﻿USE sofia;
DROP TABLE IF EXISTS sofia.zpoNT_vpl;
CREATE TABLE zpoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zpoNT_vpl WRITE;
INSERT INTO zpoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucrist ngol lo dii cheen rey David nu lo dii cheen Abraham. Lo yech ne mkee na re dii cheen re xey Jesús: ");
INSERT INTO zpoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ngok xuz Chak, Chak ngok xuz Kob, Kob ngok xuz Judá, kwaan re wech xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ngok xuz Fares nu Zara, nu xnaa xaa ngok Tamar. Fares ngok xuz Esrom, Esrom ngok xuz Aram. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ngok xuz Aminadab, Aminadab ngok xuz Naasón, Naasón ngok xuz Salmón. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ngok xuz Booz, nu xnaa xaa ngok Rahab. Booz ngok xuz Obed, nu xnaa xaa ngok Rut. Obed ngok xuz Isaí. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ngok xuz rey David, rey David ngok xuz Salomón, nu xnaa xaa ngok sa Urías. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ngok xuz Roboam, Roboam ngok xuz Abías, Abías ngok xuz Asa. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ngok xuz Josafat, Josafat ngok xuz Joram, Joram ngok xuz Uzías. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías ngok xuz Jotam, Jotam ngok xuz Acaz, Acaz ngok xuz Ezequías. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ngok xuz Manasés, Manasés ngok xuz Amón, Amón ngok xuz Josías. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías ngok xuz Jeconías kwaan re wech xaa, mbanaka Josías leezha mloo xaa Babilonia re xey be, xaa Israel, xkyizhyo xaa nu mbe xaa xaa axta yizhyo Babilonia. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Leezha ngulo mloo re xaa Babilonia re xey be xkyizhyo xaa: Jeconías ngok xuz Salatiel, Salatiel ngok xuz Zorobabel. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ngok xuz Abiud, Abiud ngok xuz Eliaquim, Eliaquim ngok xuz Azor. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ngok xuz Sadoc, Sadoc ngok xuz Aquim, Aquim ngok xuz Eliud. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ngok xuz Eleazar, Eleazar ngok xuz Matán, Matán ngok xuz Kob. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Kob ngok xuz Che sa Mari, nu lee me nak xnaa Jesús, Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Snee tub chida dii ngu axta Abraham nu axta rey David, nu rey David axta leezha mnabeyy Babilonia re xey be stub chida dii, nu leezha mnabeyy Babilonia axta mzhin Xaa Mxaal Dios Nabeyy, stub chida dii. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Snee ngol Jesús: nakladiizh ka Che Mari; per gorna zeraka chelya rop xaa me, nu zeraka zhaal rop xaa, lee Mari mbeyyxiin kwent cheen Mbi Naban cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zee Che mle xgab laa xaa me xlaan, nel nak xaa tub xaa nali, nu nel nanzheklat xaa laa xaa me delant lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ngulo mle xaa xgab le xaa sbaa, zee ngunii tub mandad cheen Xaa Nabeyy lo xaa lo tub mkaal, nu nzhé lo xaa: —Che, lu nak xaa dii cheen rey David, nazhebt lu chelya lu Mari, nel mbeyyxiin me kwent cheen Mbi Naban. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mari kano tub xgann nu kole lu mad Jesús, sbaa role mad nel lee mad koo re xaa xaa lo yalgut cheen jwalt cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Rese kwaane ngok zee mbarlo re kwaan nzhé Xaa Nabeyy lo xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo: ");
INSERT INTO zpoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Lee tub ngwnaa, me zer chaal kwaan tub xaabyi, weyyxiin me nu zan me tub xgann me, xaa role Emanuel, (wdizh ne nii: “Dios nzo kwaan be”). Is. 7:14 ");
INSERT INTO zpoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Gorna mroo mkaal lo Che, mle xaa kwaan nzhé mandad cheen Xaa Nabeyy lo xaa, nu mchelya xaa Mari. ");
INSERT INTO zpoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Per namchaalt xaa me axta gorna ngol xinn me. Nu mlole Che mad Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Gorna ngol Jesús yezh Belén pa nabeyy Judea, re mbizh leezha mnabeyy rey Herod, zee lee re xaa mseed cheen mbal yiba mzhin Jerusalén. Xaa ba nze naz pa nlen mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nu mnabdizh xaa: —¿Pa nzho Rey cheen re xaa Israel, mad ngol nal? Nel ngune nu lo mbal cheen mad leezha mzo nu xkyizhyo nu, naz pa nlen mbizh, zee nze nu gool nu lo mad. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nu gorna mbin rey Herod kwaane nawent ngok lextoo xaa, nu noka re xaa Jerusalén mle doo xaa xgab. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mrezh Herod re ngwleyy non nu re maestr xaa nlu xtizh Dios, zee mnabdizh xaa nen paro gal Xaa Xaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Re xaa nzhé: —Gal xaa Belén pa nabeyy Judea; nel sbaa mkee xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo: ");
INSERT INTO zpoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén pa nabeyy Judea nak tub yezh non doo; nixa naka tub yezh chut, loya roo tub xaa nabeyy lo re yezh Israel, tub xaa kanap re xaa na, mod tub xaa wen nkanap mbakxiil. Mi. 5:2 ");
INSERT INTO zpoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Zee xlaan mrezh Herod re xaa mseed cheen mbal yiba, nu mnabdizh xaa lo xaa nen cho gor mlu mbal lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Zee mxaal xaa re xaa Belén, nu nzhé xaa lo re xaa: —Gwa gu, gwakwaan gu madoo, nu gorna yizhal mad lo gu, zee yaad gu nu né guya lo na zee noka na yiyoll lo mad. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Gorna ngulo mbin re xaa mseed cheen mbal yiba kwaan nzhé rey lo xaa zee nzha re xaa. Gorna ngune xaa lo mbal nyakdoola xaa. Nu lee mbal kwaan mlu lo xaa nzha delant lo re xaa axta ngulo mzhin re xaa pa nzho mad, nu naz baa mlaz mbal. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Zee mzeeb xaa leen yoo, nu ngune xaa lo madoo kwaan Mari, xnaa mad. Nu mkichxub xaa nu mbill xaa lo mad, zee mxal xaa roo re kwaan nzhano xaa, nu mselazh xaa or, nu yaal, nu anseyt kwaan nak cheen yag mirra kwaan chul nzebech lo mad. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Gwluzh Dios ngunii lo re xaa mseed cheen mbal yiba lo mkaal zee nabaret xaa naz pa nzho Herod, nu mbare xaa lazh xaa stub naz. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Gorna lee re xaa mseed lo mbal yiba nya, lee tub mandad cheen Xaa Nabeyy, ngunii lo Che lo tub mkaal stub welt, nzhé lo xaa: —Guxche, nu be rop xnaa mad, nu broo zyaa naz yizhyo Egipto. Nu baa yoka lu zee, axta gorna nii naya, nel lee rey Herod kwaan mad gut xaa mad. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Che nguxche, leeka gor yaal zee, nu mbe xaa rop xnaa mad nya xaa naz Egipto, ");
INSERT INTO zpoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","pa ngu xaa axta ngut Herod. Kwaane mded zee mbarlo kwaan nzhé Xaa Nabeyy lo xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo: “Axta yizhyo Egipto mrezh na xgaan na”. Os. 11:1 ");
INSERT INTO zpoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Gorna lee Herod ngune lee re xaa mseed cheen mbal yiba mkade, nu nambaret xaa naz lo Herod, zee mrixyan doo Herod. Kwaanzee mxaal xaa soldad yezh Belén nu re rench, zee gut xaa rese madoo, madbyi, mad neta chop liin, modxa nzhé re xaa nseed cheen mbal yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sbaa mbarlo re kwaan mkee Jeremías, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo: ");
INSERT INTO zpoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Mbin xaa tub bi yezh Ramá tub bi cheen yalne nu cheen xgab gro doo, nel Raquel nzho bel kwent cheen re xinn me, nu nanzheklat me seleyy xaa me, nel ngulola ngut re xinn me. Jer. 31:15 ");
INSERT INTO zpoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Per gwluzh ngulo ngut Herod, lee tub mandad cheen Xaa Nabeyy ngwa lo Che naz Egipto, nu ngunii xaa lo xaa lo mkaal, nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Guxche, nu be rop xnaa mad, nu bare naz yizhyo Israel, nel ngulola ngut re xaa nzhekla gut mad. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Zee lee Che nguxche mbe rop xnaa mad, nya naz xkyizhyo be. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Per gorna mbin Che lee Arquelao nabeyy Judea nu lee xaa nak xinn Herod, zee mzheb xaa nya xaa baa. Nu Dios ngunii lo xaa lo mkaal, zee nya xaa yizhyo Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Gorna mzhin xaa zee, nya xaa ngu xaa tub yezh kwaan le Nazaret. Nu kwaane ngok zee mbarlo kwaan nzhé xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo: “Lee Jesús role Xaa Nazaret”. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Re mbizh zee lee Juan Xaa Nchubnis re myet, mbid mzaa kwent cheen Dios naz wen cheen Judea. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nu nzhé xaa: —¡Blaa gu naletra gu kwaan nawent nu wii gu lo Dios nel mbizh kwaan nabeyy Dios mzhin gaxla! ");
INSERT INTO zpoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan nak xaa mzaa Chay kwent leezha nzhé xaa: Tub xaa nzho naz wen nii dublegan: “Bdexkwaa gu xnaz Xaa Nabeyy; bxal gu tub naz nali ze xaa”. Is. 40:3 ");
INSERT INTO zpoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nu xab Juan nak yichled kamey, nu nzii tub yed lextoo Juan. Nu lee kwaan nzhaw Juan nak mbeso nu kwaan nzho Juan nak mzhin wen. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Re myet xaa Jerusalén, nu re myet xaa re yezh cheen Judea, nu re myet xaa nzho dub welt roo yuu Jordán, ngwa nguyon kwaan mzaa Juan kwent. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ngunii xaa lo Juan re jwalt cheen xaa kwaan mle xaa, zee mchubnis Juan xaa leen yuu Jordán. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Per gorna ngune Juan zyen doo xaa fariseo nu xaa saduceo nzha rubnis, zee nzhé Juan lo re xaa ba: —¡Gu nak mod dii cheen mball wiz! ¿Cho né lo re gu xonn gu lo yalnayii kwaan né Dios yaad? ");
INSERT INTO zpoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Blu gu mod xaa mlaa naz nawent kwaan nzha gu nu wlipa wii gu lo Dios, kwaan gak mod xle cheen tub yag. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nu natot gu yalxwa nu yé gu: “Lee be nak dii cheen Abraham”; nel wlipa na nii na lo gu, Dios nzho mod le axta noka re ke ne gaka dii cheen Abraham. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Lee yibyag nzobla cho lox re yag kwaan nanzaat xle wen, zee choog xaaya nu koo xaaya lo ki. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wlipa na nii na, na nchubnis re gu kwaan nis zee laa gu kwaan nawent kwaan kale gu nu wii gu lo Dios, per lee tich na nze stub xaa chubnis re gu kwaan Mbi Naban nu kwaan ki. Lee xaa nonra lo na, kwaanzee nanzhaalt xek na tich xkyelyed xaa, nel nanont na. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nzho garot yaa xaa koo paj lo nzhobxtil, nu kozhaw xaa nzhobxtil pa ngozhaw xaa re xob xaa, nu lee paj cheen nzhobxtil zek xaa lo ki kwaan tira nanyuyyt. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús ngwa roo yuu Jordán yizhyo cheen Galilea pa nzo Juan kachubnis re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Per Juan nanzheklat chubnis Jesús zee nzhé Juan lo xaa: —Na nzhaal rubnis lo lu, ¿chozhiin leel lu nze lo na? ");
INSERT INTO zpoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús mkeb nzhé: —Nkin chubnis lu na, nel be nkin le kwaan né Dios. Juan mbin wdizh ne nu mchubnis xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nu leeka gorna ngulo mrubnis Jesús, lee yiba mxal nu myun Mbi Naban cheen Dios lo Jesús nyaadla naz leen yiba mod tub palom. ");
INSERT INTO zpoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Zee mbin xaa tub bos kwaan nze naz yiba kwaan nzhé: —Xaa ne nak xgaan na, xaa nkedoola na, xaa nyakdoo lextoo na wii na lo. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Zee lee Mbi Naban mbe Jesús naz wen pa kiil Maxuu xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nu mkwan xaa tub choo mbizh nu tub choo yaal, gorna nandawt xaa nik tik kwaan, zeera ngok nlaan xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nu lee Maxuu mbii gax lo Jesús zee kiil Maxuu Jesús, nu nzhé Maxuu: —Chelee lu wlipa lu nak lu Xgann Dios guzh lu lo re ke ne zee gaka pan. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Per Jesús mkeb nzhé: —Lo Xkyech Dios nkee: “Nanebt pan nle zee mban re myet, nel noka re wdizh kwaan nroo roo Dios nle zee mban re myet”. Dt. 8:3 ");
INSERT INTO zpoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Zee lee Maxuu mbe Jesús naz leen yezh Jerusalén, yezh kwaan nambey nak, nu mtexoob Maxuu Jesús yek yidoo pa mas ya nzeb, ");
INSERT INTO zpoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nu nzhé Maxuu lo xaa: —Chelee lu wlipa lu nak lu Xgann Dios, brenzeb naz xan naz lo yo; nel nkeela lo Xkyech Dios nzhé: “Dios xaal mandad cheen xaa zee zenyaa xaa lu, zee nalat nii lu lo ke”. Sal. 91:11 ");
INSERT INTO zpoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús mkeb nzhé: —Noka nkee lo Xkyech Dios nzhé: “Nanzhaalt kiil lu Xdios lu, Xaa Nabeyy lo lu”. Dt. 6:16 ");
INSERT INTO zpoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Zee lee Maxuu mbe Jesús yek tub yi kwaan ya doo nzeb, nu mlu Maxuu rese yezh kwaan nzhi lo yizhyo lo Jesús, nu xomod chul doo nzhaka. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nu nzhé Maxuu: —Na za rese kwaane ka lu chelee lu kichxub lu lo na nu gool lu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús mkeb nzhé: —Bachii lo na Maxuu, nel lo Xkyech Dios nkee: “Nzhaal gool lu nebse lo Xdios lu Xaa Nabeyy lo lu, nu nebse lo lee xaa nzhaal kee lu zhiin”. Dt. 6:13 ");
INSERT INTO zpoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Zee lee Maxuu mlaa Jesús, zee lee lak mandad cheen Dios mzhin lo xaa kanap xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Gorna lee Jesús mbin lee Juan nzho lozhyib, nya xaa naz yizhyo Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nu mded xaa yezh Nazaret, zee nya xaa ngu xaa naz yezh Capernaum, roo nistoo kwaan nak yizhyo cheen re dii cheen Zabulón nu Neftalí. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kwaane ngok zee mbarlo kwaan nzhé Chay, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo: ");
INSERT INTO zpoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Yizhyo cheen Zabulón nu cheen Neftalí, kwaan nzhi stub lad roo yuu Jordán, roo wri nistoo, kwaan nak yizhyo Galilea pa nzho re xaa nanakt xaa Israel, ");
INSERT INTO zpoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","re xaa nzho naz ba nzo xaa lo yalnakaw, per ngune xaa lo tub xni gro doo, nu noka nzho re xaa xan xkal cheen yalgut, per mlu tub xni lo xaa. Is. 9:1-2 ");
INSERT INTO zpoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Gorzee lee Jesús mzelo mzaa kwent cheen wdizh chul nu nzhé xaa: —Blaa gu naletra gu re kwaan nawent nu wii gu lo Dios, nel mzhin gaxla mbizh gorna nabeyy Dios lo rese myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gorna nzhaze Jesús roo nistoo cheen Galilea, zee ngune xaa lo rop wech Simón (nu stub le xaa nak Pér) nu Ndres. Rop xaa ne nak xaa nzen mbal, nu kagobi xaa xkyeez xaa leen nis. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús nzhé lo rop xaa: —Breke rop gu tich na, zee le na gu xaa zere myet lo Dios, kwentaxa nzen gu mbal. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Gorzee mlaa rop xaa xkyeez xaa nu nzhake xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Xepse mze Jesús naz delant, zee ngune xaa lo Chag nu Juan xgann Zebedeo, nzho yon xuz xaa leen kano kagobde xaa xkyeez xaa. Nu Jesús mrezh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nu leeka gorzee mlaa xaa xuz xaa leen kano nu mreke xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús mded rese yezh Galilea nu mseed xaa rese xaa, re pa nkasa be nseed be xtizh Dios, nu mzaa xaa kwent wdizh chul cheen pa nabeyy Dios, nu msekwen xaa re xaa nzak reta klas yalyizh nu reta klas yalne. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nu dubse yizhyo cheen Siria mbin xaa re kwaan mle Jesús, zee nyiidno xaa re xaa nzak yalyizh nu re xaa nzak yalne, xaa nzho mbi mal lextoo, xaa nzhak naxen, xaa mdeen, zee sekwen Jesús re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Zyen doo myet mreke tich Jesús, re xaa nze naz Galilea, re xaa nze naz chii yezh kwaan le Decápolis, re xaa nze naz Jerusalén, nu re xaa nze naz yizhyo cheen Judea, nu re xaa yezh kwaan nzhi stub lad roo yuu Jordán. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nu gorna ngune Jesús lee re myet nzhake tich xaa, zee nguxoob yi nu mzob xaa, zee lee re xaa mseed lo Jesús mbii gax lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Zee lee Jesús mzelo mseed re xaa nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Wen re gu, xaa nzeen nkin Dios, nel lee pa nabeyy Dios gak xcheen re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Wen re gu, xaa nzhonn nal, nel Dios seleyy re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Wen re gu, xaa nadoo nak lextoo, nel lee re gu kayaa yizhyo kwaan zaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Wen re gu, xaa nak mod tub xaa nlaan nu nzhek lextoo nle kwaan nali, nel Dios zle yudar gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Wen re gu, xaa nlesla ne wechxinn, nel Dios lesla ne re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Wen re gu, xaa ngok nzhul lextoo, nel re gu ne lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Wen re gu, xaa nkwaan ne xomod kwi wen re wechxinn, nel lee Dios né: “Re gu nak xiin na”. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Wen re gu, xaa mded bid nel nle gu kwaan nali kwaan né Dios, nel lee pa nabeyy Dios gak xcheen re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Wen re gu, leezha nii nawent re myet lo gu, leezha nrenal xaa gu, leezha ngaazh xaa re kwaan namlet gu tich gu, nel ngwii gu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Byakdoola gu, nu nix doo gok lextoo gu, nel lee re gu le gan tub kwaan gro doo naz leen yiba, nel sbaaka mnayii re xaa ngune re xaa yilo, xaa mzaa kwent kwaan nzhé Dios lo lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Re gu nak mod zed lo yizhyo ne, per chelee zed nagaknzhigt, nyent mod gaknzhiga stub welt. Naletra sirb zee kobi xaaya naz leen naz pa nded re myet zee taazh nii re myet ticha. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Re gu nak mod xni lo yizhyo ne. Lee tub yezh kwaan nzhi axta yek tub yi nyent mod le xaa zee nayunta. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nixa nakeet xaa yek tub bruj nu koo xaaya leen tub chekwid, sinka nzob xaaya tub pa ya nzeb zee zaaya xni lo rese xaa nzho leen yoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sbaaka re gu nkwaan gu mod ne xomod zaa gu xni lo re myet, zee wii re myet re kwaan wen nle gu, zee noka re xaa gool lo Xuz be, xaa nzob naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Nalet re gu xgab lee na nzhal lux ley, nu nzhal na lux na re kwaan mlu re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo; nanzhalt na lux naya, lee na nzhal le re kwaan nkee lo ley zee gak re kwaan mzaa re xaa kwent, kwaan nzhé Dios lo re xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Wlipa na nii na, gorna lee yizhyo nu yiba nzhika, nik tub letr nu nik tub punt nazhet lo ley, axta gorna yilo gak rese kwaan nzhéya. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kwaanzee rese xaa che tub re kwaan nzhé ley nixa nzak xaa naka tub kwaan nanont, nu see lu xaaya lo re stub naz re myet, re xaa zee nak xaa mas chut pa nabeyy Dios; per lee xaa kwaan nle kwaan nzhé ley nu seeka nlu xaaya lo re stub naz re myet, xaa zee nak tub xaa mas non pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nel wli na nii na lo re gu, nzhaal zo nalira gu lo Dios mod nzo re xaa fariseo nu re maestr, xaa nlu xtizh Dios, chelee gu nzhekla gu zeeb gu pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Re be mbin kwaan nzhé re xey be xaa yilo leezha né xaa: “Naguta lu, nel re xaa nzhut naab jwes kwent lo xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per lee na nii: Loka cho xaa kwaan yii lo wechxinn noka naab jwes kwent lo xaa, nu loka xaa yé lo wechxinn “Xaa ned” noka naab re xaa nak zhiin kwent lo xaa, nu loka xaa yé lo wechxinn “Bxen” nya xaa lo ki kwaan tira nanyuyyt. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Kwaanzee chelee lu nzhazaala lu gon cheen lu lo Dios, nu mselazh lu lee wechxinn lu nayii ne lu, ");
INSERT INTO zpoNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","laaka lu gon cheen lu baa, nu gwa zee bri wen rop wechxinn gu, zeera bare lu zaa lu gon cheen lu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Chelee tub xaa nayii ne lu nu nzhekla xaa kwezh xaa lu lo xaa nak zhiin, mas wen kwaan mod zee kwi wen rop gu xaa, nel chelee xaa ya xaa lo xaa nak zhiin zee gaazh xaa tub kwaan tich lu, zee napa kazaa xaa nak zhiin lu lo xaa nkanap roo lozhyib zee napa kago xaa lu lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Wlipa na nii na, naroot lu baa chelee lu nakixt lu axta paro nzhaal kix lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Re be mbin kwaan nzhé re xey be xaa yilo, leezha né xaa: “Nanzhaalt chaal lu stub ngwnaa”. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per lee na nii: Loka xaa kwaan wii lo tub ngwnaa nu le xaa xgab chaal xaa me, ngulola mchaal xaa me naz leen lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Seeka chelee zaalo lu lad li nle zee nle lu kwaan nawent, blooya nu blabiya zit lo lu, nel mas wen lux lu tub lad zaalo lu ke nya dub lu lo ki. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nu seeka chelee yaa lu lad li nle zee nle lu kwaan nawent, chooga nu blabiya zit lo lu, nel mas wen lux lu tub lad yaa lu, ke nya dub lu lo ki. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Re be mbin kwaan nzhé re xey be xaa yilo leezha né xaa: “Loka xaa nlaa xngwnaa, nzhaal zaa xaa tub yech kwaan nzhé lee xaa nawiitra lo me”. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per lee na nii: Chelee tub xaabyi laa xngwnaa nu nanakta nel mchaal me stub xaabyi, lee xaa nle zee kano xngwnaa xaa tub jwalt gorna ka me stub xaabyi, nu noka xaabyi kwaan ka me le jwalt. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Re be mbin kwaan nzhé re xey be xaa yilo leezha né xaa: “Ble re kwaan nzhé lu kwaan ncheroo lu lo Xaa Nabeyy”. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per na nii lo gu: Nyent mod cheroo gu lo Dios, nixa nyent mod cheroo gu naz yiba, nel naz yiba nak pa nzob Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nixa nyent mod cheroo gu lo yizhyo, nel lo yizhyo nak pa nzo nii Dios, nixa nyent mod cheroo gu lo yezh Jerusalén, nel yezh ne nak cheen Rey, xaa non doo. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nu nixa nyent mod cheroo gu naz yek gu, nel nyent mod le gu na rus yich yek gu o nagaas naya. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nebse yé gu: “Le naya”, o “Nalet naya”. Nu nacheroot gu nel kwaane nak tub kwaan nroo lo Maxuu. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Re be mbin kwaan nzhé re xey be xaa yilo leezha né xaa: “Chelee tub xaa kich zaalo stub xaa, noka zaalo xaa zee yech. Nu chelee tub xaa kiib leyy stub xaa, noka leyy xaa zee yiib.” ");
INSERT INTO zpoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per lee na nii: Chelee tub xaa nzhekla le tub kwaan nawent lo gu, laa gu le xaaya. Mas wen chelee tub xaa gazya tagarlo gu noka bzaa gu stub lad gazya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chelee tub xaa nzhekla wee gu lo xaa nak zhiin zee kiib xaa xkamis gu, mas wen noka xchamar gu bzaa gu lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Chelee tub soldad né lo gu: “Be xcheenta tub mil metr yirol”, be guya tub chon mil metr. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chelee tub xaa naab kwaan lo gu, zaa guya lo xaa, nu nyent mod yé gu lo xaa: “Nazaat naya”. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Re be mbin kwaan nzhé re xey be xaa yilo leezha né xaa: “Kela lu xaa nyenn lu, nu byii ne xaa nayii ne lu”. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per lee na nii: Kela gu re xaa nayii ne gu, nu gunaab gu gak kwaan wen lo re xaa mxobde lo gu, noka gunaab gu lo Dios kwent cheen re xaa nrenal gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Zee sbaa gak gu xinn Dios xaa nzob naz yiba, nel lee xaa nle zee nlen mbizh lo re xaa wen nu lo re xaa nakap nak, nu noka nsela xaa yey lo re xaa wen nu lo re xaa nakap nak. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nel chelee gu kela gu nebse xaa nkela gu, ¿xana kwaan wen le gu gan? Nu axta re xaa ntop demi kwaan nya naz Roma snee nle. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nu chelee gu nebse lo re wech gu nii gu “dix”, ¿xana kwaan wen kale gu? Noka re xaa nanakt xaa Israel sbaa nle. ");
INSERT INTO zpoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kwaanzee nzhaal gak nali gu mod nali nak Xuz be, xaa nzob naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Nalet gu kwaan wen zee nebse wii re myet lo gu; chelee gu sbaa le gu, lee Xuz be, xaa nzob naz yiba, nik tub kwaan nazaat xaa lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Kwaanzee nii na lo gu, gorna zaa gu tub kwaan lo tub xaa nkin kwaan, nayét gu lo rese xaa: “Wii gu lo na, lee na zaa kwaan kin xaa ne”, snee nle re xaa nkade nu nanlet kwaan wen. Nel sbaa nle re xaa ne, pa nkasa be nseed be xtizh Dios, nu noka nle xaaya leen naz, zee nii wen re myet lo xaa. Wlipa na nii na lo gu, nkanola re xaa ne kwaan le xaa gan. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Gorna zaa gu tub kwaan lo tub xaa nkin kwaan, nayét guya lo nik tub xaa, nixa lo xmig gu xaa nyenn gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Xlaan ble guya, zee Xuz be, xaa ne re kwaan xlaan, zaa kwaan le gu gan. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Kwaanzee nii na lo gu, gorna wdizhno gu Dios, nalet gu mod nle re xaa nkade, xaa nanlet kwaan wen. Re xaa ne nzhedizhno Dios pa nseed re be xtizh Dios nu noka nzhedizhno xaa Dios leen naz, zee wii re myet lo xaa. Wlipa na nii na lo gu, nkanola re xaa ne kwaan le xaa gan. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Per lee re gu, gorna nzhekla gu wdizhno gu Dios, bzeeb gu leen li gu nu bsaaw roo li gu nu wdizhno gu Xuz be, xaa nanlut, zee lee Xuz be xaa ne re kwaan xlaan, zaa kwaan le gu gan. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Nu gorna wdizhno gu Dios nazeret gu tub lanaka wdizh zyen doo welt, modxa nle re xaa nanakt xaa Israel. Nle xaa xgab zere xaa tub lanaka wdizh zyen doo welt zee lee Dios mas gon xtizh xaa, nzak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nagakt gu mod re xaa ne; nel Xuz be nela cho kwaan nkin gu, gorna zeeraka naab guya lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Snee nzhaal wdizhno gu Dios: Xuz na, xaa nzob naz yiba, nzhekla na wii re myet lo lu nel nambey doo lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nzhekla na yaad lu nabeyy lu lo yizhyo ne modxa nabeyy lu naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Zaa kwaan gaw na nalzhe. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bchee rese jwalt kwaan mle na, modxa myenlazh na re jwalt kwaan mle re wechxinn na lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Naleyat lu na la na lo re kwaan nawent sinka bkanap na lo Maxuu. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Per chelee gu yenlazh gu re jwalt kwaan mle re wechxinn gu lo gu, noka Xuz be xaa nzob naz yiba chee re jwalt cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Per chelee gu nayenlazht gu re jwalt kwaan mle wechxinn gu lo gu, noka Xuz be xaa nzob naz yiba, nacheet jwalt cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Kwaanzee nii na lo gu, gorna kwan gu leezha nagawt gu nik tub kwaan, nalet gu mod tub xaa nales doo nzhak, modxa nle re xaa nkade nu nanlet kwaan wen. Nales doo nle xaa zee ne re myet lee xaa kakwan. Wlipa na nii na lo gu, nkanola re xaa ne kwaan le xaa gan. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Per lee na nii, gorna kwan gu bdeeb gu garlo gu nu chul gok gu xab gu, ");
INSERT INTO zpoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","zee nanet re myet lee gu kakwan. Xlaan ble guya zee lee Xuz be xaa ne re kwaan xlaan, zaa kwaan le gu gan. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Natopt gu zyen doo kwaan lo yizhyo ne, nel nzho mod kee mbaza nu nzho mod kee chena nu nzho mod lewann xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mas wen btop gu re kwaan naz yiba, pa nyent mod kee mbaza nu pa nyent mod kee chena nu pa nyent mod lewann xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nel pa nzho re xcheen gu, baa nzo xgab cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Zaalo xaa nak mod xni kwaan nzeni lo xaa. Seeka chelee zaalo xaa wen nyani zee dubse xaa nak xni. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Per chelee zaalo xaa nanyenit zee dubse xaa nakaw na. Chelee zaalo xaa kwaan nzhaal zaa xni lo xaa nanyenit, tira lo yalnakaw na nzo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Nik tub mos nyent mod kano chop patron xaa kee xaa zhiin lo, nel yii xaa ne xaa tub xaa nu stub xaa kela xaa, nel tub xaa gon xaa xtizh nu stub xaa nagont xaa xtizh. Nyent mod kee gu zhiin lo Dios nu kee gu zhiin kwaan gu re kwaan yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Kwaanzee nii na lo re gu: Nalet gu xgab re kwaan gaw gu nu kwaan go gu zee ban gu yee, nixa nalet gu xgab xana ler gak gu yee. ¿Che nonra yalnaban cheen gu lo kwaan gaw gu, nu lo kwaan gak gu? ");
INSERT INTO zpoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bwii gu lo re mbyin ma nzebi. Nixa nanzhaant ma nu nixa nantopt ma yalgon nu nixa nangochawt ma yalgon cheen ma, per lee Xuz be xaa nzob naz leen yiba nzaa kwaan nzhaw ma. Nu nonra re gu lo re mbyin. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nixa nle doo gu xgab roo gu stub chut per nyentra mod roo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Noka nalet re gu xgab xana gak gu. Bwii gu lo re yeey, xomod nxeen yeey kwaan nzeb wen. Nankeet yeey zhiin nu nixa nangaxkwaat yeey ler. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kwaanzee nii na lo gu, nixa rey Salomón, xaa ngok duzna ler non doo, namyunt chulra xaa ke re yeey kwaan nzeb wen. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nu chelee Dios chul mle re yeey kwaan nzeb wen nalzhe, nu yee choog xaaya nu zek xaaya lo ki, telisa sbaaka zaa Dios rese kwaan chul kwaan nkin gu. ¿Chozhiin chepse ngwii gu lo xaa? ");
INSERT INTO zpoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nu sbaa nalet gu xgab yé gu: “¿Cho kwaan gaw be, nu cho kwaan go be, nu cho kwaan gak be?” ");
INSERT INTO zpoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Rese kwaane nak kwaan nle re xaa nanakt xaa sawlazh be xgab. Per lee Xuz be, xaa nzob naz yiba, nela xaa cho kwaan nkin gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Per yilotlaka kwaan gu zee nabeyy Dios rese kwaan, zeera zaa Dios rese kwaane lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kwaanzee nalet gu xgab yee, nel yizata mbizh nzho kwaan le gu xgab. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Nanaabt gu kwent lo stub xaa zee noka Dios nanaabt kwent lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nel leeka mod naab gu kwent lo stub naz xaa seeka naab Dios kwent lo gu; nel leeka medid kwaan nchiix guya kwaan nzaa gu lo stub naz xaa, leeka sbaa chiix Dios kwaan zaa xaa lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Chozhiin ngwii lu lo paj kwaan nzho mbeelo stub wechxinn lu, nu nangwiit lu lo yag kwaan nzho mbeelo lu? Nu chelee lu nanzeent lu nzho yag mbeelo lu, ");
INSERT INTO zpoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿xomod le lu ryez yé lu lo wechxinn lu: “Laa ko na paj kwaan nzho leen mbeelo lu”? ");
INSERT INTO zpoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Gu nak xaa nkade nu nanlet gu kwaan wen! Yilotlaka bloo yag kwaan nzho leen mbeelo lu, zee nzho mod wii wen lu, zee koo lu paj kwaan nzho leen mbeelo wechxinn lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Nazaat gu kwaan nambey lo mbak, nel napa lee ma kabare kayii lo gu nu kachaz ma gu. Nu nixa nazaat gu tub perla, kwaan non doo demi, lo kuch, nel nanonta lo ma zee luux maya leen ban. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Kwaanzee nii na lo gu: gunaab guya, zee lee Xaa Nabeyy zaaya lo gu; Bkwaan guya, zee yizhala lo gu; bkwezh gu roo yoo, zee lee xaa xal roo yoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nel rese xaa naaba kayaaya; nu rese xaa nkwaana, yizhala lo xaa; nu rese xaa nkwezh roo yoo, zxal xaa roo yoo lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Chelee xinn gu naab cha pan lo gu, ¿che zaa gu tub ke lo mad? Telisa nazaat guya. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nu chelee mad naab mad tub mbal lo gu, ¿che zaa gu tub mball wiz lo mad? Telisa nazaat guya. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nu chelee re gu, xaa nakap nak, nzaa gu kwaan wen lo xinn gu, ¡lee Xuz be xaa nzob naz yiba telisa mas wenra nak xaa, nu zaa xaa kwaan wen lo rese xaa naaba lo xaa! ");
INSERT INTO zpoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Mod nzhekla gu le xaa lo gu, sbaaka ble gu lo xaa; nel kwaane nak kwaan nzhé ley nu re kwaan mkee re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Zeeb gu pwert kwaan nanyag. Nel pwert kwaan naxen nu naz kwaan naxen nzhe xaa pa lux xaa. Nu zyen doo xaa nzen naz naxen ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Per lee pwert cheen naz kwaan nzhe xaa lo yalnaban kwaan tira, nanyag doo nak nu nagan doo ze xaa naz ne, kwaanzee nazyent xaa nyazhal naz ne lo. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Kanap gu gu lo re xaa nkade mbezh snee: “Na nza kwent kwaan né Dios lo na”. Nze xaa lo gu nu nlu xaa mod mbakxiil, per lextoo xaa nzhak mod lextoo lob, ma nayii. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Re gu nzho mod labeyy xaa ne lo re kwaan nle xaa, kwaan nak mod xle kwaan nzaa xaa. Nel nyent mod zaa yag yich xle kwaan nak ub, nu nixa yixnizh nyent mod zaa xle kwaan nak ig. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sbaa rese yag chul nzaa xle wen, per lee yag nawent nzaa xle nawent. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tub yag wen nyent mod zaa xle nawent, nu sbaaka tub yag nawent nyent mod zaa xle wen. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Rese yag kwaan nzaa xle nawent, choog xaaya nu koo xaaya lo ki. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Snee nzho mod labeyy gu xaa nawent, nebse wii gu cho klas xle nzaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Naret xaa kwaan né lo na: “Xaa Nabeyy, Xaa Nabeyy”, zeeb pa nabeyy Dios, sinka nebse re xaa kwaan nle kwaan nzhekla Xuz na, xaa nzob naz yiba, zeeb pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mbizh zee, zyen doo xaa yé lo na: “Xaa Nabeyy, re nu mzaa kwent kwaan né Dios lo nu, nu kwaan yalnabeyy cheen lu mloo nu mbi mal, nu kwaan yalnabeyy cheen lu mle nu zyen doo kwaan gro”. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Per zee keb na lo xaa: “¡Tira namlabeyyt na lu, bachii lo na xaa nzeb jwalt!” ");
INSERT INTO zpoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Seeka re myet, xaa nzhon xtizh na nu nle xaa kwaan nii na, nak xaa list, mod xaa mza li lo ke. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Per gorna nze yey nu ngok kwall doo nis nu mroo doo mbi, zee luuxa yoo ba, per namleta gan mtexcheya yoo ba, nel lo ke nzoba. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Per lee xaa kwaan nzhon xtizh na nu nanlet xaa kwaan nii na, xaa zee nak mod xaa mza li lo yux. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Per gorna nze yey, nu ngok kwall doo nis nu mroo doo mbi nu mtexche nis yoo, zee tira mluxa. ");
INSERT INTO zpoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Gorna ngulo ngunii Jesús re kwaane, mdedyall doo re myet xomod mseed Jesús re xaa, ");
INSERT INTO zpoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","nel nzhé xaaya kwaan yalnabeyy, nu namlet xaaya mod nle re maestr, xaa nlu xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Gorna mbare Jesús yek yi, zyen doo myet mreke tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lo re myet ba mroo tub xaa nyall cho, nu mbii xaa lo Jesús nu mkichxub xaa nu mkichyek xaa axta lo yo, zee nzhé xaa lo Jesús: —Xaa Nabeyy, chelee lu nzhekla lu nzho mod sekwen lu na lo yalyizh ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús mzhib yaa cho xaa nu nzhé lo xaa: —Nzhekla na, gakwen lu. Nu leeka gorzee ngokwen xaa lo yalyizh kwaan nyall cho xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús nzhé lo xaa: —Wii, nik tub lo nayét luya. Zyaa nu gwa lo ngwleyy nu zaa gon cheen lu modxa mnabeyy Ches, zee ne ngwleyy lee lu ngokwen lo yalyizh kwaan nzak lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Gorna nzhazeeb Jesús leen yezh Capernaum, tub xaa nabeyy lo tub gayoo soldad ngwa lo Jesús nu ngunaab xaa tub jabor lo Jesús, ");
INSERT INTO zpoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","nzhé xaa: —Xaa Nabeyy, lee xmos na xaa nkee zhiin lo na, ne doo nzak xaa nu nyent mod gun xaa nu nayetra xaa lo yalne. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús mkeb nzhé: —Yasekwen na xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Lee xaa nabeyy lo tub gayoo soldad nzhé: —Xaa Nabeyy, nalet lu xgab yé lu zeeb leen li na, nebse nabeyy zee gakwen xmos na. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nel nzho tub xaa nabeyy lo na, nu noka na nkano na soldad xaa nabeey na lo. Chelee na yé na lo tub xaa: “Gwa”, zee ya xaa; nu gorna mbezh na lo stub xaa: “Te”, zee nyiid xaa lo na; gorna mbezh na lo xmos na: “Ble kwaane”, nle xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús mdedyall doo gorna mbin xaa kwaane, nu nzhé xaa lo re xaa nzhake tich xaa: —Wlipa na nii na lo gu, ¡nik tub sawlazh be nangwiit lo Dios modxa ngwii xaabyi ne lo Dios! ");
INSERT INTO zpoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Wlipa na nii na lo gu, zyen doo xaa nzho dubse yizhyo axta paro nzhaal yizhyo kwaan yiba, zob gaw kwaan Abraham tubka kwaan xgann xaa Chak nu kwaan Kob pa nabeyy Dios, ");
INSERT INTO zpoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","per re xaa sawlazh be, xaa nzhaal zob naz yiba pa nabeyy Dios lake naz jwer lo yalnakaw, pa gonn xaa nu kozhe leyy xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Zee lee Jesús nzhé lo xaa nabeyy lo tub gayoo soldad: —Zyaa, nel ngwii lu lo Dios, zee ngokwen xmos lu. Leeka gorzee lee xmos xaa ngokwen. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús ngwa garli Pér, zee ngune xaa lee xnaazhap Pér ne nzak, nlen xlee nu naxna me lo loon. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús mzen yaa me, nu gorzee lee xlee mroo cho me. Nu nguxche me, mzaa me kwaan ndaw re xaa leeka gorzee. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gorna merla la yalchool nguno re xaa zyen doo xaa nzho mbi mal lextoo lo Jesús, nu kwaan tub lanaka wdizh ngunii Jesús ta mroo mbi mal lextoo re xaa, nu msekwen xaa zyen doo xaa ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kwaane ngok, zee mbarlo kwaan mkee Chay, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, leezha nzhé xaa: “Lee xaa wee re yalyizh cheen be nu re yalne cheen be”. Is. 53:4 ");
INSERT INTO zpoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gorna ngune Jesús dub welt lo xaa mri re myet, zee mnabeyy xaa zee deed xaa stub ta roo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Zee mbii tub maestr xaa nlu xtizh Dios, nzhé lo xaa: —Maestr, nzhekla na reke na tich lu rese pa ya lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús nzhé: —Lee re mbaz nkano ma yeer pa nzho ma, nu lee re mbyin nkano ma xlaaz ma; per lee na, Xaa Mzhin Ngok Myet, nankanot na mer li na. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Stub xaa mreke tich Jesús nzhé lo Jesús: —Xaa Nabeyy, laa nebse kach na xuz na. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús mkeb nzhé: —Reke tich na, laa kach re xaa nak mod xaa ngut re xaa ngut. Lu, gwa nu bzaa kwent cheen pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Gorna nguxoob Jesús leen tub kano, nu noka re xaa mseed lo xaa nzha kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nu gorna nzha re xaa leen nistoo mroo tub mbi dox doo leen nistoo, nu axta mzeeb nis leen kano. Per lee Jesús ngot nu tira mzen mkaal lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Zee lee re xaa mseed lo xaa mloo mkaal lo xaa, nu nzhé xaa lo xaa: —Xaa Nabeyy, nalaat lu lux be, nel nzhala xkano be leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús mkeb nzhé: —¿Chozhiin tant nzheb gu? ¿Chozhiin chepse ngwii gu lo Dios? Gorna nzhé xaa kwaane, nu mzoli xaa nu mgalno xaa mbi nu nistoo, zee zheta ngok mbi nu nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Re xaa mseed lo xaa mdedyall, nu nabdizh xaa lo wechxinn xaa: —¿Cho nak xaa ne, axta mbi nu nistoo nzhon xtizh xaa? ");
INSERT INTO zpoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gorna lee Jesús kwaan re xaa mseed lo xaa mzhin stub ta roo nistoo, yizhyo cheen yezh Gadara. Nu baa chop xaa nzho mbi mal lextoo mroo leen yeer pa nyu xaa ngut, nu mbii xaa gax lo Jesús. Nu nakap doo nzhak xaa, nu nik tub xaa nyent mod ded naz ba. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nu mbazhe xaa nu mbezh xaa: —¿Chozhiin nze lu lo nu, Jesús Xgann Dios? ¡Naab na lo lu nateed lu nu bid, nel zer zhin mbizh ted lu nu bid! ");
INSERT INTO zpoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gax zee nzhi zyen doo kuch, ma kayaw. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nu lee re mbi mal ngunaab jabor lo Jesús nu nzhé: —Chelee lu koo lu nu, laa zeeb nu lextoo re kuch ba. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús nzhé: —¡Gwa gu! Nu lee re mbi mal mroo lextoo rop xaa, nu mzeeb xaa lextoo re kuch. Nu leeka gorzee mzelo re kuch mrexonn mkato naz yat nu mla axta leen nistoo. Nu ngwep re ma nis zee tira ngut ma. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Re xaa nkano kuch mrexonn nya, nu gorna mzhin xaa yezh, mzelo xaa mzaa xaa kwent re kwaan mded, kwaan ngok lo rop xaa ngu mbi mal lextoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Zee lee rese xaa nzho yezh ngwa pa nzo Jesús. Nu gorna ngune re xaa lo Jesús, mle xaa jwers lo Jesús zee roo xaa yizhyo ba. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Gwluzh lo re kwaane, Jesús nguxoob leen tub kano nu mded xaa stub ta roo nistoo, zee mzhin xaa pa nak mod lazh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Baa mbidno re xaa tub mdeen nax lo tub yag lo Jesús. Nu lee Jesús nzhé lo mdeen: —Gok nix lextoo lu nel lee re jwalt cheen lu ngulola mzhe. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lak maestr xaa nlu xtizh Dios nle xgab: —Lee kwaan nii Jesús nak jwalt lo Dios, nel nzhekla xaa gak lal xaa kwaan Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Per nela Jesús cho xgab nle xaa, zee ngunabdizh Jesús lo xaa: —¿Chozhiin tant nawent nle gu xgab? ");
INSERT INTO zpoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Cho kwaan nzak gu? ¿Cho kwaan mas nanagant yé na lo xaa ne nzak: “Ngulola mzhe re jwalt cheen lu”, o sekwen na xaa ne nzak nu yé na lo xaa: “Guxche, bzen xkyag lu nu zyaa”? ");
INSERT INTO zpoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Le na kwaane lo gu, zee wii gu lee na nkano yalnabeyy chee re jwalt, nel na nak Xaa Mzhin Ngok Myet. Kwaanzee nzhé xaa lo mdeen: —Guxche nu bzen xkyag lu, zyaa garli lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lee mdeen nguxche nu mzen xkyag nu nya garli. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Gorna ngune re xaa kwaane, mzheb doo xaa nu mbill xaa lo Dios, nel Dios mzaa yalnabeyy lo tub myet zee sekwen xaa re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Gorna mroo Jesús baa ngune xaa lo tub xaa le Teo, xaa ne nak na. Katop na demi kwaan nya naz Roma, nu nzob na pa ntop xaa demi. Jesús né lo na: —Reke tich na. Zee nguxso na nu mreke na tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Gorna kayaw Jesús garli na, noka nzo stub naz xaa ntop demi kwaan nya naz Roma, nu stub naz re xaa nle re kwaan nawent, nu kayaw re nu kwaan Jesús, nu noka re xaa kwaan kaseed lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Gorna ngune re fariseo kwaane nzhé xaa lo re xaa kaseed lo Jesús: —¿Chozhiin nzhaw xmaestr gu kwaan re xaa ntop demi kwaan nya naz Roma nu kwaan re xaa nle kwaan nawent? ");
INSERT INTO zpoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús mbin kwaane zee nzhé xaa: —Xaa nanet nzak, nankint xaa zee doktor, per re xaa ne nzak, xaa zee nkin doktor. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Zyaa gu nu seed gu nen cho kwaan nak kwaan né Dios ne: “Kwaan nzhekla na nak blesla gu ne gu sa myet gu, nu nanzheklat na teed gu ma lo na”. Hos. 6:6 Nel nanzhalt na kwezh na re xaa wen, lee na nzhal kwezh re xaa nzeb jwalt. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lee re xaa nzhake tich Juan Xaa Nchubnis, mbii lo Jesús nu nzhé: —Re nu, nu re fariseo nkwan gorna nanzhawt nu nik tik kwaan. ¿Chozhiin lee re xaa kaseed lo lu nankwant? ");
INSERT INTO zpoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús mkeb nzhé: —Ble gu xgab kwaane. Nyent mod le gu zee kwan re xaa nzho tub jondang zee nagawt xaa, gorna lee xaa kachelya nzoka lo re xaa. Per zhin tub mbizh wee xaa xaa kwaan kachelya, nu gorna zhin mbizh ba, zeesi lee re xaa nzhaal kwan. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Nik tub xaa nakobdet tub lee ler kub cho tub lee ler gox, nel lee ler kub ndop zee chaza ler gox, zee nyentra mod le xchiina. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nu nixa nangot xaa xis ub kwaan kub leen mbud yed gox, nel lee xis ub kwaan kub gorna yixooba chaza mbud gox. Lee xis ub kwaan ngu leena xo lo yo, nu noka mbud lux. Kwaanzee nzhaal yo xis ub kwaan kub leen tub mbud yed kub. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Gorna lee Jesús kanii lee tub xaa mzhin lo xaa, xaa ne nak tub xaa nabeyy pa nkasa be nseed be xtizh Dios, nu mkichxub xaa lo Jesús nu nzhé xaa: —Lee xchap na ngulola ngut. Per chelee lu yiid lu zhib lu yaa lu yek mad, zroban mad stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Zee lee Jesús nu re nu, xaa mseed lo xaa, mzoli nu mreke nu tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Zee lee tub ngwnaa, me nzhala tub chiibchop liin nded ren lextoo mbii tich Jesús, nu mgal me cho xab Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nel mle me xgab: “Chelee na nebse gal na cho xab xaa gakwen na”. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Per lee Jesús myek zee ngune xaa lo me, nu nzhé xaa: —Xchap na. Gok nix lextoo lu, nel mwii lu lo Dios, zee ngokwen lu. Nu leeka gorzee ngokwen me. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Gorna lee Jesús mzhin garli xaa nabeyy pa nkasa be nseed be xtizh Dios, nu ngune xaa lee re musk kayoll paro nzhi re xaa kayonn doo nu mbazhe, pa nax mad ngut. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Zee nzhé Jesús: —Broo re gu nee, nel nanguta mad, nebse naxna mad. Nu lee re myet mxizhno Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Per gorna mloo xaa re myet leen yoo, zee mzeb xaa nu mzen xaa yaa mad, nu lee mad mroban nu mzoli mad. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nu dubse yizhyo ba mbin re xaa kwaan mle Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Gorna mroo Jesús baa, chop syeg mreke tich xaa, nzhé lo xaa: —¡Xaa dii cheen David, blesla lu ne lu nu! ");
INSERT INTO zpoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Gorna lee Jesús mzeeb leen yoo, lee rop syeg mbii gax lo xaa, zee lee Jesús mnabdizh nzhé lo xaa: —¿Che nle gu xgab nzho mod le na kwaane? —Xaa Nabeyy, nzho mod le luya —nzhé xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Zee lee Jesús mgal zaalo xaa, nu nzhé: —Nel ngwii gu lo Dios, zee gakwen gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nu gorzee nguni zaalo xaa, zee nzhé Jesús lo xaa: —Nik tub lo nayét guya. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nu pensa mroo rop xaa, mzelo xaa mzaa xaa kwent kwaan mle Jesús xaa, lo xaa dubse yizhyo ba. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Gorna lee rop syeg mroo lo Jesús, zee nze re xaa nzeno tub xaa nzho mbi mal lextoo lo Jesús. Xaa ne nyent mod wdizh. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nu gorna mroo mbi mal lextoo xaa muud gorzee mzelo xaa mdizh xaa. Lee re myet mdedyall nu nzhé: —¡Nik tub welt nanet be tub kwaan snee lo re xaa lazh be! ");
INSERT INTO zpoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per lee re fariseo nzhé: —Maxuu mzaa diizh zee ngoo xaa ne mbi mal, nel Maxuu nak xaa nabeyy lo rese mbi mal. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús mded rese yezh nu rese rench nu mseed xaa rese myet reta pa, nu mzaa xaa kwent cheen wdizh chul pa nabeyy Dios, nu msekwen xaa rese yalyizh nu rese yalne. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Gorna ngune xaa lo re myet, mlesla xaa ne xaa re xaa, nel tant nales nzhak re myet, mod mbakxiil, ma nyent cho nkanap. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Zee né xaa lo re nu, xaa mseed lo xaa: —Wlipa na nii na lo gu, nzho doo xchiin Xaa Nabeyy per lee xaa nkee zhiin nazyent. ");
INSERT INTO zpoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kwaanzee naab gu lo Xaa Nabeyy, zee xaal xaa masra xaa kee zhiin zee top xaa xkyalgon xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús mrezh chiibchop nu, xaa mseed lo xaa, nu mzaa xaa yalnabeyy lo nu zee koo nu re mbi mal nu sekwen nu rete klas yalyizh nu rete klas yalne. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Snee le re chiibchop nu, xaa mkayaa yalnabeyy lo Jesús: Simón (xaa noka le Pér), Ndres (wech Pér), Chag, Juan (wech xaa, rop xaa ne nak xgann Zebedeo), ");
INSERT INTO zpoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Lip, Tol, Max, Teo (xaa nak na, mtop na demi kwaan nya naz Roma), Chag (xgann Alfeo), Tadeo, ");
INSERT INTO zpoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón (xaa nkedoola lazh), Judas Iscariote (xaa mzaa Jesús lo re xaa gut xaa). ");
INSERT INTO zpoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús mxaal chiibchop nu, nu mnabeyy xaa nu, nu né xaa lo re nu: —Nayat gu yizhyo cheen re xaa nanakt xaa sawlazh be, nixa re yezh cheen xaa Samaria. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gwa gu lo re sawlazh be, xaa Israel, xaa nak kwenta mbakxiil, ma mzowen. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gwa gu guzh gu lee mbizh kwaan nabeyy Dios mzhin gaxla. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bsekwen gu re xaa ne nzak, seban gu re xaa ngut, bsekwen gu re xaa nyall cho, nu bloo gu re mbi mal lextoo re xaa nzho mbi mal. Re gu sbaasa mkayaa re yalnabeyy ne, nu nanaabt gu demi lo re xaa pa le gu kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Nik tub gaay naweet gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nixa naweet gu stub naz ler kwaan gak gu, nixa naweet gu stub naz yelyed kwaan kee nii gu, nixa garrot kwaan yo yaa gu, nixa yex kwaan yo re xcheen gu leen, nel xaa nkee gu zhiin lo, nzhaal kix ka gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Gorna zhin gu tub yezh o tub rench, kwaan gu garli tub xaa wen nak, xaa nzhekla kwaz gu garli xaa, nu kwaz gu baa axta gorna roo gu yezh ba. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gorna zeeb gu leen tub yoo zen gu yaa xaa nzho leen yoo nu nii gu wdizh wen lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Zee nel chelee xaa nzho leen yoo nzhaal kayaa re wdizh wen kwaan nii gu lo xaa lakeya lo xaa, per chelee xaa nanzhaalt kayaa xaaya, nalaket wdizh wen lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nu chelee xaa nakayaat xaa gu, nixa nagont xaa kwaan yé gu, broo gu yoo ba o yezh ba. Nu brib gu nii gu baa, zee gab yide ba, sbaa zaa gu kwent lee xaa yezh ba namkayaat gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Wlipa na nii na lo gu, leezha naab Dios kwent lo re myet, lee bid cheen re xaa yezh ba gak mas nakap ke bid kwaan ded re xaa rop yezh le Sodoma nu Gomorra. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Wii re gu! Na xaal re gu mod mbakxiil lo re lob, kwaanzee list gok gu mod mball wiz nu gok nadoo gu mod tub palom. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","List bzo gu lo re myet napaka yalaa xaa gu lo re xaa nak zhiin, nu zaa xaaya yenn gu pa nkasa be nseed be xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nu wee xaa gu lo re xaa nabeyy nu lo re rey, nel nzaa gu kwent xtizh na, sbaa nzho mod zaa gu kwent cheen na lo re xaa nabeyy nu lo re xaa nanakt sawlazh be. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Per gorna yilaa xaa gu lo xaa nak zhiin, nalet gu xgab cho kwaan keb gu lo xaa, nel leeka gorzee zaa Dios wdizh keb gu lo xaa, ");
INSERT INTO zpoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","nel nalet gu nii, sinka Mbi Naban cheen Xuz be nii naz leen lextoo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Nu leeka wech xaa yilaa wech xaa lo re xaa gut wech xaa, nu sbaaka le xuz xaa lo xinn xaa. Nu re xinn xaa yii ne xuz xaa nu xnaa xaa, nu zaa xaa xaa lo re xaa nzhekla gut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nu yii re xaa ne gu nel nak gu xaa na. Per lee xaa ye ded re kwaane axta gwluzhtlaka, xaa ba le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Per gorna cheldil xaa gu tub yezh, brexonn gu nu zyaa gu stub yezh. Nel wlipa na nii, nanalet gu gan ya gu dub yezh cheen be, axta gorna bare na, Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Nik tub xaa nseed nonra lo xmaestr, nu nik tub xaa nkee zhiin nonra lo xaa nkee xaa zhiin lo. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nik tub xaa nseed nyent mod gakra lo xmaestr xaa, nu nik tub xaa nkee zhiin nyent mod gakra lo xaa nkee xaa zhiin. Chelee nii re xaa lo ngwzan xaa nabeyy yoo: “Lu nak Beelzebú, xaa nak mer Maxuu”, noka re xinn xaa, xaa nzho yoo nii re xaa lo sbaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Kwaanzee nazhebt gu ne gu re myet. Nel mod nii xaa: “Nik tub kwaan xlaan nyent mod nalut, nixa tub kwaan nzholaan nyent mod nanet re xaa loya”. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kwaan ngunii na lo gu yaal, guzh guya lo re xaa gorna nla xni mbizh; kwaan ngunii na lo gu xlaan, bzo gu axta yek yoo nu guzh guya lo re xaa dublegan. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nazhebt gu ne gu xaa nzhut myet nel nyent mod gut xaa mer yalnaban cheen gu. Bzheb gu ne gu Dios, nel lee xaa nzho mod gut kwerp cheen gu nu yalnaban cheen gu pa nzho ki kwaan nanyuyyt. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Wii, nto xaa chop myaa kwaan tubka rel. Per na nii lo gu, nik tub myaa nalat naz yizhyo chelee Xuz be, xaa nzob naz yiba, nazaat diizh. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Per lee re gu axta re yich yek gu nak kwent lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nu kwaanzee nazhebt gu nel nonra gu lo zyen doo myaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Chelee tub xaa yé lo re myet lee xaa nak xaa na, noka na yé naya lo Xuz na, xaa nzob naz yiba lee xaa nak xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Per lee xaa yé lo re myet lee xaa nanakt xaa na, noka na yé naya lo Xuz na, xaa nzob naz yiba lee xaa nanakt xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Nalet gu xgab lee na nzhal zee kwi wen re xaa yizhyo ne. Nanzhalt na zee gaka sbaa, sinka lee na nzeno tub spad kwaan le zee dil re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Lee na nzhal zob dil tub xaabyi kwaan xuz xaa, nu tub madnaa kwaan xnaa mad, nu xiz me kwaan xnaaye me. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Leeka re sawlizh xaa yii ne xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Nu loka xaa mas nkela xuz nu xnaa, nanzhaalt gak xaa zee xaa na, nu loka xaa mas nkela xgann nu xchap, nanzhaalt gak xaa zee xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nu loka xaa nanreket tich na nu naweet xaa xkrus xaa mod we naya, nanzhaalt gak xaa zee xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Xaa kwaan tira nanzheklat yet lo yizhyo ne telisa yet xaa, per lee xaa kwaan nanzhebt yet lo yizhyo ne kwent cheen na, xaa ba le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Xaa kwaan nkayaa re gu, noka nkayaa xaa na. Nu xaa kwaan nkayaa na, noka nkayaa xaa xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Loka xaa kwaan nkayaa tub xaa nzaa kwent kwaan nzhé Dios lo lee xaa, nel ne xaa nak xaa xaa Dios, xaa ne le gan leeka kwaan le xaa zee gan. Loka xaa kwaan nkayaa tub xaa nali nak, nel ne xaa nali nak xaa, xaa zee le gan leeka kwaan le xaa nali gan. ");
INSERT INTO zpoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nu loka xaa kwaan zaa tub xig nis go tub xaa chut xaa nak xaa na, wlipa na nii na, telisa Dios kixa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Gorna lee Jesús ngulo mzaa kwent lo chiibchop nu, xaa mleey xaa, nu mroo nu baa, nu nzhazaa nu kwent lo stub naz xaa re yezh cheen yizhyo baa. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan xaa mchubnis nzho lozhyib, nu leezha mbin xaa re kwaan kale Jesús, zee mxaal xaa lak xaa mseed lo xaa, ");
INSERT INTO zpoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ya nabdizh xaa lo Jesús nen che wlipa lee xaa nak Xaa Xaal Dios Nabeyy, o che zbaz xaa stub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús mkeb lo xaa nzhé: —Zyaa gu, nu guzh gu lo Juan re kwaan ngune gu nu re kwaan mbin gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Guzh gu lo xaa: “Lee syeg, ngwii; nu lee xaa mdeen, nze; nu lee xaa nyall cho, ngokwen; nu lee xaa nkwee, mxal nzha; nu lee re xaa ngut, nroban; nu lee re xaa prob, nzhon wdizh chul cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Wen re myet, xaa nanzeret tich lo na nu nantont ne na!” ");
INSERT INTO zpoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Gorna lee xaa mxaal Juan nya, lee Jesús mzelo mzaa kwent cheen Juan lo re xaa, nu nzhé xaa: —Leezha ngwasewii gu lo Juan naz wen, ¿cho nak xaa nzak gu? ¿Che nzak gu lee xaa nak kwenta tub nit kwaan nkun mbi? ");
INSERT INTO zpoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nu chelee xaa ngwasewii gu lo nanakt kwenta nit, ¿cho kwaan ngwasewii gu lo leezha mroo gu nzha gu naz wen? ¿Che tub xaa nak ler chul ngwasewii gu lo? Re gu ne, lee xaa nzhak ler chul, nak xaa nzob leen li re rey. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Per né gu lo na, ¿cho kwaan ngwasewii gu lo? ¿Che tub xaa nzaa kwent kwaan nzhé Dios lo lee xaa ngwasewii gu lo? Wlipa na nii na lo gu, xaa ne nak xaa mas non lo re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan nak xaa nzaa Xkyech Dios kwent: Wii gu, xaal na tub mandad yilo ke lu, xaa zee dexkwaa naz ze lu. Mal. 3:1 ");
INSERT INTO zpoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Lee na nii lo re gu, nik stub xaa nangoknont kwenta Juan. Per snee naka, lee xaa nanont tant pa nabeyy Dios, nak mas nonra ke Juan. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Axta gorna myaad Juan nu axta nal lee pa nabeyy Dios nded dil, nel nzhekla xaa kwaan dil gaka. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Rese xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, nu lee ley ngok non axta myaad Juan. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nu chelee nzhekla gu kayaa gu kwaane, lee Juan nak Li xaa nakladiizh yaad. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Loka xaa nzob nzha, nzhaal gon kwaane! ");
INSERT INTO zpoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Nal nii na lo gu xomod nzhak re myet xaa nzhi nal. Nzhak xaa mod re madwin, mad ngit lo xbi, nu mbazhe xaa lo re wechxinn xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mbill nu bzhik per lee re gu namkaniit, mbill nu kwaan nales nzholl per lee re gu nambinnt”. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sbaa nii na, nel leezha mbid Juan Xaa Nchubnis, xaa nanzhawt pan, nu xaa nixa nanzhot xis ub, nu lee re gu né lee tub mbi mal nzho lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nu nal, nzhal na Xaa Mzhin Ngok Myet, nzhaw na nu nzho na re kwaan, nu lee re gu né na nak tub xaa nzhaw doo nu tub xaa nzho doo xis ub, nu nak na xmig re xaa ntop demi kwaan nya naz Roma nu noka nak na xmig re xaa nle re kwaan nawent. Mod nii re xaa: “Lee yalnzhak cheen Dios luu klar lo re xaa nzho yek”. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Zee lee Jesús mzelo mgalno re xaa re yezh pa mle xaa mas kwaan gro, nel lee re myet baa namlaat xaa naletra xaa kwaan nawent, zee nzhé Jesús: ");
INSERT INTO zpoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Ay proob re gu xaa yezh Corazín! ¡Ay proob re gu xaa yezh Betsaida! Chol rop yezh Tiro nu Sidón ngak re kwaan gro ne, kwaan ngok lo re gu, nzhala mbizh nglaa xaa re kwaan nawent kwaan mle xaa nu ngwii xaa lo Dios nu ngak xaa ler nadox, nu ngzob xaa lo xkade kwaan lu lee xaa nales doo nzhak lextoo kwent cheen re jwalt cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kwaanzee lee mbizh kwaan naab Dios kwent lo re myet, lee bid kwaan ded re gu gak mas nakapra ke kwaan ded re xaa rop yezh Tiro nu Sidón. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nu lee gu xaa yezh Capernaum, ¿che nle gu xgab nya gu naz yiba? ¡Nawlit kwaane, lee gu nya axta xan lo Hades pa nzho re xaa ngut! Nel chol lo yezh Sodoma ngak re kwaan gro ne kwaan ngok lazh gu, lee re xaa yezh Sodoma ngzhika axta mbizh nal. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Per nii na lo gu, lee mbizh kwaan naab Dios kwent lo re myet, lee bid kwaan ded gu gak mas grora lo kwaan ded re xaa yezh Sodoma. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nu leeka gorzee lee Jesús nzhé: —Goll na lo lu Xuz na, Xaa Nabeyy yiba nu yizhyo nel mkaxlaan lu re kwaane lo re xaa nzhak doo nu mlu luya lo re xaa nagakt. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Xuz na sbaa mle lu, nel sbaa nzhekla lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Lee Xuz na mzaa rese kwaan lo na. Nu nik tub nanet cho nak na, xaa nak Xgann xaa, nebse Xuz na ne cho nak na. Nu nik stub xaa nanet cho nak Xuz na, nebse na xaa nak Xgann xaa ne cho nak xaa, nu re xaa nzhekla na zaa na kwent lo. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Te rese gu lo na, xaa kwaan nguzha nkee xchiin, nu xaa nkee kwaan nga doo tich, zee za na deskans cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kayaa gu yog cheen na kwaan za na, nu bseed gu lo na. Na nak xaa nadoo doo nu wen doo nak lextoo na. Sbaa yizhal gu deskans kwaan nza na. ");
INSERT INTO zpoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nel naxex doo yog kwaan za na wee gu zee nanagant wee guya. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Zhe sab, zhe kwaan nzholl re be, xaa Israel lo Dios, Jesús mded pa mgaan xaa nzhobxtil. Lee re nu, xaa mseed lo xaa, ngok nlaan, nu mzelo nu mkiib nu son nzhobxtil nu ndaw nu nzhobxtil. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nu ngune re fariseo kwaane zee nzhé xaa lo Jesús: —Wii lee re xaa kaseed lo lu kale kwaan nanzhaalt le be zhe sab. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Lee Jesús mkeb nzhé: —¿Che zer lab gu Xkyech Dios, kwaan mle David tub welt leezha ngok nlaan re xmig xaa? ");
INSERT INTO zpoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mzeeb xaa leen xkyidoo Dios nu ndaw xaa pan cheen Dios nu mzaa xaaya ndaw re xmig xaa, kwaan nanzhaalt gaw re xmig xaa, sinka nebse ngwleyy nzho mod gawa. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nu, ¿che zer lab gu ley cheen Ches, lee re ngwleyy nanlet nik tub jwalt nixa tubka nkee xaa zhiin dub zhe sab lo xkyidoo Dios? ");
INSERT INTO zpoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kwaanzee nii na lo re gu, nee nzho tub xaa mas non lo xkyidoo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Re gu nanet nen cho kwaan nzaa Xkyech Dios kwent leezha nzhé Dios: “Kwaan nzhekla na nak blesla gu ne gu sa myet gu, nu nanzheklat na teed gu ma lo na”. Hos. 6:6 Chol mlaya yek gu nazhibt gu jwalt tich xaa kwaan nle kwaan wen. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nel na nak Xaa Mzhin Ngok Myet, nu nkano na yalnabeyy zee nzho mod nabeey na zhe sab. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús mroo baa nu nya nu mzeeb nu pa nkasa re be, xaa Israel, nseed be xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nu nzob tub xaa mbizh yaa lo re xaa ba. Nu nkwaan re xaa mod gaazh xaa kwaan tich Jesús zee nzhé xaa: —¿Che nakladiizh sekwen xaa tub myet zhe sab, zhe kwaan nzholl be lo Dios? ");
INSERT INTO zpoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús mkeb nzhé: —Chelee tub gu nkano tub mbakxiil nu la ma leen pos zhe sab, ¿cho nayat gu koo gu ma? ");
INSERT INTO zpoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nii na lo gu, mas non tub myet ke tub mbakxiil. Kwaanzee nzhaal le be kwaan wen zhe sab. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Zee nzhé xaa lo xaa mbizh yaa: —Bseli yaa lu. Zee mseli xaa yaa xaa, zee ngokwen yaa xaa mod nak stub lad. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Per gorzee mroo re xaa fariseo zee myaan re xaa gut xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús ngune cho xgab mle xaa. Kwaanzee mroo xaa baa nu zyen doo myet mreke tich Jesús, nu msekwen Jesús rese xaa ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nu nzhé xaa lo re xaa, zee nayét xaa kwaan mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kwaane ngok zee mbarlo kwaan nzhé Chay, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, leezha nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nee nzo xaa nkee zhiin lo na, xaa mleey na, xaa nkedoola na, xaa nyakdoola ne na, xaal na Mbi Naban cheen na lo xaa, nu zaa xaa kwent nali lo re xaa nanakt xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Naniit xaa wdizh nayii nixa nakeet xaa rezh, nu nixa leen naz nagont re xaa kwaan kanii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nu nachoogt xaa nit kwaan mrek, nu nixa nazebit xaa lo ki gorna leeya zela bal, axta gorna zo xaa nali rese kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nu lee re xaa nanakt xaa Israel nkambaz, zee le xaa kwaan wen lo xaa. Is. 42:1-4 ");
INSERT INTO zpoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Zee ngulaa xaa tub xaa nzho mbi mal lextoo lo Jesús, nu syeg xaa ne, nu noka nyent mod wdizh xaa. Nu lee Jesús mseni zaalo xaa nu noka mle mbdizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mdedyall doo re myet nu nabdizh xaa: —¿Che lee xaa dii cheen rey David nak xaa ne? ");
INSERT INTO zpoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Per gorna mbin re fariseo kwaane, nzhé xaa: —Beelzebú, xaa nak mer Maxuu, mzaa yalnabeyy lo xaa zee nabeyy xaa lo rese mbi mal. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús nela cho kwaan nle re xaa xgab, zee nzhé xaa: —Rese yezh naro nu rese yezh chut nu axta tub yoo kwaan nzhak chop tant, telisa luxa. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nu seeka chelee leeka Maxuu koo Maxuu, zee leeka lee xaa dil kwaan lee xaa, nu nadiit yalnabeyy cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Re gu né, lee na ngoo mbi mal kwaan yalnabeyy cheen Beelzebú, per cheleeya see naka, ¿cho mzaa yalnabeyy lo re xaa mseed lo gu zee koo xaa mbi mal? Kwaanzee leeka re xaa ne nlu re kwaan ngunii gu nawlit nak. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Per chelee na ngoo na mbi mal kwaan yalnabeyy cheen Mbi Naban, kwaane nak lee pa nabeyy Dios mzhin gaxla lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Xomod zeeb tub xaa leen li tub xaa ngezh doo, nu kiib xaa re xcheen xaa, chelee xaa nakadot xaa xaa yilo? Nebse sbaa nzho mod kiib xaa kwaan nkano xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Re xaa nanroot jabor cheen na, xaa zee nayii ne na; nu lee xaa nankeet zhiin kwaan na, xaa zee nluux xchinn na. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Kwaanzee nii na lo gu, Dios chee re jwalt cheen gu, nu re kwaan nge gu lo Dios, per nacheet xaa jwalt cheen re gu, xaa nge lo Mbi Naban. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dios chee axta re jwalt kwaan nge gu lo na, Xaa Mzhin Ngok Myet, per lee xaa nge lo Mbi Naban, nacheet Dios jwalt ba nixa yizhyo ne, nixa stub yizhyo kwaan yo. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Tub yag wen, nzaa xle wen; nu tub yag nawent, nzaa xle nawent; nel lee yag nzhakbeyy kwaan xle nzaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Gu nak dii cheen mball wiz! Gu nak xaa nawent, kwaanzee nyent mod nii gu kwaan wen; nel re kwaan nzho lextoo xaa, nroo roo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lee xaa wen nii kwaan wen nel zyen re kwaan wen nzho lextoo xaa, lee xaa nawent nii kwaan nawent nel zyen kwaan nawent nzho lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kwaanzee nii na lo gu, gorna zhin mbizh kwaan naab Dios kwent lo re myet, axta re wdizh kwaan sbaasa ngunii gu, zaa gu kwent lo xaa gorzee. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nel leeka kwaan wdizh kwaan nii gu chee Dios jwalt cheen gu, nu leeka wdizh kwaan nii gu gaazh xaa jwalt tich gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Zee lee lak fariseo nu lak maestr xaa nlu xtizh Dios nzhé lo Jesús: —Nzhekla nu wii nu le lu tub nseyn gro doo, kwaan nyent mod le re myet yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús mkeb nzhé: —Rese xaa mbizh nalzhe nakap doo nak, nel nzhekla xaa tub nseyn gro doo, per nik tub nseyn nalut lo re xaa, nebse yun nseyn cheen Jonás lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nel mod ngu Jonás lextoo mbal naro doo chon mbizh nu chon yaal, sbaaka na, Xaa Mzhin Ngok Myet, chon mbizh nu chon yaal yoo na leen yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nu noka re xaa Nínive gaazh kwaan tich re xaa mbizh nalzhe, nel mbin xaa xtizh Jonás nu mlaa xaa re kwaan nawent kwaan mle xaa nu mwii xaa lo Dios. Nu lee nal, nee nzo tub xaa mas nonra lo Jonás. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nu lee mbizh kwaan naab Dios kwent lo re myet, lee ngwnaa, me mnabeyy Re Yezh Naz Sur, gaazh kwaan tich re myet mbizh nalzhe, nel lee me mroo axta zit doo nu ngwa me lo Salomón nel nzhekla me gon me re yalnzhak kwaan nzhedizh Salomón. Nu lee nal, nee nzo tub xaa mas nonra lo Salomón. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Gorna lee mbi mal nroo lextoo tub xaa, zee nyanze mbi mal tub pa nabizh zee nkwaan mbi mal tub pa chul kwaz mbi mal, nu nayizhalt mbi mal pa kwaz mbi mal, zee lee mbi mal nle xgab: ");
INSERT INTO zpoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Bare na paro mroo na”. Nu gorna mbare mbi mal stub welt, yizhal xaa zee lo mbi mal, nu xaa zee nak mod tub yoo kwaan nyent xaa leen, tub yoo kwaan wen wen mlob leen nu chul nzhak. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Zee lee mbi mal mbare nya pa ngu yilo, nu nyaxii mbi mal stub gazh mbi mas nawent ke mbi zee. Zee lee xaa ne mas nakap nak ke mod nak xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nu seetaka kanii Jesús lo re myet gorna lee xnaa xaa nu re wech xaa mzhin baa nu nzhekla wdizhno xaa xaa. Nu mlaz re xaa naz jwer. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Zee nzhé tub xaa lo Jesús: —Xnaa lu nu re wech lu mkambaz lu naz jwer nu nzhekla xaa nii xaa lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Per lee Jesús nzhé lo xaa ba: —¿Cho nak xnaa na nu wech na? ");
INSERT INTO zpoNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Zee mlu Jesús re xaa mseed lo xaa, nu nzhé xaa: —Wii gu, re xaa ne nak wech na nu xnaa na. Nel re xaa nle kwaan nzhekla Xuz na, xaa nzob naz yiba, xaa baa nak wech na nu bzan na nu xnaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Loka cho nle kwaan nzhekla Xuz na, re xaa zee nak re wech na, nu re bzan na, nu xnaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nu mbizh zee mroo Jesús roo yoo pa mlaz xaa nu ngwa xaa mzob xaa roo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nu zyen doo myet mkasa lo xaa, zee nguxoob xaa leen tub kano nu mzob xaa leen kano leen nistoo. Nu lee re myet mri roo nistoo lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nu ngunii xaa zyen doo kwaan kwaan kwent nabix. Nu nzhé xaa: —Nal za na tub kwent lo gu cheen tub xaa nchech nzhobxtil lo yo. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nu gorna kachech xaa nzhobxtil laka mla leen naz, nu zee nzha re mbyin nu ndawa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Zlaka mla lo ke pa nyent zyen yo. Nzhobxtil ba lijer doo mlen nel nyent zyen yo pa mlaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Per gorna mlen mbizh nel mla doo neey, zee mbizha nel nyent loxa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Zlaka mla leen yag yich, nu mdin yag yicha, zee namxenta. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Per lee stub naz nzhobxtil kwaan mla lo yo wen chul doo mxena nu chul doo ngoka. Tub ben mzaa tub gayoo nzhobxtil, nu stuba mzaa chongal nzhobxtil, nu stuba mzaa galbchii nzhobxtil. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Loka xaa nzob nzha, nzhaal gon kwaane! ");
INSERT INTO zpoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Zee lee re nu, xaa mseed lo xaa, mbii gax lo xaa nu nzhé nu lo xaa: —¿Chozhiin duzna kwent nabix nii lu lo re xaa? ");
INSERT INTO zpoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús mkeb nzhé: —Dios mzaa yek re gu zee ne gu xomod nak re kwaan nanyunt cheen pa nabeyy Dios; per lo stub naz xaa namzaat xaa diizh labeyy xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nel lee re xaa kwaan nkano kwaan, kayaa xaa masraya; per lee re xaa nankanota axta chep re kwaan nkano xaa yiib lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kwaanzee nii na lo re xaa duzna kwent nabix, zee nixa wii xaa naluta lo xaa, nu nixa gon xaaya nalata yek xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Lo re xaa ne mbarlo kwaan nzhé Chay, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, leezha nzhé xaa: Nixa gon guya, nalata yek gu, nixa wii guya, naluta lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nel ngok ned doo lextoo re xaa ne, nu mod xaa nyaaw nzha, nu mod xaa nanyenit lo nzhak xaa, zee nyent mod gon xaaya zee nyent mod wii xaa loya, zee nyent mod laya lextoo xaa, kwaane nle zee nambaret xaa lo na, zee nasekwent na xaa. Is. 6:9-10 ");
INSERT INTO zpoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Per byakla re gu, xaa nkano zaalo nu nyani, nu xaa nzob nzha nzhon re kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Wlipa na nii na lo gu, zyen doo xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo nu noka re xaa nali mzo lo Dios, nzhekla ne re kwaan ngune gu lo, per nangunet xaa loya; nu noka nzhekla xaa gon xaa re kwaan mbin gu, per nambint xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Kenzha gu zee ne gu xomod nak kwent nabix cheen xaa nchech nzhobxtil lo yo. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Lee re xaa kwaan nzhon re wdizh kwaan nak cheen pa nabeyy Dios, nu nanlata yek xaa, xaa ne nak mod nzhobxtil kwaan mla leen naz, zee nzha Maxuu nkiib xtizh Dios leen lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lee nzhobxtil kwaan mla lo ke pa nyent zyen yo nak kwenta re xaa nzhon xtizh Dios, nyakdoola xaa mkayaa xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Per nel nak xaa mod tub nzhobxtil kwaan nanecht nzho lox, kwaanzee nanyet nzo xaa lo xtizh Dios. Nu gorna nze tub yalzi lo xaa lo xtizh Dios nu nrenal xaa xaa, gorzee nlaa xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Lee nzhobxtil kwaan mla leen yag yich nak kwenta xaa nzhon xtizh Dios, per lee re xgab yizhyo ne nu re kwaan nzoblazh xaa nkade xaa. Nu rese kwaane ngin xtizh Dios leen lextoo xaa. Kwaane nle zee nanzaat xaa xle. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Per lee nzhobxtil kwaan mla leen yo wen nak mod xaa kwaan nzhon xtizh Dios nu nlaya yek xaa. Nu xaa ne nak xaa nzaa zyen doo xle. Xaa ne nak mod tub ben nzhobxtil kwaan tubka son nzaa tub gayoo nzhobxtil, nu stub xaa nak mod tub ben nzhobxtil kwaan tubka son nzaa chongal nzhobxtil, nu stub xaa nak mod tub ben nzhobxtil kwaan tubka son nzaa galbchii nzhobxtil. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús mzaa stub kwent nabix lo re xaa nu nzhé xaa: —Lee na za stub kwent. Lee pa nabeyy Dios nak mod tub xaa nchech nzhobxtil chul lo yo. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Per gorna ngot re xaa, lee tub xaa nayii ne xaa ngwa mchech bizh cheen yixbal leen nzhobxtil cheen xaa. Nu gorna ngulo mchech xaaya nu nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gorna lee nzhobxtil ngulo mxen nu nzela dooy, zee noka yixbal mlen leena. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Zee lee re xaa nkee zhiin lo xaa nak cheen nzhobxtil nzhéya lo xaa: “¡At ben wen mloo be lo yo! ¿Pa mroo yixbal kwaan mlen leena?” ");
INSERT INTO zpoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Lee xaa nak cheen nzhobxtil nzhé: “Tub xaa nayii ne na mle kwaane”. Lee re xaa nkee zhiin lo xaa mnabdizh nu nzhé xaa: “¿Che nzhekla lu yakiib nu yixbal?” ");
INSERT INTO zpoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Per lee xaa nzhé: “Laa, nayakiibt guya. Nel chelee gu yakiib gu yixbal napaka kakiib gu nzhobxtil. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mas wen blaa gu xen reya tubka, axta gorna top na nzhobxtil. Zee xaal na xaa top re yixbal, nu gorna yilo top xaa re yixbal nu kado xaa leena zee zek naya, nu lee nzhobxtil top xaa, zee koo naya pa ngozhaw na re xoob na.” ");
INSERT INTO zpoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús mzaa stub kwent nabix lo xaa nu nzhé: —Nal lee na za stub kwent lo re gu. Lee pa nabeyy Dios nak mod tub bizh cheen mostas kwaan mxen tub xaa xleyo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Leeya nak tub bizh chut lo rese bizh, per gorna mlena nu ngoka tub yag, nu lee re mbyin mdexkwaa xlaaz ma lo re ram cheena. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Noka nzhé xaa: —Lee na za stub kwent lo re gu. Lee pa nabeyy Dios nak mod lebadur kwaan mlo tub ngwnaa leen chon medid arin zee yixooba. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús ngunii re kwaane lo re myet kwaan kwent nabix, nu cheleeya nanakta kwent nabix naniit xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kwaane ngok zee mbarlo kwaan nzhé xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, leezha nzhé xaa: Kwaan kwent nabix yé na re kwaan nzhoxlaan, axta gorna lee Dios mdexkwaa yizhyo. Sal. 78:2 ");
INSERT INTO zpoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús mlaa re myet nu mzeeb xaa leen tub yoo. Leen yoo ba lee re nu, xaa mseed lo xaa, mnabdizh lo xaa: —¿Xomod nak kwent kwaan mzaa lu cheen nzhobxtil rop yixbal? ");
INSERT INTO zpoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús mkeb nzhé: —Lee xaa kwaan mchech nzhobxtil wen nak na, Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nu lee leyo nak dub yizhyo, lee nzhobxtil nak re xinn Dios, Xaa Nabeyy, nu lee yixbal nak xaa Maxuu. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Lee xaa nayii ne na, xaa mgaan yixbal nak Maxuu. Lee gorna top xaa yalgon nak axta mbizh gwluzhtlaka gorna naab na kwent, lee xaa topa nak re mandad cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Snee mod ntop xaa yixbal nu nzek xaaya lo ki, sbaaka gak mbizh gwluzhtlaka gorna naab na kwent. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Lee na, Xaa Mzhin Ngok Myet, xaal na mandad cheen na top xaa re xaa kwaan nle nawent, nu re xaa nle zee nle re wechxinn xaa kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nu chep na xaa leen gor kwaan nze doo bal, paro gonn xaa nu kozhe leyy xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Zee lee xaa nali nak lo Dios la xni pa nabeyy Xuz na, modxa nla xni mbizh. ¡Loka xaa nzob nzha, nzhaal gon kwaane! ");
INSERT INTO zpoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Lee pa nabeyy Dios nak mod zyen doo or kwaan nzholaan leen tub lee leyo. Tub xaa nzha nu nguzhal or ne, nu mbare xaa mlolaan xaaya stub welt leeka lugar zee. Nu nyakdoola xaa nya xaa mto xaa rese kwaan nkano xaa, zee zii xaa leyo pa nguzhal xaa or. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Lee pa nabeyy Dios nak mod tub xaa nzi perla kwaan non doo. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Gorna yizhal xaa tub kwaan chul doo lo reya, nu nya xaa nu mto xaa rese kwaan nkano xaa, zee zii xaa perla kwaan chul doo kwaan nguzhal xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Noka pa nabeyy Dios nak mod yeez, kwaan nchep xaa leen nistoo zee zen xaa re lota mbal. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Gorna lee yeez ngulo nguzhe zee mloo xaaya naz roo nistoo, pa zob re xaa kweey xaa mbal. Nu koo xaa ma wen leen xchekwid xaa, lee re ma nawent ngobi xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sbaaka gak mbizh gwluzhtlaka lo yizhyo ne. Lee re mandad cheen Dios kweey re xaa nawent lo re xaa nali. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nu lee re xaa nawent chep xaa leen gor ki, pa gonn xaa nu kozhe leyy xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús mnabdizh: —¿Che mla re kwaane yek re gu? Lee re nu mkeb nzhé: —Mlaya yek nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Zee lee Jesús né lo re nu: —Gorna lee tub maestr, xaa nlu xtizh Dios, nlabeyy xomod nak pa nabeyy Dios, mod tub ngwzan nle xaa, xaa nabeyy garli. Nu nzhekla xaa luu xaa rese kwaan chul nu rese kwaan non kwaan ngozhaw xaa leen li xaa, re kwaan gox nu re kwaan kub. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Gorna lee Jesús ngulo ngunii re kwent nabix ne, zee mroo xaa baa, ");
INSERT INTO zpoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nu mzhin xaa mer lazh xaa. Zee mseed xaa re myet pa nkasa re be, xaa Israel nseed be xtizh Dios. Lee re myet ndedyall ngwii lo xaa nu mbezh re xaa: —¿Pa mseed xaa ne re kwaan nzhak xaa? ¿Xomod nzho mod nle xaa re kwaan gro ne? ");
INSERT INTO zpoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¡Lee xaa ne nak xgann Che karpinter nu lee xnaa xaa nak Mari, nu re wech xaa nak Chag, Che, Simón nu Judas! ");
INSERT INTO zpoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nu leeka nee nzho re bzan xaa. ¿Pa naz nguxii xaa re kwaan nzhak xaa? ");
INSERT INTO zpoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kwaanzee nanlet re xaa kas xaa. Per lee Jesús nzhé: —Nik tub xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo namkayaawent re sawlazh xaa xaa nu re sawlizh xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nu namlet xaa zyen kwaan gro baa, nel namwiit re xaa ba lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Re mbizh zee lee rey Herod, xaa nabeyy Galilea, mbin zyen doo kwaan kale Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Zee nzhé xaa lo re xaa nkee zhiin lo xaa: —Xaa ne nak Juan xaa mchubnis nu mroban xaa stub welt, zee nle xaa re kwaan gro ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Sbaa nzhé Herod nel Herodías, xngwnaa wech xaa Lip, mle zee mkado Herod Juan kwaan kaden, nu mlo xaa Juan lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sbaa mle Herod nel Juan nzhé lo Herod: —Nawent kano lu me mod xngwnaa lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Zee nzhekla Herod gut Juan, per nzheb xaa ne xaa re xaa yezh, nel lee re xaa yezh mbezh lee Juan nak tub xaa nzaa kwent kwaan nzhé Dios lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gorna nguxoob Herod liin zee mle Herod tub yalni. Nu lee xchap Herodías mzelo mkanii lo re xaa nzhi baa, nu ngula doo Herod mod mkanii me, ");
INSERT INTO zpoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","zee mcheroo xaa lo me nu nzhé xaa lo me: —Naab loka kwaan nzhekla lu lo na, na zaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Xnaa me nzhé lo me xana kwaan nzhaal naab me, zee nzhé meya lo Herod: —Choog yek Juan Xaa Nchubnis nu blooya leen yann nu zaaya lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nales doo ngok lextoo Herod. Per zyen doo xaa mbin lee Herod nzhé kwaane lo me, zee nzhé Herod lo tub xaa, zee zaa xaaya lo me. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Zee mxaal xaa xaa yachoog yek Juan leen lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Zee mbe xaa yek Juan nu mloo xaaya lo tub yann, nu mzaa xaaya lo me, nu lee me mzaaya lo xnaa me. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mzhin re xaa mseed lo Juan nu mbe xaa kwerp cheen Juan zee kach xaa xkwerp xaa. Gwluzh zeera ngwa xaa nu ngwayé xaaya lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Gorna mbin Jesús lee Juan ngut, zee nguxoob xaa leen tub kano, zee ya xaa pa nyent myet. Per ngune re myeta nu mroo re xaa yezh nu nzenii xaa nzhake xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Zee mla Jesús leen kano, zee mwii xaa lo zyen doo myet nzhake tich xaa. Mles lextoo xaa ne xaa re xaa, zee msekwen xaa re xaa ne nzak, xaa nzhano re xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gorna nzhazhela yizhyo lee nu, xaa mseed lo Jesús, mbii gax lo xaa nu nzhé nu lo xaa: —Ngulola mzhel yizhyo nu nyent yoo nee to kwaan gaw re be. Xaal re xaa zee yakwaan xaa kwaan gaw xaa re yezh nzhi gax nee. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lee Jesús mkeb lo re nu né: —Nankint nya re xaa. Zaa gu kwaan gaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Per re nu nzhé lo xaa: —Nankanot nu kwaan zaa nu gaw re xaa, nebse gaaya pan nu chopaka mbal nkano nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús né: —Teno guya nee. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Zee nzhé Jesús lo re myet: —Bzob gu lo yixyi wen. Nu mzen xaa gaaya pan nu rop mbal, nu mwii xaa naz yiba, nu mzaa xaa dixkix lo Dios. Nu mle rol xaa pan nu mzaa xaaya lo re nu, xaa mseed lo xaa, zee kiiz nuya lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Rese xaa ndaw axta paro nguzhe lextoo xaa. Nu chiibchop chekwid pan byog mlake gorna ngulo ndaw re xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nu gaay mil xaabyi nak xaa ndawa nu namloot xaa kwent re ngwnaa nu re madwin. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Gwluzh ngulo mded kwaane, Jesús mxaal re nu, xaa mseed lo xaa, zee yixoob nu leen kano zee deed nu stub ta roo nistoo. Per lee Jesús mlakeka lo re myet axta yilo chech xaa re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Gorna ngulo mxaal xaa re myet nya, nu lee xaa nguxoob yek yi pa wdizhno techosa xaa Dios. Gorna ngulo mzhel yizhyo techo xaa nzo baa. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nu lee kano nzha xsaww leen nistoo gorzee. Nu lee mbi nze naz lo kano zee ngit doo nistoo, nu nanlat nis nzeno nu kano naz delant. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nzhaka xnila yizhyo lee Jesús nzhaze lo nistoo nu nyaad gax lo re nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Gorna ngune re nu lee xaa nzhaze lo nistoo, mbazhe nu nel mzheb doo nu, zee nzhé nu: —¡Besa! ");
INSERT INTO zpoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Per Jesús nguné lo nu: —Blo gu balor lextoo gu, nazhebt gu, nel naya. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Zee lee Pér nzhé: —Xaa Nabeyy, cheleeya luya, ble zee noka na ze lo nistoo yal lo lu baa. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús nzhé lo xaa: —Te nee. Zee lee Pér mla leen kano nu nzhaze xaa lo nistoo nzha lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per gorna ngune Pér nroo doo mbi zee mzheb doo xaa, nu nzhala Pér naz leen nistoo. Zee mbazhe Pér nzhé Pér: —Xaa Nabeyy, nalaat lu la na leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gorzee lee Jesús mzen yaa xaa, nu nzhé lo xaa: —¡Chepse ngwii lu lo na! ¿Chozhiin nzho stub xgab yek lu? ");
INSERT INTO zpoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Gorna nguxoob xaa leen kano lee mbi mlaz. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Zee lee re nu, xaa nzho leen kano mkichxub lo Jesús nu mbill nu lo xaa, nu nzhé nu lo xaa: —Wlipa lu nak Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Zee mded nu stub ta roo nistoo, mzhin nu tub yezh kwaan le Genesaret. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Gorna ngokbeyy Jesús lo re xaa, dubse yizhyo ba mdizh xaa kwent cheen Jesús. Kwaanzee ngulaa re xaa xaa ne nzak lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nu ngunaab re xaa lo Jesús, zee zaa Jesús diizh gal re xaa ne cho xab Jesús, nu re xaa mgal cho xab Jesús nzhakwen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tub mbizh mroo lak xaa fariseo nu lak maestr xaa nlu xtizh Dios naz Jerusalén, mnabdizh lo Jesús, nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Chozhiin nanlet re xaa nseed lo lu re kwaan nzhé re xey be, xaa yilo? ¿Chozhiin nayanagt xaa gorna nzhaw xaa modxa nzhé re xey be yilo? ");
INSERT INTO zpoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús mnabdizh lo re xaa: —¿Chozhiin nanlet re gu kwaan mxaal Dios le gu, leel re cheen xey be nle gu? ");
INSERT INTO zpoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nel Dios nzhé: “Kela lu xuz lu nu xnaa lu, nu xaa nge lo xuz o lo xnaa, bit gu xaa”. Ex. 20:12 ");
INSERT INTO zpoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per gu mbezh nzho mod nii gu lo xuz gu nu lo xnaa gu: “Nagarlot mod le na yudar rop gu, nel rese kwaan mlake lo na mzala naya lo Dios”. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nu loka xaa mbezh snee, nanzhaalt le xaa yudar xuz xaa nu xnaa xaa. Nu sbaaka nak re gu, re gu nlux re kwaan mxaal Dios le gu, nel nzhake gu tich re kwaan nzhé re xey be. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Gu nak xaa nkade nu nanlet gu kwaan wen! Wen ngunii Chay, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. Mzaa xaa kwent cheen gu leezha nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Lee re xaa ne nebse kwaan roo xaa mbezh na, per lee lextoo xaa zit doo nzo lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kanxlee nzholl re xaa lo na, nel rese kwaan seed re xaa nak kwaan mroo yek re myet. Is. 29:13 ");
INSERT INTO zpoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Zee lee Jesús mrezh re myet nu nzhé xaa lo re xaa: —Kenzha gu kwaane nu bin guya. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nalet kwaan nzhaw myet nle nzo nawent myet lo Dios, sinka kwaan nroo naz leen lextoo myet nak kwaan nle nawent nzo xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Zee lee re nu, xaa mseed lo xaa, mbii gax lo xaa nu nzhé nu: —¿Che nanet lu lee re fariseo nayii mbin kwaan nzhé lu? ");
INSERT INTO zpoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús mkeb né: —Lee rese yag kwaan namxent Xuz na, xaa nzob naz yiba, dub loxa yiib. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Laa xaa ba nel syeg xaa, nel chelee tub syeg wee leeka sasyeg syeg ropse xaa la leen yeer. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pér nzhé lo Jesús: —Né lo nu nal, ¿xomod nak wdizh nabix kwaan nguné lu lo nu? ");
INSERT INTO zpoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús mkeb né: —¿Che nixa yek gu nanlata? ");
INSERT INTO zpoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Che nanlat yek gu, lee rese kwaan nzhaw xaa nla leen xpaans xaa, nu nrooya stuba? ");
INSERT INTO zpoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per lee kwaan nroo roo xaa, nzhal mer lextoo xaa, kwaan ba nle nawent nzo xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nel leen lextoo xaa nzhal re xgab nawent ne: gut xaa sa myet xaa, zoblazh xaa chaal xaa stub ngwnaa, lewann xaa, gaazh xaa kwaan nawlit tich stub xaa, gawyix xaa wechxinn xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kwaane nak kwaan nle zee nawent nzo myet lo Dios. Per leezha nanyanagt xaa gaw xaa, nanlet kwaan ba nle zee nzo nawent xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús mroo baa nu nzha naz yizhyo cheen Tiro nu Sidón. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nu lee tub ngwnaa Canaán, me nzho yizhyo ba, mbii gax lo Jesús nu dublegan nzhé me lo Jesús: —Me Nabeyy, lu nak xaa dii cheen rey David, bles lextoo lu ne lu na. Lee xchap na nded doo bid nel nzho mbi mal lextoo mad. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Namkebt Jesús nik tub lan wdizh lo me. Nu lee nu, xaa mseed lo Jesús, mbii gax lo xaa nu nzhé nu lo xaa: —Guzh lo ngwnaa ba zee nya me, nel nkee doo me rezh nzeke me tich be. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús né: —¿Che nanebt lo re sawlazh be mxaal Dios na, re xaa nak mod mbakxiil ma mzowen? ");
INSERT INTO zpoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Per lee ngwnaa ne mbii gax lo xaa nu mkichxub lo xaa, nu nzhé: —Me Nabeyy, le jabor lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús mkeb nzhé: —Nawent kiib xaa pan lo xinn xaa nu zaa xaaya lo mbak. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Lee me nzhé: —See naka, Me Nabeyy. Per noka nzhaw mbak re kwaan byog kwaan nzhab lo mes cheen xbixwann ma. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Zee nzhé Jesús: —Ngwnaa, gro doo nak mod ngwii lu lo Dios. Gaka mod nle lu xgab. Nu leeka gorzee ngokwen xchap me. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús mroo baa nu mzhin xaa roo nistoo cheen Galilea. Zee ngwa xaa yi nu mzob xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Zyen doo myet nkasa lo xaa pa nzob xaa. Nu nzheno re xaa xaa reenk, syeg, xaa nzhak net nii, xaa muud, nu re xaa nzak stub naz yalyizh. Ngwano re xaa xaa lo Jesús zee msekwen Jesús re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nu lee re xaa nzhi ngwii mdedyall doo nu nzhé xaa: —Lee muud nzho mod nzhadizh, nu lee xaa reenk nzho mod nze, nu lee xaa nzhak net nii nzho mod nze wen, nu lee syeg ngwii. Zee mzelo re xaa mbill lo Xdios be. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús mrezh re nu, xaa mseed lo xaa, nu né xaa lo re nu: —Nles doo lextoo na ne na re myet ne, nel nzhala chon mbizh nzo re xaa kwaan be nu nyent kwaan gaw re xaa. Nanzheklat na xaal na re xaa garli xaa nu nazaat na kwaan gaw xaa, nel napaka kayaguuzh xaa naz. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Lee nu nzhé lo xaa: —¿Per pa yixii nu tub lanee kwaan gaw tub lanee myet, pa nik tub xaa nyent? ");
INSERT INTO zpoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús mnabdizh né: —¿Lak pan nzeno gu? Zee nzhé nu: —Gazh pan nu lak mbal dik. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Zee ngunii Jesús lo re myet zee zob xaa lo yo. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nu mzen xaa gazh pan nu lak mbal dik nu mzaa xaa dixkix lo Dios. Nu mlerol xaaya nu mzaa xaaya lo re nu, xaa mseed lo xaa. Re nu mdiiza lo re myet xaa nzhi baa. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Rese xaa ndaw axta nguzhe lextoo xaa. Nu gazh chekwid re kwaan byog mlake. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nu tap mil xaabyi nak re xaa ndawa zee nu namloot nu kwent re ngwnaa nu re madwin. ");
INSERT INTO zpoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Gwluzh zeera mxaal Jesús re xaa nya nu lee Jesús nguxoob lo tub kano nu nzha xaa naz yezh cheen Magdala. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Re xaa fariseo nu re xaa saduceo ngwa lo Jesús nu ngunaab xaa tub nseyn yiba lo Jesús, zee luu lee xaa nak xaa mxaal Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Per lee Jesús mkeb nzhé: —Leezha naxne na xkaw yiba nzhal mzhel yizhyo mbezh gu: “Nalat yey”. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Leezha naxne na xkaw yiba nzhal garziil, zee mbezh gu: “Nalzhe roo mbi nu la yey”. Gu nlabeyy re nseyn naz yiba, ¿xomod nanlabeyyt gu re nseyn re mbizh ne? ");
INSERT INTO zpoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","¡Ay, nakap doo nak re gu xaa nzho re mbizh nal, xaa nanalit nzhak lextoo gu! Naab gu nseyn gro doo lo na, per nyent nseyn kwaan wii re gu lo, nebse nseyn cheen Jonás, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. Nzhé xaa kwaan baa nu mroo xaa lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesús kwaan re nu, xaa mseed lo xaa, nzhaded stub ta roo nistoo nu myenlazh re nu nge nu pan. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Zee né Jesús lo re nu: —Lijer gok gu lo lebadur cheen re fariseo nu re xaa saduceo. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Zee lee re nu nzhé lo wechxinn nu: —Nanzenot be pan, zee sbaa né xaa lo be. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús mzeen kwaane zee né xaa lo re nu: —¿Chozhiin mbezh gu lee gu nanzenot pan? Gu nak xaa chepse ngwii lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Che seesa nanlata yek gu? ¿Che nanselazht gu cheen gaay pan kwaan mza na ndaw tub gaay mil xaabyi, nu lak chekwid kwaan byog mtop gu? ");
INSERT INTO zpoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nu, ¿che nixa nanselazht gu cheen gazh pan kwaan mza na ndaw tub tap mil xaabyi, nu lak chekwid kwaan byog mtop gu? ");
INSERT INTO zpoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chozhiin nanet gu lee na nakaniit cheen lebadur cheen pan? Per lee kwaan ngunii na lo gu nak: Kanap gu gu lo lebadur cheen re fariseo nu re xaa saduceo. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Zeera mlaya yek re nu, lee Jesús nakaniit gak lijer re nu lo lebadur cheen pan, sinka lijer gak nu lo re kwaan nlu re fariseo nu re xaa saduceo. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Gorna lee Jesús mzhin yizhyo cheen Cesarea-Filipo, mnabdizh xaa lo re nu, xaa mseed lo xaa, nu né xaa lo nu: —¿Cho né re myet nak na, Xaa Mzhin Ngok Myet? ");
INSERT INTO zpoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Lee nu nzhé: —Tub naz xaa mbezh lee lu nak Juan xaa mchubnis, stub naz xaa mbezh lee lu nak Li, nu stub naz xaa mbezh lee lu nak Jeremías, nu stub naz xaa mbezh lee lu nak stub re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, mrobanla nal. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Zee mnabdizh Jesús lo re nu: —Lee re gu, ¿cho nak na nle re gu xgab? ");
INSERT INTO zpoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pér mkeb nzhé: —Lu nak Xaa Mxaal Dios Nabeyy, nak lu Xgann Dios xaa tira mban. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Zee lee Jesús nzhé lo Pér: —Byakla lu Simón Pér, xgann Jonás. Nel nik tub myet namlut kwaane lo lu, sinka Xuz na, xaa nzob naz yiba, mluya lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nu nii na lo lu Pér, lee le lu nii “Ke”, nu tich ke ne za na yidoo cheen na, kwaan nak re xaa ngwii lo na. Nu lee re xaa ngwii lo na le gan lo xaa nabeyy lo re xaa ngut. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nu lo lu za na leyaw cheen pa nabeyy Dios. Rese kwaan kado lu lo yizhyo ne, nkadoola naz yiba; nu rese kwaan sela lu lo yizhyo ne, mlala naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Zee lee Jesús mnabeyy re nu, zee nik tub lo nayét nu lee Jesús nak Crist, Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jesús mzelo mseed re nu, xaa mseed lo xaa, nkin ded doo xaa bid, nu nakayaat re xaa gol xaa, nixa re ngwleyy xaa non, nixa re maestr xaa nlu xtizh Dios. Nu gut re xaa xaa, per lee mbizh yon lee xaa roban. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Zee mbe Pér xaa tub lad nu mgalno Pér xaa, nu nzhé Pér lo xaa: —Xaa Nabeyy, Dios nanzheklat yet lu, nyent mod ded lu kwaan ba. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Per lee Jesús mzere yenn nu nzhé xaa lo Pér: —¡Bachii lo na Maxuu! Lu nanlet xgab kwaan nle Dios xgab; lu nle xgab kwenta re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Zee lee Jesús né lo re nu, xaa mseed lo xaa: —Chelee tub gu nzhekla reke tich na, laa gu rese kwaan nzhap gu, nu rese kwaan nzho yek gu le gu, nu gak gu kwenta tub xaa mbit xaa lo krus, nu breke gu tich na. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chelee tub xaa yet nel nreke xaa tich na, nu nel ngula xaa re wdizh wen cheen Dios xaa nzho naz leen yiba, le xaa gan yalnaban cheen xaa kwaan tira. Per lee xaa nzheb yet kwaan na, nalet xaa gan yalnaban naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Cho gan le re myet le xaa gan rese kwaan nzho yizhyo nu yet xaa? ¿Che nzho mod zii xaa yalnaban kwaan ndii tira? ");
INSERT INTO zpoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nel lee na nak Xaa Mzhin Ngok Myet, nu yal na kwaan xni cheen Xuz na nu kwaan re mandad cheen xaa. Nu lo kad tub xaa za na kwaan mle xaa gan lo yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Wli na nii na lo gu, nzho lak gu nzo nee nal, nayeta axta lee na, Xaa Mzhin Ngok Myet, yaad kwaan yalngezh cheen pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Xop mbizh gwluzh, Jesús mbe Pér, Chag nu Juan wech Chag. Nu nzha re xaa yek yi naro. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Zee lee Jesús myun stub mod lo yon xaa nu mla doo xni garlo xaa mod xni mbizh; nu lee xab xaa begxiil doo na mod xni. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ta mlu Ches kwaan Li kawdizh kwaan Jesús lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Zee nzhé Pér lo Jesús: —Xaa Nabeyy. ¡Wen nzo nu nee! Nal dexkwaa nu chon ramad: tuba cheen lu, stuba cheen Ches nu stuba cheen Li. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Gorna lee Pér kaniika lee tub xkaw kwaan nla xni msaaw re xaa. Nu leen xkaw mroo tub bos kwaan nzhé: —Xaa ne nak xgaan na, xaa nkedoola na, xaa nyakla na ne na. Bin gu xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gorna mbin re xaa mseed lo xaa kwaane, mkichyek xaa axta lo yo nel mzheb doo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús mbii lo yon xaa nu mgal cho xaa, nu nzhé Jesús lo xaa: —Guxche gu, nazhebt gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nu gorna mwii yon xaa nik stub xaa namlut lo xaa, nebse Jesús nzo lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Gorna mbare xaa naz yi Jesús nzhé lo yon xaa: —Nik tub lo nayét gu kwaan mlu lo gu axta gorna lee na roban, Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Zee mnabdizh yon xaa lo Jesús: —¿Chozhiin nzhé re maestr xaa nlu xtizh Dios, yanertlaka Li yaad? ");
INSERT INTO zpoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Zee lee Jesús mkeb nzhé: —Wli, lee Li yaad yilo nu lee xaa dexkwaa reya. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per lee na nii lo gu, lee Li mbiidla per namkayaat re myet xaa sinka mle re xaa xaa modxa nzhekla re xaa. Seeka na, Xaa Mzhin Ngok Myet, deed na bid doo lo re xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Zee lee yon xaa mseed lo xaa mzeen lee xaa kazaa kwent cheen Juan xaa mchubnis. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Gorna mbare Jesús kwaan yon xaa mseed lo xaa ngwa yek yi, zee mzhin xaa pa nzhi re myet. Zee mzhin tub xaa mkichxub lo Jesús, nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Xaa Nabeyy, blesla lu ne lu xgaan na, nel nzhib xaa yizhgutye. Nu nded doo xaa bid loya, zyen doo welt nla xaa lo ki nu leen nis. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nguno na xaa lo re xaa kaseed lo lu, per namlet xaa gan msekwen xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús mkeb nzhé: —Myet xaa nakap nak, xaa nanet wii lo Dios. ¿Axta pa gor yiche lextoo na ne na re gu? ¿Axta zlak mbizh nzhaal zo na lo re gu? Teno xgann lu nee. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Zee lee Jesús ngunii lo mbi mal nu mloo xaa mbi mal lextoo xaa ba. Nu leeka gorzee ngokwen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Gwluzh lee re nu, xaa mseed lo xaa, mnabdizh lo xaa tub lad pa nzhi re nu, nu nzhé nu lo xaa: —¿Chozhiin nyent mod ngoo nu mbi mal ba? ");
INSERT INTO zpoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jesús né: —Nyent mod ngoo gu mbi mal zee, nel chepse ngwii gu lo Dios. Wli na nii na lo gu, chol ngwii gu lo Dios, tub chutaka lalsa na tub bizh dik cheen mostas, nzho mod yé gu lo yi ne: “Bachii nee nu zyaa stub pa”, nu lee yi bachii. Rese kwaan nzho mod gak lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tub mbizh mkanze xaa yizhyo Galilea, Jesús né lo re nu, xaa mseed lo xaa: —Nixa nak na Xaa Mzhin Ngok Myet, zaa xaa na lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nu gut xaa na per mbizh yon lee na roban. Wdizh baa mbin nu, zee nales doo ngok lextoo nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Gorna lee Jesús kwaan re nu, xaa mseed lo xaa, mzhin yezh Capernaum, lee xaa naab demi cheen yidoo, nzha nzhé lo Pér nu mnabdizh xaa nu nzhé xaa: —¿Che nakixt xmaestr lu demi cheen yidoo? ");
INSERT INTO zpoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pér nzhé: —Zgix xaaya. Zee gorna nzha zeeb Pér leen yoo, yilo Jesús ngunii lo Pér nu nzhé: —¿Simón, cho xgab nle lu? ¿Cho lo naab re rey yizhyo ne demi, che leeka lo re sawlazh xaaya o che lo xaa stub yezha? ");
INSERT INTO zpoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pér nzhé: —Lo xaa stub yezha. Zee Jesús nzhé: —Kwaanzee re sawlazh xaa nanzhaalt kix nik tub gaay. ");
INSERT INTO zpoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Per nik tub xaa nanzheklat na le na zee gak nales doo lextoo xaa, kwaanzee nii na lo lu, gwa roo nistoo nu lebi lambr kwaan nzen lu mbal. Nu mbal kwaan yilotlaka yiga lo lu, leen yenn mbal ba roo tub demi plat kwaan kix be cheen yidoo. Nu beya nu gwatix lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tub welt nu, xaa mseed lo Jesús, mbii gax lo xaa nu nzhé nu: —¿Cho xaa mas non pa nabeyy Dios? ");
INSERT INTO zpoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zee Jesús mrezh tub madwin nu mzo xaa mad xsaww lo re nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nu né xaa: —Wlipa na nii na lo gu, chelee gu nagakt gu kwent madwin ne nazeebt gu pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Lee xaa nonra pa nabeyy Dios, nak xaa nadoo doo nak mod madwin ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Loka cho kayaa tub madwin kwenta madwin ne nel nkela xaa na, noka nkayaa xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Loka xana tub xaa le zee laa tub madwin na, mad ngwii lo na; mas wen kee xaa tub ke ndok yenn xaa zee, nu gobi xaa xaa leen nistoo zee yep xaa nis. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ay! Bid doo ded re xaa yizhyo, xaa nkiil stub xaa zee laa xaa na. Telisa nzho xaa sbaa nle, per nales doo gak re xaa sbaa nle. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Kwaanzee chelee yaa lu o nii lu nle zee nle lu kwaan nawent, chooga nu blabiya zit lo lu, nel mas wen lux lu tub lad yaa lu o tub lad nii lu, ke nya dub lu lo ki kwaan tira nanyuyyt. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chelee zaalo lu nle zee nle lu kwaan nawent, blooya nu blabiya zit lo lu, nel mas wen lux lu tub zaalo lu, ke nya dub lu lo ki kwaan tira nanyuyyt. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Nalet gu xgab lee re madwin ne nanont, nel wli na nii na, lee re mandad cheen re madwin ne tubka nzo kwaan Xuz na, xaa nzob naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwaanzee lee na, Xaa Mzhin Ngok Myet, na nzhal zee kwaan na rese myet, xaa mzowen Dios lo, nu koo na xaa lo yalgut. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Cho kwaan nzak gu? Tub xaa nkano tub yiyoo mbakxiil nu mzowen xaa tub ma. Telisa laa xaa stub tapgal nzho chiibyee ma naz wen, zee yikwaan xaa ma mzowen axta yizhal ma lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nu chelee xaa mle xaa gan nguzhal ma lo xaa, wlipa na nii na, mas nyakdoola xaa ne xaa ma mzowen, ke stub tapgal nzho chiibyee ma, ma namzowent. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sbaaka le Xuz be, xaa nzob naz yiba, nanzheklat xaa zowen nik tub re madwin ne lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Chelee wech lu le tub kwaan nawent lo lu, yanii lu lo techosa xaa, nu yé lu lo xaa rese kwaan mle xaa. Chelee xaa gon xaa xtizh lu, zeesi wen zo rop wech gu stuba. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Chelee xaa nanet xaa gon xaa xtizh lu, brezh chop xaa o chon xaa, zee ya yon gu lo xaa, modxa nkee lo Xkyech Dios: “Nkin chop xaa o chon xaa nii leeka kwaan, zee lee jwes yé wliya”. Dt. 19:15 ");
INSERT INTO zpoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Chelee xaa nanet xaa gon xaa xtizh yon gu, guzh guya lo re xaa Dios. Nu chelee xaa nanet xaa gon xaa xtizh re xaa Dios, zee le gu xaa mod tub xaa nanakt xaa Dios nu mod tub xaa ntop demi kwaan nya naz Roma. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Wli na nii na lo re gu, rese kwaan kado gu lo yizhyo ne, nkadoola naz yiba; nu rese kwaan sela gu lo yizhyo ne, mlala naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Kwaane nii na lo gu: Chelee chop gu myaan lal lo tub kwaan lo yizhyo ne naab guya lo Xuz na, xaa nzob naz yiba, lee xaa zaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nel pa nzhi chop gu o chon gu, xaa nak xaa na, lee na nzo xsaww lo yon gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Zee lee Pér ngwanabdizh lo Jesús nu nzhé: —Xaa Nabeyy, ¿lak welt yenlazh na kwaan mle wech na lo na? ¿Che axta gazh welta? ");
INSERT INTO zpoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús mkeb nzhé: —Naniit na gazh welta, sinka lee na nii, gazh welt chongal nzho chiiya. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Nal za na tub kwent lo gu, zee ne gu xomod nak pa nabeyy Dios. Tub welt ngu tub rey, xaa nzhekla koo kwent rese kwaan nzeb xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Gorna mzelo xaa mloo xaa kwent, yilotlaka mrezh xaa tub xaa nzeb zyen doo miyon demi lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nu nyent mod kix xaaya lo rey, zee lee rey nzhé: “To gu rop xngwnaa xaa ne, nu re xinn xaa lo stub xaa, nu noka to gu rese kwaan nkano xaa, zee roo chep demi kwaan kix xaa lo na”. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Per lee xaa nzeb demi mkichxub lo rey nu ngunaab tub jabor kwaan dub lextoo xaa lo rey nu nzhé xaa: “Blesla lu ne lu na; chuwlazh kix na reseya lo lu. Nayét lu lee na nakixta.” ");
INSERT INTO zpoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nu lee rey mlesla ne xaa, nu msela rey xaa mod tub xaa nik tub kwaan nanzebt. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Per gorna mroo xaa lo rey, nu mzhaal xaa tub xaa nzeb lakse demi lo xaa, nu mzen xaa yenn xaa, nu msiyenn xaa xaa, nu nzhé xaa lo xaa: “¡Bdix kwaan nzeb lu lo na!” ");
INSERT INTO zpoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lee xmig xaa mkichxub lo xaa nu ngunaab jabor kwaan dub lextoo lo xaa nu nzhé xaa: “Blesla lu ne lu na; chuwlazh kix na reseya lo lu. Nayét lu lee na nakixta.” ");
INSERT INTO zpoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Per namzeyalt xaa, nu mbezh xaa xaa nu mloo xaa xaa lozhyib, axta ke kix xaa re kwaan nzeb xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kwaanzee nales doo ngok lextoo re xaa nkee zhiin lo rey. Nu ngwa xaa nzhé xaaya lo rey, re kwaan mle xaa zee stub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Zee lee rey mrezh xaa nu nzhé lo xaa ba: “¡Xaa nakap doo! Mlesla na ne na lu lo re kwaan nzeb lu lo na sinka ngunaab lu jabor lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Leeka medid kwaan mlesla na ngune na lu, leeka medid ba nzhaal lesla lu ne lu wechxinn lu.” ");
INSERT INTO zpoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Zee nayii doo rey lo xaa nu zee mloo rey xaa lozhyib, nu nzhé rey lo xaa nkanap roo lozhyib, zee teed doo xaa xaa bid, axta paro yilo kix xaa rese kwaan nzeb xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Zee Jesús nzhé: —Sbaa le Xuz na, xaa nzob naz yiba re gu, chelee kad tub gu nayenlazht gu rese kwaan mle wechxinn gu lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Gorna lee Jesús ngulo ngunii re wdizh ne, mroo xaa yizhyo Galilea nu nzha xaa naz yizhyo cheen Judea stub ta roo yuu Jordán. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nu zyen doo myet nzhake tich xaa nu msekwen xaa re xaa ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Zee lee lak xaa fariseo mbii gax lo Jesús, nu mnabdizh xaa lo Jesús, nel nzhekla xaa kwaan xaa mod zee gaazh xaa tub kwaan tich Jesús, nu nzhé xaa lo Jesús: —¿Che nzho mod laa tub xaabyi xngwnaa xaa chelee me mle me tub kwaan sbaasa lo xaa? ");
INSERT INTO zpoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Lee Jesús mkeb nzhé: —¿Che zer lab gu kwaan nzhé Xkyech Dios, leezha mdexkwaa Dios yizhyo, tubka ngwnaa nu tubka xaabyi mchaal Dios? ");
INSERT INTO zpoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Kwaanzee lee xaabyi roo lo xuz xaa nu lo xnaa xaa nu chelya rop sa xaa, zee rop xaa gak tubka kwerp”. Gn. 2:24 ");
INSERT INTO zpoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kwaanzee nanaktra xaa chop sinka tubka myet nak rop xaa. Kwaanzee nyent mod lux rop sa xaa yalnchelya nel mchaal Dios ropse xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Zee mnabdizh re xaa lo xaa nu nzhé xaa: —¿Chozhiin lee Ches nzhé nzho mod laa xaabyi xngwnaa xaa, nebse zaa xaa tub yech kwaan yé mtexonn xaa me? ");
INSERT INTO zpoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Zee Jesús nzhé: —Ches né kwaan ba lo gu, tant ned doo gu, per yilo nanakta sbaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Loka cho xaa nlaa xngwnaa, me namchaalt nik stub xaabyi, nu ka xaa stub ngwnaa, nle xaa tub jwalt gro doo. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Zee nzhé re nu lo xaa: —Cheleeya sbaa nak kwent cheen xaabyi kwaan sa xaa, mas wen nakat xaa ngwnaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús mkeb né: —Naret xaa nzho mod le kwaane, sinka nebse xaa nakladiizh leya. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nzho xaa nankat ngwnaa nel sbaa ngol xaa, nu nzho zlak xaa nankat ngwnaa nel myet mle zee nayot yek xaa ka xaa ngwnaa, nu nzho zlak xaa nankat ngwnaa nel nzhekla xaa kee xaa zhiin kwent cheen pa nabeyy Dios. Xaa nzhaal yizo kwaane yizoya. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nzhano xaa lak madwin lo Jesús zee zhib Jesús yaa Jesús yek mad zee naab xaa lo Dios kwent cheen mad. Per lee re nu, xaa mseed lo xaa, mgalno re xaa nzheno mad. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Per lee Jesús né: —Nayiit gu lo re madwin, laa gu yiid re madwin lo na, nel lee pa nabeyy Dios nak cheen re xaa nak kwenta re madwin ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nu mzhib xaa yaa xaa yek mad. Zee mroo xaa baa. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lee tub xaa ngwanabdizh lo Jesús, nzhé xaa lo Jesús: —Maestr, ¿cho kwaan wen le na zee nzho mod le na gan yalnaban kwaan tira? ");
INSERT INTO zpoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús mkeb lo xaa nzhé: —¿Chozhiin mnabdizh lu lo na cho kwaan nak kwaan wen? Nik tub xaa wen nyent, nebse Dios nak xaa wen. Per chelee lu nzhekla lu le lu gan yalnaban kwaan tira, blozhaw re wdizh kwaan né Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Xanaya? —nzhé xaa. Zee lee Jesús nzhé: —Naguta lu sa myet lu, nazoblazht lu kano lu stub ngwnaa, nalewannt lu, nagaazht lu tub kwaan nawlit tich sa myet lu, ");
INSERT INTO zpoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nazeret lu diizh lo xuz lu nu lo xnaa lu, nu kela lu sa myet lu modxa nkela lu lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Lee xaa mad nzhé lo Jesús: —Rese kwaane kale na dubse nzexen na. ¿Cho kwaan mas nzho jwalt le na? ");
INSERT INTO zpoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús nzhé: —Chelee lu nzhekla lu gak lu nali, zyaa nu bto rese kwaan nkano lu nu bzaaya lo prob, zee gap lu zyen doo kwaan naz leen yiba, nu breke tich na. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Gorna mbin xaa mad sbaa nzhé Jesús lo xaa, nales doo ngok lextoo xaa nel zyen doo kwaan nzhap xaa nu nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Zee lee Jesús né lo re nu: —¡Nagan doo zeeb tub xaa rik naz leen yiba, pa nabeyy Dios! ");
INSERT INTO zpoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Stub welt nii na lo gu, mas nanagant zeeb tub kamey leen yeer cheen tub aguj, ke tub xaa rik le gan zeeb naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nu gorna mbin nu kwaane, nu nzhé nu: —¿Cho le gan nya leen yiba chol sbaa naka? ");
INSERT INTO zpoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús mwii lo nu, nu né lo nu: —Lo re myet yizhyo ne nyent moda, per Dios rese kwaan nzho mod le Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Zee lee Pér nzhé: —¡Wii lo rese nu, rese kwaan mlaa nu, nu mreke nu tich lu! ¿Cho kwaan le nu gan? ");
INSERT INTO zpoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús nzhé: —Wlipa na nii na lo gu, gorna lee na, Xaa Mzhin Ngok Myet, zoob na nabeey na lo xni cheen na, noka re gu, xaa nzeke tich na, zob naab kwent lo re chiibchop dii cheen be. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wlipa kwaane, loka cho xaa laa li, laa wech, laa bzan nu bal, laa xuz, laa xnaa, laa xinn, laa xleyo, nel nzhekla xaa zaa xaa kwent cheen na, zkayaa xaaya tub gayoo welt mas nu kayaa xaa yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mbizh zee, xaa kwaan non nal nagaknontra zee; nu xaa kwaan nanont nal gak non zee. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Nal za na tub kwent zee ne gu xomod nak pa nabeyy Dios. Leeya nak mod tub fink pa nabeyy tub xaa. Mroo xaa garziil doo nzhakwaan xaa mos kee zhiin fink cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Myaan xaa kix xaa ka xaa tub lal demi kwaan nle xaa gan kee xaa zhiin tub mbizh, nu mxaal xaa re xaa zee kee xaa zhiin fink cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nzekela mbizh mroo xaa nak cheen fink nzhakwaan xaa stub naz xaa kee zhiin lo xaa, nu ngune xaa lo stub naz xaa sbaasa nzo lo xbi. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nu nzhé xaa lo re xaa: “Gwa gu, kee gu zhiin fink cheen na zee kix na kwaan nzhaal le gu gan”. Zee ngwa re xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nu rolta mbizh mroo xaa ngwakwaan xaa stub naz xaa, nu noka nzhazhela yizhyo mroo xaa stuba. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nu stub chutaka nzob mbizh mroo ngwa xaa lo xbi stuba, zee ngune lo stub naz xaa sbaasa nzhi. Zee mnabdizh xaa lo xaa nu nzhé xaa lo xaa: “¿Chozhiin zheta nzhi re gu nee nu nankeet gu zhiin?” ");
INSERT INTO zpoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Zee nzhé re xaa: “Nel nyent cho xaa ree nu kee nu zhiin”. Zee nzhé xaa: “Chaa ya be zee kee gu zhiin fink cheen na”. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Gorna ngulo mzhel yizhyo, lee xaa nak cheen fink mnabeyy enkargad cheen xaa, nu nzhé xaa lo xaa: “Brezh rese xaa mkee zhiin nu bdix ka re xaa, nu bzelo kwaan re xaa mkee zhiin gwluzhtlaka”. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Zee mzhin re xaa mzeeb mkee zhiin leezha mzob stub chutaka mbizh nu lal mle xaa gan kwaan re xaa mkee dub zhe. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Gwluzh gorna mzelo xaa mdix xaa lo re xaa mzeeb yilotlaka, re xaa ne mle xgab mlera xaa gan grora demi, per kad tub xaa mle gan lal kwaan nle xaa gan nkee xaa zhiin tub mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Gorna ngulo ngox mka re xaa, mzelo xaa mdildiizh xaaya kwaan xaa nabeyy fink. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Nzhé re xaa: “Re xaa mzhin gwluzhtlaka tub goraka mkee xaa zhiin. Lee re nu dubse zhe mkee nu zhiin, nu nla doo neey mded doo nu bid, nu lal mdix lu mka nu kwaan re xaa ba.” ");
INSERT INTO zpoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Per lee xaa nak cheen fink nzhé lo re xaa: “Mig, nik tub kwaan nawent nakalet na lo gu. ¿Che namyaant be paro kix na ka gu tub mbizh? ");
INSERT INTO zpoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kwaanzee wen gok lextoo gu kwaan ngox mka gu nu zyaa gu, nel chelee na nzhekla na kix na lal ka gu kwaan re xaa mzeeb gwluzhtlaka, ");
INSERT INTO zpoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","nkano na derech le na kwaan nzhekla na kwaan xdemi na.” ");
INSERT INTO zpoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kwaanzee lee xaa gwluzhtlaka gak xaa yilotlaka, nu lee xaa yilotlaka gak xaa gwluzhtlaka. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús mzen naz nzha xaa naz Jerusalén, zee mbe Jesús re chiibchop nu, xaa mseed lo xaa tub lad, nu né xaa lo nu: ");
INSERT INTO zpoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Nal ne re gu, lee re be ya naz Jerusalén, pa zaa xaa na, Xaa Mzhin Ngok Myet, lo re ngwleyy non nu lo re maestr xaa nlu xtizh Dios, nu yé re xaa ne nzhaal yet na. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Zee zaa xaa na lo re xaa nanakt xaa Israel, nu xizhno re xaa na nu zaa re xaaya yenn na kwaan tub le yed, nu kee xaa na lo krus, nu yet na. Per lee mbizh yon lee na roban stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nu nzha xngwnaa Zebedeo kwaan rop xgann me Chag nu Juan, nu mkichxub me lo Jesús, nu ngunaab me jabor lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Lee Jesús mnabdizh cho jabor nzhekla me. Lee me nzhé: —Gorna nabeyy lu, nzhekla na lee tub xgaan na zob lad li lo lu nu stub mad zob lad rebes lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús nzhé lo rop xaa: —Nanet gu cho kwaan naab gu. ¿Che zye gu ded gu bid kwaan merla deed na? Lee rop xaa nzhé: —Nzho moda. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús nzhé: —Mbay. Ded gu bid kwentaxa deed na bid. Per nyent mod zoob na gu lad li lo na nu lad rebes lo na, nel naleet na za kwaan zee. Kwaanzee zaa Xuz na lo re xaa naklakwent kayaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Leezha mbin xchii nu, xaa mseed lo Jesús kwaane, zee nayii nu ne nu Juan rop Chag. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Per Jesús mrezh re nu, nu né lo nu: —Ne wen gu, lee re xaa nabeyy yizhyo ne, nabeyy doo xaa re xaa nzhi lo xaa, nu seeka re xaa non nabeyy doo xaa re xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Per lo re gu nagakta sbaa, sinka rebes gaka. Loka cho nzhekla gak non lo re gu, xaa zee gak xmos gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nu loka cho nzhekla nabeyy lo re gu, xaa zee gak xaa le xchiin lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nel na nak Xaa Mzhin Ngok Myet, nu nanzhalt na zee le xchiin re xaa lo na, sinka lee na nzhal zee le xchinn lo rese myet, nu yet na zee zii na zyen doo xaa lo yalgut nu za na yalnaban cheen xaa kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Gorna mroo Jesús kwaan re nu, xaa mseed lo xaa, yezh Jericó, zyen doo myet mreke tich re nu Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nu baa nzob chop syeg roo naz, gorna mbin xaa lee Jesús nzhaded, dublegan mrazhe rop xaa nu nzhé xaa: —Xaa Nabeyy, lu nak xaa dii cheen rey David, bles lextoo lu ne lu nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Zee lee re myet nayii lo rop xaa zee, zee nakeet xaa tant bi. Per mas nkee rop xaa bi, nu mbezh xaa: —Xaa Nabeyy, lu nak xaa dii cheen rey David, bles lextoo lu ne lu nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Zee lee Jesús mlaz leen naz, nu mrezh xaa xaa, zee nabdizh xaa lo xaa, nzhé xaa: —Guné nen cho kwaan nzhekla gu le na lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Zee lee rop xaa nzhé: —Xaa Nabeyy, nzhekla nu yani lo nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mles lextoo Jesús ne rop xaa ne, zee mgal Jesús zaalo rop xaa nanyanit zaalo. Nu leeka gorzee lee zaalo xaa nguni, nu mreke xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Gorna lee Jesús merla mzhin gax yezh Jerusalén, mzhin xaa yezh Betfagé naz yi le Olib, Jesús mxaal chop nu, xaa mseed lo xaa, ");
INSERT INTO zpoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nu né xaa lo nu: —Gwa gu yezh kwaan nlu lo be nee. Baa yizhal gu tub burr ma nkadoo rop xinn. Xek gu ma nu yaadno gu ma nee. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nu chelee tub xaa nii lo gu, yé gu lo xaa: “Xaa Nabeyy nkin ma, nal bare nu yiidlaa nu ma”. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kwaane ngok zee mbarlo re kwaan nzhé Dios lo xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, leezha nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Guzh gu lo re xaa Sión: “Wii, lee Rey cheen gu, xaa nadoo nak, nze nzob tich tub burr yeen, xinn tub ma nkee zhiin”. Zac. 9:9 ");
INSERT INTO zpoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Zee lee rop xaa mseed lo Jesús mle kwaan nzhé Jesús lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mbe xaa burr gox nu xinn ma, nu mzhib xaa ler tich ma yeen, zee mzob Jesús tich ma. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nzhi zyen doo myet baa, rol xaa mbek xab leen naz, nu zrol xaa mchoog ram yag nu mbek xaaya leen naz. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nu re xaa nzha delant nu re xaa nzeke tras mbazhe re xaa, mbezh xaa: —¡Chul xaa nak nze dii cheen rey David! ¡Gool be lo xaa nze kwaan yalnabeyy cheen Xaa Nabeyy! ¡Wen nak Dios, xaa nzob naz yiba! ");
INSERT INTO zpoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Gorna lee Jesús mzeeb leen yezh Jerusalén, rese xaa yezh mle doo xgab nu mnabdizh lo re wechxinn xaa, nu nzhé xaa: —¿Cho xaa xaa ne? ");
INSERT INTO zpoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lee re myet mkeb nzhé: —Xaa ne nak Jesús, xaa nzaa kwent kwaan nzhé Dios lo xaa, nu nze xaa yezh Nazaret cheen yizhyo Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Gorna mzhin Jesús yezh Jerusalén, mzeeb xaa leen lach roo yidoo, nu mzelo xaa mloo xaa re xaa kato nu re xaa kazi. Nu mtexche xaa xmes re xaa kachee demi, nu mtexche xaa yagxil cheen re xaa kato palom. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nu nzhé xaa: —Nkeela lo Xkyech Dios nii: “Li na nak yoo pa wdizhno rese xaa stub yezh na”, Jer. 7:11; Is. 56:7 per gu mleya kwenta tub pa nzho wann. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lo lach roo yidoo ngwa re syeg lo Jesús, nu re xaa reenk, Jesús msekwen re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Gorna lee re ngwleyy non nu re maestr, xaa nlu xtizh Dios ngune re kwaan gro kwaan mle Jesús, nu mbin xaa nzhé re madwin naz roo yidoo: “¡Chul nak xaa nze dii cheen rey David!”, zee mas nayii doo re ngwleyy nu re maestr. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Zee nzhé re xaa lo Jesús: —¿Che nanzhont lu re kwaan né re madwin ne lo lu? Jesús nkeb nzhé: —Aja, nzhon naya. ¿Per che zer lab gu Xkyech Dios kwaan nzhé kwaane: “Mle lu zee re madwin gool chul lo lu, nu noka axta re madoo, mad nkeeka laz xnaa, gool lo lu”? Sal. 8:3 ");
INSERT INTO zpoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Zee namlaztra Jesús baa nu nya xaa naz yezh Betania pa mlaz xaa dubse yaal. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Stub mbizh gorna mbare Jesús naz Jerusalén stub welt, ngok nlaan xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ngune xaa lo tub yag ig kwaan nzo roo naz, nu mbii xaa gax loya, per nyent ig loya nebse lag nzeb loya. Zee nzhé xaa lo yag ig: —Nik stub welt nabaretra lu zaa lu xle. Nu leeka gorzee mbizh yag ig. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gorna ne nu re kwaane mdedyall nu, nu mnabdizh nu lo Jesús: —¿Xomod mbizh yag ig leeka nal? ");
INSERT INTO zpoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús mkeb né: —Wlipa na kwaan nii na lo gu, chelee gu tubka ngwii gu lo Dios nu nagakt chop yek gu, nzho mod le gu kwaane nu axta noka yé gu lo yi ne: “Bachii nee nu bla axta leen nistoo”, nu leeya gak. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Rese kwaan naab gu lo Dios, Dios zaaya lo gu nu nela gu lee gu kayaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nu gorna mzeeb Jesús lach roo yidoo kaseed xaa re myet, zee ngwa re ngwleyy non nu re xaa gol lo Jesús nu mnabdizh xaa, zee nzhé re xaa: —¿Cho mzaa diizh le lu re kwaane? ¿Nu cho yalnabeyy nkano lu le lu re kwaane? ");
INSERT INTO zpoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús mkeb nzhé: —Noka na, nabdizh tub kwaan lo re gu. Chelee re gu keb yalnabdizh cheen na, zee nii na lo gu cho mzaa diizh le na re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Cho mxaal Juan, xaa mchubnis re myet? ¿Che Dios mxaal xaa o re myet mxaal xaa? ¡Keb gu lo na nal! Nu lee re xaa mzelo mkediizh kwaan re wechxinn xaa nu nzhé xaa: —Chelee be yé be lo xaa: “Dios mxaal xaa”, zee né xaa lo be: “¿Chozhiin nambint gu xtizh xaa?” ");
INSERT INTO zpoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Per chelee be yé be: “Re myet mxaal xaa…”, per nyent mod yé be sbaa nel nzheb be ne be re myet, nel lee re myet ne lee Juan nak tub xaa mzaa kwent kwaan nzhé Dios lo lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Zee mkeb xaa lo Jesús nzhé xaa: —Nanet nu cho xaa mxaal Juan. Zee lee Jesús mkeb nzhé: —Nixa na naniit lo gu cho mzaa diizh nle na re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nu nzhé Jesús: —Nal za na stub kwent lo gu, zee ne gu cho kwaan nle gu xgab lo kwaane. Tub xaa nkano chop xgann, nu lo xaa yilo nzhé xaa: “Gwayaan lo yo”. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lee xaa mkeb nzhé: “Nayat na”. Per gwluzh mchee xaa xgab cheen xaa zee ngwa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Lee xuz xaa ngunii lo xgann xaa, xaa gwluzh, nu sbaaka nzhé xaa mod nzhé xaa lo xaa yilo. Zee nzhé xgann xaa: “Mbay, nal ya na”. Per nangwat xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Xana rop xaa mle kwaan nzhé xuz xaa? —Xaa yiloya —nzhé re xaa. Nu zee lee Jesús nzhé: —Wlipa na nii na lo gu, xaa ntop demi kwaan nya naz Roma, nu re ngwnaa me nto cho, yilotlaka zeeb pa nabeyy Dios lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nel Juan mbiid lo re gu nu mseed xaa gu naz nali cheen Dios, per nambint gu xtizh xaa; leel re xaa naab demi kwaan nya naz Roma, nu re ngwnaa me nto cho mbin xtizh xaa. Per nixa ngune gu re kwaan ba nu nanglaat gu naletra gu kwaan nawent nu nangwiit gu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Kenzha gu stub kwent nabix kwaan za na: Tub welt ngu tub xaabyi, xaa mxeen yag ub dubse xleyo. Nu msaaw xaa dub welta kwaan ke. Nu mdexkwaa xaa tub pa sii xaa ub, nu mdexkwaa xaa tub yoo naro doo pa nlu dubse xleyo xaa lo xaa. Nu mzaa xaaya kompani lo stub xaa zee nachii xaaya, nu mroo xaa nzha xaa zit. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mzhin mbizh top xaa ub, zee mxaal xaa re xmos xaa nzha lo xaa kanachii xkag ub xaa, zee lerol xaa re ub kwaan top xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per lee re xaa kanachii yag ub mzen re xaa, rol xaa mzaa golp xaa, nu zrol xaa mbit xaa, nu zrol xaa mzaake xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Lee xaa nak cheena mbare mxaal xaa masra zyen xmos xaa, nu lee re xaa kanachiiya mle xaa modxa mle xaa re xaa ngwa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Gwluzhtlaka zee mxaal xaa mer xgann xaa, mle xaa xgab nzhé xaa: “A, xgaan na si gon re xaa xtizh. Nalisa ngu yek xaa.” ");
INSERT INTO zpoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per gorna ngune re xaa lo xgann xaa nak cheen fink, nu nzhé xaa lo re wechxinn xaa: “Xaa ne nak xaa lake reya lo. Nal ne xa gut be xaa, zee lakeya lo re be zee gaka xcheen be.” ");
INSERT INTO zpoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Zee mzen xaa xaa nu mloo xaa xaa tub lad pa nzhaan xaa zee mbit xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Lee nal gorna ya xaa nak cheen fink, ¿cho kwaan nzak gu? ¿Cho kwaan le xaa nak cheen fink kwaan re xaa mkeeya kompani? ");
INSERT INTO zpoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mkeb re xaa nzhé: —Gut xaa xaa, nu nalestra lextoo xaa ne xaa re xaa, nu zaa xaa xleyo xaa lo stub naz xaa, xaa zaa rol xle cheena gorna yilo zaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nu zee nzhé Jesús lo re xaa: —¿Che zer lab gu Xkyech Dios pa nii: “Lee ke kwaan mlebi re xaa nza yoo tub lad, leeya gak tub ke mas kwaan chul doo zob xaa naz skin yoo? Lee Dios, Xaa Nabeyy be mle kwaane; nu ndedyall doo be ne beya.” Sal. 118:22-23 ");
INSERT INTO zpoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kwaanzee nii na lo re gu: Kiib Dios pa nabeyy Dios lo gu, nu zaa xaaya lo stub yezh kwaan zaa xle cheen pa nabeyy Dios, gorna nzhaal zaa xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Xaa ral ke ne nii tira yech xaa; nu chelee ke ne la yek tub xaa, yidese leya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Re xaa fariseo nu re maestr xaa nlu xtizh Dios mzeen re xaa lee kwent nabix kwaan ngunii Jesús nlu nen xomod nle re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kwaanzee nzhekla re xaa zen Jesús leeka gorzee, per nzheb re xaa ne re myet, nel lee re myet mbezh lee Jesús nak xaa nzaa kwent kwaan nzhé Dios lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús mzelo mzaa kwent nabix lo re xaa, nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Nal za na tub kwent. Lee pa nabeyy Dios nak mod tub rey xaa mle yalni cheen yalnchelya cheen xgann xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nu mxaal xaa re xmos xaa yichezh re xaa nakladiizh yiid lo yalni, per nanet re xaa yiid. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mbare xaa mxaal stub naz xmos xaa, nu nzhé xaa lo xaa: “Gwa gu nu guzh gu lo re xaa nakladiizh yiid lo yalni, listla na, ngulola mbit na re xngoon na nu noka re ma msechaa na, ngulola mdexkwaa na rese kwaan gaw re xaa yiid lo yalni, zee nzhaal yiid re xaa lo yalni”. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per lee re xaa nakladiizh yiid lo yalni namlet kas. Tub xaa nzha wii lo xleyo, stub xaa nzhale xnegos. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nu lee stub re xaa ne mzen xmos rey nu mzaa xaaya yenn xaa nu mbit xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Zee lee rey nayii doo, nu mnabeyy xaa re xsoldad xaa zee yiyut re xaa mbit re xmos xaa, nu yizek xaa yezh cheen re xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Zee nzhé xaa lo re xmos xaa: “Rese kwaan nzhi listla gaw re xaa lo jondang, per lee re xaa nakladiizh yiid nanzhaalt yiid xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gwa gu leen naz nu brezh gu rese xaa nzo leen naz zee yiid xaa lo jondang.” ");
INSERT INTO zpoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Lee re mos mroo nu nzha, nu mrezh xaa rese xaa, xaa wen nu xaa nawent, zeesi nguzhe re myet leen yoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Gorna lee rey mzeeb leen yoo mwii lo re xaa, zee mwii xaa lo tub xaa nanakt ler kwaan nzhak re xaa nya jondang. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Zee nzhé xaa lo xaa: “Mig, ¿xomod mzeeb lu nee nu nanakt lu ler kwaan nak re xaa nya pa nchelya xaa?” Per lee xaa namkebt nik tub lan wdizh. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Zee lee rey nzhé lo re xmos xaa: “Bkado nii xaa nu yaa xaa, nu blebi gu xaa lo yalnakaw, pa gonn xaa nu kozhe leyy xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nel zyen doo xaa mrezh Dios per nazyent xaa mleey xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Gwluzh lo kwaane, lee re xaa fariseo ngwa nu myaan re xaa zee yé Jesús tub kwaan nawent lo xaa, zee nzho mod gaazh xaa tub kwaan tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Zee mxaal xaa lak xaa mseed lo xaa kwaan lak xaa Herod, zee yé re xaa: —Maestr, ne nu wli kwaan nii lu, nu wlipa nlu lu modxa nzhekla Dios, nu nanlet lu kwaan nzhé re myet, nel nanzhebt lu nii lu kwaan wli lo re xaa non. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kwaanzee guné, nen xomod le nu kwaane: ¿Che nzhaal kix nu lo xaa kwaan ntop demi kwaan nya naz Roma o nanzhaalt kix nuya? ");
INSERT INTO zpoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús ngunela lee re xaa nzhekla zen xaa tub tramp, nel nawent nzhak lextoo xaa, zee nzhé xaa: —¡Gu nak xaa nkade nu nanlet gu kwaan wen! ¿Chozhiin nzhekla gu zen gu na tub tramp? ");
INSERT INTO zpoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Blu gu tub demi kwaan naab César lo gu lo na. Zee mlu xaa tub demi lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nu lee Jesús mnabdizh: —¿Cho yek nkee loya nu cho le nkee xana? ");
INSERT INTO zpoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Re xaa mkeb nzhé: —Cheen César, xaa nabeyy Roma. Zee lee Jesús nzhé: —Mbay. Zaa gu lo César kwaan nak xcheen César, nu bzaa gu lo Dios kwaan nak xcheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Gorna mbin re xaa kwaane mdedyall xaa, nu mlaa re xaa xaa nu nya re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Leeka mbizh zee lee lak xaa saduceo ngwasewii lo Jesús. Lee re xaa saduceo mbezh nyent mod roban re myet xaa ngut, kwaanzee ngwa xaa lo Jesús nu mnabdizh xaa lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestr, Ches mkee lo Xkyech Dios nzhé: “Chelee tub xaabyi, xaa mchelya ngut nu nik tub xinn xaa namlaat xaa, zee lee wech xaa nzhaal chelya kwaan xngwnaa xaa ngut, zee kano xngwnaa xaa mad, zee naluxt dii cheen wech xaa”. Dt. 25:5 ");
INSERT INTO zpoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tub welt gazh wech xaa. Lee xaa yilotlaka mchelya, ta ngut xaa. Nu nik tub xinn xaa namlaat xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Seeka mded wech xaa xaa rop, mod xaa yilo; nu seeka ngok kwaan wech xaa, xaa yon; nu seeka ngok axta ngulo nguxoob gazh wech xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Gwluzh ngulo ngut re xaa noka ngwnaa ngut. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kwaanzee chol roban re xaa, ¿xana xaa gak xmbyi me, nel yizasa gazh wech xaa mka me? ");
INSERT INTO zpoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús mkeb lo xaa nzhé: —¡Tira nguyo gu! Nanlata re kwaan nkee lo Xkyech Dios yek gu, nixa nanlabeyyt gu re kwaan nzho mod le Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gorna lee re xaa ngut roban, re xaabyi nu re ngwnaa nachelyatra xaa, nel gak xaa mod re mandad cheen Dios, re xaa nzhi yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nal nii na lo gu, wli roban re xaa ngut. ¿Che zer lab gu mer kwaan nzhé Dios: ");
INSERT INTO zpoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Lee na nak Dios cheen Abraham, Dios cheen Chak, Dios cheen Kob”? Ex. 3:6 ¡Nu Dios nanakt Dios cheen re xaa ngut, lee Dios nak Dios cheen re xaa mban! ");
INSERT INTO zpoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gorna mbin re myet kwaane, mdedyall doo xaa mbin xaa kwaan mlu Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nu gorna mbin re fariseo lee Jesús msaaw roo re xaa saduceo zee mzhaal re xaa tubka. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nu nel nzhekla xaa zen xaa Jesús kwaan tub tramp, zee lee tub maestr xaa nlu xtizh Dios, xaa nze kwaan re xaa, mnabdizh lo Jesús: ");
INSERT INTO zpoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—¿Xana kwaan mkee Ches nak mas kwaan non lo rese kwaan mnabeyy Dios le be? ");
INSERT INTO zpoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús nzhé: —“Nzhaal kela lu Xdios lu kwaan dub lextoo lu, nu kwaan dub yalnaban cheen lu, nu kwaan dub yek lu.” Dt. 6:5 ");
INSERT INTO zpoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kwaane nak kwaan mas non lo rese wdizh. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nu lee stuba nak mer lal kwaan kwaane: “Nzhaal kela lu wechxinn lu kwentaxa nkela lu lu”. Lv. 19:18 ");
INSERT INTO zpoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chop wdizh ne nak kwaan nzelo xan rese ley nu re kwaan nzhé re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Leeka gorzee lee re xaa fariseo, seetaka nzhi. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Nu lee Jesús mnabdizh lo re xaa nu nzhé xaa: —¿Cho kwaan nle gu xgab cheen Xaa Xaal Dios Nabeyy? ¿Cho dii yaad xaa? Re xaa mkeb nzhé: —Dii cheen David. ");
INSERT INTO zpoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús mkeb nzhé: —¿Xomod mlole David Xaa Xaal Dios Nabeyy: “Xaa Nabeyy lo na”, leezha ngunii xaa kwaan Mbi Naban cheen Dios? Nel David mkee: ");
INSERT INTO zpoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dios, Xaa Nabeyy rese kwaan, nzhé lo Xaa Nabeyy lo na: “Zob lad li lo na, axtaka chezhin na rese xaa nayii ne lu zee kichxub xaa lo lu, nu zee gak xaa mod tub kwaan zhib lu nii lu tich”. Sal. 110:1 ");
INSERT INTO zpoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Xomod nzho mod yaad xaa dii cheen David nu leeka David mlole xaa: “Xaa Nabeyy lo na”? ");
INSERT INTO zpoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nik tub xaa nyent mod keb nik stub lan wdizh lo xaa. Nu mzheb re xaa nabdizhra xaa lo Jesús zhe zee. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Gwluzh lo kwaane Jesús nzhé lo re myet nu lo re nu, xaa mseed lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Lee re maestr xaa nlu xtizh Dios nu re fariseo nkano xaa ley cheen Ches kwaan nlu xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kwaanzee bin re guya nu ble gu kwaan né xaa. Per nareket gu tich mod nle xaa, nel lee re xaa mbezh le tub kwaan nu nle xaa stub kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nu nzhib xaa kwaan nga doo tich stub xaa, xaa nyent mod wee. Nu lee xaa nik chep nakagt choya, per nik kwaan kwen yaa xaa nakaant choya. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nyula xaa le xaa rese kwaan, zee ngwii re myet respet lo xaa. Nyula xaa wee xaa kaj dik kwaan narora xep, pa nzho tik Xkyech Dios leen, naz lechuzh xaa nu tich yaa xaa. Nu nyula xaa nzhak xaa ler wen kwaan nzhak re ngwleyy. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nyula xaa zob xaa pa non lo yalni, nu nyula xaa zob pa non pa nkasa be nseed be xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nu nyula xaa kichyek re xaa lo xaa gorna nii xaa “dix” lo xaa lo xbi, nu wen nzhak lextoo xaa nii re xaa “maestr” lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Per lo re gu nanzhaalt nii re xaa “maestr”, nel re gu nak mod wech na, nu tubka Maestr nkano gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nu naniit gu “xuz na” lo tub xaa yizhyo ne, nel tubka Xuz gu nkano gu, xaa nzob naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nu nixa nanzhaalt nii re xaa lo gu “xaa nabeyy” nel Xaa Mxaal Dios Nabeyy, nebse xaa zee nak Xaa Nabeyy lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Xaa mas non lo re gu, xaa zee nzhaal kee xchiin gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nel lee xaa nto yalxwa, zhin mbizh ton xaa; nu lee xaa nantot yalxwa, zhin mbizh gak non xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ay, bid doo ded re gu fariseo nu re gu maestr, xaa nlu xtizh Dios! ¡Gu nak xaa nkade nu nanlet gu kwaan wen! Nel nsaaw gu pa nabeyy Dios, nixa nanzheklat gu zeeb gu nu nixa nanlat gu zeeb stub naz myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ay, bid doo ded re gu fariseo nu re gu maestr, xaa nlu xtizh Dios! ¡Gu nak xaa nkade nu nanlet gu kwaan wen! Nu nkiib gu li re ngwnaa byud, nu seetaka nzhedizhno gu Dios xchee doo, zee wii re xaa respet lo gu. ¡Per mas gro doo bid ted Dios gu! ");
INSERT INTO zpoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ay, bid doo ded re gu fariseo nu re gu maestr, xaa nlu xtizh Dios! ¡Gu nak xaa nkade nu nanlet gu kwaan wen! Gu nya nze leen nistoo nu lo yizhyo zee kwaan gu tub xaa nanakt xaa Israel, zee nseed lu xaa xcheen Dios, per gorna nle guya, nle gu xaa xchop welt mas nakapra xaa ke gu, zee nya xaa lo ki pa nya re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ay, bid doo ded re gu, xaa nzhekla luu naz lo stub xaa, per syeg nak gu! Nel nzhé gu: “Chelee tub xaa le tub trat nu cheroo xaa lo yidoo cheen Dios, nik tub kwaan namlet xaa trat. Per chelee xaa cheroo xaa lo or kwaan nzho leen yidoo cheen Dios, zeesi mle xaa trat.” ");
INSERT INTO zpoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Xaa bxen nu xaa syeg! Lee yidoo cheen Dios mas non lo or, nel yidoo cheen Dios mle nzhul or kwaan nzho naz leena. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Noka mbezh gu: “Chelee tub xaa le tub trat nu cheroo xaa lo mdo kwaan nzo leen xkyidoo Dios, namlet xaa trat nik tub kwaan. Per chelee xaa cheroo xaa lo gon kwaan nzhib lo mdo, zeesi mle xaa trat.” ");
INSERT INTO zpoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Syeg! Lee mdo mas non lo gon, nel mdo nak kwaan nle nzhul gon. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kwaanzee xaa ncheroo lo mdo kwaan nzho leen xkyidoo Dios noka lo gon kwaan nzhib lo mdo ncheroo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nu seeka xaa ncheroo lo yidoo cheen Dios, nancheroot xaa nebse lo yidoo cheen Dios, sinka noka lo Dios, xaa nzho baa, ncheroo xaa lo. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nu seeka xaa ncheroo naz yiba, ncheroo xaa pa nzob Dios nabeyy xaa, noka lo Dios xaa nabeyy baa, ncheroo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ay, bid doo ded re gu fariseo nu re gu maestr, xaa nlu xtizh Dios! ¡Gu nak xaa nkade nu nanlet gu kwaan wen! Nel nzaa gu gon lo Dios, tub part lo chii part re xcheen gu axta re btyonxtil, nu komin, nu re yix naye. Per nanlet gu kas re kwaan mas non kwaan mnabeyy Dios, kwenta kwaane: Ble gu kwaan nali, bles lextoo gu ne gu wechxinn gu nu nye bzo gu lo Dios. Re kwaane nak kwaan nzhaal le gu, nu noka re kwaan nzhaal zaa gu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Syeg rese gu, nanlaat gu keb gu tub ngruuzh, per nanzeent gu mdeb gu tub kamey. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ay, bid doo ded re gu fariseo nu re gu maestr, xaa nlu xtizh Dios! ¡Gu nak xaa nkade nu nanlet gu kwaan wen! Nel wen nzet gu naz tich re bas nu naz tich re yann, per lee leen lextoo gu nyazhe re kwaan mlewann gu nu re kwaan nzoblazh gu kano gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo syeg! Yilotlaka naz leen bas nu naz leen yann zet gu, zeera nzho mod zet gu naz ticha. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ay, bid doo ded re gu fariseo nu re gu maestr, xaa nlu xtizh Dios! ¡Gu nak xaa nkade nu nanlet gu kwaan wen! Nel gu nak mod tub baa kwaan rus na naz ticha, per lee naz leena nzho zhit cheen xaa ngut, nu duzna kwaan nanambeyt. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sbaa nak gu naz tich, nalal wen doo nak gu lo re myet per lee naz leen lextoo gu nzho re yalxwa nu re kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ay, bid doo ded re gu fariseo nu re gu maestr, xaa nlu xtizh Dios! ¡Gu nak xaa nkade nu nanlet gu kwaan wen! Nel ndexkwaa gu yoo chul, pa nak baa cheen re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo nu re baa cheen re xaa mle kwaan nali. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Zee mbezh gu: “Chol nzhila be yilo, leezha mbit re xey be re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, nanglet be yudar ngut be xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nebse sbaa mbezh re gu, lee gu nak dii cheen re xaa mbit re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kwaanzee gulo ble gu re kwaan mle re xey gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Mball wiz, dii cheen re mball wiz nayii! ¿Xomod roo gu pa xaal Dios gu lo ki kwaan nayuyyt tira, pa ded gu bid? ");
INSERT INTO zpoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kwaanzee xaal na re xaa zaa kwent kwaan yé Dios lo lee xaa, nu re xaa nkano yalnzhak nu re maestr lo gu. Per gu gut xaa nu zrol xaa kee gu lo krus, nu zrol xaa zaa golp gu pa nkasa be nseed be xtizh Dios, nu renal gu xaa tub yezh nu stub yezh. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kwaanzee tich gu kwib re ren cheen re xaa mle kwaan nali, re xaa mbit xaa yilo. Ren cheen Bel, xaa mbit xaa yilotlaka, nu axta ren cheen Zacari xgann Berequías, xaa mbit xaa xsaww lo pa nzek xaa gon lo Dios nu roo yidoo cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wlipa na nii na lo gu, lee re jwalt cheen re xaa mbit re xaa zee, la tich re myet, xaa nzhi mbizh nal. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Xaa Jerusalén, xaa Jerusalén, gu nzhut re xaa nzaa kwent kwaan nzhé Dios lo lee xaa yilo, nu nzaake gu re xaa nxaal Dios lo gu. Zyen welt nzhekla na ngtop na re xinn gu, kwentaxa ngo kolek re xinn kolek xan xiil kolek, per nanzheklat guya. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wii gu, nik stub kwaan nalaketra li gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nu na nii lo gu, nal gornetlaka nanetra gu lo na, axta zhin mbizh kwaan yé gu: “¡Gool be lo xaa nze kwaan yalnabeyy cheen Xaa Nabeyy!” ");
INSERT INTO zpoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Gorna lee Jesús nyaze mroo lach roo yidoo, lee re nu, xaa mseed lo xaa mbii gax lo xaa, nu mlu yidoo lo re nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Zee Jesús né lo re nu: —¿Che nlu re kwaane lo gu? ¡Wlipa na nii na lo re gu, nik tub ke ne nalaketra tich sa ke ke, rese kwaane lux! ");
INSERT INTO zpoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Gorzee nzha Jesús naz yek yi le Olib, zee mzob xaa baa, zee lee re nu mbii gax lo xaa, zee mnabdizh nu lo techosa xaa nu nzhé nu lo xaa: —Nzhekla nu né lu lo nu cho gor gak re kwaane. ¿Cho nseyn gak gorna merla bare lu, nu gorna merla lux yizhyo? ");
INSERT INTO zpoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús mkeb lo nu, nu né xaa: —List gok gu zee nik tub xaa nakadet gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nel yo zyen doo xaa yé: “Na mkayaa yalnabeyy lo Jesús”. Nu noka yé xaa: “Na nak Crist, Xaa Mxaal Dios Nabeyy”, nu sbaa kade xaa zyen doo myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Per gorna gon gu lee dil nzho nee nu nzho naz baa, nazhebt gu, nel see nzhaal gaka. Per nalet re kwaane nak kwaan lux yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lee re yezh dil kwaan stub yezh nu lee pa nabeyy tub rey dil kwaan pa nabeyy stub rey, nu la win nu zyen doo pa nye doo gun xog. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Re kwaane gak kwenta yalne cheen ngwnaa, gorna merla gal xinn me. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Zee zaa xaa gu lo re xaa ted gu bid mod nzhekla xaa, zee gut xaa gu. Nu rese xaa yizhyo yii ne gu, nel nzaa gu kwent cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mbizh zee zyen doo xaa laa na nu nawiitra xaa lo na, zee yii xaa nu zen xaa tramp tub xaa nu stub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Zee yiid zyen doo xaa yé lo re xaa: “Lee na nzaa kwent kwaan né Dios lo na”, nu nawlit xaaya, zee kade xaa zyen doo myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nu yo zyen doo xaa nakap doo gak, nu zyen doo xaa nakelatra re wechxinn. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per loka xaa ye ded re kwaane axta gwluzhtlaka, xaa ba le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nu lee re wdizh chul cheen pa nabeyy Dios rech dubse yizhyo, zee ne re xaa rese yezh kwaan wli. Zeera lee yizhyo lux. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Zee gorna wii gu lee kwaan nakap doo kwib pa nanzhaalt kwiba, modxa nzhé Daniel, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo (xaa lab kwaane nzhaal laya yek xaa), ");
INSERT INTO zpoNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","zee lee re xaa nzho yizhyo Judea nzhaal xonn xaa nu nya xaa naz yi. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Zee lee xaa nzob yek li, nayatra leen li xaa koo xaa xcheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nu lee xaa nzha naz wen, nabaretra xaa top xaa xab xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ay, nales doo gak re ngwnaa me nakxiin mbizh zee, nu re ngwnaa me nkee madoo laz. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Naab gu lo Dios zee nagakt kwaane mbee kwaan nla doo nal, nixa nagakta zhe sab. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwaanzee re mbizh zee, gak tub mbizh mas bid doo ded re xaa, ke re bid kwaan mded re xaa axta leezha mdexkwaa Dios yizhyo nu axta mbizh zee, nu nadedtra xaa bid snee stub bes gwluzh. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nu chol Xaa Nabeyy nanglerolt re mbizh zee, nik tub xaa nanget axta gwluzh. Per lee xaa mlerola nel nkela xaa re xaa mleey xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Nu mbizh zee chelee tub xaa nii lo gu: “Wii nee, lee Xaa Mxaal Dios Nabeyy nzo nee. Wii nee, lee Xaa Mxaal Dios Nabeyy nzo baa”, nagont gu xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nu yiid re xaa kade; nu re xaa né: “Na nak Xaa Mxaal Dios Nabeyy”, nu zlak xaa né: “Na nak xaa nzaa kwent kwaan né Dios lo na”, per nawlit xaaya. Zyen doo kwaan gro doo le xaa, nu luu xaa re nseyn gro doo zee kade xaa re myet, axta re xaa mleey Dios kade xaa, chol nzho moda, per nyent moda. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ngulola ngunii naya lo gu nal. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kwaanzee chelee xaa né xaa lo gu: “Gwa gu, lee xaa nzo naz wen”, nayat gu; nu chelee xaa né xaa lo gu: “Gwa gu, lee xaa nzholaan nee”, nagont gu xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nel leezha yal na, Xaa Mzhin Ngok Myet, yal na mod balngwzi kwaan nroo tub ta yiba nu nyetlo stub ta yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nel loka paro nax tub ma ngut, baa ndop re ngolbech. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Gorna ngulo nguxoob mbizh ded re xaa bid gro doo, zee lee mbizh nazaatra xni, nu lee mbee nazaatra xni, nu lee re mbal gab leen yiba, nu lee re kwaan nzho naz leen yiba xiz. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Zee lee nseyn cheen na, Xaa Mzhin Ngok Myet, luu naz leen yiba lo rese myet xaa nzho leen re yezh lo yizhyo ne. Le doo re xaa xgab nu gonn doo re xaa, nel ne re xaa lee na nyal leen xkaw naz yiba, kwaan yalnabeyy gro doo cheen na nu kwaan xni chul cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nu xaal na re mandad cheen na, zee kwezh xaa trompet nye doo, zee lee re mandad top re xaa mleey na dubse yizhyo, axta pa mas zit lo yizhyo nu lo yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Bseed gu lo yag ig, gorna lee re ram cheena merla koo lag, zee ne gu lee mbee kwaan la neey zhin gaxla. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kwaanzee gorna ne gu lee re kwaane kayakla, zee ne gu lee na, Xaa Mzhin Ngok Myet, listla nzo na roo pwert yal na. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Wlipa na kwaan nii na lo gu, rese kwaane yilo gak zeera yet re myet xaa nzho re mbizh zee. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lee yiba nu yizhyo lux, per lee xtizh na naluxt. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Nik tub xaa nanet pa gor zhin mbizh zee, nixa re mandad cheen Dios naneta, nixa na, xaa nak mer Xgann Dios, nanet na pa gor, nebse Xuz na ne pa gora. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Modxa ngok re mbizh cheen Noé seeka gak gorna merla bare na, Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Re mbizh cheen Noé, gorna zeeraka la yey kwaan lux yizhyo nu axta mbizh kwaan mzeeb Noé leen bark, lee re myet seetaka nzhaw nu nzho nu nchelya. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nel tira nanlet re xaa xgab la yey kwaan lux yizhyo, nu lee yey mzelo mla zee ngut re xaa leen nis. Sbaaka gak gorna yal na, Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mbizh zee chop xaabyi nzha naz wen, tub xaa wee xaa nu stub xaa lakeka xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nu chop ngwnaa nkayoo lo molin, tub me wee xaa nu stub me lakeka xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Kwaanzee tubka list bzo gu nel nanet gu cho gor yal na, Xaa Nabeyy lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Per nzhaal la kwaane yek gu: Chelee xaa nak li tub yoo nela cho gor yiid tub wann yaal lewann garli xaa, tubka list zo xaa, nu nalaat xaa zeeb nik tub xaa leen li xaa lewann xcheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kwaanzee noka re gu list bzo gu, nel na, Xaa Mzhin Ngok Myet, yal mer gor kwaan tira nanlet gu xgab. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Cho nak mos wen? Lee mos wen nak xaa mlaa xpatron xaa garli xaa, zee zaa xaa kwaan gaw re xaa gorna zhin gor gaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chul doo nzhak lextoo mos, xaa kale kwaan nzhé xpatron xaa lo xaa, gorna lee xpatron xaa bare. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nu wlipa na nii na lo gu, lee xpatron xaa le gak xaa xaa nabeyy lo rese kwaan nzhap xpatron xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per chelee mos zee le xgab: “Nayat xpatron na nal”. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Lee xaa mzelo mdin re xmos xpatron xaa, nu mzelo xaa ndaw xaa nu ngu xaa kwaan re nguy. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nu lee mbizh kwaan nanlet xaa xgab nu gor kwaan nanlet xaa xgab, lee xpatron xaa bare yaad. ");
INSERT INTO zpoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nu ted xaa xaa gro doo bid, nu xaal xaa xaa leeka pa nzho re xaa nkade nu nanlet kwaan wen, zee gonn xaa nu kozhe leyy xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Nal za na tub kwent nen xomod nak pa nabeyy Dios. Leeya nak mod tub chii ngwnaa mad, me mroo kwaan bruj cheen, zee kayaa me xaa chelya. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gaay me nachan nu gaay me list. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lee gaay me nachan mzen xbruj per nambet me anseyt kwaan chezhe meya stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Per lee stub gaay me list mbe xbruj nu mbe me anseyt cheen me zee chezhe meya stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nu lee xaabyi ngok tras, nu lee re ngwnaa mzen mkaal lo, nu tira ngot me. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nu kan wall yaal mbin re me tub bos kwaan nzhé: “Lee xaabyi nzela, broo gu, dexkwaa gu yek xbruj gu zee kayaa gu xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Zee lee re ngwnaa mad nguxche nu mdexkwaa me yek bruj cheen me. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Zee lee gaay ngwnaa mad, me nachan, nzhé lo gaay me list: “Zaa gu chep anseyt gu koo nu leen xbruj nu, nel nzhekla xbruj nu yuyy”. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Per lee ngwnaa me list nzhé lo gaay me nachan: “Nazaat nuya nel napa nagalta le xchiin guya nu le xchiin nuya, mas wen gwa gu pa nto xaaya nu bzi gu xcheen gu”. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Per gorna lee gaay me nachan nzhazi anseyt, nu lee xaabyi, xaa chelya me mzhin, nu lee zgaay me listla mzo mkayaa xaa, nu mzeeb me kwaan xaa chelya me leen yoo pa nzho jondang. Nu msaaw xaa roo yoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Gwluzh mzhin gaay me nachan nu nzhé me: “Xaa nabeyy, xaa nabeyy, xal roo yoo zee deed nu”. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Per lee xaa mkeb nzhé: “Wlipa na nii na lo gu, nanlabeyy na gu”. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Zee nzhé Jesús: —Kwaanzee tubka bloo gu mkaal lo gu, nel nanet gu pa zhe nu cho gora. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Nal zan stub kwent cheen pa nabeyy Dios. Leeya nak mod tub xaabyi xaa roo ya stub ta yizhyo. Nu mrezh xaa re xmos xaa zee kanap xmos xaa re xdemi xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Lo tub xaa mzaa xaa gaay bools demi nu lo stub xaa mzaa xaa chop bools demi, nu lo stub xaa mzaa xaa tub bools demi, lo kad tub xaa mzaa xaaya nel ne xaa xomod kano xaaya zhiin. Nu zee mroo xaa nzha xaa zit. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Lee xaa mkayaa gaay bools demi mkanoya zhiin nu mle negos, zee mle xaa gan stub gaay bools demi lo gaay bools demi kwaan mkayaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Seeka lee xaa mkayaa chop bools demi mle xaa gan stub chop bools demi lo chop bools demi kwaan mkayaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per lee xaa mkayaa tub bools demi, nya nu mdeen tub yeer lo yo nu mlozhaw xdemi xpatron xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Zyen doo liin mded zeera mbare xpatron xaa, zee mloo xaa kwent kwaan xaa mkayaa xdemi xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yilotlaka mrezh patron xaa mkayaa gaay bools demi, nu lee xaa ne mzaa gaay bools kwaan mkayaa xaa nu mzaa stub gaay boolsa. Nu nzhé xaa: “Xaa nabeyy, mzaa lu gaay bools demi lo na, per nal za na stub gaay bools demi kwaan mle na gan loya”. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Lee xpatron xaa nzhé: “Xmos na, wen doo mkee lu zhiin nu nali doo mle luya. Nali doo ngok lu lo chepse kwaan mza na lo lu, lee nal za na masra lo lu. Nu nix doo kwi rop be nal.” ");
INSERT INTO zpoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Zeera mrezh patron xaa mkayaa chop bools demi, nu lee xaa ne mzaa chop bools kwaan mkayaa xaa nu mzaa stub chop boolsa. Nu nzhé xaa: “Xaa nabeyy, mzaa lu chop bools demi lo na, per nal za na stub chop bools demi kwaan mle na gan loya”. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Lee xpatron xaa nzhé: “Xmos na, wen doo mkee lu zhiin nu nali doo mle luya. Nali doo ngok lu lo chepse kwaan mza na lo lu, nu lee nal za na masra lo lu. Nu nix doo kwi rop be nal.” ");
INSERT INTO zpoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Per gwluzhtlaka mrezh patron xaa mkayaa tub bools demi, nu lee xaa ne nzhé lo xpatron: “Xaa nabeyy na, ne na lee lu nak tub xaa nakap doo, nu nzhaan lu pa nanakt xleyo lu nu ntop lu yalgon pa naleet lu ngoon. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kwaanzee mzheb na ne na lu zee mkaxlaan na xdemi lu leen lo yo. Per nal lee xdemi lu nee.” ");
INSERT INTO zpoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Per lee xpatron xaa mkeb lo xaa nzhé: “Lusi nak tub mos nawent nu tub xaa nchaab doo, nel néla lu, lee na nzhaan pa nanakt xleyo na nu ntop na yalgon pa naleet na ngoon. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kwaan ngle lu nak nzhaal ngo lu xdemi na bank, zee gorna ngbare na ngzaa lu re kwaan mzaa na lo lu nu ngzaa lu re xinna kwaan mleya gan.” ");
INSERT INTO zpoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nu nzhé xpatron xaa lo re xaa: “Kiib bools demi kwaan mza na lo xaa ba, nu zaaya lo xaa nkano chii bools demi. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nel xaa nkanoya zaa xaa masraya lo xaa, nu axta nzhobre kwaan zaa xaa lo xaa. Per lee xaa kwaan nankanota axta chep kwaan nkano xaa yiib lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bzen gu xaa nchaab nu blebi gu xaa naz jwer lo yalnakaw, paro gonn xaa nu kozhe leyy xaa.” ");
INSERT INTO zpoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Gorna lee na yal, Xaa Mzhin Ngok Myet, dubse cho na la xni, nu yal na kwaan re mandad cheen na, xaa nambey nak. Nu zoob na pa nla xni chul doo pa nabeey na. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Lee rese myet xaa yizhyo kwi dubse naz delant lo na, nu koxcho na xaa, modxa ngoxcho xaa mbakxiil lo chib. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mbakxiil kwek na lad li lo na nu lee chib kwek na lad rebes lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Lee na nak Rey, nu yé na lo xaa nzhi lad li lo na: “Te re gu, xaa mzaa Xuz na re kwaan wen lo, zee kayaa gu pa nabeyy Xuz na, kwaan mdexkwaa xaa gak cheen re gu, axta gorna zeeraka dexkwaa yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nel ngok nlaan na nu mzaa gu kwaan ndaw na, ngok nzhek lextoo na nu mzaa gu nis nguu na, mkanze na nyent pa yoo na nu mzaa gu pa ngot na, ");
INSERT INTO zpoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nyent ler gak na nu mzaa gu ler ngok na, ngok ne na nu mbidsewii gu lo na, ngu na lozhyib nu mbid gu lo na.” ");
INSERT INTO zpoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Zee lee re xaa nali, xaa nzhi lad li lo na, nabdizh lo na: “Xaa Nabeyy, ¿cho gor ngune nu lo lu lee lu ngok nlaan, nu mzaa nu kwaan ndaw lu? ¿Nu cho gor ngune nu lo lu lee lu ngok nzhek lextoo nu mzaa nu nis ngu lu? ");
INSERT INTO zpoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Nu cho gor ngune nu lo lu lee lu nyent pa yo nu mzaa nu pa ngot lu? ¿Nu cho gor ngune nu lo lu lee lu nyent ler gak nu mzaa nu ler ngok lu? ");
INSERT INTO zpoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Nu cho gor ngune nu lee lu ngok ne nu mbidsewii nu lo lu, nu cho gor ngune nu lee lu ngu lozhyib nu mbidsewii nu lo lu?” ");
INSERT INTO zpoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Zee lee Rey keb nzhé: “Wlipa na nii na lo gu, rese kwaan mle gu lo tub wech na, nixa nak xaa tub xaa sbaasa, noka lo na mle guya”. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Zee lee na, xaa nak Rey, yé na lo re myet xaa kwaan nzhi lad rebes lo na: “Bachii rese gu lo na, xaa nxobde na. Zyaa re gu lo ki kwaan tira nayuyyt, kwaan mdexkwaa yo Maxuu kwaan re mandad cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nel ngok nlaan na nu namzaat gu kwaan ndaw na, ngok nzhek lextoo na nu namzaat gu nis nguu na. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mkanze na nu nyent pa yoo na nu namzaat gu pa ngot na. Nyent ler gak na nu namzaat gu ler ngok na, ngok ne na nu nambidsewiit gu lo na, nu ngu na lozhyib nu nambidsewiit gu lo na.” ");
INSERT INTO zpoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Zee lee re xaa nabdizh lo na: “Xaa Nabeyy, ¿cho gor ngune nu lo lu lee lu ngok nlaan, nu namzaat nu kwaan ndaw lu? ¿Nu cho gor ngune nu lo lu lee lu ngok nzhek lextoo nu namzaat nu nis ngu lu? ¿Nu cho gor ngune nu lo lu lee lu nyent pa yo nu namzaat nu pa ngot lu? ¿Nu cho gor ngune nu lo lu lee lu nyent ler gak nu namzaat nu ler ngok lu? ¿Nu cho gor ngune nu lee lu ngok ne nu nambidsewiit nu lo lu nu cho gor ngune nu lee lu ngu lozhyib nu nambidsewiit nu lo lu?” ");
INSERT INTO zpoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Zee lee Rey keb nzhé: “Wlipa na nii na lo gu, rese kwaan namlet gu lo tub wech na, nixa nak xaa tub xaa sbaasa, noka lo na namlet guya”. ");
INSERT INTO zpoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Re xaa ne nya ded bid kwaan tira, nu lee re xaa nali nya le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Gwluzh ngulo ngunii Jesús re kwaane, né xaa lo re nu, xaa mseed lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Re gu ne nzho jwalt xchop mbizh la yalni kwaan le Paskwa, zee selazh be xomod mloo Dios re xey be Egipto. Zee lee na, Xaa Mzhin Ngok Myet, zaa xaa na lo xaa kee na lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Re mbizh zee lee re ngwleyy non nu re xaa gol lo re xaa sawlazh be, ngwa re xaa li Caifás, xaa nak ngwleyy non doo. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Zee myaan re xaa zen xaa Jesús, zee gut xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Per nzhé re xaa: —Nalet beya lo yalni, zee nayiit re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús nzo yezh le Betania, garli Simón, xaa ngok ne lo tub yalyizh kwaan nyall cho xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nee lee tub ngwnaa nzhano tub bot dik kwaan mdexkwaa kwaan ke le alabastro, kwaan nyazhe perfum kwaan chul doo nzebech leena nu kwaan kar doo non. Gorna lee Jesús kayaw lee me mxo kwaan ba yek xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lee nu, xaa mseed lo Jesús nguneya, zee nayii re nu, nu nzhé re nu: —¿Chozhiin mlux me kwaan ba? ");
INSERT INTO zpoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nzho mod ngdooya kar doo, zee ngzaa be demi lo re xaa prob. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús mbin kwaane nu nzhé xaa: —¿Chozhiin ngalno gu ngwnaa ne? Lee kwaan kale me lo na nak kwaan wen doo. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nel lee re xaa prob tubka nzo lo re gu, nu nzho mod le gu wen lo xaa gorna nzhekla gu, per lee na, nazot na lo gu tubka. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Per lee ngwnaa ne mle me kwaan nzho mod le me, mlo me perfum ne cho na gorna zeeraka sebyo re xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Wlipa na nii na lo gu, dub yizhyo pa zaa xaa Kwent Chul cheen na, zet xaa noka kwaan mle ngwnaa ne, zee selazh xaa me. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judas Iscariote xaa nak tub xaa lo re chiibchop nu, xaa mseed lo Jesús, ngwa lo re ngwleyy non. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nu nzhé xaa: —¿Lak kix gu ka na, zee za na Jesús lo re gu? Zee lee re xaa nzhé: —Kix nu tub galbchii demi plat ka lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nu leeka gorzee lee Judas mkwaan mod ne xomod zaa xaa Jesús lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nu mzhin mbizh yilotlaka cheen yalni kwaan le Paskwa, pa nzhaw be pan kwaan nanyut lebadur. Nu noka nzhaw be mbakxiil kwaan nteed be zee nselazh be xomod mloo Dios xey be Egipto. Nu lee nu, xaa mseed lo Jesús nzhé lo xaa: —¿Pa nzhekla lu yadexkwaa nu kwaan gaw be yalni ne? ");
INSERT INTO zpoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Lee Jesús mkeb né: —Gwa gu garli tub xaa, nu guzh gu lo xaa: “Lee maestr né: ‘Mzhinla gor cheen na, nu yal na garli lu zee gaw re nu, xaa mseed lo na, xchee kwaan le Paskwa.’” ");
INSERT INTO zpoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Lee rop nu mle modxa né xaa lo nu. Nu mdexkwaa xaa kwaan gaw xchee re nu cheen Paskwa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gorna ngulo mla yalchool, Jesús kayaw kwaan re chiibchop nu, ");
INSERT INTO zpoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","nu gorna kayaw re nu, Jesús né: —Wlipa na nii na lo gu, leeka tub gu zaa na lo re xaa nayii ne na. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Re nu nales doo ngok lextoo nu, nu tubga nu tubga nu nabdizh lo xaa, nu nzhé nu: —Xaa Nabeyy, ¿che naya? ");
INSERT INTO zpoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús mkeb né: —Tub xaa nle bsii pan leen tubka yann kwaan naya, xaa ba zaa na lo re xaa nayii ne na. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lee na Xaa Mzhin Ngok Myet, nzhaal ded na doo bid mod nii Xkyech Dios, per tira nawent ded xaa zaa na lo re xaa. Mas wen nzela xaabyi zee nangalt xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zee lee Judas, xaa zaa Jesús lo re xaa nayii ne Jesús, mnabdizh nu nzhé lo Jesús: —Maestr, ¿che naya? —Lu néya —nzhé Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nu gorna kayaw re nu, lee Jesús mzen pan, nu mzaa xaa dixkix lo Dios, nu mlerol xaaya, nu mzaa xaaya lo re nu. Nu né xaa: —Daw guya, kwaane nak xbaal na. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Zee mzen xaa tub bas kwaan nzho xis ub, nu mzaa xaa dixkix lo Dios nu mted xaaya lo re nu, nu né xaa lo re nu: —Gu gu xis ub kwaan nzho leen bas ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kwaane nak xren na. Leeya dexkwaa wdizh kub kwaan laa Dios, nu leeya xo na zee zhe jwalt cheen zyen doo myet. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Per wlipa na nii na lo gu, nabaretra na go na xiz ub ne, axta mbizh gorna go naya stub welt kwaan gu pa nabeyy Xuz na. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Gorna ngulo mbill re nu, nu nzha re nu naz yi kwaan le Olib. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Zee lee Jesús né lo re nu: —Nalyall laa re gu na, nel Xkyech Dios niiya: “Gut na xaa nkano mbakxiil, nu lee re mbakxiil rech reta naz”. Zac. 13:7 ");
INSERT INTO zpoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per gwluzh gorna roban na, yilotlaka na zhin yizhyo Galilea lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Zee nzhé Pér lo xaa: —¡Per nixa rese xaa laa lu, per tira nalaat na lu! ");
INSERT INTO zpoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús nzhé lo xaa: —Wlipa nii na lo lu, leeka nalyall, zeeraka kozhe gaay, lee lu yé chon welt nanlabeyyt lu na. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nu lee Pér mbare nzhé: —Per nixa yet na kwaan lu, per nayét na lee na nanlabeyyt lu. Nu rese nu, xaa mseed lo xaa, nzhé leeka kwaan nzhé Pér. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Zee nzha Jesús kwaan re nu, xaa mseed lo xaa, leen tub yilo kwaan le Getsemaní, nu né xaa lo re nu: —Neeka brika re gu, lee na ya wdizhno Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nu mbe xaa Pér nu Juan nu Chag, rop xgann Zebedeo, nu mzelo lextoo xaa mxonn doo nu nales doo nzhak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Zee nzhé xaa: —Nales doo nzhak lextoo na kwenta tub xaa mer yet. Blakeka gu nee nu nagaat gu, tubka zo gu kwaan na. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Zee lee Jesús mze delant xep, nu mkichxub xaa nu axta ngol lechuzh xaa lo yo, nu mdizhno xaa Dios nzhé xaa: —¡Ay, Xuz na! Nalaat lu deed na bid ne, per nagakta kwentaxa nzhekla na, sinka kwentaxa nzhekla lu gaka. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Zeera mbare xaa pa mlaa xaa yon xaa nu gorna mzhin xaa lo xaa; lee yon xaa naxna. Zee nzhé xaa lo Pér: —¿Che nik tub gor nayet gu lo mkaal? ");
INSERT INTO zpoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Blo gu mkaal lo gu nu bdizhno gu Dios zee nakiilt Maxuu gu. Lee xgab cheen gu nzhekla le kwaan nyakla Dios, per lee baal cheen gu nayet leya. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mrop welt ngwa xaa mbdizhno xaa Dios nu nzhé xaa: —¡Ay, Xuz na! Cheleeya nyent mod nadedt na bid ne, bleya mod nzhekla lu. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Zee mbare xaa paro mlaa xaa yon xaa stub welt, nu gorna mzhin xaa lee yon xaa naxna, nel nayetra xaa lo mkaal. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nu zee ngwa xaa stub welt nu mdizhno xaa Dios. Ngunii xaa leeka re kwaan nzhé xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Zee mbare xaa pa mlaa xaa re nu, xaa mseed lo xaa, nu né xaa: —¿Che seetaka naxna gu? ¡Nal kenzha gu! Mzhinla gor lee na, Xaa Mzhin Ngok Myet, zaa xaa na lo re xaa mle jwalt. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Guxche gu, chaa gu nya be, nel nzela xaa zaa na lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús seetaka kanii lo re nu, lee Judas, xaa ngok tub xaa lo re chiibchop nu, mzhin kwaan zyen doo xaa nzeno spad nu nzeno yag. Re xaa ne nze kwent cheen re ngwleyy non, nu cheen re maestr, xaa nlu xtizh Dios, nu kwent cheen re xaa gol. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ngulola nzhé Judas nseyn lo re xaa: —Loka xana xaa gaw na bit garlo, xaa zeeya; zen gu xaa nu wee gu xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nu gorzee lee Judas mbii gax lo Jesús nu nzhé: —¿Ma lu, Maestr? Nu gorzee ndaw xaa bit tagarlo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús mkeb lo xaa nzhé: —Mig, kwaan nze lu le lu, bleya. Zee lee re xaa mbii lo Jesús, nu mzen xaa Jesús nu mbe xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Per tub xaa nzo kwaan Jesús mloo spad nu mchoog tub lad nzha xmos ngwleyy non doo. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Zee Jesús nzhé: —Blochaw spad cheen lu pa nzhoya, nel rese xaa kwaan nzhut kwaan spad leeka kwaan spad yet xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Che nanet gu chelee na naab na lo Xuz na, xaal xaa tub chiibchop mil mandad cheen xaa nal gornetlaka? ");
INSERT INTO zpoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per chol sbaaya, ¿xomod gak re kwaan nkee lo Xkyech Dios kwaan nzhé snee nzhaal gaka? ");
INSERT INTO zpoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesús nzhé lo re myet: —¿Chozhiin nze gu kwaan spad nu kwaan yag zen gu na kwenta tub wann? Zyen doo mbizh mzo na lo re gu, mseed na re gu lach roo yidoo. Nu nik tub welt namzent gu na. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per rese kwaane kayak zee mbarlo kwaan mkee re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. Mer gorzee lee nu, xaa mseed lo Jesús, mlaa Jesús, nu mrexonn nu nya nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Re xaa mzen Jesús, mbe xaa Jesús garli ngwleyy non doo, xaa le Caifás, paro nzhi re maestr xaa nlu xtizh Dios, kwaan re xaa gol. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Per lee Pér zit zit nzhake tich re xaa, nu gorna mzhin xaa lach jwer garli ngwleyy non doo, zee mzob xaa lo re xaa nkanap roo yoo, nel nzhekla xaa ne xaa xomod yilo le xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Lee re ngwleyy non nu re xaa nak zhiin kakwaan xaa tub kwaan nawlit gaazh xaa tich Jesús, zee gut xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Per nanguzhaalta lo re xaa, nixa zyen doo xaa ngaazh kwaan tich Jesús per duzna nkade re xaa. Gwluzhtlaka mzhin xchop xaa ");
INSERT INTO zpoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nzhé: —Mbin nu lee lu né: “Na lux xkyidoo Dios, nu chonaka mbizh dexkwaa na stuba”. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nu zee lee ngwleyy non doo mzoli lo re xaa, nu mnabdizh lo Jesús nu nzhé xaa: —¿Chozhiin nik tub kwaan namkebt lu? ¿Cho kwaan komba nii re xaa lo lu? ");
INSERT INTO zpoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per lee Jesús nik tub kwaan namkebt lo ngwleyy non doo. Zee lee ngwleyy non doo mbare mnabdizh lo Jesús, nu nzhé xaa: —Kwaan le Dios xaa naban, né: ¿che lu nak Xaa Mxaal Dios Nabeyy? ¿Che lu nak mer Xgann Dios? ");
INSERT INTO zpoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús mkeb nzhé: —Lu néya. Nu wii gu, lee na nak Xaa Mzhin Ngok Myet, zob lad li lo Dios, xaa nzho mod nle rese kwaan. Nu wii gu lee na yal leen xkaw naz yiba stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nu zee lee ngwleyy non doo mchaz xab xaa, nu nzhé: —¡Nankintra be stub testig! ¡Ngulola mbin gu ngunii xaa kwenta Dios! ¿Xomod nle gu xgab lo kwaane? Re gu mbin wdizh nawent kwaan ngunii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Xomod nzak gu lo kwaane? Lee re xaa mkeb, nzhé: —¡Nzhaal yet xaa! ");
INSERT INTO zpoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nu mzelo lak xaa mchuk lo xaa nu mdin xaa xaa. Nu stub naz xaa mgazya ta garlo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nu mbezh xaa: —Lu né nak lu Xaa Mxaal Dios Nabeyy, kwaanzee né, ¿cho xaa mkeeya yek lu? ");
INSERT INTO zpoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lee Pér nzob naz lach jwer garli ngwleyy non doo. Baa lee tub ngwnaa mad, me nkee zhiin lo ngwleyy non doo, mbii gax lo Pér nu nzhé me: —Noka lu nkanze kwaan Jesús, xaa yizhyo Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per lee Pér nzhé delant lo re xaa: —Nanet na cho kwaan né lu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Zee nya Pér mzo naz roo pwert, zee ngune stub ngwnaa me nkee zhiin lo ngwleyy non doo lo xaa, nu nzhé me lo re xaa: —Noka me nee nkanze kwaan Jesús, xaa yezh Nazaret. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Stub welt lee Pér mcheroo, nzhé: —¡Nanlabeyyt na xaa ba! ");
INSERT INTO zpoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Gwluzh xep lee re xaa nzhi baa mbii gax lo Pér nu nzhé xaa: —Wlipa nu, noka lu nreke tich xaa, axta mod nzhadizh lu nluya. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Zee mzelo Pér mde xaa nu mcheroo xaa, nu nzhé xaa: —¡Wlipa na, nanlabeyyt na xaa ba! ¡Nu nanet na cho kwaan zet gu lo na! Nu gorzee lee gaay mbazhe. ");
INSERT INTO zpoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Zee lee Pér mselazh kwaana nzhé Jesús lo Pér yilo: “Zeeraka kozhe gaay, lee lu yé chon welt nanlabeyyt na”. Nu gorna mselazh xaa kwaane, mroo xaa nu mzelo xaa mbinn xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gorna mkaxni yizhyo stub mbizh, rese ngwleyy non nu re xaa gol myaan gut xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Zee mkado xaa yaa Jesús nu mbe xaa Jesús lo Pilat, xaa nabeyy baa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Lee Judas, xaa mzaa Jesús lo re xaa gut xaa, gorna mzeen xaa lee re xaa gut Jesús, ngok nales doo lextoo xaa nu mzere xaa galbchii demi plat kwaan mzaa re ngwleyy non nu re xaa gol lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nu nzhé xaa: —Mle na tub jwalt gro doo nel mza na tub xaa nik tub jwalt nankanot yet. Per lee re xaa mkeb nzhé: —Per nu, nyent cho le nu komba. ¡Komba nak xcheen lu! ");
INSERT INTO zpoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Zee lee Judas mlabi re demi leen yidoo, nu nya xaa nu leeka lee xaa msiyenn xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lee re ngwleyy non mtop re demi nu nzhé re xaa: —Nyent mod kwib re demi ne pa mbib re gon, nel nanambeyt demi ne, nel leeya mzaa be zee yet tub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Zee myaan re xaa zii xaa tub lee leyo, pa ngoo myet yo ndexkwaa xaa yas; zee kano re xaa tub lee leyo pa sebyo xaa re xaa yezh zit, xaa yet zee. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kwaanzee leyo ba le Lach Cheen Ren axta mbizh nalzhe. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sbaa mbarlo re kwaan nzhé Jeremías, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, leezha nzhé xaa: “Mzen re xaa galbchii demi plat, lal nzhé re xaa Israel ka xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nu kwaan demi zee mzi re xaa lach, pa ngoo myet yo ndexkwaa xaa yas. Mle naya modxa mnabeyy Xaa Nabeyy.” Jer. 32:6; Zac. 11:12-13 ");
INSERT INTO zpoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mbe re xaa Jesús lo Pilat xaa nabeyy zee. Nu mnabdizh Pilat lo Jesús nzhé xaa: —¿Che lu nak Rey cheen re xaa Israel? Jesús nzhé: —Sbaa naka, kwentaxa nguné luya lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Gorna lee re ngwleyy non nu re xaa gol mgaazh kwaan nawlit tich Jesús, nu lee Jesús nik tub lan wdizh namkebt, ");
INSERT INTO zpoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","zee lee Pilat mnabdizh lo Jesús: —¿Che nanzhont lu re kwaan gaazh re xaa tich lu? ");
INSERT INTO zpoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per nik tub lan wdizh namkebt Jesús, gorzee lee Pilat tira mdedyall nu nanetra xaa cho kwaan nle xaa xgab. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nu rese liin leezha nla yalni cheen Paskwa, Pilat nsela tub xaa nzho lozhyib, loka xaa naab re xaa yezh sela xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nzho tub xaa le Jesús Barrabás lozhyib, xaa nlabeyy re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nu lee Pilat mnabdizh lo re xaa nzhi baa nu nzhé: —¿Cho nzhekla gu sela na? ¿Che sela na Jesús Barrabás o Jesús, xaa nii re xaa Xaa Mxaal Dios Nabeyy? ¿Cho xaa sela na? ");
INSERT INTO zpoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sbaa nguné nel nela Pilat lee re ngwleyy non nu re xaa gol nzhak selos, kwaanzee ngulaa xaa Jesús lo Pilat. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nu lee Pilat seetaka nzob pa nabeyy, nu lee xngwnaa Pilat mxaal tub xaa nzhé lo xaa: —Nalet lu kwaan nawent lo xaabyi ba, nel nalgwzheze tira nawent mchaa lextoo na kwent cheen xaabyi ba, nu wen nak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per lee ngwleyy non nu re xaa gol, mkiil re xaa nzhi baa zee naab re xaa sela Pilat Barrabás, zee gut Pilat Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Zee lee Pilat mnabdizh stub welt nzhé: —¿Xana tub lo rop xaa ne nzhekla gu sela na? Zee lee re xaa mkeb nzhé: —Bsela Barrabás. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Zee lee Pilat mnabdizh lo re xaa nzhé: —Guné gu, nen cho kwaan nzhekla gu le na kwaan Jesús, xaa nii re xaa Xaa Mxaal Dios Nabeyy. Re xaa mkeb nzhé: —¡Bkee xaa lo krus! ");
INSERT INTO zpoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat nzhé: —Per, ¿cho kwaan nawent mle xaa ne? Per bi nkee re xaa nu nzhé re xaa: —¡Kee xaa lo krus! ");
INSERT INTO zpoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Gorna ngune Pilat nayetra Pilat lo re xaa, nel mas nakap doo nzhak re xaa, zee mnabeyy Pilat xaa yixii nis yanag Pilat, zee wii re xaa kwaan le Pilat. Nu nzhé xaa: —Nyent mod kwib yalgut cheen xaabyi ne tich na; xkwent re gu nak kwaan ba. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Zee lee re myet mkeb nzhé: —¡Tich nuya, nu tich re xinn nu kwib yalgut cheen xaa ne! ");
INSERT INTO zpoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Zee lee Pilat msela Barrabás nu mnabeyy xaa xsoldad xaa zee mdin Jesús nu kee xaa xaa lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Zee lee re soldad cheen xaa nabeyy mbe Jesús lo lach jwer pa nzho Pilat nu mri rese soldad dub welt lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nu mlache xaa xab xaa nu msegak xaa xaa tub ler naxne. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nu lee yek xaa mzob xaa tub koron kwaan nya kwaan yich, nu mlo xaa tub bar yaa xaa lad li. Nu mkichxub re xaa lo xaa modxa nkichxub xaa lo rey, nu mxizhno re xaa xaa, nu nzhé re xaa: —¡Xwa doo Rey cheen re xaa Israel! ");
INSERT INTO zpoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Noka mchuk re xaa lo xaa, nu mla xaa leeka bar kwaan nzho yaa xaa yek xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nu gorna ngulo mzhitno re xaa xaa, zee mloo xaa ler naxne yenn xaa, nu msegak xaa xaa leeka xab xaa. Nu mloo xaa xaa, mbe xaa xaa zee kee xaa xaa lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Gorna nzheno xaa xaa, zee mzhaal xaa tub xaa le Simón xaa yezh Cirene, zee mnabeyy soldad xaa, zee wee xaa xkrus Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nu mbe xaa Jesús tub pa le Gólgota. (Wdizh ne nii: “Zhit Yek Xaa”.) ");
INSERT INTO zpoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nu mzaa xaa xis ub kwaan nzhaal kwaan tub kwaan nala ngo Jesús. Nebse mle Jesús preba, nangutra xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nu gorna mkeela xaa lo krus, zee lee re soldad mloo swert nen cho xaa le gan xab xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nu mzob re soldad baa zee kanap xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nu yek Jesús mkee xaa tub letr kwaan nzhé nen chozhiin mkee xaa Jesús lo krus. Lee letr nzhé: “XAA NE NAK JESÚS, REY CHEEN RE XAA ISRAEL”. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Noka chop wann nkee lo krus, tub xaa nkee lad li lo Jesús nu stub xaa nkee lad rebes lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Re xaa nded lo xaa duzna wdizh nawent nii xaa lo xaa, nu mbib re xaa yek xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nu mbezh re xaa lo Jesús: —Lu né lux lu yidoo nu chonaka mbizh dexkwaa luya stuba. ¡Bsela leeka lu lo krus zee nadedt lu bid, chol Xgann Dios nak lu! ");
INSERT INTO zpoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nu sbaaka mxizhno re ngwleyy non xaa, nu re maestr xaa nlu xtizh Dios nu re xaa gol, ");
INSERT INTO zpoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","nu mbezh re xaa: —Namlaat xaa nget stub xaa, ¿chozhiin nyent mod la xaa leeka xaa lo krus? Né xaa lee xaa nak Xaa Mxaal Dios Nabeyy lo re xaa Israel. Nal la xaa leeka lee xaa lo krus zee wii re nu lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ngwii doo xaa lo Dios, laa zee nalaat Dios ded xaa bid nal, chol sbaa nzhekla Dios. ¿Che nanét xaa lee xaa nak Xgann Dios? ");
INSERT INTO zpoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nu axta rop wann, xaa nkee xkwes xaa mxizhno xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Rolta mbizh dubse yizhyo mla yalnakaw axta las tres mzhel yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Gorzee lee Jesús mbazhe nye doo nzhé: —Elí, Elí, ¿lama sabaktani? (Wdizh ne nii: “Xdios na Xdios na, ¿chozhiin mlaa lu na?”) Sal. 22:1 ");
INSERT INTO zpoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nu lak xaa nzo zee, mbin kwaan ngunii xaa, zee nzhé xaa lo re xaa: —Bkenzha gu. Lee xaa kabezh Li, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Gorzee lee tub xaa ngwakwaan tub lee xiil, nu mchub xaa xis ub kwaan ni doo chooya, nu mkado xaaya yek tub le yi, nu mzeb xaaya roo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Per lee stub naz xaa nzhé: —Laa, zee ne be nen che zyiid Li la xaa lo yalgut. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús mbazhe nye doo stub welt nu ngut. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nu lee ler kwaan nyaaw roo Pa Nambey Doo leen yidoo, mzelo mraz axta yek nu axta xan, nu ngoka chop lee. Nu lee tub xog mgun nu lee re ke ngok rol. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nu lee roo re baa mxal; nu axta zyen doo re myet, xaa ngut, xaa nambey nak, mroban stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Zee mroo xaa leen xbaa xaa. Gwluzh gorna ngulo mroban Jesús, mzeeb re xaa ne leen yezh Jerusalén, yezh kwaan nambey nak, nu baa zyen doo xaa ngune lo re xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Gorna lee xaa nabeyy lo tub gayoo soldad nu re soldad kwaan nkanap Jesús, ngune mgun xog, nu gorna ngune xaa re kwaan mded, mzheb doo xaa nu nzhé xaa: —Wlipa, lee xaa ne nak Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nu zyen doo ngwnaa, me mreke tich Jesús axta yizhyo le Galilea, me mle yudar xaa, mzo zit ngwii. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lo re me ba mzo Mari, me yezh Magdala, nu Mari xnaa Chag nu Che, nu xnaa xgann Zebedeo. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Gorna nzhelala yalchool, mzhin tub xaa rik, xaa le Che, xaa nak xaa yezh le Arimatea. Noka xaa ne mreke tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Che ngwa lo Pilat nu ngunaab xaa kwerp cheen Jesús. Zee lee Pilat mnabeyy zee mzaa re xaaya lo Che. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nu mzen Che xkwerp Jesús nu mchaal xaaya kwaan tub lee ler nzhul, tub lee ler kwaan non doo. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nu mlo xaa Jesús leen tub baa kub, kwaan nak mer cheen Che, kwaan mdeen xaa leen tub ke. Nu msaaw xaa tub ke naro doo rooya nu nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Per lee Mari me Magdala nu stub Mari mlakeka nzob gax roo baa. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Stub mbizh, gorna ngulo mded mbizh kwaan ndexkwaa re be kwaan gaw be zhe sab, lee re ngwleyy non nu re xaa fariseo ngwa lo Pilat, ");
INSERT INTO zpoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nu nzhé re xaa lo xaa: —Xaa nabeyy, mselazh nu lee xaabyi ba, xaa kwaan tant mkade, nguné xaa leezha zer yet xaa: “Gwluzh yilo ded chon mbizh, lee na roban stub welt”. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwaanzee nabeyy zee kanap xaa baa cheen Jesús axta yixoob yon mbizh, napa lee re xaa mseed lo xaa, ya yixii kwerp cheen xaa yaal, nu yé xaa lo re myet: “Lee xaa mroban stub welt”. Kwaan zee gak tub kwaan mas kade xaa re myet ke yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat nzhé: —Nkano gu re soldad, gwa gu kanap gu roo xbaa Jesús axta paro nzho moda lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Zee ngwa re xaa zee mkee xaa tub sey cho ke kwaan nyaaw roo baa, zee yaww wena, nu mlaa xaa re soldad kanap roo baa. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ngulo mded zhe sab, gorna ngulo mkaxni yizhyo zhe dming garziil, lee Mari me yezh Magdala kwaan stub Mari ngwa ngusewii roo baa pa mlo xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gorzee lee tub xog mgun nye doo leen yizhyo nel lee tub mandad cheen Dios mla naz lo yizhyo, nu mbii xaa roo baa nu mre xaa ke kwaan nyaww roo baa, nu mzob xaa ticha. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Lee mandad mla doo xni xab xaa mod balngwzi, nu lee xab xaa na rus doo mod na yeg. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Gorna ngune re soldad kwaane, nebse nxiz re xaa tant mzheb doo xaa, nu tira mkaw re xaa, mod tub xaa ngut. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lee mandad nzhé lo rop ngwnaa: —Nazhebt gu. Na ne lee gu nzekwaan Jesús, xaa mkee re xaa lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nyentla xaa nee, ngulola mroban xaa, modxa né xaa lo re gu. Te gu nu wii gu, nyentla xaa paro mdix xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Prad zyaa gu nal nu guzh guya lo re xaa mseed lo xaa, lee xaa mrobanla. Nu yilotlaka xaa ya yizhyo Galilea lo re gu. Baa ne gu lo xaa. Kwaan ba nak kwaan nii na lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nu gorzee lee rop ngwnaa mroo xonn mroo leen baa, nel mzheb doo me nu noka nyakdoola me. Nu mrexonn me né meya lo re nu, xaa mseed lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nu leeka gorzee lee Jesús ta mreke lo rop me. Nu ngunii xaa “dix” lo rop me. Nu lee rop me mbii lo Jesús, nu mdeezh me nii xaa nu mbill me lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nu nzhé Jesús lo me: —Nazhebt gu. Zyaa gu nu guzh gu lo re wech na zee ya xaa naz yizhyo Galilea, nu baa zhaal xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Gorna lee re ngwnaa nya, lee lak soldad xaa nkanap roo baa ngwa Jerusalén, nu mzaa xaa kwent lo re ngwleyy non re kwaan ngok. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Zee lee re ngwleyy non mrezh re xaa gol, zee yaan re xaa lal. Nu mzaa xaa zyen doo demi lo re soldad, ");
INSERT INTO zpoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nu nzhé xaa lo re soldad: —Yé gu lo re myet: “Yaal, gorna lee re nu ngot, lee re xaa mseed lo Jesús mbid mlewann xkwerp Jesús”. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nu chelee Pilat ne kwaane, re nu seleyy xaa zee nateedt xaa gu bid. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Zee lee re soldad mkayaa re demi, nu mle xaa re kwaan nzhé re xaa gol lo xaa. Nu kwaan nzhé re soldad, nzet re xaa sawlazh be axta mbizh nalzhe. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Zee lee re chiibtub nu, xaa mseed lo Jesús, nya naz yizhyo Galilea, yi kwaan nzhé Jesús lo nu. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nu gorna ngune re nu lo Jesús, mbill nu lo Jesús, nixa nzho lak nu seetaka ngok ned lextoo. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús mbii gax lo re nu, nu né xaa lo re nu: —Dios mzaa dubse yalnabeyy lo na naz leen yiba nu naz lo yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nal gwa gu lo rese myet, xaa nzhi dubse lo yizhyo, nu ble gu zee gak re xaa xaa seed lo na, nu bchubnis gu xaa kwaan yalnabeyy cheen Xuz na, nu kwaan yalnabeyy cheen na, xaa nak xgann Xaa, nu kwaan yalnabeyy cheen Mbi Naban cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nu bseed gu re xaa le xaa re kwaan mseed na gu. ¡Nu ne gu, lee na zo lo re gu rese mbizh, axta gorna lux yizhyo!");
INSERT INTO zpoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Snee mzelo wdizh chul cheen Jesucrist, xaa nak Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Snee nzhé kwaan mkee Chay, xaa mxaal Dios zaa kwent kwaan nzhé Dios lo lee xaa, gorna nzhé xaa: Wii gu, xaal na tub mandad yilo ke lu, xaa zee dexkwaa naz ze lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nu dub gan snee yé xaa naz wen: “Bdexkwaa gu xnaz Xaa Nabeyy; bxal gu tub naz nali ze xaa”. Is. 40:3 ");
INSERT INTO zpoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Snee mbarlo kwaan nzhé Chay gorna mzhin Juan Xaa Nchubnis re myet tub pa naz wen. Juan nchubnis re myet, re xaa mlaa naz nawent nu mwii xaa lo Dios, zee kiib Dios jwalt kwaan mle xaa. Snee mzaa Juan kwent lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nu zyen doo myet yezh gro Jerusalén, nu re yezh win pa nabeyy Judea mzhin mkenzha xtizh Juan. Nu konxa mzaa re myet kwent re jwalt kwaan mle xaa, zee mchubnis Juan xaa leen yuu Jordán. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nu yich led kamey nak xab Juan, nu nzii tub yed leen Juan. Nu lee kwaan nzhaw Juan nak mbeso, nu kwaan nzho Juan nak mzhin wen. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan nzaa kwent cheen Dios, nu nzhé xaa: —Tich na nze stub xaabyi mas non ke na. Nanont na zee nyent mod xek na tich xkyelyed xaa, nel nonra xaabyi zee lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na nchubnis gu kwaan nis, per lee xaabyi zee chubnis re gu gorna xaal xaa Mbi Naban cheen Dios lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tub mbizh mroo Jesús yezh Nazaret, yizhyo kwaan le Galilea, nu mzhin xaa pa kachubnis Juan re myet, zee mchubnis Juan xaa leen yuu Jordán. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nu gorna mroo Jesús leen nis, mwii xaa lee yiba mxal, nu lee Mbi Naban cheen Dios mroo nyaadla naz leen yiba nu mla cho Jesús mod tub palom. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Zee mbin xaa tub bos kwaan mroo naz yiba, nzhé: —Lu nak xgaan na, xaa nkedoola na, nu nix doo nzhak lextoo na ngwii na lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Zee mbe Mbi Naban cheen Dios Jesús naz wen. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ngu Jesús tub choo mbizh pa nzho re ma wen, zee mkiil Maxuu Jesús. Zeera lee re mandad cheen Dios myaad mkanap Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mzhin tub mbizh mlo xaa Juan lozhyib, nu lee Jesús ngwa yizhyo kwaan le Galilea, nu mzaa xaa kwent cheen wdizh chul cheen Dios, ");
INSERT INTO zpoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","nu nzhé xaa: —Mzhin gaxla mbizh kwaan mleey Dios, gorna lee Dios nabeyy lo rese myet. Blaa gu naletra gu kwaan nawent nu wii gu lo Dios, nu ble gu krer wdizh chul cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús nzhaze roo nistoo le Galilea leezha ngune Jesús lo Simón, nu wech Simón xaa le Ndres. Lee rop xaa nak xaa nzen mbal. Kagobi xaa xkyeez xaa leen nistoo zee zen xaa mbal. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zee nzhé Jesús lo xaa: —Breke gu tich na zee le na gu xaa zere myet lo Dios, kwentaxa nzen gu mbal. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Leeka gorzee mlaa rop xaa xkyeez xaa nu mreke xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nu nzhaze Jesús mas naz delant, zee ngune xaa lo rop xgann Zebedeo, Juan rop Chag. Nzho xaa leen tub kano. Kagobde xaa xkyeez xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Zee mrezh Jesús rop xaa ne. Nu leeka gorzee mlaa xaa xuz xaa Zebedeo kwaan re mos, xaa nkee zhiin lo xaa leen kano, nu lee rop wech xaa mreke tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nu mzeeb xaa yezh Capernaum zhe sab, zhe kwaan nzholl re nu, xaa Israel, lo Dios. Nu mzeeb Jesús leen tub yoo pa nkasa nu nseed nu xtizh Dios, nu mzelo xaa mseed xaa re myet kwaan nzhi zee. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nu mdedyall doo re xaa nzhon xaa re kwaan nlu Jesús, nel nseedra Jesús kwaan yalnabeyy ke re maestr, xaa nlu xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nu leen yoo paro nkasa re xaa, nzo tub xaa nzho mbi mal lextoo. Nu mbazhe xaa nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Chozhiin mzhin lu lo nu Jesús, xaa Nazaret? ¿Che nze lu lux lu nu? Nlabeyy na lu, ne na lee lu nak Xaa Nzhul, xaa nze lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús mgalno mbi mal nu nzhé: —¡Bsaaw rool! ¡Broo lextoo xaa ne! ");
INSERT INTO zpoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Zee lee mbi mal mle zee mzhib xaa yizhgutye stub welt, nu gorzee lee mbi mal mrazhe nye doo nu mroo lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nu rese xaa nzhi zee mdedyall doo. Nu mnabdizh xaa lo wechxinn xaa nu nzhé xaa: —¡Yisutisuti! ¿Cho kwaan kwaane? Xaa ne nlu duzna re kwaan nanet be, nu axta nabeyy xaa lo re mbi mal nu nzhona xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nu zeesi, lijer doo mbin re xaa kwaan mle Jesús dubse naz yizhyo kwaan le Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nu gorna mroo Jesús pa nkasa nu nseed nu xtizh Dios, zee mbe Simón rop Ndres xaa garli Simón nu noka Juan rop Chag nzha kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nu lee xnaazhap Simón nzho loon nel ne nzak me, nlen me xlee. Nu gorna mzhin Jesús, zee nzhé re xaaya lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Zee lee Jesús mbii gax lo me nu mzen yaa me, nu mlis xaa me. Leeka gorzee lee xlee mroo cho me, nu mzaa me kwaan ndaw re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gorna nzeyaaz mbizh, zee ngwano re xaa re xaa ne nzak lo Jesús, nu re xaa nzho mbi mal lextoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nu rese xaa yezh mkasa roo yoo pa nzo Jesús, ");
INSERT INTO zpoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","zee msekwen Jesús re xaa ne nzak, nu re xaa nzak reta klas yalyizh. Nu mloo Jesús zyen mbi mal lextoo re myet. Nanlaat Jesús nii re mbi mal, nel nela re mbi mal cho nak Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nu garziil doo nguxche Jesús mroo xaa, nzha xaa tub pa nzhekla xaa zo techosa xaa, zee wdizhno xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón nu re wechxinn Simón nkwaan re xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nu gorna nguzhal Jesús lo xaa, zee nzhé xaa lo Jesús: —¡Rese xaa kakwaan lu! ");
INSERT INTO zpoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Per lee Jesús nzhé lo re xaa: —Chaa gu ya be re yezh nzhi gax nee, zee za na kwent xtizh Dios lo rese xaa nzho baa, nel kwaanzee nzhal na le na. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesús mkanze leen rese yezh kwaan nzhi yizhyo Galilea, nu mzaa xaa kwent xtizh Dios leen yoo pa nkasa nu nseed nu xtizh Dios. Noka mloo xaa mbi mal lextoo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nu mzhin tub xaa nyall cho lo Jesús, zee mkichxub xaa lo Jesús nu dub lextoo xaa ngunaab jabor lo Jesús, nzhé xaa: —Chelee lu nzhekla lu, nzho mod sekwen lu na lo yalyizh ne. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús mles lextoo ngune xaa, nu mgal cho xaa, zee nzhé Jesús lo xaa: —Nzhekla na, gakwen lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Leeka gorna ngunii Jesús lo xaa, ngokwen xaa nu ngok nzhul xaa lo yalyizh. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Zee nzhé Jesús lo xaa: —Nik tub kwaan nayét lu lo re myet. Gwa lo ngwleyy zee wii xaa lo lu, zee né xaa lee lu ngokwenla. Nu bzaa gon kwaan mnabeyy Ches, kwaan nzaa xaa nzhakwen yalyizh kwaan nyall cho, zee ne rese myet lee lu ngokwenla. ");
INSERT INTO zpoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Zee mlaa xaa Jesús nya xaa, per lee xaa ne gorna nya xaa nzhé xaaya lo re myet, lee xaa ngokwenla. Kwaanzee nyentra mod zeeb Jesús leen yezh, zee mlake Jesús naz wen, nel nyentra mod zeeb Jesús sbaasa. Per zyen doo xaa rese yezh nya lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Zee mbare Jesús yezh Capernaum, nu nzhala lak mbizh zeera mbin re xaa lee Jesús nzho leen li tub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nu lijer doo mkasa zyen doo xaa. Nixa naz roo yoo nagaltra kwi re xaa, zee mzaa xaa kwent xtizh Dios lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tap xaa nzeno tub xaa mdeen lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nu nel nzhi doo xaa, nanzaat lugar zeeb xaa yino xaa xaa ne lo Jesús. Zee mtexoob xaa xaa naz yek yoo. Nu mxal xaa tub tik yek yoo, zeera mzaa lugar msela xaa dub yag mdeen paro nzo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nu gorzee mzeen Jesús lee re xaa nzeno mdeen ngwii lo Dios, zee nzhé Jesús lo xaa mdeen: —Xgaan, lee re jwalt cheen lu ngulola mzhe. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Per zee nzob lak maestr, xaa nlu xtizh Dios, nu mle xaa xgab leen lextoo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Chonoon sbaa nzhedizh xaa ne? Kwenta Dios nzhedizh xaa. Nyent cho xaa nzho mod chee jwalt, nebse Dios.” ");
INSERT INTO zpoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Per lee Jesús nela cho xgab nle re maestr, zee nzhé Jesús lo xaa: —¿Chozhiin sbaa nle gu xgab? ");
INSERT INTO zpoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Cho kwaan nzak gu? ¿Cho kwaan mas nanagant yé na lo xaa ne nzak: “Ngulola mzhe re jwalt cheen lu”, o sekwen na xaa ne nzak nu yé na lo xaa: “Guxche, bzen xkag lu nu zyaa”? ");
INSERT INTO zpoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Le na kwaane lo gu, zee wii gu lee na nkano yalnabeyy chee re xjwalt gu, nel lee na nak Xaa Mzhin Ngok Myet. Kwaanzee nzhé Jesús lo xaa mdeen: ");
INSERT INTO zpoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Guxche. Zen xkyag lu, nu zyaa garli lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Gorzee mzoli xaa mdeen, nu mzen xaa xkyag xaa, nya xaa. Rese xaa nguneya ndedyall xaa, mbill xaa lo Dios, nzhé xaa: —¡Yisutisuti! ¡Tira zer ne be lo tub kwaan snee! ¡Dios nle kwaan gro doo! ");
INSERT INTO zpoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nu zeera mroo Jesús leen yezh, nzha xaa naz roo nistoo stub welt, zee mkasa zyen doo myet lo xaa. Nu mzelo xaa mseed xaa re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Gorna nzhaded Jesús roo yoo paro nzob Leví, xgann Alfeo, xaa ntop demi kwaan nya naz Roma, zee nzhé Jesús lo xaa: —Breke tich na. Zee nguxso xaa, nu mreke xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ngulo mded kwaane, zee ngwa Jesús garli Leví nu ndaw xaa kwaan re xaa ntop demi, nu re xaa nzeb jwalt, nu re xaa mseed lo Jesús, nel zyen re xaa nzeb jwalt nreke tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nu gorna ngune re maestr nu re fariseo lee Jesús kayaw kwaan re xaa nzeb jwalt, nu kwaan re xaa ntop demi, zee nzhé xaa lo re xaa mseed lo Jesús: —¿Chozhiin nzhaw xmaestr gu kwaan re xaa ntop demi, nu kwaan re xaa nzeb doo jwalt? ");
INSERT INTO zpoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Gorna mbin Jesús kwaane zee nzhé xaa lo re xaa: —Xaa nanet nzak, nankint xaa zee doktor, per lee re xaa ne nzak, xaa zee nkin doktor. Nanzhalt na kwezh na re xaa wen, lee na nzhal kwezh re xaa nzeb jwalt. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Re xaa mseed lo Juan nu re fariseo nkwan xaa gorna nanzhawt xaa nik tik kwaan, kwaanzee mbiid re xaa lo Jesús nu nzhé xaa: —¿Chozhiin nkwan re xaa mseed lo Juan nu re xaa kaseed lo fariseo, per lee re xaa kaseed lo lu nakwant xaa? ");
INSERT INTO zpoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús nzhé: —Ble gu xgab kwaane. Nyent mod le gu zee kwan re xaa nzho jondang zee nagawt xaa, gorna lee xaa kachelya nzoka kwaan re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per zhin tub mbizh wee xaa xaa kachelya; nu gorna zhin mbizh ba, zeesi lee re xaa nzhaal kwan nu nagawt xaa nik tub kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Nik tub xaa nakobdet tub lee ler kub cho tub lee ler gox, nel lee ler kub ndop zee mas chaza ler gox, nu zee nyentra mod le xchiin xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nu nixa nangot xaa xis ub kwaan kub leen mbud yed gox. Nel lee xis ub kwaan kub gorna yixooba chaza mbud yed gox. Zee lee xis ub kwaan nzho leena xo nu lee mbud lux. Kwaanzee lee xis ub kwaan kub nzhaal yo leen tub mbud yed kub. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nu zhe sab, zhe kwaan nzholl re nu lo Dios, lee Jesús nzhaze wen pa mgaan xaa nzhobxtil. Nzhaze re xaa nzha xaa, lee re xaa mseed lo Jesús mzelo mtop son nzhobxtil. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Zee lee re xaa fariseo, nzhé lo Jesús: —¿Chozhiin nle re xaa nreke tich lu kwaan ba, kwaan nanzhaalt le be zhe sab? ");
INSERT INTO zpoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús mkeb nzhé: —¿Che zer lab gu Xkyech Dios, kwaan mle David leezha ngok nlaan xaa nu ngok nlaan re wechxinn xaa nu nkin xaa kwaan gaw xaa? ");
INSERT INTO zpoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Zee lee David mzeeb leen yidoo cheen Dios, leezha ngu Abiatar ngwleyy non doo zee, nu ndaw David pan kwaan mzhib xaa lo Dios, kwaan nyent mod gaw re xaa, kwaan nebse re ngwleyy nzho mod gaw. Nu lee David mzaaya ndaw re xaa nzhake tich David. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Lee Jesús nzhé lo re xaa: —Zhe sab mdexkwaa Dios zee deed wen re myet, nu namdexkwaat Dios re myet zee nabeyy zhe sab lo myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kwaanzee na nabeey lo zhe sab, nel na nak Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Stub welt mbare Jesús mzeeb pa nkasa nu seed nu xtizh Dios, nu baa nzo tub xaa mbizh yaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nu lee lak xaa nzob ngwii, ne che sekwen Jesús yaa xaa, zhe sab, zhe kwaan nzholl nu lo Dios, zee kwaan xaa mod gaazh xaa kwaan tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Zee nzhé Jesús lo xaa mbizh yaa: —Guxso, nu bzo xsaww lo rese xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nzhé Jesús lo re xaa: —¿Xomod nzhé wdizh kwaan mkee Ches? ¿Cho kwaan nzho mod le be zhe sab, kwaan wen o kwaan nawent? ¿Che wen sekwen xaa tub xaa, o che wen gut xaa tub xaa? Per nik tub xaa namkebt, rese xaa zheta mri. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús mnayii doo mwii lo re xaa nzhi lo xaa, nu nales doo ngok lextoo Jesús ne re xaa, nel namlest lextoo re xaa ne xaa, xaa mbizh yaa. Zee nzhé Jesús lo xaa mbizh yaa: —Bseli yaa lu. Nu gorna mseli xaa yaa xaa, gorzeeka ngokwena. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Zee lee re xaa fariseo mroo mzhaal xaa kwaan re xaa nreke tich rey Herod, zee mkwaan xaa mod gut xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Zee mroo Jesús naz baa, zee mzhin xaa roo nistoo kwaan re xaa mseed lo xaa. Nu zyen doo myet xaa yizhyo Galilea mreke tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Noka re xaa yizhyo le Judea, nu re xaa yezh gro Jerusalén, nu re xaa yizhyo le Idumea ngwa lo Jesús; noka myaad re xaa nzho stub lad roo yuu Jordán lo Jesús, noka myaad re xaa xchop yezh gro le Tiro nu Sidón lo Jesús. Nu zyen myet mbin re kwaan mle Jesús, zee mbiid re xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Zee nzhé Jesús lo re xaa mseed lo xaa: —List bzo gu tub kano yixoob na leen, nel zyen doo myet nzeke tich na, nu ntaaw doo re xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sbaa nzhé Jesús nel zyen doo xaa ne nzak msekwen xaa, zee mtaaw doo re xaa Jesús nel nzhekla re xaa gal re xaa cho Jesús, zee yikwen re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nu gorna ngune re mbi mal kwaan nzho lextoo re myet lo Jesús, zee mlebi mbi mal re xaa lo yo lo Jesús, nu mrazhe re mbi mal, nzhé re mbi mal: —Lu nak Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Zee lee Jesús mgalno re mbi mal zee, nu nzhé xaa lo re mbi mal: —Nik tub lo nayét gu nen cho nak na. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nguxoob Jesús yek yi nu mrezh xaa re xaa nzhekla xaa, zee ngwa re xaa ne lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Zee mleey Jesús chiibchop xaa reke tich xaa, zee xaal xaa xaa zaa xaa kwent xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nu lee Jesús mzaa yalnabeyy lo re xaa zee koo xaa re mbi mal lextoo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chiibchop xaa ne nak xaa mleey Jesús: Simón (xaa mlole Jesús Pér), ");
INSERT INTO zpoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Chag, Juan (rop wech xgann Zebedeo, nu rop xaa ba mlole Jesús Boanerges, kwaane nii: “Xaa nii kwenta ngwzi”); ");
INSERT INTO zpoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ndres, Lip, Tol, Teo, Max, Chag (xgann Alfeo), Tadeo, Simón (xaa nkedoola lazh), ");
INSERT INTO zpoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote (xaa zaa Jesús lo re xaa gut xaa). ");
INSERT INTO zpoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nu ngulo mded kwaane, zee mzeeb Jesús leen tub yoo. Nu stub welt zyen doo myet mri dub welt lo Jesús nu lo re xaa mseed lo xaa, nixa nyent mod gaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nu gorna mbin re sawlizh Jesús kwaane zee ngwa xaa zee yaxii xaa xaa, nel nzhé re xaa: —Nzhak naxen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Zee mzhin re maestr xaa nlu xtizh Dios yezh Jerusalén pa nzo Jesús, nu nzhé xaa lo re xaa nzhi baa: —Lee Jesús nkano yalnabeyy cheen Beelzebú, xaa nak mer Maxuu, xaa nak rey cheen rese mbi mal, kwaanzee Beelzebú mzaa yalnabeyy lo Jesús, zee nzho mod ngoo Jesús mbi mal. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nu mrezh Jesús re xaa pa nzo Jesús, zee mzaa Jesús tub kwent nabix lo xaa zee ne xaa xomod naka. Nu nzhé Jesús: —¿Che nle gu xgab koo Maxuu leeka Maxuu? ");
INSERT INTO zpoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chelee tub yezh nzhak chop tant nu dil xaa kwaan leeka re sawlazh xaa, nadiit yezh ba xche. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Noka chelee re xaa nzho tubka yoo nzhak chop tant kwaan leeka re sawlizh xaa nu ndil xaa kwaan leeka re xaa, nadiit re sawlizh xaa ba xche. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kwaanzee chelee Maxuu dil kwaan leeka Maxuu, nadiit yalnabeyy cheen Maxuu xche. Telisa lee Maxuu lux. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Nu sbaaka, nik tub xaa nyent mod zeeb leen li tub xaa ngezh, lewann xaa rese kwaan nkano xaa, chelee xaa nakadot xaa xaa yilo. Kado xaa xaa, zee nzho mod wee xaa re kwaan nkano xaa leen li xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Wlipa na kwaane. Nzho mod chee Dios reta klas jwalt kwaan nle xaa axta re kwaan nge xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Per loka xaa nge lo Mbi Naban cheen Dios, nacheetra Dios jwalt ne. Kwaane nak tub jwalt kwaan nkened lextoo xaa tira. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kwaane ngunii Jesús nel nzhé re xaa lee Jesús nkano yalngezh cheen Maxuu. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Zee mzhin xnaa Jesús nu re wech Jesús pa nzo Jesús. Nu mlaz re xaa naz jwer, zee mxaal xaa tub xaa yichezh Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nu zyen doo xaa nzob dub welt lo Jesús, zee nzhé xaa lo Jesús: —Lee xnaa lu nu re wech lu nzhi naz jwer kabezh lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nu mkeb Jesús nzhé: —¿Cho nak xnaa na nu re wech na nu re bzan na? ");
INSERT INTO zpoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nu mwii Jesús lo re xaa nzob dub welt lo Jesús, nu nzhé xaa: —Wii gu, nee nzhi re wech na, nu xnaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Loka cho nle kwaan nzhekla Dios, re xaa zee nak mod wech na, nu bzan na, nu xnaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Stub welt mzelo Jesús mseed zyen doo myet roo nistoo. Nel zyen doo xaa mri lo xaa zee nguxoob xaa leen tub kano, nu mzob xaa leen kano kwaan nzhib lo nistoo. Lee re myet mri roo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Zee mlu xaa zyen doo kwaan lo re xaa kwaan kwent nabix. Nu nzhé xaa lo re xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Kenzha gu kwent kwaan za na. Tub welt lee tub xaa nchech nzhobxtil lo yo. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Leezha kachech xaa nzhobxtil lo yo, rola mla leen naz, zee nzha re mbyin nu ndawa. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Zlaka mla lo ke pa nyent zyen yo. Nzhobxtil ba lijer doo mlen nel nyent zyen yoo pa mlaya. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Per gorna mlen mbizh nu mla doo neey, zee mbizha nel nagrot nzho loxa. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Zlaka mla leen yag yich, zee lee yag yich mdina, zee namzaata xle. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Per lee stub naz nzhobxtil kwaan mla lo yo wen, chul doo mxena nu chul doo ngoka. Tub nzhobxtil mzaa galbchii nzhobxtil, stuba mzaa chongal nzhobxtil, nu stuba mzaa tub gayoo nzhobxtil. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nu nzhé xaa: —¡Loka xaa nzob nzha, nzhaal gon kwaane! ");
INSERT INTO zpoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Leezha mlake nebse Jesús kwaan chiibchop xaa mseed lo xaa nu zlak xaa kwaan nzhi gax lo xaa, mnabdizh re xaa xomod nak kwent kwaan mzaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Zee nzhé Jesús: —Dios mzaa yo yek re gu zee ne gu xomod nak re kwaan nanyunt cheen pa nabeyy Dios; per lee lo stub naz xaa kwaan nanreket tich na, nii na duzna kwent nabix lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Zee nixa wii xaa naluta lo xaa, nixa gon xaaya nalata yek xaa, zee nalaat xaa kwaan nawent kwaan kale xaa zee nacheet Dios jwalt cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Zee nzhé Jesús lo re xaa: —¿Che nanlat kwent ne yek re gu? ¿Xomod la stub naz kwent nabix yek gu? ");
INSERT INTO zpoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Xaa nchech nzhobxtil lo yo nak kwenta tub xaa nzaa kwent xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Re xaa nak mod ben kwaan mla leen naz, nak re xaa sbaasa nzhon xtizh Dios, zee nze Maxuu nkiib xtizh Dios lo xaa, kwentaxa nak nzhobxtil kwaan mla leen naz kwaan ndaw mbyin. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Stub naz xaa nak kwenta ben kwaan mla lo ke pa nyent zyen yo; nu nyakdoola xaa mkayaa xaa xtizh Dios gorna mbin xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Per nak xaa mod nzhobxtil kwaan nanecht nzho lox, kwaanzee nanyet nzo xaa lo xtizh Dios. Nu gorna nzhin yalzi lo xaa lo xtizh Dios nu nrenal xaa xaa, zee nlaa xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Stub naz xaa nak kwenta nzhobxtil kwaan mla leen yag yich; nzhon xaa xtizh Dios, ");
INSERT INTO zpoNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per nle doo xaa xgab re kwaan yizhyo ne, nu nzoblazh doo xaa demi nu rese kwaan yizhyo ne, nu re kwaane nkade xaa, zee nluux xtizh Dios leen lextoo xaa. Xaa ne nak kwenta nzhobxtil kwaan namzaat xle. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Per stub naz xaa nak kwenta nzhobxtil kwaan mla lo yo wen. Nzhon xaa xtizh Dios, nu nkayaa xaaya kwaan dub lextoo xaa. Xaa ne nak kwenta son kwaan mzaa galbchii nzhobxtil por tub nzhobxtil, zlak xaa nak kwenta son kwaan mzaa chongala, nu zlak xaa nak kwenta son kwaan mzaa gayooya. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús nzhé stub welt: —Nik tub xaa nankeet xni bruj nu nsaaw xaa yeka kwaan tub almud o chep xaaya xan loon, sinka nzob xaaya pa ya zee zaaya xni lo re xaa nzho leen yoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nik tub kwaan xlaan nyent mod nalut, nixa tub kwaan nzholaan nyent mod nanet re xaa loya. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Loka xaa nzob nzha, nzhaal gon kwaane! ");
INSERT INTO zpoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Wen kenzha gu re kwaan nii na. Leeka medid kwaan nchiix gu kwaan nzaa gu lo stub naz xaa, leeka sbaa chiix Dios kwaan zaa xaa lo gu, nu axta masra zaa xaaya lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nel re xaa kwaan nkano kwaan, masraya kayaa xaa; per lee re xaa nankanota axta chep re kwaan nkano xaa yiib lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kwaane nzhé Jesús: —Nal za na stub kwent zee ne gu nen xomod nak pa nabeyy Dios. Leeya nak kwenta tub xaa mlo ben lo yo. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nixa naxna nixa nanaxnat xaa zhe nu yaal, per lee ben nlen nu nrooya, per nanet xaa xomod nrooya, ");
INSERT INTO zpoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","nel yizhyo nserooya. Yilotlaka nlen xkocha, zeera nzhib yaaya, nu gwluzhtlaka nzaaya son. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Leezha nla xyecha, zee nchoog xaaya kwaan syer nel mzhinla mbizh kwaan ndopa. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kwaane nzhé Jesús: —Nal za na stub kwent nabix lo gu, zee ne gu xomod nak pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Leeya nak kwenta tub bizh cheen mostas. Bizh ne nak bizh kwaan mas chut lo rese bizh. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Per leezha nxeen xaaya nu nlena nrooya, nu nzhak zyen ram cheena, nu nzaaya xkal. Nu ndexkwaa re mbyin xlaaz ma loya. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Snee mlu Jesús xtizh Dios kwaan kwent nabix, kwenta re kwent ba. Snee nii xaaya axta paro laya yek re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Leezha nii xaa lo re myet duzna kwaan kwent nabix nii xaa lo re xaa, per leezha ngulo nlake xaa kwaan re xaa mseed lo xaa, zeera nii xaaya klar lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Leeka zhe zee gorna ngulo ngwaaz mbizh, zee nzhé Jesús lo re xaa mseed lo xaa: —Chaa gu, ya be stub ta roo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nu mlaa xaa rese xaa nzhi zee nu nguxoob re xaa leen kano kwaan nguxoob Jesús leen, nu nzha re xaa. Nu noka mreke zlak kano tich re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nu mzelo tub mbi dox doo mroo, nu mzelo nistoo mgun nu axta mzeeba leen kano. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Per lee Jesús mkoo tub kwaan yek nu naxna xaa naz tras leen kano. Zeera mloo xaa mkaal lo Jesús nu nzhé xaa: —Maestr, ¿che nanlet lu xgab nu mer law re be leen nistoo? ");
INSERT INTO zpoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Zee nguxche Jesús nu mgalno xaa mbi nu nzhé xaa: —¡Kexa! ¡Zheta! Mlaz mbi, nu lee nistoo zheta ngok. ");
INSERT INTO zpoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Zee nzhé xaa lo re xaa mseed lo xaa: —¿Chozhiin tant nzheb doo gu? ¿Che nangwiit gu lo Dios? ");
INSERT INTO zpoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Per mzheb doo re xaa nu mdedyall xaa, nu nzhé xaa lo re wechxinn xaa: —¿Cho xaa ne? ¡Era gro doo kwaan nle xaa ne! ¿Chozhiin axta mbi nu nistoo nzhon xtizh xaa? ");
INSERT INTO zpoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nu gorna mzhin Jesús stub ta roo nistoo, yizhyo cheen re xaa Gadara, ");
INSERT INTO zpoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","mla Jesús leen kano. Zee mzhin tub xaa nkanze leen yeer, pa nyu re xaa ngut, nu mzhin xaa lo Jesús. Xaa ne nzho mbi mal lextoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Leen yeer pa nyu re xaa ngut nak li xaa. Nik tub xaa nalet gan kado xaa nixa kwaan kaden. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nel zyen welt nzha kado xaa yaa xaa nu nii xaa kwaan kaden, per nle xaa gan nle praa xaaya; nu nik tub xaa nayet lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yaal nu zhe nkanze xaa leen yeer pa nyu re xaa ngut nu nkanze xaa leen yi. Mbazhe xaa, nu leeka lee xaa ngin xaa kwaan ke. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Zitra ngune xaa lo Jesús nu mrexonn xaa mkichxub xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Zee nzhé Jesús: —Mbi mal, broo lextoo xaa ne. Zee dub gan mbazhe xaa nzhé xaa: —Jesús. ¡Laa, nateedt lu nu bid! ¡Lu nak Xgann Dios yiba! Naab na lo lu, nateedt lu nu bid. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Zee mnabdizh Jesús: —¿Cho le gu? —Nu le Zyen Doo —nzhé xaa—, nel zyen doo nu. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Zee lee re mbi mal ngunaab doo jabor lo Jesús, zee nakoot xaa mbi mal yizhyo ba. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Gax cho yi zee nzhi zyen kuch, ma kayaw. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Zee lee re bi mal zee ngunaab jabor lo Jesús: —Bxaal nu naz lo re kuch, nu blaa zeeb nu lextoo ma. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús mzeyal. Zee mroo re mbi mal lextoo xaa, nu mzeeb re mbi lextoo re kuch, kan chop mil kuch nzhi baa. Nu leeka gorzee mzelo re kuch mrexonn mkato naz yat mla axta leen nistoo. Nu ngwep re ma nis nu tira ngut ma. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nu re xaa nkano re kuch mrexonn nya nu nzhé xaaya lo re xaa nzhi wen nu lo re xaa nzho yezh, nen cho kwaan ngok. Zee zyen xaa ngwaselach nen cho kwaan ngok. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Leezha mzhin xaa pa nzo Jesús, zee ngune re xaa lo xaa ngu mbi mal lextoo; nzobla, nak xab, nu ngokwenla xaa, zee mzheb doo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nu re xaa ngune xomod ngok xaa ngu mbi mal lextoo, nu xomod ngok re kuch, mzaa xaa kwenta lo stub naz xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Zee ngunaab re xaa jabor lo Jesús nu nzhé xaa: —Broo nee, nakwaztra lu nee. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Leezha mbare Jesús leen kano, lee xaa ngu mbi mal lextoo ngunaab xaa jabor lo Jesús, nzhé: —Laa reke na tich lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per lee Jesús namzeyalt, zee nzhé Jesús lo xaa: —Zyaa garli lu nu lo re sawlizh lu, guzh kwaan mle Xaa Nabeyy lo lu, nu xomod mles lextoo xaa ne xaa lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Zee nya xaa, nu mzaa xaa kwenta lo re chii yezh kwaan le Decápolis re kwaan gro doo mle Jesús lo xaa. Nu rese xaa mdedyall doo. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Leezha mbare Jesús nyaad leen kano, leezha ngwa xaa stub ta roo nistoo, zyen doo xaa mri lo xaa roo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Zee lee tub xaa le Jairo, xaa nabeyy pa nkasa nu nseed nu xtizh Dios, mzhin gax xaa lo Jesús, nu mkichxub xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Zee ngunaab xaa tub jabor kwaan dub lextoo xaa, nu nzhé xaa: —Merla yilo yet xchap na. Le tub jabor lo na, chaa ya be zee zhiib lu yaa lu yek mad, zee gakwen mad zee ban mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús ngwa kwaan lee xaa. Nu zyen doo xaa mreke tich xaa nu ndaaw doo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nu lo re xaa nzha tub ngwnaa, me nzhala chiibchop liin tubka nded ren lextoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bid doo kaded me. Rese xdemi me mzaa me lo re doktor nu nanet me gakwen me, nel lee yalyizh cheen me masra nzharoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Leezha mbin me re kwaan kale Jesús, mrep me xsaww lo re xaa nzhi lo Jesús, zee mzhin me tich Jesús, nu mgal me cho xab xaa, ");
INSERT INTO zpoNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","nel mle me xgab: “Chelee na gal na cho xab Jesús, zee gakwen na”. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Gorna mgal me xab Jesús, gorzee lee ren mlaz, nu mzeen me lee yalyizh cheen me ngokwen. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Leeka gorzee mzeen Jesús, lee Jesús msekwen tub myet kwaan nebse yalngezh cheen xaa, zee myek xaa nu mnabdizh xaa lo re xaa nzhake tich xaa: —¿Cho mgal cho xab na? ");
INSERT INTO zpoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Re xaa mseed lo xaa nzhé: —Wii, ntaaw re xaa lu, nu mnabdizhra lu: “¿Cho mgal cho xab na?” ");
INSERT INTO zpoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per lee Jesús mwii dub welt zee ne xaa cho xaa mgal cho xab xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Zee lee ngwnaa ne nxizh doo lo yalnacheb nel mzheb doo me, nel sbaa nzhé Jesús. Zee mbii me gax lo Jesús nu mkichxub me lo xaa, nu mzaa me rese kwent lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Zee nzhé Jesús lo ngwnaa ne: —Xchap na. Nel mwii lu lo Dios, zee ngokwen lu. Wen nya lu nal, nel ngulola ngokwen lu yalyizh cheen lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kaniika Jesús, lee lak xaa sawlizh Jairo mzhin lo Jairo. Nu nzhé xaa lo Jairo: —Ngulola ngut xchap lu, nankintra nii lu lo maestr. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Per leezha mbin Jesús kwaan nzhé re sawlizh Jairo, zee nzhé Jesús lo Jairo: —Nazhebt lu, nebse bwii lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nu namzaat xaa diizh reke mas xaa tich xaa, nebse Pér, Chag nu Juan, wech Chag. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nu leezha mzhin Jesús garli Jairo, ngune xaa lee re xaa nzhi baa nzhonn nu mbazhe re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mrep xaa leen yoo nu nzhé xaa: —¿Chozhiin tant nkee gu rezh nu nzhonn gu? Nel nanguta mad, nebse naxna mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mxizhno re xaa Jesús. Per lee Jesús mloo re xaa leen yoo nu mbe xnaa mad nu xuz mad nu yon xaa mseed lo xaa, nu mzeeb xaa pa nax mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Zee mzen Jesús yaa mad nu nzhé xaa lo mad: —Talita kumi. (Wdizh ne nii: “Mad, ¡guxche!”) ");
INSERT INTO zpoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tas nguxche mad nu mze mad; chiibchop liin nzho mad. Nu rese xaa mdedyall ngune kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús nzhé: —Nik tub lo nayét guya. Nu nzhé xaa: —Zaa gu kwaan gaw mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mroo Jesús naz ba, zee nya xaa naz lazh xaa, kwaan re xaa mseed lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Leezha ngok zhe sab, zhe kwaan nzholl re nu lo Dios, zee mzelo Jesús mseed re myet, pa nkasa nu nseed nu xtizh Dios. Mdedyall re xaa gorna mbin xaa kwaan nzhé Jesús. Zee nzhé re xaa lo wechxinn xaa: —¿Pa mseed xaa ne re kwaan nzhak xaa? ¿Che Dios mzaa rese kwaan nzho yek xaa, zee nzho mod nle xaa re kwaan gro doo ne? ");
INSERT INTO zpoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¡Xaa ne nak karpinter xgann Mari! ¡Re wech xaa nak Chag, Che, Judas nu Simón nu re bzan xaa nzho leeka nee! Kwaanzee nanont Jesús lo re xaa, nu nixa nanzhont xaa xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús nzhé lo re xaa: —Nik tub xaa nzaa kwent kwaan nzhé Dios lo lee xaa yilo, namkayaawent re sawlazh xaa xaa nu re sawlizh xaa nu re xaa nzho li xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Namlet Jesús zyen kwaan gro lazh xaa, lakse xaa mzhib xaa yaa xaa cho nu ngokwen. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nu ndedyall Jesús ngune xaa lee re sawlazh xaa nangwiit lo xaa. Nu zee mroo Jesús lazh xaa, nu ngwa xaa re yezh kwaan nzhi gax nu mseed xaa re xaa nzho re yezh ba. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús mrezh chiibchop xaa kwaan mseed lo xaa, zee xaal xaa chopga xaa, nu nzhé xaa lo xaa: —Za na yalnabeyy lo gu zee nzho mod koo gu rese mbi mal lextoo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Noka nzhé Jesús lo re xaa: —Be gu tub garrot per naweet gu mas kwaan, nixa yex kwaan yo re xcheen gu leen, nixa kwaan gaw gu, nixa demi. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nzhaal ke yelyed nii gu, per nanzhaalt wee gu stub naz ler. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nu nzhé xaa: —Loka xana yoo zhin gu, kwaz gu zee axta gorna yilo roo gu yezh ba. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nu chelee tub yezh nanzheklat kayaa gu, broo gu leen yezh ba nu brib gu yide kwaan nkee tich xkyelyed gu, zee ne re xaa yezh ba lee re sawlazh xaa mle kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Zee mroo re xaa ngwa, nu nzhé xaa lo re xaa zee laa xaa naletra xaa kwaan nawent nu wii xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Zyen doo mbi mal mloo xaa lextoo re myet, nu mteeb xaa anseyt cho re xaa ne nzak nu ngokwen re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nu rese yezh mxonn wdizh cheen Jesús, zee mbin rey Herod re kwent cheen Jesús, nu nzhé xaa: —Xaa ne nak Juan Xaa Nchubnis mroban, kwaanzee nzho mod nle xaa re kwaan gro doo. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lee stub naz xaa nzhé: —Lee Jesús nak Li, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. Nu lee stub naz xaa nzhé: —Lee Jesús nak stub re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, mroban. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Per leezha mbin Herod re kwaane, nzhé xaa: —¡Lee Juan xaa mxaal na nguchoog xaa yek, mroban! ");
INSERT INTO zpoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yilo mxaal Herod zen xaa Juan nu mlo xaa Juan lozhyib, nel nayii Herodías ne Juan, nel lee Herodías nak sa Lip, wech Herod, per mka Herod me. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nel Juan nzhé lo Herod: —Nawent nkano lu sa wech lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kwaanzee nayii doo Herodías ne Juan, nu nzhekla me gut me Juan, per nyent mod gut me Juan, ");
INSERT INTO zpoNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","nel nzheb doo Herod ne Juan. Kwaanzee nkanap Herod xaa, nel ne xaa lee Juan nak tub xaabyi nambey nu nali nzo lo Dios. Nu nzaa Herod yek Herod nzhon xtizh Juan, nu gorna nzhon xaa xtizh Juan, nle doo xaa xgab. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per tub mbizh mle Herod tub yalni gro doo, zhe kwaan nguxoob xaa liin. Nu mrezh xaa rese xaa nabeyy, nu rese xaa nabeyy lo re soldad nu rese xaa non re yezh cheen Galilea, zee mbid re xaa lo yalni cheen Herod. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Zee lee xchap Herodías mrep mkanii paro mzob Herod kwaan re xaa mrezh xaa. Nu lee Herod nyula doo mod mkanii me, nu noka re xaa mrezh xaa nyula mod mkanii me, zee nzhé Herod lo me: —Naab kwaan nzhekla lu, na zaya. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nu nzhé Herod lo me: —Wlipa naya, loka kwaan naab lu lo na, za naya, axta nzho mod za na rol pa nabeey na lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nu gorzee mroo mad nu ngwanabdizh mad lo xnaa mad nu nzhé mad: —¿Cho kwaan naab na? Lee me nzhé: —Na nzhekla yek Juan Xaa Nchubnis. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nu leeka gorzee ngwa mad lo Herod nu nzhé mad: —¡Nal gorne nzhekla na zaa lu yek Juan Xaa Nchubnis, we na leen tub yann! ");
INSERT INTO zpoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nales doo ngok lextoo Herod, nel ngulola nzhé xaaya lo mad. Kwaanzee mton xaa chee xaa xtizh xaa, nel zyen doo xaa nzhi garli xaa mbin kwaan nzhé xaa gorna mcheroo lo mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Gorzee mxaal xaa tub soldad cheen xaa, nu nzhé xaa lo xaa: —Gwachoog yek Juan Xaa Nchubnis. Nu gorzee ngwa soldad leen lozhyib, nu mchoog xaa yek Juan. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nu mlo xaa yek Juan leen tub yann nu mzaa xaaya lo mad, zee lee mad mzaaya lo xnaa mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gorna mbin re xaa mseed lo Juan lee Juan ngut, ngwa re xaa ngunaab xaa kwerp cheen Juan zee kaach re xaa kwerp cheen Juan. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Gorna mbare re xaa mkayaa yalnabeyy lo Jesús, zee nzhé re xaa rese kwaan mle xaa nu rese kwaan mlu xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Zyen doo xaa nzhi lo Jesús, nu nixa nanlat re xaa gaw xaa, kwaanzee nzhé Jesús lo re xaa mseed lo xaa: —Laa be re xaa nee. Chaa gu ya be tub pa nyent xaa, zee nzho mod le gu deskans chep. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Zee ngu re xaa leen tub kano nu nzha xaa tub pa zit, pa nyent myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Per ngune re myet lee xaa nzha, nu mlebeyy re xaa xaa, zee mrexonn rese xaa yezh nzha. Nu mas yilo re xaa yezh mzhin baa zeera mzhin Jesús kwaan re xaa mseed lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Per gorna mla Jesús leen kano, mwii xaa zyen doo xaa nzhi baa. Zee mles lextoo xaa ne xaa re xaa ba, nel kwenta mbakxiil, ma nakanot xaa kanap ma nzhak re xaa. Nu mzelo xaa mlu xaa zyen kwaan lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Leezha nzhazhela yizhyo, re xaa mseed lo xaa mbii gax lo xaa, nu nzhé xaa: —Mzhela yizhyo nu nyent xaa nee to kwaan gaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chech re xaa, zee yizi xaa kwaan gaw xaa re yezh nzhi gax nee, nu re rench. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Per lee Jesús mkeb lo re xaa nzhé: —Zaa gu kwaan gaw xaa. Zee lee re xaa nzhé: —Lee re kwaan gaw tub lanee xaa non doo. Mas nona ke tub lal kwaan le xaa gan kee xaa zhiin tub gayoo mbizh. ¿Che nzhekla lu yazii nu tub lanee pan, zee zaa nuya gaw re xaa ne? ");
INSERT INTO zpoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús nzhé: —¿Lak pan nkano gu? Gwasewii gu ne lak pan nkano gu. Zee lee re xaa ngwasewii, nu nzhé xaa: —Gaayka pan nu chopaka mbal. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nu mxaal Jesús re xaa zee zob lakga xaa lakga xaa lo yix wen. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nu mzob lakga xaa. Rol pa mri gayooga xaa, nu zrol pa mri choobchiiga xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Zee mzen Jesús gaay pan nu rop mbal nu mwii xaa naz yiba, nu mzaa xaa dixkix lo Dios. Nu mlerol xaa pan nu mzaa xaaya lo re xaa mseed lo xaa, zee kiiz xaaya lo re xaa nzhi baa. Nu seeka mlerol xaa mbal, nu mzaa xaa ma lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Rese xaa ndaw axta paro nguzhe lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nu mtop xaa zchiibchop chekwid pan nu mbal kwaan mlake ndaw re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kan tub gaay mil xaabyi ndaw. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gwluzh ngulo mded kwaane, Jesús mxaal re xaa mseed lo xaa zee yixoob xaa leen kano nu ded xaa stub ta roo nistoo lo yezh Betsaida. Zee lee Jesús mlake lo re myet axta gorna chech xaa re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Leezha ngulo mchech Jesús re xaa, zee lee Jesús nzha naz yi zee wdizhno xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Leezha ngulo mzhel yizhyo, lee kano nzha xsaww nistoo nu lee Jesús techosa mlake naz roo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Zee leezha merla kaxni yizhyo, ngune Jesús lee re xaa mseed lo xaa nded doo bid kazeno kano nel nroo doo mbi. Nu nanlat mbi nzeno xaa kano, nzobya mbi xkano xaa naz tras. Nzhakaxnila yizhyo lee Jesús nzhaze lo nistoo, nu mle xaa mod tub xaa tira dedyo lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Leezha ngune re xaa lee Jesús nzhaze lo nistoo, nzhé re xaa: —¡Besa! Nu mbazhe re xaa, ");
INSERT INTO zpoNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","nel rese xaa mluya lo, nu mzheb doo re xaa. Per gorzee lee Jesús nzhé lo re xaa: —Blo gu balor lextoo gu, nazhebt gu, nel naya. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nu mzeeb xaa leen kano pa nzho re xaa, nu lee mbi mlaz. Ndedyall re xaa leezha ngune re xaa kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nel namlat kwaan mle Jesús yek re xaa leezha mdiiz xaa pan kwaan ndaw re myet, nel mkaw yek re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Zee mded xaa stub ta roo nistoo, mzhin xaa tub yezh kwaan le Genesaret, pa mkado xaa kano roo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Gorna mla Jesús leen kano, rese xaa mlabeyy xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nu lee re xaa yezh mrexonn mzhib re xaa ne nzak lo da nu nzheno re xaa xaa lo Jesús, pa nzo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Palpa nzeeb Jesús, nya xaa re yezh gro nu re yezh win nu re rench, zee nyilaa re xaa re xaa ne nzak lo xbi nu roo naz. Nu naab xaa lo Jesús, zee zaa Jesús diizh gal re xaa ne cho xab Jesús, nu re xaa mgal cho xab Jesús nzhakwen. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tub mbizh mroo lak fariseo nu lak maestr xaa nlu xtizh Dios naz Jerusalén. Nu mzhin re xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nel nzak xaa lee lak xaa mseed lo Jesús, nawent nzo lo Dios, nel nanyanagt xaa nzhaw xaa kwentaxa nii ley cheen re xey nu. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Nel rese fariseo nu rese nu, xaa Israel, gorna nzhaw nu, yanertlaka yanag nu nel see mle re xey nu, xaa yilo, zee mzo wen nu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Noka gorna mbare nu nya nu lo xbi, yanertlaka yanag nu zeera nzho mod gaw nu. Nu zyen kwaan kwenta kwaane mlu re xey nu lo nu zee zo wen nu lo Dios, kwentaxa: nzet xaa re tas nu re yann nu re yas wen wen.) ");
INSERT INTO zpoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kwaanzee lee re fariseo nu re maestr, xaa nlu xtizh Dios, mnabdizh lo Jesús, nu nzhé: —¿Chozhiin nangozhawt re xaa kaseed lo lu kwaan mle re xey be? ¿Chozhiin nayanagt xaa gorna gaw xaa, kwentaxa nzhé re xey be? ");
INSERT INTO zpoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Zee Jesús nzhé: —¡Gu nak xaa nkade nu nanlet gu kwaan wen! Wen, wen mzaa Chay kwent cheen gu yilo, nen xomod nak gu, leezha né xaa: Né Dios: “Né gu nkela gu na, per nanreket gu tich xnaz na. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kanxlee nzholl re xaa lo na, nel rese kwaan seed re xaa nak kwaan mroo yek re myet.” Is. 29:13 ");
INSERT INTO zpoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Lee re gu nle rese kwaan mle xey gu, nu mlaa gu xcheen Dios stub lad. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nu noka nzhé Jesús: —Tub lad nted gu re wdizh kwaan mxaal Dios le gu, leel re kwaan mlu xey gu lo gu nle gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ches nzhé lo ley: “Kela lu xuz lu nu xnaa lu”. Ex. 20:12 Noka nzhé ley: “Xaa nge lo xuz o lo xnaa, bit gu xaa”. Ex. 21:17 ");
INSERT INTO zpoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Per gu mbezh nzho mod nii gu lo xuz gu nu lo xnaa gu: “Nagarlot le na yudar rop gu nel rese kwaan mlake lo na nak korban”. (Wdizh ne nii: “Leeya mzala na lo Dios”.) ");
INSERT INTO zpoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nu nzhak re gu kwenta re xaa sbaa mbezh, nanzhaaltra le xaa yudar xuz xaa nu xnaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sbaa nle nanont gu xtizh Dios gorna nlu gu re kwaan mlu re xey gu lo gu. Nu zyen kwaan kwenta kwaane nlu gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Zee mrezh Jesús rese xaa nu nzhé xaa: —Kenzha gu kwaane nu bin guya. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nik tub kwaan nzeeb leen lextoo xaa le nawent nzo xaa lo Dios, nel re xgab nawent kwaan nroo lextoo xaa, kwaanzee nle nawent nzo xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Re gu nzob nzha, nzhaal gon kwaane! ");
INSERT INTO zpoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Leezha ngulo mlaa Jesús re xaa zee, zee mzeeb Jesús leen tub yoo kwaan re xaa mseed lo xaa. Nu lee re xaa mseed lo xaa mnabdizh lo xaa: —¿Xomod nak kwent kwaan nguné lu zee? ");
INSERT INTO zpoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Zee nzhé xaa lo re xaa: —¿Che noka gu, namlata yek? ¿Che nangwiit gu rese kwaan nzhaw xaa nya leen xpaans xaa, nyent mod leya zee nawent nzo xaa lo Dios? ");
INSERT INTO zpoNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nel namzeebta mer leen lextoo xaa, nel nebse leen xpaans xaa nzeeba, nu nrooya stuba. Wdizh ne mlu Jesús zee nzho mod gaw xaa rese kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nu nzhé xaa: —Kwaan nroo lextoo myet, kwaanzee nak kwaan nle nawent nzo xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nel naz leen lextoo xaa nzhal re xgab nawent: nzoblazh xaa chaal xaa stub ngwnaa, nlewann xaa, nzhut xaa sa myet xaa, ");
INSERT INTO zpoNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nzoblazh xaa kwaan nkano wechxinn xaa, nle xaa rese kwaan nawent, nkade xaa, nzhib bis nachan yek xaa, nzhak xaa enbidyos cheen stub xaa, nzhawyix xaa sa myet xaa, nto xaa yalxwa, nle xaa rese kwaan nachan. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Rese kwaan nawent ne nzhal lextoo myet, nu kwaane nle nawent nzo xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Leezha mroo Jesús yizhyo Galilea, zee nzha Jesús yizhyo cheen chop yezh le Tiro nu Sidón. Mzeeb xaa leen tub yoo, nel nanzheklat xaa ne re xaa lo xaa, per nyent mod nkaxlaan xaa lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Lijer mbin tub ngwnaa lee Jesús nzho leen tub yoo. Me ne nkano tub xchap, mad nzho mbi mal lextoo. Zee ngwa xnaa mad lo Jesús, nu mkichxub me lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Me ne nanakt tub ngwnaa me sawlazh nu, lee me nak tub me yizhyo Sirofenicia. Ngunaab me jabor lo Jesús zee koo Jesús mbi mal lextoo xchap me. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Per lee Jesús nzhé lo me: —Yanertlaka nzhaal gaw re xinn xaa, nu nanzhaalt kiib xaa pan lo re xinn xaa, nu zaa xaaya lo re mbak. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lee me mkeb nzhé: —Li lu kwaan ba; per noka mbak nzhaw re kwaan ngobi re madwin xan mes. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Zee nzhé xaa: —Li kwaan né lu baa, nzho mod nya lu. Mroola mbi mal lextoo xchap lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Leezha mbare me garli me, lee xchap me naxna lo loon. Ngulola mroo mbi mal lextoo mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Zee mroo Jesús yezh Tiro nu mded xaa yezh Sidón, nu mded xaa yizhyo cheen chii yezh kwaan le Decápolis. Nu mbare xaa roo nistoo Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Zee mbidno re xaa tub xaa nkwee lo xaa, nu nyent mod wdizh wen xaa, zee nzhé re xaa lo Jesús: —Zhib yaa lu cho xaa ne, zee gakwen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Zee mbe Jesús xaa zit lo re xaa, nu kwaan kwen yaa Jesús mgal Jesús leen nzha xaa. Nu mted Jesús nzhuk yaa Jesús nu mgal xaa lo luzh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nu mwii Jesús naz yiba, nu mzilextoo xaa, nu nzhé xaa: —¡Efata! (Wdizh ne nii: “¡Xal!”) ");
INSERT INTO zpoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Gorzee lee nzha xaa mxal, nu mzelo xaa nzhedizh wen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Zee nzhé Jesús lo re xaa: —Nik tub lo nayét guya. Per nambint re xaa xtizh Jesús, masra nzaa xaa kwent lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nu rese xaa mdedyall doo. Nu mbezh re xaa lo wechxinn xaa: —¡Yisutisuti! ¡Wen nle xaa rese kwaan! ¡Nu axta nsekwen xaa re xaa nkwee, nu nle xaa nzhedizh re xaa nyent mod wdizh! ");
INSERT INTO zpoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tub mbizh mkasa zyen doo xaa lo Jesús, nu nik tub kwaan nyent gaw re xaa. Jesús mrezh re xaa mseed lo xaa, nu nzhé xaa lo re xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nles doo lextoo na ne na re xaa ne, nel nzhala chon mbizh nzhi re xaa lo be, nu nik tub kwaan nyent gaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kwaanzee chelee na xaal na re xaa nya xaa, napaka yiguuzh xaa naz, nel zyen doo xaa nzho zit doo nee. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Re xaa mseed lo xaa nzhé: —¿Per pa yixii nu tub lanee kwaan gaw tub lanee myet, pa nik tub xaa nyent? ");
INSERT INTO zpoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús nzhé lo re xaa: —¿Lak pan nzeno re gu? Zee lee re xaa nzhé: —Gazha. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Zee nzhé xaa lo re xaa nzhi zee: —Bzob re gu lo yo. Nu mzen xaa gazh pan, nu mzaa xaa dixkix lo Dios. Mlerol xaaya nu mzaa xaaya lo re xaa mseed lo xaa, zee mdiiz xaaya lo re xaa nzhi zee. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Noka nzeno xaa lak mbal dik. Jesús mzaa dixkix lo Dios nu mzaa xaaya zee mdiiz xaaya lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Rese xaa ndaw axta paro nguzhe lextoo xaa, nu seesa mtazhe xaa gazh chekwid byog, re kwaan mlake. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kan tap mil xaa ndaw. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ngulo ndaw xaa, zee mxaal Jesús re xaa nya xaa. Nu gorzee nguxoob Jesús leen kano kwaan re xaa mseed lo xaa, nu mzhin xaa yizhyo kwaan le Dalmanuta. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Zee re xaa fariseo mzhin lo Jesús, nu mzelo xaa mdildiizh xaaya kwaan Jesús. Nel nzhekla xaa ne xaa che wli kwaan nii Jesús, zee nzhé xaa lo Jesús: —Le tub nseyn kwaan nebse Dios nzho mod le, zee ne nu lee lu nak xaa mxaal Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús mzilextoo nu nzhé: —¿Chozhiin naab re gu, xaa nzho mbizh nalzhe, nseyn ne? Wli na kwaan nii na lo gu, nik tub kwaan nalet na lo gu, zee nik tub kwaan nawiit gu lo. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Zee mlaa Jesús re xaa, nu mzeeb Jesús leen kano, nu nzha xaa mded xaa stub ta roo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Myenlazh re xaa nge xaa kwaan gaw xaa, chaka pan nkano xaa leen kano. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Leezha nzha re xaa leen kano, Jesús nzhé lo re xaa: —Lijer gok gu lo lebadur cheen re fariseo, nu lo lebadur cheen Herod. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Re xaa mseed lo xaa mzelo nzhé xaa lo wechxinn xaa: —Sbaa né xaa lo be nel myenlazh be nge be pan. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nu mzeen Jesús kwaan nzhé re xaa lo re wechxinn xaa, zee mnabdizh Jesús lo re xaa: —¿Chozhiin nzhé gu nanzenot gu pan? ¿Che seetaka nanzeent gu, nu nixa nanlata yek gu? ¿Che tira mkaw yek gu? ");
INSERT INTO zpoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nzob lo gu, per nanluta lo gu; nzob nzha gu, per namxalt nzha gu gon guya. ¿Che tira nanselazht gu? ");
INSERT INTO zpoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Leezha mlerol na pan ndaw tub gaay mil xaa, ¿lak chekwid pan mlake? —Chiibchopa —nzhé re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Leezha mlerol na pan ndaw tub tap mil xaa, ¿lak chekwid pan mlake? —Gazha —nzhé re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Zee nzhé Jesús: —¿Chozhiin seesa nanlata yek gu? ");
INSERT INTO zpoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gorna mzhin Jesús yezh Betsaida, lee lak xaa nzeno tub xaabyi syeg. Zee nzhé re xaa lo Jesús: —Le jabor, zhib yaa lu cho xaa ne, zee gakwen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús mzen yaa xaa nu mbe Jesús xaa tub lad roo yezh. Nu mchuk xaa zaalo xaa, nu mzhib xaa yaa xaa cho syeg, nu nzhé xaa: —¿Che nyini lu lak? ");
INSERT INTO zpoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Gorna mwii xaa zee nzhé xaa: —Nlu lak xaa nzhaze lo na, per kwenta yag nzhak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mbare Jesús mgal zaalo xaa stuba, ¡nu lee syeg nguni lo, nu myun rese kwaan lo xaa! ");
INSERT INTO zpoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Zee Jesús nzhé lo xaa: —Zyaa garli lu, per nadedt lu leen yezh. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zeera lee Jesús nu re xaa mseed lo Jesús, ngwa re yezh yizhyo le Cesarea-Filipo. Leezha nzhaze re xaa, Jesús nzhé lo re xaa mseed lo xaa: —¿Cho né re myet nak na? ");
INSERT INTO zpoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Lee re xaa nzhé: —Tub naz xaa mbezh lee lu nak Juan Xaa Nchubnis, stub naz xaa mbezh lee lu nak Li, nu stub naz xaa mbezh lee lu nak stub re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, mroban nal. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Lee re guya, ¿cho nle re gu xgab nak na? —nzhé xaa lo re xaa. Nu lee Pér mkeb nzhé: —Lu nak Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Per lee Jesús mnabeyy re xaa nu nzhé xaa lo xaa: —Nik tub lo nayét guya. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús mzelo mseed re xaa mseed lo xaa, nu nzhé xaa: —Na nak Xaa Mzhin Ngok Myet. Nu nzhaal ded doo na bid, nu nakayaat re xaa gol na, nixa re ngwleyy xaa non, nixa re maestr xaa nlu xtizh Dios. Nu gut re xaa na, per lee mbizh yon lee na roban. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Klar ngunii xaa re wdizh ne, kwaanzee Pér mbe xaa tub lad, nu mgalno Pér xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Per lee Jesús myek nu mwii lo re xaa mseed lo xaa, nu mgalno xaa Pér, nzhé xaa: —¡Bachii lo na Maxuu! Nanlet lu xgab kwaan nle Dios xgab; lu nle re xgab kwaan nle re myet xgab. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Zee mrezh Jesús re xaa mseed lo xaa nu nzhé xaa: —Chelee tub gu nzhekla reke tich na, laa gu rese kwaan nzhap gu, nu rese kwaan nzho yek gu le gu, nu gak gu kwenta tub xaa mbit xaa lo krus, nu breke gu tich na. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chelee tub xaa yet nel nreke xaa tich na, nu nel ngula xaa re wdizh wen cheen Dios xaa nzho naz leen yiba, le xaa gan yalnaban kwaan tira. Per lee xaa nzheb yet kwaan na, nalet xaa gan yalnaban naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Per cho gan le myet; nixa rese kwaan nzho lo yizhyo nkano xaa, nu nalet xaa gan yalnaban naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nik tub kwaan nyent mod zaa myet zee le myet gan yalnaban naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Chelee tub xaa nton ne na, nu nton nii xtizh na lo re myet xaa nzhi mbizh nal, xaa mlaa Dios nu xaa tira nawent nak, noka na ton na ne na xaa ba, gorna bare na stub welt, nel na nak Xaa Mzhin Ngok Myet. Ton na ne na xaa ba gorna xaal Xuz na na stub welt kwaan re xmandad xaa, xaa nambey. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Snee nzhé Jesús: —Wlipa na kwaan nii na lo gu, lak gu nzhi nee, nayeta axta ne gu lee Dios nabeyy, kwaan yalnabeyy cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Leezha mzhaal xop mbizh, Jesús mbe Pér, Chag nu Juan yek tub yi naro, techosa dap xaa nzha. Nu gorna mzhin xaa zee, ta mzhee Jesús lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nu mla xni xab xaa. Nu rus doo nguna xab xaa, nixa mas zet xaa ler nalet xaa gan naya see. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nu mlu Li kwaan Ches kawdizhno Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Zee nzhé Pér lo Jesús: —Maestr, wen nzo nu nee. Nal dexkwaa nu chon ramad, tuba cheen lu, stuba cheen Ches, nu stuba cheen Li. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Snee nzhé xaa nel mzheb doo yon xaa, nu nanetra xaa cho kwaan yé xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nu gorzee lee tub xkaw nze, nu ngu re xaa leen xkaw zee. Nu leen xkaw zee mroo tub bos kwaan nzhé: —Xaa ne nak xgaan na, xaa nkedoola na. Bin gu xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gorna mwii re xaa stuba, nyentra cho mlu lo re xaa, techosa Jesús nzo. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Gorna mla re xaa yek yi Jesús nzhé lo re xaa: —Nik tub lo nayét gu kwaan mlu lo gu, axta zhin mbizh kwaan lee na roban, Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mbin re xaa kwaane, nu nik tub lo nanzhét xaaya. Per zyen welt nabdizh xaa lo wechxinn xaa xomod nak kwaan roban xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Zee mnabdizh yon xaa lo Jesús: —¿Chozhiin nzhé re maestr xaa nlu xtizh Dios, yanertlaka Li yaad? ");
INSERT INTO zpoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús nzhé: —Wliya. Li nkin yaad yilo, zee dexkwaa xaa rese kwaan. ¿Chozhiin nzhé xtizh Dios: “Lee Xaa Mzhin Ngok Myet nzhaal ded doo bid, nu tira nangaknont xaa lo re myet”? ");
INSERT INTO zpoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Per lee na nii lo gu, mbiidla Li, nu nawent mle re xaa lo xaa, mod nzhekla re xaa mle xaa xaa, kwentaxa nkee lo Xkyech Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Leezha mbare Jesús kwaan Pér, Chag, nu Juan, leezha ngwa xaa yek yi, mzhin xaa paro nzhi stub naz re xaa mseed lo Jesús, nu ngune Jesús zyen doo xaa nzhi baa. Nu lee re maestr, xaa nlu xtizh Dios, kadildiizh kwaan re xaa mseed lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nu gorna ngune re xaa lo Jesús mdedyall xaa, nu mrexonn xaa nzhé xaa “dix” lo Jesús ");
INSERT INTO zpoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nu lee Jesús mnabdizh lo re xaa: —¿Cho kwaan ndildiizh re gu kwaan stub naz xaa ne? ");
INSERT INTO zpoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nu lee tub xaa nzo lo re xaa, mkeb nzhé: —Maestr, na nzeno xgaan na lo lu. Nzho tub mbi mal lextoo mad, nanlaata wdizh mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Palpa nzo mad, nzen mbi mal mad nu ngobiya mad lo yo; nu nroo bchiin roo mad, nu ntaaw mad keleyy mad, nu nseli mbi mal mad. Ngunaab na jabor lo re xaa kaseed lo lu, zee koo xaa mbi mal lextoo mad per nangarlot ngoo re xaa mbi mal lextoo mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús mkeb nu nzhé: —Myet xaa ned, xaa nanet wii lo Dios. ¿Axta pa gor yiche lextoo na ne na re gu? ¿Axta zlak mbizh nzhaal zo na lo re gu? Teno xgann lu nee. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Zee mbe xaa mad lo Jesús. Nu gorna ngune mbi mal zee lo Jesús, mlebi mbi mal mad lo yo nu mle mbi mal mzhib mad tub yizhgutye. Nu mbaxche mad lo yo, nu mroo bchiin roo mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús mnabdizh lo xuz mad, nu nzhé: —¿Pok mzelo mad snee nzhak mad? Nu lee xuz mad mkeb nu nzhé: —Axta leezha win mad mzhiba. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nu zyen doo welt ngobi mbi mal mad lo ki, leen nis, nel nzhekla mbi mal gut mad. Cheleeya nzho mod koo lu mbi mal lextoo mad, bles lextoo lu ne lu nu, le yudar nu. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús nzhé: —¿Chozhiin né lu che nzho moda? Rese kwaan nzho mod chelee lu ngwii lu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nu gorzee mkeb xuz mad dublegan, nu nzhé xaa: —Ngwii na lo Dios, ble yudar na zee nzho mod masra wii na lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nu gorna ngune Jesús zyenra xaa nzhazhin, zee mgalno Jesús mbi mal, nu nzhé xaa: —Mbi muud, nu mbi nkwee, na nabeey lo lu, broo lextoo mad nu nabaretra lu zeeb lu lextoo mad stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nu lee mbi mal zee mrazhe, mle mzhib mad stub yizhgutye naro stub welt, nu lee mbi mal zee mroo lextoo mad, nu mlaa mbi mal mad mod mad ngut. Zee lee re xaa nzhi baa nzhé: —Ngulola ngut mad. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nu lee Jesús mzen yaa mad nu mlis mad, nu lee mad mzoli. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nu gorzee mzeeb Jesús leen yoo kwaan nebse re xaa mseed lo xaa, zee mnabdizh re xaa lo Jesús: —¿Chozhiin nyent mod ngoo nu mbi mal ba? ");
INSERT INTO zpoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús nzhé: —Rese klas mbi mal ne nagarlot roo sbaasa, yilotlaka nkin naab guya lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Gorzee lee Jesús mroo zee, nu mded xaa yizhyo Galilea kwaan re xaa mseed lo xaa. Nzhekla xaa nik tub xaa nanet pa zo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kwaanzee kaseed Jesús re xaa mseed lo xaa nu nzhé xaa: —Na nak Xaa Mzhin Ngok Myet. Nu zaa xaa na lo xaa nak zhiin zee gut xaa na, per mbizh yon lee na roban. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Namlat wdizh ne yek re xaa, per nzheb re xaa nabdizh xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nu mzhin xaa yezh le Capernaum. Leezha mzhin xaa roo yoo, Jesús mnabdizh lo re xaa mseed lo xaa: —¿Cho kwaan tant mdildiizh guya naz? ");
INSERT INTO zpoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Per nik tub xaa namkebt, nel leezha nzo re xaa naz nzhé re xaa: “¿Cho be nak xaa mas non?” ");
INSERT INTO zpoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Zee mzob Jesús nu mrezh Jesús re chiibchop xaa mseed lo xaa, nu nzhé Jesús lo re xaa: —Chelee tub gu nzhekla gak xaa mas non, nkin gak gu xaa nadoo doo nu kee gu zhiin lo rese xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nu mzo Jesús tub madwin xsaww lo re xaa, nu mdeezh Jesús mad, zee nzhé Jesús lo re xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Loka cho kayaa madwin ne nel nkela xaa na, noka mkayaa xaa na; nu loka cho kayaa na, noka mkayaa xaa xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan nzhé lo Jesús: —Maestr, ngune nu lo tub xaa ngoo mbi mal kwaan le lu, per nanakt xaa tub xaa kaseed kwaan nu. Kwaanzee nzhé nu lo xaa: “Nalet lu kwaan ba”. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús mkeb nzhé: —Blaa gu nu naniit gu lo xaa. Tub xaa nle tub kwaan naro kwaan yalnabeyy cheen na, nyent mod nii nawent xaa na, gorna ngulo mle xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Rese xaa nanayiit ne be, nroo xaa ba xjabor be. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wliya, loka xaa zaa tub xig nis go gu nel xaa na nak gu, telisa kix Dios lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Loka xana tub xaa le zee le tub madwin jwalt, mad ngwii lo na, mas wen kee xaa tub ke ndok yenn xaa zee nu gobi xaa xaa leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chelee yaa lu lad li nle zee nle lu kwaan nawent, chooga nu blabiya zit lo lu, nel mas wen lux lu tub lad yaa lu ke nya dub lu lo ki kwaan tira nanyuyyt, ");
INSERT INTO zpoNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","pa nixa myaz nanluxt, nixa ki tira nanyuyyt. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Chelee nii lu nle zee nle lu kwaan nawent, chooga nu blabiya zit lo lu, nel mas wen lux lu tub lad nii lu ke nya dub lu lo ki kwaan tira nanyuyyt, ");
INSERT INTO zpoNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","pa nixa myaz nanluxt nixa ki tira nanyuyyt. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Chelee zaalo lu nle zee nle lu kwaan nawent, blooya nu blabiya zit lo lu, nel mas wen lux lu tub zaalo lu ke nya dub lu lo ki, ");
INSERT INTO zpoNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","pa nixa myaz tira nanluxt, nu nixa ki nanyuyyt. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Rese gu gak nzhig kwaan ki. ");
INSERT INTO zpoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Chul zed leezha nzhig zed, per chelee zed nanzhigtra zed nyentra mod gak nzhiga stub welt. Seeka gak gu kwenta zed lo rese kwaan nle gu, nu wen bri re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Zee mroo Jesús yezh Capernaum, nu nzha xaa yizhyo cheen Judea, nu noka mded xaa stub ta yuu Jordán. Nu mkasa zyen doo myet lo xaa, nu mseed xaa re xaa, kwentaxa nle xaaya rese welt. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Zee mzhin lak fariseo nu mnadizh xaa lo Jesús, nel nzhekla xaa kwaan xaa mod zee gaazh xaa kwaan tich Jesús, zee nzhé xaa lo Jesús: —¿Cho kwaan nzhé ley? ¿Che nzho mod laa tub xaabyi xngwnaa xaa? ");
INSERT INTO zpoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Zee nzhé Jesús: —¿Xomod nii ley cheen Ches? ");
INSERT INTO zpoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Zee nzhé re xaa: —Ches nzhé nzho mod laa xaabyi xngwnaa xaa, nu nebse zaa xaa tub yech kwaan yé mtexonn xaa me. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Zee nzhé Jesús lo re xaa: —Sbaa nzhé Ches lo re xey be nel tant ned doo xaa mod gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Per leezha mdexkwaa Dios yizhyo, tubka ngwnaa nu tubka xaabyi mchaal Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kwaanzee nzhé Dios: “Lee xaabyi roo lo xuz xaa nu lo xnaa xaa nu chelya rop sa xaa, ");
INSERT INTO zpoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","zee tubka kwerp gak rop xaa”. Gn. 2:24 Kwaanzee nagaktra xaa chop sinka tubka gak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dios mchaal rop xaa, zee nyent mod lux rop sa xaa yalnchelya. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Leezha mzhin re xaa mseed lo Jesús roo yoo, zee mnabdizh xaa lo Jesús nu nzhé xaa: —¿Xomod nak kwaan nzhé lu lo xaa zee? ");
INSERT INTO zpoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús nzhé lo re xaa: —Loka cho xaa laa xngwnaa nu ka xaa stub ngwnaa, mle xaa tub jwalt lo xngwnaa xaa, me mka xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nu noka ngwnaa, me laa sa nu ka me stub xaabyi, mle me tub jwalt lo xmbyi me, xaa mka me yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nzhano xaa re madwin lo Jesús, zee zhiib Jesús yaa Jesús cho mad. Per lee re xaa mseed lo Jesús mzelo mgalno re xaa nzhano madwin lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús nguneya zee nayii Jesús lo re xaa mseed lo xaa, nu nzhé Jesús: —Laa gu yiid re madwin lo na, nu nayiit gu lo mad. Nel Dios nabeyy leen lextoo re xaa nak kwenta re madwin ne. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Wlipa na nii na lo gu, loka cho gu nakayaat pa nabeyy Dios, mod tub madwin, nyent mod zeeb gu pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nu mdeezh Jesús re madwin, nu mzhib xaa yaa xaa yek re madwin, nu ngunaab xaa lo Dios kwent cheen re madwin. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tub mbizh leezha merla roo Jesús nzha, mzexonn tub xaa nu mkichxub lo Jesús, nu nzhé xaa: —Maestr wen. ¿Cho kwaan le na zee le na gan yalnaban kwaan tira? ");
INSERT INTO zpoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús nzhé lo xaa: —¿Chozhiin né lu lo na, na nak tub xaa wen? Nik tub xaa wen nyent, nebse Dios nak xaa wen. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nela lu re kwaan mlaa Dios le be. Re kwaane: naguta lu sa myet lu, nazoblazht lu kano lu stub ngwnaa, nalewannt lu, nagaazht lu tub kwaan nawlit tich sa myet lu, nakadet lu, nu nazeret lu diizh lo xuz lu nu lo xnaa lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Zee mkeb xaa nu nzhé: —Axta tik na mlozhaw na rese kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús mwii lo xaa nu mkela Jesús xaa. Zee nzhé Jesús lo xaa: —Tubka kwaan nzho jwalt le lu. Zyaa, nu bto rese kwaan nkano lu nu bzaaya lo re xaa prob, zee gap lu zyen doo kwaan naz leen yiba, nu breke tich na. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Per gorna mbin xaa kwaan nzhé Jesús lo xaa, nales doo ngok lextoo xaa, nel zyen doo kwaan nzhap xaa. Nu mzen xaa xnaz xaa nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús mwii lo re xaa nzhi baa, nu nzhé xaa lo re xaa mseed lo xaa: —Nagan doo zeeb tub xaa rik naz yiba, pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ndedyall doo re xaa mseed lo Jesús leezha mbin xaa kwaane. Per lee Jesús mbare ngunii lo re xaa stub welt nu nzhé xaa: —Xgaan na, aka nagan rep re xaa naz pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas nanagant ded tub kamey yeer cheen tub aguj, ke tub xaa rik le gan zeeb naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Rese xaa mseed lo Jesús mdedyall doo xaa nu nzhé xaa: —Chol sbaaya, ¿cho le gan nya naz leen yiba? ");
INSERT INTO zpoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús mwii lo re xaa, nu nzhé lo re xaa: —Lo re myet yizhyo ne nyent moda, per lee Dios reseya nzho mod le Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pér nzhé lo Jesús: —Wii lo rese nu, rese kwaan mlaa nu, nu mreke nu tich lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús nzhé: —Wlipa na kwaane, loka cho xaa laa li, laa wech, laa bzan nu bal, laa xuz, laa xnaa, laa xinn, laa xleyo, nel nzhekla xaa kee xaa xchinn na, zaa xaa kwent cheen wdizh chul cheen na, ");
INSERT INTO zpoNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","zee gayoo welt bareya lo xaa: li xaa, wech xaa, bzan xaa, bal me, xnaa xaa, xinn xaa, xleyo xaa lo yizhyo ne, per noka ted xaa xaa bid yizhyo ne. Per zhin mbizh zee kayaa xaa yalnaban kwaan tira leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mbizh zee, xaa kwaan non nal nagaknontra xaa zee; nu xaa kwaan nanont nal gak non zee. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mzen Jesús naz nzha xaa naz Jerusalén, nu nzhaner xaa lo re xaa nzhake tich xaa. Nu mdedyall re xaa, nu nle doo re xaa xgab. Zee mbe Jesús re chiibchop xaa mseed lo xaa tub lad, nu nzhé Jesús nen cho kwaan ded Jesús lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesús nzhé: —Bin gu kwaane. Ya be naz Jerusalén paro zaa xaa na lo re ngwleyy non, nu lo re maestr, xaa nlu xtizh Dios; nixa na nak Xaa Mzhin Ngok Myet. Re xaa ne yé: “Xaa ne nzhaal yet”. Zee zaa xaa na lo xaa nanakt xaa sawlazh be. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nu xizhno re xaa na, nu zaa re xaaya yenn na kwaan tub le yed, chuk re xaa lo na, nu gut re xaa na. Per lee mbizh yon, lee na roban stuba. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chag rop Juan, rop xgann Zebedeo, ngwa rop wech xaa lo Jesús nu nzhé xaa: —Maestr, nzhekla nu le lu tub jabor kwaan naab nu lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Zee mkeb Jesús nzhé: —Guné, nen cho kwaan nzhekla gu le na lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nu nzhé rop xaa: —Zaa diizh zee zob tub nu lad li lo lu, nu stub nu zob lad rebes lo lu, leezha nabeyy lu kwaan dub yalngezh cheen lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús mkeb nzhé lo xaa: —Nanet gu cho kwaan naab gu. ¿Che zye gu ded gu bid, kwaan merla deed na, nu yet gu kwentaxa yet na? ");
INSERT INTO zpoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Zee nzhé rop xaa: —Zye nu. Jesús nzhé lo xaa: —Wli, ded gu bid kwentaxa deed na bid, nu yet gu, kwentaxa yet na. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nyent mod zoob na gu lad li lo na nu lad rebes lo na, nel naleet na za kwaan zee. Kwaan zee kayaa re xaa naklakwent kayaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Leezha mbin xchii xaa mseed lo Jesús kwaane, zee nayii xaa ne xaa Juan rop Chag. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús mrezh re xaa nu nzhé lo re xaa: —Ne wen gu, re xaa nabeyy yizhyo ne, nabeyy doo xaa re xaa nzhi lo xaa, nu seeka re xaa non nabeyy doo xaa re xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per lee lo re gu nagakta sbaa, sinka rebes gaka. Loka cho xaa nzhekla gak non lo re gu, xaa zee gak xmos gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nu loka cho xaa nzhekla nabeyy lo re gu, xaa zee gak xaa le xchiin lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nel na nak Xaa Mzhin Ngok Myet, nu nanzhalt na zee kee re xaa xchinn na, sinka lee na nzhal zee kee na zhiin lo rese myet, nu yet na zee zii na zyen doo xaa lo yalgut nu za na yalnaban lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Leezha mzhin re xaa yezh Jericó, lee Jesús nzharoola leen yezh kwaan re xaa mseed lo xaa, nu re xaa nzha ke tich xaa. Lee tub syeg nzob roo naz naab gon lo re xaa. Xaa ne le Bartimeo, xgann Timeo. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Leezha mbin syeg lee Jesús, xaa yezh Nazaret nzhaded zee, zee mzelo xaa ngunii xaa dublegan: —Jesús, lu nak xaa dii cheen rey David, bles lextoo lu ne lu na. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Zyen xaa nzhi zee, nzhé lo xaa: —¡Saaw roo lu! ¿Cho bi tant kee lu? Per mas nkee xaa bi, nzhé xaa: —Jesús, lu nak xaa dii cheen rey David, bles lextoo lu ne lu na. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Zee mlaz Jesús nu nzhé lo re xaa: —Brezh gu xaa. Zee mrezh xaa syeg, nu nzhé xaa lo xaa: —Byakla lu; kabezh xaa lu. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nzholl xchamar xaa mlabi xaa, nu mkee xaa brink, nzha xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Zee mnabdizh Jesús lo xaa: —Guné, nen cho kwaan nzhekla lu le na lo lu. Lee syeg mkeb lo xaa nzhé: —Maestr, nzhekla na yani lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús nzhé: —Nzho mod yani zaalo lu, nel dub lextoo lu ngwii lu lo na, zee gakwen zaalo lu. Gorzee lee syeg nguni zaalo, nu mreke tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Gorna nzhazhin re xaa gaxla yezh Jerusalén, mzhin re xaa chop yezh le Betfagé nu Betania, gax yi le Olib, zee mxaal Jesús chop xaa mseed lo xaa, ");
INSERT INTO zpoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nu nzhé Jesús lo rop xaa: —Gwa gu yezh kwaan nzhi delant lo be nee. Nu gorna zhin gu yezh ba, ne gu lee tub burr yeen nkadoo, ma nik tub xaa zer zob tich. Xek gu ma nu yiidno gu ma lo na nee. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Chelee nzho cho nabdizh lo gu nu né xaa lo gu: “¿Chozhiin kaxek gu burr ba?”, yé gu lo xaa: “Xaa Nabeyy nkin ma, nu zeera yiidlaa xaa ma”. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nu gorna nzha rop xaa, ngune xaa lee burr nkadoo roo pwert roo naz nu gorzee mxek xaa ma. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nu lak xaa nzhi zee mnabdizh lo xaa: —¿Cho kwaan kale gu baa? ¿Chozhiin kaxek gu burr? ");
INSERT INTO zpoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Lee rop xaa nzhé kwaan nzhé Jesús lo xaa, nu mlaa re xaa mbe xaa burr. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nu nyaadno xaa burr lo Jesús, nu mzhib xaa xab xaa tich ma, zee mzob Jesús tich ma. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nu zyen doo xaa mbek xab leen naz nu stub naz xaa nchoog re ram yag nu mbek xaaya leen naz. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nu re xaa nzha delant nu re xaa nzeke naz tras snee mbazhe re xaa: —¡Chul nak Dios! ¡Gool be lo xaa nze kwaan yalnabeyy cheen Xaa Nabeyy! ");
INSERT INTO zpoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Era xwa leezha nabeyy xaa modxa mnabeyy David, xey be! ¡Wen nak Dios, xaa nzob naz yiba! ");
INSERT INTO zpoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zee mzeeb Jesús yezh Jerusalén nu mzeeb xaa lach roo yidoo, nu mwii xaa reta lad. Nel mzhela yizhyo, zee nya re xaa naz Betania. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Stub mbizh leezha mroo xaa Betania, ngok nlaan Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nu zit mlu tub yag ig lo xaa, kwaan nzeb lag lo, zee ngwa xaa loya, zee ne xaa nen che nzeb xle loya. Nu gorna mzhin xaa nyent xle loya, nebse lag nzeb loya, nel nanakt mbee nzaa xle. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Zee nzhé xaa lo yag ig: —Nik stub welt, nagawtra myet xle lo lu. Nu mbin re xaa mseed lo xaa see ngunii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Gorna mzhin Jesús yezh Jerusalén, mzeeb xaa lach roo yidoo, nu mzelo xaa mloo xaa re xaa kato, nu re xaa kazi. Nu mtexche xaa xmes re xaa kachee demi, nu mtexche xaa yagxil cheen re xaa kato palom. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nu nik tub xaa nzeno kwaan to, nanlaat xaa ded xaa lach roo yidoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nu mzelo xaa mseed xaa re xaa, nu nzhé xaa lo re xaa: —Nkeela lo Xkyech Dios nii: “Li na nak yoo pa wdizhno xaa rese yezh Dios”; per gu mleya kwenta tub pa nzho wann. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nu gorna mbin re ngwleyy nu re maestr xaa nlu xtizh Dios, kwaan nzhé Jesús, mzelo re xaa mkwaan mod nen xomod gut xaa Jesús, nel nzheb xaa ne xaa Jesús, nel rese xaa yezh nyula doo mod nseed xaa, nu mdedyall rese xaa ngwii xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Per gorna ngulo mzhel yizhyo, Jesús mroo kwaan re xaa mseed lo xaa Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Garziil, stub mbizh, zee mded re xaa lo yag ig, zee ne xaa axta loxa mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Zee mselazh Pér kwaan ngunii Jesús stub mbizh, zee nzhé xaa lo Jesús: —Wii maestr. Lee yag ig kwaan mxobde lu lo, mbizhla. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús nzhé: —Wii gu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Wlipa na kwaan nii na lo gu. Loka tub xaa yé lo yi ne: “Bachii nee nu bla axta leen nistoo”, nu nagakt chop yek xaa nu tubka ngwii xaa lo Dios, leeya gak. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kwaanzee nii na lo gu, rese kwaan naab gu lo Dios, Dios zaaya lo gu, nu nela gu lee gu kayaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nu gorna wdizhno gu Dios, yenlazh gu rese kwaan mle wechxinn gu lo gu, nu seeka noka Xuz be, xaa nzob naz leen yiba chee rese jwalt cheen gu kwaan mle gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Per chelee gu nayenlazht gu rese kwaan mle wechxinn gu lo gu, noka Xuz be, xaa nzob naz leen yiba, nacheet re jwalt cheen gu kwaan mle gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Zee mbare Jesús Jerusalén, nu gorna lee Jesús nzhaze lach roo yidoo, zee ngwa re ngwleyy non lo xaa, nu re maestr, nu noka re xaa gol lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nu mnabdizh xaa lo Jesús nzhé xaa: —¿Cho mzaa diizh le lu re kwaane?, nu ¿cho yalnabeyy nkano lu le lu re kwaane? ");
INSERT INTO zpoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús mkeb nzhé: —Noka na nabdizh lo re gu. Chelee re gu keb gu lo na, zee nii na lo gu nen cho xaa mzaa diizh le na re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Cho mxaal Juan xaa mchubnis re myet? ¿Che Dios mxaal xaa o re myeta? ¡Keb gu! ");
INSERT INTO zpoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nu lee re xaa mzelo mkediizh kwaan re wechxinn xaa zee nzhé xaa: —Chelee be yé be lo xaa: “Dios mxaal xaa”, zee né xaa lo be: “¿Chozhiin nambint gu xtizh xaa?” ");
INSERT INTO zpoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Chelee be yé be: “Re myet mxaal xaa…”, per nyent mod yé be sbaa —nzhé re xaa. Nel nzheb xaa ne xaa re myet, nel ngune re myet lee Juan nak tub xaa mzaa kwent kwaan nzhé Dios lo lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Zee nzhé xaa lo Jesús: —Nanet nu cho xaa mxaal Juan. Zee nzhé Jesús lo xaa: —Nixa na naniit lo gu cho xaa mzaa diizh nle na re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nu zee mzelo Jesús ngunii lo re xaa duzna kwent nabix. Nu nzhé xaa: —Na za tub kwent cheen tub xaabyi kwaan mxeen yag ub dubse xleyo. Nu msaaw xaa dub welta kwaan ke. Nu mdexkwaa xaa tub pa sii xaa ub, nu mdexkwaa xaa tub yoo naro doo pa luu dubse xleyo xaa lo xaa. Nu mzaa xaaya kompani lo stub xaa zee nachii xaaya, nu mroo xaa nzha xaa zit. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mzhin mbizh top xaa ub, zee mxaal xaa xmos xaa nzha lo xaa kanachii xkag ub xaa, zee lerol xaa re ub kwaan top xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Per lee re xaa kanachii xkag ub xaa mzen xmos xaa nu mzaaya yenn xaa, nu nik tub kwaan namzaat xaa lo xaa, mtexonn xaa xaa nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Zee lee xaa nak cheen leyo mbare mxaal stub xmos. Per lee re xaa kanachiiya mlee xaa yek xaa, nu mlo re xaa xkalnto xaa, mxizhno re xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nu mbare xaa mxaal xaa stub xmos xaa. Nu re xaa mbit re xaa ne. Per zeesi mxaal xaa zyen doo xaa ngwa, tub naz xaa mseweey xaa nu stub naz xaa mbit xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Nyentra cho mlake lo xaa, techosa tub xgann xaa, xaa tant nkedoola xaa. Per gwluzhtlaka mxaal xaa xgann xaa. Nu mle xaa xgab, nzhé xaa: “Xgaan na si, gon re xaa xtizh”. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Per lee re xaa kanachii xkag ub xaa, nzhé xaa lo re wechxinn xaa: “Xaa ne yizo dubse kwaane gorna yet bixwanna. Te gu, gut be xaa ne, zee lake reseya lo be, zee gaka xcheen be.” ");
INSERT INTO zpoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Zee mzen re xaa xaa nu mbit re xaa xaa nu mlebi re xaa xaa tub lad pa nanzhaant xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Lee Jesús mnabdizh lo re xaa nzhé: —¿Xomod nle gu xgab? ¿Cho kwaan le xaa nak bixwann leyo pa kanachii stub xaa xkyag ub xaa? Telisa ya xaa, nu gut xaa re xaa kanachiiya, nu zaa xaaya lo stub naz xaa zee nachii xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Che zer lab gu Xkyech Dios? Leeya nzhé: Lee ke kwaan mlebi re xaa nza yoo tub lad, leeya gak tub ke mas kwaan chul doo zob xaa naz skin yoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Lee Dios, Xaa Nabeyy be mle kwaane; nu ndedyall doo be ne beya. Sal. 118:22-23 ");
INSERT INTO zpoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zee nkwaan re xaa ba mod zen xaa Jesús nel mzeen re xaa lee kwent nabix kwaan ngunii Jesús nlu nen xomod nle xaa. Per nzheb re xaa ne re myet, zee mlaa re xaa Jesús nu nya re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nu zee mxaal xaa lak xaa fariseo nu lak xaa Herod, zee nzhanabdizh lo Jesús, zee ne xomod gaazh xaa tub kwaan tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Gorna mzhin xaa lo xaa nu nzhé xaa: —Maestr, ne nu lee lu nak tub xaa wen doo nu nali doo, nu nanlet lu xgab re kwaan nii xaa lo lu. Nali nlu lu xnaz Dios. Guné lo nu: ¿che nzhaal kix nu lo xaa kwaan ntop demi kwaan nya naz Roma o nanzhaalt kix nuya? ");
INSERT INTO zpoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per lee Jesús nela cho xgab nle xaa, zee nzhé Jesús lo xaa: —¿Chozhiin nzhekla gu gaazh gu kwaan tich na? Teno gu tub demi Roma zee wii na loya. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Zee nzeno xaa tub demi lo Jesús, nu zee mnabdizh Jesús lo xaa: —¿Cho yek nkee loya? ¿Nu cho le nkee loya? —nzhé Jesús lo xaa. Zee mkeb re xaa nzhé xaa: —Cheen César, xaa nabeyy Roma, xaa nabeyy lo be. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Zee mkeb Jesús nu nzhé xaa lo xaa: —Mbay. Zaa gu lo César kwaan nak cheen César, nu bzaa gu lo Dios kwaan nak cheen Dios. Kwaane nzhé Jesús lo re xaa. Zeesi ndedyall re xaa mbin xaa kwaan ngunii Jesús lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Lee re xaa saduceo nle xgab: “Lee re xaa ngut nanrobant”. Zee ngwa lak xaa ngunabdizh lo Jesús nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestr, Ches mkee lo Xkyech Dios nzhé: “Chelee tub xaabyi, xaa mchelya ngut nu nik tub xinn xaa namlaat xaa, zee lee wech xaa nzhaal chelya kwaan xngwnaa xaa ngut, zee kano xngwnaa xaa mad, zee naluxt dii cheen wech xaa”. Dt. 25:5 ");
INSERT INTO zpoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tub welt gazh wech xaa. Lee xaa yilotlaka mchelya, ta ngut xaa. Nu nik tub xinn xaa namlaat xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lee stub wech xaa, xaa nzeke tich xaa, mchelya kwaan lee me, nu noka xaa ne ngut nu nik tub mad namlaat xaa. Nu seeka ngok xaa yon. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nu yizasa gazh wech xaa mchelya kwaan lee me nu nik tub xaa namlaat mad. Nu gwluzhtlaka noka ngwnaa ngut. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chol roban re xaa, ¿xana xaa gak xmbyi me, nel yizasa gazh wech xaa mka me? ");
INSERT INTO zpoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Zee mkeb Jesús nu nzhé xaa: —Lee na nii lo gu, ¡tira nguyo gu! Nanlabeyyt gu kwaan nkee lo Xkyech Dios. ¿Che nanet gu ngezh doo Dios nu nzho mod le xaa rese kwaan? ");
INSERT INTO zpoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gorna roban rese xaa nixa re xaabyi nu nixa ngwnaa nachelyatra xaa sinka gak re xaa kwenta re mandad cheen Dios, xaa nzho naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nal nii na lo gu, wli roban re xaa ngut. ¿Che zer lab gu Xkyech Ches leezha ngunii Dios lo Ches leen bal yag kwaan kayek? Zee nzhé Dios lo Ches: “Lee na nak Dios cheen Abraham, Dios cheen Chak, Dios cheen Kob”, nzhé xaa. Ex. 3:6 ");
INSERT INTO zpoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Dios nanakt Dios cheen re xaa ngut, sinka Dios nak Dios cheen re xaa mban! ¡Tira nguyo gu! ");
INSERT INTO zpoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lee tub maestr xaa nlu xtizh Dios mbin lee Jesús rop xaa saduceo kadildiizh. Nu gorna ngune xaa lee Jesús wen mkeb lo re xaa, zee ngunabdizh xaa lo Jesús: —¿Xana kwaan mkee Ches nak mas kwaan non lo rese kwaan mnabeyy Dios le be? ");
INSERT INTO zpoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Lee Jesús mkeb nzhé: —Lee wdizh mas non kwaan mnabeyy xaa lo rese nak: “Sawlazh na, xaa Israel, kenzha rese gu, lee Dios Xaa Nabeyy lo be, tubka nak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nu nzhaal kela lu Xdios lu kwaan dub lextoo lu, nu kwaan dub yalnaban cheen lu, nu kwaan dub yek lu, nu kwaan dub yalngezh cheen lu.” Dt. 6:4-5 Kwaane nak kwaan mas non lo rese wdizh. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nu lee stub kwaan non doo nak: “Nzhaal kela lu wechxinn lu kwentaxa nkela lu lu”. Lv. 19:18 Nyentra stub wdizh kwaan mas nonra lo ropse kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Zee lee maestr xaa nlu xtizh Dios, nzhé: —¡Wli luya, maestr! ¡Wli lu kwaan né lu! Lee Dios Xaa Nabeyy lo be, tubka nak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nu nzhaal kela lu Xdios lu kwaan dub lextoo lu, nu kwaan dub yek lu, nu kwaan dub yalngezh cheen lu, nu nzhaal kela lu wechxinn lu kwentaxa nkela lu lu. Nonra kwaane ke rese ma kwaan nteed xaa lo Dios, nu rese gon kwaan nzek xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ngune Jesús lee maestr wen mkeb kwaan yalnzhak doo, zee nzhé Jesús lo xaa: —Merla nabeyy Dios leen lextoo lu. Zee rese xaa nzhi baa, nzheb nabdizh stub kwaan lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús kaseed re xaa lach roo yidoo, zee ngunabdizh xaa lo re xaa: —¿Chozhiin re maestr, xaa nlu xtizh Dios, mbezh: “Lee Xaa Xaal Dios Nabeyy nak dii cheen David”? ");
INSERT INTO zpoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nel leeka David ngunii kwaan Mbi Naban cheen Dios nu nzhé xaa: Dios, Xaa Nabeyy rese kwaan, nzhé lo Xaa Nabeyy lo na: “Zob lad li lo na, axtaka chezhin na rese xaa nayii ne lu zee kichxub xaa lo lu, nu zee gak xaa mod tub kwaan zhib lu nii lu tich”. Sal. 110:1 ");
INSERT INTO zpoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Leeka David nzhé lee xaa nak: “Xaa Nabeyy lo na”. ¿Xomod nzho mod yaad xaa dii cheen David nu leeka David mlole xaa: “Xaa Nabeyy lo na”? Nu lee zyen doo myet xaa nzhi nzhon xtizh Jesús nyakla. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Leezha kaseed Jesús re myet, zee nzhé Jesús lo re xaa: —Kanap gu gu zee nakadet re maestr xaa nlu xtizh Dios gu, nel re xaa ne nyula doo gak ler wen kwaan nzhak ngwleyy, zee kichyek re xaa lo xaa gorna nii xaa “dix” lo xaa lo xbi. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nu nkwaan re xaa pa non doo zob xaa, pa nkasa be nseed be xtizh Dios, nu nkwaan xaa tub pa mas non nzob xaa gorna nyu tub yalni. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nu nkiib xaa li re ngwnaa byud. Nu nzhedizhno xaa Dios xchee doo, zee wii re xaa respet lo xaa. ¡Per Dios ted xaa mas gro doo bid! ");
INSERT INTO zpoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tub welt nzob Jesús lach roo yidoo, gax paro ngo xaa gon leen alkansi. Zee mwii Jesús ngo re xaa gon leen alkansi. Zyen doo xaa rik ngo zyen demi leena. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nu mzhin tub ngwnaa byud, me prob doo, nu mlo me chop rel leen alkansi. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Zee mrezh Jesús re xaa mseed lo xaa, nu nzhé xaa: —Wlipa na kwaan nii na lo gu, mas non gon kwaana mlo ngwnaa byud ne leen alkansi, ke re gon kwaan ngo re xaa rik. ");
INSERT INTO zpoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nel rese xaa rik mlo gro doo demi leen alkansi, per nebse mlo xaa re kwaan mlake lo xaa. Per lee ngwnaa prob ne mlo rese demi kwaan nkano me, kwaan nak kwaan zi me kwaan gaw me. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Gorna mroo Jesús lach roo yidoo lee tub xaa mseed lo Jesús nzhé lo Jesús: —¡Yisutisuti, wii maestr! ¡Chul doo nzhak re ke gro cheen yidoo ne, nu chul doo nzhak re yoo cheen yidoo ne! ");
INSERT INTO zpoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Per lee Jesús mkeb nzhé: —Naro doo yidoo. ¡Per nik tub ke ne nalaketra tich sa ke ke, rese kwaane lux! ");
INSERT INTO zpoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Zee ngwa Jesús nu mzob xaa yek yi le Olib paro nyun yidoo lo xaa. Leezha nebse Pér, Chag, Juan, nu Ndres nzo kwaan Jesús, zee mnabdizh xaa lo Jesús, nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Nzhekla nu né lu lo nu cho gor gak re kwaane. ¿Nu xana nseyn luu lo nu, gorna lee re kwaane zelo gak? ");
INSERT INTO zpoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús mkeb lo xaa nu nzhé xaa: —List gok gu zee nik tub xaa nakadet gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nel zyen doo xaa yiid né: “Na nak Crist, Xaa Mxaal Dios Nabeyy”. Nu kade xaa zyen doo myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Per gorna gon gu lee dil nzho nee nu nzho naz baa, nazhebt gu, nel see nzhaal gaka. Per nalet re kwaane nak kwaan lux yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kwaanzee tub yezh dil kwaan stub yezh. Nu zyen doo pa gun xog nye doo, nu zyen doo pa la win. Nu leezha gak re kwaane pensa nzelo re myet nded bid, mod tub ngwnaa me zan xinn. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Per list bzo re gu, nel yilaa xaa gu lo re xaa nak zhiin, nu zaa xaaya yenn gu pa nkasa re be nseed be xtizh Dios. Nel nak gu xaa na, zee yilaa xaa gu lo re xaa nabeyy nu lo re rey. Snee nzho mod zaa gu kwent cheen na lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Gorna zer lux yizhyo, lee xtizh Dios nkin rech rese yezh. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nu gorna kwezh xaa gu, nu yilaa xaa gu lo re xaa nak zhiin; nalet gu xgab cho kwaan keb gu, nel Mbi Naban cheen Dios né lo gu cho kwaan keb gu gorzee. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Leeka wech xaa yalaa wech xaa lo yalgut; nu sbaaka lee xuz xaa zaa xaa xinn xaa; nu gaya gak xinn xaa lo xuz xaa nu lo xnaa xaa, zee gut xaa xuz xaa nu xnaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Rese xaa nzhi yizhyo yii ne rese gu nel nzaa gu kwent cheen na. Per loka xaa ye ded re kwaane axta gwluzhtlaka, xaa ba le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Zee gorna wii gu lee kwaan nakap doo kwib lo pa nanzhaalt kwiba, zee lee re xaa nzho yizhyo Judea nzhaal xonn xaa nya naz yi. (Xaa lab kwaane nzhaal laya yek xaa.) ");
INSERT INTO zpoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nu re xaa nzob yek yoo mbizh zee, nayatra xaa leen li xaa koo xaa xcheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nu re xaa nzha naz wen, nabaret xaa top xaa xab xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ay, nales doo nzhak re ngwnaa, me nakxiin nu re ngwnaa me nkee madoo laz mbizh zee. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Naab gu lo Dios zee nagakt kwaane mbee kwaan nla doo nal. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwaanzee re mbizh zee, gak tub mbizh mas bidra ded re myet, ke rese bid kwaan mded re xaa axta leezha mdexkwaa Dios yizhyo axta mbizh zee, nu nadedtraya stub bes gwluzh. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nu chol Xaa Nabeyy nanglerolt re mbizh zee, nik tub xaa nangeta axta gwluzh. Per lee xaa mlerola nel nkela xaa re xaa mleey xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Nu mbizh zee chelee tub xaa nii lo gu: “Wii nee, lee Xaa Mxaal Dios Nabeyy nzo nee”. “Wii nee, lee Xaa Mxaal Dios Nabeyy nzo baa”, nagont gu xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yiid re xaa kade; nu re xaa né: “Na nak Xaa Mxaal Dios Nabeyy”, nu zlak xaa né: “Na nak xaa nzaa kwent kwaan né Dios lo na”, per nawlit xaaya. Zyen kwaan gro doo le xaa, nu luu xaa re nseyn gro doo zee kade xaa re myet, axta re xaa mleey Dios nzhekla xaa kade xaa, per nyent moda. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Per list bzo gu; rese kwaan yilo ngunii na lo gu gorna zeeraka gaka. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Gorna ngulo nguxoob mbizh ded re xaa bid gro doo, zee lee mbizh nu mbee nazaatra xni, ");
INSERT INTO zpoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","zee lee re mbal gab yiba, nu lee re kwaan nzho naz leen yiba xiz. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Zee wii re xaa lo na, Xaa Mzhin Ngok Myet, yaad naz leen xkaw, kwaan yalngezh cheen na nu xni cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Zee xaal na re mandad cheen na, zee top xaa re xaa mleey na dubse yizhyo, axta pa mas zit lo yizhyo nu lo yiba. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Bseed gu lo yag ig, gorna lee re ram cheena merla koo lag, zee ne gu lee mbee kwaan la neey mzhin gaxla. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kwaanzee gorna ne gu lee re kwaane kayakla, zee ne gu lee na, Xaa Mzhin Ngok Myet, listla nzo na roo pwert yal na. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Wlipa na nii na lo gu, rese kwaane yilo gak zeera yet re myet xaa mban re mbizh zee. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lee yizhyo nu yiba lux per lee xtizh na nadedt. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Nik tub xaa nanet pa gor zhin mbizh zee, nixa re mandad cheen Dios naneta, nixa na xaa nak mer Xgann Dios nanet na pa gor, nebse Xuz na ne pa gora. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Per list bzo gu nu kanap gu gu, nel nanet gu cho gor zhin mbizh zee. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kwaane nak kwenta tub xaa roo ya stub yezh. Nu gorna mroo xaa nzha xaa mlaa xaa re xmos xaa kanap li xaa. Nu mzaa xaa tub zhiin le re xmos xaa. Nu mlaa xaa tub xaa kanap roo yoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","See list bzo gu, nel nanet gu cho gor bare xaa nak li yoo. Nzho mod zhin xaa mkaw yizhyo, o zhin xaa wall yaal, o gorna kozhe gaay, o nzekaxnila yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Zee napa gorna kazhin xaa lo gu lee gu naxna. ");
INSERT INTO zpoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kwaane nak kwaan kanii na lo gu, noka kanii naya lo rese myet: List bzo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nzho jwalt chop mbizh la yalni kwaan le Paskwa, zee selazh re nu, xaa Israel, xomod mloo Dios re xey nu Egipto, nu lo yalni ne nzhaw nu pan kwaan nanyut lebadur. Zee lee re ngwleyy non nu re maestr, xaa nlu xtizh Dios, kakwaan xaa mod zen xaa Jesús xlaan, zee gut xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Per nzhé re xaa: —Nalet beya leen yalni, zee nanet re myeta, zee nanayiit re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús nzo yezh Betania, garli Simón, xaa ngok ne lo tub yalyizh kwaan nyall cho xaa. Nu kayaw re xaa, zee lee tub ngwnaa nzhano tub bot dik kwaan mdexkwaa kwaan ke le alabastro. Nu nyazhe perfum kwaan chul doo nzebech leena, kwaan nak cheen yeey le nardo, kwaan non gro doo demi. Nu mlee me bot dik kwaan nak ke nu mxo me perfum yek Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Per lee lak re xaa nzo zee nayii xaa, nu nzhé xaa lo wechxinn xaa: —¿Chozhiin sbaasa mlux ngwnaa ne perfum ba? ");
INSERT INTO zpoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Lee perfum ba non lal le xaa gan kee xaa tub liin zhiin. Nzho mod ngdooya, zee ngzaa be demi lo re xaa prob. Nu mzelo re xaa mgalno xaa ngwnaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Per Jesús nzhé: —Laa gu me. ¿Chozhiin ngalno gu me? Lee kwaan mle me lo na nak tub kwaan wen doo. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nel lee re xaa prob tubka nzo lo re gu, nu nzho mod le gu wen lo xaa gorna nzhekla gu, per na, nazot na lo gu tubka. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Per ngwnaa ne mle kwaan nzho mod le me, mlo me perfum ne cho na gorna zeeraka sebyo re xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Wlipa na nii na lo gu, dub yizhyo pa wdizh xaa wdizh chul cheen na, zee noka zet xaa ngwnaa ne, zee selazh xaa me. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote nak tub xaa lo chiibchop xaa mseed lo Jesús, ngwa lo re ngwleyy non, zee yaan xaa zee zaa xaa Jesús lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nu gorna mbin re xaaya, zeesi nyakdoola re xaa. Nu nzhé xaa: —Kix nu ka lu. Zee lee Judas mkwaan mod zee zaa xaa Jesús lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nu mbizh yilotlaka lo yalni kwaan le Paskwa, pa nzhaw nu pan kwaan nanyut lebadur. Nu noka nzhaw nu mbakxiil kwaan nteed nu, zee nselazh nu xomod mloo Dios xey nu Egipto. Nu lee re xaa mseed lo Jesús nzhé lo xaa: —¿Pa nzhekla lu ya dexkwaa nu kwaan gawxchee be lo yalni ne? ");
INSERT INTO zpoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Zee mxaal Jesús chop xaa mseed lo xaa, nu nzhé xaa lo xaa: —Gwa gu yezh, nu baa ne gu lo tub xaabyi nyano tub re nis. Reke gu tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nu loka pa zeeb xaa, yé gu lo xaa nak li yoo: “Lee Maestr né: ‘Nzhekla na gaw na kwaan re xaa mseed lo na xchee kwaan le Paskwa. ¿Pa nzob yoo gaw nu leen?’” ");
INSERT INTO zpoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nu zee luu xaa tub yoo ndok lo gu kwaan nak stub pis leen yoo ndok, pa nzho rese kwaan. Baa dexkwaa gu kwaan gaw re be. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nu mroo rop xaa mseed lo Jesús. Nu mzhin xaa yezh. Nu nguzhal xaa re kwaan kwentaxa nzhé Jesús lo xaa, nu mdexkwaa xaa kwaan gaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nu gorna nzelala yalnakaw, zee mzhin Jesús kwaan chiibchop xaa mseed lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nu gorna kayaw re xaa, Jesús nzhé lo xaa: —Wlipa kwaan nii na. Lee tub gu, xaa kayaw kwaan na nee, zaa na lo re xaa nayii ne na. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Zee ngok nales lextoo re xaa, nu tubga xaa tubga xaa mzelo nabdizh lo Jesús: —¿Che naya? ");
INSERT INTO zpoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nu lee Jesús mkeb nzhé: —Lee xaa nak tub lo chiibchop gu, tub xaa noka nle bsii pan leen tubka yann kwaan na. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wlipa na nii na lo gu, lee na Xaa Mzhin Ngok Myet, nzhaal ded doo bid mod nii Xkyech Dios. Per tira nawent ded xaa zaa na lo re xaa. Mas wen nzela xaabyi zee nangalt xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nu gorna kayaw re xaa, lee Jesús mzen pan, nu mzaa xaa dixkix lo Dios, nu mlerol xaaya, nu mzaa xaaya lo re xaa mseed lo xaa. Nu nzhé xaa: —Daw guya, kwaane nak xbaal na. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nu mzen xaa bas. Nu mzaa xaa dixkix lo Dios, nu mzaa xaaya lo re xaa mseed lo xaa, nu ngu re xaa nis kwaan nzho leen bas. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nu lee Jesús nzhé: —Kwaane nak xren na. Leeya dexkwaa wdizh kub kwaan laa Dios, nu leeya xo na zee zyen doo myet le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Wlipa kwaan nii na lo gu, nalsi nagotra na xis ub axta mbizh kwaana go na xis ub kwaan kub pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Gorna ngulo mbill xaa, nu nzha xaa naz yi kwaan le Olib. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zee lee Jesús nzhé lo re xaa mseed lo xaa: —Nalyall lee re gu laa na, nel Xkyech Dios niiya: “Gut na xaa nkano mbakxiil, zee lee re mbakxiil rech reta naz”. Zac. 13:7 ");
INSERT INTO zpoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per gwluzh gorna roban na, yilotlaka na zhin yizhyo Galilea lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Zee nzhé Pér lo xaa: —¡Per nixa rese xaa laa lu, per na tira nalaat na lu! ");
INSERT INTO zpoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Per Jesús nzhé lo xaa: —Wlipa na nii na lo lu, leeka nalyall, zeeraka kozhe gaay chop welt, lee lu yé chon welt, nanlabeyyt lu na. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nu lee Pér mas nye mkeb, nu nzhé: —Per nixa yet na kwaan lu, per tira nayét na: “Lee na nanlabeyyt lu”. Nu rese xaa nzhé leeka kwaan nzhé Pér. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Zee mzhin xaa leen tub yilo kwaan le Getsemaní zee Jesús nzhé lo re xaa mseed lo xaa: —Zob gu nee, lee na yawdizhno Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nu mbe xaa Pér, Chag, nu Juan, nu mzelo lextoo xaa nxonn doo nu nales nzhak. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nu nzhé xaa: —Nales doo nzhak lextoo na nal, nel merla yet na. Lakeka re gu nee, nu tubka zo gu kwaan na. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Zee lee Jesús mze xep. Nu mkichxub xaa axta ngol lachuzh xaa lo yo. Nu ngunaab xaa lo Dios, zee nadedt xaa yalne kwaan nzhaal ded xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nu nzhé xaa: —¡Pa! Rese kwaan nzho mod le lu. Nalaat lu deed na bid ne, per nagakta kwentaxa nzhekla na, sinka kwentaxa nzhekla lu. See gaka. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nu zee mbare xaa, pa mlaa xaa yon xaa nu gorna mzhin xaa lo xaa; lee yon xaa naxna. Zee nzhé xaa lo Pér: —Simón, ¿che naxna lu? ¿Che nik tub gor nayet lu lo mkaal? ");
INSERT INTO zpoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lakeka gu stub welt nu nagaat gu bdizhno gu Dios, zee nakiilt Maxuu gu. Wlipa na nii na lo gu, lee xgab cheen gu nzhekla le kwaan nzhekla Dios, per lee baal cheen gu nayet leya. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nu zee ngwa xaa stub welt nu mdizhno xaa Dios. Ngunii xaa leeka re kwaan nzhé xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Zee mbare xaa paro mlaa xaa yon xaa stub welt, nu gorna mzhin xaa lo xaa lee yon xaa naxna, nel nayetra xaa lo mkaal. Nu nanetra xaa cho kwaan keb xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ngok yon welt ngwawdizhno xaa Dios, nu gorna mbare xaa paro mlaa xaa yon xaa, zee nzhé xaa lo yon xaa: —¿Che seetaka naxna gu? ¡Kenzha gu! Mzhinla gor zaa xaa na lo re xaa mle jwalt, nixa na nak Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Guxche gu, chaa gu nya be, nel nzela xaa zaa na lo re xaa nayii ne na. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Seetaka kanii Jesús lo re xaa mseed lo xaa, lee Judas, xaa ngok tub xaa lo chiibchop xaa mseed lo Jesús, mzhin kwaan zyen doo xaa nzeno espad nu nzeno yag. Re xaa ne nze kwent cheen re ngwleyy non, nu cheen re maestr, xaa nlu xtizh Dios, nu kwent cheen re xaa gol. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ngulola mzaa Judas nseyn lo re xaa, nzhé xaa: —Loka xana xaa gaw na bit tagarlo, xaa zeeya; zen gu xaa, nu wee gu xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gorna mzhin Judas, nu mbii xaa lo Jesús nu nzhé xaa lo xaa: —Maestr. Nu ndaw xaa bit tagarlo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Zee mzen re xaa Jesús nu mbe xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Per tub xaa nzo kwaan Jesús, mloo espad nu mchoog nzha xmos ngwleyy non doo. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús nzhé lo re myet: —¿Chozhiin nze gu kwaan spad nu kwaan yag zen gu na kwenta tub wann? ");
INSERT INTO zpoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Zyen doo mbizh mzo na lo re gu, mseed na re myet lach roo yidoo. Nu nik tub welt namzent gu na. Per kwaane kayak kwentaxa nzaa Xkyech Dios kwent. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Zee lee re xaa mseed lo Jesús mrexonn nu mlaa xaa techo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Per tub xaa mad nzhake tich Jesús, nak xaa tublaka ler, nu mzen re xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Per lee xaa ne mlaa ler nak, nu cheey xaa mrexonn. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Zee mbe xaa Jesús lo ngwleyy non doo, nu zee mdop re ngwleyy non nu re xaa gol nu re maestr xaa nlu xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Per lee Pér zit zit nzhake tich re xaa, mzeeb xaa lach jwer li ngwleyy non doo. Nu mzo xaa kwaan re polisi, xaa kazhe lo bal. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nu lee re ngwleyy non, nu re xaa nak zhiin kakwaan xaa tub mod ne xomod gaazh xaa tub kwaan tich Jesús zee gut xaa xaa, per nanguzhalt mod lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nu zyen doo xaa ngaazh kwaan tich Jesús per duzna nkade re xaa, nu xa kwaan nii tub xaa nii stub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nu lak xaa nguxso mgaazh kwaan tich Jesús per nkade xaa nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Mbin nu lee lu nzhé: “Na lux yidoo ne kwaan mdexkwaa yaa re myet, nu chonaka mbizh dexkwaa naya stuba, kwaan nadexkwaat yaa re myet”. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per nixa sbaa mbezh xaa per nalalt nii re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nu zee lee ngwleyy non doo mzoli lo re xaa, nu mnabdizh lo Jesús nu nzhé: —¿Chozhiin nik tub kwaan namkebt lu? ¿Cho kwaan komba nii re xaa lo lu? ");
INSERT INTO zpoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Per lee Jesús nik tub kwaan namkebt lo ngwleyy non doo. Zee lee ngwleyy non doo mbare mnabdizh lo Jesús, nu nzhé xaa: —¿Che lu nak Crist, Xaa Mxaal Dios Nabeyy? ¿Che lu nak mer Xgann Dios? ");
INSERT INTO zpoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús mkeb nzhé: —Naya. Nu wii gu lee na, Xaa Mzhin Ngok Myet, zob lad li lo Dios, xaa nzho mod nle rese kwaan. Nu wii gu, lee na yal leen xkaw naz yiba stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nu zee lee ngwleyy non doo mchaz leeka xab, nu nzhé xaa: —¡Nankintra be stub testig! ");
INSERT INTO zpoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","—nzhé xaa—. ¡Ngulola mbin gu ngunii xaa kwenta Dios! ¿Xomod nle gu xgab lo kwaane? Zee rese xaa nzhé: —¡Nzhaal yet xaa! ");
INSERT INTO zpoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nu mzelo lak xaa mchuk lo xaa, nu msaaw xaa garlo xaa nu mdin xaa xaa. Nu nzhé xaa lo xaa: —¡Né, cho xaa mkee yek lu! Nu lee re polisi mzaa golp garlo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nu lee Pér mzob lach jwer garli ngwleyy non doo, zee mzhin tub ngwnaa mad, me nkee zhiin lo ngwleyy non doo. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nu gorna ngune me lee Pér kazhe lo bal, zheta mwii me lo Pér, nu nzhé me: —Noka lu mze kwaan Jesús, xaa yezh le Nazaret. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pér nzhé: —Nanlabeyyt na Jesús, nixa nanet na cho kwaan né lu. Nu gorzee mroo xaa paro nze bal, nu mya xaa roo korredor, zee lee gaay mbazhe tub roo. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Zee mwii me lo xaa stub welt, nu nzhé me lo re xaa nzhi zee: —Me nee nak tub me nzho lo re me. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Per lee Pér mkeb nu nzhé stub welt: —Nanlabeyyt na xaa. Nu gwluzh xep lee re xaa nzhi zee nzhé lo Pér stub welt: —Wli nuya. Lu nak tub xaa nzho lo xaa, nel lu nak tub xaa yizhyo Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Zee lee Pér mzelo mde, nu mzet Dios nu nzhé lo re xaa: —¡Wlipa na, nanlabeyyt na xaabyi ba! ¡Nu nanet na cho kwaan mbezh gu lo na! ");
INSERT INTO zpoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nu gorzee lee gaay mbazhe rop welt. Zeera lee Pér mselazh kwaana nzhé Jesús lo Pér yilo: “Zeeraka kozhe gaay chop welt lee lu yé chon welt nanlabeyyt na”. Nu gorna mselazh xaa kwaane, mzelo xaa mbinn xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Garziil doo mkasa re ngwleyy non, nu re xaa gol, nu re maestr xaa nlu xtizh Dios, nu re xaa nak zhiin lo re nu. Rese xaa ne myaan zee zaa xaa Jesús lo Pilat, xaa nabeyy zee. Nu gwluzh zeera mkado xaa Jesús nu mbe xaa Jesús lo Pilat. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat mnabdizh lo xaa nu nzhé: —¿Che lu nak Rey cheen re xaa Israel? Zee Jesús mkeb nzhé: —Sbaa naka, kwentaxa nguné luya lo na. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nu lee re ngwleyy non mzelo mgaazh zyen doo kwaan tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Stub welt lee Pilat mbare mnabdizh lo Jesús nu nzhé: —¿Chozhiin nik tub kwaan nankebt lu? ¡Wii, lakta kwaan ngaazh re myet tich lu! ");
INSERT INTO zpoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Per lee Jesús nik tub kwaan namkebt lo xaa. Zee lee Pilat mdedyall doo mwii lo xaa nu nanetra xaa cho kwaan le xaa xgab. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Rese liin leezha nla yalni ne, Pilat nsela tub xaa nzho lozhyib, loka xaa yé re xaa yezh sela xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nu tub xaa le Barrabás nzho lozhyib, xaa nzho tubka kwaan lak xaa mbit myet, leezha mdil xaa kwaan re xaa Roma. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nu zee ngwa re myet lo Pilat, nu mzelo xaa ngunaab xaa lo Pilat, zee sela xaa tub xaa kwentaxa nle xaa rese liin. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nu lee Pilat mkeb nzhé: —¿Che nzhekla gu sela na Jesús, Rey cheen gu, xaa Israel? ");
INSERT INTO zpoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Snee nzhé Pilat nel nela xaa lee re ngwleyy non nangulat reke zyen doo myet tich Jesús zee ngulaa re ngwleyy non Jesús lo Pilat. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per lee re ngwleyy non nzhéya, zee yé re xaa lo Pilat sela xaa Barrabás. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Zee Pilat mnabdizh nzhé: —Guné gu, nen cho kwaan nzhekla gu le na kwaan xaa ne, xaa mbezh re xaa nak Rey cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nu lee re xaa nzhé dublegan: —¡Kee xaa lo krus! ");
INSERT INTO zpoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Per lee Pilat nzhé lo re xaa: —¿Cho kwaan nawent mle xaa ne? Per lee re xaa mbare nzhé stub welt: —¡Kee xaa lo krus! ");
INSERT INTO zpoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Zee lee Pilat nzhekla kwi wen kwaan re myet, zee msela xaa Barrabás, nu mnabeyy xaa xsoldad xaa zee mdin xaa Jesús nu kee xaa xaa lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nu zee lee re soldad mbe Jesús lo lach jwer pa nzho Pilat, nu mrezh xaa rese soldad. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nu mlo xaa tub ler naxne yenn xaa, kwenta kwaan nzhak rey. Nu mzob xaa tub koron yek xaa kwenta cheen rey, per kwaan yich mdexkwaa xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nu mzelo re xaa mbazhe nu nzhé re xaa: —¡Xwa doo Rey cheen re xaa Israel! ");
INSERT INTO zpoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nu mzaa golp xaa yek xaa kwaan yag nu mchuk xaa lo xaa, nu mkichxub re xaa lo xaa modxa mkichxub re xaa lo rey. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nu gorna ngulo mzhitno re xaa xaa, zee mloo xaa ler naxne yenn xaa, nu msegak xaa xaa leeka xab xaa. Nu mloo xaa xaa, mbe xaa xaa, kee xaa xaa lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tub xaa yezh Cirene le Simón, xuz Jant nu Rufo, nyaad ngwa wen. Nu gorna nyaad ded xaa, zee mnabeyy soldad xaa zee wee xaa xkrus Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nu mbe re xaa Jesús tub pa le Gólgota. (Wdizh ne nii: “Zhit Yek Xaa”.) ");
INSERT INTO zpoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nu mzaa xaa xis ub kwaan nzho mirra leen ngu xaa, per nangut Jesús kwaan ba. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nu zee mkee re soldad xaa lo krus. Nu mloo re xaa swert nen cho xaa le gan xab xaa, zee nen cho kwaan yizo kad tub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Gorna mkee xaa Jesús lo krus nak las nueve garziil. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lee letr kwaana mkee xaa yek xkrus xaa nzhé: “REY CHEEN RE XAA ISRAEL”. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nu xsaww chop wann mkee xaa xaa, tub wann lad li nu stub xaa lad rebes. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nu sbaa ngok zee mbarlo Xkyech Dios kwaana nzhé: “Lee xaa ne ngu kwent lo re wann”. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nu lee re xaa nded zee mxizhno xaa nu mbib xaa yek xaa lo xaa, nu nzhé re xaa lo xaa: —Lu nzhekla lux yidoo cheen Dios, nu nzhé lu chonaka mbizh za luya stuba. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Chol tant xwa lu, nalaat lu lux lu, leeka lu sela lu lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nu noka re ngwleyy non nu re maestr, xaa nlu xtizh Dios, mxizhno xaa xaa nu mbezh xaa lo wechxinn xaa: —Nanlaat xaa nget stub xaa, per chozhiin nyent mod sela xaa leeka lee xaa lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Noka mbezh re xaa: —Né lu lee lu nak Xaa Mxaal Dios Nabeyy lo re nu. Nal leeka lu sela lu lo krus, zee ne nu lee lu nkano yalnabeyy cheen Dios zee wii re nu lo lu. Nu axta rop wann, xaa nkee xkwes xaa mxizhno xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nu gorna ngok rol mbizh, dubse yizhyo mla yalnakaw, nu gorna ngulo mded chon gor, ");
INSERT INTO zpoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","lee Jesús mbazhe nye nzhé: —Eloi, Eloi, ¿lama sabaktani? (Wdizh ne nii: “Xdios na, Xdios na, ¿chozhiin mlaa lu na?”) ");
INSERT INTO zpoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nu lee lak xaa nzo zee, mbin ngunii xaa, zee nzhé xaa lo re xaa: —Bkenzha gu. Lee xaa kabezh Li, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Zee lee tub xaa mrexonn nzhale bsii xiil kwaan xis ub kwaan nala nu nzhazaa xaaya go Jesús. Per lee stub xaa nzhé lo xaa: —Laa, nazaat luya go xaa, zee ne be nen che zyiid Li la xaa lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Per Jesús gorzee mbazhe dub gan, ta ngut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Zee lee ler kwaan nyaaw roo Pa Nambey Doo leen yidoo, mzelo mraz axta yek nu axta xan, nu ngoka chop lee. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nu lee tub xaa nabeyy lo tub gayoo soldad, xaa nzo naz delant lo Jesús, ngune xaa xomod ngut Jesús nu nzhé xaa: —Wlipa, xaa ne ngok Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nu noka zit nzhi lak ngwnaa ngwii. Lo re me nzo Mari me yezh Magdala, nu Mari xnaa Chag yeen nu Che, nu Salomé. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Re ngwnaa ne mreke tich Jesús, nu mle re me yudar xaa gorna mkanze xaa yizhyo le Galilea. Nu zyen doo ngwnaa Galilea mreke tich Jesús naz Jerusalén nu noka re me nzo zee. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Zhe kwaan mbit xaa Jesús nak tub mbizh kwaan ndexkwaa re nu kwaan gaw nu zhe sab, zhe kwaan nzholl re nu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Leezha mzhel yizhyo tub xaa le Che kwaan dub lextoo xaa mzeeb xaa pa nzo Pilat. Xaa ne nak tub xaa yezh le Arimatea, nu noka nak xaa tub xaa nabeyy lo re sawlazh nu, nu noka nkambaz xaa mbizh nabeyy Dios. Nu ngwa xaa lo Pilat xaa nabeyy zee, nu ngunaab xaa xkwerp Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mdedyall Pilat gorna mbin xaa lee Jesús ngulola ngut. Zee mrezh xaa tub xaa nabeyy lo tub gayoo soldad, zee mnabdizh xaa lo xaa, nu nzhé xaa: —¿Che ngulola ngut Jesús? ");
INSERT INTO zpoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nu lee xaa nabeyy lo tub gayoo soldad nzhé: —Ngutla xaa. Zee mzaa Pilat diizh wee Che xkwerp Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zee lee Che mzi tub ler kwaan wen, nu mla xaa xkwerp Jesús, zee mchaal xaaya ler, nu mlo xaaya leen tub baa kwaan mdeen xaa cho ke, nu msaaw xaa tub ke naro doo roo baa. ");
INSERT INTO zpoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari me yezh Magdala nu Mari xnaa Che, mwii me pa mlo xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Leezha ngulo mded zhe sab, zhe kwaan nzholl re nu lo Dios, Mari me yezh Magdala, nu Salomé, nu Mari xnaa Chag, mzi me perfum kwaan chul nzebech, zee yilo meya xkwerp Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nu pensa mlen mbizh, nzha re me roo baa zhe dming, pa mlo xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Zee nzhé me lo wechxinn me: —¿Cho xaa kiib ke kwaan nyaaw roo baa gorna zhin be? ");
INSERT INTO zpoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Zee mwii yon me, lee ke ndok doo kwaan msaaw xaa roo baa, nazobtraya roo baa. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nu gorna mzeeb me leen baa, mlu tub xaa mad nzob lad li lo me, xaa nak tub ler rus ler noll, kwaan nla axta nii xaa. Nu mzheb doo yon me. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nu lee xaa mad nzhé lo yon me: —Nazhebt gu. Gu kakwaan Jesús xaa Nazaret, xaa mkee re xaa lo krus. ¡Mrobanla xaa! ¡Nyentla xaa nee! Wii gu pa mzhib xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Zyaa gu nu guzh guya lo Pér nu lo re stub naz xaa mseed lo xaa. Yé gu lo re xaa: “Yilo xaa ya yizhyo Galilea lo re gu. Baa wii gu lo xaa, kwentaxa né xaa lo gu”. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Zee lee yon ngwnaa mrexonn mroo leen baa, nu nebse nxiz me lo yalnacheb. Nu nik tub lo nanzhét meya, nel mzheb me. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Gwluzh leezha ngulo mroban Jesús mkaxni yizhyo zhe dming, yilotlaka lo Mari, me yezh Magdala, mlu xaa, me mloo xaa tub gazh mbi mal lextoo. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nu gorna mbare me nya me, nu nzhé meya lo re xaa mze kwaan Jesús. Per lee re xaa mze kwaan Jesús nxonn doo lextoo xaa nu nzhonn xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Gorna nzhé me: “Mban Jesús, ngune na lo xaa”, per lee re xaa nzak nawlit meya. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ngulo mded kwaane, Jesús myun stub mod lo chop xaa nzha naz wen. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Zee lee rop xaa ne mbare Jerusalén nu nzhé xaaya lo re xaa mze kwaan Jesús, per nixa xtizh rop xaa ne namlet xaa krer. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mas gwluzh mlu xaa lo re chiibtub xaa mseed lo xaa. Mgalno xaa re xaa leezha kayaw re xaa, nel seetaka nzhak ned lextoo xaa nu nanlet xaa krer leezha nzhé xaa lo xaa, lee xaa roban. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nu nzhé Jesús lo re xaa: —Gwa gu dubse yizhyo, nu zaa gu kwent cheen wdizh chul cheen na lo rese myet. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Loka xana xaa mkayaa wdizh chul cheen na, zee chubnis gu xaa, zee le xaa gan yalnaban kwaan tira. Per lee xaa nakayaat wdizh chul cheen na, Dios xaal xaa lo ki. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Re kwaane le re xaa mkayaa wdizh chul cheen na: kwaan yalnabeyy cheen na koo xaa zyen mbi mal lextoo re myet, nu wdizh xaa stub naz diizh, ");
INSERT INTO zpoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","nzho mod zen xaa mball kwaan yaa xaa, nu chelee xaa go xaa kwaan nzho kwaan leen nyent cho gak xaa, nu zhib xaa yaa xaa yek re xaa ne nzak, zee lee re xaa ne nzak yakwen. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nu ngulo ngunii Jesús lo re xaa, Dios mtexoob Jesús, Xaa Nabeyy be, naz leen yiba, nu mzob xaa xaa lad li lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nu lee re xaa kwaan mze kwaan Jesús mzelo mroo mzaa kwent cheen wdizh chul cheen Jesús kwaan nyalno yalnaban rete pa. Nu lee Xaa Nabeyy nle yudar re xaa. Nu nlu Xaa Nabeyy lee xtizh Dios nak kwaan wli, nu nle xaa zyen doo kwaan gro kwaan nagarlot le re myet, zee ne re xaa lee kwaan ngunii xaa nak xtizh Dios. ¡Sbaa gaka!");
INSERT INTO zpoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dix Chof, xaa non doo. Zyen xaa mkee re kwaan ngok lo re nu. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nu prop lo re xaa ngune xaa re kwaan ngok, nu xomod mzelo re kwaane axta yilo, leeka re xaa ne mkayaa zhiin zee zaa xaa kwent xtizh Dios, nak xaa mzaa kwenta lo re nu. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Kwaanzee nzak na wen kee na yech ne lo lu zee ne wen lu wlipa re kwaan mseed xaa lu, re kwaan ngok axta yilo. Wen wen ngunabdizh na lo re xaa ne, xomod mzelo re kwaane axta yilo nu xomod ngoka. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Zacari ngok tub ngwleyy, re liin kwaan mnabeyy rey Herod re yezh Judea, nu ngok xaa partid cheen Abías. Nu lee sa Zacari le Elizabet, me nak dii cheen Aarón. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Rop sa xaa ne nali doo nzo lo Dios, nu nzhon xaa xtizh Xaa Nabeyy nu nik tub xaa nyent mod gaazh tub kwaan tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Per nanzhapt rop sa xaa mad, nel sa xaa Elizabet nak tub me nit, me nazant mad nu ngoxla rop sa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Gorna nguzo partid cheen Zacari le xchiin leen yidoo cheen Xaa Nabeyy, ");
INSERT INTO zpoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","nu mloo re xaa swert mod nak kostumbr cheen re xaa zee, nu Zacari nguzoya zee zeeb xaa leen yidoo zee zek xaa yaal lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nu gorna lee yaal kayek, rese xaa yezh nzhi naz jwer kawdizhno Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nu gorzee lee tub mandad cheen Xaa Nabeyy mlu lo Zacari, nzolisa lad li lo mdo pa kayek yaal. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nu gorna ngune Zacari lo mandad, mdedyall xaa nu mzheb xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Per lee mandad nzhé lo xaa: —Zacari, nazhebt lu, nel mbinla Dios kwaan ngunaab lu lo xaa; lee sa lu, Elizabet, kano tub mad, nu kole lu mad Juan. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nu nix doo gak lextoo lu, nu noka zyen doo myet nix doo gak lextoo lee xaa gal, ");
INSERT INTO zpoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","nel xinn lu gak tub xaa non lo Xaa Nabeyy. Nagot xaa xis ub, nu axta gorna zeeraka gal xaa lee Mbi Naban cheen Dios nabeyyla lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Lee xaa le zee zyen doo xaa Israel bare lo Xdios xaa, Xaa Nabeyy lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juan yaner delant lo Xaa Nabeyy, kwaan leeka Mbi Naban nu yalngezh kwaan mkano Li, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. Zee lee re myet kwi wen kwaan re xinn xaa, nu noka re xaa nazaat yek gon diizh, zaa yek gona. Snee zo list re myet zee kayaa xaa Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacari mnabdizh lo mandad nu nzhé xaa: —¿Xomod ne na wlipa gak kwaane? Nel ngoxla rop sa na. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Lee mandad mkeb lo xaa, nzhé: —Na nak Gabriel, na nzo gax lo Dios nu na nkee xchiin xaa. Lee xaa mxaal na wdizhno na lu, nu nii na re kwaan wen ne lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per nel namlet lu krer kwaan nii na lo lu, nal lake lu muud, nu nagarlot wdizh lu axta mbizh gak re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nu lee re myet nkambaz Zacari naz jwer roo yidoo, nu nabdizh re xaa lo wechxinn xaa chozhiin nyentaka xaa roo leen yidoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nu gorna mroo xaa nyentra mod nii xaa lo re xaa; zee mzeen re xaa lee xaa ngune lo tub kwaan naz leen yidoo, nel kwaan nseyn nii xaa lo re xaa, nel muud myaan xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Gorna ngulo mle Zacari xchiin xaa, nya xaa garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gwluzh gorna ngulo mded kwaane, lee sa xaa mbeyyxiin, nu tira mkaxlaan me garli me dubse tub gaay mbee nu namrootra me nel nle me xgab: ");
INSERT INTO zpoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Snee mle Xaa Nabeyy lo na, zee mbyiib yalnto cheen na lo re myet”. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Xop mbee gwluzh, Dios mxaal mandad Gabriel naz yezh Nazaret yizhyo pa nabeyy Galilea, ");
INSERT INTO zpoNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","lee mandad ngwasewii lo tub ngwnaa me zer chaal nik tub xaabyi, me le Mari, me nakladiizh chelya kwaan tub xaabyi le Che, xaa nak dii cheen rey David, xaa mnabeyy yilo. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Lee mandad mzeeb pa nzho me, nu nzhé lo me: —¡Dix Mari, lu nak tub me wen lo Dios! Dios, Xaa Nabeyy, nzo kwaan lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Gorna mbin Mari re kwaan nzhé mandad lo me, mdedyall me nu mle me xgab chozhiin sbaa nzhé mandad lo me. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nu lee mandad nzhé: —Mari, nazhebt lu nel nyakla Dios ne lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nal lee lu weyyxiin lu, nu kano lu tub xgann lu, nu kole lu mad Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Lee xaa ne gak tub xaa gro doo nu lee xaa role Xgann Dios, xaa nzob naz yiba. Nu lee Dios, Xaa Nabeyy, le zee nabeyy xaa mod xey xaa David, xaa ngu yilo, ");
INSERT INTO zpoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","zee tira nabeyy xaa re xaa Israel. Nu lee yalnabeyy cheen xaa tira naluxt. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari mnabdizh lo mandad, nzhé: —¿Xomod nzho mod gak kwaane? Nel lee na nik tub xaabyi zer chaal na. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Lee mandad mkeb nzhé: —Lee Mbi Naban la tich lu, nu lee yalngezh cheen Dios, xaa nzob naz yiba la cho lu kwenta tub xkaw. Kwaanzee nzhul gak xinn lu mad gal nu role xaa Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Noka sawlizh lu Elizabet gal tub xgann, nixa ngoxla me; nixa “me nit” nii re xaa me. Nu nal nzhala xop mbee nakxiin me, ");
INSERT INTO zpoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","nel lee Dios nzho mod le rese kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Zee lee Mari nzhé: —Na nak mos cheen Xaa Nabeyy, laa le Dios na modxa né lu lo na. Gorzee lee mandad nya. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tub mbizh nzha Mari tub yezh nzhi leen yi cheen yizhyo Judea, prad doo nzha me; ");
INSERT INTO zpoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","nu gorna mzhin me garli Zacari ngunii me “dix” lo Elizabet. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nu gorzee lee Elizabet mbin ngunii Mari “dix”, lee xinn me nyakdoola nu mgun mad leen lextoo me nu gorzee lee Mbi Naban cheen Dios mnabeyy leen lextoo me. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Zee lee Elizabet dub gan nzhé: —¡Dios mzaa kwaan gro doo lo lu nu lo xinn lu ke lo stub naz re ngwnaa! ");
INSERT INTO zpoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nanakt na tub me non per mzeselach lu lo na, nel lu nak xnaa Xaa Nabeyy lo na. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nu gorna mbin na ngunii lu “dix” lo na, lee xiin na nyakdoola nu mgun mad leen lextoo na. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Chul doo ded lu nel mle lu krer lee Xaa Nabeyy le rese kwaan né xaa lo lu! ");
INSERT INTO zpoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Zee lee Mari nzhé: Lee yalnaban cheen na nzholl lo Xaa Nabeyy, nel gro doo nak Xaa Nabeyy, ");
INSERT INTO zpoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","nu lee mbi naban cheen na nyakdoola ne Dios, xaa koo na lo yalgut lo re jwalt cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nel nixa nanont na per Dios mleey na, nel nal lee re myet zelo nii lo na me non; ");
INSERT INTO zpoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nel lee xaa nkano yalngezh nu zyen doo kwaan nzhale xaa lo na. ¡Nzhul nak xaa! ");
INSERT INTO zpoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tubka nles lextoo Dios ne re xaa nzheb ne Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dios nle kwaan gro doo kwaan yalngezh cheen xaa. Mlux xaa xgab cheen re xaa xwa doo nle, ");
INSERT INTO zpoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","nu mkiib xaa yalnon lo re xaa nabeyy, nu mle non xaa re xaa nanont. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mzaa xaa zyen doo kwaan lo re xaa nlaan, nu lo re xaa rik nik tub kwaan namzaat xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mle xaa yudar re sawlazh be, xaa kwaan nkee zhiin lo Dios; nu nanyanlazht xaa lesla xaa ne xaa re be, ");
INSERT INTO zpoNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","modxa nzhé Dios lo re xey be xaa yilo, nu lo Abraham, nu lo re dii cheen Abraham. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari mlaz garli Elizabet chon mbee, zeera nya me garli me. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Gorna mzhin mbizh gal xinn Elizabet, zee ngol tub madbyi. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Re xaa nzho gax garli me nu re sawlizh me, ngwa re xaa lo me, gorna mbin re xaa lee Xaa Nabeyy ngok wen doo lo me. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nu gorna nguxoob mad xon mbizh, zee mbid re xaa garli Zacari zee choog xaa tik yed cho mad kwaan nak beyy cheen re xaa Israel. Nu nzhekla re xaa kole mad Zacari kwentaxa le xuz mad. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Per lee xnaa mad nzhé: —Narolet mad sbaa, lee mad role Juan. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Lee re xaa nzhé lo me: —Nik tub sawlizh lu nalet sbaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Zee kwaan nseyn mnabdizh xaa lo xuz mad, zee ne xomod nzhekla xaa kole xaa mad. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nu lee xuz mad ngunaab tub lee tab zee kee xaa le mad lo tab, nu lee xaa mkee lo tab: “Juan role mad”. Nu rese xaa mdedyall. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nu gorzee lee Zacari mzelo ngunii stub welt, nu mzelo xaa mbill xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Rese xaa nzho gax garli xaa mzheb doo, nu rese xaa nzho re yezh kwaan nzhi leen yi cheen Judea nzhedizh kwaan ngok. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Rese xaa mbin re kwaan ngok nabdizh lo re wechxinn: —¿Cho kwaan gak xaa ne? Sbaa mle xaa xgab nel kwaan gro doo mle Xaa Nabeyy lo madoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Lee Mbi Naban mnabeyy lextoo Zacari, xaa nak xuz madoo, zee mzaa xaa kwent kwaan nzhé Dios lo lee xaa, nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Wen doo nak Xaa Nabeyy, Dios cheen re be, xaa Israel; mbiid xaa mdix xaa re jwalt cheen re xaa xaa! ");
INSERT INTO zpoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nel mxaal xaa tub xaa nzho mod koo be lo yalgut, lo re jwalt kwaan mle be kwaan yalngezh cheen xaa. Nu xaa ne nze naz lo dii cheen rey David, xaa ngok xey be, xaa ngok xmos Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kwaane nak kwaan nzhé re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, xaa nambey nak. Re xaa ne nzhé: ");
INSERT INTO zpoNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Dios nak xaa koo be lo re xaa nayii ne be, nu lo rese xaa nawent nzhak lextoo ne be”. Sal. 106:10 ");
INSERT INTO zpoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Luu xaa yalnlesla cheen xaa lo re xaa xaa, nu namyenlazht xaa wdizh kwaan mlaa xaa lo re xey be, xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nu kwaane nak wdizh kwaan mlaa xaa lo xey be Abraham: ");
INSERT INTO zpoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","koo xaa be lo re xaa nayii ne be, zee nazhebt re be kee be zhiin lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nu tubka nzhul nu nali zo be lo xaa, rese mbizh kwaan mban be. Zee nzhé xaa lo xgann xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Lee lu nak xaa zaa kwent kwaan né Dios lo lu, xaa nzob naz yiba, nel lu yaner lo Xaa Nabeyy, zee xal lu xnaz xaa, ");
INSERT INTO zpoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","zee zaa lu kwent lo re xaa nak xaa Dios, lee Dios chee re jwalt cheen xaa, nu zaa xaa yalnaban cheen xaa kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nel mles lextoo Dios ne be, zee zaa xaa xni mod mbizh lo re be, ");
INSERT INTO zpoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","zee la xni cheen xaa lo re xaa nzho lo yalnakaw, nu lo re xaa nzho xan xkal cheen yalgut, nu le xaa zee kwi wen be kwaan lee xaa.” ");
INSERT INTO zpoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Lee madwin nzharoora nu nzhayak ngezh mad kwaan Mbi Naban cheen Dios, nu ngu mad naz wen, axta mbizh kwaan mzelo xaa zaa xaa kwent xtizh Dios lo re xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Re mbizh zee lee xaa nabeyy dubse pa nabeyy yezh Roma le Augusto, nu mnabeyy xaa zee top xaa le re xaa nzho dubse pa nabeyy Roma. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Cirenio ngok xaa nabeyy Siria leezha mdop le re xaa welt yilotlaka. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nu rese myet nkin ya xaa lazh xaa zee kee le xaa list. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nu kwaan ba mle zee mroo Che yezh Nazaret, pa nabeyy Galilea, nu ngwa xaa Belén, yezh pa nabeyy Judea, pa ngol David, xaa nabeyy yilo, nel Che nak xaa dii cheen David. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ngwa rop xaa Mari sa xaa baa, me nakladiizh chelya kwaan lee xaa, zee ke le xaa list; nu lee me nakxiinla. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nu gorna nzoka xaa Belén, mzhinla mbizh gal xinn me. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nu baa ngol xgann me mad yilotlaka, nu mchal me mad ler nu mdix me mad lo yix kwaan nzhaw ma, nel nyent yoo pa kwaz me. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gax Belén nzho lak xaa nkanap xma nzhal yaal. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nu gorna nzhi re xaa mlu tub mandad cheen Xaa Nabeyy lo re xaa, nu lee xni cheen Xaa Nabeyy mla lo re xaa; nu mzheb doo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Per lee mandad nzhé lo re xaa: —Nazhebt re gu, nel lee na nzhal za tub kwent chul doo lo re gu, nu nix doo gak lextoo rese myet gona. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nel nalzhe ngol tub mad yezh cheen David nu koo xaa re gu lo yalgut. Xaa ne nak Xaa Mxaal Dios Nabeyy, nu leeka lee xaa nak Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kwaane nak tub nseyn zee yizhal mad lo gu, lee mad nral ler nu naxna lo yix kwaan nzhaw ma. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nu leeka gorzee mlu zyen doo mandad cheen Dios xkwes mandad zee, lee re xaa mbill lo Dios nu nzhé: ");
INSERT INTO zpoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Gool re myet lo Dios xaa nzob naz yiba! ¡Chul kwi re myet yizhyo ne, nel Dios nyakla lextoo wii lo re myet! ");
INSERT INTO zpoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Gorna lee re mandad mbare nya naz yiba, lee re xaa nkanap ma mzelo mbezh lo re wechxinn: —Ya be Belén nal, zee ne be nen cho kwaan ngok, kwaanzee mle Xaa Nabeyy yabis lo be. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nu gorzee mrexonn re xaa nzha xaa, nu gorna mzhin xaa ngune xaa lo Mari nu lo Che nu lo madoo, mad naxna lo yix kwaan nzhaw ma. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nu gorna ngune xaa lo madoo, nu mzelo xaa mzaa xaa kwent kwaan nzhé mandad lo xaa cheen mad, ");
INSERT INTO zpoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","nu rese xaa kwaan mbin kwaan nzhé re xaa nkanap ma, mdedyall re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Per lee Mari mlozhaw rese kwaane leen lextoo me, zee le wen me xgab xomod nak re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nu lee re xaa nkanap ma nya, nyakdoola re xaa. Mbill re xaa lo Dios kwent cheen rese kwaan ngune xaa lo, nu re kwaan mbin xaa, nel reseya ngok kwentaxa nzhé mandad lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Gorna mzhaal mad xon mbizh, zee mlo xaa mad beyy cheen xaa Israel kwaan nak mchoog xaa tik yed cho mad, nu mlole xaa mad Jesús, mod nzhé mandad lo Mari kole Mari mad leezha zeeraka weyyxiin me. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Gorna ngulo nguxoob re mbizh lee me ngok nambey, modxa nabeyy ley cheen Ches, mbe Che rop Mari mad yezh Jerusalén, zee kayaa Xaa Nabeyy mad. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Snee mle xaaya nel snee nkeeya lo ley cheen Xaa Nabeyy: “Rese xgann xaa, xaa yilotlaka, gak xaa nali lo Xaa Nabeyy”. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ngwa xaa mzaa xaa gon mod nabeyy ley cheen Xaa Nabeyy, nzhaal wee xaa chop ngog o chop palom yeen. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Re mbizh zee nzho tub xaa Jerusalén, xaa le Simeón, xaa nak tub xaa nali nu nzholl lo Dios nu nkambaz xaa yaad xaa seleyy re xaa Israel. Nu lee Mbi Naban cheen Dios mnabeyy lextoo Simeón, ");
INSERT INTO zpoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","nu nzhé xaa lo xaa, mbanaka xaa axta gorna ne xaa lee Xaa Nakladiizh Yaad. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nu lee Mbi Naban cheen Dios mle zee ngwa Simeón yidoo; nu leeka gorzee lee xuz Jesús nu xnaa Jesús mbe madoo lo lach roo yidoo, zee le xaa kwaan nabeyy ley cheen Ches. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nu Simeón mdeezh mad nu mbill xaa lo Dios, nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nalsi, Xaa Nabeyy, lee kwaan nguné lu lo na ngok; chul doo nzhak lextoo na nal nu nzho mod laa lu yet na nal. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nel ngunela na lo xaa koo re xaa lo yalgut; ");
INSERT INTO zpoNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mxaal lu xaa lo rese myet mod mlela lu xgaba axta yilo. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Lee xaa zaa xni lo rese xaa nanakt xaa sawlazh nu, nu le non xaa re xaa lu, xaa nak re nu, xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Xuz Jesús nu xnaa Jesús mdedyall rop xaa nzhon xaa re kwaan ngunii Simeón cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Zee ngunii Simeón zee kanap Dios xaa, nu nzhé xaa lo Mari xnaa Jesús: —Lee mad ne mleeyla Dios, zee le xaa zyen doo sawlazh be yiib jwalt cheen o kwibra mas jwalt tich. Lee mad gak tub nseyn kwaan nakayaat re xaa, ");
INSERT INTO zpoNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","nu snee lee mod nle re xaa xgab gakbeyy. Per lee re kwaane gak kwenta tub spad kwaan ded lextoo lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Noka naz ba nzo tub ngwnaa le An, me nzaa kwent kwaan nzhé Dios lo me, me nak xchap Fanuel, xaa dii cheen Aser. Lee me nak tub ngwnaa, me ngoxla. Mka me xaabyi leezha nyeen doo me, nu ngu me kwaan sa me gazhaka liin; ");
INSERT INTO zpoNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","nu nzhala tapgal nzho tap liin mlake me byud. Nu tira nanroot me lach roo yidoo, zhe nu yaal nkee me zhiin lo Dios, nu nkwan me gorna nanzhawt me nik tik kwaan, nu nzhedizhno me Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nu noka An mzhin gorzee, nu mzelo me mzaa me dixkix lo Dios, nu nzaa me kwent cheen Jesús, lo re xaa nkambaz nen cho gor zhin xaa zii re xaa Jerusalén lo yalgut. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nu gorna ngulo mle xaa re kwaan nabeyy ley cheen Xaa Nabeyy, mbare xaa yizhyo Galilea, mer lazh xaa Nazaret. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nu kad mbizh lee Jesús mas nzhero nu mas nzheyura yek, nu lee Dios tubka nzo kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Rese liin nya xnaa Jesús nu xuz Jesús Jerusalén yalni cheen Paskwa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nu gorna nguxoob Jesús chiibchop liin, ngwa rop sa Che kwaan Jesús Jerusalén, mod nak kostumbr cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Per gorna ngulo mded yalni, nu gorna mbare xaa nya xaa garli xaa, lee Jesús mlakeka Jerusalén, per namzeent xuz xaaya nixa xnaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mle xaa xgab che nyala Jesús xsaww lo re myet xaa nya, nu ngulola mze xaa tub mbizh; per gorna mkwaan xaa xaa lo re sawlizh xaa nu lo re sawlazh xaa nanguzhalt xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Zee mbare xaa Jerusalén stub welt, zee kwaan xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ngulo mzhaal chon mbizh zeera nguzhal xaa lo xaa. Nu lee xaa nzob leen lach roo yidoo cheen Dios, lo re maestr xaa nlu xtizh Dios, kakenzha xaa nu kanabdizh xaa lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nu rese xaa kakenzha kwaan kanii xaa, ndedyall re xaa ngune xaa xomod nzhak xaa, nu xomod nkeb xaa lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Gorna lee xuz xaa nu xnaa xaa ngune lo xaa mdedyall xaa; nu lee xnaa xaa nzhé lo xaa: —Xgann, ¿chozhiin snee mle lu lo nu? Nales doo nzhak lextoo rop nu xuz lu, kakwaan nu lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús mkeb nzhé: —¿Chozhiin nkwaan gu na? ¿Che nanet gu nkin zo na garli Xuz na? ");
INSERT INTO zpoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per namlat kwaan nzhé xaa yek xuz xaa nu xnaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Zee mbare xaa kwaan xuz xaa nu xnaa xaa naz Nazaret stub welt, pa ngu xaa. Nu mbin xaa rese xtizh xuz xaa nu xtizh xnaa xaa. Lee xnaa xaa mlozhaw rese kwaane leen lextoo me, zee le wen wen me xgab xomod nak re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nu lee Jesús nzharoora, nu nzhiyura yek xaa, nu nyakla Dios ne xaa nu noka re myet nyakla ne xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chiin liin nzha nabeyy Tiberio César dub pa nabeyy Roma, lee Poncio Pilat nak xaa nabeyy yizhyo Judea, Herod nabeyy yizhyo Galilea, wech xaa nak Lip xaa nabeyy yizhyo Iturea nu yizhyo Traconite, nu lee Lisanias nabeyy yizhyo Abilinia. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás nu Caifás nak ngwleyy non doo naz Jerusalén. Re mbizh zee lee Juan xgann Zacari ngu naz wen, nu ngunii Dios lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nu Juan mded dubse roo yuu Jordán, nu mbezh xaa lo rese myet nkin laa xaa naz nawent nu bare xaa lo Dios zee rubnis xaa, zee zhe re jwalt cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nu kwaane ngok zee mbarlo kwaan mkee Chay, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo: Tub xaa nzo naz wen nii dublegan: “Bdexkwaa gu xnaz Xaa Nabeyy; bxal gu tub naz nali zee ze xaa.” ");
INSERT INTO zpoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Rese pa yat nzeb yizhe, nu rese yi nu rese lom seli xaa nu rese naz narek seli xaa. Nu dexkwaa wen xaa re naz kwaan nawent nak. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nu rese myet ne lo xaa mxaal Dios, xaa koo re xaa lo yalgut. Is. 40:3-5 ");
INSERT INTO zpoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Gorna lee re myet nzhin rubnis xaa lo xaa, Juan mbezh lo re xaa: —¡Gu nak dii cheen mball wiz! ¿Cho né lo gu nzho mod xonn gu lo yalnayii kwaan né Dios yaad? ");
INSERT INTO zpoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Blu mlaa gu naz nawent nu wlipa mbare gu naz lo Dios, zee gakpa gu mod xle cheen tub yag. Nu nawdizht gu yé gu: “¡Lee re be nak dii cheen Abraham!” Nel wlipa na nii na lo gu, Dios nzho mod le axta noka re ke ne gaka dii cheen Abraham. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Lee yibyag nzobla cho lox re yag kwaan nanzaat xle wen, zee choog xaaya nu koo xaaya lo ki. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Zee lee re xaa mnabdizh nu nzhé xaa: —¿Cho kwaan nzhaal le nu? ");
INSERT INTO zpoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan mkeb nzhé lo re xaa: —Nu loka cho xaa nkano chop naz ler, bzaa gu tub naza lo xaa nankanota, nu loka cho nkano kwaan gaw, bzaa guya lo xaa nyent kwaan gaw. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Noka lak xaa ntop demi kwaan nya naz Roma ngwa lo Juan, zee chubnis Juan xaa, nu mnabdizh xaa lo Juan nu nzhé xaa: —Maestr, ¿cho kwaan nzhaal le nu? ");
INSERT INTO zpoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan nzhé lo re xaa: —Nebse gunaab gu parota nzhaal kix xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Noka mnabdizh lak soldad lo Juan, nu nzhé xaa: —¿Cho kwaan le re nu? Nu lee Juan nzhé lo xaa: —Nakiibt gu kwaan nkano re myet kwaan lajwers, nixa nagaazht gu tub kwaan nawlit tich xaa; nu nebse gok chul lextoo gu kayaa gu re demi kwaan nzhex nka gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lee re myet nkambaz nen cho kwaan gak. Nu rese xaa nle xgab chelee Juan nak Xaa Xaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Per lee Juan nzhé lo re xaa: —Na nchubnis re gu kwaan nis, per tich na nze stub xaa chubnis re gu kwaan Mbi Naban nu kwaan ki. Lee xaa nonra lo na kwaanzee nixa tich xkyelyed xaa nanzhaalt xek na. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Lee xaa nzho tub garot yaa koo paj lo nzhobxtil, nu kozhaw xaa nzhobxtil pa ngozhaw xaa re xob xaa, nu lee paj nzhobxtil zek xaa lo ki kwaan tira nanyuyyt. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nu kwaan zyen doo re wdizh ne mzaa Juan kwent chul cheen Dios lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nu noka mgalno xaa Herod, xaa nabeyy yizhyo Galilea, nel mkano Herod xngwnaa wech xaa Lip, me le Herodías, nu noka mgalno xaa Herod lo rese kwaan nawent kwaana mle Herod. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Lo re kwaan nawent nzhale Herod, noka mle xaa stub kwaan nawent, mchep xaa Juan lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nu gorna lee Juan kachubnis re myet, noka Jesús ngwa mrubnis; nu gorna lee xaa kawdizhno Dios lee yiba mxal, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","nu lee Mbi Naban cheen Dios nyaadla naz leen yiba mla tich xaa mod tub palom, nu kwaane nak tub kwaan mlu lo xaa. Nu tub bos kwaan nze naz yiba nzhé: —Lu nak xgaan na, xaa nkedoola na, nu nyakdoo lextoo na wii na lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús nzho kan tub galbchii liin gorna mzelo xaa mzaa xaa kwent wdizh chul cheen Dios. Nak xaa mod xgann Che, kwentaxa nle re xaa xgab. Che ngok xgann Elí, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí ngok xgann Matat, Matat ngok xgann Leví, Leví ngok xgann Melqui, Melqui ngok xgann Jana, Jana ngok xgann Che, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Che ngok xgann Matatías, Matatías ngok xgann Amós, Amós ngok xgann Nahúm, Nahúm ngok xgann Esli, Esli ngok xgann Nagai, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ngok xgann Maat, Maat ngok xgann Matatías, Matatías ngok xgann Semei, Semei ngok xgann Chek, Chek ngok xgann Judá, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá ngok xgann Joanán, Joanán ngok xgann Resa, Resa ngok xgann Zorobabel, Zorobabel ngok xgann Salatiel, Salatiel ngok xgann Neri, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ngok xgann Melqui, Melqui ngok xgann Adi, Adi ngok xgann Cosam, Cosam ngok xgann Elmadam, Elmadam ngok xgann Er, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ngok xgann Jesús, Jesús ngok xgann Eliezer, Eliezer ngok xgann Jorim, Jorim ngok xgann Matat, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat ngok xgann Leví, Leví ngok xgann Simeón, Simeón ngok xgann Judá, Judá ngok xgann Che, Che ngok xgann Jonam, Jonam ngok xgann Eliaquim, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim ngok xgann Melea, Melea ngok xgann Mená, Mená ngok xgann Matata, Matata ngok xgann Natán, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán ngok xgaan rey David, David ngok xgann Isaí, Isaí ngok xgann Obed, Obed ngok xgann Booz, Booz ngok xgann Sélah, Sélah ngok xgann Naasón, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón ngok xgann Aminadab, Aminadab ngok xgann Admín, Admín ngok xgann Arní, Arní ngok xgann Esrom, Esrom ngok xgann Fares, Fares ngok xgann Judá, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá ngok xgann Kob, Kob ngok xgann Chak, Chak ngok xgann Abraham, Abraham ngok xgann Taré, Taré ngok xgann Nacor, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor ngok xgann Serug, Serug ngok xgann Ragau, Ragau ngok xgann Peleg, Peleg ngok xgann Heber, Heber ngok xgann Sala, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ngok xgann Cainán, Cainán ngok xgann Arfaxad, Arfaxad ngok xgann Sem, Sem ngok xgann Noé, Noé ngok xgann Lamec, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec ngok xgann Matusalén, Matusalén ngok xgann Nok, Nok ngok xgann Jared, Jared ngok xgann Mahalaleel, Mahalaleel ngok xgann Cainán, ");
INSERT INTO zpoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán ngok xgann Enós, Enós ngok xgann Set, Set ngok xgann Dan, Dan ngok xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mnabeyy Mbi Naban leen lextoo Jesús, zee gorna mbare xaa roo yuu Jordán, lee Mbi Naban mbe xaa naz wen. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nu mzo xaa choo mbizh naz wen zee mkiil Maxuu xaa, nu nandawt xaa nik tub kwaan tub choo mbizh, zee mzhiib tub yalnlaan lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Zee lee Maxuu nzhé lo xaa: —Chelee lu wlipa lu nak lu Xgann Dios, guzh lo ke ne gaka pan. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús mkeb nzhé: —Lee lo Xkyech Dios nkee: “Nanebt pan nle zee mban myet, nel noka wdizh kwaan nroo roo Dios nle zee mban re myet”. Dt. 8:3 ");
INSERT INTO zpoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Zee lee Maxuu mbe xaa tub pa ya doo nzeb, nu mlu rese yezh kwaan nzhi lo yizhyo lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Zee nzhé Maxuu lo xaa: —Na za reya zee nabeyy lu rese yezh ne, nel na nabeyy re yezh ne, kwaanzee nzho mod za naya lo xaa nzhekla na. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chelee lu kichxub lu lo na nu gool lu lo na rese yezh ne gak xcheen lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús mkeb nzhé: —Lee lo Xkyech Dios nkee: “Nzhaal gool lu nebse lo Xdios lu Xaa Nabeyy lo lu, nu nebse lo lee xaa nzhaal kee lu zhiin”. Dt. 6:13 ");
INSERT INTO zpoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Zeera mbe Maxuu xaa naz yezh Jerusalén, nu mtexoob Maxuu xaa yek yidoo pa mas ya nzeb nu nzhé Maxuu lo xaa: —Chelee lu wlipa nak lu Xgann Dios, brenzeb naz xan naz lo yo; ");
INSERT INTO zpoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","nel lee lo Xkyech Dios nkee: Dios xaal mandad cheen xaa zee kanap xaa lu, zee nyent cho kwaan gak lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nu zenyaa xaa lu, zee nalat nii lu lo ke. Sal. 91:11-12 ");
INSERT INTO zpoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús mkeb lo xaa nzhé: —Noka nkee lo Xkyech Dios: “Nanzhaalt kiil lu Xdios lu, Xaa Nabeyy lo lu”. Dt. 6:16 ");
INSERT INTO zpoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nu gorzee nanguzhaaltra Maxuu stub mod kiil Jesús, zee mlaa xaa Jesús tub tyemp. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús mbare naz yizhyo Galilea, gorna mbare xaa nkanola xaa yalngezh cheen Mbi Naban nu mrech kwent cheen xaa dubse yizhyo zee. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nu nseed xaa re myet re pa nkasa xaa Israel nseed xaa xtizh Dios, nu re xaa zee nyula mbin xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús ngwa Nazaret, yezh pa mxen xaa. Zhe sab, zhe kwaan nzholl re xaa Israel lo Dios, mzeeb xaa pa nkasa xaa nseed xaa xtizh Dios, mod nak kostumbr cheen xaa; nu mzoli xaa mlab xaa Xkyech Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nu mzaa xaa yech kwaan mkee Chay lo xaa; Chay nak tub xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. Nu gorna mxal Jesús loya, nguzhal pa nzhé snee lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Lee Mbi Naban cheen Xaa Nabeyy nzo kwaan na, nel mleey xaa na zee za na kwent cheen wdizh chul lo re myet xaa prob; zee yé na lo re xaa nzho mod roo xaa lozhyib; nu sekwen na garlo re syeg; nu le wen na lextoo re xaa nales doo nzhak lextoo; ");
INSERT INTO zpoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nu za na kwent cheen mbizh leezha lee Xaa Nabeyy zaa re kwaan chul cheen xaa lo re myet. Is. 61:1-2 ");
INSERT INTO zpoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Zeera mtuuzh Jesús yech, nu mzaa xaaya lo xaa nkanap pa nkasa re xaa nseed xaa xtizh Dios, nu mzob xaa. Rese xaa nzhi baa tubka nlach lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Zee lee Jesús mzelo nzhé lo re xaa: —Nalzhe mbarlo kwaan nkee lo Xkyech Dios nee, delant lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nu rese xaa nzhedizh wen xaa, nu ndedyall re xaa nzhon re wdizh chul kwaan ngunii xaa, nu nzhé re xaa lo wechxinn xaa: —¡Lee Jesús nak xgann Che! ");
INSERT INTO zpoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús mkeb lo re xaa nzhé: —Wlipa na nii na lo gu, lee re gu kale xgab nii diizh ne lo na: “Doktor bsekwen lu leeka lu”. Nu noka nle gu xgab nii gu lo na: “Re kwaan mbin nu mle lu yezh Capernaum, noka bleya nee, pa nak mer lazh lu”. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Noka nzhé Jesús: —Wlipa na nii na lo gu, nik tub xaa mzaa kwent kwaan nzhé Dios lo xaa yilo, namkayaawent re sawlazh xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Wlipa na nii na lo gu, ngu zyen doo byud lazh be re mbizh cheen Li, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, re mbizh kwaan mla win dubse yizhyo ne nel namlat yey chon liin yirol. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Per Dios namxaalt Li ya xaa lo tub byud me lazh be, lee Dios mxaal xaa ya xaa lo tub ngwnaa byud, me nzho yezh Sarepta, pa nabeyy yezh Sidón. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nu noka ngu zyen doo xaa lazh be, xaa myall baal cho, re mbizh cheen Eliseo, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, per nik tub re xaa ne, xaa myall baal cho namsekwent xaa, nebse msekwen xaa tub xaa le Naamán, xaa nak xaa yizhyo Siria. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nu gorna mbin re xaa nzhi pa nkasa xaa Israel nseed xaa xtizh Dios kwaane, mrixyan re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Gorzee nguxso re xaa nu mloo xaa Jesús yezh ba, nu mbe xaa Jesús nu nguzo xaa Jesús yek blee roo yezh, zee kobi xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per lee Jesús mdedyo xsaww lo re xaa nu nya. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús mkato yezh Capernaum, yezh cheen Galilea. Rese zhe sab, zhe kwaan nzholl xaa lo Dios, Jesús nseed re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nu lee re myet ndedyall doo ngwii lo re kwaan nseed xaa, nel nzhedizh xaa kwaan yalnabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nu pa nkasa xaa nseed xaa xtizh Dios, nzo tub xaabyi xaa nzho mbi mal lextoo, nu xaa ne ngunii dublegan, nzhé lo Jesús: ");
INSERT INTO zpoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Blaa nu! ¿Chozhiin mzhin lu lo nu Jesús, xaa Nazaret? ¿Che nze lu lux lu nu? Na nlabeyy lu, nu ne na lee lu nak Xaa Nzhul lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús mgalno mbi mal ba, nu nzhé xaa: —¡Bsaaw roo lu! ¡Broo lextoo xaabyi ne! Zee lee mbi mal mlebi xaa lo yo delant lo re xaa, nu mroo mbi mal lextoo xaa nu nyent cho kwaan ngok xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Rese xaa nzhi baa mdedyall, nu mbezh xaa lo wechxinn xaa: —¿Cho nak xaa ne? Nkano xaa yalnabeyy nu yalngezh ngoo xaa re mbi mal lextoo re myet, nu nzhon re mbi mal xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Zeesi, lijer doo mxonn re kwaan mle Jesús dubse yizhyo kwaan le Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Gorna mroo Jesús pa nkasa xaa Israel nseed xaa xtizh Dios, zee nzha xaa garli Pér. Nu gorna mzeeb xaa garli Pér, zee nzhé re xaa lo xaa lee xnaazhap Pér ne nzak, nlen xlee, nu ngunaab xaa lo Jesús zee sekwen xaa me. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús mwii lo me, nu mgalno xaa xlee, zee mroo xlee cho me. Nu gorzee nguxche me nu mzaa me kwaan ndaw re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gorna merla la yalchool, rese xaa nzak rete klas yalyizh mbidno re xaa xaa lo Jesús nu lee xaa mzhib yaa yek re xaa nu msekwen xaa re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nu noka nzho zyen doo xaa mloo xaa mbi mal lextoo, xaa kwaan mbazhe dublegan nu mbezh lo xaa: —¡Lu nak Xgann Dios! Per lee Jesús mgalno re mbi mal nel nanzheklat xaa nii re mbi mal lo xaa, nel nela re mbi mal lee xaa nak Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gorna mkaxni yizhyo stub mbizh, Jesús mroo yezh nu nzha xaa tub pa zo techosa xaa. Per lee re myet nkwaan xaa, nu gorna nguzhal xaa lo re xaa, nzhekla re xaa sekwaz xaa, zee nayatra xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Per lee Jesús nzhé lo re xaa: —Nzhaal za na kwent cheen wdizh chul cheen Pa Nabeyy Dios lo re myet xaa stub yezh, nel kwaane mxaal xaa na le na zee nzhal na. ");
INSERT INTO zpoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kwaanzee Jesús mroo nzhazaa kwent cheen wdizh chul cheen Dios re yezh cheen Judea, pa nkasa xaa Israel nseed xaa xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tub welt Jesús nzo roo nistoo cheen Galilea, kwaan noka nii xaa Genesaret, zee mdop zyen doo myet lo xaa nu ntaaw doo re myet xaa, sinka nzhekla xaa kenzha xaa wdizh chul cheen Dios kwaan kazaa xaa kwent. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Zee mlu chop kano lo Jesús roo nistoo, kwaan nik tub xaa nyent leen, nel lee re xaa nzen mbal mla xaa leena zee zet xaa xkyeez xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús nguxoob leen tuba, kwaan nak cheen Simón, nu ngunii xaa lo Simón zee chep xaa xepa naz leen nistoo. Zee nguxoob xaa leen kano, nu baa mzob xaa nu mzelo xaa mseed xaa re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Gorna ngulo mseed xaa re myet, zee nzhé xaa lo Simón: —Be kano, ya be xep xsaww leen nistoo paro nech, zee bchep gu xkyeez gu zee zen gu mbal. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón nzhé lo Jesús: —Maestr, dubse yaal mkee nu zhiin per nik tub mbal namzent nu; per bay gon nu xtizh lu zee ya be zee chep nu xkyeez nu leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nu gorna mlebi xaa yeez leen nistoo zyen doo mbal nguga lo xaa, nu axta mraz xkyeez xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Zee mle xaa nseyn lo re xmig xaa, xaa nzho leen stub kano, zee yiid re xaa le xaa yudar xaa. Nu lee re xaa ngwa lo xaa nu mchazhe re xaa ropse kano axta nzhekla kano la naz leen nis. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nu gorna mzeen Simón Pér lee zyen doo mbal nguga lo xaa, mkichxub xaa delant lo Jesús nu nzhé xaa: —¡Bachii lo na, Xaa Nabeyy, nel na nak tub xaa nzeb doo jwalt! ");
INSERT INTO zpoNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nu Simón kwaan re xmig xaa mdedyall doo nel mzen xaa zyen doo mbal. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nu noka Chag rop Juan mdedyall doo, rop xaa ne nak xgann Zebedeo, nu ngok xmig Simón. Per lee Jesús nzhé lo Simón: —Nazhebt lu, nel neta mbizh nalzhe naz delant lee lu gak xaa zere myet lo Dios kwentaxa nzen gu mbal. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Zee mchep re xaa xkano xaa naz roo nistoo zee mlaa re xaa rese kwaan nu mreke re xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tub mbizh nzo Jesús tub yezh, mzhin tub xaa nzak tub yalyizh kwaan nyall cho xaa. Gorna ngune xaa lo Jesús, mkichxub xaa nu mkichyek xaa axta lo yo nu nzhé xaa: —Xaa Nabeyy, chelee lu nzhekla lu, nzho mod sekwen lu na lo yalyizh ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús mzhib yaa cho xaa, nu nzhé lo xaa: —Nzhekla na; gakwen lu. Nu leeka gorzee lee yalyizh kwaan nyall cho xaa ngokwen. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús nzhé lo xaa: —Nik tub lo nayét luya. Gwa lo ngwleyy zee ne xaa lee lu ngokwen, nu bzaa gon cheen lu kwaan nlu lee lu ngokwen, kwentaxa mnabeyy Ches, zee ne ngwleyy lee lu ngokwen lo yalyizh kwaan mzhib lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Per lee xtizh Jesús yizata mbizh nzharechra, nu zyen doo xaa mdop mkenzha kwaan nii xaa, nu mkasa zyen xaa lo xaa zee sekwen xaa yalyizh cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Per lee Jesús tubka nya wen nyawdizhno Dios, pa nyent myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tub mbizh Jesús kaseed re xaa, nu baa nzob lak xaa fariseo nu lak maestr xaa nlu xtizh Dios, xaa nze naz reta yezh pa nabeyy Galilea, nu Judea nu yezh Jerusalén; nu yalngezh cheen Dios nkano Jesús, zee sekwen xaa rese xaa ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Zee mzhin lak xaabyi, re xaa ne nzeno tub xaa mdeen nzhib lo yag, nu nzhekla xaa chep xaa xaa leen yoo zee zhiib xaa xaa delant lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Per nanguzhalt xaa mod zeeb xaa leen yoo, nel zyen doo myet nzhi baa; kwaanzee nguxoob xaa yek yoo, nu mxal re xaa tik yek yoo, nu baa msela xaa dub yag mdeen, nu mdix xaa xaa delant lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nu gorna mzeen Jesús re xaa ngwii lo Dios, zee nzhé Jesús lo xaa: —Lee re jwalt cheen lu ngulola mzhe. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Zee lee re maestr xaa nlu xtizh Dios nu re fariseo nzelo mle xaa xgab: “¿Cho nak xaabyi ne, zee sbaa nii xaa? Nebse Dios nak xaa nzho mod chee re jwalt.” ");
INSERT INTO zpoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Per lee Jesús mzeen re kwaan nle re xaa xgab, nu nzhé xaa lo re xaa: —¿Chozhiin sbaa nle re gu xgab? ");
INSERT INTO zpoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Cho kwaan nzak gu? ¿Cho kwaan mas nanagant yé na lo xaa ne nzak: “Ngulola mzhe re jwalt cheen lu”, o sekwen na xaa ne nzak nu yé na lo xaa: “Guxche, bzen xkyag lu nu zyaa”? ");
INSERT INTO zpoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Le na kwaane lo gu, zee wii gu lee na nkano yalnabeyy chee na re jwalt, nel lee na nak Xaa Mzhin Ngok Myet. Kwaanzee nzhé Jesús lo xaa mdeen: —Guxche nu bzen xkyag lu nu zyaa garli lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nu gorzee lee xaabyi zee nguxche delant lo re xaa, nu mzen xaa xkyag xaa kwaan ngot xaa lo, nu nyayoll xaa lo Dios nya xaa garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rese myet mdedyall doo nu nzholl re xaa lo Dios, nu dub lo yalnacheb nzhé re xaa: —¡Yisutisuti, nalzhe si ngune nu tub kwaan gro doo! ");
INSERT INTO zpoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gwluzh ngulo mded kwaane, Jesús mroo nu ngune xaa lo tub xaa ntop demi kwaan nya naz Roma, xaa ne le Leví, nzob roo mes pa nya re xaa ngix lo xaa. Jesús nzhé lo xaa: —Breke tich na. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Zee lee Leví nguxso, nu mlaa xaa rese kwaan nu mreke xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mas gwluzh, garli Leví mle Leví tub yalni cheen Jesús kwaan gro doo; nu nzhi zyen doo xaa ntop demi kwaan nya naz Roma nu noka nzhi stub naz re xaa kwaan kayaw kwaan re xaa lo mes. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Per lee re xaa fariseo nu re maestr, xaa nseed xtizh Dios, mzelo xaa ngunii nawent lo re xaa mseed lo Jesús, nu nzhé re xaa: —¿Chozhiin nzhaw gu nu nzho gu kwaan re xaa ntop demi nu re xaa kwaan nle kwaan nawent? ");
INSERT INTO zpoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús mkeb nzhé lo re xaa: —Xaa nanet nzak, nankint xaa zee doktor, per lee re xaa ne nzak, xaa zee nkin doktor. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nel lee na nanzhalt kwezh re xaa wen, lee na nzhal kwezh re xaa nzeb jwalt, zee laa xaa kwaan nawent kwaan kale xaa nu wii xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nzhé re xaa lo Jesús: —Lee re xaa mseed lo Juan nu re fariseo zyen doo welt nkwan xaa gorna nazhawt xaa nik tik kwaan nu noka nzhedizhno doo xaa Dios, per lee re xaa mseed kwaan lu tubka nzhaw xaa nu nzho xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús mkeb nzhé: —Ble gu xgab kwaane. Nyent mod le gu zee kwan re xaa kwaan nzho tub jondang, zee nagawt xaa, gorna lee xaa kachelya nzoka kwaan re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per zhin tub mbizh wee xaa xaa kwaan kachelya; nu gorna zhin mbizh ba, zeesi lee re xaa nzhaal kwan. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nu noka mzaa xaa kwent nabix ne lo re xaa nu nzhé xaa: —Nik tub xaa nanchoogt tik ler kub, zee kobde xaaya cho ler gox. Chelee xaa sbaa le xaaya, nayet ler gox kee ler kub choya, nu sbaa noka ler kub lux. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nu nixa nangot xaa xis ub kwaan kub leen mbud yed gox. Nel lee xis ub kwaan kub gorna yixooba zchaza mbud gox. Nu lee xis ub kwaan ngu leena xo lo yo, nu noka mbud gox lux. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kwaanzee lee xis ub kwaan kub nzhaal yo leen mbud yed kub. ");
INSERT INTO zpoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nu rese xaa nzho xis ub kwaan nzhala mbizh mroo, nanyulat xaa go xaa xis ub kwaan kub, nel nzhé xaa: “Lee kwaan gox mas chulra ndee”. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Zhe sab, zhe kwaan nzholl re xaa Israel lo Dios, Jesús nzhaze pa mgaan xaa nzhobxtil, zee lee re xaa mseed lo Jesús mzelo mdich son nzhobxtil, nu mzob re xaaya nu ndaw xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Zee lee lak fariseo mnabdizh lo xaa: —¿Chozhiin nle re gu kwaan nanzhaalt le gu zhe sab? ");
INSERT INTO zpoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús mkeb nzhé lo re xaa: —¿Che zer lab re gu Xkyech Dios kwaan mle David tub welt leezha ngok nlaan xaa nu ngok nlaan re xmig xaa? ");
INSERT INTO zpoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mzeeb xaa leen yidoo cheen Dios, nu mzen xaa re pan kwaan nak cheen Dios ndaw xaa, kwaan nebse re ngwleyy nzho mod gaw nu noka mzaa xaaya ndaw re xmig xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nu noka nzhé xaa: —Na nak Xaa Mzhin Ngok Myet nu nkano na yalnabeyy zee nzho mod nabeey na zhe sab. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lee stub sab, zhe kwaan nzholl re xaa Israel lo Dios, Jesús mzeeb pa nkasa xaa Israel nu mzelo xaa mseed xaa re xaa. Nu baa nzo tub xaa mbizh yaa lad li. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nu lee re maestr xaa nlu xtizh Dios nu re fariseo mlach lo Jesús zee nen che sekwen Jesús xaa ne nzak zhe sab, zee sbaa nzho mod gaazh xaa tub kwaan tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Per lee Jesús nela nen cho kwaan nle re xaa xgab, zee nzhé Jesús lo xaa mbizh yaa: —Guxso nu bzoli xsaww lo re xaa. Lee xaabyi zee nguxso nu mzoli. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Zee Jesús nzhé lo re xaa nzhi baa: —Nal lee na nabdizh tub kwaan lo gu: ¿Xana kwaan nzho mod le re myet zhe sab, kwaan wen o kwaan nawent? ¿Che wen sekwen xaa tub myet, o gut xaa tub myet? ");
INSERT INTO zpoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Zee mwii Jesús lo rese xaa nzhi lo Jesús, nu zeera nzhé xaa lo xaa mbizh yaa: —Bseli yaa lu. Lee xaabyi zee mseli yaa, nu gorzee lee yaa xaa ngokwen. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Per lee re fariseo nu re maestr mzhaal xyan doo, nu mzelo re xaa mkediizh xaaya, zee ne cho kwaan nzho mod gaazh xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nu tub mbizh zee, Jesús ngwa yek tub yi zee wdizhno xaa Dios dubse yaal. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nu gorna ngunil yizhyo, Jesús mrezh re xaa mseed lo xaa, nu lo re xaa mseed lo xaa mleey xaa chiibchop xaa zaa xaa yalnabeyy cheen xaa lo. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Snee le re xaa mkayaa yalnabeyy lo xaa: Simón (xaa mlole Jesús Pér), Ndres (wech Simón), Chag, Juan, Lip, Tol, ");
INSERT INTO zpoNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Teo, Max, Chag (xgann Alfeo), Simón (xaa nkedoola lazh), ");
INSERT INTO zpoNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (xgann Chag), Judas Iscariote (xaa mzaa Jesús lo re xaa mbit xaa). ");
INSERT INTO zpoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Zee mbare Jesús naz yek yi kwaan re xaa mreke tich xaa, zee mzhin xaa tub pa lach. Baa mkasa re xaa mreke tich xaa nu noka zyen doo re myet stub naz yezh ngwa lo xaa: re xaa nze yezh Jerusalén, nu re xaa nze re yezh cheen Judea, nu re xaa nze rop yezh Tiro nu Sidón kwaan nzho roo nistoo. Mzhin re xaa baa zee kenzha xaa kwaan zaa Jesús kwent nu noka zee sekwen Jesús re yalyizh cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nu rese xaa nded bid lo re mbi mal, xaa nzho lo re xaa ne, msekwen xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kwaanzee rese xaa nzhekla gal cho Jesús, nel ne re xaa cho Jesús nroo yalngezh sekwen re xaa ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús mwii lo re xaa mseed lo xaa nu nzhé xaa lo re xaa: —Wen re gu xaa prob, nel lee pa nabeyy Dios gak xcheen re gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Wen re gu xaa nlaan nal, nel lee re gu gak xaa yazhe lextoo. ’Wen re gu xaa nzhonn nal, nel gwluzh lee re gu xizh. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Wen re gu xaa nded bid xaa ngwii lo na, Xaa Nyaad Ngok Myet, gorna yii re myet lo gu, nu gorna koo re xaa gu yezh, nu gorna nge re xaa lo gu, nu gorna nanzheklat re xaa gon xtizh re gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Byakdoola gu, nu nix doo gok lextoo gu re mbizh ba, nel re gu kayaa kwaan gro doo naz leen yiba; nel sbaaka mnayii re xaa ne re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Per nales ded re gu xaa rik nal, nel mkanola gu rese kwaan mle zee nix doo nzhak lextoo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Per nales ded re gu xaa nkano zyen doo kwaan nzhaw, nel gu gak nlaan. ’Per nales ded re gu xaa nxizh nal, nel lee re gu gonn nu gak nales doo lextoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Per nales ded re gu xaa wen nii re myet lo nal, nel sbaa ngunii wen re myet lo re xaa mbezh mzaa xaa kwent kwaan nguné Dios lo lee xaa yilo per nawlit xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Noka Jesús nzhé: —Per lee na nii lo re gu, xaa kayon xtizh na: Bkela gu re xaa nayii ne gu, ble gu wen lo re xaa nzhedizh nawent lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nii wen gu lo re xaa kwaan nxobde lo gu, nu gunaab gu lo Dios kwent cheen re xaa nii wdizh nawent lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chelee tub xaa la panyet tagarlo gu, noka bzaa gu stub tagarlo gu la xaaya. Nu chelee tub xaa nzhekla kiib xchamar gu, noka laa gu kiib xaa xkamis gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nu loka cho xaa naab tub kwaan lo gu, zaa guya lo xaa, nu chelee tub xaa kiib tub xcheen gu nayét gu lo xaa: “¿Ma xcheen na?” ");
INSERT INTO zpoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mod nzhekla gu le xaa lo gu, sbaaka ble gu lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Chelee gu nkela gu nebse xaa nkela gu, ¿xana kwaan wen le gu gan? Noka re xaa nzeb jwalt snee nle. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nu chelee gu wen nak gu nebse lo re xaa kwaan nle wen lo gu, ¿xana kwaan wen le gu gan? Noka re xaa nzeb jwalt nle kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nu chelee gu nteche gu tub kwaan lo tub xaa kiin tub kwaan lo gu, nu nela gu zere xaaya lo gu stub welt, ¿xana kwaan wen le gu gan? Noka re xaa nzeb jwalt nteche kwaan ngiin wechxinn xaa lo xaa, nu nela xaa lee xaa zereya lo xaa stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nzhaal kela re gu xaa nayii ne gu nu nalet gu xgab chelee xaa nanketla xaa gu. Ble gu kwaan wen lo xaa nu nalet gu xgab chelee xaa nalet xaa kwaan wen lo gu, nu chelee xaa kiin xaa tub kwaan lo gu teche guya lo xaa nu nalet gu xgab chelee xaa nazeret xaaya lo gu stub welt. Snee gro doo kwaan le gu gan, nu snee gak re gu xinn Dios, xaa nzob naz yiba, nel nle xaa kwaan wen lo re myet, nixa nanzaat re myet dixkix lo xaa nu nixa nakap nak re myet lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kwaanzee noka gu blesla gu ne gu re myet, modxa nlesla Xuz be Dios ne re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Nanaabt gu kwent lo stub xaa zee noka Dios nanaabt kwent lo gu. Byenlazh gu kwaan nawent kwaan nle re myet lo gu, zee noka Dios chee re jwalt cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Zaa gu kwaan lo stub naz xaa, zee noka Dios zaaya lo gu, kwaan tub medid nyazhera. Dios chiix kwaan zaa xaa lo gu leeka medid kwaan mchiix gu kwaan mzaa gu lo stub naz xaa, leeka sbaa chiix Dios kwaan zaa xaa lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús nzhé wdizh nabix ne lo re xaa: —Nyent mod wee tub syeg leeka sasyeg syeg, nel rop xaa ne la leen blee. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nik tub xaa mseed nyent mod gakra lo xmaestr xaa, per gorna yilo seed xaa, zeera zhin xaa gak xaa kwenta xmaestr xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Chozhiin ngwii lu lo paj kwaan nzho leen mbeelo wechxinn lu, nu nangwiit lu lo dub yag kwaan nzho leen mbeelo lu? ");
INSERT INTO zpoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nu chelee lu nanzeent lu nzho dub yag leen mbeelo lu, ¿xomod le lu reyez yé lu lo wechxinn lu: “Laa ko na paj kwaan nzho leen mbeelo lu”? ¡Gu nak xaa nkade nu nanlet gu kwaan wen! Yilotlaka bloo dub yag kwaan nzho leen mbeelo lu, zee nzho mod wii wen lu, zee koo lu paj kwaan nzho leen mbeelo wechxinn lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesús nzhé: —Nyent yag kwaan wen kwaan nzaa xle nawent. Nu noka nyent yag nawent kwaan nzaa xle wen. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kad yag nzhakbeyy kwaan xle cheena. Nantopt xaa ig lo yag yich, nu nixa nantopt xaa ub lo yag yich garbat. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lee xaa wen, nzhedizh kwaan wen, nel kwaan wen nzhal lextoo xaa. Lee xaa mal, nzhedizh kwaan nawent, nel kwaan nawent nzhal lextoo xaa. Nel lextoo xaa nzhal kwaan nzhedizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Chozhiin nii gu lo na “Xaa Nabeyy”, nu nanlet gu kwaan nii na? ");
INSERT INTO zpoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nal lee na nii lo gu xomod nak xaa nreke tich na; nkenzha xaa xtizh na nu nle xaa kwaan nii na. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lee xaa ne nak mod tub xaa mza tub li. Yilotlaka mdeen nech xaa simyent axta lo ke. Nu gorna mroo nis yuu nu mkee nis cho yoo, per namlet nis gan mkuna nel wen wen nyaya. ");
INSERT INTO zpoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Per lee xaa nzhon kwaan nii na, nu nanlet xaa kwaan nii na, xaa zee nak mod tub xaa mza li lo yux nu namdeent xaa simyent. Nu gorna mroo nis yuu, nu mkee nisa, zee mbaxcheya nu tira mluxa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Gorna ngulo ngunii Jesús lo re myet, zee nya xaa naz yezh Capernaum. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Baa nzho tub xaa nabeyy lo tub gayoo soldad Roma, xaa ne nkano tub xmos, xaa nkedoola xaa, nu ne nzak xaa ne, mer yet xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Gorna lee xaa nabeyy lo re soldad mbin lee Jesús nle kwaan gro doo, zee mxaal xaa lak xaa Israel, xaa gol, zee yichezh xaa Jesús zee sekwen Jesús xmos xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nu gorna mzhin re xaa gol lo Jesús ngunaab xaa jabor lo Jesús nu nzhé xaa lo xaa: —Nzhaal le lu yudar xaa nabeyy lo tub gayoo soldad, ");
INSERT INTO zpoNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","nel nkela xaa re sawlazh be, nu leeka lee xaa mdexkwaa pa nya re be nseed be xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Zee mreke Jesús tich re xaa gol, per gorna merla zhin xaa garli xaa nabeyy lo tub gayoo soldad, zee lee xaa nabeyy lo tub gayoo soldad mxaal lak xmig xaa yé xaa lo Jesús: —Xaa Nabeyy, nalet lu xgab yé lu lee lu zeeb leen li na, nel nanont na lo lu, ");
INSERT INTO zpoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","kwaanzee nixa nangwat na ngukwaan na lu. Nebse nabeyy zee sekwen lu xmos na. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nel nzho tub xaa nabeyy lo na, nu sbaaka nkano na soldad, xaa nabeey na lo. Gorna yé na lo tub xaa: “Gwa”, zee ya xaa; gorna yé na lo stub xaa: “Te”, zee nyiid xaa lo na; nu gorna nabeey na xmos na le xaa tub kwaan, zee nle xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mdedyall Jesús gorna mbin xaa kwaane, nu mwii Jesús lo re xaa nzhake tich xaa nu nzhé xaa lo re xaa: —Wlipa na nii na lo gu, ¡nik tub xaa sawlazh be nangwiit lo Dios modxa ngwii xaabyi ne lo Dios! ");
INSERT INTO zpoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nu gorna mbare re xaa mxaal xaa ngwa lo Jesús garli xaa nabeyy lo soldad, lee xmos xaa ngulola ngokwen. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Gwluzh ngulo mded kwaane, lee Jesús kwaan re xaa mseed lo xaa nzha naz yezh kwaan le Naín. Nu noka zyen doo myet nzhake tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Gorna nzhazhin re xaa gax roo yezh, ngune xaa lo zyen doo xaa yezh nzhakaach tub xaa ngut. Per xaa ngut nak techosa xaa lo xnaa xaa, nu byud xnaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nu gorna ngune Xaa Nabeyy lo me, mlesla xaa ngune xaa me, zee nzhé xaa lo me: —Nagonnt lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nu gorzee mbii gax xaa lo yin, zee lee re xaa nzhano yin mlaz, zee lee Jesús mgal cho yin nu nzhé xaa lo xaa ngut: —Xaa mad, ¡guxche! ");
INSERT INTO zpoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Zee lee xaa ngut ta mzob nu mzelo nzhedizh, zee lee Jesús mzaa xaa lo xnaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nu gorna ngune re xaa ngok kwaane, mzheb doo re xaa nu mzelo re xaa mbill lo Dios, nu nzhé re xaa: —Tub xaa non doo, xaa nzaa kwent kwaan nzhé Dios lo lee xaa mzhin lo re be nee nal. Nu noka nzhé re xaa: —Dios nze le yudar re sawlazh be. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nu dub welt yizhyo Judea mbin re xaa kwaan mle Jesús nu noka re stub naz xaa nzho yizhyo gax mbin kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan mbin rese kwaane, nel re xaa mreke tich xaa mzaa kwenta lo xaa. Zee mrezh Juan chop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Zee mxaal xaa xaa ya nabdizh xaa lo Jesús zee nen che mer lee xaa nak Xaa Mxaal Dios Nabeyy, cheleeya nalet xaaya, zee kwaz xaa yaad stub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Zee lee rop xaa mxaal Juan mbii gax lo Jesús nu nzhé xaa lo Jesús: —Juan Xaa Nchubnis mxaal nu nabdizh nu lo lu, nen chelee lu nak Xaa Mxaal Dios Nabeyy o kwaz xaa yaad stub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nu leeka gorzee lee Jesús msekwen zyen doo xaa ne nzak lo yalyizh cheen xaa, nu noka msekwen xaa re xaa nded bid lo mbi mal kwaan nzho leen lextoo xaa, nu noka mxal xaa garlo re syeg. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Zeera mkeb xaa lo rop xaa mxaal Juan, nu nzhé xaa: —Zyaa gu nu guzh gu re kwaan ngune gu nu re kwaan mbin gu lo Juan. Guzh gu lo xaa lee re syeg ngwii, nu lee re xaa mdeen nze, nu lee re xaa nyall cho ngokwen, nu lee re xaa nkwee mxal nzha, nu lee re xaa ngut mroban, nu lee lo re xaa prob nzhon kwent cheen wdizh chul cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Wen re myet, xaa nanzeret tich lo na nu nantont ne na! ");
INSERT INTO zpoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Gorna lee rop xaa mxaal Juan nya, nu gorzee lee Jesús mzelo mzaa kwent cheen Juan lo re myet, nu nzhé xaa: —Leezha ngwa gu naz wen, ¿cho kwaan mle gu xgab wii gu lo? ¿Che ngwa gu ngwasewii gu lo tub nit kwaan nkun mbi? ");
INSERT INTO zpoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nu cheleeya nanakta sbaa, ¿cho kwaan ngwa gu ngwasewii gu lo zeey? ¿Che ngwa gu ngwasewii gu lo tub xaa nak tub ler chul doo nzhak? Nela gu lee re xaa nzhak re ler chul doo, nak re xaa wen nzho leen li re rey. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wena, ¿cho kwaan mroo gu ngwasewii gu lo? ¿Che ngwasewii gu lo tub xaa nzaa kwent kwaan nzhé Dios lo lee xaa? Wlipa na nii na, lee Juan nak mas non ke stub xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan nak xaa nzaa Xkyech Dios kwent: Wii gu, xaal na tub mandad yilo ke lu, xaa zee dexkwaa naz ze lu. Mal. 3:1 ");
INSERT INTO zpoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Lee na nii lo re gu, nik stub xaa nangoknont kwenta Juan. Per snee naka, lee xaa nanont tant pa nabeyy Dios, nak mas nonra ke Juan. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Gorna mkenzha rese xaa kwaane, nu lee re xaa ntop demi kwaan nya naz Roma, rese xaa mrubnis lo Juan, zee mbezh re xaa: “Nali nak Dios”. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per lee re xaa fariseo nu re maestr xaa nlu xtizh Dios, namrubnist xaa lo Juan, kwaanzee nanet xaa kayaa xaa kwaan nzhé Dios lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zee lee Jesús nzhé: —¿Cho kwenta nzhak re myet xaa nzhi nal? ");
INSERT INTO zpoNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lee re myet ne nak kwenta re madwin, mad nzob ngit lo xbi, mad mbazhe lo re wechxinn: “Mbill nu bzhik, per lee re gu namkaniit; mbill nu re kwaan nales nzholl, per lee re gu nambinnt”. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sbaa nii na, nel leezha mbid Juan Xaa Nchubnis, nanzhawt xaa pan, nu nixa nanzhot xaa xis ub, nu lee re gu né: “Mbi mal nzho lextoo xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","’Nu nal nzhal na, Xaa Mzhin Ngok Myet, nzhaw na nu nzhoo na re kwaan, nu lee re gu mbezh lee na nak tub xaa nzhaw doo nu nzho doo xis ub, nu nak na xmig re xaa ntop demi kwaan nya naz Roma nu noka nak na xmig re xaa nle re kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mod nii re xaa: “Lee yalnzhak cheen Dios luu klar lo re xaa nzho yek”. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Lee Simón, tub fariseo mbe Jesús gaw garli xaa. Nu gorna kayaw xaa, ");
INSERT INTO zpoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","zee lee tub ngwnaa, me nzeb doo jwalt, me nzho yezh ba, mzhin lo Jesús, nel ngune me lee Jesús kayaw garli fariseo. Nu nzheno me tub bot dik kwaan mdexkwaa kwaan ke le alabastro, kwaan nyazhe perfum kwaan chul doo nzebech. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nzhonn me mzob me nii Jesús, nu nis kwaan nzhonn me ngok bsii nii Jesús. Nu zeera msekwizh me nii Jesús kwaan yich yek me. Nu ndaw me bit nii xaa nu mxo me perfum tich nii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Zee lee fariseo, xaa mbe Jesús gaw Jesús garli xaa, gorna ngune xaa kwaane, snee mle xaa xgab leen yek xaa: “Chol xaa ne ngak tub xaa nzaa kwent kwaan nzhé Dios lo lee xaa, zeen xaa nen cho ngwnaa ne, me kagal cho xaa, tub ngwnaa me duzna kwaan nawent nle”. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Zee lee Jesús nzhé lo fariseo: —Simón, nzhekla na nii na tub kwaan lo lu. Lee fariseo mkeb nzhé: —Néya maestr. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús nzhé: —Za na tub kwent lo lu. Ngu chop xaabyi xaa mdiin demi lo tub xaa. Tub xaa mdiin gaay gayoo demi plat, lee stub xaa mdiin choobchii demi plat lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nu nel nyent demi kix xaa lo xaa mteche demi lo xaa, zee lee xaa mteche demi lo xaa mle perdon re demi kwaan mzeb rop xaa. Nal nabdizh na lo lu: ¿xana xaa mas mkelara xaa mtecheya lo xaa? ");
INSERT INTO zpoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Zee lee Simón mkeb nzhé: —Nzak na xaa nzeb mas grorey nkelara xaa. Jesús nzhé lo fariseo: —Wli luya. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Zee lee Jesús mwii lo ngwnaa nu nzhé xaa lo Simón: —¿Che nlu ngwnaa ne lo lu? Mzeeb na leen li lu, nu namzaat lu nis keeb na nii na; per lee ngwnaa ne mdeeb nii na kwaan nis garlo me nu msekwizh meya kwaan yich yek me. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gorna ngunii lu “dix” lo na, nandawt lu bit tagarlo na. Per lee ngwnaa ne, axta gorna mzhin me, nu axta nal seetaka kayaw me bit nii na. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Namteebt lu anseyt yek na, per lee ngwnaa ne mxo me perfum tich nii na. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kwaanzee nii na lo lu, lee rese jwalt cheen ngwnaa ne ngulola mzhe, nel nkedoola me na. Per lee re xaa mzhe chepse jwalt cheen, zee chepse nkela xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Zee nzhé xaa lo ngwnaa ne: —Lee re jwalt cheen lu ngulola mzhe. ");
INSERT INTO zpoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nu lee lak xaa nzhi baa, nzhé lo wechxinn xaa: —¿Cho nak xaa ne, nzak xaa nzho mod kiib xaa jwalt? ");
INSERT INTO zpoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Zee lee Jesús nzhé lo ngwnaa: —Nel ngwii lu lo na zee ngok nzhul lu lo rese jwalt cheen lu, nal wen nya lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Gwluzh ngulo mded re kwaane, zee nzha Jesús kwaan re chiibchop xaa mseed lo xaa, nzhazaa xaa kwent cheen wdizh chul cheen pa nabeyy Dios re yezh nu re rench. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nu noka nzha lak ngwnaa, me mloo Jesús mbi mal lextoo nu me msekwen xaa lo yalyizh. Tub me nzha kwaan lee xaa le Mari, me yezh Magdala, me ne mloo xaa gazh mbi mal lextoo; ");
INSERT INTO zpoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","nu stub me le Juan sa Chusa, xaa mkee zhiin lo Herod; nu stub me le Susana, nu noka nzha zlakra ngwnaa. Nu re ngwnaa ne mzaa me kwaana nkano me lo Jesús nu lo re xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Zyen doo myet mroo lazh yiyon kwaan yé Jesús, snee mod zyen doo myet mdop lo Jesús, zee mzaa Jesús kwent nabix lo re xaa nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Nal lee na za tub kwent lo gu cheen tub xaa nchech nzhobxtil lo yo. Nu gorna kachech xaa ben lo yo tub naza mla leen naz, nu mtaazh xaa ticha, nu lee mbyin ngwa nu ngutawa. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Stub naza mla lo ke pa nyent zyen yo; nu gorna mlena mxena chep, nu mbizha nel nyent gop xena. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nu lee stub naza mla leen yag yich; gorna mlena, mlena leen yag yich zee mdin yicha. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Per lee stub naza kwaan mla lo yo wen, mxen dooya nu mzaaya zyen doo nzhobxtil, axta tub yiyoo nzhobxtil mzaa tub ben. Sbaa nak kwent. Nu dublegan nzhé Jesús: —¡Loka cho nzob nzha, nzhaal gon kwaane! ");
INSERT INTO zpoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Lee re xaa mseed lo Jesús mnabdizh lo Jesús: —¿Xomod nak kwent ne? ");
INSERT INTO zpoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús mkeb lo re xaa nu nzhé xaa: —Dios mzaa yek re gu zee ne gu xomod nak re kwaan nanyunt cheen pa nabeyy Dios; per lee lo stub naz xaa nii na duzna kwent nabix, nu zee nixa wii xaa nu naluta lo xaa, nu nixa gon xaaya nu nalata yek xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Snee nak kwent nabix ne: Lee nzhobxtil nak kwenta xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lee nzhobxtil kwaan mla leen naz nak kwenta re xaa nzhon xtizh Dios, per lee Maxuu nzha nkiiba lo xaa zee nawiit xaa lo Dios nu zee nalet xaa gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lee nzhobxtil kwaan mla lo ke pa nyent zyen yo nak kwenta re xaa nzhon xtizh Dios, nu nyakdoola xaa mkayaa xaaya, per nanyet nzo xaa lo xtizh Dios; ngwii xaa lo Dios tub tyemp, per gorna nzhin tub yalzi lo xaa zee nlaa xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Lee nzhobxtil kwaan mla leen yag yich nak kwenta re xaa nzhon xtizh Dios, per chepse chepse lee re xgab yizhyo ne nle gan lo xaa nu re demi kwaan nkano xaa nu re kwaan nlu chul cheen yizhyo ne, ngin xtizh Dios lextoo xaa nu kwaane nle zee nanzaat xaa xle. Lee xaa nak kwenta tub nzhobxtil kwaan ngin yag yich nu nanzaata nzhobxtil. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Per lee nzhobxtil kwaan mla neb lo yo wen, nak kwenta re xaa nzhon xtizh Dios kwaan dub lextoo xaa, nu nle xaa re kwaan nzhé xtizh Dios, nu nye nzo xaa lo xtizh Dios, nu xaa ne nzaa zyen doo xle. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Noka nzhé Jesús: —Nik tub xaa nankeet tub bruj nu nsaaw xaa yeka kwaan tub almud o chep xaaya xan loon, sinka nzob xaaya pa ya nzeb, zee zaaya xni lo re xaa rep leen yoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nik tub kwaan xlaan nyent mod nalut, nixa tub kwaan nzholaan nyent mod nanet re xaa loya. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Kenzha wen gu re kwaan nii na. Nel re xaa nkano kwaan, kayaa xaa masraya; per lee re xaa nankanota axta chep re kwaan nkano xaa yiib lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Xnaa Jesús nu re wech Jesús mzhin pa nzo Jesús, per nyent mod bii xaa gax lo Jesús nel zyen doo myet nzhi baa. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nu gorzee nzhé lak xaa lo Jesús: —Xnaa lu nu re wech lu nzo naz jwer, nzhekla re xaa nii xaa lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lee Jesús mkeb nzhé: —Re xaa nzhon xtizh Dios nu nle kwaan nzhéya, re xaa zee nak mod xnaa na nu mod re wech na. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tub mbizh Jesús mzeeb leen tub kano kwaan re xaa mseed lo xaa, nu nzhé xaa lo re xaa: —Ya be stub ta roo nistoo. Zee nzhaze xaa nzha xaa leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nu gorna nzhaze re xaa leen nistoo, ta ngot Jesús. Nu lee tub mbi dox doo mroo leen nistoo, nu mzelo nis nguzhe leen kano, nu nzho reyez la kano naz xan nistoo, nu kaded doo xaa bid. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kwaanzee mloo xaa mkaal lo Jesús nu nzhé xaa: —¡Maestr! ¡Maestr! ¡Nzhalaw be leen nistoo! Jesús nguxche nu mgalno nistoo nu mbi, nu gorzee lee nistoo nu mbi zheta ngok. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Gwluzh nzhé xaa lo re xaa mseed lo xaa: —¿Chozhiin nzheb re gu? ¿Ma kwaan ngwii gu lo Dios? Per lee re xaa mzheb doo nu mdedyall xaa, nu mnabdizh xaa lo wechxinn xaa: —¿Cho nak xaabyi ne, nu axta nistoo nu mbi nzhon xtizh xaa? ");
INSERT INTO zpoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mzhin xaa stub ta roo nistoo cheen Galilea yizhyo kwaan le Gadara. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nu gorna mla Jesús leen kano zee mroo tub xaa yezh, mbii gax lo Jesús. Xaa ne nzho mbi mal lextoo. Nzha zyen doo mbizh nanzhaktra xaa xab xaa, nixa nanzhotra xaa li xaa, sinka lee xaa nyu duzna leen yeer pa nyu re xaa ngut. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Gorna ngune xaa lo Jesús, nu mkichxub xaa lo Jesús nu mbazhe xaa nzhé xaa: —¿Chozhiin nze lu lo nu, Jesús Xgann Dios, xaa nzob naz yiba? ¡Naab na lo lu nateedt lu nu bid! ");
INSERT INTO zpoNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nzhé xaa kwaane, nel Jesús mgalno re mbi mal kwaan nzho lextoo xaa, zee mrooya lextoo xaa. (Zyen welt nzen nye mbi mal xaa. Nu nixa nkado re myet yaa xaa nu nii xaa kwaan kaden, per nle xaa gan nchoog xaaya nu nzhe mbi mal xaa naz wen.) ");
INSERT INTO zpoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús mnabdizh lo xaa: —¿Cho le lu? Nu lee xaa mkeb nzhé: —Na le Zyen Doo. Nzhé xaa kwaane, nel zyen doo mbi mal nzho lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nu lee re mbi mal ngunaab lo Jesús: —Nagubit lu re nu leen yerdoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nel gax zee nzhi zyen doo kuch kayaw, zee lee re mbi mal nzhé lo Jesús: —Laa zeeb re nu lextoo re kuch ba. Nu zee lee Jesús mzeyal. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nu lee re mbi mal mroo lextoo xaa nu nya ngu lextoo re kuch. Nu leeka gorzee mzelo re kuch mrexonn nkato naz yat nu mla axta leen nistoo. Nu ngwep re ma nis nu tira ngut re ma. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Per gorna mzeen re xaa nkanap re kuch kwaane, gorzee mrexonn xaa nu nya xaa mzaa xaa kwenta lo re xaa nzo wen nu lo re xaa yezh. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gorzee nzhasewii re myet nen cho kwaan ngok. Nu gorna mzhin xaa pa nzo Jesús, zee mlu xaabyi, xaa mroo re mbi mal lextoo, nzob lo Jesús, nakla xaa ler nu ngokwenla xaa, zee mzheb doo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nu lee re xaa ngune ngok kwaane mzaa kwent lo re xaa nen xomod ngokwen xaa ngu mbi mal lextoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Rese myet, xaa yizhyo Gadara, nzhé lo Jesús zee nya Jesús, nel nzheb doo re xaa. Kwaanzee lee Jesús mzeeb leen kano nu nya. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lee xaabyi kwaan mroo re mbi mal lextoo nzhé lo Jesús: —Laa reke na tich lu. Per Jesús mnabeyy xaa, zee lake xaa zee zaa xaa kwent lo re xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Zyaa garli lu, nu guzh re kwaan mle Dios lo lu. Lee xaabyi zee nya, nu mzaa xaa kwent kwaan mle Jesús lo rese xaa dub yezh. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gorna mbare Jesús stub ta roo nistoo, nyakdoola re myet mkayaa xaa xaa, nel rese xaa nkambaz xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nu gorzee mzhin tub xaa le Jairo, xaa nak tub xaa nabeyy pa nkasa re xaa Israel nseed xaa xtizh Dios. Xaabyi ne mkichxub lo Jesús nu ngunaab xaa zee ya Jesús garli xaa, ");
INSERT INTO zpoNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","nel nkano xaa tubka xchap xaa, mad nzho kan tub chiibchop liin, mer yet. Nu gorna nzha Jesús zyen doo myet nzhake tich xaa nu ntaaw doo re myet xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lo re myet zee nzha tub ngwnaa, me nzhala chiibchop liin ne nzak. Tubka nded ren lextoo me. Nu mlux me rese kwaan nzhap me ngwa me lo re doktor, nu nik tub xaa namlet gan sekwen me. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ngwnaa ne mbii naz tich Jesús, nu mgal me cho xab xaa. Nu leeka gorzee lee ren kwaan ded lextoo me mlaz. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Zee lee Jesús mnabdizh: —¿Cho mgal cho na? Nu rese xaa nzhé: —Namgalt na cho lu. Per lee Pér nzhé: —Maestr, rese xaa ntaaw lu nu nzobya lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kwaanzee Jesús mbare nzhé: —Nzho tub myet mgal cho na, nel mzeen na mroo yalngezh cho na. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Per lee ngwnaa ne nyent mod kaxlaan me nzheb me nu mbii me gax mkichxub me lo Jesús. Nu nzhé me delant lo re xaa, cho zhiin mgal me cho xab Jesús, nu xomod ta ngokwen me mgal me cho xab xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús nzhé lo me: —Xchap na. Nel mwii lu lo Dios, zee ngokwen lu. Nal wen nya lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Seetaka kanii Jesús gorna mzhin tub mos lo Jairo nzhé lo Jairo: —Lee xchap lu ngulola ngut, nankintra nii lu lo maestr. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Per Jesús mbin kwaan nzhé mos nu nzhé xaa lo Jairo: —Nazhebt lu. Nebse wii lu lo Dios, lee xchap lu roban. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nu gorna mzhin xaa garli Jairo, namlaat Jesús mzeeb re xaa kwaan lee xaa, nebse mzeeb Pér, Chag, nu Juan kwaan xuz mad nu xnaa mad mzeeb. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Rese xaa nzhi nzhonn nu mbazhe nel ngutla mad, per lee Jesús nzhé lo re xaa: —Nagonnt gu nel nanguta mad, nebse naxna mad. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Rese xaa mxizhno Jesús, nel nela xaa ngut mad. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Zee mzen Jesús yaa mad nu ngunii xaa dub gan nu nzhé xaa: —¡Mad, guxche! ");
INSERT INTO zpoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nu lee mad mbare mroban. Nu gorzee nguxche mad, zee mnabeyy Jesús zaa xaa kwaan gaw mad. ");
INSERT INTO zpoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mdedyall doo xuz mad nu xnaa mad. Per lee Jesús nzhé lo re xaa nik tub kwaan ngok nayét xaa lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús mrezh re chiibchop xaa kwaan kaseed lo xaa, nu mzaa xaa yalnabeyy lo re xaa zee nzho mod koo xaa reta klas mbi mal kwaan nzho lextoo re myet, nu sekwen xaa re xaa ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mxaal xaa re xaa zee zaa xaa kwent xomod nak pa nabeyy Dios nu sekwen xaa re xaa ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nu nzhé xaa lo re xaa: —Nik tub kwaan naweet gu ze gu naz, nixa tub garrot, nixa yex kwaan yo re xcheen gu, nixa pan, nixa demi, nixa chop naz ler naweet gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Loka yezh pa zhin gu kwaan gu tub yoo pa kwaz gu, nu baa blaz gu axta roo gu yezh ba. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nu chelee xaa tub yezh nanzheklat kayaa xaa gu, broo gu yezh baa nu brib gu yide kwaan ke tich xkyelyed gu, zee ne re xaa yezh ba lee re sawlazh xaa mle tub kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Zee mroo re xaa, nu ngwa re xaa rese yezh nu rese rench, mzaa xaa kwent cheen wdizh chul nu msekwen xaa re xaa ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Rey Herod mbin rese kwent cheen Jesús nu rese kwaan mle Jesús. Nanetra Herod nen cho kwaan le Herod xgab, nel rol xaa mbezh lee Juan mroban, nu kale xaa re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Stub naz xaa mbezh lee Jesús nak Li, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo; nu stub naz xaa mbezh lee Jesús nak stub re xaa mzaa kwent kwaan nzhé Dios lo re xaa yilo, xaa mroban. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Per lee Herod nzhé: —Mer na mxaal xaa mchoog yek Juan. ¿Cho xaaya zeey? ¿Xana xaa kayon na kwent cheen? Kwaanzee Herod nzhekla ne lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Gorna mbare re xaa mkayaa yalnabeyy lo Jesús, zee nzhé re xaa kwaan mle re xaa lo Jesús. Zee lee Jesús mbe nebse re xaa mseed lo xaa nu ngwa xaa stub yezh le Betsaida, zee zo nebse re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Per gorna ngune re myet lee Jesús nzha naz ba, zee mreke re xaa tich Jesús. Mkayaa xaa re xaa, zee mzaa xaa kwent cheen pa nabeyy Dios lo re xaa nu msekwen xaa re xaa ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gorna nzhazhela yizhyo, zee mbii chiibchop xaa mseed lo Jesús nu nzhé xaa lo Jesús: —Xaal re myet ne, zee nya xaa zee le xaa deskans nu yikwaan xaa kwaan gaw xaa re yezh nzhi gax nee; nel nik tub kwaan nyent gaw re xaa nee. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús nzhé lo re xaa: —Re gu zaa kwaan gaw xaa. Lee re xaa mkeb nzhé: —Nik tub kwaan nankanot nu nee, nebse gaay pan nu chop mbal, per chelee lu nzhekla lu yizi nu kwaan gaw re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nu baa nzhi kan gaay mil xaabyi. Per lee Jesús nzhé lo re xaa mseed lo xaa: —Guzh re gu lo re xaa zee zob choobchiiga xaa tub pa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sbaa mle re xaaya, zee mzob rese xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Zee lee Jesús mzen gaay pan nu rop mbal, nu mwii xaa naz yiba nu mzaa xaa dixkix lo Dios, nu mle rol xaaya nu mzaa xaaya lo re xaa mseed lo xaa, zee kiiz re xaaya lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Rese myet ndaw axta paro ngulo nguzhe lextoo re xaa. Nu seesa mtazhe re xaa zchiibchop chekwid pan kwaan mlake. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tub mbizh techosa Jesús kawdizhno Dios. Nu lee re xaa mseed lo xaa nzhi gaxka lo xaa, zee mnabdizh xaa lo re xaa: —¿Cho né re myet nak na? ");
INSERT INTO zpoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lee re xaa mkeb nzhé: —Tub naz xaa mbezh lee lu nak Juan Xaa Nchubnis, stub naz xaa mbezh lee lu nak Li, nu stub naz xaa mbezh lee lu nak stub re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, mrobanla nal. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Lee re gu, ¿cho nle re gu xgab nak na? —nzhé xaa lo re xaa. Nu lee Pér mkeb nzhé: —Lu nak Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nu mnabeyy Jesús lo re xaa nu nzhé xaa: —Nik tub lo nayét gu kwaane ");
INSERT INTO zpoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","—nzhé xaa lo re xaa—. Lee na nak Xaa Mzhin Ngok Myet, nu nzhaal ded doo na bid. Nu nakayaat re xaa gol na, nixa re ngwleyy xaa non, nixa re maestr xaa nlu xtizh Dios. Re xaa ne gut na, per mbizh yon lee na roban. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Gwluzh zeera nzhé xaa lo re xaa: —Loka cho xaa nzhekla reke tich na, nkin laa xaa rese kwaan nzhap xaa, nu rese kwaan nzho yek xaa le xaa, nu gak xaa kwenta tub xaa mbit xaa lo krus, nu reke xaa tich na. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chelee tub xaa yet xaa nel nreke xaa tich na, le xaa gan yalnaban kwaan tira. Per lee xaa nzheb yet kwaan na, nalet xaa gan yalnaban naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Per cho gan le myet chol rese kwaan nzho lo yizhyo nkano xaa, nu nalet xaa gan yalnaban naz leen yiba? ");
INSERT INTO zpoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nel loka xaa nton ne na nu ton ne xtizh na; noka na, Xaa Mzhin Ngok Myet, ton na ne na xaa zee, gorna bare na naz lo yizhyo stub welt, kwaan xni chul cheen na nu kwaan xni chul cheen Xuz na nu kwaan re xmandad xaa, xaa nambey. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Wlipa na nii na lo gu, lakra gu xaa nzhi nee nal, nayeta axta yilo ne gu xomod nak pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kan tub xon mbizh ngwluzh, nzha ngulo ngunii xaa kwaane, zeera nguxoob Jesús yek tub yi zee wdizhno xaa Dios. Nu mbe xaa Pér, Chag, nu Juan. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nu gorna kawdizhno xaa Dios, lee mod nzhak xaa mzhee, nu lee xab xaa mluya rus doo nu mla doo xniya. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nu mlu chop xaabyi, kwaan kawdizh kwaan lee xaa. Xaa ne nak Ches nu Li. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nu nzo yon xaa xsaww lo tub xni kwaan chul doo nu mdizh yon xaa kwent cheen yalgut cheen Jesús kwaan ded xaa yezh Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Zee lee Pér kwaan Chag nu Juan nze doo mkaal lo xaa per nangota xaa, zee ngune xaa lo xni chul cheen Jesús nu lo rop xaabyi kwaan mzo kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gorna lee rop xaabyi ba nzhekla nya, lee Pér nzhé: —Maestr, ¡wen nzo nu nee! Nal dexkwaa nu chon ramad: tub cheen lu, stub cheen Ches, nu stuba cheen Li. Per nanet Pér cho kwaan ngunii Pér. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Gorna kaniika xaa, zee lee tub xkaw msaaw lo re xaa, nu mzheb doo xaa ngu xaa leen xkaw. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nu leen xkaw mroo tub bos kwaan nzhé: —Xaa ne nak xgaan na, xaa mleey na. Bin gu kwaan né xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Gwluzh gorna ngulo mbin xaa bos, ngune xaa techosa Jesús nzo. Nu re mbizh zee nik tub lo nanzhét xaa re kwaan mlu lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nu lee stub mbizh, gorna mbare xaa ngwa xaa yek yi, zyen doo myet ngwa mri lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nu lee tub xaabyi, xaa nzo lo re myet, nzhé dublegan: —Maestr, blesla lu wii lo xiin na, nel tubka xaa nkano na. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nzen tub mbi mal xaa, nu nle mbi mal zee mbazhe xaa, nu nle mbi mal zee nzhib tub yizhgutye xaa, nu ngoo mbi mal bchiin roo xaa. Nakap doo nle mbi mal xaa nu nanzheklat mbi mal laa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nzhé naya lo re xaa kaseed lo lu, zee koo xaa mbi mal lextoo mad, per nyent mod ngle xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús mkeb nzhé: —Myet xaa ned, xaa nanet wii lo Dios. ¿Axta pa gor yiche lextoo na ne na re gu? ¿Axta zlak mbizh nzhaal zo na lo re gu? Teno xgann lu nee. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Gorna lee xaa mad mbii, zee lee mbi mal mlebi mad lo yo, nu gorzee mle mbi mal zee mzhib mad stub yizhgutye. Per lee Jesús mgalno mbi mal, nu msekwen Jesús mad, nu mzaa xaa mad lo xuz mad. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nu rese xaa nzhi baa, mdedyall ngune lo kwaan gro doo cheen Dios kwaan ngok. Gorna rese xaa mdedyall ngune kwaan ngok, Jesús nzhé lo re xaa mseed lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Wen bkenzha gu kwaane nu nanyenlazht guya; nel na, Xaa Mzhin Ngok Myet, zaa xaa na lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per namlat kwaan nzhé Jesús yek re xaa, nel namzeyalt Dios laya yek re xaa. Per nzheb re xaa nabdizh xaa lo Jesús nen cho kwaan nak kwaan nzhé xaa lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Zee lee re xaa mseed lo Jesús mzelo ndildiizha nen xana xaa nak xaa mas xaa nonra. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Gorna mzeen Jesús kwaan nle re xaa xgab, zee mdezh Jesús tub madwin, nu mzo xaa mad saaw lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nu nzhé xaa lo re xaa: —Loka cho xaa kayaa tub madwin nel nkela xaa na, noka mkayaa xaa na; nu loka cho xaa kayaa na, noka mkayaa xaa xaa mxaal na. Kwaanzee lee xaa mas nanont lo re gu, nak xaa mas non lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan nzhé lo xaa: —Maestr, ngune nu lo tub xaa ngoo mbi mal kwaan yalnabeyy cheen lu, nu nzhé nu lo xaa: “Nalet lu komba”, nel nanakt xaa tub xaa be. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús mkeb lo xaa nzhé: —Nanzhaalt yé gu lo xaa: “Nalet luya”, nel xaa kwaan nanayiit ne re be, xaa zee nroo xjabor re be. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gorna mzhin gaxla mbizh kwaan nya Jesús yiba, mlib xaa lextoo xaa ya xaa Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mxaal xaa lak xaa xaa nzha delant lo xaa, zee ya xaa tub yezh cheen Samaria zee kwaan xaa pa kwaz re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Per lee re xaa yezh ba nanzheklat kayaa re xaa, nel mzeen re xaa yezh ba, lee re xaa ya naz Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Gorna lee Chag rop Juan, xaa mseed lo Jesús, mzeen kwaane, zee nzhé xaa lo Jesús: —Xaa Nabeyy, ¿che nzhekla lu nabeyy nu lo ki zee roo ki naz yiba, zee luuxa re xaa nzho yezh ne? ");
INSERT INTO zpoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Zee lee Jesús mwii lo rop xaa, nu mgalno xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Zeera nzha xaa stub yezh. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Gorna nzo Jesús kwaan re xaa naz, tub xaabyi nzhé lo Jesús: —Xaa Nabeyy, nzhekla na reke na tich lu rese pa ya lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús mkeb lo xaa nzhé: —Lee re mbaz nkano ma yeer cheen ma nu lee re mbyin nkano ma xlaaz ma; per lee na, Xaa Mzhin Ngok Myet nankanot na mer li na. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús nzhé lo stub xaa: —Breke tich na. Per lee xaa ne mkeb nzhé: —Xaa Nabeyy, laa yilo kaach na xuz na. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús mkeb lo xaa: —Laa kaach re xaa nak mod tub xaa ngut re xaa ngut. Lu, gwa nu bzaa kwent cheen pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nu lee stub xaa nzhé lo Jesús: —Xaa Nabeyy, nzhekla na reke na tich lu, per yilotlaka laa ya na zee yé naya lo re sawlizh na. ");
INSERT INTO zpoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús mkeb lo xaa nzhé: —Loka xaa zen yaa yarad nu wii xaa naz tras, nanont xaa zee pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngulo mded re kwaane, zee lee Xaa Nabeyy mleey stub chongal nzho chii xaa, nu mxaal xaa chopga chopga xaa nzha yilo lo xaa, zee ya xaa re yezh nu re rench pa nak diizh ya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesús nzhé lo re xaa: —Wlipa na nii na lo gu, nzho doo xchiin Xaa Nabeyy per lee xaa nkee zhiin nazyent xaa. Kwaanzee naab gu lo Xaa Nabeyy, zee xaal xaa masra xaa kee zhiin zee top xkyalgon xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kwaanzee gwa re gu nal; nu wii gu lee na xaal gu mod mbakxiil xsaww lo re lob, ma nakap. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nu nik tub kwaan naweet gu: naweet gu yex kwaan yo re xcheen gu leen, nixa demi, nixa yelyed; nu nixa nik tub lo nakwazt gu wdizh gu naz. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gorna zeeb gu leen tub yoo yilotlaka yé gu: “Wen kwi re gu, xaa nzho leen yoo ne”. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Zee chelee xaa nzho leen yoo nzhaal kayaa re wdizh wen kwaan ngunii gu lo xaa, lakeya lo xaa, per chelee xaa nanzhaalt kayaa xaaya, nalaket wdizh wen lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nu blaz gu leeka yoo baa, daw gu kwaan zaa xaa gaw gu, nu gu gu kwaan zaa xaa go gu, nel xaa nkee zhiin nzhaal yex ka. Nu nayat gu tich tub yoo stub yoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nu loka yezh kwaan ya gu nu chul kayaa xaa gu, daw gu kwaan zaa xaa lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nu bsekwen gu re xaa ne nzak, xaa nzho yezh ba, nu guzh gu lo re xaa: “Lee mbizh kwaan nabeyy Dios mzhin gaxla lo re gu”. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Per chelee gu zhin gu tub yezh nu nakayaat xaa gu, broo gu leen naz nu guzh gu: ");
INSERT INTO zpoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Axta re yide cheen yezh lazh gu, kwaan mkee nii nu, rib nuya zee gab yide ba, sbaa ne re gu lee re gu namkayaat nu. Per nkin ne re gu kwaane: Lee mbizh kwaan nabeyy Dios mzhin gaxla lo re gu.” ");
INSERT INTO zpoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Wlipa na nii na, mbizh kwaan naab Dios kwent, lee bid kwaan ded re xaa yezh ba gak mas nakap ke bid kwaan ded re xaa yezh Sodoma. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Ay, proob re gu xaa yezh Corazín! ¡Ay proob re gu xaa yezh Betsaida! ¡Ay, xomod ded gu bid! Chol leen yezh Tiro nu Sidón ngak re kwaan gro ne, kwaan ngok lo re gu, nzhala mbizh ngbare xaa lo Dios nu ngak xaa ler nadox nu ngzob xaa lo xkade kwaan lu lee xaa nales doo nzhak lextoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kwaanzee mbizh kwaan naab Dios kwent, lee bid kwaan ded re gu gak mas nakapra ke kwaan ded re xaa yezh Tiro nu Sidón. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nu gu, xaa yezh Capernaum, ¿che nzak gu nya gu yiba? ¡Nawlit kwaane, lee gu nya axta xan lo Hades pa nzho re xaa ngut! ");
INSERT INTO zpoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesús nzhé lo re xaa kwaan xaal xaa ya re yezh ba, nu nzhé xaa: —Xaa kwaan nkenzha kwaan nii gu, noka nkenzha xaa kwaan nii na; nu xaa kwaan nakayaat gu, noka nakayaat xaa na; nu xaa kwaan nakayaat na, noka nakayaat xaa xaa kwaan mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Gorna mbare chongal nzho chii xaa mxaal Jesús re yezh ba, nyakdoola re xaa nu mbezh re xaa: —Xaa Nabeyy, axta re mbi mal nzhon xtizh nu kwaan yalnabeyy cheen lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nu lee Jesús nzhé lo re xaa: —Ngune na lee Maxuu ngob leen yiba mod tub balngwzi. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mza na yalnabeyy lo re gu zee ze gu tich mball nu tich nix, nu lo rese yalngezh cheen xkontrad gu nu nyent cho gak gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nu nayaklat gu nel nzhon re mbi mal xtizh gu, sinka goklara gu nel lee le re gu nkeela naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nu leeka gorzee lee Mbi Naban mle nyakdoola Jesús nu nzhé xaa: —Goll na lo lu Xuz na, Xaa Nabeyy yiba nu yizhyo; nel mkaxlaan lu re kwaane lo re xaa nzhak nu mlu luya lo re xaa nagakt. Xuz na sbaa mle luya, nel kwaane nzhekla lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Lee Xuz na mzaa rese kwaan lo na. Nu nik tub xaa nanet cho nak na, xaa nak Xgann xaa, nebse Xuz na ne cho nak na. Nu nik tub xaa nanet cho nak Xuz na, nebse na, xaa nak Xgann xaa, ne cho nak xaa, nu re xaa nzhekla na za na kwenta lo. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nu mzere xaa yenn xaa lo re xaa mseed lo xaa, nu nzhé xaa lo re xaa: —Wen rese xaa kwaan kawii lo re kwaan kalach re gu lo. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nel wli na nii na lo re gu, zyen doo xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo nu zyen doo rey mzoblazh ngwii re kwaan kalach re gu lo, per nangunet xaa loya, nu nzhekla xaa ngon xaa kwaan kayon gu per nambint xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nu lee tub maestr xaa nlu xtizh Dios, nguxso mnabdizh lo Jesús nel nzhekla yizhal xaa tub kwaan gaazh xaa tich Jesús, nu nzhé xaa: —Maestr, ¿cho kwaan nzhaal le na zee le na gan yalnaban kwaan tira? ");
INSERT INTO zpoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús mkeb lo xaa, nzhé: —¿Cho kwaan nkee lo ley? ¿Nu cho kwaan nla yek lu gorna nlab luya? ");
INSERT INTO zpoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Lee maestr xaa nlu xtizh Dios mkeb nzhé: —Nzhaal kela lu Xdios lu kwaan dub lextoo lu, nu kwaan dub yalnaban cheen lu, nu kwaan dub yalngezh cheen lu, nu kwaan dub yek lu, nu nzhaal kela lu wechxinn lu kwentaxa nkela lu lu. Lv. 19:18; Dt. 6:5 ");
INSERT INTO zpoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús mkeb lo xaa nzhé: —Wen mkeb lu, bleya zee ban lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per lee maestr nzhekla lake wen lo re xaa nzhi baa, zee mnabdizh xaa lo Jesús nu nzhé xaa: —¿Cho xaa nak wechxinn na? ");
INSERT INTO zpoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Zee lee Jesús mkeb lo xaa nzhé: —Za na tub kwent lo lu. Tub xaa mroo naz Jerusalén nyaadla naz yezh Jericó nu mzhaal xaa lak wann, re xaa ne mlewann xaa nu mkiib xaa re xcheen xaa nu axta xab xaa mkiib xaa lo xaa, nu mzaa re xaa yenn xaa nu mlaa re xaa xaa mod tub xaa ngut. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nu lee tub ngwleyy nyaad ded naz baa. Nu gorna ngune xaa lo xaa, nebse mwii xaa lo xaa nu tub lad mded xaa lo xaa, nu nzha xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nu seeka nyaad ded tub xaa dii cheen Leví, nu gorna ngune xaa lo xaa, nebse mwii xaa lo xaa nu tub lad mded xaa lo xaa, nu nzha xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Per tub xaa Samaria, xaa nyaad ded leeka naz ba, gorna ngune xaa lo xaa mlesla xaa ne xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nu mbii xaa gax lo xaa, nu mchub xaa anseyt nu xis ub pa mweey, nu mchaal xaa ler pa mweey. Nu zee mtexoob xaa xaa tich xburr xaa nu mbe xaa xaa leen tub posad nu mkanap xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nu stub mbizh gorna lee xaa Samaria roo nya, mloo xaa chop demi plat nu nzhé xaa lo xaa nkanap posad: “Bkanap chep xaa ne nu chelee mas gro le lu gast, na kixa lo lu gorna bare na”. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Zee mnabdizh Jesús lo maestr nu nzhé xaa: —¿Cho kwaan nzak lu? ¿Xana lo yon xaa ne ngok wechxinn xaa mzaa re wann yenn? ");
INSERT INTO zpoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lee maestr xaa nlu xtizh Dios mkeb nzhé: —Xaa mlesla ne xaa mzaa re wanna yenn. Jesús nzhé lo maestr: —Zyaa nu ble kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nu gorna nzha Jesús zee mzhin xaa tub yezh; zee lee tub ngwnaa le Mart mrezh xaa garli me. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nu nkano Mart tub bal Mart, me le Mari. Nu lee Mari mzob lo Jesús, kakenzha re kwaan nzhé Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Per lee Mart nle doo xgab re kwaan nzho jwalt dexkwaa me leen yoo, nu mbii me lo Jesús nu nzhé me lo Jesús: —Xaa Nabeyy, techosa na mlaa bal na le na re kwaane. Guzh lo me le me yudar na chep. ");
INSERT INTO zpoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Per lee Jesús mkeb lo me nzhé: —Mart, zyen doo kwaan kale lu xgab, ");
INSERT INTO zpoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","per Mari mleey kwaan mas non, nu kwaanzee nakiibt naya lo me. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tub mbizh Jesús kawdizhno Dios tub pa. Nu gorna ngulo mdizhno xaa Dios, zee lee tub xaa mseed lo xaa nzhé: —Xaa Nabeyy, bseed nu wdizhno nu Dios, modxa mseed Juan re xaa mreke tich Juan. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús nzhé lo re xaa: —Gorna wdizhno gu Dios guzh gu snee: Xuz na, xaa nzob naz yiba, nzhekla na wii re myet lo lu, nel nambey doo lu. Nzhekla na yaad lu nabeyy lu lo yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Zaa kwaan gaw na nalzhe. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bchee rese jwalt kwaan mle na, modxa myenlazh na re jwalt kwaan mle wechxinn na lo na. Naleyat lu na la na lo re kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nu noka nzhé Jesús lo re xaa: —Chelee tub xmig lu mzhin garli lu wall yaal, nu nakanot lu kwaan zaa lu gaw xaa, zee nzha lu garli stub xmig lu nu yé lu lo xmig lu: “Mig, teche chon pan lo na, ");
INSERT INTO zpoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","nel lee tub xmig na mroo zit mzhin garli na nal yaal, nu nik tub kwaan nankanot na za na gaw xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nu lee xmig lu keb axta leen yoo, yé: “Naxnala re xiin sa nu, nakeet lu rezh yek na. Msaawla na garli na, nu nayixchetra na za na pan lo lu, nel nyawwla garli na.” ");
INSERT INTO zpoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wlipa na nii na lo gu, nixa xmig lu nak xaa per nayixchet xaa zaa xaa pan lo lu gor yaal, per nel ned doo nzo lu kanaab luya lo xaa, yixche xaa zaa xaa rese kwaan kin lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kwaanzee nii na lo gu: Gunaab guya, zee lee Xaa Nabeyy zaaya lo gu; bkwaan guya, zee yizhala lo gu; bkwezh gu roo yoo, zee lee xaa xal roo yoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nel rese xaa naaba kayaa xaaya; nu rese xaa nkwaana, yizhala lo xaa; nu rese xaa kwezh roo yoo, zxal xaa roo yoo lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Chelee gu nkano gu tub mad nu naab mad tub mbal gaw mad lo gu, ¿che zaa gu tub mball wiz lo mad? Telisa nazaat guya. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nu chelee mad naab mad tub ngo gaw mad lo gu, ¿che zaa gu tub nix lo mad? Telisa nazaat guya. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nu chelee re gu, xaa nak xaa nakap, nzaa gu kwaan wen lo xinn gu, ¡per lee Xuz be xaa nzob naz yiba, telisa mas wenra nak xaa nu zaa xaa Mbi Naban lo rese xaa naaba lo xaa! ");
INSERT INTO zpoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús kagoo tub mbi mal lextoo tub xaa nyent mod wdizh. Gorna mroo mbi mal lextoo xaa ba, zee mzelo xaa mdizh xaa nu rese myet mdedyall ngune lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Per lee lak xaa mbezh: —Nkano xaa yalnabeyy cheen Beelzebú, xaa nak leeka Maxuu, zee nzho mod nabeyy xaa lo re mbi mal. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Lee stub naz xaa nzhekla ne cho nak Jesús, zee nzhé xaa lo Jesús: —Ble tub kwaan gro, kwaan nze naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús nela cho xgab nle re xaa, zee nzhé Jesús lo re xaa: —Rese yezh, kwaan nzhak chop tant nu ndil kwaan leeka re sawlazh xaa, nadiit yezh ba xche. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nu chelee Maxuu gak chop tant, nu dil Maxuu kwaan leeka Maxuu, nayet Maxuu xche. Per lee re xaa nzhé ngoo na mbi mal kwaan yalnabeyy cheen Beelzebú. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Cheleeya sbaa naka, ¿cho mzaa yalnabeyy lo re xaa mseed lo gu zee koo xaa mbi mal zee? Nu leeka re xaa ne nlu nawlit nak re kwaan ngunii gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Per lee na ngoo mbi mal kwaan yalnabeyy cheen Dios, nu kwaane nlu lee yalnabeyy cheen Dios mzhinla lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Gorna lee tub xaabyi ngezh nkanap li nu nkano xaa xspad xaa, nu nle xaa xgab dil xaa kwent cheen re xcheen xaa, telisa nalewannt xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per chelee stub xaabyi xaa mas ngezhra nze le gan lo xaa, zee kiib xaa xspad xaa, zee nzho mod kiib xaa re xcheen xaa nu kiiz xaaya lo re xmig xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Re xaa nanroot jabor cheen na, xaa zee nayii ne na; nu xaa nankeet zhiin kwaan na, xaa zee nluux xchinn na. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Gorna lee tub mbi mal mroo lextoo tub xaa, zee lee mbi mal zee nzha pa nyent nis nkwaan tub pa chul doo kwaz mbi mal. Nu chelee mbi mal nanyazhaalt tub pa chul lo, zee yé mbi mal: “Bareka na garli na, pa mroo na stub welt”. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nu chelee mbi mal bare lo xaa kwaan mroo mbi mal, zee lee xaa zee nak mod tub yoo kwaan wen wen mlob leen nu axta chul nzhak. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Zee lee mbi mal mbare nya pa ngu yilo, nu yaxii mbi mal stub gazh mbi mas nawent ke mbi zee. Nu lee xaa ne gak mas nakapra ke mod nak xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Leezha kanii Jesús re kwaane, tub ngwnaa mzo lo re myet ngunii dublegan nu nzhé me: —¡Wen doo nak xnaa lu, me mzan lu nu me mzaa nizh ngu lu! ");
INSERT INTO zpoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lee Jesús mkeb nzhé: —Nanakta sbaa mod ngunii lu, sinka nii na lo lu: ¡Wen doo nak re xaa nkenzha kwaan nzhé Dios, nu nzhon xaa xtizh xaa! ");
INSERT INTO zpoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Gorna mdop zyen myet lo Jesús, zee nzhé Jesús lo re xaa: —Rese gu, xaa nzho mbizh nal nakap doo nak, nel nzhekla gu tub nseyn gro doo, per nik tub nseyn nalut na lo re gu, nebse yun nseyn cheen Jonás lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nel sbaa kwentaxa ngok Jonás tub nseyn lo re xaa yezh Nínive, sbaaka gak na tub nseyn, Xaa Mzhin Ngok Myet, lo re myet xaa nzhi mbizh nal. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nu mbizh kwaan naab Dios kwent lo re myet, lee ngwnaa me mnabeyy Re Yezh Naz Sur, gaazh kwaan tich re myet xaa nzhi mbizh nal, nel lee me mroo axta stub ta yizhyo nu ngwa me lo Salomón nel nzhekla me gon me re yalnzhak kwaan ngunii Salomón. Nu nal nee nzo tub xaa mas nonra lo Salomón. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nu noka re xaa Nínive gaazh kwaan tich re xaa nzhi mbizh nal, nel mbin xaa xtizh Jonás nu mlaa xaa kwaan nawent nu mwii xaa lo Dios. Nu lee nal nee nzo tub xaa mas non lo Jonás. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Nik tub xaa nakeet yek tub bruj, nu ko xaaya tub pa xlaan nu nixa nakot xaaya leen tub chekwid, sinka nzob xaaya tub pa ya nzeb zee zaaya xni lo re xaa nzeeb leen yoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Zaalo xaa nak mod xni kwaan nzeni lo xaa. Sbaaka chelee zaalo xaa wen nyani zee dubse cho xaa nzho xni. Per chelee zaalo xaa nanyenit zee dubse cho xaa nakaw na. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bwii gu, napa nanyenit zaalo gu, napa tira blanyas na nzo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kwaanzee chelee dubse kwerp cheen lu nla xni nu nik tika nanat nakaw, rese kwaan luu klar lo lu mod tub pa chul nla xni. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Gorna ngulo ngunii Jesús kwaane, lee tub xaa fariseo ngunii lo Jesús zee yataw Jesús garli xaa. Nu gorna mzhin Jesús garli xaa, mzelo re xaa ndaw. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nu gorna lee fariseo mwii lee Jesús nangunagt kayaw, zee mdeyall xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Zee nzhé Xaa Nabeyy lo xaa nak li yoo: —Lee re gu fariseo, wen nzet gu naz tich re bas nu naz tich re yann, per lee leen lextoo gu nyazhe re kwaan mlewann gu nu re kwaan nakap doo nak. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Xaa ned! ¿Che nanet gu lee xaa kwaan mdexkwaa kwaan naz tich noka mdexkwaa leeka kwaan naz leen? ");
INSERT INTO zpoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mas wen zelazh gu re kwaan nzhap gu lo re xaa prob zee gak nzhul dub gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ay, bid doo ded gu fariseo! Nel nzaa gu gon lo Dios tub part lo chii part re xcheen gu, axta re btyonxtil, nu rud nu rese yix lo Dios, per nanlet gu re kwaan nali nixa nankanot gu yalnkela cheen Dios leen lextoo gu. Re kwaane nak kwaan nzhaal le gu, nu noka nzhaal nzaa gu kwaan lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Ay, bid doo ded gu fariseo! Nel nyula gu zob gu tub pa non doo pa nkasa be nseed be xtizh Dios, nu nyula gu gorna nii xaa “dix” lo gu lo xbi. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ay, bid doo ded gu! Nel lee re gu nak mod tub baa, nu nanet xaa nzo nii xaa ticha. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nu lee tub re maestr xaa nlu xtizh Dios nzhé lo Jesús: —¡Maestr, gorna sbaa nii lu, noka nu ngalno lu! ");
INSERT INTO zpoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús nzhé lo xaa: —¡Ay, noka re gu maestr, xaa nlu xtizh Dios bid doo ded re gu! Nel nzhib gu kwaan nga doo tich stub xaa, xaa nyent mod wee. Nu lee gu nik chep nakagt choya, per nik kwaan kwen yaa gu nakaant choya. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Ay, bid doo ded gu! Nel ndexkwaa gu yoo chul pa nak baa cheen re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, nu xey re gu xaa yilo mbit re xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nu kwaane nlu lee re gu nzak wen kwaan mle re xey gu xaa yilo, nel lee xey gu xaa yilo mbit re xaa ne nu lee re gu ndexkwaa xbaa re xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Kwaanzee lee Dios kwaan yalnzhak cheen xaa nzhé xaa: “Xaal na lak xaa zaa kwent kwaan nzhé na lo xaa nu xaal na lak xaa nkayaa yalnabeyy lo na; nu lak xaa ne gut re xaa nu zlak xaa ne renal re xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kwaanzee lee ren cheen re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, axta gorna mzelo yizhyo nu axta re mbizh nal, nu naab xaaya lo re xaa nzho mbizh ne; ");
INSERT INTO zpoNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nu axta gorna mxo xren Bel nu axta gorna mxo xren Zacari, xaa mbit xaa xsaww lo pa nzek xaa gon lo Dios nu roo yidoo cheen Dios. Wlipa na nii na lo gu, rese kwent ne naab xaa lo re xaa nzho mbizh nal. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Ay, bid doo ded re gu maestr, xaa nlu xtizh Dios! Nkano gu leyaw cheen yalnzhak, per re gu nanseedt nu nixa nanlaat gu seed stub naz xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Gorna ngulo nzhé Jesús re kwaane, lee re maestr xaa nlu xtizh Dios nu re fariseo mrixyan doo xaa nu mzelo xaa mnabdizh xaa zyen doo kwaan lo Jesús ");
INSERT INTO zpoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","zee keb Jesús tub wdizh nawent, nu snee yizhal xaa tub kwaan gaazh xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nu zyen doo mil myet mzelo mkasa lo Jesús nu nzelo re xaa ntaaw doo xaa wechxinn xaa. Zee lee Jesús ngunii yilotlaka lo re xaa mseed lo xaa, nu nzhé xaa: —List bzo gu lo re fariseo, xaa nto yalxwa nu nanlet xaa kwaan wen, nel lee xaa nak kwenta lebadur kwaan nle nyixoob dubse koob. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nel rese kwaan nanyunt, nzho tub mbizh leeya luu, nu rese kwaan nzholaan nzho tub mbizh leeya roo lo xni. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kwaanzee rese kwaan ngunii gu naz lo yalnakaw, gon re xaaya gorna nla xni mbizh; nu rese kwaan ngunii gu xlaan, dublegan yé xaaya yek yoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Nu nal nii na lo re gu, xmig na. Nazhebt gu ne gu xaa nzho mod gut gu nel nyentra mod le xaa stub naz kwaan nawent lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nal seed na gu zee ne gu nen xana xaa nzhaal zheb gu ne gu. Bzheb gu ne gu xaa nzho mod gut kwerp cheen gu, xaa nkano yalgezh chep xaa gu lo ki kwaan tira nanyuyyt. Xaa ne nzhaal zheb gu ne gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Wii, gaay myaa nto xaa chopka rel. Nu wlipa na nii na lo gu, lee Dios nanyanlazht nik tub re ma ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Rese kwaan nak kwent lo Dios, axta re yich yek be nela xaa lak. Kwaanzee nazhebt gu, nel mas nonra gu ke zyen doo myaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Nu wlipa na nii na lo re gu, loka xaa roo xjabor na lo re myet, noka na Xaa Mzhin Ngok Myet, roo na xjabor re xaa ba lo re mandad cheen Dios, ");
INSERT INTO zpoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","per loka xaa yé lo re myet nanakt xaa xaa na, noka na yé lo re mandad cheen Dios nanakt xaa xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Nu chelee tub xaa nge lo na, Xaa Mzhin Ngok Myet, zchee Dios jwalt zee; per chelee tub xaa nge lo Mbi Naban cheen Dios, nacheet Dios jwalt cheen xaa zee. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Nu leezha yilaa xaa gu lo re xaa nabeyy pa nkasa be nseed be xtizh Dios, nu noka yilaa xaa gu lo re xaa nabeyy nu lo re xaa nak zhiin, nalet gu xgab cho kwaan keb gu gorzee, ");
INSERT INTO zpoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","nel lee Mbi Naban né lo gu nen cho kwaan keb gu gorzee. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tub xaa nzo lo re myet nzhé lo Jesús: —Maestr, guzh lo wech na zee zaa xaa rol kwaan nzhap xuz nu ka na. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús mkeb nzhé: —Mig, ¿cho né lo lu lee na nak jwes, xaa ngiiz yizhyo? ");
INSERT INTO zpoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Zee lee Jesús ngwii lo re myet nu nzhé xaa: —List bzo gu nu nazoblazht gu kano gu masra kwaan lo re kwaan nkanola gu; nel nanont re kwaane lo yalnaban. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Noka mzaa Jesús stub kwent nabix lo re xaa nu nzhé xaa: —Ngu tub xaa rik ngok doo xkyalgon xaa, ");
INSERT INTO zpoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","nu nle doo xaa xgab nel pa kochaw xaa re xkyalgon xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nu nzhé xaa: “A, nela na cho kwaan le na nal. Lux na pa ngozhaw na re xob na yilo, nu dexkwaa na stub yoo mas narora ke kwaane. Zee gaaya yizhaw re xkyalgon na nu stub naz re kwaan nkano na.” ");
INSERT INTO zpoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nu le xaa xgab: “Nalsi nkano na zyen doo kwaan, nu zgaaya zyen doo liin. Kwaanzee nix doo nzhak lextoo na; nebse gaa na, nu gaw na, nu goo na.” ");
INSERT INTO zpoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Per lee Dios yé lo xaa: “Xaa ned, leeka nalgwzhe yal na kiib na yalnaban cheen lu, nu lee re kwaan nkano lu, ¿cho lo lakeya?” ");
INSERT INTO zpoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nu snee gak re xaa ntop zyen doo kwaan zee nebse nix doo gak lextoo leeka lee xaa, per naz lo Dios nik tub kwaan nankanot xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús nzhé lo re xaa mseed lo xaa: —Kwaanzee nii na lo re gu: Nalet gu xgab kwaan gaw gu nu kwaan go gu zee ban gu yee, nixa nalet gu xgab xana ler gak gu yee, ");
INSERT INTO zpoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","nel lee yalnaban cheen gu nonra lo kwaan gaw gu nu lo kwaan gak gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Bwii gu lo nga. Nixa nanzhaant ma nu nixa nantopt ma yalgon nu nixa nangochawt ma xkyalgon ma, per lee Xuz be, xaa nzob naz leen yiba, nzaa kwaan nzhaw ma. Nu nonra gu lo re ma ba. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nixa nle doo gu xgab roo gu stub zhit per nyentra mod roo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nu chelee gu nyent mod le gu tub kwaan win kwenta kwaane, ¿chozhiin nle gu xgab stub naz re kwaan? ");
INSERT INTO zpoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Bwii gu lo re yeey, xomod nxeen yeey kwaan nzeb naz wen. Nankeet yeey zhiin nu nixa nangaxkwaat yeey ler. Kwaanzee nii na lo gu, nixa rey Salomón, xaa ngok duzna ler chul, namyunt xab xaa chul kwenta re yeey ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nu chelee Dios chul mle re yeey kwaan nzeb naz wen nalzhe, nu lee yee choog xaaya nu zek xaaya lo ki, telisa sbaaka zaa Dios rese kwaan chul kwaan nkin gu. ¿Chozhiin chepse ngwii gu lo xaa? ");
INSERT INTO zpoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nu sbaa nalet gu xgab, yé gu: “¿Cho kwaan gaw be, nu cho kwaan go be?” Nalet gu xgab re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nel lee re myet yizhyo nkwaan re kwaane, per lee Xuz be nela cho kwaan nkin gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Per yilotlaka kwaan gu zee nabeyy Dios rese kwaan, zee zaa Dios rese kwaane lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Nazhebt gu, xaa nak mod xmbakxiil na, nixa nazyent gu, per lee Xuz be nzhekla zaa pa nabeyy xaa lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bto gu kwaan nkano gu, nu bzaa gu demi lo re xaa nankanota, sbaa nak mod kagozhaw gu xcheen gu leen tub bools kwaan nanluxt, pa nyent mod lewann xaa gu nu pa nyent mod kee mbaza. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nel pa nzho re xcheen gu, baa nzo xgab cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’List bzo gu, nu list gok gu xab gu nu list kee gu yek xbruj gu, ");
INSERT INTO zpoNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","zee gak gu mod tub mos xaa listla nzo gorna lee xpatron xaa mbare ngwa jondang, zee gorna lee xpatron xaa kwezh roo yoo lee xaa listlaka nzo xala. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Chul doo nzhak lextoo re xmos xaa, xaa list nzo gorna lee xpatron xaa yaad. Wlipa na nii na lo gu, lee xpatron xaa yé lo xmos xaa: “Te gaw”. Nu lee xpatron xaa ko kwaan leen yann gaw xmos xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nu chul nzhak lextoo re mos, xaa sbaaka listla nzo xaa gorna lee xpatron xaa yaad, nexa chol nyaad xaa wall yaal o nyaad xaa nzekaxnila yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Per nzhaal la kwaane yek gu: Chelee xaa nak li tub yoo nela cho gor yiid tub wann lewann garli xaa, tubka list nzo xaa, nu nalaat xaa zeeb nik tub xaa leen li xaa, lewann xcheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kwaanzee noka re gu list bzo gu, nel lee na, Xaa Mzhin Ngok Myet, yal mer gor kwaan tira nanlet gu xgab. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Zee lee Pér ngunabdizh nzhé: —Xaa Nabeyy, ¿che ngunii lu wdizh nabix ne nebse lo re nu o noka ngunii luya lo rese xaa? ");
INSERT INTO zpoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Zee lee Xaa Nabeyy nzhé: —¿Cho nak mos wen? Lee mos wen nak xaa mlaa xpatron xaa garli xaa, zee zaa xaa kwaan gaw re stub naz re xmos patron gorna zhin gor gaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Chul doo nzhak lextoo mos, xaa kale kwaan nzhé xpatron xaa lo xaa, gorna lee xpatron xaa bare. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nu wlipa na nii na lo gu, lee xpatron xaa zo xaa ne zee nabeyy xaa lo rese kwaan nzhap xpatron xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per chelee mos zee le xgab: “Nayaadt xpatron na nal”, nu mzelo xaa mdin re xmos xpatron xaa, nu mzelo xaa ndaw xaa nu ngu xaa zee mzuzh xaa, ");
INSERT INTO zpoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nu mbizh kwaan nanlet xaa xgab nu gor kwaan nanlet xaa xgab, lee xpatron xaa bare yaad nu gorna zhin xaa chezi xaa xaa nu chep xaa xaa pa nzho re xaa nangwiit lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Lee mos, xaa nela cho kwaan mlaa xpatron xaa le xaa, nu nanzolist xaa nixa nanzhont xaa diizh, zyen doo yaayed zaa xaa yenn xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Per lee mos, xaa kwaan nanet cho kwaan mlaa xpatron le, nu nle xaa kwaan nawent, mas nazyent yaayed zaa xaa yenn xaa ba. Nu loka xaa mzaa xaa zyen kwaan lo, sbaaka zyen kwaan naab xaa lo xaa ba; nu xaa mkayaa zyen doo kwaan lo xpatron, mas zyenra kwaan naab xpatron xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nu Jesús nzhé: —Lee na nzhalno ki lo yizhyo ne; ¡nu kwaan dub lextoo na nzhekla na maleyy kala bal nal! ");
INSERT INTO zpoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","¡Per nkin deed na bid kwaan nagan doo kwaan nak mod rubnis na, nu dubse nal nyent mod gak wen lextoo na axta yilo deed na kwaane! ");
INSERT INTO zpoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Che nle gu xgab lee na nzhal zee chul doo kwi re xaa lo yizhyo ne? Nanakta sbaa. Lee na nzhal zee gak rol re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nu nalzhe naz delant, leen tub yoo pa nzho tub gaay xaa, chon xaa gak gaya lo chop xaa nu chop xaa gak gaya lo chon xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Zee lee xuz xaa gak gaya lo xgann xaa, nu lee xgann xaa gak gaya lo xuz xaa, nu lee xnaa me gak gaya lo xchap me, nu lee xchap me gak gaya lo xnaa me. Lee xnaaye me gak gaya lo xix me, nu lee xix me gak gaya lo xnaaye me. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús noka nzhé lo re xaa nzhi baa: —Gorna ne gu lee xkaw nze pa naz nyaaz mbizh, mbezh gu: “Zla yey”. Nu sbaa nzhaka. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Gorna ne gu lee mbi nze naz sur, mbezh gu: “La doo neey nal”. Nu sbaa nzhaka. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Gu nak xaa nkade nu nanlet kwaan wen! Chelee gu nlabeyy gu re nseyn yiba nu yizhyo, ¿xomod nanlabeyyt gu re mbizh kwaan nzho be nal? ");
INSERT INTO zpoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Chozhiin nanet gu kwaan gu kwaan wen leeka lo gu? ");
INSERT INTO zpoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chelee tub xaa nayii ne lu nu nzhekla xaa kwezh xaa lu lo xaa nak zhiin, mas wen kwaan mod zee kwi wen rop gu xaa, gorna zeeraka kwezh xaa lu lo xaa nak zhiin, zee napa kazaa xaa nak zhiin lu lo xaa nkanap roo lozhyib, napa kago xaa lu lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Wlipa na nii na lo lu, naroot lu baa chelee lu nakixt lu axta paro nzhaal kix lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tub mbizh ngwa lak xaa lo Jesús nu nzhé xaa: —Lee Pilat mbit lak re xaa yizhyo Galilea, nu mchaal xaa ren cheen xaa kwaan ren cheen re ma kwaan mteed xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús nzhé lo re xaa: —¿Cho kwaan nzak gu? ¿Che nzak gu mas nzebra re xaa ne jwalt ke stub naz re xaa Galilea, zee sbaa mle xaa xaa? ");
INSERT INTO zpoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Lee na nii lo gu, nanakta sbaa; nu chelee re gu nalaat naletra gu kwaan nawent nu wii gu lo Dios, sbaaka noka re gu yet. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nu, ¿cho kwaan nzak gu? Leezha mla yoo ndok tich chiimchon xaa tub pa le Siloé zee ngut re xaa. ¿Che nle re gu xgab nzebra re xaa jwalt ke stub naz re xaa Jerusalén? ");
INSERT INTO zpoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bare na nii na lo gu, nanakta sbaa; nel chelee re gu nalaat gu re kwaan nawent kwaan kale gu nu nawiit gu lo Dios, sbaaka noka re gu yet. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Zee lee Jesús mzaa stub kwent nabix ne lo re xaa nu nzhé xaa: —Tub xaabyi nzo tub xan yag ig leen xleyo xaa pa nzhaan xaa. Nu ngukwaan xaa xle loya, per nyent xle loya. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Zee nzhé xaa lo re xaa nkee zhiin lo xaa: “Wii, nzhala chon liin nzekwaan na ig lo yag ne, per nik tub welt zer yizhal na xle loya. Bchooga nal, zee naleta tras leen xleyo na.” ");
INSERT INTO zpoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Per lee xaa nkee zhiin lo xaa nzhé: “Xaa nabeyy, blaaya stub liin. Nal le nzhul naya nu ko na bon xana, ");
INSERT INTO zpoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","cheleeya zaaya xle stub liin, wena; per cheleeya nazaata xle zee choog naya.” ");
INSERT INTO zpoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jesús kaseed re xaa zhe sab, mbizh kwaan nzholl re xaa Israel lo Dios, pa nkasa re xaa Israel nseed xaa xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nu baa nzo tub ngwnaa, me nzhala chiimchon liin nded me bid lo tub mbi mal kwaan nanlaat nli tich me. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Gorna ngune Jesús lo me, zee mrezh xaa me, zee bii me gax lo xaa nu nzhé xaa lo me: —Ngwnaa, nal gorne lee lu yakwen lo yalyizh cheen lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nu mzhib xaa yaa xaa cho me, nu leeka gorzee lee tich me ta mli nu mzelo me mbill me lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lee xaa nabeyy pa nkasa re xaa nseed xaa xtizh Dios mzhaal xyan, nel ngune xaa lee Jesús msekwen ngwnaa ne zhe sab. Zee nzhé xaa lo re xaa nzhi baa: —Xop mbizh nkee xaa zhiin tub sman, zee yiid gu zee sekwen xaa gu. Per nanzhaalt yiid gu zhe sab, zee sekwen xaa gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Zee lee Jesús nzhé lo xaa nabeyy pa nkasa re xaa: —¡Gu nak xaa nkade nu nanlet gu kwaan wen! ¿Che nanxekt gu xngoon gu nu xburr gu zhe sab, zee yisego gu ma nis? ");
INSERT INTO zpoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nu lee ngwnaa ne, me nak dii cheen Abraham, ¿che nyent mod zhe sab xek be me lo yalyizh kwaan mkado Maxuu me nzhala chiimchon liin? ");
INSERT INTO zpoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Gorna ngulo nzhé Jesús kwaane, rese xaa mnayii ne Jesús mton, per lee re myet nix doo ngok lextoo xaa ngune xaa re kwaan gro kwaan mle Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zee lee Jesús nzhé lo re xaa: —Nal za na stub kwent nabix ne zee ne gu xomod nak pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Leeya nak kwenta tub bizh cheen mostas kwaan mgaan tub xaa xleyo xaa. Mlena nu ngoka tub yag, nu lee re mbyin mdexkwaa xlaaz ma lo re ram cheena. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Noka nzhé Jesús: —Nal lee na za stub kwent nabix lo re gu zee ne gu xomod nak pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Leeya nak mod lebadur kwaan ngo tub ngwnaa leen chon medid arin, zee yixooba. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús mseed re myet xaa nzho re yezh gro nu re yezh win gorna nzhaze xaa nzha xaa naz Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nu lee tub xaa mnabdizh lo xaa nu nzhé: —Xaa Nabeyy, ¿che nazyent xaa le gan yalnaban kwaan tira? Zee lee Jesús nzhé lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Bseyezh gu yek gu zeeb gu pwert nanyag, nel wlipa na nii na lo gu, zyen doo xaa nzhekla zeeb pwert, per nyent mod zeeb xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","’Nu gorna lee xaa nak li yoo, zoli saaw roo yoo, lee re xaa lake naz jwer kwezh roo yoo nu yé xaa: “Xaa Nabeyy, xal roo yoo zeeb nu”. Zee keb Xaa Nabeyy lo xaa: “Nanlabeyyt na gu nu nixa nanet pa naz nze gu”. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Zee lee re gu yé lo xaa: “Re nu ndaw kwaan lu, nu lu nak xaa mseed re sawlazh nu leen naz”. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Per lee xaa né lo gu stuba: “Nanlabeyyt na re gu. Bachii re gu lo na, xaa nzeb jwalt.” ");
INSERT INTO zpoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nu baasi, gonn gu nu kozhe leyy gu gorna ne gu lo Abraham, nu lo Chak, nu lo Kob nu lo rese xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, pa nabeyy Dios, nu lee re gu lakeka naz jwer. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Xaa nzho dubse yizhyo axta paro nzhaal yizhyo kwaan yiba zhin xaa nu gaw xaa pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nu nzho lak xaa kwaan nanont nal gak non zee; nu nzho lak xaa kwaan non nal nagakt non zee. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nu leeka gorzee lee lak fariseo mbii gax lo Jesús nu nzhé xaa lo xaa: —Broo nee, nel lee Herod nzhekla gut lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús mkeb lo xaa nzhé: —Gwa gu nu guzh gu lo Herod, xaa nak mod tub mbaz, ma ngolki: “Nalzhe nu yee koo na mbi mal nu sekwen na re xaa ne nzak, nu wiizh yilo lux na xchinn na”. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nexa xomoda per lee na nzhaal reke na xnaz na nalzhe nu yee nu stub mbizh wiizh. Nel nyent mod yet tub xaa nzaa kwent kwaan né Dios lo lee xaa tub pa nanakt Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Xaa Jerusalén, xaa Jerusalén, gu nzhut re xaa nzaa kwent kwaan nzhé Dios lo lee xaa yilo, nu nzaake gu re xaa mxaal Dios lo gu. Lak welt nzhekla na ngtop na re xinn gu, kwentaxa ntop kolek re xinn kolek xan xiil kolek, per nanzheklat gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wii gu, nik stub kwaan nalaketra leen li gu. Nu wlipa na nii na lo gu, nanetra gu lo na, axta zhin mbizh kwaan yé gu: “¡Gool be lo xaa nze kwaan yalnabeyy cheen Xaa Nabeyy!” ");
INSERT INTO zpoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Zhe sab, Jesús ngwataw garli tub xaa nabeyy lo re fariseo nu lee re xaa nzhi ngwii lo xaa zee nen cho kwaan le xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nzo tub xaa nzeki nii nu yaa lo re xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Zee lee Jesús mnabdizh lo re fariseo nu lo re maestr xaa nlu xtizh Dios, nu nzhé xaa: —¿Cho kwaan nzhé ley? ¿Che wen sekwen xaa tub xaa zhe sab o nawenta? ");
INSERT INTO zpoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per lee re xaa nik tub kwaan namkebt xaa. Zee lee Jesús mgal cho xaabyi ba nu msekwen Jesús xaa, nu mlaa Jesús nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Zeera nzhé Jesús lo re xaa nzhi baa: —Chelee tub gu nkano tub la ngoon o tub burr nu la ma leen tub pos zhe sab, ¿che nakoot gu ma zhe sab? ");
INSERT INTO zpoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nik tub xaa nyent mod nkeb lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Gorna ngune Jesús lee re xaa kakwaan tub pa mas non zob xaa, zee ngunii Jesús stub kwent nabix ne lo re xaa nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Leezha kwezh tub xaa lu yitaw lu lo tub jondang, nakweeyt lu pa mas non zob lu, nel gorna yiid stub xaa nonra ke lu, ");
INSERT INTO zpoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","zee lee xaa mrezh gu bii lo lu, nu né xaa lo lu: “Mig, zaa pa nzob lu zob xaa ne”. Nu kwaan yalnto yixso lu nu nya lu zob lu axta tras. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mas wen leezha kwezh xaa lu yitaw lu lo tub jondang, bzob lu naz tras, nu gorna ne xaa mrezh lu lo lu, zee né xaa lo lu: “Mig, bded zob naz delant”. Zeesi lee lu gak xaa non lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nel lee xaa nto yalxwa, zhin mbizh ton xaa; nu xaa nantot yalxwa, zhin mbizh lee xaa gak non. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nu noka nzhé Jesús lo xaa mle jondang: —Leezha kwezh lu tub xaa gaw garli lu, nakwezht lu re xmig lu, nixa re wech lu, nixa re sawlizh lu, nixa re xaa rik xaa nzho gax garli lu; nel rese xaa ne nzho mod bare xaa kwezh xaa lu gaw lu garli xaa zee kix xaa re kwaan ndaw xaa lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mas wen leezha le lu tub yalni, brezh re xaa prob, re xaa nzhak net nii, re xaa reenk nu re syeg; ");
INSERT INTO zpoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","zee lee Dios le kwaan chul lo lu, nel lee re xaa ne nyent mod kix xaa kwaan ndaw xaa lo lu, per lee mbizh kwaan roban re xaa nali ngok, kayaa lu kwaan chul kwaan mle lu gan. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Lee tub xaa kayaw kwaan Jesús mbin kwaane, nu nzhé xaa lo Jesús: —Wen re xaa nyataw lo yalni cheen pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nu lee Jesús mkeb nzhé: —Za na stub kwent cheen tub xaa mle tub yalni gro doo, nu mrezh xaa zyen doo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nu gorna mzhin gor yo yalni, zee mxaal xaa tub xmos xaa yéya lo re xaa mrezh xaa: “Te gu nal, rese kwaan listla nzhi”. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Per rese xaa nzhé lo xaa nyent moda. Xaa yilotlaka nzhé: “Nal mzi na tub lee leyo nu nkin yasewii na loya; zee yé lu lo xaa le xaa perdon na, nel nyent mod yal na”. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Lee stub xaa nzhé: “Mzi na chii la ngoon; zee yé lu lo xaa le xaa perdon na, nel nyent mod yal na”. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nu lee stub xaa nzhé: “Pensa mchelya na nu nyent mod yal na”. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Lee mos mbare nu nzhé rese kwaane lo xaa nkee xaa zhiin lo. Nu lee xaa mrixyan doo nu nzhé xaa lo xmos xaa: “Gwa leen naz nu roo wri yezh nu yaadno lu re xaa prob, nu re xaa reenk, nu re xaa nzhak net nii, nu re syeg”. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nu lee mos mbare nzhé: “Xaa Nabeyy, mlela na kwaan né lu lo na, per seesa nzhora pa zob xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Zee lee xaa nzhé lo xmos xaa: “Gwa re naz kwaan nzha naz wen, nu ble jwers lo re xaa zee yiid xaa, zee yizhe leen li na. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nel wlipa na nii na lo gu, nik tub re xaa mrezh na yilo, nagawt kwaan mdexkwaa na.” ");
INSERT INTO zpoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nu zyen doo myet nzhake tich Jesús, nu lee Jesús mzere yenn, nzhé lo re xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Chelee tub xaa nzeke tich na, nu nankelat xaa na masra mod nkela xaa xuz xaa, nu xnaa xaa, nu sa xaa, nu xinn xaa, nu wech xaa, nu bzan xaa, nu leeka lee xaa, nyent mod gak xaa tub xaa nreke tich na. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nu loka xaa nanreket tich na nu naweet xaa xkrus xaa, nanzhaalt gak xaa zee xaa nseed lo na. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Chelee tub xaa nzhekla za tub yoo gro, yilotlaka zob xaa le xaa xgab zee nen paro kwaan lux xaa yilo yaaya tira. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nel chelee xaa yilotlaka simyent zob xaa nu gwluzh naletra xaa gan zelo xaaya; zee rese xaa wii loya xizhno xaa xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Zee yé re xaa: “Xaabyi ne mbaxkwe xan yoo nu namlet xaa gan ngulo mza xaaya”. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nu sbaaka, chelee tub rey nzhekla dil kwaan stub rey, yilotlaka zob xaa nu le wen xaa xgab, nen che zle xaa reyez ya xaa kwaan tub chii mil soldad dil xaa kwaan stub rey, xaa nzeno tub gal mil soldad. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nu chelee xaa nzak xaa nyent mod le xaa gan, gorna lee rey zitra nze, zee xaal xaa lak xaa nabdizh lo rey, zee nen xomod kwi wen rop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sbaaka nak re gu, nyent mod gak gu tub xaa reke tich na, chelee gu nalaat gu re kwaan nkano gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Chul zed, per chelee zed nagaknzhigtra zed, nyentra mod le nzhig xaa zed stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nixa kobi xaa zed zee gak zed bon, per nik stub sirb naletra zed. ¡Loka xaa nzob nzha, nzhaal gon kwaane! ");
INSERT INTO zpoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mzhin re xaa ntop demi kwaan nya naz Roma nu stub naz re xaa nzeb jwalt mbii lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Per lee re xaa fariseo nu re maestr xaa nlu xtizh Dios, nxizhno xaa Jesús nu mbezh re xaa: —¡Xaa ne nkayaa re xaa nzeb jwalt nu noka nzhaw xaa kwaan re xaa nzeb jwalt! ");
INSERT INTO zpoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Zee nzhé Jesús kwent nabix ne lo re xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Cho kwaan nzak gu? Tub xaa nkano tub gayoo mbakxiil nu mzowen xaa tub ma. Telisa laa xaa stub tapgal nzho chiibyee ma, zee yikwaan xaa ma mzowen axta yizhal ma lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nu gorna nguzhal ma lo xaa, nix doo nzhak lextoo xaa zee mzhiib xaa ma yenn xaa, ");
INSERT INTO zpoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","nu nya xaa garli xaa zee top xaa re xmig xaa nu re xaa nzho gax garli xaa nu yé xaa lo re xaa: “Nix doo nzhak lextoo na kwaanzee noka byakla gu, nel nguzhal xmbakxiil na, ma mzowen”. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nu wlipa na nii na lo re gu. Mas chul nzhak lextoo re xaa yiba, leezha lee tub xaa nzeb jwalt laa jwalt cheen xaa nu wii xaa lo Dios, ke wii xaa lo tapgal nzho chiibyee xaa wen, xaa nakint bare lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Noka mzaa xaa stub kwent nabix lo re xaa nu nzhé xaa: —Ngu tub ngwnaa nkano tub chii demi plat nu mzowen me tuba. Telisa mkee me xni, nu mloob me leen li me zee kwaan meya, axta ke nguzhala lo me. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nu gorna nguzhala lo me, zee mrezh me re xmig me nu re me nzho gax garli me nu nzhé me lo re me: “Nix doo nzhak lextoo na kwaanzee noka byakla gu, nel nguzhal na demi plat cheen na kwaan mzowen”. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nu nii na lo re gu: Sbaaka nix doo nzhak lextoo re mandad cheen Dios, leezha lee tub xaa nzeb jwalt laa jwalt cheen xaa nu wii xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Noka mzaa xaa stub kwent nabix lo re xaa nu nzhé xaa: —Ngu tub xaabyi xaa nkano chop xgann. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nu lee xaa mas winra nzhé lo xuz: “Pa, zaa re kwaan yizo na lo na nal”. Zee lee xuz xaa mdiiz re kwaan lo rop xgann xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nu leezha ngulo mdiiz xaa re kwaan lo xaa, lee xinn xaa, xaa winra, mto rese kwaan mzaa xuz xaa lo xaa, nu mroo xaa nzha xaa tub yezh zit lazh xaa. Baa mlux xaa rese xdemi kwaan nzhano xaa lo re kwaan tira nawent lo yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nu leezha ngulo mlux xaa rese xdemi xaa kwaan nzhano xaa, nu mer liin zee mla doo win yezh ba zee ngok nlaan xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Zee ngunaab xaa zhiin lo tub xaa yezh ba kee xaa. Nu lee zhiin kwaan nkee xaa nak nzaa xaa kwaan nzhaw kuch. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nu ngok nlaan doo xaa, axta nzhekla xaa gaw xaa bad kwaan nzhaw kuch, nu nyent cho zaaya gaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Nu gorna mzeen xaa kwaan kaded xaa, mle xaa xgab nu nzhé xaa: “Lakta mos xaa nkee zhiin garli xuz na, nkano xaa kwaan nzhaw xaa nu chelee xaa nzhekla xaa gawra xaaya nzhoraya. Nu lee na mer yet na lo yalnlaan ne.” ");
INSERT INTO zpoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nal mas wen bare na garli xuz na nu yé na lo xuz na: “Pa, mle na jwalt lo Dios nu lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nanzhaaltra le lu na xinn lu, sinka ble na mod tub mos cheen lu.” ");
INSERT INTO zpoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Nu nguxso xaa nu nya xaa lo xuz xaa nu gorna zitra nyaad xaa garli xuz xaa, lee xuz xaa ngune lo xaa lee xaa nyaad, zee mlesdoo lextoo xuz xaa ngune xaa lo xaa. Nu mdexonn xuz xaa xaa nu ndaw xaa bit tagarlo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nu lee xgann xaa nzhé lo xaa: “Pa, mle na jwalt lo Dios nu lo lu, nanzhaaltra le lu na mod xinn lu”. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per lee xuz xaa nzhé lo re xmos xaa: “Le gu prad, kwaan gu ler kwaan mas wen segak gu xaa, nu bloo gu tub ani kwen yaa xaa nu bkee gu tub naz yelyed nii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nu kwaan gu beser ma mas nachaa doo nu bit gu ma gaw re be, zee le be yalni nu yakdoola be. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nel lee xgaan na xaa mluxla nu xaa mzowen, mroban stub welt.” Nu mzelo xaa mle xaa yalni. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Nu lee xgann xaa, xaa yilo, nzo naz wen, nu gorna nyaad xaa ngwa xaa wen nyaadzhin gax xaa garli xaa, nu mbin xaa nkee bi cheen musk zee ngune xaa kakanii re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Zee mrezh xaa tub xmos xuz xaa zee ngunabdizh xaa lo xaa nen cho kwaan nzho re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Zee lee mos nzhé lo xaa: “Lee wech lu mbare nu lee xuz lu mbit beser, ma nachaa doo, nel wen mbare wech lu nyaad garli lu stub welt”. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","’Per lee wech xaa xaa yilo mrixyan doo xaa nu nanzheklat xaa zeeb xaa leen yoo. Zee lee xuz xaa mroo ngunaab jabor lo xaa zee zeeb xaa leen yoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Zee nzhé xaa lo xuz xaa: “Zyen doo liin nzha nkee na zhiin lo lu, nu tubka nzhon na xtizh lu, nu nik tub chib dik zer zaa lu lo na, le na tub yalni kwaan re xmig na. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Per lee nal mzhin xgann lu, xaa bduun, xaa mlux rese xdemi lu lo re ngwnaa me nto cho, nu nal mbit lu beser, ma nachaa doo.” ");
INSERT INTO zpoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Zee lee xuz xaa nzhé lo xaa: “Xgann, lu tubka nzo lo na, nu rese kwaan nkano na nak xcheen lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per lee nal nzhaal le be yalni nu yakla be, nel lee wech lu, xaa mluxla nu xaa mzowen mroban stub welt.” ");
INSERT INTO zpoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Zee lee Jesús nzhé lo re xaa mseed lo xaa: —Ngu tub xaa rik, xaa mzaa li nkanap tub xmos. Per stub xaa nzhé lo xaa rik: “Xmos lu, xaa nkano li lu, kalux re xcheen lu”. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nu lee xaa rik mxaal xaa ngwaxii xmos xaa, nu nzhé xaa lo xmos xaa: “Mbin na tub kwent cheen lu. Néya lo na. ¿Cho kwaan kale lu kwaan re xcheen na? Nal nyentra mod kano lu re xcheen na.” ");
INSERT INTO zpoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Zee lee xmos xaa mle xgab leen lextoo xaa: “¿Cho kwaan le na nal, lee xpatron na chexonn na? Nayetra na gaan na nu nton na naab na karda. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, nela na cho kwaan le na zee zaa re xaa kwaan gaw na gorna nankanotra na zhiin ne.” ");
INSERT INTO zpoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nu zee mxaal xaa xaa ngwachezh re xaa nzeb lo xpatron xaa nu mnabdizh xaa lo xaa yilotlaka mzhin nu nzhé xaa: “¿Lak nzeb lu lo xpatron na?” ");
INSERT INTO zpoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Lee xaa ne nzhé: “Tub gayoo barril anseyt”. Zee nzhé xaa lo xaa: “Nee, bzen resib cheen lu, nu bkee loya, leeya nak choobchiika barril anseyt”. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Zeera mnabdizh xaa lo stub xaa nu nzhé xaa: “¿Lak nzeb lu?” Xaa ne mkeb nzhé: “Tub gayoo sak nzhobxtil”. Zee lee xaa nzhé lo xaa: “Bzen resib cheen lu nu bkee loya leeya nak tapgalka sak nzhobxtil”. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Gorna lee xaa rik ngune kwaane, nzhé xaa: “Nzho doo yek xaa, zee ne xomod chul ded xaa gwluzh”. Nel lee re myet yizhyo mas nzho yek lo re kwaan yizhyo ke re xaa nzo lo xni. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Zee nzhé Jesús: —Na nii lo gu, zaa gu demi kwaan nkano gu yizhyo ne, zee gak re xaa xmig gu. Zee gorna lee re kwaan yizhyo ne lux, zee lee re xmig gu kayaa gu leen tub yoo kwaan tira naluxt. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nu loka xaa wen nkano chepse kwaan, sbaaka wen kano xaa zyen kwaan; nu loka xaa nawent nkano chepse kwaan, sbaaka nawent nkano xaa zyen kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nu chelee gu nagakt gu kano wen gu demi yizhyo ne, nyent mod nkano gu kwaan nak kwaan wlipa naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nu chelee gu nagakt gu kano wen gu xcheen stub xaa, nyent mod zaa xaa lo gu kwaan nak xcheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nik tub mos nyent mod kano chop patron xaa kee xaa zhiin lo, nel tub xaa yii ne xaa lee stub xaa kela xaa, nel tub xaa gon xaa xtizh, lee stub xaa nagont xaa xtizh. Nyent mod kee gu zhiin lo Dios nu kee gu zhiin kwaan gu demi yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Zee lee re xaa fariseo mbin re kwaane zee mxizhno xaa Jesús nel nkedoola re xaa demi. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Zee lee Jesús nzhé lo re xaa: —Gu nak xaa nlu wen lo re myet, per lee Dios nlabeyy xgab cheen re gu; nel re kwaan nzak re myet non doo, lee lo Dios nik tik nanonta. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Axta leezha myaad Juan, re gu nkanola re kwaan nkee lo ley cheen Dios nu re kwaan ngunii re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. Axta zee nu axta nal seetaka kazaa re xaa kwent cheen wdizh chul cheen pa nabeyy Dios, nu nzaa re xaa jwers zee rep re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nu mas nanagant lux yizhyo nu yiba ke lux tik ley cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Loka xaa laa xngwnaa nu ka xaa stub ngwnaa, kale xaa jwalt lo Dios; nu loka xaa ka tub ngwnaa, me mlaa xmbyi me, noka xaa ne kale jwalt lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús mzaa stub kwent nu nzhé xaa: —Ngu tub xaa rik, xaa nzhak duzna ler kwaan mas wen nu rese mbizh nle xaa yalni nu nzhaw xaa duzna re kwaan wen. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nu noka ngu tub xaa prob, xaa le Lach. Xaa ne nak tub xaa mzhaal yeezh kwaan nyall cho nu nzob xaa gax roo pwert cheen xaa rik naab xaa karda. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nu nzoblazh xaa gaw xaa re kwaan byog kwaan nzhab lo mes cheen xaa rik. Nu lee re mbak mbii gax lo Lach nu ntale ma lo yeezh kwaan nzeb cho xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nu mzhin tub mbizh ngut Lach nu zee mbe re mandad cheen Dios xaa pa nzho Abraham. Noka mzhin stub mbizh ngut rik nu msebyo xaa rik. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Nu lee rik kaded doo bid leen Hades pa nzho re xaa ngut, nu ta mlep xaa yek xaa zee mlu Abraham lo xaa zit doo; nu noka mlu Lach lo xaa nzo xkwes Abraham. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Zee dub gan mrazhe rik nu nzhé rik: “Xuz na Abraham, blesla lu ne lu na. Bxaal Lach zee le bsii xaa yek kwen yaa xaa kwaan nis zee teeb xaaya lo luzh na, nel bid doo kadeed na lo ki nee.” ");
INSERT INTO zpoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nu lee Abraham nzhé lo rik: “Xgann, bselazh lu leezha dubse leezha mban lu, mkano lu zyen doo kwaan wen nu lee Lach mkano duzna kwaan nawent. Per nal lee xaa nak xaa nix doo nzhak lextoo nzo nee, nu lee lu kaded doo bid naz baa. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nu nel nyent moda nel nzho tub barank xsaww lo re nu nu lo re gu, zee nik tub xaa nzho nee nyent mod ya baa, nixa nzhekla xaa ya xaa nyent moda; nu nik tub xaa nzho baa nyent mod yaad nee, nixa nzhekla doo xaa yaad xaa nee.” ");
INSERT INTO zpoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Zee lee rik mkeb nu nzhé: “Xuz na Abraham, naab na tub jabor lo lu, xaal Lach garli xuz na, ");
INSERT INTO zpoNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nel nkano na tub gaay wech na, xaa nzho baa, zee nii xaa lo re xaa zee nayat xaa nee pa nzhoo na, nel bid doo kadeed na nee”. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Per Abraham mkeb lo xaa nu nzhé xaa: “Nkanola re xaa kwaan mkee Ches, nu kwaan mkee re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo; laa gon xaa xtizh re xaa ne”. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nu lee rik mbare nzhé: “Xuz na Abraham, nagont xaaya, per chelee tub xaa ngut roban nu lu xaa lo re xaa, telisa laa xaa naletra xaa kwaan nawent nu wii xaa lo Dios”. ");
INSERT INTO zpoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Per lee Abraham nzhé lo xaa: “Chelee xaa nagont xtizh Ches nu xtizh re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, telisa nalaat xaa re kwaan nawent kwaan kale xaa nixa chelee tub xaa roban lo re xaa ngut nu yazaa kwent xtizh Dios lo xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús nzhé lo re xaa mseed lo xaa: —Telisa yo xaa kiil gu le gu jwalt lo Dios, per bid ded doo xaa kiil sa myet nu nle zee ralnii sa myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas wen kee xaa tub ke gro doo yenn xaa nu gobi xaa xaa leen nistoo, ke le xaa zee tub re xaa chut ne le jwalt. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kwaanzee ¡list gok gu! Chelee tub wech lu le tub jwalt lo lu, bgalno lu xaa nu chelee xaa laa xaa kwaan nawent kwaan mle xaa lu, byenlazh kwaan mle xaa lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nu chelee xaa mle xaa jwalt lo lu gazh welt tub mbizh, nu gazh welt bare xaa lo lu nu né xaa lo lu: “Yenlazh kwaan mle na lo lu”, zee nzhaal yenlazh lu kwaan mle xaa lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Lee re xaa mseed lo Jesús nzhé lo xaa: —Ble zee mas wii nu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Zee lee Xaa Nabeyy nzhé lo re xaa: —Chelee gu ngwii gu lo Dios, lalsa paro na tub bizh dik cheen mostas, nzho mod yé gu lo yag ne: “Bachii nee nu bzo axta leen nistoo”, nu leeya gon xtizh gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Chelee tub gu nkano tub mos xaa nkee goon o xaa nkano xma gu naz wen, gorna mbare xaa nya xaa wen, at nambezht gu lo xaa: “Bded zee gaw lu”; ");
INSERT INTO zpoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","sinka mbezh gu lo xaa: “Bdexkwaa kwaan gaw xchee na nu list bzo koo lu kwaan leen xkyann na gorna lee na kayaw nu kayoo. Nu gorna yilo gaw na zeesi nzho mod gaw lu nu go lu.” ");
INSERT INTO zpoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","At nixa dixkix nanzaat gu lo xmos gu, xaa mle xchiin gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nu leeka snee re gu, gorna yilo le gu re kwaan mnabeyy xaa gu, guzh gu: “Nak re be tub mos xaa nanont, nel nebse kwaan nzhaal le be, mle be”. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Gorna lee Jesús nzha naz yezh Jerusalén, mded xaa roo wri yizhyo cheen Samaria nu cheen Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nu gorna mzhin xaa tub yezh, zee mbii chii xaa nzak yalyizh kwaan nyall cho lo Jesús. Nu zit mzo re xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nu dublegan nzhé xaa: —¡Maestr! ¡Jesús! ¡Blesla lu ne lu re nu! ");
INSERT INTO zpoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Gorna ngune Jesús lo re xaa zee nzhé Jesús lo re xaa: —Gwa gu nu blu gu gu lo re ngwleyy, lee gu ngokwenla. Nu gorna nzhaze re xaa naz, lee yalyizh kwaan nzak xaa ngokwen. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Zee lee tub xaa mbare, gorna mzeen xaa lee xaa ngokwen, nu dublegan nzholl xaa lo Dios, ");
INSERT INTO zpoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","nu mkichxub xaa nu mkichyek xaa lo Jesús, nu nzhé xaa: —Dixkix lu. Nu xaa ne nak tub xaa Samaria. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Zee lee Jesús nzhé: —Ngu chii xaa msekwen na per tubka xaa stub yizhyo mbare mzaa dixkix lo Dios. ¿Per ma stub yee xaa msekwen na? ");
INSERT INTO zpoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Zeera nzhé Jesús lo xaa: —Guxso nu zyaa. Nel mwii lu lo Dios zee ngokwen lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Zee lee re xaa fariseo mnabdizh lo Jesús nu nzhé xaa: —¿Pok zhin yalnabeyy cheen Dios? Jesús nzhé lo xaa: —Gorna zhin yalnabeyy cheen Dios, naluta. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nayét xaa: “¡Wii gu, leeya nzo nee!” o “¡Leeya nzo baa!” Nel lee mbizh kwaan nabeyy Dios mzhin gaxla lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Zee nzhé Jesús lo re xaa mseed lo xaa: —Zhin tub mbizh leezha zoblazh gu ne gu mbizh kwaan nabeey na, Xaa Mzhin Ngok Myet, nu nanet guya. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lak xaa yé: “Lee xaa nzo nee, lee xaa nzo baa”, nayat gu baa nixa nareket gu tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gorna bare na, Xaa Mzhin Ngok Myet, gaka mod la tub balngwzi; lee xni cheena la dubse yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per yilotlaka nkin ded doo na bid, nu lee re myet xaa nzhi re mbizh ne, nakayaat xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kwentaxa ngok re mbizh cheen Noé, sbaaka gak gorna bare na. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Re mbizh cheen Noé, gorna zeeraka la yey lux re kwaan nu zeeraka zeeb Noé leen bark, lee re myet seetaka nzhaw nu nzho nu nchelya. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nu leeka snee ngok re mbizh cheen Lot, lee re myet nzhaw nu nzho, nzi xaa nu nto xaa, nzhaan xaa nu nza xaa yoo. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per lee mbizh leezha mroo Lot yezh Sodoma, mroo ki nu azufre naz leen yiba nu mod yey mlaya leen yezh, nu mluxa dubse Sodoma. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Sbaaka gak mbizh leezha yal na. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lee mbizh zee, lee xaa nzob yek yoo, nakoot xaa re xcheen xaa kwaan nzho leen yoo, nu lee xaa nzha naz wen, nabaretra xaa garli xaa yaadxii xaa xcheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¡Bselazh gu cho kwaan ngok kwaan sa Lot! ");
INSERT INTO zpoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Xaa kwaan tira nanzheklat yet lo yizhyo ne telisa yet xaa, per lee xaa kwaan tira nanzhebt yet lo yizhyo ne, xaa ba le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nu wlipa na nii na lo gu, yaal zee chop xaa naxna lo tub loon, tub xaa wee xaa nu stub xaa lake xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chop ngwnaa tubka nkayoo; tub me wee xaa stub me lakeka xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chop xaabyi tubka nkee zhiin naz wen; tub xaa wee xaa nu stub xaa lakeka xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Zee mnabdizh xaa lo Jesús: —¿Pa ded re kwaane, Xaa Nabeyy? Nu lee Jesús nzhé: —Pa nax tub ma ngut, baa ndop re ngolbech. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Noka Jesús mzaa tub kwent nabix lo re xaa, zee ne re xaa tubka nkin wdizhno xaa Dios nu nalaat xaa nalet xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jesús nzhé: —Tub welt ngu tub jwes tub yezh, xaa nanzhebt ne Dios nixa nanzhont xtizh re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nu leeka yezh ba ngu tub byud, me tubka nya lo jwes nu mbezh me lo xaa: “¡Le yudar na lo xaa nayii ne na!” ");
INSERT INTO zpoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nu zyen doo welt nzhiya me lo jwes nu nanzhont xaa xtizh me. Nu mzhin tub mbizh kwaan mle xaa xgab nu nzhé xaa: “Nanzhebt na ne na Dios nixa nanzhont na xtizh re myet, ");
INSERT INTO zpoNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","per nal le na yudar ngwnaa byud ne, nel tant tubka nzeke me rezh yek na nel napa zhin tub mbizh yiche lextoo na ne na me”. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Zee nzhé Xaa Nabeyy: —Bkenzha gu kwaan nzhé jwes, xaa nanaabt kwent nali. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¡Telisa nela be lee Dios gon xtizh re xaa mleey xaa, xaa nzhedizhno xaa zhe nu yaal! ¿Che sbaaka gak Dios tras? ");
INSERT INTO zpoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wlipa na nii na lo gu, telisa zle xaa yudar gu gorna naab guya lo xaa; per gorna yal na, Xaa Mzhin Ngok Myet, ¿che zyizhal na xaa ngwii lo na lo yizhyo ne? ");
INSERT INTO zpoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Zee lee Jesús mzaa stub kwent nabix lo stub naz myet xaa nzak nali nak, xaa nzak tira nanont stub naz re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Nu Jesús nzhé: —Tub welt nzha chop xaa nzhawdizhno Dios lach roo yidoo. Tub xaa nak fariseo, lee stub xaa nak xaa ntop demi kwaan nya naz Roma. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Lee fariseo mzoli techosa nu snee ngunii xaa lo Dios: “Dios, dixkix lu, nel nanakt na kwenta stub naz re myet ne. Nanakt na wann, xaa wen nak na, nu nankanot na stub naz re ngwnaa ba, nu nixa nanakt na kwenta xaa ne, xaa ntop demi kwaan nya naz Roma. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nu nii na lo lu: Chop welt nkwan na tub sman gorna nanzhawt na nik tik kwaan, nu nza na tub chii part rese kwaan nle na gan lo lu.” ");
INSERT INTO zpoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Per lee xaa ntop demi kwaan nya naz Roma zit mzo; nu nixa namlept xaa lo xaa naz yiba, sinka nebse ngazya xaa laz xaa nu nzhé xaa: “Dios, blesla lu ne lu na, nel na nak tub xaa nzeeb doo jwalt”. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Lee na nii lo gu, mbare xaabyi ne garli xaa nu mchela Dios re jwalt cheen xaa. Lee stub xaa namchet Dios re jwalt cheen. Nel lee re xaa nto yalxwa, zhin mbizh ton xaa; nu lee re xaa nantot yalxwa, zhin mbizh gak non xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lee re myet nzhe re madwin lo Jesús nu noka nzhe xaa axta re madoo, zee zhiib Jesús yaa Jesús yek re mad win. Nu gorna ngune re xaa mseed lo Jesús lee re xaa tant nzhano mad lo Jesús, zee mgalno xaa re xaa nyaadno mad win. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús mrezh re xaa mseed lo xaa nu nzhé Jesús lo re xaa: —Laa gu yiid re madwin lo na, nu nasaawt gu lo mad zee nayiidt mad lo na. Nel Dios nabeyy leen lextoo re xaa nak kwenta re madwin ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Wlipa na nii na lo gu, loka cho gu nakayaat pa nabeyy Dios, mod tub madwin, nyent mod zeeb gu pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tub xaa non ngwa mnabdizh lo Jesús: —Maestr wen, ¿cho kwaan le na, zee le na gan yalnaban kwaan tira? ");
INSERT INTO zpoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús nzhé lo xaa: —¿Chozhiin né lu lo na, na nak tub xaa wen? Nik tub xaa wen nyent, nebse Dios nak xaa wen. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nela lu re kwaan mlaa Dios le be. Re kwaane: nazoblazht lu kano lu stub ngwnaa, naguta lu sa myet lu, nalewannt lu, nagaazht lu tub kwaan nawlit tich sa myet lu, nu nazeret lu diizh lo xuz lu nu lo xnaa lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Lee xaa non nzhé: —Rese kwaane kale na dubse nzexen na. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Gorna mbin Jesús kwaane, zee nzhé Jesús lo xaa: —Tubka kwaan nzho jwalt le lu. Zyaa, nu bto rese kwaan nkano lu nu bzaaya lo re xaa prob, zee gap lu zyen doo kwaan naz leen yiba, nu breke tich na. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Gorna lee xaa non mbin kwaane, nales doo ngok lextoo xaa, nel rik doo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús mwii lo xaa nu nzhé xaa: —¡Nagan doo zeeb tub xaa rik naz leen yiba, pa nabeyy Dios! ");
INSERT INTO zpoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas nanagant zeeb tub kamey leen yeer cheen tub aguj, ke tub xaa rik le gan nya yiba. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nu gorna mbin re xaa kwaane, nzhé re xaa: —¿Cho le gan nya yiba chol sbaa naka? ");
INSERT INTO zpoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús nzhé: —Lo re myet yizhyo ne nyent moda, per Dios reseya nzho mod le Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Zee nzhé Pér: —Lee rese nu, rese kwaan mlaa nu, nu mreke nu tich lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús nzhé lo xaa: —Na nii lo re gu, loka cho xaa laa li, laa sa, laa wech, laa xuz nu xnaa, laa xinn kwent cheen pa nabeyy Dios, ");
INSERT INTO zpoNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","zee zyen welt bareya lo xaa nu zhin mbizh kayaa xaa yalnaban kwaan tira leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nu zeera mbe Jesús techosa re chiibchop xaa mseed lo Jesús tub lad nu nzhé Jesús lo re xaa: —Bkenzha gu nal. Nal ya be Jerusalén, nu baa gak rese kwaan nzhé re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, kwent cheen Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Zaa xaa na lo re xaa nanakt xaa Israel, nu xizhno re xaa na; nu koo xaa xkyalnto na, nu chuk re xaa lo na. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nu gorna yilo zaa re xaaya yenn na kwaan tub le yed, zeera gut re xaa na; per lee mbizh yon lee na roban stuba. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Namlat xtizh Jesús yek re xaa mseed lo xaa; nanet re xaa cho kwaan mzaa Jesús kwent, nel mkaxlaan Dios diizh ne lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nu gorna nzhazhin Jesús gax yezh Jericó, ngune xaa lo tub xaabyi syeg nzob roo naz naab karda. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Lee syeg mbin nkee doo rezh, nel zyen doo xaa nzhake tich Jesús, kwaanzee ngunabdizh xaa lo re xaa nu nzhé xaa: —¿Cho kwaan kayak? ");
INSERT INTO zpoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Zee nzhé re myet lo syeg: —Jesús xaa Nazaret nzhaded nee. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Zee lee syeg dub gan mrazhe nzhé: —¡Jesús, lu nak xaa dii cheen rey David, blesla lu ne lu na! ");
INSERT INTO zpoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Zee lee re myet mgalno xaa nu nzhé xaa lo xaa: —¡Saaw roo lu! ¿Cho bi nkee lu? Per lee xaa mas nyera mrazhe xaa nu nzhé xaa: —¡Jesús, lu nak xaa dii cheen rey David, blesla lu ne lu na! ");
INSERT INTO zpoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Zee mlaz Jesús nu nzhé Jesús: —Teno gu xaa nee. Gorna mzhin xaa zee mnabdizh Jesús lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Guné, nen cho kwaan nzhekla lu le na lo lu. Lee xaa mkeb nzhé: —Xaa Nabeyy, nzhekla na wii na. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús nzhé lo xaa: —Nzho mod yani garlo lu, nel kwaan dub lextoo lu ngwii lu lo na, zee gakwen zaalo lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nu leeka gorzee lee syeg nguni zaalo nu mreke xaa tich Jesús nu mbill xaa lo Dios. Nu gorna lee re xaa yezh ngune kwaan ngok, noka re xaa mzelo mbill lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús nzha mzeeb yezh Jericó. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Baa nzho tub xaa rik doo, xaa le Zaqueo, xaa ne nak xaa nabeyy lo re xaa ntop demi kwaan nya naz Roma. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zaqueo nzhekla ne lo Jesús; per nyent mod lu Jesús lo xaa, nel zyen doo myet nzhi, nu nel chut doo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Zee mrexonn xaa nguner xaa naz delant nu nguxoob xaa lo tub yag kwaan le sicómoro, zee wii xaa lo Jesús gorna ded xaa xan yag ba. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Gorna mzhin Jesús baa, nu mwii xaa naz lo yag zee nzhé xaa lo Zaqueo: —Zaqueo, bla baa, nel garli lu kwaz na nalzhe. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nu gorzee lejer doo mla xaa, nu nyakdoola xaa mbin xaa lee Jesús kwaz garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Gorna ngune re myet kwaane, mzelo re xaa mkediizh xaaya nu nzhé re xaa: —Lee Jesús nya kwaan tub xaa nzeeb doo jwalt. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo mzoli nu nzhé xaa: —Wii Xaa Nabeyy, rol re kwaan nkano na za na lo re xaa prob; nu chelee na mlewann na xcheen stub xaa, tap tant kwaan mkiib na lo xaa zere na lo xaa nal. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús nzhé lo re xaa: —Nalzhe lee yalnaban kwaan tira mzhin lo re xaa nzho yoo ne, nel noka lee xaa nak dii cheen Abraham. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nel na, Xaa Mzhin Ngok Myet, nzekwaan re xaa mzowen zee za na yalnaban lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Gorna mbin xaa re kwaane, Jesús mzaa tub kwent nabix ne lo re xaa, gorna nzhazhin gaxla xaa Jerusalén, nel lee re xaa nle xgab merla nabeyy Dios lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Zee nzhé Jesús lo re myet: —Ngu tub xaa non doo, nu mroo xaa nzha xaa zit doo, pa gak xaa tub rey xaa nabeyy, nu zeera bare xaa garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Gorna zeeraka roo xaa, mrezh xaa tub chii xmos xaa, nu mzaa xaa tubga demi or lo re xaa nu nzhé xaa: “Bkano gu demi ne zhiin axta gorna bare na”. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Per re xaa nabeyy xaa lo nayii ne xaa, nu mxaal re xaa lak xaa nzha yéya lo rey: “Nanzheklat nu gak xaa ne rey cheen nu”. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Per gorna ngok xaa rey zee mbare xaa nabeyy xaa xkyizhyo xaa. Zee mrezh xaa re xmos xaa, xaa mzaa xaa demi lo, nel nzhekla xaa ne xomod mkano xaaya zhiin. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Xaa yanertlaka mzhin lo xaa nzhé: “Xaa nabeyy, demi or kwaan mzaa lu lo na nee, mle na gan stub chii demi or”. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Lee xaa nabeyy nzhé lo xaa: “Xmos na, wen doo mkee lu zhiin nu nali doo mle luya. Nali doo ngok lu lo chepse kwaan mza na lo lu, nu lee nal za na chii yezh nabeyy lu.” ");
INSERT INTO zpoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Lee stub xmos xaa mzhin lo xaa nu nzhé: “Xaa nabeyy, kwaan demi or kwaan mzaa lu lo na, mle na gan stub gaay demi or”. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nu nzhé xaa lo xaa: “Nal nza na gaay yezh nabeyy lu”. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Lee stub mos mzhin nu nzhé: “Xaa nabeyy, lee xdemi lu kwaan mzaa lu lo na, leeya nee. Mlozhaw naya lo tub panit. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Xaa nabeyy na, ne na lee lu nak tub xaa nakap doo, nu nzhaan lu pa nanakt xleyo lu nu ntop lu yalgon pa nankeet lu goon.” ");
INSERT INTO zpoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Lee rey nzhé lo xaa: “Leeka kwaan xtizh lu kwaan ngunii lu lo na, naab na kwent lo lu; lu nak tub xaa mal. Néla lu lee na nzhaan pa nanakt xleyo na nu ntop na yalgon pa naket na goon. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Chozhiin nangoot lu xdemi na bank? Zee gorna ngbare na, ngzaa lu xdemi na kwaan mza na lo lu, nu ngzaa lu xinna kwaan mleya gan lo na.” ");
INSERT INTO zpoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Zee lee xaa nabeyy nzhé lo re xaa nzhi lo xaa: “Bkiib gu demi or lo xaa ne nu bzaa guya lo xaa nkano chii demi or”. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nu lee re xaa nzhé lo xaa: “Xaa nabeyy, nkanola xaa chii demi or”. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Per lee xaa nabeyy mkeb nzhé: “Lee na nii lo gu: Nel xaa nkanoya zaa xaa masraya lo xaa, nu axta nzhobre zaa xaaya lo xaa. Per lee xaa kwaan nankanota axta chep kwaan nkano xaa yiib lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Teno gu re xaa nanzheklat gak na rey lo, nu bit gu xaa lo na nee.” ");
INSERT INTO zpoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Gorna ngulo mzaa xaa kwent ne, zee nzha xaa naz Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Gorna lee Jesús nzhazhin gax rop yezh kwaan le Betfagé nu Betania, gax yi le Olib, mxaal xaa chop xaa mseed lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nu nzhé xaa lo rop xaa: —Gwa gu yezh kwaan nzhi gax nee, nu baa yizhal tub burr ma nkadoo lo gu, ma nik tub xaa zer zob tich. Xek gu ma nu yaadno gu ma nee. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Chelee nzho cho nabdizh lo gu nu né xaa lo gu: “¿Chozhiin kaxek gu burr ba?” yé gu lo xaa: “Xaa Nabeyy nkin ma, nu zeera bare nu yiidlaa nu ma”. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Lee rop xaa kwaan mxaal Jesús nzha, nu nguzhal xaa burr kwentaxa nzhé Jesús lo rop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Gorna lee xaa kaxek ma, lee bixwann burr mnabdizh lo xaa: —¿Chozhiin kaxek gu xburr na? ");
INSERT INTO zpoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Lee rop xaa mkeb nzhé: —Nel Xaa Nabeyy nkin ma. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Zee mbe xaa ma lo Jesús. Nu mzhib xaa xab xaa tich ma, zee mzob Jesús tich ma. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nu gorna nzhaded Jesús lee re myet mbek xab leen naz. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nu gorna nzhakato xaa xan yi Olib, lee re myet kwaan nzhake tich xaa mzelo mbill dublegan lo Dios nu mzaa re xaa dixkix lo Dios kwent cheen rese kwaan gro doo kwaan ngune xaa mle Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nu mbezh re xaa: —¡Goll be lo xaa nze kwaan yalnabeyy cheen Xaa Nabeyy! ¡Wen kwi re xaa leen yiba nu gool re be lo xaa nzob naz yiba! ");
INSERT INTO zpoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Lee lak fariseo nzo lo re myet nzhé lo Jesús: —Maestr, bgalno re xaa nzeke tich lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Per lee Jesús nzhé lo xaa: —Lee na nii lo gu, chelee re xaa ne saaw roo lee re ke wdizh. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Leezha mzhin Jesús gaxla Jerusalén, mbinn xaa gorna mlu yezh lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nu nzhé xaa: —¡Oj chol ne re gu xaa Jerusalén, nalzhe nzho mod kwi wen gu, per lee nal mkaxlaan Dios re kwaane lo re gu! ");
INSERT INTO zpoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mzhin gaxla re mbizh lee re xaa nayii ne lu dil kwaan lu, nu dub welt lo lu kwi re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Telisa lux xaa lu kwaan re xinn lu, nu nik stub ke nalaketra tich sa ke ke, nel nangunet lu mbizh kwaan mbiid Dios lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús mzeeb lach roo yidoo, nu mloo xaa re xaa nzi nu re xaa nto naz jwer. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nu nzhé xaa lo re xaa: —Nkeela lo Xkyech Dios nii: “Li na nak yoo pa wdizhno rese xaa Dios” Is. 56:7; Jer. 7:11; per gu mleya kwenta tub pa nzho wann. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yizata mbizh mseed Jesús re myet leen lach roo yidoo. Nu lee re fariseo nu re maestr xaa nlu xtizh Dios, nu re xaa non nkwaan re xaa mod gut xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Per nangazhaalt mod ngut re xaa Jesús, nel zyen doo myet tubka nzeke tich Jesús nu nzhon xaa re kwaan nseed Jesús re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tub mbizh gorna lee Jesús kaseed re myet lach roo yidoo, zee ngwa re ngwleyy non lo xaa, nu noka ngwa re maestr, nu noka ngwa re xaa gol lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nu mnabdizh xaa lo Jesús nu nzhé xaa: —¿Cho mzaa diizh le lu re kwaane? nu ¿cho yalnabeyy nkano lu le lu re kwaane? ");
INSERT INTO zpoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús nzhé lo re xaa: —Noka na nabdizh tub kwaan lo gu, keb gu kwaan nabdizh na. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Cho xaa mxaal Juan, xaa mchubnis re myet? ¿Che Dios mxaal xaa o re myet? ");
INSERT INTO zpoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nu lee re xaa mzelo nzhé lo re wechxinn xaa: —Chelee be yé be lo xaa: “Dios mxaal xaa”, zee né xaa lo be: “¿Chozhiin nambint gu xtizh xaa?” ");
INSERT INTO zpoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Per chelee be yé be lo xaa: “Re myet mxaal xaa”, zee gut re myet be kwaan ke, nel nzak re myet lee Juan nak tub xaa mzaa kwent kwaan nzhé Dios lo lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Zee nzhé re xaa: —Nanet nu cho mxaal Juan. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesús nzhé lo re xaa: —Nixa na naniit lo gu cho mzaa diizh le na re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús mzaa stub kwent nabix lo re myet nu nzhé xaa: —Tub welt ngu tub xaabyi, xaa mgaan yag ub tub lach. Nu mzaa xaaya kompani lo stub xaa zee nachii xaaya, zee nya xaa ngu xaa tub yezh zit doo, nu zyen doo liin nya xaa ngu xaa baa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nu gorna mzhin mbizh top xaa yalgon, zee mxaal xaa tub re xmos xaa, zee yaxii xaa re kwaana yizo xaa nak cheena. Per lee re xaa kanachiiya mzaa golp xaa ba, nu nik tub kwaan namzaat xaa lo xaa gorna mbare xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Lee xaa nak cheena mxaal stub xmos xaa, nu lee re xaa kanachiiya, mzaa golp re xaa nu ned doo mle xaa xaa ne, nu mxaal xaa xaa nya xaa nu nik tub kwaan namzaat xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nu zeera lee xaa nak cheena mbare mxaal stub xaa ngok yon xaa. Lee re xaa kanachiiya ngune lo xaa nu mseweey xaa xaa, nu mlebi xaa xaa tub lad pa nanzhaant xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Zee lee xaa nak cheena nzhé: “¿Cho kwaan le na? Nal xaal na mer xgaan na, xaa nkedoola na, xaa nesi ech zon re xaa xtizh xaa.” ");
INSERT INTO zpoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Gorna ne re xaa kanachiiya lo xgann xaa, zee nzhé re xaa: “Xaa ne nak xaa kayaa rese kwaane gorna lee xuz xaa yet. Gut re be xaa, zee gak lach ne cheen re be.” ");
INSERT INTO zpoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Zee mloo re xaa xaa lach pa nzeb yag ub nu mbit re xaa xaa. Lee nal, ¿xomod nzak gu? ¿cho kwaan le xaa nak cheen lach yag ub nal? ");
INSERT INTO zpoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ya xaa nu gut xaa re xaa kanachiiya, zee zaa xaa lach ub lo stub naz xaa zee nachii xaaya. Gorna mbin re xaa kwaane, zee nzhé re xaa: —¡Nanet Dios gak kwaane! ");
INSERT INTO zpoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lee Jesús mwii lo re xaa nu nzhé Jesús: —¿Xomod nak kwaan nkee lo Xkyech Dios? Lee ke kwaan mlebi re xaa nza yoo tub lad, leeya gak tub ke mas kwaan chul doo, zob xaa naz skin yoo. Sal. 118:22 ");
INSERT INTO zpoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Xaa ral ke ne nii tira yech xaa; nu chelee ke ne la yek tub xaa, yidese leya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Re xaa fariseo nu re maestr xaa nlu xtizh Dios, nzhekla re xaa zen xaa Jesús, nel mzeen re xaa lee kwent nabix kwaan ngunii Jesús nlu nen xomod nle re xaa. Per nzheb re xaa ne re myet, zee mlaa re xaa Jesús nu nya re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tubka nkwaan re xaa nayii ne Jesús tub mod zen re xaa Jesús. Kwaanzee mxaal re xaa myet, xaa mle mod xaa wlipa nkenzha xtizh Jesús nel xaa ne nzhekla keb Jesús tub kwaan nawent, zee nzho mod zaa xaa Jesús lo re xaa nak zhiin. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Re xaabyi ne nzhé lo Jesús: —Maestr, nela nu lee re kwaan nlu lu nak kwaan wli, lee lu nak xaa nali lo re myet, nu nali nlu lu xnaz Dios lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Che nzhaal kix nu lo xaa kwaan ntop demi kwaan nya naz Roma o nanzhaalt kix nuya? ");
INSERT INTO zpoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Per Jesús nela lee re xaa kakade, zee nzhé Jesús lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Blu tub demi lo na. ¿Cho yek nkee loya? ¿Nu cho le nkee loya? Lee re xaa mkeb nzhé: —Cheen César, xaa nabeyy Roma. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Zee nzhé Jesús lo re xaa: —Mbay. Zaa gu lo César kwaan nak xcheen César, nu bzaa gu lo Dios kwaan nak xcheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nik tub kwaan nawent nanguzhalt re xaa lo re kwaan mseed Jesús. Nu gorna mbin xaa kwaan nzhé Jesús, mdedyall doo xaa zee zheta ngok re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lee re xaa saduceo nle xgab, lee re myet xaa ngut, nanrobant. Zee ngwa lak xaa lo Jesús, zee nabdizh xaa lo Jesús, nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestr, Ches mkee lo Xkyech Dios nzhé: “Chelee tub xaabyi, xaa mchelya ngut nu nik tub xinn xaa namlaat xaa, zee lee wech xaa nzhaal chelya kwaan xngwnaa xaa ngut, zee kano xngwnaa xaa mad, zee naluxt dii cheen wech xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tub welt ngu tub xaa nkano xop wech. Lee xaa yilotlaka mchelya, ta ngut xaa. Nu nik tub xinn xaa namlaat xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Lee wech xaa, xaa nzeke tich xaa, mchelya kwaan lee me, nu noka xaa ne ngut nu nik tub mad namlaat xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nu seeka ngok xaa yon. Nu yizasa gaazh xaa mchelya kwaan lee me nu nik tub xaa namlaat mad. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nu gwluzhtlaka noka ngwnaa ngut. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Chol roban re xaa, ¿xana xaa gak xmbyi me, nel yizasa gazh xaa mka me? ");
INSERT INTO zpoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús nzhé lo re xaa: —Lee re myet xaa yizhyo ne nchelya. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Per lee re xaa nzhaal roban lo re xaa ngut, nu nya xaa naz yiba, nu baa nachelyatra re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nu nyentra mod yet xaa stub welt, nel mroban re xaa zee gak xaa xinn Dios. Nu gak re xaa kwenta re mandad cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nu axta Ches mlu lee re myet roban, gorna mzaa xaa kwent cheen yag kwaan kayek, gorna ngunii Xaa Nabeyy lo xaa nu nzhé xaa: “Lee na nak Dios cheen Abraham, Dios cheen Chak, Dios cheen Kob”. Ex. 3:6 ");
INSERT INTO zpoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Nel Dios nanakt Dios cheen re xaa ngut; nel Dios nak xaa nabeyy lo re xaa mban, nel lo Dios rese myet mban! ");
INSERT INTO zpoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nu lee tub maestr xaa nlu xtizh Dios, nzhé lo Jesús: —¡Maestr, wen né lu! ");
INSERT INTO zpoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nu gorna ngulo mded kwaane, mzheb re xaa nabdizhra xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús mnabdizh lo re myet nu nzhé xaa: —¿Xomod nak kwaan mbezh re myet, lee Xaa Xaal Dios Nabeyy yaad naz lo dii cheen David? ");
INSERT INTO zpoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nel leeka David mkee lo yech cheen Salm nzhé: Dios, Xaa Nabeyy rese kwaan, nzhé lo Xaa Nabeyy lo na: “Zob lad li lo na, ");
INSERT INTO zpoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","axtaka chezhin na rese xaa nayii ne lu, zee kichxub xaa lo lu, nu zee gak xaa mod tub kwaan zhib lu nii lu tich”. Sal. 110:1 ");
INSERT INTO zpoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","’Leeka David nzhé: “Lee xaa nak Xaa Nabeyy lo na”. ¿Xomod nzho mod yaad xaa dii cheen David nu leeka David mlole xaa: “Xaa Nabeyy lo na”? ");
INSERT INTO zpoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Leezha kaseed xaa re myet zee nzhé xaa lo re xaa mseed lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Kanap gu gu zee nakadet re maestr xaa nlu xtizh Dios gu, nel re xaa ne nyula doo gak ler chul doo, zee wii re xaa respet lo xaa lo xbi. Nu nkwaan re xaa tub pa non doo zob xaa pa nkasa be nseed be xtizh Dios, nu nkwaan xaa tub pa mas non nzob xaa gorna nyu tub yalni. ");
INSERT INTO zpoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nu nkiib xaa li re ngwnaa byud. Nu nzhedizhno xaa Dios xchee doo, zee wii re xaa respet lo xaa. ¡Per Dios ted xaa mas gro doo bid! ");
INSERT INTO zpoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús mwii lo re rik, xaa kago demi leen alkansi naz roo yidoo cheen re xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Noka ngune xaa lo tub byud, me prob doo. Me ne mlo chop rel leen alkansi. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Zee Jesús nzhé: —Wlipa na nii na lo gu, lee ngwnaa prob ne mzaa mas grora gon ke re stub naz xaa mzaaya. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nel rese xaa mlo gro doo demi leen alkansi, per nebse mlo xaa re kwaan mlake lo xaa. Per lee ngwnaa prob ne mlo rese demi kwaan nkano me kwaan nak kwaan zi me kwaan gaw me. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lak myet kawdizh cheen yidoo kwaan gro cheen re xaa Israel. Nu mbezh xaa lee re ke cheen yidoo ne chul doo nzhak nu zyen doo gon ngwaya. Per lee Jesús nzhé: ");
INSERT INTO zpoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Kwaan kawii gu lo nal, zhin tub mbizh rese ke kwaan chul doo kwaan nyun lo gu, nalaketra tich sa ke ke. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Zee mnabdizh re xaa lo Jesús: —Maestr, ¿cho gor zelo re kwaane gak? ¿Cho kwaan luu zee mer gak re kwaane? ");
INSERT INTO zpoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús mkeb lo xaa nu nzhé xaa: —List gok gu zee nik tub xaa nakadet gu. Nel zyen doo xaa yiid nu né xaa: “Na nak Crist, Xaa Mxaal Dios Nabeyy”. Noka né xaa: “Mzhin gaxla mbizh gak re kwaane”. Nareket gu tich re xaa sbaa nii. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Gorna gon gu lee dil nzho rete pa, nazhebt gu. Rese kwaane nzhaal gak yilotlaka; per nalet re kwaane nak kwaan lux yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Noka nzhé Jesús lo re xaa: —Lee re yezh dil kwaan stub yezh nu lee pa nabeyy tub rey dil kwaan pa nabeyy stub rey. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nu gun re xog naro doo lo yizhyo, nu la win, nu la reta yalyizh reta pa. Nu luu nseyn gro doo naz leen yiba, kwaanzee cheb doo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yilotlaka ded re kwaane, lee re myet zen re gu nu ted xaa gu bid, nu yilaa xaa gu pa nkasa be nseed be xtizh Dios nu noka yilaa xaa gu lo re xaa nak zhiin nu lo re rey zee chep xaa gu lozhyib. Sbaa le xaa gu nel nzaa gu kwent cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kwaane gak zee nzho mod zaa gu kwent cheen na lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nu nalet gu xgab cho kwaan keb gu gorzee lo re kwaan gaazh xaa tich gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nel na za yalnzhak lo gu zee wen keb gu lo xaa gorzee; zee lee re xaa nayii ne re gu nyent mod saaw roo gu, nu nixa nyent mod keb lo gu nik tub kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Leeka xuz gu, leeka re wech gu, nu re xaa li gu, nu re xaa nyenn gu, yilaa xaa gu lo xaa nak zhiin, nu sbaa axta nzho mod gut xaa lak gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nu rese myet zhaal xyan ne gu, nel nzaa gu kwent cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Per nik tub yich yek gu naluxt. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Per loka xaa ye ded re kwaane, xaa ba le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Gorna ne gu lee re soldad dub welt nzhi yezh Jerusalén zee ne gu leeya lux. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Re xaa nzho yizhyo Judea nzhaal rexonn xaa nya xaa naz yi, lee re xaa nzho yezh nzhaal rexonn nya leeka naz yi, nu lee re xaa nzhi naz wen nanzhaaltra bare xaa yezh. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bid doo ted Dios re xaa mbizh zee, zee gak rese kwaan kwentaxa nkeeya lo Xkyech Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nagan gak re kwaane lo re ngwnaa me nakxiin mbizh zee. Nu nagan gaka lo re ngwnaa me nkano madoo, nu nagan doo gaka lo re myet nzhi lo yizhyo ne, nel lee yalnayii cheen Dios la tich re myet yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lee lak myet yet kwaan spad, nu zlak myet wee xaa lo yizhyo cheen xaa. Nu nabeyy re xaa nanakt xaa Israel yezh Jerusalén, axta gorna yilo yixoob re mbizh kwaan nzhaal nabeyy re xaa yizhyo Israel. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Nu luu nseyn gro doo naz yiba lo mbizh, lo mbee, lo re mbal. Nu lee re myet xaa nzho re yezh yizhyo ne, tira guuzh lo yalnacheb gorna ne xaa lee nistoo nakap doo nkee brink. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nu tira guuzh re myet lo yalnacheb cheen re kwaan gak lo yizhyo ne, nel lee re kwaan nzho naz leen yiba xiz. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Gorzee wii re gu, lee na Xaa Mzhin Ngok Myet, nyal leen xkaw kwaan gro doo yalnabeyy cheen na nu kwaan xni chul cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Gorna ne gu lee re kwaane zelo gak, zoli gu nu blep gu yek gu naz yiba nel merla zhin na za na yalnaban kwaan tira lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús mzaa tub kwent nabix ne lo re myet, nu nzhé xaa: —Wii gu lo yag ig nu wii gu lo stub naz yag. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Gorna lee re ram cheena merla koo lag, zee ne gu lee mbee kwaan la neey mzhin gaxla. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Leeka snee, gorna ne gu lee re kwaane kayak, nela gu lee yalnabeyy cheen Dios nzezhin gaxla. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Wlipa na nii na lo gu, lee re myet xaa nzhi nal nayeta xaa gorna lee re kwaane zeeraka gak. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lee yizhyo nu yiba lux per lee xtizh na nadedt. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Bkanap gu gu napa lee re kwaan yizhyo ne kale gan lo gu, zee tubka nalet gu xgab cho kwaan gaw gu nu cho kwaan go gu zee listlaka zo gu mbizh kwaan bare na, ");
INSERT INTO zpoNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","nel zhin mbizh nakap ne lo rese myet dubse yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tubka bkanap gu gu, nu tubka wdizhno gu Dios zee nzho mod le gu gan lo re kwaan nakap doo kwaan ded, nu zee nzho mod zo gu lo na, Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Rese mbizh nseed Jesús rese myet lach roo yidoo, per rese yaal ngwa xaa yi kwaan le Olib, nu mlaz xaa baa. ");
INSERT INTO zpoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Garziil doo rese myet nya lach roo yidoo zee gon xaa kwaan yé Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mzhin gaxla mbizh la yalni kwaan le Paskwa, zee selazh re xaa Israel xomod mloo Dios re xey xaa Egipto, nu lee lo yalni ne nzhaw xaa pan kwaan nanyut lebadur leen. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nu lee re ngwleyy non, nu lee re maestr xaa nlu xtizh Dios, kakwaan xaa mod zen xaa Jesús xlaan, zee gut xaa xaa, per mzheb xaa ne xaa re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Zee lee Maxuu mzeeb lextoo Judas, xaa le Iscariote, tub xaa lo re chiibchop xaa mseed lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas ngwa mdizhno re ngwleyy non nu re polisi, xaa nkanap yidoo, zee ne xomod zaa Judas Jesús lo re xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nyakdoola re xaa nu nzhé xaa: —Nal kix nu ka lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Zee lee Judas myaan kwaan re xaa zee zaa xaa Jesús lo re xaa, nu mkwaan xaa le xaaya leezha nyent zyen myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mzhinla mbizh cheen yalni kwaan le Paskwa, mbizh kwaan nzhaw xaa pan kwaan nanyut lebadur, leeka mbizh kwaan nteed xaa mbakxiil lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús mxaal Pér nu Juan nu nzhé xaa lo rop xaa: —Gwa gu nu bdexkwaa xchee kwaan le Paskwa gaw be. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Per lee rop xaa nzhé lo xaa: —¿Pa nzhekla lu yadexkwaa nuya? ");
INSERT INTO zpoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús mkeb nzhé: —Gwa gu yezh, nu baa yizhal gu tub xaabyi, xaa nyano tub re nis. Breke gu tich xaa axta roo yoo pa zeeb xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yé gu lo xaa nak li yoo: “Lee Maestr né: ‘Nzhekla na gaw na kwaan re xaa kaseed lo na xchee Paskwa. ¿Pa nzob yoo gaw nu leen?’” ");
INSERT INTO zpoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nu zee luu xaa tub yoo ndok lo gu kwaan nak stub pis leen yoo ndok, pa nzho rese kwaan. Baa dexkwaa gu kwaan gaw re be. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nu mroo rop xaa mseed lo Jesús. Nu mzhin xaa yezh. Nu nguzhal xaa re kwaan kwentaxa nzhé Jesús lo xaa, nu mdexkwaa xaa kwaan gaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Gorna mzhin gor, mzelo Jesús ndaw kwaan re chiibchop xaa mkayaa yalnabeyy lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús nzhé lo re xaa: —Nzhekla doo na gaw na xchee Paskwa kwaan re gu, gorna zer ted xaa na bid. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wlipa na nii na lo gu, nabaretra na gaw na xchee ne xcha, axta yilo gak re kwaan nii xchee ne, zeera gaw naya pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Zee lee Jesús mzen bas nu mzaa xaa dixkix lo Dios nu nzhé xaa: —Bzen guya nu bted guya lo rese wechxinn gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wlipa kwaan nii na lo gu, nalsi nagotra na xis ub nee, sinka go na axta mbizh kwaana go naya xis ub pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Zee lee Jesús mzen pan nu mzaa xaa dixkix lo Dios nu mlerol xaaya. Zee mzaa xaaya lo re xaa nu nzhé xaa: —Kwaane nak xbaal na, kwaan za na zee le gu gan yalnaban kwaan tira. Ble gu kwaane zee selazh gu na. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Leeka sbaa mzen Jesús bas, gorna ngulo ndaw xaa pan, nu nzhé xaa: —Lee xis ub kwaan nzho leen bas ne nak ren cheen wdizh kub kwaan xo na kwent cheen re gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wii gu, lee xaa zaa na lo re xaa nayii ne na, tubka kayaw kwaan be. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wlipa na nii na lo gu, lee na Xaa Mzhin Ngok Myet, zaa xaa na lo re xaa nayii ne na, nel sbaa nak mod mle Dios xgab. ¡Per tira nawent ded xaa zaa na lo re xaa! ");
INSERT INTO zpoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Zee rese xaa mnabdizh lo wechxinn xaa, ne xana xaa le kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Zee lee re xaa mseed lo Jesús mzelo nkediizha nen xana xaa nak xaa mas xaa nonra. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús nzhé lo re xaa: —Ne wen gu, lee re xaa nabeyy yizhyo ne, nabeyy doo xaa lo re xaa nzhi lo xaa, nu seeka re xaa non nabeyy doo xaa re xaa xaa, nu nii re xaa lo xaa: “Xaa nle yudar be”. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per lo re gu nanakta snee. Blaa gu lee xaa mas non lo re gu gak mod xaa yeen. Nu blaa gu lee xaa nabeyy gu gak xmos gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Cho kwaan nzak gu? ¿Cho xaa nonra, xaa kayaw o xaa kago kwaan leen yann? Lee xaa kayaw nonra lo xaa nkee zhiin kago kwaan leen yann. Per lee na nak tub xaa nkee xchiin gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Re gu nzo kwaan na leezha ndeed na bid. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na za yalnabeyy lo gu, modxa mzaa xuz na yalnabeyy lo na, ");
INSERT INTO zpoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","zee nzho mod gaw gu nu go gu pa nabeey na, zee zob gu nabeyy gu lo chiibchop dii cheen re be. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Zee lee Xaa Nabeyy nzhé lo Pér: —Pér, bkenzha kwaane. Lee Maxuu ngunaab zee nabeyy xaa gu, zee koo xaa gu, kwentaxa ngoo xaa nzhobxtil lo paj. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pér ngunaab na lo Dios kwent cheen lu zee nalaat lu xomod ngwii lu lo na. Zee gorna bare lu lo na, nzhaal le lu yudar re wech lu zee noka re xaa nye zo lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pér nzhé lo Jesús: —¡Xaa Nabeyy! List nzo na nya na yoo na kwaan lu lozhyib, nu noka list nzo na yet na kwaan lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús mkeb lo xaa nu nzhé: —Pér, lee na nii lo lu, zeeraka kozhe gaay lee lu yé chon welt nanlabeyyt lu na. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús nzhé lo re xaa mseed lo xaa: —Leezha mxaal na gu ngunii na lo gu zee naweet gu demi, nixa yex kwaan yo re xcheen gu leen, nixa yelyed. ¿Che nzho tub welt ngu jwalt tub kwaan lo gu? Lee re xaa mkeb nzhé: —Nik tub welta. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Zee nzhé xaa lo re xaa: —Per lee nal xa naka; nzhaal wee gu demi nu yex kwaan yo re xcheen gu leen. Nu loka cho nankanot espad, nzhaal to xaa xkamis xaa zee zii xaa tuba. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na nii lo gu, kwaan nzaa Xkyech Dios kwent cheen na nzhaal gaka, paro nzhé: “Lee re myet nzak lee xaa nak tub xaa nakap doo”. Is. 53:12 Zee gak rese kwaan nzaa Xkyech Dios kwent cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Zee lee re xaa mseed lo xaa nzhé: —Xaa Nabeyy, nee nkano nu chop espad. Jesús nzhé: —Wena. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Zee mroo Jesús leen yoo, zee ngwa xaa yi kwaan le Olib, kwentaxa nleka xaa yilo, noka re xaa mseed lo xaa ngwa kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Gorna mzhin xaa baa, zee nzhé xaa lo re xaa: —Bdizhno gu Dios zee nakiilt Maxuu gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Zee mlaa Jesús re xaa, kan tub lal paro ngol xaa tub ke kwaan yaa xaa. Baa mkichxub xaa nu mdizhno xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Snee nzhé xaa: —¡Ay, Xuz na! Che leeya nzho moda, nalaat lu deed na kwaan nakladiizh deed na, per nagakta kwentaxa nzhekla na, sinka kwentaxa nzhekla lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Zee tub mandad cheen Dios myaad naz leen yiba mzaa jwers lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nu nales doo nzhak leen lextoo xaa, nu xche doo mdizhno xaa Dios. Nu kwenta ren nzhak nis neey ngob garlo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Gorna ngulo mdizhno xaa Dios, zee nguxso xaa, nu mbare xaa paro mlaa re xaa mseed lo xaa. Nu mzhin xaa lo re xaa, lee re xaa naxna, nel nales doo nzhak lextoo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Zee nzhé Jesús lo re xaa: —¿Chozhiin naxna gu? Guxche gu nu bdizhno gu Dios, zee nakiilt Maxuu gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lee Jesús seetaka kanii lo re xaa mseed lo xaa, zee lee Judas, xaa ngok tub xaa lo re chiibchop xaa mseed lo Jesús, nze delant lo zyen doo myet. Nu mbii gax lo Jesús, ndaw xaa bit tagarlo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Per lee Jesús nzhé lo xaa: —Judas, ¿che kwaan tub bit luu lu na, xaa nak Xaa Mzhin Ngok Myet lo re xaa nak zhiin? ");
INSERT INTO zpoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Gorna ngune re xaa nzo kwaan Jesús lee kwaane kayak, zee ngunabdizh xaa lo Jesús nu nzhé xaa: —Xaa Nabeyy, ¿che zdil nu kwaan spad cheen nu? ");
INSERT INTO zpoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Per tub xaa nzo kwaan Jesús, mloo spad nu mchoog lad li nzha xmos ngwleyy non doo. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús nzhé lo xaa mchoog nzha xmos ngwleyy: —¡Laa! Nu gorzee mzen xaa nzha xaa zee mkened xaaya stuba. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesús nzhé lo re ngwleyy non nu lo re maestr, nu lo re xaa gol, xaa kwaan nzewee xaa: —¿Chozhiin nze gu kwaan spad nu kwaan yag zen gu na kwenta tub wann? ");
INSERT INTO zpoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Zyen doo mbizh mzo na lo re gu lo lach roo yidoo nu namzent gu na. Per nal nze gu lo yalnabeyy cheen yalnakaw zen gu na, nel gor nal nak gor cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Zee mbe xaa Jesús garli ngwleyy non doo, nu lee Pér zit zit nzhake tich re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nu xsaww jwer roo yoo, mze re xaa tub bal, nu mzob re xaa dub welt lo bal zee zhe xaa. Nu noka Pér mzob kazhe lo bal. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tub ngwnaa mad, me nak mos lo ngwleyy non doo, ngune lee Pér nzob kazhe lo bal, zee wen wen mwii me lo Pér lo xni cheen bal, zeera nzhé me: —Noka me nee mkanze kwaan Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pér mkade nu nzhé: —Ngwnaa, nanlabeyyt na xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gwluzh xep lee stub xaa ngune lo Pér nu zee nzhé xaa: —Noka lu nak tub re xaa nreke tich Jesús. Pér nzhé: —¡Aa, nanot na! ");
INSERT INTO zpoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kan stub gor gwluzh, zee stub xaa nzhé: —Wlipa na, noka xaabyi ne mzo kwaan Jesús nel nak xaa tub xaa yizhyo Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Per lee Pér mkeb nzhé: —¡Nanet na cho kwaan né lu lo na! Nu leeka gorzee, lee Pér seetaka kawdizh lee gaay mbazhe. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nu gorzee lee Xaa Nabeyy mwii lo Pér, zee lee Pér mzelazh kwaan nzhé Xaa Nabeyy lo Pér: “Zeeraka kozhe gaay, chon welt lee lu yé nanlabeyyt lu na”. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Gorzee mroo Pér nu nales doo ngok lextoo xaa nu mbinn doo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nu lee re xaa nkanap Jesús, nxizhno xaa Jesús, nu nzaa golp re xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Msaaw xaa garlo Jesús kwaan tub lee ler nu mbezh re xaa lo Jesús: —¡Né, cho mkeeya yek lu! ");
INSERT INTO zpoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mxizhno xaa Jesús nu zyen doo kwaan nawent nzhé xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nu gorna ngulo nguni yizhyo, lee re xaa nabeyy lo re xaa Israel, xaa nak re ngwleyy non nu re maestr xaa nlu xtizh Dios mkasa, zee lee re xaa yiidno Jesús pa nzhi re xaa. Nu nzhé re xaa lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Né lo nu, ¿che lu Crist, Xaa Mxaal Dios Nabeyy? Jesús mkeb nzhé: —Chelee na za na kwent lo gu, nalet gu krer xtizh na. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nu chelee na nabdizh na tub kwaan lo gu nakebt gu nik tub kwaan lo na. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Neta nalzhe naz delant lee na zoob lad li lo Dios xaa ngezh doo, nel lee na nak Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Rese xaa nzhé lo xaa: —¿Che nak lu Xgann Dios? Jesús nzhé: —Leeka re gu nguné, lee na nak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Zee nzhé re xaa: —Nankintra wdizhno be stub xaa, zaa kwent cheen xaa ne. Mbinla be mer lee xaa nguné kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Zee ngu re xaa junt zee mbe Jesús lo Pilat. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Zee mzelo xaa mgaazh xaa zyen doo kwaan nawent tich Jesús kwenta kwaane: —Nguga xaabyi ne lo re nu, lee xaa nzheno re sawlazh nu naz nawent, nu nguné xaa lo re sawlazh nu: “Nanzhaalt kix be cheen leyo lo César xaa nabeyy yezh Roma”, nu noka né xaa: “Lee na nak Crist, Xaa Mxaal Dios Nabeyy”. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Zee lee Pilat mnabdizh lo Jesús nu nzhé xaa: —¿Che lu nak Rey cheen re xaa Israel? Jesús nzhé: —Sbaa naka, kwentaxa nguné luya. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Zee lee Pilat nzhé lo re ngwleyy non nu lo re xaa nzhi baa: —Nzak na nik tub jwalt namlet xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Zee mbare re xaa nzhé: —Wii, axta yizhyo Galilea mzelo xaa mzaa xaa kwent zee lee re myet zelo yasya lo re xaa Roma. Nu noka mzhin xaa re yezh cheen Judea nee nu sbaaka kale xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Gorna mbin Pilat kwaane, zee mnabdizh xaa: —¿Che xaa yizhyo Galilea nak xaa ne? ");
INSERT INTO zpoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Gorna ngune Pilat lee Jesús nak xaa yizhyo pa nabeyy Herod, zee mxaal xaa Jesús lo Herod. Mbizh ba Herod nzo Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nyakdoola Herod ngune lo Jesús, nel nzha doo mbizh nzhekla xaa ne xaa lo Jesús, nel zyen doo welt mbin Herod kwent cheen Jesús, nu nzhekla xaa ne xaa le Jesús tub kwaan gro doo. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Zee mnabdizh Herod zyen doo kwaan lo Jesús, per lee Jesús nik tub kwaan namkebt lo Herod. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Per lee re ngwleyy non, nu re maestr xaa nlu xtizh Dios nzhi baa nu zyen doo re kwaan mgaazh re xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Zee lee Herod nu re soldad cheen Herod mzaaya yenn Jesús nu mxizhno re xaa Jesús. Nu mlo re xaa tub ler chul doo yenn Jesús zee mbe re xaa Jesús lo Pilat stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nu mer mbizh ba lee Pilat rop Herod mbare myenn stub welt, nel yilo mdil doo rop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat mrezh re ngwleyy non nu re xaa nabeyy yezh, zee ya re xaa lo Pilat. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Zee nzhé Pilat lo re xaa: —Mbidlaa re gu xaabyi ne lo na, mgaazh gu kwaan tich xaa, lee xaa nle zee yasya re myet ne re xaa Roma. Delant lo re gu mnabdizh na re kwaane lo xaa, nzak na nik tub jwalt kwaan mgaazh gu tich xaa namlet xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Noka Herod nzak nik tub kwaan namlet xaa, zee mxaal xaa xaa lo na stuba. Nik tub kwaan namlet xaa zee nanzhaalt yet xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nal za naya yenn xaa zee sela na xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nu rese liin leezha nla yalni ne, Pilat nsela tub xaa nzho lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Per rese myet dublegan mbazhe, nu nzhé: —Nanzheklat nu sela lu xaabyi ba, Barrabás nzhekla nu sela lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás nak tub xaa mbit myet nu leeka lee xaa nak xaa mchaldil xaa nabeyy yezh, kwaanzee mlo xaa Barrabás lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat nzhekla sela Jesús, zee mbare xaa ngunii xaa lo re myet stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Per lee re myet mbare nzhé: —¡Kee xaa lo krus! ¡Kee xaa lo krus! ");
INSERT INTO zpoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Myon welt mbare Pilat nzhé lo re xaa: —¿Chozhiin? ¿Cho kwaan nawent mle xaa ne? Nanguzhalt na nik tub kwaan nawent kwaan mle xaa zee gut na xaa, nebse teed na xaa bid zee sela na xaa zee nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per lee re xaa seetaka nye doo mbazhe, nu mbezh re xaa nzhaal kee xaa lo krus. Tant nkee doo re xaa bi, zee mle xaa gan le Pilat kwaan nzhekla re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Zee lee Pilat mnabeyy zee gaka mod nzhekla re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Zee msela Pilat Barrabás xaa mbit myet nu xaa mchaldil xaa nabeyy yezh. Nu mzaa xaa Jesús zee gaka mod nzhekla re myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Zee mbe re xaa Jesús, nu lee tub xaabyi le Simón xaa yezh Cirene nyaad ngwa wen, zee mnabeyy soldad xaa zee wee xaa krus cheen Jesús naz tras tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zyen doo myet mreke tich Jesús. Nu zyen doo ngwnaa, me nzhonn, nzhake tich xaa, nel nales doo nzhak lextoo me ne me xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Zee lee Jesús mzere yenn naz tras mwii lo re me, nu nzhé xaa: —Xchap na, me Jerusalén, nanzhonnt gu kwent cheen na, lee gu nzhonn kwent cheen re gu nu kwent cheen re xinn gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","¡Bkenzha gu! Zhin tub mbizh gorna yé gu: “Nyakdoola re me nit, nu noka nyakdoola re me nik tub welt zer zaa nizh go mad”. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Zee zelo re me yé me lo re yi: “Bla tich re nu”. Nu noka yé re me lo re yi: “Sebyo nu”. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chelee snee le xaa lo tub yag naye, nakapra le xaa lo tub yag mbizhla. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nu noka mbe xaa chop xaa nakap zee gut xaa xaa tubka kwaan Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Gorna mzhin re xaa pa nii xaa “Zhit Yek Xaa”, zee lee re soldad mkee Jesús lo krus, nu noka mkee xaa rop xaa nakap lo krus; tub xaa mkee xaa lad li lo Jesús nu stub xaa mkee xaa lad rebes lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Zee lee Jesús nzhé: —Xuz na, chee jwalt kwaan kale re xaa ne, nel nanet xaa cho kwaan kale xaa. Nu mloo re xaa swert nen cho xaa le gan xab xaa, zee nen cho kwaan yizo kad tub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nu dub welt lo xaa nzhi re myet ngwii. Nu lo re xaa baa nzhi re xaa non, nu nxizhno re xaa Jesús nu mbezh re xaa: —Nanlaat lu yet stub xaa, per chozhiin nyent mod sela lu leeka lu lo krus. Né lu lee lu nak Crist, Xaa Mxaal Dios Nabeyy lo re nu. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nu noka re soldad mxizhno Jesús. Nu nzhazaa xaa xis ub kwaan nala go Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Zee nzhé re soldad lo xaa: —Chol lu nak Rey cheen re xaa Israel, bla lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Lee letr kwaana mkee xaa yek xkrus xaa nzhé: “REY CHEEN RE XAA ISRAEL”. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Zee lee tub xaa nakap nkee xkwes Jesús lo krus, ngunii re wdizh nawent lo Jesús, nu nzhé xaa: —Chol nak lu Xaa Mxaal Dios Nabeyy, bla lu leeka lu lo krus, nu bla nu lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Per lee stub xaa mkee lo krus, xaa mle kwaan nakap, mgalno xaa wechxinn xaa, xaa nzhé kwaan nawent lo Jesús, nu nzhé xaa lo wechxinn xaa: —¿Chozhiin nanzhebt lu ne lu Dios? Yon be lal kaded bid. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nu nzhaal ded rop be bid nel mle be re kwaan nawent, per lee xaa ne nik tub kwaan nawent namlet. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Zee nzhé xaa lo Jesús: —Xaa Nabeyy, bselazh na gorna zhin lu pa nabeyy lu. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús nzhé lo xaa: —Wlipa na nii na lo lu, leeka nalzhe zo lu kwaan na lo Lach Chul cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kan rolta mbizh dubse yizhyo mla yalnakaw axta las tres mzhel yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nu lee mbizh namzaatra xni. Nu lee ler kwaan nyaaw roo Pa Nambey Doo leen yidoo ngok chop lee. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Zee lee Jesús mrazhe nzhé: —Xuz na, lo lu za na yalnaban cheen na. Gorna ngulo ngunii xaa kwaane ta ngut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nu gorna lee xaa nabeyy lo tub gayoo soldad ngune xomod ngut Jesús, mbill xaa lo Dios, nu nzhé xaa: —Wlipa lee xaa ne nak tub xaa nali doo. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nu rese myet xaa nzhingwii nen xomod ngut Jesús, nales doo nzhak lextoo re xaa nu mgazya xaa lazh xaa nu nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Zee re xmig Jesús nu re ngwnaa Galilea, me mreke tich Jesús, nzhingwii zit, ne xomod mle xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Noka nzo tub xaabyi le Che. Lee xaa nak tub xaa yezh Arimatea, tub yezh cheen re xaa Israel. Nak xaa tub xaa nali doo lo Dios, nu nkambaz xaa mbizh kwaan nabeyy Dios. Nak xaa tub xaa lo re xaa nabeyy lo xaa Israel, per nangulat xaa kwaan mle re xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Che ngwa lo Pilat nu ngunaab xaa kwerp cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Zee mla xaa xkwerp Jesús lo krus, nu mchaal xaa xkwerp Jesús tub lee ler wen doo nu mlo xaa xaa leen tub baa kwaan mdeen xaa cho ke. Nu nik tub xaa zer yo leen baa ba. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nu zhe zee nak mbizh kwaan ndexkwaa xaa re kwaan gaw xaa zhe sab, zhe kwaan nzholl re xaa Israel lo Dios, nu merla zelo zhe sab. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Lee re ngwnaa me Galilea, me mreke tich Jesús, ngwa roo baa. Nu ngune me xomod mzhiib xaa xkwerp Jesús leen baa. ");
INSERT INTO zpoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Zee mbare re me Jerusalén, nu mzi me perfum kwaan chul doo nzebech. Nu mle re me deskans zhe sab, modxa nabeyy ley le me. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Zhe dming garziil gorna pensa ngulo mlen mbizh, re ngwnaa ne ngwa roo baa pa mlo xaa xkwerp Jesús, nu mbe me re perfum kwaan chul doo nzebech. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Gorna mzhin me lee ke ndok kwaan msaaw xaa roo baa nanzobtra pa mzob xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Zee mzeeb re me leen baa per nanguzhalt xkwerp Jesús lo re me. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Zee mnabdizh re me lo wechxinn me nu nzhé me: —¿Xomod ngok kwaane? Zee mlu chop xaabyi, xaa nak ler rus kwaan nla xni doo lo re me. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mzheb doo re me ta mwii re me naz lo yo. Zee lee rop xaabyi zee nzhé lo re me: —¿Chozhiin kakwaan gu xaa mban lo re xaa ngut? ");
INSERT INTO zpoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wii gu nyent xaa nee; lee xaa mrobanla. ¿Che nanzetla gu kwaan né xaa lo gu leezha nzoka xaa yizhyo Galilea? ");
INSERT INTO zpoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Leezha né xaa lo gu: “Lee na nak Xaa Mzhin Ngok Myet, nu zaa xaa na lo re myet xaa nzeb jwalt, zee kee re xaa na lo krus per lee mbizh yon lee na roban stub welt”. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Zeera mzelazh re me kwaan nzhé Jesús leezha mbanaka xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Gorna mbare re me ngwa me roo baa, zee mzaa me kwent cheen re kwaane lo chiibtub xaa mseed lo Jesús nu lo re stub naz myet. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Snee le re me: Mari me yezh Magdala, Juan, nu Mari xnaa Chag. Nu noka stub naz re ngwnaa me nzhi baa mzaa kwent cheen kwaane lo re xaa mkayaa yalnabeyy lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lee re xaa nzhé lo re wechxinn xaa: —¡Nzhak naxen re ngwnaa ne! Nu nanlet re xaa krer kwaan nzhé re me. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nu gorzee nguxso Pér nu mrexonn xaa ngwa xaa roo baa. Nu gorna mzhin xaa mkichyek xaa mwii xaa leen baa per nebse ler kwaan mchaal xaa Jesús myun lo xaa. Zeesi mdedyall xaa nya xaa, gorna ngulo ngune xaa kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Leeka mbizh ba mroo chop xaa mseed lo Jesús naz Jerusalén nu nzha xaa yezh kwaan le Emaús, kwaan nzhi kan chiibtub kilómetro. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nzhaze rop xaa nu nzhayadizh rop xaa re kwaan ngok. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nu gorna nzhayadizh rop xaa nu leeka gorzee lee Jesús nzhaze kwaan rop xaa, ");
INSERT INTO zpoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","per nzho tub kwaan mleya zee namzeent rop xaa cho xaa nak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Zee lee Jesús nzhé lo rop xaa ba: —¿Cho xaa kazet gu? Zee lee rop xaa mlaz chep nu nales doo nzhak lextoo rop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tub xaa le Cleofas nzhé lo xaa: —¿Che naleet naz Jerusalén mroo lu? ¿Che zer gon lu re kwaan ngok re mbizh ne? ");
INSERT INTO zpoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Lee xaa mnabdizh lo rop xaa: —¿Cho kwaan ngok? Lee rop xaa mkeb nzhé: —Kawdizhno nu kwent cheen Jesús xaa yezh Nazaret. Lee xaa ne ngok tub xaa non doo nu mzaa xaa kwent kwaan nzhé Dios lo lee xaa. Dios mxaal xaa zee mle xaa re kwaan gro doo nu mdiizh xaa duzna kwaan yalnabeyy zee mdedyall doo re myet mwii lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nu lee re ngwleyy non nu re xaa gol mzaa xaa lo re xaa mbit xaa, zee mkee re xaa xaa lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nu mle nu xgab lee xaa zelo nabeyy re sawlazh be, nu texonn xaa re xaa Roma, per lee nal nzhala chon mbizh ngut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","¡Per nal garziil lak ngwnaa mle zee mdedyall doo nu, nel ngwa me roo baa cheen Jesús, ");
INSERT INTO zpoNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","per nanguzhalt xkwerp Jesús lo re me! Nu gorna mbare re me lo re nu, ngune me lo re nu, lee me ngune lo chop mandad cheen Dios, xaa nzhé lo re me lee Jesús mbanla. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Zee lee zlak xaa nzo lo nu ngwa roo baa, zee ngune xaa leeka kwaan ngune re ngwnaa, per nanguzhalt xaa xkwerp Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Zee lee Jesús nzhé lo rop xaa: —¡Xaa ned! ¿Chozhiin tant nen doo nle gu krer kwaan mkee re xaa kwaan mzaa kwent kwaan nzhé Dios lo lee xaa yilo? ");
INSERT INTO zpoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nkin ded Crist bid, Xaa Xaal Dios Nabeyy, nu zeera bare xaa nya xaa pa nzho xni gro doo cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Zee lee Jesús mzaa kwent xomod mbarlo re kwaan nkee lo Xkyech Dios cheen lee xaa, re kwaan mzaa Ches kwent nu re kwaan nzhé re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nu gorna mzhin rop xaa yezh pa nzha xaa, zee lee Jesús mle mod tub xaa ya mas zit, ");
INSERT INTO zpoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","zee lee rop xaa nzhé lo xaa: —Blaz lo rop nu, nel mzhela yizhyo. Zee mlaz Jesús lo rop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Gorna mzelo re xaa gaw, zee mzen Jesús cha pan nu mzaa xaa dixkix lo Dios nu mlerol xaaya, nu mzaa xaaya lo rop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Zeera mxal lo rop xaa, nu mlabeyy xaa Jesús. Zee ta namlutra Jesús lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nu zee nzhé xaa lo wechxinn xaa: —¡Nyak doo lextoo be gorna nyaad wdizh be naz, gorna mzaa xaa kwent kwaan nkee lo Xkyech Dios lo be! ");
INSERT INTO zpoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nu leeka gorzee mzoli rop xaa nu zoza mbare rop xaa naz Jerusalén. Nu gorna mzhin rop xaa zee nzhé xaaya lo chiibtub xaa Jesús, nu lo stub naz re xaa nzo lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nu nzhé re xaa lo rop xaa: —Telisa mban Xaa Nabeyy, ngunela Pér lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Zee mzaa rop xaa re kwent ne xomod ngune xaa lo Jesús gorna nzhaze xaa naz, nu xomod mlabeyy xaa Jesús gorna mlerol Jesús pan. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Gorna lee re xaa seetaka kawdizh re kwaane, lee Jesús ta mreke xsaww lo re xaa nu nzhé: —Wen kwi re gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Per lee re xaa mzheb doo, nu mle re xaa xgab nu nzhé xaa: —Tub bes mzhin lo be. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús nzhé lo re xaa: —¿Chozhiin tant nzheb re gu? ¿Chozhiin seetaka ned doo lextoo gu? ");
INSERT INTO zpoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wii gu yaa na nu wii gu nii na. ¡Leeka naya! Gal gu cho na zee ne gu mer naya. Tub bes nankanot baal nixa zhit, kwentaxa nkano naya, modxa nlu na lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Gorna ngulo nzhé Jesús kwaane, zee mlu xaa yaa xaa nu nii xaa lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nu nixa sbaa mlu Jesús yaa xaa nu nii xaa lo re xaa, per seesa nanlet xaa krera. Nagan doo le re xaa krera, nu noka nyakdoola re xaa. Zeera nzhé Jesús lo re xaa: —¿Che nkano gu kwaan gaw gu? ");
INSERT INTO zpoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Zee mzaa xaa tik mbal nguy lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nu ndaw Jesús mbal delant lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Zee nzhé Jesús: —Kwaane nak re kwaan ngunii na lo re gu, leezha mzoka na kwaan re gu. Rese kwent cheen na kwaan nkee lo ley cheen Ches, nu re kwaan ngunii re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, nu re kwaan nkee lo Salm, rese mbarlola. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Zeera mxal Jesús yek re xaa zee la xtizh Dios yek xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Zee nzhé Jesús lo re xaa: —Lo Xkyech Dios nkee lee Xaa Xaal Dios Nabeyy nzhaal yet, nu mbizh yon lee xaa roban. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nu nzhaal zaa gu kwent kwaane lo re myet xaa nzho re yezh lo yizhyo, nu nzhaal zelo gu naz Jerusalén. Nu kwaane nak kwaan nzhaal zaa gu kwent zee rese xaa laa kwaan nawent kwaan kale xaa, zee chee Dios xjwalt xaa kwent cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Re gu nzhaal zaa kwent cheen na nel ngune gu nu mbin gu re kwaan mle na. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bkenzha gu. Na xaal kwaan nguné Xuz na zaa xaa lo re gu, per nzhaal kwaz re gu naz Jerusalén axta yilo kayaa gu yalngezh kwaan yaad naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Zee Jesús mloo re xaa roo yezh Betania, zee mlep xaa yaa xaa nu ngunaab xaa lo Dios kwent cheen re xaa, zee zo Dios kwaan re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nu gorna seetaka kanii xaa lo Dios lee Jesús ta nguxoob naz leen yiba. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Gorna ngulo mbill re xaa mseed lo Jesús lo xaa, zee mbare re xaa Jerusalén stub welt. Zeesi nyakdoola re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nu zeesi tubka mzo re xaa lach roo yidoo nu tubka mbill re xaa lo Dios.");
INSERT INTO zpoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Lee Wdizh Naban ngu axta mbizh yilotlaka, nu lee Wdizh Naban nzola kwaan Dios, nu lee Wdizh Naban nak Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nu lee Wdizh Naban nzola kwaan Dios axta yilo. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nu rese kwaan nzho mdexkwaa Dios kwaan Wdizh Naban, nu rese kwaan nzho nik tuba namdexkwaat techo. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lee Wdizh Naban nak yalnaban, nu lee yalnaban nak xni kwaan nzaa xni lo rese myet yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nu lee xni ne nzaa xni lo yalnakaw nu lee yalnakaw nyent mod saaw lo xni ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nu Dios mxaal tub xaa le Juan, ");
INSERT INTO zpoNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","zee zaa xaa kwent cheen xaa yaad, xaa nak xni, zee rese xaa wii lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Naleet Juan nak xni, per lee Juan nak tub xaa mzaa kwent cheen xni, ");
INSERT INTO zpoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","nu lee xni kwaan wlipa nzaa xni lo rese myet, yaad yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lee Wdizh Naban myaad lo yizhyo ne, nu nixa leeka Wdizh Naban nak xaa mdexkwaa yizhyo ne, per lee re xaa yizhyo ne namlebeyyt Wdizh Naban. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Myaad Wdizh Naban lo xkyizhyo xaa, per namkayaat re xmyet xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Per lee rese xaa mkayaa Wdizh Naban nu mwii lo xaa, mzaa xaa yalnabeyy lo xaa gak xaa xinn Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nu lee re xaa ne ngol stub welt zee gak xaa xinn Dios, per nanakta nel nzhekla myeta o nel nzhekla xuz xaa o xnaa xaa, kwaane naka nel sbaa nzhekla Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lee Wdizh Naban ngok myet, nu mban xaa nu ngu xaa lo re be, nu ngune nu yalnkela cheen xaa, nu ngune nu wli nak xaa. Noka ngune nu lo xni cheen xaa, nu kwaane mlu nebse lee xaa nak Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan mzaa kwent cheen xaa nu nzhé: —Kwent cheen xaa mza na, leezha ngunii na, lee xaa nze ngwluzh lo na per mas nonra xaa lo na, nel lee xaa nzhola axta yilo gorna zeeraka gal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nel nadoo doo nak xaa, mlu xaa yalnkela cheen xaa lo nu, nu tubka nlu xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yilo mzaa Dios ley lo Ches; per leezha myaad Jesucrist, Dios mlu yalnkela cheen xaa nu mod wli nak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nik tub xaa zer ne lo Dios; nebse Xgann xaa ngune lo xaa, xaa techosa lo xaa, nu lee xaa nak xaa mlu xomod nak Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lee re xaa nabeyy nu, xaa Israel, xaa nzho yezh Jerusalén, mxaal xaa re ngwleyy nu re xaa nle yudar xaa zee yanabdizh xaa lo Juan zee ne xaa cho nak Juan. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nu klar doo nzhé Juan lo re xaa: —Nanakt na Crist, Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Zee mbare re xaa mnabdizh: —¿Cho nak lu zeey? ¿Che lu nak Li, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo? Juan mkeb nzhé: —Nanakt na Li. Zee lee re xaa mbare nzhé: —¿Che lu nak stub xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, xaa nak kwent yaad? Lee xaa mkeb nzhé: —Nanakt na xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Zee lee re xaa nzhé: —¿Cho nak lu zeey? Nkin yé nu tub kwaan lo re xaa mxaal nu. ¿Che nzho mod né lu lo nu, cho nak lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan mkeb modxa nzhé Chay, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo: —Na nak kwenta tub bos kwaan nii paro nanzhot myet: “Bxal gu tub naz nali ze Xaa Nabeyy”. Is. 40:3 ");
INSERT INTO zpoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Zee lee re xaa mxaal re xaa fariseo mnabdizh lo Juan, ");
INSERT INTO zpoNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","nu nzhé xaa: —Chelee lu nanakt lu Xaa Mxaal Dios Nabeyy, nixa nanakt lu Li, nixa nanakt lu tub xaa mkayaa wdizh lo Dios yilo, ¿chozhiin nchubnis lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan mkeb nzhé: —Na nchubnis kwaan nis, per lo re gu nzho stub xaa nanlabeyyt gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Xaa ne nze gwluzh lo na, nu nonra xaa lo na zee nixa tich xkyelyed xaa nanzhaalt xek na. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Re kwaane ngok tub pa le Betania, stub lad roo yuu Jordán, pa mchubnis Juan. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Stub mbizh, Juan ngune lo Jesús mzebii gax lo Juan, zee nzhé Juan: —¡Wii re gu, xaa ne nak Xmbakxiil Dios, xaa kiib jwalt cheen rese myet yizhyo ne! ");
INSERT INTO zpoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Xaa ne nak xaa mza na kwent leezha ngunii na lo gu: “Gwluzh lo na nze stub xaa mas nonra lo na, nel lee xaa nzho axta yilo leezha zeeraka gal na”. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nu nixa nanlabeyyt na xaa, per na nchubnis zee lee re xaa Israel labeyy xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nu noka mzaa Juan kwent, nzhé xaa: —Ngune na lee Mbi Naban nyaad naz yiba mod tub palom, nu mlaya cho xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nu na seetaka nanet na cho nak xaa, per xaa mxaal na zee chubnis na kwaan nis, nguné lo na: “Loka xaa kwaan ne lu la Mbi Naban cho, nu kwaz Mbi Naban kwaan lee xaa, xaa zee nak xaa chubnis kwaan Mbi Naban”. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nu na nguneya, kwaanzee nza na kwent lee xaa nak Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nu stub mbizh, Juan nzo leeka zee, kwaan chop xaa kwaan mseed lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Gorna ngune Juan lee Jesús nzhaded, zee nzhé xaa: —¡Wii gu, xaa ba nak Xmbakxiil Dios! ");
INSERT INTO zpoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Gorzee lee rop xaa mseed lo Juan, mbin nzhé Juan kwaane, zee mreke xaa tich Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús mzere yenn; nu gorna ngune xaa lee rop xaa ne nzeke tich xaa, zee mnabdizh xaa lo xaa: —¿Chozhiin nzeke gu tich na? Lee rop xaa nzhé: —Dix Maestr, ¿pa nzho lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús mkeb nzhé: —Te gu zee ne gu. Zee ngwa rop xaa ne, zee ngune xaa pa nzho xaa, nu mlaz xaa kwaan lee xaa las cuatro axta mkaw yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Lee rop xaa mbin kwaan nzhé Juan nu mreke xaa tich Jesús, tub xaa le Ndres, wech Simón Pér. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nu leeka gorzee nguchezh Ndres wech xaa Pér, nu nzhé xaa lo xaa: —Ngune nu lo Xaa Mxaal Dios Nabeyy, xaa nak Crist. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Zeera mbe Ndres Pér pa nzo Jesús, gorna ngune Jesús lo xaa nu nzhé xaa lo xaa: —Lu nak Simón, xgann Juan, per nal role lu Cefas. (Wdizh ne nak “Pér”.) ");
INSERT INTO zpoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Stub mbizh, Jesús mroo nzha naz yizhyo Galilea, zee ngune xaa lo Lip nu nzhé xaa lo xaa: —Reke tich na. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Lip nak tub xaa yezh Betsaida, lazh Ndres rop Pér. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Lip ngwakwaan Nat, nu nzhé lo xaa: —Ngune nu lo xaa kwaan mzaa Ches kwent cheen lo re yech cheen ley, nu leeka lee xaa mzaa re xaa yilo kwent kwaan nzhé Dios lo lee xaa. Xaa zee nak Jesús, xinn Che, xaa yezh Nazaret. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nat nzhé: —¡Nyent mod yo tub xaa wen yezh Nazaret! Lip nzhé: —Chaa, zee ne lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Gorna ngune Jesús lee Nat mzhin gax lo xaa, nzhé xaa: —Nee nze tub xaa wlipa nak tub xaa sawlazh be, xaa Israel, xaa nankadet. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Zee nzhé Nat: —¿Xomod nlabeyy lu na? Jesús mkeb nzhé: —Gorna zeeraka kwezh Lip lu, ngune na lo lu gorna nzob lu xan tub yag ig. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nat nzhé: —Maestr, ¡lu nak Xgann Dios, lu nak rey lo sawlazh be, re xaa nak dii cheen Israel! ");
INSERT INTO zpoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús mkeb nzhé: —Nel nii na lo lu ngune na nzob lu xan tub yag ig, zee nzak lu na nak Xgann Dios. Per nara ne lu re kwaan mas grora ke kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Noka nzhé Jesús: —Wlipa na nii na lo gu, zne gu lee yiba xal, nu lee re mandad cheen Dios la nu yixoob lo na; nel na nak Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ngok yon mbizh ngu tub jondang Caná, yezh cheen Galilea. Lee xnaa Jesús nzo baa; ");
INSERT INTO zpoNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús nu nu, xaa mseed lo xaa, noka mrezh xaa re nu ya nu jondang. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Leezha mbare xis ub lee xnaa Jesús nzhé lo Jesús: —Nyentra xis ub. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús mkeb nzhé: —¿Chozhiin naab lu kwaane lo na? Nal nyent mod le na yudar lu nel zer zhin gor kwaan le na kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Lee me nzhé lo re mos, xaa ngiiz xis ub: —Ble gu rese kwaan né xaa lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Baa nzhi tub xop yas ke, kwaan ngo re nu nis leen leezha nle nzhul nu nu lo Dios. Nu leen kad tub yas nyu tub tapgal o tub gayoo litr nis. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús nzhé lo re mos: —Chezhe gu nis leen re yas ba. Nu mtezhe re xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Zee nzhé Jesús lo re xaa: —Bloo gu chepa, nu be guya lo xaa nabeyy lo re gu zee le xaa preba. Snee mle xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Lee xaa ne mle preb nis kwaan ngok xis ub, nu nixa nanet xaa pa mrooya; nebse re xmos xaa ne pa mrooya, nel re xaa mtezhe nis leen yas. Zee lee xaa nabeyy lo re mos mrezh xaa mchelya, ");
INSERT INTO zpoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","zee nzhé xaa lo xaa: —Rese xaa yilotlaka ngiiz xis ub kwaan mas wen, zee gorna lee re xaa nze jondang ngulola ngu xis ub kwaan mas wen, nu zeera ngiiz xaa xis ub kwaan nanakt kwaan wen. ¡Per lee lu rebes mle luya, mlozhaw lu kwaan wen zee kiiz luya axta gwluzh! ");
INSERT INTO zpoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kwaane mle Jesús yezh Caná yizhyo cheen Galilea nu kwaane ngoka kwaan yilotlaka kwaan gro kwaan mle xaa. Nu snee mlu xaa yalnabeyy cheen xaa, nu rese nu, xaa mseed lo xaa, mzelo ngwii lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ngulo mded kwaane, zee mkato xaa naz yezh Capernaum, kwaan xnaa xaa, nu kwaan re wech xaa, nu kwaan re nu, xaa mseed lo xaa, nu mlaz xaa baa lak mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jesús nguxoob naz Jerusalén leezha merla zhin yalni cheen re nu, xaa Israel, kwaan le Paskwa, pa nselazh nu xomod mloo Dios re xey nu Egipto. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nu lo lach jwer yidoo ngune Jesús lo re xaa nto ngoon, xaa nto mbakxiil, xaa nto palom, nu re xaa nchee demi nzhi baa. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Gorna ngune xaa kwaane, mzen xaa tub le doo nu mdexkwaa xaa tub bins nu mloo xaa re xaa lo lach roo yidoo, kwaan re xmbakxiil xaa nu kwaan re xngoon xaa. Nu mchech xaa re xdemi re xaa kachee demi, nu mtexche xaa xmes re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nu lo re xaa nto palom, nzhé xaa: —¿Cho gor koo gu re xma gu nee? ¡Nalet gu li Xuz na barati! ");
INSERT INTO zpoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Zee lee re nu, xaa mseed lo xaa, mselazh kwaan nzhé xtizh Dios, kwaan nzhé: “Nzhak selos na ne na xomod nle re xaa li lu, nu kwaane le zee gut re xaa na”. Sal. 69:9 ");
INSERT INTO zpoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Lee re xaa non lo nu mnabdizh lo xaa: —¿Xana kwaan gro le lu, zee luu lee lu nkano yalnabeyy le kwaane? ");
INSERT INTO zpoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús mkeb nzhé: —Blux gu yidoo ne, zee chonaka mbizh za naya. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Lee re xaa non nzhé: —Tub choobxop liin mza xaa yidoo ne, nu lee lu né, chonaka mbizh za luya. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per yidoo kwaan kazaa Jesús kwent nak leeka kwerp cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kwaanzee leezha mroban xaa, lee nu, re xaa mseed lo xaa, mselazh kwaan nzhé xaa, nu mzeen nu lee kwaan nii xtizh Dios nu kwaan nzhé Jesús nak kwaan wli. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Leezha mzo Jesús Jerusalén, yalni cheen Paskwa, zyen doo xaa mzelo ngwii lo xaa mod Xaa Mxaal Dios Nabeyy, nel mwii re xaa lo re kwaan gro mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per Jesús ne nawlit xaaya, nel nlabeyy xaa xomod nak rese myet. ");
INSERT INTO zpoNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nu nankint xaa tub xaa zaa kwent lo xaa xomod nak re myet, nel lee xaa nlabeyy lextoo rese myet. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ngu tub fariseo, xaa le Nikodem, tub xaa non doo lo re nu. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tub gwzhe ngwa xaa ne lo Jesús nu nzhé xaa: —Maestr, ne nu lee Dios mxaal lu zee seed lu nu, nel nik tub xaa nyent mod le re kwaan gro doo kwaan nle lu, chelee Dios nanzot kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús nzhé lo xaa: —Wlipa na nii na lo lu, chelee xaa nagalt stub welt nyent mod rep xaa Pa Nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem mnabdizh: —¿Per xomod gal tub xaa stub welt leezha ngoxla xaa? ¡Nyent mod rep tub xaa lextoo xnaa xaa nu gal xaa stub welt! ");
INSERT INTO zpoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús mkeb lo xaa nzhé: —Wlipa na nii na lo lu, chelee xaa nagalt xaa leen nis nu kwaan Mbi Naban cheen Dios nyent mod rep xaa Pa Nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Loka xaa nzhal lo tub myet, myet nak xaa; nu loka xaa nzhal lo Mbi Naban, mod Mbi Naban nak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nu nadedyallt lu nel ngunii na lo lu: Lee gu nzhaal gal stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lee mbi nze loka lad nzheklaya, nu nixa nzhon lu mbezha, per nanet lu pa naz nzeya nu nixa pa naz nyaya. Nu sbaaka nak re xaa nzhal kwaan Mbi Naban. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodem mbare mnabdizh: —¿Xomod nzho mod gak re kwaane? ");
INSERT INTO zpoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús mkeb nzhé: —Lu nak maestr lo re sawlazh be, ¿xomod nanlat re kwaane yek lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Wlipa na nii na lo lu, lee re nu ne re kwaan nii nu, kwaanzee nzaa nu kwent re kwaan ngune nu, per nanlet re gu krer kwaan nii nu. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nu chelee gu nanlet gu krer kwaan yizhyo kwaan nza kwent lo gu, ¿xomod le gu krer, chelee na za na kwent cheen kwaan naz yiba? ");
INSERT INTO zpoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Nik tub xaa zer ya naz yiba, techosa xaa kwaan mla naz yiba; xaa kwaan kaza na kwent cheen, nak na. Lee na nak Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nu konxa mkee Ches mball wiz lo yag wen, sbaaka nkin kee xaa na lo yag, Xaa Mzhin Ngok Myet, ");
INSERT INTO zpoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","zee rese xaa kwaan tubka wii lo na, le xaa gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nu mkedoola Dios rese xaa yizhyo ne, zee mxaal xaa Xgann xaa, xaa techosa lo xaa, zee loka xaa tubka wii lo xaa nayeta xaa, sinka le xaa gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nel mxaal Dios Xgann Dios yizhyo ne, nu nanakta nel naab xaa kwent lo re myet, sinka mxaal xaa xaa zee lee re myet le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Loka xaa kwaan tubka wii lo Xgann Dios, nanaabt Dios kwent lo xaa; per lee xaa kwaan nawiit lo xaa tubka, ngulola ngunaab Dios kwent lo xaa, nel namwiit xaa lo xaa nak tubka Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Loka xaa kwaan nangwiit lo Xgann Dios ngulola ngunaab Dios kwent lo xaa, nel gorna myaad xni yizhyo ne, mas nyula re xaa yalnakaw ke xni, nel nle xaa re kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Rese xaa kwaan nle kwaan nawent, nayii xaa ne xaa xni, nu nambiit xaa loya, zee nalut re kwaan kale xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Per lee re xaa nzhake tich kwaan wli, mbii xaa lo xni, zee luu lee re kwaan kale xaa, nak kwaan nzhekla Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ngulo mded kwaane, zee lee Jesús kwaan re nu, xaa mseed lo xaa, mroo Jerusalén nu ngwa nu naz wen cheen Judea, nu baa ngu re nu lak mbizh, nu mchubnis xaa re myet. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nu noka Juan kachubnis naz yezh Enón, gax yezh Salim, nel baa nzho nall nis; nu lee re myet nya lo xaa nu nchubnis xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Re kwaane mded leezha zeeraka ko xaa Juan lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Per lee lak xaa mseed lo Juan, mzelo mdildiizh kwaan lak sawlazh nu, kwent cheen xomod gak nzhul xaa lo Dios, ");
INSERT INTO zpoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","kwaanzee ngwa xaa nu nzhé xaa lo Juan: —Maestr, lee xaa mbid lo lu stub ta yuu Jordán, xaa kwaan mzaa lu kwent cheen, lee nal noka xaa kachubnis re myet, nu zyen doo xaa nya lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan nzhé lo xaa: —Nik tub xaa nyent mod kano tub kwaan chelee Dios nazaata lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Leeka re gu mbin leezha klar doo ngunii na, lee na nanakt Crist, xaa Xaal Dios Nabeyy, lee na nak nebse tub xaa mxaal Dios delant lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lo tub jondang, lee xaa ka sa nak xaa chelya, nu noka xmig xaa nchelya nzo kwaan lee xaa, nu nzhon xaa kwaan nii xaa, nu nyakdoola xaa nzhon xaa kwaan nii xaa nchelya. Nu seeka na nyakdoola na nal. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Lee xaa nkin gak nonra, per lee na gak tub xaa nanont. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Lee xaa kwaan nyaad naz yiba nabeyy lo rese xaa nu lo rese kwaan. Loka xaa nzhal yizhyo ne, xaa yizhyo ne nak xaa nu nzhedizh xaa kwaan yizhyo ne. Per lee xaa kwaan nyaad naz yiba, lee xaa nabeyy lo rese xaa nu lo rese kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nu nzaa xaa kwent kwaan ngune xaa lo, nu kwaan mbin xaa, per nik tub xaa nanlet krer kwaan nii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Per lee re xaa kwaan nle krer kwaan nii xaa noka mlu xaa wli nak Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Lo xaa mxaal Dios nzaa kwent cheen Dios, mzaa Dios Xmbi Naban xaa nu nangwiit xaa paro kwaan mzaa xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lee Xuz xaa nkela Xgann xaa, nu mzaa xaa yalnabeyy lo xaa, zee nabeyy xaa lo rese kwaan nzho yizhyo ne nu yiba. ");
INSERT INTO zpoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Loka xaa kwaan tubka wii lo Xgann xaa, le xaa gan yalnaban kwaan tira; per lee xaa kwaan nangwiit lo Xgann xaa nalet gan yalnaban, sinka le xaa gan la yalnayii cheen Dios tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nu mbin re xaa fariseo zyenra xaa nreke tich Jesús ke tich Juan nu nzhachubnis xaa mas zyenra xaa ke Juan. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Per kwaan wli nak nanchubnist Jesús, sinka xaa nchubnis nak re nu, xaa mseed lo xaa.) ");
INSERT INTO zpoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Gorna mbin Jesús kwaane, mroo xaa Judea, nu nzha xaa naz Galilea stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Per gorna nzha xaa, nkin ded xaa yizhyo cheen Samaria. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nu mzhin xaa tub yezh cheen Samaria kwaan le Sicar, gax xleyo Kob kwaan mlaa xaa lo xinn xaa Che, ");
INSERT INTO zpoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","pa nzob bzo kwaan nii re xaa, bzo cheen Kob. Nu Jesús nguzha mze xaa zee mzob xaa roo bzo ba, kwaane ngok kan rolta mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Zee lee re nu, xaa mseed lo xaa, mlaa nu Jesús nu nzhazi nu kwaan gaw nu leen yezh. Nu gorzee lee tub ngwnaa, me yezh Samaria nzexii nis, zee Jesús nzhé lo me: —Zaa chep nis goo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Per lee re nu, xaa Israel, nanzhaalt xtizh kwaan re xaa Samaria, kwaanzee lee ngwnaa ne mkeb, nzhé lo xaa: —¿Chozhiin naab lu nis lo na, nak na tub me Samaria nu lee lu nak tub xaa Israel? ");
INSERT INTO zpoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús mkeb nzhé: —Chelee lu nlabeyy lu kwaan nzelazh Dios nu cho nak xaa kwaan kanaab nis lo lu, nu chol naab lu nis lo na, lee na za nis kwaan nzaa yalnaban go lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Lee ngwnaa nzhé: —Per nik tub kwaan nankanot lu koo lu nis, nu lee bzo nech; ¿pa koo lu nis kwaan nzaa yalnaban zaa lu goo na? ");
INSERT INTO zpoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Lee Kob, xaa nak xey be, xaa yilo, mlaa bzo ne lo nu, nu leen bzo ne mloo xaa nis ngu xaa, nu ngu re xinn xaa nu re xma xaa. ¿O che nonra lu ke Kob? ");
INSERT INTO zpoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús mkeb nzhé: —Rese xaa kwaan nzho nis ne, telisa gak nzhek lextoo xaa stub welt; ");
INSERT INTO zpoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","per loka xaa go nis kwaan za na, tira nagaknzhektra lextoo xaa. Nel lee nis kwaan za na go xaa, gak leen lextoo xaa mod tub xlen pa nlen nis, kwaan nzaa yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Lee ngwnaa ne nzhé lo Jesús: —Xaa Nabeyy, zaa lu nis ba goo na, zee nagaknzhektra lextoo na, nu nankintra yaadxii na nis nee. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús nzhé lo me: —Gwa, gwachezh sa lu zee bare gu stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Lee ngwnaa mkeb nzhé: —Nankanot na sa na. Jesús nzhé lo me: —Wli lu nguné lu, nankanot lu sa lu; ");
INSERT INTO zpoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","per nzhala gaay xaabyi nzhachelya lu, per lee xaa nkano lu nal nanakt xaa sa lu. Wli lu kwaan nguné lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Gorna mbin me kwaane, zee nzhé me: —Nzak na lee lu nak tub xaa nzaa kwent kwaan né Dios lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Lee re xey nu xaa yilo nzhedizhno Dios yek yi ne, per lee re gu né; paro nzhaal nii xaa lo Dios nak leen yezh Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús mkeb lo me, nzhé: —Wlipa na nii na lo lu, merla zhin mbizh kwaan nankintra ya gu yi ne nixa nankintra ya gu Jerusalén, zee wdizhno gu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nel nanet re gu cho xaa wdizhno gu lo, per lee re nu ne nu cho xaa nzhedizhno nu, nel naz lo re nu, xaa Israel, nyaad yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Per nal mzhin gor, nu nal nak gor leezha lee re xaa wlipa nzholl lo Xuz be, gool lo xaa mod nlu Mbi Naban leen lextoo xaa nu tub mod nali nak. Nel sbaa nzhekla Xuz be gool re xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios nak mbi, nu kwaanzee lee re xaa nzhekla gool lo xaa nzhaal gool lo xaa mod nlu Mbi Naban leen lextoo xaa, nu tub mod nali nak. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Lee ngwnaa nzhé: —Nela na, telisa yaad Xaa Xaal Dios Nabeyy, xaa nak Crist; nu leezha yaad xaa, zaa xaa kwent lo nu xomod nak rese kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús nzhé: —¡Na nak xaa zee, xaa kwaan kayawdizhno lu! ");
INSERT INTO zpoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nu gorna mzhin re nu, mdedyall doo nu ngune nu lee Jesús kayawdizh kwaan tub ngwnaa. Per mzheb nu nabdizh cho kwaan nzhekla me, o cho kwaan kayadizh rop xaa me. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Zee mlaa me xre me nu ngwa me yezh, nu nzhé me lo rese xaa yezh: ");
INSERT INTO zpoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Te gu nee, zee wii gu lo tub xaabyi, xaa nguné rese kwaan mle na lo na. ¿Che nalet xaa ne nak Xaa Xaal Dios Nabeyy? ");
INSERT INTO zpoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Zee mroo re xaa yezh nu ngwa xaa pa nzo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Zeera nzhé re nu lo xaa: —Maestr, daw tub kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Per lee Jesús nguné lo nu: —Nkano na tub kwaan gaw na, kwaan nanet re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Zee mzelo nu mnabdizh nu lo wechxinn nu: —¿Che nzho cho mzaa kwaan ndaw xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Per Jesús né lo nu: —Lee kwaan nle na nak kwaan nzhekla xaa mxaal na le na, nu kwaane nak kwenta kwaan nzhaw na, nu telisa le naya. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Per lee re gu nzhedizh: “Nzho jwalt stub tap mbee, zeera top be yalgon”. Per lee na nii lo gu, bwii gu nee, ngulola ngok yalgon nu mzhinla mbizh dopa. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Lee xaa ntop yalgon nzhex nka, nu lee yalgon kwaan ntop xaa nak kwaan ndii tira, zee lee xaa kwaan mlo ben nu xaa kwaan mtop yalgon, gak chul lextoo rop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nel wli mod nii xaa: “Tub xaa ngo ben lo yo nu stub xaa ntop yalgon”. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na mxaal re gu zee top gu yalgon kwaan namgaant gu, stub naz xaa nak xaa mgaana nu mdexkwaaya, per re gu topa nu kayaaya. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Zyen doo xaa yezh Sicar yizhyo cheen Samaria, mwii lo Jesús, nel lee ngwnaa zee nzhé lo re xaa: “Nguné xaa rese kwaan mle na”. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nu kwaanzee gorna mzhin re xaa yezh ba lo Jesús, ngunaab xaa lo Jesús zee kwaz xaa lo re xaa. Zee lee re nu mlaz baa chop mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nu zyen stub naz xaa mwii lo Jesús, gorna nzhon xaa kwaan nii Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nu nzhé xaa lo ngwnaa zee: —Nalsi ne nu wli lee Jesús nak xaa nzaa yalnaban, nu nanakta nebse nel nguné luya lo nu sinka noka nel mbin nu kwaan nguné Jesús lo nu zee ne nu lee xaa nak xaa nzaa yalnaban. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Gorna ngulo mded rop mbizh zee, Jesús mzen xnaz naz yizhyo Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nu leeka Jesús nzhé, lee re sawlazh xaa, xaa nzaa kwent kwaan nzhé Dios lo lee xaa, nagont xaa xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Gorna mzhin xaa Galilea, lee re myet zee mkayaa xaa chul doo, nel ngune re xaa re kwaan gro kwaan mle xaa lo yalni cheen Paskwa naz yezh Jerusalén, kwaanzee noka lee xaa mzo lo yalni cheen Paskwa. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús mbare naz yezh Caná yizhyo cheen Galilea, paro mle xaa lee nis ngok xis ub. Nu mzhaal xaa kwaan tub xaa non lo rey, nu lee xgann xaa ne ne nzak yezh Capernaum. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Leezha mbin xaa ne lee Jesús mzhin Galilea, ngwa xaa lo xaa nu ngunaab xaa jabor lo Jesús, zee ya xaa garli xaa zee sekwen xaa xgann xaa, xaa merla yet. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús mkeb lo xaa nzhé: —Chelee na nalut na tub nseyn o tub kwaan gro lo gu nawiit gu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Per lee xaa non lo rey nzhé: —Chaa ya be nal, napa lee xgaan na kayet. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Zee lee Jesús nzhé lo xaa: —Zyaa garli lu; ngokwenla xgann lu. Lee xaa ne mle krer kwaan nzhé Jesús lo xaa, nu mbare xaa garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nu gorna nya xaa garli xaa, lee re xmos xaa nzhaxiila xaa kan rol naz nu nzhé lo xaa: —¡Ngokwenla xgann lu! ");
INSERT INTO zpoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Lee xaa mnabdizh: —¿Pa gor mzelo xgaan na ngokwen xaa? Nu lee re xmos xaa nzhé lo xaa: —Naaze, kan la una mroo xlee mad. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Zee lee xuz mad mzeen leeka gor kwaan nzhé Jesús lo xaa: “Ngokwenla xgann lu”, mer gorzee ngokwen xaa. Nu lee xaa nu rese xaa nzho li xaa mwii lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kwaane ngok rop kwaan gro kwaan mle Jesús gorna mroo xaa Judea nyaad xaa naz Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mded lak mbizh, zee lee re sawlazh nu mle tub yalni, nu Jesús mbare ngwa Jerusalén stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nu leen yezh Jerusalén, gax pwert kwaan nii xaa Mbakxiil, nzob tub tank kwaan diizh hebreo leya Betesda. Nkanoya gaay korredor, ");
INSERT INTO zpoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","pa nkambaz zyen doo re xaa ne nzak: xaa nachool lo, xaa ngob nii, nu xaa mdeen. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nkambaz re xaa gorna yiid mandad cheen Dios kun nis leen tank, nu loka xaa yilotlaka nzeeb leen tank gakwen xaa lo yalyizh kwaan nzak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nu lo re xaa ba, nzho tub mdeen, xaa nzhala tub galbchiibxon liin ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nu gorna ngune Jesús lee xaa naxkoslosa, nu ne xaa lak liin nzha sbaa nax xaa, mnabdizh xaa lo xaa: —¿Che nzhekla lu gakwen lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Lee xaa mkeb nzhé: —Nyent cho chep na leen tank gorna lee nis gun. Nu kad welt leezha nzhekla na rep na, yilo stub xaa nrep ke na. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús nzhé lo xaa: —Guxso, bzen xda lu nu bze. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nu leeka gorzee lee xaa ngokwen, mzen xaa xda xaa nu mzelo xaa mze xaa. Per zhe zee nak zhe sab, mbizh kwaan nzholl re nu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Lee re xaa non lo nu, xaa Israel, nzhé lo xaa kwaan ngokwen: —Nalzhe nak zhe sab, zhe kwaan nzholl re be lo Dios; nyent mod wee lu xda lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lee xaabyi zee mkeb nzhé: —Xaa msekwen na né lo na: “Bzen xda lu nu bze”. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Lee re xaa mnabdizh lo xaa: —¿Xana xaa né lo lu: “Bzen xda lu nu bze”? ");
INSERT INTO zpoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per lee xaabyi zee nanet xaa cho msekwen xaa, nel lee Jesús mzeeb lo re myet xaa nzhi baa. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lo lach roo yidoo zeera ngune Jesús lo xaa stub welt, zee nzhé Jesús lo xaa: —Wii, nal ngokwen lu; naletra lu kwaan nawent zee nadedt lu stub bid kwaan mas naxinnra. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lee xaabyi zee nya nu nzhé lo re xaa non: —Jesús nak xaa kwaan msekwen na. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nu kwaanzee, lee re xaa non mrenal Jesús nel nle Jesús re kwaane zhe sab. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Per Jesús nzhé lo re xaa: —Lee Xuz na tubka nkee zhiin zee noka na nkee zhiin. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nu kwaanzee lee re xaa non mas nzhekla gut Jesús, nu nanebt nel nanlet xaa kwaan nzhé ley cheen zhe sab, zhe kwaan nzholl nu Dios, sinka noka naka nel nle xaa lal ke Dios, gorna mbezh xaa Dios nak Xuz xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús nzhé lo re xaa: —Wlipa na nii na, na nak Xgann Dios nu nik tub kwaan nanlet na nel nebse nzhekla na; nebse nle na kwaan ne na nle Xuz na. Rese kwaan nle Xuz na, sbaaka rese nle na. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nel nkela Xuz na na nu nlu xaa rese kwaan nle xaa lo na, nu luu xaa kwaan mas gro lo na, zee dedyall gu ne guya. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nel konxa nseban Xuz na re xaa ngut, nu nle xaa zee mban xaa stuba, sbaaka lee na nza yalnaban lo re xaa kwaan nzhekla na za naya. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nu lee Xuz na nanaabt kwent lo re xaa, sinka mzaa xaa yalnabeyy lo na, xaa nak Xgann xaa, zee naab na kwent lo re xaa, ");
INSERT INTO zpoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","zee rese xaa wii respet lo na, konxa ngwii xaa respet lo Xuz na. Lee xaa kwaan nangwiit respet lo na, noka nangwiit xaa respet lo Xuz na, xaa kwaan mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Wlipa na nii na lo gu, loka xaa kwaan nkenzha kwaan nii na nu ngwii lo xaa mxaal na, le xaa gan yalnaban kwaan tira; nu nanaabt Dios kwent lo xaa mbizh gwluzh, nel mroola xaa lo re xaa ngut nu nkano xaa yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Wlipa na nii na lo gu, mzhin gaxla gor, nu nal nak gor zee lee re xaa ngut nkenzha bos cheen na, nu loka xaa kwaan gona ban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nu nel leeka Xuz na nle zee mban myet, sbaaka mzaa xaa lo na zee le na ban myet; ");
INSERT INTO zpoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","nu noka mzaa xaa yalnabeyy lo na, xaa nak Xgann xaa, zee naab na kwent lo rese xaa, nel lee na nak Xaa Mzhin Ngok Myet. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nu nadedyallt gu lo kwaane, nel yo tub mbizh rese xaa ngut kenzha bos cheen na, ");
INSERT INTO zpoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nu roo re xaa leen xbaa xaa. Lee re xaa mle kwaan wen roban zee kayaa xaa yalnaban; lee re xaa mle kwaan nawent roban xaa zee naab Dios kwent lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Nyent mod le na nebse kwaan nzhekla na. Naab na kwent mod nabeyy Xuz na na, nu lee mod naab na kwent nak tub mod nali, nel nanlet na kwaan nzhekla na sinka nle na kwaan nzhekla xaa kwaan mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Chelee na nebse za na kwent cheen na, nanonta. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Per nzho tub xaa nzaa kwent cheen na, kwent zeesi non. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Re gu mxaal xaa nabdizh xaa lo Juan, nu wli nak re kwaan mkeb xaa lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Per na nankint tub xaa zaa kwent cheen na, nii na kwaane zee ne re gu nzho mod le gu gan yalnaban. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan nak mod tub xni, nu mzo re gu lo xni cheen xaa lak mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Per jabor cheen na nkano na tub preb kwaan mas non ke kwent kwaan mzaa Juan. Lee re kwaan nle na, kwaan nak kwaan mxaal Xuz na le na, nlu lee xaa nak xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nu noka Xuz na, xaa kwaan mxaal na nroo xjabor na, nixa nanzhont re gu bos cheen xaa nixa zer ne gu lo xaa, ");
INSERT INTO zpoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","nixa nanzhot kwent cheen xaa lextoo gu nel nangwiit gu lo na, xaa mxaal Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lee re gu nseed xtizh Dios, nel nzak gu nzho mod yizhal gu yalnaban kwaan tira loya, per nangwiit gu lee Xkyech Dios nzaa kwent cheen na, ");
INSERT INTO zpoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nu lee re gu nanet yiid lo na zee kayaa gu yalnaban kwaan nza na. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Nankwaant na mod zee nii wen re myet lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nu na nlabeyy re gu nu ne na lee re gu nankelat Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na nzhal kwent cheen Xuz na, nu lee re gu nakayaat na; nu chol yiid stub xaa kwent cheen leeka lee xaa, telisa kayaa gu xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xomod gak gu tub xaa ngwii lo Dios, chelee gu nebse nkwaan gu mod zee nii wen re xaa gu, nu nankwaant gu mod zee nii wen Dios gu? ");
INSERT INTO zpoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nu nanlet gu xgab lee na gaazh kwaan tich gu lo Xuz na, xaa ngaazh kwaan tich gu nak Ches, xaa mzaa ley kwaan ngwii gu lo nu nzak gu sbaa yizhal gu yalnaban. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nu chol nzhon gu xtizh Ches, noka nzhaal gon gu xtizh na, nel Ches mzaa kwent cheen na lo re yech kwaan mkee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Per chelee re gu nanlet krer kwaan mkee xaa, ¿xomod le gu krer kwaan nii na? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Gorna ngulo mded kwaane Jesús ngwa stub ta roo nistoo cheen Galilea, kwaan noka nii xaa Tiberias. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Zyen doo myet mreke tich xaa, nel ngune xaa re kwaan gro kwaan mle xaa; msekwen xaa zyen doo myet, xaa ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Zee nguxoob Jesús yek tub yi nu baa mzob xaa kwaan re nu, xaa mseed lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nu merla gak yalni cheen Paskwa, kwaan nle nu, xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Gorzee lee Jesús mwii lo re myet xaa nzeke tich xaa, nu nzhé xaa lo Lip: —¿Pa yizi be kwaan gaw tub lanee myet? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Snee mnabdizh xaa, zee ne xomod keb Lip, nel nela Jesús cho kwaan le xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Lip mkeb lo xaa nzhé: —Nixa demi kwaan le xaa gan chop gayoo mbizh nagalta zuuy pan kwaan gaw re xaa tikgaya. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Zee lee Ndres stub xaa mseed lo Jesús, wech Simón Pér, nzhé: ");
INSERT INTO zpoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Nee nzo tub xaawin, nkano gaay pan sebad nu chop mbal; ¿per pa gaa kwaane gaw rese xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús mkeb nzhé: —Guzh gu lo re xaa zee zob xaa. Nu mzeb doo yixyi baa, zee mzob re xaabyi, kan tub gaay mil xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús mzen gaay pan, nu gorna ngulo mzaa xaa dixkix lo Dios zee mzaa xaaya lo re nu, zee mdiiz nuya lo re xaa nzob baa; sbaaka kwaane mle xaa kwaan mbal, nu mzaa xaaya ndaw re xaa, axta paro nguzhe lextoo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Gorna ngulo ndaw re xaa, Jesús nzhé lo nu: —Btop gu re kwaan mlake, zee naluxta sbaasa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Zee mtop nuya nu mchezhe nu chiibchop chekwid kwaan pan byog kwaan mlake lo re gaay pan sebad. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Zee lee re myet, gorna ngune xaa kwaan gro kwaan mle Jesús, mbezh re xaa: —Wlipa lee xaa ne nak xaa nzaa kwent kwaan nzhé Dios lo lee xaa, xaa nakladiizh xaal Dios yiid lo yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Per Jesús mzeen nzhekla re xaa wee xaa xaa lajwers, zee gak xaa rey cheen re xaa, kwaanzee nya xaa naz yek yi stuba, zee zo techo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Gorna nzela yalchool, lee nu mkato roo nistoo, ");
INSERT INTO zpoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","nguxoob nu leen tub kano nu mzelo nu mzeno nu kano leen nistoo zee zhin nu yezh Capernaum. Nu tira ngulola mla yalchool, lee Jesús zeeraka bare. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Zee lee nis mzelo mgun nel nze doo mbi. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Leezha nzhazela nu kan gaay o xop kilómetro, ngune nu lee Jesús nzezhin gaxla lo nu nyaad zenii lo nistoo, nu mzheb doo nu. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lee Jesús né: —¡Naya, nazhebt gu! ");
INSERT INTO zpoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Zee mkayaa nu xaa, nu leeka gor kwaan mzeeb Jesús leen kano, mzhin re nu yezh pa nzha nu. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Lee stub mbizh, lee re myet xaa mlake stub ta roo nistoo, ngune lee nu nya leen tub kano kwaan nzo baa nu lee Jesús namyat kwaan re nu. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Zee lee stub naz kano nze naz yezh Tiberias mzhin gax pa ndaw rese xaa gorna ngulo mzaa Jesús dixkix lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nu gorna ngune re xaa nixa Jesús nu nixa re nu nyent baa, noka re xaa mzeeb leen kano nu nzhakwaan xaa Jesús naz yezh Capernaum. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Gorna mzhin re xaa stub ta roo nistoo, nguzhal Jesús lo xaa nu mnabdizh xaa lo xaa: —Maestr, ¿cho gor nyaad lu nazre? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús mkeb lo xaa nzhé: —Wlipa na nii na lo gu, gu nkwaan na nel ndaw gu axta paro nguzhe lextoo gu nu nanakta nel mla re kwaan gro kwaan mle na yek gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nanzhaalt kwaan gu kwaan gaw gu kwaan nandiit tira, sinka kwaan gu kwaan gaw gu kwaan tira ndii nu kwaan nzaa yalnaban kwaan tira lo gu. Nel na nak Xaa Mzhin Ngok Myet zee za na yalnaban kwaan tira lo gu, nel Dios, xaa nak Xuz na, mzob sey cheen xaa cho na, zee ne re myet lee na nak Xgann xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Zee mnabdizh re xaa nzhé xaa: —¿Cho kwaan nzhaal le nu zee le nu kwaan nzhekla Dios? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús mkeb nzhé: —Kwaan nzhekla Dios nak, gon gu xtizh na, xaa kwaan mxaal xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Zee mnabdizh re xaa: —¿Xana tub kwaan nzho mod luu lu lo nu, zee nzho mod le nu krer lu? ¿Cho kwaan nzho mod le lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Re xey be, xaa yilo ndaw pan kwaan nyaad naz yiba naz wen, modxa nzhé Xkyech Dios: “Mzaa xaa pan kwaan nyaad naz yiba ndaw re xaa”. Sal. 78:24 ");
INSERT INTO zpoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús mkeb nzhé: —Wlipa na nii na, naleet Ches nak xaa mzaa pan yiba, sinka Xuz na nak xaa nzaa pan kwaan wlipa nyaad naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nel lee pan kwaan wlipa nzaa Dios nak xaa kwaan mla naz yiba, nu nzaa xaa yalnaban lo re myet yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Lee re xaa nzhé: —Xaa Nabeyy, zaa duzna pan zee gaw nu. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Zee nzhé Jesús lo re xaa: —Lee na nak kwenta pan kwaan nzaa yalnaban. Nu xaa kwaan yiid lo na tira nagaknlaantra xaa; nu xaa kwaan tira wii lo na nagaknzhektra lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Per modxa nii na lo gu, nixa ne gu lo na nangwiit gu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Rese xaa nzaa Xuz na lo na, nyiid lo na, nu lee xaa kwaan nyiid lo na nachexonnt na xaa naz jwer. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nel lee na nyal naz yiba zee nalet na kwaan nzhekla na, sinka nyal na zee le na kwaan nzhekla Xuz na, xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nu lee kwaan nzhekla Xuz na, xaa mxaal na nak, nazowent na nik tub re xaa mzaa xaa lo na, sinka rese xaa ba seban na mbizh gwluzhtlaka. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nel lee kwaan nzhekla Xuz na nak, wii rese xaa lo Xgann xaa; nu xaa nzak lee xaa nak xaa mxaal Dios, le gan yalnaban kwaan tira; zee lee na seban xaa mbizh gwluzhtlaka. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Zee lee re xaa nzelo nzhedizh nawent Jesús, nel lee Jesús nzhé: “Lee na nak kwenta pan kwaan nyaad naz yiba”. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Zee nzhé re xaa: —¿Che naleet xaa ne nak Jesús, xgann Che? Rese be nlabeyy xuz xaa nu xnaa xaa. ¿Xomod né xaa nal: “Nyaad na naz yiba”? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Zee lee Jesús nzhé: —Nawdizht gu sbaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nik tub xaa nyent mod yiid lo na, chelee Xuz na, xaa mxaal na, nayiidnot xaa lo na; zee seban na xaa ba mbizh gwluzh. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo nzhé xaa: “Yo mbizh seed Dios rese xaa”. Snee rese xaa kwaan nzhon xtizh Xuz na nu nseed lo xaa, nyiid xaa lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Nu nanakta nel ngune stub xaa lo Xuz na; xaa ngune lo xaa nak na, xaa nyaad naz lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wlipa na nii na, xaa kwaan ngwii lo na, le xaa gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Lee na nak kwenta pan kwaan nzaa yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Re xey be xaa yilo ndaw pan kwaan nyaad naz yiba naz wen, per nixa ndaw xaaya ngut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Per kwaan kaza na kwent lo gu nak pan wlipa kwaan nyaad naz yiba, nu loka xaa kwaan gawa tira nayeta xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Lee na nak pan ba, kwaan nyaad na naz leen yiba; nu loka xaa kwaan gaw pan ne tira ban xaa. Lee pan kwaan za na nak leeka baal cheen na, nu za naya kwent cheen rese myet yizhyo ne zee ban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Lee re xaa mzelo mkediizha: —¿Xomod nzho mod zaa xaa ne leeka kwerp cheen xaa gaw be? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús nzhé lo re xaa: —Wlipa na nii na lo gu, na nak Xaa Mzhin Ngok Myet nu chelee gu nagawt gu baal cheen na, nu nagot gu xren na, nabant gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Loka xaa kwaan gaw baal cheen na nu go ren cheen na nkano xaa yalnaban kwaan tira, nu na seban xaa mbizh gwluzh. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nel baal cheen na nak laaw xaa kwaan wlipa, nu xren na nak kwaan wlipa nzho xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Lee xaa kwaan nzhaw baal cheen na nu nzho xren na tubka nzo xaa zee kwaan na, nu na nzo tubka kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Lee Xuz na, xaa mxaal na nkano yalnaban, nu na mban kwent cheen lee xaa; nu leeka see, loka xaa gaw baal cheen na, ban xaa kwent cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kaza na kwent cheen pan kwaan nyaad naz yiba. Lee pan ne nanakt mod kwaan nyaad naz yiba kwaan ndaw re xey be, xaa yilo, nel nixa ndaw xaaya ngut xaa, per loka xaa gaw pan kwaan za na, tira ban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús nzhé re kwaane, paro nkasa re nu nseed nu xtizh Dios yezh Capernaum. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Gorna mbin re xaa kwaan nzhé Jesús, zyen doo xaa nzhake tich xaa mbezh: —Nagan doo la kwaan nii xaa ne yek be; ¿che nzho mod gon be xtizh xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús mzeen kwaan kawdizh re xaa, zee nzhé xaa: —Nawent nzhak lextoo gu nzhon gu kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Xomod gak lextoo gu chol ne gu lee na, Xaa Mzhin Ngok Myet, yixoob paro nzob na yilo? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mbi Naban nak xaa nzaa yalnaban, per kwerp nyent mod zaa yalnaban. Nu lee re kwaan nii na lo gu nak cheen Mbi Naban nu cheen yalnaban. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per seesa nzho lak gu nanet wii lo na. Nel axta yilo, nela Jesús cho xaa nanet wii lo xaa, nu ne xaa xana xaa zaa xaa lo re xaa nzhekla gut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Zee nzhé xaa: —Kwaanzee nii na lo gu nik tub xaa nyent mod yiid lo na chelee Xuz na nayiidnot xaa lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwaanzee zyen doo xaa nzhake tich Jesús, mlaa xaa xaa nu nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús mnabdizh lo chiibchop nu, xaa kwaan mseed lo xaa, nu né xaa: —¿Che noka re gu nzhekla nya? ");
INSERT INTO zpoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pér mkeb nzhé: —Xaa Nabeyy, ¿cho lo ya nu? Lee xtizh lu nak kwaan nzaa kwent xomod le nu gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Re nu ne lee lu nak Xaa Nali nze lo Dios nu ngwii nu lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús mkeb nzhé: —Mleey na chiibchop gu, nu tub gu nzhon xtizh Maxuu. ");
INSERT INTO zpoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Gorna ngunii Jesús kwaane, kazaa xaa kwent cheen Judas, xgann Simón Iscariote, nel lee xaa nak xaa zaa xaa lo re xaa nzhekla gut xaa, nixa nak xaa tub xaa lo chiibchop nu mseed lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Gorna ngulo mded re kwaane, Jesús nzhaze re yezh yizhyo Galilea, nanzheklat xaa ya xaa yizhyo Judea, nel baa nzhekla re sawlazh nu gut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Per nel merla zhin yalni cheen Ramad, tub yalni cheen re nu, xaa Israel, ");
INSERT INTO zpoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","lee re wech Jesús nzhé lo xaa: —¿Cho kwaan le lu zee kwaz lu nee? Gwa Judea, zee lee re xaa nreke tich lu, xaa nzho baa, ne re kwaan nle lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nel leezha lee tub xaa nzhekla xaa wii re xaa lo xaa, nanlet xaa re kwaan xlaan. Chol nle lu re kwaan kwenta kwaane, bleya delant lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nu nixa re wech xaa nanzakt lee xaa nak xaa mxaal Dios yaad. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús nzhé: —Zer zhin gor cheen na, per lee re gu rese gor nak wen ya gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Lee re xaa yizhyo nyent mod yii ne re gu; per lee na nayii xaa ne xaa na, nel na nlu lo re xaa lee kwaan nle xaa nak kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gwa gu yalni, nayat na nal, nel zer zhin gor cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nzhé xaa kwaane lo re wech xaa, nu mlakeka xaa Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Gorna ngulo nzha re wech Jesús, noka Jesús ngwa yalni, per ngwa xaa xlaan. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Lee re xaa sawlazh nu nkwaan xaa lo yalni, nu mbezh re xaa: —¿Pa nzha xaa zee? ");
INSERT INTO zpoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lee re myet mdildiizh. Lak xaa mbezh: “Nak xaa tub xaa wen”; per zlak xaa mbezh: “Nanakt xaa tub xaa wen; nebse nkade xaa re myet”. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Per nik tub xaa nabezht kwaane delant lo re xaa, nel nzheb re xaa ne xaa re xaa non. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nzhadedla rol yalni, zeera lee Jesús mzeeb lo lach roo yidoo nu mzelo xaa mseed xaa re myet. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Lee re xaa ndedyall nu mbezh re xaa: —¿Xomod tant nzhak xaa ne, nu namseedt xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús mkeb lo re xaa nzhé: —Lee kwaan nlu na nanakta cheen na, leeya nak cheen xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Chelee tub xaa nzhekla le kwaan nzhekla Dios, nzho mod labeyy xaa chelee kwaan nlu na nak cheen Dios o cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Lee xaa kwaan nii kwent cheen leeka lee xaa, nle xaaya zee lee re myet wii lo xaa; per lee xaa nleya zee wii re xaa lo xaa kwaan mxaal xaa, xaa ba mbezh kwaan wli nu nankadet xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Che nawlit Ches mzaa ley lo re xey be? Per nik tub gu nanlet kwaan nzhéya. ¿Chozhiin nzhekla gu gut gu na? ");
INSERT INTO zpoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Lee re myet nzhé: —¡Tub mbi mal nzho lextoo lu, kwaanzee nawent nzhak yek lu! ¿Cho nzhekla gut lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús nzhé: —Re gu mdedyall nel mle na tub kwaan gro zhe sab, mbizh kwaan nzholl re be lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ches mseed be zee koo be xgann be beyy cheen re xaa sawlazh be (nixa kwaane namzelot lo Ches, lee kwaane mzelo lo re xey be, xaa mas yilo). Nu lee re be ngoo madoo madbyi beyy, nixa ped naka mbizh kwaan nzholl re be lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nal chelee gu nzak gu wen koo be beyy tub madoo mbizh kwaan nzholl re be lo Dios, zee le be kwaan nzhé ley cheen Ches, ¿chozhiin nayii gu ne gu na nel msekwen na dub kwerp cheen tub xaa mbizh kwaan nzholl re be lo Dios? ");
INSERT INTO zpoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nanaabt gu kwent mod nlu re kwaan lo gu. Leezha naab gu kwent, ble guya tub mod nali. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Zee lak re xaa nzho Jerusalén, mzelo nzhé: —¡Wii gu, xaa ne kakwaan re xaa, zee gut xaa xaa! ");
INSERT INTO zpoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nu nal baa nzo xaa delant lo re xaa kanii xaa, nu nik tub xaa naniit lo xaa. ¿O che noka re xaa non nzak wlipa lee xaa nak Crist, Xaa Xaal Dios Nabeyy? ");
INSERT INTO zpoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Per re be ne pa nze xaa ba, per gorna yaad Xaa Xaal Dios Nabeyy, nik tub xaa nanet pa naz yaad xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nu zee mseed Jesús re xaa lo lach roo yidoo, nu nzhé xaa dublegan: —¡Re gu nzak nlabeyy gu na nu ne gu pa naz nzhal na! Per nanzhalt na nel nzhekla na, nzhal na nel lee xaa nali mxaal na, xaa kwaan nanlabeyyt re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na nlabeyy xaa ne nel lo xaa mroo na, nu lee xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Zee nzhekla re xaa zen xaa, per nik tub xaa namgalt xaa nel zer zhin gor cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Zyen doo xaa mwii lo xaa nu nzhé xaa: —Lee xaa ne nak Xaa Mxaal Dios Nabeyy nel nle xaa rese kwaan gro, nel rese kwaan nzho mod le xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Lee re xaa fariseo mkenzha kwaan mbezh re myet cheen Jesús; nu lee xaa nu re ngwleyy non, mxaal lak polisi, xaa nkanap yidoo, zee zen xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Zee lee Jesús nzhé: —Xepse kwaz na lo gu, zee bare na lo xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Zee re gu kwaan na, per nayizhalt na lo gu nel nyent mod ya gu pa nya na. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Zee lee re myet mzelo mnabdizh lo re wechxinn: —¿Pa nya xaa ne, zee nayizhalt xaa ne lo be? ¿Che nya xaa naz lo re sawlazh be, xaa nzho stub naz re yezh nu noka seed xaa re xaa nanakt xaa sawlazh be? ");
INSERT INTO zpoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Cho kwaan nzhekla xaa ne né xaa, gorna ngunii xaa: “Kwaan gu na per nayizhalt na lo gu, nel nyent mod ya gu pa nya na”? ");
INSERT INTO zpoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mbizh gwluzhtlaka lo yalni, mbizh kwaan mas non, Jesús nguxso nu nzhé lo re xaa dublegan: —Chelee tub gu nzhek lextoo, te gu lo na nu go gu nis. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Gaka modxa nzhé Xkyech Dios: “Loka xaa kwaan wii lo na, lextoo xaa roo nis kwaan zaa yalnaban kwaan tira”. Ez. 47:1; Zac. 14:8 ");
INSERT INTO zpoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kwaan kwaane nzhekla Jesús yé: Loka xaa wii lo xaa, kayaa xaa Mbi Naban; nel lee Mbi Naban zeeraka yaad zee, nel lee Jesús zeeraka bare nya naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nzho lak re xaa mbin kwaane, nzhé xaa: —Wlipa lee xaa ne nak xaa nzaa kwent kwaan nzhé Dios lo lee xaa, xaa nakladiizh yaad. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Zlak xaa mbezh: —Xaa ne nak Xaa Mxaal Dios Nabeyy. Per zlak xaa mbezh: —Naleet xaaya, nel Xaa Xaal Dios Nabeyy nyent mod ngal yizhyo Galilea, ");
INSERT INTO zpoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","nel lee Xkyech Dios nzhé, lee Xaa Xaal Dios Nabeyy nzhaal gak xaa dii cheen rey David, nu gal xaa naz yezh Belén, leeka yezh pa ngol David. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Snee ngok rol myet kwent cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lak xaa nzhekla ko xaa lozhyib per nik tub xaa namzent xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Lee re polisi, xaa nkanap yidoo, mbare pa nzo re fariseo nu re ngwleyy non, nu mnabdizh xaa ne lo re polisi: —¿Chozhiin nayiidnot gu xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Lee re polisi nzhé: —¡Nik tub xaa zer wdizh modxa nzhedizh xaa ne! ");
INSERT INTO zpoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Zee lee re fariseo nzhé: —¿Che noka re gu ngulo mkade xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nik tub re xaa nabeyy lo be o tub re nu, nanzakt lee xaa nak Xaa Xaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Per maldit re xaa mkayaa xaa mod Xaa Mxaal Dios Nabeyy, nel nixa nanlabeyyt re xaa ley cheen Ches! ");
INSERT INTO zpoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Lee Nikodem nak tub fariseo, xaa ngwa mdizhno Jesús tub welt nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Lee ley cheen be nzhé nyent mod gaazh be tub kwaan tich xaa leezha zer né xaa cho kwaan mle xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Lee re xaa mkeb nzhé: —¿Che noka lu nak xaa Galilea? Bseed Xkyech Dios, zee ne lu nik tub xaa nzaa kwent kwaan nzhé Dios lo lee xaa nanzet naz Galilea. ");
INSERT INTO zpoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nu zee kad tub xaa nya naz garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Per lee Jesús nya naz yek yi Olib. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nu stub mbizh, gorna mkaxni yizhyo mbare xaa naz roo yidoo stub welt. Lee re myet mbii gax lo xaa nu lee xaa mzob nu mzelo mseed xaa re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Zee lee re maestr, xaa nlu xtizh Dios, nu re fariseo nzhano tub ngwnaa, me nguga kachaal kwaan stub xaabyi, nu mzo xaa me xsaww lo re xaa nzhi baa, ");
INSERT INTO zpoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","zee nzhé xaa lo Jesús: —Maestr, lee ngwnaa ne nguga kachaal kwaan stub xaabyi. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lee lo xley be kwaan mzaa Ches lo re xey be, xaa yilo, nzhé nzhaal zaake be tub ngwnaa snee nle axta yilo gut be me. ¿Lee luya, cho kwaan né lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mnabdizh re xaa kwaane, zee kiil xaa Jesús, nu snee yizhal xaa tub kwaan gaazh xaa tich xaa. Per lee Jesús mkichyek nu mzelo mkee kwaan kwen yaa lo yo. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nu lee re xaa seetaka kanabdizh, zee mzoli Jesús nu nzhé xaa lo re xaa: —Rese gu, xaa zer le nik tub kwaan nawent, kee ke yilotlaka yenn me. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nu mkichyek xaa nu mzelo xaa mkee xaa lo yo stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Gorna mbin re xaa kwaane, tubga xaa tubga xaa mzelo nya, nu yilotlaka re xaa gol mroo. Gorna ngulo nya re xaa nebse Jesús rop ngwnaa zee mlake, ");
INSERT INTO zpoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","nguxso xaa nu mnabdizh xaa lo me: —¿Ma re me? ¿Che nik tub me nangunaabt kwent lo lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Lee ngwnaa mkeb lo xaa, nzhé: —Nik tub meya, Me Nabeyy. Jesús nzhé lo me: —Nixa na, nanaabt kwent lo lu; nal zyaa nu naletra lu kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Stub welt Jesús ngunii lo re myet nu nzhé xaa: —Lee na nak kwenta xni yizhyo; loka xaa kwaan reke tich na, nkano xaa xni kwaan nzaa yalnaban, nu nazet xaa naz lo yalnakaw. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lee re fariseo nzhé lo xaa: —Leeka kwent cheen lu kazaa lu; nanont kwent ba. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Lee Jesús mkeb nzhé: —Non kwent cheen na, nixa leeka na nzaya. Nel ne na pa naz nzhal na nu pa naz nya na; per lee re gu nanet pa naza. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lee re gu naab kwent mod mbezh re myet. Lee na nanaabt kwent lo re xaa; ");
INSERT INTO zpoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","per chelee na naab na kwent, zee naka tub kwaan nali, nel nanaabt techo na kwent, sinka noka Xuz na, xaa mxaal na, naab kwent kwaan na. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lee lo ley cheen be nzhé, chelee chop testig nii tubka kwaan, non kwaan nii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wena, leeka na nak tub testig kwent cheen na, nu lee Xuz na, xaa mxaal na, nak stub testig. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Zee mnabdizh re xaa: —¿Ma xuz lu? Jesús mkeb nzhé: —Lee re gu nanlabeyyt na nixa Xuz na, chol nlabeyy gu na, noka nlabeyy gu Xuz na. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús nzhé re kwaane leezha kaseed xaa re xaa lo lach roo yidoo, paro nzhib alkansi, pa ngo xaa gon leen. Per nik tub xaa namzent xaa, nel zer zhin gor cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús mbare nzhé lo re xaa: —Lee na nya, nu kwaan re gu na, per yet re gu lo jwalt cheen gu. Lee pa nya na nyent mod ya re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kwaanzee lee re xaa nzhé: —¿Che kale xaa xgab gut xaa xaa, zee né xaa nyent mod ya be pa nya xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús nzhé lo re xaa: —Re gu nak xaa yizhyo ne, per nanakt na tub xaa yizhyo ne, lee na nzhal naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kwaanzee nii na lo gu, yet gu lo re jwalt cheen gu, nel chelee gu nanzakt gu lee na nak Xaa Mxaal Dios Nabeyy, yet gu lo re jwalt cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Zee mnabdizh re xaa lo xaa: —¿Cho nak lu? Jesús mkeb nzhé: —Axta yilo nii na cho nak na. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nu nzho zyen doo kwaan nzho mod naab na kwent lo gu; per lee xaa mxaal na nii kwaan wli, nu nebse re kwaan nguné xaa lo na, yé na lo re myet yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per lee re xaa namzeent kazaa xaa kwent cheen Xuz xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kwaanzee nzhé xaa lo re xaa: —Gorna kee re gu na lo krus, Xaa Mzhin Ngok Myet, gorzee ne re gu cho nak na, nu nanlet na kwaan nzhekla na; nebse nii na kwaan mseed Xuz na na. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nel lee xaa kwaan mxaal na nzo kwaan na; lee xaa namlat techo na, nel tubka nle na kwaan nyula xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Gorna nzhé Jesús kwaane lo re xaa, zyen doo xaa mzelo ngwii lo xaa mod Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Lee Jesús nzhé lo re myet, xaa mwii lo xaa: —Chelee re gu zob gu xtizh na, wlipa nak gu tub xaa nseed lo na; ");
INSERT INTO zpoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","labeyy gu re kwaan wli, nu re kwaan wli le zee gak gu mod tub xaa mla. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Lee re xaa mkeb nzhé: —Lee re nu nak dii cheen Abraham, nu nik tub welt zer gak nu mos cheen tub xaa; ¿chozhiin né lu lo nu, gak nu mod tub xaa mla? ");
INSERT INTO zpoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús nzhé: —Wlipa na nii na lo re gu, xaa nle jwalt nak mos cheen re kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Lee tub mos nambazt tira garli xaa nabeyy lo xaa, per lee xgann xaa tira nzho garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kwaanzee chelee xgann Dios le zee gak gu mod tub xaa mla, zeesi wlipa nak gu xaa mla. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nela na lee gu nak dii cheen Abraham; per nzhekla gu gut gu na, nel nanzheklat gu zob gu xtizh na. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na nii kwaan mlu lo na leezha mzo na kwaan Xuz na, nu sbaaka lee re gu nle re kwaan nguné xuz gu lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Lee re xaa nzhé: —¡Lee nu nak dii cheen Abraham! Per lee Jesús mkeb lo re xaa nzhé: —Chol nak gu dii cheen Abraham, zle gu kwaan mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Per lee re gu nixa nii na lo gu kwaan wli, kwaan mseed Dios na, nzhekla gu gut gu na. ¡Tub kwaan snee nik tub welt namlet Abraham! ");
INSERT INTO zpoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lee re gu nle kwaan nle xuz gu. Lee re xaa nzhé: —¡Lee re nu nanakt xinn xto xaa; nkano nu tubka xuz nu, xaa nak Dios! ");
INSERT INTO zpoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús mkeb nzhé: —Chol wli Dios nak xuz gu, telisa nkela gu na, nel na nzhal naz lo Dios, lee na nanzhalt nel nzhekla na, lee na nzhal nel Dios mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Chozhiin nyent mod la yek gu kwaan nzhekla na nii na? Nel nanzheklat gu gon gu kwaan nii na. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Lee Maxuu nak mod xuz re gu; nu lee re gu nak xaa xaa, nu nle gu kwaan nzhekla xaa. Lee Maxuu nak tub xaa nzhut myet axta yilo. Nangwiit xaa lo kwaan wli nel nik tub kwaan wli nyent lextoo xaa. Leezha nii xaa kwaan nawlit, nii xaaya mod nak xaa; nel lee xaa nak xaa nkade, nu lee xaa nak xuz re kwaan nawlit. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Per nel na nii kwaan wli zee nanlet gu krer xtizh na. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Cho tub gu nzho mod né lee na mle tub kwaan nawent? Nu cheleeya nii na kwaan wli, ¿chozhiin nanlet gu krer xtizh na? ");
INSERT INTO zpoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xaa nak xaa Dios nkenzha xtizh Dios; per lee re gu namkayaat wdizh lo Dios, naka nel nanakt gu xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Zee lee re xaa nzhé: —Wen nii nu, leezha nii nu lee lu nak tub xaa Samaria nu nzho mbi mal lextoo lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús mkeb nzhé: —Nankanot na nik tub mbi mal lextoo na. Lee kwaan nle na nak ngwii na respet lo Xuz na; per lee re gu nangwiit gu respet lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nu na nankwaant zee wii gu respet lo na, per nzho tub xaa nzhekla wii re xaa respet lo na, nu xaa ba nak xaa naab kwent. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wlipa na nii na, loka xaa kwaan nzhon kwaan nii na, nayeta xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Lee re xaa mkeb nzhé: —Nalsi, ne nu wlipa nzho mbi mal lextoo lu. Abraham nu rese xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo ngut, nu lee lu né: “Loka xaa kwaan gon xtizh na nayeta xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿O che nonra lu ke xey be Abraham, xaa yilo? Lee xaa ngut nu noka re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo ngut. ¿Cho nzak lu nak lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús mkeb nzhé: —Cheleeya leeka na le zee wii xaa respet lo na, nanonta. Per lee xaa kwaan nle zee wii xaa respet lo na nak Xuz na, leeka xaa kwaan mbezh re gu nak Xdios gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Per nanlabeyyt re gu xaa, per na nlabeyy xaa. Nu chol nii na nanlabeyyt na xaa, nak na mod tub xaa nkade, mod re gu. Per wli nlabeyy na xaa, nu nzhon na xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Lee Abraham, xey re be, nyakdoola xaa ne xaa na re mbizh nal; nu ngune xaa lo na, nu nyakdoola xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lee re xaa nzhé lo Jesús: —¡Zeeraka yo lu choobchii liin, nu né lu ngune lu lo Abraham! ");
INSERT INTO zpoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús mkeb nzhé: —¡Wlipa na nii na, lee na nzhoola leezha zeeraka yo Abraham! ");
INSERT INTO zpoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Zee lee re xaa mzen ke kee yenn xaa, per Jesús mkaxlaan nu mroo lach roo yidoo. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Gorna nzhaded Jesús tub pa, ngune xaa lo tub syeg, xaa sbaa ngol. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Lee re nu, xaa mseed lo xaa mnabdizh: —Maestr, ¿chozhiin syeg xaabyi ne ngol? ¿Che naka nel xuz xaa rop xnaa xaa mle jwalt o che naka nel leeka lee xaa mle jwalt? ");
INSERT INTO zpoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús mkeb né: —Nangolt xaa sbaa nel xuz xaa rop xnaa xaa mle jwalt, nixa nanakta nel lee xaa mle jwalt; sbaa nak xaa, zee lo lee xaa luu Dios cho kwaan nzho mod le Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gorna nak zhe nkin kee be xchiin xaa kwaan mxaal na; gorna la yaal nik stub xaa nyent mod kee zhiin. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Leezha nzoka na lo yizhyo ne, nak na xni lo yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Gorna ngulo ngunii xaa kwaane, nu mchuk xaa lo yo, nu mdexkwaa xaa ban nu mteeb xaaya zaalo syeg. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Zee nzhé xaa lo xaa: —Gwa, bdeeb garlo lu leen tank kwaan le Siloé. (Wdizh ne nii: “Xaa mxaal”.) Lee syeg ngwa nu mdeeb garlo, zee nguni zaalo xaa, zee mbare xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Lee re xaa nzho gax garli xaa, nu re xaa ngune lee xaa ngunaab karda, mnabdizh xaa lo wechxinn xaa: —¿Che nalet xaa ne nzob naab karda yizasa mbizh? ");
INSERT INTO zpoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Lak xaa mbezh: —Lee xaaya. Zlak xaa mbezh: —Nalet xaaya, nixa kwenta lee xaa nzhak xaa. Per leeka lee xaa mbezh: —Naya. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Zee mnabdizh re xaa lo xaa: —¿Xomod nzho ngwii lo lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Lee xaa mkeb nzhé: —Xaa le Jesús mdexkwaa ban, nu mteeb xaaya zaalo na, nu né xaa lo na: “Gwa roo Tank Siloé nu bdeeb garlo lu”, né xaa lo na. Gorzee ngwa na, nu mteeb na garlo na nu gorzee nguni zaalo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Zee mnabdizh re xaa: —¿Ma xaa zee nal? Nu lee xaa mkeb nzhé: —Nanet na. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Nu zhe kwaan mdexkwaa Jesús ban nu msekwen xaa zaalo syeg ngok zhe sab, mbizh kwaan nzholl re nu lo Dios. Kwaanzee mbe re xaa xaa ngokwen lo re fariseo. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Zee lee re fariseo mnabdizh lo xaa: —¿Xomod nzho mod nyani zaalo lu nal? Nu lee xaa mkeb nzhé: —Lee xaa mteeb ban zaalo na, nu mzet na garlo na kwaanzee nal nzho mod ngwii na. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lak xaa fariseo nzhé: —Pa gak xaa ne tub xaa mxaal Dios, nel nangozhawt xaa zhe sab, mbizh kwaan nzholl re be lo Dios. Per zlak xaa mbezh: —¿Xomod nzho mod le xaa re kwaan gro ne, chelee xaa nak xaa tub xaa nzeb jwalt? Zee snee ngok re xaa chop tant. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nu mbare xaa ngunabdizh xaa lo xaa ngok syeg yilo: —¿Per cho nzak lu nak xaa msekwen zaalo lu? ¿Cho kwaan né lu? Lee xaa mkeb nzhé: —Na nii lee xaa nak tub xaa nzaa kwent kwaan nzhé Dios lo lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Per lee re xaa non namlet krer lee xaa ngok syeg yilo, axta gorna nguchezh xaa xuz xaa rop xnaa xaa, ");
INSERT INTO zpoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","zee mnabdizh xaa lo xaa: —¿Chelee xinn gu nak xaa ne? ¿Che nzho mod né gu lo nu, nen che syeg xaa ngol xaa? ¿Xomod nal, nzhola mod ngwii xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Lee xuz xaa rop xnaa xaa mkeb nzhé: —Xgann nu nak xaa ne, nu sbaa ngol xaa; ");
INSERT INTO zpoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","per nanet nu xomod nzho mod ngwii xaa nal, nixa nanet nu cho msekwen zaalo xaa. Leeka lo xaa bnabdizh gu nel grola xaa, nzho mod né xaaya lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sbaa nzhé xuz xaa rop xnaa xaa nel nzheb xaa ne xaa re xaa non lo re xaa Israel, nel myaan re xaa koo xaa xaa lo re xaa nkasa nseed xtizh Dios, xaa kwaan yé lee Jesús nak Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kwaanzee nzhé xuz xaa rop xnaa xaa: “Bnabdizh gu lo xaa, grola xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Lee re xaa non mbare mrezh xaa kwaan nak syeg yilo, nu nzhé xaa lo xaa: —Né lo nu kwaan wli delant lo Dios. Nel ne re nu lee xaa zee nak tub xaa nzeb jwalt. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Lee xaa mkeb nzhé: —Nanet na che nak xaa tub xaa nzeb jwalt, o nanakt xaa tub xaa nzeb jwalt. Per kwaan ne na nak, nanyanit zaalo na yilo, per nal nyanilaya. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Zee mbare re xaa ngunabdizh lo xaa: —¿Cho kwaan mle xaa lu? ¿Xomod mle xaa zee nguni zaalo lu nal? ");
INSERT INTO zpoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Lee xaa mkeb nzhé: —Nguniila naya lo gu, per lee gu nanlet krera. ¿Chozhiin nzheklara gu zere naya stub welt? ¿O che noka re gu nzhekla reke tich xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Zee lee re xaa mzelo myech lo xaa, nu nzhé xaa lo xaa: —Lu nreke tich xaabyi ba, per lee re nu nreke tich Ches, ");
INSERT INTO zpoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","nel ne re nu lee Dios ngunii lo Ches; per lee xaa ba nixa nanet nu pa naz nze xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Lee xaa mkeb nzhé: —¿Xomod nak kwaane? ¿Chozhiin nanet re gu pa naz nze xaa, nel lee xaa msekwen garlo na? ");
INSERT INTO zpoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nel ne re be nanzhont Dios xtizh xaa kwaan nzeb jwalt; nebse nzhon Dios xtizh re xaa kwaan ngwii lo xaa nu nle kwaan nzhekla xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nik tub welt zer zaa xaa kwent cheen tub syeg ngol nu nyanila zaalo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nu chelee xaa ne nanzet kwent cheen Dios, nyent mod le xaa tub kwaan gro. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Zee nzhé re xaa lo xaa: —¡Lu nak tub xinn xto xaa! ¿Chozhiin nzhekla lu luu lu xana kwent wen lo nu? Nu mloo xaa xaa pa nseed re xaa xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús mbin lee re fariseo mloo xaa ngok syeg pa nseed re nu xtizh Dios; nu gorna mzhaal xaa xaa mnabdizh xaa lo xaa: —¿Che ngwii lu lo Xaa Mzhin Ngok Myet? ");
INSERT INTO zpoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Lee xaa nzhé: —Né lo na, xana xaa zee, zee wii na lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús mkeb nzhé: —Ngunela lu lo xaa, nel na nak xaa, xaa kawdizh kwaan lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Zee lee xaabyi zee mkichxub lo Jesús, nu nzhé lo xaa: —Xaa Nabeyy, ngwii na lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Zee nzhé Jesús lo xaa: —Na nyal yizhyo ne zee naab na kwent; lee re syeg yani garlo nu lee re xaa nyani garlo gak syeg. ");
INSERT INTO zpoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lak fariseo nzo kwaan lee xaa, nu gorna mbin xaa kwaane mnabdizh xaa: —¿Napa noka nu nak syeg? ");
INSERT INTO zpoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús mkeb nzhé: —Chol nak gu syeg, nankanot gu kulp cheen re jwalt cheen gu. Per nel né gu nyani garlo gu, nzhap gu kulp cheen re jwalt cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Zee nzhé Jesús: —Wlipa na nii na, lee xaa kwaan nanrept naz roo korrel cheen mbakxiil, nu nrep xaa naz cho korrel, nak xaa wann. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Per lee xaa kwaan nrep naz roo pwert nak xaa kwaan nkanap mbakxiil. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Xaa kwaan nkanap roo korrel nxal xaa roo pwert ded xaa, nu nkwezh xaa kad tub mbakxiil kwaan le ma, nu lee re mbakxiil nlabeyy bos cheen xaa. Ngoo xaa ma leen korrel, ");
INSERT INTO zpoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","nu gorna yilo roo rese ma, lee xaa nyaner lo ma, nu lee re mbakxiil nreke tich xaa nel nlabeyy ma xbos xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Per lee xaa nanlabeyyt ma nanreket ma tich xaa, nxonn ma lo xaa, nel nanlabeyyt ma bos cheen stub naz xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús ngunii wdizh nabix ne lo re xaa, per lee re xaa namlata yek xaa, kwaan nzhekla xaa nii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús mbare nzhé lo re xaa: —Kwaane si wlipa na: Lee na nak mod tub pwert paro nded re mbakxiil. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Rese xaa kwaan mbid yilo lo na, nak tub xaa nlewann; per nambint re mbakxiil xtizh re xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Lee na nak mod roo pwert, nu lee xaa nrep kwent cheen na, le xaa gan yalnaban. Gak xaa mod tub mbakxiil ma nrep nu nroo nu nyazhal yixyi gaw ma. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Lee wann nebse nyiid lewann, nu gut, nu lux xaa ma; per lee na nyal zee wlipa ban gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Lee na nak mod xaa chul nkanap re mbakxiil. Lee xaa chul nkanap re xmbakxiil, nzaa xaa yalnaban cheen xaa kwent cheen re mbakxiil. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Per lee xaa nebse nzhex nka nkee zhiin, gorna ne xaa lee lob nze, zee nlaa xaa mbakxiil nu nxonn xaa nya xaa, nel nanakt xaa xaa nkela mbakxiil nu nel nanakt mbakxiil xma xaa. Nu lee lob nkiib re mbakxiil lo xaa nu nchech ma re ma. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Lee xaabyi zee nxonn, nel nebse nkwaan xaa yex ka xaa, nu nankelat xaa re mbakxiil. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Lee na nak mod xaa chul nkanap re mbakxiil. Modxa nlabeyy Xuz na na, nu nlabeyy na Xuz na, sbaaka nlabeyy na re xmbakxiil na nu lee re ma nlabeyy ma na. Nu na za yalnaban cheen na kwent cheen re xmbakxiil na. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Noka nkano na stub naz mbakxiil, ma nanakt korrel ne; nu noka nzhaal yaxii na re ma ne. Zee lee re ma ba gon xtizh na, nu yo ma tubka korrel nu tubka xaa kanap ma. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Lee Xuz na nkela na nel na nza yalnaban cheen na zee kayaa naya stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nik tub xaa nyent mod gut na, yet na nel sbaa nzhekla na. Nkano na yalnabeyy za na yalnaban cheen na nu kayaa naya stub welt. Kwaane mxaal Xuz na na le na. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Gorna lee re xaa mbin kwaane mbare mrexcho xaa stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Zyen doo re xaa mbezh: —¿Chozhiin nzhon gu xtizh xaa ba? Mbi mal nzho lextoo xaa, nzhak nachan yek xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Lee stub naz xaa mbezh: —Nik tub xaa nzho mbi mal lextoo nyent mod nii sbaa. ¿Napa nel tub xaa nzho mbi mal lextoo, nzho mod sekwen zaalo tub syeg? ");
INSERT INTO zpoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Re mbee nla nal, lee re xaa yezh Jerusalén kale yalni cheen xkyidoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nu Jesús nzo baa, naz roo korredor kwaan le Salomón. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Zee lee lak xaa mlo welt lo Jesús nu mnabdizh xaa lo xaa: —¿Axta cho gor zaa lu xkwent lu lo nu, zee yilo li lextoo nu? Chelee lu nak Crist, Xaa Xaal Dios Nabeyy, gunéya lo nu nal. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús mkeb nzhé: —Nguniila naya lo re gu, per nanlet gu krer xtizh na. Lee re kwaan nle na kwaan yalnabeyy cheen Xuz na, nlu sbaa naka. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Per lee re gu nanlet krera, nel nanakt gu xmbakxiil na. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Lee xaa nak mod xmbakxiil na nu nlabeyy ma bos cheen na, nu na nlabeyy re ma nu nreke ma tich na. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na nza yalnaban cheen na lo ma nu tira nayetra ma, nu zee nik tub xaa nyent mod kiib ma lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Lee Xuz na mzaa re ma lo na, nu lee xaa ngezh mas ke stub xaa, nu nik tub xaa nyent mod kiib ma lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Lee Xuz na nu na tubka nak nu. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Lee re xaa mbare mzen ke kee yenn xaa stub welt, ");
INSERT INTO zpoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","per Jesús nzhé lo re xaa: —Kwaan yalnabeyy cheen Xuz na mle na zyen doo kwaan wen lo gu. ¿Che kwent cheen kwaanzee, zaake gu na? ");
INSERT INTO zpoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Lee re xaa mkeb nzhé: —Nazaaket nu lu lo re kwaan wen mle lu, zaake nu lu lo re kwaan nawent nii lu. Lu nak tub xaabyi, per lee lu kale mod Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús nzhé: —Lee lo ley cheen be nkee: “Na nii, lee gu nak dios”. Sal. 82:6 ");
INSERT INTO zpoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nel lee Xkyech Dios nzhé nyent mod yé be nawlita, Dios mrole dios re xaa kwaan mkayaa xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nu chelee Dios mloxcho na nu mxaal xaa na yizhyo, ¿xomod nzho mod zaa gu kwent lee na mle tub kwaan nawent lo Dios, leezha ngunii na nak na Xgann Dios? ");
INSERT INTO zpoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Chelee na nalet na re kwaan nle Xuz na nawiit gu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Per chelee na nle na kwaan nle xaa, nixa nangwiit gu lo na per ble gu krer kwaan nle na, zee ne gu lee Xuz na nzo kwaan na nu na nzo kwaan Xuz na. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nu stub welt nzhekla xaa zen xaa Jesús, per mkaxlaan Jesús lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesús mbare naz stub ta yuu Jordán, nu mlaz xaa baa, pa mchubnis Juan. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Zyen doo xaa ngwa lo xaa, nu mbezh xaa: —Wlipa, Juan namlet nik tub kwaan gro, per rese kwaan nguné Juan cheen xaa ne wli. ");
INSERT INTO zpoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Zyen doo xaa mzelo ngwii lo Jesús naz baa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ngu tub xaabyi ne nzak, xaa le Lach, xaa yezh Betania. Mari nu Mart, me nak leeka bzan Lach, nzho leeka yezh ba. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari mchub perfum kwaan chul nzebech nii Xaa Nabeyy, nu msekwizh meya kwaan yich yek me. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Zee mxaal rop bal me xaa yé kwaane lo Jesús: —Me Nabeyy, lee xmig lu ne nzak. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Gorna mbin Jesús kwaane, nu né xaa: —Lee yalyizh ne nazhint nebse lo yalgut, sinka noka leya sirb luu lee yalnabeyy cheen Dios nak tub kwaan gro, nu xomod gro nak yalnabeyy cheen Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nu nixa nkedoola Jesús rop bal Mart nu Lach, ");
INSERT INTO zpoNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","mlaz xaa xchop mbizh pa nzo xaa, leezha mbin xaa kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Zeera né xaa lo re nu, xaa mseed lo xaa: —Ya be stub welt yizhyo Judea. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Zee lee re nu nzhé lo xaa: —Maestr, nalsi lee re sawlazh be, re xaa nzho yizhyo ba nzhekla ngut lu kwaan ke, nu seesa nzhekla lu ya lu baa stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús né: —Wli na nii na, lee tub mbizh nkano chiibchop gor pa nzaaya xni. Chelee tub xaa ze zhe, naralt nii xaa, nel nkano xaa xni cheen yizhyo ne; ");
INSERT INTO zpoNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","per chelee tub xaa ze yaal, nral nii xaa, nel nyent xni lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ngulo ngunii xaa sbaa noka né xaa: —Lee xmig be Lach naxna, per na yalexche xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Zee nzhé nu: —Xaa Nabeyy, chelee xaa naxna xaa, zee yakwen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Per lee kwaan né Jesús lo nu, nak lee Lach ngut, nu lee nu seetaka kale xgab lee xaa naxna. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Zeera klar nguné Jesús lo re nu: —Lee Lach ngutla. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nu nyakla na nel namzot na baa, nel snee ne re gu lee na nak Xaa Mxaal Dios Nabeyy. Chaa gu, yasewii be lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Zee lee Max, xaa nii re xaa “Kwech”, né lo stub naz nu, xaa mseed lo Jesús: —Chaa ya re be zee noka re be yet kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Gorna mzhin Jesús, ngune xaa lee Lach nzhala tap mbizh mkaach xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nu yezh Betania nzhi gax Jerusalén, kan chon kilómetro, ");
INSERT INTO zpoNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","zee zyen xaa nzho Jerusalén ngwa nguseleyy Mart nu Mari nel ngut bzan me. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Gorna ngune Mart lee Jesús mzezhin baa, mroo me garli me zee mzhaal me kwaan lee xaa; per lee Mari mlakeka leen yoo. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Lee Mart nzhé lo Jesús: —Me Nabeyy, chol nzo lu nee, nangeta bzan na. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Per nixa nala, na ne lee Dios zaa kwaan naab lu lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús mkeb nzhé: —Lee bzan lu ban stuba. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mart nzhé: —Wliya, nela na, lee xaa ban stub mbizh kwaan roban re xaa ngut, mbizh gwluzhtlaka. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Zee lee Jesús nzhé: —Lee na nak yalmroban nu yalnaban. Loka xaa wii lo na, nixa yet xaa lee xaa ban; ");
INSERT INTO zpoNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","nu lee xaa seetaka mban, xaa ngwii lo na tira nayeta xaa. ¿Che nzak lu wli kwaane? ");
INSERT INTO zpoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Lee me nzhé: —Nle na krera, Me Nabeyy. Ne na lu nak Crist, Xgann Dios, Me Mxaal Dios Nabeyy, me nak kwent yaad yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Gorna ngulo nzhé xaa kwaane, Mart ngwa nguchezh bal me Mari, nu nzhé meya lo bal me xlaan: —Lee Maestr nzo nee nu kabezh me lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Gorna mbin Mari kwaane, lijer nguxso me nu ngwa me lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Lee Jesús zeeraka zeeb leen yezh; nu nzoka xaa pa mzhaal Mart xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Gorna ngune re xaa kaseleyy Mari, lee Mari lijer nguxso, nu mreke re xaa tich me, mle xaa xgab lee roo xbaa Lach ya me yayonn me. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Gorna mzhin Mari pa nzo Jesús, mkichxub me lo xaa nu nzhé me: —Me Nabeyy, chol nzo lu nee, nangeta bzan na. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Gorna ngune Jesús nzhonn Mari, nu noka nzhonn re xaa nzhake tich me, nales doo ngok lextoo Jesús, ");
INSERT INTO zpoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","nu mnabdizh xaa: —¿Pa msebyo gu xaa? Lee re xaa nzhé: —Xaa Nabeyy, te, zee wii lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nu mbinn Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Lee re xaa nzhé: —¡Wii gu lo xaa, nkedoola xaa Lach! ");
INSERT INTO zpoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Per lak xaa mbezh: —Lee xaa ne msekwen zaalo syeg, ¿che nyent mod ngle xaa tub kwaan zee nangeta Lach? ");
INSERT INTO zpoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Stub welt Jesús nales doo nzhak lextoo xaa, gorna mbii xaa roo baa. Baa ne nak tub yiloo, kwaan nyaaw roo kwaan tub ke. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nu Jesús nzhé: —Bre gu ke. Mart bzan ntagol nzhé: —Me Nabeyy, ech nawent nlaa me, nzhala tap mbizh ngut me. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús mkeb nzhé: —¿Che nanit na lo lu, chelee lu wii lu lo na, ne lu lo re kwaan chul cheen Dios? ");
INSERT INTO zpoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mre xaa ke, nu Jesús mwii naz yiba nu nzhé: —Xuz, za na dixkix lo lu nel mkenzha lu xtizh na. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na ne tubka nkenzha lu xtizh na; per nii naya zee lee re myet, xaa nzo nee, ne lee lu mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Gorna ngulo ngunii xaa kwaane, dublegan nzhé xaa: —¡Lach broo baa! ");
INSERT INTO zpoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nu lee xaa ngut mroo nduuzh nral ler, nu noka yek xaa nral ler. Jesús nzhé: —Bxek gu xaa nu laa gu nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kwaane mle, zee zyen sawlazh nu, xaa nguseleyy Mari, mzelo ngwii lo Jesús nel ngune xaa kwaan mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Per lak xaa ngwa lo re xaa fariseo, nu nzhé xaa kwaan mle Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kwaanzee lee re ngwleyy non nu re fariseo mdop re xaa nak zhiin, nu nzhé xaa: —¿Cho kwaan le be? Zyen doo nseyn kwaan gro doo kale xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Chelee be laa be xaa, rese xaa zelo wii lo xaa, nu napa lee xaa yezh Roma, xaa nabeyy be, kayiid nu kalux xaa kwaan nkano be nee nu yezh cheen be. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Per lee tub xaa nzo lo re xaa ba, xaa le Caifás, xaa nak ngwleyy non doo liin zee, nzhé lo re xaa: —¡Re gu nanet nik tub kwaan! ");
INSERT INTO zpoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Chozhiin nanzeent re gu kwaane? ¡Mas wen yet tubka xaa kwent cheen re xaa yezh, ke rese xaa yezh yet! ");
INSERT INTO zpoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ngunii Caifás lee Jesús yet kwent cheen re xaa, nu ngunii xaa wdizh kwaan mzaa Dios lo xaa, nel lee xaa nak ngwleyy non doo liin zee nu namroota leeka yek xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nu nayeta Jesús nebse kwent cheen re nu, xaa Israel, sinka noka zee chaal Dios re xaa nzho stub yezh zee gak re xaa tubka yezh cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nu snee axta mbizh zee lee re xaa non nzho yek gut Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kwaanzee, Jesús nanzotra klar lo re sawlazh nu, xaa non, nya xaa naz tub yezh kwaan nzhi gax naz wen, yezh kwaan le Efraín. Baa mlaz xaa kwaan re nu, xaa mseed lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nu merla zhin yalni cheen Paskwa, pa nselazh nu xomod mloo Dios re xey nu Egipto, nu zyen nu, xaa rete yezh, nroo nzha naz Jerusalén zee le nzhul nu nu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Zee re xaa ne kakwaan Jesús lo yalni, nu nabdizh re xaa lo wechxinn xaa lach roo yidoo: —¿Cho kwaan nzak gu? ¿Che zyiid xaa o nayiidt xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Lee re fariseo nu re ngwleyy non, mnabeyy zee loka xaa ne lo Jesús, yé xaaya lo xaa, zee zen xaa xaa zee ko xaa xaa lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Xop mbizh nzho jwalt la yalni cheen Paskwa, leezha mbid Jesús yezh Betania pa nzho Lach, xaa mseban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nu baa mle xaa tub yalni cheen Jesús; Mart ngo kwaan leen yann, nu lee Lach kayaw kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari mbidno rol litr perfum kwaan chul nzebech cheen tub yeey kwaan le nardo, kwaan non doo, nu mchub meya nii Jesús nu msekwizh meya kwaan yich yek me. Nu dubse leen yoo mzebech chul doo. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Zee lee Judas Iscariote, tub xaa lo re nu, xaa mseed lo Jesús, ngulola mle xaa xgab zaa xaa Jesús lo re xaa nayii ne Jesús. Nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Chozhiin namtot me kwaane tub lal demi kwaan nle tub xaa gan kee xaa zhiin tub liin, zee zaa beya lo re xaa prob? ");
INSERT INTO zpoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Per nixa snee nzhé Judas per nanakta nel nkela xaa re xaa prob, nzhé xaaya nel nak xaa tub xaa nlewann, nu nel lee xaa nkanap bools cheen re xdemi nu, xaa Jesús, nu nlewann xaa rese demi kwaan nla. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nu Jesús nzhé: —Laa le meya, nel cho na mlochaw meya, zee chul nzebech cho na gorna kaach xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Lee re xaa prob tubka nzo lo re gu, per na nazot tubka lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zyen xaa lazh nu mbin lee Jesús nzo yezh Betania, nu ngwa xaa baa, zee ne xaa lo Jesús nu lo Lach, xaa mroban. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Zee lee re ngwleyy non myaan noka Lach gut xaa, ");
INSERT INTO zpoNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","nel kwent cheen Lach, zyen xaa lazh nu mlaa re ngwleyy nu mzelo xaa ngwii lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lee stub mbizh mbin re xaa lee Jesús zhin yezh Jerusalén. Zyen doo xaa ngwa Jerusalén, kwent cheen yalni cheen Paskwa, ");
INSERT INTO zpoNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","zee mchoog re xaa lag yagyin nu mroo re xaa leen yezh zee kayaa xaa Jesús, zee nzhé re xaa dublegan: —¡Chul doo! ¡Goll be lo xaa nze kwaan yalnabeyy cheen Xaa Nabeyy! ¡Goll be lo xaa nak Rey cheen be, xaa Israel! ");
INSERT INTO zpoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús ngune lo tub burr yeen nu mzob xaa tich ma; zee gaka modxa nkee lo Xkyech Dios: ");
INSERT INTO zpoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Nazhebt gu xaa yezh Sión. Wii, lee Rey cheen gu nze nzob tich tub burr yeen. Zac. 9:9 ");
INSERT INTO zpoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Gorzee lee re nu, xaa mseed lo xaa, namzeent re kwaan kaded; per gwluzh gorna ngulo mbare Jesús naz yiba, zee mselazh nu re kwaane, kwaan nzaa Xkyech Dios kwent cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lee re xaa mzo kwaan Jesús leezha mrezh xaa Lach leen baa, nu mseban xaa xaa, re xaa ne mzaa kwent re kwaan ngune xaa ngok. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kwaanzee, lee re myet mroo mzhaal kwaan Jesús, nel mbin re xaa re kwaan gro kwaan mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Per lee re fariseo mbezh lo wechxinn: —¿Che ngwii gu? ¿Cho gan le re be? ¡Rese myet nzhake tich xaa ba! ");
INSERT INTO zpoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lo re myet, xaa ngwayoll lo Dios Jerusalén, ngu lak xaa nanakt xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Lee re xaa ne mbii lo Lip, xaa nak yezh Betsaida, tub yezh cheen Galilea, nu mnabdizh xaa lo xaa, nzhé xaa: —Nzhekla nu ne nu lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Lip ngwa nzhéya lo Ndres, zee rop xaa ngwayéya lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Zee nzhé Jesús lo xaa: —Mzhinla gor lee Dios luu lee Xgann xaa non doo nak. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wlipa na nii na lo gu, chelee tub nzhobxtil nalat lo yo nu nayebt xaba, nazaata xle; per cheleeya laya lo yo nu yeb xaba, zeesi zaaya zyen doo nzhobxtil. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Lee xaa nkela yalnaban cheen lux xaa yalnaban cheen xaa; per lee xaa nankelat yalnaban cheen xaa lo yizhyo ne, le xaa gan yalnaban cheen xaa kwaan tira naluxt. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Chelee tub xaa nzhekla kee zhiin lo na, reke xaa tich na; nu loka pa zo na, baa zo xaa kwaan nkee zhiin lo na. Chelee tub xaa kee zhiin lo na, lee Xuz na le non xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’¡Nales doo nzhak lextoo na nal gorne! Nu nanet na cho kwaan nii na. Nzho mod nii na: “Xuz, nalat lu deed na bid ne”. ¡Per kwaane deed na, zee nzhal na! ");
INSERT INTO zpoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Xuz na, ble non le lu”. Zee ngu tub bos naz yiba kwaan nzhé: —Mle nonla naya, nu le non naya stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nu mkenzha re myet nzhi baa kwaane, zee lak xaa nzhé: —Ngwzi ngoch. Per zlak xaa nzhé: —Tub mandad cheen Dios ngunii lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús nzhé lo re xaa: —Nanakta kwent cheen na zee ngunii xaaya, sinka ngunii xaaya kwent cheen re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nal nak gor naab xaa kwent lo re myet yizhyo ne, nal nak gor koo xaa xaa nabeyy yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Per gorna kee xaa na lo krus, leeka na le zee rese myet yiid lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Snee mzaa xaa kwent xomod yet xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lee re myet mkeb lo xaa nzhé: —Lo ley cheen Dios nlu lee Xaa Xaal Dios Nabeyy tubka nzo. ¿Xomod nak kwaan nii lu, lee Xaa Mzhin Ngok Myet nkin kee lo krus? ¿Cho nak Xaa Mzhin Ngok Myet, xaa nzaa lu kwent? ");
INSERT INTO zpoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús nzhé: —Nzoka xni lo gu nal, per naxchetra zoya. Bze gu nalsi nkee xni, zee nalat yalnakaw lo gu mod tub kwaan nankambazt gu; nel lee xaa nze lo yalnakaw nanet xaa pa naz nzha xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bwii gu lo xni nal, nel nzokaya lo gu, zee gak gu xinn xaa nak xni. Gorna ngulo nzhé Jesús re kwaane, nya xaa nu mkaxlaan xaa lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nu nixa mle Jesús zyen doo kwaan gro doo delant lo re xaa, per nangwiit re xaa lo xaa; ");
INSERT INTO zpoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","nel snee zee mbarlo kwaan mkee Chay, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, leezha mkee xaa: Xaa Nabeyy, namkayaat xaa re wdizh kwaan nzaa nu kwent, nixa nle lu re kwaan gro doo lo xaa. Is. 53:1 ");
INSERT INTO zpoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kwaanzee namwiit xaa lo xaa, nel noka mkee Chay: ");
INSERT INTO zpoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nu mod xaa nanyenit lo nzhak xaa, zee nyent mod gon xaaya, zee nyent mod wii xaa loya, zee nyent mod laya lextoo xaa, kwaane nle zee nambaret xaa lo na zee nasekwent na xaa. Is. 6:10 ");
INSERT INTO zpoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Chay nzhé re kwaane, nel ngune xaa lo yalnabeyy cheen Jesús, zee mzaa xaa kwent cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Per nixa sneeya, zyen xaa lazh nu, xaa non, mzelo ngwii lo Jesús, per nzheb xaa yé xaaya, nel nzheb xaa ne xaa re fariseo, napaka goo xaa xaa pa nseed re nu xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nel mas nyula re xaa kwi wen xaa kwaan myet ke kwaan Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús ngunii dublegan nzhé: —Loka xaa nzhon kwaan nii na, nanzhont xaa nebse kwaan nii na sinka noka nzhon xaa kwaan nii Xuz na, xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nu loka xaa nlu na lo, noka nlu xaa mxaal na lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na nak kwenta xni, nu myal na yizhyo ne zee wii re xaa lo na, zee nalaket xaa lo yalnakaw. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Per lee xaa kwaan mbin xtizh na, nu nanlet kwaan nii na, nanaabt na kwent lo xaa; nel lee na namyalt naab kwent lo re myet, sinka lee na myal koo re myet lo yalgut. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Lee xaa nankayaat na nu nanlet re kwaan nii na, leeka re kwaan ngunii na naab kwent lo xaa mbizh gwluzhtlaka. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nel nanguniit na kwaan nzhekla na; sinka lee na ngunii kwaan kwaan mnabeyy Xuz na na, xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nu ne na lee kwaan mnabeyy Xuz na nak, zee le re xaa gan yalnaban kwaan tira. Kwaanzee lee kwaan nii na, nii naya mod nguné Xuz na lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nu yilo gorna merla la yalni cheen Paskwa, Jesús nela mzhinla gor laa xaa yizhyo ne, zee nya xaa yo xaa kwaan Xuz xaa. Nel tant nkedoola xaa re xaa xaa, xaa nzhi lo yizhyo ne, zee mlu xaa dubse yalnkela cheen xaa lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Gorna kayawxchee re xaa, lee Maxuu mlola xgab yek Judas Iscariote, xgann Simón, zee zaa xaa Jesús lo re xaa gut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús nela lee Jesús nze naz lo Dios nu lo Dios bare xaa stuba; nu lee Xuz xaa mzaa dubse yalnabeyy lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Zee snee gorna kayawxchee re xaa, nguxso xaa roo mes nu mlache xaa tub ler nak xaa, nu mzhi xaa tub tway leen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Zeera mlo xaa nis leen tub bandej, nu mzelo xaa mdeeb xaa nii re nu, xaa mseed lo xaa, nu nsekwizh xaaya kwaan tway kwaan mzhi xaa leen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Gorna nzha xaa keeb xaa nii Simón Pér, xaa ne nzhé lo xaa: —Xaa Nabeyy, ¿napa nel lu keeb nii na? ");
INSERT INTO zpoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús mkeb nzhé: —Nal nanlat kwaan kale na yek lu, per gwluzh laya yek lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pér nzhé: —¡Tira nazeyalt na keeb lu nii na! Jesús mkeb nzhé: —Chelee na nakeebt na nii lu, nyent mod gak lu xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pér mkeb nzhé: —¡Cheleeya sbaaya, Xaa Nabeyy, nakeebta lu nebse nii na, noka bsenag na nu noka bseguch na! ");
INSERT INTO zpoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Per Jesús mkeb nzhé: —Lee xaa ngozla, nankintra gaz xaa stuba, nel nzhula na xaa. Nu nzhul na re gu, per nixa naretlaka gu nzhul na. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Leezha nzhé xaa: “Naretlaka gu nzhul na”, snee nzhé xaa nel nela xaa xana xaa zaa xaa lo re xaa gut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Gorna ngulo mdeeb Jesús nii re xaa, nu ngok xaa xab xaa nu mbare xaa roo mes stub welt nu nzhé xaa lo re xaa: —¿Che mla kwaan mle na yek gu? ");
INSERT INTO zpoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lee re gu nii lo na Maestr nu Xaa Nabeyy, nu wen nle gu nii guya sbaa, nel nak naya. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mdeeb na nii re gu, nixa nak na Xmaestr gu nu Xaa Nabeyy lo gu, zee noka re gu nzhaal keeb nii wechxinn gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mle na kwaane, zee ne gu xomod nzhaal le gu, zee le gu kwaan mlu na lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wlipa na nii na lo gu, nik tub mos nanont mas ke xpatron xaa, nu nik tub xaa nanakt mas non ke xaa mxaal xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chelee gu nla re kwaane yek gu, ble guya zee chul ded gu. Noka Jesús nzhé: ");
INSERT INTO zpoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","—Nakazat na kwent cheen rese gu, nel nela na xana re xaa mleey na. Per nzhaal gak kwaan nkee lo Xkyech Dios: “Lee xaa kayaw kwaan na, gak xkontrad na”. Sal. 41:9 ");
INSERT INTO zpoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nii na kwaane lo gu, zee gorna gaka, zee wii gu lo na mod Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Wlipa na nii na, loka xaa wii lo xaa mxaal na, noka ngwii xaa lo na, nu xaa ngwii lo na, noka ngwii xaa lo xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Gorna ngulo nzhé Jesús kwaane, tira nawent ngok lextoo xaa, zee nzhé xaa: —Wlipa na nii na, lee tub gu zaa na lo re xaa gut na. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Zee lee re nu, xaa mseed lo xaa, mzelo mwii lo wechxinn, nu nanet nu xana xaa kazet. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Lee na, xaa nkedoola Jesús, nzo xkwes xaa, ");
INSERT INTO zpoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","nu Simón Pér mle nseyn lo na zee nabdizh na, ne xana xaa kazaa xaa kwent. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Zee mbii na gaxra lo Jesús, nu mnabdizh na: —Xaa Nabeyy, ¿xana xaa ne? ");
INSERT INTO zpoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús mkeb nzhé: —Lebsii na tik pan, nu loka xaa za naya gaw, xaa zeeya. Gorzee mlebsii xaa tik pan nu mzaa xaaya lo Judas Iscariote, xgann Simón. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nu gorna mzen Judas pan nu ndaw xaaya, gorzee mzeeb Maxuu lextoo xaa. Jesús nzhé: —Ble kwaan nzhaal le lu, zoza leya. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Per rese stub naz xaa, namlata yek chozhiin nzhé xaa kwaane lo Judas. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas nak xaa kwaan nzen xdemi re nu, nu lak xaa mle xgab, mxaal xaa xaa yazii xaa tub kwaan nkin re nu lo yalni o lo re xaa prob nyazaa xaa tub kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Gorna ngulo mzen Judas pan nu ndaw xaaya, ta mroo xaa. Nu mchoola yizhyo gorzee. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Gorna ngulo mroo Judas, Jesús né: —Mzhinla gor lee re xaa wii respet lo na, Xaa Mzhin Ngok Myet, nu sneeka wii xaa respet lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nu chelee na le zee wii re xaa respet lo Dios, noka Dios le zee wii re xaa respet lo na, Xaa Mzhin Ngok Myet; nu merla le xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Re gu nak mod xiin na, nu nanzotra na xche lo re gu. Zee lee re gu kwaan na, per leeka kwaan nzhé na lo re xaa sawlazh be, nii na lo re gu nal, nyent mod ya gu pa nya na. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nu tub kwaan kub nabeey na lo gu le gu nal: Bkela gu tub gu stub gu, kwentaxa nkela na re gu, sbaaka nzhaal kela gu tub gu stub gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chelee gu kela gu tub gu stub gu, xaa dubse yizhyo ne lee gu nak xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pér mnabdizh lo Jesús: —Xaa Nabeyy, ¿pa nya lu? Jesús mkeb nzhé: —Lee pa nya na, nyent mod ya lu nal, per yiid lu gwluzh. ");
INSERT INTO zpoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pér nzhé: —Xaa Nabeyy, ¿chozhiin nyent mod reke na tich lu nal? ¡Listla nzo na yet na kwent cheen lu! ");
INSERT INTO zpoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús mkeb lo xaa nzhé: —¿Che wlipa lu yet lu kwent cheen na? Per wli na nii na lo lu, zeeraka kozhe gaay lee lu yé chon welt nanlabeyyt lu na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Nalenalest gu lextoo gu. Ngwii gu lo Dios noka bwii gu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lee garli Xuz na nzho zyen doo pa yo xaa; nu chol nanakta snee, nangniit naya lo gu; nu nya na dexkwaa na tub pa yo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nu gorna yilo nya na dexkwaa na pa yo gu, zee bare na stub welt yaadxii na gu, zee zo re gu pa nzo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nu nlabeyy re gu naz kwaan nzhin axta pa nya na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Max nzhé lo Jesús: —Xaa Nabeyy, nanet nu pa naz nya lu, ¿xomod ne nu naz? ");
INSERT INTO zpoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús mkeb nzhé: —Leeka na nak mod tub naz, nu nak na re kwaan wli, nu leeka na nak yalnaban kwaan tira. Nik tub xaa nyent mod zhin lo Xuz na, cheleeya nanakta kwent cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Chelee re gu nlabeyy na, noka nlabeyy gu Xuz na. Nu nal nlabeyy gu xaa nel ngune gu lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Zee lee Lip nzhé: —Xaa Nabeyy, nebse kwaan naab nu nak, laa ne nu lo Xuz lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Zee lee Jesús nzhé lo xaa: —Lip, nzhala mbizh nzo na lo re gu, ¿che zeeraka labeyy lu na? Loka xaa kwaan ngwii lo na ngwii lo Xuz na; ¿chozhiin naab lu, laa na ne gu lo Xuz na? ");
INSERT INTO zpoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Che nanlet lu krer lee Xuz na nzo kwaan na nu na nzo kwaan Xuz na? Lee re kwaan nii na naniit naya kwent cheen na. Rese kwaan nle na nak xcheen Xuz na nel lee Xuz na tubka nzo kwaan na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nu ne gu lee na nzo kwaan Xuz na, nu lee Xuz na nzo kwaan na; nu kwent cheen re kwaan gro kwaan nle na, nzhaal wii gu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Wlipa na nii na lo gu, loka xaa tubka ngwii lo na, le xaa rese kwaan nle na; nu le xaa stub naz kwaan mas gro, nel lee na nya lo Xuz na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nu rese kwaan naab gu lo na, nel ngwii gu lo na, na leya; zee wii re xaa respet lo Xuz na kwent cheen re kwaan nle na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Rese kwaan naab gu lo na, za naya, nel ngwii gu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Chelee re gu nkela gu na, le gu re kwaan nabeey na le gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Zee naab na lo Xuz na zee xaal xaa stub xaa zo kwaan gu, le xaa yudar gu. Xaa ne nak mer Mbi Naban kwaan wli, nu tubka zo xaa kwaan re gu. Lee xaa yizhyo nyent mod kayaa xaa, nel nanyunt xaa lo xaa nu nanlabeyyt xaa xaa; per lee re gu nlabeyy gu xaa, nel gax nzo xaa lo re gu, nu tira yo xaa lextoo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Nalat na re gu mod ngwzeb, nel bare na stub welt zee zo na kwaan re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xepse lee re xaa yizhyo nanetra lo na; per lee re gu ne lo na nu mban gu nel mban na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mbizh zee lee re gu ne, lee na nzo lo Xuz na nu re gu nzo kwaan na, nu na nzo kwaan re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Loka xaa kayaa re kwaan nabeey na nu le xaaya, nlu xaa wlipa nkela xaa na. Nu lee Xuz na nkela xaa nu noka na nkela xaa nu nlu na na lo xaa zee labeyy wen xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (xaa nanakt Iscariote) mnabdizh lo Jesús nzhé: —Xaa Nabeyy, ¿chozhiin luu lu lu lo re nu, nu nalut lu lu lo re xaa yizhyo? ");
INSERT INTO zpoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús mkeb nzhé: —Xaa nkela na nzhon xaa xtizh na; nu nkela Xuz na xaa zee lee rop Xuz na yiid yo kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Lee xaa nankelat na, nanzhont xtizh na. Lee re wdizh kwaan kakenzha gu nal, nanakta xtizh na, Leeya nak xtizh Xuz na, xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Kanii na rese kwaane lo gu nal nzoka na lo re gu; ");
INSERT INTO zpoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","per lee Mbi Naban, Xaa Seleyy gu, xaa xaal Xuz na kwent cheen na, lee xaa seed re gu rese kwaan, nu le xaa selazh gu rese kwaan nguniila na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Gorna nya na, na le zee nalet gu xgab, nu lee na le zee wen gak lextoo gu; nu le naya tub mod nyent mod le re xaa yizhyoya. Kwaanzee nagak nalest gu lextoo gu, nixa nazhebt gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mbinla gu ngunii na, nya na nu bare na zo na kwaan re gu stub welt. Chelee gu wlipa nkela gu na, chul gak lextoo gu gon gu lee na nya lo Xuz na, nel lee xaa nak xaa nonra lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Zeeraka gak re kwaane nguniila naya lo gu, zee gorna gaka, zee wii re gu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Nawdizhtra na xche kwaan re gu, nel nzela xaa nabeyy yizhyo ne. Nixa nanakt xaa tub xaa nabeyyra lo na, ");
INSERT INTO zpoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","per snee nzhaal gaka, zee lee re xaa yizhyo ne, ne lee na nkela Xuz na nu nle na re kwaan mxaal xaa na. Zee nzhé Jesús: —Guxso gu, nu chaa nya be. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús seetaka nii nu nzhé: —Lee na nak kwenta tub xan yag ub kwaan wlipa, nu Xuz na nak kwenta xaa nxeen na. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Chelee tub re ram, nanzaat xle, tira choog xaaya. Per chelee tub ram nzaa xle, nle nzhul xaaya zee zaaya mas zyen xle. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Sbaa mle nzhula na re gu kwaan re wdizh kwaan ngunii na lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tubka sbaa zo gu kwaan na, mod tubka nzo na kwaan re gu. Kwenta tub ram nyent mod zaaya xle chelee nanzobta cho yag; sbaaka nyent mod zaa re gu xle chelee gu nanzot gu tubka kwaan na. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Lee na nak mod xan yag nu re gu nak mod re ram cheen na. Loka xaa tubka nzo kwaan na, nu na tubka nzo kwaan lee xaa, zaa xaa zyen doo xle; nel chelee nyent na nyent mod le gu nik tub kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Lee xaa kwaan nanzot tubka kwaan na, nak kwenta tub ram kwaan nanzobtra cho yag, kwaan mchoog xaa nu mlebi xaa zee bizha, nu zeera top xaaya koo xaaya lo ki. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Chelee re gu tubka zo kwaan na, nu nali zo gu lo re kwaan mseed na gu, bnaab gu re kwaan nzhekla gu zee kayaa guya. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wii re xaa respet lo Xuz na gorna lee re gu nzaa zyen xle, zee gak gu xaa wlipa nseed lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nu nkela na re gu modxa nkela Xuz na na; tubka bzo gu lo yalnkela cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Chelee gu gon gu re kwaan ngunii na lo gu, zee tubka nzo gu lo yalnkela cheen na; modxa nzhon na xtizh Xuz na, re kwaan mnabeyy xaa le na, nu tubka nzo na lo yalnkela cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Nii na kwaane lo gu, zee yo yalnix cheen na lextoo gu, zee tubka gak chul lextoo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lee kwaan nabeey na gu nak kwaane: Kela gu tub gu stub gu modxa nkela na gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lee yalnkela kwaan grora lo reya, nlu xaa leezha yet xaa kwent cheen xmig xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Re gu nak xmig na, chelee gu nle gu re kwaan mnabeey na gu le gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nal naniitra na lo gu nak gu xmos na, nel lee mos nanet cho kwaan nle xaa nabeyy lo xaa. Mig, nii na lo gu, nel rese kwaan nguné Xuz na lo na nguniila naya lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Namleeyt re gu na, nel na mleey re gu nu mza na zhiin lo gu, zee zaa gu zyen doo xle nu lee xle kwaan zaa gu dii tira. Nu snee lee Xuz na zaa rese kwaan naab gu lo xaa kwaan yalnabeyy cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kwaane nak kwaan nabeey na gu: Kela gu tub gu stub gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Nzhekla na ne gu, chelee re xaa yizhyo nayii ne re gu, yilo na, nayii xaa ne xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Chol xaa yizhyo nak gu, kedoola re xaa yizhyo gu, mod nkela xaa re xaa nak xaa xaa. Per na mleey gu lo re xaa yizhyo nu kwaanzee nayii re xaa yizhyo ne, ne gu, nel nanaktra gu xaa yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bselazh gu kwaan nii na lo gu: “Nik tub mos nanont mas ke xaa nabeyy lo xaa”. Chelee xaa nrenal xaa na, noka re gu renal xaa; nu chelee xaa mbin xaa xtizh na noka gon xaa xtizh gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Snee le re xaa gu kwent cheen na, nel nanlabeyyt re xaa xaa mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Nik tub kulp nangabt re myet, chol na nangalt ngnii lo re xaa. Per nal nkano xaa kulp. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Loka xaa nayii ne na noka nayii xaa ne xaa Xuz na. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nik tub kulp nagabt re xaa ne, chol nanglet na re kwaan gro kwaan nik stub xaa nyent mod le. Per nal lee re xaa nela kwaane, nu nixa sneeya nayii xaa ne xaa na nu noka nayii xaa ne xaa Xuz na. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Per re kwaane gak nel nzhaal gak re kwaan nkee lo ley: “Nyent cho kwaan, nu nayii re xaa ne xaa na”. Sal. 35:19; Sal. 69:4 ");
INSERT INTO zpoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Per gorna yiid Xaa Seleyy gu, Mbi Naban kwaan wli, lee xaa zaa kwent cheen na lo re gu. Xaal na xaa gorna zo na lo Xuz na, nel lo Xuz na roo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nu noka re gu nzhaal zaa kwent cheen na, nel mzo gu kwaan na axta yilo. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Nii na re kwaane lo re gu, zee nik tub kwaan nalet zee ral nii gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Koo xaa gu pa nseed be xtizh Dios, nu leezha zhin gor loka cho xaa gut gu, nel nle xaa xgab snee kale xaa tub kwaan nyula Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Le xaa kwaane nel zer labeyy xaa Xuz na nu na. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nii na kwaane zee gorna zhin gor ne, selazh gu ngulola ngunii naya lo re gu; nangniit na kwaane lo re gu yilo nel nzoka na kwaan re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jesús seetaka kanii nu nzhé: —Per nal nya na zee zo na kwaan xaa mxaal na, nu nik tub gu nanabdizht lo na pa nya na; ");
INSERT INTO zpoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","leel nales ngok lextoo gu nel ngunii na re kwaane lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Per kwaan wli ngunii na lo gu, mas wen nya na. Nel chelee na nanyat na lee Xaa Seleyy gu, nyent mod zo kwaan gu; per chelee nya na, xaal na xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Gorna lee xaa yaad, luu xaa re kwaane lo re myet yizhyo: xana re kwaan nawent, xana re kwaan nali, nu xomod naab Dios kwent lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Lee Mbi Naban luu lo re xaa nawent nak xaa, nel nangwiit xaa lo na; ");
INSERT INTO zpoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","lee Mbi Naban luu lo re xaa kwaan nak kwaan nali, nel nya na lo Xuz na nu nanetra re gu lo na; ");
INSERT INTO zpoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","nu Mbi Naban luu lo re xaa xomod naab Dios kwent lo re xaa yizhyo ne, nel ngulola ngunaab xaa kwent lo xaa nabeyy yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Nkano na zyen doo kwaan nii na lo re gu, per nyent mod nii na reseya lo gu nal, nel nyent mod la reya yek gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Per gorna yaad Mbi Naban, xaa wli, lee xaa luu re kwaan wli lo gu; nel naniit xaa kwaan nzhekla xaa, nii xaa rese kwaan gon xaa, nu né xaa re kwaan ded lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Lee xaa le zee wii re xaa chul lo na, nel lee xaa luu re kwaan wli cheen na lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Rese kwaan nak cheen Xuz na nak cheen na; kwaanzee nii na lo re gu, lee Mbi Naban luu re kwaan wli cheen na lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Xepse nanetra gu lo na, per xep gwluzh bare gu ne gu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Zee lee lak nu, xaa mseed lo xaa, mzelo nabdizh lo wechxinn: —¿Cho kwaan nzhekla xaa né xaa kwaan re kwaane? Né xaa, xepse nanetra be lo xaa, nu xep gwluzh bare be ne be lo xaa, che naka nel nya xaa pa nzo Xuz xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Cho kwaan nzhekla xaa né xaa “xep gwluzh”? Nanet be cho kwaan kanii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús mzeen lee re nu nzhekla nabdizh lo xaa, zee né xaa lo re nu: —Lee na nii lo re gu, xepse nanetra gu lo na, nu xep gwluzh bare gu ne gu lo na. ¿Che nanlat kwaane yek gu? ");
INSERT INTO zpoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wlipa na nii na, lee re gu goon nu nales doo gak lextoo gu, gorna lee re myet yizhyo gak chul doo lextoo. Per gorna gak nales lextoo gu, lee yalnales gak yalchul. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Gorna lee tub ngwnaa gal xinn, ne lextoo me nel merla zhin gor gal xinn me, per gorna ngulo ngol xinn me, nyenlazh me yalne, nu chul doo nzhak lextoo me, nel ngol xinn me. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nu leeka snee nales nzhak lextoo re gu nal; per bare na zhaal na re gu stub welt, nu zee lee lextoo gu nix doo gak, tub mod kwaan nik tub kwaan nu nik tub xaa nyent mod le zee nales gak lextoo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Mbizh zee nanaabt gu nik tub kwaan lo na. Wlipa na nii na, lee Xuz na zaa rese kwaan naab gu lo xaa kwent cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Axta nal nik tub kwaan zer naab gu kwaan yalnabeyy cheen na; naab guya zee kayaa guya, zee chul gak lextoo gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Nii na re kwaane lo gu, nu nlu naya lo gu kwaan kwent nabix; per yo tub mbizh nalutra naya lo gu kwaan kwent nabix, sinka klar nii naya lo gu mod nak Xuz na. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mbizh zee lee re gu naab kwaan kwent cheen yalnabeyy cheen na; zee nankint yé naya lo Xuz na kwent cheen gu, ");
INSERT INTO zpoNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","nel lee Xuz na nkela re gu. Nkela xaa re gu nel nkela gu na, nu nel ne gu lee na nzhal naz lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mroo na lo Xuz na zee myal na yizhyo ne, nu nal laa na yizhyo ne, zee nya na naz lo Xuz na stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Zee nzhé re nu lo xaa: —¡Nalsi kanii lu klar, nu naniit lu kwaan kwent nabix! ");
INSERT INTO zpoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nal ne nu, lee lu ne rese kwaan nu nankint kwaz lu nabdizh xaa tub kwaan lo lu. Nu kwaane nle zee ne nu lee lu nyaad naz lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús né: —¿Che nalsi ne gu lee na nzhal naz lo Dios? ");
INSERT INTO zpoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","¡Kwaanzee mzhinla gor nu nal nak gor zee lee re gu rech, kad tub gu nya gu garli gu, nu laa gu techosa na! Per nazot techosa na nel Xuz na nzo kwaan na. ");
INSERT INTO zpoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nii na re kwaane lo re gu nel nzo gu kwaan na, nankint le gu xgab. Lo yizhyo ne ded gu bid; per nazhebt gu nel mlela na gan lo yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Gorna ngulo ngunii Jesús re kwaane, Jesús mwii yiba nu nzhé xaa: —Xuz na, mzhinla gor cheen na. Ble zee wii re xaa respet lo Xgann lu, zee noka Xgann lu le zee wii re xaa respet lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Lu mzaa diizh lo na, xaa nak Xgann lu, zee nabeey na lo rese myet yizhyo, zee zaa na yalnaban kwaan tira lo re xaa kwaan mzaa lu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nu xaa nzhekla kano yalnaban ne nzhaal labeyy xaa lu, xaa wlipa nak tubka Dios, nu nzhaal labeyy xaa na, Xaa Mxaal lu Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Na mle zee wii re xaa chul lo lu lo yizhyo ne, nel ngulola mle na re kwaan mxaal lu na le na. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kwaanzee nal Xuz na, zaa yalnabeyy lo na kwaan mkano na leezha mzo na kwaan lu, leezha zeeraka dexkwaa yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Mlu na cho nak lu lo re xaa mleey lu lo re myet, xaa mzaa lu lo na, nel nak xaa xaa lu, nu mzaa lu xaa lo na, zee mbin xaa xtizh lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nal ne re xaa, lee re kwaan mzaa lu lo na nak xcheen lu; ");
INSERT INTO zpoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","nel nzhé na lo xaa re kwaan nguné lu lo na, nu lee re xaa mbina. Mzeen re xaa lee na wlipa nzhal naz lo lu, nu mzeen re xaa lu mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Nal naab na lo lu zee kanap lu re xaa ne; nanaabt na lo lu zee kanap lu re xaa yizhyo; lee na naab lo lu zee kanap lu re xaa mzaa lu lo na, nel xaa lu nak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Rese xaa nak xaa na noka nak xaa xaa lu, nu re xaa nak xaa lu noka nak xaa xaa na. Lu mle zee ngwii re myet respet lo na kwent cheen re xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Na nazotra lo yizhyo; per lee re xaa seetaka nzhi lo yizhyo, gorna lee na nya zo kwaan lu. Xuz na, xaa nambey, bkanap re xaa kwaan yalngezh nu kwaan yalnabeyy cheen lu, kwaan mzaa lu lo na, zee tubka gak re xaa, mod lu nu na. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nzo na kwaan re xaa nak xaa lu lo yizhyo ne, nkanap na xaa kwaan yalnabeyy cheen le lu, kwaan mzaa lu lo na. Nu nik tub xaa kwaan mzaa lu lo na namluxt na, nebse mlux xaa kwaan nakla lux, zee gak re kwaan nkee lo Xkyech lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Nal bare na pa nzo lu. Per nel nzoka na yizhyo ne, zee nii na re kwaane, zee lee re xaa gak chul lextoo, mod nix nzhak lextoo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na mza xtizh lu lo xaa, per lee re myet yizhyo nayii ne re xaa, nel nanakt re xaa xaa yizhyo, modxa nanaktaka na xaa yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nanaabt na lo lu koo lu xaa lo yizhyo, sinka kanap lu xaa lo Maxuu. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Snee modxa nanakt na xaa yizhyo ne, noka re xaa nanakt xaa yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ble nzhul xaa kwaan re kwaan wli; nel xtizh lu nak kwaan wli. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Modxa mxaal lu na lo re xaa yizhyo ne, sbaaka xaal na re xaa lo re myet yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nu kwent cheen re xaa ne, mle nzhul na na, zee noka re xaa ne wlipa gak nzhul kwent cheen re kwaan wli. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Nu nanaabt na kanap lu nebse re xaa ne, sinka noka naab na kanap lu re xaa kwaan gwluzh wii lo na, gorna gon xaa kwent cheen wdizh chul kwaan zaa re xaa ne kwent. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Xuz na, naab na lo lu zee tubka gak re xaa ne, mod nak rop be tubka, snee mod tubka nzo lu kwaan na nu tubka nzo na kwaan lu, zee snee tubka gak re xaa ne; sbaa lee re myet yizhyo, ne lee lu mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nu mza na re kwaan chul lo xaa mod mzaa luya lo na, zee gak re xaa ne tubka, snee modxa nak lu nu na tubka. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na nzo kwaan re xaa ne, nu lu nzo kwaan na, zee gak re xaa ne tubka, nu snee lee re myet yizhyo ne ne lee lu mxaal na, nu nkela lu re xaa ne mod nkela lu na. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Xuz na, nzhekla na zo re xaa mzaa lu lo na pa nzo na, zee labeyy re xaa yalnabeyy kwaan mzaa lu lo na. Mzaa luya lo na leezha zeeraka dexkwaa yizhyo, nel nkela lu na. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xuz na, xaa nali nak, lee re xaa yizhyo nanlabeyyt lu; per na nlabeyy na lu nu re xaa ne ne lee lu mxaal na. ");
INSERT INTO zpoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nu mlu na lo xaa cho nak lu, nu seetaka nlu naya, nu leeka mod nkela lu na, kela lu re xaa, nu snee noka na zo kwaan re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Gorna ngulo mdizhno Jesús Dios, Jesús mroo kwaan re nu, xaa mseed lo xaa, zee mded xaa tub barank kwaan le Cedrón zee ya nu yi Olib. Baa nzob tub yilo, pa mrep Jesús kwaan re nu. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Noka Judas, xaa kwaan zaa xaa lo re xaa nak zhiin, nlabeyy baa, nel zyen welt mdop Jesús kwaan re nu naz baa. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Zee lee Judas mzhin baa kwaan tub partid soldad, nu kwaan lak polisi, xaa nkanap yidoo, xaa kwaan mxaal re ngwleyy non, nu re fariseo. Re xaa ne nzeno yiib, nu nzeno xaa xbruj xaa nu yerbal. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Per Jesús nela cho kwaan gak, zee mroo xaa nu mnabdizh xaa lo re xaa: —¿Cho xaa nkwaan gu? ");
INSERT INTO zpoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Lee re xaa mkeb nzhé: —Lee nu nkwaan Jesús xaa Nazaret. Jesús nzhé: —Na nak xaa zee. Judas, xaa zaa Jesús nze lo re xaa ba. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Gorna lee Jesús nzhé lo re xaa: “Na nak xaa zee”, mbii re xaa naz tras zee nguchin re xaa lo yo. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús mbare mnabdizh lo re xaa stub welt: —¿Cho xaa nkwaan gu? Lee re xaa mbare nzhé: —Nu nkwaan Jesús, xaa Nazaret. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús nzhé lo re xaa stub welt: —Niila na lo gu, na nak xaa zee. Chelee gu nkwaan gu na, laa gu nya re stub naz xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kwaane mded zee mbarlo kwaan nzhé leeka Jesús: “Xuz, lee re xaa mzaa lu lo na namluxt nik tub xaa ba”. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Zee lee Simón Pér, xaa nkano tub espad, mlooya nu mchoog xaa lad li nzha tub xaa le Malco, xaa nak mos cheen ngwleyy non doo. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús nzhé lo Pér: —Blochaw espad. Chelee Xuz na nzhekla deed na bid ne, nzhaal deed naya. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Zee lee re soldad nu xaa nabeyy lo xaa nu noka re polisi, xaa nkanap yidoo, mzen Jesús nu mkado xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Yilotlaka mbe xaa xaa garli Anás, nel xaa ne nak xuzhap Caifás, xaa nak ngwleyy non doo liin zee. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Leeka Caifás ne nak xaa nzhé lo re xaa sawlazh nu, mas wen yet tubka xaa kwent cheen dubse yezh ke dubse yezh lux. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Lee Simón Pér nu na nzhake tich Jesús. Nlabeyy na ngwleyy non doo, nu snee mrep na kwaan Jesús leen yoo; ");
INSERT INTO zpoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","per lee Pér mlake naz jwer roo yoo. Kwaanzee ngunii na lo xmos ngwleyy non doo, me nkanap roo yoo, zee mrep Pér naz leen. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Lee me nkanap roo yoo mnabdizh lo Pér, nzhé: —¿Che nanot lu nak tub re xaa kwaan kaseed lo Jesús? Pér mkeb nzhé: —Nanakt naya. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nu nel nze nal, lee re mos nu re polisi, xaa nkanap yidoo, mzee tub bal, nu kazhe re xaa. Noka Pér nzob kwaan re xaa kazhe lo bal. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Lee ngwleyy non doo mzelo mnabdizh lo Jesús cheen re nu, xaa mseed lo xaa, nen cho kwaan nseed xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús nzhé: —Lee na ngunii delant lo rese xaa; tubka nseed na re xaa pa nseed be xtizh Dios, nu lach roo yidoo, pa nkasa re sawlazh be; nu nik tub kwaan namlut na xlaan. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Chozhiin nabdizh lu lo na? Bnabdizh lo re xaa mbin kwaan ngunii na, zee re xaa né re kwaan nzhé na, nu nzho mod zaa xaa kwenta lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Gorna nzhé Jesús kwaane, tub polisi, xaa nkanap yidoo, mgazya ta garlo Jesús, nu nzhé lo xaa: —¿Che sbaa mkeb lu lo ngwleyy non doo? ");
INSERT INTO zpoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús mkeb nzhé: —Chelee na ngunii na tub kwaan nawent, né lo na cho kwaan ngunii na; nu chelee kwaan ngunii na wli, ¿chozhiin mkee lu yek na? ");
INSERT INTO zpoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nu seetaka nkadoo xaa, mxaal Anás xaa lo Caifás, xaa nak ngwleyy non doo. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nu lee Pér nzobaka baa kazhe lo bal. Zee mnabdizh re xaa lo xaa: —¿Che nanakt lu tub xaa mseed lo Jesús? Pér mkeb nzhé: —Nanakt naya. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Zee mnabdizh tub mos cheen ngwleyy non doo, sawlizh xaa mchoog Pér nzha, nzhé: —¿Che nangunet na lo lu kwaan Jesús, leen yilo? ");
INSERT INTO zpoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pér nzhé stub welt: —Nalet naya. Nu gorzee lee gaay mrazhe. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mloo xaa Jesús garli Caifás, nu mbe xaa xaa naz palas cheen Pilat, xaa nabeyy Judea. Nu merla yani yizhyo. Lee re xaa sawlazh nu namzeebt leen palas, nel snee nzho mod lake nzhul xaa lo Dios nu nzho mod gaw xchee xaa cheen Paskwa, gorna nselazh re nu xomod mloo Dios re xey nu Egipto. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kwaanzee Pilat mroo ngunii lo re xaa, nzhé: —¿Cho re kwaan ngaazh gu tich xaabyi ne? ");
INSERT INTO zpoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Lee re xaa non lo re xaa sawlazh nu mkeb, nzhé: —Chol nanakt xaa tub xaa nakap, nangiidnot nu xaa lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat nzhé: —Be gu xaa, nu bnaab gu kwent lo xaa, mod nak ley cheen gu. Lee re xaa mkeb nzhé: —Per lee re nu, xaa Israel, nanzeyalt gu gut nu tub xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Snee mbarlo kwaan nzhé Jesús, leezha mzaa xaa kwent xomod yet xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat mbare mrep leen palas stub welt, mrezh xaa Jesús, nu mnabdizh xaa lo xaa: —¿Che lu nak Rey cheen re xaa Israel? ");
INSERT INTO zpoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús nzhé: —¿Che nabdizh lu kwaane nel sbaa nzak lu, o nel nguné stub xaaya lo lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Lee Pilat mkeb nzhé: —Nanakt na xaa Israel, lee re xaa sawlazh lu nu re ngwleyy non mzaa lu lo na. ¿Cho kwaan mle lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús mkeb nzhé: —Lee Pa Nabeey na nanakt lo yizhyo ne. Chol yizhyo ne nabeey na, lee xaa kwaan nkee zhiin lo na dil, zee nangzaat re xaa na lo re xaa non lo re sawlazh na. Per lee Pa Nabeey na nanakt lo yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Zee lee Pilat nzhé lo xaa: —A, lu nak rey. Jesús mkeb nzhé: —Wli kwaan né lu, na nak rey. Kwaanzee ngol na nu myal na yizhyo zee za na kwent cheen kwaan wli lo re myet. Nu rese xaa ngwii lo kwaan wli nzhon xtizh na. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat nzhé: —Nik tub xaa nanet cho kwaan nak kwaan wli. Gorna ngulo nzhé xaa kwaane, Pilat mroo mdizh kwaan re xaa sawlazh nu, nu nzhé xaa lo re xaa: —Nik tub kwaan nawent mle xaabyi ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Per lee re gu nkano kostumbr nsela na tub xaa nzho lozhyib lo yalni cheen Paskwa. ¿Che nzhekla gu sela na xaa nak Rey cheen re gu? ");
INSERT INTO zpoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Re xaa mbare nzhé: —¡Naselat lu xaa ba! ¡Bsela Barrabás! Nu Barrabás nak tub wann. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Zee lee Pilat mzen Jesús, nu mnabeyy zee zaa xaaya yenn xaa kwaan bins. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lee re soldad mdexkwaa tub koron kwaan yag yich nu mzob xaaya yek Jesús, nu msegak xaa xaa tub ler naxne, kwenta kwaan nzhak rey. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Zee mbii re xaa lo xaa nu nzhé xaa: —¡Xwa doo Rey cheen re xaa Israel! Nu mgazya re xaa ta garlo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat mbare mroo stub welt nu nzhé lo re xaa: —Wii re gu, mlo na xaa, zee ne re gu nik tub kwaan nawent namlet xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Zee mroo Jesús nzob koron yich yek xaa nu nak xaa ler naxne. Lee Pilat nzhé: —¡Wii gu, lee xaa nzo nee! ");
INSERT INTO zpoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Gorna ngune re ngwleyy non nu re soldad, xaa nkanap yidoo lo xaa, mzelo re xaa nzhé: —¡Bkee xaa lo krus! ¡Bkee xaa lo krus! Zee nzhé Pilat lo re xaa: —Be gu xaa nu bkee gu xaa lo krus, per lee na nangaazht nik tub kwaan tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Lee re sawlazh na mkeb nzhé: —Lee re nu nkano tub ley, nu mod nzhé ley cheen nu nzhaal yet xaa, nel né xaa lee xaa nak Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Gorna mbin Pilat kwaane mas mzheb xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Zee mrep xaa leen palas stub welt nu mnabdizh xaa lo Jesús: —¿Pa naz nze lu? Per Jesús namkebt nik tub kwaan lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilat nzhé: —¿Chozhiin nankebt lu lo na? ¿Che nanet lu nkano na yalnabeyy kee na lu lo krus, nu nkano na yalnabeyy sela na lu? ");
INSERT INTO zpoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Zee lee Jesús mkeb nzhé: —Nyent mod nabeyy lu lo na, chelee Dios namzaat yalnabeyy lo lu; per lee xaa kwaan mzaa na lo lu, mas nkano kulp ke lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nu gorzee lee Pilat mzelo mkwaan mod sela Jesús; per lee re sawlazh na nzhé: —¡Chelee lu sela lu xaa ne, nanakt lu xmig César, xaa nabeyy dub pa nabeyy Roma! ¡Loka xaa mbezh nak rey, nak xaa xkontrad xaa nabeyy dub pa nabeyy Roma! ");
INSERT INTO zpoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Gorna mbin Pilat kwaane, mnabeyy xaa zee koo xaa Jesús, nu mzob xaa pa nzob xaa nabeyy naab xaa kwent, pa kwaan le diizh hebreo Gabata, kwaan nak Lach Ke. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kwaane ngok rolta mbizh, mbizh gorna nzelo xaa ndexkwaa xaa cheen yalni le Paskwa. Pilat nzhé lo re xaa: —¡Lee xrey gu baa! ");
INSERT INTO zpoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Per lee re xaa nzhé: —¡Yet xaa! ¡Yet xaa! ¡Bkee xaa lo krus! Lee Pilat mnabdizh lo re xaa: —¿Che nzhekla gu kee na xrey gu lo krus? Nu lee ngwleyy non doo mkeb nzhé: —¡Nankanot nu stub rey, nebse César, xaa nabeyy dub pa nabeyy Roma! ");
INSERT INTO zpoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Zee lee Pilat mzaa Jesús lo re xaa, zee mkee xaa xaa lo krus, zee lee re xaa mbe xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mbe re xaa Jesús nya xaa naz tub pa le Zhit Yek Xaa (kwaan wdizh hebreo nak Gólgota). Nu mbe Jesús xkrus Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Baa mkee xaa xaa lo krus kwaan xchop xaa, nu mkee xaa tubga xaa rop lad lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat mnabeyy zee kee xaa tub kwaan yek krus, kwaan nzhé: “JESÚS XAA NAZARET, REY CHEEN RE XAA ISRAEL”. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Zyen doo xaa lazh na mlab kwaane, nel lee pa nkee Jesús lo krus nak gax Jerusalén, nu lee kwaane nkee kwaan wdizh hebreo, latín, nu gryeg. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kwaanzee lee re xaa nu re ngwleyy non nzhé lo Pilat: —Nakeet lu: “Rey cheen re xaa Israel”, kee kwaan yé: “Xaa mbezh nak xaa Rey cheen re xaa Israel”. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Per lee Pilat mkeb lo re xaa nzhé: —Lee kwaan mkee na, sbaa lakeya. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Gorna ngulo mkee re soldad Jesús lo krus, mzen xaa xab xaa, nu mle xaaya tap lee nu tubga leeya mka tubga soldad. Noka mzen xaa stub naz xab xaa, nu nel naka tubka lee ler chul doo, ");
INSERT INTO zpoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","zee nzhé re soldad lo wechxinn xaa: —Nachazt beya, mas wen kee be swert zee nen cho yizoya. Nu snee mbarlo kwaan nzhé Xkyech Dios: “Mdiiz xaa re xab na nu mkee xaa swert nen cho yizo xab na”. Sal. 22:18 Nu sbaa mle re soldad. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nu gax lo krus nzo xnaa Jesús, nu bal xnaa xaa, nu Mari sa Cleofas nu Mari me yezh Magdala. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Gor ne ngune Jesús lo xnaa xaa nu lee na nzo gax lo me, xaa nkedoola xaa, zee nzhé xaa lo xnaa xaa: —Lee xgann lu nzo lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Zee né xaa lo na: —Lee xnaa lu nzo lo lu. Nu leeka zee, lee na mkayaa me li na mod xnaa na. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Gorna ngulo mded kwaane, Jesús ne ngulola ngok re kwaan mzaa Xkyech Dios kwent cheen xaa, re wdizh kwaan mkee re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. Nu zee gak re kwaan nzhé Xkyech Dios, snee nzhé Jesús: —Nzhek lextoo na. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Baa nzo tub re xis ub kwaan ni. Nu mle bsii xaa tub lee xiil nu mzob xaaya yek tub lee yag kwaan le hisopo nu mkee xaaya roo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús ngu xis ub kwaan ni ba nu nzhé xaa: —¡Rese kwaan ngulola ngok! Zee mkichyek xaa nu mlaa xaa yet xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Re kwaane ngok mbizh kwaan mzelo nu ndexkwaa nu kwaan gaw nu yalni cheen Paskwa, nu lee re xaa lazh na nanzheklat keeka kwerp lo krus mbizh kwaan nzholl re nu lo Dios, nel mbizh ne nak tub mbizh non doo lo re nu. Zee ngunaab xaa lo Pilat, zee kich xaa nii re xaa nkee lo krus, nu zee la xaa re kwerp cheen xaa lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Zee lee re soldad ngwa nu mdich nii rop xaa nkee xkwes Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Per gorna mbii xaa gax lo Jesús ngune xaa ngutla xaa. Kwaanzee namdicht xaa nii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nu lee tub soldad mkich xtak roo lextoo xaa, nu gorzee mchuun ren kwaan nuch nis lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nu na ngune kwaane, kwaanzee nza na kwent cheena, nu wli kwaan nii na; nu kwaanzee nzhaal le gu krer kwaan nza na kwent. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nu re kwaane mded zee mbarlo re kwaan nkee lo Xkyech Dios, kwaan nii: “Nakicht xaa nik tub zhit cheen na”. Sal. 34:20 ");
INSERT INTO zpoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nu lo stub pa Xkyech Dios nkee: “Wii re xaa lo xaa mkich xaa stak lextoo”. Zac. 12:10 ");
INSERT INTO zpoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ngulo mded re kwaane, Che xaa yezh Arimatea, ngunaab lo Pilat zee zaa xaa diizh wee xaa kwerp cheen Jesús. Che nak tub xaa mseed lo Jesús, nixa nak xaa tub xaa nseed xlaan nel nzheb xaa ne xaa re xaa non lazh nu. Pilat mzaa diizh lo xaa, nu lee xaa ngwa nu mbe xaa kwerp cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nu noka ngwa Nikodem, xaa kwaan ngwa mdizhno Jesús tub yaal, mzhino xaa kan tub galbchii kil anseyt kwaan chul nzebech, kwaan nak cheen chop yag kwaan le mirra nu aloe. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nu snee Nikodem rop Che mbe kwerp cheen Jesús nu mchaal xaa kwerp cheen Jesús ler kwaan mrub anseyt kwaan chul nzebech zee cho, mod nle re nu kwaan xaa nzhet. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lee pa mkee xaa Jesús lo krus nzob tub yilo, nu leen yilo ne nzob tub baa kwaan nik tub xaa zer yo leen. ");
INSERT INTO zpoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Baa mchep xaa xkwerp Jesús, nel lee baa ba nzob gax nu nel merla zhin mbizh kwaan nzholl re nu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Zhe dming garziil doo, Mari me yezh Magdala ngwa roo baa, gorna seetaka nakawra na; nu ngune me nyent ke kwaan nyaww roo baa. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Zee mrexonn me ngwa me pa nzo rop na Simón Pér, na nak xaa nkedoola Jesús, nu né me lo rop nu: —¡Mloo xaa Xaa Nabeyy leen baa nu nanet nu pa naz ngulaa xaa xaa! ");
INSERT INTO zpoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Zee lee rop na Pér mroo nu ngwa roo baa. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tubka mrexonn rop nu, per lee na mas nxonnra ke Pér nu yilo na mzhin na roo baa. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mkichyek na nu mwii na nu myun re ler kwaan mral Jesús lo na, per namzeebt na. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nu zeera mzhin Simón Pér, zee mzeeb xaa leen baa. Noka lo lee xaa myun ler kwaan mral Jesús; ");
INSERT INTO zpoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","nu noka myun lo xaa lee ler kwaan mral yek Jesús, nanaxt gax lo stub naz ler, sinka leeya nduuzh nax stub pa. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Zee noka mrep na, nu myun lo na re kwaan ngok, nu mle na krer lee Jesús mroban. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nel zeeraka la yek re nu kwaan nzhé Xkyech Dios, lee xaa nzhaal roban. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Zee mbare rop nu garli nu. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Per lee Mari mlake naz jwer, gax roo baa nu nzhonn me, nu mkichyek me zee ngwii me naz leen baa, ");
INSERT INTO zpoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","nu myun chop mandad cheen Dios lo me, xaa kwaan nak ler rus, nzobsa paro mzhib xaa kwerp cheen Jesús; tub xaa nzob paro ngot yek Jesús nu stub xaa nzob pa naz mrib nii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lee rop mandad ngunabdizh lo me: —¿Chozhiin nzhonn lu? Lee me nzhé: —Nel mbe xaa Xaa Nabeyy na nu nanet na pa naz ngulaa xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nebse ngulo nzhé me kwaane, nu mzere me yenn me, ta myun Jesús lo me, per nanet me chelee xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Zee mnabdizh Jesús lo me: —¿Chozhiin nzhonn lu? ¿Cho xaa nkwaan lu? Lee me mle xgab xaa nkanap yilo ngunii lo me, zee nzhé me: —Chelee lee lu mbe xaa, né lo na pa naz ngulaa lu xaa, zee wee na xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Zee lee Jesús nzhé lo me: —¡Mari! Lee me mzere yenn, nu nzhé me kwaan wdizh hebreo lo xaa: —¡Maestr! ");
INSERT INTO zpoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús nzhé: —Nakeezht lu na, nel zer nya na lo Xuz na. Gwa nu guzh lo re wech na lee na nya zhaal kwaan Xuz na, xaa nak Xuz re gu, nu xaa kwaan nak Xdios na, nu xaa nak Xdios re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Zee lee Mari, me yezh Magdala, nya nu nzhé me ngune me lo Xaa Nabeyy, nu noka nzhé me lo re xaa, kwaan nzhé Xaa Nabeyy lo me. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Gorna mzhel yizhyo zhe zee, zhe dming, lee nu, xaa mseed lo Jesús, mkasa leen tub yoo nu msaaw nu roo yoo nel nzheb nu ne nu re xaa sawlazh nu. Zee lee Jesús mzeeb nu mzo xsaww lo re nu, nu né xaa: —Dix. Chul kwi re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Gorna ngulo nguné xaa kwaane, mlu xaa yaa xaa nu roo lextoo xaa lo re nu. Zee lee re nu chul doo ngok lextoo ngune lo Xaa Nabeyy stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Zee lee Jesús né lo re nu stub welt: —¡Chul kwi re gu! Modxa mxaal Xuz na na, sbaaka xaal na re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nu mzebi xaa lo re nu, nu né xaa: —Bkayaa gu Mbi Naban. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Loka xaa yenlazh jwalt cheen wechxinn, Dios chee jwalt cheen xaa zee; nu loka xaa nayenlazht jwalt cheen wechxinn, Dios nacheet jwalt cheen xaa zee. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Max, tub lo re chiibchop nu, xaa mseed lo Jesús, xaa nii re xaa lo “Kwech”, nanzot baa gorna mzhin Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Gwluzh nzhé re nu lo xaa: —Ngune nu lo Xaa Nabeyy. Per lee Max mkeb né: —Chelee nawiit na lo yaa xaa paro mzob re xaa klab nu nachebt na kwen yaa na pa mzob klab, nu nachebt na yaa na roo lextoo xaa, nalet na krer mroban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Xon mbizh gwluzh, lee re nu mkasa leen yoo stub welt, nu welt ne noka Max nzo kwaan re nu. Nyaww roo yoo kwaan leyaw pa nzho re nu, per lee Jesús mzeeb nu mzoli xsaww lo re nu, nu né xaa: —Dix. Chul kwi re gu. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Zee nzhé xaa lo Max: —Bwii yaa na nu bchep kwen yaa lu; nu bchep yaa lu leen laz na. Nagakt lu tant ned. ¡Ble krer lee na mroban! ");
INSERT INTO zpoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Zee lee Max nzhé: —¡Lu nak Xaa Nabeyy lo na nu Xdios na! ");
INSERT INTO zpoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús nzhé lo xaa: —Nle lu krer mroban na nel myun na lo lu. ¡Wen re xaa kwaan nanet lo na nu nle xaa krer lee na mroban! ");
INSERT INTO zpoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús mle zyen doo stub naz kwaan gro lo re nu, xaa mseed lo xaa, kwaan namkeet na lo yech ne. ");
INSERT INTO zpoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Per lee re kwaane mkee na, zee nzho mod le gu krer lee Jesús nak Crist, Xaa Mxaal Dios Nabeyy, nu lee xaa nak Xgann Dios, nu zee snee le gu gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ngulo mded kwaane, Jesús mlu lo re nu, xaa mseed lo xaa, roo nistoo cheen Galilea, kwaan noka nii xaa Tiberias, nu snee ngoka: ");
INSERT INTO zpoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nzo Simón Pér, Max (xaa nii xaa lo “Kwech”), Nat (xaa nak xaa yezh Caná cheen yizhyo Galilea), nu rop wech nu (nu nu nak xgann Zebedeo), nu xchop xaa kaseed lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pér né lo re nu: —Lee na yazen mbal. Lee re nu mkeb nzhé: —Noka re nu ya kwaan lu. Zee ngwa re nu, nu nguxoob re nu lo tub kano, per yaal zee namzent nu nik tub mbal. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Gorna nzeka xnila yizhyo, lee Jesús mlu lo re nu roo nistoo, per lee re nu nangunet chelee xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús mnabdizh: —Xey, ¿che nik tub mbal nangugat lo re gu? Lee re nu mkeb nzhé: —Nik tub ma. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús né lo re nu: —Bchep gu xkyeez gu leen nis naz lad li kano, zee yiga mbal lo gu. Sbaa mle nuya, nu zee nyentra mod koo nu yeez, nel zyen doo mbal nguga. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Zee nzhé na, xaa tant nkela xaa, lo Pér: —¡Xaa Nabeyy beya! Gorna mbin Simón Pér, Xaa Nabeyy beya, ngok xaa xab xaa (nel mkiib xaa xab xaa zee kee xaa zhiin), nu mzeeb xaa leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lee stub naz re nu nyaad leen kano, kwaan yeez nyazhe mbal, nel nzo re nu kan tub gayoo metr roo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nu mzhin nu roo nistoo nze tub bal, nu kayeex mbal loya, noka mlu pan lo nu, ");
INSERT INTO zpoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús né lo re nu: —Teno gu lak mbal, ma nguga lo gu nal. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pér nguxoob leen kano nu mdobxex xaa yeez nyazhe kwaan re mbal naro axta roo nistoo; nu leen yeez nzho tub gayoo choobchiibchon mbal, nu nixa zyen doo ma nu namrazt yeez. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús né lo nu: —Te gawren gu. Nu rese nu mzheb ngnabdizh lo xaa: “¿Cho nak lu?”, nel ne nu lee xaa nak Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Zee lee Jesús mbii gax nu mzen pan nu mdiiz xaaya lo nu, nu sneeka mle xaa kwaan mbal. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kwaane ngok yonn welt mlu Jesús lo nu, gorna ngulo mroban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Gorna ngulo ndawren re nu, Jesús mnabdizh lo Simón Pér: —Simón, xgann Juan, ¿che nkela lu na mas ke re xaa ne? Pér mkeb nzhé: —Aja, Xaa Nabeyy, lu ne xmig be. Jesús nzhé: —Bkanap re xmbakxiil na. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mbare xaa mnabdizh xaa stub welt, nzhé xaa: —Simón, xgann Juan, ¿che nkela lu na? Pér mkeb nzhé: —Aja, Xaa Nabeyy, lu ne xmig be. Jesús nzhé: —Bkano re xmbakxiilta. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ngok yonn welt mnabdizh xaa lo xaa nu nzhé xaa: —Simón, xgann Juan, ¿che xmig be? —Lee Pér nales doo ngok lextoo nel mnabdizh xaa lo xaa chon welt che nkela xaa xaa, nu lee xaa mkeb nzhé: —Xaa Nabeyy, lu ne rese kwaan, lu ne xmig be. Jesús nzhé: —Bkanap re xmbakxiilta. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wlipa na nii na lo lu, leezha mad lu nzhak lu xab lu nu nya lu pa nzhak yek lu, per leezha yex lu, nebse seli lu yaa lu nu stub xaa segak xab lu nu wee xaa lu pa nanzheklat lu ya lu. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Gorna nzhé Jesús kwaane, zee nzhé xaa xomod yet Pér nu sbaa le Pér gan zee gool myet lo Dios. Zeera nzhé xaa: —¡Breke tich na! ");
INSERT INTO zpoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Gorna mzere Pér yenn Pér ngune Pér lee na nzhal, xaa nkedoola Jesús. Nu na nak xaa mnabdizh lo Jesús, ngwzhe kwaan ndawxchee re nu, nu nzhé na: “Xaa Nabeyy, ¿xana xaa zaa lu lo re xaa gut lu?” ");
INSERT INTO zpoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Gorna ngune Pér lo na, mnadizh xaa lo Jesús: —Xaa Nabeyy, lee xaa nee, ¿cho kwaan ded kwaan lee xaa? ");
INSERT INTO zpoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús mkeb nzhé: —Chelee na nzhekla na banaka xaa axta gorna bare na stub welt, sbaa gaka. ¡Nu nakint ya lu pa nakabezht xaa lu! Lu nebse breke tich na. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kwaanzee mxonn diizh lo re wech lee na nayeta. Per nanzhét Jesús nayeta na, kwaan nzhé xaa nak, chelee nzhekla xaa banaka na axta gorna bare xaa, nu nakint ya Pér pa nakabezht xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Leeka na, xaa mzaa Jesús kwent, nak xaa mkee re wdizh ne. Nu ne be wli nak kwaan mkee na. ");
INSERT INTO zpoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús mle zyen doo stub naz re kwaan gro; nu chol nkee reseya, nzak na nixa dub yizhyo nagaat yo re yech nkee re kwaan mle Jesús. Sbaa nak kwent kwaan mza na.");
INSERT INTO zpoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Dix Chof. Lo yech yilo cheen na mkee na rese kwaan mle Jesús nu rese kwaan mlu xaa, ");
INSERT INTO zpoNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","axta mbizh kwaan nguxoob xaa naz yiba. Leezha zeeraka nya xaa naz yiba, mseed xaa re xaa mkayaa yalnabeyy lo xaa, xana kwaan nzhaal le xaa, nu mseed xaa xaa kwaan Mbi Naban cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nu gwluzh leezha ngulo ngut xaa, zee mlu xaa kwaan kwerp cheen xaa lo re xaa mkayaa yalnabeyy lo xaa, lee xaa mban. Nu tubka see mlu xaa tub choo mbizh lo re xaa. Nu mzaa xaa kwent cheen pa nabeyy Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nu leezha nzoka Jesús kwaan re xaa mleey xaa, Jesús nzhé lo re xaa nanzhaalt roo xaa yezh Jerusalén. Nu nzhé xaa: —Blaz gu axta yilo gak kwaan ngune Xuz na nu kwaan nguniika na lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wli lee Juan mchubnis kwaan nis, per nazyentra mbizh lee re gu rubnis kwaan Mbi Naban cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nu lee re xaa nzhi lo Jesús, mnabdizh lo xaa: —Xaa Nabeyy, ¿che mzhinla mbizh, zaa lu diizh nabeyy leeka sawlazh nu lo nu? ");
INSERT INTO zpoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Zee lee Jesús mkeb nzhé: —Nanzhaalt ne gu cho gor o cho mbizh lee Xuz na le re kwaane, nel mleeyla xaa gor kwaan yalnabeyy cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Per gorna lee Mbi Naban cheen Dios la leen lextoo gu, kayaa gu yalnabeyy nu ya gu zaa gu kwent kwaan mlu lo gu, nu ya gu yezh Jerusalén, nu dubse yizhyo cheen Judea nu yizhyo cheen Samaria nu axta pa mas zit lo yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ngulo ngunii xaa kwaane, kawiika re xaa lo xaa, Jesús nguxoob naz yiba nu lee tub xkaw msaaw xaa, nu namlutra xaa lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nu nzo re xaa ngwii naz yiba, nu lee Jesús nya nguxoob naz yiba, gorzee lee chop xaabyi nak ler rus ta mzhin lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nu nzhé xaa: —Xaabyi, xaa Galilea, ¿chozhiin ngwii gu naz yiba? Leeka Jesús, xaa mroo lo re gu nguxoob naz yiba, nu yaad xaa stub welt, sbaaka kwentaxa ne gu nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Zee mroo re xaa yek yi kwaan le Olib, nu mbare re xaa axta Jerusalén, kwaan nzhi gax, kan xon gayoo metr. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Gorna mzhin xaa yezh, nguxoob xaa leen tub yoo ndok kwaan nak stub pis paro mlaz xaa. Nu lo re xaa nzho: Pér, Juan, Chag, Ndres, Lip, Max, Tol, Teo, Chag (xgann Alfeo), Simón (xaa nkedoola lazh), nu Judas (wech Chag). ");
INSERT INTO zpoNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Rese xaa ne tubka nzhidizhno xaa Dios. Nu lo re xaa ne nzo Mari xnaa Jesús, nu zlak ngwnaa, nu noka re wech Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nu tub mbizh lee Pér mzoli xsaww lo re xaa Jesús, pa nzhi kan tub gayoo gal xaa, ");
INSERT INTO zpoNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","zee nzhé Pér lo re xaa: —Wech na, nkin gak kwaan ngunii Mbi Naban kwaan mkee David lo Xkyech Dios, pa nzaa kwent kwaan mle Judas, xaa mzaa Jesús lo re xaa nzhekla gut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nel Judas nak tub xaa lo re be, nu mkano xaa zhiin lo xchiin be, ");
INSERT INTO zpoNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","nu ngwa xaa nu mzi xaa tub leyo, kwaan demi kwaan mkayaa xaa lo kwaan nawent kwaan mle xaa. Mrenzeb xaa lo yo, nu mraz xaa, nu mroo xtrip xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Gorna lee re xaa nzho Jerusalén mbina, zee mlole xaa leyo zee xtizh xaa, “Acéldama”. (Wdizh ne nii: “Lach cheen ren”.) ");
INSERT INTO zpoNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nel nkee lo yech cheen Salm nzhé: Garli xaa gak tub pa wen, nu nik tub xaa nayot baa. Sal. 69:25 ’Nu noka nkee: Mas wen lee stub xaa kayaa xchiin xaa. Sal. 109:8 ");
INSERT INTO zpoNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Pér nzhé: —Nzhaal kweey be tub xaa zo kwaan nu, tub xaa kwaan mzo dubse leezha mzo Jesús Xaa Nabeyy be kwaan nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Nzhaal gak xaa tub xaa mzo kwaan Jesús axta mbizh kwaan mchubnis Juan xaa, nu axta mbizh kwaan nguxoob xaa naz yiba, zee zhaal xaa kwaan be, zee zaa xaa kwent lee Jesús mroban. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Zee mrezh re xaa chop xaa: Che (xaa nii xaa lo Barsabás nu noka nii xaa Just), nu Matías. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nu mdizhno re xaa Dios snee: —Xaa Nabeyy, lu nlabeyy lextoo rese myet. Né xana xaa kweey lu lo rop xaa ne, ");
INSERT INTO zpoNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","zee garlo mod kayaa xaa yalnabeyy lo lu nu le xaa xchiin Judas, nel mlaa Judas nu, nu nya xaa pa nzhaal nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Zee ngu rop xaa swert. Nu Matías mle gan, kwaanzee Matías mla lo chiibtub xaa mkayaa yalnabeyy lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Gorna mzhin mbizh yalni cheen Pentecostés, rese xaa Jesús nzhi tubka pa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nu ta mbin re xaa tub bi nye doo, kwaan nze kwenta tub mbi naz yiba, kwaan mrezh dubse leen yoo pa nzhi re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Zee mlu tub kwaan kwenta luzh bal lo re xaa, kwaan mla tich kad tub xaa nu mlakeya lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Zee lee Mbi Naban mnabeyy lextoo re xaa nu mzelo xaa mdizh xaa stub naz diizh, kwaan nzaa Mbi Naban mdizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nu mbizh zee nzho re xaa Israel Jerusalén, xaa nzholl lo Dios, re xaa ne nze xa xa yezh lo yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Rese xaa mdop gorna mbin xaa bi, nixa nanet xaa cho kwaan le xaa xgab, nel kad tub xaa mbin nzhedizh re xaa Jesús mer xtizh re xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nu ndedyall doo re xaa, nu nle xaa xgab, nu nabdizh xaa lo wechxinn xaa, nu nzhé xaa: —¡Wii gu! ¿Che nanakt xaa Galilea re xaa kawdizh nee? ");
INSERT INTO zpoNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Xomod nak kwaane? Nzhon be nzhedizh xaa mer xtizh be. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nu nzhi lo re be xaa nze re yizhyo ne: Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO zpoNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Panfilia, Egipto nu Libia kwaan nak gax Cirene. Noka nzhi lo be xaa Roma. Tub naz be nak xaa Israel axta ngol be, lee stub naz be nzhak xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Noka nzhi lo re be, xaa yizhyo Creta nu Arabia. Nu rese be nzhon kawdizh re xaa mer xtizh be, re kwaan gro doo mle Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Rese xaa nzhi ndedyall, nixa nanet xaa cho kwaan le xaa xgab, nu nabdizh xaa lo wechxinn xaa, nzhé xaa: —¿Cho kwaan re kwaane? ");
INSERT INTO zpoNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Per lee stub naz xaa nxizhno xaa nu mbezh xaa: —¡Kan nel nzuzh xaa! ");
INSERT INTO zpoNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Zee lee Pér kwaan re xchiibtub xaa mkayaa yalnabeyy lo Jesús mzoli. Zee ngunii Pér nye, nu nzhé xaa: —Xaabyi, xaa lazh na, kenzha rese gu kwaan nii na. Rese xaa nzho naz Jerusalén nu rese be nze nee, nzhaal ne re gu kwaan nii na lo gu nal. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nanzuzht re nu kwentaxa nle re gu xgab, nel pensa nak las nueve, garziil doo. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Re kwaan ngok nak kwaan mzaa Joél kwent, tub xaa mzaa kwent kwaan nzhé Dios lo lee xaa, leezha nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dios nzhé: “Re mbizh gwluzh, lee na xaal Mbi Naban cheen na lo rese myet lo yizhyo. Nu lee re xgann gu nu re xchap gu, zaa kwent kwaan yé na lo lee xaa, le na luu tub kwaan lo re xaa mad, nu lee re xaa gox chaa lextoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Lo re xmos na xaabyi nu ngwnaa, xaal na Mbi Naban cheen na re mbizh zee, nu wdizh xaa re kwaan luu na lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Le na re kwaan gro doo naz leen yiba nu lo yizhyo, nu luu ren, nu ki, nu xkaw zhen. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lee mbizh gak yalnakaw, nu lee mbee na mod ren, gorna zeeraka zhin mbizh gro doo cheen Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Per rese xaa naab lo Xaa Nabeyy, zaa Xaa Nabeyy yalnaban kwaan tira lo xaa.” Joél 2:28-32 ");
INSERT INTO zpoNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Kwaanzee kenzha re gu, xaabyi sawlazh be, kwaan nii na lo gu nal. Gu ne wen, Dios mxaal Jesús, xaa yezh Nazaret lo re gu. Nu xaa ne mle zyen doo kwaan naro, nu kwaan re gu mdedyall ngune. Sbaa mlu Dios lee Dios mxaal xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Axta yilo mlela Dios xgab nen cho kwaan le gu Jesús. Re gu mzen xaa nu mzaa gu xaa lo re xaa mbit xaa, mkee xaa xaa lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per Dios mseban xaa, namlaat Dios xaa lo re xaa ngut, nel nyent mod le yalgut gan lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nel rey David leezha ngunii xaa kwent cheen Jesús, nzhé xaa: Tubka nzo Xaa Nabeyy kwaan na, lee xaa nzo lad li lo na, zee tubka nye nzo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kwaanzee nyak doo lextoo na, nu nzholl na kwaan roo na. Kwaanzee nela na nyent cho kwaan gak na gorna yet na, ");
INSERT INTO zpoNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","nel nalaat lu na leen Hades, pa nzho re xaa ngut, nu nixa nalaat lu lux kwerp cheen na, kwerp cheen xmos lu, Xaa Nali nak. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mlu lu naz cheen yalnaban lo na, nu nyakdoola na nzo lu lo na. Sal. 16:8-11 ");
INSERT INTO zpoNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Wech na, kwaane klar doo nak, lee xey be David ngut, nu ngubyo xaa, nu lee baa cheen xaa nzoka axta nal. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Per David ngok tub xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, nu ne wen xaa lee Dios nzhé lo xaa, telisa tub dii cheen xaa nabeyy mod mnabeyy lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Snee ngunii David, mod tub xaa mzeen kwaan ded, ngunii xaa cheen yalmroban cheen Xaa Xaal Dios Nabeyy, nu ngunii xaa lee xaa nalaket leen Hades, pa nzho re xaa ngut, nu nixa naluxt kwerp cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kwaanzee nal Dios mle mroban Jesús, nu rese nu nzaa kwent cheen kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ngulo mroban xaa zee nya xaa mzob xaa lad li lo Dios, nu mkayaa xaa Mbi Naban kwaan nzhé Xuz xaa zaa xaa lo xaa, nu nal mxaala xaa Mbi Naban lo yizhyo ne. Nu Mbi Naban mle kwaan mlu lo gu nu mbin gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nu nanakt David, xaa nguxoob yiba. Nel leeka David nzhé: Dios, Xaa Nabeyy rese kwaan, nzhé lo Xaa Nabeyy lo na: “Zob lad li lo na, ");
INSERT INTO zpoNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","axtaka chezhin na rese xaa nayii ne lu, zee kichxub xaa lo lu, nu zee gak xaa mod tub kwaan zhib lu nii lu tich”. Sal. 110:1 ");
INSERT INTO zpoNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Sawlazh be, nzhaal ne kwaane: Lee Jesús, xaa mkee re gu lo krus, Dios mle xaa Xaa Nabeyy, nu lee xaa nak Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nu gorna mbin re xaa kwaane, nales ngok lextoo xaa nu mnabdizh xaa lo Pér nu lo re xaa mkayaa yalnabeyy lo Jesús, nu nzhé xaa: —Wech, ¿cho kwaan nzhaal le nu? ");
INSERT INTO zpoNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Zee nzhé Pér lo re xaa: —Laa gu nalet gu kwaan nawent, nu wii gu lo Jesucrist, nu brubnis kad tub gu kwaan yalnabeyy cheen Jesucrist, zee chee xaa re jwalt kwaan nawent kwaan mle gu, nu zaa Dios Mbi Naban lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nel kwaan nguné Dios zaa Dios, nzho mod kayaa re gu nu re xinn gu, nu noka nzho mod kayaa rese xaa nzho zit. Leeya nak cheen rese xaa nzhekla Dios kwezh, xaa nak Xaa Nabeyy be. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwaan re wdizh ne nu stub naza, Pér ngunii lo xaa, nu mzaa xaa kwent lo xaa nu nzhé xaa: —Nzhaal roo gu lo re myet kwaan nle re kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nu snee kan tub chon mil xaa mbin xtizh Pér, nu mrubnis xaa, nu ngok xaa xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nu rese xaa Jesús tubka ngok lextoo nu nle re xaa re kwaan nlu re xaa mkayaa yalnabeyy lo Jesús lo xaa, nu nzhaw xaa Xchee cheen Xaa Nabeyy, nu nzhedizhno xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nu rese myet mdedyall sinka zyen doo kwaan gro nle re xaa mkayaa yalnabeyy lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nu rese xaa ngwii lo Jesús tubka nak re xaa, nu nlerol xaa rese kwaan nkano xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nto xaa re kwaan nzhap xaa nu nyaadno xaa re demi nu ngiiz xaaya mod nkin kad tub xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yizata mbizh nkasa xaa roo yidoo, nu nkasa xaa nzhaw xaa garli xaa, nu nyakla re xaa nzhaw re xaa tubka, nu nix doo nzhak lextoo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nzholl xaa lo Dios, nu dubse yezh nyakla ne xaa. Nu yizata mbizh lee Xaa Nabeyy nle zyenra xaa, xaa le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tub mbizh Pér rop Juan nzha roo yidoo, kan las tres, kwaan nak gor nkasa xaa nzhedizhno xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nu ngu tub xaabyi, xaa mdeen axta leezha ngol, xaa nzhe xaa rese mbizh nu nzob xaa xaa roo pwert kwaan le Chul Doo cheen yidoo, zee naab xaa karda lo re xaa nzeeb leen lach roo yidoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Gorna lee xaa mdeen ngune lee Pér rop Juan nzha nzeeb lach roo yidoo, zee ngunaab xaa karda lo rop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Zee lee Pér rop Juan mwii lo xaa, zee nzhé Pér lo xaa: —Wii lo nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lee xaabyi zee zheta mwii lo xaa nel mle xaa xgab zaa Pér rop Juan tub kwaan lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pér nzhé lo xaa: —Nankanot na demi za na lo lu, per kwaan nzho mod le na lo lu, le naya. Na nii lo lu: “Kwaan yalnabeyy cheen Jesucrist xaa yezh Nazaret, guxso nu bze”. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ngulo ngunii Pér kwaane, mzen Pér yaa xaa lad li nu mlexso xaa xaa, nu gorzee lee nii xaa ngokwen nu mli. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Lee xaa mzoli nu mkee xaa brink nu mzelo xaa mze xaa, zee mzeeb xaa kwaan rop xaa ba lach roo yidoo. Nu mkee xaa brink nu nzholl xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Rese xaa ngune lo xaa lee xaa nze nu nzholl xaa lo Dios, ");
INSERT INTO zpoNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","nu mdedyall doo rese xaa ngune lee xaa ne ngokwen, nu nixa nanet rese xaa cho kwaan le xaa xgab. Nel rese xaa nlabeyy xaa ngok mdeen, nu ne xaa lee xaa nzob naab karda roo pwert lach roo yidoo kwaan le Chul Doo. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Per lee xaa ngokwen namlaat xaa Pér rop Juan. Nu rese myet ndedyall nu mkasa re xaa dub welt lo yon xaa roo korredor pa le cheen Salomón. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Per gorna ngune Pér lo re myet, nzhé xaa: —Sawlazh be, ¿chozhiin ndedyall gu ngwii gu lo nu, nu lal nu msekwen xaa ne nu mle nu mze xaa, nel nkano nu yalngezh o nel nali nak nu lo Dios? ");
INSERT INTO zpoNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Lee Dios cheen re xey be xaa yilo, xaa nak Abraham, Chak nu Kob, lee Dios mle non Xgann Xaa, xaa le Jesús. Per re gu mzaa Jesús lo re xaa nak zhiin; nu leezha nzhekla Pilat sela xaa, nangzeyalt re gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Lee gu ngunaab msela xaa tub xaa nzhut myet, nu sbaa mlaa gu Jesús, xaa nzhul nu nali nak. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Snee mbit gu xaa nzaa yalnaban. Per Dios mseban xaa lo re xaa ngut. Nu re nu ngune kwaane, nu nzaa nu kwenta lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Per lee xaabyi, xaa nzo nee, tira ngokwen nel ngwii xaa lo Jesucrist. Nu rese gu nlabeyy xaa. Nu nal lee xaa nzo lo re be nee. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Re gu sawlazh be nu re xaa nak zhiin, nela na gorna mbit gu Jesús, nanet gu cho kwaan mle gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Per Dios mle kwaane, zee snee mbarlo kwaan ngunii re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, kwaan nak: lee Xaa Xaal Dios Nabeyy nzhaal yet. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Blaa gu naletra gu kwaan nawent nu wii gu lo Jesús, nu chee gu mod nak gu, zee chee Dios rese kwaan nawent kwaan mle gu, zee seleyy Dios gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nu xaal xaa Jesús, Xaa Nabeyy be stub welt lo yizhyo ne. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Per lee dubse nal Jesús nzo naz yiba, axta zhin mbizh kwaan mleey Dios gorna yilo zhib wen xaa rese kwaan, kwentaxa ngunii re xaa mzo nambey, xaa mzaa kwent kwaan nzhé Dios lo lee xaa re mbizh yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ches nzhé lo re xaa yilo: “Lee Dios, Xaa Nabeyy be, le zee lo re gu roo tub xaa zaa kwent xtizh xaa kwenta na. Le re gu kwaan yé xaa”. Dt. 18:15 ");
INSERT INTO zpoNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","“Nel rese xaa nagont xtizh xaa yet”. Dt. 18:19 ");
INSERT INTO zpoNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Nu rese xaa mzaa kwent kwaan nzhé Dios lo lee xaa, axta Samuel naz delant, mzaa xaa kwent cheen re mbizh ne. ");
INSERT INTO zpoNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Be nak dii cheen re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, nu noka mkayaa be wdizh kwaan mlaa Dios lo re xey be xaa yilo. Nel lee Dios nzhé lo Abraham: “Kwent cheen lu, Dios le kwaan chul lo zyen doo xaa dubse yizhyo”. Gn. 22:18 ");
INSERT INTO zpoNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nel gorna mseban Dios Xgann xaa Jesucrist, yilotlaka lo re be mxaal xaa xaa, zee ne wen Dios re be, nu laa be re kwaan nawent kwaan nle be. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Seetaka kanii Pér rop Juan lo re myet, gorna mzhin re ngwleyy, kwaan xaa nabeyy lo re xaa nkanap yidoo, nu kwaan re xaa saduceo. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nayii xaa ne xaa Pér rop Juan nel nseed xaa lo re myet. Nu mbezh xaa lo re xaa, lee re xaa ngut roban, mod mroban Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Zee mzen xaa yon xaa, nu mchep re xaa xaa lozhyib. Nu nel mzhela yizhyo zhe zee, zee mlaaka xaa xaa lozhyib axta stub mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Per zyen doo re xaa mbin wdizh chul kwaan nzhé xaa, nu kan tub gaay mil nebse xaabyi mle krer kwaan nzhé xaa, nu namlabt xaa re ngwnaa nu re madwin. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nu stub mbizh mdop rese xaa nabeyy Israel yezh Jerusalén, kwaan re xaa gol nu kwaan re maestr, xaa nlu xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nu lo re xaa zee nzo Anás, ngwleyy non doo, noka nzo Caifás nu Juan nu Jant, nu nzo re sawlizh ngwleyy non doo. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Zee mxaal xaa xaa mrezh Pér nu Juan nu xaa ngok mdeen, nu mzo xaa xaa xsaww lo re xaa, nu mnabdizh xaa lo xaa: —¿Cho mzaa diizh le gu kwaane? ¿Cho mzaa yalnabeyy lo gu zee nle gu rese kwaane? ");
INSERT INTO zpoNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Zee lee Mbi Naban mnabeyy lextoo Pér, zee mkeb xaa lo re xaa, nzhé xaa: —Rese gu xaa nabeyy nu, nu rese gu xaa gol, lee re gu kanabdizh lo nu ");
INSERT INTO zpoNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","zee ne gu xomod ngokwen xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Wena, nal nii nu lo re gu zee ne guya nu noka rese sawlazh be, lee xaabyi xaa nzo nee lo re gu, ngokwen kwaan yalnabeyy cheen Jesús xaa Nazaret, xaa mkee re gu lo krus per Dios mseban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Rese gu nak mod xaa nza yoo nu Jesús nak mod tub ke kwaan mlaa re gu, xaa nza yoo, per lee ke ne ngok ke mas kwaan wen kwaan nzob tub skin yoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nel nebse Jesús nzaa yalnaban kwaan tira, nu nyentra stub xaa nzaa yalnaban kwaan tira, nel namxaalt Dios stub xaa nzho mod koo be lo yalgut. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nu gorna lee re xaa ba mwii nanzhebt Pér rop Juan nu mzeen re xaa lee rop xaa namseedt gro, mdedyall doo re xaa. Per noka mzeen re xaa lee xaa mseed lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nel lee xaabyi xaa ngokwen nzo lo re xaa, zee nyent mod gaazh xaa nik tub kwaan tich rop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Zee mnabeyy xaa mroo yon xaa lo junt, zee mlake nebse re xaa, mdizh xaa kwaan wechxinn xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nu nzhé re xaa: —¿Cho kwaan le be kwaan rop xaa ne? Nel rese xaa yezh Jerusalén ne mle xaa tub kwaan gro doo nu nyent mod yé be nawlit kwaan mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mas wen yii be lo xaa, cheb be xaa, zee nazaatra xaa kwent cheen Jesús lo re myet, nu snee naxonntra xtizh Jesús lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nu zeera mrezh xaa xaa zee cheb xaa xaa, zee naseedtra xaa re myet kwent cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Per lee Pér rop Juan mkeb lo re xaa nzhé: —Leeka gu ble xgab nen cho mas wen delant lo Dios, gon nu xtizh gu o gon nu xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Per lee nu nyent mod laa nu nawdizhtra nu kwaan mlu lo nu nu kwaan mbin nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Zee lee re ngwleyy nu re xaa gol nayii lo xaa kwaan wdizh gaya nu mlaa xaa nya xaa, nel nangzhaalt mod ngted xaa xaa bid, nel rese myet nzholl lo Dios nel ngune xaa msekwen xaa mdeen. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Lee xaa sbaa ngokwen nzho masra choo liin. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Gorna msela xaa Pér rop Juan, zee nya xaa lo re xaa Jesús nu nzhé xaa rese kwaan nzhé re ngwleyy non nu re xaa gol lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nu gorna ngulo mbin xaa rese kwaan nzhé xaa lo re xaa, rese xaa mzelo xaa mdizhno Dios, nu nzhé xaa: —Xaa Nabeyy nu. Lu mdexkwaa yiba nu yizhyo nu nistoo nu re kwaan nzho leena. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Lu nzhé kwaan Mbi Naban kwaan roo David, xaa nak xmos lu: Kanxlee nayii re myet yizhyo, nu kanxlee nle re nu, xaa Israel, xgab. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Rese rey nu rese xaa nabeyy re yezh yizhyo ne yaan re xaa, zee dil xaa kwaan Xaa Nabeyy, xaa mleey lu kee xchiin lu, xaa Né lu Yaad. Sal. 2:1-2 ");
INSERT INTO zpoNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Nel wlipa mkasa rey Herod nu Pilat nu re xaa nanakt xaa Israel kwaan re xaa sawlazh be, zee mnayii xaa ne xaa xgann lu, xaa nali doo nak, xaa le Jesús; nixa lu mleyy Jesús zee nabeyy xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nu snee, mle re xaa ne kwaan mlela lu xgab yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nu lee nal, Xaa Nabeyy, wii ne xomod nayii xaa ne xaa nu kwaan re wdizh gaya; nu ble yudar re nu, xaa nak xmos lu, zee nazhebt nu zaa nu xkwent lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nu kwaan yalngezh cheen lu ble zee sekwen nu re xaa ne nzak, nu le nu re kwaan gro kwaan yalnabeyy cheen xgann lu, Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Gorna ngulo mdizhno xaa Dios, lee pa nzhi re xaa mxiz kwenta tub xog, zee lee Mbi Naban cheen Dios mnabeyy doo lextoo rese xaa nzhi baa, nu snee namzhebt re xaa nzaa kwent xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Zee lee rese xaa Jesús lal nle xaa xgab. Nik tub xaa nambezht xcheen xaa nak re kwaan nkano xaa, sinka xcheen re xaa naka, nzak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nu lee Dios mle yudar re xaa mkayaa yalnabeyy lo Jesús, nu mzaa xaa kwent wli mroban Jesús, Xaa Nabeyy. Zee lee Dios mlu doo yalnkela cheen lo re xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kwaanzee rese xaa nkano kwaan nkin, nel lee re xaa nkano leyo o tub yoo nto xaaya, nu lee demi ");
INSERT INTO zpoNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nzaa xaa lo re xaa mkayaa yalnabeyy lo Jesús, zee kiiz xaaya lo re xaa mod nkin kad tub xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nu lo re xaa ngu tub xaa le Che, xaa nak dii Leví. Xaa ne nak xaa yizhyo Chipre. Lee re xaa mkayaa yalnabeyy lo Jesús mlole xaa Bernabé. (Wdizh ne nii: “Xaa Nseleyy”.) ");
INSERT INTO zpoNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Xaa ne mkano tub lee leyo, nu mto xaaya zee myaadno xaa demi, nu mzaa xaaya lo re xaa mkayaa yalnabeyy lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tub xaabyi le Ananías nu sa xaa le Safira, mto xaa tub lee xleyo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Per myaan rop sa xaa kade xaa, nu mlaa xaa lak demi lo xaa, nu zlaka mzaa xaa lo re xaa mkayaa yalnabeyy lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Zee lee Pér nzhé lo Ananías: —¿Chozhiin mlaa lu mzeeb Maxuu leen lextoo lu, zee nzhekla lu kade lu Mbi Naban? ¿Chozhiin namzaat lu re demi kwaan mto lu xleyo lu? ");
INSERT INTO zpoNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Che nanakta xleyo lu gorna zer to luya? ¿Che nalet cheen lu nak demi kwaan mkayaa lu? ¿Chozhiin mle lu xgab le lu kwaane? Lu nzhekla kade re myet, per namzeent lu sbaaka nzhekla kade lu Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nu gorna mbin Ananías wdizh ne, gorzee ta ngut xaa. Nu rese xaa mbina mzheb xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Zee mbid lak xaa mad, nu mchaal xaa ler, nu mbe xaa xaa zee sebyo xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kan chon gor gwluzh zeera mzhin sa Ananías, nixa nanet me cho kwaan ngok. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pér mnabdizh lo me: —Né lo na, ¿che paro ne sa lu mto gu xleyo gu? Lee me mkeb nzhé: —Aja, pres baa mto nuya. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Zee nzhé Pér lo me: —¿Chozhiin myaan rop sa gu mle gu kwaane, zee nzhekla gu ne gu cho zeen Mbi Naban cheen Xaa Nabeyy kwaane? ¡Wii! Baa nyaad re xaa ngwa ngusebyo sa lu, nu nal wee xaa lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Leeka gorzee ta ngut me pa nzo Pér. Nu lee re xaa mad mzeeb nu ngune re xaa lee me ngutla; zee mbe re xaa me, msebyo xaa me cho sa me. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nu rese xaa Jesús nu rese xaa mbin kwaane mzheb doo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Re xaa mkayaa yalnabeyy lo Jesús mle xaa zyen doo kwaan gro lo re myet. Nu rese xaa nkasa roo korredor kwaan le Salomón roo yidoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nu lee re xaa yezh nkedoola re xaa Jesús, per nzheb xaa zhaal xaa kwaan re xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nu zyen doo xaabyi nu ngwnaa mzelo mwii lo Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nu nzhe xaa re xaa ne nzak roo naz, nzhib xaa xaa lo loon, nel gorna lee Pér ded gola xbzhin Pér gal cho lak xaa, zee gakwen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Noka zyen doo myet, re xaa Jerusalén nu re xaa yezh gax, nyaadno xaa re xaa ne nzak nu re xaa nzho mbi mal lextoo. Nu rese xaa nzhakwen. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lee ngwleyy non doo nu rese xaa saduceo ngok selos, ");
INSERT INTO zpoNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","nu mzen xaa rop xaa mkayaa yalnabeyy lo Jesús nu mchep xaa xaa lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Per leeka yaal zee, lee tub mandad cheen Dios mxal roo lozhyib nu mloo rop xaa, nu nzhé mandad lo xaa: ");
INSERT INTO zpoNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Gwa gu lo lach roo yidoo, nu guzh gu lo re xaa yezh rese wdizh cheen yalnaban kwaan kub ne. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Gorna sbaa mbin rop xaa mkayaa yalnabeyy lo Jesús, gorna mkaxni yizhyo zee ngwa xaa lach roo yidoo, nu mzelo xaa mseed xaa re myet xtizh Dios. Zee lee ngwleyy non doo nu re xaa nzhi kwaan lee xaa, mrezh xaa rese xaa nak zhiin. Zee mxaal xaa lak polisi xaa nkanap yidoo roo lozhyib zee yaadxii xaa rop xaa mkayaa yalnabeyy lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Per gorna mzhin re polisi, xaa nkanap yidoo roo lozhyib, nyentla rop xaa lozhyib. Zee mbare xaa nu nyaadno xaa rason, ");
INSERT INTO zpoNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","nu nzhé xaa: —Gorna mzhin nu seetaka wen wen nyaww roo lozhyib, nu nzhika re soldad nkanap roo pwert; per gorna mxal nuya zee ne nu nyentla xaa lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nu gorna mbin ngwleyy non doo nu re ngwleyy xaa non nu xaa nabeyy lo re polisi xaa nkanap yidoo kwaane, zee mle xaa xgab: “¿Axta paro zhin re kwaane?” ");
INSERT INTO zpoNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nu gorzee mzhin tub xaa nzhé lo re xaa: —Lee rop xaa mlo gu lozhyib nzo lach roo yidoo kaseed re myet. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Gorzee lee re polisi xaa nkanap yidoo nu xaa nabeyy lo re polisi mroo ngwakwaan rop xaa. Per gorna nguzhal xaa lo xaa, nyent cho kwaan mle re xaa xaa, nel nzheb re xaa napa kazaa ke re myet re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nu gorna mzhino xaa rop xaa lo re xaa nak zhiin, zee lee ngwleyy non doo nzhé lo rop xaa: ");
INSERT INTO zpoNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿Che namnabeyyt nu lo rop gu zee naniitra gu nu nixa naseedtra gu re myet kwent cheen Jesús? ¿Nu nal, cho kwaan mle gu? Ngulola mseed gu rese xaa dubse yezh Jerusalén, nu noka ngaazh gu re nu, lee re nu mbit Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Zee lee Pér kwaan stub xaa mkayaa yalnabeyy lo Jesús mkeb nzhé: —Yilotlaka nzhaal le nu kwaan nzhekla Dios; zeera le nu kwaan nzhekla re myet. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Lee Dios cheen re xey be, mle mroban Jesús, xaa mbit re gu, xaa mkee gu lo krus. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios mseban xaa nu mzob xaa xaa lad li lo xaa, nu mle xaa xaa, Xaa Nabeyy nu xaa nkiib jwalt cheen rese myet, zee lee re be xaa Israel, laa be naletra be kwaan nawent nu wii be lo Jesús, zee chee xaa re jwalt cheen be. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mlu re kwaane lo re nu zee zaa nu kwent cheena; nu noka Mbi Naban nzaa kwent cheen lee xaa, nu Mbi Naban mxaal Dios lo re nu, xaa nzhon xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Gorna mbin re xaa kwaane, mas nayii xaa nu nzhekla xaa ngut xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Per lo re xaa nak zhiin, zee nzo tub fariseo, xaa le Gamaliel. Xaa ne nlu ley cheen Ches, nu rese xaa yezh nzhon xtizh xaa. Nu mzoli xaa zee mnabeyy xaa koo xaa rop xaa mkayaa yalnabeyy lo Jesús tub rat naz jwer. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Zee nzhé xaa lo re xaa: —Kenzha gu, sawlazh be. Wii wen be nen cho kwaan le be kwaan rop xaabyi ne. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bselazh gu nzhala lak liin, ngu tub xaabyi le Teudas, xaa nzhekla ngak non; mtop xaa kan tap gayoo xaa mreke tich xaa. Per mbit re xaa xaa. Zee lee re xaa mreke tich xaa mrech, nu nik stub xaa xaa namlaketra. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nu leezha mtop rey le re myet, ngu stub xaa le Judas xaa Galilea, xaa noka mtop xaa mreke tich, per mbit xaa xaa. Per leezha gut xaa, noka rese xaa mreke tich xaa mrech. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kwaanzee na nii lo re gu, bsela gu re xaa ne, nu nik tub kwaan nalet gu lo xaa. Nel chelee re kwaane nak xchiin re myet, zluxa. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Per chelee Dios kale Dios kwaane, nalet be gan lo xaa. List gak be, napa lee re be Dios kadil. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Rese ngwleyy non nu rese xaa gol mbin xtizh xaa. Snee mrezh xaa re xaa mkayaa yalnabeyy lo Jesús, nu mzaa xaaya yenn xaa, nu mnabeyy xaa lo xaa zee nazaatra xaa kwent cheen Jesús; zeera msela xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Per lee re xaa mkayaa yalnabeyy lo Jesús nyakdoola xaa mroo lo re xaa nak zhiin, nel lee Dios mzeyal mded xaa bid kwent cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nixa namzhebt xaa nixa namlaat seed xaa re myet lach roo yidoo nu noka garli re myet. Nu mbezh xaa: —Lee Jesús nak Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nu zee lee re xaa Jesús nzhiyak zyen doo, nu lee re xaa Jesús, xaa nzhedizh gryeg mzelo ngunii nawent re stub naz xaa Jesús, xaa nzhedizh hebreo nu nzhé xaa: “Lee re byud, me nzhedizh gryeg nankayaat tub paro kwaan mod nkayaa re byud, me nzhedizh hebreo”. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kwaanzee lee re chiibchop xaa mkayaa yalnabeyy lo Jesús mkasa rese xaa Jesús nu nzhé xaa lo xaa: —Nawent chelee nu laa nu nazaat nu kwent cheen wdizh chul, zee kiiz nu kwaan gaw re myet. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kwaanzee wech nu bzan, bleey gu lo re gu gazh xaabyi xaa nali nak, xaa nkano yalnzhak, nu xaa nabeyy Mbi Naban lextoo, zee zaa nu zhiin ne le xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Lee re nu nzhedizhno Dios nu zaa nu kwent cheen wdizh chul. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Rese xaa nyakla sbaa gaka, zee mleey re xaa: Steb (tub xaa wlipa ngwii lo Jesús, nu nak xaa tub xaa nabeyy doo Mbi Naban cheen Dios lextoo), Lip, Prócoro, Nicanor, Timón, Parmenas, nu Nik (xaa yezh Antioquía, xaa ngok xaa Israel). ");
INSERT INTO zpoNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Zeera mbe re xaa gazh xaa ne pa nzhi re xaa mkayaa yalnabeyy lo Jesús nu lee re xaa mkayaa yalnabeyy lo Jesús mdizhno Dios nu mzhib xaa yaa xaa yek gazh xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lee xtizh Dios mas nzhiyon re xaa, nu lee re xaa Jesús nzhiyak zyen doo Jerusalén. Nu axta zyen ngwleyy mzelo ngwii lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nel nabeyy Mbi Naban lextoo Steb zee mkano xaa yalnkela nu yalngezh cheen Dios, zee mle xaa re kwaan gro lo re xaa yezh. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nu lak re xaa nseed xtizh Dios tub pa le: “Re Myet Libr”, mzelo xaa mkediizh re xaa Steb. Re xaa ne nze yezh Cirene nu yezh Alejandría, nu rop yizhyo kwaan nzhi pa nabeyy Cilicia nu Asia. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Per lee xaa ne nayet roo lo Steb, nel lee Steb nzhedizh kwaan yalnzhak cheen Mbi Naban. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Zee mdix re xaa mka lak xaabyi zee yé xaa lee Steb kanii nawent Ches nu Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nu sbaa mle re xaa, zee yii re xaa yezh nu re xaa gol nu re maestr, xaa nlu ley cheen Ches, zee mzen re xaa Steb, mbe xaa xaa lo re xaa nak zhiin. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nu mkwaan re xaa lak xaa nkade, nzhé: —Xaa ne tubka nawent nii Xkyidoo be nu ley cheen Xdios be. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nu mbin nu nzhé xaa, lee Jesús xaa Nazaret lux yidoo nu chee xaa mod mlaa Ches le be. ");
INSERT INTO zpoNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nu zee lee re xaa nak zhiin kwaan rese xaa nzhi baa mwii lo Steb, nu lee garlo xaa mlu kwenta garlo tub mandad cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Lee ngwleyy non doo mnabdizh lo Steb: —¿Che wli re kwaan né xaa lo nu? ");
INSERT INTO zpoNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nu lee xaa mkeb nzhé: —Xaa gol nu rese xaa sawlazh be, kenzha gu kwaan nii na. Lee Dios, xaa gro doo, mlu lo xey be Abraham, gorna nzo xaa yizhyo Mesopotamia, leezha zer nya xaa yo xaa naz yizhyo Harán. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios nzhé lo xaa: “Laa yizhyo cheen lu nu re sawlizh lu, nu zyaa yizhyo kwaan luu na lo lu”. Gn. 12:1 ");
INSERT INTO zpoNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Zee Abraham mroo yizhyo cheen re xaa Caldea, nu nya xaa ngu xaa yezh Harán. Nu zee ngut xuz xaa, nu gwluzh Dios mbeno Abraham yizhyo ne, pa nzho re be nal. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Per Dios namzaat nik tub lee leyo yizhyo ne lo xaa, per gola tika. Per nzhé xaa lo xaa, lee yizhyo ne gak cheen re dii cheen xaa, gorna yilo yet xaa, per zee Abraham zeeraka kano mad. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nu noka nzhé Dios lo xaa: “Lee re dii cheen lu, yo mod mos cheen stub yezh, tub yizhyo kwaan nanlabeyyt xaa nu ded xaa bid tub tap gayoo liin naz baa”. Gn. 15:13 ");
INSERT INTO zpoNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nu noka nzhé Dios: “Lee na teed bid re xaa nzho yizhyo kwaan mle re dii cheen lu mos nu gwluzh roo xaa zee, nu yaad xaa nee, gool xaa lo na”. Ex. 3:12 ");
INSERT INTO zpoNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kwaanzee mlaa Dios tub wdizh kwaan Abraham, zee Dios mnabeyy Abraham zee yo xaa tub beyy kwaan nak choog xaa tik yed cho xaa. Nu kwaanzee xonaka mbizh nzha ngol xgann xaa Chak, Abraham mchoog tik yed cho mad. Nu seeka mle Chak kwaan xgann xaa Kob, nu lee xaa ne seeka mle kwaan re xgann xaa, xaa ngok xey re chiibchop dii cheen re be. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Re xgann Kob ngok re xey be, xaa yilo. Leeka re wech Che nayii ne Che nu mto re xaa xaa nu zee nya xaa yizhyo Egipto. Per Dios tubka mzo kwaan Che, ");
INSERT INTO zpoNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nu mle xaa yudar xaa lo rese bid kwaan mded xaa. Nu mzaa doo Dios xgab yo yek xaa nu mle xaa zee wen doo kayaa faraón xaa. Faraón ngok rey lo dubse Egipto nu lee xaa mzo Che zee nabeyy xaa lo dubse yizhyo Egipto nu axta garli rey. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Nu zee mla win nu yalnales lo rese yezh cheen Egipto nu Canaán, nu lee re xey be xaa yilo, nankanot xaa kwaan gaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Per gorna mbin Kob nzho nzhobxtil Egipto, zee mxaal xaa re xgann xaa, xaa nak re xey be, xaa yilo. Kwaane ngok welt yilotlaka. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Gorna ngwa re xaa ngok rop welt, Che mlaa ngokbeyy xaa lo re wech xaa, nu snee lee faraón mlabeyy cho dii nak Che. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nu zee Che mxaal xaa zee yaad xuz xaa Kob nu dubse li xaa naz yizhyo Egipto. Re xaa ba ngok tub chon galbchiin myet. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nu snee Kob nya ngu Egipto, nu zee ngut xaa nu seeka ngut re ngwzan be xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nu lee re xchit Kob mbe re xaa nya naz Siquem nu msebyo xaaya leen baa cheen Abraham, kwaana mzi Abraham kwaan demi lo re xinn Hamor, xaa yezh Siquem. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Nu gorna nzha zhin gaxla mbizh kwaan gak kwaan nzhé Dios lo Abraham, lee re xey be ngok zyen doo xaa naz Egipto. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nu zee stub xaa ngok rey cheen re xaa Egipto, nu xaa ne nangunet cho kwaan mle Che. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rey ne mkade lazh be, nu mted xaa bid re xey be, xaa yilo. Nu mnabeyy xaa xaa zee laa xaa yet re xgann xaa, mad pensa ngol. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Re mbizh zee ngol Ches, tub mad nix nzhak lextoo Dios ne. Nu xuz mad nu xnaa mad mxeen mad li xaa chon mbee. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Gorna mlaa xaa mad, lee xchap faraón nguzhal mad nu mxeen me mad kwenta mod xinn me. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nu snee Ches mseed rese kwaan nzhak re xaa Egipto, nu lee xaa ngok tub xaa nzhak nzhedizh wen nu re kwaan nle xaa mreke wen. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Choo liin nzho Ches leezha ngwa xaa lo re sawlazh be, xaa yilo, re dii cheen Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nu gorna ngune xaa lee tub xaa Egipto kazaaya yenn tub sawlazh xaa, Ches mle yudar xaa, nu zee mbit xaa xaa Egipto. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nu Ches mle xgab lee re sawlazh be, zeen lee Dios mxaal lee xaa koo xaa re xaa yizhyo Egipto; per lee sawlazh be namzeenta. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nu stub mbizh, Ches nguzhal chop xey be kadil nu nzhekla xaa nadilt xaa, zee nzhé xaa lo xaa: “Sawlazh be; ¿chozhiin ndil gu kwaan sawlazh be?” ");
INSERT INTO zpoNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Zee lee xaa kazaaya yenn wechxinn, mzob yaa Ches nu nzhé xaa: “¿Cho mzo lu kwenta tub xaa nabeyy lo nu? ");
INSERT INTO zpoNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Che nzhekla lu gut lu na kwentaxa mbit lu xaa Egipto naaze?” Ex. 2:14-15 ");
INSERT INTO zpoNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Gorna mbin Ches kwaane, zee mxonn Ches nu nya xaa ngu xaa yizhyo cheen re xaa Madián, pa ngu xaa kwenta tub xaa stub yezh nu zee ngol chop xgann xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Mded choo liin, Ches nzo wen gax yi Sinaí, zee ngune xaa lo tub mandad cheen Dios, xaa mlu lo xaa lo ki cheen tub yag yich kwaan kayek. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ches mdedyall ngune kwaanzee, nu gorna mbii xaa gax zee wii wen xaa, mbin xaa bos cheen Xaa Nabeyy, kwaan nzhé: ");
INSERT INTO zpoNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Lee na nak Dios cheen re xey lu, xaa yilo, lee na nak Dios cheen Abraham, cheen Chak, nu cheen Kob”. Ex. 3:6 Ches mzelo mxiz sinka mzheb xaa, nu nanzheklat xaa lach xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Zee lee Xaa Nabeyy nzhé lo xaa: “La yelyed nii lu, nel lee pa nzo lu nak leyo nzhul. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Lee na ne, lee re xaa na kaded doo bid yizhyo Egipto. Nzhon na re kwaan mbezh re xaa, nu nzhal na zee ko na re xaa yizhyo Egipto. Kwaanzee te nee, zee xaal na lu Egipto.” Ex. 3:5,7 ");
INSERT INTO zpoNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Leezha nzhé re xey be lo Ches: “¿Cho mzo lu kwenta tub xaa nabeyy lo nu?”, sbaa mlu namkayaat xaa Ches. Nixa sbaa Dios mxaal xaa zee nabeyy xaa re xey be nu Ches ngwa nu mloo xaa re xaa yizhyo Egipto. Nu lee mandad cheen Dios mle yudar xaa, leeka mandad kwaan mlu lo xaa gorna kayek yag yich. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nu Ches ngok xaa mloo re xey be xaa yilo Egipto, nu kwaan yalngezh cheen Dios mle xaaya nu mle xaa zyen doo kwaan gro yizhyo Egipto nu lo Nistoo Naxne nu naz wen tub choo liin. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nu leeka Ches nak xaa nzhé lo re wechxinn xaa: “Lee Dios le zee lo re gu roo tub xaa zaa kwent xtizh xaa kwenta na.” Dt. 18:15 ");
INSERT INTO zpoNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nu leeka Ches nak xaa mzo kwaan sawlazh xaa naz wen. Nu lee mandad cheen Dios ngunii lo xaa yek yi Sinaí, zee Ches nguniiya lo re xey be xaa yilo. Kwaanzee Ches nak xaa mzaa kwent kwaan nzhé Dios lo xaa cheen yalnaban nu nzhé xaaya lo re xey be xaa yilo, zee ne be xomod naka. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Per lee xey be xaa yilo, nanzheklat xaa gon xaa xtizh xaa, nu nzhekla xaa ngbare xaa naz Egipto stuba. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Zee nzhé re xaa lo Aarón: “Baxkwaa re dios kwaan nzho mod lu naz lo re be nu kanap be, nel nanet be cho kwaan ngok kwaan Ches, xaa mloo be Egipto”. Ex. 32:1 ");
INSERT INTO zpoNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Zee mdexkwaa xaa tub maj kwaan nlu kwenta tub la ngoon yeen, nu mteed xaa ma lo maj ne, nu mle xaa tub yalni lo maj kwaan leeka re xaa mdexkwaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kwaanzee Dios mbachii lo re xaa nu mlaa xaa mbill re xaa lo mbizh, lo mbee nu lo re mbal ma nzeb leen yiba. Nel snee mkee tub xaa mzaa kwent kwaan nzhé Dios lo lee xaa: Sawlazh na, xaa Israel. Leezha mkanze xey be wen tub choo liin, ¿cho dios mteed xey be ma lo? Namzaat xey be gon lo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Lee xaa mbe tub yoo kwaan nak ler, pa nzholl xaa lo dios Moloc nu lo mbal cheen dios Refán, re dios kwaan leeka re xaa mdexkwaa nzholl xaa lo. Kwaanzee xaal na xaa mas zit lo Babilonia. Amós 5:25-27 ");
INSERT INTO zpoNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Re xey be xaa yilo, nkano xaa yoo kwaan nak ler pa mbill xaa lo Dios naz wen, kwaan mdexkwaa xaa kwentaxa mnabeyy Dios Ches, gaxkwaa xaaya mod mluya lo Ches. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Re xey be xaa yilo, leezha mded xaa kwaan Josué yizhyo ne mbe xaa yoo kwaan nak ler pa mbill xaa lo Dios. Mle xaa gan yizhyo lo re stub naz yezh, nel Dios mtexonn re xaa yezh zee, zee mkayaa xaa yizhyo ne. Snee lee yoo ne kwaan nak ler, mlake nee axta mbizh cheen rey David. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nu Dios nix doo nzhak lextoo ne David, nu David nzhekla ngaxkwaa xaa tub yidoo pa yo Dios cheen Kob. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per Salomón nak xaa mza yidoo cheen Dios, ");
INSERT INTO zpoNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","nixa Dios nanyut leen yoo kwaan nza myet, kwentaxa ngunii xaa mzaa kwent kwaan nzhé Dios lo lee xaa: ");
INSERT INTO zpoNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Xaa Nabeyy né: “Yiba nak pa nabeey na, nu lee yizhyo nak mod pa nzo nii na. Nyent mod za gu tub yoo pa le na deskans, ");
INSERT INTO zpoNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","nel na mdexkwaa rese kwaan nu dubse yizhyo.” Is. 66:1-2 ");
INSERT INTO zpoNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Noka nzhé Steb: —Nu lee re gu tubka nanzaat gu yek gu gon gu xtizh Dios, nixa nzob nzha gu gon gu per lee lextoo gu ned doo nak. Kwenta re xey be xaa yilo, nanzheklat gu gon gu xtizh Mbi Naban cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Lee re xey be mrenal re xaa mzaa kwent kwaan nzhé Dios lo lee xaa, xaa mzaa kwent yaad Xaa Nali nak. Nu mbit xey be re xaa ne. Nu gorna myaad Xaa Nali nak, re gu mzen xaa nu mbit re gu xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nixa re be mkayaa ley lo mandad cheen Dios, per nambint guya. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Gorna mbin re xaa gol wdizh ne, nayii doo xaa ngune xaa Steb nu mrixyan doo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nu lee Mbi Naban mnabeyy lextoo Steb, zee leezha mwii xaa naz yiba mlu xni cheen Dios lo xaa nu lee Jesús nzo lad li lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Zee nzhé xaa: —¡Wii gu! Mlu yiba lo na nu leeya nzoxal, nu lee Xaa Mzhin Ngok Myet nzo lad li lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nu lee re xaa mbazhe nye, nu msaaw xaa nzha xaa nu mzen xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Zee mloo xaa xaa yezh nu mzaake xaa xaa. Lee re xaa kwaan kazaake xaa, mlaa xchamar xaa lo tub xaa mad le Saulo. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lepa kazaake re xaa Steb, lee xaa nzhedizhno Dios nu nzhé xaa: —Jesús Xaa Nabeyy, kayaa yalnaban cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ngulo ngunii xaa kwaane, zee mkichxub xaa nu mrazhe xaa nye, nzhé xaa: —Xaa Nabeyy, nanaabt lu kwent kwaan kale re xaa ne. Gorna ngulo ngunii xaa kwaane, ngut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo mzak wen mbit xaa Steb. Leeka mbizh zee mzelo re xaa mrenal re xaa Jesús, xaa yezh Jerusalén, zee rese xaa Jesús mxonn nya naz re yezh cheen Judea nu zrol xaa nya naz yizhyo Samaria, nebse re xaa mkayaa yalnabeyy lo Jesús mlake. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Lak xaa ngwii lo Dios, ngwa sebyo Steb nu mbinn doo xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nu lee Saulo mrenal re xaa Jesús, nu axta nya xaa garli re xaa, nu nzhe xaa xaabyi nu ngwnaa nu nchep xaa xaa lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nu lee rese xaa Jesús, xaa mroo Jerusalén, nzaa xaa kwent xtizh Dios kwaan nyaadno yalnaban, rese pa nzha xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Lip le tub xaa nzho lo re xaa ba, nu ngwa xaa yezh kwaan le Samaria. Naz baa mzaa xaa kwent cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nu rese xaa yezh nkenzha re kwaan nzhé Lip, nu ngwii xaa lo re kwaan gro kwaan nle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kwaane nak kwaan mle xaa: msekwen xaa zyen doo xaa kwaan nzho mbi mal lextoo, nu gorna lee mbi mal nroo lextoo re xaa mbazhe xaa, nu noka msekwen xaa zyen xaa nyent mod gun nu xaa mdeen, ");
INSERT INTO zpoNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","kwaanzee nyakdoola re xaa yezh. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Per zee nzho tub xaabyi, xaa le Simón, xaa ngok wezh yilo nu mkade xaa re xaa yezh Samaria, nu mle xaa mod tub xaa non doo. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nu rese myet, xaawin nu xaa gox, ngwii lo xaa nu nzhon xaa xtizh xaa, nu mbezh re xaa: —Xaa ne nkano yalnabeyy mod cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nu nzhon re xaa kwaan mbezh xaa, nel xche doo mkade xaa re xaa yezh lo re kwaan gro kwaan mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Per gorna lee Lip nzaa kwent cheen wdizh chul cheen Jesucrist lo xaa, nu cheen pa nabeyy Dios rop Jesucrist, xaabyi nu ngwnaa mzelo ngwii lo Dios nu mrubnis xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nu axta noka Simón, xaa ngok wezh mzelo ngwii lo Jesús nu mrubnis xaa, nu snee mreke xaa tich Lip, nu ndedyall xaa ngwii xaa lo re yalgro kwaan nlu lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Leezha mzhin diizh lo re xaa mkayaa yalnabeyy lo Jesús lee re xaa Samaria mkayaa wdizh chul cheen Dios, zee mxaal re xaa Pér rop Juan ngwa yezh Samaria. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Gorna mzhin rop xaa ne yezh Samaria, ngunaab xaa lo Dios zee kayaa re xaa Jesús, xaa Samaria, Mbi Naban cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Sbaa mle rop xaa ne nel zer kayaa re xaa Samaria Mbi Naban; nebse mrubnis xaa kwaan yalnabeyy cheen Jesús, Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Zee Pér nu Juan mzhib yaa yek re xaa, nu snee mkayaa re xaa Mbi Naban. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Gorna ngune Simón lee rop xaa mkayaa yalnabeyy lo Jesús nzhib xaa yaa yek re myet, zee lee re myet mkayaa Mbi Naban, zee nzhekla Simón ngzaa demi lo rop xaa ne, ");
INSERT INTO zpoNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kwaanzee nzhé xaa lo xaa: —Zaa gu lo na yalnabeyy kwaan nkano gu ka na, zee noka na gorna zhib na yaa na yek re myet, noka kayaa xaa Mbi Naban cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Zee mkeb Pér lo xaa nzhé: —¡Lu, nu xdemi lu lux, nel mle lu xgab zii lu yalnabeyy kwaan nzelazh Dios kwaan demi! ");
INSERT INTO zpoNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nyent mod kee lu xchiin Dios, nel lee lextoo lu nanakt nali lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Blaa xgab nawent kwaan nkano lu, nu bnaab lo Dios zee chelee nzho moda, chee xaa kwaan nawent kwaan nzho leen lextoo lu, ");
INSERT INTO zpoNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","nel nzeen na nzho yalnayii lextoo lu nu nkadoo lu lo re kwaan nawent kwaan nabeyy lextoo lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nu Simón mkeb nzhé: —Naab gu lo Xaa Nabeyy, zee nyent cho kwaan gak na lo re kwaan né gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Gwluzh ngulo mzaa xaa kwent cheen xtizh Xaa Nabeyy, lee rop xaa mkayaa yalnabeyy lo Jesús, nya naz Jerusalén nu mzaa xaa kwent cheen wdizh chul leen re yezh win cheen Samaria dubse naz. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Gwluzh ngulo mded kwaane tub mandad cheen Xaa Nabeyy nzhé lo Lip: —Gwa nu bzen naz kwaan nkato naz Jerusalén kwaan nzha naz yezh le Gaza —naz ne nded naz wen. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kwaanzee naz zee nzha Lip. Nu baa mzhaal xaa tub xaa non yizhyo Etiopía, xaa nankat ngwnaa. Lee xaa ne nkanap rese xdemi Candace, me nabeyy rese xaa Etiopía. Xaa ne mroo Jerusalén pa nguyoll xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nya xaa lazh xaa nu nzob xaa leen tub karret, nu nya xaa nyilab xaa yech kwaan mkee Chay, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Zee lee Mbi Naban nzhé lo Lip: —Brexonn zee yiga karret ba lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Gorna mbii Lip lo karret, mbin xaa lee xaa Etiopía kalab yech kwaan mkee Chay, zee mnabdizh xaa lo xaa: —¿Che nla kwaan kalab lu yek lu? ");
INSERT INTO zpoNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Lee xaa Etiopía mkeb nzhé: —¿Xomod laya yek na, kwaan nyent cho xaa zaa kwenta lo na xomod naka? —Nu zee nzhé xaa lo Lip— Guxoob nu zob xkwes na nee. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lee kwaan kalab xaa nak kwaane: Wee xaa xaa kwenta tub mbakxiil lo yalgut, nu kwenta tub mbakxiil leezha nchub xaa yich led ma nambazhet ma, nixa lee xaa naniit nik tub wdizh. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Leeka lee xaa le xaa mod tub xaa nanont, kwaanzee nanalit ngunaab xaa kwent lo xaa. Nanzaat xaa kwent cheen re xinn xaa, nel gut xaa xaa. Is. 53:7-8 ");
INSERT INTO zpoNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nu lee xaa Etiopía mnabdizh lo Lip, nu nzhé xaa: —¿Chu zné lu lo na? ¿Cho xaa nzaa xaa ne kwent, che leeka lee xaaya o stub xaa kazet xaa? ");
INSERT INTO zpoNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Zee lee Lip mkeb nzhé lo xaa: —Chay mzaa kwent cheen Jesús. Nu snee mzelo xaa mzaa xaa Kwent Chul cheen Jesús lo xaa Etiopía. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mas gwluzh mzhin xaa tub pa nzho nis nu lee xaa Etiopía nzhé lo xaa: —¡Wii, baa nzho nis! ¿Che nyent mod rubnis na nal? ");
INSERT INTO zpoNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Lee Lip mkeb lo xaa nzhé: —Chelee lu wii lu lo Jesús kwaan dub lextoo lu, nzho mod rubnis lu nal. Nu lee xaa mkeb nzhé: —Ngwii na lo xaa, nu ne na lee Jesucrist nak Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nu mnabeyy xaa xaa nzeno karret zee sekwaz xaa karret, zee lee Lip nu xaa Etiopía mla lo karret zee nzha xaa paro myun nis lo xaa, nu gorna mzhin xaa mzeeb xaa leen nis, zee mchubnis Lip xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Gorna mroo xaa leen nis, lee Mbi Naban cheen Xaa Nabeyy mbe Lip. Nu lee xaa Etiopía nambaretra ngune lo Lip. Nu nyaka xaa xnaz xaa nu nyakdoola xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nu lee Mbi Naban mbe Lip axta yezh le Azoto. Zee mded xaa rese yezh naz baa, nu mzaa xaa kwent cheen wdizh chul, zee mzhin xaa yezh Cesarea. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo nak tub xaa tubka nrenal re xaa Jesús, nel nzhekla xaa seweey xaa xaa nu nzhe xaa xaa lo re xaa gut xaa. Nu kwaanzee ngwa xaa lo ngwleyy non doo, ");
INSERT INTO zpoNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","zee ngunaab xaa yech wee xaa lo xaa nabeyy pa nkasa re xaa Israel nseed xaa xtizh Dios yezh Damasco, nel nzhekla xaa yikwaan xaa re xaa kwaan nzhake tich Naz Kub cheen Jesús, zee wee xaa re xaabyi nu re ngwnaa, nu kado xaa re xaa, zee wee xaa xaa Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Per gorna nzhazhin gaxla xaa yezh Damasco, lee tub xni kwaan nze naz yiba mla dub welt lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nu gorzee ngob Saulo lo yo nu mbin xaa tub bos kwaan nzhé: —Saulo, Saulo, ¿chozhiin nrenal lu na? ");
INSERT INTO zpoNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Lee Saulo mnabdizh: —¿Cho lu, Xaa Nabeyy? Nu lee xaa mkeb nzhé: —Lee na nak Jesús, xaa nrenal lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Guxche nu gwa yezh nu zee né xaa lo lu nen cho kwaan nzhaal le lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Lee re xaa nzha kwaan Saulo mzheb doo xaa; nel mbin xaa bos per nik tub xaa namlut lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Zee nguxche Saulo lo yo, nu gorna mzoli xaa nangnitra garlo xaa, mchool lo xaa. Nu mzen xaa yaa xaa nu mbe xaa xaa yezh Damasco. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Zee ngu xaa chon mbizh nangnit lo xaa, nu nixa nandawt xaa, nu nixa nangut xaa nik tub kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yezh Damasco, nzho tub xaa Jesús, xaa le Ananías. Nu lo xaa ne ngunii Xaa Nabeyy lo mkaal, nu nzhé xaa lo xaa: —¡Ananías! Nu lee xaa mkeb nzhé: —Nee nzo na Xaa Nabeyy, ¿cho kwaan né lu lo na? ");
INSERT INTO zpoNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Zee lee Xaa Nabeyy nzhé lo xaa: —Guxche nu gwa naz kay kwaan le Nali, nu garli Judas nabdizh lu Saulo, tub xaa yezh Tarso, nel lee xaa kawdizhno na. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nu mlu lo xaa lee tub xaabyi le Ananías, zhib yaa yek xaa, zee nzho mod wii xaa stuba. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nu gorna mbin Ananías kwaane, zee nzhé xaa: —Xaa Nabeyy, zyen doo xaa nzaa kwent cheen xaa ba nu rese kwaan nawent kwaan mle xaa lo re xaa mle nambey lu, naz Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nu nal nze xaa nee, kwaan diizh cheen ngwleyy non doo, zee kado xaa rese xaa nzholl lo lu nu wee xaa xaa naz Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Per lee Xaa Nabeyy nzhé lo xaa: —Gwa, nel na mleey xaabyi ba zee zaa xaa kwent cheen na lo re xaa nanakt xaa Israel, nu lo re xaa nabeyy dubse yizhyo, nu noka lo re xaa sawlazh lu, xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na luu lo xaa nzhaal ded doo xaa bid zaa xaa kwent cheen na. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías ngwa garli Judas pa mlaz Saulo, mzeeb xaa nu mzhib xaa yaa xaa yek xaa, nu nzhé xaa lo xaa: —Wech Saulo, lee Jesús Xaa Nabeyy be, xaa mlu lo lu naz gorna nzha lu, mxaal na zee bare lu wii lu stuba nu zee nabeyy Mbi Naban cheen Dios lextoo lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Leeka gorzee ngob tub kwaan nzhak kwenta tub med mbal zaalo Saulo nu mkaxni zaalo xaa stuba. Zee nguxso xaa zee mrubnis xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Gwluzh zeera ndaw xaa zeera ngu jwers lo xaa, nu mlaz xaa lak mbizh kwaan re xaa Jesús, xaa nzho yezh Damasco. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nu zeera lee Saulo mzelo mzaa kwent xtizh Dios pa nkasa xaa Israel nseed xaa xtizh Dios, nu mbezh xaa lee Jesús nak Xgann Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nu re xaa nzhon kwaan nii xaa ndedyall xaa, nu mbezh xaa: —¿Che nalet xaa ne, nak xaa nrenal re xaa ngwii lo Jesús yezh Jerusalén? ¿Nu che nanzet xaa nee, zee wee xaa xaa Jesús nu kado xaa xaa, zee zaa xaa xaa lo re ngwleyy non? ");
INSERT INTO zpoNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Per mas nzhiyu yek Saulo nu nsegan xaa yek re sawlazh xaa, xaa nzho Damasco. Klar doo mlu xaa, lee Jesús nak Crist, Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nu nzha zyen mbizh, lee re sawlazh xaa myaan zee gut xaa Saulo, ");
INSERT INTO zpoNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","per mbin Saulo nzhekla xaa gut xaa xaa. Zhe nu yaal nkambaz xaa xaa roo yezh, zee gut xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Per tub yaal lee re xaa Jesús, xaa mseed kwaan lee xaa, nguxoob xaa kwaan Saulo yek bla kwaan nyaaw dubse yezh, nu mlo xaa xaa leen tub chekwid naro, nu msela xaa xaa naz tich bla. Snee mle xaa gan mroo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nu gorna lee Saulo mzhin Jerusalén, nzhekla xaa ngzhaal xaa kwaan re xaa Jesús; per lee re xaa ne nzheb ne xaa, nel nanlet xaa krer lee xaa nak tub xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Per Bernabé mbe xaa lo re xaa mkayaa yalnabeyy lo Jesús, nu nzhé xaa lo re xaa lee Saulo ngune lo Xaa Nabeyy naz kwaan nya naz Damasco, nu lee Xaa Nabeyy ngunii lo xaa, nu xomod Saulo mzaa kwent cheen Jesús kwaan dub lextoo xaa leen yezh Damasco. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nu snee lee Saulo mlakeka Jerusalén nu nze xaa kwaan re xaa. Nii xaa kwent cheen Jesús kwaan yalnabeyy cheen Xaa Nabeyy, nu nanzhebt xaa nzaa xaa kwent xtizh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nu nkediizh xaa kwaan re xaa sawlazh, xaa nzhedizh gryeg; per lee re xaa ne nzhekla gut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Gorna lee re xaa Jesús mzeen kwaane, mbe xaa Saulo yezh Cesarea, nu zee mxaal xaa xaa naz yezh Tarso. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kwaanzee nik stub xaa nanrenalt xaa Jesús. Nu rese xaa Jesús, xaa re yezh cheen Judea, nu Galilea nu Samaria mas nye nzo lo Dios, nu nabeyyra Mbi Naban lextoo xaa. Nu ngok zyenra xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Lee Pér nzha re yezh nu noka ngwasewii xaa lo rese xaa Jesús, xaa nambey, xaa nzho yezh Lida. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Zee mlabeyy xaa tub xaabyi le Eneas, xaa nzhala xon liin nzho loon, nu nyent mod gun xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pér nzhé lo xaa: —Eneas, Jesucrist sekwen lu. Guxche nu blis xda lu. Nu gorzee nguxche Eneas. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nu rese xaa nzho yizhyo Lida nu yizhyo Sarón ngune ngokwen xaa, nu mlaa xaa re krens cheen xaa nu ngok xaa xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ngu tub ngwnaa yezh Jope le Tabita, (xtizh gryeg le me Dorcas). Nu lee me nak tub xme Jesús, nu tubka nle me kwaan wen nu nle me yudar re xaa nkin kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tub mbizh zee, Tabita mzen tub yalyizh ta ngut me. Nu ngulola msegaz me kwerp cheen me, zee mzhib xaa me leen tub yoo kwaan nak stub pis. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lee re xaa Jesús ngune lee Pér nzo yezh Lida, nu gax nzhi yezh Lida kwaan yezh Jope, kwaanzee mxaal xaa chop xaabyi yichezh Pér, nu nzhé xaa lo Pér: —Chaa prad nya be yezh Jope. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Zee mreke Pér tich rop xaa ba. Nu gorna mzhin xaa mbe xaa Pér pa nzhib kwerp cheen me ngut, nu rese byud nzhi dub welt lo me nzhonn, nu mlu me re ler kwaan ngaxkwaa Dorcas leezha mbanaka me. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Zee lee Pér mloo rese xaa leen yoo, nu mkichxub xaa nu ngunaab xaa lo Dios, zee mwii xaa lo me ngut nu nzhé xaa: —Tabita. ¡Guxche! Lee me mxal zaalo, nu gorna ngune me lo Pér, gorzee mzob me. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Lee xaa mzen yaa me nu mlisxo xaa me; zeera mrezh xaa re xaa Jesús nu re byud, re xaa nambey, nu mlu xaa me lo re xaa naban me. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kwaane ngune re xaa dubse yezh Jope nu zyen doo myet mzelo ngwii lo Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pér mlaz lak mbizh yezh Jope li Simón, tub xaa nak xaa nseguuzh yed. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nu ngu tub xaa le Kornel yezh le Cesarea, lee xaa nabeyy lo tub gayoo soldad, kwaan le Italia. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Lee xaa nak tub xaabyi nzholl lo Dios, kwaan rese xaa li xaa. Noka nzaa xaa gro doo demi nle xaa yudar re xaa prob, xaa Israel, nu tubka nzhedizhno xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tub mbizh kan las tres, mchaa lextoo xaa nu lo tub mkaal kwaan mlu Dios lo xaa, klar myun tub mandad cheen Dios lo xaa, xaa mrep paro nzo xaa nu nzhé lo xaa: —¡Kornel! ");
INSERT INTO zpoNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Mzheb doo xaa gorna ngune xaa lo mandad cheen Dios zee nzhé xaa: —¿Cho kwaan né lu lo na, Xaa Nabeyy? Lee mandad cheen Dios nzhé lo xaa: —Mbin Dios rese kwaan nzhé lu lo xaa nu ne xaa xomod nle lu yudar re xaa nkin kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bxaal lak xaa yezh Jope zee yichezh xaa Simón zee yiid Simón nee, xaa noka le Pér. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Lee xaa nzho li stub Simón, xaa nseguuzh yed, xaa nzob li gax roo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Gorna lee mandad cheen Dios nya, Kornel mrezh chop xmos, nu tub soldad, xaa nle yudar xaa, xaa nzholl lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nu gorna ngulo mzaa xaa kwent re kwaan mded, zee mxaal xaa xaa yezh Jope. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nu rolta mbizh stub mbizh nzhazhin xaa gax yezh Jope. Nu lee Pér nguxoob lo tub skaler yek yoo zee wdizhno xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nlaan xaa nu nzhekla xaa gaw xaa, per gorna kadexkwaa me kwaan gaw xaa, gorzee mlu tub kwaan lo xaa, ");
INSERT INTO zpoNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","lee yiba mxal nu nzela tub lee ler naro naz lo yo, kwaan nkadoo dap punt. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nu lo ler nzho rete ma, nu re mball, nu re mbyin. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nu mbin xaa tub bos kwaan nzhé lo xaa: —Pér, guxso, bit ma nu daw ma. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pér mkeb nzhé: —Nyent moda, Xaa Nabeyy; nel na nik tub welt zer gaw na tub ma nanzhult nu ma nanambeyt. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nu lee bos mbare ngunii stuba, nu nzhé lo xaa: —Rese kwaan mle nzhula na, naniit luya kwaan nanzhult. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kwaane ngok chon welt, nu zeera lee ler naro mbare nguxoob naz yiba stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pér mle xgab cho kwaan nak kwaan mlu lo xaa, gorzee mzhin re xaa mxaal Kornel roo pwert, xaa ngunabdizh pa nzob li Simón. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Gorna mzhin xaa, mnabdizh xaa zee ne che nzho tub xaa le Simón, xaa noka nlabeyy re xaa mod Pér. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nu lee Pér seetaka kale xgab kwaan mlu lo xaa, nu lee Mbi Naban nzhé lo xaa: —Wii, chon xaabyi kakwaan lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Guxso, nu bla, nu gwa kwaan re xaa, nu nalet lu xgab, nel na mxaal xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pér mla nu nzhé xaa lo re xaabyi zee: —Na nak xaa kakwaan re gu. ¿Nu chozhiin kakwaan gu na? ");
INSERT INTO zpoNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Lee re xaa mkeb nzhé: —Nze nu kwent cheen Kornel, xaa nabeyy lo tub gayoo soldad. Lee xaa nak tub xaabyi wen, tub xaa nreke tich Dios, nu rese xaa Israel nkela xaa. Tub mandad cheen Dios nzhé lo xaa, nzhaal kwezh xaa lu, zee ya lu garli xaa zee lee xaa kenzha kwaan nzhaal yé lu lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Zee lee Pér nzhé lo re xaa: —Bzeeb gu. Nu mlaz xaa kwaan Pér dubse yaal zee. Nu lee stub mbizh, Pér ngwa kwaan re xaa, nu mreke lak wech, xaa Israel xaa nzho Jope, tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nu lee stub mbizh mzhin xaa yezh Cesarea, paro nkambaz Kornel xaa, kwaan lak sawlizh xaa nu xmig xaa, xaa mrezh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Gorna mzhin Pér garli Kornel, gorzee mroo Kornel ngunii lo xaa, nu mkichxub xaa lo xaa, nu mbill xaa lo xaa kwenta lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Per lee Pér mlexso xaa nu nzhé lo xaa: —Bzoli, nel ropse be nak myet. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nu kayadizh rop xaa Kornel, nu zeera mzeeb xaa leen yoo zee ngune xaa zyen doo myet nzhi. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pér nzhé lo re xaa: —Ne gu lee re nu, xaa Israel, nanzeyalt ley cheen nu zhaal nu kwaan xaa stub yezh nu nixa nyent mod zeeb nu leen li xaa stub yezh. Per lee Dios mseed na, nanzhaalt le na xgab nanzhult nak xaa stub yezh. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kwaanzee lijer doo nzhal na gorna mrezh Kornel na, nu namzot na nik tub diizh leeya nyent mod. Kwaanzee nzhekla na ne na, chozhiin mrezh gu na. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornel mkeb nzhé: —Nzha tap mbizh kan gor neeka las tres, na nzo garli na nee nu kawdizhno na Dios, gorzee mlu tub xaabyi nak tub ler rus kwaan nla doo xni lo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nu né xaa lo na: “Kornel, Dios mbin kwaan nzhé lu lo xaa, nu ne xaa xomod mle lu yudar re xaa nkin kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bxaal lak xaa yezh Jope zee yichezh xaa lo Simón, xaa noka le Pér yiid xaa nee. Lee xaa nzho garli Simón, xaa nseguuzh yed, xaa nzob li gax roo nistoo.” ");
INSERT INTO zpoNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kwaanzee gorzee mxaal na lak xaa yakwaan lu, nu wen mle lu nze lu lo nu nee. Nal nzhi re be nee lo Dios, nu nzhekla nu gon nu rese kwaan nzhekla Xaa Nabeyy seed lu nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Zee lee Pér mzelo ngunii, nu nzhé: —Nalsi, ne na lee Dios nzak lal nak re myet, ");
INSERT INTO zpoNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","nu nkayaa xaa rese xaa nzhon xtizh xaa nu nle kwaan wen, nixa chol xaa stub yezh nak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nu sbaa mlu Dios leezha mxaal xaa Jesucrist lo re nu, xaa Israel, nel lee xaa nak Xaa Nabeyy rese myet. Nu lee xaa mzaa kwent zee nzho mod kwi wen re myet kwaan Dios kwent cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Re gu ne re kwaan ngok lazh nu. Jesucrist mzelo mzaa kwent xtizh Dios leezha mchubnis Juan re myet naz yizhyo Galilea nu noka dubse yizhyo Judea. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Lee Dios mle nabeyy Mbi Naban lextoo Jesús, xaa Nazaret, zee nzho mod le Jesús rese kwaan. Nu ne gu xomod mle Jesús re kwaan wen, nu xomod msekwen xaa re xaa ne nzak nu xomod mloo xaa re mbi mal lextoo re xaa. Kwaane mle xaa nel Dios mzo kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Lo re nu mlu rese kwaan mle Jesús sawlazh nu, nu nzaa nu kwent cheena. Zeera nya xaa naz Jerusalén, nu mbit xaa xaa, leezha mkenga xaa xaa lo tub krus. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Per Dios mseban xaa ngok yon mbizh, nu mle zee mlu xaa lo re nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Namlut xaa lo rese xaa yezh, nebse lo re nu, xaa mleey Dios yilo, nu nzaa nu kwent cheen yalmroban cheen xaa. Ndaw nu nu ngu nu kwaan lee xaa gwluzh gorna mroban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nu lee xaa mxaal nu zaa nu kwent cheen xaa, nel mbizh gwluzh naab xaa kwent lo re xaa mban nu lo re xaa ngut. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Noka rese xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, mzaala xaa kwent cheen xaa, nu nzhé xaa: “Loka xana xaa ngwii lo xaa, ngulola mzhe re jwalt cheen xaa zee”. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Seetaka kanii Pér, gorna lee rese xaa kayon xtizh Dios kwaan kanii Pér, mkayaa Mbi Naban. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nu lee rese xaa Jesús, xaa Israel, xaa ngwa kwaan Pér, ndedyall doo ngune lee re xaa nanakt xaa Israel noka mkayaa Mbi Naban cheen Dios, ");
INSERT INTO zpoNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","nel mbin xaa nzhedizh xaa stub naz diizh kwaan nagakt xaa nu nzholl xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Zee lee Pér nzhé lo re wech kwaan nzha kwaan lee xaa: —Nyent mod yé tub xaa lee re myet nee nyent mod rubnis, nel noka lee xaa mkayaala Mbi Naban kwenta re be. ");
INSERT INTO zpoNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nu mnabeyy Pér xaa zee rubnis xaa kwaan yalnabeyy cheen Jesucrist. Gwluzh zee mnaab re xaa lo Pér zee kwaz Pér kwaan re xaa lak mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Lee re xaa mkayaa yalnabeyy lo Jesús, nu re xaa Jesús, xaa nzho Judea mbin xomod lee re xaa nanakt xaa Israel mbin xaa xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Gorna lee Pér mbare naz Jerusalén, zee lee lak xaa Jesús, xaa ngwii doo lo beyy cheen re xaa Israel, mgalno xaa Pér, ");
INSERT INTO zpoNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nu nzhé xaa lo xaa: —¿Chozhiin ngwa lu lo re xaa nanakt sawlazh be, xaa nanzhot beyy cheen be, nu axta ndaw lu kwaan re xaa zee? ");
INSERT INTO zpoNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Zee lee Pér nzhé lo re xaa rese kwaan mded axta yilo lo re xaa. Nu nzhé xaa lo re xaa: ");
INSERT INTO zpoNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Gorna mzo na yezh Jope nu kawdizhno na Dios, mlu tub kwaan lo na. Ngune na lo tub lee ler naro kwaan nkadoo dap skin, nyaadla naz leen yiba axta pa nzo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nu mlach wen na zee ne na nen cho kwaan nzho leena, nu mlu re rete ma lo na, re ma nakap, nu re mball, nu re mbyin. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nu mbin na tub bos kwaan né lo na: “Pér, guxso, bit ma nu daw ma”. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nu lee na mkeb nzhé: “Nyent moda, Xaa Nabeyy, nel leen roo na zer zeeb nik tik kwaan nanambeyt nu kwaan nanzhult”. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Zee lee bos kwaan nze naz yiba ngunii lo na stuba nu né: “Rese kwaan mle nzhula Dios, naniit luya tub kwaan nanzhult”. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kwaane ngok chon welt, nu zeera mbareya nguxooba naz yiba stuba. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nu gorzee lee chon xaabyi mzhin roo yoo pa nzhi re nu, xaa ne mroo axta Cesarea nu nzekwaan xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Lee Mbi Naban né lo na: “Gwa kwaan lee xaa nu nalet lu xgab.” Nu noka xop wech ne ngwa kwaan na. Rese nu mzeeb leen li Kornel, ");
INSERT INTO zpoNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","nu mzaa xaa kwent lo nu xomod ngune xaa lo tub mandad cheen Dios, xaa nzhé lo xaa: “Bxaal lak xaa ya yezh Jope zee yichezh xaa Simón zee yiid Simón nee, xaa noka le Pér. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Lee xaa né lo lu nu lo rese xaa li lu, nen xomod le gu gan yalnaban kwaan tira.” ");
INSERT INTO zpoNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nu gorna mzelo na mza na kwent lo xaa, lee re xaa mkayaa Mbi Naban kwentaxa mkayaa be Mbi Naban yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Zee mselazh na kwaan nzhé Xaa Nabeyy: “Wli, lee Juan mchubnis kwaan nis, per lee re gu rubnis kwaan Mbi Naban cheen Dios”. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kwaanzee, chelee Dios mzaa lo re xaa kwaan mzaa xaa lo be, gorna mwii be lo Jesucrist Xaa Nabeyy be, nyent mod yé na nawent kwaan kale Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Gorna lee re xaa Jesús, xaa Jerusalén mbin re wdizh ne, nanayiitra xaa, nu mbill xaa lo Dios, nu nzhé xaa: —¡Noka lo re xaa nanakt xaa Israel mzaa Dios yalnkela cheen xaa, zee laa xaa re kwaan nawent nu wii xaa lo xaa, zee le xaa gan yalnaban kwaan tira! ");
INSERT INTO zpoNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Gwluzh ngulo ngut Steb, zee mzelo re xaa mrenal re xaa Jesús, nu kwaanzee lee lak xaa mxonn nya naz yizhyo Fenicia, zlak xaa nya naz yizhyo Chipre nu zlak xaa nya naz yezh Antioquía. Nu mzaa re xaa ne kwent cheen wdizh chul lo re sawlazh xaa, per namzaat xaa kwent cheen wdizh chul lo re xaa nanakt xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Per lee lak xaa nze naz yizhyo Chipre nu xaa nze yezh Cirene, mzhin yezh Antioquía nu mzaa xaa kwent cheen Jesús, Xaa Nabeyy be, noka lo re xaa nanakt xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nu lee yalngezh cheen Xaa Nabeyy nzo kwaan re xaa zee, kwaanzee zyen doo xaa mzelo ngwii lo Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Re xaa Jesús, xaa nzho yezh Jerusalén, gorna mbin xaa kwaane, zee mxaal xaa Bernabé naz yezh Antioquía. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Gorna mzhin Bernabé, ngune xaa re kwaan gro kwaan mle Dios, nu nyak doo lextoo xaa. Nu nzhé xaa lo re xaa: —Ble nali gu lextoo gu nu nye bzo gu lo re xcheen Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nel lee Bernabé nak tub xaabyi wen, xaa nabeyy Mbi Naban cheen Dios lextoo nu tubka ngwii xaa lo Jesús. Nu snee zyen doo myet mzelo ngwii lo Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nu zee mroo Bernabé baa, nu ngwa xaa yezh Tarso ngukwaan xaa Saulo, ");
INSERT INTO zpoNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","nu gorna nguzhal xaa lo xaa, mbe xaa xaa naz yezh Antioquía. Zee mlaz xaa tub liin kwaan re xaa Jesús, nu mseed xaa zyen doo myet. Nu Antioquía ngok pa ngunii re xaa lo re xaa Jesús “cristianos” yilotlaka. (Wdizh ne nii: “Xaa nreke tich Crist”.) ");
INSERT INTO zpoNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nu re mbizh zee, lak xaa mzaa kwent kwaan nzhé Dios lo lee xaa mroo Jerusalén nu ngwa xaa naz Antioquía. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nu lee tub xaa ba le Agabo, nu mzelo xaa ngunii kwaan mzaa Mbi Naban lo xaa, nu nzhé xaa lo re xaa: —La tub win gro doo dubse yizhyo pa nabeyy Roma. Kwaane ngok gorna lee Law mnabeyy dubse Roma. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Zee lee rese xaa Jesús, xaa nzho yezh Antioquía, mxaal ayud lo re xaa Jesús, xaa nzho yizhyo Judea; kad xaa mzaa loka paroya nzho mod zaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nu snee mle xaa; zee mxaal xaaya lo Bernabé rop Saulo zee yalaa xaaya lo re xaa gol xaa Jesús, xaa nzho yizhyo Judea. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Re mbizh zee, lee rey Herod mzelo mrenal re xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Mnabeyy xaa zee gut xaa Chag, wech Juan, kwaan espad. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nu ngune xaa lee kwaane nak kwaan nyula re xaa Israel, kwaanzee noka mzen xaa Pér. Re kwaane ngok leezha mla yalni cheen Paskwa, re mbizh kwaan nzhaw xaa pan kwaan nanyut lebadur. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kwaanzee Herod mzen Pér, nu mchep xaa xaa lozhyib, nu mnabeyy xaa kanap tub chiinmtub soldad xaa, per namkanapt re soldad xaa tubka junt, sinka tapga soldad mkanap xaa. Nzhekla xaa luu xaa xaa lo re xaa yezh yilo ded yalni cheen Paskwa, zeera gut xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nu snee lee Pér nzho lozhyib, per lee re xaa Jesús tubka naab xaa lo Dios zee kanap Dios Pér. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Leeka yaal kwaan nzhé Herod luu xaa xaa lo re xaa yezh, Pér naxna xsaww lo chop soldad, nu nkadoo xaa kwaan chop kaden nu lee stub naz soldad nzhi nkanap roo pwert. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nu gorzee lee tub mandad cheen Dios mzhin lo xaa nu dubse lozhyib mla xni. Lee mandad cheen Xaa Nabeyy mgal cho Pér, mloo mkaal lo xaa, nu nzhé lo xaa: —¡Guxche nal gor ne! Nu gorzee lee kaden mxek yaa Pér. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nu lee mandad cheen Dios nzhé lo xaa: —Gok xab lu nu kee xkyelyed lu nii lu. Nu snee mle Pér, zee lee mandad cheen Xaa Nabeyy nzhé lo xaa: —Gok xchamar lu nu breke tich na. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pér mreke tich mandad cheen Xaa Nabeyy, nixa nanet xaa che wli o nawlit kwaan mlu lo xaa, nzak xaa kachaa lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Rop xaa mded lo lak soldad xaa nkanap, nu sneeka mded xaa lo stub lak soldad xaa nkanap, nu zee mzhin xaa roo pwert yiib kwaan nyaww naz jwer, lee pwert techo mxal. Mroo rop xaa nu mze rop xaa mandad cheen Xaa Nabeyy xep, zeera mlaa xaa techo Pér. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Zeera Pér mzeen kwaan ngok, nu mle xaa xgab leen lextoo xaa: “Nalsi, ne na lee Xaa Nabeyy mxaal mandad cheen xaa mloo xaa na lozhya Herod, nu lo rese kwaan nzhekla re sawlazh na le na”. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Gwluzh ngulo mzeen wen xaa kwaan ngok, Pér nya garli Mari, xnaa Juan (xaa noka le Mark), pa nzhi zyen xaa kawdizhno Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nu gorna mzhin xaa mkwezh xaa roo pwert kwaan nkee roo naz, nu tub ngwnaa mad le Rode, me nak tub mos, mroo mwii nen cho xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nu gorna mbin me bos, mlabeyy me bos cheen Pér, nu tant nyakdoola me, myenlazh me ngxal me roo pwert, nu mrexonn me nya me nu mle me yabis lee Pér nzo roo pwert naz jwer. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Lee re xaa nzhé lo me: —¡Nkade lu! Per lee me nzhé: —Wli kwaan ngunii na lo gu. Lee re xaa mbezh: —Naleet xaaya, besa. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Per lee Pér seetaka kakwezh roo pwert nu gorna mxal xaa roo pwert ngune xaa lo xaa, nu rese xaa mdedyall doo. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pér mlis yaa nu mle xaa tub nseyn zee nawdiizht re xaa, nu mzaa xaa kwent nen xomod mloo Xaa Nabeyy xaa lozhyib nu nzhé xaa lo re xaa: —Guzh gu re kwaane lo Chag nu lo re stub naz xaa Jesús. Zee mroo Pér nu nya xaa stub pa. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Gorna mkaxni yizhyo, lee re soldad mrech nel nanet xaa pa naz nzha Pér. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod mnabeyy kwaan xaa xaa, per nel nyent mod ngzhaal xaa lo xaa, zee mgaazh xaa kwaane tich re xaa nkanap roo lozhyib. Nu mnabeyy xaa zee gut xaa re soldad zee, nel mlaa xaa mle Pér gan. Gorna ngulo mded re kwaane, Herod mroo Judea nu nya xaa ngu xaa naz yezh Cesarea. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod nayii doo ngune re xaa rop yezh Tiro nu Sidón. Nu nel Tiro nu Sidón mkayaa xaa kwaan nzhaw xaa lazh Herod, mkwaan re xaa rop yezh ne nen xomod kwi wen xaa kwaan Herod. Mle xaa gan myenn xaa kwaan Blasto, tub xaa non nkee zhiin garli rey Herod, zee le xaa yudar xaa zee kwi wen xaa kwaan Herod. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nu mbizh nakladiizha, lee Herod ngok ler chul doo kwaan nzhak re rey, nu mzob xaa pa nzob re rey, nu ngunii xaa lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Zee lee re myet mzelo nye ngunii nu nzhé xaa: —¡Lee xaa kanii nanakt tub myet, lee xaa nak tub dios! ");
INSERT INTO zpoNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Leeka gorzee lee tub mandad cheen Xaa Nabeyy mle mzen yalyizh Herod, nel namzaat xaa kwent lo Dios. Nu ndaw myaz xaa zee ngut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Per lee xtizh Dios mrech reta yezh, nu mzelo re xaa ngwii lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Gorna Bernabé nu Saulo mlux xaa xchiin xaa yezh Jerusalén, mbare xaa yezh Antioquía. Nu mbe rop xaa Juan, xaa noka le Mark. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lo re xaa Jesús, xaa yezh Antioquía, nzho xaa nzaa kwent kwaan nzhé Dios lo lee xaa nu nzho maestr. Lee xaa nak Bernabé, Simón (xaa noka nii xaa lo “Nagaas”), Lus (xaa yezh Cirene), Manaen (xaa mxeen kwaan Herod, xaa mnabeyy Galilea), nu Saulo. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tub mbizh lee re xaa ne mkwan nu nandawt xaa nik tub kwaan zee mbill xaa lo Xaa Nabeyy, nu lee Mbi Naban nzhé lo re xaa: —Bloxcho gu Bernabé nu Saulo zee kee xaa xchinn na, kwaanzee mrezh na xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nu gorna ngulo mkwan xaa nu mdizhno Dios, zee mzhib xaa yaa xaa yek Bernabé nu Saulo, zee mxaal xaa xaa yizaa xaa Wdizh Chul cheen Jesucrist. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nu Mbi Naban mbe Bernabé rop Saulo axta yezh Seleucia, nu zee mzen xaa bark mzhin xaa tub yizhyo nzhi xsaww nistoo kwaan le Chipre. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nu gorna mzhin xaa yezh cheen Salamina, mzelo xaa mzaa xaa kwent xtizh Dios pa nkasa re xaa Israel nseed xaa xtizh Dios. Noka Juan nzha kwaan rop xaa zee le yudar xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Mded xaa dubse yizhyo Chipre nu mzhin xaa yezh le Pafos, pa nguzhal xaa tub xaa Israel, xaa le Barjesús; nu lee xaa ne nak tub wezh nu mbezh xaa nak xaa tub xaa nzaa kwent kwaan nzhé Dios lo lee xaa, per nawlit xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Xaa ne nzhaal kwaan Sergio Paulo, xaa nabeyy yizhyo Chipre. Nu Sergio Paulo nak tub xaa nzho doo yek. Zee mxaal Sergio Paulo mrezh Bernabé rop Saulo nel nzhekla xaa gon xaa xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Per lee wezh, xaa le Barjesús, xaa noka le Elimas xtizh gryeg, nanzheklat lee xaa nabeyy Chipre gon xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nu mnabeyy Mbi Naban cheen Dios lextoo Saulo, xaa noka le Pab, nu mlach xaa lo xaa, ");
INSERT INTO zpoNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","zee nzhé xaa lo xaa: —¡Lee lu nak tub xaa nkade, xaa mal, xinn Maxuu, xaa nzhekla lux rese kwaan wen! ¿Chozhiin tubka nsaaw lu naz nali cheen Xaa Nabeyy? ");
INSERT INTO zpoNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nal lee Xaa Nabeyy ted lu bid. Nal lee lu chool lo tub tyemp, zee nyent mod wii lu che zheya o yaala. Nu leeka gorzee mla tub yalnakaw lo Barjesús, nu nyent mod wii xaa, nu nkwaan xaa tub xaa zen yaa xaa, nel nik tub kwaan nanyunt lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nu gorna ngune xaa nabeyy yizhyo zee kwaane, mle xaa krer xtizh Xaa Nabeyy nu ndedyall xaa mbin xaa re kwent cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pab nu re xaa nzha kwaan lee xaa, mrep xaa leen bark yezh Pafos nu ngwa xaa axta yezh Perge, yizhyo cheen Panfilia; per Juan (xaa noka le Mark) mlaa xaa rop xaa nu mbare xaa naz Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pab rop Bernabé mroo Perge, nu ngwa xaa yezh Antioquía, kwaan nzhi lo yizhyo Pisidia. Lee mbizh kwaan nkasa xaa Israel nseed xaa xtizh Dios, mzeeb rop xaa pa nkasa re xaa, nu mzob xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Gwluzh gorna ngulo mlab xaa kwaan mkee Ches nu kwaan mkee re xaa mzaa kwent kwaan nzhé Dios lo lee xaa, zee lee re xaa nabeyy pa nkasa re xaa Israel, nzhé xaa lo Pab rop Bernabé: —Wech na. ¿Che nzhekla gu nii gu tub kwaan, zee zaa gu balor lextoo re myet ne? ¡Nii guya nal! ");
INSERT INTO zpoNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Zee lee Pab nguxso nu mle xaa nseyn kwaan yaa xaa zee nakeet re xaa rezh, nu nzhé xaa: —Kenzha rese gu xaabyi, xaa lazh na, nu noka re gu, xaa stub naz re yezh, xaa nzheb ne Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lee Dios cheen be mleey re xey be xaa yilo, nu mle xaa xaa zyen doo xaa leezha nzhoka xaa Egipto, mod xaa stub yezh. Nu gwluzh Dios mloo xaa yizhyo zee kwaan yalngezh cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nu myela Dios ne re xey be tub choo liin leezha nzha xaa naz wen. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Zee mlux xaa tub gazh yizhyo pa le Canaán, zee zaa xaa leyo cheen re xaa zee lo re xey be, xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Rese kwaane ngok tub tap gayoo nzho choobchii liin. Gwluzh mlaa Xaa Nabeyy re jwes lo xey be axta re mbizh cheen Samuel, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Zee lee re xaa ngunaab tub rey zee nabeyy xaa xaa; nu lee Dios mleyy Saúl, xinn Cis lo xaa, xaa nak dii cheen Benjamín. Nu mnabeyy xaa lo re xaa tub choo liin. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Gorna mkiib Dios Saúl mod rey lo re xaa, zee mzaa Dios David gak rey cheen xaa, nu nzhé Dios: “Lee David xinn Isaí, nak tub xaa nyula na ne na, lee xaa le rese kwaan nzhekla na.” ");
INSERT INTO zpoNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Leeka lo xben David myaad Jesús, xaa ne mxaal Dios koo re sawlazh be lo yalgut, nu zee zaa xaa yalnaban kwaan tira, kwentaxa nzhéla xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Leezha zeeraka yaad Jesús, Juan mzaa kwent xtizh Dios lo rese sawlazh be. Mbezh xaa nzhaal laa xaa re kwaan nawent kwaan kale xaa nu wii xaa lo Dios zee rubnis xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nu leezha merla lux Juan xchiin xaa, nzhé xaa: “Nanakt na xaa nle re gu xgab, nanakt na Xaa Xaal Dios Nabeyy; per tich na nze tub xaa nixa xkyelyed xaa kwaan nkee nii xaa nanzhaalt la na. Nel nik tik nanont na lo xaa.” ");
INSERT INTO zpoNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Re gu sawlazh be, xaa nak dii cheen Abraham, nu rese gu, xaa nzheb ne Dios, xaa stub yezh; lee diizh cheen yalnaban ne nak cheen re be. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nel lee re xaa nzho Jerusalén, nu re xaa nabeyy lo xaa, namzaat xaa yek xaa gon xaa xtizh Jesús, nixa namlaat yek xaa re kwaan mkee re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, mer kwaana nlab xaa re mbizh nzholl be lo Dios. Mle xaa zee mbarlo re kwaan mkee xaa ne, leezha mzaa xaa Jesús lo yalgut. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nixa nanguzhalt nik tub kwaan gaazh xaa tich xaa, zee nzho mod gut xaa xaa, per nzhé xaa lo Pilat: “¡Bit xaa!” ");
INSERT INTO zpoNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Gorna ngulo mle xaa xaa rese kwaan, mod nzaa Xkyech Dios kwent, mla xaa xaa lo krus nu msebyo xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","¡Per Dios mseban xaa! ");
INSERT INTO zpoNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nu zyen doo mbizh mlu Jesús lo re xaa mreke tich xaa, leezha mroo xaa Galilea nu ngwa xaa yezh Jerusalén. Nal re xaa ne, nak xaa nzaa kwent cheen Jesús lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Snee re nu nzaa kwent cheen wdizh chul lo gu, tub kwaan myaan Dios kwaan re xey be xaa yilo, ");
INSERT INTO zpoNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","mle xaaya lo re be, xana xaa nak dii cheen xaa. Kwaane mle xaa gorna mseban xaa Jesús lo re xaa ngut, kwentaxa nkeela lo Xkyech Dios lo Salm chop, kwaan nii: “Lu nak xgaan na, na mle ngol lu nalzhe”. Sal. 2:7 ");
INSERT INTO zpoNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios nguniila lee xaa seban xaa lo re xaa ngut, zee lee kwerp cheen xaa naluxt, nel noka nzhé xaa: “Za na lo re gu re kwaan myaan na lo David, kwaana nali nu wli nak”. Is. 55:3 ");
INSERT INTO zpoNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nu noka lee stub salm nzhé: “Nalaat lu lux kwerp cheen xmos lu, Xaa Nali nak”. Sal. 16:10 ");
INSERT INTO zpoNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nu David mle mod mnabeyy Dios xaa re mbizh cheen xaa. Nu gwluzh ngut xaa nu msebyo xaa xaa pa msebyo xaa re xey xaa, nu lee kwerp cheen xaa mlux, nu ngoka yide stuba. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Per lee kwerp cheen Jesús mseban Dios nu namluxta. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","’Snee wech na, nzhaal ne gu lee Jesús nak xaa nzho mod chee rese kwaan nawent kwaan mle gu, mod nzaa nu kwent lo gu, ");
INSERT INTO zpoNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","zee lee rese xaa ngwii lo Jesús, mchee Dios jwalt cheen xaa, tub kwaan nyent mod le ley cheen Ches. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kwaanzee kanap gu gu zee nazhint re kwaan mkee re xaa mzaa kwent kwaan nzhé Dios lo lee xaa tich gu, kwaan nzhé: ");
INSERT INTO zpoNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Wii re gu, xaa nxizhno kwaan wli, telisa dedyall gu mod lux na gu, nel lee re mbizh cheen gu kale na tub zhiin gro doo, tub kwaan nalet gu krer nixa zaa xaa kwenta lo re gu. Hab. 1:5 ");
INSERT INTO zpoNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Gorna lee Pab rop Bernabé mroo pa nkasa xaa Israel nseed xaa xtizh Dios, ngunaab re xaa lo xaa zee stub mbizh kwaana nzholl xaa lo Dios, noka nii xaa re kwaane stuba. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Gorna ngulo mrech re myet pa nkasa xaa nseed xaa xtizh Dios, zyen doo xaa Israel, nu noka re xaa mzhin ngok xaa Israel mreke tich Pab rop Bernabé. Nu lee rop xaa mzaa kwent nzhaal nye zo xaa lo yalnkela cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nu lee stub sman, mbizh kwaan nzholl xaa Israel lo Dios, mer rese xaa yezh mdop zee gon xaa xtizh Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Per gorna ne re xaa Israel zyen doo myet, ngok selos doo xaa nu mzelo xaa nawent ngunii xaa Pab nu mbezh xaa nawent kwaan nlu Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Zee lee Pab rop Bernabé nye mkeb nu namzhebt xaa, nzhé xaa: —Kwaan nkin le nu nak zaa nu kwent xtizh Dios yilotlaka lo gu, xaa nak sawlazh be, xaa Israel. Nu nel nanet gu gon gu xtizh Dios zee noka nanet gu kayaa gu yalnaban kwaan tira, nal lee nu ya niiya lo re xaa nanakt xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nel snee mnabeyy Xaa Nabeyy nu, leezha nguné xaa: Mzo na lu kwenta xni lo rese yezh, xaa nanakt xaa Israel, zee zaa lu kwent xomod le xaa gan yalnaban kwaan tira, axta dubse yizhyo. Is. 49:6 ");
INSERT INTO zpoNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nu gorna mbin re xaa nanakt xaa Israel kwaane, nyakdoola xaa nu mzelo xaa nzhé xaa: “Lee xtizh Xaa Nabeyy nak tub kwaan wen”. Nu rese xaa naklakwent le gan yalnaban kwaan tira, mwii xaa lo Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Snee mbin re xaa xtizh Xaa Nabeyy dubse yezh zee. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Per lee re xaa Israel msegan lak ngwnaa non, me nzholl lo Dios, nu lak xaabyi non yezh, zee renal xaa Pab rop Bernabé, zee koo xaa xaa yizhyo zee. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kwaanzee Pab rop Bernabé mrib yide kwaan nkee tich xkyelyed xaa, kwaan nak mod tub nseyn kwaan nii nawent nzo re myet zee lo Dios, nu nya xaa naz yezh Iconio. ");
INSERT INTO zpoNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Per lee re xaa Jesús nyakdoola nu mnabeyy Mbi Naban cheen Dios lextoo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Leezha mzhin Pab rop Bernabé yezh Iconio, mzeeb rop xaa pa nkasa xaa Israel nseed xaa xtizh Dios, klar doo mzaa xaa kwent cheen wdizh chul zee zyen doo xaa Israel nu xaa nanakt xaa Israel mzelo ngwii lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Per lee re xaa Israel, xaa nanzheklat wii lo Jesús, mzelo xaa mdiizh xaa kwaan re xaa nanakt xaa Israel, nu snee mle xaa zee le re xaa xgab nawent nak re xaa Jesús nu nayii re xaa ne xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Zee lee Pab rop Bernabé mlaz zee zyen doo mbizh, nu namzhebt xaa mzaa xaa kwent wdizh chul cheen Xaa Nabeyy. Mle rop xaa re kwaan gro doo kwent cheen Jesús, kwaan mlu wli nak wdizh chul kwaan mzaa xaa kwent. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Per lee re xaa yezh ngok chop tant, tub naz xaa nroo jabor cheen re xaa Israel nu stub naz xaa nroo jabor cheen rop xaa mkayaa yalnabeyy lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Zee lee re xaa Israel nu re xaa nanakt xaa Israel myaan kwaan re xaa nak zhiin, zee le xaa tub kwaan nawent lo rop xaa nu mle xaa xgab zee zaake xaa rop xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Per gorna mzeen Pab rop Bernabé kwaane, zee mxonn xaa nya xaa naz Listra nu Derbe, rop yezh pa nabeyy Licaonia, nu noka nya xaa re yezh kwaan nzhi dub welt, ");
INSERT INTO zpoNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","pa mzaa xaa Kwent Chul cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yezh Listra nzho tub xaabyi nyent mod ze. Nik tub welt namzet xaa, nel mdeen xaa axta leezha ngol xaa. Xaabyi ne nzob, ");
INSERT INTO zpoNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","nkenzha re kwaan nii Pab, nu lee Pab zheta mwii lo xaa nu ne Pab ngwii xaa lo Dios, zee nzho mod sekwen Dios xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Zee nzhé Pab lo xaa kwaan bos nye: —¡Guxso! Nu lee xaabyi zee nguxso nu mkee xaa brink nu mzelo xaa mze xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nu gorna ngune re myet kwaan mle Pab, zee lee re myet mzelo ngunii mer xtizh xaa nu nzhé xaa: —¡Rop xaa ne nak dios nu myaad xaa kwenta myet lo re be! ");
INSERT INTO zpoNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nu mbezh xaa lee Bernabé nak dios Zeus, nu lee Pab nak dios Hermes, nel lee xaa nak xaa nii. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Lee ngwleyy cheen Zeus, xaa nzob xkyidoo roo yezh, mbidno xaa re ngoon nu zyen yeey kwaan chul nzhak. Lee ngwleyy nu re myet nzhekla gool xaa lo rop xaa mkayaa yalnabeyy lo Jesús kwentaxa lo Dios, nu nzhekla xaa ngut xaa lak la ngoon kwentaxa nteed xaa ma lo xdios xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Per gorna mzeen Bernabé rop Pab kwaane, zee mchaz xaa xab xaa nu mzeeb xaa leen pa nzhi re myet, nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¿Chozhiin nle gu kwaane? Lee rop nu nak myet kwenta re gu. Lee nu nze zaa kwent ne lo re gu, zee laa gu re dios ne, kwaan nik tub sirb nanlet, nu wii gu lo Dios, xaa mban. Lee xaa mdexkwaa yiba nu yizhyo nu nistoo nu mdexkwaa xaa re naksa ma. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nu re mbizh nazskweeze, Dios mlaa reke xaa tich re kwaan nzhekla xaa, ");
INSERT INTO zpoNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","nixa namlaat xaa techo re myet sinka nlu xaa rese kwaan wen kwaan nle xaa lo re myet. Nlu xaa xomod nak xaa leezha nselazh yey lo be kwaan nxeen re yalgon cheen be, nu leezha nzaa xaa zyen kwaan gaw be zee chul nzhak lextoo be. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Per nixa rese kwaane nzhé xaa, nagan mle xaa gan lee re myet nangteedt ngoon lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Gorna mzhin lak xaa Israel, xaa Antioquía nu xaa Iconio, mle xaa gan mchee xaa xgab cheen re myet; zee mzaake xaa Pab nu mle xaa xgab mbit xaa Pab, zee mdobxex xaa xaa mloo xaa xaa naz jwer roo yezh. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Per gorna lee re xaa Jesús mkasa dub welt lo xaa, lee xaa nguxche nu mzeeb xaa stub welt leen yezh. Nu stub mbizh mroo rop xaa Bernabé nya xaa naz stub yezh le Derbe. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Gwluzh gorna ngulo mzaa xaa kwent cheen wdizh chul cheen Jesús yezh Derbe, zee zyen doo xaa mzelo ngwii lo Xaa Nabeyy. Zee mbare xaa yezh Listra, nu Iconio nu Antioquía. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nu mle Pab rop Bernabé yudar re xaa Jesús, xaa nzho yezh ne, zee zo nye xaa lo Dios nu roora xaa lo re xcheen Dios. Nu nzhé xaa: “Chelee be nzhekla be zeeb be pa nabeyy Dios nkin ded be bid”. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nu noka mleey xaa lak xaa gol, xaa ngwii lo Jesús, zee nabeyy xaa lo re xaa Jesús reta yezh. Zee mkwan xaa gorna nandawt xaa nik tik kwaan nu mdizhno xaa Dios, zee ngunaab xaa lo Dios zee kanap Xaa Nabeyy rese xaa gol. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Gorna mded xaa yizhyo Pisidia, mzhin xaa yizhyo Panfilia, ");
INSERT INTO zpoNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","nu naz baa mzaa xaa kwent wdizh chul cheen Jesús yezh Perge. Nu zeera ngwa xaa yezh Atalia, ");
INSERT INTO zpoNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","pa mzen xaa bark mzhin xaa Antioquía, yezh cheen Siria. Leen yezh ne mxaal xaa xaa mzaa xaa kwent cheen Xaa Nabeyy, lo yalnkela cheen Dios. Nu sbaa mle xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Gorna mzhin xaa Antioquía, mtop xaa re xaa Jesús, nu mzaa xaa kwent rese kwaan mle Dios kwaan rop xaa. Nzhé xaa xomod mle Dios zee noka re xaa nanakt xaa Israel ngwii lo Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nu Pab rop Bernabé mlaz baa zyen doo mbizh kwaan re xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Re mbizh zee, lak xaa mroo yizhyo Judea mzhin Antioquía. Nu mzelo xaa mseed xaa re xaa Jesús, nu nzhé xaa: —Nyent mod le tub xaa gan yalnaban kwaan tira chelee xaa nanyot xaa beyy cheen re nu, xaa Israel, modxa mlaa Ches le nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Zee lee Pab rop Bernabé mdildiizh xaa kwaan re xaa zee. Nu gwluzh zee lee re xaa Jesús, xaa Antioquía, mxaal Pab rop Bernabé nu zlak xaa, zee ya re xaa Jerusalén, yanabdizh xaa lo re xaa mkayaa yalnabeyy lo Jesús nu lo re xaa gol, xaa nzho yezh zee. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kwaanzee mroo Pab rop Bernabé Antioquía nu gorna nzhaded xaa yezh Fenicia nu Samaria mzaa xaa kwent xomod lee re xaa nanakt xaa Israel, mlaa xaa re krens cheen xaa nu mreke xaa tich xcheen Dios. Nu rese xaa Jesús nyakdoola xaa mbin xaa re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Gorna lee re xaa ne mzhin Jerusalén, lee re xaa Jesús nu re xaa mkayaa yalnabeyy lo Jesús nu re xaa gol wen mkayaa xaa xaa. Nu mzaa Pab rop Bernabé kwent rese kwaan mle Dios kwaan lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Per lak fariseo, xaa ngwii lo Jesús, nguxso nu nzhé: —Lee re xaa nanakt sawlazh be, nzhaal yo beyy cheen be, nu noka nzhaal xaal be xaa zee le xaa kwaan nzhé ley cheen Ches. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Zee mdop re xaa mkayaa yalnabeyy lo Jesús nu re xaa gol, zee wdizh xaa kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Gwluzh gorna mdizh xaa zyen doo kwaane, Pér nguxso nu nzhé: —Wech na, gu ne nzha lak liin Dios mleey na lo re gu zee za na wdizh chul cheen Jesús lo re xaa nanakt xaa Israel, zee noka re xaa ngwii lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nu Dios, xaa nlabeyy lextoo re myet, mlu mkayaa xaa xaa, nel mzaa xaa Mbi Naban cheen xaa lo re xaa modxa mzaa xaa Mbi Naban lo re be. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nel Dios mle kwaan wen lo be nu noka lo lee xaa; Dios mle nzhul lextoo be gorna mzelo be ngwii be lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kwaanzee nal, ¿chozhiin nzhekla gu lux gu xgab cheen Dios nu zhib gu tich re wech ne ley cheen Ches kwaan nga doo kwaan nixa be nyent mod nge, nu nixa re xey be xaa yilo nyent mod wee? ");
INSERT INTO zpoNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Lee re be mle gan yalnaban kwaan tira lo yalnkela cheen Jesucrist, Xaa Nabeyy be, nu leeka snee lee re xaa nanakt xaa sawlazh be le gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Rese xaa msaaw roo nu mkenzha xaa gorna lee Bernabé rop Pab mzaa kwent re kwaan gro kwaan mle Dios kwaan rop xaa lo re xaa nanakt xaa Israel, leezha mzaa xaa kwent cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Gorna ngulo ngunii rop xaa, Chag nzhé: —Wech na, kenzha gu kwaan nii na: ");
INSERT INTO zpoNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pér mzaa kwent xomod ngoka tub welt leezha mleey Dios lo re xaa nanakt xaa Israel tub naz xaa zee gak xaa xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nu kwaane lal nii kwaan nkee re xaa mzaa kwent kwaan nzhé Dios lo lee xaa, modxa nii Xkyech Dios: ");
INSERT INTO zpoNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Lee mod mwii xaa Israel lo Dios nak mod tub yoo cheen rey David kwaan mbaxche. Gwluzh bare na stub welt, zee za na li David stub bes. Za naya stub bes, nu bare na saaw na yeka, ");
INSERT INTO zpoNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","zee lee re xaa stub yezh nzho mod kwaan xaa Xaa Nabeyy, re xaa mleey na tubka kwaan xaa na, xaa Israel, xaa nkano le na. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Snee nzaa Xaa Nabeyy kwent, xaa mlu re kwaan axta re mbizh yilo. Amós 9:11-12 ");
INSERT INTO zpoNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Kwaanzee lee na nii: Nanzhaalt zhib be ley cheen Ches tich re xaa nanakt xaa Israel, re xaa mzelo ngwii lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Per nzhaal kee be lo re xaa ne zee nagawt xaa rese baal kwaan nzhib lo mdo, nu nachaalt xaa re stub naz ngwnaa, nu nagawt xaa baal cheen re ma mziyenn, nu nagawt xaa ren. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Sbaa kee be lo xaa, nel mzaa re xaa kwent rese yezh cheen ley cheen Ches axta nazskweeze. Nlab xaaya pa nkasa re xaa sawlazh be nseed be xtizh Dios yizata mbizh kwaan nzholl xaa lo Dios. Sbaa nzhaal kee be lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Re xaa mkayaa yalnabeyy lo Jesús nu re xaa gol nu re xaa Jesús, myaan xaa kweey xaa lo re xaa, chop xaa xaal xaa Antioquía kwaan Pab rop Bernabé. Nu mleey xaa Judas (xaa noka le Barsabás) kwaan Silas, rop xaa ne nak xaa non lo re xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nu mxaal xaa yech ne lo re xaa Jesús naz ba, nu mbe Barsabás rop Silas yech ne: “Dix wech nu bzan, xaa nanakt xaa Israel, xaa nzho yezh Antioquía, Siria nu Cilicia. Re nu, xaa mkayaa yalnabeyy lo Jesús, nu re xaa gol, nu re xaa Jesús, mxaal nu yech ne lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mbin nu, lak xaa mroo nee nu ngwa xaa lo re gu nu mbezh xaa tub kwaan nawent zee mle gu xgab, per namxaalt nu xaa zee. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kwaanzee mle re nu xgab nu myaan re nu, xaal nu chop xaa zee yasewii xaa lo re gu. Ya xaa kwaan Bernabé rop Pab, rop xaa nkedoola nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Rop xaa ne mzaa yalnaban cheen xaa zee ded xaa bid zaa xaa kwent cheen wdizh chul cheen Jesucrist, Xaa Nabeyy be. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nu kwaanzee nxaal nu Judas nu Silas. Rop xaa ne zaa kwent kwaan myaan nu né nu lo re gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nel ngunii Mbi Naban cheen Dios lo nu zee kiib re nu tub kwaan nga tich gu, nebse nkin le gu re kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nagawt gu baal cheen ma mteed xaa lo mdo, nagawt gu ren nixa baal cheen ma mziyenn, nu nachaalt gu re stub naz ngwnaa. Nu chelee gu nanlet gu re kwaane, wen kale gu.” ");
INSERT INTO zpoNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nu gorna ngulo mrech re xaa, lee re xaa zee ngwa yezh Antioquía, zee mtop xaa re xaa Jesús, nu mzaa xaa yech ne lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Gorna lee re xaa mlaba, nyakdoola xaa nel mseleyy dooya re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nu nel lee Judas nu Silas nak xaa nzaa kwent kwaan nzhé Dios lo lee xaa, zee gro mzaa xaa kwent xtizh Dios, kwaanzee mzaa xaa balor lextoo re xaa nu mseleyy doo xaa re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nu mlaz xaa zee lak mbizh, zeera lee rese xaa Jesús mlaa nya xaa nu nzhé xaa lo xaa: “Wen nya gu”, zee mbare xaa naz Jerusalén stuba. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Per lee Silas nzhekla lakeka xaa naz baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Noka Pab rop Bernabé mlakeka xaa yezh Antioquía, Pab rop Bernabé nu stub naz xaa mzaa kwent cheen wdizh chul cheen Xaa Nabeyy naz ba. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Xep gwluzh Pab nzhé lo Bernabé: —Ya be yisewii be lo re wech nu lo re bzan xaa rese yezh pa ngwa zaa be kwent xtizh Xaa Nabeyy, zee ne be xomod nzhi re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé nzhekla wee Juan, xaa noka le Mark, ");
INSERT INTO zpoNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","per Pab nzak nawent wee xaa xaa, nel mlaa Mark xaa Panfilia nu nangreketra xaa tich rop xaa lo xchiin xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kwaane mle zee mdildiizh doo rop xaa, nu axta mcho rop xaa; Bernabé mbe Mark nu mzen xaa bark nzha xaa naz Chipre. ");
INSERT INTO zpoNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nu lee Pab kwent cheen xaa mleey xaa Silas. Nu re xaa Jesús ngunaab lo Xaa Nabeyy zee kanap xaa xaa. Zee mroo rop xaa baa, ");
INSERT INTO zpoNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","nu mded xaa yizhyo Siria nu yizhyo Cilicia, nu mzaa xaa balor lextoo re xaa Jesús naz ba. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pab rop Silas mzhin yezh Derbe nu yezh Listra, pa mzhaal xaa kwaan tub xaa le Timoteo, xaa nak tub xaa Jesús. Xnaa Timoteo nak me yezh Israel, nu nak me tub me ngwii lo Jesús, per lee xuz xaa nak tub xaa gryeg. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nu lee re xaa Jesús, xaa yezh Listra nu yezh Iconio, wen nzhedizh xaa Timoteo. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pab nzhekla wee Timoteo kwaan lee xaa, per yilotlaka mchoog xaa tik yed cho xaa, kwaan nak beyy cheen re xaa Israel, zee nyent mod le re xaa Israel xgab nawent, xaa nzho zee, nel ne rese xaa lee xuz Timoteo nak xaa gryeg. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Rese yezh pa nded xaa, mzaa xaa kwent re kwaan nzhaal le re xaa Jesús, modxa mxaal re xaa mkayaa yalnabeyy lo Jesús nu re xaa gol, xaa nzho yezh Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Snee yizata mbizh lee re xaa Jesús mas nye nzo lo re xcheen Dios nu ngok zyenra xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Mded xaa yizhyo Frigia nu Galacia, nel lee Mbi Naban nanglaat ngzaa xaa kwent wdizh chul cheen Jesús re yezh cheen Asia. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nu gorna mzhin xaa yizhyo Misia, zee mle xaa xgab zeeb xaa yezh Bitinia, per lee Mbi Naban cheen Jesús nangzeyalt. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Snee tira mded xaa yizhyo Misia, nu mzhin xaa axta roo nistoo nu mzeeb xaa leen tub yezh kwaan le Troas. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tub yaal, mchaa tub xaa yizhyo Macedonia lextoo Pab. Nzak xaa lee xaabyi ne nzo nu kanaab lo xaa nu nzhé: “Ded yizhyo Macedonia zee le lu yudar nu”. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Gorna ngulo mchaa lextoo xaa, zee mle nu xgab roo nu baa, nu ya nu naz Macedonia, nel ne nu lee Dios nzhekla ya nu baa zee zaa nu kwent wdizh chul cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ngu nu leen bark yezh Troas, nu ngwa nu nalisa yezh kwaan nzhi xsaww nistoo cheen Samotracia, nu lee stub mbizh mzhin nu yezh Neápolis cheen yizhyo Macedonia. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nu yezh ne mroo nu ngwa nu Filipos, kwaan nak tub yezh cheen Roma nu yezh kwaan mas non cheen Macedonia. Baa mlaz nu lak mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tub mbizh kwaan nseed re xaa Israel xtizh Dios mroo nu leen yezh nu ngwa nu naz roo yuu, pa mle nu xgab nzho tub pa nseed re xaa xtizh Dios. Gorna mzhin nu, mzob nu, nu mzaa nu kwent wdizh chul cheen Jesús lo re ngwnaa, me mkasa zee. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lee lo re me nzho tub ngwnaa le Lidia; me ne nak me yezh Tiatira nu nto me ler naxne kwaan non doo, nu nak me tub ngwnaa nseed xtizh Dios. Nu kakenzha me kwaan kanii Pab, zee Xaa Nabeyy mxal lextoo me, zee mbin meya. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nu mrubnis me kwaan re me li me, nu gwluzh ngunaab me lo nu: —Te gu kwaz gu garli na, chelee gu nle gu xgab nak na tub me ngwii lo Xaa Nabeyy. Mle doo me jwers lo nu zee mlaz nu garli me. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Stub mbizh gorna nzhaze nu pa nkasa xaa Israel nseed xaa xtizh Dios zee mzhaal nu tub ngwnaa mad, lee me nzho mod zaa kwent cho kwaan gak, nel nzho mbi mal lextoo me. Lee me nak tub mos, nu sbaa nle me gan gro doo demi kwaan nzaa me lo xaa nabeyy lo me. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ngwnaa ne mzelo mreke tich Pab nu tich re nu, nu mbezh me: —¡Re xaa ne nak xmos Dios, xaa ngezh doo! ¡Nu lee re xaa ne nzaa kwent lo re gu xomod roo gu lo yalgut zee le gu gan yalnaban kwaan tira! ");
INSERT INTO zpoNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Sbaa mle me zyen doo mbizh, axta paro nguzha Pab tant seeka nii me, nu mzere xaa yenn xaa mlach xaa lo me nu nzhé xaa lo mbi mal kwaan nzho lextoo ngwnaa mad zee: —Kwaan yalnabeyy cheen Jesucrist, nabeey na lu, broo lextoo ngwnaa ne. Leeka gorzee lee mbi mal mroo lextoo me. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Per gorna lee re xaa nabeyy ngwnaa mad zee, mzeen xaa nyentra mod le re xaa gan gro demi kwaan lee me, zee mzen xaa Pab rop Silas, ");
INSERT INTO zpoNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","nu mbe xaa xaa lo re xaa nak zhiin, nu nzhé xaa: —Xaa Israel re xaa ne, nu kachee xaa mod nak re xaa sawlazh be. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nu nlu xaa stub naz kostumbr kwaan nanzhaalt le be, nel be nak xaa Roma. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nu noka zyen doo myet ngaazh kwaan tich Pab nu tich Silas. Nu lee re xaa nak zhiin mnabeyy koche xaa xab Pab rop Silas zee zaa bar xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Gwluzh gorna ngulo mzaa bar doo xaa rop xaa, zeera mchep xaa xaa lozhyib, nu mnabeyy xaa xaa nkanap roo lozhyib, zee kanap wen xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nu gorna mbin xaa nkanap roo lozhyib kwaane, mchep xaa xaa lozhyib paro mas nech, nu mkado xaa nii xaa kwaan chop le yag. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Per wall yaal Pab rop Silas kawdizhno Dios nu kayoll xaa lo Dios, nu lee stub naz xaa nzhibyoo kakenzha kwaan kayoll xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nu gorzee mgun tub xog kwaan nye doo kwaan mrib axta simyent cheen lozhyib. Nu leeka gorzee mxal rese pwert, nu rese xaa nzho lozhyib mroog kaden kwaan nkadoo yaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Gorna lee xaa nkanap lozhyib mroo mkaal lo, nu ngune xaa lee re pwert cheen lozhyib nzoxal, mloo xaa spad xaa zee gut xaa xaa, nel mle xaa xgab lee re xaa nzho lozhyib mxonn. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Per Pab nzhé lo xaa dub gan: —¡Naguta lu leeka lu, rese nu nzhika nee! ");
INSERT INTO zpoNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Zee lee xaa nkanap lozhyib mnaab tub xni, nu mrexonn xaa mzeeb xaa lozhyib. Nu leezha mzhin xaa lo Pab nu lo Silas, mxiz xaa lo yalnacheb nu mkichxub xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Zeera mloo xaa xaa nu mnabdizh xaa lo xaa: —¿Cho kwaan le na zee roo na lo yalgut nu le na gan yalnaban kwaan tira? ");
INSERT INTO zpoNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Lee rop xaa mkeb lo xaa nzhé: —Wii lo Jesús, Xaa Nabeyy be, zee lu nu rese xaa garli lu, le gu gan yalnaban kwaan tira. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nu mzaa xaa kwent wdizh chul cheen Xaa Nabeyy lo xaa nu lo rese xaa nzho li xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nu leeka gor yaal ze, lee xaa nkanap lozhyib mzet cho Pab rop Silas pa mseweey xaa nak zhiin, nu zeera lee xaa nu rese xaa li mrubnis. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nu zeera lee xaa nkanap lozhyib mbe rop xaa garli xaa nu mzaa xaa kwaan ndaw xaa, nu nyakdoola re xaa li xaa, nel mzelo xaa ngwii xaa lo Jesús, Xaa Nabeyy xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Garziilaka, lee re xaa nak zhiin mxaal lak soldad nguyé lo xaa nkanap lozhyib zee sela xaa Pab rop Silas. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Lee xaa nkanap lozhyib nzhéya lo Pab nu lo Silas: —Re xaa nak zhiin mnabeey na zee sela na gu; nzho mod nya gu. Wen nya gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Per lee Pab nzhé lo re soldad, xaa mxaal xaa nak zhiin: —¡Lee nu nak xaa Roma! Mzaa golp xaa nu delant lo zyen doo xaa yezh, nu nik tub xaa nanguniit che nkano nu kulp, nu mchep xaa nu lozhyib. ¿Nu nal chozhiin nzhekla xaa sela xaa nu xlaan? ¡Nyent moda! Nzhaal yiid mer re xaa nak zhiin koo xaa nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Zee lee re soldad nzhé re kwaane lo re xaa nak zhiin, nu lee re xaa nak zhiin mzheb doo xaa gorna mbin xaa lee xaa nak xaa Roma. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Zee ngwa re xaa nak zhiin nu ngunaab xaa perdon lo Pab nu lo Silas. Nu mloo xaa xaa nu nzhé xaa lo xaa: —Broo gu yezh. ");
INSERT INTO zpoNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nu gorna mroo xaa lozhyib, Pab rop Silas ngwa garli Lidia, nu gorna ngune xaa lo re wech nu lo re bzan, zee mzaa xaa balor lextoo re wech nu re bzan, zee mroo xaa yezh zee. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Zee nzha Pab rop Silas, nu mded xaa yezh Anfípolis nu Apolonia, nu zeera mzhin xaa yezh Tesalónica, pa lee re xaa Israel nkano tub pa nkasa xaa nseed xtizh xaa Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kostumbr cheen Pab nak ngwa xaa pa nkasa xaa nseed xaa xtizh Dios, rese mbizh kwaan nzhool re xaa Israel lo Dios. Chon sman mdildiizh Pab kwaan re xaa. Nu nlu xaa xomod nzaa Xkyech Dios kwent, ");
INSERT INTO zpoNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","nu nzhé xaa: —Jesús nak lee Xaa Mxaal Dios Nabeyy, mded xaa bid nu ngut xaa nu gwluzh ngulo ngut xaa zeera mroban xaa, mod mlela Dios xgab nzhaal gak xaa. Xaa ne nza na kwent cheen lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nu mla xtizh Pab yek lak sawlazh xaa, zee mreke xaa tich Pab rop Silas. Noka mla xtizh Pab yek zyen doo xaa gryeg, xaa nzholl lo Dios, nu zyen doo ngwnaa, me non yezh. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Per kwaane mle ngwasya re xaa Israel, nu mtop xaa lak xaabyi, xaa nakap doo nzo lo xbi, nu nle xaa zee rese xaa yezh yii. Zee ngwa xaa garli Jasón, mle xaa xgab zee yizhal Pab rop Silas zee zaa xaa xaa lo re xaa yezh. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Per nel nanguzhalt rop xaa lo xaa zee, zee mbe xaa Jasón nu zlak wech lo re xaa nak zhiin, nu nzhé xaa: —¡Pab rop Silas kachee dub yizhyo nu noka nze xaa nee, ");
INSERT INTO zpoNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","nu Jasón mzeyal ngu xaa garli xaa! Rese xaa ne nanlet kwaan nzhé ley cheen rey, xaa nabeyy Roma, nel mbezh xaa nzho stub rey, tub xaa le Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nu gorna lee re xaa yezh nu re xaa nabeyy yezh mbin kwaane, mle xaa xgab. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Per Jasón nu stub naz re wech mdix xaa tub mult zee msela xaa xaa nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nu yaal zee, lee re wech mxaal Pab rop Silas naz yezh Berea. Nu gorna mzhin xaa baa, ngwa xaa pa nkasa xaa Israel nseed xaa xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nu lee re xaa Israel, xaa nzho yezh ne, nzheyura yek xaa ke re xaa Tesalónica, nel kwaan dub lextoo xaa mkayaa xaa xtizh Dios kwaan ngunii xaa, nu tich tub mbizh stub mbizh nseedra xaa Xkyech Dios zee ne xaa nen che wli re kwaan ngunii xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nu snee zyen doo xaa mzelo ngwii lo Jesús, nu sbaaka zyen doo xaa gryeg mzelo ngwii lo Xaa Nabeyy, xaabyi nu ngwnaa me nak me non. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Per gorna lee re xaa Israel, xaa Tesalónica, mbin xaa lee Pab kazaa kwent cheen wdizh chul cheen Dios noka yezh Berea, zee ngwa xaa baa nu mle xaa zee nayii re xaa ne xaa Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Zee lee re wech mxaal Pab naz roo nistoo, lee Silas nu Timoteo mlakeka Berea. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Lee re xaa ngwaze naz Pab axta yezh Atenas. Zee lee Pab nzhé lo xaa zee yé xaa lo Silas nu lo Timoteo zee yiid xaa zhaal re xaa leezha nzho moda lo xaa. Nu gorzee nya re wech zee. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Leezha lee Pab nkambaz Silas nu Timoteo yezh Atenas, nales doo ngok lextoo xaa ngune xaa lee re xaa yezh ngwii lo zyen maj. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kwaanzee mkediizh xaaya kwaan re xaa sawlazh xaa nu re xaa nanakt xaa Israel, xaa nzholl lo Dios, pa nkasa re xaa. Nu rese mbizh nkediizh xaaya kwaan re xaa nkasa lo xbi. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nu naz Atenas ngu xaa nzhekla gon xomod nak rese xgab kub. Lak xaa ne mreke tich Epicuro, nu zlak xaa ne mreke tich mod mseed xaa estoico, nu lak xaa ne mbezh: —¿Chozhiin tant nachan nii xaa ne? Nu zlak xaa mbezh: —Nzaa xaa kwent cheen re dios kwaan nanlabeyyt be. Nzhé xaa kwaane nel Pab nzaa kwent cheen Jesús nu kwent cheen yalmroban cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Zee mbe xaa xaa pa nkasa rese xaa yezh, tub pa le Areópago, nu mnabdizh xaa lo xaa: —Nzhekla nu gon nu wdizh kub kwaan kalu lu lo nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nel nii lu kwaan nanlabeyyt nu, nzhekla nu ne nu cho kwaan naka. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Nal rese xaa yezh Atenas, nu re xaa nanakt xaa yezh Atenas xaa nzho baa, purse nzhekla xaa gon xaa o zaa xaa kwent tub kwaan kub. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pab mzoli lo re xaa naz Areópago, nu nzhé xaa lo re xaa: —Xaabyi, xaa yezh Atenas, tub kwaan mlu lo na, lee re gu nzholl lo zyen dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nel gorna mdeed na yezh, mwii na re pa nzholl gu lo re xdios gu, nu ngune na lo tub mdo kwaan nzhé lo: “DIOS KWAAN NANLABEYYT BE”. Lee Dios ne, xaa nzholl gu lo, nixa nanlabeyyt gu xaa, lee xaa nak xaa kaza na kwent lo gu nal. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Lee xaa nak Dios, xaa mdexkwaa yizhyo nu rese kwaan nzho leena, lee xaa nak Xaa Nabeyy yiba nu yizhyo. Nanzhot xaa leen tub yoo kwaan nya kwaan yaa myet, ");
INSERT INTO zpoNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","nu nixa nankint xaa le myet yudar xaa, nel lee xaa nak xaa nle zee ban be nu ngob be mbi, nu nzaa xaa rese kwaan nkin be lo be. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Kwaan tubka xaabyi mdexkwaa xaa rese yezh kwaan nzhi lo dubse yizhyo; mdexkwaa xaa pa nzhaal kwi re yezh nu lak mbizh nzhaal nabeyy re yezh. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Sbaa mle xaa, zee lee xaa rese yezh kwaan Dios. Nu nixa xaa rese yezh nkwaan Dios mod tub syeg, zyizhal Dios lo xaa, nel nazit nzo xaa lo rese be. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nel Dios nle zee mban be, nu zee ngun be, nu zee nzho be. Modxa mbezh tub xaa non lo re gu: “Dii cheen Dios nak be”. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kwaanzee chelee be nak be dii cheen Dios, nanzhaalt lee be xgab lee Dios nak kwenta tub maj or o plat o ke, kwaan ngaxkwaa re myet mod nzhekla re myet. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Re mbizh yilo myela Dios ne re myet, nel namlabeyyt re myet cho kwaan nawent nle re myet, per nal nabeyy xaa xaa rese pa, zee laa xaa naletra xaa kwaan nawent nu wii xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nel Dios mleey tub mbizh kwaan naab xaa re kwent lo rese myet tub mod nali doo, nu mleey xaa Jesús le kwaane. Sbaa mlu xaa lo rese myet, leezha mseban xaa Jesús lo re xaa ngut. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nu gorna mbin xaa cheen kwaan mroban xaa lo re xaa ngut, lak xaa mxizhno xaa nu zlak xaa nzhé: —Nyula nu gon nu kwaane stub welt. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Zee mlaa Pab re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Per mreke lak xaa tich xaa nu re xaa ne mle krer kwaan nzhé xaa. Nu lo re xaa ne nzho tub xaa le Dionisio, tub xaa nabeyy pa nkasa rese xaa yezh naz Areópago, nu noka tub ngwnaa me le Dámaris, nu noka zlak xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Gwluzh gorna ngulo mdedla re kwaane, Pab mroo yezh Atenas nu nya xaa naz yezh Corinto. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Zee mzhaal xaa tub sawlazh xaa, xaa le Aquila, xaa nak xaa yezh Ponto. Xepse yilo Aquila nu sa xaa Priscila mroo Italia, nel lee rey Law, xaa nabeyy Roma, nzhé lee rese xaa Israel nzhaal roo yezh Roma. Pab ngwa lo Aquila nu Priscila. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Lee xchiin Pab nak dexkwaa xaa yoo ler. Nu nel leeka zhiin kwaan nkee Pab nak xchiin xaa, Pab mlaz lo xaa zee mkee rop xaa zhiin tubka. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nu rese mbizh kwaan nseed xaa xtizh Dios, Pab nya pa nkasa re xaa, nel nzhekla xaa le xaa gan zee wii re xaa Israel lo Jesús nu noka re xaa nanakt xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Gorna mroo Silas nu Timoteo yizhyo cheen Macedonia nu mzhin xaa yezh Corinto, Pab mzelo mzaa nebse kwent chul cheen Jesús lo re xaa Israel, nu mbezh xaa lee Jesús nak Crist, Xaa Mxaal Dios Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Per gorna mzelo re xaa nambintra xaa xtizh Pab zee mzelo xaa ngunii xaa re wdizh nawent lo Pab, zee Pab mrib xaa xab xaa, zee mlu Pab nawent nak xgab cheen re xaa, nu nzhé xaa: —Gu nkano kulp lux gu gu, lee na nankanot kulp. Nalzhe naz delant, lee na ya za kwent cheen wdizh chul lo re xaa nanakt xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mroo xaa pa nkasa re xaa Israel nseed xaa xtizh Dios nu ngwa xaa garli tub xaabyi le Just, tub xaa nzhool lo Dios. Nu lee li xaa nzob gax pa nkasa xaa nseed xaa xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nu lee Crispo, xaa nabeyy lo re xaa pa nkasa xaa nseed xaa xtizh Dios, nu re xaa li xaa mzelo ngwii lo Xaa Nabeyy. Nu noka zyen doo xaa yezh Corinto, gorna mbin xaa xtizh Dios mzelo xaa ngwii lo Xaa Nabeyy nu zee mrubnis xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nu tub yaal lee Xaa Nabeyy nzhé lo Pab lo tub mkaal: —Nala nazhebt lu, nu nixa nakwazt lu zaa lu kwent chul, ");
INSERT INTO zpoNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","nel na nzo kwaan lu, nu nik tub xaa nyent mod le tub kwaan nawent lo lu, nel zyen doo myet yezh ne nzho jwalt lach lo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Snee lee Pab mlaz tub liin yirol yezh Corinto, nu nseed xaa re xaa xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Per re mbizh kwaan mnabeyy Galión re yezh cheen Acaya, lee re xaa Israel mkasa nu ngunii nawent xaa Pab, nu mbe xaa xaa lo Galión pa naab xaa kwent lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Nu ngaazh re xaa kwaan tich xaa nu nzhé xaa: —Xaa ne nzhekla le nu tub kwaan nawent lo ley cheen nu, nel mbezh xaa lo re myet nzhaal gool xaa lo Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pab nzhala nii gorna lee Galión nzhé lo re xaa Israel: —Nkenzha gu na xaa Israel, chelee kwaan ngaazh gu tich xaa ngok tub kwaan nawent mod mbit xaa tub xaa, zee nzhaal gon na kwaan né gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Per kwaane nak wdizh cheen ley cheen gu, mdexkwaa leeka re guya, nanzheklat na zeeb na lo re kwent ba. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nu mloo xaa xaa lo pa naab xaa kwent. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Zee mzen re xaa Sóstenes, tub xaa non pa nkasa xaa Israel nseed xaa xtizh Dios, nu mzaa golp xaa xaa delant lo Galión, pa naab xaa kwent. Per Galión namlet kas re kwaan mle re xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Seese mlazra Pab zyen mbizh yezh Corinto. Gwluzh mle xaa despedir re wech nu re bzan, nu ngwa Aquila nu Priscila kwaan Pab yezh Cencrea pa mzen xaa bark nu nya xaa naz yizhyo Siria. Nu gorna zeeraka zen Pab bark mchub xaa yek xaa, sbaa mlu xaa le xaa kumplir tub wdizh kwaan nzhé xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Gorna mzhin re xaa yezh Éfeso ngwa xaa pa nkasa xaa Israel nseed xaa xtizh Dios, pa mkediizh xaa kwaan re xaa Israel, xaa nkasa zee. Nu Pab mlaa Priscila nu Aquila yezh ba, ");
INSERT INTO zpoNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","nel lee re xaa yezh mle jwers lo Pab zee kwazra Pab xche lo re xaa, per lee xaa namlazt. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nu gorna mle xaa despedir nzhé xaa lo re xaa: —Chelee Dios nzhekla bare na yal na lo re gu stuba. Nu gwluzh xep, lee Pab ngu leen bark nu mroo xaa yezh Éfeso. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Gorna mzhin xaa yezh Cesarea, ngwa xaa Jerusalén zee wdizh xaa kwaan re xaa Jesús, xaa nzho zee, nu zeera ngwa xaa yezh Antioquía. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nu mlaz xaa zee lak mbizh, nu zeera ngwa xaa re yizhyo cheen Galacia nu Frigia nu mle xaa zee nyera nzo re xaa Jesús lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nu mbizh zee mzhin tub xaa Israel yezh Éfeso, xaa le Apolos, xaa yezh Alejandría. Nu nzhak doo xaa nzhedizh xaa nzaa xaa kwent xtizh Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Tub xaa mseed Apolos xnaz Xaa Nabeyy, nu zee lee Apolos wen nzaa kwent cheen xtizh Jesús nu klar doo nii xaa lo stub naz xaa, per nlabeyy xaa nebse yalmrubnis kwaan mlu Juan. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nu lee Apolos mzelo mzaa kwent cheen xtizh Jesús pa nkasa re xaa Israel nseed xaa xtizh Dios. Nu leezha mbin Aquila nu Priscila kwaane, zee mbe xaa Apolos stub pa zee seed xaa xaa mas cheen xnaz Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nu gorna lee Apolos nzhekla ded yizhyo Acaya pa nzhi yezh Corinto, zee lee re xaa Jesús yezh Éfeso mkee xaa tub yech kwaan mxaal xaa lo re xaa Jesús naz ba zee wen kayaa xaa Apolos. Gorna mzhin xaa naz ba, mle doo xaa yudar rese xaa ngwii lo Jesús, nu mlu Jesús yalnkela cheen Jesús lo rese xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nel kwaan xtizh Dios klar doo nlu xaa lo re myet lee Jesús nak Crist, Xaa Mxaal Dios Nabeyy; nu sbaa mlu xaa nawlit re kwaan mbezh re xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Gorna lee Apolos nzo yezh Corinto, lee Pab mded re yezh leen yi nu mzhin xaa Éfeso, pa nguzhal lak xaa Jesús lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Zee mnabdizh xaa lo re xaa zee: —¿Che mkayaa gu Mbi Naban gorna mzelo gu ngwii gu lo Jesús? Rese xaa mkeb nzhé: —Nixa nanet nu nen che nzho Mbi Naban. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pab mnadizh lo xaa stuba: —¿Xomod mrubnis gu? Nu lee re xaa mkeb nzhé: —Mod mlu Juan, mrubnis nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Zee lee Pab nzhé lo xaa: —Lee Juan mchubnis re xaa mlaa kwaan nawent kwaan kale xaa nu mzelo xaa ngwii lo Dios. Nu mbezh xaa nzhaal wii rese xaa lo Jesús, xaa nze gwluzh xep. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nu gorna mbin xaa kwaane mrubnis xaa kwaan yalnabeyy cheen Jesús, Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nu gorzee lee Pab mzhib yaa xaa yek re xaa, nu noka re xaa mkayaa Mbi Naban cheen Dios, nu mzelo re xaa nzhedizh xaa stub naz diizh, nu nzaa re xaa kwent re wdizh kwaan nguné Dios lo lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Rese xaa nak kan tub chiibchop xaabyi. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Dubse chon mbee, Pab ngwa pa nkasa re xaa Israel nseed xaa xtizh Dios, pa mzaa xaa kwent cheen xomod nabeyy Dios zee laa xaa nabeyy Dios lextoo xaa, nu nik tik nanzhebt xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Per lak xaa ned nanzheklat ngle xaa krer kwaan nzhé xaa, nu delant lo re myet ngunii nawent xaa Naz Kub cheen Jesús. Zee mbachii Pab lo re xaa Israel nu mbe xaa re xaa Jesús leen tub yoo skwel cheen tub xaa le Tiranno, zee mseed xaa re xaa yizata mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nu snee mseed xaa re xaa chop liin. Sbaa rese xaa nzho rese yezh cheen Asia, re xaa Israel, nu re xaa nanakt xaa Israel, mkenzha xaa wdizh chul cheen Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nu mzaa Dios zee mle Pab re kwaan gro doo lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nu axta panit nu re ler kwaan nzhal cho Pab, nzhe xaa lo re xaa ne nzak, snee lee Dios mzaa diizh sekwen Pab re xaa, nu lee re mbi mal nroo lextoo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ngu lak xaa Israel, xaa nya tich tub yezh stub yezh, nzhekla xaa koo xaa mbi mal lextoo re myet. Nu nle xchiin xaa yalnabeyy cheen Jesús lo re xaa nzho mbi mal lextoo nu mbezh xaa lo re mbi mal: —Kwaan yalnabeyy cheen Jesús, xaa nzaa Pab kwent, nabeey na lu, broo. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Gazh xgann tub xaa Israel xaa le Esceva mle kwaane, xaa nak tub ngwleyy non lo re ngwleyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Per gorna nzhekla xaa ngle xaaya lo tub xaa nzho mbi mal lextoo, lee mbi mal nzhé lo xaa: —Nlabeyy na Jesús, nu ne na cho nak Pab, ¿per lee gu cho nak gu? ");
INSERT INTO zpoNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nu leeka gorzee lee xaabyi, xaa nzho mbi mal lextoo mzelo mkee yek re xaa, nu nel ngezh doo xaa zee mzaa golp xaa re xaa, nu cheey re xaa nu mweey re xaa mroo garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Rese xaa nzho Éfeso, rop xaa Israel nu re xaa nanakt xaa Israel, mbin xaa kwaane, nu mzheb doo re xaa. Nu snee lee Jesús, Xaa Nabeyy ngok non doo naz baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Zyen doo xaa mzelo ngwii lo Jesús, nu nzaa xaa kwent cheen re kwaan nawent kwaan mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nu zyen xaa mseed yalwezh mbidno re yech cheen xaa zee zek xaaya delant lo rese xaa. Mle xaa kwent paro non re yech ne, nu nona choobchii mil demi plat. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Snee lee xtizh Xaa Nabeyy mas nzhaxonn re yezh zee, nu zyen xaa mzelo ngwii lo Xaa Nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Gwluzh gorna ngulo mded re kwaane, Pab mle xgab yasewii lo re xaa nzho re yezh pa nabeyy Macedonia nu pa nabeyy Acaya, nu zee yaka xaa axta Jerusalén; nu noka nzhé xaa gorna yilo ya xaa Jerusalén, noka Roma nzhaal ya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Zee mxaal xaa Timoteo nu wech Erasto le yudar re xaa Macedonia. Nu lee xaa mlakeka xep naz baa, yizhyo cheen Asia. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Re mbizh zee ngwasya re xaa Éfeso kwent cheen Naz Kub cheen Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kwaane mle tub xaabyi le Demetrio, xaa ndexkwaa re kwaan plat, ndexkwaa xaa zyen yidoo dik cheen dios Artemisa kwaan plat, nu lee xaa nu re xaa nkee zhiin kwaan plat, nle xaa gan zyen doo demi. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Mtop xaa re xaa kwaan nkee zhiin kwaan plat kwaan stub naz xaa nle gan demi lo kwaane, nu nzhé xaa lo re xaa: —Gu ne, be kale doo gan lo zhiin ne. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nu neka gu cho kwaan mbezh Pab: “Lee re dios kwaan ndexkwaa yaa myet nanakt dios”. Nu snee mle xaa gan mkiil xaa zyen doo myet, nu nanebt xaa Éfeso noka xaa rese yezh pa nabeyy Asia. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nu kwaane nak tub kwaan tira nawent lo re be, nel lee xchiin be nzho mod lux. Nu noka yidoo cheen dios Artemisa nzho mod lux yalnon kwaan nkanoya, nu snee nawiitra xaa loya, nixa nal lee re xaa rese yezh pa nabeyy Asia nu axta rese xaa dub ntersa yizhyo nzholl lo Aretmisa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Gorna mbin xaa kwaane, nayii doo xaa nu zyen doo xaa mzelo mbezh: —¡Mban Artemisa, xdios re be, me nak dios cheen re xaa Éfeso! ");
INSERT INTO zpoNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Dubse yezh Éfeso ngwasya nu mzen xaa chop xaa, tub xaa le Gayo nu stub xaa le Aristarco, xaa yizhyo Macedonia, xaa mzhin kwaan Pab. Nu mbe xaa xaa pa nkasa re xaa yezh. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Zee lee Pab nzhekla ngzeeb baa, zee nii xaa lo re myet, per lee re xaa Jesús nanglat ngzeeb xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Noka lak xaa nak zhiin, re xaa Asia, xaa nak xmig Pab, mxaal xaa xaa nzhé lo xaa, nanzhaalt zeeb xaa baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nu lee lo junt, lak xaa mbezh tub kwaan, nu zlak xaa mbezh stub kwaan, nu ngwasya zyen doo xaa nu zyen xaa ba nixa nanet xaa chozhiin mkasa xaa baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Zee lee lak xaa mzaa kwent lo Jant cho kwaan kaded, nu mbe re xaa Israel xaa nu mzo xaa xaa delant lo rese xaa. Nu Jant mle nseyn zee nakeet re xaa rezh, nel nzhekla xaa ngnii xaa lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Per gorna mzeen xaa lee Jant nak tub xaa Israel, mzelo re xaa mkee xaa bi chop gor nu nzhé xaa: —¡Mban Artemisa, xdios re be, me nak dios cheen re xaa Éfeso! ");
INSERT INTO zpoNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Lee sekretar yezh, gorna ngulo mle xaa gan msaaw xaa roo re myet, nzhé xaa: —Re xaa sawlazh be, xaa Éfeso, re xaa dubse yizhyo mbezh lee re xaa yezh ne nkano zhiin nkanap yidoo cheen dios Artemisa nu maj cheen me, kwaan ngob naz yiba. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nel nik tub xaa nyent mod né nawlit kwaane, blaa gu nu nalet gu nik tub kwaan, chelee gu nale went gu xgaba yilotlaka. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nel re xaabyi kwaan mbe gu nee, namlewannt xaa nik tub kwaan cheen yidoo nu nixa nanguniit xaa nawent Xdios be. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Chelee Demetrio nu re xaa nkee zhiin kwaan lee xaa nzhekla gaazh tub kwaan tich tub xaa, nya xaa lo jwes nu lee jwes dexkwaaya. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Chelee gu nzhekla gu naab gu stub kwaan nzhaal le guya lo tub junt kwaan rese xaa nabeyy. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nzhaal nayasyat be nel napa lee rey, xaa nabeyy dubse Roma, xaal tub xaa ne xomod naka, zee nanet be cho kwaan keb be lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Gorna ngulo ngunii xaa kwaane, nzhé xaa lo re myet: —Nzho mod nya gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nu gorna ngulola nya re xaa garli xaa, Pab mrezh re xaa Jesús zee mzaa konsej lo xaa, nu zeera nya xaa naz re yezh Macedonia. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nu re yezh pa mded xaa, mseed xaa re xaa Jesús nu mle xaa nyera nzo xaa lo Jesús; gwluzh zeera mzhin xaa pa nabeyy Grecia, ");
INSERT INTO zpoNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","pa mlaz xaa chon mbee. Merla zen xaa bark nya xaa naz Siria, gorna mzeen xaa lee re xaa Israel myaan zen xaa xaa. Zee mchee Pab xgab cheen xaa nu mbare xaa re yezh cheen Macedonia. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nu re xaa ne ngwa kwaan Pab: Sópater xgann Pirro xaa yezh Berea, nu Aristarco rop Segundo xaa yezh Tesalónica, nu Gayo xaa yezh Derbe, nu Timoteo nu Tíquico nu Trófimo yon xaa yizhyo Asia. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nu re xaa ne nguner lo nu, nu mlaz xaa nu yezh Troas. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nu gwluzh ngulo mded yalni cheen Paskwa, tub yalni kwaan nzhaw xaa Israel pan kwaan nanyut lebadur, zee mroo nu yezh Filipos, nu ngu nu leen bark. Nu gaay mbizh zeera nguga xaa lo nu Troas, pa mlaz nu gazh mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mbizh dming mdop rese nu ndaw nu Xchee cheen Xaa Nabeyy, zee lee Pab mseed re xaa Jesús. Nel stub mbizh lee xaa roo nya stub yezh, zee xche mseed xaa re xaa axta wall yaal. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nu mkasa re nu pis yon leen tub yoo, nu baa nkee zyen doo bruj kwaan nkee xni. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nu tub xaa mad le Eutico nzob roo bentant, nu nel Pab mzaa kwent xche doo, zee mzen mkaal xaa mad, nu gorna ngulo mzen wen mkaal garlo xaa mad, mrenzeb xaa mad lo yo. Nu nel lee yoo pa nzho nu leen nak kwaan chon pis, zee rese xaa mla ngwasewii lo xaa mad, nu gorna mzhin xaa lo xaa mad, lee xaa mad ngutla. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Zee lee Pab mla, nu mbii lo xaa mad nu mdezh xaa xaa. Nu nzhé xaa lo re xaa: —Nazhebt gu, mban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nu zeera mbare Pab nguxoob, nu ndaw xaa kwaan re xaa, nu seesa ngunii xaa axta mkaxni yizhyo. Nu zeera nya xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nu nyakdoola re xaa lee xaa mad mban nu mbe xaa xaa garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pab mle xgab ze xaa kwaan nii xaa axta yezh Asón, nu lee nu nguner lo xaa, nel kwaan bark nzha nu axta Asón. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nu gorna mzhaal nu kwaan lee xaa Asón, ngu xaa leen bark kwaan nu, nu ngwa nu axta Mitilene. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mroo nu baa, nu lee stub mbizh ngwa nu ngu nu leen bark nu mded nu tub yizhyo leen nistoo kwaan le Quío. Nu lee stub mbizh mded nu nistoo axta yezh Samos. Zee stub mbizh mzhin nu yezh Mileto. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Snee ngoka nel Pab nanzheklatra xaa kwaz xaa re yezh cheen Asia, nu nzhekla xaa tira ded xaa Éfeso; nel nzhekla xaa zhin xaa lejer yezh Jerusalén, zee zo xaa yalni cheen Pentecostés naz baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Gorna nzo Pab Mileto, mrezh xaa re xaa gol xaa nabeyy re xaa Jesús yezh Éfeso. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Gorna mzhin re xaa zee nzhé xaa lo re xaa: —Gu ne wen, axta mbizh kwaan yilotlaka mzhin na yizhyo Asia nu axta nalzhe, ");
INSERT INTO zpoNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","dubse mbizh kwaan mzo na lo re gu, mkee na xchiin Xaa Nabeyy lo re gu nu namtot na yalxwa. Mded doo na bid kwent cheen re kwaan myaan re xaa sawlazh na nu axta mbinn na lo re bid kwaan mdeed na. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Per nixa snee, namlat na namzatra na kwent chul lo re gu, kwaan mle yudar gu; nu mseed na re gu delant lo re xaa nu leen li re gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Lo xaa sawlazh na nu lo xaa nanakt xaa Israel mbezh na, zee laa xaa kwaan nawent kwaan kale xaa nu wii xaa lo Jesús, Xaa Nabeyy be. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nu nal nya na Jerusalén nel sbaa mxaal Mbi Naban na, nixa nanet na cho kwaan deed na baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nebse kwaan ne na nak, ke rese yezh pa nya na, lee Mbi Naban né lo na, ko xaa na lozhyib nu ded doo na bid. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Per lee yalnaban cheen na nanont, kwaan non nak lux na xchiin na kwaan mzaa Jesús kee na, kwaan nak za na kwent wdizh chul, nen xomod mlu Dios yalnkela cheen xaa lo re be. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Nu ne na, nabaretra gu ne gu lo na, re gu xaa mza na kwent cheen pa nabeyy Dios lo. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kwaanzee nzhekla na nii na lo rese gu, nankanot na kulp cheen nik tub gu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nel ngulola mza na rese kwent cheen Dios lo gu, nu namkaxlaant na nik tub kwaan lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kwaanzee list bzo gu, nu bkanap gu re xaa Jesús, mod tub xaa wen doo nkanap re xma, nel lee Mbi Naban mzo gu gak gu xaa nabeyy lo re xaa Jesús, leeka Jesús mzi re xaa kwaan xren xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Noka ne na gorna lee na nya, zyiid stub naz xaa kwenta tub ma nakap, xaa nzhekla luux re xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nu leeka lo gu roo lak xaa wdizh yalnkade zee lee re xaa Jesús le kwaan nzhekla xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kwaanzee list bzo gu nu bselazh gu xomod mza na konsej lo re gu kwaan dub lextoo na, dubse chon liin zhe nu yaal, nu axta mbinn na kwent cheen gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Kwaanzee nal wech na, nal naab na lo Dios zee kanap xaa re gu, nel nazotra na kwaan re gu nal. Bselazh gu wdizh chul cheen yalnkela cheen Dios nel leeya nzho mod le zee nye nzo gu lo Dios, nu leeya zaa kwent xomod kayaa gu rese kwaan nzaa Dios lo gu, xaa nzo nzhul lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Namzoblazht na xdemi tub xaa, nixa xab xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nu rese gu ne, mkee na zhiin kwaan leeka yaa na, zee mkwaan na kwaan nkin na nu kwaan nkin re xaa mzo kwaan na. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nu sbaa mlu na lo gu, nzhaal kee gu zhiin nu le gu yudar re xaa nkin kwaan. Nu bselazh gu xtizh Jesús leezha nzhé xaa: “Wenra re xaa nzaa xcheen lo stub naz xaa, ke xaa kayaa kwaan”. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Gwluzh gorna ngulo ngunii xaa kwaane, Pab mkichxub nu mdizhno xaa Dios tubka kwaan rese xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Rese xaa mbinn, nu mdezh xaa xaa nu ndaw xaa bit ta garlo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nu nales doo ngok lextoo re xaa, nel nzhé Pab lo xaa: “Nabaretra gu ne gu lo na stuba”. Nu zeera ngwa re xaa kwaan lee xaa axta paro mzen xaa bark. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Gorna mlaa nu re wech, xaa Éfeso, zee ngu nu leen bark, zee nya nu nalise naz yizhyo Cos, kwaan nzhi leen nistoo, nu stub mbizh mzhin nu yizhyo Rodas, kwaan nzhi leen nistoo nu baa mroo nu nya nu naz yezh Pátara. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nu yezh Pátara nguzhal nu tub bark kwaan nya naz yizhyo Fenicia, zee ngu nu leena. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nu gorna nya nu zee mlu yizhyo Chipre lo nu, kwaan nzhi leen nistoo, nu lad rebes lo nu nzhiya. Nu mdedyo nuya, nya nu mzhin nu axta yizhyo Siria. Nel nzhaal lat bark baa, mla nu ngwa nu yezh Tiro. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Baa mzhaal nu re xaa Jesús, nu mlaz nu lo re xaa gazh mbizh. Nu lee re xaa tubka nzhé lo Pab nanyat xaa Jerusalén, nel mlu Mbi Naban tub kwaan lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Per gorna ngulo mzhaal gazh mbizh, zee mroo nu zee, nu rese wech kwaan sa xaa nu kwaan xinn xaa ngwa zee naz xaa nu axta roo yezh, roo nistoo. Baa mkichxub re nu, nu mdizhno nu Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Gorna mle nu despedir re xaa zee nguxoob nu leen bark, zee lee re xaa mbare nya garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Leeka bark kwaan mzen nu yezh Tiro mzhino nu axta yezh Tolemaida. Baa mla nu leen bark nu ngunii nu “dix” lo re wech nu lo re bzan. Mlaz nu lo re xaa tub mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Stub mbizh mroo nu baa, mzhin nu axta yezh Cesarea. Zee ngwa nu garli Lip, baa mlaz nu garli xaa. (Lip nak tub xaa nzaa kwent xtizh Dios, nu nya xaa tub yezh stub yezh. Lee xaa nak tub lo gazh re xaa kwaan mleey re xaa mkayaa yalnabeyy lo Jesús.) ");
INSERT INTO zpoNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Lip nzhap tap xchap, me mad, me mzaa kwent kwaan nzhé Dios lo lee me. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nzhala lak mbizh nzo nu baa, zee mzhin tub xaa yizhyo Judea, xaa le Agabo, xaa noka nzaa kwent kwaan nzhé Dios lo lee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nu gorna mzhin xaa lo nu, mzen xaa yed cheen Pab, mkado xaaya yaa xaa nu nii xaa nu né xaa: —Snee né Mbi Naban: “Snee kado re sawlazh nu bixwann yed ne, nu zaa xaa xaa lo re xaa nanakt xaa Israel”. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nu gorna mbin nu kwaane, zee lee re nu nu re wech, xaa Cesarea, nzhé nu lo Pab zee nayat xaa Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Per lee Pab mkeb né: —¿Chozhiin nzhonn gu, nle gu nzhak nales lextoo na? Nel listla nzo na kado xaa na nu noka listla na nzo zee gut xaa na yezh Jerusalén kwent cheen Jesús, Xaa Nabeyy be. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nu nel namyet roo nu lo xaa, mlaa nu nya xaa, zee nzhé nu lo xaa: —¡Gak mod nzhekla Xaa Nabeyy! ");
INSERT INTO zpoNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Gwluzh gorna ngulo mded kwaane, mzo list nu nya nu naz Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nu lak xaa Jesús, xaa Cesarea ngwa kwaan re nu. Xaa ne mbe nu garli Mnasón, tub xaabyi xaa yezh Chipre. Lee xaa nak xaa Jesús nzha doo liin, nu mlaz nu garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Gorna mzhin nu Jerusalén, nyakdoola re wech nu re bzan ngune lo nu, nu chul doo mkayaa xaa nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Nu lee stub mbizh, ngwasewii re nu Pab lo Chag, nu baa nzhi rese xaa gol. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pab mdizh kwaan re xaa, zeera mzelo xaa mzaa xaa kwent tubga tubga re kwaan mle Dios lo re xaa nanakt xaa Israel lo re zhiin kwaan mkee xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Gorna mbin re xaa kwaan nzhé Pab, mbill re xaa lo Dios, nu nzhé xaa lo Pab: —Wech Pab, gwii. Zyen doo mil xaa sawlazh be ngwii lo Jesús, nu rese xaa ne nzak seetaka nkin kozhaw xaa ley cheen Ches. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nu mbin re xaa Jerusalén, lee lu nlu lo sawlazh be, xaa nzho zit, zee nagozhawtra xaa ley; nu nzhé lu lo xaa, nanzhaalt koo xaa re xgann xaa beyy cheen rese be, xaa Israel, nu nixa nareketra xaa tich re kwaan mlu re xey be. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Cho kwaan le be nal? Nel napa rese xaa kazeen lee lu nzo nee. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Kwaanzee mas wen le lu kwaane: Nzho tap xaabyi lo re be, xaa nzhaal le kumplir tub wdizh kwaan mlaa xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Gwa re gu xaa lo ngwleyy zee gak nzhul lu tubka kwaan re xaa ne, nu bdix re kwaan nzhaal kix xaa rub yek xaa. Snee rese xaa zeen nawlit re kwaan nii re xaa lu, rebes naka, noka lu ngozhaw ley. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Per lee lo re xaa Jesús, xaa nanakt xaa Israel, mxaal nu tub yech lo xaa paro nzhé nu, nanzhaalt gaw xaa baal kwaan nzhib xaa lo mdo, noka nanzhaalt gaw xaa ren nixa baal ma mziyenn, nu nachaalt xaa stub ngwnaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nu stub mbizh Pab kwaan dap xaabyi ngwa lo ngwleyy zee gak nzhul xaa, zeera mzeeb xaa leen lach roo yidoo cheen re xaa Israel, zee yé xaa cho gor yilo yixoob mbizh kwaan gak kumplir wdizh kwaan mlaa xaa lo Dios, kwaane nak, gorna kad tub xaa nzhaal yiidno gon cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Gorna merla yixoob gazh mbizh kwaan mlaa xaa wdizh lo Dios, lee lak xaa Israel, xaa yizhyo Asia, ngune lo Pab lo lach roo yidoo, nu mzelo xaa nzhé xaa lo re myet nawent kwaan kale Pab. Nu ngok gaya re xaa nu mzen xaa Pab, ");
INSERT INTO zpoNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","nu mbezh xaa: —¡Xaa sawlazh be, ble gu yudar nu! Xaa ne nseed rese myet rese pa, nu nii xaa nawent lazh be, nu nii xaa nawent ley cheen Ches nu nawent xkyidoo be. ¡Nu noka, nal mchep xaa leen xkyidoo be lak xaa nanakt xaa Israel, nu sbaa mle beed xaa yidoo cheen be, pa nzhul doo nak! ");
INSERT INTO zpoNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Nzhé xaa kwaane nel yilo ngune xaa lo Pab rop Trófimo, tub xaa yezh Éfeso, nzo Jerusalén, nu mle xaa xgab lee Pab mbe xaa xaa leen lach roo yidoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Dubse yezh nayii, nu lee re myet mrexonn mzhin. Nu mzen xaa Pab nu mdobxex xaa Pab naz jwer lach roo yidoo, gorzeetlaka msaaw xaa roo pwert. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nzhekla re xaa gut xaa Pab. Nu gorna nzhé xaaya lo xaa nabeyy lo tub mil soldad, tub xaa nabeyy kwent cheen Roma, lee rese myet xaa yezh Jerusalén nayii doo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Zee lee xaa mtop lak soldad cheen xaa nu lak xaa nabeyy lo re soldad, nu mrexonn xaa ngwa xaa pa nzo re myet. Gorna ngune re xaa lo re soldad, mlaa re xaa, nu namzaatra xaaya yenn Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Zee lee xaa nabeyy lo tub mil soldad mbii nu mzen Pab nu mnabeyy xaa zee kado xaa Pab kwaan chop kaden. Gwluzh zeera mnabdizh xaa nen cho nak xaa, nu cho kwaan mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Per lee lak xaa mbezh tub kwaan nu lee zlak xaa mbezh stub kwaan, snee medid lee xaa nabeyy nik tub kwaan namlat yek xaa, nel nanet xaa ne chozhiin tant nayii re myet. Snee mnabeyy xaa wee xaa Pab leen kwart. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nu gorna nyano xaa Pab leen kwart, mzhib yenn re soldad Pab, nel zyen doo myet nzhekla gut xaa xaa. Nu nguxoob xaa lo escaler. ");
INSERT INTO zpoNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Rese myet mreke tich re xaa nyano Pab nu mbezh xaa: —¡Bit gu xaa! ");
INSERT INTO zpoNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Gorna merla chep xaa Pab leen kwart, Pab mnabdizh lo xaa nabeyy lo tub mil soldad: —¿Che nzho mod wdizh rop be chep? Lee xaa nabeyy mkeb nzhé: —¿Che nzhidizh lu gryeg? ");
INSERT INTO zpoNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Che naleet lu xaa Egipto, xaa mle nayii re xaa nee nzha lak liin, zee mdil re xaa kwaan re nu, xaa Roma? Nu zee, ¿che naleet lu mroo naz wen kwaan tap mil xaa nzhut myet? ");
INSERT INTO zpoNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pab nzhé lo xaa: —Na nak xaa Israel, xaa yezh Tarso, yizhyo cheen Cilicia. Na nak tub xaa tub yezh nonsa. ¿Che zle lu jabor lo na, laa nii na lo re myet? ");
INSERT INTO zpoNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Lee xaa nabeyy mzeyal. Nu lee Pab mzoli delant lo re xaa nu kwaan yaa xaa mle xaa nseyn, zee nakeetra re myet rezh. Gorna lee re xaa namkeetra rezh, ngunii xaa lo re xaa mer xtizh xaa kwaan nak hebreo. Nu nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Rese gu, xaa sawlazh be, kenzha gu kwaan nzhekla na nii na lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nu gorna mbin re xaa lee Pab ngunii lo re xaa kwaan mer xtizh xaa, kwaan nak hebreo, mas namkeetra re xaa rezh. Zee Pab nzhé: ");
INSERT INTO zpoNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Na nak tub xaa Israel. Ngol na Tarso, tub yezh cheen Cilicia, per mxen na nee Jerusalén, nu mseed na lo tub xaa le Gamaliel, nu mseedra na rese ley cheen re xey be xaa yilo. Nu mlozhaw na ley cheen Ches, kwentaxa kale gu nal. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Kwaanzee yilo mrenal na re xaa kwaan nzhake tich Naz Kub cheen Jesús, zee gut na xaa. Kwaanzee mchep na xaa lozhyib, nexa ped ngwnaaya o xaabyiya. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Lee ngwleyy non doo nu rese xaa gol nzho mod zaa xaa kwent wli re kwaane. Nel re xaa ne mzaa tub yech lo na kwaan diizh zee kab na re xaa Jesús, xaa nzho yezh Damasco, zee yaadno na xaa Jerusalén nu chep na xaa lozhyib, zee chezi xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Per gorna nzha na naz gorna mer zhin na yezh Damasco, kan rolta mbizh, lee tub xni kwaan mroo naz yiba mla dub welt lo na, ");
INSERT INTO zpoNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","nu mla na lo yo. Zee mbin na tub bos kwaan nguné lo na: “Saulo, Saulo, ¿chozhiin nrenal lu na?” ");
INSERT INTO zpoNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nu lee na mnabdizh: “¿Cho lu Xaa Nabeyy?” Nu lee tub bos ngunii lo na né: “Na nak Jesús xaa Nazaret, xaa nrenal lu”. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Lee re xaa kwaan nzha kwaan re nu ngune xaa lo xni nu mzheb xaa per namlat kwaan né bos lo na yek xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Na mnabdizh: “Guné nen cho kwaan nzhekla lu le na Xaa Nabeyy”. Nu lee Xaa Nabeyy né lo na: “Guxso gwa Damasco. Nu baa né xaa nen cho kwaan nzhaal le lu.” ");
INSERT INTO zpoNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Lee xni zee tira msechool lo na, lee re xaa kwaan nzha kwaan re nu mzen yaa na nu mbe xaa na yezh Damasco. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Baa nzho tub xaabyi xaa le Ananías, nu rese xaa sawlazh be, xaa nzho yezh Damasco nzhedizh wen xaa xaa ne. Nu noka ngozhaw xaa ley cheen Ches. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananías mbid lo na, nu gorna mzhin xaa né xaa: “Wech Saulo, nal wii lu stuba”. Nu gorzee lee na mwii stuba, nu mlu xaa lo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Zee Ananías né: “Lee Dios cheen re xey be mleey lu, zee ne lu xana kwaan nzhekla Dios le lu, nu zee wii lu lo lee Xaa Nali, nu gon lu xtizh xaa kwaan mer lee xaa nii. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nu lu zaa kwent cheen xaa leen dubse yizhyo, re kwaan ngune lu, nu re kwaan mbin lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nal nakwaztra lu. Guxso, nu brubnis, nu gunaab lo Xaa Nabeyy zee chee xaa rese kwaan nawent kwaan mle lu.” ");
INSERT INTO zpoNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Nu gorna mbare na Jerusalén, ngwa na lo lach roo yidoo, nu mdizhno na Dios, nu ta mlu Dios tub kwaan lo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mlu Xaa Nabeyy lo na, nu né xaa lo na: “Le prad broo Jerusalén, nel nagont xaa kwaan zaa lu kwent cheen na”. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Lee na nzhé: “Xaa Nabeyy, nlabeyy re xaa na, nu ne re xaa lee na nya rese pa nkasa nu nseed nu xtizh lu, zee mzen na re xaa ngwii lo lu nu ngo na xaa lozhyib, nu mza naya yenn xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nu gorna mbit re xaa Steb, xaa mzaa kwent cheen lu, noka na mzo baa, nu nyakla na lee re xaa kazaake Steb, nu axta mkanap na xab re xaa kwaan mbit Steb.” ");
INSERT INTO zpoNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Zee né Jesús lo na: “Broo, lee na xaal lu zit lo re xaa nanakt xaa Israel”. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Kombasa mkenzha re myet axta gorna lee Pab nzhé, ya xaa axta re xaa nanakt xaa Israel; zee mzelo re myet mbazhe nu nzhé: —¡Nanzhaalt ban xaa ne! ¡Bit gu xaa! ");
INSERT INTO zpoNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nu nel nye doo mbazhe re myet nu nrib xaa xab xaa, nu ngoll xaa yo lo mbi, ");
INSERT INTO zpoNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","zee lee xaa nabeyy lo tub mil soldad, mchep Pab lozhyib, nu mnabeyy xaa zee zaa xaa yenn xaa, zee koo Pab roo Pab chozhiin nayii re myet ne Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Per gorna ngulola mkado xaa xaa zee zaa xaa yenn xaa, Pab nzhé lo xaa nabeyy lo tub gayoo soldad, xaa nzo baa: —Nankanot gu yalnabeyy zaa gu yenn na, nel na nak tub xaabyi Roma nu zer naab gu kwent lo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Gorna mbin xaa nabeyy lo tub gayoo soldad kwaane, zee ngwa xaa nu nzhé xaaya lo xaa nabeyy lo tub mil soldad: —¿Cho kwaan kale lu? Lee xaabyi ne nak tub xaa Roma. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Zee lee xaa nabeyy lo tub mil soldad mbii lo Pab, nu mnabdizh xaa lo Pab: —¿Che wli lu nak xaa Roma? Lee Pab mkeb nzhé: —Wliya. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Lee xaa nabeyy lo tub mil soldad nzhé lo Pab: —Na mdix zyen doo demi zee ngok na xaa Roma. Lee Pab mkeb nzhé: —Na nak xaa Roma nel sbaa ngol na. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nu leezha mbin re xaa nzha keeya yek Pab kwaane, mbachii xaa lo xaa; nu noka xaa nabeyy lo tub mil soldad, gorna mzeen xaa lee Pab nak xaa Roma, mzheb xaa nel lee xaa mnabeyy zee mkado re xaa Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nu lee stub mbizh, lee xaa nabeyy lo tub mil soldad nzhekla nen chozhiin nayii re xaa Israel ne Pab, zee mxek xaa Pab nu mnabeyy xaa zee kasa xaa re ngwleyy non nu rese xaa nak zhiin. Zeera mbe xaa Pab nu mzo xaa xaa delant lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pab mlach wen lo re xaa nak zhiin zee nzhé xaa: —Wech na, rese kwaan né Dios wen nzhale na axta mbizh nalzhe. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Zee lee Ananías, ngwleyy non doo, mnabeyy re xaa nzhi gax lo Pab zee gazya xaa roo Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Zee lee Pab nzhé lo xaa: —¡Sbaaka le Dios lu, xaa nkade! Baa nzob lu naab lu kwent lo na modxa nabeyy ley. ¿Chozhiin nanlet lu mod nabeyy ley, leel mnabeyy lu kee xaaya roo na? ");
INSERT INTO zpoNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Zee lee re xaa nzhi zee, nzhé xaa lo Pab: —¿Chozhiin sbaa mgalno lu ngwleyy non doo? ");
INSERT INTO zpoNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Zee nzhé Pab: —Wech na, nanet na chelee xaa nak ngwleyy non doo; nel Xkyech Dios nzhé: “Naniiyet lu xaa nabeyy lazh lu”. Ex. 22:28 ");
INSERT INTO zpoNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Zeera ngune Pab chop tant xaa nzhi baa, xaa saduceo nu xaa fariseo, zee nye ngunii Pab nzhé: —Nkenzha re gu wech na; na nak fariseo, xgann tub fariseo, nu naab gu kwent lo na nel nkambaz na mbizh kwaan roban re xaa ngut. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nu gorna Pab nzhé kwaane, zee lee re fariseo kwaan re saduceo mzelo xaa mdildiizh re xaa, nu ngok re xaa chop tant. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nel lee re saduceo nzak nanrobant re xaa ngut, nu nzak nixa nyent mandad cheen Dios, nu chora re mbi mal. Nu lee re fariseo mbezh nzho rese kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Sbaa mzelo rese xaa mkee bi; nu lak maestr xaa nlu xtizh Dios, xaa nak fariseo, nguxso nzhé: —Lee xaabyi ne namlet nik tub kwaan nawent, talbes tub mbi o tub mandad cheen Dios ngunii lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Zee mzelo re xaa masra mdildiizh. Zee lee xaa nabeyy lo tub mil soldad mzheb doo xaa napaka kayut re xaa Pab. Zee mnabeyy xaa lak soldad zee koo xaa Pab lo re xaa nu wee xaa xaa lozhyib stuba. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nu leeka yaal zee, lee Xaa Nabeyy mlu lo Pab nu nzhé lo xaa: —Sbaaka modxa mzaa lu kwent cheen na nee, naz Jerusalén, sbaaka nzhaal zaa luya yezh Roma. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nu lee stub mbizh lee lak xaa Israel myaan diizh gut Pab, nu mcheroo xaa nzhé xaa: “Nagawt be nixa nagot be nik tub kwaan chelee be zeeraka gut be Pab”. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nu masra choo xaabyi sbaa myaan. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Nu ngwa xaa lo re ngwleyy non nu lo re xaa gol xaa Israel nu nzhé xaa lo re xaa: —Re nu myaan nagawt nu axta yilo gut nu Pab, nu Dios ted nu bid chelee nu yilo gaw nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nu nal re gu nu re xaa nak zhiin, guzh gu lo xaa nabeyy lo tub mil soldad, yaadno xaa Pab nee lo re gu. Guzh gu lo xaa lee gu nzhekla ne wen xomod nak xkwent xaa, nu lee re nu list zo gut xaa leezha zeeraka zhin xaa nee. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Per lee xinn bzan Pab mbin kwaane, nu ngwa xaa lozhyib mle xaa yabis lo Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pab mrezh tub re xaa nabeyy lo tub gayoo soldad, nu nzhé lo xaa: —Be xaa mad ne lo xaa nabeyy lo tub mil soldad, nel xaa ne nzhekla yé tub kwaan lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Lee xaa nabeyy lo tub gayoo soldad mbe xaa mad zee lo xaa nabeyy lo tub mil soldad, nu nzhé xaa lo xaa: —Pab, xaa nzhibyoo mrezh na, nu né xaa lo na zee yalno na xaa ne lo lu, nel nzhekla xaa né xaa tub kwaan lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Lee xaa nabeyy lo tub mil soldad mzen yaa xaa mad, nu mloo xaa xaa tub lad nu mnabdizh xaa lo xaa: —Guné, nen cho kwaan nzhekla lu né lu lo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nu lee xaa mad nzhé lo xaa: —Lee re xaa nak zhiin, re sawlazh na, myaan diizh zee naab xaa wee lu Pab lo re xaa, nel nzhekla xaa nera xaa xomod nak xkwent xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Per nagont lu xtizh xaa, nel masra choo xaabyi nzholaanla kasaaw xaa, nu noka mcheroo re xaa nzhé xaa, nagawt xaa nu nagot xaa nik tub kwaan chelee xaa zer gut xaa xaa. Nu nal listla nzhi re xaa, nkambaz xaa nen cho kwaan yé lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Zee lee xaa nabeyy lo tub mil soldad mxaal xaa xaa mad nya, nu mnabeyy xaa xaa mad zee nyent cho lo yé mad kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Lee xaa nabeyy lo tub mil soldad mrezh chop xaa nabeyy lo tub gayooga soldad, nu mxaal xaa zee zo list xaa chop gayoo soldad, nu xchop gayoo xaa wee tubga yag naluch, nu chon gal chii soldad, xaa zob kabay, zee wee xaa Pab yezh Cesarea las nueve mzhela yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Noka mnabeyy xaa zee koxab xaa kabay, ma zob Pab tich; nu mnabeyy xaa zee zhino wen xaa Pab lo Jwels, xaa nabeyy kwent cheen Roma. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Lo re xaa ne mxaal xaa tub yech kwaan nzhé kwaane: ");
INSERT INTO zpoNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Dix Jwels, xaa nabeyy kwent cheen Roma. Na nak Law Lisias. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Re xaa Israel mzen xaa ne, nu nal xaal na xaa lo lu nel nzhekla re xaa ngut xaa, per gorna ngune na lee xaa nak xaa Roma, zee ngwano na re soldad na nu mla na xaa lo re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nu nel nzhekla na ne na cho kwaan mle xaa zee mzen re xaa xaa; zee mbe na xaa lo re xaa nak zhiin lo re xaa Israel, ");
INSERT INTO zpoNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","zee ngune na lee re xaa mzen xaa nel nangozhawt xaa ley cheen re xaa Israel. Per nyent cho kwaan mle xaa zee nzhaal yet xaa, nu nixa lozhyib nanzhaalt yo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Per mzeen na lee xaa Israel myaan gut xaa, kwaanzee xaal na xaa lo lu; nu yé na lo re xaa nayii ne xaa, nzhaal ya re xaa lo lu, zee ne xaa nen chozhiin nayii re xaa ne xaa xaa.” ");
INSERT INTO zpoNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nu lee re soldad, konxa mnabeyy xaa lo xaa, zee mbe xaa Pab yezh Antípatris yaal. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Nu lee stub mbizh lee re soldad xaa nzha kwaan nii mbare pa nzho re soldad stuba, nu lee re xaa nzob kabay nzhanoka Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nu gorna mzhin xaa yezh Cesarea, mzaa xaa yech lo xaa nabeyy, noka mzaa xaa Pab lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gwluzh gorna ngulo mlab xaa yech, lee xaa nabeyy mnabdizh pa xaa Pab; nu gorna ngune xaa lee Pab nak xaa Cilicia, ");
INSERT INTO zpoNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","zee nzhé xaa lo Pab: —Gorna yiid re xaa nayii ne lu zee gon na kwaan né lu. Zee mnabeyy xaa mkanap xaa xaa lozhyib leen yoo kwaan mdexkwaa rey Herod yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nu leezha nzhala gaay mbizh, lee Ananías, xaa nak ngwleyy non doo, mzhin Cesarea kwaan lak re xaa gol, nu kwaan tub lisensyad xaa le Tértulo. Re xaa ne mbid lo xaa nabeyy kwent cheen Roma, zee gaazh xaa kwaan tich Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Gorna nyaadno xaa Pab lo Jwels, zee lee Tértulo mzelo mgaazh kwaan tich Pab nu nzhé xaa lo Jwels: —Dixkix lu, Jwels. Nel lu nak xaa nabeyy yezh ne zee wen nzhi nu. Nu noka nzaa nu dixkix lo lu nel nzho doo yek lu mdexkwaa lu zyen doo kwaan chul lazh nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nu rese pa nix doo nzhak lextoo re myet ne re myet re kwaan wen kwaan kale lu nu nzaa xaa dixkix lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Per nanzheklat na kiib na zyen doo tyemp lo lu, naab na lo lu zee kenzha lu kwaan né nu lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Mzeen nu lee xaabyi ne kakiil re sawlazh nu, nu nzha xaa dubse yizhyo nle xaa re sawlazh nu chop tant; nu lee xaa nak tub xaa lo re xaa nreke tich Jesús, xaa yezh Nazaret. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Noka nzhekla xaa ngle beed xaa yidoo cheen Dios; kwaanzee mzen nu xaa nel nzhekla nu naab nu kwent lo xaa mod nzhé ley cheen nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Per gorzee mzhin Lisias kwaan re soldad kwaan nabeyy xaa lo, nu lajwers mkiib xaa Pab lo nu, nu nguné xaa: “Rese gu, xaa nzhekla gaazh kwaan tich xaa nzhaal ya lo Jwels”. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nal leeka lu nabdizh lo xaa zee ne lu wli rese kwaan ngaazh nu tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Nu lee re xaa Israel, xaa nzhi baa, rese xaa nzhé wli re kwaan nzhé Tértulo. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Lee xaa nabeyy yezh mle tub nseyn lo Pab zee nii xaa, nu lee Pab nguxso nu nzhé: —Nel nzhala zyen doo liin nzob lu nabeyy yizhyo ne, kwaanzee kwaan dub lextoo na keb na re kwaan gaazh xaa ne tich na. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Leeka lu nzho mod nabdizh nen che wli naya, nara nzha chiibchop mbizh mzhin na yezh Jerusalén, ngwa na zee gol na lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nu nela xaa nakadildiizht na kwaan nik tub xaa, nu nixa namchadilt na tub xaa lo lach roo yidoo cheen Dios, nu nixa re pa nkasa nu nseed nu xtizh Dios, nu nik tub pa leen yezh namlet na tub kwaan sbaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nu lee re xaa ne nyent mod lu xaa wli re kwaan ngaazh xaa tich na. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Per kwaan nii na lo lu nak; lee na nkee xchiin Dios cheen re xey nu, kwentaxa nzaa Naz Kub cheen Jesús kwent, kwaan nii re xaa ne nawent. Sbaaka kale na nel nle na krer rese kwaan nkee lo yech cheen ley nu re kwaan mkee re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nu leeka mod nle re xaa ne xgab, sbaaka nle na xgab; wli seban Dios re xaa ngut, xaa kwaan mle kwaan wen nu xaa mle kwaan nawent. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nu kwaanzee lee na tubka nkwaan na nali zo na delant lo Dios nu lo re myet. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Gwluzh gorna nzhala lak liin, zeera mbare na ngwa na Jerusalén zee za na lak kwaan lo re xaa prob nu noka nzhaza na gon lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kwaane kale na gorna ngune lak xaa sawlazh na, xaa nyaad naz Asia lo na, lach roo yidoo Jerusalén. Kale na modxa nabeyy ley cheen Ches zee gak nzhul na lo Dios. Nu nixa nazyent xaa nzo kwaan na, nu nixa nakakeet nu rezh. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nu nee nzhaal zo re xaa mzen na zee ne xaa cho kwaan mle na nu chozhiin nayii xaa ne xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nu cheleeya nanakta sbaa, oj re xaa nzhi nee, né xaa nen cho kwaan nawent mle na gorna mzo na lo re xaa nak zhiin, xaa sawlazh nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nebse kwaan mbezh na leezha mzo na lo re xaa leezha nzhé na: “Na né, lee re xaa ngut roban, kwaanzee snee nkano gu na”. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Nu gorna mbin Jwels kwaane, nu nel ne wen xaa xomod nak Naz Kub cheen Jesús, mxaal xaa re xaa nya, nu nzhé xaa: —Gorna yiid Lisias xaa nabeyy lo tub mil soldad, zee ne wen na xomod nak xkwent gu, zee ne na cho kwaan le na. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nu mnabeyy Jwels lo xaa nabeyy lo tub gayoo soldad zee sebyoka xaa Pab, per laa xaa ya re xmig xaa lo xaa le yudar xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Leezha mded lak mbizh lee Jwels mzhin stub welt kwaan sa xaa Drusila, tub me Israel. Zee mnabeyy Jwels ngwaxii xaa Pab, zee gon xaa kwaan nzhé Pab, ne xomod nak wii xaa lo Jesucrist. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Lee Pab mzaa kwent nkin yo xaa tub mod nali, nu wen nabeyy xaa kwerp cheen xaa, nel zhin tub mbizh lee Dios naab kwenta lo xaa. Nu gorna mbin Jwels re kwaane, mzheb xaa nu nzhé xaa: —Zyaa nal, stub mbizh leezha nkano na tyemp zee kwezh na lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Per kwaan nzhekla Jwels nak zaa Pab demi lo xaa, zee sela xaa Pab; kwaanzee mrezh xaa xaa zyen doo welt, mdizhno xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Chop liin sbaa mded, zee lee Jwels mroo lo yalzhiin, nu xlugar xaa mla tub xaa le Porcio Festo. Nu nel Jwels nzhekla kwi chul xaa kwaan re xaa Israel, zee mlaaka xaa nzho Pab lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Gorna nzhala chon mbizh ngok Festo xaa nabeyy rese yezh pa nabeyy Cesarea, zeera ngwa xaa Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Zee lee re ngwleyy non, nu re xaa nak xaa non lo re xaa Israel, mgaazh xaa kwaan tich Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Nu ngunaab xaa lo Festo, zee xaal xaa Pab Jerusalén. Lee xgab re xaa nak gut xaa Pab naz. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Per Festo mkeb lo re xaa nzhé: —Lee Pab nzho lozhyib yezh Cesarea, nu lee na nle xgab bare na naz ba zlak mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nu chelee tub gu nzho mod ya kwaan na, zee chelee xaabyi ba mle tub kwaan nawent, baa gaazh gu kwaan tich xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo mzo Jerusalén kan xon o chii mbizh masra, zeera mbare xaa Cesarea. Nu lee stub mbizh, mzob xaa paro nabeyy xaa, nu mnabeyy xaa zee yaadno xaa Pab lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Gorna lee Pab mzeeb, lee re xaa Israel, xaa mroo Jerusalén, mzoli dubse lo Pab nu mgaazh xaa zyen doo kwaan naxinn tich Pab, per nyent mod lu xaa wli re kwaan mbezh xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Zee lee Pab mkeb nzhé: —Nik tub kwaan nawent namlet na lo ley cheen re nu; nu nixa lo yidoo cheen Dios; nixa lo César, xaa nabeyy naz Roma. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nel Festo nzhekla xaa kwi chul xaa kwaan re xaa Israel, zee mnabdizh xaa lo Pab: —¿Chu zeyal lu xaal na lu Jerusalén, zee baa naab na kwent lo lu? ");
INSERT INTO zpoNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pab mkeb nzhé: —Nee nzo na delant lo lu, xaa nak zhiin Roma, paro nzhaal naab lu kwent lo na; nu ne wen lu, lee na namlet nik tub kwaan nawent lo re sawlazh na, xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Chol na mle na tub kwaan nawent, kwaan nzhaal yet xaa, naniit na naguta gu na; per cheleeya nawlit re kwaan ngaazh re xaa ne tich na, nik tub xaa nanzhaalt zaa na lo re xaa. Kwaanzee naab na zee lee César naab kwent lo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Zee lee Festo mnabdizh lo re xaa nzaa konsej lo xaa, nu zeera nzhé xaa lo Pab: —Nel mnaab lu zee César, xaa nabeyy Roma, naab kwent lo lu, nal xaal na lu lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nu mded lak mbizh, lee rey Agripa nu Berenice mzhin Cesarea lo Festo. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nel mlaz xaa baa lakra mbizh, zee mzaa Festo kwent cheen Pab lo xaa. Nu nzhé lo xaa: —Nee nzho tub xaabyi, xaa mlaa Jwels lozhyib. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nu leezha ngwa na Jerusalén, lee re ngwleyy non nu re xaa gol lo re xaa Israel, mbid lo na nu mgaazh xaa kwaan tich xaabyi ne, nu ngunaab xaa lo na zee nabeey na gut xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Per na nzhé lo re xaa: “Lee nu xaa Roma, nankanot nu kostumbr nabeyy nu gut xaa tub xaa cheleeya zeeraka chaal nu xaa kwaan re xaa ngaazh kwaan tich xaa, zee ne nu che wli o nawlit kwaan nii re xaa xaa”. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kwaanzee gorna lee re xaa mbid nee, stub mbizh zee lee na mzob pa naab na kwent lo re myet, nu nzhé na zee yaadno re soldad Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Per lee re xaa mzhin ngaazh kwaan tich xaa, nanét xaa nik tub re kwaan naxinn kwaan mle na xgab. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kwaan ngaazh xaa tich Pab nak kwent xkostumbr re xaa nu kwent cheen tub xaa le Jesús. Mbezh re xaa lee Jesús ngut, per lee Pab né naban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nu nal nanet na xomod dexkwaa na kwent ne, zee mnabdizh na lo Pab, nen che nzhekla xaa xaal na xaa Jerusalén zee baa naab na kwent lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Per lee Pab mnaab zee César naab kwent lo xaa. Snee medid mnabeey na yoka xaa lozhyib, axta gorna nzho mod xaal na xaa lo César. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Zee lee rey Agripa nzhé lo Festo: —Chol nzho mod, noka na nzhekla gon na kwaan né xaa ba. Zee lee Festo mkeb nzhé: —Yee gon lu kwaan né xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Nu lee stub mbizh, Agripa nu Berenice mzhin pa nabeyy Festo nu ngok xaa ler chul cheen rey, nu kwaan musk mzeeb xaa baa, kwaan re xaa nabeyy tub mil soldad, nu kwaan re xaa yezh, xaa non. Zee lee Festo mnabeyy zee yaadno xaa Pab baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Nu nzhé xaa: —Rey Agripa nu re gu, xaa non, xaa nzhi nee. Lee xaabyi, xaa nzo lo gu nee, rese xaa Israel, xaa Jerusalén mgaazh xaa kwaan tich xaa, nu mnaab xaa gut na xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Per na, nela nik tub kwaan namlet xaa zee nzhaal yet xaa. Per lee xaa mnaab ya xaa lo César, zee César naab xaa kwent lo xaa, nu mlela na xgab xaal na xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Rey Agripa, nel nanet na cho kwaan kee na lo yech kwaan xaal na lo César, kwaanzee nzeno na xaa ne lo lu, nu lo re gu xaa non, zee gorna ngulo nabdizh lu lo xaa, zee ne che nankanot na tub kwaan kee na lo César. ");
INSERT INTO zpoNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nel nzak na nawent xaal na tub xaa nzho lozhyib lo César, nu nayét na nen cho kwaan nawent mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Zee lee rey Agripa nzhé lo Pab: —Nzho mod nii lu. ¿Chozhiin nzho lu lozhyib? Zee lee Pab mlis yaa nu mzelo ngunii nzhé: ");
INSERT INTO zpoNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Rey Agripa. Nyakdoola na nzo na lo lu nalzhe, zee nii na lo lu nu keb na re kwaan ngaazh re xaa sawlazh be tich na. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nel lu ne wen xomod nak rese kostumbr cheen re be, nu re kwaan nle nkediizh be. Kwaanzee nii na lo lu kenzha lu kwaan nii na lo lu tub rat. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Rey Agripa, rese xaa lazh be ne xomod nguu na lazh na leezha mad na, nu xomod nguu na Jerusalén. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Noka nzhala liin ne re xaa, nu nzho mod né xaa wli kwaane chelee xaa nzhekla xaa, lee na nak tub fariseo, tub xaa nzhekla doo gozhaw ley cheen be. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nu nal nzeno re xaa na nee, nel nkambaz na le Dios re kwaan nzhé Dios lo re xey be, xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Nu reta lo chiibchop xaa, xaa nak dii cheen be, nkambaz be nen cho gor gak re kwaan nguné Dios, nu kwaanzee tubka nzholl be lo Dios. ¡Per nal rey Agripa, lee re xaa sawlazh be ngaazh kwaane tich na nel noka na nkambaz na gak kwaan nguné Dios! ");
INSERT INTO zpoNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Che nle gu xgab nyent mod seban Dios re xaa ngut? ");
INSERT INTO zpoNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Yilo leeka mer na mle xgab nzhaal luux na re xaa Jesús, ");
INSERT INTO zpoNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","nu sbaa mle na Jerusalén. Nu kwaan yech kwaan mzaa ngwleyy non doo, mchep na zyen doo xaa Jesús lozhyib, nu gorna nzhut re xaa tub xaa Jesús, nroo na jabor cheen re xaa nzhut xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Zyen doo welt mteed na re xaa Jesús bid pa nzhool be lo Dios, zee yé re xaa naleet Jesús nak Xaa Mxaal Dios Nabeyy. Nu nayii doo na ne na re xaa, nu axta noka mrenal na re xaa re yezh zit. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Zee nya na Damasco kwaan yech kwaan mzaa re ngwleyy non lo na, zee zen na re xaa Jesús baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Per rey Agripa, nkenzha lu, leezha nzha na naz kan rolta mbizh, zee mlu tub xni kwaan nze naz yiba lo na, nkee masra xni ke xni mbizh. Mla dub welt lo re na xaa kwaan nzha kwaan na. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Zee rese nu mla lo yo, nu na mbin tub bos kwaan ngunii lo na wdizh hebreo: “Saulo, Saulo, ¿chozhiin nrenal lu na? Leeka lu kaseweey lu, mod tub ma kwaan nkee patad yek yag kwaan ngin xaa ma. See nak lu.” ");
INSERT INTO zpoNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Zee nzhé na: “Xaa Nabeyy, ¿cho lu?” Lee Xaa Nabeyy mkeb lo na nzhé: “Na nak Jesús, xaa karenal lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Per nal guxso. Na mlu lo lu nel mleey na lu, zee zaa lu kwent cheen na, nu yé lu re kwaan mlu lo lu nalzhe, nu re kwaan nara lu na lo lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nal xaal na lu lo re xaa sawlazh lu nu lo re xaa nanakt xaa Israel, nu la na lu lo re xaa nayii ne lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Xaal na lu lo re xaa ne, zee luu lu kwaan wli lo xaa, zee nazetra xaa lo yalnakaw sinka lo xni cheen Dios ze xaa; nu nanabeyytra Maxuu lo xaa sinka nabeyy Dios lo xaa, zee chee na re jwalt cheen xaa nel ngwii xaa lo na nu le nzhul na xaa.” ");
INSERT INTO zpoNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Sbaa ngoka rey Agripa, mle na rese kwaan mlu Jesús lo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nu yilotlaka lo re xaa Damasco nzhé na: “Nzhaal laa gu naletra gu kwaan nawent nu wii gu lo Dios”. Zeera ngwa na Jerusalén nu noka ngwa na lo re xaa Judea, nu zeera ngwa na lo re xaa nanakt xaa Israel. Nu nzhé na lo xaa: “Nzhaal laa gu re kwaan nawent nu wii gu lo Dios, nu le gu kwaan wen, zee luu wlipa mbare gu lo Dios”. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nu kwaane mle na zee lee lak xaa sawlazh na mzen na lach roo yidoo nu nzhekla xaa ngut xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Per Dios nkanap na axta nalzhe, zee nza na kwent xtizh Dios lo re xaa non nu lo re xaa nanont. Nu nanlut na nik tub kwaan xa lo re kwaan nzhé re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo nu re kwaan nzhé Ches gak. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Lee re xaa ne nzhé: “Lee Xaa Xaal Dios Nabeyy nkin ded doo bid nu yet xaa; per lee xaa yilotlaka roban lo re xaa ngut, sbaa yilo xaa zaa kwent cheen yalnaban lo re xaa sawlazh be nu lo re xaa re stub naz yezh”. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nu gorna lee Pab sbaa nzhé, zee lee Festo mkeb dub gan nu nzhé: —¡Nzhak naxen yek lu Pab! Tant nseed lu zee tira ngok naxen lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Per lee Pab mkeb lo Festo nzhé: —Nanzhak naxent na; nel wli na re kwaan nii na. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kwaanzee lee rey Agripa nzo nee, lee xaa ne wli rese kwaan nii na, kwaanzee nanzhebt na kawdizhno na xaa. Nu ne wen na lee xaa ne rese kwaan kaza na kwent, nel nakazat na kwent tub kwaan ngok xlaan, tub kwaan nyent cho xaa ne. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Rey Agripa, ¿che nle lu krer re kwaan ngunii re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo? Na ne nle lu krera. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Zee lee rey Agripa nzhé lo Pab: —Nebse kwaan lak lan wdizh ne nzhekla lu ngle lu na tub xaa Jesús. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pab nzhé: —Nexa ped lakse lana o zyena, chelee Dios nzhekla nanakta techosa lu sinka noka re xaa mbin kwaan ngunii na nalzhe wii lo Jesucrist kwenta na, nixa nakadoot xaa kwaan kaden snee kwenta na. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Zee nguxso rey Agripa kwaan sa xaa Berenice, nu noka Festo, kwaan rese xaa nzhi baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nu mroo xaa baa nu nzhedizh re xaa lo wechxinn xaa: —Nik tub kwaan namlet xaabyi ne zee nzhaal yet xaa, nu nixa lozhyib nanzhaalt yo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Lee rey Agripa nzhé lo Festo: —Nzho mod ngzela lu xaabyi ne, chol lee xaa nangnaabt xaa zee César naab kwent lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Leezha mzhin mbizh xaal Festo nu Italia, zee mzaa Festo Pab kwaan zlak xaa nzho lozhyib lo Jul, tub xaa nabeyy lo tub gayoo soldad, xaa nak xaa partid kwaan le Augusto. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nu ngu nu leen tub bark kwaan mroo yezh Adramitio kwaan merla roo nya naz Asia. Noka nzo Aristarco kwaan nu, xaa ne nak xaa yezh Tesalónica, tub yezh kwaan nabeyy Macedonia. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Nu stub mbizh mzhin nu yezh Sidón, nu lee Jul wen doo ngok xaa lo Pab, nu mlaa xaa ngwasewii Pab lo re xmig Pab, nu mlaa xaa zee lee re xmig Pab zaa kwaan ndaw xaa nu re kwaan nkin xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Gorna mroo nu Sidón, nu nel nze doo mbi naz nzha nu, kwaanzee mzaa nu welt naz tich yizhyo Chipre, kwaan nzhi leen nistoo, zee saawa mbi lo nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nu gwluzh mded nu leen nistoo gax yizhyo Cilicia nu yizhyo Panfilia, zeera mzhin nu yizhyo cheen Licia zee ngwa nu tub yezh kwaan le Mira. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nu baa lee xaa nabeyy lo tub gayoo soldad ngune lo tub bark cheen xaa yezh Alejandría, kwaan nya naz yizhyo Italia, nu mnabeyy xaa zee ngu nu leen kwaane. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Zyen doo mbizh chuwlazh doo mze nu leen bark nu nagan doo mzhin nu tub yizhyo le Gnido. Nu nel seetaka nze mbi naz nzha nu, kwaanzee nya nu naz yezh Salmón lo Creta, yizhyo kwaan nzhi leen nistoo, zee saaw Creta mbi lo nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nanagant nya nu duzna naz roo nistoo, axta mzhin nu tub pa le Pwert Wen gax yezh Lasea. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nu nel ngok doo nu tras zyen mbizh nu ya naganla yaka nu leen nistoo, nel ngokla re mbizh kwaan nroo doo mbi, kwaanzee Pab nzhé lo re xaa: ");
INSERT INTO zpoNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Xmig na, ne wen na, nawent ya be; chelee be roo be nee, telisa lux bark, noka lux re kwaan nzho leen bark, nu nzho ryez yet re be. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Per lee xaa nabeyy lo tub gayoo soldad, nambint xaa kwaan nzhé Pab, mas mbin xaa kwaan nzhé bixwann bark nu kwaan nzhé xaa nzeno bark. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nu pwert ba nanakt wen kwaz nu re mbee nla nal. Kwaanzee mer rese xaa mle xgab mas wen roo nu baa, nu nya nu naz Pwert Fenice. Pwert Fenice noka nak cheen Creta, nu nxal pwert naz pa nyaz mbizh. Nu baa ded nu re mbee kwaan nla nal. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mle re xaa xgab nzho mod nzha nu stuba, nel chepse mbi nze naz lo yizhyo nu nze naz lo nistoo, zee ngu re nu leen bark, nu nzhekla nu nya nu gax gax roo yizhyo Creta. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Per gwluzh xep lee mbi nye doo nze naz stub ta, nu mkeeya bark. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nu mzeloya mzobyaaya bark naz xsaww nistoo. Nu nel naz pa nzha nu nze mbi, zee mlaa nu mbe mbi bark. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Mded nu tich yizhyo Clauda kwaan nzhi leen nistoo, pa nanroot mbi nye. Nu bid doo mded nu mtexoob nu kano naz leen bark naro. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Gwluzh gorna ngulo mtexoob nu kano leen bark, zee mkado xaa bark naro zee naluxta, nel nzheb xaa napa lee bark kayasob lo yux kwaan le Sirte. Nu mla xaa re lon yek bark, zee mlaa xaa mbe mbi bark. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nu lee stub mbizh, seetaka nye doo nroo mbi, zee lee re xaa mzelo mlebi re kwaan nzhano bark leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Nu lee myon mbizh, mlebi xaa re kwaan nle xchiin bark leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nu zyen mbizh namlut lo mbizh nixa lo mbal yiba lo nu, nu seetaka nroo doo mbi, zee namzaktra re nu le nu gan. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nu zyen mbizh nzha zer gaw nu, zee lee Pab mzoli xsaww lo re nu, nu né xaa: —Xmig na, mas wen chol ngon gu xtizh na, zee nangroot be Creta; snee nangdedt be re bid nu nangluxt be re kwaan. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Per nal blo gu balor lextoo gu, nel nik tub re be nayeta, nebse bark ne lux. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Lee Dios Xaa Nabeyy lo na, xaa nkee na zhiin lo mxaal tub xmandad ngunii lo na nawzheze, ");
INSERT INTO zpoNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","nu né xaa lo na: “Nazhebt lu Pab, nel kan lu, zee nalat Dios yet nik tub re xaa nzho re gu leen bark, nel mbin Dios xtizh lu nu nkin ya lu lo xaa nabeyy Roma”. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kwaanzee xmig na, nazhebt gu, nel ne wen na zak rese kwaan nguné xmandad Dios lo na. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Per telisa lee bark yisob roo yizhyo kwaan nzho leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Per leezha nzha chida mbizh nzho nu leen nistoo, yaal zee mzhin nu nistoo pa le Nistoo Adriático. Nu lee mbi nzhenoka bark naz baa nu naz ree. Nu kan wall yaal lee re xaa nzhano bark mzeen lee nu nzhazhin gax yizhyo. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Zee mchiix xaa ne paro nech nis, nu baa nech galbchii xop metr. Nu delant xep mchiix xaa stub welt, nu nee nech galbgazhaka metr. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nzheb xaa napa lee bark kayal cho ke, kwaanzee mkee xaa tap yiib reke bark kwaan la axta xan nistoo zee naxonnt bark tant. Lee re xaa nzak: “Oj mkaxnila yizhyo”. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Per lee re xaa nkee zhiin leen bark mle xgab xonn. Nu mzelo xaa kala xaa kano lo nis, nu mle xaa mod xaa kaselaka yiib cheen bark leen nis, nebse zee ta xonn xaa leen kano. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Per Pab nzhéya lo xaa nabeyy lo re soldad nu lo re soldad: —Chelee re xaa ne xonn, telisa zet re be. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Zee lee re soldad mchoog re doo kwaan nkadoo kano zee lawa lo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nu gorna nzhakaxnila yizhyo, Pab nzhé lo re xaa: —Daw gu tub kwaan. Nel nzhala chida mbizh nle doo gu xgab zee nixa nandawt gu nu nanzhat gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nal nii na lo gu, daw gu zee nayeta gu, nel nik tub xaa nayeta. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nu gorna ngulo sbaa nzhé Pab, zee mzen Pab cha pan nu mzaa xaa dixkix lo Dios lo re xaa, nu mxux xaaya nu mzelo xaa ndaw xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Zee ngu balor lextoo rese xaa nu noka re xaa ndaw. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Chop yiyoo nzho chongal nzho chiinmtub xaa nak re nu, xaa nzho leen bark. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Gwluzh gorna ngulo ndaw re nu parosa nguzhe lextoo nu, zee mlebi xaa re nzhobxtil leen nis zee gak naxex bark. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Gorna mkaxni yizhyo, lee re xaa nkee zhiin leen bark namlabeyyt xaa yizhyo ba, per mlu tub yaa nistoo kwaan nzhi yux roo lo xaa; mle re xaa xgab chep xaa bark naz baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Zee mchoog xaa re doo kwaan nkadoo re yiib kwaan nsekwaz bark, mlaa xaa mlaya leen nistoo. Nu mxek re xaa yag kwaan nle nze bark. Zeera mlep xaa lon kwaan nzen mbi nu sbaa lee bark mzelo mbii lo yux. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Per lee bark mzeeb neb lo yux nu baa ngusoba, nu nyentra mod guna. Lee naz xan bark mzelo mlux nel tant mzaa golp nistooya. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Lee re soldad nzhekla gut re pres, xaa nzheno xaa, zee naxonnt re xaa le xaa nadar lo nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Per lee xaa nabeyy lo tub gayoo soldad, namzeyalt xaa le xaa sbaa, nel nanzheklat xaa yet Pab. Lee xaa nabeyy tub gayoo soldad mnabeyy nzhé: —Lee re xaa nzhak nle nadar, yilo re xaa la leen nis nu roo xaa, zee zhin xaa lo yo. ");
INSERT INTO zpoNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Zeera reke re xaa nagakt le nadar, nu zen xaa tub le tab o re yag byog cheen bark. Sbaa rese nu mzhin lo yo. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Gorna ngulo mroo re nu leen nistoo, zeera ngune nu lee yizhyo pa mzhin nu le Malta, tub yizhyo kwaan nzhi leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Per lee re xaa nzho baa, wen doo ngok xaa lo re nu. Mze xaa tub bal naro mzhe nu nel nal doo nu nze yey. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pab mtop tub deezh yag bizh, nu gorna kago xaa yag lo ki, lee tub mball mxonn mroo lo xchoog mkenga yaa Pab. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nu gorna ngune re xaa Malta lee mball mkenga yaa Pab, zee nzhé xaa lo wechxinn xaa: —Telisa xaa nzhut myet nak xaa ne, nixa mle xaa gan nangeta xaa leen nistoo, per lee re kwaan nawent kwaan mle xaa nalaat ban xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Per Pab mrib yaa, zee ngob mball lo bal, nu nyent cho kwaan ngok xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Rese xaa nkambaz, nen cho gor zeki yaa xaa o ta bix xaa yet xaa. Per gor nzhala gor kawii re xaa lo xaa, nu nyent cho kwaan ngok xaa, zee mchee re xaa mod mle xaa xgab, nu mzelo re xaa mbezh lee Pab nak tub dios. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Gax baa nzhi re xleyo cheen tub xaa non. Xaa ne le Publio nu wen doo ngok xaa lo re nu, zee mlaz nu tub chon mbizh garli xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nu lee xuz Publio ne nzak; nlen xlee nu yizhnlob. Pab ngwasewii lo xaa, nu gwluzh gorna ngulo mdizhno Pab Dios, mzhib Pab yaa Pab cho xaa nu lee xaa ngokwen. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Gorna mbin re xaa nzho baa kwaane, zee noka re stub naz xaa ne nzak, xaa nzho yizhyo ba, mbidno xaa lo Pab, nu ngokwen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Nu zyen doo kwaan mzelazh xaa ba lo nu. Nu gorna mroo nu baa, ngu nu leen bark stuba, mzaa xaa rese kwaan nkin nu gorna nya nu leen nistoo. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kwaanzee chon mbee mlaz nu yizhyo Malta kwaan nzhi leen nistoo. Zeera ngu nu leen tub bark, kwaan mlaz baa dubse mbee nal; kwaane nak cheen xaa yezh Alejandría, nu naz yek nkee tub maj cheen Cástor nu stub maj cheen Pólux, chop dios cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Zee mzhin nu yezh Siracusa, baa mlaz nu chon mbizh. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nu baa mroo nu nya nu duzna naz roo nistoo axta mzhin nu tub yezh le Regio. Nu lee stub mbizh, mzelo tub mbi nze naz tich nu. Nu axta mbizh rop zeera mzhin nu tub yezh le Puteoli. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nu baa mzhaal nu lak xaa Jesús nu ngunaab xaa lo nu kwaz nu lo re xaa tub sman. Nu gwluzh zeera nya nu yezh Roma. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Re xaa Jesús mbin re kwent cheen nu. Nu snee mle xaa zee mzhaal re nu yilo mzhin nu yezh Roma. Lak xaa ne nze axta tub yezh le Foro cheen Apio, nu zlak xaa nze axta tub yezh le Yon Tyend zee zhaal xaa Pab naz ba. Nu gorna ngune Pab lo re xaa mzaa Pab dixkix lo Dios nu ngu balor lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Gorna mzhin nu Roma, zee lee xaa nabeyy lo tub gayoo soldad mlaa ngu techosa Pab tub yoo, nu nkanap tub soldad xaa baa. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Gorna nzhala chon mbizh mzhin nu Roma, Pab mxaal lak xaa mrezh re xaa non lo re xaa Israel, xaa nzho Roma. Nu gorna ngulo mdop re xaa, Pab nzhé lo re xaa: —Wech na, nik tub kwaan nawent namlet na lo re sawlazh be, nixa lo re xkostumbr re xey be, per lee re xaa mzen na Jerusalén, nu mzaa xaa na lo re xaa Roma. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Nu gorna ngulo mnabdizh re xaa lo na, nzhekla xaa sela xaa na, nel nanguzhalt xaa nik tub kwaan nawent kwaan mle na lo re xaa, zee gut xaa na. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Per lee re sawlazh be ngok gaya, kwaanzee mnaab na zee César naab kwent lo na, per nanakta nel nayii na ne na re sawlazh be. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kwaanzee mrezh na re gu zee wdizh be chep. Kwaanzee nzhekla na ne gu, nkadoo na kwaan kaden nee, nel nza na kwent cheen kwaan nkambaz re be, xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Re xaa nzhé lo Pab: —Zer kayaa nu nik tub kwent cheen lu kwaan mxaal xaa Judea, nu nik tub re sawlazh be mroo baa mzhin nee, nanét nik tub kwaan nawent cheen lu lo nu. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Per nzhekla nu gon nu kwaan né lu, nel ne nu rese pa nzhedizh nawent xaa Naz Kub cheen Jesús kwaan kalu lu. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Snee mleey xaa tub mbizh kwaan kasa re xaa. Nu mbizh zee mkasa zyen doo myet pa nzho Pab. Nu axta garziil nu axta mzhel yizhyo, Pab mzaa kwent cheen pa nabeyy Dios lo re xaa. Nu sbaa mle xaa zee wii re xaa lo Jesús, zee mzaa xaa kwent cheen ley cheen Ches, pa nzaa kwent cheen Jesús lo re xaa, nu lo re kwaan ngunii re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Rol xaa mzaa yek mbin kwaan nzhé Pab, per lee stub naz xaa namzaat yek mbin kwaan nzhé xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nu nel mdildiizh re xaa, mzelo xaa nya xaa. Zee nzhé Pab lo re xaa: —Wen wen ngunii Mbi Naban gorna ngunii Chay, xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, lo re xey be xaa yilo, leezha nzhé xaa: ");
INSERT INTO zpoNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Gwa nu guzh lo re xaa na: Nixa gon guya, nalata yek gu, nixa wii guya, naluta lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Nel ngok ned doo lextoo re xaa ne, nu mod xaa nyaaw nzha, nu mod xaa nanyenit lo nzhak xaa, zee nyent mod gon xaaya, zee nyent mod wii xaa loya, zee nyent mod laya lextoo xaa, kwaane nle zee nambaret xaa lo na zee nasekwent na xaa. Is. 6:9-10 ");
INSERT INTO zpoNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","’Kwaanzee bzeen re gu, leeka nal gorne, lee yalnaban kwaan nzaa Dios, kwaan nza na kwent, zaa xaa kwent lo re xaa nanakt xaa Israel, nu lee re xaa zee, zona. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Gorna ngulo nzhé Pab kwaane, zee lee re xaa Israel nya nu mzelo xaa mkediizh xaaya. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Chop liin ngu Pab leen yoo kwaan mree xaa, paro nkayaa xaa re xaa nyaadsewii lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Nu namzhebt xaa mzaa xaa kwent lo re xaa cheen pa nabeyy Dios, nu mzaa xaa kwent cheen Jesucrist, Xaa Nabeyy be, nu nik tub xaa namchadilt xaa, nel kazaa xaa kwent kwaane.");
INSERT INTO zpoNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Dix re gu. Na nak Pab, xaa nkee xchiin Jesucrist. Kakee na yech ne lo re gu, nel Dios mrezh na nu mleey xaa na, zee kayaa na yalnabeyy lo Jesucrist, nu mxaal xaa na zee za na kwent cheen wdizh chul cheen xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Lee wdizh chul ne nak kwaan nguné Dios lo re xaa mzaa kwent kwaan nzhé Dios lo lee xaa yilo, nu leeya nak kwaan mkee xaa lo Xkyech Dios. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Wdizh chul ne nak cheen Xgann xaa, xaa myaad ngok myet, naz lo dii cheen rey David, xaa mnabeyy yilo, ");
INSERT INTO zpoNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","nu Mbi Naban cheen Dios mseban xaa lo yalgut, snee mlu xaa lee xaa nak Xgann Dios. Nu lee xaa nak Jesucrist, Xaa Nabeyy be. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kwent cheen lee xaa mlu Dios yalnkela cheen Dios lo be. Nu re nu mkayaa yalnabeyy lo Dios zee zaa nu kwent xtizh xaa lo re xaa nanakt xaa Israel, zee nzho mod wii xaa lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nu re gu, xaa yezh Roma nak xaa zee, nel Jesucrist mrezh gu zee gak gu xaa xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nu nkedoola Dios gu, zee mleey xaa gu gak gu nambey lo xaa. Nzhekla na luu Xuz be Dios, nu Jesucrist Xaa Nabeyy be, yalnkela cheen xaa lo rese gu; zee noka le xaa kwi wen re gu. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Yilotlaka mza na dixkix lo Dios, kwaan yalnabeyy cheen Jesucrist, nel rese myet, xaa dubse yizhyo nzaa kwent xomod ngwii gu lo Jesucrist. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nu kwaan dub lextoo na nkee na zhiin lo Dios, kwaanzee nza na kwent cheen wdizh chul cheen Xgann xaa; nu ne xaa yizata mbizh naab na lo xaa kwent cheen re gu. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Nu tubka naab na lo xaa, chelee xaa nzhekla zee ne che nzho mod yal na lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nle doo na xgab yal na lo gu zee nzho mod le na yudar re gu, zee nyera zo gu lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Kwaanzee lee mod ngwii tub be stub be lo Dios, nle zee yo balor lextoo rese be. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Wech nu bzan, nzhekla na ne na lo re gu; zyen doo welt mle na xgab yal na lo gu nel nzhekla na kee na xchiin Dios lo re gu, modxa mkee naya lo re stub naz xaa nanakt xaa Israel. Per nzho doo kwaan nleya zee nyent mod yal na lo gu. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nzeeb doo na lo re myet zer za na kwent cheen Jesucrist lo xaa, lo re xaa nzhedizh gryeg nu lo re xaa nanzhedizhta, lo re xaa nzhak nu lo re xaa nagakt. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Kwaanzee nzhekla doo na yal na Roma, zee za na kwent wdizh chul cheen Dios lo rese gu. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nantont na za na kwent cheen wdizh chul nel leeya nak yalngezh cheen Dios, nu kwent cheen wdizh chul ne, Dios koo rese xaa ngwii lo Jesucrist lo yalgut, yilotlaka re sawlazh na, xaa Israel, nu noka re xaa nanakt xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Nu wdizh chul ne nlu xomod nle Dios zee nali zo be lo xaa, chelee be ngwii be lo Jesucrist; nel nebse kwent xomod ngwii be lo Jesucrist nzho mod nzo be nali lo Dios. Nel nkeela lo Xkyech Dios nzhé: “Lee xaa ngwii lo Dios, nali nak xaa nu telisa ban xaa”. Hab. 2:4 ");
INSERT INTO zpoNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nlu lee yalnayii cheen Dios nze naz yiba la tich rese xaa nle kwaan nawent nu tich rese xaa nanalit nzo lo Dios, nu tich rese xaa nanzheklat le krer kwaan wli. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Zee nzho mod ne rese myet xomod nak Dios, nel leeka Dios mluya lo rese xaa, axta naz leen lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Nanlut Dios, per klar doo nlu xomod nak Dios lo rese myet kwent cheen re kwaan mdexkwaa Dios. Kwaanzee axta leezha mdexkwaa Dios yizhyo, mlu xomod nak Dios, xomod ngezh doo nak Dios, nu xomod nzhul doo nak Dios. ¡Kwaanzee lee re xaa nle kwaan nawent nyent kwaan keb xaa lo Dios gorna naab Dios kwent lo xaa! ");
INSERT INTO zpoNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Nixa nela xaa xomod nak Dios per nangwiit xaa lo Dios, nu nixa dixkix nanzaat xaa lo Dios; kwaanzee nangoknont re xgab kwaan mle xaa; kwaan nachan mle xaa xgab, tira mkaw yek re xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Mbezh xaa nzhak doo xaa per ngok nachan xaa, ");
INSERT INTO zpoNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","nel mlaa xaa xcheen Dios, kwaan chul doo, xaa tira nayeta, kwent cheen re maj, re maj kwaan nlu mod myet, nu mod re mbyin, nu mod re ma tap nii, nu mod re mball, nu rese kwaane lux. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Kwaanzee mlayaa Dios xaa, zee le xaa rese kwaan nzhekla xkwerp xaa, rese kwaan nawent, rese kwaan nzhaal ton xaa le xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Nel mlaa xaa re kwaan wli cheen Dios kwent cheen re kwaan nawlit; nu nlenon xaa rese kwaan mdexkwaa Dios nu nzholl xaa loya, per namlenont xaa Dios nu nixa nambillt xaa lo Dios, xaa tubka nzhaal gool xaa lo. ¡Snee naka! ");
INSERT INTO zpoNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Kwaanzee tira mlayaa Dios xaa, zee le xaa rese kwaan nzhekla xkwerp xaa, rese kwaan nzhaal ton xaa le xaa. Axta re ngwnaa mlaa me nachaaltra me sa me, nu nchaal me leeka sa ngwnaa me, tub kwaan namzeyalt Dios le me. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Nu leeka snee lee re xaabyi, nchaal xaa leeka sa byi xaa. Kwaanzee nlaa xaa xngwnaa xaa nu nle xaa rese kwaan nzhekla xkwerp xaa, nu nchaal xaa leeka sa byi xaa, tub kwaan tira nawent. Nu kwaane nle zee nded doo xaa bid lo re kwaan nawent kwaan nle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Nel nanzheklat xaa labeyy xaa Dios kwaanzee tira mlayaa Dios xaa, zee le xaa kwaan nzhak yek xaa, kwaan nanzhaalt le xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Nu ngok xaa: tub xaa tira nanalit, xaa nawent, xaa nzoblazh, xaa nzho kwaan jwyer lextoo, xaa nzho yalnzoblazh lextoo, xaa nzhut wechxinn, xaa ndildiizh, xaa nkade, xaa nakap, xaa nchech diizh, ");
INSERT INTO zpoNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","xaa nzhedizh nawent stub xaa, xaa nayii ne Dios, xaa nkwaan dil, xaa nto yalxwa, xaa ngab stub naz kwaan nawent yek, xaa nanzhont xtizh xuz nixa xtizh xnaa, ");
INSERT INTO zpoNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","xaa ned doo, xaa nkade nu nanlet re kwaan nii, xaa nyent yalnkela lextoo, xaa nanlest lextoo ne wechxinn. ");
INSERT INTO zpoNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Nu nixa ne wen xaa lee Dios nzhé: “Loka xaa le re kwaane nzhaal yet xaa”. Per mas nzha xaa nle xaaya, nu axta nyakdoola xaa ngwii xaa lee stub xaa nle re kwaan nawent ne. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Kwaanzee leezha ngaazh be tub kwaan tich wechxinn be, nankanot be kwaan keb be lo Dios, nel leeka kwaan mgaazh be tich wechxinn be, ngaazh be leeka tich be. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Nela be, nali naab Dios kwent lo re xaa sbaa nle. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Kwaanzee, ¿cho kwaan nzak gu? Leezha ngaazh be tub kwaan tich wechxinn be nu nle be leeka kwaan nle xaa, nalet be xgab lee be nzho mod xonn lo yalnayii cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","¿Che nanont yalnkela cheen Dios lo be nu xomod nanyachetla xaa ne xaa be? ¿Chozhiin nanzeent be, lee yalnkela cheen Dios nak kwaan le zee laa be kwaan nawent kwaan nle be nu wii be lo xaa? ");
INSERT INTO zpoNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Per nel ned be zee nanet be wii be lo Dios, zee kazhibra be zyenra yalnayii cheen Dios tich be, axta zhin mbizh kwaan naab Dios kwent lo rese myet tub mod nali, ");
INSERT INTO zpoNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","nu kix Dios lo kad tub xaa kwaan mle xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Lee re xaa nanguzhat le kwaan wen, nak xaa nkwaan xni cheen Dios, nu nkwaan xaa zee wii wen Dios lo xaa, nu nkwaan xaa zee ban xaa tira, zee zaa Dios yalnaban kwaan tira lo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Per lee re xaa nkwaan leeka cheen nu nanzaat yek gon re kwaan wli, sinka nreke xaa tich re kwaan nawlit, Dios naab kwent lo xaa kwaan yalnayii cheen Dios. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Per la yalnayii cheen Dios tich rese xaa nle re kwaan nawent nu nales doo gak lextoo re xaa ne. Yilotlaka sawlazh na, xaa Israel, ted Dios bid, per noka ted xaa bid re xaa nanakt xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Per lo re xaa nle kwaan wen, Dios wii wen lo xaa nu zaa xni lo xaa nu le xaa kwi chul xaa kwaan lee xaa. Yilotlaka le xaaya lo re nu, per noka le xaaya lo re xaa nanakt xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Nel lal naab Dios kwent lo rese myet. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Rese xaa mle kwaan nawent naab Dios kwent lo. Rese xaa nankanot ley kwaan mzaa Dios lo nu, Dios ted xaa bid kwent cheen re kwaan nawent kwaan mle xaa. Nu rese nu, xaa nkano ley kwaan mzaa Dios lo nu, Dios naab kwent lo xaa mod nzhé ley kwaan mzaa Dios lo nu. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Nu nanakta nebse re xaa kwaan nkenzha ley kayaa Dios mod xaa nali, sinka xaa nle kwaan nzhéya, nali nak. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Per leezha lee re xaa nanakt xaa Israel, nle xaa mod nzhé ley, nixa nankanot xaa ley kwaan mzaa Dios lo re nu, kwaan ba nak mod nkano xaa ley cheen Dios naz leen lextoo xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Nel lo re kwaan nle xaa nlu nkano xaa ley naz leen lextoo xaa. Leeka lextoo xaa nlu lo xaa zee ne xaa cho kwaan kale xaa, kwaan wen o kwaan nawent, ");
INSERT INTO zpoNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","axta mbizh kwaan zob Dios Jesucrist naab kwent lo rese kwaan xlaan kwaan mle re myet. Snee nii wdizh chul kwaan nza na kwent. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kwaanzee mbezh lu nak lu tub sawlazh be, nu ngwii lu lo ley kwaan mzaa Dios lo Ches nu nto lu yalxwa nel xaa Dios nak lu. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Mbezh lu nela lu cho kwaan nzhekla Dios le lu, nel nlabeyy lu ley, zee nela lu cho kwaan wen nzhaal le re myet. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Nu nzak lu nzho mod luu lu xnaz Dios lo re xaa nak mod syeg, nu nzak lu nzho mod yazaa lu xni lo re xaa nzho lo yalnakaw. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Nzak lu nzho mod lu lu re kwaan wen lo re xaa nagakt, nu nzak lu nzho mod seed lu re xaa nagakt xtizh Dios, nel nkano lu ley kwaan mzaa Dios, nel lo Xkyech Dios nkee re yalnzhak nu re kwaan wli. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Kwaanzee chelee lu mbezh lu, nseed lu stub naz xaa xtizh Dios, ¿chozhiin nanseedt lu leeka lu? Nzaa lu kwent nawent lewann xaa, ¿chozhiin nlewann lu? ");
INSERT INTO zpoNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Mbezh lu nawent chaal xaa stub ngwnaa, ¿chozhiin nle luya? Mbezh lu nayii lu ne lu re maj, ¿chozhiin nlewann lu kwaan nzho leen xkyidoo maj? ");
INSERT INTO zpoNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Nto doo lu yalxwa nel Dios mzaa ley lo lu, ¿chozhiin nanlet lu kwaan nzhé ley? ¡Kwaane nle zee nawent nii re myet Dios! ");
INSERT INTO zpoNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kwaanzee kwentaxa nkeeya lo Xkyech Dios: “Nawent nii re xaa nanakt xaa Israel Dios, kwent cheen re gu”. Is. 52:5 ");
INSERT INTO zpoNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Wli, chelee lu nle lu kwaan nzhé ley kwaan mzaa Dios lo Ches, wena, nel mchoog lu tik baal cho lu, zee nzho lu beyy cheen nu, xaa Israel. Per chelee lu nanlet lu kwaan nzhé ley nixa mchoog lu tik baal cho lu kwaan nak beyy cheen re nu, nanakt lu kwenta tub re nu, xaa Israel. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Per lee re xaa nangut beyy cheen re nu, nu nle xaa kwaan nzhé ley, nak xaa kwenta tub xaa sawlazh nu, xaa Israel, xaa nzho beyy. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Loka xaa nle kwaan nzhé ley, nixa nanzhot xaa beyy cheen nu, telisa ngaazh xaa kwaan tich re xaa nkano ley per nanlet xaa kwaan nzhéya, nixa nzho xaa beyy cheen nu. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nel re xaa wlipa nak dii Israel, nanakta re xaa gol lo xey nu Israel, nixa nzho xaa beyy cheen nu cho xaa, nel re xaa wlipa nzho beyy cheen Dios naz leen lextoo xaa, xaa ne nak xaa wlipa nak dii Israel. ");
INSERT INTO zpoNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Lee xaa wlipa nak dii Israel, nzho xaa beyy cheen Dios naz leen lextoo xaa, nu nanakta nel mroog tik baal cho xaa, mod nzaa ley kwent, sinka leeya nak tub kwaan mle Mbi Naban cheen Dios naz leen lextoo xaa. Nanont kwaan nle re myet xgab, kwaan non lo xaa nak nix nzhak lextoo Dios ne xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Nixa sneeya, nix doo nzhak lextoo re nu, xaa Israel, xaa nzho beyy cho, ");
INSERT INTO zpoNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","nel Dios mzaa xtizh xaa lo re xaa dii Israel. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Wena, ¿per cho kwaan gak chelee tub sawlazh nu laa nawiitra lo Dios? Sbaa naleet komba le zee laa Dios rese xaa dii Israel. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","¡Telisa nalaat Dios yalwen! Nel tubka nle Dios kwaan né xaa, nixa rese myet nak xaa nkade; nel lo Xkyech Dios nkee: Dios, rese kwaan nzhé lu wli nak, nu chelee xaa naab xaa kwent lo lu, lu le gan lo xaa. Sal. 52:4 ");
INSERT INTO zpoNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Per chelee re kwaan nawent kwaan nle be, nlu lee Dios nak tub xaa nali, ¿cho kwaan yé be? Chol sbaa naka, ¿chozhiin nayii Dios leezha nle be kwaan nawent nu nted Dios be bid? ¡Per yalnabdizh ne nak tub kwaan nachan! ");
INSERT INTO zpoNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","¡Telisa nawlit lee Dios nak tub xaa nakap! Nel chelee Dios nak tub xaa nanalit, ¿xomod naab Dios kwent lo rese myet yizhyo? ");
INSERT INTO zpoNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Lak xaa mbezh: “Wen naka chelee na nkade na nel zee mas klar nlu re kwaan wli cheen Dios, zee nlu wen nak Dios. Cheleeya sbaa naka, zee nanzhaalt naab Dios kwent lo na, kwent cheen re kwaan nawent kwaan mle na.” ");
INSERT INTO zpoNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Chol sbaa naka, zee nzho mod yé be: “Nzhaal le be re kwaan nawent, zee mas klar luu kwaan wen”. Lak xaa mbezh sbaa nlu nu, per nawlit xaaya, telisa lee Dios ted xaa ba bid. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","¿Cho kwaan nzak gu? ¿Che re nu, xaa Israel, nak xaa xwara lo stub naz myet? ¡Nawlita! Nel mod mkeela na, Dios naab kwent lo rese xaa, lo re xaa dii Israel nu noka lo re xaa nanakt dii Israel. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Nel lo Xkyech Dios nzhé: ¡Nik tub xaa nali nyent! ¡Nik gola tub xaa! ");
INSERT INTO zpoNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nik tub xaa nanzaat yek, nu nik tub xaa nankwaant Dios. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Rese xaa mlaa Dios, rese xaa mzen naz nawent, lal ngok rese xaa zee nyentra sirb re xaa. ¡Nik tub xaa nle kwaan wen nyent! ¡Nik gola tub xaa! Sal. 14:1-3 ");
INSERT INTO zpoNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Lee yeer yenn xaa nak mod baa kwaan nzoxal, nu roo xaa nroo kwaan nkade xaa. Sal. 5:9 Nu re wdizh kwaan nii xaa nak mod xtox mball. Sal. 140:3 ");
INSERT INTO zpoNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Nu kwaan roo xaa nge xaa lo re myet nu nii xaa re wdizh nala lo re myet. Sal. 10:7 ");
INSERT INTO zpoNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Nu kwaan rop nii xaa nrexonn xaa, gut wechxinn xaa. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Palpa nzha xaa nle xaa ndil re myet nu nted xaa re myet bid. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Nu nanlabeyyt xaa naz kwaan nle zee kwi wen re xaa. Is. 59:7-8 ");
INSERT INTO zpoNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Nu tira nanzhebt xaa ne xaa Dios. Sal. 36:1 ");
INSERT INTO zpoNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Nela be, rese kwaan nii ley cheen Dios, leeya nii lo re xaa ngwii lo ley. Kwaanzee nik tub myet nyent mod né: “Nanet na cho kwaan nak jwalt”. Nel Dios naab kwent lo rese myet. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Nyent mod zo wen myet kwaan Dios nel ngwii xaa lo ley. Nel nebse non ley, zee luu, be nak tub xaa nzeb jwalt. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Per nal mlu Dios nen xomod zo be nali lo xaa, nu nanakta nel ngozhaw be ley cheen Ches, nel leeka ley nzaa kwent xomod nzhaal zo be nali lo Dios nu noka re xaa yilo, xaa mzaa kwent kwaan nzhé Dios lo lee xaa, mzaa kwent xomod nzhaal zo be nali lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nu nali nzo be lo Dios nal, nel ngwii be lo Jesucrist. Nu kwent cheen xaa rese myet nzho mod zo nali lo Dios nel delant lo Dios lal nak re myet. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Rese myet mle jwalt nu tira nanalit nzo xaa lo Dios. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Per nel nkela Dios rese be, mle xaa be mod tub xaa nik tub jwalt namlet, kwent cheen kwaan mle Jesucrist, leezha ngut xaa zee mdix xaa rese jwalt cheen be. ");
INSERT INTO zpoNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Mlaa Dios ngut Jesucrist delant lo rese myet zee gorna mxo xaa xren xaa ngok xaa tub xaa mchee jwalt cheen rese myet, xaa ngwii lo xaa. Nel myedoola Dios ne re be nazskweeze, nu nangunaabt xaa kwent lo re jwalt kwaan mle be, ");
INSERT INTO zpoNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","nel nzhekla xaa luu xaa lee xaa nak xaa nali re mbizh ne. Nu nal seetaka nali nak xaa, nu nkiib xaa jwalt tich re xaa ngwii lo Jesucrist zee noka lee xaa gak xa