﻿USE sofia;
DROP TABLE IF EXISTS sofia.zpmNT_vpl;
CREATE TABLE zpmNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zpmNT_vpl WRITE;
INSERT INTO zpmNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesús meṉ ne pxeeḻ Dios ga, lo xtii Abraham, lo xtii David, ga brieequia me. Lëë grë xmeṉgoldoo me nu: ");
INSERT INTO zpmNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham goc pxoz Isaac, Isaac goc pxoz Jacob, Jacob goc pxoz Judá (bio zla xpëëd Jacob), ");
INSERT INTO zpmNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá goc pxoz Far ni Zar (Tamar brieelë tsieel Judá), Far goc pxoz Srom, Srom goc pxoz Aram. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram goc pxoz Minadab, Minadab goc pxoz Naasón, Naasón goc pxoz Salmon. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmóngoc pxoz Booz (Rahab brieelë tsieel Salmon), Booz goc pxoz Obed (Rut brieelë tsieel Booz), Obed goc pxoz Isaí. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí goc pxoz rey David, David goc pxoz Salomón (lëë Salomón ga gop tsieel Urí wnaa ne bionie David). ");
INSERT INTO zpmNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón goc pxoz Roboam, Roboam goc pxoz Abí, Abí goc pxoz Asá, ");
INSERT INTO zpmNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asá goc pxoz Josafat, Josafat goc pxoz Joram, Joram goc pxoz Uzí. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzí goc pxoz Jotam, Jotam goc pxoz Acaz, Acaz goc pxoz Ezequí. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequí goc pxoz Manasés, Manasés goc pxoz Amón, Amón goc pxoz Josí, ");
INSERT INTO zpmNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josí goc pxoz Jeconí (bio zla xpëëd Josí). Leṉ dze ne nac Jeconí mëëd, leṉ dze co güeybee zhoo zha Babiloin grë zha Israel, beynie zho zho Babiloin. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babiloin, ga gol tib xpëëd Jeconí brieelë Salatiel, Salatiel goc pxoz Zorobabel. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel goc pxoz Abiud, Abiud goc pxoz Liaquim, Liaquim goc pxoz Azor. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor goc pxoz Sadoc, Sadoc goc pxoz Aquim, Aquim goc pxoz Liud. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Liud goc pxoz Leazar, Leazar goc pxoz Matán, Matán goc pxoz Jacob. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob co nagoṉ goc pxoz José, meṉ ne ptsieelnia Marí. Marí goc xniaa Jesús, Meṉ ne nacle diidz ga cxeeḻ Dios guiaad lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Zig choopchop bdziṉ lo dii co, dzigoraa brieequia Jesús. Tsiida zho wban desde Abraham haxta David; stsiida zho wban desde Salomón haxta leṉ dze ne bey zho Babiloin; stsiida zho wban desde leṉ dze co haxta bdziṉ dze ne goc me mëëd. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Znu bzhaac Marí grop José leṉ dze ne ziaadyob gal Jesús. Gard ctsieelnia Marí loxaque xtiidz me no ne laa me ycaa José, zeeṉe bnabey Espíritu Sant pquialo tib mëëd zdoo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zeeṉe bieṉ Joséw, miṉe beeṉ me gocladz me mazd nsaan me Marí; sac sca rnabey ley ni zienaḻpaa me miṉe rnabey ley; per laa me gocladz zhliaanse nzozit me, sacne racladzd me nriee xquieḻto Marí. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Zhgab co no me, tibaque blulo tib xanjl Dios lo me lo mcaaḻ. ―José (xiag David) ―rëb anjl co―, peet tsienied guic luu, pcaania Marí gac me tsieel luu; sac goṉ mëdyeeṉ ne zoney me ga, Espíritu Sant bnabey pquialo win zdoo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Zeeṉe gaḻ dze ne laa win gal, JESUS cueelë luu win, sca grieelë win sac win csilaa grë meṉladz win lo doḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ga brieequia miṉe bnee Dios padzeela, zeeṉe bzeet zha ne biadnee xtiidz mew, rëb zho: ");
INSERT INTO zpmNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Bii zaṉ to gaṉle zeeṉe laa tib mëëdbgui yquiaalo zdoo tib wnaayeeṉ ne gard gnee mgui lo. Zeeṉe laa win gal, Emanuel grieelë win. (Emanuel nac zig nacne rnee ne: Dioszhal ziaad lo ne.) ");
INSERT INTO zpmNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zeeṉe bna José laa guic me goc tibli; bin me xtiidz anjl co laa me ptsieelnia Marí. ");
INSERT INTO zpmNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Laa me wban tipse grop me per ib bgaaḻd me Marí, haxta bded dze ne laa mëdyeeṉ co gol. Bdziṉ dzew, laa win gol, dzigo bleelë José win JESUS. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tib guiedz win ne ndxie xtan Judé lë Belén, ga gol Jesús. Lëëtse leṉ dze co zob meṉ ne lë Herod nac me rey ne rnabey dan co. Goc palal dzew, laa bla zha ne ruṉbey lo mel ziaad nëz ne rlan ngbidz bdziṉ Jerusalén, ");
INSERT INTO zpmNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","bnabdiidz zho rëb zho: ―¿Pa lo dieṉ no mëëd ne gac meṉ ne gnabey ladz to nu, mëëd ne griiṉ gol ga? Bdzioṉ no tib mel nëz ne no no, mel co blu lo no laa win gol-le, miṉ co ne ziaad no nu ziaaddziaṉ no win. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","4","Grë meṉguiedz Jerusalén, zeeṉe bin zhow bzee zdoo zho. Laa Herod, rieṉdraa me zha guṉ me, bnabey me pcaalsa grë zha ne nac pxoz non, grë zha ne rseed miech ley, bnabdiidz me lo zho dieṉ pa lo nac diidz gal Meṉ ne nole diidz cxeeḻ Dios guiaad lo guidzliu ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dzigo rëbchaa zho lo me: ―Belén, guiedz ne ngab Judé ga none gal meṉ co, sac scale zhobnee lo guits ne pquiaa zha ne pxeeḻ Dios padzeela biadteed xtiidz me, zeeṉe psiaab me guic zho znu bnee zho: ");
INSERT INTO zpmNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Teḻ Belén, niicle ne winraaw lo grë guiedz ne ngab Judé, per nroob nona; sac goṉ ga grieequia tib meṉ ne gnabey, meṉ ne so yquiaanap grë meṉ Israel, ne nac zho zha ne ngab lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nacne zhliaanse bnabey Herod gocredz gza zha rac co, bnabdiidz me lo zho dieṉ blapaa dze rac psilo goṉ zho blan mel co. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Blozhse ga, dzigo pxeeḻ me zho Belén, rëb me lo zho: ―Ga goḻtsie goḻtsieguib mëëd co. Zigne gdziel to win, goḻtëniegazh diidz lo naa nu, zeeṉa ye naa ga gagaṉ naa win. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Blozhse sca pso me diidz lo zho, laa zho bio nëz stib laa zho zie. Laa mel ne goṉ zho brieequia nëz ne ziaad zho ga, laa ma neraque lo zho; haxta bdziṉ ma ngali guic yu ne no mëdyeeṉ co, gataa laa ma blëz. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","11","Zeeṉe goṉ zho laa mel co blëz ga, per nli rley zho. Bzëëb zho leṉ yu co, goṉ zho laa mëdyeeṉ co no ga grop xniaa win, dzigo pquiitsgzhib zho lo win, bnee zho tib xtiidz zho lo win. Blozh ga blee zho ncuaaṉe zienie zho lo win, blee zho or, blee zho tiblo yaalnex, ni tiblo nceit nex rnee zho mirr, bgad zho lo win. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Zeeṉe laa gza zha rac co wbi Belén, laa ne nieted zho Jerusalén, stible nëz bzheṉ zho zey zho; sac bnee Dios lo zho lo mcaaḻ, rëb me tsienied zho diidz lo Herod. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Laa gza zha rac co zey, zeeṉe güeylulo tib xanjl Dios lo José lëëtse nixguies me, rëb anjl co lo me: ―José, na zeeṉa guche i pcaanie mëdyeeṉ qui nëz grop xniaa win, goḻsë nëz Egipt, sac laa Herod yquiaguib win gut me win. Egipt, ga cuëznie to win, na naaque guiaḻnie diidz lo to zeeṉe laa to gbi ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Guieel cogazh guche José, pcaanie me mëdyeeṉ co nëz grop xniaa win, laa zho ziese nëz Egipt; ");
INSERT INTO zpmNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ga blëz me haxta bdziṉ dze ne laa Herod gut. Ga brieequia miṉe bnee zha ne biadteed xtiidz Dios padzeela, zeeṉe znu bnee zho: “Nëz Egipt no xpëëd naa, zeeṉe bredz naa me.” ");
INSERT INTO zpmNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Laa zeeṉe goṉ Herod wbiredraa gza meṉ rac co nienie zho diidz lo me, per nli blëë me. Ntseeb rac me, pxeeḻ me zha ne güey Belén ni grëraa guiedz ne ndxie gax ga, güeygut zho grëse mëëdbgui yeeṉ ne no grë guiedz co, desde win ne golnëz, haxta win ne rap chop iz. Tibaque naṉ me sca ngaa mëdyeeṉ ne nac Jesús ga niet win, sac blee me cuent zhile gac chop iz psilo goṉ gza zha rac co blan mel co. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Guieḻnëdox ne bio grë miech co, ga brieequia miṉe bzeet Jeremí meṉ ne biadteed xtiidz Dios padzeela, zeeṉe znu rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Tib redz nroob ne zëëb leṉ guiedz Ramá. Grë wnaa Judá, zha ne ziaad lo xtii Raquel, mbanse rac zho, roon zho no zho xquieḻnë xpëëd zho; zha rna zha ne cchoobladz zdoo zho, sac laa xpëëd zho gut. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Goc palal dzew laa Herod gut, dzigo pxeeḻ Dios tib xanjl me güeynee lo José lo mcaaḻ zaatne no José nëz Egipt, rëb me lo José: ");
INSERT INTO zpmNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―José, guche i, pcaanie mëdyeeṉ qui nëz grop xniaa win, goḻbire nëz Israel stib; laa zha ne quianaḻ win ga gutle. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dzigo brieenie José mëdyeeṉ co ga grop xniaa win, bio me nëz laa me wbire zeynie win nëz Israel. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Per zeeṉe bin José lëëque tib xpëëd Herod meṉ ne lë Arquelá, meṉ co biaaṉ xlugar Herod zobnabey xtan Judé, bdzieb José ndziṉnie me mëdyeeṉ co nëz co. Dzigo bneeque Dios lo me lo mcaaḻ tsie me nëz Galilé. ");
INSERT INTO zpmNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Goḻ zho Galilé, bdziṉaque zho guiedz Nazaret, ga wbannie zho mëdyeeṉ co. Ga brieequia miṉe bzeet grë zha ne biadteed xtiidz Dios padzeela, zeeṉe rëb zho: meṉ Nazaret guiab miech nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Leṉ dze ne psilo Juan Bautist noseed Juan miech xtan zha Judé, dan zit ne no me ga; ");
INSERT INTO zpmNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","rnee me lo zho: ―¡Goḻsaan xquieḻntseeb to, goḻnab lo Dios guṉ me to perdon grëtaa doḻ ne ziyuṉ to; sac goṉ laa dze bdziṉle laa me csilo gnabey! ");
INSERT INTO zpmNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Lëë Juan Bautist ga bzeet profet Isá, zeeṉe znu pquiaa me: Bii zon miech gaṉle zeeṉe laa tib tsi meṉ zëëb tib dan zit, rnee me: “Goḻzhixcuaa nëz ne ted meṉ ne rnabey, goḻsaan grë guieḻntseeb ne ruṉ to.” ");
INSERT INTO zpmNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Niapse guits lad camell niaa xab Juan, guid nac ncuaaṉe ndxie leṉ me, ni niapse nguzhanch ni dzin dan row me. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nzian grë meṉguiedz Jerusalén, grë meṉ Judé, grë meṉ ne no gax ro guiubee Jordán, rriee zho riequiaadiag zho zhiwseed me. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Grë zha ne rxobdoḻ grëse xtoḻ zho, dzigo rchoobnis me zho ro guiubee co. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Laa zeeṉe raṉ me grë zha farisé, zha saducé ne rdziṉ lo me ga racladz zho ye zho chobnis, dzigo rnee me lo zho: ―¡Miech ngoopdoḻ, masaque nac to zig nac meeḻ! Naṉ to na lëë, loxaque chobnis to laa to laale lo grë guieḻnëdox ne ziaadyob. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Led scada goṉ, none zaacse gban to zeeṉa glu nli dib zdoo to psaan to grë xquieḻntseeb to. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ni gacniatsde to guiab to loxaque por nacse to xtii Abraham, laa Dios csilaale to; sac gneli naa lo to gaṉle teḻne gacladz Dios, haxta grë quie zac gnabey me tsaalow miech ne gac zha xtii Abraham. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Naṉle to gaṉle, grë yag nex, zeeṉe rquiad nex low led rruga, rlozh ga rliaaḻa lo gui, ga reca. Scadaa nagoṉ gdzieelo miech ne gband zigne racladz Dios, sac rrieequia laa me nzheṉle xquiibyag me cchug me yag ne sca nac. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Nli tib wrobnisse nu rnedz naa lo to, nacsew zig tib señ, sac lëë gdib rluw laa to psaan xquieḻntseeb to, laa to bzëëb xnëz Dios. Saṉgue meṉ ne no guiaad ga, mesi Espíritu Sant gdeed me lo zha ne gliladz me; ni scagaa zha ne gliladzd me, sonëz me zho zaatne nitlo zho. Ne nligaa tib meṉ non nac me, teḻ naa peet nond naa, per ni par tib nguṉdziin ne glit lab me raguiaḻd naa gac naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Laa me guiaad zig tib zha ne rbeeguizh zhobxtil, sac zha co rlozhse ruṉmbe zho zhob, rgotsow zhow, laa paj rielaaḻ zho lo gui, ga reca. Per gui ne gzëëg grë paj ne guiadbee me ga, gdziṉd dze guiuuw. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Leṉ dze co briee Jesús nëz Galilé zie me nëz ro guiubee Jordán, laa me zie par cchoobnis Juan me. Bdziṉ me ");
INSERT INTO zpmNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","nëd Juan cchoobnis Juan me, rëb Juan lo me: ―Lëda i goṉ, naa none guiaḻ lo luu cchoobnis luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dzigo rëb me lo Juan: ―Nli scaw, per mazd pchoobnis naa, sac goṉ ib nonguieḻa dziuuṉ ne miṉe rnabey Dios. Dzigoraa pchoobnis Juan me. ");
INSERT INTO zpmNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Laa me zieriee lo nis zeeṉe laa zhan gbaa bzhial, goṉpaa me zig rlu tib palom rlu Espíritu Sant laa me ziad-zëëb bdziṉ me guic me, ");
INSERT INTO zpmNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ni blu zëëb tib tsi meṉ co nëz gbaa rnee me: ―Xpëëd naa goṉ nac meṉ qui, rleynie naa me, meṉ nziuu nac me lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Zeeṉe blozh brobnis Jesús, dzigo güeynie Espíritu Sant me tib dan zit, zaatne guieṉd miech; ga gocladz meṉdox niuṉgüet ma me niuṉ me miṉe racladz ma. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Zeeṉe goc choo ngbidz choo guieel no me dan co ni tib lë peet rowd me, laa me pcaabedz ");
INSERT INTO zpmNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","hor co bdziṉ meṉdox zaatne no me ga, rëb ma: ―Teḻne nli Xpëëd Dios nac luu, bnabey tsaalo grë quie rii ncuaaṉe gow luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Dzigo pquiab me rëb me lo ma: ―Znu zhobnee lo Xtiidz Dios: “Niapse por xtiidz Dios mban miech, yquiamband zho loxaque guieḻwagwse.” ");
INSERT INTO zpmNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Blozh ga güeynie ma me Jerusalén, blep ma me glaa guic yadoo nroob ne zob lad guiedz co, ");
INSERT INTO zpmNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","rëb ma lo me: ―Teḻne nli Xpëëd Dios nac luu, briṉgaa nu, beṉque led znu zhobnee lo Xtiidz Dios: “Znabey Dios grë xanjl me yquiaanap luu, zha queedz luu, zeeṉa ni tib quie ycaaṉd ni luu.” ");
INSERT INTO zpmNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pquiab me rëb me lo ma: ―Psoladz gaṉle, noque stib zaatne znu rnee lo Xtiidz Dios: “Bieṉ, Dios nac meṉ ne rnabey luu, nodne quitnie luu me gnab luu lo me ncuaaṉe nod guṉ me.” ");
INSERT INTO zpmNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Blozh ga bii güeynie ma me glaa tib guic gui, ga blu ma grëse guiedz ne ndxie dib lo guidzliu lo me, ni blu ma grëse ncuaaṉ ndaan ne rap tib tib guiedz co, ");
INSERT INTO zpmNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","rëb ma lo me: ―Bui gaṉle, grëse ncuaaṉ qui goṉ gnedz naa lo luu teḻne squiitsgzhib luu lo naa niina, guṉnon luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Horco pquiab me rëb me lo ma: ―¡Biche lo naa nu meṉdox! Znu goṉ zhobnee lo Xtiidz Dios: “Diosse nac meṉ ne rnabey, mese none guṉnon luu, lo me rieguiaḻ yquiitsgzhib luu; ni miṉe rnabey me miṉ co none guṉ luu.” ");
INSERT INTO zpmNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dzigoraa biche ma lo me, dzigo bdziṉ bla anjl bdeed zho ncuaaṉe dow me. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zeeṉe bin Jesús laa Juan biab ladzguiib, dzigo briee me ga güey me nëz Galilé, guiedz ne lë Nazaret. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Zhisaque goca, brieeque me ga güey me Capernaum tib guiedz ne ndxie gax ro Nisdoo Galilé, zaatne nac xtan zha xtii Zabulón ni zha xtii Neftalí. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ga brieequia miṉe bzeet Isá (meṉ ne pxeeḻ Dios padzeela biadnee xtiidz me), zeeṉe psiaab Dios guic Isá rëb Isá: ");
INSERT INTO zpmNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Grëse meṉzit ne ndxie xtan Galilé, nëz daṉ ro guiubee Jordán, gax ro Nisdoo Galilé, zaatne goccheṉ Zabulón ni Neftalí; ");
INSERT INTO zpmNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","miech ne no lo ncow nac zho, per niina tib biini nroob biab lo zho. Ladzniale guieḻgut no zho, per laa biini co biab lo zho par griee zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ga psilo Jesús pseed me miech, rnee me lo zho csaan zho xquieḻntseeb zho, gbig zho lo Dios, sac laa dze ne csilo gnabey Dios ziaadgaxle. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Leṉ dze co, tib dze zieded Jesús gax ro Nisdoo Galilé goṉ me chop ngoozmeḻ, tib zho lë Simón Pedr, stib zho lë Ndrés; grop bets zho lëëtse laa zho noroṉ guiex ne rgaa meḻ lo nis. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Dzigo bredz me zho, rëb me lo zho: ―¡Goḻtë goḻtënaḻ zhits naa! ¡Laa naa cxeḻ to tsie to stib gooz, tsietop to grë miech ne sëëb xnëz Dios! ");
INSERT INTO zpmNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Horcogazh psaṉ zho guiex ne rgaa meḻ ga, laa zho zienaḻ zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Zhisaque bzë me ro nis co, goṉ me laa Jacob ni Juan (lëë grop xingan meṉ ne lë Zebedé ga) no tib leṉ barcw gza pxoz zho, noquiaabdie zho guiex ne rgaa meḻ; dzigo bredz me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Zigne bredz me zho biaaṉnieque pxoz zho barcw ga, laa zho zienaḻ zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Dipse xtan zha Galilé, guiedz ne rdziṉtaa Jesús rie me grë yadoo ne zob lad guiedz co rseed me miech Xtiidz Dios, rnee me lo zho zha racladz Dios gban zho, ni ruṉguiac me grë meṉ rzacnë, teḻ pe guieḻguiidztaa rzac zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Teḻ pa lotaaw zëëb diidz scataa ruṉ me grë milagr, haxta nëz Siria bin miecha. Nzian grë meṉ co briee ga bdziṉnie zho grë zhimguidz zho lo me: no grë meṉ rzacnë co noguitnie meṉdox, no zho rlan guieḻguidz gutye, no zho gutoo dipse xcuerp, no zho rlan grë pe stib guieḻguidz, nogaa zho rlan grë pe yoob; grëse zho beeṉguiac me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Zaatne zieetaa me, miech guizhiu ne naḻ zhits me, grë zha Galilé, grë zha Decápolis, grë zha Jerusalén, grë zha Judé, haxta grë zha ne no stib nëz ro guiubee Jordán. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tib dzew, goṉ Jesús laa grë miech guizhiu co bdziṉ lo me, dzigo bzoquia me glaa tib guic gui win. Ga zob me, bdziṉ grë xpëëdscuel me lo me, ");
INSERT INTO zpmNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","dzigo psilo me pseed me zho, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―¡Wen zie zha ne rieṉ ib none gbig zho lo Dios, sac ib zdziṉ zho zaatne rnabey me! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’¡Wen zie zha ne mban rac roon niina, sac schoobladz Dios zdoo zho! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’¡Wen zie zha ndooladz, zha ne zienie guic gban zigne rnabey Dios, sac scaania zho guidzliu ne gdeed me lo zho! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’¡Wen zie zha ne racladz guṉ grë miṉe rnabey Dios, rzac zhow zigne rzac zha ne rcaabedz, zha ne rnabgaa zhis, sac ible zacnie Dios zho parne grieelo guṉ zhow! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’¡Wen zie zha ne rquia zdoo miech, sac zigne rquia zdoo zho samiech zho scaque Dios squia zdoo me zho! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’¡Wen zie zha ne mbele zdoo, zha ne biaaṉmbele lo xtoḻ, sac zaṉlo zho Dios! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’¡Wen zie zha ne noxco zaacse gban miech, tiḻd zho, sac masaque mëëd gac zho lo Dios! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’¡Wen zie zha ne loxaque porne quiayuṉ zho miṉe rnabey Dios, rquianaḻ miech zho, sac ible zdziṉ zho zaatne rnabey me! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Zig nac to, zeeṉe csilo grë miech yquiaago zho to, ctsidiḻ zho to, yquiadiidzguizh zho to loxaque ne rliladz to naa, ¡wen zie to ga! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","¡Nley goḻco zdoo to, nguieeḻ goḻgac, sac goṉ tib guieḻnzaac nroob ne gneedz Dios lo to! Goḻsoladz gaṉle, scaque beeṉ zho grë zha ne pxeeḻ me padzeela biadnee xtiidz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Masaque nac to lo guidzliu rii zig nac zed. Naṉle to gaṉle pa lotaa rquiin zed, per teḻne nzhida, ¿pa dieṉ rquiina? ¡Lëë gdib rliaaḻa lo guizh, zaatne rded rzë miech rzëëni zhow! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Nac to zig tib biini ne noziini lo guidzliu. Grieelod tsongueets to, sac tib guiedz ne ndxie glaa tib guic gui, grieelod tsongueetsa. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Goḻguieṉ gaṉle nacd biini parne tsolana, sinque parne gziiniw lo grë miech ne no leṉ yu. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Zaacse sca goḻgac, miṉe rquiin miṉ co goḻguṉ, masaque lëëw gac zig tib biini; zeeṉa zeeṉe gaṉ miech biini co zieṉ zho gaṉle pa lotaa meṉ nroob nac Pxoz to meṉ ne no gbaa. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Guiabde to togo bod laa naa ziaḻ ziaḻtichee naa ley ne psaṉ Moisés, o grëgaa miṉe bnee zha ne biadteed xtiidz Dios padzeela; sac led miṉcod ziaḻ naa, sinque laa naa ziaḻ guṉ naaw zigne no gaca. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gneli naa lo to gaṉle: Laga niaa guidzliu rii, laga niaa gbaa, ib none gac miṉe zhobnee lo ley, miṉe bneegaa zha ne biadteed xtiidz Dios, ni tib lë paat gdzëëda. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Gacxe waa zha ne quiits tib ley niicle miṉe mazdraa wina, ni cseed zho miecha zigne ruṉ zho ga, ib tedsod zha nac zha ne mazdraa win guiaaṉ lo grë zha ne ygaa zaatne rnabey Dios. Saṉgue zha ne guṉa zigne rnabeya, ni cseed zho miech scaque tsienaḻ zhow, zha cosi nroob gacnon zho lo grë zha ne gdziṉ zaatne rnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","’Rso naa diidz lo to sca, zaacse goḻgac guṉde to zigne ruṉ grë maistr ley, grë zha farisé; sac teḻne tsoxcode to gban to zigne racladz Dios, grieelod gdziṉ to zaatne rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Led naṉle to gaṉle, no tib ley ne biaaṉ lo xmeṉgol to padzeela, rneew: “Gute luu samiech luu”; rnabeya zha ne gut samiech, ib none guetaque zho, quizhgazh zho doḻ co. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sca rnee ley co, per zig nac zha ne goṉ në rac zdoo raṉ samiech, rrieequia beetle zho ga, ye zho rieguiaḻ quizh falt co. Zig nac zha ne gnee pe tib diidznë lo samiech, none gacredz zho lo wxtis zeeṉa guṉquizh zho zho doḻ co; zha ne quiegaa samiech, lëëque zha rguib guey zho gabiḻ ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Gacxe waa teḻ ziesaṉ to tib gon, per lo pcoogle zo to rsoladz to rdiḻnie to tib samiech to, ");
INSERT INTO zpmNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","gase goḻsaṉ gon co, goḻtsie goḻtsienabgazh perdon lo zha ne rlëë to lo ga, gbireraa to dzigo gdeed to gon co. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Zha ne sca rlëënie to, goḻtsoxco pront goḻguiaaṉ wen; zeeṉa tsiezod zho to lo wxtis, sac teḻ laa zho tsiezo to lo wxtis ib znabey wxtis tso to ladzguiib. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gneli naa lo to gaṉle grieede to ga, haxtaque lozh quizh to grë dimi ne gnab wxtis lo to. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Naṉlaque to gaṉle zha rnee stib ley ne biaaṉ lo xmeṉgol to, rneew: “Zha ne nole tsieel, zigtaa mguiw zigtaa wnaaw, nodne tsonie zho zha ne led tsieeld zho.” ");
INSERT INTO zpmNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per zig nac zha ne goṉ, raṉ tib wnaa ni rsilo zho riogui zho tsonie zho wnaa co, laa zho bdiitsle ley co. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Gacxe waa, bziaalo to miṉe rquiaqui ruṉctal to xtoḻ to, mazd goḻcueegazha; niicle teḻ bziaalo derech tow. Peet nacd nitlo tib lëque xcuerp to, lëdle dib nacsew tsietsobe gabiḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Laa teḻ niagaa tow, miṉe rquiaqui ruṉctal to xtoḻ to, niicle teḻ nia derech tow, goḻchuggazha. Peet nacd nitlo tib nia to, lëdle nitlo to leṉ gabiḻ dib nacse xcuerp to. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’No stib ley znu rnee: “Mgui ne racladz csaan tsieel, zac ctso zho; totsaque gdeed zho tib guits lo wnaa, zaatne raquiet ne laa zho psaan wnaa.” ");
INSERT INTO zpmNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per gni naa lo to gaṉle: teḻne quiangobd tsieel zho stib mgui, ni rsëbtsieel zho, lëëque zha rguib ga yquianie tsieel zho stib mgui. Mgui ne ctsieelnia wnaa co, doḻ ga guṉ zho, sac goṉ nole tsieel wnaa co. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ziyon to gaṉle zha nac stib ley ne biaaṉ lo xmeṉgol to rneew: “Zha ne gzeet lë Dios par glu zuṉ zho miṉe bnee zho, yase zeeṉe gdeed zho tib gona, guṉgaa zho pe tib dziina, ib none guṉ zhow.” ");
INSERT INTO zpmNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per gni naa lo to gaṉle: nodne sca gzeet to lë Dios, per ni gbaa nodne ne sca gzeet to, sac goṉ ga nac zaatne zob Dios; ");
INSERT INTO zpmNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","per ni guidzliu, sac lo guidzliu nac zaatne zo ni me; per ni Jerusalén, sac ga nac guiedz nroob ne rnabey me; ");
INSERT INTO zpmNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","guiaabgaa to gzeet to guic to. Guṉscade to, sac goṉ zig nac guic to, per ni tib guitsguic to grieelod csaṉ nquits to, grieelodgaa csaṉ ngas tow. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Gacxe waa ncuaaṉe rgobey to zrieelo guṉ to, goḻguiab: “zuṉ naaw”, togo rieṉgaa to grieeloda, goḻguiab: “grieeloda”; tsode to dieeṉ cho gzeet to, sac goṉ led Diosdraa rnabey miṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’No stib ley znu rnee: “Teḻ cuee zho tib bziaalo luu, guiaaṉd luu scase bleeque stib bziaalo zho, teḻ cueegaa zho tib lay luu, scaque beeṉ blee stib lay zho.” ");
INSERT INTO zpmNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Saṉgue naa laa naa rso diidz lo to goṉ, guṉscade to; zha ne gacntseeb lo to, gacndaande to lo zho. Teḻ cap zho lo to, tiblise goḻgac, ib guṉde to glisaque nia to. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","’Zha ne tsiezo to lo wxtis, ni lozh ga haxta gla zho xibiaagw to, goḻsaan güey zhow haxta xabnaḻ to goḻdeed lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Zeeṉe grieequia zha ne gnabey to güey to xyo zho tib groḻ hor, goḻgüeya, haxta tib hor goḻtsie güey tow. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Zha ne gnabtaa pe cos lo to, goḻdeeda; zig nac zha ne ziadtiiṉ, goḻdeed ncuaaṉe ziadtiiṉ zho, ctsirede to zho scase. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ziyonle to gaṉle no zha ne znu rnee: “Zha ne rdzieel xtiidz luu bleynie zho, scagaa zha ne rlëë lo luu, blëënie zho.” ");
INSERT INTO zpmNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per led scada goṉ, ¡none zaacse gac to lo zha ne rlëë lo to! ¡Zha ne rgodee to, goḻnab lo Dios guṉlay me zho! ");
INSERT INTO zpmNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Zeeṉa sca glu nli xpëëd meṉ ne zob gbaa nac to. Goḻgaṉ gaṉle teḻ me rnabey me rziini ngbidz lo grëse miech, zigtaa lo zha wena, zigtagaa lo zha ntseeba; scaque nisguie me rsiaaba rquiin zho grëse zho, rbed me dieṉ cho ngable lo me, chogaa ngabd lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","¡Gase nasca goḻwi! Teḻ loxaque zha ne ndzieeldiidz to zha cose rleynie to, ¿niacxe zgaa to guieḻnzaac ne gdeed Dios? Haxta zha ne mazdraa ntseeb ruṉ miṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Teḻ loxaque zha ne nacse meṉlidz to, lo zha cose zaacse rnee to, ¿pe lëë guieḻwen ga na rlu to? Haxta zha ne ruṉbeyd Dios ruṉ miṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Goḻtsoxco sca ndzinli goḻgac, zigne rleynie Pxoz to (meṉ ne zob gbaa) grëse miech, scaque none guṉ to. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Zeeṉe guṉ to xyudar samiech to, ib guṉde to zaatne ndxiepaa miech ga so to glu to xquieḻwen to, par gaṉ zho miṉe ruṉ to. Teḻne sca guṉ to, ygaade to guieḻnzaac ne gdeed Pxoz to meṉ ne zob gbaa. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Gacxe waa, zeeṉe guṉ to xyudar zha ne guieṉd pe yquiin, gooḻdide tow zigne ruṉ grë zha ne rquiaalo rquia zdoo samiech; sac zha co teḻ pe ncuaaṉe rgad zho, rzo zho leṉ yadoo, rzo zho ro nëz rlozhd yquiaabdzie zhow par gacnaṉpaa miecha, zeeṉa zha ne gona guiab zho: ¡Zha wentaa zha qui! ¡Gneli naa lo to gaṉle ne sca riaṉnziuu zho lo miech, lëële gdib guieḻnzaac ne ygaa zho ga! ");
INSERT INTO zpmNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Goḻguieṉ sca, zeeṉe guṉ to xyudar zha ne no tib liaadz, choot lo gzodiidzde tow, per ni zha ne mazdraa ndzieeldiidz to nodne gacnaṉa. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dzigo scagaa Pxoz to nroob guieḻnzaac ne gneedz me lo to, sac teḻ me grësew raṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Scaque zeeṉe gzodiidznie to me, guṉde to zigne ruṉ grë zha ne rquiaalo miech wen nac zho. Sac teḻ zha co zeeṉe rzodiidznie zho me, rzo zho zaatne gaṉpaa miech zho, zig nac leṉ yadoo, zig nac leṉ guiedz zaatne rded rzë miech. Gneli naa lo to gaṉle lëële guieḻnzaac ne ygaa zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Goḻguieṉ zeeṉe gzodiidznie to me, goḻsëëb leṉ lidz to dziits goḻsioog ro yu, ga goḻzodiidznie me. Ible tedsod nroob guieḻnzaac gneedz me lo to, sac niicle ncuaaṉe mazdraa ngueets zhliaana, raṉ mew. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ni zeeṉe nozodiidznie to me, guṉde to ncuaaṉe nonee to lëëw rlozh, lëëw rsilo zigne ruṉ grë zha ne ruṉbeyd me. Sac zha co rzac zho por nroob diidz gnee zho, por nzian vuelt gnee zhow dzigo squiaadiag mew. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Guṉscade to, sac me ne nac me Pxoz to gardle gnee to xliaadz to lo me laa me naṉle pe nac ncuaaṉe rquiin to. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gacxe waa zeeṉe gzodiidznie to me, znu goḻnee: Dios, luu ne nac luu Pxoz no, zob luu gbaa; luuse nac meṉ ne mazdraa ndzon. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Luu nac meṉ ne gnabey no, miṉe gnabeytaa luu zigne raca gbaa, scaque none gaca lo guidzliu nu. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Beeṉ guieḻnzaac bneedz ncuaaṉe dioow no nadze. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bzhiguieḻ beeṉ no perdon grëse doḻ ne ziodziuuṉ no lo luu, zigne rdziuuṉ no samiech no perdon grë falt ne ruṉ zho lo no. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gdeete luu diidz yquiil meṉdox no, beeṉ guieḻnzaac bla no lo ma. Luu nac meṉ ne rnabey, meṉ ne rap poder, meṉ ne mazdraa nroob. Miṉe rnab no nu, ndioṉpaa no zuṉ luuw. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Sca nagoṉ none gnee to. Ni goḻgona gaṉle, zha ne goṉ guṉ samiech zho perdon teḻ pe nactaa falt ne beeṉ zho lo zho, scaque Pxoz to meṉ ne zob gbaa, zuṉ me zho perdon. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Zha ne guṉd samiech zho perdon, niicle megaa guṉd me perdon xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Stiba, zeeṉe nocuan to nozodiidznie to me, guṉmbande to lo to. Sac grë zha ne rquiaalo miech wen nac zho, sca ruṉ zho; zeeṉe nocuan zho xtsiinpaa ruṉ zho ruṉmban zho lo zho par gaṉ miech laa zho nocuan. Gneli naa lo to gaṉle, zha ne sca ruṉ lëële guieḻnzaac ne ygaa zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Guṉscade to, nguieeḻ goḻgac iṉe goḻzëë biegw guic to, goḻquiib lo to, zeeṉa ni tib choot guieṉd laa to nocuan, loxaque Pxoz to gacnaṉa, sac grëse ncuaaṉe rac ngueets raṉ mew. Grëse ncuaaṉe rac, me raṉa, me nac meṉ ne gneedz tib guieḻnzaac nroob lo to. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Tsienaḻde to loxaque dieṉ zha gapcheṉ to lo guidzliu rii, sac nac ncuaaṉ lo guidzliu rii rban ngbaana, rnitlo mxiḻa, haxta noxtseeb guioochena. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mazd goḻtsoxco ygaa to guieḻnzaac ndzon ne no gbaa, sac miṉe no gbaa, led yed miṉ co guioochen, led yed miṉ co cuan ngbaan, led yedgaaw gnitlo mxiḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Goḻgona gaṉle, guieḻnzaac ne goṉ guṉlo to, ga glu pa gdziṉ xalm to, sac zaatne guṉlo to guieḻnzaac co ga nac zaatne gdziṉ xalm to. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Rrieequia nac bziaalo to zig nac tib biini. Teḻne niapse lo grë ncuaaṉe ndzinli rwi to, dzigo gdipse xcuerp to no lo guieḻbiini. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Laa teḻne loxaque lo grë ncuaaṉe nonguieḻd rwi to, dzigo gdipse xcuerp to no lo guieḻcow ga. ¡Zha rnazhe lo guieḻcow co, teḻ lëëque biini noyac guieḻcow! ");
INSERT INTO zpmNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Goḻgona gaṉle, grieelod goṉ gleynie to dimi, ni gleynieque to Dios. Ib none teḻne Dios rleynie to, me none gleynie to, togo dimigaaw, dimi goḻleynie. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Gacxe waa, gni naa lo to gaṉle: Tsode to zhgab dieṉ zha gban to lo guidzliu rii, pa griee pe gow to, pe guie to, pe gacwxabgaa to. Stiba, ¿niacxe mazdraa non guieḻwagw lo xquieḻmban to? Xabgaa tow, ¿niacxe mazdraa nona lo xcuerp to? ");
INSERT INTO zpmNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Goḻwi lo grë mguiṉ gaṉle, led yed ma rquia gon, led yed ma rquia wlaap, led yed ma rgotsow pe guieḻgon, per row ma, sac Pxoz to meṉ ne zob gbaa, meṉ co rdeed ncuaaṉe row ma. ¡Teḻ to goṉ, mazdraa non to lo grë mguiṉ co! ");
INSERT INTO zpmNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ni lalnu paat rquiinda tant tso to zhgab. Teḻne guiab to tso to zhgab dieṉ zha gacnool xtse to spalal yeeṉse, ¿niacxe zrieelo to guṉnool tow? ");
INSERT INTO zpmNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Zig nac lar, ¿pe nacne tant tso to zhgab dieṉ pe gacwxab to? Pe rwide to lo grë guiee ne gaṉle zëëb dan, zha rrooba, led yeda rio zhgab dieṉ zha gacwxaba, per niow rnaw; ");
INSERT INTO zpmNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","gni naa lo to gaṉle, per ni rey Salomón con grë xab niazh me, blud me scataa niow. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","’Gase na gaṉle goḻwi, niicxe grë guiee dan co na, zna dze zob nguiaw, gzhe widz laaw bidzle, laaw tsecle, ni scataa niow rgacwxab Diosa, ¿pe leḻ to dzigo ygacwxabd me, niicle ne squi gard guieṉ to dib zdoo to gnalo to me? ");
INSERT INTO zpmNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","’Tsode to zhgab sca guiab to: “¿Bay pa griee pe dioow ne, pa griee pe dio ne, pa griee pe dziaacwxab ne?” ");
INSERT INTO zpmNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Grë miech ne ruṉbeyd Dios, tibaque zhgab co rio zho. Saṉgue to goḻsoladz gaṉle, Pxoz to meṉ ne zob gbaa, naṉle me pe nac grë xliaadz to, ");
INSERT INTO zpmNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","me nac meṉ ne gneedz ncuaaṉe yquiin to, per ib none glo tsoxco to gban to zigne rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Goḻguieṉ sca tsode to zhgab dieṉ zha ted to gzhe widz, sac gzhe widz co zhaalaque xco ne ziaad. Tib tib dze zhaase zhaase zhgab ne ziaadniew. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Blozh ga rëbchaa me lo zho: ―Goḻguieṉ, ib guṉde to në gac zdoo to zeeṉe raṉ to ncuaaṉ nonguieḻd ne ruṉ stib miech, sac to tozhal guṉquizh zhow; zeeṉa scagaa Dios, guṉscad me to. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sac goṉ teḻ zha rzac to samiech to, scasaque sac Dios to. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","’¡Lëda ga goṉ tso to lozhd gzee zdoo to dieṉ cho pe ruṉ, ni nenda mazdraa miṉe ruṉ to! ");
INSERT INTO zpmNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Pe ro to glisqui to miṉe ruṉ stib zho, ni teḻ mazdraa nac miṉe ruṉ to? ");
INSERT INTO zpmNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Goḻguieṉ sca glude to ncuaaṉe nacde to! Glo goḻtsoxco ndzinli gac to, dzigo lozh ga zac tsienee to lo stib zho zha gacndzinli zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ndzon nac Xtiidz Dios, gdeete tow lo zha ne rlëëniew, sac goṉ rrieequia lo mëcw ga gdeed tow, ib zuṉ zho miṉe ruṉ mëcw zacntseeb zho lo to. Naca zig nac quie perl, gdeete tow lo zha ne rleynieda, sac goṉ rrieequia lo nguts ga gdeed tow, teḻ ngutsa niicle ncuaaṉe mazdraa non glaaḻ zho lo ma, loxaque gzëëni maw. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Ncuaaṉe rquiin to, goḻnaba lo Dios, scagaa me zneedz mew. Goḻguib teḻ pe racladz to, me nac meṉ ne gacnie to gdziel tow. Goḻcuedzlë me, scagaa me scaania me to. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sac grëse zha ne rbig lo me rnab zho ncuaaṉe rquiin zho, rdeed mew. Zha ne rguib ncuaaṉe racladz, racnie me zho rdziel zhow. Zha ne rbedzlë me, rcaania me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Goḻwi gaṉle, zig nac to zeeṉe rnab xpëëd to guiet gow win, ¿niacxe ziazh to co to tib quie nia win? ");
INSERT INTO zpmNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Zeeṉe rnabgaa win meḻ, ¿niacxe zdeed to tib meeḻ lo win? ");
INSERT INTO zpmNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Led rioxco to lëë niapse ncuaaṉe wen rdeed to lo xpëëd to, niicle ne miech ntseeb nac to. Teḻne sca rioxco to xpëëd to, peleḻ Pxoz to dzigo, meṉ ne zob gbaa, tsoxcod me to. Ib tedsod grëse zha ne gnab lo me gdeed me ncuaaṉe rquiin zho, zdeed mew. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Zha ne racladz ndzinli gac miech lo zho, none glo zho zaacse gac zho lo miech. Zigtaa ley ne psaṉ Moisésa, zigtagaa miṉe bnee grë zha ne biadteed xtiidz Dios padzeelaw, sca rnabeya. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Goḻtsoxco sca tsienaḻ to miṉe rnabey Dios, niicle ne nac guieḻmban co zig nac zeeṉe rzë ne tib nëz nia. Zhis zha ne rzëëb nëz co, per nëz co zgaa miech guieḻmban ndzon ne rdeed Dios. Sac goṉ zha ne mban zigne notaa guic zho, rrieequia tib nëz nzhen ga zie zho; ndal miech ne zie nëz co, per nëz ne nitlo zho ga zie zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Nsin goḻso lo zha ne gacladz yquidie to gnë zho xtiidz Dios noteed zho, niicle ndooladz rlu zho pale cho grë mëcwxiil yeeṉ, per zha ntseeba, masaque nac zho zig grë coyot blë. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Zigne ruṉbey miech tib yag por nex ne rquia low, scaque wen wen goḻwi zha nac ncuaaṉe ruṉ zho, dzigo ga guṉbey to cho nac zho. Sac goṉ zig nac uv, rquiada lo yag guiets; niicle guigwgaaw rquiada lo grë lbë guiets. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tib tib yag nex rdeedsew xnexa. Tib yag wen, nex wen rquia low; scagaa yag ncuaana, nex ncuaan rquia low. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Grieelod yquia nex ncuaan tib lo yag ne rquia nex wen, ni grieelodgaa yquia nex wen tib lo yag ncuaan. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Gacxe waa grë yag ne rquia nex ncuaan, paat rquiinda, lëë gdib rruga, rlozh ga rzëëg zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Miṉ co nagoṉ rne naa lo to, zha ne sca guiaad, por ncuaaṉe ruṉ zho ga guṉbey to cho nac zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Grë zha ne rnee noxco zho miṉe rnabey Dios, no zho lega rneesew. Nenda haxta rnee zho, naa nac meṉ ne rnabey zho, per gdziṉd zho zaatne rnabey Pxoz naa. Sac zha ne nlipaa ruṉ miṉe rnabey me, zha cose gdziṉ ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Gaḻ dze co, nzian zha ne grieequia gnë lo naa: “Conque rdziuuṉbey no luu, blactaa name bio no bionee no Xtiidz luu lo miech, nzian milagr ne bdziuuṉ no, haxta meṉdox bdziuṉcxooṉ no zeeṉe bzeet no lë luu.” ");
INSERT INTO zpmNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Niicle sca gnë zho, ib ycaaniad naa zho, sonëz naa zho; sac ni lalnu beeṉd zho ncuaaṉe ndzinli. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Zha ne rquiaadiag miṉe rne naa, ni rioxco zho rban zhow zigne naca, rrieequia nac zho ga zig tib zha ndzielguic ne bzaa lidz zaatne nac tib lo quie. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Niicle riab guiedox per peet racd lidz zho, niicle rriee medox, nis naal ne raclo rded zaatne zoba ga, per rbixcheda. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","’Laa grë zha ne rquiaadiag xtidz naa, ni rioxcod zho gban zhow zigne naca, ziaad gac zho ga zig tib zha nxen ne güeyzoob lidz zaatne nac tib lo yuzh. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Znuse bnitlo lidz zho, sac zeeṉe biab guiedox, lo medox ne briee, lo nis naal ne goclo bded zaatne zoba, znuse bixchew, ni stib lëw biaaṉd. ");
INSERT INTO zpmNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Zeeṉe blozh bnee Jesús, grë miech ne noquiaadiag ga, per nli rzee zdoo zho goṉ zho zha rseed me, ");
INSERT INTO zpmNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sac rlu meṉ rnabey nac me, led yed me rseed miech zig rseed grë maistr ley. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Laa Jesús ziad-zëëb cho gui win co, miech guizhiu ne naḻ zhits me, ");
INSERT INTO zpmNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","tibaque brieequia tib mgui ne rlan guiedzdox ne lë lepr, wbig me pquiitsgzhib me lo Jesús, rëb me: ―Tebaa siguieeḻ luu guṉguiac luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dzigo pxobnia Jesús guic mgui, rëb Jesús: ―Zuṉguiac naa luu. ¡Niinagazh laa luu guiaaṉmbe! Horcogazha laa grë guiedz co bnitlo. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dzigo rëbchaa Jesús lo me: ―Bina gaṉle, choot lo gzodiidzd luu goṉ zha biac luu; sinque güey lo pxoz güeysaṉ gon ne rieguiaḻ gdeed luu zigne rnabey ley ne psaṉ Moisés, zeeṉa gaṉ zho gaṉle laa luu biacle. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Loxaque bdziṉ Jesús guiedz Capernaum, laa tib meṉ ne rnabey lo xmeṉguiib zha Roma bdziṉle lo me, rnab meṉ co guṉguiac Jesús tib zha ne quia xtsiiṉ me, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―Beeṉ tib guieḻnzaac beeṉguiac tib zha ne rquia xtsiṉ naa, laa zho nix lidz naa ib gacd griaḻ zho, mban rac zho yoobdox ne rquia zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Dzigo rëbchaa Jesús: ―Peet nacda, na së naa guio ne guṉguiac naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","―Coo ―rëb meṉguiib co―, rieguiaḻd csodziin naa luu sëë luu haxta lidz naa. Naṉpaa naa zrieelo luu nugazh gnabey luu guiac zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Sac zig nac naa no zha ne rnabey lo naa, ni ron naa miṉe rnabey zho; scagaa teḻ guiep naa tib lo zhaguiib ne rnabey naa: “Güey nu”, rie zho; rnegaa naa: “Dë nu”, riaad zho; zha ne ruṉgaa dziin lo naaw, miṉe rnabeytaa naa zho, ruṉ zhow. Scaque luu nagoṉ naṉpaa naa zrieelo sca gnabey luu guiac xmoz naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Zeeṉe goṉ Jesús sca rnee meṉ co, rley me, rëb me lo grë zha ne zienaḻ zhits me ga: ―Lo grë zha Israel, gard goṉ gaṉ naa tib zha ne squitaa dib zdoo rnalo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ni goḻquiaadiaga gaṉle, zdziṉ dze grële zha zit ne squi gnalo Dios, zha co ygaa sobnie Abraham, sobnie Isaac ni Jacob zaatne rnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Laa grë zha Israel, niicle nac zho zha ne nac diidz gdziṉ ga, leḻ lo ncow nëz ley guiaaṉ zho, ga tso zho goonnë zho, haxta gow lay zho lo guieḻnëdox co. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Blozh ga rëbchaa me lo meṉguiib co: ―Bzë nasca, gocnaṉ gaṉle zigne bliladzse luu guiac xmoz luu, sca gaca. Horcogazha laa moz co biac. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Laa zeeṉe bdziṉ Jesús lidz Pedr, goṉ me laa xniadzoop Pedr nix rlan xlëë. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dzigo bded me zaatne nix zhuz co, zigne bzheṉ me nia zhuz laa xlëë co blëz. Horcogazh guche zhuz beeṉlo zhuz ncuaaṉe dow zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ziedzele dzew, laa ngbidz rzëëblew, zeeṉe bdziṉ grë miech co, nzian grë zha ne nosacsi meṉdox bdziṉnie zho lo me. Grëse zho beeṉguiac me, goctox me lo grë meṉdox ne nosacsi zho ga, beṉcxooṉ me ma; ni zha ne rlangaa pe stib guieḻguidz, grëse zho beeṉguiac me. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ga brieequia miṉe bzeet Isá, meṉ ne biadteed xtiidz Dios lo miech padzeela, zeeṉe rëb me: “Grëse xquieḻnë ne, grëse guieḻguidz ne rziaac ne, me biw.” ");
INSERT INTO zpmNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Zeeṉe goṉ Jesús scataa ndal miech ne goclo lo me ga, dzigo bnabey me xpëëdscuel me gzhixcuaa zho, sac laa zho no tedquia stib nëz ro nisdoo co. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dzigo wbig tib meṉ ne nac maistr ley lo me, rëb maistr co: ―Zaatne tsietaa luu goṉ, sënaḻ naa zhits luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Dzigo rëbchaa me: ―Gocnaṉa gaṉle, naa ne nac naa Mgui ne pxeeḻ Dios, peet rapd naa nu, mazd zig nac grë mëz, grë mguiṉ, rap ma zhibliee ma, rap ma zhiptsieez ma; per naa per ni zaatne gaguies naa quianied naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wbigaque stib zha ne rzënaḻle zhits me, rëb zho: ―Ye naa goṉ sënaḻ naa zhits luu, per bzhiguieḻ bneedz diidzbey cuëz naa gaṉgazh naa tsoliu pxoz naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pquiab me rëb me: ―Dënaḻ zhits naa. Psaan, nzian grë zha gut no, tsow tsiequeets zho sameṉgut zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dzigo laa me bzëëbnie xpëëdscuel me tib leṉ barcw, laa zho zie. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","25","Laa zho zie lo nis co, tibaque zeeṉe psilo briee tib medox, masaque rlis me lo nis co, laaw psilo rzëëb leṉ barcw. Dzigo lëëlëd güey zho güeycuaan zho me, sac lëëtaque nixguies me. ―Ligier gaṉle ―rëb zho―, blee mcaaḻ lo luu. ¡Bui gaṉle laa ne nitlo lo nis rii, csaand luu guet ne nu! ");
INSERT INTO zpmNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Dzigo rëbchaa me lo zho: ―¿Pe nacne squitaa rdzieb to? ¡Gardaque dzigo lëë gliladz to cho nac naa! Dzigo guche me, bnee me lo me co, bnee me lo nis co cuedzew. Horcogazha blëz me co, niicle nis cow laaw bredze. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Zeeṉe goṉ zhow, bzee zdoo zho. ―Bay chozhe waa nac meṉ rii ―rnee zho―. ¿Zha nac ne haxta me, haxta nis ron xtiidz me? ");
INSERT INTO zpmNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Laa zho bdziṉdze stib nëz ro nisdoo co, zaatne nac xtan zha Gadar, zeeṉe brieequia chop mgui ne nosacsi meṉdox, bdziṉ lo Jesús ga. Zha ntseeba, rdzieb miech zho, choot rdete nëz co. Leṉ baa briee grop mgui co bdziṉ zho ga, ");
INSERT INTO zpmNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","nguiedz roptsie zho rnee zho: ―¡Peet guṉd luu no Jesús, psaan no! Rdziuuṉbey no luu, Xpëëd Dios nac luu. Ne nligaa beeṉ guieḻnzaac csacsid luu no niinaga. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Zitlaaque ga ndxie tib dzoon nguts notop lag, dzigo bnab grë meṉdox co lo Jesús rëb ma: ―Teḻne cuee luu no nu, bzhiguieḻ bneedz diidz lose grë nguts qui gdziiṉ no. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","―Niinaga sca goḻtsie ―rëb me. Zigne psaan meṉdox co grop mgui co, güey ma bdziṉ ma lo grë nguts co. Horco psilo grë nguts co, rquiaa ma corr güeypix ma tib ro yeedox ne quia ro nisdoo co, bliaaḻ ma lo nis, grëse ma gut. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Zha ne quianap grë nguts co, gzase zho bzhooṉ. Güey zho lad guiedz güeyzodiidz zho zha goc grë nguts co, ni bzodiidz zho zha biac grop mgui ne nosacsi meṉdox ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Grëse miech co, briee zho zieso zho. Zeeṉe bdziṉ zho goṉ zho laa Jesús zo ga, dzigo bnab zho lo me siguieḻ me gbi me xtan zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Dzigo wbiireque bzëëb zho leṉ barcw, bdziṉ zho guiedz Capernaum stib, sac ga nac zaatne rbëz Jesús leṉ dze co. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Zhisaque goc bdziṉ me, laa zho bdziṉniele tib meṉ rzacnë lo me, dipse meṉ co gutoo, ib gacd së me. Lo yag zhoob me bdziṉnie zho me ga. Zeeṉe goṉ Jesús dib zdoo grë zha co rnalo zho ne me guṉguiac meṉ rzacnë co, rëbchaa me lo meṉ rzacnë co: ―¡Nley bloo zdoo luu xin! ¡Laa naa beṉle perdon grëse xtoḻ luu! ");
INSERT INTO zpmNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ga zob blalaa maistr ley, zeeṉe goṉ zho sca bnee me, bza zdoo zho rëb zho: “¡Quiaguitnie meṉ qui Dios goṉ squi rzë xtiidz me!” ");
INSERT INTO zpmNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Bieṉga Jesús sca rza zdoo zho, dzigo rëbchaa me: ―Lëda i goṉ squi rza zdoo to. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nli ngaṉda guiab ne lo miech: “Laa naa beṉle perdon grëse xtoḻ luu”; per grieelod lega guiab ne laa ne guṉguiac zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Gacnaṉ to sca gaṉle naa ne nac naa Mgui ne pxeeḻ Dios, ible rap naa poder par guṉ naa miech perdon. Dzigo rëbchaa me lo meṉ rzacnë co: ―¡Niinagazh guche i, bi yag ne bzhoob luu i, zeeṉ bzë! ");
INSERT INTO zpmNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Zigne sca bnee me, laa mgui co bzoli, laa me zey. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Grë miech guizhiu ne ndxie ga, zeeṉe goṉ zho sca beeṉguiac me mgui co, bdzieb zho. Psilo zho rdeed zho xquizh lo Dios, scataa poder ne bdeed Dios lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Blozh ga laa Jesús briee ga. Ro nëz zieded me goṉ me tib meṉ lë Matew, lëëtaque laa meṉ co zob lo mezh zaatne razh dimi ne rey lo zha Roma; sac me rcaania dimi co. Dzigo bredz Jesús me tsienaḻ me zhits Jesús. Ga guso me, laa me zienaḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Bded ga güeynie me Jesús tib wagw lidz me. Grë zha ne rcaania dimi ne razh lo zha Roma, grë zha ne zëëb diidz nac zha ntseeb, tipse brenie Jesús zho grë xpëëdscuel me. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Blalaa zha farisé, goṉ zho sca tipse zobnie me grë zha co, bded ga, rëbchaa zho lo xpëëdscuel me: ―¡Mod scataa na rownie xmaistr to grë zha ngoopdoḻ, grë zha beed ne nac recaudador! ");
INSERT INTO zpmNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Bin Jesús sca quianee zho, dzigo rëbchaa me lo zho: ―Naṉle to gaṉle, zha ne ruṉ rmed, zaatne no zha rzacnë ga rquiin zho, ¿niacxe squiin zho zaatne no zha ne ndip ndaan? ");
INSERT INTO zpmNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Goḻsoladz gaṉle znu rnee Dios: “Laa naa racladz gacndooladz miech, yquia zdoo zho samiech zho, racladzdaxe naa waa guiaad zho dieeṉ peraa guiaadlogon zho lo naa.” Mazd gaṉle goḻtsie, tsow goḻsob goḻguieṉ dieṉ zha nacne sca rnee me. Teḻ naa, ziaḻguibd naa miech wen, sinque laa naa ziaḻguib grë zha ngoopdoḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Bdziṉaque xpëëdscuel Juan Bautist, bnabdiidz zho lo Jesús, rëb zho: ―¿Pe nac waa ib rcuand xpëëdscuel luu? Ni no grë no zha farisé, zhiga zhiga laa no rcuanle. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Pquiab me rëb me lo zho: ―Zaatne nadieṉ noyac tib guieḻtsieel, ¿pe niacxe lega csilo grë zha ne ndxie lo lni tso zho guieḻnë, ycuan zho, ni raṉ zho laa mgui ne notsieelnia zo lo zho? Per zdziṉ dze zeeṉe laa mgui co gbiche, ni zeeṉe laa dze co gdziṉ, dzigosi nagoṉ rieguiaḻ tso zho guieḻnë, rieguiaḻ ycuan zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Raṉle to gaṉle, zha ne rquiaabdie tib lë lar, yquiaad zho lar cub lad lar gox, sac zha ne sca guṉ paat yquiind wquiaabdie co. Zeeṉe laa lar cub gbe, lëëque lëëw guṉnat zaatne nriez lar gox. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Scaque tsod zha ne cotsow vin cub tib leṉ guid ne padzeela noquiin, sac stsiez nziu cuba; dzigo niicle guid cow, niicle nziugaaw laaw nitlo ga. Gacxe, teḻ nziu cuba none leṉ guid cubaque tsotsowa. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lëëtaaque sca quianee Jesús lo xpëëdscuel Juan Bautist, zeeṉe bdziṉ tib mgui ne nac zha non yadoo. Zigne bdziṉ me pquiitsgzhib me lo Jesús, rëb me: ―Beeṉ tib guieḻnzaac së luu guio ne lidz naa. Laa tib xpëdwnaa naa blozh niina, per naṉpaa naa teḻne cxobnia luu guic win, zbeeban luu win. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dzigo bio Jesús nëz zienaḻ me zhits meṉ co, gza xpëëdscuel me. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Lad grë miech ne zienaḻ ga, lad co no tib meṉ wnaa, gocle tsiipchop iz rlan me tib guieḻguidz, rzac me zigne rzac grë meṉ wnaa gzob mëë, tibaque rlan mew ib rbëzda. Ga zie me, zeeṉe wbig me nëz zhits Jesús, bzheṉ me ro lar ne mbix Jesús, ");
INSERT INTO zpmNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","sac tibaque güeynie guic me, ziac me totsaque ygaa xab Jesús nia me. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dzigo wbire lo Jesús, dze bui Jesús lo me. ―Xin ―rëb Jesús―, peet tsienied guic luu. Laa luu biac sacne bliladz luu naa. Gataa laa wnaa co biac lo guieḻguidz co. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Laa zeeṉe bdziṉ Jesús lidz meṉ rnabey co, laa zha ne rooḻ ndxiele, noquiaa zho grë di ne rac lo ngutoo, grëraa zha ne ndxie ga, nguiedz zëëb tsi zho roon zho, tib ruid ne rac. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Dzigo rëbchaa me lo zho: ―Goḻriee nëz ley, sac goṉ gute mëëd qui, nixguiesse win. Zha ne rlëë, zha ne rzhidzniegaa me, laa zho briee ley. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dzigo laa me bzëëb leṉ yu zaatne nix mëëd co, bzheṉ me nia win. ¡Horcogazha laa win guche! ");
INSERT INTO zpmNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Grëse guiedz ne ndxie dib gax ga, gocnaṉ miech scataa milagr nroob ne beeṉ me, bleeban me mëëd co. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Zeeṉe laa Jesús wbi ga, nëz zie me brieenaḻ chop zha ne roḻd lo zhits me, nguiedz rbedz zho rnee zho: ―¡Jesús, xingan David, pquia zdoo no! ");
INSERT INTO zpmNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bdziṉ Jesús yu ne rbëz me, laa zho wbig lo me. Dzigo rëbchaa me lo zho: ―¿Dib zdoo to dzigo lëë rliladz to zrieelo guṉguiac naa to? ―Dib zdoo now ―rëb zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dzigo pquiaania me zhits bziaalo zho, ni rëb me: ―Miṉe bliladz to i nasca, laaw gac niina zigne bliladz tow. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","¡Horcogazha laa lo grop zha co biac! Dzigo pso Jesús diidz lo zho choot lo gzodiidzd zho zha biac zho, ");
INSERT INTO zpmNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ni zigne briee zho ga, laa zho bzodiidzlew. Blozh ga, grëse guiedz ne ndxie dib gax ga, gocnaṉ miech scataa nac milagr ne ruṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Loxaque wbi grop zha ne biac lo ga, laa bla zho bdziṉlaque, bdziṉnie zho tib meṉ ne nosacsi meṉdox, psaṉngop ma meṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dzigo beṉcxooṉ Jesús meṉdox co, zeeṉe laa ma bzhooṉ laa meṉ co psilo bnee. Grë miech guizhiu ne ndxie ga, per nli rzee zdoo zho, rnee zho: ―¡Wlaltaa gard dziaṉ ne tib meṉ ne squitaa guṉ grë milagr qui! ");
INSERT INTO zpmNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Laa grë zha farisé rnee: ―Ma ne rnabey lo meṉdox nacnie meṉ qui, gane rrieelo ruṉcxooṉ me meṉdox. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Grëse guiedz ne ndxie gax ga, zigtaa guiedz nrooba, zigtagaa guiedz lasa rie Jesús rieseed me miech. Zaatne rdziṉtaa me, rie me xyadoo zho rnee me lo zho zha racladz Dios gban zho, ni ruṉguiac me zho teḻ pe nactaa guieḻguidz ne rzac zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Zeeṉe raṉ me grë miech guizhiu ne rcaalsa lo me, rquia zdoo me zho, sac raṉ me mban rac zho guieṉd cho tib zha ne gacnie zho, rac zho zig grë mëcwxiil yeeṉ ne guieṉd xbaxtor. ");
INSERT INTO zpmNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Tib vuelt haxta rëb me lo xpëëdscuel me: ―Goḻnab lo Dios cxeeḻraa me zha ne guṉ xtsiiṉ me. Goḻwi gaṉle pe zhidaa grë miech qui, quiambëz zho dieṉ cho gnee Xtiidz Dios lo zho. Masaque nac zho niina, zig tib guieḻgon ne goḻle gliaap. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Blozhse sca bnee Jesús, dzigo bredz me gza tsiipchop zha ne nac xpëëdscuel me ga, bzo me zho tsienee zho Xtiidz Dios lo miech, bdeed me poder lo zho guṉcxooṉ zho meṉdox zaatne nosacsi ma miech, ni guṉguiac zho grë meṉ rzacnë. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Znu lë gza tsiipchop zha co: Simón (zha ne rneeque zho Pedr), Ndrés (bets Simón), Jacob ni Juan (zha co nac xingan Zebedé), Lip, Bartol, Mazh, Matew (zha ne ptop dimi ne razh lo zha Roma), Jacob (xingan Alfé), Lebeo (zha ne rneeque zho Tadé), Simón (zha ne no lo partid ne racladz griee zha Roma Israel), ni Judas Iscariot (zha ne güeyto Jesús). ");
INSERT INTO zpmNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Blozhse ga, pso me diidz lo zho zha tsie zho, rëb me lo zho: ―Naṉle to nagoṉ, tsiede to zaatne no grë zha ne nacd zha Israel, niicle sëëbde to grë guiedz ne ndxie xtan zha Samar. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Zaatne no grë zha Israel, gase goḻtsie; lëë grë mëcwxiil ne nonziaab ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","’Goḻtsie, goḻtsienee lo zho gacnaṉ zho gaṉle laa dze ziaadgaxle zeeṉe laa Dios csilo gnabey. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","’Grëse zha ne rzacnë, goḻguṉguiac zho; zha ne rlan guiedz lepr, goḻsaṉmbe zho; zaatne nix zha ne gutle, goḻcueeban zho; grë zha ne nosacsi meṉdox, goḻguṉcxooṉ ma. Peet gnabde to lo miech, goḻguieṉ gaṉle lega bnedz naa poder qui lo to, bzhiide tow. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","’Peet güeyde to, xab tow, lab tow, miṉe nacwse to, miṉe quiase ni to, miṉcose goḻtsienie. Güeyde to dimi, per ni tib guiet güeyde to; sac zaatne tsieguṉ to dziin rii, ib ga none gneedz zho ncuaaṉe gow to. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Guiedz ne gdziṉtaa to, goḻguib dieṉ pa lo no tib zha ne ndzinli, dzigo lidz zha co goḻtsiebëz, haxta gza dze ne laa to gbi guiedz co. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Zeeṉe noguib to pa cuëz to, yu ne tsie to, zaacse goḻgac, goḻquiaabdiuzh zha ne no yu co, ");
INSERT INTO zpmNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","goḻnab guṉlay Dios zho. Teḻne wen gac zho lo to, zuṉlay me zho, togo guṉcasdgaa zho to, dzigo toque guṉlay me. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Zha ne sca siguieḻd ycaania to, goḻrieegazh lidz zho; guiedz ne siguieḻd zho yquiaadiag zho miṉe nonee to, goḻbigazh guiedz co; goḻlit grë yudie co ni to, goḻlu lo zho gaṉle led xtoḻdraa to ga teḻ laa zho nitlo. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gneli naa lo to gaṉle zeeṉe gaḻ dze ne laa Dios guṉ xquieḻwxtis me, bii lëëtaa gac guieḻnë ne ygaa grë miech ne bio guiedz Sodom, guiedz Gomorr, lëdle guieḻnë ro ne ygaa grë miech ne sca siguieḻd ycaania to. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Nsin goḻso, goḻguieṉ gaṉle rrieequia tib mëcwxiil yeeṉse nac to, ni laa naa rxeḻ to zaatne no grë coyot dox. Ndooladz goḻgac, niowse goḻgac lo miech zig rac grë palom, per scagaa con cuidad goḻtsie, goḻgaṉ gaṉle zha rzë meeḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nligaa nsin goḻso, sac goṉ ib ziezo miech to lo wxtis, ni lëëque leṉ yadoo ga quiṉ zho to, ");
INSERT INTO zpmNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","haxta ziezo zho to lo grëraa zha nroob ne rnabey. Laa zho guṉa, loxaque ne nac to zha ne no xnëz naa, ni gagaa nagoṉ gdeeda diidz gnee to xtidz naa lo grë zha co, ni lo grëragaa miech ne nacd zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","’Zeeṉe sca tsiezo zho to lo grë zha rnabey co, tsode to zhgab dieṉ pe gnee to, dieṉ zhagaa gnee tow; sac zeeṉe sca tsiegala, Dios gneedz diidz ne gnee to. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Led tod gnee, sinque, ¡zhiEspíritu Pxoz to meṉ ne zob gbaa, meṉ co gnee ga! ");
INSERT INTO zpmNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Zlëëniedox miech zha ne no xnëz naa. Zio zha ne lëëque bets zho, zha ne lëëque pxoz zho, zha ne lëëque xpëëd zho ctsidiḻ zho, tsielo zho zho ladznia zha ne gut zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Teḻ to, guiets yag gaṉ miech to, per teḻne dziits so to teḻ pe nactaa lo guieḻnë ne ted to, ib zgaa to tib guieḻmban ndzon ne gdziṉdraa dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Guiedz ne no to, zeeṉe laa miech csilo yquiaanaḻ to, goḻriee ga, goḻtsie stib guiedz. Gneli naa lo to gaṉle, niicle stib guiedz stib guiedz tsie to, gardaque lozh tsieted to grë guiedz ne ndxie Israel zeeṉe gaḻ dze ne laa Mgui ne pxeeḻ Dios guiaad stib. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Goḻwi gaṉle zha ne nac mëëdscuel, tsod zha ne ndziibraa non lo maistr, zha ne rquiagaa dziin, tsod zha ne nonraa lo zha ne rree zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Teḻ zha guṉ miech maistr, scaque guṉ zho mëëdscuel; teḻ pe cteed zho bizhuan dziin, miṉcoque cteed zho zha ne quia dziin. Gacxe waa peet tsienied guic to, teḻ pe nactaa ncuaaṉe gnee miech to, sac goṉ niicxe naa name ne nac naa Dad, meṉdox rnee zho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Gdziebde to, zdziṉ dze ne glu gaṉle cho zienaḻ miṉe nac diidzli, chogaa zienaḻ guieḻntseeb, gaḻ dze co grësew xoobneṉ. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","’Grëse miṉe rne naa lo to zeeṉe nese rziodiidza, goḻneew lo miech, haxta glaa guic yu goḻso, nguiedz goḻneew. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gdziebde to miech, goḻguieṉ gaṉle no tib meṉ nroobraa, lëë meṉ co nac Dios. Teḻ miecha, loxaque cuerpse zrieelo zho csacsi zho, saṉgue Dios, zrieelo me gnitlo me miech dib xcuerp zho, dib xalm zho leṉ gabiḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Nligaa gdziebde to, csaand Dios lega pe gac to. Goḻwi gaṉle, zig nac grë mguiṉ niicle ne rzac miech peet nond ma, haxta chop ma rdeed zho por tib gaay centav; per Pxoz to goṉ meṉ ne zob gbaa rsaanladzd me ma, ni tib ma guete teḻne gdeete me diidz. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Peleḻ to dzigo csaan me, haxta guits guic tow, grësew ngaba lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Gdziebde to sca, goḻguieṉ gaṉle nonraa to lo tib dzoon mguiṉ. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Gneli naa lo to gaṉle, zha ne glu lo miech nacnie zho naa, scaque naa zeeṉ gaḻ dze co zlu naa lo Pxoz naa meṉ ne zob gbaa, nacnie naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Saṉgue zha ne ctoladznie naa lo miech, scaque naa ziep naa lo me ruṉbeyd naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’¡Guiabde to togo laa naa ziaḻ loxaque par cuiṉ wense miech! Lëda goṉ, ye ziaḻ naa ziaḻguṉctiḻ naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sac zha ne sëëb xnëz naa, zlëënie xpëëd zho zho, teḻ mëëdgaaw, zlëënie pxoz zho zho; scaque meṉ wnaaw, zlëënie xinzhizh zho zho, zha ne nacgaa nguzhizha, zlëënie xniaa tsieel zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","¡Lëëque meṉlidz miech gac zha ne glëë gaṉ zho! ");
INSERT INTO zpmNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Zha ne mazdraa rquia zdoo glëënie pxoz zho zho, glëënie xniaa zho zho, glëëniegaa xpëëd zho zho, porne guṉ zho miṉe rnabey naa, peet xtsiiṉd zha co par ygab zho xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Scaque zha ne yquia zdoo cueeladz zho zho guiaadnaḻ zho zhits naa, grieelod ygab zho lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sac grëse zha ne rquia zdoo guieḻmban ne rap zho lo guidzliu rii, ygaad zho guieḻmban ndzon ne gneedz Dios; saṉgue zha ne cueeladz xquieḻmban, niicle teḻ csacsi miech zho loxaque ne no zho xnëz naa, ib zgaa zho guieḻmban ndzon co. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Niina goṉ ne squi tsie to, grëse zha ne zaacse ycaania to, zaacse gnee zho lo to, rrieequia naa ga sca ycaania zho; ni zha ne sca ycaania naa, rrieequia meṉ ne pxeeḻle naa ga sca ycaania zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Zha ne cuëzlo tib meṉ ne noteed xtiidz Dios lo miech, guieḻnzaac ne gdeed Dios lo meṉ co, ye zho ygaa guieḻnzaac co. Zha ne cuëzlo tib miech ndzinli, guieḻnzaac ne gdeed Dios lo zha co, ye zho ygaaw. ");
INSERT INTO zpmNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ni zha ne gneedz maase tib zhigaque nis yag lo cho tib zha win ne nac to ne nac to xpëëdscuel naa, ib tedsod zdeed Dios guieḻnzaac ne tsieguiaḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Zeeṉe blozh pso Jesús diidz lo gza tsiipchop zha co, dzigo laa zho zie. Blozh ga laa me brieeque, güey me grë guiedz ne ndxie gax ga, güeyseed me grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Leṉ dze co no Juan Bautist ladzguiib, ga no Juan bin Juan zha nactaa grë milagr ne ruṉ Jesús, dzigo pxeeḻ Juan bla xpëëdscuel Juan güeynabdiidz zho lo me, dieṉ pe lëële Meṉ ne zëëble diidz cxeeḻ Dios lo guidzliu ga nac me, te dzigoraa gdziṉ meṉ co ye. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Dzigo rëbchaa me lo zho: ―Grë ncuaaṉe bin to rne naa, grëgaa ncuaaṉe goṉ to ruṉ naa, goḻtsie goḻzodiidza lo Juan. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Raṉ to gaṉle grë zha ne roḻd lo, grë zha ne gacd së, grë zha ne rlan guiedz lepr, grë zha ne rcuaat, laa zho riac; haxta grë zha ne gutle, laa zho rrieeban. Xtiidz Diosa, laaw quiagaaz lo grëse zha ne rquiina. Grësew, goḻzodiidza. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ni goḻguiab lo me, dichos zha ne racchopd guic, sinque tiblique rac zho rliladz zho cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","8","Zeeṉe laa xpëëdscuel Juan zey, dzigo psilo me bzeet me Juan lo miech guizhiu ne ndxie lo me ga, rëb me: ―Zeeṉe güey to dan ngan co, güey to lo Juan, ¿zha dieṉ güeynie guic to niaṉ to me? ¿Pe rëb to rlu me zig tib goobgui ne nëzrii nëzrec rey me, te rëb to ye masaque grë lar niazh ne racw zha non nacw me? Per naṉle to gaṉle zha ne scataa racwxab riod zho dan. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nligaa cho dieṉ güeynie guic to nac me, ¿te rëb to ye tib meṉ ne noteed xtiidz Diosa? Gacnaṉ to gaṉle tib meṉ ne noteed xtiidz Dios goṉ nac me, ni me nac tib zha ne mazdraa nroob lo grë zha ne ziyuṉ dziin co. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Me ga raquiet lo Xtiidz Dios zaatne znu rnee: Sxeḻ naa tib zha ne tednerga lo luu, zha co gzhixcuaa nëz ne ted luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ne nligaa lo grëse mgui ne zieded lo guidzliu gard grieequia tib zha ne mazdraa non lo Juan Bautist; per zha ne goṉ winraa zaatne rnabey Dios, nonraa zha co lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Desde psilo Juan noseed me miech zhapaa racladz Dios gban zho, ni rchoobnis me zho, hor co psiloque brieequia zha ne rlëënie zhiwseed Dios, gacxe waa zha ne nlipaa rdziebd, zha cose rcaaniaw, rzëëb zho xnëz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mazd glo tibaque raquiet ne laa meṉ ne cxeeḻ Dios ga guiaad, zigtaa lo leya, zigtagaa grë zha ne biadteed xtiidz Diosa, bzeet zhow. Ni niina ne laa Juan biaad, laa meṉ co blanso. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Juan goṉ biaad niina zig no diidz guiaad Lí; goḻgacnaṉ sca gaṉle cho nac me. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Zha ne racladz guieṉ zho zha nac grë miṉe none naa nu, ¡yquiaadiag zhow! ");
INSERT INTO zpmNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","’Nac grë miech rii, rieṉd zho pe racladz zho. ¿Cho gaṉle ruṉ zig ruṉ zho? Lëë zho ruṉ miṉe ruṉ mëëdlas ne rio wguit ro nëz, niicle rooḻ xcompañer win di nguieeḻ rieed win, niicle rooḻgaa zho di ngan, roond win. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sac goṉ biaad Juan, raṉ zho rowd me teḻ pe ncuaaṉe row zho, ried me ncuaaṉe rie zho, dzigo laa zho rnee meṉdox nacnie me. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Blozh ga ziaad Mgui ne pxeeḻ Dios, raṉ zho row me, rie me, laa zho rneeque, lega rowcho me, lega riecho me, ib rieṉd me cho rtsieelsa me, haxta grë zha ngoopdoḻ, haxta grë zha yozh ne rtop dimi ne razh lo zha Roma rzënie me. Sca rnee zho, saṉgue zha ne rgaa guieḻbiini ne rdeed Dios, rieṉ zho cho nac zha ne ziaadguṉ xtsiiṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Blozhse ga, dzigo psilo Jesús bzeet me miṉe ygaa grë zha ne pcaaniad xtiidz me; sac nzian guiedz ne güey me niicle goṉ zho grëtaa milagr ne beeṉ me, per ib psaand zho xquieḻntseeb zho, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Probsaxe grë meṉ guiedz Corazín, grë meṉ guiedz Betsaid! Sac goṉ goṉpaa zho grë poder ne rap Dios, per ib psaand zho xquieḻntseeb zho. Teḻ niaca miṉe niaṉ grë meṉ guiedz Tiro, grë meṉ guiedz Sidón, grë milagr ne goṉ zho beṉ naa, ib ndedsod mban niac grë zha co nio zho guieḻnë, zëëb nsaan zho xquieḻntseeb zho, mbig zho lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Gacnaṉ zha Corazín, gacnaṉ zha Betsaid sca gaṉle, gaḻ dze ne guṉ Dios guieḻwxtis, lëëtaa caxtigw ne ygaa zha Tiro ni zha Sidón, mazdraa miṉe ygaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Scaque zha Capernaum, masaque rzac zho niina zha nziuuraa lo Dios, per gacnaṉ zho gaṉle haxta guiet lo ncowdoo ne guey meṉdox ga guey zho; sac goṉ teḻ niaca miṉe niaṉ zha Sodom grë milagr ne raṉ zho noyuṉ naa, ible nsaan zha co xquieḻntseeb zho, nitlod zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","¡Gacnaṉ zha Capernaum gaṉle gaḻ dze ne guṉ Dios guieḻwxtis, lëëtaa caxtigw ne ygaa zha Sodom, mazdraa miṉe ygaa zho! ");
INSERT INTO zpmNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dzigo bzodiidznie Jesús Dios, rëb me: ―Dios luu ne nac luu Pxoz naa, luu rnabey gbaa luu rnabey guidzliu, rnedz naa xquizh lo luu sac grë miṉe noyuṉ luu nu niina bdeete luu diidz niacnaṉ grë zha raca, sinque laaw blu luu lo grë zha ne nac zig grë mëëdlas. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sca quiayuṉ luu, sac ib scale racladz luu gaca. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Blozh ga rëb me lo grë miech ne ndxie ga: ―Grëse ncuaaṉe raṉ to quiayuṉ naa, Dios meṉ ne nac Pxoz naa, me bneedz poder rii lo naa; sac ib laa me bzo naa, naa guṉa. Xpëëd me nac naa, wen wen ruṉbey me naa, scagaa naa wen wen ruṉbey naa me. Choot ruṉbeyd me zigne ruṉbey naa me, per zha ne gacladz naa guṉbey me, zuṉbey zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Grëse to ne nac to zha ne në noded, rdib rdzag to quiaguib to dieṉ zha guiaaṉwen zdoo to, goḻtë lo naa, naa gneedz tib wdziiladz ndzon lo to. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nligaa goḻbig lo naa, goḻtënaḻ zhiwseed naa, goḻgac tib miech tibliladz, tib miech ndooladz zigne nac naa; zeeṉa gap to descans co. ");
INSERT INTO zpmNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nacda ncuaaṉe ngaṉ, nacda ncuaaṉe guiab to glëbde to guṉ tow. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Leṉ dze coquew, tib dze lëëtaque dze ne rdziiladz zha Israel lo dziina, bded Jesús zaatne zëëb zhobxtil grë xpëëdscuel me. Ga zie zho rcaabedz zho, dzigo psilo zho ptop zho mzion co dow zho zhobxtil co. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Goṉ bla zha farisew, dzigo rëb zho: ―¡Lëda i goṉ noyuṉ to, noguiits to ley i! Goḻguieṉ gaṉle dze nda nac dze rii. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pquiabchaa me rëb me lo zho: ―¿Pe gard glab to zaatne ziaad gaṉle zha beeṉ rey David, tib dze zeeṉe pcaabedz me grë me zha ne ziegza me, ni zienied zho pe gow zho? ");
INSERT INTO zpmNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Rneew, bzëëb me leṉ yadoo güeynab me guietxtil ne nac gon, downie me grë zha ne ziegza me ga, ni loxaque zha ne nacse pxoz row guietxtil co, ¿pe led bdiitsd me ley ga? ");
INSERT INTO zpmNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Lo xley Moisés name zhobnee gaṉle zha haxta dze ne rdziiladz to lo dziin ruṉ grë pxoz dziin leṉ yadoo, ni rneeda doḻ ga sca ruṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Goḻwi gaṉle zha rats ley par gac dziin leṉ yadoo, ni yadoose ga, gacnaṉ to gaṉle lo to nu zo meṉ ne mazdraa non lo yadoo. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","’Rnee Dios lo Xtiidz me, quiambëzd me dieṉ peraa guṉ miech, dieṉ peraa cogon zho lo me, sinque miṉe racladz me guieṉ zho yquia zdoo zho samiech zho. Teḻ niaca miṉe nli rieṉ to miṉ co, zieṉ to gdziibdoḻde to zha ne rapd doḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gacnaṉ to gaṉle naa ne nac naa Mgui ne pxeeḻ Dios, naa rnabey dze rii, naṉpaa naa pe nonguieḻ gac. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bded ga, goḻ stib dze ne rdziiladz zho lo dziina, güey Jesús leṉ yadoo win ne zob lad guiedz co. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lad grë miech ne ndxie leṉ yadoo co, no tib mgui ne mband tib nia; porque laa zha farisé bnabdiidzlaque lo me dieṉ pe nonguieḻa guṉguiac me miech dze ne rdziiladz zho lo dziin. Sca bnabdiidz zho, sac quiaguib zho dieṉ pe yquiaaqui zho me tsiezo zho me lo wxtis. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Dzigo pquiab me rëb me lo zho: ―Togase dieṉ, zha ruṉ to zeeṉe lëëtse dze rii rietsobe tib xpëcwxiil to tib leṉ blë nroob, ¿led zëëb lëë rie to riebee to ma? ");
INSERT INTO zpmNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Teḻ sca rquia zdoo to mëcwxiil, ¡goḻguieṉ gaṉle mazdraa goṉ non miech lo tib mëcwxiil! Gacxe waa ible nonguieḻa guṉ ne xyudar samiech ne, niicle maase dze nda nac dze co. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dzigo rëbchaa me lo mgui ne në nia ga: ―¡Bzigaa nia luu! Zigne bzigaa mgui nia mgui, biacgazha, biaaṉa zig nac stib miṉe ndaantaque ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Grë zha farisé co, zigne briee zho ga laa zho psilo bnediidz dieṉ zha gdeeda diidz gut zho Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bieṉ Jesús sca no guic zho, dzigo mazd briee me ga. Miech guizhiu ne zienaḻ zhits me, grëse meṉ rzacnë ne zienaḻ ga, beeṉguiac me zho; ");
INSERT INTO zpmNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","per pso me diidz lo zho, choot lo gzodiidzd zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ga brieequia miṉe pquiaa Isá, tib meṉ ne biadteed xtiidz Dios padzeela, zeeṉe rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Lëë meṉ rii bzooblo naa guṉ xtsiṉ naa, rleynie naa me, rzac zdoo naa grë ncuaaṉe ruṉ me. Zded naa zhiEspíritu naa gacnie me, me nac meṉ ne cxobneṉ xtidz naa lo grëse miech. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tiḻnied me miech, sedzd yaṉ me lo zho, sod me ro nëz goptsie me. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Grë zha ne gzhe gzhele rac, zig tib goobgui ne quiaxweele, zig tib lë guier ne noyiidiele, csaṉd me zdoo zho; zha ne mban rac lo xliaadz zho, csaand me zho. Miṉ co tsoxco me, haxta gaṉ me grëse miech gacnaṉ miṉe nac diidzli, ni tsienaḻ zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Haxta zeeṉe gaṉ me ye grë zha ne nacdraa zha Israel, laa zho gnalo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dzigo güeynie zho tib mgui lo Jesús roḻd lo mgui ni gacdaque gnee mgui, sac nosacsi meṉdox mgui. Znuse beeṉguiac me mgui, gagazh psilo goṉ mgui, psilo bnee mgui. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Grë miech ne ndxie lo me ga, per nli bzee zdoo zho, rnee zho: ―¡Bay pe lëë meṉ qui naye nac Meṉ ne zëëble diidz ga cxeeḻ Dios! ");
INSERT INTO zpmNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Zeeṉe goṉ zha farisé sca rnee grë miech co, rzachaa zdoo zho rnee zho: “Pe Dios nazho cxeeḻ me, ma ne rnabey lo meṉdox ma co nacnie me, gane rrieelo ruṉcxooṉ me meṉdox.” ");
INSERT INTO zpmNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Bieṉ Jesús sca rza guic zho, dzigo rëbchaa me lo zho: ―¡Ncuaaṉe gacd goṉ rnee to! Teḻ tib wxtis nadieṉ lëëque zha ne nacnie zho csilo tiḻnie zho, ¿niacxe zac gnabey zho? Tib guiedza, teḻ lëëque zha guiedz co tiḻnie meṉladz zho, led znuse lozh guiedz co; tib diigaa miecha, teḻ lëëque zha tiḻnie meṉlidz zho, ¿niacxe nitlod dii co? ");
INSERT INTO zpmNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Scaque meṉdox nagoṉ, teḻne lëëque lëë ma guṉcxooṉ sameṉdox ma, ¡pe nale na bnitlo ma! ");
INSERT INTO zpmNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nana ne squi rnee to Beelzebú nacnie naa gane rrieelo ruṉcxooṉ naa meṉdox, ¿zha ne nacgrë to dzigo, cho nacnie zho ne ye zho ruṉcxooṉ ma? Gase nagaṉle rlu doḻdox i quiayuṉ to, squi rnee to. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Saṉgue teḻ naa zhiEspíritu Dios nacnie naa gane ruṉcxooṉ naa meṉdox, ni ga rlu gaṉle laa Dios psilo quianabeyle nu. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¡Masaque nac meṉdox zig tib zha ne no xfuers, zha ne gacladz cuee grë ncuaaṉe no lidz zha co, none cxidoogazh zho zho! ");
INSERT INTO zpmNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Teḻ meṉdoxa rlëënie ma naa, ni naṉle to gaṉle zha ne rlëë lo ne, gacnied zho ne. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","’Gacnaṉ to gaṉle, grëse doḻ ne ruṉ miech, grë teḻ zha rguie zho, rdzibdee zho, niicle teḻ haxta gneenë zho naa, bii zuṉ Dios zho perdon miṉ co; saṉgue zha ne gneenë zhiEspíritu me, ib guṉdraa me zho perdon. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Naṉle to gaṉle zig nac yag nex, miṉe nac yag, miṉ co nac nex ne rdeeda. Teḻ yag wena nex wen rquia low, togo yag ncuaangaaw, nex ncuaanaque rquia low. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Scaque to nagoṉ zhin meṉdox! ¿Zha naṉ to nadieṉ gac to miech wen, teḻ desde zdoo to ntseeb? Miech ntseeb to gane squi rzë xtiidz to, sac goṉ, ¡grëse diidz ne rriee ro miech, zdoo zho rzaw! ");
INSERT INTO zpmNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gacxe waa, zha ne mbe zdoo, niapse diidz wen, diidz ndooladz nac xtiidz zho. Saṉgue zha ne ntseeb zdoo, niapse diidz ntseeb, niapse diidznë rrieeche ro zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ni gaḻ dze ne goṉ guṉ Dios guieḻwxtis, ib tedsod zuṉquizh me miech tib tib diidz ntseeb, tib tib diidznë ne sca rriee ro zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sac goṉ zigne rzë xtiidz zho niina, miṉ co cueequia zho gaḻ dze co, o miṉcogaa cteedquie zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tib dze wbig zla zha farisé lo Jesús gza zho zla maistr ley, rëb zho lo me: ―Maestro, racladz no dziaṉ no guṉ luu tib milagr, milagr ne glu nli Dios pxeeḻ luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pquiab me rëb me lo zho: ―Nazdpaa ntseeb to, squitaa gocndip zdoo to nëz lo Dios, ¿zha nacraa milagr ne racladz to gaṉ to? ");
INSERT INTO zpmNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Stibaque milagr goṉ gaṉ to, lëë miṉ co gac zeeṉ gaḻ dze ne laa Mgui ne pxeeḻ Dios, tso leṉ liu tsoṉ dze, tsoṉ guieel zigne bio Jonás leṉ meḻ nroob co tsoṉ dze ni tsoṉ guieel. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ni gaḻ dze ne goṉ guṉ Dios xquieḻwxtis me, ib steedquie zha Nínive miech ntseeb ne nac to i; sac goṉ zeeṉe güeynee Jonás lo zho, grëse zho psaan xquieḻntseeb zho wbig zho nëz lo Dios, laa to nëde to gon to diidz niicle ne lo to nu zo tib meṉ ne mazdraa non lo Jonás. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Scaque rein ne bzob nëz Sabá, steedquie me to gaḻ dze co, sac teḻ rein co goḻwi gaṉle pa lo guidzliu ne briee me biaadgaṉ me rey Salomón, biadquiaadiag me grë xtiidz Salomón. Ni to lo to nu zo meṉ ne mazdraa non lo Salomón, ni ib ronde to xtiidz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Teḻne csaande to xquieḻntseeb to i goṉ, low lozh to. Sac to zig bzhaac tib zha ne psacsi meṉdox. Zeeṉe briee ma zdoo zho, güey ma güeyquianzë ma grë dan zit güeyguib ma dieṉ pa cuëz ma. Goṉse ma rdzield zaatne cuëz ma, ");
INSERT INTO zpmNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","rëb ma: “Mazd laa naa gbireque guia naa zaatne brie naa ga.” Zeeṉe biire ma bdziṉ ma zdoo zha co, goṉ ma nroob lugar no, pale tib yu dets, ");
INSERT INTO zpmNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","nacne güeyaque ma güeyxi ma zgadz sameṉdox ma, ma ne mazdraa ntseeb blëznie ma zdoo zha co. ¡Dzigole mazdraa mban biaaṉ zha co, lëdlegaa zigne goc zho glo! Scadaa nagoṉ gdzieelo to. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Laa me bii noneeque, zeeṉe laa xniaa me ni zha bets me bdziṉ, racladz zho gzodiidznie zho me. Per brieelod nzëëb zho haxta leṉ yu, sac scataa miech guizhiu ne ndxie lo me ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dzigo rëb tib zho lo me: ―Laa xniaa luu goṉ ni zha bets luu quiambëz luu nëz ley, racladz zho gzodiidznie zho luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pquiab me rëb me: ―¿Xnia naa ye, bets naa ye? ");
INSERT INTO zpmNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Blis nia me, blu me grë xpëëdscuel me, dzigo rëbchaa me: ―Zha ne goṉ nac zig zha rii, lëë xnia naa ga, lëë bets naa ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","¡Sac grëse zha ne ruṉ miṉe rnabey Pxoz naa meṉ ne zob gbaa, grëse zha co nac bets naa, nac bzian naa, nac xnia naa! ");
INSERT INTO zpmNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Blozh ga briee Jesús güey me ro nisdoo. Ga zob me, ");
INSERT INTO zpmNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","zeeṉe goṉ me nzian miech ne nocaalsa lo me ga, nacne biep me güeysob me tib leṉ barcw zo gax ro nis co, psilo me pseed me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","4","Ndal grë ncuaaṉe pseed me zho, per niapse con cuent rnee mew lo zho. Lëë tib cuent ne bzodiidz me ga nu, rëb me: ―Tib zha name güey gon zhobxtil. Zeeṉe laa zho quialaaḻ zhob co, now bliaaḻ gax ro nëz, now bliaaḻ lad quie, now bliaaḻ leṉ yag guiets. Miṉe bliaaḻ gax ro nëz ga, güey grë mguiṉ znuse dow maw. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Miṉe bliaaḻ zaatne nac lad quie, znuse znuse blana, ");
INSERT INTO zpmNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","per zeeṉe laa lo ngbidz briee, znusaque bgooḻa, bidzgaw; sac guieṉd nroob low. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Miṉe bliaaḻ zaatne nac leṉ yag guiets co, zeeṉe laa yag guiets pxii, bnitlogaw. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Saṉgue miṉe bliaaḻ zaatne nac lo liu naaḻ, blana, brooba ni goca; lo tib tib zhob co no zhimziona briee gaḻptsii zhob, now briee tsoṉgaḻa, nogaaw briee haxta tib gayoow. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Blozh ga, rëbchaa me: ―Zha ne racladz guieṉ miṉe rne naa nu, yquiaadiag zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Zeeṉe laa grë miech co zey, dzigo wbig xpëëdscuel me bnabdiidz zho lo me dieṉ pe nac ne sca niapse con cuent rseed me grë miech. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Pquiab me rëb me: ―Teḻ to, Dioszhal rlu lo to zha rnabey me, niicle ncuaaṉe mazdraa ngueetsa; laa grëraa miech ne gard gbig lo me, grieelod guieṉ zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sac zha ne noxcole dieṉ zha rnabey me, zdeedraa me guieḻbiini lo zho guieṉ zhow, laa zha ne noxcoda, miṉe rieṉse zho, stiche mew. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sca rseed naa zho parne tsoguic zho zha rnabey Dios, per nac zho niicle nzhial lo zho rwi zho, per peet raṉd zho; niicle nzhial diag zho per peet rond zho; ib peet rieṉd zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Lëë miṉe nac zho i bzeet Isá, zeeṉe znu rëb me: Nac miech qui, niicle peraa ron zho, per peet rieṉd zho; niicle rwiraa zho, per peet raṉd zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ne nlipaa miech nad, miech ndip zdoo nac zho, rrieequia ntse zho diag zho, ntse zho lo zho; parne peet gond zho, peet gaṉd zho. Ib rieṉd zho zha gbig zho lo naa, ygab zho xnëz naa, parne csilaa naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Saṉgue to ―rëb Jesús lo zho―. ¡Dichos to porne rieṉ to pe raṉ to, ni rieṉgaa to miṉe ron to! ");
INSERT INTO zpmNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Blactaa zha ne biadteed xtiidz Dios padzeela, blactaa zha ne güeynaḻ miṉe nac diidzli, bzoobladz zho niaṉ zho grë ncuaaṉe raṉ to niina, per bgaad zho niaṉ zhow; bzoobladz zho nquiaadiag zho grë ncuaaṉe noquiaadiag to, per bgaad zho nion zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Goḻquiaadiag sca gaṉle zha nac xcuent zha ne güey gon ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ro nëz ne sca bliaaḻ zhob co, sca nac palal miech ne riepaa zha ne rienee Xtiidz Dios lo zho, per rioguicd zhow, rlozh ga rdziṉaque meṉdox, rietiche ma teḻ palalse miṉe rieṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lad quie ne bliaaḻ spalal zhob co, sca nac grë zha ne rley rcaania Xtiidz Dios; ");
INSERT INTO zpmNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","per led dib zdood zho rcaania zhow, gane zeeṉe laa miech rsilo rlëë lo zho, laa miech rtsidiḻ zho porne rliladz zhow, rsaanga zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nogaa zho nac zig nac leṉ yag guiets co. Rquiaadiag zho Xtiidz Dios, per rsilo zho leḻ grë ncuaaṉe no lo guidzliu rii mazdraa rionie guic zho, rquidie grë dimi zho. Grë ncuaaṉ co rioxcoraa zho, laa ne tsonie Xtiidz Dios guic zho, miṉ co rquiaqui ib ruṉd zho miṉe rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Laa liu naaḻ ne bliaaḻ miṉe scataa goc ga, sca nac grë zha ne dib zdoo rquiaadiag Xtiidz Dios, rieṉ zho zha naca, ni rban zhow zigne rnabeya. Rrieequia grë ncuaaṉe ruṉ zho, no zho nac zig mzion ne briee gaḻptsii zhob ga, no zho nac zig miṉe briee tsoṉgaḻa, nogaa zho nac zig miṉe briee tib gayoow ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Biire pcaalsa miech lo me stib, dzigo psiloque me pseed me zho con stib cuent, rëb me: ―Ziaad gac xquieḻrnabey Dios lo guidzliu rii zig bzhaac tib meṉ ne gon zhobxtil. Niapse zhob wen, zhob nal gon me, ");
INSERT INTO zpmNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","per no tib zha ne rlëë lo me, goḻ tib pcow liu, horne grëse miech nixguies, güey zho güeylaaḻ zho xmidz guizh ncuaan zaatne gon me. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","’Zeeṉe laa zhobxtil co psilo blan mzion, hor coraa blu laa guizh ncuaan co no lada. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Grë zha ne quia xtsiiṉ me, zeeṉe goṉ zhow güey zho rëb zho lo me: “Tebaa gaṉ luu gaṉle, dipse lad xoob luu zëëb guizh ncuaan, ¿dieeṉ pa brieew gocbniw ga?” ");
INSERT INTO zpmNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Dzigo rëb me: “Rieṉ naa no cho tib zha ne rlëë lo naa, zha co beeṉ dziin co.” ’Gocladz zho, hor cogazh nielaadz zhow per bzhiguieḻd me, ");
INSERT INTO zpmNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","rëb me lo zho: “Tsielaadzde tow, sac teḻ glaadz tow niina ye zhobxtil gliaadzniew. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Goḻsaan sca zëëba ga, na zeeṉe laa wlaap gac, hor co gnabey naa zha ne quiits zhob, ctopgazh zhow gdziiṉ zhow tib lad tseca; lozhraa ga quiits zho zhob, tsasa ga, glansow ro yu.” ");
INSERT INTO zpmNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Blozh ga bzeet me midz moxtaz, rëb me: ―Nac xquieḻrnabey Dios zig nac tib midz moxtaz ne ran miech dan rii. Naṉ to gaṉle midz moxtaz nac midz ne mazdraa win, ");
INSERT INTO zpmNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ni teḻ gacbniw, rrooba ni lëëw rroobraa lo grë guizh ne ran zho ro yu, raca lal tib yag nex, haxta rdziṉ grë mguiṉ rzhixcuaa ma zhiptsieez ma lo grë zhicwa. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Rëbaque me: ―Nac xquieḻrnabey Dios zig nac ncobi ne rquiaa meṉ wnaa lad ncob ne riaa guietxtil. Niipaque ncobi riots tsoṉ lmud rin, ni dib nacse ncob co rzibe. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Grëse miṉe pseed Jesús grë miech co, niapse con cuent bnee mew lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ga brieequia miṉe bzeet zha ne biadteed xtiidz Dios padzeela, zeeṉe rëb zho: “Niapse con cuent cseed naa miech, sca gnee naa lo zho grëtaa ncuaaṉe gard gacnaṉ miech wlal ne bre guidzliu.” ");
INSERT INTO zpmNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Blozhse bnee Jesús lo grë miech co guey zho, yeque me laa me zey gza xpëëdscuel me. Bdziṉ zho ro yu, ga bnab zho lo me siguieḻ me gnee me lo zho dieṉ zha nac xcuent guizh ncuaan ne bzeet me ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Dzigo rëbchaa me lo zho: ―Goḻgona sca, znu goṉ nac cuent co. Rrieequia goṉ naa ga nac meṉ ne gon zhob co. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Liu ne bniaaw ga, nac lo guidzliu, zhobxtil co nac grë miech ne nole xnëz Dios, laa guizh ncuaan co nac grë zha ne no ladznia meṉdox. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Zha ne güeygan guizh ncuaan co, lëë meṉdox ga. Dze lo wlaap co, gac dze ne guṉ Dios xquieḻwxtis me, zha ne tsie wlaap ga, lëë anjl ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ni zigne sca cuee zho guizh ncuaan co lad zhobxtil, gzëëg zhow, scapaa nagoṉ gaḻ dze ne gac xquieḻwxtis Dios, ");
INSERT INTO zpmNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","sxeḻ naa grë xanjl naa tsie zho tsiebee zho grë zha ntseeb, zha ne sca ruṉctal xtoḻ grëraa miech, lad zha ne no xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","¡Grëse zha ntseeb co, hor co laa zho guey lo guidox ne rieguiaḻ zho! Ga tso zho goonnë zho, haxta gow lay zho lo guieḻnëdox co. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Laa grë zha ne güeynaḻ miṉe nac diidzli, zha co gdziṉ zaatne rnabey Pxoz naa, masaque zig xbiini ngbidz glu zho ga. ¡Zha ne racladz guieṉa yquiaadiag zhow! ");
INSERT INTO zpmNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Ziaad gac xquieḻrnabey Dios zig tib ncuaaṉ non ne noliu tib lo xcuaa miech. Zha ne gdziel tib ncuaaṉe sca non, ib tedsod zie zho sto zho grëse ncuaaṉe rap zho griee dimi si zho liu co, parne guṉcheṉ zho ncuaaṉ non co. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Zha ne rzëëb lo xquieḻrnabey Dios ziaad gac zho zig tib zha ne rzi quie perl miṉe mazdraa niazh. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Zeeṉe ron zho pa no tib perl co, rto zho grëse ncuaaṉe rap zho, rie zho rzi zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Nacaque xquieḻrnabey Dios, zig tib guiex nroob ne rgaa meḻ niina, zeeṉe rsëëb ngooz meḻa lo nis grë lose meḻ rtopa. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Rlozhse riodzëw, dzigo rbeequia zhow ro nis, garaa rzob zho rbe zho grë meḻ co; ma ne rquiin laa tib chicuid zole rio ma, laa ma ne rquiind rsëëb zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Scapaa nagoṉ gac miech gaḻ dze ne guṉ Dios xquieḻwxtis me, ziaad grë xanjl me cuee zho grë zha ntseeb lo zha ne no xnëz me, ");
INSERT INTO zpmNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tsieroṉ zho zho lo guidox ne rieguiaḻ zho. Ga tso zho goonnë zho, haxta gow lay zho lo guieḻnëdox co. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Blozhse ga, rëb me lo zho: ―¿Pe bieṉ to na zha nac grë miṉe blozh bne naa lo to nu? Grëse zho pquiab rëb zho: ―Bieṉ now. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Dzigo rëbchaa me: ―Tib zha ne rieṉle zha nac grë ley ne psaṉ Moisés, ni squi guieṉ zho zha nac zhiwseed Dios miṉe ziaḻnie naa niina, masaque nac zho zig tib zha gol ne quianie chop lo ncuaaṉ non lidz zho, quianie zho grë miṉ gol-le ni quianiequegaa zho miṉ cub. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Blozhse sca bzodiidz me grë cuent co lo zho, laa me briee ga zie me nëz ladz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bdziṉ me ga güey me yadoo, psilo me pseed me grë miech co. Per nli rzee zdoo zho ron zho grë miṉe rnee me, rnabdiidzlsa zho rnee zho: ―¿Pazhe waa squitaa pseed meṉ qui? ¿Zha nac guieḻbiini ne squitaa rap me i, ne rnee miech ndal grë milagr ne ruṉ me? ");
INSERT INTO zpmNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tib zhinse ngurëëyag name nac me. Led lëë xingan Marí i, bets me name nac Jacob, nac José, nac Simón ni Judas; ");
INSERT INTO zpmNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","grë bzian mew, nu no zho grë zho. ¿Pa dzigo güey me wseed qui? ");
INSERT INTO zpmNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ib beeṉcasd zho me, haxta rlëë zho lo me. Zeeṉe goṉ me sca rac zho, rëbchaa me lo zho: ―Zha ne rteed xtiidz Dios, mazd wen rnee miech lo zho stib dan, stib guiedz, lëdle ladz zho ni meṉlidz zho ni meṉladz zho nëd guṉbey zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Beeṉd me nzian milagr ga, sac sca ndip zdoo grë miech co ib nëd zho nliladz zho cho nac me. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Leṉ dze co bin rey Herod (meṉ ne rnabey Galilé) grë ncuaaṉe ruṉ Jesús, sac teḻ pa lotaaw zëëb xtiidz me; ");
INSERT INTO zpmNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","dzigo rëb Herod lo grë zha ne ruṉ dziin lo me: ―Rieṉ naa lëë Juan Bautist ga quiayuṉ grë miṉ co, segur brieeban me. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Sca rnee Herod sac naṉwen me zha beeṉ me Juan. Me bnabey bgaa Juan bzoob zho Juan caden bio Juan ladzguiib, ");
INSERT INTO zpmNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","loxaque ne rnee Juan lo me nonguieḻda ga lëëque Herodí ptsieelnia me, sac tsieelpaa bets me Lip nac Herodí. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gocladz Herod niut me Juan, per bdzieb me meṉguiedz, sac rleynie zho Juan, rieṉ zho xtiidz Dios ziadteed Juan lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Laa tibtaa dzew, lëëtaque noyac zhilni Herod dze ne bloozh me stib iz, bded tib xindzoop Herodí squi ndxie grë zha ne zobnie me psilo ndzoop biee ndzoop. Bdziladz me goṉ me zha biee ndzoop, ");
INSERT INTO zpmNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","haxta briee ro me rëb me: “Ncuaaṉe gacladztaa luu gnab luu, znedz naaw.” ");
INSERT INTO zpmNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Per glole pquiil Herodí ndzoop, nacne rëb ndzoop lo me: “Miṉe racladz naa, xoob guic Juan tib leṉ bandej gneedz luuw lo naa niinagazh.” ");
INSERT INTO zpmNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Zeeṉe bin Herod sca rëb ndzoop, mbanse rac me; per rdeetraaw diidz niab me grieeloda, sac grëse zha ne zobnie me ga, bin zho rëb me zdeed me ncuaaṉe gnabtaa ndzoop. Dzigo racse me pxeeḻ me zha ne güeychug guic Juan leṉ ladzguiib. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Zeeṉe wbire zho, zhoobse guic Juan tib leṉ bandej bdeed zhow lo ndzoop, dzigo güey ndzoop güeydeed ndzoopa lo xniaa ndzoop. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zeeṉe gocnaṉ xpëëdscuel Juana, güey zho güeylis zho me ga güeyqueets zho me. Blozh ga güeyzodiidz zho lo Jesús zha bzhaac me. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Zeeṉe bin Jesús sca bzhaac Juan, dzigo briee me ga bzëëb me barcw zie me tib zaatne guieṉd miech. Per znuse bieṉ diidza, nzian grë guiedz co zha ne gocnaṉa, tib ro nis güey zho, glole zho bdziṉ zaatne no gdziṉ me ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Laa me noyet leṉ barcw, zeeṉe blis lo me goṉ me laa grë miech guizhiu co ndxiele ga; pquia zdoo me zho, beeṉguiac me grë mguidz ne zienie zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Laa dze ziedzelew, wbig xpëëdscuel me rëb zho lo me: ―Mazd gudz lo grë miech qui guey zho na, zeeṉa guiob tsie zho grë guiedz win ne ndxie gax i tsiesi zho ncuaaṉe gow zho; sac goṉ laa dze bdzele. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pquiab me rëb me lo zho: ―¿Pe nacne guey zho squise? To none gdeed ncuaaṉe gow zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Rëbchaa zho: ―¿Per pe dieṉ yguiaaṉ no zho? Pe rnase gaay guietxtil ni chop meḻ ne ziaadnie no nu, lo grëtaa miech qui. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Dzigo bnabey me zho güeynie zho guietxtil co, güeynie zho meḻ co lo me, ");
INSERT INTO zpmNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ni bnabey me grë miech co bzob zho lo grë guizh nguia ne zëëb ga. Horco bzheṉ me gza guietxtil co ni grop meḻ co, blis lo me nëz gbaa, bdeed me xquizh lo Dios. Blozhse bdeed me xquizh, beeṉgroḻ me gza guietxtil co, meḻ co ne, zigse rdeed mew lo xpëëdscuel me scase scase bdiiz zhow lo grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","Grëse zho dow zho haxta zaatne bieltaa zdoo zho. Miech tafa, zha bguise rgaa zig gaay mil, naṉdragaa grë meṉ wnaa, grë mëëdlas; ni zeeṉe blozh dow zho, scase ncuaaṉe nroob biaaṉ, biodzë tsiipchop chicuid bio grë guietxtil co, bio grë meḻ co. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Zeeṉe blozh ga, bnabey Jesús xpëëdscuel me bzëëb zho leṉ barcw, zeeṉa zienerga zho tedquia zho stib nëz ro nis co; laa me bii blëz ga, nozonëz me grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Blozhse bzonëz me zho, dzigo güey me tib guic gui zob gax ga, güeyzodiidznie me Dios, tipse me zo ga laa liu pcow. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Horco laa barcw ne zie xpëëdscuel me ga no lo nis co, ib gacd csëëniob zhow, sac rriee me rtsire mew, nëzrii nëzrec raca lo nis. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Merle guini liuw, tibaque zeeṉe laa me bdziṉ zaatne zie zho ga, tib lo nis co ziezë me. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Zeeṉe goṉ zho laa meṉ co sca ziaad-zë lo nis co, bdzieb zho, broptsie zho rnee zho: ―¡Tib ndziin i goṉ ziaad i! ");
INSERT INTO zpmNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dzigo bnee me lo zho rëb me: ―¡Gdziebde to, naa ziaḻ nu! ");
INSERT INTO zpmNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","29","Pquiab Pedr rëb Pedr: ―Teḻne luu i ziaad i, bneedz diidz së naa lo nis glanso naa lo luu i. ―¡Dë sca! ―rëb me. Lëëlëd biet Pedr leṉ barcw, laa Pedr ziezële lo nis co ");
INSERT INTO zpmNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","zeeṉe goṉ Pedr scataa rlis me low, bdzieb Pedr. Tibaque zeeṉe bieṉ Pedr laa Pedr nodedquiele low, hor co broptsiedan Pedr, rbedz Pedr me, tsiebee me Pedr ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Dzigo wbig me bzheṉ me nia Pedr, bzoli me Pedr lo nis co. ―¡Aque luu goṉ Pedr! ―rëb me―. ¿Pe nacne gocchop guic luu? ¿Gard goṉ gliladz wen luu cho nac naa? ");
INSERT INTO zpmNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Zeeṉe laa me biepnie Pedr leṉ barcw, laa me co blëz. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Grëraa zha ne no leṉ barcw ga, rleynie zho me, rzee zdoo zho rnee zho: ―¡Nasi nagoṉ ndioṉ no nli Xpëëd Dios nac luu! ");
INSERT INTO zpmNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Zeeṉe bdziṉ zho stib nëz ro nis co, zaatne rnee zho Genesaret, ga biet zho barcw. ");
INSERT INTO zpmNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Grë miech co zeeṉe gocnaṉ zho laa me bdziṉ ga, znuse znuse pxooṉ zho diidz grëraa guiedz ne ndxie gax ga. Dzigo briee grë miech co, güeynie zho grë meṉ rzacnë lo me, ");
INSERT INTO zpmNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","rnab zho lo me siguieḻ me maase ni xabse me xeṉ grë meṉ rzacnë co. Grëse zha ne bzheṉ ni xab me, biac zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tib dze, bdziṉ bla zha farisé ni zla maistr ley ne ziaad nëz Jerusalén, lo Jesús; rëb zho lo me: ");
INSERT INTO zpmNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Pe nacne dieṉ zienaḻd xpëëdscuel luu miṉe blu xmeṉgol ne, pe nacne zeeṉe laa zho row, ib rguiibd zho nia zho zigne nopaa tsara? ");
INSERT INTO zpmNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pquiab me rëb me lo zho: ―¿To waa, pe nacne quiaguiits to xley Dios? Goḻguieṉ gaṉle laa ne guṉ to miṉe rnabey Dios zigne naca, leḻ ncuaaṉe blu xmeṉgol to, miṉ co zienaḻ to. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Led znu goṉ rnee lo xley Dios: “Goṉ pxoz luu, goṉ xniaa luu”, ni rneew: “Zha ne quie pxoz, quiegaa zho xniaa zho, ib none guet zho.” ");
INSERT INTO zpmNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Laa to goṉ rnee to: “Peet nacda guṉd zho xyudar xmeṉgol zho niicle no me liaadz, totsaque gdeed zho gon.” ");
INSERT INTO zpmNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tib lad rsaṉ to xley Dios, miṉe blu xmeṉgol to miṉ co noxcoraa to. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Loxaque guieḻwquidie qui no to! Rquiaalo to miech wen nac to, per lëëpaa miṉe ruṉ to i ga bzeet Isá zeeṉe rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Grë miech rii, rquiaalose zho ruṉnon zho naa, rond zho diidz guṉ zho miṉe rnabey naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Zhlëse nac grë ncuaaṉe ruṉ zho, rnee zho laa zho riaadgaṉ naa; sac niapse guicle zho riab grë wseed ne quialu zho lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dzigo bnee me lo grë miech ne ndxie lo me ga, rëb me: ―Goḻquiaadiag miṉe gni naa lo to nu, ni goḻtsoxco guieṉ to zha naca. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Goḻgacnaṉ gaṉle, grë ncuaaṉe rdziṉ zdoo miech, led miṉcod ruṉctal xtoḻ zho; sinque grë ncuaaṉ ntseeb ne rza guic zho, diidz ntseeb ne rriee ro zho, miṉ co ruṉctal xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Horco wbig xpëëdscuel me, rëb zho: ―¿Pe bieṉ luu gaṉle blëë zha farisé goṉ zho sca rëb luu lo zho? ");
INSERT INTO zpmNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pquiab me rëb me: ―Grëse yag ne squi beeṉbnid Pxoz naa meṉ ne zob gbaa, ib none laaw gliaadz zolo zolow. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Goḻsaan zho, nli zha noseed miech per nac zho zig nac zha ne roḻd lo. Ni naṉle to gaṉle, teḻ tib zha ne sca roḻdle lo ni xeṉaque zho nia stib zha ne raṉd, zaatne nac tib leṉ blë, ib tedsod grop xcuaa zho tsietsobe ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bdedse ga, wbig Pedr lo me rëb Pedr: ―Bzhiguieḻ bnë lo no dieṉ zha nac diidz ne në luu ga, ne rnee luu led ncuaaṉe rowd miech ruṉctal xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Pquiab me rëb me: ―¿Pe niicle to rieṉdaquew dzigo lëë? ");
INSERT INTO zpmNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Pe rieṉde to grë ncuaaṉe row miech, led miṉcod ruṉctal xtoḻ zho? Sac grë ncuaaṉe row zho rdziṉda leṉ zdoomban zho, zhaa zaatne rdziṉa; tib rietedsew xcuerp zho, rlozh ga rrieegaw. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Saṉgue grë diidznë ne rriee ro zho, zdoomban zho ga rzaw, ni lëë miṉ co nac miṉe ruṉctal xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Zdoomban zho nac zaatne rza grë ncuaaṉ ntseeb ne ruṉ zho, zig nac: zeeṉe rio zho grë zhgab yozh, zeeṉe rut zho samiech zho, zeeṉe rionie zho zha ne nole tsieel, zeeṉe rionie zho zha ne nacd tsieel zho, zeeṉe ruṉ zho guieḻgbaan, zeeṉe lega rnexuu zho samiech zho, zeeṉe rneenë zho samiech zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Grë ncuaaṉ ntseeb co nagoṉ nac miṉe ruṉctal xtoḻ miech, guṉctald zho xtoḻ zho niicle tsard nia zho zigne nacpaa grë zhiwseed meṉgol. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ga briee Jesús, güey me haxta nëz Tiro ni nëz Sidón. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nëz co no me güey tib wnaa ne ziaad lo xtii zha Canaán lo me, nguiedz zëëb tsi wnaa co rnab me lo Jesús siguieḻ Jesús tsieguṉguiac tib xpëdwnaa me nosacsi meṉdox. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per ib pquiabd Jesús lo xtiidz wnaa co, dzigo wbig xpëëdscuel me, rëb zho: ―Mazd bzhiguieḻ pquiaadiag miṉe rnee wnaa qui, bui gaṉle zha ncuëtaa zëëb tsi me naḻ me zhits ne. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pquiab Jesús rëb me: ―Ziaḻd naa par guṉ naa xyudar zha zit, sinque laa Pxoz naa pxeeḻ naa par guṉ naa xyudar grë zha Israel ne rzac zig grë mëcwxiil ne zonziaab lo xbaxtor. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Scaque nonee me laa wnaa co wbig pquiitsgzhib lo me. ―Bzhiguieḻ ―rëb me―, beeṉ tib guieḻnzaac beeṉ xyudar naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Rëbchaa Jesús lo me: ―Nonguieḻda goṉ, cob ne guiet ne no nia mëëd gdeed new lo mëcw. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","―Nliw, scaw ―pquiab wnaa co―, per niicle mëcwa name rsaanaque bizhuan ma rbig ma row ma miṉe rrieengaa nia mëëd. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Horco pquiab Jesús rëb me: ―¡Squiw nagoṉ! ¡Rlu nli dib zdoo luu rnalo luu naa! Gacxe waa miṉe rnab luu i guṉ naa, niinagazh laaw gac. Horcogazh biac xpëëd wnaa co. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nëz co wbi Jesús bdziṉ me ro Nisdoo Galilé. Ro nis co no me, miech guizhiu ne pcaalsa lo me. Tib dze goṉ me scataa nzian miech co, dzigo güey me güeysob me tib guic gui win zob gax ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ga zob me rdziṉ grë miech co rdziṉnie zho grë zhimguidz zho lo me, no zho zienie grë zha ne në ni, no zho zienie grë zha ne roḻd lo, grë zha ne guieṉd tib nia, grë zha ne guieṉd tib ni, grë zha ngop, ni grëragaa zha ne rlan pe stib guieḻguidz; grëse zho beeṉguiac me. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","¡Ncuaaṉe gzee zdoo ne goc ga! Grë zha ne ni tib diidz gard gnee, per nli rley zho laa zho psilo rnee; grë zha ne guieṉd tib ni, guieṉd tib nia, laa ni zho laa nia zho biaaṉ zigne no gaca; grë zha ne rgob ni, haxta rias zho laa ni zho goc-wen; grë zha ne roḻd lo, rlozhd gzee zdoo zho grë ncuaaṉe raṉ zho. Grëse miech ne ndxie ga, rzee zdoo zho, rley zho rooḻnie zho Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Dzigo bredz me xpëëdscuel me rëb me lo zho: ―Rquia zdoo naa grë miech rii. Nadzele rac tsoṉ ngbidz blanso zho lo ne nu, ni na quianiedraa zho pe gow zho. Teḻne squise gzonëz naa zho, nend pa lo zie zho nëz ycow zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pquiab zho rëb zho: ―¿Per pe yguiaaṉ ne zho? ¿Pa guioxi ne guieḻwagw ne yquiin grëtaa miech qui dan rii, naca zaatne guieṉd miech? ");
INSERT INTO zpmNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Dzigo bnabdiidz me lo zho, rëb me: ―¿Bla guietxtil ziaadnie to i? ―Gadzaquew no ―rëb zho―, ni chop tsoṉ meḻ win. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","Dzigo bnabey me grëse miech co bzob zho lo liu. Blozh bzheṉ me gza gadz guietxtil co, ni gza meḻ co, bdeed me xquizh lo Dios; blozhse bdeed me xquizh, zigse ruṉgroḻ me guietxtil co scase scase rdeed mew lo xpëëdscuel me rguiiz zhow lo grë miech co; scaque beeṉ me gza meḻ co. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Grëse miech co dow zho haxta zaatne bieltaa zdoo zho. Miech guizhiuw, zha bguise rgaa zho maase tap mil, naṉdragaa grë meṉ wnaa, grë mëëdlas; ni zeeṉe blozh ga bii biodzë gadz chicuid bio grë miṉe biaaṉ. ");
INSERT INTO zpmNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Blozhse bnee me lo grë miech co, blozhse bzonëz me zho, dzigo laa me bzëëb leṉ barcw zie ne nëz xtan zha Magdal. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Magdal no Jesús, bdziṉ bla zha farisé ni zla zha saducé lo me, gocladz zho niuṉgüet zho me dieṉ pe nxiṉd me tib diidz, pe tib ncuaaṉe nonguieḻdgaa niuṉ me. Rquiaalo zho rnab zho lo me guṉ me pe tib milagr, zeeṉa gliladz zho nli Dios pxeeḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Dzigo pquiab me rëb me lo zho: ―¡Pe nlipaa rnee to rieṉde to zha nac grë ncuaaṉe noyac leṉ dze rii! Zha zëëb dzigo ruṉbey to pe rlu lo xcow. Zeeṉe raṉ to rquia xcow nizhnie bdze dze, rieṉle to guiet stib dze co zriee lo ngbidz. Sil ne raṉgaa to quia xcow nizhnie, quia xcow nlaan zhan gbaa, rieṉle to guiexoo guiab dze co. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nazdpaa ntseeb to, squitaa gocndip zdoo to nëz lo Dios, ¿zha rnaraa milagr ne racladz to gaṉ to? Stibaque milagr goṉ gaṉ to, tib miṉe gac zigne bzhaac Jonás. Blozhse sca rëb me lo zho, zoque zho ga, ziega me. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Zeeṉe briee zho ga, zoladzd xpëëdscuel me ney zho guietxtil ne niow zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Lega nacle psilo me nonee me lo zho, rëb me: ―Goḻguieṉ goṉ, napaa noyab to lo zhincobi zha farisé, lo zhincobigaa zha saducé. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Zeeṉe goṉ zho sca rëb me, rneechaa zho: ―Porne nagoṉ ziaadnied ne guietxtil, gane squi rnee me lo ne. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Bieṉ me sca nonee zho, dzigo rëb me lo zho: ―¡Gardaque lëë guieṉ to cho nac naa! ¿Pe nacne tso to zhizhgab guietxtil? ");
INSERT INTO zpmNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¡Ni lalnu lëë peet rieṉde to! ¿Pe rsoladzde to zeeṉe gaayaque guietxtil bguiaaṉ ne gaay mil miech, bla chicuida biaaṉ? ");
INSERT INTO zpmNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Scaque zeeṉe gadzaque guietxtil ni bgaaw dow tap mil miech, ¿pe niicle miṉ co rsoladzdraa to? ");
INSERT INTO zpmNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Zha nac dzigo rzac to guietxtil nozet naa? Goḻguieṉ gaṉle zhincobi zha farisé, zhincobi zha saducé ni naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dzigoraa bieṉ zho led ncobidpaa rzeet me, sinque rëb me lo zho gap zho cuidad lo zhiwseed zha farisé, lo zhiwseedgaa zha saducé. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Bdziṉ Jesús nëz xtan zha Cesarea de Filipo grë xpëëdscuel me, nëz co no me bnabdiidz me lo zho rëb me: ―¿Cho dieṉ ron to rnee miech nac naa? ");
INSERT INTO zpmNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pquiab zho rëb zho: ―No zho rnee Juan Bautista, no zho rnee Líw, no zho rnee Jeremíw, meṉ ne biadteed xtiidz Dios padzeela; nogaa zho rnee no cho stib meṉ ne ziadteed xtiidz Diosa zig biaad zha ne biaad padzeela. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dzigo rëb me lo zho: ―¿To waa? ¿Cho rzac to nac naa? ");
INSERT INTO zpmNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pquiab Pedr, rëb Pedr: ―¡Luu nac Meṉ ne zëëble diidz ga cxeeḻ Dios! ¡Xpëëd Dios nac luu! ");
INSERT INTO zpmNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dzigo rëbchaa me: ―Dichos luu Simón (xingan Jonás) briee diidz qui ro luu, sac goṉ Pxoz naa meṉ ne no gbaa, meṉ co bneedz guieḻbiini qui lo luu, nacda ncuaaṉe cho miech nëw lo luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ye naa goṉ niina laa naa gni gaṉle cho nac luu, luu nac zig tib quie, ni quie ne goṉ squi nac gzhixcuaa naa xyadoo naa; tsod zha ne grieelo gnitlo yadoo co, per ni guieḻgut gnitloda. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Laa naa rzo luu, luu gnee Xtidz naa lo miech zeeṉa gacnaṉ zho zha grieelo ygaa zho zaatne rnabey Dios; luu gac zig tib zha ne rey liow, teḻ zha cow, zha zac cxal ro yu, ni zha zac csiooga. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dzigo pso me diidz lo zho choot lo gneed zho, me nac Meṉ ne zëëble diidz ga cxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Leṉ dze co psilo Jesús bzeet me lo xpëëdscuel me zha csacsi miech me. Rëb me nroob ncuaaṉe cteed zho me, zeeṉe laa me tsie Jerusalén; grë zha non lo meṉguiedz, grë pxoz ne rnabey, grë maistr ley, ible stsidiḻ zho me ni haxta zut zho me; per zeeṉe gac tsoṉ ngbidz gut me, laa me grieeban. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Goṉ Pedr zha rnee me, dzigo bredzaque Pedr me blisqui Pedr lo me dieṉ pe nacne rnee me laa me guet. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Zeeṉe bin mew, zoque Pedr ga, biecw me rëb me: ―¡Biche lo naa nu meṉdox! ¡Loxaque no luu par guṉgüet luu naa! Zienied guic luu miṉe rnabey Dios, sinque miṉe rleynie miech, miṉ co zienie guic luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dzigo bnee me lo zho, rëb me: ―Zha ne racladz sëëb xnëz naa, none cueeladz zho zho, none lëb zho guiaadnaḻ zho miṉe rnabey naa, niicle teḻ miṉ co yquiaaqui csacsi miech zho. Nodne yquia zdoo zho xquieḻmban zho, ");
INSERT INTO zpmNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","sac zha ne yquia zdoo xquieḻmban, leḻ znu nitlo zho; saṉgue zha ne sca cueeladz xquieḻmban porne no zho xnëz naa, ib zgaa zho tib guieḻmban ndzon ne gdziṉd dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Zha ne zienie guic loxaque gapcheṉ, ¿pa dieṉ yquiina lo zho, teḻ lëëw yquiaaqui guey zho gabiḻ? ¿Niacxe zrieelo gdziib zho dimi, laa zho leṉ gabiḻ? ");
INSERT INTO zpmNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Naa ne nac naa Mgui ne pxeeḻ Dios, zdziṉ dze ne gbiire guiaḻ naa stib, guiaḻnie naa grë xanjl naa, glu naa gaṉle pa lotaa meṉ nroob nac Pxoz naa; dze co gded naa miṉe tsieguiaḻ tib tib miech, teḻ zha wban zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ib tedsod lo grë zha ne ndxie nu niina, bii no zha ne gaṉ gaṉle, zeeṉe laa naa csilo gnabey lo guidzliu rii. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Goca xoop ngbidz, bredz Jesús Pedr, Jacob ni Juan bets Jacob güeynie me zho tib guic gui glaa. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Guic gui co no zho, zeeṉe goṉ zho laa me bdzëëlo. Masaque biinidoo rriee lo me, pale lo ngbidz; xab mew, per nli rquiabniw, masaque biini ne rroṉa. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tibaque zeeṉe goṉ zho laa Moisés ni Lí meṉ ne biadteed xtiidz Dios padzeela, nozodiidznie me. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Rdzieb zho, lo dzeb co briee ro Pedr rëb Pedr: ―Maestro, ¡tebaa zha grieelo guiaaṉ ne nu! Teḻne racladz luu, na maase gzaa no tsoṉ yu yag xiid nu, tiba cuëz luu, tiba cuëz Moisés, stiba cuëz Lí. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Scaque nonee Pedr, zeeṉe znuse pquia tib xcow ngali zaatne zo zho ga, masaque biini ne rroṉ xcow co, lo xcow co bin zho zëëb tsi tib meṉ co, rnee me: ―Lëë xpëëd naa i goṉ, rleynie naa me, rzac zdoo naa miṉe quiayuṉ me. Miṉe rnee me, goḻgona. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mazdraa bdzieb zho bin zho sca rnee meṉ co, lëëlëd pquiitsgzhib zho haxta bdziṉ lo zho lo liu. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dzigo wbig Jesús, pcaaṉnia me zho, rëb me: ―Goḻsoli, gdziebde to. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Zeeṉe blis lo zho bui zho, mese zo ga, goṉdraa zho schop meṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Blozhse ga, laa zho wbi ga. Cho gui co ziad-zëëbnie me zho, pso me diidz lo zho miṉe goṉ zho ga, choot lo gzodiidzd zhow, nieeda gaḻ dze ne laa me brieeban. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dzigo bnabdiidz zho lo me, rëb zho: ―¿Bay zha nacne rnee maistr ley, glo Lí no guiaad stib, dzigoraa guiaad Meṉ ne zëëble diidz ga cxeeḻ Dios? ");
INSERT INTO zpmNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Rëbchaa me: ―Nliw, ible nacle diidz ne glo Lí guiadseed miech gon zho xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ni gacnaṉ to gaṉle laa me biaadle, per beeṉbeyd miech me, leḻ psacsi zho me beeṉ zho me miṉe gocladztaa zho; ni ib tedsod goṉ, scaque csacsi zho Mgui ne pxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Zeeṉe blozh sca rëb me, dzigo bieṉ zho Juan Bautist ga rzeet me. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Zeeṉe blozh biet zho cho gui co, goṉ zho miech guizhiu ndxie ga quiambëz Jesús. Lad co briee tib mgui, wbig me lo Jesús, pquiitsgzhib me lo Jesús, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Laa naa rnab lo luu, bzhiguieḻ beeṉguiac xpëëd naa, nrooble nosacsi guidz gutye win. Blactaa ziyobe win lo gui, ziyobe win lo nis ne. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Blansonie naa win lo xpëëdscuel luu nu, per rrieelod zho guṉguiac zho win. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dzigo rëbchaa Jesús lo xpëëdscuel me: ―¡Pe na squitaa miech ntseeb nac to, ib nëde to gnalo to Dios! ¿Palal tiemp ne so naa gne naa lo to? ¡Ncuaaṉe cxecwdraa naa lo to squi nac to! ¡Goḻtënie mëëd qui nu! ");
INSERT INTO zpmNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dzigo goctox Jesús lo meṉdox ne nosacsi mëëd co, beṉcxooṉ me ma, hor cogazh laa mëëd co biac. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Haxta wbiraa zho ga, wbig zho lo me bnabdiidz zho dieṉ pe nacne brieelod zho niuṉcxooṉ zho meṉdox ne nosacsi mëëd co. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Dzigo rëbchaa me: ―Brieelode to niuṉcxooṉ to ma, sacne rnalode to Dios. Teḻ niaca miṉe rnalole to Dios siquier palal yeeṉ, gzoob ne siquier lal tib midz moxtaz, niicxe ncuaaṉe mazdraa ngaṉ gnab to lo me, zuṉ mew; tsod ncuaaṉe grieelod guṉ to. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Xtan zha Galilé no zho, tib dzew rëb me lo zho: ―Naa ne nac Mgui ne pxeeḻ Dios, ib znaaz miech naa, ");
INSERT INTO zpmNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","haxta zut zho naa; per zeeṉe gac tsoṉ ngbidz gut naa, zriebaan naa. Zeeṉe bin zho sca rnee me, bio zho guieḻnë, mbanse rac zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Bdziṉ me guiedz Capernaum, loxaque bzëëb me lad guiedz, laa zha ne rtop dimi ne razh yadoo wbigle lo Pedr, bnabdiidz zho dieṉ pe rguizh me dimi co. Pquiab Pedr rëb Pedr lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","―Rguizh mew, ¿pe nacne quizhd mew? Zeeṉe bdziṉ zho leṉ yu ne rbëz me, gardle guiab Pedra lo me, glole me bnabdiidz rëb me lo Pedr: ―Zig nac dimi ne razh lo meṉ ne nac rey dieṉ, ¿pe ye xpëëd me rguizha, te loxaque zha zit rguizha ye? ");
INSERT INTO zpmNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pquiab Pedr rëb Pedr: ―Zha zitse rguizha. ―Nligaa sca naca ―rëb Jesús―. Zha ne nac mëëd nodne quizh zho, ");
INSERT INTO zpmNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","per par guiabd zho rdziond ne diidz, güey güeyroṉ xanzuel luu lo nis. Meḻ ne glopaa ygaa low, bzheṉ ma pxal ro ma, ga gdziel luu dimi; dimi co güeynie bdiizh miṉe no dizh ne grop ne. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Leṉ dze co bnabdiidz xpëëdscuel Jesús lo me, dieṉ cho tib zho gac zha ne mazdraa gacnon lo grë zha ne no xnëz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dzigo bredz me tib mëëdbgui win, bzo me win glowtaa lo zho, ");
INSERT INTO zpmNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","rëb me: ―Gneli naa lo to gaṉle, teḻne csaande to xquieḻntseeb to, teḻne gacnguudzladzde to, gac to zig mëëdwin rii, per ni xnëz Dios grieelod sëëb to. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Zha ne racladz gac zho zha non, none gac zho tib miech ndooladz, none gac zho zig tib mëëdlas. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Miech ne gacnie zha ne sca nac, zha ne rleynie naa, rrieequia naale ga racnie zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Per miech ne yquiil zho guṉctal zho xtoḻ zho, ¡probsaxe zha co! Mazd zhi guieḻnëw lo zho ygadoo tib quie molin zhobxtil yaṉ zho tsieroṉ zho zho nisdoo. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Nac lo guidzliu rii, ruṉfalte guieḻntseeb low! Ruṉfalte ncuaaṉe guṉctal xtoḻ miech, ¡per probsaxe zha ne yquiil zha ne nole xnëz naa, guṉctal zho xtoḻ zho! ");
INSERT INTO zpmNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Goḻguieṉ teḻne tib nia to, tib nigaa to rquiaqui ruṉctal to xtoḻ to, goḻtichegazha. Peet nacda maase tibaque ni to, tibaque nia to zob totsaque ygaa to guieḻmban ndzon ne gdziṉd dze lozh, lëdle zob gropa ni laa to guey gabiḻ, lo beldox ne gdziṉd dze guiuu. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Scaque bziaalo to, miṉe rquiaqui ruṉctal to xtoḻ to, goḻtichegazha, peet nacd maase tibaque lo to zob totsaque ygaa to guieḻmban ndzon ne gdziṉd dze lozh, lëdle zob gropa ni laa to guey lo beldox ne nac gabiḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ib guṉde to csaṉwin to grëraa zha ne no xnëz naa, zha ne nac zha mban, sac goṉ non zho lo Dios, anjl ne quianap zho, tibaque zo me lo Pxoz naa meṉ ne zob gbaa. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","’Nziuu miech lo Dios, teḻ naa ne nac naa Mgui ne pxeeḻ me, ib laa naa ziaḻ ziaḻsilaa naa grë zha ne zonziaab lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Rzac Dios miech zig tib meṉ ne rquianë zdoo xpëcwxiil. Teḻne quianie zho tib gayoo ma, ni gziaab tib ma, led zëëb lëë rsaṉ zho stapgaḻ tsiimtap ma ne zo lo zho, rbire zho rieguib zho ma ne bziaab ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Zeeṉe rdziel ma lo zho, rlozhd gleynie zho ma, lëë ma rac guieḻbley que grëraa xcompañer ma. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Scadaa nagoṉ rzac Pxoz naa miech, grë zha ne nole xnëz me, ib racladzd me gziaab zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Goḻguieṉ sca, tib tib to zeeṉe cho tib zha ne nacgrë to guṉ pe tib falt lo to, goḻtsie goḻtsienee lo zho; gropse to goḻzodiidz pe nac miṉe pxiṉ zho. Teḻne siguieḻ zho guiaaṉ to mpas, laa to beeṉle gan ga gneewen to stib. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Laa teḻne nëd zho, dzigo goḻguib tib zha ne së, chopgaa zha ne së gaṉ gaṉle zha rac zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Teḻ niicle scaw nëdaque zho guiaaṉ to mpas, dzigo mazd goḻguiab lo grëse zha ne nacgrë to gnee zho lo zho. Teḻne niicle xtiidz zha co nëd zho gon zho, dzigotaa mazd goḻsaan zho, sacdraa to bets to ga, goḻcuee zho lad to, goḻsac zho zig rzac miech grë zha ne zienaḻ guieḻntseeb. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Gneli naa lo to gaṉle, grëse zha ne gon xtiidz to zeeṉe rnee to lo zho gac-wen zho, scagaa Dios scaania me zho; per zha ne gonda, ycaaniad me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ni racladz naa gacnaṉ to gaṉle, grë zha ne no xnëz naa, niicle tib nëzaque zho, per teḻne tipse rac zho, ncuaaṉe gnabtaa zho lo Pxoz naa meṉ ne zob gbaa, zdeed mew. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sac zeeṉe rcaalsa zho rooḻnie zho naa, ga zo naa lo zho; niicle maase chopaque, tsoṉaque zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dzigo wbig Pedr rëb Pedr lo me: ―Zha ne sca dzigo guṉ falt lo naa, ¿blataa vuelt no guṉ naa zho perdon? ¿Gadztaaw lëë? ");
INSERT INTO zpmNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Pquiab me rëb me: ―Lëda goṉ Pedr, led loxaque gadzdse vuelta. Teḻ blataa vuelt guṉ zho falt lo luu, none guṉ luu zho perdon. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Grë zha ne no xnëz Dios, ib none guṉ zho perdon samiech zho. ’Tib rey name, tib dzew bredz me grë zha ne rquia dziin lo me, par dieṉ zha quiayuṉ zho dziin. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Loxaque psilo me, zeeṉe laa xcuent tib zha co blozh briee, nroob brieequia zho lo me; ");
INSERT INTO zpmNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","par quizh zhow, peet nzheṉd zho. Dzigo bnabey me to zho grop tsieel zho, xpëëd zho ne, ni grëse ncuaaṉe rap zho, parne grieelo gazh xquieḻqui zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Zeeṉe goṉ zho sca rëb me, pquiitsgzhib zho lo me, rëb zho: “¡Beeṉ guieḻnzaac, gop tib paciens, na dieṉ zha guṉ naa quizh naa xquieḻqui naa lo luu!” ");
INSERT INTO zpmNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Goṉ me zha rac zho, pquia zdoo me zho, psilaa me zho, beeṉquizhdaque me zho xquieḻqui zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Loxaque briee zho ga, bdzieel zho tib zha ne nzëëb palal yeeṉ dimi lo zho, tib zha ne rquiaque xtsiiṉ rey cow. Zigne goṉ zho zha co, zolinëz wbig zho bdie zho yaṉ zho, rnab zho gagazh quizh zho xtimi zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dzigo pquiitsgzhib zha co lo zho, rnab zho siguieḻ zho gap zho paciens, dieṉ zha gaclo dimi co quizh zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pe nquiaadiag zho ga, bnab zho bio zha co ladzguiib, haxta bdiizh zho dimi ne zëëb zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Grëraa zha ne rquia dziin lo rey co, zeeṉ gocnaṉ zhow, bdeednë zho, güey zho güeyzodiidz zhow lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Zeeṉe bin mew, bnabey me gocredz zho, goctox me lo zho rëb me: “¡Pe clas miech nac luu! Pe rsoladzd luu zha rac luu bnab luu pquia zdoo naa luu, haxta beeṉquizhd naa luu guieḻquidox ne zëëb luu ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Pe nacne pquiad zdoo luu zha co, zigne pquia zdoo naa luu?” ");
INSERT INTO zpmNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Blëë me goṉ me sca beeṉ zho, bnabey me bio zho ladzguiib, haxta blozh bdiizh zho grëse xquieḻqui zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Scadaa nagoṉ guṉ Pxoz naa to, teḻne guṉde to samiech to perdon, teḻ pe nac falt ne guṉ zho lo to. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Blozhse sca bnee Jesús lo zho, brieenie me zho ga güeyted zho grë guiedz ne ndxie xtan zha Judé, grë miṉe riaaṉ nëz daṉ ro guiubee Jordán, nëz ne rlan ngbidz. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Miech guizhiu ne rriee grë guiedz co, rdziṉ lo me; grë meṉ rzacnë ne rdziṉnie zho, beeṉguiac me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ga no me, bdziṉ bla zha farisé gocladz zho niuṉgüet zho me, par dieṉ pe nxiṉd me tib diidz; bnabdiidz zho lo me rëb zho: ―Pe gnë luu dieṉ, ¿pe wena csëbtsieel zha bgui ne gacladztaa csëbtsieel? ");
INSERT INTO zpmNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pquiab me rëb me: ―¿Mod raṉde to zha zhobnee lo Xtiidz Dios? Lo co zhobnee gaṉle zeeṉe psaṉ me miech, tib nëz zho psaṉ me, tib mgui ni tib wnaa. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ni rneew, ib none grieezhaa mgui lo pxoz zho, lo xniaa zho par gbannie zho wnaa ne nac tsieel zho, gac zho tibaque miech grop zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nligaa nacdraa zho chop miech, sinque laa zho rac tibaque. Dios nac meṉ ne psaṉ ycatsieel miech, cho dzigo nac miech par quiits zho miṉe rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dzigo rëb zho lo me: ―¿Pex nac dzigo waa bdeed Moisés diidz csëbtsieel mgui ne racladz csëbtsieel? Rëb Moisés, zac csëbtsieel zho, totsaque yquia tib guits gdeed zho lo wnaa zaatne raquiet laa zho psaan wnaa. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Pquiabchaa me rëb me: ―Ne squitaaxe waa miech nad, miech ndip zdoo goc xmeṉgol to, gane bdeed Moisés diidz csëbtsieel zho; saṉgue Dios psaṉd me diidz csëbtsieel miech. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Gacnaṉ to gaṉle, zha ne csëëb wnaa ne nac tsieel zho, ni teḻ peet guieḻyozh beeṉd wnaa co, doḻ ga guṉ zho csëëb zho tsieel zho ycaa zho stib wnaa. Scaquegaa mgui ne ycaa wnaa ne psëëb zho ga, doḻ ga guṉ zho sac goṉ no tsieel wnaa co. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dzigo rëbchaa xpëëdscuel me: ―Teḻ scataa nac xcuent guieḻtsieel, mazd lëëquew dzigo ctsieelniad ne. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pquiab me rëb me: ―Nligaa no mgui ne rtsieelniad, per zhis zho, ni no pe nacne sca riaaṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","No zho desde rac zho mëëd, nacd zho zha ne grieelo tsonie wnaa; no zho ib miech sca rsaṉ zho. Nogaa zha ne ib zha rbeeladz zho ctsieelniad zho, parne grieelo tsoxcoraa zho guṉ zho xtsiiṉ Dios. Zha ne sca rquiabladz ctsieelniad, maase ctsieelniad zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ga no Jesús, ndal zha ne bdziṉ bdziṉnie zho xpëëdlas zho lo me, parne cxobnia me guic win guṉlay me win. Grë zha ne nac xpëëdscuel me, leḻ psilo zho rtsidiḻ zho pe nacne nodziṉnie zho grë mëëdlas co lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Zeeṉe goṉ me sca quiayuṉ zho, rëbchaa me lo zho: ―Ctsirede to grë mëëdlas yeeṉ qui, goḻsaan guiaad win lo naa. Sac goṉ grë mëëdlas yeeṉ, ni zha ne nac zig nac win, zha co nac zha ne sëëb ygab lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dzigo psilo me pxobnia me guic grë mëëdlas yeeṉ co, beeṉlay me win. Blozhse ga, laa me briee ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Laa me zieriee ga, zeeṉe bdziṉ tib mgui nguieg, tib zha ricwa, rëb zho lo me: ―Naṉ naa luu nac tib meṉ ne noseed miech, ni tib meṉ wen nac luu. Bnë dieṉ, ¿pe nac miṉe guṉ naa parne grieelo ygaa naa guieḻmban ndzon ne gdziṉd dze lozh? ");
INSERT INTO zpmNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Pquiab Jesús rëb me: ―Rnee luu lëë tib meṉ wen nac naa. ¡Nligaaw, Diosse nac meṉ wen! Teḻne nli racladz luu ygaa luu guieḻmban co, none tsoxco luu gban luu miṉe rnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Pquiab zho rëb zho lo me: ―¿Pa miṉ waa? Rëbchaa me: ―Miṉe rnee: Gute luu samiech luu, teḻne nole tsieel luu, tsonied luu zha ne led tsieeld luu, cuand luu samiech luu, yquiadiidzguizhd luu samiech luu, ");
INSERT INTO zpmNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","goṉ pxoz luu, goṉ xniaa luu, cueed luu xquieḻto me. Bleynie samiech luu, zigne rleynie luu luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dzigo rëbchaa zho: ―Ni tib miṉe rnee luu i gard quits naa, grësew zanaḻ naaw zigne naca. Racladz naa gacnaṉ naa, dieṉ peraa no guṉ naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Horco rëb me lo zho: ―Teḻ racladz luu gac luu tib zha ne gban grëse miṉe rnabey Dios, güey sca güeyto grëse ncuaaṉe rap luu, dzigo güeytiiz dimi co lo grë zha ne guieṉd pe yquiin. Lozh ga, dë dënaḻ zhits naa. Miṉ co nagoṉ guṉ luu, dzigo zgaa luu guieḻmban ndzon co; ni scagaa nroob guieḻnzaac ne ygaa luu nëz lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Zeeṉe bin zho sca rëb me, mbanse rac zho laa zho zey, sac nroob ncuaaṉe quianie zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dzigo rëbchaa Jesús lo xpëëdscuel me: ―Gneli naa lo to gaṉle, grë zha ne squi rapcheṉ rzacxuu zho par sëëb zho xnëz Dios gnabey me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","¡Ne nligaa ngaṉ rzac zhow! Mazd ngaṉdse rded tib camell guieer guzh lëdle sëëb tib zha ne squi rapcheṉ xnëz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Zeeṉe bin zho sca rëb me, rzee zdoo zho, rnee zho: ―Bay, ¿chosezhe dzigo waa nac zha ne zrieelo sëëb xnëz Dios? ");
INSERT INTO zpmNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dze bui me lo zho, dzigo rëbchaa me: ―Nligaa par miech zootle tsod zha ne grieelo sëëb xnëz me; saṉgue me naṉ me no zho. Sac teḻ me, tsod ncuaaṉe grieelod guṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Horco pquiab Pedr rëb Pedr lo me: ―No dzigo waa, ¿pe nac miṉe ygaa no? Naṉle luu gaṉle, teḻ no grëse ncuaaṉe rdziaap no, laa no psaṉa, ziaadnaḻ no zhits luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Pquiab me rëb me: ―Goḻgona gaṉle, dze ne gacncub grëse ncuaaṉe no, zeeṉe laa Mgui ne pxeeḻ Dios zob lo xcan ne zo zaatne nac lo guieḻndzon ne no me, dze co lo gza to ne nac to zha ne biaadnaḻ zhits naa, sob to lo gza tsiipchop xcan ne rieguiaḻ to. To gac zha ne guṉ guieḻwxtis lo gza tsiipchop dii ne nac zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Grëragaa zha ne psaṉ lidz, psaṉ zho bets zho, bzian zho, xniaa zho, pxoz zho, tsieel zho, xpëëd zho, liuṉ zho porne noyuṉ zho xtsiṉ naa, na lo guieḻmban riique laa zho gaṉa stib tib gayoogaw tib tiba; ni ib tedsod zgaa zho tib guieḻmban ndzon ne gdziṉdraa dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","’Nli zig nac niina, nzian zha ne rzac zha non nac zho, nogaa zha ne rzac zho peet nond, per zeeṉe gaḻ dze co lalga gac zho grë zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Grë zha ne no xnëz Dios, zac zho lo me zig bzhaac grë zha ne güey xtsiiṉ tib meṉ co. ’Tib meṉ co name nroob dziin quianie me, tib dzew zigne biini liu briee me güeyguib me zha ne tsielaap xuv me. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bdziel me palal zho, biaaṉ zho diidz palal quizh me zho dze, laa zho bzëëb lo dziin. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Glaale ngbidza briee me güeyted me leṉ guiedz, lëëtse güeytsib me lo bla zha ne zob ga racladz dziin. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Dzigo bree me zho, rëb me: “Goḻtsie xtsiṉ naa, na quizh naa to miṉe non xtse to.” ");
INSERT INTO zpmNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","’Rwe ngbidza, biire me güey me güeyguib me spalal zho. Maase las treza güeyaque me stib. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","’Zhile sëëb ngbidza, biire me güey me leṉ guiedz. Ga bdzieel me zla zho, goṉ me scase zob zho ga. Dzigo rëbchaa me lo zho: “¿Pe nacne squise noded dze to?” ");
INSERT INTO zpmNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Pquiab zho rëb zho: “Choot rneedzdaxe dziin waa yquiaa no.” Rëbchaa me: “Nasca zeeṉa tsie to lo xtsiṉ naa, maase quizh naa xtse to.” Dzigo laa zho zie. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Zeeṉe laa dze blozh bdze, bnee me lo zha ne zo lo xtsiiṉ me, rëb me: “Bredz grë zha qui na, bdiizh xtse zho grëse zho. Zha ne bza bzëëb lo dziin, zha co glo bdiizh, lozhraa ga quizh luu zha ne glo bzëëb.” ");
INSERT INTO zpmNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dzigo bded zha ne bdzele dze bzëëb lo dziin ga, tib tib zho pcaase zho miṉe non zho tib dze. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Grë zha ne glo bzëëb lo dziin, zeeṉe goṉ zhow, tibaque güeynie guic zho nroobraa nguizh me zho. Per zeeṉe laa zho gozh, lalgaque pcaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","’Zeeṉe goṉ zho lalga pcaa zho grë zho, blëë zho, güey zho güeylisqui zhow lo meṉ ne naccheṉ dziin ga, rëb zho: ");
INSERT INTO zpmNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Psacsi luu no i goṉ squi beeṉ luu. Bui gaṉle gdipse dze ptsuu ngbidz no pquiaa no xtsiiṉ luu, ¿zha nac dzigo lalga quizh luu no grë no zha qui, ni niipyeeṉaque beeṉ zho dziin?” ");
INSERT INTO zpmNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pquiab me rëb me: “Bets, nosacsid naa to, biaaṉle ne diidz name palal quizh naa xtse to. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nana sca goḻgüey xtimi to i, zeeṉa goḻsë. Ib zdoo naa rala lalga quizh naa to grëse to. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¡Stiba, xtimi naaw, zrieelo guṉdziin naaw zigne racladz naa! ¿Te në rac zdoo to ye, raṉ to rquia zdoo naa miech?” ");
INSERT INTO zpmNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Scapaa nagoṉ gac zha ne no xnëz Dios. Lal gacnon zho, zigtaa zha ne glo bzëëb xnëz mew, zigtagaa zha ne sëëb bzaw. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nëz no Jesús zie me nëz Jerusalén, tibaque bredz me gza tsiipchop xpëëdscuel me, ");
INSERT INTO zpmNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","bzeet me lo zho zha guṉ miech me zeeṉe laa zho gdziṉ Jerusalén, rëb me: ―Ib ziaab naa ladznia grë pxoz ne rnabey grë zho maistr ley, zha gnab guet naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Zha co naa ladznia zha zit, parne guṉnguzee zha co naa, parne quiṉ zho naa, ni haxta squiaa zho naa lo cruz. Per zeeṉe gac tsoṉ ngbidza, zriebaan naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tibaque zeeṉe wbig tsieel Zebedé wbignie me grop xingan me Jacob ni Juan, pquiitsgzhib me lo Jesús rnab me guṉ Jesús tib favor ne racladz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Dzigo bnabdiidz Jesús lo me, pe nac favor ne racladz me. Pquiab me rëb me: ―Racladz naa gneedz luu diidz sob tibga xpëëd rii naa cue luu zeeṉe gdziṉ dze ne laa luu zob zobnabey luu; tib zho nëz derech, stib zho nëz revés. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pquiab Jesús rëb me lo wnaa co: ―¡Ni luu goṉ rieṉd pe rnab luu! ¿Niacxe zlëb zho gaṉ zho grë guieḻnë ne gaṉ naa, tedgaa zho grë miṉe teed naa? Pquiab zho rëb zho: ―Zlëëb no. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Rëbchaa me lo zho: ―Nli nenda zaṉ to grë guieḻnë ne gaṉ naa, ni zdedgaa to miṉe teed naa; per ne gnedz naa diidz sob to cue naa nëz derech, nëz revésgaa, led naad raguiaḻ miṉ co; sac laa lugar co biaaṉle par zha ne tsieguiaḻa, ni Pxoz naa meṉ ne zob gbaa meṉ cose naṉ dieṉ chow. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Grëraa xpëëdscuel me, zeeṉe bin zho pe nac miṉe rnab Jacob grop Juan, blëë zho lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dzigo bredz Jesús zho grë zho, rëb me lo zho: ―Raṉ to gaṉle zha ruṉ grë zha ne rnabey grë guiedz ne ndxie lo guidzliu, ni grë zha ne nac zha non, masaque rnabey zho samiech zho zigne racladztaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Saṉgue to goṉ guṉscade to. Zha ne racladz gac zho zha non lo to, laa ne glu zho zha non zho, none glo zho guiaaṉwin, gac zho zig tib nguṉdziin lo to. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Scaquegaa zha ne racladz gnabey zho lo to, none glo cseed zho guṉ zho miṉe gnabey to zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Goḻgaṉ gaṉle, niicle naa ne nac naa Mgui ne pxeeḻ Dios, ziaḻd naa par gnabey naa miech, sinque laa naa ziaḻ par gac naa tib nguṉdziin lo zho, ni gded naa xquieḻmban naa zeeṉa laa zho lo grëtaa ncuaaṉe ngadoo zho. Ni naṉpaa naa miech guizhiu ne laa. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Miech guizhiu naḻ zhits Jesús, laa me zieriee guiedz Jericó. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ro nëz co zob chop zha ne roḻd lo, zeeṉe bin zho laa me ziaad ga, psilo zho nguiedz rbedz zho rnee zho: ―¡Jesús, meṉ xtii rey David, pquia zdoo no! ");
INSERT INTO zpmNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Blalaa zha ne zie ga, psilo zho ndox zho lo grop zha co parne guioog ro zho, per leḻ hor cole nguiedzraa rbedz zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nacne zeeṉe bdziṉ me zaatne zob zho, blëz me, bnabdiidz me lo zho rëb me: ―¿Pe nadieṉ guṉ to naa? ");
INSERT INTO zpmNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pquiab zho rëb zho: ―¡Racladz no guiac lo no! ");
INSERT INTO zpmNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Pquia zdoo me zho goṉ me sca rac zho, dzigo pquiaania me zhits guidlo zho. Horcogazh laa lo zho biac, laa zho zienaḻ zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sca no Jesús nëz grë xpëëdscuel me, laa me bdziṉ guiedz Betfagé. Gaxle ga riaaṉ Jerusalén, nëz daṉse squi riaaṉ Gui Oliv. Dzigo pxeeḻ me chop xpëëdscuel me, rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","―Goḻtsie guiedz win ne ndxie daṉse lo ne i. Ga gdziṉ to zaatne quiadoo tib burr gus grop xpëëd, dzigo goḻxadz ma goḻtënie ma nu. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Teḻ cho gnabdiidz pe nacne noxadz to ma, goḻguiab lo zho: Meṉ ne rnabey ne, meṉ co rquiin ma, na zigne lozh xtsiiṉ ma guiaadsaṉ no ma. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ga brieequia miṉe bnee tib meṉ ne biadteed xtiidz Dios lo miech padzeela, zeeṉe rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Goḻguiab lo meṉ Jerusalén: “Goḻwi gaṉle, laa meṉ ne nac zhirey to ziaad i. Tib meṉ ligase rlu me, zob me lad tib burr win, tib ladse ma ne rey yo zob me.” ");
INSERT INTO zpmNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Laa zho zie, zigne bnabeyse me zho ga, scase beeṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Zeeṉe wbire zho, laa zho bdziṉnie burr co grop xpëëd ma. Pxob zho lar ne rbix zho lad xpëëd ma, laa me bzob ma. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Zigse zie me, no grë miech guizhiu co, rta zho lar ne rbix zho ro nëz rded burr ne zob me ga; nogaa zha ne rchoo nia grë yag nguia, rdziiṉ zhow ro nëz rded me. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Grëse zho, zigtaa zha ne nera, zigtaa zha ne naḻa, nguiedz roptsie zho rnee zho: ―¡Goḻgotsaa co ne xviv xingan David! ¡Goḻgotsaa gleynie ne me! ¡Zha ndzontaa Dios, pxeeḻ me meṉ nroob qui lo ne! ");
INSERT INTO zpmNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Zeeṉe bdziṉ me Jerusalén, rlozhd gzee zdoo grë miech ne ndxie ga, rnabdiidzlsa zho rnee zho: ―¿Bay cho nac meṉ qui? ");
INSERT INTO zpmNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Rquiab grë zha ne naḻ zhits me ga, rnee zho: ―¡Lëë Jesús i! ¡Lëë meṉ Galilé qui, noteed xtiidz Dios lo miech! ");
INSERT INTO zpmNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Biini liu co, zeeṉe bdziṉ Jesús Jerusalén stib, güey me yadoo nroob ne zob lad guiedz co. Bdziṉ me goṉ me nzian miech ne ndxie ga, masaque tib lgui quiayuṉ zho, zha ne no wto, zha ne no wzi. Nacne güey me ptiixche me xmezh zha ne notsëë dimi, ptiixche me xmezh zha ne no wto palom; blee me zho ga grëse zho, ");
INSERT INTO zpmNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","rëb me lo zho: ―Led znu goṉ zhobnee lo Xtiidz Dios: “Zaatne nac lidz naa nu, nu none guiaad grëse miech sodiidznie zho naa.” Laa to goṉ, quiayuṉ to lugar rii zig tib zhibliee ngbaan. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ga no me bdziṉ bla zha ne roḻd lo, zla zha ne në ni, wbig zho lo me. Gzase zho beeṉguiac me. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nzian mëëdlas yeeṉ ne ndxie leṉ yadoo ga, psilo win nguiedz rnee win: “¡Zha ndzontaa xingan rey David!” Grë zha ne nac pxoz ne rnabey, ni grë maistr ley, zeeṉe goṉ zho milagr ne beeṉ me ga, ni goṉ zho zha rnee grë mëëdlas co, rlëë zho, ");
INSERT INTO zpmNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","rëb zho lo me: ―¿Pe ib rond luu gaṉle pe nonee grë mëëdlas qui? Pquiab me rëb me: ―Ron naaw. ¿To waa, pe raṉde to gaṉle zha zhobnee lo Xtiidz Dios, zaatne raquiet miṉe noyac nu? Led rneew lëë: Haxta grë mëëdlas ne bii radz, ye win rley win rooḻnie win me. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Blozhse sca rëb me, zoque zho ga, laa me bio nëz zie me nëz Betain. Ga blëz me wdze co. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sil co zeeṉe no me nëz gdziṉ me Jerusalén, pcaabedz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Goṉ me zob tib yag guigw gax ro nëz, dzigo güey me güeyso me low dieṉ pe ndzield tib nex low niow me. Bdziṉ me goṉ me loxaque zhiblagsew zëëb, nacne rëb me low: ―¡Lëë blozh xtse luu nu goṉ! ¡Gdziṉdraa dze ne yquia nex lo luu! ");
INSERT INTO zpmNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Biini liu, zeeṉe laa zho zie Jerusalén stib, goṉ xpëëdscuel me, laa yag guigw co bidzle. Bzee zdoo zho, bnabdiidz zho lo me rëb zho: ―¿Bui gaṉle, bay zha nacne squi znuse wbidz yag guigw qui? ");
INSERT INTO zpmNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Pquiab me rëb me: ―Gneli naa lo to gaṉle, teḻne dib zdoo to rnalo to Dios, niicle ncuaaṉe mazdraa ngaṉ gnab to lo me, zuṉ mew. Lëëraasi none dib zdoo to gliladz to zaca, ni palal gacchopd guic to. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Grëse ncuaaṉe gnab to zeeṉe rzodiidznie to me, zneedz mew, totsaque dib zdoo gliladz to laa to ycaaniaw. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Bdziṉ me Jerusalén, wbiire güey me leṉ yadoo. Ga noseed me miech, zeeṉe bdziṉ bla zha ne nac pxoz ne rnabey ni zla zha ne nac meṉ non lo meṉguiedz, bnabdiidz zho lo me rëb zho: ―¿Cho dzigo nac luu ne squitaa ziaadnabey luu leṉ yadoo? ¿Cho rnabey luu? ");
INSERT INTO zpmNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Pquiab me rëb me lo zho: ―Ye naa laa naa guṉ tib wnabdiidz lo to. Teḻne stsire to low, dzigo gni naa lo to gaṉle cho rnabey naa ne laa naa noyuṉ grë ncuaaṉe noyuṉ naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Goḻnë dieṉ, ¿cho pxeeḻ Juan Bautist biaad me pchoobnis me miech? ¿Pe Dios pxeeḻ me, te miechsew ye? Psilo zho rnabdiidzlsa zho dieṉ zha ctsire zho lo xtiidz me, rnee zho: ―Teḻne dzieets ne Dios pxeeḻ Juan, dzigo laa me gnë: “¿Pex nac dzigo waa bliladzde to miṉe bnee me?” ");
INSERT INTO zpmNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Teḻ na dzieetsgaa ne, miechse pxeeḻ Juan, grieequiadaque ne. Rdzieb zho niab zho miechse pxeeḻ Juan, sac naṉ meṉguiedz nli Dios pxeeḻ Juan biadteed Juan xtiidz me lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dzigo mazd miṉe beeṉ zho rëb zho lo me: ―Ndioṉd no dieṉ cho pxeeḻ Juan. Dzigo rëbchaa me lo zho: ―Niicle naagaa nagoṉ, grieelod gni naa lo to cho rnabey naa quiayuṉ naa grë miṉ rii. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","’Goḻquiaadiaga gaṉle. Tib mgui, quianie me chop mëëdbgui. Tib dzew, bredz me tib zho rëb me lo zho: “Xin, none goṉ tsie luu nadze, tsietop luu uv xcuaa ne.” ");
INSERT INTO zpmNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Pquiab zho rëb zho: “¡Gad naa!” Wdzeelaaw, bieṉ zho nonguieḻda ga sca guṉ zho, dzigo bio zho nëz güey zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Laa stib zho, zeeṉe bredz me zho bnabey me zho tsie zho lo dziin, rëb zho: “Peet nacda, na maase ga naa.” Blozh ga pasë zho nie. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","’Goḻnë dieṉ, lo grop mëëd co, ¿cho nac zha ne bin xtiidz pxoz? Pquiab zho rëb zho: ―Zha glo cow. Dzigo rëbchaa me: ―Gneli naa lo to gaṉle, miṉcodaa quiayac nu niina: Grë zha ne rzac to mazdraa ngoopdoḻ, zig nac grë zha ne rtop dimi ne razh lo zha Roma, zig nac grë wnaa ro nëz, mazd glole zha co nozëëb xnëz Dios, lëdle to. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Biaadpaa Juan Bautist name biadseed me miech csaan zho xquieḻntseeb zho, gban zho zigne racladz Dios, ni pe liaadz to nion to miṉe rnee me. Mazd grë wnaa ro nëz, grë zha ne rtop dimi ne razh lo zha Roma, znuse psaan zho xquieḻntseeb zho. Laa to, niicle raṉ to nosaan grë zha co xquieḻntseeb zho, per ib rsaande to miṉe nac to. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Dzigo bzodiidz me stib cuent lo zho rëb me: ―Tib meṉ name, nroob lbë uv beeṉbni me lo liuṉ me. Psilo me ptse me igose liu co, bzaa me zaatne gzhii grë uv co, ni bzaa me tib yu glaa zaatne sob zha ne yquiaanapa. Blozh ga, blediiṉ me liu co lo bla zha ne ran liu, dzigo laa me briee, laa me zey zit. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Zeeṉe goḻ mëë ne laa nex co gol, pxeeḻ me bla zha ne quia xtsiiṉ me zie lo zha ne quianap liuṉ me ga, parne gdeed zha co uv ne rieguiaḻ me ycaa me. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per leḻ bnaaz zho zho, zha ne blooquie zho, zha ne bdeedgolp zho, haxta beet zho tib zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wbiire pxeeḻ me zla zho, hor cole nzianraa zho pxeeḻ me, per niapse sca psacsi zha co zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Tibaque zeeṉe pxeeḻaque me xpëëd me, bza guic me rëb me: “Gaṉse zho xpëëd naaw, zon zho miṉe gnee me.” ");
INSERT INTO zpmNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","’Pex nion zho diidz, zeeṉe goṉ zho xpëëd me, rëbchaa zho: “¡Lëë zha qui nagoṉ guiaaṉnie liu rii! ¡Goḻgotsaa dziuut ne zho, zeeṉa guiaaṉa lo ne!” ");
INSERT INTO zpmNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dzigo bnaaz zho xpëëd me, güeynie zho me zaatne nac tib lad lo liu co, ga güeygut zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’¿Zha sca dieṉ rzac to guṉ bizhuan liu co gza zha co, zeeṉe laa me gbire? ");
INSERT INTO zpmNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pquiab grë zha ne nac pxoz ne rnabey, ni zha ne nac zha non lo meṉguiedz ga, rëb zho: ―Ni lalnu yquiad zdoo me zho, znitlogazh me zho. Lozhse ga, cuediiṉga me liuṉ me lo zla zha ne guṉdziina, zha ne guieṉ gdeed nex ne rieguiaḻ me ycaa me. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Dzigo rëbchaa me lo zho: ―Haxta lo Xtiidz Dios no tib zaatne znu rnee, ¿pe gard gaṉle glab tow? Rneew: Quie ne psëëb zha ne nozaa yu, ni naṉd zho lëëpaa quie co nac miṉe rnazdziits yu. ¡Ncuaaṉe gzee zdoo new! Sac Dios bnabey sca goca. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Gacnaṉ to gaṉle, scadaa nagoṉ griee to lad grë zha ne ngab lo Dios, parne gbig zha ne tsoxcopaa guṉ xtsiiṉ me, zha cole guiaaṉ xlugar to. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Zha ne tsietsobe lo quie ne raquiet ga, zac zho zig tib ncuaaṉe rac tsoṉ tap lë; laa teḻ lëëgaaw tsobe lad zho, zac zho zig tib ncuaaṉe die die rac. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Grë zha ne nac pxoz rnabey ga, ni grë zha farisé, zeeṉe blozh pquiaadiag zho cuent ne bzodiidz me lo zho ga, bieṉ zho zha ga rzeet me. ");
INSERT INTO zpmNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nacne gocladz zho naaz zho me, per bdziebaque zho; sac ndal miech rleynie me, niicle ne rzac zho tib zha ne noteedse xtiidz Dios nac me. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Bzodiidz Jesús stib cuent lo zho, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Grë zha ne rbedz Dios ygab zho xnëz me, none tsoxco zho gon zho miṉe rnee me; sac nenda gdzieelo zho zig bdzieelo zha ne bredz tib rey co nie zho lo zhilni xpëëd me. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","’Tib rey name, ziaadyob ctsieelnia xpëëd me, nzian zha ne bredz me tsie lo lni. Zeeṉe laa dze co bdziṉ, pxeeḻ me zha ne quia dziin lo me zietsedz grë zha ne bredz me lo lni ga, per nëd zho nienaḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wbiire me pxeeḻ me zla zho rëb me: “Goḻtsietsedz zho, goḻguiab, laa guieḻwagw ne yquiin goclole, siguieḻ zho na guiaad zho.” ");
INSERT INTO zpmNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per ib beeṉcasd zho zha ne pxeeḻ me ga, no zho briee zie lo xcuaa, no zho briee zie zhiwto, ");
INSERT INTO zpmNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","nogaa zho leḻ bnaaz zho zha co, psacsi zho zho, beet zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Zeeṉe goṉ me sca beeṉ zho, blëë me, bnabey me grë xmeṉguiib me güey zho güeygut zho grë zha ntseeb ne psacsi xmandad me ga, ni bnabey me bzëëg zho guiedz co. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","9","Blozh ga biire pxeeḻ me zla zho, rëb me: “Laa guieḻwagw rii goclole, miṉe naca goḻtsie tib nëz yu, zha ne gdzieeltaa to, goḻcuedz zho guiaad zho lo lni; sac grë zha ne bredz naa ga niaad, laa zho blule gaṉle rieguiaḻd zho guiaad zho nu.” ");
INSERT INTO zpmNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","’Dzigo briee zho güey zho, miech ne bdzieeltaa zho, zigtaa zha ndzinliw, zigtaa zha ntseeba, grëse zho bredz zho bdziṉnie zho zho lo lni. Goḻ hor wagw, biodzëse leṉ yu ndxie miech. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Zeeṉe laa rey bzëëb zienee me lo zho, goṉ me lad co no tib zha co nacwxabd zho zigne rieguiaḻ gacwxab zha ne sca rie tib lo guieḻtsieel. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dzigo rëbchaa me lo zho: “Bets, ¿pe nacne squise luu bzëëb luu nu, bui gaṉle nacwd luu lar ne bneedz zho niacw luu?” ’Dzese zob zho, rdzield zho pe guiab zho lo me. Goṉse me sca rac zho, ");
INSERT INTO zpmNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","bnabey me zha ne nodziib lo mezh rëb me: “Goḻzobdoo zha rii, goḻxidoo grop nia zho, grop ni zho, goḻcuee zho nu goḻtsieroṉ zho lo ncow nëz ley. ¡Ga nac zaatne rieguiaḻ zho, ga gaṉ zho guieḻnëdox ne no ted zho, goonnë zho, haxta gow lay zho!” ");
INSERT INTO zpmNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","’Miṉcodaa nagoṉ rac leṉ dze rii ―rëb Jesús―, ndal zha ne racredz sëëb xnëz Dios, per zhis nac zha ne rioxco rzëëb. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Blalaa zha farisé ne ndxie ga güey zho bnediidz zho dieṉ zha guṉgüet zho Jesús cxiṉ me tib diidz, zeeṉa miṉ co yquiaaqui tsiezo zho me lo wxtis. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dzigo pxeeḻ zho bla zha ne nacgrë zho, ni güey zla zha ne racnie Herod gocgza zho. Bdziṉ zho rëb zho lo me: ―Maestro, ndioṉ no niapse diidzli zienaḻ luu, ni scagaa zeeṉe rseed luu miech, rdziebd luu miṉe nac diidzli miṉ co rnee luu lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gane niina, racladz no gnë luu dieṉ pe nonguieḻa ga rdeed no dimi ne razh lo rey ne zob Roma, te nonguieḻda ye. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","19","Bieṉga me racladz zho guṉgüet zho me, dzigo rëbchaa me lo zho: ―¿Pe naṉ to na rieṉd naa pe no guic to? Masaque rëb to na lëë, znuse guṉgüet to naa. Goḻneedz tib pes ne rguizh to nu gaṉle. Dzigo bdeed zho tib pes plat lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Blozh ga, rëbchaa me lo zho: ―¿Cho nu, cho lë nu quia lo pes rii? ");
INSERT INTO zpmNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pquiab zho rëb zho: ―Lëë rey i, lëë lë me i quia lo qui. Dzigo rëb me lo zho: ―Miṉe rieguiaḻ sca ycaa rey, goḻdeeda lo rey; scaquegaa miṉe rieguiaḻ ycaa Dios, lo Dios goḻdeeda. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Zeeṉe goṉ zho sca ptsire me lo xtiidz zho, bzee zdoo zho, mazd miṉe beeṉ zho laa zho wbichese ga, laa zho zey. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dze coquew, güey bla zha saducé lo Jesús. Nac zha saducé rliladzd zho zdziṉ dze grieeban miech. Dzigo bdziṉ zho, ");
INSERT INTO zpmNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","rëb zho lo me: ―Maestro, znu psaṉ Moisés diidz: Teḻne glo mgui guet lo wnaa ne nac tsieel mgui, ni gopd wnaa mëëd, dzigo none betsaque zho ctsieelnia wnaa co stib, zeeṉa gap wnaa mëëd ne guiaaṉ xlugar xpëëd zha ne gut ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","’Bio tib dii zha co znu bzhaac, gadz bets nac zho. Ptsieelnia zha ne nac zha gol, zeeṉe laa zho gut biaaṉd xpëëd zho. Dzigo ptsieelnia stib bets zho wnaa co. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Blozh ga gutaque zha co, pa së zho nsaṉ mëëd. Ptsieelniaque me stib zho, goc zho tsoṉ, niicle zha co psaṉdaque mëëd. Sca sca haxta bza gza gadzse zho ptsieelnia me, ");
INSERT INTO zpmNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","tibaque zeeṉe yeque me laa me gut. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Miṉe racladz no gacndioṉ no, ¿chopaa dzigo gac tsieel wnaa co zeeṉe laa zho grieeban? Sac gza gadzse zho ptsieelnia me. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pquiab Jesús rëb me lo zho: ―I nagoṉ laa to rxiṉ, miṉe naca rieṉde to zha nac Xtiidz Dios, niicle rliladzde to zrieelo me guṉ me ncuaaṉ ro ne gard gaṉ miech. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sac goṉ zeeṉe gaḻ dze ne laa grë miech grieeban, niicle mguiw niicle wnaaw led yedraa hor co dieṉ cho ctsieelnia zho; sac hor co laa zho gac zig nac grë anjl ne no gbaa. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Stiba, ib nli zrieeban meṉgut. Mod raṉde to zha zhobnee zaatne raquiet zeeṉe rëb Dios: ");
INSERT INTO zpmNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Naa nac Dios ne rliladz Abraham, naa nac Dios ne rliladz Isaac, naa nac Dios ne rliladz Jacob.” Niicle ne gutle gza zha co hor co, per zeeṉe sca bnee Dios gase rlu mban zho no zho lo me; sac teḻ Dios, ¡nacd me xDios meṉgut, sinque xDios zha mban nac me! ");
INSERT INTO zpmNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Grë miech ne ndxie ga, zeeṉe goṉ zho sca ptsire me lo xtiidz zha saducé co, rzee zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Grë zha farisé ne ndxie ga, goṉ zho sca psioog Jesús ro grë zha saducé co. Horco biire grë zha farisé co bzodiidz zho stib. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Lad zho no tib maistr ley, dzigo wbig maistr ley co lo Jesús, rëb zho: ―Maestro, lo grë xley Dios, bzhiguieḻ bnë lo naa dieṉ, ¿pa miṉ nac miṉe mazdraa non? Sca rëb zho, sac gocladz zho niuṉgüet zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Pquiab me rëb me lo zho: ―Lëë miṉe mazdraa non nu znu rnee: “Dib zdoo luu, dib xalm luu, dib guieḻbiini ne no guic luu, bleynie Dios, meṉ nroob ne rnabey luu.” Lëëw nac miṉe mazdraa non, ni lëëw glopaa raquiet lo grëse ley. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","No stib miṉe rnee: “Bleynie samiech luu zigne rleynie luu luu.” Ye miṉ rii nona, meraque lala con miṉ glo. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Zha ne gban zigne rnabey grop ley rii, lëële grë ley ne psaṉ Moisés ga, lëële grë zhiwseed zha ne biadteed xtiidz Dios ga, zienaḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Goṉ Jesús nzian farisé ndxie lo me ga, nacne bnabdiidz me lo zho rëb me: ―¿Zha dieṉ rzac to guiaad Meṉ ne zëëble diidz ga cxeeḻ Dios? ¿Cho lo xtii grieequia me? Pquiab zho rëb zho: ―Lo xtii David grieequia me. ");
INSERT INTO zpmNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dzigo rëbchaa me lo zho: ―¿Pe scaw sca? Zha nac waa zeeṉe bdeed Espíritu Sant guieḻbiini lo David bzeet David meṉ co, rëb David me nac meṉ ne rnabey David. Goḻgaṉ gaṉle znu bnee David: ");
INSERT INTO zpmNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Rëb Dios lo meṉ ne rnabey naa: “Cue naa nëz derech, nu bzob, nieeda lozh gnaz naa grëse zha ne rlëë lo luu, csaṉ naa zho ladznia luu.” ");
INSERT INTO zpmNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Gase nagoṉ teḻne nli zha xtii David gac Meṉ ne cxeeḻ Dios ga, ¿zha nac dzigo rnee David meṉ co rnabey David? ");
INSERT INTO zpmNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ni tib zho ib bdzield zho zha ntsire zho lo xtiidz me; desde dze co ni stib zho biazhdraa pe nabdiidz zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dzigo psilo Jesús bnee me lo grë miech co, ni lo xpëëdscuel me, ");
INSERT INTO zpmNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","rëb me lo zho: ―Grë maistr ley ni grë zha farisé ib lëë xtsiiṉ zho ga, nac cseed zho miech zha nac ley ne psaṉ Moisés. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Goḻguieṉ goḻgon xtiidz zho, ¡per nsin goḻso, ib guṉde to miṉe ruṉ zho! Nac zho, ni lalnu ruṉd zho miṉe rseed zho miech. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rio zho rnee zho lo miech, miṉ rii, miṉ rii rnabey ley guṉ to, ni per ni zha rioxcod zho siquier csilo zho guṉ zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","’¡Grë ncuaaṉe ruṉ zho, laaw ruṉse zho par gaṉpaa miecha! Par guiab miech nguzobdiidz zho lo Dios, rio zho led zhid nzhen grë lo cint rquiaa zho Xtiidz Dios, rlozh ga rzhidoow yaṉ nia zho, rzhidoow quia zho ne. Lar ne rbix zhow, rlozhd dieeṉ peraa rquia lada, xab zhow, haxta zhits ni zho rbiba. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","¡Zeeṉe rbedz miech zho tib wagw nroob, rdziladz zho zhapaa rzob groḻ mezh, niicle leṉ yadoogaaw, zaatne glupaa zha non nac zho, ga rzob zho! ");
INSERT INTO zpmNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ro nëza, rdziladz zho ndooladz gnee miech bdiuzh lo zho, zeeṉe rnee miech “zha rac”, “zha non”, nac zho, rlozhd gley zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Saṉgue to goṉ yguibde to dieṉ zha gnee miech “zha rac” nac to, sac tibaque meṉ rac no, lëë me ga zëëble diidz cxeeḻ Dios; goḻguieṉ gaṉle teḻ to lalga nac to, rrieequia bets to grë to. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ib guṉde to zig ruṉ grëraa miech, ruṉnon zho tib samiech zho rnee zho lëë pxoz zho ga, sac tibaque meṉ ne nac Pxoz to, lëë meṉ co no gbaa. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yguibde to sac miech topaa guṉctsiṉ zho lo Dios, sac loxaque Meṉ ne nole diidz ga cxeeḻ me, meṉ cose zrieelo guṉctsiṉ zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Nodne gacglaa to lo samiech to, mazd ndooladz goḻgac lo zho, sac zha ne racglaa, ziaaṉwin zho. Gacxe waa, teḻne racladz to gacnon to, none ndooladz gac to lo samiech to. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Probsaxe to maistr ley, probsaxe to zha farisé! Lëda i goṉ noyuṉ to, rzac to noxco to sëëb miech xnëz Dios, per leḻ noca to sëëb zha ne racladz sëëb. Ni stiba, per ni to nod xnëz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Probsaxe to! Guieḻntseeb i goṉ ruṉ to, rio to rlozhd gooḻ to xlay to rzo to ro nëz, ni noque to rla to ncuaaṉe rapse grë wnaa viud; ib tedsod goṉ guieḻnëdox ne ygaa to. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Probsaxe to, rzac to na lëëw ga ruṉ to! Rio to gui dan rbix to, haxta rded to nisdoo, rquiaguib to dieṉ cho sëëb xnëz to ni rlozh ga laa ne ygab zho nëz lo Dios, leḻ nëz leṉ gabiḻ zienie to zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Probsaxe to, nac diidz name to noseed miech, ni per ni to rieṉd pe rnee to! Rnee to lo miech: “Zha ne rzeet yadoo ni teḻ guṉd zho miṉe rnee zho, peet nacd ga, per teḻ gzeet zho grë or ne no leṉ yadoo ni guṉd zhow, doḻ ga guṉ zho.” ");
INSERT INTO zpmNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Nadzpaa nxen to, nadzpaa ncow nac guic to! ¿Niacxe mazdraa non or lo yadoo? Goḻguieṉ gaṉle por yadoo, naclay grë or co. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Rneeque to: “Zha ne gzeet lo pcoog, led doḻda teḻne guṉd zho miṉe rnee zho; per teḻ gzeet zho gon ne ndziib lo pcoog ni guṉd zhow, doḻ ga guṉ zho.” ");
INSERT INTO zpmNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Pe nlipaa rnee to peet rieṉde to! ¿Niacxe mazdraa dzigo non gon que lo pcoog? ¿Pe raṉde to por lo pcoog co raclay gon? ");
INSERT INTO zpmNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Goḻguieṉ gaṉle, zha ne rzeet lo pcoog, yele grë ncuaaṉe ndziib low ga quiazeet zho; ");
INSERT INTO zpmNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","zha ne gzeetgaa yadoo, haxta Diosle ga goṉ rzeet zho, sac ga rbëz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Scasaque zha ne gzeet gbaa, zaatne rzoble Dios ga nozeet zho, masaque rrieequia me ga rzeet zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Probsaxe to maistr ley, probsaxe to farisé! Rzac to na demas nguzobdiidz to lo Dios, rio to haxta grë guizh bitxtil, guizh nizh, guizh comin ruṉ to tsii lal, rdeed to tib lala miṉe rieguiaḻ tsiesaṉ to yadoo, laa ley ne mazdraa non zienied guic to guṉ to miṉe rnabeya. Nli rieguiaḻa gdeed to grë gon co, per none scaque tsoxco to guṉ to miṉe nac diidzli, none yquia zdoo to samiech to, none dib zdoo to gnalo to Dios. Miṉ rii nac miṉe mazdraa non. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","’¡Ne nlipaa ib rieṉde to pe quiayuṉ to! Rzac to na noxco to guṉctalde to xtoḻ to, masaque ni tib ngurudz rsaande to tso lo ncuaaṉe row to, ni rieṉde to rrieequia haxta tib camell rab to. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Probsaxe to, masaque nac to zig tib plat, zig tib tas ne nëz zhitssew mbe rna, laa nëz leṉa rnadraa! Laglaase rquiaalo to miech wen nac to, per tibaque noban to, tibaque nosacsi to samiech to. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Goḻguieṉ none glo csaan to xquieḻntseeb to, none gac to zig tib plat zig tib tas ne zigtaa mbe nëz zhitsa, scagaa mbe nëz leṉa. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Probsaxe to, nac to goṉ zig grë baa ne dieeṉ paraa nquitsbie rna! Niow rlu nëz zhitsa, laa nëz leṉa loxaque grë ncuaaṉ biodz, loxaque grë dzit ngutoo nodzë. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sca goṉ nac to, ne rac to zootxe luu waa nli miech ndzinli nac to, per nëz leṉ zdoo to loxaque zhgab ne dieṉ zha yquidie to miech, zha csacsi to miech no to. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Probsaxe to maistr ley, probsaxe to farisé! Ni lalnu guieḻto guieṉd lo to, rio to rzhixcuaa to ro xpaa grë zha ne biadteed xtiidz Dios, ni lëëpaa grë pxozgol to beet zho. Dieeṉ peraa ruṉ to rquiaalo to rsoladz to zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Rnee to: “Teḻne niaca miṉe nole ne leṉ dze co, ndeete ne diidz nsacsi xmeṉgol ne grë meṉ rii.” ");
INSERT INTO zpmNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","¡Lëëque to goṉ nobeero ga, zha nactaa lo dii ntseeb ne ziaad to! ");
INSERT INTO zpmNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Scaque nasca goḻguṉ! ¡Goḻtsienaḻ grë miṉe beeṉ pxozgol to ga! ");
INSERT INTO zpmNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Miech ngoopdoḻ! ¡Zhin meṉdox! Teḻne csaande to xquieḻntseeb to i, ib tedsod goṉ gabiḻ guey to. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","’Grë zha ne cxeḻ naa, zig nac zha ne guiadteed xtidz naa, zha ne nacnie Espíritu Sant, zha ne ygaa guieḻbiini yquiaa zho miṉe gnabey Espíritu Sant zho, ib tedsod sacsi to zho. No zho gutgazh to, no zho yquiaa to lo cruz, no zho lëëque leṉ xyadoo to gdeed yag to zho, ib gaṉdzede to zho, stib guiedz, stib guiedz tso to ctsidiḻ to zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Blactaa grë miech ne sca peet xtoḻd ziyut to grë xmeṉgol to, psilow desde Abel haxta Zacarí xingan Berequí, meṉ ne beet xmeṉgol to zaatne nac gax lo pcoog leṉ yadoo. Ni ye to goṉ zëëb xchen grëse zha co. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","¡Gneli naa lo to gaṉle, grë miech ne goṉ mban leṉ dze rii, grë to zho ygaa guieḻnëdox ne tsieguiaḻ to por grëtaa guieḻntseeb co! ");
INSERT INTO zpmNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Aque tow meṉ Jerusalén! ¿Pe nacne squitaa nac to, rut to zha ne ziadteed xtiidz Dios lo to, rgoquie to grë zha ne rxeeḻ me lo to? Blactaa gocladz naa, niacnie naa to, nquianaap naa to, zig ruṉ nguid rgueedz ma xpëëd ma, per bzhiguieḻde to. ");
INSERT INTO zpmNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gacnaṉ to sca gaṉle, nadzetaa goṉ laa lidz to nu guiaaṉ ngan, ");
INSERT INTO zpmNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","sac gaṉdraa to naa, haxta gaḻ dze ne guiab to: “¡Zha ndzontaa meṉ qui pxeeḻ Dios lo ne!” ");
INSERT INTO zpmNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Laa Jesús zieriee leṉ yadoo grë xpëëdscuel me, zeeṉe pcuëëzdze zho me, rëb zho: ―Gotsaa gwi ne gaṉle zha niaataa yadoo rii. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Blozhse bui zho low, rëbchaa me lo zho: ―Niicle squitaa nagoṉ niaaw, per zdziṉ dze ne nitlow dib nacsew. Ni stib quie qui guiaaṉdraa zigne squi zhobxcuaaw i. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Briee me leṉ yadoo ga grë me zho, laa zho zie nëz Gui Oliv. Bdziṉ zho cho gui co, ga bzob me grë me zho. Dzigo wbig gax bla zho lo me, bnabdiidz zho rëb zho: ―Bzhiguieḻ bnë lo no dieṉ, ¿pa hor dzigo gac miṉe bzeet luu ga? ¿Zha glu zeeṉe laa luu ziaadyoble guiaad? Zeeṉe nitlogaa guidzliu, ¿zha gacndioṉ no laa dze co ziaadyoble? ");
INSERT INTO zpmNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Pquiab me rëb me lo zho: ―Nsin goḻso, zeeṉa choot yquidiede to. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sac nzian zha ne grieequia guiab zho zha nac Meṉ ne zëëble diidz cxeeḻ Dios; ni nzian miech ne yquidie zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Zeeṉe gon to nëzrii nëzrec noxtseeb csilo diḻ, guiabde to togo lëële dze ne guiaḻ naa ga bdziṉ; sac niicle noyacle diḻa, noxtseebragaa pa csilo gaca, led lëdle ne nitlo guidzliu ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Garaa csilo grë diḻdox, grë guiedz nroob laaw tiḻnie saguiedz nrooba; grë zha ne rnabey grë guiedz nroob, laa zho tiḻnie sazha rnabey zho. Nëzrii nëzrec csilo gni grë zhodox, nzian zaatne gaṉ miech gbin. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ni lega loxaque miṉe rsilosew ga, sac nroobraa guieḻnë ne gaṉ miech lozh ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Zeeṉe laa grë ncuaaṉ rii noyac, ¡nsin goḻso! Sac hor co laa miech tsielo to ladznia zha ne csacsi to, haxta zut zho palal to, grëse miech stsidiḻ zho to loxaque ne nac to zha ne no xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nzian zha ne nole xnëz naa, leṉ dze co laa zho gbiche, laa zho csilo lëëque zha glëënie zha ne nacgrë zho, haxta zielo zho zho ladznia zha ne gut zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Leṉ dze co zrieequia nzian zha ne yquidie miech guiab zho xtiidz Dios noteed zho, ni nzian zha ne gliladza. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Grë zha ne nole xnëz naa, zeeṉe gaṉ zho grëtaa guieḻntseeb, grëtaa doḻ ne quiayuṉ miech leṉ dze co, ndal zho gleyniedraa zho Dios dib zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per zha ne tiblique gac, gbiched zho lo Dios, niicle teḻ petaa gaṉ zho noyac, zha co gac zha ne gdziṉ lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Niicle scataa noyac grë ncuaaṉ co, ib none ygaaz Xtiidz Ndzon Dios lo grëse miech, grëtaa zaatne ndxie miech laa zho gacnaṉa; lozhraa ga dzigo laa guidzliu rii nitlo. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Zeeṉe gaṉ to zaatne nac Lugar Nda leṉ yadoo, zo tib ncuaaṉe rieguiaḻd so ga, tib ncuaaṉe ziaad gnitlo, zigne bzeet Daniel meṉ ne biadteed xtiidz Dios (zha ne glaba, none guieṉ zho zha naca), hor co goḻguib dieṉ zha xooṉ to. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Zha ne no grëraa guiedz ne ngab Judé, none xooṉ zho tsie zho dan, ga tsietsolan zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Zha ne lëëtaque hor co no glaa guic lidz, none lëëlëd xooṉ zho, ib guiabd zho sëëb zho leṉ yu tsiebee zho ncuaaṉe rap zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Zha ne quiagaa lo dziin dan, ib guṉd zho tsie zho lad guiedz tsiexi zho xab zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Prob grë meṉ wnaa ne lëëtse leṉ dze co zoney xpëëd, meṉ ne quianiegaa mëdyeeṉ ne bii radz! ");
INSERT INTO zpmNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Goḻnab lo Dios gaṉde to guieḻnë co leṉ mëë ne rac naḻ, dze ne rdziiladzgaa to lo dziin. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ne nligaa guieḻnëdoxa. Wlal ne biaaṉ guidzliu haxta lo nadze, gard gaṉ miech tib guieḻnëdox sca, ni gaṉdragaa zhow ted ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Teḻne csaan Dios nroob dze gac guieḻnë co, ni stib miech rii guiaaṉdraa; per na por grë zha ne bzooblo me sëëb xnëz me, gdeete me diidz gaca nroob dze. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Zigne rne naa ga, leṉ dze ne scataa gaṉ miech grë diḻ co, zha ne gnë lo to: “Goḻtë nu gaṉle, lëë Meṉ ne nole cxeeḻ Dios ga blanso nu”, gnëgaa zho: “Goḻtsie nec gaṉle, laa me bdziṉ ga”, gliladzde tow. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sac zrieequia zha ne yquidie guiab zho zha nac meṉ co, zrieequia zha ne guiab xtiidz Dios ziadteed zho lo miech, zuṉ zho grë milagr nroob, parne yquidie zho miech, haxta zha ne nole xnëz Dios, zguib zho dieṉ zha gdeeda diidz yquidie zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","¡Nsin sca goḻso! Beṉque laa naa nilew lo to. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nligaa zha ne gnë lo to laa meṉ ne pxeeḻ Dios ga blansole, gliladzde tow. Nenda cxeeḻ zho to tib dan zit, gnë zho: “Goḻtsie gaṉle laa me no ga”, gnëgaa zho pa tib leṉ yu ne no me, ni tib xtiidz zho gliladzde to. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sac zeeṉ gaḻ dze ne guiaad me stib, gacda ncuaaṉ ngueets zhliaan, grëse miech gaṉ me. Zig teḻ guiab tib belye nroob ne glu zhan gbaa, desde nëz ne rlan ngbidz haxta nëz ne rzëëb ngbidz, ¿niacxe gaṉd grëse miecha? ");
INSERT INTO zpmNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Zlupaa zeeṉe laa me guiaad; naṉle to gaṉle zaatne nix ma gut, ga rcaalsa pech. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Zeeṉe lozhse gaṉ miech grë guieḻnëdox co, laa lo ngbidz ycow, gziinidraa mëë. Grë mel ne ndziib gbaa, laa ma gliaaḻ; grëraa ncuaaṉe no gbaa, masaque nëzrii nëzrec gaca. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Horco zlu gaṉle zeeṉe laa Mgui ne pxeeḻ Dios ga, ziad-zëëb lo xcow con grë guieḻndzon, con grë poder ne rap me, grëse miech mban gac zho, zoon zho gaṉ zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Grë xanjl Dios, hor co laa Dios cxeeḻ zho tsiecuedz zho zhitrompet zho parne ycaalsa grëse zha ne ngab xnëz me, teḻ pa lotaa lo guidzliu no zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Goḻzoob cuidad zha nac yag guigw. Led naṉle to gaṉle, zeeṉe laa grë zhicwa racnieeṉ, ni rsilo rdzib zhiblaga, gase rlu ne laa mëë nëëg ziaadgaxle. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Scaque nagoṉ zeeṉe gaṉ to laa grë miṉe rne naa lo to nu rsilo noyac, dzigo naṉle to laa dze ne guiaad meṉ co ziaadgaxle. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gneli naa lo to gaṉle, nzian miech ne mban niina bii zaṉ zho zeeṉe laa grë ncuaaṉ co csilo gac; sac ible ncuaaṉe gaca. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Zdziṉ dze ne nitlo gbaa, nitlo guidzliu, saṉgue miṉe rne naa lo to nu, nitloda; ible laaw none gac. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Lëëraasi choot naṉd dieṉ pa dzew, dieṉ pa horgaaw, per ni grë anjl ne no gbaa, per ni naa naṉda, loxaque Pxozse naa naṉa. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","’Naṉle to gaṉle zha bzhaac miech leṉ dze ne wban Noé, ib bliladzd zho xtiidz me. Guxt no zho lo zhilni zho, zha ne notsieelnia, zha ne nobediiṉgaa xpëëd, laa dze bdziṉ laa Noé bzëëb leṉ barcw; tibaque zeeṉe biaa zho biini laa guiedox co nonitlole zho. Scadaa nagoṉ sac grë miech nad rii, tibaque zeeṉe tsaa zho biini laa Mgui ne pxeeḻ Dios ga ziaadle. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Horco zaatne quia chop mgui lo dziin dan; tib zho tsienaḻ zhits me, stib zho guiaaṉ. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Zaatne quiayot chop wnaa, tib zho tsienaḻ zhits me, stib zho guiaaṉ. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’¡Nsin sca goḻso, sac goṉ naṉde to dieṉ pa horpaa guiaad me, beṉque laa vis racle lo to! ");
INSERT INTO zpmNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Goḻgaṉ gaṉle, teḻ niaca miṉe gacnaṉ miech laa ngbaan tsieban lidz zho guieel, per naṉd zho dieṉ pa horpaaw; ¿niacxe zaaguies zho? Led sobna zho lëë, nsin nsin so zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Scaque to nagoṉ, none nsin so to, sac goṉ lega naclew zeeṉ gaṉ to laa me ziaadle. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Goḻgaṉ gaṉle, masaque laa to gac nagoṉ zig tib nguṉdziin ne riaaṉnie ro lidz meṉ ne rquia zho xtsiiṉ. ’Nguṉdziin ne ndzinli, zeeṉe laa meṉ ne quia zho xtsiiṉ ga griee, iṉe niowse guiaaṉ zho guiaaṉnie zho grëraa zha ne no lidz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Zha ne sca guṉ, ¡wen tsie zho, sac zeeṉe gbire me gaṉ me scataa noxco zho dziin ne pso me zho, ziaṉnziuu zho lo me ");
INSERT INTO zpmNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","haxta so me zho, zha yquiaanap grëse ncuaaṉe rap me! ");
INSERT INTO zpmNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","’Teḻ nguṉdziin yozhgaaw, miṉe tsienie guic zho guiab zho gbireniobd meṉ ne quia zho xtsiiṉ ga, ");
INSERT INTO zpmNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","csilo zho csacsi zho grëraa zha ne nac nguṉdziin, csilo zho ctsieelsa zho grë ngonziu tso zho loxaque gzudz zho, loxaque gowcho zho, ");
INSERT INTO zpmNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tibaque zeeṉe gaṉ zho laa me bdziṉle. ");
INSERT INTO zpmNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Zha ne sca guṉ, per peraa dieṉ guṉ me, ib tedsod nroob caxtigw ne cteed me zho, sonëz me zho guey zho zaatne no grëraa zha ne rond diidz, ga tso zho grë zho zha co goonnë zho, haxta gow lay zho lo guieḻnëdox ne ted zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Blozh ga rëbchaa Jesús lo zho: ―Par sëëb miech zaatne rnabey Dios, masaque naca zig rzëëb miech tib lo lni zaatne noyac tib guieḻtsieel. ’Tsii wnaa nguieg name, briee zho ziexinëz zho mgui ne ctsieelnia, tib tib zho bise zho psin win ne rec nceit ne rziini. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Gaay zho goc ligier pcodzëë zho zhipsin zho nceit, ni zhaaque bi zho zniipa; laa zgaay zho gocnroladz, zigne bzheṉse zho psin co scase bi zhow, bid zho nceit ne niodzëraaw. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","’Goc pa hora rio zhimcaalo zho, ni rdziṉdaque mgui ne ziexinëz zho ga, tibaque zeeṉ laa zho pquia mcaaḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Goḻ groḻ guieela, zeeṉ laa vis rac, laa mgui co ziaadle, zha ne ziexinëz me ga, zac griee zho tsiedzieel zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Lëëlëd briee mcaaḻlo gza wnaa nguieg co, psilo zho nozhixcuaa zho zhipsin zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Zeeṉe goṉ gza zha nroladz co ygaadraa zhinceit zho, dzigo bnab zho lo zgaay zha co, gdeed zho niip nceit yquiin zho, sac laa zhipsin zho noyuule. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pquiab zho rëb zho: “Grieeloda, sac miṉe yquiinse zhipsin no ziaadnie no. Mazd goḻtsie zaatne rto zhow, ga goḻtsiexiw.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Per lo lal ne ziexi zho nceit, laa mgui co bdziṉ. Zeeṉe wbire zho, laa ro yu nioogle, loxaque gza zha ne nsinle zo ga, zha cose bzëëb leṉ yu. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Dzigo psilo zho, rcaaṉ nia zho ro yu, rbedz zho mgui co cxal me ro yu sëëb zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Per bdeete me diidz nzëëb zho, rëb me: “Ruṉbeyd naa to goṉ, naṉd naa dieṉ cho nac to.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’¡Nsin sca goḻso! ―rëb Jesús―. Sac goṉ naṉde to pa dzepaa, pa horpagaa gbiire guiaad Mgui ne pxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Mgui ne pxeeḻ Dios ga, ziaad gac me zig tib meṉ ne no griee tsie tib viaj zit. ’Tib meṉ name no griee me tsie me tib guiedz zit, dzigo bredz me zha ne ruṉ dziin lo me, bdeed me palalga xtimi me lo zho guṉdziin zhow leṉ dze ne guieṉd me ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tib zho pcaania gaay mil pes plat, tib zho chop mila, stib zho pcaania tib mila. Tib tib zho, bdeedse me miṉe rgobey me grieelo zho guṉdziin zho, dzigo laa me briee laa me zie. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","’Zha ne biaaṉnie gaay mil pes plat co, güey zho bloonon zhow, beeṉa gan zgaay mila. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Zha ne biaaṉnie chop mila, ye zho güey zho bloonon zho dimi co, scaque beeṉa gan schop mila. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Laa zha ne pcaania tib mila ga, leḻ güey zho güeyteeṉ zho tib guieer güeyloliu zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Goc bla iza laa meṉ co bdziṉ, dzigo bredz me zho tib tib zho, tsie zho gzodiidz zho dieṉ yo dimi ne biaaṉnie zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","’Bdziṉ zha ne pcaania gaay mil pes plat co, bdziṉnie zho xtimi me, rëb zho: “Laa xtimi luu nu goṉ, lëë gaay mil pes ne psaṉ luu lo naa nu, laa zgaay mil miṉ rii nac miṉe bdziniaaw.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Rley me rëb me lo zho: “¡Zha squi nagoṉ racladz naa! Rley naa raṉ naa squitaa ndzinli luu, squitaa nguzobdiidz luu; sac goṉ lo palalse dimi ne psaṉ naa lo luu ga, bioxco luu zaacse beṉdziin luuw. Nana goṉ, nroobraa miṉe gnedz naa guṉdziin luu. ¡Na bded, zeeṉa ygaa luu grë guieḻbley ne quiayac nu!” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Blozh ga, bdziṉaque zha ne biaaṉnie chop mila ga, ye zho laa zho bdziṉnie xtimi me, rëb zho: “Laa xtimi luu nu goṉ, lëë chop mil pes ne psaṉ luu lo naa nu, laa schop mil miṉ rii nac miṉe bdziniaaw.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Pquiab me rëb me: “¡Squiw nagoṉ! Rley naa raṉ naa squitaa ndzinli luu, squitaa nguzobdiidz luu lo naa; sac goṉ lo palalse dimi ne psaṉ naa lo luu ga, bioxco luu zaacse beṉdziin luuw. Nana goṉ, nroobraa miṉe gnedz naa guṉdziin luu. ¡Na bded, zeeṉa ygaa luu grë guieḻbley ne quiayac nu!” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Zeeṉe bdziiṉtaa zha ne biaaṉnie tib mila ga, rëb zho lo me: “Nli beṉdziind naa xtimi luu, sac naṉle naa zha nac luu, niicle paraa niuṉdziin naaw, grëse miṉe niuṉa gan lo luu niaaṉa; ");
INSERT INTO zpmNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","gane mazd bialoliu naaw. Tib mil naca bneedz luuw, ledaaw nu.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Blëë guic me, rëb me lo zho: “¡Biche nu, paat rquiind naa miech yozh, miech nroladz ne squi nac! Conque naṉle luu sca nac naa, ");
INSERT INTO zpmNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿pex nac dzigo waa bioxcod luu maase mbediiṉ luu dimi qui, ndziniaaw palal ncaania naaw niina?” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dzigo rëbchaa me lo zha ne ndxie ga: “Niinagazh goḻcob tib mil pes qui lo zha qui, goḻdeeda lo zha ne ziaadnie tsiiw i. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sac zha ne rioxco ruṉdziin ncuaaṉe rcaania zho, zacnroobraa ncuaaṉe yquianie zho. Laa zha ne squi nac, haxta miṉe pcaaniale zho, zdiooba lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Goḻxeṉ zha yozh qui, goḻtsiesaṉ zho lo ncow nëz ley. Ga gaṉ zho guieḻnëdox ne tsieguiaḻ zho, ga goon zho haxta gow lay zho.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Blozhse bzodiidz Jesús cuent co lo zho, rëbchaa me: ―Naa ne nac naa Mgui ne pxeeḻ Dios, zeeṉ gaḻ dze ne laa naa guiaḻ stib, ziaḻnie naa grë xanjl naa, zlu grëtaa guieḻndzon ne rap naa, laa naa sob lo xcan ne raguiaḻ naa soob naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Grëse miech ne ndxie dibdoose lo guidzliu, hor co laa zho gacredz lo naa, laa naa cueextso zho zig rbeextso baxtor chiv lad xpëcwxiil zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Zha ne no xnëz naa, zha co gdziṉ naa cue naa nëz derech, laa zha ne nod xnëz naa, cue nëz revés. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’Lozhse ga, naa ne nac naa meṉ ne rnabey, hor co laa naa cuedz zha ne no xnëz naa, guiep naa lo zho: “Goḻtë grëse to, to ne nac to zha ne nziuu lo Pxoz naa. Goḻted zeeṉa ycaania to zaatne cuëz to, ible par to bzaa mew desde zeeṉe bzaa me guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sac zeeṉe pcaabedz naa, bneedz to ncuaaṉe dow naa; zeeṉe bnab zhis naa, bneedz to ncuaaṉe go naa; zeeṉe biaḻ naa ladz to, bneedz to lidz to blëz naa; ");
INSERT INTO zpmNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","zeeṉe goṉ to guieṉd xab naa, bgacwxab to naa; zeeṉe bzhacnë naa, zeeṉe bio naa ladzguiib, biaad to biaadgaṉ to naa.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","39","See zdoo zho gnë zho: “¿Per pa hor bneedz no ncuaaṉe doow luu, ncuaaṉe go luu, pa hor bneedz no zaatne blëz luu, pa horgaa bneedz no lar ne gotxab luu, ib bdzioṉd no nzhaacnë luu, bdzioṉd no niogaa luu ladzguiib?” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","’Dzigo guiep naa lo zho: “Gzobtaa hor ne goṉ beeṉ to xyudar zha ne nacgrë to, güeygaṉ to zho, pcaaniagaa to zho, niicle zha ne bzoob miech peet nonda, rrieequia xyudar naa ga beeṉ to, rrieequia naa ga biaadgaṉ to.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Laa zha ne ndxie nëz revés, hor co laa naa gzonëz zho, guiep naa lo zho: “¡Goḻbiche lo naa nu, miech ndziibdee! ¡Goḻsë lo guidox ne rieguiaḻ to, zaatne no guey meṉdox grë xanjl ma! ");
INSERT INTO zpmNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sac goṉ, bio dze pcaabedz naa ni bneedzde to ncuaaṉe niow naa; bnab zhis naa, ni bneedzde to pe nie naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Biaḻ naa ladz to, ni bneedzde to zaatne mbëz naa; goṉ to guieṉd xab naa, ni ni tib lë lar bneedzde to niacw naa. Bio naa ladzguiib, bzhacnë naa, ni pe liaadz to niaadgaṉ to naa.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Squiab zho gnë zho lo naa: “Per pa hor bdzioṉ no luu rcaabedz luu, rnabgaa zhis luu; pa hor bdzioṉ no guieṉd pa cuëz luu, guieṉd lar ne gacw luu; pa horgaa bdzioṉ no no luu ladzguiib, nixgaa luu rzacnë luu.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","’Dzigo guiep naa lo zho: “Grëse vuelt ne bzoliaadz to niuṉ to xyudar zha ne no xnëz naa, bzoliaadz to niegaṉ to zho niicle zha ne mazdraa wina, rrieequia naa ga sca beeṉ to.” ");
INSERT INTO zpmNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","’Horco grëse zha co laa zho guey lo guidox ne gdziṉdraa dze griee zho; laa zha ne bioxco wban zigne rnabey naa, grëse zho laa zho ygaa tib guieḻmban ndzon ne gdziṉdraa dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Zeeṉe blozh sca bnee Jesús lo grë miech co, dzigo rëbchaa me lo xpëëdscuel me: ");
INSERT INTO zpmNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Naṉle to gaṉle schopaque ngbidz, laa lni Pascw csilo. Naa ne nac naa Mgui ne pxeeḻ Dios, lo lni co goṉ gnaaz miech rii naa, tsielo zho naa ladznia zha ne yquiaa naa lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Grë zha ne nac pxoz ne rnabey, grë maistr ley ni grë zha ne nac meṉ non lo meṉ guiedz Israel, lëëtaque hor co laa zho ndxie lidz Caifás, meṉ ne nac pxoz nroob. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Laa zho ndxie ga, nonediidz zho dieṉ zha grieelo gnaaz zho Jesús, gut zho me, per tib mod ne grieelod glisqui meṉ guiedza. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Rnee zho: “Lëëraasi choot gnabeyd ygaa me merpaa dze lni, zeeṉa gacntseebd meṉguiedz.” ");
INSERT INTO zpmNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betain ga no tib meṉ ne biac lo guiedz lepr, lë Simón. Lëëtaaque no Jesús lidz meṉ co, ");
INSERT INTO zpmNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","zeeṉe bdziṉ tib wnaa bdziṉnie tiblo nceit nex, nosew tib leṉ ncuaaṉ win niaa niapse quie rbebni, tiblo nceit niazha. Squi zob Jesús lo mezh, güey wnaa co güeychoob me nceit co guic Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Zeeṉe goṉ xpëëdscuel Jesús sca beeṉ wnaa co, blëë zho, rnee zho: ―¡Pa rieguiaḻa squi pxiṉ zhlë wnaa qui nceit qui! ");
INSERT INTO zpmNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Teḻ niaca miṉe ndow, pe zhidaa dimi ne nguizh zhow, nquiinpaa dimi co ngaaza lo grë zha ne guieṉd pe yquiin. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Goṉ Jesús sca rac zho, dzigo rëbchaa me lo zho: ―¿Pe nacne rlëë to lo wnaa qui? Goḻsaan me. Par naa nroob non miṉe beeṉ me i. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Teḻ nli lëë racladz to guṉ to xyudar zha ne guieṉd pe yquiin, zac ygad to lo zho stib dze, sac tibaque raṉ to zho; saṉgue naa zhile laa naa gbiche lo to. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Led pxiṉ zhlëd wnaa rii zhinceit me, sac goṉ rrieequia laa me bzhixcuaale xcuerp naa nu gaḻ dze ne ygueetsa. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Gneli naa lo to gaṉle, dipse lo guidzliu zaatne cseedtaa miech Xtiidz Dios, ible soladz zho wnaa rii, seet zho miṉe beeṉ me nu. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Lo gza tsiipchop zha ne nac xpëëdscuel Jesús ga, briee zha ne lë Judas Iscariot güeyzodiidznie Judas grë zha ne nac pxoz ne rnabey, ");
INSERT INTO zpmNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","rëb Judas lo zho: ―¿Palal quizh to naa teḻne guṉ naa Jesús ntregar lo to? Dzigo biaaṉ zho diidz quizh zho Judas gaḻptsii pes plat. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nacne psilo Judas noguib Judas dieṉ zha gdeeda diidz csaṉ Judas me ladznia zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mer dze ne rsilo lni Pascwa, leṉ dze ne sca row zho guietxtil ne riotsd ncobi ga, bnabdiidz xpëëdscuel Jesús lo me dieṉ pa lo racladz me tsieguṉlo zho ncuaaṉe gowxtseenie me zho wdze co. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Dzigo rëbchaa me lo zho: ―Naṉle to gaṉle cho lidz zrieelo gdziṉ ne. Goḻtsie Jerusalén goḻguiab lo zho: “Znu në xmaistr no: Gneedz luu lidz luu me dioow no xtsee Pascw rii. Niinataa laa xtse me bdziṉ, gane racladz me lidz luu nu diowxtsee no nawdze grë no me.” ");
INSERT INTO zpmNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dzigo laa zho zie. Güey zho zaatne pxeeḻ me zho ga, ga beeṉlo zho xtsee co. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Wdze co, laa me no xtsee grë me zho, zeeṉe bnee me lo zho rëb me: ―Gacnaṉ to gaṉle, lëëque tib to goṉ tsielo naa ladznia zha ne gnaaz naa nawdze rii. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Zeeṉe bin zho sca rëb me, mbanse rac zho, dzigo psilo zho tibga tibga zho rnabdiidz lo me, rnee zho: ―Bnë dieṉ, ¿cho guṉ miṉ co? ¿Pe naaw? ");
INSERT INTO zpmNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Pquiab me rëb me lo zho: ―Zha ne gaṉ to csëëb xcuuṉ leṉ xquien naa, lëë zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Naa ne nac naa Mgui ne pxeeḻ Dios, niina laa miech gut naa zigne raquietsew lo Xtiidz Dios; per, ¡probsaxe zha ne tsielo naa ladznia zho! ¡Mazd wen nie zho, ib niacd zho miech lo guidzliu! ");
INSERT INTO zpmNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yeze Judas rnabdiidz lo me rnee Judas: ―Maestro, ¿pe gooṉ naaw ye? Rëbchaa me lo Judas: ―Luuw goṉ Judas, luu güeyto naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Laa zho noyow, zeeṉe bzheṉ Jesús tib guietxtil, bdeed me xquizh lo Dios, blozh ga beeṉgroḻ mew, dzigo bdiiz mew lo zho, ni rëb me: ―Goḻquiina, lëë xcuerp naa i goṉ. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ni bzheṉ me tib cop nroob vin, bdeed me xquizh lo Dios, blozhse bdeed me xquizh, dzigo pteed me cop co lo zho grëse zho, rëb me: ―Goḻguie vin qui, ");
INSERT INTO zpmNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","sac lëë xchen naa i, miṉe no gzhiee par guiaaṉmbe grë miech lo xtoḻ zho sëëb zho xnëz Pxoz naa, sac lëë stib mod cub nu psaṉ me parne sëëb miech xnëz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lëë lultm vuelt nu guie naa vin rii, sac zhaale stib vin cub ne guie naa gaḻ dze ne guienie naa tow zaatne rnabey Pxoz naa. Dzigo psilo me biiḻnie me Dios gza me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Blozhse biiḻnie zho Dios, laa me briee ga gza me zho, laa me zienie zho nëz Gui Oliv. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","―Ible saan to naa nawdze rii ―rëb me lo zho―, sac scale ziaad lo Xtiidz Dios zaatne rnee: “Zdeed Dios diidz csiwee zho baxtor, lozh ga nëzrii nëzrec gliaaḻ mëcwxiil.” ");
INSERT INTO zpmNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Miṉcopaa nagoṉ guṉ miech naa, per zeeṉe laa naa grieeban glole naa ga Galilé, ga cuëz naa to. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dzigo rëbchaa Pedr lo me: ―Niicle teḻne saan grë zha qui luu, saṉgue naa goṉ csaand naa luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pquiab me rëb me lo Pedr: ―Gneli naa lo luu gaṉle, guieel riigazh, gardle ycuedz gall, laa luu csale tsoṉ vuelt guiab luu ruṉbeyd luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Per tibaque nac xtiidz Pedr, rnee Pedr lo me: ―Niicle teḻ zaatne guet luu guet naa, per guṉscad naa. ¿Pe nacne guiep naa ruṉbeyd naa luu? Scaque rnee grëraa xpëëdscuel me. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Zeeṉe bdziṉnie Jesús zho zaatne lë Getsemaní, dzigo rëbchaa me lo zho: ―Nuse nagoṉ goḻsob, laa naa ga gazodiidznie naa Pxoz naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Horco psilo mban rac zdoo me, riabguieḻnë me, dzigo bredz me Pedr, ni grop xingan Zebedé, bzënie me zho palal ");
INSERT INTO zpmNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","dzigo rëbchaa me lo zho: ―Mban rac zdoo naa, zootle zig zet naa lo guieḻnë rii. Nuse nagoṉ goḻguiaaṉ, per goḻsobna. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bzë me spalal, dzigo pquiitsgzhib me haxta bdziṉ lo me lo liu; psilo me bnab me lo Dios, rëb me: ―Papá, laa naa rnab lo luu, teḻne zala zdoo luu, bzhiguieḻ psilaa naa lo grë guieḻnë rii. Miṉ rii rnab naa lo luu, per teḻne grieeloda, miṉe gnëtaa luu, miṉ co gac. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Zeeṉe guso me, güey me zaatne biaaṉ gza tsoṉ zha co, goṉ me laa zho nixguiesle; dzigo rëbchaa me lo Pedr: ―¿Pe ni palal blëbde to nzobna to? ");
INSERT INTO zpmNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Goḻsobna, goḻnab lo Dios zeeṉa yquiild meṉdox to. Niicle ne squi lëbdraa xcuerp to sobna to, per goḻnab lo Dios, sac goṉ miṉ co nac miṉe racladz zhiespíritu to. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Dzigo güey me stib, güeyzodiidznie me Dios; scaque miṉe bnab me glo miṉcoque bnab me. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Zeeṉe wbiire me bdziṉ me lo zho, goṉ me laa zho nixguieslaque, sac lëbdraa zho mcaaḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wbiire güey me güeynab me lo Dios, scaque miṉcoque bnab me. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Zeeṉe laa me wbiretaa bioṉ vuelt co, rëbchaa me lo zho: ―Lëëw nagoṉ, zacle na gaguies to, zacle gdziiladz to. Naa ne nac naa Mgui ne pxeeḻ Dios, laa hor nagoṉ bdziṉ zeeṉe laa grë miech ntseeb rii guiadnaaz naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Goḻtsieso, zeeṉa zio ne; sac goṉ laa zha ne glu naa lo zho ziaadle nu. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Laa Jesús bii quianeeque, zeeṉe laa Judas (tib zha ne nac xpëëdscuel me) bdziṉ, bdziṉnie Judas tib dzoon zha ne pxeeḻ grë pxoz ne rnabey, ni grë zha ne nac zha non lo meṉ guiedz Israel. No zho nzheṉ spad, nogaa zho nzheṉ yag. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Biaaṉniele Judas zho diidz zha glu Judas cho nac Jesús, rëb Judas lo zho zha ne gaṉ zho gow Judas bzhid cuas, lëë me ga, ligier so zho gnaaz zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Zigne bdziṉ Judas pquiaabdiuzh Judas me, blozhse ga wbig Judas dow Judas bzhid cuas me. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dzigo rëbchaa me lo Judas: ―Judas, ¿pe ziaadguṉ luu nu? Lëëlëd wbig be grë zha co, bzheṉ zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Horco biet tib zha ne rzënie me ga, bdob zho zhispad zho psilaa zho tib niaw, bliengaa zho diag tib zha ne rquia xtsiiṉ meṉ ne nac pxoz nroob. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dzigo rëb Jesús lo zha ne pquiaaw ga: ―Blootsow zhispad luu, ib guṉdraa luu squi cob luuw. Sac goṉ zha ne rdiḻ con spad, noxtseeb ne low guet zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Niacxe naṉ to na grieelod gnab naa lo Pxoz naa niina cxeeḻ me tsiipchop partid xanjl me guiaadla ne nu? ");
INSERT INTO zpmNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per teḻne sca guṉ naa, ¿zha dzigo gac miṉe zhobnee lo Xtiidz Dios, zaatne raquiet miṉe noyac nu? ");
INSERT INTO zpmNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dzigo rëbchaa me lo grë zha ne bdziṉ ga: ―¿Pe nacne squitaa rac to? ¿Niacxe naa cho zha ntseeb, ne squitaa nzheṉ to spad, nzheṉ to yag ziadnaaz to naa? Blactaa name goṉ to noseed naa miech leṉ yadoo, ¿pe nacne bnaazde to naa ga? ");
INSERT INTO zpmNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per ible laa grë ncuaaṉ rii goṉ noyac, zeeṉa grieequia grë miṉe bzeet grë zha ne biadteed xtiidz Dios lo miech padzeela. Horco grëse zha ne nac xpëëdscuel me laa zho bzhooṉ, tipse me psaṉ zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ga brieenie zho Jesús bdziṉnie zho me lidz Caifás, meṉ ne nac pxoz nroob. Grë zha ne rnabey lo meṉguiedz Israel, laa zho ndxiele ga. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ye Pedr maase zit zit naḻ Pedr laa Pedr bdziṉ xley meṉ co. Bdziṉ Pedr güeysobga Pedr lo grë zha ne ndxienap, quiambëz Pedr dieṉ zha guṉ zho Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Grë pxoz ne rnabey, grë zha ne nac zha non lo meṉguiedz, grëse zha ne nac wxtis, laa zho ndxie nëz leṉ yu co, quiaguib zho zha ne gzhixcuaa maase diidzguizh ycaadz zho Jesús, parne gdeeda diidz gnab zho guet me. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ndal zha ne sca beeṉ, per brieequiad xtiidz zho, sac zhaase zhaase rnee zho. Tibaque zeeṉe guso chop zho, ");
INSERT INTO zpmNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","rëb zho: ―Bdzioṉ no goṉ rnee me laa me ctixche yadoo ne zob lad guiedz nu, zaatne riodziaṉ ne Dios, lozh ga tsoṉaque ngbidz gzaalo me stiba. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dzigo hor co bzoli meṉ ne nac pxoz nroob, rëb me lo Jesús: ―¿Pe nacne rquiabd luu? ¿Pe nli sca rnee luu, te nlida ye? ");
INSERT INTO zpmNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Goṉ pxoz nroob co rquiabdaque Jesús, rëbchaa me: ―Zig zob Dios mban ne no gbaa, laa naa rnab lo luu bneeli lo no dieṉ cho nac luu. Bnë teḻ nli Xpëëd Dios nac luu, Meṉ ne zëëble diidz ga cxeeḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Dzigo pquiab Jesús rëb me: ―Scaw goṉ, naa nac meṉ co. Naa ne nac naa Mgui ne pxeeḻ Dios, bii zaṉ to gaṉle zeeṉe laa naa zoob cue Dios nëz derech, ni zeeṉe laa naa guieet gbaa ziaḻzëëb naa lo xcow. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Horco ptsiez pxoz nroob co xab me, sac blëë me bin me sca rëb Jesús. ―¿Pe mazdraa textigw ne racladz ne? ―rëb me―. Laa to binle gaṉle zha rzëtaa xtiidz me noguitnie me Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nana waa, ¿pe gnë to zha dziuuṉ ne me? Pquiab be zho rëb zho: ―¡Ib rieguiaḻ guet me! ");
INSERT INTO zpmNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dzigo hor co psilo zho nosacsi zho me. Zha ne rtsuc lo me, zha ne rdeed puñet me, nogaa zho rgap lo me, ");
INSERT INTO zpmNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","rlozh ga rzhidznie zho me rnee zho: ―Luu ne nac luu meṉ ne pxeeḻ Dios, ¿bnë dieṉ cho ga bdiṉ luu? ");
INSERT INTO zpmNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Horco laa Pedr bii zob nëz ley. Ga zob Pedr, güey tib ndzoop ne quia dziin lidz meṉ rnabey co; rëb ndzoop lo Pedr: ―¿Ye luu lëë rzënie Jesús, meṉ Galilé ne bdziṉnie zho i? ");
INSERT INTO zpmNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per bneelid Pedr. Squi zob grë zha co, rëb Pedr: ―Rieṉd naa dieṉ cho meṉ rnee luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Laa Pedr ziele nëz ro puert ne quia ro nëz, zeeṉe goṉ stib ndzoop ne rquia dziin ga Pedr, rëb ndzoop lo zha ne ndxie ga: ―Ye mgui qui goṉ nacgrë meṉ Nazaret ne bdziṉnie zho i. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Scaque bneelid Pedr, haxta rzeet Pedr Dios rëb Pedr ruṉbeyd Pedr me. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wdzeepaaw, rëb zha ne ndxie ga lo Pedr: ―Ne nligaa ye luu rzënie meṉ ne bdziṉ i. ¡Rlupaa name zig rnee zha nëz Galilé rnee luu! ");
INSERT INTO zpmNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dzigo psilo Pedr rzeet Pedr Dios rnee Pedr ruṉbeyd Pedr Jesús, haxta rnee Pedr: ―Dios zobwi gaṉle, teḻne led diidzlid nu rne naa, maase cuibdee naa. Loxaque blozh sca briee ro Pedr zeeṉe laa tib gall pcuedz. ");
INSERT INTO zpmNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Horco psoladz Pedr xtiidz Jesús zeeṉe rëb me lo Pedr: “Gardle ycuedz gall, tsoṉle vuelt rëb luu ruṉbeyd luu naa.” Dzigo mbanse rac Pedr. Briee Pedr ga, psilo Pedr biin Pedr guieḻnë co. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ziadyiinile liuw, wbiire pcaalsa grë pxoz rnabey, grë zha non lo meṉguiedz, bnediidz zho dieṉ zha gnabey zho guet Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Blozhse bzodiidz zho, dzigo laa zho bzobdoo me blee zho me ga ziesaṉ zho me lo Pilat, meṉ ne nac gobernador. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Laa Judas Iscariot zha ne pto Jesús ga, zeeṉe bin Judas laa zho rnab guet me, lëëlëd güey Judas lo grë pxoz rnabey co, lo grë zha non lo meṉguiedz ga, zietsire Judas dimi ne bdiizh zho Judas ga. Mban rac Judas, ");
INSERT INTO zpmNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","bdziṉ Judas rëb Judas lo zho: ―Naraa rieṉ naa lëda nu beṉ naa. ¡Tib doḻ nrooble nu, znu biaḻto naa tib meṉ ne peet xtoḻd! Pquiab zho rëb zho: ―¡Miṉcotaa goṉ ndioṉd no! ¡Xcuentzhe luu ga! ");
INSERT INTO zpmNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Horco pcheḻ Judas dimi co leṉ yadoo. Lo guieḻnë co briee Judas ga güey Judas lëëque Judas pxiiyaṉ Judas. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Grë zha ne nac pxoz rnabey ga, güey zho ptop zho dimi co. Per blozh ga, rieṉd zho dieṉ zha guṉ zhow. ―¿Zha dziuuṉ ne dimi rii? ―rëb zho―. Teḻne guiaaṉa yadoo, per rdzieelda, sac goṉ xchen tib miech bdzëëw. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dzigo bzodiidz zho dieṉ zha gaca, nacne mazd pquiin zhow bzhii zho tib lë liu, zaatne rdieeṉ yu ne riaa grë ncuaaṉ psin ne rquiin; parne lo liu co ygueets grë zha zit ne guet Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nacne brieelë liu co “Liu ren”, ni sca ruṉbey zhow leṉ dze rii. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ga brieequia miṉe bzeet zha ne biadteed xtiidz Dios padzeela, zeeṉe rëb zho: “Gaḻptsii pes plat ne bzhii zha Israel meṉ nziuu co, dimi co bzhii zho tib lë liu, zaatne rdieeṉ yu ne riaa grë ncuaaṉ psin ne rquiin. Sca në Dios lo naa.” ");
INSERT INTO zpmNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bdziṉnie zho Jesús lo Pilat, ga bnabdiidz Pilat lo Jesús rëb Pilat: ―Bnë dieṉ, ¿pe nli luu nac zhirey zha Israel? Pquiab me rëb me: ―Nliw. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Grë zha ne nac pxoz rnabey ga, ni grë zha ne nac zha non lo meṉguiedz, rzadraa ncuaaṉe rquiaqui zho me; per ni tib diidz rtsired me lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dzigo rëbchaa Pilat lo me: ―¿Pe nacne rquiabd luu? ¿Pe ib rond luu grëtaa ncuaaṉe rquiaqui zho luu i? ");
INSERT INTO zpmNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bzee zdoo Pilat goṉ Pilat, ible rquiabd me. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gzobse iz, zeeṉe raḻ lni Pascw rnabey Pilat rlaa tib zha ne no ladzguiib, zha ne gnabtaa meṉguiedz laa. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Leṉ dze co no tib zha ntseeb ladzguiib lë Barrabás, zëëb xtiidz zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nacne rëb Pilat lo grë zha ne ndxie ga: ―¿Cho racladz to csilaa naa? ¿Pe silaa naa Barrabás, te silaa naa Jesús ye, meṉ ne nac diidz pxeeḻ Dios lo to? ");
INSERT INTO zpmNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sca rëb Pilat sac bieṉ Pilat loxaque porne ndal miech nobig lo Jesús miṉ co ne rlëënie zho me, bnabey zho bgaa me. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Laa Pilat zob lo xcan ne ruṉ me guieḻwxtis, zeeṉe bdziṉ tib mandad rëb lo me: ―Znu në tsieel luu: bzhiguieḻ me peet guṉd luu meṉ qui, rlu peet xtoḻd me; sac nieewdze me nroob ptseb mcaaḻ tsieel luu. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Grë zha rnabey co, bio zho pquiil zho meṉguiedz gnab zho csilaa Pilat Barrabás, ni gnab zho guet Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Zeeṉe wbiire Pilat bnabdiidz Pilat stib, dieṉ chopaa racladz zho laa, grëse zho nguiedz pquiab be zho, rëb zho: ―¡Barrabás psilaa! ");
INSERT INTO zpmNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dzigo rëbchaa Pilat: ―Meṉ ne waa nac diidz pxeeḻ Dios lo to nu, ¿zha guṉ naa me? Pquiab zho rëb zho: ―¡Bnabey yquia me lo cruz! ");
INSERT INTO zpmNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","―¿Per pe nacne yquia meṉ rii lo cruz? ―rëb Pilat―. ¡Ni tib doḻ rapd me! Biireque zho nguiedz roptsie zho rnab zho yquia me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Goṉse Pilat rquiaadiagd zho xtiidz me, leḻ mazdraa rac zho, dzigo bnab me nis, squi ndxie zho bdiib me nia me, rëb me lo zho: ―¡Naṉle to nasca, led xtoḻdraa naa nu ne laa xchen meṉ rii gzhiee, sac naṉpaa naa peet falt rapd me! ");
INSERT INTO zpmNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pquiab be zho rëb zho: ―¡Peet nacd ga! ¡Zhits no grë xpëëd no cuib doḻ co, na no guiotizha! ");
INSERT INTO zpmNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dzigo bnabey Pilat blaa Barrabás, laa Jesús racse me bnabey me zha ne bdiṉ Jesús, blozhse ga laa me psaṉ Jesús ladznia meṉguiib ne tsiequiaa me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Biire grë meṉguiib co bzëëbnie zho me nëz leṉ yulow, ga pcaalsa grëraa meṉguiib ne nacgrë zho, briṉ zho igose me. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Blee zho xab me, bgacw zho me tib lar nizhnie nlaan, zig rna lar ne racw grë rey, ");
INSERT INTO zpmNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","bzieecw zho bla lë yag guiets, bzoob zhow guic me zig rzob coron guic zha ne nac rey, ni bloo zho tib lë goobgui nia me. Ruṉnguzee zho me, rquiitsgzhib zho lo me, rnee zho: ―¡Goḻwi gaṉle zha ractaa zhirey zha Israel! ");
INSERT INTO zpmNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","No zho rtsuc zho lo me, rgob zho goobgui ne no nia me ga, rdeed zhow guic me. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Blozhse sca bdziitnie zho me, blee zho lar nizhnie co lad me, bgacw zho me xab me stib, dzigo laa zho brieenie me ga zienie zho me zaatne yquia me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nëz zienie zho me bdzieel zho tib meṉ Ciren lë Simón, bnabey zho meṉ co bi me zhicruz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Zeeṉe bdziṉ zho zaatne nac “Gui Beerguic Ngutoo” (Gólgota), ");
INSERT INTO zpmNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ga bdeed zho nziu lo me notsa tiblo guizh nlayag, per zeeṉe pquiaaro mew bieṉ me nziu cow, bnëd me nie mew. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","36","Blozhse pquiaa zho me lo cruz, bzheṉ zho tib xab me pchug zhow biaaṉnie zho tib lëgaw, laa stiba bio zho rif; dzigo laa zho bzob ga, bzobnap zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Guic zhicruz me, ga pquiaa zho bla lan diidz zaatne rnee: “LËË JESUS NU, MEṈ NE NAC ZHIREY ZHA ISRAEL.” Sca pquiaa zho, sac miṉco pquiaqui sca pquiaa zho me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ye chop ngbaan pquiaagza zho me lo cruz, tibga zhicruz zho bzo tib nëz cho zhicruz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Grëse miech ne rdedtaa raṉ zho laa me quia ga, rzhidznie zho me, haxta rdzi zho guic zho ");
INSERT INTO zpmNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","rnee zho lo me: ―Led rëb luu lëë laa luu ntsiḻ yadoo, ni tsoṉaque ngbidz nzaalo luu stiba, ¿pe nac dzigo rrieelod luu guieet luu i? Teḻne nli Xpëëd Dios nac luu, biet lo qui. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Scaque grë pxoz rnabey, grë maistr ley, grë zha farisé ni grë zha ne nac zha non lo meṉguiedz, rzhidznie zho me, rnee zho: ");
INSERT INTO zpmNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Stib miech scataa beeṉguiac me, stib miech scataa bla me, ¿pe nac dzigo rrieelod me gla me me? ¡Gooṉ me name nac zhirey ne, guiet me i sca zho; zeeṉa dziuuṉbey ne meṉ rnabey nac me! ");
INSERT INTO zpmNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","¡Conque tant rnalo me Dios, haxta rnee me Xpëëd Dios nac me, guiaadsilaa Dios me i nazho! ");
INSERT INTO zpmNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ye ngbaan ne quiagza me lo cruz ga, miṉcoque rbidzgo zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Zig groḻ dzew, tibaque zeeṉ goc tib ncow dipse lo guidzliu, haxta las tres biaa biini stib. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Horco nguiedz zëëb tsi Jesús, rnee me: ―Elí, Elí. ¿Lama sabactani? Diidz co nac zig nac ne rnee ne: Luu nac xDios naa, luu nac xDios naa. ¿Pe nacne psaan luu naa? ");
INSERT INTO zpmNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Zha ne ndxie ga, zeeṉe bin zho sca rbedz me, no zho rëb Lí, meṉ ne biadteed xtiidz Dios padzeela, meṉ co rbedz me. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dzigo rias tib zho güeygadz tib lë zhiil lo nziu bla, bzoob zhow tib guic goobgui pquiaa zhow ro me. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Laa zla zho rnee: ―Psaan, nu dziaṉ ne dieṉ pe ziaad Lí guiaadlit Lí me i. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tibaque zeeṉe pquiaa me stib redz nroob, znuse blozh me. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Horne nolozh me ga, hor co briez nzoli lar nroob ne quia leṉ yadoo, groḻtaa goca; psilo bni tib zhodox, grë quie masaque wbiḻa, ");
INSERT INTO zpmNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","nzian ro baaṉ grë zha ne bnalo Dios mazd padzeela bzhial. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Zeeṉ goḻ dze ne brieeban me, ye zho laa zho brieeban, briee zho leṉ baa, bzëëb zho lad guiedz; nzian miech ne goṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Grë meṉguiib ne quianap me ga, ni zha ne rnabey lo zho, zeeṉe goṉ zho bni zho co, ni goṉ zho grë ncuaaṉe goc ga, per nli bdzieb zho. ―¡Ne nlipagaa ―rnee zho―, Xpëëd Dios nac meṉ qui! ");
INSERT INTO zpmNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nzianlaa meṉ wnaa, zit zo zho rwi zho. Lëë grë meṉ wnaa co güeynaḻ zhits Jesús, beeṉ zho xyudar me dipse leṉ dze ne pseed me miech, desde dze ne psilo me nëz Galilé. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lad co no Marí Magdal, Marí tsieel Zebedé, ni Marí ne nac xniaa Jacob grop José. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Zhile sëëb ngbidza, zeeṉe bdziṉ tib mgui lë José lo Pilat, bnab me diidzbey tsielit me xcuerp Jesús lo cruz; tib zha ricwa, meṉ guiedz Arimaté nac me, ye me zienaḻ zhiwseed Jesús. Nacne pxeeḻ Pilat diidz lo zha ne quianap Jesús ga, parne siguieḻ zho glit José me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dzigo güey José. Blozhse blit José me lo cruz, laa José neyle tib lë lar cub, pcheḻ José me lar co, ");
INSERT INTO zpmNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","güeyxob José me tib leṉ baa ne naccheṉ José ndieeṉ tib cho quie gax ga; tib baa cuba. Blozhse bdzig José tib quie nroob bioog ro baa co, laa José zey. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Laa Marí Magdal bii biaaṉ ga, grop me stib Marí ne nacgrop me ga; zobse zho gax ro baa co. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Biini liu co, pcaalsa grë pxoz rnabey, grë zho zha farisé, güey zho lo Pilat, ");
INSERT INTO zpmNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","rëb zho: ―Guṉ luu dispensar, laa no ziaadaque lo luu stib. Naraa rsoladz no, leṉ dze ne bii mban meṉ ntseeb ne sca biaadquidie miech ga, rëb me, zeeṉe gac tsoṉ ngbidz guet me laa me grieeban. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Gane ziaad no lo luu, bzhiguieḻ pxeeḻ zha ne yquiaanap ro baaṉ me haxta gac tsoṉ ngbidz co; sac nend tsie zha ne nac xpëëdscuel me tsiebee zho me, lozh ga guiab zho laa me brieeban. Naṉle luu gaṉle, teḻ gac miṉ co, cho gnë peraa gzhixcuaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dzigo rëbchaa Pilat lo zho: ―Teḻne sca racladz to, laa tib partid meṉguiib ndxie i. Goḻtsienie zho, goḻguiab lo zho yquiaanap zhow teḻ zha racladz to. ");
INSERT INTO zpmNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dzigo laa zho zie zienie zho grë meṉguiib co. Bdziṉ zho bloo zho tib bey cho quie ne nioog ro baaṉ Jesús ga, par glu teḻ cho zha ne tsiegaaḻa, ni biaaṉ grë meṉguiib co yquiaanapa. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Zna dze goc dze ne rdziiladz zho lo dziin ga, biini liu, dze ne rsilo zhmal, silgaw zie Marí Magdal grop me stib Marí co zieso zho ro baaṉ Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lëëtaaque hor co bni tib zhodox, lo zho co biet tib xanjl Dios gbaa bdob me quie nroob ne nioog ro baa co, bdiix mew tib lad, bzobga me lada. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Masaque rlu me zigne rlu belye, xab mew, nquitsbie rnaw, zig rlu zaatne ndxie guieg. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Grë meṉguiib ne quianap ro baa ga, zeeṉe goṉ zho anjl co, per nli bdzieb zho, rzhidz zho. Lo dzeb co, pcowgazh zho, grëse zho biab liu. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Zeeṉe laa grop wnaa co bdziṉ, rëbchaa anjl co lo zho: ―Gdziebde to. Naṉle naa Jesús meṉ ne pquiaa zho lo cruz ga, meṉ co ziaadguib to. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Per guieṉdle me nu, ¡laa me brieebanle zigne bneele me ga! Goḻwi gaṉle nu nac zaatne pxob zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Niinagazh goḻtsie goḻtsienie diidz lo xpëëdscuel me, goḻguiab lo zho laa me brieebanle. Galilé me cuëz me zho, ga gaṉ zho me. Laa to naṉlew nasca. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lëëlëd briee grop wnaa co ga, rias zho laa zho zienie diidz lo xpëëdscuel me; lala rdzieb zho, ni lala rley zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Laa zho zie, tibaque zeeṉe goṉ zho laa Jesús zole lo zho, iṉe pquiaabdiuzh me zho. Horco wbig zho pquiitsgzhib zho lo me, bdeedz zho ni me. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dzigo rëbchaa me lo zho: ―Gdziebde to. Goḻtsie goḻtsienie diidz lo grë zha bets naa, goḻguiab lo zho tsie zho Galilé, ga gaṉ zho naa. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Horcoraa laa bla zhaguiib ne pquianap ro baaṉ Jesús ga bdziṉ lad guiedz. Güey zho lo grë pxoz rnabey, bzodiidz zho zha goṉ zho bzhial ro baa co. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Dzigo pcaalsa grë pxoz co grë zho zha ne nac zha non lo meṉguiedz, dieṉ zha guṉ zho. Nacne biaaṉ zho diidz, mazd gdeed zho dimi lo grë meṉguiib co, parne gneelid zho, sinque guiab zho, segur xpëëdscuelaque me güeybee me leṉ baa, per bieṉd zhow sac nixguies zho. Nroob dimi bdeed zho lo grë meṉguiib co, ");
INSERT INTO zpmNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","rëb zho: ―Peet tsienied guic to, niicle teḻne gon gobernadora na no guionee lo me, zeeṉa peet guṉd me to. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dimi co pcaania zho, dzigo laa zho psilo pxooṉ diidz co zigne rëbse grë zha co lo zho. Grë zha Israel ne bina leṉ dze co, masaque bliladz zho nli sca goca, ¡ni haxta lo nadze sca zienie guic zho! ");
INSERT INTO zpmNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Zeeṉe bdziṉ dze ne gdzieelo Jesús xpëëdscuel me nëz Galilé, briee gza tsiiptib zha ne bzo gaxpaa lo me ga, güey zho nëz co; bdziṉ zho guic gui ne rëble me ga gdzieelo me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Zeeṉe goṉ zho me pquiitsgzhib zho liu. Lo grë zha ne ndxie ga, no zho rieṉpaa lëë me ga, nogaa zha ne bii racchop guic. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dzigo wbig me lo zho, rëb me: ―Laa to goṉle nasca naa rnabey. Grëse ncuaaṉe no gbaaw, nogaa guidzliuw, ladznia naa psaṉ Pxoz naaw. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Niina nagoṉ, laa naa rsaṉ diidz lo to: goḻtsie dipse lo guidzliu, goḻtsieseed miech gac zho zha ne sëëb xnëz naa, goḻchoobnis zho, goḻguiab lo zho lëë miṉ co rnabey Pxoz naa, rnabey naa ne nac Xpëëd me, ni rnabeygaa Espíritu Sant. ");
INSERT INTO zpmNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Goḻseed zho gban zho, grëse miṉe bnabey naa to guṉ to. Miṉ co rsaṉ naa diidz lo to guṉ to; ni gacnaṉ to gaṉle, ib csaand naa to, gzataa dzew niicle haxta dze ne nitlo guidzliuw, naa gacnie to.");
INSERT INTO zpmNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nu gaṉle laa naa csilo gzodiidz naa, miṉe beeṉ Jesús, Meṉ ne bneele Dios cxeeḻ me lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Lo guits ne pquiaa Isá, tib meṉ ne biadteed xtiidz Dios padzeela, lo co zhobnee gaṉle ible laa Dios no cxeeḻ me. Rneew, glo cxeeḻ me tib zha ne tedner, guiaadnie diidz. Znu zhobnee lo guits co: Sxeḻ naa tib zha ne tedner lo luu, zeeṉa zha co gzhixcuaa nëz ne ted luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dan tso zho, zon miech zeeṉe laa tsi zho zëëb gnee zho: “Goḻzhixcuaa nëz ne ted meṉ ne rnabey, goḻsaan grë guieḻntseeb ne ruṉ to.” ");
INSERT INTO zpmNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ni nligaa scase goca, zeeṉe laa Juan Bautist biaad, dan bio me rchoobnis me miech; rnee me lo zho csaan zho xquieḻntseeb zho gbig zho lo Dios, ni chobnis zho, zeeṉa csilaa Dios zho lo grëtaa xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dzigo rriee miech grë guiedz ne ngab Judé, dib lad guiedz Jerusalén, riequiaadiag zho zhiwseed me; ni rxobdoḻ zho grë xtoḻ zho, dzigo rchoobnis me zho leṉ guiubee Jordán. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Guits lad camell niaa xab me, ncuaaṉe rzhidoo leṉ me guid niaaw ni niapse nguzhanch ni dzin dan row me. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Zeeṉe rseed me grë miech co, rnee me lo zho: ―Iraa ziaad meṉ ne mazdraa non lo naa. Teḻ naa peet nond naa, tib guieḻnzaac nroob ga ygaa naa teḻne niaca miṉe grieelo maase lab me glit naa; per na ni miṉ co rdziṉd naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Laa naa rchoobnis to niina con nis; saṉgue me con Espíritu Sant cchoobnis me to. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Leṉ ngbidz coquew, laa Jesús briee guiedz Nazaret xtan zha Galilé, güey me pchoobnis Juan me leṉ guiubee Jordán. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Laa me norieedze lo nis, zeeṉe goṉ me laa zhan gbaa bzhial, laa meṉ ne nac Espíritu Sant biet gbaa zig tib palom laa me ziad-zëëb guic me. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ni lëëtaque zëëb tib tsi meṉ co gbaa, rnee me: ―Xin, rleynie naa luu goṉ, nziuu luu lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Zeeṉe blozh brobnis me, dzigo güeynie Espíritu Sant me tib dan ngan, zaatne no grë ma ntseeb; ");
INSERT INTO zpmNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","bio me ga choo ngbidz. Ga no me güey Satanás (ma ne rnabey lo grëse meṉdox), gocladz ma niuṉgüet ma me. Bdedse ga, güey grë xanjl Dios güeygaṉ zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Leṉ ngbidz co bnabey Herod bio Juan ladzguiib. Ladzguiible no Juan zeeṉe briee Jesús güeyted me grë guiedz ne ngab Galilé güeyseed me miech Xtiidz Ndzon Dios, ");
INSERT INTO zpmNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","rnee me lo zho: ―Laa dze ne gnabey Dios ziaadgaxle, laaw bdziṉ dzele. ¡Goḻsaan grë xquieḻntseeb to, goḻnab perdon lo Dios; dib zdoo to goḻliladz Xtiidz me! ");
INSERT INTO zpmNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tib dze zieded Jesús ro Nisdoo ne lë Galilé, goṉ me laa Simón grop Ndrés quia gooz meḻ lo nis co; sac ible dziin co nac xtsiiṉ zho. Grop bets zho laa zho noroṉ guiex ne rgaa meḻ lo nis. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Dzigo bredz me zho, rëb me lo zho: ―¡Goḻtë, goḻtënaḻ zhits naa! ¡Laa naa cxeḻ to tsie to stib gooz, tsietop to grë miech ne sëëb xnëz Dios! ");
INSERT INTO zpmNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Horcogazh psaṉ zho guiex ne rnaaz zho meḻ ga, laa zho zienaḻ zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Zhisaque bzë Jesús ro nis co, goṉ me laa Jacob ni Juan no tib leṉ barcw noquiaabdie zho guiex ne rnaaz zho meḻ, lëë grop xingan Zebedé ga; ");
INSERT INTO zpmNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","dzigo bredz me zho. Zigne bredz me zho, zoque Zebedé lo barcw ga grë xmoz Zebedé, laa zho zienaḻ zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Laa zho bdziṉ guiedz ne lë Capernaum. Zeeṉe goḻ dze ne rdziiladz zho lo dziin nëz Israel, güey Jesús yadoo win ne zob lad guiedz co güeyseed me miech. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Grë miech ne ndxie leṉ yadoo ga, rzee zdoo zho raṉ zho zha rnee me, sac rlu meṉ rnabey nac me; led yed me rseed zigne rseed grë zha ne nac maistr ley. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lad grë miech co no tib mgui ne nosacsi meṉdox, tibaque zeeṉe nguiedz pcooptsie ma mgui, ");
INSERT INTO zpmNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","rnee ma: ―¿Pe guṉ luu no Jesús Nazaren? ¿Ziaad luu lëë par gnitlo luu no? Ruṉbey naa luu, tib meṉ peet xtoḻd nac luu ni Dios pxeeḻ luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dzigo goctox Jesús lo ma, rëb me: ―¡Psioog ro luu! ¡Na zeeṉa psaan meṉ qui! ");
INSERT INTO zpmNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Horco masaque beeṉcxidz ma mgui co, ni rquiaadan ma redz laa ma psaan mgui. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Grëse miech ne ndxie ga, bzee zdoo zho rnabdiidzlsa zho rnee zho: ―¿Bay cho nac meṉ qui? ¡Wseed cub i goṉ ziaadnie me! ¡Rlu zha rnabey nac me, zha haxta meṉdox rdzieb zeeṉe ractox me lo ma! ");
INSERT INTO zpmNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Znuse brieets bliaaḻ diidz zha beeṉguiac Jesús mgui co; grëse guiedz ne ngab Galilé gocnaṉ miecha. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ga briee Jesús güey me lidz Simón grop Ndrés gza me Jacob ni Juan. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bdziṉ zho, lëëtaque laa xniadzoop Simón nix rlan xlëë, nacne rëb zhow lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dzigo bded me zaatne nix zhuz co, bzheṉ me nia me, blische me me. Horcogazh laa zhixlëë me blëz, guche me ga psilo me beeṉlo ncuaaṉe dow zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ziedzele dzew, laa ngbidz rzëëblew, zeeṉe psilo grë miech co zo zo rdziṉnie zho grë meṉ rzacnë, grë zha ne nosacsi meṉdox ne; bioogse ro yu co ndxie miech. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Zootle zig grëse miech ne no lad guiedz co pcaalsa ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ndal grë meṉ rzacnë co zhaase zhaase guieḻguidz ne rzac zho, per beeṉguiac Jesús zho; zha ne nosacsi meṉdox, beṉcxooṉ me grë meṉdox ne nosacsi zho. Goctox me lo ma, ib bdeete me diidz nee ma cho nac me, sac ruṉbey ma me. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Silgaw, scase bii ncow rnaw guche Jesús briee me lad guiedz co, güey me zaatne guieṉdraa miech, güeyzodiidznie me Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Zeeṉe rnit me choot guieṉd; dzigo briee Simón ni zla zha ne nacgza Simón güeyguib zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Zeeṉe bdziel me, rëbchaa zho lo me laa grë miech co quiaguible me. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dzigo pquiab me rëb me lo zho: ―¡Sca ye! Per ib laa ne none goṉ guio grëraa guiedz ne ndxie dib gax nu, zeeṉa ye grë guiedz qui gnee naa Xtiidz Dios lo miech; sac ible miṉ co pxeeḻ me naa ziaḻ naa lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dzigo güey zho grëse guiedz ne ngab Galilé. Zaatne rdziṉtaa zho, rie me grëse yadoo win ne zob lad guiedz rseed me grë miech co Xtiidz Dios, ni ruṉcxooṉ me grë meṉdox ne nosacsi miech. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tib vuelt, wbig tib mgui ne rlan guiedzdox ne lë lepr lo Jesús (masaque riaaḻ dipse guid lad mgui), pquiitsgzhib mgui lo me, rëb mgui: ―Tebaa siguieeḻ luu guṉguiac luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pquia zdoo Jesús mgui, pxobnia me guic mgui rëb me: ―Zuṉguiac naa luu. ¡Niinagazh laa luu guiaaṉmbe! ");
INSERT INTO zpmNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Zigne sca bnee me laa mgui co biac, mbese biaaṉ xcuerp mgui. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Blozh ga bzonëz me mgui, ni pso me diidz lo mgui ");
INSERT INTO zpmNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","rëb me: ―Bina gaṉle, choot lo gzodiidzd luu goṉ zha biac luu. Bzë, güey lo pxoz, güeysaṉ gon ne rnabey xley Moisés gdeed luu; zeeṉa gaṉ zho gaṉle laa luu biacle. ");
INSERT INTO zpmNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ni zigne briee mgui ga, psilo mgui grë lo miech bzodiidz mgui zha biac mgui. Grëse miech gocnaṉa, nacne brieelodraa neṉlo ndziṉ Jesús grë lad guiedz co. Miṉe beeṉ me, blëz me zaatne choot miech guieṉd; per niicle scaw, miech guizhiu ne rriee grë guiedz co rdziṉ lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Goc bla dzew, laa Jesús biire bdziṉ lad guiedz Capernaum stib. Zeeṉe bin zho laa me bdziṉ ro yu, ");
INSERT INTO zpmNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","miech guizhiu ne pcaalsa zaatne no me ga, haxta ro yu ndxie grë miech co; dzigo psilo me noseed me zho Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Laa grë miech co ndxie ga, zeeṉe bdziṉ tap zha bgui ney zho stib meṉ bgui, zhoobse me lo yag, ib gacd së me sac dipse me gutoo. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ni ne scataa miech guizhiu ne ndxie, gacd ted zho nëz ro yu gdziṉnie zho me lo Jesús, nacne biepaque zho guic yu. Pxal zho ngali zaatne zob Jesús, dzigo ga pteed zho meṉ co dib yag ne zhoob me ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Zeeṉe goṉ Jesús ne nli dib zdoo zho rliladz zho me guṉguiac meṉ rzacnë co, dzigo rëbchaa me lo meṉ co: ―Xin, niinagazh laa naa guṉ perdon grëse xtoḻ luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Blalaa zha ne nac maistr ley zob ga, zeeṉe bin zho sca rëb me lo meṉ rzacnë co, bzachaa zdoo zho: ");
INSERT INTO zpmNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¡Lëda i goṉ squi rnee meṉ qui! Quiaguitnie me Dios i squi rzë xtiidz me. ¡Tibaque meṉ ne ruṉ perdon xtoḻ miech, ni lëë meṉ co nac Dios!” ");
INSERT INTO zpmNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bieṉga Jesús sca rza zdoo zho, dzigo rëbchaa me: ―¿Pe nacne rlëë to ron to miṉe rne naa? ");
INSERT INTO zpmNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Parga nli, choḻze zha ne zac guiab: “Laa naa guṉ perdon grëse xtoḻ luu.” ");
INSERT INTO zpmNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Per laa naa glu lo to gaṉle, naa ne nac naa Meṉ ne pxeeḻ Dios ziaḻ naa lo guidzliu, ible naa no guṉ miech perdon. Dzigo bnee me lo meṉ rzacnë co, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―¡Guche i, bi yag ne bzhoob luu i, zeeṉ bzë! ");
INSERT INTO zpmNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Zigne sca bnee me laa mgui co bzoli, blis me yag co, grop lo grë miech co goṉ zho laa me briee ga, laa me zey. Grëse zho rzee zdoo zho, rleynie zho Dios rnee zho: ―¡Nasi laa ne nodziaṉ ncuaaṉe gard dziaṉ ne! ");
INSERT INTO zpmNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Blozh ga, laa Jesús briee ga laa me zie nëz ro nisdoo stib; nzian miech ne pcaalsa lo me ga, dzigo pseed me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ro nis co ziezë me goṉ me Leví, xingan Alfé, zob Leví zaatne rietizh zho contribucion, dzigo bredz me Leví tsienaḻ Leví zhits me. Guso Leví ga, laa Leví zienaḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bded ga, bredz Leví me güey me tib wagw lidz Leví. Grë zha ne nac recaudador, grë zha ne zëëb diidz nac zha yozh, tipse lo mezh bzobnie me zho grë xpëëdscuel me; sac ndal grë zha co zienaḻ zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Blalaa maistr ley ne nacgrë zha farisé, goṉ zho sca tipse noyownie Jesús grë zha co; bded ga, rëbchaa zho lo xpëëdscuel me: ―¡Mod sca na rownie xmaistr to grë zha ngoopdoḻ, grë zha beed ne nac recaudador! ");
INSERT INTO zpmNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Dzigo rëbchaa Jesús lo zho: ―Naṉle to gaṉle, meṉ ne ruṉ rmed, zaatne no zha ne rzacnë, ga rquiin zho, ¿niacxe squiin zho zaatne no zha ne ndip ndaan? Ni miṉ co rac niina, teḻ naa ziaḻguibd naa miech wen, sinque laa naa ziaḻguib miech ngoopdoḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lëëtaaque dze co nocuan xpëëdscuel Juan Bautist, grë zho zha farisé. Dzigo bdziṉ bla zha ne bnabdiidz lo Jesús, rëb zho: ―¿Pe nac waa ib rcuand xpëëdscuel luu? Zha grë xpëëdscuel Juan Bautist ni grë zha farisé, rcuan zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Pquiab Jesús, rëb me: ―Zaatne nadieṉ noyac tib guieḻtsieel, ¿pe niacxe lega csilo grë zha ne ndxie lo lni tso zho guieḻnë, ycuan zho ni raṉ zho laa mgui ne notsieelnia mban? ");
INSERT INTO zpmNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per zdziṉ dze zeeṉe laa mgui co gbiche; ni zeeṉe laa dze co gdziṉ, dzigosi nagoṉ rieguiaḻ tso zho guieḻnë, rieguiaḻ ycuan zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Raṉle to gaṉle, zha ne rquiaabdie tib lë lar, rquiaad zho lar cub lad lar gox, sac zha ne sca guṉ paat yquiind wquiaabdie co. Zeeṉe laa lar cub gbe, lëëque lëëw guṉnat zaatne nriez lar gox. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Scaque tsod zha ne cotsow vin cub tib leṉ guid ne padzeelale noquiin, sac stsiez vin cuba; dzigo niicle guid cow, niicle vingaaw laaw nitlo ga. Gacxe, teḻ vin cuba none leṉ guid cubaque tsotsowa. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tib dze ne rdziiladz zho lo dziin nëz Israel, bdednie Jesús xpëëdscuel me zaatne zëëb zhobxtil, dzigo zigse zieded zho pchoo zho palal mzion zhobxtil co. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Goṉ zha farisew, dzigo rëbchaa zho: ―¡Lëda i goṉ noyuṉ to! ¡Goḻguieṉ gaṉle dze nda nac dze rii! ");
INSERT INTO zpmNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Dzigo pquiab Jesús, rëb me: ―¿Pe gard glab to zaatne ziaad gaṉle zha beeṉ rey David tib dze zeeṉe pcaabedz me grë me zha ne ziegza me, ni zienied zho pe gow zho? ");
INSERT INTO zpmNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Rneew, bzëëb me leṉ yadoo güeynab me guietxtil ne nac gon, downie me grë zha ne ziegza me ga, ni loxaque zha ne nacse pxoz row guietxtil co. Leṉ iz co nac meṉ ne lë Abiatar pxoz nroob. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Goḻgacnaṉ sca gaṉle, biaaṉd dze rii par csacsi miech xcuerp zho, sinque ne rleynie Dios miech gane psaṉ mew. ");
INSERT INTO zpmNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Naa ne nac naa Meṉ ne pxeeḻ Dios ziaḻ naa lo guidzliu, naa rnabey dze rii, naṉpaa naa pe nac miṉe nonguieḻ gac. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Goḻ stib dze ne rdziiladz zho lo dziin, güey Jesús leṉ yadoo win ne zob lad guiedz co. Lad grë miech ne no leṉ yadoo co, no tib mgui ne mband tib nia. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nzian zha ne ndxie ga, quialeets zho Jesús dieṉ pe zuṉguiac me nia mgui co dze ne rdziiladz zho lo dziin. Quiambëz zho dieṉ pe guṉ me, par gdziel pe yquiaaqui zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dzigo bredz me mgui co, bnabey me bzo mgui groḻtaa lo grë zha ne ndxie ga; ");
INSERT INTO zpmNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","blozh ga rëbchaa me lo zho: ―¿Pe nadieṉ rzac to nonguieḻ guṉ ne dze rii? ¿Pe nonguieḻa guṉ ne ncuaaṉe yquiin, te nonguieḻa guṉ ne guieḻntseeb ye? Zig nac samiech ne zha ne noxtseeb xquieḻmban, ¿pe maase csaan ne guet zho? Ni tib zho pquiabd. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Dze bui me lo zho grëse zho, wbiṉladz guic me, ni mban goc zdoo me goṉ me scataa ntseeb zdoo zho; dzigo rëb me lo mgui co: ―Bzigaa nia luu. Zigne bzigaa mgui nia mgui, laaw biac. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Grë zha farisé, ni grë zha ne nacnie rey Herod, zigne briee zho ga laa zho psilo bnediidz dieṉ zha gdeeda diidz gut zho Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Leṉ dze co, tib vuelt bdziṉ Jesús ro nisdoo grë xpëëdscuel me. Miech guizhiu ne naḻ zhits zho, ga zie grë zha ne ziaad nëz Galilé, grë zha ne ziaad nëz Judé, ");
INSERT INTO zpmNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","grë zha Jerusalén, grë zha ne ziaad nëz Idumé, grë zha no dib nëz daṉ ro guiubee Jordán, grë zha ne no dib gax guiedz Tiro ni guiedz Sidón. Miech guizhiuw, sac ron zho grëtaa milagr ne ruṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Dzigo bnabey Jesús xpëëdscuel me, yguib zho tib leṉ barcw zaatne gac so me zeeṉa ctaagwd grë miech co me. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Zëëble diidz ndal miech ziyuṉguiac me, dzigo grëse zha ne rlan pe guieḻguidz, rbigbe zho dieṉ zha grieelo maase lad xab me xeṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Grë meṉdox ne noguitnie miech, zeeṉe raṉ ma me, ruṉquiitsgzhib ma zha ne noguitnie ma lo me ni rquiaadan ma redz rnee ma: ―¡Xpëëd Dios nac luu! ");
INSERT INTO zpmNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per ractox me lo ma, rsaand me gnee ma parne xoobneṉd cho nac me. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Blozh ga biep me tib guic gui win zob ga, ga bredz me zha ne gocladzse me. Zeeṉe pcaalsa zho grë zho, ");
INSERT INTO zpmNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","dzigo lad co ble me tsiipchop zha ne sënie me, zha ne cxeeḻ me tsieseed miech Xtiidz Dios. Lëë zha co bleelë me poxtl, ");
INSERT INTO zpmNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ni bdeed me poder lo zho guṉcxooṉ zho meṉdox. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Znu lë gza tsiipchop zha ne ble me ga: Simón (lëë Simón co bleelë me Pedr), Jacob ni Juan (xingan Zebedé, zha ne bleelë me “Zhin Nguzi” “Boanerj”). Ndrés, Lip, Bartol, Matew, Mazh, Jacob (xingan Alfé), Tadé, Simón (zha ne nacgrë zha ne racladz cuee zha Roma xtan zho) ni Judas Iscariot (zha ne güeyto me). ");
INSERT INTO zpmNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wbire Jesús ga, laa me bdziṉ ro yu grë me zho. Scasaque ndal miech ne pcaalsa ga stib, ni rdeetew diidz gownie me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Zeeṉe bin meṉlidz mew, dzigo briee zho ziexi zho me, sac rëb zho bod rzhiṉle guic me. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Haxta grë maistr ley, zha ne briee nëz Jerusalén bdziṉ ga, rnee zho: ―Beelzebú, ma ne rnabey lo meṉdox, ma co nacnie me gane rrieelo ruṉcxooṉ me meṉdox. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dzigo bredz me zho bzodiidz me tib cuent lo zho, rëb me: ―¿Pa naṉ to na grieelo lëëque meṉdox guṉcxooṉ sameṉdox ma? ");
INSERT INTO zpmNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Teḻ tib guiedz nadieṉ gac miech chop dii, csilo zho tiḻlsa zho, ¿niacxe nitlod guiedz co? ");
INSERT INTO zpmNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tib diigaa miecha, teḻ csilo zho lëëque zha tiḻnie meṉlidz zho, ¿niacxe nitlod zho? ");
INSERT INTO zpmNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Scaquegaa meṉdox nagoṉ, teḻne lëëque lëë ma tiḻnie sameṉdox ma, ¡pe nale na bnitlo ma! ");
INSERT INTO zpmNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Masaque nac meṉdox zig tib zha ne no xfuers, zha ne gacladz cuee grë ncuaaṉe no lidz zha co, none cxidoogazh zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Gneli naa lo to gaṉle, grëse doḻ ne ruṉ miech, grë teḻ zha rguie zho, rdzibdee zho, bii zuṉ Dios zho perdon miṉ co; ");
INSERT INTO zpmNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","saṉgue zha ne gneenë Espíritu Sant, doḻ nroob ga ruṉ zho, gdziṉd dze ne guṉ Dios zho perdon. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sca rëb me lo zho, sac sca quianee zho rëb zho meṉdox nacnie me. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Horco laa xniaa me ni zha bets me bdziṉ, per leyse blëz zho; dzigo pxeeḻ zho zha ne zietsedz me. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Blalaa zha ne zob gaxpaa lo me, zha co beeṉ vis rëb zho: ―Laa xniaa luu goṉ, ni zha bets luu ziaadguib luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pquiab me rëb me: ―¿Xnia naa ye, bets naa ye? ");
INSERT INTO zpmNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dze bui me lo grë zha ne ndxie ga, dzigo rëbchaa me: ―To goṉ nac xnia naa, to nac bets naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sac grëse zha ne ruṉ miṉe racladz Dios, lëë bets naa ga, lëë bzian naa ga, lëë xnia naa ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Dze coquew, laa Jesús psilo quiaseed miech zaatne nac ro Nisdoo Galilé ga. Miech guizhiu ne pcaalsa lo me, nacne güeytsep me tib leṉ barcw ne zo ro nis co, ga bzob me laa grë miech co bre tib ro nis. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ndal grë ncuaaṉe pseed me zho, per niapse con cuent rnee mew lo zho. Lëë tib cuent ne bzodiidz me ga nu, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―¡Goḻquiaadiaga gaṉle! Tib mgui name, briee me güey me gon zhobxtil. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Zeeṉe laa me quialaaḻ zhob co, miṉe bliaaḻ gax ro nëz; znuse güey grë mguiṉ güeytow maw. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Laa miṉe bliaaḻ zaatne nac lo quie, znuse znuse blana; ");
INSERT INTO zpmNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","per zeeṉe laa lo ngbidz briee, znusaque bgooḻa blozh ga bidzgaw; sac guieṉd nroob low. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Laa miṉe bliaaḻ zaatne nac leṉ yag guiets, zeeṉe laa grë yag guiets co broob znuse bnitlo yag guietsa, pasëw niac. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Saṉgue grë miṉe bliaaḻ zaatne nac lo liu naaḻ, blana, brooba ni goca; lo tib tib zhob co no mzion co briee gaḻptsii zhob, now briee tsoṉgaḻa, nogaaw briee haxta tib gayoow. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Blozh ga, rëbchaa me lo zho: ―Zha ne racladz guieṉ miṉe rne naa, yquiaadiag zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Zeeṉe laa grë miech co zey, laa gza tsiipchop xpëëdscuel me, ni zla zha ne rzënie me, laa zho bnabdiidz lo me dieṉ zha nac cuent co. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dzigo rëbchaa me lo zho: ―Teḻ to, Dioszhal rlu lo to zha rnabey me, niicle ncuaaṉe mazdraa ngueetsa; laa lo grëraa miech ne gard gbig lo me niapse con cuent rzodiidz naaw lo zho parne guieṉ zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Per niicle scaw, nzhial diag zho ron zho, per peet rieṉd zho; nzhial lo zho rwi zho, per peet raṉd zho; ib nëd zho gbig zho lo Dios, gnab zho guṉ me zho perdon. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","’Nana to, teḻne bieṉde to zha nac cuent co, ¿zha guieṉ to grëraa miṉe gne naa dzigo? Goḻquiaadiaga gaṉle, znu goṉ naca: ");
INSERT INTO zpmNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mgui ne güeylaaḻ zhob ga, rrieequia lëë zha ne rienee Xtiidz Dios lo miech ga, laa zhobxtil co nac Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","No miech nac zig nac ro nëz ne bliaaḻ palal zhob co: rquiaadiag zho Xtiidz Dios, rlozh ga lëëlëd rdziṉ meṉdox rquiil ma zho, rsaanga zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nogaa zho nac zigne nac lo quie co: zeeṉe rquiaadiag zho Xtiidz Dios, iṉe rley zho rcaania zhow, ");
INSERT INTO zpmNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","per led dib zdood zho rcaania zhow; gane zeeṉe laa miech rsilo rlëë lo zho, laa miech rtsidiḻ zho porne rliladz zhow, rsaanga zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Zzhisgaa zho nac zigne nac leṉ yag guiets co: nli rquiaadiag zho Xtiidz Dios, ");
INSERT INTO zpmNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per rsilo zho leḻ grë ncuaaṉe no lo guidzliu rii mazdraa rionie guic zho, rquidie grë dimi zho, rzoobladz zho yquianie zho grëse ncuaaṉe racladz zho. Grë ncuaaṉ co rioxcoraa zho, laa ne tsonie Xtiidz Dios guic zho, miṉ co rquiaqui ib ruṉd zho miṉe rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Laa nogaa zho nac zigne nac liu naaḻ co: rquiaadiag zho Xtiidz Dios, dib zdoo zho rliladz zhow, ni rban zhow zigne naca. Grë zha co, no zho nac zig mzion ne briee gaḻptsii zhob ga, no zho nac zig miṉe briee tsoṉgaḻa, nogaa zho nac zig miṉe briee tib gayoow ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Blozh ga, biire pcaalsa miech lo me, dzigo rëb me lo zho: ―¿Pa dieṉ rquiin biini? ¿Pe rquiaguiw par tsolana tib leṉ guiṉ o soogaaw tib zhan lon? Led zeeṉe rquiaguiw lëë, zaatne grieelo gziiniw ga rzoob zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Scaque nagoṉ grëse ncuaaṉe rac ngueetsa, grëse ncuaaṉe rnee miech zhliaana, ib none xoobneṉa. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","’Teḻne racladz to guieṉ to miṉe rne naa, goḻquiaadiaga; ");
INSERT INTO zpmNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ni zigne ron tow scagaa goḻtsoxco goḻguṉa. Teḻne tsoxco to guṉ tow, scagaa zioguicraa tow. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sac zha ne tsoxcow, zdeedraa Dios guieḻbiini lo zho; saṉgue zha ne tsoxcoda, haxta teḻ palalse guieḻbiini ne bdeed me lo zho stiche mew. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ni rëb me lo zho: ―Znu goṉ nac zha ne ngab lo Dios; nac zho zig bni ne ran miech. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Zha ne rielaaḻ bni co, liu rcow, liu riini, laa zho raaguies, laa zho rieche. Sca sca laa dze zie, laa bni co ratslo, laaw rlan, laaw rroob, per rieṉd zho zha nacne laaw rroob. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","’Zhal guidzliu rdeeda guieḻnzaac co, guizh nac zhob co zeeṉe rlana, rac palal dzew laaw rlan mzion. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Laa zeeṉe laaw ral, dzigo laa zho rietiitsa, sac laa dze bdziṉle ne laaw tsas. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","’¿Zha gaṉle gni naa lo to zeeṉa guieṉ to zha nac xquieḻrnabey Dios? ―rëb Jesús―. ¿Pa tib cuent gaṉle gzodiidz naa lo to zeeṉa guieṉ to zha naca? ");
INSERT INTO zpmNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naca goṉ zigne nac tib midz moxtaz ne ran miech dan rii. Midz moxtaz nac midz ne mazdraa win, ");
INSERT INTO zpmNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ni teḻ gacbniw, rrooba, ni lëëw rroobraa lo grë guizh ne ran zho ro yu, haxta grë mguiṉ riezaa zhiptsieez ma low sacne ncala. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nzian grë cuent rii pquiin me par cseed me grë miech co, ni laa me bnee miṉe rgobey me guieṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Niapse sca rseed me zho, laa zha ne nac xpëëdscuel me, zeeṉe zhasew rnee mew lo zho zigne naca. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Zeeṉe bdze dze co, rguetsle liuw rëbchaa me lo xpëëdscuel me: ―Goḻgotsaa dieedquia ne stib nëz lo nis rii. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Blozhse bnee me lo grë miech co, laa zho biep leṉ barcw ne zob me ga grë me zho, laa zho zie. Ye blalaa barcw ne zob lo nis co zienaḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Laa zho zie, tibaque zeeṉe laa tib medox psilo briee, masaque rlis me lo nis co; zeeṉe riasoli low riechooṉa leṉ barcw, laa barcw psilo noyodzële nis. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dzigo güey zho güeycuaan zho Jesús, sac lëëtaque laa me nixguies nëz zhan barcw ncoogse me tib lmad. ―¡Maestro! ―rëb zho―. Bui gaṉle, ¿pe znuse csaan luu nitlo ne nu? ");
INSERT INTO zpmNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dzigo guche Jesús, bnee me lo me co, bnee me lo nis co, rëb me: ―¡Lëëw ga na! ¡Goḻcuedze! Zigne sca bnee me, laa me co blëz, niicle nis cow laaw bredze. ");
INSERT INTO zpmNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Dzigo rëbchaa me lo zho: ―¿Pe nacne squitaa rdzieb to? ¡Gardaque dzigo lëë gliladz to cho nac naa! ");
INSERT INTO zpmNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Rieṉdraa zho zha guṉ zho lo dzeb co, ni rnabdiidzlsa zho rnee zho: ―¿Bay cho nac me, zha nacne haxta me, haxta nisdoo ron xtiidz me? ");
INSERT INTO zpmNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bdziṉ Jesús nëz daṉ ro nisdoo co gza xpëëdscuel me, ga nac xtan zha Gadar. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Laa me bietdze leṉ barcw, zeeṉe laa tib mgui ne nosacsi meṉdox bdziṉ lo me. Leṉ baa briee mgui co bdziṉ me ga, ");
INSERT INTO zpmNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","sac leṉ baa nac zaatne rbëz me. Miech ne lëbd zho low, nzian vuelt ziezoob zho caden nia me, ni me ne, per znuse rchug mew, rzhooṉga me. ¡Choot rlëbd lo me! ");
INSERT INTO zpmNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dze, guieel quianzë me grë dan co, rietso me grë leṉ baa. Roptsiedan me, ni lëëque me rzheṉ quie rchug me guidlad me. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Laa dze co, zitraa goṉ me Jesús, rias me bdziṉ me pquiitsgzhib me lo Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Dzigo goctox Jesús lo meṉdox ne noguitnie me, rëb Jesús: ―¡Meṉdox, psaan meṉ qui! Horco pcooptsiedan meṉdox co mgui co, ni rnee ma lo Jesús: ―¿Pe guṉ luu naa Jesús? Ruṉbey naa luu, Xpëëd Dios ne no gbaa nac luu. ¡Ne nlipagaa beeṉ guieḻnzaac csacsid luu naa! ");
INSERT INTO zpmNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dzigo bnabdiidz Jesús lo ma dieṉ cho lë ma. Pquiab ma rëb ma: ―Legion lë no, sac nzian nac no. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Rnab grë meṉdox co lo Jesús, gzonëzd me ma zit. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Gaxaque zhan gui co ndxie tib dzoon nguts noyow, ");
INSERT INTO zpmNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","dzigo bnab ma lo Jesús, rëb ma: ―Bzhiguieḻ lose grë nguts qui bzonëz no. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Bdeed Jesús diidz. Dzigo laa grë meṉdox co psaan mgui co, laa ma zie bzëëb ma zdoo grë nguts ne ndxie ga; psilo grë nguts co rquiaa ma corr güeypix ma glaa tib ro yee ne quia ro nisdoo co, bliaaḻ ma haxta lo nis. Ga biep ma nis, grëse ma gut. Rgaa ma zig chop mil. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Zha ne quianap grë nguts co, gzase zho bzhooṉ güeyzodiidz zhow lad guiedz, ni grëraa yu ne zob gax ga. Briee grë miech co, zieso zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Zeeṉe bdziṉ zho, per nli bdzieb zho, sac goṉ zho laa mgui ne sca bdziitnie meṉdox ga zobse lo Jesús, laa mgui nacwxable, rlu ndzinlile nac guic mgui. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Psilo grë zha ne goṉ zha biac mgui co, ni zha goc grë nguts co, psilo zho rzodiidz zhow lo grë zha ne bdziṉ ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Miṉ co bin grë zha co, mazd bnab zho lo Jesús siguieḻ me gbi me xtan zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Zeeṉe laa Jesús zie sëëb me leṉ barcw, dzigo laa mgui co wbigaque lo me, naṉ mgui nziguieḻ me nienaḻ mgui zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per bdeete me diidz, rëb me: ―Wbire, güey güeyzodiidz lo grë meṉlidz luu gaṉle pa lotaa pquia zdoo Dios luu, zha nactaa milagr nroob ne beeṉ me beeṉguiac me luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dzigo wbire mgui. Güey mgui dib xtan zha Decápolis, güeyzodiidz mgui lo grë miech co zha beeṉguiac Jesús mgui. Grëse zha ne rona, rzee zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Zeeṉe laa Jesús biire brieequia stib nëz ro nisdoo co, miech guizhiu ne pcaalsa lo me ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ga zo me zeeṉe laa tib meṉ ne nacgrë zha ne rnabey yadoo lë Jair bdziṉ. Zigne bdziṉ me lo Jesús pquiitsgzhib me, ");
INSERT INTO zpmNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","rëb me: ―Beeṉ tib guieḻnzaac gotsaa guio ne guṉguiac luu xpëëd naa. Laa win rlozhle; naṉpaa naa teḻne cxobnia luu guic win, ziac win. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dzigo laa Jesús zie nëz lidz meṉ co. Ndal miech ne zienaḻ zhits me, haxta rtaagw zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lad grë miech co zienaḻ tib wnaa, gocle tsiipchop iz rlan me tib guieḻguidz, rzac me zigne rzac meṉ wnaa gzob mëë, tibaque rlan mew ib rbëzda. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nzianle lo meṉ ne ruṉ rmed ziye me, grëse ncuaaṉe rap me bloozh me lo rmed; per laa ne cuëz guieḻguidz co, leḻ znu rzhizhooraaw. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ziyonle me grë milagr ne ruṉ Jesús. Bza zdoo me rëb me: “Totsaque ygaa maase lad lar ne mbix me xeeṉ naa, ziacle naa.” Dzigo bded me lad grë miech co, wbig gax me nëz zhits Jesús, bzheṉ me lad lar ne mbix Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nligaa hor cogazh laa guieḻguidz co blëz, bieṉ me laa me biac. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Zeeṉe bieṉ Jesús ne laa me beeṉguiac wnaa co, dzigo ptsire lo me rwi me lo grë miech co, rëb me lo zho: ―¿Cho ga bzheṉ lad xab naa? ");
INSERT INTO zpmNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Rëbchaa xpëëdscuel me: ―¿Zha naṉ luu glu dieṉ cho bzheṉ lad xab luu, ni squitaa ndaagw ziaad luu lad grë miech qui? ");
INSERT INTO zpmNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per laa me rwi lo grë miech co dieṉ chow. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Naṉpaa wnaa co ne me ga, rdzieb me, rzhidz me laa me wbig pquiitsgzhib me lo Jesús bneeli me zha nacne sca beeṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dzigo rëbchaa Jesús lo me: ―Xin, laa luu biac sacne bliladz luu naa. Bzë na, peet tsieniedraa guic luu, laa guieḻguidz co bichele. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Laa Jesús bii quianeeque, zeeṉe laa bla zha ne ziaad nëz lidz Jair bdziṉ, rëb zho lo Jair: ―Csodziindraa luu lo meṉ qui, laa xpëëd luu gutle. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Zeeṉe goṉ Jesús sca rëb zha co, dzigo bnee me lo Jair rëb me: ―Peet tsienied guic luu. Dib zdoo luu bliladz naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Psaandraa me cho grë miech co nienaḻ zhits me, loxaque Pedr, Jacob ni Juan bets Jacob; zha cose zienie me. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Zeeṉe bdziṉ zho lidz meṉ co, tib ruid ne rac, nguiedz zëëb tsi zho roon zho no zho xquieḻnë mëëd co. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dzigo bzëëb Jesús leṉ yu, rëb me lo zho: ―¿Pe nacne squitaa roon to? Goonde to, goṉ led gute ndzoop win rii, nixguies ndzoop. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Leḻ rzhidznie grë miech co me, bin zho sca rëb me. Dzigo bnabey me briee zho ley grëse zho, loxaque pxoz mëëd co, xniaa win ni gza tsoṉ xpëëdscuel me zha ne naḻ zhits me ga bzëëbnie me leṉ yu ne nix win. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wbig me bzheṉ me nia win, rëb me lo win: ―¡Guche i na, ndzoop yeeṉ! (Talita, cumi.) ");
INSERT INTO zpmNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Zigne sca bnee me laa mëëd co guche, laa win bzë. Tib mëëd tsiipchop iza. Grëse miech co per nli rzee zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Dzigo pso me diidz lo zho choot lo gneed zhow; blozh ga bnabey me bdeed zho ncuaaṉe dow mëëd co. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ga briee Jesús grë xpëëdscuel me, laa me bdziṉ Nazaret zaatne nac ladz me. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Laa zeeṉe goḻ dze ne rdziiladz zho lo dziin, laa me bdziṉ leṉ yadoo, psilo me pseed me grë miech co. Per nli rzee zdoo zho ron zho grë miṉe rnee me, rnabdiidzlsa zho rnee zho: ―¿Pazhe waa squitaa pseed meṉ qui? ¿Zha nac guieḻbiini ne squitaa rap me i, ne rnee miech ndal grë milagr ne ruṉ me? ");
INSERT INTO zpmNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tib ngurëëyagse name nac me. Led lëë xingan Marí i, bets me name nac Jacob, nac José, nac Judas ni Simón, grë bzian mew, nu no zho grë zho. Ib beeṉcasd zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Zeeṉe goṉ me sca rac zho, dzigo rëb me lo zho: ―Zha ne rteed xtiidz Dios, mazd wen rnee miech lo zho stib dan, stib guiedz, lëdle ladz zho, ni meṉlidz zho ni meṉladz zho nëd guṉbey zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Brieelod niuṉ me nzian milagr ga, blase zha rzacnë pxobnia me guic, beeṉguiac me. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bzee zdoo me goṉ me scataa ndip zdoo zho, ib bliladzd zho cho nac me. Blozh ga mazd güey me grë guiedz ne ndxie gax ga, güeyseed me miech. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tib dze, bredz me gza tsiipchop xpëëdscuel me, bnabey me zho tsieseed zho miech. Pxeeḻ me zho chopga chopga zho, ni bdeed me poder lo zho par guṉcxooṉ zho meṉdox. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pso me diidz lo zho güeyd zho pe yquiin zho nëz, lëë gdib tib lë yag ne gzoxca zho güey zho. Zig nac ncuaaṉe gow zho, zig nac dimi, pe tib bziuudgaa, güeyd zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lab zho, miṉe quiase ni zho; xab zho, miṉe nacwse zho miṉcose tsienie zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ni rëb me lo zho: ―Guiedz ne gdziṉ to, zha ne gneedz zaatne cuëz to, lidz zha co goḻcuëz haxta gdziṉ dze ne gbi to guiedz co. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Laa zaatne ne ib gneedzd zho pa cuëz to, niicle nëdgaa zho yquiaadiag zho miṉe gnee to, dzigo goḻlit grë yudie co ni to, goḻrieegazh ga, zeeṉa guieṉ zho gaṉle lëda ga beeṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dzigo laa zho briee, laa zho zie. Güey zho, güeynee zho lo grë miech csaan zho xquieḻntseeb zho, gbig zho lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nzian zha ne nosacsi meṉdox, beṉcxooṉ zho meṉdox co; grë zha ne rzacnë, bdëëb zho nceit guic zho, beeṉguiac zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bin rey Herod rzeet zho Jesús, sac teḻ pa lotaaw zëëb diidz grëtaa milagr ne ruṉ me. Grë miech co, no zho rzac brieeban Juan Bautist lëë me ga nac Jesús, gane ruṉ me grëtaa milagr co; ");
INSERT INTO zpmNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","nogaa zho rnee Líw, meṉ ne biaad pteed Xtiidz Dios padzeela; zzhisgaa zho rnee, no cho stib meṉ ne ziaad noteed Xtiidz Diosa, zig biaad grë zha ne biaad padzeela. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Zeeṉe ron Herod sca rnee miech, dzigo rnee me: ―Nligaa Juan ga. Naa bnabey pchug zho yaṉ me, per lëë me ga brieeban. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Sca rnee Herod sac rsoladz me zha beeṉ me Juan. Me bnabey bgaa Juan bio Juan ladzguiib, loxaque ne rnee Juan lo me nonguieḻda ga lëëque Herodí ptsieelnia me; sac tsieelpaa bets me Lip nac Herodí. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Blëënie wnaa ne nac Herodí ga Juan, rzac me tebaa zha gut me Juan; per rdeetew diidz, ");
INSERT INTO zpmNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","sac rdzieb Herod lega pe guṉ me Juan, rieṉ me tib zha ne zienaḻ miṉe nac diidzli, tib zha ne peet xtoḻd nac Juan; dzigo ib rdeete me diidz pe guṉ wnaa co Juan. Niicle ne cadque zeeṉe rnee Juan lo me, rio me zhgab rieṉd me dieṉ zha guṉ me, per rdziladz me rquiaadiag me grë miṉe rnee Juan. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Laa tibtaa dze laa miṉe no guic Herodí ga goc. Dze ne bloozh Herod stib iz, bnabey Herod goc tib lni nroob, bredz me grë zha ne nacnie me dziin, grë zha ne zo lo meṉguiib, ni grë zha non lo zha Galilé. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Laa zho no mezh noyow zho, zeeṉe bzëëb xindzoop Herodí psilo ndzoop biee ndzoop. Bdziladz Herod goṉ me zha biee ndzoop, grë zha ne zob lo mezh ga ne. Dzigo rëb Herod lo ndzoop, teḻ petaa gnab ndzoop zdeed mew; haxta briee ro me rëb me: ―Ncuaaṉe gacladztaa luu gnab luu, niicle zig groḻ grë ncuaaṉe rap naaw, znedz naaw. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Rias ndzoop güeynabdiidz ndzoop lo xniaa ndzoop. Dzigo rëbchaa me lo ndzoop: ―Bnab lo me gnabey me tsiechug zho guic Juan gneedz zhow lo luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bdziṉ ndzoop lo Herod rëb ndzoop: ―Racladz naa xoob guic Juan Bautist tib leṉ plat, gneedz luuw lo naa niinagazh. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Zeeṉe bin Herod sca rëb ndzoop, mbanse rac me; per rdeetraaw diidz niab me grieeloda, sac grëse zha ne zobnie me ga, bin zho rëb me zdeed me ncuaaṉe gnabtaa ndzoop. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dzigo racse me pxeeḻ me tib meṉguiib ne tsiechug guic Juan. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Güey meṉguiib co leṉ ladzguiib pchug zho guic Juan. Bdziṉ zho, zhoobsew tib leṉ plat bdeed zhow lo ndzoop, dzigo güey ndzoop güeydeed ndzoopa lo xniaa ndzoop. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zeeṉe bin xpëëdscuel Juana, dzigo güey zho güeylis zho me ga güeyqueets zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Zeeṉe laa gza xpëëdscuel Jesús bdziṉ lo me stib, psilo zho bzodiidz zho lo me grëse teḻ zha güey zho, grëse teḻ zha güeyseed zho miech. Per miech guizhiu ne ndxie lo me, zha ne rbi, zha ne rdziṉ; haxta ni riobd gow me grë xpëëdscuel me. Dzigo rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","―Mazd goḻgotsaa guio ne tib zaatne zitlaa lo grë miech rii, zeeṉa grieelo gdziiladz to niip. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dzigo bzëëb me tib leṉ barcw grë me zho, laa zho zie. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nzian zha ne goṉ zie me, beeṉbey zho ne mew. Dzigo ndal miech ne no grë guiedz gax co briee, rias zho zie zho glole zho bdziṉ zaatne no gdziṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Zeeṉe biet me leṉ barcw, goṉ me laa grë miech guizhiu co ndxiele ga. Pquia zdoo me zho goṉ me scataa ndxie zho zootle grë mëcwxiil yeeṉ ne guieṉd xbaxtor, dzigo psilo me nzian grë ncuaaṉe pseed me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Goḻ bdze dze co, wbig xpëëdscuel me lo me rëb zho: ―Mazd gudz lo grë miech qui guey zho na, zeeṉa guiob tsie zho grë guiedz ne ndxie dib gax i, tsiesi zho ncuaaṉe gow zho; sac goṉ laa dze bdzele, ni choot miech guieṉd nu. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pquiab me rëb me lo zho: ―To goḻdeed ncuaaṉe gow zho. Rëbchaa zho lo me: ―¿Pe zhizhe dimi ne yquiin gziuu guietxtil ne gow grëtaa miech qui? ");
INSERT INTO zpmNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Dzigo bnabdiidz me lo zho, rëb me: ―¿Bla guietxtil ziaadnie to? ¡Goḻwi dieṉ! Zeeṉe biire zho güeyso zho, rëbchaa zho lo me: ―Loxaque gaay guietxtil ziaad, ni ziaad chop meḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dzigo bnabey me bzob grë miech co, wdzeepaaw bioogse lo guizh nguia ne zëëb ga ndxie zho. Tib dzoonga tib dzoonga zho bre, ");
INSERT INTO zpmNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","zaatne bre tib gayoo zho, zaatne breegaa groḻ gayoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Dzigo bzheṉ me gza gaay guietxtil co, ni grop meḻ co, blis lo me bui me nëz gbaa, bdeed me xquizh lo Dios. Blozh ga, beeṉgroḻ me guietxtil co, zigse rdeed mew lo xpëëdscuel me, scase scase noguiiz zhow lo grë miech co. Scaque beeṉ me grop meḻ co. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Grëse miech co, dow zho haxta zaatne bieltaa zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Miech tafa, zha bguise rgaa zig gaay mil; ni zeeṉe blozh dow zho, scase ncuaaṉe nroob biaaṉ, biodzë tsiipchop chicuid bio grë guietxtil co, bio grë meḻ co. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Zeeṉe blozh ga, bnabey Jesús xpëëdscuel me bzëëb zho leṉ barcw, zeeṉa zienerga zho tedquia zho stib nëz ro nis co, gdziṉ zho guiedz ne lë Betsaid; laa me bii blëz ga, nozonëz me grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Blozhse bzonëz me zho, dzigo güey me tib guic gui zob gax ga, güeyzodiidznie me Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Zig rguets liuw, laa barcw ne zie xpëëdscuel me ga no lo nis co. Laa me zo ga tipse me, ");
INSERT INTO zpmNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","raṉ me rlu ib gacd csëëniob zhow, sac rriee me rtsire mew. Merle guimbe liuw, tibaque zeeṉe goṉ zho laa me bdziṉ zaatne zie zho ga; tib lo nis co ziezë me, rac me zig nac zeeṉe tibted me lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Zeeṉe goṉ zho laa meṉ co sca ziaad-zë lo nis co, bdzieb zho, broptsie zho rnee zho: ―¡Tib ndziin i goṉ ziaad i! ");
INSERT INTO zpmNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sac grëse zho raṉlo zho laa me sca ziezë lo nis co. Dzigo bnee me lo zho rëb me: ―¡Gdziebde to, naa ziaḻ nu! ");
INSERT INTO zpmNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Zeeṉe laa me biep leṉ barcw ne zie zho ga, laa me co blëz; dzigo mazdraa bzee zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","¡Per ib rieṉd zho cho nac me, niicle ne goṉle zho beeṉ me milagr nroob co bguiaaṉ me miech guizhiu co! ");
INSERT INTO zpmNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Zeeṉe laa zho bdziṉ stib nëz ro nis co, zaatne nac xtan zha Genesaret, dzigo laa zho pxidoo xbarcw zho ro nis ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Loxaque biet me leṉ barcw laa grë miech co beeṉbeyle me. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Rias zho güey zho grë guiedz co, güeynie zho diidz laa me bdziṉ ga. Dzigo psilo grë miech co rxob zho zhimguidz zho lo yag, rdziṉnie zho zho lo me zaatne rontaa zho no me. ");
INSERT INTO zpmNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Zaatne gdziṉtaa me, niicle guiedz nrooba, niicle guiedz lasa, rbee grë miech co zhimguidz zho rienie zho zho zaatne nac leṉ guiedz; ga rnab zho lo me siguieḻ me maase ni lar ne mbixse me xeṉ grë meṉ rzacnë co. Ni grëse zha ne rzheṉ xab me, riac zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tib dze, bdziṉ bla zha farisé, ni zla maistr ley ne ziaad nëz Jerusalén, lo Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Dzigo goṉ zho blalaa zha ne nac xpëëdscuel Jesús, zeeṉe laa zho row rguiibd zho nia zho zigne nacpaa grë zhiwseed xmeṉgol zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Nac zha farisé, ni grësegaa zha Israel teḻne tsard nia zho zigne nac xcostumbr xmeṉgol zho, ible rowd zho; sac zienaḻdox zho miṉe nac costumbr. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Zeeṉe rbire zho lo lgui, ib no mod ne riar nia zho dzigoraa rzob zho row zho. Nzian grë wseed co psaṉ xmeṉgol zho zienaḻ zho, zig nac zha riar grë tas, grë cant, grë xtsiiṉ rotie zho miṉe niaa guiib, ni grë lo bangw ne rzob zho row zho.) ");
INSERT INTO zpmNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Dzigo rëb zho lo Jesús: ―¿Pe nacne zienaḻd xpëëdscuel luu miṉe blu xmeṉgol ne? ¿Pe nacne squize nia beed zho i row zho? ");
INSERT INTO zpmNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pquiab Jesús rëb me lo zho: ―Nlipaa miṉe bnee Isá, meṉ ne biaad pteed Xtiidz Dios, zeeṉe znu pquiaa me: Grë miech rii, rquiaalose zho ruṉnon zho naa, rond zho diidz guṉ zho miṉe rnabey naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Paat rquiind riaad zho riaadgaṉ zho naa; sac niapse guicle zho riab grë wseed ne quialu zho lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Sac teḻ to goṉ, nosaan to grë miṉe rnabey Dios, leḻ grë xcostumbr miech zienaḻ to. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","’Xcostumbr to nac miṉe mazdraa rioxco to, laa miṉe rnabey Dios quiasaṉ to tib lad. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Led znu goṉ rnee ley ne bdeed Dios lo Moisés: “Goṉ pxoz luu, goṉ xniaa luu”, ni no stib miṉe rnee: “Zha ne quie pxoz, quiegaa xniaa, ib none guet zho.” ");
INSERT INTO zpmNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Laa to leḻ rnee to, zac guṉd miech xyudar xmeṉgol zho, teḻne bloogonle zho pe nac ncuaaṉe rieguiaḻ gdeed zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tole rdeete diidz ga guṉ zho xyudar pxoz zho, xyudar xniaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tib ladle goṉ rsaṉ to Xley Dios ga sca ruṉ to, lëëpaaze grë costumbr ne biaaṉnie to, ni quiasaṉgaa to lo zha ne ziaadquia, miṉ co noxcoraa to. Ni nzianraa grë falt ne squi quiayuṉ to. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dzigo bnee me lo grëraa miech ne ndxie ga, rëb me lo zho: ―Goḻquiaadiag miṉe gni naa lo to nu, ni goḻtsoxco guieṉ to zha naca. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Goḻgacnaṉ gaṉle: Grë ncuaaṉe rdziṉ zdoo miech, led miṉcod ruṉctal xtoḻ zho; sinque grë ncuaaṉe ntseeb ne rza zdoo zho, miṉ co nac miṉe ruṉctal xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Laa zeeṉe laa me bdziṉ ro yu grë xpëëdscuel me, dzigo bnabdiidz zho lo me dieṉ zha nac diidz ne sca rëb me lo grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Rëbchaa me lo zho: ―¿Pe niicle to rieṉdaquew dzigo lëë? ¿Pe rieṉde to, grë ncuaaṉe row miech, led miṉcod ruṉctal xtoḻ zho? ");
INSERT INTO zpmNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sac grë ncuaaṉe row zho rdziṉda leṉ zdoomban zho, zhaa zaatne rdziṉa. Grë guieḻwagw, leṉ bziuud zdoose zho, leṉ zhitripse zho rieteda, rlozh ga rrieegaw xcuerp zho. Ga blu me lo zho gaṉle, grëse ncuaaṉe nac guieḻwagw lëda ruṉctal xtoḻ miech. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ni rëb me lo zho: ―Miṉe rza zdoomban miech, miṉ co nac miṉe ruṉctal xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sac zdoomban zho rza grë ncuaaṉe ntseeb ne ruṉ zho, zig nac: zeeṉe rio zho grë zhgab yozh, zeeṉe ruṉ zho grë guieḻyozh, zeeṉe rban zho, zeeṉe rut zho samiech zho, ");
INSERT INTO zpmNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","zeeṉe rionie zho zha ne nacd tsieeld zho, zeeṉe rzoobladz zho ncuaaṉe rap stib miech, zeeṉe ruṉ zho grë guieḻntseeb, zeeṉe rquidie zho, zeeṉe rien zho ruṉ zho grë ncuaaṉe ndzinlid, zeeṉe në rac zdoo zho raṉ zho cho zha ne stibnoded, zeeṉe rzhixcuaa zho diidzguizh, zeeṉe racniats zho, zeeṉe ruṉ zho grëraa ncuaaṉe paat rquiind. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Grëse ncuaaṉe ntseeb rii, zdoomban miech rzaw, ni lëëw nac miṉe ruṉctal xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ga briee Jesús, laa me zie nëz Tiro. Zeeṉe bdziṉ me nëz co ga bdziel tib yu ne blëz me, gocladz me choot niacnaṉd ne laa me no ga; per brieeloda, znuse bieṉ diidza. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Zeeṉe bin tib wnaa Sirofenis laa Jesús bdziṉ ga, dzigo güey me, sac noguitnie meṉdox tib xpëëd me. Zigne bdziṉ me pquiitsgzhib me lo Jesús, rnab me tsieguṉcxooṉ Jesús meṉdox co. Tib wnaa zit nac wnaa co; ");
INSERT INTO zpmNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","dzigo rëbchaa Jesús lo me: ―Blëz niip dieṉ. None glo mëëd gow, nonguieḻda cuee ne guiet nia mëëd gdeed new lo mëcw. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pquiab wnaa co, rëb me: ―Nli scaw, zigne rnee luu i; per niicle mëcwa led rio ma zhan mezh rtop ma grë miṉe rrieengaa nia mëëd. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dzigo rëbchaa Jesús: ―¡Squiw nagoṉ! Lëëgazha i rnee luu. Peet tsieniedraa guic luu naa sca; bzë, laa meṉdox ne nosacsi xpëëd luu bichele. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Laa wnaa co zey. Zeeṉe bdziṉ me lidz me, goṉ me iṉe laa xpëëd me nixse lo lon, per laa meṉdox co psaanle win. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ga briee Jesús, güeyted me nëz Sidón. Sidón briee me bdziṉ me ro Nisdoo Galilé stib, zaatne nac xtan zha Decápolis. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ga bdziṉnie zho tib mgui lo me, rcuaat mgui ni nca rnee mgui; bnab zho lo me cxobnia me guic mgui guṉguiac me mgui. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dzigo blee me mgui lad grë miech ne ndxie ga. Zitlaa güeynie me mgui, ga psëëb me mzhugnia me gropse leṉ diag mgui ni bdëëb me zhindzuc me lo ludz mgui. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Blozh ga, blis lo me bui me nëz gbaa, bneeladz zdoo me, dzigo rëb me: ―¡Bzhial! (¡Efata!) ");
INSERT INTO zpmNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Zigne sca bnee me, laa diag mgui co bzhial, niicle ludz mguiw laaw wban, laa mgui psilo bneenal. ");
INSERT INTO zpmNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dzigo pso Jesús diidz lo grë miech co, choot lo gzodiidzd zho zha biac mgui co. Per laa ne rso me diidz lo zho, dzigole nëzrii, nëzrec rzodiidz zhow; ");
INSERT INTO zpmNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","sac rzeedox zdoo zho goṉ zho miṉe beeṉ me ga. ―¡Ncuaaṉe gzee zdoo ne i beeṉ meṉ qui! ―rnee zho―. Zha haxta nguaat, haxta ngop, ruṉguiac me. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Leṉ dze co, miech guizhiu ne biire pcaalsa lo Jesús stib. Zeeṉe goc tsoṉ ngbidza, guieṉdraa ncuaaṉe gow zho. Dzigo bredz me xpëëdscuel me, rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Rquia zdoo naa grë miech rii, tsoṉle ngbidz ga rac blanso zho nu, ni na quianiedraa zho ncuaaṉe gow zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Teḻne squise zho gzonëz naa zho, glëbd zho, scow zho nëz, sac no zho zit briee zho ziaad zho nu. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pquiab zho rëb zho: ―¿Per pe yguiaaṉ ne zho? ¿Pa guioxi ne guietxtil ne gow grëtaa miech qui dan rii, naca zaatne guieṉd miech? ");
INSERT INTO zpmNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dzigo bnabdiidz me lo zho, rëb me: ―¿Bla guietxtil ziaadnie to i? ―Gadzaquew ―rëb zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dzigo bnabey me grëse miech co bzob zho liu. Blozh ga bzheṉ me gza guietxtil co, bdeed me xquizh lo Dios; blozhse bdeed me xquizh lo Dios, zigse noyuṉgroḻ mew, scase scase rdeed mew lo xpëëdscuel me rguiiz zhow lo grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Zienie zho zla meḻ las; bzheṉ me gza meḻ co bdeed me xquizh lo Dios, blozh ga bnabeyaque me zho bdiiz zho ma. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Grëse miech co, dow zho haxta zaatne bieltaa zho dzigo laa me bzonëz zho. Rgaa zho maase tap mil, ni zeeṉe blozh dow zho bii bdop gadz chicuid miṉe biaaṉ. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Blozh ga, laa me bzëëb leṉ barcw grë xpëëdscuel me, laa zho zie nëz xtan zha Dalmanut. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Blalaa zha farisé ne no nëz co, zeeṉe bin zho laa me bdziṉ ladz zho, güey zho rzadraa ncuaaṉe rlisqui zho lo me. Rnab zho glu me cho nac me, rëb zho lo me: ―Racladz no dziaṉlo no guṉ luu tib milagr, teḻne nli gbaa ziaad luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Zeeṉe goṉ me sca rac zho, bio me guieḻnë; dzigo haxta bneeladz zdoo me, rëb me lo zho: ―¿Zha rnaraa milagr ne racladz to gaṉ to? Gneli naa lo to gaṉle, ni stib milagr goṉ gaṉdraa to. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Blozhse sca rëb me lo zho, ndxieque zho ga laa me bzëëb leṉ barcw laa me zie stib nëz ro nis co. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Zeeṉe briee zho ga, zoladzd xpëëdscuel me ney zho ncuaaṉe niow zho, lëë gdib tib guietxtil zienie zho leṉ barcw. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Laa zho zie, tibaque zeeṉe rëb me lo zho: ―Goḻguieṉ goṉ, napaa noyac-wet to lo zhincobi zha farisé, lo zhincobigaa rey Herod. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Zeeṉe bin zho sca rëb me, bza zdoo zho rnee zho: ―Ne goṉ me nagoṉ ziaadnied ne guietxtil gane squi rnee me. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Bieṉ me sca rnee zho, dzigo rëbchaa me lo zho: ―¿Pe nacne rnee to ziaadniede to guietxtil? ¿Rieṉde to lëë zha rne naa? Ndip nac zdoo to gane rieṉde tow. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Pa rquiin lo to, pa rquiin diag to ne laaw zob? ");
INSERT INTO zpmNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Pe rsoladzde to zeeṉe gaayaque guietxtil ni bgaaw bguiaṉ naa gaay mil miech? ¿Bla chicuid biodzë miṉe biaaṉ hor co? Pquiab zho rëb zho: ―Tsiipchopa. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Dzigo rëbchaa me: ―Zeeṉe waa gadzaque guietxtil co, ni bguiaṉ naa tap mil miech, ¿bla chicuida biaaṉ? ―Gadz chicuida ―rëb zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dzigo rëb me lo zho: ―¿Pe niicle nana rieṉdaque to pe rne naa? ");
INSERT INTO zpmNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bdziṉ Jesús guiedz ne lë Betsaid, ga güeynie zho tib mgui ne rcow lo lo me, bnab zho cxobnia me guic mgui guṉguiac me mgui. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dzigo bzheṉ me nia mgui güeynie me mgui zaatne nacle ro guiedz co. Ga bdëëb me zhindzuc me leṉ bziaalo mgui, ni pquiaania me zhits guidlo mgui; blozh ga bnabdiidz me lo mgui dieṉ pe raṉle mgui palal. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Zeeṉe laa mgui bui, rëbchaa mgui: ―Raṉle naa niina nagoṉ laa miech ziezë; per masaque raṉ naa zho zig rlu grë yag. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dzigo biire pquiaania me zhits lo mgui. Zeeṉe laa mgui bui stib, ndiple rwi mgui laa lo mgui biacle. Grëse ncuaaṉe raṉ mgui, niicle zitraaw niini raṉ mguiw. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dzigo bzonëz Jesús mgui nëz lidz mgui, pso me diidz lo mgui tib nëz guey mgui, choot lo tsiezodiidzd mguiw lad guiedz. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Blozhse ga, laa Jesús briee ga grë xpëëdscuel me laa zho zie nëz Cesarea de Filipo, zieted zho grë guiedz las ne ndxie nëz co. Laa zho no nëz, tibaque zeeṉe bnabdiidz me rëb me lo zho: ―¿Cho dieṉ ron to rnee miech nac naa? ");
INSERT INTO zpmNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pquiab zho, rëb zho: ―No zho rnee Juan Bautista, no zho rnee Líw, meṉ ne biadteed xtiidz Dios padzeela; nogaa zho rnee no cho stib meṉ ne ziadteed xtiidz Diosa. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dzigo rëb me lo zho: ―¿To waa, cho rzac to nac naa? Pquiab Pedr, rëb Pedr lo me: ―¡Luu nac Meṉ ne zëëble diidz ga cxeeḻ Dios guiaad lo guidzliu! ");
INSERT INTO zpmNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dzigo pso me diidz lo zho choot lo gneed zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bded ga, psilo Jesús bzeet me lo grë xpëëdscuel me zha csacsi miech me. Rëb me nroob grë ncuaaṉe cteed zho me; grë zha non lo meṉguiedz, grë pxoz nroob, grë zha ne rseed miech ley, ible stsidiḻ zho me, ni haxta zut zho me; per zeeṉe gac tsoṉ ngbidz gut me laa me grieeban. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Grëse miṉe ted me, laaw nozodiidz me lo zho. Goṉ Pedr sca rnee me, dzigo bredz Pedr me, blisqui Pedr lo me dieṉ pe nacne rnee me laa me guet. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Zeeṉe goṉ me zha rzë xtiidz Pedr, zoque Pedr ga biecw me bui me lo grëraa xpëëdscuel me, goctox me rëb me: ―¡Biche lo naa nu meṉdox! Zienied guic luu miṉe rnabey Dios, sinque laa guic luu zienie miṉe racladz luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dzigo blunia me lo grë miech ne ndxie ga, yquiaadiag zho miṉe gnee me; rëb me: ―Zha ne racladz sëëb xnëz naa, none cueeladz zho zho, none lëb zho guiaadnaḻ zho miṉe rnabey naa, niicle teḻ miṉ co yquiaaqui csacsi miech zho. Nodne yquia zdoo zho xquieḻmban zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sac zha ne yquia zdoo xquieḻmban, leḻ znu nitlo zho; saṉgue zha ne sca cueeladz xquieḻmban porne rleynie zho naa, porne rleynie zho grë Diidz Ndzon rii, zha co ygaa tib guieḻmban ne mazdraa ndzon. ");
INSERT INTO zpmNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nana, teḻ zha ne guṉlo grëse ncuaaṉe no lo guidzliu rii. ¿Pa yquiin grë ncuaaṉ co lo zho, teḻ lëëw yquiaaqui laa zho guey gabiḻ? ");
INSERT INTO zpmNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Niacxe zrieelo gdziib zho dimi co laa zho leṉ gabiḻ? ");
INSERT INTO zpmNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Naa ne nac naa Meṉ ne pxeeḻ Dios ziaḻ naa lo guidzliu, zha ne ctoladz guiab zho lo grë miech ngoopdoḻ rii laa zho no xnëz naa, o ctoladzniegaa zho xtidz naa, scaque naa stoladznie naa zho gaḻ dze ne laa naa guiaḻ stib. Dze ne guiaḻnie naa grë anjl, ni glu naa grë guieḻndzon ne rap Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ni rëb me lo grë miech co: ―Gneli naa lo to gaṉle, nzian grë zha ne ndxie nu niina ib tedsod gardaque guet zho, bii zaṉ zho gaṉle zeeṉe laa Dios glu ne nli meṉ rnabey nac me. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Goca xoop ngbidz, briee Jesús gza me Pedr, Jacob ni Juan, güey zho bzoquia zho tib guic gui glaa. Bdziṉ zho glaa guic gui co, tibaque zeeṉe goṉ zho laa me bdzëëlo. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Masaque rquiabni xab me, nquitsbie rnaw; ni tib miech grieelod scataa mbe quiib lar. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Goṉlo zho zeeṉe laa Lí ni Moisés (grop zha ne biadteed xtiidz Dios glo) bdziṉaque, laa zho nozodiidznie me. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dzigo rëbchaa Pedr lo me: ―Maestro, ¡ne nligaa wena guiaaṉ ne nu! Laa no gzaa tsoṉ yu yag xiid win nu tso to: tiba tso luu, tiba tso Moisés, stiba tso Lí. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Rdzieb Pedr gza Pedr schop zha co, lo dzeb co niicle rieṉdaque Pedr pe rnee Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tibaque znuse bdop tib xcow pquia ngali zaatne zo zho ga; dzigo bin zho zëëb tib tsi meṉ co lo xcow co, rnee me: ―Lëë xpëëd naa i goṉ, rleynie naa me. Goḻgon miṉe rnee me. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Lëëlëd biecw lo zho rwi zho, choot goṉdraa zho, Jesússe zo lo zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Blozhse ga, laa zho wbique ga. Laa zho ziezëëb dan noyet zho cho gui co, zeeṉe rëb me lo zho: ―Miṉe goṉ to goṉ, choot lo gneede tow. Goḻcuëz haxta gaḻ dze ne grieeban Meṉ ne pxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nacne choot lo bneed zhow, per psilo zho gza tsoṉ zho rnabdiidzlsa zho, zha mod grieeban tib zha ne gutle. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dzigo bnabdiidz zho lo me, rëb zho: ―¿Bay zha nacne rnee maistr ley, glo Lí no guiaad stib, dzigoraa guiaad Meṉ ne zëëble diidz ga cxeeḻ Dios? ");
INSERT INTO zpmNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Pquiab me rëb me lo zho: ―Nliw, ible nacle diidz ne glo Lí guiadseed miech gon zho xtiidz Dios, per laa me biaadle; ni zigne bzeetse grë zha ne biadteed xtiidz Dios ted me, scase beeṉ miech me. Scaque Meṉ ne cxeeḻ Dios ga, rnee lo Xtiidz Dios nroob csacsi miech me, ible gaṉdzed zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Zeeṉe bdziṉ Jesús zaatne biaaṉ grëraa xpëëdscuel me ga, gza me Pedr Jacob ni Juan; goṉ zho miech guizhiu ne ndxie lo zho; blalaa zha ne nac maistr ley zo lo zho ga, nodiḻdiidznie zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Grë miech co, zeeṉe goṉ zho Jesús, rley zho, rias zho güeydzieelo zho me güeyquiaa bdiuzh zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dzigo bnabdiidz me rëb me: ―¿Pe nadieṉ squitaa nodiḻdiidz to? ");
INSERT INTO zpmNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lad grë miech co pquiab tib zho, rëb: ―Maestro, lo luu ziaḻnie naa tib xpëëd naa guṉguiac luu win; ib gacd gnee win sac noguitnie meṉdox win. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Teḻ pataa zo win, zeeṉe laa ma rzëëb zdoo win rroṉ ma win liu; ga nix win rdzib mtsiiṉ ro win, ni row lay win; nrooble noyo win lëbdraa win së win. Blansonie naa win nu, dzigo bnab naa lo xpëëdscuel luu guṉcxooṉ zho meṉdox co, per brieelod zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dzigo rëbchaa Jesús lo zho: ―¡Pe na squitaa miech nad nac to, ib rnalode to Dios! ¿Palal tiemp ne so naa gne naa lo to? ¡Ncuaaṉe cxecwdraa naa lo to squi nac to! ¡Goḻtënie mëëdwin qui nu! ");
INSERT INTO zpmNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Güey zho güeynie zho mëëdwin co lo me. Zigne goṉ meṉdox co me, psilo beeṉcxidz ma win, znuse biab win liu, rtiibxto win ni rdzib mtsiiṉ ro win. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Dzigo bnabdiidz me lo pxoz win, goc palal dze psilo sca rac win. Rëbchaa pxoz win: ―Bii mëdyeeṉ win psilo squi rac win. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pe zhidaa vuelt zieroṉ meṉdox qui win lo gui, zieroṉ ma win lo nis ne, racladz ma gut ma win. Bzhiguieḻ teḻne zrieelo guṉguiac luu xpëëd naa, ¡pquia zdoo naa, beeṉ tib guieḻnzaac beeṉguiac win! ");
INSERT INTO zpmNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Rëbchaa Jesús lo me: ―¿Zha rnee luu “teḻne zrieelow”? ¡Zha ne dib zdoo rnalo Dios, grëse ncuaaṉe racladz zho, zaca! ");
INSERT INTO zpmNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lëëlëd pquiab pxoz mëëd co, rëb me: ―Rnalo naa Dios, per bzhiguieḻ beeṉ xyudar naa, ¡dib zdoo naa gnalo naa me! ");
INSERT INTO zpmNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Zeeṉe goṉ Jesús laa grë miech co rbigberaa, dzigo goctox me lo meṉdox ne noguitnie mëëd co, rëb me: ―Meṉdox, luu goṉ psaṉ ngop mëëd rii, luu psaṉ nguaat win. ¡Niinagazh psaan win, ib gbiiredraa luu ygaaḻ luu win! ");
INSERT INTO zpmNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Horco biire beeṉcxidz ma mëëd co stib, masaque roptsiedan ma laa psaan win, nixtaque win ga, zootle gutle win. Nzian grë miech co, tibaque naṉ zho gutle win. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Laa zeeṉe bzheṉ Jesús nia win, blis me win ga, laa win bzoli. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Zeeṉe bdziṉ Jesús leṉ yu ne rbëz me grë xpëëdscuel me, bnabdiidz zho lo me rëb zho: ―¿Bay pe nacne brieelod no ndziuṉcxooṉ no meṉdox co? ");
INSERT INTO zpmNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Dzigo rëbchaa me lo zho: ―Grë meṉdox ne sca nac, rquiin dib zdoo ne gnab ne lo Dios dzigo zrieelo guṉcxooṉ ne ma. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Briee Jesús ga grë xpëëdscuel me, laa zho wbire nëz xtan Galilé stib. Racladzd me cho gacnaṉ pa lo no me; sac leṉ dze co nzian grë ncuaaṉe noseed me zho. Haxta bzeet me zha csacsi miech me, rëb me: ―Naa ne nac naa Meṉ ne pxeeḻ Dios, ible ziaab naa ladznia miech, ni zut zho naa. Per zeeṉe gac tsoṉ ngbidz gut naa, laa naa grieeban. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per ib rieṉd zho pe nacne sca rnee me, niicle gnabdiidzgaa zho rdzieb zho gnabdiidz zhow lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bdziṉ zho guiedz ne lë Capernaum; grëse zho laa zho ndxie leṉ yu ne blëz zho, tibaque bnabdiidz Jesús lo zho, rëb me: ―Goḻnë dieṉ, ¿pe scataa nodiḻdiidz to zeeṉe ziaad ne nëz? ");
INSERT INTO zpmNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ni tib zho ib pquiabd, sac zeeṉe ziaad zho nëz quianeelsa zho dieṉ cho nac zha ne nonraa. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dzigo bzob me, bredz me zho gza tsiipchop zho rëb me lo zho: ―Zha ne racladz gac zho zha non, none guiaaṉwin zho gac zho zig tib nguṉdziin lo samiech zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dzigo bzo me tib mëëdbgui win glowtaa lo zho; blozh ga bdeedz me win ni rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Zha ne ngab xnëz naa, ni gleynie zho tib mëëdwin zig mëëdwin rii, guṉ naa cuent naa ga rleynie zho; ni zha ne sca rleynie naa, yele meṉ ne pxeeḻ naa ga rleynie zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Blozh ga, rëbchaa Juan lo me: ―Maestro, bdzioṉ no goṉ bzeet tib zha co lë luu zeeṉe beṉcxooṉ zho meṉdox; nacne nli blisqui now lo zho, sac goṉ, led yed zho nacgrë ne. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dzigo pquiab me rëb me lo zho: ―¡Guṉscade to! Sac goṉ zha ne sca rzeet lë naa zeeṉe ruṉ zho milagr, niacxe lëëque zha glëë lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Zha ne nacnie ne, glëëd zho lo ne. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","’Goḻgacnaṉ sca gaṉle, grëse zha ne gdeed maase tib zhigaque nis guie zha ne ngab lo naa, ib tedsod stsire Dios miṉe beeṉ zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Saṉgue zha ne yguib guṉctal zho xtoḻ zho ne nac zho zig tib mëëdlas yeeṉ; mazd lëëtaa miṉe ted zha co sobdoo tib quie molin zhobxtil yquiaw yaṉ zho tsieroṉ zho zho nisdoo. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","’Zha ne rieṉ nia zho nac miṉe rquiaqui ruṉctal zho xtoḻ zho, mazd cchuggazh zho nia co zho. Peet nacd maase tibaque nia zho zob totsaque ygaa zho guieḻmban ndzon ne gdziṉd dze lozh, lëdle zob gropa ni laa zho guey gabiḻ, lo beldox ne gdziṉd dze guiuu. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Teḻne rieṉgaa zho ni zho nac miṉe rquiaqui ruṉctal zho xtoḻ zho, mazd cchuggazh zho ni co zho. Peet nacd maase tibaque ni zho zob totsaque ygaa zho guieḻmban ndzon ne gdziṉd dze lozh, lëdle zob gropa ni laa zho guey gabiḻ, lo beldox ne gdziṉd dze guiuu. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Teḻ tib logaa zho nac miṉe rquiaqui ruṉctal zho xtoḻ zho, mazd cueegazh zho bziaalo co zho. Peet nacd maase tibaque bziaalo zho zob totsaque ygaa zho guieḻmban ndzon co, lëdle zob grop bziaalo zho ni laa zho guey gabiḻ. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Zaatne nac gabiḻ, ib gdziṉd dze ne guiuu lo bel co; grë mziog ne ndxie ga, gdziṉd dze ne nitlo ma. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Grëse zha ne gdziṉ ga, masaque cuib gui lad zho zig rbib zed lad bëël. ");
INSERT INTO zpmNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","’Zig nac zed, rquiindoxa zeeṉe nzhiw, per zeeṉe nzhida, ¿pa dieṉ yquiina? Scaquegaa to nagoṉ goḻgac zig zed ne nzhi, zeeṉa yquiin to lo guidzliu rii; niowse goḻbannie samiech to, glëëlsade to. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Briee Jesús Capernaum güeyted me grë guiedz ne ndxie nëz xtan zha Judé, grë guiedz ne ndxie nëz daṉ ro guiubee Jordán. Miech guizhiu ne rcaalsa lo me, dzigo rsilo me rseed me zho zigne ruṉtaque me. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tib vuelt bdziṉ bla zha farisé gocladz zho niuṉgüet zho me, par dieṉ pe nxiṉd me tib diidz; bnabdiidz zho rëb zho: ―Maestro, mgui ne racladz csëbtsieel, ¿pe gnë luu pe zrieelo csëbtsieel zho? ");
INSERT INTO zpmNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Pquiab me rëb me lo zho: ―¿Zha zho psaṉ Moisés diidz lo to? ");
INSERT INTO zpmNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pquiab zho rëb zho: ―Teḻ Moisésa, bdeed me diidz csëbtsieel zha ne racladz csëbtsieel, lëëraasi none yquia tib guits gdeed zho lo wnaa zaatne raquiet ne laa zho psaan wnaa. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dzigo rëbchaa me lo zho: ―Ne squicxe waa miech nad nac to ib ronde to diidz, miṉ co nacne biaaṉ ley co. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Per ib nodne csëbtsieel miech; sac goṉ, zeeṉe psaṉ Dios grëtaa ncuaaṉe no, tib nëz miech bzaa me: tib mgui ni tib wnaa. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Gacxe waa, mgui ne rtsieelnia ib none grieezhaa zho lo pxoz zho, lo xniaa zho, par gbannie zho wnaa ne nac tsieel zho; laa zho gactipse grop zho. Nacdraa zho chop miech, sinque laa zho rac tibaque. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dios nac meṉ ne psaṉ ycatsieel miech, cho dzigo nac miech par quiits zho miṉe rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Laa zeeṉe bdziṉ me leṉ yu ne rbëz zho, dzigo bnabdiidzaque xpëëdscuel me miṉ co lo me stib. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Dzigo rëbchaa me lo zho: ―Mgui ne rsëbtsieel ni rbannie zho stib wnaa, noguitnie zho wnaa ne gocpaa tsieel zho ga, ni doḻ ga ruṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Niicle wnaagaaw, wnaa ne rsëbtsieel ni rbannie zho stib mgui, lëëque doḻaque ga ruṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tib vuelt nzian meṉ ne bdziṉ bdziṉnie zho xpëëdlas zho lo Jesús, par cxobnia me guic win guṉlay me win. Grë zha ne nac xpëëdscuel me, leḻ psilo zho ndox zho lo grë zha ne bdziṉnie grë mëëdlas co. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","15","Zeeṉe goṉ me sca quiayuṉ zho, wbiṉladz guic me, dzigo rëb me lo zho: ―Ctsirede to grë mëëdlas yeeṉ qui, goḻsaan guiaad win lo naa. Sac goṉ grë mëëdlas yeeṉ, ni zha ne nac zigne nac win, zha co nac zha ne sëëb ygab lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Blozhse sca bnee me, dzigo psilo me bdeedz grë mëëdlas co, ni pxobnia me guic win beeṉlay me win. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Laa Jesús nole nëz tsie me stib guiedz, zeeṉe rias tib niib nguieg bdziṉ pquiitsgzhib lo me, rëb niib lo me: ―Naṉ naa luu nac tib meṉ ne noseed miech, ni tib meṉ wen nac luu; ¿bnë dieṉ pe nac miṉe guṉ naa zeeṉa ygaa naa guieḻmban ndzon ne gdziṉdraa dze lozh? ");
INSERT INTO zpmNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Rëbchaa Jesús lo niib: ―Rnee luu lëë tib meṉ wen nac naa. ¡Nligaaw, Diosse nac meṉ wen! ");
INSERT INTO zpmNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Naṉle luu gaṉle zha nac Xley Dios, rneew: Gute luu samiech luu, teḻne nole tsieel luu, tsonied luu zha ne led tsieeld luu, cuand luu samiech luu, yquiadiidzguizhd luu samiech luu, yquidieed luu samiech luu, goṉ pxoz luu, goṉ xniaa luu; bin miṉe rnabey me luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dzigo pquiab niib rëb niib lo me: ―Maestro, grësew zigne bzeetse luuw i, ni tiba gard quits naa wlal ne nac naa zha nguieg. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dze rwi Jesús lo niib, rleynie me niib. ―Stibaque miṉe rquiin guṉ luu ―rëb me―, güey, güeyto grëse ncuaaṉe quianie luu, dzigo bdiiz dimi co lo grë zha mban ne guieṉd pe yquiin; sca nroobraa guieḻnzaac ne ygaa luu gbaa. Lozh ga, bleeladz xquieḻmban luu dënaḻ zhits naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Zeeṉe bin niib co sca rëb Jesús, biab guieḻnë niib, mbanse rac niib laa niib zey; sac ne nligaa nroob ncuaaṉe quianie niib. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dze rwi me goṉ me laa zha nguieg co zey, dzigo rëb me lo xpëëdscuel me: ―¡Grë zha ne squi rapcheṉ, rzacxuu zho par sëëb zho xnëz Dios gnabey me zho! ");
INSERT INTO zpmNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Zeeṉe bin zho sca rëb me, rzee zdoo zho. Dzigo biire me bnee me rëb me lo zho: ―Xin, ¡ne nligaa tib miech ne ndziib rap cheṉ, rzacxuu zho sëëb zho xnëz Dios gnabey Dios zho! ");
INSERT INTO zpmNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mazd znuse rded tib camell guieer guzh, lëdle sëëb tib zha ricw xnëz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Zeeṉe bin zho sca rëb me, mazdraa bzee zdoo zho, rnabdiidzlsa zho rnee zho: ―Bay, ¿chose dzigo nac zha ne zrieelo sëëb xnëz Dios? ");
INSERT INTO zpmNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dze rwi me lo zho, dzigo rëbchaa me: ―Par miech zootle tsod zha ne grieelo sëëb xnëz me. Saṉgue me, naṉ me no zho; sac tsod ncuaaṉe grieelod guṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dzigo rëb Pedr lo me: ―Teḻ no, grëse ncuaaṉe rdziaap no laa no psaṉa, laa no ziaadnaḻ zhits luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pquiab me rëb me: ―Grëse zha ne psaṉ lidz, psaṉ zho bets zho, bzian zho, xniaa zho, pxoz zho, xpëëd zho, liuṉ zho, porne rliladz zho naa ni rliladz zho Xtiidz Ndzon Dios; ");
INSERT INTO zpmNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nli nroob guieḻnë gaṉ zho, per gneli naa lo to gaṉle: grëse ncuaaṉe sca psaṉ zho ga, lo guieḻmban riique laa zho gbiire gaṉa stib tib gayoogaw tib tiba; ni ib tedsod zgaa zho tib guieḻmban ndzon ne gdziṉdraa dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","’Nli zig nac niina, no zha ne rzac zha non nac zho, per zeeṉe gaḻ dze co peet gacnond zho; laa zha ne rzac zho peet nond, gaḻ dze co lalga gac zho grë zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Briee Jesús ga laa me zie Jerusalén. Nzian grë zha ne zienaḻ zhits me, nerse me lo zho laa zho zie. Grë zha ne nac xpëëdscuel mew, rzee zdoo zho; laa grëraa miech co per nli rdzieb zho. Dzigo bredz me gza tsiipchop zha ne nac xpëëdscuel me ga, psilo me bzeet me grëse teḻ zha ziaadyob ted me, rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Bii zaṉ to gaṉle, naa ne nac naa Meṉ ne pxeeḻ Dios, niina ne laa ne gdziṉ Jerusalén ible zielo zho naa ladznia grë zha ne nac pxoz nroob ni grë zha ne rseed miech ley. Grë zha co gnab guet naa, ni saṉ zho naa ladznia grë zha ne nacdraa zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Xidznie zho naa, stsuc zho lo naa, zguiṉ zho naa, ni haxta zut zho naa; per dze ne gac tsoṉ ngbidz gut naa laa naa grieeban. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Dzigo wbig gax Jacob grop Juan (xingan Zebedé) lo me, rëb zho: ―Maestro, laa no gnab tib favor lo luu, per racladz no siguieḻ luu guṉ luuw. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Dzigo rëb me: ―¿Pe favor ne racladz to guṉ naa lo to? ");
INSERT INTO zpmNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Rëbchaa zho: ―Laa no racladz, siguieḻ luu zioob no cue luu gaḻ dze ne laa luu nac rey rnabey luu, tib no nëz derech stib no nëz revés. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pquiab Jesús, rëb me lo zho: ―¡Ni to goṉ rieṉd pe rnab to! ¿Pe zlëb to gaṉ to grë guieḻnë ne gaṉ naa, pe zlëb to ted to grë miṉe teed naa? ");
INSERT INTO zpmNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Rëbchaa zho: ―¡Zlëëb no! Dzigo rëbchaa me lo zho: ―Nli zaṉ to guieḻnë ne gaṉ naa, ni zded to miṉe teed naa; ");
INSERT INTO zpmNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","per ne gnedz naa diidz sob to cue naa nëz derech o nëz revésgaa, led naad raguiaḻ miṉ co; laa lugar co biaaṉle par zha ne nole diidz ygaaw. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Grëraa zha ne nac xpëëdscuel me, zha ne nacgza Jacob ga grop Juan, zeeṉe bin zho zha rzë xtiidz Jacob grop Juan blëë zho lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dzigo bredz Jesús zho grëse zho, rëb me lo zho: ―Raṉ to gaṉle zha ruṉ grë zha ne rnabey grë guiedz ne ndxie lo guidzliu, ni grë zha ne nac zha non, masaque rnabey zho samiech zho zigne racladztaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Saṉgue to goṉ, guṉscade to. Lo gza to, zha ne racladz gac zho zha non lo to, laa ne glu zho zha non zho, none glo zho guiaaṉwin gac zho zig tib nguṉdziin lo to. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Scaquegaa, zha ne racladz gnabey lo to, none glo cseed zho guṉ zho miṉe gnabey to zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Goḻgaṉ gaṉle, niicle naa ne nac naa Meṉ ne pxeeḻ Dios, ziaḻd naa par gnabey naa miech, sinque laa naa ziaḻ par gac naa tib nguṉdziin lo zho, ni gded naa xquieḻmban naa zeeṉa laa zho lo grëtaa ncuaaṉe ngadoo zho. Ni naṉpaa naa miech guizhiu ne laa. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sca no grë miech guizhiu co nëz, laa zho bdziṉ guiedz Jericó. Laa zeeṉe laa grë miech taf co zieriee ro guiedz co, laa tib mgui ciegw lë Bartimé zob ga rtop gon (xingan tib meṉ lë Timew). ");
INSERT INTO zpmNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Zeeṉe bin Bartimé ye Jesús (Nazaren) ziaad ga, psilo me nguiedz rbedz me, rnee me: ―¡Jesús, meṉ xtii rey David, pquia zdoo naa! ");
INSERT INTO zpmNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nzian grë miech co ndox lo me naṉ zho guioog ro me, per dzigole mazdraa nguiedz roptsie me, rnee me: ―¡Jesús, pquia zdoo naa! ");
INSERT INTO zpmNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dzigo pcuëëzni Jesús, bnabey Jesús güeytsedz zho me. Bdziṉ zho lo me, rëb zho: ―¡Ligier guso i! Dë gaṉle laa me rbedz luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Zeeṉe bin mew, haxta squi broṉ me lar ne mbix me, guso me ga laa me bdziṉ lo Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Dzigo rëbchaa Jesús lo me: ―Bnë nadieṉ, ¿pe racladz luu guṉ naa? Pquiab me rëb me: ―Maestro, racladz naa guiac lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dzigo rëbchaa Jesús: ―¡Niinagazh laa lo luu gaṉ! Laa luu biac, sacne dib zdoo luu bnalo luu naa. Ligier na bzë. Horcogazha laa lo meṉ co psilo bui, laa me zienaḻ zhits Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Zhile gdziṉ zho Jerusalén, laa zho zie gax zaatne riaaṉ guiedz Betfagé ni guiedz Betain, nëz daṉ squi riaaṉ Gui Oliv, zeeṉe bredz Jesús chop xpëëdscuel me ");
INSERT INTO zpmNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","rëb me lo zho: ―Goḻtsie guiedz win ne ndxie daṉse lo ne i. Zigne sëëb to lad guiedz, laa tib burr quiadoo ga, ni tib miech gard sob lad ma; dzigo goḻxadz ma, goḻtënie ma nu. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Teḻ cho gnabdiidz pe nacne noxadz to ma, dzigo goḻguiab: meṉ ne rnabey ne meṉ co rquiin ma, na zigne lozh xtsiiṉ ma guiaadsaṉ no ma. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Laa zho zie, nligaaw laa zho güeydziel burr co quiadoo ma tib ro nëz, gax tib ro yu. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Blalaa zha ne zo ga, zeeṉe goṉ zho laa zho noxadz ma, rëbchaa zho: ―¿Pe guṉ to burr qui dzigo na, ne noxadz to ma? ");
INSERT INTO zpmNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dzigo pquiab zho zigne rëbse Jesús lo zho ga, nacne bdeed meṉ co diidz laa zho zienie ma. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bdziṉnie zho ma lo Jesús lëëque lar ne rbix zho pxob zho lad ma, bzobga me ma. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nzian grë miech co zigse zie Jesús, scase scase ner zho rta zho lar ne rbix zho rded me, nogaa zho rchoo nia grë pe yag rdziiṉ zho zaatne rded me. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Grëse zho, niicle zha ne ner lo mew, niicle zha ne naḻ zhits mew, rley zho nguiedz roptsie zho, rnee zho: ―¡Zha ndzontaa meṉ qui pxeeḻ Dios lo ne! ");
INSERT INTO zpmNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Zha wentaa ziaad me gac me zhirey ne! ¡Me gnabey zigne bnabey pxozgol ne rey David! ¡Zha ndzontaa Dios ne zob gbaa! Sca nguiedz roptsie zho rleynie zho me, laa me bdziṉ Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Bdziṉ me Jerusalén, güey me güeyso me leṉ yadoo. Blozhse bui me dipse leṉ yadoo, laa me brieeque ga laa me zie nëz Betain grë xpëëdscuel me, sac bdzele dzew. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Biini liu, loxaque zieriee zho Betain laa me psilo rcaabedz. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Zitlaa ziaad me goṉ me tib zhan yag guigw, nxii nac low zëëb zhiblaga; dzigo zie me zieso me dieṉ pe gdzield tib guigw low gow me. Bdziṉ me zaatne zoba, ni tib guigw guieṉd low loxaque zhiblagsew scataa zëëb, sac gardpaa gdziṉ mëë ne rquia guigw. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dzigo rëb me lo yag guigw co: ―¡Squitaa nagoṉ guiaaṉ luu! ¡Gdziṉdraa dze yquia nex lo luu gow miech! Grëse xpëëdscuel me, bin zho sca bnee me lo yag co. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bdziṉ zho Jerusalén, bzëëb me leṉ yadoo. Psilo me blee me grëse miech ne quiayuṉ lgui ga, zigtaa zha ne no wtow, zigtaa zha ne no wziw. Grë zha ne no wto palom, grë zha ne notsëë dimi, ptiixche me xmezh zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Blozh ga, pso me diidz choot nodraa sëëbnie grë ncuaaṉ co leṉ yadoo, ");
INSERT INTO zpmNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","rëb me lo zho: ―Led znu goṉ rnee lo Xtiidz Dios: “Zaatne nac lidz naa nu, nu guiaad grëse miech ne ndxie lo guidzliu sodiidznie zho naa.” Laa to goṉ quiayuṉ to lugar rii zig tib zhibliee ngbaan. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Grë zha ne nac pxoz nroob ni grë zha ne rnabey lo maistr ley, bin zho sca rëb me, dzigo psilo zho rguib zho dieṉ zha gdeeda diidz gut zho me. Per rdzieb zho lega gnaaz zho me, sac ndal miech ne rley rquiaadiag zhiwseed me. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Zeeṉe laa liu pcow, laa me wbique Jerusalén stib grë xpëëdscuel me. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Biini liu co, laa zho zieded zaatne zob yag guigw ne sca güeyguib me nex lo ga, goṉ zho laaw bidzle dib low. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dzigo beeṉcsoladz Pedr mew, rëb Pedr: ―Maestro, bui gaṉle laa yag guigw ne bdzibdee luu ga bidzle. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pquiab me rëb me: ―Zha ne dib zdoo rnalo Dios, ");
INSERT INTO zpmNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","gneli naa lo to gaṉle: Niicle ncuaaṉe mazdraa ngaṉ gnab zho lo me, zuṉ mew; lëëraasi none dib zdoo zho gliladz zho zac miṉe rnee zho, ni palal gacchopd guic zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Goḻgona sca gaṉle, grëse ncuaaṉe gnab to lo Dios, dib zdoo to goḻliladz ne zneedz mew, dzigo sca zac miṉe rnab to. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ni zeeṉe gnab to lo Dios, goḻsoladz dieṉ pe no cho rlëënie to, dzigo goḻguṉ zho perdon; zeeṉa scagaa, Pxoz to meṉ ne zob gbaa zuṉ me to perdon teḻ pe nactaa xtoḻ to. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Sac teḻne guṉde to samiech to perdon, dzigo niicle megaa, guṉd me to perdon. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Blozh ga, laa zho bdziṉaque Jerusalén stib. Lëëtaaque laa Jesús quiawi dib leṉ yadoo, zeeṉe bdziṉ bla zha ne nac pxoz nroob, bla zha ne nac maistr ley ni zha ne nac meṉ non lo meṉguiedz, ");
INSERT INTO zpmNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","rëb zho lo me: ―¿Cho dieṉ nac luu ne squitaa ziaadnabey luu leṉ yadoo? ¿Cho rnabey luu? ");
INSERT INTO zpmNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Pquiab me rëb me lo zho: ―Laa naa guṉ tib wnabdiidz lo to. Teḻne stsire to low, dzigo gni naa lo to gaṉle cho rnabey naa ne laa naa noyuṉ grë ncuaaṉe noyuṉ naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Goḻnë dieṉ, ¿cho pxeeḻ Juan biaad me pchoobnis me miech? ¿Pe Dios pxeeḻ me, te miechsew ye? ");
INSERT INTO zpmNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Psilo zho rnabdiidzlsa zho, rnee zho: ―Teḻne dzieets ne Dios pxeeḻ Juan, dzigo laa me gnë: “¿Pex nac dzigo waa bliladzde to miṉe bnee Juan?” ");
INSERT INTO zpmNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Teḻ na dzieetsgaa ne: “Miechse pxeeḻ Juan, grieequiadaque ne.” Rdzieb zho niab zho miech pxeeḻ Juan, sac grëse meṉguiedz naṉ ne nli Dios pxeeḻ Juan biadteed Juan xtiidz Dios lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Dzigo mazd miṉe beeṉ zho, rëb zho: ―Ndioṉd no dieṉ cho pxeeḻ Juan. Dzigo rëbchaa me lo zho: ―Niicle naagaa nagoṉ, grieelod gni naa lo to cho rnabey naa quiayuṉ naa grë ncuaaṉ rii. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dzigo psilo Jesús bzodiidz me tib cuent, rëb me: ―Tib mgui name, nroob lbë uv beeṉbni me lo liuṉ me. Psilo me ptse me igose liu co, bzaa me zaatne gzhii grë uv co, ni bzaa me tib yu glaa zaatne sob zha ne yquiaanapa. Blozh ga, blediiṉ me liu co lo bla zha ne ran liu, dzigo laa me briee ga, laa me zey zit. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’Zeeṉe goḻ mëë ne ral uv, pxeeḻ me tib xmoz me lo zha ne quianap liu co, parne gdeed zho uv ne rieguiaḻ me ycaa me. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Per leḻ bnaaz zho moz co, bdiṉ zho zho; blozh ga, scase bzonëz zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","’Dzigo biire meṉ ne naccheṉ liu co pxeeḻ me stib moz, scasaque beeṉ zho: gocntseeb zho lo moz co, pquiaago zho zho, bdiṉ zho zho, blë zho guic zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","’Biireque me pxeeḻ me stib zho, zha cole beet zho. Ni bii pxeeḻ me nzianraa zho, no zho psiwee zho, nogaa zho beet zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tibaque zeeṉe loxaque xinganse me riaaṉ. Rleyniedox me xpëëd me, per laa me pxeeḻ me, bza guic me rëb me: “Gaṉse zho xpëëd naaw, zon zho miṉe gnee me.” ");
INSERT INTO zpmNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","’Zeeṉe goṉ zho laa xpëëd me bdziṉ, rëbchaa zho: “¡Lëë zha qui nagoṉ guiaaṉnie liu rii! ¡Goḻgotsaa dziuut ne zho zeeṉe guiaaṉa lo ne!” ");
INSERT INTO zpmNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dzigo bnaaz zho meṉ co, beet zho me, güeyga zho güeyroṉ zho me tib lad lo liu co. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Sca nagoṉ ―rëb Jesús―, beeṉ zha ne quianap liu co. Goḻnëse nadieṉ, ¿pe nac miṉe guṉ bizhuan liu co? Ib tedsod zeeṉe laa me guiaad, znitlo me zha co; zhaale lo zha ne csaṉ me liuṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Goḻsoladz gaṉle znu rnee lo Xtiidz Dios: Quie ne psëëb zha ne nozaa yu, ni naṉd zho lëëpaa quie co nac miṉe rnazdziits yu. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","¡Ncuaaṉe gzee zdoo new! Sac Dios bnabey sca goca. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zeeṉe goṉ zho sca bnee me, gocladz zho naazgazh zho me ga; sac bieṉ zho miṉe ruṉ zho ga bzeet me. Per bnaazd zho me, sac rdzieb zho grë miech guizhiu ne ndxie ga, nacne zeyga zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Zhisaque goca, laa zho pxeeḻaque zla zha farisé, ni zla zha ne nacnie Herod, zie zho zieguṉgüet zho Jesús par dieṉ zha cxiṉ me tib diidz; zeeṉa sca gdeeda diidz tsiezo zho me lo wxtis. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bdziṉ zho lo me, rëb zho: ―Maestro, ndioṉ no niapse diidzli rnee luu, led lega guṉd luu miṉe rnee tib miech, sac tibeyse nac miech lo luu, ni laa luu zienaḻ cseed zho miṉe nac diidzli zeeṉa sëëb zho xnëz Dios. Miṉ co nagoṉ, nacne racladz no gnë luu lo no dieṉ, ¿pe nonguieḻa ga rdeed no dimi ne razh lo rey te nonguieḻda ye? ¿Pe zdizhraa no dimi co, te mazd dizhdraa now ye? ");
INSERT INTO zpmNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bieṉga Jesús racladz zho guṉgüet zho me, dzigo rëbchaa me lo zho: ―¿Pe nacne racladz to guṉgüet to naa? Goḻguiid tib xpes to nu gaṉle. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dzigo bdeed zho tib pes lo me. Blozh ga, rëbchaa me lo zho: ―Goḻnë lo naa dieṉ, ¿cho nu quia lo pes rii? ¿Cho lë nu quia low? Pquiab zho rëb zho: ―Lëë rey Roma i, lëë lë me i quia low. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dzigo rëb me lo zho: ―Miṉe nonguieḻ ycaa rey, goḻdeeda lo rey; scaquegaa miṉe nonguieḻ ycaa Dios, lo Dios goḻdeeda. Zeeṉe goṉ zho sca ptsire me lo xtiidz zho, rdzieldraa zho zha guṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bdziṉaque zla zha saducé, rëb zho lo me: ");
INSERT INTO zpmNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, znu pquiaa Moisés lo libr ley ne psaṉ Moisés lo no: teḻ glo mgui guet lo wnaa ne nac tsieel mgui ni gopd wnaa mëëd, dzigo none betsaque zho ctsieelnia wnaa co stib, zeeṉa gap wnaa mëëd ne guiaaṉ xlugar xpëëd zha ne gut ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","’Bio tib dii zha co znu bzhaac, gadz bets nac zho. Ptsieelnia zha ne nac zha gol, zeeṉe laa zho gut, biaaṉd xpëëd zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dzigo ptsieelnia stib bets zho wnaa co, blozh ga gutaque zha co, pasë zho nsaṉ mëëd. Ptsieelniaque me stib zho, goc zho tsoṉ, niicle zha co psaṉdaque mëëd. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sca sca haxta bza gza gadzse zho ptsieelnia me, per ziese zho ni tib zho psaṉd mëëd; tibaque zeeṉe yeque me, laa me gut. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Miṉe racladz no gacndioṉ no, ¿chopaa dzigo gac tsieel wnaa co gaḻ dze ne laa zho grieeban; sac gza gadzse zho ptsieelnia me? Sca bnabdiidz zho, sac nac zha saducé rliladzd zho ne nli zdziṉ dze grieeban zha ne ret. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Dzigo pquiab Jesús rëb me lo zho: ―I nagoṉ laa to rxiṉ. Miṉe naca rieṉde to zha nac Xtiidz Dios, niicle rliladzde to zrieelo me guṉ me ncuaaṉ ro ne gard gaṉ miech. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sac goṉ, zeeṉe gaḻ dze ne laa grë miech grieeban, niicle mguiw niicle wnaaw led yedraa hor co dieṉ cho ctsieelnia zho; sac hor co laa zho gac zig nac grë anjl ne no gbaa. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Stiba, ible nli zrieeban meṉgut. ¿Pe gard gaṉle glab to lo guits ne pquiaa Moisés, zaatne ziaad zeeṉe bin Moisés tsi Dios tib lo yag zarz nguia ne noyazbel? Rëb Dios lo Moisés: “Naa nac Dios ne rliladz Abraham, naa nac Dios ne rliladz Isaac, naa nac Dios ne rliladz Jacob.” ");
INSERT INTO zpmNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Niicle ne gutle gza zha co hor co, per zeeṉe sca bnee Dios, gase rlu ne mban zho no zho lo me. Sac teḻ Dios, nacd me xDios meṉgut sinque xDios zha mban nac me. Ise nagoṉ rlu, peet rieṉde to gane squi rnee to. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Zeeṉe sca nozodiidznie Jesús zha saducé co, goṉ tib maistr ley niapse diidzli ptsire me lo xtiidz zho. Dzigo wbig maistr ley co, bnabdiidz me lo Jesús, rëb me: ―Bzhiguieḻ bnë lo naa dieṉ, lo grë xley Dios, ¿pa miṉ nac miṉe mazdraa non? ");
INSERT INTO zpmNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Pquiab Jesús rëb me: ―Miṉ rii nac miṉe mazdraa non, znu rneew: “Grëse to meṉ Israel, goḻquiaadiaga gaṉle: meṉ ne nac Dios ne rliladz ne, tibaque me ni me nac meṉ ne rnabey ne. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dib zdoo to, dib xalm to, dib guieḻbiini ne no guic to, dipse xfuers to goḻleynie me.” Lëë tiba nu, ");
INSERT INTO zpmNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","laa stiba znu rnee: “Bleynie samiech luu zigne rleynie luu luu.” Tsodraa stib ley ne mazdraa non lo grop ley rii. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dzigo rëbchaa maistr ley co lo Jesús: ―Diidzli rnee luu maestro, tibaque Dios no. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ni none dib zdoo ne, dib guieḻbiini ne no guic ne, dipse xfuers ne gleynie ne me; ni gleynie ne samiech ne zigne rleynieque ne ne. Miṉ co nac miṉe mazdraa non, lëdle gzëëg ne pe cos cogon ne lo me o dieṉ peragaa guṉ ne. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zeeṉe goṉ Jesús sca niini rzë xtiidz me, rëbchaa Jesús lo me: ―Zhile ruṉfalt sëëb luu xnëz Dios, gnabey me luu. Blozh ga, grëse zha ne ndxie ga, ni stib zho biazhdraa zho pe nabdiidz zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sca noseed Jesús miech leṉ yadoo ga, zeeṉe bnabdiidz me lo zho, rëb me: ―¿Bay zha nacne rnee grë maistr ley, lo xtii rey David ga grieequia Meṉ ne nacle diidz ga cxeeḻ Dios? ");
INSERT INTO zpmNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sac zeeṉe bdeed Espíritu Sant guieḻbiini lo rey David, znu bnee David: Bnee Dios lo meṉ ne rnabey naa, rëb Dios lo me: “Cue naa nëz derech, nu bzob, nieeda lozh gnaz naa grëse zha ne rlëë lo luu, csaṉ naa zho ladznia luu.” ");
INSERT INTO zpmNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Gase nagoṉ teḻne nli zha xtii David gac Meṉ ne nole diidz cxeeḻ Dios ga, ¿zha nac dzigo ne lëëque David rnee ne me rnabey David? Grë miech guizhiu ne ndxie ga noquiaadiag zhiwseed me, per nli rley zho ron zho zha rnee me. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Laa me noseed grë miech co, zeeṉe pso me diidz lo zho rëb me: ―Ible tsienaḻde to miṉe ruṉ maistr ley goṉ. Sac grë zha ne nac maistr ley, rdziladz zho racw zho lar nool haxta zhits ni zho rbiba, rdziladz zho ndooladz yquiaabdiuzh miech zho zeeṉe gdzieel zho zho dib ro nëz. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Zig nac leṉ yadoow, zha nac zha ne rzob lo xcan zaatne rzob grë zha non, zeeṉe tsiegaa zho tib lni lidz miech, lëëpaaze zha nac zha ne rzob groḻ mezh zeeṉe laa wagw gac. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ni rlozh ga, rio zho rla zho teḻ pe ncuaaṉe rapse grë wnaa viud; ni parne peet guiabd miech lo zho, xtse rzo zho rzadraa pe lay ne gooḻ zho. ’Sca goṉ nac zho, per ib tedsod zeeṉe laa grë miech ngoopdoḻ quizh xfalt, zha nac zha ne mazdraa nroob caxtigw ygaa. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Blozh ga, güey Jesús güeysob me gax zaatne zhoob grë alcancí. Dzese rwi me raṉ me zha riesaṉ miech gon leṉ grë alcancí co; ndal grë zha ricw rdziṉ, nroob dimi rsaṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tibaque zeeṉe bdziṉ tib wnaa viud, tib meṉ prob nac me, ye me laa me psaṉ chop gaay win leṉ alcancí co. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dzigo bredz Jesús xpëëdscuel me, rëb me lo zho: ―Gneli naa lo to gaṉle, mazdraa goṉ nroob non gon ne bdeed wnaa viud qui, lëdle gon ne bdeed grëraa zha qui. ");
INSERT INTO zpmNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sac zha, dimi ne riaaṉle lo zho i rgogon zho; saṉgue wnaa prob qui goṉ, centav yeeṉ ne quianiese me miṉe rnalopaa me gziuu pe gow me, per laa me bloogona. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Laa Jesús zieriee leṉ yadoo nroob co grë xpëëdscuel me, zeeṉe rëb tib zho lo me: ―Maestro, ¡bui gaṉle zha niaataa yadoo rii! ¡Zha rnataa grë quie ngol ne niaaw! ");
INSERT INTO zpmNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Pquiab me rëb me lo zho: ―Nligaa lëë zha niaataaw. Per niicle squitaa goṉ raṉ tow niina, zdziṉ dze ne nitlow dib nacsew. Ni stib quie qui guiaaṉdraa zigne squi zhobxcuaaw i. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Briee me ga, laa me zie gza me zho. Bdziṉ zho cho Gui Oliv, ga bzob zho grë zho. Nieeṉpaa ro yadoo co zaatne zob zho ga; dzigo wbig Pedr, Jacob, Juan ni Ndrés lo me, gza tap zho bnabdiidz lo me rëb zho: ");
INSERT INTO zpmNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Bzhiguieḻ bnë lo no dieṉ, ¿pa hor dzigo gac miṉe bzeet luu ga? ¿Zha nac señ ne tso zeeṉe laaw csilo gac? ");
INSERT INTO zpmNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dzigo psilo me bnee me lo zho, rëb me: ―Nsin goḻso zeeṉa choot yquidiede to. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sac nzian zha ne grieequia gnë zho zha nac Meṉ ne zëëble diidz cxeeḻ Dios; ni nzian miech ne yquidie zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Zeeṉe gon to nëzrii nëzrec noyac diḻ, ib gdziebde to; sac ible none gac grë miṉ co, ni lëdsew ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sac garaa csilo grë diḻdox, grë guiedz nroob laaw tiḻnie saguiedz nrooba; grë zha ne rnabey grë guiedz nroob, laa zho tiḻnie sazha rnabey zho. Nëzrii nëzrec csilo gni grë zhodox, nzian zaatne gaṉ miech gbin. Ni lega loxaque miṉe rsilosew ga, sac nroobraa guieḻnë ne gaṉ miech lozh ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Zeeṉe laa grë ncuaaṉ rii rsilo noyac, ¡nsin goḻso! Sac hor co laa miech tsiezo to lo zha ne rnabey yadoo, ni lëëque leṉ yadoo ga quiṉ zho to; ziezo zho to lo grë zha non, lo grë zha rnabey, loxaque ne no to xnëz naa. Ga nagoṉ gdeeda diidz gnee to Xtidz naa lo grë zha co, ");
INSERT INTO zpmNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","sac ib none brieets bliaaḻlew lo grëse miech zeeṉe gaḻ dze ne laa guidzliu nitlo. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Zeeṉe tsiezo zho to lo wxtis, tsode to zhgab dieṉ pe guiab to lo wxtis; sac Espíritu Sant nac meṉ ne gacnieṉ to, ni miṉe csiaab me guic to miṉ co gnee to. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","’Leṉ dze co, zio zha ne lëëque zha tsielo bets zho ladznia zha ne gut zho; zio zha ne lëëque zha tsielo xpëëd zho ladznia zha ne gut zho; scaquegaa mëëda, zio zha ne lëëque zha gut pxoz zho, lëëque zha gut xniaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ible gaṉdzed miech to, grëse zho glëë lo to sacne rliladz to naa; per scagaa, grëse zha ne dziits so haxta lozh grë guieḻnë co, ible scaania Dios zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Zeeṉe gaṉ to laa ncuaaṉe ziaad gnitlo zo zaatne rieguiaḻd sow, zigne bzeet profet Daniel (zha ne glaba, none guieṉ zho zha naca), hor co goḻguib dieṉ zha xooṉ to. Zha ne no grëraa guiedz ne ngab Judé, none tsie zho dan, ga tsietsolan zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Zha ne no glaa guic yu, none lëëlëd xooṉ zho, ib guiabd zho sëëb zho leṉ yu tsiebee zho ncuaaṉe naccheṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Zha ne zogaa dana, ib guṉd zho ne laa zho tsie ro lidz zho tsiexi zho xab zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Prob grë meṉ wnaa ne lëëtaque leṉ dze co zoney xpëëd, meṉ ne quianiegaa mëdyeeṉ ne bii radz! ");
INSERT INTO zpmNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Goḻnab lo Dios gaṉde to guieḻnë co leṉ mëë ne rac naḻ, sac ne nligaa guieḻnë nrooba. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wlal ne biaaṉ guidzliu haxta lo nadze, gard gaṉ miech tib guieḻnëdox sca, ni gdziṉdragaa dze ne gaṉ zhow stib. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Teḻne csaan Dios nroob dze gac guieḻnë co, ni stib miech rii guiaaṉdraa; per na por grë zha ne bzooblo me sëëb xnëz me, gdeete me diidz gaca nroob dze. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Leṉ dze co, teḻ cho zha gnë lo to: “Goḻwi gaṉle, lëë meṉ rii nac Meṉ ne nole diidz ga cxeeḻ Dios”, gnëgaa zho: “Goḻwi nec gaṉle, lëë me i”, gliladzde tow. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sac ndal grë zha ne grieequia guiaadquidie miech, no zho gnë zha nac meṉ co, nogaa zho gnë zha ziadteed Xtiidz Dios lo miech; ni zuṉ zho grë milagr parne yquidie zho miech, parne yquidie zho haxta grë zha ne ngable lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Nsin sca goḻso! Ib cxende to, beṉque laa naa nilew lo to. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Zeeṉe lozhse gaṉ miech grë guieḻnëdox co, laa lo ngbidz ycow, gziinidraa mëë. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Grë mel ne ndziib gbaa, laa ma gliaaḻ; grëraa ncuaaṉe no gbaa, masaque nëzrii nëzrec gaca. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Horco bii zaṉ zho gaṉle, zeeṉe laa Meṉ ne pxeeḻ Dios ziad-zëëb glaa lo xcow con grë guieḻndzon con grë poder ne rap me. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Lozh ga laa me gnabey grë xanjl me, tsie zho tsietop zho grëse zha ne ngab lo me, niicle zaatne mazdraa zit lo guidzliuw, mazdragaa zit gbaaw. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Goḻzoob cuidad zha nac yag guigw. Led naṉle to gaṉle, zeeṉe laa grë zhicwa racnieeṉ, ni rsilo rdzib zhiblaga, gase rlu ne laa mëë nëëg ziaadgaxle. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Scaquegaa nagoṉ, zeeṉe gaṉ to laa grë miṉe rne naa lo to nu rsilo noyac, dzigo naṉle to lëë dze co ziaadyoble. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gneli naa lo to gaṉle, nzian miech ne mban niina bii zaṉ zho zeeṉe laa grë ncuaaṉ co csilo gac; sac ible ncuaaṉe gaca. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Zdziṉ dze nitlo gbaa, nitlo guidzliu, saṉgue miṉe rne naa lo to nu, nitloda, ible laaw none gac. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Lëëraasi choot naṉd dieṉ pa dzew, dieṉ pa horgaaw, per ni grë anjl ne no gbaa, per ni naa naṉda; loxaque Pxozse naa naṉa. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gacxe waa, nsin goḻso, goḻnab lo Dios; sac goṉ naṉde to dieṉ pa hora. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","’Nac cuent rii zig nac tib zha ne rriee zie tib guiedz zit. Zeeṉe laa zho rriee, rsaṉse zho diidz dieṉ pe guṉ tib tib moz ne guiaaṉ ro lidz zho, ni rso zho diidz lo zha ne rquianap ro puert nsin so zho, ib gaguiesd zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Scadaa to nagoṉ nsin goḻso, sac zig bizhuan yu co scaquegaa naa naṉde to pa hor guiaḻ naa, yase glanso naa tib bdze dze, tib groḻ guieel, wxiṉgaa horne rcuedz gall, o ziaadyuṉmbegaa liu. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nsin goḻso, zeeṉa iṉe zobna to zeeṉe laa naa glanso. ");
INSERT INTO zpmNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Miṉe rne naa lo to nu, laaw rne naa par grëse miech. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Schop ngbidz ruṉfalt csilo lni Pascw, lni ne row zho guietxtil ne riotsd ncobi; grë pxoz nroob ni grë maistr ley, laa zho noguib dieṉ zha ngueetsse gnaaz zho Jesús gut zho me, ");
INSERT INTO zpmNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","rnee zho: ―Laa me no ygaa, per lëëraasi gnaazd ne me mer dze lni, sac miech guizhiu ne ndxie lo lni dze co; zrieequia nzian zha ne glisquiw. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Leṉ dze co, laa Jesús no guiedz Betain. Lëëtaaque laa me no mezh lidz Simón ne blan guiedz lepr, zeeṉe bdziṉ tib wnaa bdziṉnie tiblo nceit nex, nosew tib leṉ ncuaaṉ win niaa niapse quie rbebni, tiblo nceit niazha. Dzigo blë wnaa co ncuaaṉ win co, blozh ga pchoob me nceit co guic Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Blalaa zha ne zobgrë Jesús ga, zeeṉe goṉ zho sca beeṉ wnaa co, blëë zho, rëb zho: ―¿Pa rieguiaḻa squi pxiṉ zhlë wnaa qui nceit qui? ");
INSERT INTO zpmNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Teḻne niaca miṉe ndow, nguizhpaa zhow tsoṉ gayoo pes plat, nquiinpaa dimi co ngaaza lo grë zha mban ne guieṉd pe yquiin. Laa zho nolisquiw lo wnaa co, ");
INSERT INTO zpmNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","dzigo rëbchaa Jesús lo zho: ―Goḻsaan me. ¿Pe nacne rlisqui tow lo me? Led lega pxiṉd mew, tib guieḻnzaac nroob i beeṉ me lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Teḻne nli rquia zdoo to zha ne guieṉd pe yquiin, zac ygad to lo zho stib dze, sac tibaque raṉ to zho; saṉgue naa zdziṉ dze ne gbiche naa lo to, gaṉdraa to naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Laa wnaa qui beeṉ miṉe brieelo lo me, laa me pchoob nceit nex rii guic naa zeeṉa nzhixcuaale xcuerp naa gaḻ dze ne laa naa ygueets. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gneli naa lo to gaṉle, dipse lo guidzliu zaatne cseedtaa miech Xtiidz Dios, ible soladz zho wnaa rii, seet zho miṉe beeṉ me nu. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Lo gza tsiipchop zha ne nac xpëëdscuel Jesús ga, briee zha ne lë Judas Iscariot güeyzodiidznie Judas grë zha ne nac pxoz nroob, rëb Judas laa Judas guṉ me ntregar. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Zeeṉe bin zhow, per nli rley zho ni rëb zho zdeed zho dimi lo Judas. Dzigo psilo Judas noguib Judas dieṉ pa hor gdeeda diidz guṉ Judas me ntregar. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mer dze ne rsilo lni Pascw, dze ne rowxtsee zho tib carner, ni rsilo zho row zho guietxtil ne rquiad ncobi lad, dze co bnabdiidz xpëëdscuel Jesús dieṉ pa lo racladz me tsieguṉlo zho ncuaaṉe gowxtseenie me zho wdze co. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dzigo pxeeḻ me chop zho Jerusalén, rëb me lo zho: ―Goḻtsie Jerusalén. Ga gaṉ to tib mgui nzobyaṉ tib re nis, dzigo goḻtsienaḻ zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yu ne gaṉ to sëëb me, goḻguiab lo bizhuan yu co: “Znu në maestro: ¿Pa leṉ yu me gneedz luu gac zaatne gowxtseenie me xpëëdscuel me wdze rii?” ");
INSERT INTO zpmNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dzigo ga glu me tib leṉ yu nroob ne riaaṉ glaa, nzhixcuaale leṉa, grële ncuaaṉe yquiin no ga; dzigo ga goḻguṉlo zhixtsee ne. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Laa grop zha co briee, laa zho zie. Bdziṉ zho lad guiedz Jerusalén, nligaa laa zho bdziel yu co zigne rëbse me lo zho ga, dzigo psilo zho beeṉlo zho xtsee co. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bdze dzew, laa me bdziṉ leṉ yu co grë xpëëdscuel me. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Laa me no mezh noyownie me zho, zeeṉe rëb me lo zho: ―Laa naa gni lo to gaṉle, lëëque tib zha ne goṉ noyownie naa nu tsielo naa ladznia zha ne gut naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Zeeṉe bin zho sca rëb me, mban rac zho, dzigo psilo zho tibga tibga zho rnabdiidz lo me, rnee zho: ―¿Pe naaw? ");
INSERT INTO zpmNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Pquiab me rëb me lo zho: ―Ladaque to no zho, zha ne nosëëb xcuuṉ leṉ xquien naa, lëë zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Naa ne nac naa Meṉ ne pxeeḻ Dios, niina laa miech gut naa zigne raquietsew lo Xtiidz Dios; per, ¡probsaxe zha ne tsielo naa ladznia zho! ¡Mazd wen nie zho, ib niacd zho miech lo guidzliu! ");
INSERT INTO zpmNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Laa zho noyow zeeṉe bzheṉ Jesús tib guietxtil, bdeed me xquizh lo Dios, blozh ga beeṉgroḻ mew dzigo bdiiz mew lo zho, ni rëb me: ―Goḻquiina, lëë xcuerp naa i goṉ. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ni bzheṉ me tib cop nroob vin, bdeed me xquizh lo Dios, blozhse bdeed me xquizh, dzigo bdeed me cop co lo zho, grëse zho go vin co. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ni rëb me lo zho: ―Lëë xchen naa i, miṉe gzhiee par grëse miech ne sëëb xnëz Dios, sac lëë stib mod cub nu psaṉ Dios parne sëëb miech xnëz me. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lëë lultm vuelt nu guie naa vin rii, sac zhaale stib vin cub ne guie naa zeeṉe laa naa gdziṉ zaatne rnabey Pxoz naa. Dzigo psilo me biiḻ me bla salm gza me zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Blozhse biiḻnie me Dios grë me zho, dzigo laa me brieenie zho ga zienie me zho nëz Gui Oliv. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","―Ible saan to naa nawdze rii ―rëb me lo zho―, sac scale ziaad lo Xtiidz Dios zaatne rnee: “Zdeed Dios diidz csiwee zho baxtor, lozh ga nëzrii nëzrec gliaaḻ mëcwxiil.” ");
INSERT INTO zpmNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sca guṉ zho naa, per zeeṉe laa naa grieeban glole naa ga Galilé, ga cuëz naa to. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dzigo rëbchaa Pedr lo me: ―Niicle teḻne saan grë zha qui luu, saṉgue naa goṉ csaand naa luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pquiab me rëb me lo Pedr: ―Gneli naa lo luu gaṉle, guieel riigazh, gardle grop gall tsoṉle vuelt rëb luu ruṉbeyd luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Per tibaque nac xtiidz Pedr, rnee Pedr lo me: ―Niicle teḻ zaatne guet luu guet naa, per guṉscad naa. ¿Pe nacne guiep naa ruṉbeyd naa luu? Scaque rnee grëraa zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bdziṉ Jesús zaatne lë Getsemaní gza me zho, dzigo rëbchaa me lo zho: ―Nuse nagoṉ goḻsob, laa naa ga gazodiidznie naa Pxoz naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Horco psilo mban rac zdoo me, riabguieḻnë me, dzigo bredz me Pedr, Jacob ni Juan, bzënie me zho palal ");
INSERT INTO zpmNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","dzigo rëbchaa me lo zho: ―Mban rac zdoo naa, zootle zig zet naa lo guieḻnë rii. Nuse nagoṉ goḻguiaaṉ, per goḻsobna. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bzë me spalal, dzigo pquiitsgzhib me haxta bdziṉ lo me lo liu; psilo me bnab me lo Dios ne teḻne zrieelow mazd tete me grë guieḻnë ne no gaṉ me, ");
INSERT INTO zpmNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","rëbchaa me: ―¡Papá, par luu grëse cos zrieelo guṉ luuw! ¡Bzhiguieḻ psilaa naa lo guieḻnë rii! Per teḻne grieeloda, miṉe gnëtaa luu, sca gaca. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Zeeṉe biire me bdziṉ me zaatne biaaṉ gza tsoṉ zha co, goṉ me gzase zho nixguies; dzigo rëbchaa me lo Pedr: ―Simón, ¿nixguies luu lëë? ¿Pe ni palal blëëbd luu nzobna luu? ");
INSERT INTO zpmNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Goḻsobna, goḻnab lo Dios zeeṉa yquiild meṉdox to. Niicle ne squi lëbdraa xcuerp to sobna to, per goḻnab lo Dios, sac goṉ miṉ co nac miṉe racladz zhiespíritu to. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dzigo biire güey me stib, güeyzodiidznie me Dios; scaque miṉe bnab me glo miṉcoque bnab me stib. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Zeeṉe bdziṉ me lo zho, goṉ me laa zho bii nixguies. Ni rdzield zho pe guiab zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Laa zeeṉe goc tsoṉ vuelt biire me güeynab me lo Dios, rëbchaa me lo zho: ―Lëëw nagoṉ, zacle na gaguies to, zacle gdziiladz to. Naa ne nac naa Meṉ ne pxeeḻ Dios, naataa laa hor bdziṉ zeeṉe laa grë miech ntseeb rii guiadnaaz naa. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Goḻtsieso, zeeṉa zio ne; sac goṉ laa zha ne glu naa lo zho ziaadle nu. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Laa Jesús bii quianeeque, zeeṉe laa Judas (tib zha ne nac xpëëdscuel me) bdziṉ, bdziṉnie Judas tib dzoon zha ne pxeeḻ grë pxoz ne rnabey, grë maistr ley ni grë zha non lo meṉguiedz Israel. No zho nzheṉ spad, nogaa zho nzheṉ yag. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Biaaṉniele Judas zho diidz zha glu Judas cho nac Jesús, rëb Judas lo zho: ―Naṉle to goṉ, zha ne gow naa bzhid cuas, lëë me ga; ligier goḻso goḻxeṉ me, ib csaande to xooṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nligaaw, zigne bdziṉ Judas bredz Judas Jesús; blozh ga dow Judas bzhid cuas me. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Horco wbig grë zha ne zienaḻ zhits Judas ga bzheṉ zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lo grë zha ne nacgza Jesús ga, hor co biasaque tib zho bdob zho zhispad zho pchug zho tib diag xmoz meṉ ne nac pxoz nroob. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dzigo rëbchaa Jesús lo grë miech co: ―¿Niacxe naa cho ngbaan, zha nac ne squitaa nzheṉ to spad, nzheṉ to yag ziadnaaz to naa? ");
INSERT INTO zpmNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Blactaa dze name goṉ to noseed naa miech leṉ yadoo, ¿pe nacne bnaazde to naa ga? Per ible laa grë ncuaaṉ rii goṉ noyac zeeṉa gac grë miṉe raquiet lo Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Grë zha ne nac xpëëdscuel me ga, grëse zho bzhooṉ, tipse me psaṉ zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tibaque mgui nguieg bii güeynaḻ zhits me, tib lëse lar nquits mbix mgui; dzigo bnaaz zho mgui gocladz zho ye mgui nienie zho; ");
INSERT INTO zpmNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","per znuse briee mgui leṉ lar co, bzhooṉ mgui coletse mgui. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ga brieenie zho Jesús bdziṉnie zho me lidz meṉ ne nac pxoz nroob. Grë pxoz rnabey, grë zha ne rnabey lo maistr ley ni grë zha non lo meṉguiedz, laa zho pcaalsa ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ye Pedr, maase zit zit naḻ Pedr laa Pedr bdziṉ xley meṉ co. Bdziṉ Pedr, güeysobga Pedr lo grë zha ne ndxienap, lëëtaque laa zho quiadzëë lo gui. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Grë pxoz co, grë zha ne nac zhiwxtis zha Israel, laa zho ndxie nëz leṉ yu co, quiaguib zho dieṉ pe yquiaaqui zho gnab zho guet Jesús, quiaguib zho dieṉ pe doḻ ne ycaadz zho me; per rdzield zho dieṉ pew. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nzian zha ne pquidie rëb zho znu znu nac ncuaaṉe noyuṉ me, per rrieequiad xtiidz zho; sac zhaase zhaase rnee zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tibaque zeeṉe guso blalaa zho, bnexuu zho rëb zho: ");
INSERT INTO zpmNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Bdzion no goṉ rëb me laa me ctixche yadoo, lozh ga tsoṉaque ngbidz gzaalo me stiba; per led miechdraa nzaaw. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Niicle scaw, rzëdaque xtiidz zho tipse. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dzigo hor co bzoli meṉ ne nac pxoz nroob, bzo me glowtaa lo grë miech co, bnabdiidz me lo Jesús rëb me: ―¿Pe nacne rquiabd luu? ¡Diidzli dzigo lëë nac grë miṉe rnee zho i! ");
INSERT INTO zpmNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dzese zo Jesús ib rquiabd me. Biireque meṉ co bnabdiidz me stib rëb me: ―¿Nligaa cho nac luu? Bnë teḻ nli Xpëëd Dios nac luu, Meṉ ne nacle diidz ga cxeeḻ me lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dzigo pquiab Jesús rëb me: ―Nliw, naa nac meṉ co. Naa ne nac naa Meṉ ne pxeeḻ Dios, bii zaṉ to gaṉle zeeṉe laa naa zoob cue Dios nëz derech, ni zeeṉe laa naa guieet gbaa ziaḻzëëb naa lo xcow. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Horco ptsiez pxoz nroob co xab me, sac blëë me bin me sca rëb Jesús. ―¿Pe mazdraa textigw ne racladz ne? ―rëb me―, ");
INSERT INTO zpmNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","laa to binle gaṉle zha rzëtaa xtiidz me noguitnie me Dios. ¿Pe gnë to na zha gac me? Grëse zho pquiab rëb zho, ib rieguiaḻa guet me. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dzigo hor co blalaa zho laa zho psilo notsuc lo me. Pxidoo zho lo me ni rdeed puñet zho me, lozh ga rnee zho: ―Bnë dieṉ, ¿cho ga bdiṉ luu? Ye grë zha ne quianap ga, rgap zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Laa Pedr bii zoque ley. Ga zo Pedr, zeeṉe laa tib wnaa ne nac zhicriad meṉ rnabey co bdziṉ; ");
INSERT INTO zpmNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","goṉ me laa Pedr zob gax lo gui nodzëë Pedr. Dze rwi me lo Pedr, tibaque zeeṉe rëb me: ―¿Ye luu lëë rzënie Jesús, meṉ Nazaret ne bdziṉnie zho i? ");
INSERT INTO zpmNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Per bneelid Pedr. ―Dieeṉ pe rooḻ luu ―rëb Pedr―. Ruṉbeyd naa meṉ co. Brieega Pedr zie Pedr nëz ro zawan, lëëtaque hor co pcuedz tib gall. ");
INSERT INTO zpmNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dzeque rwi wnaa co lo Pedr, dzigo rëbchaa me lo grë zha ne ndxie ga: ―¡Lëëw, zha ne rzënie me nac mgui qui! ");
INSERT INTO zpmNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Biire Pedr rëb Pedr ruṉbeyd Pedr me. Wdzeepaa goca, biire zha ne ndxie ga rëb zho lo Pedr: ―Ne nligaa, ye luu rzënie meṉ co. ¡Zha Galilé name nac luu! ");
INSERT INTO zpmNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dzigo psilo Pedr rzeet Pedr Dios rnee Pedr ruṉbeyd Pedr Jesús, haxta rnee Pedr: ―¡Dios zobwi gaṉle, teḻne rned naa diidzli, maase cuibdee naa! ");
INSERT INTO zpmNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lëëtaaque hor co laa gall pcuedz stib. Dzigoraa psoladz Pedr xtiidz Jesús zeeṉ rëb me lo Pedr: “Gardle grop gall, tsoṉle vuelt rëb luu ruṉbeyd luu naa.” Dzigo mbanse rac Pedr, psilo Pedr biin Pedr guieḻnë co. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ziadyiinile liuw, scase bii nchooḻ rnaw, wbiire pcaalsa grë pxoz non grë zho zha ne rnabey lo maistr ley, grë zha non lo meṉguiedz ni grë zha ne nac zhiwxtis zho. Blozhse bnediidz zho, laa zho pxidoo Jesús güeysaṉ zho me lo Pilat meṉ ne nac gobernador. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bdziṉ me lo Pilat, bnabdiidz Pilat rëb Pilat lo me: ―¿Pe nli na luu nac zhirey zha Israel? Pquiab me rëb me: ―Nliw. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tibaque quia grë zha ne nac pxoz non, rzadraa grë ncuaaṉe rcaadz zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nacne wbiire Pilat bnabdiidz Pilat lo me, rëb Pilat: ―¿Pe nacne rquiabd luu? Bui gaṉle zha nactaa grë ncuaaṉe rcaadzdoḻ zho luu. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bzee zdoo Pilat goṉ Pilat ible pquiabd me. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gzobse lni Pascw rsilaa Pilat tib zha ne no ladzguiib, teḻ cho zha ne gnabtaa meṉguiedz laa. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Leṉ dze co no tib mgui lë Barrabás ladzguiib, ni zla zha ntseeb ne nacgza me, laa zho no ga sac nzian zha ne beet zho zeeṉe gocntseeb zho lo gobiern. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nacne psilo grë miech co, rnab zho lo Pilat csilaa Pilat tib zha ne no ladzguiib zigne ruṉtaque Pilat grëraa iz. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dzigo bnabdiidz Pilat lo zho, rëb Pilat: ―¿Cho racladz to csilaa naa? ¿Pe silaa naa meṉ ne rnee zho zhirey to nu? ");
INSERT INTO zpmNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sca rëb Pilat lo zho, sac naṉle me niapse por rlëë grë pxoz non co raṉ zho Jesús gane bnabey zho bgaa me güeysaṉ zho me ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per leḻ psilo grë miech co rnab zho csilaa Pilat Barrabás; ni lëëque grë pxoz co pquiil zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dzigo rëb Pilat lo zho: ―¿Zha dzigo racladz to gac meṉ rnee zho zhirey to nu? ");
INSERT INTO zpmNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pquiab be grë miech co, roptsie zho rnee zho: ―¡Bnabey yquia me lo cruz! ");
INSERT INTO zpmNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","―¿Pe nac falt ne beeṉ me? ―rëb Pilat―. ¿Pe nacne racladz to yquia me lo cruz? Biire zho roptsie zho rnee zho: ―¡Bnabey yquia me lo cruz! ");
INSERT INTO zpmNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Goṉ Pilat zha rac zho ni racladzaque me guiaṉnziuu me lo zho, nacne mazd bzoob me xtiidz zho, bnabey me blaa Barrabás; laa Jesús, blozhse bnabey me bdiṉ zho Jesús laa me beeṉ Jesús ntregar lo grë meṉguiib ne tsiequiaa me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Biire grë meṉguiib co bzëëbnie zho Jesús nëz leṉ yulow, ga pcaalsa grëraa meṉguiib ne nacgrë zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Psilo zho rguitnie zho me, bgacw zho me tib lar morad zig rna lar ne racw grë rey, ni bzieecw zho bla lë yag guiets bzoob zhow guic me, zig rzob coron guic grë rey. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dzigo psilo zho nguiedz roptsie zho rnee zho: ―¡Goḻwi gaṉle zha ractaa zhirey zha Israel! ");
INSERT INTO zpmNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bzheṉ zho tib goobgui, rdeed zhow guic me, rtsuc zho lo me, rquiaalo zho rquiitsgzhib zho lo me zig rquiitsgzhib zho lo zha non. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Blozhse sca bdziitnie zho me, laa zho blee lar morad ne nacw me ga, biire zho bgacw zho me miṉe nac xab me; dzigo laa zho brieenie me ga zienie zho me zaatne yquia me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nëz zienie zho me, bdzieel zho tib mgui Ciren lë Simón (lëë pxoz Lejandr ga grop Ruf), znu ziaad me wbire me dan. Dzigo bnabey zho me bi me zhicruz Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Zeeṉe bdziṉnie zho Jesús zaatne lë Gólgota (nac diidz co zig nac ne rnee ne “Gui Beerguic Ngutoo”); ");
INSERT INTO zpmNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ga bdeed zho nziu notsa guizh rmed ne lë mirr, naṉ zho nie mew, per god mew. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dzigo laa zho pquiaa me lo cruz. Blozhse pquiaa zho me lo cruz, bzheṉ zho tib xab me pchug zhow, biaaṉnie zho tib lëgaw tib tib zho, laa stiba bio zho rif. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Zig hor wxeeren ga pquiaa zho me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Glaa guic cruz ne pquiaa zho me ga, ga pquiaa zho bla lan diidz zaatne rnee pe nacne sca psacsi zho me, rneew: “LËË MEṈ RII QUIA NU, PORNE NAC ME ZHIREY ZHA ISRAEL.” ");
INSERT INTO zpmNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ye chop ngbaan pquiaagza zho me lo cruz, tibga zhicruz zho bzo tib nëz cho zhicruz me. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ga brieequia miṉe raquiet lo Xtiidz Dios, zaatne rnee: “Bloo zho me lad zha ntseeb.” ");
INSERT INTO zpmNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Grë miech ne rded zaatne quia me lo cruz ga, ruṉnguzee zho me, rzhidznie zho me, haxta rdzi guic zho rnee zho lo me: ―¡Pe led rëb luu lëë, laa luu ntsiḻ yadoo ni tsoṉaque ngbidz nzaalo luuw stib! ");
INSERT INTO zpmNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nana zho, ¡pe gacd lëëque luu bla luu lo caxtigw qui, biet lo cruz qui! ");
INSERT INTO zpmNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Scasaque grë pxoz non ni grë maistr ley, rzhidznie zho me; rnee zho: ―Stib miech scataa beeṉguiac me, stib miech scataa bla me, pe nac dzigo rrieelod me gla me me. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Teḻne nli me nac Meṉ ne zëëble diidz ga cxeeḻ Dios, teḻne nli me nac zhirey ne, niinagazh guiet me lo cruz; zeeṉa gliladz ne me! Ye zha ne quiagza me lo cruz ga, rbidzgo zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Goḻ groḻ dzew, tibaque zeeṉe goc tib ncow dipse lo guidzliu, haxta las tres biaa biini stib. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Horco nguiedz zëëb tsi Jesús, rnee me: ―¡Eloi, Eloi! ¿Lama sabactani? (Diidz co nac zig nacne rnee ne: ¡Luuse name nac xDios naa! ¿Pe nacne psaan luu naa?) ");
INSERT INTO zpmNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Grë zha ne ndxie ga, zeeṉe bin zho sca rbedz me, no zho naṉ Lí, meṉ ne biadteed xtiidz Dios padzeela, meṉ co rbedz me. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dzigo rias tib zho güeygadz tib lë zhiil lo nziu bla, bzoob zhow tib guic goobgui pquiaa zhow ro me. ―¡Gotsaa csaan ―rnee zho―, nu dziaṉ ne dieṉ pe ziaad Lí guiaadlit Lí me lo cruz! ");
INSERT INTO zpmNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tibaque zeeṉe pquiaa me stib redz nroob, znuse blozh me. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lëëtaaque laa me nolozh, zeeṉe briez nzoli lar nroob ne quia leṉ yadoo, groḻtaa goca. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Gax lo me ga zo meṉ ne rnabey lo grë meṉguiib co, zeeṉe goṉ meṉ co zha gut me, rëbchaa me: ―¡Ne nligaa, Xpëëd Dios nac meṉ qui! ");
INSERT INTO zpmNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ye blalaa meṉ wnaa güeyso ga, zit zo zho rwi zho; lad co no Marí Magdal, Salomé ni Marí ne nac xniaa Jacob niab grop José. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nzianlaa nac zho, lëë grë wnaa co beeṉ xyudar me leṉ dze ne güeyted me dib xtan zha Galilé; ni zlagaa zha ne güeynaḻ zhits me zeeṉe bdziṉ me Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Lëëtaaque dze co nac vispr dze ne rdziiladz zho lo dziin. Zeeṉe laa dze bdzepaa, dzigo güey José (meṉ Arimaté) lo Pilat bnab me diidzbey tsiequeets me Jesús. Glo zoot me tsied me, per tibaque bloo me tib valor güey me; niicle ne tib zha non nac me lad zhiwxtis zha Israel, ye me quiambëz gdziṉ dze ne gnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bzee zdoo Pilat zeeṉe bin me laa Jesús gutle. Bnabey me gocredz zha ne rnabey lo meṉguiib ne quianap Jesús; ");
INSERT INTO zpmNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","haxta bdziṉraa meṉ co rëb nliw, dzigoraa bdeed me diidz tsielit José Jesús lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nacne güey José, güeysi me tib lë lar nroob. Zeeṉe blozh blit me Jesús lo cruz pcheḻ me Jesús lar co, dzigo güeyxob me me tib leṉ baa ne ndieeṉ tib cho quie. Blozh ga, psodan me tib quie nroob psioog me ro baa co. ");
INSERT INTO zpmNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ga zo Marí Magdal ni Marí xniaa José, goṉ zho pa lo bgueets me. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bdze dze dze ne rdziiladz zho lo dziin, güey Marí Magdal, Salomé, ni Marí xniaa Jacob güeysi zho grë nceit nex ne tsietëëb zho lad xcuerp Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Laa zeeṉe biini liu, dze ne rzobni zhmal, silgaw loxaque ziaadlan ngbidza laa gza wnaa co briee laa zho zie ro baaṉ Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nëz no zho, rnabdiidzlsa zho dieṉ zha gdioob quie nroob ne nioog ro baa, cho siguieḻ coba. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ni zeeṉe bdziṉ zho, goṉ zho laa quie co bdiooble. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Laa zho bzëëb leṉ baa, zeeṉe goṉ zho nëz derech laa tib mgui nguieg zob ga, nacw me tib lar nool, dib nquitsbiese rna lar co. Bdzieb zho goṉ zho me; ");
INSERT INTO zpmNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","dzigo rëbchaa me lo zho: ―Gdziebde to. ¿Jesús lëë, meṉ Nazaret ne pquiaa zho lo cruz, meṉ co ziaadguib to? Guieṉdle me nu, ¡laa me brieebanle! Goḻwi gaṉle nu nac zaatne pxob zho me. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Goḻtsie, goḻguiab lo Pedr ni lo grëraa xpëëdscuel me tsie zho Galilé, ga tsiedzieel zho me zigne rëble me lo zho glo. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Rias gza wnaa co laa zho briee ga, masaque rzhidz zho rdzieb zho. Lo dzeb co ni par gnee zho gacd. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dze ne rzobni zhmal ga, sil co brieeban Jesús, ni Marí Magdal nac zha ne glopaa goṉ me; lëë Marí co ga beeṉguiac me zeeṉe beṉcxooṉ me gadz meṉdox ne nosacsi Marí. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dzigo güey Marí güeynie Marí diidz lo grë zha ne bzënie me ga. Lëëtaaque laa zho ndxie mban rac zho, roon zho no zho xquieḻnë me. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Niicle bin zho rëb Marí laa me brieebanle, goṉlo Marí me; per bliladzd zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bded ga, brieequia me lo schop xpëëdscuel me lëëtaque no zho nëz zie zho dan. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dzigo güey zho güeynie zho diidz lo grëraa zha ne nacgza zho; per niicle xtiidz grop zha co bliladzd zho. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Laa stibtaa vuelt, lëëtaque ndziib zho lo mezh no zho wagw gza tsiiptib zho, tibaque zeeṉe laa me brieequia; dzigo goctox me lo zho sac goṉ me ib bliladzd zho xtiidz me; ni goṉ me scataa nad zdoo zho, sac niicle güey zha ne goṉ me güeynie zho diidz ne nli brieeban me, ni bliladzd zhow. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ni rëb me lo zho: ―Goḻtsie dipse lo guidzliu, goḻtsieseed miech Xtiidz Ndzon Dios. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Grëse zha ne dib zdoo gliladza ni chobnis zho, scaania Dios zho; saṉgue zha ne gliladzda, laa zho bnitlole ga. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Grë zha ne sca dib zdoo gliladz naa: znee zho stib diidz ne rneed zho. Niicle xeṉ zho grë meeḻ ntseeb, concuaangaa miech zho, ib peet gacd zho. Ni zeeṉe cxobnia zho guic grë meṉ rzacnë, zuṉguiac zho zho; grë meṉdox ne noguitnie miech, zeeṉe gzeet zho lë naa zuṉcxooṉ zho ma. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Blozhse sca bnee me lo zho, laa me zey gbaa bzob me cue Dios nëz derech. ");
INSERT INTO zpmNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dzigo grëse xpëëdscuel me laa zho briee, brieets bliaaḻ zho zieseed zho miech Xtiidz Dios. Ni me nac meṉ ne noyacnieṉ zho ruṉ zho grë milagr nroob, zeeṉa glu ne nli Xtiidz me nac miṉe noseed zho miech.");
INSERT INTO zpmNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Naṉle luu gaṉle, nole bla zha ne bioxco pquiaa zho grë ncuaaṉe goc zeeṉe biaad Jesús meṉ ne pxeeḻ Dios ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ncuaaṉe nlipaa goca, grë ncuaaṉe pquiaa zho ga, laaw pquiaa zho zigne rzodiidzse miecha leṉ dze rii, zigne rzodiidzsegaa zha ne bzëniepaa mew, zha ne pso me noneew lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yeque naa pquiaa naa wen wen bnabdiidz naa, bleeni naa diidz grëse dieṉ zha psilo grë ncuaaṉ co; ni niina laa naa rquiaw zigne gocsew laaw rxeḻ naa lo luu. Sac rieṉ naa ib nonguieḻa gacnaṉ luuw; ");
INSERT INTO zpmNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","zeeṉa lozh gacnaṉ luu zha nac diidzli rii, wseed ne blu zho lo luu i. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Leṉ dze ne nac Herod rey rnabey me dib xtan zha Judé, leṉ dze co no tib pxoz lë Zacarí, me nac tib zha ne nacgrë “Zha Abí”. Niicle tsieel mew, zha xtii pxoz Aarón ziaad wnaa co, lë me Lisabet. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zigtaa Zacaríw, zigtaa Lisabeta, noxco me miṉe rnabey Dios, mban mew zigne naca, ni tib xley Dios rguiitsd me. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Meṉ gol-le nac me grop me, per ni tib mëëd quianied me, sac niaad Lisabet gapd me mëëd. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Laa tib dzew bgaa grë zha ne nacgrë Zacarí guṉ zho dziin leṉ yadoo. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nac xcostumbr grë zha ne nac pxoz, rio zho tib rif dieṉ chopaa ygaa tsielaadz goxyaal leṉ yadoo, dzigo bgaa Zacarí. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Goxyaal co nolaadz me leṉ yadoo, laa grë miech ne ndxie nëz ley nonabgaa lo Dios, ");
INSERT INTO zpmNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","tibaque zeeṉe brieequia tib xanjl Dios bzo cue pcoog nëz derech, zaatne nozëëg me yaal ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zeeṉe goṉ me anjl co bdzieb me, rdzieldraa me zha guṉ me lo dzeb co. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dzigo rëb anjl co lo me: ―¡Gdzieebd luu! Diidzse ziaḻnie naa lo luu, gacnaṉ luu gaṉle miṉe bnab luu lo Dios ga, pquiaadiag mew; gane niina laa tsieel luu gap tib mëëdbgui. Zeeṉe gal win, Juan cueelë to win. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tib guieḻbley nroob gac win lo to, niicle lo grëragaa miecha, ");
INSERT INTO zpmNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","sac tib meṉ nziuu gac win lo Dios. Zeeṉe gac win zha broob, ni tib ro nziu guied win, per ni vin yquiaarod win; ansraa gal win, laa Espíritu Sant nacniele win. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Win gac meṉ ne co guic nzian grë zha Israel, gbiire gbig zho lo Dios, meṉ ne rnabey zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Zigne goc Lí, meṉ ne biaad pteed xtiidz me padzeela, sca gac win tedner win lo me, nroob poder ne gap win. Win gnee lo grë miech rii, gbiire gleynie zho me zigne goc xmeṉgol zho zha ne bleynie me; csaan zho grë xquieḻntseeb zho, gban zho zigne racladz me; zeeṉa niowse gac zho ycaania zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Pquiab Zacarí rëb Zacarí lo anjl co: ―¡Ncuaaṉe gacd i goṉ rnee luu! Zigtaa naaw, zigtaa tsieel naaw, meṉgol-le nac no. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Rëbchaa anjl co: ―Bieṉ gaṉle anjl Gabriel nu quianee lo luu, anjl ne tibaque zo lo Dios. Me pxeeḻ naa ziaḻnie naa diidz rii. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per ne squi rliladzd luuw, na laa luu guiaaṉ ngop, haxta gaḻ dze ne gac miṉe rne naa lo luu nu, dze co glan xtiidz luu stib. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Grë miech ne ndxie quianab lo Dios ga, quiambëz zho Zacarí, rnabdiidzlsa zho pe goc me, sac raṉ zho rrieed me zaatne ziezëëg me yaal ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zeeṉe briee me, goṉ zho gacdraa gnee me, dzigo bieṉ zho no pe blu Dios lo me ga. Teḻ pe racladz me gnee me, niapse señ rlu me. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bzase dze ne beeṉ me dziin leṉ yadoo, dzigo laa me zey lidz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Goca bla ngbidz, laa mëëd co pquialo zdoo tsieel me. Dipse leṉ gaay mëë bio zhuz co ro yu, ib brieed me, rley me rnee me: ");
INSERT INTO zpmNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","―¡Zha wentaa Dios, bneedz me diidz bdziṉ dze yquianie naa mëëd rii, zeeṉa gzhidzniedraa miech naa! ");
INSERT INTO zpmNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Goc xoop mëë zoney Lisabet mëëd, pxeeḻ Dios anjl co stib güey me Nazaret, guiedz ne ndxie xtan zha Galilé. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ga no tib ndzoop nguieg lë Marí, leṉ dze co no xtiidz ndzoop co ctsieelnia ndzoop tib zha xtii rey David, lë José. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bdziṉ anjl co zaatne no ndzoop, pquiaabdiuzh me ndzoop, rëb me: ―¡Dichos luu goṉ, sac tib zha nziuu nac luu lo Dios! Me quianap luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Zeeṉe goṉ Marí anjl co, ni goṉ Marí zha rnee me, bzee zdoo Marí, rieṉd Marí dieṉ pe nac scataa rzë xtiidz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dzigo rëbchaa me lo Marí: ―¡Gdzieebd luu! Laa Dios goṉ bzooblo luu ygaa luu tib guieḻnzaac nroob. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Zdoo luu yquiaalo tib mëëdbgui, zeeṉe laa win gal, JESUS cueelë luu win. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tib meṉ nroob gac win, zieṉ miech gaṉle Xpëëd Dios ro ne no gbaa nac win; ni so me win gnabey win zig bnabey xmeṉgol win David. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Win gnabey lo grëse zha Israel, ni gdziṉd dze ne lozh xquieḻrnabey win. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Pquiab Marí rëb Marí lo anjl co: ―¿Mëëd ye? ¿Per zha grieelo gap naa mëëd, ni tib naa zo nu? ");
INSERT INTO zpmNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Rëbchaa anjl co: ―Niapse por poder ne rap Dios gac miṉ co. Zeeṉe laa Espíritu Sant guiaad gacnie luu, hor co laa poder co gacnie luu, laa mëëd co yquiaalo zdoo luu; gacxe waa Xpëëd Dios guṉbey miech win, miṉe rnabey Dios miṉ co guṉ win. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ye beḻyeeṉ luu Lisabet, niina lo guieḻgol-le laa tib mëëd pquialo zdoo me; zëëb diidz ib grieelod gap me mëëd, per na racle xoop mëë zoney me mëëd, ");
INSERT INTO zpmNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","sac par Dios tsod ncuaaṉe grieelod gac. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dzigo rëb Marí: ―Teḻ scaw, miṉe rnee luu i, maase gaca. Laa naa zo nu par guṉ naa miṉe gnabeytaa Dios naa. Blozhse ga, laa anjl co zey. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Goc bla dzew, briee Marí ga zie me ziegaṉ me Lisabet tib guiedz win ne ndxie gui glaa ne nac xtan zha Judé. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bdziṉ me, wbig me pquiaabdiuzh me Lisabet. Bdiuzh co bnee me, zeeṉe biasoli xpëëd Lisabet zdoo Lisabet; dzigo hor co bdeed Espíritu Sant guieḻbiini lo Lisabet, ");
INSERT INTO zpmNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nguiedz bnee Lisabet rëb me lo Marí: ―¡Dichos luu Marí bgaa luu guieḻnzaac qui! Sac goṉ, lo grëraa no nac no meṉ wnaa, luu bzooblo Dios. Mëëd ne zoney luu i, zha nziuu nac win lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¡Ib guiaaṉladzd naa dze rii, znu biaad luu nac luu xniaa meṉ ne rnabey naa, biaadgaṉ luu naa! ");
INSERT INTO zpmNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Haxta mëëd ne zoney naa nu, rley win biasoli win zdoo naa, zeeṉe pquiaabdiuzh luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Dichos luu, bin luu miṉe në Dios, ni bliladz luu zuṉ mew! ");
INSERT INTO zpmNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dzigo hor co bnee Marí rëb me: ¡Meṉ nroob nac Dios! ¡Gdib zdoo naa rooḻnie naa me! ");
INSERT INTO zpmNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Rleynie naa me nac me meṉ ne psilaa naa, sac goṉ niicle peet nond naa, tib nguṉdziin winse nac naa lo me, per laa me bzooblo naa. Grë miech, zigtaa leṉ dze riiw, zigtaa leṉ dze ne ziaadragaaw, ziab zho naa nac tib wnaa ne mazdraa dichos. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ne nligaa zha nactaa guieḻnzaac rii bneedz me lo naa. Meṉ ro, meṉ nroob nac me, ¡guieṉdraa cho zig me! ");
INSERT INTO zpmNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Grëse miecha, zha ne rioxco rquiaadiag miṉe rnabey me, tibaque racnie me zho, ib rsaand me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","¡Goḻwi gaṉle zha nactaa grë ncuaaṉe ruṉ me! Grë ncuaaṉe no guic zha niats guṉ zho, bnitlo mew, ");
INSERT INTO zpmNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ptiche me grë zha ne zob rnabey. Laa grë zha ndooladz, zha ne rzac miech peet nond, beeṉnon me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Grë zha mban ne guieṉd pe yquiin, nroob guieḻnzaac ne bdeed me lo zho, laa grë zha ne rapcheṉ, scase bzonëz me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","¡Pe zhidaa ziyacnie me grë zha ne nac xtii Israel, meṉgol ne goc zig tib nguṉdziin lo me ga! ¡Tibaque rlu me rleynie me zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ib biaaṉladzd me xtiidz me miṉe bnee me lo pxozgol ne Abraham, zeeṉe rëb me gdziṉd dze ne csaan me Abraham, ni grëraa zha ne grieequia lo xtii Abraham. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maase tsoṉ mëë biaaṉ Marí ga blëz me lo Lisabet, dzigoraa wbi me ga bdziṉ me lidz me stib. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bdziṉ dzew, laa xpëëd Lisabet bza mëë, laa me gop win. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Grë zha ne no gax lidz me, grë zha ne nac meṉlidz me, zeeṉe bin zho scataa pquia zdoo Dios me bdeed Dios mëëd co lo me, rley zho güeygaṉ zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Dze ne goc mëëdbgui yeeṉ co xon ngbidz, blalaa zha ne güeynaḻ zhits pxoz win, zhits xniaa win güeynie zho win bio win bey ne rio xpëëdbgui zha Israel, parne glu lo Dios ngab win. Tibaque naṉ zho Zacarí nrieelë win, zigne lëque pxoz win, haxta scale nonee zho lo win, ");
INSERT INTO zpmNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","per hor co rëb Lisabet, led scad gac lë win, Juan grieelë win. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dzigo pquiab zho rëb zho: ―¿Pe nacne sca grieelë win? Ni tib meṉlidz to lëd Juan. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bnabdiidzaque zho lo pxoz win, blu zho señ lo me dieṉ zha racladz me gac lë win. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dzigo bnab me bdeed zho tib lë lo zaatne yquiaa me; bzee zdoo zho zeeṉe blozh pquiaa me goṉ zho rnee lo co: “Juan grieelë win.” ");
INSERT INTO zpmNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Loxaque blozh dze sca pquiaa me, zeeṉe laa me wbiire bnee stib, psilo me rdeed me xquizh lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Grë zha ne zo ga, zha ne ruṉbey me, zeeṉe goṉ zhow, per nli rzee zdoo zho. (Nëzrii nëzrec bzhooṉ diidz laa mëëd co gol, grëse guiedz ne ndxie gui glaa co gocnaṉ miecha. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Zha ne rona, rza zdoo zho rnee zho: “¿Bay cho gac mëdyeeṉ co?” Sac nligaa rlu nacnie Dios win.) ");
INSERT INTO zpmNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Horco bdeed Espíritu Sant guieḻbiini lo Zacarí, psilo me bnee me rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Xquizh xquieḻnzaac meṉ nroob ne rnabey, meṉ ne nac xDios ne nac ne zha Israel! Sac goṉ laa me ziaad, ziaadgaṉ me ne, ziadbee me ne lo xquieḻnë ne. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nasi laa me pxeeḻ meṉ nroob ne ziaadsilaa ne, lëë meṉ co ga no grieequia lo zha xtii David, meṉ ne beeṉ xtsiiṉ me ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Padzeelale bzeet me cxeeḻ me meṉ co, grë zha ne biaad pteed xtiidz me, bzeet zhow. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Rëb zho, ib sxeeḻ me meṉ ne guiaadsilaa ne ladznia zha ne nosacsi ne, zha ne rlëë lo ne. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sac ib gdziṉd dze csaan me grë zha xtii pxozgol ne, rquianëpaa zdoo me zho. Ib guiaaṉladzd me miṉe rëb me lo Abraham, ");
INSERT INTO zpmNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","zeeṉe rëb me laa me cxeeḻ meṉ ne csilaa ne, ");
INSERT INTO zpmNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","zeeṉa dziodzebdraa ne lo zha ne rlëë lo ne, lo zha ne rsacsi ne; sinque iṉe tibli gac ne dziuuṉ ne miṉe rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Gzataa dze ne gneedz me guieḻmban lo ne, iṉe mbe zdoo ne, dziuuṉ ne miṉe rleynie me. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Luu goṉ xin, bzooblo Dios ro ne zob gbaa, cteed xtiidz me lo miech, luu tedner tsienee luu lo zho, laa meṉ co no guiaad. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Luu gnee lo grë zha Israel, guieṉ zho gaṉle zha guṉ Dios zho perdon, parne ycaania me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ne nligaa rleynie me ne, rquia zdoo me ne, gane laa me cxeeḻ Xpëëd me, meṉ co gac zig tib biini, ");
INSERT INTO zpmNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Biini co gziini lo grë zha ne mban lo guieḻcow, zeeṉa biini co glu nëz lo ne, guio ne nëz ne peet zhgab, peet dzeb guieṉd. ");
INSERT INTO zpmNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zigse zie dzew, scase scase zieroob mëdyeeṉ co, ni scaquegaa dib zdoo win rleynie win Dios. Zeeṉe laa win broobpaa, dzigo güey win bio win tib dan zit, haxta bdziṉ dze ne laa win psilo pseed miech laa win blulo lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lëëtaaque leṉ dze co, laa August, rey nroob ne zob Roma, bnabey top lë grëse miech ne no dib dan ne rnabey me, par gacnaṉ me dieṉ palal zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lëë primer vuelt ga ptop zho lë miech, lëë iz co zob meṉ ne lë Cirein zobnabey me guiedz Siria. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bnabey August grëse miech zha ne no stib ladz beṉ, laa zho no tsie zaatne nacpaa ladz zho tsiedeed zho lë zho, parne ga ygab zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Miṉ co nagoṉ nacne briee José guiedz Nazaret (xtan Galilé) grop me Marí zie me Belén (xtan Judé). Laa me zie ga, sac ga goc ladz xmeṉgol me rey David. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Gard ctsieelniapaa me Marí, per nole xtiidz me grop me. Leṉ dze co ziaadyobpaa gal xpëëd Marí. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Bdziṉ me Belén, bgaadraa me zaatne nrieelo mbëz me leṉ yu, lega nac ti leṉ lidz ma bdeed zho blëz me. Lëëtaaque bdziṉ me ga, laa mëëd co gol. Racse Marí pcheḻ me win lar, bdiix me win tib leṉ yag ne row ma guizh; lëë mëëdglo ga lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Guieel co, blalaa zha ne nac baxtor, laa zho ndxie quianap zho xpëcwxiil zho dan, ");
INSERT INTO zpmNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","tibaque zeeṉe brieequia tib xanjl Dios lo zho, dipse zaatne ndxie zho ga biab tib biini nroob. Zeeṉe goṉ zho anjl co, goṉ zho biini nroob co, per nli bdzieb zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dzigo bnee anjl co, rëb me lo zho: ―¡Gdziebde to! ¡Goḻgon diidz cub ne gaṉle ziaḻnie naa lo to nu! ¡Tib guieḻbley nroob gac diidz rii lo grëse miech! ");
INSERT INTO zpmNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Meṉ ne goṉ quiambëz to ga guiaad csilaa to, laa me blansole lo guidzliu. Me nac Meṉ ne zëëble diidz ga cxeeḻ Dios, me nac meṉ ndzon ne rnabey. Belén, zaatne goc ladz rey David, ga gol me naguieel. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Goḻtsie, zaatne tsiedziel to tib mëëdbgui yeeṉ, nrieḻse win lar zhoob win leṉ yag ne row ma guizh, lëë me ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tibaque zeeṉe goṉ zho laa stib dzoon anjl brieequia gocgrë anjl ne quianee lo zho ga, psilo grë anjl co rooḻnie zho Dios, rnee zho: ");
INSERT INTO zpmNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Haxta zaatne glaaraa gbaa, nozhoobneṉ gaṉle pa lotaa meṉ nroob nac Dios! ¡Nasi, grëse miech zrieelo guiaaṉwen zho lo me; zdoo me rala laa me nobedz zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Zeeṉe laa grë anjl co zey gbaa stib, psilo grë baxtor co rnee zho: ―¡Niinaga goḻgotsaa guio Belén! ¡Gotsaa guiowi ne dieṉ, zeeṉa dziaṉ ne miṉe biaadnie anjl co diidz lo ne nu! ");
INSERT INTO zpmNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Lëëlëd bio zho nëz laa zho zie. Bdziṉ zho zaatne blëz José ga grop Marí, nligaa laa mëdyeeṉ co nix ga, nixse win tib leṉ yag ne row ma guizh. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Dzigo bzodiidz zho grëse zha rëb anjl co lo zho, zeeṉe güeynie me diidz laa win gol. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","19","Grë zha ne bina, per nli rzee zdoo zho; laa Marí nosew zdoo me, tibaque rsoladz mew. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Blozh ga, laa zho bio nëz ziequianap zho xma zho stib. Iṉe rooḻnie zho Dios, rdeed zho xquizh lo me sca pxeeḻ me xanjl me güeynie diidz lo zho, rley zho sac brieelo goṉ zho mëdyeeṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dze ne goc xon ngbidz gol win, dze co bio win bey ne rio xpëëdbgui zha Israel, par glu xnëz Dios ngab zho; dze coquew bleelë zho win JESUS, zigne rëb xanjl Dios zeeṉe güeynie me diidz ne laa win gac mëëd lo Marí. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Nac ley ne psaṉ Moisés lo zha Israel, wnaa ne sca rap mëëdbgui, zeeṉe rac zho tap zhmal, none tsienie zho chop ma cogon zho leṉ yadoo; yase tsienie zho tib nëz coc, tib nëzgaa palom. Ni rnabeya: “Grëse mëëdbgui ne rac mëëdglo, ib none gdeed zho win gac win tib zha ne guṉ xtsiiṉ Dios.” Nacne zeeṉe bza dze co, dzigo briee Marí zie me Jerusalén grop me José, zienie me mëdyeeṉ co yadoo csaṉ me win ladznia Dios; lëë nëzle ga zienieque me gon ne no gdeed me ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lëëtaaque dze ne bdziṉnie zho win leṉ yadoo, laa tib meṉ lë Simeón no ga. Meṉ Jerusalén nac meṉ co, rleynie me Dios, rioxco me mban me zigne rnabey Dios, ni nacnie Espíritu Sant me. Quiambëz me gaṉ me Meṉ ne nole diidz ga cxeeḻ Dios csilaa zha Israel, ");
INSERT INTO zpmNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","sac rëble Espíritu Sant lo me ible laa me no gaṉ meṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Laa dze co, Espíritu Santaque psiaab guic me zie me yadoo. Nacne lëëtaque no me leṉ yadoo, laa zho bdziṉnie mëdyeeṉ co ga, ziesaṉ zho win ladznia Dios zigne rnabey ley. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Dzigo me wbig bdeedz win, rdeed me xquizh lo Dios, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Xquizh xquieḻnzaac luu Dios, miṉe në luu lo zhinguṉdziin win luu nu, laaw goc. ¡Nasi zacle nagoṉ guiaad-xi luu naa, haxta gley naa gbi naa lo guidzliu rii! ");
INSERT INTO zpmNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","¡Meṉ ne nacle diidz cxeeḻ luu guiaadsilaa miech lo xtoḻ zho, grop lo naa laa naa raṉ me niina! ");
INSERT INTO zpmNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","¡Grëse miech ne ndxie lo guidzliu, me nac biini ne gziini lo zho! ¡Me csaṉnziuu zha Israel, ne nac zho zha ne ngab lo luu! ");
INSERT INTO zpmNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Zeeṉe goṉ Marí grop José scataa rzë grë diidz ne rnee Simeón rzeet Simeón mëdyeeṉ co, bzee zdoo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dzigo bnab Simeón lo Dios gacnieṉ Dios me gza me mëdyeeṉ co. Blozh ga, rëbchaa Simeón lo xniaa win: ―Tib guieḻbley nroob ne gac mëëd rii lo zha Israel, por win ndal zho griee lo guieḻcow ne no zho, laa zho gbig lo Dios. Ni scagaa zrieequia zha ne glëënie win, per lëëque zha csacsi zho ga. Mban gac zdoo luu, nroob guieḻnë ne tso luu gaṉ luu zha sac miech win. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ga glu gaṉle zha nac zdoo tib tib miech. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ye tib zhuz gol lë An zo ga hor co. Tibaque no me yadoo, dze guieel rooḻnie me Dios, rcuan me ni rzodiidznie me Dios. Tib zhuz gola, leṉ dze co rac tapgaḻ tap iz biaaṉ me viud. Nguieg me ptsieelnia me, per loxaque gadz iz wbannie me tsieel me. Lëë pxoz me ga brieelë Fanuel, lëë zhey co ga nac zha xtii Aser. Tib meṉ ne rteed xtiidz Dios lo miech nac me, ");
INSERT INTO zpmNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","dzigo wbigaque me, psilo me rdeed me xquizh lo Dios; ni bzodiidz me lo grë zha ne ndxie ga, rëb me lëë mëdyeeṉ co ga nac meṉ ne quiambëz zho ga guiaadsilaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Blozhse beeṉ José miṉe rnabey xley Dios grop me Marí, dzigo laa me wbi ga. Bdedraa ga, beynie me mëëd co Nazaret, zaatne nac ladz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ga broob win, zigse zieroob win scase scase rac macis win, scase riabiiniraa win. Tibaque nacnie Dios win. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Zeeṉe bloozh Jesús tsiipchop iz, dzigo güey José grop me Marí güeynie me win lni Pascw, lni nroob ne ruṉ zho Jerusalén. Gzobse iz rie me grop me, per iz cotaa laa me güeynie win, sac nac zhiwseed zha Israel, mëëdbgui ne rap lalga iz, zrieelole tsie zho lo lni co. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Zeeṉe laa lni co bded, laa me bio nëz grop me laa me wbi ga. Ib bieṉd me biaaṉ win Jerusalén, ");
INSERT INTO zpmNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","tibaque güeynie guic me lad grëraa miech ne wbire lni, lad co zienaḻ win. Laa me no nëz, zeeṉe bdzetaa dzew, laa me psilo rguib win, bnabdiidz me lo grë zha lidz me, lo grë zha ne ruṉbey me, ");
INSERT INTO zpmNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","per ni tib zho choot rdeete win diidz. Nacne wbireque me nëz Jerusalén stib, zieguib me win. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dze ne racle tsoṉ ngbidz blozh lniw, dzigoraa güeydziel me win leṉ yadoo, laa win zob lo grë zha ne nac maistr ley, noquiaadiag win grë zhiwseed zho ni nzian grë ncuaaṉe rnabdiidz win lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Rzee zdoo zho raṉ zho scataa nixbiini win, niicle zeeṉe rnee wina, zeeṉe rtsiregaa win lo xtiidz zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Zeeṉe goṉ me laa win zob lad grë meṉ co, bzee zdoo me; dzigo rëbchaa xniaa win lo win: ―Xin, ¿pe nacne squi beeṉ luu? Ptseeb luu no goṉ, quia no grop no pxoz luu noguib no luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pquiab win rëb win: ―Nguibde to naa. ¿Pe raṉde to ib none guṉ naa xtsiiṉ Pxoz naa? ");
INSERT INTO zpmNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ib bieṉd me pe nacne sca rëb win. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dzigo laa win zienaḻ zhits me, laa me zeynie win Nazaret; nose grë miṉ co zdoo xniaa win. Tib mëëd nguzobdiidz nac win, ron win xtiidz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Zigse zie dzew, laa win riabiiniraa, laa win noroobraa; rleynie Dios win, niiclegaa miecha rleynie zho win. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Bdziṉ dzew, laa Juan psilo pseed miech. Lëë leṉ iz co rac tsiiṉ iz zob meṉ ne lë Tiber nac me rey, rnabey me grë guiedz ne ngab lo zha Roma. Leṉ dze co zob Pilat rnabey me grë guiedz ne ndxie nëz Judé, laa Herod zob rnabey grë guiedz ne ndxie nëz Galilé. Leṉ dze coque zob bets Herod, meṉ ne lë Lip rnabey me grë guiedz ne ndxie nëz Ituré ni nëz Traconit; laa Lisian rnabey grë guiedz ne ndxie nëz Abilin. Zha ne nac zhipxoz nroob zha Israel leṉ dze co, nac Anás ni Caifás. Leṉ dze copaa nagoṉ güeynee Dios lo Juan (xpëëd Zacarí) dan ngan ne no Juan ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nacne hor co psilo Juan güeyted me grë guiedz ne ndxie ro guiubee Jordán, rnee me lo grë miech co, csaan zho xquieḻntseeb zho gbig zho lo Dios ni chobnis zho, zeeṉa csilaa Dios zho lo grë xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ga brieequia miṉe bnee Isá, meṉ ne biaad pteed xtiidz Dios, zeeṉe znu pquiaa me: Bii zon miech gaṉle zeeṉe laa tib tsi meṉ zëëb tib dan ngan, rnee me: “Goḻzhixcuaa nëz ne ted meṉ ne rnabey, goḻsaan grë guieḻntseeb ne ruṉ to. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Zaatne nac leṉ blë, goḻcodzëëw, grë gui glaa, grë gui las, goḻsiaablow. Nëz ne niecw, nëz ne quiaya quiaguiet nac, goḻzhixcuaaw. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Grëse miech, laa zho gaṉ meṉ ne pxeeḻ Dios ga ziaadsilaa zho.” ");
INSERT INTO zpmNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Zeeṉe raṉ Juan laa miech rdziṉ lo me cchoobnis me zho, rnee me lo zho: ―¡Miech ngoopdoḻ, masaque nac to zig nac meeḻ! Naṉ to na lëë, loxaque chobnis to laa to laale lo grë guieḻnëdox ne ziaadyob guiaad. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Led scada goṉ, none ndzinli gban to zeeṉa glu nlipaa psaan to xquieḻntseeb to. Ni gacniatsde to guiab to, loxaque por nacse to zha xtii Abraham, laa Dios csilaale to; sac gneli naa lo to gaṉle, teḻne gacladz Dios, haxta grë quie zac gnabey me tsaalow miech ne gac zha xtii Abraham. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Naṉle to gaṉle, grë yag nex ne rquiad nex lo, zeeṉe raṉ zho sca naca, rchug zhow, rzëëg zhow; scadaa nagoṉ sac grë zha ne gband zigne racladz Dios, ib tedlaad zho lo gui; sac rrieequia laa me nzheṉle xquiibyag me, cchug me grë yag ne sca nac. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dzigo rnabdiidz zho lo Juan, pe no guṉ zho parne ygaad zho grë guieḻnë co. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dzigo rquiab me rnee me lo zho: ―Teḻne quianie to chop lar ne racw to, none gdeed to tiba lo zha ne guieṉd xab; teḻne quianiegaa to ncuaaṉe gow to, none gdeed to palala yquiin zha ne quianieda. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wbigaque bla recaudador ne zie chobnis, rnabdiidz zho dieṉ pe guṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Pquiab Juan, rëb Juan lo zho: ―Cuandraa to samiech to, miṉe rieguiaḻse zho quizh zho, miṉ co goḻnab lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ye zla meṉguiib wbig, rnabdiidz zho rëb zho: ―¿Teḻzhe no waa, pe nac miṉe dziuuṉ no? Rquiab Juan rnee Juan lo zho: ―Ndzinli goḻgac, ib ctsebde to samiech to par dieṉ pe gla to lo zho; zha ne peet xtoḻd, ib yquiaaquide to zho ncuaaṉe beeṉd zho. None sac zdoo to dimi ne quiayazh to. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nzian grë miech co quiambëznë zho gacnaṉ zho dieṉ pe lëële Meṉ ne bzooblo Dios ga cxeeḻ me nac Juan. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dzigo rëb Juan lo zho: ―Tib wrobnisse nu rnedz naa lo to, saṉgue meṉ ne no guiaad ga Espíritu Sant gdeed me lo zha ne gliladz me; ni scagaa zha ne gliladzd me, sonëz me zho zaatne nitlo zho. Ne nligaa meṉ non nac me, teḻ naa peet nond naa, per ni par tib nguṉdziin ne glit lab me ni me, raguiaḻd naa gac naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Laa me guiaad zig tib zha ne rbeeguizh zhobxtil, sac zha co, rlozhse rbeeguizh zho zhob rgotsow zhow, laa paj rlaaḻ zho lo gui, ga reca. Per gui ne gzëëg grë paj ne guiadbee me ga, gdziṉd dze guiuuw. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sca rnee me lo zho, par guieṉ zho zha nac Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tib vuelt haxta lo rey Herod goctox me, sac lëëque Herodí, wnaa ne nac tsieel bets Herod nonie Herod; grë guieḻntseeb ne quiayuṉ Herod, blisqui mew. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Per laa ne nion Herod diidz, leḻ beeṉ me stib guieḻntseeb, bnabey me bgaa Juan bio Juan ladzguiib. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Leṉ dze ne nochoobnis Juan miech ga, tib dzew laa Jesús bdziṉ lo Juan ga, ye me bnab cchoobnis Juan me. Blozhse brobnis me, laa me quiazodiidznie Dios, tibaque zeeṉe bzhial zhan gbaa, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","laa meṉ ne nac Espíritu Sant biet, rlu me zig rlu tib palom, laa me bdziṉ guic Jesús, hor co blu zëëb tib tsi meṉ co nëz gbaa, rnee me: ―Xin, rleynie naa luu goṉ, nziuu luu lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Gaḻptsii iz rap Jesús, laa me psilo xtsiiṉ me pseed me miech. Zha ne ruṉbey me, rzoob zho xpëëd José nac me, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","José co goc xpëëd Elí, Elí goc xpëëd Matat, Matat goc xpëëd Leví, Leví goc xpëëd Melqui, Melqui goc xpëëd Jan, Jan goc xpëëd José, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José goc xpëëd Matatí, Matatí goc xpëëd Amós, Amós goc xpëëd Nahúm, Nahúm goc xpëëd Esli, Esli goc xpëëd Nagai, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai goc xpëëd Maat, Maat goc xpëëd Matatí, Matatí goc xpëëd Semei, Semei goc xpëëd José, José goc xpëëd Judá, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá goc xpëëd Joan, Joan goc xpëëd Resa, Resa goc xpëëd Zorobabel Zorobabel goc xpëëd Salatiel, Salatiel goc xpëëd Neri, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri goc xpëëd Melqui, Melqui goc xpëëd Adi, Adi goc xpëëd Cosam, Cosam goc xpëëd Lmodam, Lmodam goc xpëëd Er, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er goc xpëëd Josué, Josué goc xpëëd Liezer, Liezer goc xpëëd Jorim, Jorim goc xpëëd Matat, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat goc xpëëd Leví, Leví goc xpëëd Simeón, Simeón goc xpëëd Judá, Judá goc xpëëd José, José goc xpëëd Jonán, Jonán goc xpëëd Liaquim, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Liaquim goc xpëëd Melé, Melé goc xpëëd Mainán, Mainán goc xpëëd Matata, Matata goc xpëëd Natán, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán goc xpëëd David, David goc xpëëd Isaí, Isaí goc xpëëd Obed, Obed goc xpëëd Booz, Booz goc xpëëd Salmon, Salmóngoc xpëëd Naasón, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón goc xpëëd Minadab, Minadab goc xpëëd Aram, Aram goc xpëëd Srom, Srom goc xpëëd Far, Far goc xpëëd Judá ");
INSERT INTO zpmNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá goc xpëëd Jacob, Jacob goc xpëëd Isaac, Isaac goc xpëëd Abraham, Abraham goc xpëëd Taré, Taré goc xpëëd Nacor, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor goc xpëëd Serug, Serug goc xpëëd Ragau, Ragau goc xpëëd Peleg, Peleg goc xpëëd Heber, Heber goc xpëëd Sala, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala goc xpëëd Cainán, Cainán goc xpëëd Rfaxad, Rfaxad goc xpëëd Sem, Sem goc xpëëd Noé, Noé goc xpëëd Lamec, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec goc xpëëd Matusalén, Matusalén goc xpëëd Enoc, Enoc goc xpëëd Jared Jared goc xpëëd Mahalaleel, Mahalaleel goc xpëëd Cainán, ");
INSERT INTO zpmNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán goc xpëëd Enós, Enós goc xpëëd Set, Set goc xpëëd Adán. Adán goc zig tib xpëëd Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Zeeṉe blozh brobnis Jesús guiubee Jordán ga, nacnie Espíritu Sant me, dzigo güeynie me Jesús tib dan ngan, zaatne choot miech guieṉd. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ga bio Jesús, ni tib lë peet dowd me; gzase dze pquianaḻ meṉdox niuṉgüet ma me niuṉ me miṉe racladz ma. Zeeṉe goc choo dze no me ga, goṉ ma lëbdraa me rcaabedz me, ");
INSERT INTO zpmNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","dzigo rëbchaa ma lo me: ―Teḻne nli Xpëëd Dios nac luu, bnabey tsaalo grë quie rii ncuaaṉe gow luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dzigo pquiab me rëb me lo ma: ―Znu zhobnee lo Xtiidz Dios: “Niapse por xtiidz Dios mban miech, yquiamband zho loxaque guieḻwagwse.” ");
INSERT INTO zpmNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Blozh ga güeynie ma me glaa tib guic gui, ga znuse blu ma grëse guiedz ne ndxie dib lo guidzliu lo me, ");
INSERT INTO zpmNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","rëb ma: ―Bui gaṉle, grëse guiedz ne goṉ raṉ luu i, cheṉ naaw, zrieelo gded naaw lo zha ne racladztaa naa. Grësew, dib guieḻndaan ne no low, znedz naaw lo luu ");
INSERT INTO zpmNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","teḻne squiitsgzhib luu lo naa, guṉnon luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","―¡Biche lo naa nu meṉdox! ―rëb me lo ma―. Znu goṉ zhobnee lo Xtiidz Dios: “Diosse nac meṉ ne rnabey, mese none guṉnon luu, lo me rieguiaḻ yquiitsgzhib luu; ni miṉe rnabey me miṉ co none guṉ luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Blozh ga güeynieque ma me lad guiedz Jerusalén, ga blep ma me zaatne mazdraa glaa guic yadoo nroob ne zob lad guiedz co, rëb ma lo me: ―Teḻne nli Xpëëd Dios nac luu, briṉgaa nu, ");
INSERT INTO zpmNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","beṉque led znu rnee lo Xtiidz me: “Znabey Dios grë xanjl me yquiaanap luu, ");
INSERT INTO zpmNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","zgueedz zho luu, zeeṉa ni tib quie ycaaṉd ni luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Dzigo rëb me lo ma: ―Psoladz gaṉle noque stib zaatne znu rnee lo Xtiidz Dios: “Bieṉ, Dios nac meṉ ne rnabey luu, nodne quitnie luu me gnab luu lo me guṉ me ncuaaṉe nod guṉ me.” ");
INSERT INTO zpmNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Goṉse ma rdzield zha guṉgüet ma Jesús, dzigo biche ma lo me palal dze. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Blozhse ga, dzigo laa Jesús wbi ga bdziṉ me nëz Galilé, scaque nacnie Espíritu Sant me. Znuse beeṉbey miech me por grëtaa ncuaaṉ ro ne ruṉ me, grëse guiedz ne ndxie nëz co, rzeet zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Zaatne rdziṉtaa me, rie me xyadoo zho, rseed me zho Xtiidz Dios, rleynie zho me, rley zho ron zho grë miṉe rnee me. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tib dzew, laa me bdziṉ Nazaret, zaatne broob me. Goḻ dze ne rdziiladz zha Israel lo dziin, güey me xyadoo zho zig ruṉaque me grëraa zaatne ziye me. Zeeṉe goḻ horne rlab zho Xtiidz Dios, dzigo bded me, ");
INSERT INTO zpmNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","bdeed zho miṉe pquiaa Isá glab me. Pxal me low, lëëtse zaatne znu rnee blab me: ");
INSERT INTO zpmNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ZhiEspíritu Dios nacnie naa, ible Dios bzooblo naa, gnee naa Diidz Ndzon ne nac xtiidz me lo grëse zha ne rquiinnëw. Laa me pxeeḻ naa gne naa lo grë zha ne ngadoo lo ncuaaṉe nosacsi zho, zeeṉa guieṉ zho zha griee zho lo grë ncuaaṉ co. Laa me pxeeḻ naa gziini naa lo grë zha ne no lo guieḻcow, grë zha ne rzac guieṉdraa zha griee zho lo zhizhgab zho, laa me pxeeḻ naa, naa cuee zho lo zhgab co. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Laa naa ziaḻnie diidz lo miech, gacnaṉ zho pa lotaa noxco Dios guṉlay me grëse zha ne gbig lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Blozhse blab me lo co, ptibëd mew bdeed mew lo zha ne quianapa, dzigo laa me bzob. Grëse zha ne no leṉ yadoo ga, dze rwi zho lo me, ");
INSERT INTO zpmNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","dzigo bnee me lo zho, rëb me: ―Grë diidz ne blozh blab naa lo to nu, leṉ dze rii goṉ laaw noyac cumplir. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Grëse zho rleynie zho me, rlozhd gzee zdoo zho ron zho grëtaa diidz ndzon ne rnee me. Rnabdiidzlsa zho rnee zho: ―¿Bay zha squitaa pseed meṉ qui? ¡Led lëë xingan José i! ");
INSERT INTO zpmNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dzigo rëb me lo zho: ―No tib diidz ne rnee: “Zha ne racnie stib miech, none guieṉ zho glo meṉladz zho gacnie zho.” Rieṉpaa naa goṉ, miṉ co racladz to gnë to lo naa; quiambëz to gaṉ to grë milagr ne ziyon to beṉ naa guiedz Capernaum. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","’Gneli naa lo to gaṉle: Zha ne riaad rteed xtiidz Dios, ible znu raṉdzed meṉladz zho zho; gane rrieelod pe guṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Goḻsoladz gaṉle zeeṉe biaad Lí, bio tib tiemp ne biabd guie tsoṉ iz groḻ, tib gbindox ne goṉ miech Israel nu. Ndal wnaa viud ne nac meṉladz me mban bded zho, guieṉd pe nquiin zho, per brieelod niuṉ me xyudar zho; leḻ xyudar tib wnaa Sarept pxeeḻ Dios me güeyguṉ me, guiedz ne ndxie gax Sidón. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Scaque zeeṉe biaad Liséw, ndal zha Israel rlan guiedzdox ne nac lepr, per ni tib zho beeṉguiacd me; leḻ tib zha Siria lë Naamán, meṉ co beeṉguiac me. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Zeeṉe goṉ zho sca rnee me, blëë zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Gusobe zho, blee zho me lad guiedz, güeynie zho me tib ro yee ne quia glaa guic gui ne ndxie guiedz co. Laa zho nole par ctiix zho me ga, ");
INSERT INTO zpmNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","zeeṉe znuse bded me lad zho, ziega me. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ga wbi Jesús, bdziṉ me guiedz Capernaum stib, guiedz ne ndxie nëz Galilé. Gzobse dze ne rdziiladz grë miech co lo dziin, rie me xyadoo zho rieseed me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Rzee zdoo zho ron zho grë zhiwseed me, grëse miṉe rnee me, rlu zha rnabey nac me. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tib vuelt, lad grë zha ne noseed me ga no tib mgui ne nosacsi meṉdox; roptsie meṉdox co rnee ma lo me: ");
INSERT INTO zpmNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Psaan no! ¿Pe guṉ luu no Jesús Nazaren? ¿Ziaad luu lëë par gnitlo luu no? ¡Ruṉbey naa luu, luu nac meṉ ndzon ne pxeeḻ Dios! ");
INSERT INTO zpmNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dzigo goctox me lo ma, rëb me: ―¡Psioog ro luu! ¡Na zeeṉa psaan meṉ qui! Horco, squi ndxie grë miech co broṉ ma mgui co liu, miṉcose beeṉ ma, laa ma briee laa ma zie. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Rlozhd gzee zdoo grë miech co, rnabdiidzlsa zho rnee zho: ―¿Zha nac xtiidz meṉ qui, zha nacne haxta meṉdox rdzieb ma me, rzhooṉ ma zeeṉe laa me ractox lo ma? ");
INSERT INTO zpmNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Grëse guiedz ne ndxie gax ga, zigse zie dze rzhooṉ diidz scataa milagr ne ruṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Briee Jesús leṉ yadoo, zie me nëz lidz Simón. Bdziṉ me lëëtaque laa xniadzoop Simón nix rlan xlëë, nzhoo rac me; dzigo wbig zha ne beeṉ vis laa zhuz co rzacnë, bnab zho lo me guṉguiac me me. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nacne bded me zaatne nix zhuz co, goctox me lo xlëë co. Horcogazha laaw blëz, guche zhuz co ga, beeṉlo me ncuaaṉe dow zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Laa ngbidz rzëëblew, zeeṉe bdziṉ grë miech co lo Jesús, bdziṉnie zho grë zhimguidz zho. Zhaase zhaase guieḻguidz ne rzac tib tib mguidz co, per grëse zho zigne rxobnia me guic zho laa zho riac. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nzian zho beṉcxooṉ me meṉdox ne nosacsi zho, zeeṉe laa ma rriee, nguiedz roptsie ma rnee ma lo me: ―¡Rdziuuṉbey no luu, Xpëëd Dios nac luu! Dzigo ractox me lo ma, rsaand me gnee ma cho nac me, sac wen wen naṉ ma me nac Meṉ ne nacle diidz ga cxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Biini liu co, silgaw briee Jesús lad guiedz co güey me tib zaatne choot miech guieṉd. Zeeṉe bnit me lo grë miech co, briee zho güeyguib zho me haxta bdziel me lo zho; rnab zho lo me Capernaumse ga cuëz me, paat tsiedraa me. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dzigo rëbchaa me lo zho: ―Grieeloda, ib none ga naa grëraa guiedz, gaseed naa miech gacnaṉ zho zha racladz Dios gban zho; sac ible miṉ co pxeeḻ me naa ziaḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nligaaw, grëse guiedz ne ndxie nëz Galilé ga güeyted me, güey me yadoo ne zob tib tib guiedz co, güeynee me Xtiidz Dios lo grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tib vuelt miech guizhiu ne pcaalsa lo Jesús ro Nisdoo Genesaret, haxta rtaagw zho me; grëse zho racladz yquiaadiag zho Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Gax ga zo chop barcw, blalaa ngooz meḻ biet leṉa, laa zho no lo nis ga noguiib zho guiex ne rnaaz zho meḻ. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nacne güey me biep me tib leṉ barcw co, bnabey me Simón psëë Simóna bzëëba lo nis palal; sac lëë xbarcw Simón ga. Dzigo leeṉ co bzob me pseed me grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Zeeṉe blozh bnee me lo zho, rëbchaa me lo Simón: ―Nana gaṉle zeeynie barcw rii guionie new zaatne guietlaa nis, zeeṉa groṉ to guiex ne rgaa meḻ i gnaaz to palal ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pquiab Simón rëb Simón: ―Dib guieel-le bdzio no lo nis rii, per ni tib meḻ bnaazd no; per lega ne luu rneew, na dieṉ laa no groṉa stib. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Broṉ zho guiex co lo nis, zeeṉe laa zho cueew, ya zig zrieza, biodzëse leṉa no meḻ. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Horco blunia zho lo grëraa zha ne nacgrë zho no stib leṉ barcw co, parne tsie zho guṉ zho xyudar zho. Bdziṉ zha co gocgza zho, gropse leṉ barcw co pcodzëë zho grë meḻ co; ya zig zdedquiew lo nis. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Zeeṉe goṉ Simón scataa meḻ taf ne bgaa, pquiitsgzhib me lo Jesús, rëb me: ―Bzhiguieḻ mazd psaan naa, tib miech ngoopdoḻ nac naa, rdzieeld so luu lo naa nu. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Zigtaa Simóna, zigtaa zha ne ziegza mew, rzee zdoo zho ni rdzieb zho scataa nac milagr ne goṉ zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Scasaque rac Jacob ni Juan (xingan tib meṉ lë Zebedé), zha ne nacgza Simón. ―Gdzieebd luu ―rëb Jesús lo Simón―. Zigne squi goṉ rioxco luu riaad luu gooz meḻ niina, desde nadze laa luu tsoxco guṉ luu stib gooz; laa naa cxeḻ luu tsietop luu grë miech ne sëëb xnëz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Zigne bdziṉnie zho barcw co ro nis, bzo zhow ga, laa zho zienaḻ zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Laa Jesús no tib guiedz co, tib dzew, bdziṉ tib mgui ne rlan guiedzdox ne lë lepr lo me, pquiitsgzhib mgui haxta bdziṉ lo mgui liu, rëb mgui lo me: ―Tebaa siguieeḻ luu guṉguiac luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dzigo pxobnia me guic mgui, rëb me: ―Zuṉguiac naa luu. ¡Niinagazh laa luu guiaaṉmbe! Horcogazha laa mgui biaaṉmbe lo guiedz co. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dzigo pso Jesús diidz lo mgui, choot lo gzodiidzd mgui zha biac mgui; ni rëb me lo mgui: ―Bzë, güey lo pxoz, güeysaṉ gon ne rnabey xley Moisés gdeed luu; zeeṉa gaṉ zho gaṉle laa luu biacle. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Niicle sca nëd me gacnaṉ miecha, per znuse znuse rliaaḻ diidz grëtaa milagr ne ruṉ me; miech guizhiu ne rdziṉ lo me, zha ne zie yquiaadiag zhiwseed me, zha ne zieegaa guṉguiac me zho teḻ pe guieḻguidz ne rzac zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Zhiga, zhiga rbiche me lo miech, rie me zaatne choot guieṉd riezodiidznie me Pxoz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Stib dzew, miech guizhiu ne ndxie lo Jesús noquiaadiag zho zhiwseed me. Nzian grë zha farisé, grë maistr ley, zha ne briee dib nëz Galilé, dib nëz Judé, zha ne brieegaa Jerusalén, ye zho laa zho no lad co noquiaadiag zho grë miṉe rnee me. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Laa grë miech co ndxie ga, zeeṉe bdziṉ bla zha bgui, ney zho stib meṉ bgui, zhoobse me lo yag, ib gacd së me sac dipse me gutoo. Gocladz zho nzëëbnie zho me leṉ yu ne no Jesús ga, ndziṉnie zho me lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Per ib gocd nded zho lad grë miech co. Nacne biepaque zho guic yu, pxal zho tiblë guiic co, ga pteed zho meṉ rzacnë co dib yag ne zhoob me ga, bdziṉ me lo Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Zeeṉe goṉ Jesús ne nli dib zdoo zho rnalo zho me, me guṉguiac meṉ rzacnë co, rëbchaa me lo meṉ co: ―Peet tsienied guic luu, niinagazh laa naa guṉ perdon grëse xtoḻ luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Zeeṉe bin grë zha farisé co, grë maistr ley co sca rëb me, rneechaa zho gza zho: “¿Cho dzigo rzac mgui qui nac me? ¡Falt i goṉ noyuṉ me lo Dios! ¡Tibaque meṉ ne ruṉ perdon xtoḻ miech, ni lëë meṉ co nac Dios!” ");
INSERT INTO zpmNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bieṉga Jesús sca quianee zho, dzigo rëbchaa me: ―¿Pe nacne rzac to laa naa quiayuṉ falt? ");
INSERT INTO zpmNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Nli choḻze zac guiab laa zho guṉ perdon xtoḻ miech, per grieelod guṉguiac zho zho. Goḻwi gaṉle laa naa guṉguiac mgui rii, zeeṉa gacnaṉ to naa ne nac naa Mgui ne pxeeḻ Dios, ible rap naa poder par guṉ naa miech perdon. Dzigo bnee me lo meṉ rzacnë co, rëb me: ―¡Niinagazh guche i, bi yag ne bzhoob luu i, zeeṉ bzë! ");
INSERT INTO zpmNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Zigne sca bnee me, laa mgui co bzoli, squi ndxie grë miech co laa me blis yag co, iṉe rooḻnie me Dios laa me zey. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Psilo zho grëse zho, rooḻnie zho Dios; lala rzee zdoo zho, lala rdzieb zho, rnee zho: ―¡Nadzesi, laa ne bdziaṉ ncuaaṉe gard dziaṉ ne! ");
INSERT INTO zpmNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Blozh ga, laa Jesús briee ga. Ro nëz zieded me goṉ me tib meṉ lë Leví, zobse meṉ co lo mezh ne rietizh zho dimi ne razh lo zha Roma, sac me rtop dimi co. Dzigo bredz Jesús me tsienaḻ me zhits Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Biaaṉaque xmezh me ga, guso me ga, laa me zienaḻ. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bded ga, güeynie me Jesús tib wagw lidz me. Grë zha ne ruṉ dziin co, ni grëragaa zha ne bdziṉ ga, tipse brenie Jesús zho grë xpëëdscuel me. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Blalaa zha farisé, ni zla maistr ley, rlëë zho goṉ zho sca zobnie Jesús grë zha co, bded ga rëbchaa zho lo xpëëdscuel me: ―¡Lëda i goṉ ruṉ to! ¿Pe nacne sca tipse rownie to grë zha ngoopdoḻ co, grë zha beed ne nac recaudador ga? ");
INSERT INTO zpmNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Dzigo rëbchaa Jesús lo zho: ―Naṉle to gaṉle, zha ne ruṉ rmed, zaatne no zha rzacnë ga rquiin zho, ¿niacxe squiin zho zaatne no zha ne ndip ndaan? ");
INSERT INTO zpmNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Scaque naa nagoṉ, ziaḻguibd naa zha wen, sinque laa naa ziaḻguib grë zha ngoopdoḻ, zeeṉa gbig zho lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bdziṉaque bla zha ne bnabdiidz, rëb zho lo Jesús: ―¿Pe nac waa ib rcuand xpëëdscuel luu, tibaque quiayow zho, tibaque quiaye zho? Zha xpëëdscuel Juan, zha xpëëdscuel farisé, rdziaṉ no tibaque nocuan zho, tibaque nonab zho lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Pquiab Jesús rëb me lo zho: ―Zaatne nadieṉ noyac tib guieḻtsieel, ¿niacxe znabey to ycuan grë zha ne ndxie lo lni, ni raṉ to laa mgui ne notsieelnia zo lo zho? ");
INSERT INTO zpmNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per zdziṉ dze zeeṉe laa mgui co gbiche, ni zeeṉe laa dze co gdziṉ, dzigosi nagoṉ rieguiaḻ ycuan zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Blozhse sca bnee me, rëbaque me lo zho: ―Zha ne rquiaabdie lar, tsod zha ne ctsiez xab cub cuee zho tib lë lar ne yquiaabdie zho tib xab gox zho. Sac tiba, znitlo zho xab cub zho ga, ni stiba rdzieeld yquia tib lë lar cub lad lar gox. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Scaque zha ne rgotsow vin, tsod zha ne cotsow vin cub tib leṉ guid ne padzeelale noquiin, sac stsiez vin cuba; lozh ga zigtaa vina, zigtaa guid cow, laaw nitlo ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Gacxe waa, teḻ vin cuba none leṉ tib guid cubaque tsotsowa. ");
INSERT INTO zpmNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","’Nac cuent rii zig rzac miech vin, zha ne bienle rie vin ne padzeelale notsow, rdziladzd zho guie zho vin cub; sac biaaṉle guic zho rnee miech: “Vin ne padzeela notsow, miṉ co nizhraa rdioow.” ");
INSERT INTO zpmNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tib vuelt, lëëtse dze ne rdziiladz zho lo dziina, bded Jesús zaatne zëëb zhobxtil grë xpëëdscuel me; psilo zho pchoo zho mzion zhobxtil co, zigse ruṉmbe zho zhob co, scase row zhow. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Goṉ blalaa zha farisé sca no zho, dzigo rëbchaa zho: ―¡Lëda i goṉ noyuṉ to! Goḻguieṉ gaṉle dze nda nac dze rii. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pquiab Jesús rëb me lo zho: ―¿Pe gard glab to zaatne ziaad gaṉle zha beeṉ rey David, tib dze zeeṉe pcaabedz me grë me zha ne ziegza me, ni zienied zho pe gow zho? ");
INSERT INTO zpmNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Rneew, bzëëb me leṉ yadoo güeynab me grë guietxtil ne nac gon, downie me grë zha ne ziegza me ga; ni loxaque zha ne nacse pxoz, zha cose row guietxtil co. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ni rëb me lo zho: ―Gacnaṉ to gaṉle naa ne nac naa Mgui ne pxeeḻ Dios, naa rnabey dze rii, naṉpaa naa pe nonguieḻ gac. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Goḻ stib dze ne rdziiladz zho lo dziin, güey Jesús leṉ yadoo win ne zob lad guiedz co, psilo me noseed me miech. Lad grë miech ne no leṉ yadoo ga, no tib mgui, mband nia derech me. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Blalaa zha farisé, blalaa maistr ley no lad co, quialeets zho Jesús dieṉ pe zuṉguiac me mgui co, dze co; sac quiambëz zho teḻ laa me guṉguiac mgui, dzigo miṉ co yquiaaqui zho tsiezo zho me lo zhiwxtis zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bieṉ Jesús sca no guic zho, dzigo bredz me mgui co, bnabey me bzo mgui groḻtaa lo grë zha ne ndxie ga; ");
INSERT INTO zpmNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","blozh ga rëbchaa me lo zho: ―¿Pe nadieṉ rzac to nonguieḻ guṉ ne dze rii? ¿Pe nonguieḻa guṉ ne ncuaaṉe yquiin, te nonguieḻa guṉ ne guieḻntseeb ye? Zig nac samiech ne zha ne noxtseeb xquieḻmban, ¿pe maase csaan ne guet zho? ");
INSERT INTO zpmNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Dze rwi me lo zho tib tib zho, dzigo rëbchaa me lo mgui co: ―¡Bzigaa nia luu! Zigne bzigaa mgui co nia mgui, laaw biac. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Zeeṉe goṉ zho sca beeṉguiac me nia mgui, per nli rlëë zho, psilo zho quianediidz zho dieṉ zha guṉ zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tib vuelt, güey Jesús tib guic gui, dipse guieel blëz me ga bzodiidznie me Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Biini liu co, bredz me grëse zha ne nac xpëëdscuel me, dzigo lad co ble me tsiipchop zho, zha ne tsiepaa tsienee xtiidz me lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Znu lë gza tsiipchop zha co: Simón (zha ne bleelë me Pedr), Ndrés (bets Pedr), Juan, Jacob, Lip, Bartol, Matew, Mazh, Jacob (xingan Alfé), Simón (zha ne no lad grë zha ne racladz cuee wxtis Roma Israel), Judas (bets Jacob), ni Judas Iscariot (zha ne güeyto me). ");
INSERT INTO zpmNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Cho gui co biet me grë xpëëdscuel me, bdziṉ zho tib ro lets. Loxaque bdziṉ zho ga, laa stib dzoon xpëëdscuel me bdziṉaque lo me ga; zhiits co naḻ stib dzoon miech, no zho racladz yquiaadiag zhiwseed me, nogaa zho zie ga par guṉguiac me zho. Miech guizhiuw, zha ne ziaad nëz Judé, zha ne ziaad nëz Tiro, zha ne ziaad nëz Sidón, zha ne brieegaa Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nzian grë zha co nosacsi meṉdox, grëse zho beeṉguiac me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Rbig be grë miech co racladz zho xeṉ zho lad xab me, sac raṉ zho, zha ne rzheṉ lad xab me, teḻ pe guieḻguiidztaa rzac zho, ruṉguiac me zho por grëtaa poder ne rap me. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Dzigo dze bui Jesús lo grëse zha ne nac xpëëdscuel me, rëb me lo zho: ―¡Wen zie zha ne rieṉ none gbig zho lo Dios, sac ib zdziṉ zho zaatne rnabey me! ");
INSERT INTO zpmNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’¡Wen zie zho! Sac niicle teḻne noyaṉ zho gbin, per me gdeed ncuaaṉe yquiin zho; niicle teḻ no hor mban rac zho roon zho; per zdziṉ dze ne gdeed me tib guieḻbley nroob lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Zig nac to, zeeṉe csilo miech glëënie zho to, guṉcxooṉ zho to, yquiaago zho to, gneenë zho to, sac zho haxta ni lë to gondraa zho, loxaque ne nac to zha ne no xnëz Mgui ne pxeeḻ Dios nu, ¡wen zie to ga! ");
INSERT INTO zpmNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","¡Nley goḻco zdoo to dze co, nguieeḻ goḻgac, sac goṉ tib guieḻnzaac nroob ne gneedz Dios lo to! Goḻsoladz gaṉle, scaque beeṉ pxozgol zho grë zha ne pxeeḻ me padzeela biadnee xtiidz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Saṉgue grë zha ne rzac grëse ncuaaṉe rquiin zho quianie zho, ib rquiind zho gbig zho lo Dios, ¡probsaxe zho, sac lo guidzliu riise gac ncuaaṉ co guieḻbley lo zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’¡Probsaxe zho, sac niicle ne grëw quianie zho niina, per zdziṉ dze gaṉ zho gaṉle zha nac gbin; rlozhd gzhidz zho, rlozhd gley zho niina, per zdziṉ dze laa zho gaṉ gaṉle zha nac guieḻnë! ");
INSERT INTO zpmNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Padzeela, biaad bla zha ne pquidie rëb zho Dios pxeeḻ zho, bio pxozgol to bleynie zho zho, ¡probsaxe to teḻne yguib to sca gleynie miech to! ");
INSERT INTO zpmNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Goḻquiaadiaga gaṉle: Zha ne rlëë lo to, goḻleynie zho, teḻ pe nac xliaadz zho goḻgacnie zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Zeeṉe rdzibdee zho to, goḻnab lo Dios guṉlay me zho; zeeṉe rsacsigaa zho to, goḻnab lo Dios yquia zdoo me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Teḻ gneedz zho tib puñet lo to, gzoobd nia to, goḻsaan zho maase yquiaa zho stiba. ’Zha ne gla xabnaḻ to, goḻsaan maase ye biaagw güey zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Zha ne gnabtaa pe cos lo to, goḻdeeda; teḻ scasegaa xeṉ zhow, ib gnabde tow lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","None zaacse gac to lo miech, zeeṉa scagaa zha, zaacse gac zho lo to. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Sac goṉ, teḻ loxaque zha ne ndzieeldiidz to, zha cose rleynie to, ¡led ncuaaṉ nroobd ga ruṉ to! Haxta grë zha ntseeb ruṉ miṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","34","Teḻ loxaque zha ne ruṉsegaa favor lo to, lo zha cosegue ruṉ to favor; zeeṉe ruṉgaa to tib pextad, lo zha ne rgobeyse to zguizh lo to, lo zha cose ruṉxtad to, ¡ni lalnu peet nond ncuaaṉe ruṉ to ga! Sac goṉ haxta grë zha ntseeb ruṉ miṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","’Goḻguieṉ sca, none gleynie to zha ne rlëë lo to, none gacnie to zho lo xliaadz zho. Zha ne guiaad tib pextad lo to, goḻdeed ncuaaṉe rnab zho, ib guiabde to nend lega scase guṉ to favor co lo zho. Zha ne guṉ grë miṉ rii, nroob guieḻnzaac ne gdeed Dios lo zho, ni ga glu zho gaṉle nli xpëëd me nac zho; sac goṉ teḻ me wen me lo grëse miech, niicle zha ne ruṉ falt lo mew, niicle zha ne rieṉdgaa gdeed xquizh lo me, rsaand me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ndzinli sca goḻgac, zigne sca wen Pxoz to lo grëse miech, scaque none wen gac to lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ib guṉde to në gac zdoo to, zeeṉe raṉ to ncuaaṉe nonguieḻd ne ruṉ stib miech, sac to tozhal guṉquizh zhow; zeeṉa scagaa Dios guṉscad me to. Goḻguieṉ none guṉ to samiech to perdon, zeeṉa scagaa Dios zuṉ me to perdon; ");
INSERT INTO zpmNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","sac grëse ncuaaṉe ruṉ miech, miṉcoque rcaania zho. Grëse ncuaaṉe guṉ to, scaania tow, ni haxta ndziibraa miṉe ycaania to. Sac ncuaaṉe guṉ to lo samiech to, miṉcoque guṉ Dios to. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Blozh sca bnee me, dzigo rëbchaa me: ―Goḻwi gaṉle, zig nac zha ne roḻd lo, ¿niacxe zrieelo glu zho nëz lo stib zha ne roḻd lo? Zha ne sca guṉ, teḻ grieḻ ni tib zho zaatne nac tib ro blë, ib tedsod grop xcuaa zho tsietsobe ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","’Grë zha ne nac mëëdscuel, tsod zha ne racraa lo zha ne noseed zho; haxta csiaaḻraa zho zhiwseed zho, ni teḻne tsoxco zhow, zdziṉ zho medid co. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¡Lëda ga goṉ tso to lozhd gzee zdoo to dieṉ cho pe ruṉ, ni nenda mazdraa miṉe ruṉ to! ");
INSERT INTO zpmNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Pe ro to glisqui to miṉe ruṉ stib zho, ni teḻ mazdraa nac miṉe ruṉ to? ¡Goḻguieṉ sca glude to ncuaaṉe nacde to! ¡Glo goḻtsoxco ndzinli gac to, dzigo lozh ga zac tsienee to zha gacndzinli stib zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Tib tib yag rdeedsew xnexa. Grieelod yquia nex ncuaan tib lo yag ne rdeed nex wen; grieelodgaa yquia nex wen tib lo yag me rquia nex ncuaan. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Teḻ zha nac nex ne rquia lo yag, gase rlu zha nac yag. Tsod yag guiets ne yquia guigw lo; ni tsodgaa lbë zarz ne gdeed uv. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Scadaa nagoṉ nac miech, zha ne wena, ncuaaṉ wen ruṉ zho, diidz wen rnee zho, sac desde zdoo zho no guieḻwen co; laa zha ne ntseeb, niapse ncuaaṉe ntseeb ruṉ zho, niapse diidz dox rnee zho, sac desde zdoo zho no guieḻntseeb co. Gacxe waa, teḻ zha rzë xtiidz tib miech, gase rlu zha nac zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Grieelod lega gnee to, naa rnabey to, sac zha ne rneew ib none guṉ zho miṉe rnabey naa. Nzian zha ne rnee, naa rnabey zho, ni ruṉd zho miṉe rne naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","’Zha ne rquiaadiag miṉe rne naa, ni rioxco zho rban zhow zigne naca, ");
INSERT INTO zpmNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","rrieequia nac zho ga zig tib zha ndzielguic ne guiet blee xcimient lidz, psilo zhow haxta zaatne bgaa lo quie. Niicle riab guiedox, peet racd lidz zho, nis naal ne raclo rded zaatne zoba ga, per rbixcheda. ");
INSERT INTO zpmNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Laa zha ne rquiaadiag xtidz naa, ni rioxcod zho gban zhow, ziaad gac zho zig tib zha nxen ne güeyzoob lidz laglaase lo liu. Znuse bnitlo lidz zho, sac zeeṉe biab guiedox, lo nis naal ne goclo bded zaatne zoba, znuse bixchew, ni stib lëw biaaṉd. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Zeeṉe blozh bnee Jesús lo grë miech co, dzigo laa me wbi ga, bdziṉ me Capernaum. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lëëtaaque leṉ dze co rzacnë tib zha ne ruṉ dziin lo tib meṉ ne rnabey lo xmeṉguiib zha Roma, no guiedz co; nzhoo rac zho zootle laa zho guetle. Rleyniedox meṉ co zho, ");
INSERT INTO zpmNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","zigne bin me laa Jesús bdziṉ, lëëlëd pxeeḻ me bla zha ne nac zha non lo meṉguiedz Israel, güey zho güeynee zho lo Jesús siguieḻ Jesús tsieguṉguiac Jesús zhinguṉdziin me. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bdziṉ zho bnab zho lo Jesús siguieḻ me tsie me. ―Bzhiguieḻ beeṉ xyudar me ―rëb zho―. Tib zha wen nac me, ");
INSERT INTO zpmNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","rleynie me meṉladz ne, haxta bzaa me tib xyadoo no lad guiedz nu. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dzigo zienaḻ Jesús zhits zho. Zhile gdziṉ zho lidz meṉ rnabey co, zeeṉe bdzieelo zho bla zha ne ndzieeldiidz me, zienie tib xtiidz me lo Jesús. Rzë xtiidz me, rëb me: ―Bzhiguieḻ mazd guiaate luu. Naraa rieṉ naa choot nacd naa, par csodziin naa lo luu guiaad luu haxta ro lidz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nligaa rieṉ naa tib zha winse nac naa par gbig naa lo luu, gane niicle biaḻd naa niaḻdzieel naa luu. Naṉpaa naa, zaatne ziaad luu i, con tib lan xtiidz luu zac gnabey luu guiac zhinguṉdziin naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sca rnee naa, sac teḻ naa no zha ne rnabey lo naa, zeeṉe rnabey zho naa none gon naa miṉe rnee zho; scaque zhaguiib ne rnabey naa, zeeṉe rne naa tib lo zho: “Güey nu”, rie zho; zeeṉe rnegaa naa: “Dë nu”, riaad zho; zha ne nacgaa zhinguṉdziin naaw, miṉe rnabeytaa naa zho, ruṉ zhow. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Zeeṉe bin Jesús sca rzë xtiidz meṉ co, bzee zdoo me, ptsire lo me, rëb me lo grë zha ne zienaḻ zhits me: ―Goḻwi gaṉle pa lotaa rnalo meṉ qui Dios. Lo grë zha Israel goṉ, ni tib zho gard gaṉ naa squitaa dib zdoo gnalo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Grë zha ne güey mandad ga, zeeṉe bdziṉ zho goṉ zho laa nguṉdziin co biacle. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bded ga, güey Jesús tib guiedz lë Naín grë xpëëdscuel me, miech guizhiu ne zienaḻ zhits zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Zeeṉe bdziṉ zho gax ro guiedz co, lëëtaque bdzieelo zho tib dzoon miech ziequeets xpëëd tib wnaa viud; lëëse mëëd ga lo wnaa co. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Goṉ Jesús zha rac me, pquia zdoo Jesús me, wbig Jesús rëb Jesús lo me: ―¡Goondraa luu! ");
INSERT INTO zpmNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dzigo bzheṉ Jesús yag ne zhoob ngutoo co. Zeeṉe goṉ gza zha ne nxobyaṉ yag cow, hor co bzodze zho; dzigo bnee me lo mëëd co rëb me: ―Xin, ¡guche i! ");
INSERT INTO zpmNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Horcogazha brieeban niib co, bzobli niib, laa niib psilo bnee. Rley xniaa niib, pcaania me niib. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Zeeṉe goṉ grë miech co sca brieeban mëëd co, lala rdzieb zho, lala rdeed zho xquizh lo Dios, rnee zho: ―¡Tib meṉ nroob ne goṉ ziadteed xtiidz Dios i, ziaad lo ne! ¡Laa ne bdziaṉ niina gaṉle, laa Dios ziaadgaṉ ne, ziadbee me ne lo xquieḻnë ne! ");
INSERT INTO zpmNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gdipse nëz Judé, ni grëraa guiedz ne ndxie dib gax ga, gocnaṉ miech milagr nroob ne beeṉ Jesús ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bin Juan Bautist grëtaa milagr ne ruṉ Jesús ga, sac rie xpëëdscuel Juan riezodiidz zhow lo Juan. Dzigo pxeeḻ Juan chop zho, ");
INSERT INTO zpmNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","zienabdiidz lo Jesús, dieṉ pe me nac Meṉ ne nole diidz ga cxeeḻ Dios, te dzigoraa gdziṉ meṉ co ye. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bdziṉ zho lo Jesús, wbig zho lo me, rëb zho: ―Laa Juan pxeeḻ no ziaadnabdiidz no lo luu, dieṉ pe lëële Meṉ ne nacle diidz ga cxeeḻ Dios i nac luu, te naraa guiaad me ye. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lëëtaaque ndal miech ndxie lo me ga, quiayuṉguiac me grë meṉ rzacnë. Nzian zho, teḻ pe guieḻguiidztaa rzac zho, no zho nosacsi meṉdox, no zho roḻd lo, grëse zho ruṉguiac me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dzigo rëbchaa me lo zha ne pxeeḻ Juan ga: ―Grëse miṉe bin to rne naa, grëgaa ncuaaṉe goṉ to quiayuṉ naa, goḻtsie goḻzodiidza lo Juan. Raṉ to gaṉle, grë zha ne roḻd lo, zha ne në ni, zha ne rlan guiedz lepr, zha ne rcuaat, grëse zho laa zho riac, haxta grë meṉgut, rrieeban. Grësew goḻzodiidza lo me, goḻguiab lo me gaṉle blactaa zha ne rquiin gbig lo Dios, laa zho noquiaadiag xtiidz Dios; ");
INSERT INTO zpmNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ni goḻguiab lo me: dichos zha ne tiblique rliladz cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Zeeṉe laa xpëëdscuel Juan zey, dzigo psilo me bzeet me Juan lo grë miech guizhiu ne ndxie ga, rëb me lo zho: ―Zeeṉe dieṉ güey to dan ngan ne bio Juan ga, ¿zha güeynie guic to niaṉ to me? ¿Pe rëb to rlu me zig tib goobgui ne nëzrii nëzrec rey me, ");
INSERT INTO zpmNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","te rëb to ye masaque grë lar niazh ne racw zha non nacw me? Per naṉle to gaṉle, zha ne scataa racwxab, leṉ grë yu ne rzob zha rnabey, ga rio zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nligaa cho güeynie guic to nac me, ¿te rëb to ye tib meṉ ne noteed xtiidz Diosa? ’Gacnaṉ to gaṉle, tib meṉ ne noteed xtiidz Dios goṉ nac me, ni me nac tib zha ne mazdraa nroob lo grë zha ne ziyuṉ dziin co. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Me ga raquiet lo Xtiidz Dios, zaatne znu rnee: “Sxeḻ naa tib zha ne tednerga lo luu, zha co gzhixcuaa nëz ne ted luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ne nligaa lo grëse mgui ne zieded lo guidzliu, gard grieequia tib zha ne mazdraa non lo Juan Bautist; per zha ne goṉ winraa zaatne rnabey Dios, nonraa zha co lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Leṉ dze ne nochoobnis Juan miech ga, ndal zha ne bin zhiwseed me, haxta grë zha ne rtop dimi ne razh lo zha Roma, bieṉ zho nonguieḻa guṉ zho miṉe rnabey Dios, güey zho pchoobnis Juan zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Saṉgue grë maistr ley ni grë zha farisé, pe liaadz zho nion zho miṉe rnabey Dios, ib güeyd zho nchoobnis Juan zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Blozhse sca bnee me, rëbchaa me: ―Nac grë miech rii, ib rieṉd zho pepaa racladz zho. ¿Cho gaṉle ruṉ zigne ruṉ zho? ");
INSERT INTO zpmNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lëë zho ruṉ miṉe ruṉ grë mëëdlas ne rio wguit dib ro nëz. Niicle rooḻ xcompañer win di nguieeḻ, rieed win; niicle rooḻgaa zho di ngan, roond win. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sac goṉ, ziaad Juan, raṉ zho rowd me grë ncuaaṉe nac xquieḻwagw zho, niicle vina ried mew; dzigo rnee zho meṉdox nacnie me. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Blozh ga, ziaad Mgui ne pxeeḻ Dios, raṉ zho row me, rie me, laa zho rneeque lega rowcho me, lega riecho me vin; ib rieṉd me cho rtsieelsa me, haxta grë zha yozh ne rtop dimi ne razh lo zha Roma, haxta grë zha ngoopdoḻ rzënie me. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sca rnee zho, saṉgue zha ne rgaa guieḻbiini ne rdeed Dios, rieṉ zho cho nac zha ne ziaadguṉ xtsiiṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tib dze bredz tib zha farisé Jesús güey me tib wagw lidz zho. Bdziṉ me, bded me bzob me lo mezh. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lad guiedz co no tib wnaa ro nëz, bin me laa Jesús bdziṉ lidz zha farisé co, dzigo bi me tib bot nceit nex, tiblo nceit niazha, briee me zie me nëz lidz zha co. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bdziṉ me ga, wbig me zaatne zob Jesús, psilo me roon me. Zigse roon me, lëëque nis ne riet lo me ga, bdiib me ni Jesús, ni pcuiidz mew con guits guic me. Dzigo ptsieelro mew, blozhse ga blee me nceit co bdëëb mew. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Zeeṉe goṉ zha farisé co sca beeṉ wnaa co, bza zdoo zho rëb zho: “Teḻne niaca miṉe nli meṉ ne ziadteed xtiidz Dios nac meṉ qui, nieṉ me gaṉle tib wnaa ngoopdoḻ i, ndeete me diidz squitaa nguëëbnia zho zhits ni me.” ");
INSERT INTO zpmNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","41","Dzigo bnee Jesús lo zha farisé co yquiaadiag zho chop lan xtiidz me, rëb me: ―Pquiaadiaga gaṉle Simón: Chop mgui name, quia zho guieḻqui lo meṉ ne blediiṉ dimi lo zho. Tib zho zëëb gaay mil pes plat, stib zho zëëb gaay gayoow. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Goṉse meṉ co ni tib zho rdzield zha quizh zho dimi co, dzigo mazd pquia zdoo me zho, beeṉquizhd me zho xquieḻqui zho. Bnë nasca dieṉ, lo grop zha co, ¿cho mazdraa sac zdoo miṉe beeṉ meṉ co? ");
INSERT INTO zpmNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Dzigo pquiab Simón, rëb Simón: ―Par naa, zha ne nroobraa xquieḻqui ga, zha co sacraa zdoo miṉe beeṉ me. ―Scaw goṉ ―rëb Jesús―. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","¡Miṉcopaa nagoṉ squi rac wnaa prob qui! Goṉ gaṉle zeeṉe bzëëb naa lidz luu, bneedzd luu nis niar ni naa; mazd me goṉ bdiib me ni naa, maase niicle con nis ne biin me bdiib mew, ni haxta pcuiidz mew con guits guic me. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Zeeṉe blanso naa per ni tib bzhid bneedzd luu nquiaabdiuzh luu naa, laa me goṉ wlal ne blanso me nu tibaque quiatsieelro me ni naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nac costumbr none nchoob luu nceit guic naa, per beeṉd luuw; mazd mele goṉ biaad biadtëëb me nceit nex rii zhits ni naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Laa me noyuṉ miṉ rii, sacne nlipaa rzac zdoo me beṉ naa me perdon grëtaa doḻdox ne nzëëb me. Zigne rneeque ne ga, teḻ zha ne zhis xtoḻa, zhi rzac zdoo zho zeeṉe laa zho rac perdon. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dzigo bnee Jesús lo wnaa co, rëb Jesús peet tsienied guic me, laa Jesús beeṉle perdon grëse xtoḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Zha ne zobgza Jesús lo mezh ga, zeeṉe goṉ zho sca rëb Jesús psilo zho rnabdiidzlsa zho, rnee zho: ―¿Cho dzigo rzac mgui qui nac me? ¿Zha nacne guiab me laa me beeṉ perdon xtoḻ wnaa qui? ");
INSERT INTO zpmNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Horco biire Jesús bnee me lo wnaa co, rëb me: ―Laa naa psilaa luu lo xtoḻ luu, sac dib zdoo luu bnalo luu naa. Bzë naa, peet tsieniedraa guic luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bded ga, briee Jesús grë xpëëdscuel me güey me grëraa guiedz ne ndxie nëz Galilé ga, zigtaa guiedz nrooba, zigtaa guiedz wina, güey me güeynee me lo miech zha racladz Dios gban zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Ye blalaa meṉ wnaa güeynaḻ zhits zho, teḻ pe ncuaaṉe quianie grë meṉ wnaa co, rdeed zhow ruṉ zho xyudar me; sac rzac zdoo zho beeṉguiac me zho. No zho beeṉguiac me lo guieḻguidz, nogaa zho beṉcxooṉ me meṉdox ne nosacsi zho. Ga güeynaḻ tib wnaa lë Marí Magdal (lëë wnaa co beṉcxooṉ Jesús gadz meṉdox ne nosacsi me), ga güeynaḻ stib meṉ lë Zhuan (lëë tsieel Chuz ga, meṉ ne quianap grë lo xtsiiṉ rey Herod) ni stib meṉ lë Susan. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tib dzew, miech guizhiu ne pcaalsa lo Jesús; nzian guiedz ne briee zho bdziṉ zho lo me. Laa me noseed zho, zeeṉe bzodiidz me tib cuent rii lo zho, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Tib mgui name, briee zho güey zho gon zhobxtil. Zeeṉe laa zho quialaaḻ zhob co liu, now bliaaḻ gax ro nëz, now bliaaḻ lad quie, nogaaw bliaaḻ leṉ yag guiets. Miṉe bliaaḻ ro nëz ga, zha ne bded bzëni zhow, blozh ga güeyaque grë mguiṉ dow maw. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Miṉe bliaaḻ zaatne nac lad quie, blana per znuse bidza sac guieṉd gop ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Miṉe bliaaḻ leṉ yag guiets co, zigne blana blanaque stib dzoon yag guiets, znuse bnitlo yag guietsa. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Saṉgue miṉe bliaaḻ zaatne nac niapse lo liu, blana, brooba, ndzon goca, tib tib zhob ne biab liu ga now goc haxta tib gayoo zhob. Blozhse bzodiidz me cuent co, nguiedz bnee me lo zho rëb me: ―¡Zha ne racladz guieṉ miṉe rne naa, yquiaadiag zhow! ");
INSERT INTO zpmNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Dzigo wbig grë zha ne nac xpëëdscuel me, bnabdiidz zho lo me dieṉ zha nac cuent co. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Rëbchaa me lo zho: ―Teḻ to, Dioszhal rlu lo to gaṉle zha rnabey me, niicle ncuaaṉe mazdraa ngueetsa; saṉgue grëraa zha ne squi gard gbig lo me, niapse con cuent rzodiidz naaw lo zho, parne guieṉ zhow; per niicle scaw, ib rzoobdiagd zhow, ib rioguicd zho zha naca. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Znu goṉ nac cuent co: Zhobxtil co nac Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ro nëz ne sca bliaaḻ zhob co, ga rlu gaṉle zha rzac zha ne rquiaadiag Xtiidz Dios, per znusaque rdziṉ meṉdox rquiil ma zho gliladzd zhow, zeeṉa laad zho lo doḻ. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lad quie ne bliaaḻ spalala ga, ga rlu zha rzac zha ne rley rquiaadiag Xtiidz Dios, rley zho rcaania zhow, per rcaaniad zhow dib zdoo zho. Nli rliladz zhow palal dze, per zeeṉe raṉ zho zha ruṉ miech zho, zha rnee miech lo zho, rsaanga zhow. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nogaa zho nac zig leṉ yag guiets co. Rquiaadiag zho Xtiidz Dios, per laa ne tsoniew guic zho, leḻ rsilo zho grë zhgab ne dieṉ zha gapcheṉ cho, dieṉ zha gdeedguxt xcuerp zho lo guidzliu rii, miṉ co rionie guic zho; pa së zho gban zigne rnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Laa lo liu naaḻ co, ga rlu gaṉle zha rzac zha ne nguudz zdoo. Zeeṉe rquiaadiag zho Xtiidz Dios, dib zdoo zho rcaania zhow, dib zdoo zho rliladz zhow. Grëse ncuaaṉe ruṉ zho, ndzinli rrieequiaw; sac tiblique rac zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Blozh ga, bnee me lo grë miech ne ndxie ga, rëb me lo zho: ―Tsod zha ne yquiaagui tib biini, lozh ga ctoos zho pe cos low, gzolangaa zhow tib zhan lon. Sac biini ne rquia, glaa rzoba par gziiniw leṉ yu, zeeṉa guiab biini lo grëse zha ne sëëb leṉ yu. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Scaque nagoṉ, grë ncuaaṉe rac ngueets, grë ncuaaṉe rnee miech zhliaan, none xoobneṉa. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Wen wen goḻquiaadiag miṉe rne naa, ni goḻtsoxcow. Sac zha ne tsoxcow, zdeedraa Dios guieḻbiini lo zho; saṉgue zha ne tsoxcoda, haxta teḻ palalse guieḻbiini ne rzac zho quianie zho, stiche mew. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Dze co, scaque noseed me miech, zeeṉe bdziṉ xniaa me ni zha bets me ziegaṉ zho me. Per brieelod ndziṉ zho haxta lo me, sac miech guizhiu ne ndxie lo me ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dzigo rëb tib zho lo me: ―Laa xniaa luu goṉ, ni zha bets luu bdziṉ ley ziaadguib zho luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pquiab me rëb me: ―¿Xnia naa ye, bets naa ye? Grëse zha ne goṉ rquiaadiag Xtiidz Dios ni rioxco zho mban zhow, lëë zha co nac xniaa naa, zha co nac bets naa, zha co nac bzian naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tib bdze dze, bzëëbnie Jesús xpëëdscuel me tib leṉ barcw, rëb me lo zho, tedquia zho stib nëz ro nis co. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Laa zho zie lo nis co zeeṉe laa me gootguies. Tibaque zeeṉe psilo briee tib medox, masaque riasoli lo nis co, zootle laa barcw ne no zho ga yguiitsle leṉ nis. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Zeeṉe goṉ zho scataa ntseeb rac lo nis co, lëëlëd güey zho güeycuaan zho me. ―¡Maestro! ―rëb zho―. ¡Blee mcaaḻlo luu gaṉle, laa ne nonitlo lo nis rii niina! Dzigo guche me bnee me lo me co, ni bnee me lo nis co. Zigne bnee me, dzese biac me, dzese bre nis co. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dzigo rëbchaa me lo zho: ―¿Pe nacne rdzieb to? ¿Niacxe rliladzde to Dios dib zdoo to? Ne nligaa rdzieb zho, ni lala rzee zdoo zho, rnabdiidzlsa zho rnee zho: ―¿Bay cho nac me? ¿Zha nacne haxta me, haxta nis ron xtiidz me? ");
INSERT INTO zpmNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bdziṉ zho stib nëz ro nis co, ga nac xtan zha Gadar. Zo zho ga, nëz daṉ squi riaaṉ xtan zha Galilé. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Laa Jesús bietdze leṉ barcw, zeeṉe laa tib mgui ne no nëz co bdziṉ lo me. Mban rlu mgui co nosacsi meṉdox me, niicle xab me nacwdraa me; ib rbëzd me lidz me, niapse grë leṉ xpaa ngutoo rio me. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Zeeṉe goṉ me Jesús, masaque roptsie me bdziṉ me pquiitsgzhib me lo Jesús, zëëb tsi me rnee me: ―¡Psaan naa Jesús! Naṉpaa naa goṉ Xpëëd Dios nroob ne zob gbaa nac luu. ¡Bzhiguieḻ csacsid luu naa! ");
INSERT INTO zpmNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Per meṉdox co sca rnee, sac hor co laa Jesús bnabeyle ma csaan ma me. Ziele dze sca nosacsi ma me, ntseeb rac me, niicle rzoob zho caden ni me, rzoob zho caden nia me, parne paat tsied me, znuse rchug mew; dzigo rienie meṉdox co me rquianzë me grë dan ngan, zaatne choot miech guieṉd. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Dzigo bnabdiidz Jesús lo ma dieṉ cho lë ma. Pquiab ma rëb ma: ―Legion lë no. Sca rëb ma sac nzian nac ma no ma zdoo mgui co. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ni bnab ma lo Jesús gzonëzd me ma lo ncowdoo ne noraa ma ne nacgrë ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Gaxaque ga ndxie tib dzoon nguts notop lag, bnab ma gdeed me diidzbey lose grë nguts co gdziṉ ma. Dzigo bdeed me diidz. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Horco laa grë meṉdox co psaan mgui co, güeysëëb ma zdoo grë nguts co. Psilo grë nguts co rquiaa ma corr, güeypix ma tib ro yeedox ne quia ro nis co, bliaaḻ ma haxta lo nis; grëse ma gut. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Grë zha ne quianap nguts co, bzhooṉ zho, rias zho güeyzodiidz zhow lad guiedz, ni grëraa yu ne zob gax ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nacne briee grë miech co ziewi zho. Zeeṉe bdziṉ zho, per nli bdzieb zho goṉ zha laa meṉ co zob gax lo Jesús, laa me nacwxable, rlu niinile nac guic me. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Psilo grë zha ne goṉ zha biac me rzodiidz zhow lo grë zha ne bdziṉ ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mazdraa bdzieb grë miech co bin zhow, dzigo mazd bnab zho lo Jesús siguieḻ me gbi me xtan zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Zeeṉe laa Jesús zie sëëb me leṉ barcw par gbi me ga, dzigo wbig mgui co rnab me lo Jesús siguieḻ Jesús tsienaḻ me zhits Jesús; per bzhiguieḻd Jesús nienaḻ me, rëb Jesús lo me: ");
INSERT INTO zpmNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―¡Biaaṉ! Güey, güeyzodiidz lo grë meṉlidz luu gaṉle zha nactaa milagr ne beeṉ Dios beeṉguiac me luu. Dzigo wbire meṉ co. Güey me lad guiedz, grëse lo miech güeyzodiidz me zha nactaa guieḻnzaac ne beeṉ Jesús ga, beeṉguiac Jesús me. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Zeeṉe laa Jesús biire bdziṉ stib nëz ro nis co, miech guizhiu ne quiambëz me ga, rley zho goṉ zho laa me bdziṉ. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Loxaque bdziṉ me, laa tib meṉ ne rnabey yadoo lë Jair wbigle pquiitsgzhib lo me. Rnab Jair siguieḻ me tsienaḻ me lidz Jair tsieguṉguiac me tib xpëdwnaa win Jair. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nzhoo rac mëëd co, tib mëëd tsiipchop iza, ni lëëse mëëd ga lo me. Dzigo laa Jesús zie nëz lidz meṉ co. Miech guizhiu ne zienaḻ zhits me, haxta rtaagw zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lad grë miech co zienaḻ tib wnaa rzacnë, gocle tsiipchop iz rlan me tib guieḻguidz, rzac me zigne rzac grë meṉ wnaa gzob mëë; tibaque rlan mew ib rbëzda. Grële ncuaaṉe rap me bloozh me lo grë meṉ ne ruṉ rmed, per ni tib zho ruṉguiacd me. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Laa me no lad co, tibaque wbig gax me nëz zhits Jesús, bzheṉ me ni lar ne mbix Jesús; hor cogazha laa me biac. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Bieṉ Jesús sca bzheṉ wnaa co lad xab me, dzigo rëbchaa me: ―¿Cho ga bzheṉ lad xab naa? Grëse zho rnee led zhada. Dzigo rëbchaa Pedr lo me: ―Maestro, wi gaṉle zha ndaagwtaa ziaad luu lad grë miech rii, haxta rcheep zho luu, ¿zha naṉ luu choot xeṉd lad xab luu? ");
INSERT INTO zpmNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","―Per no cho bzheṉ lad xab naa ―rnee me―, sac bieṉpaa naa beeṉguiac naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Zeeṉe goṉ wnaa co bieṉ Jesús sca bzheṉ me lad xab me, rdzieb me laa me wbig pquiitsgzhib me lo Jesús. Squi ndxie grë miech co, bzodiidz me zha nacne sca beeṉ me, ni zha zigne bzheṉ me lad xab Jesús laa me biac. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dzigo rëbchaa Jesús lo me: ―Xin, laa luu biac sacne dib zdoo luu bnalo luu naa. Bzë na, peet tsieniedraa guic luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Laa Jesús bii quianeeque lo wnaa co, zeeṉe laa tib zha ne nac mandad ziaad nëz lidz Jair bdziṉ, rëb zho lo Jair: ―Csodziindraa luu lo meṉ qui, laa xpëëd luu gutle. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Zeeṉe goṉ Jesús sca rëb zha co, rëbchaa me lo Jair: ―Peet tsienied guic luu. Dib zdoo luu bnalo Dios, zeeṉa peet gacd xpëëd luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bdziṉ zho lidz Jair, psaandraa Jesús naḻ grë miech co zhits me ndziṉ zho zaatne nix mëëd co. Loxaque Pedr, Jacob, ni Juan, pxoz win ni xniaa win bzëëbnie me leṉ yu ne nix win. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Grë miech ne ndxie ga, roon zho no zho xquieḻnë win; dzigo rëbchaa Jesús lo zho: ―Goonde to; sac goṉ nixguiesse mëëdwin rii, gute win. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Psilo zho leḻ rzhidznie zho me, sac naṉpaa zho gutle win. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dzigo wbig me, bzheṉ me nia win, nguiedz bnee me lo win, rëb me: ―¡Guche i na, ndzoop yeeṉ! ");
INSERT INTO zpmNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Zigne sca bnee me, laa mëëd co brieeban, laa win guche ga; dzigo bnabey me bguiaaṉ zho win. ");
INSERT INTO zpmNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Zigtaa pxoz wina, zigtaa xniaa wina, per nli rley me. Dzigo pso Jesús diidz lo me, choot lo gzodiidzd me zha brieeban win. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Tib dze bredz Jesús gza tsiipchop xpëëdscuel me, pxeeḻ me zho tsienee zho lo miech gacnaṉ zho zha racladz Dios gban zho; bdeed me poder lo zho guṉcxooṉ zho grë meṉdox ne nosacsi miech, ni guṉguiac zho grë meṉ rzacnë. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","―Goḻtsie ―rëb me lo zho―. Per ib güeyde to ncuaaṉe yquiin to nëz. Zig nac dimi, zig nac ncuaaṉe gow to, pe bziuud, pe baxtongaa, güeyde tow; xab tow, miṉe nacwse to miṉcose goḻtsienie. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Guiedz ne gdziṉ to, zha ne gneedz zaatne cuëz to, lidz zha co goḻcuëz, haxta gdziṉ dze ne gbi to guiedz co. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Per teḻne gdziṉ to tib guiedz, nëd miech yquiaadiag zho miṉe zienee to, dzigo goḻlit grë yudie co ni to, goḻrieegazh ga, zeeṉa guieṉ zho gaṉle doḻ ga beeṉ zho lo Dios, nëd zho ycaania zho xtiidz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dzigo laa zho briee, laa zho zie. Grëse guiedz ne ndxie dib gax ga, güey zho güeynee zho Xtiidz Dios lo miech, ni beeṉguiac zho grë meṉ rzacnë. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bin rey Herod rzeet zho Jesús, sac teḻ pa lotaaw zëëb diidz grëtaa milagr ne ruṉ me. Grë miech co, no zho rzac Juan Bautist ga brieeban, lëë me ga nac Jesús; ");
INSERT INTO zpmNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","nogaa zho rnee bod Líw, meṉ ne biadteed xtiidz Dios padzeela, me ziaad stib; zzhisgaa zho rnee no cho stib meṉ biadteed xtiidz Dios padzeelaw, sinque brieeban me gane ziaad me stib. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Zeeṉe ron Herod rnee grë miech co lëë Juan ga, rio me zhgab, rnee me: ―¿Bay cho nac meṉ co? Per gacda Juan; naazhal name bnabey pchug zho yaṉ Juan. Racladz Herod tebaa zha gaṉ me Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Goc bla dzew, laa grë zha ne pxeeḻ Jesús ga wbire bdziṉ lo me. Blozhse bzodiidz zho lo me grëse teḻ zha güey zho, dzigo güeynie me zho tib lugar riaaṉ gax guiedz Betsaid. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Zeeṉe bin grë miech co laa me briee, dzigo brieenaḻ zho me, bdziṉ zho lo me ga. Zeeṉe goṉ me zho, rley me pcaania me zho, bnee me lo zho zha racladz Dios gban zho, ni beeṉguiac me grë zha ne rzacnë. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Laa dze rdzelew, wbig gza tsiipchop xpëëdscuel me rëb zho lo me, mazd gnee me lo grë miech co gbi zho ga; zeeṉa guiob tsie zho grë guiedz las, grë yu ne riaaṉ gax ga, yguib zho dieṉ pa cuëz zho, yguib zho dieṉ pe gow zho; sac choot miech nod ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dzigo rëbchaa me lo zho: ―To goḻdeed ncuaaṉe gow zho. Pquiab zho rëb zho: ―Gaayaque guietxtil ni chop meḻ ziaadnie no nu, ¡pe rnase ncuaaṉ co lo grëtaa miech qui! Niicle niaca miṉe gziuu ncuaaṉe gow zho, pe zhidaa dimi yquiin, ¿pa guioxi now? ");
INSERT INTO zpmNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","15","Nligaa miech tafa, zig gaay mil rgaa loxaque zha bguise. Dzigo bnabey me zho güey zho, güeynee zho lo grë miech co sob zho, cue zho groḻ gayooga, groḻ gayooga zho tib lugar. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Laa grë miech co bzob, dzigo bzheṉ Jesús gza gaay guietxtil co ni grop meḻ co, blis lo me nëz gbaa, bdeed me xquizh lo Dios. Blozhse ga, beeṉgroḻ me gza guietxtil co, meḻ co ne, dzigo zigse rdeed mew lo xpëëdscuel me, scase scase rguiiz zhow lo grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Grëse zho dow haxta zaatne bieltaa zdoo zho; ni zeeṉe blozh dow zho, biodzë tsiipchop chicuid bio grë miṉe biaaṉ. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tib dze biche Jesús lo miech palal, güey me tib zaatne güeyzodiidznie me Dios; loxaque xpëëdscuelse me güeynaḻ zhits me. Ga bnabdiidz me lo zho rëb me: ―¿Cho dieṉ ron to rnee miech nac naa? ");
INSERT INTO zpmNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pquiab zho rëb zho: ―No zho rnee Juan Bautista, nogaa zho rnee Líw (meṉ ne biadteed Xtiidz Dios padzeela); nogaa groḻ zho rnee no cho stib meṉ ne biadteed Xtiidz Dios padzeelaw, sinque brieeban me gane ziaad me stib. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","―¿To waa? ―rëb me lo zho―. ¿Cho rzac to nac naa? Horco pquiab Pedr, rëb Pedr lo me: ―¡Luu nac Meṉ ne zëëble diidz ga cxeeḻ Dios! ");
INSERT INTO zpmNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dzigo pso me diidz lo zho choot lo gneed zhow. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tib vuelt bzeet Jesús lo grë xpëëdscuel me zha csacsi miech me. Rëb me, nroob grë ncuaaṉe cteed zho me; grë zha non lo meṉguiedz, grë pxoz rnabey, grë zha ne rseed miech ley, ible stsidiḻ zho me, ni haxta zut zho me; per zeeṉe gac tsoṉ ngbidz gut me laa me grieeban. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ni rëb me lo grë miech ne ndxie lo me ga: ―Zha ne racladz sëëb xnëz naa, none cueeladz zho zho, none lëb zho gzataa dze guiaadnaḻ zho miṉe rnabey naa, niicle teḻ miṉ co yquiaaqui csacsi miech zho. Nodne yquia zdoo zho xquieḻmban zho, ");
INSERT INTO zpmNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","sac zha ne yquia zdoo xquieḻmban, leḻ znu nitlo zho; saṉgue zha ne sca cueeladz xquieḻmban porne no zho xnëz naa, ib zgaa zho tib guieḻmban ne gdziṉd dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Zha ne zienie guic loxaque gapcheṉ, ¿pa dieṉ yquiina lo zho, teḻ por lëëw rsacsi zho zho, teḻ lëëw yquiaaqui guey zho gabiḻ? ");
INSERT INTO zpmNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Naa ne nac naa Mgui ne pxeeḻ Dios, zha ne ctoladz guiab zho laa zho no xnëz naa, ctoladzniegaa zho xtidz naa; scaque naa stoladznie naa zho gaḻ dze ne laa naa guiaḻ stib. Dze ne guiaḻnie naa grë xanjl Pxoz naa, guiaḻlu naa guieḻndzon ne rap me. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Blozhse sca bnee me, rëbchaa me lo grë miech co: ―Ni gni naa lo to gaṉle, nzian grë zha ne ndxie nu niina, ib tedsod bii zaṉ zho zeeṉe laa Dios glu zha rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Goca maase xon ngbidz, güey Jesús tib guic gui gza me Pedr, Jacob ni Juan; laa me zie ga ziezodiidznie me Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Laa me nozodiidznie Dios, zeeṉe laa me bdzëëlo. Masaque biinidoo ne rriee lo me, xab mew, nquitsbie rnaw, haxta rquiabniw. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Tibaque brieequia Lí grop Moisés bdziṉ lo me ga, psilo zho nozodiidznie zho me grë guieḻnë ne cteed miech me Jerusalén, zeeṉe laa me gbi lo guidzliu. Masaque biinidoo ne riab, ncuaaṉe gzee zdoo new. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Laa zha ne zienaḻ zhits me, rcow zho mcaaḻ zob zho ga; per zeeṉe biab biini nroob co, hor co bzhial lo zho goṉ zho zha rlu me gza me Lí ni Moisés. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Laa grop meṉ co ziebiche lo Jesús, zeeṉe rëb Pedr lo me: ―Maestro, ¡wena goṉ tebaa gbiaaz ne nu! Na maase gzaa no tsoṉ yu yag xiid win, tiba cuëz luu, tiba cuëz Moisés, stiba cuëz Lí. Per niicle Pedr rieṉdaque dieṉ pe nacne sca rnee Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Laa Pedr bii quianeeque, zeeṉe bre tib xcow zaatne zo zho ga; per nli bdzieb zho goṉ zho laa zho biaaṉ leṉ xcow co. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dzigo bin zho zëëb tib tsi meṉ co lo xcow co, rnee me: ―Lëë Xpëëd naa i goṉ, rleynie naa me. Goḻgon miṉe rnee me. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Zeeṉe blozh bin zho tsi meṉ co, goṉ zho loxaque Jesússe zo ga. Grëse miṉe goṉ zho ga, ib choot lo bneed zhow leṉ dze co. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Biini liu co, laa Jesús wbi guic gui co gza me zha ne güeynie me ga. Miech guizhiu ne güeydzieelo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lad grë miech co briee tib mgui, wbig me lo Jesús rëb me: ―Maestro, bzhiguieḻ bui gaṉle zha rac xpëëd naa. Tibaque mëëdbgui rii nac mëëd lo naa, ");
INSERT INTO zpmNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ni na laa meṉdox nosacsi win. Zeeṉe rdziṉ ma rcoptsiedan ma win, rroṉ ma win liu, ga nix win ruṉcxidz ma win, ni masaque rdzib mtsiiṉ ro win; nen rsaan ma win. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Blansonie naa win nu, bnab naa lo xpëëdscuel luu guṉcxooṉ zho meṉdox co, per brieelod zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dzigo rëbchaa Jesús: ―¡Pe nac squitaa miech ntseeb nac to, ib nëde to gnalo to Dios! ¿Pa lal dze ne so naa gne naa lo to? ¡Ncuaaṉe cxecwdraa naa lo to squitaa nac to! Dënie xpëëd luu nu ―rëb me lo meṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Zeeṉe laa mëëd co ziegax lo Jesús, hor co broṉ meṉdox co win liu, nix win ga masaque rzhidz win. Dzigo goctox Jesús lo ma, beṉcxooṉ me ma. Horcogazh biac mëëd co, laa me bdeed win lo pxoz win. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Grë miech ne ndxie ga, per nli rzee zdoo zho goṉ zho scataa nroob poder ne rap Dios. Grëse miech ne raṉ grëtaa milagr ne ruṉ Jesús, rzee zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Biire Jesús bzeet me lo xpëëdscuel me zha guṉ miech me, rëb me: ―Wen wen goḻquiaadiag miṉe gni naa lo to nu gaṉle. Naa goṉ ne nac naa Mgui ne pxeeḻ Dios, ible zielo zho naa ladznia miech. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per ib rieṉd zho zha nacne sca rnee me, sac gard gdeed Dios diidzbey hor co guieṉ zho zha naca; niicle par gnabdiidzgaa zho, rdzieb zho gnabdiidz zhow lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Horco psilo zho noneelsa zho dieṉ cho tib zho gac zha non. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bieṉ Jesús sca no zho, dzigo bnee me lo zho, bredz me tib mëëdbgui win, ");
INSERT INTO zpmNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","rëb me: ―Grë zha ne no xnëz naa, zha ne guṉcas tib mëëdwin zig mëëd rii, gleynie zho win, rrieequia naa ga rleynie zho. Ni zha ne gleynie naa, rrieequia meṉ ne pxeeḻle naa ga rleynie zho. Teḻne racladz to gacnaṉ to dieṉ cho nac zha non, gacnaṉ to gaṉle, zha ne tsoxco gac zig tib nguṉdziin lo samiech, zha co nac zha non. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Blozh ga, rëbchaa Juan lo me: ―Maestro, bdzioṉ no tib zha co goṉ bzeet zho lë luu zeeṉe beṉcxooṉ zho meṉdox, nacne nli blisqui now lo zho, sac led yed zho nacgrë ne. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dzigo pquiab me, rëb me: ―¡Guṉscade to! Sac goṉ zha ne racnie ne, grieelod lëëque zha glëënie ne. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Leṉ dze ne ziaadyob gbi Jesús lo guidzliu rii, leṉ dze co bio me nëz laa me zie nëz Jerusalén. Tiblique bio guic me, ib pquiad zdoo me, laa me zie. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Zeeṉe bdziṉ me xtan Samar, pxeeḻ me bla zho bdedner zie zho tib guiedz win ne ndxie nëz co, par dieṉ pa lo gdeed miech co cuëz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bdziṉ zho guiedz co, choot bzhiguieḻd ndeed zaatne mbëz me; sac bieṉ zho nëz Jerusalén tsie me. Nac zha Samar, rlëënie zho zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Zeeṉe bin Jacoba grop Jacob Juan, blëë guic zho, rëbchaa zho lo me: ―Maestro, ¡mazd tibaque gotsaa gnab ne gliaaḻ gui lad grë miech rii, zeeṉa nitlogazh zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Biecwaque me, goctox me lo zho rëb me: ―Rieṉde to lëë zhapaa nac meṉ ne nacnie to. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Goḻguieṉ gaṉle, naa ne nac naa Mgui ne pxeeḻ Dios, ziaḻd naa par gnitlo naa miech, sinque laa naa ziaḻ csilaa naa zho lo doḻ. Ga briee zho güey zho stib guiedz. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nëz zie zho, zeeṉe wbig tib mgui co rëb me lo Jesús, laa me racladz tsienaḻ me zhits Jesús, teḻ pa lotaa nac zaatne tsie Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Dzigo pquiab Jesús rëb Jesús lo me: ―Gocnaṉa gaṉle, naa ne nac naa Mgui ne pxeeḻ Dios, peet rapd naa nu, mazd zig nac grë mëz, grë mguiṉ, rap ma zhibliee ma, rap ma zhiptsieez ma; per naa per ni zaatne gaguies naa quianied naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Laa zha ne bredz me tsienaḻ zhits me, pquiab zho rëb zho: ―Sënaḻ naa zhits luu, per bzhiguieḻ bneedz diidzbey cuëz naa, gaṉgazh naa tsoliu pxoz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Rëbchaa me lo zho: ―Nzian grë zha gut no, psaan tsow tsie sameṉgut zho tsiequeets zho. Saṉgue luu zhits naa dënaḻ, zeeṉa tsie luu tsienee luu lo miech, gacnaṉ zho zha racladz Dios gban zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pquiab stib zho rëb lo me: ―Maase sënaḻ naa zhits luu, per bneedz diidz ganiegazh naa diidz lo grë meṉlidz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dzigo rëbchaa me: ―Zha ne xeṉ nia rad ni csilo zho gwi zho nëz zhits zho, niacxe zrieelo ygan zho ngon. Scaque zha ne sëëb xnëz Dios, grieelod sëëb zho teḻne mazdraa rleynie zho grë ncuaaṉ lo guidzliu rii. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tib dze, ble Jesús stsoṉgaḻtsii zha ne rquiaadiagle zhiwseed me, bnabey me tedner zho lo me tsie zho grë guiedz ne no ted me, pxeeḻ me zho chopga chopga zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","―Goḻnab lo Dios ―rëb me―, cxeeḻraa me zha ne guṉ xtsiiṉ me. Sac ne nligaa ndaldoo miech ne quiambëz yquiaadiag Xtiidz me, zha ne gneelew lo zho rgaad. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Goḻtsie sca, per nsin nsin goḻso. Goḻguieṉ gaṉle rrieequia nac to zig cho mëcwxiil yeeṉ, ni laa naa rxeḻ to zaatne no grë coyot dox. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Peet güeyde to, güeyde to dimi, güeyde to ncuaaṉe gow to, lab tow, miṉe quiase ni to miṉcose goḻtsienie. ’Miech ne yquiaabdiuzh to nëz, sode to dieeṉ zharaa yquiaabdiuzh to zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Zeeṉe yguib to zaatne cuëz to, yu ne gdziṉtaa to, goḻnab guṉlay Dios grë zha ne no yu co. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Teḻne squiaadiag zho miṉe rnee to, zuṉlay me zho; teḻne nëdgaa zho yquiaadiag zhow, dzigo toque guṉlay me. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Zha ne gneedz zaatne cuëz to, lidzse zha co goḻcuëz, tsiede to stib yu stib yu; guieḻwagw ne gneedz zho lo to, ctoladzde to goḻgowa; sac goṉ zha ne ruṉ dziin, ib none ycaa zho miṉe non xtsiiṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’Guiedz ne yquiaadiag miech miṉe zienee to, zaacse goḻgac lo zho, teḻ pe guieḻwagw ne gneedz zho, goḻquiina; ");
INSERT INTO zpmNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","goḻguṉguiac grë meṉ rzacnë ne no ga. Goḻguiab lo zho, laa dze ne nolu Dios zha sëëb miech xnëz me, laa dze co bdziṉle. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Saṉgue guiedz ne siguieḻd miech yquiaadiag zho miṉe zienee to, goḻriee grë ro xnëz zho, ");
INSERT INTO zpmNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","gaṉlo zho glit to grë yudie co ni to, zeeṉa guieṉ zho gaṉle nëz ne nitlo zho ga zie zho. Goḻguiab lo zho, zha bguiba, sac binpaa zho zha grieelo sëëb zho xnëz Dios ni nëd zho gon zho diidz. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Gacnaṉ zho gaṉle, gaḻ dze ne guṉ Dios xquieḻwxtis me, lëëtaa gac guieḻnë ne tsieguiaḻ zha Sodom, mazdraa nac guieḻnë ne tsieguiaḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Scadaa nac zha Corazín ni zha Betsaid. ¡Probsaxe zho, sac goṉ goṉpaa zho grë milagr ne ruṉ Dios, per ib psaand zho xquieḻntseeb zho! Teḻ niaca miṉe ngaa grë meṉ Tiro, grë meṉ Sidón, niaṉ grë milagr ne goṉ zho, ib ndedsod mban niac grë zha co nio zho guieḻnë, zëëb nsaan zho xquieḻntseeb zho mbig zho lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gacnaṉ zho gaṉle, gaḻ dze ne guṉ Dios guieḻwxtis, lëëtaa caxtigw ne ygaa zha Tiro ni zha Sidón, mazdraa miṉe ygaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Scaque zha Capernaum, masaque rzac zho niina zha nziuuraa lo Dios, per gacnaṉ zho gaṉle haxta guiet leṉ gabiḻ ga guey zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Blozhse sca bnee me, rëbchaa me lo zho: ―Grëse zha ne yquiaadiag miṉe gnee to, rrieequia naa ga rcaania zho. Zha ne nëdgaa ycaania to, rrieequia naa ga nëd zho ycaania zho; ni zha ne nëd ycaania naa, rrieequia meṉ ne pxeeḻ naa ga nëd zho ycaania zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Zeeṉe laa gza tsoṉgaḻtsii zha co wbire, rley zho bdziṉ zho lo Jesús. Rëb zho haxta grë meṉdox bdzieb ma zho, zeeṉe bzeet zho lë me. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dzigo pquiab me rëb me lo zho: ―Haxta ma ne rnabey lo ma, goṉpaa naa goṉ briṉgaa ma, biab ma zig riabse tib belye. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Laa naa bneedz poder qui lo to, parne gdeete to diidz guṉ ma miṉe racladz ma; grë meeḻdox, grë meegu ntseeb, niicle gzoobni to ma, peet gacde to. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nli laa to ruṉcxooṉ meṉdox niina, per gleyde to por miṉ co, sinque mazd goḻley porne laa lë to zhooble lo Dios, laa to ngable lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Horco biaad tib guieḻbley nroob zdoo Jesús, bnee me lo Dios, rëb me: ―Papá, luu nac meṉ ne rnabey gbaa, luu nac meṉ ne rnabey guidzliu, rnedz naa xquizh lo luu, sac grë miṉe noyuṉ luu nu niina, bdeete luu diidz niacnaṉ grë zha raca, sinque laaw blu luu lo grë zha ne nac zig grë mëëdlas. Sca quiayuṉ luu, sac ib scale racladz luu gaca. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Blozh ga rëb me lo grë miech ne ndxie lo me ga: ―Grëse ncuaaṉe raṉ to quiayuṉ naa, Dios meṉ ne nac Pxoz naa, me bneedz poder rii lo naa; sac ib laa me bzo naa, naa guṉa. Xpëëd me nac naa, wen wen ruṉbey me naa, scagaa naa wen wen ruṉbey naa me. Choot ruṉbeyd me zigne ruṉbey naa me, per zha ne gded naa diidz guṉbey me, zuṉbey zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dzigo rëbchaa me lo xpëëdscuel me: ―Dichos to bgaa to noyaṉ to grë miṉ rii. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sac goṉ blactaa zha ne biadteed xtiidz Dios padzeela, haxta grë zha ne bnabey leṉ dze co, bzoobladz zho niaṉ zho grë ncuaaṉe noyaṉ to, bzoobladz zho nquiaadiag zho grë ncuaaṉe noquiaadiag to. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tib dze wbig tib zha ne nac maistr ley lo Jesús, bnabdiidz zho lo me, rëb zho: ―Maestro, bnë lo naa dieṉ, ¿pe nac miṉe guṉ naa parne grieelo ygaa naa guieḻmban ndzon ne gdziṉd dze lozh? ");
INSERT INTO zpmNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Pquiab Jesús rëb me: ―¿Zha dieṉ zhobnee lo ley? ¿Pe rnabeya? ");
INSERT INTO zpmNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Rëbchaa maistr ley co: ―Znu rneew: “Dib zdoo luu, dib nacse luu, dib guieḻbiini ne no guic luu, dipse xfuers luu, bleynie Dios; ni bleynie samiech luu, zigne rleynie luu luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","―¡Miṉ qui nagoṉ bioxco guṉ luu ―rëb Jesús―, zeeṉa ygaa luu guieḻmban ndzon ne gdziṉd dze lozh ga! ");
INSERT INTO zpmNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per par glud ne noxcod me guṉ me miṉe rnabey ley, dzigo pquiaalo me rëb me lo Jesús: ―¿Chopaa dzigo nac samiech naa, zha ne no gleynie naa? ");
INSERT INTO zpmNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dzigo bzodiidz Jesús tib cuent lo me, rëb Jesús: ―Tib meṉ wladz name briee me Jerusalén zie me guiedz Jericó. Nëz zie me brieequia ngbaan, bdiṉ ngbaan me, mer niut ngbaan me; grëse ncuaaṉe ney me, haxta xab me blan ngbaan. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Laa me nix ga, zeeṉe laa tib pxoz bded. Zigne goṉ pxoz me, biecwga pxoz bded pxoz tib lad. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wdzeepaaw, zeeṉe laa tib zha ne ruṉaque dziin leṉ yadoo ziaad ga; scaque zigne goṉ zho me, tib tib bded zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sca nix me ga, zeeṉe laa tib zha Samar bdziṉ. Zeeṉe goṉ zho me, wbig gax zho lo me; pquia zdoo zho me goṉ zho zha rna me. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Gagazh beeṉ zho me rmed, blee zho vin bdiib zho lo grë rid ne ney me, bdëëb zho nceita, pxidoo zhow. Blozhse ga, blis zho me bzoob zho me lad xcuay zho laa zho zienie me, haxta bdziṉnie zho me tib yu ne rbëz miech ne zo nëz; ga blëznie zho me, pquianap zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","’Biini liu, zeeṉe laa zho briee ga, blee zho palal dimi, lal ne non chop xtse zha ne rie dziin, bdeed zhow lo bizhuan yu co, parne yquiaanap me meṉ co, rëb zho: “Peet tsienied guic luu, teḻne nroobraa guṉ luu gaxt, na zeeṉe gbire naa dzigo quizh naaw.” ");
INSERT INTO zpmNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Blozhse bzodiidz me cuent co, rëbchaa me lo maistr ley co: ―Lo gza tsoṉ zha ne nadieṉ bded zaatne nix meṉ co, ¿cho tib zho bieṉ samiech zho ga nac me? ");
INSERT INTO zpmNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pquiab maistr ley co rëb me: ―Zha ne bioṉ bded gaw, sac zha co pquia zdoo me. Dzigo rëbchaa Jesús lo me: ―Sca nagoṉ none guṉ luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Laa Jesús no nëz gza xpëëdscuel me. Bdziṉ me tib guiedz win, ga no tib wnaa lë Mart, dzigo meṉ co bdeed zaatne blëz zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","40","Bdziṉ zho lidz Mart, lëëlëd bzëëb Mart ro tie. Zhixco ro tie no Mart, laa tib beḻ Mart lë Marí zob noquiaadiag grë zhiwseed Jesús. Goṉ Mart rgaadraa nia Mart, dzigo wbig Mart rëb Mart lo Jesús: ―Bzhiguieḻ bnee lo beḻ naa guiaad me guṉ me xyudar naa. Bui gaṉle tipse naa psaṉ me ro tie. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pquiab Jesús rëb Jesús lo me: ―Aque luuw nli Mart, squitaa noxco luu dieṉ zha gac xtsiiṉ ro tie luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","No tib ncuaaṉe mazdraa none tsoxco luu, ni lëë miṉ co nu goṉ noyuṉ Marí; gane grieelod ycaa naa miṉe quiayuṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tib vuelt, loxaque blozh bzodiidznie Jesús Dios, wbig tib xpëëdscuel me rëb lo me: ―Maestro, bzhiguieḻ blu lo no dieṉ zha gzodiidznie no Dios, zigne beeṉ Juan Bautist pseed me xpëëdscuel me zha gzodiidznie zho Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dzigo rëbchaa Jesús: ―Zeeṉe gzodiidznie to Dios, goḻguiab: Dios, luu nac Pxoz no, zob luu gbaa; luuse nac meṉ ne mazdraa ndzon. Luu nac meṉ ne gnabey no, miṉe gnabeytaa luu, zigne raca gbaa, scaque none gaca lo guidzliu nu. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Beeṉ guieḻnzaac bneedz ncuaaṉe dioow no nadze. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bzhiguieḻ beeṉ no perdon grëse doḻ ne ziodziuuṉ no lo luu, zigne rdziuuṉ no samiech no perdon grë falt ne ruṉ zho lo no. Gdeete luu diidz yquiil meṉdox no, beeṉ guieḻnzaac bla no lo ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","’Sca nagoṉ gnee to ―rëb Jesús―. Ncuaaṉe gnab to lo me zneedz mew. Samiechse to name, gzoob ne wxiṉa, lega nacle glanso tib zha ne ndzieeldiidz to ni guieṉd pe gdeed to gow zho. Dzigo tsie to lidz stib zha ne ndzieeldiidz to guiab to lo zho: “Bzhiguieḻ beeṉxtad tsoṉaque xcuuṉ luu lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Lega nacle blanso tib zha ne ruṉbey naa, na guieṉd pe gded naa yquiin zho.” ");
INSERT INTO zpmNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Segur znë zho: “Guṉneete luu naa nu, dziitsle nioog ro lidz naa, nataa nixguies grë xpëëd naa; grieelod gache naa gnedz naa ncuaaṉe racladz luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Per teḻne sonaad to ga, gaṉse zho tibaque quianee to, gnid naa zho tsieched zho gneedz zho ncuaaṉe racladz to. Per gneedzd zhow porne ndzieeldiidz to zho, sinque laa zho gneedza porne goṉ zho tibaque quianab tow. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Scaque nagoṉ none guṉ to, zeeṉe pe gnab to lo Dios. Ncuaaṉe rquiin to, goḻnaba lo me, scagaa me zneedz mew. Goḻguib teḻ pe racladz to, me nac meṉ ne gacnie to gdziel tow. Goḻcuedzlë me, scagaa me scaania me to. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sac grëse zha ne rbig lo me rnab zho ncuaaṉe rquiin zho, rdeed mew. Zha ne rguib ncuaaṉe racladz zho, racnie me zho rdziel zhow. Zha ne rbedzlë me, rcaania me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Goḻguieṉ gaṉle, zig nac to, zeeṉe rnab xpëëd to tib meḻ gow win, ¿niacxe ziazh to co to tib meeḻ nia win? ");
INSERT INTO zpmNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Zeeṉe rnabgaa win tib dzit, ¿niacxe zgo to tib meegu nia win? ");
INSERT INTO zpmNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Led rioxco to lëë niapse ncuaaṉe wen rdeed to lo xpëëd to, niicle ne miech ntseeb nac to. Teḻne sca rioxco to xpëëd to, peleḻ Pxoz to dzigo, meṉ ne zob gbaa, tsoxcod me to. Ib tedsod grëse zha ne gnab lo me gdeed me ncuaaṉe rquiin zho, zdeed mew; haxta zha ne gnab cxeeḻ me Espíritu Sant gacnie zho, zuṉ me miṉe gnab zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tib vuelt beṉcxooṉ Jesús meṉdox ne nosacsi tib mgui co. Ib gacd gnee mgui, sac psaṉ ngop ma mgui. Dzigo zigne beṉcxooṉ Jesús ma, laa mgui psilo bnee. Grë miech ne ndxie ga, bzee zdoo zho goṉ zhow. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nogaa zho rnee, Beelzebú ma ne rnabey lo meṉdox, ma co nacnie me gane rrieelo ruṉcxooṉ me meṉdox. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Brieequia spalal zho, rnab zho lo me guṉ me pe stib milagr, parne gliladz zho nli Dios pxeeḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bieṉ Jesús zha rza guic zha ne noneenë me ga, dzigo rëbchaa me lo zho: ―¡Ncuaaṉe gacd goṉ rnee to! Teḻ tib guiedz nadieṉ, csilo miech, lëëque zha tiḻnie meṉladz zho, ¿niacxe nitlod guiedz co? Tib diigaa miecha, teḻ lëëque zha tiḻnie meṉlidz zho, led znuse lëë nitlo dii co. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Scaque meṉdox nagoṉ, teḻne lëëque lëë ma guṉcxooṉ sameṉdox ma, ¡pe nale na bnitlo ma! Laa naa rne miṉ rii lo to, porne rnee to ma ne rnabey lo meṉdox nacnie naa, gane rrieelo ruṉcxooṉ naa ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nana teḻne sca rzac to, ¿zha ne nacgrë to dzigo, cho nacnie zho ne ye zho ruṉcxooṉ ma? Gase nagaṉle rlu doḻdox i quiayuṉ to squi rnee to. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Saṉgue teḻ naa, Dios nacnie naa ruṉcxooṉ naa meṉdox, ni ga rlu gaṉle laa Dios pxeeḻle meṉ ne gnabey lo to. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’¡Masaque nac meṉdox zig tib zha ne no xfuers! Tib zha ne no xfuers, teḻ tibaque ney zho xquiib zho, ¿cho dieṉ lega sëëb lidz zho gla ncuaaṉe quianie zho? ");
INSERT INTO zpmNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per zeeṉe rrieequia stib zha ne mazdraa no xfuers, zha cole rtiche zha co, ruṉcxooṉ zho zho, riaaṉnie zho grë ncuaaṉe gopcheṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Goḻgacnaṉ sca gaṉle, zha ne rlëë lo naa, ga rlu nacnied zho naa; ni zha ne racnied naa lo xtsiṉ naa, paat yquiind zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Meṉdox ne rsacsi miech, zeeṉe laa ma rsaan zho, rie ma riequianzë ma dan zaatne choot miech guieṉd, rguib ma dieṉ pa cuëz ma; raṉse ma rdzield zaatne cuëz ma, rnee ma: “Mazd gbire naa guia naa lidz naa stib.” ");
INSERT INTO zpmNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dzigo rbire ma, zeeṉe rdziṉ ma lo zha ne psacsi ma ga, masaque rzac ma zho zig rzac miech tib yu ne griiṉ blioob, tib yu ne iṉe nzhixcuaa leṉ. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dzigo rie ma riexi ma zgadz sameṉdox ma, ma ne mazdraa ntseeb, rdziṉ ma gza ma rzëëb ma zdoo zha co, rsilo ma rsacsi ma zho. ¡Horcole mazdraa mban ruṉ ma zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sca quianee Jesús, zeeṉe nguiedz bnee tib wnaa ne no lad grë miech ne ndxie lo me ga, rëb wnaa co: ―¡Dichos wnaa ne gop luu, wnaa ne bgadz luu! ");
INSERT INTO zpmNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pquiab Jesús rëb me: ―¡Mazdraa dichos zha ne goṉ, yquiaadiag Xtiidz Dios ni tsoxco zho gban zhow zigne naca! ");
INSERT INTO zpmNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Miech guizhiu ne quiadziṉraa lo me ga, dzigo bnee me rëb me: ―Nadzpaa ntseeb zdoo to nac to miech ne mban leṉ dze rii. Tibaque quia to racladz to gaṉ to pe stib milagr, parne gliladz to Dios pxeeḻ naa, ¿zha rnaraa milagr ne racladz to gaṉ to? Gacnaṉ to gaṉle, stibaque milagr goṉ gaṉ to, tib miṉe csoladz to zha goc Jonás. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Haxta dzigoraa nagoṉ guieṉ to nli Dios pxeeḻ naa. Sac teḻ Jonás, zeeṉe gocnaṉ zha Nínive zha bzhaac me, dzigo bliladz zho nli Dios pxeeḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ni gacnaṉ to gaṉle, zeeṉe gaḻ dze ne laa Dios guṉ xquieḻwxtis me, zieso wnaa ne goc rein nëz Sabá, steedquie me to. Sac goṉ pa lo ga briee me, biaad me biadquiaadiag me grë xtiidz Salomón; ni to, lo to nu zo meṉ ne mazdraa non lo Salomón, ni nëd to gon to xtiidz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Scaque grë zha Nínive, steedquie zho to; sac goṉ zeeṉe güeynee Jonás lo zha Nínive, znuse bin zho diidz psaan zho xquieḻntseeb zho wbig zho lo Dios; ni to, lo to nu zo meṉ ne mazdraa non lo Jonás, ni ib ruṉcasde to me. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Tsod zha ne yquiaagui tib biini, lozh ga ctoos zho pe cos low, gzolangaa zhow zaatne ngueets. Sac biini ne rquia, glaa rzoba par gziiniw leṉ yu, zeeṉa guiab biini lo grëse zha ne sëëb leṉ yu. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Rrieequia nac bziaalo miech zig nac tib biini. Teḻne niapse lo grë ncuaaṉe ndzinli rwi zho, dzigo gdipse xcuerp zho no lo guieḻbiini. Laa teḻne loxaque lo grë ncuaaṉe nonguieḻdgaa rwi zho, dzigo gdipse xcuerp zho no lo guieḻcow ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Goḻguieṉ sca pa lo rwi to, napaa laa ne tso to lo biini, leḻ lo guieḻcow no to. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sac goṉ, teḻ dipse xcuerp to no lo guieḻbiini, ni tib lëw nod lo ncow, zlupaa to; sac masaque nac to ga zig tib zha ne zo gax tib lo biini nroob. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Zeeṉe blozhse bnee Jesús lo grë miech co, dzigo bredz tib zha farisé me güeynie zho me tib wagw lidz zho. Bdziṉ me lidz zho, bded me bzob me lo mezh, ");
INSERT INTO zpmNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","psilo me dow me, per bdiibd me nia me zigne nacpaa xcostumbr grë zha Israel. Zeeṉe goṉ zha farisé cow, rlozhd gzee zdoo zho; ");
INSERT INTO zpmNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","dzigo rëbchaa me: ―Grë to ne nac to zha farisé, laglaase rlu to miech wen nac to, per zdoo to ntseeb to, sac niapse guieḻntseeb, niapse guieḻgbaan ruṉ to; masaque nac to goṉ zig tas, zig plat ne nëz zhitsse mbe rna, laa nëz leṉa rnadraa di beed. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Nadzpaa ncow nac guic to! ¿Pe rieṉde to racladzd Dios ne laglaase glu miech wen nac to, sinque racladz me desde zdoo to gac to miech wen? Sac dib nacse to psaṉ me to. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Laa ne squi no to noban to, mazd goḻdeed ncuaaṉe naccheṉpaa to lo grë zha ne guieṉd pe yquiin, zeeṉa gac to miech ne nlipaa wen. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Probsaxe to! Rzac to demas nguzobdiidz to lo Dios, rio to haxta grë guizh bitxtil, grë guizh rud, ni grëragaa guizh ne ran to, rdeed to xdiezm to yadoo; per rioxcode to gban to zigne rnabey Dios, ib rioxcode to gleynie to samiech to. Ible none tsoxco to miṉ rii, ni bii scaquegaa tsoxco to gdeed to xdiezm to. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Probsaxe to! Rdziladz to gacnon to lo miech, zeeṉe rie to yadoo, zaatne glupaa non to, ga rzob to; scaque ndooladz racladz to gnee miech bdiuzh lo to, zeeṉe rdzieel zho to dib ro nëz. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Probsaxe to, lëëtaa rdzieel to grë to maistr ley! Masaque nac to zig nac grë baa ne rludraa pa nac. Teḻ baa cow, zeeṉe rded zho zaatne niaaw, ib rieṉd zho lad grë ncuaaṉ noyodz ga, noded zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Horco pquiab tib maistr ley, rëb zho lo me: ―Maestro, ¿ye no dzigo lëë rzoob luu squi nac? ");
INSERT INTO zpmNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pquiab Jesús rëb me: ―Ye to goṉ. ¡Probsaxe to! Rio to rzadraa ley ne rnabey to guṉ miech, ni per ni to rioxcode to siquier csilo to guṉ tow. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Probsaxe to! Paat rquiinda goṉ squi rio to, rlozhd dieeṉ paraa rzhixcuaa to ro xpaa grë zha ne biadteed xtiidz Dios padzeela. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","¡Igual ntseeb to grë pxozgol to! Sac goṉ, zha beet grë zha co, laa to no rzhixcuaa to ro baa. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Naṉle Dios squitaa ntseeb zdoo to, miṉe ruṉ to ga bnee me, zeeṉe rëb me: “Sxeḻ naa grë zha ne tsieteed xtidz naa lo zho, sxeḻ naa zha ne tsieneew lo zho, per naṉle naa gaṉdzed zho zho, haxta zut zho groḻ zho.” ");
INSERT INTO zpmNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gacnaṉ to sca gaṉle, grë to miech ne mban leṉ dze rii, grë to guṉquizh Dios xchen grë zha ne pxeeḻ me biadteed xtiidz me wlal ne ndxie guidzliu, ");
INSERT INTO zpmNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","desde Abel haxta Zacarí meṉ ne beet pxozgol to leṉ yadoo zaatne nac gax lo pcoog. ¡Ne nligaa grëse doḻ co goṉ, to quizha! ");
INSERT INTO zpmNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Probsaxe to maistr ley squi nac to, ib rneede to diidzli lo miech! Nac diidz to cseed miech guieṉ zho zha nac Xtiidz Dios, per nëde to gliladz tow, ni niicle nëëdgaa to gliladz zha ne racladz ycaaniaw. ");
INSERT INTO zpmNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Blozhse ga, laa me briee ga. Grë zha farisé, grë maistr ley, per nli rlëë zho bin zho sca rëb me. Psilo zho nzian grë ncuaaṉe rnabdiidz zho lo me, rguib zho dieṉ zha guṉglëë zho me, par dieṉ pe cxiṉd me pe tib diidz, zeeṉa miṉ co yquiaaqui zho tsiezoob zho xdemand me. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Miech guizhiu ne pcaalsa lo Jesús, haxta rcheeplsa zho. Dzigo bnee me lo xpëëdscuel me, rëb me: ―Goḻguieṉ goṉ, guṉde to miṉe ruṉ zha farisé, teḻ zha rquiaalose zho miech wen nac zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sac grëse ncuaaṉe sca ngueets rac, grëse ncuaaṉe rlud miech, zdziṉ dze ne xoobneṉa. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","’Zig nac grë ncuaaṉe zhliaanse rnee to lo ncow niina, zdziṉ dze ne gon miecha zobna ngbidz; grë ncuaaṉe rnee to leṉ yuse, zdziṉ dze ne dib lad guiedz gacnaṉ miecha. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Goḻgona gaṉle bets: Ib gdziebde to zha ne gacladz gut to. Nli zrieelo gut zho xcuerp to, per peet grieelodraa zho guṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Goḻguieṉ, Dios nac meṉ ne mazdraa nroob, miṉe rnabey me miṉ co none gon to. Sac teḻ me, zrieelo me gnitlo me miech dib xcuerp zho, ni lozh ga zrieelo me gzonëz me zho nëz leṉ gabiḻ. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Nligaa gdziebde to miech, csaand Dios lega pe gac to. Goḻwi gaṉle, zig nac grë mguiṉ, niicle ne rzac miech peet nond ma, haxta chop ma rto zho por tib gaay centav; per teḻ Dios, ib rsaanladzd me ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Peleḻ to dzigo csaan me, haxta guits guic tow, grësew ngaba lo me. Gdziebde to sca, goḻguieṉ gaṉle nonraa to lo tib dzoon mguiṉ. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ni gni naa lo to gaṉle, zha ne glu lo miech nacnie zho naa, scaque naa ne nac naa Mgui ne pxeeḻ Dios, zeeṉ gaḻ dze co zlu naa lo grë xanjl Dios, nacnie naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Saṉgue zha ne ctoladznie naa lo miech, scaque naa ziep naa lo grë anjl co ruṉbeyd naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","No zha ne rneenë naa, per zuṉ Dios zho perdon doḻ co; saṉgue zha ntseeb ne gneenë Espíritu Sant, ib guṉdraa me zho perdon. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Zeeṉe tsiezo miech rii to lo grë zha ne rnabey xyadoo zho, tsiezogaa zho to lo grë zha ne nac wxtis, tsode to zhgab dieṉ pe gnee to; ");
INSERT INTO zpmNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","sac zeeṉe sca tsiegala, Espíritu Sant csiaab guic to pe nac miṉe gnee to lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Horco wbig tib zha ne no lad grë miech co, rëb zho lo Jesús: ―Maestro, bzhiguieḻ bnee lo bets naa glë zho ncuaaṉe psaṉ pxoz no, gneedz zho miṉe raguiaḻ naa yca naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","―Aque luuw nli ―rëb Jesús―, ¿cho në lo luu laa naa noyuṉ guieḻwxtis co? Ziaḻd naa goṉ par quiiz naa ncuaaṉe rap miech. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dzigo bnee me lo grë miech co, rëb me: ―¡Goḻguieṉ goṉ, gzoobladzde to demas gapcheṉ to! Sac niicle ndziibraa gapcheṉ miech, grieelod por grë ncuaaṉ co ndzon gac lo xquieḻmban zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Znu goṉ bzhaac tib meṉ ne nroob gopcheṉ. Nat liu quianie me, zeeṉe rlaap me grë ncuaaṉe ran me, nroob ncuaaṉe rlis me low. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bdziṉ tib dze rgaadraa pa tsotsow grë ncuaaṉ co, dzigo bzob me dieṉ zha guṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tibaque zeeṉe rëb me: “Miṉe naca laa naa guṉ nroob grë yu qui, zeeṉa zigtaa grë guieḻnzaac quiw, grëragaa ncuaaṉe rap naa, ga tsotsowa grësew. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","¡Pe zhidaa iz ne lëb grë ncuaaṉ co! Peet tsieniedraa guic naa, iṉe guxt sob naa, gow naa, guie naa ncuaaṉe gacladztaa naa.” ");
INSERT INTO zpmNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Miṉ co rza guic me, tibaque zeeṉe rëb Dios lo me: “Nadzpaa nxen luu. Guieel riigazh goṉ laa luu guet. ¡Zhaale zha ne guiaaṉnie grëtaa ncuaaṉe beeṉlo luu i!” ");
INSERT INTO zpmNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Zeeṉe blozh bzodiidz Jesús cuent co, rëbchaa me: ―Sca nagoṉ rzac grë zha ne loxaque dieṉ zha gapcheṉ zho zienie guic zho. Ncuaaṉ cose rionie guic zho, ib rioxcod zho guṉ zho ncuaaṉe non nëz lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Blozh ga, rëbchaa me lo xpëëdscuel me: ―Gacxe waa, gni naa lo to gaṉle: Tsode to zhgab dieṉ zha gban to lo guidzliu rii, pa griee pe gow to par gban to, pa gdzielgaa ncuaaṉe gdze xcuerp to. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mazd goḻconie guic to dieṉ zha gac xquieḻmban to, dieṉ pa tsiebannie to xcuerp to. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","’Goḻwi lo grë nga gaṉle, led yed ma ran, led yed ma rlaap, led yed ma rgotsow pe guieḻgon, per row ma; sac Dios rdeed ncuaaṉe row ma. ¡Teḻ to goṉ, mazdraa non to lo grë mguiṉ co! ");
INSERT INTO zpmNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni lalnu paat rquiinda tant tso to zhgab. Teḻne guiab to tso to zhgab dieṉ zha gacnool xtse to spalal yeeṉse, ¿niacxe zrieelo to guṉnool tow? ");
INSERT INTO zpmNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Naṉle to gaṉle led ncuaaṉe grieelod ga. ¿Pe nac dzigo tant tso to zhgab ncuaaṉe mazdraa nroob? ");
INSERT INTO zpmNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Zig nac lar, ¿pe nacne tant tso to zhgab dieṉ pe gacwxab to? Pe rwide to lo grë guiee dzil ne gaṉle zëëb dan, zha rrooba, niow rluw, ni led yeda rio zhgab dieṉ zha gacwxaba; ni gni naa lo to gaṉle, per ni rey Salomón con grë xab niazh me, blud me scataa niow. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gase na gaṉle goḻwi, niicxe grë guiee dan co na, zna dze zob nguiaw, gzhe widz laaw bidzle, laaw tsecle, ni scataa niow rgacwxab Diosa; ¿pe leḻ to dzigo ygacwxabd me, niicle ne squi gard guieṉ to dib zdoo to gnalo to me? ");
INSERT INTO zpmNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","’Tsodraa to zhgab sca, guiab to: “¿Pa griee pe dioow ne, pa griee pe dio ne?” ");
INSERT INTO zpmNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Grë miech ne ruṉbeyd Dios, tibaque zhgab co rio zho. Saṉgue to, goḻsoladz gaṉle Pxoz to meṉ ne zob gbaa, naṉle me pe nac grë xliaadz to. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Me nac meṉ ne gneedz ncuaaṉe yquiin to, per ib none glo tsoxco to gban to zigne rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Nli zhis to, pale tib dzoon win mëcwxiil yeeṉ, per gdziebde to. Sac niicle zhis to, per rley Pxoz to meṉ ne zob gbaa, laa me rneedz grëse ncuaaṉe rap me lo to. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gacxe waa, laa ne tsonie guic to dieṉ zha gacnroob ncuaaṉe rap to, miṉe quianie to goḻtow, dzigo goḻdeed dimi co yquiin zha ne rappaa liaadz; zeeṉa sca nroobraa guieḻnzaac ne ygaa to gbaa. Guieḻnzaac cosi, led yeda nitlo, led yeda grë, led yeda tsoxtseeb lo ngbaan, tsoxtseebgaa lo mxiḻ. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","’Sca goḻguṉ, sac goṉ guieḻnzaac ne guṉlo to, zaatne guṉlo tow, ga gdziṉ to. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Nsin sca goḻso ―rëb me lo zho―. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Goḻgac zig tib nguṉdziin ne rquiambëz gbire meṉ ne rnabey zho zeeṉe pa rie me tib lo guieḻtsieel. Nsin rzo zho, zigne rdziṉ me, rxal zho ro yu rzëëb me. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","’Dichos zha ne nsin zo zeeṉe laa meṉ ne rnabey zho glanso. Ib tedsod, steed me zho nëz leṉ yu, soob me zho lo mezh, csilo me mezhal gdziib ncuaaṉe gow zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nligaa dichos zha ne sca nsin so, horne glansotaa me; niicle teḻ wxiṉa, ziadyiinigaa liuw. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Goḻgaṉ gaṉle, teḻ niaca miṉe gacnaṉ miech laa ngbaan tsieban lidz zho guieel, per naṉd zho dieṉ pa horpaaw, ¿niacxe zaaguies zho? Led sobna zho lëë, nsin nsin so zho parne csaand zho sëëb ngbaan lidz zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Scaque to nagoṉ, none sca nsin so to, sac goṉ lega naclew zeeṉe gaṉ to laa Mgui ne pxeeḻ Dios ziaadle. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Zeeṉe blozh sca bnee me, rëbchaa Pedr lo me: ―Maestro, miṉe blozh bnee luu i, ¿pe par nose naca, te ye par grëraa miecha ye? ");
INSERT INTO zpmNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pquiab me rëb me: ―Laaw rne naa, par grëse zha ne zienie guic zaacse guṉ zho miṉe rnee meṉ ne rnabey zho. Nligaa nsin none so zho, sac laa zho guiaaṉnie zha ne nacgrë zho, zig riaaṉnie tib nguṉdziin sanguṉdziin zho parne gdeed zho ncuaaṉe gow zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","’Dichos zho, teḻne iṉe niowse noyuṉ zho dziin co zeeṉe laa meṉ ne rnabey zho glanso. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Zeeṉe gaṉ mew, ib tedsod so me zho, zha gnabey grëse ncuaaṉe quianie me. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per teḻ tsienie wguit guic zho guiab zho gbireniobd me, csilo zho leḻ csacsi zho grë zha ne biaaṉnie zho, tso zho loxaque gowcho zho, loxaque gzudz zho, ");
INSERT INTO zpmNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tibaque zeeṉe gaṉ zho laa me zole lo zho; ib tedsod hor cogazh ctiche me dziin co lo zho, gzonëz me zho guey zho zaatne no grëraa zha ne rond diidz. Nroob caxtigw ne cteed me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Sac goṉ zha ne sca naṉle pe nac miṉe racladz meṉ ne rnabey zho, ni tsoxcod zho guṉ zhow; ible nroob nac caxtigw ne ted zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mazd lëëtaa caxtigw ted zha ne peet naṉd, niicle guṉd zho miṉe rnabey me. Grëse zha ne naṉle pe nac miṉe no guṉ zho, ib none guṉ zhow; nac cuent rii zig tib zha ne rcaania pe cos, teḻ palal miṉe pcaania zho, none haxta nroobraaw ctsire zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Niina ne laa naa ziaḻ, rrieequia ziaḻzobgui naa lo guidzliu. ¡Ni zoot naa goṉ, tebaa raṉle naa laaw quiayazbel! ¡Tebaa psiaaḻle naa lo dziin ne ziaḻguṉ naa! ");
INSERT INTO zpmNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Per na naraa none teed naa tib guieḻnë nroob, ni mbanse goṉ rac zdoo naa quiambëz naa gdziṉ dze co. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Masaque naṉ to na lëë, laa naa ziaḻ loxaque par cuiṉ wense miech? Lëda goṉ, ye ziaḻ naa ziaḻguṉctiḻ naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sac desde leṉ dze rii, yu ne no gaay miech, laa zho ctsolsa. Teḻ sëëb chop zho xnëz naa, laa stsoṉ zha ne guiaaṉ ga, ctsidiḻ zho; teḻ sëëbgaa tsoṉ zho, scaque grop zha ne guiaaṉ ga, gaṉdzed zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mëëd ne gaṉ laa pxoz zho, laa xniaagaa zho bzëëb xnëz naa, gaṉdzed zho pxoz zho, gaṉdzed zho xniaa zho; scaquegaa zha ne quianie mëëda, zeeṉe gaṉ zho laa xingan zho, laa xindzoopgaa zho bzëëb xnëz naa, gaṉdzed zho zho. Zha ne nac nguzhizha, zlëënie xniaa tsieel zho zho; teḻ xniaagaa tsieel zhow, zlëënie zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Blozhse sca bnee me, rëbchaa me lo grë miech ne ndxie ga: ―¡Pe nlipaa rnee to rieṉde to pe nac grë ncuaaṉe noyac leṉ dze rii! Zha zeeṉe raṉ to rquia xcow nëz ne rzëëb ngbidz, znuse rieṉ to laa guie guiab. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Zeeṉe raṉgaa to ziaad me nëz ne rzë ngbidz leṉ mëë naḻ, naṉle to laa nëëg gac. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Guieḻwquiaalo i lo to goṉ! Zha zëëb dzigo ruṉbey to grë señ ne rlu zhan gbaa, rlugaa lo guidzliu, laa grë miṉe quiayaṉ to leṉ dze rii rieṉde to. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¡None guieṉ to tozhal cobey dieṉ pe nac miṉe nonguieḻ guṉ to! ");
INSERT INTO zpmNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gzoob ne bdiḻnie to tib samiech to, laa to nole nëz zie to lo wxtis grop to. None guieṉ to, laga no to nëz mazd goḻguiaaṉ mpas, lëdle tsiezo zho to lo wxtis; sac teḻ laa to gdziṉ lo wxtis, ib znabey wxtis zha ne co to ladzguiib. ");
INSERT INTO zpmNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ni naṉle to gaṉle, grieede to ga, haxtaque lozh quizh to teḻ palal gac mult ne gnab zho lo to. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Leṉ dze co, bdziṉ bla zho lo Jesús bzodiidz zho lo me zha bnabey Pilat gut bla zha Galilé, lëëtse zeeṉe no zho leṉ yadoo noyut zho ma ne nogogon zho lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Dzigo rëbchaa Jesús lo zho: ―Segur na lëë, rëb to mazdraa ngoopdoḻ grë zha co lo grëraa zha ne no nëz Galilé, gane sca bdzieelo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","¡Lëda goṉ! Zigtaa ngoopdoḻ zha co, scaque to ngoopdoḻ nac to; teḻne csaande to xquieḻntseeb to gbig to lo Dios, ye to znitlo to. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Scaque tsiimtsoṉ zha ne bgaadz yuglaa ne bixche Siloé, masaque rëb to nagoṉ mazdraa ngoopdoḻ zho lo grëraa zha Jerusalén, gane sca gut zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Per gacnaṉ to gaṉle, ¡lëda! ¡Zig rne naa ga, ye to miech ngoopdoḻ nac to, ni teḻne csaande to xquieḻntseeb to gbig to lo Dios, ye to zdziṉ dze ne nitlo to! ");
INSERT INTO zpmNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dzigo bzodiidz me tib cuent lo zho, rëb me: ―Tib meṉ name, zob tib zhan yag guigw lo xcuaa me zaatne quianie me lbë uv. Cad rdziṉ mëë ne rquia guigw, rie me rieguib me nex low, per ib peet rquiad. Zeeṉe goctaa tsoṉ iz, goṉ me sca rdeetew nex, ");
INSERT INTO zpmNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","dzigo bnabey me zha ne quianap liu co cchuggazh zhow, rëb me: “¡Pchuggazh yag yozh qui, zhlëse zoba i! Nale rac tsoṉ iz ziyaḻ naa rguib naa nex low, ni peet nex rneedzda.” ");
INSERT INTO zpmNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Dzigo pquiab zha ne quia dziin lo me ga, rëb zho: “Psaan dieṉ guiaaṉa stibtaa iz rii, na laa naa glë zhana, na laa naa gdziṉ beeba. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Teḻne yquiadaque nex low iz ne ziaad, maase cchug new dzigo.” ");
INSERT INTO zpmNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tib dze ne rdziiladz zha Israel lo dziina, bdziṉ Jesús leṉ yadoo, psilo me noseed me miech. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lad grë zha ne noseed me ga, lad co no tib meṉ wnaa nlengw nac zhits, gocle tsiimtsoṉ iz sca nosacsi meṉdox me, ib gacd gacnli me. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Zeeṉe goṉ Jesús me, dzigo bredz me me, pxobnia me guic me, rëb me lo me: ―¡Niinagazh goṉ, laa luu guiac! ");
INSERT INTO zpmNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","¡Horcogazh laa zhits me ga gocnli, rley me, psilo me rdeed me xquizh lo Dios! ");
INSERT INTO zpmNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Laa zha ne rnabey yadoo, zeeṉe goṉ zho sca beeṉguiac Jesús me dze co, blëë zho, rëb zho lo zha ne ndxie ga: ―Zha ne racladz guiac pe lo guieḻguidz, pe gacd guiaad zho leṉ dze ne rac dziin, ¡led tsod zho guiaad zho guiac zho dze nda rii! ");
INSERT INTO zpmNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dzigo pquiab Jesús rëb me: ―¡Nazdpaa ntseeb to! Rquiaalo to ib peet dziin ruṉde to dze rii. ¿Pezhe ga waa ruṉ to zeeṉe rsilaa to xcon to, rsilaa to xpurr to dze rii rieguie to ma nis? ");
INSERT INTO zpmNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Zha nac dzigo rzac to, nonguieḻda nu beṉ naa beeṉguiac naa wnaa rii, dze rii. Goḻwi gaṉle zha xtii Abraham nac me, leṉ tsiimtsoṉ iz goc sca nosacsi meṉdox me. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Zha ne rlëë ga, zeeṉe bin zho sca rëb me, ptoladz zho; laa grëraa zha ne ndxie ga, rley zho raṉ zho grëtaa milagr ne ruṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Blozh ga, bnee me rëb me: ―¿Zha gaṉle racnroob lo xtsiiṉ Dios lo guidzliu rii? ");
INSERT INTO zpmNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Racnrooba goṉ zig rroob tib midz moxtaz ne ran zho dan rii. Teḻ midz moxtaza niicle tib midz winsew, zaatne racbniw, rrooba, raca tib yag nroob; haxta rie grë mguiṉ riezhixcuaa ma zhiptsieez ma low. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","’Ziaadaque goṉ gaca, zig ncobi. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Sac teḻ ncobiw, niipaquew rcots meṉ wnaa tsoṉ lmud rin, ni dib nacse ncob co rzibe. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Laa Jesús no nëz zie me nëz Jerusalén. Guiedz ne rdedtaa me rseed me miech; zigtaa guiedz nrooba, zigtaa guiedz wina. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tib vuelt bnabdiidz tib zho lo me, dieṉ pe zhis nac miech ne ycaania Dios. Dzigo pquiab me rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Nligaa zhis zho, sac masaque naca zig tib puert niase. Goḻtsoxco sca niinasraa goḻsëëb xnëz me ycaania me to, sac zdziṉ dze ne nzian zho gacladz sëëb, per grieelodraaw. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Deque laa meṉ ne rnabey csioog ro yu, teḻne biaaṉ to nëz ley, niicle cuedzraa to me gnab to siguieḻ me cxal me ro yu sëëb to, per cxaldraa mew. “Ruṉbeyd naa to”, gnë me, “naṉd naa dieṉ cho zha to.” ");
INSERT INTO zpmNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Niicle guiab to ruṉbey me to, biaadpaa me ladz to pseed me miech, haxta downie to me. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Laa naa nile”, gnë me, “ruṉbeyd naa to. ¡Guṉneetraa to naa, ib rdziguiend naa grë miech yozh, miech ngoopdoḻ ne nac to!” ");
INSERT INTO zpmNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","’Mban gac to zeeṉe gaṉ to laa Abraham, laa Isaac, laa Jacob ni grëraa zha ne biadteed xtiidz Dios, laa me pcaania zho, laa to biaaṉse nëz ley. Nligaa mbandox gac to, zoon to, haxta zow lay to lo guieḻnë co. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ni mazdraaw goṉ, zeeṉe gaṉ to pa lo guidzliu briee grë miech ne bdziṉ ga, iṉe zobnie me zho lo xmezh me noyownie me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Grë zha ne rzac to niina peet nond, lëëtse zha co ygaa guieḻnzaac co; laa grë zha ne rzac non zho niina, peet ygad zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dze coquew, bdziṉ bla zha farisé rëb zho lo Jesús grieeniob me ga, sac laa Herod racladz gut me. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Dzigo rëbchaa me lo zho: ―Goḻtsie goḻguiab lo mëz win co cxecw me spalal, nadzese ni gzhe guṉguiac naa miech nu, zigtaa zha ne rzacnëw, zigtagaa zha ne nosacsi meṉdoxa; gaḻ widz guieṉdle naa nu. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","¡Nligaa nadzesew ni gzhe, widz laa naa gdziṉle Jerusalén zaatne za naa! Sac ible Jerusalén, ga rut zho grëse zha ne riadteed xtiidz Dios lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Aque tow meṉ Jerusalén! ¿Pe nacne squitaa nac to, rut to zha ne ziadteed xtiidz Dios lo to, rgoquie to grë zha ne rxeeḻ me lo to? Blactaa gocladz naa niacnie naa to, nquianaap naa to zig ruṉ nguid rgueedz ma xpëëd ma, per bzhiguieḻde to. ");
INSERT INTO zpmNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Gacnaṉ to gaṉle, nadzetaa goṉ laa lidz to guiaaṉ ngan, sac gaṉdraa to naa, haxta gaḻ dze ne guiab to: “¡Zha ndzontaa meṉ qui pxeeḻ Dios lo ne!” ");
INSERT INTO zpmNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Tib dze ne rdziiladz zha Israel lo dziina, güey Jesús lidz tib zha farisé ne nac zha non, sac bredz zho me tib wagw lidz zho. Bdziṉaque tib meṉ bgui, rzacnë me, gdipse me no gui. Grëraa zha farisé ne ndxie ga, quialeets zho Jesús quiambëz zho dieṉ pe zuṉguiac me mgui co. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dzigo rëbchaa Jesús lo zho, ni lo grë maistr ley ne ndxie ga: ―Goḻnë dieṉ, ¿pe nonguieḻa guṉguiac naa miech dze rii, te nonguieḻda ye? ");
INSERT INTO zpmNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ni tib zho pquiabd. Horco pxobnia me guic mgui co, beeṉguiac me mgui. Blozhse bzonëz me mgui, ");
INSERT INTO zpmNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","rëbchaa me lo zho: ―¿Pe nli na peet dziin ruṉde to dze rii? Teḻ zha tsietsobe tib xpëëd to, tib xmagaa to tib leṉ guiuu dze rii, ¿niacxe tsiebeegazhde to xpëëd to, tsiebeegazhdgaa to xma to ga? ");
INSERT INTO zpmNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Loxaque lo zho rac, ib bdzield zho pe nquiab zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Grëraa miech ne nodziṉ ga, no zho rguib zho dieṉ zha ygaa zho zaatne nzhixcuaaraa sob zho. Goṉ Jesús zha rac zho, dzigo bnee me lo zho, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Goḻguieṉ goṉ, zeeṉe znu cuedz miech to, zig nac tsie to tib wagw zaatne noyac tib guieḻtsieel, ib guṉde tsiesob to zaatne nzhixcuaaraa. Sac goṉ, nenda glanso tib zha ne nonraa lo to, ");
INSERT INTO zpmNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","lozh ga, laa zha ne bredz to lo lni guiaadliso to ga, gnë zho: “Guso i dieṉ sob meṉ rii.” Led tib guieḻto ga par to, racse to laa to tsieso ga, tsiesob to zaatne riaḻle ro beeḻ. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mazd gaṉle, zeeṉe sca pa lo tsie to tib lo lni, ndooladz goḻgac, tib lad goḻsob. Zha ne bredzle to lo lni, zeeṉe gaṉ zho laa to zob ga, ziaad zho ziaad-xi zho to tsiesobnie zho to zaatne nzhixcuaa. Zha ne zoble lo mezh ga, zeeṉe gaṉ zhow, ziaṉnziuu to lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Goḻsoladz gaṉle: grë zha ne lëëque zha ruṉnon zho, leḻ riaaṉwin zho; laa zha ne riaaṉwin, ruṉnon miech zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Blozh ga, rëbchaa me lo meṉ ne nac lidz ga: ―Scaque luu goṉ, zeeṉe cuedz luu miech guiaad zho tib wagw lidz luu, tsod luu loxaque zha ne ndzieeldiidz luu, loxaque zha bets luu, zha lidzse luu, lo grëgaa zha ne no gax lidz luu zha ne rapcheṉse, zha cose cuedz luu; sac goṉ ib tedsod zbedzaque zho luu lo zhilni zho, stsire zho miṉe beeṉ luu ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mazd bredz grëse miech, zig nac zha ne guieṉd pe yquiin, zig nac zha ne guieṉd tib nia, zha ne guieṉd tib ni, zha ne roḻdgaa lo; ");
INSERT INTO zpmNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","zeeṉa gaḻ dze ne grieeban grë zha ne bioxco wban zigne racladz Dios, iṉe gley luu ygaa luu guieḻnzaac ne tsieguiaḻ luu gneedz me lo luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Lad zha ne zobgrë me lo mezh ga, pquiab tib zho rëb: ―¡Dichos grë zha ne sca ygaa tsiesob lo mezh, tsietownie zho Dios zaatne rnabey me! ");
INSERT INTO zpmNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pquiab Jesús rëb me: ―Tib meṉ name, nzian zha ne bredz me tsie tib wagw lidz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Zeeṉe goḻ dze ne laa guieḻwagw co gac, pxeeḻ me tib zhinguṉdziin me ziexi grë zha co. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Per pasë zho nie, zhaase zhaase ncuaaṉe pquiaqui zho. Tib zho rëb: “Grieelod së naa, sac laa naa pca tib lë liu, ni lëëtse nadze no gaso naa low; bzhiguieḻ gudz lo me guṉ me naa dispensar.” ");
INSERT INTO zpmNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Stib zho rëb: “Niina wriiṉ pca naa gaay nëz ngon, laa naa no ganie ma dieṉ zha ruṉ ma dziin, gudz lo me yquiambëzd me naa.” ");
INSERT INTO zpmNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Laa stib zho rëb: “Grieelod së naa, sac niina wriiṉ ptsieelnia naa, bzhiguieḻ gudz lo me gacd guiaḻ naa.” ");
INSERT INTO zpmNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","’Bdziṉ nguṉdziin co bzodiidz zho lo me zha rzë xtiidz grë zha co. Zeeṉe bin mew, wbiṉladz guic me, bnabey me zho güey zho dib lad guiedz güeyxi zho grë zha ne guieṉd pe yquiin, grë zha ne guieṉd nia, zha ne guieṉd ni, zha ne roḻd lo, grëse zho bdziṉnie zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Blozh ga, rëbchaa zho lo me: “Laa naa wbirele xmandad luu goṉ, per scase noraa zaatne cue miech.” ");
INSERT INTO zpmNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dzigo pxeeḻ me zho stib, rëb me: “Güey dib ro guiedz, zha ne gdzieeltaa luu, dënie zho nëz rii, bloo guic zho guiaad zho; ib none tsodzëse miech lidz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sac grë zha ne bredz naa glo ga, ni lalnu racladzdraa naa ygaa zho guieḻwagw rii.” ");
INSERT INTO zpmNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Laa Jesús no nëz zie me nëz Jerusalén, miech guizhiu ne naḻ zhits me. Tibaque ptsire lo me bui me lo grë miech co, rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Lo grë to ne ziaadnaḻ to zhits naa, gacnaṉ to gaṉle zha ne racladz ygab xnëz naa, ib none gleynie zho miṉe rnabey naa. Sac zha ne mazdraa rleynie pxoz, mazdraa rleynie xniaa, mazdragaa rleynie zho tsieel zho, xpëëd zho, bets zho, bziangaa zho, xquieḻmban zhow, rquia zdoo zhow, peet xtsiiṉd grë zha co par sëëb zho xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sac ni tib zha ne sca yquia zdoo cueeladz zho zho guiaadnaḻ zho zhits naa, grieelod ygab zho lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Antes ne yquiabladz to sëëb to xnëz naa, none wen wen sob to dieṉ pe zlëb to ted to miṉe rieguiaḻ to. Zig nacse tib zha ne gzaa tib yu glaa ne gac chop tsoṉ xcuaa, led rzobgazh zho rbee zho cuent dieṉ pe zgaa xtimi zho tsaalow. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sac goṉ nenda loxaque cueeze zhow, ni lozh ga grieelod gzaalo zhow. Miech ne gaṉa laa zho gzhidznie zho, ");
INSERT INTO zpmNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","guiab zho: “Goḻwi lo zha qui gaṉle, loxaque bleeze zho lidz zho, na blëbd zho nzaalo zhow.” ");
INSERT INTO zpmNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Scaque rey ne no tiḻnie stib rey, led none sobgazh zho gaṉ zho dieṉ pe zlëëb tsii mil xmeṉguiib zho tsietiḻnie gaḻ mil xmeṉguiib stib rey co. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Teḻne rgobey me lëbd me, laga bii zit ziaad stib rey co, rxeeḻ me bla zha ne tsie tsienee dieṉ zha gataa cuëz lo xtiḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","’Scaque to nagoṉ none glo gwi to pe nac grë ncuaaṉe no csaan to, parne grieelo ygab to xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sac goṉ zed ne nzhid, ¿pa dieṉ yquiina? ");
INSERT INTO zpmNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Per ni par gaca beeb peet xtsiiṉda; miṉe ractaaw, laaw rziaab. Zha ne no liaadz guieṉ zho pe rnee naa, yquiaadiag zhow. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Zeeṉe rseed Jesús miech, nzian grë zha ne rtop dimi ne razh lo zha Roma, ni grë zha ne rzoob miech nac zha yozh, ye zho rbig zho rquiaadiag zho zhiwseed me. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nacne grë zha farisé ni grë maistr ley, rneenë zho me, rnee zho lëda ga ruṉ me sca rtsieelsa me grë zha co, rownie me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dzigo bnee me lo zho, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Togase nadieṉ, gzoob ne quianie to tib gayoo mëcwxiil, ni lega naclew rziaab tib ma, ¿zha dieṉ ruṉ to? Led rsaṉ to ma ne ndxie lo to ga lëë, laa to rie rieguib to ma ne bziaab ga, haxta rdziel to ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Zeeṉe rdziel ma lo to, lo guieḻbley co haxta rxobyaṉ to ma rdziṉnie to ma ro yu. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Lëëlëd rzodiidz tow lo zha ne ndzieeldiidz to, lo zha ne no gax lidz to, sac rley to laa xpëcwxiil to brieequia. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Gni naa lo to gaṉle, scadaa nagoṉ rzac Dios, tib guieḻbley nrooba lo me, zeeṉe raṉ me laa tib zha ngoopdoḻ rsaan xquieḻntseeb, laa zho rbig lo me. Ne nligaa tib guieḻbley rac zha co lo me, lëdle zha ne rzac miech wenle nac zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Zig rzacgaa tib meṉ wnaa, gzoob ne nzheṉ me tsii gayoo pes, ni lega naclew rsëëb me tib gayoow, ¿zha dieṉ ruṉ me? Led hor cogazh lëë rquiaa me biini, rsilo me dzega dzega rloob me leṉ lidz me haxta rdziel me dimi co. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Zeeṉe rdziel mew, rley me rzodiidz mew lo grë zha ne ndzieeldiidz me, lo grë zha ne no gax lidz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Zig rne naa ga, scadaa nagoṉ rzac grë xanjl Dios, tib guieḻbley nrooba lo zho zeeṉe raṉ zho laa tib zha ngoopdoḻ rsaan xquieḻntseeb, laa zho rbig lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Dzigo psilo Jesús bzodiidz me tib cuent lo zho, rëb me: ―Tib meṉ name quianie me chop mëëdbgui. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tib dze, rëb zha ne nac zha niab lo me: “Papá, teḻ pe nac ncuaaṉe no gneedz luu lo no, bzhiguieḻ niinaga beeṉgroḻa, zeeṉa gneedz luu miṉe raguiaḻ naa.” Dzigo beeṉgroḻ me ncuaaṉe rap me, bdeed mew lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","’Zhisaque goca, pto zha niab co grëse ncuaaṉe biaḻ zho, briee zho laa zho zie. Bdziṉ zho stib dan, ga beeṉ zho grë guieḻyozh ne gocladztaa zho, grëse xtimi zho pxiṉ zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tibaque zeeṉe laa xtimi zho blozh, mbanse rac zho guieṉdraa pe gow zho, ni lëëtaque leṉ dze co laa tib gbin psiloque nëz co. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dzigo racse zho güeyguib zho dziin lad guiedz co, ga brieequia tib meṉ co bree zho, pxeeḻ me zho yquiaanap zho nguts. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Lo gbin ne noded zho ga, rzac zho tebaa cho gdeed maase grë duuzhye dan ne row grë nguts co gow zho, per ni miṉ co choot rdeete lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Sca no zho ga, tibaque zeeṉe biaa zho biini psoladz zho nzian zha ne quia dziin lo pxoz zho, grë ncuaaṉe raclo row grë zha co, haxta riaaṉa, ni laa zho sca noded ga; rëbchaa zho: ");
INSERT INTO zpmNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“Mazd miṉe naca laa naa guia gdziiṉ naa lo pxoz naa stib, guiep naa lo me guṉ me naa perdon grëtaa falt ne beṉ naa lo me, falt ne beṉgaa naa lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Maase sacdraa me naa zig xpëëd me, siguieḻ me ycaania me naa gac naa zig tib zha ne quiase dziin lo me.” ");
INSERT INTO zpmNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Horco bio zho nëz laa zho zey nëz lidz pxoz zho. Zitraa ziaad zho laa me goṉle zho, pquia zdoo me zho goṉ me zha rac zho; rias me güeydzieelo me zho bnaaz me nia zho, bdeedz me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","’“Papá”, rëb zho lo me, “rieṉ naa nroob falt ne beṉ naa lo Dios, beṉgaa naa lo luu. Rieguiaḻdraa sac luu naa zig tib xpëëd luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","’Ni blëzd me nlozh nee zho, lëëlëd bredz me zha ne quia xtsiiṉ me, rëb me: “¡Na goḻtënie tib nëz lar wen nu gacw xpëëd naa! ¡Goḻtënie tib nil wen tso nia me, tib nëz guieḻguid cub yquia ni me!” ");
INSERT INTO zpmNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bnabey me zho güeyxi zho tib ngon ne mazdraa ndaan, beet zho, rëb me: “¡Ib none gac tib lni, none dioow ne, none dio ne! ");
INSERT INTO zpmNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","¡Sac goṉ guṉ naa cuent, brieeban xpëëd rii naa! ¡Bnitle me ga, na laa me bdziel!” ¡Laa lni psilo! ");
INSERT INTO zpmNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Lni co noyac, zeeṉe laa stib xpëëd me zha ne nac zha gol ga, wbire lo dziin dan. Bdziṉ zho gax ro yu, rlu rquia di, haxta wiee rlu noyac; ");
INSERT INTO zpmNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","dzigo bredz zho tib zha ne quia dziin lo pxoz zho ga, bnabdiidz zho dieṉ pe lni ne noyac. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dzigo rëbchaa zha co: “Bets luu blanso, gane squitaa bnabey pxoz luu noyac lni; rley me goṉ me mban zho laa zho blanso. Bnabey me gut tib ngon ne mazdraa ndaan.” ");
INSERT INTO zpmNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Blëë zha gol co bin zhow, lo guieḻblëë co bzëëbd zho ro yu. Nacne briee pxoz zho, bnee me lo zho sëëb zho ro yu. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dzigo rëbchaa zho lo me: “¡Lëdraaw i goṉ papá noyuṉ luu! Bui gaṉle blactaa iz ne quiayuṉ naa dziin lo luu, wlaltaa gard quits naa tib xtiidz luu. Ni zha rna tib dze, siquier tib chiv yeeṉ ygad luu lo naa, gownie naa grë zha ne ndzieeldiidz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Cho dzigo nac zha qui, blozhse güeyloozh zho xtimi luu lo grëtaa guieḻyozh ne beeṉ zho, na no luu beet luu ngon ne mazdraa ndaan, noyuṉ luu zhilni zho.” ");
INSERT INTO zpmNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dzigo rëbchaa me lo zho: “Nliw xin, ni lalnu gard csaan luu naa, gacxe waa grëtaa ncuaaṉe quianie naa, luu guiaaṉniew. ");
INSERT INTO zpmNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per niina ne laa bets luu blanso, ib nonguieḻa znu dziuuṉ ne tib lni gleynie ne me; sac goṉ bnit me, ni na laa me bdziel. ¡Dziuuṉ ne cuent brieeban me nu!” ");
INSERT INTO zpmNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tib vuelt bzodiidz Jesús tib cuent lo xpëëdscuel me, rëb me: ―Tib meṉ name nroob rapcheṉ me, quianie me tib zha ne zo lo grëtaa ncuaaṉe rap me; tib dzew, lega nacle bded diag me zhliaan noxiṉ zha co xtimi me. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dzigo bredz me zho, rëb me lo zho: “Lëda i goṉ squi ruṉ luu, lega noxiṉ luu xtimi naa. Niinaga racladz naa guiaadnie luu cuent nu dieṉ zha quiayuṉ luu dziin; sac grieelodraa so luu lo grë ncuaaṉe rap naa.” ");
INSERT INTO zpmNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","’Wbire zho ga, rëb zho: “Zha na gaṉle guṉ naa, teḻne guiab ne ga naa dziin dan, lëbdraa naa guṉ naa dziin co; teḻ guiaabgaa ne na ga naa gatop naa gon, rtoladz naa gnab naa gon lo miech.” ");
INSERT INTO zpmNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tibaque zeeṉe biab guic zho rëb zho: “¡Laa naa bieṉle zha guṉ naa, zeeṉa tso zha ne guṉ xyudar naa zeeṉe laa naa grie lo xtsiiṉ meṉ rii!” ");
INSERT INTO zpmNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Dzigo psilo zho bredz zho zha ne quia guieḻqui lo meṉ ne quia zho xtsiiṉ ga. Bdziṉ tib zha co bnabdiidz zho lo zho dieṉ palal nzëëb zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Rëb zha co: “Tib gayoo tamb nceit nac miṉe nzëëb naa lo me.” Dzigo rëbchaa zho: “Nliw, lalga quia lo tib val ne psaṉ luu nu. Ledaa val co nu, zac ctsieez luuw; bzhixcuaa stiba, pquiaa lo co, groḻ tamba zëëb luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bdziṉaque stib zha co, bnabdiidz zho lo zho dieṉ palal nac xquieḻqui zho lo meṉ co. Zha co rëb zëëb zho tib gayoo sac zhobxtil. Dzigo rëbchaa zho: “Nliw, lalga raquiet lo val ne psaṉ luu; per na zac ctsieez luu miṉ rii, bzhixcuaa stiba, pquiaa lo co tapgaḻaque saca zëëb luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","’Zeeṉe bieṉ meṉ co zha noyuṉ zho, bzee zdoo me goṉ me scataa ndzielguic zho. Ncuaaṉe ntoladza, per grëse miech ne zienaḻ ncuaaṉ lo guidzliu rii, ndzielguic zho par guṉ zho grë guieḻntseeb. Par miṉ co ndziibraa ndzielguic zho lo zha ne no xnëz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Saṉgue to gzoobladzde to guṉ to miṉ co, ncuaaṉe rap to lo guidzliu rii, goḻquiina per par guṉ to xyudar samiech to. Zeeṉe laa ncuaaṉ co grë, nenda zacnie zho to, per miṉe mazdraa non Diossi ible zacnie me to, zneedz me tib lugar ndzon cuëz to, led yedraa ga pe nitlo. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Zha ne ndzinli ruṉdziin teḻ palal yeeṉse ncuaaṉe riaaṉnie zho, scaque ndzinli guṉdziin zhow zeeṉe guiaaṉnie zho nrooba. Laa zha ne ndzinlid, miṉe guṉ zho zeeṉe guiaaṉnie zho ncuaaṉ zhis, miṉcoque guṉ zho zeeṉe guiaaṉnie zho ncuaaṉe nroob. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nana zha ne sca gacd ne ndzinlise guṉdziin zho ncuaaṉe no lo guidzliu rii, ¿zha dzigo grieelo guṉdziin zho ncuaaṉ ndzon ne gdeed Dios lo zho zaatne no me? ");
INSERT INTO zpmNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Stiba, teḻ sca ndzinlide to lo cheṉ beṉ, ¿pe naczhe ncuaaṉe guṉ to tib ncuaaṉe cheṉpaa to? ");
INSERT INTO zpmNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Goḻgona gaṉle, grieelod goṉ gleynie to dimi ni gleynieque Dios. Ib none teḻne Dios rleynie to, me none gleynie to, togo dimigaaw, dimi goḻleynie. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Grë zha ne nac farisé zeeṉe goṉ zho sca rnee me, leḻ rzhidznie zho me, sac teḻ zhaw rleyniedox zho dimi. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dzigo rëbchaa me lo zho: ―Masaque rzac to nalëë nli miech wen nac to nëz lo Dios, saṉgue me goṉ, wen wen naṉ me zha nac zdoo to. Nli miech ne raṉ to, zha wen rzoob zho to; saṉgue Dios ni lalnu rzacd zdoo me miṉe ruṉ to. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Leṉ dze ne gard guiaad Juan Bautist, niapse xley Moisés ni grë miṉe bnee zha ne biadteed xtiidz Dios, miṉ co nac miṉe güeynaḻ to. Per zeeṉe psilo Juan pseed me miech, desde hor co laa miech quiayacnaṉ stib mod ne grieelo ygaa zho zaatne rnabey Dios; gane na nzian zha ne noxco ygaa lugar co. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Per guiabde to togo nondraa ley, sac grëse miṉe zhobnee lo ley, ¡ib laaw none gac! ¡Zig nac guidzliu, zig nac gbaa zrieelo nitlow, saṉgue ley nitloda, tibaque naca! ");
INSERT INTO zpmNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Gacxe waa, grë zha bgui ne rsëbtsieel niina ni rtsieelnia zho stib wnaa, zha ne rtsieelniagaa tib wnaa ne psëëbtsieel, doḻ ga quiayuṉ zho; zigtaa doḻa padzeela, scaque niina doḻa. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Tib ricw name ―rëb Jesús―, niapse grë lar niazh racw me, gzobse dze ruṉ me lni lidz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Zaatne noque me ga, guiedz co no tib zha prob lë Lazh, lala prob me ni rlanaque me guiedz, gdipse lad me noyacnë guiedz co. Riese me riesob me ro lidz zha ricw co, ");
INSERT INTO zpmNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","rquiambëz me dieṉ pe grieelod gow me maase ncuaaṉe rrieengaale lo xmezh meṉ co; ga zob me haxta rdziṉ grë mëcw rzëëludz ma lo guiedz ne rlan me ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Bdziṉ dzew laa Lazh gut, dzigo biet xanjl Dios beynie zho me lo Abraham, zaatne rdziṉ grë zha wen. Goc palal dzew, laa meṉ ricw co gutaque, blozhse pquianap zho me, laa zho güeyqueets me; ");
INSERT INTO zpmNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","zeeṉe biaa me biini laa me nole gabiḻ. Lëbdraa me no me lo guieḻnë co, lega naclew blis lo me, zit squi goṉ me Abraham, laa Lazh zobnie Abraham ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Horco bnab me lo Abraham siguieḻ Abraham cxeeḻ me Lazh, maase guic mzhugniase Lazh yquiaa Lazh nis tsiegadz Lazh lo ludz me; sac lëbdraa me lo guidox ne no me ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dzigo rëbchaa Abraham lo me: “Xin, psoladz gaṉle zeeṉe wban luu lo guidzliu, ncuaaṉe gocladztaa luu pquianie luuw; laa Lazh mbanse bded me. Nagaa na, me nac meṉ ne nogaa noyaṉ guieḻbley, laa luu bgaa squi no luu lo guieḻnë qui. ");
INSERT INTO zpmNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Stiba, zha ne no nëz rii gacd guiaad zho i, niicle zha ne nogaa iw, gacd guiaad zho nëz rii; sac no tib yeedox ne rtse.” ");
INSERT INTO zpmNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Bzhiguieḻ sca”, rëb meṉ ricw co, “pxeeḻ Lazh tsie me lidz pxoz naa, ");
INSERT INTO zpmNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tsienie me diidz lo zgaay bets naa zha ne biaaṉ, guiab me lo zho ib guṉd zho miṉe beṉ naa, zeeṉa guiaate zho nu ygaa zho lo guieḻnëdox rii.” ");
INSERT INTO zpmNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pquiabchaa Abraham, rëb Abraham: “Teḻ miṉcow, tsow glab zho lo grë ley ne psaṉ Moisés, lo grë miṉe bnee grë zha ne güeyteed xtiidz Dios, beṉque lo co zhobnee zha no gban zho.” ");
INSERT INTO zpmNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Nliw”, rëb me, “per teḻ squi tib meṉ ne gutle tsie tsienee lo zho, rieṉ naa znuse csaan zho xquieḻntseeb zho gbig zho lo Dios.” ");
INSERT INTO zpmNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Dzigo rëbchaa Abraham: “Teḻne rond zho miṉe rnabey grë ley ne psaṉ Moisés, grë miṉe bnee zha ne güeyteed xtiidz Dios, scaque gond zho diidz niicle tsie tib zha ne brieebanle tsienee lo zho.” ");
INSERT INTO zpmNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tib vuelt rëb Jesús lo xpëëdscuel me: ―Nac lo guidzliu rii, ib guṉfalte ncuaaṉe rgogui miech guṉctal zho xtoḻ zho, ¡per probsaxe zha ne rquiil samiech ruṉctal zho xtoḻ zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mazd zhi guieḻnëw lo zho ygadoo tib quie molin zhobxtil yaṉ zho tsieroṉ zho zho nisdoo, lëdle guieḻnëdox ne gaṉ zho; sac goṉ doḻ nroob ga guṉ zho yquiil zho zha ndooladz ne no xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Goḻguieṉ sca ndzinli goḻgac! Tib bets tow, zeeṉe pe tib falt guṉ zho lo to, goḻnee lo zho guṉdraa zhow; teḻne gnab zho perdon, goḻguṉ zho perdon. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Niicle teḻne nzian vuelt sca guṉ zho falt lo luu tib dze, beeṉ zho perdon zeeṉe laa zho rbig rnab zho perdon lo luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Stib dzew, rëb zha ne rzënie me lo me: ―Bneedz guieḻbiini lo no dib zdooraa no gnalo no Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pquiab me rëb me: ―Teḻ niaca miṉe gzoob ne rnalole to Dios siquier lal tib midz moxtaz, niicle ncuaaṉe mazdraa ngaṉ gnab to lo me, zuṉ mew. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’¿Pe raṉ to gaṉle, zha nac zha ne ruṉ xtsiiṉ beṉ? Zeeṉe rbire zho dan, yase güey zho gon, güeygaa zho güeyquianap zho ma, pe liaadz meṉ ne quia zho xtsiiṉ ga, guiab me lo zho: “Na bded, bzob, zeeṉa gowxtsee luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Miṉe ruṉ me, gloque rnabey me zho guṉlo zho ncuaaṉe gowxtsee me, gdziib zhow lo me; rlozhraa row me, dzigoraa rowxtsee zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Niicle scataa ron zho miṉe rnabey me, ni rlozh ga, per ni xquizh rdeete me lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Scaque to nagoṉ, zeeṉe lozh guṉ to grë dziin ne pso Dios to guṉ to, peet yquiambëzde to, goḻguieṉ tib nguṉdziinse nac to, miṉe rieguiaḻ to ga, miṉ co beeṉ to. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Laa Jesús no nëz zie me nëz Jerusalén. Laa me zieded tib guiedz win ne riaaṉ zaatne ndzieel xtan Samar xtan zha Galilé, ");
INSERT INTO zpmNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","zeeṉe brieequia tsii zha ne rlan guiedz lepr. Zit zo zho, ");
INSERT INTO zpmNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","nguiedz rbedz zho me, rnab zho lo me yquia zdoo me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Zeeṉe goṉ me zho, rëbchaa me lo zho: ―¡Goḻtsie, goḻtsielulo lo pxoz, zeeṉa gaṉ zho gaṉle laa to biacle! Dzigo laa zho zie. Nëz no zho laa zho biaaṉmbe lo guiedz co. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Lo gza zho, hor co rias tib zho wbire, nguiedz rnee zho: ―¡Zha ndzontaa Dios! ¡Goḻwi gaṉle laa me beeṉguiacle naa! Zigne bdziṉ zho lo Jesús, pquiitsgzhib zho lo me, haxta bdziṉ lo zho lo liu, rdeed zho xquizh lo me. Tib zha Samara, zha zit nac zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Dzigo rëbchaa Jesús: ―¿Yoraazhe grë zha co waa? Conque tsii zho name beeṉguiac naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Tibaque zha zit rii dzigo lëë rzac zdoo miṉe beeṉ Dios lo zho? ");
INSERT INTO zpmNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dzigo bliso me zha co ga, rëb me lo zho: ―Porne dib zdoo luu goṉ bnalo luu Dios, gane biac luu. Bzë, peet tsieniedraa guic luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tib dze bnabdiidz zha farisé lo Jesús, rëb zho: ―¿Poc dzigo csilo gnabey Dios lo ne? Dzigo pquiab me rëb me lo zho: ―Gacnaṉ to gaṉle, nacd miṉ co ncuaaṉe gaṉlopaa miech. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Grieelod guiab zho laaw psilo nec, laaw psilolegaa nëz rii; sac goṉ teḻ niina laa me quianabeyle nu. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bded ga, rëbchaa me lo xpëëdscuel me: ―Zdziṉ dze, gacladz to tebaa zha znu so naa lo to maase tibaque dze, per gacdraaw. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Leṉ dze co, zio zha ne gnë lo to: “Goḻtë gaṉle laa Mgui ne pxeeḻ Dios bdziṉ nu”; gnëgaa zho pa stib lugar none tsie to par gaṉ to naa; tsienaḻde to, gliladzde to xtiidz zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sac zeeṉe gbiire guiaḻ naa, grëse miech gaṉa. Zig nac teḻ guiab tib belye nroob ne glu zhan gbaa desde nëz ne rlan ngbidz haxta nëz ne rzëëb ngbidz, ¿niacxe gaṉd grëse miecha? ");
INSERT INTO zpmNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per ansraa ne gac miṉ co, ible nroob guieḻnë ne cteed miech rii naa, ni lalnu gaṉdzed zho naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Leṉ dze ne guiaḻ naa ga, grë miech ne ndxie lo guidzliu gaḻ hor co, zhaa grë ncuaaṉe tsonie guic zho. Rsoladz to gaṉle zha rac miech leṉ dze ne biaad Noé, leḻ lo grë zhilni zho no zho, zha ne notsieelnia, zha ne nobediiṉ xpëëd, tibaque zeeṉe biaa zho biini laa guiedox co psilole. Laa Noé nole leṉ barcw, laa zho biaaṉ grëse zho bnitlo lo nis co. Scadaa nagoṉ no miech leṉ dze ne guiaḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Zig racgaa miech Sodom leṉ dze ne briee Lot ga. Scaque, loxaque ncuaaṉ lo guidzliu rii noxco zho, zha ne no lo zhilni, zha ne no zhiwto, zha ne nozigaa, zha ne quia gon, zha ne quiazhixcuaagaa lidz. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lega naclew, zeeṉe laa Lot briee, hor co laa tib guidox biet gbaa, notsa zufr bliaaḻa lad guiedz co, grëse miech co bnitlo lo guidox co. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Scapaa nagoṉ rac miech ne ndxie lo guidzliu leṉ dze ne laa naa guiaḻ. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Zha ne lëëtaque hor co no glaa guic yu, ib guiabd zho sëëb zho leṉ yu tsiebee zho ncuaaṉe no leṉ lidz zho, zha ne quiagaa lo dziin dana, ib guiabd zho gbi zho guey zho ro yu. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¡Goḻsoladz gaṉle zha bzhaac wnaa ne goc tsieel Lot! ");
INSERT INTO zpmNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Grëse miech, zha ne sca rquianë zdoo grë ncuaaṉe rap zho, ible znitlo zho xquieḻmban zho; saṉgue zha ne rquiad zdoo grë ncuaaṉ co, haxta xquieḻmban zho rbeeladz zhow, nitlod zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Gaḻ hor co, zaatne tipse nixguies chop zho, tib zho sënaḻ zhits naa, laa stib zho guiaaṉ. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Zaatne tipse quiayot chop wnaa, zaatne tipsegaa quia chop mgui lo dziin dana, tib zho sënaḻ zhits naa, laa stib zho guiaaṉ. ");
INSERT INTO zpmNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dzigo rëbchaa xpëëdscuel me lo me: ―¿Pa lo dzigo gdziṉ grë zha co? Pquiab me rëb me: ―Horco bii zlu gaṉle paw. Zig nac grë pech, zaatne nix magut ga rdziṉ ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","2","Stib dzew, bzodiidz Jesús tib cuent lo xpëëdscuel me, par guieṉ zho ib guiaaṉd zdoo zho zeeṉe racniobd miṉe quianab zho lo Dios, rëb me: ―Tib guiedz name, no tib meṉ co nac me wxtis, ni palal rquiad zdoo me samiech me, per ni Dios rdziebd me. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Guiedz coque no tib zhuz viud, gzobse dze rie zhuz co rienab zhuz guṉ me guieḻwxtis, cuedz me tib zha co rlëë lo zhuz. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Glo ib rquiaadiagd me miṉe rnab zhuz co, per zeeṉe goc palal dze goṉ me tibaque quia meṉ co quianab me gac guieḻwxtis, dzigotaa rëb me: “Ncuaaṉe lëbdraa guic naa lo meṉ rii, tibaque squi quia me. Nli rdziebd naa Dios, niicle nodgaa naa liaadz pe rzac miech, per parne guiadguṉneetraa me naa, miṉe naca mazd laa naa guṉ guieḻwxtis ne rnab me.” ");
INSERT INTO zpmNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Blozhse bzodiidz Jesús cuent co, rëbchaa me lo zho: ―Teḻne sca bdziṉ dze ne pquiaadiag zha ntseeb co miṉe bnab wnaa viud co, ");
INSERT INTO zpmNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿pe leḻ Dios dzigo yquiaadiagd xtiidz zha ne ngab lo me, teḻ tibaque gnab zho miṉe racladz zho? ");
INSERT INTO zpmNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","¡Nligaa, ib tedsod zuṉ me miṉe rnab zho! Per segur zhis zho quiambëz gac xquieḻwxtis me, zeeṉe laa naa guiaḻ stib. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Laa grë zha ne riats, zha ne rzac masaque zha wen nac zho nëz lo Dios, haxta rbix zdoo zho raṉ zho grëraa miech, bnee Jesús lo zho, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Chop zha name, bdziṉ zho leṉ yadoo ziezodiidznie zho Dios. Tib zho nac zha farisé, stib zho nac zha ne rtop dimi ne razh lo rey Roma. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Zha ne nac farisé ga, psilo zho rnee zho: “Dios, rnedz naa xquizh lo luu, sac nacd naa zigne nac grë miech ngoopdoḻ, zig nacse zha ne zo i. Wlaltaa ruṉd naa guieḻgbaan, ruṉd naa guieḻntseeb, niicle rquiangoobd naa stib wnaa. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Haxta chop vuelt rcuan naa tib leṉ zhmal, grëse ncuaaṉe ruṉ naa gan, ruṉ naaw tsii lal, rnedz naa tib lal miṉe rieguiaḻ luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Laa zha ne rtop dimi ne razh Roma ga, gaxaque ga zo zho, per nquiitsruṉse zho liu. Mban rac zho, quiase nia zho zdoo zho, rnee zho lo Dios: “¡Dios, rnab naa lo luu pquia zdoo naa znutaa miech ngoopdoḻ nac naa!” ");
INSERT INTO zpmNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","’Gneli naa lo to gaṉle ―rëb Jesús―, mazdraa goṉ wen biaaṉ recaudador co lo Dios, lëdle zha farisé co. Sac zha ne lëëque zha ruṉnon zho, racnond zho lo Dios, laa zha ne riaaṉwin, ruṉnon me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tib dze, nzian meṉ ne bdziṉ lo Jesús, bdziṉnie zho xpëëdlas zho lo me, parne cxobnia me guic win guṉlay me win. Grë zha ne nac xpëëdscuel me, leḻ psilo zho ndox zho lo grë zha ne bdziṉnie grë mëëdlas co. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Zeeṉe goṉ me sca quiayuṉ zho, dzigo bredz me zho, rëb me lo zho: ―¡Ctsirede to grë mëëdlas yeeṉ qui! ¡Goḻsaan guiaad win lo naa! Sac goṉ grë mëëdlas yeeṉ qui, ni zha ne nac zig nac win, zha co nac zha ne sëëb ygab lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nligaa zha ne gacndooladzd, zha ne gliladzd dib zdoo, zigne ruṉ grë mëëdlas, grieelod gdziṉ zho zaatne rnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tib vuelt, wbig tib meṉ ne nac zha non lo meṉguiedz Israel, rëb me lo Jesús: ―Naṉ naa luu nac tib meṉ ne noseed miech, ni tib meṉ wen nac luu, ¿bnë lo naa dieṉ, pe nac miṉe guṉ naa parne grieelo ygaa naa guieḻmban ndzon ne gdziṉd dze lozh? ");
INSERT INTO zpmNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Pquiab Jesús rëb me: ―Rnee luu lëë tib miech wen nac naa. ¡Nligaaw, Diosse goṉ nac meṉ wen! ");
INSERT INTO zpmNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Teḻne nli racladz luu ygaa luu guieḻmban co, none tsoxco luu gban luu zigne nac Xley Dios. Naṉle luu gaṉle zha naca, rneew: Tsonied luu zha ne led tsieeld luu, gute luu samiech luu, cuand luu samiech luu, yquiadiidzguizhd luu samiech luu. Goṉ pxoz luu, goṉ xniaa luu, cueed luu xquieḻto me. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dzigo rëbchaa meṉ co: ―Maestro, grëse miṉe bzeet luu i, ni tiba gard quits naa wlal ne nac naa zha nguieg. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Horco rëb Jesús lo me: ―Stibaque miṉe rquiin guṉ luu. Güey, güeyto grëse ncuaaṉe quianie luu, dzigo bdiiz dimi co lo grë zha mban ne guieṉd pe yquiin; sca nroobraa guieḻnzaac ne ygaa luu gbaa. Lozh ga, dë, dënaḻ zhits naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Zeeṉe bin meṉ co sca rëb Jesús, mbanse rac me laa me zey; sac nroob ncuaaṉe quianie me. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Dzigo rëbchaa Jesús lo xpëëdscuel me: ―¡Zha ngaṉtaa lëë, rzac zha ne squi rapcheṉ sëëb zho xnëz Dios gnabey me zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mazd ngaṉdse rded tib camell guieer guzh. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Grë zha ne ndxie ga, zeeṉe bin zho sca rëb me, rneechaa zho: ―Teḻne scataa ngaṉ sëëb miech xnëz Dios, ¿chosezhe dzigo waa nac zha ne zrieelo sëëb xnëz me? ");
INSERT INTO zpmNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dzigo rëbchaa Jesús: ―Nligaa par miech, zootle tsod zha ne grieelo sëëb xnëz me; saṉgue me naṉ me no zho. Sac teḻ me, tsod ncuaaṉe grieelod guṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Horco pquiab Pedr, rëb Pedr lo me: ―Teḻ no, grë ncuaaṉe rdziaapse no psaṉ now, laa no ziaadnaḻ zhits luu. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Pquiab me rëb me: ―Goḻgacnaṉa gaṉle, grëse zha ne psaṉ lidz, psaṉ zho tsieel zho, psaṉ zho xpëëd zho, psaṉ zho pxoz zho, psaṉ zho xniaa zho, psaṉ zho bets zho, bziangaa zho, porne bzëëb zho xnëz Dios, ");
INSERT INTO zpmNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na lo guieḻmban riique, mazdraa nroob miṉe gaṉ zho, ni lozh ga ib tedsod zgaa zho guieḻmban ndzon ne gdziṉdraa dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ne sca no Jesús nëz zie me nëz Jerusalén, tibaque bredz me gza tsiipchop zha ne rzëniepaa me ga, bzeet me lo zho zha guṉ miech me, rëb me: ―Grëse miṉe bzeetle zha ne biadteed xtiidz Dios padzeela teed naa, niina ne laa ne gdziṉ Jerusalén, laaw gac cumplir. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ga gnaaz zho naa, tsielo zho naa ladznia grë zha ne nacdraa zha Israel, xidznie zho naa, squiaago zho naa, stsuc zho lo naa, ");
INSERT INTO zpmNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","zguiṉ zho naa, ni haxta zut zho naa. Per zeeṉe gac tsoṉ ngbidza, zriebaan naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Per ib bieṉd zho dieṉ zha nacne sca rnee me. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Laa Jesús bzëëb ro guiedz Jericó, miech guizhiu ne naḻ zhits me. Ro nëz co zob tib meṉ ne roḻd lo, rnab me gon. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Zeeṉe bieṉ me rlu nzian miech noded ga, dzigo bnabdiidz me dieṉ pe nacne scataa ziaad grë miech co ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dzigo rëb zho lo me, Jesús, meṉ Nazaret ziaad ga, zhits me ziaadnaḻ grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Horco psilo me nguiedz rbedz me, rnee me: ―¡Jesús, meṉ xtii rey David, pquia zdoo naa! ");
INSERT INTO zpmNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Grë zha ne ner, psilo zho ndox zho lo me parne guioog ro me, per leḻ hor cole nguiedzraa rbedz me Jesús, rnab me yquia zdoo Jesús me. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nacne zeeṉe bdziṉ Jesús gax zaatne zob me, blëz Jesús, bnabey Jesús güeyxi zho me. Bdziṉ me lo Jesús, rëbchaa Jesús lo me: ");
INSERT INTO zpmNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Pe nadieṉ guṉ luu naa? Pquiab me rëb me: ―¡Racladz naa guiac lo naa! ");
INSERT INTO zpmNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dzigo rëbchaa Jesús: ―¡Niinagazh goṉ laa luu gaṉ stib! Laa luu biac, sacne dib zdoo luu bnalo luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Horcogazh laa meṉ co psilo bui, iṉe rley me rooḻnie me Dios, laa me zienaḻ zhits Jesús. Haxta grë miech ne zienaḻ ga, zeeṉe goṉ zhow, ye zho rooḻnie zho Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Guiedz Jericó, ga no tib meṉ ne rnabey lo grë zha ne rtop dimi ne razh lo rey Roma, lë me Zaquew. Zeeṉe laa Jesús zieded lad guiedz co, ");
INSERT INTO zpmNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","briee me, ziewi me, sac racladz me guṉbey me Jesús. Bdziṉ me, pasëse me gaṉ me Jesús, sac lala miech guizhiu ne naḻ zhits Jesús, ni lala ndopse me. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Miṉe beeṉ me, rias me bdedner me güeytsep me tib lo yag guigw zob ro nëz co, par gdeeda diidza gaṉ me Jesús, zeeṉe laa Jesús ted ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zeeṉe laa Jesús bded ga, blis lo Jesús goṉ Jesús laa me zob ga, dzigo bredz Jesús me, rëb Jesús lo me: ―Zaquew, na zeeṉa biet i. Sac racladz naa, lidz luu cuëz naa nadze. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Rley Zaquew goṉ Zaquew sca rëb Jesús, lëëlëd biet me lo yag co, laa me zienie Jesús nëz lidz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Zeeṉe goṉ grë miech cow, rlëë zho, rnee zho: ―¡Pe lëëtaa lidz zha ngoopdoḻ qui ziebëz me! ");
INSERT INTO zpmNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Laa Zaquew, iṉe rley zobnie Jesús. Tibaque bzoli Zaquew, rëb Zaquew: ―Gacnaṉ luu goṉ, lo grë ncuaaṉe rap naa, laa naa gded groḻa ygaaz lo grë zha ne guieṉd pe yquiin, ni teḻ nogaa zha ne ndziibraa miṉe beeṉquizh naa zho, naa maase ctsiree naa tap lal miṉe blan naa zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Horco pquiab Jesús, rëb me lo zha ne ndxie ga: ―I nagoṉ rlu laa meṉ qui wbigle lo Dios, parne ycaania Dios me. Nli zha xtii Abraham nac me, per bzonziaab me ");
INSERT INTO zpmNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ni naa ne nac naa Mgui ne pxeeḻ Dios, ible laa naa ziaḻ ziaḻsilaa naa grë zha ne zonziaab. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Grë miech ne zienaḻ zhits Jesús ga, rzac zho zigne laa me gdziṉ Jerusalén, laa me sob gac me zhirey zho; nacne bzodiidz me tib cuent rii, rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","―Tib xpëëd zha non name, no me tib guiedz win, nacle diidza laa me no tsie zaatne zob meṉ nroob ne rnabey, parne gzo zho me gac me rey guiedz ne no me ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Zeeṉe laa dze co bdziṉ, dzigo bredz me tsii zha ne quia xtsiiṉ me, nroob dimi ne psaṉ me lo zho tib tib zho, parne guṉdziin zhow, mientras gbire me. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","’Nzianlaa zha ladz me, rlëë zho raṉ zho me, dzigo pxeeḻ zho bla zha ne güey lo meṉ ne rnabey ne zie me ga, güeynab zho gdeete meṉ co dziin co lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Per niicle sca güey grë zha co, peet brieelod niuṉ zho. Blozhse bzo rey co me, laa me bdziṉ ladz me. Zeeṉe bdziṉ me, bredz me gza zha ne biaaṉnie xtimi me ga, par dieṉ palal ziyaca. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Bdziṉ tib zho, rëb zho: “Laa xtimi luu nu goṉ, tsii lal miṉe psaṉ luu ga naca niina.” ");
INSERT INTO zpmNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Rley me rëb me lo zho: “¡Zha squi nagoṉ racladz naa! ¡Wen brieequia xtsiiṉ luu! Niicle zhis ncuaaṉe psaṉ naa lo luu, per bieṉ luu niowse beṉdziin luuw. Na nagoṉ, laa naa gzo luu, gnabey luu tsii guiedz.” ");
INSERT INTO zpmNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bdziṉ stib zho, rëb zho: “Laa xtimi luu nu goṉ, gaay lal miṉe psaṉ luu lo naa ga naca niina.” ");
INSERT INTO zpmNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Scaque rley me. Bzo me zho gnabey zho gaay guiedz. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Zeeṉe bdziiṉtaa tib zho, rëb zho: “Nli beṉdziind naa xtimi luu, sac naṉle naa zha nac luu, niicle paraa niuṉdziin naaw, grëse miṉe niuṉa gan lo luu niaaṉa; gane mazd pquia naaw tib lë lo lar, blootsow naaw, ledaaw nu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Blëë guic me, rëb me lo zho: “¡Biche nu, paat rquiind naa miech yozh ne squi nac! Conque naṉle luu zha nac naa, ");
INSERT INTO zpmNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿pex nac dzigo waa bioxcod luu maase mbediiṉ luu dimi qui, ndziniaaw palal ncaania naaw niina?” ");
INSERT INTO zpmNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dzigo rëbchaa me lo grë zha ne ndxie ga: “Niinagazh goḻcob dimi qui nia zha qui, goḻdeeda lo zha ne ziaadnie tsii lala i.” ");
INSERT INTO zpmNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pquiab zho rëb zho: “Per pe nacne zha coque ycaaniaw, ni nrooblew beeṉlo zho.” ");
INSERT INTO zpmNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ib sca no gaca”, rëb me, “sac zha ne rieṉ zha guṉdziin zho ncuaaṉe rcaania zho, nroobraa ncuaaṉe ycaania zho. Laa zha ne squi nac, haxta miṉe pcaaniale zho, zdiooba lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Saṉgue zha ne sca ptsidiḻ niac naa rey, goḻtsiexi zho, niinaga racladz naa gaṉlo naa gut to zho.” ");
INSERT INTO zpmNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Blozhse bzodiidz Jesús cuent co lo zho, laa zho bio nëz stib, nerse me lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Zeeṉe bdziṉ zho gax Gui Oliv, zaatne ndxie guiedz Betfagé ni guiedz Betain, pxeeḻ me chop xpëëdscuel me, ");
INSERT INTO zpmNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","rëb me lo zho: ―Goḻtsie guiedz win ne ndxie daṉse lo ne i. Ga gdziṉ to zaatne quiadoo tib burr yeeṉ ne choot gard sob lad, dzigo goḻxadz ma, goḻtënie ma nu. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Teḻ cho gnabdiidz lo to pe nacne noxadz to ma, goḻguiab lo zho: meṉ ne rnabey ne, meṉ co rquiin ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Laa zho zie. Bdziṉ zho, zaatne quiadoo burr co, ");
INSERT INTO zpmNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","nligaa, lëëtaque noxadz zho ma, zeeṉe laa bizhuan ma bdziṉ. ―¿Pe guṉ to xpurr naa? ―rëb me lo zho―. ¿Pe nacne noxadz to ma? ");
INSERT INTO zpmNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dzigo rëbchaa zho: ―Meṉ ne rnabey ne, meṉ co rquiin ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bdziṉnie zho ma lo Jesús, pxob zho lar ne rbix zho lad ma, bzob me ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Zigse zie me, no grë miech guizhiu co rta zho xab zho ro nëz rded burr ne zob me ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Grëse miech co, rleynie zho me. Laa zho xiuxto dze cho gui Oliv, zeeṉe psilo zho nguiedz zëëb tsi zho, rley zho rooḻnie zho Dios, por grëtaa milagr ne ziyaṉ zho ruṉ Jesús; ");
INSERT INTO zpmNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","rnee zho: ―¡Nasi laa Dios pxeeḻ zhirey ne! ¡Zha ndzontaa Dios! ¡Haxta gbaa noyac guieḻbley dze rii! ");
INSERT INTO zpmNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Blalaa zha farisé ne zienaḻ ga, zeeṉe goṉ zho zha rooḻnie grë miech co me, wbig zho lo me, rnab zho gnee me lo zho guioog ro zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dzigo rëbchaa me: ―¡Zac guioog ro zho, per hor co dzigo laa grë quie rii csilo gooḻniew naa! ");
INSERT INTO zpmNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Zeeṉe bdziṉ me zaatne nieeṉpaa Jerusalén, psilo biab guieḻnë me, biin me goṉ me guiedz co, ");
INSERT INTO zpmNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","rëb me: ―¡Prob to meṉ Jerusalén! ¡Tebaa ye to nieṉ niuṉbey to meṉ ne needz guieḻbley rii lo to! Per na ib bieṉde tow, masaque rzac to zig zha ne nioog lo. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na nagoṉ laa dze co bdedle. Grë zha ne rlëë lo to, ible ziaad zho ziadsioog corral zho to, ni tib nëz tedlaade to lo zho, ");
INSERT INTO zpmNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","haxta guiab to ladznia zho, grë xpëëd to. Znitlo zho ladz to, nëzrii nëzrec glaaḻ zho grë quie ne niaa grë lidz to i; sac squi beeṉ to ib pcaaniade to Dios, zeeṉe biaadpaa me nsilaa me to lo xtoḻ to. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Bdziṉ me Jerusalén, güey me yadoo, psilo me blee me grëse zha ne noyuṉ lgui ga, rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","―Znu zhobnee lo Xtiidz Dios: “Zaatne nac lidz naa, ga none guiaad miech gzodiidznie zho naa.” Laa to goṉ, quiayuṉ to lugar rii zig tib zhibliee ngbaan. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bded ga, gzobse dze rie me rieseed me miech leṉ yadoo ga. Nacne psilo grë pxoz ne rnabey, grë maistr ley, ni grë zha ne nac zha non lo meṉguiedz, quiaguib zho dieṉ zha gdeeda diidz gut zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Per rdzield zho dieṉ zha guṉ zho, sac tibaque ndxie miech lo me, grëse zho rquiaadiag zho zhiwseed me. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Leṉ dze ne sca noseed me miech leṉ yadoo, nonee me lo zho zha nac Xtiidz Dios, tib vuelt bdziṉ bla zha ne nac pxoz ne rnabey, grë zho bla maistr ley ni zla meṉ ne nac meṉ non lo meṉguiedz, ");
INSERT INTO zpmNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","rnabdiidz zho lo me dieṉ cho nac me, cho rnabey me, zha nacne sca quiayuṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Dzigo rëbchaa me lo zho: ―Ye naa laa naa guṉ tib wnabdiidz lo to. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Goḻnë dieṉ cho pxeeḻ Juan zeeṉe biadchoobnis Juan miech, ¿pe Dios pxeeḻ Juan, te miechsew ye? ");
INSERT INTO zpmNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Psilo zho rnabdiidzlsa zho dieṉ zha ctsire zho lo xtiidz me, rnee zho: ―Teḻne dzieets ne Dios pxeeḻ Juan, dzigo laa me gnë: “¿Pex nac dzigo waa bliladzde to miṉe bnee Juan?” ");
INSERT INTO zpmNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Teḻ na dzieetsgaa ne, miechse pxeeḻ Juan, grieequiadaque ne; zgoquie meṉguiedz ne, sac grëse zho rliladz Dios pxeeḻ Juan. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dzigo mazd lëë gdib miṉe beeṉ zho, rëb zho naṉd zho dieṉ cho pxeeḻ Juan. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nacne rëbchaa Jesús lo zho: ―Niicle naagaa nagoṉ, grieelod gni naa lo to cho rnabey naa quiayuṉ naa grë miṉ rii. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Blozhse ga, biire psilo me noseed me grë miech co. Bzodiidz me tib cuent rii lo zho, rëb me: ―Tib meṉ name, nroob lbë uv beeṉbni me lo liuṉ me. Blozh ga blediiṉ me liu co lo bla zha ne ran liu, dzigo laa me briee ga, zey me stib dan. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","’Zeeṉe goḻ mëë ne laa nex co gol, pxeeḻ me tib zha ne quia xtsiiṉ me zie lo zha ne quianap liuṉ me ga, parne gdeed zha co nex ne rieguiaḻ me ycaa me. Per leḻ bnaaz zho zha ne pxeeḻ me ga, bdiṉ zho zho, blozh ga scase bzonëz zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wbiire pxeeḻ me stib zho, scaque peet bdeete zho lo zho, leḻ ndox zho lo zho, bdiṉ zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pxeeḻaque me stib zho, goc zho tsoṉ, scasaque beeṉ zho, haxta psiwee zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Quianie me tib mëëd, rleynie me mëëd co. Zeeṉe goṉ me sca beeṉ zha co, rëbchaa me: “Miṉe naca laa naa cxeḻ xpëëd naa, zeeṉe gaṉ zho xpëëd naaw, peet guṉd zho me, nend zon zho xtiidz me.” ");
INSERT INTO zpmNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","’Pex guieṉ zho cho nac xpëëd me, zeeṉe goṉ zho meṉ co, rëb zho: “¡Lëë zha qui nagoṉ guiaaṉnie liu rii! ¡Goḻgotsaa dziuut ne zho, zeeṉa guiaaṉa lo ne!” ");
INSERT INTO zpmNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bnaaz zho xpëëd me, güeynie zho me zaatne nac tib lad lo liu co, ga güeygut zho me. ’¿Zha sca dieṉ rzac to guṉ bizhuan liu co gza zha ntseeb co? ");
INSERT INTO zpmNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ib tedsod lëë, zeeṉe gbire me, znitlogazh me zho. Lozhse ga, cuediiṉga me liuṉ me lo zla zha ne guṉdziina. Zeeṉe bin zho sca rëb me, rneechaa zho: ―¡Ib lic Dios qui, dziuuṉscad no! ");
INSERT INTO zpmNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dze bui me lo zho, dzigo rëbchaa me: ―Per led znu lëë, zhobnee lo Xtiidz Dios: “Quie ne psëëb zha ne nozaa yu, ni naṉd zho lëëpaa quie co nac miṉe rnazdziits yu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","’Ni quie co goṉ, zha ne tsietsobe low, zac zho zig tib ncuaaṉe rac tsoṉ tap lë; laa teḻ lëëgaaw tsobe lad zho, zac zho zig tib ncuaaṉe die die rac. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Grë zha ne nac pxoz ne rnabey, ni grë maistr ley, hor co bieṉ zho miṉe nac zho ga, bzeet me lo cuent co. ¡Gocladz zho gagazh naaz zho me! Per bdzieb zho, niacntseeb grë miech ne ndxie ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dzigo miṉe beeṉ zho, pxeeḻ zho bla zha ne zie zieguṉgüet me par cxiṉ me tib diidz, dzigo miṉ co yquiaaqui zho tsiezo zho me lo zhiwxtis zha Roma. Rquiaalo zha co, no zho liaadz dieṉ zha gzoobdiag zho xtiidz Dios, ");
INSERT INTO zpmNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","bdziṉ zho lo me, bnabdiidz zho rëb zho: ―Maestro, ndioṉ no niapse diidzli zienaḻ luu, ni scagaa zeeṉe rseed luu miech, rguibd luu guiaṉnziuu luu lo zho, sinque niapse miṉe nac diidzli, miṉe rlu zha sëëb zho xnëz Dios, miṉ co rnee luu lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gane niina, racladz no gnë luu dieṉ pe nonguieḻa ga rdeed no dimi ne razh lo rey Roma, te nonguieḻda ye. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bieṉga me racladz zho guṉgüet zho me, dzigo rëbchaa me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―¡Goḻneedz tib xpes to nu gaṉle! Dzigo bdeed zho tib pes lo me. Blozh ga, rëbchaa me lo zho: ―¿Cho nu? ¿Cho lë nu quia lo pes rii? Pquiab zho rëb zho: ―Lëë rey Roma i, lëë lë me i quia lo qui. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dzigo rëb me lo zho: ―Miṉe rieguiaḻ sca ycaa rey Roma, goḻdeeda lo rey Roma; scaquegaa miṉe rieguiaḻ ycaa Dios, lo Dios goḻdeeda. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bzee zdoo zho goṉ zho sca ptsire me lo xtiidz zho. Mazd dzese bre zho, sac bdzield zho zha niuṉgüet zho me; gocladz zho squi ndxie miech nxiṉ me pe tib diidz, per brieelod niuṉgüet zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Blozh ga, güeyaque zla zha saducé lo Jesús. Nac zha saducé rliladzd zho zdziṉ dze grieeban miech; bdziṉ zho, rëb zho lo me: ");
INSERT INTO zpmNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, znu psaṉ Moisés diidz: teḻne glo mgui guet lo wnaa ne nac tsieel mgui, ni gopd wnaa mëëd, dzigo none betsaque zho ctsieelnia wnaa co stib, zeeṉa gap wnaa mëëd ne guiaaṉ xlugar xpëëd zha ne gut ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","’Bio tib dii zha co znu bzhaac, gadz bets nac zho. Ptsieelnia zha ne nac zha gol, zeeṉe laa zho gut, biaaṉd xpëëd zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dzigo ptsieelnia wnaa co stib bets ngutoo co. Blozh ga, gutaque zha co, pa së zho nsaṉ mëëd. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ptsieelniaque me stib zho, goc zho tsoṉ, niicle zha co psaṉdaque mëëd. Sca sca haxta bza gza gadzse zho ptsieelnia me, ");
INSERT INTO zpmNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","tibaque zeeṉe yeque me laa me gut. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Miṉe racladz no gacndioṉ no, ¿chopaa dzigo gac tsieel wnaa co, zeeṉe laa zho grieeban, ne sca gza gadzse zho ptsieelnia me? ");
INSERT INTO zpmNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Pquiab Jesús rëb me: ―Tiba, gacnaṉ to gaṉle, lo guieḻmban riise rtsieelnia miech. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Zeeṉe grieeban zho, zig nac zha ne ygaa guieḻnzaac gdziṉ zho zaatne no Dios, led yedraa ga ctsieelnia zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Sac laa zho mbanle ga, gdziṉdraa dze guet zho. Masaque laa zho gac zig nac grë xanjl me, mëëd gac zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Laa stiba, gacnaṉ to gaṉle ible zrieeban grë meṉgut. Goḻwi gaṉle, zeeṉe bzeet Moisés zha rëb Dios lo me zeeṉe goṉ me tib yag zarz ne noyazbel ga; ga rlu rrieeban meṉgut. Rëb Dios lo me: “Naa nac Dios ne rliladz Abraham, naa nac Dios ne rliladz Isaac, naa nac Dios ne rliladz Jacob.” Zeeṉe sca rëb me, ga rlu gaṉle mban zha co. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Sac teḻ me, nacd me xDios meṉgut, sinque xDios zha mban nac me. ¡Par me, grëse zha ne ngab lo me, zha mban nac zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Blalaa maistr ley zo ga, goṉ zho sca rëb me lo zha co, dzigo rëbchaa zho lo me: ―Maestro, nli squi naca zigne rnee luu i. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dzigotaa ni stib zho beeṉdraa pe nabdiidz zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Horco bnabdiidz Jesús lo zho, rëb me: ―¿Zha nac dieṉ ne rnee zho tib xpëëdaque rey David gac Meṉ ne nacle diidz cxeeḻ Dios ga? ");
INSERT INTO zpmNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Led Davitaque name znu bnee tib lo salm ne pquiaa me: ");
INSERT INTO zpmNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Bnee Dios lo meṉ ne rnabey naa, rëb Dios lo me: “Cue naa nëz derech, nu bzob, nieeda lozh gnaz naa grëse zha ne rlëë lo luu, csaṉ naa zho ladznia luu.” ");
INSERT INTO zpmNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Gase gaṉle rlu, led scada; teḻne nli zha xtii David gac meṉ co, ¿zha nac dzigo ne lëëque David rnee ne me rnabey David? ");
INSERT INTO zpmNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Squi ndxie grë miech co noquiaadiag zho, zeeṉe bnee me lo xpëëdscuel me, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Goḻguieṉ goṉ, ib tsienaḻde to miṉe ruṉ maistr ley. Sac grë zha ne nac maistr ley, rdziladz zho racw zho lar nool, haxta zhits ni zho rbiba, rdziladz zho ndooladz rquiaabdiuzh miech zho zaatne rdzieel zho zho ro nëz. Zig nac leṉ yadoow, zha nac zha ne rzob lo xcan zaatne rzob grë zha non; zeeṉe riegaa zho tib lo lni lidz miech, lëëpaaze zha nac zha ne rzob groḻ mezh zeeṉe laa wagw rac. ");
INSERT INTO zpmNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ni rlozh ga, rio zho rla zho teḻ pe ncuaaṉe rapse grë wnaa viud; ni parne peet guiabd miech lo zho, xtse rzo zho rzadraa pe lay ne rooḻ zho. Sca ruṉ zho, ¡per ib tedsod nroob caxtigw ne ygaa zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Laa Jesús no leṉ yadoo ga noseed me miech. Ga no me, goṉ me zha rdziṉ grë zha ricw, nroob dimi rsaṉ zho leṉ alcancí ne zob ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tibaque zeeṉe bdziṉ tib wnaa viud, tib meṉ proba, ye me laa me psaṉ chop gaay win leṉ alcancí co. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Zeeṉe goṉ Jesúsa, rëbchaa me: ―Gneli naa lo to gaṉle, mazdraa goṉ non gon ne bdeed wnaa viud qui, lëdle grë gon ne psaṉ grë zha qui. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sac teḻ zha, dimi ne riaaṉle lo zho i rgogon zho; saṉgue wnaa prob qui goṉ, centav yeeṉ ne quianiese me, miṉe rnalopaa me gziuu pe yquiin me, per laa me bloogona. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Laa Jesús zieriee ga, zeeṉe psilo bla zha ne nac xpëëdscuel me, rlozhd gwi zho zha niaa yadoo co, rzee zdoo zho raṉ zho grë quie ne niaaw, grë ncuaaṉe ngaḻguiee leṉa. Zeeṉe goṉ mew, rëbchaa me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Niicle squitaa goṉ raṉ to niaaw niina, per zdziṉ dze ne nitlow, dib nacsew. Ni stib quie qui guiaaṉdraa zigne squi zhobxcuaaw i. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bded ga, bnabdiidz zho lo me, rëb zho: ―Maestro, ¿poc dzigo gac miṉe bzeet luu ga? ¿Zha glu zeeṉe laaw ziaadyob gac? ");
INSERT INTO zpmNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Dzigo rëbchaa me lo zho: ―Nsin goḻso, zeeṉa choot yquidiede to. Sac nzian zha ne grieequia, guiab zho laa dze co bdziṉle, guiab zho zha nac Meṉ ne zëëble diidz ga cxeeḻ Dios. ¡Ib gliladzde tow! ");
INSERT INTO zpmNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Zeeṉe gon to pa lo ndxiediḻ tib guiedz, pa lo noyacgaa grë diḻdox, ib gdziebde to. Ib none gac grë ncuaaṉ co, per lega loxaque miṉe csilosew ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","’Grë guiedz nroob, laaw tiḻnie saguiedz nrooba; grë zha ne rnabey grë guiedz nroob, laa zho tiḻnie sazha rnabey zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nëzrii nëzrec csilo gni grë zhodox, nzian zaatne gaṉ miech gbin, zaatne glaangaa zho grë guieḻguidzdox. Nzian grë ncuaaṉe glu zhan gbaa, nzian grë ncuaaṉ co, ncuaaṉe ctseb miecha. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Per ansraa gac grë ncuaaṉ co, stsidiḻ miech to, squianaḻ zho to; znaaz zho to, tsiezo zho to lo wxtis ne rnabey yadoo, zha co co to ladzguiib, ni haxta ziezo zho to lo wxtis ne rnabey guiedz, loxaque porne nac to zha ne no xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ga nagoṉ gdeeda diidz gnee to lo grë zha co, gacnaṉ zho gaṉle cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ib guṉde to tso to zhgab dieṉ pe guiab to lo zho, zeeṉe laa to ctsire lo miṉe rquiaqui zho to; ");
INSERT INTO zpmNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","sac naa gnedz guieḻbiini lo to, zeeṉe laa to gnee guieṉ to pe guiab to. Zha ne gona, squiaadiag zhow, per ni gdzield zho pe ctsire zho lo to. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","’Haxta pxoz to, xniaa to, bets to, grë meṉlidz to, grë zha ne ndzieeldiidz to, stsidiḻ zho to, lëëque zha tsielo to ladznia zha ne csacsi to. Lo grë to, zio zha ne haxta zet ladznia grë zha co. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Grëse miech glëë gaṉ to porne nac to zha ne no xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nli stiche zho xquieḻmban to lo guidzliu rii, per, ¡ni tib guits guic to, grieelod zho gnitlo zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tiblique sca goḻgac, sozite to lo naa, zeeṉa ygaa to guieḻmban ndzon ne gneedz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Zeeṉe gaṉ to igose guiedz Jerusalén ndxienap meṉguiib, naṉle to leṉ dze co laaw nitlo. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Grë zha ne no guiedz ne ngab Judé, none xooṉ zho tsie zho nëz yagui, ga tsietsolan zho. Zha ne no Jerusalén nu, none grieeniob zho. Grëgaa zha ne quia dziin dana, ib guiabd zho gbire zho lad guiedz. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tib guieḻnëdox ne csiaab Dios gaṉ grë miech rii leṉ dze co, ga gac grë miṉe raquiet lo Xtiidz me ted zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Prob grë meṉ wnaa ne lëëtse leṉ dze co zoney xpëëd, meṉ ne quianiegaa mëëd ne bii radz! ¡Mbandox ted miech, guieḻnëdox ne csiaab Dios gaṉ zho guiedz rii! ");
INSERT INTO zpmNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Zutxuu miech zho, zha ne tedlaagaa lo guieḻgut zeyzhoo miech zho, zhaase zhaase dan ne gueynie zho zho. Horco laa grë zha zit co, sëëb guṉcheṉ Jerusalén; haxta gdziṉ dze ne gnabey Dios griee zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Nzian grë ncuaaṉe glu lo ngbidz, glu lo mëë, glu lo mel. Mbanse gac miech, zdziebdox zho zeeṉe gon zho bidox ne tso tsasoli nisdoo. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nzian zha ne haxta scow zho lo dzeb, zeeṉe laa zho gaṉ grëtaa ncuaaṉe noyac lo guidzliu leṉ dze co. Grë ncuaaṉe no zhan gbaa, nëzrii nëzrec gaca. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Horco bii zaṉ zho gaṉle zeeṉe laa naa ziaḻzëëb tib lo xcow con grë guieḻndzon, con grë poder ne rap naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Zeeṉe gaṉ to laa grë ncuaaṉ co rsilo noyac, nley goḻco zdoo to; ¡sac hor co laa Dios ycaania to! ");
INSERT INTO zpmNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","’Goḻzoob cuidad gaṉle zha nac yag guigw, beeḻzegaa pe stib yag. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Led raṉ to gaṉle, zeeṉe laa grë zhicwa racnieeṉ, laa zhiblaga rsilo rdzib, gase ruṉbey to laa mëë nëëg ziaadgaxle. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Scaque nagoṉ zeeṉe gaṉ to laa grë miṉe rne naa lo to nu rsilo noyac, dzigo naṉle to laa dze ne csilo gnabey Dios ziaadgaxle. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Gneli naa lo to gaṉle, nzian grë miech ne mban niina, bii zaṉ zho zeeṉe laa grë ncuaaṉ co gac; sac ible ncuaaṉe gaca. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Zdziṉ dze ne nitlo gbaa, nitlo guidzliu, saṉgue miṉe rne naa lo to nu nitloda; ible laaw none gac. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","¡Nsin sca goḻso, zaacse goḻgac! ¡Adeḻ gaḻ dze ne laa naa guiaḻ, leḻ lo grë ncuaaṉe ndzinlid, leḻ lo guieḻgonziu, leḻ lo grë zhgab ne rac lo guidzliu rii no to, zigne guṉ grëraa miech! Sac goṉ, lega naclew glanso naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nligaa nsin goḻso. Tibaque goḻnab lo Dios, gacnieṉ me to peet gacde to lo grë guieḻnë co, iṉe peet xtoḻde to zeeṉe laa to gacredz lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Gzase leṉ dze co pseed me miech. Silgaw, miech guizhiu ne rdziṉ leṉ yadoo, parne yquiaadiag zho zhiwseed me. Guidze sca rseed me zho, laa pcow liu riebëz me cho Gui Oliv. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ziaadyoble lni Pascwa, zhilni nroob meṉ Israel, lni ne row zho guietxtil ne rquiad ncobi lad. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Grë zha ne nac pxoz rnabey ni grë maistr ley, leṉ dze co laa zho no quiaguib zho dieṉ zha gut zho Jesús. Noguib zho tib mod ne glisquid meṉguiedza; sac rdzieb zho gacntseeb meṉguiedz. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tib dzew, laa meṉdox bzëëb zdoo Judas Iscariot, tib zha ne rzëniepaa me ga, ");
INSERT INTO zpmNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","rias Judas güey Judas lo grë pxoz rnabey co, lo grë meṉ ne zo lo zha ne rquianap yadoo, rëb Judas zha csaṉ Judas Jesús ladznia zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Zeeṉe bin zhow per nli rley zho, nacne biaaṉ zho diidz quizh zho Judas. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Dzigo desde hor co psilo Judas noguib Judas dieṉ zha gdeeda diidz guieṉd miech csaṉ Judas me ladznia zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mer dze ne rsilo lni Pascwa, leṉ dze ne sca row zho guietxtil ne rquiad ncobi lad, ni rut zho carner yeeṉ ne rowxtsee zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dze co bnabey Jesús Pedr grop Juan tsieguṉlo zho xtsee ne gownie me zho wdze co. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dzigo bnabdiidz zho lo me, rëb zho: ―¿Pa lo racladz luu guio no guiodziuuṉlo now? ");
INSERT INTO zpmNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Rëbchaa me lo zho: ―Goḻtsie Jerusalén. Zeeṉe sëëb to lad guiedz, ga gaṉ to tib mgui nzobyaṉ tib re nis, goḻtsienaḻ zhits me. Yu ne gaṉ to sëëb me, ");
INSERT INTO zpmNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","goḻguiab lo bizhuan yu co: “Znu në Maestro, ¿pa leṉ yu me gneedz luu gac zaatne gowxtseenie me xpëëdscuel me wdze rii?” ");
INSERT INTO zpmNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ga glu me tib leṉ yu nroob ne riaaṉ glaa, nzhixcuaale leṉa, dzigo ga goḻguṉlo zhixtsee ne. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dzigo laa zho zie. Güey zho zaatne pxeeḻ me zho ga, ga beeṉlo zho xtsee co. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wdze co, zeeṉe goḻ hor xtsee laa Jesús bded lo mezh gza me gza tsiipchop xpëëdscuel me. Xtsee co no zho, ");
INSERT INTO zpmNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","zeeṉe rëb me lo zho: ―¡Blactaa goṉ pquiambëz naa gdziṉ dze rii, znu gowxtseenie naa to nawdze rii, ansraa csacsi miech naa, gut zho naa! ");
INSERT INTO zpmNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Lëë lultm vuelt nu goṉ teed naa lni Pascw rii, haxta gdziṉ dze ne laa Dios csilo gnabey, dze ne glupaa gaṉle zha nac xtsee rii. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dzigo bzheṉ me tib cop nroob no vin, bdeed me xquizh lo Dios, blozh ga bdeed me cop co lo zho, rëb me: ―Goḻquiin vin rii gza to. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gneli naa lo to gaṉle, lëë lultm vuelt nu guie naa vin rii, haxta gdziṉ dze ne laa Dios csilo gnabey. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ni bzheṉ me guietxtil, bdeed me xquizh lo Dios, blozh ga beeṉgroḻ mew bdiiz mew lo zho, rëb me: ―Goḻquiina, rrieequia goṉ lëë xcuerp naa i, sac goṉ znu guṉ zho xcuerp naa parne csilaa naa to grë to. Zeeṉe gdeedtaaw diidz, goḻguṉ miṉ rii parne glu to gaṉle tibaque rsoladz to naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Blozhse dowxtseenie me zho, scaque bzheṉ me stib cop no vin, blozhse bdeed me xquizh, rëb me lo zho: ―Lëë stib trat cub nu goṉ riaaṉ Dios grë me miech, rrieequia xchen naa nu nac vin rii, ren ne gzhiee xcuent to, ren ne tso firm trat co par glu nona. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ni gacnaṉ to gaṉle, lo mezhaque nu goṉ zob zha ne tsielo naa ladznia zha ne gut naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Naa ne nac naa Mgui ne pxeeḻ Dios, nli, ible none guet naa, parne gac miṉe pxeeḻ Dios naa ziaḻguṉ naa, ¡per probsaxe zha ne tsielo naa ladznia zha co! ");
INSERT INTO zpmNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Horco psilo gza zha ne zobnie me ga, rnabdiidzlsa zho dieṉ cho nac zha ne rzeet me ga; ");
INSERT INTO zpmNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","haxta psilo zho nodiḻdiidz zho dieṉ cho gac zha ne gacnon lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dzigo bnee me lo zho, rëb me: ―Nli grë zha ne rnabey guiedz ne ndxie lo guidzliu, masaque rnabey zho miech zig nac zeeṉe bzhii zho zho, per zha guṉraa miech, lëë gdib rxecw zho, haxta rnee zho nroob quiayuṉ zha co xyudar guiedz. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Saṉgue to goṉ, zha ne gnabey lo to, none guieṉ zho gac zho zig tib nguṉdziin lo to; zha ne racladzgaa gacnon, none guieṉ zho guiaaṉwin zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Lo guidzliu rii, zha ne rnabey, rzobse zho, zha ne nac nguṉdziin, zha co rdziib ncuaaṉe row zho. ¡Saṉgue lo ne, led scad naca! ¡Goḻwi gaṉle, tib nguṉdziin nac naa lo to! ");
INSERT INTO zpmNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Tose goc zha ne tibaque gocnie naa lo grëtaa miṉe bdeed naa leṉ dze rii. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Gane niina, laa naa gneedz tib guieḻnzaac nroob lo to ygaa to gdziṉ to zaatne bneedz Pxoz naa gnabey naa; ");
INSERT INTO zpmNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","zeeṉa iṉe znu tipse zioob ne lo xmezh naa ga, dioow ne, dio ne. Haxta so naa to, to gac zha ne cobey, pe nac miṉe beeṉ gza tsiipchop dii ne nac meṉladz to nu. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Horcoque bnee me lo Pedr rëb me: ―Bina gaṉle Pedr, racladz Satanás goṉ ycuiib ma to, zigne ruṉ zho zhobxtil. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Per laa naa bnable lo Dios, gacnieṉ me luu, csaand me sozitpaa luu lo naa. Gacxe waa, zeeṉe guieṉ luu lëda ga beeṉ luu, luu gnee lo grëraa zha qui, parne tibaque dib zdoo zho gnalo zho naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pquiab Pedr rëb Pedr: ―Niicxe peraa waa gac, csaand naa luu. Teḻne co zho luu ladzguiib, ye naa tso ga, ¡teḻne gutgaa zho luu, zaatne guet luu, ga guet naa! ");
INSERT INTO zpmNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","―Bina gaṉle Pedr ―rëb Jesús―. ¡Guieel riigazh goṉ, gardle ycuedz gall, tsoṉle vuelt rëb luu ruṉbeyd luu naa! ");
INSERT INTO zpmNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dzigo bnee me lo zho gza zho, rëb me: ―Led rsoladz to gaṉle zeeṉe pxeḻ naa to güeyseed to miech, scase güey to, peet dimi bide to, per ni ncuaaṉe gow to, per ni lab to bide to. ¿Pe beeṉfalt ncuaaṉe nquiin to hor co? Pquiab zho rëb zho: ―Beeṉfaltedew. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dzigo rëbchaa me: ―Horco nagoṉ peet bide to, saṉgue niina zha ne quianie dimi, zha ne quianiegaa ncuaaṉe gow zho, none güey zhow. Niina nagoṉ none laa to yquiin spad. Zha ne quianieda, none maase tib xab zho cto zho, si zho tiba. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sac nataa nagoṉ, laa miech cteed naa miṉe zhobnee lo Xtiidz Dios, zaatne rnee: “Bnabey zho gut me, zigne rut zho grë zha ntseeb.” Grëse miṉe zhobneele teed naa, ib laaw none gac niina. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pquiab zho rëb zho lo me: ―¡Bui gaṉle laa chop spad nule! Dzigo rëbchaa me: ―¡Mazd peet gnedraa naa lo to! ");
INSERT INTO zpmNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Blozhse ga, laa me briee zie me nëz Gui Oliv, zaatne rietaque me; zienaḻaque gza xpëëdscuel me zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bdziṉ zho ga, rëbchaa me lo zho: ―Goḻnab lo Dios gacnieṉ me to, zeeṉa yquiild meṉdox to. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bzë me spalal, bdziṉ me zig zaatne riab tib quie ne rcheḻ ne nia ne, dzigo ga pquiitsgzhib me, psilo me bnab me lo Dios, ");
INSERT INTO zpmNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","rëb me: ―Papá, laa naa rnab lo luu, teḻne zala zdoo luu, psilaa naa lo grë guieḻnë rii. Per teḻne grieeloda, miṉe gnëtaa luu sca gaca. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Horco biet tib anjl gbaa bdziṉ pchoobladz zdoo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mban rac me laa me nozodiidznie Pxoz me, per hor cole mazdraa rnab me lo Pxoz me; lo guieḻnë ro co haxta rzonis me, masaque zëbdzuuṉ grë nis co lo me zootle ren. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Zeeṉe laa me guso ga, bdziṉ me zaatne biaaṉ xpëëdscuel me, goṉ me gzase zho laa zho nixguies. Ye zho mban rac zho, lo guieḻnë co bguudz zho mcaaḻ. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dzigo pcuaan me zho, rëb me lo zho: ―¿Nixguies to ye? Lëda i goṉ, ¡goḻsobna! Goḻnab lo Dios, gacnieṉ me to, zeeṉa yquiild meṉdox to. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Laa Jesús quianeeque, zeeṉe laa Judas bdziṉ bdziṉnie Judas tib dzoon miech. Zigne bdziṉ Judas, wbig Judas lo me, dow Judas bzhid cuas me. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","―¡Judas! ―rëb me―. ¿Con tib bzhid dzigo lëë glu luu naa lo grë zha qui? ");
INSERT INTO zpmNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Zeeṉe bieṉ xpëëdscuel me, me zienaaz grë miech co, rëbchaa zho lo me: ―Maestro, ¿zha dziuuṉ ne? ¿Pe zdeed spad no zho? ");
INSERT INTO zpmNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Znuse biet tib zho pcheḻ zho tib nia spad, pchug zho diag tib xmoz meṉ ne nac pxoz nroob. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dzigo bnee Jesús lo zho rëb me: ―Goḻsaan zho, ndzinli goḻgac. Horco wbig me bzheṉ me diag zha co, beeṉguiac mew, lëëtse miṉ derecha. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Lad grë miech co no ndal grë pxoz ne rnabey, grë zha ne zo lo zha ne rquianap yadoo, ni spalal meṉ ne nac zha non lo meṉguiedz; dzigo bnee Jesús lo zho, rëb me: ―¿Pe nacne squitaa ziaad to, nzheṉ to yag, nzheṉ to spad ziadnaaz to naa? ¿Niacxe naa cho ngbaan? ");
INSERT INTO zpmNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Blactaa dze name goṉ to no naa leṉ yadoo, ni bnaazde to naa ga. Per nole guic to nagoṉ nawdze rii gnaaz to naa; grë miṉe racladz to grë to meṉdox, niina laaw gac. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Horco wbig be zho bnaaz zho me, laa zho zienie me nëz lidz meṉ nac pxoz nroob. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bdziṉ zho lidz meṉ co, bre zho xley me, bzëëg zho gui, laa zho no nodzëë zho. Ye Pedr maase zit zit naḻ Pedr, laa Pedr bdziṉ ga; laa Pedr wbig bzob lo zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Zeeṉe goṉ tib wnaa ne quia xtsiiṉ meṉ co laa Pedr zob ga, dze rwi me, tibaque rëb me: ―¡Ye mgui qui goṉ rzënie meṉ ne blansonie to i! ");
INSERT INTO zpmNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","―¿Naa ye? ―rëb Pedr―, ¡per ni ruṉbeyd naa meṉ qui! ");
INSERT INTO zpmNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wdzeepaaw, laa tib zha ne zo ga, goṉaque Pedr, rëb zho lo Pedr: ―¿Segur lëë ye luu nacnie meṉ ne bgaa i? Scasaque bneelid Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wdzeelaaque goca, zeeṉ laa stib zho brieequia, rëb zho: ―Lëë tib zha ne nacnie meṉ qui nu goṉ. ¡Rlu zha galilé nac zho! ");
INSERT INTO zpmNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pquiab Pedr, rëb Pedr: ―¡Rieṉd naa goṉ, pe nacne squi rnee luu! Gardle lozh griee diidz co ro Pedr, zeeṉe laa tib gall pcuedz. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gall co nocuedz, zeeṉe ptsire lo Jesús, dze bui me lo Pedr; dzigoraa psoladz Pedr zeeṉe rëb me lo Pedr: “¡Guieel riigazh goṉ, gardle ycuedz gall, tsoṉle vuelt rëb luu ruṉbeyd luu naa!” ");
INSERT INTO zpmNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mbanse rac Pedr. Briee Pedr ga, psilo Pedr biin Pedr guieḻnë co. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Grë zha ne zopaa quianap Jesús, nzian grë ncuaaṉe ruṉ zho me, psilo zho noyuṉnguzee zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pxidoo zho lo me, ni rguiṉ zho me, rlozh ga, rnee zho: ―Luu ne nac luu meṉ ne ziadteed xtiidz Dios, ¿bnë sca dieṉ cho ga bdiṉ luu? ");
INSERT INTO zpmNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nzian grë ncuaaṉe rgoredz zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Zeeṉe biini liu, pcaalsa grë meṉ ne nac zha non lo meṉguiedz, grë zho pxoz rnabey, ni grë zha ne nac maistr ley, güey zho güeynie zho Jesús lo zhiwxtis zho. Bdziṉ me ga, bnabdiidz zho lo me rëb zho: ");
INSERT INTO zpmNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Bnë lo no dieṉ, ¿pe lëë Meṉ ne nacle diidz cxeeḻ Dios lo guidzliu ga i nac luu? Pquiab me rëb me: ―Niicle teḻne gni naa lo to nli lëë meṉ co nu nac naa, gliladzde tow, ");
INSERT INTO zpmNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","teḻ pe gnabdiidzgaa naa lo to, ctsirede to low; sac gliladzde to miṉe nac diidzli. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Naa ne nac naa Mgui ne pxeeḻ Dios, zhile laa dze gdziṉ zeeṉe laa naa sob cue Dios nëz derech, meṉ nroob ne rrieelo ruṉ grëse ncuaaṉe racladz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Horco grëse zho pquiab, rëb zho lo me: ―¿Xpëëd Dios dzigo lëë nac luu? Dzigo rëbchaa me: ―Tozhal name rnee, nli Xpëëd me nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Horco rëb zho: ―¡Pe mazdraa textigw ne racladz ne! ¡Laa ne bdzionle gaṉle mezhal rnee Xpëëd Dios nac me! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Horcogazh pcaanie zho Jesús nëz, bdziṉnie zho me lo Pilat, meṉ ne nac gobernador ne nzoob zha Roma ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ga psilo zho nzian grë ncuaaṉe rquiaqui zho me, rëb zho: ―Laa no bnaaz meṉ rii goṉ ziaadnie no me lo luu, sac bgaa me noquiil me meṉladz no gacntseeb zho. Rnee me lo zho nonguieḻda gdeed zho dimi ne razh lo zhirey ne, meṉ ne zob Roma; haxta rnee me mele nac rey ne guṉbey zho, sac Dios pxeeḻ me ziaad me. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dzigo bnabdiidz Pilat lo me, rëb Pilat: ―¿Pe nli na luu nac Rey ne rnabey lo zha Israel? Pquiab me rëb me: ―Nliw, rey nac naa zigne rnee luu i. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dzigo rëbchaa Pilat lo grë zha ne ne nac pxoz rnabey co, ni grë miech ne ziegrë zho ga: ―¡Ni tib doḻ rapd meṉ rii! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","―¿Zha gapd me doḻ? ―rëb zho―. Ni zaatne zieetaa me noquiil me miech gacntseeb zho lo zhirey ne. ¡Dible nëz Judé nu güeyted me; desde nëz Galilé briee me ziaad me haxta nu! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Goṉ Pilat sca rëb zho, dzigo bnabdiidz me dieṉ pe zha Galilé nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Zeeṉe gocnaṉ me zha nëz co nac Jesús, dzigo pxeeḻ me Jesús lo Herod, sac Herod rnabey nëz Galilé; lëëtaque leṉ dze co laa Herod no Jerusalén ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Rley Herod zeeṉe goṉ Herod me, sac ziyon Herod grëtaa miṉe ruṉ me; quiambëz Herod gdziṉ dze gaṉlo Herod me, gaṉlo Herod guṉ me pe tib milagr. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Psilo Herod nzian grë ncuaaṉe rnabdiidz Herod lo me, per ni tib lo wnabdiidz co ib ptsired me. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Zeeṉe goṉ Herod rquiabd me, ni goṉ Herod noque grë pxoz rnabey co, grë maistr ley co, ib rioogd ro zho rzadraa pe yquiaaqui zho me, rnab zho cteed Herod me caxtigw, ");
INSERT INTO zpmNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","nacne leḻ psilo Herod grë xmeṉguiib Herod rzhidznie zho me, ruṉnguzee zho me. Bgacw zho me tib lar ne racw rey, sca nacw me lar co biire pxeeḻ Herod me lo Pilat. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Glo ib rdzieeld xtiidz Herod grop Pilat, laa dze co laa zho psilo bneewen stib. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dzigo bnabey Pilat pcaalsa grëse pxoz rnabey, grë zha ne nac zhiwxtis zha Israel, ni grëraa meṉguiedz, ");
INSERT INTO zpmNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","rëb Pilat lo zho: ―Laa zho biad-zoob xdemand meṉ rii lo naa nu, nac diidz noquiil me miech gacntseeb zho lo zhirey ne. Nacne pquiep naa me, ni blalagaa to goṉa; par naa peet doḻ rapd me. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Niiclegaa Herod, ye Herod goṉ ni tib doḻ rapd me; gane pxeeḻaque Herod me lo naa. Quiayuṉd me ncuaaṉe guiab ne rieguiaḻ guet me. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Miṉe gaca, laa naa gnabey ted me tib caxtigw, lozh ga dzigo laa naa csilaa me. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nac costumbr, gzobse lni Pascw rsilaa zho tib zha ne no xcuent lo wxtis. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Per zeeṉe bin grë miech co laa Pilat csilaa Jesús, grëse zho nguiedz roptsie zho, rnee zho: ―¡Csilaad luu meṉ qui, bnabey guetgazh me! ¡Barrabás psilaa! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás lë tib meṉ co no ladzguiib leṉ dze co, sac bgaa me zo me lo tib dii zha ne noyacntseeb lo rey leṉ guiedz Jerusalén ga, ni zëëbaque me tib ngutoo. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bguib Pilat dieṉ zha nrieelo nsilaa me Jesús, ");
INSERT INTO zpmNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","per psilo grë miech co nguiedz roptsie zho, rnee zho: ―¡None guetgazh meṉ qui! ¡Lo cruz bnabey yquia me! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","―Per, ¿pe nacne gnabey naa yquia me lo cruz? ―rëb Pilat stib―. ¿Pe nac falt ne rap me? Laa naa pquieple me, ni tib doḻ rapd me, parne gnabey naa guet me. Laa naa nile lo to, laa naa gnabey ted me tib caxtigw, lozh ga laa naa csilaa me. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Psiloque grë miech co stib, nguiedzraa roptsie zho, rnab zho yquia Jesús lo cruz; haxta goc miṉe racladz zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Racse Pilat, laa Pilat bdeed diidz. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Blozhse bnabey Pilat psilaa zho Barrabás, zha ntseeb ne no ladzguiib ga, dzigo laa Pilat psaṉ Jesús ladznia zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Horco laa zho brieenie Jesús laa zho zienie me zaatne yquia me lo cruz. Nëz zienie zho me, bdzieel zho tib meṉ Ciren lë Simón wbire lo dziin dan, pcuëëz zho meṉ co, bnabey zho me bi me zhicruz Jesús; naḻse me zhits Jesús, laa zho zienie Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Miech guizhiu ne zie ga, ndal grë meṉ wnaa psilo zho roon zho no zho xquieḻnë me, ");
INSERT INTO zpmNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","dzigo dze bui me lo zho, rëb me: ―Xin, nac to meṉ Jerusalén rii, goonde to xquieḻnë naa. Mazd goḻgoon por grëtaa guieḻnë ne no gaṉ to, por grëtaa guieḻnë ne no gaṉ xpëëd to; ");
INSERT INTO zpmNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","sac zeeṉe gaḻ dze co grë meṉ wnaa ne quianie mëëd, ziab zho: “Mazd wenaque zie zha ne quianied mëëd, zha ne naṉd zha radz mëëd, zha ne niaadgaa gap mëëd.” ");
INSERT INTO zpmNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Horco grë miech, laa zho gnab tebaa zha pixche grë gui guiaaṉ zho zhana. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","¡Goḻwi gaṉle, teḻne znutaa miṉe nodeed naa nac naa zig tib yag nguia, peleḻ to dzigo ne nac to zig tib yag bidz! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ye schop zha ne nac ngbaan, zienie zho ga yquiaagza zho me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Zeeṉe bdziṉ zho zaatne nac “Gui Beerguic Ngutoo”, ga pquiaa zho me lo cruz gza me ngbaan co. Tibga zhicruz zho bzo tib nëz cue zhicruz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Lo cruz co quia me, zeeṉe nguiedz bnee me rëb me: ―¡Papá! Ncuaaṉe quiayuṉ grë miech rii nu, bzhiguieḻ guṉquizhd luu zhow; sac rieṉd zho pe ruṉ zho. Gza meṉguiib ne bdziṉ ga yquiaanap me, hor co tib tib zho bzheṉse zho tib lë xab me, laa stiba bio zho rif. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ndal miech ne ndxie quiawi. Haxta grë zha ne nac wxtis zo ga, no zho rzhidznie zho me, rnee zho: ―Stib miech scataa beeṉguiac me, stib miech scataa bla me. ¿Pe rac me na ne riete me i? ¡Guiet me i zho, teḻne nli me nac Meṉ ne zëëble diidz cxeeḻ Dios, teḻne nli Dios bzooblo me ziaad me! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wbig meṉguiib co rdeed zho nziu bla guie me, rzhidznie zho me, rnee zho: ");
INSERT INTO zpmNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","―¡Zhirey zha Israel name nac luu! Psilaa luu lo guieḻnë qui nazho. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Glaa guic zhicruz me quia choplan diidz ne pquiaa zho, rneew: “LËË ZHIREY ZHA ISRAEL NU.” ");
INSERT INTO zpmNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Grop ngbaan ne quianie me lo cruz ga, psilo tib zho ye zho rzhidznie me, rnee zho lo me: ―¡Led rëb luu lëë, luu nac Meṉ ne zëëble diidz ga cxeeḻ Dios! ¡Blu nazho nli meṉ co nac luu, psilaa ne lo guieḻnë rii! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Horco pquiab stib zha co, rëb zho lo zho: ―¡Psioog ro luu! ¿Pe niicle niina ne laa luu guetle ib rdzieebd luu Dios? ");
INSERT INTO zpmNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Bieṉ gaṉle, ¡teḻ ne ible miṉ rii rioguiaḻ ne grop ne, nu nodizh ne grë guieḻntseeb ne bdziuuṉ ne; saṉgue meṉ qui, peet doḻ rapd me! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dzigo rëb zho lo me: ―¡Bzhiguieḻ zeeṉe guiaad luu gnabey luu, ib csaṉd luu naa tib lad! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Pquiab me rëb me lo zho: ―Peet tsienied guic luu, nadzegazh laa luu së guioo ne zaatne nac lo xquieḻbley Pxoz naa. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","46","Goḻ groḻ dzew, tibaque zeeṉe goc tib ncow dipse lo guidzliu. Ni palal rlud xbiini ngbidz, haxta las tres biaa biini stib. Horco pquiaa Jesús tib redz nroob, rëb me: ―Papá, laa naa rsaṉ zhiespíritu naa ladznia luu, luu pcaaniaw. Diidz co briee ro me, znuse blozh me. Laa me quialozh, zeeṉe laa lar nroob ne quia leṉ yadoo Jerusalén ga briez nzoli, groḻtaa goca. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Zha ne rnabey lo zhaguiib ne pquiaa me lo cruz ga, zeeṉe goṉ zho zha blozh me, bieṉ zho Dios beeṉ miṉ co, rëb zho: ―¡Ne nlipagaa tib meṉ peet xtoḻd goc meṉ qui! ");
INSERT INTO zpmNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Scaque grë miech ne goclo ga, zeeṉe goṉ zho zha blozh me, biabguieḻnë zho, mbanse rac zho laa zho wbi ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Laa grë zha ne ruṉbey me, zha ne gocnie me, zig nac grë meṉ wnaa ne gocgrë zha ne brieenaḻ zhits me zeeṉe briee me nëz Galilé, grë zho laa zho ndxiese tib lad rwi zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Lad grë zha ne nac zhiwxtis meṉ Israel ga, no tib meṉ guiedz Arimaté lë me José; lëë guiedz co ndxie xtan Judé. Tib miech wen nac me, noxco me miṉe rnabey Dios, ");
INSERT INTO zpmNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ye me quiambëz gdziṉ dze ne csilo gnabey Dios. Zeeṉe bnabey zha ne nacgrë me dziin ga zha gac Jesús, ni lalnu biod me conform miṉe bnabey zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nacne hor co güey me lo Pilat, bnab me diidzbey tsielit me xcuerp Jesús lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Dzigo güey me, blozhse blit me cuerp co lo cruz, pcheḻ me me tib lo lar nroob, güey me güeyqueets me me tib leṉ baa cub ndieeṉ tib cho quie gax ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lëë bdze dze co no zho xco ne laa dze ne gdziiladz zho lo dziin sëëb. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Grë meṉ wnaa ne sca nacgza grë zha ne brieenaḻ zhits me zeeṉe briee me nëz Galilé ga, ye zho güeynaḻ bgueets me, goṉ zho pa lo bio me. ");
INSERT INTO zpmNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Blozhse bgueets me, laa zho zey. Bdziṉ zho bzhixcuaa zho, tiblo zënex ne tsietëëb zho lad xcuerp me; dzigo laa zho bdziiladz zigne rnabey ley no guṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Laa zeeṉe goḻ dze ne rzobni zhmal, silgaw laa gza meṉ wnaa co briee, bi zho grë zënex ne bzhixcuaa zho ga, laa zho zie ro baaṉ Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bdziṉ zho, goṉ zho laa quie ne bioog ro baaṉ me ga bdiooble; ");
INSERT INTO zpmNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","bzëëb zho leṉ baa goṉ zho, niicle xcuerp me guieṉdle ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Laa zho zo ga, rieṉd zho dieṉ pe nacne sca nialse ro baa co, pe nacne niicle xcuerp me guieṉd leeṉ co. Tibaque zeeṉe goṉ zho laa chop meṉ bgui zole lo zho ga, masaque riaazbel lad xab grop meṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Horco per nli bdzieb zho, lo dzeb co miṉe beeṉ zho laa zho pquiitsgzhib haxta bdziṉ lo zho lo liu. Dzigo rëb grop meṉ bgui co lo zho: ―¿Pe nacne ziaadguib to meṉ mban zaatne rio meṉgut? ");
INSERT INTO zpmNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","¡Laa me brieebanle! ¡Guieṉdle me nu! Goḻsoladz gaṉle zha në me lo to leṉ dze ne no me nëz Galilé, ");
INSERT INTO zpmNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","në me: “Mgui ne pxeeḻ Dios, ible none guiab me ladznia grë miech ngoopdoḻ, squiaa zho me lo cruz, per zeeṉe gac tsoṉ ngbidza, laa me grieeban.” ");
INSERT INTO zpmNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dzigoraa psoladz zho, nligaa sca bnee me, ");
INSERT INTO zpmNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","hor co lëëlëd güeynie zho diidz lo gza tsiiptib zha ne nac xpëëdscuel me, ni lo grëraa zha ne nacgza zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nzianlaa nac meṉ wnaa co, lad co no Marí Magdal, no Zhuan, ni Marí ne nac xniaa Jacob. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Niicle bzodiidz zhow lo xpëëdscuel me, per con rnee zho led ncuaaṉ gacd ga, ni lalnu bliladzd zhow. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tibaque zeeṉe briee Pedr, rias Pedr laa Pedr zie nëz ro baa. Bdziṉ Pedr bdiixlo Pedr leṉ baa co, goṉ Pedr nligaa, ¡loxaque lar ne brieḻ me zhoob leeṉ co! Blozh ga, laa Pedr zeyaque, rzee zdoo Pedr goṉ Pedr nli guieṉdle xcuerp me ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dze co briee chop xpëëdscuel me zie zho tib guiedz win lë Maús. Gax Jerusalén riaaṉ guiedz win co, maase chop hor rzë zho rdziṉ zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nëz no zho nozodiidz zho grë miṉe pteed miech Jesús ga, ");
INSERT INTO zpmNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","tibaque zeeṉe bieṉ zho laa zho bgaa tib lo meṉ co, gocgza me zho laa zho no nëz, per, ¡ib bieṉd zho lëë Jesús ga! ");
INSERT INTO zpmNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Raṉlo zho laa me ziegza zho ga, per ni lalnu beeṉbeyd zho ne mew, sac zig nac zeeṉ pe tib ncuaaṉe ptse lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Dzigo rëb me: ―¿Pe squitaa nozodiidz to? ¿Pe nac squi rac to, zig nac zeeṉe pe guieḻnë no to? Dzigo bzodze zho. Mban rac zho, haxta lo zho rlu nroob guieḻnë no zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pquiab tib zha ne lë Cleof, rëb zho: ―¿Niacxe bind luu gaṉle zha nactaa ncuaaṉe goc Jerusalén leṉ dze rii? Grëse zha ne name güey Jerusalén, gocnaṉa. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","―Nligaa ―rëb me―, ¿pe dieṉ goc ga? Rëbchaa zho: ―Leṉ dze rii psacsi zho meṉ Nazaret ne lë Jesús. Tib meṉ ne biadteed xtiidz Dios lo miech nac me, nzian grë milagr nroob ne beeṉ me; miech guizhiu ne bley pquiaadiag zhiwseed me. Rlu tib meṉ nziuu nac me lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Per leḻ briee grë pxoz rnabey, grë zho zha ne nac wxtis, bnaaz zho me, bnab zho gut me, pquiaa zho me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tibaque rdzieets no, me niac tib meṉ ne nsilaa zha ladz ne ladznia zha Roma. Pasëse miṉ co niac, nadzele rac tsoṉ ngbidz beet zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Per rieṉd no dieṉ zha nac cuent co, sac nasil güey bla meṉ wnaa ne nacgrë no ro baaṉ me, ");
INSERT INTO zpmNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","zeeṉe wbire zho bzodiidz zho lo no në zho guieṉdle xcuerp me leṉ baa, loxaque chop anjl brieequia lo zho ga, rëb anjl co mban me. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Blozh ga, güeyaque bla zha bgui ne nacgrë no, goṉ zho nligaa guieṉdle xcuerp me ga. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dzigo rëbchaa me lo zho: ―¡Nadzpaa ncow nac guic to, nadzpaa ndip nac zdoo to! ¿Rliladzde to grë miṉe dzigo lëë bzeet zho padzeela ted Meṉ ne nole diidz ga cxeeḻ Dios? ");
INSERT INTO zpmNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bzeetle zha co name ible no csacsi miech me, antes ne gbire me lo guieḻndzon ne no me. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dzigo psilo me bnee me lo zho pa lo zhobnee grë miṉe bded me ga, psilo me desde grë miṉe pquiaa Moisés, haxta grë miṉe pquiaa grëraa zha ne biadteed xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sca no zho nëz laa zho bdziṉ Maús. Bdziṉ zho ga, rac me zig nac zeeṉe tib ted me, ");
INSERT INTO zpmNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","dzigo quia zho rnab zho lo me cuëz me ga, sac laa dze bdzele, zhile laa liu ycow. Nacne blëz me. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Laa zho zob lo mezh gowxtsee zho, bzheṉ me guietxtil bdeed me xquizh lo Dios, blozh beeṉgroḻ mew bdeed mew lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dzigoraa zig nac zeeṉe bzhial lo zho, laa zho beeṉbey me. Per par niaṉraa zho me, znuse bnit me lo zho, goṉdraa zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Horco per nli rley zho rnee zho: ―Con razon zeeṉe sca ziaadgza ne me nëz nonee me lo ne zha raquiet lo Xtiidz Dios, masaque tib guieḻbley nroob ne biaadnie xcodiidz me zdoo ne. Sca rnee zho, sac bieṉ zho bdziṉ tib guieḻbley nroob zdoo zho, zeeṉe sca nonee me lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lëëlëdaque briee zho ga, bio zho nëz wbire zho Jerusalén stib. Bdziṉ zho lo gza tsiiptib zha ne bzëniepaa me ga, ni grëraa zha ne nacgrë zho, ");
INSERT INTO zpmNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","rëbchaa zha co lo zho: ―¡Tebaa gaṉ to gaṉle nli brieeban xmaistr ne! ¡Laa Pedr goṉle me! ");
INSERT INTO zpmNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Psiloque zho grop zho bzodiidz zho zha goṉ zho me no zho nëz, per haxta horne no zho xtsee, zeeṉe laa me beeṉgroḻ guietxtil dzigoraa beeṉbey zho me. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lëëtaaque sca nozodiidz zho, tibaque zeeṉ goṉ zho laa Jesús zole lo zho ga, pquiaabdiuzh me zho, rëb me lo zho, peet tsieniedraa guic zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Leḻ rdzieb zho, haxta rzhidz zho lo dzeb co, sac rëb zho bod ndziin ga raṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Dzigo bnee me lo zho rëb me: ―¿Pe nacne rdzieb to? ¿Pe nacne rliladzde to naa nu? ");
INSERT INTO zpmNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Goḻwi leṉ nia naa, goḻwi zhits ni naa gaṉle. Goḻxeeṉ naa, zeeṉa gliladz to gaṉle nli naaw; sac teḻ ndziina, mese naca, gacd xeṉ tow. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sca quianee me, blu me nia me, blu me ni me lo zho, zaatne biaaz me clav. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Per nli rley zho, rzee zdoo zho, per rliladzdaque zho dieṉ pe nlipaa lëë me ga. Goṉ me sca rac zho, nacne bnab me ncuaaṉe gow me lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dzigo bdeed zho tib lë meḻ bguiee lo me, ");
INSERT INTO zpmNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","bnaaz me meḻ co, squi ndxie zho goṉ zho dow me ma. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dzigo rëb me lo zho: ―¿Pe ib rsoladzde to nile naa laa grë miṉ rii no gac? Led ni naa lo to, grëse miṉe bzeet Moisés, grëse miṉe bzeet grë zha ne biadteed xtiidz Dios, miṉe raquietgaa lo Salm teed naa, ible laaw none gac. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Psilo me clar nonee me lo zho, parne guieṉpaa zho zha zhobnee lo grë guits co, ");
INSERT INTO zpmNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","rëb me: ―Ible lo co zhobnee sca teed naa ne nac naa Mgui ne pxeeḻ Dios, rneew ib no gut miech naa, per zeeṉe gac tsoṉ ngbidza, laa naa grieeban. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Rneew, Jerusalén nu, nu csilo gacnaṉ miech ible none csaan zho xquieḻntseeb zho, gnalo zho naa, parne guṉ Dios zho perdon. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ni to goṉ gaṉle grëse miṉ co, goca. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na leṉ dze ne ziaadaque nu, laa naa cxeḻ Espíritu Sant gacnieṉ to, sac ib scale nac xtiidz Pxoz naa. Per guiabde to niinaga griee to tsienee to lo miech, Jerusalénse nu goḻcuëz, haxta nieeda ygaa to poder ne gneedz Espíritu Sant lo to. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Zeeṉe goḻ dze ne laa me guey gbaa, dzigo güey me güeynie me zho nëz Betain. Bdziṉ zho ga, blis me nia me, psilo me noyuṉlay me zho. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Laa me quiayuṉlay zho, tibaque zeeṉe laa me bias lo guidzliu, ¡goṉlo zho laa me bzoquia gbaa! ");
INSERT INTO zpmNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Horco pquiitsgzhib zho liu, beeṉnon zho me, rnee zho grë diidz ndzon lo me; blozh ga iṉe rley zho laa zho wbi ga, bdziṉ zho Jerusalén stib. ");
INSERT INTO zpmNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Psilo zho gzataa dze rie zho yadoo rooḻnie zho Dios, rdeed zho xquizh lo me.");
INSERT INTO zpmNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Jesús, meṉ ne nac Diidz Ndzon, nole me zeeṉe biaa grëtaa ncuaaṉe no; lo Dios no me ni Diosaque nac me. Notaque me, tibaque nac me: me ni Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Me bzaa grëtaa ncuaaṉe no, tsod ncuaaṉe lega scase niaaṉ; sac me bzaaw grësew. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ladznia me no guieḻmban ne gdziṉd dze lozh, nac guieḻmban co zig tib biini ne rziini lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Me nac biini ne quiaziini zaatne nac lo guieḻcow, ni rrieelod guieḻcow ctsew lo biini co. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Bio tib mgui brieelë Juan, Dios pxeeḻ Juan biadnee Juan lo miech cho nac Jesús, zeeṉa grëse zho gliladz Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Led Juand nac biini, sinque loxaque biaad Juan biaadlu Juan Jesús, meṉ ne nac biini co. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Bdziṉ dzew laa Jesús biaad, ni niina me nac meṉ ne noziini lo grëse miech, sac mepaa nac biini co. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jesús nac biini, me nac Diidz Ndzon co. Me bzaa guidzliu, per zeeṉe biaad me lo guidzliu ib bieṉd miech cho nac me. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Per ni meṉladz me, niicle ne lopaa zho bdziṉ me ib goṉdzed zho me; tib chop zha ne blëzlo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ni grë zha ne sca bleynie me, grë zha ne dib zdoo gliladz cho nac me, grëse zha co laa me bzo zho gac zho xpëëd Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","¡Grëse zho, rrieequia gol zho stib! Per guiabd ne togo gol zho zigne ral grë miech guidzliu rii, sinque laa zho gol zigne racladz Dios; gane niina xpëëd me nac zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Zeeṉe bdziṉ dze ne laa meṉ ne nac Diidz Ndzon ga goc miech biaad me lo guidzliu, grop lo no bdzioṉ no me, ni bzianie no me. Blu me pa lotaa nquialadz me miech, ni niapse diidzli bnee me. Bdzioṉ no xquieḻndzon me ne nac me tibpaa mëëd lo Dios, meṉ ne nac Pxoz ne. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zeeṉe bzeet Juan Bautist me lo miech, tib vuelt haxta blu Juan me lo zho, rëb Juan: “Lëë meṉ rii ga goṉ rzet naa lo to zeeṉe rne naa: Iraa ziaad tib meṉ ne mazdraa non lo naa, sac notaque me; nole me zeeṉe blanso naa lo guidzliu.” ");
INSERT INTO zpmNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nquialadzdox Jesús ne, grëse ne gzataa dze laa ne nogaa grëtaa guieḻnzaac ne rsiaab me. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Zeeṉe psaṉ Moisés ley, loxaque bnabeya ne; saṉgue niina ne laa Jesús biaad, laa me biaadnie miṉe nacpaa diidzli ni biaadlu me gaṉle pa lotaa nquialadz Dios miech. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wlaltaa ib choot gard gaṉ Dios; saṉgue niina ne laa Xpëëd me Jesús biaad, meṉ co biaadlu gaṉle zha nac Dios; sac zaatne no Dios gaque no me. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tib dze pxeeḻ grë zha ne nac zha non Jerusalén, bla zha ne nac pxoz ni zla zha ne rquianap yadoo, zienabdiidz zho lo Juan dieṉ cho nac Juan. Bdziṉ zho bnabdiidz zho lo Juan. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Dzigo bneeli Juan lo zho, rëb Juan: ―Goḻgacnaṉ gaṉle, led naad nac Meṉ ne quiambëz to ga cxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","―¿Chox nac luu waa? ―rëb zho―. ¿Te luu ye nac Lí, meṉ ne biadteed xtiidz Dios padzeela? Pquiab Juan rëb Juan: ―Lëda, led Líd naa. Biire zho bnabdiidz zho, rëb zho: ―¿Te luu ye nac meṉ ne bzeet Dios padzeela cxeeḻ me guiadteed xtiidz me? Pquiab Juan rëb Juan: ―Zhaa meṉ co, led naad nac meṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","―¿Cho dzigo nac luu? ―rëb zho―. Bnë dieṉ cho nac luu; sac goṉ ib none gdziṉnie no tib xtiidz luu lo zha ne pxeeḻ no. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dzigo pquiab Juan, rëb Juan lo zho: ―Naa nac mgui ne bzeet Isá, meṉ ne biadteed xtiidz Dios padzeela, zeeṉe znu bnee me: “Zon to zëëb tsi tib mgui dan rnee me lo miech: ¡Goḻguṉ nguudz zdoo to, sac goṉ ile ziaad meṉ ne rnabey ne!” ");
INSERT INTO zpmNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Horco laa zha ne pxeeḻ zha farisé pquiab, rëb zho lo Juan: ");
INSERT INTO zpmNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","―Teḻne led luud nac Meṉ ne zëëble diidz ga cxeeḻ Dios, niicle led luud nac Lí, niicle nacdgaa luu cho stib zha ne pxeeḻ Dios ziadteed xtiidz me, ¿zha nac dzigo ne nochoobnis luu miech? ");
INSERT INTO zpmNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Pquiab Juan rëb Juan: ―Teḻ naa niab nis rchoobnis naa miech, per no tib meṉ ne gard guṉbey to. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tib meṉ non nac me, per ni par gac naa tib nguṉdziin win ne glit lab me ni me raguiaḻd naa; ni merle csilo guṉ me dziin ne pxeeḻ Dios me guṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betain lë tib guiedz ne riaaṉ gax ro guiubee Jordán, nëz ne rlan ngbidz; ga no Juan nochoobnis me miech zeeṉe scataa pquiep zho me. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Biet stib dzew, laa Jesús bdziṉ zaatne no Juan ga. Zeeṉe goṉ Juan me, rëbchaa Juan lo grë miech ne ndxie ga: ―¡Goḻwi gaṉle, lëë meṉ qui goṉ csilaa miech lo grëtaa xtoḻ zho! ¡Me gac zig tib carner yeeṉ ne guet tsogon lo Dios par guiaaṉmbe miech lo doḻ! ");
INSERT INTO zpmNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Lëë meṉ rii ga nagoṉ rzet naa lo to zeeṉe rne naa: “Iraa ziaad tib meṉ ne mazdraa non lo naa, sac notaque me; nole me zeeṉe blanso naa lo guidzliu.” ");
INSERT INTO zpmNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Leṉ dze co niicle naa ruṉbeyd naa me; per laa naa nochoobnis miech sac ible laa naa ziaḻ par glu naa me lo grë zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Dzigo bzodiidz Juan lo zho, zha goṉlo Juan biet Espíritu Sant gbaa, rlu me zigne rlu tib palom blëz me guic Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","―Ne nligaa ruṉbeyd naa me ―rëb Juan―. Per zeeṉe pxeeḻ Dios naa ziaḻchobnis naa miech, hor co në me lo naa: “Zeeṉe gaṉ luu guiet Espíritu Sant gbaa cuëz me guic tib mgui ne nochoobnis luu, dzigo gocnaṉ lëë meṉ co nac meṉ ne rxeeḻ Espíritu Sant zdoo miech.” ");
INSERT INTO zpmNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Goṉlo naa blëz Espíritu Sant guic me; gane naṉween naa ne nli Xpëëd Dios nac me. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Biini liu co, laa Juan zoque ga zonie me chop xpëëdscuel me. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ga zo me, goṉ me laa Jesús zieded ga; dzigo rëbchaa me lo zho: ―¡Goḻwi gaṉle! ¡Lëë meṉ qui goṉ nac Xcarner yeeṉ Dios! ");
INSERT INTO zpmNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Zigne bin zhow, laa zho zienaḻ zhits Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Zeeṉe ptsire lo me, goṉ me laa zho naḻle zhits me; dzigo rëbchaa me lo zho: ―¿Pe nac ziaadnaḻ to zhits naa? ―Maestro ―rëb zho―, laa no racladz gacndioṉ no dieṉ pa rbëz luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Dzigo rëbchaa me lo zho: ―Na gaṉle guio ne, zeeṉa gaṉ to paw. Nacne güeynaḻ zho zhits me, goṉ zho pa lo no me; dzigo blëz zho lo me ga. Ga blozh ptse zho dze, sac ziedzele dze zie zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ndrés lë tib zha ne güeynaḻ zhits me ga; lëë Ndrés co nac bets Simón Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dzigo zigne briee Ndrés ga güey Ndrés güeyguib Ndrés Simón. Bdziṉ Ndrés rëb Ndrés lo Simón: ―¡Nasi goṉ laa no bdzioṉ Meṉ ne nacle diidz ga cxeeḻ Dios! ");
INSERT INTO zpmNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dzigo güeynie Ndrés Simón zaatne no Jesús ga. Zeeṉe goṉ Jesús Simón, rëbchaa me lo Simón: ―Bina gaṉle, nli Simón nac lë luu ni xingan Jonás nac luu, saṉgue niina laa luu grieelë Cef. (Cef rnee zha Israel quie, laa xtiidz zha Gres rnee zhow Pedr.) ");
INSERT INTO zpmNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Biet stib dze co, laa Jesús no nëz tsie me nëz Galilé. Laa me zieriee dze ga, zeeṉe bdzieel me tib mgui lë Lip; dzigo rëbchaa me lo Lip: ―Dënaḻ zhits naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Zha Betsaid nac Lip, ni zha coque nac Ndrés grop Simón. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dzigo güey Lip güeyguib Lip Natanael; rëb Lip lo Natanael: ―¡Laa no bdzioṉ Meṉ ne nacle diidz ga cxeeḻ Dios! Meṉ ne rzeet Moisés lo libr ley ne psaṉ me, meṉ ne scataa bzeet grë zha ne biadteed xtiidz Dios padzeela. ¡Laa no bdzioṉ me, tib meṉ Nazareta, lëë me ga nac Jesús, xingan José! ");
INSERT INTO zpmNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Pquiab Natanael, rëb Natanael: ―¿Nazaret ye? ¡Gard grieequia tib zha non Nazaret! ―Gotsaa guio ne gaṉle ―rëb Lip―, zeeṉa gaṉzhal luu me. Dzigo laa zho zie. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Squi ziaad Natanael, zeeṉe goṉ Jesús Natanael rëbchaa me: ―¡Goḻwi gaṉle, lëë zha qui goṉ nac merpaa zha Israel, sac mesi ib rquidied me! ");
INSERT INTO zpmNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","―¿Zha nacne ruṉbey luu naa? ―rëb Natanael. Pquiab me rëb me: ―Glole naa beeṉbey luu, dzigoraa bredz Lip luu. Zeeṉe zob luu tib zhan yag guigw, hor co goṉ naa luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Rzee zdoo Natanael, rëb me lo Jesús: ―¡Nlique nagoṉ luu nac Xpëëd Dios! ¡Luu nac zhirey zha Israel! ");
INSERT INTO zpmNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Dzigo rëbchaa Jesús lo Natanael: ―¿Pe ne binse luu ni naa goṉ naa zeeṉe zob luu tib zhan yag guigw, pe miṉcose laa luu bliladz cho nac naa? ¡Naraa gaṉle gaṉ luu ncuaaṉe mazdraa nroob! ");
INSERT INTO zpmNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ni rëb me lo grë zha ne ndxie ga: ―Gneli naa lo to: zaṉaque to gaṉle zeeṉe laa zhan gbaa gzhial, zlupaa grë xanjl Dios, zha ne ziad-zëëb zha ne ziequia, quiayuṉ zho dziin lo naa, nac naa Mgui ne pxeeḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Goc tsoṉ ngbidza, bio tib guieḻtsieel guiedz Caná, xtan zha Galilé ga. Dzigo bredz zho xniaa Jesús lo lni co, ");
INSERT INTO zpmNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ni bredz zho me; nacne bionaḻ no zhits me grëse no ne nac no xpëëdscuel me. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Laa lni noyac, tibaque zeeṉe laa vin blozh. Dzigo güey xniaa Jesús rëb me lo Jesús: ―Laa xvin meṉ rii blozh. ¡Guieṉdraa pe quiiz zho! ");
INSERT INTO zpmNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pquiab Jesús rëb me: ―¿Pe nacne rnee luuw lo naa? Goṉ gaṉle naraa gdziṉ dze ne gacnaṉ miech cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Niicle sca rëb Jesús lo me, güey me lo zha ne quiaguiiz vin ga rëb me lo zho: ―Miṉe gnabeytaa me to, goḻguṉa. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Lidz meṉ co ga ndxie xoop guies ne niaa quie; zaatne rio nis ne rquiin zha Israel riar nia zho, zigne nac grë xcostumbr zho. Tib tib guies co, rio maase xoopga re nis leṉa. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Dzigo bnabey Jesús zha ne rguiiz vin ga pcodzëë zho nis leṉ gza guies co. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Blozhse guiel guiel pcodzëë zhow, rëbchaa me lo zho: ―Goḻcuee niip nis qui, goḻtsieniew lo meṉ ne zo lo lni. Zeeṉe laa zho blee niip nis co tsienie zho, laaw nacle vin. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ni lalnu ib güeynied guic meṉ co pa briee vin co (loxaque zha ne nacse nguṉdziin ga, zha ne blee nis ga, zha cose goṉ pa brieew), zeeṉe pquiaaro mew, bredz me mgui ne notsieelnia ga, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","―¡Zha naṉ luu naraa cuee luu vin rii! Grëtaa zaatne znu rac lni, glo rgaaz vin niazh, zeeṉe nrooblew noye zho, dzigo rgaaz vin ligase. Laa luu goṉ leḻ naraa bnabey luu briee vin niazh. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Milagr ne beeṉ Jesús guiedz Caná ga, ga glopaa blu me lo miech gaṉle nli tib meṉ nroob nac me. Grëse no ne nac no xpëëdscuel me, zeeṉe bdzioṉ now, hor co bliladz no nli me nac Meṉ ne zëëble diidz ga cxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Zeeṉe blozh guieḻtsieel co, laa no wbire guiedz Capernaum stib grë no me, xniaa me, ni zha bets me ne. Bdziṉ no Capernaum, ga bliaaz no blalaa ngbidz. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Leṉ dze ne ziaadyob lni Pascw, lni nroob ne ruṉ zha Israel rsoladz zho zha psilaa Dios zho Egipt, leṉ dze co briee Jesús zie me nëz Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bdziṉ me Jerusalén, güey me leṉ yadoo nroob ne zob lad guiedz co. Zeeṉe bzëëb me, goṉ me nzian miech ne ndxie ro yadoo co, zha ne no wto ngon, zha ne no wto mëcwxiil, zha ne no wto palom ne, haxta zha ne rtsëë dimi ndxie ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dzigo bzhixcuaa me tib lë doo zig riaa dooguid ne rcaa ma, bzheṉ me doo co beṉcxooṉ me zho ga grë xma zho; blozh ga, ptiixche me xmezh zha ne notsëë dimi ga, nëzrii nëzrec blaaḻ me xtimi zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","―¡Niinagazh goḻcuee grë ncuaaṉ qui nu! ―rëb me lo zha ne rto palom―. ¡Goḻguieṉ gaṉle lidz Pxoz naa nu! ¡Nacda yu lgui parne tso to wto nu! ");
INSERT INTO zpmNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dzigo psoladz no zha ziaad lo Xtiidz Dios, zaatne rnee: “Rbiṉladz guic naa, sac ne nligaa racladz naa yquiaanap naa lidz luu.” ");
INSERT INTO zpmNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Blalaa zha non lo meṉguiedz Israel, zeeṉe goṉ zho sca beṉcxooṉ me grë miech co, wbig zho lo me rëb zho: ―¿Cho nac luu ne squitaa noyuṉ luu grë ncuaaṉ qui? ¡Beeṉ tib milagr, dzigo zliladz no meṉ rnabey nac luu! ");
INSERT INTO zpmNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","―Teḻne racladz to milagr ―rëb me―; goḻtsiḻ yadoo rii, ni gni naa lo to gaṉle ngbidz tsoṉa laa naa bzaalolew stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pquiab zho rëb zho: ―¡Ncuaaṉe gliladzdraa no rnee luu! ¡Leṉ choopxoopraa iz name biaa yadoo rii! ¿Zhazhe guṉ luu, tsoṉaque ngbidz gzaa luuw stib? ");
INSERT INTO zpmNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per zeeṉe sca bnee Jesús lo zho, xcuerp me ga nac yadoo ne bzeet me. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Gane zeeṉe brieeban me, hor co psoladz no zeeṉe znu bnee me, dzigo bieṉ no ne me ga bzeet me ni bieṉ no ne me ga raquiet lo Xtiidz Dios zaatne scaque rnee. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Leṉ dze lni Pascw co, nzian miech zeeṉe goṉ zho grëtaa milagr ne ruṉ me, bliladz zho ne nli me nac Meṉ ne zëëble diidz ga cxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per ib pxend me lo zho, sacne naṉwen me zha nac zho tib tib zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pquiind me chopaa niab lo me zha nac zho; sac naṉwen me zha nac tib tib miech ni naṉ me pe rza zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ziecowle liuw, bdziṉ tib zha farisé lë Nicodem zaatne rbëz Jesús; tib zha non nac me lo meṉguiedz Israel. Bdziṉ me rëb me lo Jesús: ");
INSERT INTO zpmNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","―Maestro, ndioṉ no ible Dios pxeeḻ luu ziadseed luu no. Grë milagr nroob ne ruṉ luu, ga rlu ne Dios nacnie luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","―Gneli naa lo luu gaṉle Nicodem ―rëb Jesús―, grëse miech, teḻne gald zho stib grieelod gdziṉ zho zaatne rnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pquiab Nicodem, rëb Nicodem: ―¿Gal zho stib ye? ¿Zha grieelo gal miech stib? Tib zha ne nacle meṉgol, ¿niacxe zrieelo sëëb zho zdoo xniaa zho gbiire gal zho? ");
INSERT INTO zpmNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Rëbchaa Jesús: ―Ible none gal miech, none gal zho zigne racladz Dios. Sac teḻne chobnisd zho ni ygaad zho Espíritu Sant, grieelod sëëb zho zaatne rnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Grëse miech zeeṉe ral zho glo, miechse nac zho; saṉgue zeeṉe ral zho stib, Espíritu Santle nac meṉ ne rnabey zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gacxe waa, gzeed zdoo luu znu rne naa: “Grëse miech, ib none gal zho stib.” ");
INSERT INTO zpmNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nac cuent rii zig nac me ne rtop xcow, zeeṉe rriee me, nëzrii nëz rec zie me, ron luu razh zhoob me; per raṉd luu dieṉ pa nëz zie me dieṉ pa nëz ziaadgaa me. Scaque nagoṉ nac zha ne ral stib, grieelod guieṉ miech zha rnabey Espíritu Sant lo xquieḻmban zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","―Rieṉd naa zha rnee luu ―rëb Nicodem―. ¡Rieṉd naa dieṉ zha grieelo gac grë miṉe rnee luu i! ");
INSERT INTO zpmNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Rëbchaa Jesús: ―¿Rieṉd luu ye zha rne naa? ¡Meṉ rseed miech name nac luu lo meṉguiedz Israel! ");
INSERT INTO zpmNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Miṉe rne naa nu ncuaaṉe rieṉ naaw, ncuaaṉe goṉ naaw, ni rieṉde to zha naca. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Teḻne rieṉd luu zha nac grë miṉe rne naa nu zeeṉe rzet naa ncuaaṉe rac lo guidzliu, ¿zha dzigo guieṉ luu miṉe gne naa teḻne gzet naa grë ncuaaṉe rac gbaa? ");
INSERT INTO zpmNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Wlaltaa gard tso tib zha ne soquia gbaa, per no tib meṉ ne biet gbaa, meṉ cosi soquia me gbaa, sac ga nac zaatne no me; ni lëë meṉ co nu nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ni zigne pquiangaa Moisés tib meeḻ brons tib guic yag zeeṉe nonie me zha Israel dan zit co; scaque none yquiangaa naa tib lo yag, ");
INSERT INTO zpmNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","zeeṉa grëse miech, zha ne gbig dib zdoo zho gnalo zho naa, zgaa zho tib guieḻmban ne gdziṉd dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sac goṉ rleyniedox Dios grëse miech ne ndxie lo guidzliu; gane niicle tib naa nac mëëd lo me per laa me pxeeḻ naa lo guidzliu; zeeṉa grëse zha ne gnalo naa, zgaa zho tib guieḻmban ne gdziṉd dze lozh; led yed zho nitlo. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Laa Dios pxeeḻ naa lo guidzliu par csilaa naa miech lo doḻ, ziaḻd naa par gdziibdoḻ naa miech. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sac grëse zha ne dib zdoo gnalo naa ne naa csilaa zho lo doḻ, nitlod zho. Saṉgue zha ne gnalod naa, laa zho bnitlole ga, sac goṉ Xpëëd Dios nac naa ni bliladzd zho naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Laa zho bnitlole, sac goṉ biaadpaa biini lo guidzliu ni laa ne nleynie zho biini, leḻ guieḻcow bleynie zho, sac guieḻntseeb nac miṉe zienaḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Grëse zha ne ruṉ guieḻntseeb, rlëë zho raṉ zho biini. Ib rbigd zho lo biini, sac racladzd zho xoobneṉ grë guieḻntseeb ne quiayuṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Saṉgue zha ne ruṉ miṉe rnabey Dios, haxta rley zho rbig zho lo biini, zeeṉa glu gaṉle zienaḻ zho miṉe rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ga briee Jesús güeynie me no nëz xtan zha Judé. Xtselaa bliaaz no ga grë no me, rchoobnis me grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Leṉ dze co gard guiab Juan Bautist ladzguiib; dzigo ye me nochoobnis miech zaatne lë Enón gax Salim; sac ga no naal nis. Nzian miech ne rdziṉ lo me ga, rchoobnis me zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tib dzew, wbig tib zha Israel lo zla xpëëdscuel Juan, psilo zho nodiḻdiidz zho dieṉ cho zhiwrobnis nonraa; pe zhiwrobnis Jesúsa, te zhiwrobnis Juana ye. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Blozhse bdiḻdiidz zho, wbig xpëëdscuel Juan lo Juan, rëb zho: ―Maestro, meṉ ne goṉ bzodiidznie luu ro guiubee Jordán ga, meṉ ne scataa bzeet luu lo miech, ¡ye me laa me quiachoobnis miech niina, ni ndal miech niapse lo me zie zho, ziaatraade zho nëz rii! ");
INSERT INTO zpmNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Pquiab Juan rëb Juan: ―Ib Dios rdeed diidz zha guṉ miech tib tib xtsiiṉ me, gacd ne lega zhal zho guṉ zho pe cos. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Miṉe pso Dios naa, laaw beṉ naa: laa naa biaḻlu gaṉle cho nac Meṉ ne zëëble diidz ga cxeeḻ Dios. Ni bneeli naa lo to gaṉle led naad nac meṉ co; laa naa ziaḻ loxaque par gzet naa me lo miech zeeṉa guṉbey zho me. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ible lo me none gdziṉ miech. Nac me niina zig tib mgui ne notsieelnia: Mgui ne notsieelnia, ¡led zha lëë rzobnie ndzoop ne notsieelnia zho! Ni grë zha ne ndzieeldiidz zho, rley zho raṉ zho laa xamigw zho notsieelnia, rley zho ron zho pe rnee xamigw zho. Scadaa nagoṉ rzaac naa niina: rley naa ron naa grë ncuaaṉe ruṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Zigse zie dze, laa me gacnonraa; scagaa naa, zigse zie dze laa naa guiaaṉwinraa. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Nëz gbaa ziaad me, miṉ co ne mazdraa non me lo grë miech. Teḻ naa tib miech guidzliuse nac naa, ni ncuaaṉe rieṉse tib miech lo guidzliu miṉ co rne naa; ");
INSERT INTO zpmNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","saṉgue me, niapse grë miṉe bin me, grë miṉe goṉ me miṉ co rnee me lo miech; ¡ni choot rliladzda! ");
INSERT INTO zpmNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Zha ne rliladzse xtiidz me, rieṉ zho gaṉle niapse diidzli rnee Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Xtiidz Dios rnee me lo miech; sac Espíritu Sant rdeed guieḻbiini lo me, ni Dios nac meṉ ne pxeeḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Rleyniedox Dios me, nac me Xpëëd Dios; gane grëtaa ncuaaṉe no gbaa, no lo guidzliu, ladznia me psaṉ Diosa. ");
INSERT INTO zpmNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Grëse zha ne gnalo me, laa zho bgaale tib guieḻmban ne ib gdziṉd dze lozh; saṉgue zha ne gond xtiidz me, gdziṉd zho gbaa, zaatne ygaa zho guieḻmban co. ¡Grëse zha co, ible zgaa zho guieḻnëdox ne csiaab Dios! ");
INSERT INTO zpmNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Zeeṉe bieṉ Jesús laa zha farisé gocnaṉle ndalraa miech zienaḻ zhiwseed me, ni ndalraa miech ne quiachoobnis me lo Juan ");
INSERT INTO zpmNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(niicle ne led medpaa rchoobnis, sinque zha ne nac xpëëdscuel me zha co rchoobnis), ");
INSERT INTO zpmNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","nacne briee me xtan zha Judé ga, wbire me nëz xtan meṉ Galilé stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Par gdziṉ me Galilé, none ted me xtan meṉ Samar. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Xtan meṉ Samar zieded me, zig groḻ dzew, laa me zie gax guiedz ne lë Sicar, ");
INSERT INTO zpmNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","dzigo güeyted me zaatne quia guiuu ne rnee zho “Zhibzie Jacob”; lo liu ne psaṉ Jacob lo xpëëd me José padzeela. Rdzag me ziaad-zë me lo nëëg co, bdziṉ me bzob me ro guiuu co; ");
INSERT INTO zpmNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","ga blëz me, laa no zio lad guiedz Sicar zioxi no ncuaaṉe dioownie no me. Ro guiuu co zob me bdziṉ tib wnaa Samar ziexi nis ga; dzigo rëbchaa me lo wnaa co: ―Bzhiguieḻ bzoladz niip zhis luu guie naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Bzee zdoo wnaa co goṉ me bnab Jesús nis lo me, sac rlëëdox zha Judé raṉ zho zha Samar, per ni rneed zho lo zho. ―¡Ncuaaṉe gliladzd naa! ―rëb me―. ¡Ti zha Judé gnab nis lo ti zha Samar! Dzigo rëbchaa Jesús: ");
INSERT INTO zpmNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","―Teḻ niaca miṉe guieṉ luu gaṉle cho rnab nis lo luu, ni guieṉ luu zha nactaa ncuaaṉe rzoladz Dios lo miech, haxta znab luu nis lo naa. Ni naasi goṉ, znedz naa nis ne rdeed guieḻmban. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Pquiab wnaa co, rëb me: ―Per ni nzheṉd luu name pe cuee luu nis, ¿pa dzigo tsiebee luu nis ne rdeed guieḻmban ga? ¡Goṉ gaṉle, guietdox bzie rii! ");
INSERT INTO zpmNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Stiba, ¿niacxe mazdraa dzigo nac luu que pxozgol ne Jacob, meṉ ne psaṉ bzie rii? Nu name go me nis grë xma me; niicle grë xpëëd mew, nuque go zho nis. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","―Grëse zha ne rie nis rii ―rëb Jesús―, rbiire rnab zhis zho; ");
INSERT INTO zpmNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","saṉgue nis ne rded naa, zha ne guiew gdziṉdraa dze gnab zhis zho. Sac nis ne gded naa, masaque gdziba zdoo zho zig rdzib nis tib ro zhlian, ni nis co gdeed tib guieḻmban ne gdziṉ dze lozh lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dzigo rëbchaa wnaa co lo Jesús: ―Bzhiguieḻ bneedz nis co guie naa, zeeṉa gnabdraa zhis naa, zeeṉa guiaḻxidraa naa nis nu. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","―Güeygazh ―rëb Jesús―, güeyxi tsieel luu, dzigo goḻtë grop to. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","―Guieṉd tsieel naa ―rëb wnaa co―. Gard ctsieelnia naa. ―Nli rnee luu ―rëb Jesús―; ");
INSERT INTO zpmNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","sac gaay mgui ne zibannie luu, ni tib zho ptsieelniad luu, niicle mgui ne nonie luu niinaw, ptsieelniadaque luu zho. ¡Nli miṉe rnee luu i! ");
INSERT INTO zpmNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Zeeṉe bin wnaa co sca rëb Jesús, rëbchaa me: ―Zootne tib zha ne ziadnee xtiidz Dios lo miech nac luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Teḻ scaw, bzhiguieḻ bnë dieṉ, ¿zha nacne rnee grë meṉ Israel ne leṉ yadoo nroob ne zobpaa Jerusalén, gapaa none tsiegaṉ miech Dios? Sac no ne nac no meṉ Samar, rnee no ne ib guic gui ne zob nu, ga none tsiegaṉ miech Dios; sac grë xmeṉgol no ga güeygaṉ zho Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","24","Pquiab Jesús rëb me: ―Bina gaṉle, zdziṉ dze zeeṉe yquiindraa ne gooṉ guic gui riipaa, o Jerusalénpagaa tsie to tsiegaṉ to Dios meṉ ne nac Pxoz ne. ¡Ni laa dze co ziaadgaxle! Gacdraaw ne dieṉ pa lo tsie ne tsiegaṉ ne Dios, sinque zha ne nlipaa racladz gleynie me, none dib zdoo zho gleynie zho me; zigne gdeedse Espíritu Sant guieḻbiini lo zho. ’Choot grieelod gaṉ Dios; gacxe waa zha ne gleynie me, none gleynie zho me zigne rdeed Espíritu Sant guieḻbiini lo zho; ni none dib zdoo zho gleynie zho me. Ni zha ne sca gleynie me, zha co rguib me. Teḻ to laa to riegaṉse Dios ni ruṉbeyde to me; saṉgue no rdziuuṉbey no meṉ ne riogaṉ no, sac goṉ lo xtii meṉ Israel ziaad meṉ ne guiaadsilaa miech lo doḻ. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","―Nenda ―rëb wnaa co―, per naṉ naa ib ziaad Meṉ ne zëëble diidz ga cxeeḻ Dios, meṉ ne lë Crist; ni zeeṉe laa me guiaad, me gnë diidzli lo no. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Pquiab Jesús, rëb me: ―¡Naa goṉ nac meṉ co! Lëë me nu nonee lo luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lëëtaaque hor co grëse no ne nac no xpëëdscuel me laa no bdziṉ. Bzee zdoo no bdzioṉ no laa me nozodiidznie wnaa co, per ni tib no bnabdiidzd lo me dieṉ pe quianabdiidz me, dieṉ pegaa quiazodiidznie me wnaa co. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Laa wnaa co, zoque xche me ga, rias me laa me zie nëz lad guiedz. Bdziṉ me, rëb me lo grë miech co: ");
INSERT INTO zpmNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―¡Goḻtë gaṉle guṉbey to ti meṉ co! ¡Bzeet me grëse zha nac lo xquieḻmban naa! ¿Bay pe lëdle Meṉ ne nole diidz cxeeḻ Dios ga? ");
INSERT INTO zpmNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Horco briee grë miech co lad guiedz, ziaad zho zaatne goṉ wnaa co Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Laa no, quia no rdeed no ncuaaṉe gow me, per nëd me. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","―Gowd naa ―rnee me―. No stib xquieḻwagw naa miṉe ruṉbeyde to. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dzigo rnabdiidzlsa no, rnee no: ―Bod no cho biaadnie pe dow me, lal ne bio ne lad guiedz. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nëchaa me lo no: ―Lëë xquieḻwagw naa nac ne guṉ naa miṉe rnabey Dios naa, ni csiaaḻ naa dziin ne pxeeḻ me naa ziaḻguṉ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","To lëë rnee to: “Leṉ stapraa mëë csilo gac wlaap.” ¡Per goḻwi lo grëtaa miech qui gaṉle, nac zho niina zig grë guieḻgon ne goḻle gliaap! ");
INSERT INTO zpmNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Gacxe waa, ib none tsie to tsielaap to, tsietop to zho, zeeṉa ygaa zho tib guieḻmban ne gdziṉd dze lozh. Ni zigne razh zha ne rie wlaap, scaque zguizh Dios to tsietop to zho. ¡Ti guieḻbley nrooba, zigtaa par zha ne rana, zigtagaa par zha ne rlaapa! ");
INSERT INTO zpmNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ible nli diidz ne znu rnee: “Zhaa zha ne rie gon, stible zha ne rie wlaap.” ");
INSERT INTO zpmNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Zig nac niina, laa naa rxeḻ to tsielaap to zaatne ni tib xtsiiṉ to psëëbde to; zhaa zha ne güey gon, na tole tsie wlaap. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Laga laa me sca quianee lo no, laa grë meṉladz wnaa co no nëz ziaad zho nëz lo no ga. Nzian grë miech co, zeeṉe bin zho rëb wnaa co bzeet Jesús grë ncuaaṉe ziyuṉ me, bliladz zho Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Laa zeeṉe blanso zho ga, bnab zho lo me cuëz me ladz zho zhis. Dzigo nacne blëz me lo zho chop ngbidz. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nzianraa grë miech co bliladz me, zeeṉe bin zho grë zhiwseed me. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","―Nasi nagoṉ laa no rliladz me ―rnee zho lo wnaa co―, sac nozhal bdzioṉ me, ni bdzion no grë miṉe rnee me. Nliw, ible me nac meṉ ne ziaadsilaa grëse miech lo xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Zeeṉe goc chop ngbidz co, laa no briee ga gza no me, laa no bdzio nëz stib zio no nëz Galilé. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Niicle ne bzeetle me: grëse zha ne ziadteed xtiidz Dios, ib raṉdzed miech zho zaatne nac ladz zho; per ");
INSERT INTO zpmNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","zeeṉe bzëëb me grë guiedz ne ngab Galilé, wen pcaania grë miech co me. Nzian zho güey lni Pascw co Jerusalén, goṉ zho grëtaa milagr ne beeṉ me ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nëz no no bdziṉ no Caná, zaatne sca bzaalo me nis vin. Ga bdzieelo me tib zha Capernaum, tib zha ne rquia dziin lo rey; lëëtaque leṉ dze co rzacnë xpëëd me. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bin me laa Jesús briee xtan meṉ Judé, laa me no gdziṉ Galilé. Dzigo biaad me biaddzieelo me Jesús ga, bnab me lo Jesús tsienaḻ Jesús zhits me Capernaum, tsieguṉguiac Jesús xpëëd me; sac nzhoo rac win. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Dzigo rëbchaa Jesús lo me: ―¿Pe haxta gaṉ to dzigo guṉ naa milagr, dzigoraa gliladz to naa? ");
INSERT INTO zpmNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","―Beeṉ tib guieḻnzaac gotsaa guioniob ne ―rëb meṉ co―, nend znuse lozh xpëëd naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Rëbchaa Jesús: ―Bzë, tsod luu guieḻnë. ¡Laa xpëëd luu biacle! Dib zdoo meṉ co bliladz me xtiidz Jesús, laa me bio nëz laa me zey. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Zhilew gdziṉ me lidz me, zeeṉe bdzieelo me bla zha ne quia xtsiiṉ me, rëb zho laa xpëëd me biacle. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dzigo bnabdiidz me lo zho, maase pa hor biac win. Rëbchaa zho: ―Nieeg, zig rwe ngbidza, tibaque znuse briee zhixlëë win. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dzigo psoladz me zig hor cotaque rëb Jesús lo me, laa xpëëd me biacle. Dzigo dib zdoo me bliladz me Jesús, tsieel me, xpëëd me, meṉlidz me ne, grëse zho dib zdoo zho bliladz zho Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ga goc brop milagr ne beeṉ Jesús lo zha Galilé. Miṉ co beeṉ me zeeṉe wbire me nëz Judé. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Goc palal dzew, laa stib lni nroob rac Jerusalén, dzigo nacne güey Jesús Jerusalén stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ro guiedz Jerusalén, gax zaatne quia puert ne rded mëcwxiil, ga niaa tib pil nis rnee zho Betesd. Igo ro pil co niaa tib nsaap, rap nsaap co gaay arcw. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Lo nsaap co, ga ndxie nzian meṉ rzacnë, no zho roḻd lo, no zho në ni, no zho ib gacd griaḻ grëse zho laa zho ndxie ga quiambëz zho gni lo nis ne no leṉ pil co, ");
INSERT INTO zpmNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","sac nac diidz poc poc riet tib xanjl Dios riesini lo nis co, dzigo zha ne znuse sëëb lo nis co, teḻ pe guieḻguiidztaa rzac zho, riac zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ga nix tib mgui, gocle gaḻptsiipxon iz rzacnë me. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Laa zeeṉe goṉ Jesús me, ni bin Jesús scataale nroob dze rzacnë me, rëbchaa Jesús lo me: ―¿Pe racladz luu guiaac luu? ");
INSERT INTO zpmNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","―Racladz naa ―rëb me―, per guieṉd cho csëëb naa leṉ pil qui zeeṉe laa lo nis rni. Zeeṉe racladz naa sëëb naa, zhaale stib zha ne glo rzëëb. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dzigo rëbchaa Jesús lo me: ―¡Nasca zeeṉa guche i! ¡Bzoli, bi yag ne bzhoob luu i, zeeṉa bzë! ");
INSERT INTO zpmNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Zigne sca rëb Jesús, laa meṉ co biac. Horcogazh blis me yag co, nzëni me laa me briee ga. Ni ne dze co nac tib dze nda lo zha Israel, ");
INSERT INTO zpmNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","zeeṉe goṉ zho ney me yag ne bzhoob me, rëbchaa zho lo me: ―¡Pe rieṉd luu nda nadze! ¡Lëda i goṉ squi yquianlaṉ luu ncuaaṉ qui dze rii! ");
INSERT INTO zpmNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pquiab me rëb me: ―Meṉ ne beeṉguiac naa, mezhal në lo naa, güey naaw. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","―¿Cho meṉ sca në lo luu? ―rëb zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Niicle me rieṉdaque dieṉ chow, sac ndaldox miech ne ndxie ga; hor co laa Jesús bzëëble lad grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Haxta leṉ yadooraa bdzieel Jesús me, dzigo rëbchaa Jesús lo me: ―Nana goṉ ne squi laa luu biacle, bieṉ guṉctaldraa luu xtoḻ luu. Sac teḻne gond luu diidz, nend dzigole glaan luu tib guieḻguidz ne mazdraa ntseeb. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Zeeṉe laa me briee ga, güey me lo zha ne rnabey lo zha Israel ga, rëb me lo zho Jesús nac meṉ ne beeṉguiac me. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nacne psilo zho quianaḻ zho dieṉ zha gnaaz zho Jesús pe nacne ruṉguiac me miech dze nda. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Blisqui zhow lo me, dzigo rëbchaa me: ―Teḻ Pxoz naa gzataa dze quiayuṉ me dziin; ni miṉcoque nac miṉe quiayuṉ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Zeeṉe goṉ zho sca rëb me, mazdraa blëë zho lo me rzac zho tebaa zha gutgazh zho me. Rlëë zho, sac zienaḻd me dieṉ pa dze nda; mazdraa zeeṉe rëb me Dios nac Pxoz me, sac ga rlu me ne lalga nac me con Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ni rëb me: ―Gneli naa lo to gaṉle: peet grieelod guṉ Xpëëd Dios lega guicse me, sinque ncuaaṉe raṉ me ruṉ Pxoz me, miṉ co ruṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nquialadzdox Dios me, grëtaa dziin ne ruṉ Dios rlu Diosa lo me; gane zuṉ me milagr nroob ne mazdraa gzee zdoo to; ncuaaṉe palalse i goṉ to niina ne biac meṉ qui. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sac teḻne gacladz me cueeban me tib meṉgut, zbeeban me zho, zigne rbeebanaque Pxoz me meṉgut. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ni bzo Dios me, me guṉ guieḻwxtis, ");
INSERT INTO zpmNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","zeeṉa grëse miech guieṉ gaṉle zigne nonaque Pxoz me, scaque meṉ non nac me, ni sca none guṉnon zho me. Sac teḻ zha ne guṉnond me, yele Pxoz me ga (meṉ ne pxeeḻ me) ruṉnond zho. Ni rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","―Gneli naa lo to gaṉle: Zha ne gliladz xtidz naa, ni gliladz zho meṉ ne pxeeḻ naa, laa zho bgaale tib guieḻmban ne gdziṉd dze lozh. Led yedraa zho ygaa guieḻnëdox ne ygaa grëraa miech ntseeb; sac laa zho brieele ladznia guieḻgut ga, bdziṉ zho lo guieḻmban co. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Zdziṉ dze zeeṉe ye grë meṉgut, zon zho xtiidz Xpëëd Dios; ni grëse zha ne gzoobdiaga, zban zho. ¡Ni lëë dze co bdziṉ niina! ");
INSERT INTO zpmNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sac goṉ, zigne rdeed Dios guieḻmban lo miech, scaque zrieelo gded naa guieḻmban lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ni bzo me naa, naa guṉ guieḻwxtis, gded naa miṉe tsieguiaḻ tib tib miech. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","’¡Gzeed zdoo to! Sac ne nligaa, zdziṉ dze, grëse meṉgut ne no leṉ baa, laa zho grieeban ");
INSERT INTO zpmNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","zeeṉe gon zho tsi naa. Grëse zha ne ndzinli wban, hor co laa zho ygaa tib guieḻmban ndzon; saṉgue zha ne beeṉ guieḻntseeb, hor co laa zho guey lo guieḻnëdox ne rieguiaḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Per grieelod guṉ naa guieḻwxtis naase, ib none gacnaṉ Pxoz naaw. Grëse guieḻwxtis ne guṉ naa, laaw guṉ naa zigne gnabey Pxoz naa, laaw guṉ naa zigne nonguieḻa, sac goṉ guṉd naa miṉe guiaabtaa guic naa, sinque laa naa guṉ miṉe racladz Pxoz naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","’Teḻne niaca miṉe naase rne cho nac naa, zrieequia zha ne guiab nlida. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Per na, no stib meṉ ne rzeet naa lo miech; ni naṉ naa diidzli rnee me. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Haxta Juan Bautist, zeeṉe pxeeḻ to bla zha ne güeynabdiidz lo me, grëse miṉe rëb me lo zho ga, diidzliw. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Laa naa rzet miṉ rii lo to, zeeṉa gliladz to cho nac naa, zeeṉa sca laa to lo xtoḻ to; sac rquiindpaa dieṉ cho miech guidzliu rii gnee cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zeeṉe biaad Juan, goc me zig tib biini bziini me lo to palal dze zeeṉa guṉbey to naa; ni bley to pquiaadiag to miṉe bnee me. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nli bnee me cho nac naa; per grë milagr ne ruṉ naa miṉ co quiaxobneṉraa gaṉle cho nac naa. Pxoz naa rneedz diidz ruṉ naaw; ni ga rlu gaṉle ne me pxeeḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Haxta ye me mezhal quialu gaṉle cho nac naa, parga nli gard gaṉ to me, niicle gard gon to tsi me. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ronde to pe rnee me, sac rliladzde to naa; sac goṉ me pxeeḻ naa ziaḻne naa xtiidz me. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","’Nli rioxco to rseed to grë guits ne ziaad Xtiidz me, sac rieṉ to ga ziaad dieṉ zha ygaa to guieḻmban ne gdziṉd dze lozh. Ni niicle ne lo co zhobnee gaṉle cho nac naa, ");
INSERT INTO zpmNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","per nëde to gbig to lo naa, zeeṉa ygaa to guieḻmban co. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nëde to guṉbey to naa, nëde to guieṉ to cho nac naa, per peet nacd miṉ co; ");
INSERT INTO zpmNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ruṉbey naa to, ni lalnu rleyniede to Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Sac goṉ, me pxeeḻ naa ziaḻ naa lo to, ni rlëë to raṉ to naa; mazd zha ne lega ziaadse, zha cosi lëëlëd rcaania to zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¡Miṉ co goṉ, ib rliladzde to cho nac naa! Sac laa guic to zienie loxaque dieṉ zha guṉnon samiech to to, ib rguibde to zha gacnon to lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ni guiabde to togo naapaa gazo to lo Pxoz naa, glisqui naa grë ncuaaṉe ruṉ to. Moisés goṉ nac meṉ ne glisquiw; sac ley ne psaṉ me, miṉe rnalo to csilaa to lo xtoḻ to, lëëw glu gaṉle pe nac grëtaa ncuaaṉe quiayuṉ to. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sac goṉ, teḻne niaca miṉe nlipaa rliladz to grë miṉe pquiaa Moisés, zliladz to dzigo cho nac naa; goḻgaṉ gaṉle, lo grë guits ne pquiaa me, ga rzeet me naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Rlu rliladzde to grë miṉe pquiaa Moisés ga, gane rliladzde to miṉe rne naa lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bded ga, tib dzew briee Jesús bdedquia me nëz daṉ ro Nisdoo Galilé (lëëque nisdoo co ga rnee zho Nisdoo Tiberias). ");
INSERT INTO zpmNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Miech guizhiu ne brieenaḻ zhits me, sac ziyaṉ zho grëtaa milagr ne ruṉ me, ruṉguiac me grë meṉ rzacnë. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Nzian zho nac zha ne zie lni Pascw, lni nroob ne rac Jerusalén gzobse iz. Grëse no ne nac no xpëëdscuel me, laa no naḻ zhits me. Zeeṉe bdieedquia no ro nis co, dzigo bdzieep no tib cho gui win zob gax ga. Loxaque laa no bzioob ga grë no me, ");
INSERT INTO zpmNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","zeeṉe bdzioṉ no miech guizhiu ne ziaadquia cho gui co, laa zho glansole lo no ga. Dzigo rëbchaa me lo Lip: ―Lip, ¿pa guioziu ne ncuaaṉe gow grëtaa miech qui? ");
INSERT INTO zpmNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Per lega scase rëb me lo Lip, par dieṉ pe guiab Lip; sac naṉle me pe nac ncuaaṉe guṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","―¡Ne nligaa pe zhidaa zho! ―rëb Lip―. Niicle teḻne niaca miṉe gziuu nzian gayoo guietxtil, ni ygaad ncuaaṉ co ygaa zho tiblë wingaw tib tib zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dzigo pquiab Ndrés, bets Pedr, stib zha ne nacgza no; rëb Ndrés: ");
INSERT INTO zpmNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nu zo tib mëëdbgui win ney gaay guietxtil cebad ni schop meḻ win. ¿Per pa ygaa ncuaaṉ co lo grëtaa miech qui? ");
INSERT INTO zpmNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","―Goḻnee lo zho dieṉ ―në me lo no―. Goḻguiab lo zho sob zho. Ndzon zëëb guizh nguia ga, dzigo laa grë miech guizhiu co bzob lo guizh nguia co (zig gaay mil rgaa loxaque zha bguise). ");
INSERT INTO zpmNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dzigo bnaaz me gza guietxtil co, bdeed me xquizh lo Dios. Blozhse ga, zigse rneedz mew lo no scase scase rguiiz now lo grë miech co; scaque beeṉ me grop meḻ co. ¡Grëse miech co, dow zho zaatne bieltaa zho! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Blozhse dow zho, nëchaa me lo no: ―¡Goḻtsietop grëse miṉe biaaṉ i, zeeṉa nitloda! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Psilo no ptop no grë guietxtil ne biaaṉ ga, zeeṉe blozh bdopa, ¡lo gaay guietxtil cebad co, biodzë tsiipchop chicuid biow! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Zeeṉe goṉ grë miech co milagr ro ne beeṉ Jesús ga, rneechaa zho: ―¡Ne nlipagaa, lëë meṉ qui ga quiambiaaz ne! ¡Me nac Meṉ ne zëëble diidz ga cxeeḻ Dios lo guidzliu guiadteed xtiidz me! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bieṉga Jesús racladz zho, zhoo tsienie zho me gac me zhirey zho, nacne bzoquia me guic gui win co, tipse me. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Rguetsle liuw, bzhiuxto no dan bdziṉ no ro nisdoo co; ga bliaaz no me. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bdzioṉse no choot rlansod ni laa liu rcowraa, dzigo mazd laa no bziaab leṉ canó, laa no zio nëz Capernaum. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Laa no zionie canó co lo nis, tibaque zeeṉe psilo rriee me, ntseeb riasoli lo nis co. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Maase gaay kilómetro o xoopgaaw goc zio no, tibaque zeeṉe bdzioṉ no laa me ziaad-zë lo nis co, gaxle lo no ga. Zeeṉe bdzioṉ no sca ziaad-zë me lo nis, bdzieeb no. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Dzigo bnee me, në me lo no: ―¡Gdziebde to! ¡Naa ziaḻ nu! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dzigoraa rley no bdzioṉ no laa me bzëëb leṉ barcw; tibaque zeeṉe bieṉ no laa no brieequiale zaatne no gdziṉ no ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Biini liu co, grë miech ne biaaṉ stib nëz ro nis co, laa zho bdziṉ zaatne nac ro nis ga, quiambëz zho gaṉ zho me. Sac goṉ zho tibaque barcw zo ga, ni zeeṉe wbii no ga, loxaque nose wbii. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Gax zaatne bguiaaṉ me zho ga, ga bdziṉ bla barcw ne ziaad nëz Tiberias; ");
INSERT INTO zpmNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","dzigo goṉse zho niicle me niicle no ne nac no xpëëdscuel me, choot guieṉd ga, nacne bzëëbaque zho leṉ barcw ne bdziṉ ga ziaad zho nëz Capernaum. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Zeeṉe blanso zho Capernaum, laa Jesús zole lo no ga; dzigo rëbchaa zho lo me: ―Maestro, ¿pa horzhe waa blanso luu nu? ");
INSERT INTO zpmNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Dzigo rëbchaa me: ―¿Naa lëë ziaadguib to? Per ziaate to porne rieṉ to cho nac naa, sinque laa to ziaad porne goṉ to bnedz naa ncuaaṉe pquiin to. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","¡Goḻguieṉ, tsienied guic to loxaque ncuaaṉe gowse to, sac znuse rnitlo grë ncuaaṉ co! Sinque, goḻtsoxco goḻguṉ miṉe racladz Dios, zeeṉa ygaa to tib guieḻmban ne ib gdziṉd dze lozh. Ni naa ne nac naa Mgui ne pxeeḻ me, naa gneedz guieḻmban co lo to; sac ible miṉ co pxeeḻ me naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dzigo bnabdiidz zho lo me, rëb zho: ―¿Zha dzigo dziuuṉ no miṉe racladz Dios? ¿Pe nac ncuaaṉe dziuuṉ no? ");
INSERT INTO zpmNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Pquiab me rëb me: ―Miṉe racladz Dios guṉ to: gliladz to cho nac meṉ ne pxeeḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","―Teḻne scaw ―rëb zho―, none dziaṉlo no guṉ luu nzian milagr, zeeṉa gliladz no luu. ¡Nligaa peet milagr nroob gard dziaṉ no guṉ luu! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Teḻ grë pxozgol ne, zeeṉe wban zho grë dan bidz co padzeela, gzobse dze biet tiblo guietxtil zhan gbaa, dow zho; rnee lo Xtiidz Dios: “Moisés rdeed guietxtil co lo zho.” ");
INSERT INTO zpmNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Pquiab me rëb me: ―Goḻgacnaṉ gaṉle led Moisésd bdeed guietxtil co, sinque Pxoz naaw. Ni niina goṉ laa me quianeedz merpaa guietxtil gbaa lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sac goṉ, me pxeeḻ meṉ ne biet gbaa ziaddeed guieḻmban lo grë miech rii; meṉ co nac guietxtil gbaa co. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","―Beeṉ tib guieḻnzaac sca ―rëb zho―, ¡gzataa dze bneedz guietxtil co dioow no! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Pquiab me rëb me: ―Naa goṉ nac guietxtil ne rdeed guieḻmban ga. Grëse zha ne gbig lo naa sëëb zho xnëz naa, gdziṉdraa dze ne ycaabedz zho; grëse zha ne gliladz cho nac naa, gdziṉdraa dze ne gnab zhis zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Laa to goṉ, zigne bnelegaa naa lo to ga, ¡niicle raṉ to naa, per rliladzde to cho nac naa! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Grëse zha ne rxeeḻ Pxoz naa, rlanso lo naa; ni tib zho ctsireed naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sac goṉ, laa naa bieet gbaa ziaḻguṉ naa miṉe racladz Pxoz naa (meṉ ne pxeeḻ naa); bieete naa par guṉ naa miṉe gacladztaa naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ni miṉe racladz me, grëse zha ne bneedz me lo naa, ni tib zho nitlod, sinque cueeban naa zho gaḻ dze ne laa guidzliu nitlo. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Sac racladz me: grëse zha ne gbig lo naa ni gliladz zho naa dib zdoo zho, grëse zho ygaa tib guieḻmban ne ib gdziṉd dze lozh, ni cueeban naa zho gaḻ dze ne nitlo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Dzigo psilo grë zha Israel rneenë zho me, loxaque ne rëb me, me nac guietxtil ne biet gbaa; ");
INSERT INTO zpmNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","rnee zho: ―Meṉ rii ga name rnee zho Jesús, me nac xingan José. Rdziuuṉbey ne xniaa me, rdziuuṉbey ne pxoz me. ¿Zha nac dzigo ne rnee me gbaa biet me? ");
INSERT INTO zpmNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dzigo rëbchaa me lo zho: ―Lëëwga na, goḻsioog ro to. Nodne squitaa gzee zdoo to miṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Laa Pxoz naa pxeeḻ naa ziaḻ naa lo guidzliu, per ni tib miech goṉ grieelod gbig lo naa teḻne niaca miṉe cuedzd me zho; ni zig rnele naa ga, zha ne gbig, naa cueeban zho gaḻ dze ne laa guidzliu nitlo. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Znu rnee lo Xtiidz Dios, zaatne pquiaa grë zha ne biadteed xtiidz me padzeela, rneew: “Laa Dios cseed grëse miech.” Ni lëë miṉ co rac niina; gacxe nagoṉ waa, grëse zha ne rquiaadiag miṉe rnee Pxoz naa ni rseed zhow, grëse zha co lo naa rlanso zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Zha ne rlanso lo naa, guiabde to togo goṉlo zho me; ni tib choot gard gaṉ me, naase nac meṉ ne ziyaṉ me, sac zaatne no me ga brie naa ziaḻ naa lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Goḻliladz miṉe gni naa lo to nu sca: ¡Grëse zha ne dib zdoo zho gliladz zho cho nac naa, zgaa zho tib guieḻmban ne gdziṉdraa dze lozh! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ne nligaa naa nac guietxtil ne rdeed guieḻmban ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Grë pxozgol to, zeeṉe sca bio zho grë dan bidz co, nli dow zho guietxtil ne biet gbaa ga, per bdeetew guieḻmban lo zho, sac grëse zho gut. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Saṉgue guietxtil ne rne naa lo to, gbaa bieta ni grëse zha ne yquiina zgaa zho tib guieḻmban ne gdziṉd dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Xcuerp naa nac guietxtil ne biet gbaa, miṉe rdeed guieḻmban ga; grëse zha ne gow guietxtil co, zgaa zho tib guieḻmban ne gdziṉd dze lozh. Lëëw gded naa zeeṉa grieelo ygaa grëse miech lo guidzliu rii stib guieḻmban. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Psilo grë zha Israel co stib, quianeelsa zho, rnee zho: ―¿Zha nacne squi rnee meṉ qui? ¡Zootne rnee me none dioow ne xcuerp me! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","―Gneli naa lo to gaṉle ―rëb me―, teḻne gowde to xcuerp Mgui ne pxeeḻ Dios, ni guiede to xchen me, ygaade to stib guieḻmban co. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Saṉgue zha ne gow xcuerp naa, ni guie zho xchen naa, ib zgaa zho guieḻmban ndzon ne gdziṉd dze lozh ga, ni naa cueeban zho gaḻ dze ne laa guidzliu nitlo; ");
INSERT INTO zpmNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","sac xcuerp naa nac miṉe mazdraa rquiin gow miech, ni xchen naa nac miṉe mazdraa rquiin guie zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Grëse zha ne row xcuerp naa, ni rie zho xchen naa, mbannie zho naa, niiclegaa naaw mbannie naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Meṉ mban nac Pxoz naa, meṉ ne pxeeḻ naa, me nac meṉ rneedz guieḻmban lo naa; ni scaquegaa zha ne gow xcuerp naa, naa gded guieḻmban lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Naa nac guietxtil ne nlipaa biet gbaa. Grëse zha ne gow guietxtil rii, zgaa zho guieḻmban; led yed zho guet zig gut grë pxozgol to, zha ne sca dow guietxtil co. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Lëë grë miṉ rii bnee Jesús zeeṉe pseed me miech leṉ yadoo win ne zob Capernaum. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nzian grë zha ne rzënie Jesús, zeeṉe bin zho grë miṉe bnee me ga, rneechaa zho: ―Zha ngaṉdoxtaa nac grë diidz ne rnee me i. ¡Cho gnë dieṉ pe bnee me! ");
INSERT INTO zpmNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bieṉ Jesús sca nonee zho, dzigo rëbchaa me lo zho: ―¿Pe rlëë guic to bin to miṉe rne naa ga? ");
INSERT INTO zpmNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Pe guiabzhe to dzigo zeeṉe gaṉ to laa Mgui ne pxeeḻ Dios soquia gbaa, gbiire guey me zaatne no me glo? ");
INSERT INTO zpmNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espíritu Sant rneedz guieḻmban lo to, teḻne guieṉd espíritu peet nond xcuerp to, sac bëëlse naca. Ni grë diidz ne bne naa lo to, lëëw nac Espíritu, ni lëëw gneedz tib guieḻmban ne gdziṉd dze lozh lo to; ");
INSERT INTO zpmNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","sinque to, bii no zla to rliladzd cho nac naa. Sca rëb me sac desde psilo bzënie zho me, rieṉle me cho nac zha ne ib rliladzd me, ni cho nac zha ne tsieto me. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","―Ruṉbey naa to ―rëb me―, gane ni naa lo to ni tib miech grieelod gbig lo naa sëëb zho xnëz naa, teḻne niaca miṉe cuedzd Pxoz naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nzian zha ne rzënie me, hor co laa zho bzozit lo me, bzëniedraa zho me. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Dzigo bnee me lo no gza tsiipchop no ne nac no xpëëdscuel me, në me: ―To waa, ¿pe led yede to racladz gbiche lo naa? ");
INSERT INTO zpmNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pquiab Simón Pedr, rëb Simón: ―¿Per cho loraa nadieṉ guio no? Luuse nac meṉ ne rseed miech diidz ndzon ne rdeed guieḻmban ne gdziṉd dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Laa no bliladzle cho nac luu, laa no gocndioṉle ne luu nac Meṉ Ndzon ne pxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","―Nliw ―rëb me―, ni naa bzooblo to gza tsiipchop to, per na goṉ laa tib to bzëëble xnëz meṉdox. ");
INSERT INTO zpmNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Zeeṉe sca rëb me, lëële Judas ga bzeet me (zhin Simón Iscariot); sac ye Judas nacgza no lo tsiipchop no ne bzooblo me ga, ni Judas nac zha ne güeyto me. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bded ga, loxaque grë guiedz ne ndxie xtan zha Galilé, gase rieted Jesús. Sac grë zha Israel ne no xtan zha Judé, zha ne rlëë lo me, racladz zho gut zho me. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Laa zeeṉe bdziṉ dze ne ruṉ zha Israel lni ne rzhixcuaa zho grë yu guizh, ni rbëz zho leṉa; ");
INSERT INTO zpmNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","rëbchaa zha bets me lo me: ―¿Pe nacne ib rrieed luu nu? Briee zho, güey dib xtan zha Judé, zeeṉa ye grë zha ne racnie luu ga gaṉ grëtaa ncuaaṉe ruṉ luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sac goṉ, zha ne racladz guṉbeyraa miech zho, grë ncuaaṉe rac zho, ruṉd zhow ngueets zhliaan zigne ruṉ luu. Rac luu name ruṉ luu grë milagr nroob, beeṉa zaatne gaṉ nzian miecha. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","6","Sca rnee zho lo me, sac niicle zha rliladzd cho nac me; dzigo rëbchaa me: ―Grieelod ga naa niina, sac gard gdziṉ dze co; zhaa nac to, zac tsie to zeeṉe gacladztaa to. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Teḻ to, rlëënied miech to; saṉgue naa rlëënie zho naa, sac rne naa lo zho pe nac grë guieḻntseeb ne ruṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Goḻtsie, tedse lni rii dzigo ga naa; sac gard gdziṉ dze ne glu cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Dzigo laa me biaaṉ ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Per loxaque briee zho zie zho, yeque me briee zie me; lëëraasi ngueetsse bdziṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Grë zha Israel ne rlëë lo me, quiaguib zho me lo lni co. ―¿Bay yo meṉ co? ―rnee zho―. ¿Pe nacne ib choot gard dziaṉ me? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Grë zha ne ndxie lo lni, loxaque me rzeet zho. No zho rnee: “Tib miech wen nac me”; nogaa zho rnee: “Pe miech wen na zho gac me, loxaque noquidie me miech.” ");
INSERT INTO zpmNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Per zhliaanse rzodiidz zho rzeet zho me, sac rdzieb zho grë zha Israel ne rlëë lo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Goc chop tsoṉ ngbidz ne noyac lni, tibaque zeeṉe laa me bzëëb leṉ yadoo nroob ne zob lad guiedz ga, psilo me pseed me grë zha Israel ne no leṉ yadoo ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Zeeṉe goṉ zho zha rseed me, rzee zdoo zho rnee zho: ―¿Zha nac squitaa rac meṉ qui, ni laa me pseete me grë zhiwseed yadoo? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pquiab me rëb me: ―Led naad nobeebey grë miṉe quiaseed naa miech, sinque laa naa quiaseed zho miṉe rnabey meṉ ne pxeeḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Teḻne yquiabladz to guṉ to miṉe rnabey me, ga guieṉ to dieṉ pe nli xtiidz Dios rseed naa miech, te miṉe riab guic naaw ye. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sac grë zha ne rnee grë miṉe riab guicse zho, laa zho ruṉa zeeṉa gacnziuu zho lo miech; saṉgue zha ne rioxco glu ne non meṉ ne pxeeḻ zho, zha cosi niapse diidzli rnee zho, ruṉd zho ne yquidie zho miech. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Laa Moisés psaṉ ley lo to, per, ¡ni tib to goṉ zienaḻd miṉe rnabeya! ¿Pe nac dzigo racladz to gut to naa? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Pquiab be grë miech co, rëb zho: ―¡Meṉdzable i goṉ noguitnie guic luu! ¿Chozhe racladz gut luu? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Rëbchaa me: ―Tib vuelt, loxaque goṉ to beeṉguiac naa tib meṉ rzacnë dze ne rdziiladz to lo dziin, na grëga to squitaa rac lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ni to goṉ, no hor par guṉ to miṉe rnabey ley ruṉ to dziin dze co; zig nac zeeṉe rio tib mëëd bey (niicle ne riole pxozgol to bey co, zeeṉe laa ley biaaṉ). ");
INSERT INTO zpmNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","¡Gase na gaṉle goḻwi! Rquia to rgo to tib mëëd bey haxta dze ne rdziiladz to lo dziin, loxaque par quiitsde to xley Moisés. ¿Pe nac dzigo ne rlëë to lo naa loxaque ne beeṉguiac naa tib miech dze co? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Goḻguieṉ gaṉle, nonguieḻd ne lega gdziibdoḻ to tib miech. Goḻtsoxco goḻtsienaḻ miṉe nac diidzli. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Blalaa meṉ Jerusalén ndxie ga, dzigo psilo zho rnabdiidzlsa zho rnee zho: ―¿Pe led meṉ riid ga zho scataa quiaguib zho gut zho? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pa zotaa me goṉ quianee me lo grë miech qui, ni choot peet ruṉd me. ¿Pe gooṉ bliladzle zhiwxtis ne naye ne me nac Meṉ ne zëëble diidz ga guiaad lo guidzliu? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Per gacda meṉ qui. Teḻ meṉ quiw, rdziuuṉbey ne me, ndioṉ ne cho zha nac me; saṉgue Meṉ ne zëëble diidz guiaad ga, zeeṉe gaḻ dze ne laa me guiaad, choot gacnaṉd dieṉ cho zha me. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bin Jesús sca nonee zho. Squi ndxie grë zha ne noquiaadiag zhiwseed me leṉ yadoo ga, nguiedz bnee me rëbchaa me: ―Ah, conque ruṉbey to naa dzigo, ¡naṉ to pa nëz ziaḻ naa! Per led zhaald naa goṉ ziaḻ naa, no tib meṉ ne pxeeḻ naa per ruṉbeyde to me; meṉ co nac meṉ ne rnee niapse diidzli. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Saṉgue naa ruṉbey naa me, sac lo me brie naa, me pxeeḻ naa ziaḻ naa lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Dzigo gocladz zho naaz zho me ga, per ni tib zho wbigd nzheṉ zho me; sac gard gaḻ dze co. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Grë zha ne ndxie ga, ndal zho bliladz me. ―Teḻne led med nac Crist ―rnee zho―, niacxe zuṉ me grëtaa milagr nroob ne ruṉ me. ¡Tsodraa zha ne guṉ grëtaa milagr ne ruṉ me! ");
INSERT INTO zpmNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bin zha farisé nozeet grë miech co Jesús, dzigo bnediidzaque zho grë zho pxoz ne rnabey, pxeeḻ zho bla zhaguiib zie zienaaz me. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Bdziṉ grë zhaguiib co, rëbchaa me lo zho: ―¡Goḻxecw zniip! Zhile dze ne cuëz naa lo to; ib laa naa none gbiire guia naa lo meṉ ne pxeeḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Zguib to naa, per gdzieldraa to naa, ni grieelod gdziṉ to zaatne guia naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Grë zha ne ndxie ga, zeeṉe bin zho sca rëb me, rzee zdoo zho. ―¿Pa naczhe zaatne tsie me? ―rnee zho―. ¿Zha nacne ib gdzield ne me? Nend grë zha ladz ne tsieseed me, grë zha ne no stib ladz beṉ. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Zha nacne rnee me, zguib ne me per gdzield me lo ne, niicle grieelodgaa guio ne zaatne guey me? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Zeeṉe goḻ dze ne laa lni co lozh (dze co nac dze ne mazdraa nroob), miech guizhiu ne ndxie; dzigo nguiedz bnee Jesús lo grë miech co, rëb me: ―Grëse zha ne racladz guiaaṉwen zdoo, rzac zho zig nac zeeṉe rnab zhis zho, guiaad zho lo naa, naa gded nis ne guie zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Sac grëse zha ne dib zdoo gliladz cho nac naa, rnee lo Xtiidz Dios, masaque rrieequia tib nis ndzon ne gdzib zdoo zho, pale tib guiubee nroob; nis co gdeed tib guieḻmban cub lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sca bzeet Jesús Espíritu Sant. Ga bzeet me, grëse zha ne gliladz cho nac me zacnie Espíritu Sant zho. Gard guiaad Espíritu Sant leṉ dze co, sac gard gbire Jesús lo guieḻndzon ne no me gbaa hor co. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Blalaa zha ne ndxie ga, zeeṉe bin zho sca bnee me, rneechaa zho: ―Ne nlipagaa, lëë meṉ qui ga no guiaad antes ne glanso Meṉ ne nacle diidz cxeeḻ Dios ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Rrieequia zla zha ne rnee: ―¡Lëda! ¡Lëëgazh me i! Meṉ qui nac Meṉ ne zëëble diidz ga cxeeḻ Dios guiaad lo guidzliu. Rquiab zla zha ne rnee: ―Meṉ Galilé nac meṉ qui. ¿Niacxe lo xtii grë zha co grieequia Meṉ ne cxeeḻ Dios ga? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pe led rnee lo Xtiidz Dios lo xtii rey David, ga grieequia me ni Belén ga gal me, zaatne gocaque ladz rey David. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Zhaase zhaase rnee zho; leḻ psilo zho nodiḻdiidz zho dieṉ cho nac me. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Brieequia bla zho gocladz naaz me, per ni tib zho wbigd nzheṉ zho me. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Grë zhaguiib ne zienaaz me ga, scase zho laa zho bdziṉ. Zeeṉe goṉ grë pxoz rnabey co, grë zha farisé co choot bdziṉnied zho, rëbchaa zho: ―¿Pe nac dzigo ne ziaadniede to me? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pquiab zho rëb zho: ―¡Wlaltaa gard dziaṉ no tib meṉ ne scataa ndzon rnee! ");
INSERT INTO zpmNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Rëbchaa zha farisé: ―¡Pe nlipaa rnee to! ¿Yelaque to dzigo beeṉgüet me? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Pe rwide to, niicle zhiwxtis new, niicle now, ni tib choot rliladzd ne me nac Meṉ ne zëëble diidz cxeeḻ Dios ga? ");
INSERT INTO zpmNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Grë zha nxen ne rliladz ne nli Dios pxeeḻ me, ¡miech ndziibdeele nac zho, sac goṉ rieṉd zho zha rnee lo ley! ");
INSERT INTO zpmNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ga zob Nicodem, meṉ ne güeyzodiidznie Jesús ga glo, ye me nacgza grë zha rnabey co, dzigo guso me bnee me lo zho, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Goḻguieṉ gaṉle nonguieḻda ne lega pe gnee ne. Sac goṉ, zig nac xley ne, rnabeya none gacndioṉgazh ne zha nac xtiidz tib miech, dieṉ pe nac miṉe quiayuṉ zho, dzigoraa gac guieḻwxtis. ");
INSERT INTO zpmNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Pquiab zho rëb zho: ―¿Zootne ye luu lëë nacgza grë zha Galilé ne rleynie me? ¡Grë zha ne cxeeḻ Dios, ni tib zho grieequiad Galilé! ¡Luuzhal bguiba lo grë guits ne ziaad Xtiidz Dios gaṉle, zeeṉa gliladz luu! ");
INSERT INTO zpmNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Blozh ga, grëse zho laa zho wbi, tib tib zho zeyse zho lidz zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ga briee Jesús güey me zaatne rnee zho Gui Oliv. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Zeeṉe biini liu co, silgaw laa me bdziṉ leṉ yadoo co stib. Nzian miech ne goclo lo me ga, nacne bzob me psilo me pseed me zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Laa me noseed grë miech co, zeeṉe bdziṉ bla maistr ley, ni zla zha farisé, bdziṉnie zho tib wnaa ne nole tsieel ni bgaanie me stib mgui; dzigo bzo zho wnaa co glowtaa lo grë miech ne ndxie ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","―Maestro ―rëb zho lo Jesús―, laa wnaa rii bgaa nonie me stib mgui. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","¿Pe gnë luu dieṉ zha gac me? Sac zig nac ley ne psaṉ Moisés, rnabeya gdeedquie no grë wnaa ne squi nac, haxta guet zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sca rëb zho, sac laa zho quiaguib dieṉ zha cxiṉ me tib diidz, zeeṉa sca grieelo tsiezo zho me lo wxtis. Per zeeṉe bin me sca rëb zho pquiitsrunga me liu, psilo me con mzhugnia me noquiaa me lo liu. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Raṉ zho rquiabd me, wbiire zho bnabdiidz zho lo me stib; haxta blis lo me, rëb me lo zho: ―Peet nacda, goḻdeedquie me. ¡Lëëraasi, zha ne rieṉ ni tib doḻ rapd, zha co csilo gdeedquie me! ");
INSERT INTO zpmNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Blozh ga biire pquiitsrun me, psilo me stib noquiaa me lo liu. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Zeeṉe bin zho sca rëb me, mazd miṉe beeṉ zho laa zho briee ga, sac bieṉ zho miech ngoopdoḻ nac zho. Zha ne nacpaa zha gol lo zho bner, blozh ga zo zo briee zho grë zho; loxaque wnaa cose biaaṉ ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dzigo bzoli me, rëb me lo wnaa co: ―¿Yo grë zha ne scataa biaad-zo luu nu? ¿Ni tib zho lëë beeṉquizhd luu xtoḻ luu? ");
INSERT INTO zpmNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","―Ni tib zho ―rëb wnaa co. ―Niicle naa ―rëb Jesús―, guṉquizhd naa luu xtoḻ luu. Bzë, per bieṉ gbiiredraa luu guṉ luu grë ncuaaṉe guṉctal xtoḻ luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Bded ga, tib dze nonee Jesús lo grë zha ne noquiaadiag zhiwseed me, rëb me lo zho: ―Nac naa zig nac tib biini ne rziini lo miech. Grëse zha ne gbig lo naa, led yed zho sorieḻ ni lo ncow, sac naa gziini lo zho zeeṉa ygaa zho tib guieḻmban ndzon. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Zeeṉe bin zha farisé sca rëb me, psilo zho nguiedz roptsie zho rnee zho: ―¡Cho gliladz xtiidz luu! ¡Lëëque luu rnee cho nac luu! ");
INSERT INTO zpmNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pquiab me rëb me: ―Niicle ne naaque rne dieṉ cho nac naa, per diidzli nac miṉe rne naa. Rieṉ naa pa nëz ziaḻ naa, pa nëzgaa za naa; saṉgue to goṉ peet rieṉde to, ");
INSERT INTO zpmNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","gacxe waa, rcaadzdoḻ to naa ncuaaṉe ni nacd naa; ncuaaṉe rcaadzdoḻ to naa, niapse guic to riaba. Teḻ naa, zig nac niina noyuṉd naa guieḻwxtis ");
INSERT INTO zpmNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","per zeeṉe gdziṉ dze co, tib tib miech miṉe beeṉ zho miṉ co glu dieṉ pe nac miṉe tsieguiaḻ zho; sac Pxoz naa meṉ ne nacnie naa, me gnë zha guṉ naa guieḻwxtis. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","¿Pe nacne rliladzde to miṉe rne naa? Led rnee lo xley to zeeṉe tipse rzë xtiidz chop miech, ga rlu ne diidzli rnee zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Zig nac niina, naa nac tib zha ne rne cho nac naa, laa stib zho nac Pxoz naa meṉ ne pxeeḻ naa; sac goṉ ye me rnee gaṉle cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pquiab zho rëb zho: ―¿Yo Pxoz luu na? ¿Pa no me? ―Ruṉbeyde to me ―rëb Jesús―, sac niicle naa ruṉbeyde to naa. Teḻne niaca miṉe ruṉbey to naa, ruṉbeyle to me na. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Gax zaatne riesaṉ miech gon leṉ yadoo nroob ne zob lad guiedz Jerusalén, ga zob Jesús zeeṉe sca rëb me; per choot bnaazd me, sac gard gaḻ dze co. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Bded ga, biire Jesús rëb me: ―Laa naa guia nagoṉ. Squiaguib to naa, per lëëque lo xtoḻ to i nitlo to, sac zaatne guia naa grieelod gdziṉ to ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Grë zha Israel ne ndxie lo me ga, rneechaa zho: ―¿Pe gooṉ lëëque me naye gut me? Zha nacne squi rnee me gooṉ grieelod gdziṉ ne zaatne guey me. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","―Teḻ to ―rëb me―, zha nëz lo guidzliu nac to; laa naa goṉ zha nëz gbaa nac naa. Meṉ guidzliu rii nac to, saṉgue naa nacd naa zha guidzliu rii. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gane ni naa lo to lëëque lo xtoḻ to i nitlo to. Ne nligaa, teḻne gliladzde to ne naa nac meṉ ne nac naa, ible lëëque lo xtoḻ to nitlo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","―¿Cho dzigo nac luu? ―rëb zho. Rëbchaa me: ―Blactaale rne naaw lo to. Haxta zeeṉe psilo naa xtsiṉ naa, laa naa rne lo to gaṉle cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ndal grë ncuaaṉe zac glisqui naa lo to nu niina, ni ndal ncuaaṉe racladz naa gne naa lo to, per laa naa noyuṉ miṉe rnabeyse meṉ ne pxeeḻ naa; ni meṉ co nac meṉ ne rnee diidzli. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per ib rieṉd zho ne Dios ga rzeet me lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Dzigo bnee me lo zho stib, rëb me: ―Nieeda gaḻ dze ne yquiaa to naa tib lo yag, dze co guṉbey to gaṉle ne naa nac Mgui ne pxeeḻ Dios ga, dze co guieṉ to gaṉle led guicd naa riab grë miṉe quiayuṉ naa; sinque miṉe pseed me naa, miṉ co rne naa lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Dios pxeeḻ naa ni tibaque nacnie me naa, ib rsaand me naa, sac tibaque noxco naa ruṉ naa miṉe rdziladz me. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Grë zha Israel ne ndxie ga, zeeṉe bin zho sca rëb me, bliladz zho ne me nac meṉ ne no cxeeḻ Dios ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dzigo bnee me lo zho, rëb me: ―Teḻne racladz to gac to xpëëdscuel naa, zha ne nlipaa ygab xnëz naa, none guiaadnaḻ to grëse zhiwseed naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sac sca guṉbey to miṉe nacpaa diidzli, ni lëëw glu lo to zha laa to ne squi nac to zig tib nguṉdziin. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Pquiab zho rëb zho: ―¡Nguṉdziin ye! ¡Teḻ no, zha xtiipaa Abraham nac no, wlaltaa gard gac no nguṉdziin lo miech! ¿Pe lo dzigo laa no, ne rnee luu laa xtiidz luu csilaa no? ");
INSERT INTO zpmNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Dzigo rëbchaa me: ―Goḻquiaadiaga gaṉle: zha ne tibaque noyuṉctal xtoḻ, rrieequiacxe waa tib nguṉdziin nac zho lo doḻ ga, sac lëëlew rnabey zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ni zha ne nac nguṉdziin lëë, zig ruṉ miech nëz rii, grieelod xooṉ zho lo meṉ ne rree zho; saṉgue zha ne nac mëëd, choot lo ngadood zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Gacxe waa, teḻ csilaa Xpëëd Dios to, dzigosi choot lo ngadoodraa to. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nli lo xtii Abraham ziaad to; per laa to quia goṉ quiaguib to dieṉ zha gut to naa, sac racladzde to yquiaadiag to zhiwseed naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Laa naa rne grë miṉe blu Pxoz naa lo naa, zeeṉe no naa lo me; saṉgue to goṉ, laa to zienaḻ miṉe rnabey meṉ ne nac pxoz to. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Pquiab zho rëb zho: ―¡Ni Abraham goṉ nac pxoz no! ―¡Nlid ga nagoṉ! ―rëb me lo zho―. Teḻne niaca miṉe nli zhinpaa Abraham nac to, zuṉ to grë miṉe beeṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Per na goṉ leḻ racladz to gut to naa, loxaque ne rseed naa to miṉe nac diidzli, miṉe blu Dios lo naa. ¡Teḻ Abraham led squid beeṉ Abraham! ");
INSERT INTO zpmNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ni lalnu zienaḻde to miṉe beeṉ Abraham, sinque laa to noyuṉ miṉe ruṉ zha ne nlipaa nac pxoz to. Pquiab zho rëb zho: ―¡Led-xe mëëd ro nëzd no waa! Tibaque meṉ ne nac pxoz no, ni lëë meṉ co nac Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Dzigo rëbchaa me lo zho: ―Teḻne niaca miṉe nli zhin Dios nac to, nleynie to naa, sac goṉ lo me brie naa ziaḻ naa lo to nu. Led zhaald naa ziaḻ naa, me nac meṉ ne pxeeḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ib rioguicde to zha nac grë miṉe rne naa, ib rieṉde tow, sacne ib nëde to yquiaadiag tow. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Goḻgacnaṉ sca gaṉle, lëë pxoz to ga goṉ nac meṉdox, lo ma ngab to, gacxe waa rdziladz to ruṉ to grë ncuaaṉe ruṉ ma. Teḻ meṉdox, haxta zeeṉe biaaṉ guidzliu tibaque nonitlo ma miech, ni ib rneed ma miṉe nac diidzli, sac ib naṉd ma zha nac diidzli. Ible lëë xtsiiṉ ma ga nac guieḻwquidie, gacxe waa ma nac pxoz zha ne rquidie. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","¡Miṉ co nagoṉ, niicle diidzli nac grë miṉe rne naa lo to, per ib rliladzde tow! ");
INSERT INTO zpmNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni tib to choot grieelod gnë laa naa noquidie, sac niapse diidzli rne naa. ¿Pe nac dzigo rliladzde to miṉe rne naa? ");
INSERT INTO zpmNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Grëse zha ne nlipaa ngab xnëz Dios, rley zho rquiaadiag zho xtiidz Dios; per to goṉ led xnëzd me ngab to, gacxe waa nëde to yquiaadiag tow. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Horco pquiab zho rëb zho lo me: ―¡Psioog ro luu meṉ Samar ngoopdoḻ! ¡Nlique miṉe rnee no ga nagoṉ, ne meṉdox noguitnie luu! ");
INSERT INTO zpmNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","―Choot meṉdzab noguitnied naa ―rëb Jesús―, sinque laa naa noxco xoobneṉ gaṉle pa lotaa meṉ nroob nac Pxoz naa; laa to goṉ leḻ rsaṉwin to naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Noguibd naa dieṉ zha guiaaṉnon naa, per Dios goṉ racladz me ne sca gaca; ni mesi naṉ me pe ruṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gneli naa lo to gaṉle: ¡Grëse zha ne gzoob xtidz naa, gdziṉd dze ne guet zho! ");
INSERT INTO zpmNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pquiab zho rëb zho: ―¡Per nlique nagoṉ meṉdox noguitnie luu! Zig nac Abraham name gut me, grë zha ne biadteed xtiidz Dios ne, grëse zho gut zho. ¿Zha nac dzigo rnee luu, zha ne gzoob xtiidz luu, gdziṉd dze guet zho? ");
INSERT INTO zpmNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Pe mazdraa dzigo nac luu lo pxozgol ne Abraham, lo grëgaa zha ne biadteed xtiidz Dios ga? ¿Cho rzac luu nac luu? ");
INSERT INTO zpmNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Rëbchaa me: ―Teḻne lëëque naa noyuṉnon naa, nlid miṉe rne naa dzigo. Per na goṉ, Pxoz naa, meṉ ne nac Dios ne rnee to rliladz to, me rlu gaṉle ne nli meṉ non nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Teḻ naa ruṉbey naa me, ni ruṉ naa miṉe rnabey me; saṉgue to goṉ, nlid ruṉbey to me. Teḻ gni naa ruṉbeyd naa me, yele naa ga dzigo noquidie zigne rquidie to. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pxozgol to Abraham, bley me zeeṉe gocnaṉ me laa naa znu guiaḻ lo guidzliu rii. Ni zeeṉe bdeed Dios diidz goṉ me naa, mazdraa bley me. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Zeeṉe bin zho sca rëb me, rëbchaa zho: ―¿Goṉ luu Abraham ye? ¡Ni chooptsii iz name rapd luu! ¡Zha dzigo goṉ luu Abraham! ");
INSERT INTO zpmNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","―Gneli naa lo to gaṉle ―rëb me―, notaque naa; nole naa zeeṉe gol Abraham. ");
INSERT INTO zpmNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Horco ptop zho quie laa zho gdeedquie me, per znuse bded me lad zho briee me leṉ yadoo, goṉdraa zho me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Zieded Jesús tib lugar co, goṉ me tib mgui ne rcow lo, scale nac lo meṉ co zeeṉe gol me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dzigo bnabdiidz xpëëdscuel Jesús rëb zho: ―Maestro, ¿bay zha nacne squi golnie meṉ qui guieḻnë qui? ¿Pe no pe xtoḻ mew, te xtoḻ xmeṉgol mew ye? ");
INSERT INTO zpmNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","―Lëda ―rëb Jesús―, led por xtoḻd zhow; sinque squi gol me, zeeṉa zeeṉe laa me guiac, ga gaṉ miech gaṉle zha nactaa grë ncuaaṉe ruṉ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Zhile laa liu ycow. None dzioxco ne dziuuṉ ne xtsiiṉ meṉ ne pxeeḻ naa laga nasraa bii zob ngbidz, sac deque ycow liu choot grieelodraa guṉ dziin. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Laga bii no naa lo guidzliu rii, naa nac zig tib biini ne rziini lo grë miech rii. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Blozhse sca bnee me, ptsuc me lo liu, bzhixcuaa me niip beṉ, dzigo bdëëb mew zhits guidlo mgui ne rcow lo ga; ");
INSERT INTO zpmNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","blozh ga, rëbchaa me: ―Güey na, güeytiib lo luu ro pil Siloé. (Siloé nac zig nacne rnee ne Pxeeḻ zho zho.) Dzigo güey mgui co güeytiib me lo me, zeeṉe laa me wbire laa me raṉle. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Grë zha ne no gax zaatne no me, ni grë zha ne ruṉbey me; zeeṉe goṉ zho me, rneechaa zho: ―¿Mgui rii ga lëë rzob gdib i rnab gon? ");
INSERT INTO zpmNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","No zho rnee mew, nogaa zho rnee led meda. ―Squidaa rlu me ―rnee zho―, per led med i. Nacne pquiab me mezhal rëb lo zho: ―Naaw, naa nac mgui co. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dzigo bnabdiidz zho zha biac lo me. Rëbchaa me: ");
INSERT INTO zpmNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","―Meṉ ne rnee zho lë Jesús, meṉ co bzhixcuaa niip beṉ dzigo bdëëb mew zhits guidlo naa, blozh ga pxeeḻ me naa biatiib naa lo naa ro pil Siloé; zeeṉe laa naa wbire laa lo naa biacle. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","―¿Yo meṉ co niina na? ―rëb zho. ―Dieeṉda ―rëb me―, naṉd naa dieṉ yo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dzigo güey zho güeynie zho me lo grë zha ne nac zha farisé; ");
INSERT INTO zpmNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","sac lëëtse dze ne rdziiladz zho lo dziin, lëëtse dze co sca beeṉguiac Jesús lo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Grë zha farisé co, biire zho bnabdiidz zho lo me dieṉ zha biac me; dzigo bzodiidz me lo zho zha bdëëb Jesús niip beṉ lo me, blozh ga güeytiib me lo me, zeeṉe laa me wbire laaw biacle. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Blalaa zha farisé ne ndxie ga, psilo zho rnee zho: ―Nlid ne Dios pxeeḻ meṉ co, gacxe waa niicle ruṉbeydraa me pa dze nac dze nda. Pquiab zla zho rnee: ―Teḻ choḻze miech ngoopdoḻ nac me, ¿niacxe zrieelo guṉ me grë milagr qui? Zhaase zhaase rnee zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dzigo wbiire zho bnabdiidz zho lo me, rëb zho: ―Luu waa, ¿cho rzac luu nac meṉ ne beeṉguiac lo luu ga? Pquiab me rëb me: ―Ible Dios pxeeḻ me. Tib meṉ ne ziadteed xtiidz Dios lo miech nac me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Per ib rliladzd grë zha wxtis co ne biac lo me, sac rliladzd zho ne roḻd lo me glo; dzigo bnabey zho gocredz pxoz me, gocredz xniaa me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bdziṉ grop meṉgol co, rëbchaa zho: ―¿Pe nli xpëëd to nac meṉ rii? ¿Pe nli na roḻd lo me zeeṉe gol me? Teḻ nli roḻd lo me, ¿zha biac lo me ne laa me raṉ niina? ");
INSERT INTO zpmNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","―Nli xpëëd no nac me ―rëb grop meṉgol co―. Ni nli roḻd lo me zeeṉe gol me; ");
INSERT INTO zpmNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","per ndioṉd no dieṉ zha biaca ne laa me raṉ niina, niicle ndioṉdgaa no dieṉ pe no cho beeṉguiaca. Beṉque zha gol-le nac me, mazd lo me goḻnabdiidz, mezhal gnë dieṉ zha biac lo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Sca rëb grop meṉgol co, sac rdzieb zho griee zho xyadoo zho. Biaaṉle grë zha rnabey co diidz: zha ne guiab Jesús nac Meṉ ne zëëble diidz ga cxeeḻ Dios lo guidzliu; csaandraa zho sëëb zho yadoo. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wbiire zho bredz zho meṉ ne biac lo ga, rëb zho: ―Bieṉ gaṉle Dios zobwi, bnë diidzli lo no; sac teḻ no ndioṉ no choḻze miech ngoopdoḻ nac meṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","―Dieeṉda ―rëb me―. Naṉd naa dieṉ pe miech ngoopdoḻ nac me, te meṉ wena ye. Per me goṉ beeṉguiac lo naa, sac roḻd lo naa glo. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dzigo biire zho bnabdiidz zho stib dieṉ zha beeṉguiac Jesús lo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Pquiab me rëb me: ―Ledaaw nile naa lo to, per ib rliladzde tow. ¿Zha nac dzigo ne racladz to gonaque tow stib? ¿Te racladz to ye, ye to sëëb xnëz me? ");
INSERT INTO zpmNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dzigo psilo zho ndox zho lo me, rëb zho: ―Luuzhe teḻ xnëz me no luu, saṉgue teḻ no zhiwseed Moisés, miṉ co zionaḻ no. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sac teḻ Moisés, ndioṉ no nli Dios pxeeḻ Moisés, per mgui co ni ndioṉd no dieṉ pa briee me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Pquiab me rëb me: ―¡Ncuaaṉe gzeegaa zdoo ne i ruṉbeydaque to cho nac me, ni ron to me beeṉguiac lo naa! ");
INSERT INTO zpmNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ndioṉ ne gaṉle rquiaadiagd Dios xtiidz choḻze miech ngoopdoḻ, sinque laa me rquiaadiag xtiidz zha ne rieṉ ne nli meṉ nroob nac me, ni ruṉ zho miṉe rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Stiba, wlaltaa gard dzion ne cho zha beeṉguiac lo tib miech ne znu gol roḻd lo. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Teḻne niaca miṉe nacnied Dios meṉ co, nrieelod me niuṉguiac me lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","―¡Psioog ro luu! ―rëb zho lo me―. ¡Ib racladzd no guiaad tib ngoopdoḻ nu guiadseed no! Horco wbig zho, blee zho me ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Bin Jesús sca blee zho me ga, dzigo zeeṉe bdzieel Jesús me, rëbchaa Jesús lo me: ―¿Pe rliladz luu meṉ ne nac Xpëëd Dios? ");
INSERT INTO zpmNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Pquiab me rëb me: ―Bzhiguieḻ bnë lo naa dieṉ cho nac meṉ co, zeeṉa gliladz naa me. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","―Goṉle luu me ―rëb Jesús―. Naa goṉ nac meṉ co, lëë me nu nozodiidznie luu niina. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dzigo pquiitsgzhib me lo Jesús, ni rëb me: ―Dib zdoo naa rliladz naa ne nli Xpëëd Dios nac luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Blozh ga rëbchaa Jesús: ―Laa naa ziaḻ lo guidzliu rii, zeeṉa glu dieṉ cho rap doḻ, dieṉ chogaa rapd doḻ; sac zha ne rzac miech peet rieṉd, laa zho tsaa biini; laa zha ne rzoob zho niini, laa xquieḻrien zho ycow, guiaaṉ zho zig tib zha ne roḻd lo. ");
INSERT INTO zpmNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Blalaa zha farisé zo ga, zeeṉe bin zho sca rëb me, rëbchaa zho lo me: ―¿Rzë diidz qui na lëë ye lo no roḻd? ");
INSERT INTO zpmNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Dzigo pquiab me rëb me lo zho: ―Teḻ niaca miṉe nlipaa zha ne roḻd lo nac to, grieelod gni naa rap to doḻ. Per na, ne masaque rzac to roḻraa lo to, gane grëse ncuaaṉe quiayuṉ to xtoḻ to noyaca, to zëëba. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ni rëb Jesús: ―Goḻquiaadiaga gaṉle: grëse zha rded stib nëz zeeṉe rzëëb zho leṉ lidz mëcwxiil, laa ne ted zho nëz ro puert, gase rlu ngbaan ga nac zho; ");
INSERT INTO zpmNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","sac teḻ meṉ ne noyaṉ maw, nëz ro puert nëz co rzëëb me. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Zha ne rquianap ro lidz ma, ga rxal zho rded me; niicle magaaw, zeeṉe ron ma tsi me, grëse ma rdziṉ lo me; dzigo rbedz me ma, rneelë me ma tib tib ma, laa me rbee ma ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Rlozhse rbee me grë ma ne nac xma me, laa me rner lo ma; grëse ma laa ma rnaḻ zhits me sacne ruṉbey ma tsi me. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Rienaḻd ma zhits stib miech, zeeṉe raṉ ma zho znuse rzhooṉ ma; sac ruṉbeyd ma tsi zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Grë zha ne ndxie lo me ga, ib bieṉd zho zha nac godiidz co; ");
INSERT INTO zpmNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","dzigo wbiire me bnee me lo zho, rëb me: ―Goḻquiaadiaga gaṉle: Naa goṉ nac zig ro Puert, zaatne rded mëcwxiil ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Grëse zha ne biaad glo rnee zho zha nac Meṉ ne nacle diidz cxeeḻ Dios ga, grëse zha co ngbaan ga nac zho, loxaque psacsi zho par grieelo cuan zho; ni grëse mëcwxiil ne nacpaa xpëcwxiil naa, güeynaḻd ma zhits zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Saṉgue naa, laa naa nile lo to gaṉle: Naa nac zig ro Puert, zaatne rded mëcwxiil ga. Grëse zha ne gbig lo naa, zlaa zho, peet lo tsoxtseebdraa zho; pale grë mëcwxiil ne zozëëb zoriee ro lidz, ni rdziel ma guizh nguia, guizh ndzon row ma. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Zha ne nac ngbaan, zeeṉe riaad zho loxaque rban zho ni rut zho; saṉgue naa, laa naa ziaḻ zeeṉa ygaa to tib guieḻmban ne mazdraa ndzon, tib guieḻmban ne gdziṉd dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","’Naa nac Baxtor ne nquialadzpaa xpëcwxiil. Sac zha ne nquialadzpaa xpëcwxiil, rquiad zdoo zho xquieḻmban zho, rsilaa zho ma lo guieḻxtseeb ne notaa ma. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Per teḻ noyac-wree zha ne noyaṉ ma, rquiad zdoo zho ma, zigne raṉ zho palo ziaad tib coyot ntseeb, ndxieque mëcwxiil ga laa zho rzhooṉ; sac led cheṉd zho ma, led zhad nac xbaxtor ma. Zeeṉe rdziṉ coyot, nëzrii nëzrec rtsieets coyot ma, nogaa ma rgaa lo coyot. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Rzhooṉ zho, sac dimise nonie guic zho, peet liaadz nod zho ma. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Naa nac Baxtor ne nquialadz xpëcwxiil. Zigne ruṉbey Pxoz naa naa ni ruṉbey naa me, sca ruṉbey naa grëse xpëcwxiil naa, niicle magaaw ruṉbey ma naa. Grëse ma, rleynie naa ma, laa naa rbeeladz xquieḻmban naa totsaque cuee naa ma lo guieḻxtseeb ne no ma. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","’No spalal xpëcwxiil naa, ma ne ngabd leṉ corral rii; grëse ma co, ible zon ma tsi naa sac laa naa no gaxi ma, zeeṉa tipse gac ma grë ma yquianaap naa ma. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Meṉ ne nac Pxoz naa, rleynie me naa sac laa naa rbeeladz xquieḻmban naa; per ible zriebaan naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Naazhal rbeeladz xquieḻmban naa, choot grieelod lega ctiche xquieḻmban naa. Rap naa poder gded naa xquieḻmban naa, ni rap naa poder gbire gban naa stib. Dios bneedz diidzbey co lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Grë zha Israel ne ndxie ga, zeeṉe bin zho sca rnee me, laa zho goc chop dii stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","No zho rnee: ―Yase meṉdox noguitnie guic meṉ qui, o rzhiṉlegaa guic me. ¿Pe nacne rquiaadiag to xtiidz me? ");
INSERT INTO zpmNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Rquiab stib zho rnee: ―Niini rzë xtiidz meṉ qui, led squid rac zha ne noguitnie meṉdox. Stiba, ¿niacxe zrieelo meṉdox guṉguiac ma tib lo zha ne roḻd lo? ");
INSERT INTO zpmNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Leṉ mëë ne rac naḻa, leṉ dze co noyac tib lni Jerusalén, lni ne ruṉ zho rsoladz zho dze ne glopaa psilo quiaquiin yadoo. Ye Jesús bdziṉ Jerusalén leṉ dze co. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Laa me zieded tib leṉ nsaap ne quia cho yadoo co, nsaap ne rnee zho zhiNsaap rey Salomón; ");
INSERT INTO zpmNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","zeeṉe wbig bla zha ne rnabey Israel, bnabdiidz zho lo me rëb zho: ―¿Poc dzigo gdziṉ dze ne gnë luu diidzli lo no? Teḻne nli luu nac Meṉ ne zëëble diidz ga cxeeḻ Dios guiaad lo guidzliu, niinagazh bnëw lo no. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Pquiab Jesús rëb me: ―Blactaale zine naaw lo to, per rliladzde tow. Stiba, pe zhidaa milagr ne ziyaṉ to ruṉ naa, gase rlu gaṉle cho nac naa; sac Dios meṉ ne nac Pxoz naa, meṉ co racnieṉ naa ruṉ naaw. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ib rliladzde tow, sacne led yede to ngab lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Teḻ zha ne ngab lo naaw, ruṉbey zho naa; niicle naagaaw ruṉbey naa zho, ni zhits naa rzënaḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Grëse zho, rded naa tib guieḻmban ne gdziṉd dze lozh lo zho, ni gdziṉd dze nitlo zho. Choot grieelod ctiche zho lo naa, ");
INSERT INTO zpmNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","sac meṉ nroob nac Pxoz naa meṉ ne pxeeḻ zho lo naa; choot grieelod cuee zho ladznia me. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ni tibaque nac no grop no me. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Zeeṉe bin grë zha rnabey co sca rëb me, psilo zho ptop zho quie naṉ zho ngoquie zho me. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Dzigo rëbchaa me lo zho: ―Lo grëtaa milagr ne quiayacnieṉ Pxoz naa naa quiayuṉ naa lo to. Goḻnë dieṉ, ¿pa miṉ rlisqui to ne laa to racladz gneedzquie to naa? ");
INSERT INTO zpmNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Pquiab zho rëb zho: ―¡Coquiedaxe no luu waa por grë milagr ne ruṉ luu, sinque laa no coquie luu por grë diidz ne rnee luu i, quiaguitnie luu Dios! ¡Tib miech beṉse name nac luu, ni rnee luu laa luu nac Dios! ");
INSERT INTO zpmNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Dzigo rëbchaa me lo zho: ―¡Lo xlibr ley to name zhobnee zha rzac Dios zha ne pcaania xtiidz me, rëb me dios nac zho! ");
INSERT INTO zpmNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ni ndioṉ ne gaṉle, grëse miṉe rnee lo Xtiidz Dios, diidzliw; gacxe waa teḻ sca rëb me lo zha ne pcaania xtiidz me ga, ");
INSERT INTO zpmNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿niacxe rguitnie naa me ga, zeeṉe rne naa Xpëëd me nac naa, ni mezhal bzooblo naa pxeeḻ me naa lo guidzliu rii? ");
INSERT INTO zpmNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Teḻne ruṉd naa milagr ne rlu Dios pxeeḻ naa, ib gliladzde to naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Per teḻne raṉ to rlu ne me nacnie naa, maase gliladzde to naa totsaque goḻliladz ne me nacnie naa; tsow guieṉ to gaṉle ne tibaque nac no grop no me, zigtaa nacnie me naa, scaque nacnie naa me. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Horco gocladz zho stib naaz zho me, per znuse briee me nia zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Dzigo briee me ga güey me ro guiubee Jordán, zaatne bio Juan pchoobnis Juan miech; ga blëz me palal dze. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nzian miech ne güey lo me ga, rnee zho: ―Nli beeṉd Juan ni tib milagr nroob, per grëse miṉe bnee me zeeṉe bzeet me meṉ rii, zigne bneese me laaw norieequia niina. ");
INSERT INTO zpmNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nzian grë miech ne güeyquiaadiag zhiwseed me ga, dib zdoo zho bliladz zho ne me nac Meṉ ne zëëble diidz ga cxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Leṉ dze co blanguidz tib mgui ne no guiedz Betain, lë Lazh; no chop bzian Lazh tib zho lë Mart stib zho lë Marí. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Lëë Marí rii pchoob tiblo nceit nex ni Jesús, ni pcuiidz mew con guitsguic me.) ");
INSERT INTO zpmNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Dzigo pxeeḻ grop wnaa co diidz lo Jesús, gacnaṉ me laa Lazh rzacnë, sac naṉ zho rleyniedox me Lazh. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Zeeṉe blanso diidz, nëchaa me: ―Peet tsienied guic to, niicle teḻ blanguidz me per nacda par guet me, sinque par glu gaṉle pa lotaa meṉ nroob nac Dios. Ga glu gaṉle pa lotaa meṉ nroob nac Xpëëd me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Zigtaa Maríw, zigtaa Marta, zigtagaa Lazha, nquialadz Jesús zho gza zho, ");
INSERT INTO zpmNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","per ib biobladzd me; leḻ blëz me schop ngbidz zaatne no me ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Dzigoraa në me lo no: ―Laa ne guio nëz xtan meṉ Judé stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Dzigo rdzieets no: ―Maestro, ¿racladz luu tsie luu nëz co stib ye? Pense name goc bla ngbidz ga gocladz zho ngoquie zho luu ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nëchaa me: ―Tsiipchopraa hor name rziini ngbidz, ni laga niini rna zac tibliladz zia ne, noxtseebd ne lega pa grieḻ ni ne; ");
INSERT INTO zpmNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","loxaque pcow liu, noxtseeb pa grieḻ ni ne; sac ncow rna. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Blozh ga në me: ―Laa xamigw ne Lazh nixguiesle, per na laa ne guio zeeṉa gabee naa zhimcaalo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Tibaque ndioṉ no nli nixguies Lazh, dzigo rdzieets no lo me: ―Teḻne raaguiesle me, zac-wen me sca. Ib bieṉd no ne gutle Lazh, gane sca rnee me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Dzigoraa clar bnee me lo no, në me: ―Laa Lazh gutle. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ni rley naa goṉ ne guieṉd naa ga dze co, zeeṉa sca grieelo lozh gliladz to gaṉle cho nac naa. Goḻgotsaa guio ne nëz lo me ga niina sca. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Laa Mazh, zha ne rnee zho “Mëëdgrop”, zeeṉe bin Mazh sca në me, rneechaa Mazh lo no: ―Guieṉd rson, goḻgotsaa cchoob zdoo ne guionaḻ ne zhits me dieṉ. Teḻ gut zho me, maase gut zho ne. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","19","Gax Jerusalén riaaṉ Betain. Zha ne rriee Jerusalén, maase groḻ hor ruṉ zho nëz rdziṉ zho Betain. Nzian grë zha Jerusalén rdziṉ riequiaabdiuzh zho Marí grop Mart, riechoobladz zho zdoo me lo xquieḻnë me ga. Dze ne rac tap ngbidz bioliu Lazh, dzigoraa laa Jesús bdziṉ. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Goṉ Mart pa lo ziaad Jesús, dzigo briee me biaad-xinëz me Jesús; laa Marí biaaṉ ro yu. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","―Jesús ―rëb Mart―, teḻne niaca miṉe nu no luu segur niete bzian naa; ");
INSERT INTO zpmNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","sac naṉ naa, grëtaa ncuaaṉe rnab luu lo Dios, ruṉ me miṉe rnab luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","―Peet tsienied guic luu ―rëb Jesús―, ible zrieeban bzian luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Pquiab Mart, rëb Mart: ―Nliw, naṉpaa naa ible zrieeban me gaḻ dze ne laa guidzliu rii nitlo, zeeṉe grëse meṉgut, laa zho grieeban. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dzigo rëb Jesús: ―Naa nac meṉ ne rbeeban grë meṉgut, ni naa nac meṉ ne rdeed guieḻmban lo grë miech. Grëse zha ne dib zdoo gliladz naa, niicle guet zho zig ret grëraa miech rii, zdziṉ dze ne gban zho stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Sac grëse zha ne dib zdoo rliladz naa, laa zho bgaale tib guieḻmban ndzon ga, guiaaṉd zho ladznia guieḻgut. ¿Led rliladz luu lëë Mart, ne sca gaca? ");
INSERT INTO zpmNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","―Rliladz naaw ―rëb Mart―. Rliladz naa ne luu nac meṉ ne bzooblo Dios ga, luu nac Xpëëd Dios, Meṉ ne zëëble diidz ga cxeeḻ me guiaad lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Blozhse ga, wbire Mart zie Mart zietsedz Mart Marí. Bdziṉ Mart zhliaanse bredz Mart Marí (sac nzian zha ne ndxie ga ziequiaabdiuzh Marí) rëb Mart: ―Niinapaale blanso Maestro, na laa me rbeedz luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Zigne bin Marí sca rëb Mart, briee nguzhooṉ Marí laa Marí zie nëz co. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Bdziṉ Marí, laa Jesús bii zo zaatne güeydzieel Mart me ga; gase blëz me, bzëëbd me lad guiedz.) ");
INSERT INTO zpmNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Grë meṉ Israel, zha ne ndxie lidz Marí ga ziechoobladz zdoo me, zeeṉe goṉ zho sca lëëlëd briee me, naḻaque zho zhits me; sac naṉ zho bod ro xpaa bzian me ziegoon me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Zigne bdziṉ me zaatne zo Jesús ga, pquiitsgzhib me lo Jesús. ―Jesús, luu ne nac luu meṉ ne rnabey ―rëb me―, teḻne niaca miṉe nu no luu zeeṉe blanguidz bzian naa, niete me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Psilo Marí roon Marí. Zeeṉe goṉ Jesús, niicle Maríw, niicle grë zha Israel ne bdziṉ ga, mban rac zho, grëse zho roon, dzigo ye me biab guieḻnë me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Bnabdiidz me rëb me: ―¿Pa lo pqueets to me? ―Dë gaṉle ―rëb zho―, zeeṉa gaṉ luu pa lo bgueets me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Horco psilo Jesús biin me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Grë zha Israel co, zeeṉe goṉ zho roon me, rneechaa zho: ―¡Goḻwi gaṉle, blactaa nquialadz me Lazh! ");
INSERT INTO zpmNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Laa zla zho rnee: ―Led me name beeṉguiac lo mgui ne roḻd lo ga, ¿pe nrieelod zha niuṉ me, zeeṉa niete Lazh? ");
INSERT INTO zpmNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Zeeṉe laa Jesús bdziṉ ro baaṉ Lazh, biire biab guieḻnë me. Zig nac tib bliee niaa baa co; rna tib quie nroob ntse zaatne rsëëb zho ngutoo; ");
INSERT INTO zpmNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","dzigo bnabey Jesús cob zho quie co. Pquiab Mart, bzian ngutoo co rëb me: ―¡Mazd gdioobda! ¡Nadze rac tap ngbidz gut me, mbanle na rlaa me! ");
INSERT INTO zpmNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dzigo rëbchaa Jesús: ―Led laa naa nile lo luu, teḻne dib zdoo luu rliladz luu naa, bii zaṉ luu gaṉle zha nactaa grë ncuaaṉe ndzon ne ruṉ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Zeeṉe blozh bdob zho quie co, dzigo blis Jesús lo me nëz gbaa, ni rëb me: ―Dios, luu ne nac luu Pxoz naa, xquizh xquieḻnzaac luu sac rquiaadiag luu miṉe rne naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Naṉ naa tibaque rquiaadiag luu miṉe rnee naa, per laa naa rzeta niina, zeeṉa grëse miech ne ndxie nu gliladz zho gaṉle ne nli luu pxeeḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Dzigo nguiedz bredz me, rëb me: ―¡Lazh, briee i! ");
INSERT INTO zpmNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Zigne sca bnee me, laa ngutoo co briee ga, scase nrieḻ lar dib nia me, dib ni me ne, ni nioog stib lë lar lo me. Dzigo rëb Jesús: ―¡Goḻxadz grë lar ne nrieḻ me i, zeeṉa guey me! ");
INSERT INTO zpmNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Grë meṉ Israel ne güeynaḻ zhits Marí ga, zeeṉe goṉ zho sca bleeban Jesús Lazh, nzian zho bliladz ne nli Dios pxeeḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nogaa zho leḻ güey zho güeyzodiidz zho lo grë zha farisé zha bleeban me Lazh. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Horco lëëlëd pcaalsa grë pxoz ne rnabey, ni grë zha farisé, rëb zho: ―¿Pe gnë to dieṉ zha gaca? ¿Zha dziuuṉ ne mgui ne rnee zho Jesús ga, sac goṉ pe zhidaa milagr ne quiayuṉ me? ");
INSERT INTO zpmNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Teḻne squise csaan ne me, mbe grëse miech sëëb xnëz me; lozh ga, zeeṉe gacnaṉ meṉ rnabey ne zob Romaw, laa me cxeeḻ grë xmeṉguiib me guiaadnitlo zho xyadoo ne, guiaadnitlo zho ladz ne. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dzigo pquiab Caifás, meṉ ne nac pxoz nroob leṉ iz co, rëb me lo zho: ―¡Ni lal nu lëë peet rieṉde to! ");
INSERT INTO zpmNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Pe rieṉde to mazd wena ygaa tib zha guet zho, zha quizh par gdib guiedz, lëdle grëse zha ladz ne nitlo? ");
INSERT INTO zpmNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Zeeṉe sca rëb Caifás meṉ ne nac pxoz nroob ga, ga bzeet me ible no guet Jesús par csilaa me grëse miech lo doḻ; per led guicd me biaba, sinque Dios psiaaba guic me. Ga goquiet ne laa Jesús guet, par csilaa me grëse zha Israel, ");
INSERT INTO zpmNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ni grëragaa zha ne no dipse lo guidzliu, zeeṉa tipse gac grëse zha ne nac xpëëd Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Dzigo grëse zha ne nac wxtis ga, laa zho biaaṉ diidz ne ible no ygaa Jesús gut zho me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nacne brieedraa Jesús ne neṉlo niaṉ zho me; dzigo mazd laa me brieenie no xtan zha Judé, güeynie me no zaatne wzhi no miech, bdziṉ no tib guiedz win lë Efraín, ga bliaaz no grë no me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Leṉ ngbidz co, ziaadyob lni Pascw. Nzian grë miech ne no grë guiedzlas ne ndxie dib ga, laa zho rsilo quiariee zie zho nëz Jerusalén; sac ansraa csilo Pascw nzian zho rie yadoo ruṉ zho grëse miṉe rnabey ley par guiaaṉmbe zho lo xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Grëse zha ne rdziṉ, leṉ yadoo no zho rnabdiidzlsa zho dieṉ pe zdziṉ Jesús lo lni; sac grëse zho racladz gaṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Laa grë pxoz ne rnabey, ni grë zha farisé, laa zho bnabeyle, zha ne gaṉtaa Jesús, tsienie zho diidz parne tsie zha ne tsienaaz me. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sxoop ngbidz gdziṉ dze lni Pascwa, güey Jesús guiedz Betain, zaatne no Lazh, meṉ ne bleeban me ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sac grëse meṉlidz Lazh, beeṉlo zho tib xtsee, gownie zho me. Mezh no zho, laga laa Lazh zobnie me, laa Mart nodziib ncuaaṉe gowxtsee zho lo mezh, ");
INSERT INTO zpmNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","tibaque zeeṉe bzëëb Marí bzëëbnie Marí tib lo nceit nex ne rriee guiee ne lë nard, tib lo nceit niazha, rgaaw maase groḻ boté. Zigne bdziṉ Marí bdëëb Marí nceit co ni Jesús, blozh ga con guitsguic Marí pcuiidz Marí ni me. Dipse leṉ yu zëbxlaa nceit co. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Laa Judas Iscariot, tib zha ne nacgza no (zha ne bded ga pto me) zeeṉe goṉ Judas sca bdëëb Marí nceit co ni Jesús, rneechaa Judas: ");
INSERT INTO zpmNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Mazd tebaa zha ndo nceit qui. Nguizhpaa zhow maase tsoṉ gayoo pes plat, dzigo needz zho dimi co ngaaza lo grë zha mban ne guieṉd pe yquiin. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sca rnee Judas, per nlid ne rquia zdoo Judas zha ne guieṉd pe yquiin, sinque laa Judas rguib dieṉ zha cuan Judas dimi co, sac Judas ngotsow bziuud ne no dimi; zigse raclo dimi leṉ bziuud co, zhliaanse rbee Judas dimi co. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dzigo rëbchaa Jesús: ―Psaan me. Ib laa me bdëëb nceit qui ni naa, zeeṉa nzhixcuaale xcuerp naa gaḻ dze ne laa naa ygueets. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Teḻne racladz to guṉ to xyudar zha ne guieṉd pe yquiin, tibaque raṉlsa to grë to zho, zac tsow ygad to lo zho; saṉgue naa zdziṉ dze gaṉdraa to naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ndal grë zha Israel, zeeṉe bin zho laa Jesús no guiedz Betain, bio zho nëz güey zho lo me ga, ni güeyso zho lo Lazh, meṉ ne bleeban me ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Zeeṉe goṉ grë pxoz rnabey cow, nacne bnediidzaque zho ye Lazh none gut zho; ");
INSERT INTO zpmNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","sac por Lazh, nzian grë zha non, laa zho rbig nëz lo Jesús, laa zho rliladz ne nli me nac Meṉ ne zëëble diidz ga cxeeḻ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Biini liu co, dipse lad guiedz Jerusalén zhoob diidz laa Jesús gdziṉ ga dze co. Grë miech guizhiu ne bdziṉ ga zie lni Pascw, ");
INSERT INTO zpmNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","psilo zho briee zho ziaad-xinëz zho me; tib tib zho nzheṉse zho tib lë zin. Lo guieḻbley co, zeeṉe goṉ zho me, psilo zho nguiedz roptsie zho, rnee zho: ―¡Zha meṉ nroobtaa nac Dios! ¡Zha ndzontaa meṉ rii pxeeḻ Dios ziaad lo ne! ¡Lëë meṉ rii gnabey Israel! ");
INSERT INTO zpmNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Laa Jesús, zobse me lad tib burr yeeṉ, zigne raquiet lo Xtiidz Dios zaatne rnee: ");
INSERT INTO zpmNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Grëse to meṉ Israel, gdziebde to. ¡Goḻwi gaṉle, laa meṉ ne rnabey ladz to ziaad i, zobse me lad tib burr yeeṉ! ");
INSERT INTO zpmNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Grëse no ne nac no xpëëdscuel me, ni tib no bieṉd hor co ne grëse ncuaaṉe noyac ga, raquietlew lo Xtiidz Dios; sinque haxta zeyle me gbaa, dzigoraa psoladz no nzian grë ncuaaṉe raquiet lo Xtiidz Dios ga, goṉlo no goca; ni bieṉ no Jesús raquiet ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lad grë miech guizhiu co no nzian zha ne goṉ zha bleeban me Lazh, dzigo nguiedz rzodiidz zhow lo grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ni nzian grë miech co, laa zho blanso ga ziaad-xinëz zho me, sac bin zho zha beeṉ me milagr nroob co. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Grë zha farisé, zeeṉe goṉ zho grë miech guizhiu co, rneechaa zho: ―¡Pe zhidaa grë miech qui racnie meṉ qui! ¡Peraa nadieṉ dziuuṉ ne! ");
INSERT INTO zpmNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lad grë miech ne bdziṉ Jerusalén ga, ziegaṉ Dios leṉ ngbidz Pascw co, lad co no blalaa zha zit ne nacd zha Israel, ");
INSERT INTO zpmNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","dzigo bnee zho lo Lip (zha Betsaid nac Lip) rëb zho: ―Bzhiguieḻ bnë dieṉ pa lo no Jesús, laa no racladz dziaṉ no me. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dzigo güey Lip rëb Lipa lo Ndrés, blozh ga güey zho grop zho güeynie zho diidz lo Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Dzigo rëbchaa me lo zho: ―Naa ne nac naa Mgui ne pxeeḻ Dios, niinataa nagoṉ laa dze bdziṉ zeeṉe laa naa gbire guia gbaa stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Goḻquiaadiaga gaṉle: Tib zhobxtil, teḻne tsoda liu tibaque zhob naca; per zeeṉe laa zhob co rio liu, nzian raca. Scaque naa nagoṉ, none guet naa, none tsoliu naa, zeeṉa gacnzian zha ne ygab xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Sac zha ne rquia zdoo xquieḻmban, znitlonie zhow; saṉgue zha ne cueeladz xquieḻmban, zha cosi zgaa zho tib guieḻmban ndzon ne ib gdziṉd dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Zha ne racladz sëëb xnëz naa, none guṉ zho miṉe rnabey naa; ni zaatne gdziṉ naa yeque zho no gdziṉ ga. Ni grëse zha ne sëëb xnëz naa ni gon zho xtidz naa, zuṉnon Pxoz naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Mban rac zdoo naa niina. Per lëda ga guṉ naa, teḻne guiep naa lo Pxoz naa csilaa me naa lo grëtaa guieḻnë ne no teed naa. ¡Sac par miṉcopaa ziaḻ naa lo guidzliu rii! ");
INSERT INTO zpmNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","’Dios, luu ne nac luu Pxoz naa ―rëb me―. Blu lo grë miech rii gaṉle ne meṉ nroob nac luu. Dzigo bin zho zëëb tib tsi meṉ co gbaa, rëb me: ―Laaw blule naa, ni niina laa naa gbire gluw stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nzian grë miech ne ndxie ga, zeeṉe bin zho tsi meṉ co, bzhaac zho nguziw; zha ne bieṉ led nguzida, rnee zho: ―Xanjl Dios ga goṉ bnee lo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dzigo rëbchaa me lo zho: ―Laa to bin gaṉle laa Pxoz naa bnee, ni por to goṉ bnee me, zeeṉa gon to tsi me ni gliladz to ne me pxeeḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Laa dze nagoṉ bdziṉ zeeṉe laa Dios guṉquizh naa xtoḻ grëse miech guidzliu rii; lëë dze bdziṉ zeeṉe laa meṉdox piche gnabeydraa ma lo guidzliu rii zigne rnabey ma niina. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Sac zeeṉe laa naa quia glaa lo cruz, ga cuedz naa grëse miech zeeṉa sëëb zho xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ga bzeet me zha gut miech me. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Grë miech ne ndxie ga, zeeṉe bin zho sca rëb me, rëbchaa zho: ―¿Guet luu ye? Lo Xtiidz Dios name rnee, ib guete Meṉ ne cxeeḻ Dios ga. ¿Zha nac dzigo ne rnee luu laa luu guet? ¿Chopaa dzigo nac luu? ");
INSERT INTO zpmNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Dzigo pquiab me rëb me lo zho: ―Naa nac zig tib biini ne noziini lo miech; ni ngabse dze ne cuëz naa lo to. Laga noziini naa lo to, goḻsëni zaatne riab biini zeeṉa ygaade to guieḻcow; sac zha ne rzë lo ncow rieṉd zho palo zie zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Niina ne rdeeda diidz goḻliladz cho nac naa, zeeṉa gac to zha ne nlipaa no lo biini. Blozhse sca rëb me laa me biche ga, blulodraa me lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Niicle goṉlo zho nzian milagr ne beeṉ me, per ib rliladzd zho ne nli Dios pxeeḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ni ib scalegaa no gaca, sac ga brieequia miṉe bzeet Isá (tib meṉ ne biadteed xtiidz Dios) zeeṉe znu rëb me: Dios, bui gaṉle ni tib choot nëd gliladz xtiidz luu, niicle raṉ zho grëtaa milagr ne ruṉ luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ni nligaa ib brieelod nliladz zho me; sac zeeṉe pquiaa Isá, znu rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ncow psaṉ Dios lo zho, ni beeṉndip me zdoo zho; zeeṉa gaṉd zho me, niicle guieṉdgaa zho zha gbig zho lo me csilaa me zho lo xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Zeeṉe znu bnee Isá, ible Jesús ga bzeet me; sac goṉ me grëtaa guieḻndzon ne rap Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ndal zho sca ib bliladzd me, per noquegaa zha ne bliladz me; zig nac grë zha ne rnabey lo zha Israel, ndal zho bliladz ne nli Dios pxeeḻ me, per ib pxobneṉd zhow; sac rdzieb zho cuee zha farisé zho yadoo. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","¡Ni stiba rdziladzraa zho guiaaṉnon zho lo miech, laa ne guiaaṉnon zho lo Dios! ");
INSERT INTO zpmNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Leṉ dze co, tib vuelt nguiedz bnee Jesús, rëb me: ―¡Grëse zha ne rliladz naa, yele Pxoz naa ga rliladz zho! ");
INSERT INTO zpmNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","¡Ni zeeṉe rwi zho lo naa, yele meṉ ne pxeeḻ naa ga raṉ zho! ");
INSERT INTO zpmNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naa nac zig tib biini ne rziini lo miech, ni grëse zha ne dib zdoo gliladz cho nac naa, zriee zho lo guieḻcow ne no zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Grëse zha ne gon Xtidz naa, ni gband zho zigne rnabeya, led naad guṉquizh zho doḻ co; sac ziaḻd naa par gdziibdoḻ naa miech, sinque laa naa ziaḻ par csilaa naa zho lo doḻ. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Xtidz naa gac ley ne guṉquizh zhow; zigtaa zhaw zigtagaa grë zha ne nëd guṉbey naa, grë zha ne nëd yquiaadiag xtidz naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sac grëse ncuaaṉe pseed naa miech, led guicd naa biaba, sinque Pxoz naa meṉ ne pxeeḻ naa, meṉ co rnabey naa pe nac miṉe cseed naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ni naṉpaa naa, grëse diidz ne rnabey Pxoz naa naa rne naa, lëëw rlu zha ygaa miech tib guieḻmban ndzon ne gdziṉd dze lozh; gacxe waa, grëse miṉe rnabey me gne naa, zigne racladz me scase rne naaw lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Guieel ne rsilo lni Pascw; wdze co pcaalsanie Jesús no grëse no ne nac no xpëëdscuel me, laa no nodiowxtsee. Rieṉle me ne gataa laa dze co bdziṉ, zeeṉe laa me gbi lo guidzliu rii gbire me lo Pxoz me stib. Grëse zha ne ngab lo me, rleynie me zho; ne nligaa rleynie me zho haxta bdeed me xquieḻmban me psilaa me zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Rieṉ me grëtaa ncuaaṉe no, ladznia me psaṉ Pxoz mew; lo Pxoz me briee me ziaad me lo guidzliu, ni lo Pxoz me gdziṉ me niina ne laa me gbi lo guidzliu. Laa no zioob no no mezh, tibaque zeeṉe guso me blee me lar ne mbix me, bdziiṉleṉ me tib lë lar nool. Par hor co, laa meṉdox pquiil-le Judas, zhin Simón Iscariot, parne tsieto Judas me. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Dzigo blaat me nis tib leṉ bandej laa me psilo noguiib me ni grë zha ne nacgza no, zigse rlozh rguiib me ni tib zho scase scase rcuiidz mew con lar ne ndxie leṉ me ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Zeeṉe laa me zie quiib me ni Simón Pedr, rëbchaa Simón lo me: ―¡Lëda i goṉ! ¿Pe nacne leḻ luu quiib ni naa? ");
INSERT INTO zpmNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Pquiab me rëb me: ―Grieelod guieṉ luu niina, pe nacne quiib naa ni luu; haxta tedraa nu dzigo gaṉle guieṉ luuw. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","―¡Nend scaw! ―rëb Pedr―. ¡Per naasi goṉ gnedzd naa diidz quiib luu ni naa! Dzigo rëbchaa me: ―Grieelod sca ygab luu xnëz naa, teḻne siguieḻd luu quiib naa ni luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Horco pquiab Simón, rëb Simón: ―Bzhiguieḻ sca, niinagazh bdiib ni naa, per led loxaque nidse naa, sinque dib nia naa, dib guic naa bdiib. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Dzigo rëbchaa me: ―Zha ne gozle, nise zho riar; sac mbele zho. Scaque to nagoṉ, mbele to grë to. Grë to rne naa, niicle ne led gzadpaa to mbe. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sca rëb me, sac rieṉle me cho tsieto me. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Blozhse bdiib me ni no, wbiire wbix me xab co me, bzob me lo mezh; dzigo në me lo no: ―¿Pe bieṉ to na pe nacne znu bdiib naa ni to? ");
INSERT INTO zpmNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Goḻwi gaṉle: To lëë, Maestro rnee to lo naa, ni rnee to naa nac meṉ rnabey; ni nonguieḻa goṉ, sac ne nligaa scaw. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Goḻgaṉ sca, niicle ne maistr naa, niicle ne naa nac meṉ ne rnabey, per laa naa bdeed zig tib nguṉdziin win bdiib naa ni to. Nana sca, scaque goḻgac lo samiech to. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Laa naa blule lo to zha guṉ to, nana sca goḻtsienaḻ miṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gneli naa lo to gaṉle, lo grë zha ne nac nguṉdziin, tsod zha ne nonraa lo zha ne rnabey zho; scaque grë zha ne rie mandad, tsod zha ne nonraa lo zha ne rxeeḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Laa to naṉlew nasca. Gacxe waa, teḻne tsienaḻ to wseed rii, zaacse gac lo xquieḻmban to. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Goḻquiaadiag gaṉle, grëse miṉe none naa nu, led par grëde tow. Naa bzooblo to, naṉween naa zha nac to tib tib to, ni naṉween naa zha rnee lo Xtiidz Dios, rneew: “Lëëque tib zha ne rownie naa, grieequia tsielo naa ladznia zha ne gut naa.” ");
INSERT INTO zpmNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Laaw rnegazh naa lo to niina, zeeṉa zeeṉe gaca, gliladz to gaṉle ne nli naa nac meṉ ne rne naa nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ni goḻgona gaṉle, grëse zha ne ycaania Espíritu Sant, meṉ ne cxeḻ naa, naale ga nocaania zho; ni zha ne rcaania naa, yele meṉ ne pxeeḻ naa ga rcaania zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Horco psilo rlupaa mban goc zdoo Jesús, dzigo bneeli me lo no në me: ―Gneli naa lo to gaṉle, lëëque tib to goṉ tsielo naa ladznia zha ne gut naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Zeeṉe bdzion no sca rnee me, psilo no rwilolsa no, rieṉd no dieṉ cho nac zha ne rzeet me ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Cuepaa me, ga zoob naa (rleynie me naa niicle ne raguiaḻd naaw); ");
INSERT INTO zpmNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","dzigo blunia Pedr lo naa, gnabdiidz naa lo me dieṉ cho nac zha ne rzeet me ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nacne wbig gax naa, bnabdiidz naa lo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Dzigo nëchaa me: ―Laa naa cobie tib lë guietxtil, ni lo zha ne gaṉ luu gded naa guietxtil co, lëë zho ga. Dzigo bzheṉ me tib lë guietxtil, blozhse bloobie me guietxtil co, laa me bdeeda lo Judas. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zigne bnaaz Judas guietxtil co, laa meṉdox bzëëb zdoo Judas. Dzigo rëbchaa Jesús lo Judas: ―Miṉe no guic luu guṉ luu, na zeeṉ nawdzegazh beeṉa. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","30","Zigne blozh dow Judas guietxtil co, lëëlëd briee Judas ley; pcowle liuw. Lo grë no ne zioobnie no me lo mezh ga, ni tib no bieṉd pe nacne sca rëb me lo Judas. No zho naṉ bod no pe ncuaaṉe rquiin lo lni co, rxeeḻ me Judas tsiesi Judas, o nogaa pa tsiesaṉ Judas palal dimi lo grë zha ne guieṉd pe yquiin; sac Judas nac zha ne ngotsow bziuud win ne no dimi. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Goṉse Jesús laa Judas briee ley, dzigo nëchaa me lo no: ―Niina nagoṉ bdziṉ dze zeeṉe glu gaṉle zha nroobtaa guieḻndzon ne rap Mgui ne pxeeḻ Dios, ni ga glu gaṉle pa lotaa nac guieḻndzon ne rap Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ni scaque Dios, zlu me gaṉle pa lotaa nac guieḻndzon ne rap Mgui ne pxeeḻ me ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xin yeeṉa, ¡zhile cuëz naa lo to nu! Squiaguib to naa, per zigne rep naa lo grë zha Israel co, laaw rneque naa lo to niina: Grieelod sënaḻ to zaatne ga naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Gane laa naa rsaṉ tib diidz cub rii, ni laa naa rnabey to guṉ tow: Tib tib to, goḻleynie zha ne nacgrë to, goḻgaṉtsi zho. Zigne rleynie naa to, sca goḻleynie zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Zeeṉe gaṉ miech, ne nligaa dib zdoo to rleynie to samiech to, dzigo zieṉ zho xpëëdscuel naa nac to. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dzigo bnabdiidz Pedr lo Jesús, rëb Pedr: ―Maestro, ¿pa dzigo nac zaatne tsie luu? Dzigo rëbchaa me: ―Zaatne ga naa, grieelod sënaḻ luu niinagazh; per ib laa luu no guiaadnaḻ. ");
INSERT INTO zpmNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pquiab Pedr, rëb Pedr: ―¿Per pe nacne grieelod sënaḻ naa zhits luu niina? ¡Sënaḻ naa zhits luu goṉ, niicxe maase gut zho naa waa! ");
INSERT INTO zpmNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Dzigo rëbchaa me: ―¿Gooṉ csaand luu naa ye Pedr, niicle gut zho luu? Nlid ga goṉ. Gneli naa lo luu gaṉle, zeeṉe laa gall ycuedz tsoṉle vuelt rëb luu ruṉbeyd luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Tsode to zhgab, tsode to guieḻnë. Tiblique goḻguṉ guic to, zigne dib zdoo to rliladz to Dios, scaque dib zdoo to goḻliladz cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Goḻgona gaṉle: Zaatne nac lidz Pxoz naa, ndaldoo zaatne cuëz miech no ga, teḻ niaca miṉe guieṉd zaatne cuëz to, nile naaw lo to na. Gacxe waa, niina laa naa ga, gazhixcuaa naa zaatne cuëz to ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ni zeeṉe lozh gzhixcuaa naa zaatne cuëz to, hor co laa naa gbire guiaḻ stib, dzigosi laa to sënaḻ zhits naa; zeeṉa tibaque zaatne gbiaaz ne. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Laa to naṉle nasca pa lo ga naa, ni naṉlegaa to nëz ne. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Pquiab Mazh rëb Mazh lo me: ―Maestro, peleḻ nëz na gacndioṉ no, ni per ni zaatne tsie luu ndioṉd no. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Dzigo rëbchaa Jesús: ―Naa nac nëz co, naa rseed miech miṉe nac diidzli, ni naa rded tib guieḻmban ndzon ne ib gdziṉd dze lozh. Lo grëse miech, zha ne gliladz cho nac naa, zha co gdziṉ lo Pxoz naa; guieṉdraa stib mod ne gdziṉ zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Teḻne ruṉbey to naa, dzigo ruṉbeyaque to Pxoz naa. Ni ruṉbeylegaa to me, sac tibaque raṉ to me. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Dzigo rëbchaa Lip lo me: ―Bzhiguieḻ mazd blu Pxoz luu lo no. Totsaque dziaṉ no me, lëëlew ga dzigo. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Pquiab Jesús, rëb me: ―Blactaale dze ga name Lip no naa lo to, ni gardaque ye guṉbey luu naa. ¡Grëse zha ne raṉ naa, lëëque Pxoz naa ga raṉ zho! ¿Zha nac dzigo ne racladz luu glu naa me lo to? ");
INSERT INTO zpmNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Niacxe rliladzd luu dzigo ne tibaque nac no grop no Pxoz naa? Grëse miṉe rseed naa to, led guicd naa riaba; grëse ncuaaṉe ruṉ naa, me rnabeya, me ruṉa sac tibaque nac no grop no me. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Goḻliladz sca ne tibaque nac no grop no Pxoz naa. Teḻne gooṉ rliladzdgaa tow zigne rnee naa lo to nu, siquier lo grë dziin ne nodziuuṉ no, ga goḻgaṉ gaṉle ne nli tibaque nac no grop no me. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","’Ne nligaa, gneli naa lo to gaṉle: Grëse zha ne rliladz cho nac naa, ye zho zuṉ zho grë milagr ne ruṉ naa, ni haxta nroobraa ncuaaṉe guṉ zho; sac teḻ naa, laa naa no guia zaatne no Pxoz naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ncuaaṉe gnabtaa to lo Pxoz naa, totsaque glu to ne nli rliladz to naa, zuṉ naaw; zeeṉa ga gaṉ miech gaṉle me nac meṉ ne mazdraa nroob, me nac meṉ ne mazdraa non. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ne nligaa, teḻne rnalo to naa, ncuaaṉe gnabtaa to zuṉ naaw. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Teḻne nli rleynie to naa, goḻguṉ grë miṉe rnabey naa to sca. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Scagaa naa, laa naa gnab lo Pxoz naa cxeeḻ me tib meṉ ne tibaque gacnieṉ to, tibaque cchoobladz zdoo to; ib gdziṉd dze ne csaan me to. ¡Lëë meṉ co ga nac Espíritu Sant, meṉ ne rlu pa miṉ nac diidzli; ni ible sxeeḻ Pxoz naa me! ");
INSERT INTO zpmNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Zha ne ngabd xnëz naa, grieelod ycaania zho me, sac raṉd zho me niicle ruṉbeyd zho me; saṉgue to, ruṉbey to me sac me quianap to niina, ni zbëzgaa me zdoo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Ib csaanladzd naa to, zbire naa guiaḻ naa lo to stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nli zhilew, zeeṉe gaṉdraa grë miech naa, saṉgue to goṉ bii zaṉ to naa; sac zriebaan naa, ni scaquegaa to zgaa to tib guieḻmban ndzon ne gdziṉd dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Gaḻ dze co, zeeṉe gaṉ to laa naa grieeban, ga gliladz to gaṉle ne nli tibaque nac no grop no Pxoz naa, zigne tibaque nacnie naa to ni nacniegaa to naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Zha ne ruṉbey zha nac grë miṉe rnabey naa, ni rban zhow zigne naca, ga rlu ne nli rleynie zho naa; ni zigne rleynie zho naa, scaque Pxoz naa zleynie me zho; niicle naagaaw zleynie naa zho, ni zlu naa lo zho gaṉle cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dzigo pquiab Judas (zhaa Judas Iscariot), rëb Judas lo me: ―¿Pe nac waa lose no glu luu cho nac luu? ¿Teḻzhe grëraa miech waa? ");
INSERT INTO zpmNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Pquiab me rëb me: ―Zha ne ruṉ miṉe rnabey naa, lo zha co glu naa cho nac naa; sac rlu zho ne nli rleynie zho naa. Ni haxta ziaad no grop no Pxoz naa gbannie no zho; sac zigne rleynie zho naa, scaque zleynie me zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Saṉgue zha ne ruṉd miṉe rnabey naa, ¿zha dieṉ glu naa lo zho cho nac naa? Sac rlu rleynied zho naa. Goḻsoladz gaṉle: grëse diidz ne ron to rne naa, led guicd naa riaba, xtiidz Pxoz naaw. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Laa naa rne grë miṉ rii, laga bii zo naa lo to nu, ");
INSERT INTO zpmNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","per zeeṉe laa Pxoz naa cxeeḻ Espíritu Sant meṉ ne guiaad cchoobladz zdoo to (meṉ co guiaad xcuent naa), meṉ co lozh cseed to, ni guṉcsoladz me to grëse miṉe bne naa lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Laa naa guia, per laa naa rsaṉ tib guieḻbley zdoo to, zeeṉa zigne tibliladz rac zdoo naa, scaque tibliladz gac zdoo to. Sac guieḻbley ne rnedz naa lo to nu, nacda zig nac guieḻbley ne ruṉbey grëraa miech guidzliu rii. Tsode to zhgab sca, niicle gdziebde to. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Laa to binle gaṉle, laa naa no guia lo Pxoz naa per zbire naa guiaḻ naa lo to stib. Teḻne nli rleynie to naa iṉe nley goḻgac, niina ne ron to laa naa guia lo me, sac goṉ meṉ nroobraa nac me lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Laa naa rne grë miṉ rii lo to niina, zeeṉa zeeṉe gaca, ga lozh guieṉ to gaṉle cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Led nroobdraa sodiidznie naa to, sac ile ziaad meṉdox, meṉ ne rnabey lo guidzliu rii. Peet grieelod guṉ meṉdox naa, ");
INSERT INTO zpmNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","per ible none gon naa xtiidz Pxoz naa meṉ ne pxeeḻ naa, zeeṉa gaṉ miech gaṉle ne nli rleynie naa me. ¡Goḻtsieso nasca, zeeṉa zio ne! ");
INSERT INTO zpmNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Naa nac zig tib zhan lbë uv, laa to nac zhicwa, laa Pxoz naa nac zig tib zha ne quianapa. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Grëse zhicw lbë co miṉe rquiad nex lo, rchug mew; laa grë miṉe rquia nex lo, iṉe rsaṉmbe me low, rbelaan me low zeeṉa yquiaraa nex low. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","’Zig nac to goṉ, laa Dios psaṉmbele to sacne zienaḻ to grë xtidz naa miṉe pseed naa to. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gbichede to lo naa sca, sinque tibaque goḻgacnie naa zigne nacnie naa to. Goḻgaṉ gaṉle, zig nac tib zhicw lbë uv, peet nex grieelod yquia low teḻne tibnëzle nixa; scaquegaa to nagoṉ, grieelod guṉ to grë ncuaaṉe rdziladz naa, teḻne nacniede to naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Goḻsoladz gaṉle: Naa nac zig nac lbë co, laa to nac zhicwa. Zha ne tibaque gacnie naa, grëse ncuaaṉe guṉ zho zdziladz Diosa; ");
INSERT INTO zpmNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","sac teḻ piche zho lo naa, laa zho nacle zig tib zhicw lbë co miṉe nixle tib nëz, laaw nixle ga, ga gbidza; lozh ga laaw tsec. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Teḻne tibaque gacnie to naa, ni tibaque tsoxco to grë miṉe pseed naa to, dzigosi ncuaaṉe gacladztaa to goḻnaba, ni scagaa scaania tow. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","’Goḻlu sca ne nli xpëëdscuel naa nac to, goḻsaṉnon Pxoz naa, niapse ncuaaṉe rdziladz me miṉ co goḻguṉ. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","’Ne nligaa rleyniedox naa to. Goḻwi gaṉle, zigne rleynie Pxoz naa naa, scaque rleynie naa to. Goḻguieṉ sca tibaque goḻguṉ miṉe rnabey naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Sac goṉ, zha ne guṉ miṉe rnabey naa, gzataa dze zleynie naa zho; sac sca rleynie Pxoz naa naa ne ruṉ naa miṉe rnabey me. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Laa naa rzet miṉ rii lo to, zeeṉa guiaad tib guieḻbley zdoo to. Ne nligaa, zeeṉa guiaad tib guieḻbley nroob zdoo to; ni naa gnedz guieḻbley co lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","’Laa naa rnabey to, laa naa rnab lo to: ¡Goḻleynie samiech to, zigne rleynie naa to! Teḻ naa, goḻguieṉ gaṉle pa lotaa rleynie naa to, ");
INSERT INTO zpmNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","sac led lega gdeedse tib zha xquieḻmban zho par csilaa zho samiech zho, sinque ga rlu zho gaṉle pa lotaa rleynie zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","’Ni to goṉ, teḻne gon to grë miṉe rne naa lo to, dzigosi nli rleynie to naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Led yedraa niina nac to zig tib nguṉdziin, sac zha ne nac nguṉdziin naṉd zho pe ruṉ meṉ ne rnabey zho. Ne nligaa rleynie naa to, sac grëse miṉe rnabey Pxoz naa, grëse zigne rnee me, laaw bzodiidzle naa lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Goḻguieṉ gaṉle, led tod goṉ bzooblo naa, sinque, ¡naa bzooblo to! Ni laa naa bzooblo to zeeṉa guṉ to niapse ncuaaṉe rdziladz Dios; dzigosi ncuaaṉe gnabtaa to lo Pxoz naa, ne nac to zha ne no xnëz naa, zneedz mew. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Laa naa rso diidz lo to: Goḻleynie samiech to. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Niicle rlëë zho raṉ zho to, goḻsoladz gaṉle, desde naa squi rlëë zho raṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Rlëë zho raṉ zho to, sac laa naa bleele to lad zho, zienaḻdraa to ncuaaṉe rleynie zho; laa teḻne nagoṉ bii nac to zigne nac zho, dzigosi zëëb gleynie zho to. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Goḻsoladz gaṉle, zeeṉe znu ni naa lo to: ¡Tsod nguṉdziin ne ndziibsraa non lo zha ne rnabey zho! Teḻ naa, pquianaḻ miech naa, ¿pe leḻ to dzigo gaṉdze zho? Nana, zigne brieequiagaa palal zha ne bliladz xtidz naa, scaque zrieequia zha ne yquiaadiag miṉe gnee to. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","’Ible squianaḻ miech to ne nac to zha ne ngab xnëz naa, sac ruṉbeyd zho Dios meṉ ne pxeeḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Teḻ niaca miṉe niaḻd naa, niicle ned naa lo zho, zac guiab ne peet xtoḻd zho, sac rieṉd zho pe ruṉ zho. Per na goṉ, guieṉd pe yquiaaqui zho; sac biaḻ naa bne naa lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Zha ne rlëë raṉ zho naa, yele Pxoz naa ga rlëënie zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ne nligaa teḻne niaca miṉe niaṉd zho grëtaa milagr nroob ne ruṉ naa, zac guiep naa peet xtoḻd zho; per na goṉ, blactaa milagr ne goṉ zho beṉ naa, ni laa zho bii rlëë raṉ zho no grop no Pxoz naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","I nagoṉ norieequia miṉe raquiet lo Xtiidz Dios, zaatne znu rnee: “Peet guieḻntseeb quiayuṉd naa lo zho, per rlëënie zho naa.” ");
INSERT INTO zpmNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Laa naa nile lo to gaṉle, ible sxeḻ naa Espíritu Sant gacnie to, niapse diidzli rnee me. Lo Pxoz naa griee me guiaad me, me cchoobladz zdoo to, ni me gneedz guieḻbiini lo to lozh guieṉ to cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ni scagaa to, ye to laa to none sodiidz lo grëraa miech gacnaṉ zho cho nac naa; sac goṉ tibaque bzënie to naa desde ne psilo naa xtsiṉ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Laa naa rne grë miṉ rii lo to zeeṉa peet tsienied guic to, tibaque dib zdoo to gnalo to naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sac goṉ zuṉcxooṉ zho to, zbee zho to yadoo; ni zdziṉ dze haxta zut zho to, sac masaque sac zho lëë miṉe racladz Dios ga noyuṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Laa zho guṉ grë miṉ co, sac niicle Pxoz naaw, niiclegaa naaw, ruṉbeyd zho no. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","’Laa naa rzodiidz grë miṉ rii niina, zeeṉa zeeṉe gaḻ dze ne laaw noyac, csoladz to gaṉle grësew bzodiidzle naaw lo to. Bzodiidzd naaw lo to glo, sacne hor co laa naa bii zo lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Laa niina nagoṉ laa naa gbiche lo to, laa naa gbire guia lo meṉ ne pxeeḻ naa, per raṉ naa ni tib to zienied guic gnabdiidz dieṉ pa nac zaatne ga naa, dieṉ pe nacgaa ne laa naa ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Lëë gdib miṉe ruṉ to, riab guieḻnë to ron to grë miṉe rne naa nu. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","’Gneli naa lo to gaṉle: Mazd wen goṉ tsie to zeeṉe laa naa guia lo meṉ ne pxeeḻ naa, sac teḻne cuëz naa nu, grieelod guiaad meṉ ne guiadchoobladz zdoo to ga. Saṉgue teḻne guia naa, dzigo naazhal cxeḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ni zeeṉe laa me guiaad, me guṉquieṉ miech gaṉle grëse zho zha ngoopdoḻ nac zho, me guṉquieṉ zho zha laa zho lo doḻ co guiaaṉwen zho lo Dios, ni guieṉ zho ne nli zdziṉ tib dze zeeṉe laa Dios guṉ xquieḻwxtis me. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","¿Pe nacne nac zho miech ngoopdoḻ? Miech ngoopdoḻ nac zho, sacne rliladzd zho cho nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","¿Zha grieelo laa zho lo doḻ co guiaaṉwen zho lo Dios? Zrieelow, miṉcocxe waa nacne biaḻ naa, ni na laa naa guia zaatne zob Pxoz naa, gaṉdraa to naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","¿Zha rlu ne nli zuṉ Dios guieḻwxtis? Nli zuṉ mew, sac goṉ laa me bnabeyle zha nac grë guieḻnëdox ne ygaa meṉdox, meṉ ne quianabey lo guidzliu rii. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’¡Nzianraa ncuaaṉe racladz naa sodiidz naa lo to! Per rieṉ naa grieelod tsoguic to zha naca niina. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Zeeṉe guiaad Espíritu Sant, me gneedz guieḻbiini lo to guieṉ to grëraa ncuaaṉe no gacnaṉ to, ni grëgaa ncuaaṉe naraa gac. Niapse diidzli gnee me, sac led guicd me guiab grë miṉe gnee me, sinque miṉe nac xtiidz Pxoz naa, miṉ co gnee me. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ga glu me lo miech gaṉle ne nli meṉ nroob, meṉ non nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Rne naa ga glu me, sac grëtaa ncuaaṉe rnabey Pxoz naa, yeque naa rnabeya. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Zhilew zeeṉe laa naa gbiche lo to gaṉdraa to naa; per gacdaquew xtse zeeṉe laa to gbiirelaque gaṉ naa stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Zeeṉe bdzion no sca rnee me, blalaa no psilo no rnabdiidzlsa no rnee no: ―¿Bay zha nacne squi rnee me? ¿Zha nacne rnee me, zhilew dziaṉdraa ne me, per gacdaquew xtse laa ne dziaṉlaque lo me stib? Ni rneeque me laa me guey lo Pxoz me. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Bieṉ me racladz no gnabdiidz no lo me, dzigo në me lo no: ―¿Racladz to lëë gacnaṉ to zha nacne znu rne naa? ");
INSERT INTO zpmNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Goḻquiaadiaga sca gaṉle: Zeeṉe gdziṉ dze co, laga noyoon to no to guieḻnë ne laa naa biche lo to, laa grëraa miech haxta zley zho ne laa naa wbiche lo zho. Nli nroob guieḻnë ne tso to, per zeeṉe laa to gaṉ naa stib, guieḻbley nroob ne tso to. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nac cuent rii zig rzac tib meṉ wnaa ne ral xpëëd. Glo yoob ro, yoobdox ne rquia me, per deque laa mëëd co ralse, ni rsoladzdraa me yoob co; sac mazdraa nroob nac guieḻbley ne rio me raṉ me laa xpëëd me blanso lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Scadaa nagoṉ rzac to, nli mban rac to niina, per zeeṉe laa to gaṉ naa stib, dzigosi tib guieḻbley nroob ne tso to, ni choot grieelod ctiche guieḻbley co lo to. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Zeeṉe gaḻ dze co, yquiindraa to pe gnabdiidz to lo naa. Ncuaaṉe gnabtaa to, lo Pxoz naa gnab tow, ni zneedz mew, sac xnëz naa ngab to. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Haxta lo nadze peet gard gnab to, niicle ne xnëz naa ngab to; laa niina laa naa rne lo to ncuaaṉe rquiin to goḻnaba lo me, ni ible zneedz mew goṉ. Nroob guieḻbley ne tso to hor co. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nzian grë ncuaaṉe zine naa lo to, rned naaw clar; per laa dze bdziṉ zeeṉe grëse ncuaaṉe gne naa, clar gne naaw lo to, zig nac zeeṉe gzet naa Pxoz naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ni zig nile naa ga, hor cosi ncuaaṉe gnabtaa to lo me, zneedz mew, sac xnëz naa ngab to. Yquiindpaa gne naa lo me gneedz me ncuaaṉe gnab to lo me, ");
INSERT INTO zpmNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","sac ye me rleynie me to. Rleynie me to, sac goṉ rleynie to naa ni rliladz to ne nli lo me brie naa biaḻ naa lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ni nligaa, lo me brie naa biaḻ naa lo guidzliu; ni niina ne laa naa gbi, loque me gdziiṉ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dzigo rdzieets no lo me: ―¡Nasi nagoṉ rieṉ no zha rnee luu! Sac clar rnee luu, rneedraa luu zigne rnee luu glo. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nasi rieṉ no grëse ncuaaṉe naṉ luu, sac zig nac niina pquiindpaa nabdiidz no lo luu. Gacxe waa, nasi nagoṉ rliladz no ne nli lo Dios briee luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Pquiab me, në me: ―¡Wen ga teḻne rliladz to niina cho nac naa! ");
INSERT INTO zpmNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Per lëë hor co nagoṉ bdziṉ; ni niina, grëse to laa to csaan naa, tib tib to zhaase zhaase nëz ne xeṉ to. Per guiaaṉd naa loxaque naase, sac tibaque nacnie Pxoz naa naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Grëse ncuaaṉe bne naa lo to nu, laaw bne naa zeeṉa peet tsienied guic to, beṉque naṉle to gaṉle tibaque nacnie naa to. Parga nli, laga no to lo guidzliu rii, nzian grë guieḻnë ne ted to, per gdziebde to; sac goṉ naa rnabey, ladznia naa no grëtaa ncuaaṉe no lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Blozhse sca në me lo no, blis lo me bui me nëz gbaa. ―Dios, luu ne nac luu Pxoz naa ―rëb me―, niina nagoṉ laa dze co bdziṉ. Blu gaṉle meṉ nroob nac naa ne nac naa Xpëëd luu, zeeṉa ga glu naa lo miech gaṉle pa lotaa meṉ nroob nac luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Zigne psaṉ luu grëse miech ladznia naa, ni gdeed naa tib guieḻmban ndzon ne gdziṉd dze lozh lo grëse zha ne bneedz luu ngab xnëz naa; scaque niina blu gaṉle meṉ nroob nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lëë guieḻmban co ygaa grëse zha ne guṉbey luu, ne nli luuse nac Dios nguia mban, ni guieṉ zho cho nac naa, ne pxeeḻ luu naa biaḻ naa lo guidzliu rii. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Grëse ncuaaṉe bnabey luu naa, laaw noyuṉ naa; ni ga rlu naa lo grë miech rii gaṉle pa lotaa meṉ nroob nac luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Scagaa luu ne nac luu Pxoz naa, niina ne laa naa glanso lo luu, blu gaṉle meṉ nroob nac naa; sac desde mazd glo zeeṉe gard tsaa grëtaa ncuaaṉe no, tibaque nac lo guieḻndzon ne bdzio ne haxta dze ne blanso naa lo guidzliu rii. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Grëse zha ne ble luu lad grë miech rii bneedz luu lo naa, laa naa pseed zho guṉbey zho luu; ni scagaa zha, bliladz zho xtiidz luu. Cheṉ luu zho per laa luu bneedz zho lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Zig nac niina, grëse ncuaaṉe bneedz luu lo naa, naṉle zho ne luu bneedza, ");
INSERT INTO zpmNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","sac pseed naa zho grëse wseed ne bneedz luu lo naa, ni bliladz zhow. Wen wen gocnaṉ zho ne lo luu i brie naa ziaḻ naa lo guidzliu rii, ni rliladz zho ne luu pxeeḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Laa naa rnab lo luu gacnieṉ luu zho. Rnabd naa par grëse miech guidzliu rii, sinque laa naa rnab por grë zha ne bneedz luu lo naa; sac goṉ cheṉ luu zho, ");
INSERT INTO zpmNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ni zha glu gaṉle pa lotaa meṉ nroob nac naa. Grëse zho cheṉ luu zho; sac grëse ncuaaṉe naccheṉ naa, cheṉ luuw; ni grësegaa ncuaaṉe naccheṉ luu, cheṉ naaw. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Rieṉ naa, led nroobdraa cuëz naa lo guidzliu rii, laa naa gbile guiaḻ naa lo luu i; per zha, laa zho guiaaṉaque nu. Gane niina, luu ne nac luu Pxoz naa, luu ne nac luu tib meṉ ne guieṉd xtoḻ, laa naa rnab lo luu: pquianap zho ne nac zho zha ne bneedz luu lo naa, zeeṉa ni tib zho nitlod, sinque tibaque gac zho gza zho zigne tibaque nacne grop ne. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Leṉ dze ne blëz naa lo zho nu, zigne racladz luu sca pquianaap naa zho. Ni scagaa ni tib zho bnitlod; zha ne bnitlo ga, nole ne sca nitlo zho, zeeṉa sca grieequia miṉe raquiet lo Xtiidz luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Zhilew laa naa glanso zaatne no luu i; per leṉ dze ne blëz naa lo zho nu, nzian grë ncuaaṉe bne naa lo zho, zeeṉa ye zho tso guieḻbley nroob ne no naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Pseed naa zho miṉe nac xtiidz luu; per na rlëë grëraa miech raṉ zho zho, sacne zienaḻdraa zho grë ncuaaṉe ndzinlid ne rac lo guidzliu rii. Nac zho zigne nac naa, rleynied naa grë ncuaaṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Per rnabd naa cuee luu zho lo guidzliu rii, sinque laa naa rnab csaand luu guṉ zho ncuaaṉe racladz meṉdox. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Sac niicle zhaw, niicle naaw, choot zionaḻd grë ncuaaṉe ndzinlid ne rac lo guidzliu rii. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bzhiguieḻ sca bdeed guieḻbiini lo zho guieṉ zho zha nac Xtiidz luu, sac Xtiidz luu nac diidzli; zeeṉa dib zdoo zho tsoxco zho gban zho zigne rnabey luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sac goṉ, niina laa naa rxeḻ zho lo grëraa miech guidzliu rii, zigne ne pxeeḻaque luu naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ni niina, dib zdoo naa laa naa guṉ miṉe rnabey luu, zeeṉa ye zho guieṉ zho none dib zdoo zho guṉ zho miṉe rnabey luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Laa naa rnab gacnieṉ luu zho, ni gacnieṉ luu zha ne naraa gliladz naa, zeeṉe laa zho tsieseed zho; ");
INSERT INTO zpmNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","zeeṉa tibaque gac zho, zigne tibaque nac ne grop ne. Ni scaquegaa gacnie zho ne, zeeṉa gliladz grëraa miech gaṉle ne nli luu pxeeḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Laa naa psaṉnon zho zigne psaṉnonaque luu naa, ni tipse gac zho zigne tibaque nac ne grop ne. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Zigne nacnie luu naa, scaque nacnie naa zho. Bzhiguieḻ gocnieṉ zho, tibaque gac zho grëse zho, zeeṉa gaṉ grëraa miech gaṉle ne nli luu pxeeḻ naa, ni guieṉ zho gaṉle zigne rleynie luu naa, scaque tibaque rleynie luu grëse zha ne ngab lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Papá, grëse zha ne bneedz luu lo naa nu, racladz naa ye zho guiaad zaatne glanso naa i, zeeṉa gaṉ zho lo grëtaa guieḻndzon ne no naa. Lo guieḻndzon ne bneedz luu lo naa, sac rleynietaque luu naa haxta zeeṉe gard tsaa guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","’Papá, luuse nac meṉ ne rapd ni tib doḻ, niicle ne ruṉbeyd grë miech rii luu, saṉgue naa ruṉbey naa luu; ni scaquegaa grë zha ne bneedz luu lo naa nu, naṉle zho ne luu pxeeḻ naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Laa naa pseedle zho gocnaṉ zho cho nac luu ni bii seedragaa naa zho, guieṉ zho gaṉle pa lotaa rleynie luu naa; zeeṉa scaque guieṉ zho gleynie zho samiech zho, ni gacnie zho naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Zeeṉe blozh bnab Jesús lo Dios, laa me brieenie no ga bdieedquia no nëz daṉ ro psë ne rnee zho Psë Cedrón. Ga no tib zaatne zëëb niapse yag nex, dzigo ga bliaaz no gza no me. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas zha ne pto me ga, wen wen ruṉbey Judas lugar co, sac nzian vuelt ziyenie me no ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Dzigo zeeṉe laa Judas blanso ga, laa Judas blansoniele tib dzoon meṉguiib, ni zla zha ne rquianap yadoo; no guierbel nia zho blanso zho ga, zha ne nzheṉ yag, zha ne nzheṉgaa spad. (Lëë grë zha co pxeeḻ grë pxoz rnabey, ni grë zha farisé.) ");
INSERT INTO zpmNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Loxaque blanso zho, laa Jesús brieequiale, rëb me lo zho: ―¿Cho rguib to? Sca rëb me sac rieṉle me pe nacne zie zho ga, naṉle me pe nac grëtaa ncuaaṉe ted me. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Pquiab zho, rëb zho: ―Meṉ Nazaret ne lë Jesús, meṉ co ziaadguib no. Dzigo rëb me: ―Naa nac meṉ co, teḻ me ziaadguib to. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Zeeṉe bin zho rëb me: “Naa nac meṉ co”, wbire rzhitsaque zho, grëse zho biab liu. Ye Judas no lad co. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wbiire Jesús bnabdiidz me lo zho, rëb me: ―¿Cho zho rguib to? Pquiab zho rëb zho: ―Meṉ Nazaret ne lë Jesús, meṉ co rguib no. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","―Laa naa nile lo to ―rëb me―. Naa nac meṉ co. Teḻne naa ziaadguib to, goḻsaan sca guey grë zha ne zo lo naa nu. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ga brieequia xtiidz me zeeṉe rëb me: “Lo grë zha ne bneedz luu lo naa, ni tib zho bnitlod.” ");
INSERT INTO zpmNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Laa Simón ney tib spad, hor co bdobaque Simón spad co psilaa me tib niaw, bliengaa me diag derech tib mgui lë Malcw. (Lëë mgui co quia xtsiiṉ meṉ ne nac pxoz nroob.) ");
INSERT INTO zpmNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Zeeṉe goṉ Jesúsa, rëbchaa me: ―¡Blootsow spad qui Pedr! ¡Bieṉ gaṉle Pxoz naa rnabey znu teed naa! ¿Niacxe gond naa miṉe rnabey me naa dzigo? ");
INSERT INTO zpmNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Horco laa grë meṉguiib co, grë zho zha ne rnabey lo zho, ni grë zha ne rquianap yadoo ga, laa zho wbigbe bnaaz zho me. Blozhse bzobdoo zho me, laa zho zienie me. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Sca nzobdoo me, laa zho bdziṉnie me lidz meṉ ne lë Anás, pxozdzoop Caifás. Caifás nac pxoz nroob leṉ iz co, ");
INSERT INTO zpmNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ni me ga rëb lo grë meṉ non lo zha Israel, ne mazd wena tibaque zha ne ygaa guet, quizh zho par dib guiedz. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Zhiits co, ga naḻ no grop no Pedr. Ni ne ruṉbey naa Caifás meṉ ne nac pxoz nroob ga, zeeṉe bdziṉ no ro lidz Anás, loxaque naa brieelo bzëëb nëz ley. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Laa Pedr, zaatne nactaa ro yu par gdziṉ zaatne nac ley, gataa biaaṉ Pedr. Nacne brieque naa bnee naa lo wnaa ne zonap ro yu, dzigoraa bdeed wnaa co diidz bzëëb Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dzigo rëbchaa me lo Pedr: ―¿Bod ye luu dzigo lëë nac xpëëdscuel meṉ ne bdziṉnie zho i? ―Coo, led yed naa ―rëb Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Grë zha ne quia xtsiiṉ meṉ co ni grë meṉguiib ne ndxie ga, laa zho bzëëgle gui. Grëse zho, laa zho ndxiedzëë lo gui ga, sac rac naḻ. Ye Pedr bdziṉ lo zho ga nodzëë Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Laa nëz leṉ yu, laa Anás psilo noquiep Jesús dieṉ yo grë xpëëdscuel me, ni dieṉ pe nac grë wseed ne nolu me lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Dzigo pquiab Jesús, rëb me: ―Grëse miech, naṉwen zho gaṉle pe nac zhiwseed naa. Sac zeeṉe pseed naa zho, beṉd naa ne ngueets zhliaan nseed naa zho; sinque zaatne rcaalsa nzian miech, ga bne naa lo zho. No hor pseed naa zho leṉ grë yadoo win, nogaa hor pseed naa zho leṉ yadoo nroob ne zob lad guiedz nu. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nana bod rieguiaḻda ne lo naa rnabdiidz luu. Mazd lo grë zha co gaṉle bnabdiidz, zha bin grëtaa ncuaaṉe bne naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Loxaque blozh sca pquiab Jesús, zeeṉe bias tib meṉguiib ne rquianap yadoo zo gax ga, bdap me lo Jesús. ―¡Bieṉ gaṉle! ―rëb me―. ¡Led squid goṉ none yquiab luu lo meṉ ne nac pxoz nroob! ");
INSERT INTO zpmNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dzigo rëbchaa Jesús: ―Teḻne rzac luu beṉ naa falt, bnë dieṉ pe nac diidz ne pxiṉ naa. ¿Te waḻ rdziladz luu ye, rguiṉ luu zha ne rnee diidzli? ");
INSERT INTO zpmNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Blozh ga scaque nzobdoo Jesús pxeeḻ Anás me lo Caifás, meṉ ne nac pxoz nroob. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Horco laa Pedr bii zodzëëque lo gui nëz ley. Dzigo wbiire zho bnabdiidz zho lo Pedr, rëb zho: ―¿Bod xpëëdscuel meṉ ne blansonie zho i lëë nac luu? Laane neeli Pedr, leḻ pquiab Pedr rëb Pedr: ―¡Lëda! ¡Zha gaczhe naa xpëëdscuel meṉ qui! ");
INSERT INTO zpmNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ye tib zhalidz Malcw, zha ne pchug Pedr diag ga, laa zho zodzëë lo gui ga, sac ye zho quia xtsiiṉ pxoz nroob co; dzigo rëbchaa zho: ―Ni goṉ naa name, ye luu no lad zha ne zonie me leṉ yag oliv ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Wbiire Pedr rëb Pedr ruṉbeyd Pedr me, ni lëëtaque hor co laa tib gall pcuedz. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ziadyiinile liuw, zeeṉe laa zho brieenie Jesús lidz Caifás, zienie zho me zaatne nac xyulow Pilat, meṉ ne nac gobernador. Zeeṉe bdziṉ zho, ni tib zho bzëëbd leṉ yulow, sac racladzd zho quiits zho miṉe rnabey xley lay zho; parne grieelo yquiin zho guieḻwagw ne row zho lni Pascw co. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nacne briee Pilat bnabdiidz Pilat lo zho, rëb Pilat: ―¿Pe nacne ziaadnie to meṉ qui nu? ¿Pe rquiaqui to me? ");
INSERT INTO zpmNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pquiab zho, rëb zho: ―¡Por grëtaa guieḻntseeb ne noyuṉ me, gane ziaadnie no me! ¡Teḻne niac me meṉ ndzinli, niacxe lega guiaad-zo no me lo luu! ");
INSERT INTO zpmNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dzigo rëbchaa Pilat: ―Goḻsënie me, tose goḻguṉquizh me miṉe beeṉ me; zigne nac xley to. ―Racladz no guetgazh me ―rëb zho―. Ni naṉle luu gaṉle, no ne nac no meṉ Israel, grieelod ne nose gnabey guet tib miech. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ga brieequia miṉe bnee Jesús, zeeṉe bzeet me ible zut miech me. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Dzigo bzëëb Pilat leṉ yulow, bnabey me gocredz Jesús. Dzigo bnabdiidz me lo Jesús, rëb me: ―¿Pe nli luu nac zhirey meṉ Israel? ");
INSERT INTO zpmNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","―Ne squi rnee luu ―rëb Jesús―. ¿Pe guic luu biaba, te no cho nëw lo luu ye? ");
INSERT INTO zpmNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pquiab Pilat, rëb Pilat: ―Naṉle luu gaṉle led zha Israeld naa. ¿Pe nac sca ne ziaadnie zho luu nu? ¿Pe beeṉ luu? Sac goṉ zha ladzaque luu grë zho zha ne rnabey lo zhipxoz zho, zha biaadsaṉ luu nu. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Dzigo rëbchaa Jesús: ―Nli rey nac naa, per led lo guidzliu riida, teḻne niaca miṉe lo guidzliu riiw, dzigosi grëse zha ne nacnie naa niacntseeb zho, nsaand zho naaz zha Israel naa. Per na, zhaa zaatne nac naa rey. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pquiab Pilat, rëb Pilat: ―¿Rey luu dzigo lëë? ―Scaw goṉ ―rëb Jesús―, nli rey naa; zigne rnee luu i. Ible miṉ co nacne biaḻ naa gol naa lo guidzliu rii, ni biaḻ naa biaḻseed naa miech guṉbey zho miṉe nac diidzli. Ni zha ne zienaḻ miṉe nac diidzli, zha co ngab lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","―¿Diidzli ye? ―rëb Pilat. Zigne blozh sca rëb Pilat, briee Pilat ga güeynee Pilat lo grë zha ne bdziṉnie me ga, rëb Pilat lo zho: ―Ni tib doḻ goṉ rapd meṉ rii. ");
INSERT INTO zpmNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Per gzobse lni Pascw rii, rnab to rlaa choḻze tib zha ne no ladzguiib. ¿Pe gnë to sca, mazd csilaa naa meṉ ne nac zhirey to nu? ");
INSERT INTO zpmNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pquiabbe zho, rëb zho: ―¡Csilaad luu me! ¡Mazd psilaa Barrabás! Ni laa Barrabás tib ngbaan nac Barrabás. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Zeeṉe goṉ Pilat sca rac zho, dzigo bnabey Pilat bla meṉguiib, bdeed dooguid zho Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bzieecw zho bla lë yag guiets bzoob zho guic me, ni bgacw zho me tib lë lar nizhnie nlaan. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dzigo psilo zho ruṉnguzee zho me, nguiedz roptsie zho rnee zho: ―¡Bley na gaṉle, laa luu nacle zhirey zha Israel! Ni rgap zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Wbiire Pilat brieequia Pilat zaatne ndxie grë miech co, rëb Pilat lo zho: ―Goḻwi gaṉle laa naa cuee me, glu naa me lo to, per gacnaṉ to gaṉle rieguiaḻd guet me; laa naa pquieple me rlu ni tib guieḻntseeb beeṉd me. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Zeeṉe laa Jesús brieequia, nzobguicse me coron yag guiets co, ni nacw me lar nizhnie co. ―Goḻwi na gaṉle ―rëb Pilat―, lëë me nu. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Grë pxoz ne rnabey, ni grë meṉguiib ne rquianap yadoo, zeeṉe goṉ zho me, psilo zho nguiedz roptsie zho rnee zho: ―¡None guet me! ¡Bnabey yquia me lo cruz! Dzigo rëbchaa Pilat: ―¡Goḻtsienie me sca! ¡To goḻquiaa me lo cruz! Saṉgue naa, grieelod yquia naa me lo cruz; sac laa naa goṉle peet guieḻntseeb beeṉd me. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pquiab zho rëb zho: ―¡Rdziaap no xley no! Ni ley co rnabey ib none guet me, sac rquidie me rnee me laa me nac Xpëëd Dios. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Zeeṉe bin Pilat sca rëb zho, mazdraa bdzieb me. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dzigo bzëëbnie me Jesús leṉ yulow stib, bnabdiidz me lo Jesús, rëb me: ―¿Bnë dieṉ cho meṉpaa nac luu? ¿Pa nac ladz luu? Per ib pquiabd Jesús lo xtiidz Pilat. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dzigo rëb Pilat: ―¿Pe nacne rquiabd luu? ¿Goṉ gaṉle naa rnabey, zrieelo csilaa naa luu, o gnabeygaa naa yquiaa luu lo cruz? ");
INSERT INTO zpmNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Pquiab Jesús, rëb me: ―Nli luu nac zha rnabey niina, per teḻne niaca miṉe needzd Dios guieḻrnabey qui lo luu, grieelod ne luu gnabey zha gac naa. Miṉcocxe waa, zhi nac xtoḻ luu, mazdraa nac xtoḻ zha ne biaadlo naa nia luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dzigo gocladz Pilat nsilaa me Jesús, per bzhiguieḻd grë zha ne güeysaṉ me ga. ―Teḻne laa luu csilaa mgui qui goṉ ―rëb zho―, rrieequia dzigo ye luu rlëënie César. Sac goṉ, grëse zha ne racladz gac rey, lo César ga racndaan zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Zeeṉe bin Pilat sca rëb grë miech co, bnabey Pilat briee Jesús nëz ley stib. Dzigo güeysob Pilat lo xcan ne zo ley co, zaatne rzob me ruṉ me guieḻwxtis. (Dipse ley co, niapse quie lag now; gane rnee zha Israela Gabata.) ");
INSERT INTO zpmNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lëë dze vispr lni Pascw co ga nagoṉ, zig groḻle dzew noyac grë miṉ co. Dzigo rëb Pilat lo zho: ―Laa zhirey to nu goṉ. ¡Goḻsënie me! ");
INSERT INTO zpmNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Psilo zho stib, nguiedz roptsie zho, rnee zho: ―¡Beetgazh meṉ qui! ¡Bnabey yquia me lo cruz! Rëbchaa Pilat: ―Zhirey to nac me, ¿ni racladz to ye gnabey naa yquia me lo cruz? Pquiabbe grë pxoz ne rnabey rëb zho: ―¡Tibaque meṉ ne nac zhirey no, ni lëë meṉ co nac César! ");
INSERT INTO zpmNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dzigotaa mazd laa Pilat bloo Jesús nia zha ne tsiequiaa me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Zeeṉe laa Jesús briee ga, rna tib cruz nroob ney me; laa zho zienie me. Bdziṉnie zho me ro guiedz, zaatne rnee zho “Gui Beerguic Ngutoo”; ");
INSERT INTO zpmNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ga pquiaa zho me lo cruz. Ni pquiaa zho schop zha ntseeb, tibga zhicruz zho bzo cue zhicruz me. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Bnabey Pilat pquia bla lan diidz guic zhicruz me, rneew: “LËË JESUS MEṈ NAZARET NU, MEṈ NE NAC ZHIREY ZHA ISRAEL.” Pquiaw xtiidz zha Israel, xtiidz zha Roma ni xtiidz zha Gres. Nzian zha Israel goṉ sca quia guic zhicruz me, sac gaxpaa ro guiedz nac zaatne pquiaa zho me lo cruz ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nacne güey grë pxoz rnabey, güeylisqui zhow lo Pilat, rëb zho: ―¿Pe nacne pquiaa luu guic zhicruz mgui co, ne me nac zhirey zha Israel? Pe gacd nquiaa luu: “Rnee me, me nac zhirey zha Israel.” ");
INSERT INTO zpmNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pquiab Pilat rëb Pilat: ―Miṉe pquia naa, laaw pquiale ga. Ni sca none guiaaṉa. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Laa grë meṉguiib ne pquiaa Jesús lo cruz ga, zeeṉe blozh pquiaa zho me lo cruz, bzheṉ zho xab me beeṉ zhow tap lë, tib lëgaw biaaṉnie zho tib tib zho. Laa lar ne rbix me, tiblagaque naca, ndiibda; ");
INSERT INTO zpmNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","dzigo rëbchaa zho: ―Miṉritaa nagoṉ dziuuṉgroḻd ne. Miṉe naca gotsaa dzio new rif, dzigo zha ne grieequia zha co guiaaṉniew. Ga brieequia miṉe raquiet lo Xtiidz Dios, zaatne rnee: “Xab naa, miṉe racw naa nzian lë beeṉ zhow bgaaza lo zho; laa miṉe rbiix naa, bio zhow rif.” Ni scadaa beeṉ gza meṉguiib co. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gax zaatne zo zhicruz Jesús ga, zo blalaa meṉ wnaa. Ga zo xniaa Jesús, zo tib beḻ xniaa me, zo Marí tsieel Cleof, ni Marí Magdal. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Gaxaque ga zo naa. Zeeṉe goṉ Jesús xniaa me, ni goṉ me naa, rëbchaa me lo xniaa me: ―Beeṉ cuent nagoṉ lëë xpëëd luu i zo i. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Laa lo naa në me: ―Beeṉ cuent lëë xniaa luu i goṉ. Bzhiguieḻ luu gaṉ me. Dzigo desde dze co, pcaania naa xniaa me bianie naa me lidz naa, pteedlo naa me. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Rieṉle Jesús ne gataa laa me psiaaḻ dziin ne pxeeḻ pxoz me me guṉ me, ni par grieequia grëse zigne rzeet lo Xtiidz Dios ted me, hor co bredz me rëb me: ―Rnab zhis naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Gax lo grë meṉguiib ne quianap me ga, ga zo tib cant win no nziu bla. Zeeṉe bin zho sca rëb me, rias tib zho bgadz zho tib lë zhiil lo nziu co, bzoob zhow guic tib goobgui nool güeyquiaa zhow ro me. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Zeeṉe bdziṉ nziu co ro me, pquiin me niipa, dzigo rëbchaa me: ―Lëëw nagoṉ, nataa laaw bza. Zeeṉe blozh sca bnee me, znuse pquianruṉ guic me; laa me blozh. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Guini liu co nac tib dze ne mazdraa nda lo zha Israel. Nacne güey grë zha ne rnabey lo meṉguiedz güeynee zho lo Pilat, gnabey Pilat tsietiits zho gzhibni Jesús ni zha ne pquiagza me lo cruz ga, zeeṉa guietgazh zho lo cruz dze co; sac racladzd zho scaque quia zho lo cruz zeeṉe laa dze nda co gdziṉ. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Dzigo pxeeḻ Pilat bla meṉguiib. Zeeṉe bdziṉ zho, glose güeytiits zho ni tib zha ne quiagza Jesús lo cruz ga; blozh ga, güeytiitsaque zho ni stib zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Zeeṉe bdziṉ zho zaatne zo zhicruz Jesús, goṉ zho laa me gutle; nacne bdiitsd zho ni me. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Horco wbig tib meṉguiib co, bliz zho xlanz zho ro xcuxti me. Zeeṉe bdob zho lanz co, nis ne, ren ne briee ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Naazhal goṉ znu beeṉ zho me. Laaw rne naa lo to zigne gocsew. Goḻliladza, sac ne nligaa diidzliw. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ga brieequia miṉe raquiet lo Xtiidz Dios, zaatne rnee: “Ni tib dzit ne no me quiitsd zho.” ");
INSERT INTO zpmNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ni stib lugar, zaatne rnee: “Bii zaṉaque zho gaṉle cho nac meṉ ne bliz lanz zho ga.” ");
INSERT INTO zpmNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Laa José, tib meṉ Arimaté, zeeṉe bin me laa Jesús gutle, dzigo güey me lo Pilat güeynab me diidzbey par grieelo tsielit me xcuerp Jesús lo cruz. Ye me xpëëdscuel Jesús nac me, per pxobneṉd me ne ye me nacgza Jesús; sacne rdzieb me grë meṉ Israel ne rlëë lo Jesús. Dzigo bdeed Pilat diidzbey. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodem, meṉ ne güeyzodiidznie Jesús ga tib pcow liu, ye me güeynaḻ zhits José; güeynie me zig gaḻptsiiptap kil tiblo zënex ne riaa yaal ne lë mirr ni yaal ne lë áloe. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Zeeṉe blozh biet Jesús lo cruz, psilo zho bdëëb zho zënex co xcuerp me; blozh ga, pcheḻ zho me tib lar nquits; sac sca rqueets grë meṉ Israel zhingutoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Gax zaatne pquia Jesús lo cruz ga, niaa tib corral no niapse yag nex. Leṉ corral co, ga ndieeṉ tib baa tib cho quie, ni tib ngutoo gard ygueets leṉ baa co; ");
INSERT INTO zpmNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","dzigo nacne gase güeyqueets zho me, sac zhile ruṉfalt sëëb dze nda co, ni baa cose nac miṉe riaaṉ gax ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Goḻ dze ne rzobni zhmala, silgaw, scase bii ncow rnaw, briee Marí Magdal zie me ro baaṉ Jesús. Zeeṉe bdziṉ me, goṉ me laa quie ne nioog ro baa co bdiooble, laaw zole tib nëz. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Horco lëëlëd wbire nguzhooṉ me, biaad me zaatne no no grop no Pedr, biaadnie me diidz lo no, në me laa zho güeybeele Jesús leṉ baa, dieeṉ palo güeysaṉ zho me. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dzigo lëëlëd, briee no grop no Pedr, zioso no ro baa. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","5","Zeeṉe bdziṉ naa ro baa, blëz naa niip, dzigo bdiixlo naa leṉ baa goṉ naa laa lar ne brieḻ me zhoob ga; per bzëëbd naa. Laa naa blozhdze bdiixlo leṉ baa, zeeṉe laa Pedr blanso. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Zigne blanso Pedr bzëëb Pedr leṉ baa, goṉ Pedr nligaa laa lar co zhoob ga, ");
INSERT INTO zpmNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","niicle lar ne brieḻ guic mew, laaw zhoobaque ga; ndibëdsew, zhooba tib lad. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nacne bzëëbaque naa. Zeeṉe goṉ naa zha zhoob lar co, dzigoraa bliladz naa ne nli brieeban me. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","¡Sac hor co, bii gard tsoguic naa zha rnee lo Xtiidz Dios; sac ga raquiet ne ible zrieeban me! ");
INSERT INTO zpmNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ye Marí biire blanso ro baa ga stib. Zeeṉe wbii no ga grop no Pedr, laa Marí bii zo ro baa ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ga name zo Marí roon me. Sca roon me, tibaque zeeṉe bui me nëz leṉ baa co, ");
INSERT INTO zpmNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","goṉ me laa chop anjl zob leeṉ co. Dib nquitsbiese rna xab grop anjl co, tib me zob nëz ne bzhoob guic Jesús, stib me zob nëz ne bio ni me; ");
INSERT INTO zpmNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","dzigo rëbchaa me lo Marí: ―¿Pe nacne roon luu? ―Roon naa ―rëb Marí―, sac laa zho biadbee xcuerp Jesús nu, na dieeṉ pa güeysaṉ zho me. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Loxaque blozh sca bnee me, zeeṉe ptsire lo me goṉ me laa tib meṉ co zo gax zhits me. ¡Per ib beeṉbeyd me ne Jesúsa! ");
INSERT INTO zpmNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","―¿Pe nacne roon luu? ―rëb Jesús―. ¿Cho rguib luu? Leḻ güeynie guic Marí rëb me bod meṉ ne rquianap gaw, dzigo rëbchaa me: ―Bzhiguieḻ, teḻne luu biadbee me nu, bnë dieṉ pa lo güeysaṉ luu me; zeeṉa ga naa gaxi naa me. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Horco bneelë Jesús Marí, bredz me me. Zeeṉe bin Marí lë me, lëëlëd biecw me; dzigoraa beeṉbey me Jesús. ―¡Maestro! ―rëb me―. ¡Mod luu i! Laa me zie gbig me lo Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dzigo rëbchaa Jesús: ―¡Xeeṉd luu naa! Sac gard guia naa lo Pxoz naa gbaa. Miṉe naca, güey güeynie diidz lo grë zha ne bzënaḻ zhits naa; gudz lo zho: Laa naa nole nëz guia naa lo meṉ ne nac Pxoz ne, meṉ ne nac Dios ne rdziuuṉbey ne. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Horco lëëlëd wbi Marí ga, ziaadnie me diidz lo no. Blanso me bzodiidz me zha goṉ me Jesús, ni në me lo no zigne rëbse Jesús lo me ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pcow liu dze dmingw co, grëse no ne nac no xpëëdscuel me laa no pcaalsa; loxaque Mazh ruṉfalt. Dziits nquiaa no yag yu, sac rdzieeb no grë zha Israel ne rlëënie me. Laa no ndxie ga, tibaque zeeṉe brieequia me bzo me glowtaa lo no; pquiaabdiuzh me no. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Blozhse pquiaabdiuzh me no, dzigo blu me leṉ nia me lo no, zaatne biaaz clav zeeṉe pquia me lo cruz, ni blu me ro xcuxti me. ¡Grëse no per nli rley no zeeṉe bdzioṉ no ne nli mew! ");
INSERT INTO zpmNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Blozh ga, në me lo no: ―¡Laa naa rnedz tib guieḻbley zdoo to, zeeṉa peet tsienied guic to! Zigne pxeeḻ Pxoz naa naa biaḻ naa, scagaa niina laa naa rxeḻ to. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Dzigo blub me lo no grëse no. ―Goḻcaania Espíritu Sant ―në me―. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ni zeeṉe goṉ guṉ to tib miech perdon, scaque Dios zuṉ me zho perdon; laa teḻne siguieḻd zho guṉ to zho perdon, laa zho biaaṉle lo xtoḻ zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","25","Zeeṉe bdzioṉ no Mazh (Mazh ne rnee zho “Mëëdgrop” ga), bzodiidz now lo Mazh, per bliladzd Mazha, rnee Mazh: ―Rliladzd naa miṉe rnee to i goṉ. Zliladz naaw, per haxta gaṉlo naa me, haxta gaṉ naa leṉ nia me zaatne biaaz clav, ni cteed-xug naa ga; ni csëëbnia naa ro xcuxti me zaatne biaaz lanz ga. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Goc xon ngbidza, laa no pcaalsaque leṉ yu co stib; hor cosi yele Mazh ndxiegrë no ga. Scaque dziits nsioog no ro yu, per tibaque zeeṉe bdzioṉ no laa Jesús bzëëb leṉ yu ga stib, bzo me glowtaa lo no, pquiaabdiuzh me no. Blozhse pquiaabdiuzh me no, ");
INSERT INTO zpmNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","rëbchaa me lo Mazh: ―Wbig na Mazh, bui leṉ nia naa, psëëb mzhugnia luu nu. Dieṉ nia luu nu, psëëbnia ro xcuxti naa. Gacchopdraa guic luu, sinque bliladz gaṉle ne nli mban naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dzigoraa bliladz Mazh ne nli mban me. ―Nasi rliladz naa mban luu ―rëb Mazh―. Luu nac meṉ ne rnabey naa, luu nac xDios naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Pquiab Jesús rëb me: ―Laa luu rliladz niina, lëëcxe laa luu goṉle naa waa. ¡Dichos zha ne gliladz ne nli mban naa, niicle raṉd zho naa! ");
INSERT INTO zpmNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Lo lal ne bzënie Jesús no, ndaldoo milagr ne bdzioṉ no beeṉ me, led grëda raquiet lo guits rii. ");
INSERT INTO zpmNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Miṉe pquiase naa nu, laaw pquia naa zeeṉa zeeṉe glab tow, guieṉ to gaṉle ni gliladz to: Jesús nac meṉ ne biaadsilaa ne lo xtoḻ ne, Dios bzooblo me biaad me, ni Xpëëd Dios nac me; sac zha ne dib zdoo gliladz cho nac me, zgaa zho tib guieḻmban ndzon ne gdziṉd dze lozh. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bded ga, wbiire brieequia Jesús lo no stib, zaatne nac ro nisdoo nroob ne rnee zho Tiberias. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tib bdze dzew, tipse ndxie no gza no Simón Pedr, Mazh, Natanael (meṉ ne nac meṉ Caná ga), bets naa Jacob ni schop zha ne nacgza no. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tibaque zeeṉe në Pedr, laa Pedr tsie gooz meḻ. Dzigo rdzieets no: ―Yeque no sca zia guio ne. Dzigo bziaab no tib leṉ barcw win gza no, laa no zio. Dipse guieel bdzionie no barcw co lo nis, per ni tib meḻ bgaad. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Laa liu ziaadle lozh guini, zeeṉe bdzioṉ no laa tib meṉ co zo ro nis, per ni tib no bdziuuṉbeyd me. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Dzigo bnee meṉ co lo no, në me: ―Yo to dieṉ xin, ¿pe bgaa ma? Pquiab no rdzieets no lo me: ―Choot ma bgaad. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dzigo nëchaa me: ―Goḻroṉ guiex ne rgaa ma i nëz derech gaṉle, znaaz to ma. Dzigo broṉ no guiex co nëz derech. Zeeṉe laa no cueew lo nis, ib lëbd no glis now; ndaldoo meḻ ne biodzë leṉa. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","―¡Pedr! ―rep naa―. ¡Bina gaṉle, xmaistr ne i goṉ! Zeeṉe bin Pedra, lëëlëd wbix Pedr xab Pedr, biab Pedr lo nis; psilo Pedr bzhoobnis Pedr brieequia Pedr ro nis. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Laa no biaaṉ leṉ barcw ga; nole bdziṉniew zaatne nac ro nis. Maase tapgaḻtsii metr sca bdioobniu no guiex co lo nis. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Zeeṉe briee no leṉ barcw, bdzioṉ no laa gui noyecle, laa tib meḻ zhooble lo gui co, ye guietxtil ne. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dzigo në Jesús lo no: ―Goḻtënie bla meḻ ne blozh bnaaz to i nu dieṉ. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dzigo güey Pedr biep me leṉ barcw, güeyxadz me guiex ne no meḻ ga; dzigo bdobniu mew bdziṉnie mew haxta zaatne nacpaa ro nis. Meḻ tafa, niapse ma mbeew, zeeṉe bgab ma rgaa ma tib gayoo chooptsiiptsoṉ lo grë ma; niicle scataa nzian ma, per blëb guiex co, briezda. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Blozh ga, bredz me no, në me: ―¡Goḻtë na, zeeṉa gowxeren to! Ni tib no bnabdiidzd lo me dieṉ pe nli mew; sac, ¡rieṉpaa no ne nli mew! ");
INSERT INTO zpmNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dzigo wbig me bdiiz me guietxtil co lo no, bzheṉ me meḻ ne, bneedz me ma lo no. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ga bioṉ vuelt brieequia me lo no wlal ne brieeban me. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Blozhse bdioowxeren no, bredz Jesús Pedr, psilo zho bzë zho grop zho; dzigo rëb me lo Pedr: ―Simón (xingan Jonás), ¿pe nli dzigo rleynieraa luu naa que grë zha qui? ―Nquialadz naa luu ―rëb Pedr―, ni naṉlegaa luuw gaṉle. ―Pteedlo grë xpëcwxiil win naa sca ―rëb me. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wbiire me, rëb me lo Pedr: ―Simón (xingan Jonás), ¿pe nlipaa dzigo rleynie luu naa? ―Nquialadz naa luu ―rëb Pedr. Dzigo rëb me: ―Pquianap xpëcwxiil naa sca. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Wbiireque me stib rëb me lo Pedr: ―Simón (xingan Jonás), ¿pe nlipaa nquialadz luu naa? Zeeṉe bin Pedr sca rëb me, mban goc zdoo Pedr; sac gale rac tsoṉ vuelt zinabdiidz me lo Pedr, dzigo rëb Pedr: ―Luu nac meṉ ne rnabey, luu naṉa grësew, naṉ luu gaṉle nquialadz naa luu. Dzigo rëb me: ―Teḻne nli nquialadz luu naa, yquiaanap luu xpëcwxiil naa sca. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","’Zeeṉe goṉ bii nguieg luu, led rsoladz luu gaṉle luuzhal racw xab luu, rrieelo rie luu zaatne racladztaa luu; per zeeṉe goṉ laa luu gac meṉgolraa, loxaque nia luu glis luu zhaale zha ne ygacwxab luu, ni zienie zho luu zaatne ni racladzd luu. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Zeeṉe znu rëb me lo Pedr, ga bzeet me zha nac guieḻgut ne ygaa Pedr, ni ga glu Pedr gaṉle pa lotaa meṉ nroob nac Dios. Blozhse ga, rëbchaa me: ―¡Dënaḻ zhits naa! ");
INSERT INTO zpmNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Dzigo naḻaque naa zhits me grop me Pedr. Zeeṉe ptsire lo Pedr, goṉ Pedr laa mëëdscuel ne scataa rleynie me ga, laa zho naḻ ga, zha ne zobpaa cue me ga lo xtsee co, zha ne wbigpaa bnabdiidz lo me dieṉ cho nac zha ne tsielo me ladznia zha ne gut me; dzigo rëbchaa Pedr lo me: ");
INSERT INTO zpmNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","―Teḻzhe zha rii waa, ¿pe nac miṉe ted zho? ");
INSERT INTO zpmNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Rëbchaa me: ―¿Pe nadieṉ guṉ luu ne racladz luu gacnaṉ luuw? Teḻne gacladz naa, zrieelo gnabey naa gban mgui haxta leṉ dze ne guiaḻ naa stib. Led xcuente luu ga. ¡Na zeeṉ dënaḻ zhits naa! ");
INSERT INTO zpmNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Zeeṉe gocnaṉ grëraa zha ne rliladz Jesús sca bnee me, grëse zho tibaque güeynie guic zho gdziṉdraa dze guet naa. Per led scada, sinque znu naca, rëb me: ¡Pe guṉ Pedr! Teḻne gacladz me, zrieelo gnabey me gban naa haxta gaḻ dze ne guiaad me stib. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Grëse miṉe pquia naa nu goṉ, grop lo naa goṉ naaw, grëse zha ne nacgrë no naṉpaa zho gaṉle ne diidzli rne naa. ");
INSERT INTO zpmNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ndaldooraa grë ncuaaṉe nroob ne beeṉ Jesús, teḻ niaca miṉe yquiaw grësew, ni ygaad dib lo guidzliu tsotsow grë guits ne yquiaw ga.");
INSERT INTO zpmNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","¿Yose luu dieṉ bets? Naa goṉ nac Luc, laa naa rxeḻ stib guits rii lo luu. Miṉe pxeḻ naa lo luu glo ga, lo co pquia naa grëse miṉe beeṉ Jesús, grëse wseed ne blu me lo miech zeeṉe psilo me xtsiiṉ me ");
INSERT INTO zpmNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","haxta goḻ dze ne psaṉ me diidz pe nac ncuaaṉe guṉ grë zha ne bzooblo me tsie tsienee Xtiidz me. Espíritu Sant bdeed guieḻbiini lo zho bieṉ zho zha racladz me; lëë dze co ga zey me gbaa. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nli psacsi miech me, beet zho me, per brieeban me. Ni par glu gaṉle ne nli brieeban me, dipse leṉ choo ngbidz brieequia me lo grë zha ne sca bzooblo me tsienee Xtiidz me. Gzataa zeeṉe rrieequia me lo zho, rnee me lo zho zha rnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tib vuelt ndxie zho grë zho me, dzigo pso me diidz lo zho ible grieed zho lad guiedz Jerusalén, haxta guiet Espíritu Sant gdeed guieḻbiini lo zho zigne nacle xtiidz Pxoz me; ni biire rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","―Goḻsoladz gaṉle laa naa nile lo to: nli laa Juan pchoobnis, per niab nisa; saṉgue to zgaa to guieḻbiini ne gneedz Espíritu Sant, rrieequia Espíritu co chobnis to; ni zhile gdziṉ dze ne laa miṉ co gac. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Leṉ ngbidz ne sca nolulo me lo zho, tib vuelt bnabdiidz zho lo me, rëb zho: ―Ndioṉ no meṉ rnabey nac luu. ¿Pe niina na so luu gnabey luu, zeeṉa cuee luu zha Israel ladznia zha Roma? ");
INSERT INTO zpmNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Dzigo pquiab me rëb me lo zho: ―Dios, meṉ ne nac Pxoz naa, ncuaaṉe guṉ me rieguiaḻde to gacnaṉ tow, mese naṉ dieṉ pa dzew, dieṉ pa horgaaw; sac mese nac meṉ ne grieelo guṉa. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sinque to, zeeṉe laa Espíritu Sant gneedz guieḻbiini lo to, hor co laa to ygaa poder ne rap me, laa to csilo gnee lo grë zha Jerusalén cho nac naa; tsie to dib xtan zha Judé, dib xtan zha Samar, ni lo grëragaa miech, tsienee tow. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Blozhse sca bnee me lo zho, zowique zho lo me, dzega, dzega laa me bzoquia gbaa. Glaale ziequia me zeeṉe znuse bdop tib xcow, laa me biongueetsse leṉ xcow co, goṉdraa zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Laa zho bii quiawique zhan gbaa zaatne goṉ zho biongueets me ga, tibaque zeeṉe bdziṉ chop mgui zaatne zo zho ga, dib nquitsbiese rna xab grop mgui co; ");
INSERT INTO zpmNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","rëb me lo zho: ―¿Pe nacne squitaa quiawi to zhan gbaa? Zigne goṉ to i nagoṉ zey me gbaa niina, squique guiet me gbaa gaḻ dze ne laa me guiaad stib. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Blozh ga dzigo laa zho wbi guic gui co (lëë Gui Oliv ga). Zhisaque bzë zho laa zho bdziṉle Jerusalén, lalse ne rzë zho dze ne rdziiladz zho lo dziin. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bdziṉ zho zaatne rbëz zho, biep zho leṉ yu ne riaaṉ glaa; sac leṉ yu glaa co ga no zho. Ga rbëz Pedr, rbëz Ndrés, Jacob, Juan, Lip, Mazh, Bartol, Matew, ni Jacob ne nac xingan Alfé; Simón Zelot, ni Judas meṉlidz Jacob. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Grëse zho tibaque rcaalsa zho rzodiidznie zho Dios grë zho zha bets Jesús, xniaa me Marí, ni grëraa meṉ wnaa ne nacgrë zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tib dze pcaalsa maase tib gayoo gaḻ zho, dzigo guso Pedr bnee me lo zho, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Grëse to bets, grëse to bzian, goḻgacnaṉ gaṉle, miṉe beeṉ Judas zeeṉe sca güeyto me Jesús, nole ne sca gaca. Lo Xtiidz Dios zhobneew, lëë miṉ co pquiaa rey David zeeṉe psiaab Espíritu Santa guic me. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ye Judas gocgza no, ye me nac diidz niuṉ dziin ne nodziuuṉ no niina. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","’Ni nligaa laa ne niuṉ me dziin co, leḻ beeṉ me guieḻntseeb pto me Jesús, ni blozh ga lëëque lo liu ne bziuu dimi ne bdiizh zho me ga, ga güeytsobe me bzob guic me lo liu, wbiḻgazh me, nëzrii nëzrec bliaaḻ leṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Miṉ co nacne zeeṉe laa grë zha Jerusalén gocnaṉa, dzigo bleelë zho liu co “Liu Ren”. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","’Zigne rneque naa ga ―rëb Pedr―, ible lo Xtiidz Dios sca zhobnee; ni lëë miṉ co ga raquiet zaatne znu rnee: Ible ziaaṉdets lidz zho, ni stib choot gbandraa zaatne bio zho. Ni rneequew: Zhaale zha ne guiaaṉnie dziin ne no niuṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Miṉ co nagoṉ, ible nonguieḻa so tib zha ne guiaaṉ xlugar Judas, gacgza zho no guioxobneṉ no ne nli brieeban Jesús. Nana sca, lo grë zha ne nacgrë no psilo bzianie no me zeeṉe pchoobnis Juan me, haxta goḻ dze ne laa me zey gbaa, lad co goḻgotsaa cue ne tib zha ne so gacgza no. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Dzigo ble zho tib meṉ ne lë José Barsabás (lëëque me ga rnee zho Just), ni stib meṉ ne lë Matí. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Blozh ga, bnab zho lo Dios, rëb zho: ―Dios, ndioṉ no luu nac meṉ ne rnabey no; ndioṉ no luuse nac meṉ ne ruṉbey zdoo tib tib miech, gane niina laa no rnab lo luu, luu blu dieṉ cho tib zha rii racladz luu so ");
INSERT INTO zpmNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","guṉ dziin ne psaan Judas; sac laa Judas zeyle zaatne rieguiaḻ Judas. ");
INSERT INTO zpmNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Blozhse bnab zho lo Dios, laa grop zha co bio rif. Nacne brieequia meṉ ne lë Matí ga, dzigo dze cotaa laa me gocgza stsiiptib zha poxtl co. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Zeeṉe goc gadz zhmal gut Jesús, lëëtaque dze co ruṉ grë zha Israel lni ne rnee zho Pentecostés. Dze co grëse zha ne no xnëz Jesús, laa zho pcaalsa. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Laa zho ndxie grë zho, tibaque zeeṉe bio tib bi nroob zhan gbaa, zig nac zeeṉe rriee tib medox, haxta leṉ yu ne ndxie zho ga pquiab; ");
INSERT INTO zpmNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ni brieequia nzian biini, rluw zig nac ludz miech, tibga tibga biini co blëz guic zho grëse zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Horco grëse zho pcaania guieḻbiini ne bdeed Espíritu Sant, psilo zho rnee zho grë xtiidz stib miech miṉe rsiaabtaa me guic zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Leṉ dze co nziandoo grë zha Israel ne no stib ladz beṉ bdziṉ Jerusalén, grë zha ne bii zienaḻ xley Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Laa zeeṉe bio bi co, ye zho no lad grë miech guizhiu ne bdopbe zaatne zob yu co; tib tib zho zeeṉe bin zho laa grë zha ne pcaania guieḻbiini co nonee xtiidz zho, per nli rzee zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Rlozhd gwi zho rnee zho: ―¡Pe nli diidz rii! ¿Zha rrieelo rnee grë zha qui xtiidz ne, ni led zha Galilé nac zho? ¡Tib tib ne ndxie ne nu, zhaase zhaase diidz ne rnee ne! ");
INSERT INTO zpmNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Nu ndxie grë meṉ Part, meṉ Media, meṉ Elam, meṉ Mesopotam, meṉ Judé, meṉ Capadós, meṉ Pont, meṉ Asia, meṉ Frij, meṉ Panfil, meṉ Egipt, haxta grë meṉ ne ziaad nëz África, delant guiedz Ciren; grë meṉ Cret, meṉ Arab, grë zha Israel ne ziaad nëz Roma, grë meṉ Roma, zha ne zienaḻ zhiwseed zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","’Pe zhidaa ne ―rnee zho―, ni diidz ne rneepaa ne tib tib ne laa ne nodzion rnee zha qui grëtaa milagr nroob ne ruṉ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Grëse zho per nli rzee zdoo zho, rdzieldraa zho zha guṉ zho, rnabdiidzlsa zho rnee zho: ―¿Bay pe i? ¡Ncuaaṉe gard dziaṉ ne! ");
INSERT INTO zpmNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Laa nogaa zho rzhidznie, rnee zho: ―Rzudz grë zha qui, gane squi rzë xtiidz zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dzigo bzoli Pedr gza me stsiiptib zha ne nac poxtl ga, psilo me nguiedz bnee me lo grë miech ne ndxie ga, rëb me lo zho: ―Grëse to, zigtaa zha Jerusaléna, zigtagaa zha ne blanso Jerusalén nuw, goḻgona gaṉle. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","No bla to quianee rëb to rzuudz no, per led rzuudzd no. Griiṉpaale name blan ngbidz, niicle niaca zha ne riepaa nziu, niacxe gooṉ nale laa zho gzudz. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Led rzuudzd no, sinque niina nagoṉ noyac grë miṉe bzeet Joel padzeela (tib meṉ ne biadteed xtiidz Dios), zeeṉe znu rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Znu rnee Dios: Zeeṉe wzhile ruṉfalt gaḻ dze co, laa naa cxeḻ zhiEspíritu naa zdoo grëse miech; grë xingan zhow, grë xindzoop zhow, laa zho cteed xtidz naa, grë zha nguieg, nzian grë ncuaaṉe glulo lo zho, grë meṉgol, nzian grë ncuaaṉe glu mcaaḻ lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Leṉ dze co, grëse zha ne nguzobdiidz lo naa, niicle mguiw, niicle wnaaw laa naa cxeḻ zhiEspíritu naa zdoo zho, dzigo grëse zho cteed xtidz naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nzian grë ncuaaṉe gzee zdoo to glu naa zhan gbaa, scaque lo guidzliu, zaṉ to ren, zaṉ to bel, zaṉ to grë goxdoo. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Zeeṉe zhile gdziṉ dze ne guiaad meṉ ne rnabey ne, laa lo ngbidz ycow, laa mëë gna nizhnie zig rna ren. Dze ne guiaad me ga, dze co gac tib dze ne mazdraa nroob, tib dze ne mazdraa ndzon. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Grëse zha ne dib zdoo gnab lo Dios yquia zdoo me zho, grëse zha co scaania me zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’¡Grëse to, goḻquiaadiaga sca gaṉle! Led naṉwen to gaṉle Dios pxeeḻ Jesús, meṉ Nazaret ne biaad lo guidzliu rii, Dios bnabey beeṉ me grë milagr nroob, beeṉ me grë ncuaaṉe bzee zdoo to; ga blu gaṉle ne nli Dios nacnie me. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Laa zeeṉe laa Dios bdeed diidz biab me ladznia to (sac ible xtiidzle Dios naca, naṉle me zha nac ne sca ted Jesús), laa to bnaaz me, bzobdoo to me, bnabey to gut me. Led to goṉ bloo me ladznia grë zha ntseeb ne sca psacsi me pquiaa zho me lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per bleeban Dios me, psilaa Dios me ladznia guieḻgut; sac lëbd guieḻgut ne lëëw gnabey lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","’Zeeṉe bzeet David Jesús, znu rëb me: Meṉ ne rnabey naa, raṉ naa tibaque quianap me naa; tibaque zo me cue naa nëz derech, ¿pe nac nadieṉ ne lega pe gac naa? ");
INSERT INTO zpmNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Gacxe waa, nley no zdoo naa, niicle ludz naaw, rleya rooḻnie naa me. Ni gane tibliladz rac naa; ");
INSERT INTO zpmNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","sac naṉ naa niicle guet naa, ib csaand me guiaaṉ naa leṉ baa, ib gdeete me diidz xiṉ xpëël naa. Naa nac tib nguṉdziin lo me, ni rleynie me naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Me blu lo naa zha grieelo ygaa naa guieḻmban, ni tib guieḻbley nroob ne ygaa naa zeeṉe laa naa gdziṉ lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Bets, bzian, to ne nac to meṉladz naa, goḻgona gaṉle: led miṉe bdete pxozgol ne David bnee me nu; sac goṉ, zeeṉe gut me güey zho güeyqueets zho me, ni haxta lo nadze laa xpaa me bii niaa. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Sinque miṉe bded Jesús ga bzeet me, sac goṉ tib zha ne biadteed xtiidz Dios goc me. Gocnaṉle me ne lo xtii me grieequia Meṉ ne nacle diidz ga cxeeḻ Dios, ni meṉ co sob gnabey zigne bnabey me; sac scale rëb Dios lo me, ni haxta bzeet Dios lë Dios parne glu ne yquidied me. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dzigo zig nac zeeṉe raṉle me grëtaa miṉe ted Jesús, nacne bzeet me ne ib zrieeban Jesús, rëb me guiaaṉd xcuerp Jesús zaatne rbëz grëraa meṉgut, niicle xiṉdgaaw. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","’Jesús ga goṉ bzeet me, sac zig nac Jesús grop lo no bdioṉ no bleeban Dios me, ");
INSERT INTO zpmNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ni niina gbaa zob me cue Dios nëz derech, sac me nac meṉ rnabey. Ni zigne nacle xtiidz Dios meṉ ne nac Pxoz me, laa me pxeeḻ Espíritu Sant lo no; ni niina grëse ncuaaṉe noyaṉ tow, grëse ncuaaṉe noyongaa tow, xtsiiṉ Espíritu Santow. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Laa naa rbire rne lo to stib gaṉle, led miṉe bdete David ga bzeet David; sac goṉ, zeeṉe gut David güeysobd David gbaa. Davitaque goc zha ne znu rëb: Rëb Dios lo meṉ ndzon ne rnabey naa: “Cue naa nëz derech, nu bzob, ");
INSERT INTO zpmNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nieeda lozh gnaz naa grëse zha ne rlëë lo luu, csaṉ naa zho ladznia luu.” ");
INSERT INTO zpmNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Grëse to meṉ wladz, goḻgona sca gaṉle: Jesús goṉ, meṉ ne pquiaa to lo cruz ga, lëë meṉ co nac meṉ ne rnabey. Dios bzo me, ni Dios pxeeḻ me biaad me lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Zeeṉe bin grë miech ne ndxie ga sca bnee Pedr, biab guieḻnë zho, psilo zho rnabdiidz zho lo Pedr ni lo grëraa zha ne nacgza Pedr ga, rëb zho: ―Bets, nana, ¿pe nac ncuaaṉe dziuuṉ no? ");
INSERT INTO zpmNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Dzigo rëb Pedr lo zho: ―Tib tib to, goḻsaan xquieḻntseeb to, goḻbig lo Dios, ni none chobnis to zeeṉa guiaaṉmbe to lo xtoḻ to; scagaa ible sxeeḻ Dios Espíritu Sant gacnie to. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Sac psaṉle Jesús diidz ne ible sxeeḻ me Espíritu Sant gacnie grëse zha ne cuedz me sëëb xnëz me; zigtaa tow, zigtaa xpëëd tow, zigtagaa grëraa meṉzita. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nzianraa grë ncuaaṉe bzodiidz Pedr lo zho, ni pso me diidz lo zho csaan zho grëtaa guieḻntseeb ne ruṉ miech lo guidzliu rii. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Lo grë zha ne bzoobdiag grë miṉe pseed me zho dze co, rgaa zho maase tsoṉ mil; blozh ga, grëse zho brobnis, laa zho gocgrë grë zha ne rliladzle Jesús ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Grëse zha ne rliladz Jesús ga, dib zdoo zho zienaḻ zho grë miṉe rseed grë zha poxtl co zho, tibaque rcaalsa zho rzodiidznie zho Dios, ni row zho guietxtil zigne psaṉse Jesús diidz guṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Grëraa zha ne zo stib lad, rdzieb zho; laa grë zha poxtl co, nzian grë milagr nroob ne ruṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","45","Tipse rnee zho, rdeedlsa zho ncuaaṉe rquiin zha ne nacgrë zho; zha ne quianie liu, teḻ pe grëragaa ncuaaṉe quianie zho, haxta rto zhow, dzigo rguiiz zho dimi co lo grë zha ne guieṉd pe yquiin. ");
INSERT INTO zpmNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Gzataa dze rcaalsa zho leṉ yadoo; rlozh ga, rcaalsaque zho lidz grë zha ne nacgrë zho row zho guietxtil zigne psaṉ Jesús diidz ga; iṉe nley, iṉe ndooladz rbe zho grë zho rquiin zho guieḻwagw ne ruṉlo zho, ");
INSERT INTO zpmNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ni rley zho rooḻnie zho Dios. Grëse miecha, rley zho raṉ zho sca niowse mban zho; ni zigse zie dzew, scase scase laa Dios rbedzraa grë zha ne rzëëb xnëz Jesús, laa zho racnzianraa. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tib dze zig rbixwe ngbidza, briee Pedr grop Juan zie zho yadoo nroob ne zob Jerusalén, sac lëë hor co nac horne rie zho yadoo riezodiidznie zho Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Gax ro yadoo co quia tib puert rnee zho Puert Ndzon, ga rzob tib zhey gol ib gacd së, sac nële ni me zeeṉe gol me. Gzobse dze, rie zha ne riezoob me ga rnab me gon lo grë zha ne rzëëb yadoo. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Laa dze co, zeeṉe goṉ me laa Pedr grop Juan zieded ga ne laa zho sëëb yadoo, zëëb nia me rnab me gon lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Dze rwi zho lo me, tibaque rëb Pedr: ―Lo no bui. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dzigo blis lo me bui me lo zho, naṉ me bod no pe dimi ne gdeed zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Wbiire bnee Pedr lo me, rëb Pedr: ―Quianied naa dimi ygad naa lo luu. Ncuaaṉe grieelose gnedz naa, laaw gnedz naa niina, ¡niapse por Jesús (meṉ Nazaret), laa naa rnab lo luu, niinagazh guso i zeeṉ bzëni! ");
INSERT INTO zpmNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dzigo bzheṉ Pedr nia derech me bliso Pedr me, hor cogazh laa grop ni me ga bdaan, ");
INSERT INTO zpmNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","laa me psilo bzë. Rley me laa me bzëëb leṉ yadoo gza me zho, lo guieḻbley co haxta rias me, ni rooḻnie me Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Grë miech ne no leṉ yadoo, zeeṉe goṉ zho laa me rzële, ni scataa rley me rooḻnie me Dios, ");
INSERT INTO zpmNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bzee zdoo zho; sac ruṉbey zho me, naṉpaa zho rzëd me glo, tibaque raṉ zho me rzob me zaatne quia Puert Ndzon ga rnab me gon. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Zeeṉe laa Pedr grop Juan briee leṉ yadoo nroob co, yeque me naḻ zhits zho ib rsaand me zho, laa zho bdziṉ stib nëz cho yadoo co zaatne quia tib nsaap nroob ne rnee zho zhiNsaap Salomón. Naḻaque grë miech co, rlozhd gwi zho, rlozhd gzee zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Dzigo rëbchaa Pedr lo zho: ―¿Pe rac to? ¿Pe nacne squitaa rzee zdoo to, squitaa rwi to lo no, zig nac zeeṉe no bdziuuṉguiac meṉ rii, zig nac zeeṉe por nguzobdiidz no lo Dios gane brieelo psëë no me? ");
INSERT INTO zpmNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Goḻgacnaṉ gaṉle led scada; sinque Dios meṉ ne bliladz Abraham, meṉ ne bliladz Isaac, meṉ ne bliladz Jacob, meṉ ne bliladz grëraa xmeṉgol ne, meṉ co blu lo to niina ne nli meṉ nroob nac Xpëëd me Jesús. Lëë Jesús co ga goṉ bnaaz to, bloo to me ladznia zhiwxtis ne, ni zeeṉe gocladz Pilat nsilaa Pilat me, pe liaadz to ndeed to diidz. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bdeete to diidz nlaa meṉ ne nac meṉ ndzon, meṉ ne peet xtoḻd; leḻ bnab to blaa tib zha ntseeb ne nzëëb ngutoo. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Laa me, pquia to haxta beet to me, ni me nac meṉ ne rdeed guieḻmban. Per bleeban Dios me, ni mban me niina; sac grop lo no bdzioṉ no me. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","’Ni niina meṉ ne raṉ to biac nu, niapse por Jesús biac me; led ruṉbeyle to me naṉle to gaṉle rzëd me glo. Ne dib zdoo no rliladz no Jesús, gane brieelo bnab no beeṉguiac Jesús me. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Grëse to bets, ne nac to meṉladz naa, rgobey naa niicle to ni niiclegaa grë zha ne nac zhiwxtis ne, lega laa to bnabeyse bgaa Jesús beet to me, niicle to bieṉdaque dieṉ pe nacne sca beeṉ to. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Laa Dios bneedz diidz beeṉ to grë guieḻntseeb co, sac sca goc grëse miṉe bzeet grë zha ne biadteed xtiidz Dios padzeela, zeeṉe bzeet zho zha nac grë guieḻnë ne ted Jesús, Meṉ ne nacle diidz cxeeḻ Dios guiaad lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","’Doḻ nroob ga goṉ beeṉ to, gacxe nana goṉ waa goḻsaan xquieḻntseeb to, goḻbig lo Dios; zeeṉa csaṉmbe me to lo xtoḻ to. Me gneedz guieḻbley lo to stib, ");
INSERT INTO zpmNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ni zbiire cxeeḻ me Jesús lo to stib, guiaadsilaa me to. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Gbaa no me niina, ni ga cuëz me nieeda gaḻ dze ne laa Dios blozh bnabey goc grëse ncuaaṉe none gac, zigne bzeetse grë zha ne pxeeḻ me padzeela, biadteed xtiidz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Zig nac Moisés bzeet me laa Jesús guiaad, rëb me lo grë pxoz gol ne: “Dios meṉ ne rnabey ne, ible znabey me ne lo xtii to grieequia tib meṉ ne gac zig nac naa lo to niina. Zeeṉe laa me guiaad, goḻgon xtiidz me; ");
INSERT INTO zpmNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","sac zha ne gond xtiidz me, ib tedsod znitlo zho.” ");
INSERT INTO zpmNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Scaque Samuel, ni grëraa zha ne biadteed xtiidz me, grëse zho bzeetle zho grë ncuaaṉe noyac leṉ dze rii. ");
INSERT INTO zpmNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","’Grëse to, xmeṉgol to nac grë zha co, ye to ga rëb Dios guṉlay me zeeṉe znu biaaṉ me diidz grop me Abraham, rëb me: “Niapse por tib meṉ ne grieequia lo xtii luu, laa naa guṉlay grëse miech ne ndxie gdibdoose lo guidzliu.” ");
INSERT INTO zpmNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ni niina ne laa Dios bleeban Jesús, gloque lo to pxeeḻ me me, guṉlay me to, zeeṉa csaan to xquieḻntseeb to. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Laa Pedr grop Juan bii noneeque lo grë miech co, zeeṉe laa bla zha ne nac pxoz bdziṉ ga, bdziṉnie zho tib zha non ne quianap yadoo co ni zla zha ne nacgrë zha saducé. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","3","Zigne bdziṉ zho bnaaz zho Pedr grop Juan, güeysëëb zho zho ladzguiib; ni ne bdzele dzew, ga biaaṉ zho dipse guieel co. Rlëë grë zha co, sacne laa Pedr grop Juan quianee lo grë miech co zha bleeban Dios Jesús; ni rnee zho grëse meṉgut, scaque grieeban zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Niicle ne scataa rlëë grë zha rnabey co, per nzian zha ne ndxie ga bliladz Jesús; zig gaay mil rgaa loxaque zha bgui. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Zeeṉe biini liu co, grëse zha non, grëse zha ne rnabey lo meṉguiedz, laa zho pcaalsa. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ga bdziṉ Anás meṉ ne nac pxoz nroob ne rnabey, ga bdziṉ Caifás, bdziṉ Juan, bdziṉ Lejandr ni grë zha ne nac meṉlidz pxoz ne rnabey ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dzigo bnabey zho gocredz Pedr grop Juan, bzo zho zho glowtaa, bnabdiidz zho lo zho, rëb zho: ―Goḻnë nadieṉ, ¿cho rnabey to, cho pxeeḻ to ne squi no to? ");
INSERT INTO zpmNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Horco laa Espíritu Sant bdeed guieḻbiini lo Pedr, pquiab Pedr rëb Pedr lo zho: ―Grëse to ne nac to zha ne rnabey lo meṉguiedz, grëse to ne nac to zha gol ne non xtiidz. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Teḻne miṉe rlisqui to nac ne dieṉ zha bdziuuṉ no meṉ rii ne laa ni me biac, ");
INSERT INTO zpmNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","goḻsiguieḻ goḻquiaadiaga gaṉle, zeeṉa gacnaṉ tow ni gacnaṉ grëragaa meṉguiedza. Jesús goṉ, meṉ Nazaret ne bnabey to gut lo cruz ga, meṉ ne bleeban Dios ga, meṉ co beeṉguiac meṉ rii; ni laa to raṉgaa me laa me zo lo ne nu. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Lëë Jesús ga raquiet lo Xtiidz Dios zaatne znu rnee: “Quie ne psëëb zha ne nozaa yu, ni naṉd zho lëëpaa quie co nac miṉe rnazdziits yu.” Ni scapaa nagoṉ bzhaac to me. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Loxaque me zrieelo csilaa ne lo xtoḻ ne, sac bzodraa Dios cho stib zha ne niaad lo guidzliu niaadsilaa miech. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Zeeṉe goṉ grë zha wxtis co, scataa peet dzeb nod lo Pedr grop Juan, bzee zdoo zho; sac ruṉbey zho Pedr, ruṉbey zho Juan, nacd zho cho zha ne güey wseed nroob. Ga goṉ zho, pa lotaa guieḻbiini ne bgaa Pedr grop Juan ne bzënie zho Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Peet brieelod nlisqui grë zha co, sac nligaa laa meṉ ne biac ga zo lo zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Dzigo mazd bnabey zho briee Pedr ley grop me Juan; laa zho biaaṉ bzodiidz zho dieṉ zha guṉ zho zho, ");
INSERT INTO zpmNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","sac rieṉ zho tib milagr nroob ga sca biac ni meṉ co; niicle ne racladz zho yqueets zhow, per grële meṉguiedz bina. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nacne biaaṉ zho diidz, ctseb zho zho gbiiredraa zho cseed zho miech zhiwseed Jesús; zeeṉa lozhd gacnaṉ grëraa miech zha biac meṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dzigo bredz zho Pedr stib, grop me Juan, goctox zho lo zho. ―Laa no rso diidz lo to goṉ ―rëb zho―, gbiiredraa to cseed to miech zhiwseed meṉ ne rnee to Jesús ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pquiab Pedr grop Juan, rëb zho: ―Zha dieṉ rzac to, ¿pe nonguieḻa ga laa ne dziuuṉ no miṉe rnabey Dios, leḻ miṉe rnee to i dziuuṉ no? ");
INSERT INTO zpmNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Grieelod goṉ dziuuṉ no miṉe rnee to i, sac grëse ncuaaṉe bdzioṉ no, grëse ncuaaṉe bdziongaa no ib none gnee now, zeeṉa gacnaṉ grëse miecha. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dzigo wbiire grë zha rnabey co, ntseeb rac zho lo zho pso zho diidz cseetraade zho miech; blozhse ga laa zho psilaa zho. Bdeetew diidz nsacsi zho zho, sac ndal miech ne rleynie Dios, rdeed zho xquizh lo me ne beeṉ me milagr ");
INSERT INTO zpmNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","beeṉguiac me meṉ co, ni choole iz rac sca gacd së me. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Zeeṉe laa Pedr grop Juan bdziṉ lo grë zha ne nacgrë zho, bzodiidz zho grëse teḻ zha rëb grë zha rnabey co, zha rëb pxoz non co. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Grë zha ne nacgrë zho ga, zeeṉe bin zhow grëse zho psilo zho bnab zho lo Dios, rëb zho: ―Dios, luu nac meṉ ro ne rnabey grëtaa ncuaaṉe no, luu bzaa gbaa, luu bzaa guidzliu, luu bzaa nisdoo, luu bzaa grëraa ncuaaṉe no. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Padzeela zeeṉe bdeed Espíritu Sant guieḻbiini lo pxozgol no David, meṉ ne beeṉ xtsiiṉ luu hor co; znu bnee me: ¿Pe nacne squitaa rac grë miech ne nacd zha Israel rlëënie zho Dios? Racladz zho guṉ zho ncuaaṉe ni grieelod lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Grëse zha non ne rnabey grë guiedz, tipse rac zho laa zho racntseeb lo Dios rlëënie zho me, ni rlëënie zho meṉ ne bzooblo me pxeeḻ me lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ni nligaa na scase goca. Guiedz Jerusalén nu, nu biaad rey Herod, biaad Pons Pilat, pcaalsa zho grë zho meṉladz no ni grë meṉzit, tipse bnediidz zho psacsi zho Jesús, meṉ ndzon ne bzooblo luu pxeeḻ luu biaadguṉ xtsiiṉ luu lo guidzliu nu. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Grëse zigne psaṉle luu diidz, scase beeṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ni scaque niina, bui gaṉle zha racladz zho ctseb zho no parne peet gneedraa no; luu nac meṉ ne gocnieṉ no ne nac no zha ne rdziuuṉ xtsiiṉ luu, zeeṉa gdzieebd no cseed no miech xtiidz luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Laa no rnab lo luu, beeṉguiac grë meṉ rzacnë, beeṉ grë milagr nroob, blu grë ncuaaṉe gzee zdoo miech; zeeṉa gaṉ zho gaṉle meṉ nroob, meṉ ndzon nac Xpëëd luu Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Zeeṉe blozh bzodiidznie zho Dios, masaque bzhidz zaatne ndxie zho ga; hor co grëse zho laa zho bgaaraa guieḻbiini ne bdeed Espíritu Sant lo zho; peet rdziebdraa zho laa zho zieseed miech Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Leṉ dze co, grëse zha ne rliladzle Jesús ga, tibaque nac zho, tibaque rnee zho, tibaque nac miṉe zienie guic zho. Nod zha ne guiab lose zho yquiin ncuaaṉe rap zho; sinque grëse ncuaaṉe quianie zho cheṉ grë zho naca. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Grë zha poxtl co, zeeṉe rseed zho miech zha brieeban Jesús, nzian zha ne rliladz me; rlupaa ne Dios nacnie zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ne nligaa tipse nac zho grë zho, nod zha ne guiab ne guieṉd pe yquiin, sac grëse zha ne quianie liu, zha ne quianie nzian yu, rto zhow dzigo rdeed zho dimi co rguiiz grë zha poxtla lo zha ne rquiina. ");
INSERT INTO zpmNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sca beeṉ tib meṉ ne nacgrë zho lë José. (Zha xtii Leví nac me, gol me tib lo guidzliu win ne no lo nisdoo lë Chipr; zha poxtl-le bleelë me Bernabé. Bernabé, nac zig nac ne rnee ne: Zha ne rchoobladz zdoo miech.) ");
INSERT INTO zpmNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Pto me tib lë liuṉ me, dzigo bdeed me dimi co lo zha poxtl, bdiiz zhow. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Tib mgui lë Ananí, laa tsieel me lë Safir; ye me pto tib lë liuṉ me. Goṉlo tsieel me, teḻ palal dimi ne bdo liu co, bzheṉga me zhisa. Zeeṉe laa me ziesaṉ miṉe biaaṉ ga, lo poxtl, rëb me lëë grë dimi ne bdo liuṉ me ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Dzigo rëbchaa Pedr lo me: ―Ananí, ¿pe nacne bdeed luu diidz bzëëb meṉdox zdoo luu? Meṉdox i goṉ noquiil luu naṉ luu yquidiee luu Espíritu Sant, rnee luu lëë grë dimi ne bdo liuṉ luu nu. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bieṉ gaṉle cheṉ luu liu co. Dimi ne bdiizh zhow, cheṉ luuw, niac niuṉ luuw zigne niacladztaa luu, ¿pe nac dzigo ne racladz luu yquidiee luu? Goṉ gaṉle led nod noquidiee luu, Dios i gocladz luu nquidiee luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Loxaque sca bin Ananí bnee Pedr, znuse biab Ananí liu, gagazh gut Ananí. Grëse miech ne bina, bdzieb zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dzigo güey bla zha nguieg pcheḻ zho ngutoo co lar, blis zho me ga laa zho ziequeets me. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Wdzeelaaque goca zeeṉe laa tsieel me bdziṉ, ni lalnu güeynied guic me ne laa tsieel me gutle. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bnabdiidzaque Pedr lo me, rëb Pedr: ―Bnë dieṉ, ¿pe nli lëë grë dimi ne bdo liuṉ to nu? Pquiab wnaa co, rëb me: ―Nliw, lalgui pto now. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","―¿Pa briee pensar qui lo to grop tsieel to? ―rëb Pedr―. Ne squi tipse bnee to naṉ to yquidie to Espíritu Sant; doḻ nroob i goṉ beeṉ to lo Dios. Laa zha ne güeyqueets tsieel luu blansole ro yu nu, ni niina goṉ laa zho güeyaque luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Diidz co blozh briee ro Pedr, znuse biab wnaa co liu, guchedraa me ga. Zeeṉe laa gza zha nguieg co bzëëb leṉ yu, laa me nixle ga; goṉ zho gutle me, dzigo blis zho me güey zho güeyqueets zho me cue xpaa tsieel me. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Grëse zha ne goṉ sca goc meṉ co grop me, zha ne bingaaw, zigtaa zha ne rliladz Jesúsa zigtagaa grëraa miecha, per nli bdzieb zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Grë zha poxtl co, tibaque rcaalsa zho tib lo nsaap ne quia cho yadoo ga rnee zho zhiNsaap Salomón; nzian grë milagr ne rdeed Dios diidz ruṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Grëse miech ne rcaalsa ga, rleynie zho grë zha poxtl co, nzian zho rliladz miṉe rseed zho, per rbigd zho gacgrë zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Zigse zie dze, scase racndalraa miech ne rzëëb xnëz Jesús, mguisaque wnaasaque laa zho rliladz me dib zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Zhoob diidz scataa milagr ne ruṉ grë zha poxtl co. Dzigo psilo miech rbee zho grë meṉ rzacnë, rguix zho me ro nëz, no me zhoobse lo xlon me, no me zhoob lo yag ne ney zho me; rquiambëz zho maase zhimlëse Pedr guiab lad grë meṉ co zeeṉe laa Pedr ted. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Haxta grë guiedz win ne ndxie gax Jerusalén ga, rriee grë miech rdziṉnie zho grë meṉ rzacnë, no grë meṉ co noguitnie meṉdox; grëse zho ruṉguiac zha poxtl co zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Zeeṉe goṉ meṉ ne nac pxoz nroob ne rnabey, ni grë zha saducé, scataa racnie miech grë zha poxtl co, per nli blëë zho, ");
INSERT INTO zpmNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","bnabey zho bgaa zho psëëb zho zho ladzguiib stib. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pcow liu co, guieela bdziṉ tib xanjl Dios pxal me ro ladzguiib, blee me zho ga; dzigo rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Goḻtsie leṉ yadoo, grëse miech ne ndxie ga goḻnee lo zho, zeeṉa gacnaṉ zho zha ygaa zho guieḻmban ndzon ne nodeed Dios niina. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Biinigazh liu, silgaw laa zho bdziṉle leṉ yadoo; psilo zho laa zho noseed grëse miech ne ndxie ga. Laga laa zho noseed miech leṉ yadoo, laa meṉ ne nac pxoz nroob ga, grë me zha ne nacnie me, bnabey zho ycaalsa zha ne nac wxtis ni grë zha non lo meṉguiedz. Zeeṉe laa grë zha co pcaalsa, dzigo pxeeḻ zho zha ne ziebee grë zha poxtl co ladzguiib. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bdziṉ zho ro ladzguiib, ni tib choot guieṉd leeṉ co; rzhitsaque wbire zho güeynie zho diidz, ");
INSERT INTO zpmNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","rëb zho: ―¡Choot guieṉd leṉ ladzguiib! Dziits niooga bdziṉ no, ga zo zha ne quianap; per zeeṉe bzhial ro ladzguiib bziaab no, bdzioṉ no choot guieṉd leeṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Grë pxoz ne rnabey, ni meṉ ne zo lo meṉguiib ne rquianap yadoo, zeeṉe bin zhow, rdzieldraa zho zha guṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lëëtaaque sca no zho, zeeṉe bdziṉ tib zho rëb: ―Zha ne goṉ bloo to ladzguiib ga, laa zho nolaque leṉ yadoo noseed zho miech. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Lëëlëd briee meṉ ne zo lo grë meṉguiib ne rquianap yadoo, brieenie me bla xaguiib me, güey zho niapse wen diidz güeyxi zho zha poxtl co leṉ yadoo; sac rdzieb zho ngoquie grë miech co zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Zeeṉe bdziṉnie zho zho lo grë zha wxtis co, dzigo rëb meṉ ne nac pxoz nroob ga lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Pe nacne ronde to diidz? Led pso no diidz lo to cseetraade to miech zhiwseed mgui ne nac Jesús ga. Ni na goṉ dible lad guiedz nu nozhoobneṉ zhiwseed to i, haxta rcaadzdoḻ to no ne no bdziuut me. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dzigo pquiab Pedr rëb Pedr: ―Rdzion no miṉe rnabey samiech no, per glo none dziuuṉ no miṉe rnabey Dios no. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Meṉ co bliladz grë pxozgol ne, ni meṉ co goṉ bleeban Jesús, meṉ ne sca psacsi to beet to lo cruz. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ni meque zeynie Jesús gbaa, bzoob me Jesús cue me nëz derech; sac Jesús nac meṉ ne rnabey, meṉ ne rsilaa miech lo doḻ. Ni Jesús goṉ, gdeed guieḻbiini lo grëse meṉ Israel gbiire gbig zho lo Dios stib; zeeṉa guṉquizhd me zho xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","’Miṉe rnee no lo to nu diidzliw, nozhal bdzioṉa, ni led loxaque nodsegaa; sinque ye Espíritu Sant meṉ ne rxeeḻ Dios racnieṉ grë zha ne ron xtiidz me, ye meṉ co quianee gaṉle ne nliw. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Zeeṉe bin zho sca rëb Pedr, blëëye zho, rzac zho tebaa gagazh gut zho gza zha poxtl co. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lad zha wxtis co no tib zha farisé lë Gamaliel, ye me rseed miech Xley Dios, tib zha non nac me lo meṉguiedz; dzigo guso me bnabey me briee grë zha poxtl co nëz ley, ");
INSERT INTO zpmNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","bnee me lo grëraa zha ne ndxie ga, rëb me: ―Grëse to meṉguiedz, laa naa rso diidz lo to, goḻcobey goṉ dieṉ pe guṉ to zha qui. Goḻguieṉ gaṉle, nonguieḻda ne lega miṉe gacladztaa to guṉ to zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Goḻsoladz gaṉle, padzeela squi bio tib meṉ ne brieelë Teudas, rëb me laa me niac tib zha ne nabey, ndal zha ne wbig lo me, goclo zho zig tap gayoo. Ni pasë me nabey, zeeṉe laa me gut nëzrii nëzrec bliaaḻ grë zha ne gocnie me ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Laa leṉ iz ne nodop lë miech, scaque brieequia tib meṉ Galilé brieelë Judas. Ndal zha ne gocnie me, per zeeṉe laa me gut scasaque nëzrii, nëzrec bliaaḻ grë zha ne gocnie me; brieelodaque pe niuṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Gane nagoṉ rne naa lo to, mazd peet guṉde to zha qui, goḻsaan zho squise goḻsilaa zho. Tsow glu teḻne guicse miech biab wseed ne ziaadnie zho i, zdziṉ dze ne nitlow. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Laa teḻne nligaa Dios rsiaab guic zho squi rseed zho miech, niacxe zlëb to gnitlo to wseed ne ziaadnie zho. ¡Teḻne guiab to gnitlo tow, naṉde to nend Dios ga tiḻnie to! ");
INSERT INTO zpmNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Grëse zha wxtis co bzoobdiag zho xtiidz Gamaliel, bieṉ zho ne scataa nonguieḻ gaca. Dzigo biire bredz zho grë zha poxtl co, bdiṉ zho zho, ni biire pso zho diidz lo zho gbiiredraa zho cseed zho miech zhiwseed Jesús. Blozhse ga, dzigo laa zho psilaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Zeeṉe laa zho wbi ga, rley zho por grëtaa miṉe pteed grë zha non co zho loxaque ne rliladz zho Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ib psaand zho zhiwseed Jesús, gzobse dze rie zho yadoo ni rieque zho stib yu stib yu, rnee zho lo miech ne nli lëë Meṉ ne zëëble diidz cxeeḻ Dios lo guidzliu ga nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ni ne leṉ dze co quiayac nzianraa miech ne rzëëb xnëz Jesús, dzigo psilo grë zha Gres rlisqui zho, rnee zho rdiooṉd grë wnaa viud ne nac zha ladz zho zaacse; zeeṉe rgaaz ncuaaṉe row zho, rgaad zho lal miṉe rgaa grë wnaa viud ne nac zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dzigo nacne bredz gza tsiipchop poxtl co grëse zha ne nole xnëz Jesús ga, bnee zho lo zho rëb zho: ―Gacnaṉ to gaṉle, grieelodraa ne noque so dziaṉ no dieṉ zha ygaaz ncuaaṉe yquiin to, sac goṉ nonguieḻda csaan no miṉe nac xtsiiṉ no, ib none guioseedraa no miech Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Miṉ co nagoṉ, mazd goḻzo gadz zha bgui ne guṉ dziin co, lëëraasi goḻguieṉ cho gzo to; goḻguib zha ne ndzinli, zha ne nixbiini, zha ne nacnie Espíritu Sant; ");
INSERT INTO zpmNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","zeeṉa sca guiob lo no gzodiidznie no Dios, gnab no lo me, ni cseed no grëraa miech Xtiidz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Grëse zho rëb, wen sca gaca. Horcogazh psilo zho ble zho zha ne so guṉ dziin co. Bzo zho tib meṉ lë Lip, tib meṉ lë Prócoro, tib meṉ lë Nicanor, tib meṉ lë Timon, tib meṉ lë Parmen, tib meṉ lë Xteb, rlupaa dib zdoo me rliladz me Dios ni nacnie Espíritu Sant me; ni tib meṉ Antioquí lë Nic, mazd glo Nic goc tib zha ne bleyniedox grë zhiwseed zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Dzigo güeynie zho gza zha co lo zha ne nac poxtl. Blozhse bnab poxtl lo Dios gacnieṉ me zho, dzigo pxobnia poxtl guic zho, bnab zho lo Dios gdeed me guieḻbiini lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Zigse zie dze, laa Xtiidz Dios quiagaazraa dib Jerusalén. Nzian grë zha ne rzëëb xnëz Jesús, haxta grë meṉ ne nac pxoz, nzian zho laa zho bliladz me dib zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Goc palal dzew, nzian grë milagr nroob ne ruṉ Xteb, sac tibaque sca dib zdoo me rliladz me Jesús, ni nacnie Espíritu Sant me. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Laa tib dze, brieequia bla zha ne rie tib xyadoo win zha Israel, lë “Esclavos Libertados” gocladz zho ndiḻdiidznie zho Xteb. Brieeque zla zha Israel ne ziaad nëz Ciren, nëz Alejandrí, nëz Cilis, ni nëz Asia, ye zho gocgza zha co rlëë zho lo Xteb. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Goṉse zho rlëbd xtiidz zho lo Xteb, sac niapse Espíritu Sant rdeed guieḻbiini lo me, rieṉ me pe rnee me lo zho; ");
INSERT INTO zpmNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","dzigo bdiizh zho bla zha ne ptsieets diidz, pquidie zho rëb zho bin zho laa Xteb noneenë Moisés ni rneenë me Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Zeeṉe bin meṉguiedza, blëë zho; nacne bnabeyaque zha ne rnabey lo meṉguiedz bgaa Xteb güeyzo zho me lo wxtis. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ni güeynie zho bla zha ne lega bnexuu, rëb zho: ―Nliw, rtsidiḻ mgui qui xyadoo ne, rtsidiḻ me xley ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bdzioṉpaa no goṉ quianee me laa Jesús meṉ Nazaret ne quiazeet zho dib i ctsiḻ yadoo rii, ni ctsëë me ley ne psaṉ Moisés lo xmeṉgol ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Horco zeeṉe laa grë zha wxtis co ni grëraa zha ne ndxie ga bui lo Xteb, goṉ zho tib biini nroob ne riab lo me, masaque rlu me zig rlu tib xanjl Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Dzigo bnabdiidz meṉ ne nac pxoz nroob ga lo Xteb, rëb me: ―¿Bnë dieṉ pe nli quiayuṉ luu grë ncuaaṉe rnee zho i? ");
INSERT INTO zpmNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","―Grëse to ne nac to meṉladz naa ―rëb Xteb―, laa naa rzaac to zig bets naa, zig pxozgaa naa. Goḻsiguieḻ goḻquiaadiag chop tsoṉ lan diidz ne gne naa lo to nu gaṉle: Padzeela, zeeṉe bii no pxozgol ne Abraham dan ne lë Mesopotam, brieequia Dios ndzon ne no gbaa lo me, rëb Dios ");
INSERT INTO zpmNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","griee me ga, csaṉ me grë meṉlidz me, tsie me nëz ne glutaa Dios lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","’Nacne briee me xtan zha Caldé ga, bey me nëz Harán, ga wban me zhis. Laa zeeṉe laa pxoz me gut, dzigo laa Dios biaadnie me nëz rii, zaatne mban ne nu niina. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Niicle ne laa me blanso lo liu rii, ni tib lë win zaatne so ni me bdeete Dios lo me; per rëb Dios ib grë zha xpëëd me guiaaṉniew. ¡Ni laa me quianied mëëd leṉ dze co! ");
INSERT INTO zpmNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Rëbgazh Dios lo me, ib zieban grë zha xpëëd me ga ladz beṉ dipse leṉ tap gayoo iz, ga csacsi miech zho guṉcuṉ zho zho dziin. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Per ib tedsod sacsi naa zha ne csacsi zho ga”, rëb Dios, “ni ga griee zho glanso zho nu, nu gooḻnie zho naa.” ");
INSERT INTO zpmNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","’Ni parne glu ib zac miṉe bnee Dios lo Abraham ga, dzigo psaṉ me diidz grëse mëëdbgui ne grieequia lo xtii Abraham none tso tib bey lad zho. Miṉ co nagoṉ, zeeṉe laa xpëëd me Isaac goc xon ngbidz, laa me bloo Isaac bey co. Scaque beeṉ Isaac xpëëd me Jacob, ni scaque beeṉ Jacob gza tsiipchop zha ne goc xpëëd Jacob; lëë gza tsiipchop zha co nagoṉ goc pxozgol ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ziese pxozgol ne ga, blëënie zho bets zho zha ne lë José, pto zho José lo meṉ ne zie wto nëz Egipt. Ni ne nacnie Dios José, ");
INSERT INTO zpmNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","psilaa me José lo grëtaa guieḻnë ne bded José, ni gocnieṉ me José beeṉbey rey Egipt José. Ib psaand me José, bdeed me guieḻbiini lo José. Zeeṉe goṉ rey co scataa meṉ nixbiini nac José, dzigo bnabey me bzo José goc me tib meṉ non ne bnabey dipse Egipt; haxta grë ncuaaṉ non ne no lidz rey, me bnabeya. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Lëëtaaque leṉ iz ne nac me dziin, biaad tib gbin; dipse xtan zha Egipt, dipse xtan zha Canaán mban bded miech. Grë zha ne goc pxozgol ne ga, guieṉdraa pe gow zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Laa zeeṉe bin Jacob laa zhobxtil bii no Egipt, dzigo pxeeḻ me zho güeyxi zho zhob ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","’Zeeṉe goc chop vuelt ziexi zho zhob Egipt, dzigoraa gocnaṉ zho bets zho ga rnabey Egipt; niiclegaa rey cow, hor coraa beeṉbey me bets José. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dzigo bnabey José güeyxi zho pxoz me Canaán, güeyxi zho tsieel zho, güeyxi zho xpëëd zho. Lo grë zho rgaa zho tsoṉgaḻ tsiiṉ, laa zho bdziṉ Egipt. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","16","’Sca nacne laa Jacob bey Egipt. Ga gut me, dzigo güeyqueets zho me Siquem, tib leṉ baa ne bzhii Abraham lo Hamor; scaque grë xpëëd me zha ne goc pxozgol ne ga, ga gut zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Grë zha ne brieequia lo xtii zha gol co, zha ne na guiab ne nac meṉladz ne, ndal iz ne bio zho Egipt ga, ni ndaldoo goc zho. Laa zeeṉe ziaadyob cuee Dios zho ga zigne rëble me lo Abraham glo, ");
INSERT INTO zpmNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","laa meṉ ne nac rey Egipt leṉ dze co, psilo ptsidiḻ zho; sac rsoladzdraa me grëtaa dziin ne beeṉ José lo meṉladz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Psacsi me zho, beeṉ me zho zigne gocladztaa me, haxta bnabey me grëse mëëdbgui ne ral gaṉdraa zho win parne guet win. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","’Leṉ dze copaa nagoṉ gol Moisés, tib mëëd niow nac win. Tsoṉ mëë bloolan xniaa win win, ");
INSERT INTO zpmNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","laa zeeṉe brieelodraa ngolan me win, dzigo güeysaṉ me win tib ro guiubee Egipt, ga bdziel tib xindzoop rey win. Wnaa co goṉ win, biaaṉ win lo me zig tib xpëëd me; ");
INSERT INTO zpmNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","haxta bioxco me grëse wseed ne rac zha Egipt, pseed win. Zeeṉe laa win broob, tib meṉ nixbiini goc win, niicle ne gnee wina, niicle ncuaaṉe guṉgaa wina. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Choo iz rap Moisés, zeeṉe biab guic me güeyted me lo meṉladz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dzigo goṉ me laa tib zha Egipt quiaguiṉ tib zha Israel; nacne bzëëbaque me bla me zho, beet me zha Egipt co. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","’Sca beeṉ Moisés, naṉ me nieṉ grë zha Israel ne Dios bzo me gacnie me zho, csilaa Dios zho ladznia zha Egipt; per bieṉd zho ne scaw. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Biini liu co, goṉ me laa chop zha Israel nodiḻ, zie me nla me lo xtiḻ zho, bnee me lo zho nonguieḻd ga tiḻ zho, guieṉ zho gaṉle meṉladzaque zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dzigo biasaque tib zha ne noquiaaw ga pcheep zho me, ntseeb rac zho rëb zho lo me: “¿Cho bzo luu guiaadnabey luu no, guiaadlisquigaa luu dieṉ pe nodziuuṉ no? ");
INSERT INTO zpmNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Te racladz luu ye gutaque luu no zigne beet luu zha Egipt co nieeg?” ");
INSERT INTO zpmNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","’Zeeṉe bin Moisés sca rëb zha co, hor co bzhooṉ me bey me nëz xtan zha Madián. Nëz co ptsieelnia me, ga gop tsieel me chop mëëdbgui. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Choo iz goc no me nëz xtan zha Madián, tib dze no me cho gui Sinaí, tibaque zeeṉe goṉ me laa tib anjl zo groḻtaa tib lo yag zarz, masaque rso bel lo yag co. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Bzee zdoo me, lëëtaque laa me zie gbiggax me, zeeṉe bin me tsi Dios rëb Dios lo me: ");
INSERT INTO zpmNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Naa nac Dios ne bliladz pxozgol luu Abraham, pxozgol luu Isaac, pxozgol luu Jacob.” ’Zeeṉe bin Moisés tsi Dios, per nli bdzieb me; lo dzeb co per ni blisdraa me lo me nwi me. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dzigo bnee Dios stib, rëb me lo me: “Blit lab luu, sac gax lo naa i zo luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Laa dze nagoṉ bdziṉ ne laa naa csilaa grë zha Israel ladznia zha Egipt; sac raṉ naa zha nactaa grë guieḻnë ne noded zho ga, ron naa blactaa roon zho nosacsi zha co zho. Ni luu bzooblo naa tsiebee zho ga.” ");
INSERT INTO zpmNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Dzigo laa Dios pxeeḻ Moisés ziesilaa me zha Israel; niicle ne glo rëb zho lo me: “¿Cho bzo luu guiaadnabey luu no, guiaadlisquigaa luu dieṉ pe nodziuuṉ no?” Per me bzo Dios bnabey lo zho, blee me zho Egipt. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","’Nzian grë milagr, nzian grë ncuaaṉe nroob ne gzee zdoo ne beeṉ Moisés blee me zho ga; zigtaa leṉ guiedz Egiptow, zigtaa lo Nisdoo Nizhniew, zigtagaa grë dan bidz ne bio zho dipse leṉ choo iz ne bzënie me zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","’Moisés ga bzeet lo pxozgol ne, ne laa Dios gnabey lo xtiique zho grieequia tib meṉ ne cxeeḻ me guiadteed xtiidz me, zigne pxeeḻ me Moisés. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","’Zeeṉe nonie Moisés zho grë dan bidz co, Anjl ne bnee lo me guic gui Sinaí, me pteed xtiidz Anjl co lo zho; me pcaania ley ne biaaṉ lo ne ga, diidz ne rap guieḻmban. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Per ib bind zho xtiidz me, leḻ gocladz zho mbiire ney zho Egipt stib, ");
INSERT INTO zpmNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","bnabey zho Aarón rëb zho: “Bzaa tib mdio tedner lo no gacnieṉ no laa no guioo Egipt stib; sac loxaque biadbee Moisés no ga, na choot naṉd dieṉ yo Moisés.” ");
INSERT INTO zpmNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","’Dzigo bzaa zho tib ngon yeeṉ goc zhimdio zho, haxta beet zho grë ma ne bloogon zho lo mdio co; bleynie zho ncuaaṉe bzaania zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nacne wbiṉladz Dios, psaan me zho; psilo zho bleynie zho grë ncuaaṉe raṉ zho zhan gbaa. Beeṉ zho zigne bzeetse zha ne biadteed xtiidz me padzeela, zeeṉe rëb zho: Goḻsoladz gaṉle, laa ne nleynie to naa dipse leṉ choo iz ne bio to grë dan bidz co, laa ne niut ma ne ngogon to lo naa, ");
INSERT INTO zpmNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","leḻ grë mdio ne bzaa to, mdio co bleynie to, lo mdio co pquiitsgzhib to. Mdio ne rnee to Moloc, zaatne zieetaa to tibaque ney to lidza, zhmel mdio ne rnee to Renfán, pa csaan to ma. Miṉcocxe waa, laa naa cuee to ladz to, gzonëz naa to guey to grë dan ne riaaṉ zitraa lo guiedz Babiloin. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Leṉ dze ne sca bio pxozgol ne grë dan bidz co, tib yu larse goc xyadoo zho, ga biotsow quie ne quia xley Dios. Dioszhal blu lo Moisés zha tsaa yu co. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Goc bla iza, zeeṉe blozh bnitlo Dios grë guiedz ne briṉ nu glo, laa Josué blansonieque yu co. Haxta leṉ dze ne goc David rey, bii lëëw nac xyadoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","’David goc tib rey ne gocnziuu lo Dios, bleynie Dios me, dzigo gocladz me nzaa me tib yadoo nroob zaatne mbëzlo zho Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per brieelod nzaa mew, Salomónraa goc rey ne bzaaw. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nli laa yadoo co biaa, per teḻ Dios, meṉ nroob nac me, led yed me cuëz leṉ grë yu ne rzaa miech. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Zigne zhobneeque lo Xtiidz me, zeeṉe znu rëb me: Gbaa nac zaatne zoob naa, laa lo guidzliu nac zaatne rzo ni naa. ¿Zha nadieṉ nac yu ne naṉ to gzaa to cuëz naa? ¿Pa nadieṉ guiab to gzaa to zaatne gdziiladz naa? ");
INSERT INTO zpmNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Niacxe led naad bzaa gbaa?, ¿niacxe led naad bzaa guidzliu? ");
INSERT INTO zpmNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Goḻgona sca gaṉle ―rëb Xteb―, zigne beeṉaque grë pxozgol to ga padzeela, scadaaque goṉ quiayuṉ to niina. Miech nad, miech ntseeb zdoo nac to; ib ronde to miṉe rnee Espíritu Sant. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Teḻ pxozgol to, nëḻte goṉdze zho grë zha ne pxeeḻ Dios biadnee xtiidz me; haxta beet zho grë zha ne bzeet ne laa Dios cxeeḻ tib meṉ peet xtoḻd ne bzooblo me guiaad lo guidzliu. Ni niina ne laa Dios pxeeḻ meṉ co, scasaque beeṉ to, ptsidiḻ to me, bnabey to bgaa me beet to me. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tibaque squi quia to quiaguiits to Xley Dios; xanjlpaa me biaadsaṉa lo to, ni ruṉde to miṉe rnabeya. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Zeeṉe bin zho sca rëb Xteb, blëëye zho haxta rowye ro zho rwi zho lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Laa me, ne nacnie Espíritu Sant me, zeeṉe blis lo me bui me nëz gbaa, goṉ me lo guieḻndzon ne no Dios, goṉpaa me laa Jesús zo cue Dios nëz derech. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dzigo bnee me, rëb me: ―Raṉpaa naa niina goṉ nzhialse gbaa, laa meṉ ne pxeeḻ Dios biaad lo guidzliu ga, laa me zo cue Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Miṉe beeṉ zho ptse zho diag zho, ni nguiedz roptsie zho parne gondraa zho pe rnee me; laa zho wbigbe bnaaz zho me, güeynie zho me tib lad ro guiedz. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Zha ne goc textigw ga, blee zho lar ne mbix zho, bdziiṉ zhow tib lo mgui nguieg lë Saul, mgui co pquianapa; laa zho psilo bdeedquie me. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sca nodeedquie zho me, laa me rnab lo Dios rnee me: ―Jesús, luu ne nac luu meṉ ne rnabey, luu pcaania zhiespíritu naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dzigo pquiitsgzhib me, ni pquiaa me stib redz nroob bnab me lo Dios, rëb me: ―Dios, luu ne nac luu meṉ ne rnabey, doḻ ne quiayuṉ miech rii, laa naa rnab lo luu guṉquizhd luu zhow. Loxaque blozh sca bnee me, laa me gut. Ye mgui ne lë Saul ga, bdeed diidz sca beet zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Dzigo pcaalsase bla zha bgui ne noxco rleynie Dios, güey zho güeyqueets zho Xteb; mban rac zho, bio zho xquieḻnë me. Leṉ dze co, psilo zha ne sca rlëënie zha ne rliladz Jesús, ptsidiḻ zho grëse zha ne rliladz me; dipse leṉ guiedz Jerusalén pquianaḻ zho zho. Grëse zho bzhooṉ, zha ne zie grëraa guiedz ne ndxie nëz Judé ga, zha ne zieegaa nëz Samar; loxaque zha ne nacse poxtl biaaṉ Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ntseeb rac Saul, rzac me tebaa zha gnitlogazh me grëse zha ne rliladz Jesús. Stib yu stib yu zie me, riebezhoo me zho lidz zho, mgui wnaasaque rey me riesëëb me zho ladzguiib. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Laa grë zha ne bzhooṉ Jerusalén ga, zaatne zieetaa zho rnee zho Xtiidz Jesús lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Zig nac Lip, zeeṉe bdziṉ me tib guiedz nëz Samar, psilo me bnee me Xtiidz Jesús lo grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ndal zho rquiaadiag miṉe rnee me, rzee zdoo zho raṉ zho grëtaa milagr ne ruṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ndal grë zha ne noguitnie meṉdox, riac zho, rquiaadan grë meṉdox co redz zeeṉe laa ma rzhooṉ; grë zha ne gutoo, grë zha ne nde ni, ruṉguiac me zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Grëse miech ne no guiedz co, rley zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Ga no tib meṉ ne rooḻ diidz dox, lë Simón. Ye me rzee zdoo miech grë ncuaaṉe ruṉ me. Nzianle iz sca noquidie me zho, grëse meṉguiedz ruṉbey me, haxta niats rac me rnee me guieṉdraa cho zig me. Grëse zho, haxta grë zha non rbig lo me, rzac zho lëë poder ne rap Dios ga nacnie me. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Laa zeeṉe bnee Lip lo grë miech co gocnaṉ zho diidz ndzon ne nac Xtiidz Dios, bin zho zha racladz Dios gban zho, bin zho cho nac Jesús; grëse zha ne bliladza, mgui wnaasaque, laa zho brobnis. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Dzigo yeque meṉ ne lë Simón ga bliladz Jesús, ye me laa me brobnis; zaatne zieetaa Lip naḻ me zhits Lip, rzee zdoo me raṉ me grëtaa milagr nroob ne ruṉ Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Grë zha poxtl ne no Jerusalén, zeeṉe gocnaṉ zho scataa ndal zha Samar nocaania zhiwseed Jesús, dzigo pxeeḻ zho Pedr grop Juan zie nëz co. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Laa zho zie gnab zho lo Dios ygaa grë zha ne bliladzle Jesús ga guieḻbiini cheṉ Espíritu Sant; ");
INSERT INTO zpmNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","sac zeeṉe bliladz zho Jesús, loxaque brobnisse zho, gard ygaa zho guieḻbiini co. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Bdziṉ zho pxobnia zho guic grë meṉ co, bnab zho lo Dios; dzigo grëse meṉ co laa me bgaa guieḻbiini ne rdeed Espíritu Sant. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Zeeṉe goṉ meṉ ne lë Simón ga, ne loxaque rxobniase zha poxtl co guic grë miech co laa zho rgaa guieḻbiini ne rdeed Espíritu Sant, dzigo laa me rdeed dimi, ");
INSERT INTO zpmNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","rëb me: ―Goḻneedz poder qui lo naa; zeeṉa ye naa zha ne cxobniataa naa guic ygaa zho guieḻbiini ne rdeed Espíritu Sant. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pquiab Pedr rëb Pedr lo me: ―¡Bieṉ gaṉle pe rnee luu! ¿Pa bin luu ye xpoder Dios zac si miech? ¡Tebaa niinagazh nitlo luu grë xtimi luu i! ");
INSERT INTO zpmNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ni lalnu rieguiaḻd luu guṉ luu dziin rii, ni gdziṉdgaa dze guṉ luuw; sac mbed zdoo luu, zienied guic luu guṉ luu miṉe rnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Blee zhgab yozh qui guic luu, bnab lo Dios zeeṉa togo squia zdoo me luu, guṉquizhd me luu doḻ ne squi bza zdoo luu i; ");
INSERT INTO zpmNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","sac rlu niapse guieḻntseeb nonie guic luu, ni lëëque luu goṉ nosacsi luu ne squitaa noyuṉctal luu xtoḻ luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pquiabse me rëb me: ―Goḻguṉ guieḻnzaac, goḻnab lo Dios yquia zdoo me naa, zeeṉa ygaad naa grë guieḻnëdox ne rnee to i. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Blozhse bzodiidznie Juan grë miech co grop me Pedr, blozhse pseed zho zho Xtiidz Dios, laa zho wbire zey zho Jerusalén stib. Guiedz ne rdedtaa zho dib xtan zha Samar ga, rnee zho Xtiidz Dios lo grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Laa Lip no Samar ga, tib dze brieequia tib xanjl Dios lo Lip, rëb me tsie Lip nëz ne rriee Jerusalén zie nëz Gaza. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Dzigo güey Lip nëz co. Tib dan ngana, lëëtaque laa tib meṉ ne nac dziin lo rein ne lë Candás zie ga, dziin nroob nac me lo rein co, sac me ngotsow grëtaa dimi ne no Etiopí. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Zobse me tib leṉ carret nroob zie me ga; znu wbirele me Jerusalén güeygaṉ me Dios. Laa me zob leeṉ co quialab me lo Xtiidz Dios miṉe pquiaa Isá, meṉ ne biadteed xtiidz Dios padzeela. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dzigo bnabey Espíritu Sant Lip tsie Lip ygaa carret co lo Lip. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Zeeṉe bgaa carret co lo Lip, bin Lip pa lo nolab meṉ co; nacne rëbchaa Lip lo me: ―¿Pe rieṉ luu cho raquiet zaatne nolab luu i? ");
INSERT INTO zpmNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","―Rieṉd naaw ―rëb me―, rquiin tib zha ne gnë lo naa dieṉ zha naca. Dzigo bredz me Lip biep Lip leṉ carret co, güeysob Lip cue me. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Znu rnee zaatne nolab me ga: Zigne racse mëcwxiil yeeṉ zeeṉe rnaaz zho ma rut zho ma, scadaa ndooladz goc me, peet beeṉd me zeeṉe laa zho zienie me. Ni zigne roptsied ma zeeṉe rtsiib zho ma, scaque ni tib diidz ptsired me lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Niicle ne goṉ zho scataa ndooladz me, per psacsi zho me. ¡Pa lotaa bdziṉ guieḻntseeb ne beeṉ grë meṉladz me! Sac goṉ, ptiche zho xquieḻmban me lo guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dzigo rëbchaa meṉ co lo Lip: ―Bzhiguieḻ bnë lo naa dieṉ, cho nu znu rzeet Isá lo rii. ¿Pe me bded miṉ rii, te stib zhow ye? ");
INSERT INTO zpmNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dzigo rëb Lip lo me Jesús raquiet ga, ni bnee Lip grëraa miṉe nac zhiwseed Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Laa zho no nëz, tibaque zeeṉe bdziṉ zho tib lugar co no nis; rëbchaa me lo Lip: ―¡Bui gaṉle laa nis no nu! Mazd bzhiguieḻ pchoobnisgazh naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","―Zaca ―rëb Lip―, totsaque dib zdoo luu rliladz luu Jesús. ―Rliladz naa me ―rëb meṉ co―, rliladz naa ne nli Xpëëd Dios nac me. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dzigo bnabey me blëz carret co ga. Biet me leeṉ co grop me Lip bzëëb zho lo nis co, ga pchoobnis Lip me. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Blozhse ga, laa Espíritu Sant blis Lip goṉdraa me Lip; per rley me laa me bio nëz stib, laa me zie. ");
INSERT INTO zpmNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Zeeṉe laa Lip brieequia, laa Lip nole guiedz ne lë Azot. Ga psilo me zigse zie me, guiedz ne rdedtaa me rnee me Xtiidz Dios lo grë miech co. Sca bio me nëz, haxta bdziṉ me guiedz Cesarea. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Laa mgui ne lë Saul ga, per nli ntseeb rac me, tibaque ne laa guic me zienie gut me grëse zha ne rliladz Jesús. Güey me lo meṉ ne nac pxoz nroob, ");
INSERT INTO zpmNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","bdeed pxoz co ti xtiidz me guey lo grë zha ne zo lo xyadoo zho nëz Damasc, parne gacnie zho Saul gnaaz zho grëse zha ne rliladz Jesús; zha ne ygaataa niicle mguiw niicle wnaaw, gzobdoo zho zho tsiesaṉ zho ladzguiib Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Laa Saul bio nëz, laa Saul zie. Zhile gdziṉ me guiedz Damasc, tibaque zeeṉe brieequia ti biinidoo zhan gbaa biab zaatne zie me ga. Groḻtaa lo biinidoo co biaaṉ me, biabgazh me liu. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Liu nix me, bin me zëëb ti tsi meṉ co rnee lo me: ―Saul, Saul, ¿pe nacne quianaḻ luu naa? ");
INSERT INTO zpmNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","―Beeṉ guieḻnzaac ―rëb me―, bnë dieṉ cho luu. Dzigo pquiab meṉ co, rëb me: ―Naa nac Jesús meṉ ne squi quiatsidiḻ luu. Lëëque luu goṉ nosacsi luu i, rzac luu zigne rzac ngon ne rcaaṉni, ni lëëque lo guiib lots ne rtseb zho ma riecaaṉni ma. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Rdzieb Saul, rzhidz me lo dzeb co rëb me: ―Bzhiguieḻ bnë dieṉ, ¿pe racladz luu guṉ naa niina? Rëbchaa Jesús lo me: ―Guche i, güey Damasc, ga gnë zho gaṉle pe nac miṉe no guṉ luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Zha ne ziegza Saul ga per nli bdzieb zho, haxta ni gacdraa gnee zho; loxaque tsi meṉ co ron zho zëëb, per choot raṉd zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Laa Saul guche ga. Zeeṉe laa me pxal lo me gwi me raṉdraa me, ¡laa lo me pcowle! Zha ne ziegzale me ga bzheṉ nia me bdziṉ me Damasc. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tsoṉ dze sca brieelod niaṉ me, gzase dze co dowd me, niicle peet god me. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Guiedz Damasc ga, ga no ti mgui ne rliladz Jesús lë Ananí; dzigo goṉ me Jesús, bredz Jesús me. Pquiab me, ");
INSERT INTO zpmNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","dzigo rëbchaa Jesús lo me: ―Güey nëz ne lë Derech, zaatne nac lidz ti mgui lë Judas; ga bnabdiidz meṉ Tars ne lë Saul. Zeeṉe quiazodiidznie me naa, ");
INSERT INTO zpmNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","blu naa lo me laa tib zha lë Ananí bdziṉ rxobnia guic me, zeeṉa gbiire gaṉ me stib. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Pquiab Ananí rëb Ananí: ―¿Saul ye? Ziyon naa name zha nac grëtaa ncuaaṉe noyuṉ me Jerusalén, notsidiḻ me grë zha ne rliladz luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Haxta pxoz nroob ne rnabey bdeed diidzbey gnaaz me grëse zha ne no nëz rii. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","―Güey ―rëb Jesús lo Ananí―, sac laa naa bzooblole me, ib me tsie grë guiedz zit tsieseed me miech xtidz naa, me gneew lo grë zha rnabey, ni lo grëgaa zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na naa glu lo me gaṉle zha nac grë guieḻnë ne gaṉ me, zeeṉe laa me quiayuṉle xtsiṉ naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dzigoraa güey Ananí zaatne no Saul ga. Bdziṉ me, pxobnia me guic Saul, rëb me lo Saul: ―Saul, bina gaṉle bets, laa Jesús goṉ, meṉ ne rnabey, meṉ ne brieequia lo luu zeeṉe ziaad luu nëz ga, laa me pxeeḻ naa ziaḻ naa nu; zeeṉa gnab naa lo me guṉguiac me bziaalo luu, ni ycaania luu guieḻbiini ne rneedz Espíritu Sant. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Zigne sca bnee Ananí, laa lo Saul biacgazh; lega zigne nac xmed meḻ nac grë ncuaaṉ co briee lo me. Horcogazh laa me brobnis. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Blozh ga laa me dow stib, zhiga zhiga laa me wbire pcaa fuerz. Goc bla dze no Saul lo grë zha ne rliladz Jesús Damasc ga, dzigo briee me ");
INSERT INTO zpmNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","güey me grë yadoo win ne no ga, rnee me lo grë miech co cho nac Jesús, rnee me lo zho ne nli Xpëëd Dios nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Rzee zdoo grëse miech co raṉ zho sca rnee me, rneechaa zho: ―¿Led lëë meṉ qui ga name scataa ntseeb rac Jerusalén, notsidiḻ me grë zha ne rliladz Jesús? Conque nac diidz miṉ co ziaad me nu, ziadnaaz me zho tsiesaṉ me zho lo grë pxoz ne rnabey. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Per zigse zie dze, mazdraa rac Saul tibaque ne rnee me lo grë miech co, lëë meṉ ne zëëble diidz cxeeḻ Dios lo guidzliu ga, nac Jesús. Grë zha Israel ne no ga, rieṉdraa zho dieṉ pe gliladz zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Goc bla dze no me ga, laa grë zha Israel ne no ga blëë lo me; bnediidz zho rëb zho laa zho gut me. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dze guieel riesobnap zho gzaase zaatne rap biedz nroob ne ndze igo guiedz co nëz, riequiambëz zho ted me, gut zho me. Per gocnaṉ mew, ");
INSERT INTO zpmNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","nacne goḻ ti pcow liu pcaalsa grë zha ne bliladz miṉe bnee me, bloo zho me ti leṉ chicuid nroob, bzoob zho doow dzigo blit zho me cho biedz nroob ne sca ndze igo guiedz co. Sca bdeeda diidz briee me ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Zeeṉe bdziṉ Saul Jerusalén gocladz me ndziṉ me lo grë zha ne rliladz Jesús ga, per leḻ bdzieb zho zeeṉe goṉ zho me, sac rliladzd zho ne nli yele me bzëëb xnëz Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dzigo güeynie Bernabé me lo grë zha ne nac poxtl, bzodiidz Bernabé lo zho zha goṉ me Jesús zeeṉe no me nëz zie me Damasc, zha rëb Jesús lo me; ni zha bdziebd me bnee me lo grë miech cho nac Jesús, leṉ dze ne blëz me Damasc. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dzigoraa pcaania zho me. Laa zho gocgza me, zaatne zietaa zho zieseed zho miech, ib rdziebd me rnee me cho nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Brieequia bla zha Israel ne rnee xtiidz zha Gres bdiḻdiidznie zho me. Zhisaque goca, laa zho gocladz niut zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Zeeṉe gocnaṉ grë zha ne rliladz Jesús gaw, dzigo güeysaṉ zho me guiedz Cesarea; ga briee me laa me zie nëz Tars, zaatne nac ladz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Leṉ dze co, grëse miech ne no xnëz Jesús, zigtaa zha ne no Judé, zha ne no Galilé, zha ne nogaa Samar, nguieeḻ rac zho peet lo guieḻxtseeb nodraa zho; zigse zie dze rioguicraa zho zha nac Xtiidz Dios. Grëse zho rioxco zho mban zho zigne rnabey me, tibaque nacnie Espíritu Sant zho. Ni scagaa, zigse zie dze ndal grë miech ne rzëëbraa rcaania Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Leṉ ngbidz coque, zie ziaad Pedr rieted me lo grëse zha ne rliladz Jesús. Nacne güeyted me lo grë zha ne no Lida. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Guiedz co, beeṉbey me ti mgui lë Ené, gocle xon iz nix mgui co, ib gacd së me sac dipse me gutoo. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Dzigo rëbchaa Pedr lo me: ―¡Ené, niinagazh goṉ laa Jesús guṉguiac luu! Na zeeṉ guche i blis xta luu. Zigne sca bnee Pedr laa meṉ co biac, laa me guche ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Grëse meṉ Lida, grëse meṉ Sarón zeeṉe goṉ zho sca biac meṉ co, grëse zho bliladz Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Gaxaque Lida riaaṉ ti guiedz lë Jop. Jop ga no ti wnaa ne rliladz Jesús, lë Tabit (laa xtiidz zha Gres rnee zho me Dorc). Nquialadz me miech, grë zha ne guieṉd pe yquiin, ruṉ me xyudar zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lega nacle blanguidz me, laa me gut. Zha ne rliladz Jesús ga, laa zho noxco dieṉ zha ygueets me. Bgaz zho me, blozhse ga güeyxob zho me sti leṉ yu ne riaaṉ nëz glaa. Xco co no zho, ");
INSERT INTO zpmNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","zeeṉe bin zho laa Pedr no Lida. Pxeeḻaque zho chop zha bgui zienie diidz lo Pedr tsieniob Pedr Jop. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Zigne bdziṉnie zha co diidz, zienaḻgazh Pedr zhits zho. Bdziṉ zho lidz meṉ co, zolinëz güeynie zho Pedr zaatne zhoob me. Nzian grë wnaa viud ndxie ga, wbigbe zho lo Pedr, roon zho rlu zho grë lar ne bdib me. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Dzigo bnabey Pedr briee zho ley grëse zho, laa me biaaṉ ga, pquiitsgzhib me bnab me lo Dios. Blozhse ga wbig me lo ngutoo co, bnee me lo me rëb me: ―Guche i, Tabit. Zigne sca rëb Pedr laa lo ngutoo co bzhial, zeeṉe goṉ me laa Pedr zo ga, laa me bzobli. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bzheṉ Pedr nia me, bliso Pedr me, dzigo bredz Pedr grë zha ne rliladz Jesús ga, ni grë wnaa viud co; goṉ zho laa me brieebanle. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dipse lad guiedz co bzhoob diidz sca brieeban wnaa co; grë zha ne bina, ndal zho bliladz Jesús dib zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nzianlaa dze biaaṉ Pedr ga, blëz me lidz Simón ti meṉ ne rcuudz grë guid ma. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Guiedz Cesarea, ga no ti meṉ lë Cornel, rnabey me lo ti partid meṉguiib lë partid Italian. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Zigtaa mew, zigtaa grë meṉlidz mew, dib zdoo zho rliladz zho Dios, noxco zho mban zho zigne racladz Dios. Tibaque nonab zho lo Dios, ni nroob ncuaaṉe rgad zho lo grë zha ne guieṉd pe yquiin. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tib dze, bdzele dzew tibaque zeeṉe goṉ me laa ti xanjl Dios bdziṉ zaatne zo me, bredzlë anjl co me. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Dze rwi me lo anjl co, rdzieb me laa me pquiab. Dzigo rëbchaa anjl co lo me: ―Gocnaṉ gaṉle grëse miṉe rnab luu lo Dios ron mew, ni raṉ me grëtaa yudar ne squi quiayuṉ luu lo grë zha ne guieṉd pe yquiin. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gacxe waa, laa naa ziaḻnie diidz lo luu: pxeeḻ bla zha ne tsie guiedz Jop tsiexi zho ti meṉ ne lë Simón Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Gax zaatne nac ro nisdoo, ga no ti meṉ lëque Simón, rcuudz me grë guid ma; lidz meṉ co ga rbëz me; ga tsieguib zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Zeeṉe laa anjl co zey, dzigo bredz me chop zha ne quia dziin lidz me, ni bredz me ti zhaguiib ne nacgrë zhaguiib ne zopaa gax lo me; dib zdoo zhaguiib co rliladz zho Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Blozhse bzodiidz me lo gza zha co zha bzhaac me, dzigo laa me pxeeḻ zho ziexi zho Pedr Jop. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","10","Biini liu, zig rwe ngbidza gaxle Jop zie zho. Lëëtaaque hor co laa Pedr biep nëz glaa guic yu ne rbëz me ga. Rcaabedz me, dzigo laga noyaclo ncuaaṉe gow me laa me biep guic yu co ziezodiidznie me Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Dios nozodiidznie me, tibaque zeeṉe goṉ me laa ti lar nroob ziad-zëëb zhan gbaa, nzhidoo gzatap nëza laaw bdziṉ lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Grë lose ma no lo lar co, ga no ma ne rzë gza tap ni, no grë ma ne rzë zigne rzë meeḻ, ni no grë ma ne rsiibe. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Horco bin me ti tsi meṉ co, rëb lo me: ―Pedr, ma ne racladztaa luu gow luu zac gut luu ma. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pquiab me rëb me: ―¡Miṉ cogaa nagoṉ grieelod! Wlaltaa gard gow naa grë ma beed qui. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Rëbchaa meṉ co lo Pedr: ―Grë ncuaaṉe beeṉlayle Dios, nodne gnee luuw ncuaaṉ beed. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Blulo lar co tib, bluloquew stib, laa zeeṉe bioṉtaa goṉ mew dzigo laaw biire bzoquia nëz gbaa. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lëëtaaque laa Pedr no zhgab dieṉ pe nacne sca goṉ me lar co, laa zha ne pxeeḻ Cornel ga bdziṉ ro yu ne rbëz me ga, ");
INSERT INTO zpmNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","rnabdiidz zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Zhgab co no Pedr, zeeṉe rëb Espíritu Sant lo Pedr: ―Laa tsoṉ zha bgui goṉ ziaadguib luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Biet, bnee lo zho. Ib peet tsienied guic luu güeynaḻ zhits zho, sac naa bnabey ziaad-xi zho luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dzigo laa Pedr biet ga, bdziṉ me lo zha ne pxeeḻ Cornel ga, rëb me lo zho: ―Naa nac Simón Pedr. ¿Pe nac mandad ne ziaad to? ");
INSERT INTO zpmNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Pquiab zho rëb zho: ―Laa no ziaad xmandad Cornel, ti meṉ ne rnabey lo meṉguiib Cesarea. Laa me pxeeḻ no ziaad-xi no luu, sac ti xanjl Dios rëb lo me cxeeḻ me zha ne guiaad-xi luu tsie luu lidz me, tsienee luu lo me. Ti miech wen nac me, dib zdoo me rliladz me Dios, grëse zha Israel rleynie zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dzigo bredz Pedr zho bded zho nëz leṉ yu; ga biaaṉ zho wdze co. Biiniraa liu zienie zho me, ye palal zha Jop, zha ne rliladz Jesús zienaḻ zhits me. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Dze ne rac chop ngbidz briee zho Jop, laa zho bdziṉ Cesarea. Laa Cornel bredzle grë meṉlidz me, grë zha ne ndzieeldiidz me; ndal nac zha ne ndxienie me lidz me, quiambëz me Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Zeeṉe laa Pedr bdziṉ, briee me güeydzieelo me Pedr, pquiitsgzhib me lo Pedr naṉ me niuṉ me Pedr zigne riegaṉ me Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Dzigo bliso Pedr me, rëb Pedr lo me: ―¡Guso i, nodne yquiitsgzhib luu lo naa! Bieṉ gaṉle samiechaque luu nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Dzigo laa meṉguiib co guso ga. Nozodiidz zho laa zho bzëëb leṉ yu. Zeeṉe bdziṉ zho zaatne ndxie grë miech co, ");
INSERT INTO zpmNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","psilo Pedr bnee me lo zho, rëb me: ―Naṉle to gaṉle zha Israel naa, ni ib lo xley no rnabey nodne ziaab no lidz grë zha zit, per ni ctsieelsad no zho; per laa niina laa Dios blu lo naa, grëse miech ne beeṉlayle me nod pe nacne gbix zdoo naa gaṉ naa zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Gacxe waa, zigne gocnaṉ naa laa to rbedz naa, ziaḻnaḻgazh naa zhits zha ne pxeeḻ to. Nana sca, goḻnë dieṉ pe nacne bredz to naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Dzigo bzodiidz Cornel zha bzhaac me, rëb me: ―Nadze rac tap ngbidz ga, zig znaw goṉ, no naa lidz naa nu nocuan naa, ni nonab naa lo Dios. Tibaque zeeṉe goṉ naa laa ti mgui zole lo naa, masaque riaazbel xab me, ");
INSERT INTO zpmNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","në me: “Gocnaṉ gaṉle grëse miṉe rnab luu lo Dios ron mew, ni raṉ me grëtaa yudar ne squi quiayuṉ luu lo grë zha ne guieṉd pe yquiin. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Gacxe waa, laa naa ziaḻnie diidz lo luu: pxeeḻ bla zha ne tsie guiedz Jop tsiexi zho ti meṉ ne lë Simón Pedr. Gax zaatne nac ro nisdoo, ga no ti meṉ lëque Simón, rcuudz me grë guid ma; lidz meṉ co ga rbëz me; ga tsieguib zho me.” ");
INSERT INTO zpmNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Sca nagoṉ në meṉ co lo naa, nacne bnabey naa biaad-xi zho luu; ni xquizhgaa luu ne laa luu ziaad. Dios zobwi gaṉle, grëse no laa no ndxie nu par yquiaadiag no miṉe bnabey me luu gnë luu lo no. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dzigo rëbchaa Pedr: ―¡Naraa rieṉ naa, led yed Dios cue miech dieṉ cho nac zha Israel, cho nacgaa zha zit! ");
INSERT INTO zpmNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sinque grëse miech lo guidzliu, teḻ pa guiedztaa nac zho, rcaania me zho totsaque ron zho miṉe rnabey me, ni rioxco zho zaacse rban zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","37","Rgobey naa ziyonle to Diidz Ndzon ne pxeeḻ Dios lo meṉladz naa niina wriiṉ. Lo Diidz Ndzon co rnee, ne zac guiaaṉwen miech lo Dios, totsaque gliladz zho cho nac Jesús, meṉ ne zëëble diidz ga cxeeḻ me (ni Jesús goṉ bzaa grëtaa ncuaaṉe no). Zig nac dib Judé, desde ne psilo Juan pseed me miech Galilé, laa zho gocnaṉa. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ni naṉaxe to gaṉle, bdeed Dios poder lo Jesús, pxeeḻ me Espíritu Sant gocnie Jesús. Zaatne bdedtaa Jesús, pquia zdoo me miech, grë zha ne nosacsi meṉdox psilaa me zho ladznia ma; sacne nli Dios nacnie me. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","No ne nac no zha ne bzianie me, grop lo no bdziaṉ no grëtaa milagr ne beeṉ me, zigtaa Jerusaléna zigtagaa dib Judéw. Jerusalénpaa ga beet zho me pquiaa zho me lo cruz, ");
INSERT INTO zpmNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","per zeeṉe goc tsoṉ ngbidza laa Dios bleeban me, ni bneedz Dios diidz biire bdziaṉ no me. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Led grëdraa miech goṉ me, loxaque nose bdziaṉ me; sac ib Dios bzooblo no dziaṉ no grë dziin ne beeṉ me. Haxta bdioownie no me, bdionie no me, ");
INSERT INTO zpmNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ni pxeeḻ me no gnee no lo miech gacnaṉ zho gaṉle laa Dios bzo me, me guṉ guieḻwxtis gaḻ dze ne laa Dios cuedz grëse miech, zigtaa zha guta zigtagaa zha mbana. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Me ga bzeet grë zha ne biadteed Xtiidz Dios lo miech padzeela, zeeṉe rnee zho: “Grëse zha ne gliladz cho nac me, silaa Dios zho lo doḻ.” ");
INSERT INTO zpmNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Laa Pedr bii quianeeque, zeeṉe laa grë zha ne noquiaadiag ga bgaa guieḻbiini ne bdeed Espíritu Sant lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Grë zha Israel ne ziegza Pedr ga, zeeṉe goṉ zho laa grë zha co psilo quianee stib diidz, ni rdeed zho xquizh lo Dios, bzee zdoo zho goṉ zho ye grë meṉzit rgaa guieḻbiini ne rdeed Espíritu Sant. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Dzigo rëbchaa Pedr: ―¿Peraa nadieṉ gbiaaz ne, ne cchoobnisgazhd ne zha rii? Laa ne bdziaṉle gaṉle zigne rdeed Espíritu Sant guieḻbiini lo zha Israel, scaque bdeed me guieḻbiini lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Dzigo bnabey Pedr brobnis zho, laa zho bzëëb xnëz Jesús. Blozh ga bnee Cornel lo Pedr cuëz me ga ti bla dze. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Grë zha poxtl ne no Jerusalén, ni grëraa zha ne rliladzle Jesús zha ne no Judé, bin zho sca bliladz gza meṉzit co Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Dzigo zeeṉe laa Pedr bdziṉ Jerusalén güey bla zho güeytiḻdiidznie zho Pedr, ");
INSERT INTO zpmNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","blisqui zho lo Pedr pe nacne güey Pedr lidz meṉzit, pe nacne güeytownie Pedr zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dzigo psilo Pedr bzodiidz me lo zho zha nacne güey me lidz meṉ co, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Guiedz Jop no naa, tib dze lëëtaque nozodiidznie naa Dios, tibaque zeeṉe goṉ naa laa ti lar nroob ziad-zëëb zhan gbaa, nzhidoo gzatap squina laaw ziaad nëz lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Zeeṉe bdixlo naa bui naa dieṉ pe quia lo lar co, goṉ naa niapse ma no lo co, grë ma ntseeb, grë ma ne rzë gzatap ni, grë ma ne rzë zig rzë meeḻ, ni grë ma ne rsiibe. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Lo grë ma co nowi naa, zeeṉe bin naa ti tsi meṉ co, në lo naa: “Pedr, ma ne racladztaa luu gow luu, zac gut luu ma.” ");
INSERT INTO zpmNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Dzigo pquiab naa rep naa: “Miṉ cogaa nagoṉ grieelod, wlaltaa gard gow naa grë ma beed qui.” ");
INSERT INTO zpmNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nëchaa me lo naa: “Grë ncuaaṉe beeṉlayle Dios, nodne gnee luuw ncuaaṉ beed.” ");
INSERT INTO zpmNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","’Tsoṉ vuelt sca goṉ naa lar co. Blulow tib, bluloquew stib, zeeṉe bioṉtaa goṉ naaw dzigo laaw biire zey gbaa. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","’Loxaque blozh goṉ naa lar co, laa tsoṉ zha bgui blanso ro lidz meṉ ne blëz naa ga, pxeeḻ meṉ Cesarea co zho ziaadguib zho naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ni laa Espíritu Sant bneeque lo naa, no ganaḻ naa zhits zho, niicle ne zhazit nac zho; nacne bianaḻ naa. Ye gza xoop zha ne ziaḻnie naa nu bzë bio no. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","’Bdziṉ no lidz meṉ co, psilo me bzodiidz me lo no zha bzhaac me, në me leṉ yu no me, zeeṉe goṉ me ti xanjl Dios, rëb anjl co lo me cxeeḻ me bla zha ne tsie Jop tsiexi zho naa ");
INSERT INTO zpmNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","zeeṉa gane naa lo me zha grieelo csilaa Dios me lo doḻ grë meṉlidz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","’Laa naa psilo quiane lo me grë meṉlidz me, zeeṉe grëse zho laa zho pcaania Espíritu Sant, ni bgaa zho grë guieḻbiini ne rdeed me zigne bgaaque new. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ga nagoṉ psoladz naa xtiidz Jesús meṉ ne rnabey ne, zeeṉe znu në me lo ne: “Nli nisse pchoobnis Juan miech, saṉgue to zgaa to guieḻbiini ne rneedz Espíritu Sant.” ");
INSERT INTO zpmNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Sca nagoṉ pcaania zho Espíritu Sant, laa zho bgaa guieḻbiini ne rdeed me zigne bgaaque new. ¿Cho nac naa nadieṉ ne glisqui naa miṉe ruṉ Dios? ");
INSERT INTO zpmNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Zeeṉe blozh bin zho grë miṉe bnee Pedr ga, peet rëbdraa zho. Psilo zho rleynie zho Dios, rdeed zho xquizh lo me; sac hor coraa bieṉ zho ye grë meṉzit zrieelo gbig zho lo Dios, gdeed me ti guieḻmban ndzon ne gdziṉd dze lozh lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Zeeṉe sca pquianaḻ zho grë zha ne rliladz Jesús leṉ dze ne beet zho Xteb ga, nëzrii nëzrec bliaaḻ zho. No zho bdziṉ haxta Fenicia, no zho bdziṉ Chipr, nogaa zho bdziṉ nëz Antioquí. Zaatne bdziiṉtaa zho bnee zho cho nac Jesús, per loxaque lo grë meṉladz zho bnee zhow. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Niicle ne scaw, lëëque grë zha Israel ne no Chipr, zha ne no Ciren, zeeṉe laa zho bliladz Jesús güey zho guiedz Antioquí, bnee zho lo grë zha zit co cho nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ni ne nacnie Dios zho, ndal grë miech co bzëëb xnëz Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Grë zha ne no Jerusalén, zeeṉe gocnaṉ zhow pxeeḻaque zho Bernabé güey Antioquí. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Zeeṉe bdziṉ Bernabé Antioquí, rley me goṉ me scataa quiayuṉlay Dios grë miech co; dzigo pso me diidz lo zho ib csaand zho zhiwseed Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ti meṉ dib zdoo rliladz Dios nac Bernabé, nacnie Espíritu Sant me, ti miech wen nac me; gane zeeṉe laa me bdziṉ ga nzianraa zha ne bliladz Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Goc palal dzew, dzigo güey Bernabé guiedz Tars güeyxi me Saul, bdziṉnie me Saul Antioquí. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Dipse ti leṉ iz blëz zho ga grop zho, blozh pseed zho grë zha ne bliladz Jesús. Ga glopaa psilo ne laa grë zha ne rliladz Jesús brieelë CRISTIAN. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Leṉ iz co blalaa zha ne noteed xtiidz Dios no Jerusalén. Dzigo briee zho ga güey zho Antioquí. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Lad co no tib meṉ lë Agab, psiaab Espíritu Sant guic me bnee me laa ti gbin dox gaṉ miech nëz Israel. (Ni nligaa scase goca, lëë gbin co biaad leṉ iz ne zobnabey meṉ ne lë Claud.) ");
INSERT INTO zpmNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Grë zha ne rliladz Jesús Antioquí, zeeṉe bin zho sca rëb Agab, nacne bnediidz zho grë zho, teḻ palaltaa ncuaaṉe rgaa lo zho tib tib zho gdeed zhow gaclo ti gon cxeeḻ zho lo zha Judé. ");
INSERT INTO zpmNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Dzigo ptop zho gon co, zeeṉe laaw goclo, pxeeḻ zho Bernabé grop Saul güeysaṉa lo grë zha rnabey ne zo lo zha ne rliladz Jesús nëz Judé. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Leṉ dze co psilo rey Herod notsidiḻ me grë zha ne rliladz Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Bnabey me bgaa Jacob bets Juan, beet zho Jacob lo spad. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Zeeṉe goṉ Herod rley grë zha ne rnabey lo meṉguiedz Israel raṉ zho zha rsacsi me grë zha ne no xnëz Jesús ga, dzigo bnabeyaque me bgaa Pedr bio Pedr ladzguiib; lëëtaque leṉ dze co noyac lni Pascw. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Laa Pedr no ladzguiib, bnabey me bzo xon nëz meṉguiib quianap Pedr. Quiambëz me tedse lni co, laa me cuee Pedr gaṉ grë meṉguiedz zha csacsi me Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Grë zha ne rliladz Jesús, zeeṉe gocnaṉ zho scataa ndxienap meṉguiib Pedr no Pedr ladzguiib, psilo zho tibaque quianab zho lo Dios gacnieṉ me Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nacle diidz pa dze cuee Herod Pedr. Wdze ne guiini liu co, laa Pedr nixguiesse leṉ ladzguiib; tib ga caden zob ti nia me, tibga meṉguiib tib nëz cue me, ni zhaaque zo zla zha ne quianap ro ladzguiib. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tibaque zeeṉe biab ti biinidoo leṉ ladzguiib, laa ti xanjl Dios bdziṉ ga. Bdziṉ me, pcaaṉnia me cue Pedr, pcuaan me Pedr, rëb me: ―¡Na zeeṉ guche i! Zigne sca bnee anjl co, lega zhal caden ne zob nia Pedr ga bzhiala brieew nia Pedr; ");
INSERT INTO zpmNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","dzigo rëbchaa anjl co lo Pedr: ―¡Pxidoo leṉ luu, pquiaa lab luu ni luu! Blozhse pxidoo Pedr leṉ Pedr, ni pquia lab Pedr; rëbchaa anjl co: ―¡Wbix xab luu na, zeeṉ dënaḻ zhits naa! ");
INSERT INTO zpmNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Naḻse Pedr zhits anjl co laa Pedr briee ga. Rieṉd Pedr ne nli nosilaa anjl co Pedr, masaque rzac me nonixquieeḻ mew. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bded zho chop leṉ yu zaatne ndxie meṉguiib ne quianap, laa zho bdziṉ zaatne quia puert guiib ne rriee ro nëz. Zigne bdziṉ zho, zhal puert co bzhiala; laa zho briee. Bzënie anjl co Pedr spalal, zeeṉe goḻ zho zaatne rdedlsa nëz co, dzigo laa anjl co psaṉ Pedr ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dzigoraa bieṉ Pedr led nonixquieeḻd Pedr, nli Dios pxeeḻ xanjl me güeysilaa Pedr ladznia Herod, zeeṉa gleyd zha Israel niaṉ zho grë guieḻnë ne nded Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Dzigo laa Pedr zie nëz lidz Marí, xniaa Juan Marcw; lëëtaque hor co nzian zho ndxie ga quianab zho lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Zeeṉe bdziṉ Pedr pcaaṉnia Pedr ro yu. Briee ti ndzoop ne quia dziin ga lë Rode, zieso ndzoop dieṉ chow. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Zeeṉe beeṉbey ndzoop co tsi Pedr, rley ndzoop. Lo guieḻbley co niicle pxaldaque ndzoop ro yu, rias ndzoop zienie ndzoop diidz lo grë zha ne ndxie ga; rëb ndzoop laa Pedr bdziṉ ro yu ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Per bliladzd zhow. ―¡Dieeṉ pe rooḻ luu! ―rëb zho―. ¡Ncuaaṉe gliladzd ne rnee luu! ―¡Coo, nli lëë mew! ―rnee ndzoop―, laa me zo ga. ―¡Led meda, ―rnee zho―, bod anjl ne quianap mew! ");
INSERT INTO zpmNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Sca no zho, laa Pedr bii nocaaṉnia ro yu. Zeeṉe güey zho pxal zho ro yu, bzee zdoo zho goṉ zho nli Pedra, laa Pedr zo ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Dzigo blunia Pedr lo zho gnee nguiedzd zho; laa zho bzëëbnie Pedr leṉ yu. Ga psilo Pedr bzodiidz Pedr lo zho zha güeybee xanjl Dios Pedr leṉ ladzguiib; ni pso Pedr diidz lo zho sodiidz zhow lo Jacob, ni lo grëraa zha ne nacgrë zho. Blozhse ga, laa Pedr briee ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Zeeṉe biini liu, grë meṉguiib ne pquianap Pedr leṉ ladzguiib ga, rdzieldraa zho zha guṉ zho; sac ib bieṉd zho dieṉ yo Pedr. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Zeeṉe laa Herod pxeeḻ zha ne ziebee Pedr ladzguiib, pa sële Pedr. Dzigo güey zho güeynie zho diidz lo Herod; nacne bnabey Herod gocredz grë zha ne pquianap Pedr ga, pquiep Herod zho; blozhse ga, bnabey Herod gut zho gzase zho. Bded ga, laa Herod briee Judé zey me Cesarea. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Leṉ dze co, pcaalsa meṉguiedz Tir ni meṉguiedz Sidón güeynee zho lo Herod; sacne rlëënie Herod zho. Lëëque ti meṉ ne nac dziin lo Herod lë Blast güeynie zho bnee lo Herod, bnab zho tiḻniedraa me zho, niicle zhagaaw laa zho gbig lo me; sac grëse ncuaaṉe rquiin zho, grë guiedz ne rnabey me ga rrieew. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Dzigo bzo Herod ti dze ne tsie zho tsiezodiidznie zho me. Zeeṉe goḻ dze co, got me lar niazh ne racw rey; bdziṉ me bzob me lo zhixcan me, psilo me bnee me lo grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Goc palo quianee me, psilo zho rleynie zho me, nguiedz roptsie zho rnee zho: ―¡Led miechdraa i goṉ! ¡Ti diosle i nac meṉ qui quianee lo ne! ");
INSERT INTO zpmNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Laa me bii quianeeque, zeeṉe biet tib xanjl Dios bdiṉ me, psilo dow mziog me, gagazh gut me. Sca gut me, sac beeṉbeyd me ne Dios nac meṉ ne non, meṉ ne rnabey. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Laa Xtiidz Dios, zigse zie dze laaw quiagaazraa lo miech; ndal zha cub ne nozëëb xnëz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jerusalén ga no Bernabé grop Saul leṉ dze co; zeeṉe biaḻse xtsiiṉ zho, laa zho brieeque ga laa zho zie nëz Antioquí zienie zho Juan Marcw. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lo grë zha ne rliladz Jesús Antioquí, nzian zha ne noteed Xtiidz Dios, nzian zha ne rseed miech Xtiidz Dios no lo zho. Lad grë zha co no Bernabé, no ti mgui lë Simón ne rnee zho “Meṉ Yaas”, no ti meṉ Ciren lë Lus, gaque no Saul, ni ti meṉ lë Manaén, bets pchoob Herod. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Laa ti dze lëëtaque ndxie zho noyooḻnie zho Dios ni nocuan zho, zeeṉe laa Espíritu Sant bnee lo zho, rëb me: ―Goḻcueextso Bernabé i grop Saul, zeeṉa csilo zho lo dziin ne gded naa guṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Blozhse pcuan zho, blozhse bzodiidznie zho Dios, dzigo pxobnia zho guic Bernabé grop Saul, bnab zho lo Dios gacnieṉ me zho; bnee zho lo zho, laa zho zie. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ga briee Bernabé grop Saul zienie Espíritu Sant zho bdziṉ zho guiedz Seleucia, Seleucia bzëëb zho barcw laa zho zie nëz Chipr (ti guidzliu win ne no lo nisdoo). ");
INSERT INTO zpmNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ye Juan Marcw zienie zho guṉ xyudar zho. Bdziṉ zho ro guidzliu win co zaatne ndxie guiedz Salamin, biet zho barcw güey zho grë leṉ xyadoo meṉ Israel ne no ga, güeyseed zho miech Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ga briee zho güeyted zho dipse lo guidzliu co bdziṉ zho guiedz Pafos; guiedz ne bdedtaa zho bnee zho Xtiidz Dios lo miech. Pafos, ga beeṉbey zho ti meṉ Israel lë Barjesús (laa xtiidz zha Gres rnee zho me Elim). Rquidie me rnee me xtiidz Dios noteed me lo miech, per diidz dox rooḻ me. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Guiedz co ga no ti meṉ lë Sergio Paul, meṉ co zob rnabey guidzliu co; dzigo lo meṉ co ga no Barjesús. Ti meṉ nixbiini nac meṉ ne lë Sergio ga, no me liaadz gacnaṉ me zha nac Xtiidz Dios; dzigo bnabey me gocredz Bernabé grop Saul. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Zeeṉe bdziṉ zho psilo Barjesús quiaguib me dieṉ pe yquiaaqui yquiaadiagd meṉ rnabey co Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Dzigo buitipaque Pabl lo Barjesús (Pabl nac sti lë Saul), ni ne nacnie Espíritu Sant Pabl ");
INSERT INTO zpmNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","rëb Pabl lo me: ―¡Biche nu zhin meṉdox! Zhin meṉdox goṉ nac luu, squitaa noquidiee luu miech, notsidiḻ luu diidzli. ¿Zha rna dze ne csaan luu miṉe nac luu i, squi notsidiḻ luu Xtiidz Dios? ");
INSERT INTO zpmNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Goṉ gaṉle, ¡laa Dios csiaabzi luu, niinagazh laa lo luu ycow, ni spalal xbiini ngbidz gaṉdraa luu! Zigne sca rëb Pabl laa lo meṉ co pcow, nëzrii nëzrec zie me racladz me dieṉ cho gnaaz nia me. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Zeeṉe goṉ meṉ rnabey co sca pcow lo Barjesús, hor co bliladz me Xtiidz Dios, bzee zdoo me goṉ me scataa poder ne ziaadnie zhiwseed Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bded ga, laa Pabl gza Bernabé ni Juan bzëëb barcw stib, laa zho zie nëz xtan zha Panfil. Bdziṉ zho guiedz Perg laa zho briee leṉ barcw, ga ptso Juan lo zho, laa Juan zey nëz Jerusalén; ");
INSERT INTO zpmNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","laa zho bio nëz zie zho nëz xtan zha Pisid, bdziṉ zho sti guiedz lë Antioquí. Zeeṉe goḻ dze ne rdziiladz miech lo dziin, güey zho xyadoo zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Blozhse bded zha ne blab lo guits ne pquiaa Moisés, ni blab zho miṉe pquiaa grëraa zha ne biadteed xtiidz Dios padzeela, dzigo laa meṉ ne rnabey yadoo co bnee lo Pabl grop Bernabé, rëb me lo zho: ―Teḻne racladz to gnee to chop lan xtiidz to, zac gnee tow niina. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Dzigo guso Pabl, blunia me lo grë zha ne ndxie ga cuedze zho, rëb me lo zho: ―Grëse to ne ndxie to nu, zigtaa tow ne nac to meṉladz naa, zigtaa togaaw ne nac to zha stib guiedz zha ne noxco gban zigne rnabey Dios; goḻquiaadiag chop lan xtidz naa gaṉle gne naa lo to: ");
INSERT INTO zpmNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","’Dios ne rliladz no nac no meṉ Israel, ib me bzooblo grë pxozgol no laa zho bgab lo me. Me gocnieṉ zho zeeṉe bio zho ladz meṉ Egipt, ni me güeysilaa zho ga, blu me gaṉle ne nli meṉ nroob nac me. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dipse leṉ choo iz ne bio zho grë dan bidz ne bded zho ga, pxecw me grëtaa xquieḻntseeb zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Blozh ga, bnitlo me gadz guiedz nroob ne ndxie xtan zha Canaán, bdeed me liu co lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ni dipse leṉ tap gayoo groḻ iz, me bzooblo grë zha ne bzo bnabey lo zho; lëë lultm zha ne bzo me ga bnabey lo zho goc profet Samuel. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Blozh ga, laa zho bnab so ti rey gnabey lo zho, nacne bzo me Saúl, bzob Saúl choo iz goc me zhirey zho. Lëë pxoz Saúl ga brieelë Cis, meṉ ne ziaad lo xtii pxozgol no Benjamín. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Zeeṉe laa Dios ptiche dziin co lo Saúl, dzigo bzo me David goc rey. Lëë David ga rzeet Dios zaatne znu rnee: “Rleynie naa xingan Isaí zha ne lë David, laa naa goṉle ib zuṉ David miṉe gnabey naa.” ");
INSERT INTO zpmNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ni lo xtii David co nagoṉ brieequia Jesús, meṉ ne pxeeḻ Dios lo guidzliu biaadsilaa miech lo doḻ, zigne psaṉle me diidz lo xmeṉgol no padzeela. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","’Leṉ dze ne merle xoobneṉ cho nac Jesús, leṉ dze co bnee Juan Bautist lo grë meṉ Israel: csaan zho xquieḻntseeb zho gnab zho perdon lo Dios, zeeṉa chobnis zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Laa zeeṉe zhile gdziṉ dze ne gut zho Juan, dzigo bnee me lo miech rëb me: “Goḻgacnaṉ gaṉle, led naad nac meṉ ne quiambëz to ga cxeeḻ Dios. Merle guṉbey to me, ti meṉ non nac me, per ni par gac naa ti nguṉdziin win ne glit lab me ni me raguiaḻd naa.” ");
INSERT INTO zpmNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Goḻgacnaṉ sca gaṉle bets: zigtaa tow ne ziaad to lo xtii Abraham, zigtagaa tow ne nac to miech stib guiedz zha ne rliladzle Dios, ib laa Dios pxeeḻ Jesús csilaa me ne lo xtoḻ ne grëse ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Grë zha Jerusalén ni grë zha ne rnabey lo zho, ib bieṉd zho cho nac Jesús, niicle ne scataa gzobse dze ne rdziiladz zho lo dziin, rlab zho lo grë guits ne pquiaa zha ne biadteed xtiidz Dios padzeela; haxta bnab zho gut me zigne bneese grë zha co. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Niicle ne goṉ zho peet xtoḻd me, niicle ne brieequiad doḻ ne pquiaqui zho me, per bguib zho bdeeda diidz bnabey Pilat gut me. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","’Blozhse psacsi zho me, pteed zho me grëse zigne bzeetle grë zha ne biadteed xtiidz Dios ga, dzigo güey zha ne blit me lo cruz, güeyqueets zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Per bleeban Dios me. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Grë zha ne güeynaḻ zhits me zeeṉe briee me Galilé bdziṉ me Jerusalén, nzian zho goṉ me; ni niina grëse zho laa zho quianee lo miech gaṉle cho nac me. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Scaquegaa no grop no Bernabé, laa no ziaadnie diidz lo to gacnaṉ to gaṉle niina ne laa Dios bleeban Jesús, laa me beeṉ miṉe bnee me lo pxozgol ne padzeela. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Lëë Jesús ga raquiet lo Salm brop, zaatne rnee: “Xpëëd naa nac luu. Desde nadze laa zho guṉbey ne Xpëëd naa nac luu.” ");
INSERT INTO zpmNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ni bzeetle Dios ne laa me cueeban Jesús, bzeetle Dios xiṉd xcuerp me leṉ baa; miṉ co ga raquiet lo Xtiidz me, zaatne rnee: “Zuṉlay naa luu, zigne bnese naa lo David guṉ naa.” ");
INSERT INTO zpmNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Laa stib lo Salm ne pquiaa David rnee: “Gdeete luu diidz xiṉ xcuerp naa leṉ baa.” ");
INSERT INTO zpmNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Rlu led Davite raquiet ga, sac zeeṉe bza dze ne goc me dziin lo meṉladz me laa me gut, ni zaatne pqueets zho me, ga bnitlo xcuerp me. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Led meda, zhaa meṉ ne raquiet ga; gacxe na rneew waa peet gacd xcuerp meṉ co, zbeeban Dios me. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","’¡Grëse to bets, goḻgacnaṉ sca gaṉle! ¡Jesús nac meṉ ne rsilaa miech lo doḻ! Zha ne gliladztaa me dib zdoo zho, teḻ pe nactaa grë xtoḻ zho, saṉmbe me zho. Miṉe wlaltaa brieelod ngaa to, niicle ne zienaḻ to xley Moisés; sac niicle guṉ tow grëse zigne naca, csaṉmbeda to lo doḻ. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","’¡Goḻguieṉ sca gacnroladzde to! Zeeṉa ygaade to miṉe bzeet zha ne biadteed xtiidz Dios padzeela, zeeṉe znu bnee zho: ");
INSERT INTO zpmNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Grëse to ne rzhidznie to miṉe nac diidzli, bii zaṉ to gaṉle laa naa guṉ ti milagr nroob ne gzee zdoo to; per znitlo to, sac gliladzde tow niicle guiaad zha ne gzodiidza lo to. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Blozh bnee Pabl; laa zeeṉe laa Pabl griee ga grop Pabl Bernabé bnab grë miech co lo zho, siguieḻ zho guiet sti zhmal co biire tsie zho tsieseed zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Zeeṉe briee zho leṉ yadoo co, nzian grë zha Israel, nzian grë zha stib guiedz zha ne rliladzle Dios zienaḻ zhits zho. Nëz no zho bnee zho lo grë miech co tiblique tso guic zho tsienaḻ zho zhiwseed Dios, guieṉ zho gaṉle pa lotaa noxco me zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Biet sti zhmal co, miech guizhiu ne goclo leṉ yadoo co, zootle zig grëse miech guiedz co pcaalsa ga ziequiaadiag zho Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Zha ne rnabey lo grë zha Israel ne no ga, zeeṉe goṉ zho scataa ndal miech ne goclo ga, blëë zho lo Pabl, ndox zho lo me, rëb zho led diidzlid nac miṉe rseed me. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Niicle Pabla, niicle Bernabéw bdziebd zho, dzigole bnee zho lo zho rëb zho: ―Nli to glo rieguiaḻ yquiaadiag Xtiidz Dios ne nac to zha Israel. Per ne squi ruṉ to guieḻntseeb nëde to ycaania tow par ygaa to guieḻmban ndzon ne rneedz Dios; na laa no guioseed grë zhazit. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ni scalegaa rnabey Dios gaca, sac znu rnee me: Laa naa bzole luu tsienee luu Xtiidz naa lo grë meṉzit, luu gac zig ti biini ne gziini lo grë miech ne ndxie lo guidzliu; zeeṉa guieṉ zho zha laa zho lo doḻ. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Grë zha ne nac zhazit, zeeṉe bin zho sca rëb Pabl, per nli rley zho, rdeed zho xquizh lo Dios scataa ndzon nac Xtiidz me. Grëse zha ne nole ygaa guieḻmban ndzon ne gdeed Dios ga, grëse zho dze cogazh laa zho bliladz Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Dipse dan co, gocnaṉ miech Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Grë zha Israel ne rlëë lo Pabl ga, psilo zho pquiil zho grë meṉ wnaa ne nac diidz noxco Xtiidz Dios, ni güey zho güeynee zho lo grë zha ne nac meṉ non lad guiedz co; zeeṉa ctsidiḻ zho Pabl grop Bernabé, guṉcxooṉ zho zho dan co. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Zeeṉe bin Pabla grop Bernabé, par glu ne nonguieḻd sca beeṉ zha co zho, beeṉmbe zho grë yudie co ni zho laa zho briee ga, laa zho zie nëz Icon. ");
INSERT INTO zpmNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Grë zha ne bliladz Jesús ga, nguieeḻ rac zho, rdeed Espíritu Sant guieḻbiini lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Zeeṉe bdziṉ Pabl Icon grop me Bernabé, güey zho tib xyadoo zha Israel zob lad guiedz co, bnee zho Xtiidz Dios lo grë zha ne pcaalsa ga. Zigtaa zha Israela, zigtagaa zha lad guiedz cow, nzian zho bliladza. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Laa grë zha Israel ne bliladzda, psilo zho bloo zho diidz lo grëraa miech guiedz co glëënie zho Pabl grop Bernabé. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Niicle sca beeṉ grë zha co per wbid zho, bii blëz zho ga, peet dzeb nod lo zho rie zho rienee zho Xtiidz Dios lo miech; scagaa Dios, nzian grë milagr ne bdeed me diidz ruṉ zho par glu ne nli Xtiidz me nonee zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Dzigo grë miech ne no lad guiedz co goc zho chop dii, groḻ zho racnie grë zha Israel ne rlëë ga, zgroḻ zho racnie grop zha poxtl co. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Zha ne rlëë ga, zigtaa zha Israela zigtagaa zha guiedz cow, bnediidz zho grë zho wxtis laa zho tsie tsiedeedquie zho Pabl grop Bernabé. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Zeeṉe bin Pabla grop Bernabé, mazd laa zho briee ga, laa zho zie nëz xtan zha Licaon. (Güey zho Listr, güey zho Derb ni grëraa guiedz ne ndxie gax ga; güeynee zho lo grë miech co zha nac Xtiidz Dios.) ");
INSERT INTO zpmNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Guiedz Listr ga goṉ zho ti mgui në ni, wlaltaa lo xquieḻmban me ib gard së me; sac scale në ni me zeeṉe gol me. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Zeeṉe goṉ Pabl dze zob me rquiaadiag me miṉe nonee Pabl lo grë miech co, dzigo dzeque bui Pabl lo me, goṉ Pabl dib zdoo me rliladz me nli zrieelo guṉguiac Dios me; ");
INSERT INTO zpmNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","dzigo nguiedz bnee Pabl lo me, rëb Pabl: ―¡Beeṉnli ni luu, zeeṉa bzoli! Zigne sca bnee Pabl, znuse guso nguzhooṉ me, bzoli me laa me psilo bzë. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Zeeṉe goṉ grë miech co sca biac me, psilo zho con xtiidz zho nguiedz rnee zho: ―¡Diosle i goṉ, nasi zig rlu miech rlu me laa me biet gbaa ziaadgaṉ me ne! ");
INSERT INTO zpmNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","¡Masaque rzac zho lë xdios zho ga! Rnee zho Bernabé nac dios Júpiter, laa Pabl nac dios Mercur, sac Pabl nac zha ne ndziibraa rnee. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ro guiedz co ga zob xyadoo zhimdio zho Júpiter, dzigo briee pxoz ne no yadoo co grë me miech lad guiedz, zienie zho ngon, zienie zho guiee, naṉ zho gut zho ngon co cogon zho ma lo Pabl grop Bernabé. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Zeeṉe bieṉ Pabla grop Bernabé wbiṉladz guic zho. Ptsiez zho xab zho, bzëëb zho lad grë miech co, nguiedz rnee zho lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Ndzinli goḻgac! ¿Pe nacne squi rac to? ¡Goḻgaṉ gaṉle miech guidzliuque nac no, tibaque nac ne grë ne! Laa no ziaad lo to ziadseed no to wseed cub ne nac Xtiidz Dios, zeeṉa guieṉ to csaan to grë ncuaaṉe paat rquiind ne ruṉ to i, gbiire gbig to lo Dios meṉ ne nlipaa mban. Me bzaa gbaa, me psaṉ guidzliu, me psaṉ nisdoo, grëse ncuaaṉe no gbaaw, ncuaaṉe no lo guidzliuw, ncuaaṉe no lo nisdoow, me bzaaw grësew. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Niicle ne glo bdeed me diidz beeṉ miech grë ncuaaṉe gocladztaa zho, ");
INSERT INTO zpmNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","per psaanladzd me zho. Gocnie me zho zigne racnieque me ne niina, rsiaab me nisguie rac xcuaa ne, rneedz me ncuaaṉe rdioow ne gzataa dze, rneedz me guieḻbley lo ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Niicle sca rnee grop zha poxtl co, nen bin grë miech co diidz beete zho ngon co ngogon zho ma lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Leṉ dze co, blalaa zha Israel ne ziaad nëz Antioquí ni nëz Icon bdziṉ Listr ga. Psilo zho bloo zho diidz lo grë miech co gocntseeb zho lo Pabl; güey grë miech co bdeedquie zho Pabl. Masaque bzhaac zho gutle Pabl, bdobniu zho me güeyroṉ zho me tiblad ro guiedz. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Grë zha guiedz co zha ne rliladzle Jesús, zeeṉe bin zhow, güey zho zaatne nix me ga. Lëëtaaque ndxie zho lo me, zeeṉe laa me guche; ga guche me laa zho zeynie me nëz leṉ guiedz. Biini liu, pcaa me nëz grop me Bernabé laa zho zie nëz Derb. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bdziṉ zho Derb, psilo zho bnee zho Xtiidz Dios lo grë miech co; ndal grë zha ne bliladza. Blozh ga, laa zho wbi ga biire güeyted zho nëz Listr, güeyted zho Icon, ni güeyted zho Antioquí, ");
INSERT INTO zpmNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","güeynee zho lo grë zha ne rliladz Jesús ga, pchoobladz zho zdoo zho, pso zho diidz lo zho, niicle nroob guieḻnë ne noded zho per none tibaque gac guic zho tsienaḻ zho Xtiidz Dios; sac ible sca nzian ncuaaṉe ted zho laga gdziṉ dze ne gdziṉ zho zaatne rnabey Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tib tib guiedz co, bzose zho grë zha ne so gnabey lo grë zha ne rliladz Jesús ga; rlozhse rcuan zho grë zho zho ni rzodiidznie zho Dios, dzigo laa zho rsaṉ zha co ladznia me yquianap me zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nëz no Pabl grop Bernabé bded zho dib xtan zha Pisid, bzëëb zho xtan zha Panfil, bdziṉ zho guiedz Perg. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Blozhse bnee zho Xtiidz Dios lo grë miech co, dzigo laa zho briee ga, bdziṉ zho guiedz Atalia. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalia ga bzëëb zho barcw bdziṉ zho sti guiedz ne lë Antioquí, gataa laa zho psiaaḻ viaj co. Guiedz coque ga briee zho grop zho güey zho grë guiedz co güeynee zho Xtiidz Dios lo miech; zeeṉe sca bnab grë zha ne rliladzle Jesús ga lo Dios gacnieṉ me zho tsieguṉ zho xtsiiṉ me. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Zigne bdziṉ zho Antioquí ga, bnabey zho pcaalsa grëse zha ne rliladz Jesús, bzodiidz zho lo grë miech co grëse zha gocnieṉ Dios zho güeyguṉ zho xtsiiṉ me, ni zha rquia zdoo Dios zha ne nacd zha Israel rbedz me zho ye zho rzëëb xnëz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Xtselaa bio Pabl ga grop me Bernabé, blëz zho lo grë zha ne rliladz Jesús ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ga no Pabl grop Bernabé zeeṉe bdziṉ bla zha ne ziaad nëz Judé, psilo zho noseed zho grë zha ne rliladzle Jesús ga, rnee zho lo zho ib none tso zho bey zigne rnabey xley Moisés, niicle ne rliladzle zho Jesús; zeeṉa sca csilaa Dios zho lo xtoḻ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Zeeṉe goṉ Pabl sca noseed zha co miech, nacne bdiḻdiidznieque Pabl zho grop Pabl Bernabé. Dzigo mazd bnediidz grë zha ne rliladz Jesús ga, bzo zho zla zha ne gacgza Pabl grop Bernabé tsie zho Jerusalén tsienabdiidz zho lo zha poxtl ni lo grë zha ne rnabey lo zha ne no ga, dieṉ pe guiab zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nacne briee zho zie zho. Nëz no zho bded zho xtan zha Fenicia, xtan zha Samar; zaatne notaa zha ne rliladz Jesús, rzodiidz zho lo zho grëse zha nobedz Dios grë zha ne nacdraa zha Israel, rsaan zho grë zhiwseed xmeṉgol zho laa zho rliladz Jesús. Rley grë miech co ron zhow. Sca bio zho nëz, laa zho bdziṉ Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Zeeṉe bdziṉ zho Jerusalén, pcaalsa grë zha poxtl, grë zha ne rliladz Jesús ga, ni grë zha ne rnabey lo zho. Dzigo ga bzodiidz Pabl grop Bernabé grëse zha gocnie Dios zho, zeeṉe güeyted zho grë dan co güeynee zho Xtiidz me lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Miṉ co quianee zho zeeṉe guso bla zha ne glo goc farisé rëb zho, grë zha ne nacd zha Israel zeeṉe laa zho rliladz Jesús ib none tso zho bey, ni none guṉ zho grëse miṉe rnabey Xley Moisés. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Dzigo nacne bnabey grë zha poxtl co ni grë zha rnabey co, ycaalsa zho stib dieṉ zhapaa gaca, pe nonguieḻa tso grë zha zit bey co. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Zeeṉe pcaalsa zho, goc pa lo quianee zho zeeṉe guso Pedr rëb Pedr lo zho: ―Grëse to bets, goḻquiaadiag miṉe gne naa lo to nu gaṉle. Led rsoladz to, zeeṉe griiṉpaa psilo quiagaaz Xtiidz Jesús lo miech, ible Dios bzooblo naa pxeeḻ me naa gaseed naa grë zha ne nacdraa zha Israel gliladz zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ni megaa ne ruṉbey me zdoo tib tib miech, laa me blu gaṉle, niicle ne zha zit nac zho laa me pcaania zho; pxeeḻ me Espíritu Sant nacnie zho, zigne pxeeḻaque Espíritu Sant nacnie ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Gotsaa gwi ne gaṉle, led yed Dios rbe dieṉ cho nac zha Israel cho nacgaa zha zit; zigtaa zhaw, zigtagaa new, laa me pcaania ne porne dib zdoo ne bliladz ne me. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Zha nac dzigo ne racladz to gnabey to grë zha co guṉ zho grë miṉe nac xley ne? ¿Pe niacxe rieṉraa ne lo Dios dzigo? ¡Niicxe ne name, niicxe xmeṉgol ne brieelod niuṉa zigne naca! ");
INSERT INTO zpmNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Goḻguieṉ gaṉle, zigtaa zhaw zigtagaa new laa me csilaa ne lo doḻ grë ne, per nacda por ncuaaṉe rdziuuṉ ne; sinque laa me csilaa ne porne nquialadz me ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Zeeṉe blozh sca bnee Pedr, dzese biac zho grë zho; dzigo laa Pabl grop Bernabé psilo bzodiidz grëtaa milagr ne blu Dios lo grë meṉzit zaatne güeynee zho Xtiidz me lo grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Blozhse bnee grop zha co, laa Jacob gusoque rëb me: ―Grëse to bets, goḻquiaadiaggaa chop lan xtidz naa nagaṉle gne naa lo to. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Laa Pedr bzodiidzle lo ne gaṉle zha psilo bredz Dios grë zha zit, bzooblo me zho ye zho gac zha ne sëëb xnëz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ga nagoṉ goca zigne zhobneese lo Xtiidz me, miṉe pquiaa grë zha ne pxeeḻ me padzeela, rneew: ");
INSERT INTO zpmNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Tedse nu gaṉle, laa naa cuedz grëse miech ne ygab lo naa; grë zha xtii David zha ne bzozit, laa zho gbig stib. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Horco grëse zha zit, laa zho gon gaṉle cho nac naa, zeeṉa grieelo sëëb zho xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Znu nac xtiidz Dios, ni padzeelale bzeet me ne laa me guṉ miṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Miṉ co nagoṉ grë zha zit ne rliladzle Jesús, ib nonguieḻda ga gnabey ne zho guṉ zho miṉe nac xley ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Sinque mazd yquia tib diidz cxeeḻ ne lo zho gon zho, grë ma ne rut miech rgogon zho lo grë zhimdio zho, ib gowd zho bëël co; grë ma ne rxieed ren zeeṉe ret ma, gowd zho ma; ni niicle grëragaa ma ne gut zho, ib gowd zho xchen ma. Grë zha bgui, nodne tsonie zho wnaa ne nacd tsieel zho; niicle wnaagaaw, nodne tsonie zho mgui ne nacd tsieel zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Niicle mazd padzeelaw, tibaque quiayon miech guṉd zho miṉ co; sac desde hor co tib tib guiedz bzose Moisés tib zha ne gneew lo miech leṉ xyadoo zho, dze ne rdziiladz zho lo dziin. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Blozhse ga, dzigo biaaṉ zho diidz so chop zha ne tsie Antioquí tsienaḻ zhits Pabl grop Bernabé, tsiesaṉ zho ti diidz ne guey lo zha co. Nacne bzo zho Judas xingan Barsabás, ni bzo zho Silas; grop zha co, zha rieṉ nac zho lo grëraa zha ne rliladz Jesús ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pquia ti guits güey zho, rnee lo guits co: “Zigne nose no Jerusalén nu, zigtaa zha ne nac poxtla, zha ne rnabeya ni grëraa zha ne rliladz Jesús nuw, grë no laa no rquiaabdiuzh to grëse to bets ne nac to zha ne no guiedz Antioquí, ni grëraa guiedz ne ndxie nëz Siria i, ni nëz Cilis. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","’Niina ne gocndioṉ no laa bla zha ne nacgrë no nu biaad lo to i, biaadcots zho guic to dieṉ peraa no guṉ to. Gacnaṉ to gaṉle led nod pxeeḻ zho, ");
INSERT INTO zpmNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","27","gane niina bzodiidz no grë no bzo no Judas ni Silas ziaadnaḻ zhits Pabl grop Bernabé, laa zho ziaad i ziaadgaṉ zho to. Zha nziuu nac Pabl grop Bernabé lo no, sac goṉ rbeeladz zho xquieḻmban zho quiayuṉ zho xtsiiṉ Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","’Lo godiidz ne bdziuuṉ no, laa no bdziaṉle nonguieḻda ne dieṉ peraa gnabey no to guṉ to, ni niiclegaa Espíritu Sant scaque rnee me. Rquiind ne peraa guṉ to, lëëlew ga totsaque tsoxco to ");
INSERT INTO zpmNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","gowde to xpëël grë ma ne rgogon miech lo grë zhimdio zho; grë ma ne rxieed ren zeeṉe ret ma, gowde to ma; ni niicle gowdgaa to xchen grë ma ne gut to. Grë zha bgui, nodne tsonie zho wnaa ne nacd tsieel zho; niiclegaa wnaaw, nodne tsonie zho mgui ne nacd tsieel zho. Miṉ rii nagoṉ nac miṉe no tsoxco to. ’Guiaaṉnie Dios to sca.” ");
INSERT INTO zpmNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Gza tap zha co laa zho briee Jerusalén, laa zho zie nëz Antioquí. Zeeṉe bdziṉ zho ga, bnabey zho pcaalsa grëse zha ne rliladz Jesús, dzigo bdeed zho guits co lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Zeeṉe gocnaṉ grë zha co zha rnee low, rley zho sacne pchoobladza zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Blozhse ga, psilo Judas grop Silas pseed zho grë miech co Xtiidz Dios, zeeṉa dib zdooraa zho gnalo zho Dios; sac bdeed me guieḻbiini lo Judas grop Silas rteed zho xtiidz me lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Xtselaa blëz Silas ga grop Judas, laa zeeṉe goḻ dze ne laa zho griee gbiire zho nëz Jerusalén stib, iṉe güeyzonëz grë zha co zho, rdeed zho xquizh lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Laa zho nole nëz, tibaque zeeṉe rëb Silas laa Silas guiaaṉaque ga spalal dze. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Laa Pabl grop Bernabé ible laa zho biaaṉ ga beeṉ zho xyudar grë zha ne noseedle miech ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Goc palal dze no Pabl guiedz Antioquí ga grop me Bernabé, zeeṉe rëb me lo Bernabé laa zho gbiire tsie grë guiedz ne güeynee zho Xtiidz Dios lo miech ga, par gacnaṉ zho dieṉ yo grë zha co. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Dzigo gocladz Bernabé ye Juan Marcw nienie zho; ");
INSERT INTO zpmNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","per bzhiguieḻd Pabl, sac zeeṉe güeynie zho Juan glo, psaṉaque Juan zho guiedz Panfil, laa Juan biire zey Jerusalén, güeynaḻd Juan nlozh nsiaaḻ zho lo dziin co. ");
INSERT INTO zpmNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Miṉ co pquiaqui bneelsa Bernabé grop Pabl, nrooblaa güey lo xtiidz zho; nacne gataa laa zho ptso. Pcaa Bernabé nëz grop Bernabé Juan bzëëb zho barcw zie zho nëz lo guidzliu win ne no lo nisdoo lë Chipr; ");
INSERT INTO zpmNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","laa Pabl goc grop Silas. Blozhse bnab grë zha co lo Dios gacnieṉ me Pabl grop Silas, laa zho briee ga ");
INSERT INTO zpmNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","güeyted zho grë guiedz ne ndxie nëz xtan zha Siria, grë guiedz ne ndxie nëz Cilis, güeynee zho lo grë miech ne rliladz Jesús nëz co, güeychoobladz zho zdoo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Leṉ dze co güey Pabl grop Silas güeyted zho Derb ni güeyted zho Listr. Listr ga beeṉbey zho tib zha nguieg ne rliladzaque Jesús lë Timoté, ti meṉ Israel ne rliladzle Jesús nac xniaa me, laa pxoz me nac meṉ Gres. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Grëse zha Listr, zha Icon, zha ne rliladz Jesús tibaque rzeet zho Timoté rnee zho ti miech ndzinli nac me, nacne bnee Pabl lo me tsienaḻ me zhits Pabl. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ni ne nod me bey ne rio zha Israel sac led zha Israeld nac pxoz me, dzigo bloo Pabl me bey co, zeeṉa tsod pe glisqui grë zha Israel ne no nëz co. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Laa me zienaḻ zhits Pabl. Guiedz ne rdedtaa zho rnee zho lo grë zha ne rliladz Jesús ga, tsoxco zho guṉ zho grë miṉe pso zha poxtl ga diidz, grë zho zha rnabey ne no Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Zeeṉe ron grë zha cow, dib zdooraa zho rnalo zho Dios, zigse zie dze racnzianraa zha ne rliladz Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Blozh ga, tibbded zho xtan zha Frij ni xtan zha Galás, sac bdeete Espíritu Sant diidz nienee zho Xtiidz Dios lo miech grë guiedz ne ndxie nëz Asia ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Zeeṉe bdziṉ zho zaatne rsilo xtan zha Misia gocladz zho nie zho nëz xtan zha Bitin, scaque bdeete Espíritu Sant diidz nie zho nëz co. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Dzigo tibbded zho dib xtan Misia bdziṉ zho ti guiedz ne ndxie ro nisdoo lë Troas. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Guieel co blulo ti mgui Macedon lo Pabl, rnab me guṉ Pabl guieḻnzaac tsie Pabl nëz co, tsieguṉ Pabl xyudar grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nacne hor cogazh bzhixcuaa no, sac bieṉ no ible Dios racladz guio no nëz co guionee no Xtiidz me lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Dzigo briee no ga bziaab no ti leṉ barcw bdziṉ no ti lo guidzliu win ne no lo nisdoo lë Samotras. Biini liu briee no ga bdziṉ no Neápolis, ga bliaaz no wdze co. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Biini sti liu co briee no Neápolis bziani no bdziṉ no Filip. Lëë guiedz co riaaṉ zaatne rsilo xtan zha Macedon, niapse meṉ Roma no ga; nzianlaa ngbidz bliaaz no ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Laa tib dze ne rdziiladz miech lo dziin, briee no bio no tib lad ro guiedz co, gax ti ro guiubee, zaatne bdzion no rcaalsa zha ne rienab lo Dios. Bdziṉ no nzianlaa meṉ wnaa ndxie ga, dzigo psilo no bnee no lo zho cho nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lad co no ti wnaa Tiatir lë Lidia, rto me grë lar nizhnie nlaan miṉe nac lar niazh; ye me dib zdoo me rliladz me Dios. Laa me noquiaadiag miṉe nonee Pabl ga, zeeṉe psiaab Dios guic me bliladz mew. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Dzigo hor cogazh brobnis me grë meṉlidz me; blozh ga, bredz me no guiobiaaz no lidz me, nëchaa me lo no: ―Teḻne rzac to nli dib zdoo naa rleynie naa Dios, goḻtë sca cuëz to lidz naa. Rzoobguic me lo no, nacne biobiaazaque no lidz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Tib dze, lëëtaque zio no zaatne riozodiidznie no Dios, bdzieelo no ti ndzoop nguieg noguitnie meṉdox. Zëëb diidz grëse teḻ pe rnabdiidz miech lo ndzoop, rnee meṉdox cow; nroob dimi ne riab nia zha ne rnabey ndzoop. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Naḻ ndzoop zhits no, nguiedz roptsie ndzoop rnee ndzoop: ―¡Xtsiiṉ Dios ndzon ne zob gbaa goṉ noyuṉ gza mgui rii! ¡Laa zho ziadseed to zeeṉa gacnaṉ to zha csilaa Dios to lo xtoḻ to! ");
INSERT INTO zpmNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nzian dze zaatne rdzieeltaa no ndzoop tibaque sca rnee ndzoop. Zeeṉe bieedtaa guic Pabl, biireque me bnee me lo meṉdox ne noguitnie ndzoop ga, rëb me: ―Jesús nacnie naa, ni laa naa rnabey luu goṉ niinagazh psaan ndzoop qui. Zigne sca rëb Pabl laa meṉdox co bzhooṉ. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Gza zha ne rnabey ndzoop ga, zeeṉe goṉ zho ruṉdraa ndzoop guieḻnsin co gdziniaa ndzoop dimi, bnaazaque zho Pabl grop Silas güeyzo zho zho lo wxtis, rëb zho: ");
INSERT INTO zpmNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","―¡Goḻwi gaṉle pe nac ncuaaṉe noyuṉ grop zha Israel rii lad guiedz nu! ¡Nogodiḻ zho miech, laa zho quiaseed miech ncuaaṉe nonguieḻdraa dziuuṉ ne nac ne zha Roma! ");
INSERT INTO zpmNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Pcaalsa grëse miech co, grëse zho ntseeb rac zho lo Pabl grop Silas. Dzigo bnabey wxtis co briee xab zho grop zho bdeed bar zho zho, nroob bdiṉ zho zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Blozhse bdiṉ zho zho laa zho psëëb zho ladzguiib, bnabey zho meṉ ne quianap ladzguiib ga tibaque yquianap me zho, sac teḻ laa zho xooṉ me tsietizha. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Zeeṉe bin meṉ co sca rëb zho, güeyaque me güeysëëb me zho stib leṉa miṉe riaaṉ caaṉraa, ga psëëb me ni zho lad chop lë yag nroob. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Wdze co, zig groḻ guieela laa Pabl grop Silas bii noyooḻnie Dios, ni rnab zho lo me gacnieṉ me zho. Grëse zha ne no ladzguiib ga, ron zho sca no Pabl grop Silas. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tibaque zeeṉe bni ti zhodox, psiniw dib nacse ladzguiib co, grëse ro ladzguiib co bzhial, guiib ne no nia grë zha ne no ga, wbiḻa. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Lëëlëd briee mcaaḻlo meṉ ne quianap ga, zeeṉe goṉ me grëse ro ladzguiib co zonial, masaque güeynie guic me bzhooṉle grë zha ne no ga, bdobaque me spad ne ney me laa me zie gut me me. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Horco broptsie Pabl lo me, rëb Pabl: ―¡Gute luu luu! ¡Grë no ndxie no, choot bzhiooṉd! ");
INSERT INTO zpmNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Lëëlëd bnab me biini, bzëëb nguzhooṉ me leṉ ladzguiib, masaque rzhidz me dzeb pquiitsgzhib me lo Pabl grop Silas. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Blee me zho ga, rëb me lo zho: ―Goḻnë lo naa, ¿pe nac miṉe guṉ naa zeeṉa csilaa Dios naa lo grëtaa xtoḻ naa? ");
INSERT INTO zpmNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","―Dib zdoo luu bliladz Jesús, meṉ rnabey ne pxeeḻ Dios lo guidzliu ―rëb zho―, dzigo silaa me luu lo doḻ, silaa me meṉlidz luu ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Dzigo güeynie me zho lidz me, bnee zho Xtiidz Dios lo me grë meṉlidz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Guieel co no me bdiib me zhits zho, zaatne brëë bar ne bloobar zho zho; blozhse ga, laa me brobnis grë meṉlidz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Bnabey me goclo ti guieḻwagw downie me zho, rley me, niicle grëgaa meṉlidz mew rley zho ne laa zho bliladz Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Biini liu, pxeeḻ wxtis zha ne güeynie diidz lo me cuee me Pabl ladzguiib grop Pabl Silas. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Dzigo güey me güeynee me lo Pabl rëb me: ―Laa wxtis pxeeḻ diidz cuee naa to ladzguiib; zacle nasca griee to, peet tsieniedraa guic to. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Dzigo rëbchaa Pabl lo zha ne bdziṉnie diidz ga: ―¡Zha ndzielguictaa zhiwxtis to goṉ! Squi ndxie meṉguiedz bdiṉ zho no, ni gardle gacnaṉ zho dieṉ pe nli no pe falt ne rdziaap no. Bnabey zho bio no ladzguiib, ni zha Roma nac no; nana racladz zho zhliaanse griee no. ¡Lëda ga goṉ! ¡Goḻtsie goḻguiab lo zho, lëëzhal zho guiaad guiadbee zho no nu! ");
INSERT INTO zpmNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Dzigo güey zha co güeynie zho diidz lo wxtis. Zeeṉe bin wxtis zha Roma nac Pabl, bdzieb zho; ");
INSERT INTO zpmNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","lëëlëd güey zho ro ladzguiib güeynab zho dispensar lo Pabl grop Silas. Blee zho zho ladzguiib, ni bnab zho lo zho siguieḻ zho mazd gbi zho guiedz co. ");
INSERT INTO zpmNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ga briee zho güey zho lidz wnaa ne lë Lidia ga, bnee zho lo grë zha ne pcaalsa ga, zha ne rliladz Jesús, pso zho diidz lo zho tiblique gac zho tsienaḻ zho xtiidz me. Blozhse ga, dzigo laa zho briee guiedz co. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Briee Pabl guiedz Filip grop me Silas, güey zho güeyted zho guiedz Anfípolis ni guiedz Apolonia, bdziṉ zho guiedz Tesalónica. Lad guiedz co zob ti xyadoo zha Israel, ");
INSERT INTO zpmNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","dzigo güey Pabl güeynee me Xtiidz Dios lo grë zha ne rcaalsa ga, zigne ruṉaque me grëraa guiedz ne zieded me. Blëz zho ga tsoṉ zhmal, gzobse dze ne rdziiladz miech lo dziin güey Pabl güeyzodiidznie Pabl grë zha co, ");
INSERT INTO zpmNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","bzeet me lo zho grë zaatne raquiet grëtaa ncuaaṉe ted meṉ ne cxeeḻ Dios lo guidzliu ga, ni zha grieeban me; ni blu me lo zho gacnaṉ zho gaṉle lëë meṉ co ga nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","5","Ndal zha ne pquiaadiag xcodiidz Pabl, bieṉ zho ne nli sca naca, laa zho bliladz Jesús, ndal zho nac zha nëz Gres, zha ne noxcole miṉe rnabey Dios, ye blalaa meṉ wnaa ne nac meṉ non lad guiedz co. Laa zha Israel ne rnabey yadoo co, zeeṉe goṉ zho scataa ndal zha ne bliladz Jesús, blëë zho; güey zho güeytop zho grë zha yozh ne quianzë lad guiedz co, ti ruid ne beeṉ zho lad guiedz. Güey zho güeysëëb zho lidz Jasón naṉ zho niebee zho Pabl ga grop Silas, ngo zho zho ladznia grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Zeeṉe goṉ zho bgaad grop zha co lo zho, bnaazaque zho Jasón ni zla zha ne rliladz Jesús, bdobniu zho zho bdziṉnie zho zho lo wxtis, roptsie zho rnee zho: ―¡Goḻgaṉ gaṉle laa zha ne sca quianzë nocots guic grë miech, laa zho blansole nu! ");
INSERT INTO zpmNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ni Jasónpaa rdeed zaatne rbëz zho. Racladzdraa zho guṉ zho miṉe rnabey rey César, sac rnee zho no sti zhirey zho lë Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Grë zha wxtis co ni grë meṉguiedz ne pcaalsa ga, zeeṉe bin zho sca rnee grë zha co, rieṉdraa zho zha guṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Miṉe beeṉ zho beeṉquizh zho Jasón ti mult gza Jasón zla zha co, dzigo laa zho wbi ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pcow liu co, wxiṉa laa grë zha ne rliladz Jesús ga bleese Pabl ga grop me Silas, pxeeḻ zho zho nëz Beré. Zigne bdziṉ zho Beré, gloque ti xyadoo zha Israel güey zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","12","Grë zha Israel ne no Beré ga, rley zho rquiaadiag zho miṉe rnee Pabl grop Silas, gzobse dze rlab zho lo Xtiidz Dios rwi zho dieṉ pe nli miṉe rnee zho ga. Ndal zha Israel co bliladz Jesús, ndal zha Gres ne, zigtaa mguiw zigtaa wnaaw; blalaa meṉ wnaa co zha non nac zho guiedz co. Tibliladz nac grë miech co, gocntseebd zho zigne gocntseeb zha Tesalónica. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Laa zeeṉe gocnaṉ zha Israel ne no Tesalónica laa Pabl nolaque guiedz Beré, güeyaque zho güeyquiil zho grë miech co glëënie zho Pabl. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","15","Dzigo lëëlëd briee bla zha ne rliladz Jesús ga, zienie zho Pabl nëz ro nis; laa Silas grop Timoté biaaṉ ga. Güey zha co güeysaṉ zho Pabl guiedz Aten; laa zeeṉe laa zho wbi, pxeeḻ Pabl diidz lo Silas grop Timoté tsieniob zho Aten. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Laga quiambëz Pabl gdziṉ Silas grop Timoté güey me güeyted me lad guiedz co, wbiṉladz guic me goṉ me led zhid grë mdio ne riegaṉ grë miech co. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nacne bioxco me bnee me Xtiidz Dios lo zho, güey me xyadoo grë zha Israel ne no ga, bzodiidznie me zho grë zho zha guiedz co zha ne rliladzle Dios. Gzobse dze rie me leṉ guiedz rienee me lo grë miech ne rdziṉ ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tib dze bdzieelo me bla zha rac ne zienaḻ zhiwseed ti meṉ lë Epicur, ni zla zha ne zienaḻ wseed ne rnee zho estoic; psilo me bzeet me Jesús lo zho, bnee me zha brieeban Jesús. Zeeṉe bin zho zha rnee me, no bla zho rzhidznie me, rnee zho: ―¡Dieeṉ pe riab guic meṉ qui rnee me, ziaadquidie me miech! Zlagaa zho rnee, nend cho zhiwseed sti Dios ne rliladz miech stib dan zienie Pabl, gane sca rnee Pabl; ");
INSERT INTO zpmNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","dzigo rëb zho lo Pabl: ―Bzhiguieḻ mazd, së luu guio ne lozh sodiidz luu lo no dieṉ zha nac wseed ne ziaadnie luu, ");
INSERT INTO zpmNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","sac wlaltaa gard dzion no grë ncuaaṉe rnee luu i. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","No zho liaadz gacnaṉ zho pe rnee Pabl, sac sca nac grë zha Aten, niiclegaa grë zha ne quiadziṉ ga, rdziladz zho rded-dze zho rzodiidz zho dieṉ zha nac grë diidz cub ne griiṉ ron zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bdziṉ zho ti guic gui win ne rnee zho Areópago, bzo Pabl glowtaa zaatne rcaalsa zho ga, bnee me lo zho rëb me: ―Grëse to ne nac to meṉ Aten, raṉ naa ne nligaa rioxco to rleynie to grë meṉ ne rzac to nac Dios; ");
INSERT INTO zpmNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","sac leṉ dze rii biateed naa zaatne zob grë xdios to, haxta no zaatne niaa ti lo pcoog quia chop lan diidz ne znu rnee: “MIṈ RII NIAA PAR DIOS NE RDZIUUṈBEYD NE.” Goḻgacnaṉ sca gaṉle, Dios ne ruṉbeyde to ga, ruṉbey naa me ni lëë zhiwseed me none naa lo miech leṉ dze rii. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Dios co bzaa guidzliu, me bzaa grëtaa ncuaaṉe no lo guidzliu; gacd ne guiab miech zha gzaa ti zaatne cuëz me, sac meṉ nroob meṉ rnabey nac me, me rnabey gbaa, me rnabey guidzliu. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Niicle rquiindgaa me dieṉ zha yquianap zho me, sac grëse ne ne nac ne miech, me rneedz guieḻmban lo ne, me rneedz grëtaa ncuaaṉe rquiin ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Lo tib nëzaque miech ne bzaa me ga, bnabey me brieequia grëse dii miech ne ndxie lo guidzliu niina, bdeedse me zaatne biaaṉ tib tib dii co ni dieṉ palal dze ne gban zho zaatne biaaṉ zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Laa me psaṉ zho parne yguib zho me, tsoxco zho guieṉ zho gaṉle zha nac me haxta gdziel me lo zho. Ni led zite ga zo me lo ne grë ne, ");
INSERT INTO zpmNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","sac goṉ, niapse por xpoder me laa xcuerp ne niaa zigne naca, laa ne mban, laa ne rrieḻ. Lëëw ga bnee bla meṉladz to, zha rac ne znu rëb: “Xtii Dios nac ne.” ");
INSERT INTO zpmNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","’Gase na gaṉle gotsaa gwi ne, conque xtii Dios name nac ne, pe nac dzigo gliladz ne lëë Dios ga nac grë cho mdio or, cho mdio plat, cho mdio quie ne riab guic miech rzaa zho; ");
INSERT INTO zpmNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ni ib sca rliladz miech. Laa Dios gop zho paciens hor co sac ruṉbeyd zho me; saṉgue niina laa me quiabedz zho, laa me rnab lo zho csaan zho grë ncuaaṉe bliladz zho ga gbig zho lo me, mese gleynie zho; ");
INSERT INTO zpmNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","sac laa me bzole tib dze ne gacredz grëse miech lo me ygaa zho miṉe tsieguiaḻ zho tib tib zho, teḻ zha wban zho. Ni laa me blule gaṉle cho nac meṉ ne guṉ guieḻwxtis co, lëë meṉ co ga goṉ bleeban me. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Zeeṉe bin zho bzeet Pabl no ti meṉ ne brieeban, nzian zho rzhidznie Pabl, zla zho rëb: ―Na dieṉ pa sti dze lozh yquiaadiag no miṉe rnee luu i. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Gataa pcuëëz zho lo xcodiidz Pabl, laa Pabl wbi lo zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Brieequia blalaa zha Aten bliladz Jesús, lëë tib zho ga nac mgui ne lë Nich (meṉ ne nacgrë zha ne nac wxtis) ni ti wnaa lë Dámaris. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Briee Pabl Aten bdziṉ me guiedz Corint. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ga beeṉbey me ti meṉ Pont lë Aquil, ti zha xtii zha Israel nac Aquil. Roma no me glo, wriiṉ bdziṉ me Corint ga grop tsieel me; sac bnabey rey Claud briee grëse zha Israel ne no Roma. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Dzigo güey Pabl blëz Pabl lo zho ga, sac ye zho rzhixcuaa grë lar nroob ne rquia ncal, tipse pquia zho dziin ga gza zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Gzobse dze ne rdziiladz miech lo dziin rie Pabl xyadoo grë zha Israel ne no ga, riezodiidznie me grë zha ne rcaalsa ga; zigtaa zha Israela, zigtagaa zha guiedz cow rnee me lo zho tso guic zho gliladz zho Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Zeeṉe laa Silas grop Timoté bdziṉ Corint, dzigo laa Pabl psilo gzobse dze güey me güeynee me Xtiidz Dios lo grë zha Israel ne no ga, rnee me lo zho cho nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Laa zeeṉe goṉtaa me rond zho diidz, leḻ ntseeb rac zho lo me haxta rneenë zho Jesús, dzigo bdzib me xab me lo zho, rëb me: ―¡Laa naa biaḻ biaḻne naa lo to per pquiaadiagde to miṉe rne naa; xtoḻle to nasca teḻ laa to nitlo! Gbiiredraa naa gne naa Xtiidz Dios lo to, na laa naa csilo ganew lo grë zha ne nacd zha Israel. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Dzigo laa Pabl psilo güey lidz ti meṉ ne no gaxaque zaatne zob yadoo co lë me Just, dib zdoo me rliladz me Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Leṉ dze co ndal zha Corint bliladz Jesús zeeṉe bin zho miṉe rnee Pabl, haxta ti meṉ ne rnabey xyadoo zha Israel lë Crisp, grë meṉlidz me bliladz Jesús, dzigo grëse zho laa zho brobnis. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ti wdze blulo Dios lo Pabl, rëb me lo Pabl: ―¡Gdziebd luu! ¡Ib ycuëëzd luu lo dziin ne noyuṉ luu i, bnee xtidz naa lo grë miech qui! Ndal grë miech rii no sëëb xnëz naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Peet tsienied guic luu, choot grieelod lega pe guṉ luu sac naa quianaap luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nacne blëz Pabl ga stib iz groḻ, pseed me grë miech co Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Laa zeeṉe bzob meṉ ne lë Galión zobnabey me xtan Acay, grë zha Israel ne no Corint ga bnediidz zho grë zho bnaaz zho Pabl güeyzo zho me lo Galión ");
INSERT INTO zpmNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","rëb zho: ―Laa no ziaadnie mgui rii lo luu, sac laa me quiaguiits xley no, quiago me guic miech tsiegaṉ zho Dios sti mod miṉe ni nacdraa ley. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Laa Pabl zie gnee, zeeṉe pquiab Galión rëb me lo grë zha co: ―Teḻne niaca miṉe no pe ti falt, pe ti guieḻntseeb ne quiayuṉ me, dzigosi naa raguiaḻ guṉ guieḻwxtis. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Per teḻne laa to ziaadnie me nu porne rdziladzde to miṉe quiaseed me miech, rdziladzde to teḻ cho rzeet me, sac led scad nac xley to, tsow goḻgaṉ dieṉ pe guṉ to. Nodaque xtiḻ to guic naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Bleega Galión zho nëz ley. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Dzigo bnaaz zha guiedz co ti meṉ lë Sóstenes, meṉ ne rnabey xyadoo zha Israel ga; goṉlo Galión bdiṉ zho me, per peet rëbd Galión. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Goc spalal dze no Pabl Corint ga, dzigo bnee me lo grë zha ne rliladz Jesús ga laa me gbi; ye Aquil ni Priscil wnaa ne nac tsieel Aquil nole guic tsienaḻ zhits me. Nacne zeeṉe laa me briee, ye zho bzëëbgza me barcw, laa zho zie nëz Cencré. Lëëtaaque leṉ dze co noxco Pabl guṉ me teḻ pe nac ncuaaṉe rëb me lo Dios guṉ me, dzigo zeeṉe bdziṉ zho Cencré bnabey me liu liu ptsiib guic me. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Cencré bzëëb zho barcw stib, zie zho nëz Efés. Bdziṉ zho Efés, güey Pabl xyadoo grë zha Israel ne no ga güeynee me Xtiidz Dios lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Dzigo bnab zho mbëz me lo zho ga ti blalaa dze, per brieelod mbëz me ");
INSERT INTO zpmNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","sac laa guic me no gdziṉniob me Jerusalén ygaa me lni ne ziaadyob leṉ dze co, rëb me: ―Na teḻne zneedz Dios diidz, bii ziaḻteedaque naa dieṉ yo to. Gataa biaaṉ Aquil grop Priscil, laa me bzëëb barcw stib zie me nëz Cesarea. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea briee me barcw, laa me zie nëz Jerusalén. Bdziṉ me güeyquiaabdiuzh me grë zha ne rliladz Jesús ga; biireraa me ga bdziṉ me Antioquí. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Goc palal dze no me Antioquí, laa me brieeque ga güeyted me grë guiedz ne ndxie dib xtan zha Frij, dib xtan zha Galás, güeynee me lo grë zha ne rliladz Jesús ga dib zdoo zho gleynie zho Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Leṉ dze co bdziṉ ti meṉ xtii zha Israel guiedz Efés, ti meṉ Alejandríw lë me Apol. Ti zha rac nac me, rieṉ me zha gnee me Xtiidz Dios lo miech. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","26","Güey me xyadoo zha Israel ne no ga, nguieeḻ rac me, peet dzeb guieṉd lo me psilo me nonee me lo zho grëse miṉe bnee Juan Bautist zeeṉe bzeet Juan Jesús; sac loxaque miṉ co bin me zeeṉe gocnaṉ me cho nac Jesús. Lad co co no Aquil ni Priscil, zeeṉe goṉ zho zha rnee me, dzigo blozhse ga, bredz zho me blozh bnee zho lo me zharaa nac zhiwseed Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Grë zha ne rliladz Jesús ga, zeeṉe gocnaṉ zho laa guic me no tsie me nëz Gres, dzigo ye zho rëb wen tsie me, pquiaa zho ti cart pxeeḻ zho lo zha ne no nëz co zaacse ycaania zho me. Zeeṉe bdziṉ me nëz co, pseed me grë zha co. Rley zho blozh gocnaṉ zho cho nac Jesús; ");
INSERT INTO zpmNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","sac squi ndxie miech rsioog me ro grë zha Israel, rnee me lo zho lëële meṉ ne quiambëz zho cxeeḻ Dios ga nac Jesús, ni rlu me lo zho pa lo zhobneew lo Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Leṉ dze ne no Apol Corint, laa Pabl bdziṉ Efés. Blozhse güeyted Pabl grë guiedz ne ndxie nëz xtan zha Galás, laa me bdziṉ ga. Ga bdzieel me blalaa zha ne rliladz Jesús, ");
INSERT INTO zpmNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","dzigo bnabdiidz me lo zho, rëb me: ―¿Pe bgaa to guieḻbiini ne rneedz Espíritu Sant, zeeṉe bliladz to Jesús? Pquiab zho rëb zho: ―¿Guieḻbiini ye? Gard goṉ dzion no rdeed Espíritu Sant guieḻbiini. Dzigo rëbchaa Pabl: ");
INSERT INTO zpmNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","―¿Pezhe waa pseed to zeeṉe brobnis to? ―Zhiwseedse Juan Bautist gocndioṉ no ―rëb zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Dzigo bnee Pabl lo zho zha nac wrobnis ne biaadnie Juan. Rëb me lo zho nacse wrobnis co par glu miech ne laa zho csaan guieḻntseeb, laa zho sëëb xnëz Dios; per grëse zha ne bgaa wrobnis co ib none gliladz zho Jesús, meṉ ne bzeet Juan ga zeeṉe rëb Juan ile ziaad me. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Miṉ co bin zho nacne brobnis zho stib zigne psaṉ Jesús diidz. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Zeeṉe laa Pabl pxobnia guic zho bnab me gdeed Espíritu Sant guieḻbiini lo zho, hor co psilo zho nzian lo diidz ne rnee zho; ni bnee zho teḻ pe nac miṉe racladz Dios gacnaṉ miech. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Lo gza zho rgaa zho tsiipchop, niapse zha bguiw. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tsoṉ mëë blëz Pabl ga, tibaque rie me xyadoo grë zha Israel ne no ga, ible rdziebd me rnee me lo zho zha nac Xtiidz Dios, ni rguib me rgo me guic zho gliladz zho cho nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Per zeeṉe goṉ me no palal zho ib rond diidz, leḻ psilo zho squi ndxie miech rneenë zho Jesús, nacne bleextsoque me grë zha ne rliladzle Jesús, güeynie me zho zaatne nac xyuscuel ti meṉ lë Tiran; ga rcaalsa zho gzobse dze rieseed me zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Dipse leṉ chop iz blëz me ga pseed me grë zha co; nacne grëse miech ne no dib nëz Asia ga, zigtaa zha Israela zigtagaa grëraa miech cow, bin zho zha nac Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bdeed Dios diidz beeṉ me grë milagr nroob ne rzee zdoo miech; ");
INSERT INTO zpmNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","sac haxta lar ne rzëse nia me, lar ne rbixse me rzhoob lad meṉ ne rzacnë laa zho riac, niicle grëgaa meṉdox ne noguitnie miecha, rzhooṉ ma. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Ga quianzë gadz xpëëd ti zhipxoz zha Israel lë Escev, stib guiedz stib guiedz rie zho rieguṉcxooṉ zho meṉdox ne noguitnie miech. Ti vuelt, naṉ zho na ye zho cuedz lë Jesús gacnieṉ me zho guṉcxooṉ zho meṉdox; bdziṉ zho zaatne guṉcxooṉ zho ma, rëb zho: ―¡Zig zobwi Jesús ne rzeet Pabl, laa no rnabey to goḻrieegazh i niina! ");
INSERT INTO zpmNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pquiabaque ma rëb ma lo zho: ―Wen wen ruṉbey naa Jesús ni naṉgaa naa cho nac Pabl, saṉgue to goṉ ni lalnu ruṉbeyd naa to. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Znuse bias meṉ ne noguitnie meṉdox co, bnaaz me gza zha co bdiṉ me zho. Ib blëbd zho lo me, masaque dib brëë rna zho, ni xab zho nacwdraa, laa zho bzhooṉ. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Grë miech ne no Efés, zigtaa zha Israela, zigtagaa grë zha guiedz cow, zeeṉe bin zhow per nli bdzieb zho; grëse zho bieṉ zho ne nli meṉ non, meṉ rnabey nac Jesús. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Haxta ye grë zha ne rliladzle Jesús, hor co laa zho bleero pe nac grë ncuaaṉe ndzinlid ne bliladz zho glo. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nzian zha ne biiḻ diidz dox güeyxi zho grë xquits zho, squi ndxie miech laa zho bzëëga grësew. Zeeṉe biobey palal gocnon grëtaa guits co, biirew zig chooptsii mil pes plat. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ga blu poder ne nacnie Xtiidz Dios, sac grë zha ne bina bdzëë lo xquieḻmban zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bded ga, biab guic Pabl tsieted me nëz xtan zha Macedon, xtan zha Gres, gbiire me ga laa me tsie Jerusalén stib; haxta rnee me Jerusalén griee me tsie me Roma. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nacne ptedner me Timoté grop Rast (zha ne noyuṉ xyudar me leṉ dze co) zie zho nëz Macedon, laa me bii biaaṉ nëz Asia ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Leṉ dze co brieequia palal zha Efés ptsidiḻ zho zha ne rliladz Xtiidz Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Guiedz co no ti meṉ ne ruṉdziin guiib plat lë Demetr, rzaa me grë yadoo yeeṉ zig niaada xyadoo xnaxnazh zho Dian; nroob dimi ne riaḻ me grë me zha ne ruṉnie me dziin co; ");
INSERT INTO zpmNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","bnabey me pcaalsa grë zha ne quia dziin lo me, ni grëragaa zha ne ruṉaque dziin co, rëb me lo zho: ");
INSERT INTO zpmNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","―Rieṉ naa ziyonle to, ziyaṉgaa to gaṉle laa mgui ne rnee zho Pabl quianzë lad guiedz nu, rnee me nlid Dios ga nac grë mdio ne rzaa miech. Pe zhidaale miech quialiladz zhiwseed me nu; ni led loxaque nudsegaa, dible Asia quialiladz miecha. ¿Pe gnë to zha dziuuṉ ne? ");
INSERT INTO zpmNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Goḻguieṉ gaṉle noxtseeb guiabdraa xtsiiṉ ne, ni naṉwen to gaṉle lëë xtimi ne nu. Ni tebaa miṉcosegaaw, miṉe mazdraa noxtseeb nend grëse miech csaanladz xyadoo nazhnazh Dian, nend grëse miech ne rleynie me dib Asia, diibgaa lo guidzliuw con guiaaṉladz zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Zeeṉe goṉ grë zha co sca rëb Demetr, rlëë zho, roptsie zho rgo zho xviv Dian. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Wdzeepaaw grëse meṉguiedz laa zho pcaalsa, güey zho bnaaz zho Gay ni Aristarco chop zha Macedon ne rzënie Pabl, bdobniu zho zho bdziṉnie zho zho ro yulow. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Nacne gocladz Pabl nie me nienee me lo grë miech co, per psaand grë zha ne rliladz Jesús ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Haxta bla zha wxtis ne ndzieeldiidz Pabl, pxeeḻ zho diidz lo me tsied me. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Zhaase zhaase rnee grë miech co ndxie zho ro yulow ga, no zho haxta ni rieṉd pe nacne zie zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Blalaa zha Israel, zeeṉe goṉ zho scataa rac grë miech co, bdob zho zhicw ti meṉ lë Lejandr gocladz zho nee me chop lan xtiidz zho. Laa meṉ co blis nia me parne cuedze zho gnee me; ");
INSERT INTO zpmNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","zeeṉe goṉ zho zha Israel nac me, psilo zho stib grëse zho nguiedz roptsie zho, rgo zho xviv Dian rnee zho: ―¡Meṉ ndzondoo nac Dian! ¡Meṉ ndzon nac xnaxnazh ne! Zig chop hor bre zho ga sca roptsie zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Dzigo briee meṉ ne zobnabey ga, blunia me lo zho cuedze zho; zeeṉe laa zho bredze, psilo me bnee me lo zho rëb me: ―Goḻgona gaṉle, grëse miech lo guidzliu naṉ zho guiedz rii zob nazhnazh Dian, naṉ wen zho gbaa biet me zob me nu; ");
INSERT INTO zpmNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","tsod zha ne guiab led scada. ¿Pe nac nadieṉ ne squitaa rac to? Goḻguieṉ gaṉle nonguieḻda i squi lëëlëd dieeṉ pe rzhixcuaa to. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Goḻwi gaṉle, laa to ziaad-zo grop zha rii nu, ¿pe nadieṉ beeṉ zho? Nacd zho cho zha ne quiaguitnie yadoo, cho zha ne nozhidzniegaa xnaxnazh ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nana, teḻne racladz Demetr pe glisqui me grë me zha ne rquianie me dziin, gacxe na no yulow waa. Niac niaad zho niaadnab zho guieḻwxtis, ni zogaa zha ne yquiaadiaga. ¡Ga glisqui zho pe ruṉ tib, pe ruṉgaa stib! ");
INSERT INTO zpmNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Laa teḻne noragaa pe racladz zho glisqui zho, dzigo niac niacredz grëse zha ne nac wxtis, zha ngobey dieṉ zha niaca. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Sac goṉ ne squi beeṉ to nadze, noxtseeb glisqui zha Romaw lo ne; ni pe nadieṉ dzieets ne teḻne laa zho glisquiw. ");
INSERT INTO zpmNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Blozhse sca bnee me laa me wbi lo zho ga, niicle zhagaaw laa zho zey. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Zeeṉe laa ruid co blëz, dzigo bredz Pabl grëse zha ne rliladz Jesús, bnee me lo zho zaacse gac zho. Blozhse bnee me lo zho, laa me briee ga zie me nëz xtan zha Macedon; ");
INSERT INTO zpmNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","güeynee me lo grë zha ne rliladz Jesús nëz co, pso me diidz lo zho zaacse gac zho. Nëz co briee me bdziṉ me nëz Gres. Ga blëz me tsoṉ mëë. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Laa zeeṉe laa me gbi ga tsie me nëz Siria, laa me ziele sëëb me barcw zeeṉe gocnaṉ me laa zha Israel ne no ga bnediidz pa tsietiṉ zho me, nacne güeydaque me barcw, mazd bio me nëz güeyted me nëz Macedon. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Blalaa zha ne bzënaḻ biogza no me, bzë ti meṉ Beré lë Sópater xingan ti meṉ lë Pirr; bzë chop zha Tesalónica, Aristarco ni Segund; ti zha Derb lë Gay, Timoté, ni schop zha nëz Asia, Tíquico ni Trófimo. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Goḻ no Filip laa zho bner, per biaaṉ no diidz Troas cuëz zho no; ");
INSERT INTO zpmNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","laa no bliaaz ga, ga bdieed no lni Pascw. Zeeṉe bded lni co laa no bziaab barcw, laa no briee ga. Goc gaay ngbidz no no lo nis laa no bdziṉ lo zho Troas, dzigo bliaaz no Troas ga gadz ngbidz. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Zeeṉe goḻ dze dmingw, bio no yu ne rcaalsa zha ne rliladz Jesús ga. Ti yu tsoṉ xcuaaw, laa no pcaalsa par dziuuṉ no xtsee ne psaṉ Jesús diidz ga guṉ grë zha ne rliladz me. Laa no ndxie grë no, dzigo psilo Pabl pseed me no; nzian ncuaaṉe nonee me lo zho sac guini liu co laa me griee ga; goḻ groḻ guieela rsiaaḻdaque me. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","9","Nzian nac biini ne noquia leṉ yu co; zaatne nac ro ventan ga zob ti niib lë Tic. Wdzeelaaw rsiaaḻdaque Pabl, tibaque bzheṉ mcaaḻ niib co, wbix niib ga biab niib nëz ley; ni glaaw, leṉ yu ne riaaṉ glaaraa ga ndxie no. Zeeṉe güeylis zho niib laa niib gutle. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Biet Pabl, bdziṉ me lo niib bdeedz me niib. ―¡Gdziebde to! ―rëb me―. ¡Zrieeban niib! ¡Ni nligaaw brieeban niib! ");
INSERT INTO zpmNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","12","Grëse zho per nli rley zho. Blozh ga bdzieep no glaa stib bdziṉ no leṉ yu co, dzigoraa bdiiz Pabl guietxtil pquiin no. Blozhse bdziuuṉ no xtsee co, laa Pabl psilo bnee lo zho stib, quianeeque Pabl laa liu biini. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Lban co psiaaḻ Pabl, laa me wbi ga laa me zie nëz Ason nzëni me; laa no bziaab barcw bdiednieer no lo me. Bdziṉ no Ason ga bliaaz no me zigne biaaṉ no diidz. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Zeeṉe blanso me lo no, laa no bziaab barcw gza no me bdziṉ no guiedz Mitilen. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Biini liu briee no Mitilen, bdieed no gax Quío, bietraa stib dze co bdziṉ no Samos, ga bliaaz no; bzia no lo nis co zig sti dze dzigoraa bdziṉ no Milet. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Biotieete no Efés, sac laa guic Pabl no gdziṉniob me Jerusalén, zeeṉa ygaa me lni Pentecostés. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nacne zigne bdziṉ no Milet pxeeḻ me diidz Efés bredz me grë zha ne zo lo zha ne rliladz Jesús ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Zeeṉe blanso zho, bnee me lo zho rëb me: ―Wen wen ruṉbey to naa, naṉle to gaṉle zha noxco naa noyuṉ naa xtsiiṉ Jesús meṉ ne rnabey ne. Wlal ne psilo ziyaḻ naa nëz Asia nu, ");
INSERT INTO zpmNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","blactaa biin naa lo grë miṉe bdeed naa, blactaa lo guieḻxtseeb ne ziyo naa, tibaque quianaḻ grë zha Israel quiṉ zho naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Per goṉ to gaṉle, tibaque bioxco naa biaḻseed naa to miṉe nac diidzli, zigtaa pseed naa to zaatne rcaalsa tow, zigtagaa pseed naa to stib yu stib yu. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Grëse miecha, tibaque miṉe pseed naa zho, miṉe bne naa lo zha Israel miṉcoque bne naa lo miech stib guiedz; grëse zho bnee naa lo zho none csaan zho xquieḻntseeb zho dib zdoo zho gnalo zho Jesús, zeeṉa gbig zho lo Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","’Scaque niina ne laa Espíritu Sant rnabey ga naa Jerusalén, naṉd naa dieṉ peraa nac ncuaaṉe gdzieelo naa ga; ");
INSERT INTO zpmNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","per naṉpaa naa ible zgo zho naa ladzguiib, ible sacsi zho naa, sac guiedz ne gdziiṉtaa naa miṉ co rnee Espíritu Sant teed naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lo guieḻxtseeb co no naa per rquiad zdoo naa xquieḻmban naa; miṉe nziuuraa lo naa laga gdeeda diidz ib laa naa no gne lo miech pa lotaa rleynie Dios zho, zeeṉa iṉe gley naa csiaaḻ naa dziin ne bzo Jesús naa nu quiayuṉ naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Rieṉ naa lo grë to ne nac to zha ne biaḻseed naa gocnaṉ to zha nac xnëz Dios, gaṉdraa to lo naa lo guidzliu rii. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Laa naa pseedle to grëse miṉe nac Xtiidz Dios, ib peet pqueetsd naa lo to; gacxe waa, teḻ cho tib to nitlo, led xtoḻdraa naa ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Goḻguieṉ sca, ¡goḻquianap to, ni scagaa goḻquianap grë zha ne zo to lo! ¡Goḻwi gaṉle xnëz Dios no zho, haxta lo cruz gut Xpëëd me bdiizh me xtoḻ zho! Ni stiba, ¡ib Espíritu Sant bzo to yquianap to zho zigne rquianap baxtor xpëcwxiil zho! ");
INSERT INTO zpmNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","’¡Nsin goḻso! Sac rieṉle naa zeeṉe laa naa gbiche lo to, ib zrieequia grë zha ne guiaad guiaadquidie to, zguib zho zha gnitlo zho to zigne ruṉ grë coyot mëcwxiil. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Haxta lad to, zrieequia bla zha ntseeb ne ctsëë Xtiidz Dios, squiil zho to tsienaḻ to zhiwseed zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Gacxe waa laa naa rne lo to, ¡nsin goḻso! Goḻsoladz gaṉle tsoṉraa iz, dze guieel pseed naa to, blactaa biin naa pso naa diidz lo to tib tib to zaacse gac to. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Dios nac meṉ ne gacnieṉ to, laa naa rsaṉ to ladznia me grëse to; Xtiidz Ndzon me miṉe rnee gaṉle zha nquialadztaa me to, lëëw lozh quix biini to dib zdoo to gnalo to me, zeeṉa ygaa to zaatne gneedz me cuëz to grë to zha ne noraa xnëz me. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","’Wlaltaa ib rzobladzd naa dimi, ib rzobladzd naa lar, guiep naa tebaa zha yquianie naa grë ncuaaṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Leṉ dze ne blëz naa lo to, goṉ to gaṉle niapse nia naa bdziniaa naa ncuaaṉe pquiin naa, ncuaaṉe pquiingaa grë zha ne bzënie naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ga blu naa lo to gaṉle, ib none dziuuṉ ne dziin zeeṉa grieelo dziuuṉ ne xyudar zha ne guieṉd pe yquiin. Ib riaaṉladzd naa xtiidz Jesús meṉ ne rnabey ne, zeeṉe znu bnee me: “Mazdraa nroob guieḻbley ne rgaa zha ne rgad, lëdle zha ne rad.” ");
INSERT INTO zpmNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Zeeṉe blozh bnee Pabl lo zho, laa me pquiitsgzhib ga grë me zho bzodiidznie zho Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Blozhse ga, tibga tibga zho wbig bnee zho lo me, bnaaz zho nia me, bdeedz zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Mban rac zho psilo zho roon zho, rsoladz zho rëb me gaṉdraa zho lo me. Blozh ga, güey zho güeyzonëz zho me zaatne sëëb me barcw. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Blozhse bzhieeṉ no nia grë zha Efés co, laa no bziaab barcw, laa no zio bdziṉ no ti lo guidzliu win ne no lo nisdoo co lë Cos. Biini liu briee no ga bdziṉ no lo sti guidzliu win co lë Rodas. Rodas briee no bdziṉ no guiedz Pátara. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Guiedz Pátara, ga bziaab no ti barcw ne zie nëz xtan zha Fenicia. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Zeeṉe zieded barcw co ngali zaatne riaaṉ guidzliu win ne lë Chipr, bui no nëz revés rlupaa guidzliu co. Laa no zio haxta bdziṉ no guiedz Tir, xtan zha Siria, ga blëz barcw co biet grë yo ne neya. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Zigne bdziṉ no ga bdzieet no barcw bziaab no lad guiedz co, biodziel no grë zha ne rliladz Jesús ga; bliaazaque no lo zho ga ti zhmal. Dzigo psiaab Espíritu Sant guic zho rnee zho lo Pabl, tebaa siguieḻ me mazd tsied me Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Zeeṉe laa no briee ga, grëse zha ne rliladz Jesús grë tsieel zho grë xpëëd zho biaad-zonëz zho no ro nis co; dzigo lo yuzh co ga pquiitsgzhib no grë no, bziodiidznie no Dios. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Blozhse bzhieeṉ no nia zho, laa zho wbi ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Briee no Tir bdziṉ no guiedz Tolemaid, ga bio no bioquiaabdiuzh no grë zha ne rliladz Jesús ga, bliaaz no lo zho tib dze. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Biini liu briee no ga bdziṉ no guiedz Cesarea, ga biobiaaz no lidz ti meṉ ne noneeque Xtiidz Dios lo miech, lë Lip. Lëë Lip co ga gocgza sxoop zha ne bzo beeṉ xyudar zha poxtl. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Quianie me tap ndzoop ne gard ctsieelnia, gzase zho bdeed Dios guieḻbiini lo zho rnee zho teḻ pe nac miṉe racladz Dios gacnaṉ miech. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nzianle dze goc no no lidz Lip, zeeṉe blanso ti meṉ ne ziaad nëz Judé lë Agab, biadquiaabdiuzh me no. (Ye me rnee teḻ pe nac miṉe racladz Dios gacnaṉ miech.) ");
INSERT INTO zpmNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Zigne blanso me lo no ga, bzheṉ me lar ne rbe leṉ Pabl, pxidoo mew nia me ni pxidoo mew ni me, në me: ―Znu goṉ rnee Espíritu Sant gzobdoo zha Israel bizhuan lar rii, co zho me ladznia zha Roma zeeṉe laa me gdziṉ Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Grë zha ne rliladz Jesús ga, zeeṉe bin zho sca rëb meṉ co, rnab zho lo Pabl tsied me Jerusalén, yeque no sca rnee lo me. Mban rac no rdzioon no. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pquiabaque me në me lo no: ―¿Pe nac dzigo roon to? Teḻ naa laa naa bleeladzle naa maase gzobdoo zho naa Jerusalén, niicxe haxta gut zho naa waa porne rleynie naa Jesús. ¡Loxaque rsiaab guieḻnë to naa i goṉ squi rac to! ");
INSERT INTO zpmNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bdziaṉse no nlid yquiaadiag me xtiidz no, dzigo mazd psaan no, rdzieets no: ―Goḻgotsaa csaan ne, Diostaa naṉ dieṉ zha gaca. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Bdedse ga bzhixcuaa no laa no briee ga, laa no zio nëz Jerusalén; ");
INSERT INTO zpmNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","blalaa zha ne rliladz Jesús Cesarea ga bzënaḻ zhits no, bzënie zho ti meṉ Chipr lë Mnasón. Izle rliladz me Jesús, lidz me biobiaaz no zeeṉe bdziṉ no Jerusalén. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Grë zha ne rliladz Jesús Jerusalén, rley zho zeeṉe goṉ zho laa no bdziṉ, blëzlo zho no. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Biini liu co güeynie Pabl no lidz Jacob bioquiaabdiuzh no me, lëëtaque laa grë zha rnabey ne zo lo grë zha ne rliladz Jesús Jerusalén ga, ndxie ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Blozhse pquiaabdiuzh Pabl grë zha co, dzigo psilo me bzodiidz me lo zho grëse zha gocnieṉ Dios me güeyseed me grë miech stib guiedz. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Zeeṉe bin zhow per nli rley zho, rdeed zho xquizh lo Dios; dzigo rëbchaa zho lo me: ―Bets, ye zha Israel goṉ ndaldoo zho zililadz Jesús; per racladz zho tibaque tsienaḻ zho miṉe rnabey Xley Moisés. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Grë zha ne no nu bin zho laa luu güeyseed grë meṉ wladz ne no guiedz zit, nac diidz blu luu lo zho tsienaḻdraa zho Xley Moisés, codraa zho xpëëd zho bey, niicle tsienaḻdraa zho grë zhiwseed xmeṉgol ne. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Zha gaṉle dziuuṉ ne? Sac zeeṉe gon zho laa luu blanso, ible ziaadguib zho luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","No tap bets ne nu ziaadyoble guṉ zho miṉe bnee zho lo Dios; miṉe gaca güey ");
INSERT INTO zpmNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","güeynie zho yadoo, goḻguṉ grë miṉe rnabey ley, bdiizh ctsiib guic to gza to; zeeṉa ga gaṉ grë zha rii gaṉle nlid grë miṉe rnee miech luu ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","’Saṉgue grë miech stib guiedz zha ne rliladz Jesús, laa no pxeeḻle diidz lo zho zigne bzodiidz ne nu: grë ma ne rut miech rgogon zho lo zhimdio zho, gowd zho bëël co; grë ma ne rxieed ren zeeṉe ret ma, gowd zho ma; ni niicle grëgaa ma ne gut zho, ib gowd zho xchen ma; grë zha bgui, nodne tsonie zho wnaa ne nacd tsieel zho; niicle wnaagaaw, nodne tsonie zho mgui ne nacd tsieel zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Laa Pabl zienie gza zha co. Biini liu güey me gza me zho güeyguṉ zho miṉe rnabey ley; blozh ga güey zho yadoo güeynie zho diidz pa dze gza miṉe quiayuṉ zho ga, zeeṉa gaḻ dze co laa zho tsienie gon ne gdeed zho tib tib zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Laa zeeṉe merle gza gadz ngbidz ne quiayuṉ me miṉe rnabey ley ga gza me zha co, lega naclew goṉ bla zha Israel ne ziaad nëz Asia laa me no leṉ yadoo. Nacne wbig zho ");
INSERT INTO zpmNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","bzheṉ zho zhicw me, roptsie zho rnee zho: ―¡Grëse to meṉguiedz! ¡Goḻguṉ xyudar no gnaaz ne meṉ rii! Sac lëë me ga quianzë quiaseed me zha wladz glëënie zho ladz zho, rnee me lo zho guṉdraa zho grë miṉe rnabey ley, gapdraa zho respet yadoo rii; haxta grë zha zit zizëëbnie me nu. ¡Noguitniele me lugar nda rii! ");
INSERT INTO zpmNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Sca rnee zho, sac goṉ zho Pabl leṉ guiedz Jerusalén ga ziegrop me ti zha Efés lë Trófimo, dzigo rzac zho güeynie me zha co leṉ yadoo. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Pe ga bin grë meṉguiedz, grëse zho bdziṉ wbigbe zho lo Pabl bdobniu zho me blee zho me leṉ yadoo, zigne blee zho me ga lëëlëd psioog zho ro yadoo; psilo zho noguiṉ zho me, naṉ zho gut zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Zeeṉe gocnaṉ meṉ ne rnabey lo meṉguiib ne ndxie ga laa ruid co noyac, ");
INSERT INTO zpmNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","lëëlëd brieenie me grë xmeṉguiib me ni grëraa zha ne rnabey lo zho. Zeeṉe goṉ grë zha ne noguiṉ Pabl ga, laa grë meṉguiib co bdziṉ, dzigoraa blëz bdiṉ zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Dzigo wbig meṉ rnabey co, bnabey me grë zhaguiib co bzoob zho Pabl chop caden. Bnabdiidz me lo grë miech co dieṉ cho nac Pabl, pe quiayuṉ me ne scataa rlëënie zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Psilo zho nguiedz roptsie zho, zhaase zhaase ncuaaṉe rcaadzdoḻ zho me. Goṉse meṉ rnabey co rlud dieṉ pepaa rlisqui zho, nacne bnabey me grë meṉguiib co ziesaṉ zho Pabl yu ne rbëzpaa zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Laa grë meṉguiib co csilo soquianie Pabl lo scaler ne rdziṉ ro yu co, gataa mazd bzoobyaṉ zho me, sac ntseeb rac grë miech co; ");
INSERT INTO zpmNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","naḻbe zho, roptsie zho rnee zho: ―¡Goḻnitlogazh meṉ qui! ¡Niinagazh goḻgut me! ");
INSERT INTO zpmNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Laa grë meṉguiib co csëëble me leṉ yu co, zeeṉe bnee me lo meṉ rnabey co, rëb me: ―¿Pe zrieelo gne naa ti xtidz naa lo luu? Dzigo rëb meṉ rnabey co: ―¿Mod rac luu rnee luu xtiidz zha Gres? ");
INSERT INTO zpmNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Led luud ga dzigo nac ti zha Egipt ne psilo racntseeb lo gobiern leṉ dze rii? Nac diidz, tap mil zha ntseeb nacnie zho, laa zho ziese nëz dan. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","―Led naada ―rëb Pabl― meṉ Israel nac naa. Guiedz Tars gol naa, lëë guiedz co nac miṉe nroobraa lo grë guiedz ne ngab Cilis. Na laa naa rnab lo luu, beeṉ guieḻnzaac bneedz diidz gne naa chop lan xtidz naa lo grë miech qui. ");
INSERT INTO zpmNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","―Zaca ―rëb meṉ co. Lo scaler co zo Pabl blunia me lo grë miech co cuedze zho. Zeeṉe laa zho biacdze, dzigo psilo me bnee me xtiitsë me grë me zho, rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","―Grëse to meṉ wladz, laa naa rzaac to zig ti bets naa zig pxozgaa naa, goḻquiaadiag miṉe gne naa nu gaṉle zeeṉa gacnaṉ to quiayuṉd naa miṉe rquiaqui to naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Zeeṉe goṉ zho xtiidz zho rnee me, grëse zho dzese bre zho; dzigo rëb me: ");
INSERT INTO zpmNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","―Meṉ Israel nac naa, guiedz Tars xtan Cilis ga gol naa, per Jerusalén nu broob naa, nu bio naa wseed, maistr Gamaliel goc meṉ ne pseed naa. Pseed me naa grëse zigne nac xley xmeṉgol ne, grëse zigne nac zhiwseed zho; pseed me naa tibaque noxco naa ruṉnon naa lë Dios zigne noxcoque tow. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Miṉe beeṉ to nu nadze, ye naa blactaa squi beṉ naa ptsidiḻ naa grë zha ne rliladz Jesús, pquianaḻ naa ygaa zho guet zho; mgui wnaasaque razobdoo naa zho lidz zho rasaṉ naa zho ladzguiib. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Meṉ ne nac pxoz nroob ni grë meṉgol ne goc wxtis guiedz rii leṉ iz co, zha co naṉpaa gaṉle nli sca beṉ naa; sac zha bneedz ti xtiidz zho bi naa ndziṉnie naa lo zha ne rnabey xyadoo grë meṉ wladz ne no Damasc, zeeṉa niacnie zho naa nianaz naa grëraa zha ne no ga rliladz Jesús, niaḻnie naa zho Jerusalén nu nded zho caxtigw. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Miṉ copaa nagoṉ brie naa nu za naa nëz co. Zhile gdziṉ naa Damasc, zig rwe ngbidza tibaque zeeṉe ziaad ti biinidoo nëz zhan gbaa biab lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Biabgazh naa liu, ga nix naa bin naa ti tsi meṉ co rnee me lo naa: “Saul, Saul, ¿pe nacne quianaḻ luu naa?” ");
INSERT INTO zpmNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“¡Beeṉ guieḻnzaac bnë dieṉ cho luu!”, rep naa. Dzigo në meṉ co lo naa: “Naa nac Jesús meṉ Nazaret ne squi quiatsidiḻ luu.” ");
INSERT INTO zpmNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","’Grë zha ne zanie naa ga, bdzieb zho goṉ zho biini co, per bieṉd zho pe rnee meṉ co lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Dzigo rep naa lo me: “Bzhiguieḻ bnë dieṉ, ¿pe racladz luu guṉ naa niina?” Nëchaa me: “Guche i, güey Damasc ga gnë zho gaṉle pe nac miṉe no guṉ luu.” ");
INSERT INTO zpmNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","’Dzigo bzheṉ zha ne zanie naa ga nia naa, bdziṉnie zho naa Damasc; sac lo biinidoo co pcow lo naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ga no ti mgui lë Ananí, zëëb diidz rioxco me grë miṉe rnabey ley, grëse meṉ wladz ne no ga naṉpaa zho ti meṉ wen nac me; ");
INSERT INTO zpmNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","dzigo biaad me zaatne blëz naa ga, në me lo naa: “Saul, niinagazh goṉ bets laa luu gbiire gwi stib.” Zigne sca bnee me laa lo naa biac, goṉgazh naa me. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Dzigo nëchaa me lo naa: “Dios meṉ ne bliladz grë pxozgol ne, ib meṉ co bzooblo luu gacnaṉ luu pe nac miṉe racladz me gac, me bzooblo luu guṉbey luu meṉ ne nacle diidz ga cxeeḻ me lo guidzliu, ni gon luu tsi meṉ co. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ib laa me bzo luu tsienee luu lo miech miṉe bzhaac luu ga, miṉe bin luu ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Guso i sca, zeeṉa chobnisgazh luu. Dib zdoo luu bredz Jesús, bnab lo me csaṉmbe me luu lo xtoḻ luu.” ");
INSERT INTO zpmNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Zeeṉe laa naa blanso Jerusalén nu, tib dze lëëtaque no naa yadoo nozodiidznie naa Dios, ");
INSERT INTO zpmNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","tibaque blulo me lo naa në me: “Na zeeṉa biobladz briee Jerusalén nu, sac ib gliladzd grë miech rii miṉe gnee luu zeeṉe gnee luu xtidz naa lo zho.” ");
INSERT INTO zpmNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Per ruṉbey zho naa waa”, rep naa lo me, “naṉpaa zho scataa ra naa grë yadoo raxizhoo naa grë miech ne rliladz luu, rnabey naa rguiṉ zho zho ni rio zho ladzguiib, ");
INSERT INTO zpmNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","niicle zeeṉe beet zho Xteb meṉ ne bnee xtiidz luu ga, ye naa bded diidz beet zho me, haxta pquianaap naa xab grë zha ne bdeedquie me.” ");
INSERT INTO zpmNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Dzigo në me lo naa: “Na zeeṉa pcaaniob nëz briee nu, sac goṉ laa naa cxeḻ luu stib dan tsienee luu xtidz naa lo grë meṉzit.” ");
INSERT INTO zpmNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Zeeṉe bin zho sca rëb me bdeetraa zho diidz nee me, psilo zho nguiedz roptsie rnee zho: ―¡Ib rieguiaḻdraa gban meṉ qui! ¡Goḻnitlogazh me! ");
INSERT INTO zpmNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nguiedz zëëb tsi zho, ib rioogd ro zho, masaque rdzib zho xab zho ni rchooṉ zho yudie laglaa. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Dzigo psëëb meṉ rnabey co Pabl leṉ yu co, ni bnabey me grë meṉguiib co quiṉ zho Pabl, zeeṉa cueero Pabl dieṉ pe nac ncuaaṉe beeṉ Pabl, zha nac ne scataa rac grë miech co lo Pabl. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Laa zho blozhle pxidoo me, laa zho csilo quiṉ me, zeeṉe rëb me lo sti zha ne rnabey lo grë zhaguiib co: ―¿Pe nonguieḻa dzigo ne lega quiṉ to ti zha Roma, ni gardle gac guieḻwxtis dieṉ pe nlipaa no xfalt zho? ");
INSERT INTO zpmNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Zeeṉe bin zha co sca rëb Pabl, lëëlëd güeynie zho diidz lo meṉ ne rnabey zho ga, rëb zho: ―¿Zha goṉ guṉ luu? Sac zha Roma me nac mgui co. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Dzigo güey meṉ rnabey co rëb me lo Pabl: ―Bneeli lo naa, ¿dieṉ pe nli na meṉ Roma nac luu? ―Nliw ―rëb Pabl―, zha Roma nac naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Rzedz yaṉ meṉ rnabey co rëb me: ―¡Naasi zha Roma nac naa, ni nroob dimi bdizh naa bgab naa lo zha Roma! Dzigo rëbchaa Pabl: ―Saṉgue naa, desde gol naa bgab naa lo zha Roma. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Grë zhaguiib ne bzo nguiṉ Pabl ga parne cueero me, lëëlëd wbiche zho lo me, niicle meṉ rnabey cow bdzieb me zeeṉe goṉ me nli zha Roma nac Pabl, sac nrooble nac falt ne niuṉ me ga lega nabey me nguiṉ zho ti zha Roma. ");
INSERT INTO zpmNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Zeeṉe biini liu, bnabey meṉ rnabey co pcaalsa grë zhipxoz non zha Israel ni grë meṉ ne nac zhiwxtis zho, sac racladz me gacnaṉ me dieṉ pepaa nac ncuaaṉe rquiaqui rlëënie grë miech co Pabl. Dzigo pxadz me Pabl, blee me Pabl bzo me Pabl lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Dze bui Pabl lo grë zha wxtis co, dzigo psilo Pabl bnee me rëb me lo zho: ―Laa naa rneli lo to nu gaṉle, mbe zdoo naa, Dios zobwi gaṉle zanaḻd naa ncuaaṉe rdziguiend me. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Zeeṉe goṉ Ananí (meṉ ne nac pxoz nroob) sca rëb Pabl, bnabey me zha ne zo gax lo Pabl, rëb me: ―¡Goḻcap ro zha qui! ");
INSERT INTO zpmNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Dzigo rëbchaa Pabl lo me: ―¡Tebaa squique cap Dios ro luu! ¡Nac luu goṉ zig ti lidz nguts loxaque nëz zhitssew stib rna! ¿Pa rquiin ne laa luu zob i? Led luu zo par cobey luu teḻ no pa ti ley ne zaguits naa, na leḻ luule noguiitsa bnabey luu bdiṉ zho naa. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","5","Pquiabbe zha ne ndxie ga rëb zho: ―¡Bieṉ gaṉle lo pxoz nroob i, lo meṉ ne quiayuṉ xtsiiṉ Dios i noquiabro luu! ―Goḻguṉ dispensar ―rëb Pabl―. Naṉd naa lëë pxoz nroob i, teḻ niaca miṉe naṉ naaw ne scad naa; sac zhobnee lo Xtiidz Dios: “Gneenëd luu zha ne rnabey ladz luu.” ");
INSERT INTO zpmNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Zeeṉe bieṉ Pabl groḻ zha wxtis co zienaḻ zhiwseed zha saducé, zgroḻ zho zienaḻ zhiwseed zha farisé, dzigo psilo me nguiedz bnee me rëb me lo zho: ―¡Grëse to bets, goḻgona gaṉle, zha farisé nac naa, niiclegaa pxoz naaw farisé goc me! ¡Ni porne rliladzpaa naa goṉ zrieeban zha ne ret, miṉ co gane znu zo naa lo to nu! ");
INSERT INTO zpmNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Zeeṉe sca rëb Pabl, psilo zho bdiḻdiidz zho. Goc zho chop dii, ");
INSERT INTO zpmNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","rriee zha saducé rnee nlid grieeban zha ne ret, nlid no anjl, nlid no espíritu; laa zha fariségaa na rnee zrieeban miech, no anjl ni no espíritu. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nguiedz zëëb tsi zho noneelsa zho, dzigo gusoque bla maistr ley ne nacgrë zha farisé, rëb zho: ―Laa ne bdziaṉle gaṉle, ¡ni ti falt rapd mgui qui! ¿Pe nadieṉ dziuuṉ ne? Nend ti espíritu ga, ti xanjlgaa Dios ga sca bnee lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Zeeṉe goṉ meṉ ne rnabey lo meṉguiib ga, laa lo xtiḻ zho noyac nroobraa, bdzieb me rëb me nend znuse gzhiizh zho Pabl; bnabeyaque me gocredz meṉguiib güeyxi zho Pabl biire güeysaṉ zho me leṉ yu ne rbëz zho ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Goḻ guieel co, blulo Dios lo Pabl rëb me: ―Gdzieebd luu, zigne bnee luu xtidz naa lo miech Jerusalén nu, scaque none tsienee luuw lo grë zha ne no Roma. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Zeeṉe biini liu, ndziibsraa choo zha Israel bnediidz rëb zho gowd zho, ni tib ro peet guied zho haxta gut zho Pabl; teḻne guṉd zho miṉe rnee zho maase csiaabzi Dios zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Dzigo güey zho lo pxoz ne rnabey, lo grë zha ne nac zha non lo meṉguiedz, bzodiidz zho miṉe no guic zho ga, ni rëb zho: ");
INSERT INTO zpmNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","―Nana goṉ, goḻnab lo meṉ ne rnabey lo meṉguiib cxeeḻ me Pabl lo to gzhe, goḻquiaalo noraa pe lozh yquiep to Pabl; laa no nsinle ziobmbiaaz. Zeeṉe laa zho tednie Pabl, ga dziuut no Pabl. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Dieeṉ zha bin ti xingan bzian Pabla, nacne lëëlëd güey win yu ne rbëz meṉguiib ga güeynie win diidz lo Pabl. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Dzigo bredz Pabl ti zha ne rnabey lo meṉguiib co, rëb Pabl lo zho: ―Bzhiguieḻ güeynie mëëd rii lo meṉ ne rnabey to, sac laa win no tsienie ti diidz lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Bzheṉ meṉ rnabey co nia mëëd co, güeynie me win lo meṉ nroob ne rnabey zho, rëb me: ―Laa naa ziaḻnie mëëd rii nu me, dieṉ pe nac diidz ne ziaadnie win lo luu; Pabl ne no ladzguiib ga bnab lo naa guiaḻnie naa win. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Dzigo bzheṉ meṉ rnabey co nia win, güeynie me win stib nëz, bnabdiidz me lo win dieṉ pe nac diidz ne zienie win lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Dzigo rëbchaa win: ―Laa zha Israel goṉ bnediidz gnab zho cxeeḻ luu pxey naa Pabl lo zhiwxtis zho gzhe, yquiaalo zho gnë zho noraa pe yquiep zho me. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bzhiguieḻ gliladzd luu xtiidz zho, sac ndziibsraa choo zha ne nacgrë zho rëb zho laa zho tsiesoblan nëz gutgazh zho me zeeṉe laa me ted. Biaaṉ zho diidz grë zho, gowd zho, ni tib ro peet guied zho haxta gut zho me; haxta rëb zho teḻ laa zho guṉd miṉ co maase gdzibdee Dios zho. Ible zuṉ zhow, loxaque quiambëzse zho dieṉ pe guiab luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Blozhse ga dzigo bzonëz me win, ni pso me diidz lo win choot lo gneed win ne laa win güeynie diidz lo me. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Lëëlëd bredz meṉ rnabey co chop zha ne zo lo meṉguiib, rëb me: ―Laa zhaguiib goṉ none griee naguieel tsie zho Cesarea, na zeeṉ goḻzo zha ne tsie; none tsie chop gayoo zha ne sëni, tsoṉgaḻ tsii zha ne sob guay, schop gayoo zha ne güey lanz. Naguieelgazh, zig rlozh xtsee none griee zho nu; ");
INSERT INTO zpmNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","sac laa zho none tsiesaṉ Pabl Cesarea. Ni goḻcoxab ti guay ne sob Pabl, sac none ndip ndaan me gdziṉnie to me lo gobernador Wech Cesarea. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","26","Dzigo pquiaa me ti guits ne güey zho gdziṉnie zho lo gobernador, rneew: “¡Diuzh Gobernador Wech! ’Naa nac Claud Lisias, laa naa rxeḻ guits rii lo luu gzodiidz naa gaṉle zha nacne bnabey naa ziaadsaṉ zho meṉ qui zaatne zob luu i. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","’Zha Israel bnaaz me gocladz zho niut zho me, laa zeeṉe gocnaṉ naa zha Roma nac me nacne pxeeḻaque naa zhaguiib güeyla me lo zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Gocladz naa niacnaṉ naa dieṉ zha nacne rlëënie zho me, dzigo bianie naa me lo zhiwxtis zho. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ga goṉ naa led ncuaaṉe rnad rlëënie zho me; teḻ zha nac xley zho ncuaaṉ co rlisqui zho; nacda ncuaaṉe guiab ne rieguiaḻ guet me, tsogyugaa me ladzguiib. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Zeeṉe gocnaṉ naa laa palal zho bnediidz gut zho me, nacne bnabeyaque naa ziaadsaṉ grë meṉguiib qui me lo luu i. Niiclegaa zha ne rlëënie mew, laa naa rep lo zho guiaad zho lo luu i, zeeṉa i gnë zho dieṉ zha nacne rlëënie zho me. ’Lëëd bii gdzieel ne sca dieṉ.” ");
INSERT INTO zpmNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Zeeṉe laa liu pcow, zig rlozh xtseew laa grë meṉguiib co pcaanie Pabl nëz; dib guieel bio zho nëz bdziṉnie zho me guiedz Antípatris. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Biini liu, loxaque zha ne zob guay ga pcaa nëz zienie zho me Cesarea, laa grëraa meṉguiib co wbire bdziṉ Jerusalén stib. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Zeeṉe bdziṉ zho Cesarea, bdeed zho guits ne zienie zho ga lo meṉ ne nac gobernador, dzigo laa zho psaṉ Pabl ga. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Blozhse blab me lo guits co, dzigo bnabdiidz me lo Pabl dieṉ pa guiedz gol Pabl. Dzigo rëbchaa Pabl lo me, zha Cilis nac Pabl. ");
INSERT INTO zpmNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","―Nasca ―rëb me―, zeeṉe laa zha ne rlëënie luu glanso nu, dzigo yquiaadiag naa dieṉ zhapaa nac xtiḻ to. Dzigo bnabey me, pquianap meṉguiib Pabl zaatne nac leṉ xyulow Herod. ");
INSERT INTO zpmNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Zeeṉe goc gaay ngbidza, laa Ananí meṉ ne rnabey lo pxoz bdziṉ ga, gza me blalaa zha ne nac zha non lo meṉguiedz Israel, zienie zho ti licenciad lë Tértulo; grë zho laa zho zie zienie zho diidz lo gobernador pe nacne rdiḻnie zho Pabl. ");
INSERT INTO zpmNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Dzigo bnabey gobernador gocredz Pabl. Zeeṉe laa Pabl bdziṉ, psilo licenciad co bzeet me grë ncuaaṉe rquiaqui zho Pabl, rëb me: ―Xquizhdoo luu goṉ gobernador, ne squitaa ndzielguic luu rieṉ luu zha gnabey luu, gane zaacse mban meṉladz no niina, blactaa ncuaaṉe yquiin lo no noyuṉ luu. ");
INSERT INTO zpmNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Rzac zdoo now, teḻ pa lotaa zo no rsoladz no luu nac luu meṉ ne rnabey no. ");
INSERT INTO zpmNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nli nonguieḻda dziuṉneed no luu, per beeṉ ti guieḻnzaac pquiaadiag gaṉle pe nac ncuaaṉe rlisqui no quiayuṉ mgui ne zo lo ne nu. ");
INSERT INTO zpmNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","’Masaque nac me lo no zig nac ti guieḻguidz dox ne rded, grëse guiedz quianzë me noyuṉgüet me meṉladz no gacndaan zho lo meṉ ne rnabey no. Lëë me ga zo lo grë zha ne rnee zho nazaren. ");
INSERT INTO zpmNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Zeeṉe bgaa me, lëëtaque laa me no leṉ yadoo ro ne zob Jerusalén quiayuṉnguzee me xyadoo no. Nacne gocladz no gagazh nguizh me falt co zigne rnabey xley no; ");
INSERT INTO zpmNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","per biaad Lisias grë xmeṉguiib me ntseeb rac zho biaadla zho me lo no. ");
INSERT INTO zpmNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Na nagoṉ zac luuzhal yquiep me, zeeṉa gaṉ luu gaṉle nli quiayuṉ me grë miṉe rnee no nu. ");
INSERT INTO zpmNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Grë zha Israel ne zienaḻ ga, pquiabbe zho rëb zho 