﻿USE sofia;
DROP TABLE IF EXISTS sofia.zplNT_vpl;
CREATE TABLE zplNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zplNT_vpl WRITE;
INSERT INTO zplNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Caꞌa nzeꞌta nú lee bee beneꞌ Jesucristo enu udetela, liꞌinu enu nzeꞌta lu familiaꞌ arre David nu Abraham. ");
INSERT INTO zplNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham unga paꞌ Isaac, nu Isaac unga paꞌ Jacob, nu Jacob unga paꞌ Judá nu bee bichilla. ");
INSERT INTO zplNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nu Judá cuna unaꞌlla Tamar, uluꞌcu beella enduꞌ beella enu lee Fares nu Zara. Fares unga paꞌ Esrom, nu Esrom unga paꞌ Aram. ");
INSERT INTO zplNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram unga paꞌ Aminadab, nu Aminadab unga paꞌ Naasón, nu Naasón unga paꞌ Salmón. ");
INSERT INTO zplNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón unga paꞌ Booz, nu naꞌlla lee Rahab. Booz cuna unaꞌlla Rut uluꞌcu beella enduꞌ beella enu lee Obed. Nu Obed unga paꞌ Isaí. ");
INSERT INTO zplNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí unga paꞌ arre David, nu arre David cuna bene enu unga unaꞌa Urías, uluꞌcu beella tucu enduꞌ enu lee Salomón. ");
INSERT INTO zplNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Nu Salomón unga paꞌ Roboam, Roboam unga paꞌ Abías, nu Abías unga paꞌ Asá. ");
INSERT INTO zplNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asá unga paꞌ Josafat nu Josafat unga paꞌ Joram nu Joram unga paꞌ Uzías. ");
INSERT INTO zplNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías unga paꞌ Jotam, Jotam unga paꞌ Acaz. Acaz unga paꞌ Ezequías. ");
INSERT INTO zplNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías unga paꞌ Manasés, Manasés unga paꞌ Amón, nu Amón unga paꞌ Josías. ");
INSERT INTO zplNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Nu Josías unga paꞌ Jeconías cuna bee bichilla, tiembu cuaꞌ neca chenu uriꞌi bee bene Babilonia preso bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Luzeꞌelá chenu uriꞌi bee bene Babilonia preso liꞌibeella, che uluꞌcu Jeconías tucu enduꞌ enu lee Salatiel, nu che Salatiel unga paꞌ Zorobabel. ");
INSERT INTO zplNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel unga paꞌ Abiud, nu Abiud unga paꞌ Eliaquim, Eliaquim unga paꞌ Azor. ");
INSERT INTO zplNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor unga paꞌ Sadoc, nu Sadoc unga paꞌ Aquim, Aquim unga paꞌ Eliud. ");
INSERT INTO zplNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud unga paꞌ Eleazar, nu Eleazar unga paꞌ Matán, Matán unga paꞌ Jacob. ");
INSERT INTO zplNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob unga paꞌ José enu unga niyuꞌ María. Nu María neca naꞌ Jesuse nu leꞌca leenu Cristo. ");
INSERT INTO zplNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Scua unga desde tiembu nú uhuañi Abraham hasta tiembu nú uhuañi arre David, uhuañi rtaa generación bene, nu leꞌca rtaa generación bene uhuañi desde tiembuꞌ arre David hasta chenu uriꞌi bee bene Babilonia preso bee bene Israel. Nu leꞌca rtaa generación bene uhuañi desde nú uriꞌi bee bene Babilonia preso bee bene Israel hasta chenu uriña bichia nú ungula Jesucristo lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Singuie unga chenu ungula Jesucristo: María naꞌnu nzula nú yuculla José, pero ante nú yucusaꞌbeella, nuꞌla enduꞌ xlaꞌcu María equie poderꞌ Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nu lunú neca José bene nzeꞌca lá niarquiꞌlla nilla nú xi seca María aꞌla uriꞌilla elliebacuꞌ nú tsaꞌnalla María aꞌchiꞌtsia. ");
INSERT INTO zplNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pero diquila nú rriꞌilla elliebacuꞌ nucuaꞌ, che ulubeꞌlu tucu ángeleꞌ Diose lulla leta xcalaꞌlla, nu uni ángele zeꞌe lulla: ―José, liꞌilu enu nzeꞌta lu familiaꞌ arre David, la lliquilu nú yuculu María xne enduꞌ enu acanuulla equie cuendaꞌ Espíritu Santo acanuullanu. ");
INSERT INTO zplNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nu enduꞌ enu acanuulla hualeelunu Jesuse. Xne equie cuendaꞌnu tsilaꞌa ye bee bene lachinu Israel lu stula beella. ");
INSERT INTO zplNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ye bee nucuaꞌ unga para nú yalu Stichiaꞌ Diose tucu nú uni tucu bee profetaꞌnu chenu unilla: ");
INSERT INTO zplNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tucu unaꞌa eꞌne chuꞌu enduꞌ xlaꞌcu nu chenu ala enduꞌlla, chiuꞌuleenu Emanuel, bedichiaꞌ cuaꞌ rni: Diose nzu cuna liaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Chenu uhuañi José, che uriꞌilla tucu nú unibiyaꞌ ángeleꞌ Diose lulla nú riꞌilla, nu uyuculla María. ");
INSERT INTO zplNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero né naꞌtsella María hasta nú ungula enduꞌ María, nu ulualee José enduꞌcuaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ungula Jesuse Belén, tucu eyeche nú nchiucuꞌ lu iliu Judea, tiembu nú unibiyaꞌ arre Herodes. Nu uriña bee bene enu reca elliebacuꞌ Jerusalén, nzeꞌta beella enza rliñi bichia Jerusalén nu neca beella magos, ");
INSERT INTO zplNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","che unidichiaꞌ beella: ―¿Cá nchiucuꞌ arreꞌ bee bene Israel enu ungula? Xne desde lachiru ulañiꞌlaꞌru nú uliñi belaꞌnu, enzeꞌe nzelaru para nú luꞌcuru ulaꞌna lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chenu ubeneꞌ arre Herodes nú unibeella scua, chiquiꞌ nzenu arquiꞌlla, cuna ye bee bene Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Che ubixia arre Herodes ye bee uleꞌya enu rnibiyaꞌ, cuna bee ulaxcuela enu reca ley nú udeteꞌ Diose lu Moisés para nú nedichiaꞌlla lubeella cá riala nú ala Cristo. ");
INSERT INTO zplNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Che uni beella lulla: ―Eyeche Belén nú nchiucuꞌ lu iliu Judea alanu, xne scua uni profeta chenu unilla: ");
INSERT INTO zplNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Liꞌilu eyeche Belén nú nchiucuꞌ lu iliu Judea, nu liꞌilu la necalu tucu bee eyeche nú mase lleꞌna nú nchiucuꞌ lu ye bee eyeche llene lu iliu Judea. Xne lulu chiuꞌu tucu bene enu nibiyaꞌ, nu liꞌilla biꞌyalla bee bene Israel enu neca bee benea. ");
INSERT INTO zplNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Che chu ubixia aꞌchi arre Herodes bee mago cuaꞌ para nú unedichiaꞌlla lubeella nú xunga itáa ulubeꞌlu belaa zeꞌe lubeella. ");
INSERT INTO zplNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nu uxeꞌlalla liꞌibeella Belén, nú unilla lubeella: ―Uquiahua zeꞌe, nu riꞌi itáahua beyaꞌ nú xa neca lu cuendaꞌ enduꞌ zeꞌe. Nu chenu ullelaꞌlaꞌhuanu, yeꞌta tixiuleꞌehua lua para nú leꞌca nua nzaꞌa nze detea ulaꞌna lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chenu ulaxu nú uni arre Herodes scua lubeella, chu nzuebeella. Nu belaa enu ulañiꞌ beella nú uliñi desde nú nucuaꞌascaꞌ beella lachi beella nzuculu lubeella, nu utsuxe belaa cuaꞌ hasta elu nchiucuꞌ enduꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Chenu ulañiꞌ bee mago belaa cuaꞌ zeꞌe, chiquiꞌ ñia utsu arquiꞌbeella, ");
INSERT INTO zplNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","nu chenu uyuꞌu beella liñi niꞌi zeꞌe, ulañiꞌ beella enduꞌ cuna naꞌnu María, che utsulliqui beella lunu nu uluꞌcu beella ulaꞌna lu enduꞌ zeꞌe. Chu uxaꞌla beella ruꞌu bee caja nú nuyaꞌ beella nu lia udeteꞌ beella oro, cuna quiendixi, cuna mirra lu enduꞌ meꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Che udixiuleꞌe Diose lu xcalaꞌ beella nula benchilaꞌ beella lu Herodes, nu né benchilaꞌ beella enza enta beella. ");
INSERT INTO zplNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chenu nziala bee mago zeꞌe lachi beella, che ulubeꞌlu tucu ángeleꞌ Diose lu xcalaꞌ José, nu uni ángele zeꞌe lulla: ―Uzetee, uyaꞌ enduꞌ cuaꞌ cuna naꞌnu nu uquiahua Egipto, zeꞌe cuaꞌahua hasta nú ixiuleꞌa luhua. Xne cuaꞌna Herodes enduꞌcuaꞌ para nú utilla liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Che chu uzete José, nu unguyaꞌlla enduꞌ cuna naꞌnu, nu rulaꞌ zeꞌe uchiuꞌu beella nziue beella enza Egipto. ");
INSERT INTO zplNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Zeꞌe ucuaꞌa beella hasta nú unguti arre Herodes. Scua unga para nú uyalu Stichiaꞌ Diose tucu nú uninu lu tucu profeta chenu uninu: “Ubixia endua enza Egipto.” ");
INSERT INTO zplNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chenu uriꞌi Herodes beyaꞌ nú uzequienu bee mago zeꞌe liꞌilla, chiquiꞌ uleella, nu unibiyaꞌlla nú unguti ye bee enduꞌ enu nza chiucu lana hasta enu meꞌe enu nucuaꞌa Belén cuna bee eyeche abenchilaꞌ zeꞌe, xne nuyaꞌ cuendalla lunú uni bee mago zeꞌe lulla nu udetela chiucu lana nú ulubeꞌlu belaa zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Scua uyalu tucu nú uquieꞌe profeta Jeremías chenu unilla: ");
INSERT INTO zplNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Uyene tucu chii eyeche Ramá, nú runaꞌ nu rixiali. Nu Raquel neca enu runaꞌ cuaꞌ equie cuendaꞌ bee enduꞌnchu, nu lecati enu riꞌi ana tsala arquiꞌnchu xne ungutila bee enduꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pero chenu unguti arre Herodes, che ulubeꞌlu tucu ángeleꞌ Diose lu José elu nucuaꞌa beella Egipto nu uni ángele zeꞌe lulla: ");
INSERT INTO zplNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Uzetee, uyaꞌ enduꞌ cuna naꞌnu, nu ubenchilaꞌ zecahua Israel xne ungutila bee enu niarquiꞌ nú uti enduꞌ quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Che chu uzetee José nu unguyaꞌlla enduꞌ cuaꞌ cuna naꞌnu nu ubenchilaꞌ beella eyeche Israel. ");
INSERT INTO zplNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero chenu ungabiyaꞌ José nú Arquelao llianaꞌ arre Herodes neca enu rnibiyaꞌ lu iliu Judea, ulliquilla nú challa enza zeꞌe. Pero chenu ungabiyaꞌlla lu xcalaꞌlla nú la challa enza Judea, che nzuella enza lu iliu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chenu uriña beella lu iliu Galilea, ucuaꞌa beella tucu eyeche nú lee Nazaret. Scua unga para nú uyalu tucu nú uni bee profeta nú Jesuse chiulee bene Nazaret. ");
INSERT INTO zplNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tiembu zeꞌe uyanzee Juan Bautista lu dañi achi lu iliu Judea udixiuleꞌella Stichiaꞌ Diose lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nu unilla: ―Utsanaꞌ arquiꞌhua stulahua xne nzeꞌta riñala nú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Equie cuendaꞌ Juan Bautista quieꞌ, uquieꞌe profeta Isaías chenu unilla: Uyene chi tucu enu juerte rixiali lu dañi achi elu la nucuaꞌa bee bene nú rni: “Utsu tsiñahua arquiꞌhua xne nzeꞌtala liꞌinu enu neca Dioseꞌahua, utsanaꞌ arquiꞌhua stulahua para nú yucu arquiꞌhua stichiaꞌnu.” ");
INSERT INTO zplNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Xucu Juan necacheꞌe ichia tsuꞌ camello, nu sinchiu nú riuꞌu xlaꞌculla necacheꞌ iti, nu elubacu nú udaculla neca xeꞌchiu cuna lliña dañi. ");
INSERT INTO zplNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nu bee bene Jerusalén cuna ye bee bene lu iliu Judea nu cuna bee bene enu nucuaꞌa axu reꞌcu Jordán uchiuꞌu beella, uya beella ubeneꞌ beella nú rni Juan. ");
INSERT INTO zplNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Chequie chenu uxucuꞌ dula beella stula beella, urinza Juan liꞌibeella reꞌcu Jordán. ");
INSERT INTO zplNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero chenu ulañiꞌ Juan nú huaxi bee fariseo cuna saduceo uriña lulla para nú rinzalla beei, che unilla lubeei: ―¡Liꞌisihua netsiñahua xi netsiña bee beꞌla! ¿Ti udixiuleꞌe luhua nú tsilaꞌahua lu castiya juerte nú axula nzu zeca bee bene? ");
INSERT INTO zplNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Uhuañi nzeꞌcahua para nú aca chee nú neli utsanaꞌ arquiꞌhua stulahua, ");
INSERT INTO zplNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","nula aca nelliñahua nú rnihua: “Liꞌiru nzelaru lu familiaꞌ tuxie Abraham”, xne liꞌá nia luhua nú hasta bee quiee quieꞌ nuꞌ modo nú riꞌi Diose nú aca bee familiaꞌ tuxie Abraham. ");
INSERT INTO zplNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nu bee bene enu la zucuꞌ Stichiaꞌ Diose tucu nú rialane, liꞌinu riꞌinu lubeella tucu nú rriꞌinu bee bene aca nú la ayuaꞌ ndixilu, xiecuꞌ benene para nú chiquine. ");
INSERT INTO zplNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Liꞌá, rniaa luhua nú liꞌá rrinzahua cuna inza xineca tucu seña nú utsanaꞌ arquiꞌlahua stulahua, pero enu nzeꞌta lulá liꞌinu rinzanu liꞌihua cuna Espíritu Santo nu cuna quii. Liꞌinu maselá rluꞌcunu poder luquela liꞌá, enzeꞌe niꞌ nú hua lucunu la yala xne masela neca equienu luquela liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nu tucu nú rcuii bene trigo scua riꞌinu Diose bee bene. Nu bee bene enu sanaꞌ arquiꞌ stula huañi bee nzeꞌe elurnibiyaꞌ Diose, nu bee bene enu la tsanaꞌ arquiꞌ stula necala nú cha beei lu quii nú leca xunga yala. ");
INSERT INTO zplNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Che uchiuꞌu Jesuse Galilea para nú nzanu lu Juán reꞌcu Jordán, para nú rinzalla liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero chenu uriñanu lu Juan lá zela Juan arinza liꞌinu, nu unilla lunu: ―Liꞌilu riala rinzalu liꞌá, ¿nu liꞌá la yala rinza liꞌilu? ");
INSERT INTO zplNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chequie uni Jesuse lulla: ―Uzela nú acane scua, xne mase neca nzeꞌca nú riaꞌa ye tucu nú rnibiyaꞌ Diose. Chee uzela Juan urinza liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Chenu ulaxu nú urinzalla Jesuse, nu uchiuꞌunu lu inza, tuꞌnatsia uyaꞌla liñibe, nu ulañiꞌnu nú nzeꞌta laca Espíritu Santoꞌ Diose xi naa tucu paloma equienu. ");
INSERT INTO zplNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nu ubene tucu chii enu uni hasta liñibe: ―Liꞌinu necanu lliꞌñia enu chiquiꞌ seꞌcaa, nu ñia nzu arquia lu. ");
INSERT INTO zplNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Luzeꞌelá unguyaꞌ Espíritu Santo Jesuse lu dañi achi elu la nucuaꞌa bee bene para nú riꞌi bezeꞌlu preu liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Zeꞌe uyaꞌna Jesuse chiuꞌa bichia nu chiuꞌa rulaꞌ nu lecalí xi udacunu nu che uliaꞌnaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chequie uya bezeꞌlu lunu para nú riꞌi preu liꞌinu nu uni lunu: ―Tunu neli nú necalu lliꞌñi Diose, unibiyaꞌ nú aca bee quiee quieꞌ pá aculu. ");
INSERT INTO zplNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero ucuaqui Jesuse lu bezeꞌlu: ―Lu ichiꞌ Stichiaꞌ Diose rni: “La neca equie cuendaꞌtsia pá nehuañi bee bene, sino que leꞌca nehuañi bee bene lu cuendaꞌ ye bedichiaꞌ nú rni Diose.” ");
INSERT INTO zplNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Che chu uyanu bezeꞌlu liꞌinu eyeche Jerusalén nu uquienui liꞌinu equie indu llene Jerusalén elu mase aya, ");
INSERT INTO zplNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nu uni lunu: ―Tunu neli nú necalu lliꞌñi Diose, utsiꞌqui liꞌilu caꞌa hasta lu yuu, xne lu ichiꞌ Stichiaꞌ Diose rni: Xeꞌla Diose bee ángeleꞌnu para nú riꞌi ucu liꞌilu. Nu naꞌtse beenu liꞌilu para nú la tiꞌqui bee quiee cuchiuꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Che ucuaqui Jesuse lu bezeꞌlu: ―Leꞌca rni lu ichiꞌ Stichiaꞌ Diose: “La riꞌilu preu Diose Pa liñibe.” ");
INSERT INTO zplNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nu leꞌca uyanu bezeꞌlu liꞌinu equie tucu dañi elu aya, nu zeꞌe ulubeꞌi lunu nzieꞌ bee eyeche nú nuꞌ lu iliulabe cuna bee eluxene nú nuꞌ lubee, ");
INSERT INTO zplNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","nu uni lunu: ―Liꞌá liquia ye bee nucuaꞌ lulu, tunu tsulliquilu lua nu luꞌculu ulaꞌna lua. ");
INSERT INTO zplNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nu uni Jesuse lui: ―Uquia bezeꞌlu, xne lu ichiꞌ Stichiaꞌ Diose rni: “Uluꞌcu ulaꞌna lu Dioseꞌlu Pa liñibe, nu lu liꞌitsianu riala nú zibiꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chequie utsaꞌna bezeꞌlu liꞌinu, nu uriña bee ángeleꞌ Diose uriꞌi elietsa lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chenu ungabiyaꞌ Jesuse nú nchiñi Juan Bautista niꞌcuꞌ, che chu nzazecanu lu iliu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero né yaꞌnanu Nazaret, sino que uyanu uzucunu eyeche Capernaum, tucu eyeche nú nchiucuꞌ ruꞌu inzatuꞌ Galilea enza lu iliu nú lee Zabulón nu Neftalí. ");
INSERT INTO zplNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Scua ungae para nú uyalu tucu nú uquieꞌe profeta Isaías chenu unilla: ");
INSERT INTO zplNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Bee bene lu iliu Zabulón nu bee bene lu iliu Neftalí, nu bee bene enu nucuaꞌa lu iliu nú nchiucuꞌ axu reꞌcu Jordán, cuna ye beelá bee bene enu nucuaꞌa axu ru'u inzatu' lu iliu Galilea elu nucuaꞌa bee bene enu laca bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ye beella uhuañi beella tucu nú nehuañi bee bene enu nucuaꞌa leta rulaꞌ, pero nee ulubeꞌlula tucu ellieꞌe lubeella, nu ellieꞌe cuaꞌ uduꞌllieꞌe lu elliebacuꞌ beella, liꞌibeella enu lecaxi utsuquie nú xi liquiꞌ Diose lubeella. ");
INSERT INTO zplNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Desde che uquixie uzeteꞌ Jesuse Stichiaꞌ Diose bee bene nu uninu lubeella: ―Tsanaꞌ arquiꞌhua stulahua xne nzeꞌta riñala elurnibiyaꞌ nú rluꞌcu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Chenu nzedete Jesuse ruꞌu inzatuꞌ Galilea, che ulañiꞌnu Simón, enu leꞌca lee Pedro, cuna bichilla Andrés, nú rduꞌbeella ixiu nú rucu beella bee bela lu inza. ");
INSERT INTO zplNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nu uni Jesuse lubeella: ―Te quiehua liꞌá para nú zeteahua xa quieteꞌsaꞌhua bee bene para nú aca beella bee benea luguare nú rucuhua bee bela. ");
INSERT INTO zplNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hora zeꞌe utsaꞌna beella ixiu nú rucu beella bela nu chu nzuebeella cuna liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Enza luzeꞌelá ulañiꞌnu xiucu bee bene, Jacobo nu cuna bichilla Juan, llianaꞌ bene enu lee Zebedeo. Nucuaꞌa beella liñi barco cuna paꞌ beella, rquielaꞌ beella ixiu nú rucu beella bee bela. Nu ubixia Jesuse beella, ");
INSERT INTO zplNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nu hora zeꞌe chu utsaꞌna beella barco zeꞌe cuna saꞌbeella, nu chu nzequie beella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Uya Jesuse ye lubee eyeche lu iliu Galilea, nu cada tucu bee eyeche uyuꞌunu liñi bee indu uzeteꞌnu bee bene Stichiaꞌ Diose, nu uninu lubeella xa neca elurnibiyaꞌ nú rluꞌcu Diose nu uriyecanu bee bene luye clasiaꞌ elichia nú seca beella. ");
INSERT INTO zplNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ungabiyaꞌ ye bee bene lu iliu Siria lunú uriꞌi Jesuse, che ubeꞌtayu bee bene zeꞌe bee bene enu seca huaxi clasiaꞌ bee elichia lunu, leꞌca ubeꞌtayu beella bee bene enu siꞌ nú rcu cuerpoꞌ, cuna bee bene enu seca ichiaꞌ benechiquiꞌ, cuna bee bene enu seca ichia ziña cuna bee bene enu la acalí tsee nu uriyeca Jesuse ye bee bene cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Huaxi bee bene enu nucuaꞌa lu iliu Galilea, cuna bee bene enu nzeꞌta enza lubee eyeche Decápolis, cuna bee bene Jerusalén cuna bee bene enu nucuaꞌa lu iliu Judea nu bee bene enu nucuaꞌa stucu chú reꞌcu Jordán, uyaquie liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chenu ulañiꞌ Jesuse ye bee bene cuaꞌ, uquienu equie tucu dañi nu uzucunu zeꞌe. Che uyetesaꞌ bee beneꞌnu lunu zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nu uquixienu uzeteꞌnu liꞌibeella nú uninu lubeella: ");
INSERT INTO zplNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ñia neca lu cuendaꞌ bee bene enu rriꞌi beyaꞌ nú chiquiꞌ rquiꞌñialla elietsaꞌ Diose, xne cuaꞌa beella liñibe elu rnibiyaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ñia neca lu cuendaꞌ bee bene enu nehuana nzu arquiꞌ, xne riꞌi Diose nú ñia tsu arquiꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ñia neca lu cuendaꞌ bee bene enu lleꞌna arquiꞌ, xne yucu beella yuu nú uni Diose nú deteꞌnu lubeella. ");
INSERT INTO zplNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ñia neca lu cuendaꞌ bee bene enu neca xi neca nú rliaꞌnaꞌ nu rebichiꞌ, scua nuꞌ ana arquiꞌbeella riꞌibeella tucu nú rnibiyaꞌ Diose, xne liꞌinu riꞌinu elietsa lubeella para nú riꞌibeella tucu nú niarquiꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ñia neca lu cuendaꞌ bee bene enu ruaꞌa arquiꞌ bee bene, xne leꞌca huaꞌa arquiꞌ Diose liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ñia neca lu cuendaꞌ bee bene enu lecaxi naa lu Diose, xne liꞌibeella neca beella enu lañiꞌ liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ñia neca lu cuendaꞌ bee bene enu rcuaꞌna nú nzuxe arquiꞌ lusaꞌ, xne liꞌibeella chiuꞌuleebeella lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ñia neca lu cuendaꞌ bee bene enu nehuana seca luye nú rriꞌinu bee bene liꞌibeella equie nú rriꞌi beella tucu nú rnibiyaꞌ Diose, xne liꞌibeella chuꞌu beella liñibe elu rnibiyaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Ñia neca lu cuendaꞌhua chenu riquichiꞌquiꞌ bee bene liꞌihua, nu chenu xitserriꞌinu bee bene liꞌihua nu chenu rtaꞌ bee bene yelu clasiaꞌ bee eluquichiaꞌ liꞌihua, equie nú necahua bee benea. ");
INSERT INTO zplNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ñia utsu arquiꞌhua nu ullilaꞌhua, xne chiquiꞌ ñia neca nú lia liquiꞌ Diose luhua liñibe, nu liꞌihua nediyaꞌhua nú leꞌca scua uriꞌi condra beella bee profeta enu udetela enu uhuañi rlutila luquela liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Liꞌihua necahua xi neca zete lu iliulabequieꞌ. Pero tunu niti nú neriꞌi, ¿xa modo zibiꞌ zecae che? Lecaꞌ xi zibiꞌi, tsiꞌquitsia benene nu taꞌ bene equiee. ");
INSERT INTO zplNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Nu leꞌca liꞌihua necahua xi neca ellieꞌe lu iliulabequieꞌ, liꞌihua necahua xi neca tucu eyeche nú nchiucuꞌ equie tucu dañi nú leca modo nú ricu aꞌchiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lecati quieꞌe quii tucu quinqué nu tsacuꞌlla tucu caja equiee, rquiꞌña nú zucune aya para nú duꞌllieꞌe luye bee bene enu nucuaꞌa liñi niꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Leꞌca scua liꞌihua, ucuaꞌnahua nú huañi nzeꞌcahua lubee bene para nú chenu lañiꞌ beella beenú neca nzeꞌca rriꞌihua, che nibeella bee bedichiaꞌ nzeꞌca equie cuendaꞌ Paꞌahua Diose enu nzucu liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’La riꞌihua elliebacuꞌ nú uriña para nú huachua ley, ley nú udeteꞌ Diose lu Moisés urre beenú uzeteꞌ bee profeta bee bene, xne liꞌá uriña para nú tsalua tucu nú rni ley. ");
INSERT INTO zplNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Liꞌá rnia luhua nú mase fácil nú nitilu liñibe cuna iliulabe, luquelá nú rila tucu letra urre tucu punto nú nzeꞌta lu leyꞌ Diose, hasta nu yalu lunú nzu nú aca. ");
INSERT INTO zplNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Enzeꞌe bene enu la zucuꞌ tucu bee mandamiento nú nzeꞌta lu ley cuaꞌ, mase secalla nú la neca equie bee mandamiento cuaꞌ, nu leꞌca esquie tunu la zeteꞌlla bee bene nú zucuꞌe, chequie liꞌilla lleꞌnatsia aca neca equiella elurnibiyaꞌ Diose liñibe. Pero bene enu sucuꞌ ye bee mandamiento nú nzeꞌta lu ley cuaꞌ, nu seteꞌlla bee bene nú zucuꞌe, liꞌilla acalla enu máse aca neca equie elurnibiyaꞌ Diose liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Enzeꞌe nia luhua nú tunu la nehuañi nzeꞌcaláhua luquelá bee ulaxcuela enu reca ley cuna bee fariseo leca modo chuꞌuhua liñibe elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Liꞌihua nediyaꞌlaꞌhua lunú uni Moisés lubee beneꞌahua enu udetela: “La uti bene saꞌ bene, xne bene enu ruuti saꞌ yalalla castiya.” ");
INSERT INTO zplNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero liꞌá nia luhua nú titse bene enu rana arquiꞌsaꞌ, challa lu usticia, nu leꞌca titse bene enu rquiexuusaꞌ, rquiꞌña nú dete bene zeꞌe lu usticia enu mase neca equie para nú chiulue lu cuendaꞌlla, leꞌca titse bene enu rni bedichiaꞌ chiꞌquiꞌ lusaꞌ nzucheꞌ nú challa lu quii ebila. ");
INSERT INTO zplNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Enzeꞌe, tunu nzeyulu uꞌna ruꞌu ecuꞌcuꞌ Diose nu ulluꞌcu arquiꞌlu nú rlelu lu bene, ");
INSERT INTO zplNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","utsaꞌnascaꞌ uꞌnaꞌlu zeꞌe. Nu uquiatsalaxuhua arquiꞌ saꞌhua, che benchilaꞌlu nu deteꞌlu uꞌna lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tunu nuꞌ ti deteꞌ cuenda liꞌilu lu juese, ante nú chahua lu juese utsucheꞌxuhua nucuaꞌ diquila nú nuꞌ tiempo para nú la deteꞌ cuendalla liꞌilu lu juese, xne tunu deteꞌ cuenda benecuaꞌ liꞌilu lu juese che juese deteꞌcuenda liꞌilu lu policía para nú chalu niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Liꞌá nia lulu nú la chiuaꞌlu niꞌcuꞌ hasta nú ixiuxulu nzieꞌ dimi nú nacuꞌ juese lulu. ");
INSERT INTO zplNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Liꞌihua nediyaꞌlaꞌhua nú rni lu ley: “La luꞌcu niyu stucu unaꞌa enu la neca unaꞌi, nu la luꞌcu unaꞌa stucu niyu enu la neca niyuꞌnchu.” ");
INSERT INTO zplNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero liꞌá nia luhua nú titse bene enu riꞌyatsia lu tucu unaꞌa nu rriꞌilla elliebacuꞌ nú necha neca chenu riꞌyalla lu tucu unaꞌa, uriꞌilalla dula arquiꞌlla lu cuendaꞌnchu che. ");
INSERT INTO zplNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Tunu rriꞌi iꞌcululu chube nú rriꞌilu dula, neca nzeꞌcalá nú uhuane nu utsiꞌquii istu. Xne neca nzeꞌcalá nú nitilu tucutsia iꞌcululu luquela nú diquinecalu chálu ebila. ");
INSERT INTO zplNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nu tunu rriꞌi yalu chube nú rriꞌilu dula, uchieꞌcue nu utsiꞌquii istu. Xne neca nzeꞌcalá nú nitilu techu yalu luquela nú cha diquilu ebila. ");
INSERT INTO zplNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Leꞌca rni lu ley: “Titse bene enu leꞌe unaꞌa, rquiꞌña nú hualla tucu ichiꞌ elu rni nú uleꞌella unaꞌalla.” ");
INSERT INTO zplNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero liꞌá nia luhua nú tunu tucu niyu leꞌe unaꞌa, nula necane nú uriꞌi unaꞌalla eluhuexe cuna stucu niyu, che leꞌca liꞌilla uriꞌilla nú rluꞌcu unaꞌalla stucu niyu. Nu niyu enu xia tucu unaꞌa enu lá acaxeelá uleꞌe niyuꞌ, rriꞌilla dula. ");
INSERT INTO zplNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Leꞌca nediyalaꞌhua nú uni Moisés lubee beneꞌhua enu udetela: “Rquiꞌña nú tsaꞌalu bene lunú unilla nú riꞌilla chenu rquieꞌella Diose nú riꞌilla.” ");
INSERT INTO zplNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero liꞌá nia luhua nula quiꞌña nú quieꞌehua dioseꞌhua nú nihua ista liñibe riꞌya, para nú aca achee nú neli nú rnihua xne liñibe nzucu Diose, ");
INSERT INTO zplNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nu niꞌ lu yuu, xne necane elu nzu eꞌyanu, nu niꞌ eyeche Jerusalén, xne necane lachinu, liꞌinu enu neca arre enu mase rnibiyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nu niꞌ la yala quieꞌe bene equie cuendaꞌ lluca equie bene, xne leca modo nú riꞌi bene nú aca nequichi urre aca naatsa niꞌ tucu ichia equiella. ");
INSERT INTO zplNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mejora uniꞌhua, “aahua” urre “aꞌa”, xne ye beela bee bedichiaꞌ nú nihua nzeꞌtae lu cuendaꞌ bezeꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Leꞌca ubeneꞌlaꞌhua bedichiaꞌ nú rni: “Enu lua iꞌcululu, leꞌca ulua iꞌculu nzeꞌe. Nu enu lua layalu, leꞌca ulua laya nzeꞌe.” ");
INSERT INTO zplNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero liꞌá nia luhua: Nú la duseꞌehua nú necha neca cuna nú necha neca, tunu nuꞌ enu duꞌ tucue xecalu chube, uzela nú duꞌllae stucu chú xecalu. ");
INSERT INTO zplNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tunu nuꞌ bene enu rliunuu liꞌilu para nú axilla lliacaꞌlu, uzela nú leꞌca uyaꞌlla chiamarraꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tunu ti rriꞌi juersa liꞌilu nú uyaꞌlu steneꞌlla tucu kilometro, uyaꞌe stucu kilometro. ");
INSERT INTO zplNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Titse bene enu rnacuꞌ tucu elietsa lulu, uriꞌi elietsa lulla, nula aca nechiquiꞌlu chenu xi riꞌñalla lulu. ");
INSERT INTO zplNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Leꞌca ubeneꞌhua bedichiaꞌ nú rni: “Uzeca bene enu seca liꞌilu nu uhuana arquiꞌ bene enu rana arquiꞌ liꞌilu.” ");
INSERT INTO zplNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero liꞌá nia luhua: Uzecahua bene enu rle luhua, nu niꞌhua nú cha nzeꞌca lu cuendaꞌ bene enu rnacuꞌ nú la cha nzeꞌca lu cuendaꞌhua, uriꞌi nzeꞌcahua lubee bene enu rana arquiꞌ liꞌihua, unaꞌcuhua lu Diose lu cuendaꞌ bee bene enu riquichiꞌquiꞌ liꞌihua nu xitse rriꞌinu liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Scua acahua lliꞌñi Diose paꞌhua enu nzucu liñibe, xne liꞌinu rriꞌinu nú rliñi bichia para yebee bene enu rriꞌi nzeꞌca nu cuna lubee bene enu la riꞌi nzeꞌca, nu rriꞌinu nú rlaca quiu para bee bene enu rriꞌi nzeꞌca nu cuna lubee bene enu la riꞌi nzeꞌca. ");
INSERT INTO zplNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Xne tunu secatsiahua bee bene enu seca liꞌihua, ¿xi atiꞌhua lu Diose che? Xne hasta bee bene enu rriꞌi cobre equie impuesto rriꞌi scua. ");
INSERT INTO zplNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nu tunu rnihua Diose lubee saꞌtsiahua, lecaxi nú neca nzeꞌca rriꞌihua, xne hasta bene enu la chulu Diose rriꞌi scua. ");
INSERT INTO zplNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aca nzeꞌcahua tucu nú nzeꞌca paꞌhua Diose enu nzucu liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ubiꞌyahua nu la riꞌihua lunú neca nzeꞌca lubee bene para nú lañiꞌtsia beei lunú xa rriꞌihua. Xne tunu rriꞌihua scua, paꞌhua Diose enu nzucu liñibe lecaꞌ xi liquiꞌnu luhua. ");
INSERT INTO zplNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Enzeꞌe chenu rriꞌilu elietsa lubee bene enu rquiꞌña elietsa, la tiꞌchia dichiaꞌlue para nú acabiyaꞌ bee bene nú xi rriꞌilu, xi rriꞌi bee bene enu nequichiaꞌ liñibee indu cuna labe inziu para nú zucuꞌ aya bee bene liꞌibeei, pero liꞌá nia luhua nú nucuaꞌ neca premioꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Enzeꞌe chenu rriꞌilu elietsa lubee bene enu rquiꞌña nú riꞌilu elietsa lu, la tiꞌchia dichiaꞌlu nucuaꞌ lubee bene, pero niꞌ lu bene enu máse rquieteꞌlu la nilu nú rriꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mase neca nzeꞌca nú liꞌitsialu nediyaꞌlu lunú rriꞌilu, nu Paꞌlu Diose enu riꞌya lunú liꞌitsialu rriꞌilu, liꞌinu liá liquiꞌnu premio nú rialalu. ");
INSERT INTO zplNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Nu chenu nacuꞌhua lu Diose, la riꞌihua xi rriꞌi bee bene enu nequichiaꞌ, nú riuꞌ arquiꞌbeella nú nzulí beella rnacuꞌ beella lu Diose liñi bee indu, nu bee squiñia inziu para nú lañiꞌ bee bene lunú rriꞌi beella. Xne liꞌá nia luhua lunú rriꞌi beella scua nucuaꞌ neca premioꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero liꞌilu chenu nacuꞌlu lu Diose, uyuꞌu liñi niꞌi, nu utsaꞌcu puerta nu unaꞌcuꞌ lu Diose enu nzu cuna liꞌilu. Nu liꞌinu enu riꞌya lunú liꞌitsialu rriꞌilu, liꞌinu lia liquiꞌnu premio nú rialalu. ");
INSERT INTO zplNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Chenu rnacuꞌlu lu Diose, la nilu bee bedichiaꞌ nú la zibiꞌ huaxi bese, xi rriꞌi bee bene enu la chulu Stichiaꞌ Diose. Xne seca beella nú tunu huaxi bese rni beella tucu bedichiaꞌ che máse riꞌi caso Diose nú rni beella. ");
INSERT INTO zplNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","La riꞌihua tucu nú rriꞌi beella, xne paꞌhua Diose nediyaꞌlaꞌ xi rquiꞌñahua ante nú nacuꞌhuane lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Enzeꞌe chenu nacuꞌhua lu Diose uniꞌhua: Pa Diose liꞌilu enu nzucu liñibe, Chiquiꞌ riala nú luꞌcuru ulaꞌna lunú leelu. ");
INSERT INTO zplNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nu yeꞌta nú rnibiyaꞌlu luru. Nu aca tucu nú riuꞌ arquiꞌlu lu iliulabe, tucu nú reca liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Uliꞌquiꞌ elubacu nú daꞌcuru yebichia. ");
INSERT INTO zplNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nu uriꞌi perdona nú necha rriꞌiru tucu nú leꞌca rriꞌiru perdona bee bene enu necha rriꞌi luru. ");
INSERT INTO zplNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","La zelalu nú riꞌiru dula, sino que uriꞌi elietsa luru para nú la riꞌi ye beenú necha neca ana luru. Xne liꞌilu rnibiyaꞌlu, nu liꞌilu rluꞌculu poder, poder nú leca xunga laxu. Amén. ");
INSERT INTO zplNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Xne tunu rriꞌihua perdona bee bene enu rriꞌi nú necha neca luhua, leꞌca scua Paꞌahua Diose enu nzucu liñibe riꞌi perdona liꞌihua; ");
INSERT INTO zplNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","pero tunu liꞌihua la riꞌihua perdona bee bene enu rriꞌi nú necha neca luhua, leꞌca la riꞌi Diose Pa liñibe perdona stulahua che. ");
INSERT INTO zplNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Chenu la acuhua equie nú rluꞌcuhua ulaꞌna lu Diose, la ricuꞌ nehuanahua luhua tucu nú nehuana reca lubee bene enu nequichiaꞌ, rriꞌi beei scua para nú lañiꞌ bee bene nú la acu beei equie nú rluꞌcu beei ulaꞌna lu Diose. Pero liꞌá nia luhua nú nucuaꞌtsia necala premioꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero liꞌilu, chenu la aculu equie nú rluꞌculu ulaꞌna lu Diose, udiꞌñi nu uriꞌcucheꞌ equielu, ");
INSERT INTO zplNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","para nú la riꞌi bee bene beyaꞌ nú la aculu lunú rluꞌculu ulaꞌna lu Diose. Tucutsia Pa Diose enu nzu cuna liꞌilu liꞌitsianu riala acabiyaꞌnu lunú rni liꞌitsialu, nu liꞌinu liquiꞌnu premio nú rialalu. ");
INSERT INTO zplNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’La laꞌnahua nú luꞌcuhua huaxi eluxeneꞌhua lu iliulabe quieꞌ, elu acu bee belalaꞌe nu nitilue, nu chuꞌu bee huanaꞌ cachiꞌ bee. ");
INSERT INTO zplNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mejora ucuaꞌnahua nú riꞌihua ana eluxene nú nuꞌ liñibe, elu leca bee belalaꞌ para nú acune, nu leꞌca lecaxi nitilu zeꞌe nu la chuꞌu bee huanaꞌ zeꞌe para nú cachiꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Xne lu eluxeneꞌhua zeꞌe nzu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Iꞌculuaꞌahua neca xi neca ellieꞌe lu cuerpoꞌahua, nu tunu rriꞌi bene lunú neca nzeꞌca, diqui cuerpoꞌ bene nuꞌ ellieꞌe, ");
INSERT INTO zplNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","pero tunu rriꞌilu lunú necha neca, diqui cuerpoꞌlu neca xi neca nú nzu leta xcabe, ¡Leta xcabe nú naatsacabelí! ");
INSERT INTO zplNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Niꞌ tucu mosoꞌ leca modo riꞌi riñaꞌ lu chiucu patrón, xne leei lu tuculla, nu stuculla zecai, urre riꞌi nzeꞌcai lu tuculla, nu lu stuculla la riꞌi nzeꞌcai. Enzeꞌe leca modo nú zibiꞌhua lu Diose nu tsu arquiꞌhua lu dimi. ");
INSERT INTO zplNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Liꞌá nia luhua: La chenu arquiꞌhua lunú xi acuhua cuna nú xi hueꞌhua para nú huañihua. Leꞌca la chenu arquiꞌhua lu cuendaꞌ xucuhua nú utuhua. Máse seca lunú nehuañi bene luquela nú racu bene, nu cuerpoꞌ bene máse seca luquela xucu bene. ");
INSERT INTO zplNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Biꞌyacuruhua bee iñi enu rcuecuꞌ liñibe. La duꞌ beeí nii nula riꞌi beeí ulaꞌcu, nu la luꞌcu beeí elu chucheꞌe, pero Paꞌahua Diose enu nzucu liñibe lia rdeteꞌnu nú racu beeí. ¿Enzaláquieꞌ liꞌihua nú másescaꞌlá secahua luquela bee iñi? ");
INSERT INTO zplNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nu leꞌca esquie, ¿xieꞌ lianú máse chiquiꞌ nzenu arquiꞌhua nú duñilahua lleꞌna la? ");
INSERT INTO zplNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Xinu nzenu arquiꞌhua lunú xi utuhua? Ubiꞌyacuruhua xa rruꞌcu bee quie dañi, la riꞌi bee riñaꞌ nu la recheꞌe xi utune, ");
INSERT INTO zplNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","pero niꞌ arre Salomón luye nú ñia utsucheꞌlla, né tsucheꞌlla tucu nú ñia nzucheꞌ bee quie. ");
INSERT INTO zplNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nu tunu sucheꞌe Diose bee huañi scua, nú nee nuꞌe dañi nu yeꞌe chiquine. ¡Enzaláquieꞌ liꞌihua bee bene enu lleꞌnatsia nzeli arquiꞌ liꞌinu, nú la tsucheꞌnu liꞌihua scua! ");
INSERT INTO zplNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Enzeꞌe, la chenuaꞌ arquiꞌhua nú rnihua: “¿Xi daꞌcuahua nee? nu ¿xi diyaꞌahua? nu ¿xi utuꞌahua?” ");
INSERT INTO zplNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Xne bee bene enu la chili arquiꞌ Diose nzenu arquiꞌ ye bee nucuaꞌ, pero liꞌihua rluꞌcuhua tucu paꞌhua liñibe, nu liꞌinu nediyaꞌ nzeꞌcanu nú xi seca laꞌchaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pero uzuꞌcuꞌhua nú rni Diose nu uriꞌihua tucu nú niarquiꞌnu che liquiꞌnu ye nú seca laꞌchaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","La chenu arquiꞌhua lu cuendaꞌ bichia yeꞌe, xne ye yeꞌe nuꞌ xi nzenu arquiꞌ bee bene. Xne cada bichia nuꞌ xi chenu arquiꞌ bene. ");
INSERT INTO zplNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Nu la zeꞌtahua saꞌhua para nú lecati zeꞌta liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Xne tucu nú seꞌtahua bee bene, leꞌca scua zeꞌta bee bene liꞌihua, nu tucu nú rriꞌinuhua bee bene leꞌca esquie riꞌinu bee bene liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿La zeꞌtahua beelá bee bene lunú lleꞌnatsia rriꞌi beella, nzalá nú uyanu arquiꞌhua lunú llenelá falta nú rluꞌcuhua? ");
INSERT INTO zplNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nu tunu llenelá falta nú rluꞌcuhua, ¿xa modo nihua lu stucu bene: “La neca nzeꞌca lunú rriꞌilu scua”? ");
INSERT INTO zplNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Bene enu nequichiaꞌ! Rluti uriꞌi tucu nú necane, che nuꞌ modo nilu lu stucu bene la yala nú riꞌilu scua. ");
INSERT INTO zplNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’La riꞌihua juersa bee bene enu la niarquiꞌ riꞌi caso lunú neca cuendaꞌ Diose, para nú lecaxi riꞌinu beei liꞌihua. Xne tunu riꞌihua juersa beei, neca nucuaꞌ xi neca chenu siꞌqui bene tucu nú necachi neca lu nicu. Leꞌca la riꞌihua juersa bee enu la yuꞌ arquiꞌ lunú neca cuendaꞌ Diose. Xne tunu riꞌihua juersa beei, neca nucuaꞌ xi neca chenu rduꞌ bene tucu nú huaxi seca lu cuchi nu tse tsiaí equiee. ");
INSERT INTO zplNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Unaꞌcuhua lu Diose che liquiꞌnu lunu rnacuꞌhua lunu, ulaꞌnahua liꞌinu nu che llelaꞌhua liꞌinu, uzequiehua lunu che riꞌi casonu liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Xne bene enu rnacuꞌ nú rnacuꞌ lunu yucu nzeꞌene, nu bene enu rlaꞌna Diose llelaꞌ nzeꞌe liꞌinu, nu bene enu rnacuꞌ nu sequie lunu, riꞌi casonu nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Xieꞌ nuꞌ ta tucuhua enu deteꞌ quiee acu enduꞌ chenu nacuꞌ enduꞌhua pa acu la? ");
INSERT INTO zplNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Urre xieꞌ deteꞌhua tucu beꞌla acu enduꞌhua chenu rnacuꞌ enduꞌhua bela acu enduꞌhua la? ");
INSERT INTO zplNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Liꞌihua enu la neca bene nzeꞌca, nuꞌluhua rdeteꞌhua nú neca nzeꞌca lubee enduꞌhua, ¡enzaláquieꞌ Paꞌahua Diose liñibe nú la liquiꞌnu nú neca nzeꞌca lubee bene enu rnacuꞌ nucuaꞌ lunu! ");
INSERT INTO zplNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Uriꞌihua lubee bene tucu nú niarquiꞌhua nú riꞌibeella luhua. Xne scua rnibiyaꞌ leyꞌ Diose cuna ye beenú uquieꞌe bee profetaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Uyuꞌuhua ruꞌu puerta nú nuxuꞌ neca. Xne ruꞌu puerta nú llene neca, nu inziu nú llene neca, nucuaꞌ neca nú ruyaꞌ liꞌibee bene lu inziu nú necha neca, nu huaxi bee bene nza inziu cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero puerta nu inziu nú ruyaꞌ bee bene lu elunehuañi meꞌe nu nuxuꞌe, nu la huaxi bee bene enu nza inziu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Leꞌca ubiꞌyahua liꞌihua lubee bene enu liꞌá rnibee nú neca beei profetaꞌ Diose, nu rriꞌi beei nú lleꞌna arquiꞌbeei, pero scuatsia rriꞌibeei para nú sequienu beei bee bene, nu chiquiꞌ necha rriꞌi beei. ");
INSERT INTO zplNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pero liꞌihua riꞌihua beyaꞌ nú xa neca bee bene cuaꞌ, lunú rriꞌi beei rixiuleꞌe núti neca beei, xne la ayu cuchiuꞌ lubeꞌ lubee aca eche, nu la ayu higo lubee huañi eche. ");
INSERT INTO zplNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Enzeꞌe ye bee aca nzeꞌca rayu ndixi nzeꞌca lu. Nu bee aca nu la neca aca nzeꞌca la ayu ndixi nzeꞌca lu. ");
INSERT INTO zplNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Leca modo nú ayu ndixi núla neca nzeꞌca lu aca nú neca nzeꞌca, leꞌca esquie la ayu ndixi nú neca nzeꞌca lu aca núla neca nzeꞌca. ");
INSERT INTO zplNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ye bee aca nú rayu ndixi nu la zibiꞌ lu, rrecuꞌe nu riuꞌe lu quii. ");
INSERT INTO zplNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Scua riꞌihua beyaꞌ ti neca beella equie nú rriꞌi beella. ");
INSERT INTO zplNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Laca ye bee bene enu rni lua: “Detá, Detá”, chuꞌu liñibe elurnibiyaꞌ Diose, sino que chuꞌutsia bee bene enu sucuꞌ lunú rni Diose Pa liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bichia zeꞌe huaxi bee bene ni lua: “Detá, Detá, liꞌiru uniru lunú leelu lubee bene, nu equie nú leelu uluaru bee benechiquiꞌ arquiꞌ bee bene nu equie nú leelu uriꞌiru huaxi bee milagro.” ");
INSERT INTO zplNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero chequie cuaquia lubeei: “Leca xunga uyulua liꞌihua, ullunaꞌhua lua, liꞌihua bee bene enu necha uriꞌi.” ");
INSERT INTO zplNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Enzeꞌe, bee bene enu rieneꞌ stichiaꞌa nu sucuꞌe, necalla xi neca tucu bene enu netsiña rrecheꞌ niꞌi equie quiee. ");
INSERT INTO zplNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Añinzuca nú rlaca quiu nu rlaca huaxi inza riuꞌu tetsuꞌ niꞌi zeꞌe nu reca bii, pero lá rila niꞌi zeꞌe xne nchiucuꞌ simienduꞌe equie quiee. ");
INSERT INTO zplNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero bene enu rieneꞌ nú rnia nu la zucuꞌ stichiaꞌa, liꞌilla necalla xi neca tucu bene enu netundu enu urecheꞌ niꞌi lu eyuxi. ");
INSERT INTO zplNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Chenu rlaca quiubi, nu rlaca huaxi inza riuꞌu tetsuꞌ niꞌi zeꞌe, che uluquie niꞌi zeꞌe. ¡Nu urilalii! ");
INSERT INTO zplNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chenu ulaxu nú uni Jesuse scua lubee bene zeꞌe, chiquiꞌ uyanu arquiꞌ ye beei xneca uzeteꞌnu liꞌibeei, ");
INSERT INTO zplNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","xne seteꞌnu beei xi seteꞌ tucu bene enu chiquiꞌ rluꞌcu poder, nu la zeteꞌnu xi seteꞌ bee ulaxcuela enu reca ley. ");
INSERT INTO zplNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Chenu ulaca Jesuse equie tucu dañi, huaxi bee bene uyanala liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nu che uyabica tucu bene enu seca elichia nú lee lepra lunu, che utsu lliquii lunu nu uni lunu: ―Detá, tunu chiuꞌu arquiꞌlu, nuꞌ beyaꞌ riyecalu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chequie uricuꞌ Jesuse yanu equie niyu zeꞌe nu uninu: ―Chiuꞌu arquia uyecaꞌ nee. Chenu uni Jesuse scua, hora zeꞌe uyecaꞌ bene zeꞌe nu lecaꞌ xi nalla. ");
INSERT INTO zplNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chequie uni Jesuse lulla: ―Uzuꞌcuꞌ diaca nú nia lulu, la ixiuleꞌelu lu niꞌtucu bee bene nú uyecaꞌlaꞌlu. Uquia lubeꞌtsia liꞌilu lu uleꞌya, nu uyaꞌ uꞌna lu Diose tucu nú unibiyaꞌ leyꞌ Moisés, para nú lañiꞌ bee uleꞌya nú uyecaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hora nú nzechuꞌu Jesuse eyeche Capernaum, uriña tucu capitán Roma lunu nu uzequiella lunu, ");
INSERT INTO zplNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","nu unilla lunu: ―Detá, mosoa nuxu nia riti nu lecaꞌ modo tsulii, chiquiꞌ nehuana secai nú ritii. ");
INSERT INTO zplNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nu uninu lu capitán: ―Liꞌá nzeriyecalla. ");
INSERT INTO zplNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chequie uni capitán zeꞌe lunu: ―Detá, la yala nú chuꞌulu nia. Pero uniꞌtsia tucu bedichiaꞌ desde caꞌa para nú yecaꞌ mosoa, ");
INSERT INTO zplNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","xne leꞌca sucua nú rni bee bene enu rnibiyaꞌ lua, nu leꞌca rluꞌcua nú rnibiyaꞌa lubee sundado. Chenu nia lu tucu beei nú cha nzeꞌe elu cha nzeꞌe chu nza nzeꞌe che, nu chenu nia lu stucui nú yeꞌta nzeꞌe lua chu nzeꞌta nzeꞌe che, nu chenu rnibiyaꞌa lu mosoa nú xi riꞌi nzeꞌe, rriꞌi nzeꞌene. ");
INSERT INTO zplNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chenu ubeneꞌ Jesuse nú uni capitán zeꞌe scua, chiquiꞌ uyanu arquiꞌnu nu uninu lubee bene enu nzenala liꞌinu: ―Liꞌá nia luhua nú niꞌ luye bee eyeche Israel lascaꞌ chechuꞌa niꞌ tucu bene Israel enu chiquiꞌ nzeli arquiꞌ Diose tucu nú nzeli arquiꞌ benequieꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Liꞌá nia luhua nú huaxi bee bene diqui lu iliulabe, yala cuaꞌanu Abraham, cuna Isaac cuna Jacob liñibe elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero bee bene Israel enu necadichiaꞌ nú riala nú chuꞌu liñibe elurnibiyaꞌ Diose liꞌibeei riala chue beei eliꞌyaꞌ elu natsacabe, nu zeꞌe unaꞌbeei cuna nú acuxaꞌ laya beei. ");
INSERT INTO zplNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chequie uni Jesuse lu capitán zeꞌe: ―Uquia niꞌlu, nu aca tucu nú uchili arquiꞌlu. Nu hora zeꞌe uyecaꞌ mosoꞌ capitán zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chenu uya Jesuse niꞌ Pedro, ulañiꞌnu nú nchiucuꞌ suegraꞌ Pedro lu luna seca xle. ");
INSERT INTO zplNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Che unaꞌtsenu yalla, nu chu uchiuꞌu xle nú secalla, che uzetella nu udeteꞌlla nú udacu beella. ");
INSERT INTO zplNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chenu uyuꞌu rulaꞌ, uriñayu bee bene huaxi bee bene enu nuꞌ benechiquiꞌ arquiꞌ lu Jesuse, nu cuna tucu bedichiaꞌ uluanu benechiquiꞌ arquiꞌbeella, nu leꞌca uriyecanu ye bee bene enu riti. ");
INSERT INTO zplNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Scua unga para nú uyalu tucu nú uni profeta Isaías chenu unilla: “Liꞌinu uyucunu elichia nú seꞌcaꞌahua nu unguyaꞌnu nú nehuana seꞌcaꞌahua.” ");
INSERT INTO zplNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Chenu ulañiꞌ Jesuse nú huaxi bee bene rriña lunu, che unibiyaꞌnu lubee beneꞌnu nú detenunu beella stucu chu ruꞌu inzatuꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nu che uyabica tucu ulaxcuela enu reca leyꞌ Moises lunu, nu unilla lunu: ―Maestro, niarquia nú nzelanala liꞌilu catse elu nzalu. ");
INSERT INTO zplNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Che uni Jesuse lulla: ―Bee betsa rluꞌcu beeí iliuꞌu nú neca niꞌi beeí, nu bee iñi rluꞌcu beeí exliaꞌtseꞌ beeí. Pero liꞌá Bene enu uxeꞌla Diose niꞌ elu quienchiñaꞌa equiea la lucua. ");
INSERT INTO zplNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nu stucu beneꞌnu enu nzenala liꞌinu uni lunu: ―Detá, uzela nú biꞌya paa hasta nú atinu. ");
INSERT INTO zplNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero uni Jesuse lu bene zeꞌe: ―Utequie liꞌá, nu uzela nú bee bene enu la niarquiꞌ yeꞌtanala liꞌá, cachiꞌ bee nzeꞌe paꞌlu chenu atilla. ");
INSERT INTO zplNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chequie uyuꞌu Jesuse liñi barco cuna bee beneꞌnu, ");
INSERT INTO zplNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","nu diquila nú rdete beella lu inzatuꞌ zeꞌe, uquixie unga tucu bii juerte nu uyuꞌu inza liñi barco. Pero raꞌtse Jesuse nuxu liñi barco zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Che uya cuaꞌñi bee beneꞌnu liꞌinu nu uni beella lunu: ―¡Detá, utsilaꞌa liaꞌahua! ¡Xne nze chatseꞌlaꞌahua lu inza! ");
INSERT INTO zplNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Che ucuaquinu lubeella: ―¿Xiquie nú chiquiꞌ xiquihua? ¡Xinu lleꞌnatsia nzeli arquiꞌhua liꞌá! Chequie uzetenu nu unibiyaꞌnu nú acaxe bii cuna inzatuꞌ nu hora zeꞌe ungaxeli ye bee nucuaꞌ ");
INSERT INTO zplNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nu chiquiꞌ uyanu arquiꞌ bee beneꞌnu nú unibeella lu saꞌ beella: ―¿Ti neca benequieꞌ?, nú hasta bii cuna inzatuꞌ sucuꞌ nú rni nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chenu uriña Jesuse stucu chu inzatuꞌ lu iliuꞌ bee bene Gadara, che chiucu bee niyu enu seca ichiaꞌ benechiquiꞌ uchiuꞌu beei liñi pandiuñi nu uriña beei lunu. Nu rucu beei chiquiꞌ nelachi beei, nu hasta nú lecati dete inziu elu nucuaꞌa beei. ");
INSERT INTO zplNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nu juerte urixialibeei nú unibeei: ―¿Xinu riꞌchialu liꞌiru Jesuse Lliꞌñi Diose? ¿Xieꞌ uriñalu caꞌa para nú riꞌilu nú zecaru castiyaꞌru chenu lascaꞌ riña tiembu nú acane scua la? ");
INSERT INTO zplNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Axu enza zeꞌe nucuaꞌa huaxi bee cuchi racu, ");
INSERT INTO zplNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","chequie uziquie bee benechiquiꞌ zeꞌe lu Jesuse nú unibeei lunu: ―Tunu hualu liꞌiru arquiꞌ bee benequieꞌ, alaꞌ zelalu nú chuꞌuru arquiꞌ bee cuchi cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Che uni Jesuse lubeei: ―Uyuꞌuhua che. Chequie uchiuꞌu bee benechiquiꞌ arquiꞌ bee bene zeꞌe nu uyuꞌu beei arquiꞌ bee cuchi zeꞌe. Che ye bee cuchi zeꞌe uyecaxuꞌu beeí nu utsundiqui beeí ruꞌu beꞌe hasta lu inzatuꞌ, nu zeꞌe unguti beeí. ");
INSERT INTO zplNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nu bee bene enu rriucu bee cuchi zeꞌe, nzexuꞌu beei, nu chenu uriña beei eyeche zeꞌe udixiuleꞌe beei lubee bene ye nú unga zeꞌe, cuna lunú ulleꞌca bee bene enu uyuꞌu benechiquiꞌ arquiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chequie uchiuꞌu ye bee bene eyeche zeꞌe uya elu nzu Jesuse, nu chenu ulañiꞌ beei liꞌinu, uziquie beei lunu nú chiuꞌunu lu iliu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chequie uyuꞌu Jesuse liñi barco nu udetenu stucu chu inzatuꞌ nu uriñanu elu neca lachinu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Zeꞌe uriñayu bee bene tucu bene enu neati cuerpoꞌ nchiucuꞌ lu camiya lunu. Chenu ulañiꞌ Jesuse nú nzeli arquiꞌbeei liꞌinu, che uninu lu bene enu riti zeꞌe: ―Duꞌ ana arquiꞌlu endua. Uriꞌila perdona stulalu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Che chiucu chuna bee ulaxcuela enu reca leyꞌ Moisés uriꞌi elliebacuꞌ: “Benequieꞌ necha rni lu cuendaꞌ Diose.” ");
INSERT INTO zplNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nu lunú nediyaꞌlaꞌ Jesuse xi rriꞌi beella elliebacuꞌ, uninu lubeella: ―¿Xinu necha rriꞌihua elliebacuꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ta nú mase neriñaꞌ nú aca, nú nia: “Uriꞌá perdona stulalu”, urre nú nia: “Uzetee nu utseꞌ”? ");
INSERT INTO zplNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero nee lubea luhua nú liꞌá Bene enu uxeꞌla Diose rluꞌcua nú rnibiyaꞌa lu iliulabe para nú riꞌá perdona stula bee bene. Chequie uninu lu bene enu riti zeꞌe: ―Uzetee unaꞌtse camiyaꞌlu nu uquiaꞌa niꞌlu nee. ");
INSERT INTO zplNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Che chu uzete bene zeꞌe nu nzialla enza niꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chenu ulañiꞌ bee bene zeꞌe nucuaꞌ chiquiꞌ ulliqui beei, nu uquixie unibeei bedichiaꞌ nzeꞌca lu Diose, equie nú udeteꞌnu poder nú rluꞌcunu lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chenu uchiuꞌu Jesuse zeꞌe nu nzanu, che ulañiꞌnu tucu bene enu lee Mateo, nzuculla elu rriꞌilla cubre impuesto, nu uni Jesuse lulla: ―Utequie liꞌá. Che chu utsuli Mateo nu chu nzequiella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chenu nzucu Jesuse lu mexa racu eta niꞌ Mateo, cuna beelá bee bene enu rriꞌi cubre impuesto nu cuna beelá bee bene enu la nehuañi tucu nú rnibiyaꞌ ley nú sucuꞌ bee bene Israel, ye beella nucuaꞌanu beella Jesuse lu mexa cuna bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pero chenu ulañiꞌ bee fariseo nucuaꞌ, unidichiaꞌ beei lubee beneꞌnu: ―¿Xinu racunuu maestroꞌhua bee bene enu rriꞌi cubre impuesto nu cuna bee bene enu rluꞌcu dula? ");
INSERT INTO zplNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chenu ubeneꞌ Jesuse nú unibeei scua, uninu lubeei: ―Bee bene enu la aca riti, la quiꞌña bee nzeꞌe doctor. Sino que bee bene enu riti bee nzeꞌe rquiꞌña doctor. ");
INSERT INTO zplNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Uquiahua nu zeꞌtehua xi rni lu ichiꞌ Stichiaꞌ Diose elu rni: “Niarquia nú huaꞌa arquiꞌhua bee bene, luguare nú rliquiꞌhua nañi uꞌna lua.” Xne lá yelaa lubee bene enu la luꞌcu dula sino que uriña lubee bene enu rluꞌcu dula para nú cheꞌe arquiꞌbeei lu stula beei. ");
INSERT INTO zplNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chequie uriña bee beneꞌ Juan Bautista lu Jesuse nu unidichiaꞌ beella lunu: ―¿Xiquie nú liꞌiru cuna bee fariseo, la daꞌcuru huaxi bese equie nú rluꞌcuru ulaꞌna lu Diose, nu bee beneꞌlu la riꞌi scua? ");
INSERT INTO zplNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Che ucuaqui Jesuse lubeei: ―Elu xia tucu bene, ¿xieꞌ nuꞌ modo nú nehuana tsu arquiꞌ bee bene enu nezeneꞌ zeꞌe chenu nzu bene enu xia zeꞌe cuna liꞌibeella la? Pero riña bichia chenu lecaꞌ bene enu xia zeꞌe. Chee si deteꞌ bee beneꞌ bene enu xia bichia nu la acu beella. ");
INSERT INTO zplNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Lecati quielaꞌ tepedaso laquie cuqui lu tucu laquie uxu, xne riuꞌbe laquie cuqui, nu riꞌi nucuaꞌ nú tsa laquie uxu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Leꞌca la chuꞌu biñu cuqui liñi iti uxu, xne tsaa iti uxu, nu che nitilu biñu cuna iti. Enzeꞌe rquiꞌña nú chuꞌu biñu cuqui liñi iti cuqui para nú la nitilu niꞌtucue. ");
INSERT INTO zplNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Chenu rniscaꞌ Jesuse scua, uriña tucu bene enu rnibiyaꞌ liñi induꞌ bee bene Israel lunu, nu utsulliquilla lunu nu unilla lunu: ―Penatsia unguti endua, pero tunu yeꞌtalu nu ricuꞌlu yalu equienchu huañi zecanchu che. ");
INSERT INTO zplNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chequie nzenu Jesuse liꞌilla, cuna bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Chequie tucu unaꞌa enu riti, nu ungala chiꞌchiucu lana nú rlaca rene, uyabica diꞌchi Jesuse nu utiꞌnchu yanchu ruꞌu xucunu, ");
INSERT INTO zplNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","xne uriꞌinchu elliebacuꞌ: “Tunu tiꞌtsia yaa ruꞌu xucunu, yecaa che.” ");
INSERT INTO zplNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero ubelleta Jesuse, nu ubiꞌyanu lu unaꞌa zeꞌe nu uninu lunchu: ―Duꞌ ana arquiꞌlu endua uyecaꞌlaꞌlu xne uchili arquiꞌlu liꞌá. Nu hora zeꞌe uyecaꞌliꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chenu uriña Jesuse niꞌ bene enu rnibiyaꞌ liñi induꞌ bee bene Israel ulañiꞌnu nú nucuaꞌala bee musica zeꞌe para nú nzeachiꞌ enduꞌlla, nu chiquiꞌ runaꞌnuu bee bene liꞌinchu, ");
INSERT INTO zplNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","chequie uni Jesuse lubee bene zeꞌe: ―Uchiuꞌuhua caꞌa xne lá ati enduꞌ unaꞌa quieꞌ, raꞌtse tsianchu. Chequie ulliꞌchinuu bee bene zeꞌe liꞌinu, ");
INSERT INTO zplNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","pero unibiyaꞌnu nú chiuꞌu bee bene zeꞌe eleꞌyaꞌ, nu chu uyuꞌunu liñi niꞌi nu unaꞌtsenu yanchu, nuchu uzeteenchu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nu ye bee luhuare enza zeꞌe uriꞌchialetse bedichiaꞌ lunú uriꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chenu uchiuꞌu Jesuse zeꞌe, chiucu bene enu labiꞌya nzenala liꞌinu, nu urixialibeei nú rnibeei: ―¡Jesuse, llianaꞌ David uhuaꞌa arquiꞌ liꞌiru! ");
INSERT INTO zplNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Chenu uyuꞌu Jesuse liñi niꞌi, nu uyabica rucu bee bene zeꞌe lunu, nu unidichiaꞌnu lubeei nú uninu: ―¿Nzelí arquiꞌhua nú acaa riyecaa iꞌculuhua la? Che ucuaqui beei lunu: ―Aahuaꞌ, nzeli arquiꞌru detá. ");
INSERT INTO zplNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nu chu, utiꞌ Jesuse yanu iꞌculu beei nu uninu lubeei: ―Aca Tucu nú nzeli arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Che uyeꞌe iꞌculu beei. Nu uninu lubeei: ―La ixiuleꞌetsiahua nucuaꞌ lu niꞌ tucu bene. ");
INSERT INTO zplNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero uchiuꞌutsia beei lunu, chu udixiuleꞌe beei lubee bene diqui lu iliu zeꞌe nú uriyeca Jesuse beei. ");
INSERT INTO zplNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chenu nziatsia bee bene enu uriyeca Jesuse iꞌculu, che uriñayu bee bene tucu bene enu la ni nchiñi benechiquiꞌ arquiꞌ lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nu chenu uhua Jesuse benechiquiꞌ arquiꞌ bene enu la ni zeꞌe, che uquixiei uni. Che chiquiꞌ nzenu arquiꞌ bee bene zeꞌe nú unibeei: ―¡Leca xunga ulañiꞌahua saꞌ milagro quieꞌ leta bee bene Israel! ");
INSERT INTO zplNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero uni bee fariseo: ―Benequieꞌ rlua benechiquiꞌ arquiꞌ bee bene cuna poder bezeꞌlu enu rnibiyaꞌ lubee benechiquiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Uya Jesuse lu ye bee eyeche llene cuna lu ye bee eyeche llaꞌna, nu cada tucua lubee eyeche cuaꞌ uyuꞌunu liñi bee indu uzeteꞌnu bedichiaꞌ nzeꞌcaꞌ Diose lubee bene, nu uninu lubeella nú xa neca elurnibiyaꞌ Diose, nu uriyecanu elu rcu cuerpoꞌ bee bene, nu cuna bee bene enu seca yelu clasiaꞌ elichia. ");
INSERT INTO zplNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Chenu ulañiꞌ Jesuse bee bene añi cuaꞌ uhuaꞌa arquiꞌnu liꞌibeella, xne nehuana nzu arquiꞌbeella, nu lixiu nzu arquiꞌbeella, nu nucuaꞌa beella xi nucuaꞌa bee sanchi enu lecaꞌ ti riꞌi ucu. ");
INSERT INTO zplNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chequie uninu lubee beneꞌnu: ―Liꞌá nia nú nuꞌ huaxi bee bene enu niarquiꞌ yeneꞌ bedichiaꞌ nzeꞌcaꞌ Diose, pero leca huaxi bee bene enu ixiuleꞌe lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Enzeꞌe unaꞌcuhua lu Diose para nú xeꞌlanu huaxi bee bene enu ixiuleꞌe stichiaꞌnu lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chequie ubixia Jesuse chiꞌchiucu bee beneꞌnu, nu udeteꞌnu poder lubeella para nú hua beella bee benechiquiꞌ arquiꞌ bee bene nu riyeca beella bee bene enu rcuu catse cuerpoꞌ, cuna ye clasiaꞌ elichia nú seca beei. ");
INSERT INTO zplNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Bee benequieꞌ neca lu chiꞌchiucu apóstolꞌ Jesuse: Rluti, Simón enu leꞌca lee Pedro, nu bichilla Andrés; nu Jacobo cuna Juan, rucu benequieꞌ neca llianaꞌ Zebedeo. ");
INSERT INTO zplNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nu leꞌca ucañinu Felipe, Bartolomé, Tomás cuna Mateo enu uriꞌi cubre bee impuesto; Jacobo llianaꞌ bene enu lee Alfeo; nu Lebeo enu leꞌca lee Tadeo. ");
INSERT INTO zplNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nu cuna Simón enu ullutse leta tucu partido nú lee cananista; nu Judas Iscariote enu udeteꞌ cuenda Jesuse lubee bene nú ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ante nú xeꞌla Jesuse chiꞌchiucu bee apóstolꞌnu lubee bene uninu lubeella: ―La chuehua elu nucuaꞌa bee bene enu la neca bee bene Israel niꞌ lubee eyeche lu iliu Samaria; ");
INSERT INTO zplNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","sino que uquiahua lubee bene Israel enu la chenala inziuꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Uquiatixiuleꞌehua lubeella nú nzeꞌta riñala bichia nú nibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Riyecahua bee bene enu riti, nu riꞌihua nú huañi zeca bee bene enu unguti, riyecahua bee bene enu seca elichia nú lee lepra, huahua bee benechiquiꞌ arquiꞌ bee bene. Tucu nú lia uliquia poder cuaꞌ luhua, leꞌca chenu riyecahua bee bene la riꞌihua cobre. ");
INSERT INTO zplNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’La uyaꞌhua cobre niꞌ oro niꞌ plata. ");
INSERT INTO zplNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Uyaꞌhua biti, nu la uyaꞌhua xucuhua nú cheꞌehua, nu la uyaꞌhua steinza lucuhua, nula uyaꞌhua xcahua, xne bee bene enu rriꞌi riñaꞌ riala nú atiꞌlla nú aculla. ");
INSERT INTO zplNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Chenu riñahua tucu eyeche llene urre tucu eyeche llaꞌna, zeꞌe cuaꞌnahua niꞌi tucu bene nzeꞌca yaꞌnahua nu uyaꞌnahua zeꞌe hasta nú chiuꞌuhua eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nu chenu chuꞌuhua liñi niꞌi bene zeꞌe, uniꞌhua Diose lubee bene enu nucuaꞌa zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tunu bee bene liñi niꞌi zeꞌe riala nú nzuxe arquiꞌbeella, riaꞌna nú nzuxe cuaꞌ arquiꞌbeella, pero tunu lacane para liꞌibeella, benchilaꞌe cuna liꞌihua che. ");
INSERT INTO zplNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nu tunu la yucu arquiꞌ bee bene liꞌihua tucu eyeche urre tucu niꞌi, uchiuꞌuhua eyeche zeꞌe urre niꞌi zeꞌe, nu riꞌquihua yuubeꞌchaꞌ nú nuꞌ cuchiuꞌhua, xi neca tucu seña nulá zela beella ayeneꞌ beella bedichiaꞌ nú unihua. ");
INSERT INTO zplNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Xne liꞌá nia luhua nu chenu hualu Diose lu cuendaꞌ yebee bene, masescaꞌla zeca bee bene eyeche cuaꞌ castiya luquela bee bene eyeche Sodoma cuna Gomorra. ");
INSERT INTO zplNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Leꞌca uni Jesuse lubee beneꞌnu: ―¡Biꞌyacuruhua! Liꞌá xeꞌla liꞌihua lubee bene xi neca chenu nza bee sanchi leta bee bichiuu. Enzeꞌe aca netsiñahua xi netsiña bee beꞌla nu aca lleꞌna arquiꞌhua xi neca bee paloma. ");
INSERT INTO zplNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ubiꞌyahua liꞌihua xne deteꞌ cuenda bee bene liꞌihua lubee usticia nu zeteꞌcheꞌ beei liꞌihua liñi bee indu. ");
INSERT INTO zplNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nu hasta uyaꞌ beei liꞌihua lubee gobernador nu lubee arre equie nú nzeli arquiꞌhua liꞌá, pero scua nuꞌ modo ixiuleꞌehua stichiaꞌa lubeei, nu lubee bene enu la neca bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nu chenu deteꞌ cuenda bee bene liꞌihua lubee usticia, la chenu arquiꞌhua xi nihua urre xa nihua lubeella; xne hora nú nihua Diose liquiꞌ bee bedichiaꞌ nú riala nihua. ");
INSERT INTO zplNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Xne laca liꞌihua enu ni. Espíritu Santoꞌ Diose Pa liñibe neca enu liquiꞌ bedichiaꞌ nú nihua. ");
INSERT INTO zplNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Enta bichia nú deteꞌ cuenda bee bene bee bichilla nú ati bee nzeꞌe, nu leꞌca deteꞌ cuenda bee paa bee enduꞌlla para nú ati beei. Nu leꞌca enta bichia nú riꞌi condra bee enduꞌ bee uzanaꞌ beei nu hasta nú deteꞌ cuenda beei liꞌibeella nú ati beella. ");
INSERT INTO zplNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nu chana arquiꞌ ye bee bene liꞌihua equie nú necahua bee benea. Pero bee bene enu tsutaꞌ arquiꞌ lunú nzeli arquiꞌ liꞌá diqui tiembu nú nehuañilla, tsilaꞌa Diose bee nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chenu riꞌi bee bene nú nehuana zecahua lu tucu eyeche equie nú necahua bee benea, uquiahua stucu eyeche, xne liꞌá nia luhua nu lascaꞌ laxu chuehua lu yebee eyeche Israel chenu riña liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Niꞌ tucu bene enu seteꞌ la neca equielálla lu bene enu seteꞌ liꞌilla, nu leꞌca niꞌ tucu mosoꞌ la neca equielá lu patronꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bene enu seteꞌ rquiꞌña nú aca conformella nú recalla tucu nú reca ulaxcuelaꞌlla, nu tucu mosoꞌ rquiꞌña nú aca conformei nú necai tucu nú neca patronꞌi. Nu liꞌá enu rnibiyaꞌa luhua rni bee bene nú necaa bezeꞌlu, ¿enzaláquieꞌ liꞌihua nú necahua bee benea ti ni bee bene nú necahua? ");
INSERT INTO zplNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Enzeꞌe la lliquihua bee bene. Xne niꞌ tucu beenú aꞌchiꞌ neca la yaꞌnane scuatsia sin nú acabiyae, riña bichia nu acache bee nucuaꞌ, leꞌca niꞌ tucu beenú aꞌchi neca rriꞌi bee bene la yaꞌnane scuatsia, riña bichia nú acabiya yebee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lunú aꞌchiꞌtsia rnia luhua, uniꞌhuane lu yebee bene nu lunú rnia aꞌchi diacahua. Juerte uniꞌhuane. ");
INSERT INTO zplNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","La lliquihua bee bene enu niarquiꞌ uti liꞌihua. Pero leca modo utilla espírituꞌhua. Mejora ulliquihua Diose, xne liꞌinu rluꞌcunu poder nú nitilunu espírituꞌhua cuna cuerpoꞌhua ebila. ");
INSERT INTO zplNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿La huaxi seca bee iñi? Pero niꞌ tucu beeí la zanaꞌ beeí lu yuu tunu la zela Paꞌahua enu nzucu liñibe nú acane scua. ");
INSERT INTO zplNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nu liꞌihua hasta yebee ichia equiehua nebacuꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Enzeꞌe la lliquihua. Xne mase secahua luquela nú seca huaxi bee iñi. ");
INSERT INTO zplNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Titse bee bene enu ni nú neca benea lu beelá bee bene, leꞌca esquie liꞌá nia nú neca beella bee benea ante lu Diose Pa liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero bee bene enu ni nú laca bee benea lu beelá bee bene, leꞌca esquie liꞌá nia nú laca beella bee benea ante lu Diose Pa liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’La riꞌihua elliebacuꞌ nú tia uriña lu iliulabe para nú riꞌá nú aca tucunecatse bee bene lu saꞌbeei, sino equie nú chili arquiꞌ bee bene liꞌá liunu saꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bee pa liunu cuna bee enduꞌlla, nu bee naa liunu cuna bee xinchiuꞌcu nu bee llixi liunu suegraꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nu bee bene liñi tucu niꞌi leꞌcatsia liꞌibeella chana arquiꞌ saꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Bene enu seca paꞌ nu naꞌ masescaꞌlá luquela liꞌá, leca modo aca nzeꞌe benea, leꞌca esquie enu mase seca enduꞌ urre xinchiuꞌcu luquela liꞌá, leꞌca leca modo aca nzeꞌe benea. ");
INSERT INTO zplNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bee bene enu niarquiꞌ yeꞌta quie liꞌá pero la niarquiꞌ nú nehuana zeca equie cuendaꞌ liꞌá, leca modo aca bee nzeꞌe bee benea. ");
INSERT INTO zplNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bene enu maselá seca elunehuañi nú rluꞌculla lu iliulabe quieꞌ enta bichia nú laxu nucuaꞌ; pero bene enu ati equie cuendaꞌ liꞌá, luꞌculla elunehuañi lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Bee bene enu riꞌi caso liꞌihua, rriꞌi caso bee nzeꞌe liꞌá; nu bee bene enu rriꞌi caso liꞌá leꞌca rriꞌi caso bee nzeꞌe Pa liñibe enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Leꞌca bee bene enu rriꞌi caso tucu profeta equie nú neca profeta quieꞌ enu uxeꞌla Diose, leꞌca atiꞌlla premio nú atiꞌ profeta lu Diose. Nu bene enu riꞌi caso tucu bene enu rriꞌi nzeꞌca, leꞌca iguale atiꞌlla premio nú atiꞌ bene enu rriꞌi nzeꞌca lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nu titse bee bene enu liquiꞌ masia tucu basu inza luhua lunú necahua bee benea, liꞌá nia luhua nú deteꞌ Diose premio lubee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Chenu ulaxu nú unibiyaꞌ Jesuse lu chiꞌchiucu bee beneꞌnu nú xi che riꞌi beella, che uchiuꞌunu nze zeteꞌnu nu nze tixiuleꞌenu Stichiaꞌ Diose lubee bene lubee eyeche nú nchiucuꞌ lu iliu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nu chenu nchiñi Juan Bautista niꞌcuꞌ ubeneꞌlla luye nú rriꞌi Jesuse. Che uxeꞌlalla chiucu chuna bee beneꞌlla, ");
INSERT INTO zplNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","para nú che nedichiaꞌ beella lu Jesuse: ―¿Liꞌilu necalu Cristo enu nzu nú nzeꞌta la, urre lluaquieeru stucu enu enta la? ");
INSERT INTO zplNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Che ucuaqui Jesuse lubeella: ―Uquia tixiuleꞌehua lu Juan Bautista lunú rlañiꞌhua nu lunú rieneꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Udixiuleꞌehua lulla nú rlañiꞌlaꞌ bee bene enu nequieꞌlu nu bee bene enu necuxu see la bee nzeꞌe, nu leꞌca uyecaꞌlaꞌ bee bene enu seca elichia nú lee lepra, nu bee bene enu nenguataꞌ rieneꞌlaꞌ, nu bee bene enu unguti uhuañi zeca bee nzeꞌe, nu bee bene enu seca elitsi rieneꞌlaꞌ bedichiaꞌ nzeꞌcaꞌ Diose nú tsilaꞌa liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ñia neca lu cuendaꞌ bee bene enu la chiecuꞌ arquiꞌ nú nzeli arquiꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chenu nziue bee beneꞌ Juan enu uya lu Jesuse, che uquixie Jesuse nú uninu lubee bene zeꞌe equie cuendaꞌ Juan, nu uninu lubeella: ―¿Ti uya biꞌyahua lu yuu achi elu la nucuaꞌa bee bene? ¿Ti secahua nú neca bene enu uya biꞌyahua, tucu etaa nú rcuñi bii la? ");
INSERT INTO zplNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Urre ¿xa naa bene enu uya biꞌyahua? ¿Xieꞌ uya biꞌyahua tucu bene enu nutu laquie fiñu la? Liꞌihua nediyaꞌhua nú bee bene enu rutu laquie fiñu liñi palacio nucuaꞌa beella. ");
INSERT INTO zplNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ti uya biꞌyahua che? ¿Uya biꞌyahua tucu profeta la? Neli nú scua necane, pero masescaꞌlá neca equiella luquela tucu profeta. ");
INSERT INTO zplNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Equie cuendaꞌ Juan quieꞌ rni lu ichiꞌ Stichiaꞌ Diose elu rni: Xeꞌlaa tucu benea cha rluti lulu, para nú recheꞌlla inziuꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Liꞌá nia luhua nu luye bee bene enu nucuaꞌa lu iliulabe lá chuꞌu niꞌ tucu bee bene enu masescaꞌlá neca equie tucu nú neca equie Juan Bautista. Pero bene enu menola neca equie liñibe elurnibiyaꞌ Diose nzeꞌe mase neca equie luquela Juan. ");
INSERT INTO zplNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Desde bichia nú ubeꞌta Juan Bautista nu hasta nee, huaxi bee benechiquiꞌ rcuaꞌna xa modo chuꞌu elurnibiyaꞌ Diose. Nu bee bene enu neli rcuaꞌna nú chuꞌu elu rnibiyaꞌnu, liꞌibeella neca beella enu chuꞌu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ley nú udeteꞌ Diose lu Moisés cuna yebee profeta udixiuleꞌe beella nú xi nzeꞌta aca, hasta bichia nu uriña Juan, ");
INSERT INTO zplNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","nu tunu liꞌihua chili arquiꞌhua nú nia luhua, nú Juan neca profeta Elías enu uni bee profeta nú riña. ");
INSERT INTO zplNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Titse bee bene enu niarquiꞌ nú yeneꞌ nú rnia, quieꞌe diaca nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Xa nia luhua nú xa neca bee bene enu nehuañi lu iliulabe quieꞌ nee? Liꞌá nia luhua nú neca beei xi neca bee enduꞌ enu rcuaꞌa ruꞌu iꞌya rita nu rixiali beei lusaꞌ beei, nú rnibeei: ");
INSERT INTO zplNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ungularu chí para nú yeꞌehua nu né yeꞌehua, nu leꞌca ungularu canción nú nehuana se, nu né unaꞌhua.” ");
INSERT INTO zplNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Scua necahua xne uriña Juan Bautista nú lá aculla nu leꞌca la hueꞌlla viñu nu rnihua nú nchiñi benechiquiꞌ arquiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Neequie uriña liꞌá Bene enu uxeꞌla Diose, nú racua nu rueꞌa biñu, nu rnihua nú racuxetaꞌa nu riuꞌ arquia rueꞌa viñu nu rquietea bee bene enu rluꞌcu dula nu cuna bee bene enu rriꞌi cubre impuesto para Roma. Pero yebee bene rriꞌi beyaꞌ, liꞌibeella nediyaꞌ beella nú neca nzeꞌca lunú rriꞌi Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Chequie uquixie Jesuse nú uquiꞌyaꞌnu bee bene bee eyeche elu mase uriꞌinu bee milagro, xne né tsanaꞌ arquiꞌbeei stula beei. Nu uninu lubeei: ");
INSERT INTO zplNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Cueꞌhua bee bene Corazín! ¡Cueꞌhua bee bene Betsaida! Xne tunu eyeche Tiro cuna eyeche Sidón a aca bee milagro nú unga lachihua, xi tiembula a tsanaꞌ arquiꞌ bee bene zeꞌe stula beei, nu leꞌca a utu beei laquie natsa nu a tiqui beei tii equie beei, xi neca tucu seña nú lubeꞌ nú nehuana nzu arquiꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero liꞌá nia luhua nú bichia chenu laxu iliulabe, maselá juerte castiya zecahua luquela nú zeca bee bene eyeche Tiro cuna eyeche Sidón. ");
INSERT INTO zplNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nu liꞌihua bee bene eyeche Capernaum, ¿la zaꞌ arquiꞌhua nú riala chuꞌuhua liñibe? ¡Xne liꞌihua riala chuꞌuhua hasta elu mase aquié rquiꞌ ebila! Xne tunu eyeche Sodoma a aca bee milagro nú unga lachihua, che pianu hasta bee bichia quieꞌ nchiucuꞌscaꞌ bee eyeche cuaꞌ che. ");
INSERT INTO zplNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero liꞌá nia luhua nú bichia chenu laxu iliulabe mase juerte castiya nú zecahua luquela castiya nú zeca bee bene eyeche Sodoma. ");
INSERT INTO zplNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bee bichia zeꞌe uni Jesuse: “Pa liñibe liꞌilu enu rnibiyaꞌ liñibe cuna lu iliulabe, zucu ayaa liꞌilu xne ulubeꞌlu lubee bene enu lecaxi reca, nu ucachiꞌlu lubee bene enu reca nu rriꞌi beyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Scua necane Pa liñibe, xne scua niarquiꞌlu nú acane. ");
INSERT INTO zplNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Uliquiꞌ Pa Diose nú nibiyaꞌa luye beenú nuꞌ. Lecati nediyaꞌ ti neca Jesucristo lliꞌñi Diose, Diose tsia nediyaꞌ nucuaꞌ, leꞌca tucutsia Jesucristo cuna bee bene enu nzeli arquiꞌ liꞌinu nuꞌlu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yehua bee bene enu nellaca nzenala lunú neca bee custumbre, nu yehua bee bene enu nellaca lu stula, utehua cuna liꞌá nu liꞌá riꞌá nú tsulachihua. ");
INSERT INTO zplNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uzuꞌcuꞌhua stichiaꞌa, nu zeꞌtehua nú acahua bene nzeꞌca enu lleꞌna nzu arquiꞌ tucu nú necaa. Che riꞌá nú huañi nzeꞌcahua. ");
INSERT INTO zplNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Xne laca neriñaꞌ nú zucuꞌhua stichiaꞌa nu leꞌca laca neriñaꞌ nú riꞌihua lunú niarquia. ");
INSERT INTO zplNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tucu bichia nú sulachi bee bene Israel, udetenu Jesuse bee beneꞌnu lu yuu elu nuꞌ trigo, nu chequie uquixie nú uliaꞌnaꞌ beella nu unguxi beella tuu lu trigo nu uzuꞌcu beellae nu udacu beellae. ");
INSERT INTO zplNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chenu ulañiꞌ bee fariseo nú uchaꞌñi bee beneꞌnu trigo, uni beella lu Jesuse: ―Biꞌyacuru, bee beneꞌlu rriꞌi lunú la yala riꞌi beei bichia nú sulachi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nu ucuaqui Jesuse lubeella: ―¿Xieꞌ lascaꞌ ulahua lu ichiꞌ Stichiaꞌ Diose elu rni nú xa uriꞌi David cuna bee bene enu nulla tucu bese chenu uliaꞌnaꞌ beella la? ");
INSERT INTO zplNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Uyuꞌu David liñi induꞌ Diose nu udeteꞌ uleꞌya pá nú necaleꞌya yalla nu udacullae nu leꞌca udeteꞌlla pá cuaꞌ udacu bee bene enu nuulla añinzuca nú bee uleꞌyatsia nuꞌ modo nú acu bee pá cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Urre xieꞌ lascaꞌ ulahua lu ley nú udeteꞌ Diose lu Moisés elu rni nú laca dula lunú rriꞌi bee uleꞌya liñi indu añinzuca núla tsulachi beella bichia nú sulachi bee bene la? ");
INSERT INTO zplNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nu liꞌá enu nzu cuna liꞌihua, nia luhua nú masela neca equiea luquela indu. ");
INSERT INTO zplNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tunu liꞌihua rriꞌihua beyaꞌ xi rni lu ichiꞌ Stichiaꞌ Diose elu rni: “Niarquia nú huaꞌa arquiꞌhua bee bene luhuare nú liquiꞌhua uꞌna bee nañi lua.” Tunu rriꞌihua beyaꞌ xi rni bee bedichiaꞌ cuaꞌ che lecalí xi taꞌquiyahua bee bene enu la luꞌcu niꞌ tucu equiya. ");
INSERT INTO zplNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nu liꞌá Bene enu uxeꞌla Diose leꞌca rluꞌcua nú rnibiyaꞌa lu bichia nú sulachi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chenu ulaxu nú udete Jesuse zeꞌe uyuꞌunu liñi indu nú nzucu enza zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nu liñi indu zeꞌe nzucu tucu niyu enu ubichicuꞌ techu ya, nu lunú rcuaꞌna bee fariseo nuxi taꞌquiya beei liꞌinu che unedichiaꞌ beei lunu: ―¿Xieꞌ nuꞌ modo nú riyecalu tucu bene enu riti bichia nú sulachi bee bene la? ");
INSERT INTO zplNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chequie uni Jesuse lubeei: ―Tunu tatucuhua rluꞌcu tucu sanchi nu yecataí liñi tucu iꞌchiu bichia nú sulachi bee bene, ¿xieꞌ la chehuahuaí bichia cuaꞌ la? ");
INSERT INTO zplNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nu ¡masela huaxi seca tucu bene luquela tucu sanchi! Enzeꞌe nuꞌ modo nú riꞌi bee bene nú neca nzeꞌca bee bichia nú sulachi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Che uninu lu niyu enu ubichicuꞌ ya zeꞌe: ―Ulí yalu. Che ulí niyu zeꞌe yai nu hora zeꞌe uyecaꞌ yai, nu nae tucu nú naa stucu chu yai. ");
INSERT INTO zplNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nu chenu uchiuꞌu bee fariseo liñi indu zeꞌe, uquixie beei ubedichiaꞌ beei nú xa modo riꞌi beei para nú uti beei Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pero chenu uriꞌi Jesuse beyaꞌ nuxi niarquiꞌ bee fariseo zeꞌe riꞌinu liꞌinu uchiuꞌunu zeꞌe nzanu, nu huaxi bee bene uyaquie liꞌinu, nu uriyecanu ye bee bene enu riti, ");
INSERT INTO zplNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","nu uninu lubeei nu la ixiuleꞌe beei lu niꞌ tucu bee bene nú uriyecanu beei. ");
INSERT INTO zplNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Scua unga para nú uyalu tucu nú uni profeta Isaías chenu unilla: ");
INSERT INTO zplNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","―Biꞌyacuruhua liꞌinu necanu enu ucañia para nú zibiꞌ lua, Liꞌinu enu chiquiꞌ seꞌcaa, nu chiquiꞌ ñia nzu arquia lunu. Nu xeꞌla Espíritu Santoa equienu, para nú ixiuleꞌenu lubee bene iliulabe xa rnibiyaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nu niꞌ tucu bene la liununu, nula bixialínu, nu la necanu bene enu bixialí labe bee calle. ");
INSERT INTO zplNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Lecaxi riꞌinunu bee bene enu la nehuañi nzeꞌca, nu la nitilunu bee bene enu lleꞌnatsia nzeli arquiꞌ xi neca qui sera nú llenetsia rululá. Hasta nú riꞌinu ana nú aca elu usticia tucu nú necane. ");
INSERT INTO zplNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nu nzuculu bee bene iliulabe nú liꞌinu tsilaꞌanu liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Uyayu bee bene tucu bene enu la yeꞌe iꞌculu nu la ni lu Jesuse, xne nchiñi benechiquiꞌ arquiꞌi. Nu uriyeca Jesuse liꞌi nu uquixie nú uni nu uyeꞌe iꞌcului. ");
INSERT INTO zplNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chequie ye bee bene zeꞌe chiquiꞌ nzenu arquiꞌbeei nú unibeei: ―¿Xieꞌ laca benecuaꞌ enu necadichiaꞌ nú nzeꞌta lu familiaꞌ David la? ");
INSERT INTO zplNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Chenu ubeneꞌ bee fariseo nucuaꞌ unibeei: ―Bezeꞌlu enu rnibiyaꞌ lubee benechiquiꞌ neca enu udeteꞌ poder lu bene cuaꞌ nú rlualla benechiquiꞌ arquiꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero nediyaꞌ Jesuse lunú rriꞌi beei elliebacuꞌ, che uninu lubeei: ―Ye bee nación nu bee eyeche llene nú la neca tucunecatse rleꞌesaꞌe, leꞌca scua tunu tucu famili liñi tucu niꞌi laneca tucu necatse beella rleꞌe saꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Leꞌca scua tunu rliunu bezeꞌlu leꞌcatsia liꞌi. ¿Xneca modo nú diꞌya elurnibiyaꞌ nú rluꞌcui che? ");
INSERT INTO zplNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Liꞌihua rnihua nú rluaa bee benechiquiꞌ arquiꞌ bee bene cuna poder bezeꞌlu. Pero tunu scua necane, ¿ti rdeteꞌ poder lubee beneꞌhua para nú rlua beei bee benechiquiꞌ arquiꞌ bee bene che?, leꞌca nia luhua nú liꞌibeei rlubeꞌ beei nú la neli nú rnihua. ");
INSERT INTO zplNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Xne liꞌá rlua bee benechiquiꞌ arquiꞌ bee bene equie cuendaꞌ Espíritu Santoꞌ Diose, nucuaꞌ rlubeꞌ nú uriñala nú rnibiyaꞌ Diose luhua. ");
INSERT INTO zplNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Xne leca modo nú chuꞌu bene niꞌi tucu bene enu naaqui para nú cachiꞌi steneꞌlla, tunu la llicaꞌ cuxuilla. Che scua nuꞌ modo nú cachiꞌi steneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Bee bene enu la nzu chua, rriꞌi cundra bee nzeꞌe liꞌá, nu bee bene enu la riꞌi elietsa lua, rca nzeꞌe nú aca huaxilá bee benea. ");
INSERT INTO zplNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Enzeꞌe nia luhua nú riꞌi Diose perdona ye dula nú rriꞌi bee bene cuna ye bee bedichiaꞌ chiꞌquiꞌ nú rni bee bene. Pero la riꞌinu perdona bee bene enu rni bee bedichiaꞌ chiꞌquiꞌ equie cuendaꞌ Espiritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Rriꞌi Diose perdona titse bee bene enu rni bedichiaꞌ chiꞌquiꞌ equie cuendaꞌ liꞌá, Bene enu uxeꞌla Diose, pero titse bene enu nechiꞌquiꞌ Espíritu Santo lecaꞌ perdona para bee benecuaꞌ niꞌ lu iliulabe quieꞌ nu niꞌ liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Liꞌihua nediyaꞌhua nú aca nzeꞌca rayu ndixi nzeꞌca lue, nu aca nú la neca nzeꞌca la ayu ndixí nzeꞌca lue, xne lu cuendaꞌ ndixí nú rayu lu aca nuꞌlu bene nú xi acae. ");
INSERT INTO zplNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Liꞌisiꞌhua netsiñahua xi netsiña bee beꞌla! ¿Xa modo nú nihua bee bedichiaꞌ nzeꞌca chenu liꞌihua necha necahua? Bee bedichiaꞌ nú nuꞌ arquiꞌ bee bene enzeꞌe rni bene. ");
INSERT INTO zplNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bene nzeꞌca rni bedichiaꞌ nzeꞌca, xne nucuaꞌ nuꞌ arquiꞌlla. Nu bene enu necha neca rni bee bedichiaꞌ nú necha neca xne nucuaꞌ nuꞌ arquiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero liꞌá nia luhua nú bichia nú hualu Diose lu cuendaꞌ bee bene iliulabe, che ye bee bene deteꞌ cuenda lu Diose luye bee bedichiaꞌ nú necha neca unibeei. ");
INSERT INTO zplNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Xne equie cuendaꞌ stichiaꞌ bene, scua rlubeꞌ tunu yala nú zecalla castiya nú deteꞌ Diose lulla, nu tunu la yala zecalla castiya. ");
INSERT INTO zplNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chequie chiucu chuna bee fariseo cuna bee ulaxcuela enu reca ley uni lu Jesuse: ―Maestro, niarquiꞌru nú lañiꞌru riꞌilu tucu milagro. ");
INSERT INTO zplNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Che ucuaqui Jesuse lubeei: ―Liꞌihua bee bene enu necha rriꞌi nu sequienu bee bene rnacuꞌhua nú riaꞌa tucu milagro, pero la riꞌá niꞌtucu milagro luhua, lañiꞌtsiahua tucu nú ulleꞌca Jonás. ");
INSERT INTO zplNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Xne tucu nú ullutse Jonás chuna bichia cuna chuna rulaꞌ xlaꞌcu beꞌnaꞌ, leꞌca scua liꞌá Bene enu uxeꞌla Diose llutsea liñi yuu chuna bichia nu chuna rulaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nu bichia chenu laxu iliulabe chenu chiuꞌlue lu cuendaꞌ bee bene tiembu quieꞌ, che huañi zeca bee bene eyeche Nínive ni nú riala bee bene cuaꞌ castiya xne bee bene eyeche Nínive uzucuꞌbeei nú uni Jonas chenu unilla lubeei nú huañi beei tucu nú niarquiꞌ Diose. Nu liꞌá Jesuse enu nzu cuna liꞌihua maselá neca equiea luquela Jonás. ");
INSERT INTO zplNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nu bichia chenu laxu iliulabe, chenu hualu Diose lucuendaꞌ bee bene, chequie reina eyeche nú lee Sabá huañi zecalla nu nilla nú riala bee bene enu nucuaꞌa nee castiya nú deteꞌ Diose. Xne liꞌilla nzeꞌtalla enza mase istu, nu ubeꞌtalla para nú ubeneꞌlla lunú reca arre Salomón, nu liꞌá Jesuse enu nzu cuna liꞌihua, másela neca equiea luquela arre Salomón. ");
INSERT INTO zplNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Chenu xiuꞌu tucu benechiquiꞌ arquiꞌ tucu bene, enzei bee luguare elu nebichi rcuaꞌnai elu tsulachii, nu chenu la llelaꞌi elu tsulachii, che rriꞌi elliebacuꞌ: ");
INSERT INTO zplNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nú rni: “Mejora benchilaꞌ zecaa arquiꞌ bene elu uchiuꞌa.” Nu chenu ubenchilaꞌ zecai llelaꞌi arquiꞌ bene elu uchiuꞌi xi neca liñi tucu niꞌi nú nelata, nu nelucuꞌ nu rna nzeꞌca. ");
INSERT INTO zplNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chequie nzetucui se achi benechiquiꞌ enu maselá necha rriꞌi luquela liꞌi, nu chuꞌu ye beei arquiꞌ bene zeꞌe, nu che masescaꞌlá necha aca bene zeꞌe lunú necalla huaꞌtu. Leꞌca scua zeca bee bene enu necha rriꞌi nucuaꞌa tiembu quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Rdichiaꞌ nuscaꞌ Jesuse bee bene zeꞌe, chenu uriña naꞌnu cuna bee bichinu nucuaꞌa eliꞌyaꞌ nu niarquiꞌ beella bedichiaꞌnu beella liꞌinu. Nu lunú nucuaꞌa beella eliꞌyaꞌ, ");
INSERT INTO zplNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","che uyatixiuleꞌe tucu bene lu Jesuse nú unilla lunu: ―Nzu naꞌlu cuna bee bichilu eliꞌyaꞌ nu niarquiꞌ beella bedichiaꞌnu beella liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero uninu lu bene enu uya udixiuleꞌe lunu: ―¿Ti neca naa, nu ti neca bee bichia? ");
INSERT INTO zplNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chequie ulubeꞌyanu lubee beneꞌnu, nú uninu: ―Bee benequieꞌ neca naa cuna bee bichia. ");
INSERT INTO zplNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Xne titse bee bene enu rriꞌi lunú niarquiꞌ Diose Pa liñibe, bee nzeꞌe neca bee bichia, cuna bee zanaa nu naa. ");
INSERT INTO zplNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Leꞌca bichia zeꞌe uchiuꞌu Jesuse niꞌi elu uyaꞌnanu nu uya zucunu ruꞌu inzatuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nu lunú chiquiꞌ huaxi bee bene uyetesaꞌ lunu, che uquienu equie tucu barco nu uzucunu liñii nu ye bee bene ucuaꞌa lunu ruꞌu inzatuꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nu huaxi beenú uzeteꞌnu bee bene zeꞌe cuna puro bee ejemplu. Nu uninu lubeei: ―Uchiuꞌu tucu bene nzetuꞌ nii, ");
INSERT INTO zplNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","nu chenu rduꞌlla nii, uzanaꞌ lleꞌna ebichi zeꞌe lu inziu, nu uriña bee iñi udacue. ");
INSERT INTO zplNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Lleꞌnae uzanaꞌ leta quiee, elu leca huaxi yuu, nu yexetsia uliñi ebichi zeꞌe xne la aca aquié lu yuu. ");
INSERT INTO zplNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero chenu uliñi bichia, nu unga nele unguꞌlune nu ubichii xne laca aquié nchiñi lue lu yuu. ");
INSERT INTO zplNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nu lleꞌna ebichi uzanaꞌ leta bee eche nu chenu enta ruꞌcue, ubichii xne uriꞌi eche ana lue. ");
INSERT INTO zplNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero lleꞌna ebichi nú uzanaꞌ lu yuu ruꞌcu, chiquiꞌ unguyuꞌe, mae unguyuꞌ tucu ayuꞌu ebichi lu, nu mae unguyuꞌ sesenta ebichi, nu mae unguyuꞌ treinta ebichi scua unguyuꞌ bee. ");
INSERT INTO zplNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Titse bee bene enu niarquiꞌ yeneꞌ nú rnia, ¡quieꞌe diaca nzeꞌe! ");
INSERT INTO zplNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Che uyabica bee beneꞌ Jesuse lunu nu unidichiaꞌ beella lunu xinu seteꞌnu bee bene cuna puro bee ejemplu tsia. ");
INSERT INTO zplNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nu ucuaquinu nú uninu lubeella: ―Liꞌihua uliquiꞌ Diose nú riꞌihua beyaꞌ xneca neca lunú aꞌchi neca nú rnibiyaꞌnu. Pero lubee benequieꞌ lá deteꞌnu nú riꞌi beella beyaꞌ nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Xne bee bene enu rriꞌi beyaꞌ Stichiaꞌ Diose, liquiꞌlánu nú riꞌilá beella beyaꞌ stichiaꞌnu, pero bee bene enu lleꞌnatsia rriꞌi beyaꞌ stichiaꞌnu, nu la laꞌnalla nú riꞌilálla beyaꞌ stichiaꞌnu hasta lu lleꞌnatsia nú rriꞌilla beyaꞌ la riaꞌlla beyaꞌ nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Enzeꞌe rnia lubeella equie cuendaꞌ bee ejemplu tsia, xne mase riꞌya beella nu neca xi neca nula lañiꞌ beella nu mase rieneꞌ beella pero neca xi neca nu la yeneꞌ beella. Nu la riꞌi beella beyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Scua rialu nú uquieꞌe profeta Isaías chenu unilla: Mase rieneꞌ beei, pero la riꞌi beei beyaꞌ. Nu mase riꞌya beei, pero neca xi neca nú la lañiꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Xne chiquiꞌ unga nziti arquiꞌbeei, nu rriꞌi beei xi neca nú la lañiꞌbeei, nu xi neca nú nenguataꞌ beei para nú la lañiꞌbeei, nu la yeneꞌ beei nu la riꞌi beei beyaꞌ, xne la zelaꞌ beei yeꞌta beei cuna liꞌá, para nú riꞌá perdona stula beei. ");
INSERT INTO zplNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pero liꞌihua: Ñia neca lu cuendaꞌhua nú rlañiꞌhua lunú rlañiꞌhua nu rieneꞌhua lunú rieneꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Xne liꞌá nia luhua nú huaxi bee profeta nu huaxi bee bene enu uhuañi nzeꞌca uniarquiꞌ beella lañiꞌ beella lunú rlañiꞌhua. Nu né lañiꞌ beella nucuaꞌ. Leꞌca uniarquiꞌ beella yeneꞌ beellla lunú rieneꞌhua, pero né yeneꞌ beellae. ");
INSERT INTO zplNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Uzuꞌcuꞌ diacahua ne ixiuleꞌa xi rni ejempluꞌ bene enu uya tuꞌ nii trigo. ");
INSERT INTO zplNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bee bene enu rieneꞌ Stichiaꞌ Diose nu la riꞌi beyaꞌ xi rnii, liꞌibeei neca beei xi neca ebichi nú uzanaꞌ inziu, xne chu nzeꞌta bezeꞌlu nu raxii Stichiaꞌ Diose nú ubeneꞌlaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nu bee ebichi nú uzanaꞌ leta quiee, neca xi neca bee bene enu rieneꞌ Stichiaꞌ Diose nu ñia riucu arquiꞌbeeii, ");
INSERT INTO zplNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pero lunú neca beei xi neca bee huañi nú leca huaxi luu la nzutaꞌ arquiꞌbeei chenu nehuana seca beei nu rana arquiꞌ bee bene liꞌibeei, che sanaꞌ arquiꞌ beei Stichiaꞌ Diose nú ubeneꞌlaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bee ebichi nú uzanaꞌ leta eche, neca xi neca bee bene enu rieneꞌ Stichiaꞌ Diose, pero lunú máse nzenu arquiꞌbeei nú nuꞌ lu iliulabe quieꞌ nu máse seca beei eluxene nú nuꞌ lu iliulabequieꞌ, che ye bee nucuaꞌ rriꞌi nú sanaꞌ arquiꞌbeei Stichiaꞌ Diose. Nu lecaxi zibiꞌ nú ubeneꞌbeei Stichiaꞌ Diose che. ");
INSERT INTO zplNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero bee ebichi nú ubenii lu yuu ruꞌcu, neca xi neca bee bene enu rieneꞌ Stichiaꞌ Diose nu rriꞌi beyaꞌe, nu liꞌibeella rriꞌi beella ana bee bene para nú chili arquiꞌbeei Stichiaꞌ Diose, tucu nú neca bee ebichi nú unguyuꞌ tucu ayuꞌu ebichi lu, nu unguyuꞌ sesenta ebichi, nu unguyuꞌ treinta ebichi. ");
INSERT INTO zplNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Uni Jesuse stucu ejemplu lubee bene zeꞌe: ―Lunú xneca rnibiyaꞌ Diose neca xi neca tucu bene enu uquienii ebichi nzeꞌca lu yuuꞌ; ");
INSERT INTO zplNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","pero diquila nú raꞌtse bee bene uriña bene enu rana arquiꞌ liꞌilla uquienii ebichiꞌ huañi nu la zibiꞌ leta bee trigoꞌlla, nu chu nza nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Chenu uruꞌcu trigo nu uliñi tuu lue, leꞌca nuu bee huañi nu la zibiꞌ zeꞌe nuꞌ leta bee uruꞌcu. ");
INSERT INTO zplNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nu che uyatixiuleꞌe bee mosoꞌlla lulla, nu unibeei lulla: “Detá, lanu ebichi nzeꞌcatsia uquieniilu lu yuuꞌlu la, ¿cá uchiuꞌu bee huañi nú nuꞌ leta bee trigo?” ");
INSERT INTO zplNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Che uni bene enu neca stene trigo: “Tucu bene enu rana arquiꞌ liꞌá uriꞌi nucuaꞌ.” Che uni bee mosoꞌ zeꞌe lulla: “¿Niarquiꞌlu nú nzetaxiru bee huañi nu la zibiꞌ cuaꞌ letae la?” ");
INSERT INTO zplNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Che unilla lubeei: “Mejora nú la axihuane, xne canu chenu axihuane leꞌca nuu bee trigo yetsu. ");
INSERT INTO zplNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mejora nú zelaꞌahua nú ruꞌcu bee cuna trigo hasta chenu aca ulaꞌcuꞌ trigo. Che nia lubee bene enu riꞌi ulaꞌcuꞌ trigo nú rluti quieteꞌsaꞌxu beei huañi cuaꞌ nu riꞌi menuxu beeii para nú chiquine. Cheelá quieteꞌ saꞌbeei trigo nu ducheꞌ beei trigo elu riala nú chucheꞌe.” ");
INSERT INTO zplNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Leꞌca uni Jesuse stucu ejemplu lubee bene: ―Lunú xneca rnibiyaꞌ Diose neca xi neca tucu ebichiꞌ mestasa nú rquienii tucu bene lu yuuꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nú masela meꞌe luye bee ebichi. Pero chenu rruꞌcue, masescaꞌla llenee luye beelá bee huañi, nu rruꞌcue xi rruꞌcu tucu aca, hasta nú rrecheꞌ bee iñi exliaꞌtseꞌ beeí lu ellutsaꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Leꞌca uni Jesuse stucu ejemplu lubee bene: ―Lunú xneca rnibiyaꞌ Diose neca xi neca levadura nú rcucha tucu unaꞌa cuna chuna medida harina para nú tsebichi ecucu. ");
INSERT INTO zplNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ye beenú uzeteꞌ Jesuse bee bene, liꞌinu uzeteꞌnu liꞌibeei cuna puro bee ejemplu nu lecaxi nu lá zeteꞌnu liꞌibeei sin lu cuendaꞌ bee ejemplu tsia. ");
INSERT INTO zplNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Scua ungae para nú uyalu tucu nú uni profeta: Nia lubee bene cuna puro bee ejemplu. Nia lubee bene beenú aꞌchiꞌ neca lubeei desde chenu urecheꞌ Diose iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chenu ulaxu nú uni Jesuse lubee bene zeꞌe che inziue beella nu uyuꞌu Jesuse liñi niꞌi cuna bee beneꞌnu, nu uni bee beneꞌnu lunu: ―Udixiuleꞌe luru xi rni ejempluꞌ bee huañi nú la zibiꞌ nú nuꞌ leta bee trigo. ");
INSERT INTO zplNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nu ucuaquinu lubeella nú uninu: ―Bene enu uduꞌnii ebichi nzeꞌca zeꞌe, neca liꞌá Bene enu uxeꞌla Diose, ");
INSERT INTO zplNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","nu lu yuu elu uyuꞌu nii neca iliulabe. Nu bee ebichi nzeꞌca neca bee beneꞌ Diose, nu bee huañi nu la zibiꞌ neca bee bene enu neca bee beneꞌ bezeꞌlu, ");
INSERT INTO zplNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","nu enu rana arquiꞌ liꞌá uquienii huañi nu la zibiꞌ zeꞌe neca bezeꞌlu. Nu ulaꞌcu neca xi neca chenu laxu iliulabe, nu bee enu rriꞌi ulaꞌcu neca bee ángeleꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nu tucu nú rieteꞌ saꞌ huañi nu la zibiꞌ para nú chiquine, leꞌca scua aca chenu laxu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Liꞌá Bene enu uxeꞌla Diose lu iliulabe, xeꞌlaa bee ángelea para nú huachu beenu bee bene enu necha rriꞌi leta bee benea, nu cuna ye bee bene enu rriꞌi dula. ");
INSERT INTO zplNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nu tsiꞌqui beenu bee bene cuaꞌ luquii liñi horno, elu unaꞌ beella nu acuxaꞌ laya beella. ");
INSERT INTO zplNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Che bee bene enu nehuañi tucu nú niarquiꞌ Diose, aca rulusiquiꞌ beella elurnibiyaꞌ Diose Pa liñibe xi rulusiquiꞌ bichia. Bee bene enu niarquiꞌ nú yeneꞌ nú rnia, quieꞌe diaca nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Lunu xneca rnibiyaꞌ Diose neca xi neca tucu nú huaxi seca nú nuꞌcheꞌ aꞌchiꞌ lu tucu yuu. Nu tucu bene ullelaꞌe nu uduꞌcheꞌ aꞌchiꞌ zecallae elu ullelaꞌllae, che chiquiꞌ ñia nzu arquiꞌlla nze tutilla yebee steneꞌlla para nú tsilla yuu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Leꞌca nia luhua nú lunú xneca rnibiyaꞌ Diose neca xi neca tucu bene enu rriꞌi berexe nu rcuaꞌnalla perla nú huaxi seca, ");
INSERT INTO zplNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","nu chenu ullelaꞌlla tucu perla nú huaxi seca, che nzalla nze tutilla yebee steneꞌlla nú rluꞌculla para nú tsilla perla zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Leꞌca scua lunú rnibiyaꞌ Diose neca xi neca tucu ixiu nú rduꞌ bee bene lu inzatuꞌ nú rucu yelu clasia bee bela. ");
INSERT INTO zplNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nu chenu ucheela ixiu zeꞌe, ulua beellae ruꞌu inzatuꞌ, nu zeꞌe ucuaꞌa beella ucañi beella bee bela enu nuꞌ liñii, nu uduꞌcheꞌ beella bee bela nzeꞌca liñi llume, nu utsiꞌqui beella bee bela enu la zibiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Leꞌca scua aca chenu laxu iliulabe; nzeꞌta bee ángeleꞌnu para nú huachu beenu bee bene enu necha rriꞌi leta bee bene enu rriꞌi nzeꞌca, ");
INSERT INTO zplNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","nu tsiꞌqui bee ángele bee bene enu necha rriꞌi cuaꞌ lu quii liñi horno, elu unaꞌ beella nu acuxaꞌ laya beella. ");
INSERT INTO zplNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nu uni Jesuse lubee beneꞌnu: ―¿Uriꞌihua beyaꞌ yebee nú unia la? Che uni beella: ―Aahuaꞌ, uriꞌiru beyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chequie uni Jesuse lubeella: ―Yebee ulaxcuela enu reca ley, nee rriꞌila beella beyaꞌ xa neca elurnibiyaꞌ Diose, liꞌibeella neca beella xi neca tucu bene enu neca stene tucu niꞌi enu nucheꞌ beenú nucheꞌe nu recalla rcañilla beenú cuqui cuna beenú uxu leta ye beenú rluꞌculla. ");
INSERT INTO zplNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Chenu ulaxu nú udixiuleꞌe Jesuse xi rni bee ejemplu cuaꞌ lubee bene, uchiuꞌunu zeꞌe nzanu ");
INSERT INTO zplNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nu uriñanu lachinu. Che uzeteꞌnu bee bene liñi indu eyeche zeꞌe. Chiquiꞌ nzenu arquiꞌ bee bene zeꞌe nú unibeei lu saꞌbeei: ―¿Cá unga nucuaꞌ ye nú reca nucuaꞌ? ¿Nu xneca reca nucuaꞌ rriꞌi nucuaꞌ bee milagro? ");
INSERT INTO zplNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Xieꞌ lanu llianaꞌ bene enu rriꞌi riñaꞌ ruꞌu bangu nucuaꞌ, nu lanu María neca naꞌ nucuaꞌ la? ¿Nu lanu bee bichi nucuaꞌ neca Jacobo, José, Simón nu Judas la? ");
INSERT INTO zplNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Nu xieꞌ lanu eyeche quieꞌ nucuaꞌa bee zana nucuaꞌ la? ¿Cá unga nucuaꞌ lu ye nú chiquiꞌ reca nucuaꞌ che? ");
INSERT INTO zplNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nu lá riꞌi caso beei Jesuse. Che uninu lubeei: ―Catse rluꞌcu bee bene ulaꞌna lu tucu profeta. Pero lachilla nu niꞌlla, la luꞌcu bee bene ulaꞌna lulla. ");
INSERT INTO zplNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nu né riꞌinu huaxi bee milagro zeꞌe xne né chili arquiꞌ bee bene zeꞌe liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Timbu zeꞌe arre Herodes enu rnibiyaꞌ lu iliu Galilea, ubeneꞌlla ye beenú rriꞌi Jesuse, ");
INSERT INTO zplNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nu unilla lubee mosoꞌlla: ―Juan Bautista nucuaꞌ, uhuañi zeca. Enzeꞌe rluꞌculla poder cuaꞌ nú rriꞌilla bee milagro. ");
INSERT INTO zplNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Uni Herodes scua xne liꞌilla unibiyaꞌlla nú ulluna Juan nu uyacaꞌculla cuna cadena uyuꞌulla niꞌcuꞌ. Uriꞌi Herodes scua equie cuendaꞌ Herodías, enu unga unaꞌa bichilla Felipe, ");
INSERT INTO zplNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","xne uni Juan lu Herodes: ―La yala nú zucunuulu leꞌcatsia unaꞌa bichilu. ");
INSERT INTO zplNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nu niarquiꞌ Herodes nú utilla Juan, pero xiquilla bee bene, xne ye bee bene rni nú neca Juan tucu profeta. ");
INSERT INTO zplNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero chenu reca eliñi nú relluꞌcu Herodes lana, che uyeꞌe xinchiuꞌcu Herodías lubee bene enu nezeneꞌ lu eliñi zeꞌe, nu chiquiꞌ uyuꞌ arquiꞌ Herodes xa uyeꞌenchu, ");
INSERT INTO zplNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","nu hasta uquieꞌella Diose nú deteꞌlla xitse nú nacuꞌnchu lulla. ");
INSERT INTO zplNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nu naꞌ enduꞌ cuaꞌ uni lunchu, nú ninchu lu Herodes: ―Uliꞌquiꞌ lluca equie Juan Bautista liñi tucu pliato lua. ");
INSERT INTO zplNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Che nehuana utsu arquiꞌ arre Herodes, pero lunú uquieꞌelalla Diose lu ye bee bene enu nezeneꞌ lu eliñiꞌlla nú deteꞌlla xitse lunú nacuꞌnchu, enzeꞌe unibiyaꞌlla lubee sundaduꞌlla nú yeꞌtayu beei nú rnacuꞌnchu lulla. ");
INSERT INTO zplNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Che unibiyaꞌlla nú chiecuꞌ bee sundadu lluca equie Juan liñi niꞌcuꞌ, ");
INSERT INTO zplNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","nu uriñayu beei lluca equie Juan nchiucuꞌ liñi tucu pliatu, nu udeteꞌ beeii yanchu, nu chu udeteꞌnchue ya naꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Che uriña bee beneꞌ Juan unguyaꞌ cuerpoꞌ Juan nu uya caꞌchiꞌ beella cuerpoꞌlla, cheelá uyatixiuleꞌe beella lu Jesuse lunú unga. ");
INSERT INTO zplNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Chenu ubeneꞌ Jesuse nú unguti Juan, uchiuꞌunu zeꞌe nza tuculiꞌnu liñi tucu barco, tucu luhuare elu lecalí tinuꞌ, para nú nzu tuculiꞌnu zeꞌe. Pero chenu uriꞌi bee bene beyaꞌ nú nzanu uchiuꞌu bee bene bee eyeche enza zeꞌe nzenala liꞌinu nu se eꞌya beei nzuebeei elu riñanu. ");
INSERT INTO zplNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chenu ulaca Jesuse equie barco, ulañiꞌnu nú tesquielaꞌ huaxi bee bene nucuaꞌa zeꞌe nu uhuaꞌa arquiꞌnu beella, che uriyecanu bee bene enu riti nuyaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nu chenu uchela, uyabica bee beneꞌnu lunu nu uni beella lunu: ―Uchela nee nu caꞌa neca tucu luhuare elu la nucuaꞌa niꞌ tucu bee bene. Uniꞌ lubee bene nú chue beei lubee eyeche para nú tsi beei nú acu beei. ");
INSERT INTO zplNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nu uni Jesuse lubeella: ―La quiꞌña nú yue beei, liꞌihua udeꞌtehua nú acu beei. ");
INSERT INTO zplNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nu uni beella lunu: ―Pero rluꞌcutsiaru ayuꞌ pa cuna chiucu bela. ");
INSERT INTO zplNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Che uni Jesuse lubeella: ―Uteyuhuane caꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Chequie unibiyaꞌnu nú cuaꞌa bee bene añi zeꞌe lu ixi xata. Nu unaꞌtsenu lu ayuꞌ pa zeꞌe cuna rucu bela nu ubiꞌyanu enza liñibe nu udeteꞌnu cheꞌtsa lu Diose. Nu chu uleꞌenu bee pa cuaꞌ udeteꞌnu ya bee beneꞌnu para nú ritsiꞌ beellae lu ye bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ye bee bene zeꞌe udacu beei hasta nú ubelaꞌ beei, nu uquietesaꞌscaꞌ beei chiꞌchiucu llume bee pa nú uyaꞌna. ");
INSERT INTO zplNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bee enu udacu neca casi ayuꞌ mili puro bee niyu, sin nú bacuꞌ bee unaꞌa cuna bee enduꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Che chu unibiyaꞌ Jesuse nú chuꞌu bee beneꞌnu liñi barco para nú riculubeella chue beella stucu chu inzatuꞌ. Diquila nú rninu lubee bene nú nzanu. ");
INSERT INTO zplNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Chenu ulaxu uninu lubee bene zeꞌe nú nzanu, uquienu equie tucu dañi para nú nacuꞌnu lu Diose zeꞌe. Chenu uyuꞌu rulaꞌ nzu tuculiꞌnu zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","nu barco nú nza bee beneꞌnu istula nzae lu inzatuꞌ, nu chiquiꞌ necha rriꞌinu inzatuꞌ barco, xne chiquiꞌ reca bii enza lu barco. ");
INSERT INTO zplNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nu elliecabe see Jesuse lu inzatuꞌ, nzanu enza lubee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Chenu ulañiꞌ bee beneꞌnu nú senu lu inzatuꞌ, ulliqui beella nu ubixialí beella nú uni beella: ―¡Tucu benechiquiꞌ! ");
INSERT INTO zplNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero uni Jesuse lubeella: ―¡Utsu naaqui arquiꞌhua! ¡Liꞌá nucuaꞌ la lliquihua! ");
INSERT INTO zplNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chequie uni Pedro lu Jesuse: ―Detá, tunu liꞌilu nucuaꞌ, unibiyaꞌ nú tsea lu inzatuꞌ nzela hasta lulu. ");
INSERT INTO zplNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Che uni Jesuse lulla: ―Utee che. Nu che chu ulaca Pedro equie barco nu uquixiella sella lu inzatuꞌ nzalla lu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero chenu utsiꞌlla nú chiquiꞌ reca bii, ulliquilla nu uquixie ratseꞌlla lu inzatuꞌ, nu urixialilla unilla: ―¡Detá, utsilaꞌa liꞌá! ");
INSERT INTO zplNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hora zeꞌe unaꞌtse Jesuse yalla, nu uninu lulla: ―¡Xinu lleꞌnatsia nzeli arquiꞌlu liꞌá! ¿Xiquie nú uzaꞌ arquiꞌlu? ");
INSERT INTO zplNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nu chenu uquie beella equie barco, ungaxe bii. ");
INSERT INTO zplNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chequie beelá bee enu nchiucuꞌ equie barco, utsulliqui beella lu Jesuse nú uni beella lunu: ―¡Nelíca nú liꞌilu necalu lliꞌñi eꞌcu Diose! ");
INSERT INTO zplNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chequie udete beella lu inzatuꞌ zeꞌe, nu uriña beella stucu chu ruꞌu inzatuꞌ lu iliu nú lee Genesaret. ");
INSERT INTO zplNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nu uyuꞌulu bee bene luhuare zeꞌe liꞌinu nú necanu Jesuse, nu ungabiyaꞌ ye bee bene diqui enza zeꞌe nú uriñanu zeꞌe, che uriñayu bee bene zeꞌe bee bene enu riti lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nu uziquie beei lunu nú zelanu nú tiꞌya beei masia ruꞌu xucunu, nu ye bee bene enu utiꞌya ruꞌu xucunu uyecaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chequie uyabica chiucu chuna bee fariseo cuna bee ulaxcuela enu reca ley lu Jesuse, nu nzeꞌta beella enza Jerusalén, nu uni beella lunu: ");
INSERT INTO zplNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Xiquie núla zucuꞌ bee beneꞌlu custumbre nú utsaꞌna bee beneꞌahua enu udetela? ¿Xiquie núla naa bee beneꞌlu chenu racu beei tucu nú neca custumbre? ");
INSERT INTO zplNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Che uni Jesuse lubeella: ―¿Leꞌca xiquie nú sanaꞌ arquiꞌhua Stichiaꞌ Diose, para nú nzenalahua lunú neca costumbreꞌtsiahua? ");
INSERT INTO zplNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Xne uni Diose: “Luꞌcu ulaꞌna lu paꞌlu cuna lu naꞌlu”, nu “Enu riquichiꞌquiꞌ paꞌ cuna naꞌ rquiꞌña nú ati nzeꞌe.” ");
INSERT INTO zplNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero liꞌihua rnihua nú nuꞌ modo ni bene lu paꞌlla cuna lu naꞌlla: “Leca modo riꞌá elietsa luhua, xne ye nú rluꞌcua necalane uꞌna para Diose”, ");
INSERT INTO zplNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","rnihua nú titse bee bene enu ni scua, la quiꞌñia nú riꞌi nzeꞌe elietsa lu paꞌ nzeꞌe cuna lu naꞌ nzeꞌe. Scua ruachuhua Stichiaꞌ Diose, nu nzenalahua costumbreꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Lia rriꞌihua nú nehuañi nzeꞌcahua! Neli nú uni profeta Isaías lu cuendaꞌhua chenu unilla: ");
INSERT INTO zplNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bee benequieꞌ rnibeei nú rluꞌcu beei ulaꞌna lua, pero niꞌ temeꞌ la luꞌcu beei ulaꞌna lua. ");
INSERT INTO zplNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lecaxi sibiꞌ nú rluꞌcu beei ulaꞌna lua, xne seteꞌtsia beei lunú xelatsia arquiꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chequie ubixia Jesuse ye bee bene zeꞌe, nu uninu lubeei: ―Uzuꞌcuꞌ diacahua nu uriꞌihua beyaꞌ nú nia luhua: ");
INSERT INTO zplNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","La neca nú racu bene nú rriꞌi, nú rriꞌi bene dula. Sino que bee bedichiaꞌ nú rni bene enzeꞌe rriꞌi nú rriꞌi bene dula. ");
INSERT INTO zplNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chequie uyabica bee beneꞌ Jesuse lunu nu uni beella lunu: ―¿Uriꞌilu beyaꞌ nú né yuꞌ arquiꞌ bee fariseo bee bedichiaꞌ nú unilu la? ");
INSERT INTO zplNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nu ucuaquinu lubee beneꞌnu nú uninu: ―Ye bee aca nú lá quieni Paa liñibe yetsu hasta lue. ");
INSERT INTO zplNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Cualaꞌ beella, xne necatsia beella xi neca bene enu nequieꞌlu enu rlubeꞌ lu stucu bene enu nequieꞌlu nú cá enza tsella, nu tunu tucu bene enu nequieꞌlu rlubeꞌ stucu bene enu nequieꞌlu cá enza tsella, che rucu beella nuꞌ modo nú zanaꞌ beella liñi tucu iꞌchiu. ");
INSERT INTO zplNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Che uni Pedro lu Jesuse: ―Udixiuleꞌe luru xi rni bee bedichiaꞌ nú unilu. ");
INSERT INTO zplNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chequie uni Jesuse: ―¿Xieꞌ leꞌca nuuhua lá riꞌihua beyaꞌ lunú unia la? ");
INSERT INTO zplNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Xieꞌ la riꞌihua beyaꞌ nú ye bee elubacu nú racu bee bene rlacae xlaꞌcu bee bene, nu che chu xiuꞌu zecae la? ");
INSERT INTO zplNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero bee bedichiaꞌ nú rni bee bene, xiuꞌu nucuaꞌ arquiꞌ bee bene, nu bee nucuaꞌ rriꞌi nú rriꞌi bee bene dula. ");
INSERT INTO zplNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Xne liñi arquiꞌ bene xiuꞌu nú necha rriꞌi bene elliebacuꞌ, nú ruuti bene saꞌbene, nú rluꞌcu niyu stucu unaꞌa, urre rluꞌcu unaꞌa stucu niyu, nú rriꞌi bene eluhuexe, nú rriꞌi bene eluhuanaꞌ, nú rni bene eluquichiaꞌ, nú riquichiꞌquiꞌ bene saꞌ bene. ");
INSERT INTO zplNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bee nucuaꞌ rriꞌi nú rriꞌi bee bene dula. Pero tunu la naa bene chenu racu bene tucu nú neca custumbre nú riala riꞌi bene ante nú acu bene, la neca nucuaꞌ nú rriꞌi nú rriꞌi bee bene dula. ");
INSERT INTO zplNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chenu uchiuꞌu Jesuse lu iliu Genesaret nzanu enza lu eyeche Tiro cuna lu eyeche Sidón. ");
INSERT INTO zplNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Enza zeꞌe uchiuꞌu tucu unaꞌa enu neca bene lu iliu Canaán lu Jesuse nu urixialinchu nú uninchu lunu: ―¡Detá, llianaꞌ David, uhuaꞌa arquiꞌ liꞌá! Biꞌyacuru xinchiuꞌcua nchiñi benechiquiꞌ arquiꞌ nu chiquiꞌ nehuana secanchu. ");
INSERT INTO zplNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nu né cuaquilí Jesuse lunchu. Che uyabica bee beneꞌnu lunu nu uziquie beella lunu nú uni beella: ―Uniꞌ lu unaꞌa cuaꞌ nú yanchu xne rixialinchu nzeꞌtaquienchu liaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Che uni Jesuse lubee beneꞌnu: ―Uxeꞌla Diose liꞌá para nú riꞌitsia elietsa lubee bene Israel enu la chenalaꞌ inziuꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero che uyabica unaꞌa zeꞌe lunu nu utsulliquinchu lunu, nú uninchu lunu: ―¡Detá, uriꞌi elietsa lua! ");
INSERT INTO zplNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nu uni Jesuse lunchu: ―La neca nzeꞌca nú axi bene pá ya bee enduꞌ nu deteꞌ benene acu bee nicu. ");
INSERT INTO zplNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chequie uni unaꞌa zeꞌe lu Jesuse: ―Neliꞌlu nucuaꞌ Detá, pero hasta bee nicu racu bee pá ube nú sanaꞌ liñi mexaꞌ bene enu neca stene nicu. ");
INSERT INTO zplNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Che uni Jesuse lunchu: ―¡Unaꞌa liꞌisiꞌlu chiquiꞌ nzeli arquiꞌlu liꞌá! Aca tucu nú niarquiꞌlu. Nu hora zeꞌe, uyecaꞌ enduꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chenu uchiuꞌu Jesuse zeꞌe uriñanu ruꞌu inzatuꞌ Galilea. Che chu uquienu equie tucu dañi nu uzucunu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nu uyetesaꞌ huaxi bee bene lunu zeꞌe, nu uriñayu beei bee bene enu necuxu, cuna bee bene enu niquieꞌlu, cuna bee bene enu nemangu, cuna bee bene enu la ni, cuna bee bene enu seca huaxilá lu elichia. Uriñayu beei bee bene quieꞌ lunu, nu uriyecanu beei. ");
INSERT INTO zplNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chequie chiquiꞌ uyanu arquiꞌ bee bene zeꞌe chenu ulañiꞌ beei nú rnila bee bene enu lani, nú uyecalaꞌ bee bene enu nemangu, nú sela bee bene enu necuxu, nú riꞌyala bee bene enu niquieꞌlu. Nu uquixie uni beella bedichiaꞌ nzeꞌca lu Dioseꞌ bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chequie ubixia Jesuse bee beneꞌnu nu uninu lubeella: ―Ruꞌu arquia bee benequieꞌ, xne necala chuna bichia nú nucuaꞌa beei lua nu la uyaꞌ beei nú acu beei. La niarquia nú xeꞌlaa beei yue beei scuatsia niꞌi beei, xne cá chiulaꞌ beei inziu. ");
INSERT INTO zplNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Che uni bee beneꞌnu lunu: ―Pero ¿ca chiyaꞌahua nú acu ye bee bene añiquieꞌ, luhuare quieꞌ elu lecati nucuaꞌa? ");
INSERT INTO zplNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nu unedichiaꞌ Jesuse lubeella, nú uninu: ―¿Xala pa rluꞌcuhua? Nu ucuaqui beella lunu: ―Rluꞌcuru achine cuna chiucu chuna bee bela. ");
INSERT INTO zplNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nu che chu unibiyaꞌnu nú cuaꞌa bee bene zeꞌe luyuu. ");
INSERT INTO zplNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nu unaꞌtsenu lu achi bee pa cuna bee bela, nu udeteꞌnu cheꞌtsa lu Diose. Nu uleꞌenu bee pa zeꞌe udeteꞌnu ya bee beneꞌnu para nú ritsiꞌ beellae luye bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ye bee bene zeꞌe udacu hasta nú ubelaꞌ beei. Nu uzucu subrascaꞌ achi llume bee pa nú uyaꞌna. ");
INSERT INTO zplNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bee bene enu udacu neca tacu mili bee niyu, pero la nebacuꞌ bee unaꞌa cuna bee enduꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chenu ulaxu nú uni Jesuse lubee bene zeꞌe nú nzalanu. Che chu uyuꞌunu liñi barco nu nzanu lu iliu nú lee Magdala. ");
INSERT INTO zplNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Uya bee fariseo cuna bee saduceo lu Jesuse para nú riꞌi beei preo liꞌinu. Nu unacuꞌ beei lunu nú riꞌinu tucu milagro nú lubeꞌnu lubeei tunu neli nú nzeꞌtanu lu cuendaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Che uni Jesuse lubeei: ―Bee uche chenu neluu rnaa liñibe, che rnihua: “Nú nzeꞌta nú ñia tsu bichia yeꞌe.” ");
INSERT INTO zplNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nu bee zilaꞌ chenu rlañiꞌhua nú neluu rnaa liñibe nu nuꞌ xcabe che rnihua: “Necha tsu bichia quieꞌ, rriꞌihua beyaꞌ xa neca bee seña liñibe.” ¿Xiquie nú la riꞌihua beyaꞌ xa neca lunú reca nee? ");
INSERT INTO zplNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bee enu necha rriꞌi bee lee lecaxi chili arquiꞌhua nu rnacuꞌhua tucu milagro lua, pero lecaꞌ xi milagro lañiꞌlaꞌhua ulañiꞌtsiahua tucu milagro nú ulleꞌca Jonás. Nu chu utsaꞌnanu bee bene cuaꞌ, nu chu nzanu. ");
INSERT INTO zplNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Chequie chenu udete beella stucu chu inzatuꞌ, uzañiꞌ bee beneꞌnu a uyaꞌ beella pa acu beella. ");
INSERT INTO zplNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Che uni Jesuse lubeella: ―Ubiꞌyahua liꞌihua, lu cuendaꞌ levaduraꞌ bee fariseo cuna bee saduceo. ");
INSERT INTO zplNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Che uni bee beneꞌnu lu saꞌbeella: ―Uninu scua xne lá auyaꞌahua pá daꞌcuaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero uriꞌi Jesuse beyaꞌ nú unibeella lu saꞌbeella, nu uninu lubeella: ―¿Xinu rnihua nú la luꞌcuhua pá? ¡Xinu lleꞌnatsia nzeli arquiꞌhua liꞌá! ");
INSERT INTO zplNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Xieꞌ lascaꞌ riꞌihua beyaꞌ, nu la elluꞌcu arquiꞌhua chenu udetea ayuꞌtsia pá udacu ayuꞌ mili bee bene la? ¿Nu se xala llume pá nú uzucu subrascaꞌ uquietesaꞌhua? ");
INSERT INTO zplNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nu xieꞌ leꞌca la elluꞌcu arquiꞌhua chenu udetea achi pá udacu tacu mili bee bene, nu se xala llume pá nú uzucu subra uquieteꞌsaꞌhua la? ");
INSERT INTO zplNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Xiquie nú lá riꞌihua beyaꞌ nú lá nia luhua lu cuendaꞌ pá, liꞌá rnia luhua nú biꞌyahua liꞌihua lu levaduraꞌ bee fariseo cuna bee saduceo. ");
INSERT INTO zplNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Che uriꞌi bee beneꞌnu beyaꞌ nú lá ninu lu cuendaꞌ levadura, sino que uninu lubeella nú biꞌya beella liꞌibeella lunú xa seteꞌ bee fariseo cuna bee saduceo bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Chenu uriña Jesuse lu iliu Cesarea de Filipo, unedichiaꞌnu lubee beneꞌnu nú uninu: ―¿Ti rni bee bene nú neca Liꞌá Bene enu uxeꞌla Diose? ");
INSERT INTO zplNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nu ucuaqui beella lu Jesuse, nú unibeella: ―Nuꞌ bee bene enu rni nú necalu Juan Bautista, nu leꞌca nuꞌ bee enu rni nú necalu profeta Elías, nu nuꞌ bee enu rni nú necalu profeta Jeremías, urre stucu profeta huaꞌtu. ");
INSERT INTO zplNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Che uninu lubeella: ―Liꞌiquiehua, ¿ti rnihua nú necaa? ");
INSERT INTO zplNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nu ucuaqui Simón Pedro lunu: ―Liꞌilu necalu Cristo, Lliꞌñi Diose enu nehuañi. ");
INSERT INTO zplNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Che uni Jesuse lulla: ―Ñia neca lu cuendaꞌlu Simón llianaꞌ Jonás, xne niꞌ tucu bee bene ne ixiuleꞌe nucuaꞌ lulu, sino que Paa enu nzucu liñibe ulubeꞌ nucuaꞌ lulu. ");
INSERT INTO zplNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nu liꞌá nia nú necalu Pedro, nu rni nucuaꞌ quiee, nu equie cuendaꞌ liꞌilu aca huaxilá bee benea nu niꞌ eluti la riꞌi ana nitilu liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Liꞌá liquia elurnibiyaꞌ nú nzeꞌta enza liñibe lulu, nu lu titse enu niilu nú neca perdonala stula lu iliulabe quieꞌ, leꞌca neca perdonala stula nzeꞌe liñibe, nu bene enu niilu nú la neca perdona stula lu iliulabe quieꞌ, leꞌca la neca perdona stula nzeꞌe liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Che uni Jesuse lubee beneꞌnu nú la ixiuleꞌe beella lu niꞌtucu bee bene, nú liꞌinu necanu Cristo. ");
INSERT INTO zplNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde che uquixie Jesuse udixiuleꞌenu lubee beneꞌnu nú rquiꞌña nú nzanu Jerusalén. Nu bee usticiaꞌ bee bene Israel cuna bee uleꞌya enu rnibiyaꞌ lubeelá bee uleꞌya cuna bee ulaxcuela enu reca ley, riꞌibeei nú chiquiꞌ nehuana zecanu. Nu udixiuleꞌenu nú utibeei liꞌinu, pero bichia rriuna huañi zecanu. ");
INSERT INTO zplNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chequie unguyaꞌ Pedro liꞌinu tucu chu nu unilla lunu: ―¡La zela Diose nú acane scua! ¡Nu la zecalu scua! ");
INSERT INTO zplNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Che ubelleta Jesuse nu uninu lu Pedro: ―¡Ullunaꞌ lua bezeꞌlu, nu la riꞌixiꞌilu lua! Xne elliebacuꞌ nú rriꞌilu la yeꞌta nucuaꞌ lu Diose, rriꞌitsialu elliebacuꞌ tucu nú rriꞌi bee bene iliulabe elliebacuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Che uninu lubeelá bee beneꞌnu: ―Tunu nuꞌta tucu bee bene enu niarquiꞌ aca bee benea, la yala nú riꞌilla tucu nú niarquiꞌtsialla, rquiꞌña nú riquiꞌlla xitse nú nehuana zecalla nu yeꞌta quiella liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Xne bee bene enu masela niarquiꞌ nú huañi lu iliulabequieꞌ enta bichia nú nitilu nucuaꞌ, pero bee bene enu ati equie nú neca beei bee benea, luꞌcu bee nzeꞌe elunehuañi nú leca xunga laxu lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Lecaxi zibiꞌ nú riꞌi bee bene ana ye nú nuꞌ lu iliulabequieꞌ, tunu nitilulla ante Diose? Xne leca modo tsibene elunehuañiꞌ bene liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nu Liꞌá Bene enu uxeꞌla Diose, chenu nzela stucu bese, nzela cuna poder nú rluꞌcu Pa Diose nu cuna bee ángeleꞌnu. Bichia zeꞌe detea lu cada tucua bee bene lunú riala atiꞌlla, equie cuendaꞌ lunú uriꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Liꞌá nia luhua, nú nuꞌ bee bene enu nucuaꞌa caꞌa lá ati hasta nú lañiꞌbeei nú riña zeca Liꞌá Bene enu uxeꞌla Diose, nzela cuna poder nú rluꞌcua para nú nibiyaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chenu udete xuꞌcu bichia, che uyanu Jesuse Pedro, Jacobo nu cuna Juan enu neca bichi Jacobo uya beella equie tucu dañi elu aya, ");
INSERT INTO zplNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","zeꞌe ucheꞌe nú xa rnaa Jesuse lubeella. Nu chiquiꞌ rulu siquiꞌ lunu xi rulu ellieꞌe bichia, nu unga niquichuaꞌquieꞌ xucunu nu rulu siquiꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hora zeꞌe ulañiꞌ beella nú rdichiaꞌnu Jesuse Moisés cuna Elías. ");
INSERT INTO zplNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Che uni Pedro lu Jesuse: ―Detá, ¡neca nzeꞌca nú nelluaꞌanuru liꞌilu caꞌa! Tunu niarquiꞌlu recheꞌru chuna ranchu: tucue para liꞌilu, stucue para Moisés nu stucue para Elías. ");
INSERT INTO zplNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Diqui nú rniscaꞌ Pedro, hora zeꞌe ulaca tucu xcabe nú rulusiquiꞌ utsacuꞌ equie Jesuse cuna bee bene zeꞌe. Nu liñi xcabe zeꞌe ubeneꞌ beella tucu chii nú uni: ―Neca ninguieꞌ Lliꞌñia enu chiquiꞌ seꞌcaa. Nu ñia nzu arquialu, uzuꞌcuꞌhua nú rninu. ");
INSERT INTO zplNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chenu ubeneꞌ bee beneꞌ Jesuse chi cuaꞌ, uzucu lliqui beella nu hasta luyuu uziꞌquindiqui beella, nu chiquiꞌ ulliqui beella. ");
INSERT INTO zplNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Che uyabica Jesuse lubeella, nu utiꞌyanu liꞌibeella nu uninu lubeella: ―Utsulíhua, nu la lliquihua. ");
INSERT INTO zplNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nu chenu uletsa beella lubeella ulañiꞌ beella nú lecaꞌ tinuꞌ zeꞌe, stucutsia Jesuse nzulá zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chenu enta laca beella dañi zeꞌe, uni Jesuse lubeella: ―La ixiuleꞌehua lu niꞌtucu bee bene lunú ulañiꞌhua, hasta bichia nú huañi zeca Liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chequie unedichiaꞌ bee beneꞌnu lunu nú uni beella: ―¿Xiquie nú rni bee ulaxcuela enu reca ley nú rluti Elías rquiꞌña nú riña? ");
INSERT INTO zplNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Che ucuaquinu lubeella: ―Neli nú nzeꞌta rluti Elías para nú tsucheꞌlla yeene. ");
INSERT INTO zplNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero Liꞌá nia luhua nú ubeꞌtala Elías, nu né chulu bee bene liꞌilla tucu nú riala nú a chulu beei liꞌilla, nu xitse uriꞌinu ye bee bene liꞌilla. Nu leꞌca scua nehuana riꞌinu bee bene Liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Che uriꞌi bee beneꞌnu beyaꞌ nú rninu lu cuendaꞌ Juan Bautista. ");
INSERT INTO zplNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Chequie chenu uriña beella elu nucuaꞌa bee bene, uyabica tucu bene lu Jesuse nu utsulliquii lunu nú uni: ");
INSERT INTO zplNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Detá, uhuaꞌa arquiꞌ endua xne secai ichia ziña nu chiquiꞌ nehuana secai, nu huaxi bese sanaꞌi lu quii, cuna lu inza. ");
INSERT INTO zplNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Uriñayua endua lubee beneꞌlu, pero lá aca beella riyeca beella liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chequie ucuaqui Jesuse nú uninu: ―¡Cueꞌhua bee bene enu rluꞌcu dula núla chili arquiꞌhua liꞌá! ¿Se xala tiembu rquiꞌña nú tsunua liꞌihua?, nu ¿se xalalá tiembu riquilá liꞌihua? Uteyuhua enduꞌcuaꞌ caꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Che uquiꞌyaꞌ benechiquiꞌ uriꞌi Jesuse nu unibiyaꞌnu nú chiuꞌui arquiꞌ enduꞌ zeꞌe, nu hora zeꞌe uyecaꞌ enduꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chenu nucuaꞌa liꞌitsia Jesuse cuna bee beneꞌnu unedichiaꞌ beella lunu nú uni beella: ―¿Xiquie nú né acaru ahuaru benechiquiꞌ arquiꞌ enduꞌ zeꞌe? ");
INSERT INTO zplNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Che uni Jesuse lubeella: ―Xne lleꞌnatsia nzeli arquiꞌhua Liꞌá. Liꞌá nia luhua nú tunu neli nzeli arquiꞌhua masia xi lleꞌna ebichi mestasa, neca lunú nzeli arquiꞌhua Liꞌá, nuꞌ modo nihua lu dañiquieꞌ: “Ullunaꞌ caꞌa nu uquia stucu luhuare”; nu zucuꞌ dañi nú nihua. Lecaxi aca neriñaꞌ para liꞌihua tunu neli nzeli arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero para nú chiuꞌu clasiaꞌ bee benechiquiꞌ cuaꞌ, rquiꞌña nú deteꞌhua bichia núla acuhua, nu nacuꞌhua lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Chenu nucuaꞌa beella lu iliu Galilea, uni Jesuse lubee beneꞌnu: ―Liꞌá Bene enu uxeꞌla Diose deteꞌ cuenda bene liꞌá lubee bene, ");
INSERT INTO zplNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nu uti beei liꞌá, pero bichia rriuna huañi zecaa. Chenu ubeneꞌ bee beneꞌnu nú uninu scua chiquiꞌ nehuana utsu arquiꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chenu uriña Jesuse cuna bee beneꞌnu eyeche Capernaum, uya bee bene enu rriꞌi cubre impuesto para indu llene Jerusalén lu Pedro nu unidichiaꞌ beei lulla, nu unibeei: ―¿Rixiu maestroꞌlu impuestoꞌ indu la? ");
INSERT INTO zplNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Che ucuaqui Pedro lubeei: ―Aahuaꞌ rixiunue. Nu chenu uyuꞌu Pedro liñi niꞌi elu nzu Jesuse, rlutilánu uninu lu Pedro: ―¿Xa nilu, Simón? ¿Ti riala ixiu impuesto lubee arre iliulabequieꞌ: bee bene lachilla la, o bee bene rene la? ");
INSERT INTO zplNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nu ucuaqui Pedro nú unilla lunu: ―Bee bene rene. Nu uni Jesuse lu Pedro: ―La quiꞌña nú ixiu bee bene lachilla impuesto. ");
INSERT INTO zplNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero para nú lecati lee luaꞌahua, mejora uquia ruꞌu inzatuꞌ, nu duꞌlu anzueluꞌlu lue, nu bela rluti enu uculu. Liñi ruꞌí ulua tucu melu nú riquiꞌ chetixiulu equie impuesto, cuendaa cuna cuendaꞌlu, uyaꞌe nu uquia tixiu. ");
INSERT INTO zplNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Che leꞌca bee bichia zeꞌe, unedichiaꞌ bee beneꞌ Jesuse lunu, nú unibeella: ―¿Ti máse neca equie elurnibiyaꞌ Diose liñibe? ");
INSERT INTO zplNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chequie ubixia Jesuse tucu enduꞌ utsunu labe beella, ");
INSERT INTO zplNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nu uninu lubeella: ―Liꞌá nia luhua nú tunu la cheꞌe arquiꞌhua lu stulahua nu acahua xi neca bee enduꞌ, la chuꞌuhua elurnibiyaꞌ Diose liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Enzeꞌe nia nú bene enu aca lleꞌna arquiꞌ xi neca arquiꞌ enduꞌ quieꞌ, nzeꞌe aca enu máse aca neca equie elurnibiyaꞌ Diose liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nu titse bene enu riꞌi elietsa lu tucu enduꞌ equie cuendaꞌ Liꞌá, lua rriꞌi nzeꞌe elietsa. ");
INSERT INTO zplNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Pero titse bee bene enu riꞌi nú zanaꞌ tucu enduꞌ enu nzeli arquiꞌ Liꞌá lu dula, máse neca nzeꞌca para bene zeꞌe nú llicaꞌcu bene tucu quie molino añilla nu tsiꞌqui benella hasta aquiee lu inzatuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Cueꞌ bee bene iliulabe nú nuꞌ huaxi beenú necha neca bee nú rriꞌi nú rriꞌi bee bene dula! Siempre nuꞌbeenú necha neca lu iliulabe, pero ¡cueꞌ bene enu riꞌi nú riꞌi stucu bene dula! ");
INSERT INTO zplNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Enzeꞌe tunu riꞌi yalu urre cuchiuꞌlu nú riꞌilu dula, mejora uchieꞌcuꞌe nu utsiꞌquii istu, xne máse neca nzeꞌca nú chuꞌulu liñibe cuna tucutsia yalu nu tucutsia cuchiuꞌlu, luquela nú chalu cuna rucu yalu nu rucu cuchiuꞌlu lu quii nú leca xunga laxu. ");
INSERT INTO zplNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Leꞌca tunu rriꞌi iꞌcululu nú rriꞌilu dula, mejora uhuane nu utsiꞌquii istu, xne máse neca nzeꞌca nú chuꞌulu liñibe cuna tucutsia iꞌcululu, luquela nú chalu luquii ebila cuna rucu iꞌcululu. ");
INSERT INTO zplNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’La huachuhua niꞌ tucu bee enduꞌ quieꞌ, xne nia luhua nú bee ángele enu rriucu liꞌibeei nucuaꞌa lu Diose Pa liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Xne Liꞌá Bene enu uxeꞌla Diose uriña para nú tsialaꞌá bee bene enu nza inziu nú necha neca. ");
INSERT INTO zplNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Neca xi neca nú tucu bene rluꞌcu tucu ayuꞌu sanchi, nu nitilla tucuí? ¿Xieꞌ la tsaꞌnascaꞌlla noventa y nueve bee sanchi zeꞌe dañi nu che cuaꞌnalla sanchi enu uniti la? ");
INSERT INTO zplNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nu tunu llelaꞌllaí, masescaꞌla ñia tsu arquiꞌlla nú ullelaꞌlla sanchi enu uniti luquela noventa y nueve sanchi enu lá niti. ");
INSERT INTO zplNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Leꞌca scua, paꞌhua enu nzucu liñibe, la niarquiꞌnu nú nitilu niꞌ tucu bee bene enu nzeli arquiꞌ liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tunu nuꞌ xi necha uriꞌinu saꞌlu liꞌilu, ubedichiaꞌ rucutsiahua uniꞌ lulla nú necha uriꞌilla lulu. Che tunu uriꞌi casolla nú unilu lulla, uriꞌilálu ana nú nucuaꞌa nzeꞌcahua che. ");
INSERT INTO zplNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero tunu lá riꞌi casolla nú unilu lulla, uyaꞌ chiucu chuna bee bene para nú nihua lulla. ");
INSERT INTO zplNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nu tunu niꞌ nú rni bee benecuaꞌ la zucuꞌlla, che udixiuleꞌe lubeelá bee bene enu nzeli arquiꞌ Diose, nu tunu la riꞌi casolla nú rni bee bene enu nzeli arquiꞌ Diose, che luꞌcu cuendatsiahualla nú necatsialla xi neca tucu bene enu la chili arquiꞌ Diose urre xi neca tucu bene enu rriꞌi cubre impuesto. ");
INSERT INTO zplNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Liꞌá nia luhua nú titse saꞌhua enu nzeli arquiꞌ Diose enu riꞌihua perdona lu iliulabequieꞌ leꞌca neca perdonalalla liñibe, nu titse saꞌhua enu nzeli arquiꞌ Diose enu la riꞌihua perdona stula lu iliulabequieꞌ leꞌca la neca perdona stula nzeꞌe liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Leꞌca nia luhua, nú tunu chiucuhua aca tucunecatse para nú nacuꞌhua xi nacuꞌhua lu Diose Paa liñibe lu iliulabequieꞌ, liꞌinu liquiꞌnue. ");
INSERT INTO zplNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Xne elu rieteꞌsaꞌ chiucu chuna bee bene equie cuendaꞌ liꞌá, zeꞌe nzua cuna liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Che uyabica Pedro lu Jesuse nu unedichiaꞌlla lunu, nú unilla: ―Detá, ¿xala bese rquiꞌña nú riꞌá perdona bee saꞌa, tunu nuꞌ xi uriꞌi nzeꞌe lua? ¿Hasta achi bese la? ");
INSERT INTO zplNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nu ucuaqui Jesuse lulla: ―La nia nú achitsia bese. Sino que nia lulu nú hasta setenta bese siete rquiꞌña nú riꞌilu perdona bee saꞌlu, nucuaꞌ rni nú diqui tiembu riꞌilu perdona saꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Tucu nú rnibiyaꞌ Diose neca nú rnibiyaꞌ tucu arre enu uriꞌi elliebacuꞌ nú uzaꞌla bichia nú ixiu bee bene enu rriꞌi riñaꞌ lulla nú neziꞌqui beei lulla. ");
INSERT INTO zplNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nu chenu uquixie arre zeꞌe nú rlacuꞌlla calu neziꞌqui cada tucua bee bene lulla, che uriñayu bee bene tucu bene enu rriꞌi riñaꞌ lulla enu neziꞌqui huaxi dimi lulla. ");
INSERT INTO zplNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nu lunú la luꞌcui xi ixiui lu arre. Che unibiyaꞌ arre zeꞌe nú iquii cuna unaꞌi cuna bee enduꞌi, nu cuna ye bee steneꞌi para nú yaxu nú neziꞌquii lu arre zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Che utsulliqui mosoꞌ zeꞌe lu arre nu uziquiei lu arre, nú uni: “Detá, alaꞌ chiuꞌu arquiꞌlu tsuquiescaꞌ lleꞌna ixiuca ye nú neziꞌquia lulu.” ");
INSERT INTO zplNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chequie uhuaꞌa arquiꞌ arre zeꞌe liꞌi, nu né ixiui nú neziꞌquii lu arre zeꞌe nu che utsanaꞌ arre liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero chenu uchiuꞌu mosoꞌ zeꞌe lu arre, uchuꞌui stucu mosoꞌ enu leꞌca sibiꞌ lu arre nu neziꞌqui mosoꞌ quieꞌ lui lleꞌna dimi. Che chu unaꞌtsei añi mosoꞌ zeꞌe utsiꞌii, nu uni: “¡Udixiu nú neziꞌquilu lua!” ");
INSERT INTO zplNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Che utsu lliqui bene zeꞌe lui, nu uziquie nzeꞌe lui nú uni nzeꞌe: “Alaꞌ chiuꞌu arquiꞌlu tsuquiescaꞌ lleꞌna, ixiuca ye nú neziꞌquia lulu.” ");
INSERT INTO zplNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero né zelai atsuquiei, nu uduꞌi bene zeꞌe niꞌcuꞌ hasta nú ixiu nzeꞌe ye nú neziꞌqui nzeꞌe lui. ");
INSERT INTO zplNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Chenu ulañiꞌ beelá bee saꞌi enu rriꞌi riñaꞌ lu arre zeꞌe nucuaꞌ, chiquiꞌ ulebeei nu uyatixiuleꞌe beei lu arre lu ye nú unga. ");
INSERT INTO zplNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chequie chu unibiyaꞌ arre nú yeꞌta bene enu unga neziꞌqui lulla, nu unilla lu bene zeꞌe: “¡Chiquiꞌ necha rriꞌilu! Liꞌá uriꞌá perdona ye nú neziꞌquilu lua, xne uziquielu lua. ");
INSERT INTO zplNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Leꞌca scua liꞌilu riala nú ahuaꞌa arquiꞌlu saꞌlu, tucu nú uhuaꞌa arquia liꞌilu.” ");
INSERT INTO zplNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nu lunú chiquiꞌ rle arre zeꞌe, chequie unibiyaꞌlla nú cha bene zeꞌe niꞌcuꞌ hasta nú ixiui ye nú neziꞌquii lu arre. ");
INSERT INTO zplNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chenu ulaxu nú uni Jesuse ejemplu cuaꞌ, che uninu: ―Leꞌca scua riꞌinu Pa liñibe liꞌihua tunu la riꞌihua perdona bee saꞌhua diquinuꞌ arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Chenu ulaxu nú uni Jesuse scua, uchiuꞌunu lu iliu Galilea nu uriñanu lu iliu Judea stucu chú reꞌcu Jordán. ");
INSERT INTO zplNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nu uyanala huaxi bee bene liꞌinu, nu zeꞌe uriyecanu bee bene enu riti. ");
INSERT INTO zplNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Che uyabica chiucu chuna bee fariseo lunu para nú riꞌi beei preu liꞌinu, nu unedichiaꞌ beei lunu nú unibeei: ―¿Nuꞌ modo nú leꞌe niyu unaꞌai equie xitse tucu nú uriꞌinchu la? ");
INSERT INTO zplNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chequie ucuaqui Jesuse nú uninu lubeei: ―¿Xieꞌ lasca ulahua lu ichiꞌ Stichiaꞌ Diose elu rni, nú liꞌinu enu urecheꞌ bee bene desde nú uquixie iliulabe, “urecheꞌnu niyu cuna unaꞌa la”? ");
INSERT INTO zplNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Leꞌca uninu: “Enzeꞌe zaꞌna niyu paꞌi cuna naꞌi para nú yucui unaꞌi, che rucu beei neca beei xi neca tucutsia bene.” ");
INSERT INTO zplNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Scua la necaꞌ beei chiucu bene, sino que tucutsia neca beei. Enzeꞌe leca modo nú riꞌi tucu bene nú leꞌesaꞌ bee bene enu uriꞌi Diose nú neca tucunecatse. ");
INSERT INTO zplNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Che uni bee fariseo lu Jesuse: ―¿Xiquie nú unibiyaꞌ Moisés nú nuꞌ modo leꞌe bene unaꞌa bene, tunu acacheꞌ tucu ichiꞌ elu rni nú leꞌe saꞌlla? ");
INSERT INTO zplNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chequie uni Jesuse lubee fariseo: ―Equie nú chiquiꞌ nziti arquiꞌhua, enzeꞌe uzela Moisés nú leꞌehua unaꞌahua. Pero chenu uquixie iliulabe né acae scua. ");
INSERT INTO zplNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nu Liꞌá nia luhua nú titse niyu enu leꞌe unaꞌa, nu la necane nú uriꞌi unaꞌalla eluhuexe cuna stucu niyu, nu yuculla stucu unaꞌa, rriꞌilla dula che, nu niyu enu yucu unaꞌa enu uleꞌe niyuꞌ, leꞌca rriꞌi nzeꞌe dula. ");
INSERT INTO zplNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chequie uni bee beneꞌ Jesuse lunu: ―Tunu scua necane lu cuendaꞌ niyu cuna unaꞌalla, nzalá nú la chia bene che. ");
INSERT INTO zplNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Che uni Jesuse lubeella: ―La ye bee bene rriꞌi beyaꞌ nucuaꞌ, sino que bee bene enu udeteꞌtsia Diose elliebacuꞌ nú riꞌi beyaꞌ nucuaꞌ rriꞌi beyaꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Xne nuꞌ bee bene enu desde nú ungula lá ala para nú chia, leꞌca nuꞌ bee bene enu la chia equie nú reca remediolla, nu nuꞌ bee bene enu la chia lunú rriꞌilla elliebacuꞌ nú mejora ixiuleꞌella Stichiaꞌ Diose luhuare nú chialla. Enu riquiꞌ núla chia, la chia nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Che uriñayu bee bene chiucu chuna bee enduꞌ lu Jesuse para nú ricuꞌnu yanu equie beei nu nacuꞌnu lu Diose lu cuendaꞌ beei, pero uquiꞌyaꞌ bee bene enu uriñayu bee enduꞌ zeꞌe uriꞌi bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero uni Jesuse lubee beneꞌnu: ―Uzelahua nú yeꞌta bee enduꞌ lua, nu la cahua nú yeꞌta beei lua, xne liñibe elurnibiyaꞌ Diose neca para bee bene enu neca arquiꞌ xi neca arquiꞌ bee enduꞌ quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chenu ulaxu nú uricuꞌnu yanu equie bee enduꞌ zeꞌe, che chu nzanu. ");
INSERT INTO zplNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Uya biꞌya tucu bene Jesuse nu unedichiaꞌ bene zeꞌe lunu nú uni: ―Maestro enu neca bene nzeꞌca, ¿xi nú neca nzeꞌca riꞌá para nú luꞌcua elunehuañi nú leca xunga laxu? ");
INSERT INTO zplNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nu uni Jesuse lui: ―¿Xinú rnilu nú neca bene nzeꞌca? Leca niꞌ tucu bene nzeꞌca tucutsia Diose neca bene nzeꞌca. Pero tunu niarquiꞌlu luꞌculu elunehuañi nú leca xunga laxu liñibe, uzuꞌcuꞌ nú rni bee mandamiento. ");
INSERT INTO zplNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Che uni bene zeꞌe lu Jesuse: ―¿Ta bee mandamiento rquiꞌña nú zucua che? Nu uni Jesuse lui: ―La utilu bene, la naꞌtselu stucu unaꞌa enu la neca unaꞌalu, nu la riꞌilu eluhuanaꞌ, nu la taꞌlu eluquichiaꞌ bene, ");
INSERT INTO zplNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","uluꞌcu ulaꞌna lu paꞌlu cuna lu naꞌlu, nu uzeca saꞌlu tucu nú secalu liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Che uni bene zeꞌe lu Jesuse: ―Ye bee nucuaꞌ sucua hasta chenu necaa enduꞌ; ¿neequie xilá rriꞌi nú zucua? ");
INSERT INTO zplNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nu uni Jesuse lu bene zeꞌe: ―Tunu niarquiꞌlu nú huañilu tucu nú niarquiꞌ Diose, uquia tuti ye beenú rluꞌculu nu udeꞌteꞌ dimicuaꞌ lubee bene enu seca elitsi, che luꞌculu eluxene liñibe, nu chu yeꞌta quielu Liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero chenu ubeneꞌ bene zeꞌe nucuaꞌ, chiquiꞌ nehuana utsu arquii nziai xne chiquiꞌ xenei. ");
INSERT INTO zplNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chequie uni Jesuse lubee beneꞌnu: ―Liꞌá nia luhua, nú chiquiꞌ neriñaꞌ nú chuꞌu tucu bene xene liñibe elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Liꞌá nia luhua, nú mase facil nú dete tucu cameyu iꞌchiu echedicu, luquelá nú chuꞌu tucu bene xene liñibe elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chenu ubeneꞌ bee beneꞌ Jesuse nú uninu scua, chiquiꞌ uyanu arquiꞌ beellla, nú uni beella lusaꞌ beella: ―¿Ti nuꞌ modo tsilaꞌa che? ");
INSERT INTO zplNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nu ubiꞌya Jesuse lubeella nu uninu lubeella: ―Para bee bene neriñaꞌ neca nucuaꞌ pero para Diose lecaxi neriñaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chequie uni Pedro lu Jesuse: ―Liꞌiru utsaꞌnaru ye beenú rluꞌcuru para nú nzela quieeru liꞌilu. ¿Xi atiꞌru, lu cuendaꞌ nucuaꞌ che? ");
INSERT INTO zplNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Che uni Jesuse: ―Liꞌá nia luhua nú chenu riña bichia nú aca necuqui yeene, nu chenu zucuaꞌa lu xleta nú nibiyaꞌa liꞌá Bene enu uxeꞌla Diose, liꞌihua enu entanala liꞌá leꞌca zucuhua lu chiꞌchiucu xleta, para nú hualuhua lu cuendaꞌ ye bee bene enu nzeꞌta lu chiꞌchiucu familia Israel. ");
INSERT INTO zplNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nu titse bee bene enu utsaꞌna niꞌi, urre bichilla, urre zanalla, urre paꞌlla, urre naꞌlla, urre unaꞌalla, urre bee enduꞌlla, urre bee yuꞌlla equie cuendaꞌ Liꞌá, atiꞌlla tucu ayuꞌu bese masela lunú utsaꞌnalla, nu leꞌca luꞌculla elunehuañi nú leca xunga laxu liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero huaxi bee bene enu neca equie lu iliulabe quieꞌ nee, aca bee nzeꞌe enu la neca equieꞌa bichia zeꞌe, nu bee bene enu la neca equie nee lu iliulabe quieꞌ, aca neca equie bee nzeꞌe bichia zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Leꞌca uni Jesuse lubee beneꞌnu. ―Elurnibiyaꞌ Diose neca xi neca tucu bene enu rluꞌcu tucu yuu llene nú nuꞌ uva, nu silaꞌtuꞌ uchiuꞌulla nzecuaꞌnalla bee mosoꞌ para nú riꞌi riñaꞌ lu uvaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nu unixulla lubee mosoꞌ zeꞌe nú calu ixiulla beei tebichia nu uzela beei, che uxeꞌlalla beei nú che riꞌi beei riñaꞌ lu yuꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cheelá uchiuꞌulla nzalla tucu rquie quieꞌ silaꞌ nu ulañiꞌlla nú nucuaꞌa chiucu chuna bee bene ruꞌu iꞌya enu la luꞌcu riñaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Che unilla lubeei: “Uquia riꞌihua riñaꞌ lu yuua elu nuꞌ uva nu ixiucahua lunú riala yaxuhua.” Che chu nzuebeei riñaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Leꞌca uchiuaꞌla bene zeꞌe nzalla tucu rebibichia, nu leꞌca esquie nzaꞌlalla tucu rquie chuna uche, nu leꞌca esquieꞌala unilla lubee bene enu nucuaꞌa ruꞌu iꞌya enu la luꞌcu riñaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nu tucu rquie ayuꞌ uche, uchiuꞌu zecaꞌlalla nzalla ruꞌu iꞌya nu uchuꞌulla stexcuaꞌa bee bene enu la luꞌcu riñaꞌ, nu unilla lubeei: “¿Xiquie nú debichia nucuaꞌahua caꞌa nu la riꞌihua riñaꞌ?” ");
INSERT INTO zplNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Che uni bee bene zeꞌe lulla: “Xne lá llelaꞌru riñaꞌ riꞌiru.” Che unilla lubeei: “Uquia riꞌihua riñaꞌ lu yuua, elu nuꞌ uva nu ixiucahua lunú riala yaxuhua.” ");
INSERT INTO zplNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Chenu uyuꞌu rulaꞌ, uni patrón lu mosoꞌ enu rnibiyaꞌ lubee mosoꞌ: “Ubixia bee mosoꞌ nu uquixie udixiuxu bee enu uriña último, nuche chu ixiulu beelá bee enu rluti uriña.” ");
INSERT INTO zplNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nu chenu uriña bee mosoꞌ enu uyuꞌu lu riñaꞌ tucu rquie ayuꞌ uche, ye beei uyaxu beei tucu nú rriꞌi bene ana tebichia. ");
INSERT INTO zplNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chequie chenu uyala nú yaxu bee mosoꞌ enu uyuꞌu rluti lu riñaꞌ, uriꞌi beei elliebacuꞌ nú maselá yaxu beei, pero leꞌca ye beei uyaxu beei tucu nú rriꞌi bene ana tebichia. ");
INSERT INTO zplNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chequie chenu riaxu beei ulebeei lu patrón zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","nu unibeei lulla: “Bee bene quieꞌ uriña uche, nu uriꞌitsia beei riñaꞌ tucu hora nu udixiulu beei tucu nú rixiulu liꞌiru, nu liꞌiru uriquiꞌru uriꞌiru riñaꞌ lubee debichiallu.” ");
INSERT INTO zplNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Chequie ucuaqui patrón zeꞌe, nú unilla lu tucu beei: “Amigo, lecaxi nú necha neca uriꞌá lulu. Xne liꞌá unixua lulu nú calu ixiualu tebichia. ");
INSERT INTO zplNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Enzeꞌe uyucu dimiꞌlu nu yaalu. Xne liꞌá niarquia nú ixiua bene enu uche uyuꞌu lu riñaa tucu nú udixiua liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Xieꞌ leca modo riꞌá lunú niarquia cuna dimiala?, urre ¿Xieꞌ ria arquiꞌlu nú rriꞌi nzeꞌca la?” ");
INSERT INTO zplNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Scua necane, xne bee bene enu leca tineca nee aca neca equie bee nzeꞌe, nu bee bene enu neca equie nee la aca neca equie bee nzeꞌe bichia zeꞌe. Xne huaxi bee bene nezeneꞌ lu inziuꞌ Diose pero la huaxi bee bene enu chenala inziuꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Chenu nza Jesuse enza Jerusalén, che ubixianu lu chiꞌchiucu bee beneꞌnu tucu chú nu uninu lubeella: ");
INSERT INTO zplNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Nediyaꞌlaꞌhua nú nzaꞌahua enza Jerusalén elu deteꞌ cuenda bee bene Liꞌá Bene enu uxeꞌla Diose lubee uleꞌya enu rnibiyaꞌ lubeelá bee uleꞌya, cuna lubee ulaxcuela enu reca ley, nu nibiyaꞌ beei nú atia. ");
INSERT INTO zplNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nu deteꞌ cuenda beei Liꞌá lubee bene rene para nú lliꞌchinu beei Liꞌá, nu zeteꞌcheꞌ beei Liꞌá nu quieꞌe beei Liꞌá lu cruse, pero bichia rriuna huañi zecaa. ");
INSERT INTO zplNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chequie uyabica unaꞌa Zebedeo cuna rucu llianaꞌ beella lu Jesuse, nu utsulliquilla lunu, nu unacuꞌlla tucu faura lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Che unedichiaꞌ Jesuse lulla: ―¿Xi niarquiꞌlu? Nu unilla lunu: ―Chenu nibiyaꞌlu niarquia nú zucu tucu endua cueꞌtselu chúbe, nu stucui zucu cueꞌtselu chúbeca. ");
INSERT INTO zplNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pero uni Jesuse lubeella: ―La riꞌihua beyaꞌ lunú rnacuꞌhua. ¿Xieꞌ nuꞌ modo nú nehuana zecahua tucu nú nehuana zecaa la? ¿Xieꞌ nuꞌ modo riquiꞌhua zecahua lunú riala zecaa la? Che uni beella lunu: ―Aahuaꞌ, riquiꞌru. ");
INSERT INTO zplNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Che ucuaquinu lubeella: ―Neli nú nehuana zecahua tucu nú nehuana zecaa. Nu riquiꞌhua zecahua lunú zecaa. Pero enu zucu cueꞌtsea chúbe urre chubeca. La neca Liꞌá enu riala nibiyaꞌ nucuaꞌ, sino que necala nucuaꞌ para bee bene enu ucañila Diose Paa liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nu chenu ubeneꞌ se xiꞌi bee beneꞌnu nucuaꞌ, ule beella lu Juan cuna lu Jacobo. ");
INSERT INTO zplNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero ubixia Jesuse beella nu uninu lubeella: ―Liꞌihua nediyaꞌhua, nú bee bene enu rnibiyaꞌ lu iliulabe quieꞌ rnibiyaꞌ beei lubee bene tucu nú niarquiꞌtsia beei, nu bee bene enu neca equie cuaꞌ rriꞌi beei tucu nú niarquiꞌtsia beei lubee bene lunú rnibiyaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero letahua la yala nú acane scua. Sino que enu niarquiꞌ nibiyaꞌ letahua, rquiꞌña nú zibiꞌlla lu yehua, ");
INSERT INTO zplNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","nu enu niarquiꞌ nú mase aca neca equie letahua, rquiꞌña nú acalla enu zibiꞌ luhua, ");
INSERT INTO zplNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","scua tucu nú uriña Liꞌá Bene enu uxeꞌla Diose, lá yela para nú zibiꞌ bee bene lua, sino que uriña lu iliulabe para nú zibiꞌa lubee bene, nu equie nú atia tsilaꞌa huaxi bee bene lu stula beei. ");
INSERT INTO zplNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Chenu uchiuꞌu Jesuse cuna bee beneꞌnu eyeche Jericó, nzequie huaxi bee bene liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nu chiucu bee bene enu la yeꞌelu nucuaꞌa ruꞌu inziu, chenu ubeneꞌ beei nú udete Jesuse zeꞌe, urixialibeei nú unibeei lunu: ―¡Detá, lliꞌñi David, uhuaꞌa arquiꞌ liꞌiru! ");
INSERT INTO zplNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nu uquiꞌyaꞌ beei uriꞌi bee bene para nú zaca beei, pero masescaꞌlá urixialibeei nú unibeei: ―¡Detá, lliꞌñi David, uhuaꞌa arquiꞌ liꞌiru! ");
INSERT INTO zplNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chequie utsuxe Jesuse nu ubixianu rucu bee bene enu la yeꞌelu zeꞌe nu uninu lubeei: ―¿Xi niarquiꞌhua nú riꞌá luhua? ");
INSERT INTO zplNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Che unibeei lunu: ―Detá, niarquiꞌru nú yeꞌe iꞌculuru para nú lañiꞌru. ");
INSERT INTO zplNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chequie uhuaꞌa arquiꞌ Jesuse beei, nu utiꞌyanu iꞌculu beei. Hora zeꞌe uyeꞌe lubeei, nu chu nzequie beei liꞌinu che. ");
INSERT INTO zplNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Chenu nzeriñala beella axu Jerusalén, uriña beella tucu dañi nú lee Olivos, axu eyeche Betfagé, che uxeꞌla Jesuse chiucu bee beneꞌnu, ");
INSERT INTO zplNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nu uninu lubeella: ―Uquiahua eyeche nú nchiucuꞌ enza lucuaꞌ. Zeꞌe llelaꞌhua tucu burro enu nequietu cuna lliꞌñií. Uxeꞌchehua beeí nu yeꞌtayuhua beeí caꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nu tunu nuꞌ ti ni xi ni luhua, uniꞌhua lu bene zeꞌe nú Detá, Jesuse rquiꞌñaí, nee chu nzelayuzecaru beeí. ");
INSERT INTO zplNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Scua unga para nú uyalu tucu nú uni tucu profeta huaꞌtu, chenu uquieꞌella: ");
INSERT INTO zplNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Uniꞌhua lubee bene eyeche llene Sión: “Ubiꞌyacuruhua, nzeꞌtala arréꞌhua luhua nee, nu nzeꞌtanu xi nzeꞌta tucu bene enu la neca equie, nchiucuꞌnu equie tucu burru, tucu burro llaꞌna, lliꞌñi nañi enu ruyaꞌ yuhuaꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chequie uya bee beneꞌ Jesuse nu uriꞌi beella tucu nú uninu lubeella. ");
INSERT INTO zplNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Che uriñayu beella burro zeꞌe cuna lliꞌñií lu Jesuse, nu uricuꞌ beella xucu beella equie burro llaꞌna zeꞌe, nu chu uricu Jesuse equieí. ");
INSERT INTO zplNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nu lunú chiquiꞌ huaxi bee bene nucuaꞌa zeꞌe, nuꞌ beei rcuaꞌa xucu labe inziu elu detenu, nu texcuaꞌa beei uchiecuꞌ bee leca lubee aca ucuaꞌa beei labe inziu elu detenu. ");
INSERT INTO zplNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Che bee bene enu nzuculu, cuna bee bene enu nzequie, rixiali beei nú rnibeei: ―¡Ñia neca lu cuendaꞌ liꞌinu enu neca Lliꞌñi arre David! ¡Chiquiꞌ ñia neca lu cuendaꞌ liꞌinu enu nzeꞌta lu cuendaꞌ Paꞌahua Diose! ¡Cheꞌtsalá Diose Paa enu nzucu liñibe! ");
INSERT INTO zplNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Chenu uriña Jesuse Jerusalén, ye bee bene zeꞌe uyacha beei nu unibeei lu saꞌbeei: ―¿Ti bene quieꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Che unibeei lusaꞌbeei: ―Profeta Jesuse nucuaꞌ, enu neca bene eyeche Nazaret lu iliu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chenu uriña Jesuse labe eleꞌyaꞌ indu llene Jerusalén utiliacaꞌnu ye bee bene enu ruti cuna ye bee bene enu si labe eleꞌyaꞌ indu zeꞌe. Nu utelletanu bee mexaꞌ bee bene enu xiꞌla dimi, cuna xletaꞌ bee bene enu ruti bee paloma, ");
INSERT INTO zplNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","nu uninu lubeei: ―Lu ichiꞌ Stichiaꞌ Diose rni: “Nia chiulee niꞌi elu nacuꞌ bee bene lu Diose”, pero liꞌihua uriꞌihuane xi neca yubeꞌ bee huanaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Che liñi indu zeꞌe uyabica bee bene enu la yeꞌe iꞌculu cuna bee bene enu necuxu ante Jesuse, nu uriyecanu beei. ");
INSERT INTO zplNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero chenu ulañiꞌ bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee ulaxcuela enu reca ley bee milagro nú rriꞌi Jesuse, nu chenu ubeneꞌ beei nú rixiali bee enduꞌ nucuaꞌ zeꞌe: “¡Ñia neca lu cuendaꞌ liꞌinu enu neca Lliꞌñi arre David!”, ule beei ");
INSERT INTO zplNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","nu unibeei lu Jesuse: ―¿Rieneꞌlu nú rni bee enduꞌ cuaꞌ la? Che ucuaqui Jesuse lubeei: ―Aahuaꞌ, rienea. Pero ¿xieꞌ lascaꞌ ulahua lu ichiꞌ Stichiaꞌ Diose elu rni lu cuendaꞌ nucuaꞌ la? Lu ichiꞌ Stichiaꞌ Diose rni: Uriꞌilu nú bee enduꞌ llaꞌna cuna bee enduꞌ meꞌe enu rachi, neca bee enu ula bee canto nu zucuꞌ aya liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Che uyaꞌna beei zeꞌe, nu uchiuꞌunu nzanu eyeche Betania, nu zeꞌe uyaꞌnanu rulaꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chenu uyeꞌe lu yuu stucu bichia, ubenchilaꞌ zecanu Jerusalén, nu uliaꞌnaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Che ulañiꞌnu tucu aca higo ruꞌu inziu nu uyabicanu lue. Pero lá llelaꞌnu higo lue, bee lecatsia nuꞌlue. Chequie uni Jesuse lu aca higo zeꞌe: ―¡Lecaꞌ xunga ayu ndixi lulu! Hora zeꞌe ubichi aca higo zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chenu ulañiꞌ bee beneꞌ Jesuse nucuaꞌ, chiquiꞌ uyanu arquiꞌbeella nu unidichiaꞌ beella lu Jesuse: ―¿Xiquie nú chu ubichi aca higo cuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Chequie uni Jesuse lubeella: ―Liꞌá nia luhua nú tunu nzeli arquiꞌhua masia temeꞌ, nu la zaꞌ arquiꞌhua, la neca nú nucuaꞌtsia riꞌihua tucu nú uriꞌá lu aca higo, sino que nihua lu dañiquieꞌ: “Uyetsu caꞌa nu uzanaꞌ lu inzatuꞌ”, nu scua acane. ");
INSERT INTO zplNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nu ye nú nacuꞌhua lu Diose, tunu neli nzeli arquiꞌhua nú liquiꞌnu nucuaꞌ, che yucuhuane. ");
INSERT INTO zplNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Luzeꞌelá uyuꞌu Jesuse liñi indu llene Jerusalén seteꞌnu bee bene, che uyabica bee uleꞌya enu rnibiyaꞌ lubeelá bee uleꞌya cuna bee usticiaꞌ bee bene Israel lunu, nu unibeei lunu: ―¿Ti uliquiꞌ stichiaꞌ nú rriꞌilu ye bee nucuaꞌ?, nu ¿Ti uliquiꞌ elurnibiyaꞌ lulu? ");
INSERT INTO zplNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Che uni Jesuse lubeei: ―Leꞌca nedichiaꞌa tucu luhua niarquia, tunu cuaquihua nú nedichiaꞌ luhua, che ixiuleꞌa luhua ti uliquiꞌ elurnibiyaꞌ nú rriꞌá scua. ");
INSERT INTO zplNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ti uxeꞌla Juan nú rinzalla bee bene che? ¿Diose uxeꞌlalla la o bee bene uxeꞌlalla la? Che unibeei lusaꞌbeei, nú unibeei: ―Tunu niaꞌahua nú Diose uxeꞌla Juan Bautista, che ni nucuaꞌ luaꞌahua: “¿Xiquie nú né chili arquiꞌhua nú unilla che?” ");
INSERT INTO zplNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nu leꞌca leca modo niaꞌahua nú bee bene uxeꞌla Juan, xne xiquiaꞌahua bee bene, xne ye bee bene nzeli arquiꞌ nú neca Juan tucu profetaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Che unibeei lu Jesuse: ―Labiyaꞌru. Chequie uni Jesuse lubeei: ―Leꞌca esquie la ixiuleꞌa luhua ti uliquiꞌ elurnibiyaꞌ nú rriꞌá scua. ");
INSERT INTO zplNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nu uni Jesuse lubeei: ―¿Xa rriꞌihua elliebacuꞌ lunú nia luhua nee? Tucu bene uluꞌcu chiucu llianaꞌ, nu unilla lu tucui: “Enduꞌ, uquia riꞌi riñaꞌ lu yuua elu nuꞌ uva.” ");
INSERT INTO zplNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Che ucuaqui llianaꞌlla lulla: “¡La niarquia chaꞌa!” Pero luzeꞌelá ucheꞌe elliebacuꞌi nu uyai. ");
INSERT INTO zplNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chequie uya niꞌ paꞌ beei lu stucui, tucu nú unilla lu enu rlu, nu uni lulla: “Nzaꞌca che.” Uni, pero né chai. ");
INSERT INTO zplNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Neequie uniꞌhua, ¿ta lu rucu bee llianaꞌlla uriꞌi lunú niarquiꞌlla? Che unibeei lunu: ―Enu unilla lu rluti. Chequie uni Jesuse lubeei: ―Liꞌá nia luhua nú bee bene enu rriꞌi cubre impuesto para Roma, cuna bee unaꞌa huexe rluti bee nzeꞌe chuꞌu elurnibiyaꞌ Diose liñibe luquela liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Xne ubeꞌta Juan Bautista udixiuleꞌe luhua nú xa huañihua, nu né chili arquiꞌhua nú unilla, aꞌlaquie bee bene enu rriꞌi cubre impuesto para Roma cuna bee unaꞌa huexe uchilí arquiꞌbeei nú unilla. Pero liꞌihua mase ulañiꞌhua bee nucuaꞌ, ne cheꞌe arquiꞌhua, para nú a chili arquiꞌhua nú unilla. ");
INSERT INTO zplNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Chequie uni Jesuse lubeei uzuꞌcuꞌ diacahua ne nia stucu ejemplu luhua: Tucu bene uquieni bee aca uva lu yuuꞌ, nu uduꞌlla eluꞌu diqui abenchilaꞌe, nu urecheꞌlla tucu elu tsiꞌi bee uva, leꞌca urecheꞌlla tucu elu aya para nú aca ucu yuu elu nuꞌ bee aca uva zeꞌe. ’Che udeteꞌlla yuu cuaꞌ lleꞌla lu chiucu chuna bee bene enu riꞌi riñaꞌ lue, nu chu nzalla istu. ");
INSERT INTO zplNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chequie chenu uriña tiembu nú leꞌe beella uva, uxeꞌlalla chiucu chuna bee mosoꞌlla chetucu bee uva nú rialalla. ");
INSERT INTO zplNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero bee bene enu rriꞌi riñaꞌ lleꞌla lu yuuꞌlla unaꞌtse beei bee mosoꞌ enu uxeꞌlalla, tucu mosoꞌ zeꞌe uzeteꞌcheꞌ beei, stucu nzeꞌe unguuti beei, nu stucui uduꞌ beei quiee. ");
INSERT INTO zplNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Che bene enu neca stene yuu zeꞌe, uxeꞌlaꞌlalla huaxilá bee mosoꞌlla luquela nú rlu, pero leꞌca esquie uriꞌinu beei bee mosoꞌ cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Último uxeꞌlalla enduꞌlla, xne uriꞌilla elliebacuꞌ: “Lu endusia luꞌcu beei ulaꞌna.” ");
INSERT INTO zplNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero chenu ulañiꞌ beei nú nzeꞌta enduꞌ bene enu neca stene yuu zeꞌe, che unibeei lusaꞌbeei: “Bene quieꞌ neca enu yaꞌnanu yuu quieꞌ, te utiaꞌhua nucuaꞌ para nú yaꞌnanuaꞌahua yuu quieꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Che unaꞌtse beei liꞌi, nu uhua beei liꞌi lu yuu zeꞌe nu chu unguuti beei liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Chequie unedichiaꞌ Jesuse lubee bene zeꞌe nú uninu: ―Chenu riña bene enu neca stene yuu zeꞌe, ¿xa rriꞌihua elliebacuꞌ nú riꞌinulla bee bene zeꞌe enu udeteꞌlla yuuꞌlla lleꞌla lu che? ");
INSERT INTO zplNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Che unibei lu Jesuse: ―Utilla beei sin nú huaꞌa arquiꞌlla beei, nu deteꞌlla yuuꞌlla lu texcuaꞌa bee bene, enu deteꞌ cuenda ulaꞌcu nú rialalla chenu aca ulaꞌcue. ");
INSERT INTO zplNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Leꞌca uni Jesuse lubee fariseo: ―¿Xieꞌ lascaꞌ ulahua lu ichiꞌ Stichiaꞌ Diose elu rni? Quiee nú uhua uꞌna bee bene enu rrecheꞌ niꞌi, quiee quieꞌ neca nú mase uzibiꞌ ungacheꞌ niꞌi. Nucuaꞌ neca nú uriꞌi Diose, nu chiquiꞌ nzenu arquiaꞌahua lunú uriꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Enzeꞌe nia luhua nú chiuꞌuchuhua elurnibiyaꞌ Diose liñibe nu chuꞌu téxcuaꞌa bee bene luhuareꞌhua, bee enu neli riꞌi tucu nú niarquiꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pero titse bee bene enu llica cuchiuꞌ cuna quiee zeꞌe, nehuana zecalla, nu tunu nuꞌti zanaꞌ quiee cuaꞌ equie laꞌxulii liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chenu ubeneꞌ bee uleꞌya enu rnibiyaꞌ lubeelá bee uleꞌya cuna bee fariseo bee ejemplu nú uni Jesuse, che uriꞌi beei beyaꞌ nú lu cuendaꞌ beei uninu. ");
INSERT INTO zplNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chequie hora zeꞌe uniarquiꞌ beei a naꞌtse beei liꞌinu, pero xiqui beei bee bene, xne nzeli arquiꞌ bee bene nú necanu tucu profeta. ");
INSERT INTO zplNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Chequie unilá Jesuse bee ejemplu lubeei nú uninu: ");
INSERT INTO zplNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Elurnibiyaꞌ Diose neca xineca tucu arre enu uriꞌi tucu tsaꞌa nú uchia enduꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nu uxeꞌlalla bee mosoꞌlla para nú chetucu beei bee bene enu nezeneꞌ lu tsaꞌa zeꞌe, pero lá zela bee bene zeꞌe achaa. ");
INSERT INTO zplNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Chequie uxeꞌlalla xiucu xuna bee mosoꞌlla, nu unilla lubeei: “Uniꞌhua lubee bene enu nezeneꞌ lu tsaꞌa nú necalula nú acu bee bene. Unibiyaꞌlá nú unguti bee uꞌnaꞌ enu mase neruꞌcu, cuna beelá bee nañia enu mase neruꞌcu, nu ye bee nucuaꞌ necala, uniꞌhua lubeella nú yeꞌta beella lu eluchia.” ");
INSERT INTO zplNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero bee bene enu nezeneꞌ lu tsaꞌa zeꞌe né riꞌi caso beei nú uni bee mosoꞌ arre zeꞌe lubeei. Tucu bene zeꞌe nza nzebiꞌya yuuꞌ, nu stucui nzequienu berexeꞌ, ");
INSERT INTO zplNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","nu texcuaꞌa beei unaꞌtse bee mosoꞌ enu uxeꞌla arre zeꞌe, nu uzeteꞌcheꞌ beei bee mosoꞌ zeꞌe hasta nú unguuti beei bee nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Chequie chiquiꞌ ule arre zeꞌe, nu uxeꞌlalla bee sundadoꞌlla nú utibeei bee bene enu unguuti bee mosoꞌlla, nu tsiquiꞌ beei lachi bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Che unilla lubee mosoꞌlla: “Neca listola yeene para nú aca tsaꞌa, pero bee enu uzeneꞌ nú yeꞌta lu tsaꞌa la yala nú yeꞌta beei. ");
INSERT INTO zplNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Uquiahua lubee calle nu ye bee bene enu llaꞌcahua uniꞌhua lubeella nú yeꞌta beella lu tsaꞌa.” ");
INSERT INTO zplNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chequie nzue bee mosoꞌlla uquieteꞌsaꞌ ye bee bene enu ullaꞌca beei lubee calle, sia bee bene nzeꞌca nu sia bene enu necha rriꞌi, scua uche niꞌi arre zeꞌe elu unga tsaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Nu chenu uyuꞌu arre zeꞌe liñi niꞌi para nú lañiꞌlla bee bene enu nezeneꞌ lu tsaꞌa, che ulañiꞌlla tucu bene enu la nutu laquie nú rutu bene enu nezeneꞌ lu tsaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Che uni arre lu bene zeꞌe: “Amigo, ¿xa uyuꞌulu caꞌa, nu la nutulu laquie nú riala utulu lu tsaꞌa?” Pero lecalí xi ucuaqui bene zeꞌe lu arre. ");
INSERT INTO zplNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chequie uni arre lubee bene enu rricuꞌ bee elubacu lu mexa: “Ulliꞌcaꞌcuhua cuchiuꞌ benequieꞌ cuna yai, nu utsiꞌquihuai eliꞌyaꞌ elu necabe, elu unaꞌi nu aculayai.” ");
INSERT INTO zplNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Xne huaxi bee bene enu nezeneꞌ, pero lleꞌnatsia bee bene enu chuꞌu. ");
INSERT INTO zplNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chenu ulaxu nú uni Jesuse bee ejemplu. Che uchiuꞌu bee fariseo luhuare zeꞌe nu ubedichiaꞌ beei equie cuendaꞌ nú xi nibeei lu Jesuse, para nú ninu tucu bedichiaꞌ nu xa taꞌ quiya beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Che uxeꞌla bee fariseo cuaꞌ chiucu chuna bee beneꞌ beei lu Jesuse, cuna chiucu chuna bee beneꞌ Herodes, nú nibeei lunu: ―Maestro, nediyaꞌru nú neli beenú rnilu nu neli seteꞌlu nú xa niarquiꞌ Diose nú huañi bee bene, sin nú riꞌi casolo nú rni bee bene, xne la biꞌyalu nú xa rnaa bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Neequie uniꞌ luru: ¿Neca nzeꞌca nú dixiuru impuesto lu arre Cesar la, o la neca nzeꞌcae la? ");
INSERT INTO zplNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero uriꞌi Jesuse beyaꞌ nú necha neca elliebacuꞌ beei, enzeꞌe uninu lubeei: ―Nequichiaꞌhua, ¿xinu rriꞌihua preu liꞌá scua? ");
INSERT INTO zplNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ulubeꞌhua tucu melu nú riaxu impuesto lua. Che chu udeteꞌ beei tucu denario yanu. ");
INSERT INTO zplNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Chenu ulañiꞌnu melu cuaꞌ, che unedichiaꞌnu lubeei: ―¿Tiluu nú nequie lu melu quieꞌ nu ti lee enu nequie lue? ");
INSERT INTO zplNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nu ucuaqui beei nú unibeei lunu: ―Arre Cesar nucuaꞌ. Che uni Jesuse lubeei: ―Udeꞌtehua lu arre Cesar lunú neca cuendaꞌ arre César, nu udeꞌteꞌhua lu Diose nú neca cuendaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chenu ubeneꞌ beei nú uni Jesuse scua, chiquiꞌ uyanu arquiꞌbeei, che utsaꞌna beei liꞌinu nu chu nzuebeei. ");
INSERT INTO zplNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Leꞌca mismo bichia zeꞌe uya chiucu chuna bee saduceo lu Jesuse. Nu bee saduceo lachili arquiꞌ nu huañi zeca bee bene enu unguti. Enzeꞌe unedichiaꞌ beei lu Jesuse nú unibeei: ");
INSERT INTO zplNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, Moisés uni nú tunu ati tucu niyu nu uyaꞌna unaꞌlla nu né luꞌcu beella enduꞌ, che rquiꞌña nú chia bichi tuxie zeꞌe unaꞌa zeꞌe para nú luꞌcu beei enduꞌ enu aca xi neca enduꞌ tuxie zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Letaꞌahua nucuaꞌa tucu familia enu uluꞌcu achi bichi. Bichi rlu beei uyucu unaꞌa pero ungutilla. Nu né luꞌculla enduꞌ cuna unaꞌalla, chequie uyucu bichi rruculla unaꞌa zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Leꞌca scua ulleꞌca bichi rrucu beella, cuna bichi rriuna beella, hasta nú unguti luzaꞌ achi bichi beella. ");
INSERT INTO zplNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Luzeꞌelá, leꞌca unguti unaꞌa zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Neequie, chenu huañi zeca bee bene enu unguti, ¿ta luzaꞌ achi bee bene cuaꞌ neca niyuꞌ unaꞌa zeꞌe, xne ye beella uchia beella unaꞌa zeꞌe? ");
INSERT INTO zplNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nu ucuaqui Jesuse lubee saduceo zeꞌe nú uninu: ―Rnihua scua xne la riꞌihua beyaꞌ Stichiaꞌ Diose nu la chuluhua xneca neca lunú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Xne chenu huañizeca bee bene enu unguti, la yucuaꞌ bee bene saꞌ bee bene, nu la deteaꞌ bee bene enduꞌ bee bene chia, sino que acatsia bee bene xi neca bee ángeleꞌ Diose liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero equie cuendaꞌ nú huañi zeca bee bene enu unguti, ¿xieꞌ lascaꞌ ulahua lu ichiꞌ Stichiaꞌ Diose elu rninu? ");
INSERT INTO zplNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Liꞌá neca Diose lu Abraham, lu Isaac cuna lu Jacob.” Nu Diose la necanu Diose lubee bene enu unguti, sino que necanu Diose lubee bene enu nehuañi. ");
INSERT INTO zplNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chenu ubeneꞌ ye bee bene zeꞌe lunú uni Jesuse, chiquiꞌ nzenu arquiꞌbeei lunú xa seteꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chenu ungabiyaꞌ bee fariseo nú lecaꞌ xi allela arquiꞌ bee saduceo uni lu Jesuse, uyetesaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nu tucu bee fariseo cuaꞌa enu neca ulaxcuela enu reca ley. Unedichiaꞌ lu Jesuse para nú deteꞌi preu liꞌinu, nu uni lunu: ");
INSERT INTO zplNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿ta mandamiento nú mase neca equie enta lu ley? ");
INSERT INTO zplNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Che uni Jesuse lui: ―“Uzeca Paꞌlu Diose diquinuꞌ arquiꞌlu, cuna diqui lunú necalu cuna diqui nuꞌ elliebacuꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ninguieꞌ neca mandamiento rluti, nú mase neca equie. ");
INSERT INTO zplNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nu casi iguaelee cuna mandamiento rrucu nú rni: “Uzeca saꞌlu tucu nú secalu liꞌilu.” ");
INSERT INTO zplNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Enzeꞌe titse bee bene enu sucuꞌ rucu bee mandamiento quieꞌ sucuꞌla nzeꞌe ye nú rni ley, cuna ye nú uquieꞌe bee profeta. ");
INSERT INTO zplNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Chenu neyeteꞌsaꞌscaꞌ bee fariseo luhuare zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","che unedichiaꞌ Jesuse lubeei: ―¿Xa rriꞌihua elliebacuꞌ lu cuendaꞌ Cristo? ¿Ti lu familiaꞌ nzeꞌtanu? Che unibeei lunu: ―Lubee familiaꞌ David nzeꞌtanu. ");
INSERT INTO zplNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chequie uni Jesuse lubeei: ―Pero, ¿xiquie nú equie cuendaꞌ Espíritu Santo uni David lunu, liꞌilu rnibiyaꞌlu lua? Xne uni David: ");
INSERT INTO zplNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Diose uni lu liꞌinu enu rnibiyaꞌ lua: “Uzucu cueꞌtsea chube, hasta nú riꞌá ana nibiyaꞌlu lubee bene enu rle lulu.” ");
INSERT INTO zplNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Enzeꞌe tunu neca Cristo enduꞌ David, xinu rni David lunu, liꞌilu rnibiyaꞌlu lua? ");
INSERT INTO zplNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nu niꞌ tucu bee bene enu nucuaꞌa zeꞌe né cuaqui niꞌ tucu bedichiaꞌ lunu, nu desde bichia zeꞌe lecaꞌ xi unedichiaꞌ beella lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chequie uni Jesuse lubee beneꞌnu cuna lubee bene enu nucuaꞌa zeꞌe: ");
INSERT INTO zplNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Bee ulaxcuela enu reca ley cuna bee fariseo, seteꞌ beei bee bene lunú rni leyꞌ Moisés. ");
INSERT INTO zplNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Enzeꞌe nia luhua nú uzuꞌcuꞌhua stichiaꞌ beei, nu riꞌihua ye nú rnibeei, pero la riꞌihua tucu nú rriꞌi beei, xne liꞌibeei rnibeei tucu nú rnibeei pero la riꞌibeei tucu nú rnibeei. ");
INSERT INTO zplNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Chiquiꞌ neriñaꞌ lunú rnibiyaꞌ beei nú riꞌi bee bene, pero puro rnibiyaꞌtsia beei nú riꞌi bee bene lunú rnibeei nu niꞌ la niarquiꞌ beei riꞌi beei elietsaꞌ bee bene para nú riꞌi bee bene lunú niarquiꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nu ye nú rriꞌi beei rriꞌitsia beei scua para nú lañiꞌ bee bene. Nú riuꞌ arquiꞌbeei nú riacaꞌcuu tucu iti nú nuꞌcheꞌ Stichiaꞌ Diose tiquie beei cuna testuꞌ xcu beei. Leꞌca riuꞌ arquiꞌbeei nú rutu beei laquie nú stuñi luxu. ");
INSERT INTO zplNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nu rleꞌ beei nú zucu beei luhuare elu rcuaꞌa bee bene enu mase neca equie chenu nezeneꞌ beei nú nzetacu beei lu tucu eliñi, leꞌca scua rriꞌi beei liñi indu, ");
INSERT INTO zplNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","leꞌca riuꞌ arquiꞌbeei nú luꞌcu bee bene ulaꞌna lubeei chenu xaꞌca bee bene liꞌibeei lu inziu, nu ni bee bene ulaxcuela lubeei. ");
INSERT INTO zplNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero liꞌihua la yala nú leꞌhua nú ni bee bene ulaxcuela luhua xne neca tucutse liꞌihua nu tucutsia ulaxcuela rluꞌcuhua nu liꞌinu necanu Cristo. ");
INSERT INTO zplNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nu la nihua pa lu niꞌtucu bee bene iliulabe enu laca paꞌhua, xne tucutsia Paa rluꞌcuhua, nu liꞌinu nzucunu liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Leꞌca la leꞌhua nú ni bee bene luhua nú necahua enu rnibiyaꞌ, xne nuꞌ tucutsia enu rnibiyaꞌ nu liꞌinu necanu Cristo. ");
INSERT INTO zplNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nu bene enu mase neca equie letahua, rquiꞌña nú zibiꞌlla luhua. ");
INSERT INTO zplNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Xne bene enu sucuꞌ aya leꞌcatsia liꞌi aca lleꞌna nzeꞌe, nu enu reca lleꞌna arquiꞌ zucuꞌ aya bee bene nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Cueꞌhua bee ulaxcuela enu reca ley nu bee fariseo, xne la riꞌihua tucu nú rnihua!, nu la zelahua nú riꞌi bee bene beyaꞌ xa riala riꞌi beei para nú aca beei bee beneꞌ Diose. Nu niꞌ liꞌihua la laꞌnahua nú acahua beneꞌ Diose, nu rcahua nú aca bee bene enu niarquiꞌ nú aca bee beneꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Cueꞌhua, bee ulaxcuela enu reca ley nu bee fariseo, xne la riꞌihua tucu nú rnihua!, xne raxihua niꞌi bee unaꞌa zaqui, nu para nú ni bee bene nú necahua bee bene nzeꞌca, che xee rnacuꞌhua lu Diose. Enzeꞌe yalahua castiya nú mase fuerte. ");
INSERT INTO zplNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Cueꞌhua bee ulaxcuela enu reca ley nu bee fariseo, xne la riꞌihua tucu nú rnihua! Xne diqui lu iliulabe rlaꞌnahua bee bene enu chuꞌu chuꞌhua, nu chenu uriꞌilahua ana tucu bene, chiucu bese masela rriꞌihualla lliꞌñi bezeꞌlu luquela liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Cueꞌhua, xne la riꞌihua beyaꞌ nu niarquiꞌhua nú zeteꞌhua bee bene!, nu rnihua: “Tunu nuꞌ ti rni istá indu Jerusalén riꞌya, lecaxi neca nú ni bene scua, pero bene enu rni equie cuendaꞌ oro nú necacheꞌ liñi indu llene Jerusalén, rquiꞌña nú riꞌilla tucu nú unilla.” ");
INSERT INTO zplNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Xala netunduhua nu niquieꞌluhua! ¿Ta nú mase neca equie oro nú necacheꞌ liñi indu la, urre indu la? Xne indu rriꞌi nú necaleꞌya oro zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nu leꞌca rnihua: “Nú lecaxi neca tunu rni bene, nú rnilla istá ruꞌu ecuꞌcu riꞌya, pero tunu rnilla istá uꞌna nú nchiucuꞌ ruꞌu ecuꞌcu riꞌya, rquiꞌña nú riꞌilla tucu nú unilla.” ");
INSERT INTO zplNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Xala netunduhua nu niquieꞌ luhua! ¿Ta nú máse neca equie uꞌna la?, urre ¿Ecuꞌcu nú rriꞌi nú necaleꞌya uꞌna la? ");
INSERT INTO zplNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Enzeꞌe bene enu rni ista ecuꞌcu riꞌya, nu la necane equie cuendaꞌ ecuꞌcutsia leꞌca necane luye nú nchiucuꞌ lue. ");
INSERT INTO zplNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nu leꞌca esquie bene enu rni nú ista indu riꞌya, nu la necane nú indutsia riꞌya leꞌca riꞌya Diose Paa liñibe enu nzu presenciaꞌ liñi indu. ");
INSERT INTO zplNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Leꞌca esquie bene enu rni nú istá liñibe riꞌya, leꞌca rnilla nú riꞌya Diose nu leꞌca rnilla nú riꞌya xleta elu nzucunu. ");
INSERT INTO zplNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Cueꞌhua bee ulaxcuela enu reca ley, nu bee fariseo, xne la riꞌihua tucu nú rnihua! Liꞌihua rdeteꞌhua diezmo bee huañi nu lee menta, anís nu cumiñu lu Diose tucu nú rnibiyaꞌ ley, pero la zucuꞌhua lunú mase neca equie rnibiyaꞌ ley nú riꞌihua. La riꞌihua tucu nú necane lubee bene, la huaꞌa arquiꞌhua bee bene nu la tsu tenilí arquiꞌhua lunú nzeli arquiꞌhua Diose. Nucuaꞌ riala nú riꞌihua, sin nú tsanaꞌ arquiꞌhua nú rdeteꞌhua diezmo lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Liꞌihua necahua xi neca enu nequieꞌlu xne niarquiꞌhua nú zeteꞌhua bee bene nu niꞌ liꞌihua la acahua, nu riꞌyahua liꞌihua nú la riꞌihua dula nú lleꞌnatsia neca! ¡Nu la biꞌyahua liꞌihua nú rriꞌihua dula nú mase necha neca! ¡Tucu nú rni bee bene: Riꞌyahua liꞌihua nú la aquihua seruchiꞌ pero riaquihua cameyu! ");
INSERT INTO zplNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Cueꞌhua bee ulaxcuela enu reca ley nu bee fariseo, xne la riꞌihua tucu nú rnihua! Liꞌihua necahua xi neca bee vaso cuna bee pliato nú leca xinaa diꞌchi, xne rlubeꞌ nú necahua bene nzeꞌca pero liñi arquiꞌhua nuꞌ nú neyiꞌ rcuaꞌahua nu rcachiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Liꞌihua bee fariseo neca xi neca nú niquieꞌluhua: Rluti cheꞌexu arquiꞌhua lunú necha rriꞌihua, che lubeꞌ nú neli rriꞌi nzeꞌcahua. ");
INSERT INTO zplNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Cueꞌhua bee ulaxcuela enu reca ley nu bee fariseo, xne la riꞌihua tucu nú rnihua! xne necahua xi neca eluhua nú nequichi netsuu nú ñia naa tetsuꞌe. Pero liñii ache nuꞌ bee artaꞌ bene nguti cuna ye beenú necha rnaa. ");
INSERT INTO zplNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Scua necahua, xne ante lubee bene rlubeꞌ nú nzeꞌcahua. Pero liñi arquiꞌhua ache nuꞌ nú necha neca nu chiquiꞌ nequichiaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Cueꞌhua bee ulaxcuela enu reca ley cuna bee fariseo! ¡Xne la riꞌihua tucu nú rnihua! Liꞌihua rrecheꞌhua equie eluhuaꞌ bee profeta nu sucheꞌhua equie eluhuaꞌ bee bene enu uhuañi tucu nú niarquiꞌ Diose, ");
INSERT INTO zplNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","nu rnihua: “Tunu uhuañiaꞌahua tiembu nú uhuañi bee beneꞌahua enu udetela, lá ariaꞌahua elietsaꞌ beella nú autiaꞌahua bee profeta enu unguti beella.” ");
INSERT INTO zplNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lunú rnihua scua, rriꞌihua beyaꞌ nú necahua lliꞌñi bee bene enu unguuti bee profeta. ");
INSERT INTO zplNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Neequie ulaꞌxuhua, uriꞌihua lunú uquixie uriꞌi bee beneꞌhua enu udetela! ");
INSERT INTO zplNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Necha rriꞌihua! ¡Liꞌi sihua netsiñahua xi netsiña bee beꞌla! ¿Xa modo tsilaꞌahua lu castiya nú nzu zecahua ebila? ");
INSERT INTO zplNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nee xeꞌla bee profeta, cuna bee bene enu chiquiꞌ reca, nu bee ulaxcuela enu zeteꞌ liꞌihua Stichiaꞌ Diose. Pero nuꞌ beella enu utihua nu nuꞌ beella enu quieꞌehua lu cruse, nu beelá beella zeteꞌcheꞌhua liñi bee induꞌhua, nu tiliacaꞌhua beella cada eyeche. ");
INSERT INTO zplNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Enzeꞌe liꞌihua ricuꞌ equiehua reneꞌ bee bene enu uriꞌi nzeꞌca lu Diose bee enu unguti, desde reneꞌ Abel enu uhuañi tucu nú niarquiꞌ Diose nu hasta reneꞌ Zacarías llianaꞌ bene enu lee Berequías Zacarías enu ungutihua enza ruꞌu indu elu siquiꞌ bene nañi uꞌna lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Liꞌá nia luhua nú bee bene enu nehuañi nee, liꞌibeei zecabeei castiya equie cuendaꞌ yebee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nu uni Jesuse: ―¡Bee bene Jerusalén, bee bene Jerusalén, liꞌihua ruutihua bee profeta, nu rduꞌhua quiee bee Bene enu uxeꞌla Diose luhua! ¡Huaxi bese uniarquia nú quietesaꞌahua xi rriꞌi lliꞌti chenu rquieteꞌsaí bee tiꞌñiꞌí riuꞌu liñi cuacaí, pero né zelahua! ");
INSERT INTO zplNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Enzeꞌe nia luhua nú enta bichia nú tsanaꞌ arquiꞌ Diose lachihua. ");
INSERT INTO zplNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Leꞌca nia luhua nú lecaꞌ bichia nú lañiꞌlaꞌhua liꞌá hasta nú riña bichia chenu nihua: “Chiquiꞌ ñia neca lu cuendaꞌ liꞌinu enu nzeꞌta lu cuendaꞌ Paꞌahua Diose liñibe.” ");
INSERT INTO zplNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Chenu uchiuꞌu Jesuse liñi indu llene Jerusalén nu nzanu, che uyabica bee beneꞌnu lunu, para nú lubeꞌ beella lunu beelá bee niꞌi nú necacheꞌ indu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Che uninu lubeella: ―Rlañiꞌhua indu quieꞌ scua nee. Pero liꞌá nia luhua nú nzeꞌta bichia nú la yaꞌnaꞌ niꞌ stucu quiee quieꞌ equie saꞌe. Yeene rilae. ");
INSERT INTO zplNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Che uya Jesuse cuna bee beneꞌnu equie dañi Olivos, nu chenu nzucunu zeꞌe, che uyabica bee beneꞌnu lunu nu unibeella lunu: ―Niarquiꞌru nú ixiuleꞌelu luru. ¿Xunga aca nucuaꞌ? Nu ¿xi seña aca chenu enta zecalu stucu bese?, nu ¿xi seña aca chenu nzeꞌta laxu iliulabe? ");
INSERT INTO zplNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Che uni Jesuse lubeella: ―Ubiꞌyahua liꞌihua para nú lecati zequienu liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Xne nzeꞌta huaxi bee bene enu ni nú nzeꞌta beei equie cuendaꞌ liꞌá, nu nibeei luhua: “Liꞌá necaa Cristo”, nu scua zequienu beei huaxi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pero liꞌihua yeneꞌhua nú reca xuu urre nú aca xuu, la lliquihua xne scua nzu nú acane, pero lascaꞌ riña nú laxu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Xne liunu tucu nación cuna stucu nación, nu liunu tucu ubiernu cuna stucu ubiernu, nu aca biña, nu aca xú huaxi bee luhuare lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ye nucuaꞌ neca nú apenatsia quixie nú nehuana zeca bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Che deteꞌ cuenda bee bene liꞌihua lubee bene enu riꞌi nú nehuana zecahua, nu utibeei liꞌihua, nu leꞌca esquie ye bee bene iliulabe chana arquiꞌ liꞌihua nú necahua bee benea. ");
INSERT INTO zplNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chenu aca bee nucuaꞌ huaxi bee bene tsanaꞌ arquiꞌ nú nzeli arquiꞌbeella liꞌá, nu chana arquiꞌsaꞌ beella, nu deteꞌ cuenda beella saꞌ beella lubee usticia. ");
INSERT INTO zplNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Leꞌca nzeꞌta huaxi bee bene enu lia ni nú neca beei profetaꞌ Diose. Nu zequienu beei huaxi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nu equie nú chuꞌu huaxi nú necha neca lu iliulabe, huaxi bee bene la zecaꞌ beella saꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero bene enu la tsanaꞌ arquiꞌ nú nzeli arquiꞌ liꞌá diqui tiembu nú nehuañilla, tsilaꞌa Diose bee nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nu bee bedichiaꞌ nzeꞌcaꞌ Diose nú rieneꞌhua nee riꞌchia letsee luye bee bene iliulabe, para nú acabiyaꞌ yebee benene che laxu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Tucu nú uquieꞌe profeta Daniel chenu unilla: Chenu lañiꞌhua nú nchiucuꞌ nú nechahua rnaa liñi indu Jerusalén luhuare elu necachi neca, enu rula ichiꞌ quieꞌ riala riꞌi beyaꞌ xi rnii, ");
INSERT INTO zplNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","chequie bee bene enu nucuaꞌa lubee eyeche lu iliu Judea, rquiꞌña nú yecaxuꞌu beella enza dañi. ");
INSERT INTO zplNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nu bene enu nchiucuꞌ equie niꞌi, la riaꞌlla ana nú chuꞌulla liñi niꞌlla para nú naꞌtsella steneꞌlla; ");
INSERT INTO zplNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","nu bene enu nzu dañi, la benchilaꞌlla niꞌlla para nú chetuculla xuculla. ");
INSERT INTO zplNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Cueꞌ bee unaꞌa enu nuꞌ enduꞌ xlaꞌcu cuna bee unaꞌa enu nuu enduꞌ enu rachi bee bichia zeꞌe! ");
INSERT INTO zplNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Unaꞌcuhua lu Diose para nú la aca bee nucuaꞌ chenu neca tiembu iqui, urre bichia nú sulachi bee bene; ");
INSERT INTO zplNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","xne bichia zeꞌe chiquiꞌ nehuana zeca bee bene, nu lascaꞌlí zeca bee bene scua desde nú uquixie iliulabe, nu lecaꞌ xunga aca scua stucu bese. ");
INSERT INTO zplNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tunu la tsuxe Diose beenú aca tiembu zeꞌe, lecati tsilaꞌa; pero tsuxenu bee nucuaꞌ xne secanu bee beneꞌnu enu ucañinu. ");
INSERT INTO zplNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Chequie tunu bichia zeꞌe nuꞌ bee bene enu ni luhua: “Biꞌyacuruhua caꞌa nzu Cristo”, urre “Biꞌyacuruhua, zeluꞌ nzunu”, la chili arquiꞌhua nú ni beei luhua. ");
INSERT INTO zplNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Xne nzeꞌta bee bene enu ni nú neca Cristo, urre bee enu lia ni nú neca profetaꞌ Diose nu riꞌibeei bee milagro cuna beelá beenú riꞌi nú chiquiꞌ chenu arquiꞌ bee bene para nú zequienuu beei bee bene, nu tunu nuꞌ modo hasta bee bene enu ucañila Diose zequienu beei. ");
INSERT INTO zplNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Udixiuleꞌexulá luhua lunú aca. ");
INSERT INTO zplNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Enzeꞌe, tunu nuꞌ bee bene enu ni luhua: “Biꞌyacuruhua Cristo nzu lu dañi achi cuaꞌ”, la chahua zeꞌe, urre tunu ni bee bene luhua: “Biꞌyacuruhua, Cristo, nzu liñi niꞌi cuaꞌ”, la chili arquiꞌhua nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Xne scua tucu nú riaꞌla lee nú rduꞌllieꞌe desde elu rliñi bichia nu hasta enza ratseꞌ bichia, scua aca chenu riña zecaa liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nu tucu nú reca chenu rieteꞌ saꞌ bee ulabichi tucu luhuare, elu nuxu nañi ati scua aca bichia zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Pero bee bichia zeꞌe chenu udetela nú nehuana ulleꞌca bee bene, cabeli lu bichia, nu la duꞌllieaꞌ ellieꞌ guu, nu zanaꞌ bee belaa enu nchiucuꞌ liñibe lu yuu, nu yebee nú nuꞌ liñibe cuñi. ");
INSERT INTO zplNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chequie lañiꞌ bee bene seña nú nzela enza liñibe, liꞌá Bene enu uxeꞌla Diose, nu ye bee bene iliulabe chiquiꞌ unaꞌ chenu lañiꞌ beei nú nzela liꞌá Bene enu uxeꞌla Diose leta xcabe liñibe, nu tuꞌna rulu siquiꞌ nzela cuna ye poder nú rluꞌcua. ");
INSERT INTO zplNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nu xeꞌla bee ángelea nu juerte bixia bee trompeta para nú quieteꞌsaꞌ beenu bee bene enu ucañilá diqui lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Uluꞌcu cuendahua ejempluꞌ aca higo: Chenu enta yeꞌ ellutsa lue, cuna leca lue, nediyaꞌlaꞌhua nú enta riñala tiembu tsibee. ");
INSERT INTO zplNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Leꞌca scua chenu lañiꞌhua nú recala bee nucuaꞌ, uriꞌihua beyaꞌ nú nzula nú riña zeca liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Liꞌá nia luhua nú yebee nucuaꞌ aca ante nú ati bee bene enu nehuañi tiembu quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Liñibe cuna iliulabe nitilu, pero stichiaꞌa la dete nú yalu yeene. ");
INSERT INTO zplNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Pero lecati riꞌi beyaꞌ xi bichia nu xi hora nú aca yebee nucuaꞌ, nu niꞌ bee ángele liñibe, nu niꞌ Lliꞌñi Diose la riꞌi beyaꞌ xunga aca bee nucuaꞌ. Tucutsia Diose Pa liñibe nediyaꞌ xunga aca bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Tucu nú unga tiembu nú uhuañi Noe, leꞌca esquie aca bichia chenu riña zeca liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Xne tiembu zeꞌe, ante nú xeꞌla Diose quiuaꞌtsaꞌ lu iliulabe, racu bee bene nu rueꞌ beei, nu uchia beei, nu udeteꞌ beei xinchiuꞌcu beei uchia, scua uriꞌi bee bene hasta bichia nú uyuꞌu Noe liñi barco; ");
INSERT INTO zplNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","nu chenu la zaꞌlí arquiꞌ bee bene uquixie ulaca tucu quiuaꞌtsaꞌ nu unguyaꞌ inza ye bee bene nu scua ungutibeei. Leꞌca scua aca chenu riña zeca liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nu bichia zeꞌe chiucu niyu enu nucuaꞌa dañi, tuculla nza nu stuculla riaꞌna. ");
INSERT INTO zplNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Leꞌca chiucu unaꞌa enu riuu, tuculla nza nu stuculla riaꞌna. ");
INSERT INTO zplNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Enzeꞌe ucuaꞌa tsiñahua xne la riꞌihua beyaꞌ xi bichia nzela zecaa, liꞌá enu rnibiyaꞌ luhua. ");
INSERT INTO zplNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pero liꞌihua nediyaꞌhua nú tunu tucu bene nediyaꞌ xi hora rulaꞌ riña huanaꞌ chuꞌu niꞌlla cachiꞌ steneꞌlla, la aꞌtsella nu la zelalla nú chuꞌu huanaꞌ niꞌilla cachiꞌ steneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Enzeꞌe, rquiꞌña nú leꞌca ucuaꞌa tsiñahua xne chenu la zaꞌlí arquiꞌhua, riña zeca liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Uriꞌihua xi rriꞌi tucu mosoꞌ enu uyaꞌna ucu niꞌi patronꞌ, uyaꞌnanulla ye bee mosoꞌ para nú deteꞌlla nú acu beei hora nú riala nú acu beei? ");
INSERT INTO zplNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ñia neca lu cuendaꞌ mosoꞌ enu rriꞌi tucu nú rialane chenu riña patronꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Liꞌá nia luhua, nú patron cuaꞌ tsaꞌnalla lu mosoꞌ cuaꞌ nú biꞌya nucuaꞌ ye steneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero tunu mosoꞌ zeꞌe necha rriꞌilla, nu riꞌilla elliebacuꞌ nú rleꞌelá benchilaꞌ patronꞌlla enu rnibiyaꞌ lulla, ");
INSERT INTO zplNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nu quixiella nú liunulla bee mosoꞌ, nu acunulla nu hueꞌnulla bee uniqui, ");
INSERT INTO zplNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","chequie riña patronꞌlla tucu bichia nú la riꞌilílla elliebacuꞌ nú riñalla, nu tucu hora nú la riꞌilla beyaꞌ, ");
INSERT INTO zplNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","nu che chiquiꞌ juerte deteꞌ patronꞌlla castiya liꞌilla, nu xeꞌla patronꞌlla liꞌilla elu nzue bee bene enu necha rriꞌi. Elu unaꞌlla nu acu layalla. ");
INSERT INTO zplNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Leꞌca uni Jesuse stucu ejemplu lubee beneꞌnu: Para nú chuꞌu bene liñibe elurnibiyaꞌ Diose, huaxi bee bene zeca tucu nú ulleꞌca chiꞌi bee unaꞌa eꞌneꞌ enu nuyaꞌ quinqué nzetsuquiee novio. ");
INSERT INTO zplNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ayuꞌ beenchu lá riꞌi elliebacuꞌ xi rquiꞌña nu sayuꞌ beenchu uriꞌi elliebacuꞌ xi quiꞌñia. ");
INSERT INTO zplNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bee enu lá riꞌi elliebacuꞌ xi quiꞌña, unguyaꞌtsia beenchu quinquéꞌ beenchu pero né uyaꞌlá beenchu aceite para nú chuꞌulá liñi quinquéꞌ beenchu, ");
INSERT INTO zplNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","pero sayuꞌ bee enu uriꞌi elliebacuꞌ nú xi quiꞌña, unguyaꞌ beenchu quinquéꞌ beenchu nu leꞌca unguyaꞌlá beenchu aceite para nú chuꞌulá liñi quinquéꞌ beenchu. ");
INSERT INTO zplNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nu lunú rleꞌe nú riña novio, unaꞌtse calaꞌ ye beenchu, nu udaꞌtse beenchu. ");
INSERT INTO zplNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nu che tucu ulelaꞌ rulaꞌ, ubene tucu chi nú juerte uni: “¡Nzeꞌtala novio; uquia chaꞌcaluhualla!” ");
INSERT INTO zplNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Che uzetee ye bee unaꞌa zeꞌe, nu uquixie beenchu nú utsucheꞌ beenchu quinquéꞌ beenchu. ");
INSERT INTO zplNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nu sayuꞌ beenchu enu lá auyaꞌ aceite uni beenchu lu sayuꞌ saꞌbeenchu enu nuyaꞌ tsiña aceiteꞌ: “Alaꞌ chiuꞌu arquiꞌhua uliꞌquihua lleꞌna aceiteꞌhua chuꞌu liñi quinquéꞌru, xne enta yalala quinquéꞌru.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero bee enu nuyaꞌ tsiña aceite ucuaqui: “La chiuꞌu arquiꞌru liquiꞌrune, xne tunu liquiꞌrune la riquiꞌi niꞌ para liꞌiru nu niꞌ para liꞌihua. Nzala nú uquiahua elu riquii nu zeꞌe tsihuane tsiꞌhua aceiteꞌhua elu riquii.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero diquila nú nze tsi beenchu aceiteꞌ beenchu, uriña novio. Che uyuꞌutsia ayuꞌ beenchu enu nucuaꞌa tsiña lu eluchia, cuna novio, nu chu uyacuꞌ ruꞌu puerta. ");
INSERT INTO zplNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Luzeꞌelá uriña sayuꞌ bee unaꞌa zeꞌe, nu uni beenchu: “¡Detá, detá, alaꞌ uxaꞌla ruꞌu puerta chuꞌuru!” ");
INSERT INTO zplNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero ucuaquilla lubeenchu: “Nia luhua nú la xaꞌlane xne la chuluahua.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chequie uni Jesuse lubee bene zeꞌe: ―Ucuaꞌa tsiñahua, xne la riꞌihua beyaꞌ xi bichia nu xi hora riña zeca Liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Leꞌca uni Jesuse stucu ejemplu lubee beneꞌnu: Elurnibiyaꞌ Diose neca xi neca nú uriꞌi tucu bene enu nza istu, pero ante nú challa ubixiaxulla bee mosoꞌlla para nú tsaꞌnalla dimiꞌlla lubeei. ");
INSERT INTO zplNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Lu tucu mosoꞌ zeꞌe udeteꞌlla ayuꞌ mili, nulu stucui udeteꞌlla chiucu mili, nulu stucui udeteꞌlla tucu mili. Scua udeteꞌlla yabeei tucu nú aca cada tucua beei riꞌinu beei berexe. Cheelá nzalla istu. ");
INSERT INTO zplNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mosoꞌ enu uyucu ayuꞌ mili bexu, uriꞌinui dimi cuaꞌ berexe nu uriꞌi ana se sayuꞌ mili bexu mase. ");
INSERT INTO zplNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Leꞌca scua uriꞌi mosoꞌ enu uyucu chiucu mili, uriꞌi berexe cuna dimi cuaꞌ, nu uriꞌi ana se xiucu mili mase. ");
INSERT INTO zplNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero mosoꞌ enu uyucu tucu mili, uducheꞌ aꞌchiꞌi dimiꞌ patron zeꞌe liñi tucu iꞌchiu nú udaꞌñii lu yuu. ");
INSERT INTO zplNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Chequie xee tiembu uya patrónꞌ bee mosoꞌ cuaꞌ, che ubenchilaꞌ zecalla nu uquixiella unacuꞌlla cuentaꞌ dimiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nu rlutila uya mosoꞌ enu uyucu ayuꞌ mili lulla, nu udeteꞌ cuendai ayuꞌ mili bexuꞌlla nu cuna se sayuꞌ mili bexu lliꞌñine, che uni mosoꞌ zeꞌe lu patronꞌi: “Detá, liꞌilu uliquiꞌlu ayuꞌ mili bexu ya nu nguie se sayuꞌ mili bexu lliꞌñine nú uriꞌá ana dete cuenda yaalu.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Che uni patronꞌi lui: “Neca nzeꞌca nú uriꞌilu, necalu tucu bene nzeꞌca. Nu uriꞌilu tucu nú necane, nu lunú uriꞌilu tucu nú necane lu lleꞌna nú uliquia lulu, nee tsaꞌnalá huaxilá nú tsaꞌna lulu. Uyuꞌu nu ñia utsu arquiꞌ cuna liꞌá.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chela uriña mosoꞌ enu uyucu chiucu mili bexu, nu uni lulla: “Detá, uliquiꞌlu chiucu mili bexu ya, nu nguie se xiucu mili bexu lliꞌñine nú uriꞌá ana dete cuenda yalu.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Che uni patronꞌi lui: “Neca nzeꞌca nú uriꞌilu, necalu tucu bene nzeꞌca. Nu uriꞌilu tucu nú necane nu lunú uriꞌilu tucu nú necane lu lleꞌna nú uliquia lulu, nee tsaꞌnalá huaxilá nú tsaꞌna lulu. Uyuꞌu nu ñia utsu arquiꞌ cuna liꞌá.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pero chenu uriña mosoꞌ enu uyucu tucu mili bexu, uni lu patronꞌi: “Detá, liꞌá nediyaa nú la luꞌcu arquiꞌlu bee bene, nu riuculu ulaꞌcu elu lá riꞌilu riñaꞌ nu rriꞌilu ulaꞌcu elu lá duꞌlu nii. ");
INSERT INTO zplNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Enzeꞌe ulliquia, nu uyaꞌa uducheꞌ aꞌchiaꞌa dimiꞌlu luyuu. Pero nguie dimiꞌlu dete cuenda nee.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Che uni patronꞌi lui: “Necalu tucu mosoꞌ enu necha rriꞌi nu nebichiu. Tunu nediyaꞌlu nú riucuaꞌa ulaꞌcu nú lá riꞌá riñaꞌlu nu rriꞌá ulaꞌcu elu lá duꞌa nii, ");
INSERT INTO zplNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿xiquie nú né duꞌlu dimia banco? Nu chenu benchilaꞌa ayucuaꞌa dimia cuna lliꞌñine.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Che uni patron zeꞌe lubee bene enu nucuaꞌa zeꞌe: “Uxihua tucu mili bexu cuaꞌ ya benecuaꞌ, nu udeꞌteꞌhuane ya bene enu nzenela chiꞌi mili bexu. ");
INSERT INTO zplNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Xne bene enu rluꞌculane atiꞌlaꞌ nzeꞌe huaxiláe, nu hasta nú luꞌcu sobrallae, pero bene enu lleꞌnatsia nú rluꞌcu, hasta lu lleꞌna nú rluꞌculla yetsu yalla. ");
INSERT INTO zplNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nu mosoꞌ enu la zibiꞌ quieꞌ, uluahuai eliꞌyaꞌ elu necabe nzu, nu zeꞌe unaꞌi nu acuxaꞌ layai.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Chenu nzeꞌta zeca Bene enu uxeꞌla Diose nzeꞌtanu cuna poder nú rluꞌcunu, nu cuna ye bee ángeleꞌnu para nú zucunu lu xleta elu nibiyaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nu ye bee bene iliulabe yeteꞌsaꞌ lunu, nu huachunu beella letasaꞌ beella, xi rriꞌi bene enu rriucu bee sanchi nú rluachulla sanchi leta bee chipa. ");
INSERT INTO zplNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nu bee bene enu neca bee beneꞌnu cuaꞌanu bee nzeꞌe chubeꞌnu nu bee bene enu laca bee beneꞌnu cuaꞌanu bee nzeꞌe chubecaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Che liꞌinu enu neca arre ninu lubee bene enu nucuaꞌa chubeꞌnu: “Utehua yehua bee enu uriꞌi leꞌyala Pa liñibe. Nu uyuꞌuhua liñibe elu rnibiyaꞌnu elu utsucheꞌlanu para liꞌihua desde chenu uquixie iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Xne chenu uliaꞌnaa uliquiꞌhua nú udacua, nu chenu ubichia uliquiꞌhua nú ungüaꞌa, nu chenu unzea xi enze bene rene, uliquiꞌhua elu uyaꞌnaa. ");
INSERT INTO zplNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nu chenu lecaꞌ xucua uliquiꞌhua xucua, nu chenu unga ritia ubeꞌta biꞌyahua liꞌá, nu chenu ullutsea niꞌcuꞌ ubeꞌta biꞌyahua liꞌá.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Che ni bee bene enu uriꞌi nzeꞌca zeꞌe: “Detá, ¿xunga ulañiꞌru nú uliaꞌnaꞌlu nu uliquiꞌru nú udaculu? Nu ¿xunga ulañiꞌru nú ubichiꞌlu nu uliquiru nú ungüeꞌlu? ");
INSERT INTO zplNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nu ¿xunga ulañiꞌru nú unzelu xi unzee bene rene, nu uliquiꞌru elu uyaꞌnalu? nu ¿xunga ulañiꞌru nú lecaꞌ xuculu, nu uliquiꞌru xuculu? ");
INSERT INTO zplNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Nu xunga ulañiꞌru nú ritilu nu ubela biꞌyaru liꞌilu?, nu ¿xunga ulañiꞌru nú netselu niꞌcuꞌ nu ubela biꞌyaru liꞌilu?” ");
INSERT INTO zplNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nu liꞌinu enu neca arre, cuaquinu nú ninu: “Liꞌá nia luhua nú ye nú uriꞌihua elietsa lu tucu bee benea mase nú lecati neca nzeꞌe, neca xi neca nú lua uriꞌihua elietsa.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Che ninu lubee bene enu nucuaꞌa chubeca: “Ullunaꞌhua lua, liꞌihua enu necha uriꞌi, uquiahua lu quii nú leca xunga yala elu neca para bezeꞌlu cuna bee ángeleꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Xne chenu uliaꞌnaa, né liquiꞌhua nú acua, nu chenu ubichia, né liquiꞌhua xi ahuaꞌa; ");
INSERT INTO zplNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nu chenu unzea xi enzee tucu bene rene né liquiꞌhua elu ayaꞌnaa, nu chenu lecaꞌ xucua né liquiꞌhua xucua nu chenu ungaritia, nu leꞌca ullutsea niꞌcuꞌ né yeꞌta biꞌyahua liꞌá.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Chequie ni bee bene zeꞌe lunu: “Detá, ¿xunga ulañiꞌru nú uliaꞌnaꞌlu nu ubichiꞌlu, nu uya nzeelu xi enzee tucu bene rene, urre xunga ulañiꞌru nú uzecalaꞌchaꞌlu xuculu, urre ungaritilu, urre xunga ulañiꞌru nú ullutselu niꞌcuꞌ, nu ne riꞌiru elietsa lulu?” ");
INSERT INTO zplNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Che cuaquinu lubee bene zeꞌe: “Liꞌá nia luhua, luye nú né riꞌihua para nú ariꞌihua elietsa lubee benea mase nú lecati neca nzeꞌe, leꞌca neca xi neca nú lua né riꞌihua elietsa.” ");
INSERT INTO zplNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nu bee bene quieꞌ chaa lu castiya nú leca xunga laxu, nu bee bene enu uriꞌi nzeꞌca luꞌcu elu nehuañi nú leca xunga laxu liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Chenu ulaxu uni Jesuse scua lubee bene, che uninu lubee beneꞌnu: ");
INSERT INTO zplNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Liꞌihua nediyaꞌhua nú xiucutsia bichia rriꞌi nú aca eliñi baxcu, nu liꞌá Bene enu uxeꞌla Diose deteꞌ cuenda bene liꞌá lubee bene para nú quieꞌe beei liꞌá lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chequie bee uleꞌya enu rnibiyaꞌ lubeelá bee uleꞌya, cuna bee ulaxcuela enu reca ley nu cuna bee usticiaꞌ bee bene Israel, uyetesaꞌ beei ruꞌu eleꞌya niꞌi uleꞌya Caifás enu rnibiyaꞌ lubeelá bee uleꞌya. ");
INSERT INTO zplNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nu zeꞌe ubedichiaꞌ beei nú xa modo zequienu beei Jesuse para nú naꞌtse beei liꞌinu nú uti beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero unibeei lusaꞌbeei: ―La riaꞌahua scua diqui nú reca eliñi para nú la tsu reche bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Chenu nzu Jesuse eyeche Betania, niꞌ Simón enu riꞌchia bene leproso, ");
INSERT INTO zplNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","che uriña tucu unaꞌa lunu nu nuyaꞌnchu tucu frasco perfume nú chiquiꞌ huaxi seca, nu uduꞌnchue equienu chenu nzucunu lu mexa. ");
INSERT INTO zplNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chenu ulañiꞌ bee beneꞌ Jesuse nucuaꞌ, ulee beella nu unibeella lusaꞌbeella: ―¿Xinu utiꞌchianchu perfume cuaꞌ scua? ");
INSERT INTO zplNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Alaꞌ aꞌla aiqui perfumecuaꞌ para nú riꞌinchu elietsa lubee bene enu seca elitsi. ");
INSERT INTO zplNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nu chenu ubeneꞌ Jesuse nú uni beella, che uninu: ―¿Xinu rlehua lu unaꞌa quieꞌ? Nu lunú uriꞌinchu lua neca nzeꞌcae. ");
INSERT INTO zplNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Xne bee bene elitsí siempre nucuaꞌa letahua, pero liꞌá la tsua siempre letahua. ");
INSERT INTO zplNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nu lunú uduꞌ unaꞌa quieꞌ perfume equiea, neca nucuaꞌ nú nzucheꞌla cuerpoa chenu achiꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Liꞌá nia luhua nu catse lu iliulabe elu ixiuleꞌe bee bene bedichiaꞌ nzeꞌcaꞌ Diose, leꞌca nibee bene nú uriꞌinu unaꞌa quieꞌ liꞌá, para nú elluꞌcu arquiꞌ bee bene liꞌinchu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Che tucu lu chiꞌchiucu bee beneꞌnu enu lee Judas Iscariote, uya lubee uleꞌya enu rnibiyaꞌ lubeela bee uleꞌya, ");
INSERT INTO zplNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nu uni Judas lubeella: ―¿Calu liquiꞌhua para nú dete cuendaa Jesuse luhua che? Che udeteꞌbeella alallichiꞌi melu plata yai. ");
INSERT INTO zplNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nu desde bichia zeꞌe ucuaꞌna Judas xneca modo deteꞌ cuendai Jesuse lubee uleꞌya. ");
INSERT INTO zplNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bichia xee eliñi baxcu chenu racu bee bene Israel pa nú la chuꞌu levadura equie, che uyabica bee beneꞌ Jesuse lunu, nu unibeella lunu: ―¿Cá niarquiꞌlu nú nzerecheꞌru nú daꞌcuxeꞌahua reché baxcu? ");
INSERT INTO zplNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Chequie uninu lubeella: ―Uquiahua Jerusalén, nzucu tucu bene enu nihua lu: “Singuie rni Maestro: Nzeꞌta riñala horaꞌnu, nu niarquiꞌnu nú acuxenunu bee beneꞌnu exee baxcu niꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Che uriꞌi bee beneꞌnu tucu nú unibiyaꞌnu nú riꞌi beella, nu urecheꞌ beella nú acuxee beella reché baxcu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Chenu uyuꞌu rulaꞌ, uzucu Jesuse lu mexa cuna chiꞌchiucu bee beneꞌnu, ");
INSERT INTO zplNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","nu diquila nú racuxee beella, uninu lubeella: ―Nia luhua nú tucuhua deteꞌ cuenda liꞌá para nú atia. ");
INSERT INTO zplNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Che chiquiꞌ nehuana utsu arquiꞌbeella nu uquixie unedichiaꞌ tucua tucua beella lunu, nu unibeella lunu: ―Detá, ¿liꞌá nzeꞌe la? ");
INSERT INTO zplNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nu ucuaqui Jesuse lubeella: ―Enu seꞌe pa leꞌca liñi pliato elu seꞌa pa nzeꞌe neca enu deteꞌ cuenda liꞌá lubee bene enu uti liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Neli nú liꞌá Bene enu uxeꞌla Diose, rquiꞌña nú zecaa tucu nú rni lu ichiꞌ Stichiaꞌ Diose; pero ¡cueꞌ bene enu deteꞌ cuenda liꞌá! Máse neca nzeꞌca lu cuendaꞌ bene zeꞌe nú né alaxulla. ");
INSERT INTO zplNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Chequie Judas enu deteꞌ cuenda liꞌinu, uni lunu: ―Maestro, ¿liꞌá nzeꞌe la? Che uni Jesuse lui: ―Ahuaꞌ, liꞌilu nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Diquila nú racu beella, unaꞌtse Jesuse tucu pa nu udeteꞌnu cheꞌtsa lu Diose, nu chu uleꞌenu pa zeꞌe udeteꞌnu ya beella, nu uninu lubeella: ―Udacuhua pa quieꞌ, ninguieꞌ neca cuerpoa. ");
INSERT INTO zplNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Che chu unaꞌtsenu tucu copa biñu, nu udeteꞌnu cheꞌtsa lu Diose nu chu udeteꞌnu copa cuaꞌ ya beella, nu uninu lubeella: ―Uhueꞌ yehua biñu quieꞌ, ");
INSERT INTO zplNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","xne neca nucuaꞌ renea nú riꞌchia chenu atia para nú tsilaꞌa huaxi bee bene iliulabe, xne equie cuendaꞌ nú atia yaꞌla tucu inziu cuqui nú riꞌi Diose perdona stula bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pero nia luhua nú la huaꞌa biñu nú necacheꞌe uva niꞌ stucu bese, hasta bichia nú huaꞌanuahua biñu cuqui liñibe elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chenu ulaxu ungula beella canto lu Diose, che chu nzuebeella dañi nú lee Olivos. ");
INSERT INTO zplNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Che uni Jesuse lubeella: ―Yehua tsanaꞌ arquiꞌhua liꞌá rulaꞌ quieꞌ, tucu nú rni lu ichiꞌ Stichiaꞌ Diose elu rni: “Utia bene enu rriucu bee sanchi, nu riꞌchialetse beeií.” ");
INSERT INTO zplNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero chenu huañi zecaa, rlutilaa nzaꞌa Galilea, cheelá riñahua zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chequie uni Pedro lu Jesuse: ―Añinzuca nú tsanaꞌ arquiꞌ yebeella liꞌilu. Pero liꞌá la tsana arquia liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Che uni Jesuse lu Pedro: ―Nia lulu nú nee rulaꞌ quieꞌ ante nú bixia tiula, unilalu chuna bese núla chululu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pero uni Pedro lunu: ―Mase nú atia cuna liꞌilu, la cachia nú nuꞌlua liꞌilu. Nu leꞌca scua uni ye beelá bee beneꞌnu lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Che uriña Jesuse cuna bee beneꞌnu tucu luhuare nú lee Getsemaní, nu uninu lubeella: ―Ucuaꞌahua caꞌa, diquila nú nzenacua lu Diose inchiuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Che chu nzenunu Pedro cuna rucu llianaꞌ Zebedeo, nu uquixie nú chiquiꞌ nehuana nzu arquiꞌnu hasta nú lixiuaꞌ nzu arquiꞌnu, ");
INSERT INTO zplNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","nu uninu lubeella: ―Chiquiꞌ nehuana nzu arquia hasta nú seꞌca nú atia, yaꞌnascaꞌhua caꞌa, nu ucuaꞌa naahua cuna liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Che chu nza Jesuse lleꞌna enza lu zeꞌelá, nu utsu lliquinu hasta nú utiꞌnu tequienu lu yuu, nu unacuꞌnu lu Diose nú uninu: ―Paa, tunu nuꞌ modo utsilaꞌa liꞌá lunú nehuana enta zecaa, pero la acatsia tucu nú niarquia, acatsia tucu nú niarquiꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chenu ubenchilaꞌ zecanu elu nucuaꞌa bee beneꞌnu, ullunaꞌnu beella nú raꞌtse beella, nu uninu lu Pedro: ―¿Xieꞌ lá riquiꞌhua acuaꞌanahua masia tucu hora cuna liꞌá la? ");
INSERT INTO zplNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ucuaꞌa nahua nu unaꞌcuhua lu Diose para nú la riꞌi bezeꞌlu ana luhua. Xne liꞌisihua chiquiꞌ nuꞌ ana arquiꞌhua nú riꞌihua tucu nú neca nzeꞌca, pero la riquiꞌ cuerpoꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bese rrucu nú uya naꞌcunu lu Diose uninu: ―Paa, tunu leca modo nu la zeca lunú nehuana nzu nú zecaa, acatsia tucu nú niarquiꞌlu che. ");
INSERT INTO zplNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Chenu ubenchilaꞌ zecanu elu nucuaꞌa beella, ulañiꞌnu nú raꞌtseaꞌla beella stucu bese xne uriꞌi calaꞌ ana lubeella. ");
INSERT INTO zplNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nu utsaꞌnanu beella zeꞌe nu uya naꞌcuꞌnu lu Diose bese rriuna cuna bee bedichiaꞌ nú unilanu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chenu ubenchilaꞌnu elu nucuaꞌa beella, uninu lubeella: ―¿Xieꞌ raꞌtsescaꞌhua nu sulachiscaꞌhua la? Nu liꞌá Bene enu uxeꞌla Diose, uriñala hora nú deteꞌ cuenda bene liꞌá lubee bene enu necha rriꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Uzetehua ne chaꞌahua nee, xne axula nzeꞌta enu deteꞌ cuenda liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Rdichiaꞌnuscaꞌ Jesuse bee beneꞌnu chenu uriña Judas, enu neca tucu lu chiꞌchiucu bee beneꞌnu, uriñayui huaxi bee bene enu nuyaꞌ espada cuna acarute lunu. Nu unaꞌtse beei Jesuse xne unibiyaꞌla bee uleꞌya enu rnibiyaꞌ lubeela bee uleꞌya cuna bee usticia Israel nú acane scua. ");
INSERT INTO zplNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nu Judas enu udeteꞌ cuenda Jesuse unilai lubee bene zeꞌe xa riꞌi chenu deteꞌ cuendai liꞌinu, nu uni lubeella: ―Nee enu acua bichiuꞌ xeca, nzeꞌella nu nzeꞌe naꞌtsehua. ");
INSERT INTO zplNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chequie chenu uriña Judas zeꞌe uya bicai lunu nu uni: ―¡Malune, Maestro! Nu chu udacui bichiuꞌ xecanu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Che uni Jesuse lu Judas: ―Amigo, uriꞌi lunú nzeꞌtalu riꞌilu. Che chu unaꞌtse bee bene zeꞌe Jesuse para nú uyaꞌ beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Che tucu bee bene enu nzunu Jesuse zeꞌe uhua espadaꞌ nu uchiecuꞌlla tucu diaca mosoꞌ uleꞌya enu rnibiyaꞌ lubee uleꞌya. ");
INSERT INTO zplNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chequie uni Jesuse lulla: ―Uduꞌcheꞌ espadaꞌlu xne ye bee bene enu rriꞌi xu cuna espada, leꞌca cuna espada atilla. ");
INSERT INTO zplNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Xieꞌ la riꞌilu beyaꞌ nú nuꞌ modo nacua lu Paa liñibe, nu chu xeꞌlanu huaxi mili bee ángeleꞌnu enu riꞌi elietsa lua la? ");
INSERT INTO zplNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero tunu riꞌá scua, ¿xneca modo yalu tucu nú nequie lu ichiꞌ Stichiaꞌ Diose elu rni nú scua riala zecaa? ");
INSERT INTO zplNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Che chu uninu lubee bene zeꞌe: ―¿Xinu nzeꞌtahua cuna espada nu cuna acarute para nú uyaꞌhua liꞌá xi neca tucu huanaꞌ? Ye yeꞌe nzua letahua uzeteahua Stichiaꞌ Diose liñi indu llene Jerusalén, nu né naꞌtsehua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero ye bee nucuaꞌ unga para nú yalu tucu nú nequie lu ichiꞌ Stichiaꞌ Diose nú uquieꞌe bee profeta. Chequie ye bee beneꞌnu utsanaꞌ arquiꞌbeella liꞌinu nu uyecaxuꞌu beella nzuebeella. ");
INSERT INTO zplNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Che bee bene enu unaꞌtse Jesuse unguyaꞌ beei liꞌinu niꞌi Caifás, uleꞌya enu rnibiyaꞌ luye bee uleꞌya, zeꞌe neyeteꞌsaꞌ bee ulaxcuela enu reca ley cuna bee usticiaꞌ bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nu istu istu nzequie Pedro Jesuse hasta ruꞌu niꞌi uleꞌya zeꞌe, nu chenu uriña Pedro ruꞌu niꞌi uleꞌya zeꞌe uzuculla leta bee bene enu rriucu zeꞌe para nú lañiꞌlla xi riꞌinu bee benecuaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chequie bee uleꞌya enu rnibiyaꞌ lubee uleꞌya, nu cuna ye bee usticia ucuaꞌna beella xa modo taꞌ beella eluquichiaꞌ Jesuse para nú atinu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero lá llelaꞌ beella xi eluquichiaꞌ ataꞌ beella liꞌinu añinzuca nú huaxi bee bene uni nú la neli contra liꞌinu, che luzeꞌelá uriña xiucu bene enu leꞌca uni nú la neli contra liꞌinu, ");
INSERT INTO zplNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nu unibeei: ―Benequieꞌ uni: “Liꞌá aca chila induꞌ Diose nu recheꞌ zecane lu chunatsia bichia.” ");
INSERT INTO zplNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chequie utsuli uleꞌya enu rnibiyaꞌ lu ye bee uleꞌya nu unilla lu Jesuse: ―¿Xiquie nú lecalí xi cuaquilu? ¿Xi nucuaꞌ rnibeei lu cuendaꞌlu? ");
INSERT INTO zplNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero lecalí xi ucuaqui Jesuse. Che uni uleꞌya zeꞌe lunu: ―Equie cuendaꞌ Diose enu nehuañi, uniꞌi nú neli neca lua tunu liꞌilu necalu Cristo lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Che ucuaqui Jesuse nú uninu: ―Liꞌá nzeꞌe. Nu leꞌca nia luhua nú lañiꞌhua liꞌá Bene enu uxeꞌla Diose nú nzucuaꞌa cueꞌtsenu chúbe, liꞌinu enu rluꞌcu ye poder, nu leꞌca lañiꞌhua nú nzela liñi xcabe enza liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chenu ubeneꞌ uleꞌya zeꞌe nucuaꞌ che utsalla xuculla, nu unilla: ―Lu Diose rni nucuaꞌ bedichiaꞌ nú necha neca, ¿xinu laꞌnaꞌláꞌahua testigo? Liꞌihua ubeneꞌláꞌhua bee bedichiaꞌ nú necha neca uni nucuaꞌ lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Xa nihua nee? Che ucuaqui bee bene zeꞌe nú unibeei: ―Riala nú ati nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Che utsuxene beei lunu nu udiñi beei liꞌinu, nu nuꞌ beei enu udichiue lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nu unibeei lunu: ―Tunu liꞌilu necalu Cristo, ¡uniꞌ ti udiñi liꞌilu! ");
INSERT INTO zplNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Diquila nú nzucu Pedro ruꞌu eliꞌyaꞌ niꞌi uleꞌya zeꞌe, che uyabica tucu criadaꞌ uleꞌya zeꞌe lu Pedro, nu uninchu lulla: ―Seꞌca nú leꞌca nuulu enzenuulu Jesuse enu neca bene lu iliu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero utsacuꞌ arquiꞌ Pedro nú nuꞌlulla Jesuse lubee bene zeꞌe, nu unilla: ―La riꞌá beya xi rnilu. ");
INSERT INTO zplNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Che chu nza Pedro enza ruꞌu puerta eliꞌyaꞌ zeꞌe, nu zeꞌe ulañiꞌ stucu criada liꞌilla nu uninchu lubee bene enu nucuaꞌa zeꞌe: ―Leꞌca nuu benecuaꞌ enzenu Jesuse bene eyeche Nazaret. ");
INSERT INTO zplNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Chequie utsacuꞌ arquiꞌ zeca Pedro stucu bese nú la chululla Jesuse, nu uquieꞌella Diose nú unilla: ―La chulua benecuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nu luzeꞌetsia bee bene enu nucuaꞌa zeꞌe uyabica beei lu Pedro, nu unibeei lu Pedro: ―Ache nzeꞌca rlubeꞌ nú necalu tucu beneꞌ bene cuaꞌ, xne rdichiaꞌlu tucu nú rdichiaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pero utsutaꞌ Pedro nú unilla: ―Deteꞌ Diose castiya liꞌá tunu la nia nú neli neca la chulua bene cuaꞌ. Nu che hora zeꞌe ubixia tucu tiula. ");
INSERT INTO zplNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Che ulluꞌcuꞌ arquiꞌ Pedro lunú uni Jesuse lulla: “Ante nú bixia tiula unilálu chuna bese nú la chululu liꞌá.” Che chu uchiuꞌu Pedro ruꞌu eliꞌyaꞌ zeꞌe nu chiquiꞌ ungunaꞌlla nú nehuana nzu arquiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Chenu uyeꞌe lu yuu, uyetesaꞌ ye bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee usticia Israel nu unga tucu necatse stichiaꞌ beella nú xa modo riꞌi beella para nú ati Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Che ullicaꞌcu beella Jesuse unguyaꞌ beella lu gobernador Poncio Pilato. ");
INSERT INTO zplNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nu Judas enu udeteꞌ cuenda Jesuse, chenu ulañiꞌi nú necala nú atinu chiquiꞌ necha ulleꞌcai, nu uya deꞌte cuenda zecai ala llichiꞌi melu plata lubee uleꞌya enu rnibiyaꞌ, cuna lubee usticia Israel, ");
INSERT INTO zplNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nu uni lubeella: ―Uriꞌá dula xne udete cuendaa tucu bene enu lecaxi uriꞌi para nú ati. Nu ucuaqui beella lu Judas: ―¿La biyaꞌru enzeꞌe? ¡Necatsiahuaꞌ cuendaꞌlu! ");
INSERT INTO zplNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chequie uya utsiꞌqui Judas bee melu zeꞌe liñi indu llene Jerusalén, nu chu uya tsiꞌi añii nu ungutii. ");
INSERT INTO zplNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Che uquieteꞌsaꞌ bee uleꞌya enu rnibiyaꞌ bee melo zeꞌe, nu uni beella lusaꞌ beella: ―Leca modo duaꞌahua melu quieꞌ liñi alcancía elu nuꞌ dimi uꞌna, xne necane melo nú uyaxu nú ati tucu bene. ");
INSERT INTO zplNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Che chu unga tucu necatse stichiaꞌ beella nú tsi beella tucu yuu elu rlua bee bene yuu nú recacheꞌ exquiꞌñia cuna dimi zeꞌe, para nú aca zeꞌe pandiuñi elu achiꞌ bee bene rene. ");
INSERT INTO zplNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Enzeꞌe hasta nee lee yuu zeꞌe, yuu rene. ");
INSERT INTO zplNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Scua uyalu tucu nú uni profeta Jeremías chenu unilla: “Uyucu bee bene ala llichiꞌi melo plata (precio nú uni bee bene Israel nú secanu), ");
INSERT INTO zplNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nu cuna melo cuaꞌ utsi beella tucu yuu elu rlua bene yuu nú recacheꞌe exquiꞌñia, tucu nú uni Diose lua nú acane.” ");
INSERT INTO zplNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Chenu uyayu bee bene Jesuse lu gobernador Poncio Pilato, che unedichiaꞌlla lu Jesuse, nú unilla: ―¿Liꞌilu necalu arreꞌ bee bene Israel la? Che uni Jesuse lulla: ―Ahuaꞌ, tucu nú unilu scua necane. ");
INSERT INTO zplNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nu chenu rtaꞌquiya bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee usticiaꞌ bee bene Israel liꞌinu, lecalí xi ucuaquinu. ");
INSERT INTO zplNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Che uni Pilato lunu: ―¿Xieꞌ la yeneꞌlu ye beenú rni cundra bee benecuaꞌ lu cuendaꞌlu la? ");
INSERT INTO zplNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero niꞌ tucu bedichiaꞌ né cuaqui Jesuse lu pilato, che chiquiꞌ nzenu arquiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nu bee bichia zeꞌe reca eliñi baxcu neca costumbreꞌ Poncio Pilato nú rlaꞌalla tucu bene enu nchiñi niꞌcuꞌ, tatse tucu bene enu nacuꞌ bee bene nu laꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Leꞌca bee bichia zeꞌe nchiñi tucu bene enu lee Barrabás niꞌcuꞌ, nu ye bee luhuare nediyaꞌlaꞌ bee bene ti necalla. ");
INSERT INTO zplNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nu chenu neyeteꞌsaꞌla bee bene zeꞌe, unedichiaꞌ Pilato lubeella nú unilla: ―¿Ta bene enu niarquiꞌhua nú laꞌa: Barrabás la?, urre ¿Jesuse enu rni bee bene nú neca Cristo la? ");
INSERT INTO zplNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Uni Pilato scua xne uriꞌilla beyaꞌ nú equie nú riatsia arquiꞌbeella enzeꞌe udeteꞌ cuenda beella Jesuse lulla. ");
INSERT INTO zplNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Chenu uzucu Pilato elu rnibiyaꞌlla nu rlualulla lu cuendaꞌ Jesuse, uriña tucu resunaꞌ unaꞌalla lulla nú uninchu lulla: “La riꞌchialu benecuaꞌ xne lecaxi equiya rluꞌculla, xne necha uni xcalaꞌa rulaꞌ quieꞌ lu cuendaꞌlla.” ");
INSERT INTO zplNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero bee uleꞌya enu rnibiyaꞌ lubeelá bee uleꞌya cuna bee usticiaꞌ bee bene Israel uduꞌ beella arquiꞌ bee bene enu nucuaꞌa zeꞌe nú nacuꞌ beei lu Pilato nú laꞌalla Barrabás, nu ati Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Chequie uniaꞌla Pilato lubeei: ―¿Ta lu rucu beella niarquiꞌhua nú laꞌa che? Che uni bee bene zeꞌe lulla: ―Ulaꞌa Barrabás. ");
INSERT INTO zplNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nu uni Pilato lubeella: ―¿Nu xi riꞌinua Jesuse enu rni bee bene nú neca Cristo? Che uni ye beella: ―¡Uquieꞌe nucuaꞌ lu cruse! ");
INSERT INTO zplNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nu uni Pilato lubeella: ―Pero ¿xi nú necha neca uriꞌilla? Che stucuaꞌla urixialibeella nú uni beella: ―¡Uquieꞌe nucuaꞌ lu cruse! ");
INSERT INTO zplNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Chenu uriꞌi Pilato beyaꞌ nú lariaꞌlla ana tsulla lubee bene zeꞌe sino que maselá rixialibeei, che unibiyaꞌlla nú yeꞌtayu tucu bene inza, nu unalla ante lu ye bee bene zeꞌe, nú unilla: ―Lecaxi culpaa nú ati bene cuaꞌ, necatsia nucuaꞌ cuendaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Che uni ye bee bene zeꞌe lu Pilato: ―¡Neca nucuaꞌ culpaꞌru cuna bee lliꞌñiru, nú ati benecuaꞌ! ");
INSERT INTO zplNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chequie ulaꞌa Pilato Barrabás, nu chu unibiyaꞌlla nú zeteꞌcheꞌ bee sundado Jesuse, nu udeteꞌ cuendalla liꞌinu lubee sundado para nú quieꞌe beei liꞌinu lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Che unguyaꞌ bee sundado zeꞌe Jesuse liñi palacioꞌ gobernador, elu uyetesaꞌ ye beei lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Che ulua beei xucunu, nu ungutu beei liꞌinu tucu laquie neluu, ");
INSERT INTO zplNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","nu urecheꞌe beei tucu elluꞌñi nú necacheꞌ eche uzucuꞌ beei equienu, leꞌca uzucuꞌ beei tucu bara yanu chube. Che chu utsulliqui beei lunu nu xitse uriꞌchia beei liꞌinu nú unibeei lunu: ―¡Huañi arreꞌ bee bene Israel! ");
INSERT INTO zplNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nu leꞌca utsuxene beei lunu, nu mismo bara nú udeteꞌ beei yanu unguxi beei yanu uduꞌbeei equienu. ");
INSERT INTO zplNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chenu ulaxu nú xitse uriꞌinu beei liꞌinu, ulua zeca beei laquie neluu nú ungutu beei liꞌinu, nu ungutu zeca beei nú necaca xucunu liꞌinu. Che unguyaꞌ beei liꞌinu para nú quieꞌe beei liꞌinu lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Chenu nzenu beei Jesuse nú quienu lu cruse ullaꞌca beei tucu bene eyeche Cirene, enu lee Simón, che unibiyaꞌ bee sundado zeꞌe lulla nú uyaꞌlla cruseꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nu chenu uriña beei tucu luhuare nú lee Gólgota, nu rni nucuaꞌ Lluca equie bene nguti. ");
INSERT INTO zplNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Zeꞌe udeteꞌ beei biñu nú nucha inza nú nelá güeꞌnu, pero chenu utiꞌñiaꞌnue, né zelanu agüeꞌnue. ");
INSERT INTO zplNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chenu ulaxu nú uquieꞌe bee sundado zeꞌe Jesuse lu cruse, urita beei tucu rifa equie xucunu para nú ritsiꞌbeei xucunu lu saꞌbeei. Scua uyalu tucu nú uquieꞌe tucu profeta lu ichiꞌ Stichiaꞌ Diose elu rni: “Ita bee sundado tucu rifa equie xucua biꞌya ta beei riꞌi anae.” ");
INSERT INTO zplNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Che chu ucuaꞌa beei zeꞌe para nú riꞌiucu beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nu equie cruseꞌnu uquieꞌe beei tucu letrero nú rni xinu uquieꞌe beei liꞌinu lu cruse. Nu letrero zeꞌe rni: “Neca ninguieꞌ Jesuse arreꞌ bee bene Israel.” ");
INSERT INTO zplNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Leꞌca uquieꞌe bee sundado zeꞌe chiucu huanaꞌ lu tucua cruse, tucu nzeꞌe cueꞌtsenu chube nu stucu nzeꞌe cueꞌtsenu chubeca. ");
INSERT INTO zplNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nu bee bene enu udete lunu zeꞌe, uriꞌqui equie beei nu rnibeei bee bedichiaꞌ nú necha neca lunu, ");
INSERT INTO zplNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nu rnibeei lunu: ―Manú unilu nú chilalu indu llene Jerusalén nulu chunatsia bichia recheꞌ zecalue, utsilaꞌa liꞌilu nee. Tunu neliꞌilu nú necalu lliꞌñi Diose, ulaca lu cruse cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Leꞌca scua bee uleꞌya enu rnibiyaꞌ lubeelá bee uleꞌya cuna bee ulaxcuela enu reca ley, cuna bee fariseo nu cuna bee usticia Israel, uni beella huaxi bee bedichiaꞌ nú necha neca lunu, nu unibeella lusaꞌbeella: ");
INSERT INTO zplNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Utsilaꞌa nucuaꞌ bee bene, pero laca nucuaꞌ tsilaꞌa nucuaꞌ liꞌi nucuaꞌ. Tunu neca nucuaꞌ arreꞌ bee bene Israel, chu laca nucuaꞌ lu cruse nu che chili arquiaꞌahua nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nzelí arquiꞌ nucuaꞌ Diose, nee tsilaꞌa Diose nucuaꞌ tunu secanu nucuaꞌ, xne rni nucuaꞌ nú neca nucuaꞌ lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nu hasta bee huanaꞌ enu nequie lu stucu cruse cueꞌtsenu unibeei bee bedichiaꞌ nú necha neca lunu. ");
INSERT INTO zplNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chenu unga rrebichia ucabelí diquineca lu iliulabe, hasta rquie chuna uche. ");
INSERT INTO zplNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nu rquie chuna uche zeꞌe, urixiali Jesuse nu uninu: ―Elí, Elí, ¿lama sabactani?, rni bedichiaꞌ cuaꞌ: Diosea, Diosea, ¿xinu utsanaꞌ arquiꞌlu liꞌá? ");
INSERT INTO zplNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chenu ubeneꞌ bee bene enu nucuaꞌa zeꞌe nú uninu scua, che unibeei lusaꞌbeei: ―Aꞌa rixialla profeta Elías. ");
INSERT INTO zplNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Che chu uyaxuꞌu tucu beei nu ucuacha nzeꞌe tucu esponja lu inza vinagre, nu uzucuꞌi lliꞌi tucu ixiꞌ, nu utiꞌi esponja cuaꞌ ruꞌu Jesuse para nú güeꞌnu inza vinagre cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero texcuaꞌa beei enu nucuaꞌa zeꞌe uni: ―La riꞌinululla scua biꞌya se nzeꞌta Elías tsilaꞌa liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Che juerte urixiali Jesuse stucu bese, nu chu ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Chequie hora zeꞌe utsa cortina llene nú nziꞌquinala liñi indu llene Jerusalén, nu utsa arliꞌtillune hasta aya nu hasta aquié. Nu unga xuú lu iliulabe nu uleꞌe bee quielaa, ");
INSERT INTO zplNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","nu uyaꞌla bee eluhua nu uhuañi zeca huaxi bee bene enu nzeli arquiꞌ Diose, bee enu unguti. ");
INSERT INTO zplNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Che uchiuꞌu beella liñi eluhua lulá nú uhuañi Jesuse, nu uyuꞌu beella Jerusalén. Nu zeꞌe ulañiꞌ huaxi bee bene liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Che capitán cuna beelá bee sundaduꞌlla enu rriucu Jesuse, chenu ulañiꞌ beella nú reca xú nu cuna ye beenú reca, chiquiꞌ ulliqui beella nu unibeella lusaꞌ beella: ―¡Neli nú neca benequieꞌ Lliꞌñi Diose! ");
INSERT INTO zplNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nu huaxi bee unaꞌa enu uyaquie Jesuse desde Galilea enu uriꞌi elietsa lunu nucuaꞌa beenchu istu zeꞌe riꞌya beenchu lunú reca. ");
INSERT INTO zplNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Leta bee unaꞌa quieꞌ nzu María Magdalena, cuna María naꞌ Jacobo nu José, nu cuna naꞌ bee llianaꞌ Zebedeo. ");
INSERT INTO zplNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Chenu uyuꞌu rulaꞌ, uriña tucu bene xene enu lee José, necalla bene eyeche Arimatea, nu leꞌca uyanzenulla Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nu uyalla lu Pilato uyanaꞌculla cuerpoꞌ Jesuse. Che unibiyaꞌ Pilato nú deteꞌ cuenda bee sundado cuerpoꞌ Jesuse lulla, ");
INSERT INTO zplNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","nu chu unaꞌtsella cuerpoꞌ Jesuse nu utelallanu tucu sábana nú lecaxi naa ");
INSERT INTO zplNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nu che uya caꞌchiꞌlla cuerpoꞌ Jesuse liñi tucu eluhua cuqui nú neca steneꞌlla, nú udaꞌñilla liñi tucu quielaa, nu utsacuꞌlla tucu quiee llene ruꞌu eluhua zeꞌe nu chu nzialla. ");
INSERT INTO zplNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ruꞌu eluhua zeꞌe nzucu María enu neca bene eyeche Magdalena cuna stucu María. ");
INSERT INTO zplNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chenu uyeꞌe lu yuu bichia nú sulachi bee bene uya bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee fariseo lu Pilato, ");
INSERT INTO zplNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nu uni beella lu Pilato: ―Detá, nchiucuꞌ arquiꞌru nú chenu nehuañiscaꞌ bene enu nequichiaꞌ cuaꞌ, uni nucuaꞌ nú detetsia chuna bichia huañizeca nucuaꞌ lu eluti. ");
INSERT INTO zplNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Enzeꞌe unibiyaꞌ nú aca ucu ruꞌu eluhua cuaꞌ hasta nú zaꞌ chuna bichia para nú la cha bee beneꞌ nucuaꞌ rulaꞌ che cachiꞌ cuerpoꞌ nucuaꞌ, nu ni bee beneꞌ nucuaꞌ lubee bene nú uhuañi zeca nucuaꞌ stucu bese. Xne tunu riꞌi bee beneꞌ nucuaꞌ scua che masescaꞌlá aca llene eluquichiaꞌ cuaꞌ luquelá eluquichiaꞌ nú uni nucuaꞌ rluti. ");
INSERT INTO zplNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Che chu uni Pilato lubeella: ―Nucuaꞌacua bee sundado. Para nú riꞌi ucue. Uyaꞌhua beei nu utsaꞌcutaꞌhua ruꞌu eluhua zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Che nzuebeella, nu utsacuꞌtaꞌ beella ruꞌu eluhua zeꞌe, nu chu utsaꞌna beella bee sundado rriucue. ");
INSERT INTO zplNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chenu udete bichia nú sulachi bee bene, nu chenu uyeꞌe lu yuu zilaꞌ domingo. Che uyabiꞌya María Magdalena cuna stucu María ruꞌu eluhuaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Che tuꞌnatsia unga tucu xú nú juerte, xne ulaca tucu ángeleꞌ Diose enza liñibe nu uyabica ángele zeꞌe ruꞌu eluhua nu uyucunu quiee nú nacuꞌ ruꞌu eluhua zeꞌe, nu uzucunu equiee, ");
INSERT INTO zplNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","nu rulu siquiꞌ ángele zeꞌe xi rulusiquiꞌ lee chenu riaꞌlane, nu xucunu niquichiu aꞌquieꞌe xi nequichi iqui. ");
INSERT INTO zplNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chenu ulañiꞌ bee sundado enu rriucu ruꞌu eluhua zeꞌe ángele cuaꞌ, chiquiꞌ unga tseꞌtseꞌ beei nú ulliqui beei, nu uzanaꞌ beei lu yuu xi uzanaꞌ benenguti. ");
INSERT INTO zplNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Che uni ángele cuaꞌ lubee unaꞌa cuaꞌ: ―La lliquihua. Liꞌá nediyaa nú rlaꞌnahua Jesuse, enu uquie lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pero lecaꞌnu caꞌa, xne uhuañi zecanu lu eluti tucu nú uninu. Utebiꞌyacuruhua elu uricu cuerpoꞌnu ne lañiꞌhua, ");
INSERT INTO zplNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","nu nee chu uquia tixiuleꞌexuhua lubee beneꞌnu: “Nú uhuañi zecanu lu eluti, nu rlutilánu nzanu lu iliu Galilea, luquela liꞌihua nu zeꞌe lañiꞌhuanu.” Nucuaꞌtsia neca nú rixiuleꞌa luhua. ");
INSERT INTO zplNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chequie uchiuꞌu beella ruꞌu eluhua zeꞌe, nu xexuꞌu beella nzuella nzetixiuleꞌe beella lubee beneꞌnu. Diquitse xiqui beella nu leꞌca ñia nzu arquiꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Chenu nzuebeella ulubeꞌlu Jesuse lubeella inziu nu uninu lubeella. Che uyabica beella lunu nu uluꞌcu beella ulaꞌna lunu, nu uchiꞌchi beella cuchiuꞌnu, ");
INSERT INTO zplNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","nu uninu lubeella: ―La lliquihua. Uquia tixiuleꞌehua lubee benea nú cha beella lu iliu Galilea, nu zeꞌe lañiꞌ beella liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Diquila nú nzubee bee unaꞌa zeꞌe, leꞌca nzubee chiucu chuna bee sundado eyeche zeꞌe nzetixiuleꞌe beei lubee uleꞌya enu rnibiyaꞌ lubeelá bee uleꞌya luye nú unga. ");
INSERT INTO zplNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Che bee uleꞌya enu rnibiyaꞌ cuaꞌ uyabedichiaꞌnu beei bee usticiaꞌ bee bene Israel para nú tucu ricucheꞌtse stichiaꞌ beella, nú xi riꞌi beella nu che udeteꞌ beella huaxi dimi ya bee sundado, ");
INSERT INTO zplNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nu uni beella lubee sundado zeꞌe: ―Uniꞌtsiahua nú rulaꞌ chenu raꞌtsehua ubeꞌta bee beneꞌ Jesuse ucachiꞌ cuerpoꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Che tunu acabiyaꞌ gobernador nucuaꞌ, liꞌicaru niru lulla para nú lecaxi riꞌinulla liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Che unaꞌtse bee sundado dimi, nu uriꞌi beei tucu nú unibeella lubeei nú riꞌi beei. Nu eluquichiaꞌ cuaꞌ nzeli arquiꞌ bee bene Israel hasta bichia quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Che nzubee ye chetuꞌcu bee beneꞌ Jesuse lu iliu Galilea, equie dañi elu unilanu lubeella nú chue beella. ");
INSERT INTO zplNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nu chenu ulañiꞌ beella Jesuse uluꞌcu beella ulaꞌna lunu, añinzuca nú nuꞌ beella la chili arquiꞌ nú necanu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Che uyabica Jesuse lubeella nu uninu lubeella: ―Uliquiꞌ Diose ye poder lua para nú nibiyaꞌa liñibe cuna luyuu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Enzeꞌe uquiahua diqui lu iliulabe uzeꞌteꞌhua bee bene stichiaꞌa para nú aca beei bee benea. Nu urinzahua beei equie nú lee Pa liñibe, cuna equie cuendaꞌ lliꞌñinu nu cuna equie cuendaꞌ Espíritu Santo, ");
INSERT INTO zplNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","nu uzeꞌteꞌhua bee bene nú zucuꞌ beei ye nú unilaa luhua. Nu nia luhua nú ye bee bichia nzua cuna liꞌihua, hasta chenu laxu iliulabe. Amén.");
INSERT INTO zplNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Singuie uquixie bedichiaꞌ nzeꞌcaꞌ Jesucristo, Lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Huaꞌtu uhuañi tucu profeta enu lee Isaías enu uquieꞌe lunú uni Diose, nu uni Diose: Xeꞌlaa tucu benea cha rluti lulu, para nú tsu tsiñialla bee bene nú zucuꞌ bee bene stichiaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lu tucu dañi achi elu la nucuaꞌa bee bene yeneꞌ bee bene chi benequieꞌ nú nilla: “Utsu tsiñahua arquiꞌhua xne nzeꞌta liꞌinu enu neca Dioseꞌahua. Utsanaꞌ arquiꞌhua stulahua para nú yucu arquiꞌhua stichiaꞌnu.” ");
INSERT INTO zplNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Uzaꞌ bee bedichiaꞌ quieꞌ chenu ubeꞌta Juan urinzalla bee bene unga nucuaꞌ lu tucu dañi achi elu la nucuaꞌa bee bene, nu unilla: ―Ucheꞌehua arquiꞌhua lu stulahua nu uzuꞌcuꞌhua nú rni Diose, para nú riꞌi Diose perdona liꞌihua che rinzahua. ");
INSERT INTO zplNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Chequie uchiuꞌu huaxi bee bene lubee iliu Judea cuna bee bene eyeche llene Jerusalén uriñabeei lu Juan para nú yeneꞌbeei nú rnilla. Che uxucuꞌdulabeei stulabeei nu urinza Juan liꞌibeei reꞌcu Jordán. ");
INSERT INTO zplNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Xucu Juan necacheꞌ ichiatsuꞌ camello nu sinchiu nú riuꞌu xlaꞌculla necacheꞌ iti, nu elubacu nú udaculla neca xeꞌchiu cuna lliña dañi. ");
INSERT INTO zplNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Udixiuleꞌella lubee bene zeꞌe nú unilla: ―La leꞌe nú nzeꞌta tucu bene enu chiquiꞌ nibiyaꞌ luquela liꞌá, niꞌ nú hua lucunu la yala xne neca equielánu lua. ");
INSERT INTO zplNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Liꞌá rrinza liꞌihua cuna inza, pero liꞌinu rinzanu liꞌihua cuna Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Bee bichia zeꞌe uchiuꞌu Jesuse eyeche Nazaret nú nchiucuꞌ lu iliu Galilea. Che uriñanu lu Juan nu urinza Juan liꞌinu reꞌcu Jordán. ");
INSERT INTO zplNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Chenu uchiuꞌu Jesuse lu inza, ulañiꞌnu nú uyaꞌla liñibe nu nzeꞌta laca Espíritu Santo equienu. Xi neca tucu paloma. ");
INSERT INTO zplNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nu uyene tucu chii enza liñibe nu uni chii zeꞌe: ―Liꞌilu necalu lliꞌñia nu chiquiꞌ seꞌca liꞌilu nu ñia nzu arquia lulu. ");
INSERT INTO zplNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Cheelá uriꞌi Espíritu Santo nú nza Jesuse lu tucu dañi achi elu la nucuaꞌa bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Zeꞌe uyaꞌnanu chiuꞌa bichia si rulaꞌ elu nucuaꞌa bee nañi dañi, che uriꞌi bezeꞌlu preu liꞌinu para nú la zucuꞌnu nú rni Diose. Pero né riꞌi bezeꞌlu ana lunu cheelá uriña bee ángeleꞌ Diose lunu nu uzibiꞌ bee ángele zeꞌe lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chenu netse Juan niꞌcuꞌ uya Jesuse lubee eyeche lu iliu Galilea, nu udixiuleꞌenu bedichiaꞌ nzeꞌca lubee bene nú xa neca lunú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Singuie uninu lubee bene zeꞌe: ―Uriñala bichia nú ucuaqui uꞌna Diose huaꞌtu. La acaxeaꞌ nú enta nú nibiyaꞌ Diose lu iliulabe quieꞌ. Enzeꞌe utsanaꞌ arquiꞌhua stulahua nu uchili arquiꞌhua bedichiaꞌ nzeꞌcaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Chenu udete Jesuse ruꞌu inzatuꞌ Galilea ulañiꞌnu Simón cuna bichii Andrés nú siꞌqui beei ixiu nú rucu bela lu inzatuꞌ zeꞌe xne neca beei enu rucu bela. ");
INSERT INTO zplNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chequie uninu lubeei: ―Utequiehua liꞌá para nú zeteahua nú nihua lubee bene para nú aca beei benea luhuare nú rucuhua bee bela. ");
INSERT INTO zplNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hora zeꞌe utsaꞌna beei ixiu nú rucu bela nu chu nzequie beei liꞌinu che. ");
INSERT INTO zplNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Lleꞌnatsia enza lu zeꞌe ulañiꞌ Jesuse Jacobo cuna Juan neca beei llianaꞌ tucu bene enu lee Zebedeo. Nucuaꞌa beei liñi barcoꞌ beei rquielaꞌ beei ixiu nú rucu bela. ");
INSERT INTO zplNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nu ubixia Jesuse liꞌibeei, che utsaꞌna beei paꞌ beei cuna bee mozoꞌ beei liñi barco nu chu nzuebeei cuna liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chenu uriña beella cuna Jesuse eyeche Capernaum. Bichia nú sulachi bee bene Israel, uyuꞌunu liñi induꞌ beella nu uquixienu uzeteꞌnu bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Chiquiꞌ nzenu arquiꞌ bee bene zeꞌe lunú seteꞌnu xne seteꞌnu bee bene xi neca tucu bene enu chiquiꞌ rnibiyaꞌ nu bee ulaxcuela enu reca leyꞌ Moisés la zeteꞌ beei scua. ");
INSERT INTO zplNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Liñi indu zeꞌe nzucu tucu niyu enu nchiñi benechiquiꞌ arquiꞌ, nu rixiali niyu zeꞌe nú rni: ");
INSERT INTO zplNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Xinu rriꞌchialu liꞌiru Jesuse bene eyeche Nazaret? ¿Uriñalu para nú nitilulu liꞌiru la? Nuꞌlua liꞌilu nú necalu beneꞌ Diose nu la luꞌculu dula. ");
INSERT INTO zplNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Chequie uriꞌinu nú uquiꞌyaꞌ benechiquiꞌ nu uninu: ―¡Uzaca nu uchiuꞌu arquiꞌ niyu quieꞌ! ");
INSERT INTO zplNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Che utsiꞌqui benechiquiꞌ niyu zeꞌe lu yuu, nu uriꞌi ichia ziñia lu niyu zeꞌe. Nu chiquiꞌ juerte rixialii nu chu uchiuꞌi arquiꞌ niyu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Che ye bee bene enu nucuaꞌa zeꞌe uyanu arquiꞌbeei nú unibeei lu saꞌbeei: ―¿Xi nucuaꞌ? Nú, ¡necheꞌe seteꞌ nucuaꞌ liaꞌahua chiquiꞌ rnibiyaꞌ nucuaꞌ hasta bee benechiquiꞌ sucuꞌ nú rni nucuaꞌ! ");
INSERT INTO zplNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Scua yexetsia uriꞌchia bedichiaꞌ diqui lu iliu Galilea lunú uriꞌi Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chequie chenu uchiuꞌu beella liñi indu zeꞌe. Nzenu Jesuse, Jacobo cuna Juan niꞌ Simón cuna Andrés. ");
INSERT INTO zplNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Zeꞌe nuxu suegraꞌ Simón nu secalla xlee. Chequie chenu uriña Jesuse zeꞌe, udixiuleꞌe beei lunu nú ritilla. ");
INSERT INTO zplNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Chequie uyabicanu elu nuxulla nu unaꞌtsenu yalla nu uletsanu liꞌilla. Hora zeꞌe uchiuꞌu xlee nú secalla. Che udeteꞌlla nú udacu beella. ");
INSERT INTO zplNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chenu uhuatseꞌ bichia nu enta chuꞌu rulaꞌ. Uquixie bee bene nú uriñayu beei ye bee bene enu riti cuna bee bene enu nchiñi benechiquiꞌ arquiꞌ lu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Uyetesaꞌ ye bee bene eyeche zeꞌe ruꞌu niꞌi elu nzucunu. ");
INSERT INTO zplNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Uriꞌiyeca Jesuse bee bene enu riti ye luu bee elichia nú seca beei, cuna nú uhuanu bee benechiquiꞌ arquiꞌ bee bene. Pero né zelanu nú ani bee benechiquiꞌ, xne nuꞌlu beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chenu lá yeꞌe lu yuu nu necabescaꞌ nzu uzetee Jesuse nu uchiuꞌunu eyeche zeꞌe nu nzanu tucu luhuare elu lecalí ti nuꞌ para nú nacuꞌnu lu Diose zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Chequie uya Simón cuna beelá bee bene enu neyeteꞌi nu uyacuaꞌna beei Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Chenu ullelaꞌ beei liꞌinu, unibeei lunu: ―Huaxi bee bene rcuaꞌna liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Che uninu lubeei: ―Chaꞌahua lubee eyeche axu caꞌa para nú leꞌca ixiuleꞌa Stichiaꞌ Diose lubee bene cuaꞌ xne enzeꞌe uriña. ");
INSERT INTO zplNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Che udixiuleꞌenu Stichiaꞌ Diose lubee bene liñi bee induꞌ bee bene Israel diqui lu iliu Galilea. Nu uhuanu benechiquiꞌ arquiꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tucu bichia uriña tucu niyu enu seca elichia nú lee lepra lu Jesuse nu utsu lliquii lunu nu uni: ―Tunu laca arquiꞌlu nuꞌ beyaꞌ nú riꞌiyecalu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Chequie chiquiꞌ uhuaꞌa arquiꞌ Jesuse niyu zeꞌe nu uricuꞌnu yanu equiei nu uninu: ―Niarquia nú yecaꞌlu, uyecaꞌ nee. ");
INSERT INTO zplNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chenu uninu scua, hora zeꞌe uyecaꞌi elichia nú secai nu lecaꞌ xi nai. ");
INSERT INTO zplNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Che uduꞌ nziunu liꞌi nu uninu lui: ");
INSERT INTO zplNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Nia lulu nú la ixiuleꞌelu nucuaꞌ lu niꞌ tucu bee bene nú xa uyecaꞌlu. Lu uleꞌyatsia uquiatixiuleꞌe nú uyecaꞌlaꞌlu. Che deteꞌlu tucu uꞌna lu Diose tucu nú unibiyaꞌ Moisés, para nú riꞌi bee bene beyaꞌ nú uyecaꞌlaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero chenu nzia niyu zeꞌe, né tsacuꞌ arquiꞌi. Aꞌla mase udixiuleꞌi lu titse bee bene nú xa uriꞌiyeca Jesuse liꞌi. Enzeꞌe leca modo nú achuꞌu Jesuse lu niꞌ tucu bee eyeche zeꞌe. Enzeꞌe enzetsianu dañi elu lecaꞌ niꞌi bee bene. Pero uyascaꞌ huaxi bee bene bee eyeche diqui abenchilaꞌ zeꞌe elu nzucunu. ");
INSERT INTO zplNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Xiucu xuna bichia lu zeꞌe, uyuꞌu zeca Jesuse eyeche Capernaum nu ungabiyaꞌ bee bene zeꞌe nú nzucunu tucu niꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Che yexetsia uyetesaꞌ huaxi bee bene ruꞌu niꞌi elu nzucunu zeꞌe, nu uchee liñi niꞌi zeꞌe, niꞌ ruꞌu puerta la acaꞌ riña beelá bee bene, nu udixiuleꞌenu Stichiaꞌ Diose lubee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Zeꞌe uriñayuu tacu bene enu nuyaꞌ tucu niyu enu neati cuerpoꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero né riꞌi beei ana nú a riña beei hasta lu Jesuse, xne nucuaꞌa huaxi bee bene liñi niꞌi zeꞌe. Enzeꞌe uxaꞌla beei equie niꞌi zeꞌe, nu cuna camilla ulaca beei niyu enu riti zeꞌe hasta elu nzu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chenu ulañiꞌ Jesuse nú nzeli arquiꞌbeei liꞌinu, che uninu lu niyu enu riti zeꞌe nu uninu: ―Niyu uriꞌá perdona stulalu nee. ");
INSERT INTO zplNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pero zeꞌe nucuaꞌa bee ulaxcuela enu reca leyꞌ Moisés nu uriꞌi beei elliebacuꞌ nú unibeei: ");
INSERT INTO zplNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ti neca nucuaꞌ? Nú rni nucuaꞌ tucu nú neca nucuaꞌ Diose. Xne tucutsia Diose rriꞌi perdona xtula bee bene.” ");
INSERT INTO zplNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero hora zeꞌe uriꞌi Jesuse beyaꞌ lunú rriꞌi beei elliebacuꞌ. Enzeꞌe uninu lubeei: ―¿Xinu uriꞌihua ellibacuꞌ scua? ");
INSERT INTO zplNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ta nú mase neriñaꞌ nú aca nú nia lulla: “Uriꞌá perdona xtulalu”, urre nia lulla: “Uzetee, nu unaꞌtse camiyaꞌlu nu uquiaꞌa”? ");
INSERT INTO zplNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero nee lubea luhua nú liꞌá Bene enu uxeꞌla Diose rluꞌcua nú rnibiyaꞌa lu iliulabe, para nú riꞌá perdona stula bee bene. Uni Jesuse lu niyu enu riti zeꞌe: ");
INSERT INTO zplNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Nia lulu nú uzetee nu unaꞌtse camiyaꞌlu nu uquiaꞌa niꞌlu nee. ");
INSERT INTO zplNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hora zeꞌe uyecaꞌ niyu zeꞌe nu unaꞌtsei camillaꞌi nu chu uchiuꞌi liñi niꞌi zeꞌe. Ulañiꞌ ye bee bene enu nucuaꞌa zeꞌe nucuaꞌ nu unibeei bedichiaꞌ nzeꞌca lu Diose. Nu chiquiꞌ uyanu arquiꞌ ye bee benecuaꞌ lunú ulañiꞌ beei nu unibeei. ―Lascaꞌ lañiaꞌhua niꞌ tucu bese lunú ulañiaꞌhua nee. ");
INSERT INTO zplNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Cheelá nza zeca Jesuse ruꞌu inzatuꞌ Galilea. Zeꞌe uyetesaꞌ huaxi bee bene lunu nu uzeteꞌnu liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chenu udetenu zeꞌe, ulañiꞌnu Leví necai llianaꞌ tucu bene enu lee Alfeo. Leví quieꞌ nzucui elu rriꞌi cubre equie bee impuestos lubee bene nu uninu lui: ―Ute quie liꞌá. Nu chu utsuli Leví nu nzai cuna liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chenu nzucu Jesuse lu mexa liñi niꞌi Leví, cuna bee beneꞌnu udacununu huaxi bee bene enu rriꞌi cubre equie bee impuestos cuna bee bene enu la nehuañi tucu nú rnibiyaꞌ leyꞌ Moisés, xne nzequie huaxi bee bene cuaꞌ liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chequie nucuaꞌa chiucu chuna ulaxcuela enu reca leyꞌ Moisés cuna bee fariseo enu ulañiꞌ nú racunuu Jesuse bee benecuaꞌ. Che unibeei lubee beneꞌnu: ―¿Xinu racunuu maestroꞌhua cuna bee bene enu rriꞌi cubre equie bee impuesto? ¿Cuna bee bene enu la nehuañi tucu nú rnibiyaꞌ leyꞌ Moisés? ");
INSERT INTO zplNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chenu ubeneꞌ Jesuse nucuaꞌ, uninu lubee bene cuaꞌ: ―Bee bene enu la aca riti, la zecalaꞌchaꞌ bee nzeꞌe tucu doctor. Pero bee bene enu riti, rquiꞌña bee nzeꞌe tucu doctor. Enzeꞌe nzela nee, para nú bixia bee bene nú cheꞌe arquiꞌbeei lu dula nú rluꞌcu beei. Lá yela lubee bene enu rriꞌi elliebacuꞌ nú la luꞌcu dula. ");
INSERT INTO zplNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tucu bichia udeteꞌ bee beneꞌ Juan Bautista cuna bee fariseo bichia nú né acu beella equie nú rluꞌcu beella ulaꞌna lu Diose, nu uriña chiucu chuna bee bene lu Jesuse nu unibeei lunu: ―Udeteꞌ bee beneꞌ Juan cuna bee fariseo bichia nú né acu beella equie nú rluꞌcu beella ulaꞌna lu Diose. ¿Xiquie nú la riꞌi bee beneꞌlu scua? ");
INSERT INTO zplNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chequie ucuaqui Jesuse lubee bene zeꞌe nú uninu: ―¿Xieꞌ la acu bee bene enu nezeneꞌ lu tucu tsaꞌa chenu xia tucu bene chenu nzucuscaꞌ bene enu xia zeꞌe la? Lunú nzuscaꞌ bene enu xia zeꞌe. Enzeꞌe rquiꞌña nú acu bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero riña bichia chenu la nzuaꞌ bene enu xia cuna bee bene. Che si deteꞌ beella bichia nú la acu beella equie nú rluꞌcu beella ulaꞌna lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Lecati quielaꞌ tucu laquie uxu cuna teleꞌe laquie cuqui xne chenu uxuꞌ laquie cuqui riꞌi nú tsaa laquie uxu. ");
INSERT INTO zplNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Leꞌca la chuꞌu biñu cuqui liñi iti uxu xne riꞌi biñu cuqui cuaꞌ nú tsaa iti uxu, che nitilu biñu cuaꞌa cuna iti uxu. Enzeꞌe rquiꞌña nú chuꞌu biñu cuqui liñi iti cuqui. ");
INSERT INTO zplNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tucu bichia nú sulachi bee bene, udetenu Jesuse bee beneꞌnu lu yuu elu nuꞌ trigo nu uquixie bee beneꞌnu unguxi beella tuu lu trigo. ");
INSERT INTO zplNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chequie unibee fariseo lu Jesuse: ―Biꞌyacuru, ¿xiquie nú rriꞌi bee beneꞌlu lunú la yala riꞌi beella bichia nú sulachi bee bene? ");
INSERT INTO zplNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero uni Jesuse lubeei: ―¿Xieꞌ lascaꞌ ulahua elu rni nú xa uriꞌi David cuna bee bene enu nuulla tucu bese chenu uliaꞌnaꞌ beella la? ");
INSERT INTO zplNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tiembu nú unga Abiatar uleꞌya, enu rnibiyaꞌ lubee uleꞌya uyuꞌu David liñi induꞌ Diose nu udaculla pá nú necaleꞌya lu Diose. Añinzuca nú uleꞌyatsia nuꞌ modo nú acu pá cuaꞌ. Pero udeteꞌlla pácuaꞌ udacu bee bene enu nuulla. ");
INSERT INTO zplNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","’Urecheꞌ Diose bichia nú sulachi bee bene, pero lá recheꞌenu bichia cuaꞌ para nú nehuana zeca bee bene bichia cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","’Liꞌá Bene enu uxeꞌla Diose leꞌca rluꞌcua nú rnibiyaꞌa lu bichia nú sulachi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Stucu bese chenu uyuꞌu Jesuse liñi tucu induꞌ bee bene Israel. Zeꞌe nzucu tucu niyu enu ubichicuꞌ tucu chú ya. ");
INSERT INTO zplNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Chequie bee bene enu nucuaꞌa zeꞌe. Nucuaꞌa tsiꞌña beei tunu riꞌiyeca Jesuse niyu zeꞌe bichia nú sulachi beei, para nú scua xana bitsi beei lu cuendaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Che uni Jesuse lu niyu enu ubichicuꞌ ya zeꞌe, nu uninu: ―Utsuli lubee bene cuaꞌ nee. ");
INSERT INTO zplNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nu uninu lubee bene zeꞌe: ―¿Xi riala riꞌi bee bene bichia nú sulachi bee bene? ¿Nú neca nzeꞌca la urre nú necha neca la? ¿Tsilaꞌa bene nú la ati tucu bene la, urre tsanaꞌ arquiꞌ bene nú ati tucu bene la? Pero lecaxi ucuaqui bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Chequie ubiꞌyanu lubee bene zeꞌe nu chiquiꞌ uleenu cuna nú chiquiꞌ nehuana utsu arquiꞌnu xne la huaꞌa arquiꞌbeei bee bene, nu uninu lu niyu enu ubichicuꞌ ya zeꞌe: ―Ulí yalu nee. Nu chu ulí niyu zeꞌe yai nu hora zeꞌe uyecaꞌ yai. ");
INSERT INTO zplNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pero chenu uchiuꞌu bee fariseo zeꞌe, uyete saꞌ beei cuna bee beneꞌ Herodes nu uriꞌi beei elliebacuꞌ xneca riꞌi beei para nú uti beei Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Chequie chu nza Jesuse cuna bee beneꞌnu ruꞌu inzatuꞌ Galilea, nu nzequie huaxi bee bene liꞌinu, bee bene Galilea cuna bee bene Judea, ");
INSERT INTO zplNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","cuna bee bene Jerusalén, cuna bee bene Idumea, cuna bee bene enu nucuaꞌa stucu chú reꞌcu Jordán, cuna bee bene enu nucuaꞌa lu iliu Tiro, cuna bee bene enu nucuaꞌa lu iliu Sidón, uya huaxi bee benequieꞌ lunu, xne unga biyaꞌbeei nú rriꞌinu bee milagro nú chiquiꞌ neca equie. ");
INSERT INTO zplNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Enzeꞌe uninu lubee beneꞌnu, nú tsu tsiña beella tucu barco para nú chuꞌunu liñi barco zeꞌe, para nú la taꞌcu bee bene liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Xne uriꞌiyecanu huaxi bee bene. Enzeꞌe ye bee bene enu riti uricuya beei lunu, para nú tiꞌ beei ya beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Chequie bee bene enu nchiñi benechiquiꞌ arquiꞌ chenu ulañiꞌ beei Jesuse, utsulliqui beei lunu nu urixialibeei nú unibeei: ―¡Necalu Lliꞌñi Diose! ");
INSERT INTO zplNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero unibiyaꞌ Jesuse lubee benechiquiꞌ nú la ixiuleꞌe beei nú ti necanu lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Cheelá uquie Jesuse equie tucu dañi, nu ubixianu bee bene enu niarquiꞌnu nú cha cuna liꞌinu nu uyabica bee benequieꞌ lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Che ucañinu leta bee bene zeꞌe, chiꞌchiucu bene para nú chenu bee benequieꞌ liꞌinu, cuna nú xeꞌlanu liꞌibeella para nú chetixiuleꞌe beella Stichiaꞌ Diose lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Udeteꞌnu nú rnibiyaꞌnu lubeella para nú riꞌiyeca beella bee bene enu riti cuna nú lua beella benechiquiꞌ arquiꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bee ningiueꞌ neca chiꞌchiucu bee bene enu ucañi Jesuse tuculla lee Simón enu leꞌca uhualenu, Pedro. ");
INSERT INTO zplNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Stuculla lee Jacobo, nu stuculla lee Juan, neca rucu benequieꞌ llianaꞌ bene enu lee Zebedeo. Uhualee Jesuse rucu llianaꞌ Zebedeo, Boanerges, nu rni nucuaꞌ bee lliꞌñi beziyuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Leꞌca ucañi Jesuse Andrés, Felipe, Bartolomé, Mateo, Tomás, Tadeo, Simón, enu ulletse leta tucu partido nú lee cananista, ");
INSERT INTO zplNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","cuna Judas Iscariote enu udeteꞌ cuenda Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chenu ulaxu nú ucañinu chiꞌchiucu bee benecuaꞌ uriñayunu liꞌibeella ruꞌu tucu niꞌi, ruꞌu niꞌi zeꞌe stucuaꞌla bese uyetesaꞌ huaxi bee bene lubeella. Hasta nú né lluꞌchaꞌnu acununu cuna bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chenu ungabiyaꞌ bee saꞌa Jesuse nú reca zeꞌe. Nzetucu beella liꞌinu leta bee bene zeꞌe, xne rni bee bene nú secanu ichia loco. ");
INSERT INTO zplNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pero bee ulaxcuela enu reca leyꞌ Moisés, nzeꞌta beei enza Jerusalén nu unibeei lusaꞌbeei: ―Benequieꞌ rlua benechiquiꞌ arquiꞌ bee bene cuna poder nú rluꞌcu bezeꞌlu enu rnibiyaꞌ lubee benechiquiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Che ubixia Jesuse liꞌibeei nu uninu lubeei: ―¿Xa modo nú hua bezeꞌlu leꞌca saꞌ bee bezeꞌlu? ");
INSERT INTO zplNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tucu ubiernu enu rleꞌe saꞌa siempre rliunu saꞌa beei nu tunu rliunu saꞌbeei, laxu nú rnibiyaꞌ ubiernu quieꞌ che. ");
INSERT INTO zplNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Leꞌca esquie bee bene tucu niꞌi tunu liunu saꞌa beella laxu bee bene quieꞌ che. ");
INSERT INTO zplNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Leꞌca esquie tunu tiliacaꞌ bezeꞌlu leꞌca saꞌ bezeꞌlu ulaxu nú rnibiyaꞌ bezeꞌlu che. ");
INSERT INTO zplNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Nu lecati aca chuꞌu niꞌ tucu bene enu naaqui para nú cachiꞌ beei steneꞌlla, tunu la llicaꞌcuxu beei liꞌilla. Scua si riꞌi beei ana nú cachiꞌ beei steneꞌlla che. ");
INSERT INTO zplNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ixiuleꞌa luhua nú ye bee dula nú rriꞌi bee bene, nuꞌ perdonaꞌ bee dula cuaꞌ. Leꞌca nuꞌ perdonaꞌ ye bee bedichiaꞌ chiꞌquiꞌ nú rni bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero tatse bee bene enu nichiꞌquiꞌ lu Espíritu Santo, lecaꞌ perdona para bee benecuaꞌ. Nzuquietsia beei castiyaꞌ beei nú leca xunga laxu. ");
INSERT INTO zplNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Uni Jesuse scua xne unibeei nú nchiñi benechiquiꞌ arquiꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hora zeꞌe uriña naꞌ Jesuse, cuna bee bichinu elu nzunu. Pero uyaꞌnatsia beella eliꞌyaꞌ nu uni beella lubee bene enu nucuaꞌa zeꞌe nú nibeei lu Jesuse para nú yeꞌtanu rixia beella. ");
INSERT INTO zplNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nu unibee bene enu nucuaꞌa abenchilaꞌ lunu: ―Nzu naꞌlu cuna bee bichilu eliꞌyaꞌ rlaꞌna beella liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero uninu lubeei: ―¿Ti neca naa nu ti neca bee bichia? ");
INSERT INTO zplNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chequie ubiꞌyanu lubee bene enu nucuaꞌa diqui abenchilaꞌnu nu uninu: ―Caꞌa nucuaꞌa bee bichia cuna naa. ");
INSERT INTO zplNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Puese tatse bene enu sucuꞌ lunú riuꞌ arquiꞌ Diose, neca bene zeꞌe bichia cuna zanaa cuna naa. ");
INSERT INTO zplNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Stucu bese uquixie Jesuse seteꞌnu bee bene ruꞌu inzatuꞌ Galilea. Lunú uyetesaꞌ huaxi bee bene lunu, enzeꞌe uyuꞌunu liñi tucu barco nú nzu lu inzatuꞌ zeꞌe, nu chu uzucunu liñii, diqui nú nucuaꞌa ye bee bene ruꞌu inzatuꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Che uzeteꞌnu huaxi bee ejemplu lubee bene zeꞌe. Chenu uzeteꞌnu bee bene uninu lubeei: ");
INSERT INTO zplNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Uquieꞌe diacahua ninguieꞌ. Tucu bichia uchiuꞌu tucu niyu nzetuꞌ nii lu yuꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chenu rduꞌ niyu quieꞌ nii uzanaꞌ lleꞌna ebichi lu inziu nu chu ulaca bee iñi udacue. ");
INSERT INTO zplNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Lleꞌna ebichi uzanaꞌ leta quiee, elu leca huaxi yuu. Enzeꞌe yexetsia uliñi ebichi quieꞌ xne leca huaxi yuu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero chenu unga nelee uriꞌi beꞌ bichia nú unguꞌlune. Lunú la aca aquié nzene lue enzeꞌe ubichii. ");
INSERT INTO zplNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Lleꞌna ebichi uzanaꞌ leta aca eche, chenu uruꞌcu aca eche. Nézela aca eche cuaꞌ nú aruꞌcue enzeꞌe né ayue. ");
INSERT INTO zplNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero ebichi nú uzanaꞌ lu yuu nzeꞌca, uruꞌcu nzeꞌcae nu chiquiꞌ ñia unguyuꞌe. Texcuaꞌa bee ebichi cuaꞌ unguyuꞌ ala llichiꞌi ebichi nu texcuaꞌe unguyuꞌ sesenta ebichi nu texcuaꞌe unguyuꞌ tucu ayuꞌu ebichi. ");
INSERT INTO zplNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Leꞌca uni Jesuse lubee bene zeꞌe: ―Tatse bene enu niarquiꞌ nú yeneꞌ nú rnia quieꞌe diaca nzeꞌe che. ");
INSERT INTO zplNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chequie chenu uyaꞌnasca lleꞌna bee bene cuna Jesuse cuna chiꞌchiucu bee beneꞌnu, unidichiaꞌ beei lunu: ―Xa rni bee ejemplu nú uninu. ");
INSERT INTO zplNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Che ucuaquinu nu uninu lubeei: ―Liꞌihua uliquiꞌ Diose nú riꞌihua beyaꞌ xa neca nu rnibiyaꞌnu lunú lascaꞌ riꞌihua beyaꞌ. Pero bee bene enu la chili arquiꞌ Diose, setea liꞌibeei puro tsia ejemplu. ");
INSERT INTO zplNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Xne mase riꞌya beei, nu mase rieneꞌ beei. Pero leca xunga riꞌi beei beyaꞌ. Scua la benchilaꞌ arquiꞌbeei lu Diose, nu la riꞌinu perdona stula beei che. ");
INSERT INTO zplNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Leꞌca uni Jesuse lubeei: ―¿Xieꞌ la riꞌihua beyaꞌ xa neca lunú rnia scua la? ¿Xa riꞌihua beyaꞌ beela bedichiaꞌ nú niilá luhua che? ");
INSERT INTO zplNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bene enu uduꞌu nii neca xi neca tucu bene enu rixiuleꞌe Stichiaꞌ Diose lubee bene, ");
INSERT INTO zplNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","nu nuꞌ bee bene enu rieneꞌ Stichiaꞌ Diose, pero la zela bezeꞌlu nú chenala beei Stichiaꞌ Diose. Neca bee bene quieꞌ xi neca ebichi nú uzanaꞌ ruꞌu inziu. ");
INSERT INTO zplNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Texcuaꞌa bee bene neca xi neca ebichi nú uzanaꞌ leta quiee. Rieneꞌ beei Stichiaꞌ Diose nu ñia uyucu arquiꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero liꞌibeei neca beei xi neca ebichi nú leca huaxi luu. Chequie chenu siꞌi beei lunú seca beei, urre chenu seꞌta bee bene liꞌibeei sanaꞌ arquiꞌbeei Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Texcuaꞌa bee bene neca xi neca ebichi nú uzanaꞌ leta aca eche, rieneꞌ beei Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero máse nzenu arquiꞌbeei lunú nuꞌ lu iliulabe. Sequienu beei leꞌcatsia liꞌibeei, xne niarquiꞌ beei nú luꞌcu beei yeene. Chequie chenu nchiñi ye bee nucuaꞌ elliebacuꞌ beei, sanaꞌ arquiꞌ beei nú rieneꞌ beei Stichiaꞌ Diose. Lecaxi zibiꞌ nú ubeneꞌ beei Stichiaꞌ Diose che. ");
INSERT INTO zplNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero nuꞌ bee bene enu rieneꞌ Stichiaꞌ Diose, cuna nú sucuꞌ beei nú rnii, liꞌibeei neca beei xi neca ebichi nú uzanaꞌ lu yuu nzeꞌca. Texcuaꞌa beei chenu rixiuleꞌe beei Stichiaꞌ Diose lubee bene rriꞌi beei ana huaxi bee bene. Neca beei xi neca ebichi nú unguyuꞌ ala llichiꞌi ebichi urre xi neca ebichi nú unguyuꞌ sesenta ebichi urre xi neca ebichi nú unguyuꞌ tucu ayuꞌu ebichi. ");
INSERT INTO zplNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Leꞌca uni Jesuse lubeei: ―¿Leca modo nú duꞌ llieꞌe tucu quinqué, tunu tsacuꞌ bene tucu caja equiee, urre tsu benene liñi luna? Rquiꞌña, nú zucu quinqué cuaꞌ elu ayaa, para nú duꞌ llieꞌe diqui luhuare. ");
INSERT INTO zplNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Leꞌca scua, niꞌ tucu beenú aꞌchi neca la yaꞌna nucuaꞌ scuatsia riña nú aca che ye bee nucuaꞌ, nu niꞌ tucu beenú aꞌchiꞌ neca la yaꞌna nucuaꞌ scuatsia riña nú acabiyaꞌ ye bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tatse bee bene enu niarquiꞌ nú yeneꞌ nú rnia quieꞌe diaca nzeꞌe che. ");
INSERT INTO zplNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Leꞌca uni Jesuse lubeei: ―Uriꞌihua elliebacuꞌ equie bee bedichiaꞌ nú rieneꞌhua. Xne tunu rriꞌihua caso Stichiaꞌ Diose. Leꞌca liquiꞌnu nú maselá riꞌihua beyaꞌ stichiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Xne bee bene enu rriꞌi beyaꞌ Stichiaꞌ Diose riña nú maselá riꞌi nzeꞌe beyaꞌ stichiaꞌnu pero bee bene enu lleꞌnatsia rriꞌi beyaꞌ Stichiaꞌ Diose, cuna nu la riꞌi caso beei stichiaꞌnu. Hasta lunú uriꞌi beei beyaꞌ lleꞌna niti nucuaꞌ arquiꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Leꞌca uni Jesuse lubeei: ―Elurnibiyaꞌ Diose, neca xi neca nú secaa tucu bene chenu nze tuꞌlla nii lu yuꞌulla. ");
INSERT INTO zplNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Xne mase raꞌtse bene quieꞌ rulaꞌ nu bichia rriꞌilla riñaꞌ. Bichia si rulaꞌ rliñi ebichi cuna nú enta ruꞌcue, pero la riꞌilla beyaꞌ xa enta ruꞌcue. ");
INSERT INTO zplNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Xne liꞌi yuu zeꞌe rriꞌi nu enta ruꞌcu ebichi, rluti rliñii nu recae huañi, cheelá enta tuu lue nu cheelá rayue. ");
INSERT INTO zplNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nu chenu necane ulaꞌcu, che xiecuꞌ bee benene xne necala tiembu nú yeteꞌ saꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Leꞌca uni Jesuse lubeei: ―¿Xa nia luhua para nú riꞌihua beyaꞌ xa neca lunú rnibiyaꞌ Diose? ¿Nu xi lubea luhua para nú riꞌi nzeꞌcahua beyaꞌ xa necane? ");
INSERT INTO zplNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ixiuleꞌa luhua xa neca nú rnibiyaꞌ Diose. Necane xi neca ebichiꞌ mestaza. Ebichi quieꞌ chenu riuꞌe lu yuu, meꞌelae lu ye bee ebichi nú nuꞌ lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero chenu uyuꞌu niila ebichi cuaꞌ, chequie enta ruꞌcue nu máse rruꞌcue lu ye bee huañi hasta bee iñi nuꞌ modo nú rrecheꞌe beeí exliaꞌtseꞌ beeí lu ellutsa lue cuna nú sulachi beeí lu xcaꞌlaꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Scua uzeteꞌ Jesuse Stichiaꞌ Diose lubee bene. Uninu huaxi bee ejemplu, hasta lunú uriꞌitsia beei beyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Siempre uninu bee ejemplu chenu uzeteꞌnu bee bene. Pero chenu nzu liꞌitsianu cuna bee beneꞌnu udixiuleꞌenu lubeella xa neca lunú uninu lubee bene scua. ");
INSERT INTO zplNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Leꞌca bichia zeꞌe chenu uyuꞌu rulaꞌ uni Jesuse lubee beneꞌnu nu uninu: ―Chaꞌahua stucu chu inzatuꞌquieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Che utsaꞌna bee beneꞌnu bee bene zeꞌe nu uyuꞌu beella liñi barco cuna Jesuse. Leꞌca nza texcuaꞌa bee barco cuna liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Chequie unga tucu bii juerte lu inzatuꞌ nu utsuli lu inza zeꞌe nu uquixie uyuꞌe hasta liñi barcoꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero raꞌtse Jesuse nuxunu enza rquiꞌ barco zeꞌe nu necuꞌcunu tucu almohada. Che ucuaꞌñi beella liꞌinu nu uni beella lunu: ―¡Maestro! ¿Xinu la riꞌi casolo lunú seꞌcaꞌahua nzee chatseꞌahua lu inza? ");
INSERT INTO zplNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chequie uzetee Jesuse nu utsuxenu bii, nu uninu lu inzatuꞌ zeꞌe: ―¡Aca xee! Nu chu unga xee bii cuna inzatuꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Cheelá uninu lubee beneꞌnu: ―¿Xinu chiquiꞌ xiquihua? ¿Xieꞌlascaꞌ chili arquiꞌhua liꞌá la? ");
INSERT INTO zplNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero chiquiꞌ ulliqui beella nu unidichiaꞌ beella lusaꞌ beella: ―¿Ti neca niyu quieꞌ nú hasta bii cuna inzatuꞌ sucuꞌ nú rni nucuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chenu uriña beella stucu chú inzatuꞌ zeꞌe, lu yuꞌu bee bene eyeche Gadara. ");
INSERT INTO zplNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hora nú uchiuꞌu Jesuse liñi barco zeꞌe uyachaꞌcalu tucu niyu enu nchiñi benechiquiꞌ arquiꞌ liꞌinu, uchiuꞌu niyu quieꞌ liñi pantiuñi. ");
INSERT INTO zplNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Xne siempre nehuañi niyuquieꞌ leta bee eluhuaꞌ bee bene nguti. Nu lecati riꞌi ana lui, mase nú ullicaꞌcuu bee bene liꞌi cuna cadena. ");
INSERT INTO zplNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Huaxi bese ullicaꞌcuu bee bene cadena yai cuna cuchiuꞌi, pero chu uchiecuꞌi cadena nu unga pedasue, nu lecati riꞌi ana lui. ");
INSERT INTO zplNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bichia si rulaꞌ enzei leta bee eluhuaꞌ bee bene nguti cuna liñi dañi, rixialii nu uchiecuꞌi liꞌi cuna quiee. ");
INSERT INTO zplNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pero chenu ulañiꞌi Jesuse, nú entanu istuscaꞌ chequie xexuꞌi nze chaꞌcalui liꞌinu, nu chu utsulliquii lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Che juerte urixialii nu uni: ―¿Xinu riuꞌulu cuna liꞌá Jesuse lliñi Diose liñibe? Ziquia lulu nú la duꞌlu nú nehuana zecaa. ");
INSERT INTO zplNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Uni niyucuaꞌ scua, xne rnila Jesuse nú rninu: ―¡Benechiquiꞌ uchiuꞌu arquiꞌ niyu cuaꞌ! ");
INSERT INTO zplNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chequie unidichiaꞌ Jesuse lu niyu zeꞌe nú uninu: ―¿Ti leelu? Che ucuaqui niyu zeꞌe: ―Liꞌá lea Legión xne huaxi necaru. ");
INSERT INTO zplNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chiquiꞌ uziquiee niyu zeꞌe lu Jesuse, para nú la xeꞌlanu bee benechiquiꞌ zeꞌe enza istu luhuare zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Axu dañi zeꞌe nucuaꞌa huaxi bee cuchi enu racu bee huañi. ");
INSERT INTO zplNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chequie uziquiee bee benechiquiꞌ zeꞌe lu Jesuse nú unibeei, uzela nú chuꞌuru arquiꞌ bee cuchi cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Che uzela Jesuse nú uchiuꞌu bee benechiquiꞌ arquiꞌ niyu zeꞌe, nu uyuꞌu beei arquiꞌ bee cuchi. Neca bee cuchi quieꞌ tucu chiucu mili beeí. Nu uyecaxuꞌu beeí nu utsundiqui beeí ruꞌu qiuee laa nu uzanaꞌ beeí hasta lu inza nu chu unguti beeí lu inza zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hora zeꞌe uyecaxuꞌu bee bene enu rriucu bee cuchi zeꞌe nzetixiuleꞌe beei lubee bene eyeche zeꞌe cuna lu ye bee bene enza zeꞌe lunú unga. Che uyabiꞌya huaxi bee bene lunú unga zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Chenu uriña bee bene zeꞌe elu nzu Jesuse, ulañiꞌ beei nú uyecaꞌlaꞌ niyu enu ulletse benechiquiꞌ arquiꞌ cuna nú nutulai xucui nzucui zeꞌe. Nu chiquiꞌ ulliqui bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Che bee bene enu ulañiꞌ nú xa unga lu niyu enu ulletse benechiquiꞌ arquiꞌ cuna nú xa unga lubee cuchi, udixiuleꞌe beei nucuaꞌ lu beelá bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chequie uquixie beei nú uziquiee beei lu Jesuse para nú chiuꞌunu lu iliuꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Chenu nze chuꞌu Jesuse liñi barco uyabica niyu enu ulletse benechiquiꞌ arquiꞌ lunu, nu uziquiei lunu para nú chenunu liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero né zela Jesuse nú chenunu niyu zeꞌe nu uninu lui: ―Uyaꞌa niꞌilu para nú zucunulu bee beneꞌlu, nu ixiuleꞌelu lubeei lu ye nú uriꞌi Diose cuna liꞌilu, nu cuna nú uhuaꞌa arquiꞌnu liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chequie chu nza niyu zeꞌe, nu uquixiei udixiuleꞌi lubee bene lu iliu Decápolis, lu ye nú uriꞌi Jesuse lui. Che ye bee bene zeꞌe uyanu arquiꞌ lu cuendaꞌ nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chenu uriña zeca Jesuse stucu chu inzatuꞌ zeꞌe liñi barco, uyetesaꞌ huaxi bee bene lunu zeꞌe. Che uyaꞌnanu ruꞌu inzatuꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chequie uriña tucu bene enu rnibiyaꞌ liñi induꞌ bee bene Israel lunu, leella Jairo. Chenu ulañiꞌlla Jesuse utsu lliquilla lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nu chiquiꞌ uziquieella lunu nú unilla lunu: ―Mero ati endua chaa nee ricuꞌlu yalu equie endua para nú yecaꞌnchu nu la atinchu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Che nzenu Jesuse liꞌilla enza niꞌlla nu nzequiee huaxi bee bene liꞌinu hasta nú utaꞌcu bee bene liꞌinu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Leta bee bene zeꞌe nza tucu unaꞌa enu riti, ungala chiꞌchiucu lana nú rlaca rene liꞌinchu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chiquiꞌ nehuana ulleꞌca unaꞌa quieꞌ nu uyanchu lu huaxi bee doctor, hasta nú ulaꞌxunchu ye bee steneꞌnchu ungüitinchu. Pero né aca bee doctor a riꞌiyeca liꞌinchu, aꞌla mase rriꞌi elichiaꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Enzeꞌe chenu ubeneꞌ unaꞌa quieꞌ lu cuendaꞌ Jesuse, che uyabicanchu diꞌchinu leta bee bene nu utiꞌnchu yanchu tsuꞌ xucunu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Xne uriꞌinchu elliebacuꞌ: “Tunu tiꞌyaa tsuꞌ xucunu, scua yecaa uriꞌinchu elliebacuꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hora zeꞌe utsuxee nú rlaca rene liꞌinchu nu utsiꞌnchu nú uyecaꞌlaꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Che uriꞌi Jesuse beyaꞌ nú uriyecanu tucu bene cuna poderꞌnu, nu ubelletanu ubiꞌyanu lubee bene zeꞌe nu uninu: ―¿Ti utiꞌ yaa tetsuꞌ xucua? ");
INSERT INTO zplNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nu uni bee beneꞌ Jesuse lunu: ―Nediyaꞌlu nú nucuaꞌa huaxi bee bene caꞌa rtaꞌcu liꞌilu: ¿Xinu rnidichiaꞌlu nú tii utiꞌ yaa tsuꞌ xuculu? ");
INSERT INTO zplNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero riꞌyascaꞌ Jesuse diqui abenchilaꞌnu para nú lañiꞌnu tii utiꞌyaa tsuꞌ xucunu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chequie chiquiꞌ reca tseꞌtse unaꞌa zeꞌe nú xiquinchu xne nediyaꞌnchu lunú uriꞌinchu, nu uyabicanchu lu Jesuse, che chu utsu lliquinchu lunu, nu uninchu ye nú ulleꞌcanchu lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Che uni Jesuse lunchu: ―Endua lunú uchili arquiꞌlu liꞌá enzeꞌe uyecaꞌlu, uquiaꞌa nu la lliquilu uyecaꞌliꞌlu elichia nú ulleꞌcalu nee. ");
INSERT INTO zplNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Rniscaꞌla Jesuse lu unaꞌa zeꞌe chenu uriña bee bene enu nucuaꞌa niꞌi Jairo nu unibeei lu Jairo: ―Unguutila enduꞌlu nee. La niaꞌlu lu maestro. ");
INSERT INTO zplNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero chenu ubeneꞌ Jesuse lunú uni bee bene zeꞌe. Che uninu lu Jairo: ―La lliquilu uchilitsia arquiꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pero né zela Jesuse a chaa bee bene zeꞌe cuna liꞌinu niꞌ Jairo. Nzenutsianu Pedro, cuna Jacobo cuna Juan bichi Jacobo. ");
INSERT INTO zplNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Chenu uriña beella niꞌi Jairo, ulañiꞌ Jesuse nú nixi bee bene nu rixiali beei cuna nú runaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Chequie uyuꞌu Jesuse liñi niꞌi Jairo nu uninu lubee bene zeꞌe: ―¿Xinu nixihua cuna nú runaꞌhua? Né ati enduꞌ quieꞌ ratse tsianchu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero ulliꞌchinuu bee bene zeꞌe liꞌinu, nu unibiyaꞌnu nú chiuꞌu ye bee bene zeꞌe eliꞌyaꞌ, nu uyuꞌu nutsianu paꞌ enduꞌ zeꞌe cuna naꞌnchu cuna bee beneꞌnu elu nchiucuꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Che unaꞌtse Jesuse ya enduꞌ zeꞌe, nu uninu lunchu: ―Talita, cumi ―rni bedichiaꞌ quieꞌ: Enduꞌ, nia lulu nú, uzetee nee. ");
INSERT INTO zplNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hora zeꞌe uzetee enduꞌ zeꞌe nu utseenchu, nza enduꞌ quieꞌ chiꞌchiucu lana, che chiquiꞌ uyanu arquiꞌ yebee bene zeꞌe nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero unibiyaꞌ Jesuse nú la ixiuleꞌe beella lu niꞌ tucu bee bene nú ungae scua. Leꞌca unibiyaꞌnu nú deteꞌ beella nú acu enduꞌ cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chequie uchiuꞌu Jesuse zeꞌe, nu ubenchilaꞌnu lachinu cuna bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Chenu uriña bichia nú sulachi bee bene uquixie Jesuse nú seteꞌnu bee bene liñi induꞌ bee bene Israel, che ye bee bene enu rieneꞌ nú rninu, chiquiꞌ uyanu arquiꞌbeei nu unibeei lu saꞌbeei: ―¿Cá unga nucuaꞌ huaxi nú seteꞌ nucuaꞌ scua? ¿Nu cá uhua nucuaꞌ nú reca elliebacuꞌ nucuaꞌ scua cuna bee milagro nú rriꞌi nucuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿La nu nucuaꞌ neca enu rriꞌi riñaꞌ ruꞌu bangu nu neca nucuaꞌ llianaꞌ María, nu neca bichi nucuaꞌ Jacobo, cuna José, cuna Judas cuna Simón la? ¿Leꞌca esquie nucuaꞌa bee zana nucuaꞌ eyeche quieꞌ? Enzeꞌe lá chili arquiꞌbeei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Che uninu lubee bene zeꞌe: ―Catse rluꞌcu bee bene ulaꞌna lu tucu profeta. Pero la luꞌcu bee bene lachilla ulaꞌna lulla, cuna bee bene niꞌilla cuna bee saꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Enzeꞌe né aca a riꞌinu huaxi milagro lachinu uricuꞌtsianu yanu equie chiucu chuna bee bene enu riti nu uriꞌiyecanu bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Chiquiꞌ uyanu arquiꞌ Jesuse, nú né chili arquiꞌ bee bene lachinu liꞌinu. Che chu uyanu bee eyeche axu zeꞌe nu uzeteꞌnu bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Chequie ubixia Jesuse chiꞌchiucu bee beneꞌnu, nu uxeꞌlanu chiucua chiucua beella. Nu udeteꞌnu poder lubeella para nú aca beella hua beella bee benechiquiꞌ arquiꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Che unibiyaꞌnu nú lecaxi uyaꞌ beella para lu inziu, la uyaꞌ beella biti nu la uyaꞌ beella pá nú acu beella nu la uyaꞌ beella dimi, uyaꞌtsia beella tucutsia xca beella. ");
INSERT INTO zplNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Cuna lucutsia beella nú niquieꞌe beella nu cuna xucu beella nú nutu tsia beella. ");
INSERT INTO zplNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Leꞌca uni Jesuse lubeella: ―Chenu riñahua niꞌi tucu bene uyaꞌnatsiahua niꞌi bene zeꞌe hasta nú chiuꞌuhua eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tunu tucu eyeche la yucu arquiꞌ bee bene liꞌihua cuna nú la niarquiꞌbeei yeneꞌ beei nú rnihua, uchiuꞌuhua eyeche zeꞌe nu riꞌquihua yuu beꞌchaꞌ nú nuꞌ cuchiuꞌhua, xi neca tucu seña nú lá zucuꞌbeei nú unihua. Ixiuleꞌa luhua nú bichia chenu deteꞌ bee bene cuenda lu Diose másela deteꞌ Diose castiya lubee bene cuaꞌ lunú deteꞌnue lubee bene eyeche Sodoma cuna Gomorra. ");
INSERT INTO zplNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Che chu nzue bee beneꞌnu nu nzetixiuleꞌe beella lubee bene nú cheꞌe arquiꞌ bee bene lu cuendaꞌ stulabeei. ");
INSERT INTO zplNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Leꞌca uhua beella huaxi bee benechiquiꞌ arquiꞌ bee bene cuna nú uduꞌ beella aceite equie bee bene enu riti nu uriꞌiyeca beella bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chequie ubeneꞌ arre Herodes nú chiquiꞌ rni bee bene lu cuendaꞌ Jesuse, catse bee luhuare zeꞌe. Nu uni Herodes: ―Pia nú Juan Bautista uhuañi zeca nee, enzeꞌe rluꞌculla poder nú rriꞌilla bee milagro scua. ");
INSERT INTO zplNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero texcuaꞌa bee bene rni: ―Neca nucuaꞌ profeta Elías. Nu texcuaꞌa bee bene rni: ―Neca nucuaꞌ tucu bee profeta huaꞌtu. ");
INSERT INTO zplNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Chenu ubeneꞌ arre Herodes nucuaꞌ unilla: ―Juan Bautista nucuaꞌ liꞌá unibiyaꞌa nú uruꞌu lluca equiella nu uhuañi zecalla nee. ");
INSERT INTO zplNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Uni Herodes scua xne unibiyaꞌlla nú ulluna Juan nu uyacaꞌcuulla cuna cadena nu uyuꞌulla niꞌcuꞌ equie cuendaꞌ Herodías unaꞌa Felipe bichi Herodes. Pero uyucu Herodes unaꞌa Felipe bichilla. ");
INSERT INTO zplNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nu unilá Juan lu Herodes: ―La neca nzeꞌca nú yuculu unaꞌa bichilu. ");
INSERT INTO zplNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chequie chiquiꞌ uhuana arquiꞌ Herodías Juan, nu niarquiꞌnchu nú útinchu liꞌilla pero leca modoe. ");
INSERT INTO zplNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Xne nediyaꞌ Herodes nú neca Juan tucu bene enu neli rriꞌi tucu nú necane cuna nú necalla tucu bene enu nehuañi nzeꞌca lu Diose, enzeꞌe ulliqui Herodes Juan. Nu né zelalla nú riꞌi Herodías lunú niarquiꞌnchu lu Juan, nu añinzuca nú chiquiꞌ riuꞌ arquiꞌlla lunú rni Juan pero la riꞌilla beyaꞌ xa riꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero chenu uriña bichia nú uyuꞌu modo nú niarquiꞌ Herodías nú riꞌinchu, unga nucuaꞌ chenu ulluꞌcu arre Herodes lana, chequie uriꞌi arre Herodes tucu eliñiꞌlla nu udeteꞌlla nú udacu bee bene enu rnibiyaꞌ cuna bee bene enu rnibiyaꞌ lubee sundado, cuna beelá bee bene enu neca equie lubee bene Galilea. ");
INSERT INTO zplNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Che uyuꞌu xinchiuꞌcu Herodías elu reca eliñi zeꞌe nu chu uyeꞌenchu. Chiquiꞌ uyuꞌ arquiꞌ Herodes cuna bee bene enu nezeneꞌ zeꞌe nú xa uyeꞌenchu nu uni arre Herodes zeꞌe lunchu: ―Unaꞌcuꞌ tatse lunú niarquiꞌlu lua, nu liꞌá liquine. ");
INSERT INTO zplNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Chequie uquieꞌe arre Herodes dioseꞌlla nú deteꞌlla lunchu lunú nacuꞌnchu mase arliꞌti lunú rnibiyaꞌlla lu. ");
INSERT INTO zplNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nu chu uchiuꞌunchu eliꞌyaꞌ nu unidichiaꞌnchu lu naꞌnchu Herodías nú uninchu: ―¿Xi nacua lu arre quieꞌ? Che uni naꞌnchu Herodías: ―Unaꞌcuꞌ lluca equie Juan Bautista. ");
INSERT INTO zplNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nu yexetsia uyuꞌu zecanchu elu nzucu arre Herodes nu uninchu lulla: ―Niarquia nú nee inza liquiꞌlu lu tucu pliatu lluca equie Juan Bautista. ");
INSERT INTO zplNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Che chiquiꞌ nehuana utsu arquiꞌ arre Herodes. Pero lu nú uquieꞌelalla dioseꞌlla lu ye bee bene enu nezeneꞌ zeꞌe, lecaꞌ modo nú acaalla lunú unacuꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chequie unibiyaꞌ arre Herodes lu tucu sundado nú yeꞌtayui lluca equie Juan Bautista. ");
INSERT INTO zplNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nu chu nza sundado zeꞌe liñi niꞌcuꞌ nu uchiecuꞌi lluca equie Juan uricuꞌi lu tucu pliatu nu unguyaꞌi nu udeteꞌi yanchu nu chu udeteꞌnchue ya naꞌnchu Herodías. ");
INSERT INTO zplNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chequie chenu ubeneꞌ bee bene enu uyaquie Juan nucuaꞌ, uya beei uya tucu beei cuerpoꞌ Juan nu ucachiꞌ beei cuerpoꞌlla liñi tucu eluhua. ");
INSERT INTO zplNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Cheelá chenu ubenchilaꞌ chiꞌchiucu bee beneꞌ Jesuse, udixiuleꞌe beella lunu lu ye nú uriꞌi beella cuna nú uzeteꞌ beella bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nu uni Jesuse lubee beneꞌnu: ―Uteehua, ne chaꞌahua tucu luhuare elu lecati nuꞌ para nú tsulachiaꞌahua zeꞌe lleꞌna. Uninu scua xne huaxi bee bene rriña lunu nu xiuꞌu beei nziue beei hasta nú né lluꞌcha acununu bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Che uyuꞌu Jesuse cuna bee beneꞌnu liñi tucu barco nu nzuebeella tucu luhuare elu lecalí ti nuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero ulañiꞌ huaxi bee bene nú uchiuꞌu barcoꞌ beella nza nu uyuꞌulu bee bene cuaꞌ liꞌibeella. Che uchiuꞌu ye bee bene eyeche zeꞌe nu nzue eꞌya tsia beei nu uriña rlutiaꞌla beei elu riña Jesuse cuna bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Chenu ulaca Jesuse liñi barco zeꞌe ulañiꞌnu nú nucuaꞌala huaxi bee bene zeꞌe. Chiquiꞌ uhuaꞌa arquiꞌnu liꞌibeei xne neca beei xi neca bee sanchi enu lecati riꞌi ucu nu uquixienu nú uzeteꞌnu liꞌibeei huaxi bee bedichiaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Chenu unga uchee, uyabica bee beneꞌ Jesuse lunu nu uni beella: ―Ucheela nee, nu leca niꞌtucu niꞌ bee bene caꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Uniꞌi lubee benecuaꞌ nú yue beei lubee ranchu cuna lubee eyeche axu caꞌa, para nú tsii beei lleꞌna nú acubeei. ");
INSERT INTO zplNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero uni Jesuse lubee beneꞌnu: ―Liꞌihua deꞌtehua nú acu bee bene quieꞌ Che uni bee beneꞌnu lunu: ―¿Pero xieꞌ che tsiaꞌhua chiucu ayuꞌu dimi denario pá, acu bee bene quieꞌ la? ");
INSERT INTO zplNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Chequie uni Jesuse lubeella: ―¿Xala pá rluꞌcuhua? Uya biꞌyahua xala pá nuꞌ. Chenu uriꞌi beella beyaꞌ nú xala pá nuꞌ uni beella lunu: ―Nuꞌ ayuꞌ pá cuna chiucu bela. ");
INSERT INTO zplNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Che unibiyaꞌ Jesuse nú cuaꞌa bee bene zeꞌe texcuaꞌa texcuaꞌa beei lu ixi xata niyeꞌe zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chequie ucuaꞌa tucu ayua tucu ayua beei luhuare zeꞌe nu ucuaꞌa se cincuentaa se cincuentaa beei. ");
INSERT INTO zplNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nu unaꞌtse Jesuse ayuꞌ pá zeꞌe cuna rucu bela zeꞌe nu ubiꞌyanu enza liñibe nu udeteꞌnu cheꞌtsala lu Diose, nu chu uleꞌenu ayuꞌ pá zeꞌe cuna rucu bela zeꞌe udeteꞌnu ya bee beneꞌnu para nú ritsiꞌ beella bee pá cuaꞌ cuna bee bela lu ye bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Udacu ye bee benecuaꞌ hasta nú ubelaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nu urichescaꞌ beella chiꞌchiucu llume bee pedaso bee pá cuna bee pedaso bee bela enu uyaꞌna lunú udacu beei. ");
INSERT INTO zplNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Leta ye bee bene enu udacu zeꞌe nucuaꞌa ayuꞌ mili bee niyu. ");
INSERT INTO zplNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chequie unibiyaꞌ Jesuse nú uyuꞌu bee beneꞌnu liñi barco para nú chu chue beella stucu chú inzatuꞌ elu nchiucuꞌ eyeche nú lee Betsaida. Pero uyaꞌnascaꞌnu zeꞌe para nú ninu lubee bene enu nucuaꞌa zeꞌe nú nzanu. ");
INSERT INTO zplNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chenu ulaxu nú uninu lubee bene zeꞌe nú nzanu, che chu nzanu tucu dañi nu unacuꞌnu lu Diose zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pero chenu uyuꞌu rulaꞌ, nzuscaꞌ Jesuse dañi zeꞌe. Nu nzala barcoꞌ bee beneꞌnu labe inzatuꞌ, ");
INSERT INTO zplNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","chenu ulañiꞌnu nú chiquiꞌ neriñaꞌ tsenuu bee beneꞌnu barcoꞌ beella xne reca bii enza lubeella. Che uchiuꞌunu ellicabe zeꞌe nu utsenu lu inzatuꞌ zeꞌe, nu uriꞌinu tucu nú nze detenu lubeella. ");
INSERT INTO zplNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero chenu ulañiꞌ bee beneꞌnu nú seenu nzeꞌtanu lu inzatuꞌ zeꞌe, uriꞌi beella elliebacuꞌ nú necanu tucu armaꞌ bene unguti nu urixialibeella. ");
INSERT INTO zplNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Xne ulañiꞌ ye beella liꞌinu nu ulliqui beella, pero chu uninu lubeella: ―¡Utsu naaqui arquiꞌhua liꞌá nucuaꞌ la lliquihua! ");
INSERT INTO zplNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Che uyuꞌu Jesuse liñi barcoꞌ beella nu chu ungaxee bii. Chiquiꞌ uyanu arquiꞌ bee beneꞌnu nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Xne niꞌlá riꞌi beella elliebacuꞌ equie milagro nú uriꞌinu chenu uritsiꞌnu bee pá lubee bene lunú nacuꞌscaꞌ nchiñi elliebacuꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chequie udete beella stucu chú inzatuꞌ zeꞌe nu uriña beella lu iliu Genezaret nu ullicaꞌcuu beella barcoꞌ beella ruꞌu inzatuꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hora chenu uchiuꞌu beella liñi barcoꞌ beella uyuꞌulu bee bene Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Che uya bee bene zeꞌe nu udixiuleꞌe beei lubee bene diqui bee luhuare enza zeꞌe, nu uquixie bee bene uyayu bee bene, bene enu riti nchiucuꞌ lu camiya elu rieneꞌ beei nú nzu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Catse elu uya Jesuse sianu necane bee eyeche llaꞌna urre necane bee eyeche llene urre necane bee ranchu udixiu bee bene cuaꞌ bee bene enu riti elu udete Jesuse. Chequie uziquie bee bene enu riti zeꞌe lunu nú zelanu nú tiꞌyabeei masia ruꞌu xucunu; nu ye bee bene enu utiꞌya ruꞌu xucu Jesuse uyecaꞌ bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tucu bichia uyabica bee fariseo cuna bee ulaxcuela enu reca leyꞌ Moisés lu Jesuse, nzeꞌta bee benequieꞌ enza Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Chequie chenu ulañiꞌ bee benecuaꞌ nu nuꞌ chiucu chuna bee beneꞌ Jesuse enu ne naa chenu udacu beella tucu nú neca costumbreꞌ bee ulaxcuela cuaꞌ, che uzeꞌta bee benecuaꞌ bee beneꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Xne nzequie bee fariseo cuna bee bene Israel costumbreꞌ bee beneꞌ beei enu udetela, nú la acu beei tunu la naa beei ya beei huaxi bese. ");
INSERT INTO zplNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Leꞌca chenu ubenchilaꞌ beei nú uya beei ruꞌu iꞌya la acu beei tunu la naa beei ya beei, tucu nú neca costumbreꞌ beei. Leꞌca nzequie beei huaxilá bee costumbreꞌ beei, nú xa rquiee beei bee vaso cuna bee situ cuna bee exquiꞌña nú necacheꞌ icuꞌ cuna luna nú raꞌtse beei.) ");
INSERT INTO zplNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Enzeꞌe unidichiaꞌ bee fariseo cuna bee ulaxcuela enu reca leyꞌ Moisés lu Jesuse nú unibeei: ―¿Xinu la chequiee bee beneꞌlu tucu nú neca bee costumbreꞌ bee beneaꞌahua enu udetela, xinu la naa bee beneꞌlu yabeei chenu racu beei tucu nú riala nú riꞌi beei? ");
INSERT INTO zplNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chequie ucuaqui Jesuse lubee benecuaꞌ nú uninu: ―Rriꞌihua tucu nú rlubeꞌhua nú rriꞌi nzeꞌcahua, pero lia rriꞌihua nucuaꞌ. Neli neca nú uni profeta Isaías chenu uquieꞌella lunú uni Diose lu cuendaꞌhua nú uninu: Bee benequieꞌ rriꞌi beei tucu nú chiquiꞌ rluꞌcu beei ulaꞌna lua, pero istu nzu arquiꞌbeei lua. ");
INSERT INTO zplNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Lecaxi zibiꞌ nú rnibeei nú rluꞌcu beei ulaꞌna lua, xne seteꞌ beei bee bene tucu nú necatsia elliebacuꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Liꞌihua sanaꞌ arquiꞌhua Stichiaꞌ Diose para nú nzequiehua bee costumbreꞌtsiaꞌ bee bene nú xa rquiehua bee situ cuna bee vaso cuna beelá nú neca xi neca bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Leꞌca uni Jesuse lubeei: ―Sanaꞌ arquiꞌhua Stichiaꞌ Diose para nú sucuꞌtsiahua nú neca bee costumbreꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nu uni Moisés: “Luꞌcu bee bene ulaꞌna lu paꞌlla cuna lu naꞌlla”, nu “Bee bene enu riꞌña nú zeca paꞌ cuna nú zeca naꞌ ati bene zeꞌe che.” ");
INSERT INTO zplNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero liꞌihua rnihua nú nuꞌ modo ni tucu bene lu paꞌlla cuna lu naꞌlla: “Leca modo nú riꞌá elietsa luhua, xne ye lunú rlucua neca nucuaꞌ Corbán” (rni bedichiaꞌ Corbán nú necala nucuaꞌ cuendaꞌ Diose). ");
INSERT INTO zplNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Che rnihua nú bee bene enu rni scua la quiꞌña nú riꞌi nzeꞌe elietsa lu paꞌ nzeꞌe cuna lu naꞌ nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Scua neca nú la zucuꞌhua Stichiaꞌ Diose, xne nzequiehua bee costumbreꞌhua nu seteꞌhua bee saꞌhua nu rriꞌihua huaxilá beenú neca scua. ");
INSERT INTO zplNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Che ubixia Jesuse bee bene, nu uninu lubeei: ―Uquieꞌe diacahua nu uriꞌihua beyaꞌ lunú rnia: ");
INSERT INTO zplNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","La riꞌi bee bene dula equie cuendaꞌ nú racu bee bene, pero rriꞌi bee bene dula lunú xiuꞌu ruꞌu bee bene, cuna lunú rriꞌi bee bene, nucuaꞌ neca nú rriꞌi nú rluꞌcu bee bene dula. ");
INSERT INTO zplNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tatse bee bene enu niarquiꞌ nú yeneꞌ nú rnia, quieꞌe diaca nzeꞌe nucuaꞌ che. ");
INSERT INTO zplNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chenu utsaꞌna Jesuse bee bene zeꞌe nu uyuꞌunu liñi tucu niꞌi nu unidichiaꞌ bee beneꞌnu lunu nú xa neca lunú uzeteꞌnu scua. ");
INSERT INTO zplNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Che uninu lubeella: ―¿Xieꞌ leꞌca nuuhua ne riꞌihua beyaꞌ lunú unia scua la? ¿Xieꞌ la riꞌihua beyaꞌ nú la riꞌi bee bene dula equie cuendaꞌ nú racu bee bene, ");
INSERT INTO zplNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","xne lunú racu bee bene la chuꞌu nucuaꞌ liñi arquiꞌ bee bene riuꞌutsia nucuaꞌ xlaꞌcu bee bene nu chu xiuꞌu zecae? Scua udixiuleꞌenu nú ye bee elubacu la riꞌi bee nucuaꞌ nú rluꞌcu bee bene dula. ");
INSERT INTO zplNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Leꞌca uni Jesuse lubeei: ―Lunú xiuꞌu ruꞌu bee bene cuna lunú rriꞌi bee bene, nucuaꞌ neca nú rriꞌi nú rriꞌi bee bene dula. ");
INSERT INTO zplNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Xne liñi arquiꞌ bee bene rliñi nú necha nchiñi elliebacuꞌ bee bene nú rriꞌi bee bene eluhuexe cuna nú rriꞌi bee bene eluhuanaꞌ cuna nú ruuti saꞌa bee bene, ");
INSERT INTO zplNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cuna nú rluꞌcu niyu stucu unaꞌa urre rluꞌcu unaꞌa stucu niyu, cuna nú rleꞌ bee bene luꞌculla steneꞌ saꞌalla, cuna nú rriꞌi bee bene nú necha neca, cuna nú sequienu bee bene saꞌa bee bene, cuna nú rluꞌcu bee bene bee vicio, cuna nu riea arquiꞌ bee bene lu saꞌa bee bene, cuna nú rni bee bene eluquichiaꞌ, cuna nú rutiꞌ bee bene, cuna nú rriꞌi bee bene beenú la zibiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ye beenú necha neca cuaꞌ nzeꞌta liñi arquiꞌ bee bene nu rriꞌi bee nucuaꞌ nú rriꞌi bee bene dula. ");
INSERT INTO zplNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chenu uchiuꞌu Jesuse zeꞌe nú nzanu lu iliu Tiro cuna lu iliu Sidón, che uyuꞌunu liñi tucu niꞌi xne la niarquiꞌnu nú acabiyaꞌ bee bene nú nzucunu zeꞌe, pero ne aca nú acachiꞌlunu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Xne luego chu ubeneꞌ tucu unaꞌa nú nzucunu zeꞌe nu uyanchu elu nzucunu, xne rluꞌcunchu tucu xinchiuꞌcunchu enu nchiñi benechiquiꞌ arquiꞌ nu chu utsu lliquinchu lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","La neca unaꞌa quie bene Israel, necanchu bene Sirofenicia. nu uziquienchu lu Jesuse para nú huanu benechiquiꞌ arquiꞌ xinchiuꞌcunchu. ");
INSERT INTO zplNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero uni Jesuse lu unaꞌa zeꞌe: ―Uzela nú acuxu bee enduꞌ xne la neca nzeꞌca nú axi bene pá ruꞌu bee enduꞌ deteꞌ bene acu bee nicu. ");
INSERT INTO zplNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Che uninchu lunu: ―Nelíꞌlu nú unilu scua. Pero hasta bee nicu racu pá ubee nú sanaꞌ ruꞌu enduꞌ liñi mexa. ");
INSERT INTO zplNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Chequie uni Jesuse lunchu: ―Uni nzeꞌcalu nú unilu scua, uquiaꞌa niꞌlu uchiuꞌula benechiquiꞌ arquiꞌ xinchiuꞌculu nee. ");
INSERT INTO zplNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chenu uriñanchu niꞌinchu ulañiꞌnchu xinchiuꞌcunchu nuxu lu luna, pero uchiuꞌula benechiquiꞌ arquiꞌnchu che. ");
INSERT INTO zplNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Che uchiuꞌu zeca Jesuse lu iliu Tiro nu udetenu eyeche Sidón cuna bee eyeche lu iliu Decápolis nu uriñanu ruꞌu inzatuꞌ Galilea. ");
INSERT INTO zplNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Zeꞌe uriñayuu bee bene tucu niyu enu nenguataꞌ lunu cuna nú la ni nzeꞌcai nu unacuꞌ bee bene zeꞌe lunu nú ricuꞌnu yanu equiei. ");
INSERT INTO zplNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chequie unguyaꞌ Jesuse niyu zeꞌe tucu chú, nu uduꞌnu cuene yanu liñi rucu diacai nu utiꞌnu xenenu lu luꞌchii. ");
INSERT INTO zplNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Che ubiꞌyanu enza liñibe nu utsii arquiꞌnu nú uninu: ―¡Efata! ―rni bedichiaꞌ quieꞌ: ¡Uyaꞌla! ");
INSERT INTO zplNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hora zeꞌe, uyaꞌla rucu diaca niyu zeꞌe nu uyecaꞌ luꞌchii nu uquixie uni nzeꞌcai. ");
INSERT INTO zplNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nu unibiyaꞌ Jesuse nú la ixiuleꞌe bee bene zeꞌe lu niꞌ tucu bee bene lunú unga zeꞌe, pero añinzuca nú unibiyaꞌ Jesuse nú la ni bee bene nucuaꞌ aꞌla mase uni bee bene nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chiquiꞌ uyanu arquiꞌ bee bene zeꞌe, nu unibeei: ―Ñia neca lu ye nú rriꞌinu hasta nú rriꞌinu nú uyeꞌe diaca bene enu nenguataꞌ nu rriꞌinu nú rni bene enu la aca nii. ");
INSERT INTO zplNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tucu bichia uyetesaꞌ zeca huaxi bee bene lu Jesuse nu lecaxi luꞌcu beei acu beei, che ubixia Jesuse bee beneꞌnu nu uninu lubeella: ");
INSERT INTO zplNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ruꞌu arquia bee benequieꞌ, xne nucuaꞌa labeei chuna bichia cuna liꞌá nu lecaxi luꞌcu beei caꞌa acu beei. ");
INSERT INTO zplNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tunu xeꞌlaa beei nú yue beei enza niꞌ beei nu la acu beei nuꞌ modo nú chiulaꞌ beei lu inziu xne nuꞌ beei enu nzeꞌta enza istu. ");
INSERT INTO zplNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Chequie ucuaqui bee beneꞌnu nu uni beella lunu: ―¿Cá chiuꞌu nú acu bee benequieꞌ caꞌa luhuare elu lecalí ti nuꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Che unidichiaꞌ Jesuse lubeella nú uninu: ―¿Xala pá rluꞌcuhua? Nu ucuaqui beella: ―Rlucuru achine. ");
INSERT INTO zplNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chequie unibiyaꞌ Jesuse nú cuaꞌa bee bene zeꞌe lu yuu nu unaꞌtsenu achi pá zeꞌe, nu udeteꞌnu cheꞌtsalá lu Diose equie cuendaꞌ pá cuaꞌ, nu chu udeteꞌnue ya bee beneꞌnu para nú ritsiꞌ beellae lubee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Leꞌca rluꞌcu bee beneꞌnu lleꞌna bee bela nu udeteꞌnu cheꞌtsalá lu Diose equie cuendaꞌ bela zeꞌe, nu unibiyaꞌnu nú ritsiꞌ bee beneꞌnu bee bela cuaꞌ lubee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ye bee bene zeꞌe udacu beei hasta nú ubelaꞌ beei nu uzucu sobrascaꞌ achi llume bee pedaso nú uyaꞌna udacu beei. ");
INSERT INTO zplNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Neca tucu tacu mili bee bene enu udacu zeꞌe nu chu uni Jesuse lubee bene zeꞌe nú nzanu. ");
INSERT INTO zplNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Che chu uyuꞌu Jesuse liñi barco cuna bee beneꞌnu nu nzuebeella lu iliu Dalmanuta. ");
INSERT INTO zplNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Zeꞌe uriña bee fariseo nu uquixie beei rnixuu beei cuna Jesuse, para nú riꞌi beei preo liꞌinu, che unacuꞌbeei nú riꞌinu tucu milagro nú lubeꞌ nú nzeꞌtanu lu cuendaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nu hasta aquié utsii arquiꞌ Jesuse nú uninu: ―¿Xi nú niarquiꞌhua nú riꞌá tucu milagro? Neli nia luhua nú la riꞌá niꞌ tucu milagro luhua. ");
INSERT INTO zplNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chequie utsaꞌnanu bee bene zeꞌe nu uyuꞌu zecanu liñi barco cuna bee beneꞌnu nu chu nzuebeella stucu chú inzatuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Uzañiꞌ bee beneꞌ Jesuse a uyaꞌ beella nú acu beella nuyaꞌtsia beella tucu pá liñi barco zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Che uni Jesuse lubeella: ―Ubiꞌyahua liꞌihua, lu levaduraꞌ bee fariseo cuna levaduraꞌ Herodes. ");
INSERT INTO zplNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nu uquixie beella uni beella lusaꞌbeella: ―Uninu scua xne la luꞌcuaꞌahua pá. ");
INSERT INTO zplNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pero uriꞌi Jesuse beyaꞌ lunú rni beella, nu uninu lubeella: ―¿Xi nú rnihua nú la luꞌcuhua pá? ¿Xieꞌ lascaꞌlí riꞌihua beyaꞌ la? ¿Xieꞌ niꞌ temeꞌ la riꞌihua beyaꞌ la? ");
INSERT INTO zplNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nzucu iꞌculuhua pero pianu la lañiꞌhua, nzucu diacahua pero pianu la yeneꞌhua ¿Xieꞌ la llucuꞌ arquiꞌhua, ");
INSERT INTO zplNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","chenu uritsia ayuꞌ pá lu ayuꞌ mili bee bene la? ¿Nu xala llume lunú uzucu sobra uquieteꞌsaꞌhua? Nu ucuaqui beella: ―Chiꞌchiucune. ");
INSERT INTO zplNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Che uni Jesuse lubeella: ―Chenu uritsia achi pá lu tacu mili bee bene, ¿xala llume uriꞌichehua lunú uquieteꞌsaꞌhua? Nu ucuaqui beella: ―Achi llumene. ");
INSERT INTO zplNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chequie uninu lubeella: ―¿Xieꞌ lascaꞌ riꞌihua beyaꞌ nee la? ");
INSERT INTO zplNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chenu uriña beella eyeche Betsaida, uriñayu bee bene tucu niyu enu niquieꞌlu lu Jesuse, nu uziquie bee bene zeꞌe lunu nú tiꞌnu yanu lu niyu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Che unaꞌtse Jesuse ya niyu zeꞌe nu unguyaꞌnu liꞌi ruꞌu eyeche zeꞌe. Nu utiꞌnu xenenu iꞌcului, nu uricuꞌnu yanu equiei nu unidichiaꞌnu lui tunu riꞌyalai lleꞌna. ");
INSERT INTO zplNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nu uquixie nú riꞌya, niyu zeꞌe nu uni: ―Rlañia bee bene nú sebeei. Pero rnaa beei xi rnaa aca. ");
INSERT INTO zplNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chequie utiꞌ zeca Jesuse yanu iꞌcului, nu uninu lui nú biꞌyai tucutsia luhuare nu uquixie nú ulañiꞌ nzeꞌcaꞌi yeene. ");
INSERT INTO zplNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Che uni Jesuse lu niyu zeꞌe nú yai enza niꞌi, nu unibiyaꞌnu nú la chuꞌi eyeche zeꞌe cuna nú la ixiuleꞌi lu niꞌ tucu bee bene nú xa uyeca iꞌcului. ");
INSERT INTO zplNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Lu lá bee nucuaꞌ, nza Jesuse cuna bee beneꞌnu lubee eyeche lu iliu Cesarea de Filipo. Chenu nzuebeella lu inziu, unidichiaꞌ Jesuse lubee beneꞌnu nú uninu: ―¿Ti rni bee bene nú necaa? ");
INSERT INTO zplNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Chequie ucuaqui beella nú uni beella: ―Nuꞌ bee bene enu rni nú necalu Juan Bautista, nu nuꞌ bee bene enu rni nú necalu profeta Elías, nu nuꞌ bee bene enu rni nú necalu tucu bee profeta huaꞌtu. ");
INSERT INTO zplNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Che uninu lubeella: ―Liꞌi quiehua, ¿ti rnihua nú necaa? Nu ucuaqui Pedro nú unilla: ―Liꞌilu necalu Cristo enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pero unibiyaꞌ Jesuse nú la ni beella nú ti necanu lu niꞌ tucu bee bene ");
INSERT INTO zplNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chequie uquixienu nú udixiuleꞌenu lubee beneꞌnu nú uninu: ―Liꞌá Bene enu uxeꞌla Diose chiquiꞌ nzeꞌta nú nehuana zecaa, cuna nú la yuꞌ arquiꞌ bee usticiaꞌ bee bene Israel liꞌá, niꞌbee uleꞌya enu rnibiyaꞌ lu beelá bee uleꞌya niꞌbee ulaxcuela enu reca leyꞌ Moisés, úti bee benecuaꞌ liꞌá, pero bichia rriuna huañi zecaa. ");
INSERT INTO zplNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chiquiꞌ neli udixiuleꞌe nzeꞌcanu lubeella lu cuendaꞌ nucuaꞌ. Chequie unguyaꞌ Pedro liꞌinu tucu chu zeꞌe nu unilla lunu nú la niaꞌnu scua. ");
INSERT INTO zplNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Che ubelleta Jesuse nu ubiꞌyanu lubee beneꞌnu, nu uquiꞌyaꞌ Pedro uriꞌinu, nú uninu lulla: ―¡Ullunaꞌ lua bezeꞌlu! Xne elliebacuꞌ nú rriꞌilu scua la yeꞌta nucuaꞌ lu Diose, rriꞌi tsialu elliebacuꞌ tucu nú neca elliebacuꞌ bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chequie ubixia Jesuse bee beneꞌnu cuna beelá bee bene enu nucuaꞌa zeꞌe, nu uninu lubeei: ―Tunu nuꞌ bee bene enu niarquiꞌ nú aca benea, la riꞌilla tucu nú necatsia elliebacuꞌlla, rquiꞌña nú riquiꞌlla beenú nehuana zecalla che chu yeꞌta quieella liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Xne bee bene enu niarquiꞌ másela lunú nehuañi lu iliulabe quieꞌ enta bichia nú nitilu nucuaꞌ, pero bee bene enu ati equie nú neca beei benea cuna equie nú uzucuꞌbeei nú rni Stichiaꞌ Diose, luꞌcu nzeꞌe nú huañi nzeꞌe lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lecaxi zibiꞌ nú riꞌi bee bene ana ye lunú nuꞌ lu iliulabe, tunu unitilulla lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Xne leca modo, nú tsi bee bene nú huañilla liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tunu tuꞌ tucu bene liꞌá cuna nú rni stichiaꞌa lubee bene enu rluꞌcu dula, cuna nú la chequiee beei inziuꞌ Diose leꞌca Liꞌá Bene enu uxeꞌla Diose tua bee benecuaꞌ chenu riña zecaa cuna lunú rnibiyaꞌ Pa liñibe cuna bee ángeleꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Leꞌca uni Jesuse lubee bene zeꞌe nú uninu: ―Ixiuleꞌa luhua nú nuꞌhua enu nucuaꞌa caꞌa lá atiscaꞌ hasta nú lañiꞌhua poderꞌ Diose cuna lu ye nú recanu. ");
INSERT INTO zplNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chenu udete xuꞌcu bichia, che unguyaꞌ Jesuse Pedro, cuna Jacobo cuna Juan. Equie tucu dañi llene, zeꞌe ucheꞌe nú rnaa Jesuse lubeella. ");
INSERT INTO zplNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nu chiquiꞌ uyuꞌullieꞌe xucunu nu unga niquichiuaꞌquieꞌe nu lecati aca quié laquie nú niquichiu scua lu iliulabequieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hora zeꞌe ulañiꞌ beella nú rdichiaꞌnu Jesuse, Elías cuna Moisés enu uhuañi huaꞌtu. ");
INSERT INTO zplNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nu uni Pedro lu Jesuse: ―Maestro, ¡neca nzeꞌca nú nelluaꞌhua caꞌa! Para nú recheꞌeru chuna ranchu: tucue para liꞌilu, nu stucue para Moisés, nu stucue para Elías. ");
INSERT INTO zplNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Uni Pedro scua xne chiquiꞌ xiqui beella, nu la riꞌilla beyaꞌ xi unilla. ");
INSERT INTO zplNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hora zeꞌe, ulaca tucu xcabe nú uduꞌ xcaꞌlaꞌ equie beella. Nu liñi xcabe zeꞌe, ubeneꞌ beella tucu chi nu uni chi zeꞌe: ―Neca nucuaꞌ lliꞌñia enu chiquiꞌ seꞌcaa, uzuꞌcuꞌhua lunú rninu. ");
INSERT INTO zplNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Che ubiꞌya beella diqui abenchilaꞌ zeꞌe, nu lecaꞌ tinuꞌ zeꞌe stucu liꞌtsia Jesuse nzu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Chenu enta laca beella dañi zeꞌe, uni Jesuse lubeella nú la ixiuleꞌe beella lu niꞌtucu bee bene lunú ulañiꞌ beella zeꞌe, hasta bichia nú huañi zeca Liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chequie liꞌitsia beella nediyaꞌ beella nucuaꞌ, añinzuca nú rnidichiaꞌ beella lu saꞌa beella xa neca equie nú huañi zecanu. ");
INSERT INTO zplNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nu unidichiaꞌ beella lu Jesuse nú unibeella: ―¿Xi nú rni bee ulaxcuela enu reca leyꞌ Moisés nú enta rluti Elías? ");
INSERT INTO zplNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Che ucuaquinu lubeella: ―Neli nú nzeꞌta rluti Elías, para nú tsúcheꞌella yeene. ¿Nu xinu rni lu ichiꞌ Stichiaꞌ Diose nú chiquiꞌ nehuana zeca liꞌinu enu uxeꞌla Diose cuna nú nibee bene nú lecati necanu? ");
INSERT INTO zplNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero nia luhua nú ubeꞌtala Elías, nu uriꞌi bee bene ye nú niarquiꞌbeei lulla, tucu nú niquie lu ichiꞌ Stichiaꞌ Diose nú zecalla. ");
INSERT INTO zplNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Chequie chenu ubenchilaꞌ beella elu nucuaꞌa beelá bee beneꞌ Jesuse, ulañiꞌ beella nú nucuaꞌa huaxi bee bene zeꞌe, cuna bee beneꞌnu nu rni xuu chiucu chuna bee ulaxcuela enu reca leyꞌ Moisés lubee beneꞌnu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chenu ulañiꞌ bee bene zeꞌe nú nzeꞌta Jesuse, chiquiꞌ uyanu arquiꞌbeei nu xexuꞌu beei uya niꞌbeei malune lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Che unidichiaꞌ Jesuse lubee beneꞌnu nú uninu: ―¿Xi rdichiaꞌnuhua bee benecuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nu ucuaqui tucu bene leta bee bene enu nucuaꞌa zeꞌe nú unilla: ―Maestro, caꞌa nzelayua endua lulu, xne secai ichiaꞌ benechiquiꞌ nu rriꞌi benechiquiꞌ nu la nii. ");
INSERT INTO zplNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Catse elu nzu endua, siꞌqui benechiquiꞌ liꞌi lu yuu nu xiuꞌu lliña ruꞌi, cuna nú tuꞌna racu xaꞌlayai cuna nú xungai. Unia lubee beneꞌlu nú huabeella benechiquiꞌ arquiꞌ endua pero né aca beella. ");
INSERT INTO zplNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Chequie ucuaqui Jesuse nú uninu: ―¡Chiquiꞌ nziti arquiꞌhua nu la chili arquiꞌhua liꞌá! ¿Se xala tiembu rquiꞌña nú tsunua liꞌihua? ¿Nu xa riquilá cuna liꞌihua? Uteyuhua enduꞌ cuaꞌ caꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Che uriñayu bee bene enduꞌ zeꞌe lu Jesuse. Pero chenu ulañiꞌ benechiquiꞌ Jesuse, uriꞌi benechiquiꞌ tucu ichia ziña lu enduꞌ zeꞌe, nu uzanaꞌi lu yuu nu nzendulai nu xiuꞌu lliña ruꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Chequie unidichiaꞌ Jesuse lu paꞌ enduꞌ zeꞌe: ―¿Hasta xunga seca enduꞌlu scua? Nu ucuaqui paꞌ enduꞌ zeꞌe: ―Hasta chenu lleꞌnai secai scua. ");
INSERT INTO zplNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Huaxi bese utsiꞌqui benechiquiꞌ endua luquii cuna lu inza, para nú atii. Enzeꞌe tunu nuꞌ modo nú acalu uriꞌi elietsa luru, nu uhuaꞌa arquiꞌ liꞌiru. ");
INSERT INTO zplNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Che uni Jesuse: ―¿Xinú rnilu tunu acaa? ¡Yeene acane para bee bene enu chili arquiꞌ liꞌá! ");
INSERT INTO zplNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chequie urixiali paꞌ enduꞌ zeꞌe nú unilla: ―Chili arquia liꞌilu. ¡Uriꞌi elietsa lua para nú chililá arquia liꞌilu! ");
INSERT INTO zplNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Chenu ulañiꞌ Jesuse nú rieteꞌsaꞌlá huaxi bee bene zeꞌe, che uquiꞌyaꞌ benechiquiꞌ zeꞌe uriꞌinu, nu uninu lui: ―Benechiquiꞌ enu rriꞌi nú la nii bene cuna nú rriꞌi nú nenguataꞌ bene, nibiyaꞌa nú chiuꞌulu arquiꞌ enduꞌ quieꞌ nu la benchilaꞌlu stucu bese arquiꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chequie ubixialí benechiquiꞌ zeꞌe, nu uriꞌi ichia ziñia lu enduꞌ zeꞌe. Nu chu uchiuꞌi arquiꞌ enduꞌ zeꞌe, utsaꞌnai endu zeꞌe xi neca tucu bene enu unguti, che uni bee bene nú ungutila enduꞌ cuaꞌ nee. ");
INSERT INTO zplNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero chu unaꞌtse Jesuse ya enduꞌ zeꞌe, nu uletsanui nu chu utsulii. ");
INSERT INTO zplNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Che uyuꞌu Jesuse cuna bee beneꞌnu liñi niꞌi, nu unidichiaꞌ beella lunu: ―¿Xinu né acaru ahuaru benechiquiꞌ arquiꞌ enduꞌ cuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nu ucuaqui Jesuse lubeella: ―Para nú chiuꞌu clasiaꞌ benechiquiꞌ cuaꞌ rquiꞌña nú deteꞌhua bichia nú la acuhua nu nacuꞌhua lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chenu uchiuꞌu beella zeꞌe, udete beella lu iliu Galilea. Pero la niarquiꞌ Jesuse nú acabiyaꞌ bee bene nú udete beella enza zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","xne rixiuleꞌetsianu lubee beneꞌnu nú uninu lubeella: ―Liꞌá Bene enu uxeꞌla Diose deteꞌ cuenda bee bene liꞌá lubee bene, para nú úti beei liꞌá, pero acatsia bichia rriuna huañi zecaa. ");
INSERT INTO zplNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lá riꞌi bee beneꞌnu beyaꞌ lunú uninu scua, nu ulliqui beella a nacuꞌ dichiaꞌ beella lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Chenu uriña beella Capernaum. Uriña beella tucu niꞌi, che unedichiaꞌ Jesuse lubee beneꞌnu: ―Xi rdichiaꞌhua chenu nzelaꞌahua lu inziu. ");
INSERT INTO zplNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero ne cuaqui beella, xne chenu enta beella lu inziu unibeella lu saꞌa beella nú taa beella enu máse neca equie. ");
INSERT INTO zplNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chequie uzucu Jesuse, nu ubixianu chiꞌchiucu bee beneꞌnu nu uninu lubeella: ―Tunu nuꞌta tucuhua enu niarquiꞌ nú aca neca equie letahua, rquiꞌña nú aca nzeꞌe tucu bene enu lecati neca cuna nú zibiꞌ nzeꞌe lu yehua. ");
INSERT INTO zplNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nu chu unaꞌtsenu tucu enduꞌ utsunu labe beella, nu uchiꞌchinu enduꞌ zeꞌe nu uninu lubeella: ");
INSERT INTO zplNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Tatse bee bene enu riꞌi elietsa lu tucu enduꞌ equie cuendaꞌ liꞌá, neca xi neca nú rriꞌi nzeꞌe elietsa lua, nu la riꞌilla elietsa lu liꞌitsia, leꞌca rriꞌilla elietsa lu liꞌinu enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Che uni Juan lu Jesuse: ―Maestro, ulañiꞌru tucu bene rlua benechiquiꞌ arquiꞌ tucu bene equie nú recalu, pero ucaru nú riꞌilla scua xne la acalla bene letaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Chequie ucuaquinu nú uninu: ―La cáhua nucuaꞌ, xne bene enu rriꞌi milagro equie nú recaa la zeꞌta nzeꞌe liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bene enu lani condra liaꞌahua, nzu nzeꞌe chuaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tatse bee bene enu liquiꞌ masia tucu basu inza luhua lunú necahua beneꞌ Cristo, neli nia luhua nú yucu bene zeꞌe lunú deteꞌ Diose lulla. ");
INSERT INTO zplNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Tatse bene enu riꞌi nú riꞌi tucu bene dula enu apenatsia nzeli arquiꞌ liꞌá, máse neca nzeꞌca lu cuendaꞌ bene zeꞌe nú quieꞌe bene tucu quiee molino añilla nu tsiꞌqui bee bene liꞌilla lu inzatuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tunu rriꞌi yalu nú rriꞌilu dula, mejora uchieꞌcuꞌe, máse neca nzeꞌca nú chuꞌulu liñibe cuna tucutsia yalu, tunu chuꞌulu ebila cuna rucu yalu, elu leca modo nú yala quii. ");
INSERT INTO zplNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Zeꞌe la ati bee berecuꞌ, cuna nú leca xunga yala quii zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tunu rriꞌi cuchiuꞌlu nú rriꞌilu dula, mejora uchieꞌcuꞌe xne máse neca nzeꞌca nú chuꞌulu liñibe cuna tucutsia cuchiuꞌlu, tunu chuꞌulu ebila cuna rucu cuchiuꞌlu elu leca modo nú yala quii. ");
INSERT INTO zplNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Elu la ati bee berecuꞌ nu leca xunga yala quii zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Leꞌca tunu rriꞌi iꞌcululu nú rriꞌilu dula, mejora uhuane, xne máse neca nzeꞌca nú chuꞌlu liñibe cuna tucutsia iꞌcuꞌlulu, nú chuꞌulu ebila cuna rucu iꞌcuꞌlulu, ");
INSERT INTO zplNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","elu la ati bee berecuꞌ nu leca xunga yala quii zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Tucu nú sibiꞌ zete nú riuꞌe equie elubacu leꞌca esquie sibiꞌ nú nehuana zeca bee bene enu nzeli arquiꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Zete neca nzeꞌcae; pero tunu niti nú neriꞌi, ¿xa riꞌihua para nú aca zecae tucu nú necane para nú zibiꞌi? Uriꞌihua tucu nú neli neca para nú la zecahua xi neca zete nú la zibiꞌ, nu uhuañi nzeꞌcahua cuna bee saꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Che uchiuꞌu Jesuse Capernaum nu uyanu lu iliu Judea cuna stucu chú reꞌcu Jordán. Zeꞌe uyetesaꞌ zeca huaxi bee bene lunu, nu uquixienu seteꞌnu liꞌibeei tucu nú neca costumbreꞌnu nú rriꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Che uyabica chiucu chuna bee fariseo lu Jesuse, para nú riꞌi beei preo liꞌinu, nu unidichiaꞌ beei lunu tunu nuꞌ modo leꞌe tucu niyu unaꞌi. ");
INSERT INTO zplNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Chequie ucuaqui Jesuse nú uninu lubeei: ―¿Xa unibiyaꞌ Moisés nú riꞌihua? ");
INSERT INTO zplNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nu unibeei lunu: ―Uni Moisés nú nuꞌ modo leꞌe tucu niyu unaꞌi tunu acacheꞌ tucu ichiꞌ elu rni nú uleꞌe saꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Che uni Jesuse lubeei: ―Uni Moisés nú acane scua xne chiquiꞌ nziti arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero chenu uquixie Diose urecheꞌ yeene, “urecheꞌnu niyu cuna unaꞌa”. ");
INSERT INTO zplNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Enzeꞌe chenu uyucu niyu tucu unaꞌa tsaꞌnai paꞌi cuna naꞌi, para nú huañii cuna unaꞌtsiai. ");
INSERT INTO zplNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Che rucu beei aca beei xi neca tucutsia bene.” Scua la neca beei xi neca chiucu bene necatsia beei tucu bene. ");
INSERT INTO zplNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Enzeꞌe la quiꞌña nú leꞌe bene lunú uriꞌi Diose nú uyetesaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chenu uyuꞌu beella liñi tucu niꞌi, unidichiaꞌ zeca bee beneꞌ Jesuse lunu equie nú uninu scua lubee fariseo. ");
INSERT INTO zplNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nu uni Jesuse lubeella: ―Tatse niyu enu leꞌe unaꞌa nu yucui stucu unaꞌa, rriꞌi dula. ");
INSERT INTO zplNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Leꞌca esquie tunu leꞌe tucu unaꞌa niyunchu nu yucunchu stucu niyu, rriꞌinchu dula. ");
INSERT INTO zplNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Uyayu bee bene bee enduꞌ lu Jesuse, para nú ricuꞌnu yanu equie bee enduꞌ, pero uquiꞌyaꞌ bee bene enu ubeꞌtayu bee enduꞌ zeꞌe uriꞌi bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chenu ulañiꞌ Jesuse nucuaꞌ, uleenu nu uninu: ―Utsanaꞌhua nú yeꞌta bee enduꞌ lua, nu la cáhua nú yeꞌta beei lua, xne lunú rnibiyaꞌ Diose neca para bee bene enu neca xi neca bee enduꞌ quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ixiuleꞌa luhua tunu la chili arquiꞌ bene lunú rnibiyaꞌ Diose xi nzeli arquiꞌ tucu endu, la chuꞌu bene cuaꞌ lunú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Che uchiꞌchinu bee enduꞌ zeꞌe, nu uricuꞌnu yanu equie beei nu uriꞌileꞌyanu liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chenu uchiuꞌu Jesuse nú nzanu, uriña xuꞌu tucu niyu lunu, nu utsulliquii lunu nu unidichiaꞌi: ―Maestro enu neca bene nzeꞌca, ¿xi rquiꞌña riꞌá para nú luꞌcua elunehuañi nú leca xunga laxu liñibe? ");
INSERT INTO zplNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Chequie ucuaqui Jesuse nú uninu: ―¿Xinu rnilu nú neca bene nzeꞌca? Leca niꞌtucu bene nzeꞌca tucutsia Diose neca bene nzeꞌca. ");
INSERT INTO zplNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nediyaꞌlaꞌlu bee mandamiento: “La útilu bene, nu la luꞌculu stucu unaꞌa, la riꞌilu eluhuanaꞌ, la taꞌlu eluquichiaꞌ bene, nu la zequienúlu bene, luꞌculu ulaꞌna lu paꞌlu cuna lu naꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Che ucuaqui niyu zeꞌe nú uni: ―Maestro, ye bee nucuaꞌ sucua hasta chenu neca enduꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chequie ubiꞌya Jesuse lu niyu zeꞌe nu uzecanui, nu uninu lui: ―Pero rriꞌitsia tucu nú riꞌilu nee, uquia tuti ye beenú rluꞌculu nu deteꞌlu dimi cuaꞌ lubee bene enu seca elitsi. Nu scua luꞌculu eluxene liñibe. Nu chu yeꞌtalu cuna liꞌá mase ulleꞌcalu lunú ulleꞌcalu. ");
INSERT INTO zplNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chenu ubeneꞌ niyu zeꞌe nucuaꞌ, chiquiꞌ utsu nehuana arquiꞌi nziai, xne necai tucu bene enu chiquiꞌ xene. ");
INSERT INTO zplNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Che ubiꞌya Jesuse luye bee bene zeꞌe, nu uninu lubee beneꞌnu: ―¡Chiquiꞌ neriñá nú chuꞌu bee bene xene lunú rnibiyaꞌ Diose! ");
INSERT INTO zplNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chiquiꞌ uyanu arquiꞌ bee beneꞌnu nu uninu scua, pero uni zecanu lubeella stucu bese nú uninu: ―Bee llianaꞌa, ¡tucu bene enu mase nchiñi arquiꞌ lubee eluxeneꞌ, chiquiꞌ neriñaꞌ nú chuꞌulla lunú rnibiyaꞌ Diose! ");
INSERT INTO zplNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","La aca neriñaꞌ nú dete tucu camello tucu iꞌchiuꞌ eche dicu, luquela nú chuꞌu tucu bene xene lunú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pero chenu ubeneꞌ bee beneꞌnu nucuaꞌ, masescaꞌlá uyanu arquiꞌbeella, nu unidichiaꞌ beella lu saꞌbeella: ―¿Ti riꞌi Diose perdona, che? ");
INSERT INTO zplNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chequie ubiꞌya Jesuse lubeella nu uninu lubeella: ―Para bee bene neriñaꞌ neca nucuaꞌ, pero para Diose la neriñaꞌ neca nucuaꞌ, xne yeene recanu rriꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Che uni Pedro lu Jesuse nú unilla: ―Utsaꞌnaru ye nú rluꞌcuru, para nú nzela quieeru liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nu ucuaqui Jesuse nú uninu: ―Ixiuleꞌa luhua nú tatse bene enu tsaꞌna niꞌi, urre bichilla, urre zanalla, urre paꞌlla, urre naꞌlla, urre niyuꞌlla, urre unaꞌlla, urre bee enduꞌlla, urre bee yuꞌlla, equie cuendaꞌ liꞌá cuna equie cuendaꞌ bedichiaꞌ nzeꞌcaꞌ Diose, ");
INSERT INTO zplNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yucu bene zeꞌe lu iliulabe quieꞌ tucu ayuꞌu bese mase lunú utsaꞌnalalla, tunu necane niꞌlla, urre bichilla, urre zanalla, urre naꞌlla, urre bee enduꞌlla, urre bee yuꞌlla, añinzuca nú tsiꞌlla lunú zecalla, pero yuculla bee nucuaꞌ nu luꞌculla elunehuañi nú leca xunga laxu liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero huaxi bee bene enu chiquiꞌ neca equie nee, aca bee nzeꞌe enu lecati neca, nu bee bene enu lecati neca, aca bee nzeꞌe enu chiquiꞌ aca neca equie. ");
INSERT INTO zplNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chenu nzuebeella enza Jerusalén, nzuculu Jesuse lubee beneꞌnu. Nu chiquiꞌ nzenu arquiꞌbeella, nú nzanu Jerusalén, pero beelá bee bene enu nzequie liꞌinu, chiquiꞌ xiqui beella. Che ubixia Jesuse chiꞌchiucu bee beneꞌtsianu, nu udixiuleꞌenu lubeella lunú zecanu. ");
INSERT INTO zplNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nu uninu lubeella: ―Nediyaꞌhua nú nzaꞌahua enza Jerusalén nee, zeꞌe liꞌá Bene enu uxeꞌla Diose deteꞌ cuenda bee bene liꞌá lubee uleꞌya enu rnibiyaꞌ lu beelá bee uleꞌya, cuna lubee ulaxcuela enu reca leyꞌ Moisés nu nibiyaꞌ bee benequieꞌ nú atia, cuna nú deteꞌ cuenda bee bene cuaꞌ liꞌá lubee bene enu la neca bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Che lliꞌchinu bee bene liꞌá, cuna nú zeteꞌcheꞌ beei liꞌá, cuna nú tsuxene beei lua, cuna nú úti beei liꞌá, pero acatsia bichia rriuna huañi zecaa. ");
INSERT INTO zplNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chequie uyabica Jacobo cuna Juan lu Jesuse, neca beella llianaꞌ Zebedeo, nu unibeella lu Jesuse: ―Maestro, niarquiꞌru nú riꞌilu tucu faura nú nacuꞌru lulu. ");
INSERT INTO zplNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nu ucuaqui Jesuse lubeella: ―¿Xi niarquiꞌhua nú riꞌá luhua? ");
INSERT INTO zplNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nu uni beella: ―Niarquiꞌru nú liquiꞌlu nú zucu tucuru cueꞌtselu chubee cuna nú zucu stucuru cueꞌtselu chubeca chenu quixie nú nibiyaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero ucuaqui Jesuse lubeella: ―La riꞌihua beyaꞌ lunú rnacuꞌhua. ¿Xieꞌ riquiꞌhua nehuana zecahua tucu nú nehuana zeca la? ¿Nu xieꞌ zelahua atihua tucu nú atia la? ");
INSERT INTO zplNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nu ucuaqui beella lunu: ―Riquiꞌru nucuaꞌ. Che uninu lubeella: ―Neli nú nehuana zecahua tucu nú nehuana zecaa nu atihua tucu nú atia. ");
INSERT INTO zplNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero lunú ti zucu cueꞌtsea chúbee cuna cueꞌtsea chúbeca la luꞌcua cuendaa nú liquia nucuaꞌ luhua, xne necatsia nucuaꞌ para bee bene enu rialane. ");
INSERT INTO zplNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chenu ubeneꞌ se xiꞌi bee beneꞌnu nucuaꞌ, ulee beella lu Jacobo cuna lu Juan. ");
INSERT INTO zplNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Che ubixia Jesuse liꞌibeella, nu uninu lubeella: ―Nediyaꞌhua nú bee bene enu rnibiyaꞌ lu iliulabe rnibiyaꞌ beei tucu nú niarquiꞌtsia beei, nu bee bene enu chiquiꞌ neca equie scua rriꞌi beei lubee bene tucu nú niarquiꞌtsia beei, equie nú rnibiyaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero letahua la yala nú acane scua. Enu niarquiꞌ nú nibiyaꞌ luhua, rquiꞌña nú zibiꞌ nzeꞌe lu yehua. ");
INSERT INTO zplNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tatsehua enu niarquiꞌ nú mase aca neca equie letahua, rquiꞌña nú aca nzeꞌe xi neca musoꞌ lu yehua. ");
INSERT INTO zplNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Xne niꞌ liꞌá Bene enu uxeꞌla Diose né yela para nú zibiꞌ bee bene lua, ubela para nú zibiaꞌa lubee bene cuna nú atia para nú ixiua stula huaxi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chequie uriña Jesuse cuna bee beneꞌnu eyeche Jericó. Chenu nzechiuꞌu beella eyeche cuaꞌ, cuna huaxilá bee bene, che nzucu tucu niyu enu niquieꞌlu ruꞌu inziu zeꞌe rnacuꞌi carida nu Bartimeo leei, necai llianaꞌ tucu bene enu lee Timeo. ");
INSERT INTO zplNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chenu ubeneꞌi nú axula enta Jesuse bene eyeche Nazaret, uquixiei urixialii nú uni: ―¡Jesuse enu neca llianaꞌ David, uhuaꞌa arquiꞌ liꞌá! ");
INSERT INTO zplNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Huaxi bee bene rriꞌi nú rquiꞌyaꞌi para nú zacai, pero aꞌla mase rixialii nú uni: ―¡Llianaꞌ David, uhuaꞌa arquiꞌ liꞌá! ");
INSERT INTO zplNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chequie utsuxe Jesuse, nu uninu lubeella: ―Ubixiahua benecuaꞌ nú yeꞌtalla. Che ubixia beella niyu enu niquieꞌe lu zeꞌe, nu unibeella lui: ―Ñia utsu arquiꞌ, nu utsuli, xne rixianu liꞌilu nee. ");
INSERT INTO zplNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nu chu utsiꞌquii lluꞌchai, rtetsai uyabicai lu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chequie unidichiaꞌ Jesuse nú uninu lui: ―¿Xi niarquiꞌlu nú riꞌá lulu? Nu ucuaqui niyu enu niquieꞌlu zeꞌe nú uni: ―Maestro, niarquia nú riꞌilu nú yaꞌla nú biꞌya zecaa. ");
INSERT INTO zplNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Che uni Jesuse lui: ―Nuꞌ modo nú yalu nee, uyecaꞌlaꞌlu equie nú utsu tenelí arquiꞌlu lua. Hora zeꞌe uyeꞌe lu niyu enu niquieꞌlu zeꞌe, nu chu nzequiei Jesuse lu inziu nú nzanu. ");
INSERT INTO zplNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Chenu nzeriña beella axu Jerusalén, elu nchiucuꞌ bee eyeche nú lee Betfagé cuna Betania, eꞌya dañi nú lee Olivos, uxeꞌla Jesuse chiucu beneꞌnu, ");
INSERT INTO zplNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nu uninu lubeella: ―Uquiahua eyeche axu nú nchiucuꞌ enza luaꞌahua, chenu riñahua eyeche cuaꞌ, zeꞌe nequietu tucu burro, enu lascaꞌ ricu bee bene. Uxeꞌchehuaií nu yeꞌta yuhuaí caꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tunu nuꞌ enu nedichiaꞌ luhua xi nu xeꞌchehuaí, uniꞌhua lu bene zeꞌe nú Jesuse enu rnibiyaꞌ luru rquiꞌñanuí nu nee chu nzela yuzecaruí. ");
INSERT INTO zplNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chequie nzuebeella, nu ullelaꞌ beella elu nequietu tucu burro ruꞌu inziu, axu ruꞌu puertaꞌ tucu niꞌi, nu chu uxeꞌche beellaí. ");
INSERT INTO zplNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Texcuaꞌa bee bene enu ulañiꞌ nucuaꞌ zeꞌe unidichiaꞌbeei lubee beneꞌ Jesuse nu unibeei: ―¿Xi rriꞌihua caꞌa? ¿Xi nú xeꞌchehua burro cuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Che ucuaqui beella lubee bene zeꞌe tucu nú uni Jesuse lubeella nú nibeella, esquie uzela bee bene zeꞌe nú unguyaꞌ beella burro zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Che uriñayu beella burro zeꞌe lu Jesuse. Nu uricuꞌ beella xucu beellaequieí, nu chu uricu Jesuse equieí ");
INSERT INTO zplNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Leꞌca ucuaꞌa huaxi bee bene xucu beei lu inziu elu detenu, nu texcuaꞌa beei uchiecuꞌ leca ucuaꞌa beei lu inziu elu detenu. ");
INSERT INTO zplNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Chequie bee bene enu nzuculu lunu cuna bee bene enu nzeꞌtaquie liꞌinu, rixiali beei nú unibeei: ―¡Chiquiꞌ neca equie nú rriꞌi Diose! ¡Cheꞌtsalá Diose equie cuendaꞌ liꞌinu enu nzeꞌta lu cuendaꞌ Diose! ");
INSERT INTO zplNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Cheꞌtsalá Diose equie cuendaꞌ liꞌinu enu nzeꞌta nú nibiyaꞌ, tucu nú unibiyaꞌ arre David beneꞌahua enu udetela! ¡Chiquiꞌ neca equie nú rriꞌi Diose liꞌinu enu nzucu liñibe! ");
INSERT INTO zplNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Che uyuꞌu Jesuse eyeche Jerusalén nu uyuꞌunu liñi indu llene Jerusalén. Chenu ulaxu nú ubiꞌyanu ye nú nuꞌ zeꞌe chu nzanu eyeche Betania cuna chiꞌchiucu bee beneꞌnu, xne ucheela bichia zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bichia rrucu, chenu nze chiuꞌu beella eyeche Betania, uquixie nú ulianaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Istu ulañiꞌnu tucu aca higuera nu nuꞌ leca niyeꞌe lue, nu chu uyabicanu lue tunu ca nuꞌ higo lue acunu, pero leca ndixi lue nuꞌtsia leca lue, xne la aca tiembu nú rayue. ");
INSERT INTO zplNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chequie uni Jesuse lu aca higuera zeꞌe: ―¡Lecaꞌ xunga acu bene ndixi nú rayu lulu! Ubeneꞌ bee beneꞌnu nú uninu scua. ");
INSERT INTO zplNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chenu uriña beella eyeche Jerusalén, uyuꞌu Jesuse ruꞌu eleꞌyaꞌ Indu llene Jerusalén nu uquixienu uluanu bee bene enu ruti cuna bee bene enu sii zeꞌe. Nu utelletanu mexaꞌ bee bene enu xiꞌla dimi cuna nú utsiꞌquinu xletaꞌ bee bene enu ruti bee paloma zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","né zelanu nú achuꞌu nulá bee bene steneꞌ beei ruꞌu eleꞌyaꞌ indu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Che uquixie Jesuse nú uzeteꞌnu bee bene, nu uninu lubeei: ―Lu ichiꞌ Stichiaꞌ Diose rni: “Nia neca elu chiuꞌulee elu nacuꞌ ye bee bene iliulabe lu Diose”; pero liꞌihua rriꞌihua nia xineca yubeꞌ elu rcuaꞌa bee huanaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chenu ubeneꞌ bee uleꞌya enu rnibiyaꞌ lu beelá bee uleꞌya cuna bee ulaxcuela enu reca leyꞌ Moisés nucuaꞌ, uquixie rlaꞌna beei xa modo útibeei Jesuse xne xiqui beei liꞌinu lunú rriꞌinu, xne chiquiꞌ nzenu arquiꞌ ye bee bene lunú seteꞌnu liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pero chenu nzeꞌta chuꞌu rulaꞌ, uchiuꞌu Jesuse cuna bee beneꞌnu eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Stucu bichia silaꞌ udete beella elu nzucu aca higuera zeꞌe, nu ulañiꞌ beella nú ubichi aca zeꞌe hasta luue. ");
INSERT INTO zplNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chequie ulluꞌcu arquiꞌ Pedro, nu unilla lu Jesuse: ―Maestro, ubiꞌyacuru, ubichila aca higuera nú unilu nú bichi. ");
INSERT INTO zplNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nu ucuaqui Jesuse nú uninu: ―Uchili arquiꞌhua Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Xne neli nia luhua, nú tatse bene enu ni lu dañi quieꞌ: “¡Ullunaꞌ caꞌa nu uzanaꞌ lu inzatuꞌ!”, tunu la zaꞌ arquiꞌlla chenu nilla scua, aca nú unilla scua che. ");
INSERT INTO zplNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Enzeꞌe nia luhua nú ye nú nacuꞌhua lu Diose, nu uchili arquiꞌhua nú liquiꞌnu nucuaꞌ che yucuhuane. ");
INSERT INTO zplNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Chenu rnacuꞌhua lu Diose, tunu nuꞌ tucu bene enu rleehua lu uriꞌihua perdona liꞌilla, para nú leꞌca esquie Diose Paꞌahua enu nzucu liñibe riꞌinu perdona liꞌihua equie cuendaꞌ stulahua. ");
INSERT INTO zplNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Xne tunu la riꞌihua perdona bee bene, leꞌca la riꞌi Diose Paꞌahua enu nzucu liñibe perdona liꞌihua equie cuendaꞌ stulahua. ");
INSERT INTO zplNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chenu uriña beella eyeche Jerusalén. Diqui nú enzee Jesuse liñi Indu llene Jerusalén, uriña bee uleꞌya enu rnibiyaꞌ lu beelá bee uleꞌya lunu, cuna bee ulaxcuela enu reca leyꞌ Moisés cuna bee usticiaꞌ bee bene Israel, ");
INSERT INTO zplNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nu unidichiaꞌ beei lunu: ―¿Ti uliquiꞌ elu usticia nú rriꞌilu scua? ¿Nu ti uliquiꞌ elu rnibiyaꞌ nú rriꞌilu scua? ");
INSERT INTO zplNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Che ucuaqui Jesuse nú uninu: ―Leꞌca nidichiaꞌa luhua tucu bedichiaꞌ tunu cuaquihua nucuaꞌ, che ixiuleꞌa luhua ti uliquiꞌ elurnibiyaꞌ nú rriꞌá scua. ");
INSERT INTO zplNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ti uxeꞌla Juan Bautista? ¿Uxeꞌla Diosella la urre uxeꞌla bee benella la? Ucuaquihua nee. ");
INSERT INTO zplNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Che uquixie beei nú ubedichiaꞌnu saꞌbeei nú unibeei: ―Tunu niaꞌahua nu Diose uxeꞌla Juan Bautista, che ni nucuaꞌ: “¿Xinu né chili arquiꞌhua liꞌilla che?” ");
INSERT INTO zplNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Leca modo nú niaꞌahua nú bene uxeꞌla liꞌilla? Unibeei scua xne xiqui beei bee bene, xne ye bee bene nzeli arquiꞌ nú unga Juan tucu profeta enu neli udixiuleꞌe Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nu ucuaqui beei lu Jesuse: ―La riꞌiru beyaꞌ ti uxeꞌlalla. Che ucuaqui Jesuse nú uninu lubeei: ―Leꞌca la ixiuleꞌa ti uliquiꞌ elurnibiyaꞌ nú rriꞌá scua che. ");
INSERT INTO zplNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Chequie uquixie Jesuse nú uninu puro bee ejemplu lubee bene zeꞌe. Nu uninu: ―Tucu niyu uquienii bee aca uva lu yuꞌlla nu uduꞌlla eluꞌ diqui abenchilaꞌe, nu urecheꞌella tucu elu tsiꞌilla bee uva, nu urecheꞌella tucu elu ayaa zucu bene enu riꞌi ucu yeene. ’Che udeteꞌlla yuu zeꞌe lleꞌla lubee bene, enu riꞌi riñaꞌ lue, nu chu nzalla enza istu zuculla. ");
INSERT INTO zplNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chequie chenu uriña tiembu nú aca ulaꞌcu bee uva, uxeꞌla niyu zeꞌe tucu mosoꞌlla nze tucu lunú rialalla. ");
INSERT INTO zplNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero unaꞌtse bee bene zeꞌe mosoꞌ zeꞌe, nu udiñi beei liꞌilla nu uxeꞌla beei liꞌilla scuatsia. ");
INSERT INTO zplNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Che uxeꞌla bene enu neca steneꞌ yuu zeꞌe stucu mosoꞌlla lubee bene zeꞌe, pero mosoꞌ zeꞌe utiꞌqui beei cuna nú udiquichiꞌquiꞌ beei liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Uxeꞌlalla stucu mosoꞌlla lubee bene zeꞌe, pero mosoꞌ quieꞌ unguuti beei. Huaxi bee mosoꞌ uxeꞌlalálla, texcuaꞌa bee mosoꞌ quieꞌ uzeteꞌcheꞌ beei nu texcuaꞌa beella unguuti beei. ");
INSERT INTO zplNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Chequie bene enu neca stene yuu zeꞌe, rriꞌitsia nú xeꞌlalla llianaꞌlla, enu chiquiꞌ secaalla. Xne uriꞌilla elliebacuꞌ nú unilla: “Neli nzu arquia nú luꞌcu bee benecuaꞌ ulaꞌna lu llianaꞌa.” ");
INSERT INTO zplNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero uni bee bene zeꞌe lu saꞌbeei: “Bene quieꞌ neca enu yaꞌnanu yuu quieꞌ, té utiaꞌahua liꞌi, para nú yaꞌna nuaꞌahua yuu quieꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Che unaꞌtse beei llianaꞌ bene enu neca stene yuu zeꞌe, nu unguuti beei llianaꞌlla nu utsiꞌqui beei llianaꞌlla stucu luhuare. ");
INSERT INTO zplNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nu unidichiaꞌ Jesuse nú uninu: ―¿Xa rriꞌihua elliebacuꞌ nú riꞌi bene enu neca stene yuu zeꞌe? Puese nia luhua nú nzeꞌtalla nu útilla bee benecuaꞌ nu deteꞌlla yuꞌlla lu texcuaꞌa bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Xieꞌ lascaꞌ ulahua lu ichiꞌ Stichiaꞌ Diose elu rni? Quiee nú uhua uꞌna bee bene enu rrecheꞌe niꞌi, quiee quieꞌ neca nú mase uzibiꞌ ungacheꞌ niꞌi zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nucuaꞌ neca nú uriꞌi Diose, nu chiquiꞌ nzenu arquiꞌru nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chequie chenu ubeneꞌ bee bene enu rnibiyaꞌ lunú uni Jesuse scua, niarquiꞌbeei nú naꞌtse beei liꞌinu para nú chánu niꞌcuꞌ, pero lunú xiqui beei bee bene utsanaꞌ beei liꞌinu nu chu nzuebeei. ");
INSERT INTO zplNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Che uxeꞌla bee bene, enu rnibiyaꞌ zeꞌe chiucu chuna bee fariseo cuna chiucu chuna bee beneꞌ Herodes lu Jesuse, para nú laꞌna beei xa modo ninu tucu bedichiaꞌ para nú nuꞌ modo riꞌi condra beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chenu uriña bee benequieꞌ lu Jesuse unibeei lunu: ―Maestro, nediyaꞌru nú rnilu nú neli neca, nu la riꞌilu caso nú xa neca bee bene, xne lulu neca tucu necatse bee bene. Nu neli seteꞌlu bee bene lunú rnibiyaꞌ Diose nú xa huañi bee bene. Enzeꞌe rnidichiaꞌru lulu. ¿Neca nzeꞌca nú dixiuru impuesto lu arre César la?, urre ¿la neca nzeꞌcae la? ¿Dixiuru la urre la dixiuru la? ");
INSERT INTO zplNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero uriꞌi Jesuse beyaꞌ, lunú lia unitsia beei scua, nu uninu lubeei: ―¿Xi nú rriꞌihua preo liꞌá scua? Uliꞌquihua tucu melu para nú lañine. ");
INSERT INTO zplNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Che uriñayuu bee bene zeꞌe tucu melu lu Jesuse, nu uninu lubeei: ―¿Tiluu nzucu lu melu quieꞌ nu ti lee enu nzucu lue? Nu ucuaqui beei nú unibeei lunu: ―Lu arre César. ");
INSERT INTO zplNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chequie ucuaqui Jesuse nú uninu: ―Udeꞌteꞌhua lunú neca cuendaꞌ César lu César, nu udeꞌteꞌhua lunú neca cuendaꞌ Diose lu Diose. Nu chiquiꞌ uyanu arquiꞌbeei chenu ucuaquinu scua. ");
INSERT INTO zplNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Che uya texcuaꞌa bee saduceo lu Jesuse. Xne rnibeei nú la huañi zeca bee bene enu unguti nu unidichiaꞌ beei lunu: ");
INSERT INTO zplNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, rni leyꞌ Moisés nú tunu ati tucu niyu nu utsaꞌnalla unaꞌalla nu né luꞌcu beella enduꞌ, che yucu bichi tuxie zeꞌe unaꞌa zaqui zeꞌe, para nú luꞌcu beei enduꞌ enu neca xi neca enduꞌ tuxie zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ucuaꞌa achi bichi bene, bichi rlu beei uyucu unaꞌa, pero ungutilla, nu né luꞌcu unaꞌlla enduꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chequie uyucu bichi rrucu beei unaꞌa zaqui zeꞌe, pero leꞌca esquie ungutilla, nu né luꞌcu unaꞌa zeꞌe enduꞌlla, leꞌca esquie ulleꞌca bichi rriuna beei. ");
INSERT INTO zplNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Scua unga lu achi beei, uyucu beei unaꞌa zeꞌe, pero niꞌ tucu beei né luꞌcu beei enduꞌ cuna unaꞌa zeꞌe, che unguti unaꞌa zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Puese chenu huañi zeca bee bene enu unguti, lu achi bichi beei, ¿ta beei neca niyuꞌ unaꞌa cuaꞌ xne lu achi bichi beei uyucu beei unaꞌa cuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nu ucuaqui Jesuse lubeei nú uninu: ―Lixiu nchiñi elliebacuꞌhua, xne la acahua Stichiaꞌ Diose nu la chuluhua xa neca lunú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Xne chenu huañi zeca bee bene enu unguti, la yucuaꞌ bee bene saꞌ bee bene nu lecaꞌ eluxia zeꞌe. Acatsia bee bene xi neca bee ángele liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Equie nú huañi zeca bee bene enu unguti, ¿xieꞌ lascaꞌ ulahua lu libroꞌ Moisés elu rni nú ulañiꞌlla tucu aca nú riqui la? Zeꞌe ubeneꞌlla chii Diose nú uninu: “Liꞌá neca Diose, lu Abraham, cuna lu Isaac, cuna lu Jacob.” ");
INSERT INTO zplNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Enzeꞌe nia luhua núla necanu Diose lubee bene enu unguti! Necanu Dioseꞌ bee bene enu nehuañi. Xne para liꞌinu ye bee bene nehuañi. Chiquiꞌ lixiu nchiñi elliebacuꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chenu ubeneꞌ tucu bee ulaxcuela enu reca leyꞌ Moisés nú ucuaqui nzeꞌca Jesuse, lubee benecuaꞌ uyabicai lu Jesuse nu unidichiaꞌi lunu: ―¿Ta mandamiento nú máse neca equie? ");
INSERT INTO zplNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Che ucuaqui Jesuse nú uninu: ―Mandamiento nú máse neca equie rni: “Ubeneꞌhua bee bene Israel, liꞌinu enu neca Dioseꞌahua tucutsia necanu. ");
INSERT INTO zplNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Uzeca liꞌinu enu neca Dioseꞌlu diquinuꞌ arquiꞌlu, cuna diquinuꞌ lunú necalu, cuna diquinuꞌ elliebacuꞌlu cuna diqui nuꞌ juerzaꞌlu.” Ninguieꞌ neca mandamiento nú máse neca equie. ");
INSERT INTO zplNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nu mandamiento rrucu neca: “Zecalu saꞌlu tucu nú secalu liꞌilu.” Lu rucu bee mandamiento quieꞌ, leca stucu mandamiento nú máse neca equie. ");
INSERT INTO zplNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chequie ucuaqui ulaxcuela enu reca leyꞌ Moisés zeꞌe nú uni: ―Maestro, uni nzeꞌcalu. Nú unilu scua. Neli nú unilu nú nuꞌ tucutsia Diose, lecaꞌ stucu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nu zeca bee bene liꞌinu diquinuꞌ arquiꞌlla, cuna diquinuꞌ elliebacuꞌlla cuna diquinuꞌ juerzaꞌlla, cuna diqui nuꞌ lunú necalla, nu zeca bee bene saꞌ bene tucu nú secalla liꞌilla, ninguieꞌ neca nú máse seca lu ye bee uꞌna nú rdeteꞌ bee bene lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chenu ulañiꞌ Jesuse nú ucuaqui nzeꞌca ulaxcuela enu reca leyꞌ Moisés uninu lui: ―La nzulu istu para nú chuꞌulu lunú rnibiyaꞌ Diose. Che lecaꞌ ti alaca arquiꞌ a nacuꞌdichiaꞌlá lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Chenu seteꞌ Jesuse bee bene liñi indu llene Jerusalén, unidichiaꞌnu lubeei nú uninu: ―¿Xinu rnibee ulaxcuela enu reca leyꞌ Moisés nú neca Cristo lliꞌñi David? ");
INSERT INTO zplNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nu leꞌca liꞌi David unilla bedichiaꞌ quieꞌ, tucu nú udeteꞌ Espíritu Santo lulla nú unilla: Diose uni lu liꞌinu enu rnibiyaꞌ lua: “Uzucu cueꞌtsea chúbee, hasta nú riꞌá nú nibiyaꞌlu lubee bene enu rlee lulu.” ");
INSERT INTO zplNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Enzeꞌe tunu neca Cristo, lliꞌñi David, xinu rni David liꞌinu lunu? Ye bee bene enu nucuaꞌa zeꞌe ñia uyuꞌ arquiꞌbeei lunú uninu. ");
INSERT INTO zplNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Chenu uzeteꞌ Jesuse bee bene uninu lubeei: ―Ubiꞌyahua liꞌihua lubee ulaxcuela enu reca leyꞌ Moisés, xne riuꞌ arquiꞌbeei nú rutu beei xucu nzeꞌca beei, cuna nú riuꞌ arquiꞌbeei nú luꞌcu bee bene ulaꞌna lubeei lu inziu, ");
INSERT INTO zplNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","nu rlaꞌna beei nú sucu beei lu xleta nú máse neca equie liñibe indu, leꞌca scua rriꞌi beei sucu beei elu máse neca equie chenu nze tacu beei. ");
INSERT INTO zplNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Leꞌca raxi beei niꞌi bee unaꞌa zaqui, rriꞌibeei nú xee rnacuꞌ beei lu Diose, para nú riꞌi bee bene elliebacuꞌ nú neca beei bene nzeꞌca pero máse deteꞌ Diose castiya lubeei. ");
INSERT INTO zplNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tucu bese chenu nzucu Jesuse liñi indu llene Jerusalén axu elu nchiucuꞌ bee alcancia elu rduꞌ bee bene uꞌna, ulañiꞌnu nú rduꞌ bee bene uꞌna liñibe alcancia zeꞌe. Leꞌca huaxi bee bene xene rduꞌ beei huaxi dimi liñibe alcancia zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Che uriña tucu unaꞌa zaqui elitsí zeꞌe, nu uduꞌnchu chiucu melu nú lleꞌnatsia seca liñi tucu bee alcancia zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nu chu ubixia Jesuse bee beneꞌnu, nu uninu lubeella: ―Neli nia luhua nú uꞌna nú uduꞌ unaꞌa zaqui elitsí quieꞌ maselá seca nucuaꞌ lunú uduꞌ beelá bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Xne yebee bene rduꞌtsia beei lunú sucu sobra equie dimiꞌbeei, pero unaꞌa zaqui quieꞌ, añinzuca nú secanchu elitsi uduꞌnchu ye nú neca diminchu liñi alcancia zeꞌe, nu añinzuca nú nucuaꞌtsia neca nú rluꞌcunchu. ");
INSERT INTO zplNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Chenu uchiuꞌu Jesuse liñi indu llene Jerusalén, che uni tucu beneꞌnu lunu: ―¡Maestro, ubiꞌyacuru chiquiꞌ ñia rnaa bee quiee quieꞌ cuna niꞌi llene quieꞌ! ");
INSERT INTO zplNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Chequie ucuaqui Jesuse nú uninu: ―Tucu nú rlañiꞌlu niꞌi llene quieꞌ, riña bichia nú la yaꞌnaꞌ niꞌ stucu quiee quieꞌ equie saꞌe yeene rilae. ");
INSERT INTO zplNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Che chu nzuebeella lu tucu dañi nú lee Olivos nzucu dañi quieꞌ enza rna lu indu llene Jerusalén, chenu uzucu Jesuse equie dañi zeꞌe, che uyabica Pedro cuna Jacobo cuna Juan cuna Andrés nu unidichiaꞌ liꞌitsia beella lunu nú unibeella: ");
INSERT INTO zplNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Udixiuleꞌe luru, ¿xunga aca bee nucuaꞌ? ¿Nu xa neca bee seña nú lubeꞌ nú nzula nú aca ye bee nucuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Chequie ucuaqui Jesuse lubeella nú uninu: ―Ubiꞌyahua liꞌihua, para nú lecati zequienu liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Xne nzeꞌta huaxi bee bene enu ni nú nzeꞌta beei equie cuendaꞌ liꞌá nu nibeei luhua: “Liꞌá neca Cristo”; nu scua zequienu beei huaxi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Pero liꞌihua chenu yeneꞌhua nú reca xuu urre rni bee bene nú enta nú aca xuu, la lliquihua xne scua nzeꞌta nú acane, pero la laxuscaꞌ iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Xne liunu tucu nación cuna stucu nación, nu liunu tucu país cuna stucu país, cuna liunu texcuaꞌa bee bene enu rnibiyaꞌ, cuna texcuaꞌa bee bene enu rnibiyaꞌ, nu aca xú cuna nú aca biña huaxi bee luhuare lu iliulabe. Nucuaꞌ neca nú apenatsia uquixie lunú enta nehuana zeca bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Pero ubiꞌyahua liꞌihua xne deteꞌ cuenda bee bene liꞌihua lubee usticia, cuna nú zetecheꞌ beei liꞌihua liñi bee indu, nu deteꞌ cuenda beei liꞌihua lubee gubierno cuna lubee arre equie nú nzeli arquiꞌhua liꞌá, pero scua nuꞌ modo nú nihua lubeei equie cuendaꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Xne rquiꞌña nú ixiuleꞌexu bee bene bedichiaꞌ nzeꞌcaꞌ Diose lu ye bee bene iliulabe, ante nú laxu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nu chenu deteꞌ cuenda bee bene liꞌihua lubee usticia, la chenu arquiꞌhua lunú xa nihua, uniꞌtsiahua bee bedichiaꞌ nú liquiꞌ Diose nú nihua xne laca liꞌihua enu ni hora zeꞌe, Espíritu Santo neca enu ni hora zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Enta bichia chenu deteꞌ cuenda bee bene leꞌca bichi beei para nú atilla, nu deteꞌ cuenda bee paꞌ bee bene enduꞌlla, leꞌca deteꞌ cuenda bee enduꞌ bee paꞌ beei cuna naꞌbeei para nú atilla. ");
INSERT INTO zplNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ye bee bene iliulabe chana arquiꞌ liꞌihua equie nú necahua bee benea; pero bene enu tsutaꞌ arquiꞌ lua hasta bichia chenu laxu yeene, benequieꞌ tsilaꞌa Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Chenu lañiꞌhua nú nzucu tucu cosa chiꞌquiꞌ liñi indu llene Jerusalén, tucu nú uni profeta Daniel hasta huaꞌtu, (bee bene enu rula ichiꞌ quieꞌ, uriꞌihua beyaꞌ) nú bee bene enu nucuaꞌa Judea, rquiꞌña nú yeca xuꞌu bee bene zeꞌe enza dañi. ");
INSERT INTO zplNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nu bee bene enu nchiucuꞌ equie niꞌi bichia zeꞌe, la lluꞌchaꞌ lacalla para nú chuꞌulla liñi niꞌilla naꞌtsella steneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nu bene enu nzu dañi, la benchilaꞌlla niꞌlla para nú yeꞌta chiyaꞌlla xuculla. ");
INSERT INTO zplNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Cueꞌe bee unaꞌa enu nuꞌ enduꞌ xlaꞌcu, cuna bee unaꞌa enu nuu bee enduꞌ enu rachi bichia zeꞌe! ");
INSERT INTO zplNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Unaꞌcuꞌhua lu Diose nú la aca bee nucuaꞌ chenu neca tiembu nú nucuaa. ");
INSERT INTO zplNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Xne chiquiꞌ nehuana zeca bee bene bichia zeꞌe, hasta chenu ungacheꞌ iliulabe lá aca bee nucuaꞌ scua, nu lecaꞌ xunga acalá bee nucuaꞌ scua niꞌ stucu bese. ");
INSERT INTO zplNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tunu la tsuxe Diose nú reca bee bichia zeꞌe, la tsilaꞌa niꞌ tucu bee bene; pero tsuxe Diose nú reca bee bichia zeꞌe, equie cuendaꞌ nú secanu bee beneꞌnu cuna nú ucañinu liꞌibeei para liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Tunu bee bichia zeꞌe nuꞌ enu ni luhua: “Ubiꞌyacuruhua caꞌa nzucu Cristo”, urre “Ni bee nzeꞌe ubiꞌyacuruhua nguiee nzucu Cristo”, la chili arquiꞌhua nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Xne nzeꞌta huaxi bee bene enu ni nú liꞌibeei neca beei Cristo, urre nibeei nú liꞌibeei neca beei bee profetaꞌ Diose, riꞌi beei huaxi bee milagro, cuna huaxilá beenú chenu arquiꞌ bee bene, para nú scua zequienu beei bee bene nu rriꞌi beei elliebacuꞌ tunu nuꞌ modo hasta bee bene enu ucañi Diose, zequienu beei. ");
INSERT INTO zplNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Enzeꞌe nia luhua, nú ubiꞌyahua liꞌihua, xne udixiuleꞌexulá ye bee nucuaꞌ luhua. ");
INSERT INTO zplNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Pero bee bichia zeꞌe, chenu udetela nú nehuana ulleꞌca bee bene cabelí lu bichia, nu la duꞌlleaꞌ ellieꞌ guu, ");
INSERT INTO zplNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nu zanaꞌ bee belaa enu nchiucuꞌ liñibe lu yuu cuna cuñi ye beenu nchiucuꞌ liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chequie lañiꞌ bee bene iliulabe, Bene enu uxeꞌla Diose, nú tuꞌna rulu siquiꞌnu nzeꞌtanu liñi xcabe cuna ye poder nú rluꞌcunu. ");
INSERT INTO zplNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Che xeꞌlanu bee ángeleꞌnu diqui lu iliulabe para nú quieteꞌsaꞌ beenu, ye bee beneꞌ Diose catse elu nucuaꞌa beella. ");
INSERT INTO zplNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Uluꞌcuhua cuenda lunú nia luhua, chenu riyeꞌ ellutsa lu aca higuera, cuna nú enta yeꞌ leca eꞌneꞌ lue, nediyaꞌhua nú enta riñala tsibee che. ");
INSERT INTO zplNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Leꞌca scua chenu lañiꞌhua nú recala ye bee nucuaꞌ uriꞌihua beyaꞌ nú axula nzu lunú nzeꞌta aca tucu nú unia luhua. ");
INSERT INTO zplNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ixiuleꞌa luhua nú acaxu ye bee nucuaꞌ, ante nú ati bee bene enu nehuañi nee. ");
INSERT INTO zplNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Iliulabe cuna liñibe nitilu bee nucuaꞌ pero stichiaꞌa la dete nú yalu yeene. ");
INSERT INTO zplNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Pero lecati riꞌi beyaꞌ xi bichia nu xi hora nú aca ye bee nucuaꞌ, nu niꞌbee ángele liñibe nu niꞌ Lliꞌñi Diose la riꞌi beyaꞌ nucuaꞌ, nediyaꞌtsia Diose Pa liñibe nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Enzeꞌe nia luhua nú ubiꞌyahua liꞌihua nu utsu tsiñiahua cuna nú unaꞌcuhua lu Diose, xne la riꞌihua beyaꞌ xunga aca bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Aca nucuaꞌ xi neca chenu xiuꞌu bene tucu biaji. Ante nú chiuꞌulla rnilla xi riñaꞌ riꞌi bee mosoꞌlla. Leꞌca unibiyaꞌlla nú tsu tsiña bene enu rriucu ruꞌu puerta niꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Leꞌca esquie liꞌihua, ucuaꞌa tsiñahua, xne la riꞌihua beyaꞌ xunga nu xiura nzelaa, tunu nzelaa chenu nzeꞌta chuꞌu rulaꞌ, urre tunu necane ulelaꞌ rulaꞌ urre tunu necane ellicabe chenu rixia tiula urre silaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Enzeꞌe ucuaꞌa tsiñahua xne ca tuꞌnatsia riñaa, nu la niarquia nú lluna liꞌihua nú la riꞌihua tucu nú riala nú riꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nu lunú rnia luhua nee, rnia lu ye bee bene: Uhuañihua tucu nú riala nú huañihua, ¡ucuaꞌa tsiñahua para bichia zeꞌe! ");
INSERT INTO zplNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Rriꞌitsia xiucu bichia nú aca eliñi baxcu, chenu racu bee bene Israel pá nú la chuꞌu levadura equie, che bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee ulaxcuela enu reca leyꞌ Moisés, rlaꞌna beei xa modo zequienu beei Jesuse para nú naꞌtse beei liꞌinu nu úti beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Che unibeei: ―Pero la riaꞌahua scua diqui nú reca eliñi, para nú la tsu reche bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Chequie chenu nzu Jesuse eyeche Betania niꞌi Simón enu ulleꞌca elichia nú lee lepra, chenu nzucu Jesuse lumexa racunu, uriña tucu unaꞌa nuyaꞌ tucu frasco nú achee nuꞌ perfume nú huaxi secaa, xne necacheꞌe puro nardo, nu chu uxaꞌlanchu frasco zeꞌe nu udunchu perfume zeꞌe equie Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Che bee bene enu nucuaꞌa zeꞌe ulee beei nú unibeei lu saꞌbeei: ―¿Xinu utiꞌchianchu perfume cuaꞌ scua? ");
INSERT INTO zplNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Alaꞌ aiqui perfume cuaꞌ tucu chuna ayuꞌu dimi denario para nú ariꞌinchu elietsa lubee bene enu seca elitsi, nu uquiꞌyaꞌ unaꞌa zeꞌe uriꞌi beei. ");
INSERT INTO zplNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero uni Jesuse lubeei: ―La riꞌchiahua liꞌinchu; ¿xinu rquiꞌyanchu rriꞌihua? Xne lunú uriꞌinchu lua, neca nzeꞌca nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bee bene elitsi siempre nucuaꞌa cuna liꞌihua, nu nuꞌ modo riꞌihua elietsa lubeei xitse bichia. Pero liꞌá la tsuaꞌa cuna liꞌihua diqui tiembu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Unaꞌa quieꞌ uriꞌinchu lunú unganchu, uduꞌxulanchu perfume cuaꞌ cuerpoa para nú necalane bichia chenu achiꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ixiuleꞌa luhua, nú diqui lu iliulabe elu ixiuleꞌe bee bene bedichiaꞌ nzeꞌcaꞌ Diose, leꞌca ni bee bene lunú uriꞌi unaꞌa quieꞌ lua para nú elluꞌcuꞌ arquiꞌ bee bene lunú uriꞌinchu lua. ");
INSERT INTO zplNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chequie uya Judas Iscariote enu neca lu chiꞌchiucu bee beneꞌ Jesuse, lubee uleꞌya enu rnibiyaꞌ lubee lá bee uleꞌya para nú deteꞌ cuendai Jesuse lubeei. ");
INSERT INTO zplNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chenu ubeneꞌ bee uleꞌya zeꞌe nucuaꞌ, ñia utsu arquiꞌbeei nu unibeei nú deteꞌ beei dimi ya Judas, che uquixie Judas ucuaꞌana xa modo deteꞌ cuendai Jesuse lubeei. ");
INSERT INTO zplNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chequie bichia nú uquixie nú reca eliñi chenu racu bee bene Israel pá nú la chuꞌu levadura equie, chenu leꞌca ruuti bee bene tucu sanchi eliñi baxcu zeꞌe che unidichiaꞌ bee beneꞌnu lunu: ―¿Cá niarquiꞌlu nú nze recheꞌru nú daꞌcuxeꞌahua reché baxcu? ");
INSERT INTO zplNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Che uxeꞌla Jesuse chiucu beneꞌnu nu uninu lubeella: ―Uquiahua eyeche Jerusalén, zeꞌe llaꞌcahua tucu niyu enu nuyaꞌ tucu ereꞌe inza nu chu chequiehua liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Elu chuꞌu bene zeꞌe, nihua lu bene enu neca stene niꞌi zeꞌe: “Singuie rni Maestro: ¿Ca nzucu cuarto elu acuxeenua bee benea reché baxcu quieꞌ?” ");
INSERT INTO zplNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Che lubeꞌ bene zeꞌe tucu cuarto elu ayaa nú nzu cheꞌela liñi, zeꞌe recheꞌhua nú daꞌcuxeꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chequie nzuebeella eyeche llene zeꞌe, nu ullelaꞌ beella tucu nú uninu lubeella nu urecheꞌe beella nú acuxee beella reché baxcu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Chenu uyuꞌu rulaꞌ uriñayuu Jesuse chiꞌchiucu bee beneꞌnu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Diqui nú nucuaꞌa beella lu mexa racu beella uni Jesuse lubeella: ―Ixiuleꞌa luhua nú tucuhua enu racunu liꞌá deteꞌcuenda liꞌá lubee bene enu uti liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chequie nehuana utsu arquiꞌbeella, nu unidichiaꞌ tucua tucua beella lunu: ―¿Liꞌá nzeꞌe la? Nu uni stucu beella: ―¿Liꞌá nzeꞌe la? ");
INSERT INTO zplNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nu ucuaqui Jesuse lubeella: ―Tucu lu chiꞌchiucuhua enu seꞌe pá leꞌca liñi pliato elu seꞌa pá nzeꞌella. ");
INSERT INTO zplNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Neli nú liꞌá Bene enu uxeꞌla Diose, zecaa tucu nú rni lu ichiꞌ Stichiaꞌ Diose; pero ¿cueꞌe bene enu deteꞌ cuenda liꞌá? Máse neca nzeꞌca lu cuendaꞌ bene zeꞌe nú né aláxulla lu iliulabe quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Diqui nú racu beella, unaꞌtse Jesuse tucu pá nu udeteꞌnu cheꞌtsa lu Diose nu chu uleꞌenu pá zeꞌe udeteꞌnu yabeella nu uninu: ―Udacuhua pá quieꞌ, ninguieꞌ neca cuerpoa. ");
INSERT INTO zplNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Che unaꞌtsenu tucu copa viñu, chenu ulaxu nú udeteꞌnu cheꞌtsa lu Diose, che chu udeteꞌnu vaso cuaꞌ ya beella nu ungueꞌ ye beella biñu cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nu uninu lubeella: ―Biñu quieꞌ neca renea nú riꞌchia chenu atia para nú tsilaꞌa huaxi bee bene, xne equie cuendaꞌ nú atia yaꞌla tucu inziu cuqui nú luꞌcu bee bene nú xa riꞌi Diose perdona liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ixiuleꞌa luhua nú lecaꞌ xunga hueꞌelá biñu nú necacheꞌ uva, hasta bichia nú huaꞌa biñu cuqui elu rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chenu ulaxu nú ungula beella tucu canto lu Diose, chu nzuebeella dañi nú lee Olivos. ");
INSERT INTO zplNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Che uni Jesuse lubeella: ―Yehua tsanaꞌ arquiꞌhua liꞌá rulaꞌ quieꞌ; tucu nú nequie lu ichiꞌ Stichiaꞌ Diose elu rni: “Utia bene enu rriucu bee sanchi, nu riꞌchia letse beeí.” ");
INSERT INTO zplNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero chenu huañi zecaa rlutia nzaꞌa Galilea, cheela riñahua zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Chequie uni Pedro lu Jesuse: ―Añinzuca nú tsanaꞌ arquiꞌ ye beella liꞌilu, pero liꞌá la tsana arquia liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nu ucuaqui Jesuse lu Pedro nú uninu: ―Ixiuleꞌa lulu nú rulaꞌ quieꞌ ante nú bixia tiula chiucu bese, unilalu chuna bese nú la chululu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero unila Pedro nú uni: ―Mase atia cuna liꞌilu, la cachia nú nuꞌlua liꞌilu. Leꞌca scua uni ye beella. ");
INSERT INTO zplNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chenu uriña beella tucu luhuare elu lee Getsemaní uni Jesuse lubee beneꞌnu: ―Ucuaꞌascaꞌhua caꞌa, nze nacutsia lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Che unguyaꞌtsianu Pedro cuna Jacobo cuna Juan, nu uquixie nú chiquiꞌ nehuana nzu arquiꞌnu, hasta nú lixiuaꞌ nzu arquiꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nu uninu lubeella: ―Chiquiꞌ nehuana nzu arquia, hasta nú seꞌca nú atia, uyaꞌnascaꞌhua caꞌa nu la aꞌtsehua. ");
INSERT INTO zplNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Che chu nza Jesuse lleꞌna enza lu zeꞌe, nu utsulliquinu hasta nú utiꞌnu tequieenu lu yuu, nu unacuꞌnu lu Diose tunu nuꞌ modo nú la zecanu lunú enta zecanu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Chenu rnacuꞌnu lu Diose uninu: ―Paa, yeene recalu rriꞌilu; utsilaꞌa liꞌá lunú chiquiꞌ juerte enta nú zecaa, pero la acane tucu nú niarquia, uriꞌitsia tucu nú niarquiꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Che chu nza Jesuse elu uyaꞌna chuna beneꞌnu nu ullunaꞌnu liꞌibeella nú raꞌtse beella nu uninu lu Pedro: ―Simón, ¿xieꞌ raꞌtselu la? ¿Xieꞌ né riquiꞌlu azucu naalu masia tucu hora la? ");
INSERT INTO zplNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Uzucunahua, nu unaꞌcuhua lu Diose para nú la riꞌi bezeꞌlu ana luhua, xne nuꞌ ana arquiꞌhua nú riꞌihua nú neca nzeꞌca, pero la riquiꞌ cuerpoꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chequie nza zeca Jesuse, nze nacuꞌnu lu Diose nu uninu lu Diose tucu nú uninu bese rluu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chenu ubenchilaꞌ zecanu elu uyaꞌna chuna beneꞌnu ullunaꞌnu liꞌibeella nú stucuaꞌla bese raꞌtse beella, xne chiquiꞌ riuꞌu calaꞌ lubeella nu lá riꞌi beella beyaꞌ xi cuaqui beella lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bese rriuna chenu ubenchilaꞌnu elu nucuaꞌa beella uninu lubeella: ―¿Xieꞌ ratsescaꞌhua nu sulachi scaꞌhua la? Pero uhuahua calaꞌ cuaꞌ luhua, xne liꞌá Bene enu uxeꞌla Diose uriñala hora nú deteꞌ cuenda bene liꞌá lubee bene enu rriꞌi dula. ");
INSERT INTO zplNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Uzetehua ne chaꞌahua. Nzeꞌta bicala bene enu deteꞌ cuenda liꞌá nee. ");
INSERT INTO zplNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Rniscaꞌlá, Jesuse cuna liꞌibeella chenu uriña Judas enu unga tucu lu chiꞌchiucu bee beneꞌnu, uriña yui huaxi bee bene enu nzene espada cuna bee acarute. Nú nzeꞌta naꞌtse beei Jesuse lunú unibiyaꞌ bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee ulaxcuela enu reca leyꞌ Moisés cuna nú rnibiyaꞌ bee usticiaꞌ bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Chequie Judas enu udeteꞌ cuenda Jesuse lubee bene zeꞌe, unilai lubee bene zeꞌe nú uni lubeella: ―Bene enu acua tucu bichiuꞌ xeca, nzeꞌe naꞌtsehua nu chiuca uyaꞌhua liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nu chenu uriña Judas lu Jesuse uyabicai lunu nú uni: ―Maestro, Maestro. Nu chu udacui tucu bichiuꞌ xecanu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Che unaꞌtse bee bene zeꞌe Jesuse nu unguyaꞌ beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero tucu bee beneꞌ Jesuse enu nzu zeꞌe uhualla espada nu uchiecuꞌlílla diaca tucu bene enu neca mosoꞌ uleꞌya enu rnibiyaꞌ lu ye bee uleꞌya. ");
INSERT INTO zplNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nu uni Jesuse lubee bene zeꞌe: ―¿Xinu entahua cuna espada cuna acarute para nú naꞌtsehua liꞌá xineca tucu huanaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ye bichia nzua cuna liꞌihua liñi indu llene Jerusalén elu uzetea Stichiaꞌ Diose nu né naꞌtsehua liꞌá zeꞌe. Pero scua acane para nú yalu nú rni Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Che ye bee beneꞌ Jesuse uyecaxuꞌu beella nu utsanaꞌ arquiꞌbeella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Chequie nzequie tucu niyu eꞌneꞌ Jesuse nu nutui tucutsia sábana. Pero chenu unaꞌtse bee bene zeꞌe liꞌi, ");
INSERT INTO zplNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","chu uchiuꞌu xquiꞌ xuꞌi liñi sábana, nú nutui nu eꞌcu etui uyecaxuꞌi nzai. ");
INSERT INTO zplNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Che uyayu bee bene zeꞌe Jesuse lu uleꞌya enu rnibiyaꞌ lu ye bee uleꞌya, nu uyetesaꞌ ye bee uleꞌya enu rnibiyaꞌ lubee uleꞌya, cuna bee usticiaꞌ bee bene Israel cuna bee ulaxcuela enu reca leyꞌ Moisés. ");
INSERT INTO zplNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nu istu istu uyaquie Pedro Jesuse hasta ruꞌu niꞌi uleꞌya enu rnibiyaꞌ luye bee uleꞌya, nu chu uzucu Pedro ruꞌu quii cuna bee bene enu rriucu ruꞌu niꞌi uleꞌya zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna ye bee usticiaꞌ bee bene Israel, ucuaꞌna beella xi ricuꞌ quiya beella Jesuse para nú scua nuꞌ modo nú utibeella liꞌinu. Pero né llelaꞌ beella xi aricuꞌ quiya beella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Xne añinzuca nú huaxi eluquichiaꞌ uricuꞌ quiya beella Jesuse, pero urene uni tucu beella nu urene uni stucu beella. ");
INSERT INTO zplNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Chequie utsuli chiucu chuna beella nu uricuꞌ quiya beella tucu eluquichiaꞌ Jesuse nu unibeella: ");
INSERT INTO zplNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Liꞌiru ubeneꞌru nú uni nucuaꞌ: Liꞌá nitilua indu llene Jerusalén nú urecheꞌe bee bene, nu chunatsia bichia recheꞌa stucu indu nú lá recheꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero niꞌ scua la neca tucu necatse lunú rni beella urene urene uni beella. ");
INSERT INTO zplNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Che utsuli uleꞌya enu rnibiyaꞌ lu ye bee uleꞌya labe bee bene enu nucuaꞌa zeꞌe nu unidichiaꞌlla lu Jesuse: ―¿Xinu la cuaquilílu? ¿Xieꞌ neli neca nú rnibeei lulu scua la? ");
INSERT INTO zplNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero la nili Jesuse nu né cuaquilínu che unidichiaꞌ zecaꞌla uleꞌya zeꞌe lunu: ―¿Xieꞌ liꞌilu necalu Cristo lliꞌñi Diose liñibe la? ");
INSERT INTO zplNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Che ucuaqui Jesuse nú uninu: ―Liꞌá nzeꞌe nu lañiꞌhua liꞌá Bene enu uxeꞌla Diose nú nzucuaꞌa cueꞌtse Diose chúbee liꞌinu enu chiquiꞌ reca yeene, nu leꞌca lañiꞌhua nú nzela liñi xcabe enza liñibe. ");
INSERT INTO zplNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chenu ubeneꞌ uleꞌya zeꞌe nucuaꞌa, che utsalla xuculla nu unilla: ―¿Xinu laꞌnalaꞌahua testigo nee? ");
INSERT INTO zplNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ubeneꞌlaꞌhua nú xa uni nucuaꞌa bedichiaꞌ nú necha neca lu Diose; ¿xa nihua nee? Chequie uni ye bee bene zeꞌe nú ati Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Xiucu xuna beei utsu xene lunu nu utsacuꞌ beei lunu nu udiñi beei liꞌinu nu unibeei lunu: ―¡Uniꞌti udiñi liꞌilu! Che bee sundado enu rriucu indu llene Jerusalén leꞌca uxutse beei ndaꞌgu lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Chenu uzucu Pedro ruꞌu eliꞌyaꞌ niꞌi uleꞌya enu rnibiyaꞌ luye bee uleꞌya, che uriña tucu criadaꞌ uleꞌya zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Chenu ulañiꞌnchu nú nzucu Pedro ruꞌu quii zeꞌe ubiꞌyanchu lulla nu uninchu lulla: ―Leꞌca nuulu enzenuulu Jesuse bene eyeche Nazaret. ");
INSERT INTO zplNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero ucachiꞌ Pedro nú unilla: ―La chuꞌlua benecuaꞌ, nu la riꞌá beyaꞌ xi rnilu. Che uchiuꞌu Pedro zeꞌe nu utsulla ruꞌu puerta nu chu ubixia tiula. ");
INSERT INTO zplNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chenu ulañiꞌ zeca criada zeꞌe Pedro stucu bese, che uquixienchu nú uninchu lubee bene enu nucuaꞌa zeꞌe: ―Leꞌca nuu nucuaꞌ neca nucuaꞌ tucu beneꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero ucachiꞌ zeca Pedro nú la chululla Jesuse. Che lu zeꞌe tsia uniaꞌala bee bene enu nucuaꞌa zeꞌe lu Pedro: ―Che rlubeꞌ nú necalu tucu beneꞌ benecuaꞌ, xne necalu bene Galilea nu rdichiaꞌlu tucu nú rdichiaꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Che uquixie Pedro nú utsutaꞌlla lu stichiaꞌlla nú unilla: Deteꞌ Diose castiya liꞌá tunu la nia nú neli neca. ―¡La chulua bene enu rnihua! ");
INSERT INTO zplNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hora zeꞌe ubixia tiula stucu bese nu ulluꞌcu arquiꞌ Pedro lunú uni Jesuse lulla: “Ante nú bixia tiula chiucu bese, unilálu chuna bese nú la chululu liꞌá.” Chenu ulluꞌcu arquiꞌ Pedro nucuaꞌ uquixiella nú runaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Chenu uyeꞌe lu yuu uyetesaꞌ bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee usticiaꞌ bee bene Israel cuna bee ulaxcuela enu reca leyꞌ Moisés cuna bee usticia enu mase rnibiyaꞌ ubedichiaꞌ beella nú xa riꞌi beella. Che ullicaꞌcuu beella Jesuse nu udeteꞌ cuenda beella liꞌinu lu Pilato. ");
INSERT INTO zplNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Che unidichiaꞌ Pilato lu Jesuse: ―¿Necalu Arreꞌ bee bene Israel la? Nu ucuaqui Jesuse nú uninu: ―Liꞌá nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Equie nú huaxi nú rricuꞌquiya bee uleꞌya enu rnibiyaꞌ lubee uleꞌya liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Enzeꞌe unidichiaꞌ Pilato lu Jesuse stucu bese: ―¿Xinu la cuaquilílu? Ubiꞌyacuru huaxi nú rni bee bene lu cuendaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero lecaxi ucuaqui Jesuse, che chiquiꞌ uyanu arquiꞌ Pilato. ");
INSERT INTO zplNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cada chenu reca eliñi baxcu, rlaꞌa Pilato tucu bene enu nchiñi niꞌcuꞌ, tatse enu nacuꞌ bee bene nú laꞌa. ");
INSERT INTO zplNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bee bichia zeꞌe nchiñi Barrabás niꞌcuꞌ cuna beelá bee bene enu neyeteꞌi, xne unguuti beei bee bene chenu uliunu beei bee beneꞌ gobierno. ");
INSERT INTO zplNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chenu uyetesaꞌ bee bene para nú nibeei lu Pilato nú riꞌilla tucu nú neca costumbreꞌlla, ");
INSERT INTO zplNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","che uni Pilato lubeei: ―¿Niarquiꞌhua nú laꞌa Arreꞌ bee bene Israel la? ");
INSERT INTO zplNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Uni Pilato scua xne uriꞌilla beyaꞌ nú equie nú ria arquiꞌ bee uleꞌya enu rnibiyaꞌ lubee uleꞌya, enzeꞌe udeteꞌ cuenda beei Jesuse lulla. ");
INSERT INTO zplNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero bee uleꞌya enu rnibiyaꞌ lubee uleꞌya uduꞌbeei arquiꞌ bee bene zeꞌe para nú ni bee bene zeꞌe lu Pilato nú laꞌalla Barrabás. ");
INSERT INTO zplNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Chequie unidichiaꞌ Pilato lubeei: ―¿Xi niarquiꞌhua nú riꞌinua enu rnihua nú neca arreꞌ bee bene Israel? ");
INSERT INTO zplNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nu ucuaqui beei nú urixialibeei: ―¡Uquieꞌe nucuaꞌa lu cruse! ");
INSERT INTO zplNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nu uni Pilato lubeei: ―Pero ¿ta nú necha neca uriꞌi nucuaꞌ? Nu masescaꞌlá juerte ubixialí beei: ―¡Uquieꞌe nucuaꞌ lu cruse! ");
INSERT INTO zplNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chequie lunú niarquiꞌ Pilato nú yaꞌna nzeꞌcalla lubeei, ulaꞌalla Barrabás. Nu unibiyaꞌlla nú uzeteꞌcheꞌ bee sundado Jesuse, nu chu udeteꞌ cuendalla liꞌinu lubee sundado para nú quieꞌe beei liꞌinu lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Unguyaꞌ bee sundado zeꞌe Jesuse labe eliꞌyaꞌ ruꞌu palacio, elu uyetesaꞌ ye bee sundado. ");
INSERT INTO zplNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Che ungutu beei tucu laquie morado Jesuse, nu urecheꞌe beei tucu elluꞌñiꞌ nú necacheꞌe eche uzucuꞌ beei equienu. ");
INSERT INTO zplNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nu uquixie beei nú rixiali beei lunu: ―¡La laxuaꞌ nú nehuañi Arreꞌ bee bene Israel! ");
INSERT INTO zplNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chequie uduꞌbeei tucu ixiꞌ equienu, nu utsu xene beei lunu, cuna nú utsu lliqui beei lunu, xi neca nú chiquiꞌ rluꞌcu beei ulaꞌna lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chenu ulaxu nú xitse uriꞌinu beei liꞌinu, uhuabeei laquie morado nú nutunu nu ungutu beei nú neca xucunu liꞌinu, che unguyaꞌ beei liꞌinu para nú quieenu lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Chequie chenu nzeyu beei Jesuse, ullaꞌca beei tucu bene eyeche Cirene enu lee Simón necalla paꞌ Alejandro cuna Rufo nzeꞌtalla enza dañi. Che uriꞌi bee sundado juerza liꞌilla para nú uyaꞌlla cruseꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nu chu unguyaꞌ beei Jesuse tucu luhuare elu lee Gólgota, nu rni nucuaꞌ: lluca equie bene nguti. ");
INSERT INTO zplNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nu udeteꞌ beei biñu nú nucha inza nú nelaa nú lee mirra, para nú hueꞌnue pero lá hueꞌnue. ");
INSERT INTO zplNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chequie uquieꞌe bee sundado zeꞌe liꞌinu lu cruse. Nu urita beei tucu rifa equie cuendaꞌ xucunu biꞌya tane riꞌi cada tucua beei ana. ");
INSERT INTO zplNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Rquie quieꞌ silaꞌ uquieꞌe beei Jesuse lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Equie cruseꞌnu uquieꞌe beei tucu letrero nú rixiuleꞌe xi nú uquieꞌe beei liꞌinu lu cruse, cuna nú rni lu letrero zeꞌe nú necanu: “Arreꞌ bee bene Israel.” ");
INSERT INTO zplNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Leꞌca uquieꞌe beei chiucu huanaꞌ lu tucua cruse, tucu nzeꞌe cueꞌtsenu chúbee nu stucu nzeꞌe cueꞌtsenu chubeca. ");
INSERT INTO zplNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Scua uyalu lunú rni lu ichiꞌ Stichiaꞌ Diose nú rni: “Ubacuꞌ beei liꞌinu leta bee bene enu necha rriꞌi.” ");
INSERT INTO zplNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Chequie bee bene enu udete zeꞌe unibeei huaxi bedichiaꞌ nú necha neca lunu, cuna nú rcuñi beei equie beei xiꞌchinu beei liꞌinu nú rnibeei: ―¡Manú! Rnilu nú chilalu indu llene Jerusalén nu lu chunatsia bichia recheꞌ zecalue, ");
INSERT INTO zplNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","utsilaꞌa liꞌilu nu ulaca lu cruse cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Leꞌca bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee ulaxcuela enu reca ley Moisés, unibeei huaxi bedichiaꞌ nú necha neca lunu nu unibeei: ―Utsilaꞌa nucuaꞌ bee bene, pero la aca nucuaꞌ tsilaꞌa nucuaꞌ liꞌi nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Tunu neca nucuaꞌ Cristo puese láca Cristo enu neca arreꞌ bee bene Israel lu cruse para nú lañiaꞌahua, che chili arquiaꞌahua nucuaꞌ! Hasta bee huanaꞌ enu nequie lu cruse cuna liꞌinu rnibeei bedichiaꞌ nú necha neca lunu. ");
INSERT INTO zplNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chenu unga rrebichia ucabeli diqui neca lu iliulabe hasta rquie chuna uche. ");
INSERT INTO zplNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hora zeꞌe chenu unga rquie chuna uche juerte urixiali Jesuse nú uninu: ―Eloi, Eloi, ¿lama sabactani? ―rni bedichiaꞌcuaꞌ: Diosea, Diosea, ¿xinu utsanaꞌ arquiꞌlu liꞌá? ");
INSERT INTO zplNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chenu ubeneꞌ chiucu chuna bee bene enu nucuaꞌa zeꞌe nucuaꞌ, che unibeei: ―Uquieꞌe diacahua rixialla profeta Elías. ");
INSERT INTO zplNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Che uyaxuꞌu tucu beei nu ucuacha nzeꞌe tucu esponja lu inza vinagre nu uzucuꞌi lliꞌi tucu aca nu utiꞌi esponja cuaꞌ ruꞌu Jesuse para nú hueꞌnu inza vinagre cuaꞌ nu uni: ―Utsanaꞌhua liꞌilla biꞌya se nzeꞌta laca Elías liꞌilla lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pero juerte urixiali Jesuse nu ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Chequie laquie llene nú neruꞌcu nziꞌqui liñi indu llene Jerusalén, utsa arliꞌtiꞌllune hasta aya nu hasta aquié. ");
INSERT INTO zplNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Che capitañi enu rnibiyaꞌ lubee sundado ulañiꞌi nú xa unguti Jesuse lunú nzui zeꞌe nu uni: ―Neli nú neca benequieꞌ Lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Leꞌca istu nucuaꞌa chiucu chuna bee unaꞌa riꞌya, leta bee unaꞌa quieꞌ nzu María Magdalena, cuna Salomé cuna María enu neca naꞌ Jacobo enu riꞌchia bene Jacobo enu lleꞌna, cuna José. ");
INSERT INTO zplNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bee unaꞌa quieꞌ uyaquie Jesuse cuna nú uriꞌi beenchu elietsa lunu chenu nzunu Galilea. Leꞌca zeꞌe nucuaꞌa huaxilá bee unaꞌa enu uyaquie liꞌinu hasta Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bichia nú rriꞌiluxu bee bene Israel ye nú quiꞌña beella neca bichia xee nu sulachi beella. Bichia zeꞌe chenu enta chuꞌu rulaꞌ, ");
INSERT INTO zplNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","uriña José bene eyeche Arimatea. Ungalla tucu bee usticia lubee bene Israel, nu rluꞌcu bee bene ulaꞌna lulla. Leꞌca nzuquiella nú lañiꞌlla lunú rnibiyaꞌ Diose, nu uyuꞌu valuruꞌlla unacuꞌlla cuerpoꞌ Jesuse lu Pilato. ");
INSERT INTO zplNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Chequie chiquiꞌ uyanu arquiꞌ Pilato chenu ubeneꞌlla nú ungutila Jesuse, nu chu ubixialla capitañi para nú riꞌilla beyaꞌ tunu neli nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chenu uni capitañi zeꞌe nú neli nú ungutila Jesuse, che uzela Pilato nú unguyaꞌ José cuerpoꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chequie uya José utsii tucu sabana fiño nu chu ulacalla cuerpoꞌ Jesuse lu cruse nu utelalla sabana zeꞌe cuerpoꞌnu nu uya caꞌchiꞌlla cuerpoꞌnu liñi tucu eluhua elu nedaꞌñila liñi tucu quiee nu utsacuꞌlla ruꞌu eluhua zeꞌe cuna tucu quiee llene. ");
INSERT INTO zplNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena cuna María naꞌ José ulañiꞌ beenchu elu uhuachiꞌ cuerpoꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Chequie chenu udete bichia nú sulachi bee bene Israel, María Magdalena, cuna Salomé, cuna María naꞌ Jacobo, uya tsiꞌ beenchu perfume para nú duꞌ beenchu perfume cuaꞌ cuerpoꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nu chenu uyeꞌe lu yuu zilaꞌ domingo silatuꞌ uya beenchu ruꞌu eluhuaꞌ Jesuse, chenu enta liñi bichia. ");
INSERT INTO zplNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Chenu nzue beenchu lu inziu uni beenchu lu saꞌbeenchu: ―¿Ti yucu quiee llene nú nacuꞌ ruꞌu eluhuaꞌ Jesuse nee? ");
INSERT INTO zplNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero chenu ubiꞌya beenchu ulañiꞌ beenchu, nu la nacuaꞌ quiee llene zeꞌe ruꞌu eluhua. ");
INSERT INTO zplNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chenu uyuꞌu beenchu liñi eluhua zeꞌe, ulañiꞌ beenchu, nú nzucu tucu niyu eꞌneꞌ chubee ruꞌu eluhua zeꞌe, nutui tucu laquie niquichi nú stuñi, nu ulliqui beenchu. ");
INSERT INTO zplNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Che uni lubeenchu: ―La lliquihua. Nediyaa nú rlaꞌnahua Jesuse bene eyeche Nazaret enu uquiee lu cruse. Pero uhuañi zecanu nú ungutinu. Lecaꞌnu caꞌa. Ubiꞌyacuruhua elu uricu cuerpoꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nee uquia tixiuleꞌehua lu Pedro cuna lu beelá bee beneꞌ Jesuse nú rlutinu nzanu Galilea, cheela riñahua zeꞌe; nu lañiꞌhua liꞌinu zeꞌe tucu nú uninu luhua. ");
INSERT INTO zplNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chequie yexetsia uchiuꞌu bee unaꞌa quieꞌ liñi eluhua zeꞌe, nu reca tseꞌtse beenchu xiqui beenchu. Nu lecati lu udixiuleꞌe beenchu lunú unga zeꞌe, equie nú xiqui beenchu. ");
INSERT INTO zplNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo silaꞌ chenu uhuañi zeca Jesuse nú ungutinu, rlutilá ulubeꞌlunu lu María Magdalena enu uhuanu achi benechiquiꞌ arquiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Che uya tixiuleꞌenchu lubee bene enu uyanzenu Jesuse, nu nehuana nzu arquiꞌbeella cuna nú runaꞌ beella equie cuendaꞌ liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero chenu ubeneꞌ beella nú nehuañi Jesuse cuna nú ulañiꞌ María Magdalena liꞌinu, né chili arquiꞌbeella nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lu zeꞌe lá ulubeꞌlu Jesuse lu chiucu bee beneꞌnu enu nza enza dañi, pero urene ulubeꞌlunu lubeella. ");
INSERT INTO zplNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Che uyatixiuleꞌe bee bene quieꞌ lubeelá bee beneꞌnu, pero niꞌ nú uni beella né chili arquiꞌ beelá bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lu zeꞌelá ulubeꞌlu Jesuse lu chetuꞌcu bee beneꞌnu, chenu nucuaꞌa beella lu mexa. Uquiꞌyaꞌ beella uriꞌinu, xne nziti arquiꞌbeella equie nú la chili arquiꞌbeella lunú unibee bene enu ulañiꞌlaꞌ liꞌinu nú uhuañi zecanu nú ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Chequie uninu lubeella: ―Uquiahua diqui lu iliulabe nu udixiuleꞌehua bedichiaꞌ nzeꞌcaꞌ Diose lu ye bee bene. ");
INSERT INTO zplNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nu bene enu chili arquiꞌ bedichiaꞌ nzeꞌcaꞌ Diose cuna nú rinzalla tsilaꞌa Diose liꞌilla, pero bene enu la chili arquiꞌ Stichiaꞌ Diose la tsilaꞌa Diose liꞌilla lu castiyaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nu bee seña quieꞌ luꞌcu bee bene enu chili arquiꞌ Stichiaꞌ Diose. Equie nú leea hua beella bee benechiquiꞌ arquiꞌ bee bene. Leꞌca nibeella stucu dialu rene nú la ni beella. ");
INSERT INTO zplNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nu tunu naꞌtse beella beꞌla cuna yaa beella; nu tunu hueꞌ beella nú nucha veneno, lecaxi zeca beella; nu leꞌca chenu ricuꞌ beella ya beella equie bee bene enu riti yecaꞌ bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chequie chenu ulaxu nú uni Jesuse lubeella, chu uquieenu liñibe nu uzucunu cueꞌtse Diose chubee. ");
INSERT INTO zplNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Che uchiuꞌu beella nú nze tixiuleꞌe beella bedichiaꞌ nzeꞌcaꞌ Diose lubee bene diqui bee luhuare. Nu uriꞌi Jesucristo elietsa lubeella, uriꞌinu bee milagro para nú riꞌi bee bene beyaꞌ nú neli neca Stichiaꞌ Diose nú seteꞌ beella. Amén.");
INSERT INTO zplNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Huaxi bee bene uriꞌi luchia nú uquieꞌe xcuaꞌa beella nú xa unga letaꞌahua, ");
INSERT INTO zplNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tucu nú uzeꞌteꞌ bee bene liaꞌahua, liꞌibeella enu ulañiꞌ xa unga hasta chenu uquixie Jesuse nú udixiuleꞌenu Stichiaꞌ Diose, nu leꞌca liꞌibeella uriꞌi beella elietsa nú udixieleꞌe beella stichiaꞌnu lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Leꞌca ucuaꞌnaa para nú uriꞌá beyaꞌ lunú neli neca nú xa unga hasta chenu uriña Jesuse lu iliulabe. Teófilo enu chiquiꞌ neca equie neca nzeꞌca para liꞌá nú quieꞌe xcuaꞌa bee ninguieꞌ lulu, ");
INSERT INTO zplNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","para nú riꞌi nzeꞌcalu beyaꞌ lu ye nú neli neca uzeteꞌ bee bene liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chenu unga Herodes arre lu iliu Judea, uhuañi tucu uleꞌya enu lee Zacarías, liꞌilla ullutsella leta texcuaꞌa bee uleꞌya enu unibiyaꞌ Abías lu, nu unaꞌa Zacarías lee Elisabet, necalla enu nzeꞌta lubee beneꞌ tuxie Aarón enu unga uleꞌya. ");
INSERT INTO zplNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías cuna unaꞌlla uhuañi beella tucu nú neli neca lu Diose, nu uzucuꞌ beella leyꞌ Diose, hasta nú lecati uduꞌ culpaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero né luꞌcu beella enduꞌ, xne neca Elisabet bíchi nu unguxula rucu beella. ");
INSERT INTO zplNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tucu bichia uyala texcuaꞌa bee uleꞌya para nú zibiꞌ beella lu Diose, leta bee uleꞌya quieꞌ nchiñi Zacarías. ");
INSERT INTO zplNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chequie tucu nú neca costumbreꞌ bee uleꞌya zeꞌe, ucañi beella biꞌya ta beella yaꞌna enu duꞌ llene quiendixí ruꞌu ecuꞌcu elu necachi neca liñi indu llene Jerusalén, nu uyala Zacarías nú chuꞌulla liñi indu zeꞌe para nú duꞌlla llene quiendixí ruꞌu ecuꞌcu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Diqui nú rduꞌlla llene quiendixí ruꞌu ecuꞌcu zeꞌe, ye bee bene rnacuꞌ beella lu Diose labe eliꞌyaꞌ indu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hora zeꞌe ulubeꞌlu tucu ángeleꞌ Diose lu Zacarías, chúbee ruꞌu ecuꞌcu elu rduꞌlla llene quiendixí. ");
INSERT INTO zplNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chenu ulañiꞌ Zacarías ángele zeꞌe, chiquiꞌ ulliquilla nu lá riꞌilla beyaꞌ xa riꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Che uni ángele zeꞌe lulla: ―Zacarías, la lliquilu, ubeneꞌlaꞌ Diose lunú rnacuꞌlu lunu, liꞌilu cuna unaꞌalu Elisabet luꞌcuhua tucu enduꞌ, enu hualeehua Juan. ");
INSERT INTO zplNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Chiquiꞌ ñia tsu arquiꞌlu, nu leꞌca esquie ñia tsu arquiꞌ huaxi bee bene chenu ala enduꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Xne enduꞌlu aca tucu bene llene lu Diose. La hueꞌlla biñu nu la hueꞌlla niꞌ tucu nú rriꞌi nú xuchiꞌ bee bene. Ante nú alalla chiquiꞌ nzula Espíritu Santo cuna liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Riꞌilla nu huaxi bee bene Israel cheꞌe arquiꞌbeei lu stula beei nú benchilaꞌ beei lu inziuꞌ Diose, liꞌinu enu neca Dioseꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juan quieꞌ cha rluti lu liꞌinu enu nzeꞌta, nu xeꞌla Diose nú huañi Espíritu Santo cuna Juan nu luꞌculla nú recalla tucu nú uluꞌcu profeta Elías, riꞌilla nú huañi nzeꞌca bee paa cuna bee lliꞌñilla para nú la cuaꞌa xuulla. Leꞌca zeteꞌlla bee bene enu nziti arquiꞌ para nú zucuꞌ beei yeene, scua riꞌilla nú cuaꞌa tsiña bee bene para nú yucu arquiꞌbeei liꞌinu enu nzeꞌta. ");
INSERT INTO zplNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Che uni Zacarías lu ángele zeꞌe: ―¿Xa modo aca tucu nú rnilu? Xne unguxulá nu leꞌca esquie unaa. ");
INSERT INTO zplNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nu ucuaqui ángele zeꞌe: ―Liꞌá neca ángele enu lee Gabriel, nu sibiaꞌa lu Diose, liꞌinu uxeꞌlanu liꞌá para nú nzelayua bee resuna nzeꞌca quieꞌ lulu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero nee, equie nú la chili arquiꞌlu lunú unia lulu, yacuꞌ nú rnilu, hasta nú yalu nú unia lulu, che yaꞌla zeca nú nilu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Diqui nú reca bee nucuaꞌ, bee bene enu nucuaꞌa ruꞌu eliꞌyaꞌ indu zeꞌe nucuaꞌa quiee beella nú chiuꞌu Zacarías nu nzenu arquiꞌbeella xi nú rleꞌ Zacarías liñi indu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Chenu uchiuꞌu Zacarías liñi indu zeꞌe la acaꞌlla nilla, che uriꞌi beella beyaꞌ nú nuꞌ nú ulubeꞌ Diose lulla, nu rriꞌitsialla seña lubeella xne la niaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Chequie chenu ulaxu bee bichia nú uzibiꞌ Zacarías liñi indu zeꞌe chu nzialla niꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Cheela bee bichia zeꞌe, uyuꞌu enduꞌ xlaꞌcu unaꞌalla Elisabet, nu diqui ayuꞌ uu né chiuaꞌalla niꞌlla, nu uriꞌilla elliebacuꞌ nú unilla: ");
INSERT INTO zplNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Uriꞌi Diose lua scua, para nú la tsequichiaꞌ bee bene liꞌá.” ");
INSERT INTO zplNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Chenu uzaꞌ xuꞌcu uu, uxeꞌla Diose ángele enu lee Gabriel lu tucu eyeche nú lee Nazaret nú nchiñi lu iliu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Para nú nze biꞌya ángele quieꞌ tucu unaꞌa eꞌne enu lee María, liꞌilla nzula nú yuculla tucu niyu enu lee José, nzeꞌta José quieꞌ lubee beneꞌ tuxie arre David. ");
INSERT INTO zplNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chequie uyuꞌu ángele zeꞌe liñi niꞌi elu nzucu María nu uni ángele quieꞌ lulla: ―¡Malune María, liꞌilu enu ucañila Diose! Nzu Diose Paa liñibe cuna liꞌilu, nu uriꞌi leꞌyalanu liꞌilu lu ye bee unaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chenu ulañiꞌ María ángele zeꞌe, chiquiꞌ uyanu arquiꞌlla bee bedichiaꞌ nú uni ángele cuaꞌ, nu leꞌca uriꞌilla elliebacuꞌ nú xa neca bee bedichiaꞌ cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chequie uni zeca ángele zeꞌe lulla: ―María, la lliquilu, xne ucañila Diose liꞌilu nu uriꞌinu nú cha nzeꞌca lu cuendaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nee chuꞌu tucu enduꞌ xlaꞌculu, nu chenu ala enduꞌ quieꞌ hualeelunu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Liꞌinu luꞌcunu nú chiquiꞌ recanu, nu hualee bee bene liꞌinu Lliꞌñi Diose liñibe, leꞌca riꞌi Diose liñibe nú acanu arre, tucu nú unga David arre, beneꞌnu enu udetela, ");
INSERT INTO zplNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","para nú nibiyaꞌnu lubee bene Israel diqui tiembu. Nu leca xunga laxu nú rnibiyaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Che uni María lu ángele zeꞌe: ―¿Xa modo nú aca nucuaꞌ scua, nu la nzucuꞌnua niꞌ tucu niyu? ");
INSERT INTO zplNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nu ucuaqui ángele zeꞌe lu María: ―Luꞌculu enduꞌ cuaꞌ equie cuendaꞌ Espíritu Santo, hora zeꞌe lunú reca Diose liñibe duꞌnu xcaꞌlaꞌ equielu tucu nú rduꞌ xcabe xcaꞌlaꞌ equie bee bene. Enzeꞌe enduꞌ enu luꞌculu leca xunga riꞌinu dula nu hualee bee bene liꞌinu Lliꞌñi Diose liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Leꞌca enta nú luꞌcu saꞌlu Elisabet tucu enduꞌ, añinzuca nú unguxulalla, liꞌilla enu rni bee bene nú lecaꞌ modo nú luꞌcu enduꞌ pero necala xuꞌcu uu nú nuꞌ enduꞌ xlaꞌculla. ");
INSERT INTO zplNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Xne leca niꞌ tucu nú neriñaꞌ para Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chequie uni María lu ángele zeꞌe: ―Nzua para nú zibiaꞌa lu Diose, riꞌinu tucu nú niarquiꞌnu cuna liꞌá. Chenu ulaxu nú uni María scua, chu nzia ángele zeꞌe che. ");
INSERT INTO zplNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bee bichia zeꞌe, uchiuꞌu María nza lu tucu eyeche nú nchiucuꞌ dañi lu iliu Judea, ");
INSERT INTO zplNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","nu chenu uyuꞌu María liñi niꞌ Zacarías unilla malune lu Elisabet. ");
INSERT INTO zplNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chenu ubeneꞌ Elisabet nú uni María malune lulla, ucuñi enduꞌ enu nuꞌ xlaꞌcu Elisabet, scua chiquiꞌ uyaꞌna Espíritu Santo cuna Elisabet. ");
INSERT INTO zplNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chequie, juerte uni Elisabet lu María: ―¡Uriꞌi leꞌyala Diose liꞌilu lu ye bee unaꞌa, leꞌca uriꞌi leꞌyala Diose enduꞌlu enu nzu nú ala! ");
INSERT INTO zplNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ti necaa nú nzeꞌta biꞌya naꞌ Diosea liꞌá? ");
INSERT INTO zplNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","María chenu unilu malune lua, ucuñi enduꞌ enu nuꞌ xlaꞌcua equie nú ñia nzu arquiꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Neca nzeꞌca nú uchili arquiꞌlu María, xne yalu tucu nú uni Diose lulu! ");
INSERT INTO zplNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chequie uni María: Chiquiꞌ rnia bedichiaꞌ nzeꞌca lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ñia nzu arquia lu Diose enu tsilaꞌa liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Xne ubiꞌyanu caa nzua, añinzuca nú necatsia tucu bene enu sibiꞌ lunu, nu hasta nee nu diqui tiembu ni bee bene nú ñia nza nzeꞌcae lu cuendaa. ");
INSERT INTO zplNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Xne uriꞌi Diose enu reca yeene huaxi nú neca nzeꞌca lua. ¡Nu Santo neca nú leenu! ");
INSERT INTO zplNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nu la tsuxe Diose nú rluꞌcu arquiꞌnu ye bee bene enu rluꞌcu ulaꞌna lunu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Huaxi nú uriꞌinu equie nú recanu. Nu ullitiꞌnu elliebacuꞌ bee bene enu nelliña. ");
INSERT INTO zplNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Leꞌca unguxi Diose nú rnibiyaꞌ bee bene enu rnibiyaꞌ, nu udeteꞌnu nú reca bee bene enu lleꞌna arquiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Udeteꞌnu lunú secalaꞌchaꞌ bee bene enu seca elitsi nu lecaxi udeteꞌnu lubee bene xene. ");
INSERT INTO zplNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Uriꞌinu elietsa lubee bene Israel, enu neca beneꞌnu, nu lá zañiꞌnu nú uluꞌcu arquiꞌnu liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tucu nú uninu lubee beneaꞌhua enu udetela lu Abraham cuna lubee bene enu nzeꞌta lu Familiꞌlla. Nu leca xunga tsanaꞌ arquiꞌnu liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Uyaꞌna María niꞌi Elisabet tucu chuna uu, cheela nzia María niꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chequie chenu uzaꞌ bichia nú ungula enduꞌ Elisabet, ungula tucu enduꞌ niyuꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Che bee besiñuꞌlla cuna bee saꞌlla uya biꞌya beella liꞌilla nu ñia utsu arquiꞌbeella, xne uriꞌi beella beyaꞌ nú ñia uhuaꞌa arquiꞌ Diose liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chenu uzaꞌ enduꞌ zeꞌe xunu bichia, uya beella para nú quie seña elu necachiꞌnu, tucu nú rquie seña bee niyu enu neca bee bene Israel. Nu niarquiꞌ beella nú achiuꞌulee endu zeꞌe Zacarías tucu nú lee paꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero uni naꞌnu lubee bene zeꞌe: ―La chiuꞌuleenu scua. Juan chiuꞌuleenu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Che uni beella lulla: ―¿Xinú chiulee enduꞌlu Juan nu niꞌ tucu bee saꞌhua la lee Juan? ");
INSERT INTO zplNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chequie cuna seña unidichiaꞌ beella lu paꞌ enduꞌ zeꞌe, para nú riꞌi beella beyaꞌ xa niarquiꞌlla nú chiuꞌlee enduꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nu unacuꞌ paꞌ enduꞌ zeꞌe teleꞌe ala para nú quieꞌella lu ala xa chiuꞌulee enduꞌlla, nu uquieꞌella lu ala zeꞌe: “Juan chiuꞌleenu.” Chiquiꞌ uyanu arquiꞌ bee bene zeꞌe nú uriꞌilla scua. ");
INSERT INTO zplNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hora zeꞌe uyaꞌla zeca nú uni Zacarías, nu unilla bedichiaꞌ nzeꞌca lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chequie ye bee besiñuꞌ beella chiquiꞌ uyanu arquiꞌbeella, nu ye bee bene bee eyeche nú nchiucu dañi Judea ubeneꞌ beella lunú ungae scua. ");
INSERT INTO zplNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ye bee bene enu ungabiyaꞌ nucuaꞌ unibeei lu saꞌbeei: ―¿Xi nzeꞌta nú aca enduꞌ cuaꞌ? Xne che rlubeꞌ nú nzu Diose cuna enduꞌ cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chequie Zacarías paꞌ enduꞌ zeꞌe, chiquiꞌ nzu Espíritu Santo cuna liꞌilla, nu uquixiella unilla bedichiaꞌ nú uliquiꞌ Diose nú unilla: ");
INSERT INTO zplNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Cheꞌtsalá Diose liñibe liꞌinu enu neca Diose lubee bene Israel, xne uriñanu para nú tsilaꞌanu liaꞌahua enu neca bee beneꞌnu! ");
INSERT INTO zplNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Uxeꞌla Diose luꞌahua tucu enu chiquiꞌ reca para nú tsilaꞌa liaꞌahua, necanu enu nzeꞌta lubee beneꞌ arre David enu uzibiꞌ lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Scua neca nú ucuaqui uꞌna Diose hasta huaꞌtu tucu nú udixiuleꞌe bee profetaꞌnu enu uhuañi nzeꞌca lunu: ");
INSERT INTO zplNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nu tsilaꞌanu liaꞌahua lubee bene enu rlee luaꞌahua cuna lubee bene enu rana arquiꞌ liaꞌahua, ");
INSERT INTO zplNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","cuna nú huaꞌa arquiꞌnu bee beneꞌahua enu udetela nu la zañiꞌnu lunú ucuaqui uꞌnanu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ninguieꞌ neca nú ucuaqui uꞌna Diose lu Abraham beneꞌahua enu udetela: ");
INSERT INTO zplNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nú tsilaꞌanu liaꞌhua lubee bene enu rlee luaꞌahua, para nú acaꞌahua zibiaꞌahua lunu nu la lliquiaꞌahua, ");
INSERT INTO zplNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","para nú huañiaꞌahua tucu nú niarquiꞌnu, cuna nú riaꞌahua tucu nú neli neca lunu, diqui tiembu lunú nehuañiaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nu liꞌilu endua, chiuꞌuleelu profetaꞌ Diose liñibe, xne liꞌilu cha rlutilu, para nú tsúcheꞌlu inziu nú riña liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nu ixiuleꞌelu lubee bene para nú riꞌi beella beyaꞌ nú xa riꞌi Diose perdona stula beella cuna nú tsilaꞌanu liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Xne seca Dioseꞌahua liaꞌahua cuna nú uhuaꞌa arquiꞌnu liaꞌahua, enzeꞌe xeꞌlanu Lliꞌñinu xi neca ellieꞌ bichia luaꞌahua, ");
INSERT INTO zplNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","para nú xaꞌlanu elliebacuꞌ bee bene enu nchiñi arquiꞌ lunú necha neca, cuna lubee bene enu nza lu inziu nú nze nitilu beei, nu lubeꞌnu liaꞌahua para nú huañiaꞌahua tucu nú riala nú huañiaꞌhua lunu. ");
INSERT INTO zplNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ubeꞌtaruꞌcu enduꞌ Zacarías cuna nú naaqui utsutaꞌ arquiꞌlla lunú neca cuendaꞌ Diose, nu uhuañilla lu dañi achi elu la nucuaꞌa bene, desde bichia nú uquixiella nú udixiuleꞌella Stichiaꞌ Diose lubee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Bee bichia zeꞌe, unibiyaꞌ arre César Augusto nú sucu ichi ye bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nu bese rlu nú uzucu ichi bee bene che neca Cirenio gobernador lu iliu Siria. ");
INSERT INTO zplNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chequie ye bee bene rquiꞌña nú nza beella lachi beella para nú zucu ichi beella zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Enzeꞌe, uchiuꞌu José eyeche Nazaret, nú nchiñi lu iliu Galilea, nu uyalla lu iliu Judea eyeche Belén, elu ungula tuxie arre David, xne lubee familiꞌ tuxie arre David nzeꞌta José. ");
INSERT INTO zplNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Uya José eyeche Belén para nú zucu ichilla cuna María, enu nzula nú yuculla nu nuꞌla enduꞌ xlaꞌcu María. ");
INSERT INTO zplNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Chequie diqui nú nucuaꞌa beella eyeche Belén, uriña bichia nú ala enduꞌ María. ");
INSERT INTO zplNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Zeꞌe ungula enduꞌ rluꞌlla liñi niꞌ bee nañi nu utelalla tucu laquie liꞌinu nu chu udixiulla liꞌinu liñi tucu cajón elu riuꞌu nú racu bee nañi, xne lecaꞌ luhuare elu yaꞌna beella liñi niꞌi elu riaꞌna bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Axu eyeche Belén zeꞌe nucuaꞌa chiucu chuna bene enu rriucu bee sanchi nu riaꞌna beella dañi rula cuna bee sanchi. ");
INSERT INTO zplNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Che tuꞌnatsia ulubeꞌlu tucu ángeleꞌ Diose lubeella, nu uduꞌllieꞌe ellieꞌe Diose diqui abenchilaꞌ beella, nu chiquiꞌ ulliqui beella. ");
INSERT INTO zplNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nu uni ángele zeꞌe lubeella: ―La lliquihua, xne uriñayua tucu resuna nzeꞌca luhua, nu equie cuendaꞌ resuna quieꞌ tsu nzeꞌca arquiꞌ ye bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nee lachi David ungula tucu enu tsilaꞌa liꞌihua, necanu Cristo, enu rluꞌcu nú rnibiyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nu para nú chuluhua enduꞌ quieꞌ, llelaꞌhua liꞌinu liñi niꞌi bee nañi nebelanu tucu laquie nu nchiucuꞌnu liñi tucu cajón elu riuꞌu nú racu bee nañi. ");
INSERT INTO zplNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hora zeꞌe ulubeꞌlu huaxilá bee ángele liñibe elu nzu ángele zeꞌe, nu rni bee ángele cuaꞌ bedichiaꞌ nzeꞌca lu Diose nú uni beenu: ");
INSERT INTO zplNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Cheꞌtsalá Diose enu nzucu liñibe! ¡Chuꞌu nú nzuxee lu iliulabe, para bee bene enu rriꞌi tucu nú riuꞌ arquiꞌnu! ");
INSERT INTO zplNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chequie chenu uquie bee ángele zeꞌe liñibe, bee bene enu rriucu bee sanchi zeꞌe uni beella lusaꞌbeella: ―Chaahua eyeche Belén, che biꞌyaꞌahua lunú unga zeꞌe tucu nú udixiuleꞌe Diose Pa liñibe luaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nu yexetsia nzuebeella nu ullelaꞌ beella María cuna José liñi niꞌ bee nañi cuna enduꞌ meꞌ zeꞌe, nu nchiucuꞌnu liñi tucu cajón elu riuꞌu nú racu bee nañi. ");
INSERT INTO zplNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chenu ulañiꞌ beella nucuaꞌ, uni beella lunú udixiuleꞌe ángele lubeella equie cuendaꞌ enduꞌ zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","che uyanu arquiꞌ ye bee bene enu ubeneꞌ lunú uni bee bene enu rriucu bee sanchi. ");
INSERT INTO zplNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero uducheꞌtsia María ye bee bedichiaꞌ cuaꞌ arquiꞌlla, cuna nú rriꞌilla elliebacuꞌ lu cuendaꞌ nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chequie chenu ubenchilaꞌ bee bene enu rriucu bee sanchi chiquiꞌ ñia nzu arquiꞌ beella rdeteꞌ beella cheꞌtsa lu Diose, cuna nú rni beella bedichiaꞌ nzeꞌca lunu lu ye nú ulañiꞌ beella cuna nú ubeneꞌ beella, xne unga ye tucu nú udixiuleꞌe ángele lubeella. ");
INSERT INTO zplNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chenu uzaꞌ xunu bichia nú ungula Jesuse uquie seña elu necachiꞌnu, tucu nú rquie seña elu necachiꞌ bee niyu enu neca bee bene Israel, nu uhualee beella liꞌinu Jesuse, tucu nú udixiuleꞌe ángele lu María ante nú chuꞌunu xlaꞌculla. ");
INSERT INTO zplNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chenu uzaꞌ bee bichia nú uriꞌi María tucu nú rnibiyaꞌ leyꞌ Moisés nú rriꞌi bee unaꞌa chenu rala enduꞌ beenchu, che unguyaꞌ beella Jesuse liñi indu llene Jerusalén lu Diose Paa liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Uriꞌi beella scua, xne rni leyꞌ Diose: “Ye bee enduꞌ niyu enu neca enduꞌ rlu necala beei para Diose.” ");
INSERT INTO zplNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Che uyayu beella uꞌna lu Diose tucu nú rnibiyaꞌ leyꞌ Diose, chiucu cuꞌcu urre chiucu paloma. ");
INSERT INTO zplNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tiembu zeꞌe uhuañi tucu bene eyeche Jerusalén enu lee Simeón. Ungalla tucu bene nzeꞌca, nu chiquiꞌ rluꞌculla ulaꞌna lu Diose nzuquieella lañiꞌlla bene enu tsilaꞌa bee bene Israel. Nu nzu Espíritu Santo cuna liꞌilla, ");
INSERT INTO zplNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","equie cuendaꞌ Espíritu Santo ungabiyaꞌ Simeón nú la atiscaꞌlla hasta nú lañiꞌlla Cristo, enu xeꞌla Diose enu rluꞌcu nú rnibiyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Leꞌca uduꞌ Espíritu Santo arquiꞌ Simeón nú uyalla liñi indu llene Jerusalén. Nu chenu uyanu paꞌ Jesuse liꞌinu cuna naꞌnu liꞌinu liñi indu zeꞌe para nú uya riꞌi beella tucu nú rnibiyaꞌ leyꞌ Moisés nú riꞌi bee bene, ");
INSERT INTO zplNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","che unaꞌtse Simeón Jesuse nu uchiꞌchilla liꞌinu nu unilla bedichiaꞌ nzeꞌca lu Diose, nú unilla: ");
INSERT INTO zplNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Diose Paa liñibe nuꞌ modo zelalu nú atia lecaꞌ xi chenuarquia nee, xne uzaꞌla lunú ucuaqui uꞌnalu lua. ");
INSERT INTO zplNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nee si ulañilá bene enu tsilaꞌa liꞌiru nee, ");
INSERT INTO zplNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","liꞌinu necanu, enu uxeꞌlalu lu ye bee bene iliulabe, ");
INSERT INTO zplNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Liꞌinu necanu xi neca ellieꞌe nú xaꞌla elliebacuꞌ bee bene enu la neca bee bene Israel. Nu chiquiꞌ aca neca equienu lubee beneꞌlu enu neca bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chiquiꞌ uyanu arquiꞌ José cuna María naꞌ Jesuse chenu ubeneꞌ beella lunú uni Simeón scua equie cuendaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Chequie uriꞌi leꞌya Simeón beella, nu unilla lu María, naꞌ Jesuse: ―Ixiuleꞌa lulu María nú utsula Diose enduꞌ quieꞌ, nú huaxi bee bene Israel la chili arquiꞌ liꞌinu, nu leꞌca huaxi bee bene chili arquiꞌ liꞌinu, nu uriñanu para nú zeteꞌnu bee bene xa niarquiꞌ Diose nú huañi beei, pero huaxi bee bene la yucu arquiꞌ liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nu scua riꞌinu beyaꞌ xa neca elliebacuꞌ cada tucua bee bene. Pero liꞌilu María xi neca chenu rdete tucu espada arquiꞌ tucu bene scua tsiꞌlu chenu aca bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Leꞌca liñi indu zeꞌe nzucu tucu unaꞌa enu neca profeta. Liꞌilla leella Ana, nu necalla xinchiuꞌcu Fanuel enu nzeꞌta lu familiꞌ Aser, unguxulalla. Nu chiquiꞌ nereꞌneꞌlla chenu uchialla nu uzucunulla niyuꞌlla achi lana, ");
INSERT INTO zplNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","nu ungala ochenta y cuatro lana nú uyaꞌna zaquilla. Niꞌ tucu bichia la dete seella indu, ye bichia nzuculla liñi indu rnacuꞌlla lu Diose, nu rdeteꞌlla bichia nú la aculla equie nú rluꞌculla ulaꞌna lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Chenu rdichiaꞌnu María Simeón, hora zeꞌe uriña Ana, chenu ulaxu nú udeteꞌlla cheꞌtsa lu Diose uquixiella nú unilla equie cuendaꞌ Jesuse lu ye bee bene enu nzuquie nú riña bene enu tsilaꞌa Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Chequie chenu ulaxu nú uriꞌi José cuna María lu ye nú rnibiyaꞌ leyꞌ Diose, ubenchilaꞌ zeca beella lachi beella Nazaret nú nchiucuꞌ lu iliu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Diqui nú nzeꞌta ruꞌcu Jesuse, nze aca naaquinu cuna nú chiquiꞌ reca elliebacuꞌnu nu chiquiꞌ uriꞌileꞌya Diose liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Zaꞌlana se José cuna María eliñi baxcu eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chenu uzaꞌ Jesuse chiꞌchiucu lana, uya ye beella Jerusalén, tucu nú neca costumbreꞌ beella nú see beella eliñi baxcu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pero chenu ubenchilaꞌ beella nú ulaxu eliñi zeꞌe, né riꞌi José cuna María beyaꞌ nú uyaꞌna Jesuse Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Uriꞌi beella elliebacuꞌ nú tia nzeꞌtanu leta bee bene, nu utsela beella tucu bichia lu inziu, pero chenu ucuaꞌna beella liꞌinu leta bee beneꞌ beella, cuna leta bee bene enu nuꞌlu beella, ");
INSERT INTO zplNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","né llelaꞌ beella liꞌinu leta bee bene zeꞌe. Che ubenchilaꞌ zeca beella Jerusalén nze laꞌna beella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chenu udete chuna bichia ullelaꞌ beella liꞌinu liñi indu llene Jerusalén, nzucunu leta bee ulaxcuela enu reca leyꞌ Moisés, nu sucuꞌ diacanu nú rni beella nu rdichiaꞌnunu beella. ");
INSERT INTO zplNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Che ye bee bene enu rieneꞌ nú rninu, chiquiꞌ uyanu arquiꞌbeella lunú chiquiꞌ recanu, nu leꞌca nzenu arquiꞌbeella lunú xa ucuaquinu lubeella. ");
INSERT INTO zplNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chenu ulañiꞌ José cuna María liꞌinu, uyanu arquiꞌbeella, nu uni María naꞌnu lunu: ―Endua, ¿xinu uriꞌilu scua? Paꞌlu cuna liꞌá chiquiꞌ nzenu arquiꞌru rlaꞌnaru liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Che ucuaqui Jesuse lubeella: ―¿Xinu rlaꞌnahua liꞌá? ¿Xieꞌ la riꞌihua beyaꞌ nú rquiꞌña nú riꞌá riñaꞌ paa la? ");
INSERT INTO zplNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero lá riꞌi beella beyaꞌ xinu uninu scua. ");
INSERT INTO zplNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Che ubenchilaꞌnunu liꞌibeella eyeche Nazaret, nu uzucuꞌnu ye nú rni beella, pero María naꞌnu uducheꞌtsialla ye bee nucuaꞌ arquiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nu nzeꞌta ruꞌculá Jesuse cuna nú chiquiꞌ nze aca elliebacuꞌnu, nu ñia nzu arquiꞌ Diose lunu. Leꞌca ñia nzu arquiꞌ bee bene lunu. ");
INSERT INTO zplNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chenu unga chiñuꞌ lana nú rnibiyaꞌ arre Tiberio César diqui lu iliulabe, che neca Poncio Pilato gobernador Judea, nu neca Herodes gobernador Galilea, nu bichilla Felipe neca gobernador Iturea cuna lu iliu Traconite, nu Lisanias neca gobernador Abilinia. ");
INSERT INTO zplNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Chequie Anás cuna Caifás unga uleꞌya enu mase rnibiyaꞌ lu beelá bee uleꞌya. Bee bichia zeꞌe uni Diose lu Juan llianaꞌ Zacarías lu dañi achi elu la nucuaꞌa bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nu uya Juan lu ye bee eyeche nú nchiucuꞌ axu reꞌcu Jordán, nu unilla lubee bene nú cheꞌe arquiꞌ bee bene lu stula beei cuna nú rinza beei, para nú riꞌi Diose perdona liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Scua uyalu tucu nú uquieꞌe profeta Isaías huaꞌtu, xne liꞌilla uquieꞌella nucuaꞌ nú rni: Lu tucu dañi achi elu la nucuaꞌa bee bene, riene tucu chii bene nu rixialilla nú nilla: “Utsu tsiñahua arquiꞌhua xne nzeꞌta liꞌinu enu neca Dioseꞌahua; utsanaꞌ arquiꞌhua stulahua para nú yucu arquiꞌhua stichiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Utsucheꞌ nzeꞌcahua arquiꞌhua tucu nú reca teriallu tucu erluu, nu utsanaꞌ arquiꞌhua elulliña cuna elurutiꞌ tucu nú reca teriallu elu neca loma cuna dañi, ubenchilaꞌ arquiꞌhua lu inziuꞌ Diose tucu nú rlí inziu nú nerenguie, nu utsucheꞌ nzeꞌcahua arquiꞌhua tucu nú neca inziu nú necacheꞌ nzeꞌca. ");
INSERT INTO zplNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Chequie ye bee bene iliulabe lañiꞌ liꞌinu enu tsilaꞌa bee bene, enu xeꞌla Diose.” ");
INSERT INTO zplNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chenu uriña bee bene para nú rinza Juan liꞌibeei unilla lubeei: ―¡Liꞌi sihua netsiñahua xi netsiña bee beꞌla! ¿Ti udixiuleꞌe luhua nú tsilaꞌahua lu castiya juerte nú nzula? ");
INSERT INTO zplNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Uhuañi nzeꞌcahua para nú acachee nú neli nú ucheꞌe arquiꞌhua lu stulahua, nu la nihua: “Liꞌiru necaru enu nzeꞌta lubee beneꞌ tuxie Abraham”; xne nia luhua nú hasta bee quiee quieꞌ aca Diose riꞌi nú aca bee beneꞌ tuxie Abraham. ");
INSERT INTO zplNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pero bee bene enu la nehuañi nzeꞌca tucu nú rnibiyaꞌ Diose, riꞌinu lubeei tucu nú rriꞌinu bee bene aca ndixi chenu la ayuaꞌ ndixí lue. Xiecuꞌ beei aca zeꞌe nu siquiꞌ beeii lu quii. ");
INSERT INTO zplNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chequie unidichiaꞌ bee bene lu Juan: ―¿Xi riala riꞌiru che? ");
INSERT INTO zplNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nu ucuaqui Juan lubeei: ―Enu rluꞌcu chiucu xucu, deteꞌnzeꞌe tucue utu bene enu la luꞌcune, nu enu nuꞌ nú racu deteꞌ nzeꞌe lleꞌnae lubee bene enu seca laꞌchaꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Leꞌca uriña chiucu chuna bee bene enu rriꞌi cubre impuestos lu Juan para nú rinza Juan liꞌibeei, nu unidichiaꞌ beei lu Juan: ―Maestro, liꞌiquieru ¿xi riala riꞌiru? ");
INSERT INTO zplNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Che uni Juan lubeei: ―La riꞌihua cubre maselá lunú riala rriꞌihua cubre. ");
INSERT INTO zplNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Leꞌca unidichiaꞌ chiucu chuna bee sundado lu Juan: ―¿Nu liꞌiquieru xi riala riꞌiru? Nu uni Juan lubeei: ―La axihua steneꞌ bee bene, nu la taꞌhua eluquichiaꞌ bee bene enu lecaxi uriꞌi para nú nuꞌ xi liquiꞌ beei luhua, nu uriꞌihua conforme lunú riaxutsiahua. ");
INSERT INTO zplNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bee bene zeꞌe niarquiꞌ beei nú alaꞌ riꞌixu beei beyaꞌ tunu neca Juan Cristo, ");
INSERT INTO zplNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","pero uni Juan lubeei: ―Liꞌá rrinza liꞌihua cuna inza. Pero nzeꞌta liꞌinu enu rinza bee bene cuna Espíritu Santo nu cuna quii. Liꞌinu necanu enu chiquiꞌ nibiyaꞌ luquelá liꞌá, nu niꞌ nú hua lucunu la yala xne neca equielánu lua. ");
INSERT INTO zplNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tucu nú rcui bee bene trigo, scua riꞌinu lubee bene, bee bene enu nehuañi tucu nú rialane, deteꞌnu nú huañi bee bene zeꞌe elu rnibiyaꞌnu, nu bee bene enu la nehuañi tucu nú rialane, xeꞌlanu liꞌibeei lu quii nú leca xunga yala. ");
INSERT INTO zplNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Scua neca nú uni Juan lubeei, nu cuna huaxilá bee bedichiaꞌ nzeꞌca unilla bezeteꞌ lubeei, nu udixiuleꞌella bedichiaꞌ nzeꞌcaꞌ Diose lubeei. ");
INSERT INTO zplNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Leꞌca uquiꞌyaꞌ arre Herodes uriꞌi Juan, xne nzucunu Herodes Herodías unaꞌa bichilla Felipe, cuna equie huaxilá beenú necha neca uriꞌi Herodes. ");
INSERT INTO zplNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero Herodes luhuare nú zucuꞌlla lunú uni Juan, uriꞌi Herodes stucu nú necha neca: Nú uduꞌlla Juan niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Chequie chenu urinza Juan bee bene, leꞌca urinzalla Jesuse, diqui nú rnacuꞌ Jesuse lu Diose uyaꞌla liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nu ulaca Espíritu Santo equienu xi neca tucu paloma, nu ubene tucu chii enza liñibe nu uni chii zeꞌe: ―Liꞌilu necalu Lliꞌñia nu chiquiꞌ seꞌca liꞌilu nu ñia nzu arquia lulu. ");
INSERT INTO zplNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nza Jesuse tucu ala llichiꞌi lana chenu uquixienu uzeteꞌnu Stichiaꞌ Diose lubee bene. Nu nzeli arquiꞌ bee bene nú unga Jesuse xi neca lliꞌñi José. Nu unga José, lliñi Elí, ");
INSERT INTO zplNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí unga lliꞌñi Matat, Matat unga lliꞌñi Leví, Leví unga lliꞌñi Melqui, Melqui unga lliꞌñi Jana, Jana unga lliꞌñi José, ");
INSERT INTO zplNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José unga lliꞌñi Matatías, Matatías unga lliꞌñi Amós, Amós unga lliꞌñi Nahum, Nahum unga lliꞌñi Esli, Esli unga lliꞌñi Nagai. ");
INSERT INTO zplNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai unga lliꞌñi Maat, Maat unga lliꞌñi Matatías, Matatías unga lliꞌñi Semei, Semei unga lliꞌñi José, José unga lliꞌñi Judá. ");
INSERT INTO zplNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá unga lliñi Joanán, Joanán unga lliꞌñi Resa, Resa unga lliꞌñi Zorobabel, Zorobabel unga lliꞌñi Salatiel, Salatiel unga lliꞌñi Neri. ");
INSERT INTO zplNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri unga lliꞌñi Melqui, Melqui unga lliꞌñi Adi, Adi unga lliꞌñi Cosam, Cosam unga lliꞌñi Elmodam, Elmodam unga lliꞌñi Er. ");
INSERT INTO zplNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er unga lliꞌñi Josué, Josué unga lliꞌñi Eliezer, Eliezer unga lliꞌñi Jorim, Jorim unga lliꞌñi Matat. ");
INSERT INTO zplNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat unga lliꞌñi Leví, Leví unga lliꞌñi Simeón, Simeón unga lliꞌñi Judá, Judá unga lliꞌñi José, José unga lliꞌñi Jonán, Jonán unga lliꞌñi Eliaquim, ");
INSERT INTO zplNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim unga lliꞌñi Melea, Melea unga lliꞌñi Mainán, Mainán unga lliꞌñi Matata, Matata unga lliꞌñi Natán, ");
INSERT INTO zplNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán unga lliꞌñi David, David unga lliꞌñi Isaí, Isaí unga lliꞌñi Obed, Obed unga lliꞌñi Booz, Booz unga lliꞌñi Salmón, Salmón unga lliñi Naasón, ");
INSERT INTO zplNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón unga lliꞌñi Aminadab, Aminadab unga lliꞌñi Aram, Aram unga lliꞌñi Esrom, Esrom unga lliꞌñi Fares, Fares unga lliꞌñi Judá, ");
INSERT INTO zplNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá unga lliꞌñi Jacob, Jacob unga lliꞌñi Isaac, Isaac unga lliꞌñi Abraham, Abraham unga lliꞌñi Taré, Taré unga lliꞌñi Nacor, ");
INSERT INTO zplNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor unga lliꞌñi Serug, Serug unga lliꞌñi Ragau, Ragau unga lliꞌñi Peleg, Peleg unga lliꞌñi Heber, Heber unga lliꞌñi Sala, ");
INSERT INTO zplNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala unga lliꞌñi Cainán, Cainán unga lliꞌñi Arfaxad, Arfaxad unga lliꞌñi Sem, Sem unga lliꞌñi Noé, Noé unga lliꞌñi Lamec, ");
INSERT INTO zplNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec unga lliꞌñi Matusalén, Matusalén unga lliꞌñi Enoc, Enoc unga lliꞌñi Jared, Jared unga lliꞌñi Mahalaleel, Mahalaleel unga lliꞌñi Cainán, ");
INSERT INTO zplNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán unga lliꞌñi Enós, Enós unga lliꞌñi Set, Set unga lliꞌñi Adán, Adán unga lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Chiquiꞌ nzu Espíritu Santo cuna Jesuse, chenu uchiuꞌnu reꞌcu Jordán, nu unguyaꞌ Espíritu Santo liꞌinu lu tucu dañi achi elu la nucuaꞌa bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Zeꞌe uyaꞌnanu chiuaꞌa bichia cuna rulaꞌ, nu né acunu ye bee bichia zeꞌe. Che uliaꞌnaꞌnu nu uriꞌi bezeꞌlu preo liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Chequie uni bezeꞌlu lunu: ―Tunu neli nú necalu Lliꞌñi Diose, unibiyaꞌ nú aca quiee quieꞌ pá. ");
INSERT INTO zplNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nu ucuaqui Jesuse lu bezeꞌlu: ―Lu ichiꞌ Stichiaꞌ Diose rni: “La huañi bee bene lu cuendaꞌ pá tsia, leꞌca huañi bee bene lunú neca Stichiaꞌ Diose.” ");
INSERT INTO zplNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Che uyanu bezeꞌlu liꞌinu equie tucu dañi elu ayaa, nu hora zeꞌe ulubeꞌ bezeꞌlu lunu nzieꞌ bee nación iliulabe, ");
INSERT INTO zplNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","nu uni bezeꞌlu lunu: ―Liquia lulu ye elurnibiyaꞌ nú nuꞌ lubee nación quieꞌ cuna ye bee eluxene nú nuꞌ lue. Xne ye bee nucuaꞌ neca stenea, nu detea bee nucuaꞌ lu enu niarquia. ");
INSERT INTO zplNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tunu tsu lliquilu lua nu chiquiꞌ luꞌculu ulaꞌna lua, che ye bee nucuaꞌ aca steneꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero ucuaqui Jesuse nú uninu: ―Lu ichiꞌ Stichiaꞌ Diose rni: “Uluꞌcu ulaꞌna lu tucutsia Diose Pa liñibe, nu tucutsia lunu zibiꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chequie uyanu bezeꞌlu liꞌinu eyeche Jerusalén, nu uquienuu bezeꞌlu liꞌinu equie indu llene Jerusalén nu uni lunu: ―Tunu neli nú necalu Lliꞌñi Diose, utsanaꞌ liꞌilu hasta caꞌa nu hasta lu yuu. ");
INSERT INTO zplNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Xne rni lu ichiꞌ Stichiaꞌ Diose: Xeꞌla Diose bee ángeleꞌnu para nú riꞌi ucu beenu liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Cuna nú naꞌtse beenu liꞌilu, para nú la tiꞌqui bee quiee cuchiuꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Che ucuaqui Jesuse lu bezeꞌlu: ―Leꞌca rni lu ichiꞌ Stichiaꞌ Diose: “La riꞌilu preo Diose Pa liñibe.” ");
INSERT INTO zplNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chequie chenu né llelaꞌ bezeꞌlu xa riꞌi preo Jesuse, utsanaꞌi liꞌinu lleꞌna tiembu. ");
INSERT INTO zplNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ubenchilaꞌ zeca Jesuse lu iliu Galilea, nu chiquiꞌ nzu lunú reca Espíritu Santo cuna liꞌinu, cuna nú chiquiꞌ rni bee bene lu cuendaꞌnu ye bee luhuare zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Seteꞌnu bee bene liñi induꞌ bee bene Israel cada bee luhuare, nu rni nzeꞌca bee bene lu cuendaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Uya Jesuse eyeche Nazaret, elu ubeꞌta ruꞌcunu. Chequie bichia nú sulachi bee bene Israel, uyuꞌunu liñi induꞌ beella tucu nú neca costumbreꞌnu, nu utsulínu nu ungulanu lu ichiꞌ Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Udeteꞌ beella ichiꞌ nú uquieꞌe profeta Isaías yanu, nu chenu uxaꞌlanu lu ichiꞌ zeꞌe uxaꞌlanu tucu luhuare elu rni: ");
INSERT INTO zplNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nzu Espírituꞌ Diose Pa liñibe cuna liꞌá, xne uriꞌi leꞌyalanu liꞌá para nú ixiuleꞌa bedichiaꞌ nzeꞌcaꞌ Diose lubee bene elitsí; uxeꞌlanu liꞌá para nú riꞌá elietsa lubee bene enu nehuana nzu arquiꞌ, cuna nú ixiuleꞌa lubee bene nú xa tsilaꞌa beei lu dula nú rnibiyaꞌ lubeei, cuna nú riꞌiyecaa iculu bee bene enu niquieꞌlu, cuna nú riꞌá elietsa lubee bene enu nehuana seca. ");
INSERT INTO zplNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nu para nú ixiuleꞌa lubee bene nú uriñala bichia nú tsilaꞌa Diose bee bene enu rcuaꞌna nú zucuꞌ nú rninu. ");
INSERT INTO zplNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Che chu utsacuꞌ Jesuse lu ichiꞌ zeꞌe, nu udeteꞌ cuendanue ya bene enu rriꞌi elietsa liñi indu zeꞌe nu chu uzucunu. Pero ye bee bene enu nucuaꞌa liñi indu zeꞌe riꞌyalí beei lunu. ");
INSERT INTO zplNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nu uquixienu nú uninu, lubeei: ―Bichia quieꞌ uyalu lunú rni lu ichiꞌ Stichiaꞌ Diose nú ubeneꞌ inzaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chequie ye bee bene zeꞌe uni nzeꞌca beei lu cuendaꞌ Jesuse, nu chiquiꞌ nzenu arquiꞌbeei nú ñia uninu bee bedichiaꞌ nzeꞌca lubeei. Nu unidichiaꞌ beei lu saꞌbeei: ―¿Lanú nucuaꞌ neca lliꞌñi José la? ");
INSERT INTO zplNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nu uni Jesuse lubeei: ―Nediyaa nú nihua lua bedichiaꞌ nú rni: “Doctor uriꞌiyeca leꞌcatsia liꞌilu.” Nu leꞌca nihua: “Lunú ubeneꞌru nú uriꞌilu eyeche Capernaúm, uriꞌi leꞌca scua lachilu caꞌa nee.” ");
INSERT INTO zplNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Chequie unilá Jesuse lubeei: ―Nia luhua nú niꞌtucu profeta la yucu nzeꞌca arquiꞌ bee bene lachilla liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Liꞌá nia luhua, nú tiembu nú uhuañi profeta Elías, ucuaꞌa huaxi bee unaꞌa zaqui diqui bee lu iliu Israel, chenu né laca quiu chuna lana arulaꞌ nu unga biñia diqui bee luhuare enza zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero né xeꞌla Diose Elías, para nú riꞌilla elietsa lu tucu unaꞌa zaqui Israel, uxeꞌla tsianu Elías para nú riꞌilla elietsa lu tucu unaꞌa zaqui eyeche Sarepta, axu eyeche Sidón. ");
INSERT INTO zplNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Leꞌca ucuaꞌa huaxi bee bene Israel enu ulleꞌca elichia nú lee lepra tiembu nú unga Eliseo profeta, pero né riꞌiyecalla niꞌ tucu bee bene cuaꞌ, uriyeca tsialla Naamán, enu neca bene Siria. ");
INSERT INTO zplNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chenu ubeneꞌ ye bee bene enu nucuaꞌa liñi indu zeꞌe bedichiaꞌ cuaꞌ, chiquiꞌ ulee beei. ");
INSERT INTO zplNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nu chu utsuli beei nu uhua beei Jesuse eyeche zeꞌe, nchiucuꞌ eyeche zeꞌe equie tucu dañi, che unguyaꞌ beei liꞌinu ruꞌu eyeche zeꞌe para nú nze tsiꞌqui beei liꞌinu hasta quierquie. ");
INSERT INTO zplNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero udetetsia Jesuse labe beei nu chu nzanu. ");
INSERT INTO zplNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Che uya Jesuse eyeche Capernaúm nú nchiucuꞌ lu iliu Galilea, nu zeꞌe uzeteꞌnu bee bene Satuꞌ bichia nú sulachi beei. ");
INSERT INTO zplNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Chiquiꞌ nzenu arquiꞌ bee bene lunú xa uzeteꞌnu liꞌibeei, xne uninu lubeei xi rni tucu bene enu chiquiꞌ rnibiyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Liñi indu zeꞌe nzucu tucu niyu enu nchiñi benechiquiꞌ arquiꞌ, nu juerte urixiali niyu zeꞌe nú uni: ");
INSERT INTO zplNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Utsanaꞌ liꞌiru! Jesuse bene eyeche Nazaret. ¿Xinu riꞌchialu liꞌiru? ¿Nzeꞌtalu para nú nitilulu liꞌiru la? Nuꞌlua liꞌilu nú necalu Beneꞌ Diose nu la luꞌculu dula. ");
INSERT INTO zplNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chequie uquiꞌyaꞌ benechiquiꞌ zeꞌe uriꞌi Jesuse nú uninu: ―¡Uzaca nu uchiuꞌu arquiꞌ niyu quieꞌ! Che utsiꞌqui benechiquiꞌ niyu zeꞌe lu yuu ante lu ye bee bene, nu chu uchiuꞌi arquiꞌ niyu zeꞌe nu né riꞌchiaꞌi niyu zeꞌe che. ");
INSERT INTO zplNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ye bee bene zeꞌe chiquiꞌ uyanu arquiꞌbeei nú unibeei lu saꞌbeei: ―¿Xi bedichiaꞌ neca bee nucuaꞌ? Chiquiꞌ reca benequieꞌ nu rnibiyaꞌlla nú chiuꞌu bee benechiquiꞌ. ¡Nu xiuꞌu beei! ");
INSERT INTO zplNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nu diqui bee luhuare enza zeꞌe uni bee bene lu cuendaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chequie chenu uchiuꞌu Jesuse liñi indu chu nzanu niꞌi Simón. Nu riti suegraꞌ Simón, nu chiquiꞌ nuꞌlla xlee, che uzequiee beella lu Jesuse para nú riꞌyecanu liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nu uya bica Jesuse elu nuxulla nu unibiyaꞌnu nú chiuꞌu xlee zeꞌe, nu chu uchiuꞌu xlee nú nuꞌlla. Hora zeꞌe uzetella, nu udeteꞌlla nú udacu beella. ");
INSERT INTO zplNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chenu uhuatseꞌ bichia, ye bee bene enu rluꞌcu bee bene enu riti lu ye bee clasiaꞌ bee elichia nú seca beei uyanu beella liꞌibeei lu Jesuse, nu uricuꞌnu yanu equie cada tucua beei, nu scua uriyecanu liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Leꞌca leta bee bene enu riti zeꞌe huaxi beei uchiuꞌu bee benechiquiꞌ arquiꞌbeei, nu urixialibeei nú unibeei: ―¡Liꞌilu necalu Lliꞌñi Diose! Pero uquiꞌyaꞌ bee benechiquiꞌ uriꞌi Jesuse nu lá zelanu nú anibeei, xne nediyaꞌbeei nú liꞌinu necanu Cristo. ");
INSERT INTO zplNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chenu uyeꞌe lu yuu, uchiuꞌu Jesuse eyeche zeꞌe nu nzanu tucu luhuare elu lecati nuꞌ. Pero ucuaꞌna bee bene liꞌinu, nu uriña beei elu nzucunu. Nu unibeei lunu nú la chanu, ");
INSERT INTO zplNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","pero uninu lubeei: ―Leꞌca rquiꞌña nú nzetixiuleꞌa lunú xa neca elurnibiyaꞌ Diose lubee bene stucu eyeche, xne enzeꞌe uxeꞌla Diose liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Scua unzee Jesuse udixiuleꞌenu Stichiaꞌ Diose liñi bee indu lubee bene lu iliu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tucu bese chenu nzu Jesuse ruꞌu inzatuꞌ Genesaret, uriña huaxi bee bene lunu xne niarquiꞌ beei nú yeneꞌ beei Stichiaꞌ Diose nu hasta nú utaꞌcu beei Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nu ulañiꞌ Jesuse chiucu barco ruꞌu inzatuꞌ zeꞌe. Nu nelata liñii xne bee bene enu rucu bela ulacala beei equiee xne rquie beei ixiu nú rucu beei bela. ");
INSERT INTO zplNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Che uyuꞌu Jesuse liñi tucu bee barco zeꞌe, neca tucu barco zeꞌe barcoꞌ Simón, nu unacuꞌnu lu Simón nú laca quieella barco zeꞌe lleꞌna enza lu inzatuꞌ zeꞌe. Nu uzucunu liñi barco zeꞌe nu uquiexienu seteꞌnu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Chenu ulaxu nú uninu lubee bene zeꞌe, uninu lu Simón: ―Uyaꞌ barco quieꞌ elu mase aquié lu inzatuꞌ quieꞌ, nu duꞌhua ixiu lu inza para nú ucuhua bee bela. ");
INSERT INTO zplNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nu ucuaqui Simón lu Jesuse: ―Maestro, diquillu rulaꞌ quieꞌ rucuꞌru bela nu niꞌ tucuí lá riꞌiru ana alluna, pero tunu rnilu nú duꞌuru ixiu nú rucuꞌru bela lu inza scua riꞌá che. ");
INSERT INTO zplNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Chenu uduꞌ beella ixiu nú rucu beella bela lu inza, uducu beella huaxi bee bela hasta nú uquixie nú saa ixiu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chequie uriꞌi beella seña lu saꞌ beella enu nucuaꞌa liñi stucu barco, para nú riꞌi bee nzeꞌe elietsa lubeella. Che uya beella nu urichee beella rucu barco zeꞌe bee bela hasta nú lleꞌnatsia achatseꞌ bee barco zeꞌe lu inza. ");
INSERT INTO zplNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Chenu ulañiꞌ Simón Pedro nú unga scua utsu lliquilla lu Jesuse nu unilla lunu: ―¡La yala nú tsua lulu Jesuse, xne necaa bene enu rluꞌcu dula! ");
INSERT INTO zplNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Unilla scua xne chiquiꞌ uyanu arquiꞌlla cuna beelá bee saꞌlla nú huaxi bee bela uducu beella. ");
INSERT INTO zplNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Leꞌca uyanu arquiꞌ Jacobo cuna Juan, enu neca bee llianaꞌ Zebedeo, nu neca beella mbañeruꞌ Simón. Pero uni Jesuse lu Simón: ―La lliquilu xne hasta nee quixiélu nú nilu lubee bene para nú aca beei bee benea luhuare nú ruculu bela. ");
INSERT INTO zplNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Che uhua beella barcoꞌ beella ruꞌu inzatuꞌ zeꞌe, nu utsaꞌna beella ye bee nucuaꞌ zeꞌe nu chu nzenu beella Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tucu bichia nzu Jesuse tucu eyeche, nu uriña tucu bene enu seca elichia nú lee lepra lunu, chenu ulañiꞌlla liꞌinu, utsu lliquilla lunu hasta nú utiꞌlla tequieella lu yuu, nu uziquieella lunu nú unilla: ―Detá, Jesuse tunu laca arquiꞌlu nuꞌ beyaꞌ nú riꞌiyecalu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Che uricuꞌ Jesuse yanu equie niyu zeꞌe, nu uninu: ―Niarquia nú yecaꞌlu. ¡Uyecaꞌ nee! Hora zeꞌe uyecaꞌ niyu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nu uni Jesuse lulla: ―La ixiuleꞌelu lu niꞌtucu bee bene nú xa uyecaꞌlu, lu uleꞌyatsia uquia tixiuleꞌe nú uyecaꞌlaꞌlu. Che deteꞌlu tucu uꞌna lu Diose tucu nú rnibiyaꞌ leyꞌ Moisés, para nú riꞌi ye bee bene beyaꞌ nú uyecaꞌlaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero cada bichia masela uriꞌchia bee bedichiaꞌ lunú rriꞌi Jesuse, nu rieteꞌ saꞌ huaxi bee bene para nú rieneꞌ beei lunú rninu cuna nú rriꞌiyecanu liꞌibeei lubee elichia nú seca beei. ");
INSERT INTO zplNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nu nza Jesuse bee luhuare elu lecalí ti nuꞌ para nú rnacuꞌnu lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tucu bichia chenu seteꞌ Jesuse bee bene, zeꞌe nucuaꞌa chiucu chuna bee fariseo cuna bee ulaxcuela enu reca leyꞌ Moisés nzeꞌta beella diqui lu iliu Galilea, cuna lu iliu Judea cuna lu eyeche Jerusalén. Ulubeꞌ Jesuse lubeella nú rlucuꞌnu poderꞌ Diose, nu rriyecanu bee bene enu riti. ");
INSERT INTO zplNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Che uriñayuu chiucu chuna bee bene tucu niyu enu neati beꞌlaꞌ nchiucuꞌ lu camilla, niarquiꞌ beei nú chuꞌunuu beei niyu quieꞌ liñi niꞌi hasta lu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero leca modo chuꞌnuu beei niyu quieꞌ liñi niꞌi zeꞌe xne nucuaꞌa huaxi bee bene zeꞌe. Che uquie beei equie niꞌi zeꞌe nu uxaꞌla beei equiee, nu ulaca beei niyu enu riti zeꞌe labe bee bene elu nzu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chenu ulañiꞌ Jesuse nú nzeli arquiꞌbeei liꞌinu, uninu lu bene enu riti zeꞌe: ―Llianaꞌa uriꞌá perdona stulalu nee. ");
INSERT INTO zplNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Che bee ulaxcuela enu reca leyꞌ Moisés cuna bee fariseo uquixie beella uriꞌi beella elliebacuꞌ nú uni beella: “¿Ti neca nucuaꞌ nú rni nucuaꞌ nú neca nucuaꞌ Diose? Xne tucutsia Diose reca rriꞌi perdona stula bee bene.” ");
INSERT INTO zplNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero uriꞌi Jesuse beyaꞌ lunú xa rriꞌi beella elliebacuꞌ nu uninu lubeella: ―¿Xinu rriꞌihua elliebacuꞌ scua? ");
INSERT INTO zplNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ta nú mase neriñaꞌ nú aca: “Nú nia lu niyu quieꞌ uriꞌá perdona stulalu”, urre nia lulla: “Uzetee nu utseꞌ”? ");
INSERT INTO zplNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pero nee lubea luhua nú liꞌá Bene enu uxeꞌla Diose rluꞌcua nú rnibiyaꞌa lu iliulabe para nú riꞌá perdona stula bee bene. Che uni Jesuse lu niyu enu riti zeꞌe: ―Nia lulu nú uzetee unaꞌtse camiyaꞌlu nu uquiaꞌa niꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hora zeꞌe utsuli niyu zeꞌe lu ye bee bene nu chu unaꞌtsella camilla nú uriculla lu, nu chu nzialla enza niꞌlla nu chiquiꞌ udeteꞌlla cheꞌtsa lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ye bee bene enu nucuaꞌa zeꞌe chiquiꞌ uyanu arquiꞌbeei nú unibeei bedichiaꞌ nzeꞌca lu Diose, nu chiquiꞌ ulliqui beei nú unibeei: ―Bichia quieꞌ ulañiaꞌahua tucu milagro nú lascaꞌ lañiaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lulá bee nucuaꞌ uchiuꞌu Jesuse eyeche zeꞌe, nu ulañiꞌnu tucu bene enu rriꞌi cubre bee impuesto leella Leví. Nzuculla elu rixiu bee bene bee impuesto. Nu uninu lulla: ―Utequie liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nu chu utsuli Leví, nu utsaꞌnalla ye bee steneꞌlla nu nzequieella Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chequie uriꞌi Leví tucu eliñi llene niꞌlla para Jesuse, nu nucuaꞌa huaxi bee bene enu rriꞌi cubre bee impuesto cuna huaxilá bee bene, enu nucuaꞌanu beella lu mexa. ");
INSERT INTO zplNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero bee fariseo cuna bee ulaxcuela enu reca leyꞌ Moisés, uquixie beella nú seꞌta beella bee beneꞌ Jesuse, nu uni beella: ―¿Xinu racunuhua nu rueꞌnuhua bee bene enu rriꞌi cubre bee impuesto cuna bee bene enu rluꞌcu dula? ");
INSERT INTO zplNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nu ucuaqui Jesuse lubeella: ―Bee bene enu la aca riti la quiꞌña bee nzeꞌe doctor, pero bee bene enu riti rquiꞌña bee nzeꞌe doctor. ");
INSERT INTO zplNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Lá yela lubee bene nzeꞌca, pero uriña lubee bene enu rluꞌcu dula, para nú cheꞌe arquiꞌbeei lu cuendaꞌ stula beei. ");
INSERT INTO zplNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Che uni beella lu Jesuse: ―Bee beneꞌ Juan Bautista cuna bee fariseo huaxi bese lá acu beella, equie nú rluꞌcu beella ulaꞌna lu Diose nu leꞌca chiquiꞌ rnacuꞌ beella lu Diose. ¿Xiquie nú racutsia bee beneꞌlu nu rueꞌtsia beella? ");
INSERT INTO zplNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nu ucuaqui Jesuse lubeella: ―¿Xieꞌ nuꞌ modo nú nihua lubee bene enu nezeneꞌ lu tucu tsaꞌa chia, nu la acu beei chenu nucuaꞌa beei cuna niyu enu xia la? ");
INSERT INTO zplNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero riña bichia chenu la nzuaꞌ bene enu xia zeꞌe cuna bee bene, che si deteꞌ beella bichia nú la acu beella, equie nú rluꞌcu beella ulaꞌna lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Leꞌca uninu lubeella: ―Lecati chiecuꞌ te pedazo laquie cuqui para nú quielaꞌlla lu tucu laquie uxu. Xne tunu riꞌi bee bene scua, riꞌi laquie cuqui nú mase tsaa laquie uxu, leꞌca la yaꞌna nzeꞌca laquie cuqui lu laquie uxu. ");
INSERT INTO zplNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Leꞌca la chuꞌu biñu cuqui liñi iti uxu, xne riꞌi biñu cuqui nú tsaa iti uxu, che nitilu biñu cuaꞌ cuna iti. ");
INSERT INTO zplNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Enzeꞌe rquiꞌña nú chuꞌu biñu cuqui liñi iti cuqui para nú la nitilu rucune. ");
INSERT INTO zplNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nu niꞌ tucu bene enu rueꞌ biñu uxu la yuꞌ arquiꞌ biñu cuqui, xne rnibeei: “Máse neca nzeꞌca biñu uxu.” ");
INSERT INTO zplNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tucu bichia nú sulachi bee bene Israel udetenu Jesuse bee beneꞌnu lu yuu elu nuꞌ trigo nu uquixie bee beneꞌnu unguxi beella túu lu trigo, nu uzuꞌcu beella ebichiꞌi liñi ya beella nu udacu beellae. ");
INSERT INTO zplNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chequie unidichiaꞌ chiucu chuna bee fariseo lubeella: ―¿Xinu rriꞌihua lunú la yala riꞌihua bichia nú sulachi bee bene? ");
INSERT INTO zplNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nu ucuaqui Jesuse: ―¿Xieꞌ lascaꞌ ulahua elu rni nú xa uriꞌi David cuna bee bene enu nuulla tucu bese chenu uliaꞌna beella la? ");
INSERT INTO zplNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Uyuꞌu David liñi induꞌ Diose nu udeteꞌ uleꞌya pá nú necaleꞌya yalla, nu udacullae nu leꞌca udeteꞌlla pá cuaꞌ udacu bee bene enu nuulla, añinzuca nú bee uleꞌyatsia nuꞌ modo acu bee pá cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Leꞌca uni Jesuse lubeella: ―Nu liꞌá Bene enu uxeꞌla Diose, leꞌca rluꞌcua nú rnibiyaꞌa lu bichia nú sulachi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Stucu bichia nú sulachi bee bene uyuꞌu Jesuse liñi tucu induꞌ bee bene Israel, nu uquixienu uzeteꞌnu bee bene. Zeꞌe nzucu tucu niyu enu ubichi cuꞌ ya chubee. ");
INSERT INTO zplNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chequie bee ulaxcuela enu reca leyꞌ Moisés cuna bee fariseo, nucuaꞌa tsiꞌña beella tunu riꞌiyeca Jesuse bene zeꞌe bichia nú sulachi beella, para nú scua luꞌcu beella xa ricuꞌ quiya beella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero liꞌinu nediyaꞌlaꞌnu xi elliebacuꞌ rriꞌi beella, che uninu lu bene enu ubichicuꞌ ya: ―Utsuli nu utsu labe quieꞌ. Nu chu utsuli bene cuaꞌ nu uya tsulla zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chequie uni Jesuse lubeella: ―Nidichiaꞌa tucu luhua: ¿Xi riala riꞌi bee bene bichia nú sulachi bee bene? ¿Nú neca nzeꞌca la urre nú necha neca la? ¿Tsilaꞌa bene nú la ati tucu bene la urre tsanaꞌ arquiꞌ bene nú ati tucu bene la? ");
INSERT INTO zplNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nú chu ubiꞌya Jesuse lu ye bee bene enu nucuaꞌa zeꞌe nu uninu lu niyu zeꞌe: ―Ulí yalu. Che uriꞌi niyu zeꞌe scua nu uyecaꞌ yaalla. ");
INSERT INTO zplNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero nuꞌ bee bene enu nucuaꞌa zeꞌe, chiquiꞌ ulee beei nu uquixie beei unibeei lu saꞌ beei nú xa riꞌi condra beei Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bee bichia zeꞌe uya Jesuse dañi nu unacuꞌnu lu Diose, nu diquillu rulaꞌ unacuꞌnu lu Diose zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Chenu uyeꞌe lu yuu ubixianu ye bee beneꞌnu nu ucañinu chiꞌchiucu beella, nu uhua leenu liꞌibeella apóstoles. ");
INSERT INTO zplNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bee benequieꞌ neca enu ucañinu: Simón enu leꞌca uhualeenu Pedro, Andrés bichi Simón, Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO zplNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo llianaꞌ bene enu lee Alfeo; Simón enu ullutse leta tucu partido nu lee cananista; ");
INSERT INTO zplNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas bichi Jacobo; nu cuna Judas Iscariote, enu udeteꞌ cuenda Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chequie ulaca Jesuse dañi zeꞌe cuna bee apóstolꞌnu nu ucuaꞌaxe beella lu tucu lichi cuna huaxi bee bene enu nzequie liꞌinu; cuna huaxilá bee bene enu nzeꞌta diqui bee luhuare lu iliu Judea, cuna bee bene Jerusalén cuna bee bene enu nzeꞌta ruꞌu inzatuꞌ eyeche Tiro cuna Sidón. Ubeꞌta bee benequieꞌ para nú ubeneꞌ beei lunú rni Jesuse cuna nú uriꞌiyecanu liꞌibeei lubee elichia nú seca beei. ");
INSERT INTO zplNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Leꞌca uriꞌiyecanu bee bene enu nchiñi bee benechiquiꞌ arquiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ye bee bene zeꞌe niarquiꞌ beei tiꞌya beei Jesuse, xne rriꞌiyecanu ye beei cuna poder nú rluꞌcunu. ");
INSERT INTO zplNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Che ubiꞌya Jesuse lubee beneꞌnu nu uninu lubeella: ―Ñia nza lu cuendaꞌhua liꞌihua enu neca bene elitsi, xne rialahua elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ñia nza lu cuendaꞌhua liꞌihua enu rliaꞌnaꞌ nee, xne riña bichia nú aca neelaꞌhua, nu ñia nza lu cuendaꞌhua liꞌihua enu runaꞌ nee, xne riña bichia nú llilaꞌ arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ñia nza lu cuendaꞌhua chenu rana arquiꞌ bee bene liꞌihua, cuna chenu rtiliacaꞌ bee bene liꞌihua cuna chenu rquiexuu bee bene liꞌihua, cuna chenu rluachú bee bene liꞌihua xi neca beenú lecaxi zibiꞌ equie nú nzeli arquiꞌhua liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Chiquiꞌ ñia utsu arquiꞌhua chenu rriꞌinu bee bene liꞌihua scua, xne liꞌihua luꞌcuhua tucu premio nú llene neca liñibe, xne leꞌca scua uriꞌinú bee beneꞌ bee benecuaꞌ bee profetaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Pero cueꞌhua bee bene xene, xne uluꞌculahua nú ñia utsu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Cueꞌhua bee bene enu neelaꞌ nee, xne enta nú liaꞌnaꞌhua. Cueꞌhua bee enu xiꞌchi nee, xne enta nú unaꞌhua nu nehuana tsu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Nu cueꞌhua bee bene enu riuꞌ arquiꞌ nú sucuꞌ aya bee bene liꞌihua, xne leꞌca scua uzucuꞌ aya bee beneꞌahua huaꞌtu bee profeta enu né ni tucu nú neli neca. ");
INSERT INTO zplNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Pero liꞌihua enu rieneꞌ lunú rnia, nia luhua: Uzecahua bee bene enu rlee luhua, nu uriꞌi nzeꞌcahua lubee bene enu rana arquiꞌ liꞌihua, ");
INSERT INTO zplNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","uniꞌhua nú cha nzeꞌca lu cuendaꞌ bee bene enu riꞌña nú zecahua, nu unaꞌcuhua lu Diose equie cuendaꞌ bee bene enu rquiexuu liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tunu nuꞌ enu duꞌ tucue lulu, udeꞌteꞌ stucu chú lulu duꞌlla stucue, nu tunu nuꞌ enu raxi chamarraꞌlu leꞌca utsanaꞌ nú uyaꞌlla cuna lliacaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Titse enu rnacuꞌ xi rnacuꞌ lulu udeꞌteꞌ nucuaꞌ lulla, nu enu raxi steneꞌlu la nacuꞌ quiyalue. ");
INSERT INTO zplNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Uriꞌihua lubee bene tucu nú niarquiꞌhua nú riꞌi beei luhua. ");
INSERT INTO zplNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tunu secatsiahua bee bene enu seca liꞌihua, lecaxi sibiꞌ nucuaꞌ, xne hasta bee bene enu necha neca rriꞌi scua. ");
INSERT INTO zplNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nu tunu rriꞌi nzeꞌcatsiahua lubee bene enu rriꞌi nzeꞌca luhua, lecaxi sibiꞌ nucuaꞌ xne hasta bee bene enu necha neca rriꞌi scua. ");
INSERT INTO zplNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tunu sanaꞌtsiahua dimi lubee bene enu nzu arquiꞌhua nú ixiuca dimiꞌhua lecaxi zibiꞌ nucuaꞌ. Xne hasta bee bene enu necha neca sanaꞌ beei dimi lubee bene enu nzu arquiꞌbeei nú ixiuca dimiꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero liꞌihua rquiꞌña nú zecahua bee bene enu rlee luhua, nu riꞌi nzeꞌcahua lubeei. Tsanaꞌhua nú rnacuꞌ beei nu la tsuquiehua nú liquiꞌ beei xi liquiꞌ beei luhua equie bee nucuaꞌ. Scua máse huaxi eluxene nú atiꞌhua liñibe nu leꞌca scua acahua lliꞌñi Diose liñibe, xne liꞌinu leꞌca rriꞌi nzeꞌcanu lubee bene enu niꞌ lleꞌna la deteꞌ cheꞌtsa lunu, cuna lubee bene enu necha neca. ");
INSERT INTO zplNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Uhuaꞌa arquiꞌhua bee bene tucu nú ruaꞌa arquiꞌ Diose Pa liñibe liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’La zeꞌtahua nu la taꞌquiyahua bee bene eluquichiaꞌ para nú la riꞌinu bee bene liꞌihua scua. Uriꞌihua perdona bee bene para nú leꞌca riꞌi Diose perdona liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Udeꞌteꞌhua lubee bene lunú secalaꞌchaꞌ beei, nu Diose liquiꞌnu luhua lunú secalaꞌchaꞌhua. Liꞌinu másela liquiꞌnu luhua lunú deteꞌhua. Xne liꞌinu liquiꞌnu luhua tucu nú deteꞌhua lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Leꞌca uni Jesuse lubeella: ―Liꞌihua nediyaꞌhua nú tucu bene enu niquieꞌlu leca modo nú chenala stucu bene enu leꞌca niquieꞌlu, xne rucu beella nuꞌ modo nú zanaꞌ beella tucu ichiu. ");
INSERT INTO zplNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Niꞌ tucu enu seteꞌ la acalla másela tucu nú reca ulaxcuelaꞌlla, tunu riquiꞌlla laꞌxulla lunú seteꞌlla, che acalla tucu nú reca ulaxcuelaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’La zeꞌtalu bee bene bee falta nú lleꞌnatsia nú rriꞌi beei, mejora uyanutsia arquiꞌ bee falta llene nú rriꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nu tunu llenelá neca bee falta nú rriꞌilu, ¿xa modo nilu lu bene nú la neca nzeꞌca nú rriꞌibeei? ¡Bene enu niquichiaꞌ! Rluti uriꞌi lunú riala nú riꞌilu, che nuꞌ modo nilu lu bene nú la neca nzeꞌca nú rriꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Leca aca nzeꞌca nú ayu ndixi nú la zibiꞌ lu, leꞌca leca aca nú la zibiꞌ nú ayu ndixi nzeꞌca lu. ");
INSERT INTO zplNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Cada aca nuꞌlu bee bene ndixi nú rayu lue. La ayu higo lu aca eche, leꞌca la ayu uva lubee huañi dañi. ");
INSERT INTO zplNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bene nzeꞌca rni bee bedichiaꞌ nzeꞌca, xne nucuaꞌ neca nú nuꞌ arquiꞌlla, nu bene enu necha neca rnilla bee bedichiaꞌ nú necha neca. Xne nucuaꞌ neca nú nuꞌ arquiꞌlla. Xne hasta liñi arquiꞌ bene xiuꞌu nú rnilla. ");
INSERT INTO zplNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Xinu rnihua lua, “Detá, Detá” nu la riꞌihua tucu nú rnia? ");
INSERT INTO zplNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nia luhua xa neca bene enu nzeꞌta lua, nú rieneꞌlla lunú rnia, nu sucuꞌlla stichiaꞌa: ");
INSERT INTO zplNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Liꞌilla necalla xi neca tucu bene enu urecheꞌe tucu niꞌi. Rluti udaꞌñilla aquié lu yuu hasta nú uriñalla elu nuꞌ quiee, che uquixiella uricuꞌlla simiendu lu quiee zeꞌe. Chenu ulaca huaxi inza mase uyuꞌe tsuꞌ niꞌi zeꞌe, pero niꞌ temeꞌ lá cuñi niꞌi zeꞌe, xne nchiucuꞌ simienduꞌe lu quiee. ");
INSERT INTO zplNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero bene enu rieneꞌ lunú rnia nu la zucuꞌlla stichiaꞌa, liꞌilla necalla xi neca tucu bene enu rrecheꞌ tucu niꞌi nu la recheꞌlla simienduꞌe. Chequie chenu ulaca huaxi inza nu uyuꞌe tsuꞌ niꞌi zeꞌe, hora zeꞌe uluquiee nu lecaꞌ modo nú acacheꞌ zecae. ");
INSERT INTO zplNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chenu ulaxu nú uni Jesuse lubee bene, chú nzanu eyeche Capernaum. ");
INSERT INTO zplNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Zeꞌe uhuañi tucu capitán romano, nu uluꞌculla tucu mosoꞌlla enu chiquiꞌ secalla, nu riti mosoꞌ quieꞌ, nu stemeꞌtsia rriꞌi nú atii. ");
INSERT INTO zplNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chenu ubeneꞌ capitán zeꞌe lu cuendaꞌ Jesuse, uxeꞌlalla chiucu chuna bene uxu enu neca equie lubee bene Israel, para nú chábeella nu ziquiee beella lu Jesuse nú chanu riꞌiyecanu mosoꞌ capitán zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Uya bee benequieꞌ elu nzu Jesuse nu chiquiꞌ uziquiee beella lunu nú uni beella lunu: ―Riala nú riꞌilu elietsa lu Capitán quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Xne secalla bee bene Israel, nu leꞌca uriꞌilla elietsa nú ungacheꞌ induaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chequie nza Jesuse cuna liꞌibeella, pero chenu nze riña beella axu niꞌi capitán zeꞌe, uxeꞌlalla chiucu chuna bene enu rquieteꞌlla para nú ni beella lu Jesuse: ―Detá, Jesuse mase la riñalu hasta ruꞌu nia xne la neca equiea para nú chuꞌulu nia. ");
INSERT INTO zplNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Enzeꞌe lá niarquia nú achelaꞌna liꞌilu, pero unibiyaꞌtsia hasta elu nzulu para nú yecaꞌ mosoa. ");
INSERT INTO zplNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Xne leꞌca sucua stichiaꞌ bee bene enu rnibiyaꞌ lua, nu leꞌca sucuꞌ bee sondadua stichiaꞌa. Chenu nia lu tucui nú chai chu nzai, nu chenu nia lu stucui nú yeꞌtai chu nzetai, nu chenu nia lu mosoa nú xi riꞌilla chu rriꞌilla lunú nia lulla. ");
INSERT INTO zplNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chenu ubeneꞌ Jesuse nucuaꞌ, chiquiꞌ uyanu arquiꞌnu stichiaꞌ capitán zeꞌe, nu ubiꞌyanu lubee bene enu nzequie liꞌinu nu uninu lubeei: ―Nia luhua nú niꞌ eyeche Israel lascaꞌ llelá tucu bene enu nzeli arquiꞌ tucu nú nzeli arquiꞌ benequieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chequie chenu ubenchilaꞌ bee bene enu uxeꞌla capitán zeꞌe niꞌilla, ulañiꞌ beella nú uyecaꞌlaꞌ mosoꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Cheela chu nza Jesuse cuna bee beneꞌnu cuna huaxilá bee bene tucu eyeche nú lee Naín. ");
INSERT INTO zplNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chenu uriñanu axu ruꞌu eyeche zeꞌe, ulañiꞌnu nú nze cachiꞌ bee bene tucu bene nguti. Neca bene nguti quieꞌ llianaꞌ tucu unaꞌa enu unguti niyuꞌ, nu tucu liꞌitsialla necalla llianaꞌ unaꞌa zeꞌe. Nu huaxi bee bene eyeche zeꞌe nzenulla nze cachiꞌ beella llianaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chenu ulañiꞌ Jesuse unaꞌa cuaꞌ, uhuaꞌa arquiꞌnu liꞌilla nu uninu lulla: ―La unaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chequie uyabica Jesuse, nu utiꞌnu yanu tsuꞌ camiyaꞌ bene nguti zeꞌe nu chu ucuaꞌaxe bee bene enu nuyaꞌ liꞌilla. Nu uni Jesuse lu bene nguti zeꞌe: ―Niyu eꞌneꞌ, liꞌá nia lulu: ¡Uzetee! ");
INSERT INTO zplNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nu chu uzuculí bene nguti zeꞌe nu uquixiei nú rdichiaꞌi. Nu chu udeteꞌ cuenda Jesuse liꞌi lu naꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Chenu ulañiꞌ bee bene zeꞌe nucuaꞌ, ye beei ulliqui beei nu uquixie beei unibeei bedichiaꞌ nzeꞌca lu Diose, nú unibeei: ―Tucu profeta enu chiquiꞌ reca uriña luaꞌahua. Leꞌca unibeei: ―Uriñala Diose para nú riꞌinu elietsa lubee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Diqui lu iliu Judea, cuna ye bee eyeche enza zeꞌe ungabiyaꞌ bee bene lunú uriꞌi Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ungabiyaꞌ Juan ye beenú unga scua, xne udixiuleꞌe bee bene enu nzequie liꞌilla nucuaꞌ lulla. Chequie ubixia Juan chiucu bee beneꞌlla, ");
INSERT INTO zplNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nu uxeꞌlalla liꞌibeei nú nedichiaꞌ beei lu Jesuse tunu liꞌinu necanu Cristo enu nzu nú nzeꞌta, urre rquiꞌña nú nzuquiee beella stucu enu rene. ");
INSERT INTO zplNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Chequie bee bene enu uxeꞌla Juan uya beei elu nzu Jesuse nu unibeei lunu: ―Uxeꞌla Juan Bautista liꞌiru para nú nidichiaꞌru lulu tunu liꞌilu necalu Cristo enu nzu nú nzeꞌta, urre nelluaꞌaquieeru stucu enu rene. ");
INSERT INTO zplNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hora zeꞌe uriꞌiyeca Jesuse huaxi bee bene enu riti, nu uhuanu benechiquiꞌ arquiꞌ bee bene, leꞌca uriꞌiyecanu iꞌculu huaxi bee bene enu niquieꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Che uni Jesuse lubeei: ―Uquiahua nu udixiuleꞌehua lu Juan lunú ulañiꞌhua cuna lunú ubeneꞌhua. Uniꞌhua lulla nú riꞌyala bee bene enu niquieꞌlu, nu seela bee bene enu necuxu, nu leꞌca uyecaꞌlaꞌ bee bene enu seca elichia nú lee lepra, nu rieneꞌla bee bene enu nenguataꞌ, nu bee bene nguti uhuañi zeca, nu bee bene elitsi rieneꞌlaꞌ beei bedichiaꞌ nzeꞌcaꞌ Diose para nú tsilaꞌa beei. ");
INSERT INTO zplNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Nu ñia nza lu cuendaꞌ bee bene enu la tsanaꞌ arquiꞌ nú nzeli arquiꞌ liꞌá! ");
INSERT INTO zplNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chenu nzia bee bene enu uxeꞌla Juan, chu uquixie Jesuse nú uninu lubee bene equie cuendaꞌ Juan, nu uninu lubeei: ―¿Ti rriꞌihua beyaꞌ nú neca bene enu uyabiꞌyahua lu dañi achi elu la nucuaꞌa bee bene? ¿Nzelí arquiꞌhua nú necalla xi neca tucu etaa nú rcuñi bi la? ");
INSERT INTO zplNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Urre, ¿xa rnaa bene enu uyabiꞌyahua? ¿Necalla tucu bene enu nutu laquie fiñu la? Nediyaꞌhua nú bee bene enu rutu laquie fiñu nehuañi nzeꞌca beella nu liñi bee niꞌi nzeꞌca nucuaꞌa beella. ");
INSERT INTO zplNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Enzeꞌe, ¿Ti uyabiꞌyahua che? ¿Tucu profeta la? Pero nia luhua, nú liꞌihua uyabiꞌyahua tucu bene enu másela neca equie lunú neca tucu profeta. ");
INSERT INTO zplNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan Bautista quieꞌ neca enu rni lu ichiꞌ Stichiaꞌ Diose elu rni: Xeꞌla tucu bene enu cha rluti lulu, para nú tsúcheꞌlla inziu nú riñalu. ");
INSERT INTO zplNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nia luhua nú lu ye bee bene iliulabe, lá chiuꞌu niꞌ tucu bene enu máse neca equie tucu nú neca equie Juan Bautista, pero añinzuca nú necane scua, bene enu lleꞌnatsia neca equie elurnibiyaꞌ Diose, liꞌilla másela neca equiella luquela Juan. ");
INSERT INTO zplNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ye bee bene cuna bee enu rriꞌi cubre equie bee impuesto chenu ubeneꞌbeei lunú uni Juan, urinzalla liꞌibeei, xne uriꞌibeei beyaꞌ nú rriꞌi Diose tucu nú rialane, ");
INSERT INTO zplNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","pero bee fariseo cuna bee ulaxcuela enu reca leyꞌ Moises, né zela beella nú arinza Juan liꞌibeella, nu scua uhuachu beei lunú niarquiꞌ Diose riꞌinu liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Che unilá Jesuse lubeei: ―¿Xa nia luhua nú xa neca bee bene enu nehuañi lu iliulabe quieꞌ nee? ¿Ti neca tucu nú neca beei? ");
INSERT INTO zplNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nia luhua: Nú liꞌibeei neca beei xi neca bee enduꞌ enu rita ruꞌu iꞌya nu rixiali beei lu saꞌbeei nú rnibeei: “Chenu ungularu chii para nú yeꞌehua né yeꞌehua. Nu chenu ungularu canción nú nehuana se né unaꞌhua.” ");
INSERT INTO zplNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Scua necahua, xne ubeꞌta Juan Bautista nu liꞌilla la aculla pá, nú la huaꞌlla biñu, nu rnihua nú nchiñi benechiquiꞌ arquiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nee quie uriña liꞌá Bene enu uxeꞌla Diose, nú racua pá nu rueꞌa biñu, nu rnihua nú racu xetaꞌa nu riuꞌ arquia ruaꞌa biñu nu rquietea bee bene enu rriꞌi dula cuna bee bene enu rriꞌi cubre equie bee impuesto. ");
INSERT INTO zplNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ye bee enu rriꞌi beyaꞌ, liꞌibeella nediyaꞌ beella nú neca nzeꞌca lunú rriꞌi Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tucu bee fariseo uzeneꞌ Jesuse nú chanu para nú acununu liꞌilla niꞌlla, che uya Jesuse niꞌlla nu uzucunu lu mexa, ");
INSERT INTO zplNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","chequie tucu unaꞌa huexe enu nzucu eyeche zeꞌe, chenu ubeneꞌnchu nú nze tacuxe Jesuse niꞌi fariseo zeꞌe, che unguyaꞌnchu tucu frasco perfume nú chiquiꞌ huaxi seca. ");
INSERT INTO zplNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nu runaꞌnchu uzucunchu lu Jesuse, nu uquienchu cuchiuꞌnu cuna inza nú runaꞌnchu. Nu ucuiꞌchinchu cuchiuꞌnu cuna ichia equienchu, nu chu utsuluruꞌnchu cuchiuꞌnu nu uduꞌnchu perfumee. ");
INSERT INTO zplNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chenu ulañiꞌ fariseo zeꞌe nucuaꞌ, uriꞌi elliebacuꞌ: “Tunu neli nú neca benequieꞌ tucu profeta, riꞌilla beyaꞌ ti neca unaꞌa enu rtiꞌya liꞌilla nu xa nehuañinchu, xne necanchu tucu unaꞌa enu rriꞌi dula.” ");
INSERT INTO zplNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Che uni Jesuse lu fariseo zeꞌe: ―Simón, nia tucu nú nia lulu. Nu ucuaqui fariseo zeꞌe: ―Uniꞌi Maestro. ");
INSERT INTO zplNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nu uni Jesuse lulla: ―Tucu bene utsanaꞌ dimi lu chiucu bene, tucu lu nzeꞌe utsanaꞌlla quiniento denario, nu lu stuculla utsanaꞌlla cincuenta denario. ");
INSERT INTO zplNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero rucu bee benequieꞌ né riꞌi beei ana aixiu beei dimi cuaꞌ lulla, che unilla lubeei nú la ixiuaꞌ beei dimi cuaꞌ lulla. Neequie uniꞌi, ¿Ta lu rucu bee benecuaꞌ máse seca liꞌilla? ");
INSERT INTO zplNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nu ucuaqui Simón: ―Pianu bene enu huaxilá neziꞌqui lulla. Nu uni Jesuse lulla: ―Scua necane. ");
INSERT INTO zplNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Che ubiꞌya Jesuse lu unaꞌa zeꞌe, nu uninu lu Simón: ―Biꞌyacuru unaꞌa quieꞌ chenu uriña niꞌilu né liquiꞌlu inza para nú quia cuchiuꞌa, pero unaꞌa quieꞌ uquie cuchiuꞌa cuna inza nú ungunaꞌnchu nu ucuiꞌchinchue cuna ichia equienchu. ");
INSERT INTO zplNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Né tsuluruꞌulu liꞌá, pero liꞌinchu desde nú uyuꞌa caꞌa la tsuxenchu nú suluruꞌunchu cuchiuꞌa. ");
INSERT INTO zplNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Né duꞌlu perfume equiea, pero liꞌinchu uduꞌnchu perfume cuchiuꞌa. ");
INSERT INTO zplNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Enzeꞌe nia lulu, equie nú chiquiꞌ seca unaꞌa quieꞌ liꞌá, neca perdonala ye stulanchu. Pero bene enu siꞌ nú la luꞌcu huaxi dula, bene zeꞌe lleꞌnatsia secalla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nu chu uninu lu unaꞌa zeꞌe: ―Uriꞌilá perdona bee stulalu nee. ");
INSERT INTO zplNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Chequie bee bene enu nucuaꞌa cuna liꞌinu zeꞌe, uquixie beei nú unidichiaꞌ beei lu saꞌbeei: ―¿Ti neca benequieꞌ, nú hasta bee dula rriꞌilla perdona? ");
INSERT INTO zplNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero uni Jesuse lu unaꞌa zeꞌe: ―Neca perdona bee stulalu, xne uchili arquiꞌlu liꞌá, uquia nzeꞌca nee. ");
INSERT INTO zplNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lulá bee nucuaꞌ, uya Jesuse lu huaxi bee eyeche llene cuna lubee eyeche llaꞌna, uzeteꞌnu nu udixiuleꞌenu xa neca lunú rnibiyaꞌ Diose. Nu uyanunu ye chiꞌchiucu bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Leꞌca chiucu chuna bee unaꞌa enu uhuanu bee benechiquiꞌ arquiꞌ cuna bee enu uriꞌiyecanu bee elichia nú seca beenchu, uyabeenchu cuna liꞌinu. Leta bee unaꞌa cuaꞌ nchiñi María enu leꞌca lee Magdalena, liꞌinchu necanchu enu uhuanu achi benechiquiꞌ arquiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Leꞌca uya Juana, unaꞌa bene enu lee Chuza, nu Chuza quieꞌ unga enu uriꞌiucu steneꞌ arre Herodes, leꞌca uya Susana cuna huaxilá bee unaꞌa enu uriꞌi elietsa lunu cuna xitse lunú rluꞌcu beenchu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Huaxi bee bene uchiuꞌu bee eyeche nu uyabiꞌya beei Jesuse. Nu chenu uyetesaꞌ huaxi bee bene lunu, che uninu tucu ejemplu lubeella: ");
INSERT INTO zplNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Tucu bichia uchiuꞌu tucu niyu nze tuꞌ nii lu yuꞌlla. Chenu rduꞌlla nii lu yuꞌlla, uzanaꞌ lleꞌna ebichi inziu nu utaꞌ bee bene equiee, nu chu udacu bee iñii. ");
INSERT INTO zplNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Lleꞌna ebichi uzanaꞌ leta quiee, chenu uliñi bee ebichi zeꞌe ubichi bee xne la nuꞌ ucu luyuu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Lleꞌna ebichi zeꞌe uzanaꞌ leta bee eche, nu equie nú tucutse uliñi bee uriꞌi bee huañi eche ana lu ebichi zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Lleꞌna ebichi uzanaꞌ lu yuu nzeꞌca, chenu uruꞌcu ebichi quieꞌ, chiquiꞌ unguyuꞌe, hasta tucu ayuꞌu ebichi unguyuꞌ lu cada tucuae. Chenu uni Jesuse scua, che chiquiꞌ juerte uninu lubeei: ―¡Tatse bene enu niarquiꞌ nú yeneꞌ lunú rnia, quieꞌ diaca nzeꞌe! ");
INSERT INTO zplNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Chequie unidichiaꞌ bee beneꞌ Jesuse lunu, xi rni ejemplu nú uninu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nu uninu lubeella: ―Diose uliquiꞌla nú rriꞌihua beyaꞌ nú aꞌchi neca lunú rnibiyaꞌnu. Pero lu beela bee bene puro tsia bee ejemplu rnia lubeei, xne mase riꞌya beei, pero neca xi neca nú la lañiꞌ beei, nu mase rieneꞌ beei pero la riꞌi beei beyaꞌ nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ninguieꞌ neca nú rni ejemplu cuaꞌ: Ebichi zeꞌe neca xi neca Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nu ebichi nú uzanaꞌ inziu neca xi neca bee bene enu rieneꞌ Stichiaꞌ Diose, pero chu nzeꞌta taxi bezeꞌlu Stichiaꞌ Diose arquiꞌbeei para nú la chili arquiꞌbeei Stichiaꞌ Diose, nu la tsilaꞌa beei. ");
INSERT INTO zplNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ebichi nú uzanaꞌ leta bee quiee neca xi neca bee bene enu rieneꞌ Stichiaꞌ Diose cuna nú ñia riucu arquiꞌbeeii, pero la tsutaꞌ arquiꞌbeei lue. Nzelí arquiꞌbeei Stichiaꞌ Diose lleꞌna tiembu, pero chenu xitse rriꞌchia bee bene liꞌibeei rtuꞌ beei nu chu sanaꞌ arquiꞌ beei Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ebichi nú uzanaꞌ leta huañi eche neca xi neca bee bene enu rieneꞌ Stichiaꞌ Diose, pero lleꞌnaa lleꞌnaa sanaꞌ arquiꞌbeei stichiaꞌnu, xne máse nzenu arquiꞌbeei bee eluxene cuna beenú nuꞌ lu iliulabe, scua la riꞌi beei tucu nú niarquiꞌ Diose nú riꞌi beei. ");
INSERT INTO zplNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero ebichi nú uzanaꞌ lu yuu nzeꞌca neca xi neca bee bene enu rieneꞌ Stichiaꞌ Diose, nu nzequiee beella tucu nú rialane nu nzutaꞌ arquiꞌbeella lue, nu equie nú nzutaꞌ arquiꞌ beella scua, rriꞌi beella tucu nú niarquiꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Lecati quieꞌe quii tucu quinqué nu tsacuꞌlla equiee urre tsullae liñi luna, rquiꞌña nú quie quii nu zucune elu aya para nú duꞌllieꞌe lu ye bee bene enu chuꞌu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Leꞌca scua, niꞌ tucu beenú aꞌchi neca la yaꞌna nucuaꞌ scuatsia, riña nú acachee ye bee nucuaꞌ, nu niꞌ tucu beenú neca aꞌchiꞌ la yaꞌna nucuaꞌ scuatsia riña nú acabiyaꞌ ye bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Enzeꞌe uquieꞌe diacahua, xne bee bene enu nzeli arquiꞌ Diose tucu nú rialane, cada bichia máse nzutaꞌ arquiꞌbeei lu stichiaꞌnu, pero bee bene enu la chili arquiꞌ Stichiaꞌ Diose tucu nú rialane, riña bichia nú la chiliaꞌ arquiꞌbeei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Chenu uya naꞌ Jesuse cuna bee bichinu elu nzunu, nu né aca ariña beella hasta elu nzunu, xne nucuaꞌa huaxi bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Che uya tucu bene enu udixiuleꞌe lu Jesuse, nu unilla lunu: ―Naꞌlu cuna bee bichilu nucuaꞌa beella eliꞌyaꞌ, nú niarquiꞌ beella nú ni beella lulu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Che uni Jesuse lubee bene zeꞌe: ―Bee bene enu sucuꞌ Stichiaꞌ Diose nu rriꞌi tucu nú riuꞌ arquiꞌnu, liꞌibeella neca beella xi neca naa cuna bee bichia. ");
INSERT INTO zplNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tucu bichia uyuꞌu Jesuse cuna bee beneꞌnu liñi barco, nu uninu lubeella: ―Chahua stucu chú inzatuꞌ quieꞌ. Nu chu nzuebeella. ");
INSERT INTO zplNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Diqui nú nze dete beella lu inzatuꞌ, udaꞌtse Jesuse, nu uquixie tucu bii juerte lu inzatuꞌ zeꞌe. Che uquixie nú uyuꞌu inza liñi barcoꞌ beella hasta nú nze chatseꞌla barcoꞌ beella lu inzatuꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chequie uya cuaꞌñi beella Jesuse, nu unibeella lunu: ―¡Maestro! ¡Maestro! ¡Nze chatseꞌahua lu inza quieꞌ! Che chu uzetee Jesuse, nu unibiyaꞌnu lu bii cuna lu inzatuꞌ nú aca xeene, nu chu ungaxe ye bee nucuaꞌ, nu unga chii. ");
INSERT INTO zplNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chequie uni Jesuse lubee beneꞌnu: ―¿Cá nza nú nzeli arquiꞌhua liꞌá? Pero liꞌibeella chiquiꞌ ulliqui beella, nu uyanu arquiꞌbeella nu uquixie beella unidichiaꞌ beella lu saꞌbeella: ―¿Ti neca benecuaꞌ nú rnibiyaꞌlla lu bii cuna lu inzatuꞌ nu sucuꞌ bee nucuaꞌ stichiaꞌlla? ");
INSERT INTO zplNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Che uriña beella stucu chú inzatuꞌ Galilea, lu iliu Gadara. ");
INSERT INTO zplNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Chenu uchiuꞌu Jesuse liñi barco uyabica tucu bene Gadara lunu. Necala huaxi tiembu nú nchiñi benechiquiꞌ arquiꞌ benecuaꞌ, la utuaꞌi xucui nu la zucuaꞌi niꞌi, enzetsiai leta bee eluhuaꞌ bee bene nguti. ");
INSERT INTO zplNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Chenu ulañiꞌi Jesuse, utsu lliquii lunu nu urixialii nú uni: ―¿Xinu riꞌchialu liꞌá Jesuse Lliꞌñi Diose liñibe? Zequiaa lulu nú la riꞌilu nú nehuana zecaa. ");
INSERT INTO zplNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Uni benecuaꞌ scua xne rnibiyaꞌla Jesuse lu benechiquiꞌ nú chiuꞌi arquiꞌ bene zeꞌe. Huaxi bese unaꞌtse benechiquiꞌ zeꞌe liꞌi, nu ullicaꞌcuu bee bene cadena yai cuna cuchiuꞌi para nú la chai niꞌ tucu bee luhuare, pero uchiecuꞌi cadena zeꞌe, nu rlua benechiquiꞌ zeꞌe liꞌi bee luhuare elu la nucuaꞌa bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Che unidichiaꞌ Jesuse lu niyu zeꞌe: ―¿Ti leelu? Nu ucuaquii: ―Legión lea. Uni scua xne huaxi bee benechiquiꞌ neca enu nchiñi arquiꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nu uziquiee bee benechiquiꞌ zeꞌe lu Jesuse, nú la xeꞌlanu liꞌibeei ebila. ");
INSERT INTO zplNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nu lunú nucuaꞌa huaxi bee cuchi liñi dañi zeꞌe racu, che unacuꞌ bee benechiquiꞌ zeꞌe lu Jesuse nú chuꞌu beeii arquiꞌ bee cuchi zeꞌe, nu uzelanu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chequie uchiuꞌu bee benechiquiꞌ arquiꞌ bene zeꞌe nu uyuꞌu beei arquiꞌ bee cuchi, nu uyecaxuꞌu beeí nu utsundiqui beeí ruꞌu quieelaa nu uzanaꞌ beeí hasta lu inzatuꞌ nu uniꞌchi chii beeí lu inza zeꞌe, nu unguti beeí. ");
INSERT INTO zplNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bee bene enu rriꞌiucu bee cuchi zeꞌe chenu ulañiꞌ beei lunú unga scua, uyecaxuꞌu beei nú nzetixiuleꞌe beei lubee bene eyeche zeꞌe cuna lubee bene enu nucuaꞌa dañi. ");
INSERT INTO zplNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Che uchiuꞌu bee bene zeꞌe nu uyabiꞌya beei lunú unga zeꞌe. Chenu uriña beei elu nzu Jesuse, ulañiꞌ beei bene enu uchiuꞌu bee benechiquiꞌ arquiꞌ nú nzucui tucu chú lu Jesuse, nu nutulai xucui nu uyecaꞌlaꞌi lunú ulleꞌcai, che chiquiꞌ ulliqui bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nu bee bene enu ulañiꞌ lunú unga zeꞌe, udixiuleꞌe beei lunú xa uyecaꞌ niyu enu ullutse bee benechiquiꞌ arquiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Enzeꞌe, ye bee bene lu iliu Gadara uquixie beei nú uziquie beei lu Jesuse para nú chiuꞌunu zeꞌe, xne chiquiꞌ xiqui beei. Che uyuꞌu Jesuse liñi barco nu chu nzanu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ante nú chanu bene enu uchiuꞌu bee benechiquiꞌ zeꞌe arquiꞌ, uzequiei lu Jesuse nú chenui liꞌinu, pero uni Jesuse nú yaꞌnai, nu uninu lui: ");
INSERT INTO zplNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ubenchilaꞌ niꞌilu, nu uquiatixiuleꞌe luye nú uriꞌi Diose lulu. Che chu nzai nu udixiuleꞌi lu ye bee bene eyeche zeꞌe lunú uriꞌiyeca Jesuse liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Chenu ubenchilaꞌ zeca Jesuse stucu chú inzatuꞌ, chiquiꞌ ñia nzu arquiꞌ bee bene uya chaꞌcalu beei liꞌinu, xne ye beei nucuaꞌa quie beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chequie uriña tucu bene enu lee Jairo lu Jesuse, neca Jairo quieꞌ enu rnibiyaꞌ liñi induꞌ bee bene Israel. Nu utsu lliquilla lu Jesuse nu uziquieella lunu para nú chanu niꞌlla, ");
INSERT INTO zplNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","xne rluꞌculla tucutsia enduꞌlla, nu nzanchu chiꞌchiucu lana, nu stemeꞌtsia rriꞌi nú atinchu. Chenu nza Jesuse enza niꞌ Jairo nzequie huaxi bee bene liꞌinu, hasta nú utaꞌcu bee bene liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Leta bee bene zeꞌe nza tucu unaꞌa enu riti, nu necala chiꞌchiucu lana nú rlaca rene liꞌilla, nu ulaꞌxulalla ye bee steneꞌlla ungüitilla nú uyaxu bee doctor, pero niꞌ tucu beei né riꞌiyeca beei liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Che uyabica unaꞌa quieꞌ diꞌchi Jesuse nu utiꞌlla yalla ruꞌu xucunu, hora zeꞌe utsuxe nú rlaca rene liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nu unidichiaꞌ Jesuse lubee bene: ―¿Ti utiꞌya liꞌá? Nu uni yebeei lunu nú né tiꞌya beei liꞌinu, che uni Pedro cuna beelá bee saꞌlla lunu: ―Maestro, huaxi bee bene rtaꞌcu liaꞌahua nu chuquieꞌ churquie siꞌña beei liaꞌahua, nu rnidichiaꞌscaꞌlu: “¿Nú ti utiꞌya liꞌilu?” ");
INSERT INTO zplNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero uni Jesuse lubeella: ―Nuꞌ enu utiꞌya liꞌá, xne uriꞌá beyaꞌ nú uriꞌiyeca tucu enu uriꞌiyeca cuna nú recaa. ");
INSERT INTO zplNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chenu uriꞌi unaꞌa zeꞌe beyaꞌ nú uriꞌinu beyaꞌ, che chu uyabicalla nu recatseꞌtsella utsulliquilla lu Jesuse. Nu uxucuꞌ dulalla luye bee bene xinu utiꞌyalla ruꞌu xucunu, cuna nú xa uyecaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Che uni Jesuse lulla: ―Xinchiuꞌcua equie nú uchili arquiꞌlu liꞌá enzeꞌe uyecaꞌlu. Uquiaꞌa nzeꞌca nee. ");
INSERT INTO zplNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Rdichiaꞌnuscaꞌ Jesuse unaꞌa zeꞌe, chenu uriña tucu bee beneꞌ Jairo nu unilla lu Jairo: ―Ungutila enduꞌlu. La riꞌi xiaꞌlu lu Maestro nee. ");
INSERT INTO zplNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero chenu ubeneꞌ Jesuse nucuaꞌ uninu lu Jairo: ―La lliquilu, uchilitsia arquiꞌlu liꞌá yecaꞌ enduꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chequie chenu uriña Jesuse niꞌi Jairo, lá zelanu nú achuꞌununu beelá bee bene, uyuꞌunutsianu Pedro, cuna Jacobo, cuna Juan cuna paꞌnchu cuna naꞌnchu liñi niꞌi zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ye bee bene runaꞌ, nu nehuana nzu arquiꞌbeei equie cuendaꞌnchu, pero uni Jesuse lubeei: ―La unaꞌhua. Lá ati enduꞌ quieꞌ, raꞌtsetsianchu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero ulliꞌchinu beei liꞌinu, xne nediyaꞌ beei nú ungutilanchu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Che chu unaꞌtse Jesuse yanchu, nu juerte uninu lunchu: ―¡Enduꞌ, uzetee! ");
INSERT INTO zplNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nu uhuañi zecanchu, nu hora zeꞌe uzeteenchu nu unibiyaꞌ Jesuse nú deteꞌ beella nú acunchu. ");
INSERT INTO zplNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chequie chiquiꞌ uyanu arquiꞌ paꞌnchu cuna naꞌnchu nucuaꞌ. Pero uni Jesuse lubeella nú la ixiuleꞌe beella lu niꞌ tucu bee bene lunú ungae scua. ");
INSERT INTO zplNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Uquieteꞌsaꞌ Jesuse chiꞌchiucu bee beneꞌnu, nu udeteꞌnu poder lubeella para nú hua beella ye clasiaꞌ bee benechiquiꞌ arquiꞌ bee bene cuna nú riꞌiyeca beella bee bene enu riti. ");
INSERT INTO zplNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Uxeꞌlanu liꞌibeella para nú ixiuleꞌe beella xa neca lunú rnibiyaꞌ Diose, cuna nú riꞌiyeca beella bee bene enu riti. ");
INSERT INTO zplNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nu uninu lubeella: ―Lecaxi uyaꞌhua para inziu, niꞌ xcahua niꞌ biti, niꞌ pá nu acuhua, niꞌ dimi, niꞌ xucuhua para nú cheꞌehua la uyaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tatse niꞌi bee bene elu riñahua, uyaꞌnatsiahua niꞌi zeꞌe, hasta nú chiuꞌuhua eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nu tunu nuꞌ tucu eyeche elu la zela bene nú yaꞌnahua niꞌlla, uchiuꞌuhua eyeche zeꞌe nu riꞌquihua yuu beꞌchaꞌ nú nuꞌ cuchiuꞌhua xi neca tucu seña nú lá yucu arquiꞌbeei Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chequie uchiuꞌu beella nu nzuebeella cada tucua eyeche udixiuleꞌe beella bedichiaꞌ nzeꞌcaꞌ Diose lubee bene, nu uriꞌiyeca beella bee bene enu riti. ");
INSERT INTO zplNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Chenu ubeneꞌ arre Herodes ye bee milagro nú rriꞌi Jesuse, la riꞌilla beyaꞌ ti necanu. Xne nuꞌ bee bene enu rni nú uhuañi zeca Juan Bautista. ");
INSERT INTO zplNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nu nuꞌ bee bene rni nú profeta Elías ulubeꞌlu. Nu nuꞌ bee bene rni nú necanu tucu bee profeta huaꞌtu enu uhuañi zeca. ");
INSERT INTO zplNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero uni Herodes: ―Liꞌá unibiyaꞌa nú uruꞌu lluca equie Juan Bautista. ¿Ti benecuaꞌ nú rienea nú rriꞌilla huaxi bee milagro scua? Nu chiquiꞌ niarquiꞌ Herodes nú lañiꞌlla Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Chenu ubenchilaꞌ bee apóstolꞌ Jesuse, udixiuleꞌe beella lunu beenú uriꞌi beella. Che unguyaꞌnu beella tucu luhuare elu la nucuaꞌa bee bene axu eyeche Betsaida. ");
INSERT INTO zplNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero chenu uriꞌi bee bene beyaꞌ, chu nzequie beei liꞌinu. Nu uya chaꞌcalu Jesuse liꞌibeei nu udixiuleꞌenu lubeei xa neca nú rnibiyaꞌ Diose, nu uriꞌiyecanu bee bene enu riti. ");
INSERT INTO zplNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chenu nze cheela, uyabica chiꞌchiucu bee beneꞌ Jesuse lunu nu uni beella lunu: ―Uniꞌ lubee benequieꞌ nú yue beei para nú chetsulachi beei nu chélaꞌna beei nú acu beei lubee eyeche axu caꞌa, xne elu nelluaꞌahua caꞌa lecalí xinuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero uni Jesuse lubeella: ―Liꞌihua udeꞌtehua nú acubeei. Nu ucuaqui beella lunu: ―Rluꞌcutsiaru ayuꞌ pá cuna chiucu bela. Mejora chatsiaꞌahua nú acu ye bee benequieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Neca tucu ayuꞌ mili bee niyu zeꞌe. Pero uni Jesuse lubee beneꞌnu: ―Uniꞌhua lubeei nú cuaꞌa cincuentaa cincuentaa beei cada tucu luhuare. ");
INSERT INTO zplNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Scua uriꞌi beella, nu chu ucuaꞌa ye bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chequie unaꞌtse Jesuse ayuꞌ pá zeꞌe cuna chiucu bela zeꞌe, nu ubiꞌyanu enza liñibe nu udeteꞌnu cheꞌtsa lu Diose, nu uleꞌenu bee pá zeꞌe cuna bee bela zeꞌe nu udeteꞌnu nucuaꞌ lubee beneꞌnu para nú ritsiꞌ beellae lubee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ye bee bene zeꞌe udacu beei hasta nú ubelaꞌ beei. Chenu ulaxu nú udacu beei, uquietesaꞌscaꞌ beella chiꞌchiucu llume bee pedaso bee pá leꞌe cuna bee bela lunú uyaꞌna udacu beella. ");
INSERT INTO zplNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tucu bichia chenu unacuꞌ liꞌitsia Jesuse lu Diose nzununu bee beneꞌnu zeꞌe. Che unidichiaꞌnu lubeella: ―¿Ti rni bee bene nú necaa? ");
INSERT INTO zplNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nu ucuaqui beella lunu: ―Nuꞌ bee bene rni nú necalu Juan Bautista. Nu leꞌca nuꞌ bee bene rni nú necalu profeta Elías, nu leꞌca nuꞌ bee bene rni nú necalu tucu bee profeta huaꞌtu enu uhuañi zeca. ");
INSERT INTO zplNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Che uninu lubeella: ―¿Nu liꞌiquieehua ti rnihua nú necaa? Nu ucuaqui Pedro lunu: ―Liꞌilu necalu Cristo enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero uni Jesuse lubeella nú la ixiuleꞌe beella nucuaꞌ lu niꞌ tucu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nu uninu lubeella: ―Liꞌá Bene enu uxeꞌla Diose chiquiꞌ nehuana zecaa, nu lee bee usticiaꞌ bee bene Israel lua, cuna bee uleꞌya enu rnibiyaꞌ lubee uleꞌya, cuna bee ulaxcuela enu reca leyꞌ Moisés, uti beei liꞌá, pero bichia rriuna huañi zecaa stucu bese. ");
INSERT INTO zplNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Che uninu lu ye bee bene: ―Tunu nuꞌ bee bene enu niarquiꞌ nú aca benea, la yala nú riꞌitsialla tucu nú necatsia elliebacuꞌlla. Nu ye bichia riquiꞌlla lubee nú xi zecalla equie nú necalla benea, nu chu yeꞌta quieella liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Xne bee bene enu másela niarquiꞌ huañi lu iliulabe quieꞌ enta bichia nú laxu nucuaꞌ. Pero bene enu ati equie nú necalla benea, luꞌculla elunehuañi lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lecaxi zibiꞌ nú riꞌi bene ana ye beenú nuꞌ lu iliulabe, tunu leꞌca liꞌitsialla nze nitilulla liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tunu nuꞌ bene enu tuꞌ liꞌá cuna stichiaꞌa, leꞌca liꞌá Bene enu uxeꞌla Diose tua liꞌilla chenu nzela nú necaa arre cuna lunú rnibiyaꞌ paa cuna lunú rnibiyaꞌ bee ángeleꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ixiuleꞌa luhua nu nuꞌ bee bene enu nucuaꞌa caꞌa lá atiscaꞌ, hasta nú lañiꞌ beei xa neca lunú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chenu udete xi neca tucu xmana nú uni Jesuse bee bedichiaꞌ cuaꞌ, uyanu equie tucu dañi unacuꞌnu lu Diose, nu unguyaꞌnu Pedro, cuna Jacobo, cuna Juan. ");
INSERT INTO zplNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pero diqui nú rnacuꞌ Jesuse lu Diose ucheꞌe xa rnaa lunu, nu chiquiꞌ unga niquichiu xucunu nu tuꞌna rulu siquiꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nu ulubeꞌlu chiucu niyu enu rdichiaꞌnu liꞌinu zeꞌe. Bee bene zeꞌe neca Moisés cuna Elías. ");
INSERT INTO zplNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nu chiquiꞌ rulu siquiꞌ beella nu rdichiaꞌnu beella Jesuse equie nú atinu nu nehuana zecanu eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Añinzuca nú chiquiꞌ riuꞌu calaꞌ lu Pedro cuna lubee saꞌlla, pero né aꞌtse beella, nu ulañiꞌ beella nú rulu siquiꞌ Jesuse cuna rucu bene enu nzununu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chenu lecaꞌ rucu benecuaꞌ elu nzu Jesuse, uni Pedro lunu: ―Maestro, ¡neca nzeꞌca nú nelluaꞌahua caꞌa para nú recheꞌru chuna ranchu, tucue para liꞌilu nu stucue para Moisés, nu stucue para Elías! Pero la riꞌi Pedro beyaꞌ xinu rnilla scua. ");
INSERT INTO zplNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Diqui nú rnilla scua, ulaca tucu xcabe nú utsacuꞌ equie beella, nu ulliqui beella chenu nchiñi beella liñi xcabe zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nu liñi xcabe zeꞌe uyene tucu chii enu uni: ―Benequieꞌ neca Lliꞌñia enu chiquiꞌ seꞌca, uzuꞌcuꞌhua stichiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chenu ulaxu nú ubeneꞌ beella chi enu uni zeꞌe, ulañiꞌ beella nú stucu liꞌi Jesuse nzunu zeꞌe nu né nilí beella. Bee bichia zeꞌe niꞌ tucu leca tilu udixiuleꞌe beella lunú ulañiꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chenu uyeꞌe lu yuu stucu bichia, nú ulaca beella equie dañi zeꞌe, huaxi bee bene uchiuꞌu uya chaꞌcalu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chequie tucu bene enu nzeꞌta leta bee bene zeꞌe urixialii nú uni: ―Maestro, ubiꞌyacuru endua, tucutsia liꞌi necai endua. ");
INSERT INTO zplNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nu nchiñi benechiquiꞌ arquiꞌi nu rriꞌi nzeꞌe nú rixialii, nu secai ichia ziña nu xiuꞌu lliña ruꞌi, rtiꞌqui benechiquiꞌ cuaꞌ liꞌi nu la tsanaꞌ nucuaꞌ liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Uzequieelá lubee beneꞌlu nú hua beella benechiquiꞌ cuaꞌ arquiꞌ endua, pero lá aca beella. ");
INSERT INTO zplNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nu ucuaqui Jesuse nú uninu: ―¡Cueꞌhua bee bene enu rluꞌcu dula nú la chili arquiꞌhua liꞌá! ¿Se xala tiembu rquiꞌña nú tsunua liꞌihua nu xa riquilá liꞌihua? Uteyuu enduꞌlu caꞌa. ");
INSERT INTO zplNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pero chenu nzebica enduꞌ zeꞌe lu Jesuse, utsiꞌqui benechiquiꞌ liꞌi lu yuu nu ulleꞌca zecai ichia ziña stucu bese, pero unibiyaꞌ Jesuse lu benechiquiꞌ nú chiuꞌi arquiꞌ enduꞌ zeꞌe nu uriꞌiyecanu liꞌi, che udeteꞌ cuendanu liꞌi lu paꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ye bee bene enu nucuaꞌa zeꞌe chiquiꞌ uyanu arquiꞌbeei chenu ulañiꞌ beei lunú llene neca nú reca Diose. Diqui nú nzenu arquiꞌbeei lunú rriꞌi Jesuse, uninu lubee beneꞌnu: ");
INSERT INTO zplNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Uquieꞌe nzeꞌca diacahua lunú nia luhua nu la zañiꞌhua nucuaꞌ. Liꞌá Bene enu uxeꞌla Diose deteꞌ cuenda bee bene liꞌá lubee bene enu rnibiyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero lá riꞌi bee beneꞌnu beyaꞌ lunú rninu, xne lascaꞌ deteꞌnu nú rriꞌi beella beyaꞌ, nu leꞌca xiqui beella nedichiaꞌ beella lu Jesuse xi rni lunú uninu. ");
INSERT INTO zplNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chequie uquixie bee beneꞌnu nú rni beella lusaꞌbeella nú tá beella neca enu máse neca equie. ");
INSERT INTO zplNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero uriꞌi Jesuse beyaꞌ lunú xa rriꞌi beella elliebacuꞌ nu unaꞌtsenu tucu enduꞌ utsunu elu nzunu, ");
INSERT INTO zplNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nu uninu lubeella: ―Tatse bene enu riꞌi elietsa lu enduꞌ quieꞌ equie cuendaꞌ liꞌá, neca xi neca nú rriꞌi nzeꞌe elietsa lua, nu tatse bee bene enu rriꞌi caso liꞌá, leꞌca rriꞌi caso nzeꞌe bene enu uxeꞌla liꞌá. Enzeꞌe enu máse lecati neca letahua, neca nzeꞌe enu máse neca equie. ");
INSERT INTO zplNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chequie uni Juan lunu: ―Maestro, ulañiꞌru tucu bene enu rlua benechiquiꞌ arquiꞌ bee bene equie nú leelu, pero uniru lulla nu la riaꞌlla scua xne la acalla bene letaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero uni Jesuse lubeella: ―La cáhua nucuaꞌ, xne enu la riꞌi condra liaꞌahua nzu nzeꞌe chuꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chenu nzeꞌta riña bichia nú nzia Jesuse liñibe, che utsu naaqui arquiꞌnu nu nzanu Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Uxeꞌlanu bee bene enu uriculu para nú chue beei tucu eyeche nú nchiucuꞌ lu iliu Samaria para nú cuaꞌna beei elu yaꞌna beella zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero lá zela bee bene eyeche zeꞌe ayaꞌnanu eyeche zeꞌe, xne uriꞌi beei beyaꞌ nú nzanu Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chenu ulañiꞌ Juan cuna Jacobo nucuaꞌ, che uni beella lunu: ―Detá Jesuse, ¿niarquiꞌlu nú nibiyaꞌahua nú laca quii enza liñibe para nú laꞌxue bee bene cuaꞌ tucu nú uriꞌi profeta Elías la? ");
INSERT INTO zplNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chequie ubiꞌya Jesuse lubeella, nu uquiꞌyaꞌ beella uriꞌinu nú uninu lubeella: ―¿Xieꞌ la riꞌihua beyaꞌ nú lu bezeꞌlu nzeꞌta nú rnihua scua la? ");
INSERT INTO zplNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Xne liꞌá Bene enu uxeꞌla Diose, lá yela para nú riꞌá nú ati bee bene, nzela para nú tsilaꞌa liꞌibeei lu dula. Che chu nzuebeella stucu eyeche. ");
INSERT INTO zplNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Diqui nu nzuebeella inziu, uni tucu niyu lu Jesuse: ―Niarquia nu nzela quiea liꞌilu catse elu nzalu. ");
INSERT INTO zplNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Che ucuaqui Jesuse lui: ―Bee betsa rluꞌcuí bee iliuꞌu nú neca niꞌí nu bee iñi rluꞌcuí exliaꞌtseꞌí, pero liꞌá Bene enu uxeꞌla Diose niꞌ elu quiee nchiñaꞌ equiea la lucua. ");
INSERT INTO zplNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nu uni Jesuse lu stucu bene: ―Utequiee liꞌá. Pero ucuaquii lunu: ―Uzela nú biꞌya paa hasta nú atinu nu che chu nzela quiea liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Che uni Jesuse lui: ―Utsaꞌna paꞌlu cuna bee bene enu neca xi neca bene enu unguti, pero liꞌilu uquia tixiuleꞌe xa neca elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nu uni stucu bene lu Jesuse: ―Niarquia nú nzelanala liꞌilu, pero rluti uzela nú nze tixiuleꞌexua lubee benea. ");
INSERT INTO zplNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero uni Jesuse lui: ―Bene enu nzene ya acaratu nu belletalla enza diꞌchilla, leca modo nú cha neli excuꞌlla. Leꞌca esquie bee bene enu niarquiꞌ nú yeꞌta quiee liꞌá, tunu la cheꞌe arquiꞌbeella lunú xa nehuañi beella, leca modo nú aca beella bee beneꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lulá bee nucuaꞌ, ucañi Jesuse setenta bee beneꞌnu, nu uxeꞌlanu chiucua chiucua beella nú riculu beella lunu, nú chue beella lubee eyeche cuna lubee ranchu elu chanu. ");
INSERT INTO zplNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nu uninu lubeella: ―Neli nú nucuaꞌa huaxi bee bene enu niarquiꞌ yeneꞌ Stichiaꞌ Diose, pero leca huaxi bee bene enu zeteꞌ liꞌibeei. Enzeꞌe unaꞌcuꞌhua lu Diose para nú xeꞌlalánu bee bene enu zeteꞌ liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Uquiahua, liꞌá xeꞌla liꞌihua xi neca chenu nza bee sanchi leta bee bichiu. ");
INSERT INTO zplNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","La uyaꞌhua biti, nú nuꞌ steneꞌhua niꞌ dimi, niꞌ steinza lucuhua nu la cuaꞌa xehua lubee bene lu inziu. ");
INSERT INTO zplNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Chenu riñahua niꞌi tucu bene, rluti uriꞌihua saludar bene zeꞌe nú nihua lulla: “Diose liquiꞌ nú nzuxe arquiꞌhua.” ");
INSERT INTO zplNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nu tunu niꞌi zeꞌe nucuaꞌa bee bene enu riala nú nzuxe arquiꞌ riaꞌna nú nzuxecuaꞌ cuna bee bene zeꞌe che, pero tunu la yala bee bene niꞌi zeꞌe nucuaꞌ, benchilaꞌ zeca nucuaꞌ cuna liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Uyaꞌnatsiahua niꞌi zeꞌe, nu la yaꞌnahua niꞌi por niꞌi bee bene, udacuhua nu hueꞌhua lunú liquiꞌ beella luhua, xne bee bene enu rriꞌi riñaꞌ rquiꞌña nú aculla. ");
INSERT INTO zplNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Chenu riñahua tucu eyeche elu zela bee bene nú riaꞌnahua, udacuhua nú liquiꞌ beei luhua, ");
INSERT INTO zplNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","uriyecahua bee bene enu riti nucuaꞌa zeꞌe, nu uniꞌhua lubeei: “Nzeꞌta riñala lunú rnibiyaꞌ Diose luhua.” ");
INSERT INTO zplNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero tunu riñahua tucu eyeche elu la zela bee bene nú riaꞌnahua, uchiuꞌhua lu inziu nu nihua lubeei: ");
INSERT INTO zplNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“¡Hasta yuu beꞌcha lachihua nú uquie cuchiuꞌru uriꞌquiru xi neca tucu seña nú né yucu arquiꞌhua Stichiaꞌ Diose! Pero uriꞌihua beyaꞌ nú nzeꞌta axula lunú rnibiyaꞌ Diose luhua.” ");
INSERT INTO zplNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nia luhua nú bichia nú laxu iliulabe, bee eyeche elu lá zela bee bene, nú ayaꞌnahua, zeca beei castiya nú mase juerte, lunú zeca bee bene enu ucuaꞌa eyeche Sodoma. ");
INSERT INTO zplNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Cueꞌhua bee bene eyeche Corazín! ¡Nu cueꞌhua bee bene eyeche Betsaida! Xne tunu eyeche Tiro cuna eyeche Sidón aca bee milagro nú unga lachihua, xi tiembu achili arquiꞌ bee bene zeꞌe Stichiaꞌ Diose, nu leꞌca autu beei laquie natsa para nú lubeꞌ nú nehuana nzu arquiꞌbeei nu aricuꞌ beei tí equie beei xi neca seña nú ucheꞌe arquiꞌbeei lu stula beei. ");
INSERT INTO zplNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero bichia chenu laxu iliulabe, másela juerte castiya nú zecahua lunú zeca bee bene eyeche Tiro cuna eyeche Sidón. ");
INSERT INTO zplNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Leꞌca esquie liꞌihua bee bene Capernaum, la riꞌihua elliebacuꞌ nú riala chuꞌuhua liñibe xne liꞌihua rialahua hasta elu mase aquié rquiꞌ ebila. ");
INSERT INTO zplNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Nu chu ubiꞌyanu lubee beneꞌnu nu uninu: ―Bene enu rriꞌi caso lunú rnihua, rriꞌi bee nzeꞌe caso liꞌá, nu bene enu rluachu liꞌihua liꞌá rluachu nzeꞌe, nu bene enu rluachu liꞌá rluachu nzeꞌe Diose enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chenu ubenchilaꞌ zeca setenta bee beneꞌ Jesuse enu uxeꞌlanu lubee eyeche, chiquiꞌ ñia nzu arquiꞌbeella nu necachi uni beella lunu: ―¡Detá, hasta bee benechiquiꞌ sucuꞌ stichiaꞌru chenu rniru lunú leelu! ");
INSERT INTO zplNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nu uni Jesuse lubeella: ―Nelíꞌhua nucuaꞌ, liꞌá ulañia nú xi neca chenu riaꞌla lee esquie uniti lunú rnibiyaꞌ bezeꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Liꞌá uliquia lunú rnibiyaꞌa luhua, para nú mase nú taꞌhua equie bee beꞌla cuna equie bee nañi lliqui, nu leꞌca para nú riꞌihua ana lunú rnibiyaꞌ bezeꞌlu, nu lecaxi zecahua. ");
INSERT INTO zplNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero la llilaꞌ arquiꞌhua nú sucuꞌ bee benechiquiꞌ stichiaꞌhua, mejora ullilaꞌhua nú nzucu ichila nú leehua lu ichiꞌ liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hora zeꞌe chiquiꞌ ñia utsu arquiꞌ Jesuse equie cuendaꞌ Espíritu Santo, nu uninu: ―Paa liꞌilu enu rnibiyaꞌ liñibe cuna lu iliulabe, zucu ayáa liꞌilu xne uzeteꞌlu bee bene enu lecaxi reca lunú ucachiꞌlu lubee bene enu reca cuna lubee bene enu rriꞌi beyaꞌ. Paa scua ungae, xne scua riuꞌ arquiꞌlu nú acane. ");
INSERT INTO zplNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Uliquiꞌla Diose Pa liñibe ye nú nibiyaꞌa lu ye beenú nuꞌ. Lecati nediyaꞌ ti neca Jesucristo Lliꞌñi Diose, Diose tsia nediyaꞌ nucuaꞌ, leꞌca tucutsia Jesucristo cuna bee bene enu nzeli arquiꞌ liꞌinu nuꞌlu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chequie ubiꞌyanu lubee beneꞌnu, nu uninu lu liꞌitsia beella: ―Ñia nza lu cuendaꞌ bee bene enu rlañiꞌ lunú rlañiꞌhua, ");
INSERT INTO zplNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","xne nia luhua nú huaxi bee profeta cuna bee arre uniarquiꞌ beella nú lañiꞌ beella lunú rlañiꞌhua, pero né lañiꞌ beella nucuaꞌ. Nu uniarquiꞌ beella nú yeneꞌ beella nú rieneꞌhua pero né yeneꞌ beella nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Che utsuli tucu ulaxcuela enu reca leyꞌ Moisés nu unilla lu Jesuse para nú riꞌilla preo liꞌinu: ―Maestro, xi riala riꞌá para nú lucua elunehuañi nú leca xunga laxu liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nu ucuaqui Jesuse lulla: ―¿Xi rni leyꞌ Moisés? ¿Nu xa rriꞌilu beyaꞌ nú rnii? ");
INSERT INTO zplNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chequie uni ulaxcuela zeꞌe, rni ley: ―“Uzeca liꞌinu enu neca Dioseꞌlu diquinuꞌ arquiꞌlu, cuna diquinuꞌ lunú necalu, cuna diquinuꞌ juerzalu, cuna diquinuꞌ elliebacuꞌlu, nu uzeca bee bene tucu nú secalu liꞌilu.” ");
INSERT INTO zplNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Che uni Jesuse lulla: ―Ucuaqui nzeꞌcalu, tunu riꞌilu scua, luꞌculu eluhuañilílu liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero ulaxcuela zeꞌe niarquiꞌlla nú yaꞌna nzeꞌcalla lunú unidichiaꞌlla lu Jesuse, che unilla lunu: ―¿Ta bene zecaa tucu nú seꞌca liꞌá che? ");
INSERT INTO zplNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chequie uni Jesuse tucu ejemplu lulla: ―Tucu bene Israel uchiuꞌulla eyeche Jerusalén nu nzalla eyeche Jericó, che unaꞌtse bee huanaꞌ liꞌilla inziu nu udiñi beei liꞌilla, nu ucachiꞌ beei ye bee steneꞌlla hasta xuculla. Nu utsaꞌna beei liꞌilla xi neca tucu bene enu unguti. ");
INSERT INTO zplNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Che udete tucu uleꞌya inziu zeꞌe, pero chenu ulañiꞌ uleꞌya zeꞌe nú nuxu bene zeꞌe, udete chechulla nu chu nzalla. ");
INSERT INTO zplNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Leꞌca enza zeꞌe udete tucu levita enu rriꞌi elietsa lubee uleꞌya, nu chenu ulañiꞌ levita cuaꞌ nú nuxu bene zeꞌe, udete chechulla nu chu nzalla. ");
INSERT INTO zplNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Chequie udete tucu bene Samaria inziu zeꞌe, chenu ulañiꞌlla bene enu nuxu lu inziu zeꞌe, uhuaꞌa arquiꞌlla bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nu chu uyabicalla elu nuxu bene zeꞌe nu uriꞌilla remedio elu nediꞌqui bene zeꞌe cuna aceite cuna biñu, nu ullicaꞌcuulla elu nediꞌqui bene zeꞌe cuna laquie. Nu chu uricuꞌlla bene zeꞌe equie burruꞌlla nu unguyaꞌlla bene zeꞌe elu neca posada, zeꞌe ubiꞌyalla bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chenu uyeꞌe lu yuu stucu bichia nú rquiene bene Samaria nú nzialla, che udixiulla lu bene enu neca stene posada lunú seca chiucu bichia riñaꞌ bene nu unilla lu bene zeꞌe: “Ubiꞌya benequieꞌ, tunu riꞌilu huaxilá gasto lu cuendaꞌlla, liꞌá ixiua nucuaꞌ chenu benchilaꞌ zecaa.” ");
INSERT INTO zplNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Che uni Jesuse lu ulaxcuela enu reca leyꞌ Moisés: ¿Taa lu chuna bee bene enu udete lu inziu zeꞌe uzeca bene enu udiñi bee huanaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nu ucuaqui ulaxcuela zeꞌe nú unilla: ―Bene enu uhuaꞌa arquiꞌ bene zeꞌe. Che uni Jesuse lulla: ―Uquia nu scua uriꞌi lu stucu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Diqui nú nze riꞌi Jesuse seidu inziuꞌnu uriñanu tucu eyeche, zeꞌe uyanu niꞌi tucu unaꞌa enu lee Marta. ");
INSERT INTO zplNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta quieꞌ rluꞌcunchu tucu belanchu enu lee María, nu uzucu María lu Jesuse para nú yeneꞌnchu lunú rninu. ");
INSERT INTO zplNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero Marta chiquiꞌ rlialaꞌnchu rriꞌinchu beenú rriꞌinchu, nu uyabicanchu lu Jesuse nu uninchu lunu: ―Detá, ¿Xieꞌ la chenu arquiꞌlu nú tucutsia liꞌá utsaꞌna belaa ye bee riñaꞌ nú riꞌá la? Alaꞌ uniꞌi lunchu nú riꞌinchu elietsaa. ");
INSERT INTO zplNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nu ucuaqui Jesuse lunchu nú uninu: ―Marta, Marta, chiquiꞌ nzenu arquiꞌlu lu huaxi bee riñaꞌlu, ");
INSERT INTO zplNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pero nuꞌ tucu nú máse neca equie. Maria ucañi nú máse neca equie, nu lecati caa nucuaꞌ lunchu. ");
INSERT INTO zplNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tucu bese chenu rnacuꞌ Jesuse lu Diose tucu luhuare, nu chenu ulaxu nú unacuꞌnu lu Diose, tucu bee beneꞌnu uni lunu: ―Detá Jesuse, uzeꞌteꞌ liꞌiru xa nacuꞌru lu Diose, tucu nú uzeteꞌ Juan Bautista bee bene, enu uyaquie liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Che uni Jesuse lubeella: ―Chenu nacuꞌhua lu Diose uniꞌhua: Paꞌru Diose, liꞌilu enu nzucu liñibe, chiquiꞌ riala nú luꞌcuru ulaꞌna lunú leelu. Nu yeꞌta lunú rnibiyaꞌlu luru. Aca lunú riuꞌ arquiꞌlu lu iliulabe quieꞌ tucu nú reca liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Uliꞌquiꞌ nú daꞌcuru ye bichia. ");
INSERT INTO zplNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Uriꞌi perdona stularu, xne liꞌiru leꞌca rriꞌiru perdona bee bene enu rriꞌi nú necha neca luru. La tsanaꞌlu liꞌiru nú riꞌiru dula, uriꞌi elietsa luru para nú la riꞌiru ye beenú necha neca. ");
INSERT INTO zplNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Leꞌca uni Jesuse lubeella: ―Te zucuaꞌahua tunu tucuhua rluꞌcu tucu bene enu rquieteꞌhua, nu riña nzeꞌe ulelaꞌ rulaꞌ niꞌhua nu ni nzeꞌe: “Alaꞌ zelalu utsanaꞌ chuna pá chenua, ");
INSERT INTO zplNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","xne uriña inza tucu bene enu rquietea nia, nu nzeꞌtalla enza istu nu lecalí xi lucua detea aculla.” ");
INSERT INTO zplNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nu cuaqui bene zeꞌe liñi niꞌlla nú nilla: “La riꞌixiꞌilu lua nacuꞌla nia, raꞌtselá nu raꞌtsela bee endua leca modo nú zetea para nú biquia lunú rnacuꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pero nia luhua, añinzuca nú la zeteella para nú deteꞌlla lunú rnacuꞌ bene enu rquieteꞌlla, pero riꞌilla juerza nú zeteella para nú deteꞌlla ye nú secalaꞌchaꞌ bene zeꞌe para nú la riꞌixiaꞌ nzeꞌe lulla. ");
INSERT INTO zplNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Enzeꞌe nia luhua: Unaꞌcuhua lu Diose che liquiꞌnu luhua lunú rnacuꞌhua. Ulaꞌnahua liꞌinu, che llelaꞌhua liꞌinu. Uziquieehua lunu nu unaꞌcuhua lunu che riꞌi casonu liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Xne bene enu rnacuꞌ nú rnacuꞌ lunu riucu nzeꞌene, nu enu rlaꞌnae xelaꞌ nzeꞌene, nu enu siquiee nu rnacuꞌ lunu rriꞌinu caso nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Tunu nuꞌhua enu neca paa, ¿Xieꞌ deteꞌhua tucu quiee lu enduꞌhua chenu rnacuꞌ nzeꞌe pá la? ¿Urre xieꞌ deteꞌhua tucu beꞌla lu nzeꞌe chenu rnacuꞌ nzeꞌe beela la? ");
INSERT INTO zplNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Urre xieꞌ deteꞌhua tucu alacrán chenu rnacuꞌ nzeꞌe tucu artabechiu la? ");
INSERT INTO zplNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tunu liꞌihua enu necha rriꞌi, recahua rdeteꞌhua beenú neca nzeꞌca lubee lliꞌñihua, ¡Pero máselá rliquiꞌ Paꞌahua enu nzucu liñibe Espíritu Santo lubee bene enu rnacuꞌ lunu! ");
INSERT INTO zplNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Chenu ulua Jesuse benechiquiꞌ enu uriꞌi nú lá niaꞌ tucu bene, nu chenu uchiuꞌu benechiquiꞌ cuaꞌ arquiꞌ bene zeꞌe, uquixie nú rnilla. Che chiquiꞌ uyanu arquiꞌ bee bene nucuaꞌ, ");
INSERT INTO zplNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","pero nuꞌ bee bene enu uni: ―Benequieꞌ rlua benechiquiꞌ arquiꞌ bee bene cuna lunú rnibiyaꞌ bezeꞌlu enu rnibiyaꞌ lubee benechiquiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Stucu beei unacuꞌ tucu milagro liñibe lunu para nú riꞌi beei beyaꞌ tunu neli nú Diose uxeꞌla liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero liꞌinu nediyaꞌlaꞌnu xi rriꞌi beei elliebacuꞌ nu uninu lubeei: ―Tatse bee gobierno enu la neca tucu necatse rleꞌ saꞌbeei, leꞌca esquie bee bene tucu niꞌi tunu la neca tucu necatse beei rleꞌe saꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Leꞌca esquie tunu leꞌca liꞌi bezeꞌlu riꞌi condrai bee benechiquiꞌ, ¿xa diꞌya nú rnibiyaꞌi che? Rnia nucuaꞌ luhua, xne rnihua nú rluaa benechiquiꞌ arquiꞌ bee bene cuna lunú reca bezeꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pero tunu scua necane, ¿ti rliquiꞌ lunú reca bee beneꞌhua rlua beella benechiquiꞌ arquiꞌ bee bene che? Nia luhua nú leꞌca liꞌibeella rni beella nú necha rriꞌihua elliebacuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Xne liꞌá rlua bee benechiquiꞌ arquiꞌ bee bene equie nú reca Diose, nucuaꞌ rlubeꞌ nú nzula lunú rnibiyaꞌ Diose cuna liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Tucu bene enu naaqui nu rluꞌculla nú acanuꞌ liꞌilla para nú riꞌiuculla niꞌlla, leca modo nú cachiꞌ bee bene steneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero tunu nzeꞌta stucu bene enu naaquilá lulla, che riꞌi nzeꞌe ana lulla nu axi nzeꞌe lunú rluꞌculla, nú rriꞌilla elliebacuꞌ nú acanuꞌ liꞌilla, nu leꞌca axi nzeꞌe ye bee steneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Bene enu la nzu chua rriꞌi condra nzeꞌe liꞌá, nu bene enu riꞌi nú la quieteꞌ bee bene liꞌá, rriꞌi nzeꞌe nú rleꞌe saꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Chenu xiuꞌu tucu benechiquiꞌ arquiꞌ tucu bene, enzei bee luhuare elu nebichi rlaꞌnai elu tsulachii. Nu chenu la llelaꞌi elu tsulachii, che rriꞌi elliebacuꞌ: “Mejora benchilaꞌ zecaa elu uchiuꞌa.” ");
INSERT INTO zplNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nu chenu benchilaꞌ zecai, llelaꞌi arquiꞌ bene elu uchiuꞌi xi neca liñi tucu niꞌi nú nelucuꞌ nu rnaa nzeꞌcae. ");
INSERT INTO zplNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chequie nze tucui se achi benechiquiꞌ enu másela necha rriꞌi luquela liꞌi, nu chuꞌu ye beei arquiꞌ bene zeꞌe. Che masescaꞌlá necha aca bene zeꞌe lunú necalla huaꞌtu ");
INSERT INTO zplNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Diqui nú rni Jesuse bedichiaꞌ cuaꞌ, leta bee bene zeꞌe ubixialí tucu unaꞌa nu unilla: ―¡Ñia nza lu cuendaꞌ unaꞌa enu ullaana liꞌilu nu uriꞌi ruꞌcu liꞌilu! ");
INSERT INTO zplNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero ucuaqui Jesuse nú uninu: ―¡Maselá ñia neca lu cuendaꞌ bee bene enu rieneꞌ Stichiaꞌ Diose nu sucuꞌ nú rninu! ");
INSERT INTO zplNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ullaꞌcaꞌla huaxi bee bene elu nzu Jesuse, nu uquixienu uninu lubeei: ―Bee bene enu nucuaꞌa lu iliulabe quieꞌ necha rriꞌi beei nu rnacuꞌ beei tucu milagro lua, pero la riaꞌa niꞌtucu milagro lubeei, xne nediyaꞌlaꞌbeei milagro nú unga lu profeta Jonás. ");
INSERT INTO zplNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tucu nú unga Jonás tucu seña lubee bene Nínive, leꞌca scua liꞌá Bene enu uxeꞌla Diose aca tucu seña lubee bene enu nucuaꞌa nee. ");
INSERT INTO zplNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bichia chenu laxu iliulabe, chenu hualu Diose lu cuendaꞌ bee bene, chequie unaꞌa enu unibiyaꞌ lu iliu nú lee sabá huañi zecalla nu nilla nú riala bee bene enu nucuaꞌa nee castiya nú deteꞌ Diose. Xne liꞌilla uchiuꞌulla enza istu, nu ubeꞌtalla para nú ubeneꞌlla lunú reca arre Salomón. Nu liꞌá Jesuse enu nzu cuna liꞌihua, másela neca equia luquela arre Salomón. ");
INSERT INTO zplNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Leꞌca huañi zeca bee bene enu ucuaꞌa eyeche Nínive bichia chenu laxu iliulabe, chenu hualu Diose lu cuendaꞌ bee bene enu nehuañi nee, nu ni bee bene Nínive nú bee bene enu nehuañi nee riala beei castiya nú deteꞌ Diose. Xne bee bene eyeche Nínive uzucuꞌbeei nú uni Jonás chenu unilla lubeei nú huañi beei tucu nú niarquiꞌ Diose. Nu liꞌá Jesuse enu nzu cuna liꞌihua másela neca equiea luquela Jonás. ");
INSERT INTO zplNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Lecati quieꞌe quii tucu quinqué nu tsullae elu aꞌchiꞌ, urre tsacuꞌlla tucu caja equiee. Pero zucune elu ayaa para nú duꞌ llieꞌe lubee bene enu chuꞌu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Iꞌculuaꞌahua neca xi neca ellieꞌe lu cuerpoꞌahua, tunu rriaꞌahua lunú neca nzeꞌca diqui cuerpoꞌahua nuꞌ ellieꞌe. Nu tunu rriꞌahua nú necha neca, diqui cuerpoꞌahua neca xi neca tucu elu natsacabe. ");
INSERT INTO zplNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ubiꞌya liꞌilu para nú la chenu iꞌcululu liꞌilu inziu nú necha neca. ");
INSERT INTO zplNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tunu la riꞌi cuerpoꞌahua niꞌ temeꞌ nú necha neca, che neca cuerpoꞌahua xi neca tucu quiꞌ quinqué nú rduꞌllieꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Chenu ulaxu nú uni Jesuse lubeei, tucu fariseo uzeneꞌ Jesuse para nú chanu acununui eta niꞌi. Chenu uyuꞌunu liñi niꞌi chu uzucunu lu mexa. ");
INSERT INTO zplNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nu chiquiꞌ uyanu arquiꞌ fariseo zeꞌe nú ne naa Jesuse ante nú acunu tucu nú neca costumbreꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero uni Jesuse lui: ―Liꞌihua necahua xi neca bee vaso cuna bee pliato nú neyequie diꞌchi, xne rlubeꞌ nú neca nzeꞌcahua diꞌchiquie pero liñirquie nuꞌ nú necha neca nu necahua huanaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Chiquiꞌ nziti arquiꞌhua! ¿Xieꞌ la riꞌihua beyaꞌ nú leꞌca liꞌi Diose enu urecheꞌ beꞌlaꞌhua urecheꞌ arquiꞌhua la? ");
INSERT INTO zplNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Uriꞌihua elietsa lubee bene enu lecalí xi luꞌcu, para nú scua lubeꞌ nú neli nzeꞌcahua. ");
INSERT INTO zplNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Cueꞌhua bee fariseo!, liꞌihua rdeteꞌhua diezmo bee huañi nú neca menta, cuna rruda nu ye nú racu bee bene. Rdeteꞌhua nucuaꞌ lu Diose tucu nú rnibiyaꞌ ley nú riala riꞌihua, pero la riꞌihua tucu nú neli neca lubee bene, nu la riꞌi casohua elusecaꞌ Diose. Uriꞌihua caso elu secaꞌnu nu la tsanaꞌhua nú deteꞌhua lunú rdeteꞌhua lunu. ");
INSERT INTO zplNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Cueꞌhua bee fariseo!, xne riuꞌ arquiꞌhua sucuhua liñi indu lu xleta elu sucu bee bene enu mase neca equie, nu riuꞌ arquiꞌhua nú chiquiꞌ luꞌcu bee bene ulaꞌna luhua ante huaxi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Cueꞌhua bee ulaxcuela enu reca leyꞌ Moisés cuna bee fariseo, xne la riꞌihua tucu nú rnihua! Liꞌihua necahua xi neca bee eluhua nú la lañiꞌ bee bene, nu la riꞌi beei beyaꞌ chenu rtaꞌ beei equie bee eluhua zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nu ucuaqui tucu ulaxcuela enu reca leyꞌ Moisés nú uni: ―Maestro, chenu rnilu bee bedichiaꞌ cuaꞌ leꞌca nuu luru rnilu scua la. ");
INSERT INTO zplNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero uni Jesuse lubeei: ―¡Leꞌca cueꞌhua bee ulaxcuela enu reca leyꞌ Moisés! Xne rnibiyaꞌhua nú riꞌi bee bene lunú neriñaꞌ riꞌi beei, nu niꞌ temeꞌ la niarquiꞌhua riꞌihua elietsa lubeei para nú riꞌi beei tucu nú niarquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Cueꞌhua! Xne sucheꞌhua equie bee eluhuaꞌ bee profeta enu unguuti bee beneꞌhua huaꞌtu. ");
INSERT INTO zplNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Scua rriꞌi bee bene beyaꞌ nú neca tucu necatsehua lunú uriꞌi bee beneꞌhua huaꞌtu. Liꞌibeei unguuti beei bee profeta zeꞌe, nu liꞌihua urecheꞌ nzeꞌcahua equie bee eluhuaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Enzeꞌe equie nú reca Diose uninu: “Liꞌá xeꞌla bee profeta cuna bee apóstoles, nu úti bee bene texcuaꞌa beella, nu riꞌi condra bee bene téxcuaꞌa beella.” ");
INSERT INTO zplNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chequie bee bene enu nehuañi nee, deteꞌ Diose castiya liꞌibeei equie cuendaꞌ reneꞌ bee profeta nú uriꞌchia hasta chenu uquixie iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Hasta reneꞌ Abel nu hasta reneꞌ Zacarías enu unguuti beei labe eliꞌyaꞌ indu llene Jerusalén. Nia luhua nú bee bene enu nehuañi nee, liꞌibeei ixiu beei equie nú unguuti bee beneꞌ beei bee benecuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Cueꞌhua bee ulaxcuela enu reca leyꞌ Moises!, xne la zelahua nú riꞌi bee bene beyaꞌ xa riala riꞌi beei para nú aca beei bee beneꞌ Diose, nu niꞌ liꞌihua la riꞌihua nú acahua bee beneꞌ Diose, nu rcahua nú aca bee bene enu niarquiꞌ nú aca bee beneꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Chenu uni Jesuse bee bedichiaꞌ cuaꞌ, bee ulaxcuela enu reca leyꞌ Moisés cuna bee fariseo chiquiꞌ ulee beei lunu, nu uquixie beei unidichiaꞌ beei huaxi nú unidichiaꞌ beei lunu. ");
INSERT INTO zplNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Uriꞌi beei preo liꞌinu para nú llelaꞌ beei tucu nú ricuꞌquiya beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Diquila nú nucuaꞌa beella esquie uyetesaꞌ huaxi mili bee bene zeꞌe, nu equie nú huaxi beei rtaꞌcu saꞌbeei. Chequie uquixie Jesuse uninu rluti lubee beneꞌnu: ―Ubiꞌyahua liꞌihua lu levaduraꞌ bee fariseo, rni nucuaꞌ nú ubiꞌyahua liꞌihua xne la riꞌi beei tucu nú rnibeei. ");
INSERT INTO zplNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Xne niꞌ tucu nú aꞌchi neca la yaꞌna nucuaꞌ scuatsia, riña nú acachee ye bee nucuaꞌ, nu niꞌ tucu beenú aꞌchi neca la yaꞌna nucuaꞌ scuatsia, riña nú acabiyaꞌ ye bene nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Enzeꞌe ye bee bedichiaꞌ nú unihua elu necabe nzu, yeneꞌ bee bene bee bedichiaꞌ cuaꞌ lu ellieꞌe, nu bee bedichiaꞌ nú aꞌchiꞌ unihua liñi niꞌihua, nuꞌ bene enu bixialí bedichiaꞌ cuaꞌ ante lu ye bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Liꞌihua bee bene enu rquietea, nia luhua nú la lliquihua bee bene enu niarquiꞌ nú uti liꞌihua. Xne titse bee bene nuꞌ modo nú uti cuerpoꞌhua, pero espírituꞌhua lecati riꞌchia ");
INSERT INTO zplNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero nia luhua nú ti rquiꞌña nú lliquihua: Ulliquihua Diose, xne liꞌinu rluꞌcunu nú rnibiyaꞌnu nu chenu uyuculanu nú nehuañihua, liꞌinu recanu xeꞌlanu espírituꞌhua ebila. Enzeꞌe ulliquihua liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Liꞌihua nediyaꞌhua nú bee iñi enu rcuecuꞌ la zeca beeí huaxi, pero Diose la zañiꞌ niꞌ tucu beeí. ");
INSERT INTO zplNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nu liꞌihua hasta ye bee ichia equiehua nebacuꞌ Diose. Enzeꞌe la lliquihua, xne másela secahua lunú seca huaxi bee iñi. ");
INSERT INTO zplNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Liꞌá nia luhua nú titse bene enu ni lubee bene nú necalla benea, leꞌca esquie liꞌá Bene enu uxeꞌla Diose nia lubee ángeleꞌnu nú necalla benea. ");
INSERT INTO zplNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero bene enu ni lubee bene nú la acalla benea, leꞌca esquie liꞌá nia lubee ángeleꞌ Diose nú la necalla benea. ");
INSERT INTO zplNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Nuꞌ perdonaꞌ titse bene enu ni condra liꞌá Bene enu uxeꞌla Diose, pero bene enu ni condra lu Espíritu Santo. Lecaꞌ perdona para bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Chenu uyaꞌ bee bene liꞌihua liñi bee indu, urre lubee juece, urre lubee usticia, la chenu arquiꞌhua xa cuaquihua lubeella cuna nú xa nihua. ");
INSERT INTO zplNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Xne chenu riña hora nú nihua, Espíritu Santo neca enu duꞌ arquiꞌhua xanihua. ");
INSERT INTO zplNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tucu bene enu nza leta bee bene zeꞌe uni lu Jesuse: ―Maestro, uniꞌ lu bichiaa nú liquiꞌi rencia nú rialaa. ");
INSERT INTO zplNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nu ucuaqui Jesuse lui: ―Niyu, ¿ti uni lulu nú neca juece urre tucu enu ritsiꞌ bee steneꞌhua? ");
INSERT INTO zplNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Leꞌca uninu lubeei: ―Ubiꞌyahua liꞌihua para nú la leꞌhua eluxene nú la luꞌcuhua, xne lecaxi zibiꞌ eluxene nú rluꞌcu bee bene, nu bee eluxene cuaꞌ la neca nucuaꞌ nú liquiꞌ nú nehuañi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chequie uni Jesuse tucu ejemplu lubeei: ―Uhuañi tucu bene xene, nu chiquiꞌ unguyuꞌ nú unguyuꞌ lu yuꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nu uquixie uriꞌilla elliebacuꞌ nú rnilla: “¿Xa riꞌá nee? La lucua elu ducheꞌa ulaꞌcua.” ");
INSERT INTO zplNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Che unilla: “Nediyalá xa riꞌá, chila bee niꞌi elu rducheꞌa bee ulaꞌcua, nu recheꞌa bee niꞌi nú llenelá. Zeꞌe ducheꞌa bee ulaꞌcua cuna ye beenú rluꞌcua. ");
INSERT INTO zplNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nu nia lu leꞌcatsia liꞌá: Nee sí rluꞌculu huaxi ulaꞌcu para huaxi lana, utsulachi nu udacu nu uhueꞌ nu ñia utsu arquiꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero uni Diose lulla: “Niyu chiquiꞌ netundulu, nee rulaꞌ quieꞌ atilu, nu beenú nuꞌcheꞌelu, ¿ti yaꞌnanuu bee nucuaꞌ che?” ");
INSERT INTO zplNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Scua seca bene enu rducheꞌ eluxeneꞌ para liꞌitsia, pero lu Diose lecaxi luꞌculla. ");
INSERT INTO zplNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Che uni Jesuse lubee beneꞌnu: ―Liꞌá nia luhua, nú la chenu arquiꞌhua nú xi acuhua para nú nze nehuañihua, leꞌca la chenu arquiꞌhua nú xi utuhua. ");
INSERT INTO zplNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nú nehuañi bene máse seca lunú racu bene, nu cuerpoꞌ bene máse seca lu xucu bene. ");
INSERT INTO zplNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ubiꞌyacuruhua bee bieca. La duꞌ beeí nii nu la quieteꞌ saꞌbeeí ulaꞌcu, nu la luꞌcu beeí elu chucheꞌ ulaꞌcuꞌ beeí, pero Diose lia rdeteꞌ nú racu beeí. Enzaláquieꞌ liꞌihua másela secahua lunú seca bee iñi. ");
INSERT INTO zplNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nu leꞌca, ¿xieꞌ equie nú tematsia chenu arquiꞌ bene nú xeelá huañilla la? ");
INSERT INTO zplNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nu tunu niꞌ nucuaꞌ la aca bene riꞌilla, ¿xiquie nú nzenu arquiꞌ bene equie nú xi aculla cuna beelá beenú xa nze nehuañilla che? ");
INSERT INTO zplNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ubiꞌyacuruhua xa rruꞌcu bee quie dañi, la riꞌi bee riñaꞌ, nu la recheꞌ bee laquie. Pero niꞌ arre Salomón lá tsucheꞌlla tucu nú nzucheꞌ bee quie añinzuca nú chiquiꞌ utsucheꞌella. ");
INSERT INTO zplNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Enzeꞌe, tunu bee huañi dañi sucheꞌ Diose nee, nu yeꞌe tsia nzula nu chiquine, ¡enza láquieꞌ liꞌihua nú la liquiꞌnu lunú utuhua, bene enu lleꞌna tsia nzeli arquiꞌ Diose bee lee! ");
INSERT INTO zplNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Enzeꞌe la chenzehua nu la chenu arquiꞌhua nú xi acuhua cuna nú xi hueꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Xne bee bene enu la chili arquiꞌ Diose, liꞌibeei neca beei enu nzenu arquiꞌ bee nucuaꞌ. Pero liꞌihua rluꞌcuhua tucu paꞌhua enu nzucu liñibe, nu liꞌinu nediyaꞌlaꞌnu lunú secalaꞌchaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pero uzelahua nú nibiyaꞌ Diose luhua che liquiꞌnu ye beenú secalaꞌchaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Bee benea, la lliquihua laca huaxihua, pero Paꞌahua Diose ñia nzu arquiꞌnu liquiꞌnu lunú rnibiyaꞌnu luhua. ");
INSERT INTO zplNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Utihua lunú rluꞌcuhua, nu uriꞌihua elietsa lubee bene enu seca elitsi. Ucuaꞌnahua nú riꞌihua ana eluxene liñibe nú leca xunga laxu, elu la chuꞌu huanaꞌ niꞌ bee belalaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Xne elu nuꞌcheꞌe eluxeneꞌhua zeꞌetsia nzu elliebacuꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Ucuaꞌa tsiñahua, nu uriꞌihua tucu nú riala riꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Uriꞌihua tucu nú rriꞌi bee mosoꞌ enu nucuaꞌaquiee chenu benchilaꞌ patronꞌbeei, nú nzalla lu tucu tsaꞌa para nú chu xaꞌla beei ruꞌu puerta chenu chichilla ruꞌu puerta. ");
INSERT INTO zplNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ñia neca lu cuendaꞌ bee mosoꞌ enu nucuaꞌa naa nu nucuaꞌa quiee nú benchilaꞌ patronꞌ beei. Xne nia luhua nú leꞌca liꞌi patronꞌ beei cuaꞌa liꞌibeei lu mexa nu chu cheꞌella xuculla para nú deteꞌlla nú acu beei. ");
INSERT INTO zplNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ñia neca lu cuendaꞌ beei tunu llunaꞌ patronꞌ beei liꞌibeei nú nucuaꞌa naa beei, mase nú riñalla ulelaꞌ rulaꞌ urre riñalla elliecabe. ");
INSERT INTO zplNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Leꞌca uriꞌihua beyaꞌ, tunu nediyaꞌ tucu bene nú xiura riña huanaꞌ niꞌilla, la zelalla nú chuꞌu huanaꞌ zeꞌe cachiꞌ bee steneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Leꞌca ucuaꞌa tsiñahua xne liꞌá Bene enu uxeꞌla Diose, riñaa chenu la riꞌihua elliebacuꞌ nú riñaa. ");
INSERT INTO zplNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chequie unidichiaꞌ Pedro lu Jesuse nú unilla: ―¿Unilu ejemplu cuaꞌ lu liꞌitsiaru la? u ¿Unilu nucuaꞌ lu ye bee bene la? ");
INSERT INTO zplNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nu uni Jesuse: ―Unia ejemplu cuaꞌ lu titse bene enu saꞌalu stichiaꞌ nu rriꞌilla tucu nú rialane. Tucu nú rriꞌi tucu mosoꞌ enu riaꞌnanuu niꞌi patronꞌ para nú deteꞌlla nú acu beelá bee mosoꞌ chenu riña hora nú acu bee nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ñia neca lu cuendaꞌ mosoꞌ enu rriꞌi tucu nú rialane chenu riña zeca patronꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Xne nia luhua nú tsaꞌna patrón zeꞌe ye bee steneꞌlla para nú yaꞌna cuendaꞌ mosoꞌ zeꞌe bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero tunu riꞌi mosoꞌ zeꞌe elliebacuꞌ nú rleꞌlá nú riña patrónꞌlla, che quixiella nú xitserinulla beelá bee mosoꞌ cuna bee criada. Nu quixiella nú acutsialla cuna nú hueꞌtsialla hasta nú lluchiꞌlla, ");
INSERT INTO zplNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","chequie riña patrónꞌlla tucu bichia nú la zucuꞌlla, nú riña patron zeꞌe tucu hora nú la riꞌlla beyaꞌ. Che chiquiꞌ juerte deteꞌ patrón zeꞌe castiya liꞌilla, nu xeꞌla patron zeꞌe liꞌilla elu riala bee bene enu la zucuꞌ nú rni bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Xne mosoꞌ enu nediyaꞌ nú xa niarquiꞌ patrónꞌlla nú riꞌilla pero la tsu tsiñalla, nu leꞌca la zucuꞌlla stichiaꞌ patrónꞌlla, liꞌilla rialalla castiya nú chiquiꞌ juerte. ");
INSERT INTO zplNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero mosoꞌ enu la riꞌi beyaꞌ xa niarquiꞌ patrónꞌ nú riꞌi, nu rriꞌilla tucu nú yalalla castiyaꞌlla, zecalla castiyaꞌlla pero menola. Enzeꞌe bene enu lia udeteꞌ Diose huaxi lunú recalla, rquiꞌña nú máse riꞌilla lunú udeteꞌ Diose lunú recalla. Leꞌca esquie bene enu lia udeteꞌ Diose nú rnibiyaꞌ rquiꞌña nú máse riꞌilla equie nú udeteꞌ Diose nu rnibiyaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Liꞌá nzela lu iliulabe xi neca tucu quii, nu alaꞌ recala lunú nzu nú aca. ");
INSERT INTO zplNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nzeꞌta nú chiquiꞌ nehuana zecaa nu nzula nú zeca scua, ¡nu desde nee chiquiꞌ nehuana nzu arquia hasta nú yalu ye bee nucuaꞌ! ");
INSERT INTO zplNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","La riꞌihua elliebacuꞌ nú tia uriña lu iliulabe para nú riꞌá nú aca tucunecatse arquiꞌ bee bene lu saꞌ beei. Xne equie nú chili arquiꞌ bee bene liꞌá leꞌe saꞌ bee bene cuna bee bene enu la chili arquiꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Xne desde nee elu nucuaꞌa ayuꞌ bene liñi tucu niꞌi, liunu chunalla cuna chiuculla, nu liunu chiuculla cuna chunalla. ");
INSERT INTO zplNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bee paa riꞌi condralla bee lliꞌñilla, nu bee lliꞌñilla riꞌi condra liꞌibeella. Leꞌca esquie bee naa riꞌi condra beella xinchiuꞌcu beella nu xinchiuꞌcu beella riꞌi condra liꞌibeella, nu bee suegra riꞌi condralla bee llixilla, nu bee llixilla riꞌi condra liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chequie uni Jesuse lubee bene: ―Chenu rlañiꞌhua nú rliñi xcabe enza ratseꞌ bichia, che rnihua nú laca quiu nu rlaca quiu. ");
INSERT INTO zplNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nu chenu rlañihua nú xiuꞌu bii enza sur, che rnihua nú aca nelee nu esquie recae. ");
INSERT INTO zplNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bene enu niquichiaꞌ bee lee. Rriꞌihua beyaꞌ xa neca bee seña liñibe cuna lu iliulabe, nu ¿xiquie nú la riꞌihua beyaꞌ xa neca lunú reca nee? ");
INSERT INTO zplNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Xiquie nú la riꞌihua elliebacuꞌ leꞌca liꞌitsiahua ta nú neca nzeꞌca riala nú riꞌi bene? ");
INSERT INTO zplNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tunu nuꞌ enu nze deteꞌ cuenda liꞌilu lubee usticia, nu llaꞌcalu liꞌilla labe inziu chenu nzalálu lubee usticia ucuaꞌna nú tsúcheꞌlu nucuaꞌ cuna liꞌilla ante nú riñalu lubee usticia. Xne tunu riñalu lu enu hualue lu cuendaꞌlu, che deteꞌ cuenda nzeꞌe liꞌilu lubee sundado nu duꞌ beei liꞌilu niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Liꞌá nia lulu, nú la chiuꞌulu niꞌcuꞌ hasta nú ixiulu ye nú nacuꞌ juece lulu. ");
INSERT INTO zplNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bee bichia zeꞌe, uya chiucu chuna bee bene lu Jesuse, nu ubedichiaꞌnu beei liꞌinu nú xa unibiyaꞌ Pilato nú unguti chiucu chuna bee bene Galilea, nu ucuchalla reneꞌ bee benecuaꞌ cuna reneꞌ bee nañi enu unguti beei xi neca uꞌna lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nu uni Jesuse lubeei: ―La riꞌihua elliebacuꞌ nú bee bene Galilea cuaꞌ, equie nú másela rluꞌcu beei dula lu ye bee bene Galilea enzeꞌe ulleꞌca beei scua. ");
INSERT INTO zplNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Liꞌá nia luhua nú la acane scua, nu tunu la tsanaꞌ arquiꞌhua stulahua, leꞌca nitiluhua che. ");
INSERT INTO zplNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Leꞌca la riꞌihua elliebacuꞌ nú ye chiñuꞌ chechuna bee bene enu unguti chenu uzanaꞌ torre nú lee Siloé equie beei, másela rluꞌcu beei dula lubeelá bee bene enu nucuaꞌa eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pero nia luhua nú la acane scua. Tunu la tsanaꞌ arquiꞌhua stulahua leꞌca nitiluhua. ");
INSERT INTO zplNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chequie uni Jesuse tucu ejemplu lubeei: ―Tucu bene uluꞌcu tucu aca higo lu yuꞌlla, nu uyabiꞌyalla tunu nuꞌ higo lu aca zeꞌe, pero né llelaꞌlla niꞌ tucu higo lu aca zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nu unilla lu bene enu rriucu lu yuu zeꞌe: “Ubiꞌyacuru necala chuna lana seidu nú nzela cuaꞌna higo lu aca quieꞌ, pero leca xunga xela niꞌ tucu higo lue. Mejora uchieꞌcuꞌe xne rriꞌixiꞌitsiae lu yua.” ");
INSERT INTO zplNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero bene enu rriucu yuu zeꞌe necachi ucuaquilla nú unilla: “Detá, utsaꞌnascaꞌe lana quietsia, liꞌá leꞌa yuu rquiꞌi nu duꞌa abonoe, ");
INSERT INTO zplNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","biꞌya se tunu scua ayu ndixí lue, nu tunu la ayu ndixí lue, che chu chiecune.” ");
INSERT INTO zplNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tucu bichia nú sulachi bee bene Israel, chenu seteꞌ Jesuse Stichiaꞌ Diose liñi tucu induꞌ bee bene Israel, ");
INSERT INTO zplNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","zeꞌe nzucu tucu unaꞌa, nu necala chiñuꞌchechuna lana nú ritilla. Tucu benechiquiꞌ uriꞌi nú nzucu tucu luꞌu tetsuꞌlla nu leca modo nú lílla. ");
INSERT INTO zplNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Chenu ulañiꞌ Jesuse liꞌilla ubixianu liꞌilla nu uninu lulla: ―Unaꞌa, uyecaꞌlaꞌlu lu elichia nú secalu nee. ");
INSERT INTO zplNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chequie uricuꞌnu yanu equiella nu hora zeꞌe ulí tetsuꞌlla, nu uquixiella unilla bedichiaꞌ nzeꞌca lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero chiquiꞌ ulee bene enu rnibiyaꞌ liñi indu zeꞌe, nú uriꞌiyeca Jesuse unaꞌa zeꞌe bichia nú sulachi bee bene, nu uni bene zeꞌe: ―Nuꞌ xuꞌcu bichia para nú riꞌi bee bene riñaꞌ, bee bichia cuaꞌ yeꞌtahua para nú yecaꞌhua, pero la yeꞌtahua bichia nú sulachi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Chequie ucuaqui Jesuse nú uninu: ―Liꞌihua necahua bene enu nequichiaꞌ, xne liꞌihua rriꞌihua riñaꞌ bichia nú sulachi bee bene. ¿Xieꞌ la laꞌahua uꞌnahua, urre burroꞌhua para nú hueꞌí inza bichia nú sulachi bee bene la? ");
INSERT INTO zplNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nu unaꞌa quieꞌ nzeꞌta lu familiꞌ tuxie Abraham, nu necala chiñuꞌ chechuna lana nú uriꞌi bezeꞌlu nú secalla elichia cuaꞌ, ¿xieꞌ leca modo nú riꞌiyecaa unaꞌa quieꞌ bichia nú sulachi bee bene la? ");
INSERT INTO zplNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chenu uninu bee bedichiaꞌ cuaꞌ, ye bee bene enu ulee lunu chiquiꞌ utuꞌ beei. Pero beelá bee bene ñia utsu arquiꞌbeei equie ye bee milagro nú uriꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Leꞌca uni Jesuse lubeei: ―¿Xa nia luhua para nú riꞌihua beyaꞌ xa neca lunú rnibiyaꞌ Diose urre xi lubea luhua para nú riꞌi nzeꞌcahua beyaꞌ xa necane? ");
INSERT INTO zplNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Necane xi neca tucu ebichiꞌ mestaza nú rquienii bene lu yuꞌlla, nu rruꞌcue hasta nú recae xi neca tucu aca llene, nu rrecheꞌe bee iñi exliaꞌtseꞌ beeí lu ellutsa lue. ");
INSERT INTO zplNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Leꞌca unilá Jesuse lubeei: ―¿Xa nia luhua para nú riꞌihua beya lunú rnibiyaꞌ Diose? ");
INSERT INTO zplNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Necane xi neca levadura nú rcucha tucu unaꞌa chuna medida harina, xne añinzuca nú temeꞌtsia levadura pero rriꞌi nú sebichi ye ecucu harina zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Chenu nza Jesuse enza Jerusalén, uzeteꞌnu bee bene lubee eyeche cuna lubee ranchu elu udetenu. ");
INSERT INTO zplNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Che necachi unedichiaꞌ tucu bene lunu: ―¿Detá, lleꞌnatsia bee bene enu tsilaꞌa la? Nu ucuaquinu: ");
INSERT INTO zplNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Uriꞌihua juerza nú chuꞌuhua ruꞌu puerta elu nuxuꞌ, xne nia luhua nú nuꞌ huaxi bee bene enu niarquiꞌ nú chuꞌu zeꞌe, pero la riꞌi beei ana nú chuꞌu beei zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Xne chenu tsulí bene enu neca lluanaꞌ niꞌi zeꞌe para nú tsacuꞌlla ruꞌu puerta, nu liꞌihua enu uyaꞌna nucuaꞌa eliꞌyaꞌ chichihua ruꞌu puerta nu nihua: “Uxaꞌla ruꞌu puerta para nú chuꞌuru.” Pero liꞌilla nilla luhua: “La riꞌá beyaꞌ cá enza nzeꞌtahua.” ");
INSERT INTO zplNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chequie quixiehua nú nihua: “Liꞌiru udaꞌcuru nu udiyaꞌru cuna liꞌilu, nu uzeteꞌlu liꞌiru lachiru.” ");
INSERT INTO zplNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero liꞌilla nilla luhua: “Unilá luhua nú la riꞌá beyaꞌ ca enza nzeꞌtahua. ¡Ullunaꞌhua lua caꞌa liꞌihua enu necha rriꞌi!” ");
INSERT INTO zplNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Zeꞌe unaꞌhua nu acuxaꞌ layahua, chenu lañiꞌhua Abraham, cuna Isaac, cuna Jacob cuna ye bee profetaꞌ Diose enu nucuaꞌa elu rnibiyaꞌnu, nu liꞌihua uyaꞌnahua eliꞌyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Xne nzeꞌta bee bene diqui lu iliulabe, bee bene enu nzeꞌta enza norte, cuna bee bene enu nzeꞌta enza sur, cuna bee bene enu nzeꞌta enza este, cuna bee bene enu nzeꞌta enza oeste, para nú cuaꞌa beei acu beei elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chequie huaxi bee bene enu la neca equie nee, aca bee nzeꞌe enu aca neca equie bichia zeꞌe, nu bee enu neca equie nee, aca bee nzeꞌe enu la aca neca equie bichia zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hora zeꞌe uriña chiucu chuna bee fariseo lu Jesuse nu unibeei lunu: ―Uquia enza rene, xne niarquiꞌ arre Herodes uti liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero ucuaquinu lubeei: ―Uquiahua nu uniꞌhua lu enu sequienu cuaꞌ: “Ubiꞌyacuru nee nu yeꞌe, liꞌá rlua bee benechiquiꞌ arquiꞌ bee bene cuna nú rriꞌiyeca bee bene enu riti, nu detetsia yeꞌe laꞌxua.” ");
INSERT INTO zplNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero rquiꞌña nú nze riꞌá seidu inziua nee nu yeꞌe nu detetsia yeꞌe, xne leca modo nú ati tucu profeta stucu eyeche enza rene lu eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Bee bene Jerusalén, bee bene Jerusalén, liꞌihua ruutihua bee profeta, nu rduꞌhua quiee bee Bene enu uxeꞌla Diose luhua. Huaxi bese uniarquia nú quietesaꞌahua tucu nú rquieteꞌsaꞌ lliꞌti tiꞌñiꞌí liñi cuacaí pero né zelahua. ");
INSERT INTO zplNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Enzeꞌe nia luhua nú enta bichia nú tsanaꞌ arquiꞌ Diose lachihua. Leꞌca nia luhua nú lecaꞌ bichia nú lañiꞌhua liꞌá, hasta nú riña bichia nú nihua. Ñia nzeꞌta liꞌinu enu nzeꞌta equie cuendaꞌ Paꞌahua Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tucu bichia nú sulachi bee bene Israel, uya Jesuse udacucheca niꞌi tucu fariseo enu rnibiyaꞌ, nu texcuaꞌa beei nucuaꞌa tsiꞌña liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chequie lunu zeꞌe, nzu tucu niyu enu nuꞌ quii diqui beꞌlaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nu unidichiaꞌ Jesuse lubee ulaxcuela enu reca ley Moisés cuna lubee fariseo nu uninu: ―¿Nuꞌ modo riꞌiyeca tucu bene enu riti bichia nú sulachi bee bene la? urre ¿leca modue la? ");
INSERT INTO zplNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero lecalí xi ucuaqui beella, chequie uricuꞌnu yanu equie niyu enu riti zeꞌe, nu uriꞌiyecanu liꞌi nu uninu lui nu yai. ");
INSERT INTO zplNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chequie uninu lubee fariseo: ―Tunu zanaꞌ tucu burroꞌhua urre tucu uꞌnaꞌhua liñi tucu iꞌchiu bichia nú sulachi bee bene, ¿xieꞌ la chehuahuaí hora zeꞌe la? ");
INSERT INTO zplNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero lecaxi ullela arquiꞌbeella acuaqui beella lunu. ");
INSERT INTO zplNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chenu ulañiꞌ Jesuse nú rlaꞌna bee bene enu nezeneꞌ lu tsaꞌa zeꞌe elu neca equie cuaꞌa beei. Che uninu lubeei: ");
INSERT INTO zplNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Chenu seneꞌ bene liꞌilu chalu lu tsaꞌa chia, la zuculu luhuare elu mase neca equie, xne tunu riña stucu bene enu nezeneꞌ enu masela neca equie lulu, ");
INSERT INTO zplNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","che bene enu uzeneꞌ rucuhua, nzeꞌtalla nu nilla lulu: “Udeꞌteꞌ elu nzuculu zucu benequieꞌ.” Chequie yaꞌna netúlu tsulílu luhuare zeꞌe, nu zuculu hasta último xleta. ");
INSERT INTO zplNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Enzeꞌe chenu seneꞌ tucu bene liꞌilu lu tsaꞌa zucu lu xleta nú nzu hasta último, para nú chenu nzeꞌta bene enu uzeneꞌ liꞌilu nu nilla lulu: “Amigo, utee caꞌa zuculu elu máse neca equie.” Nu scua zucuꞌ aya beei liꞌilu lubee bene enu nucuaꞌa lu mexa cuna liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Xne enu sucuꞌ aya leꞌcatsia liꞌi, aca lleꞌna nzeꞌe, nu enu reca lleꞌna zucuꞌ aya bee bene liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chequie uni Jesuse lu bene enu uzeneꞌ liꞌinu: ―Chenu seneꞌlu bee bene nú acucheca beei urre nú acuxee beei, la zeneꞌlu bee bene enu rquieteꞌlu, niꞌ bee bichilu, niꞌ bee familiꞌlu, niꞌ bee besiñuꞌlu enu neca xene. Xne leꞌca tucu bichia zeneꞌ beella liꞌilu niꞌ beella, nu scua ixiu beella lunú udacu beella niꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mejora chenu rriꞌilu tucu eliñi, zeneꞌlu bee bene enu seca elitsi, cuna bee bene enu neca mangu, cuna bee bene enu necuxu, cuna bee bene enu niquieꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Che ñia nza lu cuendaꞌlu, xne añinzuca nu la guseaꞌ beei nucuaꞌ lulu. Pero Diose neca enu guseꞌe nucuaꞌ lulu bichia nú huañi zeca bee bene enu neli uriꞌi tucu nú necane lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chenu ubeneꞌ tucu bene enu nzucu lu mexa cuna Jesuse nucuaꞌ, unilla lunu: ―Ñia nza lu cuendaꞌ bene enu riala acu pá elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Che uni Jesuse lui: ―Tucu niyu uriꞌilla elliebacuꞌ nú deteꞌlla tucu exee llene para nú acu xee bee bene, nu uzeneꞌlla huaxi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chequie chenu uriña horaꞌ exee, uxeꞌla bene zeꞌe mosoꞌlla nze ni lubee bene enu uzeneꞌlla para nú yeꞌta beei xne necalula exee. ");
INSERT INTO zplNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero ye bee bene zeꞌe uquixie beei nú unacuꞌ beei disculpa lulla nu uni tucui: “Uniꞌi lu benecuaꞌ nú riꞌilla disculpa liꞌá, xne apenatsia utsia tucu yuu nu rquiꞌña nú nzebiꞌyane.” ");
INSERT INTO zplNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Stucui uni: “Apenatsia utsia ayuꞌ inza uꞌnaꞌ, nu rquiꞌña nú nze riꞌá preo beeí biꞌya xa rriꞌi beei riñaꞌ. Uniꞌ lu benecuaꞌ nú riꞌilla disculpa liꞌá.” ");
INSERT INTO zplNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Stucui uni: “Liꞌá apenatsia uchiaa. Enzeꞌe leca modo nú tsea nee.” ");
INSERT INTO zplNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Chenu ubenchilaꞌ mosoꞌ zeꞌe udixiuleꞌella lu patrónꞌlla ye lunú unga. Chequie ulee patrón zeꞌe, nú unilla lu mosoꞌlla: “Uquia yexetsia lu eyeche cuaꞌ lubee inziu llene cuna lubee inziu llaꞌna, uteyuu bee bene enu seca elitsi, cuna bee bene enu neca mangu, cuna bee bene enu necuxu, cuna bee bene enu niquieꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chenu ulaxu nú uriꞌi mosoꞌ zeꞌe scua, necachi unilla lu patrónꞌlla: “Uriꞌilá tucu nú unibiyaꞌlu nú riꞌá, pero nuꞌscaꞌ luhuare elu cuaꞌa bee bene.” ");
INSERT INTO zplNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Che uni patrón zeꞌe lu mosoꞌlla: “Uquia lubee calle cuna lubee inziu. Uriꞌi Juerza bee bene enu llaꞌcalu zeꞌe, nú yeꞌta beei nia para nú cheene. ");
INSERT INTO zplNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Xne nia lulu nú niꞌ tucu bee bene enu rluti uzenea la acu exee nú uriꞌilua.” ");
INSERT INTO zplNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Huaxi bee bene uyaquie Jesuse, nu ubelletanu nú uninu lubeei: ");
INSERT INTO zplNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tunu nuꞌ enu niarquiꞌ nú yeꞌta quie liꞌá, rquiꞌña nú másela zecalla liꞌá lunú secalla paꞌlla, naꞌlla, unaꞌalla, enduꞌlla, bichilla, zanalla, nu rquiꞌña nú másela zecalla liꞌá lunú secalla lunú nehuañilla. Tunu la riꞌilla scua leca modo nú acalla benea. ");
INSERT INTO zplNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nu bene enu entaquie liꞌá nu la niarquiꞌlla nú nehuana zecalla equie cuendaꞌ liꞌá, leca modo nú acalla benea. ");
INSERT INTO zplNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tunu tucuhua niarquiꞌ nú recheꞌe tucu niꞌi nzeꞌca, ¿xieꞌ la zuculla nu rluti riꞌilla elliebacuꞌ calu yalu gasto nú acacheꞌ niꞌi zeꞌe nu tunu riquiꞌ dimiꞌlla laꞌxulla recheꞌellae la? ");
INSERT INTO zplNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Xne tunu recheꞌtsialla puro simienduꞌ niꞌi nu la laꞌxulla recheꞌella diquine, che ye bee bene enu lañiꞌ nucuaꞌ tsequichiaꞌ liꞌilla, ");
INSERT INTO zplNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nu ni bee bene: “Benequieꞌ uquixie rrecheꞌ niꞌi pero lá laꞌxulla a recheꞌellae xne la riquiꞌ dimiꞌlla.” ");
INSERT INTO zplNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nu tunu tucu arre niarquiꞌ riꞌi xuu cuna stucu arre, ¿xieꞌ la zuculla rluti riꞌilla elliebacuꞌ tunu riquiꞌ chiꞌi mili bee sundadoꞌlla riꞌi xuu cuna ala mili bee sundadoꞌ stucu arre la? ");
INSERT INTO zplNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pero tunu riꞌilla beyaꞌ nú la riꞌilla ana lu arre zeꞌe, chequie ante nú riña arre zeꞌe lulla, xeꞌlalla chiucu chuna bee beneꞌlla para nú ni bee nzeꞌe lu arre zeꞌe nú tsuxee xuu para nú scua huañi beei sin xuu. ");
INSERT INTO zplNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Leꞌca esquie tatse bene enu la tsaꞌna ye bee steneꞌlla nú rluꞌculla, leca modo nú acalla benea. ");
INSERT INTO zplNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Zete neca nzeꞌcae. Pero tunu niti nú neriꞌi, ¿xa sibiꞌ zecae stucu bese che? ");
INSERT INTO zplNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","La zibiꞌi niꞌ nú riꞌchiane leta yuu nu niꞌ nú acane abono, tiꞌchiatsia bee benene. Enu niarquiꞌ nú yeneꞌ, quieꞌe diaca nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ye bee bene enu rriꞌi cubre equie bee impuesto cuna bee bene enu rluꞌcu dula, uyabica beei lu Jesuse para nú yeneꞌ beei lunú rninu. ");
INSERT INTO zplNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chequie bee fariseo cuna bee ulaxcuela enu reca leyꞌ Moisés, uquixie beei nú seꞌta beei Jesuse nú unibeei: ―Benequieꞌ rquieteꞌ bee bene enu rriꞌi dula nu racunulla bee benecuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Che uni Jesuse ejemplu quieꞌ lubeei: ");
INSERT INTO zplNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tunu nuꞌ tátucuhua rluꞌcu tucu ayuꞌu sanchi nu nitihua tucui, ¿xieꞌ la tsaꞌnascaꞌlla noventa y nueve bee sanchi zeꞌe dañi nu che cuaꞌnalla sanchi enu uniiti hasta nú llelaꞌllaí la? ");
INSERT INTO zplNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nu chenu ullelaꞌllaí, ñia nzu arquiꞌlla uricuꞌllaí añilla. ");
INSERT INTO zplNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Chequie chenu riñalla niꞌlla quieteꞌsaꞌlla bee bene enu rquieteꞌlla cuna bee besiñuꞌlla, nu nilla lubee bene zeꞌe: “Ñia utsu arquiꞌhua cuna liꞌá, xne ullelalá sanchia enu uniti.” ");
INSERT INTO zplNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nee nia luhua, nú leꞌca scua nuꞌ nú ñia nzu arquiꞌ liꞌi beenu enu nucuaꞌa liñibe chenu tsanaꞌ arquiꞌ tucu bene stulalla luquela se noventa y nueve bee bene enu neli neca enu la quiꞌña nú cheꞌe arquiꞌ lu stula. ");
INSERT INTO zplNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Leꞌca esquie tunu tucu unaꞌa enu rluꞌcu chiꞌi melu plata nu nitilla tucue, ¿xieꞌ la quieꞌella quii nu lucuꞌlla liñi niꞌlla nu cuaꞌnalla dimiꞌlla xuxuu hasta nú llelaꞌllae la? ");
INSERT INTO zplNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nu chenu llelaꞌlla dimiꞌlla, quieteꞌsaꞌlla bee unaꞌa enu rquieteꞌlla cuna bee besiñuꞌlla, nu nilla lubee nzeꞌe: “Ñia utsu arquiꞌhua cuna liꞌá xne ullelalá dimia nú unitia.” ");
INSERT INTO zplNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nee nia luhua, leꞌca scua ñia nzu arquiꞌ bee ángeleꞌ Diose liñibe chenu tsanaꞌ arquiꞌ tucu bene stulalla. ");
INSERT INTO zplNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Leꞌca uni Jesuse stucu ejemplu lubeei: ―Tucu bene uluꞌcu chiucu llianaꞌ, ");
INSERT INTO zplNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","chequie uni llianaꞌlla enu lleꞌnalá lulla: “Paa uliꞌquiꞌ rencia nú rialaa.” Nu chu uritsiꞌ paꞌ beei bee renciaꞌlla lu rucu beei. ");
INSERT INTO zplNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xiucu xuna bichia lu zeꞌe llianaꞌlla enu lleꞌnalá ungüiti ye bee rencia nú uyucui. Che unguyaꞌi dimi cuaꞌ nzai enza istu elu ulaꞌxui yeene, xne uriꞌi ye nú niarquiꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pero chenu ulaxu dimiꞌi unga biñia elu nzucui, nu uquixie nú uriꞌi falta nú acui. ");
INSERT INTO zplNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nu chu uya naꞌcui riñaꞌ riꞌi niꞌ tucu bene enza zeꞌe, nu uxeꞌla bene zeꞌe liꞌi nú riꞌi ucui bee cuchi enza dañi. ");
INSERT INTO zplNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nu equie nú chiquiꞌ rliaꞌnaꞌi alaꞌ nú raculai beenú racu bee cuchi nú secai, pero lecati udeteꞌ nú udacui. ");
INSERT INTO zplNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Chequie uriꞌi elliebacuꞌ nú uni: “¡Niꞌ paa nucuaꞌa huaxi bee mosoꞌ nu hasta nú sucu sobra nú racu beei, nu liꞌá nzucuaꞌa caꞌa ya mero atia nú rliaꞌnaa! ");
INSERT INTO zplNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nee benchilaꞌ zecaa niꞌ paa nu nia lunu: Paa, uriꞌila dula lu Diose nu uriꞌila dula lulu, ");
INSERT INTO zplNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","la yalaꞌ nú nilu lua nú neca llianaꞌlu. Uriꞌitsia lua xi neca tucu mosoꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chequie uyuꞌu nziui nu ubenchilaꞌ zecai niꞌ paꞌi. ’Pero chenu nzeꞌtascaꞌi istu ulañiꞌ paꞌi liꞌi, nu uhuaꞌa arquiꞌlla liꞌi. Che uyaxuꞌulla uchaꞌcalulla liꞌi, nu uchiꞌchilla liꞌi nu udaculla bichiuꞌ xecai. ");
INSERT INTO zplNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nu chu uni lu paꞌi: “Paa uriꞌila dula lu Diose, nu uriꞌila dula lulu, la yalaꞌ nú nilu lua nú neca llianaꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero chu uni paꞌi lubee mosoꞌlla: “Yexetsia uquia chiyaꞌhua laquie nú máse rnaa nzeꞌca utuꞌhua llianaꞌa, nu uduꞌhua tucu biꞌi cuenei nu quieꞌehua subatu cuchiuꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nu uteyuhua tucu becerro enu máse neruꞌcu nu útihuaí para nú daꞌcuaꞌahuaí, nu riꞌahua tucu eliñi. ");
INSERT INTO zplNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Xne para liꞌá ungutila llianaꞌa ninguieꞌ, nu uhuañi zecai. Uniiti, pero ullela zecai.” Nu uquiexie beella nú rriꞌi beella eliñiꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Diqui nú nucuaꞌa beella esquie, llianaꞌ rluꞌlla nzuscaꞌi dañi. Chequie chenu ubenchilaꞌi nú nzeꞌta riñai axu niꞌbeella, chenu ubeneꞌi nú rula bee musica nu rieꞌe beella, ");
INSERT INTO zplNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chequie ubixiai tucu mosoꞌ niꞌbeella nu unidichiaꞌi lu nzeꞌe nú xi reca niꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nu uni mosoꞌ zeꞌe lui: “Nú ubenchilaꞌ zeca bichilu nu unibiyaꞌ paꞌlu nú unguti becerro enu máse neruꞌcu xne uriña nzeꞌcai nu uriña naaquii.” ");
INSERT INTO zplNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pero chiquiꞌ ulee llianaꞌ rluꞌlla nzeꞌe nu la zelai chuꞌi niꞌi, che chu uchiuꞌu paꞌi uya ziquie lui para nú chuꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Che uni lu paꞌi: “Liꞌilu nediyaꞌlu xala lana rriꞌá riñaꞌ cuna liꞌilu, nu leca xunga unga nzitia lulu, nu leca xunga ubiquiꞌlu masia tucu chipa llaꞌna para nú riꞌá tucu eliñi cuna bee enu rquietea. ");
INSERT INTO zplNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero nee nú uriña llianaꞌlu ninguieꞌ, enu uya laꞌxu dimiꞌlu cuna bee unaꞌa huexe. Para liꞌi sí unibiyaꞌlu nú unguti becerro enu máse neruꞌcu.” ");
INSERT INTO zplNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Che uni paꞌi lui: “Llianaꞌa liꞌilu nzuculu cuna liꞌá ye bichia, nu ye nú rlucua neca steneꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero nee rquiꞌña nú aca tucu eliñi cuna nú ñia tsu arquiaꞌahua, xne para liꞌá neca xi neca nú unguti bichilu nu nee uhuañi zecai, unitii, nu ullelaꞌ zecaꞌahuai.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Leꞌca uni Jesuse lubee beneꞌnu: ―Uhuañi tucu bene xene, nu uluꞌculla tucu mosoꞌlla enu uyaꞌnanu ye bee steneꞌlla, cheela uyatixiuleꞌe bee bene lulla nú lia rlaꞌxu mosoꞌ zeꞌe ye bee steneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nu chu ubixialla mosoꞌ zeꞌe nu unilla lui: “¿Xa neca lunú rni bee bene lu cuendaꞌlu scua? Uliꞌquiꞌ cuenda beenú rriꞌilu, xne la liquiaꞌa riñaꞌ riꞌilu.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chequie uquixie mosoꞌ zeꞌe nú rriꞌi elliebacuꞌ: “¿Xa riꞌá nee nu la liquiaꞌ patrónꞌa riñaꞌ riꞌá? Leca juerzaa para nú riꞌá riñaꞌ dañi, nu rtua nú nacua caridad. ");
INSERT INTO zplNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nediyala xa riꞌá para nú nuꞌ ti yucu liꞌá niꞌi chenu la luꞌcuaꞌa riñaꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Che ubixiai tucua tucua bene enu neziꞌqui lu patrónꞌi, nu uni lu enu uriña rluti: “¿Calu neziꞌquilu lu patronꞌa?” ");
INSERT INTO zplNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nu ucuaqui bene zeꞌe nú unilla: “Liꞌá neziꞌquia tucu ayuꞌu barrili aceite de olivo.” Che uni mosoꞌ zeꞌe lulla: “Nguie ichiꞌ nú uduꞌlu firma uzucu nu yexetsia ucheꞌe lunú neziꞌquilu, nu uzuꞌcuꞌ ichitsia nú neziꞌquilu cincuenta barrili aceite.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nu unedichiaꞌi lu stucu bene zeꞌe: “¿Calu neziꞌquilu lu patrónꞌa?” Nu uni bene zeꞌe lui: “Tucu ayuꞌu medida trigo.” Che uni lu bene zeꞌe: “Nguie ichiꞌ nú uduꞌlu firma. Ucheꞌe lunú neziꞌquilu nu uzuꞌcuꞌ ichitsia nú neziꞌquilu ochenta medidae.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chequie chiquiꞌ uyanu arquiꞌ patrón zeꞌe nú netsiña mosoꞌ enu necha neca esquie lunú uriꞌi. Neli nú mase netsiña bee bene enu la chequie inziuꞌ Diose cuna bee saꞌbeei, luquelá bee bene enu nzequie inziuꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Enzeꞌe nia luhua: “Nú uquiꞌñahua bee eluxene nú rluꞌcuhua lu iliulabe quieꞌ para nú riꞌihua elietsa lubee bene, nu scua nuꞌ enu yucu liꞌihua elu huañilíhua chenu laxu bee steneꞌhua.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Bene enu rriꞌi tucu nú rialane cuna lu lleꞌnatsia nú riaꞌnanulla, leꞌca rriꞌilla tucu nú rialane cuna lu huaxi nú riaꞌnanulla, nu bene enu la riꞌi tucu nú rialane cuna lu lleꞌna tsia nú riaꞌnanulla, leꞌca la riꞌilla tucu nú rialane cuna lu huaxi nú riaꞌnanulla. ");
INSERT INTO zplNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nee leꞌca scua tunu la riꞌihua tucu nú rialane cuna lubee eluxene nú nuꞌ lu iliulabe quieꞌ, ¿ti luꞌcu confianza luhua cuna bee eluxene nú nuꞌ liñibe che? ");
INSERT INTO zplNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nu tunu la riꞌihua tucu nú rialane cuna lunú la neca bee steneꞌhua, ¿ti liquiꞌ luhua lunú rialahua che? ");
INSERT INTO zplNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Niꞌ tucu mosoꞌ leca modo riꞌi riñaꞌ lu chiucu patrón, xne leei lu tuculla, nu stuculla zecai, urre riꞌi nzeꞌcai lu tuculla, nu lu stuculla la riꞌi nzeꞌcai. Enzeꞌe leca modo nú zibiꞌhua lu Diose nu tsu arquiꞌhua lu dimi. ");
INSERT INTO zplNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nu lunú máse rleꞌ bee fariseo dimi, chequie chenu ubeneꞌ beei nú uni Jesuse scua uquixie beei nú uzeꞌta beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nu uni Jesuse lubeei: ―Liꞌihua rriꞌihua nú necahua xi neca bene nzeꞌca lubee bene. Pero Diose nuꞌlu xa nchiñi arquiꞌhua. Mase rriꞌihua ana nú nzeli arquiꞌ bee bene nú necahua enu neca equie, pero lu Diose lecati necahua. ");
INSERT INTO zplNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Hasta chenu ubeꞌta Juan Bautista. Nuꞌla leyꞌ Moisés cuna bee bedichiaꞌ nú uquieꞌe bee profeta, pero hasta che uquixie nú udixiuleꞌe bee bene nú xa neca lunú rnibiyaꞌ Diose, nu huaxi bee bene rriꞌi juerza nú chuꞌu elu rnibiyaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Másela fácil nú nitilu liñibe nu lu yuu, pero la dete nú yalu niꞌ tucu bedichiaꞌ nú nzeꞌta lu leyꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Tunu tucu niyu leꞌi unaꞌi nu yucui stucu unaꞌa, riꞌi dula, nu leꞌca tunu yucu tucu bene unaꞌa enu uleꞌe niyuꞌ, leꞌca riꞌi nzeꞌe dula che. ");
INSERT INTO zplNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Uhuañi tucu bene xene nu chiquiꞌ utsucheꞌella cuna bee laquie fiñu nú ñia rnaa nu ye bichia rriꞌilla nú neca xi neca tucu eliñi niꞌilla, equie nú chiquiꞌ necalla bene xene nu racu nzeꞌcalla. ");
INSERT INTO zplNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Leꞌca uhuañi tucu bene elitsi enu lee Lázaro, nu diqui beꞌlaꞌlla nchiucuꞌ bechuꞌ nú ruchulu nu suculla ruꞌu niꞌ bene xene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Niarquiꞌ Lázaro cuaꞌ nú aculla masia bee ube nú sanaꞌ liñi mexaꞌ bene xene zeꞌe, nu hasta bee nicu rriña rñieꞌe lu beechuꞌ nú nchiucuꞌ liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Chenu uriña bichia nú unguti Lázaro, nu unguyaꞌ bee ángeleꞌ Diose liꞌilla liñibe elu nzucu Abraham. Nu leꞌca unguti bene xene zeꞌe, nu ucachiꞌ bee bene liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Diqui nú nehuana seca bene xene zeꞌe nchiñi ebila, uletsai lui nu istu ulañiꞌi Lázaro nzu cuna Abraham. ");
INSERT INTO zplNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nu urixialii nú uni: “¡Paa Abraham, uhuaꞌa arquiꞌ liꞌá! Uxeꞌla Lázaro nú cuachai lliꞌi cuene yai para nú yeꞌtai nu riꞌi nú aꞌlaꞌ luꞌchia, xne chiquiꞌ nehuana seꞌca nchiñia lu quii quieꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero ucuaqui Abraham lu bene xene nú unilla: “Lliꞌñia ulluꞌcu arquiꞌ nú chiquiꞌ ñia uhuañilu lu iliulabe, nu Lázaro nehuana uhuañii. Pero nee rialai elu ñia tsu arquiꞌi, nu liꞌilu rialalu elu nehuana zecalu.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nu leꞌca nia lulu: “Nú arliꞌtiꞌ nuꞌ tucu errubee llene. Enzeꞌe niꞌ tucu bee enu nucuaꞌa caꞌa leca modo nú dete elu nzulu, nu niꞌ tucu bee enu nucuaꞌa elu nzulu leca modo nú yeꞌta caꞌa.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Chequie uni bene xene zeꞌe: “Ziquia lulu paa Abraham, uxeꞌla Lázaro niꞌ paa, ");
INSERT INTO zplNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","xne rlucua ayuꞌ bichia, para nú ixiuleꞌella lubeei nú la yeꞌta beei caꞌa elu chiquiꞌ nehuana seca bene.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Che uni Abraham lui: “Liꞌibeei rluꞌcu beei bee ichiꞌ nú uquieꞌe Moisés cuna beenú uquieꞌe bee profeta, mejora nú riꞌi beei caso lunú niquie lubee ichiꞌ cuaꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nu ucuaqui bene xene zeꞌe: “Leca modoe paa Abraham, pero tunu huañi zeca tucu bene enu unguti, nu lubeꞌlu nzeꞌe lubeei, che si tsanaꞌ arquiꞌbeei stula beei.” ");
INSERT INTO zplNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero uni Abraham lui: “Tunu la riꞌi beei caso stichiaꞌ Moisés cuna stichiaꞌ bee profeta, leꞌca la chili arquiꞌbeei mase nú huañi tucu bene enu unguti.” ");
INSERT INTO zplNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Uni Jesuse lubee beneꞌnu: ―Siempre nuꞌ beenú rriꞌi nú rriꞌi bee bene dula, pero ¡cueꞌ bene enu riꞌi nú riꞌi stucu bene dula! ");
INSERT INTO zplNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Máse neca nzeꞌca para bene zeꞌe nú llicaꞌcuu bene quie molino añilla nu tsiꞌqui beei liꞌilla lu inzatuꞌ, luhuare nú riꞌilla nú sanaꞌ bene lu dula enu apenatsia uyalí arquiꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Ubiꞌyahua liꞌihua! ’Tunu nuꞌ ta tucu enu rriꞌi dula, uriꞌihua nú quiꞌyalla, nu tunu cheꞌe arquiꞌlla lu dula nú uriꞌilla, uriꞌihua perdona liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mase achi bese tucu bichia riꞌilla urre nilla bee nú necha neca lulu, nu tunu achi bese leꞌca entalla nu nilla lulu uriꞌi perdona liꞌá: “La riꞌá scua stucu bese.” Rquiꞌña nú riꞌilu perdona liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Chequie uni bee beneꞌ Jesuse lunu: ―Uriꞌi elietsa luru para nú tsu tenelílá arquiꞌru lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nu ucuaqui Jesuse lubeella: ―Tunu nzu tenelí arquiꞌhua masia lleꞌna xi neca ebichiꞌ mestaza, nuꞌ modo nihua lu aca llene sicómoro quieꞌ: “Axi liꞌilu caꞌa nu uzucu lu inzatuꞌ”, che zucuꞌ aca cuaꞌ nú rnihua. ");
INSERT INTO zplNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Tucu ejemplu necane, tunu tucuhua rluꞌcu tucu bene enu neca esclavo luhua, nu riña nzeꞌe nú uya unguꞌna nzeꞌe uꞌnaꞌ urre uya nzeꞌe ucu nañi, ¿xieꞌ nihua lu nzeꞌe: “Uyuꞌu nu uzucu para nú acuxelu”? ");
INSERT INTO zplNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pero aꞌla nihua lu bene zeꞌe: “Ucheꞌe xuculu nu urecheꞌe nú acuxea nu yeꞌta yulue lua, diqui nú racua nu ruaꞌa hasta nú laꞌxua nú acua. Che nuꞌ modo nú aculu nu hueꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pero la deteꞌhua masia cheꞌtsa lu bene zeꞌe, xne rriꞌitsiai lunú unibiyaꞌhua lui nú riꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Leꞌca esquie liꞌihua, chenu laꞌxuhua nú riꞌihua ye nú unibiyaꞌ Diose nú riꞌihua, chequie nihua: “Necaru mosoꞌ enu la zibiꞌ, xne uriꞌitsiaru lunú neca cuendaꞌru nú riꞌiru.” ");
INSERT INTO zplNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Chenu nza Jesuse eyeche Jerusalén, udetenu lu iliu Samaria cuna lu iliu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nu chenu nze chuꞌunu tucu eyeche llaꞌna, uyachaꞌcalu chiꞌi bee niyu enu seca elichia nú lee lepra liꞌinu, pero istu ucuaꞌaxe beei lunu, ");
INSERT INTO zplNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","nu urixialibeei nú unibeei lunu: ―¡Maestro, Jesuse, uhuaꞌa arquiꞌ liꞌiru! ");
INSERT INTO zplNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chenu ulañiꞌ Jesuse liꞌibeei, uninu lubeei: ―Uquiahua ne lañiꞌ bee uleꞌya liꞌihua. Pero diquila nú nzuebeei uyecaꞌ beei elichia nú seca beei. ");
INSERT INTO zplNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Chequie tucu beei, chenu uriꞌi nzeꞌe beyaꞌ nú uyecaꞌlaꞌ nzeꞌe, ubenchilaꞌ nzeꞌe nu ubixialii nú uni bedichiaꞌ nzeꞌca lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nu utsulliquii lu Jesuse hasta nú udiꞌ tequiei lu yuu para nú udeteꞌi cheꞌtsa lunu, nu necai bene Samaria. ");
INSERT INTO zplNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Che uni Jesuse: ―¿Xieꞌlanú chiꞌi neca bene enu uriyeca la? ¿Ma sequie beei? ");
INSERT INTO zplNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Xieꞌ bene rene quieꞌtsia ubenchilaꞌ para nú ni bedichiaꞌ nzeꞌca lu Diose la? ");
INSERT INTO zplNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Che uni Jesuse lui: ―Utsuli, nu uquiaꞌa nee. Uyecaꞌlaꞌlu xne uchili arquiꞌlu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Unidichiaꞌ bee fariseo lu Jesuse xunga riña lunú rnibiyaꞌ Diose, nu ucuaquinu lubeella: ―Lunú rnibiyaꞌ Diose la neca nucuaꞌ nú lañiꞌhua chenu riñane. ");
INSERT INTO zplNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Lecati ni: “Nú caꞌa nzu lunú rnibiyaꞌ Diose”, urre “nguié nzuee”; xne lunú rnibiyaꞌ Diose nzula letahua nee. ");
INSERT INTO zplNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nu uninu lubee beneꞌnu: ―Riña bichia nú niarquiꞌhua nú lañiꞌhua liꞌá Bene enu uxeꞌla Diose masia tucu bichia pero la lañiaꞌhua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mase nuꞌ bee bene enu ni luhua: “Caꞌa nzucunu”, urre “nguié nzucunu”, pero la chequiehua beei. ");
INSERT INTO zplNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Xne tucu nú neca chenu riaꞌla lee nu riuꞌu llieꞌe enzichiuꞌ enzerquie, leꞌca scua aca chenu riña zeca liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero rluti rquiꞌña nú chiquiꞌ nehuana zecaa, nu huachu bee bene enu nucuaꞌa nee liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tucu nú unga tiembu nú uhuañi Noé, leꞌca scua aca bichia chenu riña zeca liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Xne tiembu zeꞌe, udacutsia bee bene nu ungueꞌtsia beei, nu uchia beei nu udeteꞌbeei xinchiuꞌcu beei uchia, hasta nú uriña bichia nú uyuꞌu Noé liñi barco llene nú urecheꞌella, nu uquixie nú ulaca tucu quiu juerte nu unguti ye beei. ");
INSERT INTO zplNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Leꞌca scua unga chenu uhuañi tucu bene enu lee Lot lu iliulabe: udacutsia bee bene nu ungueꞌtsia beei, cuna nú ruti beei nu si beei, nu rduꞌ beei nii nu rrecheꞌe beei bee niꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero chenu uchiuꞌu Lot eyeche Sodoma, uquixie nú ulaca quii enza liñibe cuna azufre, nu unguti ye beei. ");
INSERT INTO zplNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Leꞌca scua aca chenu riña zeca liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Bichia nú aca bee nucuaꞌ, bee bene enu nchiucuꞌ equie niꞌi la lluꞌchaꞌ chuꞌu beei liñi niꞌi beei para nú naꞌtse beei steneꞌ beei, nu bee bene enu nucuaꞌa dañi la lluꞌchaꞌ benchilaꞌ beei niꞌbeei para nú uyaꞌbeei steneꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ulluꞌcuꞌ arquiꞌhua xa ulleꞌca unaꞌa Lot. ");
INSERT INTO zplNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bene enu máse niarquiꞌ nú huañi lu iliulabe quieꞌ riña bichia nú laxu nucuaꞌ, pero bene enu ati equie cuendaꞌ liꞌá luꞌculla eluhuañilílla liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Liꞌá nia luhua nú rulaꞌ zeꞌe elu nucuaꞌa chiucu bene lu tucu luna, tuculla uya nu stuculla riaꞌna. ");
INSERT INTO zplNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nu elu nucuaꞌa chiucu unaꞌa riu, tuculla uya nu stuculla riaꞌna. ");
INSERT INTO zplNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nu elu nucuaꞌa chiucu niyu dañi, tucui uya nu stuculla riaꞌna. ");
INSERT INTO zplNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chenu ubeneꞌ bee beneꞌnu nucuaꞌ uni beella lunu: ―¿Cá aca bee nucuaꞌ? Nu ucuaqui Jesuse lubeella: ―Elu nuxu tucu nañi enu unguti zeꞌe rieteꞌ saꞌ bee ulabichi. ");
INSERT INTO zplNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Uni Jesuse tucu ejemplu lubee beneꞌnu para nú seteꞌnu liꞌibeella nu uninu rquiꞌña nú nacuꞌ beella lu Diose, nu la llacaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Che uninu nú lu beella: ―Tucu bene enu unga juece tucu eyeche nu la lliquilla Diose nu la riꞌi casolla bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nu leꞌca eyeche zeꞌe nzucu tucu unaꞌa enu unguti niyuꞌ, nu nzanchu lu juece zeꞌe rnacuꞌnchu nú riꞌi juece zeꞌe elietsa lunchu para nú deteꞌlla castiya lu bene enu rlee lunchu. ");
INSERT INTO zplNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero xee né riꞌi caso juece zeꞌe unaꞌa zeꞌe, nu chu uriꞌi juece zeꞌe elliebacuꞌ nú unilla: “Añinzuca nú la lliquia Diose nu la riꞌi casoa bee bene, ");
INSERT INTO zplNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero unaꞌa quieꞌ la tsuxenchu nú rriꞌi xiꞌinchu lua, mejora riꞌá elietsa lunchu para nú la yeꞌtaꞌnchu ante nú laxu paciencia.” ");
INSERT INTO zplNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nu chu uni Jesuse lubeella: ―Scua uni juece enu necha neca zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Enzeꞌe, ¿xieꞌ la riꞌi caso Diose bee beneꞌnu enu ucañinu chenu rnacuꞌ beella lunu bichia si rulaꞌ la? Nu, ¿xieꞌ leꞌnu para nú riꞌinu elietsa lubeella la? ");
INSERT INTO zplNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Liꞌá nia luhua nú riꞌinu elietsa lubeella sin nú leꞌnu. Pero chenu riña zeca liꞌá Bene enu uxeꞌla Diose, la riꞌá beyaꞌ tunu llelá bee bene enu nzeli arquiꞌ Diose lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Uni Jesuse stucu ejemplu para bee bene enu siꞌ nú neca beei bene nzeꞌca, nu rluachu beei beelá bee bene, nu uninu: ");
INSERT INTO zplNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Uya chiucu niyu liñi Indu llene Jerusalén unacuꞌ beei lu Diose: tucui neca fariseo, nu stucui neca enu rriꞌi cubre impuestos. ");
INSERT INTO zplNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nu nzulí fariseo zeꞌe rnacuꞌi lu Diose nú uni: “Cheꞌtsalu Diose Pa liñibe, xne la necaa xi neca stucu bee bene, xi neca bee bene enu rriꞌi eluhuanaꞌ, xi neca bee bene enu necha rriꞌi, xi neca bee bene enu rluꞌcu stucu unaꞌa, nu la necaa niꞌ xi neca benequieꞌ enu rriꞌi cubre impuesto. ");
INSERT INTO zplNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Chiucu bese liñi tucu xmana rdetea bichia nú la acua equie nú rluꞌcua ulaꞌna lulu Diose, leꞌca rdetea diezmo equie dimi nú rriꞌá ana.” ");
INSERT INTO zplNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero bene enu rriꞌi cubre impuesto istu utsui nu né riꞌi nú aletsai lui enza liñibe, nu xutse tsiai yai latsai nu uni: “¡Diose Pa liñibe uhuaꞌa arquiꞌ liꞌá, xne neca bene enu rluꞌcu dula!” ");
INSERT INTO zplNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Liꞌá nia luhua nú bene enu rriꞌi cubre bee impuesto uriꞌila Diose perdona liꞌilla chenu nzialla niꞌlla, pero fariseo zeꞌe né riꞌi Diose perdona liꞌilla, xne bene enu sucuꞌ aya leꞌcatsia liꞌi lecati neca nzeꞌe lu Diose. Pero bene enu reca lleꞌna arquiꞌ, liꞌilla necalla enu máse seca lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Leꞌca uyayu bee bene bee enduꞌ elu nzu Jesuse para nú ricuꞌnu yanu equie beei. Pero chenu ulañiꞌ bee beneꞌnu nucuaꞌ, uriꞌi beella nú uquiꞌyaꞌ bee bene enu uyayu bee enduꞌ zeꞌe lunu. ");
INSERT INTO zplNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero ubixia Jesuse liꞌibeella nu uninu lubeella: ―Uzelahua nú yeꞌta bee enduꞌ lua nu la cáhua nucuaꞌ, xne lunú rnibiyaꞌ Diose neca para bee bene enu neca xi neca bee enduꞌ quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Xne liꞌá nia luhua nú bene enu la chili arquiꞌ lunú rnibiyaꞌ Diose xi neca tucu enduꞌ, leca modo nú chuꞌulla elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tucu bene enu rnibiyaꞌ unidichiaꞌ lu Jesuse nú unilla: ―Maestro, enu neca bene nzeꞌca, ¿xi rquiꞌña riꞌá para nú lucua elunehuañi nú leca xunga laxu liñibe? ");
INSERT INTO zplNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nu uni Jesuse lui: ―¿Xinu rnilu nú neca bene nzeꞌca? Leca niꞌ tucu bene nzeꞌca, tucutsia Diose neca bene nzeꞌca. ");
INSERT INTO zplNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nediyaꞌláꞌlu bee mandamiento: “La útilu bene, nu la luꞌculu stucu unaꞌa, nu la riꞌilu eluhuanaꞌ, nu la taꞌlu eluquichiaꞌ stucu bene, uluꞌcu ulaꞌna lu paꞌlu cuna lu naꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Che uni bene zeꞌe lu Jesuse: ―Ye bee nucuaꞌ sucua hasta chenu lleꞌna. ");
INSERT INTO zplNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chenu ubeneꞌ Jesuse nucuaꞌ, uninu lui: ―Pero rriꞌi tucu nú riꞌilu nee. Uti ye bee steneꞌlu, nu udeꞌteꞌ dimi cuaꞌ lubee bene enu seca elitsi. Scua luꞌculu eluxene liñibe. Nu chu yeꞌta quieelu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero chenu ubeneꞌ bene zeꞌe nucuaꞌ, chiquiꞌ nehuana utsuu arquiꞌi, xne chiquiꞌ xenei. ");
INSERT INTO zplNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chenu ulañiꞌ Jesuse nú chiquiꞌ nehuana nzu arquiꞌi, che uninu: ―¡Chiquiꞌ neriñaꞌ nú chuꞌu bee bene xene elurnibiyaꞌ Diose! ");
INSERT INTO zplNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Máse facil nú dete tucu camello iꞌchiuꞌ echedicu, luquela nú chuꞌu bee bene xene elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pero bee bene enu ubeneꞌ nú uni Jesuse scua, unibeei lunu: ―¿Ti nuꞌ modo tsilaꞌa che? ");
INSERT INTO zplNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nu ucuaqui Jesuse lubeei: ―Nuꞌ nú neriñaꞌ neca para bee bene iliulabe, pero para Diose leca niꞌ tucu nú neriñaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chequie necachi uni Pedro lunu: ―Liꞌiru utsaꞌnaru ye beenú rluꞌcuru para nú nzela quieeru liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nu ucuaqui Jesuse nú uninu: ―Liꞌá nia luhua nú titse bene enu tsaꞌna niꞌi, urre unaꞌa, urre bichi, urre paꞌ, urre na, urre lliꞌñi, para nú riꞌilla lunú rnibiyaꞌ Diose, ");
INSERT INTO zplNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","liꞌilla másela yuculla nú liquiꞌ Diose lulla lu iliulabe quieꞌ nu leꞌca luculla elunehuañi nú leca xunga laxu liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ubixia Jesuse chiꞌchiucu bee beneꞌnu tucu chú nu uninu lubeella: ―Nee chaꞌahua Jerusalén elu yalu tucu nú uquieꞌe bee profeta lu cuendaꞌ liꞌá Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Deteꞌ cuenda bee bene liꞌá lubee bene rene, nu tsequichiaꞌ beei liꞌá, ni beei huaxi bedichiaꞌ nú necha neca lua nu tsúxene beei lua. ");
INSERT INTO zplNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Iñi beei liꞌá nu úti beei liꞌá, pero bichia rriuna huañi zecaa. ");
INSERT INTO zplNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","La riꞌilí bee beneꞌnu beyaꞌ lunú uninu, nu la riꞌi beella beyaꞌ xa neca nú rninu, xne uninu tucu nú leca modo riꞌi beella beyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Chenu nze riña Jesuse axu eyeche Jericó, nzucu tucu niyu enu niquieꞌlu ruꞌu inziu rnacuꞌ carida, ");
INSERT INTO zplNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","chenu ubeneꞌi nú rdete huaxi bee bene inziu zeꞌe unidichiaꞌi xi reca. ");
INSERT INTO zplNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Che uni bee bene lui nú Jesuse bene eyeche Nazaret rdete lu inziu zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","nu ubixialí nú uni: ―¡Jesuse lliꞌñi David uhuaꞌa arquiꞌ liꞌá! ");
INSERT INTO zplNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bee bene enu nzuculu rquiꞌyalla rriꞌi beei para nú zacalla, pero másela ubixialilla nú unilla: ―¡Lliꞌñi David uhuaꞌa arquiꞌ liꞌá! ");
INSERT INTO zplNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chequie utsuxee Jesuse nu unibiyaꞌnu nú yeꞌtayuu bee bene liꞌilla lunu. Chenu uriñalla axu lunu unidichiaꞌnu lulla: ");
INSERT INTO zplNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Xi niarquiꞌlu nú riꞌá lulu? Nu ucuaqui niyu enu niquieꞌlu zeꞌe nu necachi unilla lunu: ―Niarquia nú yeꞌe iꞌculua nu biꞌya zecaa. ");
INSERT INTO zplNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nu uni Jesuse lulla: ―Riꞌyalálu nee, nu uyecaꞌlaꞌlu xne uchili arquiꞌlu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hora zeꞌe chu uyeꞌe iꞌculu niyu zeꞌe, nu nzequiei Jesuse nu uni bedichiaꞌ nzeꞌca lu Diose. Nu ye bee bene enu ulañiꞌ nú unga scua, leꞌca unibeei bedichiaꞌ nzeꞌca lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Uyuꞌu Jesuse eyeche Jericó, nu chu udetenu eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Zeꞌe nzucu tucu bene xene enu lee Zaqueo nu rnibiyaꞌlla lubee bene enu rriꞌi cubre impuesto. ");
INSERT INTO zplNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Niarquiꞌ Zaqueo quieꞌ nú chululla Jesuse, pero leca modo nú lañiꞌlla liꞌinu xne nzeꞌtanala huaxi bee bene liꞌinu, nu nerungulla. ");
INSERT INTO zplNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Enzeꞌe uyecaxuꞌulla nu uricululla, para nú lañiꞌlla Jesuse, chequie uquiella lu tucu aca nú lee sicómoro axu elu detenu. ");
INSERT INTO zplNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Chenu udete Jesuse zeꞌe, ubiꞌyanu enzeya nu uninu lulla: ―Zaqueo yexetsia ulaca, xne nee riaꞌna niꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Che yexetsia ulaca Zaqueo, nu ñia nzu arquiꞌlla nú uriña Jesuse niꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chenu ulañiꞌ bee bene nú uriñanu niꞌi Zaqueo, ye beei uquixie beei nú seꞌta beei Jesuse nu rnibeei xinú nzanu yaꞌnanu niꞌ bene enu rluꞌcu dula. ");
INSERT INTO zplNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nu utsuli Zaqueo nu necachi unilla lu Jesuse: ―Ubiꞌyacuru, ritsia arliꞌtiꞌ lunú rlucua lubee bene enu seca elitsi. Nu tunu nuꞌ bene enu uriꞌá cubre de mase lu, nee detea lulla tacu bese mase lunú ucachia lulla. ");
INSERT INTO zplNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Che uni Jesuse lulla: ―Bichia quieꞌ uriña nú tsilaꞌa bee bene enu nucuaꞌa niꞌ Zaqueo, xne uchili arquiꞌlla Diose, liꞌilla necalla enu mero nzeꞌta lu familiꞌ tuxie Abraham. ");
INSERT INTO zplNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nu liꞌá Bene enu uxeꞌla Diose, nzela para nú laꞌna bee bene enu nza inziu nú necha neca, nu tsilaꞌa liꞌibeei lu dula. ");
INSERT INTO zplNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bee bene enu rieneꞌ lunú rni Jesuse, uninu tucu ejemplu lubeei, xne axula nzunu Jerusalén, nu liꞌibeei rriꞌi beei elliebacuꞌ nu hora zeꞌe nze riñala lunú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nu uninu lubeei: ―Uhuañi tucu niyu enu nzeꞌta lu tucu famili enu chiquiꞌ neca equie, nu nzalla istu stucu nación para nú yuculla nú nibiyaꞌlla, nú acalla arre nu chu benchilaꞌ zecalla para nú nibiyaꞌlla lachilla. ");
INSERT INTO zplNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ante nú chiuꞌulla, ubixialla chiꞌi bee mosoꞌlla nu udeteꞌlla lu cada tucua beei tucu dimi nú huaxi seca, nu unilla lubeei: “Uriꞌihua berexe cuna dimi cuaꞌ hasta chenu benchilaꞌ zecaa.” ");
INSERT INTO zplNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero bee bene lachilla, chiquiꞌ rana arquiꞌbeei liꞌilla, nu uxeꞌla beei texcuaꞌa bee bene nzequie liꞌilla nu uya niꞌ beei lubee bene elu nzalla nú la niarquiꞌbeei nú aca bene cuaꞌ arre lubeei. ");
INSERT INTO zplNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero uyaꞌnalla nú ungalla arre, nu ubenchilaꞌ zecalla lachilla. Chenu uriñalla ubixialla bee mosoꞌlla enu udeteꞌlla dimiꞌlla ya para nú riꞌilla beyaꞌ calu uriꞌi cada tucua beei ana. ");
INSERT INTO zplNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mosoꞌ enu rluti uya uni lulla: “Detá, dimi nú uliquiꞌlu lua, uriꞌi ana chiꞌi bese mase lunú necane.” ");
INSERT INTO zplNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nu uni arre zeꞌe lulla: “Uriꞌi nzeꞌcalu, tucu nú rialane. Nu lunú uriꞌilu tucu nú rialane cuna lu lleꞌna nú utsaꞌna lulu, nee liquia lulu nú nibiyaꞌlu lu chiꞌi eyeche.” ");
INSERT INTO zplNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chenu uya mosoꞌ rrucu unilla lu arre zeꞌe: “Detá, dimi nú uliquiꞌlu ya uriꞌi ana ayuꞌ bese mase lunú necane.” ");
INSERT INTO zplNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Leꞌca esquie uni arre zeꞌe lu benecuaꞌ: “Liꞌilu nibiyaꞌlu lu ayuꞌ eyeche.” ");
INSERT INTO zplNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nu uya stucu mosoꞌ lulla nu uni nzeꞌe lulla: “Detá, nguie dimiꞌlu. Uducheꞌne liñi tucu panitu, ");
INSERT INTO zplNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","xne ulliquia liꞌilu nú la huaꞌa arquiꞌlu bee bene, nu riuculu lunú né tsaꞌnalu, nu riuculu ulaꞌcu elu la duꞌlu nii.” ");
INSERT INTO zplNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chequie uni arre zeꞌe lui: “Mosoꞌ enu necha neca, equie nú unilu scua enzeꞌe rialálu castiyaꞌlu. Tunu nediyaꞌlu nú la huaꞌa arquia bee bene nu riucuꞌa lunú né tsaꞌna nu riucuꞌa ulaꞌcu elu la riꞌá riñaꞌ, ");
INSERT INTO zplNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","bueno che, ¿xiquie nú né duꞌlu dimia banco para nú chenu ubenchilaꞌ zecaa ayucuꞌne cuna lliꞌñine?” ");
INSERT INTO zplNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nu chu uni arre zeꞌe lubee bene enu nucuaꞌa zeꞌe: “Axihua melu cuaꞌ yai, nu udeteꞌhuane ya bene enu nzene chiꞌi.” ");
INSERT INTO zplNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Che necachi uni bee benecuaꞌ lu arre zeꞌe: “Pero liꞌilla rluꞌculalla chiꞌi melu.” ");
INSERT INTO zplNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nu ucuaqui arre zeꞌe: “Liꞌá nia luhua nu bene enu rluꞌculane, rquiꞌña nú yuculá nzeꞌene; pero bene enu rluꞌcu lleꞌnatsiae, hasta lu lleꞌna nú rluꞌculla ducuꞌ enzeꞌe yalla. ");
INSERT INTO zplNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nu bee bene enu rlee lua nu la niarquiꞌ beei nu aca arre, uteyuhua bee nzeꞌe caꞌa, nu útihua beei lua.” ");
INSERT INTO zplNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chenu ulaxu nú uni Jesuse ejemplu cuaꞌ, uriꞌinu seidu nú nzanu enza Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nu chenu uriñanu axu eyeche Betfagé cuna Betania axu dañi nú lee Olivos, che uxeꞌlanu chiucu bee beneꞌnu, ");
INSERT INTO zplNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nu uninu lubeella: ―Uquiahua eyeche nú nchiucuꞌ enza lucuaꞌ. Nu chenu riñahua zeꞌe llelaꞌhua tucu burro enu niquietu enu lascaꞌlí ricu bene. Uxeꞌchehuaií nu yeꞌtayuhuaií. ");
INSERT INTO zplNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tunu nuꞌ enu nedichiaꞌ luhua xinu xeꞌchehuaií, uniꞌhua lu bene zeꞌe nú Detá, Jesuse enu rnibiyaꞌ luru uni nú uyaꞌruií. ");
INSERT INTO zplNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Che uyaa bee beneꞌnu nu uriꞌi beella tucu nú uninu lubeella. ");
INSERT INTO zplNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nu chenu xeꞌche beella burro zeꞌe, bee lluaanaꞌí unidichiaꞌ lubeella: ―¿Xinu xeꞌchehua burro cuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nu ucuaqui beella: ―Xne Detá, Jesuse rni nú uyaꞌruií. ");
INSERT INTO zplNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Che unguyaꞌ beella burro zeꞌe elu nzu Jesuse, nu uricuꞌ beella xucu beella equieií nu uricu Jesuse equieií. ");
INSERT INTO zplNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nu ucuaꞌa bee bene xucu beei labe inziu elu udetenu. ");
INSERT INTO zplNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nu chenu uquixie nú nze laca beella equie dañi nú lee Olivos, ye bee bene enu nzequie Jesuse uquixie beei nú urixialibeei xne chiquiꞌ ñia nzu arquiꞌbeei, nu unibeei bedichiaꞌ nzeꞌca lu Diose, equie ye bee milagro nú ulañiꞌ beei nú uriꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nu unibeei: ―¡Ñia nzeꞌta arre, liꞌinu enu nzeꞌta lu cuendaꞌ Paꞌahua Diose! ¡Nuꞌ nú nzuxe liñibe cheꞌtsa Diose enu nzucu liñibe! ");
INSERT INTO zplNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chequie bee fariseo enu nzeꞌta leta bee bene enu nzequie liꞌinu unibeei lunu: ―Maestro, uquiꞌyaꞌ bee bene enu nzeꞌtaquie liꞌilu nú la bixialí beei scua. ");
INSERT INTO zplNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero ucuaqui Jesuse lubeei: ―Nia luhua tunu zaca beei, bee quie neca nú bixialí scua. ");
INSERT INTO zplNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Chequie chenu uriña Jesuse axu eyeche Jerusalén, chenu ulañiꞌnu eyeche cuaꞌ ungunaꞌnu equie cuendaꞌ eyeche cuaꞌ, ");
INSERT INTO zplNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nu uninu: ―¡Bee bene eyeche Jerusalén, alaꞌ masia bichiaquieꞌ uriꞌihua beyaꞌ ti liquiꞌ nú nzuxe arquiꞌhua! Pero aꞌchi neca nucuaꞌ luhua nee, nu la lañiꞌhuane. ");
INSERT INTO zplNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Riña bichia nú recheꞌe bee bene enu rlee luhua muro diqui abenchilaꞌ lachihua, nu diqui bee luhuare riꞌi condra bee bene liꞌihua, ");
INSERT INTO zplNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","nu úti beei liꞌihua. Che nitilu beei lachihua, nu la tsaꞌna beei niꞌ stucu quiee equie saꞌe, xne né riꞌihua caso Diose chenu ubeꞌta biꞌyanu liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Lulá bee nucuaꞌ, uriña Jesuse labe eliꞌyaꞌ Indu llene Jerusalén, nu uquixienu uluanu bee bene enu ruti cuna bee bene enu sii zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","nu uninu lubeei: ―Lu ichiꞌ Stichiaꞌ Diose rni: “Nia neca para nú nacuꞌ bee bene lu Diose”, pero liꞌihua rriꞌihuane xi neca yubeꞌ elu rcuaꞌa bee huanaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ye bichia uzeteꞌ Jesuse bee bene liñi indu llene Jerusalén, pero bee uleꞌya cuna bee ulaxcuela enu reca leyꞌ Moisés cuna bee usticia eyeche zeꞌe, rlaꞌna beei xa modo úti beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero la llelaꞌ beei xa modo úti beei liꞌinu, xne ye bee bene chiquiꞌ sucuꞌ diaca lunú seteꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tucu bichia diqui nú seteꞌ Jesuse bedichiaꞌ nzeꞌcaꞌ Diose lubee bene liñi Indu llene Jerusalén. Che uriña bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee ulaxcuela enu reca leyꞌ Moisés, cuna bee usticia Israel lunu, ");
INSERT INTO zplNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nu unidichiaꞌ beella lunu: ―Uniꞌ luru, ¿ti uliquiꞌ elu usticia nú rriꞌilu scua? Nu ¿ti uliquiꞌ elurnibiyaꞌ nú rriꞌilu nucuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Che ucuaqui Jesuse lubeei: ―Leꞌca nidichiaꞌa tucu luhua. Ucuaquihua lua nee: ");
INSERT INTO zplNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ti uxeꞌla Juan para nú rinzalla bee bene? ¿Diose uxeꞌla liꞌilla la urre bee bene la? ");
INSERT INTO zplNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pero uquixie beei nú ubedichiaꞌnu saꞌbeei nu rnibeei: ―Tunu niaꞌahua nú Diose uxeꞌla Juan Bautista, che ni nucuaꞌ luaꞌahua: “¿Xiquie nú la chili arquiꞌhua nú rnilla che?” ");
INSERT INTO zplNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nu leꞌca leca modo nú niaꞌahua nú bee bene uxeꞌla liꞌilla, xne úti bee bene liaꞌahua cuna quiee, xne ye bee bene nzeli arquiꞌ nú Juan Bautista unga tucu profetaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Che ucuaqui beei nú la riꞌi beei beyaꞌ ti uxeꞌla Juan nú rrinzalla bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nu uni Jesuse lubeei: ―Leꞌca la ixiuleꞌa luhua ti uliquiꞌ elurnibiyaꞌ nú rriꞌá bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nu chu uquixie Jesuse uninu lubee bene ejemplu quieꞌ: ―Tucu niyu uquienii bee aca uva lu yuꞌlla nu chu udeteꞌlla yuꞌlla lleꞌla lubee bene, nu nzalla enza istu zuculla. ");
INSERT INTO zplNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chenu uriña tiembu nú aca ulaꞌcu uva, uxeꞌlalla tucu mosoꞌlla nzetucu lunú rialalla. Pero udiñi bee bene zeꞌe mosoꞌ cuaꞌ nu scuatsia uxeꞌla beei liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chequie uxeꞌla bene enu neca stene yuu zeꞌe stucu mosoꞌlla, pero leꞌca esquie udiquichiꞌquiꞌ beei nzeꞌe nu udiñi beei nzeꞌe, nu scuatsia uxeꞌla beei liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nu uxeꞌla bene zeꞌe stucu mosoꞌlla, pero udiñi beei mosoꞌ zeꞌe nu utiꞌqui beei liꞌi, nu uhua beei liꞌi lu yuu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Chequie uni bene enu neca stene yuu zeꞌe: “¿Xa riꞌá nee? Xeꞌla endua enu chiquiꞌ seꞌca, tia aꞌla liꞌi luꞌcu bee bene cuaꞌ ulaꞌna.” ");
INSERT INTO zplNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero chenu ulañiꞌ bee bene zeꞌe enduꞌlla unibeei lu saꞌ beei: “Liꞌi neca enu yaꞌnanu yuu quieꞌ, te útiaꞌahua liꞌi para nú yaꞌnanuaꞌahua yuu quieꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nu uhua beei liꞌi lu yuu zeꞌe, nu unguti bee bene zeꞌe liꞌi. Che unidichiaꞌ Jesuse lubee bene enu rdichiaꞌnunu: ―¿Xa rriꞌihua elliebacuꞌ nú riꞌi bene enu neca stene yuu zeꞌe cuna bee bene zeꞌe? ");
INSERT INTO zplNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Puese nia luhua nú nzeꞌtalla nu útilla bee bene zeꞌe, nu deteꞌlla yuꞌlla lu stucu bee bene. Chenu ubeneꞌ beei nucuaꞌ, unibeei: ―¡Alaꞌ la acane scua! ");
INSERT INTO zplNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero ubiꞌya Jesuse lubeei nu uninu: ―Tunu la acane scua, ¿xinu rni lu ichiꞌ Stichiaꞌ Diose elu rni?: Quiee nú uhua uꞌna bee bene enu rrecheꞌe niꞌi, quiee cuaꞌ neca nú máse uzibiꞌ ungacheꞌ niꞌi zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Titse bene enu llica cuchiuꞌ cuna quiee cuaꞌ nehuana zeca bene zeꞌe, nu tunu zanaꞌ quiee cuaꞌ equie bene, laꞌxulíi liꞌilla che. ");
INSERT INTO zplNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee ulaxcuela enu reca leyꞌ Moisés. Hora zeꞌe niarquiꞌ beei naꞌtse beei Jesuse, xne uriꞌi beei beyaꞌ nú lunú uninu scua neca nucuaꞌ contra liꞌibeei, pero ulliqui beei bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Che uxeꞌla beei bee bene nze tsiꞌña liꞌinu, nu rriꞌi bee bene quieꞌ tucu nú neca beei bene nzeꞌca, para nú rlaꞌna beei nú ni Jesuse tucu bedichiaꞌ nú riꞌi nú deteꞌ cuenda beei liꞌinu lu gobernador Roma. ");
INSERT INTO zplNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nu unidichiaꞌ beei lunu, nú unibeei: ―Maestro, liꞌiru nediyaꞌru nú rnilu nu rriꞌilu tucu nú rialane, nu rriꞌilu tucunecatse lu ye bee bene, nu neli seteꞌlu bee bene nú xa niarquiꞌ Diose nú huañi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Uniꞌ luru: ¿Neca nzeꞌca nú dixiuru bee impuesto lu gobernador Roma la?, ¿urre la neca nzeꞌcae la? ");
INSERT INTO zplNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero chu uriꞌi Jesuse beyaꞌ nú lixiu neca elliebacuꞌ beei, nu uninu lubeei: ");
INSERT INTO zplNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Ulubeꞌhua tucu melu lua. ¿Tiluu nú nzucu lue, nu ti nombreꞌ nequie lue? Nu ucuaqui beei: ―Neca nucuaꞌ arre César. ");
INSERT INTO zplNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Che uni Jesuse lubeei: ―Udeꞌteꞌhua nú neca steneꞌ César lu César, nu udeꞌteꞌhua nú neca steneꞌ Diose lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nu lá llelaꞌ beei xi aricuꞌquiya beei liꞌinu lu ye nú uninu lubee bene. Nzenutsia arquiꞌbeei lunú xa ucuaquinu lubeei, nu lecaꞌ xi unibeei. ");
INSERT INTO zplNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Cheela uya chiucu chuna bee Saduseo lu Jesuse. Bee saduceo quieꞌ la chili arquiꞌbeei nú huañi zeca bee bene enu unguti. Enzeꞌe unibeei lunu: ");
INSERT INTO zplNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, leyꞌ Moisés rni tunu ati tucu niyu nu tsaꞌnalla unaꞌalla nu lá luꞌcu beei enduꞌ, che yucu bichi tuxie zeꞌe unaꞌalla para nú luꞌcu beella enduꞌ enu neca xi neca enduꞌ tuxie zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nu ucuaꞌa achi bichi tucu bene, bichi rluu beei uyucu unaꞌa, pero ungutilla nu né luꞌcu beella enduꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chequie uyucu bichi rrucu beei unaꞌa zeꞌe, pero leꞌca ungutilla nu né luꞌcu beella enduꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Leꞌca uyucu bichi rriuna beei unaꞌa zeꞌe, nu scua uyucunchu lu achi bichi beei, nu ye beei unguti beei nu né luꞌcu beei enduꞌ cuna unaꞌa zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Cheela, leꞌca unguti unaꞌa zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Enzeꞌe bichia nú huañi zeca bee bene enu unguti, ¿ta lu achi bee benecuaꞌ neca niyuꞌ unaꞌa zeꞌe, xne ye beei uchia beei cuna liꞌinchu? ");
INSERT INTO zplNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nu uni Jesuse lubeei: ―Lu iliulabe quieꞌ xia bee bene nu rdeteꞌ beei xinchiuꞌcu beei para nú chia. ");
INSERT INTO zplNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero bee bene enu riala nú luꞌcu stucu elu nehuañi nú necuqui, liꞌibeella enu huañi zeca, niyu si unaꞌa la chiaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Xne la atiaꞌ beella, acatsia beella xi neca bee ángeleꞌ Diose nu aca beella lliꞌñinu, equie nú uhuañi zeca beella. ");
INSERT INTO zplNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Liꞌiru nediyaꞌru nú huañi zeca bee bene enu unguti, xne hasta Moisés uni tucu parte lu ichiꞌ Stichiaꞌ Diose elu rni nú ulañiꞌlla aca nú riqui. Nu lu ichiꞌ zeꞌe rni nú liꞌinu necanu Dioseꞌ Abraham cuna Isaac, cuna Jacob. ");
INSERT INTO zplNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Nu Diose la necanu Dioseꞌ bee bene enu unguti, liꞌinu necanu Dioseꞌ bee bene enu nehuañi, xne para liꞌinu ye bee bene nehuañi! ");
INSERT INTO zplNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chequie chiucu chuna bee ulaxcuela enu reca leyꞌ Moisés unibeei lunu: ―Uni nzeꞌcalu Maestro. ");
INSERT INTO zplNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nu né lacaꞌ arquiꞌbeei a nacuꞌ dichiaꞌlá beei lunu. ");
INSERT INTO zplNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pero uni Jesuse lubeei: ―¿Xinu rni bee bene nú neca Cristo lliꞌñi David? ");
INSERT INTO zplNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nu leꞌca liꞌi David uni lu libro Salmos: Diose uni lu liꞌinu enu rnibiyaꞌ lua: “Uzucu cueꞌtsea chubee, ");
INSERT INTO zplNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta nú riꞌá ana nú nibiyaꞌlu lubee bene enu rle lulu.” ");
INSERT INTO zplNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Enzeꞌe tunu Cristo neca lliꞌñi David, ¿xiquie nú rni David lunu Liꞌilu rnibiyaꞌlu lua? ");
INSERT INTO zplNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ye bee bene uquieꞌe diaca chenu uni Jesuse lubee beneꞌnu: ");
INSERT INTO zplNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ubiꞌyahua liꞌihua lubee ulaxcuela enu reca leyꞌ Moisés, xne riuꞌ arquiꞌbeei nú enzee beei cuna xucu fiñu beei, nu leꞌca riuꞌ arquiꞌbeei nú luꞌcu bee bene ulaꞌna lubeei labe inziu. Nu liñi bee indu rlaꞌna beei nú zucu beei lubee xleta nú máse neca equie, leꞌca scua rriꞌi beei elu nze tacu beei eta. ");
INSERT INTO zplNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Leꞌca raxi beei niꞌi bee unaꞌa enu unguti niyuꞌ, nu para nú ni bee bene nú neca beei bene nzeꞌca, xee rnacuꞌ beei lu Diose. Pero liꞌibeei yala beei castiya nú mase fuerte. ");
INSERT INTO zplNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Chenu ulañiꞌ Jesuse nú rduꞌ bee bene xene uꞌna liñi alcancia liñi Indu llene Jerusalén, ");
INSERT INTO zplNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","leꞌca esquie ulañiꞌnu tucu unaꞌa enu unguti niyuꞌ nu secalla elitsi, nu uduꞌlla chiucu melu nú meꞌ liñi alcancia zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Che uni Jesuse lubee beneꞌnu: ―Liꞌá nia luhua nú máse sibiꞌ uꞌna nú uduꞌu unaꞌa zaqui elitsi quieꞌ lunú sibiꞌ uꞌna nú uduꞌu beelá bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Xne ye bee bene rduꞌtsia beei lunú sucu sobra equie dimiꞌ beei, pero unaꞌa quieꞌ añinzuca nú secalla elitsi uduꞌlla ye dimiꞌlla liñi alcancia añinzuca nú nucuaꞌtsia rluꞌculla. ");
INSERT INTO zplNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Chiucu chuna bee bene rdichiaꞌ beei equie cuendaꞌ bee quiee nú ñia rnaa necacheꞌ Indu llene Jerusalén, cuna equie cuendaꞌ beenu huaxi seca nú lia rdeteꞌ bee bene para nú sucheꞌe. Nu uni Jesuse lubeei: ");
INSERT INTO zplNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Riña bichia nú ye nú rlañiꞌhua nee, pero niꞌ stucu quiee la yaꞌnaꞌe equie saꞌe, yeene rilae. ");
INSERT INTO zplNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nu unidichiaꞌ bee bene lunu: ―Maestro, ¿xunga aca bee nucuaꞌ? Nu ¿xi seña lubeꞌ nú nzula nú aca bee nucuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Chequie uni Jesuse lubeei: ―Ubiꞌyahua liꞌihua para nú lecati zequienu liꞌihua. Xne nzeꞌta huaxi bee bene enu ni luhua nú nzeꞌta beei equie cuendaꞌ liꞌá, nu ni beei: “Liꞌá neca Cristo”; urre “Nzeꞌta axula bichia nú riñanu.” Pero la chili arquiꞌhua lunú nibeei. ");
INSERT INTO zplNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nu chenu yeneꞌhua nú reca xuu nu rliu bee bene, la lliquihua xne rluti bee nucuaꞌ acaxu ante nú laxu iliulabe, pero la neca lu cuendaꞌ nucuaꞌ nú ulaxu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nu unilá Jesuse lubeei: ―Tucu nación liunu cuna stucu nación, nu bee gobierno liunu cuna stucu gobierno. ");
INSERT INTO zplNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nu aca bee xú nu juerte, nu aca biña, nu aca bee elichia diqui lu iliulabe, nu lañiꞌ bee bene beenú nelliqui rnaa liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero ante nú aca ye bee nucuaꞌ, naꞌtse bee bene liꞌihua, nu xitse riꞌinu beei liꞌihua nu riꞌibeei nú nehuana zecahua, uyaꞌ beei liꞌihua liñi bee indu para nú chiuꞌulue lu cuendaꞌhua. Duꞌ beei liꞌihua niꞌcuꞌ nu cheyubeei liꞌihua lubee arre cuna lubee gobierno para nú chiuꞌulue lu cuendaꞌhua equie nú nzeli arquiꞌhua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pero scua nuꞌ modo nú nihua stichiaꞌa lubeei. ");
INSERT INTO zplNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","La quiꞌña nú chenu arquiꞌhua, nu la quiꞌña riꞌihua elliebacuꞌ xa cuaquihua lubee bene zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","xne liꞌá liquia elliebacuꞌ luhua cuna bee bedichiaꞌ nú nihua. Niꞌ tucu bee enu rlee luhua la riquiꞌ beei nú yeneꞌ beei bedichiaꞌ cuaꞌ, nu leꞌca leca modo ni condra beei liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pero liꞌihua riña bichia nú hasta bee paꞌhua cuna bee naꞌhua cuna bee bichihua cuna bee familiꞌhua cuna bee bene enu rquieteꞌhua deteꞌ cuenda beei liꞌihua, nu nuꞌhua enu uti bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nu ye bee bene iliulabe chana arquiꞌbeei liꞌihua, equie nú necahua bee benea. ");
INSERT INTO zplNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero niꞌ tucu ichia equiehua la nitihua equie bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Utsutaꞌ arquiꞌhua lu stichiaꞌa para nú chuꞌuhua liñibe elu huañilíhua. ");
INSERT INTO zplNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Chenu lañiꞌhua nú nucuaꞌa bee sundado diqui abenchilaꞌ eyeche Jerusalén, uriꞌihua beyaꞌ nú nzula nú laxu eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chequie bee bene enu nucuaꞌa bee eyeche Judea, rquiꞌña nú yecaxuꞌu beei enza dañi, nu bee bene enu nucuaꞌa eyeche Jerusalén, rquiꞌña nú chiuꞌu beei eyeche cuaꞌ, nu bee bene enu rriꞌi riñaꞌ enza ruꞌu eyeche la benchilaꞌ beei eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Xne bee bichia zeꞌe deteꞌ Diose castiya bee bene para nú yalu ye tucu nú niquie lu ichiꞌ Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Pero cueꞌ bee unaꞌa enu nuꞌ enduꞌ xlaꞌcu cuna bee unaꞌa enu nuu bee endu enu rachi bichia zeꞌe! Xne chiquiꞌ nehuana zeca bee bene, nu yala bee bene eyeche zeꞌe tucu castiya nú juerte. ");
INSERT INTO zplNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Texcuaꞌa beei ati lu xuu, nu texcuaꞌa beei uyaꞌ bee bene preso diqui lu iliulabe, nu bee bene rene nibiyaꞌ Jerusalén, hasta nú yalu bichia nú tsanaꞌ Diose nú nibiyaꞌ beei zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Chequie lañiꞌ bee bene seña lu bichia cuna lu uu cuna lubee belaa, nu lu iliulabe la riaꞌ bee bene beyaꞌ xi riꞌi beei, nu lliqui beei xne chiquiꞌ juerte llichi inzatuꞌ lunú cuñine. ");
INSERT INTO zplNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hasta nú chiulaꞌ bee bene equie nú lliqui beei chenu riꞌi beei elliebacuꞌ lunú aca lu iliulabe quieꞌ, nu hasta beenú nuꞌ liñibe cuñi. ");
INSERT INTO zplNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chequie lañiꞌ bee bene iliulabe Bene enu uxeꞌla Diose, nú tuꞌna rulu siquiꞌnu nzeꞌtanu liñi xcabe cuna ye nú rluꞌunu. ");
INSERT INTO zplNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chenu quixie nú aca bee nucuaꞌ, uduꞌhua ana arquiꞌhua nu uletsahua luhua, xne axula uriña bichia nú tsilaꞌahua lunú nehuana zecahua. ");
INSERT INTO zplNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Leꞌca uni Jesuse lubeei ejemplu quieꞌ: ―Ubiꞌyacuruhua aca higo, urre tatse stucu bee aca. ");
INSERT INTO zplNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chenu lañiꞌhua nú riyeꞌ leca eꞌneꞌ lubee aca, liꞌihua rriꞌihua beyaꞌ nú nzeꞌta axula nú aca nelee. ");
INSERT INTO zplNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Leꞌca esquie, chenu lañiꞌhua nú uquixiela nú aca bee nucuaꞌ, riꞌihua beyaꞌ nú nzeꞌta axula lunú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Liꞌá nialuhua nú ye bee nucuaꞌ aca ante nú ati ye bee bene enu nehuañi tiembu quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Liñibe cuna iliulabe laxu, pero stichiaꞌa la dete nú yalue. ");
INSERT INTO zplNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ubiꞌyahua liꞌihua para nú la riꞌi bee bicio ana luhua nu la riꞌi úniqui ana luhua nu la acu xeꞌtahua nu la riꞌihua nú chenu arquiꞌhua nú xa huañihua para nú chenu benchilaꞌ zecaa, la aca bichia zeꞌe nu tuꞌnatsia llunahua. ");
INSERT INTO zplNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Xne scua aca bichia zeꞌe para lu ye bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ucuaꞌa tsiñahua, nu ye bichia unaꞌcuꞌhua lu Diose para nú nuꞌ modo tsilaꞌahua lu ye beenú aca lu iliulabe, nu para nú scua nuꞌ modo riñahua lu Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Bichia uzeteꞌ Jesuse bee bene liñi indu llene Jerusalén, nu rulaꞌ nzanu riaꞌnanu dañi nú lee Olivos. ");
INSERT INTO zplNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nu ye bee bene se silaꞌ liñi Indu Jerusalén cuaꞌ para nú rieneꞌ beei lunú rninu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chenu nzeꞌta axula eliñi baxcu, chenu racu bee bene pá nú la chuꞌu levadura equie, ");
INSERT INTO zplNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","chequie bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee ulaxcuela enu reca leyꞌ Moisés, rlaꞌna beei xa modo úti beei Jesuse, xne xiqui beei bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nu uyuꞌu bezeꞌlu arquiꞌ Judas Iscariote, liꞌi necai tucu lu chiꞌchiucu bee beneꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Che uya Judas lubee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna lubee bene enu rnibiyaꞌ liñi indu, nu uni lubeella nú xa deteꞌ cuendai Jesuse lubeella. ");
INSERT INTO zplNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Che chiquiꞌ ñia utsu arquiꞌbeella chenu ubeneꞌ beella nucuaꞌ, nu uni beella nú deteꞌ beella dimi yai. ");
INSERT INTO zplNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nu uzelai, che uquixiei nú ucuaꞌnai xa modo deteꞌ cuendai Jesuse chenu la riꞌi bee bene beyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Chenu uriña bichia liñi baxcu nú racu bee bene Israel pá nú la nucha levadura, cuna chenu riñi bene tucu sanchi llaꞌna xi neca uꞌna lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chequie uxeꞌla Jesuse Pedro cuna Juan, nú uninu lubeella: ―Uquiahua nu urecheꞌhua exee nú daꞌcuxeꞌahua reché baxcu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nu unidichiaꞌ beella lunu nú uni beella: ―¿Cá niarquiꞌlu nú riꞌilurune? ");
INSERT INTO zplNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Che uni Jesuse lubeella: ―Chenu chuꞌuhua eyeche Jerusalén, zeꞌe llaꞌcahua tucu niyu enu nuyaꞌ tucu ereꞌe inza, uquia quieehualla hasta niꞌi elu chuꞌulla, ");
INSERT INTO zplNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","nu uniꞌhua lu bene enu neca stene niꞌi zeꞌe: “Singuie rni Maestro, ¿Cá nzucu cuarto elu acuxénua bee benea reché baxcu?” ");
INSERT INTO zplNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Che lubeꞌ bene zeꞌe tucu cuarto elu ayaa nú nzucheꞌela liñi. Zeꞌe recheꞌehua nú daꞌcuxeꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Chequie uya beella nu ullelaꞌ beella tucu nú uni Jesuse lubeella, nu urecheꞌe beella nú acuxee beella reché baxcu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chenu uriña hora, uzucu Jesuse cuna bee apóstolꞌnu lu mexa. ");
INSERT INTO zplNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Che uni Jesuse lubeella: ―¡Chiquiꞌ niarquia nú acuxenuahua rulaꞌ baxcu quieꞌ ante nú enta nú chiquiꞌ nehuana zecaa! ");
INSERT INTO zplNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Xne liꞌá nia luhua nú lecaꞌ bichia nú acunu zeca liꞌihua lu iliulabe quieꞌ stucu bese, nu hasta elurnibiyaꞌ Diose acunu zeca liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Che unaꞌtsenu tucu copa biñu, nu chenu ulaxu nú udeteꞌnu cheꞌtsa lu Diose, uninu: ―Unaꞌtsehua biñu quieꞌ nu uhueꞌhuane nu uriꞌtsiꞌhuane lubee saꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Xne liꞌá nia luhua nú lecaꞌ bichia nú huaꞌa biñu hasta bichia nú riña lunú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chequie unaꞌtsenu pá, nu chenu ulaxu nú udeteꞌnu cheꞌtsa lu Diose, uleꞌenu pá zeꞌe nu udeteꞌnue yabeella, nu uninu: ―Pá quieꞌ neca cuerpoa nú detecuendaa chenu atia equie cuendaꞌ liꞌihua. Nu chenu riꞌihua scua, uriꞌihuane equie nú nchiucuꞌ arquiꞌhua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Leꞌca scua uriꞌinu cuna copa biñu chenu ulaxu nú udacuxee beella, nu uninu: ―Biñu quieꞌ neca renea nú riꞌchia chenu atia para nú scua yaꞌla tucu inziu cuqui nú nuꞌ modo riꞌi Diose perdona bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Pero nee enu deteꞌ cuenda liꞌá nchiucuꞌ ya lu mexa elu nchiucuꞌ yaa. ");
INSERT INTO zplNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Pero liꞌá Bene enu uxeꞌla Diose, rquiꞌña nú zecaa lunú nzu nú zecaa, pero ¡cueꞌe bene enu deteꞌ cuenda liꞌá para nú atia! ");
INSERT INTO zplNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chequie uquixie beella nú unidichiaꞌ beella lu saꞌbeella, ta beella neca enu deteꞌ cuenda liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Che uquixie beella nú uni beella lu saꞌbeella nú ta beella neca enu mase neca equie. ");
INSERT INTO zplNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero uni Jesuse lubeella: ―Lu iliulabe quieꞌ bee arre chiquiꞌ juerte rnibiyaꞌ beei lubee bene lachi beei, nu bee enu rnibiyaꞌ rni bee bene nú rriꞌi beei tucu nú rialane lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero liꞌihua la yala nú riꞌihua scua, enu máse neca equie letahua, rquiꞌña nú aca nzeꞌe enu lecati neca, nu enu rnibiyaꞌ rquiꞌña nú aca nzeꞌe xi neca tucu enu sibiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Lu iliulabe quieꞌ sucu bee patrón lu mexa, nu bee mosoꞌ sibiꞌ lubeei. Pero letaꞌahua la acane scua, xne liꞌá nzua cuna liꞌihua xi neca tucu enu sibiꞌ luhua. ");
INSERT INTO zplNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Liꞌihua necahua enu siempre nzu cuna liꞌá bee bichia nú nehuana ulleꞌcaa. ");
INSERT INTO zplNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Enzeꞌe liquia luhua lunú rnibiyaꞌa, tucu nú uliquiꞌ paa lunú rnibiyaꞌnu lua, ");
INSERT INTO zplNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nu acuhua lu mexa elu nibiyaꞌa nu leꞌca zucuhua lu xleta para nú hualuhuane lu cuendaꞌ ye bee bene enu nzeꞌta lu chiꞌchiucu familiꞌ bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Leꞌca uni Jesuse: ―Simón, Simón, ubiꞌyacuru, xne unacuꞌla bezeꞌlu liꞌihua lua para nú riꞌinui liꞌihua tucu nú rriꞌinu bene trigo chenu rcuillae. ");
INSERT INTO zplNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero uziquieelá lu Diose lu cuendaꞌlu para nú la tsanaꞌarquiꞌlu nú nzeli arquiꞌlu liꞌá. Nu chenu chili zeca arquiꞌlu liꞌá stucu bese, uriꞌi elietsa lubee saꞌlu para nú tsutaꞌ arquiꞌbeella lunú nzeli arquiꞌ beella liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chequie uni Pedro lunu: ―Detá, nzua para nú chaꞌa niꞌcuꞌ cuna liꞌilu, nu hasta nú atia cuna liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nu uni Jesuse lulla: ―Liꞌá nia lulu Pedro, nú rulaꞌ quieꞌ, ante nú bixia tiula, liꞌilu unilálu chuna bese nú la chululu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Che uni Jesuse lubeella: ―Chenu uxeꞌla liꞌihua né uyaꞌhua niꞌ tucu bolsa, niꞌ dimi niꞌ stucu para lucuhua, ¿nu xieꞌ nuꞌ nú uriꞌi falta liꞌihua la? Nu uni beella: ―Lecaxi uriꞌi falta liꞌiru. ");
INSERT INTO zplNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chequie uninu lubeella: ―Pero nee enu rluꞌcu dimi nu rluꞌcu biti, rquiꞌña nú uyaꞌ nzeꞌe nucuaꞌ. Nu enu la luꞌcu espada, uti nzeꞌe xucu nzeꞌe para nú tsi nzeꞌe tucue. ");
INSERT INTO zplNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Xne rquiꞌña nú yalu tucu nú niquiee lu ichiꞌ Stichiaꞌ Diose equie cuendaꞌ liꞌá elu rni: “Nu ubacuꞌ bee bene liꞌinu leta bee bene enu necha rriꞌi.” Ye nú nequie lu ichiꞌ Stichiaꞌ Diose equie cuendaꞌ liꞌá, rquiꞌña nú yalu nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chequie uni beella lunu: ―Caꞌa rluꞌcuru chiucu espada. Nu ucuaquinu lubeella: ―Cuna nucuaꞌtsia zibiꞌ quiꞌñiaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nu chu uchiuꞌu Jesuse nu nzanu dañi nú lee Olivos tucu nú neca costumbreꞌnu, nu nziquie bee beneꞌnu liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chenu uriña beella dañi zeꞌe uninu lubeella: ―Unaꞌcuhua lu Diose, para nú la riꞌi bezeꞌlu ana luhua. ");
INSERT INTO zplNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Che uchiuꞌu chunu lubeella nu nzanu xi neca tucu nú siꞌqui bene tucu quiee, nu chu utsulliquinu zeꞌe nu unacuꞌnu lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nu uninu: ―Paa, tunu laca arquiꞌlu, utsilaꞌa liꞌá lunú nehuana enta zecaa. Pero la riꞌilu tucu nú niarquia, uriꞌitsia tucu nú niarquiꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Che ulubeꞌlu tucu ángeleꞌ Diose liñibe lunu, nu uduꞌ nzeꞌe juerzaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nu chenu chiquiꞌ nehuana secanu, másela juerte rnacuꞌnu lu Diose, nu sanaꞌ inza nú suinzanu hasta lu yuu xi neca tucu gota réne. ");
INSERT INTO zplNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chenu utsulínu elu unacuꞌnu lu Diose, nzanu lubee beneꞌnu nu ullunaꞌnu liꞌibeella nú raꞌtse beella, xne néhuana nzu arquiꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nu uninu lubeella: ―¿Xinu raꞌtsehua? Uzetehua nu unacuꞌhua lu Diose para nú la riꞌi bezeꞌlu ana luhua. ");
INSERT INTO zplNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Rniscaꞌlá Jesuse lubeella, chenu uriña huaxi bee bene. Nu enu lee Judas, enu unga tucu bee beneꞌnu, liꞌi nzucului lu ye bee bene zeꞌe, nu chu uyabicai lu Jesuse para nú udacui bichiuꞌ xecanu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nu uni Jesuse lui: ―Judas, ¿xieꞌ cuna tucu bichiuꞌtsia deteꞌ cuendalu liꞌá Bene enu uxeꞌla Diose la? ");
INSERT INTO zplNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Che bee bene enu nucuaꞌa cuna Jesuse, chenu ulañiꞌ beella nú reca, necachi uni beella lunu: ―¿Detá, huaru espada para nú liunuꞌahua liꞌibeei la? ");
INSERT INTO zplNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chequie tucu bee beneꞌnu uchiecuꞌ diaca chubee tucu mosoꞌ uleꞌya enu rnibiyaꞌ lubeelá bee uleꞌya. ");
INSERT INTO zplNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero uni Jesuse lubeella: ―Necane nee, utsanaꞌhua beei. Che utiꞌnu yanu diaca bene zeꞌe nu uriꞌiyecanue. ");
INSERT INTO zplNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nu chu uninu lubee uleꞌya enu rnibiyaꞌ lubee uleꞌya, cuna lubee bene enu rnibiyaꞌ lubee bene enu rriꞌi ucu Indu llene Jerusalén, cuna lubee usticiaꞌ bee bene Israel, enu uriña nú uyaꞌ liꞌinu: ―¿Xinu nzeꞌtahua cuna espada nu cuna acarute para nú uyaꞌhua liꞌá xi neca tucu huanaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ye bichia nzua cuna liꞌihua liñi Indu llene Jerusalén nu ne naꞌtsehua liꞌá, pero nee uriña hora nú rnibiyaꞌ bezeꞌlu luhua. ");
INSERT INTO zplNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nu chenu unaꞌtse beei Jesuse, unguyaꞌ beei liꞌinu niꞌi uleꞌya enu rnibiyaꞌ lu beelá bee uleꞌya, nu istu nzequie Pedro liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Che ucuaꞌa bee bene quii labe eliꞌyaꞌ zeꞌe, nu ucuaꞌa beei ruꞌu quii zeꞌe, nu leꞌca uzucu Pedro cuna liꞌibeei zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nu chenu ulañiꞌ tucu criada liꞌilla nú nzuculla ruꞌu quii zeꞌe, riꞌyalinchu lulla nu uninchu: ―Leꞌca nuu bene quieꞌ enzee cuna Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ucachiꞌ Pedro nú unilla lu unaꞌa zeꞌe: ―La chulua nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sterratutsia, chenu ulañiꞌ stucu bene zeꞌe liꞌilla, che uni lulla: ―Leꞌca nuulu necalu tucu saꞌ beella. Pero ucuaqui Pedro nú unilla: ―Aꞌa déta, laca beneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chenu udete xi neca tucu hora, uni stucu bene lulla: ―Neli nú leꞌca nuu bene quieꞌ enzee cuna Jesuse, xne necalla bene Galilea. ");
INSERT INTO zplNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nu ucuaqui Pedro: ―La riꞌá beyaꞌ xi rnilu. Hora nú rni Pedro scua ubixia tiula. ");
INSERT INTO zplNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Che ubelleta Jesuse nu ubiꞌyanu lu Pedro, nu ulluꞌcu arquiꞌlla lunú uni Jesuse lulla: “Ante nú bixia tiula unilalu chuna bese nú la chululu liꞌá.” ");
INSERT INTO zplNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nu chu uchiuꞌu Pedro ruꞌu eliꞌyaꞌ zeꞌe, nu chiquiꞌ ungunaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bee bene enu rriucu Jesuse, udiquichiꞌquiꞌ beei liꞌinu, nu udiñi beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Utsacuꞌ beei lunu, nu udiñi beei liꞌinu nu unibeei lunu: ―¡Uriꞌi beyaꞌ ti udiñi liꞌilu! ");
INSERT INTO zplNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nu unibeei huaxilá bee bedichiaꞌ nú necha neca lunu. ");
INSERT INTO zplNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Chenu uyeꞌe lu yuu stucu bichia, uyetesaꞌ bee usticiaꞌ bee bene Israel cuna bee uleꞌya enu rnibiyaꞌ lubee uleꞌya, cuna bee ulaxcuela enu reca leyꞌ Moisés, nu uyayu beei Jesuse elu nucuaꞌa yebee usticiaꞌ beei. Zeꞌe unidichiaꞌ beei lunu: ");
INSERT INTO zplNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Uniꞌ luru, ¿liꞌilu necalu Cristo enu uxeꞌla Diose la? Nu ucuaqui Jesuse lubeei: ―Tunu nia luhua nú liꞌá neca Cristo enu uxeꞌla Diose, la chili arquiꞌhua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nu tunu nedichiaꞌa luhua la cuaquihua, nu leꞌca la laꞌahua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero desde nee Bene enu uxeꞌla Diose zucunu cueꞌtse Diose chubee enu rnibiyaꞌ lu yeene. ");
INSERT INTO zplNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chequie unidichiaꞌ ye beei lu Jesuse: ―¿Liꞌilu necalu Lliꞌñi Diose la? Nu ucuaqui Jesuse lubeei: ―Scua necane liꞌá nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Che unibeei: ―¿Para qué nú laꞌnalaꞌahua máse bee testigo nee? Nu leꞌca liaꞌahua ubeneꞌahua lunú uni nucuaꞌ scua. ");
INSERT INTO zplNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Che utsuli ye beei, nu uyayu beei Jesuse lu Pilato. ");
INSERT INTO zplNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Zeꞌe uquixie beei nú rricuꞌ quiya beei liꞌinu eluquichiaꞌ, nu unibeei: ―Ullunaꞌru benequieꞌ nú sequienu nucuaꞌ bee bene lachiaꞌahua. Nu rni nucuaꞌ nú la quiꞌña dixiuꞌahua bee impuesto lu gobernador César, nu leꞌca rni nucuaꞌ nu neca nucuaꞌ Cristo cuna arre. ");
INSERT INTO zplNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nu unidichiaꞌ Pilato lunu: ―¿Liꞌilu necalu arreꞌ bee bene Israel la? Nu ucuaqui Jesuse nú uninu: ―Liꞌá nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Che uni Pilato lubee uleꞌya enu rnibiyaꞌ lubee uleꞌya, cuna lu ye bee bene: ―La llelaa niꞌ tucu falta nú uriꞌi benequieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero liꞌibeei máse juerte unibeei: ―Nucuaꞌ sequienu ye bee bene cuna lunú seteꞌ nucuaꞌ. Uquixie nucuaꞌ nú rriꞌi nucuaꞌ scua desde Galilea, nu leꞌca scua rriꞌi nucuaꞌ caꞌa Judea. ");
INSERT INTO zplNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chequie chenu ubeneꞌ Pilato nucuaꞌ, unidichiaꞌlla lubeei tunu neca Jesuse bene lu iliu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nu chenu unibeei nú necanu bene Galilea, uxeꞌla Pilato liꞌinu lu arre Herodes enu rnibiyaꞌ lu iliu Galilea, xne bee bichia zeꞌe nzucu Herodes Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Chenu ulañiꞌ arre Herodes Jesuse chiquiꞌ ñia utsu arquiꞌlla, xne hasta huaꞌtu niarquiꞌlla nú lañiꞌlla liꞌinu. Nu ubeneꞌlaꞌlla nú rni bee bene lu cuendaꞌnu, nu nzuquiella nú riꞌinu tucu milagro. ");
INSERT INTO zplNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Huaxi nú unidichiaꞌlla lu Jesuse, pero lecaxi ucuaquinu. ");
INSERT INTO zplNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Leꞌca zeꞌe nucuaꞌa bee uleꞌya enu rnibiyaꞌ lubee uleꞌya, cuna bee ulaxcuela enu reca leyꞌ Moisés, nu la tsuxe beei nú rricuꞌquiya beei liꞌinu eluquichiaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chequie arre Herodes cuna bee sundadoꞌlla chiquiꞌ necha uriꞌinu beei Jesuse, nu ungutu beei liꞌinu laquie fiñu nú rutu bee arre, nu xitse uriꞌchia beei liꞌinu, nu chu uxeꞌla zeca arre Herodes liꞌinu lu Pilato. ");
INSERT INTO zplNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bichia zeꞌe uyuꞌu nú uquieteꞌ arre Herodes Pilato, pero ante nú aca bee nucuaꞌ, rlee beella lu saꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Chequie unibiyaꞌ Pilato nú uyete saꞌ bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee usticiaꞌ bee bene Israel, cuna ye bee bene yeche. ");
INSERT INTO zplNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nu unilla. ―Liꞌihua uriñayuhua benequieꞌ, nu unihua nú sequienulla bee bene. Pero ante lu yehua unidichiaꞌa lulla nu la llelaa niꞌ tucu nú xi uriꞌilla, tucu nú rnihua lu cuendaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nu leꞌca esquie arre Herodes. Enzeꞌe uxeꞌla zecalla benequieꞌ lua. Ulañiꞌhua nee nú la luꞌculla niꞌtucu equiya nú uriꞌilla para nú atilla. ");
INSERT INTO zplNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nee detea castiya liꞌilla, nu chu laꞌa liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Bee bichia liñi baxcu zeꞌe rlaꞌa Pilato tucu bene tucu nú neca costumbreꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero ye beei uquixie beei urixialibeei nú unibeei: ―¡Ati benecuaꞌ! ¡Nu ulaꞌa Barrabás! ");
INSERT INTO zplNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás quieꞌ unibiyaꞌ bee usticia nú uyuꞌi niꞌcuꞌ equie nú uliunui bee usticia eyeche Roma nu uliunuu bee benecuaꞌ eyeche Jerusalén, cuna equie nú unguuti bene. ");
INSERT INTO zplNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Niarquiꞌ Pilato nú laꞌalla Jesuse, nu uni zecalla lubeei stucu bese, ");
INSERT INTO zplNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","pero máse juerte urixialibeei nú unibeei: ―¡Uquieꞌe nucuaꞌ lu cruse! ¡Uquieꞌe nucuaꞌ lu cruse! ");
INSERT INTO zplNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bese rriuna uni Pilato lubeei: ―Pero ¿ta nú necha neca uriꞌi nucuaꞌ che? La llela niꞌ tucu nú xi uriꞌi nucuaꞌ para nú yala nú ati nucuaꞌ, detea castiya nucuaꞌ nu che laꞌalla. ");
INSERT INTO zplNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero máse urixialibeei nú unibeei lu Pilato nú quieꞌella Jesuse lu cruse. Equie nú urixiali bee benecuaꞌ scua cuna bee uleꞌya enu rnibiyaꞌ lubee uleꞌya, enzeꞌe uriꞌi beei ana nú unga lunú niarquiꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Che ulaca arquiꞌ Pilato nú riꞌilla tucu nú niarquiꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Scua uriꞌilla tucu nú niarquiꞌ bee bene zeꞌe, ulaꞌalla Barrabás enu uyuꞌu niꞌcuꞌ equie nú uriꞌi xuu cuna nú unguuti bene, nu udeteꞌ cuendalla Jesuse lubeei para nú riꞌi beei lunú niarquiꞌ beei cuna liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Chenu unguyaꞌ beei Jesuse para nú quienu lu cruse, unibeei lu tucu bene eyeche Cirene, enu lee Simón. Nu nzeꞌtalla enza dañi, nu unibeei nú riꞌilla elietsaꞌnu uyaꞌlla cruseꞌnu nu chequiella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Huaxi bee bene uyaquie liꞌinu, nu huaxi bee unaꞌa runaꞌ nu rixiali beenchu xne ruꞌa arquiꞌ beenchu liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero ubiꞌya Jesuse lu beenchu nu uninu: ―Bee unaꞌa Jerusalén, la unaꞌhua lu cuendaꞌ liꞌá, unaꞌhua equie cuendaꞌ liꞌihua cuna lu cuendaꞌ bee lliꞌñihua. ");
INSERT INTO zplNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Xne nzeꞌta bichia nú ni bee bene: “Ñia nza lu cuendaꞌ bee unaꞌa enu lá luꞌcu bee enduꞌ, cuna bee unaꞌa enu la chuꞌu enduꞌ xlaꞌcu, cuna bee unaꞌa enu lá riꞌi ruꞌcu bee enduꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chequie quixie bee bene nú ni beei lubee dañi: “¡Uzanaꞌhua equieru!”, nu ni beei lubee loma: “¡Ucaꞌchiꞌhua liꞌiru!” ");
INSERT INTO zplNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nu tunu liꞌá rriꞌinu beei scua, ¿enza laquieꞌ liꞌihua nú la riꞌinu bee bene liꞌihua scua? ");
INSERT INTO zplNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Leꞌca nzeyu beei chiucu huanaꞌ para nú quieꞌe beei bee nzeꞌe lubee cruse, cuna Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Chenu uriña beei luhuare elu lee calabera, uquieꞌe beei Jesuse lu cruse cuna rucu bee huanaꞌ zeꞌe lu tucua cruse. Tucu nzeꞌe uquieꞌe beei cueꞌtsenu chúbee, nu stucu nzeꞌe cueꞌtsenu chúbeca. ");
INSERT INTO zplNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nu chenu rquieꞌe beei Jesuse lu cruse uninu: ―Paa, uriꞌi perdona bee benequieꞌ xne la riꞌi beei beyaꞌ lunú rriꞌi beei. Che urita bee sundado tucu rifa para nú uritsiꞌ beei xucunu lu saꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nu nucuaꞌa bee bene riꞌya zeꞌe, nu hasta bee usticia utsequichiaꞌ beei Jesuse, nu unibeei lunu: ―Utsilaꞌa nucuaꞌ stucu bee bene, puese tsilaꞌi liꞌi nee, tunu neli nú necai Cristo enu ucañi Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Leꞌca xitse uriꞌinuu bee sundado zeꞌe liꞌinu, nu uyabica beei lunu nu udeteꞌ beei vinagre para nú güeꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nu unibeei lunu: ―¡Tunu liꞌilu necalu arreꞌ bee bene Israel, utsilaꞌa leꞌcatsia liꞌilu! ");
INSERT INTO zplNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nu niquie tucu letrero equie cruseꞌnu, cuna bedichiaꞌ griego cuna latín, cuna hebreo, nú rni: “Benequieꞌ neca arreꞌ bee bene Israel.” ");
INSERT INTO zplNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tucu bee huanaꞌ enu niquie lú cruse uni bedichiaꞌ nú necha neca lu Jesuse: ―¡Tunu liꞌilu necalu Cristo, utsilaꞌa liꞌilu nu utsilaꞌa liꞌiru! ");
INSERT INTO zplNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero stucui uriꞌi nú uquiꞌyaꞌi nu uni lusaꞌi: ―¿Xieꞌ la lliquilu Diose añinzuca nú leꞌca secalu castiya cuaꞌla? ");
INSERT INTO zplNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Neli nú riala zeꞌcaꞌa castiya quieꞌ, xne scua riala nú rixiuꞌa beenú uriꞌá, pero benequieꞌ lá riꞌi niꞌ tucu nú necha neca. ");
INSERT INTO zplNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nu uni lu Jesuse: ―Jesuse, ulluꞌcuꞌ arquiꞌ liꞌá chenu quixie nú nibiyaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Che uni Jesuse lui: ―Liꞌá nia lulu, nú nee bichiaquieꞌ nzulu cuna liꞌá liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Chenu unga rebibichia, diqui lu iliulabe ucabelí hasta rquiechuna uchee. ");
INSERT INTO zplNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ucabe lu bichia, nu utsaa arliꞌtiꞌlluu cortina nú nziꞌqui liñi Indu llene Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nu juerte urixiali Jesuse nú uninu: ―¡Paa, yalu tsaꞌna espíritua! Chenu uninu scua, chu ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chenu ulañiꞌ capitañi enu rnibiyaꞌ lubee sundado romano lunú unga, che uni bedichiaꞌ nzeꞌca lu Diose nú uni: ―Neli nú né riꞌi benequieꞌ niꞌ tucu nú necha neca. ");
INSERT INTO zplNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ye bee bene enu nucuaꞌa zeꞌe, chenu ulañiꞌ beei nú ungae scua, chu nziue beei nu xutse beei ya beei latsa beei. ");
INSERT INTO zplNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero ye bee bene enu nuꞌlu Jesuse, cuna bee unaꞌa enu uyaquiee liꞌinu desde Galilea, istu ucuaꞌa beella ubiꞌya beella lu ye nú unga scua. ");
INSERT INTO zplNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Uhuañi tucu bene enu neca bene nzeꞌca, nu uriꞌilla tucu nú rialane lu Diose. Liꞌilla leella José. Nu lachilla lee Arimatea, nú nchiñi lu iliu Judea, nu ungalla tucu bee usticiaꞌ bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","José quieꞌ nzuquiee lunú rnibiyaꞌ Diose. Enzeꞌe la nzulla chúꞌ bee usticia enu unibiyaꞌ nú unguti Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chequie uyaalla unilla lu Pilato para nú unacuꞌlla cuerpoꞌ Jesuse lu Pilato. ");
INSERT INTO zplNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chenu ulaxu nú ulacalla cuerpoꞌ Jesuse lu cruse, che utelalla tucu sabana fiñu cuerpoꞌnu, nu uyacaꞌchiꞌ beella cuerpoꞌnu liñi tucu eluhua nú nedaꞌñi liñi tucu quiee, elu lascaꞌ achiꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Bichia zeꞌe neca bichia xee nú sulachi bee bene Israel, nu stemeꞌtsia rriꞌi nú quixiee bichia nú sulachi bee bene chenu uyacaꞌchiꞌ beella Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bee unaꞌa enu uyaquiee Jesuse desde Galilea, uya beella nu ulañiꞌ beella eluhuaꞌ Jesuse, nu leꞌca ulañiꞌ beella xa uricu cuerpoꞌnu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nu chenu ubenchilaꞌ beella, urecheꞌ beella perfume nú ñia rlia cuna ungüento. Nu chu utsulachi beella bichia nú sulachi bee bene Israel, tucu nú rnibiyaꞌ ley. ");
INSERT INTO zplNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo silaꞌ stucu bichia, uya bee unaꞌa zeꞌe ruꞌu eluhuaꞌ Jesuse, nu unguyaꞌ beella perfume nú urecheꞌ beella, nu leꞌca uyanu beella xiucu xuna bee unaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chenu uriña beella zeꞌe, ulañiꞌ beella nú uducuꞌla quiee llene nú uyacuꞌ ruꞌu eluhua zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nu uyuꞌu beella liñi eluhua zeꞌe, pero né lleꞌlaꞌ beella cuerpoꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hora zeꞌe chenu xiqui beella nu la riꞌi beella beyaꞌ xa riꞌi beella, ulañiꞌ beella chiucu niyu enu nzulí axu lubeella, nutu bee nzeꞌe laquie nú rulu siquiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nu lunú chiquiꞌ ulliqui beella uziꞌqui ndiqui beella hasta lu yuu, nu uni bee niyu zeꞌe lubeella: ―¿Xinu rlaꞌnahua tucu bene enu nehuañi leta bee bene nguti? ");
INSERT INTO zplNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Lecaꞌnu caꞌa, xne uhuañi zecanu. Ulluꞌcu arquiꞌhua lunú uninu luhua chenu nzuscaꞌnu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Uninu luhua nú liꞌinu Bene enu uxeꞌla Diose, rquiꞌña nú dete cuendanu lubee bene enu rriꞌi dula para nú quieꞌe beei liꞌinu lu cruse, nu acatsia bichia rriuna huañi zecanu. ");
INSERT INTO zplNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Che ulluꞌcuꞌ arquiꞌbeella bedichiaꞌ nú uni Jesuse lubeella, ");
INSERT INTO zplNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","nu chenu nzia beella nú uchiuꞌu beella ruꞌu eluhua zeꞌe udixiuleꞌe beella ye nú ulañiꞌ beella lu se chetuꞌcu bee beneꞌnu cuna lu beelá bee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María Magdalena, cuna Juana, cuna María naꞌ Jacobo, cuna beela bee unaꞌa, neca beella enu uyayu resuna cuaꞌ lubee apóstolꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero né chili arquiꞌbeella lunú uni bee unaꞌa cuaꞌ, xne seca beella nú lia rnitsia beella nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero xexuꞌu Pedro uyabiꞌya ruꞌu eluhua zeꞌe, nu chenu ubiꞌyalla liñii, ulañiꞌtsialla sabana nú ubelanu nchiucuꞌ zeꞌe, nu ubenchilaꞌlla nu chiquiꞌ nzenu arquiꞌlla lunú ulañiꞌlla nu unga scua. ");
INSERT INTO zplNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Leꞌca bichia zeꞌe, chiucu beneꞌ Jesuse nzuebeella lu eyeche nú lee Emaús, eyeche cuaꞌ neca tucu chetuꞌcu kilómetro para Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chenu nzuebeella lu inziu rdichiaꞌ beella lu ye nú unga. ");
INSERT INTO zplNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Diqui nú rdichiaꞌ beella, uyabica Jesuse lubeella nu uquixienu nú nzenunu liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Añinzuca nú riꞌya beella lunu, pero la zela Diose nú luego chulu beella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nu unidichiaꞌ Jesuse lubeella: ―¿Xi equie rdichiaꞌhua diqui nú nzeꞌtahua inziu? Nu xinu nehuana nzu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tucu beella enu lee Cleofas, ucuaqui: ―Ye bee bene nediyaꞌ lunú unga eyeche Jerusalén bee bichiaquieꞌ. ¿Xieꞌ liꞌitsialu enu uzucu Jerusalén lá riꞌilu beyaꞌ lunú unga zeꞌe la? ");
INSERT INTO zplNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nu unidichiaꞌnu lubeella: ―¿Xi unga che? Nu uni beella lunu: ―Lunú uriꞌinu bee bene Jesuse enu neca bene eyeche Nazaret, liꞌinu unganu tucu profeta enu chiquiꞌ reca lunú uriꞌinu cuna bee bedichiaꞌ nú uninu lu Diose, cuna lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nu bee uleꞌya enu rnibiyaꞌ lubee uleꞌya cuna bee usticiaꞌru, udeteꞌ cuenda beella liꞌinu para nú atinu nu uquieꞌe beella liꞌinu lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Liꞌiru nzu arquiꞌru nú liꞌinu a tsilaꞌanu bee bene Israel. Pero nee necala bichia rriuna nú unga ye bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Añinzuca nú texcuaꞌa bee unaꞌa enu nucuaꞌa cuna liꞌiru uchiiqui beella liꞌiru, xne nee zilaꞌ quieꞌ uya beella ruꞌu eluhuaꞌnu, ");
INSERT INTO zplNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nu lunú néllelaꞌ beella cuerpoꞌnu, ubenchilaꞌ beella nu uni beella nú ulubeꞌlu bee ángele lubeella, uni bee ángele cuaꞌ lu beella nú nehuañi Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Che uya chiucu chuna bee saꞌru uyabiꞌya ruꞌu eluhua zeꞌe, nu ulañiꞌ beella tucu nú uni bee unaꞌa zeꞌe, pero né lañiꞌ beella Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nu uni Jesuse lubeella: ―¡Chiquiꞌ lleꞌnatsia rriꞌihua beyaꞌ, nu rleꞌe nzeli arquiꞌhua ye bee nú uni bee profeta hasta huaꞌtu! ");
INSERT INTO zplNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Xieꞌ la quiꞌña nú nehuana zeca Jesucristo ye bee nucuaꞌ nu cheelá zucunu liñibe la? ");
INSERT INTO zplNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Che uquixienu udixiuleꞌenu xi rni ye nú niquie lu ichiꞌ Stichiaꞌ Diose lu cuendaꞌnu. Uquixienu cuna bee libro nú uquieꞌe Moisés, nu chu uquixiaꞌlanu cuna ye bee libro nú uquieꞌe bee profeta. ");
INSERT INTO zplNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chenu uriña beella eyeche nú nza beella, uriꞌi Jesuse tucu nú nzalanu enza lu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero uriꞌi beella juerza liꞌinu nú yaꞌnanu cuna liꞌibeella, nu uni beella lunu: ―Uyaꞌna cuna liꞌiru, xne ucheela nu enta chuꞌula rulaꞌ. Che uyuꞌu Jesuse nu uyaꞌnanunu liꞌi beella. ");
INSERT INTO zplNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nu chenu nzucunu lu mexa cuna liꞌibeella unaꞌtsenu pá, nu chenu ulaxu nú udeteꞌnu cheꞌtsa lu Diose, che uleꞌenu pá zeꞌe nu udeteꞌnue udacubeellae. ");
INSERT INTO zplNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hora zeꞌe ulleꞌca beella xi neca nú uyaꞌla iꞌculu beella nu uyulu beella liꞌinu, pero tuꞌnatsia unitinu lubeella. ");
INSERT INTO zplNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nu uni beella lu saꞌbeella: ―Enzeꞌeca nú chenu nzelayuaꞌa liꞌinu lu inziu ñia utsiꞌa chenu uninu nú xa rni lunú rni lu ichiꞌ Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chequie leꞌca hora zeꞌe, chu uyuꞌunziu beella nu ubenchilaꞌ beella eyeche Jerusalén, elu neyeteꞌ saꞌ sechetuꞌcu bee beneꞌnu cuna beelá bee saꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nu uni bee bene enu nucuaꞌa zeꞌe lu rucu beella: ―Neli nú uhuañi zeca Jesuse, xne ulubeꞌlulanu lu Simón. ");
INSERT INTO zplNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nu chu udixiuleꞌe rucu bene zeꞌe lubeella lunú unga chenu nzuebeella lu inziu, cuna nú xa uyuꞌlu beella Jesuse chenu uleꞌenu pá. ");
INSERT INTO zplNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Rdichiaꞌscaꞌ beella lunú unga, chenu ulubeꞌlu Jesuse lubeella, nu uninu lubeella: ―La lliquihua ñia utsu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Chiquiꞌ ulliqui beella nu leꞌca uyanu arquiꞌbeella, xne uriꞌi beella elliebacuꞌ nú ulañiꞌ beella tucu espírituꞌ bene enu unguti. ");
INSERT INTO zplNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero uni Jesuse lubeella: ―¿Xinu xiquihua? nu ¿xinu saꞌ arquiꞌhua? ");
INSERT INTO zplNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ubiꞌyacuruhua bee yaa cuna bee cuchiuꞌa. Liꞌá ninguieꞌ, unaꞌtsehua liꞌá nu ubiꞌyahua lua xne tucu espíritu la acane arta cuna beꞌla tucu nú rlañiꞌhua liꞌá nee. ");
INSERT INTO zplNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chenu uninu scua, che ulubeꞌnu bee yanu cuna bee cuchiuꞌnu lubeella. ");
INSERT INTO zplNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero lá chiliscaꞌ arquiꞌbeella nu liꞌinu lunú ñia nzu arquiꞌ beella cuna nú nzenu arquiꞌbeella, che uninu lubeella: ―¿Rluꞌcuhua lleꞌna nú acua la? ");
INSERT INTO zplNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nu chu udeteꞌ beella teleꞌe bela enu uyiꞌi cuna teleꞌe lliñia, ");
INSERT INTO zplNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","che unaꞌtsenu bela zeꞌe cuna lliñia zeꞌe nu udacunue ante lubeella. ");
INSERT INTO zplNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nu uninu lubeella: ―Lunú ulleꞌca ye bee nucuaꞌ unia luhua chenu nzuscaꞌa cuna liꞌihua. Nu rquiꞌña nú yalu ye beenú niquie lu ichiꞌ Stichiaꞌ Diose equie cuendaa nú nequie lu libroꞌ Moisés, cuna lu libroꞌ bee profeta, cuna lu libro salmos. ");
INSERT INTO zplNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nu uxaꞌlanu elliebacuꞌ beella para nú uriꞌi beella beyaꞌ lunú rni Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Che uninu lubeella: ―Lu ichiꞌ Stichiaꞌ Diose rni nú chiquiꞌ nehuana zeca Cristo, nu acatsia bichia rriuna huañi zecanu leta bee bene nguti. ");
INSERT INTO zplNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nu desde Jerusalén quixie bee bene ixiuleꞌe stichiaꞌa cuna diqui lu iliulabe, nú rquiꞌña nú tsanaꞌ arquiꞌ bee bene stula beei, nu chili arquiꞌbeei liꞌá para nú riꞌi Diose perdona liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Liꞌihua ulañiꞌhua ye bee nucuaꞌ, nu ixiuleꞌehua lubee bene bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nu liꞌá xeꞌla luhua lunú ucuaqui uꞌna paa. Pero uyaꞌnascaꞌhua caꞌa eyeche Jerusalén hasta nú yucuhua lunú rnibiyaꞌ Diose nú nzeꞌta liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Che uchiuꞌu Jesuse cuna liꞌibeella eyeche Jerusalén, nu unguyaꞌnu liꞌibeella axu Betania, nu uletsanu yanu nu uriꞌi leꞌyanu liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Diqui nú rriꞌileꞌyanu liꞌibeella, uyatsanu nu uquienu liñibe. ");
INSERT INTO zplNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chequie chenu ulaxu nú udeteꞌ beella ulaꞌna lunu, chiquiꞌ ñia nzu arquiꞌbeella ubenchilaꞌ beella eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nu ye bichia nucuaꞌa beella liñi Indu llene Jerusalén nu rni beella bedichiaꞌ nzeꞌca lu Diose, nu rdeteꞌ beella cheꞌtsa lunu. Amén.");
INSERT INTO zplNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ante nú quixie iliulabe nzula tucu enu neca bedichiaꞌ, nu liꞌinu nzulanu cuna Diose nu necanu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Liꞌinu enu neca bedichiaꞌ nzulanu cuna Diose ante nú quixie iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ye beenú nuꞌ equie cuendaꞌ liꞌinu ungacheꞌ bee nucuaꞌ. Nu niꞌtucu bee lunú nuꞌ lá acacheꞌ tunu leca liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Liꞌinu rluꞌcunu elunehuañi, nu elunehuañicuaꞌ neca ellieꞌe para lu yebee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nu ellieꞌe cuaꞌ rduꞌllieꞌe lubee bene mase nú necabe nzu elliebacuꞌbeei, pero lá riꞌi nú natsacabecuaꞌ ana lu ellieꞌecuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Uhuañi tucu bene enu lee Juan, enu ucañi Diose, ");
INSERT INTO zplNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","para nú ungalla enu udixiuleꞌe equie cuendaꞌ ellieꞌ Diose nu liꞌilla udixiuleꞌella nucuaꞌ para nú chili arquiꞌ yebee bene ellieꞌe cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pero la aca Juan ellieꞌ Diose, ungatsialla enu ubeꞌtatixiuleꞌe lubee bene equie cuendaꞌ ellieꞌecuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Xne enu mero neca ellieꞌecuaꞌ, rduꞌllieꞌenu elliebacuꞌ yebee bene iliulabe, nu ubeꞌtalanu lu iliulabe quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Liꞌinu ubeꞌtanu lu iliulabe, nu añinzuca nú equie cuendaꞌ liꞌinu ungacheꞌ iliulabe, pero né zela bee bene iliulabe achuꞌlubeei liꞌinu tucu nú riala nú achuꞌlubeei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ubeꞌtanu lubee bene lachinu, nu né riꞌibeei caso liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero yebee bene enu uriꞌi caso liꞌinu cuna nú uyalí arquiꞌ liꞌinu, liꞌinu uriꞌinu nú neca beella lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nu neca beella lliꞌñi Diose, nu la necane equie cuendaꞌ nú neca beella lliꞌñi bene iliulabe, urre nú niarquiꞌ bene urre rriꞌi bee bene elliebacuꞌ nú luꞌcu bene enduꞌ sino que lunú nzelíla arquiꞌbeella liꞌinu neca beella lliꞌñinu. ");
INSERT INTO zplNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Liꞌinu enu neca bedichiaꞌ unganu bene, nu uhuañinu lu iliulabe cuna liaꞌahua, llene neca elusecaꞌnu, uninu puro nú neli neca. Liꞌiru ulañiꞌru lunú rnibiyaꞌnu nu uyucunu elurnibiyaꞌ, xne liꞌitsianu necanu Lliꞌñi eꞌcu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Chenu udixiuleꞌe Juan equie cuendaꞌ liꞌinu lubee bene, liꞌilla unilla: ―Jesuse quieꞌ neca enu unia chenu unia luhua nú enu nzeꞌta lulá máse neca equienu luquela liꞌá, xne hasta huaꞌtu nzulanu luquela liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Chiquiꞌ llene neca elusecaꞌnu luaꞌahua, yebichia riucuaꞌahua ye eluxeneꞌnu nú rliquiꞌnu luyeaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Equie cuendaꞌ Moisés uliquiꞌ Diose leyꞌnu luaꞌahua. Pero equie cuendaꞌ Jesucristo uriꞌi nzeꞌcaꞌahua beyaꞌ xa neca elusecaꞌnu luaꞌahua, nu uriaꞌahua beyaꞌ ta nú neli neca. ");
INSERT INTO zplNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Niꞌtucu bene leca xunga ulañiꞌ Diose, tucutsia Lliꞌñinu enu nzucu cuna liꞌinu ulubeꞌ luaꞌahua xa neca Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Chequie desde Jerusalén bee usticiaꞌ bee bene Israel, uxeꞌla beella bee uleꞌya cuna chiucu chuna bee bene Levitas para nú uya beella lu Juan Bautista unidichiaꞌ beella nú ti necalla. ");
INSERT INTO zplNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nu liꞌilla unilla ye nú neli neca lubeella, nu unilla: ―Liꞌá la neca Cristo. ");
INSERT INTO zplNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Che unidichiaꞌ zeca beella lu Juan: ―¿Ti necalu che? ¿Liꞌilu necalu Elías la? Nu ucuaquilla: ―Laca bene zeꞌe. Nu unibeella lulla: ―¿Urre liꞌilu necalu profeta enu nzu nú nzeꞌta la? Nu ucuaquilla lubeella: ―Laca bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nu unibeella lulla: ―¿Ti necalu che? Xne rquiꞌña nú nzeyuru resuna lubee bene enu uxeꞌla liꞌiru. ¿Udixiuleꞌe luru ti necalu? ");
INSERT INTO zplNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Chequie uni Juan lubeella: ―Liꞌá neca tucu enu juerte rixiali lu tucu dañi achi elu lecati nucuaꞌa: “Ulihua inziuꞌ Diose Pa liñibe” ―tucu nú uni profeta Isaías hasta huaꞌtu. ");
INSERT INTO zplNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Chequie bee bene enu uxeꞌla bee fariseo para nú nzebedichiaꞌnu Juan, ");
INSERT INTO zplNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","nú unedichiaꞌ beella lu Juan: ―Tunu lacalu Cristo, niꞌ Elías, niꞌ profeta enu nzu nú nzeꞌtalá, ¿xiquie nú rrinzalu bee bene che? ");
INSERT INTO zplNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Che ucuaqui Juan nú unilla lubeella: ―Liꞌá rrinza bee bene cuna inza, pero letahua nzu tucu enu lascaꞌ chuluhua, ");
INSERT INTO zplNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","nu liꞌinu necanu enu nzeꞌta lulá, nu niꞌ nú hua lucunu la yalaa, xne liꞌinu maselá neca equienu luquela liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yebee nucuaꞌ unga tucu luhuare elu lee Betábara, stucu chú reꞌcu Jordán, elu urinza Juan bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chenu uyeꞌe luyuu stucu bichia, ulañiꞌ Juan nú nzeꞌtabica Jesuse elu nzulla, nu unilla: ―¡Ubiꞌyacuruhua, benequieꞌ neca Corderoꞌ Diose enu chila stula bee bene iliulabe! ");
INSERT INTO zplNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Equie cuendaꞌ liꞌinu unia luhua chenu unia: “Lulá nzeꞌta tucu bene enu másela neca equie lua, xne hasta huaꞌtu nzulanu luquela liꞌá.” ");
INSERT INTO zplNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Niꞌ liꞌá lá riꞌá beyaꞌ nú liꞌinu necanu enu nzu nú nzeꞌta, pero liꞌá uriñaa para nú rinza bee bene cuna inza para nú chulu bee bene Israel liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Leꞌca uni Juan lubeei: ―Liꞌá ulañia nú ulaca Espíritu Santo enza liñibe xi neca tucu paloma equienu. ");
INSERT INTO zplNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Añinzuca nú lá chulua liꞌinu, pero enu uxeꞌla liꞌá para nú rinza bee bene cuna inza, liꞌinu uninu lua: “Chenu lañiꞌlu nú laca Espíritu Santo equie tucu bene nu yaꞌnane equiella, liꞌilla necalla enu rinza bee bene cuna Espíritu Santo.” ");
INSERT INTO zplNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Liꞌá ulañilánu, nu nediya nzeꞌca nú liꞌinu necanu Lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chenu uyeꞌe lu yuu stucu bichia, nzu zecaꞌla Juan zeꞌe cuna chiucu bee beneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Chenu ulañiꞌlla nú nzedete Jesuse zeꞌe, chequie unilla: ―¡Ubiꞌyacuruhua! Benequieꞌ neca Corderoꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chenu ubeneꞌ rucu beneꞌ Juan nucuaꞌ, che nzequie beella Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nu chenu ubelleta Jesuse, ulañiꞌnu nú nzeꞌtaquie beella liꞌinu, nu uninu lubeella: ―¿Xi rlaꞌnahua? Nu ucuaqui beella: ―Maestro, ¿cá nzuculu? ");
INSERT INTO zplNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Che ucuaqui Jesuse lubeella: ―Utehua para nú lañiꞌhua. Chequie uya beella nu ulañiꞌ beella elu nzucunu, nu uyaꞌnanu beella liꞌinu zeꞌe bichia zeꞌe, xne necala tucu rquietacu uchee. ");
INSERT INTO zplNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tucu lu rucu beneꞌ Juan enu uyaquie Jesuse, enu ubeneꞌ lunú uni Juan, liꞌi necai Andrés bichi Simón Pedro. ");
INSERT INTO zplNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés quieꞌ rluti uya laꞌnai bichi Simón Pedro nu uni lulla: ―Ullelaꞌlaꞌru Mesías ―nu rni bedichiaꞌ cuaꞌ Cristo. ");
INSERT INTO zplNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chequie Andrés unguyaꞌ Simón elu nzu Jesuse, nu che ulañiꞌ Jesuse liꞌilla nu uninu: ―Liꞌilu necalu Simón, llianaꞌ Jonás, pero nee chiuꞌuleelu Cefas ―nu rni bedichiaꞌ cuaꞌ Pedro. ");
INSERT INTO zplNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chenu uyeꞌe luyuu stucu bichia uriꞌila Jesuse elliebacuꞌ nú nzanu Galilea, nu ullaꞌcanu Felipe nu uninu lulla: ―Utequie liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe quieꞌ neca bene eyeche Betsaida, elu leꞌca neca lachi Andrés cuna Pedro. ");
INSERT INTO zplNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nu che uya laꞌna Felipe Natanael, nu unilla lui: ―Ullelaꞌlaꞌru bene enu rni Moisés lu libro ley, leꞌca liꞌilla enu uni bee profeta enu uquieꞌe Stichiaꞌ Diose. Liꞌinu necanu Jesuse lliꞌñi José bene eyeche Nazaret. ");
INSERT INTO zplNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Che ucuaqui Natanael: ―¿Xieꞌ nuꞌ bene nzeꞌca eyeche Nazaret la? Nu uni Felipe lulla: ―Utecuru ne lañiꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Chenu ulañiꞌ Jesuse nú nzeꞌta Natanael, uninu: ―Caꞌa nzeꞌta tucu bene enu neli neca bene Israel, enu la zequiee. ");
INSERT INTO zplNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Chequie unidichiaꞌ Natanael lunu: ―¿Xaquie nuꞌlulu liꞌá? Nu ucuaqui Jesuse lulla: ―Ante nú bixia Felipe liꞌilu chenu nzulu rquiꞌ tucu aca higuera, che ulañia liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nu uni Natanael lunu: ―Maestro, ¡liꞌilu necalu Lliꞌñi Diose, liꞌilu necalu arre Israel! ");
INSERT INTO zplNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Che ucuaqui Jesuse nú uninu: ―Liꞌilu nzeli arquiꞌlu liꞌá lunú unitsia lulu nú ulañia liꞌilu rquiꞌ tucu aca higuera. Pero nzeꞌta nú huaxilá nú lañiꞌlu luquela nú ulañiꞌlalu. ");
INSERT INTO zplNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Leꞌca uni Jesuse lulla: ―Liꞌá nediyanzeꞌca nú liꞌihua lañiꞌhua nú naꞌla liñibe, nu leꞌca lañiꞌhua bee ángeleꞌ Diose, nú rquiee beenu nu rlaca beenu equie Bene enu uxeꞌla Diose lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bichia rriuna, unga tucu eluchia eyeche Caná nú nchiucuꞌ lu iliu Galilea. Nu leꞌca nzu naꞌ Jesuse zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","nu leꞌca uzeneꞌ bee bene Jesuse cuna bee beneꞌnu nu uya beella lu eluchia zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chenu ulaxu biñu, che uni naꞌ Jesuse lunu: ―La lucuaꞌ beella biñu. ");
INSERT INTO zplNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nu ucuaqui Jesuse: ―¿Xinu rnilu nucuaꞌ lua naa? Lascaꞌ riña hora nú riꞌá lunú riala nú riꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pero María naꞌ Jesuse chu unilla lubee bene enu rriꞌi elietsa zeꞌe: ―Uriꞌihua ye nú ninu luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nu zeꞌe nucuaꞌa xuꞌcu etsu quiee, nú riucheꞌ inza rquiꞌña bee bene Israel para nú lecaxi naa beei tucu nú neca costumbreꞌ beei, nu riuꞌu como tucu ayuꞌu litro inza liñi cada tucua bee etsu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chequie uni Jesuse lubee bene enu rriꞌi elietsa zeꞌe: ―Uriꞌichehua bee etsuquieꞌ inza. Nu chenu uchela bee etsu, ");
INSERT INTO zplNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","uni Jesuse lubeei: ―Nee uhuahua lleꞌnae, udeꞌteꞌhua lubee bene enu nuyaꞌ cuendaꞌ eliñi. Nu scua uriꞌi beei. ");
INSERT INTO zplNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nu bene enu nuyaꞌ cuenda eliñi zeꞌe uriꞌilla preo inza nú unga biñu, nu lá riꞌilla beyaꞌ cá enza uchiuꞌe, nediyaꞌtsia bee bene enu rriꞌi elietsa zeꞌe nucuaꞌ, xne liꞌibeei uya chiyaꞌbeeii, che ubixia bene enu nuyaꞌ cuenda eliñi zeꞌe niyu enu xia, ");
INSERT INTO zplNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nu unilla lui: ―Ye bee bene rluti rritsiꞌbeei biñu nzeꞌca, nu chenu ungueꞌla bee bene huaxi biñu cuaꞌ, cheelá rritsiꞌbeei biñu nú la neca nzeꞌca. Pero liꞌilu uduꞌcheꞌelu biñu nzeꞌca quieꞌ para nú rritsiꞌlue hasta neelá. ");
INSERT INTO zplNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nucuaꞌ neca milagro rluti nú uriꞌi Jesuse, uriꞌinu milagro quieꞌ eyeche Caná nú nchiucuꞌ lu iliu Galilea, scua ulubeꞌnu poder nú rluꞌcunu nu uchili arquiꞌ bee beneꞌnu liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chenu ulaxu nú unga nucuaꞌ che nzanu eyeche Capernaum, cuna naꞌnu, cuna bee bichinu cuna bee beneꞌnu, nu zeꞌe ucuaꞌa beella chiucu chuna bichia. ");
INSERT INTO zplNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lunú axula nzu baxcu eliñiꞌ bee bene Israel, che uya Jesuse eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nu labe eleꞌyaꞌ indu llene Jerusalén zeꞌe ulañiꞌnu bee bene enu ruti bee uꞌnaꞌ, cuna bee sanchi, cuna bee paloma, cuna bee bene enu nucuaꞌa lu mexa xiꞌla dimiꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chenu ulañiꞌ Jesuse nucuaꞌ, che urecheꞌnu tucu chicuete nú neca tuu para nú uhuanu ye bee bene cuna bee uꞌnaꞌ beella, cuna bee sanchiꞌ beella ruꞌu eleꞌyaꞌ indu zeꞌe, nu utsiꞌquinu dimiꞌ bee bene enu xiꞌla dimi, nu utelletanu mexaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Che uninu lubee bene enu ruti bee paloma: ―¡Uhuahua bee nucuaꞌ caꞌa! ¡La riꞌihua niꞌi paa xi neca tucu iꞌya! ");
INSERT INTO zplNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Chequie ulluꞌcu arquiꞌ bee beneꞌnu lu ichiꞌ Stichiaꞌ Diose elu rni: “Hasta nú atia la tsana arquia nú recanua niꞌlu.” ");
INSERT INTO zplNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Che uni bee bene Israel lu Jesuse: ―¿Xi milagro lubeꞌlu luru para nú riꞌiru beyaꞌ nú rluꞌculu nu rnibiyaꞌlu nú rriꞌilu scua? ");
INSERT INTO zplNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nu ucuaqui Jesuse lubeei: ―Uchilahua induquieꞌ, nu lu chunatsia bichia recheꞌ zecane. ");
INSERT INTO zplNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chequie uni bee bene Israel zeꞌe lunu: ―Cuarenta y seis lana uleꞌ bee bene nú urecheꞌe beei indu quieꞌ, ¿nu liꞌilu rnilu nú lu chunatsia bichia recheꞌ zecalue la? ");
INSERT INTO zplNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero liꞌinu rninu lu cuendaꞌ cuerpoꞌnu chenu uninu lu cuendaꞌ indu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Enzeꞌe chenu uhuañi zeca Jesuse nú ungutinu, ulluꞌcuꞌ arquiꞌ bee beneꞌnu lunú uninu, nu uchili arquiꞌbeella stichiaꞌnu nu leꞌca uchili arquiꞌ beella lunú niquie lu ichiꞌ Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Diqui nú nzucu Jesuse eyeche Jerusalén eliñi baxcu, huaxi bee bene uyalí arquiꞌ liꞌinu chenu ulañiꞌ beei bee milagro nú uriꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero la chili arquiꞌ Jesuse lunú rnibeei, xne nuꞌlu nzeꞌcanu xa neca elliebacuꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","La quiꞌñanu nú nuꞌ enu ni lunu nú xa neca bee bene, xne liꞌinu nuꞌlu nzeꞌcanu xa neca elliebacuꞌ ye bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Uhuañi tucu fariseo enu lee Nicodemo, liꞌilla ungalla usticia lubee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nu uyabiꞌyalla Jesuse tucu rulaꞌ, nu unilla lunu: ―Maestro, liꞌiru nediyaꞌru nú Diose uxeꞌla liꞌilu para nú zeteꞌlu liꞌiru, xne lecati aca riꞌi saꞌ bee milagro nú rriꞌilu tunu la nzu Diose cuna liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nu uni Jesuse lulla: ―Liꞌá rixiuleꞌe nzeꞌca lulu, nú enu la ala zeca stucu bese leca modo chuꞌu nzeꞌe elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Che uni Nicodemo lunu: ―Pero ¿xa modo nú ala zeca tucu bene enu unguxula? ¿Xieꞌ nuꞌ modo nú chuꞌu zeca tucu bene xlaꞌcu naꞌlla nu ala zecalla la? ");
INSERT INTO zplNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nu ucuaqui Jesuse lulla: ―Liꞌá rixiuleꞌe nzeꞌca lulu, nú enu la rinza nu la nzu Espíritu Santo cuna liꞌi leca modo chuꞌu nzeꞌe liñibe elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ye bee bene chenu ralalla, necatsialla bene lu iliulabe quieꞌ. Pero bee bene enu nehuañi cuna Espíritu Santo, equie cuendaꞌ Espíritu Santo rluꞌcula beella stucu elunehuañi. ");
INSERT INTO zplNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","La zeca lullieꞌlu equie nú unia lulu chenu unia lulu: “Rquiꞌña nú ala zeca bee bene.” ");
INSERT INTO zplNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Xne tucu nú reca bii catse bee luhuare, nu mase rieneꞌlu chenu reca bii, pero niꞌla riꞌilu beyaꞌ cá enza nzeꞌtae, urre cá enza nzae. Scua neca Espíritu Santo luye bee bene enu nzu cuna Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Che uni Nicodemo lunu: ―¿Xa modo nú acahuaꞌ scua? ");
INSERT INTO zplNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nu ucuaqui Jesuse: ―¿Liꞌilu, nú necalu ulaxcuela lubee bene Israel, nu la riꞌilu beyaꞌ bee nucuaꞌ la? ");
INSERT INTO zplNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Liꞌá rnia lulu, nú liꞌiru rniru lunú nediyaꞌru nu lunú ulañiꞌlaꞌru. Pero liꞌihua la chili arquiꞌhua lunú rniru. ");
INSERT INTO zplNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tunu la chili arquiꞌhua chenu rnia luhua equie cuendaꞌ beenú nuꞌ lu iliulabe quieꞌ. ¿Xa chili arquiꞌhua chenu rnia luhua equie cuendaꞌ beenú nuꞌ liñibe? ");
INSERT INTO zplNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Lecali ti uya liñibe tucutsia enu nzeꞌta enza liñibe, nu liꞌinu necanu Bene enu uxeꞌla Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nu tucu nú uquieꞌe Moisés tucu beꞌla enu necacheꞌ icuꞌ lu tucu aca lu dañi achi, leꞌca esquie Bene enu uxeꞌla Diose quieꞌe bee bene liꞌinu lu cruse, ");
INSERT INTO zplNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","para nú ye bee bene enu chili arquiꞌ liꞌinu, la nitilu beella, nu luꞌcu beella elunehuañi nú leca xunga laxu lunu. ");
INSERT INTO zplNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Equie nú chiquiꞌ seca Diose bee bene iliulabe, uxeꞌlanu Lliꞌñi eꞌcunu lu iliulabe para nú ye bee bene enu chili arquiꞌ liꞌinu la nitilubeei, sino que luꞌcu beei elunehuañi nú leca xunga laxu lunu. ");
INSERT INTO zplNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Xne né xeꞌla Diose Lliꞌñinu lu iliulabe para nú deteꞌnu castiya bee bene, sino que ubeꞌtanu para nú tsilaꞌanu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Bene enu chili arquiꞌ Lliꞌñi Diose, la zecaꞌ nzeꞌe castiyaꞌ Diose. Pero enu la chilí arquiꞌ liꞌinu, zeca nzeꞌe castiya xne la chili arquiꞌ nzeꞌe Lliꞌñi eꞌcu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bee bene enu la chili arquiꞌ liꞌinu zeca bee nzeꞌe castiya, xne nee nú uriñanu lu iliulabe liꞌinu enu neca ellieꞌ Diose, liꞌibeei máse riuꞌ arquiꞌbeei inziu nú necha neca, xne rriꞌi beei puro lunú necha neca. ");
INSERT INTO zplNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Xne ye bee enu rriꞌi nú necha neca, la yuꞌlí arquiꞌbeei ellieꞌe cuaꞌ, nu la chebica beei lue para nú la yaꞌlalu lunú necha neca rriꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","pero bee bene enu nehuañi tucu nú rialane lu Diose, liꞌibeella nzequie beella ellieꞌnu para nú acachee nú rriꞌi beella lunú niarquiꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chenu udete nú unga bee nucuaꞌ, uya Jesuse cuna bee beneꞌnu lu iliu Judea, zeꞌe ucuaꞌa beella chiucu chuna bichia nu urinza bee beneꞌnu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Leꞌca tucu eyeche nú lee Enón, axu eyeche nú lee Salim, zeꞌe uriꞌnza Juan bee bene xne nuꞌ huaxi inza zeꞌe, nu nza bee bene para nú rinza beei zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nucuaꞌ unga chenu lascaꞌ chuꞌu Juan niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chequie chiucu chuna bee beneꞌ Juan cuna texcuaꞌa bee bene Israel, uquixie beei nú rni xuu beei lu saꞌbeei equie cuendaꞌ nú xa rnaa nzeꞌca beei lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nu uya niꞌ bee beneꞌ Juan lulla: ―Maestro, bene enu nzunuulu stucu chú reꞌcu Jordán, liꞌilla enu unilu luru, rrinzalla bee bene nu ye beei nzequie beei liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Che uni Juan lubeei: ―Lecati aca luꞌcu elurnibiyaꞌ nú riꞌilla scua tunu la deteꞌ Diose nucuaꞌ lulla. ");
INSERT INTO zplNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Liꞌihua ubenelaꞌhua nú unila luhua nú la neca Cristo, necatsia enu uriña rluti para nú ixiuleꞌa lu cuendaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lu tsaꞌa chia nzu niyu enu xia cuna unaꞌa enu xialla, nu bene enu rquieteꞌ niyu enu xiacuaꞌ enu nzu cuna liꞌilla, chiquiꞌ ñia nzu arquiꞌlla chenu rieneꞌlla nú uquixie nú rni niyu enu xia. Nee leꞌca scua chiquiꞌ ñia nzu arquia equie cuendaꞌ liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Liꞌinu chu nzeaca neca equielánu, nu liꞌá chu nzelacalá lunú neca equia luquela liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Enu nzeꞌta enza liñibe liꞌinu necanu enu rnibiyaꞌ lu yeene. Pero bee bene iliulabe necatsialla bee bene iliulabe, nu rnitsialla beenú nuꞌ lu iliulabe, pero liꞌinu enu nzeꞌta enza liñibe liꞌinu necanu enu rnibiyaꞌ lu yeene. ");
INSERT INTO zplNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nu liꞌinu rninu lunú ulañiꞌlaꞌnu cuna lunú ubeneꞌlaꞌnu. Pero lecati nzeli arquiꞌ lunú rninu. ");
INSERT INTO zplNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tunu nuꞌ enu nzeli arquiꞌ stichiaꞌnu, scua rlubeꞌlla nú neli neca Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Enu nzeꞌta lu cuendaꞌ Diose, liꞌinu rninu Stichiaꞌ Diose xne chiquiꞌ udeteꞌ Diose Espíritu Santo lunú. ");
INSERT INTO zplNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Diose secanu Lliꞌñinu, nu udeteꞌ cuendanu yeene lu Lliꞌñinu para nú nibiyaꞌnu lu yeene. ");
INSERT INTO zplNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nu tatse enu chili arquiꞌ Lliꞌñinu, liꞌilla rluꞌculla elunehuañi nú leca xunga laxu, pero enu la niarquiꞌ chili arquiꞌ Lliꞌñinu la luꞌculla elunehuañi cuaꞌ sino que rialalla castiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Uriꞌi bee fariseo beyaꞌ nú nuꞌ huaxilá bee beneꞌ Jesuse, nu leꞌca rrinzalánu bee bene luquelá Juan, ");
INSERT INTO zplNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","añinzuca nu la neca mero Jesuse enu rrinza bee bene, sino que bee beneꞌnu neca enu rriꞌnza bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Chenu uriꞌi Jesuse beyaꞌ bee nucuaꞌ, uchiuꞌunu lu iliu Judea, nu nzanu lu iliu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pero chenu nzanu lu iliu Galilea, rquiꞌña nú detenu enza lu iliu Samaria. ");
INSERT INTO zplNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nu uriñanu tucu eyeche nú lee Sicar, nú nchiucuꞌ lu iliu Samaria axu lu yuu nú udeteꞌ Jacob lu llianaꞌlla José. ");
INSERT INTO zplNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Zeꞌe nzucu tucu tsu nú rni bee bene tsuꞌ Jacob, nu lunú ullacalaꞌ Jesuse nú seenu, chequie uzucunu ruꞌu tsu zeꞌe tucu rebibichia. ");
INSERT INTO zplNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Hora zeꞌe uriña tucu unaꞌa Samaria ruꞌu tsu zeꞌe nú nzeꞌta chiyaꞌlla inza nu uni Jesuse lulla: ―Iꞌña lleꞌna inza lulu huaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Nu bee beneꞌnu nzuela beella eyeche zeꞌe nzetsii beella nú acu beella. ");
INSERT INTO zplNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nu lunú la quieteꞌ bee bene Israel bee bene Samaria, chequie ucuaqui unaꞌa zeꞌe lu Jesuse: ―Liꞌá neca bene Samaria, nu ¿xieꞌlanu bene Israel necalu nu rnacuꞌlu inza lua la? ");
INSERT INTO zplNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nu uni Jesuse lulla: ―Tunu rriꞌilu beyaꞌ lunú niarquiꞌ Diose nú liquiꞌnu lulu, nu rriꞌilu beyaꞌ tineca enu rnacuꞌ inza lulu. Liꞌilu nacuꞌlu inza lua, nu liꞌá liquia inza nú rliquiꞌ elunehuañi lulu. ");
INSERT INTO zplNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chequie uni unaꞌa zeꞌe lu Jesuse: ―Detá, lecaxi uyaꞌlu para nú hualu inza, nu chiquiꞌ aquié tsuquieꞌ, ¿cá chiyaꞌlu inza nú rliquiꞌ elunehuañi? ");
INSERT INTO zplNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tsuquieꞌ neca nú utsaꞌna Jacob beneꞌru enu udetela luru, nu leꞌca inza cuaꞌ ungueꞌlla cuna bee enduꞌlla cuna bee nañiꞌbeella. ¿Xieꞌ másela neca equielu lulla la? ");
INSERT INTO zplNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nu uni Jesuse lulla: ―Ye bee bene enu rueꞌ inza quieꞌ, bichiꞌ zecaꞌ beei stucu bese, ");
INSERT INTO zplNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pero bee enu hueꞌ inza nú detea, lecaꞌ xunga bichiꞌ nzeꞌe. Xne inza nú detea lulla liñii liñi arquiꞌlla xi neca tucu elu la tsuxe rliñi inza, nu luꞌculla elunehuañi nú leca xunga laxu. ");
INSERT INTO zplNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nu uni unaꞌa zeꞌe lunu: ―Detá, uliꞌquiꞌ inza cuaꞌ lua para nú la bichiaꞌa stucu bese, nu la yelaꞌa ruꞌu tsuquieꞌ huaa inza. ");
INSERT INTO zplNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Che uni Jesuse lulla: ―Uquia tucu niyuꞌlu nu chu yeꞌta zecalu. ");
INSERT INTO zplNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nu ucuaqui unaꞌa zeꞌe lunu: ―La luꞌcua niyu. Che ucuaqui Jesuse nú uninu lulla: ―Neli rnilu nú la luꞌculu niyu, ");
INSERT INTO zplNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","xne uchialálu cuna ayuꞌ niyu, nu nee niyu enu nzucunulu la nechialu cuna liꞌi. Enzeꞌe neli lunú unilu scua. ");
INSERT INTO zplNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chenu ubeneꞌ unaꞌa zeꞌe nucuaꞌ, che unilla lunu: ―Detá, rriꞌá beyaꞌ nú liꞌilu necalu tucu profetaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bee beneꞌru enu udetela uluꞌcu beella ulaꞌna lu Diose equie dañi quieꞌ, pero liꞌihua enu neca bee bene Israel rnihua nú eyeche Jerusalén neca elu luꞌcu bee bene ulaꞌna lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nu ucuaqui Jesuse: ―Unaꞌa, uchili arquiꞌ nú rnia, nú riña bichia nú luꞌcu bee bene ulaꞌna lu Diose Pa liñibe sin nú yeꞌta beella equie dañi quieꞌ, nu niꞌ la quiꞌñaꞌ nú chue beella eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Liꞌihua la riꞌihua beyaꞌ ti rluꞌcuhua ulaꞌna lu. Pero liꞌiru nediyaꞌru ti rluꞌcuru ulaꞌna lu, xne lubee bene Israel nzeꞌta enu tsilaꞌa bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nu nee horaquieꞌ, uriñala bichia nú ye bee bene enu neli rluꞌcu ulaꞌna lu Diose, luꞌcu beella ulaꞌna lunu tucu nú rialane equie cuendaꞌ Espíritu Santo. Xne scua niarquiꞌ Diose Pa liñibe nú riꞌi bee bene enu rluꞌcu ulaꞌna lunu. ");
INSERT INTO zplNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diose necanu Espíritu, nu bee enu rluꞌcu ulaꞌna lunu rquiꞌña nú neli luꞌcu beella ulaꞌna lunu equie cuendaꞌ Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chequie uni unaꞌa zeꞌe lu Jesuse: ―Liꞌá nediyaa nú nzeꞌta Mesías (enu leꞌca lee Cristo), nu chenu riñanu, liꞌinu ixiuleꞌenu yeene luaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nu uni Jesuse lulla: ―Liꞌá neca Cristo enu rnilu, nu liꞌinu necanu enu rdichiaꞌnulu nee. ");
INSERT INTO zplNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hora zeꞌe uriña bee beneꞌnu, nu nzenu arquiꞌbeella nú rdichiaꞌnunu tucu unaꞌa. Pero niꞌ tucu beella né nedichiaꞌ beella lunu xi niarquiꞌ unaꞌa zeꞌe, urre xi rdichiaꞌnunu liꞌinchu. ");
INSERT INTO zplNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chequie utsaꞌna unaꞌa zeꞌe ereꞌnchu ruꞌu tsuu zeꞌe nu nzanchu eyeche zeꞌe elu uya niꞌnchu, lubee bene: ");
INSERT INTO zplNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Utehua ne lañiꞌhua tucu bene enu uni lua lu ye beenú uriꞌá. ¿Xieꞌ la necalla Cristo la? ");
INSERT INTO zplNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Che uchiuꞌu beei eyeche zeꞌe nu uyabeei elu nzu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Diquila nú nza unaꞌa zeꞌe eyeche zeꞌe, uni bee beneꞌ Jesuse lunu: ―Maestro, udacu lleꞌna nú aculu. ");
INSERT INTO zplNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero uninu lubeella: ―Liꞌá rluꞌculá tucu elubacu nú acua, núla chuluhua. ");
INSERT INTO zplNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nu uquixie bee beneꞌnu unidichiaꞌ beella lu saꞌbeella: ―¿Xieꞌ nuꞌti ubeꞌtayula nú udacunu la? ");
INSERT INTO zplNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chequie uni Jesuse lubeella: ―Elubacua neca nú rriꞌá lunú niarquiꞌ Diose enu uxeꞌla liꞌá, nu tsalua lunú uninu lua nú riꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Liꞌihua rnihua: “Rriꞌiscaꞌlá se stacu guu para nú aca ulaꞌcu.” Pero liꞌá nia luhua: Nú uletsahua luhua nu ubiꞌyacuruhua lubee yuu, nú necala bee para nú aca ulaꞌcu lubee. ");
INSERT INTO zplNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nu bene enu rquietesaꞌ ulaꞌcu riuculla lunú rialalla equie riñaꞌ nú rriꞌilla. Nu bee ulaꞌcu nú rriꞌilla necalane para elu nuꞌ elunehuañi nú leca xunga laxu, nu scua bene enu rduꞌ nii nu bene enu rriꞌi ulaꞌcu tucutse ñia nzu arquiꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Neli lunú rni bee bene: “Urene enu rduꞌ nii nu stucu enu rriꞌi ulaꞌcu.” ");
INSERT INTO zplNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Liꞌá uxeꞌla liꞌihua para nú riꞌihua ulaꞌcu elu né riꞌihua riñaꞌ, urene enu uriꞌi riñaꞌ, nu liꞌihua uyariꞌihua ulaꞌcu elu uriꞌi beella riñaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Huaxi bee bene lu iliu Samaria zeꞌe uchili arquiꞌbeei Jesuse lunú uni unaꞌa zeꞌe lubeei, chenu uninchu lubeei: “Unilanu lua luye nú uriꞌá.” ");
INSERT INTO zplNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Enzeꞌe chenu uriña bee bene lu iliu Samaria zeꞌe elu nzu Jesuse, uziquie beei lunu nú yaꞌnanu cuna liꞌibeei. Nu uyaꞌnanu cuna liꞌibeei chiucu bichia. ");
INSERT INTO zplNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nu huaxilá bee bene uchili arquiꞌbeei liꞌinu, chenu ubeneꞌbeei lunú rninu. ");
INSERT INTO zplNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chequie unibeei lu unaꞌa zeꞌe: ―Nee laneca lunú unitsialu luru nzeli arquiꞌru liꞌinu, sino que liꞌi eꞌcuru ubeneꞌlaꞌru lunú rninu, nu nediyaꞌ nzeꞌcaru nú liꞌinu necanu Cristo enu tsilaꞌa bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chenu udete rucu bichia zeꞌe, uchiuꞌu Jesuse lu iliu Samaria nu nzanu enza Galilea. ");
INSERT INTO zplNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Xne leꞌca liꞌinu uninu, nú niꞌ tucu profeta la luꞌcu bee bene ulaꞌna lulla lachilla. ");
INSERT INTO zplNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero chenu uriñanu lu iliu Galilea, uyucu nzeꞌca bee bene lu iliu zeꞌe liꞌinu, xne leꞌca nu beei uya beei eliñi baxcu Jerusalén nu ulañiꞌ beei ye bee milagro nú uriꞌinu lu eliñi zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chequie uya zeca Jesuse eyeche Caná nú nchiucuꞌ lu iliu Galilea, elu uriꞌinu nú unga inza biñu. Nu eyeche Capernaum zeꞌe nzucu tucu beneꞌ arre enu riti llianaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chenu ungabiyaꞌ beneꞌ arre zeꞌe nú uriña Jesuse Galilea, nu uchiuꞌunu lu iliu Judea. Che uyalla elu uriña Jesuse nu uziquiella lunu nú chánu riyecanu llianaꞌlla enu yamero ati. ");
INSERT INTO zplNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nu uni Jesuse lulla: ―Liꞌihua la chili arquiꞌhua liꞌá tunu la lañiꞌhua tucu seña, urre bee milagro nú rriꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero ucuaqui beneꞌ arre zeꞌe nú unilla: ―Detá, yexetsia uchaa ante nú ati llianaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chequie uni Jesuse lulla: ―Ubenchilaꞌ niꞌlu, nzucu nzeꞌcala llianaꞌlu. Nu uchili arquiꞌ bene zeꞌe lunú uni Jesuse, nu chu nzialla enza niꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Diquila nú nzialla, uyachaꞌcalu bee mosoꞌlla liꞌilla nu unibeei lulla: ―Nzucu nzeꞌcala llianaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chequie unidichiaꞌlla lubeei nú xiura uquixie nú uzucu nzeꞌca llianaꞌlla, nu unibeei lulla: ―Necaꞌ tucu rqui tucu uchee uchiuꞌu xleꞌi. ");
INSERT INTO zplNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Che uriꞌi bene zeꞌe beyaꞌ nú hora zeꞌe neca chenu uni Jesuse lulla: “Nzucu nzecala llianaꞌlu”, nu uchili arquiꞌlla cuna ye bee bene niꞌlla Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nucuaꞌ neca milagro rrucu nú uriꞌi Jesuse lu iliu Galilea, chenu ubenchilaꞌnu nú uyanu lu iliu Judea. ");
INSERT INTO zplNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chenu udete nú unga bee nucuaꞌ che unga tucu eliñiꞌ bee bene Israel, nu uya Jesuse eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nu Jerusalén axu ruꞌu puerta nú lee bee sanchi, nzucu tucu estanque llene nú lee Betesda cuna dialu hebreo, nu rluꞌcune ayuꞌ curdure. ");
INSERT INTO zplNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nu liñi bee curdure zeꞌe nucuaꞌa huaxi bee bene enu riti, bee bene enu niquieꞌlu, bee bene enu necuxu, bee bene enu neati beꞌlaꞌ. Nucuaꞌa quiebeei nú cuñi lu inza nú nuꞌ liñi estanque zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Xne nuꞌtsia nuꞌtsia chenu rlaca tucu ángeleꞌ Diose rcuñi inza zeꞌe. Chequie bene enu rluti riuꞌu lu inza zeꞌe chenu rcuñi lue, chu riecaꞌ bene zeꞌe, lu xitse lubee elichia nú secalla. ");
INSERT INTO zplNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nu leta bee bene enu riti zeꞌe netse tucu niyu enu necala treinta y ocho lana nú riti. ");
INSERT INTO zplNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Chenu ulañiꞌ Jesuse liꞌi nú nuxui zeꞌe, nu uriꞌinu beyaꞌ nú huaꞌtula riti, che unidichiaꞌnu lui: ―¿Niarquiꞌlu nú yecaꞌlu la? ");
INSERT INTO zplNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nu ucuaqui bene enu riti zeꞌe lunu: ―Detá, lecati lucua para nú duꞌ liꞌá lu inzaquieꞌ chenu rcuñine, cada chenu niarquia nú chuꞌa lu inzaquieꞌ, stucu bene rluti chu riuꞌu lue. ");
INSERT INTO zplNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chequie uni Jesuse lui: ―Uzetee, unaꞌtse camiyaꞌlu nu utseꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hora zeꞌe uyecaꞌi, nu unaꞌtsei camiyaꞌi nu uquixiei nú utsei. Pero bichia zeꞌe neca bichia nú sulachi bee bene, ");
INSERT INTO zplNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","che uni bee bene Israel lu bene enu uyecaꞌ zeꞌe: ―Bichia quieꞌ neca bichia nú sulachi bee bene, leca modo nú uyaꞌlu camiyaꞌlu nee. ");
INSERT INTO zplNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nu ucuaqui bene zeꞌe: ―Bene enu uriꞌiyeca liꞌá, liꞌilla unilla lua: “Unaꞌtse camiyaꞌlu nu uquiaꞌa.” ");
INSERT INTO zplNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nu unidichiaꞌ beei lui: ―¿Ti uni lulu: “Unaꞌtse camiyaꞌlu nu uquiaꞌa”? ");
INSERT INTO zplNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero la riꞌi bene zeꞌe beyaꞌ ti uriꞌiyeca liꞌi, xne uyuꞌu Jesuse leta huaxi bee bene enu nucuaꞌa zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Luzeꞌelá uchuꞌu zecaꞌla Jesuse bene zeꞌe liñi indu llene Jerusalén, nu uninu lui: ―Uriꞌi beyaꞌ, nú uyecaꞌlaꞌlu, la riaꞌlu dula para nú la zecaꞌlu stucu nú maselá lunú ulleꞌcalu. ");
INSERT INTO zplNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chequie chu nza bene zeꞌe nu uyatixiuleꞌi lubee bene Israel, nú Jesuse neca enu uriꞌiyeca liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Enzeꞌe uquixie beei nú rcuaꞌna beei xa naꞌtse beei Jesuse para nú úti beei liꞌinu, xne rriꞌinu bee milagrocuaꞌ bichia nú sulachi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero uni Jesuse lubeei: ―Pa Diose siempre rriꞌinu lunú riala riꞌinu, enzeꞌe leꞌca rriꞌá tucu nú rriꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Enzeꞌe máse niarquiꞌ bee bene Israel útibeei Jesuse, la necane equietsia beenú rriꞌinu bichia nú sulachi bee bene, leꞌca necane equie nú rriꞌinu nú reca igualenu Diose, chenu rninu nú neca Diose mero Paꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chequie uni Jesuse lubeei: ―Liꞌá neli ixiuleꞌa luhua, nú Lliꞌñi Diose lecaxi riꞌi tuculiꞌnu, liꞌinu rriꞌinu lunú rlañiꞌnu nú rriꞌi Paꞌnu. Xne ye nú rriꞌi Diose leꞌca esquie rriꞌi Lliꞌñinu. ");
INSERT INTO zplNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Xne seca Diose Lliꞌñinu nu seteꞌnu Lliꞌñinu ye nú rriꞌinu, nu másescaꞌlá lubeꞌlánu huaxi beenú llenescaꞌlá lu Lliꞌñinu, nú másela chenu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Xne tucu nú rriꞌi Diose nú rehuañi zeca bee bene enu unguti nu rdeteꞌnu elunehuañiꞌ beei, leꞌca scua Lliꞌñinu rdeteꞌ elunehuañi lu enu niarquiꞌnu nú deteꞌnue. ");
INSERT INTO zplNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nu la hualu Diose lu cuendaꞌ bee bene, sino que utsaꞌnanu lu Lliꞌñinu nú hualue lu cuendaꞌ bee bene, ");
INSERT INTO zplNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","para nú luꞌcu ye bee bene ulaꞌna lu Lliꞌñi Diose tucu nú rluꞌcu beei ulaꞌna lunu. Nu enu la luꞌcu ulaꞌna lu Lliꞌñinu, leꞌca la luꞌcu nzeꞌe ulaꞌna lu Paꞌnu enu uxeꞌla liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Liꞌá neli rnia luhua: Nú bene enu sucuꞌ stichiaꞌa, cuna nú chili arquiꞌ nzeꞌe Diose, liꞌinu enu uxeꞌla liꞌá, liꞌilla rluꞌculalla elunehuañi nú leca xunga laxu lu Diose. Chequie la yalaꞌlla castiyaꞌ Diose, xne la necaꞌlla xi neca bene enu unguti lu Diose, liꞌilla rluꞌculalla elunehuañi lunu. ");
INSERT INTO zplNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Leꞌca neli rnia luhua nú nzeꞌtala hora, nu nee hora quieꞌ, neca chenu bee bene enu neca xi neca bee bene enu unguti lu Diose, yeneꞌ beei chii Lliꞌñi Diose, nu bee bene enu zucuꞌ stichiaꞌnu, luꞌcu beella elunehuañi lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Xne tucu nú rluꞌcu Diose elunehuañi, leꞌca scua udeteꞌlanu saꞌ elunehuañicuaꞌ lu Lliꞌñinu, ");
INSERT INTO zplNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","nu leꞌca udeteꞌlanu elurnibiyaꞌ lu Lliꞌñinu para nú hualunue lu cuendaꞌ bee bene iliulabe, xne liꞌinu necanu Bene enu uxeꞌla Diose lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","La chenu arquiꞌhua lunú rnia luhua, xne riña bichia chenu ye bee bene nguti, yeneꞌ beei chi Lliꞌñi Diose ");
INSERT INTO zplNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nu chiuꞌubeei liñi eluhuaꞌbeei. Nu bee enu uriꞌi tucu nú niarquiꞌ Diose, huañi beei para nú luꞌcu beei elunehuañi cuna liꞌinu. Pero bee bene enu necha uriꞌi, leꞌca huañi beei para nú yala beei castiya nú riala beei. ");
INSERT INTO zplNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Nu liꞌá lecaxi riꞌá lunú necatsia elliebacuꞌ eꞌcua. Liꞌá rlualua lu cuendaꞌ bee bene tucu nú rnibiyaꞌ paa, nu rriꞌá elu usticia tucu nú rialane, xne la riꞌá tucu nú necatsia ellibacua, sino que rriꞌá tucu nú niarquiꞌ Paa enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tunu leꞌcatsia liꞌá rnia lu cuendaꞌ liꞌá, lecaxi zibiꞌ stichiaꞌa che. ");
INSERT INTO zplNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero stucu enu rni lu cuendaꞌ liꞌá, nu nediya nzeꞌca nú neli neca lunú rni nzeꞌe lu cendaꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Liꞌihua uxeꞌlahua bee bene enu uya nedichiaꞌ lu Juan, nu liꞌilla unilla puro nú neli neca luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Añinzuca nú la quiꞌña nú ni zecaa luhua lunú uni bene lu cuendaa, pero nia luhua lunú uni Juan para nú tsilaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan unga xi neca tucu quii nú rduꞌllieꞌe, nu liꞌihua chiquiꞌ ñia utsu arquiꞌhua nu uriꞌihua caso lunú uzeteꞌlla liꞌihua lleꞌna tiembu. ");
INSERT INTO zplNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero liꞌá másela huaxi nú lubea luhua luquelá nú uzeteꞌ Juan liꞌihua lu cuendaꞌ liꞌá. Xne lunú uni Pa Diose nú riꞌá neca lunú rriꞌá nee para nú neli acachee nú Diose uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nu leꞌca Paa enu uxeꞌla liꞌá, uninu equie cuendaꞌ liꞌá, añinzuca nú leca xunga ubeneꞌhua chiinu nu lá lañiꞌhua liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nu leꞌca lá zucuhua stichiaꞌnu, enzeꞌe la chili arquiꞌhua bene enu uxeꞌlanu. ");
INSERT INTO zplNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Liꞌihua chiquiꞌ seteꞌ nzeꞌcahua lu Stichiaꞌ Diose chenu rulahuane, xne nzuquiehua nú scua luꞌcuhua elunehuañi nú leca xunga laxu liñibe, nu añinzuca nú leꞌca liꞌi lu ichiꞌ Stichiaꞌ Diose rni lu cuendaꞌ liꞌá, ");
INSERT INTO zplNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","pero liꞌihua la zelahua chili arquiꞌhua liꞌá para nú luꞌcuhua elunehuañicuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Liꞌá la laꞌna nú zucuꞌ ayaa bee bene liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nu nediya nzeꞌca nú liꞌihua la zecahua Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Liꞌá uriña lu cuendaꞌ Pa; nu lá riꞌi casohua liꞌá, pero tunu nzeꞌta stucu bene enu nzeꞌta lu cuendaꞌ liꞌitsia, aꞌla nzeꞌe si riꞌi casohua. ");
INSERT INTO zplNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xa modo nú chili arquiꞌhua liꞌá, tunu liꞌihua máse rlaꞌnahua nú zucuꞌ ayaa beelá bee saꞌhua liꞌihua, luhuare nú laꞌnahua nú yaꞌna nzeꞌcahua lu tucutsia liꞌinu enu neca Diose che? ");
INSERT INTO zplNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","La riꞌihua elliebacuꞌ nú tia liꞌá xanabitsia lu cuendaꞌhua lu Diose, xne enu xanabitsi lu cuendaꞌhua neca Moisés, enu nzuquiehua nú riꞌi elietsa luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Xne tunu liꞌihua neli uchili arquiꞌhua lunú uni Moisés, leꞌca chili arquiꞌhua liꞌá, xne equie cuendaꞌ liꞌá uquieꞌe Moisés lu ichiꞌ Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero tunu la chili arquiꞌhua lunú uquieꞌe Moisés, ¿xa chili arquiꞌhua lunú rnia luhua che? ");
INSERT INTO zplNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chenu udete nú unga bee nucuaꞌ, nza Jesuse stucu chú inzatuꞌ Galilea, elu leꞌca lee Tiberias. ");
INSERT INTO zplNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Huaxi bee bene uyanala liꞌinu, xne ulañiꞌbeei bee milagro nú rriꞌinu, chenu uriꞌiyecanu bee bene enu riti. ");
INSERT INTO zplNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Che uquie Jesuse equie tucu dañi elu uzucunu cuna bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nu bee bichia zeꞌe axula nzu eliñi baxcu, eliñi nú rriꞌi bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chenu uletsa Jesuse lunu ulañiꞌnu nú nzeꞌta riña huaxi bee bene lunu, che uninu lu Felipe: ―¿Cá chetsiaꞌahua nú acu ye bee benequieꞌ nee? ");
INSERT INTO zplNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pero unitsia Jesuse scua lu Felipe biꞌya xi cuaquii, xne nediyalaꞌnu lunú riꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Chequie ucuaqui Felipe: ―Pero niꞌ chiucu ayuꞌu denario pá la riquiꞌ nú acu beei masia te pedasoae. ");
INSERT INTO zplNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Che uni stucu beneꞌnu enu lee Andrés, bichi Simón Pedro: ");
INSERT INTO zplNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Caꞌa nzu tucu enduꞌ niyu enu nuyaꞌ ayuꞌ pá cebada cuna chiucu bela, pero ¿xa riquiꞌ nucuaꞌ para lu huaxi bee benequieꞌ? ");
INSERT INTO zplNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chequie uni Jesuse lubeella: ―Uniꞌhua lu ye beei nú cuaꞌa beei. Nu lunú nuꞌ ixi xata zeꞌe ucuaꞌa yebeei zeꞌe, nulu yebee bene enu nucuaꞌa zeꞌe neca tucu ayuꞌ mili puro bee niyutsia. ");
INSERT INTO zplNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Che unaꞌtse Jesuse bee pá zeꞌe, nu chenu ulaxu nú udeteꞌnu cheꞌtsa lu Diose, udeteꞌnue ya bee beneꞌnu nu uritsiꞌ beellae luye bee bene enu nucuaꞌa zeꞌe. Leꞌca esquie uriꞌinu cuna bee bela, udeteꞌnu calutse nú uniarquiꞌbeei acubeei nu udacu beei hasta elu ubelaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Chenu ubelaꞌ beei uni Jesuse lubee beneꞌnu: ―Uquieteꞌ saꞌhua bee pedaso nú uyaꞌna, para nú la nitilu niꞌtemeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chequie uquietesaꞌ beellae, nu uriche beella chiꞌchiucu llume bee pedaso bee pá nú uyaꞌna lu ayuꞌ pá zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chenu ulañiꞌ bee bene zeꞌe milagro llene nú uriꞌi Jesuse, che unibeei: ―Neli nú liꞌinu necanu profeta enu nzu nú nzeꞌta lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero chu uriꞌi Jesuse beyaꞌ nú niarquiꞌ beei nú uyaꞌ beei liꞌinu ala juerza para nú riꞌi beei nú acanu arre, enzeꞌe chu nzanu elu aya equie dañi zeꞌe, para nú zucu tuculiꞌinu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Chenu uyuꞌu rulaꞌ, ulaca bee beneꞌ Jesuse ruꞌu inzatuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nu uyuꞌu beella liñi tucu barco nu uquixie beella rdete beella lu inzatuꞌ zeꞌe para nú riña beella eyeche Capernaum. Nu ucabelila, nu lascaꞌ benchilaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Che uquixie nú unga tucu bii juerte, nu uquixie nú chiquiꞌ riatsaya inzatuꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Chenu nzala beella tucu ayuꞌ urre xuꞌcu kilometro, ulañiꞌ beella nú see Jesuse lu inzatuꞌ zeꞌe nu nzebicanu enza lu barcoꞌ beella, nu ulliqui beella. ");
INSERT INTO zplNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero uninu lubeella: ―¡Liꞌá ninguieꞌ, la lliquihua! ");
INSERT INTO zplNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nu chiquiꞌ ñia nzu arquiꞌbeella uyucu beella liꞌinu liñi barco, nu chu uriña beella elu nzuebeella. ");
INSERT INTO zplNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chenu uyeꞌe lu yuu stucu bichia, bee bene enu nucuaꞌa stucu chu inzatuꞌ zeꞌe uriꞌibeei beyaꞌ nú nzue bee beneꞌ Jesuse liñi tucu barco nú tuculiꞌ nzu zeꞌe, pero né chaa Jesuse cuna liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Che chiucu chuna bee barco nú nzeꞌta enza eyeche Tiberias, uriña bee axu elu udacu bee bene pá chenu ulaxu nú udeteꞌ Jesuse cheꞌtsa lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Chequie chenu ulañiꞌ bee bene zeꞌe nú lecaꞌ Jesuse nu niꞌ bee beneꞌnu zeꞌe, che uyuꞌu beei liñi bee barco zeꞌe nzuebeei eyeche Capernaum nze cuaꞌna beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chenu uriña beei stucu chú inzatuꞌ zeꞌe, ullunaꞌ beei Jesuse nu unidichiaꞌ beei lunu: ―Maestro, ¿xunga uriñalu caꞌa? ");
INSERT INTO zplNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nu ucuaqui Jesuse lubeei: ―Nediya nzeꞌcaa nú rlaꞌnahua liꞌá, la necane equie bee milagro nú ulañiꞌhua nú uriꞌá, liꞌihua rlaꞌnahua liꞌá equie nú udacuhua hasta nú ubelaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","La chenu arquiꞌhua equie bee elubacu nú rlaxu, sino que uyanu arquiꞌhua equie bee elubacu nú rliquiꞌ elunehuañi nú leca xunga laxu lu Diose. Nu elunehuañi cuaꞌ neca nú rliquiꞌ Bene enu uxeꞌla Diose lu iliulabe quieꞌ, nu ucañila Diose liꞌinu para nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chequie unidichiaꞌ beei lunu: ―¿Xi rquiꞌña riꞌiru para nú riꞌiru lunú niarquiꞌ Diose nú riꞌiru? ");
INSERT INTO zplNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nu ucuaqui Jesuse lubeei: ―Lunú niarquiꞌ Diose nú riꞌihua, necane nú chili arquiꞌhua Bene enu uxeꞌlanu lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Che unibeei lunu: ―¿Xi seña lubeꞌlu luru para nú chili arquiꞌru liꞌilu? ¿Nu xi milagro rriꞌilu? ");
INSERT INTO zplNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bee beneꞌahua enu udetela udacu beella maná chenu ucuaꞌa beella lu dañi achi elu la nucaꞌa bee bene, tucu nú rni lu ichiꞌ Stichiaꞌ Diose elu rni: “Nú Diose udeteꞌ pá nú ulaca enza liñibe udacu beella.” ");
INSERT INTO zplNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chequie uni Jesuse lubeei: ―Liꞌá neli ixiuleꞌa luhua nú la neca Moisés enu uliquiꞌ pá nú ulaca enza liñibe, Pa neca enu rliquiꞌ mero pá liñibe. ");
INSERT INTO zplNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Xne pá nú rliquiꞌ Diose, liꞌinu ubeꞌtanu enza liñibe nu rliquiꞌnu elunehuañiꞌ bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nu unibeei lunu: ―Detá, ye bichia uliꞌquiꞌ pá cuaꞌ luru. ");
INSERT INTO zplNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Che uni Jesuse lubeei: ―Liꞌá neca pá nú rliquiꞌ elunehuañi. Nu enu yeꞌta cuna liꞌá lecaꞌ xunga liaꞌnaꞌ nzeꞌe. Nu enu chili arquiꞌ liꞌá, lecaꞌ xunga bichiꞌ nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero tucu nú unilá luhua, añinzuca nú ulañiꞌlaꞌhua liꞌá pero la chili arquiꞌhua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ye bee bene enu uxeꞌla Paa lua, nzeꞌta bee nzeꞌe cuna liꞌá, nu bee bene enu nzeꞌta lua, la luachua bee nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Xne liꞌá nzela desde liñibe para nú riꞌá tucu nú niarquiꞌ Pa Diose enu uxeꞌla liꞌá, nu lá yela para nú riꞌá tucu nú niarquitsia. ");
INSERT INTO zplNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nu Pa enu uxeꞌla liꞌá, lunú niarquiꞌnu necane nú ye bee bene enu uxeꞌlanu lua la nitia niꞌ tucu beei, sino que riꞌá nú huañi zeca beei chenu riꞌi Diose elu usticiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Xne Pa Diose niarquiꞌnu nú ye bee bene enu zela nú chili arquiꞌ Lliꞌñinu, luꞌcu beella elunehuañi nú leca xunga laxu cuna liꞌinu. Nu liꞌá riꞌá nú huañi zeca beella chenu riꞌi Diose elu usticiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Che uquixie bee bene Israel nú uzeꞌta beei Jesuse, equie nú uninu: “Liꞌá neca pá nú ulaca enza liñibe.” ");
INSERT INTO zplNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nu unibeei: ―¿Xieꞌ lacanú nucuaꞌ neca Jesuse llianaꞌ José la? Liaꞌahua nuꞌluꞌahua paꞌ nucuaꞌ cuna naꞌ nucuaꞌ. Nu ¿xinu rni nucuaꞌ nú ulaca nucuaꞌ enza liñibe? ");
INSERT INTO zplNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Chequie uni Jesuse lubeei: ―Utsanaꞌhua nú seꞌtahua liꞌá lusaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Lecati aca yeꞌta lua, tunu la xeꞌla Diose nzeꞌe lua. Liꞌinu enu uxeꞌla liꞌá, nu liꞌá riꞌá nú huañi zeca nzeꞌe chenu riꞌi Diose elu usticiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lu libro nú uquieꞌe bee profetaꞌ Diose rni: “Diose zeteꞌ ye bee bene.” Enzeꞌe ye bee enu rieneꞌ stichiaꞌnu, nu reca lunú seteꞌnu, liꞌibeella nzeꞌta beella cuna liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Niꞌ tucu lecati lascaꞌ lañiꞌ Diose, enu uxeꞌlatsia Diose lu iliulabe ulañiꞌlaꞌ liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Neli rnia luhua nú enu nzeli arquiꞌ liꞌá, rluꞌcula nzeꞌe elunehuañi nú leca xunga laxu lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Liꞌá neca pá nú rliquiꞌ elunehuañi. ");
INSERT INTO zplNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bee beneꞌhua enu udetela udacu beella maná lu dañi achi elu la nucuaꞌa bee bene, nu añica nú unguti beella; ");
INSERT INTO zplNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","pero liꞌá rnia luhua equie cuendaꞌ pá nú ulaca enza liñibe, nu bene enu acune la atiaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Liꞌá neca pá nú nehuañi nú ulaca enza liñibe, nu enu acu pá quieꞌ, luꞌculla elunehuañi nú leca xunga laxu lu Diose. Nu pá nú rliquia necane cuerpoa. Liꞌá detene para nú luꞌcu bee bene iliulabe elunehuañi. ");
INSERT INTO zplNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chequie uquixie bee bene Israel zeꞌe nú unixuu beei lu saꞌbeei, nú unibeei: ―¿Xamodo aca benecuaꞌ liquiꞌ nucuaꞌ cuerpoꞌ nucuaꞌ daꞌcuaꞌahua? ");
INSERT INTO zplNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Che uni Jesuse lubeei: ―Liꞌá neli nia luhua nú tunu la acuhua cuerpoꞌ Bene enu uxeꞌla Diose nu tunu la hueꞌhua reneꞌnu la luꞌcuhua elunehuañi che. ");
INSERT INTO zplNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pero enu acu cuerpoa nu hueꞌ renea, luꞌcu nzeꞌe elunehuañi nú leca xunga laxu lu Diose, nu liꞌá riꞌá nú huañi zeca nzeꞌe chenu riꞌi Diose elu usticiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Xne cuerpoa neca elubacu nú neli neca, nu renea neca nú neli neca nú hueꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nu bene enu acu cuerpoa nu hueꞌ renea, liꞌilla nehuañilla cuna liꞌá, nu liꞌá nehuañia cuna liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Pa liñibe enu uxeꞌla liꞌá rluꞌcunu elunehuañi, nu liꞌá nehuañia equie cuendaꞌ liꞌinu. Leꞌca esquie enu racu cuerpoa luꞌcu nzeꞌe elunehuañi lu Diose equie cuendaꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Liꞌá rnia equie cuendaꞌ pá nú ulaca enza liñibe. Nu la neca pá quieꞌ xi neca maná nú udacu bee beneꞌhua enu udetela, xne añinzuca nú udacu beellae unguti beella, pero bene enu acu páquieꞌ luꞌcu nzeꞌe elunehuañi nú leca xunga laxu lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Bee nucuaꞌ neca nú uzeteꞌ Jesuse bee bene liñi indu Capernaum. ");
INSERT INTO zplNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chenu ubeneꞌ beei lunú uzeteꞌ Jesuse liꞌibeei huaxi bee bene enu nzequie liꞌinu unibeei: ―Chiquiꞌ neriñaꞌ nú riꞌahua beyaꞌ xa neca nú rni stichiaꞌnu. ¿Ti aca riꞌi caso lunú rninu? ");
INSERT INTO zplNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Chenu uriꞌi Jesuse beyaꞌ lunú rnibeei, che uninu lubeei: ―¿Xieꞌ rcuu arquiꞌhua lunú unia scua la? ");
INSERT INTO zplNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Xa riꞌihua tunu lañiꞌhua nú quie zeca Bene enu uxeꞌla Diose elu nzucunu huaꞌtu? ");
INSERT INTO zplNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Equie cuendaꞌtsia Espíritu Santo rluꞌcu bene elunehuañi nú leca xunga laxu, lecaxi aca bene riꞌilla leꞌcatsia liꞌilla. Nu equie cuendaꞌ Espíritu Santo nzeꞌta bee bedichiaꞌ nú unilá luhua, nu equie cuendaꞌ bee bedichiaꞌ cuaꞌ rluꞌcu bene elunehuañi. ");
INSERT INTO zplNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero nuꞌscaꞌhua enu la chili arquiꞌ liꞌá. Uni Jesuse scua xne nediyaꞌ nzeꞌcaꞌnu desde ante nú taa bee bene enu la chili arquiꞌ liꞌinu, nu ta bene enu deteꞌ cuenda liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nu leꞌca uninu lubeei: ―Enzeꞌe unia luhua nú lecati aca yeꞌta lua, tunu la xeꞌla Pa liñibe nzeꞌe lua. ");
INSERT INTO zplNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Desde bichia zeꞌe, huaxi bee bene enu uyaquie Jesuse chu utsanaꞌ arquiꞌbeei liꞌinu, nu nechenzenuaꞌbeei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chequie uni Jesuse lu ye chiꞌchiucu bee beneꞌnu: ―¿Leꞌca nuhua niarquiꞌhua chuehua la? ");
INSERT INTO zplNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pero ucuaqui Simón Pedro lunu nú unilla: ―Detá, ¿tilu nzaꞌaru che? Xne stichiaꞌlu neca nú nzeꞌta yuu elunehuañi nú leca xunga laxu lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Liꞌiru nzelíla arquiꞌru liꞌilu, nu nediyaꞌlaꞌru nú necalu Cristo Lliꞌñi Diose enu nehuañi. ");
INSERT INTO zplNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Chequie uni Jesuse lubeella: ―Añinzuca nú liꞌá ucañia lu ye chiꞌchiucuhua, pero nuꞌ tucuhua enu neca bezeꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Uni Jesuse scua, equie cuendaꞌ Judas llianaꞌ Simón Iscariote, xne Judas quieꞌ neca enu udeteꞌ cuenda liꞌinu, añinzuca nú necai tucu lu chiꞌchiucu bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lulá bee nucuaꞌ, uya Jesuse lu iliu Galilea. Lá niarquiꞌnu achaanu lu iliu Judea, xne bee bene cuaꞌ rlaꞌna beei liꞌinu para nú úti beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pero lunú nzeꞌta axula eliñiꞌ bee bene Israel, chenu rcuaꞌa beella liñi bee ranchu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Che uni bee bichi Jesuse lunu: ―La yaꞌnalu caꞌa, uquia lu iliu Judea, para nú leꞌca lañiꞌ bee beneꞌlu enu nucuaꞌa zeꞌe bee milagro nú rriꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Xne chenu niarquiꞌ bene nú riꞌi bee bene beyaꞌ lunú rriꞌilla, la yala nú riꞌilla nucuaꞌ aꞌchiꞌ. Nee lunú rriꞌilu bee milagro cuaꞌ, uriꞌi nucuaꞌ ante lu ye bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Uni bee bichi Jesuse scua xne niꞌ liꞌibeei la chili arquiꞌbeei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Chequie uni Jesuse lubeei: ―Lascaꞌ riña horaa, pero para liꞌihua xitse hora neca nzeꞌca. ");
INSERT INTO zplNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Leca modo chana arquiꞌ bee bene iliulabe liꞌihua, pero liꞌisia rana arquiꞌbeei, xne rixiuleꞌa lubeei nú necha neca lunú rriꞌi beei. ");
INSERT INTO zplNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Uquiahua lu eliñi cuaꞌ, xne la chaꞌscaꞌa, xne lascaꞌ riña hora nú chaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chenu ulaxu nú uninu scua lubeei, uyaꞌnanu Galilea. ");
INSERT INTO zplNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Lulá nú nzue bee bichi Jesuse lu eliñi zeꞌe, cheelá nzanu para nú lecati riꞌi beyaꞌ nú leꞌca nunu nzanu lu eliñi zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nu bee bene Israel rlaꞌna liꞌinu lu eliñi zeꞌe, nu unibeei: ―¿Cáche nzu bene zeꞌe? ");
INSERT INTO zplNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Leta huaxi bee bene enu uya lu eliñi zeꞌe, yelu nú rnibeei lu cuendaꞌnu. Nuꞌ beei enu rni: “Ñia nzeꞌcanu”; nu nuꞌ beei enu rni: “La riꞌi nzeꞌcanu, sino que sequienunu bee bene.” ");
INSERT INTO zplNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero niꞌ tucu beei né ni beei lu cuendaꞌnu ante luye bee bene, xne xiqui beei bee usticia Israel. ");
INSERT INTO zplNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chenu unga arulaꞌla nú reca eliñi zeꞌe, uyuꞌu Jesuse liñi indu llene Jerusalén, nu uquixienu nú uzeteꞌnu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Che bee bene Israel chiquiꞌ nzenu arquiꞌbeei nú unibeei: ―¿Xa reca nucuaꞌ huaxi beenú reca nucuaꞌ nu lecati uzeteꞌ liꞌi nucuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Chequie uni Jesuse lubeei: ―La zetea liꞌihua lunú necatsia elliebacua, sino que nzeꞌta nucuaꞌ lu Diose enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tunu nuꞌ enu niarquiꞌ nú riꞌi tucu nú niarquiꞌ Diose, liꞌilla riꞌilla beyaꞌ tunu nú setea liꞌihua nzeꞌtae lu Diose, urre necane nú necatsia elliebacua. ");
INSERT INTO zplNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Enu seteꞌ lunú necatsia elliebacuꞌ, liꞌilla rriꞌilla scua para nú zucuꞌ aya bee bene liꞌilla. Pero bene enu rlaꞌna nú zucuꞌ aya bee bene Diose enu uxeꞌla liꞌinu, rnilla lunú neli neca, nu la zequienulla bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Añinzuca nú utsaꞌna Moisés ley luhua, pero niꞌ tucuhua, la zucuꞌ nú rnibiyaꞌ ley. ¿Nu xinu niarquiꞌhua nú útihua liꞌá? ");
INSERT INTO zplNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chequie ucuaqui bee bene zeꞌe lunu nú unibeei: ―¡Benechiquiꞌ nuꞌ arquiꞌlu! ¿Ti niarquiꞌ úti liꞌilu? ");
INSERT INTO zplNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nu uni Jesuse lubeei: ―Equie tucu milagro nú uriꞌá bichia nú sulachi bee bene, yehua chiquiꞌ nzenu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero liꞌihua mase nú neca bichia nú sulachi bee bene rquieꞌehua seña bee enduꞌ meꞌhua para nú riꞌihua tucu nú unibiyaꞌ Moisés nú riꞌihua, añinzuca nú la neca equie cuendaꞌ Moisés nú rquie seña bee enduꞌ meꞌhua sino que bee beneꞌhua enu udetela rriꞌila scua huatu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Neequie, para nú la iꞌchiahua lunú rni leyꞌ Moisés rquieꞌehua seña bee enduꞌ niyu masia nú necane bichia nú sulachi bee bene. Nu, ¿xiquie nú rlehua lua nú uriyeca tucu niyu bichia nú sulachi bee bene? ");
INSERT INTO zplNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","La nihua lu cuendaꞌ bee bene lunú rlañiꞌtsiahua rriꞌi bee bene sino que rlutixu uriꞌinzeꞌcahua beyaꞌ xi rriꞌilla che nihua. ");
INSERT INTO zplNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Chequie chiucu chuna bee bene Jerusalén unibeei lu saꞌbeei: ―¿Xieꞌ lanu benequieꞌ neca enu rlaꞌna bee bene para nú úti beei la? ");
INSERT INTO zplNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nu nee luꞌ nzulla rnilla ante lu ye bee bene, nu lecati riꞌchialla. ¿Xieꞌ uyalílaquie arquiꞌ bee usticia nú necalla Cristo la? ");
INSERT INTO zplNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero liaꞌahua nediyaꞌ nzeꞌcaꞌahua cá enza nzeꞌtalla, nu chenu nzeꞌta Cristo, lecati riꞌibeyaꞌ cá enza nzeꞌtanu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Chenu ubeneꞌ Jesuse lunú rnibeei, diqui nú seteꞌnu bee bene liñi Indu llene Jerusalén, che juerte uninu lubeei: ―Liꞌihua rnihua nú nuꞌluhua liꞌá, nu leꞌca nediyaꞌhua cá enza nzela, pero liꞌá lá yelá equie cuendaꞌ liꞌitsia. Liꞌá uriña equie cuendaꞌ liꞌinu enu rni nú neli neca, nu liꞌihua la chuluhua liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero liꞌá nuꞌlua liꞌinu, xne nzela enza lunu nu liꞌinu uxeꞌlanu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chenu ubeneꞌbeei nucuaꞌ uniarquiꞌbeei nú naꞌtse beei Jesuse, pero lecati unaꞌtse liꞌinu xne lascaꞌ riña hora nú xi riꞌinu beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nulu huaxi añi bee bene enu nucuaꞌa zeꞌe, huaxi beei uchili arquiꞌ liꞌinu nu unibeei: ―Chenu yeꞌta Cristo, ¿xieꞌ riꞌilanu huaxilá bee milagro luquelá nú rriꞌi benequieꞌ la? ");
INSERT INTO zplNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ubeneꞌ bee fariseo lunú rni bee bene equie cuendaꞌ Jesuse. Che liꞌibeei cuna bee uleꞌya enu rnibiyaꞌ, uxeꞌla beei bee sundadu enu rriꞌi ucu Indu llene Jerusalén para nú naꞌtse beei Jesuse cha niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nu uni Jesuse lubeei: ―Lacaxeaꞌ nzula cuna liꞌihua nu chu benchilaꞌ zeca elu nzucu enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Liꞌihua laꞌnahua liꞌá pero la llelaꞌhua liꞌá, xne leca modo riñahua elu nzaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Che bee bene Israel zeꞌe unibeei lu saꞌbeei: ―¿Cá nza nucuaꞌ nú la llelaꞌahualla che? ¿Xieꞌ nzalla lubee bene Israel enu uriꞌchialetse leta bee bene enu la neca bee bene Israel para nú zeteꞌlla hasta bee bene enu laca bee bene Israel la? ");
INSERT INTO zplNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Xa neca nú uni nucuaꞌ: “Nú laꞌnahua liꞌá pero la llelaꞌhua liꞌá, xne leca modo riñahua elu nzaꞌa”? ");
INSERT INTO zplNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ultimo bichia eliñi zeꞌe, neca bichia nú másela llene neca nu utsuli Jesuse nu juerte uninu: ―Tunu nuꞌ enu rebichiꞌ yeꞌta nzeꞌe lua para nú hueꞌ nzeꞌe inza. ");
INSERT INTO zplNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Xne bee bene enu chili arquiꞌ liꞌá, tucu nú rni lu ichiꞌ Stichiaꞌ Diose, liñi arquiꞌ nzeꞌe liñi inza nú rliquiꞌ elunehuañi. ");
INSERT INTO zplNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chenu uni Jesuse scua. Nu nú uninu rni, nú yebee bene enu chili arquiꞌ liꞌinu huañi Espíritu Santo cuna bee nzeꞌe, xne bee bichia zeꞌe lá riñascaꞌ Espíritu Santo equie nú lecascaꞌ Jesuse elu rnibiyaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chenu ubeneꞌ bee bene zeꞌe nú uni Jesuse, nuꞌbeei enu uni: ―Neli nú benequieꞌ neca profeta enu nzu nú nzeꞌta. ");
INSERT INTO zplNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nu nuꞌlá beei enu uni: ―Benequieꞌ neca Cristo. Pero texcuaꞌa beei uni: ―Laca liꞌilla Cristo xne necalla bene Galilea. ");
INSERT INTO zplNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Lu ichiꞌ Stichiaꞌ Diose rni nú lubee familiaꞌ arre David nzeꞌta Cristo, nu eyeche Belén alanu elu leꞌca unga lachi arre David. ");
INSERT INTO zplNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nu scua uleꞌesaꞌ bee bene equie cuendaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nu nuꞌbeei uniarquiꞌ nú chanu niꞌcuꞌ, pero lecati ulaca arquiꞌ anaꞌtse liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chequie bee sundado enu rriucu Indu llene Jerusalén zeꞌe, ubenchilaꞌ zeca beei elu nucuaꞌa bee fariseo cuna bee uleꞌya enu rnibiyaꞌ, nu uni bee bene cuaꞌ lubeei: ―¿Xinu lá yeꞌtayuhualla? ");
INSERT INTO zplNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nu ucuaqui bee sundado zeꞌe nú unibeei: ―Leca xunga, uyuꞌu tucu bene enu rni tucu nú rni benecuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Che uni bee fariseo zeꞌe lubeei: ―¿Xieꞌ leꞌca nuhua uzelahua nú uzequienu nucuaꞌ liꞌihua la? ");
INSERT INTO zplNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Xieꞌ nuꞌtátucu bee usticiaꞌahua urre nuꞌ tátucuaꞌahua bee fariseo enu uchilila arquiꞌ liꞌilla la? ");
INSERT INTO zplNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¿Xieꞌ la riꞌihua beyaꞌ nú huaxi bee benequieꞌ nenitilula beei ante Diose, equie nú la aca beei ley la? ");
INSERT INTO zplNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Che fariseo enu lee Nicodemo enu uyabiꞌya Jesuse tucu reché, liꞌilla unilla: ");
INSERT INTO zplNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Leyꞌahua rni nú leca modo niaꞌahua nú xi castiya riala tucu bene ante nú yeneꞌahua stichiaꞌlla para nú riaꞌahua beyaꞌ xi uriꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Chequie ucuaqui beei lulla nú unibeei: ―¿Xieꞌ leꞌca nuulu nzulu chuꞌ bee bene Galilea la? Uzeꞌteꞌ nzeꞌca lu ichiꞌ Stichiaꞌ Diose, para nú riꞌilu beyaꞌ nú niꞌ tucu bene Galilea lá aca profeta. ");
INSERT INTO zplNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Che chu nziue beei enza niꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nu nza Jesuse enza dañi Olivos, ");
INSERT INTO zplNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","nu chenu uyeꞌe lu yuu stucu bichia, ubenchilaꞌ zecanu liñi indu llene Jerusalén, che uyetesaꞌ huaxi bee bene lunu zeꞌe, nu chu uzucunu nu uquixienu uzeteꞌnu liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Che bee ulaxcuela enu reca leyꞌ Moisés cuna bee fariseo, unguyaꞌbeei tucu unaꞌa enu ullunanuu tucu niyu, nu utsu beei liꞌinchu arliꞌtiꞌ bee bene enu nucuaꞌa zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nu unibeei lu Jesuse: ―Maestro, unaꞌaquieꞌ ullunanunchu tucu niyu mero chenu nucuaꞌanu saꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lu ley nú utsaꞌna Moisés luaꞌahua rni: ―Nú saꞌ bee unaꞌaquieꞌ, rquiꞌña nú atinchu cuna quiee, nu liꞌiquielu, ¿xa nilu nee? ");
INSERT INTO zplNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Liꞌibeei unidichiaꞌ beei lunu scua para nú biꞌya xi ninu, nu scua luꞌcu beei xi ricuꞌquiya beei liꞌinu, pero chu uziꞌquindiqui Jesuse, nu uquixienu rquieꞌenu cuna cuene yaanu lu yuu. ");
INSERT INTO zplNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero lunú chu rnidichiaꞌscaꞌlá beei lunu, che uzucu nelínu nu uninu lubeei: ―Tatsehua enu la luꞌcu dula, rlutilá nzeꞌe duꞌquiee unaꞌa quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Che uziꞌquindiqui zecanu núchu rquieꞌelánu lu yuu. ");
INSERT INTO zplNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bee bene enu uyayu unaꞌa zeꞌe lu Jesuse, chenu ubeneꞌ beei nú uni Jesuse scua, che uquixie nú tucua tucua beei nziue beei, desde enu unguxu nu hasta bee enu nereꞌnelá, nziue ye beei nu utsaꞌnatsia beei unaꞌa zeꞌe cuna Jesuse lu ye bee bene enu nucuaꞌa zeꞌe cuna liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chequie uzucu neli Jesuse nu uninu lu unaꞌa zeꞌe: ―Unaꞌa, ¿ma bee bene enu ubeꞌtayu liꞌilu caꞌa? ¿Xieꞌ niꞌtucu beei lecaxi uriꞌinu liꞌilu la? ");
INSERT INTO zplNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nu ucuaquinchu: ―Niꞌtucu beei detá. Che uni Jesuse lunchu: ―Niꞌliꞌá lecaxi riꞌinua liꞌilu, uquia nee nu la riaꞌlu dula. ");
INSERT INTO zplNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chequie uni zeca Jesuse lubee bene enu nucuaꞌa zeꞌe: ―Liꞌá neca ellieꞌe lubee bene iliulabe. Bee bene enu zucuꞌ stichiaꞌa, chuꞌu ellieꞌe elliebacuꞌ beella, nú xa luꞌcu beella elunehuañi ante Diose, nu leca xunga tsunecabe elliebacuꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nu uni bee fariseo lunu: ―Liꞌilu rnilu leꞌca lu cuendaꞌ liꞌitsialu, nu lunú rnilu la zibiꞌi. ");
INSERT INTO zplNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nu ucuaqui Jesuse nú uninu lubeei: ―Stichiaꞌa si zibiꞌi, añinzuca nú rnia lu cuendaꞌ liꞌá. Xne liꞌá nediyaa cá enza nzela nu cá enza nzaꞌa, pero liꞌihua la riꞌihua beyaꞌ cá enza nzela nu cá enza nzaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Liꞌihua rnihua lu cuendaꞌ bee bene tucu nú rriꞌitsiahua elliebacuꞌ. Pero liꞌá la nia lu cuendaꞌ niꞌ tucu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nu liꞌá rnia lu cuendaꞌ bee bene, lunú neli neca. Xne la nia tucu nú necatsia elliebacua, sino que Paa enu uxeꞌla liꞌá nediyaꞌnu nú neli neca lunú rnia. ");
INSERT INTO zplNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lu leyꞌhua rni nú chenu nuꞌ chiucu bene enu tucu nchiucuꞌtse stichiaꞌ neli lunú rnibeei. ");
INSERT INTO zplNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nee leꞌca liꞌá neca tucu enu rni lu cuendaꞌ liꞌá, nu Paa enu uxeꞌla liꞌá neca stuculla. ");
INSERT INTO zplNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chequie unidichiaꞌ beei lunu: ―¿Ca nzucu paꞌlu che? Nu ucuaqui Jesuse lubeei: ―Liꞌihua la chuluhua liꞌá, nu leꞌca la chuluhua Paa xne tunu uyuꞌluhua liꞌá, leꞌca nuꞌluhua Paa. ");
INSERT INTO zplNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Scua uni Jesuse diqui nú seteꞌnu bee bene liñi Indu llene Jerusalén elu nchiucuꞌ bee alcancía elu riuꞌu bee uꞌna. Pero niꞌtucu lecati unaꞌtse liꞌinu, xne lascaꞌ riña hora nú llunanu. ");
INSERT INTO zplNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nu leꞌca uninu lubeei: ―Chenu nzaꞌa liꞌihua laꞌnahua liꞌá, pero liꞌihua atihua cuna stulahua, xne elu nzaꞌa leca modo chuehua zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nu uni bee bene Israel zeꞌe: ―¿Xieꞌ leꞌca liꞌitsialla útilla liꞌilla, enzeꞌe rnilla nú leca modo chaꞌahua elu nzalla la? ");
INSERT INTO zplNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Chequie uni Jesuse lubeei: ―Liꞌihua necahua bene lu yuu quieꞌ pero liꞌá nzela enza liñibe, liꞌihua necahua bee bene iliulabe, pero liꞌá la neca bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Enzeꞌe unia luhua nú atihua cuna stulahua. Xne tunu la chili arquiꞌhua nú liꞌá neca enu necaa, che atinuhua stulahua. ");
INSERT INTO zplNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nu unidichiaꞌ beei lunu: ―¿Ti necalu che? Nu ucuaquinu lubeei: ―¿Desde chenu uquixiea nú rnia luhua, unilá luhua nú ti necaa? ");
INSERT INTO zplNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Huaxi nú rquiꞌña zetea liꞌihua nu nia equie cuendaꞌhua. Pero nee lunú rnia lubee bene iliulabe, necane nú rienea rni enu uxeꞌla liꞌá, nu lunú rninu neli necane. ");
INSERT INTO zplNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero liꞌibeei né riꞌi beei beyaꞌ nú equie cuendaꞌ Diose neca nú rninu. ");
INSERT INTO zplNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Enzeꞌe uninu lubeei: ―Chenu uriꞌilahua lunú niarquiꞌhua cuna liꞌá Bene enu uxeꞌla Diose che riꞌihua beyaꞌ nú liꞌá neca enu neca, nu la riꞌitsia lunú necatsia elliebacua. Sino que rnitsia lunú uzeteꞌla Diose liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Xne liꞌinu enu uxeꞌla liꞌá nzunu cuna liꞌá nu lecaꞌ bichia nu tsanaꞌ arquiꞌnu liꞌá, xne rriꞌá puro lunú riuꞌu arquiꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Chenu ulaxu nú uni Jesuse scua, huaxi bee bene uyalí arquiꞌ liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Che uni Jesuse lubee bene Israel enu uyalí arquiꞌ liꞌinu: ―Tunu nzezucuꞌláhua stichiaꞌa. Che si neli necahua bee benea. ");
INSERT INTO zplNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nu chuluhua nú neli neca, nu equie cuendaꞌ nú neli neca cuaꞌ, laꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Che ucuaqui beei: ―Liꞌiru nzelaru lu familiaꞌ tuxie Abraham, nu leca xunga unga neiquiru. ¿Xiquie nú rnilu nú aca nelaꞌaru che? ");
INSERT INTO zplNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nu uni Jesuse lubeei: ―Neli nia luhua nú ye bee bene enu rriꞌi dula, neca beei xi neca esclavo lu dula. ");
INSERT INTO zplNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nu tucu esclavo la yaꞌnalí nzeꞌe niꞌ bene enu utsi liꞌi, pero llianaꞌ bene enu utsi esclavo zeꞌe sii nuꞌ modo riaꞌnalii niꞌ paꞌi. ");
INSERT INTO zplNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Enzeꞌe tunu Lliꞌñinu tsilaꞌa liꞌihua, che si neli nelaꞌahua ché. ");
INSERT INTO zplNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nediyaa nú nzeꞌtahua lu familiaꞌ tuxie Abraham. Pero liꞌihua niarquiꞌhua nú útihua liꞌá, xne la yuꞌ arquiꞌhua stichiaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Liꞌá rnia lunú uzeteꞌla Paa liꞌá, pero liꞌihua rriꞌihua lunú rni paꞌhua luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chequie ucuaqui beei: ―¡Paꞌru neca tuxie Abraham! Nu uni Jesuse lubeei: ―Tunu liꞌihua neli necahua llianaꞌ tuxie Abraham liꞌihua, riꞌihua tucu nú uriꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero liꞌihua añinzuca nu unilá nú neli neca luhua, tucu nú uzeteꞌla Diose liꞌá, nu liꞌihua niarquiꞌhua nú útihua liꞌá. ¡Nu tuxie Abraham lá riꞌilla scua! ");
INSERT INTO zplNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pero liꞌihua rriꞌihua tucu nú rriꞌi paꞌhua. Nu unibeei lunu: ―Liꞌiru lecati lliꞌñilá necaru, tucutsia Diose neca paꞌru. ");
INSERT INTO zplNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Che ucuaqui Jesuse lubeei: ―Tunu neli nú neca Diose paꞌhua secahua liꞌá, xne equie cuendaꞌ liꞌinu nzela lu iliulabe, lá yela lu cuendaꞌ liꞌitsia sino que liꞌinu necanu enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","La riꞌihua beyaꞌ lunú rnia luhua, xne la niarquiꞌhua nú zucuꞌ diacahua stichiaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Enu neca paꞌhua neca bezeꞌlu, nu rriꞌihua tucu nú niarquiꞌ bezeꞌlu nú riꞌihua. Desde chenu uquixie iliulabe riuꞌ arquiꞌ bezeꞌlu nú úti bee bene saꞌ bee bene. Leca xunga uyuꞌu bichia nú nzenalai lunú neli neca, xne la ni lunú neli neca chenu rni eluquichiaꞌ, nu scua rlubeꞌ nuxa necai, xne necai enu niquichiaꞌ, nu liꞌi necai paꞌ eluquichiaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero liꞌá lunú rnia lunú neli neca, la chili arquiꞌhua lunú rnia. ");
INSERT INTO zplNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Tahua nuꞌ beyaꞌ ni nú rluꞌcua dula che? Nu tunu neli neca lunú rnia luhua, ¿xiquie nu la chili arquiꞌhua liꞌá che? ");
INSERT INTO zplNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bee bene enu neca bee beneꞌ Diose sucuꞌ diaca beella Stichiaꞌ Diose, pero liꞌihua la acahua beneꞌ Diose, enzeꞌe la zucuꞌ diacahua stichiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chequie uni bee bene Israel zeꞌe lunu: ―Neli lunú rniru nú benechiquiꞌ nchiñi arquiꞌlu, nu bene Samaria necalu. ");
INSERT INTO zplNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Che ucuaqui Jesuse lubeei: ―Niꞌ tucu benechiquiꞌ leca arquia, sino que liꞌá sucua stichiaꞌ Paa, pero liꞌihua puro bedichiaꞌ nú necha se rriꞌchiahua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Liꞌá la laꞌna nú zucuꞌ aya bee bene liꞌá, pero nuꞌ enu niarquiꞌ nú zucuꞌ aya bee bene liꞌá, nu liꞌinu necanu enu rriꞌi elu usticia. ");
INSERT INTO zplNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Neli rnia luhua nú titse bene enu zucuꞌ stichiaꞌa, lecaꞌ xunga ati nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nu uni bee bene Israel zeꞌe lunu: ―Nee siꞌ neliꞌru nú rniru nú nchiñi benechiquiꞌ arquiꞌlu. Abraham cuna ye bee profeta unguti beella, nu liꞌilu rnilu: “Titse bene enu zucuꞌ stichiaꞌa lecaꞌ xunga ati nzeꞌe.” ");
INSERT INTO zplNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Xieꞌ másela neca equielu luquelá tuxie Abraham beneꞌru enu udetela la? Liꞌilla ungutilla nu leꞌca unguti bee profeta. Nu liꞌilu. ¿Ti siꞌlu nú necalu? ");
INSERT INTO zplNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Che ucuaqui Jesuse: ―Tunu leꞌcatsia liꞌá sucu ayaa liꞌá, lecaxi sibiꞌ lunú rnia lu cuendaꞌ liꞌá che. Pero enu sucuꞌ aya liꞌá neca Paa, liꞌinu enu rnihua nú neca Dioseꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Liꞌihua la chuꞌluhua liꞌinu. Pero liꞌisiꞌa nuꞌlua liꞌinu. Nu tunu nia luhua nú la chulua liꞌinu, che neca tucu bene enu niquichiaꞌ tucu nú necahua. Pero liꞌá nuꞌlua liꞌinu nu sucua stichiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tuxie Abraham beneꞌhua enu udetela ñia utsu arquiꞌlla nú lañiꞌlla bichia nú nzela lu iliulabe. Nu chenu ulañiꞌlla bichia cuaꞌ másela ñia utsu arquiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nu uni bee bene Israel zeꞌe lunu: ―Pero niꞌ cincuenta lana lascaꞌ luꞌculu nu rnilu nú ulañiꞌlaꞌlu Abraham. ");
INSERT INTO zplNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chequie uni Jesuse lubeei: ―Neli nialuhua nú nzulá ante nú ala Abraham. ");
INSERT INTO zplNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Che unaꞌtse beei quiee nzetuꞌ beei liꞌinu, pero chu uyuꞌunu leta bee bene, nu udetenu labe beei uchiuꞌunu liñi indu zeꞌe nu chu nzanu. ");
INSERT INTO zplNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Chenu nzedete Jesuse tucu luhuare ulañiꞌnu tucu niyu enu la yeꞌe lu desde nú ungulalla. ");
INSERT INTO zplNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Chequie unedichiaꞌ bee beneꞌnu lunu: ―Maestro, ¿xinu layeꞌe lu niyu quieꞌ desde nú ungulalla? ¿Neca nucuaꞌ equie cuendaꞌ stula paꞌlla cuna naꞌlla la, urre necane equie cuendaꞌ stulalla la? ");
INSERT INTO zplNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nu ucuaqui Jesuse nú uninu: ―La nequieꞌlu niyuquieꞌ equie cuendaꞌ stulalla, niꞌ equie cuendaꞌ stula paꞌlla cuna naꞌlla. Liꞌilla nequieꞌlulla para nú lañiꞌ bee bene lunú reca Diose rriꞌi equie milagro nú aca lulla. ");
INSERT INTO zplNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nee diqui nú nuꞌscaꞌ tiembu, rquiꞌña nú riꞌahua lunú rni enu uxeꞌla liꞌá, xne nzeꞌta chenu laxu tiembu cuaꞌ, nú lecascaꞌ xi aca. ");
INSERT INTO zplNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nu diqui nú nzua lu iliulabe quieꞌ, liꞌá neca ellieꞌe para lubee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chenu ulaxu nú uni Jesuse scua, chee utsuxenenu lu yuu nu urecheꞌnu ebenu cuna xenenu nu uduꞌnu ebenu cuaꞌ iꞌculu niyu enu la yeꞌe lu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nu uninu lulla: ―Uquia uquiee lulu ruꞌu estanque nú lee Siloé ―Siloé, rni nucuaꞌ. Enu uxeꞌla. Che uya niyu zeꞌe nu uquiella lulla, nu chenu ubenchilaꞌlla riꞌyalalla. ");
INSERT INTO zplNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chequie bee besiñuꞌlla cuna bee bene enu nediyaꞌ nú rnacuꞌlla caridá unibeei: ―¿Xieꞌ lacanu niyuquieꞌ neca enu sucu rnacuꞌ caridá la? ");
INSERT INTO zplNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nuꞌ beei rni: ―Liꞌilla nucuaꞌ. Leꞌca nuꞌlá beei enu rni: ―Xi rnaa nzeꞌe rnaalla pero laca liꞌilla. Che uni niyu zeꞌe: ―Liꞌá nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chequie unedichiaꞌ beei lulla: ―¿Xaquie modo uriꞌilu nú uquixie riꞌyalu che? ");
INSERT INTO zplNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nu ucuaquilla nú unilla: ―Bene enu lee Jesuse urecheꞌenu ebenu uduꞌnu iꞌculua, che uninu lua: “Uquia uquie lulu ruꞌu estanque Siloé.” Nu chu uyaꞌa, nu chenu ulaxu nú uquiea lua riꞌyala. ");
INSERT INTO zplNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nu unibeei lulla: ―¿Ma bene zeꞌe che? Nu ucuaquilla: ―La riꞌá beyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chequie uyayu beei niyu enu unga niquieꞌlu zeꞌe lubee fariseo. ");
INSERT INTO zplNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Xne bichia nú urecheꞌe Jesuse ebenu nu uduꞌnue iꞌculu niyu zeꞌe para nú ubiꞌyai. Bichia zeꞌe neca bichia nú sulachi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nu unidichiaꞌ bee fariseo zeꞌe lulla, nú xa unga nú uquixie nú riꞌyalla nu ucuaquilla lubeei: ―Bene zeꞌe uduꞌ ebenu iꞌculua, nu chu uyaquiea lua, nu nee riꞌyalá. ");
INSERT INTO zplNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nuꞌ bee fariseo zeꞌe enu uni: ―Bene enu uriꞌiyeca i'cululu la acalla beneꞌ Diose, xne la luꞌculla ulaꞌna bichia nú sulachi bee bene. Pero stucu beei uni: ―¿Xa aca nucuaꞌ riꞌi nucuaꞌ milagro quieꞌ tunu rluꞌcu nucuaꞌ dula? Nu urene urene unibeei. ");
INSERT INTO zplNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chequie unidichiaꞌ zecaꞌla beei lu niyu enu unga niquieꞌlu zeꞌe: ―Nee nú uriꞌiyeca benecuaꞌ iꞌcululu, ¿ti neca nucuaꞌ secalu? Nu unilla: ―Liꞌá rnia nú neca nucuaꞌ tucu profeta. ");
INSERT INTO zplNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero bee bene Israel zeꞌe la chili arquiꞌbeei nú unga niquieꞌlu niyu zeꞌe, nu nee riꞌyalla. Che ubixia beei paꞌlla cuna naꞌlla, ");
INSERT INTO zplNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","para nú unidichiaꞌ beei lubeella: ―¿Xieꞌ ninguieꞌ enduꞌhua enu rnihua nú la yeꞌelu desde nú ungula la? Nee, ¿xaquie unga nú riꞌyai? ");
INSERT INTO zplNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chequie ucuaqui paꞌlla cuna naꞌlla: ―Nediyaꞌru nú necai llianaꞌru, nu leꞌca nediyaꞌru nú desde nú ungulai la yeꞌe lui. ");
INSERT INTO zplNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero la riꞌiru beyaꞌ xa unga nú riꞌyai, nu leꞌca la riꞌiru beyaꞌ ti uriꞌiyeca iꞌcului. Mejora unidichiaꞌhua lui unguxulacai, liꞌicai ixiuleꞌi luhua xa unga nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Uni paꞌlla cuna naꞌlla scua, equie nú xiqui beella, xne unga tucu necatsela bee bene Israel nú tatse bee enu ni nú neca Jesuse Cristo, la zelaꞌbeei nú chuꞌu nzeꞌe liñi indu. ");
INSERT INTO zplNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Enzeꞌe uni paꞌlla cuna naꞌlla: “Mejora lui nedichiaꞌhua, unguxulacai.” ");
INSERT INTO zplNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Che ubixia zeca beei niyu enu unga niquieꞌlu nu unibeei lulla: ―Nzucu Diose riꞌya, uniꞌ nú neli neca, xne nediyaꞌru nú bene enu uriꞌiyeca iꞌcululu necalla bene enu rluꞌcu dula. ");
INSERT INTO zplNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nu ucuaqui niyu zeꞌe: ―La riꞌá beyaꞌ tunu rluꞌculla dula, urre la luꞌculla dula, lunú nediyatsia nú ante unga niquieꞌlua nu nee riꞌya. ");
INSERT INTO zplNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chequie unidichiaꞌ zeca beei lulla: ―¿Xa uriꞌinu nucuaꞌ lulu? ¿Xa uriꞌi nucuaꞌ nú reca riꞌyalu? ");
INSERT INTO zplNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nu ucuaquilla: ―¿Unilá luhua, pero la chili arquiꞌhua nú rnia? ¿Xinu niarquiꞌhua nú ni zecaa luhua xa uriꞌilla? ¿Xieꞌ leꞌca nuhua niarquiꞌhua nú acahua beneꞌlla la? ");
INSERT INTO zplNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Che uquiꞌyaꞌlla uriꞌi beei nu unibeei lulla: ―Liꞌilu tunu necalu beneꞌlla. Pero liꞌiru necaru beneꞌ Moisés. ");
INSERT INTO zplNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xne liꞌiru nediyaꞌru nú Diose uni lu Moisés. Pero benecuaꞌ niꞌtemeꞌ la riꞌiru beyaꞌ cá enza nzeꞌtalla. ");
INSERT INTO zplNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Che uni niyu zeꞌe lubeei: ―¡Nú secalullieꞌ bene necahuaꞌ! Liꞌihua la riꞌihua beyaꞌ cá enza nzeꞌtalla pero liꞌilla uriꞌilla nú riꞌya nee. ");
INSERT INTO zplNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nediyaꞌ nzeꞌcaꞌhua nú Diose la riꞌi caso bee bene enu rluꞌcu dula, rriꞌi casotsianu bee bene enu sucuꞌ stichiaꞌnu nu rriꞌi lunú niarquiꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Leca xunga ubeneꞌahua nú nuꞌ tucu bene enu rriꞌi nú riꞌya tucu bene enu la yeꞌelu desde nú ungula. ");
INSERT INTO zplNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tunu benecuaꞌ la yeꞌtalla equie cuendaꞌ Diose. Lecaxi acalla ariꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Che unibeei lulla: ―Liꞌilu nú ungulanúlu stulalu, ¿xieꞌ liꞌilálu zeteꞌlu liꞌiru la? Nu ulua beei liꞌilla zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ungabiyaꞌ Jesuse nú ulua bee bene Israel zeꞌe niyu enu unga niquieꞌlu liñi indu, nu chenu ullaꞌcanu liꞌi uninu lui: ―¿Nzelí arquiꞌlu Bene enu uxeꞌla Diose la? ");
INSERT INTO zplNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nu ucuaquii nú uni: ―Detá, udixiuleꞌe tii nzeꞌe para nú chili arquia liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Che uni Jesuse lulla: ―Ulañiꞌlaꞌlulla, nu liꞌilla necalla enu rdichiaꞌnulu nee. ");
INSERT INTO zplNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chequie utsulliqui niyu zeꞌe lu Jesuse, nu uni: ―Nzelí arquia liꞌilu Detá. ");
INSERT INTO zplNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nu chu uni Jesuse: ―Liꞌá ubela lu iliulabe quieꞌ para nú riꞌá elu usticia, para nú lañiꞌ bee bene enu la lañiꞌ, nu bee enu rlañiꞌ la lañiaꞌ bee nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Chequie chiucu chuna bee fariseo enu nucuaꞌa lunu zeꞌe, chenu ubeneꞌ beei nú uninu scua, unibeei lunu: ―¿Xieꞌ leꞌca nuuru niquieꞌluru la? ");
INSERT INTO zplNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Che uni Jesuse lubeei: ―Tunu necacla nú niquieꞌluhua, lecaxi equiya rluꞌcuhua equie stulahua. Pero lunú rnihua nú riꞌyahua enzeꞌe rluꞌcuhua equiya. ");
INSERT INTO zplNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Che uni Jesuse: ―Neli nia luhua nú bene enu la chuꞌu enza ruꞌu puerta curaleꞌ sanchi sino que riuꞌu nzeꞌe enza rene neca nzeꞌe huanaꞌ nu rcachiꞌ nzeꞌe steneꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero bene enu riuꞌu enza ruꞌu curale nzeꞌe siꞌ neca bene enu rriꞌiucu bee sanchi. ");
INSERT INTO zplNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nu bene enu rriucu ruꞌu curaleꞌ beeí xaꞌla nzeꞌe ruꞌu curaleꞌ beeí para nú chuꞌu bene enu rriꞌiucu beeí nu chenu rixialla nú lee cada tucua beeí nuꞌlu beeí chilla. Nu rlualla beeí curale. ");
INSERT INTO zplNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nu chenu ulaxu nú uchiuꞌu ye bee sanchiꞌlla che nzucululla lubeeí nu nzenala beeí liꞌilla, xne nuꞌlu beeí chilla. ");
INSERT INTO zplNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero la chenala beeí bene rene, sino que riecaxuꞌu beeí lu nzeꞌe, xne la chulu beeí chii nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Chenu ulaxu nú uni Jesuse ejemplu cuaꞌ liꞌibeei né riꞌi beei beyaꞌ xi rni nú uninu. ");
INSERT INTO zplNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Chequie uniaꞌla Jesuse lubee bene zeꞌe: ―Neli nia luhua, liꞌá neca xi neca ruꞌu curaleꞌ bee sanchi elu riuꞌu beeí. ");
INSERT INTO zplNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ye bee bene enu rlutilá ubeꞌta luquelá liꞌá neca bee nzeꞌe xi neca huanaꞌ nu rcachiꞌ nzeꞌe steneꞌ bee bene pero bee enu neca bee benea né riꞌi caso beella bee nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Liꞌá neca xi neca puerta, nu bene enu chuꞌu ruꞌu puerta quieꞌ tsilaꞌa nzeꞌe, che nuꞌla modo nú chuꞌu nzeꞌe nu chiuꞌu nzeꞌe tucu nú rriꞌi bee sanchi, nú xelaꞌ beeí ixi acubeeí. ");
INSERT INTO zplNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Huanaꞌ nzeꞌtatsia para nú rcachiꞌ nu ruuti nu rnitilui bene, pero liꞌá nzela para nú liꞌihua luꞌcuhua elunehuañi, elunehuañi nú leca xunga laxu. ");
INSERT INTO zplNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Liꞌá neca tucu bene enu rriꞌiucu nzeꞌca bee sanchiꞌ, nu tucu bene enu rriꞌiucu nzeꞌca bee sanchiꞌ para liꞌilla lecaxi riꞌi mase hasta nú atilla equie cuendaꞌ bee sanchiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero enu riaxutsia rriucu beeí, chenu rlañiꞌ nzeꞌe nú nzeꞌta bichiu riecaxuꞌu nzeꞌe sanaꞌ arquiꞌ nzeꞌe beeí xne la neca nzeꞌe tucu bene enu rriꞌiucu nzeꞌca bee sanchi nu laca beeí sanchiꞌlla, che rucu bichiu beeí nu rtiꞌchialetse bichiu beeí. ");
INSERT INTO zplNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Bene cuaꞌ sanaꞌ arquiꞌlla beeí, xne riaxutsialla nequienulla beeí nu la riꞌilla caso beeí. ");
INSERT INTO zplNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Liꞌá neca bene enu rriꞌiucu nzeꞌca bee sanchiꞌ, scua tucu nú nuꞌlu Paa liꞌá leꞌca scua nuꞌlua liꞌinu, leꞌca scua nuꞌlua bee sanchia nu liꞌibeeí nuꞌlu beeí liꞌá. Nu lecaxi riꞌi mase hasta nú atia equie cuendaꞌ beeí. ");
INSERT INTO zplNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Leꞌca rluꞌcua stexcuaꞌa bee sanchi enu la chucheꞌ liñi curale quieꞌ, rquiꞌña nú nzetucuaꞌa beeí, nu zucuꞌbeeí nú rnia, para nú acatucunecatse beeí nu tucutsia enu riꞌiucu beeí. ");
INSERT INTO zplNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Pa Diose seca liꞌá xne rdete cuendaa liꞌá nú atia, para nú huañi zecaa stucu bese. ");
INSERT INTO zplNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lecati riꞌi ana nú uti liꞌá, tunu liꞌá la zela nú atia, liꞌá rluꞌcua poder nu zela nú atia, nu huañi zecaa stucu bese xne scua unibiyaꞌ Paa lua. ");
INSERT INTO zplNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chenu ubeneꞌ bee bene Israel bee bedichiaꞌ quieꞌ, stucuaꞌla urene urene unibeei. ");
INSERT INTO zplNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Huaxi beei uni: ―¿Xinu rriꞌi casohua nucuaꞌ nu benechiquiꞌ nuꞌ arquiꞌ nucuaꞌ nu ichia lucu seca nucuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero texcuaꞌa beei rni: ―Niꞌ tucu bene enu nuꞌ benechiquiꞌ arquiꞌ laca ni scua. ¿Xieꞌ aca tucu benechiquiꞌ riꞌi nú lañiꞌ bee bene enu niquieꞌ iꞌculu la? ");
INSERT INTO zplNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tiembu iqui, chenu rriꞌi bee bene Israel eliñi Indu llene Jerusalén, ");
INSERT INTO zplNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","se Jesuse enza liñi curdureꞌ indu zeꞌe elu lee curdureꞌ Salomón. ");
INSERT INTO zplNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Che uyabica bee bene Israel lunu nu unibeei lunu: ―¿Hasta xungaquie ixiuleꞌelu luru nú ti necalu? Neli uniꞌ luru tunu liꞌilu necalu Cristo. ");
INSERT INTO zplNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nu uni Jesuse lubeei: ―Unilá luhua nú ti necaa pero liꞌihua la chili arquiꞌhua Liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero liꞌihua la chili arquiꞌhua liꞌá, lunú la acahua bee benea. Tucu nú unilá luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Bee bene enu neca bee benea nuꞌlu bee nzeꞌe chia nu liꞌá nuꞌlua bee nzeꞌe nu nzeꞌtanala bee nzeꞌe liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Liꞌá rdetea elunehuañi nú leca xunga laxu lubeella, nu lecaꞌ xunga nitilu beella, leꞌca lecati axi beella yaa. ");
INSERT INTO zplNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Xne Pa Diose, liꞌinu uliquiꞌnu beella lua, liꞌinu másela rluꞌcunu poder lu yeene nu lecati axi beella yanu. ");
INSERT INTO zplNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Liꞌá nu Pa Diose tucutsia necaru. ");
INSERT INTO zplNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Che unaꞌtseaꞌla bee bene Israel quiee nzetuꞌbeei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Chequie uni Jesuse lubeei: ―Huaxi beenú neca nzeꞌca uriꞌá luhua equie poder nú rluꞌcu Pa Diose, ¿ta luye bee nucuaꞌ, duꞌhua quiee liꞌá? ");
INSERT INTO zplNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ucuaqui beei nú unibeei: ―La necane equie beenú neca nzeꞌca uriꞌilu, nú duꞌuru quiee liꞌilu. Duꞌuru quiee liꞌilu lunú la luꞌculu ulaꞌna lu Diose, xne rriꞌilu nú necalu Diose nu benetsialu. ");
INSERT INTO zplNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nu uni Jesuse lubeei: ―Xieꞌlanu lu leyꞌhua rni: “Liꞌá unia nú liꞌihua necahua bee diose.” ");
INSERT INTO zplNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nediyaꞌahua nú leca modo tsacuꞌ arquiaꞌahua lunú rni lu ichiꞌ Stichiaꞌ Diose. Nú liꞌinu ulualenu bee diose bee bene enu uyucu stichiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nee tunu Pa Diose utsulanu liꞌá para nú nzelaa lu iliulabe quieꞌ. ¿Xinu rnihua nú la luꞌcua ulaꞌna lunu, lunú unia nú necaa lliꞌñinu? ");
INSERT INTO zplNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tunu liꞌá la riꞌá tucu nú rni Pa Diose la chili arquiꞌhua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero tunu rriꞌá tucu nú rninu mase la chili arquiꞌhua liꞌá, pero uyalí arquiꞌhua lunú rriꞌá, para nú riꞌihua beyaꞌ nú liꞌá nzua cuna Pa Diose nu liꞌinu nzunu cuna liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hora zeꞌe stucuaꞌla bese uniarquiꞌ beei nú naꞌtse beei Jesuse, pero chu ulaꞌanu leta yaa beei nzanu. ");
INSERT INTO zplNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nu che nza zecanu stucu chú reꞌcu Jordán, luguare elu rluti urinza Juan bee bene, nu uyaꞌnanu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nu huaxi bee bene uya lunu, nu unibeei: ―Neli, nú né riꞌi Juan niꞌ tucu milagro. Pero ye lunú unilla equie cuendaꞌ bene quieꞌ, neli necane. ");
INSERT INTO zplNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nu huaxi bee bene uyalí arquiꞌ Jesucristo luhuare zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Uhuañi tucu bene enu ungariti lee Lázaro, liꞌilla cuna bee zanalla María nu Marta neca lachi beella Betania. ");
INSERT INTO zplNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nu María zana Lázaro, liꞌinchu necanchu enu uduꞌ perfume cuchiuꞌ Jesuse nu ucuiꞌchinchue cuna ichia equienchu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Che rucu bela beenchu uxeꞌla beenchu resuna lu Jesuse nu uni beenchu lunu: ―Detá, amigoꞌlu Lázaro riti. ");
INSERT INTO zplNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chenu ubeneꞌ Jesuse nucuaꞌ uninu: ―Elichia quieꞌ lanecatsiae para nú atilla sino que necane para nú equie cuendaꞌe acachee poderꞌ Diose nu para nú leꞌca acachee poder nú rluꞌcu lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Añinzuca nú chiquiꞌ seca Jesuse Marta cuna María nu Lázaro. ");
INSERT INTO zplNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Chenu ungabiyaꞌnu nú riti Lázaro uyaꞌnascaꞌlánu xiucu bichia luguare elu nzucunu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Udetetsia bee bichia zeꞌe uninu lubee beneꞌnu: ―Cha zecaꞌahua lu iliu Judea. ");
INSERT INTO zplNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Che uni bee beneꞌnu lunu: ―Maestro, lacaxeelá nú uniarquiꞌ bee bene Israel zeꞌe úti liꞌilu cuna quiee. ¿Nu nzaꞌlalu zeꞌe stucu bese la? ");
INSERT INTO zplNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nu uninu lubeella: ―Liꞌihua nediyaꞌhua nú chiꞌchiucu hora nuyaꞌ tucu bichia. Nu tunu bichia see bee bene la llica cuchiuꞌlla, xne rlañiꞌlla ellieꞌe nú nuꞌ lu iliulabe quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero tunu rulaꞌ see bene xica cuchiuꞌlla xne leca ellieꞌe yeꞌe lulla. ");
INSERT INTO zplNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Leꞌca uninu lubeella: ―Amigoꞌahua Lázaro raꞌtselalla. Pero nee nzecuaꞌñialla. ");
INSERT INTO zplNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nu uni bee beneꞌnu lunu: ―Detá, tunu raꞌtsella yecaꞌcalla che. ");
INSERT INTO zplNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero lunú uni Jesuse scua, rnii nú ungutila Lázaro, nu bee beneꞌnu ulleꞌca nú liꞌinu rninu nú raꞌtsetsialla. ");
INSERT INTO zplNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chequie udixiuleꞌe itá Jesuse lubeella nú uninu: ―Unguti Lázaro. ");
INSERT INTO zplNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nu ñia nzu arquia nú lecá zeꞌe, xne scua máse neca nzeꞌcae lu cuendaꞌhua para nú chili arquiꞌhua liꞌá. Nee chahua chebiꞌyaꞌahualla. ");
INSERT INTO zplNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Chequie Tomás enu riꞌchia bee bene “cuachi”, unilla lubeelá bee beneꞌ Jesuse: ―Uchahua cuna liꞌinu para nú atiaꞌahua cuna liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Che uriña Jesuse Betania, nu ungala tacu bichia nú uhuachiꞌ Lázaro. ");
INSERT INTO zplNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania axu riaꞌna Jerusalén, tucu chuna kilometro. ");
INSERT INTO zplNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nu huaxi bee bene Israel uya biꞌya Marta cuna María, para nú tsala beella arquiꞌ beenchu equie nú unguti zana beenchu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Chenu ungabiyaꞌ Marta nú axula nzeꞌta riña Jesuse che uyachaꞌcalunchu liꞌinu, pero María uyaꞌna niꞌbeenchu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Chequie uni Marta lu Jesuse: ―Detá, tunu nzulu caꞌa né ati zanaa. ");
INSERT INTO zplNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero liꞌá nediyaa nú Diose liquiꞌ ye nú nacuꞌlu lunu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nu uni Jesuse lunchu: ―Liꞌá rniaa nú huañi zeca zanalu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Chequie uni Marta lunu: ―Neliꞌlu nucuaꞌ, nediyaa nú huañi zecai chenu huañi zeca bee bene nguti, bichia nú laxu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nu uni Jesuse lunchu: ―Liꞌá neca enu rriꞌi nú rehuañi zeca bee bene nguti nu rdetea elunehuañiꞌ bee bene. Nu enu chili arquiꞌ liꞌá mase nú atilla huañi zecalla. ");
INSERT INTO zplNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nu ye bee bene enu nehuañiscaꞌ nu nzeli arquiꞌ liꞌá lecaꞌ xunga ati bee nzeꞌe. ¿Nzelí arquiꞌlu nú rnia la? ");
INSERT INTO zplNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nu uninchu lunu: ―Nzelí arquia nú rnilu Detá, liꞌá nzeli arquia nú liꞌilu necalu Cristo Lliꞌñi Diose, enu nzu nú riña lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chenu ulaxu nú uni Marta scua lunu, chu uyatixianchu belanchu María, nu uni aꞌchiꞌnchu lunchu: ―Uriñala Maestro nu rixianu liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chenu ubeneꞌ María nucuaꞌ, utsulíxuꞌunchu nzanchu lu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nu lascaꞌ chuꞌu Jesuse eyeche Betania zeꞌe, nu nzuscaꞌnu luhuare elu uyachaꞌcalu Marta liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Che bee bene Israel enu nucuaꞌa niꞌi beenchu saala arquiꞌ beenchu, chenu ulañiꞌ beella nú yexetsia nza María che nzenala beella liꞌinchu nu rni beella. Nzanchu nze unaꞌnchu ruꞌu eluhuaꞌ Lázaro. ");
INSERT INTO zplNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Chenu uriña María elu nzu Jesuse, utsu lliquinchu lunu nú uninchu: ―Detá, tunu nzulu caꞌa né ati zanaa. ");
INSERT INTO zplNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Chenu riꞌyanu nú runaꞌ María nu leꞌca runaꞌ bee bene Israel enu nuunchu, che nehuana utsiꞌnu, nu chiquiꞌ nehuana utsu arquiꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nu unidichiaꞌnu lubeella: ―¿Cá ucachiꞌhualla? Che unibeella: ―Utecuru ne lañiꞌlu Detá, ");
INSERT INTO zplNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chequie ungunaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Che uni bee bene Israel zeꞌe: ―¡Biꞌyacuruhua chiquiꞌ ulleꞌcanu liꞌilla! ");
INSERT INTO zplNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero nuꞌ beei enu uni: ―Benequieꞌ neca enu uriyeca iꞌculu bene enu unga niquieꞌ iꞌculu zeꞌe, ¿xieꞌ lá acaquiella ariꞌilla xi ariꞌilla para nú lá ati Lázaro la? ");
INSERT INTO zplNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Chequie stucuaꞌla bese nehuana utsu arquiꞌ Jesuse chenu uya bicanu ruꞌu eluhua zeꞌe. Necane tucu yubeꞌ, nu nacuꞌ tucu quiee ruꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nu uni Jesuse: ―Uyucuhua quiee cuaꞌ. Che Marta zana tuxie uni lunu: ―Detá, nechala rlialla xne necala tacu bichia nú ungutilla. ");
INSERT INTO zplNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nu uni Jesuse lunchu: ―¿Xieꞌ lanu unilá lulu nú tunu chili arquiꞌlu, lañiꞌlu poderꞌ Diose la? ");
INSERT INTO zplNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Che uyucu beella quiee nú nacuꞌ ruꞌu eluhua zeꞌe, nu ubiꞌya Jesuse enza liñibe nu rninu: ―Pa Diose, cheꞌtsalu xne uriꞌi casolu nú unia lulu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Liꞌá nediyaa nú siempre rriꞌilu caso lunú rnia pero rnine lu cuendaꞌ bee bene quieꞌ, enu nucuaꞌa caꞌa, para nú chili arquiꞌbeella nú liꞌilu uxeꞌlalu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chenu ulaxu nú uninu scua che juerte uninu: ―¡Lázaro, uchiuꞌu liñi cuaꞌ! ");
INSERT INTO zplNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chequie uchiuꞌu Lázaro liñi eluhua zeꞌe, nu nebelascaꞌ venda yalla cuna cuchiuꞌlla. Nu leꞌca nacuꞌ tepedaso laquie lulla, che uni Jesuse lubeella: ―Uxeꞌchehualla nu uzelahua yaalla. ");
INSERT INTO zplNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Chequie huaxi bee bene Israel enu uyanuu María uyalí arquiꞌbeei Jesuse chenu ulañiꞌ beei milagro nú uriꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero nuꞌbeei enu uyatixiuleꞌe lubee fariseo lunú uriꞌi Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Che bee fariseo quieꞌ cuna bee uleꞌya enu rnibiyaꞌ uquieteꞌ saꞌbeella cuna beelá bee usticia nu uni beella: ―¿Xneca riaꞌahua? Xne bene quieꞌ rriꞌi huaxi bee milagro. ");
INSERT INTO zplNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu tunu zelaꞌahua nú nzeriꞌilá benequieꞌ scua, ye bee bene chili arquiꞌ liꞌilla, che bee usticia Roma yeꞌta nitilu induꞌahua nu cuna naciónꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero tucu beella enu lee Caifás enu neca uleꞌya enu rnibiyaꞌ lu ye bee uleꞌya lana zeꞌe uni: ―Liꞌihua la biyaꞌhua, ");
INSERT INTO zplNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nu la riꞌihua beyaꞌ nú másela neca nzeꞌca nú ati tucutsia bene equie cuendaꞌ ye bee bene, luquela nú nitilu diqui naciónꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero né ni Caifás nucuaꞌ lu cuendaꞌtsialla. Diose udeteꞌ bee bedichiaꞌ cuaꞌ lulla, xne necalla uleꞌya enu rnibiyaꞌ lu ye bee uleꞌya lana zeꞌe, enzeꞌe unilla nú enta nú ati Jesuse equie cuendaꞌ bee bene Israel; ");
INSERT INTO zplNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","nu la necane nú equie cuendaꞌtsia beella atinu, sino que leꞌca necane para nú acatucunecatse beella cuna bee beneꞌ Diose enu nucuaꞌa diqui lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Enzeꞌe desde bichia zeꞌe bee usticiaꞌ bee bene Israel unga tucunecatse beella nú útibeella Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Enzeꞌe lá lubeꞌluaꞌ Jesuse lubee bene Israel. Sino que uchiuꞌunu lu iliu Judea nu nzanu tucu eyeche nú lee Efraín axu lu tucu dañi achi, nu zeꞌe uyaꞌnanu cuna bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Chenu nzeꞌta riñala eliñi baxcu nú rriꞌi bee bene Israel. Huaxi bee bene bee eyeche enza zeꞌe nzuebeella Jerusalén para nú riꞌibeella lunú neca costumbreꞌ beella para nú lecaxi naa beella lu Diose ante nú riña eliñi zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Che rlaꞌna beei Jesuse nu rnedichiaꞌ beei lu saꞌbeei liñi Indu llene Jerusalén, nú unibeei: ―¿Xa nihua? ¿Nzeꞌtalla lu eliñi la o la yeꞌtalla la? ");
INSERT INTO zplNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nu bee uleꞌya enu rnibiyaꞌ cuna bee fariseo unibiyaꞌla beella, nú tunu titse bee bene acabiyaꞌ cá nzunu ixiuleꞌe beei para nú llunanu. ");
INSERT INTO zplNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sexuꞌcu bichia rriꞌi para nú aca eliñi baxcu, chenu uya Jesuse Betania, elu neca lachi Lázaro enu uriꞌinu nú uhuañi zeca lu eluti. ");
INSERT INTO zplNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Zeꞌe urecheꞌ beella tucu exee para Jesuse, Marta neca enu udeteꞌ elubacu lubeella nu Lázaro neca tucu enu nzucununu lu mexa. ");
INSERT INTO zplNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hora zeꞌe uriñayu María tucu arulaꞌ litro perfume nú huaxi seca xne necacheꞌe puro nardo nu uduꞌnchue equie cuchiu Jesuse, nu chu ucuiꞌchinchue cuna ichia equienchu. Nu diqui liñi niꞌi zeꞌe ñia ulia uriꞌi perfume cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Che uni Judas Iscariote enu neca llianaꞌ Simón enu neca tucu lu chiꞌchiucu bee beneꞌ Jesuse enu udeteꞌ cuenda liꞌinu, uni: ");
INSERT INTO zplNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Xinu lá autinchu perfume quieꞌ chuna ayuꞌu dimi denario para nú aca elietsa lubee bene enu seca elitsi? ");
INSERT INTO zplNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero né ni Judas scua lunú nzenu arquiꞌi lu cuendaꞌ bee bene enu seca elitsi, uniitsiai scua xne nehuanaꞌi nu como liꞌi nuyaꞌ cuendai biti nú nuꞌcheꞌ dimi, che rcachiꞌi bee dimi nú rdeteꞌ beella yai ducheꞌi. ");
INSERT INTO zplNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Chequie uni Jesuse lui: ―La riꞌchialunchu, xne liꞌinchu uduꞌxulanchu perfume quieꞌ liꞌá para bichia chenu achiꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Xne bee bene elitsi ye bichia nucuaꞌa cuna liꞌihua, pero liꞌá la ye tiembu nzua cuna liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Huaxi bee bene Israel ungabiyaꞌ nú nzucu Jesuse eyeche Betania, uya beei zeꞌe. La necatsiae para nú lañiꞌbeei Jesuse sino que leꞌca para nú lañiꞌ beei Lázaro enu uriꞌinu nú uhuañi lu eluti. ");
INSERT INTO zplNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Enzeꞌe bee uleꞌya enu rnibiyaꞌ unga tucunecatse beella para nú úti beella Jesuse nu leꞌca nuu Lázaro uniarquiꞌ beella úti beella. ");
INSERT INTO zplNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Xne equie cuendaꞌlla huaxi bee bene Israel xiuꞌu leta beella, nu nzeli arquiꞌ beella Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chenu uyeꞌe lu yuu stucu bichia, huaxi bee bene bee enu uriña Jerusalén lu eliñi baxcu ungabiyaꞌ beella nú riña Jesuse zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Che uchiecuꞌ beei iña nu uya chaꞌcalu beei liꞌinu, nu urixialibeei nú unibeei: ―¡Diose nzu cuna liaꞌahua! ¡Ñia neca lu cuendaꞌ liꞌinu enu nzeꞌta lu cuendaꞌ Diose, enu neca Arre Israel! ");
INSERT INTO zplNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesuse ullelaꞌ tucu burro eꞌneꞌ nu uricunuí, tucu nú rni lu ichiꞌ Stichiaꞌ Diose elu rni: ");
INSERT INTO zplNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Bee bene Sión la lliquihua, biꞌyacuruhua nzeꞌtaquiela Arreꞌhua, nchiucuꞌ equie tucu burro eꞌneꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hora zeꞌe lá riꞌi bee beneꞌnu beyaꞌ lunú reca, pero chenu uquienu liñibe che uriꞌibeella beyaꞌ nú scua niquie lu ichiꞌ Stichiaꞌ Diose equie cuendaꞌnu, enzeꞌe unga scua. ");
INSERT INTO zplNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bee bene enu nucuaꞌa cuna Jesuse chenu ubixianu Lázaro nú uchiuꞌui liñi eluhua, nu uriꞌinu nú uhuañi lu eluti, bee bene cuaꞌ udixiuleꞌe lubee bene lunú ulañiꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Enzeꞌe uchiuꞌu huaxi bee bene uyachaꞌcalu Jesuse, xne ungabiyaꞌ beei bee milagro nú uriꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Chequie uni bee fariseo lu saꞌbeei ulañiꞌhuanee nú leca xa modo riaꞌahua: ―Biꞌyacuruhua tescualaꞌ huaxi bee bene nzenala liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bee bene enu uriña Jerusalén lu eliñi para nú luꞌcu ulaꞌna lu Diose, leta beei nucuaꞌa chiucu chuna bee bene griego. ");
INSERT INTO zplNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Liꞌibeei uyabica beei lu Felipe, enu neca bene eyeche Betsaida, tucu eyeche lu iliu Galilea, nu uzequiee beei lulla nú unibeei: ―Detá, niarquiꞌru bedichiaꞌnuru Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Che uyatixiuleꞌe Felipe nucuaꞌ lu Andrés nu che rucu beella uyatixiuleꞌe beella nucuaꞌ lu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chequie uni Jesuse lubeella: ―Uriñala hora nú liꞌá Bene enu uxeꞌla Diose, zucuꞌ aya bee bene liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Xne liꞌá nia luhua nú tucu nú neca tucu ebichi trigo nú tunu la benii, necascaꞌ tucutsiae, pero tunu benii che chiquiꞌ ayune. ");
INSERT INTO zplNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Xne bene enu máse niarquiꞌ huañi lu iliulabe quieꞌ, enta bichia nú laxu nucuaꞌ, pero bene enu nzenu arquiꞌ nú riꞌi lunú niarquiꞌ Diose mase ulleꞌcalla lunú ulleꞌcalla luꞌculla elunehuañi nú leca xunga laxu ante lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tunu nuꞌ bene enu niarquiꞌ nú zibiꞌ lua, yeꞌtaquie nzeꞌe liꞌá, nu elu nzaꞌa leꞌca zeꞌe nza nzeꞌe. Nu bene enu zibiꞌ lua, zucuꞌ aya Pa Diose nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’¡Chiquiꞌ nehuana nzu arquia nee hora quieꞌ! ¿Nu xi nia? ¿Nia “Pa Diose, utsilaꞌa liꞌá lunú chiquiꞌ nehuana seꞌca”? ¡La nia scua xne para nucuaꞌ nzela! ");
INSERT INTO zplNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Enzeꞌe rnia, Pa Diose ulubeꞌ poderꞌlu lubeei. Che uyene tucu chii enza liñibe, nú rni: ―Ulubela poder nú rluꞌcua lubee bene pero lubezecane stucu bese lubeei. ");
INSERT INTO zplNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chequie chenu ubeneꞌ bee bene enu nucuaꞌa zeꞌe chii cuaꞌ, uni beella nú biziyuꞌ neca enu uni, pero nuꞌ beella enu uni: ―Tucu ángel neca enu ni lunu. ");
INSERT INTO zplNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Che uni Jesuse lubeei: ―Lá yene chiquieꞌ lu cuendaꞌ liꞌá sino que necane para liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nee uriñala hora nú aca elu usticia lu iliulabequieꞌ nu nee la nibiyaꞌ bezeꞌlu tucu nú rnibiyaꞌi lu iliulabequieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pero chenu uquieelá lu cruse, che riꞌá nú yelu bee bene chili arquiꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Scua udixiuleꞌenu xa modo atinu. ");
INSERT INTO zplNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Che ucuaqui bee bene lunu: ―Liꞌiru nediyaꞌru nú lu ley rni, nú leca xunga ati Cristo. ¿Xinu rnilu nú Bene enu uxeꞌla Diose rquiꞌña nú quiee lu cruse? ¿Ti neca Bene enu uxeꞌla Diose che? ");
INSERT INTO zplNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chequie uni Jesuse lubeei: ―Lacaxeaꞌ nzulá ellieꞌe quieꞌ cuna liꞌihua, enzeꞌe uyaquiehuane diquila nú nzue cuna liꞌihua para nú la riꞌi nú necabe ana luhua xne bene enu nzenala nú necabe la riꞌi nzeꞌe beyaꞌ cá nza nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Enzeꞌe diquila nú nzu ellieꞌe quieꞌ cuna liꞌihua uchili arquiꞌhuane para nú acahua bee benea. Chenu ulaxu nú uni Jesuse bee bedichiaꞌquieꞌ chu nzanu nu né lañiaꞌ beei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pero añinzuca nú uriꞌi Jesuse huaxi bee milagro lubeei, né chili arquiꞌbeei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nu scua uyalu nú uni profeta Isaías chenu unilla: Pa Diose, lecati nzeli arquiꞌ beenú rniru equie cuendaꞌlu. Lecati rriꞌi beyaꞌ nú equie poderꞌlu huaxi beenú unga. ");
INSERT INTO zplNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Enzeꞌe né chili arquiꞌbeei liꞌinu. Nu leꞌca uquieꞌe profeta Isaías: ");
INSERT INTO zplNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diose uriꞌi nú neca xi neca nú la lañiꞌbeei, nu uriꞌinu nú unga nziti arquiꞌbeei, para nú la lañiꞌbeei, nu la riꞌibeei beyaꞌ, para nú la benchilaꞌbeei lua, para nú riꞌá perdona stula beei. ");
INSERT INTO zplNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Uni Isaías scua xne ulañiꞌlaꞌlla poder nú rluꞌcu Jesuse hasta huaꞌtu, enzeꞌe unilla scua equie cuendaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero huaxi bee bene Israel uchili arquiꞌ Jesuse, nu hasta chiucu chuna bee bene enu rnibiyaꞌ uchili arquiꞌ liꞌinu. Pero lá tsiruꞌu beei nucuaꞌ lubee bene xne xiqui beei nú cánu la zelaꞌ bee fariseo nú chuꞌulá beei liñi indu. ");
INSERT INTO zplNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Xne másela uyuꞌu arquiꞌbeei nú zucuꞌ ayaa bee bene liꞌibeei, luhuare nú yaꞌna nzeꞌca beei lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nu juerte uni Jesuse: ―Bene enu nzeli arquiꞌ liꞌá, la nzeli arquiꞌ nzeꞌe liꞌitsia, leꞌca nzeli arquiꞌ nzeꞌe Pa Diose enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nu enu rlañiꞌ liꞌá, leꞌca rlañiꞌlaꞌ nzeꞌe Pa Diose enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Liꞌá enu neca ellieꞌe, uriña lu iliulabe para nú bee bene enu nzeli arquiꞌ liꞌá, la chenalaꞌ beei inziu nú necha neca. ");
INSERT INTO zplNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Enu rieneꞌ stichiaꞌa nu la riꞌi casoe, liꞌá la necaa enu deteꞌ castiya nzeꞌe, xne lá yela lu iliulabe para nú detea castiya bee bene, sino que uriña para nú tsilaꞌa bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bene enu rluachu liꞌá, nu la riꞌi caso stichiaꞌa nzula enu deteꞌ castiya nzeꞌe, bee bedichiaꞌ nú unila deteꞌ castiya nzeꞌe bichia chenu hualu Diose lu cuendaꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Xne bee bedichiaꞌ nú rnia la necane stichiaꞌtsia, sino que Pa Diose enu uxeꞌla liꞌá, liꞌinu unibiyaꞌnu lua nú xi nia nu xi zetea bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nu nediyaa nú stichiaꞌ Pa Diose necane para nú luꞌcu bee bene elunehuañi nú leca xunga laxu lu Diose. Enzeꞌe rnia tucu nú unibiyaꞌnu lua nú nia. ");
INSERT INTO zplNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ante eliñi baxcu, nediyaꞌlaꞌ Jesuse nú entariñala hora nú tsaꞌnanu iliulabequieꞌ para nú nzianu zucunu cuna paꞌnu Diose. Liꞌinu chiquiꞌ uzecanu bee beneꞌnu lu iliulabe quieꞌ nu secascaꞌnu liꞌibeella hasta nee. ");
INSERT INTO zplNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nu chenu racuxee beella, uyuꞌu bezeꞌlu arquiꞌ Judas Iscariote llianaꞌ Simón Iscariote para nú deteꞌ cuendai Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pero nediyaꞌlaꞌnu nú Paꞌnu Diose utsaꞌnala yeene yanu, nu leꞌca nediyaꞌlaꞌnu nú enza lu Paꞌnu Diose nzeꞌtanu nu enza lu Paꞌnu Diose benchilaꞌ zecanu. ");
INSERT INTO zplNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Diquila nú racuxee beella utsulínu nu uluanu laquie nú nutunu lu xucunu nu ullicaꞌnu tucu tualla xlaꞌcunu. ");
INSERT INTO zplNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Che chu uduꞌnu inza liñi tucu exquiꞌña, nu uquixienu rquienu cuchiuꞌ bee beneꞌnu, nu rcuiꞌchinue cuna tualla nú nacaꞌcu xlaꞌcunu. ");
INSERT INTO zplNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chenu nze quienu cuchiuꞌ Simón Pedro, unilla lunu: ―Detá, la yala nú quielu cuchiuꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nu ucuaqui Jesuse lulla: ―Nee la riꞌilu beyaꞌ lunú rriꞌá, pero enta chenu riꞌilu beyaꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Chequie uni Pedro lunu: ―¡La zelaa nú quielu cuchiuꞌa! Nu uninu lulla: ―Tunu la quiea cuchiuꞌlu la acaꞌlu benea che. ");
INSERT INTO zplNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nu ucuaqui Simón Pedro lunu: ―Aa che, Detá, pero la quieelu cuchiuꞌtsia, leꞌca uquiee ya nu uꞌchaꞌ liꞌá che. ");
INSERT INTO zplNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero ucuaqui Jesuse lulla: ―Enu ungutsala, cuchiuꞌtsia nzeꞌe rquiꞌña nú chequielá, xne lecaꞌ xi naa diquilla. Nu liꞌihua lecaꞌ xi naahua, añinzuca nú laca yehua. ");
INSERT INTO zplNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Liꞌinu uninu: “Añinzuca nú laca yehua”, xne nediyaꞌnu nú ta enu deteꞌ cuenda liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chenu ulaxu nú uquieenu cuchiuꞌ bee beneꞌnu, che ungutu zecanu laquie nú uluanu lu xucunu, nu chu uzucu zecanu lu mexa nu uninu lubeella: ―¿Rriꞌihua beyaꞌ lunú uriꞌá luhua la? ");
INSERT INTO zplNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Liꞌihua rnihua Maestro nu Detá lua, nu neliꞌhua xne scua necane. ");
INSERT INTO zplNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nee liꞌá nú neca ulaxcuela nu Detá uquia cuchiuꞌhua, leꞌca scua rquiꞌña nú quiehua cuchiuꞌ bee saꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ulubela luhua xa riꞌihua para nú leꞌca scua tucu nú uriꞌá riꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Liꞌihua nediyaꞌhua nú niꞌtucu mosoꞌ la neca equielái lu patronꞌi, leꞌca bene enu nza luhuareꞌ stucu bene la neca equielái lu bene enu xeꞌla liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ñia nza lu cuendaꞌhua tunu rriꞌihua beyaꞌ bee nucuaꞌ nu zucuꞌhuane. ");
INSERT INTO zplNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’La nia lu cuendaꞌ yehua, liꞌá nediya tahua bee enu ucañia. pero rquiꞌña nú yalu tucu nú rni lu ichiꞌ Stichiaꞌ Diose elu rni: “Liꞌi eꞌcu enu racunua, ubelleta equiea.” ");
INSERT INTO zplNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nia nucuaꞌ luhua ante nú acane para nú chenu acane, chili arquiꞌhua nú liꞌá necaa enu necaa. ");
INSERT INTO zplNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Neli nia luhua: Nú bene enu riꞌi caso bene enu xeꞌlaa, rriꞌi caso nzeꞌe liꞌá, nu enu rriꞌi caso liꞌá, liꞌilla rriꞌi casolla enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chenu ulaxu nú uni Jesuse scua, chiquiꞌ nehuana utsu arquiꞌnu, che udixiuleꞌe nzeꞌcanu lubeella nú uninu: ―Neli nia luhua nú tucuhua deteꞌ cuenda liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chequie uquixie ubiꞌya bee beneꞌnu lu saꞌbeella, nu la riꞌi beella beyaꞌ tabeella neca enu uninu lu cuendaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nu tucu beneꞌ Jesuse enu chiquiꞌ secanu enu nzucu cueꞌtsenu diqui nú racuxe beella, ");
INSERT INTO zplNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","uriꞌi Simón Pedro seña lulla para nú nedichiaꞌlla lunu, núti lu cuendaꞌ rninu. ");
INSERT INTO zplNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Che beneꞌnu enu nzucu cueꞌtsenu unedichiaꞌlla lunu: ―Detá, ¿Taru enu deteꞌ cuenda liꞌilu? ");
INSERT INTO zplNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nu ucuaqui Jesuse, nu uninu: ―Cuachaa teleꞌe pá nu ya enu detene nzeꞌella. Che ucuachanu teleꞌe pá udeteꞌnu ya Judas Iscariote, llianaꞌ Simón Iscariote. ");
INSERT INTO zplNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hora nú unaꞌtse Judas pá zeꞌe chu uyuꞌu bezeꞌlu arquii, nu uni Jesuse lui: ―Lunú niarquiꞌlu riꞌilu, yexetsia uriꞌi. ");
INSERT INTO zplNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nu niꞌ tucu beella enu nzucununu lu mexa zeꞌe né riꞌibeella beyaꞌ xinu uninu lui scua. ");
INSERT INTO zplNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nu lunú Judas nuyaꞌ cuenda biti nú nuꞌcheꞌ melu, che nuꞌ beella enu uriꞌi elliebacuꞌ, nú uni Jesuse lui nú chetsii xi chetsii para eliñi, urre deteꞌi xi deteꞌi lubee bene enu seca. elitsi. ");
INSERT INTO zplNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Chenu ulaxu udacu Judas pa zeꞌe chu uchiuꞌui nzai nu uyuꞌula rulaꞌ che. ");
INSERT INTO zplNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Chenu uchiuꞌu Judas uni Jesuse: ―Nee aca achee poder nú rluꞌcu Bene enu uxeꞌla Diose lu iliulabe, nu equie cuendaꞌ liꞌinu aca achee poder nú rluꞌcu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nu scua tucu nú lubeꞌ Bene enu uxeꞌla Diose, xa neca poder nú rluꞌcu Diose, leꞌca scua lubeꞌ Diose poder nú rluꞌcu bene enu uxeꞌlanu, nu la leaꞌ nú acane scua. ");
INSERT INTO zplNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bee lliꞌñia, lleꞌnatsia nzula cuna liꞌihua. Laꞌnahua liꞌá pero tucu nú unila lubee bene Israel, leꞌca scua nia luhua nee. Leca modo tsehua elu nzaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nee liquia tucu mandamiento cuqui luhua: Uzecahua bee saꞌhua. Tucu nú seꞌca liꞌihua, leꞌca scua uzecahua bee saꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tunu secahua bee saꞌhua, scua riꞌi ye bee bene beyaꞌ nú liꞌihua necahua bee benea. ");
INSERT INTO zplNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nu uni Simón Pedro lu Jesuse: ―Detá, ¿ca nzalu? Nu uni Jesuse: ―Elu nzaꞌa leca modo tselu nee, pero enta bichia nú yeꞌtanalalu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Che uni Pedro lunu: ―Detá, ¿xiquie nú leca modo tsea cuna liꞌilu nee? ¡Nu liꞌá lecaxi riꞌi mase nú atia lu cuendaꞌlu! ");
INSERT INTO zplNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nu ucuaqui Jesuse nú uninu: ―¿Neliꞌlu nú atilu lu cuenda la? Liꞌá nia lulu nú ante nú bixia tiula, liꞌilu chunala bese unilálu nú la chululu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Chequie uni Jesuse lubeella: ―La chenu arquiꞌhua, uchili arquiꞌhua Diose, nu uchili arquiꞌhua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Elu nzucu Pa Diose chiquiꞌ nuꞌ luguare elu cuaꞌa bee bene nuꞌ, xne tunu leca luhuare liꞌá lá ania luhua nú nze tsucheꞌa elu cuaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nu chenu uyatsucheꞌla elu cuaꞌahua, che nzela stucu bese para nú nzela tucuaꞌahua para nú cuaꞌahua elu zucuaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Liꞌihua nediyaꞌhua cá nzaꞌa nu nuꞌluhua inziu para nú riñahua zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chequie uni Tomás lunu: ―Detá, la biyaꞌru cá nzalu, ¿xa chuluru inziu nú rnilu? ");
INSERT INTO zplNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Che ucuaqui Jesuse, nú uninu: ―Liꞌá neca inziu zeꞌe, nu nú neli neca, nu elu nehuañi. Equie cuendaꞌ liꞌitsia nuꞌ modo riña bee bene lu Pa Diose liñibe. ");
INSERT INTO zplNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tunu liꞌihua nuꞌluhua liꞌá leꞌca nuꞌluhua Pa Diose nu nee nuꞌlulahuanu, xne ulañiꞌlaꞌhuanu. ");
INSERT INTO zplNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Che uni Felipe lunu: ―Detá, uzela lañiꞌru Pa Diose para nú yaꞌna conformero. ");
INSERT INTO zplNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Chequie uni Jesuse lulla: ―Felipe, xeela nzua cuna liꞌihua, ¿Nu lascaꞌ chululu liꞌá la? Enu ulañiꞌlaꞌ liꞌá, leꞌca ulañiꞌlaꞌ nzeꞌe Pa Diose, ¿xiquie nú rnilu lua nú zelaa lañiꞌhua Pa Diose? ");
INSERT INTO zplNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Xieꞌ la chili arquiꞌlu nú tucutsia neca cuna Pa Diose nu liꞌinu tucutsia necanu cuna liꞌá la? Bee bedichiaꞌ nú rnia la necane elliebacutsia sino que Pa Diose, enu nzunu liꞌá, liꞌinu necanu enu rriꞌi lunú rriꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uchili arquiꞌhua nú liꞌá nzunua Pa Diose, nu liꞌinu nzununu liꞌá, tunu la chili arquiꞌhua, uchili arquiꞌhua liꞌá equie beenú rriꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Liꞌá nia luhua nú enu nzeli arquiꞌ liꞌá, leꞌca riꞌi nzeꞌe beenú rriꞌá, nu riꞌi nzeꞌe beenú llenescaꞌlá neca, lunú nziaꞌla elu nzucu Pa Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nu ye nú nacuꞌhua lu Diose equie cuendaa liꞌá liquine. Para nú equie cuendaꞌ lliꞌñinu acachee poder nú rluꞌcu Pa Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Xitse nú nacuꞌhua lu Diose equie cuendaa, liꞌá liquine. ");
INSERT INTO zplNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tunu liꞌihua secahua liꞌá, zuꞌcuhua stichiaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nu liꞌá nacua lu Pa Diose para nú xeꞌlanu stucu enu duꞌ ana arquiꞌhua nu yaꞌnalínu cuna liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Liꞌinu necanu Espíritu Santo enu rni nú neli neca, bee bene enu laca bee benea leca modo yucu arquiꞌbeei liꞌinu. Xne la lañiꞌ beei liꞌinu nu la chulu beei liꞌinu. Pero liꞌihua nuꞌluhuanu xne nzunu cuna liꞌihua nu yaꞌnalínu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","La tsaꞌna zaquia liꞌihua, nzela zeca luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Lacaxeaꞌ la lañiaꞌ bee bene enu laca bee benea liꞌá, pero liꞌihua lañiꞌhua liꞌá. Nu tucunú rluꞌcua elunehuañi, leꞌca scua luꞌcuhua elunehuañi. ");
INSERT INTO zplNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Bichia nú yucuhua Espíritu Santo riꞌihua beyaꞌ nú tucutsia necaa cuna Pa Diose, nu tucutsia necahua cuna liꞌá, nu tucutsia necaa cuna liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Enu rduꞌ equie stichiaꞌa nu sucuꞌe, nzeꞌe rlubeꞌ nú neli seca liꞌá. Nu enu seca liꞌá zeca Pa Diose nzeꞌe, nu leꞌca zecaa nzeꞌe, nu lubea lu nzeꞌe nú ti necaa. ");
INSERT INTO zplNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chequie Judas (enu laca Judas Iscariote) uni lunu: ―Detá, ¿xiquie nú lutsiaru lubeꞌlu nú ti necalu? Nu la lubeꞌlu nú ti necalu lu beelá bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Che ucuaqui Jesuse nú uninu: ―Enu seca liꞌá sucuꞌ stichiaꞌa, nu Paa Diose seca nzeꞌe, nu Paa nu liꞌá nzelaru para nú huañiru cuna nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Enu la zeca liꞌá, la zucuꞌ nzeꞌe stichiaꞌa nu bee bedichiaꞌ nú rieneꞌhua rnia lacane stichiaꞌa, stichiaꞌ Paa Diose enu uxeꞌla liꞌá necane. ");
INSERT INTO zplNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Rnia ye bee nucuaꞌ luhua diquila nú nzuscaꞌa cuna liꞌihua; ");
INSERT INTO zplNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","pero Espíritu Santo enu xeꞌla Paa Diose equie cuendaa, liꞌinu duꞌnu ana arquiꞌhua nu zeteꞌnu liꞌihua yeene, nu elluꞌcu arquiꞌnu liꞌihua ye beenú unila luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Chenu nziaꞌla liquia nú nzuxe arquiꞌhua, nu liꞌá la nitsiane tucu nú rni bee bene iliulabe xne liꞌá neli liquine luhua. La chenu arquiꞌhua nu la lliquihua. ");
INSERT INTO zplNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","’Ubeneꞌlaꞌhua nú unia nú nziaꞌa pero benchilaꞌ zecaa luhua. Tunu neli nú secahua liꞌá, ñia atsu arquiꞌhua chenu unia nú nziaꞌa lu Pa Diose, xne liꞌinu rnibiyaꞌnu lua. ");
INSERT INTO zplNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Rixiuleꞌexula nucuaꞌ luhua nee para nú chenu acane chili arquiꞌhua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’La niaꞌa huaxilá bee bedichiaꞌ luhua, xne nzeꞌtala enu rnibiyaꞌ lu iliulabe quieꞌ. Añinzuca nú la nibiyaꞌ nzeꞌe lua, ");
INSERT INTO zplNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","pero rquiꞌña nú acane scua tucu nú rquiꞌña nú acane, para nú riꞌi bee bene iliulabe beyaꞌ nú liꞌá seꞌca Pa Diose, nu rriꞌá lunú unibiyaꞌnu riꞌá. Utsulihua ne chaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Leꞌca uni Jesuse lubeella: ―Liꞌá neca xi neca luchi lubeꞌ nu Pa Diose neca xi neca enu rquienii. ");
INSERT INTO zplNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nu bee bene enu neca xi neca bee luchi yae. Bee luchi yae nú la ayu uva, chiecuꞌnue, pero beenú rayu uva, chiꞌqui yae nú la zibiꞌ para nú lecaxi nae nu che ayulae. ");
INSERT INTO zplNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Liꞌihua lecaꞌ xi nahua equie nú nzeli arquiꞌhua bee bedichiaꞌ nú unilá luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Aca tucutsiahua cuna liꞌá, tucu nú tucutsia necaa cuna liꞌihua, xne tucu luchi lubeꞌ leca modo ayu uva lue tunu la nzenene cuna luchi uzana leꞌca scua liꞌihua leca modo riꞌihua lunú riuꞌ arquiꞌ Diose tunu la neca tucutsiahua cuna liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Liꞌá neca xi neca luchi lubeꞌ uzana nu liꞌihua necahua xi neca luchi yae. Bene enu la tsanaꞌ arquiꞌ nú neca tucunecatse cuna liꞌá, nu liꞌá necatucunecatsea cuna nzeꞌe, nzeꞌe máse rriꞌi lunú riuꞌ arquiꞌ Pa Diose, xne tunu la neca tucunecatsehua cuna liꞌá lecaxi acahua riꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bene enu sanaꞌ arquiꞌ nú neca tucunecatse cuna liꞌá, zeca nzeꞌe tucu nú seca yaa luchi lubeꞌ nú urecuꞌ nu rebichi, che yeteꞌsae para nú chiquine. ");
INSERT INTO zplNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Tunu la tsanaꞌhua nú neca tucunecatsehua cuna liꞌá nu la tsanaꞌhua nú sucuꞌhua stichiaꞌa, unaꞌcuhua nú niarquiꞌhua nu yucuhuane. ");
INSERT INTO zplNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nu chenu neli rriꞌihua lunú riala riꞌihua equie bee nucuaꞌ, liꞌihua sucuꞌ ayahua Pa Diose, scua rlubeꞌ nú neli necahua bee benea. ");
INSERT INTO zplNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tucu nú seca Pa Diose liꞌá, leꞌca scua seꞌca liꞌihua uduꞌ equiehua nú liꞌá seꞌca liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tunu liꞌihua sucuꞌhua stichiaꞌa, rduꞌ equiehua nú liꞌá seꞌca liꞌihua, scua tucu nú sucua nú rni Pa Diose, xne rduꞌ equiea nú liꞌinu secanu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Rnia scua luhua para nú ñia tsu arquiꞌhua tucu nú ñia nzu arquia para nú zaꞌ nú ñia nzu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nee lunú rnibiyaꞌa luhua necane: nú uzecahua bee saꞌhua tucu nú seꞌca liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Leꞌca eluseca nú máse llene neca nú zela tucu bene ati equie cuendaꞌ amigoꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nu liꞌihua necahua bee amigoa, tunu rriꞌihua lunú rnibiyaꞌa luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","La nia mosoa luhua xne tucu mosoꞌ la riꞌi beyaꞌ ye nú rriꞌi patrón. Liꞌá rnia luhua bee amigo, xne liꞌá unila luhua ye beenú uni Pa Diose lua. ");
INSERT INTO zplNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Liꞌihua nécañihua liꞌá, sino que liꞌá ucañia liꞌihua, nu uxeꞌla liꞌihua para nú chetixiuleꞌehua lubee bene nú chili arquiꞌbeei liꞌá, tucu nú nzeli arquiꞌhua liꞌá para nú nzedalala bee bene enu chili arquiꞌ liꞌá. Nu scua Pa Diose liquiꞌ luhua ye nú nacuꞌhua lunu equie cuendaꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nee lunú rnibiyaꞌa luhua necane: nú uzecahua bee saꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tunu rana arquiꞌ bee bene liꞌihua ulluꞌcu arquiꞌhua nú liꞌá rlutila uhuana arquiꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tunu liꞌihua nehuañiscaꞌhua tucu nú nehuañi beei, seca beei liꞌihua tucu nú seca beei saꞌbeei, pero liꞌá ucañia liꞌihua leta beei, nu rana arquiꞌbeei liꞌihua, xne la riaꞌahua tucu nú rriꞌi beei. ");
INSERT INTO zplNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ulluꞌcu arquiꞌhua bee bedichiaꞌ nú unilá luhua: “Niꞌ tucu mosoꞌ la neca equiela lu patronꞌ.” Neequie tunu liꞌá rriꞌi condra bee bene, leꞌca riꞌi condra beei liꞌihua, nu tunu rriꞌi caso beei stichiaꞌa, leꞌca riꞌi caso beei stichiaꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Scua riꞌinu beei liꞌihua lunú necahua bee benea, xne lachulu beei enu uxeꞌla liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Liꞌibeei lecaxi equiya luꞌcu beei, tunu liꞌá lá ayela ania lubeei pero nee lunú ubelalá unia lubeei lecaꞌ xi quieruꞌulá beei lu cuendaꞌ stula beei. ");
INSERT INTO zplNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nu bee bene enu rana arquiꞌ liꞌá, leꞌca nuu Pa Diose rana arquiꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Lecaxi equiya luꞌcubeei tunu liꞌá lá ariꞌá bee milagro lubeei, bee milagro nú niꞌ tucu bene lá riꞌi, pero nee añinzuca nú ulañiꞌlaꞌ beei beenú uriꞌá rana arquiꞌbeei liꞌá, nu leꞌca nuu Pa Diose rana arquiꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero recae scua, xne rquiꞌña nú yalu tucu nú nequie lu leyꞌ beei elu rni: “Rana arquiꞌbeei liꞌá nu lecaxi rriꞌa lubeei.” ");
INSERT INTO zplNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Pero chenu riña enu duꞌ ana arquiꞌhua, liꞌinu necanu Espíritu Santo enu xeꞌla luhua desde elu nzucu Pa Diose, nu liꞌinu ninu equie cuendaa. ");
INSERT INTO zplNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nu leꞌca liꞌihua nihua equie cuendaꞌ liꞌá, xne nucuaꞌanuhua liꞌá desde nú uquixiea setea liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Rnia bee bedichiaꞌ quieꞌ luhua para nú la tsu chiucu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Xne nzeꞌta bichia nú la zelaꞌbeei nú chuꞌuhua liñi indu, nu hasta riña bichia nú bene enu úti liꞌihua zeca nzeꞌe nú rriꞌi nzeꞌe lunú riuꞌ arquiꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Rriꞌi beei scua xne lascaꞌ chulu beei Pa Diose nu niꞌ liꞌá lá chulu beei. ");
INSERT INTO zplNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Rnia bee nucuaꞌ luhua para nú chenu acane elluꞌcu arquiꞌhua nú unilane luhua. Né nia nucuaꞌ luhua desde nú uquixiea setea liꞌihua, xne liꞌá nzua cuna liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","’Pero nee nziaꞌa lu enu uxeꞌla liꞌá nu niꞌtucuhua la nedichiaꞌ lua cá nzaꞌa, ");
INSERT INTO zplNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","aꞌla chiquiꞌ nehuana nzu arquiꞌhua nú unia scua luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero liꞌá rnia luhua: nú neca nzeꞌcalá para liꞌihua nú nziaꞌa. Xne tunu la yaꞌa la yeꞌta Espíritu Santo luhua pero tunu nziaꞌa liꞌá xeꞌla Espíritu Santo luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nu chenu riñanu che lubeꞌ nzeꞌcanu lubee bene ta enu rluꞌcu dula, nu ta enu la luꞌcu dula, nu ta enu riala castiya. ");
INSERT INTO zplNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nu liꞌibeei riꞌibeei beyaꞌ nú rluꞌcu beei dula xne la chili arquiꞌbeei liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nu riꞌibeei beyaꞌ nú liꞌá la luꞌcua dula xne nziaꞌa lu Pa Diose, nu la lañiaꞌhua liꞌá, ");
INSERT INTO zplNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","nu leꞌca riꞌibeei beyaꞌ nú enu riala castiya neca bezeꞌlu enu rnibiyaꞌ lu iliulabe quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Huaxiscaꞌlá nú rlucua nia luhua, pero nee liꞌihua la riꞌihua beyaꞌ xi rni bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero chenu riña Espíritu Santo liꞌinu lubeꞌnu luhua ye nú neli neca xne la ninu lu cuendaꞌ liꞌinu, liꞌinu ninu ye nú rieneꞌnu nu equie cuendaꞌnu riꞌihua beyaꞌ beenú aca. ");
INSERT INTO zplNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nu liꞌinu zucuꞌ ayanu liꞌá, xne ye nú nediyaꞌnu lu cuendaa lubeꞌnue luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ye nú rluꞌcu Pa Diose, leꞌca necane stenea enzeꞌe unia luhua nú ye nú nediyaꞌ Espíritu Santo lu cuendaa lubeꞌnue luhua. ");
INSERT INTO zplNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Lleꞌnatsia la lañiaꞌhua liꞌá, pero cheelá lleꞌnatsia chu lañiꞌ zecaꞌhua liꞌá, xne nziaꞌa lu Pa Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chequie nuꞌ bee beneꞌnu unedichiaꞌ beella lu saꞌbeella: ―¿Xi rninu nú lleꞌnatsia la lañiaꞌahuanu nu cheelá lleꞌnatsia lañiꞌ zecaꞌahuanu xne nzianu elu nzucu Pa Diose? ");
INSERT INTO zplNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Xi rni bedichiaꞌ nú rninu “lleꞌnatsia”? La riaꞌahua beyaꞌ xi rninu. ");
INSERT INTO zplNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nu uriꞌi Jesuse beyaꞌ nú niarquiꞌ beella nedichiaꞌ beella lunu bedichiaꞌ nú uninu lubeella: ―¿Rnedichiaꞌhua lu saꞌhua lunú unia, lleꞌnatsia la lañiaꞌhua liꞌá nu cheelá lleꞌnatsia lañiꞌ zecaꞌhua liꞌá la? ");
INSERT INTO zplNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Neli rnia luhua nú unaꞌhua nu nehuana tsu arquiꞌhua, diquila nú ñia nzu arquiꞌ beelá bee bene. Pero lecaxi riꞌi nú nehuana tsu arquiꞌhua, cheela cheꞌe nú ñiaꞌla tsu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tucu nú seca tucu unaꞌa enu enta nú ala enduꞌ rlachi xlaꞌculla pero chenu ungulala enduꞌlla, niꞌ la llucuaꞌ arquiꞌlla nú nehuana utsiꞌlla equie nú ñia nzu arquiꞌlla nú ungula enduꞌlla lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Leꞌca scua liꞌihua nehuana nzu arquiꞌhua nee, pero chenu nzelabiꞌya zeca liꞌihua chiquiꞌ ñia tsu arquiꞌhua nu lecati axi nú ñia nzu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Bichia zeꞌe lecaꞌ xi nedichiaꞌhua lua. Nu neli nia luhua nú ye nú nacuꞌhua lu Pa Diose, liꞌinu liquiꞌnue luhua equie cuendaꞌ liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta nee lecaxi nacuꞌhua lunú equie cuendaa, unaꞌcuhua nu yucuhuane para nú zaꞌ nú ñia tsu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ye beenú unia luhua la riꞌihua beyaꞌe xne unine luhua puro bee ejemplu pero nzeꞌta hora nú la niaꞌa scua luhua, sino que achee nia luhua equie cuendaꞌ Pa Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Bichia zeꞌe equie cuendaa nuꞌ modo nacuꞌhua lu Pa Diose nu la quiꞌñiaꞌ nú nacua lunu equie cuendaꞌhua, ");
INSERT INTO zplNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","xne leꞌca liꞌi Pa Diose seca liꞌihua, secanu liꞌihua xne secahua liꞌá nu nzeli arquiꞌhua nú liꞌinu uxeꞌlanu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Lunú uriña lu iliulabe quieꞌ, nu nee tsaꞌna iliulabe quieꞌ para nú benchilaꞌ zeca lunu. ");
INSERT INTO zplNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chequie uni bee beneꞌnu lunu: ―Nee siꞌ achee rixiuleꞌelu luru, la niaꞌlu bee ejemplu luru tucu nú unilu nú la riꞌiru beyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nee rriꞌiru beyaꞌ nú nediyaꞌlu yeene nu la quiꞌñialu nú ti nedichiaꞌ lulu, enzeꞌe nzeli arquiꞌru nú nzeꞌtalu enza lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nu ucuaqui Jesuse lubeella: ―¿Nee siꞌ nzeli arquiꞌhua liꞌá la? ");
INSERT INTO zplNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Xne nee nzeꞌta riñala hora, nu nee necalane, nú liꞌihua riꞌchialetsehua tucua tucuahua naꞌtsehua inziuꞌhua, nu tsaꞌnahua stuculiꞌa. Pero la yaꞌna stuculiꞌa xne Pa Diose nzu cuna liꞌá ");
INSERT INTO zplNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Rnia ye bee nucuaꞌ luhua para nú equie cuendaꞌe ñia tsu arquiꞌhua. Liꞌihua nehuana zecahua lu iliulabe, pero la lliquihua xne liꞌá uriꞌila ana luye nú nuꞌ lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chenu ulaxu nú uni Jesuse scua lubee beneꞌnu, che ubiꞌyanu enza liñibe nu uninu: ―Pa Diose, uriñala hora nú aca lunú riala aca. Ulubeꞌ poder nú rluꞌcu lliꞌñilu para nú leꞌca lubeꞌ lliꞌñilu poder nú rluꞌculu. ");
INSERT INTO zplNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Xne liꞌilu udeteꞌlu poder lu lliꞌñilu para nú nibiyaꞌnu luye bee bene iliulabe, nu deteꞌnu elunehuañi nú leca xunga laxu luye bee bene, enu udeteꞌlu lunu. ");
INSERT INTO zplNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nu elunehuañicuaꞌ neca para bee bene enu nuꞌlu liꞌilu, nú tucutsia liꞌilu necalu Diose nu nuꞌlu beei Jesucristo enu uxeꞌlalu lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Liꞌá ulubea poder nú rluꞌculu ante lubee bene iliulabe, nu nee ulaꞌxula rriꞌá beenú unibiyaꞌlu lua nú riꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nee nú nzela lulu Pa Diose uliꞌquiꞌ poder lua tucu nú uluꞌcune cuna liꞌilu ante nú quixie iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Bee bene enu ucañilu lu iliulabe quieꞌ nu uliquiꞌlu lua, unila lubeella equie cuendaꞌlu. Bee beneꞌlu beella nu uliquiꞌlu beella lua nu uzucuꞌ beella stichiaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nee rriꞌi beella beyaꞌ nú equie cuendaꞌlu nzeꞌta ye beenú unia nu ye beenú uriꞌá, ");
INSERT INTO zplNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","xne udixiuleꞌa stichiaꞌlu lubeella, nu uyali arquiꞌbeella. Neequie rriꞌi nzeꞌca beella beyaꞌ nú nzela enza lulu, nu nzeli arquiꞌ beella nú liꞌilu uxeꞌlalu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Liꞌá rnacua lulu equie cuendaꞌ beella, la nacua lulu equie cuendaꞌ ye bee bene iliulabe, sino que rnacua lulu equie cuendaꞌ bee bene enu uliquiꞌlu lua, xne bee beneꞌlu neca beella. ");
INSERT INTO zplNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nu equie cuendaꞌ beella achee poder nú rluꞌcua. Ye nú neca stenea neca steneꞌlu nu ye nú neca steneꞌlu leꞌca necane stenea. ");
INSERT INTO zplNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Liꞌá la zucuaꞌa lu iliulabe quieꞌ pero liꞌibeella nucuaꞌalá beella lu iliulabe, nu liꞌá nzela lulu. Pa Diose, liꞌilu enu la luꞌculí dula ubiꞌyaa liꞌibeella enu uliquiꞌlu lua, cuna poder nú rluꞌculu uliꞌquiꞌlua para nú aca tucunecatse beella tucu nú tucutsia necaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Chenu nzunua liꞌibeella lu iliulabe quieꞌ, liꞌibeella enu uliquiꞌlu lua ubiꞌya beella cuna poder nú rluꞌcua uliquiꞌlu lua nu niꞌ tucu beella né nitilu, sino que unitilutsia tucu enu nzula nú nitilu, para nú yalu tucu nú rni lu ichiꞌ stichiaꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Nee nzelala lulu, pero rnia bee bedichiaꞌ quieꞌ diquila nú nzua lu iliulabe, para nú chiquiꞌ ñia tsu arquiꞌbeella tucu nú ñia nzu arquia. ");
INSERT INTO zplNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Liꞌá udixiuleꞌa stichiaꞌlu lubeella nu rana arquiꞌ bee bene liꞌibeella, xne la nehuañiaꞌ beella tucu nú nehuañi beelá bee bene, tucu nú leꞌca liꞌá la nehuañia tucu nú nehuañi bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","La nacua lulu nú hualu liꞌibeella lu iliulabequieꞌ, sino que nacua lulu nú biꞌyalu liꞌibeella para nú la riꞌibeella nú necha neca. ");
INSERT INTO zplNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Liꞌibeella la nehuañiaꞌ beella tucunú nehuañi beelá bee bene, tucu nú leꞌca liꞌá la nehuañia tucu nú nehuañi bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uriꞌi nú lecaxi naa beella nu la luꞌcu beella dula, equie cuendaꞌ stichiaꞌlu. Xne stichiaꞌlu neli necane. ");
INSERT INTO zplNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tucu nú uxeꞌlalu liꞌá lu iliulabe quieꞌ, leꞌca scua liꞌá xeꞌla liꞌibeella lu beela bee bene iliulabe, ");
INSERT INTO zplNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nu equie cuendaꞌ beella dete cuendaa liꞌá para nú leꞌca liꞌibeella lecaxi naabeella equie cuendaꞌ stichiaꞌlu nú neli neca. ");
INSERT INTO zplNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Nu la neca equie cuendaꞌtsia beella rnacua lulu, leꞌca rnacua lulu lu cuendaꞌ bee bene enu neela chili arquiꞌ liꞌá chenu yeneꞌ beella lunú ixiuleꞌe bee benea equie cuendaa. ");
INSERT INTO zplNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nacua lulu Pa Diose nú aca tucunecatse beella, tucu nú tucutsia necaa cuna liꞌilu, nu leꞌca scua acatucunecatse beella cuna liꞌá, para nú chili arquiꞌ bee bene iliulabe nú liꞌilu uxeꞌlalu liꞌá lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Leꞌca liꞌi poder nú uliquiꞌlu lua, udetene lubeella para nú acatucunecatse beella tucu nú liꞌilu nu liꞌá tucutsia necaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Liꞌá nzunua liꞌibeella nu liꞌilu nzunulu liꞌá para nú zaꞌlí nú acatucunecatse beella cuna liꞌá, nu scua riꞌi bee bene iliulabe beyaꞌ nú liꞌilu uxeꞌlalu liꞌá nu secalu liꞌibeella tucu nú secalu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Pa Diose, niarquia nú ye bee bene enu uliquiꞌlu lua cuaꞌa beella elu zucuaꞌa, para nú lañiꞌ beella poder nú uliquiꞌlu lua xne secalu liꞌá desde chenu lascaꞌ quixie iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pa Diose, liꞌilu enu rriꞌi tucu nú rialane, añinzuca nú bee bene iliulabe lá chulu beei liꞌilu pero liꞌá nuꞌlua liꞌilu, nu bee benea nediyaꞌ beella nú liꞌilu uxeꞌlalu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Liꞌá unila lubeella equie cuendaꞌlu nu nzeniscaꞌla lubeella, para nú zeca beella saꞌbeella tucu nú secalu liꞌá nu liꞌá nzua cuna liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chenu ulaxu nú uni Jesuse bee bedichiaꞌ quieꞌ, uchiuꞌunu nú nzanu cuna bee beneꞌnu stucu chú reꞌcu nú lee Cedrón. Zeꞌe nuꞌ bee aca olivos nu uyuꞌununu bee beneꞌnu leta bee aca zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nu Judas, enu udeteꞌ cuenda liꞌinu nuꞌlui zeꞌe, xne huaxi bese uyanu Jesuse liꞌibeella zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nu zeꞌe uriñayu Judas texcuaꞌa bee sundado, nu cuna texcuaꞌa bee bene enu rriucu Indu llene Jerusalén enu uxeꞌla bee uleꞌya enu rnibiyaꞌ nu bee fariseo nu nuyaꞌ beei bee lanza cuna bee espada nu leꞌca nuyaꞌ beei bee quinqué cuna bee antorcha. ");
INSERT INTO zplNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pero lunú nediyaꞌlaꞌ Jesuse ye nú zecanu, uchiuꞌunu leta bee aca zeꞌe, nu unidichiaꞌnu lubeei: ―¿Ti rlaꞌnahua? ");
INSERT INTO zplNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nu ucuaquibeei lunu: ―Liꞌiru rlaꞌnaru Jesuse bene Nazaret. Che ucuaqui Jesuse nú uninu: ―Liꞌá neca nzeꞌe. Nu Judas enu udeteꞌ cuenda liꞌinu leꞌca nzui leta beei zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nu chenu uni Jesuse lubeei: “Liꞌá neca nzeꞌe”, ulacaquie beei enza diꞌchibeei nu uyecata beei lu yuu. ");
INSERT INTO zplNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chequie unidichiaꞌ zecaꞌla Jesuse lubeei nú uninu: ―¿Ti rlaꞌnahua? Nu uniaꞌla beei stucu bese: ―Liꞌiru rlaꞌnaru Jesuse bene Nazaret. ");
INSERT INTO zplNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Che uniaꞌla Jesuse stucu bese lubeei: ―Unila luhua nú liꞌá neca nzeꞌe. Tunu liꞌá rlaꞌnahua, uzelahua nú yue bee benequieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ungae scua para nú uyalu nú uni Jesuse chenu uninu: “Niꞌ tucu bee bene enu uliquiꞌlu lua né nitilu beella.” ");
INSERT INTO zplNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chequie Simón Pedro ulualla espada nú nuyaꞌlla nu uchiecuꞌlilla diaca chubé tucu bene enu lee Malco mosoꞌ uleꞌya enu rnibiyaꞌ lubee uleꞌya. ");
INSERT INTO zplNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Che uni Jesuse lu Pedro: ―Uducheꞌ espada cuaꞌ luhuareꞌe. Xne tunu Pa Diose unilanu nú nehuana zecaa rquiꞌña nú nehuana zecaa. ");
INSERT INTO zplNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chequie bee sundado zeꞌe nu tucu sundado enu rnibiyaꞌ lubeei, cuna bee bene Israel enu rriucu Indu llene Jerusalén, unaꞌtsebeei Jesuse nu ullicaꞌcubeei liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nu unguyaꞌ beei liꞌinu rluti niꞌ Anás, enu neca suegroꞌ Caifás, Caifás quieꞌ neca uleꞌya enu máse rnibiyaꞌ lubeelá uleꞌya lana zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nu leꞌca liꞌi Caifás quieꞌ neca enu uni lubee bene Israel nú neca nzeꞌcalá para liꞌibeella nú ati tucutsia bene equie cuendaꞌ ye bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro cuna stucu beneꞌ Jesuse uyanala beella liꞌinu. Nu lunú nuꞌlu uleꞌya enu mase rnibiyaꞌ cuaꞌ stucu benecuaꞌ, che uyuꞌulla cuna liꞌinu niꞌ uleꞌyacuaꞌ, ");
INSERT INTO zplNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","pero Pedro uyaꞌna ruꞌu puertatsia. Che uchiuꞌu beneꞌ Jesuse enu nuꞌlu uleꞌya enu máse rnibiyaꞌ, nu unilla lu unaꞌa enu rriucu ruꞌu puerta zeꞌe para nú uyuꞌu Pedro. ");
INSERT INTO zplNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Che uni unaꞌa enu rriucu ruꞌu puerta zeꞌe lu Pedro: ―¿Pianu leꞌca liꞌilu necalu tucu beneꞌ Jesuse? Nu ucuaqui Pedro lunchu nú unilla: ―Liꞌá laca beneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nu lunú nucuaa che bee mosoꞌ cuna bee bene enu rriucu Indu llene Jerusalén ucuaꞌa beei quii para nú ubichia beei. Nu leꞌca nzu Pedro cuna liꞌibeei ruꞌu quii zeꞌe rebichia beei. ");
INSERT INTO zplNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Chequie uleꞌya enu mase rnibiyaꞌ uquixie unedichiaꞌ lu Jesuse equie cuendaꞌ bee beneꞌnu nu cuna equie nú seteꞌnu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Che ucuaqui Jesuse lulla nú uninu: ―Liꞌá siempre unia ante luye bee bene nu uzetea liꞌibeella liñi bee indu nu cuna liñi Indu llene Jerusalén elu rieteꞌsaꞌ ye bee bene Israel, nu lecaxi nú unia aꞌchiꞌ lubeella. ");
INSERT INTO zplNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Enzeꞌe xinu rnedichiaꞌlu lua? Unedichiaꞌ lubee bene enu ubeneꞌ nú unia, liꞌibeella nediyaꞌ beella lunú uzetea liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Chenu uni Jesuse scua tucu bee bene enu rriucu ruꞌu Indu llene Jerusalén, udichiui ruꞌunu nu uni: ―¿Xieꞌ scua rcuaqui bene lu uleꞌya enu máse rnibiyaꞌ la? ");
INSERT INTO zplNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nu ucuaqui Jesuse lui nú uninu: ―Tunu nuꞌ xi nú necha neca unia, uniꞌ xine. Pero tunu uni nzeꞌcaa, ¿xinu udiñilu liꞌá che? ");
INSERT INTO zplNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Che nacaꞌcunu uxeꞌla Anás liꞌinu lu Caifás uleꞌya enu másela rnibiyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pero Pedro nzuscaꞌ rebichia ruꞌu quii zeꞌe. Nu unibeei lulla: ―¿Pianu leꞌca liꞌilu necalu tucu beneꞌ Jesuse? Nu ucuaqui Pedro lubeei nú unilla: ―Liꞌá laca beneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chequie tucu bee mosoꞌ uleꞌya enu máse rnibiyaꞌ cuaꞌ, enu recasaꞌ bene enu uchiecuꞌ Pedro diaca, uni lu Pedro: ―¿Xieꞌlanu liꞌá ulañialu cuna liꞌilla leta bee aca olivos la? ");
INSERT INTO zplNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nu stucuaꞌla utsacuꞌ arquiꞌ Pedro nú nuꞌlulla Jesuse. Hora zeꞌe ubixia tucu tiula. ");
INSERT INTO zplNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chenu uyeꞌe lu yuu uchiuꞌunu beei Jesuse niꞌi Caifás nu unguyaꞌ beei liꞌinu ruꞌu palacioꞌ gobernador Roma. Nu bee bene Israel cuaꞌ né chuꞌu beei liñi palacio zeꞌe, xne para liꞌibeei tunu achuꞌu beei zeꞌe lixiu naa beei lu Diose, nu che lecaꞌ modo acubeei exe baxcu. ");
INSERT INTO zplNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Che uchiuꞌu Pilato nu unilla lubeei: ―¿Xi uriꞌi benequieꞌ nú uriñayuhualla caꞌa? ");
INSERT INTO zplNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Che ucuaqui beei nú unibeei lulla: ―Tunu necalla bene nzeꞌca né ayelayurulla lulu caꞌa. ");
INSERT INTO zplNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Che uni Pilato lu beei: ―Uyaꞌhualla, nu ulualuhua lu cuendaꞌlla tucu nú rnibiyaꞌ leyꞌhua. Che unibeei lu Pilato: ―Liꞌiru la luꞌcuru elurnibiyaꞌ nú nibiyaꞌru nú ati tucu bene. ");
INSERT INTO zplNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Scua uyalu nú uni Jesuse chenu uninu equie cuendaꞌ nú xa atinu. ");
INSERT INTO zplNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Chequie uyuaꞌla Pilato liñi palacio zeꞌe nu ubixialla Jesuse nu unedichiaꞌlla lunu: ―¿Xieꞌ liꞌilu necalu arreꞌ bee bene Israel la? ");
INSERT INTO zplNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Che ucuaqui Jesuse lulla nú uninu: ―¿Liꞌitsialu rnidichiaꞌlu nucuaꞌ la o stucu bene uni nucuaꞌ lulu la? ");
INSERT INTO zplNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nu ucuaqui Pilato lunu: ―¿Xieꞌ bene Israel liꞌá la? Liꞌi eꞌcu bee bene lachilu cuna bee uleꞌya enu rnibiyaꞌ udeteꞌ cuenda liꞌilu lua. ¿Xi uriꞌilu che? ");
INSERT INTO zplNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Che ucuaqui Jesuse lulla: ―Elurnibiyaꞌ nú rluꞌcua lacane elurnibiyaꞌ nú nuꞌ lu iliulabequieꞌ. Tunu necane elurnibiyaꞌ nú nuꞌ lu iliulabequieꞌ, rluꞌcua bee bene enu ariꞌi xuu para nú lecati adeteꞌ cueda liꞌá lubeei pero elurnibiyaꞌ nú rluꞌcua lacane elurnibiyaꞌ nú nuꞌ lu iliulabequieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chequie uni Pilato lunu: ―¿Liꞌilu necalu arre chela? Nu ucuaqui Jesuse lulla nú uninu: ―Tucu nu rnilu scua necane, liꞌá neca arre. Para nucuaꞌ ungula, nu para nucuaꞌ ubela lu iliulabe quieꞌ para nú nia lunú neli neca lubee bene. Ye bee bene enu nzenala nú neli neca rieneꞌ bee nzeꞌe nú rnia. ");
INSERT INTO zplNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Che uni Pilato lunu: ―¿Xi neca nú neli neca che? Chenu ulaxu uni Pilato nucuaꞌ, uchiuꞌu zecaꞌlalla uyaniꞌlla lubee bene Israel zeꞌe nu unilla lubeei: ―La llela niꞌ tucu equiya nú uriꞌi benequieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero liꞌihua rluꞌcuhua custumbre nú liꞌá laꞌa tucu bene enu nchiñi niꞌcuꞌ lu eliñi baxcu. ¿Niarquiꞌhua nú laꞌa Arre Israel che la? ");
INSERT INTO zplNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chequie ubixialí zecaꞌlabeei nú unibeei: ―La laꞌalu benequieꞌ, ulaꞌa Barrabás. Nu Barrabás necai tucu huanaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Che unibiyaꞌ Pilato nú uzeteꞌcheꞌ bee sundado Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nu bee sundado cuaꞌ urecheꞌ beei tucu elluꞌñiꞌ eche uzucuꞌbeei equienu, nu ungutubeei liꞌinu tucu laquie morado. ");
INSERT INTO zplNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Che uyabica beei lunu rnibeei: ―¡Nehuañi arre Israel! Nu udichiu beei ya beei lunu. ");
INSERT INTO zplNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Chequie uchiuꞌu zecaꞌla Pilato nu unilla lubee bene Israel zeꞌe: ―Ubiꞌyacuruhua, hualla caꞌa para nú riꞌihua beyaꞌ nú lá llela niꞌ tucu equiya nú xi uriꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nu uchiuꞌu Jesuse nzucu elluꞌñiꞌ eche equienu nu nutunu laquie morado nú ungutubeei liꞌinu. Che uni Pilato lubee bene zeꞌe: ―¡Nzuquieꞌlla! ");
INSERT INTO zplNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Che bee uleꞌya enu rnibiyaꞌ cuna bee bene enu rriucu Indu llene Jerusalén chenu ulañiꞌ beei liꞌinu uquixie beei rixiali beei rnibeei: ―¡Uquieꞌella lu cruse! ¡Uquieꞌella lu cruse! Che uni Pilato lubeei: ―Liꞌihua uyaꞌhualla nu uquieꞌehualla lu cruse, xne liꞌá la llela niꞌtucu equiya nú xi uriꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero bee bene Israel zeꞌe ucuaqui beella nú unibeella: ―Liꞌiru rluꞌcuru tucu ley, nu lunú rnibiyaꞌ ley riala nú atilla xne rnilla nú necalla lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Chenu ubeneꞌ Pilato nucuaꞌ chiquiꞌ ulliquilla. ");
INSERT INTO zplNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Che uyuꞌu zecaꞌlalla liñi palacio nu unedichiaꞌlla lu Jesuse: ―¿Cá benelu? Pero lecaxi ucuaqui Jesuse lulla. ");
INSERT INTO zplNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Che uni Pilato lunu: ―¿Xieꞌ la cuaquilu nú rnia la? ¿Xieꞌ la riꞌilu beyaꞌ nú rluꞌcua elurnibiyaꞌ nú nibiyaꞌa nú quielu lu cruse, nu leꞌca para nú laꞌa liꞌilu la? ");
INSERT INTO zplNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Chequie ucuaqui Jesuse lulla: ―Lecaxi elurnibiyaꞌ rluꞌculu lua, tunu lá liquiꞌ Diosee lulu, enzeꞌe bene enu udeteꞌ cuenda liꞌá lulu nzeꞌe rluꞌcu masela equiya luquela liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nu desde hora zeꞌe, uquixie rlaꞌna Pilato nú xneca modo laꞌalla Jesuse, pero bee bene Israel zeꞌe ubixialíbeei nú unibeei: ―¡Tunu laꞌalulla lacalu amigoꞌ arre César! ¡Xne titse bene enu rni nú neca arre, rriꞌi condra nzeꞌe arre César! ");
INSERT INTO zplNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chenu ubeneꞌ Pilato nucuaꞌ uhua zecalla Jesuse eleꞌyaꞌ ante lubee bene zeꞌe nu chu uzuculla lu xleta elu rlualullae, tucu luhuare elu lee bedichiaꞌ hebreo Gabata, nu rni nucuaꞌ labe eleꞌyaꞌ nú necacheꞌ cuna quiee. ");
INSERT INTO zplNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nu bichia zeꞌe neca bichia xee eliñi baxcu, nu tucu rebibichia, uni Pilato lubee bene Israel cuaꞌ: ―¡Nzuquieꞌ arreꞌhua! ");
INSERT INTO zplNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero ubixialíbeei nú unibeei: ―¡Utilla! ¡Utilla! ¡Quieꞌella lu cruse! Che uni Pilato lubeei: ―¿Xieꞌ quieꞌa arreꞌhua lu cruse la? Nu ucuaqui bee uleꞌya enu rnibiyaꞌ: ―Lecati stucu neca arreꞌru, tucutsia arre César neca arreꞌru. ");
INSERT INTO zplNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chequie udeteꞌ cuenda pilato liꞌinu lubee sundado para nú chequieꞌe beei liꞌinu lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nu uchiuꞌunu beei Jesuse nu nuyaꞌnu cruse, nzenubeei liꞌinu “tucu luguare elu lee calavera”, nu bedichiaꞌ hebreo lee Gólgota. ");
INSERT INTO zplNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Zeꞌe uquieꞌebeei liꞌinu lu cruse, nu cuna xiucu bene tucua beei cada tucu chú cueꞌtsenu nu liꞌinu labe. ");
INSERT INTO zplNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nu unibiyaꞌ Pilato nú uquiee bee bedichiaꞌ equie cruseꞌnu nú rni: “Jesuse bene Nazaret, Arreꞌ bee bene Israel.” ");
INSERT INTO zplNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Huaxi bee bene Israel ungula bee bedichiaꞌ zeꞌe xne luhuare elu uquieꞌe bee bene liꞌinu lu cruse axue Jerusalén, nu bee bedichiaꞌ zeꞌe nequiene cuna bedichiaꞌ hebreo, cuna bedichiaꞌ griego nu bedichiaꞌ latín. ");
INSERT INTO zplNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Enzeꞌe bee uleꞌya Israel enu máse rnibiyaꞌ uni beella lu Pilato: ―Xinu uquieꞌelu: “Arreꞌ bee bene Israel”, mejora uquieꞌe: “Enu rni nú neca Arreꞌ bee bene Israel.” ");
INSERT INTO zplNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nu ucuaqui Pilato lubeella: ―Lunú uquieꞌa, uquieꞌelane. ");
INSERT INTO zplNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Chenu ulaxu nú uquieꞌe bee sundado Jesuse lu cruse, unaꞌtsebeei xucunu nu utsabeei tacu pedaso xucunu nu uritsiꞌbeei xucunu lu dacubeei. Nu stucu xucunu nú lee túnica nu lunú tucunecatsene nu la nedicune, ");
INSERT INTO zplNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","enzeꞌe uni bee sundado lusaꞌbeei: ―La tsaꞌahuane, mejora te itaꞌahua tucu rifa para nú biꞌyaꞌahua taꞌahua riꞌi anae. Scua uyalu tucu nú niquie lu ichiꞌ Stichiaꞌ Diose elu rni: “Uditsiꞌbeei xucua lusaꞌbeei, nu urita beei rifa equie túnicaa.” Scua neca nú uriꞌi bee sundado zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Axu elu uquie Jesuse lu cruse nzu naꞌnu cuna belalla, cuna María, unaꞌa Cleofas, nu María Magdalena. ");
INSERT INTO zplNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Chenu ulañiꞌ Jesuse naꞌnu nzu cueꞌtse beneꞌnu enu chiquiꞌ secanu, uninu lu naꞌnu: ―Naa nzucuaꞌ enduꞌlu: ");
INSERT INTO zplNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nu uninu lu beneꞌnu: ―Nzucuaꞌ naꞌlu. Desde hora zeꞌe uyucu cuenda beneꞌnu nucuaꞌ naꞌnu niꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chenu ulaxu nú uni Jesuse scua lunú nediyaꞌlaꞌnu nú uyalula yeene tucu nú riala nú acane. Nu para nú yalu tucu nú nequie lu ichiꞌ Stichiaꞌ Diose, che uninu: ―Rebichia. ");
INSERT INTO zplNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nu zeꞌe nzu tucu jarra nú achechicu nuꞌ vinagre, che ucuacha beei tucu esponja lu vinagre zeꞌe nu uzucuꞌ beeii lliꞌi tucu aca nú lee hisopo, nu utiꞌbeeii ruꞌunu. ");
INSERT INTO zplNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Chenu ungüeꞌ Jesuse vinagre zeꞌe, uninu: ―Uyalula yeene nee. Che chu uziꞌquindiquinu nu ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nu bichia zeꞌe neca bichia xee eliñi baxcu chenu rriꞌilu bee bene ye nú xi quiꞌñiabeei, nu la niarquiꞌbeei nú yaꞌna cuerpoꞌ bee bene zeꞌe lu cruse bichia nú sulachi beei, xne bichia zeꞌe neca bichia nú máse necachi neca para liꞌibeei, enzeꞌe unacuꞌbeei lu Pilato nú nibiyaꞌlla nú acha cuchiuꞌ bee bene enu nequie lu cruse enu nehuañiscaꞌ para nú atibeei nu laca beei lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Che uyaa bee sundado nu rluti udiꞌchia beei cuchiuꞌ tucu bene zeꞌe nu che udiꞌchia beei cuchiuꞌ stuculla. ");
INSERT INTO zplNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero chenu uyabica beei lu Jesuse ulañiꞌbeei nú ungutilanu. Enzeꞌe ne iꞌchiaꞌbeei cuchiuꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero tucu bee sundado zeꞌe utseꞌe lanza cueꞌtsenu, nu uchiuꞌu rene cuna inza cueꞌtsenu. ");
INSERT INTO zplNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nu bene enu rquieꞌe nucuaꞌ ulañiluꞌlla nú ungae scua, nu neli neca nú rnilla, nu liꞌilla nediyaꞌlla nú neli neca nú rnilla para nú chili arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ungae scua para nú uyalu tucu nú nequie lu ichiꞌ Stichiaꞌ Diose elu rni: “Niꞌ tucu artaꞌnu lá iꞌchia beei.” ");
INSERT INTO zplNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nu leꞌca stucu luhuare lu ichiꞌ Stichiaꞌ Diose elu rni: “Lañiꞌ bee bene liꞌinu enu utsee lanza.” ");
INSERT INTO zplNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chenu ulaxu nú unga ye bee nucuaꞌ che José bene eyeche Arimatea uyanaꞌcuꞌlla cuerpoꞌ Jesuse lu Pilato para nú uyaꞌllanu. José quieꞌ neca beneꞌ Jesuse pero aꞌchiꞌ xne xiquilla bee usticia Israel. Nu chenu uzela Pilato, che uyalla nu unguyaꞌlla cuerpoꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nu leꞌca Nicodemo enu uyabedichiaꞌnu Jesuse tucu rulaꞌ, uriñayulla tucu ala llichiꞌi kilo mirra nú nucha cuna áloe nú ñia rlia. ");
INSERT INTO zplNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Che unaꞌtse beella cuerpoꞌnu utelabeella venda nú nuꞌ perfume, tucu nú neca costumbreꞌ bee bene Israel chenu rcachiꞌ beella tucu benenguti. ");
INSERT INTO zplNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Axu luhuare elu uquiee Jesuse lu cruse nuꞌ bee aca ndixí, nu zeꞌe nzucu tucu eluhua elu lascaꞌlí achiꞌ nitucu bene, ");
INSERT INTO zplNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","zeꞌe ucachiꞌ beella cuerpoꞌ Jesuse xne axue, nu enta quixiela eliñi baxcu nú rriꞌi bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo silaꞌtuꞌ, chenu necabescaꞌ uyaa María Magdalena ruꞌu eluhuaꞌ Jesuse, nu ulañiꞌlla nú uducuꞌla quiee nú nacuꞌ ruꞌu eluhua zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","che xexuꞌulla uyatixiuleꞌella lu Simón Pedro nu lu stucu beneꞌ Jesuse enu chiquiꞌ secanu, nu unilla lubeella: ―¡Unguyaꞌ bene cuerpoꞌ Detá Jesuse nu la riaꞌahua beyaꞌ cá uriꞌi beei liꞌinu lecaꞌnu liñi eluhua! ");
INSERT INTO zplNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chequie uchiuꞌu Pedro cuna stucu beneꞌnu, nzuebeella ruꞌu eluhua zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Rucu beella xuxuꞌu beella nzuella pero stuculla másela xexuꞌu nza che rlutilálla uriñalla ruꞌu eluhua zeꞌe luquela Pedro. ");
INSERT INTO zplNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Chequie uziꞌquilulla riꞌyalla liñi eluhua zeꞌe, nu ulañiꞌlla laquie nú ubela Jesuse nchiucuꞌ zeꞌe pero né chuꞌulla. ");
INSERT INTO zplNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Che chu uriña Simón Pedro nu uyuꞌulla liñi eluhua zeꞌe nu leꞌca ulañiꞌlla laquie zeꞌe nú nchiucuꞌe zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","nu leꞌca ulañiꞌlla laquie nú ubela equienu nu la nchiucuꞌe cuna laquie nú ubela cuerpoꞌnu sino que neyuꞌchine nchiucuꞌ renene. ");
INSERT INTO zplNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Che leꞌca uyuꞌu stucu beneꞌnu enu uriña rlutilá liñi eluhua zeꞌe nu ulañiꞌlla nú unga, che uchili arquiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pero lascaꞌ riꞌibeella beyaꞌ lunú rni lu ichiꞌ Stichiaꞌ Diose nú huañi Jesuse lu eluti. ");
INSERT INTO zplNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Che chu nzia bee beneꞌnu nzeꞌe niꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero María uyaꞌnalá ruꞌu eluhua runaꞌ. Nu diquila nú runaꞌlla uziꞌquilulla ubiꞌyalla liñi eluhua zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","nu ulañiꞌlla chiucu bee ángele enu nutu laquie niquichi nzucu liñi eluhua zeꞌe. Tucunu nzucu elu unguta equienu nu stucunu nzucu elu unguta eꞌyanu. ");
INSERT INTO zplNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Che unidichiaꞌ bee ángele cuaꞌ lu María nú uni beenu: ―Unaꞌa, ¿xiquie nú runaꞌlu? Che unilla lubeenu: ―Xne unguyaꞌ bene cuerpoꞌ Detá Jesuse, nu la riꞌá beyaꞌ cá uriꞌi bene liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ulaxutsia unilla scua, ubelletalla nu ulañiꞌlla nú nzu Jesuse zeꞌe, pero lá chululla liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Che uninu lulla: ―Unaꞌa, ¿xiquie nú runaꞌlu? ¿Ti rcuaꞌnalu? Ulleꞌca María nú bene enu rriucu bee aca ndixi zeꞌe necanu, nu unilla lunu: ―Detá, tunu liꞌilu unguyaꞌlu cuerpoꞌ Jesuse, udixiuleꞌe lua cá uriꞌilunu para nú nzetucuaꞌanu. ");
INSERT INTO zplNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nu uni Jesuse lulla: ―¡María! Che ubelletalla nu unilla lunu bedichiaꞌ hebreo: ―¡Rabuni! ―nu ni bedichiaꞌ cuaꞌ: Maestro. ");
INSERT INTO zplNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Che uni Jesuse lulla: ―Utsanaꞌ liꞌá, xne lascaꞌ chaꞌa elu nzucu Paa, pero uquia nu uniꞌ lubee benea nú nziaꞌa elu nzucu Paa, enu leꞌca neca Paꞌhua nu neca Diosea, nu leꞌca necanu Dioseꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chequie uyatixiuleꞌe María Magdalena lubee beneꞌnu nú ulañiꞌlla Jesuse nu leꞌca udixiuleꞌella lubeella yebeenú uninu lulla. ");
INSERT INTO zplNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nu chenu uyuꞌu rulaꞌ domingo zeꞌe neyeteꞌsaꞌ bee beneꞌnu nu nacuꞌ ruꞌu puerta nucuaꞌa beella xne xiquibeella bee usticia Israel, che tuꞌnatsia uyuꞌu Jesuse elu nucuaꞌa beella nu uninu lubeella: ―¡La lliquihua! ");
INSERT INTO zplNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chenu ulaxu uninu scua, ulubeꞌnu yanu nu cueꞌtsenu lubeella. Nu chiquiꞌ ñia utsu arquiꞌbeella nú ulañiꞌ beella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Che stucuaꞌla bese uni Jesuse lubeella: ―¡La lliquihua utsu naqui arquiꞌhua! Nu tucunú uxeꞌla Paa liꞌá, leꞌca scua xeꞌla liꞌihua lubee bene iliulabe para nú ixiuleꞌehua stichiaꞌnu lubeella. ");
INSERT INTO zplNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chequie ulaanu equie beella nu uninu lubeella: ―Uyucuhua Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Chenu nihua nú xa aca perdona stula bee bene, che enu riꞌi caso nú nihua neca perdona stula nzeꞌe, nu enu la riꞌi caso nú nihua la aca perdona stula nzeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero Tomás, enu neca lu chiꞌchiucu bee beneꞌnu, enu rriꞌchia bee bene cuachi lecalla chenu ulubeꞌlu Jesuse lubeelá bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chequie chenu uni beella lu Tomás: ―Ulañiꞌru Detá Jesuse. Che ucuaqui Tomás lubeella: ―Tunu la lañia yanu elu uzucu clau, nu tunu la duaꞌa cuene yaa zeꞌe nu tunu la duꞌa yaa cueꞌtsenu elu udiꞌqui, la chili arquia. ");
INSERT INTO zplNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Xunu bichia luzeꞌelá, uyetesaꞌ zeca bee beneꞌnu nu leꞌca nzu Tomás leta beella nu nacuꞌ puerta nucuaꞌa beella, che ulubeꞌlu Jesuse lubeella nu uninu lubeella: ―¡Tsuxe arquiꞌhua! ");
INSERT INTO zplNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Che uninu lu Tomás: ―Uduꞌ cuene yaalu caꞌa nu ubiꞌyacuru yaa, nu uliꞌqui yalu nu unaꞌtse cueꞌtsea la zaꞌ arquiꞌlu. ¡Uchili arquiꞌ liꞌá! ");
INSERT INTO zplNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chequie uni Tomás lunu: ―¡Liꞌilu necalu Paa nu Diosea! ");
INSERT INTO zplNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nu uni Jesuse: ―¿Nzelí arquiꞌlu liꞌá xne ulañiꞌlaꞌlu liꞌá? ¡Ñia neca lu cuendaꞌ bee bene enu nzeli arquiꞌ liꞌá añinzuca nú lá lañiꞌ beei liꞌá! ");
INSERT INTO zplNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Huaxilá bee milagro nú uriꞌi Jesuse lubee beneꞌnu nu lá quiee lu libro quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero uquiee bee nucuaꞌ para nú chili arquiꞌhua nú Jesuse neca Cristo lliꞌñi Diose, nu lunú chili arquiꞌhua liꞌinu luꞌcuhua elunehuañi lu Diose liñibe. ");
INSERT INTO zplNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lu zeꞌe lá, ulubeꞌlu zecaꞌla Jesuse lubee beneꞌnu ruꞌu inzatuꞌ Tiberias, nu singuie ulubeꞌlunu lubeella: ");
INSERT INTO zplNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Chenu neyeteꞌsaꞌ beella, nzu Simón Pedro, cuna Tomás enu rriꞌchia bee bene cuachi, nu Natanael enu neca bene Caná tucu eyeche lu iliu Galilea cuna bee llianaꞌ Zebedeo nu cuna xiucu bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Che uni Simón Pedro lubeella: ―Nzaꞌa nze ucuaꞌa bee bela. Che unibeella: ―Leꞌca nuuru tseru cuna liꞌilu. Che nzuebeella nu uquie beella equie tucu barco, pero rulaꞌ zeꞌe né uculí beella bee bela. ");
INSERT INTO zplNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Chenu enta yeꞌela lu yuu, uriña Jesuse ruꞌu inzatuꞌ zeꞌe, pero né chulu bee beneꞌnu liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nu uni Jesuse lubeella: ―Bee enduꞌ, ¿lá ucuhua niꞌ tucu bela la? Nu ucuaqui beella nú uni beella: ―Niꞌ tucuí. ");
INSERT INTO zplNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Che uninu lubeella: ―Utsiꞌquihua ixiu nú rucuhua bee bela enza cueꞌtse barco chubee para nú ucuhua bee bela. Nu scua uriꞌi beella, nu la riquiꞌa beella lua beella ixiu lu inza, xne huaxi bela nuꞌ liñii. ");
INSERT INTO zplNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chequie beneꞌnu enu chiquiꞌ secanu uni lu Pedro: ―¡Detá Jesusenu! Chenu ubeneꞌ Simón Pedro nú necanu Detá Jesuse che chu ungutulla xuculla nú ulualla, nu chu utetsalla lu inza. ");
INSERT INTO zplNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Che beelá bee beneꞌnu uriñayuu beella barco zeꞌe nú nzexaꞌ ixiu nú achee nú bela hasta ruꞌu inzatuꞌ, xne rriꞌi casi tucu ayuꞌu metro para nú riña beella ruꞌu inzatuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Chenu ulaca beella equie barco zeꞌe ulañiꞌ beella nú nucuaꞌa quii nu nchiucuꞌ tucu bela lue, nu cuna pá. ");
INSERT INTO zplNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Che uni Jesuse lubeella: ―Uteyuhua chiucu chuna bee bela enu ulaxu inza uducuhua. ");
INSERT INTO zplNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Che uquie zeca Simón Pedro equie barco zeꞌe nu uxaꞌlla ixiu nú achee nuꞌ bee bela llene hasta ruꞌu inzatuꞌ, nu neca tucu ayuꞌu arulaꞌ nuꞌ chuna beeí, añinzuca nú huaxi beeí né tsa ixiu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Che uni Jesuse lubeella: ―Utehua ne acusilaꞌhua. Nu niꞌtucu bee beneꞌnu lá laca arquiꞌ beella anedichiaꞌ beella nú tinu, xne nediyaꞌlaꞌ beella nú Jesusenu. ");
INSERT INTO zplNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Che chu uyabica Jesuse, nu unaꞌtsenu pá nu udeteꞌnue udacu beellae, nu leꞌca scua uriꞌinu cuna bela. ");
INSERT INTO zplNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ninguieꞌ neca bese rriuna nú ulubeꞌlu Jesuse lubee beneꞌnu chenu uhuañi zecanu lu eluti. ");
INSERT INTO zplNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Chenu ulaxu nú udacusilaꞌ beella, uni Jesuse lu Simón Pedro: ―Simón, llianaꞌ Jonás, ¿másela secalu liꞌá luquela beelá beella la? Nu ucuaqui Pedro lunu: ―Ahuaꞌ, Detá, liꞌilu nediyaꞌlu nú seꞌcalu. Che uni Jesuse lulla: ―Ubiꞌya bee benea che. ");
INSERT INTO zplNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Che unedichiaꞌlanu bese rrucu lulla: ―Simón, llianaꞌ Jonás, ¿secacálu liꞌá la? Nu ucuaqui Pedro lunu: ―Ahua, Detá, liꞌilu nediyaꞌlu nú seꞌcalu. Che uni Jesuse lulla: ―Ubiꞌya bee benea che. ");
INSERT INTO zplNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nu bese rriuna unedichiaꞌlanu lulla: ―Simón llianaꞌ Jonás, ¿secalu liꞌá la? Che nehuana utsu arquiꞌ Pedro xne unedichiaꞌnu chuna bese lulla tunu secacalla liꞌinu, nu ucuaquilla nú unilla: ―Detá, liꞌilu nediyaꞌlu yeene. Liꞌilu nediyaꞌlu nú seꞌcalu. Che uni Jesuse lulla: ―Ubiꞌya bee benea che. ");
INSERT INTO zplNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Liꞌá rnia lulu nú chenu nereꞌneꞌlálu, rutulu xuculu nu nzalu elu niarquiꞌlu, pero chenu uxulu lílu yalu nu stucu bene utu xuculu liꞌilu nu uyaꞌ nzeꞌe liꞌilu elu la niarquiꞌlu chálu. ");
INSERT INTO zplNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Chenu uni Jesuse scua, rixiuleꞌenu equie cuendaꞌ nú xa ati Pedro, nu equie nú atilla zucuꞌ ayalla Diose. Chequie uninu lulla: ―Utenala liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Chenu ubelleta Pedro ulañiꞌlla nú nzeꞌtanala beneꞌ Jesuse enu chiquiꞌ secanu liꞌibeella, enu uzucu cueꞌtsenu chenu udacuxee beella enu unedichiaꞌ lunu: “Nu ti deteꞌ cuenda liꞌinu.” ");
INSERT INTO zplNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Chenu ulañiꞌ Pedro liꞌilla unedichiaꞌlla lu Jesuse nú unilla: ―Detá, liꞌiquiella ¿xa zecalla? ");
INSERT INTO zplNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ucuaqui Jesuse lulla nú uninu: ―Tunu niarquia nú nehuañilla hasta chenu riña zecaa lu iliulabe, cuenda nucuaꞌ. Liꞌilu utenalatsia liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Che urichialetse bee bedichiaꞌ cuaꞌ leta beelá bee beneꞌnu, nú beneꞌnu nucuaꞌ la atilla. Pero lá ni Jesuse nú la atilla. Lunú uninu neca: “Tunu niarquia nú nehuañilla hasta chenu riña zecaa lu iliulabe, cuenda nucuaꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nu leꞌca beneꞌnu ninguieꞌ rni bee nucuaꞌ nu uquieꞌellae. Nu nediyaꞌahua nú neli rnilla. ");
INSERT INTO zplNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nu huaxilá beenú uriꞌi Jesuse nu tunu quiee tucua tucua bee seꞌca nú la yala lu iliulabe chuꞌu bee libro quieꞌ. Amén.");
INSERT INTO zplNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo enu rquietea, ichiꞌ rluti nú uxeꞌla lulu, lu ichiꞌ zeꞌe udixiuleꞌa ye beenú uquixie Jesucristo uriꞌinu cuna ye beenú uzeteꞌnu, ");
INSERT INTO zplNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta bichia nú uquienu liñibe. Nu ante nú yanu liñibe, ucañinu bee bene enu aca bee apóstolꞌnu, nu equie cuendaꞌ Espíritu Santo, udixiuleꞌenu lubeella nú xi rquiꞌña riꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ungutinu nu uhuañi zecanu nu ulubeꞌlunu lubeella para nú riꞌibeella beyaꞌ nú neli nú nehuañinu, nu diqui chiuꞌa bichia ulubeꞌlunu lubeella, nu udixiuleꞌenu lubeella nú xa neca lunú rnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chenu nzuscaꞌnu cuna bee apóstolꞌnu, uninu lubeella nú la chiuꞌuscaꞌ beella eyeche Jerusalén. Nu uninu: ―Ucuaꞌaquiehua hasta nú yalu tucu nú ucuaqui uꞌna Paa nú riꞌinu luhua, tucu nú unilá luhua. ");
INSERT INTO zplNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Neli nú Juan urinza bee bene cuna inza, pero la acaxeaꞌ nú rinzahua cuna Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Chequie chenu uyetesaꞌbeella cuna liꞌinu, unidichiaꞌ beella lunu nu necachi unibeella: ―Jesuse, ¿xieꞌ uriñala bicha nú riꞌilu nú nibiyaꞌ zeca bee bene lachiru luru la? ");
INSERT INTO zplNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nu ucuaqui Jesuse lubeella: ―La yala nú riꞌihua beyaꞌ nú xi bichia nu xi hora nu xunga riꞌi Diose nucuaꞌ, xne liꞌitsianu rnibiyaꞌnu xunga riꞌinu nucuaꞌ; ");
INSERT INTO zplNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","pero chenu yucu arquiꞌhua Espíritu Santo, che acahua ixiuleꞌehua ti neca liꞌá lubee bene eyeche Jerusalén, cuna diqui lu iliu Judea cuna lu iliu Samaria, cuna lu ye bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chenu ulaxu nú uni Jesuse scua diquila nú riꞌyascaꞌ beella lunu tuꞌnatsia uyatsanu uquienu liñibe, che ulaca tucu xcabe nú uyacuꞌnu liñi nu né lañiaꞌ beella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Diqui nú riꞌyascaꞌ beella enza liñibe enza uquienu, che ulubeꞌlu chiucu ángele enu nutu laquie niquichi lubeella, ");
INSERT INTO zplNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","nu uni bee ángele zeꞌe lubeella: ―Bee bene Galilea, ¿xinu riꞌyaliscaꞌhua enza liñibe? Liꞌi Jesuse quieꞌ enu ulañiaꞌahua nú uquie liñibe, nzeꞌta zecanu stucu bese tucu nú ulañiꞌhua nú nzianu. ");
INSERT INTO zplNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chenu ulaca beella nú uya beella dañi nú lee Olivos, utse beella casi tucu kilometro para nú uriña beella Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Chenu uriña beella niꞌi elu nucuaꞌa beella, uquie beella stucu piso aya equie niꞌi zeꞌe. Nu singuie lee beella, Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo llianaꞌ tucu bene enu lee Alfeo, Simón enu ulletse leta tucu partido nú lee cananista, cuna Judas enu neca bichi Jacobo. ");
INSERT INTO zplNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yebeella unga tucu necatse beella nu uyete saꞌbeella para nú unacuꞌ beella lu Diose cuna bee bichi Jesuse, cuna María enu neca naꞌnu, cuna beelá bee unaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bee bichia zeꞌe utsuli Pedro lubee bene enu nzeli arquiꞌ Jesucristo, nu neca casi tucu ayuꞌu ala beella, nu uni Pedro lubeella: ");
INSERT INTO zplNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Bee saꞌa enu nzeli arquiaꞌahua Jesucristo, rquiꞌña nú yalu tucu nú uquieꞌe David lu ichiꞌ Stichiaꞌ Diose, tucu nú uduꞌ Espíritu Santo arquiꞌlla nú xneca riꞌi Judas lu iliulabe, Judas quieꞌ neca enu udeteꞌ cuenda Jesuse lubee bene enu unaꞌtse liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas quieꞌ unga tucu saꞌahua enu, uriꞌinuaꞌahua riñaꞌ tucu nú rriaꞌahua nee. ");
INSERT INTO zplNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero cuna dimi nú uyaxu Judas lu cuendaꞌ nú necha uriꞌi ungaxiꞌi tucu yuu, nu uyecata rendiqui Judas lu yuu nu utsa xlaꞌcui uchiuxquiꞌ ye llutsiꞌi, nu scua ungutii. ");
INSERT INTO zplNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chenu ungabiyaꞌ ye bee bene Jerusalén lunú unga scua, che uhualee beei yuu zeꞌe Acéldama, nu rni nucuaꞌ yuu réne. ");
INSERT INTO zplNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Xne lu ichiꞌ Stichiaꞌ Diose nú lee Salmos rni: Yaꞌna tuculiꞌ niꞌii, nu lecaꞌ xunga che cuaꞌa benene. Leꞌca rni lu Salmos cuaꞌ: Chuꞌu stucu bene luhuareꞌi. ");
INSERT INTO zplNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Enzeꞌe lu ye bee bene enu uyanzenuaꞌahua ye bee bichia chenu nzu Jesuse cuna liaꞌahua, ");
INSERT INTO zplNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","hasta chenu urinza Juan liꞌinu nu hasta bichia nú uquienu liñibe. Lu ye bee benequieꞌ rquiꞌña nú cañiaꞌahua tucu beella para nú riꞌilla elietsa luaꞌahua nú ixiuleꞌahua lubee bene nú neli nú uhuañi zeca Jesuse nú ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chequie ucañi beella chiucu bee bene cuaꞌ: tuculla lee Matías, nu stuculla lee José Barsabás, enu leꞌca riꞌchia bee bene Justo. ");
INSERT INTO zplNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nu unacuꞌ beella lu Diose nú unibeella: ―Diose Pa liñibe, liꞌilu enu nuꞌlu arquiꞌ ye bee bene, ulubeꞌluru ta lu rucu benequieꞌ enu ucañilálu ");
INSERT INTO zplNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para nú acalla apóstolꞌlu enu chuꞌu luhuareꞌ Judas xne Judas unitilulai equie cuendaꞌ stulai, nu nzialai elu riala nú yai. ");
INSERT INTO zplNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Che ubiꞌya beella biꞌya ta lu rucu bene quieꞌ yala nú chuꞌu luhuareꞌ Judas nu uyala nú uyaꞌna Matías, nu hora zeꞌe unga zeca chiꞌchiucu apóstol cuna liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Chenu uriña bichia liñi nú lee Pentecostés, uyetesaꞌ ye bee bene enu nzeli arquiꞌ Jesuse tucutsia luhuare. ");
INSERT INTO zplNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nu tuꞌnatsia ubene nú rula enza liñibe xi rula chenu enta tucu bi juerte, nu ubene nú rula diquineca liñi niꞌi elu nucuaꞌa beella. ");
INSERT INTO zplNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Chequie ulubeꞌlu beenú rnaa xi rnaa quii meꞌe nú rulu, nu ulacae equie cada tucua beella. ");
INSERT INTO zplNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nu yebeella chiquiꞌ uyucu arquiꞌbeella Espíritu Santo, nu uquixie nú unibeella stucu bee dialu rene, tucu nú niarquiꞌ Espíritu Santo nú ni beella. ");
INSERT INTO zplNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Bee bichia zeꞌe uriña bee bene Israel eyeche Jerusalén para nú deteꞌ beella ulaꞌna lu Diose, nu nzeꞌta beella diqui bee luhuare lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chenu ubeneꞌbeella nú rula, uyetesaꞌbeella para nú nze biꞌya beella xi nú rula scua, nu hasta la riꞌibeella beyaꞌ xi elliebacuꞌ riꞌibeella, xne cada tucua beella ubeneꞌ beella nú rni bee beneꞌ Jesuse dialuꞌ cada tucua beella. ");
INSERT INTO zplNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Chiquiꞌ nzenu arquiꞌbeella hasta nú lá riꞌibeella beyaꞌ xa ni beella, nu uquixie beella nú unibeella lusaꞌbeella: ―¿Xieꞌ la neca ye bee bene enu rni cuaꞌ bee bene Galilea la? ");
INSERT INTO zplNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Xiquie nú rieneꞌahua nú rnibeella dialuꞌ cada tucuaꞌahua? ");
INSERT INTO zplNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Caꞌa letaꞌahua nucuaꞌa bee bene eyeche iliu Partia, cuna bee bene enu nzeꞌta lu iliu Media, cuna bee bene enu nzeꞌta lu iliu Elam, cuna bee bene enu nzeꞌta lu iliu Mesopotamia, cuna bee bene lu iliu Judea, cuna bee bene lu iliu Capadocia, cuna bee bene lu iliu Ponto, cuna bee bene Asia, ");
INSERT INTO zplNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","cuna bee bene Frigia, cuna bee bene Panfilia, cuna bee bene Egipto, cuna bee bene lu iliu Africa, axu Cirene. Nu cuna bee bene Roma, chiucu chuna bee bene Roma quieꞌ ungula lu iliu Israel nu nucuaꞌa beei Roma. Leꞌca chiucu chuna beei neca mero bene Roma enu nzeli arquiꞌ tucu nú nzeli arquiꞌ bee bene Israel Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Leꞌca caꞌa letaꞌahua nucuaꞌa bee bene lu iliu Creta cuna bee bene Arabia, pero yeꞌahua rieneꞌahua bee milagro nú rriꞌi Diose xne rni bee bene cuaꞌ dialuꞌ cada tucuaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Chiquiꞌ nzenu arquiꞌ ye beei nu la riꞌibeei beyaꞌ xi elliebacuꞌ riꞌibeei, nu uquixiebeei nú rnidichiaꞌ beei lu saꞌbeei: ―¿Xi nucuaꞌ nú reca caꞌa scua? ");
INSERT INTO zplNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero nuꞌ beei enu utsequichiaꞌ liꞌibeella nú unibeei: ―¡Xuchiꞌ bee bene cuaꞌ! ");
INSERT INTO zplNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Chequie utsuli Pedro cuna se chetuꞌcu bee apóstol nu juerte unilla: ―Bee bene Judea cuna ye bee bene enu nucuaꞌa caꞌa Jerusalén, uzuꞌcuꞌ diacahua nu uriꞌihua beyaꞌ nú nia luhua. ");
INSERT INTO zplNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","La lluchiꞌ bee bene quieꞌ tucu nú rriꞌihua elliebacuꞌ, xne apena neca rquiquieꞌ silaꞌ nee. ");
INSERT INTO zplNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lunú reca caꞌa, neca tucu nú uni profeta Joel chenu unilla: ");
INSERT INTO zplNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Uni Diose, riña bichia chenu xeꞌla Espíritu Santoa para nú llutsene arquiꞌ ye bee bene; Nu bee llianaꞌhua cuna bee xinchiuꞌcuhua ixiuleꞌe beei stichiaꞌa, nu bee enduꞌhua huaxi beenú enta lubeꞌlu lubeei, leꞌca esquie bee bene uxu huaxi beenú ni xcalaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Bee bichia zeꞌe xeꞌla Espíritu Santoa lubee niyu cuna lubee unaꞌa enu sibiꞌ lua, che ixiuleꞌe beella stichiaꞌa lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lubea luhua nú lañiꞌhua huaxi bee seña liñibe nu chiquiꞌ chenu arquiꞌhua, nu lu yuu lubea luhua bee seña: Nu lañiꞌhua nú na xi na rene, cuna quii cuna llene nu na xi na xcabe. ");
INSERT INTO zplNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Che cabe lu bichia, nu aca nelu guu xi nelu rene, ante nú riña bichia llene nú ñia neca, chenu riña liꞌinu, enu rnibiyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nu tatse bee bene enu nacuꞌ lu Diose, tsilaꞌanu nzeꞌe lu dula. ");
INSERT INTO zplNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Nee nia luhua bee bene Israel, uzuꞌcuꞌ diacahua, nú liꞌihua nediyaꞌ nzeꞌcaꞌhua nú Jesuse bene eyeche Nazaret, liꞌinu enu uxeꞌla Diose uriꞌinu bee milagro luhua nu cuna bee seña nú chiquiꞌ uyanu arquiꞌhua para nú riꞌi nzeꞌcahua beyaꞌ nú Diose uxeꞌla liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Hasta huaꞌtu utsula Diose nú xa zeca Jesuse, liꞌihua unaꞌtsehua liꞌinu nu udeteꞌ cuendahua liꞌinu lubee bene enu necha rriꞌi para nú ungutinu lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero uriꞌi Diose nú uhuañi zeca Jesuse lu eluti, nu utsilaꞌa Diose liꞌinu lu eluti, xne másela reca Jesuse luquela eluti. ");
INSERT INTO zplNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nu chenu uni arre David bedichiaꞌ equie cuendaꞌ Jesuse, unilla: Siempre ulañia nú nzu Diose Pa liñibe cuna liꞌá. Nu nzunu cueꞌtsea chubee para nú lecaxi lliquia. ");
INSERT INTO zplNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Enzeꞌe chiquiꞌ ñia nzu arquia rnia bedichiaꞌ nzeꞌca lu Diose. Mase nú atia la chenuarquia, ");
INSERT INTO zplNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","xne la tsanaꞌlu nú yaꞌna cuerpoa liñi eluhua, nu leꞌca la tsanaꞌlu nú uchu cuerpoꞌ Lliꞌñilu enu la luꞌcu dula. ");
INSERT INTO zplNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ulubeꞌlu lua inziu nú rliquiꞌ nú nehuañia nu chiquiꞌ ñia tsu arquia huañia cuna liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Bee saꞌa, nia luhua nú arre David ungutilalla nu uhuachiꞌlalla, nu eluhuaꞌlla rlañiꞌscahua hasta nee. ");
INSERT INTO zplNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero arre David ungalla tucu profetaꞌ Diose, nu nediyaꞌlaꞌlla nú ucuaqui uꞌna Diose nú leta bee beneꞌlla enu nzeꞌta enza luquiela ala Cristo enu nibiyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Scua unga, chenu uhuañi David neca xi neca nú rlañiꞌláꞌlla nú xi enta aca, nu unilla nú huañi zeca Cristo lu eluti nu la yaꞌna cuerpoꞌnu liñi eluhua, nu leꞌca esquie la uchu cuerpoꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nu nee uriꞌila Diose nú uhuañi zeca Jesuse lu eluti, yeru ulañiꞌlaꞌru nú ungae scua. ");
INSERT INTO zplNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nu nee nzucula Jesuse liñibe cueꞌtse Diose chúbe, nu udeteꞌla Diose Espíritu Santo lunu tucu nú ucuaqui uꞌna Diose hasta huaꞌtu, nu uxeꞌla Jesuse Espíritu Santo quieꞌ lu iliulabe nu equie cuendaꞌ Espíritu Santo reca lunú rieneꞌahua nu rlañiꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","La neca David enu uquie liñibe, xne liꞌilla unilla: Diose Pa liñibe uni lu liꞌinu enu rnibiyaꞌ lua: “Uzucu cueꞌtsea chube, ");
INSERT INTO zplNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta nú riña bichia nú riꞌá nú nibiyaꞌlu lu ye bee bene enu rle lulu.” ");
INSERT INTO zplNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Enzeꞌe yehua bee bene Israel, uriꞌihua beyaꞌ nú Jesuse enu uquieꞌehua lu cruse, uriꞌi Diose nú necanu Cristo enu rnibiyaꞌ luaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chenu ubeneꞌ bee bene cuaꞌ nú uni Pedro scua, nehuana utsu arquiꞌbeella, chequie unidichiaꞌ beella lu Pedro cuna lubeelá bee apóstolꞌ Jesucristo nú unibeella: ―Uniꞌhua, ¿xi rquiꞌña nú riꞌiru che? ");
INSERT INTO zplNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nu ucuaqui Pedro lubeella: ―Utsanaꞌ arquiꞌhua stulahua, nu urinza cada tucuahua lu nú lee Jesucristo para nú riꞌi Diose perdona stulahua, nu scua liquiꞌnu Espíritu Santo luhua. ");
INSERT INTO zplNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Xne nucuaꞌ ucuaqui uꞌna Diose, nu neca nucuaꞌ para liꞌihua, nu necane para lu ye bee lliꞌñihua nu para lu ye bee bene enu nucuaꞌa istu, nu leꞌca necane para lu ye bee bene enu ucañi Diose Pa liñibe para liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Scua uni Pedro lubeella, nu unilla bee bezeteꞌ lubeella cuna beelá bee bedichiaꞌ nú unilla: ―¡Uchiuꞌuchuhua leta bee bene enu rriꞌi nú necha neca! ");
INSERT INTO zplNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Chequie bee bene enu uzucuꞌ stichiaꞌ Pedro urinza beella, nu bichia zeꞌe uyalí arquiꞌ tucu chuna mili bee bene Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yebeella utsutaꞌ arquiꞌbeella lunú uzeteꞌ bee apóstolꞌ Jesucristo liꞌibeella, nu uhuañinzeꞌca beella, nu unga tucu necatse beella nu rnacuꞌ beella lu Diose, nu uyetesaꞌbeella para nú udacu junto beella pá tucu nú unibiyaꞌ Jesucristo nú riꞌi beella. ");
INSERT INTO zplNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ye bee bene chiquiꞌ uyanu arquiꞌbeella, lu huaxi bee milagro cuna lubeela beenú uriꞌi bee apóstol. ");
INSERT INTO zplNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ye bee bene enu uyalí arquiꞌ Jesucristo neca tucu necatse beella nu uditsiꞌ beella steneꞌ beella lu saꞌbeella, ");
INSERT INTO zplNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","nu ungüiti beella bee yuꞌ beella cuna ye beenú rluꞌcu beella, nu uditsiꞌ beella dimi cuaꞌ lu saꞌbeella lunú xi seca laꞌchaꞌ cada tucua beella. ");
INSERT INTO zplNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ye bichia rieteꞌ saꞌbeella liñi Indu llene Jerusalén, nu cheelá nzuebeella niꞌbee saꞌbeella enu nzeli arquiꞌ Jesucristo nze tacu beella eta nu ñia nzu arquiꞌbeella lu saꞌ beella cuna nú seca saꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Unibeella bedichiaꞌ nzeꞌca lu Diose, nu uyuꞌ arquiꞌ ye bee bene eyeche zeꞌe lunú xneca nehuañi beella, ye bichia uriꞌi Diose elietsa nú rdalalá bee bene enu uchili arquiꞌ liꞌinu nu uriꞌinu perdona stula beella, nu uyeteꞌ bee bene quieꞌ cuna beelá beneꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tucu bichia uya Pedro cuna Juan ruꞌu Indu llene Jerusalén tucu rquiechuna uchee, neca hora zeꞌe chenu rnacuꞌ bee bene lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ruꞌu puerta indu quieꞌ, sucu tucu niyu enu lacalitse hasta nú ungulalla. Ye bichia ruyaꞌ bee bene liꞌilla nu sucuꞌ beella bene quieꞌ ruꞌu puerta nú lee ñia rnaa para nú rnacuꞌlla caridá lubee bene enu riuꞌu liñi indu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Chenu ulañiꞌlla nú nzechuꞌu Pedro cuna Juan liñi indu zeꞌe, unacuꞌlla caridá lubeella. ");
INSERT INTO zplNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Chequie ubiꞌya beella lulla, nu uni Pedro lulla: ―Ubiꞌya luru. ");
INSERT INTO zplNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nu ubiꞌyalílla lubeella nu uriꞌilla elliebacuꞌ nú deteꞌ beella dimi yalla. ");
INSERT INTO zplNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero uni Pedro lulla: ―La luꞌcua plata niꞌ oro biquia lulu, pero lunú aca riꞌá enzeꞌe riꞌá lulu: lunú rnibiyaꞌ Jesucristo bene eyeche Nazaret, nia lulu nú utsuli nu utseꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Chequie unaꞌtse Pedro ya niyu zeꞌe chúbe nu utsuli Pedro liꞌilla, nu hora zeꞌe uyuꞌu Juerzaꞌ bee cuchiuꞌlla nu utsutaꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nu utetsalla utsulílla, nu uquixiella nú utsella, uyuꞌunulla liꞌibeella liñi indu zeꞌe. Sella nu rtetsalla unilla bee bedichiaꞌ nzeꞌca lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ye bee bene enu ulañiꞌ nú sella cuna nú rnilla bee bedichiaꞌ nzeꞌca lu Diose, ");
INSERT INTO zplNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","chiquiꞌ nzenu arquiꞌbeei nu ulliqui beei lunú ulleꞌca niyu zeꞌe, xne nuꞌlubeei liꞌilla nú necalla enu sucu rnacuꞌ caridá ruꞌu indu zeꞌe, ruꞌu puerta nú lee Ñia rnaa. ");
INSERT INTO zplNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","La tsanaꞌ niyu enu uyecaꞌ zeꞌe Pedro cuna Juan, ye bee bene nzenu arquiꞌ nu uyaxuꞌu beei elu nzu Pedro cuna Juan ruꞌu cordure elu lee Salomón. ");
INSERT INTO zplNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Chenu ulañiꞌ Pedro nucuaꞌ, unilla lubee bene zeꞌe: ―Bee bene Israel, ¿xinu nzenu arquiꞌhua nú uyecaꞌ niyuquieꞌ?, nu ¿xinu riꞌyahua luru, xi neca nú liꞌiru necaru enu uriꞌi nú utse niyu quieꞌ, lunú recaru, urre lunú nehuañi nzeꞌcaru lu Diose? Xne equie nú rnibiyaꞌ Jesucristo uyecaꞌ niyu quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dioseꞌ bee beneꞌahua enu udetela Abraham, Isaac cuna Jacob, Diose quieꞌ neca enu udeteꞌ poder lu Lliꞌñinu Jesucristo, pero liꞌihua udeteꞌ cuendahua Jesucristo lubee usticiaꞌhua. Nu chenu niarquiꞌ Pilato nú laꞌalla liꞌinu liꞌihua né zelahua. ");
INSERT INTO zplNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pero luhuare nú anacuꞌhua nú laꞌa Lliꞌñi Diose enu la luꞌcu dula nu rriꞌi tucu nú neli neca, unacuꞌhua nú laꞌa tucu bene enu uriꞌi eluti. ");
INSERT INTO zplNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Scua uriꞌihua nú unguti liꞌinu enu rliquiꞌ nú nehuañi bee bene. Pero uriꞌi Diose nú uhuañi zecanu lu eluti, nu liꞌiru ulañiꞌru nú ungae scua. ");
INSERT INTO zplNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Liꞌi niyu enu uyecaꞌ quieꞌ yehua nuꞌluhualla, nu equie nú rnibiyaꞌ Jesuse uyecaꞌlla xne nzeli arquiꞌru liꞌinu. Nu equie nú nzeli arquiꞌru liꞌinu scua, enzeꞌe uyecaꞌliꞌlla tucu nú rlañiꞌ yehua nee. ");
INSERT INTO zplNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Bee saꞌa, nediyaa nú liꞌihua cuna bee usticiaꞌhua chenu ungutihua Jesuse né riꞌihua beyaꞌ xi uriꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero uriꞌi Diose scua para nú yalu stichiaꞌnu tucu nú uni ye bee profetaꞌnu hasta huaꞌtu. Nú Cristo Lliꞌñi Diose nehuana zecanu. ");
INSERT INTO zplNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Enzeꞌe nia luhua nú utsanaꞌ arquiꞌhua stulahua nu ubenchilaꞌ zeca arquiꞌhua lu Diose para nú chila Diose stulahua. Che liquiꞌnu nú ñia tsu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nu xeꞌla zeca Diose Jesucristo enu ucañinu hasta huaꞌtu luhua. ");
INSERT INTO zplNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero rquiꞌña nú nzucuscaꞌ Jesucristo liñibe hasta nú tsucheꞌ Diose yeene tucu nú uni bee profetaꞌnu hasta huaꞌtu. Liꞌibeella enu ucañinu. ");
INSERT INTO zplNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nu uni Moisés lubee beneꞌahua enu udetela: “Tucu nú uxeꞌla Diose Pa liñibe liꞌá luhua leꞌca scua xeꞌlanu stucu bene enu ni bee stichiaꞌnu luhua, nu chiuꞌu bene quieꞌ letahua. Uzuꞌcuꞌhua ye nú ni bene quieꞌ luhua, ");
INSERT INTO zplNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","xne tatse bee bene enu la zucuꞌ nú ni bene quieꞌ la nebacuaꞌlla leta bee beneꞌ Diose, nu nitilulla che.” ");
INSERT INTO zplNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ye bee profeta enu udixiuleꞌe Stichiaꞌ Diose desde tuxie Samuel cuna beelá bee profeta enu ubeꞌta enza luquiela, udixiuleꞌe beella lunú reca bee bichia quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nu liꞌihua necahua lliꞌñi bee profeta quieꞌ. Luhua zibiꞌ Stichiaꞌ Diose nú unibeella, nu leꞌca yucuhua nú ucuaqui uꞌna Diose lubee beneꞌahua enu udetela chenu uni Diose lu Abraham: “Equie cuendaꞌ bee beneꞌlu aca leꞌya ye bee bene lu iliulabe.” ");
INSERT INTO zplNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nu chenu uriꞌi Diose nú uhuañi zeca Lliꞌñinu Jesucristo lu eluti, rlutilá luhua uxeꞌlanu Lliꞌñinu para nú riꞌileꞌyanu liꞌihua para nú cada tucuahua tsanaꞌ arquiꞌhua stulahua. ");
INSERT INTO zplNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Rniscaꞌlá Pedro cuna Juan lubee bene zeꞌe, chenu uriña bee uleꞌya cuna bee bene enu rnibiyaꞌ lubee sundado enu rriucu ruꞌu Indu llene Jerusalén, cuna texcuaꞌa bee saduceo. ");
INSERT INTO zplNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Chiquiꞌ rle bee bene quieꞌ xne seteꞌ Pedro cuna Juan bee bene nu rnibeella nú huañi zeca bee benenguti tucu nú uhuañi zeca Jesuse lu eluti. ");
INSERT INTO zplNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Chequie unaꞌtse bee bene zeꞌe Pedro cuna Juan, nu lunú ucheela uduꞌscaꞌ beei liꞌibeella niꞌcuꞌ hasta nú yeꞌe luyuu stucu bichia. ");
INSERT INTO zplNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero huaxi bene enu uzucuꞌ diaca nú unibeella, uchili arquiꞌbeella Stichiaꞌ Diose nu lu yebeella enu uyalí arquiꞌ neca tucu ayuꞌ mili bee niyu sin nú bacuꞌ bee unaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chenu uyeꞌe lu yuu stucu bichia bee usticiaꞌ bee bene Israel cuna bee bene enu rnibiyaꞌ leta beella nu cuna bee ulaxcuela enu reca leyꞌ Moisés uyetesaꞌbeella eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Leꞌca zeꞌe nzu uleꞌya Anás, enu rnibiyaꞌ lubee uleꞌya cuna Caifás cuna Juan cuna Alejandro cuna ye bee niyu enu neca familiaꞌ uleꞌya enu rnibiyaꞌ lubee uleꞌya. ");
INSERT INTO zplNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Chequie unibiyaꞌ beella nú yeꞌtayu bee bene Pedro cuna Juan, nu tsu bee bene liꞌibeella labe bee bene zeꞌe, che unidichiaꞌ beella lu Pedro cuna lu Juan: ―¿Ti unibiyaꞌ nú rriꞌihua scua? ¿Nu ti unga stichiaꞌ nú rriꞌihua nucuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nu lunú chiquiꞌ nchiñi Espíritu Santo arquiꞌ Pedro che unilla: ―Liꞌihua bee usticia, nu liꞌihua bee bene uxu, ");
INSERT INTO zplNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","rnedichiaꞌhua luru lunú uriꞌinzeꞌcaru lu tucu niyu enu ungariti, nu xneca uyecaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Enzeꞌe ixiuleꞌeru luhua para nú riꞌi yehua beyaꞌ cuna ye bee bene Israel nú niyu enu nzu luhua caꞌa uyecaꞌlaꞌlla equie cuendaꞌ poderꞌ Jesucristo bene eyeche Nazaret, enu uquieꞌehua lu cruse nu uriꞌi Diose nú uhuañi zecanu lu eluti. ");
INSERT INTO zplNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Uriꞌinuhua liꞌinu tucu nú rriꞌi bee bene enu rrecheꞌe niꞌi chenu rua uꞌnalla tucu quié nú recheꞌlla niꞌi, nu lu zeꞌela quie zeꞌe neca nú máse sibiꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nu leꞌca scua lecati stucu bene enu reca tsilaꞌa liaꞌahua, xne tucutsia Jesucristo uxeꞌla Diose lu iliulabe para nú tsilaꞌa liaꞌahua lu stulaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chenu ulañiꞌ bee usticia nú la lliqui Pedro cuna Juan nú rnibeella, nu chenu uriꞌi bee usticia beyaꞌ nú né cha beella xcuela nu necatsia beella titse bee bene, che chiquiꞌ uyanu arquiꞌbeella. Nu uriꞌibeella beyaꞌ nú neca Pedro cuna Juan enu uyanzenu Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nu lunú leꞌca nzu niyu enu uyecaꞌ zeꞌe cuna liꞌibeella lecaꞌxi ullela arquiꞌ bee usticia zeꞌe ani lu cuendaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Chequie unibiyaꞌ beella nú chiuꞌu Pedro cuna Juan eleꞌyaꞌ para nú bedichiaꞌ liꞌitsia beella. ");
INSERT INTO zplNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nu unibeella lu saꞌbeella: ―¿Xi riꞌinuaꞌahua bee niyu quieꞌ? Xne ye bee bene eyeche Jerusalén nediyaꞌ nú uriꞌibeella milagro quieꞌ, nu leca modo nú tsacuꞌarquiaꞌahua nú ungae scua. ");
INSERT INTO zplNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero para nú la riꞌchia letselá bee bedichiaꞌ quieꞌ lubee bene rquiꞌña nú quiꞌyaꞌ beella riaꞌahua nu chiquiaꞌahua arquiꞌbeella para nú desde nee la niaꞌbeella lunú lee Jesuse lu niꞌ stucu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chequie ubixia zeca beella Pedro cuna Juan nu unibiyaꞌ beella lubee benecuaꞌ nú la zeteaꞌ beella nu la niaꞌ beella lunú lee Jesuse lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero ucuaqui Pedro cuna Juan lubeella: ―¿Xi rriꞌihua elliebacuꞌ nú máse neca nzeꞌca nú zucuꞌru nú rnihua la, luhuare nú zucuꞌru nú rni Diose la? ");
INSERT INTO zplNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pero liꞌiru leca modo nú tsanaꞌru nú la niru lunú ulañiꞌru cuna lunú ubeneꞌru. ");
INSERT INTO zplNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Chequie uquiꞌyaꞌ zeca Pedro cuna Juan uriꞌi bee usticia zeꞌe, nu ulaꞌa usticia liꞌibeella xne né llela arquiꞌbeella xamodo a deteꞌbeella castiya Pedro cuna Juan xne ye bee bene uni bedichiaꞌ nzeꞌca lu Diose equie milagro nú unga. ");
INSERT INTO zplNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nu máse chiuꞌa lana nza niyu enu uyecaꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Chenu ulaꞌa bee usticia Pedro cuna Juan, che chu nzuebeella elu nucuaꞌa beelá bee saꞌbeella enu nzeli arquiꞌ Jesucristo. Nu udixiuleꞌe beella lubee bene zeꞌe ye nú uni bee uleꞌya enu rnibiyaꞌ lubeelá bee uleꞌya cuna bee bene uxu enu rnibiyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chenu ubeneꞌ bee saꞌbeella enu nzeli arquiꞌ Jesucristo nucuaꞌ, yebeella unacuꞌ beella lu Diose nu unibeella: ―Diose Pa liñibe enu rnibiyaꞌ lu yeene, liꞌilu enu urecheꞌ liñibe cuna iliulabe, cuna inzatuꞌ, cuna ye nú nuꞌ lubee. ");
INSERT INTO zplNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nu equie cuendaꞌ Espíritu Santoꞌlu uchiuꞌu bee bedichiaꞌ quieꞌ ruꞌu arre David chenu unilla: ¿Xiquie nú rlee bee bene iliulabe lu Diose? Nu, ¿xinu rriꞌibeei elliebacuꞌ nú la zibiꞌ? ");
INSERT INTO zplNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bee arre cuna bee usticia enu rnibiyaꞌ lu iliulabe uyetesaꞌbeella, nu unga tucu necatse stichiaꞌ beella, para nú riꞌi cundra beella Diose cuna Cristoꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Nu scua ungala nee, Herodes cuna Poncio Pilato uyete saꞌbeella eyeche quieꞌ cuna bee bene Israel nu cuna bee bene enu la neca bene Israel. Uriꞌi cundra beella lliꞌñilu Jesuse enu la luꞌcu dula enu uxeꞌlalu lu iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Scua ungala tucu nú uriꞌilu elliebacuꞌ hasta huaꞌtu, nu uriꞌibeella nú ungala lunú riala nú aca. ");
INSERT INTO zplNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nu nee, Diose Pa liñibe ubiꞌyacuru xneca rquiꞌyaꞌru rriꞌibeella, uriꞌi elietsa luru enu neca bee beneꞌlu para nú la lliquiru ixiuleꞌeru stichiaꞌlu, ");
INSERT INTO zplNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","nu cuna poder nú rluꞌculu rriyecaru bee bene enu riti, nu leꞌca rriꞌiru bee milagro equie poder nú rluꞌcu lliꞌñilu Jesucristo enu la luꞌcu dula. ");
INSERT INTO zplNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chenu ulaxu nú unacuꞌ beella lu Diose ucuñi luhuare elu neyetesaꞌbeella, nu chiquiꞌ uyucu arquiꞌbeella Espíritu Santo nu lá lliqui beella udixiuleꞌe beella Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ye bee bene enu uyalí arquiꞌ Jesucristo unga tucu necatse beella nu unga tucutsia elliebacuꞌ beella. Niꞌ tucu beella lá ni nú neca nú rluꞌcu beella steneꞌtsia beella, sino que yeene necane steneꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nu cuna elietsaꞌ Diose, bee apóstol unilá beella nú neli nú uhuañi zeca Jesucristo stucu bese lu eluti, nu chiquiꞌ uriꞌi Diose nú neca nzeꞌca lu cuendaꞌ yebeella. ");
INSERT INTO zplNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nu niꞌ tucu beella lecaxi uzeca laꞌchaꞌ beella xne ye beella enu rluꞌcu yuu urre niꞌi ungüiti beellae. Nu dimi zeꞌe ");
INSERT INTO zplNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","udeteꞌbeella ya bee apóstol para nú ritsiꞌbeellae lu saꞌbeella tucu nú secalaꞌchaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Uhuañi tucu bene enu lee José, nu liꞌilla nzeꞌtalla leta familiꞌ bene enu lee levita, nu necalla bene enu nzeꞌta enza lu iliu Chipre. Nu uhualee bee apóstol liꞌilla Bernabé, nu rni nucuaꞌ enu sala arquiꞌ bene. ");
INSERT INTO zplNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bene quieꞌ ungüitilla tucu yuꞌlla nu udeteꞌlla dimi zeꞌe ya bee apóstol. ");
INSERT INTO zplNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero uhuañi stucu niyu enu lee Ananías, nu unaꞌlla lee Safira, ungüiti beella tucu yuꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pero unga tucu necatse beella nú uyaꞌnanu beella lleꞌna dimi quieꞌ nu lleꞌnae udeteꞌlla ya bee apóstol. ");
INSERT INTO zplNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Che uni Pedro lulla: ―Ananías, ¿xinu uzelalu nú uriꞌi bezeꞌlu ana lulu para nú unga niquichiaꞌlu lu Espíritu Santo nú uyaꞌnanulu lleꞌna dimi nú ungüitilu yuꞌlu? ");
INSERT INTO zplNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ante nú utilu yuu zeꞌe, ¿xieꞌ la neca yuu zeꞌe steneꞌlula? nu chenu ungüitilue, ¿xieꞌ la neca dimi zeꞌe dimiꞌlu la? ¿Xinu ullela arquiꞌlu nú uriꞌilu scua? Unga niquichiaꞌlu lu Diose nu né aca nequichiaꞌlu lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chenu ubeneꞌ Ananías bee bedichiaꞌ quieꞌ chu uyecatalla luyuu nu ungutilla. Che ye bee bene enu ungabiyaꞌ xi ulleꞌcalla chiquiꞌ ulliqui beella. ");
INSERT INTO zplNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chequie uriña bee niyu eꞌneꞌ zeꞌe nu utela beei tucu laquie cuerpoꞌlla Che unguyaꞌbeei cuerpoꞌlla nu uyacaꞌchiꞌ beei liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chenu udetela tucu chuna hora uriña unaꞌa Ananías zeꞌe nu la riꞌinchu beyaꞌ xi unga. ");
INSERT INTO zplNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nu unidichiaꞌ Pedro lunchu: ―Uniꞌ, ¿neli nú ungüitihua yuꞌhua tucu nú uni niyuꞌlu la? Nu ucuaqui Safira nú uninchu: ―Esquie ungüitirune. ");
INSERT INTO zplNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Che uni Pedro lunchu: ―¿Xinu unga tucu necatse stichiaꞌhua nu unga nequichiaꞌhua lu Espíritu Santo? Luꞌtsia enta bee bene enu uya caꞌchiꞌ niyuꞌlu, nu nee leꞌca scua che cachiꞌ beei liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Hora nú uni Pedro scua lunchu uyecatanchu lu Pedro nu ungutinchu. Chenu uyuꞌu bee niyu eꞌneꞌ liñi niꞌi zeꞌe ulañiꞌbeei nú ungutilanchu. Nu ulua beei liꞌinchu para nú nzecachiꞌ beei liꞌinchu tucu chu cueꞌtse tuxie niyuꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ye bee bene enu nzeli arquiꞌ Jesucristo, cuna ye bee bene enu ungabiyaꞌ lunú unga chiquiꞌ ulliqui beella. ");
INSERT INTO zplNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Chequie uriꞌilá bee apóstol huaxi bee milagro lubee bene eyeche zeꞌe; nu yebeella rieteꞌsaꞌbeella ruꞌu cordure nú lee cordureꞌ Salomón. ");
INSERT INTO zplNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bee bene eyeche zeꞌe chiquiꞌ uni nzeꞌca beei lu cuendaꞌ bee bene enu nzeli arquiꞌ Jesucristo, pero xiqui beei nú ayeteꞌsaꞌbeei cuna liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Scua unga huaxilá bee bene enu uyalí arquiꞌ Jesucristo niyu si unaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nu hasta rlua bee bene bee bene enu riti labe inziu nu rixiu beei liꞌibeella lu edaꞌ urre lu camilla para nú chenu dete Pedro masia xcaꞌlalla dete equie beella para nú yecaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nu leꞌca bee bene enu nucuaꞌa bee eyeche axu Jerusalén, huaxi bee bene zeꞌe uyanu beei bee bene enu riti cuna bee bene enu nchiñi benechiquiꞌ arquiꞌ eyeche Jerusalén nu yebeella uyecaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Chequie uleꞌya enu máse neca equie nu rnibiyaꞌ lu ye bee uleꞌya cuna bee saduceo enu nucuaꞌa cuna liꞌilla, chiquiꞌ uye arquiꞌbeei lubeella. ");
INSERT INTO zplNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Che unibiyaꞌ beei nú ulluna bee apóstol nu uduꞌ beei liꞌibeella niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero rulaꞌ zeꞌe tucu ángeleꞌ Diose uxaꞌla ruꞌu bee puertaꞌ niꞌcuꞌ zeꞌe. Nu ulua ángele zeꞌe liꞌibeella liñi niꞌcuꞌ, nu uninu lubeella: ");
INSERT INTO zplNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Uquiahua liñi Indu llene Jerusalén nu udixiuleꞌehua lubee bene para nú riꞌibeei beyaꞌ xa luꞌcu beei elunehuañi nú leca xunga laxu lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Chenu ubeneꞌbeella nú uni ángele zeꞌe scua. Silatuꞌ stucu bichia uyuꞌu beella liñi indu zeꞌe, nu uquixiebeella uzeteꞌ beella Stichiaꞌ Diose lubee bene. Chequie uleꞌya enu máse neca equie nu rnibiyaꞌ lu ye bee uleꞌya cuna beelá bee bene enu nzu cuna liꞌilla zeꞌe, uquieteꞌ saꞌbeei bee usticia cuna ye bee bene enu rnibiyaꞌ leta bee bene Israel, nu unibiyaꞌ beei nú chetucu bee sundado bee apóstol liñi niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero chenu uriña bee sundado ruꞌu puerta niꞌcuꞌ zeꞌe, lá llelaꞌbeei bee apóstol, nu ubenchilaꞌ zeca beei nu udixiuleꞌe beei lubee usticia. ");
INSERT INTO zplNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Nu unibeei: ―Chenu uriñaru ruꞌu niꞌcuꞌ nacutaꞌ ruꞌu niꞌcuꞌ, nu zeꞌe nucuaꞌa bee sundado enu rriucu ruꞌu niꞌcuꞌ. Pero chenu uxaꞌlaru ruꞌu niꞌcuꞌ niꞌtucu lecaꞌ ti nuꞌ liñi niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chequie uleꞌya enu máse neca equie nu rnibiyaꞌ lu ye bee uleꞌya cuna capitañi enu rnibiyaꞌ lubee sundado enu rriucu Indu llene Jerusalén cuna beelá bee uleꞌya enu rnibiyaꞌ, chenu ubeneꞌbeei nucuaꞌ uquixiebeei nú rriꞌibeei elliebacuꞌ xa laxulu bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hora zeꞌe uriña tucu niyu enu uni lubeei: ―Bee bene enu uduꞌhua niꞌcuꞌ nucuaꞌala beella liñi indu seteꞌ beella bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chequie capitañi zeꞌe cuna bee sundado nzetucu beei bee apóstol, pero lecaxi uriꞌinu beei liꞌibeella xne xiqui beei nú cá duꞌ bee bene eyeche zeꞌe quiee liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chenu uriñayu beei bee apóstol udeteꞌbeei liꞌibeella lubee usticia, chequie uleꞌya enu máse neca equie nu rnibiyaꞌ lu ye bee uleꞌya uni lubeella: ");
INSERT INTO zplNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Xieꞌlanú ita unibiyaꞌru luhua nú la zeteaꞌhua stichiaꞌ Jesuse lubee bene la? Nu nee uriꞌihua nú yela bee bene Jerusalén ungabiyaꞌ bee bedichiaꞌ cuaꞌ, nu leꞌca niarquiꞌhua nú ricuꞌquiyahua liꞌiru nú ungutiru Jesuse cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nu ucuaqui Pedro cuna beelá bee apóstol lubeella: ―Rluti rquiꞌña nú zucuꞌxuru nú rni Diose cheela zucuꞌru nú rni bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dioseꞌ bee beneꞌahua enu udetela uriꞌinu nú uhuañi zeca Jesuse enu ungutihua lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nu uzucuꞌ Diose liꞌinu cueꞌtse Diose chúbe liñibe, nu liꞌinu necanu enu rnibiyaꞌ nu silaꞌanu bee bene lu dula, nu equie cuendaꞌ liꞌinu nuꞌ modo nú tsanaꞌ arquiꞌ bee bene Israel stula beei nu scua riꞌinu perdona liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Liꞌiru nediyaꞌ nzeꞌcaru nú neli bee nucuaꞌ cuna Espíritu Santo nú rdeteꞌ Diose lu ye bee bene enu sucuꞌ stichiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chenu ubeneꞌbeella nucuaꞌ, chiquiꞌ ulebeella nu niarquiꞌbeella úti beella bee apóstol ");
INSERT INTO zplNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero leta bee usticia zeꞌe nzucu tucu fariseo enu lee Gamaliel, nu necalla ulaxcuela enu reca ley, nu chiquiꞌ rluꞌcu bee bene zeꞌe ulaꞌna lulla. Benequieꞌ utsulílla nu unibiyaꞌlla nú chiuꞌu bee apóstol eliꞌyaꞌ lleꞌna. ");
INSERT INTO zplNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nu chu unilla lubee usticia zeꞌe: ―Bee bene Israel, uriꞌi nzeꞌcahua elliebacuꞌ xa riꞌinuhua bee niyu quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ulluꞌcu arquiꞌhua nú xa uriꞌi tucu bene enu lee Teudas huaꞌtu, uni nú necai tucu bene enu neca equie, nu neca tucu tacu ayuꞌu bee beneꞌi, pero chenu unguuti bee bene liꞌi, ye bee bene enu uyaquie liꞌi uriꞌchia letse beei, zeꞌe ulaxu ye nu uriꞌi. ");
INSERT INTO zplNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Leꞌca bee bichia chenu unibiyaꞌ gobierno nú bacuꞌ calu neca bee bene. Uchiuꞌu Judas enu neca bene Galilea, leꞌca esquie uluꞌcui huaxi bee beneꞌi, pero chenu unguuti bee bene liꞌi, uriꞌchia letse bee beneꞌi. ");
INSERT INTO zplNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Enzeꞌe nia luhua nú utsanaꞌhua bee niyu cuaꞌ, nu ulaꞌahua liꞌibeella. Xne tunu neca nucuaꞌ bezeteꞌ nú udeteꞌ bee bene lubeella nú riꞌibeella scua, laxu nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero tunu equie cuendaꞌ Diose rriꞌibeella nucuaꞌ, leca modo tsuxehua lunú rriꞌibeella scua. Ubiꞌyahua tunu cá rriꞌi condrahua lunú neca cuendaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Che uriꞌi bee usticia zeꞌe caso lunú uni Gamaliel, nu ubixia beei bee apóstol nu uzetecheꞌ beei liꞌibeella, nu unibeei nú la chetixiuleaꞌ beella stichiaꞌ Jesuse lubee bene, nu chu ulaꞌa beei liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nu chenu uchiuꞌu beella lubee usticia zeꞌe, chiquiꞌ ñia nzu arquiꞌbeella xne utsanaꞌ Diose nú nehuana ulleꞌca beella equie cuendaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nu ye bichia né tsanaꞌ arquiꞌbeella udixiuleꞌe beella cuna nú uzeteꞌ beella bedichiaꞌ nzeꞌcaꞌ Jesucristo lubee bene, sia liñi Indu llene Jerusalén cuna niꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Bee bichia zeꞌe, chenu nze aca huaxilá bee bene enu nzeli arquiꞌ Jesucristo, che bee bene enu rni dialu griego uquixiebeella nú xanabitsi beella lu cuendaꞌ bee bene enu rni dialu hebreo. Unibeella nú yeyeꞌe chenu ritsiꞌ bee elubacu, lleꞌnalá nú riucu bee unaꞌa zaqui enu rni dialu griego luquelá nú riucu bee unaꞌa zaqui enu rni dialu hebreo. ");
INSERT INTO zplNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chequie ye chiꞌchiucu bee apóstol uquieteꞌ saꞌbeella ye bee bene enu nzeli arquiꞌ Jesucristo, nu unibeella: ―La necanzeꞌca nú tsanaꞌ arquiꞌru nú rixiuleꞌeru Stichiaꞌ Diose para nú ritsiꞌru nú acu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Enzeꞌe bee saꞌa enu nzeli arquiaꞌahua Jesucristo, ucañihua achi bee niyu letahua enu riꞌi riñaꞌ cuaꞌ, nu nediyaꞌhua nú nehuañi beella tucu nú rialane, cuna nú neli nzu Espíritu Santo cuna liꞌibeella, cuna nú rluꞌcu beella lunú reca beella. ");
INSERT INTO zplNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Liꞌiru nzenacuꞌláru lu Diose cuna nú nze tixiuleꞌeru stichiaꞌnu lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yebeella unga tucu necatse beella nú acane scua, nu ucañi beella Esteban, enu chiquiꞌ nzeli arquiꞌ Jesucristo, nu chiquiꞌ nzu Espíritu Santo cuna liꞌilla, nu leꞌca ucañi beella Felipe, Procoro, Nicanor, Timón, Parmenas, cuna Nicolás, enu neca bene eyeche Antioquía. Nicolás quieꞌ la necalla bene Israel, pero uyalí arquiꞌlla tucu nú uyalí arquiꞌ bee bene Israel ante nú chili arquiꞌlla Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chequie uriñayu beella achi bee niyu zeꞌe lubee apóstol para nú unacuꞌ beella lu Diose lu cuendaꞌ beella nu uricuꞌ beella ya beella equie beella. ");
INSERT INTO zplNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pero másela nzeriꞌchia Stichiaꞌ Diose lubee bene, cuna nú nze aca huaxilá bee bene enu nzeli arquiꞌ Jesucristo eyeche Jerusalén, hasta bee uleꞌyaꞌ bee bene Israel huaxi beella uyalí arquiꞌbeella Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Chiquiꞌ uriꞌi Diose elietsa lu Esteban, nu udeteꞌnu poder lulla nú rriꞌilla huaxilu bee milagro nú llene neca lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Chequie chiucu chuna bee bene liñi indu nú lee Esclavos Libertados, cuna bee bene eyeche Cirene, cuna bee bene eyeche Alejandría, cuna bee enu nzeꞌta enza Cilicia, cuna bee bene Asia, uquixiebeei nú unixu beei cuna Esteban. ");
INSERT INTO zplNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero bee benequieꞌ lá riꞌi stichiaꞌ beei ana lunú reca elliebacuꞌ Esteban, equie nú rriꞌi Espíritu Santo elietsa lulla. ");
INSERT INTO zplNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chequie udixiu beei chiucu chuna bee bene enu ni nú rni condra Esteban Moisés cuna Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Scua uriꞌibeei para nú ulee bee bene eyeche zeꞌe, cuna bee bene enu neca equie, cuna bee ulaxcuela enu reca leyꞌ Moisés lu Esteban. Che unaꞌtse beei liꞌilla nu uyayu beei liꞌilla lubee ustichiaꞌ bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nu leꞌca ucuaꞌna beei bee bene enu uni eluquichiaꞌ para nú uni bee nzeꞌe: ―Niyu quieꞌ la tsuxella nú seꞌtalla leyꞌ Moisés cuna induꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Liꞌiru ubeneꞌru nú rnilla nú Jesuse bene eyeche Nazaret nitilulla indu llene Jerusalén, nu cheꞌella bee custumbre nú utsaꞌna Moisés luaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Chequie bee usticia cuna ye bee bene enu nucuaꞌa zeꞌe, chenu ulañiꞌbeella lu Esteban, ulañiꞌbeella nú rnaa lulla xi rnaa lu tucu ángeleꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chequie uleꞌya enu máse neca equie nu rnibiyaꞌ lu ye bee uleꞌya unidichiaꞌlla lu Esteban nú unilla: ―¿Xieꞌ neli nú scua unilu la? ");
INSERT INTO zplNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nu uni Esteban: ―Liꞌihua bee usticia cuna yehua bee bene enu nucuaꞌa caꞌa, uzuꞌcuꞌ diacahua nú nia luhua. Diose liñibe ulubeꞌlunu lu Abraham beneꞌahua enu udetela, chenu uzuculla lu iliu Mesopotamia, ante nú chálla zuculla lu eyeche Harán. ");
INSERT INTO zplNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nu uni Diose lulla: “Utsaꞌna lachilu cuna ye bee saꞌlu, nu uquia luyuu nú lubea lulu.” ");
INSERT INTO zplNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chequie uchiuꞌu Abraham lu iliuꞌ bee bene Caldea, nu uyacuaꞌa beella lu eyeche Harán. Nu chenu unguti paꞌlla, che uni Diose lulla nú yeꞌtalla zuculla luyuu elu nucuaꞌahua hasta nee. ");
INSERT INTO zplNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero chenu uriña Abraham caꞌa, lá deteꞌscaꞌ Diose niꞌ temeꞌ yuu lulla, pero ucuaqui uꞌnanu nú deteꞌnu yuu zeꞌe lulla. Chequie chenu atilla, aca iliu zeꞌe iliuꞌ bee lliꞌñilla, añinzuca nú chenu uni Diose scua lá luꞌcuscaꞌ Abraham lliꞌñilla. ");
INSERT INTO zplNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nu leꞌca uni Diose lu Abraham, nú bee lliꞌñilla enu nzeꞌta enza luquielá checuaꞌa beei xi neca bene rene lu stucu nación, elu riꞌi bee bene nú juerte riꞌibeei riñaꞌ nu nehuana zeca beei zeꞌe diqui tacu ayuꞌu lana. ");
INSERT INTO zplNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero leꞌca uni Diose lu Abraham: “Liꞌá detea castiya bee bene enu riꞌi nú juerte riꞌibeei riñaꞌ. Cheelá chiuꞌu beei lu nación zeꞌe, nu luꞌcu beei ulaꞌna lua luhuare quieꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nu chenu uni Diose lu Abraham, utsaꞌnanu stichiaꞌnu nú quiee seña elunecachiꞌlla cuna beelá bee niyu. Enzeꞌe chenu ungula enduꞌlla Isaac, nu chenu ulluꞌcui tucu xmana uquieꞌella seña elunecachiꞌi. Leꞌca esquie uriꞌi Isaac cuna enduꞌlla Jacob. Nu leꞌca esquie uriꞌi Jacob cuna chiꞌchiucu bee enduꞌlla enu unga bee beneꞌahua enu udetela. ");
INSERT INTO zplNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Bee lliꞌñi Jacob, enu unga bee beneꞌahua enu udetela, liꞌibeella uya arquiꞌbeella lu bichi beella José. Chequie ungüiti beella liꞌilla lubee bene enu unguyaꞌ liꞌilla Egipto. Pero né tsanaꞌ arquiꞌ Diose José, ");
INSERT INTO zplNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nu Diose uriꞌi elietsa lulla lu ye nú nehuana ulleꞌcalla, nu leꞌca uriꞌinu elietsa lulla para nú uzeca Faraón arre Egipto liꞌilla, nu uriꞌi arre Faraón nú ungalla gobernador Egipto, nu unibiyaꞌlla lu ye bee steneꞌ arre zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Chequie chenu unga biña lu nación Egipto cuna Canaán, chiquiꞌ nehuana ulleꞌca bee beneꞌahua enu udetela nu ulaxu nú udacu beella. ");
INSERT INTO zplNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero chenu ungabiyaꞌ Jacob beneꞌahua enu udetela nú nuꞌ trigo Egipto, uxeꞌlalla bee llianaꞌlla nzetsi beei trigo bese rlu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nu chenu uya beella bese rrucu, udixiuleꞌe José nú necalla bichi beella, nu scua ungabiyaꞌ arre Faraón nú ti neca bee beneꞌ José. ");
INSERT INTO zplNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chequie uxeꞌla José resuna nú yeꞌta paꞌlla Jacob cuna ye bee beneꞌlla para nú cuaꞌa beella Egipto, nu neca beella setenta y cinco bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Scua unga nú uya zucu Jacob Egipto. Zeꞌe ungutilla, nu leꞌca zeꞌe unguti bee beneꞌahua enu udetela. ");
INSERT INTO zplNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Chenu udete tiembu, che unguyaꞌbeella artaꞌ bee beneꞌahua enu udetela, nu uya caꞌchiꞌ beellae eyeche Siquem, liñi eluhua nú utsi Abraham lubee llianaꞌ bene enu lee Hamor eyeche Siquem. ");
INSERT INTO zplNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Chenu nzeꞌta lluꞌcula tiembu nú aca tucu nú ucuaqui uꞌna Diose lu Abraham, chiquiꞌ udala bee saꞌahua enu neca bee bene Israel Egipto. ");
INSERT INTO zplNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chequie bee bichia zeꞌe uquixie nú rnibiyaꞌ stucu arre Egipto enu lá chulu José. ");
INSERT INTO zplNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nu arre quieꞌ ucuaꞌnalla nú uriꞌilla nú nehuana ulleꞌca bee beneꞌahua enu udetela. Unibiyaꞌlla nú utsiꞌqui bee beneꞌahua bee enduꞌ niyuꞌ beella enu ungula inza reꞌcu Nilo para nú atibeei. ");
INSERT INTO zplNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tiembu zeꞌe ungula Moisés. Nu chiquiꞌ ñia riuꞌ arquiꞌ Diose enduꞌ quieꞌ, nu uriꞌiucu bee paꞌnu liꞌinu diqui chuna guu. ");
INSERT INTO zplNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Chenu uriña bichia nú utsanaꞌ arquiꞌbeella liꞌinu, leꞌca liꞌi xinchiuꞌcu arre Egipto ullelaꞌ liꞌinu nu uriꞌi ruꞌcunchu liꞌinu xi neca enduꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nu unga Moisés ye nú reca bee bene Egipto, nu chiquiꞌ neca equie lunú rnilla cuna lunú uriꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Chenu nza Moisés chiuꞌa lana, uduꞌ arquiꞌlla nú nzebiꞌyalla bee saꞌlla enu neca bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nu chenu ulañiꞌ Moisés nú riñi tucu bene Egipto tucu bene saꞌlla. Unganuꞌlla bene zeꞌe, nu unguutilla bene Egipto zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Uriꞌi Moisés elliebacuꞌ nú nediyalaꞌ bee bene Israel nú equie cuendaꞌ liꞌilla tsilaꞌa Diose liꞌibeei lubee bene Egipto, pero la riꞌibeei beyaꞌ nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Stucu bichia, ulañiꞌ Moisés chiucu bee bene Israel nú rliu beei, nu niarquiꞌlla nú laalla liꞌibeei, nu unilla lubeei: “Tucutse saꞌhua, ¿xinu rliuhua?” ");
INSERT INTO zplNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Chequie tucu bene enu rliu zeꞌe, utsiꞌñai Moisés nu uni lulla: “¿Ti uliquiꞌ elurnibiyaꞌ lulu para nú nilu luru? ");
INSERT INTO zplNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Xieꞌ niarquiꞌlu nú útilu liꞌá tucu nú unguutilu bene Egipto necaꞌ la?” ");
INSERT INTO zplNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chenu ubeneꞌ Moisés nucuaꞌ, uyecaxuꞌulla nzalla lu iliu Madián. Zeꞌe uzuculla xi neca bene rene, nu uchialla zeꞌe nu uluꞌculla chiucu enduꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Chenu udete chiuꞌa lana, lu dañi achi elu lecalí ti nucuaꞌa, axu dañi nú lee Sinaí, ulubeꞌlu tucu ángeleꞌ Diose lu Moisés lu quii nú rulu lu tucu aca llaꞌna. ");
INSERT INTO zplNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Chequie nzenu arquiꞌ Moisés chenu ulañiꞌlla quii zeꞌe, nu chenu nzebicalla para nú lañiꞌ nzeꞌcalla nucuaꞌ, nu ubeneꞌlla chi Diose nú uni lulla: ");
INSERT INTO zplNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Liꞌá neca Dioseꞌ bee beneꞌhua enu udetela Abraham, Isaac, cuna Jacob.” Nu uquixie Moisés nú recatseꞌtseꞌlla nú xiquilla, nu né laca arquiꞌlla nú abiꞌyalla lu quii zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Chequie uni Diose lulla: “Uhua luculu, xne luhuare elu nzulu necachine. ");
INSERT INTO zplNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Liꞌá rlañi nzeꞌca lunú xa nehuana seca bee benea enu nucuaꞌa Egipto, nu rienea lunú xanabitsi beella, enzeꞌe ulaca para nú tsilaꞌa liꞌibeella lubee nucuaꞌ. Utee, ne xeꞌla liꞌilu Egipto.” ");
INSERT INTO zplNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Añinzuca nú né zucuꞌbeella lunú uni Moisés lubeella, aꞌla unibeella lulla: “¿Ti uliquiꞌ elurnibiyaꞌ lulu para nú niarquiꞌlu nilu luru?”, pero equie cuendaꞌ ángele enu ulubeꞌlu lulla lu aca llaꞌna nú rulu zeꞌe, Diose udeteꞌ elurnibiyaꞌ lulla, nu uxeꞌlanu liꞌilla para nú riꞌilla elietsa lubeella nú chiuꞌu beella Egipto. ");
INSERT INTO zplNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nu Moisés neca enu uhua bee beneꞌahua enu udetela Egipto, uriꞌilla bee milagro zeꞌe, nu leꞌca uriꞌilla bee milagro lu inzatuꞌ nú lee inzatuꞌ neluu, cuna lu dañi achi elu unzee beella diqui chiuꞌa lana. ");
INSERT INTO zplNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nu leꞌca liꞌi Moisés quieꞌ uni lubee bene Israel: “Diose cañi tucu bene enu aca tucu profeta letahua, tucu nú ucañinu liꞌá. Zuꞌcuhua stichiaꞌ profeta quieꞌ.” ");
INSERT INTO zplNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nu chenu nzu Moisés cuna bee beneꞌahua enu udetela lu dañi achi, liꞌilla necalla enu uni ángeleꞌ Diose lu equie dañi nú lee Sinaí para nú unilla Stichiaꞌ Diose lubeella. Nu bedichiaꞌ cuaꞌ neca nú utsaꞌna beella luaꞌahua hasta nee. ");
INSERT INTO zplNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero bee beneꞌahua enu udetela né zucuꞌbeella nú uni Moisés, nu lá niarquiꞌbeella nú anibiyaꞌlla lubeella, aꞌla niarquiꞌbeella nú benchilaꞌ zeca beella Egipto. ");
INSERT INTO zplNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nu unibeella lu Aarón: “Urecheꞌe bee diose enu zuculu luaꞌahua; xne la riaꞌahua beyaꞌ canza Moisés enu uhua liaꞌahua Egipto.” ");
INSERT INTO zplNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Chequie urecheꞌ beella tucu becerro enu unga dioseꞌ beella, nu unguuti beella nañi uꞌna lu becerro zeꞌe, nu uriꞌi beella tucu eliñi lunú ñia nzu arquiꞌbeella nú urecheꞌ beella becerro zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Che utsanaꞌ arquiꞌ Diose liꞌibeella, nu utsanaꞌnu nú rdeteꞌ beella ulaꞌna lu bichia cuna lu guu cuna lubee enu nchiucuꞌ liñibe. Xne scua niquie lu ichiꞌ Stichiaꞌ Diose nú uquieꞌe bee profeta elu rni: Bee bene Israel, ¿xieꞌ unguutihua bee nañi lua xi neca uꞌna, diqui chiuꞌa lana nú ucuaꞌahua lu dañi achi la? ");
INSERT INTO zplNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pero aꞌla uluꞌcuhua ulaꞌna lu dioseꞌhua enu lee Moloc enu nzucu liñi carpa nú necacheꞌ iti, cuna belaa dioseꞌ Renfán, bee diose enu leꞌca liꞌihua urecheꞌhua para nú luꞌcuhua ulaꞌna lu. Enzeꞌe xeꞌla liꞌihua elu máse istu Babilonia. ");
INSERT INTO zplNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Nu chenu ucuaꞌa bee beneꞌahua enu udetela lu dañi achi, uluꞌcu beella tucu niꞌi iti nú unga induꞌbeella elu uducheꞌ beella leyꞌ Diose. Indu quieꞌ ungacheꞌ tucu nú unibiyaꞌ Diose lu Moisés, chenu uninu lulla nú recheꞌllae tucu nú ulañiꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bee beneꞌahua enu udetela uyaꞌnanu beella induquieꞌ chenu unguti Moisés, nu chenu uyaꞌna Josué luhuareꞌ Moisés che uriñayu beella indu quieꞌ luyuu elu uriñabeella, chenu uriꞌibeella xuu lubee bene eyeche Canaán equie yuu, nu Diose uriꞌi elietsa lubeella nú uyaꞌnanu beella yuu zeꞌe. Scua uluꞌcu beella indu quieꞌ hasta bichia nú uquixie nú unibiyaꞌ arre David. ");
INSERT INTO zplNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Diose uzeca arre David, nu niarquiꞌlla nú recheꞌlla tucu indu para liꞌinu enu neca dioseꞌahua, liaꞌahua enu neca bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero arre Salomón neca enu urecheꞌ induꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Añinzuca nú la zucu Diose liñi indu nú urecheꞌ bee bene tucu nú uni profeta chenu unilla: ");
INSERT INTO zplNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","Liñibe nzucuaꞌa rnibiyaꞌa, nu luyuu neca elu nzu eꞌya. ¿Xa rnaa niꞌi nú recheꞌhua para liꞌá? ¿Nu xa rnaa luhuare elu tsulachia? Xne leꞌca liꞌá urecheꞌa ye bee nucuaꞌ, ―uni Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Pero liꞌihua ―unilá Esteban lu beella― chiquiꞌ nziti arquiꞌhua, nu la zucuꞌhua nú rni Diose. La riꞌi casohua Espirítu Santo. Tucu nú uriꞌi bee beneꞌhua enu udetela. ");
INSERT INTO zplNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bee beneꞌhua enu udetela xitse uriꞌinu beella ye bee profetaꞌ Diose, hasta nú unguuti beella bee profeta enu udixiuleꞌe nú riña liꞌinu enu rriꞌi tucu nú neli neca, nu nee nú ubeꞌtanu, udeteꞌ cuendahua liꞌinu lubee bene, nu unibiyaꞌhua nú ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Añinzuca nú uyucuhua ley nú uliquiꞌ bee ángeleꞌ Diose luhua, pero lá zucuꞌhuane. ");
INSERT INTO zplNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chenu ubeneꞌ bee bene zeꞌe nucuaꞌ, chiquiꞌ ulebeei nu tuꞌna racu xaꞌ laya beei nú rlee beei lu Esteban. ");
INSERT INTO zplNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero chiquiꞌ nzu Espirítu Santo cuna Esteban, chenu ubiꞌyalla enza liñibe ulañiꞌlla ellieꞌe elu nzucu Diose, leꞌca ulañiꞌlla nú nzulí Jesucristo cueꞌtse Diose chubee. ");
INSERT INTO zplNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Chequie uni Esteban: ―¡Ubiꞌyacuruhua! Rlañia nú naꞌla liñibe, nu leꞌca rlañia nú nzulí Jesucristo cueꞌtse Diose chúbee. ");
INSERT INTO zplNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero chenu ubeneꞌbeei nú uni Esteban scua utsacuꞌ beei diaca beei, nu juerte urixialibeei nú nze naꞌtse beei Esteban. ");
INSERT INTO zplNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Che uhuabeei liꞌilla ruꞌu eyeche zeꞌe para nú útibeei liꞌilla cuna quiee, nu tucu niyu eꞌne enu lee Saulu uriꞌi ucu xucu beei. ");
INSERT INTO zplNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nu diqui nú rduꞌbeei quiee Esteban, unilla lu Diose: ―Paa Jesuse uyucu espíritua. ");
INSERT INTO zplNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Che chu utsulliquilla nu juerte rixialilla nú unilla: ―Paa Jesuse, la duꞌ cuendalu dula nú rriꞌinu bee benequieꞌ liꞌá nee. Chenu ulaxu nú uni Esteban scua, chu ungutilla. ");
INSERT INTO zplNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nu para Saulo neca nzeꞌca nú unguuti bee bene Esteban. Nu leꞌca bichia zeꞌe uquixie bee bene nú uriꞌibeei nú nehuana seca bee beneꞌ Jesucristo eyeche Jerusalén. Ye beella uriꞌchialetse beella diqui lubee iliu Judea, cuna lu iliu Samaria, uyaꞌnatsia bee apóstolꞌnu eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Chequie chiucu chuna bee niyu enu nzenu cuenda nú nzucu Diose uyacaꞌchiꞌ beella cuerpoꞌ Esteban nu chiquiꞌ ungunaꞌnu beella liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nu uquixie Saulo nú unaꞌtsei bee bene enu nzeli arquiꞌ Jesucristo, nu riuꞌi niꞌ por niꞌ beella, nu ala juerza ruyaꞌi niyu si unaꞌa rduꞌi niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pero bee bene enu uchiuꞌu eyeche Jerusalén udixiuleꞌe beella bedichiaꞌ nzeꞌcaꞌ Diose catse elu nzuebeella. ");
INSERT INTO zplNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe enu neca tucu bene leta beella, uyalla eyeche llene Samaria, nu uquixiella rixiuleꞌella stichiaꞌ Jesucristo lubee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Uyetesaꞌ huaxi bee bene nu yebeella sucuꞌdiaca beella lunú udixiuleꞌe Felipe lubeella, cuna lunú ulañiꞌbeella bee milagro llene nú uriꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Xne uriꞌiyecalla huaxi bee bene enu nchiñi benechiquiꞌ arquiꞌ, nu rixiali bee benechiquiꞌ zeꞌe xiuꞌu arquiꞌbeei. Leꞌca uriꞌiyecalla bee bene enu neati tucu parte cuerpoꞌ cuna bee bene enu necuxu. ");
INSERT INTO zplNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Enzeꞌe chiquiꞌ ñia utsu arquiꞌ ye bee bene eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pero eyeche zeꞌe nzucu tucu bene enu lee Simón, hasta huaꞌtu rriꞌi elu uliñi nu sequienui bee bene eyeche Samaria, nu rriꞌi nú necai tucu bene enu neca equie. ");
INSERT INTO zplNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ye bee bene zeꞌe ubeneꞌbeei lunú uni Simón, desde bee enduꞌ llaꞌna nu hasta bee bene uxu, nu unibeei: ―Niyu quieꞌ chiquiꞌ rluꞌcu poder nú rluꞌcu Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Chiquiꞌ rriꞌi caso beei lunú rni, xne hasta huaꞌtu sequienui bee bene equie elu uliñi nú rriꞌi. ");
INSERT INTO zplNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero chenu uyalí arquiꞌ bee bene lunú udixiuleꞌe Felipe equie cuendaꞌ poder nú rluꞌcu Diose, cuna equie cuendaꞌ Jesucristo. Che urinza beella niyu si unaꞌa. ");
INSERT INTO zplNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nu hasta liꞌi Simón quieꞌ uyalí arquiꞌlla Jesucristo nu urinzalla, nu uquixie enzenulla Felipe, cuna nú nzenu arquiꞌlla lu ye clasiaꞌ bee milagro llene nú rlañiꞌlla rriꞌi Felipe. ");
INSERT INTO zplNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chequie chenu ungabiyaꞌ bee apóstolꞌ Jesucristo enu nucuaꞌa eyeche Jerusalén nú uchili arquiꞌ bee bene Samaria Stichiaꞌ Diose, uxeꞌla beella Pedro cuna Juan lubee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Chenu uriñabeella eyeche Samaria, unacuꞌ beella lu Diose equie cuendaꞌ bee bene enu uyalí arquiꞌ Stichiaꞌ Diose para nú yucu arquiꞌbeella Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Xne niꞌ tucu beella lascaꞌ yucu arquiꞌbeella Espíritu Santo, urinzatsia beella cuna nú lee Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Chequie uricuꞌ Pedro cuna Juan ya beella equie bee bene zeꞌe para nú uyucu arquiꞌbeella Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Chenu ulañiꞌ Simón nú uyucu arquiꞌ bee bene zeꞌe Espíritu Santo equie nú uricuꞌ bee apóstol ya beella equie bee bene zeꞌe, uniarquiꞌlla nú deteꞌlla dimi ya beella, ");
INSERT INTO zplNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","nu unilla: ―Leꞌca nua uliꞌquiꞌ poder cuaꞌ lua para nú chenu ricua yaa equie tatse bene, leꞌca yucu arquiꞌ nzeꞌe Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Chequie uni Pedro lulla: ―Liꞌilu cuna dimiꞌlu nitilulu, xne rriꞌilu elliebacuꞌ nú tsilu poder nú lia rliquiꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Liꞌilu niꞌtemeꞌ la yala nú riꞌilu tucu nú rriꞌiru, xne niꞌtemeꞌ la chequieelu inziuꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Utsanaꞌ arquiꞌ beenú necha neca rriꞌilu nu ucheꞌe elliebacuꞌlu, nu uziquiee lu Diose tunu tianuꞌ xa riꞌinu perdona lunú necha uriꞌilu elliebacuꞌ scua. ");
INSERT INTO zplNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Xne puro nú necha neca nuꞌ arquiꞌlu, nu rnibiyaꞌscaꞌ dula lulu. ");
INSERT INTO zplNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Che ucuaqui Simón nú unilla: ―Unaꞌcuhua lu Diose equie cuendaa para nú la zeca niꞌ tucu beenú unihua. ");
INSERT INTO zplNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Chenu ulaxu nú unibeella stichiaꞌ Jesucristo cuna nú unibeella Stichiaꞌ Diose lubee bene zeꞌe, cheelá ubenchilaꞌ zeca beella eyeche Jerusalén. Nu ye bee eyeche nú nchiucuꞌ lu iliu Samaria elu udete beella udixiuleꞌe beella Stichiaꞌ Diose lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Lulá bee nucuaꞌ, uni tucu ángeleꞌ Diose lu Felipe: ―Uquia enza sur, inziu nú xiuꞌu enza Jerusalén nu nza enza eyeche nú lee Gaza. Inziu zeꞌe rdete lu dañi achi. ");
INSERT INTO zplNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Che uchiuꞌu Felipe nú nzalla, nu lu inziu ullunaꞌlla tucu niyu eyeche Etiopía. Neca benequieꞌ enu chiquiꞌ neca equie xne rricucheꞌella ye dimiꞌ reina Candace enu rnibiyaꞌ Etiopía, nu uyaalla eyeche Jerusalén udeteꞌlla ulaꞌna lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nu nuꞌ nziulalla nú nzialla enza lachilla, nzuculla equie acaretaꞌlla rulalla lu ichiꞌ Stichiaꞌ Diose nú uquieꞌe profeta Isaías. ");
INSERT INTO zplNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Che uni Espíritu Santo lu Felipe: ―Uquiabica lu acareta cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Chenu uyabica Felipe lu acareta zeꞌe, ubeneꞌlla nú rula bene zeꞌe lu ichiꞌ Stichiaꞌ Diose nú uquieꞌe profeta Isaías, nu unidichiaꞌlla lu bene zeꞌe: ―¿Detá rriꞌilu beyaꞌ lu ichiꞌ nú rulalu la? ");
INSERT INTO zplNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Chequie ucuaqui bene zeꞌe nú unilla: ―¿Xa riꞌá beyaꞌ nú rnii, tunu lecati ixiuleꞌe lua xa rnii? Nu uni bene zeꞌe lu Felipe nú quieella equie acareta nu cuaꞌa junto beella. ");
INSERT INTO zplNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lu ichiꞌ Stichiaꞌ Diose elu rulalla rni: Unguyaꞌ bee bene liꞌinu xi neca tucu sanchi, elu úti beei liꞌinu; nu lá ninu xi neca tucu sanchi enu lecaxi riꞌi nuxu lu bene chenu xiecuꞌ bene ichia tsuꞌí. ");
INSERT INTO zplNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Chenu xitse uriꞌinu bee bene liꞌinu. Lecati uriꞌi elu usticia lu cuendaꞌnu, ¿ti nii nú ti neca bee beneꞌnu enu udetela? Xne uchiuꞌulanu lu iliulabe quieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Chequie uni bene zeꞌe lu Felipe: ―Uriꞌi faura uniꞌ lua, ¿ti lu cuendaꞌ rni profeta cuaꞌ, rnilla lu cuendaꞌ liꞌitsialla la, urre rnilla lu cuendaꞌ stucu bene la? ");
INSERT INTO zplNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Chequie uquixie Felipe nú udixiuleꞌella xi rni luhuare lu Stichiaꞌ Diose elu rulalla, nu uni Felipe equie cuendaꞌ bedichiaꞌ nzeꞌcaꞌ Jesucristo lulla. ");
INSERT INTO zplNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Lu zeꞌelá chenu udete beella tucu luhuare elu nuꞌ inza, uni bene zeꞌe lu Felipe: ―Caꞌa nuꞌ inza, ¿nuꞌ modo rinzalu liꞌá caꞌa nee la? ");
INSERT INTO zplNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Nu uni Felipe lulla: ―Nuꞌ modoe, tunu diquinuꞌ arquiꞌlu chili arquiꞌlu Jesuse. Che unilla: ―Chili arquia nú Jesucristo neca Lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chequie unibiyaꞌlla nú utsuxe acaretaꞌlla, nu ulaca rucu beella equie acareta zeꞌe, nu uyuꞌu beella lu inza nu urinza Felipe liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Chenu uchiuꞌu beella lu inza, hora zeꞌe tuꞌnatsia uniti Felipe nu unguyaꞌ Espíritu Santo liꞌilla, nu né lañiaꞌ bene zeꞌe liꞌilla. Pero chiquiꞌ ñia nzu arquiꞌlla nze riꞌilla seidu inziuꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Chenu uriꞌi Felipe beyaꞌ nú hasta eyeche Azoto nzulalla, che eyeche por eyeche udixiuleꞌella bedichiaꞌ nzeꞌcaꞌ Jesucristo lubee bene, hasta nú uriñalla eyeche Cesarea. ");
INSERT INTO zplNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nu bee bichia zeꞌe, la tsuxe Saulo nú rleei lubee bene enu nzeli arquiꞌ Jesucristo, nu uni nú úti liꞌibeella. Enzeꞌe uyaniꞌi lu uleꞌya enu máse neca equie nu rnibiyaꞌ lu ye bee uleꞌya, ");
INSERT INTO zplNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","para nú acacheꞌ tucu ichiꞌ nú nuꞌ modo chai liñi bee indu eyeche Damasco che cuaꞌnai bee bene enu nzeli arquiꞌ Jesucristo niyu si unaꞌa para nú uyaꞌi liꞌibeella nu duꞌi liꞌibeella niꞌcuꞌ eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pero chenu nze riñai axu eyeche Damasco, tuꞌnatsia ulaca tucu ellieꞌe nú nzeꞌta enza liñibe nu uduꞌllieꞌe ellieꞌe zeꞌe diqui abenchilaꞌ elu nza Saulo. ");
INSERT INTO zplNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nu chu uzanaꞌ Saulo luyuu, nu ubeneꞌi tucu chii nú uni: ―Saulo, Saulo, ¿xinu rriꞌi condralu liꞌá? ");
INSERT INTO zplNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nu uni Saulo: ―¿Tiilu, Detá? Nu ucuaquinu: ―Liꞌá neca Jesuse enu rriꞌi condralu, leꞌcatsia liꞌilu rriꞌilu equiya lulu. Tucu nú rriꞌi uꞌnaꞌ nú subeí lliꞌi icuꞌ aca rucha. ");
INSERT INTO zplNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nu recatseꞌtseꞌ Saulo xiquilla, nu unilla: ―Detá, ¿xi niarquiꞌlu nú riꞌá? Chequie uni Jesucristo lulla: ―Uzetee, nu uquia eyeche Damasco, zeꞌe ni bene ta nú riꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nu bee bene enu nzenu Saulo chiquiꞌ ulliqui beella, xne ubeneꞌ beella chii nú uni lulla, pero lecalí ti ulañiꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Chenu utsuli Saulo la biꞌyaꞌlla, che unaꞌtse bee bene enu nuulla yalla nu unguyaꞌbeella liꞌilla eyeche Damasco. ");
INSERT INTO zplNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Zeꞌe uzuculla chuna bichia, sin nú biꞌyalla nu sin nú aculla, nu lecaxi ungueꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Eyeche Damasco zeꞌe nzucu tucu bene enu nzeli arquiꞌ Jesucristo enu lee Ananías, Ananías quieꞌ ulubeꞌlu Jesuse lulla nu uninu lulla: ―¡Ananías! Nu ucuaquilla: ―Caꞌa nzua, Detá. ");
INSERT INTO zplNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Chequie uni Jesuse lulla: ―Utsuli nu uquia inziu llene nú lee chubee, chenu riñalu niꞌ Judas nedichiaꞌlu tucu bene eyeche Tarso enu lee Saulo. Xne rnacuꞌlla lua nee, ");
INSERT INTO zplNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","nu neca xi neca nú rni xcalaꞌlla ulañiꞌlla nú uyuꞌu tucu bene enu lee Ananías nu uricuꞌlla yalla equie Saulo, para nú biꞌya zecalla. ");
INSERT INTO zplNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Chenu ubeneꞌ Ananías nucuaꞌ, unilla: ―Detá, huaxi bee bene rni lu cuendaꞌ niyu cuaꞌ, cuna lu ye beenú necha neca rriꞌilla lubee bene enu nzeli arquiꞌ liꞌilu eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nu nee uriñalla caꞌa cuna elurnibiyaꞌ nú udeteꞌ bee uleꞌya enu máse neca equie nu rnibiyaꞌ lu ye bee uleꞌya para nú naꞌtsella ye bee bene enu nzeli arquiꞌ liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nu uni Jesuse lulla: ―Uquia, xne ucañia niyu cuaꞌ para nú ixiuleꞌella stichiaꞌa lubee bene enu la neca bee bene Israel, cuna lubee arre, nu leꞌca cuna nuu lubee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Liꞌá ixiuleꞌa lulla nú chiquiꞌ huaxi nú nehuana zecalla equie nú necalla benea. ");
INSERT INTO zplNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Chequie nza Ananías niꞌi elu nzucu Saulo. Chenu uyuꞌulla liñi niꞌi zeꞌe, uricuꞌlla yaalla equie Saulo, nu unilla: ―Saulo, Jesucristo enu ulubeꞌlu lulu lu inziu nú nzeꞌtalu, liꞌinu uxeꞌlanu liꞌá lulu para nú biꞌya zecalu, nu para nú yaꞌna Espíritu Santo cuna liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hora zeꞌe uzanaꞌ nú nacuꞌ iꞌcululla nú rna xi rna melu tsuꞌ bela, nu ubiꞌya zecalla. Che utsulílla nu urinzalla. ");
INSERT INTO zplNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Che udacu Saulo lleꞌna nú udaculla nu uyuꞌu zeca juerzaꞌlla, nu uyaꞌnalla chiucu chuna bichia cuna bee bene enu nzeli arquiꞌ Jesucristo enu nucuaꞌa eyeche Damasco. ");
INSERT INTO zplNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nu chu uquixie Saulo rixiuleꞌella Stichiaꞌ Diose liñi bee induꞌ bee bene Israel, nu unilla nú neca Jesuse Lliꞌñi Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ye bee bene enu ubeneꞌ nú rnilla chiquiꞌ nzenu arquiꞌbeei, nu unibeei: ―¿Xieꞌ laca benecuaꞌ enu utiliacaꞌ bee bene enu nzeli arquiꞌ Jesucristo eyeche Jerusalén la? ¿Lanu leꞌca liꞌi nucuaꞌ enu uriña caꞌa para nú naꞌtse nucuaꞌ bee bene enu nzeli arquiꞌ Jesucristo nu cheyu nucuaꞌ liꞌibeella lubee uleꞌya enu máse rnibiyaꞌ lu ye bee uleꞌya la? ");
INSERT INTO zplNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero bichia por bichia la lliqui Saulo rixiuleꞌella Stichiaꞌ Diose, nu rnilla nú neca Jesuse Cristo, hasta nú la riꞌi bee bene Israel enu nucuaꞌa eyeche Damasco beyaꞌ xa riꞌibeei chenu ubeneꞌbeei nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Udetetsia huaxi bee bichia, unga tucu necatse bee bene Israel enu nucuaꞌa eyeche Damasco para nú úti beei Saulo, ");
INSERT INTO zplNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","pero uriꞌi Saulo beyaꞌ nucuaꞌ. Bichia si rulaꞌ nucuaꞌa quiebeei liꞌilla ruꞌu puerta eyeche zeꞌe para nú útibeei liꞌilla, ");
INSERT INTO zplNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","che bee bene enu nzeli arquiꞌ Jesucristo rulaꞌ uduꞌ beella Saulo liñi tucu llume nu ulaca beella liꞌilla enza diꞌchi barda nú nuꞌ diqui abenchilaꞌ eyeche zeꞌe, nu scua uchiuꞌulla eyeche Damasco. ");
INSERT INTO zplNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Chenu uriña Saulo eyeche Jerusalén, uniarquiꞌlla nú yeteꞌlla cuna bee bene enu nzeli arquiꞌ Jesucristo, pero ye beella xiqui beella liꞌilla xne la chili arquiꞌbeella nú leꞌca nulla nzelíla arquiꞌlla Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Chequie unguyaꞌ Bernabé liꞌilla lubee apóstol. Nu udixiuleꞌella nú ulañiꞌ Saulo Jesucristo cuna nú ubedichiaꞌnulla liꞌinu chenu nzalla enza eyeche Damasco, nu la lliquilla udixiuleꞌella stichiaꞌ Jesucristo lubee bene eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Scua uyaꞌna Saulo eyeche Jerusalén, nu uyanzeenulla cuna liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Lá lliquilla udixiuleꞌella stichiaꞌ Jesuse, cuna nú unixulla cuna bee bene Israel enu rni dialu griego, chequie niarquiꞌbeei nú útibeei liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chenu ungabiyaꞌ bee bene enu nzeli arquiꞌ Jesucristo nucuaꞌ, unguyaꞌbeella Saulo eyeche Cesarea, nu zeꞌe uxeꞌla beella liꞌilla eyeche nú lee Tarso. ");
INSERT INTO zplNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Chequie bee bene enu nzeli arquiꞌ Jesucristo enu nucuaꞌa lu iliu Judea, cuna lu iliu Galilea, cuna lu iliu Samaria, uyuꞌu nú nzuxe arquiꞌbeella, cuna nú nze riꞌilá beella beyaꞌ xa neca inziuꞌ Diose, nu uzucuꞌbeella stichiaꞌnu, nu cuna elietsaꞌ Espíritu Santo nze aca huaxilá bee bene enu nzeli arquiꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Chenu nzebiꞌya Pedro bee bene enu nzeli arquiꞌ Jesucristo, chequie leꞌca uyabiꞌyalla bee bene enu nzeli arquiꞌ Jesucristo enu nucuaꞌa eyeche nú lee Lida. ");
INSERT INTO zplNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Zeꞌe ulañiꞌ Pedro tucu niyu enu riti enu lee Eneas, nu ungala xunu lana nú nuxulla ritilla, nu la tsulílla. ");
INSERT INTO zplNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nu uni Pedro lulla: ―Eneas, Jesucristo neca enu uriꞌiyecala liꞌilu. Uzetee nu uletsa nú ungutalu. Nu hora zeꞌe utsuli Eneas. ");
INSERT INTO zplNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Chenu ulañiꞌ ye bee bene enu nucuaꞌa eyeche nú lee Lida cuna bee bene enu nucuaꞌa enza Sarón nú uyecaꞌlla, che leꞌca uchili arquiꞌ bee bene zeꞌe Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tiembu zeꞌe nzucu tucu unaꞌa enu nzeli arquiꞌ Jesucristo eyeche Jope liꞌilla leella Tabita, nu dialu griego leella Dorcas. Unaꞌa quieꞌ uriꞌilla nú neca nzeꞌca, nu leꞌca uriꞌilla elietsa lubee bene elitsi. ");
INSERT INTO zplNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bee bichia zeꞌe ungariti Dorcas nu ungutilla, nu chenu ulaxu nú ungutsa bee bene liꞌilla uya ricucheꞌe bee bene liꞌilla liñi niꞌi elu aya equie niꞌi zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nu lunú axu eyeche Jope lu eyeche Lida, elu nzucu Pedro, chenu ungabiyaꞌ bee bene enu nzeli arquiꞌ Jesucristo nú nzucu Pedro zeꞌe, uxeꞌla beella chiucu niyu enu uya ziquiee lulla, nu unibeella lulla: ―Uriꞌi faura yexetsia ucha eyeche Jope. ");
INSERT INTO zplNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nu chu nza Pedro cuna liꞌibeella. Chenu uriña beella eyeche Jope, unguyaꞌbeella Pedro liñi niꞌi elu nchiucuꞌ cuerpoꞌ Dorcas, zeꞌe nucuaꞌa bee unaꞌa zaqui runaꞌ beenchu, che uyabica beenchu lu Pedro nu ulubeꞌ beenchu bee laquie nú urecheꞌe Dorcas chenu nehuañiscaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Chequie unibiyaꞌ Pedro nú chiuꞌu ye bee bene eliꞌyaꞌ, nu chu utsulliquilla nu unacuꞌlla lu Diose, nu ubiꞌyalla lu benenguti zeꞌe nu unilla: ―¡Tabita, uzetee! Hora zeꞌe chu uyaꞌla iꞌcululla, nu chenu ulañiꞌlla Pedro, chu uzuculla. ");
INSERT INTO zplNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nu chu unaꞌtse Pedro yalla nu utsulílla, che ubixia Pedro bee bene enu nzeli arquiꞌ Jesucristo, cuna bee unaꞌa zaqui para nú lañiꞌ beella nú uhuañi zeca Dorcas lu eluti. ");
INSERT INTO zplNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nu diqui lu eyeche Jope ungabiyaꞌ bee bene nucuaꞌ, nu huaxi bee bene zeꞌe uyalí arquiꞌ Jesucristo equie cuendaꞌ nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Uyaꞌna Pedro chiucu chuna bichia eyeche zeꞌe, niꞌ tucu bene enu lee Simón enu rcuꞌchi iti. ");
INSERT INTO zplNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Eyeche Cesarea uhuañi tucu bene enu lee Cornelio, liꞌilla ungalla capitañi lu texcuaꞌa bee sundado enu lee Italiano. ");
INSERT INTO zplNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Liꞌilla ungalla tucu bene enu chiquiꞌ unga nzeꞌca arquiꞌ lu Diose, nu cuna ye bee beneꞌlla udeteꞌ beella ulaꞌna lu Diose. Leꞌca uriꞌilla elietsa lubee bene Israel enu seca elitsi, nu siempre rnacuꞌlla lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tucu bichia, tucu rquiechuna uchee, ulleꞌcalla xi neca nú uni xcalaꞌlla. Chee nzeꞌca ulañiꞌlla nú uyuꞌu tucu ángeleꞌ Diose liñi niꞌi elu nzuculla, nu uni ángele zeꞌe lulla: ―¡Cornelio! ");
INSERT INTO zplNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nu ubiꞌyalilla lu ángele zeꞌe nu chiquiꞌ ulliquilla, nu unilla: ―¿Rnilu lua la Detá? Nu uni ángele zeꞌe lulla: ―Diose ubeneꞌlaꞌ stichiaꞌlu, nu ulañiꞌlaꞌnu xa rriꞌilu elietsa lubee bene enu seca elitsi. ");
INSERT INTO zplNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Uxeꞌla bee bene eyeche Jope para nú chetucu beei Simón, enu leꞌca lee Pedro. ");
INSERT INTO zplNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nzuculla niꞌ tucu bene enu leꞌca lee Simón, enu rcuꞌchi iti, nzucu bene quieꞌ ruꞌu inzatuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Chenu nzia ángele enu uni lu Cornelio, ubixialla chiucu mosoꞌlla cuna tucu sundado enu rluꞌculla confianza lu enu nzeli arquiꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Chenu ulaxu nú udixiuleꞌella lunú ulleꞌcalla lubeella, che uxeꞌlalla liꞌibeella eyeche Jope. ");
INSERT INTO zplNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bichia rrucu, diquila nú nzeriña beella axu eyeche Jope, tucu rrebichia uquie Pedro equie niꞌi elu nzuculla para nú nacuꞌlla lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Chiquiꞌ rliaꞌnaꞌlla nu niarquiꞌlla nú aculla, pero diquila nú rriꞌilu bene elubacu nú aculla, che ulleꞌcalla xi neca nú uni xcalaꞌlla, ");
INSERT INTO zplNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","nu ulañiꞌlla nú riaꞌla liñibe nu nzeꞌta laca nú rnaa xi rnaa tucu laquie llene lulla, nu nacaꞌcuu dacu lliꞌi. ");
INSERT INTO zplNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Liñi laquie llene zeꞌe nuꞌ yelu bee nañi enu tacu cuchiuꞌ, cuna bee beꞌla cuna bee nañi enu rcuecuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Chequie ubeneꞌlla tucu chii nú uni lulla: ―Pedro, uzetee, nu uti tatse nañi cuaꞌ aculu. ");
INSERT INTO zplNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nu ucuaqui Pedro nú unilla: ―Aꞌa, Detá, xne leca xunga udacua beenú necha rnaa, cuna beenú la yala acu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Chequie uni zeca chii zeꞌe, stucu bese lulla: ―Lunú uquieela Diose, la hualeelu nucuaꞌ nú necha rnae. ");
INSERT INTO zplNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chenu ulleꞌcalla scua chuna bese, uquie zeca laquie llene zeꞌe liñibe. ");
INSERT INTO zplNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Diquila nú rriꞌi Pedro elliebacuꞌ xinu ulañiꞌlla nucuaꞌ, hora zeꞌe uriña bee bene enu uxeꞌla Cornelio ruꞌu puerta niꞌi Simón, xne unidichiaꞌla beella cá nzucu niꞌ Simón. ");
INSERT INTO zplNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chenu uriñabeella ruꞌu niꞌi zeꞌe, unidichiaꞌ beella tunu zeꞌe nzucu Simón, enu leꞌca lee Pedro. ");
INSERT INTO zplNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Rriꞌiscaꞌ Pedro elliebacuꞌ lunú ulañiꞌlla scua, che uni Espíritu Santo lulla: ―Chuna bene rlaꞌna liꞌilu. ");
INSERT INTO zplNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Utsuli, ulaca, nu uquia cuna liꞌibeella nu la zaꞌ arquiꞌlu, xne liꞌá uxeꞌla liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nu chu ulaca Pedro elu nucuaꞌa bee bene enu uxeꞌla Cornelio, nu unilla lubeella: ―Liꞌá neca enu rlaꞌnahua, ¿xinu rlaꞌnahua liꞌá? ");
INSERT INTO zplNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nu ucuaqui beella: ―Liꞌiru nzelaru lu cuendaꞌ capitañi enu lee Cornelio, enu neca tucu bene nzeꞌca, enu rluꞌcu ulaꞌna lu Diose, nu ye bee bene Israel seca liꞌilla. Tucu ángeleꞌ Diose uni lulla nú uxeꞌlalla liꞌiru para nú nzela tucuꞌru liꞌilu nú chalu niꞌlla para nú yeneꞌlla lunú nilu lulla. ");
INSERT INTO zplNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Che uni Pedro lubeella nú chuꞌu beella liñi niꞌi, nu zeꞌe uyaꞌna beella rulaꞌ zeꞌe. Chenu uyeꞌe luyuu stucu bichia, nzenu Pedro liꞌibeella, nu leꞌca nzenu beella chiucu chuna bee bene enu nzeli arquiꞌ Jesucristo enu neca bene eyeche Jope. ");
INSERT INTO zplNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Chenu uyeꞌe lu yuu stucu bichia uriña beella eyeche Cesarea, elu nzucu Cornelio nu liꞌilla uquieteꞌsaꞌlalla ye bee beneꞌlla cuna bee bene enu chiquiꞌ rquieteꞌlla nucuaꞌaquiee beella nú riña Pedro. ");
INSERT INTO zplNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Chenu uriña Pedro ruꞌu niꞌ Cornelio, chu uchiuꞌu Cornelio nu uya chaꞌcalulla liꞌilla, nu utsulliquilla lu Pedro para nú deteꞌlla ulaꞌna lulla. ");
INSERT INTO zplNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nu utsuli Pedro Cornelio, nu unilla lulla: ―Utsuli, xne necatsia bene tucu nú necalu. ");
INSERT INTO zplNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Diquila nú nze riña beella ruꞌu niꞌlla rdichiaꞌ beella, nu chenu uyuꞌu Pedro liñi niꞌlla ulañiꞌlla nú nucuaꞌa huaxi bee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Chequie uni Pedro lubeella: ―Liꞌihua nediyaꞌhua nú xa neca leyꞌ bee bene Israel la tsanaꞌ leyꞌ beella nú yeteꞌ beella cuna bee bene enu la neca bee bene Israel, niꞌ nú chuꞌu beella liñi niꞌ bee bene zeꞌe. Pero Diose uzeteꞌ liꞌá nú la hualeea nú necha neca lu cuendaꞌ niꞌ tucu bee bene, niꞌ nú riꞌa elliebacuꞌ nú necha neca lu cuendaꞌ beei. ");
INSERT INTO zplNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Enzeꞌe, chenu ubixiahua liꞌá, chu nzela sin nú nia nú la lluꞌcha. ¿Nee, niarquia riꞌá beyaꞌ xi rixiahua liꞌá? ");
INSERT INTO zplNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Che uni Cornelio lulla: ―Necala tucu tacu bichia leꞌca hora quieꞌ, nzucuaꞌa nia sin nú acua equie nú rnacua lu Diose, tucu rquiechuna uche, tuꞌnatsia ulubeꞌlu tucu niyu enu nutu laquie nú rulu siquiꞌ lua. ");
INSERT INTO zplNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nu unilla: “Cornelio, Diose ubeneꞌlaꞌ stichiaꞌlu, nu ulañiꞌlaꞌnu lunú xa rriꞌilu elietsa lubee bene enu seca elitsi. ");
INSERT INTO zplNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Enzeꞌe uxeꞌla bee benea eyeche Jope, chetucu Simón, enu leꞌca lee Pedro. Nzuculla niꞌ tucu bene enu lee Simón, enu rcuꞌchi iti enu nzucu ruꞌu inzatuꞌ. Pedro quieꞌ ni xi riala riꞌilu.” ");
INSERT INTO zplNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Enzeꞌe chu uxeꞌla bee bene enu ubeꞌta tucu liꞌilu, nu uriꞌinzeꞌcalu nú uriñalu. Nu nee nelluaꞌa yeru caꞌa lu Diose liñibe para nú yeneꞌru lunú uxeꞌla Diose liꞌilu nú nilu luru. ");
INSERT INTO zplNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Chequie uquixie Pedro nú unilla: ―Nee, rriꞌá beyaꞌ nú tucutse rriꞌi Diose lu ye bee bene, nu la cañinu bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Xne tatse bee bene iliulabe enu sucuꞌ Stichiaꞌ Diose nu rriꞌilla tucu nú rialane, liꞌinu leꞌca rriꞌi casonu bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diose unila lubee bene Israel, nu udixiuleꞌelanu lubeella nú equie cuendaꞌ Jesucristo luꞌcu beella nú nzuxe arquiꞌbeella, liꞌinu enu rnibiyaꞌ lu ye bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nu liꞌihua nediyaꞌhua nú lulá nú uzeteꞌ Juan Bautista bee bene equie cuendaꞌ elurrinza, che uquixie Jesuse nú uzeteꞌnu bee bene desde Galilea, hasta lubee iliu Judea. ");
INSERT INTO zplNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Liꞌihua nediyaꞌnzeꞌcahua nú udeteꞌla Diose Espíritu Santo cuna poder lu Jesuse Nazaret, cuna nú uyanzenu nu uriꞌinu nú neca nzeꞌca nu uriꞌiyecanu ye bee bene enu nehuana seca lunú rriꞌi bezeꞌlu. Uriꞌinu nucuaꞌ xne nzu Diose cuna liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nu liꞌiru ulañiꞌru lu ye nú uriꞌi Jesuse diqui lu iliu Judea, cuna eyeche Jerusalén. Cheela unguuti bee bene liꞌinu, lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero uriꞌi Diose nú uhuañi zecanu bichia rriuna, nu utsanaꞌ Diose nú ulubeꞌlunu luru. ");
INSERT INTO zplNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Né lubeꞌlunu lu ye bee bene, ulubeꞌlutsianu luru enu ucañila Diose hasta huaꞌtu para nú ulañiꞌru ye nú uriꞌinu. Liꞌiru udaꞌcunuru liꞌinu nu udiyaꞌnuru liꞌinu chenu uhuañi zecanu nú ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Lu zeꞌela uxeꞌla Jesuse liꞌiru para nú dixiuleꞌeru stichiaꞌnu lubee bene, nu uduꞌ Diose liꞌinu para nú hualunue lu cuendaꞌ bee bene chenu deteꞌ beei cuenda lu Diose, sia bee bene enu nehuañi, urre sia bee bene enu unguti. ");
INSERT INTO zplNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Leꞌca hasta huaꞌtu, ye bee profeta uni lu cuendaꞌ Jesuse, nu ye bee bene enu chili arquiꞌ liꞌinu riꞌinu perdona stula beella. ");
INSERT INTO zplNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Rniscaꞌlá Pedro lubee bene zeꞌe, chenu tuꞌnatsia uyucu arquiꞌbeella Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Chequie bee bene Israel enu nzeli arquiꞌ Jesucristo enu uyanu Pedro, chiquiꞌ uyanu arquiꞌbeella xne leꞌcanuu bee bene enu la neca bee bene Israel uyucu arquiꞌbeella Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Xne ubeneꞌbeella nú rni bee bene zeꞌe stucu bee dialu rene, nu rnibeella bedichiaꞌ nzeꞌca lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Chequie uni Pedro lubeella: ―¿Ti cá nú rinza bee benequieꞌ xne uyucula arquiꞌbeella Espíritu Santo tucu nú uyucu arquiaꞌahua Espíritu Santo? ");
INSERT INTO zplNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nu unibiyaꞌ Pedro nú rinza beella lunú lee Jesucristo. Cheelá uziquie beella lu Pedro nú yaꞌnalla cuna liꞌibeella xiucu xuna bichia. ");
INSERT INTO zplNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bee apóstol cuna bee bene Judea enu nzeli arquiꞌ Jesucristo, ubeneꞌbeella nú leꞌca nuu bee bene enu la neca bee bene Israel uchili arquiꞌbeella Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Chequie chenu ubenchilaꞌ Pedro eyeche Jerusalén, bee bene Israel enu nzeli arquiꞌ Jesucristo enu nzequiescaꞌ ley, uquiꞌyaꞌ Pedro uriꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Nu unibeella lu Pedro: ―¿Xinu uyalu niꞌ bee bene enu la neca bee bene Israel, nu udacunulu liꞌibeei? ");
INSERT INTO zplNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Chequie uni Pedro lubeella lu ye nú unga, enzeꞌe uyalla niꞌ bene zeꞌe, nu unilla: ");
INSERT INTO zplNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Chenu nzua eyeche Jope, nu rnacua lu Diose, che ulleꞌca xi neca nú uni xcalaꞌa, nu ulañia nú rnaa xi rnaa tucu laquie llene, nú nzeꞌta laca enza liñibe nu nacaꞌcuu dacu lliꞌi nu uriñae hasta elu nzua. ");
INSERT INTO zplNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Chequie ubiꞌya nzeꞌca xi nuꞌ liñi laquie llene zeꞌe, nu ulañia bee nañi dañi enu nelachi, cuna bee nañi enu nzucu tacu cuchiuꞌ, cuna bee beꞌla cuna bee nañi enu rcuecuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nu ubenea tucu chii nú uni: “Pedro, utsuli, uti tatse bee nañi cuaꞌ aculu.” ");
INSERT INTO zplNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Che ucuaquia: “Aꞌa, Detá, xne leca xunga udacua beenú necha rnaa lunú la yala acu bee bene.” ");
INSERT INTO zplNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nu uni zeca chii zeꞌe lua stucu bese desde liñibe: “Lunú uquieela Diose la hualeelu nucuaꞌ nú necha rnaa.” ");
INSERT INTO zplNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Chenu unga nucuaꞌ chuna bese, che uquie zeca ye bee nucuaꞌ liñibe. ");
INSERT INTO zplNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Leꞌca hora zeꞌe uriña chuna bee niyu elu nzucuaꞌa, nzeꞌta bee bene quieꞌ desde eyeche Cesarea nzeꞌta laꞌna beella liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nu uni Espíritu Santo lua nú chenua liꞌibeella sin nú zaꞌ arquia. Leꞌca uyaꞌnua xuꞌcu bee saꞌahua enu nucuaꞌa caꞌa. Nu yeru uyuꞌuru liñi niꞌi bene zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","chequie uni bene zeꞌe luru nú xa ulubeꞌlu tucu ángeleꞌ Diose lulla niꞌlla, nu uni ángele zeꞌe lulla: “Uxeꞌla bee bene enu cha eyeche Jope para nú chetucu beella Simón enu leꞌca lee Pedro, ");
INSERT INTO zplNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","liꞌilla nilla lulu xa tsilaꞌalu, cuna ye bee bene niꞌlu lu stula beella.” ");
INSERT INTO zplNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Chenu uquixia nú unia lubeella, che uyucu arquiꞌbeella Espíritu Santo, tucu nú ungae chenu uyucu arquiꞌrune. ");
INSERT INTO zplNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Chequie ulluꞌcuꞌ arquia bee stichiaꞌ Jesucristo chenu uninu: “Neli nú urinza Juan bee bene cuna inza, pero liꞌihua rinzahua cuna Espíritu Santo.” ");
INSERT INTO zplNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nu nee nú uxeꞌla Diose Espíritu Santo nú uyucu arquiꞌ beella tucu nú uyucu arquiaꞌahua chenu uyalí arquiaꞌahua Jesucristo, ¿enzeꞌe ti necaa para nú cáa lunú rriꞌi Diose? ");
INSERT INTO zplNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chenu ubeneꞌ bee bene Jerusalén bedichiaꞌ cuaꞌ, che né niaꞌ beella lu Pedro, nu unibeella bedichiaꞌ nzeꞌca lu Diose, nú unibeella: ―¡Nee nediyaꞌahua nú leꞌca nuu bee bene enu la neca bee bene Israel udeteꞌ Diose nú cheꞌe arquiꞌbeella equie cuendaꞌ stula beella nu luꞌcu beella elunehuañi nú leca xunga laxu lu Diose! ");
INSERT INTO zplNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Lulá nú unguuti bee bene Esteban, che uquixiebeei nú rtiliacaꞌ beei bee bene enu nzeli arquiꞌ Jesucristo, nu uriꞌchia letse bee beneꞌnu enza Fenicia, cuna enza Chipre cuna enza Antioquía. Nu zeꞌe udixiuleꞌe beella bedichiaꞌ nzeꞌcaꞌ Jesucristo lubee bene Israel tsia. ");
INSERT INTO zplNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero leta beella nchiñi chiucu chuna bee bene eyeche Chipre cuna bene eyeche Cirene, chenu uriña bee benequieꞌ eyeche Antioquía udixiuleꞌe beella bedichiaꞌ nzeꞌcaꞌ Jesucristo lubee bene enu la neca bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Diose uriꞌi elietsa lubeella, che huaxi bee bene uyalí arquiꞌ lunú rnibeella, nu uyalí arquiꞌbeella Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Chenu ungabiyaꞌ bee bene enu nzeli arquiꞌ Jesucristo eyeche Jerusalén nucuaꞌ, uxeꞌla beella Bernabé hasta eyeche Antioquía. ");
INSERT INTO zplNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Chenu uriñalla zeꞌe, chiquiꞌ ñia utsu arquiꞌlla chenu ulañiꞌlla nú xa rriꞌi Diose elietsa lubee bene zeꞌe. Chequie unilla bezeteꞌ lubeella nu diquinuꞌ arquiꞌbeella chequiee beella stichiaꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé unga tucu bene nzeꞌca, chiquiꞌ uriꞌi Espíritu Santo elietsa lulla nu neli nzeli arquiꞌlla Jesucristo. Enzeꞌe huaxi bee bene uyalí arquiꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lu zeꞌelá uya Bernabé eyeche Tarso nzecuaꞌnalla Saulo, nu chenu ullelaꞌlla Saulo che unguyaꞌlla liꞌilla eyeche Antioquía. ");
INSERT INTO zplNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Zeꞌe ucuaꞌa beella tucu lana cuna bee bene enu nzeli arquiꞌ Jesucristo, nu uzeteꞌ beella huaxi bee bene. Nu eyeche Antioquía neca elu uquixie nú uhualee bee bene cristiano bee bene enu nzeli arquiꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Bee bichia zeꞌe chiucu chuna bee profeta enu rni Stichiaꞌ Diose uchiuꞌu beella eyeche Jerusalén para nú nzuebeella eyeche Antioquía. ");
INSERT INTO zplNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tucu beella enu lee Agabo, utsulílla lubee bene, nu equie cuendaꞌ Espíritu Santo unilla nú aca biña diqui lu iliulabe, nu scua ungae lana nú unibiyaꞌ arre Claudio. ");
INSERT INTO zplNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Chequie bee bene enu nzeli arquiꞌ Jesucristo enu nucuaꞌa eyeche Antioquía, unibeella nú quieteꞌsaꞌbeella dimi calutse nú nuꞌ modo deteꞌ cada tucua beella para nú riꞌi beella elietsa lubee saꞌbeella enu nzeli arquiꞌ Jesucristo enu nucuaꞌa lu iliu Judea. ");
INSERT INTO zplNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nu scua uriꞌibeella, che uxeꞌla beella dimi zeꞌe cuna Saulo cuna Bernabé para nú deteꞌ beella dimi zeꞌe ya bee bene enu rnibiyaꞌ lubee bene enu nzeli arquiꞌ Jesucristo, lu iliu Judea. ");
INSERT INTO zplNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Bee bichia zeꞌe uquixie arre Herodes nú uriꞌilla nú nehuana ulleꞌca chiucu chuna bee bene enu nzeli arquiꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nu unibiyaꞌlla nú unguti Jacobo bichi Juan cuna espada. ");
INSERT INTO zplNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nu chenu ulañiꞌ Herodes nú riuꞌ arquiꞌ bee bene Israel lunú uriꞌilla, che unibiyaꞌlla nú unaꞌtse bee bene Pedro. Nucuaꞌ unga bee bichia liñi nú racu bee bene Israel pá nú la nucha levadura. ");
INSERT INTO zplNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Chenu unaꞌtse bee bene Pedro nu uduꞌ beei liꞌilla niꞌcuꞌ. Che unibiyaꞌ arre Herodes lu tacu texcuaꞌa bee sundado para nú riꞌi ucu beei ruꞌu niꞌcuꞌ, cada texcuaꞌa bee sundado zeꞌe neca tacu beei. Xne uriꞌilla elliebacuꞌ nú deteꞌlla Pedro lubee bene eyeche zeꞌe chenu dete eliñi baxcu. ");
INSERT INTO zplNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Enzeꞌe uriꞌi ucu beei Pedro chenu nchiñilla niꞌcuꞌ, pero ye bee bene enu nzeli arquiꞌ Jesucristo la tsuxe beella nú siquiee beella, cuna nú rnacuꞌ beella lu Diose equie cuendaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Leꞌca rulaꞌ zeꞌe chenu uyeꞌe luyuu stucu bichia para nú lubeꞌ Herodes Pedro lubee bene eyeche zeꞌe, raꞌtse Pedro nuxu labe chiucu bee sundado, nu nacaꞌculla cuna chiucu cadena, nu texcuaꞌa bee sundado rriucu ruꞌu niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nu tuꞌnatsia uriña tucu ángeleꞌ Diose nu uyuꞌullieꞌe liñi niꞌcuꞌ. Nu chu ucuñi ángele zeꞌe cueꞌtse Pedro para nú huañilla, nu uni ángele zeꞌe lulla: ―Yexetsia uzetee. Hora zeꞌe uzanaꞌ cadena nú nacaꞌcuu ya Pedro. ");
INSERT INTO zplNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nu uni ángele zeꞌe lulla: ―Ulliꞌcacuutaꞌ xlaꞌculu nu uquieꞌe luculu. Chenu uriꞌi Pedro scua, che uni ángele zeꞌe lulla: ―Uꞌtuꞌ capaꞌlu nu utequiee liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nu chu uchiuꞌu Pedro nzequiee ángele zeꞌe, pero la riꞌilla beyaꞌ tunu neli nú rriꞌi ángele zeꞌe. Xne secalla nú rnitsia xcalaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nu udete beella lu texcuaꞌa bee sundado, cheelá udete beella lu texcuaꞌa bee sundado, chenu uriñabeella ruꞌu puerta niꞌcuꞌ para nú chiuꞌu beella ruꞌu inziu, eꞌcu puerta zeꞌe uyaꞌlane. Nu uchiuꞌu beella, nu chenu uriñabeella squiña inziu zeꞌe, zeꞌe utsanaꞌ arquiꞌ ángele zeꞌe Pedro. ");
INSERT INTO zplNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Chequie uriꞌilla beyaꞌ nú neli lunú secalla scua, nu unilla: ―Nee nediyaa nú uxeꞌla Diose ángeleꞌnu para nú utsilaꞌanu liꞌá lu Herodes, cuna lu ye nú niarquiꞌ bee bene Israel riꞌinu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Chenu uriꞌi Pedro beyaꞌ nú necane scua, che chu nzalla niꞌ María, naꞌ Juan, enu leꞌca lee Marcos, elu nucuaꞌa huaxi bee bene neyeteꞌ saꞌ rnacuꞌ lu Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Chenu uchichi Pedro ruꞌu puerta, che uchiuꞌu tucu unaꞌa eꞌne enu lee Rode para nú nzebiꞌyanchu ti enu xichi zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pero chenu uyulunchu chi Pedro, chiquiꞌ ñia utsu arquiꞌnchu, che luhuare nú xaꞌlanchu ruꞌu puerta chuꞌulla aꞌla uyecaxuꞌunchu uya tixiuleꞌenchu nú Pedro nzu ruꞌu puerta. ");
INSERT INTO zplNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nu uni bee bene zeꞌe lunchu: ―¡Ichia lucu secalu! Pero chiuca utsutaꞌ Rode nú neli nú necalla Pedro. Nu uni beella lunchu: ―Laca liꞌilla, talabese neca nucuaꞌ ángele enu rriꞌi elietsa lulla. ");
INSERT INTO zplNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pero chu xichila Pedro ruꞌu puerta, chequie chenu uxaꞌla beella ruꞌu puerta, hasta ulliqui beella chenu ulañiꞌbeella liꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nu uriꞌi Pedro seña lubeella nú zaca beella, che udixiuleꞌella nú xa uhua Diose liꞌilla niꞌcuꞌ, nu unilla lubeella: ―Scua udixiuleꞌehua lu Jacobo, cuna lu ye bee bene enu nzeli arquiꞌ Jesucristo. Cheelá uchiuꞌulla nu nzalla stucu luhuare. ");
INSERT INTO zplNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Chenu uyeꞌe luyuu, niꞌ la riꞌi bee sundado beyaꞌ xa riꞌibeei xne né acabiyaꞌ beei xa uchiuꞌu Pedro niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Chequie unibiyaꞌ Herodes nú checuaꞌna bee sundado Pedro, pero ne llelaꞌ beei liꞌilla. Chenu ulaxu nú unidichiaꞌ Herodes lubee sundado xa unga nú uchiuꞌu Pedro niꞌcuꞌ, unibiyaꞌlla nú ati bee sundado zeꞌe. Che uchiuꞌu Herodes Judea nu nzalla eyeche Cesarea zuculla. ");
INSERT INTO zplNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ulee Herodes lubee bene eyeche Tiro cuna lubee bene eyeche Sidón, pero unga tucu necatse bee bene zeꞌe para nú che nibeei lulla. Nu chenu uriꞌibeei ana nú rquieteꞌ beei bene enu lee Blasto, tucu beneꞌ arre Herodes, che uni Blasto zeꞌe lu cuendaꞌ beei lu arre Herodes nú la riaꞌlla xu cuna liꞌibeei, xne liꞌilla rnibiyaꞌlla diqui bee luhuare elu nzeꞌta bee elubacu nú racubeei. ");
INSERT INTO zplNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Chequie utsaꞌna Herodes tucu bichia nú bedichiaꞌnulla liꞌibeei, chenu uriña bichia zeꞌe ungutulla xucu fiñulla, nu uzuculla lu xleta elu rnibiyaꞌlla nu uquixiella nú unilla lubeei. ");
INSERT INTO zplNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Che uquixie bee bene zeꞌe nú urixialibeei nú unibeei: ―¡Tucu diose neca enu rni, nu la ni tucu bene! ");
INSERT INTO zplNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hora zeꞌe uriꞌi tucu ángeleꞌ Diose nú unga riti Herodes, udacu bee berecuꞌ liꞌilla nu ungutilla. Xne uyuꞌu arquiꞌ Herodes nú zucuꞌ ayaa bee bene liꞌilla, luhuare nú zucuꞌ ayaalla Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pero Stichiaꞌ Diose chu nze riꞌchia letsela diqui bee luhuare, nu diqui bee luhuare chu nze dalalá bee bene enu nzeli arquiꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Chequie chenu ulaꞌxu Bernabé cuna Saulo lunú riala riꞌibeella eyeche Jerusalén, ubenchilaꞌ beella eyeche Antioquía cuna Juan, enu leꞌca lee Marcos. ");
INSERT INTO zplNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Leta beneꞌ Jesucristo enu nucuaꞌa eyeche Antioquía nucuaꞌa bee profeta, cuna bee ulaxcuela enu udixiuleꞌe Stichiaꞌ Diose. Leta beella nzu Bernabé, Simón (enu leꞌca lee enu natsa), cuna Lucio enu neca bene eyeche Cirene, cuna Saulo cuna Manaén (enu tucutse uruꞌcunu arre Herodes enu unibiyaꞌ Galilea). ");
INSERT INTO zplNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tucu bichia nú né acu beella diqui nú rnacuꞌ beella lu Diose, che uni Espíritu Santo lubeella: ―Ucañihua Bernabé cuna Saulo para nú riꞌibeella riñaꞌ nú niarquia nú riꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Chenu ulaxu nú udeteꞌbeella bichia nú la acu beella, diqui nú rnacuꞌ beella lu Diose, chu uricuꞌ beella ya beella equie Bernabé cuna Saulo para nú riꞌi Diose elietsa lubeella, nu uni bee bene zeꞌe lubeella chenu nziue beella. ");
INSERT INTO zplNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Che uxeꞌla Espíritu Santo Bernabé cuna Saulo lu eyeche nú lee Seleucia. Nu zeꞌe uyuꞌu beella liñi barco nu nzuella luyuu nú lee chipre nú netse lu inzatuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Chenu uriña beella lu iliu Chipre, chequie eyeche Salomina uquiexie beella nú rixiuleꞌe beella Stichiaꞌ Diose liñi induꞌ bee bene Israel enu nucuaꞌa zeꞌe, leꞌca unguyaꞌ beella Juan para nú riꞌilla elietsa lubeella. ");
INSERT INTO zplNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Chenu nzuebeella diqui lu iliu Chipre, che uriña beella eyeche nú lee Pafos, eyeche zeꞌe uchuꞌu beella tucu bene Israel enu lee Barjesus, liꞌilla necalla tucu uliñi nu sequienulla bee bene nu rnilla nú necalla tucu profetaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Barjesus quieꞌ neca beneꞌ Sergio Paulo enu neca gobernador lu iliu Chipre, nu chiquiꞌ recalla. Unibiyaꞌlla nú yeꞌta Bernabé cuna Saulo, xne niarquiꞌlla nu yeneꞌlla Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero uliñi quieꞌ dialu griego leella Elimas, niarquiꞌlla nú cálla nú chili arquiꞌ Sergio Paulo Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Chequie Saulo enu leꞌca lee Pablo, chiquiꞌ nzu Espíritu Santo cuna liꞌilla, nu ubiꞌyalílla lu Elimas, ");
INSERT INTO zplNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nu uni Pablo lu Elimas: ―¡Lliꞌñi bezeꞌlu lee, puro eluquichiaꞌ rnilu, nu puro lunú necha neca rriꞌilu, niꞌ tucu nú neca nzeꞌca la yuꞌ arquiꞌlu! ¿Hasta xunga tsanaꞌlu nú chequiee bee bene inziuꞌ Diose nú neli neca? ");
INSERT INTO zplNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nee deteꞌ Diose castiya liꞌilu nu quieꞌ lulu, nu la biꞌyaꞌlu ellieꞌe bichia tucu tiembu. Hora zeꞌe ucabelí lu Elimas nu la biyaꞌilla nu rlaꞌnalla enu naꞌtse yalla, xne la biꞌyaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Chenu ulañiꞌ gobernador Sergio Paulo nucuaꞌ, uchili arquiꞌlla stichiaꞌ Jesucristo. Nu chiquiꞌ uyanuu arquiꞌlla equie cuendaꞌ stichiaꞌ Jesucristo nú seteꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Chequie Pablo cuna bee bene enu nuulla uyuꞌu beella liñi barco eyeche Pafos nu nzuebeella enza lu eyeche Perge nú nchiucuꞌ lu iliu Panfilia. Zeꞌe utsaꞌna Juan Marcos liꞌibeella nu ubenchilaꞌlla eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lu zeꞌelá uchiuꞌu beella eyeche nú lee Perge nu nzuebeella eyeche Antioquía nú nchiucu lu iliu Pisidia. Chenu uriña bichia nú sulachi bee bene Israel, uyuꞌu beella liñi induꞌ beei nu chu uzucu beella liñi indu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Chequie chenu ulaxu nú ungula bene lu ichiꞌ nú uquieꞌe Moisés cuna beenú uquieꞌe bee profeta, bee bene enu rnibiyaꞌ liñi indu zeꞌe unibeei lu Pablo cuna lu Bernabé: ―Tunu nuꞌ nú niarquiꞌhua nihua para nú nihua bezeteꞌ lubee bene nuꞌ modo nihuane nee. ");
INSERT INTO zplNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Che utsuli Pablo nu uriꞌilla seña lubeella nú zaca beella, nu unilla lubeella: ―Bee bene Israel, cuna yehua bee enu rcuaꞌna nú huañi tucu nú niarquiꞌ Diose, uquieꞌe diacahua nú nia luhua. ");
INSERT INTO zplNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dioseꞌahua liaꞌahua enu neca bee bene Israel, liꞌinu ucañinu bee beneꞌahua enu udetela, nu uriꞌinu nú udala beella nu unga huaxi beella chenu ucuaꞌa beella xi neca bee bene rene Egipto, chequie cuna poderꞌnu uhuanu liꞌibeella Egipto. ");
INSERT INTO zplNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nu uriquiꞌ Diose liꞌibeella lunú uriꞌibeella diqui chiuꞌa lana chenu ucuaꞌa beella lu dañi achi, ");
INSERT INTO zplNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","nu unitilu Diose achi bee nación nú uricu lu iliu Canaán para nú udeteꞌnu yuu zeꞌe lubee beneꞌahua enu udetela. ");
INSERT INTO zplNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nucuaꞌ unga diqui tacu ayuꞌu arulaꞌ lana, cheelá uduꞌ Diose bee juece para nú nibiyaꞌ lubeella. Nu profeta Samuel unga último juece lubeella. ");
INSERT INTO zplNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Cheelá unacuꞌ beella nú chuꞌu tucu arre enu nibiyaꞌ lubeella, che ucañi Diose arre Saul para nú nibiyaꞌ lubeella diqui chiuꞌa lana, liꞌilla ungalla llianaꞌ bene enu lee Cis, enu nzeꞌta leta familiꞌ Benjamin. ");
INSERT INTO zplNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nu chenu unguti arre Saúl, che ucañi Diose arre David, nu uninu: “Ulañilá nú David, llianaꞌ Isaí nehuañilla tucu nú niarquia, nu liꞌilla riꞌilla lu ye nú niarquia nú riꞌilla.” ");
INSERT INTO zplNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nu nee, tucu nú uni Diose nú leꞌca leta bee familiꞌ arre David quieꞌ uchiuꞌu Jesuse enu uxeꞌla Diose para nú tsilaꞌanu bee bene Israel lu cuendaꞌ stula beella. ");
INSERT INTO zplNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ante nú riña Jesuse, udixiuleꞌe Juan Bautista lu ye bee bene Israel nú rquiꞌña nú cheꞌe arquiꞌbeei lu stula beei, nu rinza beei. ");
INSERT INTO zplNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nu chenu nzeꞌta axula nú ati Juan, unilla: “La necá Cristo tucu nú nzeli arquiꞌhua. Pero chenu riñanu niꞌ lucunu la yala nú hua xne máse neca equienu luquela liꞌá.” ");
INSERT INTO zplNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Nee yeꞌahua enu nzelaꞌahua lubee familiꞌ Abraham, cuna yehua enu rcuaꞌna nú huañihua tucu nú niarquiꞌ Diose para liaꞌahua neca stichiaꞌnu nú rixiuleꞌe nú xa tsilaꞌa Jesucristo liaꞌahua lu cuendaꞌ dula. ");
INSERT INTO zplNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Pero bee bene eyeche Jerusalén cuna bee usticiaꞌ beella lá chulubeella Jesucristo tucu nú riala nú chulu beella liꞌinu nu leꞌca la riꞌibeella beyaꞌ xi rni Stichiaꞌ Diose nú uquieꞌe bee profeta nú rula beella liñi indu bichia nú sulachi beella nu leꞌca liꞌibeella unguti beella Jesucristo. Nu scua uyalu tucu nú niquie lu ichiꞌ Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Añinzuca nú lecaxi equiya uluꞌcu Jesucristo, pero uniteꞌca beei lu Pilato nú unibiyaꞌlla nú ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Chenu ulaxu luye nú uriꞌinubeella liꞌinu tucu nú nequiee lu ichiꞌ Stichiaꞌ Diose equie cuendaꞌnu. Che uya bee bene enu ulaca cuerpoꞌnu lu cruse nu uyacaꞌchiꞌ beella cuerpoꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero uriꞌi Diose nú uhuañi zecanu. ");
INSERT INTO zplNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nu huaxi bee bichia ulubeꞌlunu lubee bene enu uyanzenu liꞌinu chenu uchiuꞌunu Galilea nu nzanu Jerusalén, nu nee neca bee bene zeꞌe enu rixiuleꞌe equie cuendaꞌnu lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Enzeꞌe, liꞌiru leꞌca rixiuleꞌeru bedichiaꞌ nzeꞌca cuaꞌ luhua tucu nú ucuaqui uꞌna Diose lubee beneꞌahua enu udetela. ");
INSERT INTO zplNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Liꞌinu utsaꞌalulanu nucuaꞌ luaꞌahua nu nzelaꞌahua leta familiꞌ beella, utsaꞌalunu stichiaꞌnu chenu uhuañi zeca Jesuse, tucu nú niquie lu salmo rrucu elu rni: “Liꞌilu necalu Lliꞌñia nu desde nee rluꞌculu nú rnibiyaꞌlu tucu nú rnibiyaꞌa.” ");
INSERT INTO zplNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Diose uni nú riꞌinu nú huañi zeca Jesucristo, nu lecaꞌ xunga atinu tucu nú niquie lu ichiꞌ Stichiaꞌ Diose elu rni: “Liꞌá riꞌá nú cha nzeꞌca lu cuendaꞌhua tucu nú ucuaqui uꞌnaa lu David.” ");
INSERT INTO zplNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nu leꞌca nuꞌ stucu parte lu ichiꞌ stichiaꞌa elu rni: “Liꞌilu la tsanaꞌlu nú uchu cuerpoꞌ Lliꞌñilu enu la luꞌcu dula.” ");
INSERT INTO zplNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nee, bedichiaꞌ quieꞌ la nine equie cuendaꞌ David, xne chenu ulaxu nú unibiyaꞌlla lubee saꞌlla tucu nú uni Diose lulla nú nibiyaꞌlla tiembu zeꞌe, chequie ungutilla nu uhuachiꞌlla nu unguchuꞌ cuerpoꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero cuerpoꞌ Jesucristo enu uriꞌi Diose nú uhuañi zeca, lá uchu cuerpoꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Enzeꞌe bee saꞌa, rixiuleꞌeru luhua para nú riꞌihua beyaꞌ nú equie cuendaꞌ liꞌinu nuꞌ nú rriꞌi Diose perdona stulaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ye bee bene enu nzeli arquiꞌ Jesucristo neca perdonala ye stula beella nú leca modo nú aca perdona, añinzuca nú uriꞌibeella tucu nú rnibiyaꞌ ley nú udeteꞌ Diose lu Moisés. ");
INSERT INTO zplNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Enzeꞌe ubiꞌyahua liꞌihua para nú la zecahua tucu nú uquieꞌe bee profeta, chenu uquieꞌe beella nú unibeella: ");
INSERT INTO zplNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Uzuꞌcuꞌ diacahua liꞌihua enu sequichiaꞌ stichiaꞌa. Uyanu arquiꞌhua nú unitiluhua, xne bee bichia nú nehuañihua riꞌá beenu hasta liꞌihua la chili arquiꞌhua, añinzuca nú nuꞌ bee enu, ixiuleꞌe bee nucuaꞌ luhua. ");
INSERT INTO zplNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Chenu uchiuꞌu Pablo cuna Bernabé liñi induꞌ bee bene Israel zeꞌe, nu bee bene enu la neca bee bene Israel uziquiee beei lu Pablo para nú chenu riña zeca bichia nú sulachi bee bene Israel cha zecalla ixiuleꞌella tucu nú unilla lubeei bichia zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Chenu uchiuꞌu bee bene liñi indu zeꞌe huaxi beella uyaquie Pablo cuna Bernabé, sianu neca beella bee bene Israel urre bee bene rene enu rluꞌcu ulaꞌna lu Diose, tucu nú rluꞌcu bee bene Israel ulaꞌna lu Diose. Nu uni Pablo cuna Bernabé lubeella nú tsútaꞌ arquiꞌbeella lunú nziquie beella inziuꞌ Diose liꞌinu enu seca liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Chenu ulaxu xmana, bichia nú sulachi bee bene Israel, casi ye bee bene eyeche zeꞌe uyetesaꞌbeei para nú ubeneꞌ beei Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero chenu ulañiꞌ bee bene Israel bee beneañi enu neyeteꞌsaꞌ zeꞌe, chequie uyee arquiꞌbeei nu uquixiebeei nú seꞌta beei nú rnibeei bedichiaꞌ nú necha neca lu Pablo. ");
INSERT INTO zplNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Chequie sin nú lliqui Pablo cuna Bernabé ucuaqui beella lubeei nú unibeella: ―Rlutilá luhua riala nú dixiuleꞌeru bedichiaꞌ nzeꞌcaꞌ Diose, liꞌihua enu neca bee bene Israel, pero nee la niarquiꞌhua nú yeneꞌhuane, chequie leꞌcatsia liꞌihua rriꞌihua nú la yalahua elu nehuañi nú leca xunga laxu lu Diose. Nu nee nze tixiuleꞌeru bedichiaꞌ nzeꞌca cuaꞌ lubee bene enu la neca bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Xne scua unibiyaꞌ paꞌru Diose chenu uninu tucu parte lu stichiaꞌnu elu rni: Uduꞌa liꞌilu xi neca ellieꞌe lubee bene enu la neca bee bene Israel, para nú chetixiuleꞌelu lu ye bee bene iliulabe nú xa tsilaꞌa beella. ");
INSERT INTO zplNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chenu ubeneꞌ bee bene enu la neca bee bene Israel nucuaꞌ, che chiquiꞌ ñia utsu arquiꞌbeei nu uquixiebeei unibeei nú neca nzeꞌca bedichiaꞌ nzeꞌcaꞌ Diose. Nu ye bee bene enu riala elunehuañi nú leca xunga laxu lu Diose uchili arquiꞌbeella stichiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Scua ungabiyaꞌ bee bene Stichiaꞌ Diose diqui lubee iliu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero bee bene Israel uduꞌ beei arquiꞌ bee unaꞌa enu siempre se indu nu neca equie beella eyeche zeꞌe, cuna lubee niyu enu neca equie para nú utiliacaꞌ beei Pablo cuna Bernabé hasta nú uhuabeei liꞌibeella lu iliu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nu chu uriꞌqui Pablo cuna Bernabé yu beꞌchaꞌ cuchiuꞌ beella xi neca seña nú ne zucuꞌ bee bene zeꞌe stichiaꞌ beella, nu chu nzuebeella eyeche nú lee Iconio. ");
INSERT INTO zplNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero bee bene enu uyalí arquiꞌ Jesucristo chiquiꞌ ñia nzu arquiꞌbeella nu chiquiꞌ nzu Espíritu Santo cuna liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Chenu nzucu Pablo cuna Bernabé eyeche Iconio, uya beella liñi induꞌ bee bene Israel, nu uzeteꞌ beella bedichiaꞌ nzeꞌcaꞌ Jesucristo lubee bene nu huaxi bee bene uyalí arquiꞌ liꞌinu, masia nú neca beei bee bene Israel, urre la neca beei bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero bee bene Israel enu la chili arquiꞌ liꞌinu, uduꞌ beei arquiꞌ bee bene enu la neca bee bene Israel para nú uquixiebeei nú uriꞌibeei elliebacuꞌ nú necha neca lubee bene enu nzeli arquiꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pero añinzuca nú ungae scua uyaꞌna bee apóstol zeꞌe huaxi tiembu. Nu sin nú lliqui beella udixiuleꞌe beella stichiaꞌ Jesucristo xne nzeli arquiꞌbeella liꞌinu, nu liꞌinu udeteꞌnu poder lubeella nú uriꞌibeella huaxi bee milagro cuna beelá beenú uriꞌibeella para nú lañiꞌ bee bene nú neli nú rnibeella lunú neca cuendaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pero bee bene eyeche zeꞌe uleꞌe saꞌbeei nu unga chiucu texcuaꞌa beei, texcuaꞌa beei nzu chuꞌ bee bene Israel nu texcuaꞌa beei nzu chuꞌ bee apóstol. ");
INSERT INTO zplNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Chequie sia bee bene Israel urre sia bee bene enu la neca bee bene Israel unga tucu necatse beei cuna bee usticia para nú quiexu beei Pablo cuna Bernabé nu duꞌ beei quie liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero chenu uriꞌi Pablo cuna Bernabé beyaꞌ nucuaꞌ, chu nzuebeella eyeche Listra cuna eyeche Derbe, nú nchiucuꞌ lu iliu Licaonia, cuna lubeelá bee eyeche nú nchiucuꞌ enza zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","uyatixiuleꞌe beella bedichiaꞌ nzeꞌcaꞌ Jesucristo lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lu eyeche Listra uhuañi tucu niyu enu laca tse nu leca xunga utsella xne necuxulla desde nú ungulalla nu nzuculla zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","rieneꞌlla lunú rni Pablo, chenu ulañiꞌ Pablo liꞌilla ulañiꞌ Pablo nú nzeli arquiꞌlla para nú yecaꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nu juerte uni Pablo lulla: ―¡Utsuli nu neli utsu! Hora zeꞌe utetsalla nu utsulílla nu uquixie seella. ");
INSERT INTO zplNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Chenu ulañiꞌ bee bene lunú uriꞌi Pablo, uquixiebeei nú rixiali beei cuna dialu Licaonia nú unibeei: ―¡Bee diose enu neca xi neca bene ulaca elu nelluaꞌahua! ");
INSERT INTO zplNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nu unibeei nú Bernabé neca diose Jupiter nu Pablo neca diose Mercurio, xne liꞌilla neca enu rni lubeei. ");
INSERT INTO zplNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nu ruꞌu eyeche zeꞌe elu riuꞌu bee bene nzucu induꞌ diose Jupiter. Chequie uleꞌya enu nzucu indu zeꞌe uyayulla bee uꞌnaꞌ cuna bee quiee lu Pablo cuna lu Bernabé. Nu uleꞌya zeꞌe cuna ye bee bene enu nuulla uniarquiꞌbeella nú úti beella bee uꞌnaꞌ zeꞌe para nú deteꞌ beella ulaꞌna lubee apóstol. ");
INSERT INTO zplNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero chenu uriꞌi Pablo cuna Bernabé beyaꞌ nucuaꞌ, chu utsa beella xucu beella nu uyuꞌu xuꞌu beella leta bee bene zeꞌe nu rixiali beella nú unibeella: ");
INSERT INTO zplNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Uzuꞌcuꞌ diacahua! ¿Xinu rriꞌihua scua? Liꞌiru necaru bene tucu nú necahua. Nu nucuaꞌtsia nzelaru para nú niru luhua nú tsanaꞌ arquiꞌhua lunú rriꞌihua xne lecaxi zibiꞌ bee nucuaꞌ. Mejora uchili arquiꞌhua Diose enu nehuañi, enu urecheꞌ liñibe cuna iliulabe cuna inzatuꞌ cuna ye beenú nuꞌ lubee. ");
INSERT INTO zplNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Huaꞌtu utsanaꞌ Diose nú uriꞌi bee bene tucu nú niarquiꞌtsia beei, ");
INSERT INTO zplNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","pero añinzuca nú necane scua, leca xunga utsacuꞌ arquiꞌ Diose lunú ti necanu equie beenú neca nzeꞌca rriꞌinu. Xne liꞌinu necanu enu rliquiꞌ quiu cuna bee ulaꞌcu nu leꞌca liꞌinu rliquiꞌnu nu rdaꞌcuaꞌahua para nú ñia tsu arquiaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Chenu uni Pablo cuna Bernabé scua lubeella, chiquiꞌ neriñaꞌ uriꞌibeella ana lubee bene zeꞌe nú ne uti bee bene zeꞌe uꞌnaꞌ xi neca uꞌna lubeella para nú aluꞌcu beei ulaꞌna lubeella. ");
INSERT INTO zplNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pero chiucu chuna bee bene Israel enu nucuaꞌa eyeche Antioquía cuna eyeche Iconio, chenu uriña beei eyeche Listra uriꞌibeei ana uduꞌ beei arquiꞌ bee bene eyeche zeꞌe. Chequie uduꞌ beei quiee Pablo nu uriꞌibeei elliebacuꞌ nú ungutila Pablo nu uya xaꞌ beei liꞌilla nu uhuabeei liꞌilla hasta ruꞌu eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero chenu uyetesaꞌ bee bene enu nzeli arquiꞌ Jesucristo abenchilaꞌ elu nuxu Pablo, che udeteꞌlla ellieꞌe nu utsulílla nu uyuꞌu zecalla eyeche zeꞌe. Nu stucu bichia uchiuꞌlla cuna Bernabé nu nzuebeella eyeche Derbe. ");
INSERT INTO zplNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Chenu ulaxu nú udixiuleꞌe beella stichiaꞌ Jesucristo eyeche Derbe elu huaxi bee bene uyalí arquiꞌ Jesucristo, che ubenchilaꞌ zeca beella eyeche Listra cuna eyeche Iconio cuna eyeche Antioquía. ");
INSERT INTO zplNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bee eyeche cuaꞌ uduꞌ beella ana arquiꞌ bee bene enu nzeli arquiꞌ Jesucristo, nu unibeella lubee bene zeꞌe nú tsutaꞌ arquiꞌbeella lunú nzeli arquiꞌbeella liꞌinu, xne chiquiꞌ nehuana zeca bee bene para nú chuꞌu bee bene elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nu leꞌca cada tucua bee eyeche zeꞌe ucañi beella tucu bene enu nibiyaꞌ lubee bene enu nzeli arquiꞌ Jesucristo, nu chenu ulaxu nú udeteꞌbeella bichia nú la acu beella equie nú rluꞌcu beella ulaꞌna lu Diose, cuna nú unacuꞌ beella lunu nu chu utsaꞌna beella liꞌibeella ya Jesucristo enu nzeli arquiꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Chenu udete Pablo cuna Bernabé lu iliu Pisidia, uriña beella lu iliu Panfilia. ");
INSERT INTO zplNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Chequie udixiuleꞌe beella Stichiaꞌ Diose eyeche Perge. Nu nzuebeella lu eyeche Atalia. ");
INSERT INTO zplNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Zeꞌe uyuꞌu beella liñi barco para nú nzuebeella eyeche Antioquía zeꞌe utsaꞌna beelá bee bene enu nzeli arquiꞌ Jesucristo liꞌibeella ya Diose para nú riꞌinu elietsa lubeella nú chetixiuleꞌe beella stichiaꞌnu. Nu riñaꞌ cuaꞌ neca nú ulaꞌxu beella rriꞌibeella nee. ");
INSERT INTO zplNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Chenu uriñabeella eyeche Antioquía, uquieteꞌsaꞌ beella bee bene enu nzeli arquiꞌ Jesucristo nu unibeella lubee bene zeꞌe lu ye nú uriꞌi Diose cuna liꞌibeella, cuna nú uriꞌinu elietsa nú nzeli arquiꞌ bee bene enu la neca bee bene Israel Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Zeꞌe uyaꞌna Pablo cuna Bernabé huaxi tiembu nu ucuaꞌa beella cuna bee bene enu nzeli arquiꞌ Jesucristo eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bee bichia zeꞌe uriña chiucu chuna bee bene Judea eyeche Antioquía. Nu uquixiebeei unibeei lubee bene enu nzeli arquiꞌ Jesucristo nú tunu la quie seña liꞌibeella tucu nú rnibiyaꞌ leyꞌ Moisés leca modo tsilaꞌa beella lu cuendaꞌ stula beella. ");
INSERT INTO zplNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Chequie Pablo cuna Bernabé chiquiꞌ unixuu beella cuna bee benecuaꞌ, luzeꞌelá ucañi bee bene enu nzeli arquiꞌ Jesucristo Pablo cuna Bernabé cuna xiucu xuna bee bene para nú uya beella Jerusalén, uya niꞌi beella lubee apóstol cuna lubee bene enu rnibiyaꞌ lubee bene enu nzeli arquiꞌ Jesucristo para nú biꞌya beella xa aca equie cuendaꞌ nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nu uduꞌnziu bee bene eyeche Antioquía enu nzeli arquiꞌ Jesucristo liꞌibeella para nú chue beella. Chenu nzuebeella udete beella lu iliu Fenicia cuna lu iliu Samaria, nu udixiuleꞌe beella lubee bene enu nzeli arquiꞌ Jesucristo enu nucuaꞌa enza zeꞌe. Nu bee bene enu la neca bee bene Israel nzelila arquiꞌbeella Stichiaꞌ Diose. Nu ye bee bene enu nzeli arquiꞌ Jesucristo enu nucuaꞌa enza zeꞌe, chiquiꞌ ñia utsu arquiꞌbeella chenu ubeneꞌbeella nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Chenu uriña Pablo cuna bernabé Jerusalén, uyucu nzeꞌca bee bene enu nzeli arquiꞌ Jesucristo liꞌibeella cuna bee apóstol cuna bee bene enu rnibiyaꞌ lubee bene enu nzeli arquiꞌ Jesucristo, che ubedichiaꞌnu Pablo cuna Bernabé liꞌibeella lunú uriꞌi Diose lubeella. ");
INSERT INTO zplNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero chiucu chuna bee fariseo enu nzelíla arquiꞌ Jesucristo, utsulíbeei nú unibeei: ―Bee bene enu la neca bee bene Israel enu nzelíla arquiꞌ Jesucristo rquiꞌña nú quiee seña nú rquie bee bene Israel liꞌibeella, nu rquiꞌña nú riꞌibeella beyaꞌ nú zucuꞌ beella leyꞌ Moisés. ");
INSERT INTO zplNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Chequie uyetesaꞌ bee apóstol cuna bee bene enu rnibiyaꞌ lubee bene enu nzeli arquiꞌ Jesucristo para nú biꞌya beella xa riꞌibeella lu cuendaꞌ nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Lunú chiquiꞌ ubedichiaꞌ beella equie cuendaꞌ nucuaꞌ, utsuli Pedro nu unilla: ―Bee saꞌa enu nzeli arquiaꞌahua Jesucristo, liꞌihua nediyaꞌhua nú hasta huaꞌtu ucañi Diose liꞌá letahua para nú nzetixiuleꞌa bedichiaꞌ nzeꞌcaꞌ Jesucristo lubee bene enu la neca bee bene Israel para nú chili arquiꞌbeella liꞌinu. ");
INSERT INTO zplNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nu Diose enu nuꞌlu arquiꞌ ye bee bene, ulubeꞌnu nú neca beella bee beneꞌnu equie nú udeteꞌnu Espíritu Santo lubeella tucu nú uliquiꞌnue luru, ");
INSERT INTO zplNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","tucutse rriꞌi Diose luru cuna lubeella, xne tucu nú uriꞌinu perdona stularu leꞌca esquie uriꞌinu perdona stula beella equie nú nzeli arquiꞌbeella Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nee, ¿xiquie nú la zucuꞌhua lunú rni Diose nu rnibiyaꞌhua nú zucuꞌ bee bene enu nzeli arquiꞌ Jesucristo nú rni leyꞌ Moisés, nu niꞌ liꞌiru nu niꞌbee beneaꞌahua enu udetela, né aca beella azucuꞌbeella ley cuaꞌ? ");
INSERT INTO zplNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Liꞌiru nediyaꞌru nú utsilaꞌalaru lu dula tucu nú utsilaꞌa Diose liꞌibeella, equie nú neca nzeꞌca nú uriꞌi Jesucristo enu rnibiyaꞌ luaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Chequie uzaca ye beella nu uzucuꞌ diaca beella lunú rni Pablo cuna Bernabé lu ye bee milagro nú uriꞌibeella lubee bene enu la neca bee bene Israel, equie poder nú rluꞌcu Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Chenu ulaxu nú unibeella, chequie leꞌca uni Jacobo: ―Bee saꞌa enu nzeli arquiaꞌahua Jesucristo, uzucuꞌ diacahua lunú nialuhua. ");
INSERT INTO zplNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro unilalla luaꞌahua nú xa uquixie Diose nú ucañinu bee bene enu la neca bee bene Israel para nú aca beella bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ye bee nucuaꞌ ungala tucu nú uquieꞌe bee profeta lu ichiꞌ Stichiaꞌ Diose elu rni: ");
INSERT INTO zplNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Lulá nú aca bee nucuaꞌ, riꞌá nú aca tucu necatse bee benea stucu bese tucu nú ungae chenu uhuañi David. Nu aca tucu necatse beella cuna beelá bee bene enu nehuañiscaꞌ nee, tucu nú uhuañi bee bene tiembu nú uhuañi David, nu equie cuendaꞌ beella aca huaxi bee benea, ");
INSERT INTO zplNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","para nú cuaꞌna ye bee bene nú zeca beella liꞌá, nu ye bee bene lu iliulabe cuaꞌna beella nú zeca beella liꞌá, liꞌibeella enu ucañia. ");
INSERT INTO zplNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Scua rni Diose enu rixiuleꞌe ye bee nucuaꞌ lu ye bee bene hasta huaꞌtu. ");
INSERT INTO zplNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Enzeꞌe liꞌá Jacobo rriꞌá elliebacuꞌ nú la quiꞌña nú riaꞌahua juerza bee bene enu la neca bee bene Israel nú chequie beella lunú rni leyꞌ Moisés, liꞌibeella enu utsanaꞌ arquiꞌ bee custumbre para nú nzequie beella inziuꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nee neca nzeꞌca nú xeꞌlahua tucu ichiꞌ lubeella nú la acu beella nú necaleꞌya lubee nú nzeli arquiꞌ bee bene nú neca diose, nu la riꞌibeella eluhuexe nu la acu beella beꞌlaꞌ bee nañi enu la tiꞌchia rene chenu rati, nu la acu beella rene. ");
INSERT INTO zplNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Scua niaꞌahua lubeella, xne hasta huaꞌtu cada eyeche siempre nuꞌ tucu bene enu seteꞌ liꞌibeella lunú xi rni leyꞌ Moisés nú rula beella liñi induꞌ bee bene Israel bichia nú sulachi bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Chequie bee apóstol cuna bee bene enu rnibiyaꞌ lubee bene enu nzeli arquiꞌ Jesucristo, cuna ye beelá bee bene enu nzeli arquiꞌ Jesucristo unga tucunecatse beella nú ucañi beella bee bene leta beella para nú xeꞌla beella bee benequieꞌ cuna Pablo cuna Bernabé eyeche Antioquía. Che ucañi beella Judas enu leꞌca lee Barsabás, cuna Silas, liꞌibeella enu neca equie leta bee bene enu nzeli arquiꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nu uxeꞌla beella tucu carta cuna liꞌibeella nú rni: “Liꞌiru bee apóstol, cuna bee bene enu rnibiyaꞌ lubee bene enu nzeli arquiꞌ Jesucristo, cuna beela bee bene enu nzeli arquiꞌ Jesucristo, riꞌiru saludar liꞌihua enu la neca bee bene Israel, pero neca saꞌahua lunú nzeli arquiaꞌahua Jesucristo, liꞌihua enu nucuaꞌa eyeche Antioquía, nu diqui lu iliu Siria, cuna Cilicia. ");
INSERT INTO zplNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Liꞌiru ungabiyaꞌlaꞌru nú uchiuꞌu chiucu chuna bee bene lachiaꞌahua nu rriꞌibeei nú saꞌ arquiꞌhua cuna stichiaꞌ beei, che la riꞌihua beyaꞌ ta nú riꞌihua xne rnibeei nú rquiꞌña nú quiehua seña nú rquie bee bene Israel, cuna nú riꞌihua tucu nú rnibiyaꞌ leyꞌ Moisés pero lá deteꞌru permiso nú riꞌibeei scua. ");
INSERT INTO zplNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Enzeꞌe uyetesaꞌru nu uniru nú máse neca nzeꞌca nú cañiru chiucu chuna bee saꞌahua para nú yeꞌta biꞌya beella liꞌihua, cuna saꞌahua Pablo cuna Bernabé enu chiquiꞌ seꞌcaꞌahua, ");
INSERT INTO zplNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","liꞌibeella enu la lliqui mase nú ati equie cuendaꞌ nú sibiꞌ beella lu Jesucristo enu rnibiyaꞌ luaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nu cuna liꞌibeella xeꞌlaru Judas cuna Silas, nu leꞌca liꞌibeella ixiuleꞌe beella ye bee nucuaꞌ luhua. ");
INSERT INTO zplNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nu equie nú nzu Espíritu Santo cuna liꞌiru, uriꞌiru beyaꞌ nú la quiꞌña nú nibiyaꞌru luhua nú xi riꞌihua, lunú rquiꞌña nú riꞌihua neca, ");
INSERT INTO zplNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","nú la acuhua beꞌlaꞌ bee nañi enu rricuꞌ bee bene lubee nú nzeli arquiꞌ bee bene nú neca bee diose, nu la acuhua bee nañi enu la tiꞌchia rene chenu rati nu leꞌca la acuhua rene nu la riꞌihua eluhuexe. Tunu riꞌyahua liꞌihua nú la riꞌihua ye bee nucuaꞌ che sí nehuañi nzeꞌcahua lu Diose. Diose biꞌya liꞌihua.” ");
INSERT INTO zplNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Scua ungae, uxeꞌla beella carta cuaꞌ cuna tacu bene zeꞌe eyeche Antioquía. Zeꞌe uquieteꞌsaꞌbeella bee bene enu nzeli arquiꞌ Jesucristo nu udeteꞌ beella carta cuaꞌ ya beella. ");
INSERT INTO zplNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Chenu ungula beella carta zeꞌe, chiquiꞌ ñia utsu arquiꞌbeella equie bee bedichiaꞌ nzeꞌca nú rni lu carta zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Chequie Judas cuna Silas lunú leꞌca rluꞌcu beella nú reca beella para nú udeteꞌ beella Stichiaꞌ Diose lubee bene, xee unibeella lubee beneꞌ Jesucristo cuna nú uduꞌ beella ana arquiꞌbeella cuna stichiaꞌ beella. ");
INSERT INTO zplNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chenu udete huaxi bee bichia nú nzucu Judas cuna Silas zeꞌe, chequie bee beneꞌ Jesucristo enu nucuaꞌa eyeche Antioquía zeꞌe uduꞌ inza beella liꞌibeella para nú benchilaꞌ zeca beella elu nucuaꞌa bee saꞌbeella enu uxeꞌla liꞌibeella nú unibeella lubeella: “Diose riꞌi ucu liꞌihua.” ");
INSERT INTO zplNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero uduꞌ arquiꞌ Silas nú uyaꞌnalla zeꞌe ");
INSERT INTO zplNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Nu Pablo cuna Bernabé uyaꞌnalá beella eyeche Antioquía, liꞌibeella cuna beelá bee bene uzeteꞌ beella, cuna nú uyatixiuleꞌe beella bedichia nzeꞌcaꞌ Jesucristo lubee bene zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Chenu udete chiucu chuna bee bichia, che uni Pablo lu Bernabé: ―Chaꞌa chebiꞌyaꞌ zecaꞌa bee saꞌahua enu nzeli arquiꞌ Jesucristo bee eyeche elu uyatixiuleꞌe lá stichiaꞌnu para nú biꞌyaꞌa xa nucuaꞌa beella. ");
INSERT INTO zplNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé niarquiꞌ nú uyaꞌ beella Juan enu leꞌca lee Marcos; ");
INSERT INTO zplNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","pero nézela Pablo nú a uyaꞌ beella Juan Marcos, xne chenu uya beella lu iliu Panfilia utsanaꞌ arquiꞌlla liꞌibeella nu né chequiella liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Chequie niꞌ tuculla nu niꞌ stuculla né yaꞌna tucu necatse beella, nu utsanaꞌ arquiꞌsaꞌbeella. Che unguyaꞌ Bernabé Marcos nu uyuꞌu beella liñi barco nu nzuebeella enza Chipre luyuu nú netse lu inzatuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nu ucañi Pablo Silas nzenulla, nu utsaꞌna beelá bee beneꞌ Jesucristo liꞌibeella ya Diose para nú riꞌiucunu liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nu udete beella lu iliu Siria, cuna lu iliu Cilicia nu uduꞌ beella ana arquiꞌ bee beneꞌ Jesucristo enu nucuaꞌa enza zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Chenu uriña Pablo cuna Silas eyeche Derbe cuna eyeche Listra, zeꞌe uchuꞌu beella tucu bene enu nzeli arquiꞌ Jesucristo, benequieꞌ lee Timoteo nu necalla llianaꞌ tucu unaꞌa bene Israel enu leꞌca nzeli arquiꞌ Jesucristo, pero paꞌlla neca bene griego. ");
INSERT INTO zplNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ye bee beneꞌ Jesucristo enu nucuaꞌa eyeche Listra cuna eyeche Iconio rnibeella nu rriꞌi nzeꞌca Timoteo. ");
INSERT INTO zplNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Chequie uni Pablo nú uyaꞌlla Timoteo, pero rluti uquieella seña nú rquiee bee bene Israel para nú lecaxi nii bee bene Israel enu nucuaꞌa enza zeꞌe lu cuendaꞌlla, xne ye beei nediyaꞌ beei nú neca paꞌ Timoteo bene griego. ");
INSERT INTO zplNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nu lu ye bee eyeche elu uyabeella, udixiuleꞌe beella lubee bene enu nzeli arquiꞌ Jesucristo nú xa riala riꞌi beella, tucu nú uni bee ápostol cuna bee bene enu rnibiyaꞌ lubee bene enu nzeli arquiꞌ Jesucristo eyeche Jerusalén. ");
INSERT INTO zplNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Scua unga nú utsutaꞌ arquiꞌ bee bene enu nzeli arquiꞌ Jesucristo enu nucuaꞌa enza zeꞌe, nu bichia por bichia udala bee bene enu nzeli arquiꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Chequie né tsanaꞌ Espíritu Santo nú a ixiuleꞌe beella Stichiaꞌ Diose enza Asia. Che udetetsia beella lu iliu Frigia cuna lu iliu Galacia, ");
INSERT INTO zplNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","nu uriñabeella enza Misia. Zeꞌe uriꞌibeella elliebacuꞌ nú chue beella enza lu iliu Bitinia, pero leꞌca né zela Espíritu Santo nú a chaa beella enza zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Chenu udete beella enza Misia, uriñabeella eyeche Troas. ");
INSERT INTO zplNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Rulaꞌ zeꞌe ulleꞌca Pablo xi neca nú uni xcalaꞌlla, nú ulañiꞌlla tucu bene enu nzeꞌta enza Macedonia nu nzulílla sequieella lu Pablo nú unilla: “Yeꞌtalu enza Macedonia para nú riꞌilu elietsa luru.” ");
INSERT INTO zplNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Hora chenu ulubeꞌlu nucuaꞌ lu Pablo, uquieneru nú nzaꞌaru enza Macedonia xne nediyaꞌru nú Diose neca enu rixia liꞌiru enza zeꞌe para nú chetixiuleꞌeru bedichiaꞌ nzeꞌcaꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nu uyuꞌru liñi barco eyeche Troas nu nzaꞌalíru enza Samotracia. Nu stuculá bichia uriñaru eyeche Neápolis. ");
INSERT INTO zplNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Zeꞌe uchiuꞌuru nu nzaꞌaru eyeche Filipos, eyeche quieꞌ neca nú máse neca equie enza Macedonia. Pero Roma rnibiyaꞌ lu eyeche quieꞌ, zeꞌe uyaꞌnaru chiucu chuna bichia. ");
INSERT INTO zplNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nu tucu bichia nú sulachi bee bene Israel uchiuꞌuru ruꞌu eyeche zeꞌe, uyaꞌaru tucu reꞌcu elu nediyaꞌru nú rieteꞌsaꞌ bee bene Israel para nú rnacuꞌ beella lu Diose. Nu zeꞌe ulluaꞌaru uniru bedichiaꞌ nzeꞌcaꞌ Jesucristo lubee unaꞌa enu uyetesaꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tucu unaꞌa zeꞌe lee Lidia, liꞌilla necalla bene eyeche nú lee Tiatira, nu rutilla laquie fiñu nú morado. Neli rluꞌculla ulaꞌna lu Diose nu sucuꞌ diacalla lunú rni Pablo, nu uxaꞌla Diose elliebacuꞌlla para nú rieneꞌ nzeꞌcaꞌlla lunú rni Pablo. ");
INSERT INTO zplNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Che urinzalla cuna ye bee beneꞌlla nu uziquieella luru nú unilla: ―Tunu nzeli arquiꞌhua nú nzelíla arquia Jesucristo uteehua ne yaꞌnahua nia. Che uriꞌilla juerza liꞌiru nú uyaꞌnaru niꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Tucu bichia chenu nzaꞌaru elu see bee bene rnacuꞌ lu Diose, uchuꞌuru tucu unaꞌa eꞌneꞌ enu nchiñi benechiquiꞌ arquiꞌ. Nu equie nú reca benechiquiꞌ zeꞌe rriꞌinchu beyaꞌ, nu rriꞌnchu ana huaxi dimi para bee bene enu utsii liꞌinchu para nú riꞌinchu riñaꞌ cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nu chu nzeꞌta quienchu Pablo cuna liꞌiru nu rixialinchu nú rninchu: ―¡Bee benequieꞌ sibiꞌ beella lu Diose liñibe, nu rixiuleꞌe beella luhua nú xa luꞌcuhua nú tsilaꞌahua lu stulahua! ");
INSERT INTO zplNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Scua uriꞌinchu huaxi bee bichia, hasta nú ullacaꞌ Pablo lunú rriꞌinchu scua nu ubenchilaꞌlla nu unilla lu benechiquiꞌ enu nchiñi arquiꞌnchu: ―Equie poder nú rluꞌcu Jesucristo liꞌá nibiyaꞌa lulu nú chiuꞌulu arquiꞌ unaꞌa eꞌneꞌ quieꞌ. Hora zeꞌe uchiuꞌu benechiquiꞌ zeꞌe arquiꞌnchu. ");
INSERT INTO zplNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero chenu ulañiꞌ bee bene enu rnibiyaꞌ lu unaꞌa eꞌneꞌ zeꞌe nú la riaꞌnchu ana dimi para liꞌibeei, chequie unaꞌtse beei Pablo cuna Silas unguyaꞌbeei liꞌibeella ruꞌu nilabe lubee usticia. ");
INSERT INTO zplNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Chenu udeteꞌ cuenda beei liꞌibeella lubee usticia unibeei: ―Bee bene Israel quieꞌ chiquiꞌ sureche beella bee bene lachiaꞌahua, ");
INSERT INTO zplNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","nu seteꞌ beei bee custumbre nú leca modo riaꞌahua nu la riaꞌahua bee custumbre cuaꞌ, xne necaꞌahua bee bene Roma. ");
INSERT INTO zplNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Chequie ye bee bene zeꞌe uriꞌi condra beei liꞌibeella, nu unibiyaꞌ bee usticia nú chiuꞌu xucu Pablo cuna Silas para nú zeteꞌcheꞌ beei liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Chenu ulaxu nú juerte uzeteꞌcheꞌ beei liꞌibeella, chu uduꞌ beei liꞌibeella niꞌcuꞌ nu unibiyaꞌ beei lu bene enu rriucu ruꞌu niꞌcuꞌ para nú riꞌi ucu nzeꞌca bene zeꞌe liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Chenu ubeneꞌ bene enu rriucu ruꞌu niꞌcuꞌ zeꞌe nucuaꞌ, che uduꞌ bene zeꞌe Pablo cuna Silas hasta cuarto aquié xiñaꞌ niꞌcuꞌ zeꞌe nu ullicaꞌcui cuchiuꞌ beella cuna cadena lu tucu baꞌca nú nchiucuꞌ zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pero tucu ulelaꞌ rulaꞌ, diqui nú rnacuꞌ Pablo cuna Silas lu Diose cuna nú rula beella canto lunu. Chequie beelá bee bene enu nchiñi liñi niꞌcuꞌ zeꞌe rieneꞌ beei lunú rula beella. ");
INSERT INTO zplNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Chequie tuꞌnatsia uquixie nú unga tucu xú juerte nu ucuñi hasta simienduꞌ niꞌcuꞌ zeꞌe. Hora zeꞌe uyaꞌla ye ruꞌu bee puertaꞌ niꞌcuꞌ zeꞌe nu uyeꞌche bee cadena nú nacaꞌcuu ye bee bene enu nchiñi zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Chenu uzetee bene enu rriucu ruꞌu niꞌcuꞌ zeꞌe ulañiꞌlla nú ye ruꞌu bee puerta niꞌcuꞌ zeꞌe naꞌla, che uhualla espadaꞌlla para nú nze utilla liꞌilla xne uriꞌilla elliebacuꞌ nú ye bee enu nchiñi niꞌcuꞌ ulaꞌala. ");
INSERT INTO zplNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Che juerte uni Pablo lulla: ―La útilu liꞌilu xne yeeru nelluaꞌaru caꞌa. ");
INSERT INTO zplNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Chequie unacuꞌ bene enu rriucu ruꞌu niꞌcuꞌ zeꞌe tucu quii nu uyuꞌu xuꞌulla liñi niꞌcuꞌ nu recatseꞌtseꞌlla xiquilla, uriñalla hasta lu Pablo cuna Silas nu utsulliquilla lubeella. ");
INSERT INTO zplNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nu chu uhualla liꞌibeella eliꞌyaꞌ nu unidichiaꞌlla lubeella nú unilla: ―Detá uniꞌhua, ¿xi riala riaꞌa para nú riꞌi Diose perdona liꞌá? ");
INSERT INTO zplNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nu ucuaqui beella lulla: ―Uchili arquiꞌ Jesucristo enu rnibiyaꞌ, che riꞌi Diose perdona liꞌilu cuna bee beneꞌlu. ");
INSERT INTO zplNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Che unibeella stichiaꞌ Jesucristo lulla cuna lu ye bee bene enu nucuaꞌa niꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nu rulaꞌ zeꞌe bene enu rriucu ruꞌu niꞌcuꞌ, uquieella bee elu nediꞌquiꞌ Pablo cuna Silas. Che chu urinzalla cuna ye bee beneꞌlla. ");
INSERT INTO zplNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nu unguyaꞌlla liꞌibeella niꞌlla nu udeteꞌlla nú udacu beella, nu chiquiꞌ ñia nzu arquiꞌlla cuna bee beneꞌlla equie nú nzelíla arquiꞌbeella Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Chenu uyeꞌe luyuu, uxeꞌla bee usticia bee sundado nú uyaniꞌbeei lu bene enu rriucu ruꞌu niꞌcuꞌ nú laꞌlla Pablo cuna Silas. ");
INSERT INTO zplNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Chequie uni bene enu rriucu ruꞌu niꞌcuꞌ zeꞌe lu Pablo: ―Unibiyaꞌla bee usticia nú laꞌa liꞌihua nuꞌ modo nú yuehua nee sin nú chenu arquiꞌhua. ");
INSERT INTO zplNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Che uni Pablo lubee sundado zeꞌe: ―Liꞌiru necaru mero bene Roma nu udiñi beella liꞌiru ante lu ye bee bene, nu niꞌtemeꞌ la zela beella nú aniru lubeella xa necane, nu uduꞌ beella liꞌiru niꞌcuꞌ. Nu nee niarquiꞌbeella nú laꞌa beella liꞌiru aꞌchiꞌtsia. ¡Leca modoe! Yeꞌta liꞌi eꞌcu beella laꞌa beella liꞌiru. ");
INSERT INTO zplNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nu uya bee sundado zeꞌe udixiuleꞌe bee nucuaꞌ lubee usticia, chequie ulliqui bee usticia zeꞌe chenu ubeneꞌ beella nú neca Pablo cuna Silas bene Roma. ");
INSERT INTO zplNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Che uya bee usticia unacuꞌ beella perdona lu Pablo cuna lu Silas, nu unibiyaꞌ bee usticia nú uchiuꞌu beella niꞌcuꞌ nu uni bee usticia zeꞌe lubeella nú chiuꞌu beella eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Chenu uchiuꞌu Pablo cuna Silas liñi niꞌcuꞌ zeꞌe uyabeella niꞌ Lidia. Nu chenu ulaxu nú uduꞌ beella ana arquiꞌ bee saꞌ beella enu nzeli arquiꞌ Jesucristo, chu nzuebeella. ");
INSERT INTO zplNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Chenu nza Pablo cuna Silas, udete beella enza eyeche Anfípolis cuna enza eyeche Apolonia nu uriñabeella eyeche Tesalónica, elu nzucu tucu induꞌ bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Tucu nú neca costumbreꞌ Pablo, uyalla liñi indu zeꞌe chuna bichia nú sulachi beella, unilla Stichiaꞌ Diose lubeella. ");
INSERT INTO zplNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Udixiuleꞌella nu ulubeꞌlla lu ichiꞌ Stichiaꞌ Diose lubeella elu rni nú rquiꞌña nú nehuana zeca Jesucristo, nu chenu atinu huañi zecanu unilla lubeella: ―Leꞌca liꞌi Jesuse enu rnia luhua nee, liꞌinu necanu Cristo. ");
INSERT INTO zplNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Chequie chiucu chuna bee bene Israel zeꞌe uyalí arquiꞌ lunú uni Pablo, nu uyetesaꞌbeella cuna liꞌilla cuna Silas, leꞌca huaxi bee bene griego enu rluꞌcu ulaꞌna lu Diose cuna huaxi bee unaꞌa enu chiquiꞌ neca equie uyalí arquiꞌbeella Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pero bee bene Israel enu la chili arquiꞌ Jesucristo, uye arquiꞌbeei nu uquieteꞌsaꞌbeei bee bene enu enzee labe inziu, nu bee bene zeꞌe uquieteꞌsaꞌbeei beelá bee bene para nú tsureche beei bee bene. Nu uyuꞌu beei liñi niꞌ Jasón rlaꞌna beei Pablo cuna Silas para nú huabeei liꞌibeella nu tsu beei liꞌibeella ante lu ye bee bene eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pero lunú néllelaꞌ beei liꞌibeella zeꞌe, che uxaꞌbeei Jasón cuna xiucu xuna bee bene enu nzeli arquiꞌ Jesucristo, nu uyayu beei liꞌibeella lubee usticia, nu urixialibeei nú unibeei: ―Bee niyu enu rriꞌi nú rliu casi ye bee bene iliulabe uriñabeella caꞌa, ");
INSERT INTO zplNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","nu niꞌ Jasón nucuaꞌa beella. Liꞌibeella cuna ye bee bene enu nzeli arquiꞌ lunú rnibeella, la riꞌi beella tucu nú rnibiyaꞌ leyꞌ arre César. Xne rnibeella nú nuꞌ stucu arre enu lee Jesús. ");
INSERT INTO zplNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Chenu ubeneꞌ bee usticia cuna bee bene nucuaꞌ, yelu elliebacuꞌ uriꞌi beella. ");
INSERT INTO zplNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pero Jasón cuna beelá bee bene enu unaꞌtse beei, chenu udixiu beella che ulaꞌa bee usticia liꞌibeella niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Leꞌca rulaꞌ zeꞌe, bee bene enu nzeli arquiꞌ Jesucristo uxeꞌla beella Pablo cuna Silas eyeche nú lee Berea. Chenu uriñabeella zeꞌe, uya beella liñi induꞌ bee bene Israel. ");
INSERT INTO zplNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bee bene Israel quieꞌ máse uriꞌi nzeꞌca beella luquela bee bene enu nucuaꞌa eyeche Tesalónica, nu chiquiꞌ ñia nzu arquiꞌbeella ubeneꞌbeella lunú uni Pablo, nu yeyeꞌe rula beella sitichiaꞌ Diose para nú riꞌi beella beyaꞌ tunu neli lunú rni Pablo. ");
INSERT INTO zplNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Enzeꞌe huaxi beella uyalí arquiꞌbeella Jesucristo, nu leꞌca huaxi bee enu neca griego uyalí arquiꞌbeella liꞌinu, sia bee niyu nu sia bee unaꞌa enu máse neca equie zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nu chenu ungabiyaꞌ bee bene Israel enu nucuaꞌa eyeche Tesalónica nú rixiuleꞌe Pablo Stichiaꞌ Diose eyeche Berea, che uyatuꞌ beei arquiꞌ bee bene zeꞌe para nú lee bee bene zeꞌe lu Pablo. ");
INSERT INTO zplNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pero bee bene enu nzeli arquiꞌ Jesucristo né leꞌbeella chu uxeꞌla beella Pablo enza ruꞌu inzatuꞌ. Nu Silas cuna Timoteo uyaꞌna beella eyeche Berea. ");
INSERT INTO zplNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nu bee bene enu uya tuꞌinza Pablo uyayu beella liꞌilla hasta eyeche Atenas liñi barco chenu ubenchilaꞌ zeca beella eyeche Berea unguyaꞌbeella resuna nú uxeꞌla Pablo para nú chu cha Silas cuna Timoteo elu nzuculla. ");
INSERT INTO zplNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Diqui nú nzuquie Pablo nú riña Silas cuna Timoteo eyeche Atenas, chiquiꞌ nehuana utsu arquiꞌ Pablo chenu ulañiꞌlla nú nuꞌ huaxi bee diose enu rluꞌcu bee bene ulaꞌna lu eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Enzeꞌe, uya Pablo liñi induꞌ bee bene Israel para nú unilla lubee bene zeꞌe Stichiaꞌ Diose, cuna lubeelá bee bene enu rluꞌcu ulaꞌna lu Diose tucu nú rriꞌi bee bene Israel, nu yeyeꞌe unilla lu titse bee bene enu xaꞌcalla ruꞌu iꞌya stichiaꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Leꞌca unilla lu chiucu chuna bee bene enu nzequiee lunú uzeteꞌ bene enu lee epicúreos, cuna bee bene estoicos, che nuꞌbeei enu uni: ―¿Xi equie rni benecuaꞌ nú chiquiꞌ rni nucuaꞌ scua? Xiucu xuna beei uni: ―Pianu stichiaꞌ stucu bee diose rene rixiuleꞌe nucuaꞌ unibeei. Unibeei scua xne lunú rixiuleꞌe Pablo lubeei neca bedichiaꞌ nzeꞌcaꞌ Jesucristo, cuna nú unilla equie nú uhuañi zeca Jesucristo stucu bese. ");
INSERT INTO zplNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Chequie unguyaꞌbeei Pablo tucu luhuare elu lee Areópago elu rieteꞌsaꞌbeei. Nu unidichiaꞌ beei lulla: ―¿Nuꞌ modo riꞌiru beyaꞌ xa neca bee bedichiaꞌ cuqui cuaꞌ nú nzeꞌtalu seteꞌlu liꞌiru caꞌa la? ");
INSERT INTO zplNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Xne puro beenú la riꞌiru beyaꞌ rnilu luru, enzeꞌe niarquiꞌru riꞌiru beyaꞌ xa neca bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Xne ye bee bene eyeche Atenas, cuna beelá bee bene rene enu nucuaꞌa zeꞌe, siempre rriꞌibeei scua, riuꞌ arquiꞌbeei nú rdeteꞌ beei bichia nú rieneꞌ beei cuna nú rdichiaꞌ beei lunú necuqui neca. ");
INSERT INTO zplNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Chequie utsuli Pablo ante lu ye beei elu neyeteꞌsaꞌ beei zeꞌe, nu unilla lubeei: ―Bee bene eyeche Atenas, lu ye nú ulañia uriꞌá beyaꞌ nú rluꞌcuhua huaxi bee diose enu rluꞌcuhua ulaꞌna lu. ");
INSERT INTO zplNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nu chenu riꞌya elu rdeteꞌhua ulaꞌna lubee dioseꞌhua, ulañia tucu ecuꞌcu elu niquie bee bedichiaꞌ nú rni: “Para Diose enu la chuluru.” Nu Diose cuaꞌ enu rluꞌcuhua ulaꞌna lu sin nú chuluhua liꞌinu, stichiaꞌnu neca nú nzelatixiuleꞌa luhua. ");
INSERT INTO zplNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Diose cuaꞌ urecheꞌe iliulabe cuna ye nú nuꞌ lue, liꞌinu rnibiyaꞌnu liñibe cuna lu iliulabe. La nzucunu liñi indu nú rrecheꞌ bee bene, ");
INSERT INTO zplNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","nu leꞌca la quiꞌñanu núti riꞌi elietsa lunu, xne liꞌinu necanu enu lia rliquiꞌ bii luaꞌahua para nú huañiaꞌahua nu liꞌinu rliquiꞌnu elu nehuañiaꞌahua, cuna ye beenú rquiꞌñiaꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Equie cuendaꞌ tucutsia bene uriꞌi Diose nú udala bee bene lu iliulabe para nú huañi bee bene diqui lu iliulabe, nu utsaꞌnalanu nú calu lana huañi beei, cuna elu cuaꞌa beei nu hasta calu luyuu nibiyaꞌ beei lu. ");
INSERT INTO zplNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Para nú laꞌna beei Diose masia xi neca chenu rrilaꞌ ya bene nú rlaꞌna bene xi rlaꞌnalla para nú scua llelaꞌ beei liꞌinu. Añinzuca nú neli nú laca istu nzu Diose lu ye bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Xne equie cuendaꞌ Diose nehuañiaꞌahua, nu equie cuendaꞌ liꞌinu rcuñiaꞌahua nu seꞌahua, nu equie cuendaꞌ liꞌinu nelluaꞌahua lu iliulabe. Tucu nú leꞌca uni chiucu chuna bee beneꞌhua enu chiquiꞌ reca chenu unibeella: “Liꞌiru necaru lliꞌñi Diose.” ");
INSERT INTO zplNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Enzeꞌe tunu necaꞌahua lliꞌñi Diose, la quiꞌña nú riaꞌahua elliebacuꞌ nú necacheꞌ Diose oro urre plata urre quiee, xi neca bee diose nú rrecheꞌe bee bene tucu nú xelatsia arquiꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Bee tiembu nú udetela uzela Diose nú uriꞌi bee bene tucu nú nzelitsia arquiꞌbeei equie nú la riꞌi beei beyaꞌ, pero nee diqui lu iliulabe rnibiyaꞌnu lubee bene, nú cheꞌe arquiꞌbeei lu stula beei nu chili arquiꞌbeei Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Xne ucañila Diose tucu bichia nú hualunue lu cuendaꞌ bee bene. Nu uduꞌlanu Jesucristo para nú riꞌinu elu usticia cuaꞌ, nu para nú lañiꞌ bee bene nú ucañi Diose liꞌinu nú riꞌinu nucuaꞌ, nu uriꞌi Diose nú uhuañi zecanu chenu ungutinu. ");
INSERT INTO zplNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Chenu ubeneꞌbeei nú uni Pablo nú huañi zeca bee benenguti stucu bese, chiucu chuna beei utsequichiaꞌ liꞌilla, nu xiucu xuna beei uni: ―Pianu hasta stucu bese yeneꞌlaꞌru lunú rnilu. ");
INSERT INTO zplNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Chequie utsanaꞌ arquiꞌ Pablo liꞌibeei, ");
INSERT INTO zplNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","pero nuꞌ beella enu uyetesaꞌ cuna Pablo nu uchili arquiꞌbeella Stichiaꞌ Diose. Leta beella nzu tucu bene enu lee Dionisio, enu neca lu tucu texcuaꞌa bee bene enu lee Areópago, cuna tucu unaꞌa enu lee Dámaris, cuna beelá bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Lu zeꞌela uchiuꞌu Pablo eyeche Atenas nu nzalla eyeche Corinto. ");
INSERT INTO zplNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Zeꞌe ullaꞌcalla tucu bene Israel enu lee Aquila, lachi bene quieꞌ lee Ponto. Aquila quieꞌ cuna unaꞌlla Priscila apenatsia uriña beella nú nzeꞌta beella enza Italia, xne unibiyaꞌ arre Claudio nú uchiuꞌu ye bee bene Israel Roma. Che uyabiꞌya Pablo liꞌibeella, ");
INSERT INTO zplNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","nu lunú leꞌca riñaꞌ nú rriꞌibeella rriꞌi Pablo, nú rrecheꞌe beella carpa iti, che uyaꞌnalla cuna liꞌibeella para nú riꞌi junto beella riñaꞌ cuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Cada bichia nú sulachi bee bene Israel nza Pablo rixiuleꞌella Stichiaꞌ Diose liñi induꞌ bee bene Israel, sia lubee bene Israel urre lubee bene enu la neca bee bene Israel, rcuaꞌna Pablo xa riꞌilla ana nú chili arquiꞌbeei lunú rnilla. ");
INSERT INTO zplNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Chenu uriña Silas cuna Timoteo eyeche Corinto nú nzeꞌta beella enza lu iliu Macedonia lá riaꞌ Pablo stucu riñaꞌ rene udixiuleꞌetsialla Stichiaꞌ Diose lubee bene, nu udixiuleꞌella lubee bene Israel nú neca Jesuse Cristo. ");
INSERT INTO zplNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pero uquixiebeei nú uleebeei lu Pablo nu unibeei bedichiaꞌ nú necha neca lulla, nu chequie uriꞌquilla xuculla xi neca seña nú la zucuꞌbeei nú rnilla, nu unilla lubeei: ―Liꞌi eꞌcuhua rriꞌihua nú nitiluhua lu Diose la neca nucuaꞌ cuenda. Desde nee nzaꞌa lubee bene enu la neca bee bene Israel nzetixiuleꞌa Stichiaꞌ Diose lubeei. ");
INSERT INTO zplNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Che uchiuꞌulla liñi indu zeꞌe nu nzalla niꞌ tucu bene enu lee Ticio Justo, benequieꞌ rluꞌculla ulaꞌna lu Diose nu axu nzucu niꞌlla ruꞌu indu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nu Crispo lee tucu bene enu rnibiyaꞌ liñi induꞌ bee bene Israel, liꞌilla cuna ye bee beneꞌlla uchili arquiꞌbeella Jesucristo. Leꞌca huaxi bee bene eyeche Corinto uchili arquiꞌbeella Jesucristo chenu ubeneꞌbeella stichiaꞌnu nu urinza beella. ");
INSERT INTO zplNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Tucu rulaꞌ neca xi neca nú uni xcalaꞌ Pablo nu uni Diose lulla: ―La lliquilu uquia tixiuleꞌelá stichiaꞌa lubee bene nu la tsuxeelu, ");
INSERT INTO zplNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","liꞌá nzua cuna liꞌilu para nú lecati xi riꞌinu liꞌilu, xne eyeche quieꞌ nucuaꞌa huaxi bee bene enu aca bee benea. ");
INSERT INTO zplNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Enzeꞌe uyaꞌna Pablo eyeche Corinto tucu lana arulaꞌ, uzeteꞌlla bee bene zeꞌe Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pero chenu unga Galión gobernador lu iliu Acaya, unga tucu necatse bee bene Israel nu unaꞌtse beei Pablo, nu unguyaꞌbeei liꞌilla lu gobernador zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Nu unibeei lulla: ―Benequieꞌ rcuaꞌnalla xa riꞌilla ana bee bene para nú luꞌcu beella ulaꞌna lu Diose stucu forma lunú la nibiyaꞌ leyꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nze nila Pablo, chenu ucuaqui Galión lubee bene Israel zeꞌe, nu unilla: ―Tunu necane nú uriꞌilla tucu equiya, urre uriꞌilla tucu nú necha neca enzeꞌe nzeꞌta yuhualla lua, che riꞌi casoa lunú rnihua. ");
INSERT INTO zplNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pero necatsia nucuaꞌ equie cuendaꞌ bee bedichiaꞌ cuna equie cuendaꞌ nú lee bee bene, nu cuna equie cuendaꞌ leyꞌhua, liꞌitsiahua biꞌyahua xa aca nucuaꞌ, xne la niarquia aca enu hualu nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nu chu uhualla bee bene zeꞌe elu rlualullae lu cuendaꞌ bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Chequie chu unaꞌtse bee bene griego zeꞌe tucu bene enu lee Sóstenes, enu rnibiyaꞌ liñi induꞌ bee bene Israel nu uzeteꞌcheꞌ beei liꞌilla. Pero niꞌtemeꞌ la riꞌi caso gobernador zeꞌe liꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Uyaꞌnascaꞌlá Pablo eyeche Corinto huaxi bichia. Cheela unilla lubee saꞌlla enu nzeli arquiꞌ Jesucristo nú nzialla nu nzalla cuna Aquila cuna Priscila, nu uyuꞌu beella liñi barco nu nzuebeella enza Siria, pero ante nú chiuꞌu beella eyeche Cencrea urecuꞌ ichia equie Pablo para nú utsaꞌalulla tucu nú ucuaqui uꞌnalla lu Diose nú uriꞌilla. ");
INSERT INTO zplNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Chenu uriña beella eyeche Efeso, zeꞌe utsaꞌna Pablo Aquila cuna Priscila, pero uyalla liñi induꞌ bee bene Israel enu nucuaꞌa zeꞌe, uyaniꞌlla lubee bene Israel enu rieteꞌsaꞌ liñi indu zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Chequie uziquiee beella lu Pablo nú yaꞌnalálla cuna liꞌibeella zeꞌe xiucu xuna bichia, pero lá zelalla, ");
INSERT INTO zplNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","nu unilla lubeella: ―Nziaꞌla nee, xne eyeche Jerusalén rquiꞌña nú detea eliñi nú nzeꞌta. Tunu zela Diose nzelabiꞌya zeca liꞌihua stucu bese. Che uyuꞌulla liñi barco nu uchiuꞌulla eyeche Efeso. ");
INSERT INTO zplNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Chenu uriña Pablo eyeche Cesarea, che uyalla Jerusalén uyabiꞌyalla bee beneꞌ Jesucristo, nu chu nzalla enza eyeche Antioquía. ");
INSERT INTO zplNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Chenu ungala xee nú nzuculla eyeche Antioquía, uyalla cada tucua bee eyeche nú nchiucuꞌ lu iliu Galacia cuna lu iliu Frigia, rduꞌlla ana arquiꞌ ye bee beneꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tiembu zeꞌe uriña tucu bene Israel eyeche Efeso nu liꞌilla leella Apolos, nu lachilla neca Alejandría. Benequieꞌ chiquiꞌ recalla rnilla, nu leꞌca chiquiꞌ recalla Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Unga nzeꞌcalla Stichiaꞌ Diose, chequie chiquiꞌ nuꞌ ana arquiꞌlla uzeteꞌlla stichiaꞌ Jesuse lubee bene, nu neli unilla stichiaꞌnu lubeella, añinzuca nú nediyaꞌtsialla elu rrinza nú uzeteꞌ Juan Bautista bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos quieꞌ sin nú lliquilla uquixiella nú udixiuleꞌella Stichiaꞌ Diose lubee bene Israel liñi induꞌbeei, nu chenu ubeneꞌ Priscila cuna Aquila lunú rnilla, che unguyaꞌbeella liꞌilla niꞌbeella, nu zeꞌe uzeteꞌlá bee benequieꞌ liꞌilla para nú ungalallá Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Chenu uriꞌi Apolos elliebacuꞌ nú chálla lu iliu Acaya, ye bee beneꞌ Jesucristo enu nucuaꞌa zeꞌe uduꞌ beella ana arquiꞌlla para nú challa zeꞌe, nu uquieꞌe beella tucu carta lubee beneꞌ Jesucristo enu nucuaꞌa lu iliu acaya para nú yucu nzeꞌca beella liꞌilla chenu riñalla lu iliu zeꞌe. Nu chenu uriña Apolos lu iliu Acaya chiquiꞌ uriꞌilla elietsa lubee bene enu nzeli arquiꞌ Jesucristo enu nucuaꞌa zeꞌe, liꞌibeella enu uyalí arquiꞌ Jesucristo cuna elietsaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Xne lu ye bee bene unilla nú la cha nzeꞌca bee bene Israel, nu lecati unga ucuaqui lulla, xne ye nú rnilla neli necane, liꞌilla rlubeꞌlla tucu nú nequie lu ichiꞌ Stichiaꞌ Diose lubee bene, ye bee luhuare elu rni: “Nú Jesuse neca Cristo.” ");
INSERT INTO zplNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Diquila nú nzucu Apolos eyeche Corinto, uya Pablo enza lubee eyeche lu dañi Asia nu uriñalla eyeche Efeso, elu nucuaꞌa texcuaꞌa bee bene enu nzeli arquiꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Nu unidichiaꞌ Pablo lubeella: ―¿Uyucu arquiꞌhua Espíritu Santo chenu uyalí arquiꞌhua Jesucristo la? Nu ucuaqui beella nú unibeella: ―Niꞌ lascaꞌ yeneꞌru nú nuꞌ Espíritu Santo. ");
INSERT INTO zplNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nu uni Pablo lubeella: ―¿Xa urinzahua che? Nu ucuaqui beella nú unibeella: ―Urinzatsiaru tucu nú uzeteꞌ Juan Bautista bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Chequie uni Pablo lubeella: ―Nelí nú Juan urinza bee bene, liꞌibeella enu utsanaꞌ arquiꞌ stula, pero unilla lubeella nú rquiꞌña nú chili arquiꞌbeella enu nzeꞌta lulá Juan, nu liꞌinu necanu Cristo. ");
INSERT INTO zplNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Chenu ubeneꞌbeella nucuaꞌ, che urinza beella equie nú lee Jesuse enu rnibiyaꞌ, ");
INSERT INTO zplNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","nu chenu uricuꞌ Pablo yalla equie beella, uyucu arquiꞌbeella Espíritu Santo, nu uquiexie beella nú unibeella stucu dialu rene, che unibeella Stichiaꞌ Diose lubee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Lu yebeella neca tucu chiꞌchiucu bee niyu. ");
INSERT INTO zplNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Diqui chuna guu uya Pablo liñi induꞌ bee bene Israel enu nucuaꞌa zeꞌe, nu sin nú lliquilla udixiuleꞌella Stichiaꞌ Diose lubeella, unilla lubeella nu ucuaꞌnalla xa riꞌilla ana nú chili arquiꞌbeella xa neca elurnibiyaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pero chiucu chuna beei unga nziti arquiꞌ nu lá niarquiꞌbeei nú achili arquiꞌbeei stichiaꞌ Jesucristo, aꞌla uquixiebeei nú uni condra beei stichiaꞌnu ante lu ye bee bene. Che uchiuꞌuchu Pablo lubeei cuna bee bene enu nzeli arquiꞌ Jesucristo, nu unguyaꞌlla liꞌibeella xcuelaꞌ tucu bene enu lee Tirano, zeꞌe uzeteꞌlla liꞌibeella yeyeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","scua uriꞌilla diqui chiucu lana. Nu ye bee bene enu nucuaꞌa lu iliu Asia nu sia bee bene Israel cuna bee bene enu la neca bee bene Israel ubeneꞌbeella stichiaꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nu equie nú rnibiyaꞌ Diose uriꞌi Pablo bee milagro nú llene, ");
INSERT INTO zplNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","hasta bee panituꞌ Pablo cuna bee laquie nú rquiee lulla ruyaꞌ bee bene nucuaꞌ lubee bene enu riti, nu scua riecaꞌ beella lu elichia nú secabeella, nu xiuꞌu bee benechiquiꞌ enu nchiñi arquiꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Chequie nuꞌ chiucu chuna bee bene Israel enu enzeehua bee benechiquiꞌ arquiꞌ bee bene, nu niarquiꞌbeei nú cuna nú lee Jesucristo huabeei bee benechiquiꞌ cuaꞌ arquiꞌ bee bene, che unibeei lubee benechiquiꞌ zeꞌe: ―Equie nú lee Jesuse enu rixiuleꞌe Pablo nibiyaꞌa nú chiuꞌuhua arquiꞌ bee benequieꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nucuaꞌ neca nú uriꞌi achi llianaꞌ tucu bene enu lee Esceva, enu unga tucu uleꞌya enu rnibiyaꞌ lubee uleꞌya. ");
INSERT INTO zplNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pero tucu bese ucuaqui tucu bee benechiquiꞌ zeꞌe lubeei nú uni: ―Nuꞌlua Jesuse, nu leꞌca nediyaa ti neca Pablo, pero liꞌihua la riꞌá beyaꞌ tihua. ");
INSERT INTO zplNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Chequie bene enu nchiñi benechiquiꞌ zeꞌe arquiꞌ uquixiei nú uzeteꞌcheꞌi liꞌibeei nu uriꞌi ana lubeei cuna juerza nú rluꞌcui, chiquiꞌ necha udiñii liꞌibeei, nu eꞌcu etubeei uchiuꞌuxuꞌubeei liñi niꞌi zeꞌe uyecaxuꞌubeei nu nediꞌqui beei. ");
INSERT INTO zplNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ye bee bene enu nucuaꞌa eyeche Efeso, sia bee bene Israel cuna bee bene enu la neca bee bene Israel, ungabiyaꞌ beella nú ungae scua. Chequie chiquiꞌ ulliqui beella nu uni nzeꞌca beella lu cuendaꞌ Jesuse. ");
INSERT INTO zplNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nu huaxi bee bene enu uyalí arquiꞌ Jesucristo uriña beei nu utsiruꞌu beei ante lu ye bee bene lu ye beenú necha neca uriꞌibeei. ");
INSERT INTO zplNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Leꞌca huaxi bee bene enu uriꞌi bee elu uliñi uriñayu beei ichiꞌ elu uliñi nu utsiquiꞌ beei ichiꞌ cuaꞌ lu quii ante lu ye bee bene. Chenu uhuabeei cuenda nú calu seca bee ichiꞌ zeꞌe, nu uyalu nú seca bee ichiꞌ zeꞌe tucu cincuenta mil melu plata. ");
INSERT INTO zplNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Scua unga nú chu nze riꞌchia letselá stichiaꞌ Jesucristo cuna nú ungachee lunú neca poderꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Chenu ulaxu nú unga bee nucuaꞌ, uduꞌ arquiꞌ Pablo nú challa lu iliu Macedonia cuna lu iliu Acaya, cuna nú nze riꞌilla seidu biajiꞌlla hasta eyeche Jerusalén. Leꞌca unilla nú chenu uyalalla eyeche Jerusalén che leꞌca challa Roma. ");
INSERT INTO zplNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nu uxeꞌlalla chiucu bee bene enu rriꞌi elietsa lulla, Timoteo cuna Erasto para nú nzuebeella lu iliu Macedonia diqui nú riaꞌnalla xiucu xuna bichia lu iliu Asia. ");
INSERT INTO zplNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Bee bichia zeꞌe utsureche bee bene eyeche Efeso equie nú rriꞌi condra beei stichiaꞌ Jesucristo. ");
INSERT INTO zplNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Xne Demetrio tucu bene enu rrecheꞌe beenú necacheꞌ plata, liꞌi enu rrecheꞌe bee indumeꞌ diose enu lee Diana, liꞌi nediyaꞌi nú equie bee nucuaꞌ rriꞌi ana huaxi dimi cuna bee bene enu rriꞌi saꞌ riñaꞌ nú rriꞌi. ");
INSERT INTO zplNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Chequie uquieteꞌ saꞌi bee benecuaꞌ, cuna beelá bee bene enu rriꞌi saꞌ riñaꞌ nú rriꞌi, nu uni lubeella: ―Uzuꞌcuꞌ diacahua, liꞌihua nediyaꞌhua nú lu riñaꞌ quieꞌ rriaꞌahua ana huaxi dimi, ");
INSERT INTO zplNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","pero nee rlañiꞌahua nu rieneꞌahua nú enzee Pablo rnilla nú bee diose enu rrecheꞌe bee bene la neca bee nucuaꞌ diose. Nu scua rriꞌilla ana nú nzeli arquiꞌ huaxi bee bene lunú rnilla, nu lacane eyeche quieꞌtsia, sino que casi diqui lubee eyeche Asia nzeli arquiꞌ bee bene scua. ");
INSERT INTO zplNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nu scua nelliqui nú laxu riñaꞌ nú rriaꞌahua, nu lacane equie riñaꞌ nú rriꞌitsiaꞌahua, leꞌca la deteaꞌ bee bene nú neca equie induꞌ diose Diana. Nu scua la riaꞌ bee bene caso diose Diana enu rluꞌcu ye bee bene ulaꞌna lu lu iliu Asia cuna ye bee bene iliulabe. ");
INSERT INTO zplNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Chenu ubeneꞌ bee bene zeꞌe nucuaꞌ, chiquiꞌ ulee beei nu rixiali beei nú unibeei: ―¡Chiquiꞌ neca equie Diana dioseꞌahua liaꞌahua enu neca bee bene efesio! ");
INSERT INTO zplNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Che utsureche bee bene eyeche zeꞌe, nu unaꞌtse beei Gayo cuna Aristarco, rucu bee niyu quieꞌ neca bene eyeche Macedonia enu enzenu Pablo, nu uxaꞌbeei liꞌibeella nu unguyaꞌbeei liꞌibeella elu rietesaꞌ bee bene eyeche zeꞌe, elu rriꞌibeei juntaꞌbeei. ");
INSERT INTO zplNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Niarquiꞌ Pablo nú nze chuꞌulla zeꞌe para nú nilla lubee bene, pero bee saꞌlla enu nzeli arquiꞌ Jesucristo né zela beella nú ariꞌilla scua. ");
INSERT INTO zplNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nu leꞌca leta bee usticia Asia, nuꞌ chiucu chuna bee bene enu rquieteꞌ Pablo, liꞌibeella enu uxeꞌla resuna lulla nú máse neca nzeꞌca nú la chuꞌulla zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Texcuaꞌa bee bene zeꞌe urixialibeei nu urene urene unibeei, nu texcuaꞌa beei urixiali nu urene unibeei nu utsureche beei nu huaxi beei niꞌ la riꞌi beei beyaꞌ xinu uyeteꞌ saꞌbeei zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Leta bee beneañi zeꞌe uhua bee bene Israel tucu bee saꞌbeella enu lee Alejandro para nú nilla lubee bene zeꞌe. Nu uriꞌi Alejandro seña cuna yalla lubee bene zeꞌe nú zaca beei para nú nilla lu cuendaꞌ bee bene Israel lubee bene eyeche zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pero chenu uriꞌibeei beyaꞌ nú necalla bene Israel, tucu chiucu hora junto urixialibeei nú unibeei: ―¡Chiquiꞌ neca equie Diana dioseꞌahua liaꞌahua enu neca bee bene efesio! ");
INSERT INTO zplNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Chequie chenu uriꞌi secretario eyeche zeꞌe ana nú uzaca bee bene, che unilla: ―Bee bene Efeso, ye bee bene iliulabe nediyaꞌ nú eyeche quieꞌ siempre rriucu bee bene induꞌ diose Diana, nu leꞌca rluꞌcu bee bene ulaꞌna lu diose Diana enu ulaca liñibe. ");
INSERT INTO zplNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Liꞌihua nediyaꞌhua nú neli nucuaꞌ. Enzeꞌe la quiꞌña nú riꞌihua scua, la riꞌihua beenú rriꞌihua sin nú riꞌihua elliebacuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Xne bee bene enu uriñayuhua caꞌa, lá riꞌibeella nú necha neca lu induaꞌahua, nu la ni beella bedichiaꞌ nú necha neca lu dioseꞌahua. ");
INSERT INTO zplNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tunu Demetrio cuna bee bene enu rriꞌinui riñaꞌ rlee beei lu stucu bene, luꞌ nzucu nilabe nu zeꞌe nucuaꞌa bee usticia, chexana bitsi beei lubeella. ");
INSERT INTO zplNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Pero tunu nuꞌlá bee nú niarquiꞌhua nú xana bitsihua, chenu aca tucu juntaꞌ bee bene eyeche che tsuxcuaꞌa bee nucuaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nu nee lunú ungae scua nuꞌ beyaꞌ nú ni gobierno nú liaꞌahua rduaꞌahua arquiꞌ bee bene nú sureche beei scua, ¿nu xi cuaquiaꞌahua lubeella tunu nedichiaꞌ beella luaꞌahua equie nú sureche bee bene scua? ");
INSERT INTO zplNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Chenu ulaxu nú unilla scua lubee bene che chu nziue ye beei. ");
INSERT INTO zplNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Chenu utsuxe lunú sureche bee bene eyeche Efeso zeꞌe, ubixia Pablo bee bene enu nzeli arquiꞌ Jesucristo nu uduꞌlla ana arquiꞌbeella. Che unilla lubeella nú nzalla, nu nzalla enza lu iliu Macedonia. ");
INSERT INTO zplNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Uyalla diqui bee enza zeꞌe nu chiquiꞌ uduꞌlla ana arquiꞌ bee bene enu nzeli arquiꞌ Jesucristo cuna stichiaꞌlla, che uriñalla enza lu iliu Grecia, ");
INSERT INTO zplNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","elu uzuculla chuna guu. Necala nú chuꞌulla liñi barco para nú nzalla enza lu iliu Siria, chenu uriꞌilla beyaꞌ nú nuꞌ nú niarquiꞌ bee bene Israel riꞌinu liꞌilla, che uriꞌilla elliebacuꞌ nú ubenchilaꞌ zecalla enza lu iliu Macedonia. ");
INSERT INTO zplNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nu unguyaꞌlla tucu bene Berea enu lee Sópater llianaꞌ Pirro, cuna bene enu lee Segundo, nu cuna Aristarco enu neca bee bene eyeche Tesalónica, leꞌca unguyaꞌlla Gayo bene Derbe, cuna Tiquico cuna Trófimo bene Asia cuna Timoteo. ");
INSERT INTO zplNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yebeella uriculu beella nu utsuquie beella Pablo cuna liꞌá Lucas eyeche Troas. ");
INSERT INTO zplNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nu liꞌiru, chenu udete eliñi nú racu bee bene pá nú la ucha levadura, che uchiuꞌuru eyeche Filipos nu uyuꞌuru liñi barco nu lu ayuꞌ bichia uriñaru eyeche Troas elu nucuaꞌa beella, nu zeꞌe ulluaꞌaru achi bichia. ");
INSERT INTO zplNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Chenu uriña bichia rlu liñi tucu xmana uyetesaꞌru para nú daꞌcu junturu pá tucu nú utsaꞌna Jesucristo, nu lunú uriꞌi Pablo elliebacuꞌ nú chiuꞌulla bichia rrucu, chenu uriña ulelaꞌ rulaꞌ lá laxuscaꞌ nú seteꞌlla bee bene. ");
INSERT INTO zplNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nu equie niꞌi elu ayaa nelluaꞌaru, nu rulu huaxi bee quii liñi niꞌi zeꞌe; ");
INSERT INTO zplNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","che tucu niyu eꞌneꞌ enu lee Eutico nzucui ruꞌu ventana. Nu lunú chiquiꞌ xee uzeteꞌ Pablo beella, che chiquiꞌ uyuꞌu calaꞌ lu niyu eꞌneꞌ zeꞌe, nu uriꞌi calaꞌ ana lui nu uzanaꞌi desde piso rriuna hasta luyuu nu ungutilai chenu uletsa beella liꞌi. ");
INSERT INTO zplNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Chequie ulaca Pablo elu nuxui, nu utsulliquilla uchiꞌchilla liꞌi, nu unilla lubee bene zeꞌe: ―La lliquihua, nehuañii. ");
INSERT INTO zplNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Che chu uquie zeca Pablo equie niꞌi zeꞌe, nu uleꞌella pá udacu beella, nu unilálla lubeella hasta nú uyeꞌe lu yuu, chenu uyeꞌe luyuu chu nzalla. ");
INSERT INTO zplNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nu niyu eꞌneꞌ enu uzanaꞌ zeꞌe, nehuañii nzeyu beella liꞌi niꞌi, nu chiquiꞌ ñia nzu arquiꞌbeella. ");
INSERT INTO zplNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Che uyuꞌuru liñi barco nu uricuꞌluru nú nzaꞌaru eyeche Asón elu utsaꞌnaru bedichiaꞌ lu Pablo nú llaꞌcaru liꞌilla, xne uriꞌilla elliebacuꞌ nú tsee eꞌyalla nzalla zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Chenu ullaꞌcaru Pablo eyeche Asón, che uyuꞌulla liñi barco cuna liꞌiru, nu nzaꞌaru lu eyeche nú lee Mitilene. ");
INSERT INTO zplNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Che uchiuꞌuru eyeche Mitilene, nu bichia rrucu udeteꞌru enza lee Quío, nu stucu bichia uriñaru elu lee Samos. Nu stucu bichia uriñaru Mileto, pero ante nú riñaru zeꞌe, utsuxeru elu lee Trogilio. ");
INSERT INTO zplNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Uriꞌi Pablo elliebacuꞌ nú la challa eyeche Efeso, nu leꞌca niarquiꞌlla nú la leꞌlla enza Asia, xne lunú niarquiꞌlla nú chu riñalla Jerusalén tunu nuꞌ beyaꞌ nú riñalla zeꞌe bichia liñi pentecostés. ");
INSERT INTO zplNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Chenu nelluaꞌaru eyeche Mileto, unibiyaꞌ Pablo nú yeꞌta bee bene enu rnibiyaꞌ lubee bene enu nzeli arquiꞌ Jesucristo eyeche Efeso, ");
INSERT INTO zplNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","chenu uriña beella zeꞌe uni Pablo lubeella: ―Desde bichia rluu nú uriñaa caꞌa Asia nu hasta nee liꞌihua nediyaꞌ nzeꞌcaꞌhua lunú rriꞌá. ");
INSERT INTO zplNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ye bee bichia nú nzua cuna liꞌihua sibiꞌa lu Jesucristo cuna nú nzuquie arquia, nu hasta runa nú huaxi beenú nehuana seꞌca lunú niarquiꞌ bee bene Israel riꞌinu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Pero añinzuca nú scua necane, ne tsana arquia unia luhua lunú neca nzeꞌca para liꞌihua ante lu ye bee bene urre niꞌhua uzetea liꞌihua. ");
INSERT INTO zplNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nu sia lubee bene Israel cuna lubee bene enu la neca bee bene Israel, unila lubeella nú cheꞌe arquiꞌbeella lu stula beella nu benchilaꞌ arquiꞌbeella lu Diose, nu chili arquiꞌbeella Jesucristo enu rnibiyaꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nee nú nzaꞌa Jerusalén elu uxeꞌla Espíritu Santo liꞌá, la riꞌá beyaꞌ xi nzu nú zeca zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Lunú nediyatsia nú lu ye bee eyeche elu nzaꞌa rni Espíritu Santo lua nú huaxi beenú nehuana zeca cuna nú chaꞌa niꞌcuꞌ. ");
INSERT INTO zplNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pero la chenuarquia nucuaꞌ mase atia, pero ñia nzu arquia rriꞌá lunú riala riꞌá hasta elu zelae, nu riꞌá lunú uliquiꞌ Jesucristo enu rnibiyaꞌ, nu ixiuleꞌa bedichiaꞌ nzeꞌcanu cuna nú xa neca elusecaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Nu nee nediyaa nú niꞌ tucuhua enu udixiuleꞌa xa neca lunú rnibiyaꞌ Diose lu, la lañiaꞌhua liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Enzeꞌe nia luhua nee, nú la necaꞌ nucuaꞌ cuendaꞌ liꞌá tunu la huañihua tucu nú neli neca, ");
INSERT INTO zplNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","xne liꞌá udixiuleꞌa luhua ye lunú xa neca Stichiaꞌ Diose, nu lecaxi utsacu arquia luhua. ");
INSERT INTO zplNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ubiꞌyahua liꞌihua, nu ubiꞌyahua bee bene enu nzeli arquiꞌ Jesucristo, liꞌibeella enu uliquiꞌ Espíritu Santo luhua para nú biꞌyahua liꞌibeella xi neca bene enu rriucu bee sanchi, xne Jesucristo udixiulanu cuna reneꞌnu equie cuendaꞌahua chenu ungutinu lu cruse. ");
INSERT INTO zplNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Liꞌá nediyaa nú chenu nziaꞌa, nzeꞌta stucu bene tiꞌchialetse bee nzeꞌe bee bene enu nzeli arquiꞌ Jesucristo, tucu nú rtiꞌchialetse bee bichiuu bee sanchi. ");
INSERT INTO zplNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nu leꞌca letahua chiuꞌu bee bene enu zeteꞌ puro bee eluquichiaꞌ para nú riꞌibeei ana bee beneꞌ Jesucristo, nu riꞌibeella caso stichiaꞌ beei luhuare nú riꞌibeella caso Stichiaꞌ Diose. ");
INSERT INTO zplNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Enzeꞌe ucuaꞌatsiñahua ubiꞌyahua liꞌihua. Ulluꞌcuꞌ arquiꞌhua nú diqui chuna lana, bichia si rulaꞌ né tsana arquia unia luhua hasta unguna unia bezeteꞌ luhua. ");
INSERT INTO zplNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Nee bee saꞌa enu nzeli arquiaꞌahua Jesucristo, ya Diose tsaꞌna liꞌihua cuna bedichiaꞌ nzeꞌcaꞌnu, nú rluꞌcu poder para nú riꞌi elietsa luhua nú nze chululáhua nú xa riala nú huañihua, nu liquiꞌnu luhua ye nú uninu nú deteꞌnu lubee bene enu neca bee beneꞌnu. ");
INSERT INTO zplNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Lecaxi unacua luhua niꞌ dimi nu niꞌ laquie. ");
INSERT INTO zplNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Liꞌihua nediyaꞌ nzeꞌcaꞌhua nú cuna yaa uriꞌá riñaꞌ para nú udacunua bee bene enu uya nzenu liꞌá. ");
INSERT INTO zplNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ulubelá luhua nú scua rquiꞌña riꞌi bee bene riñaꞌ para nú riꞌibeella elietsa lubee bene enu seca elitsi, ulluꞌcuꞌ arquiꞌhua stichiaꞌ Jesucristo enu rnibiyaꞌ chenu uninu: “Máse ñia nzu arquiꞌ bene enu lia rdeteꞌ nú rdeteꞌ luquela bene enu riucue.” ");
INSERT INTO zplNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Chenu ulaxu nú uni Pablo scua, chequie utsulliquilla nu unacuꞌlla lu Diose cuna liꞌibeella. ");
INSERT INTO zplNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Che yebeella ungunaꞌbeella nu uchiꞌchi beella Pablo nu udacu beella bichiuꞌ xecalla. ");
INSERT INTO zplNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nu chiquiꞌ nehuana utsu arquiꞌbeella lunú uni Pablo lubeella nú la lañiaꞌ beella liꞌilla. Nu chu uyayu beella liꞌilla hasta elu nzu barco. ");
INSERT INTO zplNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Zeꞌe utsaꞌnaru liꞌibeella, nu uyuꞌuru liñi barco nu nzaꞌalíru enza lee Cos tucu yuu nú netse lu inzatuꞌ, nu stucu bichia uriñaru elu lee Rodas lu stucu yuu nú netse lu inzatuꞌ, nu zeꞌe chu nzaꞌaru eyeche nú lee Pátara. ");
INSERT INTO zplNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nu eyeche zeꞌe uchuꞌuru tucu barco nú nza enza Fenicia, nu uyuꞌuru liñi barco zeꞌe. ");
INSERT INTO zplNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Chenu nzaꞌaru che enza cueꞌtseru chubeca ulañiꞌru yuu nú lee Chipre nú netse labe inzatuꞌ, nu nzaꞌaru enza Siria. Nu lunú rquiꞌña nú laca beenú nuyaꞌ barco eyeche Tiro. Che uyuꞌuru eyeche zeꞌe, ");
INSERT INTO zplNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","zeꞌe uchuꞌuru bee bene eyeche zeꞌe enu nzeli