﻿USE sofia;
DROP TABLE IF EXISTS sofia.zpi_vpl;
CREATE TABLE zpi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zpi_vpl WRITE;
INSERT INTO zpi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Laa yra la mén ne nak xpenkwlal Jesucrist nee, Jesucrist ne zëëd xnëz rrey-David no ne zëëd xnëz Abraham. ");
INSERT INTO zpi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham nak xuz Isaac, Isaac nak xuz Jacob, Jacob nak xuz Judá yra bech Judá, ");
INSERT INTO zpi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá nak xuz Fares yrup Fares Zara, le xnaa men nak Tamar, Fares nak xuz Esrom, Esrom nak xuz Aram, ");
INSERT INTO zpi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram nak xuz Aminadab, Aminadab nak xuz Naasón, Naasón nak xuz Salmón, ");
INSERT INTO zpi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón nak xuz Booz, le xnaa Booz nak Rahab, Booz nak xuz Obed, le xnaa Obed nak Rut, Obed nak xuz Isaí, ");
INSERT INTO zpi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí nak xuz rrey-David, rrey-David nak xuz Salomón, le xnaa Salomón nak men ne wak xewnaa Urías. ");
INSERT INTO zpi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón nak xuz Roboam, Roboam nak xuz Abías, Abías nak xuz Asa, ");
INSERT INTO zpi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nak xuz Josafat, Josafat nak xuz Joram, Joram nak xuz Uzías, ");
INSERT INTO zpi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías nak xuz Jotam, Jotam nak xuz Acaz, Acaz nak xuz Ezequías, ");
INSERT INTO zpi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías nak xuz Manasés, Manasés nak xuz Amón, Amón nak xuz Josías, ");
INSERT INTO zpi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías nak xuz Jeconías yra bech Jeconías tyemp ne wzanofwers men-Babilonia men-Israel wyano men men Babilonia. ");
INSERT INTO zpi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nga ka men chene wal Salatiel xpee Jeconías. Salatiel nak xuz Zorobabel, ");
INSERT INTO zpi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel nak xuz Abiud, Abiud nak xuz Eliaquim, Eliaquim nak xuz Azor, ");
INSERT INTO zpi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor nak xuz Sadoc, Sadoc nak xuz Aquim, Aquim nak xuz Eliud, ");
INSERT INTO zpi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud nak xuz Eleazar, Eleazar nak xuz Matán, Matán nak xuz Jacob, ");
INSERT INTO zpi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob nak xuz Xeb xemgyeey Mli ne nak xnaa Jesus ne la ke Crist. ");
INSERT INTO zpi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chidaa ngwzan wuu kwlotee Abraham axtegue rrey-David, schidaa ngwzan wuu kwlotee rrey-David axtegue chene wzano men-Babilonia men-Israel ne wyano men men Babilonia, schidaa ngwzan wuu nga axtegue ne wal Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Zeree wak chene wal Jesucrist: Che nuu Mli xnaa Ne ne ytsëlnya men yrup men Xeb; per antes ne tsuu men yrup men, wakzhiin Mli por xpoder Espíritu Sant. ");
INSERT INTO zpi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kom kesentyent wen Xeb, wlaandet men nboo men xeblaan Mli; mazdee wlebleedx men nsalzaan men Mli ngueedxendxee. ");
INSERT INTO zpi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Zenga rlebleedx men chene wlalo te xangel Dëdyuzh lo men lo mkaal, re angel guin: ―Xeb ne zëëd xnëz David, ydxedet de ytsëlnyano de Mli, porke mëëd ne gap men, por xpoder Espíritu Sant wuu ne. ");
INSERT INTO zpi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Gap men te mëdbee, ynesela de ne JESUS, porke laa ne yselaa yra xpén ne lo xdol men. ");
INSERT INTO zpi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wak yra neree chen gak kumplir diiz ne re Dëdyuzh lo profet, laa we nga re: ");
INSERT INTO zpi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Gakzhiin te nzeb-benak, gap men te mëdbee ne sela Emanuel. Emanuel rna: Dëdyuzh zu kon laa be. ");
INSERT INTO zpi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Chene wruu mkaal lo Xeb, wlaa Xeb zegne wkyeen xangel Dëdyuzh Xeb. Wtsëlnya Xeb yrup Xeb Mli. ");
INSERT INTO zpi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Per wgaldetgue Xeb Mli axtegue ne wal xpëëd Mli. Lex wnesela Xeb ne JESUS. ");
INSERT INTO zpi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Chene wal Jesus Belén gyëz ne nak lo lyu ne la Judea, tyemp ne nak Herodes rrey, wdxiin txup tson mennan Jerusalén ne nuu nes ledne rlen ngbiz. ");
INSERT INTO zpi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Lex wnabdiiz men, re men: ―¿Gozh mëëd ne wal ne nak xerrey men-Israel? Porke wii noo wlen xpël ne gyeybaa nes ledne rlen ngbiz, neguin zëëd noo saknzoon noo ne. ");
INSERT INTO zpi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chene won rrey-Herodes neree, axtegue nandet men pe wuu lextoo men. Zenga ke wzak yrandxee men-Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Por neguin wbëz rrey yrandxee fxuz ne rnebééy lo yra fxuz no le yra maxter ley, lex wnabdiiz rrey lo men gan pazh nak ne gal Crist. ");
INSERT INTO zpi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lex re yra mén guin: ―Belén ne nak lo lyu ne la Judea gal Ne, porke zenga wkaa profet ledne re: ");
INSERT INTO zpi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Laa de Belén ne nak lo lyu ne la Judea, nakdet de te gyëz ne zhindxee non lo yra gyëz ne mazre nondee ne nak lo lyu guin. Porke wa yruu te mén ne ynebééy, laa men gapkwent yra xpén noo, men ne nak men-Israel. ");
INSERT INTO zpi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lex ngueedxendxee wbëz rrey-Herodes yra mennan guin wnabdiiz rrey-Herodes lo men gan pa tyemp tyempendxeezhe nak ne wii men wlen mël guin gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Lex wxaal rrey-Herodes men ne tsa men Belén, re rrey-Herodes lo men: ―Gutsa, ynabdizwen de gan pazh wal mëëd gwa; chene che wzël ne lo de, yluugue de diiz lo noo, chen no noo tsa saknzoon noo ne. ");
INSERT INTO zpi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wluzhse won men ne re rrey zenga, wka men nëz za men. Mël ne wii men wlen nes ledne rlen ngbiz, laa mël guin zaner lo men axtegue ne wdxiin mël guin ngali ledne nex mëëd guin, nga wzobtsë mël guin. ");
INSERT INTO zpi_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ne wii mennan guin ne wzobtsë mël guin, kesentyent wzhiilen men. ");
INSERT INTO zpi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chene wdee men ledne nuu mëëd guin, wii men ne yrup ne Mli xnaa ne; orguin wzuzhib men lo ne wzaknzoon men ne. Lex wxal men xkaj men wboo men or no wboo men ne nak zegnak yaal no le mirra wgueed meno lo ne. ");
INSERT INTO zpi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lex wnii Dëdyuzh lo men lo mkaal ne ybereedetre men nes ledne nuu Herodes. Por neguin nak ne wateedetre men nëz guin chene le men wberee ne sya men laz men. ");
INSERT INTO zpi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chene che sya mennan guin, wlalo te xangel Dëdyuzh lo Xeb lo mkaal, re angel guin: ―Gutsaxee, gulis mëëd yrup mëëd xnaa mëëd, gugya Egipto. Nga tsuu de axtegue ne yluu noo diiz lo de, porke skaye rrey-Herodes ne, chen yket rrey-Herodes ne. ");
INSERT INTO zpi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Lex waxee Xeb wlis Xeb ne yrup ne xnaa ne, gyëël ke guin wruu men sya men Egipto. ");
INSERT INTO zpi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nga wuu men axtegue ne wet rrey-Herodes. Wak neree chen gak kumplir xdiiz Dëdyuzh ne wkaa profet ledne re: “Wbëz noo XPee noo chen yruu me Egipto.” ");
INSERT INTO zpi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chene wyenen rrey-Herodes ne wkade mennan guin rrey-Herodes, kesentyent wlayaa rrey-Herodes. Lex wkyeen rrey-Herodes mén wa men waket men yrandxee mëdbee ne gardet luzh txup iz ne nuu Belén no ne nuu kbii Belén porke wboo men kwent ne re mennan guin lo men, che za we zeg txup iz ne wii men mël guin. ");
INSERT INTO zpi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Zenga wak kumplir diiz ne wkaa profet-Jeremías ledne re: ");
INSERT INTO zpi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Wlen te rëz gyëz-Ramá, baanske roon robtsaatee mén. Raquel nak mén guin ne kayoon por yra xpëëd men, no rlaandet men txu ynino men porke che wet yra xpëëd men. ");
INSERT INTO zpi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Per chene che wet rrey-Herodes, wlalo te xangel Dëdyuzh lo Xeb lo mkaal chene nuu Xeb Egipto, re ne: ");
INSERT INTO zpi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Gutsaxee, gulis mëëd yrup mëëd xnaa mëëd, guberee ke Israel, porke le yra mén ne wlaan nket mëëd che wet. ");
INSERT INTO zpi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Lex waxee Xeb wlis Xeb mëëd yrup mëëd xnaa mëëd, wberee ke Xeb Israel. ");
INSERT INTO zpi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Per chene waknan Xeb ne laa Arquelao xpee rrey-Herodes rnebééy lo lyu ne la Judea no ne laa men wyan nii xuz men, wdxe Xeb nya men nga; lex wnii Dëdyuzh lo Xeb lo mkaal ne gya men tsuu men lo lyu ne la Galilea, por neguin wya men lo lyu guin. ");
INSERT INTO zpi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chene wdxiin men nga, wa men wuu men gyëz ne la Nazaret. Wak neree chen gak kumplir diiz ne re profet ne men-Nazaret sela Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tyemp ke guin wa Xwa ne rtxobnis wzëët Xwa xdiiz Dëdyuzh denbidx ne nak lo lyu ne la Judea, ");
INSERT INTO zpi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","re Xwa: ―Gusaan xgyelmal de, porke che wyob gak ne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Laa xkwent Xwaree nga wkaa profet-Isaías chene re men: Te rëz rlen denbidx, re we: “Gulaxnëz xnëz Men ne rnebééy, guxal te nëz ne tebli.” ");
INSERT INTO zpi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kon xgyits kamey nzhexkwaa xab Xwa, le sinturon ne ruu txu Xwa nak gyed, le ne ru Xwa nak miich no le dxin ne nuu den. ");
INSERT INTO zpi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Lex rruu men-Jerusalén no le yra mén ne nuu ydendxee lo lyu ne la Judea no le yra men nuu kbii rugyow-Jordán, ra men ron men ne rzëët Xwa. ");
INSERT INTO zpi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Lex rxobdol men, rluzh nga rtxobnis Xwa men rugyow-Jordán. ");
INSERT INTO zpi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Per chene wyenen Xwa ne ndal men ne nak farisew no le men ne nak sadusew ra lo Xwa chen yrobnis men, nan Xwa lo men: ―¡Xerras mëël! ¿Txu na lo de ne yláá de lo gyelentozroo ne zëdyob? ");
INSERT INTO zpi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xnëz gugak chen gaknyoo ne nli che wsaan de xgyelmal de, ");
INSERT INTO zpi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","no ydxindet de ne gue de lo xkompanyer de: “Xnëz Abraham zëëd be”; porke yna noo lo de yra de ne axtegue gyeree zun Dëdyuzh gan ylaa Dëdyuzho men ne zëëd xnëz Abraham. ");
INSERT INTO zpi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Che list zu gyibyag ne txuug axtegue ydeblu yag; yrandxee yag ne rkaadet nexwen lo, txuugo, tsa we lo gyi. ");
INSERT INTO zpi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Noo noze kon nis rtxobnis noo de yra de chen gaknyoo ne che wsaan de xgyelmal de; per le men ne gyed zëëd, kon Espíritu Sant ytxobnis men de no le kon gyi. Axtegue ni xgyël men rzëëldet noo tsano noo lo men porke mazre rapdee men poder ke lo noo. ");
INSERT INTO zpi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","No nzen men ne ylanya men zhobxtil, koo men zhobxtil lad xgyizho, lex gutsoow meno; le xgyizho tsa lo gyi ne nunk gyuudet. ");
INSERT INTO zpi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Cheguin ke wruu Jesus lo lyu ne la Galilea wa Ne rugyow-Jordán ledne ka Xwa, chen ytxobnis Xwa Ne, ");
INSERT INTO zpi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","per nadet Xwa, re Xwa lo Ne: ―Laa de ryal ytxobnis noo, lel laa de zëëd lo noo ne ytxobnis noo de. ");
INSERT INTO zpi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wke Jesus, re Ne: ―Gutxobnis noo, porke rap be degne gun be kumplir yrandxee ne rkyeen Dëdyuzh. Orguin wna Xwa wtxobnis Xwa Ne. ");
INSERT INTO zpi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wluzh wrobnis Ne, wruugue Ne lo nis, tebegue wyal gyeybaa, wii Ne zëdtseeb Espíritu Sant zegnak te mëër, wyab Espíritu Sant led Ne, ");
INSERT INTO zpi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","no wlen te rëz gyeybaa, re we: ―Laa XPee noo nee ne ryaan noo no ne kesentyent rnesak lextoo noo. ");
INSERT INTO zpi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lex wano Espíritu Sant Jesus denbidx chen ylaa Bzelo Ne preb gan pe slaa Ne dol. ");
INSERT INTO zpi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nga wkaa Ne txuplal gbiz txuplal gyëël wudet Ne, zhich guin wlen wlaanen Ne. ");
INSERT INTO zpi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Lex wa Bzelo lo Ne, re Bzelo: ―Belne nli XPee Dëdyuzh nak de, gukyeen yra gye gwa gako gyëtxtil. ");
INSERT INTO zpi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wke Ne re Ne: ―Lo xgyiich Dëdyuzh re: “Let noncheedet por gyëtxtil ybán mén, sinke no ke por yrandxee xdiiz Dëdyuzh.” ");
INSERT INTO zpi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Lex wano Bzelo Ne Jerusalén, wlep Bzelo Ne xtoo xeydoo Dëdyuzh ledne mazre gyadee. ");
INSERT INTO zpi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Lex re Bzelo lo Ne: ―Belne nli XPee Dëdyuzh nak de, gutsas nee, gugyab lyu, porke lo xgyiich Dëdyuzh re: Dëdyuzh yxaal xangel chen gapkwent xangel Ne de. Ylisgya xangel Ne de kon nya xangel Ne chen tsakadet gye nii de. ");
INSERT INTO zpi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Wke Ne re Ne: ―Laake re ke lo xgyiich Dëdyuzh: “Ylaadet de preb XDëdyuzh de.” ");
INSERT INTO zpi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Wluzh nga wano Bzelo Ne te xtoo gyeey ne kesentyent gya, lex wluu Bzelo yrandxee gyëz ne nak lo gyëzlyu lo Ne no le yrandxee ne non ne nuu lo gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Lex re Bzelo lo Ne: ―Noo yniiz yrandxee negwa lo de belne suzhib de lo noo saknon de noo. ");
INSERT INTO zpi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wke Ne re Ne: ―Gubetxee lo noo Bzelo, porke lo xgyiich Dëdyuzh re: “Nonchee XDëdyuzh de gusaknon, no nonchee ne rkyeen Ne gulaa.” ");
INSERT INTO zpi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Orguin wbetxee Bzelo lo Ne. Lex wdxiin tebëd angel wdee ne wu Ne. ");
INSERT INTO zpi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chene waknan Jesus ne le Xwa che nuu chegyiib, wberee ke Ne lo lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Per wadetre Ne nyuu Ne Nazaret, sinke le Ne wa wuu Capernaum ne nak guex runis nes Zabulón no nes Neftalí, ");
INSERT INTO zpi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","chen gak kumplir diiz ne wkaa profet-Isaías ledne re: ");
INSERT INTO zpi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Xelyu Zabulón no le xelyu Neftalí ne ryan nes runis no ne ryan stebkoo gyow-Jordán, Galilea ledne nuu mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mén ne wak zegnak men ne mbán lo nkeb, le men che wii te bninzhoo; mén ne zadet xnëz Dëdyuzh, bnii guin che rzenii xgyeryen men yra men. ");
INSERT INTO zpi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kwlote nga wzelo Jesus wzëët Jesus xdiiz Dëdyuzh lo mén, re Ne: ―Gusaan xgyelmal de porke che wyob gak ne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Chene za Jesus tebrunis-Galilea, wii Ne Simon men ne la ke Bëd yrup men Ndrizh bech men, katxoon men xgyix men lo nis porke gozmël rkaa men. ");
INSERT INTO zpi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Lex re Ne lo men: ―Gutanal noo; noo ylaa ne ylaa de mén xpén Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Orgueguin wsan men xgyix men, zanalgue men Ne. ");
INSERT INTO zpi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Lex wzaa Ne stebla, wii Ne yrubech xpee Zebedew, Jacob no le Xwa, kalaxnëz men xgyix men yra men xuz men lenbark. Lex wbëz Ne men, ");
INSERT INTO zpi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","orgueguin wsan men bark no wsan men xuz men, zanal men Ne. ");
INSERT INTO zpi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ydendxee lo lyu ne la Galilea wa Jesus waneluu Ne mén lenydoo te te gyëz ne wa Ne, wzëët Ne zegne rkyeen Dëdyuzh no wneseyaken Ne yrandxee mén ne rzak kwaskyertee gyelgyiz no le gyelerzebyoob. ");
INSERT INTO zpi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ydendxee Siria ruu mén xdiiz Ne, lex rdxiin men lo Ne rdxinno men yrandxee mén ne baanske rlaa, mén ne rzak kwaskyertee gyelgyiz, mén ne rzak gyelerzebyoob, mén ne nuu menzab lextoo, mén ne rzak gyiz ne ngyidet, mén ne noze waknet led; wneseyaken Ne men yrandxee men. ");
INSERT INTO zpi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kesentyent ndalyaa mén wa wanal Ne, men-Galilea, men-Decápolis, men-Jerusalén, men-Judea, no le yra mén ne nuu stebkoo gyow-Jordán. ");
INSERT INTO zpi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chene wii Jesus ne kesentyent ndalyaa mén zanal Ne, wyeep Ne xtoo gyeey wzob Ne. Lex wbig yra xpén Ne lo Ne, ");
INSERT INTO zpi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","wzelo Ne wneluu Ne men, re Ne: ");
INSERT INTO zpi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Nzoon yra mén ne ryenen ne rkyiin ne gun Dëdyuzh xyudar men, porke por laa men nak ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Nzoon yra mén ne nles nuu lextoo, porke Dëdyuzh ydee diiz lo men. ");
INSERT INTO zpi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Nzoon yra mén ne ndoo, porke skakwent men lyu ne re Dëdyuzh ydee Ne lo men. ");
INSERT INTO zpi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Nzoon yra mén ne kesentyent rlaan ylaa ne rkyeen Dëdyuzh zegne rzak men ne rlaanen no zegne rzak men ne rlaan nis, porke laa Ne gaknonen men chen gun men gan ylaa meno. ");
INSERT INTO zpi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Nzoon yra mén ne rap lextoo semén, porke zap ke lextoo Dëdyuzh men. ");
INSERT INTO zpi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Nzoon yra mén ne rlaadet dol, porke swii men Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Nzoon yra mén ne rye gan pezee ybán men ndxi yra men semén men, porke laa men nak ne sela zhiin Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Nzoon yra mén chene rzakzi mén men por ne rlaa men ne rkyeen Dëdyuzh, porke por laa men nak ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Nzoon de yra de chene rninyaan mén lo de no chene rkye men de no chene noze yralondxee ne rkagyii men de por ne rlaleedx de noo. ");
INSERT INTO zpi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Guzhiilen, nzoon guguu lextoo de, porke kesentyent non ne yniiz Dëdyuzh lo de chene ydxiin de gyeybaa. Porke laake zegwa wzakzi mén yra profet ne wuu kwlodee ke lo de. ");
INSERT INTO zpi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Laa de yra de nak zegnak zëd nee gyëzlyuree; per belne gaknzhidetro, ¿pezee gak gaknzhi we ste? Batre ykyiindeto, noze yzhe we, noze gyichnii méno. ");
INSERT INTO zpi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Laa de yra de nak bnii nee gyëzlyuree. No laa de nak zegnak te gyëzroo ne nak te xtoo gyeey ne gakdet gyidxlaan. ");
INSERT INTO zpi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Zenga ke nak te bnii, rkaadet méno, lex ytosenruu men te kaj lo we, sinke rzobgya meno chen yzenii we lo yra mén ne nuu lenyuu. ");
INSERT INTO zpi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Zenga ke laa de yra de, gugak zegnak te bnii lo mén chen chene kwii mén ne wen rlaa de, saknon men Dëdyuzh Xuz be ne zob gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Tsuudet lextoo de ne noo zëëd ygyitxee ley ne wdee Dëdyuzh lo Moises no le ne wneluu profet. Noo zëëdet noo por ne ygyitxee noo we, sinke le noo zëëd chen gako kumplir. ");
INSERT INTO zpi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Porke nligue yna noo lo de yra de ne myentras ne nuu gyeybaa no le gyëzlyu, rut ygyitxeedet ni te punt ni te leter ne zëëd lo ley axtegue ne gak yra ne rap degne gak. ");
INSERT INTO zpi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Por neguin mén ne rlaadet te ne zëëd lo ley ne wdee Dëdyuzh lo Moises, mase mazre winendxoo no zenga ke rneluu meno lo mén, laa mén guin zhindxee gaknon ledne rnebééy Dëdyuzh. Per le mén ne rlaa yrandxee ne zëëd lo ley no zenga ke rneluu meno lo mén, laa mén guin nak ne mazre gaknondee ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Por neguin yna noo lo de yra de, belne laa de ne ybándet de mazre xnëzdee ke lo yra maxter ley no le ke lo yra men ne nak farisew, ydxiindet de ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Laa de yra de che nan de ne re Dëdyuzh lo xpenkwlal de: “Yketet de mén, porke men ne rket mén tesudet ne sakzi men.” ");
INSERT INTO zpi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per noo yna noo lo de ne kwaskyertee mén ne rlayaa lo semén, tesudet ne sakzi men; mén ne rninyaan lo semén, tesudet ne ybig men lo xtis-Israel; mén ne nan lo semén, “men bat rkyiindet”, tesudet ne gya men lo gyi linfyeren. ");
INSERT INTO zpi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Por neguin chene zasan de xgoon de lo fkuuk, lex nga rnileedx de ne rlaa xkompanyer de lo de por logne wlaa de men, ");
INSERT INTO zpi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nga yxob xgoon de nes lo fkuuk, primer tsa de ynab de perdon lo xkompanyer de ne rlaa lo de. Lex yberee de guu xgoon de lo fkuuk. ");
INSERT INTO zpi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Belne nuu mén rdxig de lo xtis, guye gan pezee gyan de diiz yrup de men antes ne ydxig men de lo xtis; porke belne ydekwent men de lo xtis, sdekwent xtis de lo polisi, chen ysee men de chegyiib. ");
INSERT INTO zpi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nligue yna noo lo de, ne yruudet de chegyiib axtegue ne gyizh de laltee ne ynab xtis lo de. ");
INSERT INTO zpi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Laa de yra de che nan de ne re lo ley: “Ykanodet de mén ne nakdet lzaa de.” ");
INSERT INTO zpi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per yna noo lo de ne kwaskyertee men ne rlaangue ykano wnaa zegne rwii men lo men, reey men dol ne la adulterio por ne rlebleedx men zenga. ");
INSERT INTO zpi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Belne bzalobëë de rlaa ne ryab de lo dol, gukoo we, gusee we nat. Porke mazre wendee gak perdid te bzalo de, ke ne tsuu de yde de linfyeren. ");
INSERT INTO zpi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No belne nyabëë de rlaa ne ryab de lo dol, gutxuugo, gusee we nat. Porke mazre wendee gak perdid te nya de, ke ne tsuu de yde de linfyeren. ");
INSERT INTO zpi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’No che nan ke de ne re lo ley: “Kwaskyertee mgyeey ne rchil xgyeltsëlnya yrup men xewnaa men, rap degne xexkwaa te gyiich ydee men lo xewnaa men ne che wsalzaan men men.” ");
INSERT INTO zpi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per yna noo lo de ne mgyeey ne rchil xgyeltsëlnya yrup men xewnaa men, belne nakdeto por ne wkano xewnaa men ste mgyeey, laake men rlag xewnaa men lo dol ne la adulterio. Zenga ke mgyeey ne rtsëlnya wnaa ne che wbil xgyeltsëlnya, laake reey ke men dol ne la adulterio. ");
INSERT INTO zpi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’No che nan ke de ne re Dëdyuzh lo xpenkwlal de: “Ygondet de Dëdyuzh noze xla, sinke gugun kumplir logne che re de ne ylaa de.” ");
INSERT INTO zpi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per noo yna noo lo de yra de: Bet ygondet de, ygondet de gyeybaa porke nga zob Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni ygondet de gyëzlyu porke lo we zu nii Ne, ni ygondet de Jerusalén porke nga nak laz rrey ne mazre nondee, ");
INSERT INTO zpi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ni ygondet de xtoo de porke ni te gyitsxtoo de gundet de gan ylaa do ne ngyich o ne ngas. ");
INSERT INTO zpi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mazdee gugue nli we belne nli we, gugue nlideto belne nlideto, porke yra diiz ne rniir de, Bzelo rsegyee lextoo de ne rlaa do. ");
INSERT INTO zpi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Laa de yra de che nan de ne re lo ley: “Mén ne koo bzalo de, gukoo ke bzalo men; mén ne koo leey de, gukoo ke leey men.” ");
INSERT INTO zpi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per noo yna noo lo de: Ychereedet de ne mal ne rlaa semén de de; belne nuu mén gap gyedkwes de ladbëë, gucheree stebkoo we gap men. ");
INSERT INTO zpi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No belne nuu mén rtsëldil de ne rgyitxee men xlërmank de, gudee si ygyitxee men no xlërmanknaal de. ");
INSERT INTO zpi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Belne lafwers rkyeen mén de gweey de yúú lal ne yna men, gugweeyo txup lal nga. ");
INSERT INTO zpi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kwaskyertee mén ne pe rnab lo de, gudee we; mén ne zëëd lebkyaan lo de, gudee we, gyaandet do. ");
INSERT INTO zpi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’No che nan ke de ne re lo ley: “Gugyaan mén ne ryaan de, no gukwinyaan mén ne rwinyaan de.” ");
INSERT INTO zpi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per noo yna noo lo de: Gugyaan mén ne rwinyaan de, no gunab lo Dëdyuzh por mén ne kanal de ne yzakzi men de, ");
INSERT INTO zpi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","chen zenga gak de zhiin Dëdyuzh Xuz be ne zob gyeybaa; porke laa Ne rlaa ne rlen ngbiz ne rzenii lo menwen menmaltee no laa Ne rlaa ne ryab gyo por mén ne xnëz mbán no por mén ne xnëzdet mbán. ");
INSERT INTO zpi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Porke belne ryaan de nonchegue mén ne ryaan de, ¿pagox yniiz Dëdyuzh lo de belne zenga nak de? Axtegue men ne rgoob zeg impwest rlaa zenga. ");
INSERT INTO zpi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","No belne rgabtyuzh de nonchegue xkompanyer de, ¿pe ne wenzhe rlaa de? Axtegue mén ne rlaleedxdet Dëdyuzh rlaa zenga. ");
INSERT INTO zpi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Xnëz gugak yra de zegne xnëz nak Dëdyuzh Xuz be ne zob gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Gugapkwent ylaadet de ne wen nes lo mén noze por ne kwii men ne rlaa de. Porke belne ylaa de zenga, bet yniizdet Dëdyuzh Xuz be ne zob gyeybaa lo de. ");
INSERT INTO zpi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Por neguin chene rdee de ne rkyiinen men ne rzak lyaaz, gudet de diizo zegne rlaa men ne noze rkanlo wen lenydoo no le runëz chen saknon mén men. Nligue yna noo lo de yra de, nonchee ne rzaknon mén men nak ne wun men gan. ");
INSERT INTO zpi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Por neguin chene rdee de ne rkyiinen men ne rzak lyaaz, gudet de diizo ni lo mén ne nak mazre xmigdee de, ");
INSERT INTO zpi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","chen zenga rut gaknandet ne run de xyudar men. Lex laa Dëdyuzh Xuz be ne rwii ne rlaa de ne ngueedx yniiz ne ryal de. ");
INSERT INTO zpi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Chene rnab de lo Dëdyuzh, ylaadet de zeg rlaa men ne noze rkanlo wen ne rtseleedx rzuli rnab lo Dëdyuzh lenydoo no le skin nëz, chen kwii mén ne rlaa men. Nligue yna noo lo de yra de, nonchee ne rzaknon mén men nak ne wun men gan. ");
INSERT INTO zpi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Per le laa de chene rnab de lo Dëdyuzh, gutee lenxyuu de, gutsëë we; lex gunab lo Dëdyuzh porke nga zu Ne yrup Ne de, laa Ne yniiz ne ryal de, porke mase ngueedx rlaa do, per rwii Ne neguin ne kalaa de. ");
INSERT INTO zpi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’No chene rnab de lo Dëdyuzh, guedet de diiz ne bat rkyiindet ne gue de laake laako zegne rlaa mén ne zadet xnëz Dëdyuzh, porke nuu lextoo men por ne kesentyent rnii men mazre tsulyaaz Dëdyuzh men. ");
INSERT INTO zpi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ylaadet de zegne rlaa men, porke che nan Dëdyuzh gan pe rkyiinen de yra de antes ne ynab do lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Por neguin chene rnab de lo Dëdyuzh, zeree gugue: Dëde, laa de ne zob de gyeybaa, kesentyent nzoon la de. ");
INSERT INTO zpi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gak zegne rkyeen de. Gak zegne rlaan de nee gyëzlyuree zegne rak ko gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Guseleedx ne gu noo yzaandxee dxe. ");
INSERT INTO zpi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gugun perdon yra xdol noo zegne run noo perdon yra ne mal ne rlaa mén noo. ");
INSERT INTO zpi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ydeedet de si ylaa noo ne mal, sinke gukoo noo lo ne mal. Porke ydeblo siguelendxee rnebééy de, rap de poder, nzoon de. Zengaw. ");
INSERT INTO zpi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Porke belne laa de ne run de perdon yra ne mal ne rlaa mén de, laake zun Dëdyuzh Xuz be ne zob gyeybaa de perdon. ");
INSERT INTO zpi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Per belne laa de ne rundet de perdon yra ne mal ne rlaa mén de, laake gundet ke Dëdyuzh de perdon. ");
INSERT INTO zpi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Chene rkwan de por ne rzaknon de Dëdyuzh, ytsownlesdet lo de zegne rlaa yra men ne noze rkanlo wen, porke yra mén guin rtsownles lo men chen gyenen mén ne rkwan men. Nligue yna noo lo de, nonchee ne rzaknon mén men nak ne wun men gan. ");
INSERT INTO zpi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Per le laa de chene rkwan de, gusul xtoo de no gugaa lo de ");
INSERT INTO zpi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","chen gyenden mén ne rkwan de, sinke nonchee Dëdyuzh gaknano porke nga zu Ne yrup Ne de, lex laa Ne yniiz ne ryal de. ");
INSERT INTO zpi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Yedet de gan pezee gapbëë gapduxtee de ne non ne nuu gyëzlyuree, ledne rluzh mlaa we, ledne rzhiino no ledne rdee ngbaan rbaano. ");
INSERT INTO zpi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mazre wendee guye gan pezee gap de ne non ne nuu gyeybaa, ledne rluzhdet mlaa we, ledne rzhiindeto no ledne rdeedet ngbaan kwano. ");
INSERT INTO zpi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Porke ledne nuu ne mazre nondee por laa de, nga ke nak ledne mazre zadee lextoo de. ");
INSERT INTO zpi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Bzalo me nak zegnak te bnii led me; belne wen bzalo me, ydendxee led me nak zegnak ledne nyenii. ");
INSERT INTO zpi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Per belne ngyidet bzalo me, ydendxee led me nak zegnak ledne nkeb. Belne ngyidet bnii guin, ¡pe zhidese gaknkebyaas! ");
INSERT INTO zpi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Rut gakdet ylaa dxiin lo txup patron, porke swinyaan men te men, le ste men gyaan men, o gakwen men lo men te men, le ste men ylaandet men. Zenga ke laa de yra de, gakdet ylaa de dxiin lo Dëdyuzh no sobleedx ke de med. ");
INSERT INTO zpi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Por neguin yna noo lo de yra de: Bet tsadet lextoo de gan pe gu de, gan pe goo de chen ybán de, ni por lër ne gak de. Porke gyelembán nak ne mazre nondee ke lo ne ru me no led me nak ne mazre nondee ke lo xab me. ");
INSERT INTO zpi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gukwii zegnak maa ne rzhobee lo mee; rguudet ma bni, ni rkaadet ma kwlaap, ni yëten ma ledne tsutsoowo, no rseleedx Dëdyuzh Xuz be ne zob gyeybaa logne ru maa. ¿Pe let laadet de yra de nak ne nondee ke lo maa? ");
INSERT INTO zpi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","No ¿txu laa de ne kesentyent rlebleedx gun gan ytsowngoolre xgyelembán? ");
INSERT INTO zpi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Penak za xab de lextoo de? Gukwii pezee rroo gyeden; rlaadeto dxiin, ni rzhexkwaadeto lër, ");
INSERT INTO zpi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","no yna noo lo de, ni rrey-Salomón mase mazre zhaandxee wnaa xab men, per wnaadet men zegne rnaa gyee guin. ");
INSERT INTO zpi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Belne zenga rlazhaandxee Dëdyuzh gyizh ne nuu den nedxeree, le yzhe le we che ke reeky leen oren, ¡peleske laa de ne ygakxabdet Dëdyuzh de, ake mén ne rlaleedxdet Dëdyuzh ydeblextoo! ");
INSERT INTO zpi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Por neguin bet tsadet lextoo de ne gue de: “¿Kosleg gu be? ¿Kosleg goo be? ¿Pa saaleg xab be?” ");
INSERT INTO zpi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Porke mén ne zadet xnëz Dëdyuzh, yra neree nak ne za lextoo men; per le laa de yra de, rap de Dëdyuzh Xuz be ne zob gyeybaa ne nan ne rkyiinen de yra neree. ");
INSERT INTO zpi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Per primer guye gan pezee ylaa de ne rkyeen Dëdyuzh no gan pezee ylaa de zegne rlaan Dëdyuzh, lex laa Ne yseleedx yra neree lo de. ");
INSERT INTO zpi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Por neguin bet tsadet lextoo de gan pe ykyiinen de yzhe, gusano por yzhe, porke te te dxe rap rapo xelyaazo. ");
INSERT INTO zpi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Yleedxdet de semén de, chen ylaadet ke Dëdyuzh gyelextis lo de. ");
INSERT INTO zpi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porke zegne rleedx de semén de, zenga ke ylaa Dëdyuzh gyelextis lo de; zegne rlaa de semén de, zenga ke ylaa Dëdyuzh de. ");
INSERT INTO zpi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Penak rwii de yuwin ne nuu bzalo semén de no ryenden de ne nzhoodee bled ne nuu bzalo de? ");
INSERT INTO zpi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Pezee ryezh de ne nan de lo semén de: “Gudee si koo noo yuwin ne nuu bzalo de”, no ryenden de ne nzhoodee ne nuu bzalo de? ");
INSERT INTO zpi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Gugannaa laa de wen! Primer gukoo bled ne nuu bzalo de, chen gak kwii de wen chen koo de yuwin ne nuu bzalo semén de. ");
INSERT INTO zpi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ylebaadet de ne nakleey lo mëëk, tegue ybig ma noze ylabyu maa de, no ylebaadet de ne non lo kuch, tegue noze gyichnii ma we. ");
INSERT INTO zpi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Gunab lo Dëdyuzh, laa Ne yseleedx ne rnab de; guye Ne, sël Ne lo de; gukanya txuyaglaa, sxal Ne yaglaa tee de. ");
INSERT INTO zpi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porke men ne rnab lo Ne, laa Ne rseleedx ne rnab men; men ne rye Ne, rzël Ne lo men; men ne rkanya txuyaglaa, sxal Ne yaglaa tee men. ");
INSERT INTO zpi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Zegnak laa de yra de, ¿peguin nuu de rdee te gye lo zhiin de chene rnab ne gyëtxtil lo de? ");
INSERT INTO zpi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿U pe rdee de te mëël lo ne chene rnab ne mël lo de? ");
INSERT INTO zpi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Laa de yra de mase mal de no nan de rdee de ne wen lo zhiin de, ¡peleske Dëdyuzh Xuz be ne zob gyeybaa ne ydeedet ne wen lo men ne rnab lo Ne! ");
INSERT INTO zpi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Por neguin gugak lo mén zegne rlaan de ne gak men lo de, porke zenga zëëd lo ley ne wdee Dëdyuzh lo Moises no zenga ke zëëd lo gyiich ne wkaa yra profet. ");
INSERT INTO zpi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Gutee nes ruyaglanzun. Porke ruyaglanzhen no nëz ne nzhen nak ne rdxiin linfyeren, no ndalyaa mén za nëz guin. ");
INSERT INTO zpi_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Per le ruyaglanzun no nëz ne nzun nak ne rdxiin ledne nuu gyelembán ne nunk luzhdet, no zhindxee mén rzël nëz guin lo. ");
INSERT INTO zpi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Gugap kwent yra mén ne rkade ne nan xprofet Dëdyuzh nak men. Porke noze rkanlo men ndoo men zegnak mëkzhiil, per le por lenlextoo men nak men zegnak lob ne rlaanen. ");
INSERT INTO zpi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Snebeey de men por logne rlaa men. Porke rkaadet ub lo lbagyëts, ni rkaadet ig lo yaggyëts. ");
INSERT INTO zpi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Por neguin yrandxee yagwen, nexwen rkaa lo we; le yag ne ngyidet, ngyidet ke nex ne rkaa lo we. ");
INSERT INTO zpi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Rkaadet nex ne ngyidet lo yagwen, ni rkaadet nexwen lo yag ne ngyidet. ");
INSERT INTO zpi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yrandxee yag ne rkaadet nexwen lo, rruugo ra we lo gyi. ");
INSERT INTO zpi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Zenga ke nak men ne rkade, snebeey de men por logne rlaa men. ");
INSERT INTO zpi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Let yradet mén ne nan lo noo: “Dechey, Dechey”, tee ledne rnebééy Dëdyuzh, sinke nonchee mén ne rlaa ne rlaan Dëdyuzh Xuz noo ne zob gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Chene ydxiin dxe guin, ndalyaa mén yna lo noo: “Dechey, Dechey, wzëët noo diiz ne wguu de lextoo noo, no por la de wboo noo menzab lextoo mén, no por la ke de wlaa noo ndal gyelmilaguer.” ");
INSERT INTO zpi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cheguin gue noo lo men: “Axtegue rnebeeydet noo de; gubetxee lo noo, mendol.” ");
INSERT INTO zpi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Por neguin kwaskyertee men ne ron neree ne rzëët noo no rlaa meno, nak men zegnak te mén ne nuu xgyeryen ne wlep xyuu led gye. ");
INSERT INTO zpi_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","No mase kesentyent wyab gyo, waknaal nis gyoow no wlen mee, wasobo txu yuu guin, no watxeedeto porke led gye nex xsimyento. ");
INSERT INTO zpi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Per le men ne ron neree ne rzëët noo no rlaadet meno, nak men zegnak te mén ne yëtet xgyeryen ne wlep xyuu noze lo yuzh. ");
INSERT INTO zpi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lex chene wyab gyo, waknaal nis gyoow no wlen mee, wasobo txu yuu guin, watxee we axtegue ni xbeeyo wyandet. ");
INSERT INTO zpi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chene wluzh wnii Jesus, wzee wzak yra mén por yra ne wneluu Ne. ");
INSERT INTO zpi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Porke wneluu Ne zegnak te men ne rnebééy, wneluudet Ne zegne rneluu maxter ley. ");
INSERT INTO zpi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Chene wyët Jesus xtoo gyeey guin, ndalyaa mén wanal Ne. ");
INSERT INTO zpi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lex wbig te mén ne rzak gyiz ne la lepra, wzuzhib men lo Ne, re men: ―Dechey, belnaal yna de zun de gan yneseyaken de noo. ");
INSERT INTO zpi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Orguin wzegaa Ne nya Ne wtee No led men, re Ne: ―Sna noo. Gugyaken. Orgueguin wyaken led mén guin. ");
INSERT INTO zpi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lex re Ne lo men: ―Che nan de rut lo guedet do, nonchee lo fxuz gutsa gutsaluu led de no gutsaron xgoon de zegne zëëd lo ley ne wdee Dëdyuzh lo Moises chen gaknan mén ne che wyaken led de. ");
INSERT INTO zpi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Zegne wdee Jesus lenlgyëz-Capernaum, wbiggue te kapitan-Roma wnab men fabor lo Ne, ");
INSERT INTO zpi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","re men: ―Dechey, le xmos noo nex ruyuu rzhuun men, baanske rlaa men, noze waknet led men. ");
INSERT INTO zpi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Lex re Ne lo men: ―Noo tsaneseyaken men. ");
INSERT INTO zpi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wke kapitan, re kapitan: ―Dechey, rzëëldet noo ne tsa de axtegue ruxyuu noo; nozguestee gukyeen ne gyaken xmos noo, laa ne gyaken men nga. ");
INSERT INTO zpi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Porke no ke noo rap mén ne rnebééy lo noo, no rap ke noo mén ne rnebééy noo lo. Chene nan noo lo men te men ne tsa men mandad, ra men; chene nan noo lo men ste men ne chiid men lo noo, rdxiid men; chene nan noo lo xmos noo: “Gulaa neree”, rlaa meno. ");
INSERT INTO zpi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ne won Jesus ne re kapitan zenga, wzee wzak Ne, lex re Ne lo yra mén ne zanal Ne: ―Nligue yna noo lo de ne ni Israel gardet ytsëlo noo ni te mén ne rlaleedx noo zegne rlaleedx ménree noo. ");
INSERT INTO zpi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","No yna noo lo de yra de ne sdxiin ndalyaa mén ne nuu ydendxee gyëzlyu sob men gu men yra men Abraham, Isaac, no le Jacob ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Per le yra mén ne ryal nyuu ledne rnebééy Dëdyuzh, yxaal Ne men fwer lo nkeb ledne goon men axtegue guleey men. ");
INSERT INTO zpi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lex re Jesus lo kapitan: ―Gugya ruxyuu de; gak zegne wlaleedx de. Orgueguin wyaken xmos kapitan. ");
INSERT INTO zpi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Lex wa Jesus ruxyuu Bëd, wii Ne le xnasweguer Bëd nex lo loon rlen men xlaa. ");
INSERT INTO zpi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Lex wnëëz Ne nya men, wruugue xlaa led men; orgueguin waxee men wdee men ne wu Ne yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chene wnit lyu, wano mén ndal mén ne nuu menzab lextoo lo Jesus, tendxee diiz wnii Ne wboo Ne menzab lextoo men, no wneseyaken Ne yrandxee mén ne rzhuun, ");
INSERT INTO zpi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","chen gak kumplir diiz ne wzëët profet-Isaías chene re men: “Laa Ne wgyitxee xgyelenyaan be no le xgyelgyiz be.” ");
INSERT INTO zpi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ne wii Jesus ne ndalyaa ndalduxtee mén ndxin kbii Ne, re Ne lo xpén Ne: “Yoo tekaa be stebkoo nis.” ");
INSERT INTO zpi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lex wbig te maxter ley lo Ne, re men: ―Maxter, sanal noo de ledne tsatee de. ");
INSERT INTO zpi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Lex re Ne lo men: ―Mëëz rap ma xebluu maa, maa ne rzhobee rap ma xeftxëës maa; per le Men ne wdxiid wak Mén, yëten men ni ledne gyix xtoo men. ");
INSERT INTO zpi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Zhich guin re te xpén Ne lo Ne: ―Dechey, primer gudee si tsa noo gugyeer noo xuz noo, lex sanal noo de. ");
INSERT INTO zpi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wke Ne re Ne lo men: ―Gutanal noo; gudee si gugyeer mengut semengut mengut. ");
INSERT INTO zpi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Lex wdee Jesus lenbark yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Chene che za bark, tebegue wlen te meroo meduxtee lo nis, axtegue ryoots bark nis; le Jesus nexguees. ");
INSERT INTO zpi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lex wa xpén Ne wboo men mkaal lo Ne, re men: ―¡Dechey, guselaa be! ¡Le be zazebgyët! ");
INSERT INTO zpi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wke Ne re Ne: ―¿Penak kesentyent rdxe de? ¡Ake mén ne rlaleedxdet Dëdyuzh ydeblextoo! Wluzhse re Ne zenga, waxee Ne wakndux Ne lo meroo guin no le lo nis; wutsëgoo. ");
INSERT INTO zpi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kesentyent wzee wzak yra xpén Ne, rnabdizlsaa men, re men: ―¿Pezee nakleg ménree ne axtegue mee, axtegue nis ron xdiiz men? ");
INSERT INTO zpi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chene wdxiin Jesus stebkoo nis lo xelyu men-Gadara, lad baa wruu txup mgyeey ne nuu menzab lextoo, za men zatsëlo men Ne. Axtegue ni te mén rakdet tee nes guin, tant ndxeeb rlaa men. ");
INSERT INTO zpi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Zegne wii men Jesus, wzelo menzab rderëz menzab, re menzab: ―¿Penak rgal de noo, Jesus XPee Dëdyuzh? ¿Pe zëëd de nee ne yzakzi de noo antes ne ydxiin dxe? ");
INSERT INTO zpi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nes guin ndxin ndal kuch ka ma gwdu. ");
INSERT INTO zpi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Lex wnab menzab lo Jesus, re menzab: ―Belne rboo de noo, gudee si tsa noo tee noo lextoo yra kuchro. ");
INSERT INTO zpi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Wke Ne re Ne: ―¡Gutsa! Orguin wruu menzab lextoo yrup mgyeey guin, watee menzab lextoo yra kuch guin. Wzelo ma wzhoon maa wxenxtoo maa te ruyúú, wyab ma axtegue lo nis. Nga wobkyiky ma nis, wet maa. ");
INSERT INTO zpi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Orguin wzhoon yra mén ne rapkwent kuch guin; chene wdxiin men lenlgyëz, wzelo men wuu men diiz yra neguin ne wak no ne wzak mgyeey ne nuu menzab lextoo. ");
INSERT INTO zpi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lex wruu yrandxee mén ne nuu gyëz guin za men ledne zu Jesus. Chene wii men Ne, wnab men lo Ne ne yruu Ne xden men. ");
INSERT INTO zpi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Lex wdee Jesus lenbark, wdekaa Ne stebkoo nis wdxiin Ne ledne nuu Ne. ");
INSERT INTO zpi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nga wdxiin mén lo Ne, wdxinneey mén te mgyeey ne noze waknet led, zhoob men te lo lonwin. Ne wii Ne ne rlaleedx yra mén guin Ne, re Ne lo mengyiz guin: ―Bet tsadet lextoo de zhiin, le xdol de che wak perdon. ");
INSERT INTO zpi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Orguin nuu lextoo tebëd maxter ley: “Diizree ne re ménree, diznyaan rnii men por Dëdyuzh.” ");
INSERT INTO zpi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Per kom nan Jesus gan pe nuu lextoo men, re Ne lo men: ―¿Penak rzaa ne mal lextoo de? ");
INSERT INTO zpi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Pe mazre mbëëdee gue noo lo men: “Le xdol de che wak perdon”, u ne gue noo: “Gutsaxee, gugya”? ");
INSERT INTO zpi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Orree kwii de yra de gante ne Men ne wdxiid wak Mén rap men poder nee gyëzlyuree por ne gun men perdon xdol mén. Lex re Ne lo mengyiz guin: ―Gutsaxee gulis xloon de, gugya ruxyuu de. ");
INSERT INTO zpi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Orguin waxee mén guin sya men ruxyuu men. ");
INSERT INTO zpi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ne wii yra mén neguin ne wak, wdxe men, wzelo men wzaknzoon men Dëdyuzh por ne wdee Dëdyuzh poder guin lo mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chene wruu Jesus nga ne sya Ne, wii Ne te men ne la Mdëw, zob men ledne rgoob men zeg impwest, lex re Ne lo men: ―Gutanal noo. Orguin wzuli men zanal men Ne. ");
INSERT INTO zpi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Te chene zob Jesus ruxyuu Mdëw yra Ne xpén Ne, zob Ne lo mezh zobyu Ne yra Ne tebëd men ne rgoob zeg impwest no le stebëd mendol. ");
INSERT INTO zpi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ne wii yra men ne nak farisew neguin, re men lo yra xpén Ne: ―¿Penak ru xmaxter de yra men men ne rgoob zeg impwest no le yra men mendol? ");
INSERT INTO zpi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ne won Jesus ne re men zenga, re Ne lo men: ―Men ne ngyëël, rkyiinden men doctor, sinke men ne rzhuun, men guin rkyiinen doctor. ");
INSERT INTO zpi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gugya, guseed gan pe rna ne ka lo xgyiich Dëdyuzh ledne re: “Logne rlaan noo nak ne yles lextoo de semén de, lugar ne rket de maa lo fkuuk.” Noo zëëdet noo zëdye noo menwen, sinke le noo zëdye mendol chen ysaan men xgyelmal men. ");
INSERT INTO zpi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lex wbig xpén Xwa ne rtxobnis, re men lo Jesus: ―Noo yra noo no yra men ne nak farisew, kesentyent rkwan noo rudet noo chene rnab noo lo Dëdyuzh, le xpén de, ¿penak rkwandet men? ");
INSERT INTO zpi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Wke Jesus, re Ne: ―Lo te dooy, ¿peguin zak noze nles kwiin xemyooz nobye myentras ne benak zu nobye lo men? Per sdxiin dxe ne ybetxee nobye lo men; cheguin si ykwan men. ");
INSERT INTO zpi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Rut rkadaadet tebla lërkweb led te lëryuux, porke rdop lërkweb, lex rtxëzo lëryuux, mazre raknzhoodee ledne wrëz. ");
INSERT INTO zpi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni rgaadet mén binkweb lengyedyuux, porke belne ylaa men zenga, srëz gyedyuux, nigle xiin bin, nigle xiin gyed. Por neguin leen ke gyedkweb taa binkweb, chen zenga ni tebo xiindet. ");
INSERT INTO zpi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Or ne re Jesus zenga lo men yra men, wdxiin te mén ne rnebééy lenydoo, lex wzuzhib men lo Jesus, re men: ―Le xsaap noo wluzhlo orree, per yoo tsa be yxob nya de led nzeb, sban nzeb. ");
INSERT INTO zpi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Orguin wzuli Ne zanal Ne men yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Lex wdxiin te wnaa ne rzhuun, che wzaa chibtxup iz ryab men ren, lex wbig men nes zhich Ne wtee nya men luzh xab Ne, ");
INSERT INTO zpi_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","porke nuu lextoo men: “Naal pezee maske nonchee ytee nya noo led xab mén gwa, laa ne gyaken noo nga.” ");
INSERT INTO zpi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Per wcheree lo Ne wii Ne lo men, lex re Ne: ―Bet tsadet lextoo de zhiina; por ne wlaleedx de noo, wyaken de. Orgueguin wyaken men. ");
INSERT INTO zpi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chene wdxiin Jesus ruxyuu mén guin ne rnebééy, wii Ne ne le musk che ndxin rool, noze rakrëz mén roon mén. ");
INSERT INTO zpi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Lex re Ne lo yra mén guin: ―Guruu lo leey. Wetet nzaapree, noze nexguees nzeb. Orguin wzhidxno yra mén guin Ne, ");
INSERT INTO zpi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","per chene che wruu men lo leey, wdee Ne, lex wnëëz Ne nya nzaap guin, waxee nzeb. ");
INSERT INTO zpi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ydendxee nes guin wrëëts diiz neguin ne wak. ");
INSERT INTO zpi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chene wruu Jesus nga, wrunal txup menngwlëë Ne, rkarëz men Ne, re men: ―¡XPee David, gules lextoo de noo! ");
INSERT INTO zpi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Chene wdxiin Ne ruyuu ledne nuu Ne, wbig yrup menngwlëë guin lo Ne; lex wnabdiiz Ne lo men, re Ne: ―¿Pe rlaleedx de ne zun noo gan gyenii bzalo de? Wke men re men: ―Rlaleedx noo we, Dechey. ");
INSERT INTO zpi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Lex wtee nya Ne bzalo men, re Ne: ―Por ne rlaleedx de ne zun noo gan gyenii bzalo de, gyenii we. ");
INSERT INTO zpi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Orgueguin wyenii bzalo men. Lex re Ne lo men: ―Rut lo guedet de gan pezee wyenii bzalo de. ");
INSERT INTO zpi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per nonchegue wruu men nga, wzelo men wuu men diiz ydendxee nes guin neguin ne wlaa Ne. ");
INSERT INTO zpi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Zegne wruu yrup mén guin lo Jesus, wdxinnogue mén te menngup ne nuu menzab lextoo lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Zegne wboo Ne menzab lextoo menngup guin, wzelogue men wnii men. Kesentyent wzee wzak yrandxee mén, lex re men: ―¡Nunk gardet kwii be klas gyelmilaguerree Israel! ");
INSERT INTO zpi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per le yra men ne nak farisew re: ―Bzelo ne rnebééy lo yra menzab rdee poder lo ménree ne rboo men menzab lextoo mén. ");
INSERT INTO zpi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Wa Jesus yrandxee gyëznzhoo no le rya gyëzwin, wneluu Ne mén lenydoo te te ledne wa Ne, wzëët Ne zegne rkyeen Dëdyuzh no wneseyaken Ne yrandxee mén ne rzak kwaskyertee gyelgyiz no le gyelerzebyoob. ");
INSERT INTO zpi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Chene wii Ne ndalyaa ndalduxtee mén, wles lextoo Ne men, porke nles rlaa men, nak men zegnak mëkzhiil ne yët gan txu gapkwent. ");
INSERT INTO zpi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Lex re Ne lo yra xpén Ne: ―Nli ne ndalyaa mén ne rlaan gon xdiiz Dëdyuzh nuu, per yëtet ndal mén ne yzëëto lo men. ");
INSERT INTO zpi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Por neguin gunab lo Dëdyuzh chen yxaalre Dëdyuzh mén ne yzëëto lo men. ");
INSERT INTO zpi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Lex wbëz Jesus yra chibtxup xpén Ne, wdee Ne poder lo men chen koo men menzab lextoo mén no chen yneseyaken men yrandxee mén ne rzak kwaskyertee gyelgyiz no le gyelerzebyoob. ");
INSERT INTO zpi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Laa yra la chibtxup poxter nee: mén primer nak Simon ne la ke Bëd, no le Ndrizh bech Bëd, no le Jacob no le Xwa (Xpee Zebedew nak Jacob yrup Jacob Xwa.), ");
INSERT INTO zpi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","no le Blib, no le Bartolomé, no le Tmazh, no le Mdëw ne rgoob zeg impwest, no le Jacob xpee Alfeo, no le Lebeo ne la ke Tadeo, ");
INSERT INTO zpi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","no le Simon men ne nak cananist, no le Judas Iscariote ne wdekwent Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Antes ne yxaal Jesus yra chibtxup xpén Ne, re Ne lo men: ―Tsadet de nes ledne nuu mén ne nakdet men-Israel, ni tsateedet de gyëz ne nak Samaria; ");
INSERT INTO zpi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","mazdee gutsa lo men-Israel ne nak zegnak mëkzhiil ne che wyab, ");
INSERT INTO zpi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","yzëët de lo men ne che wyob gak ne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yneseyaken de mengyiz, yneban de mén ne che wet, yneseyaken de mén ne rzak gyiz ne la lepra, koo de menzab lextoo mén. Laa de yra de noze weeden de poderree, zenga ke bet gobdet de ne ylaa de yra neree. ");
INSERT INTO zpi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Bet med gweeydet de, ni med or, ni med plat, ni med kober, ");
INSERT INTO zpi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni gweeydet de bols por nëz, ni ste xab de, ni xgyël de, ni baston. Porke mén ne rlaa dxiin ryal ne ydee mén ne gu men. ");
INSERT INTO zpi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Chene ydxiin de te gyëznzhoo yra de o te gyëzwin, ynabdiiz de gan txu nak men wen, nga ykaa de ruxyuu mén guin axtegue ne yruu de gyëz guin. ");
INSERT INTO zpi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Zegne tee de lenyuu, ygabtyuzh de yra mén ne nuu yuu guin, gue de lo men: “Gyelendxi wlenza lenyuuree.” ");
INSERT INTO zpi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Belne neden men gyelendxi guin, por laa men nako, per belne nedendet meno, por laake de yra de nako. ");
INSERT INTO zpi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Belne nuu gyëz o yuu ne ylaandet mén kwii men de ni ylaandet men gon men ne rzëët de, yruu de nga, kwib de guxyudi nii de zegnak te beey ne nadet mén guin nyon men ne wzëët de. ");
INSERT INTO zpi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nligue yna noo lo de yra de ne chene ydxiin dxe ne ylaa Dëdyuzh gyelextis, ntozdee sakzi yra mengyëz guin ke lo men-Sodoma no ke lo men-Gomorra. ");
INSERT INTO zpi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","No re Jesus lo men: ―Gugon neree ne yna noo lo de, yxaal noo de yra de zegnak mëkzhiil lad lob. List gugak zegnak mëël, ndoo gugak zegnak mëër. ");
INSERT INTO zpi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gugap kwent porke sdekwent mén de lo xtis, no sniiz men xkwent de lenxeydoo men. ");
INSERT INTO zpi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","No axtegue sdxig men de lo gobernador no le lo rrey por ne nak de xpén noo, zenga gak gu de xdiiz noo lo men yra men no le lo mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Per chene ydekwent men de lo xtis, bet tsadet lextoo de gan pe gue de o pezee gue de, porke chene ydxiin orguin ne ynii de, Dëdyuzh yseleedx diiz ne gue de. ");
INSERT INTO zpi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Porke let laadet de nak ne ynii, sinke XEspíritu Dëdyuzh Xuz be nak ne ynii por laa de yra de. ");
INSERT INTO zpi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’No laake bech mén ydekwent bech mén chen yket mén bech men, laake ngwzan ydekwent zhiin ngwzan, laake zhiin ngwzan til ngwzan no ylaa zhiin ngwzan ne yket mén ngwzan. ");
INSERT INTO zpi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kwinyaan yrandxee mén de por ne rzëët de xdiiz noo, per men ne ysalzaandet xdiiz noo ydeblo ne ybán men, men guin nak ne yláá. ");
INSERT INTO zpi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chene ykanal mén de te gyëz, yzhoon de nga tsa de ste gyëz. Nligue yna noo lo de ne ni gardet gyal yrandxee gyëz ne nak Israel tsa de, chiid Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ni te mén ne benak rseed nondet mazre ke lo xmaxter men; ni te mos nondet mazre ke lo xpatron men. ");
INSERT INTO zpi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Men ne rseed rap men degne gyan men byen gak men zegnak xmaxter men, le mos rap men degne gyan men byen gak men zegnak xpatron men. Belne Beelzebu rnii mén noo, ¿pezee yniileg mén de yra de ne nak de xpén noo? ");
INSERT INTO zpi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Por neguin ydxedet de mén. Porke bet ne ngueedx yët ne yrunyoodet, ni yët ne rak rlaanguel ne gaknandet mén. ");
INSERT INTO zpi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Logne rzëët noo ngueedxendxee lo de yra de, guzëëto lo mén, no logne rzëët noo rlaanguel lo de, ndíp guzëëto lo yra mén. ");
INSERT INTO zpi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ydxedet de mén ne rap poder yket de, waldegue bet gundet men gan ylaa men no xanem de. Mazdee gudxe Dëdyuzh ne rluzh kwerp no ne yxaal ke anem linfyeren. ");
INSERT INTO zpi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Laa de yra de nan de ne txup mgyinwin rdoo por te medwin, no ni te ma retet belne rdeedet Dëdyuzh si ne guet maa. ");
INSERT INTO zpi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Le laa de yra de, axtegue gyitsxtoo de yrandxoo ngab lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Por neguin ydxedet de, porke laa de nondee ke lo ndal mgyinwin. ");
INSERT INTO zpi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Mén ne rzëët lo mén ne xpén noo nak men, laake no noo yzëët lo Xuz noo ne zob gyeybaa ne xpén noo nak men. ");
INSERT INTO zpi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Per le mén ne rzëëdet lo mén ne xpén noo nak men, laake no noo yzëëdet lo Xuz noo ne zob gyeybaa ne xpén noo nak men. ");
INSERT INTO zpi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Tsuudet lextoo de ne gyelendxi zëdneey noo gyëzlyu; zëdneeydet noo gyelendxi, sinke le noo zëdneey dil. ");
INSERT INTO zpi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Por ne rlaleedx mén noo, til semén men men: mëdbee tilno xuz, le mëdgwnaa tilno xnaa, le ngwzhizh tilno xnasweguer. ");
INSERT INTO zpi_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Zenga gak, laake xfamilye men tilno men. ");
INSERT INTO zpi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Men ne ntozdee ryaan xuz o ryaan xnaa ke lo noo, rzëëldet gak men xpén noo; no men ne ntozdee ryaan xpee o xsaap ke lo noo, rzëëldet gak men xpén noo. ");
INSERT INTO zpi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Men ne zëdnal noo, per rlaandet men gak men sufrir, rzëëldet gak men xpén noo. ");
INSERT INTO zpi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Men ne rkaa xgyelembán lextoo, zako perdid; per le men ne rboleedx xgyelembán por ne nak men xpén noo, zap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Men ne tsukas de yra de, noo nga tsukas men; men ne rukas noo, Xuz noo nga ne wxaal noo zëëd noo rukas men. ");
INSERT INTO zpi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Men ne rukas te profet por ne nak profet guin profet, ne ryal ke profet guin gyal men; men ne rukas te men ne xnëz mbán por ne xnëz mbán men guin ne xnëz mbán, ne ryal ke men guin ne xnëz mbán gyal men. ");
INSERT INTO zpi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","No kwaskyertee mén ne ydee mase nonchee tebas nisnyag goo men ne nak xpén noo, nligue yna noo lo de yra de ne che nuu ne gun mén guin gan. ");
INSERT INTO zpi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Chene wluzh wzëët Jesus lo yra chibtxup xpén Jesus gan gonezhe nak ne ylaa men, wruu Ne nga waneluu Ne no wazëët Ne xdiiz Dëdyuzh yra gyëz ne nak nes guin. ");
INSERT INTO zpi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Chegyiib nuu Xwa ne rtxobnis ne won Xwa diiz yra ne kalaa Jesus, lex wxaal Xwa tebëd xpén Xwa, ");
INSERT INTO zpi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","chen ynabdiiz men lo Ne, gue men: ―¿Pe laa de nga nak ne nuu diiz ne chiid u rap noo degne ykambë́z noo ste mén? ");
INSERT INTO zpi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Wke Jesus, re Ne lo men: ―Gutsa gue de lo Xwa logne rwii de, logne ron de. ");
INSERT INTO zpi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","No gu de diiz lo Xwa ne le menngwlëë che rwii, le mennguzh che rzawen, le men ne rzak gyiz ne la lepra che wyaken, le mennkwëët che wyenii gyedyag, le men ne che wet le men che wban, le lo yra menprob che rakzëët xdiznzoon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nzoon men ne ysalzaandet ne rlaleedx men noo. ");
INSERT INTO zpi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chene che sya yra mén guin ne wanabdiiz lo Jesus, wzelo Ne wzëët Ne xkwent Xwa lo yra mén, re Ne: ―¿Pagox wa de wii denbidx? ¿Pe te gobkyii ne rlaa mee zere zerotee wa de wii? ");
INSERT INTO zpi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿U pagox wa de wii? ¿Pe te mén ne zhaandxee rnaa xab wa de wii? Laa de yra de nan de ne men ne zhaandxee rnaa xab ruxyuloow rrey ndxin men. ");
INSERT INTO zpi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Guex neguin, ¿txu wa de wii? ¿Pe te profet wa de wii? Nli we, yna noo lo de, te men ne mazre nondee ke lo te profet wa de wii. ");
INSERT INTO zpi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Laa men nga rakzëët lo xgyiich Dëdyuzh ledne re: Noo yxaal te mén ne saner lo de chen ylaxnëz men xnëz de. ");
INSERT INTO zpi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nligue yna noo lo de yra de ne delo lo yrandxee mén, ni te men ne mazre nondee ke lo Xwa ne rtxobnis gardet tsuu; per mase zenga, mén ne zhindxee non ledne rnebééy Dëdyuzh, men guin nak ne mazre nondee ke lo Xwa. ");
INSERT INTO zpi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Desde dxe ne wzelo Xwa ne wtxobnis Xwa mén axtegue nedxeree, wzelo menmal wtsëldil men xdiiz Dëdyuzh, noze lafwers wlaan men nsoow men ne nyakzëëdeto. ");
INSERT INTO zpi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yrandxee profet che wzëët ne rkyeen Dëdyuzh no rakzëët ko lo ley ne wdee Dëdyuzh lo Moises axtegue ne le Xwa wdxiid, le we wak kumplir. ");
INSERT INTO zpi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Belne rlaan de ylaleedx de neree ne yzëët noo lo de, laa Xwa nga nak profet-Elías ne che nuu diiz chiid. ");
INSERT INTO zpi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Men ne rkagyedyag diiz, gon men neree ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Pagox ynesaglo noo mén ne nuu naaree? Rzaglo men minwin ne rkaa wkyit lenlgyeey no ne rkarëzlsaa, ");
INSERT INTO zpi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","nan miin: “Wool noo flawt yra noo, per wyadet de. Nles wolbaan noo, per woondet de.” ");
INSERT INTO zpi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Porke wdxiid Xwa ne rtxobnis, wudet men yralondxee ne ru mén, ni woodet men bin, no re de yra de ne menzab nuu lextoo men. ");
INSERT INTO zpi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Orrenaa zëëd Men ne wdxiid wak Mén, ru men, roo men, no re de, laa men kesentyent ru rootee, laa men rtsëlsaa mendol no laa men rtsëlsaa men ne rgoob zeg impwest. Per xgyelenyenii Dëdyuzh raknyoo we por yra ne rlaa mén ne nak xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Lex wzelo Jesus wakndux Ne lo yra mén ne nuu gyëz ledne che wlaa Ne ndal gyelmilaguer, porke rsaandet yra men guin xgyelmal men, re Ne: ");
INSERT INTO zpi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Prob de men-Corazín! ¡Prob de men-Betsaida! Porke belne lad men-Tiro no le lad men-Sidón nyak gyelmilaguer ne wak lad de yra de, che penaadese wsaan men xgyelmal men naa, nbonyoo meno nyak men lër ne rak mén ne ruu gyelgut no ndxiib men di xtoo men. ");
INSERT INTO zpi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Per yna noo lo de yra de ne chene ydxiin dxe ne ylaa Dëdyuzh gyelextis, ntozdee sakzi de ke lo men-Tiro no ke lo men-Sidón. ");
INSERT INTO zpi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Laa de naa men-Capernaum, ¿pe nuu lextoo de ne gyeybaa gya de? ¡Lel axtegue linfyeren gya de! Porke belne lad men-Sodoma nyak gyelmilaguer ne wak lad de, benak nak gyëz guin axtegue naaree. ");
INSERT INTO zpi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Per yna noo lo de yra de ne chene ydxiin dxe ne ylaa Dëdyuzh gyelextis, ntozdee sakzi de ke lo men-Sodoma. ");
INSERT INTO zpi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Cheguin ke re Jesus: ―Dëde, laa de ne rnebééy de gyeybaa gyëzlyutee, rzaknon noo de porke wluu de lo men ne nandet yra ne wluudet de lo mennan no lo men ne rdee kwent xgyeryen. ");
INSERT INTO zpi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nli we Dëde, wlaa do, porke zenga wlaan de ne gako. ");
INSERT INTO zpi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Zhich guin re Ne lo xpén Ne: ―Laa Xuz noo wniiz yrandxee kos lo noo chen ynebééy noo we. Rnebeeydet mén noo, nonchee Xuz noo rnebeey noo; rnebeeydet mén Xuz noo, nonchee noo rnebeey me, no le men ne rlaan noo ne ynebeey me. ");
INSERT INTO zpi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yra men ne che wzaguen no ne che wyëëden, chiid men lo noo, noo ylaa ne yne men. ");
INSERT INTO zpi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gulaa ne rkyeen noo de no guseed ylaa de zegne rlaa noo, porke noo wen noo no ndoo noo, chen yne lextoo de. ");
INSERT INTO zpi_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Porke ngandet ne ylaa de ne rkyeen noo, no gyëëten de ylaa do. ");
INSERT INTO zpi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Cheguin ke wdee Jesus ledne nuu zhobxtil yra Ne xpén Ne dxe ne rne men-Israel. Kom rlaanen xpén Ne, wzelo men wkyiits men xebzun zhobxtil, wboo men zhobxtil wu men. ");
INSERT INTO zpi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chene wii yra men ne nak farisew neguin, re men lo Ne: ―Gukwii, le yra xpén de kalaa ne ndux ylaa be dxe ne rne be. ");
INSERT INTO zpi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Wke Ne re Ne: ―¿Pe gardet gool de lo xgyiich Dëdyuzh ledne re ne wlaa David chene wlaanen zhaa yra zhaa xkompanyer zhaa? ");
INSERT INTO zpi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wdee zhaa lenxeydoo Dëdyuzh, wu zhaa gyëtxtil ne nakleey yra zhaa xkompanyer zhaa, no ndux gu zhaa gyëtxtil guin, nonchee fxuz rak ru we. ");
INSERT INTO zpi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿U pe gardet gool de lo ley ne wdee Dëdyuzh lo Moises ne let doldet rlaa fxuz dxiin lenxeydoo Dëdyuzh dxe ne rne be? ");
INSERT INTO zpi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yna noo lo de yra de ne nee zu te men ne nondee ke lo ydoo. ");
INSERT INTO zpi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Belnaal ne ndee de kwent gan pe rna ne re lo xgyiich Dëdyuzh ledne re: “Logne rlaan noo nak ne yles lextoo de semén de, lugar ne rket de maa lo fkuuk.” Belne ndee de kwento, nkagyiidet de mén ne bet xdoldet. ");
INSERT INTO zpi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gugaknan ne Men ne wdxiid wak Mén rak ke rnebééy men dxe ne rne be. ");
INSERT INTO zpi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Zhich guin wruu Jesus nga, wdee Ne lenydoo. ");
INSERT INTO zpi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lenydoo guin zu te mgyeey ne miitx te nya. Kom rye men ne nak farisew gan pezee ykagyii men Jesus, lex wnabdiiz men lo Ne, re men: ―¿Pe zak yneseyaken me te mengyiz dxe ne rne me? ");
INSERT INTO zpi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Wke Jesus, re Ne: ―Belne nuu de te de rap te mëkzhiil, lex gyab ma te leen pos dxe ne rne be, ¿pe tsaloodetgue de maa? ");
INSERT INTO zpi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Si nondee te mén ke lo te mëkzhiil. Por neguin zak ylaa me ne wen dxe ne rne me. ");
INSERT INTO zpi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lex re Ne lo mgyeey guin ne miitx nya: ―Guzegaa nya de. Zegne wzegaa meno, wakwengoo, wyan ko zegnako stebo. ");
INSERT INTO zpi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lex wruu yra men ne nak farisew nga, wzelo men wye men gan pezee yket men Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chene waknan Jesus logne rlebleedx yra mén guin, wruu Ne nga. Ndalyaa mén wanal Ne, no wneseyaken Ne yra mén ne rzhuun, ");
INSERT INTO zpi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","no re Ne lo men ne rut lo gudet men diiz gan txu nak Ne. ");
INSERT INTO zpi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Wak neree chen gak kumplir ne re profet-Isaías chene re men: ");
INSERT INTO zpi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Laa ménree nak ne wye noo ne ylaa xdxiin noo, ryaan noo men. Laa men nak ne rzak lextoo noo. Lo men yseleedx noo XEspíritu noo, chen yzëët men lo yrandxee mén ne slaa noo gyelextis. ");
INSERT INTO zpi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tildet men mén, ni terëzdet men mén, no rut gondet xrëz men ne le men kaderëz mén runëz. ");
INSERT INTO zpi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","No bet ylaadet men mén ne nak zegnak gobkyii ne che wrëz, ni bet ylaadet men mén ne nak zegnak gyeer ne che nonchee guux rlen lo, axtegue ne gun men gan gak gyelextis zegne ryal gako. ");
INSERT INTO zpi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lo men ykalo yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Zhich guin wdxinno mén te mgyeey ne nuu menzab lextoo lo Jesus; ngup men no ngwlëë men. Lex wneseyaken Ne men ne le men wak wii no ne le men wak wnii. ");
INSERT INTO zpi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wzee wzak yrandxee mén, wzelo men re men: ―¿Peguin laa XPee David nee? ");
INSERT INTO zpi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ne won men ne nak farisew zenga, re men: ―Beelzebu ne rnebééy lo menzab rdee poder lo ménree ne rboo men menzab lextoo mén. ");
INSERT INTO zpi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Per kom nan Jesus gan pe rlebleedx men, lex re Ne lo men: ―Yrandxee gobyeren ne rdil laake xpén, rdiidet gobyeren guin; no yrandxee gyëz o familye ne rdilelsaa, laake rdiidet men. ");
INSERT INTO zpi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Zenga ke, belne laake Bzelo rboo sebzelo Bzelo lextoo mén, laake Bzelo rdil Bzelo. ¿Pezee ydii ne rkyeen Bzelo? ");
INSERT INTO zpi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Belne Beelzebu rniiz poder lo noo ne rboo noo menzab lextoo mén, ¿txu rdee poder lo xpén de ne rboo men menzab lextoo mén? Por neguin laake men rbonyoo ne nlidet rnii de. ");
INSERT INTO zpi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Per belne por XEspíritu Dëdyuzh rboo noo menzab lextoo mén, neguin rna ne le ne rkyeen Dëdyuzh che kayak lad de yra de. ");
INSERT INTO zpi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Porke ¿pezee gun mén gan tee men lenxyuu te mgyeey ne ndíp por ne gweey men yra ne rap mgyeey guin, belne yliibdet men mgyeey guin primer? Per belne yliib men men, zenga si zun men gan gweey men yra ne rap mgyeey guin. ");
INSERT INTO zpi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Men ne nuudet xfabor noo, rwinyaan men noo; men ne ryedet gan pezee ydaalre xpén noo, rnexoon men xpén noo. ");
INSERT INTO zpi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Por neguin yna noo lo de yra de ne zak perdon yrandxee xdol mén no yrandxee diznyaan ne rnii men, per le men ne rnii diznyaan por Espíritu Sant, nunk gakdet xdol men perdon. ");
INSERT INTO zpi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Men ne rnii diznyaan por Men ne wdxiid wak Mén, zak men perdon; per le men ne rnii diznyaan por Espíritu Sant, nunk gakdet men perdon ni naaree ni chene ylaa Dëdyuzh gyelextis. ");
INSERT INTO zpi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Yagwen, wen nex ne rkaa lo we, per le yag ne ngyidet, ngyidet ke nex ne rkaa lo we. Porke yag ryakbeeyo por nex ne rkaa lo we. ");
INSERT INTO zpi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Xerras mëël! ¿Pezee ynii de dizwen si menmal nak de yra de? Porke yra diiz ne rzaa lextoo me, laa we rlen ruu me. ");
INSERT INTO zpi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Menwen, dizwen rnii men porke ne wen nuu lextoo men; le menmal, dizmal rnii men porke ne mal nuu lextoo men. ");
INSERT INTO zpi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Yna noo lo de yra de ne chene ydxiin dxe ne ylaa Dëdyuzh gyelextis, yrandxee mén ydee kwent lo Ne por yra diiz ne bat rkyiindet ne wnii men. ");
INSERT INTO zpi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Porke por xdiiz ke de nak ne gyakbeey gan pe nuu xdol de o yëtet xdol de chene ylaa Dëdyuzh gyelextis. ");
INSERT INTO zpi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Lex re tebëd men ne nak farisew lo Jesus no le tebëd maxter ley: ―Maxter, rlaan noo kwii noo ne ylaa de te gyelmilaguer. ");
INSERT INTO zpi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Wke Jesus, re Ne lo men: ―Menmal ne zadet xnëz Dëdyuzh rnab lo noo ne ylaa noo te gyelmilaguer, per betre gyelmilaguer kwiidet men, nonchee zegne wzak profet-Jonás kwii men. ");
INSERT INTO zpi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Porke zegne wuu Jonás tson gbiz tson gyëël leen te mëlnzhoo, zenga ke tsuu Men ne wdxiid wak Mén tson gbiz tson gyëël lenlyu. ");
INSERT INTO zpi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Chene ylaa Dëdyuzh gyelextis, yban yra men-Nínive, gue men ne rzëël sakzi yra men ne nuu naaree; porke wsaan men-Nínive xgyelmal men chene wzëët Jonás xdiiz Dëdyuzh lo men; nee zu te men ne mazre nondee ke lo Jonás. ");
INSERT INTO zpi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","No chene ylaa Dëdyuzh gyelextis, yban wnaa ne wak rrey nes Sur, gue men ne rzëël sakzi yra men ne nuu naaree. Porke kesentyent nat wruu wnaa guin wdxiid men won men logne re rrey-Salomón porke kesentyent nan rrey-Salomón; nee zu te men ne mazre nondee ke lo rrey-Salomón. ");
INSERT INTO zpi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Chene rruu menzab lextoo mén, zad tsu menzab ledne noze mbidx rkaye menzab ledne yne menzab, per rzëldeto. ");
INSERT INTO zpi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Lex nuu lextoo menzab: “Mazdee yberee ke noo ledne wruu noo.” Chene rberee menzab, nak mén guin zegnak te yuu ne nlat ne noze nexnloob no ne noze xnëz xnëzske nak. ");
INSERT INTO zpi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Lex ra menzab raxii menzab sguedx menzab ne mazre ntozdee nak ke lo menzab guin; yra menzab zenga ra rdee lextoo mén guin; mazre ntozdee rak men ke ne nak men chekwlo. Zenga ke sak yra menmalree ne nuu naaree. ");
INSERT INTO zpi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Benak kanii Jesus lo mén, chene wdxiin xnaa Ne yra men bech Ne, rlaan men ynii men lo Ne. Kom fwer zu men, ");
INSERT INTO zpi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","lex waluu te mén diiz lo Ne, re men: ―Le xnaa de no le yra bech de zu fwer, rlaan men guno men de diiz. ");
INSERT INTO zpi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Per wke Ne re Ne lo men ne waluu diiz lo Ne: ―¿Txu nak xnaa noo? ¿Txu nak bech noo? ");
INSERT INTO zpi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Lex wluu Ne yra xpén Ne, re Ne: ―Ménree nak xnaa noo no nak bech noo. ");
INSERT INTO zpi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porke yrandxee mén ne rlaa ne rlaan Xuz noo ne zob gyeybaa, mén guin nak bech noo no nak bzaan noo no nak xnaa noo. ");
INSERT INTO zpi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dxe ke guin wruu Jesus ruyuu, wa Ne wzob Ne runis. ");
INSERT INTO zpi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kom kesentyent ndal mén wdop lo Ne, lex wdee Ne lenbark wzob Ne, le yra mén wyan runis. ");
INSERT INTO zpi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Lex wzelo Ne wzëët Ne ndal diiz lo men zegnak te kwent, re Ne: ―Te dxe wruu te mén ne rguu bni, zalabni men zhobxtil. ");
INSERT INTO zpi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Chene kalaal meno, nuu we wyab nëz; lex wyab mgyin wu ma we. ");
INSERT INTO zpi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nuuzego wyab lad gye ledne yëtet ndal yu; wlengoo por ne yëtet ndal yu lad gye guin. ");
INSERT INTO zpi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Per chene wlen ngbiz, wzeey ngbizo; kom yëtet ndal lu we, wbidxo. ");
INSERT INTO zpi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nuuzego wyab lad lbagyëts; wroo lbagyëts, wket lbagyëtso. ");
INSERT INTO zpi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Per nuuzego wyab ledne wen lyu, kesentyent wako; nuu we wak tebgwyuu zhob, nuuzego wak tsonlal zhob, nuuzego wak galebchii zhob. ");
INSERT INTO zpi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Men ne rkagyedyag diiz, gon men neree ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Lex wbig yra xpén Jesus lo Ne, re men: ―¿Penak rzëët de xdiiz Dëdyuzh lo mén zegnak te kwent? ");
INSERT INTO zpi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wke Ne re Ne: ―Laa de yra de, Dëdyuzh wniiz si ne gaknan de logne ngueedx ne rkyeen Ne, per le yra ménree wdeedet Ne si ne gaknan meno. ");
INSERT INTO zpi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Porke men ne che rdee kwent pezee rnebééy Dëdyuzh, laa Ne ylaa ne mazre ydee men kwento no kesentyent ydee men kwento. Per le men ne rdeedet kwento, axtegue ne chendxee rdee men kwent, ydeedetre men kwento. ");
INSERT INTO zpi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Por neguin rzëët noo we lo men zegnak te kwent, porke rwii men, per nak men zegnak mén ne rwiidet; ron men diiz, per nak men zegnak mén ne bet rondet, ni rdeedet men kwento. ");
INSERT INTO zpi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Neree ne kazak men rak kumplir diiz ne re profet-Isaías chene re men: Mase mazre ykagyedyag men diiz, per ydeedet men kwento; mase mazre kwii men, per bet gyenden men. ");
INSERT INTO zpi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porke yra ménree wakndíp lextoo men; rtsëë gyedyag men chen gondet men diiz, no rtsëë bzalo men, chen kwiidet men, ni ykagyedyagdet men diiz, ni ydeedet men kwento, ni ysaandet men xgyelmal men chen gakdet yselaa noo men lo xdol men. ");
INSERT INTO zpi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Per le laa de yra de nzoon de, porke rwii de neree no ron de neree. ");
INSERT INTO zpi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nligue yna noo lo de ne ndal profet no ndal mén ne wbán xnëz wlaan nwii neree ne rwii de yra de, per wiidet meno, no wlaan men nyon men neree ne ron de, per wondet meno. ");
INSERT INTO zpi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Gugon ne rna xkwent mén ne rguu bni. ");
INSERT INTO zpi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Men ne ron xdiiz Dëdyuzh no rdeedet men kwento, mén guin nak zegnak zhobbni ne wyab nëz; rdxiin Bzelo rboo diiz guin ne che nuu lextoo men. ");
INSERT INTO zpi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Le zhobbni ne wyab lad gye nak zegnak mén ne ron xdiiz Dëdyuzh; rzhiilen men ron meno, ");
INSERT INTO zpi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","per kom nak men zegnak ne yëtet ndal lu, rundet men wantar; chene le men pe rzak o chene rwinyaan mén men por ne rlaleedx men xdiiz Dëdyuzh, rsalzaangue men ne rlaleedx meno. ");
INSERT INTO zpi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Le zhobbni ne wyab lad lbagyëts nak zegnak mén ne ron xdiiz Dëdyuzh, per por ne mazre za yra ne nuu gyëzlyuree lextoo men no por ne rbode ne non ne nuu gyëzlyuree men, neguin rlaa ne le men rsalzaan xdiiz Dëdyuzh, rdeedeto si ylaa men ne wen. ");
INSERT INTO zpi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Per le zhobbni ne wyab ledne wen lyu, nak zegnak mén ne ron xdiiz Dëdyuzh, rdee men kwento, lex rlaa men ne wen. Nuu men nak zegnak te zhobbni ne wak tebgwyuu zhob, nuuzeg men nak zegnak te zhobbni ne wak tsonlal zhob, nuuzeg men nak zegnak te zhobbni ne wak galebchii zhob. ");
INSERT INTO zpi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wzëët Jesus zegnak ste kwent lo men, re Ne: ―Ne rkyeen Dëdyuzh nak zegnak te mgyeey ne wguu teblose zhobxtil lo xelyu. ");
INSERT INTO zpi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Per chene nexguees yrandxee mén, wa te mén ne rwinyaan mgyeey guin walu men medx ne bat rkyiindet lad xzhobxtil mgyeey guin, lex sya men. ");
INSERT INTO zpi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Le chene le zhobxtil wroo ne le we wlen do, wlalo no gyizh ne bat rkyiindet lado. ");
INSERT INTO zpi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Lex wa yra mén ne rlaa dxiin lo mgyeey guin ne nako xen, re men: “Dechey, ¿pe let teblosedet zhobxtil wguu de lo xelyu de? ¿Pa wzaa gyizh ne bat rkyiindet ne nuu lado?” ");
INSERT INTO zpi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Lex re mgyeey guin ne nako xen: “Nuu mén ne rwinyaan noo wlaa negwa.” Orguin wnabdiiz yra mén guin ne rlaa dxiin lo mgyeey guin, re men: “¿Pe rlaan de tsalaaz noo we?” ");
INSERT INTO zpi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Per wke mgyeey guin ne nako xen, re men: “Tsadet de porke tegue ylaaz de no zhobxtil or ne ylaaz do. ");
INSERT INTO zpi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mazre wendee gudee si yroo we yrup rlo we axtegue ne gak zhobxtil; lex yxaal noo mén ne ytopo. Per primer ytop men gyizh ne bat rkyiindet, lex yliib meno por mzhuun chen tseekyo; luzh nga, ytop men zhobxtil, gutsoow meno ledne tsutsoowo.” ");
INSERT INTO zpi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Wzëët Jesus zegnak ste kwent lo men, re Ne: ―Ne rkyeen Dëdyuzh nak zegnak te medx lyagwlizh ne rlabni mén lo xelyu mén. ");
INSERT INTO zpi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Medx guin nak ne mazre windee ke lo yra medx, per chene le we rlen rroo we, laa we nak ne mazre raknzhoodee ke lo yrandxee gyizh; rako zegnak tebzhaan yag, axtegue mgyin ra rzhexkwaa xeftxëës zhuuko. ");
INSERT INTO zpi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wzëët Jesus zegnak ste kwent lo men, re Ne: ―Ne rkyeen Dëdyuzh nak zegnak lebadur ne rgoots te wnaa tson medid rin chen ynesegyi we yrandxee ngob. ");
INSERT INTO zpi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yra neree ne wzëët Jesus lo mén, teblose zegnak kwent wzëët No; bet nzëëdet Ne lo men belne nzëëdet No zegnak kwent. ");
INSERT INTO zpi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wak yra neree chen gak kumplir diiz ne re profet chene re men: Teblose diiz ne nak zegnak te kwent ynii noo yzëët noo logne rdeedet yra mén kwent desde ne waa gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Wluzhse wguli Jesus mén nëz, wdee Ne lenyuu; lex wbig yra xpén Ne lo Ne, re men: ―Guzëët gan pe rna xkwent gyizh ne bat rkyiindet ne nuu lad zhobxtil. ");
INSERT INTO zpi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wke Ne re Ne lo men: ―Mén ne wguu teblose zhobxtil nak Men ne wdxiid wak Mén, ");
INSERT INTO zpi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","le lyu nak gyëzlyu, le teblose zhobxtil nak xpén Dëdyuzh, le gyizh ne bat rkyiindet nak xpén Bzelo, ");
INSERT INTO zpi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","le mén ne wguu gyizh ne bat rkyiindet nak Bzelo, le ne ydop zhobxtil rna chene nitlo gyëzlyu, le mén ne ytopo nak yra angel. ");
INSERT INTO zpi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Zegne rdop gyizh ne bat rkyiindet chen tseekyo, zenga ke gak chene nitlo gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Men ne wdxiid wak Mén yxaal men xangel men chen kowaa xangel men yra mén ne rlaa ne ryab ste mén lo dol no le yra mén ne rlaa dol, ");
INSERT INTO zpi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","chen ysee angel yra men guin lo gyirenii ledne goon men axtegue guleey men. ");
INSERT INTO zpi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Le yra mén ne rlaa ne wen, ykabtsa men ledne rnebééy Dëdyuzh zegne rkabtsa ngbiz. Men ne rkagyedyag diiz, gon men neree ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Ne rkyeen Dëdyuzh nak zegnak te ne kesentyent non ne nulaan lo tebla lyu. Lex rzëlen te mgyeeyo, zhich guin rgulaan meno nga ke; kesentyent rzhiilen men, ra men ratoo men yrandxee ne rap men, lex ra men raka men lyu guin. ");
INSERT INTO zpi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’No nak ke ne rkyeen Dëdyuzh zegnak te mén ne rkaa rkaye perla ne kesentyent nyezh non, chen yka meno. ");
INSERT INTO zpi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Chene rzël te perla ne kesentyent nyezh non lo men, ra men ratoo men yrandxee ne rap men, lex ra men raka men perla guin. ");
INSERT INTO zpi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’No nak ke ne rkyeen Dëdyuzh zegnak te gyix ne rtxoon mén lo nisdoo ne raag yralondxee mël leen. ");
INSERT INTO zpi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chene ryezaase mël lengyix, rboo mén ne rkaa gozmël gyix lo nisdoo rdxinneey meno runis. Lex rzob men rbe men mël; mëlwen rguu men lentsegwed, le mëlngyidet rsee men. ");
INSERT INTO zpi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Zenga gak chene ydxiin dxe ne nitlo gyëzlyu. Schiid ndal angel chen kwe ne yra menmal lad menwen. ");
INSERT INTO zpi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Lex ysee ne menmal lo gyirenii ledne goon men axtegue guleey men. ");
INSERT INTO zpi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Lex wnabdiiz Jesus lo men yra men, re Ne: ―¿Pe rdee de kwent yra neree? Wke men re men: ―Rdee noo kwento, Dechey. ");
INSERT INTO zpi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Lex re Ne lo men: ―Yra maxter ley ne rseed ne rkyeen Dëdyuzh, nak men zegnak te ngwzan ne rbe ne kweb no le ne yuux lad yra ne non ne ngutsoow men. ");
INSERT INTO zpi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Chene wluzh wzëët Jesus yra neree zegnak te kwent, wruu Ne nga. ");
INSERT INTO zpi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ne wdxiin Ne laz Ne, wzelo Ne wneluu Ne mén lenydoo ne zob nga. Kesentyent wzee wzak yra mén, re men: ―¿Pazh wseed mén gwa yra negwa ne nan men? ¿Pezee run men gan rlaa men gyelmilaguer? ");
INSERT INTO zpi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Pe let laadet xpee karpinter wa? ¿Pe let xnaadet men nga nak Mli, le bech men nak Jacob, nak Xeb, nak Simon, no le Judas? ");
INSERT INTO zpi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Pe let needet nuu yra bzaan men lad be? ¿Pazh wseed men yra negwa? ");
INSERT INTO zpi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Por neguin wukasdet men Jesus, per re Ne lo men: ―Yrandxee lugar rzaknon mén te profet, per le laz men rzaknondet mén men, ni men ne nak xfamilye men rzaknondet men men. ");
INSERT INTO zpi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wlaadet Ne ndal gyelmilaguer nga por ne wlaleedxdet mén Ne. ");
INSERT INTO zpi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Cheguin ke won Herodes ne rnebééy lo lyu ne la Galilea yra ne kalaa Jesus, ");
INSERT INTO zpi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","lex re Herodes lo men ne rlaa dxiin lo Herodes: ―Xwa ne rtxobnis wa wban. Por neguin rap men poder rlaa men gyelmilaguer. ");
INSERT INTO zpi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Re Herodes zenga porke laa Herodes wkyeen mén wanëëz men Xwa, wliib men Xwa kon kaden; lex wguu men Xwa chegyiib. Wlaa Herodes yra neree por xdol Herodías xewnaa Blib bech Herodes. ");
INSERT INTO zpi_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Porke ndal tir re Xwa lo Herodes: ―Ngyidet negwa ne rlaa de ne nuno de xewnaa bech de. ");
INSERT INTO zpi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Wlaan Herodes nket Herodes Xwa, per wdxe Herodes mén porke yrandxee mén nan ne te profet nak Xwa. ");
INSERT INTO zpi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Per chene wzaa Herodes iz, wa xsaap Herodías wya nzeb nes lo yra xemyooz Herodes; kesentyent wtseleedx Herodes zegne wya nzeb. ");
INSERT INTO zpi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Lex wgon Herodes Dëdyuzh ne sdee Herodes logne ynabtee nzeb. ");
INSERT INTO zpi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Orguin wzëët xnaa nzeb lo nzeb gan kox ynab nzeb, lex re nzeb lo Herodes: ―Guniiz xtoo Xwa ne rtxobnis lo noo kon te lengyaan. ");
INSERT INTO zpi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ne won Herodes zenga, wdenles lextoo Herodes; per kom che wgon Herodes Dëdyuzh nes lo xemyooz Herodes, wap Herodes degne wkyeen Herodes men ne rlaa dxiin lo Herodes ne ydee men xtoo Xwa lo nzeb. ");
INSERT INTO zpi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Lex wxaal Herodes mén wa men watxuug men xtoo Xwa lenchegyiib. ");
INSERT INTO zpi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Wluzh nga wdxinneey men xtoo Xwa, nuu we te lengyaan, wdee meno lo nzeb, lex laa nzeb wdekwento lo xnaa nzeb. ");
INSERT INTO zpi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zhich guin wa yra xpén Xwa weey men xkwerp Xwa, walugyeer meno. Wluzh nga waluu men diiz lo Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Chene won Jesus ne wket men Xwa, wruu Ne nga, wdee Ne lenbark za Ne te ledne yëtet mén. Per chene waknan méno, wruu men yra gyëz ne nak nes guin zanal men Ne nii men. ");
INSERT INTO zpi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chene wruu Ne lenbark, wii Ne yra menroo menduxtee guin; lex wles lextoo Ne men, wneseyaken Ne yrandxee mengyiz ne zano men. ");
INSERT INTO zpi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Chene che rzëë, wbig yra xpén Ne lo Ne, re men: ―Chexke rzëë no ni te mén nuudet lugarree. Gugue lo yra ménree gya men chen tsa men yra gyëzwin ne nak guex nee yka men ne gu men. ");
INSERT INTO zpi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Orguin wke Jesus, re Jesus lo men: ―Yët neguin ne tsa men; laa de gudee ne gu men. ");
INSERT INTO zpi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wke men re men lo Ne: ―Per nonchee gaay gyëtxtil no le txup mël neey noo nee. ");
INSERT INTO zpi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Orguin re Ne lo men: ―Gutano we nee. ");
INSERT INTO zpi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Lex wkyeen Ne wzob yra mén guin lo gyizh. Zhich guin wgoob Ne yra gaay gyëtxtil guin no le yrup mël guin, wkalo Ne gyeybaa, wdee Ne dexkyizhtee lo Dëdyuzh. Wluzh nga wla Ne yra gyëtxtil guin, wdee No lo yra xpén Ne, lex laa men wgyiizo lo yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wu men yrandxee men axtegue ne wyezaa men, no chene wluzh nga, wsezaa men chibtxup tsegwed yra gyëtxtilbla ne wrukaa. ");
INSERT INTO zpi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yra mén guin ne wu, zeg gaaymil nak nonchee mgyeey, ngabdet no wnaa ni minwin. ");
INSERT INTO zpi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Zhich guin wkyeen Jesus yra xpén Ne wdee men lenbark chen sanergue men tekaa men stebkoo nis, myentras ne le Ne guli yra mén guin nëz. ");
INSERT INTO zpi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wluzhse wguli Ne yra mén guin nëz, wyeep Ne te xtoo gyeey tete Ne chen ynab Ne lo Dëdyuzh. Chene wnit lyu, tete Ne zu nga. ");
INSERT INTO zpi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Le bark ne za yra xpén Ne chexke nat za we. Noze zere zerotee rlaa mëlo, porke nes lo we rasob mee. ");
INSERT INTO zpi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ne zëdyenii lyu, za Jesus nes lo men rzaa Ne lo nis. ");
INSERT INTO zpi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Chene wii yra xpén Ne ne za Ne rzaa Ne lo nis, kesentyent wdxe men, wobtsadii men, re men: ―¡Te bis! ");
INSERT INTO zpi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Orguin wnii Jesus lo men, re Ne: ―¡Ydxedet de, nzholeedx gugak, noo nee! ");
INSERT INTO zpi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Lex wke Bëd, re Bëd: ―Dechey, belne laa de wa, gulaa ne saa noo lo nis chiid noo lo de. ");
INSERT INTO zpi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Orguin re Ne: ―Gutaa. Lex wruu Bëd lenbark za Bëd nes lo Ne rzaa Bëd lo nis. ");
INSERT INTO zpi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per chene wyenen Bëd ne kesentyent rlen mee, wdxe Bëd; kom le Bëd chexke zazebgyët, wkarëz Bëd, re Bëd: ―¡Dechey, guselaache noo! ");
INSERT INTO zpi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Orguin wzegaa Ne nya Ne wnëëz Ne nya Bëd, re Ne: ―¡Ake mén ne rlaleedxdet Dëdyuzh ydeblextoo! ¿Penak wgutxup lextoo de? ");
INSERT INTO zpi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Zhich guin chene wdee Ne lenbark yrup Ne Bëd, wyakchigue mee. ");
INSERT INTO zpi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Orguin wzuzhib yra xpén Ne ne wyan lenbark lo Ne, re men: ―¡Nli ne XPee Dëdyuzh nak de! ");
INSERT INTO zpi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chene wdekaa Jesus stebkoo nis yra Ne xpén Ne, wdxiin Ne lo xelyu men-Genesaret. ");
INSERT INTO zpi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chene wyenen yra mén ne nuu nga ne Jesus ne, wxoon men diiz ydendxee nes guin, lex wa mén wano men yra mengyiz lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","No wnab men lo Ne ne ydee Ne si ytee nya men maske nonchee luzh xab Ne, no yrandxee mén ne wtee nya luzh xab Ne wyaken. ");
INSERT INTO zpi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lex wbig tebëd men ne nak farisew lo Jesus no le tebëd maxter ley ne wruu Jerusalén, wnabdiiz men lo Ne, re men: ");
INSERT INTO zpi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Penak rlaadet xpén de zegnak xkoxtumber xpenkwlal be ne raa nya men antes ne gu men, le xpén de raadet nya? ");
INSERT INTO zpi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Wke Jesus, re Ne: ―Laa de naa, ¿penak rlaadet de ne rkyeen Dëdyuzh, sinke lel xkoxtumber de zanal de? ");
INSERT INTO zpi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porke re Dëdyuzh: “Gugaknzebnëz lo xuz de, gugaknzebnëz lo xnaa de”, “Mén ne rninyaan lo xuz o men ne rninyaan lo xnaa, rzëël guet men.” ");
INSERT INTO zpi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per le laa de yra de re de ne zak gue mén lo xuz men o lo xnaa men: “Gundet noo gan gun noo xyudar de porke yrandxee ne nniiz noo lo de le we che wguu noo goon por Dëdyuzh”; ");
INSERT INTO zpi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","re de ne kwaskyertee men ne gue zenga, rapdetre men degne gun men xyudar xuz men o xyudar xnaa men. Ne rlaa de zenga, tebkoolel rsan de ne rkyeen Dëdyuzh por ne zanal de xkoxtumber de. ");
INSERT INTO zpi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Gugannaa laa de wen. Nli ke ne re profet-Isaías por laa de yra de chene re men: ");
INSERT INTO zpi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yra ménree noze xdiiz men za ne rzaknon men noo, per rlaadet meno ydeblextoo men. ");
INSERT INTO zpi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bat rkyiindet yra ne rlaa men chene rzaknon men noo, porke yra ne rneluu men, noze mén rkyeeno. ");
INSERT INTO zpi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Lex wbëz Jesus yra menroo menduxtee guin, re Ne lo men: ―Gugon neree ne yzëët noo lo de no gudee kwento: ");
INSERT INTO zpi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Let ne rudet mén rlaa ne rak men mendol, sinke dizmal ne rruu ruu men rlaa ne rak men mendol. ");
INSERT INTO zpi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lex wbig yra xpén Jesus lo Ne, re men: ―¿Pe wyenen de ne wlayaa yra men ne nak farisew ne won men negwa ne re de? ");
INSERT INTO zpi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Wke Ne re Ne: ―Yrandxee gyizh ne let Xuzdet noo ne zob gyeybaa wlabni, slaazo axtegue ydeblu we. ");
INSERT INTO zpi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Zeka men; nak men zegnak menngwlëë ne rgoob nya sengwlëë; no belne rgoob ngwlëë nya sengwlëë ngwlëë, skantaa men yrup men ledne nugyët. ");
INSERT INTO zpi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Lex re Bëd lo Jesus: ―Guzëët gan pe rna diiz gwa ne re de. ");
INSERT INTO zpi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Orguin re Ne: ―¿Pe ni laa de yra de gardet ydeedet kwento? ");
INSERT INTO zpi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Pe rdeedet de kwent ne yrandxee ne ru mén, txu men rya we, zhich guin rruu ko? ");
INSERT INTO zpi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per le diiz ne rlen ruu mén, lextoo men rruu we; laa we rlaa ne rak men mendol. ");
INSERT INTO zpi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porke lextoo mén nuu yra ne mal ne rlebleedx men, zegnak ne rket men semén men, zegnak ne rkano men mén ne nakdet lzaa men, zegnak ne rkanogue men xkompanyer men chene gardet ytsëlnya men, zegnak ne rbaan men, zegnak ne rkagyii men semén men, no le zegnak ne rninyaan men lo semén men. ");
INSERT INTO zpi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yra neree rlaa ne rak mén mendol; per le ne raadet nya mén antes ne gu men, let neguindet rlaa ne rak mén mendol. ");
INSERT INTO zpi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wruu Jesus nga, za Ne nes Tiro no le nes Sidón. ");
INSERT INTO zpi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lex wbig te wna-Canaán ne nuu nes guin rkarëz men Jesus, re men: ―¡Dechey, XPee David, gules lextoo de noo! Porke kesentyent rzakzi menzab xsaap noo. ");
INSERT INTO zpi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per wkedet Jesus. Lex wbig xpén Ne wnab men lo Ne, re men: ―Gugue lo wnaa gwa gya men, porke ndxiin rkarëz men zëdnal men be. ");
INSERT INTO zpi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Lex wke Ne re Ne: ―Nonchee por men-Israel ne nak zegnak mëkzhiil ne che wyab wxaal Dëdyuzh noo. ");
INSERT INTO zpi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Per wbig wnaa guin wzuzhib men lo Ne, re men: ―¡Dechey, gugun xyudar noo! ");
INSERT INTO zpi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Wke Ne re Ne: ―Ngyidet ne ygyitxee mén ne ru zhiin men chen ynii meno lo mëëk. ");
INSERT INTO zpi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Lex re wnaa guin lo Ne: ―Nli we Dechey; per axtegue mëëk ru ne byu ne ratxee zhiin xmezh xpexwaan maa. ");
INSERT INTO zpi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Lex wke Ne re Ne lo men: ―¡Wnaae, kesentyent rlaleedx de noo! Gak zegne rlaan de. Orgueguin wyaken xsaap wnaa guin. ");
INSERT INTO zpi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Wruu Jesus nga, wdxiin Ne runis-Galilea. Lex wyeep Ne te xtoo gyeey wzob Ne. ");
INSERT INTO zpi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nga wdxiin ndalyaa ndalduxtee mén lo Ne, wdxinno men mennguzh, menngwlëë, menngup, men ne ngyidet nya, no ndalre men ne rzak ste klas gyiz; wdxig men men lo Ne, lex wneseyaken Ne yrandxee men. ");
INSERT INTO zpi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kesentyent wzee wzak yra mén ne wii men ne le menngup che rnii, le men ne ngyidet nya che wakwen nya, le mennguzh che rzawen, le menngwlëë che rwii. Lex wzelo men wzaknon men XDëdyuzh men-Israel. ");
INSERT INTO zpi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Lex wbëz Jesus yra xpén Ne, re Ne lo men: ―Rles lextoo noo yra ménree, porke che wzaa tson gbiz ndxin men lo noo no neeydet men ne gu men. Rlaandet noo yxaal noo men gya men ruxyuu men sin ne gudet men, porke tegue yra men fwers nëz. ");
INSERT INTO zpi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Lex re yra xpén Ne: ―Per ¿pazh tsaxii be ne gu lal nee mén zegnakpee lugarree ne ni te mén nuudeto? ");
INSERT INTO zpi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Orguin wnabdiiz Jesus lo men, re Ne: ―¿Blazh gyëtxtil neey de wa? Wke men re men: ―Guedxo no le tebëd mëlwin. ");
INSERT INTO zpi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Orguin wkyeen Jesus wzob yra mén guin lyu. ");
INSERT INTO zpi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Lex wgoob Ne yra guedx gyëtxtil no le yra mël, wdee Ne dexkyizhtee lo Dëdyuzh. Wluzh nga wla Ne yra gyëtxtil guin, wdee No lo yra xpén Ne, lex laa men wgyiizo lo yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wu men yrandxee men axtegue ne wyezaa men, no chene wluzh nga, wsezaa men guedx tsegwed yra ne bla ne wrukaa. ");
INSERT INTO zpi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yra men ne wu, tapmil nak nonchee mgyeey, ngabdet no wnaa ni minwin. ");
INSERT INTO zpi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Wluzhse, wguli Ne yra men guin nëz, lex wdee Ne lenbark za Ne lo lyu ne la Magdala. ");
INSERT INTO zpi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wa men ne nak farisew no le men ne nak sadusew lo Jesus; no por ne ylaa men Ne preb, wnab men lo Ne ne ylaa Ne te gyelmilaguer chen gyakbeey gan pe nli ne Dëdyuzh wxaal Ne. ");
INSERT INTO zpi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Per wke Ne re Ne lo men: ―Chene rzëë lyu, nan de: “Wen gak yzhe porke nloo zhinybaa”; ");
INSERT INTO zpi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","le rsil nan de: “Wendet gak nedxeree porke nloo zhinybaa no nuza.” ¡Gugannaa laa de nan! Belne rdee de kwent gan pe rna beey ne ruu zhinybaa, ¿pezee rdeedet de kwent gan pe rna yra ne kayak naaree? ");
INSERT INTO zpi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Menmal ne zadet xnëz Dëdyuzh rnab lo noo ne ylaa noo te gyelmilaguer, per betre gyelmilaguer kwiidet men, nonchee zegne wzak profet-Jonás kwii men. Wluzh nga wsan Jesus men, sya Ne. ");
INSERT INTO zpi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Chene wdekaa Jesus yra Ne xpén Ne stebkoo nis, wnileedx men ne neeydet men gyëtxtil. ");
INSERT INTO zpi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Lex re Ne lo men: ―Gugap kwent lo xlebadur men ne nak farisew no le lo xlebadur men ne nak sadusew. ");
INSERT INTO zpi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Orguin wzelo xpén Ne rulsaa men diiz, re men: ―Por ne neeydet be gyëtxtil, neguin na Jesus zegwa. ");
INSERT INTO zpi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Wyenen Jesus ne re men zenga, lex re Ne lo men: ―¿Penak re de ne neeydet de gyëtxtil? ¡Ake mén ne rlaleedxdet Dëdyuzh ydeblextoo! ");
INSERT INTO zpi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Pe gardet ydee de kwent no pe zaleedxdet de chene wgyiiz noo gaay gyëtxtil lo gaaymil mén no gan blazh tsegwed gyëtxtilbla ne wrukaa wtop de? ");
INSERT INTO zpi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","No ¿pe zaleedxdet de chene wgyiiz noo guedx gyëtxtil lo tapmil mén no gan blazh tsegwed gyëtxtilbla ne wrukaa wtop de? ");
INSERT INTO zpi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Pezee ne rdeedet de kwent ne let xkwentet gyëtxtil rzëët noo ne na noo gugap kwent lo xlebadur men ne nak farisew no le lo xlebadur men ne nak sadusew? ");
INSERT INTO zpi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Orguin wdee men kwent ne rzëëdet Jesus xkwent lebadur ne rnesegyi gyëtxtil, sinke le Ne rzëët ne gap men kwent lo yra ne rneluu men ne nak farisew no le ne rneluu men ne nak sadusew. ");
INSERT INTO zpi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Chene wdxiin Jesus nes Cesarea Filipo, wnabdiiz Ne lo yra xpén Ne, re Ne: ―¿Pe re mén txu nak noo? ");
INSERT INTO zpi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wke men re men: ―Nuu men re Xwa ne rtxobnis nak de, nuuzeg men re profet-Elías nak de, nuuzeg men re profet-Jeremías nak de, nuuzeg men re ka txu ste profet nak de. ");
INSERT INTO zpi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Lex re Jesus lo men: ―Laa de naa, ¿pe na de txu nak noo? ");
INSERT INTO zpi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Wke Simon-Bëd, re Simon-Bëd: ―Laa de nak Crist XPee Dëdyuzhmbán. ");
INSERT INTO zpi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Orguin re Jesus lo men: ―Nzoon de Simon xpee Jonás, porke let méndet wseleedx diiz gwa lo de, sinke Xuz noo ne zob gyeybaa wseleedxo lo de. ");
INSERT INTO zpi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Le noo yna laa de nak Bëd. Led gyeree ne zu nee ylandal noo xpén noo, ni gyelgut gundet gan yluzh men. ");
INSERT INTO zpi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Noo yniiz poder ne nuu gyeybaa lo de; logne ydeedet de si gak nee gyëzlyuree, gakdet ko gyeybaa; logne ydee de si gak nee gyëzlyuree, zak ko gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Orguin re Jesus lo yra xpén Jesus ne rut lo guedet men ne laa Ne nak Crist. ");
INSERT INTO zpi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kwlotee cheguin wzelo Jesus wzëët Ne lo yra xpén Ne ne rap Ne degne tsa Ne Jerusalén no ne kesentyent yzakzi men ne rnebééy lo men-Israel Ne yra men fxuz ne rnebééy lo yra fxuz no yra men maxter ley. No re Ne ne yket men Ne, per chene gyon gbiz, yban ke Ne. ");
INSERT INTO zpi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Lex wboo Bëd Ne tebkoo, re Bëd lo Ne: ―¡Naleg Dëdyuzh sakdet de negwa Dechey! Nunk sakdeto. ");
INSERT INTO zpi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Orguin wcheree lo Ne, re Ne lo Bëd: ―¡Gubetxee lo noo Bzelo! Noze rsoow de lo noo, porke rlebleedxdet de zegne rlaan Dëdyuzh, sinke le de rlebleedx zegne rlebleedx noze mén. ");
INSERT INTO zpi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Lex re Jesus lo yra xpén Ne: ―Belne nuu mén rlaan gak xpén noo, rap men degne koleedx men xgyelembán men, chidnal men noo, mase kesentyent gak men sufrir. ");
INSERT INTO zpi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Porke men ne rkaa xgyelembán lextoo, zako perdid; per le men ne rboleedx xgyelembán por ne nak men xpén noo, zap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Pa ykyiin ne gap mén yrandxee ne nuu gyëzlyuree belne gapdet men gyelembán ne nunk luzhdet? ¿U zun men gan yka men gyelembán guin? ");
INSERT INTO zpi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Porke schiid Men ne wdxiid wak Mén ydebxgyelenzoon Dëdyuzh Xuz men no yra men xangel Dëdyuzh Xuz men chen ydee men ne ryal te te mén segun ne wlaa men te te men. ");
INSERT INTO zpi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nligue yna noo lo de yra de, ne nuu de zegne ndxin de nee guetetgue sin ne kwiidet de zëëd Men ne wdxiid wak Mén chen ynebééy men. ");
INSERT INTO zpi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ne wluzh xuup gbiz ne wak yra neguin, wzano Jesus Bëd no le Jacob no le Xwa bech Jacob, wano Ne men noze gyon men te xtoo gyeey ne kesentyent gya. ");
INSERT INTO zpi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nga zu Ne yra Ne mén guin, nes lo men stelel wtsoow lo Ne; wkabtsa we zegnak ngbiz, wakngyichdoo xab Ne zegnak bnii. ");
INSERT INTO zpi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tebegue wii men le Moises no le Elías zu kayuno Ne diiz. ");
INSERT INTO zpi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Lex re Bëd lo Jesus: ―Dechey, ¡wen ne zu noo nee gyon noo zeree! Belne rlaan de, yzhexkwaa noo tson guezh: tebo por laa de, stebo por Moises, stebo por Elías. ");
INSERT INTO zpi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Benak kanii Bëd, tebegue wyab te bëw ne rkabnii wrëlo Ne yra Ne men; lad bëw guin wlen te rëz ne re: ―Laa XPee noo nee ne ryaan noo no ne kesentyent rnesak lextoo noo; gugon xdiiz mee. ");
INSERT INTO zpi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ne won xpén Jesus zenga, wzuzhib men axtegue wtee lo men lyu, kesentyent wdxe men. ");
INSERT INTO zpi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lex wbig Jesus lo men, wgal Ne men, re Ne: ―Gusuli; ydxedet de. ");
INSERT INTO zpi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Le chene wlis lo men, rutre wiidet men, nonchee laa Ne zu nga. ");
INSERT INTO zpi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Or ne zëdtseeb Ne txu gyeey guin yra Ne men, re Ne lo men: ―Rut lo guedetgue de neree ne wii de axtegue ne yban Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Orguin wnabdiiz yra xpén Ne lo Ne, re men: ―¿Penak re yra maxter ley ne laa Elías rap degne chiid primer? ");
INSERT INTO zpi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Wke Jesus, re Ne: ―Nli ne primer Elías chiid; laa Elías gue lo yrandxee mén ne gakxnëz mén. ");
INSERT INTO zpi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per yna noo lo de yra de ne le Elías che wdxiid, no wyakbeeydet Elías lo mén, sinke wlaa men Elías zegne wlaantee men. Zenga ke yzakzi men Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Orguin wdee yra xpén Ne kwent ne xkwent Xwa ne rtxobnis nga wzëët Ne. ");
INSERT INTO zpi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Chene wdxiin Jesus yra Ne xpén Ne ledne ndxin ndalyaa mén, wbig te mgyeey lo Ne wzuzhib men, re men: ");
INSERT INTO zpi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Dechey, gules lextoo de xpee noo porke baanske rlaa mee, ngyidet gyiz rzak mee, ndal tir ryab me lo gyi no le lo nis. ");
INSERT INTO zpi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Che wdxidno noo me lo xpén de, per rundet men gan gyaken mee. ");
INSERT INTO zpi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wke Jesus, re Ne: ―¡Ake menmal ne rlaleedxdet Dëdyuzh! ¿Pa axtegue lalre tyemp ykaa noo lad de? ¿Pa axtegue lalre tyemp gun noo de wantar? Gutano me nee. ");
INSERT INTO zpi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Orguin wakndux Jesus lo menzab, wruu menzab lextoo mee guin, orgueguin wyaken mee. ");
INSERT INTO zpi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Zhich guin wbig xpén Jesus lo Ne waandxee, wnabdiiz men lo Ne, re men: ―¿Penak wundet noo gan nboo noo menzab lextoo mee gwa? ");
INSERT INTO zpi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wke Ne re Ne: ―Porke rlaleedxdet de Dëdyuzh ydeblextoo de. Yna noo lo de belne rlaleedx de Dëdyuzh mase medid landxel te medx lyagwlizh, zun de gan gue de lo gyeeyree: “Gubetxee nee, gutsa sob de stebkoo”, no zono xdiiz de. Yët ne gakdet gan gak belne rlaleedx de Dëdyuzh ydeblextoo de. ");
INSERT INTO zpi_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Klas menzab gwa rruudet men belne rut ynabdet lo Dëdyuzh no belne rut ykwandet. ");
INSERT INTO zpi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ne ka Jesus yra Ne xpén Ne lo lyu ne la Galilea, re Ne lo men: ―Men ne wdxiid wak Mén, sdekwent mén men lo mén ");
INSERT INTO zpi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","chen yket mén men; per chene gyon gbiz, yban ke men. Ne won yra xpén Ne zenga, kesentyent wunles lextoo men. ");
INSERT INTO zpi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chene wdxiin Jesus Capernaum yra Ne xpén Ne, wa yra men ne rgoob zeg impwest lo Bëd, re men: ―¿Pe rgyizhdet xmaxter de zeg xeydoo Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Wke Bëd, re Bëd: ―Rgyizh zhaa we. Per zegne wdee Bëd lenyuu, primerdee Jesus re lo Bëd: ―¿Pe na de Simon? ¿Txu lo rgoob rrey ne nuu gyëzlyuree zeg impwest, pe lo zhiin zhaa u lo ste mén? ");
INSERT INTO zpi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Wke Bëd, re Bëd: ―Lo ste mén rgoob zhaa we. Lex re Jesus: ―Rgyizhdet zhiin zhaa we cheguin. ");
INSERT INTO zpi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Per por ne ynelaadet be mén gwa, gutsa runis ynëëz de mël. Primer mël ne yzuun lo de, koo de maa, lex lenruu ma tsëlen de te med, sen de med guin tsa de tsatizh de zeg ximpwest noo no le zeg ximpwest de. ");
INSERT INTO zpi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dxe ke guin wbig yra xpén Jesus lo Ne, re men: ―¿Txuzh nak men ne mazre nondee ledne rnebééy Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Lex wbëz Ne te mëdwin, wzu Ne mëdwin guin gwrooltee lad men yra men, ");
INSERT INTO zpi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","re Ne lo men: ―Nligue yna noo lo de yra de, belne ysaandet de ne nak de no belne gakdet de zegnak mëdwin, teedet de ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Por neguin mén ne nugyadet lextoo zegnak mëdwinree, mén guin nak ne mazre nondee ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","No belne por la noo rukas mén men ne nak zegnak mëdwinree, noo nga rukas men. ");
INSERT INTO zpi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Kwaskyertee mén ne ysegyee lextoo te men ne gyed wzelondxee rlaleedx noo ne ye men dol, mazre wendee por laa men yliib mén te gyenzhoo ne rkyiinen molin lenyen men ne rsegyee men lextoo semén men, lex ytxoon mén men lo nisdoo chen sebgyët men axtegue zhiin nisdoo. ");
INSERT INTO zpi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Prob mengyëzlyu porke ndal ne rsegyee lextoo mén ne ryab men lo dol nuu gyëzlyu, syemper zuu we, per prob mén ne ysegyee lextoo semén ne gyab men lo dol. ");
INSERT INTO zpi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Por neguin belne nya de o nii de rlaa ne ryab de lo dol, gutxuugo, gusee we nat. Porke mazre wendee tee de ledne gap de gyelembán ne nunk luzhdet kon tebegue nya de, kon tebegue nii de, ke ne tsuu de kon yrup nya de, kon yrup nii de lo gyi ne nunk gyuudet. ");
INSERT INTO zpi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","No belne bzalo de rlaa ne ryab de lo dol, gukoo we, gusee we nat. Porke mazre wendee tee de ledne gap de gyelembán ne nunk luzhdet kon tebegue bzalo de, ke ne tsuu de kon yrup bzalo de lo gyi linfyeren. ");
INSERT INTO zpi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Gugap kwent, gakmaldet de ni te lo men ne gyed wzelondxee rlaleedx noo. Porke yna noo lo de yra de, yzaandxee dxe zu yra angel ne rapkwent men lo Xuz noo ne zob gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Porke le Men ne wdxiid wak Mén zëëd chen yselaa men mén ne che wak perdid lo dol. ");
INSERT INTO zpi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Gukwii gante, zegnak te mgyeey, belne rap men tebgwyuu mëkzhiil, lex gyab ma te maa. ¿Peguin ysandet men taplalno-chimtap ma guin den chen tsaye men ma ne wyab? ");
INSERT INTO zpi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","No belne rzël maa, nligue yna noo lo de ne mazre rzhiilendee men por ma guin ne wzël ke taplalno-chimtap ma ne wyabdet. ");
INSERT INTO zpi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Zenga ke Dëdyuzh Xuz be ne zob gyeybaa, rlaandet Ne ne gyab ni te men ne gyed wzelondxee rlaleedx noo. ");
INSERT INTO zpi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Belne nuu pe ne mal rlaa xkompanyer de de, gutsa gu de diiz noze yrup de men chen gyenen men ne ngyidet ne rlaa men. Belne tsukas men de, wun de gan wakwen men lo de ste. ");
INSERT INTO zpi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Per belne tsukasdet men de, guye te mén o txup mén gutsano chen ynii de lo men yra de mén guin, chen laa mén guin gak testig ne che wanii de lo men. ");
INSERT INTO zpi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Per belne tsukasdet ke men xdiiz mén guin, gugue we lo yra xkompanyer de ne za xnëz Dëdyuzh; per belne ni xdiiz men guin ne za xnëz Dëdyuzh tsukasdet ke men, gugun men kwent zegnak men ne rlaleedxdet Dëdyuzh o zegnak men ne rgoob zeg impwest. ");
INSERT INTO zpi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Nligue yna noo lo de yra de, logne ydeedet de si gak nee gyëzlyuree, gakdet ko gyeybaa; logne ydee de si gak nee gyëzlyuree, zak ko gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’No yna noo lo de yra de, belne gyan de diiz txup de nee gyëzlyuree por ne ynab de lo Xuz noo ne zob gyeybaa, laa me yseleedx logne ynabtee de. ");
INSERT INTO zpi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porke ledne ndxin txup mén o tson mén por la noo, nga zu noo gwrooltee lad men. ");
INSERT INTO zpi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Lex wbig Bëd lo Jesus wnabdiiz Bëd, re Bëd: ―Dechey, ¿blazh tir rap noo degne gun noo perdon xkompanyer noo belne nuu pe ne mal rlaa men noo? ¿Pe axtegue guedx tir? ");
INSERT INTO zpi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Wke Jesus, re Ne: ―Ynadet noo ne guedxegue tir, sinke axtegue guedx tsonlalno-chii tir. ");
INSERT INTO zpi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ne rkyeen Dëdyuzh nak zegnak te rrey ne rboo kwent gan palal zeeb yra xmos men lo men. ");
INSERT INTO zpi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ne wzelo men rboo men kwent, wdxinno mén te xmos men ne kesentyent nzhoo zeeb lo men. ");
INSERT INTO zpi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Per kom rundet mos guin gan gyizh men ne zeeb men, wkyeen rrey too mos guin yrup men xewnaa men no le yra zhiin men no le yrandxee ne rap men chen guezh ne zeeb men. ");
INSERT INTO zpi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lex wzuzhib men lo rrey, wnab men, re men: “Dechey, gugap noo pasens, noo gyizh yra ne zeeb noo lo de.” ");
INSERT INTO zpi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Orguin wap lextoo rrey men, wun rrey perdon yra ne zeeb men lo rrey, wdee rrey si sya men. ");
INSERT INTO zpi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Per nonchegue wruu men nga, wtsëlo men te xkompanyer men, zeeb mén guin teblawin med lo men. Lex wnëëz men men wzelo men rgye men yen men, re men lo men: “¡Gugyizh ne zeeb de lo noo!” ");
INSERT INTO zpi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lex wzuzhib mén guin lo men, wnab men, re men: “Gugap noo pasens, noo gyizh yra ne zeeb noo lo de.” ");
INSERT INTO zpi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Per nadet men nyap men pasens mén guin, sinke wsee men men chegyiib axtegue ne gyizh men yra ne zeeb men lo men. ");
INSERT INTO zpi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ne wii stebëd xmos rrey ne wlaa men zenga, kesentyent nyaan wdee lextoo men; wa men wa gue men lo rrey yra ne wlaa mén guin. ");
INSERT INTO zpi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lex wbëz rrey men, re rrey lo men: “¡Kesentyent mal de! Noo wun noo perdon yra ne zeeb de lo noo, porke wnab de lo noo ne gap noo de pasens. ");
INSERT INTO zpi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Le laa de, ¿penak wapdet lextoo de xkompanyer de zegne wap lextoo noo de?” ");
INSERT INTO zpi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kom kesentyent wlaa rrey, lex wdekwent rrey mén guin lo mén chen yzakzi mén men axtegue ne gyizh men yra ne zeeb men. ");
INSERT INTO zpi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Zenga ke ylaa Xuz noo ne zob gyeybaa de yra de belne rundet de perdon xkompanyer de ydebgyiky ydeblextootee de. ");
INSERT INTO zpi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wluzhse re Jesus yra neree, wruu Ne lo lyu ne la Galilea wa Ne stebkoo gyow-Jordán wdxiin Ne lo lyu ne la Judea. ");
INSERT INTO zpi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ndalyaa mén wanal Ne; nga wneseyaken Ne yra mén ne rzhuun. ");
INSERT INTO zpi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lex wbig tebëd men ne nak farisew lo Ne por ne ylaa men Ne preb; wnabdiiz men lo Ne, re men: ―¿Pe zak ychil xgyeltsëlnya me yrup me xewnaa me por kwaskyertee kos? ");
INSERT INTO zpi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Wke Jesus, re Ne: ―¿Pe gardet gool de lo xgyiich Dëdyuzh ledne re, chene primerendxee wzhexkwaa Ne mén, “wzhexkwaa Ne mgyeey no le wnaa”? ");
INSERT INTO zpi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","No re Ne: “Por neguin ysalzaan xuz mgyeey, ysalzaan xnaa mgyeey, chen ybánno men xewnaa men, yrup men zenga gak men zegnak tebegue mén.” ");
INSERT INTO zpi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Che nakdetre men txup, sinke che tebegue nak men. Por neguin nuudet ychil mén ne che wlates Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lex re men ne nak farisew lo Ne: ―¿Penak re Moises cheguin ne zak ybil xgyeltsëlnya mén yrup men xewnaa men, noze ne xexkwaa te gyiich ydee men lo xewnaa men ne che wsalzaan men men? ");
INSERT INTO zpi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Wke Jesus, re Ne lo men: ―Por tant ndíp xdiiz de yra de, por neguin wdee Moises si wako zenga; per chekwlo nakdeto zenga. ");
INSERT INTO zpi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yna noo lo de yra de, kwaskyertee mgyeey ne rchil xgyeltsëlnya yrup men xewnaa men, lex rtsëlnya men yrup men ste wnaa, belne nakdeto por ne wkano xewnaa men ste mgyeey, reey mgyeey guin dol ne la adulterio. Zenga ke mgyeey ne rtsëlnya wnaa ne che wbil xgyeltsëlnya, laake reey ke men dol ne la adulterio. ");
INSERT INTO zpi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lex re yra xpén Jesus lo Ne: ―Belne zenga nak xkwent mgyeey yrup men xewnaa men, mazre wendee ytsëlnyadet men. ");
INSERT INTO zpi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Wke Jesus, re Ne: ―Let yradet mén yna ne ytsëlnyadet, sinke nonchee mén ne che zëëd ne ytsëlnyadet. ");
INSERT INTO zpi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nuu mén axtegue ne wal men che zëëd men ne ytsëlnyadet men, nuuzeg men por ne rboo doctor ne ndaanen men neguin rtsëlnyadet men, nuuzeg men rtsëlnyadet por ne rlaa men xdxiin Dëdyuzh. Men ne gun gan ne ytsëlnyadet, ytsëlnyadet men. ");
INSERT INTO zpi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wdxinno mén tebëd minwin lo Jesus chen yxob nya Ne xtoo miin no chen ynab Ne lo Dëdyuzh por laa miin; per wakndux xpén Ne lo yra men ne wdxinno minwin guin. ");
INSERT INTO zpi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Lex re Jesus lo men: ―Gudee si chiid minwin lo noo, ysoowdet de, porke ledne rnebééy Dëdyuzh, por mén ne nak zegnak minwin nako. ");
INSERT INTO zpi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Orguin wxob nya Ne xtoo minwin guin, lex sya Ne. ");
INSERT INTO zpi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wa te mén lo Jesus, re men: ―Maxter, laa de ne wen de, ¿pe ne wenzhe rap noo degne ylaa noo chen gap noo gyelembán ne nunk luzhdet? ");
INSERT INTO zpi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Wke Jesus, re Ne: ―¿Penak na de ne wen noo? Yët menwen; nonchee Dëdyuzh wen. Per belne rlaan de ne gap de gyelembán ne nunk luzhdet, gulaa ne zëëd lo ley. ");
INSERT INTO zpi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Lex re men: ―¿Gonezhe? Wke Ne re Ne: ―Yketet de mén, ykanodet de mén ne nakdet lzaa de, kwandet de, ykagyiidet de mén, ");
INSERT INTO zpi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","gugaknzebnëz lo xuz de, gugaknzebnëz lo xnaa de, no gugyaan semén de zegne ryaan ke de de. ");
INSERT INTO zpi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wke men re men lo Jesus: ―Yrandxee negwa che rlaa noo axtegue ne win noo; ¿pagoxre rak falt ylaa noo? ");
INSERT INTO zpi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Lex re Jesus: ―Belne rlaan de gak de zegne ryal gak de lo Dëdyuzh, gutsa gutoo ne rap de, lex gudee med lo menprob, chen gap de ne non ne nuu gyeybaa; lex chiid de chidnal de noo. ");
INSERT INTO zpi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Per chene won men zenga, nleschee wuu lextoo men sya men, porke kesentyent rik men. ");
INSERT INTO zpi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Zhich guin re Jesus lo yra xpén Ne: ―Nligue yna noo lo de yra de ne kesentyent ngan tee te menrik ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","No yna noo lo de yra de ne mazre mbëëdee tee te kamey gyeer ne zob nii gyëtsguzh ke ne tee te menrik ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ne won yra xpén Jesus zenga, kesentyent wzee wzak men, re men: ―¿Txuzh nak ne gun gan yláá lo kastig cheguin? ");
INSERT INTO zpi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Orguin wii Jesus lo men, lex re Ne lo men: ―Por mén gakdet gan gak neree, per por Dëdyuzh yët ne gakdet gan gak. ");
INSERT INTO zpi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Lex re Bëd: ―Noo yra noo, wsan noo yrandxee ne rap noo, zëdnal noo de. ¿Pagox gun noo gan? ");
INSERT INTO zpi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Wke Jesus, re Ne: ―Nligue yna noo lo de yra de ne chene ydxiin dxe ne gak kweb yra yrandxee ne nuu, ne sob Men ne wdxiid wak Mén lo yagzhilnzoon ledne ynebééy men, no ke de yra de ne zëdnal de noo sob lo chibtxup yagzhil chen ylaa de gyelextis lo yrandxee men ne zëëd xnëz yra chibtxup xpee Israel. ");
INSERT INTO zpi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","No yrandxee mén ne rsan xyuu, rsan bech, rsan bzaan, rsan xuz, rsan xnaa, rsan xewnaa, rsan zhiin, o rsan xelyu por ne nak men xpén noo, skakwent meno stebgwyuu tir no gap ke men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Per ndal men ne nak men primer naaree, gak men lultim; no ndal ke men ne nak men lultim, gak men primer. ");
INSERT INTO zpi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Ne rkyeen Dëdyuzh nak zegnak te patron ne wruu zaye mos rsil rsilendxee chen ylaa mos dxiin lo xelyu men ledne nuu blag ub. ");
INSERT INTO zpi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wyan men diiz yra men mos ne gyizh men yka mos lal ne run mén gan te dxe; lex wxaal men mos zalaa mos dxiin lo xelyu men. ");
INSERT INTO zpi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Zhich guin wruu men ste zeg beygaa rsil, wdee men lgyeey wii men ndxin stebëd mén ne yëten dxiin. ");
INSERT INTO zpi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Lex re men lo yra men guin: “Gutsa ylaa de dxiin lo xelyu noo; noo gyizh lal ne ryal yka de.” Lex za men. ");
INSERT INTO zpi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Zeg rwen ngbiz, wruu patron guin ste no wruu ke men zeg beytson wzëë, zenga ke wlaa men. ");
INSERT INTO zpi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Zeg beygaay wzëë wruu patron guin ste; wzël stebëd mén ne yëten dxiin lo men, lex re patron guin lo men: “¿Penak ndxin de nee ne wlaadet de dxiin ydebdxendxee?” ");
INSERT INTO zpi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wke men re men: “Porke rut wniizdet dxiin nlaa noo.” Lex re patron guin lo men: “Gutsa ylaa de dxiin lo xelyu noo; noo gyizh lal ne ryal yka de.” ");
INSERT INTO zpi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Chene wzëë lyu, re patron guin lo mén ne zudíp lo xdxiin men: “Gukwëz yra mos, lex gugyizh yka men, primer gyizh de yka yra men ne wdee lo dxiin lultim, gyal de lo yra men ne wdee lo dxiin primerdee.” ");
INSERT INTO zpi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chene wdxiin yra men ne wdee lo dxiin zeg beygaay wzëë, lal ke ne run mén gan ydebdxe wezh wka men te te men. ");
INSERT INTO zpi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Le chene wdxiin men ne wdee lo dxiin primerdee, nuu lextoo men pazer nyezhdee nyezh nka men, per lal ke ne run mén gan te dxe wezh wka men te te men. ");
INSERT INTO zpi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Zegne wnëëz meno, wzelo men wnii men lo patron guin, ");
INSERT INTO zpi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","re men: “Yra menree ne wdee lo dxiin lultim, tendxee or wlaa men dxiin, no lal ke ne wgyizh de wka noo yra noo wgyizh de wka men, no noo yra noo nak ne wun wantar wlaa dxiin lo neey ydebdxendxee.” ");
INSERT INTO zpi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Per wke patron guin, re men lo men te men: “Adxii, rzakzidet noo de. ¿Pe let che wyandet be diiz gan palal gyizh noo yka de te dxe? ");
INSERT INTO zpi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gusen xmed de, gugya. Belne rlaan noo gyizh noo yka menree ne wdee lo dxiin lultim lal ke ne wgyizh noo wka de, ");
INSERT INTO zpi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿peguin nuudet ylaa noo ne rlaan noo kon xmed noo, u nyaan nuu lextoo de ne wen noo?” ");
INSERT INTO zpi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Zeree gak, yra men ne nak men lultim naaree, gak men primer; le yra men ne nak men primer, gak men lultim. Porke ndalyaa mén wakrëz, per zhindxee men ybee. ");
INSERT INTO zpi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Chene nuu Jesus nëz ne za Ne Jerusalén, wbëz Ne yra chibtxup xpén Ne waandxee, lex re Ne lo men: ");
INSERT INTO zpi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Laa de yra de rwii de ne Jerusalén za be ledne ydekwent mén Men ne wdxiid wak Mén; ydekwent men men lo fxuz ne rnebééy lo yra fxuz no le lo maxter ley, lex gyan yra mén guin diiz ne ynab men lo menzit ne yket menzit men; ");
INSERT INTO zpi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","zhich guin ydekwent men men lo menzit chen yzhidxno menzit men, no ydee menzit xkwent men no ykaa menzit men lo kruz; per chene gyon gbiz, yban ke men. ");
INSERT INTO zpi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wluzh nga wbig xewnaa Zebedew no le yrup xpee men wzuzhib men lo Jesus chen ynab men te fabor lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Orguin re Ne lo men: ―¿Pagox rlaan de? Wke men re men: ―Rlaan noo ne chene ynebééy de, ykyeen de sob xpee noo koo de, te me sob ladbëë, ste me sob ladbëg. ");
INSERT INTO zpi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wke Jesus, re Ne: ―Laa de nandet de gan pe rnab de. ¿Pe zun de wantar sak de zegne sak noo? ¿Pe zun de wantar guet de zegne guet noo? Wke yrup xpee men, re mee: ―Zun noo wantaro. ");
INSERT INTO zpi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lex re Ne lo men: ―Nli we, zun de wantar sak de zegne sak noo no zun de wantar guet de zegne guet noo, per por ne sob de koo noo ladbëë o ladbëg, ryaldet noo yniiz noo we, sinke le we nak por yra mén ne che wsanla Xuz noo ne gyalo. ");
INSERT INTO zpi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chene won schii xpén Ne ne re men zenga, wlaa men lo yrubech men guin. ");
INSERT INTO zpi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lex wbëz Jesus men yra men, re Ne lo men: ―Laa de yra de nan de ne men ne rnebééy ste nacion, rnebééy men lo mén zegne rlaantee men; zenga ke yra mén ne non ne nuu lad men, rlaa men mén zegne rlaantee men, porke laa men rnebééy. ");
INSERT INTO zpi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Per le laa de yra de ylaadet de zenga. Sinke men ne rlaan gaknon lad de, rap men degne laa men ylaa dxiin lo de. ");
INSERT INTO zpi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","No men ne rlaan ynebééy lad de, rap men degne laa men gak mos lo de. ");
INSERT INTO zpi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Zegnak Men ne wdxiid wak Mén zëëdet men por ne ylaa mén dxiin lo men, sinke le men zëëd por ne ylaa men dxiin lo mén no por ne guet men chen yselaa men ndal mén lo dol. ");
INSERT INTO zpi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Chene wruu Jesus yra Ne xpén Ne lenlgyëz-Jericó, ndalyaa mén za zanal Ne. ");
INSERT INTO zpi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nga zob txup menngwlëë runëz; zegne won men ne le Jesus zadesu, wzelo men rkarëz men, re men: ―¡Dechey, XPee David, gules lextoo de noo! ");
INSERT INTO zpi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Orguin wakndux mén lo men chen gyakchi men, per lel mazre rkarëz men, re men: ―¡Dechey, XPee David, gules lextoo de noo! ");
INSERT INTO zpi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Lex wzutsë Jesus, wbëz Ne men yrup men, re Ne lo men: ―¿Pagox rlaan de ylaa noo por laa de? ");
INSERT INTO zpi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wke men re men: ―Dechey, rlaan noo gyenii bzalo noo. ");
INSERT INTO zpi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Orguin wles lextoo Jesus yrup mén guin, wtee nya Ne bzalo men. Orgueguin wyenii bzalo men, zanal men Ne. ");
INSERT INTO zpi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Chene wdxiin Jesus yra Ne xpén Ne guex Jerusalén ne wdxiin Ne Betfagé koo gyey-Olivos, wxaal Ne txup xpén Ne, ");
INSERT INTO zpi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","re Ne lo men: ―Gutsa gyëzwin ne nak ngali nee. Nga kaduu te burgos yrup ma zhiin maa. Ychil de ma, chidno de maa. ");
INSERT INTO zpi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Belne nuu mén pe yna lo de, gue de lo men: “Laa Jesus ne rnebééy ykyiinen maa. Orkeree yxaal men men ne chidron maa.” ");
INSERT INTO zpi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Wak neree chen gak kumplir diiz ne re profet chene re men: ");
INSERT INTO zpi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gugue lo men gyëz-Sión: “Gukwii, le xerrey de zëëd lo de, probendxee zëëd men, mbib men te bur bëën bëënleg, zhiin te burgos ne reey yúú.” ");
INSERT INTO zpi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Lex wa xpén Jesus, wlaa men zegne wkyeen Ne. ");
INSERT INTO zpi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wzano men burgos guin yrup ma zhiin maa, wxob men lër ne rrël men led maa yrup maa, lex wbiib Jesus zhiin maa. ");
INSERT INTO zpi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ndalyaa ndalduxtee mén ndxin nga, nuu men rgyixnchiil lër nëz, nuuzeg men rkyiits gyizh rgyix men nëz ledne tee Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Noze nesree nesrotee rlen xrëz yrandxee mén ne zaner men ne zanaltee, re men: ―¡Nzoon XPee rrey-David! ¡Dëdyuzh gaknonen men ne zëëd por la Dëdyuzh! ¡Nzoon Dëdyuzh! ");
INSERT INTO zpi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Chene wdee Jesus lenlgyëz-Jerusalén, axtegue nandet yra men-Jerusalén pe wuu lextoo men, wnabdizlsaa men, re men: ―¿Txu wa? ");
INSERT INTO zpi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lex re yra men ne zanal Ne: ―Profet-Jesus ne, men-Nazaret, Nazaret ne nak lo lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Zhich guin wdxiin Jesus ruxeydoo Dëdyuzh, wnexoon Ne yra mén ne ndxin rtoo nga no le yra mén ne ndxin rzii, no wnekantaa Ne xmezh yra mén ne ndxin rtsaa medzit; zenga ke wlaa Ne xyagzhil yra mén ne rtoo mëër. ");
INSERT INTO zpi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Lex re Ne lo men: ―Lo xgyiich Dëdyuzh re: “Xyuu noo, ledne ynab mén lo noo sela we”; per le laa de yra de rlaa do zegnak xebluu ngbaan. ");
INSERT INTO zpi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nga lenydoo guin wbig menngwlëë no le mennguzh lo Jesus, lex wneseyaken Ne men. ");
INSERT INTO zpi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Per chene wii yra fxuz ne rnebééy lo yra fxuz no le yra maxter ley yra gyelmilaguer ne rlaa Ne no ne won men ne rlen xrëz minwin lenydoo, re miin: “¡Nzoon XPee rrey-David!”, kesentyent wlaa men. ");
INSERT INTO zpi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Lex re men lo Jesus: ―¿Pe ron de ne re yra minwin gwa? Wke Jesus, re Ne: ―Ron noo we. ¿Pe gardet gool de lo xgyiich Dëdyuzh ledne re: Axtegue minwin, axtegue mëëd ne roo dud, laa Dëdyuzh wlaa ne saknon miin Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Lex wsan Ne yra mén guin, za Ne Betania, nga wzëën Ne. ");
INSERT INTO zpi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ne wra gyëël, rsilgue wberee ke Jesus za Ne Jerusalén, orguin wlen wlaanen Ne. ");
INSERT INTO zpi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lex wii Ne zob tebzhaan yag-ig guex runëz, wbig Ne zhiino, per bet ig wzëldet lo we, nonchee gyizh ka lo we. Lex re Ne lo yag guin: ―¡Nunk ykaadetre nex lo de! Orgueguin wbidxo. ");
INSERT INTO zpi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ne wii yra xpén Jesus neree, wzee wzak men; wnabdiiz men lo Ne, re men: ―¿Pezee wbidxgue yag-igree, bes? ");
INSERT INTO zpi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Wke Jesus, re Ne: ―Nligue yna noo lo de yra de, belne rlaleedx de Dëdyuzh no belne nutxupdet lextoo de, let nozdet neree ne wlaa noo yag-igree gun de gan ylaa de, sinke zun de gan gue de lo gyeeyree: “Gubetxee nee, gugyab lo nisdoo”, no zako. ");
INSERT INTO zpi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","No yrandxee ne rnab de lo Dëdyuzh, belne rlaleedx de ne slaa No, laa Ne yseleedxo lo de. ");
INSERT INTO zpi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Lex wa Jesus lenxeydoo Dëdyuzh; or ne kaneluu Ne mén, wbig yra fxuz ne rnebééy lo yra fxuz yra men men ne rnebééy lo men-Israel, wnabdiiz men lo Ne, re men: ―¿Txu wkyeen de ne rlaa de neree? ¿Txu wnebééy lo de ne rlaa do? ");
INSERT INTO zpi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Wke Ne re Ne: ―Laake no ke noo ynabdiiz lo de yra de; belne yke de, lex yna noo gan txu wkyeen noo ne rlaa noo we. ");
INSERT INTO zpi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Txuzh wxaal Xwa ne wtxobnis Xwa mén, Dëdyuzh u noze mén? Orguin wzelo men rulsaa men diiz, re men: ―Belne gue be ne Dëdyuzh wxaal Xwa, naap yna zhaa: “¿Penak wlaleedxdet de Xwa cheguin?” ");
INSERT INTO zpi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","No belne gue be noze mén wxaal Xwa, texnad ylayaa mengyëz, porke yrandxee mengyëz rlaleedx ne te profet nak Xwa. ");
INSERT INTO zpi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Orguin wke men re men lo Jesus: ―Nandet noo we. Lex re Ne lo men: ―Laake ni noo yzëëdet gan txuzh wkyeen noo ne rlaa noo neree. ");
INSERT INTO zpi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Zhich guin re Jesus lo men: ―Yzëët noo diizree lo de yra de gan pe yna de. Te mgyeey rap men txup xpee men, lex re men lo me te mee: “Zhiin, gutsa ylaa de dxiin lo blag ub nedxeree.” ");
INSERT INTO zpi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wke me, re mee: “¡Rlaandet noo tsa noo!” Per zhich guin nuu lextoo mee: “Tsachee noo mazdee.” Lex wa mee. ");
INSERT INTO zpi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Lex wbig men lo ste xpee men, zenga ke re men lo mee. Wke me, re mee: “Ow Dëde, orree tsa noo.” Per wadet mee. ");
INSERT INTO zpi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Orrenaa delo yrup mee guin, ¿go mezhe wlaa ne rlaan xuz? Wke men re men: ―Meprimer ne wnii men lo. Lex re Jesus: ―Nligue yna noo lo de yra de ne kwlodee men ne rgoob zeg impwest no le wnaa ne rkano wren wren mgyeey tee ledne rnebééy Dëdyuzh ke laa de yra de. ");
INSERT INTO zpi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porke wdxiid Xwa ne rtxobnis wneluu Xwa de gan pezee ybán de xnëz, per wlaleedxdet de ne wzëët Xwa; le men ne rgoob zeg impwest no le wnaa ne rkano wren wren mgyeey, wlaleedx men ne wzëët Xwa. Per le laa de yra de mase wii de ne wsaan men xgyelmal men, per wsaandet de xgyelmal de nlaleedx de ne wzëët Xwa. ");
INSERT INTO zpi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Gugon neree ne yna noo lo de yra de zegnak ste kwent: Wuu te mgyeey ne wlabni blag ub lo xelyu, lex wtsëloo meno, no wzhexkwaa men te ledne yzhii ub, no wlep men te ne kesentyent gya ledne kwiin men ne ykanapo ydendxoo. ’Zhich guin wbodiin men blag ub guin lo tebëd mén ne rapkwent blag ub. Lex wruu men za men nat. ");
INSERT INTO zpi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Le chene wdxiin tyemp ne le ub wal gyët, wxaal xpexwaan blag ub guin tebëd xmos men lo yra men ne rapkwento, zaxii xmos men ub ne ryal xpexwaan blag ub guin. ");
INSERT INTO zpi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per lel wnëëz yra men ne rapkwent blag ub mos guin, wdee men xkwent men te men, le ste men wket men, le ste men wgugye men. ");
INSERT INTO zpi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Zhich guin wxaal xpexwaan blag ub guin mazre ndaldee xmos men ke lo men ne wa primer, per zenga ke wlaa yra mén guin ne rapkwent blag ub yra mos guin. ");
INSERT INTO zpi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Wyal wdebo, wxaal men xpee men, nuu lextoo men: “Lo xpee noo si zaknzebnëz men.” ");
INSERT INTO zpi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per chene wii yra mén guin xpee men, wulsaa men diiz, re men: “Laa ménree nak ne gyanno blag ubree; yoo yket be men, chen gyanno bo laa be.” ");
INSERT INTO zpi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Lex wnëëz yra mén guin mee guin, wboo men me lo lyu guin, wket men mee. ");
INSERT INTO zpi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Naaree naa chene chiid xpexwaan blag ub guin, ¿pagox ylaa men yra mén guin ne rapkwent blag ub? ");
INSERT INTO zpi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lex wke yra mén guin, re men lo Jesus: ―Yket men yra menmal guin, gapdet lextoo men men. Lex kodiin men xeblag ub men lo stebëd mén ne ydee ub ne ryal men chene ydxiin tyemp ne le ub wal gyët. ");
INSERT INTO zpi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Lex re Jesus lo men: ―¿Pe nunk gardet gool de lo xgyiich Dëdyuzh? Nga re: Gye ne axtegue rlaandet mén ne rlep yuu, laa we wak gye ne mazre rkyiindee. Dëdyuzh wlaa neree, no le be kesentyent rzee rzak. ");
INSERT INTO zpi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Por neguin na noo lo de yra de ne sgyitxee Dëdyuzh xpoder Ne lo de chen ydee No lo yra mén ne rlaa ne rlaan Ne. ");
INSERT INTO zpi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Men ne gyab led gye guin, zakbyu men, per belne gyab gye guin led men, zakbyudoo men. ");
INSERT INTO zpi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chene wluzh won yra fxuz ne rnebééy lo yra fxuz no le yra men ne nak farisew yra kwent ne wuu Jesus, wyenen men ne por laa men wnii Ne. ");
INSERT INTO zpi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wlaan men nguu men Ne chegyiib, per wdxe men mén porke nan mén ne te profet nak Ne. ");
INSERT INTO zpi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Lex wuu Jesus zegnak ste kwent lo men, re Ne: ");
INSERT INTO zpi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ne rkyeen Dëdyuzh nak zegnak te rrey ne wlaa xdooy xpee. ");
INSERT INTO zpi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wxaal xmos rrey walëz yra men ne che re rrey lo ne tsa dooy guin, per nadet men nya men. ");
INSERT INTO zpi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wberee rrey wxaalgue stebëd xmos rrey, re rrey lo men: “Gutsa gue de lo men ne che re noo lo ne chiid xdooy xpee noo, le nesyaa che nuu, le noo che wkyeen wet xyuz noo, ma ne mazre rroodee, yrandxoo che list nak; gue de lo men chiid men naa.” ");
INSERT INTO zpi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per wukasdet yra mén guin xmos rrey. Te men za lo xelyu, le ste men za lo xdxiin, ");
INSERT INTO zpi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","le stebëd men wnëëz xmos rrey, wdee men xkwent men axtegue wket men men. ");
INSERT INTO zpi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Chene won rrey ne zenga wlaa men, wlayaa rrey. Lex wxaal rrey xsoldad rrey waket men yra menmal guin no wzeey men gyëz ne nuu menmal guin. ");
INSERT INTO zpi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Zhich guin re rrey lo xmos rrey: “Yrandxoo che list nak chen gak dooy, per yra ménro ne re noo lo ne chiid, rzëëldetre men chiid men. ");
INSERT INTO zpi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Orrenaa gutsa yde runëzyu wa, yrandxee mén ne ytsëël de gue de lo men chiid men xdooy xpee noo.” ");
INSERT INTO zpi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Lex wruu yra xmos rrey wa men runëz, wtop men yrandxee mén ne wtsëël men, menmal menwentee; zenga wyezaa mén lenxyuu rrey. ");
INSERT INTO zpi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Per chene wdee rrey ledne ndxin yra mén guin, wii rrey te mgyeey ne nakdet lër ne ryal gak mén lo dooy. ");
INSERT INTO zpi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lex re rrey lo mgyeey guin: “Adxii, ¿penak wdee de nee sin lër ne rak mén lo dooy?” Per wkedet mgyeey guin. ");
INSERT INTO zpi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Orguin re rrey lo yra xmos rrey: “Guliib nii men no guliib nya men, lex gutxoon men fwer lo nkeb ledne goon men axtegue guleey men.” ");
INSERT INTO zpi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Porke ndalyaa mén wakrëz, per zhindxee men ybee. ");
INSERT INTO zpi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Zhich guin sya yra men ne nak farisew, wyan men diiz gan pezee gue men lo Jesus chen gan pe gue Ne chen tsël gan pezee ykagyii men Ne. ");
INSERT INTO zpi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Lex wxaal men tebëd xpén men no le tebëd xpén Herodes wa men re men lo Jesus: ―Maxter, nan noo yra noo ne nli ne rnii de no ne nli ne rneluu de ne ybán mén zegne rlaan Dëdyuzh. Zadet lextoo de gan txu nak mén porke por laa de tese nak mén. ");
INSERT INTO zpi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Guna gan ¿pe wen gyizh noo zeg impwest lo rrey-Roma u wendeto? ");
INSERT INTO zpi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per kom wyenen Jesus ne ngyidet ne rlebleedx men, lex re Ne lo men: ―Gugannaa laa de wen, ¿penak rye de gan pezee gyab noo lo xetramp de? ");
INSERT INTO zpi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Guluu te med ne rgyizh de zeg impwest gan. Orguin wluu men te med lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Lex wnabdiiz Ne lo men, re Ne: ―¿Txu lo wa no txu la wa ka lo we? ");
INSERT INTO zpi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wke men re men: ―Lo rrey-Roma we no le la rrey-Roma we. Lex re Ne lo men: ―Guex gudee ne nak xen rrey lo rrey, le ne nak xen Dëdyuzh gudee lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ne won men zenga, wzee wzak men; wsan men Ne, syague men. ");
INSERT INTO zpi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dxe ke guin, wa tebëd men ne nak sadusew lo Jesus. Kom rlaleedxdet men ne sban mengut, por neguin re men lo Ne: ");
INSERT INTO zpi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maxter, re Moises ne belne guet te mén, per wapdet xewnaa men mëëd, bech men rap degne ytsëlnyano wnaa guin, chen gap men mëëd ne gak zegnak zhiin mén guin ne wet. ");
INSERT INTO zpi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Chekwlo wuu guedx mén lad noo yra noo, tese bech men yra men; lex wtsëlnya men ne nak mengoldee lo men yra men, per wet men. Kom wuudet zhiin men, lex wtsëlnya men ne wrup yrup men xewnaa mén guin ne wet. ");
INSERT INTO zpi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Zenga ke wzak men ne wrup, wet ke men; zhich guin wtsëlnya men ne wyon yrup men wnaa guin; zenga wlaa men yra men axtegue ne wzaa men guedx. ");
INSERT INTO zpi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chene che wet men yra men, no ke wnaa guin wet. ");
INSERT INTO zpi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Orrenaa, chene yban mengut, delo yra guedx mén guin, ¿txu xewnaapee gak wnaa guin ne yrandxee men wtsëlnyano men? ");
INSERT INTO zpi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Wke Jesus, re Ne: ―Laa de yra de ngyidet ne rnii de, porke rdeedet de kwent ne zëëd lo xgyiich Dëdyuzh, ni rdeedet de kwent pezee nak xpoder Ne. ");
INSERT INTO zpi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chene yban mengut, che ytsëlnyadetre men, ni mgyeey ni wnaa, sinke zegnak angel ne nuu gyeybaa gak men. ");
INSERT INTO zpi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Belne rlaleedxdet de ne sban mengut, ¿pe gardet gool de lo xgyiich Dëdyuzh ledne re Ne: ");
INSERT INTO zpi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Noo nak XDëdyuzh Abraham, XDëdyuzh Isaac, XDëdyuzh Jacob”? Nakdet Dëdyuzh XDëdyuzh mengut, sinke le Dëdyuzh nak XDëdyuzh menmbán. ");
INSERT INTO zpi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ne won yra men guin neree, kesentyent wzee wzak men por yra ne rneluu Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chene won yra men ne nak farisew ne wsoow Jesus ruu yra men ne nak sadusew, wdop men yra men. ");
INSERT INTO zpi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Lex wbig te ke farisew ne nak maxter ley wnabdiiz men lo Ne gan pe gue Ne, re men: ");
INSERT INTO zpi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maxter, ¿gonezhe nak ne mazre nondee ne zëëd lo xley Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Wke Ne re Ne lo men: ―“Gugyaan XDëdyuzh de ydebgyiky ydeblextootee de, ydebxanem de.” ");
INSERT INTO zpi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Laa neree nak ne primer no ne mazre nondee ne zëëd lo xley Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Le ne wrup nak ko zegnak ne primer, re we: “Gugyaan semén de zegne ryaan ke de de.” ");
INSERT INTO zpi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mén ne rlaa yrup neree, laa ne rlaa men yrandxee ne zëëd lo xley Dëdyuzh nga no le ne wkaa yra profet. ");
INSERT INTO zpi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Or ne benak ndxin yra men ne nak farisew nga, wnabdiiz Jesus lo men, ");
INSERT INTO zpi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","re Ne: ―¿Pagox yna de por Crist? ¿Txu xpee nak zhaa? Wke men re men: ―Xpee David. ");
INSERT INTO zpi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Lex re Jesus lo men: ―¿Penak chene waknonen Espíritu Sant David cheguin, wnesela David Crist XDëdyuzh David? Porke re David: ");
INSERT INTO zpi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dëdyuzh re lo XDëdyuzh noo: “Gusob koo noo ladbëë axtegue ne ylaa noo ne gyichnii de yrandxee mén ne rlaa lo de.” ");
INSERT INTO zpi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Belne David ke rnesela Crist XDëdyuzh David, ¿pezee gak Crist xpee David? ");
INSERT INTO zpi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ni te men wundet gan nke ni te diiz lo Jesus; kwlotee dxe guin ni ste men wyezhdetre nnabdiiz lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Re Jesus lo yra mén no le lo yra xpén Jesus: ");
INSERT INTO zpi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Yra maxter ley no yra men ne nak farisew, laa men rneluu zegne zëëd lo ley ne wdee Dëdyuzh lo Moises. ");
INSERT INTO zpi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Por neguin gugon xdiiz men; gulaa yra ne yna men; per ylaadet de zeg rlaa men, porke wren ne rzëët men wrengue ne rlaa men. ");
INSERT INTO zpi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Porke rkyeen men ylaa mén ne gakdetlel ylaa mén, per noze rkyeen men ylaa méno; le laa men axtegue ni zadet lextoo men ylaa meno. ");
INSERT INTO zpi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yrandxee ne rlaa men, rlaa meno noze por ne kwii mén ne rlaa men. Rtseleedx men yliib men tebla gyed ne ka xdiiz Dëdyuzh xudx men no le zhuuk men no rtseleedx men gak men lër ne kesentyent ngool luzh. ");
INSERT INTO zpi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Rtseleedx men sob men lo mezh ledne rzob mennon chene ra men gwdu; zenga ke rlaa men lenydoo. ");
INSERT INTO zpi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","No rtseleedx men ne kon gyelenzebnëz gabtyuzh mén men nes lgyeey no rtseleedx men ne ynii mén men maxter. ");
INSERT INTO zpi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Per le laa de yra de, ydeedet de si ne ynii mén de maxter, porke tese bech de yra de, no tendxee Maxter rap de, laa men nga nak Crist. ");
INSERT INTO zpi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","No yniidet de dëd lo kwaskyertee mén nee gyëzlyuree, porke tendxee Xuz be rap be, laa Ne nga nak Dëdyuzh Xuz be ne zob gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni ydeedet de si ne ynii mén de men ne rnebééy porke tendxee men ne rnebééy nuu, laa men nga nak Crist. ");
INSERT INTO zpi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Men ne mazre nondee lad de, rap men degne laa men ylaa dxiin lo de. ");
INSERT INTO zpi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Porke men ne nugya lextoo, men guin nak men ne gaknondet; le men ne nugyadet lextoo, men guin nak men ne gaknon. ");
INSERT INTO zpi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Prob de yra de ne nak de maxter ley no le yra de ne nak de farisew, gugannaa laa de wen!, no rdeedet de si gak mén xpén Dëdyuzh, no ni laa de rakdet xpén Ne, ni rdeedet zeg de si ne gak mén ne rlaan gak xpén Dëdyuzh xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Prob de yra de ne nak de maxter ley no le yra de ne nak de farisew, gugannaa laa de wen!, no le de rgyitxee xyuu wnabyud, per por ne gyendeto, kesentyent xche rnab de lo Dëdyuzh. Por neguin laa de yra de nak ne ntozdee sakzi. ");
INSERT INTO zpi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Prob de yra de ne nak de maxter ley no le yra de ne nak de farisew, gugannaa laa de wen! Ra de nes lo nisdoo no ra de nes lyu rkaye de mén ne tee lad de. Chene le de run gan ne rdee te mén lad de, ntozdee rlaa de men zhiin Bzelo ke laa de yra de. ");
INSERT INTO zpi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Prob de yra de ne rneluu de mén ne ni laa de rdeedet kwent! Nan de lo men: “Belne rgon mén xeydoo Dëdyuzh, bet nakdeto; per belne rgon men ne or ne nuu lenydoo, rap men degne ylaa men ne re men.” ");
INSERT INTO zpi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Nzël de! ¡Ngwlëë de! ¿Gonezhe nak ne nondee: or u ydoo? Si por ydoo rakleey or. ");
INSERT INTO zpi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","No re ke de: “Belne rgon mén fkuuk, bet nakdeto; per belne rgon men goon ne zhoob lo fkuuk, cheguin si rap men degne ylaa men ne re men.” ");
INSERT INTO zpi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Nzël de! ¡Ngwlëë de! ¿Gonezhe nak ne nondee: goon u lo fkuuk ledne rakleey goon? ");
INSERT INTO zpi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mén ne rgon fkuuk, rgondet men nonchee fkuuk, sinke le men rgon yrandxee ne zhoob lo fkuuk; ");
INSERT INTO zpi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","zenga ke mén ne rgon ydoo, rgondet men nonchee ydoo, sinke le men rgon no Dëdyuzh, porke nga zu Ne. ");
INSERT INTO zpi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","No le mén ne rgon gyeybaa, ledne zob Dëdyuzh nga rgon men, laake Ne nga rgon men. ");
INSERT INTO zpi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Prob de yra de ne nak de maxter ley no le yra de ne nak de farisew, gugannaa laa de wen! Rlachii de bedextil, rlachii de ynizh no rlachii de komin, lex rasan de tebchii we por Dëdyuzh, per rlaadet de ne mazre nondee ne zëëd lo xley Dëdyuzh ne ylaa de ne xnëz no ne yles lextoo de semén de no ne ylaleedx de Dëdyuzh ydeblextoo de. Neree nak ne rap de degne ylaa de, sin ne ysalzaandet de negwa ne che rlaa de. ");
INSERT INTO zpi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Rneluu de mén logne ni laa de rdeedet kwent, rdeedet de si gueb de ni te mduxwin per ryenden de ne axtegue te kamey reb de. ");
INSERT INTO zpi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Prob de yra de ne nak de maxter ley no le yra de ne nak de farisew, gugannaa laa de wen! Nak de zegnak bas no le zegnak gyaan ne ndaa por led, per le por lenlextoo de teblose gyelegbaan nuu we no le gyelendeblextoo. ");
INSERT INTO zpi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisew ngwlëë: primer guye gan pezee gakndaa lextoo de chen gakndaa de yde de. ");
INSERT INTO zpi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Prob de yra de ne nak de maxter ley no le yra de ne nak de farisew, gugannaa laa de wen!, no nak de zegnak baa ne ngyichdoo ne zhaandxee rnaa por led, per le por leeno yzaa xdxit mengut no yzaa yra ne beed. ");
INSERT INTO zpi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Zenga nak de yra de; por legya rnaa de wen de, per le por lenlextoo de teblose gyelerkade nuu we no le ne mal. ");
INSERT INTO zpi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Prob de yra de ne nak de maxter ley no le yra de ne nak de farisew, gugannaa laa de wen! Rzhexkwawen de xbaa profet ne wuu chekwlal no rlazhaandxee de led xbaa mén ne xnëz wbán, ");
INSERT INTO zpi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","no re de yra de: “Belne nako ne che nuu be chene wuu xpenkwlal be, nyakden be yra be xpenkwlal be chene wket men profet.” ");
INSERT INTO zpi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kon neree, laake de yra de ryenen ne xnëz men ne wket profet zëëd de. ");
INSERT INTO zpi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Guseyal ne wneselo xpenkwlal de! ");
INSERT INTO zpi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Mëël! ¡Xerras mëël! ¿Pezee gun de gan yláá de chen sakzidet de linfyeren? ");
INSERT INTO zpi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yxaal noo profet, yxaal noo mennan, yxaal noo maxter lad de yra de, per sket de men gwrol men, gwrol zeg men ykaa de lo kruz, gwrol zeg men ydee de xkwent lenxeydoo de, no ykanal de men gyëz por gyëz chen yzakzi de men. ");
INSERT INTO zpi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Por neguin led de ykaa gyii por ne wket xpenkwlal de yra mén ne xnëz wbán, desde Abel ne xnëz wbán axtegue Zacari xpee Berequías, Zacari ne wa men-Israel waket men-Israel guex lo fkuuk lenxeydoo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nligue yna noo lo de yra de ne led yra mén ne nuu naaree ykaa yra gyii guin. ");
INSERT INTO zpi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","No re Jesus: ―¡Men-Jerusalén, men-Jerusalén, ne rket profet no ne rgugye men ne wxaal Dëdyuzh lad de yra de! ¡Blazhtee tir wlaan noo ntop noo de yra de zegne rtop ngyed zhiin ngyed rguu ma ma lenxpaan maa, per nadet de! ");
INSERT INTO zpi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Por neguin noze nles gyan laz de. ");
INSERT INTO zpi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Porke yna noo lo de yra de, ne kwiidetre de noo axtegue ne ydxiin dxe ne gue de: “Dëdyuzh gaknonen men ne zëëd por la Dëdyuzh.” ");
INSERT INTO zpi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Chene wruu Jesus lenxeydoo Dëdyuzh ne sya Ne, wbig yra xpén Ne rluu men yra zegne nyeep ydoo guin lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lex re Ne lo men: ―Nligue yna noo lo de, yra neree ne rwii de, ni te gye gyandet led ste gye, yrandxoo luzh. ");
INSERT INTO zpi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Or ne zob Jesus gyey-Olivos, wbig yra xpén Ne lo Ne, laangue wnabdiiz men lo Ne, re men: ―Rlaan noo yzëët de gan pa or gak yra negwa. ¿Pezee gak beey ne tsuu chene le de che wyob chiid ste no chene le gyëzlyu che wyob nitlo? ");
INSERT INTO zpi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Wke Ne re Ne: ―Gugap kwent, rut ydeedet de si ykade de. ");
INSERT INTO zpi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porke schiid ndal mén ne ykade, gue men: “Noo nak Crist”; no ndal mén gun men gan ykade men. ");
INSERT INTO zpi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","No chene gon de diiz ne le dilroo nuu nesree nesrotee, ydxedet de, porke zenga nak ne rap degne gak; per let laadet ne nitlo gyëzlyu nga. ");
INSERT INTO zpi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Porke te nacion til yrup ste nacion, te gobyeren til yrup ste gobyeren, no ndal ledne tsuu gbiin no kesentyent yni lyu. ");
INSERT INTO zpi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Per chene gak yra neree, laa ne gyed selondxee gyelenles nga. ");
INSERT INTO zpi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Cheguin ydekwent mén de lo mén ne yzakzi de, yket men de, no kwinyaan yrandxee mén de por ne nak de xpén noo. ");
INSERT INTO zpi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chene gak yra neree, ndal mén ysalzaan ne rlaleedx men noo; ydekwentelsaa men xkompanyer men lo xtis no kwinyanelsaa men. ");
INSERT INTO zpi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Zuu ndal profet ne ykade no ndal mén gun men gan ykade men. ");
INSERT INTO zpi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Por tant ydaal ne mal, ndal mén gyanelsaadetre. ");
INSERT INTO zpi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per le mén ne ysalzaandet xdiiz noo ydeblo ne ybán men, men guin nak ne gap gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Xdiznzoon Dëdyuzh ne kayakzëët lo de yra de, axtegue ne gakzëëto ydendxee gyëzlyu chen gaknan yrandxee méno; lex nitlo gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Che wkaa profet-Daniel xkwent ne mbixleedx; por neguin chene kwii de zhoob ne mbixleedx lenxeydoo Dëdyuzh (men ne gool neree, ydee men kwento), ");
INSERT INTO zpi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","men ne nuu Judea rap men degne yzhoon men gya men gyeey den. ");
INSERT INTO zpi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Men ne zob xtoo xyuu rap men degne yzhoon men, koodet men ne nuu lenxyuu men; ");
INSERT INTO zpi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","men ne zu den ybereedet men tsaxii men xab men. ");
INSERT INTO zpi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Prob yra wnaa ne nakzhiin chene ydxiin dxe guin! ¡Prob yra wnaa ne rap mëëd ne roo dud! ");
INSERT INTO zpi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gunab lo Dëdyuzh ne gakdet neree mëëw ne rak nal ni dxe ne rne be. ");
INSERT INTO zpi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porke chene ydxiin dxe guin, kesentyent tsuu gyelenles ne nunk gardet tsuu kwlolne waa gyëzlyu, ni ybereedetro tsuu we. ");
INSERT INTO zpi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Belne ytsowndopdet Dëdyuzh tyemp ne gak yra neguin, rutlel yláádet; per stsowndop No por ne ryaan Ne yra xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Chene ydxiin dxe guin, belne nuu mén yna lo de yra de: “Gukwii, le Crist zu nee”, o “Gukwii, le Crist zu wa”, ylaleedxdet de men. ");
INSERT INTO zpi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porke zuu ndal mén ne ykade, gue men laa men nak Crist, no zuu ndal mén ne ykade, gue men laa men nak profet; ylaa men gyelmilaguer no ylaa men logne yzee sak mén, chen ykade men mén no belne gun men gan, axtegue xpén Dëdyuzh ykade men. ");
INSERT INTO zpi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Le yra neree che nague noo lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Por neguin belne yna men lo de: “Nan de gon, le Crist zu denbidx”, tsadet de; o belne yna men: “Nan de gon, le Crist nuu lenyuu gwa”, ylaleedxdet do. ");
INSERT INTO zpi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porke chene chiid Men ne wdxiid wak Mén, zaknyoogoo, gako zegne rak chene rkabtsa ne reep nis nes ledne rlen ngbiz raknyoo we axtegue nes ledne raaz ngbiz. ");
INSERT INTO zpi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ledne nex mawet, nyoo rdop ngolo. ");
INSERT INTO zpi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Zegne tesu yra dxe guin ne tsuu gyelenles, gaknkeb lo ngbiz, ni mëëw yzeniidetre, gyitxee yra mël ne ndxiib gyeybaa, no yni yrandxee ne nuu gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Cheguin tsuu beey gyeybaa ne chiid Men ne wdxiid wak Mén. Yrandxee mengyëzlyu kesentyent goon men no swii men Men ne wdxiid wak Mén zëëd men lad bëw ydebxpoder men no ydebxgyelenzoon men. ");
INSERT INTO zpi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","No yxaal men yra xangel men kwëz xangel men trompet kesentyent fwert, chen ytop xangel men yrandxee xpén men, men ne nuu ydendxee gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Gukwii zegnak yag-ig: Chene rreeno ne rlen gyizh lo we, ryenengue de ne le mëëw ne rak neey che zëdyob. ");
INSERT INTO zpi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Zenga ke chene kwii de ne le yra neree che kayak, syenengue de ne le Men ne wdxiid wak Mén che zëdguex. ");
INSERT INTO zpi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nligue yna noo lo de yra de ne antes ne guet yra mén ne nuu naaree, gak yra neree. ");
INSERT INTO zpi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Gyeybaa no le gyëzlyu snitlo we, per le xdiiz noo tesudet ne gako. ");
INSERT INTO zpi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Per le dxe, le or ne gako, rut nandeto, ni angel ne nuu gyeybaa nandeto, ni XPee Dëdyuzh. Nonchee Dëdyuzh Xuz be nano. ");
INSERT INTO zpi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Zegne wak tyemp ne wuu Noé, zenga ke gak chene chiid Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tyemp guin, antes ne gyab gyoroo gyoduxtee, ru mén, roo mén, rtsëlnya mén, rdee zhinzaap men rtsëlnya, axtegue ne le dxe ne wdee Noé lenbark wdxiin. ");
INSERT INTO zpi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Axtegue bet wadet lextoo men, tebegue wzelo wyab gyoroo gyoduxtee, weeyo men yrandxee men. Zenga ke gak chene chiid Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chene ydxiin dxe guin, ledne zu txup mgyeey den, te men gya, te men gyan. ");
INSERT INTO zpi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Zenga ke ledne kayuut txup wnaa, te men gya, te men gyan. ");
INSERT INTO zpi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Por neguin list gugak yra de, porke nandet de gan pa dxe chiid Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gugaknan neree, ne belne nan xpexwaan te yuu gan pa or ydxiin ngbaan gyëël tee ngbaan kwan ngbaan lenxyuu men, sobna men ydeedet men si tee ngbaan kwan lenxyuu men. ");
INSERT INTO zpi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Zenga ke laa de yra de, list gugak; porke te dxe ne axtegue ni kambë́zdet de Men ne wdxiid wak Mén, chiid men. ");
INSERT INTO zpi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Txu nak te moswen? Laa men nga nak te men ne noze list zu ne rsan xpatron men yra xpén xpatron men lo men chen ydee men ne gu men or ne ryal gu men. ");
INSERT INTO zpi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nzoon mos guin ne chene rberee xpatron men, le men kalaa dxiin ne ryal ylaa men. ");
INSERT INTO zpi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nligue yna noo lo de yra de ne su xpatron men men ynebééy men yrandxee ne rap xpatron men. ");
INSERT INTO zpi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per belne mal mos guin, nuu lextoo men ybereedetgue xpatron men, ");
INSERT INTO zpi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","rzelo men rzakzi men semos men, le laa men ru rootee yra men menguu. ");
INSERT INTO zpi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Laatee te dxe ne axtegue ni kambë́zdet mos guin xpatron men, ydxiin xpatron men no te or ne axtegue ni nandet men ne ydxiin xpatron men. ");
INSERT INTO zpi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Lex kesentyent yzakzi xpatron men men, yxaal men men ledne ryal gya yra mén ne noze rkanlo wen; nga goon men axtegue guleey men. ");
INSERT INTO zpi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Lex re Jesus: ―Ledne rnebééy Dëdyuzh gak zegne wzak chii nzebmenyu ne wzen tegue bnii ne rkaa kon seyt; wa nzeb wakambë́z nzeb nobyemgyeey. ");
INSERT INTO zpi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gaay nzaap guin bet wadet lextoo, le sgaay nzeb waklist. ");
INSERT INTO zpi_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yra nzaap ne bet wadet lextoo, wzen nzeb bnii, per weeydetre nzeb seyt; ");
INSERT INTO zpi_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","per le yra nzaap ne waklist, waa weeyre nzeb steblmet seyt no wzen ke nzeb bnii. ");
INSERT INTO zpi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Per kom wdxiindetgue nobye, wdxiiden nzeb mkaal yra nzeb, waguees nzeb. ");
INSERT INTO zpi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Zeg gwrool gyëël won nzeb wlen te rëz, kesentyent ndíp re we: “¡Le nobye che zëëd; guruu ytsëlo de men!” ");
INSERT INTO zpi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Orguin waxee yra nzaap guin, wlaxnëz nzeb bnii ne nzen nzeb. ");
INSERT INTO zpi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Lex re yra nzeb ne bet wadet lextoo lo yra nzeb ne waklist: “Guniiz tebruu xseyt de ynab noo, porke le bnii ne nzen noo che zayuu.” ");
INSERT INTO zpi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Per wke yra nzeb ne waklist, re nzeb: “Yniizdet noo we, porke naap gaglodeto por noo ni por laa de yra de. Mazdee gutsa ledne rdoo we, yka de ne ykyiinen de.” ");
INSERT INTO zpi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Or ne le yra nzaap guin zaka seyt, wdxiin nobye; le yra gaay nzaap ne waklist wdenal nobye lo dooy, wzëëgue yaglaa. ");
INSERT INTO zpi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chene le yra nzaap guin wberee, re nzeb: “¡Dechey, dechey, guxal yaglaa tee noo!” ");
INSERT INTO zpi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Per wke nobye, re men: “Nligue yna noo lo de yra de, ne rnebeeydet noo de.” ");
INSERT INTO zpi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Por neguin list gugak yra de porke nandet de gan pa dxe, gan pa or chiid Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ne rkyeen Dëdyuzh nak zegnak te mgyeey ne che nuu ne yruu tsa nat; lex wbëz men yra xmos men, wsan men xmed men lo xmos men. ");
INSERT INTO zpi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Te lo mos wdee men gaaymil, le lo men ste men wdee men txupmil, le lo men ste men wdee men temil, te te lo men wdee men lal ne ryenen men ne gun men gan ylano men dxiin. Lex wruu men za men nat. ");
INSERT INTO zpi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Men ne wnëëz gaaymil wlano meno dxiin, wuno gan ste gaaymil. ");
INSERT INTO zpi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Zenga ke wlaa men ne wnëëz txupmil, wuno gan ste txupmil. ");
INSERT INTO zpi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per le men ne wnëëz temil, wa men wkeen men te gyeer lyu, wgulaan men xmed xpatron men. ");
INSERT INTO zpi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Chene che wakxche, wberee ke xpatron yra mos guin, lex wnab patron guin kwent lo men. ");
INSERT INTO zpi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Primer wdxiin men ne wnëëz gaaymil, lex wdekwent men ste gaaymil lo xpatron men, re men: “Dechey, te gaaymil ne wniiz de lo noo, wun noo gan ste gaaymil, le we nee.” ");
INSERT INTO zpi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Lex re patron guin lo men: “Weno, te moswen nak de, wen wlaa de; ya ke ne wen wlaa de kon ne zhi, orrenaa yzu noo de ynebééy de ne mazre ndaldee. Gutee, guzhiilen zegne rzhiilen noo.” ");
INSERT INTO zpi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Zhich guin wdxiin mos ne wnëëz txupmil, re men: “Dechey, te txupmil ne wniiz de lo noo, wun noo gan ste txupmil, le we nee.” ");
INSERT INTO zpi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Lex re patron guin lo men: “Weno, te moswen nak de, wen wlaa de; ya ke ne wen wlaa de kon ne zhi, orrenaa yzu noo de ynebééy de ne mazre ndaldee. Gutee, guzhiilen zegne rzhiilen noo.” ");
INSERT INTO zpi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Per chene wdxiin mos ne wnëëz temil, re men lo patron guin: “Dechey, che nan noo ne wdee beey nak de, rlaap de ne wak ledne wguudet de bni no rtop de ne wak ledne wlaaldet de zhobbni. ");
INSERT INTO zpi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Por neguin wdxe noo, wa noo wkyeen noo te gyeer wgulaan noo xmed de; le xmed de nee.” ");
INSERT INTO zpi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Wke patron, re men lo men: “Mosmal, mosngol, belne nan de ne rlaap noo ne wak ledne wguudet noo bni no ne rtop noo ne wak ledne walaaldet noo we, ");
INSERT INTO zpi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿penak waludet de xmed noo bank cheguin? Lex chene nberee noo, nkakwent noo we ydebzhiino.” ");
INSERT INTO zpi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Lex re patron lo yra men ne ndxin nga: “Gugyitxee temil gwa lo men, gudee we lo men ne nzen chiimil. ");
INSERT INTO zpi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porke mén ne nzeno, mazre ndaldoo sen men, axtegue sober sen meno; per le mén ne nzendeto, axtegue ne nzenendxee men ybetxee lo men. ");
INSERT INTO zpi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Le mosree ne bat ykyiindet, gukoo men fwer lo nkeb ledne goon men axtegue guleey men.” ");
INSERT INTO zpi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Chene chiid Men ne wdxiid wak Mén ydebxpoder men no le yra men xangel men, sob men lo xyagzhilnzoon men. ");
INSERT INTO zpi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ydop yrandxee mén ne nuu ydendxee gyëzlyu lo men; lex kowaa men mén zegne rlaa men ne rapkwent mëkzhiil, rbowaa men mëkzhiil lad chib. ");
INSERT INTO zpi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Men ne nak xpén men, yzu men koo men ladbëë; le men ne nakdet xpén men, yzu men koo men ladbëg. ");
INSERT INTO zpi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kom laa men nak rrey, lex gue men lo yra mén ne ndxin koo men ladbëë: “Gutaa yra de zegne wneleey Dëdyuzh Xuz noo de; gutee ledne rnebééy me ledne che nak por laa de desde ne waa gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Porke chene wlaanen noo, laa de yra de wniiz ne wu noo; chene wlaan noo nis, wniiz de nis woo noo; chene wkanza noo, wniiz de ledne wbë́z noo; ");
INSERT INTO zpi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","chene wakyët xab noo, wniiz de lër wak noo; chene wzhuun noo, wdxiid de wii lo noo; chene wuu noo chegyiib, wdxiid de wii lo noo.” ");
INSERT INTO zpi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Lex yke yra xpén men, gue men: “Dechey, ¿pa or wii noo wlaanen de ne wniiz noo ne wu de? ¿Pa or wii noo wlaan de nis ne wniiz noo nis woo de? ");
INSERT INTO zpi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Pa or wii noo wkanza de ne wniiz noo ledne wbë́z de? ¿Pa or wakyët xab de ne wniiz noo lër wak de? ");
INSERT INTO zpi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Pa or wii noo wzhuun de u pa or wii noo wuu de chegyiib ne wa noo wii lo de?” ");
INSERT INTO zpi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yke rrey guin, gue men: “Nligue yna noo lo de yra de ne chene wlaa do por te ménree ne nak xpén noo, mase zhindxee non men, lo noo nga wlaa do.” ");
INSERT INTO zpi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Lex gue rrey guin lo yra mén ne ndxin koo men ladbëg: “Gubetxee lo noo, menmal; gutsa tsuu de lo gyi ne nunk gyuudet ne che list nak por Bzelo yra Bzelo xpén Bzelo. ");
INSERT INTO zpi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Porke chene wlaanen noo, wniizdet de ne nyu noo; chene wlaan noo nis, wniizdet de nis nyoo noo; ");
INSERT INTO zpi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","chene wkanza noo, wniizdet de ledne nbë́z noo; chene wakyët xab noo, wniizdet de lër nyak noo; chene wzhuun noo no chene wuu noo chegyiib, wdxiidet de wii lo noo.” ");
INSERT INTO zpi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Lex yke men yra men, gue men: “Dechey, ¿pa or wii noo wlaanen de? ¿Pa or wii noo wlaan de nis? ¿Pa or wii noo wkanza de? ¿Pa or wii noo wakyët xab de? ¿Pa or wii noo wzhuun de, u pa or wii noo wuu de chegyiib, ne wundet noo xyudar de?” ");
INSERT INTO zpi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yke rrey guin, gue men: “Nligue yna noo lo de yra de, yra ne wlaadet de por te ménree ne nak xpén noo, mase zhindxee non men, lo noo nga wlaadet do.” ");
INSERT INTO zpi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yra men ne wlaa zenga gya ledne sakzi men ydeblo siguelendxee, le yra menwen gap gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Chene wluzh re Jesus yra neree, re Ne lo xpén Ne: ");
INSERT INTO zpi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Laa de yra de nan de ne nee stxup gbiz rak falt ne ydxiin lni pask, lex ydekwent mén Men ne wdxiid wak Mén chen ykaa mén men lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Cheguin ke wdop yra fxuz ne rnebééy lo yra fxuz yra men men ne rnebééy lo men-Israel ruxyuu Caifás, fxuz ne mazre nondee. ");
INSERT INTO zpi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nga wyan men diiz gan pezee kode men Jesus chen ynëëz men Ne yket men Ne. ");
INSERT INTO zpi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Per re men: ―Ylaadet bo lo lni chen gakntozdet mengyëz lo be. ");
INSERT INTO zpi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Chene ka Jesus gyëz-Betania ruxyuu Simon men ne rnii ke men Leproso, ");
INSERT INTO zpi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","wbig te wnaa lo Jesus neey men te bot alabastro, yzaa we perfum ne kesentyent nyezh non. Or ne zob Ne lo mezh, wdxiib men perfum guin xtoo Ne. ");
INSERT INTO zpi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ne wii yra xpén Ne ne wlaa wnaa guin zenga, wlaa men, lex re men: ―¿Penak noze wxiin wnaa gwa negwa? ");
INSERT INTO zpi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mazre wendee ntoo meno no nyezhyaa ndoo we chen nruu med nkyiinen menprob. ");
INSERT INTO zpi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ne won Jesus zenga, re Ne lo men: ―¿Penak rnii de por wnaaree? Neree ne wlaa men noo, weno. ");
INSERT INTO zpi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Porke menprob yzaandxee dxe tsuu men lad de, per le noo che xchedetre tsuu noo lad de. ");
INSERT INTO zpi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Neree ne wlaa wnaaree ne wdxiib men perfum led noo, wlaa meno chen che list nak noo chene tsugyeer noo. ");
INSERT INTO zpi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nligue yna noo lo de yra de ne ydendxee gyëzlyu ledne gakzëëttee xdiznzoon Dëdyuzh, zakzëët ke ne wlaa wnaaree, chen zenga ynileedx mén men. ");
INSERT INTO zpi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Men ne la Judas Iscariote ne nak ke xpén Jesus chibtxup wa lo fxuz ne rnebééy lo yra fxuz, ");
INSERT INTO zpi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","re men: ―¿Palal yniiz de noo ynizkwent Jesus lo de? Lex wdee men galebchii med plat lo Judas. ");
INSERT INTO zpi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Desde cheguin wzelo Judas wye Judas gan pezee ydekwent Judas Jesus lo men. ");
INSERT INTO zpi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Primer dxe lni pask ne ru mén gyëtxtil ne nootsdet lebadur, wbig yra xpén Jesus wnabdiiz men lo Ne, re men: ―¿Pazh rlaan de yzhexkwaa noo ne guxsëë be lo lniree? ");
INSERT INTO zpi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wke Ne re Ne: ―Gutsa Jerusalén ruxyuu te mén ne rnebeey noo, lex gue de lo men: “Zere na Maxter: Le xor Maxter che zëdyob. Ruxyuu de rlaan Maxter tee Maxter pask yra Maxter xpén Maxter.” ");
INSERT INTO zpi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Lex wlaa xpén Ne zegne wkyeen Ne, wzhexkwaa men ne guxsëë Ne lo pask yra Ne men. ");
INSERT INTO zpi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Chene wnit lyu, wzob Jesus lo mezh yra Ne chibtxup xpén Ne; ");
INSERT INTO zpi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","or ne kayu Ne yra Ne men, re Ne lo men: ―Nligue yna noo lo de yra de, ne laake de te de nak ne ydekwent noo lo mén chen yzakzi men noo. ");
INSERT INTO zpi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ne won men zenga, kesentyent wunles lextoo men, wzelo men rnabdiiz men lo Ne te te men, re men: ―Dechey, ¿peguin noo ne? ");
INSERT INTO zpi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wke Ne re Ne: ―Men ne rgoob ne ru lengyaan ke ne rgoob noo ne ru noo nak ne ydekwent noo lo mén chen yzakzi men noo. ");
INSERT INTO zpi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Men ne wdxiid wak Mén rap men degne sak men zegne re lo xgyiich Dëdyuzh; per ¡prob mén ne ydekwent men! Mazre wendee por laa mén guin ne nyaldet men. ");
INSERT INTO zpi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Lex wke Judas ne ydekwent Jesus, re men: ―Maxter, ¿peguin noo ne? Wke Ne re Ne: ―Zegwa we zeg na de. ");
INSERT INTO zpi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Or ne kayu Ne yra Ne men, wgoob Ne gyëtxtil, wdee Ne dexkyizhtee lo Dëdyuzh, lex wla No wdee No lo yra xpén Ne, re Ne: ―Gunëëz gyëtxtilree, gugu we; laa we nak xkwerp noo. ");
INSERT INTO zpi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Zhich guin wgoob Ne bas ne nuu bin, wdee Ne dexkyizhtee lo Dëdyuzh, lex wdee No lo men yra men, re Ne: ―Gugoo ne nuu lenbasree yra de, ");
INSERT INTO zpi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","porke laa we nak xren noo ne yzhe chene guet noo por ndal mén, chen gyal te nëzkweb ne gak ydxiin men lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","No yna noo lo de yra de ne goodetre noo bin ub, axtegue chene ydxiin dxe ne goo noo binkweb yra noo de ledne rnebééy Xuz noo. ");
INSERT INTO zpi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wluzhse wolbaan Jesus te salmo yra Ne xpén Ne, za Ne gyey-Olivos yra Ne men. ");
INSERT INTO zpi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Lex re Ne lo men: ―Sboleedx de noo yrandxee de negyëëlree, porke zenga zëëd lo xgyiich Dëdyuzh ledne re: “Yket noo men ne rapkwent mëkzhiil, le mëkzhiil noze yrëëts.” ");
INSERT INTO zpi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per chene che wban noo, sanergue noo lo de tsa noo Galilea. ");
INSERT INTO zpi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Wke Bëd, re Bëd: ―Mase koleedx men de yra men, per noo nunk koleedxdet noo de. ");
INSERT INTO zpi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Lex re Jesus lo Bëd: ―Nligue yna noo lo de ne negyëëlkeree, antes ne ykarëz ngyedgol, che wyon tir wkedxnruu de ne rnebeey de noo. ");
INSERT INTO zpi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Lex re Bëd ste: ―Mase guet noo tese yrup noo de, per ykedxnruudet noo ne rnebeey noo de. Zenga ke re yra xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ne wdxiin Jesus ledne la Getsemaní yra Ne xpén Ne, re Ne lo men: ―Nee gusob myentras ne le noo tsa nodese ynab noo lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wzano Ne Bëd no le yrup xpee Zebedew, lex wlen kesentyent wunles lextoo Ne, axtegue baanske wuu lextoo Ne. ");
INSERT INTO zpi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Orguin re Ne lo men: ―Kesentyent nles nuu lextoo noo, zem zet noo lo gyelenlesree. Nee gugyan, gusobna. ");
INSERT INTO zpi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Lex za Ne nodese, wandeslo Ne wtee lo Ne lyu wnab Ne lo Dëdyuzh, re Ne: ―Dëde, belne gak yselaa de noo lo gyelenlesree, guselaa noo; per gakdet zegne rlaan noo, sinke zegne rlaan de. ");
INSERT INTO zpi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Zhich guin wberee ke Ne ledne wyan men gyon men; chene wdxiin Ne, le men ndxinguees. Orguin re Ne lo Bëd: ―¿Pe ni te or wakdet nzobna de? ");
INSERT INTO zpi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gusobna, gunab lo Dëdyuzh chen ysegyeedet Bzelo lextoo de. Rlaan de ylaa de ne wen, per led de rundet gan. ");
INSERT INTO zpi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ne wrup tir wa Jesus wnab Ne lo Dëdyuzh, re Ne: ―Dëde, belne gakdet tesu gyelenlesree sin ne sakdet noo we, gak zegne rlaan de. ");
INSERT INTO zpi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Chene wberee Ne, le men ndxinguees ke ste, porke noze rdiib bzalo men tant zëëden men mkaal. ");
INSERT INTO zpi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Lex wsan Ne men za Ne zanab Ne lo Dëdyuzh ne wyon tir, zenga ke re Ne. ");
INSERT INTO zpi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chene wberee Ne ledne ndxin men ste, re Ne lo men: ―¿Pe benak ndxinguees de? ¿Pe benak ndxinne de? Le or ne ynëëz mén Men ne wdxiid wak Mén che wdxiin, chen ydekwent mén men lo mendol. ");
INSERT INTO zpi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gutsaxee, guseyoo naa; le men ne ydekwent noo che zëdguex. ");
INSERT INTO zpi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Benak kanii Jesus chene wdxiin Judas; te ke men ne nak xpén Jesus chibtxup nak Judas; wdxinno Judas ndalyaa mén ne nzen spad no mén ne nzen yag. Laa fxuz ne rnebééy lo yra fxuz no le men ne rnebééy lo men-Israel wxaal yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Che re Judas lo yra mén guin gan pezee ydekwent Judas Ne lo men, re Judas: ―Men ne goo noo bzhid gyedkwes, laa men nga; ynëëzgue de men. ");
INSERT INTO zpi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Zegne wdxiin Judas, wbiggue Judas lo Jesus, re Judas: ―¡Payuz, Maxter! Lex woo Judas bzhid gyedkwes Ne. ");
INSERT INTO zpi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Wke Ne re Ne lo Judas: ―Judas, gulaa ne zëëd de ylaa de. Lex wbig yra mén guin wnëëzgue men Ne chen sano men Ne. ");
INSERT INTO zpi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Orguin wboo xespad te ke men ne zuno Jesus nga, wkyits meno gyedyag xmos fxuz ne mazre nondee, wtxugnëz meno tebo. ");
INSERT INTO zpi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Lex re Jesus lo men: ―Gugutsoow spad gwa xlugaro. Porke yrandxee men ne rdil kon spad, kon spad ke guet men. ");
INSERT INTO zpi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Pe nandet de ne zak ynab noo lo Xuz noo no orgueree yxaalgue me mazdee tsonlalno-chibtxupmil xangel me chidselaa noo? ");
INSERT INTO zpi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per belne ylaa noo we, ¿pezee gak kumplir ne re lo xgyiich Dëdyuzh cheguin, ledne re ne rap degne gak zeree? ");
INSERT INTO zpi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Orguin re Jesus lo yra mén guin: ―¿Penak zëëd de zëdnëëz de noo kon spad, kon yag, zeg teleg ngbaan nak noo? No yzaandxee dxe wzu noo lenxeydoo Dëdyuzh wkaneluu noo de yra de, no wnëëzdet de noo. ");
INSERT INTO zpi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per kayak yra neree chen gak kumplir yra ne wkaa profet lo xgyiich Dëdyuzh. Orguin wzhoon yra xpén Ne, wsan men Ne tendxee Ne. ");
INSERT INTO zpi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yra mén ne wa wanëëz Jesus, wano men Ne lo Caifás, fxuz ne mazre nondee. Nga ndxin yra maxter ley yra men men ne rnebééy lo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Le Bëd zanal Ne nat nat axtegue ne wdxiin Bëd ruxyuu fxuz ne mazre nondee. Lex wdee Bëd wzob Bëd yra Bëd men ne rapkwent xeydoo Dëdyuzh, chen kwii Bëd gan kox ylaa men Ne. ");
INSERT INTO zpi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Le yra fxuz ne rnebééy lo yra fxuz no le yra xtis-Israel rye mén ne noze ykade chen tsël gan pezee ykagyii men Ne, chen gak ykyeen men guet Ne. ");
INSERT INTO zpi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Per wzëldet gan pezee nkade men, mase ndal mén wbig wkagyii Ne. Zhich guin wbig stxup men ne noze rkagyii Ne, ");
INSERT INTO zpi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","re men: ―Re ménree: “Noo zun noo gan ylitla noo xeydoo Dëdyuzh no tsonegue gbiz ylep ke noo we.” ");
INSERT INTO zpi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Orguin wzuli fxuz ne mazre nondee, re men lo Jesus: ―¿Pe bet ykedet de? ¿Pe rna rnii men zeree por laa de? ");
INSERT INTO zpi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per wkedet Jesus. Lex re fxuz ne mazre nondee: ―Por la Dëdyuzhmbán ykyeen noo de ne yzëët de belne laa de nak Crist XPee Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Lex re Jesus: ―Zegwa we zeg na de, yna noo lo de yra de, ne swii de zob Men ne wdxiid wak Mén koo Dëdyuzhnzoon ladbëë no swii de zëëd men lad bëw gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Orguin wtxëz xab fxuz ne mazre nondee, re men: ―Diznyaan rnii ménree por Dëdyuzh; pe ylar be testig. Laa de yra de che won de ne diznyaan rnii men. ");
INSERT INTO zpi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Pe na de, pezee gak men? Wke yra mén guin, re men: ―Guet men rzëël. ");
INSERT INTO zpi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Lex wtxonxen men txegwlo Jesus no wgupunyet men Ne; le stebëd men wgap txegwlo Ne, ");
INSERT INTO zpi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","re men lo Ne: ―Belne laa de nak Crist, ¿txu rniiz xkwent de gan? ");
INSERT INTO zpi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Or ne zob Bëd ruxyuu fxuz ne mazre nondee, wbig te wnaa ne rlaa dxiin nga lo Bëd, re men: ―¿No de nak xpén Jesus men-Galilea ye? ");
INSERT INTO zpi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per wkedxnruu Bëd nes lo yra mén guin, re Bëd: ―Axtegue nandet noo gan pagox gwa rnii de. ");
INSERT INTO zpi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Zhich guin or ne zaruu Bëd ruporton, wii ste wnaa ne rlaa dxiin nga ne za Bëd; lex re men lo yra mén ne ndxin nga: ―No mgyeeyree nak xpén Jesus men-Nazaret. ");
INSERT INTO zpi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Per wkedxnruu Bëd ste, wgon Bëd Dëdyuzh, re Bëd: ―¡Axtegue rnebeeydet noo mgyeey gwa! ");
INSERT INTO zpi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Orsegue wako, wbig men ne ndxin nga lo Bëd, re men: ―Nlipee ne no de nak te xpén men, porke axtegue zegne rnii de nakbeey. ");
INSERT INTO zpi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Lex wgon Bëd Dëdyuzh, re Bëd: ―Dëdyuzh yzakzi noo belne nlidet rnii noo. ¡Noo axtegue rnebeeydet noo mén gwa! Orke guin wkarëz te ngyedgol. ");
INSERT INTO zpi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Orguin wnileedx Bëd ne re Jesus lo Bëd: “Antes ne ykarëz ngyedgol, che wyon tir wkedxnruu de ne rnebeey de noo.” Lex wruu Bëd nga; baanske woon Bëd. ");
INSERT INTO zpi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Chene wyenii lyu, wyan yra fxuz ne rnebééy lo yra fxuz diiz yra men men ne rnebééy lo men-Israel gan pezee yket men Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Lex wliib men Ne zano men Ne, wdekwent men Ne lo Poncio Pilato ne nak gobernador. ");
INSERT INTO zpi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Chene wii Judas ne wdekwent Jesus, ne le men che wal yket Jesus, ngyidet wuu lextoo Judas, wa Judas wacheree Judas yra galebchii med plat guin lo fxuz ne rnebééy lo yra fxuz no le lo men ne rnebééy lo men-Israel, ");
INSERT INTO zpi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","re Judas: ―Noze xdol noo wye noo ne wnizkwent noo te mén ne bet xdoldet chen guet men. Per wke men yra men, re men: ―¿Pe ylaa noo cheguin? ¡Xkwent de nga! ");
INSERT INTO zpi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Orguin wtxoon Judas yra med guin lenxeydoo Dëdyuzh, wruu Judas nga. Wa Judas wasee Judas duu yen Judas, wxii Judas yen Judas. ");
INSERT INTO zpi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lex wtop yra fxuz ne rnebééy lo yra fxuz yra med guin, re men: ―Nuudet ysee be medree ledne ruu goon porke medree wezh wka men ne wnizkwent men ne guet. ");
INSERT INTO zpi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Orguin wuu men diiz yra men, kon med guin wka men xelyu mén ne rzhexkwaa ne yu, chen nga tsugyeer menzit. ");
INSERT INTO zpi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Por neguin axtegue naaree benak la lyu guin Lyu Ren. ");
INSERT INTO zpi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Zenga wak kumplir diiz ne re profet-Jeremías chene re men: “Wnëëz men yra galebchii med plat, lal ne re men-Israel ne non men, ");
INSERT INTO zpi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","kon med guin wka men xelyu men ne rzhexkwaa ne yu zegne wkyeen Dëdyuzh noo.” ");
INSERT INTO zpi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Chene zu Jesus lo gobernador-Pilato, wnabdiiz men lo Ne, re men: ―¿Pe laa de nak xerrey men-Israel? Wke Ne re Ne: ―Zegwa we zeg na de. ");
INSERT INTO zpi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Or ne le yra fxuz ne rnebééy lo yra fxuz kakagyii Jesus yra men men ne rnebééy lo men-Israel, bet wkedet Ne. ");
INSERT INTO zpi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Lex re Pilato lo Ne: ―¿Pe rondet de yra ne kanii men por laa de? ");
INSERT INTO zpi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per ni te diiz wkedet Ne. Por neguin kesentyent wzee wzak Pilato. ");
INSERT INTO zpi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lo lni nak xkoxtumber Pilato rselaa Pilato te mén ne nuu chegyiib, log mén ne guetee mengyëz. ");
INSERT INTO zpi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Cheguin nuu te men ne la Barrabás chegyiib; nesree nesrotee nuu diiz yra ne wlaa men. ");
INSERT INTO zpi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Chene le yra mén wdop, wnabdiiz Pilato lo yra mén, re Pilato: ―¿Txu rlaan de yselaa noo, Barrabás u Jesus ne rnii mén Crist? ");
INSERT INTO zpi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Re Pilato zenga porke wyenen Pilato ne por gyelembidye wdekwent men Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Or ne le Pilato zob ledne rlaa Pilato gyelextis, wxaal xewnaa Pilato diiz lo Pilato, re men: “Ygaldet de mgyeey gwa, bet xdoldet men. Porke kesentyent ndxiin wnexgyëëlen noo negyëëlree por laa men.” ");
INSERT INTO zpi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per le fxuz ne rnebééy lo yra fxuz no le yra men ne rnebééy lo men-Israel che wun men gan wguu men lextoo yrandxee mén chen ynab men ne yláá Barrabás, le Jesus guet. ");
INSERT INTO zpi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Lex wnabdiiz Pilato lo yra mén ste, re Pilato: ―¿Delo yrup ménree, txuzh rlaan de yselaa noo? Wke men re men: ―¡Barrabás! ");
INSERT INTO zpi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Orguin re Pilato: ―¿Jesus ne rnii mén Crist naa, pagox ylaa noo men? Wke men yra men, re men: ―¡Lo kruz gukaa men! ");
INSERT INTO zpi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Lex re Pilato lo men yra men: ―¿Penako? ¿Pe ne malzhe wlaa men? Per lel mazre rderëz men, re men: ―¡Lo kruz gukaa men! ");
INSERT INTO zpi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Chene wyenense Pilato ne rukasdet mén xdiiz Pilato, sinke lel mazre rderëz men, wgoob Pilato nis, waa nya Pilato nes lo men yra men, lex re Pilato: ―Let noodet rap dol ne guet ménree ne bet xdoldet; laatee de nan. ");
INSERT INTO zpi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lex wke men yrandxee men, re men: ―Led noo yra noo no le led zhiin noo gyab dol gwa. ");
INSERT INTO zpi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Orguin wselaa Pilato Barrabás; lex wkyeen Pilato soldad ne ydee soldad xkwent Jesus; chene wluzh wdee men xkwent Ne, wdekwent Pilato Ne lo men chen tsakaa men Ne lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Zhich guin zano men Ne ruyuloow; lex wtop men yrandxee sesoldad men wbiin men noze kbii Ne. ");
INSERT INTO zpi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wluzh nga wboo men xab Ne, wnegak men Ne te lërnloo, ");
INSERT INTO zpi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","no wzhexkwaa men te korongyëts wzoob meno xtoo Ne, no wguu men tebla bëg nyabëë Ne. Lex rzuzhib men lo Ne, rzhidxno men Ne, re men: ―¡Kesentyent non xerrey men-Israel! ");
INSERT INTO zpi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Rtxonxen men led Ne no rnëëz men bëg guin ne nzen Ne rkyits meno xtoo Ne. ");
INSERT INTO zpi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chene wluzh wlaa men Ne zenga, wboo ke men lërnloo guin led Ne, wnegak ke men Ne xab Ne, lex zano men Ne chen ykaa men Ne lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Chene wruno men Jesus nga, nëz wtsëlo men te men-Cirene ne la Simon, lex wkyenfwers men mén guin weey men xekruz Ne. ");
INSERT INTO zpi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Chene wdxiin men ledne la Gólgota (Gólgota rna, Berxtoo Mengut.), ");
INSERT INTO zpi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","nga wdee men bin ne noots ne kesentyent nla nyoo Ne; per chene wzeen No, nadet Ne nyoo No. ");
INSERT INTO zpi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chene che wkaa soldad Ne lo kruz, wa soldad pwest gan txuzh yganen xab Ne. Zenga wak kumplir diiz ne zëëd lo xgyiich Dëdyuzh ledne re: “Wgyizlsaa men xab noo no wa men pwest gan txu yganeno.” ");
INSERT INTO zpi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lex wzob men nga, wbinnap men Ne. ");
INSERT INTO zpi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wkaa men leter xtoo xekruz Ne gan pe kwentzhe ka Ne nga, re leter guin: “Laa Jesus ne nak xerrey men-Israel nee.” ");
INSERT INTO zpi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","No wkaa men txup ngbaan lo kruz, te men wkaa lo kruz ne zob koo Ne ladbëë, le ste men wkaa lo kruz ne zob koo Ne ladbëg. ");
INSERT INTO zpi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yrandxee mén ne rdee nga, rdxii xtoo men, rninyaan men lo Ne, ");
INSERT INTO zpi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","re men: ―Laa de nga nlitla xeydoo Dëdyuzh no tsonegue gbiz nlep ke do ste, orrenaa guselaa de laake de. Belne XPee Dëdyuzh nak de, gugyët lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Zenga ke rzhidxno yra fxuz ne rnebééy lo yra fxuz Ne yra men maxter ley no le yra men men ne rnebééy lo men-Israel, re men: ");
INSERT INTO zpi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Wselaa ménree ste mén, per rundet men gan yselaa men men laake men. Belne laa men nak xerrey men-Israel, gyët men lo kruz naa chen ylaleedx be men. ");
INSERT INTO zpi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Belne wkalo men Dëdyuzh, yselaa Dëdyuzh men nabes belne nli ryaan Dëdyuzh men; porke re men XPee Dëdyuzh nak men. ");
INSERT INTO zpi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Axtegue no ngbaan ne ka lo kruz ne zob koo Jesus wninyaan lo Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Or ne rwen ngbiz, waknkeb ydendxee gyëzlyu, axtegue beytson wzëë wyenii ste. ");
INSERT INTO zpi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Zeg beytson ke wkarëzyaa Jesus, re Ne: ―Elí, Elí, ¿lama sabactani? ―Diizree rna: Dëdyuzhe, Dëdyuzhe, ¿penak wboleedx de noo? ");
INSERT INTO zpi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Gwrol men ne ndxin nga, ne won men wkarëz Ne, re men: ―Profet-Elías rkarëz men. ");
INSERT INTO zpi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Orgueguin noze rzhoon te ke men ne zu nga, waxii men tebla zhiil, wgaz meno kon binaguer; lex wzoob meno xtoo te bëg, wtee meno ruu Jesus chen goo Ne binaguer. ");
INSERT INTO zpi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Per le stebëd men re: ―Zeka men, gan pe schiid Elías yselaa men. ");
INSERT INTO zpi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Lex wkarëzyaa Jesus ste, wetgue Ne. ");
INSERT INTO zpi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Orgueguin wrëznzeli kortin ne ka lenxeydoo Dëdyuzh, gwrooltee wako, no wni lyu, no waktxupla yra gyeroo, ");
INSERT INTO zpi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","no wyal baa; ndal xpén Dëdyuzh ne che wet wban. ");
INSERT INTO zpi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Chene le Jesus che wban, wruu mén guin lenbaa, wdee men lenlgyëz-Jerusalén, ndal mén wii men. ");
INSERT INTO zpi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ne wii kapitan yra men soldad ne ndxin rapkwent Ne ne kani lyu no le yra neguin ne kayak, kesentyent wdxe men, re men: ―Nli ne XPee Dëdyuzh nak ménree. ");
INSERT INTO zpi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ndal wnaa ne wrunal Jesus axtegue Galilea no ne wun xyudar Ne, ndxin axtegue nat rwii men yra neguin ne kayak. ");
INSERT INTO zpi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lad wnaa guin zu Mli Matlen no zu Mli ne nak xnaa Jacob yrup Jacob Xeb no le xnaa xpiin Zebedew. ");
INSERT INTO zpi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Or ne che rzëë, wdxiin te menrik ne la Xeb ne nak men-Arimatea no mén guin nak te xpén Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wa mén guin lo Pilato wnab men xkwerp Jesus. Lex wkyeen Pilato soldad ne ydekwent soldad Ne lo men. ");
INSERT INTO zpi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Orguin wkakwent men Ne, wtxël men Ne te saben ndaa. ");
INSERT INTO zpi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Lex walu men Ne te lenbakweb ne che wkeen men txugye. Wluzhse wtsëë men rubaa kon te gyeroo, lex sya men. ");
INSERT INTO zpi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Le Mli Matlen no le ste Mli wzobchee nes rubaa guin. ");
INSERT INTO zpi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ne wra gyëël guin, dxe guin nak dxe ne rne men-Israel, wdop fxuz ne rnebééy lo yra fxuz yra men men ne nak farisew, wa men lo Pilato, ");
INSERT INTO zpi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","re men: ―Dechey, wnileedx noo ne chene benak mbán ménro ne nan rkade, re men ne chene gyon gbiz, yban ke men. ");
INSERT INTO zpi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Por neguin gukyeen men ne kwinnap xbaa men axtegue ne gyon gbiz, tegue tsa xpén men gyëël gweey men men, lex gue men lo mén: “Wban men.” Belne ylaa men zenga, mazre ykade men mén ke ne primer. ");
INSERT INTO zpi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Lex re Pilato lo men yra men: ―Le soldad ndxin wa; gutsano soldad chen kwinnap soldad rubaa wen wenendxee zegne rlaan de. ");
INSERT INTO zpi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Lex wa men watsëchiich men rubaa, wguu men te beey rubaa. Zhich guin wsan men soldad wbinnap rubaa. ");
INSERT INTO zpi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chene wdesu dxe ne rne men-Israel ne wyenii lyu dxe ne rzelo xman, wa Mli Matlen wii rubaa yrup men ste Mli. ");
INSERT INTO zpi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tebegue wzelo kesentyent wni lyu, porke wruu te xangel Dëdyuzh gyeybaa, wdxiin ne wgyitxee ne gye ne zemzëë rubaa, lex wzob ne ledo. ");
INSERT INTO zpi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rkabtsa ne zegnak chene reep nis, le xab ne ngyichdoo. ");
INSERT INTO zpi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ne wii yra soldad angel guin, noze rzhiz men tant rdxe men, noze wak men zegnak mengut. ");
INSERT INTO zpi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lex re ne lo yrup wnaa guin: ―Ydxedet de. Che nan noo ne Jesus rye de, men ne wkaa lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yëtre men nee; le men che wban zegne re men. No re angel: ―Gutaa kwii de ledne wguu mén men gante. ");
INSERT INTO zpi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gutsa noze rzhoon de, gue de lo yra xpén men ne le men che wban. Sanergue men lo yra xpén men tsa men Galilea; nga kwii men men. Nonchee neree rap noo degne yna noo lo de. ");
INSERT INTO zpi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Orgueguin wruu yrup wnaa guin rubaa, te rdxe men te rzhiilen men; noze rzhoon men zaluu men diiz lo yra xpén Jesus. ");
INSERT INTO zpi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ne za men nëz, wlalo Jesus lo men, wgabtyuzh Ne men. Wbig men wzuzhib men lo Ne, wgyeedx men nii Ne. ");
INSERT INTO zpi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Lex re Ne lo men: ―Ydxedet de; gutsa gue de lo yra xpén noo tsa men Galilea; nga kwii men noo. ");
INSERT INTO zpi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Myentras ne le yrup wnaa guin za, le tebëd soldad ne ndxinnap ruxbaa Jesus wague waluu diiz lo yra fxuz ne rnebééy lo yra fxuz yra neguin ne wak. ");
INSERT INTO zpi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Zhich guin wa fxuz ne rnebééy lo yra fxuz lo yra men ne rnebééy lo men-Israel chen gyan men diiz gan pezee ylaa men; lex wdee men ndal med lo soldad guin, ");
INSERT INTO zpi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","re men: ―Zeree gue de: “Gyëël or ne nexguees noo, wdxiid xpén men weey men men.” ");
INSERT INTO zpi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Belne gaknan Pilato neree, noo yra noo ynii lo men chen bet ylaadet men de. ");
INSERT INTO zpi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wnëëz soldad med guin, lex wzëët soldad yra diiz guin zegne wkyeen yra mén guin soldad. Laa diiz guin nak ne wrëëts lad men-Israel, axtegue naaree benak rakzëëto. ");
INSERT INTO zpi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lex wa yra chibteb xpén Jesus lo lyu ne la Galilea, xtoo gyeey ne re Ne lo men. ");
INSERT INTO zpi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chene wii men Ne, wzuzhib men lo Ne, mase nuu men legue nutxup lextoo. ");
INSERT INTO zpi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Lex wbig Jesus lo men yra men, re Ne: ―Dëdyuzh wniiz poder lo noo ne ynebééy noo gyeybaa no le gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Por neguin gutsa ydendxee gyëzlyu, yneluu de mén chen gak men xpén noo no ytxobnis de men por la Dëdyuzh no le por la XPee Ne no le por Espíritu Sant. ");
INSERT INTO zpi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","No yneluu de men ylaa men yra ne wkyeen noo de yra de. Lex noo su kon laa de yzaandxee dxe axtegue ne nitlo gyëzlyu.");
INSERT INTO zpi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Zeree wzelo wakzëët xdiznzoon Jesucrist XPee Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wakzëëto zegne zëëd lo liber ne wkaa profet-Isaías ledne re: Noo yxaal te mén ne saner lo de chen ylaxnëz men xnëz de. ");
INSERT INTO zpi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Te rëz rlen denbidx, re we: “Gulaxnëz xnëz Men ne rnebééy, guxal te nëz ne tebli.” ");
INSERT INTO zpi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Zenga wak chene wdxiid Xwa ne rtxobnis, wa Xwa denbidx, re Xwa lo mén ne yrobnis men no ysaan men xgyelmal men chen gun Dëdyuzh perdon xdol men. ");
INSERT INTO zpi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","No yrandxee mén ne nuu lo lyu ne la Judea no le men-Jerusalén rruu ra ron ne rzëët Xwa. Lex rxobdol men, rluzh nga rtxobnis Xwa men rugyow-Jordán. ");
INSERT INTO zpi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kon xgyits kamey nzhexkwaa xab Xwa, le sinturon ne ruu txu Xwa nak gyed, le ne ru Xwa nak miich no le dxin ne nuu den. ");
INSERT INTO zpi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Rzëët Xwa xdiiz Dëdyuzh lo mén, re Xwa lo men: ―Te men ne gyed zëëd, axtegue ni xgyël men rzëëldet noo ychil noo nii men porke mazre rapdee men poder ke lo noo. ");
INSERT INTO zpi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Noo noze kon nis wtxobnis noo de yra de, per le mén guin kon Espíritu Sant ytxobnis men de. ");
INSERT INTO zpi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Cheguin ke wruu Jesus gyëz-Nazaret ne nak lo lyu ne la Galilea, lex wtxobnis Xwa Ne rugyow-Jordán. ");
INSERT INTO zpi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Zegne wruu Ne lo nis, wii Ne wyal gyeybaa no wii Ne zëdtseeb Espíritu Sant, wyab Espíritu Sant led Ne zegnak te mëër, ");
INSERT INTO zpi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","no wlen te rëz gyeybaa, re we: ―Laa de nak XPee noo ne ryaan noo; kesentyent rnesak de lextoo noo. ");
INSERT INTO zpi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Zhich guin wano Espíritu Sant Jesus denbidx. ");
INSERT INTO zpi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nga wkaa Jesus txuplal gbiz lad maa ne ndux; ne ka Ne nga wlaa Bzelo Ne preb gan pe slaa Ne dol. Zhich guin wdxiin tebëd angel wdee ne wu Ne. ");
INSERT INTO zpi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chene che nuu Xwa chegyiib, wa Jesus lo lyu ne la Galilea wazëët Ne zegne rkyeen Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","re Ne: ―Le or che wdxiin no che wyob gak ne rkyeen Dëdyuzh. Gusaan xgyelmal de; gulaleedx xdiznzoon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Chene za Jesus tebrunis-Galilea, wii Ne zu Simon no le Ndrizh bech Simon, katxoon men xgyix men lo nis porke gozmël rkaa men yrup men. ");
INSERT INTO zpi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Lex re Ne lo men: ―Gutanal noo; noo ylaa ne ylaa de mén xpén Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Orgueguin wsan men xgyix men, zanalgue men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Lex wzaa Ne stebla, wii Ne yrubech xpee Zebedew, Jacob no le Xwa, kalaxnëz men xgyix men lenbark. ");
INSERT INTO zpi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Wbëzgue Ne men, orguin wsan men xuz men lenbark yra xuz men men ne kalano men dxiin, zanal men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wdxiin Jesus gyëz-Capernaum yra Ne men; lex dxe ne rne men-Israel, wdee Ne lenydoo, wzelo Ne wneluu Ne mén. ");
INSERT INTO zpi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Axtegue wzee wzak mén por yra ne rneluu Ne, porke rneluu Ne zegnak te men ne rnebééy, rneluudet Ne zegne rneluu maxter ley. ");
INSERT INTO zpi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lenydoo guin zob te mgyeey ne nuu menzab lextoo. Wzelo menzab rderëz menzab, ");
INSERT INTO zpi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","re menzab: ―¿Penak rdee de lad noo Jesus men-Nazaret? ¿Pe zëëd de yluzh de noo? Rnebeey noo de no nan noo ne nakdet de mendol, XPee Dëdyuzh nak de. ");
INSERT INTO zpi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Orguin wakndux Jesus lo menzab guin, re Ne: ―¡Gusoow ruu de! ¡Guruu lextoo ménree! ");
INSERT INTO zpi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Orguin wlaa menzab ne wlen xgyiz mén guin ste, noze robtsadii menzab wruu menzab lextoo men. ");
INSERT INTO zpi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Yrandxee mén wzee wzak, rnabdizlsaa men, re men: ―¡Pagoxlegree! ¿Pe ne kwebzheree rneluu ménree? ¡Gukwii gante, rap ménree poder rnebééy men axtegue lo menzab, no ron menzab xdiiz men! ");
INSERT INTO zpi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","No ydendxee lo lyu ne la Galilea gyiid gyiidske wrëëts diiz yra neguin ne rlaa Jesus. ");
INSERT INTO zpi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Zegne wruu Jesus lenydoo, wa Ne yra Ne Jacob no le Xwa ruxyuu Simon yrup Simon Ndrizh. ");
INSERT INTO zpi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Le xnasweguer Simon nex lo loon rlen men xlaa, lex re mén lo Jesus ne rzhuun wnaa guin. ");
INSERT INTO zpi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Orguin wbig Jesus lo men, wnëëz Ne nya men wnesobli Ne men; orgueguin wruu xlaa led men. Lex wdee men ne wu Ne yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chene che waaz ngbiz or ne che zëdnit lyu, wano mén yrandxee mengyiz lo Jesus no le mén ne nuu menzab lextoo. ");
INSERT INTO zpi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","No yrandxee mengyëz guin wdxiin ruyuu guin. ");
INSERT INTO zpi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Lex wneseyaken Jesus ndal mén ne rzak noze wren wren gyelgyiz, no wboo Ne menzab lextoo yra mén ne nuu menzab lextoo; per wdeedet Ne si nnii menzab guin porke nan Ne ne che nan menzab guin gan txu nak Ne. ");
INSERT INTO zpi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Te rsil benakre nkeb waxee Jesus, wruu Ne lenlgyëz guin wa Ne te ledne yëtet mén chen ynab Ne lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Lex waye Simon Ne yra Simon xkompanyer Simon. ");
INSERT INTO zpi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Chene wzël Ne lo men, re men lo Ne: ―Le yrandxee mén ka kaye de. ");
INSERT INTO zpi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Per wke Ne re Ne: ―Yoo tsa be yra ledne nak guex nee chen yzëët noo xdiiz Dëdyuzh no nga, porke por neguin zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Zenga wkaa Jesus ydendxee lo lyu ne la Galilea wzëët Ne xdiiz Dëdyuzh lenydoo te te gyëz, no wboo Ne menzab lextoo yra mén ne nuu menzab lextoo. ");
INSERT INTO zpi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wbig te men ne rzak gyiz ne la lepra, wzuzhib men lo Jesus, wnab men lo Ne, re men: ―Belnaal yna de zun de gan yneseyaken de noo. ");
INSERT INTO zpi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Orguin wles lextoo Jesus men, wzegaa Ne nya Ne wtee No led men, re Ne: ―Sna noo. Gugyaken. ");
INSERT INTO zpi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Orgueguin wyaken led mén guin, axtegue nya wyan led men. ");
INSERT INTO zpi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Orguin wguli Jesus men nëz sya men, per re Ne lo men: ");
INSERT INTO zpi_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Che nan de rut lo guedet do, nonchee lo fxuz gutsa gutsaluu led de no gutsaron xgoon de ne che wakndaa de nes lo Dëdyuzh zegne zëëd lo ley ne wdee Dëdyuzh lo Moises chen gaknan mén ne che wyaken led de. ");
INSERT INTO zpi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per zegne wruu mén guin nga, wzelogue men wuu men diiz lo mén neguin ne wak. Por neguin nak ne nuudetre nkanyoo Jesus ni ste gyëz, sinke teblose fwer lenlgyëz wkaa Ne ledne yëtet mén. Per mase zenga, gyëzree gyëzrotee rruu mén rdxiin mén lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chene che wluzh txup tson gbiz, wberee Jesus wdee ke Ne lenlgyëz-Capernaum. Ne waknan mén ne le Ne che ke ka Capernaum, ");
INSERT INTO zpi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","kesentyent ndal mén wdop lo Ne, axtegue rgadet ledne kwiin men; orguin wzëët Ne xdiiz Dëdyuzh lo men. ");
INSERT INTO zpi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Orke guin wdxiin tap mén nga ledne zu Ne, wdxinneey men te mgyeey ne noze waknet led. ");
INSERT INTO zpi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Per kom rakdet ydxiin men axtegue lo Ne por tant ndal mén ndxin lenyuu ledne zu Ne, orguin wlis men tebëd tezh led yuu guin; lex nes guin wlit men mengyiz guin ydebxloon men. ");
INSERT INTO zpi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ne wii Ne ne rlaleedx yra mén guin Ne, re Ne lo mengyiz guin: ―Zhiin, le xdol de che wak perdon. ");
INSERT INTO zpi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Orguin nuu lextoo tebëd maxter ley ne zob nga: ");
INSERT INTO zpi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Penak rnii ménree zeree? Diznyaan rnii men por Dëdyuzh, porke rut rundet gan gun perdon xdol mén, sinke nonchee Dëdyuzh run gan run perdon xdol mén.” ");
INSERT INTO zpi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Per kom nan Jesus gan pe nuu lextoo men, lex re Ne lo men: ―¿Penak rlebleedx de zegwa? ");
INSERT INTO zpi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Pe mazre mbëëdee gue noo lo mengyiz: “Le xdol de che wak perdon”, u ne gue noo lo men: “Gutsaxee gulis xloon de, gugya”? ");
INSERT INTO zpi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Orree kwii de yra de gante ne Men ne wdxiid wak Mén rap men poder nee gyëzlyuree por ne gun men perdon xdol mén. Lex re Ne lo mengyiz guin: ");
INSERT INTO zpi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Yna noo lo de, gutsaxee gulis xloon de, gugya ruxyuu de. ");
INSERT INTO zpi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Orgueguin waxee mén guin, wlis men xloon men, wruu men nga nes lo yra mén. Por neguin wzee wzak yrandxee mén, lex wzelo men wzaknzoon men Dëdyuzh, re men: ―Nunk gardet kwii be gak neree ne wak orree. ");
INSERT INTO zpi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Zhich guin wruu Jesus wa Ne runis ste. Lex ra yrandxee mén lo Ne, rneluu Ne men. ");
INSERT INTO zpi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ne za Ne, wii Ne zob Leví xpee Alfeo ledne rgoob Leví zeg impwest, lex re Ne lo Leví: ―Gutanal noo. Orguin wzuli Leví zanal Leví Ne. ");
INSERT INTO zpi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Te chene zob Jesus ruxyuu Leví yra Ne xpén Ne, zob Ne lo mezh zobyu Ne yra Ne tebëd men ne rgoob zeg impwest no le stebëd mendol, porke che kesentyent ndal men ranal Ne ledne ratee Ne. ");
INSERT INTO zpi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ne wii maxter ley yra men men ne nak farisew ne zobyu Ne yra Ne mén guin, re men lo xpén Ne: ―¿Penak ru xmaxter de yra men men ne rgoob zeg impwest no le yra men mendol? ");
INSERT INTO zpi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ne won Jesus ne re men zenga, re Ne lo men: ―Men ne ngyëël, rkyiinden men doctor, sinke men ne rzhuun, men guin rkyiinen doctor. Noo zëëdet noo zëdye noo menwen, sinke le noo zëdye mendol. ");
INSERT INTO zpi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Te chene rkwan xpén Xwa no le men ne nak farisew por ne saknon men Dëdyuzh, wa tebëd mén lo Jesus, wnabdiiz men lo Ne, re men: ―¿Penak rkwan xpén Xwa no rkwan ke men ne nak farisew, le xpén de rkwandet men? ");
INSERT INTO zpi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wke Jesus, re Ne: ―Lo te dooy, ¿peguin zak gudet xemyooz nobye myentras ne benak zu nobye lo men? Belne benak zu nobye lo men, gakdet ne gudet men. ");
INSERT INTO zpi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per sdxiin dxe ne ybetxee nobye lo men; cheguin si ykwan men. ");
INSERT INTO zpi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Rut rkadaadet tebla lërkweb led te lëryuux, porke rdop lërkweb, lex rtxëzo lëryuux, mazre raknzhoodee ledne wrëz. ");
INSERT INTO zpi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ni rut rgaadet binkweb lengyedyuux, porke belne ylaa men zenga, stxëz binkweb gyedyuux; nigle xiin bin, nigle xiin gyed. Por neguin binkweb leen ke gyedkweb taa we. ");
INSERT INTO zpi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Te dxe ne rne men-Israel, wdee Jesus ledne nuu zhobxtil yra Ne xpén Ne. Lex za za xpén Ne rkyiits men xebzun zhobxtil. ");
INSERT INTO zpi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Lex re men ne nak farisew lo Ne: ―¿Penak rlaa xpén de ne ndux ylaa be dxe ne rne be? ");
INSERT INTO zpi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Wke Ne re Ne: ―¿Pe gardet gool de lo xgyiich Dëdyuzh ledne re ne wlaa David chene wlaanen zhaa ne wakyët ne nyu zhaa yra zhaa xkompanyer zhaa? ");
INSERT INTO zpi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wdee zhaa lenxeydoo Dëdyuzh chene nak Abiatar fxuz ne mazre nondee, wgoob zhaa gyëtxtil ne nakleey wu zhaa yra zhaa xkompanyer zhaa, no ndux gu kwaskyer mén gyëtxtil guin, nonchee fxuz rak ru we. ");
INSERT INTO zpi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","No re Ne: ―Dxe ne rne be, por mén wyano, let por laadeto wyan mén. ");
INSERT INTO zpi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Por neguin Men ne wdxiid wak Mén rak ke rnebééy men no dxe ne rne be. ");
INSERT INTO zpi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wdee Jesus lenydoo ste; nga zob te mgyeey ne miitx te nya. ");
INSERT INTO zpi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kom noze kaleedx mén gan pe sneseyaken Ne mgyeey guin dxe ne rne men-Israel, chen tsël gan pezee ykagyii men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Lex re Ne lo mgyeey guin ne miitx nya: ―Gusuli, gusu gwrooltee. ");
INSERT INTO zpi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Zhich guin wnabdiiz Ne lo mén ne ndxin nga, re Ne: ―¿Pagox nak ne ryal ylaa me dxe ne rne me, ne wen u ne mal?, ¿yselaa me xgyelembán te mén u yket me men? Per noze chi wbiin men yra men. ");
INSERT INTO zpi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Orguin legue wlaa Ne wii Ne lo yra mén ne ndxin kbii Ne no legue wunles lextoo Ne por ne nadet men gon men diiz. Lex re Ne lo mgyeey guin: ―Guzegaa nya de. Zegne wzegaa meno, wakwengoo. ");
INSERT INTO zpi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Per zegne wruu yra men ne nak farisew nga, wzelogue men yra men xpén Herodes wye men gan pezee yket men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Zhich guin wa Jesus runis-Galilea yra Ne xpén Ne; kesentyent ndalyaa men-Galilea wanal Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","No chene waknan mén yra ne nzoon ne rlaa Ne, ndalyaa mén wa lo Ne: men-Judea, men-Jerusalén, men-Idumea, no le men ne wruu stebkoo gyow-Jordán, no le men nes Tiro, no le men nes Sidón. ");
INSERT INTO zpi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Por neguin re Jesus lo xpén Ne ne ylaxnëz men te leen bark chen tee Ne leeno, chen gueendet yra mén guin Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kom kesentyent ndal mén che wneseyaken Ne, yrandxee mén ne rzhuun rbig lo Ne chen ytee nya men led Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","No te te chene rwii menzab Ne, rzuzhib menzab lo Ne, noze rderëz menzab, re menzab: ―¡XPee Dëdyuzh nak de! ");
INSERT INTO zpi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per waknduxyaa Ne lo menzab chen yzëëdetre menzab gan txu nak Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Zhich guin wyeep Jesus te txu gyeey, wbëz Ne tebëd mén lo Ne, lex wdxiin men lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lad yra men guin wye Ne chibtxup mén chen tsanal men Ne no chen yxaal Ne men tsazëët men xdiiz Dëdyuzh, lex wnesela Ne men poxter ");
INSERT INTO zpi_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","no wdee Ne poder lo men yra men chen koo men menzab lextoo mén. ");
INSERT INTO zpi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Laa yra chibtxup poxter guin nga nak: Simon no wnesela ke Ne men Bëd, ");
INSERT INTO zpi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nak Jacob no le Xwa bech Jacob, zhiin Zebedew nak men yrup men, wnesela Ne men Boanerges (diizree rna Zhiin Ngwzii), ");
INSERT INTO zpi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","no le Ndrizh, Blib, Bartolomé, Mdëw, Tmazh, Jacob xpee Alfeo, Tadeo, Simon men ne nak cananist, ");
INSERT INTO zpi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","no le Judas Iscariote ne wdekwent Ne. Zhich guin wdee Jesus te lenyuu yra Ne xpén Ne, ");
INSERT INTO zpi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","lex wdop ndalyaa mén lo Ne ste, axtegue ni ryobdet gu Ne yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chene waknan xparyent No, za men chen tsaxii men Ne, porke re men roots xtoo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Le yra maxter ley ne wruu Jerusalén re: ―Beelzebu ne rnebééy lo menzab nuu lextoo ménree, laa Beelzebu rdee poder lo men ne rboo men menzab lextoo mén. ");
INSERT INTO zpi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Lex wbëz Jesus men yra men, re Ne lo men: ―¿Pezee gak koo Bzelo laake sebzelo Bzelo lextoo mén? ");
INSERT INTO zpi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Belne rdil gobyeren laake xpén gobyeren, rdiidet gobyeren guin. ");
INSERT INTO zpi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","No belne rdilelsaa te familye, laake rdiidet ke familye guin. ");
INSERT INTO zpi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Zenga ke, belne rdil Bzelo laake sebzelo Bzelo, ydiidet ke Bzelo, sinke lel luzh Bzelo. ");
INSERT INTO zpi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Rut gundet gan tee lenxyuu te mgyeey ne ndíp chen gweey men yra ne rap mgyeey guin, belne yliibdet men mgyeey guin primer. Per belne primer yliib men men, zenga si zun men gan gweey men yra ne rap mgyeey guin. ");
INSERT INTO zpi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Nligue yna noo lo de yra de ne zak perdon yrandxee xdol mén no yrandxee diznyaan ne rnii men. ");
INSERT INTO zpi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Per le men ne rnii diznyaan por Espíritu Sant, nunk gakdet men perdon, sinke ydeblo siguelendxee gak men sufrir. ");
INSERT INTO zpi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Re Ne zenga porke re men ne menzab nuu lextoo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lex wdxiin xnaa Jesus yra men bech Ne, per fwer wzu men yra men; orguin wxaal men men ne waluu diiz lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lex re yra men ne zob koo Ne: ―Le xnaa de no le yra bech de zu fwer, laa de rye men. ");
INSERT INTO zpi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wke Ne re Ne lo men: ―¿Txu nak xnaa noo? ¿Txu nak bech noo? ");
INSERT INTO zpi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Orguin wii Ne lo yra mén ne zob kbii Ne, lex re Ne: ―Ménree nak xnaa noo no nak bech noo. ");
INSERT INTO zpi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Porke yrandxee mén ne rlaa ne rlaan Dëdyuzh, mén guin nak bech noo, nak bzaan noo no nak xnaa noo. ");
INSERT INTO zpi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wzelo Jesus rneluu Ne mén runis ste. Kom kesentyent ndal mén wdop lo Ne, lex wdee Ne lenbark ne zob nga, wzob Ne lenbark guin, le yra mén wyan runis. ");
INSERT INTO zpi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ndal ne wneluu Ne men, teblose zegnak kwent wneluu No. Or ne kaneluu Ne men, re Ne: ");
INSERT INTO zpi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Gugon neree gante: Te dxe wruu te mén ne rguu bni, zalabni men zhobxtil. ");
INSERT INTO zpi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chene kalaal meno, nuu we wyab nëz; lex wyab mgyin wu ma we. ");
INSERT INTO zpi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nuuzego wyab lad gye ledne yëtet ndal yu; wlengoo por ne yëtet ndal yu lad gye guin. ");
INSERT INTO zpi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Per chene wlen ngbiz, wzeey ngbizo; kom yëtet ndal lu we, wbidxo. ");
INSERT INTO zpi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nuuzego wyab lad lbagyëts; wroo lbagyëts, wket lbagyëtso, por neguin wakdeto. ");
INSERT INTO zpi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Per nuuzego wyab ledne wen lyu; wleno, wroo we, no kesentyent wako; nuu we wak galebchii zhob, nuuzego wak tsonlal zhob, nuuzego wak tebgwyuu zhob. ");
INSERT INTO zpi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lex re Ne lo men: ―Men ne rkagyedyag diiz, gon men neree ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chene che wyan Jesus noze laa Ne, wbig yra men ne ndxin guex lo Ne no le yra chibtxup xpén Ne, wnabdiiz men lo Ne gan pe rna neguin ne wzëët Ne zegnak te kwent. ");
INSERT INTO zpi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Lex re Ne lo men: ―Laa de yra de, Dëdyuzh wniiz si ne gaknan de logne ngueedx ne rkyeen Ne; per le yra men ne nakdet xpén noo, yrandxee ne rzëët noo lo men, teblose zegnak kwent rzëët noo we; ");
INSERT INTO zpi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","chen mase mazre rwii men, per nak men zegnak mén ne rwiidet; mase mazre ron men diiz, per ydeedet men kwento, chen ysaandet xgyelmal men no chen gakdet perdon xdol men. ");
INSERT INTO zpi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","No re ke Jesus lo men: ―Belne rdeedet de kwent gan pe rna diizree ne wzëët noo zegnak te kwent, ¿pezee ydee de kwento stebëdo? ");
INSERT INTO zpi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Men ne rguu bni nak zegnak men ne rzëët xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Le zhobbni ne wyab nëz nak zegnak mén ne ron xdiiz Dëdyuzh, per chene rluzh ron meno, rdxiin Bzelo rboo we lextoo men. ");
INSERT INTO zpi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Le zhobbni ne wyab lad gye nak zegnak mén ne ron xdiiz Dëdyuzh; rzhiilen men ron meno, ");
INSERT INTO zpi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","per kom nak men zegnak ne yëtet ndal lu, rundet men wantar; chene le men pe rzak o chene rwinyaan mén men por ne rlaleedx men xdiiz Dëdyuzh, rsalzaangue men ne rlaleedx meno. ");
INSERT INTO zpi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Le zhobbni ne wyab lad lbagyëts nak zegnak mén ne ron xdiiz Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per por ne mazre za yra ne nuu gyëzlyuree lextoo men no por ne rbode ne non ne nuu gyëzlyuree men no por ne zoon men pezee gap men yrandxee ne nuu gyëzlyuree, neguin rlaa ne le men rsalzaan xdiiz Dëdyuzh; rdeedeto si ylaa men ne wen. ");
INSERT INTO zpi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Per le zhobbni ne wyab ledne wen lyu, nak zegnak mén ne ron xdiiz Dëdyuzh, rukas meno, lex rlaa men ne wen. Nuu men nak zegnak zhobbni ne wak galebchii zhob, nuuzeg men nak zegnak zhobbni ne wak tsonlal zhob, nuuzeg men nak zegnak zhobbni ne wak tebgwyuu zhob. ");
INSERT INTO zpi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","No re ke Jesus lo men: ―¿Peguin rgoob mén te bnii por ne yzoob meno zhiin te kaj u por ne yzoob meno zhiin loon? ¿Pe let rzoobdet meno ledne gya chen yzenii we? ");
INSERT INTO zpi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bet ne ngueedx yët ne yrunyoodet, ni yët ne rak rlaanguel ne gaknandet mén. ");
INSERT INTO zpi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Men ne rkagyedyag diiz, gon men neree ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","No re ke Ne lo men yra men: ―Gukagyedyag neree ne ron de. Zegne rukas de xdiiz Dëdyuzh, zenga ke tsukas Ne de no ntozdee tsukas Ne de. ");
INSERT INTO zpi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Men ne che rukas xdiiz Dëdyuzh, laa Ne ylaa ne mazre tsukas meno; per le men ne rukasdeto, axtegue ne chendxee rukas men, tsukasdetre meno. ");
INSERT INTO zpi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","No re ke Jesus: ―Ne rkyeen Dëdyuzh nak zegnak chene rguu te mén zhobxtil lenlyu. ");
INSERT INTO zpi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Lex rya men raguees men; rluzh nga raxee men. Zenga za dxe, za gyëël. Lex rleno, rroo we, per nandet men pezee rleno no pezee rroo we. ");
INSERT INTO zpi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Laa lyu nak ne rguu gyelembán lextoo we. Primer rlen xgyizho, zhich guin rlen do we, zhich guin ruleedxo. ");
INSERT INTO zpi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","No chene le we che wal, rtop meno porke che wdxiin tyemp ne ydopo. ");
INSERT INTO zpi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","No re ke Jesus: ―¿Pagox rzaglo ne rkyeen Dëdyuzh, u pagox ynesaglo bo? ");
INSERT INTO zpi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Rzaglo we te medx lyagwlizh ne rlabni mén lyu. Laa we nak ne mazre windee ke lo yrandxee medx ne nuu gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Per chene le we che wakbni, rroo we, laa we nak ne mazre raknzhoodee ke lo yrandxee gyizh; kesentyent rroo zhuuko, axtegue mgyin ra rzhexkwaa xeftxëës zhuuko. ");
INSERT INTO zpi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Zeree wzëët Jesus xdiiz Dëdyuzh, teblose zegnak kwent wzëët No, chen ydee mén kwento. ");
INSERT INTO zpi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bet nzëëdet Ne lo mén belne nzëëdet No zegnak kwent; per le lo yra xpén Ne, waandxee wzëët Ne gan pe rna we. ");
INSERT INTO zpi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dxe ke guin, chene che rzëë lyu, re Jesus lo yra xpén Ne: ―Yoo tekaa be stebkoo nis. ");
INSERT INTO zpi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Orguin wsan men yrandxee mén ne ndxin nga, lex za men yra men Ne lenbark guin ne zob Ne; no zanal ke stxup stson bark ne zob nga. ");
INSERT INTO zpi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lex wlen te meroo meduxtee, axtegue lenbark rasob nis, le nis chexke zayezaa lenbark. ");
INSERT INTO zpi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Le Jesus nexguees lenbark, nkuuk Ne te lmad. Orguin wboo men mkaal lo Ne, re men: ―¡Maxter! ¿Pe bet zadet lextoo de ne sebgyët be lo nis? ");
INSERT INTO zpi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Orguin waxee Ne wakndux Ne lo meroo guin, no re Ne lo nis: ―¡Chi gutsuu! ¡Tsë gutsuu! Orguin wyakchi mee, no wutsë nis, nonchee chi wak. ");
INSERT INTO zpi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Lex re Ne lo yra xpén Ne: ―¿Penak kesentyent rdxe de? ¿Pe rlaleedxdet de Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kesentyent wdxe men yra men, lex rnabdizlsaa men, re men: ―¿Pezee nakleg ménree ne axtegue mee, axtegue nis ron xdiiz men? ");
INSERT INTO zpi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lex wdxiin Jesus stebkoo nis lo xelyu men-Gadara yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Zegne wruu Ne lenbark, lad baa wruu te mgyeey ne nuu menzab lextoo, za men zatsëlo men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Lad baa ka men, no rut rundet gan yliib men, ni kon kaden. ");
INSERT INTO zpi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Che ndal tir rlaan mén yliib mén nii nyatee men kon kaden, per nunegue rtxugyaa men kaden, noze byu rlaa meno; rut rundet gan lo men. ");
INSERT INTO zpi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dxe gyëëltee, rkayobtsaa men gyeey den no le rubaa, noze wraa led men rziib men gye we. ");
INSERT INTO zpi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Per axtegue natre za Jesus, le men che wii Ne; orguin noze rzhoon men wa men wzuzhib men lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Lex ndípse wnii menzab ne nuu lextoo mgyeey guin, re menzab lo Ne: ―¿Penak rgal de noo, Jesus XPee Dëdyuzhnzoon? Ynab noo lo de por la Ne ne yzakzidet de noo. ");
INSERT INTO zpi_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Re men zenga porke re Jesus lo men: ―¡Menzab, guruu lextoo ménree! ");
INSERT INTO zpi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Lex wnabdiiz Jesus lo men, re Ne: ―¿Txu la de? Wke men re men: ―Le noo la Legión, porke ndal nak noo. ");
INSERT INTO zpi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Orguin kesentyent wnab men lo Jesus ne yxaaldet Ne men stebkoo. ");
INSERT INTO zpi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kom ndal kuch ka gwdu guex gyeey guin ledne zu Jesus, ");
INSERT INTO zpi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","lex wnab menzab guin lo Ne, re men: ―Lextoo kuchro guxaal noo; gudee si tee noo lextoo maa. ");
INSERT INTO zpi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Orguin wdee Jesus si. Lex wruu menzab lextoo mgyeey guin, watee menzab lextoo yra kuch guin. Zeg txupmil nak ma yra ma. Zegne wdee menzab lextoo maa, wzelo ma wzhoon maa wxenxtoo ma te ruyúú, wyab ma axtegue lo nis. Nga wobkyiky ma nis, wet maa. ");
INSERT INTO zpi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Orguin wzhoon yra mén ne rapkwent kuch guin, lex wa men waluu men diiz lenlgyëz no le ledne ka mén den. Lex wruu mén za men wii neguin ne wak. ");
INSERT INTO zpi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Chene wdxiin men lo Jesus, wii men le mgyeey guin ne wuu menzab lextoo che zobchee lo Jesus, che nak men xab men no che nde bnii xgyeryen men. Ne wii yra mén guin neguin, wdxe men. ");
INSERT INTO zpi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yra mén ne wii neguin ne wak, laa men wuu diiz gan pezee wzak mgyeey guin ne nuu menzab lextoo no gan pezee wzak yra kuch guin. ");
INSERT INTO zpi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Orguin wzelo yra mén guin wnab men lo Ne ne yruu Ne xden men. ");
INSERT INTO zpi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Chene le Jesus wdee lenbark, wzelo mgyeey guin ne wruu menzab lextoo wnab men lo Jesus ne ydee Ne si tsanal men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per wdeedet Ne si, sinke re Ne lo men: ―Gugya ruxyuu de, gu de diiz lo yra xparyent de yra ne wlaa Dëdyuzh de no gan pezee wles lextoo Ne de. ");
INSERT INTO zpi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Lex sya mgyeey guin wzelo men wuu men diiz lo mén yra gyëz ne ngab Decápolis ne nzoon guin ne wlaa Jesus men. Yrandxee mén wzee wzak. ");
INSERT INTO zpi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chene wberee Jesus kon bark ke stebkoo nis ste, kesentyent ndal mén wdop lo Ne. Nga runis guin wzu Ne. ");
INSERT INTO zpi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Zhich guin wdxiin te men ne la Jairo ne rnebééy lenydoo. Zegne wii men Ne, wzuzhib men lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kesentyent wnab men lo Ne, re men: ―Le xsaap noo che kaluzhlo. Yoo tsa be yxob nya de led nzeb chen gyaken nzeb no chen ybánre nzeb. ");
INSERT INTO zpi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Orguin zanal Jesus men. Ndalyaa mén zanal Ne, noze reen men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nga zu te wnaa ne rzhuun, che wzaa chibtxup iz ryab men ren. ");
INSERT INTO zpi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Che kesentyent wak men sufrir porke noze ndal lo doctor wa men, no che wdenya yra xmed men, per bat wkyiindeto, lel mazre wak xgyelgyiz men. ");
INSERT INTO zpi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chene won men ne ruu mén xdiiz Jesus, noze lad yra mén guin wdee men, wbig men nes zhich Ne, wtee nya men led xab Ne. ");
INSERT INTO zpi_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Porke nuu lextoo men: “Naal pezee maske nonchee ytee nya noo led xab mén gwa, laa ne gyaken noo nga.” ");
INSERT INTO zpi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","No orgueguin wyaag men ren, wyenengue men ne le men che wyaken. ");
INSERT INTO zpi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Orgueguin wyenen Jesus ne wneseyaken Ne te mén kon xpoder Ne. Wcheree lo Ne wii Ne lo yra mén ne zanal zhich Ne, lex wnabdiiz Ne lo men, re Ne: ―¿Txuzh wtee nya led xab noo? ");
INSERT INTO zpi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Orguin re yra xpén Ne lo Ne: ―Rwii de noze reen mén de, no le de rnabdiiz gan txuzh wtee nya led xab de. ");
INSERT INTO zpi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per zazëëdtee lo Ne noze kbii Ne chen kwii Ne gan txuzh wtee nya led xab Ne. ");
INSERT INTO zpi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Orguin noze rzhiz wnaa guin tant rdxe men kom nan men ne laa men wtee nya led xab Ne. Wa men wzuzhib men lo Ne, lex wzëët meno zegne nak nakendxoo. ");
INSERT INTO zpi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Orguin re Jesus lo men: ―Zhiina, por ne wlaleedx de noo, wyaken de. Zhaas gugya, che wbë́z xgyelgyiz de. ");
INSERT INTO zpi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Benak kanii Jesus, chene wdxiin tebëd mén ne wruu ruxyuu mén guin ne rnebééy lenydoo, re men lo men guin: ―Le xsaap de che wet. Gunendetre de lo Maxter. ");
INSERT INTO zpi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Per wukasdet Jesus neguin ne re men, lex re Ne lo mén guin ne rnebééy lenydoo: ―Ydxedet de; noze gulaleedx noo. ");
INSERT INTO zpi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","No wdeedet Ne si nyanal ndal mén Ne, nonchee Bëd no le Jacob no le Xwa bech Jacob. ");
INSERT INTO zpi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Chene wdxiin Ne ruxyuu mén guin ne rnebééy lenydoo, wii Ne le yra mén ndxin roon robtsaatee. ");
INSERT INTO zpi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Orguin wdee Ne, re Ne lo men: ―¿Penak noze rakrëz de no penak roon de? Wetet xsaap ménree, noze nexguees nzeb. ");
INSERT INTO zpi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Per lel wzhidxno men Ne. Orguin wboo Ne men yrandxee men fwer. Lex wzano Ne xnaa nzaap guin no le xuz nzeb no le men ne zano Ne, wdee Ne ledne nex nzeb. ");
INSERT INTO zpi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wnëëz Ne nya nzeb, re Ne lo nzeb: ―Talita, cumi ―diizree rna: Nzaape, yna noo lo de, gutsaxee. ");
INSERT INTO zpi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Orgueguin waxee nzaap guin, wzelo nzeb wzaa nzeb. Kesentyent wzee wzak yrandxee mén. Chibtxup iz rap nzeb. ");
INSERT INTO zpi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lex re Jesus lo men ne rutlel lo guedet meno, no wkyeen Ne men ne ydee men ne gu nzeb. ");
INSERT INTO zpi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wruu Jesus nga yra Ne xpén Ne, wdxiin Ne laz Ne. ");
INSERT INTO zpi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Chene wdxiin dxe ne rne men-Israel, wzelo Ne wneluu Ne mén lenydoo; no ndal mén wzee wzak ne won men ne rzëët Ne, rnabdizlsaa men, re men: ―¿Pazh wseed mén gwa yra negwa? ¿Pazh waxii men yra negwa ne nan men no le yra gyelmilaguer gwa ne rlaa men? ");
INSERT INTO zpi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Pe let laadet men gwa nga nak karpinter, xpee Mli, le bech men nak Jacob, nak Xeb, nak Judas, nak Simon? ¿Pe let needet nuu yra bzaan men lad be? Por neguin wukasdet men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Per re Ne lo men: ―Yrandxee lugar rzaknon mén te profet, per le laz men rzaknondet mén men, ni men ne nak xparyent men, ni men ne nak bechpee men rzaknondet men men. ");
INSERT INTO zpi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wakdet nlaa Ne ndal gyelmilaguer nga, nonchee tebëd mengyiz wneseyaken Ne ne wxob nya Ne led men. ");
INSERT INTO zpi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wzee wzak Ne ne rlaleedxdet mén guin Ne. Lex wa Ne yra gyëzwin ne nak guex nga, waneluu Ne mén. ");
INSERT INTO zpi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Zhich guin wbëz Jesus yra chibtxup xpén Ne, lex wxaal Ne men txupgue txupgue men, wazëët men xdiiz Dëdyuzh no wdee Ne poder lo men chen koo men menzab lextoo mén. ");
INSERT INTO zpi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","No re Ne lo men ne gweeydet men ne ykyiinen men nëz, ni gyëtxtil, ni bols, ni med, nonchee te baston sen men. ");
INSERT INTO zpi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ykaa xgyël men nii men, gak men xab men, per gweeydet men steb nëzo. ");
INSERT INTO zpi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","No re Ne lo men: ―Chene ydxiin de te ruyuu, nga ykaa de axtegue ne yruu de gyëz guin. ");
INSERT INTO zpi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Belne nuu ledne ylaandet mén kwii men de ni ylaandet men gon men ne rzëët de, yruu de nga, kwib de guxyudi ne ka nii de zegnak te beey ne nadet mén guin nyon men ne wzëët de. Nligue yna noo lo de yra de ne chene ydxiin dxe ne ylaa Dëdyuzh gyelextis, beeytee sakzi men-Sodoma no le men-Gomorra ke lo yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Lex wruu men yra men, wazëët men ne rap mén degne ysaan mén xgyelmal mén. ");
INSERT INTO zpi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","No wboo men ndal menzab lextoo mén, no wguu men seyt led ndal mengyiz, wneseyaken men men. ");
INSERT INTO zpi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Won rrey-Herodes yra ne kalaa Jesus, porke noze nesree nesrotee ryen diiz ne kalaa Ne. Nuu mén re: ―Xwa ne rtxobnis wa wban. Por neguin rap men poder rlaa men gyelmilaguer. ");
INSERT INTO zpi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nuuzeg mén re: ―Profet-Elías ne. Nuuzeg men re: ―Te profet ne nak zegnak profet ne wuu chekwlo ne. ");
INSERT INTO zpi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Chene won Herodes neguin, re Herodes: ―Laa Xwa wa wban. ¿Pezee wbanleg Xwa? No che wxaal noo mén wa men watxuug men xtoo Xwa. ");
INSERT INTO zpi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Re Herodes zenga porke laa Herodes wxaal mén, wa men wanëëz men Xwa, lex wguu Herodes Xwa chegyiib, wliib men Xwa kon kaden. Wlaa Herodes yra neree por xdol Herodías xewnaa Blib bech Herodes, per wla Herodes men lo Blib, lex wtsëlnya Herodes yrup Herodes men. ");
INSERT INTO zpi_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ndal tir re Xwa lo Herodes: ―Ngyidet negwa ne rlaa de ne wtsëlnyano de xewnaa bech de. ");
INSERT INTO zpi_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Por neguin rwinyaan Herodías Xwa, rlaan men yket men Xwa, per rdeedet Herodes si, ");
INSERT INTO zpi_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","porke rdxe Herodes Xwa, che nan Herodes ne te menwen nak Xwa no ne bet dol neeydet Xwa. Por neguin rdeedet Herodes si ne pe ylaa Herodías Xwa; no mase ni rdeedet Herodes kwent ne rzëët Xwa, per rzhiilen Herodes rkagyedyag Herodes ne rzëët Xwa. ");
INSERT INTO zpi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per wdxiin te dxe ne wzël gan pezee wlaa Herodías. Chene wzaa Herodes iz, wlaa Herodes te lni. Wdee Herodes ne wu yra men ne rnebééy no le yra komandant no le yra men ne non ne nuu lo lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Wdee xsaap Herodías ledne kayak lni, lex wya nzeb. Kesentyent wtseleedx Herodes zegne wya nzeb yra Herodes men ne zobno Herodes lo mezh; lex re Herodes lo nzeb: ―Gunab logne rlaantee de lo noo, noo yniizo. ");
INSERT INTO zpi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wgon Herodes Dëdyuzh ne sdee Herodes logne ynabtee nzeb, niguelzhe ynab nzeb gwrool nacion ledne rnebééy Herodes. ");
INSERT INTO zpi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Orguin wruu nzeb wanabdiiz nzeb lo xnaa nzeb, re nzeb: ―¿Pagox ynab noo? Lex re men lo nzeb: ―Gunab xtoo Xwa ne rtxobnis. ");
INSERT INTO zpi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Zhich guin wdenzeeb nzeb ledne zob Herodes, re nzeb: ―Rlaan noo yniiz de xtoo Xwa ne rtxobnis lo noo orgueree kon te lengyaan. ");
INSERT INTO zpi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kesentyent wdenles lextoo Herodes ne won Herodes zenga; per kom che wgon Herodes Dëdyuzh nes lo yra men ne zobno Herodes lo mezh, wap Herodes degne wlaa Herodes ne wnab nzeb. ");
INSERT INTO zpi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Orgueguin wxaal Herodes te soldad ne tsatxuug men xtoo Xwa. ");
INSERT INTO zpi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Lex wa soldad guin lenchegyiib, watxuug men xtoo Xwa. Wluzh nga wdxinneey meno nuu we te lengyaan, wdee meno lo nzaap guin, lex laa nzeb wdekwento lo xnaa nzeb. ");
INSERT INTO zpi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chene waknan xpén Xwa we, wa men weey men xkwerp Xwa, walugyeer meno. ");
INSERT INTO zpi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chene wberee yra poxter, wdop men lo Jesus, lex wuu men diiz yra ne wlaa men no yra ne wneluu men. ");
INSERT INTO zpi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lex re Jesus lo men: ―Gutayoo tsa be ledne yëtet mén yne be tebrrat. Kesentyent ndal mén rdxiin lo Ne, men ne za, men ne rberee, axtegue ni ryobdet gu Ne yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Orguin wdee Ne lenbark yra Ne xpén Ne, za Ne te ledne yëtet mén. ");
INSERT INTO zpi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Per ndal mén wii ne za Ne yra Ne xpén Ne no wnebeey men Ne. Lex wruu mén yrandxee gyëz ne nak nes guin, za men nii men, kwlodee men wdxiin ke lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Chene wruu Ne lenbark, wii Ne yra menroo menduxtee guin; lex wles lextoo Ne men, porke nak men zegnak mëkzhiil ne yët gan txu gapkwent. Lex wzelo Ne noze ndal ne wneluu Ne men. ");
INSERT INTO zpi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Chene che rzëë, wbig xpén Ne lo Ne, re men: ―Chexke rzëë no ni te mén nuudet lugarree. ");
INSERT INTO zpi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gugue lo yra ménree gya men, chen tsa men ledne ka mén den o ledne nak gyëzwin ne nak guex nee, tsaka men ne gu men porke neeydet men ne gu men. ");
INSERT INTO zpi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Per wke Jesus, re Ne: ―Laa de gudee ne gu men. Wke men re men: ―¿Pe rlaan de tsaka noo txupgwyuu denario gyëtxtil chen ydee be ne gu men? ");
INSERT INTO zpi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Lex re Jesus lo men: ―¿Blazh gyëtxtil neey de? Gutsa wii gan. Chene wberee men, re men lo Ne: ―Gaay gyëtxtil no le txup mël. ");
INSERT INTO zpi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Orguin wkyeen Ne men ne gue men lo yra mén guin ne sob men tebëdgue tebëdgue men lo gyizhyaa. ");
INSERT INTO zpi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Lex wzob men tebëdgue tebëdgue men, nuu ledne wzob men tebgwyuu men, nuuzeg ledne wzob men txupchii men. ");
INSERT INTO zpi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Zhich guin wgoob Jesus yra gaay gyëtxtil guin no le yrup mël guin, wkalo Ne gyeybaa, wdee Ne dexkyizhtee lo Dëdyuzh. Wluzh nga wla Ne yra gyëtxtil guin, wdee No lo yra xpén Ne chen ygyiiz meno lo yra mén guin. Zhich guin wgyiiz Ne yrup mël guin. ");
INSERT INTO zpi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wu yrandxee mén guin axtegue ne wyezaa men, ");
INSERT INTO zpi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","no chene wluzh nga, wsezaa men chibtxup tsegwed yra gyëtxtilbla ne wrukaa no le yra mël ne wrukaa. ");
INSERT INTO zpi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yra mén guin ne wu, gaaymil nak nonchee mgyeey. ");
INSERT INTO zpi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Zhich guin wkyeen Jesus yra xpén Ne wdee men lenbark chen sanergue men tekaa men stebkoo nis, ydxiin men Betsaida, myentras ne le Ne guli yra mén guin nëz. ");
INSERT INTO zpi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wluzhse wguli Ne yra mén guin nëz, za Ne ledne nak gyeey chen ynab Ne lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Chene wnit lyu, le bark chexke za gwrool nis, le Ne wyan lyubidx tete Ne. ");
INSERT INTO zpi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Rwii Ne ne rundetre men gan ynexoon men bark, porke nes lo bark rasob mee, lex rcherezhich mee bark. Ne zëdyenii lyu, za Ne nes lo men rzaa Ne lo nis, le Ne chexke zadesu. ");
INSERT INTO zpi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Chene wii men ne za Ne rzaa Ne lo nis, nuu lextoo men pazer te biso, wobtsadii men ");
INSERT INTO zpi_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","por tant rdxe men, porke yrandxee men wii Ne. Per wnii Ne lo men, re Ne: ―¡Ydxedet de, nzholeedx gugak, noo nee! ");
INSERT INTO zpi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lex wdee Ne lenbark ne nuu men, orgueguin wyakchi mee. Kesentyent wzee wzak men yra men, ");
INSERT INTO zpi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","porke gardet ydee men kwent gyelmilaguer ne wlaa Ne ne wtsowndal Ne gyëtxtil, porke benak nkeb xgyeryen men. ");
INSERT INTO zpi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chene wdekaa Jesus stebkoo nis yra Ne xpén Ne, wdxiin Ne lo xelyu men-Genesaret. Nga wkaduu men bark runis. ");
INSERT INTO zpi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Chene wruu Ne lenbark yra Ne xpén Ne, wyenengue mén ne Jesus ne. ");
INSERT INTO zpi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Noze rzhoon mén wa men waluu men diiz ydendxee nes guin. Wzelo mén weey men mengyiz ydebxlonwin mengyiz, wdxinneey men mengyiz ledne won men diiz ne zu Jesus. ");
INSERT INTO zpi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","No kwaskyertee ledne rdee Ne ledne nak gyëzwin o ledne nak gyëznzhoo o ledne nak den, rgyix mén mengyiz runëz, lex rnab men lo Ne ne ydee Ne si ytee nya men maske nonchee luzh xab Ne, no yrandxee mén ne rtee nya luzh xab Ne ryaken. ");
INSERT INTO zpi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wdxiin tebëd men ne nak farisew lo Jesus no le tebëd maxter ley ne wruu Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wii men kayu txup tson xpén Jesus noze nyarbeed men, waadet nya men zegne nak xkoxtumber men yra men, por neguin wzelo men rnii men diznyaan por xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Porke yra men-Israel ne nak farisew no le yra men-Israel ne nakdet farisew, rsalzaandet men xkoxtumber xpenkwlal men, rudet men belne raadet nya men zegne ryal ga meno. ");
INSERT INTO zpi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","No chene rberee men lgyeey, belne raadet nya men, rudet men. No ndalre ne rlaa men, zegnak ne raa men bas ne rdaa ne roo men no le byak no le gyusgyiib ne rkyiinen men no le xloon men.) ");
INSERT INTO zpi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Lex wnabdiiz men ne nak farisew no le maxter ley lo Ne, re men: ―¿Penak rlaadet xpén de zegnak xkoxtumber xpenkwlal be ne raa nya men antes ne gu men, le xpén de raadet nya? ");
INSERT INTO zpi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Wke Ne re Ne: ―Gugannaa laa de wen. Nli ke ne re profet-Isaías por laa de yra de chene re men: Yra ménree noze xdiiz men za ne rzaknon men noo, per rlaadet meno ydeblextoo men. ");
INSERT INTO zpi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bat rkyiindet yra ne rlaa men chene rzaknon men noo, porke yra ne rneluu men, noze mén rkyeeno. ");
INSERT INTO zpi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Porke lugar ne ylaa de ne rkyeen Dëdyuzh, lel xkoxtumber mén zanal de: zegnak ne raa de byak no le bas ne rdaa ne roo de, no ndalre ne rzaglo neree rlaa de. ");
INSERT INTO zpi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","No regue Ne ste: ―Lugar ne ylaa de ne rkyeen Dëdyuzh, lel xkoxtumber de zanal de. ");
INSERT INTO zpi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chekwlo re Moises: “Gugaknzebnëz lo xuz de, gugaknzebnëz lo xnaa de”, “Mén ne rninyaan lo xuz o men ne rninyaan lo xnaa, rzëël guet men.” ");
INSERT INTO zpi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Per le laa de yra de re de ne zak gue te mén lo xuz men o lo xnaa men: “Gundet noo gan gun noo xyudar de porke che Corbán yrandxee ne nniiz noo lo de” (Corbán rna, che por Dëdyuzh nako). ");
INSERT INTO zpi_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","No re de, men ne guese zenga, che yëtre neguin ne gun men xyudar xuz men o xyudar xnaa men. ");
INSERT INTO zpi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ne rlaa de zenga, rsan de ne rkyeen Dëdyuzh tebkoo, lel koxtumber ne wsan xpenkwlal de lo de zanal de. No ndalre ne rzaglo neree rlaa de. ");
INSERT INTO zpi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Lex wbëz Jesus yra menroo menduxtee guin, re Ne lo men: ―Gugon neree ne yzëët noo lo de yra de no gudee kwento: ");
INSERT INTO zpi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Let ne rudet mén rlaa ne rak men mendol, sinke ne mal ne rzaa lextoo men, neguin nak ne rlaa ne rak men mendol. ");
INSERT INTO zpi_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Men ne rkagyedyag diiz, gon men neree ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chene che wruu Jesus lad yra mén guin, wdee Ne lenyuu, lex wnabdiiz yra xpén Ne lo Ne gan pe rna neguin ne re Ne. ");
INSERT INTO zpi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Orguin re Ne lo men: ―¿Pe ni laa de yra de rdeedet kwento? ¿Pe rdeedet de kwent ne yrandxee ne ru mén, let laadeto rlaa ne rak men mendol? ");
INSERT INTO zpi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Porke rdxiindeto lextoo men, sinke le we rdxiin txu men, zhich guin rruu ko. Ne re Ne zenga, rna xdiiz Ne ne yrandxee ne ru mén ndaa we. ");
INSERT INTO zpi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","No re Ne ste: ―Ne mal ne rzaa lextoo mén, neguin nak ne rlaa ne rak men mendol. ");
INSERT INTO zpi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porke lextoo mén nuu yra ne mal ne rlebleedx men, zegnak ne rkano men mén ne nakdet lzaa men, zegnak ne rkanogue men xkompanyer men chene gardet ytsëlnya men, zegnak ne rket men semén men, ");
INSERT INTO zpi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","zegnak ne rbaan men, zegnak ne ndeblextoo men, zegnak ne rlaa men ne mal, zegnak ne rkade men, zegnak ne rap men bisye, zegnak ne rakmbidye men, zegnak ne rnii men diznyaan, zegnak ne nugya lextoo men, zegnak ne rdeedet men bnii xgyeryen men. ");
INSERT INTO zpi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yra ne malree, lextoo mén rruu we. Laa we nak ne rlaa ne rak men mendol. ");
INSERT INTO zpi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wruu Jesus nga, za Ne nes Tiro no le nes Sidón. Lex wdee Ne te lenyuu; wlaandet Ne ne nyaknan mén ne wdxiin Ne nga, per wakdet gan ne nkarlaan Ne. ");
INSERT INTO zpi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Waknangue te wnaa ne le Ne wdxiin nga. Rap wnaa guin te nzaap ne nuu menzab lextoo, lex wa men wzuzhib men lo Ne, ");
INSERT INTO zpi_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","wnab men lo Ne ne koo Ne menzab lextoo xsaap men. Nakdet men men-Israel, sinke le men nak men-Sirofenicia. ");
INSERT INTO zpi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Per re Jesus lo men: ―Rap mén degne ydee men si gu zhiin men primer, porke ngyidet ne ygyitxee men ne ru zhiin men chen ynii meno lo mëëk. ");
INSERT INTO zpi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wke men re men: ―Nli we Dechey; per axtegue mëëk ne zu zhiin mezh ru ne byu ne ratxee nya minwin. ");
INSERT INTO zpi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Orguin re Jesus lo men: ―Por ne na de zegwa, gugya. Le menzab che wruu lextoo xsaap de. ");
INSERT INTO zpi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chene wdxiin men ruxyuu men, wii men le xsaap men che nex lo loon; che wruu menzab lextoo nzeb. ");
INSERT INTO zpi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wruu Jesus nes Tiro ste, wdee Ne nes Sidón no le nes Decápolis, wdxiin Ne runis-Galilea. ");
INSERT INTO zpi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nga wdxinno mén te mgyeey lo Ne, nkwëët mgyeey guin no rninga men; lex wnab mén lo Ne ne yxob nya Ne led mgyeey guin. ");
INSERT INTO zpi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Orguin wano Jesus mgyeey guin tebkoo ledne yëtet mén. Lex wsee xkwen Ne lengyedyag men no wtxonxen Ne nya Ne, lex wtee No lo loz men. ");
INSERT INTO zpi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Zhich guin wii Ne gyeybaa, wonleedx Ne, lex re Ne: ―¡Efata! ―diizree rna: ¡Gugyal! ");
INSERT INTO zpi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Orgueguin wdee bnii gyedyag mgyeey guin, no wakwen loz men, wnixnëz men. ");
INSERT INTO zpi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Lex re Ne lo yra mén ne rut lo guedet meno; per mase re Ne ne rut lo guedet meno, lel mazre wlaa men wuu men diizo. ");
INSERT INTO zpi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kesentyent rzee rzak yra mén, re men: ―Yrandxee ne rlaa ménree, wen rlaa meno; axtegue mennkwëët rlaa men ne ryenii gyedyag no rlaa men ne rnii menngup. ");
INSERT INTO zpi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Cheguin ke wdop ndalyaa mén lo Jesus ste, neeydet men ne gu men. Lex wbëz Jesus yra xpén Ne, re Ne lo men: ");
INSERT INTO zpi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Rles lextoo noo yra ménree, porke che wzaa tson gbiz ndxin men lo noo no neeydet men ne gu men. ");
INSERT INTO zpi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Belne yxaal noo men gya men ruxyuu men sin ne gudet men, naap yra men fwers nëz porke nuu men wruu nat. ");
INSERT INTO zpi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wke xpén Ne, re men: ―Per ¿pazh saa ne gu men zegnakpee lugarree ne ni te mén nuudeto? ");
INSERT INTO zpi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Orguin wnabdiiz Jesus lo men, re Ne: ―¿Blazh gyëtxtil neey de wa? Wke men re men: ―Guedxo. ");
INSERT INTO zpi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Orguin wkyeen Ne wzob yra mén guin. Lex wgoob Ne yra guedx gyëtxtil guin, wdee Ne dexkyizhtee lo Dëdyuzh. Wluzh nga wla No, wdee No lo yra xpén Ne, lex laa men wgyiizo lo yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","No neey men tebëd mëlwin. Lex wdee Ne dexkyizhtee lo Dëdyuzh por mël guin; wluzh nga wkyeen Ne wgyiiz men no mël guin. ");
INSERT INTO zpi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wu yrandxee mén guin axtegue ne wyezaa men, no chene wluzh nga, wsezaa men guedx tsegwed yra ne bla ne wrukaa. ");
INSERT INTO zpi_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yra mén guin ne wu, zeg tapmil nak men. Zhich guin wguli Jesus yra mén guin nëz, sya men. ");
INSERT INTO zpi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Wluzhse nga, wdee Ne lenbark yra Ne xpén Ne, za Ne lo lyu ne la Dalmanuta. ");
INSERT INTO zpi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wa tebëd men ne nak farisew lo Jesus, wzelo men rdildiiz men Ne, no por ne ylaa men Ne preb, wnab men lo Ne ne ylaa Ne te gyelmilaguer chen gyakbeey gan pe nli ne Dëdyuzh wxaal Ne. ");
INSERT INTO zpi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Orguin wonleedx Ne axtegue gyët, lex re Ne: ―¿Penak rnab ménree lo noo ne ylaa noo te gyelmilaguer? Nligue yna noo lo de yra de ne betre gyelmilaguer kwiidet men. ");
INSERT INTO zpi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Orguin wruu Ne lad yra mén guin, wdee ke Ne lenbark, za Ne stebkoo nis. ");
INSERT INTO zpi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Chene che za Jesus yra Ne xpén Ne lo nis, wyenen xpén Ne ne zaneeydet men ne gu men; nunegue te gyëtxtil zaneey men lenbark. ");
INSERT INTO zpi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Lex re Jesus lo men: ―Gugap kwent lo xlebadur men ne nak farisew no le lo xlebadur Herodes. ");
INSERT INTO zpi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Orguin wzelo yra xpén Ne rulsaa men diiz, re men: ―Por ne neeydet be gyëtxtil, neguin na Jesus zegwa lo be. ");
INSERT INTO zpi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Wyenen Jesus ne re men zenga, lex re Ne lo men: ―¿Penak re de ne neeydet de gyëtxtil? ¿Pe gardet ydee de kwent no pe gardet gyenen de? ¿Pe wdeelel lo beey nkeb xgyeryen de yra de? ");
INSERT INTO zpi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Zobse bzalo de no rwiidet de; zobse gyedyag de no rondet de diiz. ¿Pe zaleedxdet de? ");
INSERT INTO zpi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Chene wgyiiz noo gaay gyëtxtil lo gaaymil mén, ¿blazh tsegwed gyëtxtilbla ne wrukaa wtop de? Wke men re men: ―Chibtxupo. ");
INSERT INTO zpi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―No chene wgyiiz noo guedx gyëtxtil lo tapmil mén, ¿blazh tsegwed gyëtxtilbla ne wrukaa wtop de? Wke men re men: ―Guedxo. ");
INSERT INTO zpi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Lex re Ne: ―¿Pezee gardet ydee de kwent cheguin? ");
INSERT INTO zpi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Zhich guin wdxiin Jesus Betsaida yra Ne xpén Ne. Wano mén te menngwlëë lo Ne, lex wnab men lo Ne ne ytee nya Ne led menngwlëë guin. ");
INSERT INTO zpi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Orguin wgoob Ne nya men, wruno Ne men lenlgyëz. Wgueeb Ne zhen bzalo men, lex wxob nya Ne led men; zhich guin wnabdiiz Ne lo men gan pe che rwii men. ");
INSERT INTO zpi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chene wlis lo men, re men: ―Rwii noo mén, legue nak men zegnak yag, per rzaa men. ");
INSERT INTO zpi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Lex wtee nya Jesus bzalo men ste, lex wii wiindxee men; orguin wyenii bzalo men, ne le men wak wii wen wenendxee. ");
INSERT INTO zpi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Lex wxaal Jesus men ruxyuu men, re Ne lo men: ―Tsateedet de lenlgyëz, ni rut lo guedet de neree. ");
INSERT INTO zpi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zhich guin wa Jesus yra Ne xpén Ne yra gyëz ne nak nes Cesarea Filipo. Ne za Ne nëz, wnabdiiz Ne lo yra xpén Ne, re Ne: ―¿Pe re mén txu nak noo? ");
INSERT INTO zpi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wke men re men: ―Nuu men re Xwa ne rtxobnis nak de, nuuzeg men re profet-Elías nak de, nuuzeg men re ka txu ste profet nak de. ");
INSERT INTO zpi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Lex re Ne lo men: ―Laa de naa, ¿pe na de txu nak noo? Wke Bëd, re Bëd: ―Laa de nak Crist. ");
INSERT INTO zpi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Per re Jesus lo men ne rut lo guedet meno. ");
INSERT INTO zpi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Zhich guin re Jesus lo men: ―Men ne wdxiid wak Mén, rap men degne kesentyent gak men sufrir, no ylaandet maxter ley men yra maxter ley fxuz ne rnebééy lo yra fxuz no le men ne rnebééy lo men-Israel. Yket men men, per chene gyon gbiz, yban ke men. ");
INSERT INTO zpi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Axtegue nya wzëët Jesuso lo men yra men. Lex wboo Bëd Ne tebkoo, wakndux Bëd lo Ne ne re Ne zenga. ");
INSERT INTO zpi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Per wcheree lo Ne, wii Ne lo yra xpén Ne, lex wakndux Ne lo Bëd, re Ne: ―¡Gubetxee lo noo Bzelo! Porke rlebleedxdet de zegne rlaan Dëdyuzh, sinke le de rlebleedx zegne rlebleedx noze mén. ");
INSERT INTO zpi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Zhich guin wbëz Ne yra xpén Ne no le yra mén ne ndxin nga, lex re Ne lo men: ―Belne nuu mén rlaan gak xpén noo, rap men degne koleedx men xgyelembán men, chidnal men noo, mase kesentyent gak men sufrir. ");
INSERT INTO zpi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Porke men ne rkaa xgyelembán lextoo, zako perdid; per le men ne rboleedx xgyelembán por ne nak men xpén noo no por ne rlaleedx men xdiznzoon Dëdyuzh, zap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Pa ykyiin ne gap mén yrandxee ne nuu gyëzlyuree belne gapdet men gyelembán ne nunk luzhdet? ");
INSERT INTO zpi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿U zun men gan yka men gyelembán guin? ");
INSERT INTO zpi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kwaskyertee mén ne nak xpén noo ne nuu lad menmal mendolteree, belne rtuunen men ne nak men xpén noo o ne rlaleedx men xdiiz noo, laake no Men ne wdxiid wak Mén ytuunen mén guin chene chiid Men ne wdxiid wak Mén ydebxgyelenzoon Dëdyuzh Xuz men no yra men xangel Dëdyuzh Xuz men. ");
INSERT INTO zpi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","No re ke Jesus lo men: ―Nligue yna noo lo de yra de, ne nuu de zegne ndxin de nee guetetgue sin ne kwiidet de gak ne rkyeen Dëdyuzh kon xpoder Ne. ");
INSERT INTO zpi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ne wluzh xuup gbiz ne wak yra neguin, wzano Jesus Bëd no le Jacob no le Xwa, wano Ne men noze gyon men te xtoo gyeey ne kesentyent gya. Nga zu Ne yra Ne mén guin, nes lo men stelel wtsoow lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wkabnii xab Ne no wakngyichdoo we, axtegue ni te mén ne nuu gyëzlyu gundet gan ysanngyich lër zenga mase mazre ga meno. ");
INSERT INTO zpi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tebegue wii men le Elías no le Moises zu kayuno Ne diiz. ");
INSERT INTO zpi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Lex re Bëd lo Jesus: ―Maxter, ¡wen ne zu noo nee gyon noo zeree! Orree yzhexkwaa noo tson guezh: tebo por laa de, stebo por Moises, stebo por Elías. ");
INSERT INTO zpi_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Per ni laa Bëd nandet gan pe rnii Bëd, tant rdxe Bëd yra Bëd xkompanyer Bëd. ");
INSERT INTO zpi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Orguin wyab te bëw, wrëlo Ne yra Ne men. Lad bëw guin wlen te rëz ne re: ―Laa XPee noo nee ne ryaan noo; gugon xdiiz mee. ");
INSERT INTO zpi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Le chene wii men ledne zu Ne yra Ne mén guin, rutre wiidet men, nonchee laa Ne zu nga. ");
INSERT INTO zpi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Or ne zëdtseeb Ne txu gyeey guin yra Ne men, re Ne lo men ne rut lo guedetgue men neguin ne wii men axtegue ne yban Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Por neguin rut lo redet meno, noze lextoo men wuu we; per rnabdizlsaa men gan pe rna ne re Ne, “axtegue ne yban Men ne wdxiid wak Mén”. ");
INSERT INTO zpi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Lex wnabdiiz men lo Ne, re men: ―¿Penak re yra maxter ley ne laa Elías rap degne chiid primer? ");
INSERT INTO zpi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Wke Ne re Ne: ―Nli ne primer Elías chiid; laa Elías gue lo yrandxee mén ne gakxnëz mén. No che re lo xgyiich Dëdyuzh ne rap Men ne wdxiid wak Mén degne sakzi men, no ylaandet mén men. ");
INSERT INTO zpi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Per yna noo lo de yra de ne le Elías che wdxiid, wlaa mén Elías zegne wlaantee mén, zegne re lo xgyiich Dëdyuzh ne sak Elías. ");
INSERT INTO zpi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Chene wberee Jesus ledne ndxin stebëd xpén Ne, wii Ne kesentyent ndalyaa ndalduxtee mén ndxin noze kbii xpén Ne no ndxin ke tebëd maxter ley ne ka kadildiiz yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Zegne wii yra mén guin Jesus, wzee wzak men; noze rzhoon men wa men wagabtyuzh men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Lex wnabdiiz Ne lo men, re Ne: ―¿Pe kwentzhe rdildiiz de? ");
INSERT INTO zpi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wke te mén ne zu lad menroo guin, re men lo Ne: ―Maxter, le noo zëdno xpee noo lo de, porke te menzab nuu lextoo mee, wsanengup men mee. ");
INSERT INTO zpi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Noze ledne zu ledne zatee me rtxoon menzab me lyu; noze rlen fchiin ruu mee, noze ruleey mee, noze rakngyedx mee. Che wnab noo lo xpén de ne koo men menzab lextoo mee, per wundet men gan. ");
INSERT INTO zpi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wke Jesus, re Ne lo men: ―¡Ake mén ne rlaleedxdet Dëdyuzh! ¿Pa axtegue lalre tyemp ykaa noo lad de? ¿Pa axtegue lalre tyemp gun noo de wantar? Gutano me nee. ");
INSERT INTO zpi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lex wdxig men me lo Ne. Chene wii menzab Ne, wlaa menzab ne wlen gyiz guin ste. Orguin wkantaa me lyu, noze rdebxtaa mee, no noze rlen fchiin ruu mee. ");
INSERT INTO zpi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Lex wnabdiiz Ne lo xuz mee, re Ne: ―¿Pa axtegue or wlen ne rzak me zeree? Lex re xuz mee: ―Axtegue ne win mee. ");
INSERT INTO zpi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","No ndal tir rsee menzab me lo gyi no le lo nis chen guet mee. Por neguin belne gun de gan yneseyaken de mee, gules lextoo de noo, gugun xyudar noo yrup noo mee. ");
INSERT INTO zpi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Orguin re Jesus lo men: ―¿Pezee ne “belne gun de gan”? ¡Yrandxoo zak gan gak belne rlaleedx de Dëdyuzh! ");
INSERT INTO zpi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Orgueguin ndípse re xuz mee guin: ―¡Rlaleedx noo Dëdyuzh; gugun xyudar noo chen mazre ylaleedx noo Ne! ");
INSERT INTO zpi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Chene wii Jesus ne ndalre mén rdxiin, wakndux Ne lo menzab, re Ne: ―Menzabngup, menzabnkwëët, ykyeen noo de ne yruu de lextoo meeree, no ybereedetre de tee de lextoo mee. ");
INSERT INTO zpi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Orguin wobtsaa menzab, wlaa menzab ne wlen gyiz guin ste, wruugue menzab lextoo mee. Wsan menzab me zegnak men ne che wet. Ndal mén re ne che wet mee. ");
INSERT INTO zpi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Per wnëëz Jesus nya mee, wlis Ne mee; lex wzuli mee. ");
INSERT INTO zpi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chene wdee Jesus lenyuu, wnabdiiz xpén Ne lo Ne waandxee, re men: ―¿Penak wundet noo gan nboo noo menzab lextoo mee gwa? ");
INSERT INTO zpi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lex re Ne lo men: ―Klas menzab gwa rruudet men belne rut ynabdet lo Dëdyuzh no belne rut ykwandet. ");
INSERT INTO zpi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chene wruu Jesus nga yra Ne xpén Ne, wdee Ne lo lyu ne la Galilea. Per rlaandet Ne ne nyaknan méno, ");
INSERT INTO zpi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","porke orguin kaneluu Ne xpén Ne, re Ne lo xpén Ne: ―Men ne wdxiid wak Mén, sdekwent mén men lo mén chen yket mén men; per chene gyon gbiz, yban ke men. ");
INSERT INTO zpi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per wdeedet men kwent gan pe rna ne re Ne zenga, no wdxe men nnabdiiz men lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ne wdxiin Jesus Capernaum yra Ne xpén Ne, chene che wdxiin Ne ruyuu, wnabdiiz Ne lo xpén Ne, re Ne: ―¿Pe kwentzhe rdildiiz de ne zëëd de nëz? ");
INSERT INTO zpi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Per wkedet men, porke ne za men nëz wdildiiz men gan txu men nak men ne mazre nondee lad men yra men. ");
INSERT INTO zpi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Orguin wzob Jesus, lex wbëz Ne yra chibtxup xpén Ne, re Ne: ―Belne nuu de rlaan gak men primer, rap de degne gak de men lultim lo yrandxee xkompanyer de no ylaa de dxiin lo men yrandxee men. ");
INSERT INTO zpi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Zhich guin wgoob Ne nya te mëdwin, wzu Ne mëdwin guin gwrooltee lad men yra men, lex wlen Ne mëdwin guin, re Ne lo men: ");
INSERT INTO zpi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Belne por la noo rukas mén te men ne nguudx lextoo zegnak mëdwinree, noo nga rukas men; no belne rukas men noo, rukasdet men noze noo, sinke no ke Xuz noo ne wxaal noo zëëd noo rukas men. ");
INSERT INTO zpi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zhich guin re Xwa lo Jesus: ―Maxter, wan noo te mén ne ka kaboo menzab lextoo mén por la de, per wsoow noo porke nuudet men lad be. ");
INSERT INTO zpi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Per re Jesus lo men: ―Nsoowdet de; porke ni te mén ne rlaa gyelmilaguer por la noo, gyezhdet ynii dizmal por noo. ");
INSERT INTO zpi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Porke mén ne nuudet konter por laa be, xfabor be nuu men. ");
INSERT INTO zpi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kwaskyertee mén ne yniiz mase nonchee tebas nis goo de por ne nak de xpén noo ne nak noo Crist, nligue yna noo lo de ne che nuu ne gun mén guin gan. ");
INSERT INTO zpi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Kwaskyertee mén ne ysegyee lextoo te men ne gyed wzelondxee rlaleedx noo ne ye men dol, mazre wendee por laa men yliib mén te gyenzhoo ne rkyiinen molin lenyen men ne rsegyee men lextoo semén men, lex ytxoon mén men lo nisdoo. ");
INSERT INTO zpi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","No belne nya de rlaa ne ryab de lo dol, gutxuugo. Porke mazre wendee tee de kon tebegue nya de ledne gap de gyelembán ne nunk luzhdet, ke ne tsuu de linfyeren kon yrup nya de, lo gyi ne gakdet gyuu, ");
INSERT INTO zpi_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ledne retet mgotx no ledne nunk gyuudet gyi. ");
INSERT INTO zpi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","No belne nii de rlaa ne ryab de lo dol, gutxuugo. Porke mazre wendee tee de ledne gap de gyelembán ne nunk luzhdet beer te nii de, ke ne tsuu de linfyeren kon yrup nii de, lo gyi ne gakdet gyuu, ");
INSERT INTO zpi_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ledne retet mgotx no ledne nunk gyuudet gyi. ");
INSERT INTO zpi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","No belne bzalo de rlaa ne ryab de lo dol, gukoo we. Porke mazre wendee tee de ledne rnebééy Dëdyuzh kon tebegue bzalo de, ke ne tsuu de linfyeren kon yrup bzalo de, ");
INSERT INTO zpi_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ledne retet mgotx no ledne nunk gyuudet gyi. ");
INSERT INTO zpi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Porke zegne rguu mén zëd yra ne rseleedx men por Dëdyuzh, zenga ke tsa yrandxee menmal lo gyi. ");
INSERT INTO zpi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Zëd, ne wen nako; per belne gaknzhidetro, ¿pezee gak gaknzhi we ste? Gugak zegnak zëd yra de, ndxi gubán yra de semén de. ");
INSERT INTO zpi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wruu Jesus Capernaum za Ne stebkoo gyow-Jordán, wdxiin Ne lo lyu ne la Judea. Nga wdop mén lo Ne ste, lex wzelo Ne wneluu Ne men zegnak xkoxtumber Ne. ");
INSERT INTO zpi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Lex wbig tebëd men ne nak farisew lo Ne por ne ylaa men Ne preb; wnabdiiz men lo Ne gan pe zak ychil xgyeltsëlnya mén yrup mén xewnaa mén. ");
INSERT INTO zpi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wke Ne re Ne: ―¿Pagox wkyeen Moises, bes? ");
INSERT INTO zpi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wke men re men: ―Re Moises ne zak ybil xgyeltsëlnya mén yrup men xewnaa men, noze ne xexkwaa te gyiich ydee men lo xewnaa men ne che wsalzaan men men. ");
INSERT INTO zpi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Lex re Jesus lo men: ―Re Moises zenga por tant ndíp xdiiz de yra de. ");
INSERT INTO zpi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Per chekwlo chene wzhexkwaa Dëdyuzh gyëzlyu, “wzhexkwaa Ne mgyeey no le wnaa”. ");
INSERT INTO zpi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Por neguin ysalzaan xuz mgyeey, ysalzaan xnaa mgyeey, chen ybánno men xewnaa men, ");
INSERT INTO zpi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yrup men zenga gak men zegnak tebegue mén.” Che nakdetre men txup, sinke che tebegue nak men. ");
INSERT INTO zpi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Por neguin nuudet ychil mén ne che wlates Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chene che wdxiin Jesus ruyuu, wnabdiiz yra xpén Ne lo Ne kwent guin ste. ");
INSERT INTO zpi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Lex re Ne lo men: ―Kwaskyertee mgyeey ne rchil xgyeltsëlnya yrup men xewnaa men, lex rtsëlnya men yrup men ste wnaa, reey men dol ne la adulterio yrup men wnaa guin. ");
INSERT INTO zpi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","No belne laa wnaa nak ne wsalzaan xemgyeey, lex rtsëlnya men yrup men ste mgyeey, laake reey men dol ne la adulterio. ");
INSERT INTO zpi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wdxinno mén minwin lo Jesus chen yxob nya Ne xtoo miin; per wakndux xpén Ne lo yra men ne wdxinno minwin guin. ");
INSERT INTO zpi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chene wyenen Jesuso, wlaa Ne, lex re Ne lo men: ―Gudee si chiid minwin lo noo, ysoowdet de, porke ledne rnebééy Dëdyuzh, por mén ne nak zegnak minwin nako. ");
INSERT INTO zpi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nligue yna noo lo de yra de ne mén ne rlaandet ylaa ne rnebééy Dëdyuzh gakdet tee men ledne rnebééy Ne belne gakdet men zegnak minwin ne ron diiz. ");
INSERT INTO zpi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wlis Jesus minwin guin wlen Ne miin, zhich guin wxob nya Ne xtoo miin, wnab Ne lo Dëdyuzh por laa miin. ");
INSERT INTO zpi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chene che nuu Jesus ne yruu Ne nga, noze rzhoon te mén wdxiin men lo Ne. Lex wzuzhib men wnabdiiz men lo Ne, re men: ―Maxter, laa de ne wen de, ¿pagox rap noo degne ylaa noo chen gap noo gyelembán ne nunk luzhdet? ");
INSERT INTO zpi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Wke Ne re Ne: ―¿Penak na de ne wen noo? Yët menwen; nonchee Dëdyuzh wen. ");
INSERT INTO zpi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Laa de che nan de gan pagox rkyeen Dëdyuzh: “Ykanodet de mén ne nakdet lzaa de, yketet de mén, kwandet de, ykagyiidet de mén, ykadedet de, gugaknzebnëz lo xuz de, gugaknzebnëz lo xnaa de.” ");
INSERT INTO zpi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wke mén guin, re men: ―Maxter, yrandxee negwa che rlaa noo axtegue ne win noo. ");
INSERT INTO zpi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Orguin wii Ne lo men, lex ndoondxee wnii Ne lo men, re Ne: ―Benak rak falt ylaa de ste kos: gutsa gutoo yrandxee ne rap de, lex gudee med lo menprob, chen gap de ne non ne nuu gyeybaa; lex chiid de chidnal de noo. ");
INSERT INTO zpi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Per chene won men zenga, axtegue nandet men pe wuu lextoo men, kesentyent nles wuu lextoo men sya men, porke kesentyent rik men. ");
INSERT INTO zpi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Zhich guin wii Jesus noze kbii mén, lex re Ne lo yra xpén Ne: ―¡Kesentyent ngan tee menrik ledne rnebééy Dëdyuzh! ");
INSERT INTO zpi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wzee wzak yra xpén Ne ne re Ne zenga; per wberee Ne, re Ne ste: ―Zhiin, kesentyent ngan tee menrik ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mazre mbëëdee tee te kamey gyeer ne zob nii gyëtsguzh ke ne tee te menrik ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ne won yra xpén Ne zenga, mazre wzee wzak men, lex rnabdizlsaa men, re men: ―¿Txuzh nak ne gun gan yláá lo kastig cheguin? ");
INSERT INTO zpi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Orguin wii Jesus lo men, lex re Ne: ―Por mén gakdet gan gak neree, per Dëdyuzh si zun Ne gan ylaa No, porke por Dëdyuzh yët ne gakdet gan gak. ");
INSERT INTO zpi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Lex re Bëd: ―Noo yra noo, wsan noo yrandxee ne rap noo, zëdnal noo de. ");
INSERT INTO zpi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Wke Jesus, re Ne: ―Nligue yna noo lo de yra de ne kwaskyertee mén ne rsan xyuu, rsan bech, rsan bzaan, rsan xuz, rsan xnaa, rsan xewnaa, rsan zhiin, o rsan xelyu por ne nak men xpén noo no por ne rzëët men xdiiz noo, ");
INSERT INTO zpi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nee ke gyëzlyuree ykakwent men stebgwyuu tir yra ne che rap men: nigle xyuu men, nigle bech men, nigle bzaan men, nigle xnaa men, nigle zhiin men, nigle xelyu men, per sakzi ke mén men; no sdxiin dxe ne gap ke men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Per ndal men ne nak men primer naaree, gak men lultim; no ndal ke men ne nak men lultim, gak men primer. ");
INSERT INTO zpi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chene nuu Jesus nëz ne za Ne Jerusalén, wzaner Ne lo yra xpén Ne. Rzee rzak men, le yra mén ne zanal Ne rdxe. Lex waandxee wbëz Ne yra chibtxup xpén Ne ste, wzëët Ne yra ne sak Ne, ");
INSERT INTO zpi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","re Ne lo men: ―Laa de yra de rwii de ne Jerusalén za be ledne ydekwent mén Men ne wdxiid wak Mén; ydekwent men men lo fxuz ne rnebééy lo yra fxuz no le lo maxter ley, lex gyan yra mén guin diiz ne ynab men lo menzit ne yket menzit men; zhich guin ydekwent men men lo menzit ");
INSERT INTO zpi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","chen yzhidxno menzit men, no ytxonxen men lo men, no ydee men xkwent men, no yket men men; per chene gyon gbiz, yban ke men. ");
INSERT INTO zpi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zhich guin wbig yrup xpee Zebedew lo Jesus, Jacob no le Xwa. Lex re men lo Ne: ―Maxter, rlaan noo ylaa de logne ynab noo lo de. ");
INSERT INTO zpi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Orguin re Ne lo men: ―¿Pagox rlaan de ylaa noo por laa de? ");
INSERT INTO zpi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wke men re men: ―Rlaan noo ne chene ynebééy de, ylaa de ne sob noo koo de, te noo sob ladbëë, ste noo sob ladbëg. ");
INSERT INTO zpi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Lex re Jesus lo men: ―Laa de nandet de gan pe rnab de. ¿Pe zun de wantar sak de zegne sak noo? ¿Pe zun de wantar guet de zegne guet noo? ");
INSERT INTO zpi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wke men re men: ―Zun noo wantaro. Lex re Ne lo men: ―Nli we, zun de wantar sak de zegne sak noo no zun de wantar guet de zegne guet noo, ");
INSERT INTO zpi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","per por ne sob de koo noo ladbëë o ladbëg, ryaldet noo yniiz noo we, sinke le we nak por yra mén ne che nunla ne gyalo. ");
INSERT INTO zpi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chene won schii xpén Ne ne re Jacob zenga yrup Jacob Xwa, wlaa men lo Jacob yrup Jacob Xwa. ");
INSERT INTO zpi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Per wbëz Jesus men yra men, re Ne lo men: ―Laa de yra de nan de ne men ne rnebééy ste nacion, rnebééy men lo mén zegne rlaantee men; zenga ke yra mén ne non ne nuu lad men, rlaa men mén zegne rlaantee men, porke laa men rnebééy. ");
INSERT INTO zpi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per le laa de yra de ylaadet de zenga. Sinke men ne rlaan gaknon lad de, rap men degne laa men ylaa dxiin lo de. ");
INSERT INTO zpi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","No men ne rlaan ynebééy lad de, rap men degne laa men gak mos lo de. ");
INSERT INTO zpi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Porke ni Men ne wdxiid wak Mén zëëdet men por ne ylaa mén dxiin lo men, sinke le men zëëd por ne ylaa men dxiin lo mén no por ne guet men chen yselaa men ndal mén lo dol. ");
INSERT INTO zpi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Zhich guin wdxiin Jesus Jericó yra Ne xpén Ne. Le chene le Ne wruu gyëz guin yra Ne men no le stebëd mén, wdxiin Ne runëz ledne zob te menngwlëë ne la Bartimeo rnab men goon, xpee Timeo nak men. ");
INSERT INTO zpi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ne won men ne Jesus men-Nazaret ne, wzelo men rkarëz men, re men: ―¡Jesus, XPee David, gules lextoo de noo! ");
INSERT INTO zpi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wakndux ndal mén lo men chen gyakchi men, per lel mazre rkarëz men, re men: ―¡XPee David, gules lextoo de noo! ");
INSERT INTO zpi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Orguin wzutsë Jesus, lex re Ne: ―Gukwëz men. Orguin wbëz mén men, re men lo men: ―Ndíp guguu lextoo de, gusuli. Laa de rbëz Jesus. ");
INSERT INTO zpi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Orguin wtxoon men lër ne nrël men lyu, wasulinzeeb men, wbig men lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Lex wnabdiiz Ne lo men, re Ne: ―¿Pagox rlaan de ylaa noo por laa de? Wke menngwlëë guin, re men: ―Maxter, rlaan noo gyenii bzalo noo. ");
INSERT INTO zpi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Lex re Ne lo men: ―Por ne rlaleedx de noo, le bzalo de che wyenii. Che zak gya de. Orgueguin wyenii bzalo men, zanal men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Chene wdxiin Jesus yra Ne xpén Ne guex Jerusalén no le guex Betfagé no le guex Betania ngali gyey-Olivos, wxaal Ne txup xpén Ne, ");
INSERT INTO zpi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","re Ne lo men: ―Gutsa gyëzwin ne nak ngali nee. Ne ydxiin de, tsël te bur bëën bëënleg ne kaduu nga lo de no ne rutlel gardet kwib. Ychil de ma, chidno de maa. ");
INSERT INTO zpi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Belne nuu mén yna lo de: “¿Penak rchil de bur gwa?”, gue de lo men: “Laa Jesus ne rnebééy ykyiinen maa. Orkeree yxaal men men ne chidron maa.” ");
INSERT INTO zpi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Lex wa men, wzël bur guin lo men, kaduu ma runëz guex te ruyaglaa; lex wchil men maa. ");
INSERT INTO zpi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Lex re tebëd mén ne ndxin nga lo men: ―¿Pagox gwa rlaa de? ¿Penak rchil de bur gwa? ");
INSERT INTO zpi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wke men re men zegne re Jesus lo men. Orguin wdee yra mén guin si wzano men maa. ");
INSERT INTO zpi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wdxinno men ma lo Jesus, wxob men lër ne rrël men led maa, lex wbiib Jesus maa. ");
INSERT INTO zpi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ndal mén rgyixnchiil lër nëz, nuuzeg mén rkyiits gyizh rgyix men nëz ledne tee Jesus. ");
INSERT INTO zpi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Noze nesree nesrotee rlen xrëz men ne zaner men ne zanaltee, re men: ―¡Nzoon Dëdyuzh! ¡Dëdyuzh gaknonen men ne zëëd por la Dëdyuzh! ");
INSERT INTO zpi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Nzoon men ne zëëd ynebééy zegne wnebééy David ne wak xpenkwlal be! ¡Nzoon Dëdyuzh! ");
INSERT INTO zpi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zenga wdee Jesus lenlgyëz-Jerusalén, lex wa Ne lenxeydoo Dëdyuzh, zazëëdtee lo Ne. Wluzhse wii Ne, lex za Ne Betania yra Ne chibtxup xpén Ne, porke che rzëë. ");
INSERT INTO zpi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ne wra gyëël chene wruu Jesus Betania yra Ne xpén Ne, wlen wlaanen Ne. ");
INSERT INTO zpi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Lex axtegue nat wii Ne zob tebzhaan yag-ig ne ka gyizh lo. Orguin wa Ne wii gan pe ka ig lo we, per chene wdxiin Ne, bet ig wzëldet lo we, nonchee gyizh ka lo we, porke nakdet xetyemp ig tyemp guin. ");
INSERT INTO zpi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Lex re Ne lo yag guin: ―Nunk rutre gudet ig ne ykaa lo de. Won yra xpén Ne re Ne zenga. ");
INSERT INTO zpi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Zhich guin wdxiin Jesus Jerusalén yra Ne men. Lex wdee Ne ruxeydoo Dëdyuzh, wzelo Ne wnexoon Ne yra mén ne ndxin rtoo nga no le yra mén ne ndxin rzii, no wnekantaa Ne xmezh yra mén ne ndxin rtsaa medzit; zenga ke wlaa Ne xyagzhil yra mén ne rtoo mëër; ");
INSERT INTO zpi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","no bet wdeedet Ne si ndesuneey mén nes lenydoo. ");
INSERT INTO zpi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Lex re Ne lo yra mén: ―Lo xgyiich Dëdyuzh re: “Xyuu noo, ledne ynab yrandxee mengyëzlyu lo noo sela we”; per le laa de yra de rlaa do zegnak xebluu ngbaan. ");
INSERT INTO zpi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ne won yra fxuz ne rnebééy lo yra fxuz zenga yra men maxter ley, wzelo men wye men gan pezee ylaa men chen yket men Ne, porke rdxe men ne yrandxee mén rzee rzak zeg rneluu Ne. ");
INSERT INTO zpi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Per zegne wnit lyu, wruugue Ne Jerusalén sya Ne. ");
INSERT INTO zpi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ne wra gyëël rsil, wdee Jesus nga yra Ne xpén Ne, wii men le yag-ig guin che wbidx axtegue ydeblu we. ");
INSERT INTO zpi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Orguin wnileedx Bëd diiz ne re Ne lo yag-ig, lex re Bëd lo Ne: ―Maxter, gukwii gante, wbidx yag-ig ne wnii de lo naag. ");
INSERT INTO zpi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Wke Jesus, re Ne: ―Gulaleedx Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Porke nligue yna noo lo de ne kwaskyertee men ne gue lo gyeeyree: “Gubetxee nee, gugyab lo nisdoo”, belne nutxupdet lextoo men sinke tebegue nuu lextoo men ne zak ne re men, no zako. ");
INSERT INTO zpi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Por neguin na noo lo de yra de ne yrandxee ne rnab de lo Dëdyuzh, tebegue guguu lextoo de ne zako, no zako. ");
INSERT INTO zpi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","No chene rnab de lo Dëdyuzh, gugun perdon semén de belne pe wlaa men de, chen gun ke Dëdyuzh de perdon. ");
INSERT INTO zpi_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Per belne laa de ne rundet de perdon semén de, laake gundet ke Dëdyuzh de perdon. ");
INSERT INTO zpi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Zhich guin wberee ke Jesus Jerusalén yra Ne xpén Ne. Or ne le Ne zuyeky lenxeydoo Dëdyuzh, wbig fxuz ne rnebééy lo yra fxuz yra men maxter ley no le men ne rnebééy lo men-Israel, ");
INSERT INTO zpi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","wnabdiiz men lo Ne, re men: ―¿Txu wkyeen de ne rlaa de neree? ¿Txu wnebééy lo de ne rlaa do? ");
INSERT INTO zpi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wke Ne re Ne: ―Laake no ke noo ynabdiiz lo de yra de; belne yke de, lex yna noo gan txu wkyeen noo ne rlaa noo we. ");
INSERT INTO zpi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Txuzh wxaal Xwa ne wtxobnis Xwa mén, Dëdyuzh u noze mén? Guke bes. ");
INSERT INTO zpi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Orguin wzelo men rulsaa men diiz, re men: ―Belne gue be ne Dëdyuzh wxaal Xwa, naap yna zhaa: “¿Penak wlaleedxdet de Xwa cheguin?” ");
INSERT INTO zpi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿U peguin ze be, noze mén wxaal Xwa? Rdxe men ne ylayaa mengyëz, porke yrandxee mengyëz rlaleedx ne nli ne te profet nak Xwa. ");
INSERT INTO zpi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Orguin wke men re men: ―Nandet noo we. Lex re Jesus: ―Laake ni noo yzëëdet gan txuzh wkyeen noo ne rlaa noo neree. ");
INSERT INTO zpi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Wzelo Jesus wuu Ne zegnak te kwent lo men yra men, re Ne: ―Wuu te mgyeey ne wlabni blag ub lo xelyu, lex wtsëloo meno, no wzhexkwaa men te ledne yzhii ub, no wlep men te ne kesentyent gya ledne kwiin men ne ykanapo ydendxoo. ’Zhich guin wbodiin men blag ub guin lo tebëd mén ne rapkwent blag ub. Lex wruu men za men nat. ");
INSERT INTO zpi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Le chene wdxiin tyemp ne le ub wal gyët, wxaal xpexwaan blag ub guin te xmos men lo yra men ne rapkwento, zaxii xmos men ub ne ryal xpexwaan blag ub guin. ");
INSERT INTO zpi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Per lel wnëëz yra men ne rapkwent blag ub mos guin, wdee men xkwent men, wzanëz men men nonchee zenga. ");
INSERT INTO zpi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Zhich guin wxaal xpexwaan blag ub ste xmos men, per lel wgugye yra men ne rapkwent blag ub mos guin, wla men xtoo men, wboo men xeblaan men. ");
INSERT INTO zpi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Zhich guin wxaalgue xpexwaan blag ub ste xmos men, per wket yra men ne rapkwent blag ub mos guin. Lex wxaal xpexwaan blag ub stebëd xmos men; gwrol men wdee mén guin xkwent, gwrol zeg men wket men. ");
INSERT INTO zpi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Per rap men te xpee men ne kesentyent ryaan men. Ne lultim wxaal men mee, nuu lextoo men: “Lo xpee noo si zaknzebnëz men.” ");
INSERT INTO zpi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Per re yra mén guin ne rapkwent blag ub: “Laa ménree nak ne gyanno blag ubree; yoo yket be men, chen gyanno bo laa be.” ");
INSERT INTO zpi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Lex wnëëz yra mén guin mee guin, wket men mee, wboo men me lo lyu guin. ");
INSERT INTO zpi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Naaree naa, ¿pagox ylaa xpexwaan blag ub yra mén guin ne wapkwent blag ub? Yna noo lo de ne chiid men yket men yra mén guin, lex ydee men blag ub lo stebëd mén. ");
INSERT INTO zpi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Pe gardet gool de lo xgyiich Dëdyuzh? Nga re: Gye ne axtegue rlaandet mén ne rlep yuu, laa we wak gye ne mazre rkyiindee. ");
INSERT INTO zpi_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dëdyuzh wlaa neree, no le be kesentyent rzee rzak. ");
INSERT INTO zpi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Orguin wlaan men nguu men Jesus chegyiib, porke wyenen men ne por laa men wzëët Ne yra diiz guin. Per kom rdxe men mén, wsan men Ne nga, sya men. ");
INSERT INTO zpi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Zhich guin wxaal men tebëd men ne nak farisew no le tebëd xpén Herodes wa wanii lo Jesus chen gan pe gue Ne chen tsël gan pezee ykagyii men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chene wdxiin men lo Jesus, re men: ―Maxter, nan noo yra noo ne nli ne rnii de, zadet lextoo de gan txu nak mén porke por laa de tese nak mén. Laa de si rneluu de ne ybán mén zegne rlaan Dëdyuzh. Guna gan ¿pe wen gyizh noo zeg impwest lo rrey-Roma u wendeto? ¿Pe ryal gyizh noo we u ryaldeto? ");
INSERT INTO zpi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per kom nan Jesus ne noze rkanlo men wen men, lex re Ne lo men: ―¿Penak rye de gan pezee gyab noo lo xetramp de? Gutano te med kwii noo. ");
INSERT INTO zpi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Orguin wdee men te med lo Ne; lex re Ne lo men: ―¿Txu lo nee no txu la nee ka lo we? Wke men re men: ―Lo rrey-Roma we no le la rrey-Roma we. ");
INSERT INTO zpi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Lex re Ne lo men: ―Guex gudee ne nak xen rrey lo rrey, le ne nak xen Dëdyuzh gudee lo Dëdyuzh. Noze wzee wzak men ne re Ne zenga. ");
INSERT INTO zpi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Zhich guin wa tebëd men ne nak sadusew lo Jesus. Kom rlaleedxdet men ne sban mengut, por neguin re men lo Ne: ");
INSERT INTO zpi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maxter, lo ley ne wdee Dëdyuzh lo Moises zëëd ne belne guet te mén, per wapdet xewnaa men mëëd, bech men rap degne ytsëlnyano wnaa guin, chen gap men mëëd ne gak zegnak zhiin mén guin ne wet. ");
INSERT INTO zpi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tebtir wuu guedx mén, tese bech men yra men; lex wtsëlnya men ne nak mengoldee lo men yra men, per wet men; wuudet zhiin men. ");
INSERT INTO zpi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lex wtsëlnya men ne wrup yrup men wnabyud guin per wet ke men; wuudet ke zhiin men. Zenga ke wzak men ne wyon. ");
INSERT INTO zpi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Zenga wzak men yra men axtegue wzaa men guedx; ni te men wuudet zhiin. Wyal wdebo, wet ke no wnaa guin. ");
INSERT INTO zpi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Orrenaa, chene yban mengut, ¿txu xewnaapee gak wnaa guin ne yrandxee guedx mén guin wtsëlnyano men? ");
INSERT INTO zpi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Wke Jesus, re Ne lo men: ―Laa de yra de ngyidet ne rnii de, porke rdeedet de kwent ne zëëd lo xgyiich Dëdyuzh, ni rdeedet de kwent pezee nak xpoder Ne. ");
INSERT INTO zpi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chene yban mengut, che ytsëlnyadetre men, ni mgyeey ni wnaa, sinke zegnak angel ne nuu gyeybaa gak men. ");
INSERT INTO zpi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Belne rlaleedxdet de ne sban mengut, ¿pe gardet gool de lo liber ne wkaa Moises xkwent gyëtsbne ne kayeeky? Nga re Dëdyuzh lo Moises: “Noo nak XDëdyuzh Abraham, XDëdyuzh Isaac, XDëdyuzh Jacob.” ");
INSERT INTO zpi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nakdet Dëdyuzh XDëdyuzh mengut, sinke le Dëdyuzh nak XDëdyuzh menmbán. Por neguin na noo lo de ne ngyidet ne rnii de. ");
INSERT INTO zpi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ne won te ke maxter ley ne re Jesus zenga no ne wyenen men ne wen wke Ne, wbig men wnabdiiz men lo Ne, re men: ―¿Gonezhe nak ne mazre nondee ne zëëd lo xley Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Wke Ne re Ne: ―Ne mazre nondee nak ne re: “Men-Israel, gugon neree; XDëdyuzh be, tendxee Ne; ");
INSERT INTO zpi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","gugyaan Ne ydebgyiky ydeblextootee de, ydebxanem de, ydebxfwers de.” Laa neree nak ne mazre nondee ne zëëd lo xley Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Le ne wrup nak: “Gugyaan semén de zegne ryaan ke de de.” Yëtre ne mazre nondee ke lo yrup neree. ");
INSERT INTO zpi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Orguin re maxter ley lo Ne: ―Wen wke de Maxter. Nli negwa ne na de, ne tendxee Dëdyuzh nuu no ne yëtre ste Dëdyuzh, sinke tendxee Ne nuu. ");
INSERT INTO zpi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","No ne gyaan me Ne ydebgyiky ydeblextootee me, ydebxanem me, ydebxfwers me, no ne gyaan me semén me zegne ryaan ke me me, laa we nak ne mazre nondee ke lo goon ne rguu me no ke lo yra maa ne rzeey me lo fkuuk. ");
INSERT INTO zpi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chene wyenen Jesus ne xnëz wke men, re Ne lo men: ―Che wyob gaknan de pezee rnebééy Dëdyuzh. No ni ste men wyezhdetre nnabdiiz lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Te chene kaneluu Jesus mén lenxeydoo Dëdyuzh, re Ne lo men: ―¿Penak re maxter ley ne xpee David nak Crist? ");
INSERT INTO zpi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Si chene waknonen Espíritu Sant David, David ke re: Dëdyuzh re lo XDëdyuzh noo: “Gusob koo noo ladbëë axtegue ne ylaa noo ne gyichnii de yrandxee mén ne rlaa lo de.” ");
INSERT INTO zpi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Belne David ke rnesela Crist XDëdyuzh David, ¿pezee gak Crist xpee David? Le yra menroo guin, rzhiilen men ron men ne rzëët Ne. ");
INSERT INTO zpi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Or ne kaneluu Jesus mén, re Ne lo men: ―Gugap maxter ley kwent, porke rtseleedx men gak men lërngool, no rtseleedx men ne kon gyelenzebnëz gabtyuzh mén men nes lgyeey, ");
INSERT INTO zpi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","no rye men lo yagzhil ne rzob mennon lenydoo chen sob men; zenga ke rlaa men chene ra men gwdu, ");
INSERT INTO zpi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","no rgyitxee men xyuu wnabyud, per por ne gyendeto, kesentyent xche rnab men lo Dëdyuzh, per laa men yra men nak ne ntozdee sakzi. ");
INSERT INTO zpi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tebtir zob Jesus lenxeydoo Dëdyuzh ngali ledne zob ne rguu mén goon, rwii Ne ra mén rguu men goon nga, no ndal ke menrik ra rguu mednyezh leen guin. ");
INSERT INTO zpi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nga ke zob Ne, wdxiin te wnabyudprob, wguu men txup medwin ne kober leen guin no ne zhindxee non. ");
INSERT INTO zpi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Lex wbëz Jesus xpén Ne, re Ne lo men: ―Nligue yna noo lo de ne nondee goon ne wguu wnabyudprobree ke lo xgoon yra mén ne wguu goon. ");
INSERT INTO zpi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porke yra mén wguu men ne che wrukaa nya men, per le wnaaree mase lo xgyeleprob men, wguu men logne nzenendxee men ne rdeendxee men lo xelyaaz men. ");
INSERT INTO zpi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Chene wruu Jesus lenxeydoo Dëdyuzh, re te xpén Ne lo Ne: ―¡Maxter, gukwii gante pezee nzhoo gyeree no pezee nzhoo ydooree! ");
INSERT INTO zpi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Wke Ne re Ne lo men: ―Ydonzhooree ne rwii de, ni te gye gyandet led ste gye, yrandxoo luzh. ");
INSERT INTO zpi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Or ne zob Jesus gyey-Olivos ngali ruxeydoo Dëdyuzh, wbig Bëd lo Ne yra Bëd Jacob, no le Xwa, no le Ndrizh, lex laangue wnabdiiz men lo Ne, re men: ");
INSERT INTO zpi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Rlaan noo yzëët de gan pa or gak yra negwa. ¿Pezee gak beey ne tsuu chene le we che wyob gak? ");
INSERT INTO zpi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wke Jesus, re Ne: ―Gugap kwent, rut ydeedet de si ykade de. ");
INSERT INTO zpi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Porke schiid ndal mén ne ykade, gue men: “Noo nak Crist”; no ndal mén gun men gan ykade men. ");
INSERT INTO zpi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’No chene gon de diiz ne le dilroo nuu nesree nesrotee, ydxedet de, porke zenga nak ne rap degne gak; per let laadet ne nitlo gyëzlyu nga. ");
INSERT INTO zpi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Porke te nacion til yrup ste nacion, te gobyeren til yrup ste gobyeren, no kesentyent yni lyu nesree nesrotee, no tsuu gbiin. Per chene gak yra neree, laa ne gyed selondxee gyelenles nga. ");
INSERT INTO zpi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Per gugap kwent porke sdekwent mén de lo xtis, no sniiz men xkwent de lenydoo, no rap de degne ybig de lo gobernador no le lo rrey por ne nak de xpén noo. Zenga gak gu de xdiiz noo lo men yra men. ");
INSERT INTO zpi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Antes ne nitlo gyëzlyu, rap degne gakzëët xdiznzoon Dëdyuzh lo yrandxee mén ne nuu ydendxee gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","No chene ydekwent mén de lo xtis, bet tsadet lextoo de gan pe gue de, ni ylebleedxdet do. Logne guu Dëdyuzh lextoo de orguin, neguin nak ne gue de, porke let laadet de nak ne ynii, sinke Espíritu Sant nak ne ynii. ");
INSERT INTO zpi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","No laake bech mén ydekwent bech mén chen yket mén bech men, laake ngwzan ydekwent zhiin ngwzan, laake zhiin ngwzan til ngwzan no ylaa zhiin ngwzan ne yket mén ngwzan. ");
INSERT INTO zpi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kwinyaan yrandxee mén de por ne rzëët de xdiiz noo, per men ne ysalzaandet xdiiz noo ydeblo ne ybán men, men guin nak ne yláá. ");
INSERT INTO zpi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Che wkaa profet-Daniel xkwent ne mbixleedx; por neguin chene kwii de zhoob ne mbixleedx ledne ryaldet xoobo (men ne gool neree, ydee men kwento), men ne nuu Judea rap men degne yzhoon men gya men gyeey den. ");
INSERT INTO zpi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Men ne zob xtoo xyuu rap men degne yzhoon men, koodet men ne nuu lenxyuu men; ");
INSERT INTO zpi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","men ne zu den ybereedet men tsaxii men xab men. ");
INSERT INTO zpi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Prob yra wnaa ne nakzhiin chene ydxiin dxe guin! ¡Prob yra wnaa ne rap mëëd ne roo dud! ");
INSERT INTO zpi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gunab lo Dëdyuzh ne gakdet neree mëëw ne rak nal. ");
INSERT INTO zpi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porke chene ydxiin dxe guin, kesentyent tsuu gyelenles ne nunk gardet tsuu kwlolne wzhexkwaa Dëdyuzh gyëzlyu, ni ybereedetro tsuu we. ");
INSERT INTO zpi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Belne ytsowndopdet Dëdyuzh tyemp ne gak yra neguin, rutlel yláádet; per stsowndop No por ne ryaan Ne yra xpén Ne ne wye Ne laa Ne. ");
INSERT INTO zpi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Chene ydxiin dxe guin, belne nuu mén yna lo de yra de: “Gukwii, le Crist zu nee”, o “Gukwii, le Crist zu wa”, ylaleedxdet de men. ");
INSERT INTO zpi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Porke zuu ndal mén ne ykade, gue men laa men nak Crist, no zuu ndal mén ne ykade, gue men laa men nak profet; ylaa men gyelmilaguer no ylaa men logne yzee sak mén, chen ykade men mén no belne gun men gan, axtegue xpén Dëdyuzh ykade men. ");
INSERT INTO zpi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Por neguin gugap kwent! Le yra neree che nague noo lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Chene che wdesu yra dxe guin ne tsuu gyelenles, gaknkeb lo ngbiz, ni mëëw yzeniidetre, ");
INSERT INTO zpi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","gyitxee yra mël ne ndxiib gyeybaa, no yni yrandxee ne nuu gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Cheguin kwii mén Men ne wdxiid wak Mén zëëd men lad bëw ydebxpoder men no ydebxgyelenzoon men. ");
INSERT INTO zpi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Lex yxaal men yra xangel men ytop xangel men yrandxee xpén men, men ne nuu ydendxee gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Gukwii zegnak yag-ig: Chene rreeno ne rlen gyizh lo we, ryenengue de ne le mëëw ne rak neey che zëdyob. ");
INSERT INTO zpi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Zenga ke chene kwii de ne le yra neree che kayak, syenengue de ne le Men ne wdxiid wak Mén che zëdguex. ");
INSERT INTO zpi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nligue yna noo lo de yra de ne antes ne guet yra mén ne nuu naaree, gak yra neree. ");
INSERT INTO zpi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Gyeybaa no le gyëzlyu snitlo we, per le xdiiz noo tesudet ne gako. ");
INSERT INTO zpi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Per le dxe, le or ne gako, rut nandeto, ni angel ne nuu gyeybaa nandeto, ni XPee Dëdyuzh. Nonchee Dëdyuzh Xuz be nano. ");
INSERT INTO zpi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Por neguin list gugak yra de, nsin gukwiin, gunab lo Dëdyuzh, porke nandet de pa dxe nak ne ydxiin orguin. ");
INSERT INTO zpi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gako zegnak chene rruu te mén ra men nat. Or ne le men che wal tsa, re men lo xmos men ne gapkwent men xyuu men. Wsan men dxiin ne ylaa men te te men, no re men lo men ne zunap ruyaglaa ne gapkwent men ruyaglaa. ");
INSERT INTO zpi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","List gugak yra de, porke nandet de gan pa or ylenza xpexwaan yuu, belne ylenza men wnit lyu, o gwrool gyëël, o or ne rkarëz ngyedgol, o or ne wyenii lyu. ");
INSERT INTO zpi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tegue ylenza men noze terpent, yga de lo men le de nexguees. ");
INSERT INTO zpi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Neree ne na noo lo de yra de, ze ke noo we lo yrandxee mén: ¡List gukwiin! ");
INSERT INTO zpi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Txup gbiz rak falt ne ydxiin pask, lni ne ru mén gyëtxtil ne nootsdet lebadur, wzelo yra fxuz ne rnebééy lo yra fxuz yra men maxter ley rye men gan pezee kode men Jesus chen ynëëz men Ne yket men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Per re men: ―Ylaadet bo lo lni chen gakntozdet mengyëz lo be. ");
INSERT INTO zpi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Chene ka Jesus gyëz-Betania ruxyuu Simon men ne rnii ke men Leproso, or ne zob Ne lo mezh, wdxiin te wnaa wdxinneey men te bot alabastro, yzaa we perfum ne kesentyent nyezh non ne nzhexkwaa kon teblose gyexnazh byaa. Lex wxal men bot guin, wdxiib men perfum guin xtoo Jesus. ");
INSERT INTO zpi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Por neguin wlaa gwrol men ne ndxinno Ne nga, lex re men lo xkompanyer men: ―¿Penak noze wxiin wnaa gwa perfum gwa? ");
INSERT INTO zpi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mazre wendee ntoo meno zeg lal ne run mos gan te iz, chen nruu med nkyiinen menprob. Lex wakndux men lo wnaa guin. ");
INSERT INTO zpi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Per re Jesus lo men yra men: ―Zeka men. ¿Penak rakndux de lo men? Neree ne wlaa men noo, weno. ");
INSERT INTO zpi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Porke menprob yzaandxee dxe tsuu men lad de, zak ylaa de ne wen por laa men chene rlaantee de, per le noo che xchedetre tsuu noo lad de. ");
INSERT INTO zpi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wlaa wnaaree logne wunendxee men gan; wdxiibgue men perfum led noo chen che list nak noo chene tsugyeer noo. ");
INSERT INTO zpi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nligue yna noo lo de yra de ne ydendxee gyëzlyu ledne gakzëëttee xdiznzoon Dëdyuzh, zakzëët ke ne wlaa wnaaree, chen zenga ynileedx mén men. ");
INSERT INTO zpi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Zhich guin wa Judas Iscariote lo fxuz ne rnebééy lo yra fxuz, re Judas ne ydekwent Judas Jesus lo men. Te ke men ne nak xpén Jesus chibtxup nak Judas. ");
INSERT INTO zpi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chene won men ne re Judas zenga, wzhiilen men, lex re men lo Judas ne ydee men med lo Judas. Ngatee wzelo Judas wye Judas gan pezee ydekwent Judas Jesus lo men. ");
INSERT INTO zpi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Primer dxe lni pask ne ru mén gyëtxtil ne nootsdet lebadur no ne rket men te mëkzhiil bëën bëënleg ne ru men lo pask, wnabdiiz xpén Jesus lo Ne, re men: ―¿Pazh rlaan de tsazhexkwaa noo ne guxsëë be lo lniree? ");
INSERT INTO zpi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Orguin wxaal Ne txup xpén Ne, re Ne lo men: ―Gutsa lenlgyëz. Nga ytsëlo de te mén ne neey tebree nis. Tsanal de men. ");
INSERT INTO zpi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yuu ne tee men, gue de lo xpexwaan yuu guin: “Zere na Maxter, ¿go lenyuuzhe guxsëë Maxter lo pask yra Maxter xpén Maxter?” ");
INSERT INTO zpi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Lex yluu men te lenyunzhen ne nak pisgya lo de, che xnëz nak leeno; nga yzhexkwaa de ne guxsëë be. ");
INSERT INTO zpi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Orguin za men yrup men, wdxiin men lenlgyëz, no yrandxee ne re Jesus lo men, wako. Lex wzhexkwaa men ne guxsëë Ne lo pask yra Ne men. ");
INSERT INTO zpi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Chene wnit lyu, wdxiin Jesus nga, wzob Ne lo mezh yra Ne chibtxup xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ne zob Ne lo mezh yra Ne men, or ne kayu Ne, re Ne lo men: ―Nligue yna noo lo de yra de, ne laake de te de zegne zobyu de nee nak ne ydekwent noo lo mén chen yzakzi men noo. ");
INSERT INTO zpi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ne won men zenga, wunles lextoo men yra men, wzelo men rnabdiiz men lo Ne te te men, re men: ―¿Peguin noo ne? Re men ste men: ―¿Peguin noo ne? ");
INSERT INTO zpi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wke Jesus, re Ne: ―Te ke de zegnak de chibtxup ne rgoob ne ru lengyaan ke ne rgoob noo ne ru noo nak ne ydekwent noo lo mén chen yzakzi men noo. ");
INSERT INTO zpi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Men ne wdxiid wak Mén rap men degne sak men zegne re lo xgyiich Dëdyuzh; per ¡prob mén ne ydekwent men! Mazre wendee por laa mén guin ne nyaldet men. ");
INSERT INTO zpi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Or ne kayu Ne yra Ne men, wgoob Ne gyëtxtil, wdee Ne dexkyizhtee lo Dëdyuzh, lex wla No wdee No lo men, re Ne: ―Gunëëz gyëtxtilree, gugu we; laa we nak xkwerp noo. ");
INSERT INTO zpi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Zhich guin wgoob Ne bas ne nuu bin, wdee Ne dexkyizhtee lo Dëdyuzh; wluzh nga wdee No lo men, woo meno yra men. ");
INSERT INTO zpi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Lex re Ne lo men: ―Laa xren noo wa ne yzhe chene guet noo por ndal mén, chen gyal te nëzkweb ne gak ydxiin men lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nligue yna noo lo de yra de ne goodetre noo bin ub, axtegue chene ydxiin dxe ne goo noo binkweb ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wluzhse wolbaan Jesus te salmo yra Ne xpén Ne, za Ne gyey-Olivos yra Ne men. ");
INSERT INTO zpi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Lex re Ne lo men: ―Sboleedx de noo yrandxee de negyëëlree, porke zenga zëëd lo xgyiich Dëdyuzh ledne re: “Yket noo men ne rapkwent mëkzhiil, le mëkzhiil noze yrëëts.” ");
INSERT INTO zpi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per chene che wban noo, sanergue noo lo de tsa noo Galilea. ");
INSERT INTO zpi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Orguin re Bëd lo Ne: ―Mase koleedx men de yra men, per noo koleedxdet noo de. ");
INSERT INTO zpi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Per re Jesus lo Bëd: ―Nligue yna noo lo de ne negyëëlkeree, antes ne yrup tir ykarëz ngyedgol, che wyon tir wkedxnruu de ne rnebeey de noo. ");
INSERT INTO zpi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Per regue Bëd ste: ―Mase guet noo tese yrup noo de, per ykedxnruudet noo ne rnebeey noo de. Zenga ke re yra xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ne wdxiin Jesus ledne la Getsemaní yra Ne xpén Ne, re Ne lo men: ―Nee gusob myentras ne le noo tsanab lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wzano Ne Bëd, no le Jacob, no le Xwa; lex wlen kesentyent wunles lextoo Ne, axtegue baanske wuu lextoo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Orguin re Ne lo men: ―Kesentyent nles nuu lextoo noo, zem zet noo lo gyelenlesree. Nee gugyan, gusobna. ");
INSERT INTO zpi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Lex za Ne nodese, wandeslo Ne lyu wnab Ne lo Dëdyuzh ne belne gak gan, ydxiindet or ne sak Ne yra ne zëëd sak Ne, ");
INSERT INTO zpi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","re Ne: ―Abba, Dëde, por laa de yrandxoo zak gak. Guselaa noo lo gyelenlesree; per gakdet zegne rlaan noo, sinke zegne rlaan de. ");
INSERT INTO zpi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Zhich guin wberee ke Ne ledne wyan men gyon men; chene wdxiin Ne, le men ndxinguees. Orguin re Ne lo Bëd: ―Simon, ¿pe nexguees de? ¿Pe ni te or wakdet nzobna de? ");
INSERT INTO zpi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gusobna, gunab lo Dëdyuzh chen ysegyeedet Bzelo lextoo de. Rlaan de ylaa de ne wen, per led de rundet gan. ");
INSERT INTO zpi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Zhich guin za Ne ste, wnab Ne lo Dëdyuzh. Diiz ke ne re Ne primer, diiz ke guin re Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chene wberee Ne, le men ndxinguees ke ste, porke noze rdiib bzalo men tant zëëden men mkaal, ni nandet men gan pe gue men lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ne wyon tir ne wberee Ne ledne ndxin men, re Ne lo men: ―¿Pe benak ndxinguees de? ¿Pe benak ndxinne de? Neetegue we nagon; le or ne ynëëz mén Men ne wdxiid wak Mén che wdxiin, chen ydekwent mén men lo mendol. ");
INSERT INTO zpi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gutsaxee, guseyoo naa; le men ne ydekwent noo che zëdguex. ");
INSERT INTO zpi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Benak kanii Jesus chene wdxiin Judas; te ke men ne nak xpén Jesus chibtxup nak Judas; wdxinno Judas ndalyaa mén ne nzen spad no le mén ne nzen yag. Laa fxuz ne rnebééy lo yra fxuz no le maxter ley no le men ne rnebééy lo men-Israel wxaal yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Che re Judas lo yra mén guin gan pezee ydekwent Judas Ne lo men, re Judas: ―Men ne goo noo bzhid gyedkwes, laa men nga; ynëëzgue de men, yliib de men chiich, lex sano de men. ");
INSERT INTO zpi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Zegne wdxiin Judas, wbiggue Judas lo Jesus, re Judas: ―Maxter, Maxter. Lex woo Judas bzhid gyedkwes Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Orguin wnëëz yra mén guin Jesus chen sano men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Per wboo xespad te ke men ne zuno Jesus nga, wkyits meno gyedyag xmos fxuz ne mazre nondee, wtxugnëz meno tebo. ");
INSERT INTO zpi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Orguin re Jesus lo yra mén guin: ―¿Penak zëëd de zëdnëëz de noo kon spad, kon yag, zeg teleg ngbaan nak noo? ");
INSERT INTO zpi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","No yzaandxee dxe wzu noo lenxeydoo Dëdyuzh wkaneluu noo de yra de, no wnëëzdet de noo. Per kayak neree chen gak kumplir yra ne zëëd lo xgyiich Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Orguin wzhoon yra xpén Ne, wsan men Ne tendxee Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Per zanal te mgyeymenyu Jesus, nonchee te saben nrël men. Lex za yra mén guin nnëëz men men, ");
INSERT INTO zpi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","per nonchee saben wzuun. Lex wseláá men saben, wzhoon men noze bëël men. ");
INSERT INTO zpi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Zhich guin wano yra mén guin Jesus lo fxuz ne mazre nondee. Nga wdop yra fxuz ne rnebééy lo yra fxuz, no le men ne rnebééy lo men-Israel, no le maxter ley. ");
INSERT INTO zpi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Le Bëd zanal Ne nat nat axtegue ne wdxiin Bëd ruxyuu fxuz ne mazre nondee. Lex wzob Bëd lo gyi wzanen Bëd yra Bëd men ne rapkwent xeydoo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Le yra fxuz ne rnebééy lo yra fxuz no le yra xtis-Israel rye gan pezee ykagyii men Jesus, chen ykyeen men guet Ne. Per wzëldet gan pezee nkagyii men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mase ndal mén wbig wkagyii Ne, per noze wren wren rnii men te te men. ");
INSERT INTO zpi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nuu mén guin re: ");
INSERT INTO zpi_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Noo yra noo won ne re ménree: “Noo ylitla ydooree ne wzhexkwaa mén no tsonegue gbiz ylep noo te ne let méndet yzhexkwaa.” ");
INSERT INTO zpi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per ni mase zenga, let tesdet rnii men yra men. ");
INSERT INTO zpi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Orguin wzuli fxuz ne mazre nondee, wzu men gwrooltee lad men yra men, wnabdiiz men lo Jesus, re men: ―¿Pe bet ykedet de? ¿Pe rna rnii men zeree por laa de? ");
INSERT INTO zpi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Per wkedet Jesus, noze chi wzu Ne. Lex wberee fxuz ne mazre nondee wnabdiiz men lo Ne ste, re men: ―¿Pe laa de nak Crist XPee Dëdyuzhnzoon? ");
INSERT INTO zpi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Wke Ne re Ne lo men: ―Noo ne. Swii de zob Men ne wdxiid wak Mén koo Dëdyuzhnzoon ladbëë no swii de zëëd men lad bëw gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Orguin wtxëz xab fxuz ne mazre nondee, re men: ―Pe ylar be testig. ");
INSERT INTO zpi_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Laa de yra de che won de ne diznyaan rnii ménree por Dëdyuzh. ¿Pe na de, pezee gak men? Orguin wyan men diiz yra men ne rzëël guet Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Orguin wzelo txup tson mén wtxonxen men lo Ne no wtsëë men lo Ne, lex wgupunyet men Ne, re men: ―¿Txu rniiz xkwent de gan? Le men ne rapkwent xeydoo Dëdyuzh rgapgue gyedkwes Ne. ");
INSERT INTO zpi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Or ne zob Bëd ruxyuu fxuz ne mazre nondee, wdxiin te wnaa ne rlaa dxiin lo fxuz guin. ");
INSERT INTO zpi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ne wii wnaa guin zob Bëd lo gyi, wii men lo Bëd, lex re men: ―¿No de nak xpén Jesus men-Nazaret ye? ");
INSERT INTO zpi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Per wkedxnruu Bëd, re Bëd: ―Rnebeeydet noo men, ni nandet noo gan pagox gwa rnii de. Wluzh nga wruu Bëd wzu Bëd ruporton nes fwer. Orguin wkarëz te ngyedgol. ");
INSERT INTO zpi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Zhich guin wiigue wnaa guin lo Bëd ste, wzelo men re men lo yra mén ne ndxin nga: ―No mgyeeyree nak xpén mén gwa. ");
INSERT INTO zpi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Per wkedxnruu Bëd ste. Orsegue wako, re men ne ndxin nga lo Bëd: ―Nlipee ne no de nak te xpén men, porke ryenen noo ne men-Galilea nak de porke rnii de zegne rnii men-Galilea. ");
INSERT INTO zpi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Orguin wzelo Bëd wgon Bëd Dëdyuzh, re Bëd: ―Dëdyuzh yzakzi noo belne nlidet rnii noo. ¡Noo axtegue rnebeeydet noo mén gwa ne rzëët de yra de! ");
INSERT INTO zpi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Orke guin wrup tir wkarëz te ngyedgol. Lex wnileedx Bëd ne re Jesus lo Bëd: “Antes ne yrup tir ykarëz ngyedgol, che wyon tir wkedxnruu de ne rnebeey de noo.” Ne wnileedx Bëd neguin, wzelo Bëd woon Bëd. ");
INSERT INTO zpi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Chene wyenii lyu, wdop yra fxuz ne rnebééy lo yra fxuz, no le men ne rnebééy lo men-Israel, no le maxter ley, no le yrandxee men ne nak xtis-Israel. Wliib men Jesus, zano men Ne wdekwent men Ne lo Pilato. ");
INSERT INTO zpi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Lex wnabdiiz Pilato lo Ne, re Pilato: ―¿Pe laa de nak xerrey men-Israel? Wke Ne re Ne: ―Zegwa we zeg na de. ");
INSERT INTO zpi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Lex wzelo fxuz ne rnebééy lo yra fxuz noze ndal ne rkagyii men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Wberee Pilato wnabdiiz Pilato lo Ne ste, re Pilato: ―¿Pe bet ykedet de? Gukwii palaltee ne rkagyii men de. ");
INSERT INTO zpi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Per wkedetre Ne. Por neguin kesentyent wzee wzak Pilato. ");
INSERT INTO zpi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lo lni nak xkoxtumber Pilato rselaa Pilato te mén ne nuu chegyiib, log mén ne guetee mengyëz. ");
INSERT INTO zpi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Cheguin nuu te men ne la Barrabás chegyiib por ne wket men mén yra men stebëd men ne wket ke mén chene wtsëldil men gobyeren. ");
INSERT INTO zpi_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wdxiin yra mén, wzelo men rnab men lo Pilato ne ylaa Pilato zegnak xkoxtumber men. ");
INSERT INTO zpi_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Lex wnabdiiz Pilato lo men, re Pilato: ―¿Pe rlaan de yselaa noo xerrey men-Israel? ");
INSERT INTO zpi_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Re Pilato zenga porke wyenen Pilato ne por gyelembidye wdekwent yra fxuz ne rnebééy lo yra fxuz Jesus lo Pilato. ");
INSERT INTO zpi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per che wun yra fxuz ne rnebééy lo yra fxuz gan wguu men lextoo yrandxee mén chen ynab men ne yláá Barrabás. ");
INSERT INTO zpi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Lex wnabdiiz Pilato lo yra mén guin ste, re Pilato: ―¿Pagox rlaan de ylaa noo menree ne rnii de xerrey men-Israel? ");
INSERT INTO zpi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wke yra mén, noze rderëz men, re men: ―¡Lo kruz gukaa men! ");
INSERT INTO zpi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lex re Pilato lo men: ―¿Penako? ¿Pe ne malzhe wlaa men? Per lel mazre rderëz men, re men: ―¡Lo kruz gukaa men! ");
INSERT INTO zpi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kom rlaan Pilato gyan Pilato wen nes lo yra mén, wselaa Pilato Barrabás; lex wkyeen Pilato soldad ne ydee soldad xkwent Jesus; chene wluzh wdee men xkwent Ne, wdekwent Pilato Ne lo men chen tsakaa men Ne lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Zhich guin zano men Ne ruyuloow; lex wtop men yrandxee sesoldad men. ");
INSERT INTO zpi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wnegak men Ne te lërnloren, no wzhexkwaa men te korongyëts wzoob meno xtoo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wzelo men rderëz men, re men: ―¡Kesentyent non xerrey men-Israel! ");
INSERT INTO zpi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Lex rkyits men tebla bëg xtoo Ne, rtxonxen men led Ne, no rzuzhib men lo Ne, rlaa men zeg rlaa men ne rzaknon Ne. ");
INSERT INTO zpi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chene wluzh wlaa men Ne zenga, wboo ke men lërnloren guin led Ne, lex wnegak ke men Ne xab Ne. Zhich guin zano men Ne chen ykaa men Ne lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nëz wtsëlo men te men-Cirene ne la Simon, xuz Lej nak men yrup Lej Rufo; den wberee mén guin, lex wkyenfwers men men weey men xekruz Jesus. ");
INSERT INTO zpi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wano men Ne ledne la Gólgota. (Gólgota rna, Berxtoo Mengut.) ");
INSERT INTO zpi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Lex wdee men bin ne noots ne la mirra goo Ne, per woodet No. ");
INSERT INTO zpi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Zhich guin wkaa soldad Ne lo kruz. Lex wa soldad pwest kon xab Ne gan gonezhe yganen men te te men. ");
INSERT INTO zpi_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Beygaa rsil or guin ne wkaa men Ne lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lex wkaa men leter xtoo xekruz Ne gan pe kwentzhe ka Ne nga, re leter guin: “Laa xerrey men-Israel nee.” ");
INSERT INTO zpi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","No wkaa men txup ngbaan lo kruz, te men wkaa lo kruz ne zob koo Ne ladbëë, le ste men wkaa lo kruz ne zob koo Ne ladbëg. ");
INSERT INTO zpi_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Zenga wak kumplir diiz ne zëëd lo xgyiich Dëdyuzh ledne re: “Wun mén men kwent lad menmal.” ");
INSERT INTO zpi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yrandxee mén ne rdee nga, rdxii xtoo men, rninyaan men lo Ne, re men: ―Laa de nga nlitla xeydoo Dëdyuzh no tsonegue gbiz nlep ke do ste, ");
INSERT INTO zpi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","orrenaa guselaa de laake de. Gugyët lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Zenga ke rzhidxno yra fxuz ne rnebééy lo yra fxuz Ne yra men maxter ley, re men: ―Wselaa ménree ste mén, per rundet men gan yselaa men men laake men. ");
INSERT INTO zpi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Belne laa men nak Crist xerrey men-Israel, gyët men lo kruz naa chen ylaleedx be men. Axtegue no men ne ka lo kruz ne zob koo Ne wninyaan lo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Or ne rwen ngbiz, waknkeb ydendxee gyëzlyu, axtegue beytson wzëë wyenii ste. ");
INSERT INTO zpi_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Orke guin wkarëzyaa Jesus, re Ne: ―Eloi, Eloi, ¿lama sabactani? ―Diizree rna: Dëdyuzhe, Dëdyuzhe, ¿penak wboleedx de noo? ");
INSERT INTO zpi_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Gwrol men ne ndxin nga, ne won men wkarëz Ne, re men: ―Gugon, profet-Elías rkarëz men. ");
INSERT INTO zpi_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Orgueguin noze rzhoon te ke men ne zu nga, wa men wagaz men tebla zhiil kon binaguer; lex wzoob meno xtoo te bëg, wtee meno ruu Jesus chen goo Ne binaguer, lex re men: ―Zeka men, gan pe schiid Elías chiidlit men lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lex wkarëzyaa Jesus ste, wetgue Ne. ");
INSERT INTO zpi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Orguin wrëznzeli kortin ne ka lenxeydoo Dëdyuzh, gwrooltee wako. ");
INSERT INTO zpi_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ne wii kapitan ne zu ngali lo Jesus ne wet Jesus, re men: ―Nli ne XPee Dëdyuzh nak ménree. ");
INSERT INTO zpi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","No ndxin ke tebëd wnaa axtegue nat, rwii men yra neguin ne kayak. Lad yra wnaa guin zu Mli Matlen no zu Salme no le Mli ne nak xnaa Xeb no ne nak ke xnaa Jacob ne windee. ");
INSERT INTO zpi_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yra wnaaree nak ne wrunal Jesus, laa men wun xyudar Ne chene ka Ne lo lyu ne la Galilea; no ndalre wnaa ne wdxinnal Ne Jerusalén zu nga. ");
INSERT INTO zpi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kom dxe guin nak dxe bisper pask no dxe guin nulyaaz men ne ykyiinen men dxe ne rne men-Israel, por neguin or ne che rzëë, ");
INSERT INTO zpi_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","wa te mgyeey ne la Xeb lo Pilato. Axtegue wdxedet men wbig men wnab men xkwerp Jesus lo Pilato. Men-Arimatea nak mgyeey guin no men nak te mennon lad xtis-Israel no kambë́z men ne gak ne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wzee wzak Pilato ne won Pilato ne che wet Jesus. Lex wbëz Pilato kapitan, wnabdiiz Pilato lo men gan pe nli ne che wet Jesus. ");
INSERT INTO zpi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chene re kapitan nli we, wdee Pilato si walit Xeb Ne lo kruz. ");
INSERT INTO zpi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Orguin wka Xeb te saben, lex wlit Xeb Ne, wtxël Xeb Ne saben guin, lex walu Xeb Ne te lenbaa ne ndeen txugye. Lex wtsëë Xeb rubaa guin kon te gye. ");
INSERT INTO zpi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Wii Mli Matlen yra men Mli xnaa Xeb gan pazh wguu men Ne. ");
INSERT INTO zpi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ne wdesu dxe ne rne men-Israel, wka Mli Matlen perfum yra men Salme no le Mli xnaa Jacob, chen tsalu meno led Jesus. ");
INSERT INTO zpi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Lex dxe ne rzelo xman, or ne le ngbiz zalen, wa men rubaa yra men. ");
INSERT INTO zpi_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Rulsaa men diiz, re men: ―¿Txuzhleg ygyitxee gye ne zemzëë rubaa? ");
INSERT INTO zpi_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per chene wii men, le gye ne zemzëë rubaa che zu tebkoo, no kesentyent nzhoo gye guin. ");
INSERT INTO zpi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chene wdee men lenbaa, wii men te mgyeymenyu zob ladbëë. Nak mgyeey guin te lërngyich ne ngool. Wdxe yra wnaa guin. ");
INSERT INTO zpi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Per re mgyeey guin lo men: ―Ydxedet de. Che nan noo ne Jesus men-Nazaret rye de, men ne wkaa lo kruz. Yëtre men nee; le men che wban. Gukwii ledne wguu mén men gante. ");
INSERT INTO zpi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Per gutsa gue de lo yra xpén men no le lo Bëd ne nak ke xpén men ne le men sanergue lo yra xpén men tsa men Galilea; nga kwii men men zegne che na men lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Orguin noze rzhoon yra wnaa guin, wruu men rubaa. Noze rzhiz men, tant rdxe men. No rut lo bet redet men, por tant rdxe men. ");
INSERT INTO zpi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dxe ne rzelo xman, rsil ne wban Jesus, lo Mli Matlen ne wboo Ne guedx menzab lextoo nak ne primer wlalo Ne. ");
INSERT INTO zpi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Lex laa Mli Matlen waluu diiz lo yra men ne wkaa yra Ne. Chene wdxiin Mli Matlen, le yra mén guin ndxinyoon por tant nles nuu lextoo men. ");
INSERT INTO zpi_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ne won yra men guin ne mbán Jesus no ne wii Mli Matlen Ne, wlaleedxdet meno. ");
INSERT INTO zpi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Zhich guin wlalo Jesus lo txup xpén Ne ne za men den, per wrenlel wlalo Ne lo men. ");
INSERT INTO zpi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lex wa men yrup men wa gue meno lo stebëd xpén Ne, per ni laa yra men guin wlaleedxdet ne re yrup men guin. ");
INSERT INTO zpi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Zhich guin wlalo Jesus lo yra chibteb xpén Ne chene zob men lo mezh; wakndux Ne lo men yra men por ne wlaleedxdet men ne che re Ne lo men no por ne ndíp lextoo men porke wlaleedxdet men yra mén ne wii Ne chene che wban Ne. ");
INSERT INTO zpi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Lex re Ne lo men: ―Gutsa ydendxee gyëzlyu, yzëët de xdiznzoon Dëdyuzh lo yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Men ne ylaleedxo, lex yrobnis men, men guin nak ne yláá lo dol; per le men ne ylaleedxdeto, men guin nak ne sakzi. ");
INSERT INTO zpi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Men ne ylaleedx noo yra neree ylaa men: Por la noo koo men menzab lextoo mén; no ynii men ste klas diiz ne axtegue nandet men; ");
INSERT INTO zpi_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","gob men mëël kon nya men; belne goo men ne nuu ngwaan, bet sakdet men; yxob nya men led mengyiz, no syaken mengyiz. Yra beeyree ylaa yra men ne ylaleedx noo. ");
INSERT INTO zpi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chene wluzh wnii Jesus lo yra xpén Ne, wyas Ne sya Ne gyeybaa, wzob Ne koo Dëdyuzh ladbëë. ");
INSERT INTO zpi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Zhich guin wruu men yra men, wa men yrandxee lugar, wazëët men xdiznzoon Dëdyuzh. Laa Jesucrist waknonen men ne wlaa men gyelmilaguer chen gyakbeey ne nli xdiiz Dëdyuzh rzëët men. Zengaw.");
INSERT INTO zpi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ndal mén wkaa wkakaa yra ne wak lad be; ");
INSERT INTO zpi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","wkaa meno zegne wneluu wneluundxee yra mén ne wii yra ne wlaa Jesus axtegue ne wzelo Ne no laa men wtxëëts diizo. ");
INSERT INTO zpi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","No ke noo wkaa wkanabdiiz wen wenendxee yra ne wlaa Ne axtegue ne wzelo Ne. Por neguin ryenen noo ne wen ykaa noo we xnëz xnëzendxee por laa de Teofil ne nak de zhannon, ");
INSERT INTO zpi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","chen gaknanwen de diznli ne wneluu men lo de. ");
INSERT INTO zpi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chene wak Herodes rrey lyu ne la Judea, wuu te fxuz ne la Zacari ne nuu lad tebëd fxuz ne la Abías; le lzaa Zacari la Elisabet, xnëz fxuz-Aarón zëëd Elisabet. ");
INSERT INTO zpi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Xnëz wbán Zacari yrup lzaa Zacari nes lo Dëdyuzh no wlaa men yra ne rkyeen Ne no yra ne rnebééy Ne. Rut gundet gan pe gue por laa men. ");
INSERT INTO zpi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Per yëten men mëëd porke nuudet gap Elisabet mëëd no che kesentyent gol men yrup men. ");
INSERT INTO zpi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dxe ne ryal ylaa xegrup fxuz-Zacari dxiin por Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","wlaa men zegnak xkoxtumber men yra sefxuz men, gan txuzh yganen tee guu guux ne nzoon rree lenxeydoo Dëdyuzh. Laatee Zacari wganeno. ");
INSERT INTO zpi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Or ne le Zacari kaguu guux guin lenydoo, le yrandxee mén ndxin fwer kanab lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Orguin wlalo te xangel Dëdyuzh lo Zacari; zu ne koo fkuuk ladbëë, ledne ruu guux ne nzoon rree. ");
INSERT INTO zpi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ne wii Zacari angel guin, axtegue nandet men pe nlaa men, tant wdxe men. ");
INSERT INTO zpi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lex re angel guin lo men: ―Zacari, ydxedet de, porke le ne rnab de che won Dëdyuzh; naaree gap Elisabet xewnaa de te mëdbee, ynesela de ne Xwa. ");
INSERT INTO zpi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kesentyent sak lextoo de no szhiilen de chene gal ne, no ndal ke mén yzhiilen, ");
INSERT INTO zpi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","porke te zhannon gak xpee de lo Dëdyuzh. Goodet zhaa bin, ni betlel nisndux goodet zhaa, no axtegue antes ne gal zhaa, che kesentyent raknonen Espíritu Sant zhaa. ");
INSERT INTO zpi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Laa zhaa ylaa ne kesentyent ndal men-Israel yberee lo XDëdyuzh men-Israel. ");
INSERT INTO zpi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","No laa zhaa chidner lo Zhan ne rnebééy ne chiid. Gap zhaa xpoder Elías no le xespíritu Elías, chen ynegyakchi zhaa xdil ngwzan yra ngwzan zhiin ngwzan no chen yseed yra mén ne ntoz gon men diiz. Zenga ylaxnëz zhaa mén chen tsukas mén Zhan ne rnebééy ne chiid. ");
INSERT INTO zpi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Orguin re Zacari lo angel guin: ―¿Pezee gaknan noo ne nli negwa ne na de? Si che kesentyent gol noo yrup noo xewnaa noo. ");
INSERT INTO zpi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Wke angel guin, re ne: ―Noo nak Gabriel, xdxiin Dëdyuzh kalaa noo; laa Ne wxaal noo ne ynii noo lo de no ne yzëët noo dizwenree lo de. ");
INSERT INTO zpi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per kom wlaleedxdet de noo, orree gyanengup de, gakdet ynii de axtegue ne ydxiin dxe ne gak neree ne na noo lo de. ");
INSERT INTO zpi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Le yra mén ndxin fwer ndxinmbë́z men Zacari, rzee rzak men gan penak rruudetlel Zacari lenydoo. ");
INSERT INTO zpi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Chene le Zacari wruu, wakdetre nnii Zacari lo men. Orguin wyenen men ne nuu ne wlalo lo Zacari lenydoo. Noze senye rluu Zacari lo men, porke wyanengup Zacari. ");
INSERT INTO zpi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Chene wzaa dxe ne zu Zacari ruydoo, sya Zacari ruxyuu Zacari. ");
INSERT INTO zpi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Zhich guin wakzhiin Elisabet xewnaa Zacari. Gaay mëëw axtegue wruudet men xyuu men, nuu lextoo men: ");
INSERT INTO zpi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Wseleedx Dëdyuzh mëëdree lo noo chen koodetre mén xeblaan noo.” ");
INSERT INTO zpi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Chene wluzh xuup mëëw, wxaal Dëdyuzh angel-Gabriel te gyëz ne la Nazaret ne nak lo lyu ne la Galilea; ");
INSERT INTO zpi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","wa ne lo te nzeb-benak ne la Mli. Che nuu nzeb ne ytsëlnya nzeb yrup nzeb te mgyeey ne la Xeb ne zëëd xnëz rrey-David. ");
INSERT INTO zpi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Zegne wdee angel guin ledne nuu nzeb, re ne lo nzeb: ―¡Payuz, Mli! Dëdyuzh wlanon de; laa Ne raknonen de; laa Ne wneleey de delo lo yrandxee wnaa. ");
INSERT INTO zpi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Per chene wii nzeb angel guin, wzee wzak nzeb por diiz guin, nuu lextoo nzeb pe rnaleg diizree. ");
INSERT INTO zpi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Lex re angel guin lo nzeb: ―Mli, ydxedet de, porke laa Dëdyuzh raknonen de. ");
INSERT INTO zpi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Orrenaa gakzhiin de; gap de te mëdbee, ynesela de ne JESUS. ");
INSERT INTO zpi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kesentyent gaknon ne; XPee Dëdyuzhnzoon ynii mén ne; laa Dëdyuzhnzoon ylaa ne rrey zeg wak David ne nak xpenkwlal ne rrey, ");
INSERT INTO zpi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","chen laalel ne ynebééy lo yrandxee men-Israel, no nunk gyaldet ynebééy ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Lex re nzeb lo angel guin: ―¿Pezee gak negwa ne na de, si ni te mgyeey gardet tsuno noo? ");
INSERT INTO zpi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wke angel re angel: ―Por Espíritu Sant gako; chiid xpoder Dëdyuzhnzoon ysakblaa we led de; por neguin mëdsant gwa ne gap de, XPee Dëdyuzhnzoon ynii mén ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","No Elisabet xparyent de gap te mëdbee mase che gol men, men ne nan mén ne nuudet gap mëëd, per naaree wzaa xuup mëëw nakzhiin men. ");
INSERT INTO zpi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Porke por Dëdyuzh yët ne gakdet gan gak. ");
INSERT INTO zpi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Lex re nzeb: ―Dëdyuzh rnebééy lo noo; ylaa Ne noo zegne na de. Wluzhse re nzeb diizree, syague angel guin. ");
INSERT INTO zpi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Zhichegue wako, zague nzeb te gyëz ne nak nes gyeey lo lyu ne la Judea; ");
INSERT INTO zpi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ne wdxiin nzeb, wdee nzeb lenxyuu Zacari, wgabtyuzh nzeb Elisabet. ");
INSERT INTO zpi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chene won Elisabet diztyuzh guin, watxegya mëëd lextoo Elisabet, no kesentyent waknonen Espíritu Sant men. ");
INSERT INTO zpi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Orguin ndípse wnii men, re men lo nzeb: ―Dëdyuzh wneleey de delo lo yrandxee wnaa, no wneleey Ne mëëd gwa ne zuneey de. ");
INSERT INTO zpi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Txu nak noo ne zëëd xnaa Men ne rnebééy zëdwii men lo noo? ");
INSERT INTO zpi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Porke zegne won noo xdiztyuzh de, watxegya xpëëd noo lextoo noo por gyelgwzhiil. ");
INSERT INTO zpi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nzoon de ne wlaleedx de ne na Dëdyuzh lo de, porke zako. ");
INSERT INTO zpi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Lex re nzeb: Ydeblextoo noo rzaknon noo Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","no rzhiilen lextoo noo ne wselaa Ne noo lo dol. ");
INSERT INTO zpi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Porke wkalo Ne noo, mase rut nakdet noo, noze te mén ne rlaa xdxiin Ne nak noo. Desde orree yrandxee mén ne nuu naaree, nigle mén ne gyed tsuur, ynii men noo men nzoon. ");
INSERT INTO zpi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porke nzoon yra ne wlaa Dëdyuzhnzoon noo; sant nak la Ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Syemper rles lextoo Ne yrandxee mén ne rlaa ne rkyeen Ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ndal ne wlaa Ne kon xpoder Ne; wluzh Ne ne rlebleedx yra mén ne nugya lextoo. ");
INSERT INTO zpi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wgyitxee Ne poder lo mén ne zob rnebééy, le mén ne rut nakdet wlagya Ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wseleedx Ne gyelenzaak lo mén ne yët ne gu, le menrik wsan Ne nonchee zenga. ");
INSERT INTO zpi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nunk wnitleedxdet Ne ne gun Ne xyudar yra men-Israel ne nak xpén Ne, syemper wles lextoo Ne men, ");
INSERT INTO zpi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","zegne re Ne lo yra xpenkwlal be, lo Abraham no le lo yra men ne zëëd xnëz men. ");
INSERT INTO zpi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nga wkaa nzeb ruxyuu Elisabet zeg tson mëëw, zhich guin wberee ke nzeb ruxyuu nzeb. ");
INSERT INTO zpi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chene wdxiin dxe ne le xpëëd Elisabet wal, wap Elisabet te mëdbee. ");
INSERT INTO zpi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","No chene waknan yra mén ne nuu guex ruxyuu Elisabet no le yra xparyent Elisabet ne wles lextoo Dëdyuzh Elisabet, kesentyent wzhiilen men; wa men gyelgabtyuzh lo Elisabet. ");
INSERT INTO zpi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ne wluzh mëëd guin xun gbiz, waneey men ne wuu ne beey ne ruu men-Israel, lex wlaan mén nnesela mén ne Zacari zegne la ke xuz ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Per re xnaa ne: ―Seladet ne zegwa, Xwa sela ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Lex re men: ―¿Penak sela ne Xwa, si ni te xparyent de ladet Xwa? ");
INSERT INTO zpi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lex wnabdiiz men lo xuz ne kon senye, chen gaknan men pezee rlaan xuz ne sela ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Orguin wnab xuz ne tebla tabel, lex wkaa men lo tabel guin: “Xwa sela ne.” Wzee wzak yrandxee mén guin. ");
INSERT INTO zpi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Orgueguin wberee wnii Zacari ste, lex wzelo men wdee men dexkyizhtee lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yrandxee mén ne nuu guex ruxyuu men wzee wzak, no yrandxee gyëz ne nak nes gyeey lo lyu ne la Judea ruu mén diiz neguin ne wak. ");
INSERT INTO zpi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yra mén ne wono, nuu we lextoo men, lex re men: ―¿Txu gakleg mëëd gwa? Porke nlipee ne Dëdyuzh raknonen ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kesentyent waknonen Espíritu Sant Zacari xuz mëëd guin; wzëët men yra diiz ne wguu Dëdyuzh lextoo men, re men: ");
INSERT INTO zpi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Dexkyizhtee Dëdyuzh ne rnebééy lo men-Israel, porke zëdselaa Ne be yra be ne nak be xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Lad men ne zëëd xnëz David ne nak xpén Ne, wseleedx Ne te mén ne rap poder ne yselaa be. ");
INSERT INTO zpi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Zegne re Ne axtegue chekwlal ne wzëët yra men ne nak xprofet Ne, ");
INSERT INTO zpi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ne selaa Ne be lo yra mén ne rlayaa lo be no le lo mén ne rlaandet kwii be, ");
INSERT INTO zpi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","no ne sles lextoo Ne yra xpenkwlal be, no ne nitleedxdet Ne ne che re Ne ne ylaa Ne. ");
INSERT INTO zpi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Laa we nga re Ne lo Abraham xpenkwlal be: ");
INSERT INTO zpi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ne selaa Ne be lo yra mén ne rlaandet kwii be, chen betre ydxedet be ylaa be xdxiin Ne, ");
INSERT INTO zpi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","no xnëz gak be lo Ne, wen ybán be ydeblo ne ybán be. ");
INSERT INTO zpi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Le laa de zhiin, xprofet Dëdyuzhnzoon ynii mén de, porke laa de saner ylaxnëz xnëz Men ne rnebééy, ");
INSERT INTO zpi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","chen ylaa de ne gaknan xpén Ne pezee yláá men lo dol, chen gak perdon xdol men. ");
INSERT INTO zpi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Por ne kesentyent ryaan XDëdyuzh be be no por ne rles lextoo Ne be, neguin wxaal Ne XPee Ne gak bnii por laa be, ");
INSERT INTO zpi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","chen yzenii Ne lo mén ne nuu lo nkeb, men ne che nuu por guet no chen yneluu Ne be gakndxi be. ");
INSERT INTO zpi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Le mëëd guin zayaknzhoo no zayakfwert xespíritu ne; denbidx wuu ne axtegue ne wdxiin dxe ne wzelo wzëët ne xdiiz Dëdyuzh lo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Cheguin ke wkyeen rrey-Augusto wdop la mén ne nuu ydendxee gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Laa ne primer wdop la mén nga, chene nak Cirenio gobernador Siria, cheguin wdopo. ");
INSERT INTO zpi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yrandxee mén rap men degne tsa men laz men chen ykagyiich la men. ");
INSERT INTO zpi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Por neguin wruu Xeb Nazaret ne nak lo lyu ne la Galilea, wa men Belén gyëz ne nak lo lyu ne la Judea ledne wal rrey-David, porke xnëz rrey-David zëëd men. ");
INSERT INTO zpi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wa men nga yrup men Mli chen ykagyiich la men; che nuu men ne ytsëlnya men no nakzhiin Mli. ");
INSERT INTO zpi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nga ka men chene wdxiin dxe ne gap xpëëd Mli. ");
INSERT INTO zpi_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nga wap xpëëd Mli mëdprimer, lex wtxël men ne lër, wgyix men ne ledne ruu ne ru maa, porke wzëldetre yuu nbë́z men. ");
INSERT INTO zpi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Guex Belén ka tebëd mén den; nga rzëën men rapkwent xpëkzhiil men gyëël. ");
INSERT INTO zpi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tebegue wlalo te xangel Dëdyuzh lo men, lex wkaa xebtsa Dëdyuzh kbii ledne ndxin men; kesentyent wdxe men. ");
INSERT INTO zpi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Per re angel guin lo men: ―Ydxedet de, porke te dizwen zëdzëët noo lo de, diizree kesentyent ynexiileno yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Laz rrey-David wal te mëëd negyëëlree; laa ne yselaa yrandxee mén lo dol; laa ne nga nak CRIST ne rnebééy. ");
INSERT INTO zpi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Por ne ynebeey de ne: Tsël ne lo de nrël ne lër, nex ne ledne ruu ne ru maa. ");
INSERT INTO zpi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tebegue wlalo ndal xangel Dëdyuzh koo angel guin; rzaknon ne Dëdyuzh, re ne: ");
INSERT INTO zpi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Nzoon Dëdyuzh axtegue gyeybaa, no zuu gyelendxi gyëzlyu lad yra mén ne rlaa ne rlaan Ne! ");
INSERT INTO zpi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chene le yra angel guin sya gyeybaa, wzelo mén guin ne rapkwent mëkzhiil rulsaa men diiz, re men: ―Yoo tsa be Belén kwii be negwa ne wak ne wzëët Dëdyuzh lo be. ");
INSERT INTO zpi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Orguin noze ryob rdxiintee za men, wzël Mli lo men yrup Mli Xeb no le mëëd guin, nex ne ledne ruu ne ru maa. ");
INSERT INTO zpi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chene wii men ne, wuu men yra xdiiz ne ne re angel guin lo men. ");
INSERT INTO zpi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yra mén ne won ne re mén guin, kesentyent wzee wzak men. ");
INSERT INTO zpi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Per le Mli noze lextoo men wuu yra diiz guin no kanzaleedx meno. ");
INSERT INTO zpi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lex wberee ke yra mén guin ne rapkwent mëkzhiil, kesentyent rzaknzoon men Dëdyuzh, rdee men dexkyizhtee lo Ne por yra ne won men no por yra ne wii men, porke wak zegne re angel lo men. ");
INSERT INTO zpi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chene wluzh mëëd guin xun gbiz, wguu men ne beey ne ruu men-Israel no wnesela men ne JESUS zegne re angel lo Mli antes ne gakzhiin Mli. ");
INSERT INTO zpi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chene wzaa dxe ne rap Mli degne tsa Mli gakndaa Mli zegne zëëd lo ley ne wdee Dëdyuzh lo Moises, wano men mëëd guin nes lo Dëdyuzh lenydo-Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Wlaa men neree, porke re lo xley Dëdyuzh: “Yrandxee mëdbee ne ral primer, por Dëdyuzh nak ne.” ");
INSERT INTO zpi_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Lex wa men waron xgoon men zegne re lo xley Dëdyuzh: tsasan men txup ngug o txup mëër. ");
INSERT INTO zpi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Cheguin ke wuu te mén ne la Simeon gyëz-Jerusalén. Xnëz wbán men, kesentyent wzaknon men Dëdyuzh; kambë́z men kwii men men ne yselaa men-Israel lo dol. Laa Espíritu Sant raknonen men, ");
INSERT INTO zpi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","por laa Ne waknan men ne guetetgue men axtegue ne kwii men XeCrist Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Laa Espíritu Sant wguu lextoo men ne wa men lenxeydoo Dëdyuzh chene wano ke xegwzan Jesus Jesus lenydoo chen ylaa xegwzan Jesus zegne zëëd lo ley. ");
INSERT INTO zpi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Lex wnëëz Simeon ne, wlen men ne, wzelo men rdee men dexkyizhtee lo Dëdyuzh, re men: ");
INSERT INTO zpi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dëde, orree si betre tsadet lextoo noo, che zak ydee de si guet noo, porke che wlaa de ne na de lo noo ne nak noo men ne rlaa xdxiin de. ");
INSERT INTO zpi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Porke le noo che wii zhan ne yselaa mén lo dol, ");
INSERT INTO zpi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","zhan ne wxaal de lo yrandxee mén ne nuu ydendxee gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Laa zhaa nak bnii ne yzenii lo yrandxee mén ne nakdet men-Israel, no laa zhaa nak gyelenzoon por men-Israel ne nak xpén de. ");
INSERT INTO zpi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wzee wzak Xeb yrup Xeb xnaa Jesus por yra ne re Simeon por laa ne. ");
INSERT INTO zpi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lex wsan Simeon men ledxnya Dëdyuzh yra men mëëd guin, re Simeon lo Mli xnaa ne: ―Mëëdree che nunla ne ne ndal men-Israel ylaleedxdet ne, per ndal ke men ylaleedx ne. Zëëd ne zëdzëët ne ne rlaan Dëdyuzh, per ndal mén ylaandet ne yzëët ne. ");
INSERT INTO zpi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Zenga gyakbeey pezee rlebleedx te te mén. Per le laa de sak de zegnak chene raaz te spad lextoo mén chene le yra neree gak. ");
INSERT INTO zpi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nga lenydoo guin zu te wnaa ne che kesentyent gol ne nak profet. Ana la men, xsaap Fanuel nak men, xnëz Aser zëëd men. Menyundxee men chene wtsëlnya men; guedxegue iz wbán men yrup men xemgyeey men. ");
INSERT INTO zpi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Che wzaa taplalno-tap iz wet xemgyeey men, no axtegue rruudet men lenydoo, dxe gyëëltee rnab men lo Dëdyuzh, rkwan men rudet men. ");
INSERT INTO zpi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Laatee orguin wbig men wdee men dexkyizhtee lo Dëdyuzh. Wluzh nga wzelo men wzëët men xkwent mëëd guin lo yra mén ne kambë́z ne yláá men-Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Chene wluzhse wlaa Xeb yrup Xeb Mli yra ne zëëd lo xley Dëdyuzh, wberee ke men Nazaret ne nak laz men no ne nak lo lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Le mëëd guin zayaknzhoo no zayakngyedx ne no zayur xgyeryen ne, no kesentyent raknonen Dëdyuzh ne. ");
INSERT INTO zpi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yrandxee iz ra xegwzan Jesus Jerusalén chene rak lni pask. ");
INSERT INTO zpi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chene wluzh Jesus chibtxup iz, wano men Ne lni pask zegnak xkoxtumber men. ");
INSERT INTO zpi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ne wdee lni ne wberee men, wyenden men wyan Jesus Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nuu lextoo men pazer lad mén nga sya Ne, wzaa men tebdxe, per chene wye men Ne lad men ne nak xparyent men no lad men ne rnebeey men, ");
INSERT INTO zpi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","wzëldet Ne. Lex wberee men wa men Jerusalén ste waye men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ne wyon gbiz, le Ne wzël lenxeydoo Dëdyuzh; zob Ne lad maxter ley rkagyedyag Ne yra ne rnii men, lex rnabdiiz Ne lo men. ");
INSERT INTO zpi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yrandxee mén ne ron ne rnii Ne, rzee rzak men por yra ne rke Ne no ne kesentyent nal xgyeryen Ne. ");
INSERT INTO zpi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chene wii Xeb Ne yrup Xeb Mli xnaa Ne, wzee wzak men, lex re xnaa Ne lo Ne: ―Zhiina, ¿penak rlaa de zegwa? Le noo yrup noo xuz de ka kaye de, axtegue nandet noo pe nuu lextoo noo. ");
INSERT INTO zpi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wke Jesus, re Ne: ―¿Penak rye de noo? ¿Pe nandet de ne rap noo degne ylaa noo xdxiin Xuz noo? ");
INSERT INTO zpi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per wdeedet men kwent gan pe rna ne re Ne zenga. ");
INSERT INTO zpi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lex wberenal ke Ne men Nazaret. Yrandxee xdiiz men ron Ne. Per noze wguu xnaa Ne yra neree lextoo men. ");
INSERT INTO zpi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Le Jesus zayaknzhoo no zayur xgyeryen Ne, no rzhiilen Dëdyuzh Ne no rzhiilen ke mén Ne. ");
INSERT INTO zpi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ne wak chíín iz ne rnebééy rrey-Tiberio, laa Poncio Pilato nak gobernador Judea, le Herodes rnebééy lo lyu ne la Galilea, le bech Herodes Blib rnebééy lo lyu ne la Iturea no le lo lyu ne la Traconite, le Lisanias rnebééy lo lyu ne la Abilinia. ");
INSERT INTO zpi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás no le Caifás nak fxuz ne mazre nondee. Cheguin ke wnii Dëdyuzh lo Xwa xpee Zacari denbidx. ");
INSERT INTO zpi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Lex wa Xwa yra gyëz ne nak guex rugyow-Jordán, re Xwa lo mén ne yrobnis men no ysaan men xgyelmal men chen gun Dëdyuzh perdon xdol men. ");
INSERT INTO zpi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Zeree wak kumplir diiz ne wkaa profet-Isaías ledne re: Te rëz rlen denbidx, re we: “Gulaxnëz xnëz Men ne rnebééy, guxal te nëz ne tebli. ");
INSERT INTO zpi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yrandxee ledne nugyët, gyezaa we; yrandxee gyeey no le yrandxee bles, gakleecho. Nëz ne nyeky, gaktebli we. Nëz ne gya gyëttee, gaktebli we. ");
INSERT INTO zpi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","No yrandxee mengyëzlyu kwii mén ne yxaal Dëdyuzh ne yselaa mén.” ");
INSERT INTO zpi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chene ra mén lo Xwa ne ytxobnis Xwa men, nan Xwa lo men: ―¡Xerras mëël! ¿Txu na lo de ne yláá de lo gyelentozroo ne zëdyob? ");
INSERT INTO zpi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xnëz gugak chen gaknyoo ne nli che wsaan de xgyelmal de, no guedet de lo xkompanyer de: “Xnëz Abraham zëëd be”; porke yna noo lo de yra de ne axtegue gyeree zun Dëdyuzh gan ylaa Dëdyuzho men ne zëëd xnëz Abraham. ");
INSERT INTO zpi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Che list zu gyibyag ne txuug axtegue ydeblu yag; yrandxee yag ne rkaadet nexwen lo, txuugo, tsa we lo gyi. ");
INSERT INTO zpi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lex wnabdiiz mén lo Xwa, re men: ―¿Pagox rap noo degne ylaa noo? ");
INSERT INTO zpi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wke Xwa, re Xwa: ―Men ne rap txup lërmank, rap men degne ydee men tebo lo men ne yëteno; men ne rap ne ru, rap men degne ydee men tebëdo lo men ne yëteno. ");
INSERT INTO zpi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","No tebëd men ne rgoob zeg impwest wa lo Xwa ne ytxobnis Xwa men, lex wnabdiiz men lo Xwa, re men: ―Maxter, ¿noo naa, pagox rap noo degne ylaa noo? ");
INSERT INTO zpi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Lex re Xwa lo men: ―Gobdet de mazre nzhoodee ke ne rap de degne gob de. ");
INSERT INTO zpi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","No le tebëd soldad wnabdiiz lo Xwa, re men: ―¿Noo naa, pagox rap noo degne ylaa noo? Wke Xwa, re Xwa: ―Ynechedet de mén por ne gak ygyitxee de logne nak xen men, ni ykagyiidet de mén logne wlaadet men, no gugyan byen logne rezh rka de. ");
INSERT INTO zpi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Noze kambë́z yra mén guin, nuu lextoo men pazer laa Xwa nak Crist. ");
INSERT INTO zpi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Per re Xwa lo men yra men: ―Noo noze kon nis rtxobnis noo de, per che zëëd te men ne ytxobnis kon Espíritu Sant no le kon gyi. Axtegue ni xgyël men rzëëldet noo ychil noo nii men porke mazre rapdee men poder ke lo noo. ");
INSERT INTO zpi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","No nzen men ne ylanya men zhobxtil, koo men zhobxtil lad xgyizho, lex gutsoow meno; le xgyizho tsa lo gyi ne nunk gyuudet. ");
INSERT INTO zpi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zeree re Xwa lo mén no ndalre diiz ne wnino Xwa men, wzëët Xwa xdiznzoon Dëdyuzh lo men. ");
INSERT INTO zpi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","No wakndux Xwa lo rrey-Herodes por ne nuu Herodes yrup Herodes Herodías xewnaa Blib bech Herodes no por yra ne mal ne wlar Herodes. ");
INSERT INTO zpi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Per lel mazre wlaa Herodes, wnëëz Herodes Xwa, wguu Herodes Xwa chegyiib. ");
INSERT INTO zpi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Chene katxobnis Xwa mén, no Jesus wa wrobnis lo Xwa. Or ne kanab Ne lo Dëdyuzh, wyal gyeybaa, ");
INSERT INTO zpi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","wyët Espíritu Sant zegnak te mëër, wyab Ne led Jesus, no wlen te rëz gyeybaa, re we: ―Laa de nak XPee noo ne ryaan noo; kesentyent rnesak de lextoo noo. ");
INSERT INTO zpi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Zeg galebchii iz rap Jesus chene wzelo Ne wlaa Ne xdxiin Ne. Jesus ne nuu lextoo mén nak zhiin Xeb xpee Elí, ");
INSERT INTO zpi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí nak zhiin Matat, Matat nak zhiin Leví, Leví nak zhiin Melqui, Melqui nak zhiin Jana, Jana nak zhiin Xeb, ");
INSERT INTO zpi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Xeb nak zhiin Matatías, Matatías nak zhiin Amós, Amós nak zhiin Nahum, Nahum nak zhiin Esli, Esli nak zhiin Nagai, ");
INSERT INTO zpi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nak zhiin Maat, Maat nak zhiin Matatías, Matatías nak zhiin Semei, Semei nak zhiin Xeb, Xeb nak zhiin Judá, ");
INSERT INTO zpi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá nak zhiin Joanán, Joanán nak zhiin Resa, Resa nak zhiin Zorobabel, Zorobabel nak zhiin Salatiel, Salatiel nak zhiin Neri, ");
INSERT INTO zpi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri nak zhiin Melqui, Melqui nak zhiin Adi, Adi nak zhiin Cosam, Cosam nak zhiin Elmodam, Elmodam nak zhiin Er, ");
INSERT INTO zpi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nak zhiin Josué, Josué nak zhiin Eliezer, Eliezer nak zhiin Jorim, Jorim nak zhiin Matat, ");
INSERT INTO zpi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat nak zhiin Leví, Leví nak zhiin Simeon, Simeon nak zhiin Judá, Judá nak zhiin Xeb, Xeb nak zhiin Jonán, Jonán nak zhiin Eliaquim, ");
INSERT INTO zpi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim nak zhiin Melea, Melea nak zhiin Mainán, Mainán nak zhiin Matata, Matata nak zhiin Natán, ");
INSERT INTO zpi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán nak zhiin David, David nak zhiin Isaí, Isaí nak zhiin Obed, Obed nak zhiin Booz, Booz nak zhiin Salmón, Salmón nak zhiin Naasón, ");
INSERT INTO zpi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón nak zhiin Aminadab, Aminadab nak zhiin Aram, Aram nak zhiin Esrom, Esrom nak zhiin Fares, Fares nak zhiin Judá, ");
INSERT INTO zpi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá nak zhiin Jacob, Jacob nak zhiin Isaac, Isaac nak zhiin Abraham, Abraham nak zhiin Taré, Taré nak zhiin Nacor, ");
INSERT INTO zpi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor nak zhiin Serug, Serug nak zhiin Ragau, Ragau nak zhiin Peleg, Peleg nak zhiin Heber, Heber nak zhiin Sala, ");
INSERT INTO zpi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala nak zhiin Cainán, Cainán nak zhiin Arfaxad, Arfaxad nak zhiin Sem, Sem nak zhiin Noé, Noé nak zhiin Lamec, ");
INSERT INTO zpi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec nak zhiin Matusalén, Matusalén nak zhiin Enoc, Enoc nak zhiin Jared, Jared nak zhiin Mahalaleel, Mahalaleel nak zhiin Cainán, ");
INSERT INTO zpi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán nak zhiin Enós, Enós nak zhiin Set, Set nak zhiin Adán, Adán nak zhiin Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kesentyent waknonen Espíritu Sant Jesus, lex wano Espíritu Sant Ne denbidx or ne wberee Ne ne wa Ne rugyow-Jordán. ");
INSERT INTO zpi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Txuplal gbiz wkaa Ne denbidx, lex wlaa Bzelo Ne preb gan pe slaa Ne dol. Bet wudet Ne ydeblo ne wkaa Ne nga, zhich guin wlen wlaanen Ne. ");
INSERT INTO zpi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Lex re Bzelo lo Ne: ―Belne nli XPee Dëdyuzh nak de, gukyeen gye gwa gako gyëtxtil. ");
INSERT INTO zpi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Wke Jesus, re Ne: ―Lo xgyiich Dëdyuzh re: “Let noncheedet por gyëtxtil ybán mén, sinke no ke por yrandxee xdiiz Dëdyuzh.” ");
INSERT INTO zpi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Zhich guin wano Bzelo Ne te xtoo gyeey ne kesentyent gya, lex tebrrategue wluu Bzelo yrandxee gyëz ne nak lo gyëzlyu lo Ne. ");
INSERT INTO zpi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Re Bzelo: ―Noo yniiz poder lo de no le yrandxee ne nuu lo gyëzlyu, porke xen noo nako, no zak ydee noo we lo men ne rlaantee noo ydee noo we. ");
INSERT INTO zpi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Belne suzhib de lo noo saknon de noo, yrandxee neree gak xen de. ");
INSERT INTO zpi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Per wke Ne re Ne lo Bzelo: ―Lo xgyiich Dëdyuzh re: “Nonchee XDëdyuzh de gusaknon, no nonchee ne rkyeen Ne gulaa.” ");
INSERT INTO zpi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Zhich guin wano Bzelo Ne Jerusalén, wlep Bzelo Ne xtoo xeydoo Dëdyuzh ledne mazre gyadee, re Bzelo lo Ne: ―Belne nli XPee Dëdyuzh nak de, gutsas nee, gugyab lyu; ");
INSERT INTO zpi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","porke lo xgyiich Dëdyuzh re: Dëdyuzh yxaal xangel chen gapkwent xangel Ne de. ");
INSERT INTO zpi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ylisgya xangel Ne de kon nya xangel Ne chen tsakadet gye nii de. ");
INSERT INTO zpi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Wke Ne re Ne: ―Laake re ke lo xgyiich Dëdyuzh: “Ylaadet de preb XDëdyuzh de.” ");
INSERT INTO zpi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chene che wzëldetre pezee ylaa Bzelo Ne preb, wbetxee Bzelo lo Ne te tyemp. ");
INSERT INTO zpi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Wberee ke Jesus lo lyu ne la Galilea, kesentyent waknonen Espíritu Sant Ne, no ydendxee nes guin ruu mén xdiiz Ne. ");
INSERT INTO zpi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ra Ne lenxeydoo men ydendxee nes guin, raneluu Ne men; yrandxee men rzaknon Ne. ");
INSERT INTO zpi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wa Jesus Nazaret ledne wroo Ne. Lex dxe ne rne men-Israel, wdee Ne lenydoo zegnak xkoxtumber Ne, lex wzuli Ne chen gool Ne lo xgyiich Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Wdee men liber ne wkaa profet-Isaías lo Ne. Chene wxal Ne lo liber guin, wzël te ledne re: ");
INSERT INTO zpi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Laa XEspíritu Dëdyuzh raknonen noo, porke laa Ne wye noo por ne yzëët noo xdiznzoon Ne lo yra menprob. Wxaal Ne noo chen yzëët noo lo yra men ne nunyoow gan pezee yláá men, no chen ylaa noo ne gyenii bzalo menngwlëë, no chen yselaa noo yra men ne baanske rzak, ");
INSERT INTO zpi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","no wxaal Ne noo chen yzëët noo lo mén ne le iz ne re Dëdyuzh ne yláá men che wdxiin. ");
INSERT INTO zpi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lex wtsëë Jesus lo liber guin wdee No lo men ne run yudar lenydoo, wluzh nga wzob Ne. Yrandxee men ne nuu lenydoo rzakyaanen lo Ne. ");
INSERT INTO zpi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wzelo Ne wnii Ne lo men, re Ne: ―Yra ne zëëd lo xgyiich Dëdyuzh ne won de orree, laa we nee kayak nedxeree. ");
INSERT INTO zpi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yrandxee mén re ne wen yra ne rnii Ne, no kesentyent rzee rzak men por yra diznzoon ne rnii Ne. Lex rnabdizlsaa men, re men: ―¿Pe let laadet xpee Xeb nee? ");
INSERT INTO zpi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Orguin re Jesus lo men yra men: ―Nanwen noo ne sna de lo noo, diiz ne re: “Doctor, gulaa de rmed laake de”, no sna de lo noo: “Ne won noo wlaa de gyëz-Capernaum, gulaa we no nee ledne nak laz de.” ");
INSERT INTO zpi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","No re Ne lo men: ―Nligue yna noo lo de yra de ne ni te profet rwiwendet mén men laake laz men. ");
INSERT INTO zpi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","No yna noo lo de, chene wuu profet-Elías, kesentyent ndal wnabyud wuu Israel, chene wyabdet gyo tson izgwrol, ydendxee gyëzlyu wuu gbiin, ");
INSERT INTO zpi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","per wxaaldet Dëdyuzh Elías ni te lo wnabyud ne nuu Israel, sinke le Dëdyuzh wxaal men lo te wnabyud ne nuu Sarepta ne nak nes Sidón. ");
INSERT INTO zpi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","No ndal ke men ne rzak gyiz ne la lepra wuu Israel chene wuu profet-Eliseo, per ni te men wneseyakden Eliseo, sinke le Eliseo wneseyaken nonchee Naamán men-Siria. ");
INSERT INTO zpi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chene won yra men ne ndxin lenydoo ne re Ne zenga, kesentyent wlayaa men. ");
INSERT INTO zpi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Orguin wzuli men yra men, wboo men Ne lenlgyëz guin; wano men Ne xtoo gyeey ne nak gyëz guin, chen ydexee men Ne axtegue nga. ");
INSERT INTO zpi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per wdee Ne gwrooltee lad men yra men syague Ne. ");
INSERT INTO zpi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Zhich guin wa Jesus Capernaum te gyëz ne nak lo lyu ne la Galilea. Nga wkaneluu Ne mén dxe ne rne men-Israel. ");
INSERT INTO zpi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wzee wzak men por yra ne rneluu Ne, porke rnii Ne zegnak te men ne rnebééy. ");
INSERT INTO zpi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lenydoo ledne kaneluu Ne, zob te mgyeey ne nuu menzab lextoo. Wzelo menzab rderëz menzab, re menzab: ");
INSERT INTO zpi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Zeka noo; ¿penak rdee de lad noo Jesus men-Nazaret? ¿Pe zëëd de yluzh de noo? Rnebeey noo de no nan noo ne nakdet de mendol, XPee Dëdyuzh nak de. ");
INSERT INTO zpi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Lex wakndux Jesus lo menzab, re Ne: ―¡Gusoow ruu de! ¡Guruu lextoo ménree! Orguin wtxoon menzab mén guin lyu nes lo yra mén, wruu menzab lextoo men, bet wzakdet men. ");
INSERT INTO zpi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yrandxee mén wzee wzak, lex rnabdizlsaa men, re men: ―¿Pezee nakleg xdiiz ménree bes ne rnebééy men lo menzab no ne rap men poder rnii men lo menzab no rruu menzab lextoo mén? ");
INSERT INTO zpi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ydendxee nes guin ruu mén xdiiz Ne. ");
INSERT INTO zpi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chene wruu Jesus lenydoo, wa Ne ruxyuu Simon. Le xnasweguer Simon nex kesentyent rlen men xlaa, lex wnab mén lo Jesus ne yneseyaken Jesus men. ");
INSERT INTO zpi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Orguin wlitlo Ne ledne nex men, wakndux Ne lo xlaa, wruugue xlaa led men. Orgueguin waxee men wdee men ne wu Ne yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Le chene waaz ngbiz, wa yrandxee mén ne rap mengyiz ne rzak noze wren wren gyelgyiz wano xpengyiz men lo Jesus. Lex wxob nya Ne led men te te men, wneseyaken Ne men yrandxee men. ");
INSERT INTO zpi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","No ndal ke mengyiz guin rruu menzab lextoo, noze rderëz menzab, re menzab: ―Laa de nak XPee Dëdyuzh. Per wakndux Jesus lo menzab, wdeedet Ne si nnii menzab porke nan Ne ne che nan menzab ne laa Ne nak Crist. ");
INSERT INTO zpi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ne wyenii lyu, wruu Jesus lenlgyëz guin wa Ne te ledne yëtet mén. Per waye mén Ne, lex chene wdxiin men lo Ne, wlaan men nsoow men Ne chen nyadet Ne, ");
INSERT INTO zpi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","per re Ne lo men: ―Rap noo degne yzëët noo xdiznzoon Dëdyuzh lo ste gyëz no le zegne rkyeen Ne, porke por neguin wxaal Ne noo. ");
INSERT INTO zpi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Zenga wkaa Jesus wkazëët Ne xdiiz Dëdyuzh lo mén yrandxee lenydoo ne zob lo lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tebtir chene zu Jesus runis-Genesaret, kesentyent ndal mén wdxiin lo Ne. Noze reen men Ne por ne rlaan men gon men xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Lex wii Ne zob txup bark guex runis, le yra men ne rkaa gozmël wruu lenbark zagye xgyix men. ");
INSERT INTO zpi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Orguin wdee Ne te leen bark guin ne nak xbark Simon, lex wnab Ne lo Simon ne ydxig Simono lodee nis. Zhich guin wzob Ne lenbark guin, axtegue nga zob Ne wneluu Ne mén. ");
INSERT INTO zpi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Chene wluzh wnii Ne lo yra mén guin, re Ne lo Simon: ―Gutsano bark ledne gyëtdee, lex gutxoon xgyix de chen ynëëz de mël. ");
INSERT INTO zpi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wke Simon, re Simon: ―Maxter, ydebgyëëlendxee kalaa noo dxiin yra noo; bet mël wnëëzdet noo. Per kom laa de rkyeen, tsatxoon noo we ste. ");
INSERT INTO zpi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Chene wtxoon meno, kesentyent ndal mël wnëëz men, axtegue rrëz xgyix men. ");
INSERT INTO zpi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lex wluu men senye lo xkompanyer men ne nuu ste lenbark guin, chen tsa men gun men xyudar men. Lex wa men, wsezaa men mël yrup bark axtegue mer nzebgyëto. ");
INSERT INTO zpi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ne wii Simon neguin, wzuzhib men lo Jesus, re men: ―Gubetxee lo noo Dechey, porke mendol nak noo. ");
INSERT INTO zpi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kesentyent wdxe Simon yra Simon men ne ndxinno Simon nga por tant ndal mël wnëëz Simon yra Simon men. ");
INSERT INTO zpi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zenga ke wdxe Xwa yrup Xwa Jacob ne nak xkompanyer Simon; xpee Zebedew nak yrup menree. Orguin re Jesus lo Simon: ―Ydxedet de. Desde orree gak de men ne ylaa mén xpén Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chene wdxinno men bark runis, wsan men yrandxoo. Lex zanal men Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tebtir chene ka Jesus te gyëz, wdxiin te mgyeey ne rzak gyiz ne la lepra; zegne wii men Jesus, wzuzhib men lo Ne axtegue wtee lo men lyu, wnab men lo Ne, re men: ―Dechey, belnaal yna de zun de gan yneseyaken de noo. ");
INSERT INTO zpi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Lex wzegaa Ne nya Ne wtee No led men, re Ne lo men: ―Sna noo. Gugyaken. Orgueguin wyaken led mén guin. ");
INSERT INTO zpi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Lex re Ne lo men: ―Rut lo guedet de neree; nonchee lo fxuz gutsa gutsaluu led de no gutsaron xgoon de ne che wakndaa de nes lo Dëdyuzh zegne zëëd lo ley ne wdee Dëdyuzh lo Moises chen gaknan mén ne che wyaken led de. ");
INSERT INTO zpi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Per dxe kon dxe mazre zarëëts diiz yra ne rlaa Jesus, no ndal mén rdop lo Ne chen gon men ne rzëët Ne no chen yneseyaken Ne men. ");
INSERT INTO zpi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Per rrunsu Ne lo men yra men, ra Ne ledne yëtet mén ranab Ne lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Te dxe ne kaneluu Jesus mén, nga zob tebëd men ne nak farisew no le tebëd maxter ley ne wruu yra gyëz ne nak lo lyu ne la Galilea no le ne nak lo lyu ne la Judea no le Jerusalén. Wdee Dëdyuzh poder lo Jesus chen yneseyaken Ne mén. ");
INSERT INTO zpi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lex wdxiin tebëd mén wdxinneey men te mgyeey ne noze waknet led, zhoob men te lo lonwin. Rlaan men ndee men lenyuu chen ngyix men mengyiz guin lo Ne. ");
INSERT INTO zpi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Per rakdet tee men por tant ndal mén ndxin. Orguin wyeep men xtoo yuu, wlis men tebëd tezh; lex nes guin wlit men mengyiz guin ydebxloon men, wgyix men men lo Ne gwrooltee lad yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chene wii Ne ne rlaleedx yra mén guin Ne, re Ne lo mengyiz guin: ―Le xdol de che wak perdon. ");
INSERT INTO zpi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Orguin nuu lextoo men ne nak farisew yra men maxter ley: “¿Txu nak ménree ne rnii men diznyaan por Dëdyuzh? Rut rundet gan gun perdon xdol mén, sinke nonchee Dëdyuzh run gan run perdon xdol mén.” ");
INSERT INTO zpi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Per wdeegue Jesus kwent gan kox nuu lextoo men, lex re Ne lo men: ―¿Penak rlebleedx de zegwa? ");
INSERT INTO zpi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Pe mazre mbëëdee gue noo lo mén: “Le xdol de che wak perdon”, u ne gue noo: “Gutsaxee, gugya”? ");
INSERT INTO zpi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Orree kwii de yra de gante ne Men ne wdxiid wak Mén rap men poder nee gyëzlyuree por ne gun men perdon xdol mén. Lex re Ne lo mengyiz guin: ―Yna noo lo de, gutsaxee gulis xloon de, gugya ruxyuu de. ");
INSERT INTO zpi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Orgueguin waxee men nes lo yra mén guin, wlis men xloon men ne waa men lo, lex sya men ruxyuu men, ryaldet rzaknon men Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wzee wzak yrandxee mén guin, wzelo men no men wzaknzoon Dëdyuzh; kesentyent rdxe men yra men, re men: ―Nedxeree wii be ne gardetlel kwii be. ");
INSERT INTO zpi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Zhich guin wruu Jesus nga. Lex wii Ne lo te men ne la Leví ne rgoob zeg impwest, zob men ledne rezh zeg impwest, lex re Ne lo men: ―Gutanal noo. ");
INSERT INTO zpi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Orguin wzuli men; wsan men yrandxoo, zanal men Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Zhich guin wlaa men te lniroo ruxyuu men por Jesus. Kesentyent ndal men ne rgoob zeg impwest ndxinno Ne lo mezh no ndal ke noze mén. ");
INSERT INTO zpi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Per wzelo yra men ne nak farisew yra men maxter ley ne nuu lad ke men, rnii men por xpén Ne, re men lo men: ―¿Penak ru rootee de yra de men ne rgoob zeg impwest no le yra de mendol? ");
INSERT INTO zpi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wke Jesus, re Ne lo men: ―Men ne ngyëël, rkyiinden men doctor, sinke men ne rzhuun, men guin rkyiinen doctor. ");
INSERT INTO zpi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Noo zëëdet noo zëdye noo menwen, sinke le noo zëdye mendol chen ysaan men xgyelmal men. ");
INSERT INTO zpi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lex wnabdiiz men lo Jesus, re men: ―¿Penak kesentyent rkwan xpén Xwa no le xpén men ne nak farisew no kesentyent rnab men lo Dëdyuzh, le xpén de syemper ru rootee men? ");
INSERT INTO zpi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Wke Jesus, re Ne: ―Lo te dooy, ¿peguin zun de gan ydeedet de ne gu xemyooz nobye myentras ne benak zu nobye lo men? ");
INSERT INTO zpi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per sdxiin dxe ne ybetxee nobye lo men; cheguin si ykwan men gudet men. ");
INSERT INTO zpi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","No re ke Ne lo men: ―Rut rtxuugdet te lërkweb chen ykadaa men te lëryuux. Belne ylaa men zenga, sxiin men lërkweb no ngyidetzeg gyan lërkweb led lëryuux. ");
INSERT INTO zpi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni rut rgaadet binkweb lengyedyuux, porke belne ylaa men zenga, stxëz binkweb gyedyuux; nigle xiin bin, nigle xiin gyed. ");
INSERT INTO zpi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Por neguin binkweb leen ke gyedkweb taa we, chen zenga ni tebo xiindet. ");
INSERT INTO zpi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","No ni te mén ne roo bin ne che wakxche nuu, ynadet goo binkweb, porke nan men: “Wendee nlaan bin ne che wakxche nuu.” ");
INSERT INTO zpi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te dxe ne rne men-Israel, wdee Jesus ledne nuu zhobxtil yra Ne xpén Ne; wkyiits men xebzun zhobxtil wzibnya meno, wruu zhobxtil wu men. ");
INSERT INTO zpi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Lex re tebëd men ne nak farisew lo men: ―¿Penak rlaa de ne ndux ylaa be dxe ne rne be? ");
INSERT INTO zpi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Wke Ne re Ne: ―¿Pe gardet gool de lo xgyiich Dëdyuzh ledne re ne wlaa David chene wlaanen zhaa yra zhaa xkompanyer zhaa? ");
INSERT INTO zpi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wdee zhaa lenxeydoo Dëdyuzh, wgoob zhaa gyëtxtil ne nakleey wu zhaa yra zhaa xkompanyer zhaa, no ndux gu kwaskyer mén gyëtxtil guin, nonchee fxuz rak ru we. ");
INSERT INTO zpi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","No re Ne: ―Men ne wdxiid wak Mén rak ke rnebééy men no dxe ne rne be. ");
INSERT INTO zpi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ste dxe ne rne men-Israel, wa Jesus lenydoo wneluu Ne mén. Nga zob te mgyeey ne miitx nyabëë. ");
INSERT INTO zpi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kom noze kaleedx maxter ley yra men men ne nak farisew gan pe sneseyaken Jesus mgyeey guin dxe ne rne men-Israel, chen tsël gan pezee ykagyii men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Per kom nan Ne gan pe rlebleedx men, lex re Ne lo mgyeey guin ne miitx nya: ―Gusuli, gusu gwrooltee. Orguin wzuli mgyeey guin, wzu men gwrooltee lad mén. ");
INSERT INTO zpi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Lex re Ne lo men yra men: ―Ynabdiiz noo lo de: ¿Pagox nak ne ryal ylaa me dxe ne rne me, ne wen u ne mal?, ¿yselaa me xgyelembán te mén u yket me men? ");
INSERT INTO zpi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Zhich guin wii Ne lo yra mén guin ne ndxin kbii Ne, lex re Ne lo mgyeey guin: ―Guzegaa nya de. Zegne wzegaa meno, wakwengoo. ");
INSERT INTO zpi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kesentyent wlayaa wladuxtee yra mén guin. Wzelo men rnabdizlsaa men gan pezee ylaa men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Cheguin ke wa Jesus te txu gyeey chen ynab Ne lo Dëdyuzh; nga wnab Ne lo Dëdyuzh ydebgyëël. ");
INSERT INTO zpi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Chene wyenii lyu, wbëz Ne yra xpén Ne, lex lad yra mén guin wye Ne chibtxup men, wnesela Ne men poxter. ");
INSERT INTO zpi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Laa men yra men nga nak: Simon no wnesela ke Ne men Bëd, no le Ndrizh bech Simon, Jacob, Xwa, Blib, Bartolomé, ");
INSERT INTO zpi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mdëw, Tmazh, Jacob xpee Alfeo, Simon men ne nak Zelot, ");
INSERT INTO zpi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas xpee Jacob, no le Judas Iscariote ne wdekwent Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Lex wyët Jesus txu gyeey guin yra Ne men, wzutsë Ne te lenleech. Nga ndxin ndalyaa ndalduxtee mén: men-Jerusalén, men ne wruu lo lyu ne la Judea, men ne wruu nes runisdoo ne nak nes Tiro no le nes Sidón. Wdxiin yra mén guin nga chen gon men ne rzëët Ne no chen yneseyaken Ne men ne rzhuun. ");
INSERT INTO zpi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","No yrandxee men ne baanske rlaa ne nuu menzab lextoo wyaken. ");
INSERT INTO zpi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yrandxee mén guin rlaan ytee nya led Ne porke rneseyaken Ne mén por poder ne rap Ne. ");
INSERT INTO zpi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wlis lo Jesus wii Ne nes lo xpén Ne, lex re Ne lo men: ―Nzoon de yra de ne nak de menprob, porke por laa de nak ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Nzoon de yra de ne rlaanen de orree, porke sdxiin dxe ne sak lextoo de. ’Nzoon de yra de ne roon de orree, porke sdxiin dxe ne yzhidx de. ");
INSERT INTO zpi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Nzoon de yra de chene rwinyaan mén de, chene rboo men de lad men, chene rninyaan men lo de, chene txu rsaktee men de por ne rlaleedx de Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Guzhiilen chene ydxiin dxe guin, kesentyent guzhiilen, porke kesentyent non ne yniiz Dëdyuzh lo de chene ydxiin de gyeybaa, porke laake zegwa wzakzi yra xpenkwlal men profet ne wuu chekwlo. ");
INSERT INTO zpi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Prob de yra de ne nak de menrik, porke che wuu de gyelgwzhiil. ");
INSERT INTO zpi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Prob de yra de ne ru de orree axtegue ne rzak lextoo de, porke sdxiin dxe ne ylaanen de. ’Prob de yra de ne rzhidx de orree, porke sdxiin dxe ne goon de por gyelenles. ");
INSERT INTO zpi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Prob de yra de chene rnii mén dizwen por laa de, porke zenga ke wlaa yra xpenkwlal men profet ne noze wkade ne wuu chekwlo. ");
INSERT INTO zpi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Per le laa de yra de ne kayon de neree, yna noo lo de: Gugyaan mén ne rlaa lo de, wen gugak lo mén ne rlaandet kwii de, ");
INSERT INTO zpi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","gunab lo Dëdyuzh por mén ne rgyiin rnabtee ne sak de, gunab lo Dëdyuzh por men ne rninyaan lo de. ");
INSERT INTO zpi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Belne nuu mén gap gyedkwes de, gudee stebkoo we gap men, no belne nuu mén rgyitxee xlërmank de, gudee no xlërmanknaal de gweey men. ");
INSERT INTO zpi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kwaskyertee mén ne pe rnab lo de, gudee we; men ne rgyitxee ne nak xen de, zeka men, bet guedet de lo men. ");
INSERT INTO zpi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gugak lo mén zegne rlaan de ne gak men lo de. ");
INSERT INTO zpi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Belne ryaan de nonchegue mén ne ryaan de, ¿pe ne wenzhe rlaa de? Porke axtegue menmal ryaan nonchegue mén ne ryaan men. ");
INSERT INTO zpi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","No belne wen de nonchegue lo men ne wen lo de, ¿pe ne wenzhe rlaa de? Porke no ke menmal rlaa zenga. ");
INSERT INTO zpi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","No belne rdee de ne rnab nonchee mén ne ryenen de ne zun gan ycheree we, ¿pe ne wenzhe rlaa de? Porke no ke menmal rdee ne rnab semenmal men ne ryenen men ne zun gan ycheree we. ");
INSERT INTO zpi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Per le laa de yra de, rap de degne gyaan de men ne rlaa lo de, gulaa ne wen, gudee ne rnab men lo de sin ne ykambë́zdet de gan pe yniiz men lo de, chen zenga gueden de ne kesentyent non no chen zenga gak de zhiin Dëdyuzhnzoon; porke laa Ne kesentyent wen Ne, nigle lo mén ne rdeedet dexkyizhtee lo Ne, nigle lo menmal. ");
INSERT INTO zpi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gules lextoo de semén de zegne rles lextoo Dëdyuzh Xuz be de. ");
INSERT INTO zpi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Yleedxdet de semén de, chen ylaadet ke Dëdyuzh gyelextis lo de. Yzakzidet de semén de, chen yzakzidet ke Dëdyuzh de. Gugun mén perdon, chen gun ke Dëdyuzh de perdon. ");
INSERT INTO zpi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Logne rnabtee mén lo de, gudee we, Dëdyuzh yseleedx mazre ndaldee we lo de; kesentyent ndalyaadee we yseleedx Ne lo de axtegue yrukaa we. Porke zegne rdee de ne rnab semén de, zenga ke ykakwent do. ");
INSERT INTO zpi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Lex re Jesus lo men: ―¿Peguin zun te ngwlëë gan yluu nëz lo ste ngwlëë? ¿Pe ybexeedet men rublaa yrup men? ");
INSERT INTO zpi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ni te mén ne benak rseed nondet mazre ke lo xmaxter men. Chene le men che wyal wseed, cheguin gak men zegnak xmaxter men. ");
INSERT INTO zpi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Penak rwii de yuwin ne nuu bzalo semén de no ryenden de ne nzhoodee bled ne nuu bzalo de? ");
INSERT INTO zpi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Pezee ryezh de ne nan de lo semén de: “Gudee si koo noo yuwin ne nuu bzalo de”, no ryenden de ne nzhoodee ne nuu bzalo de? ¡Gugannaa laa de wen! Primer gukoo bled ne nuu bzalo de, chen gak kwii de wen chen koo de yuwin ne nuu bzalo semén de. ");
INSERT INTO zpi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Yët yagwen ne rkaa nex ne ngyidet lo, ni yët yag ne ngyidet ne rkaa nexwen lo. ");
INSERT INTO zpi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Porke te te yag ryakbeeyo por nex ne rkaa lo we: rkaadet ig lo yaggyëts, ni rkaadet ub lo gyëtsbne. ");
INSERT INTO zpi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Zenga ke nak mén: menwen, dizwen rnii men porke ne wen nuu lextoo men; le menmal, dizmal rnii men porke ne mal nuu lextoo men. Porke yra diiz ne nuu lextoo men, laa we rlen ruu men. ");
INSERT INTO zpi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Penak rnii de noo, “Dechey, Dechey”, no rlaadet de ne na noo? ");
INSERT INTO zpi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yna noo lo de yra de, gan txuzh rzaglo mén ne zëëd lo noo no ne ron ne rzëët noo no rlaa meno: ");
INSERT INTO zpi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","nak men zegnak te mén ne wlep xyuu, primer wkeen men gyët axtegue ne wga gye, lex wgyix xsimyent men led gye. Chene waknaal nis gyoow, wasobo txu yuu guin, per bet wzakdeto porke led gye nex xsimyento. ");
INSERT INTO zpi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Per le mén ne ron ne rzëët noo no rlaadet meno, nak men zegnak mén ne wlep xyuu noze lo yu, wgyixdet men simyent. Le chene waknaal nis gyoow, wasobo txu yuu guin, watxee we axtegue ni xbeeyo wyandet. ");
INSERT INTO zpi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chene wluzh wnii Jesus lo yra mén guin, za Ne Capernaum. ");
INSERT INTO zpi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nga nuu te kapitan-Roma; rap men te xmos men ne kesentyent ryaan men; rzhuun mos guin, mer mer guet men. ");
INSERT INTO zpi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chene won kapitan ne ruu mén xdiiz Jesus, wxaal men txup tson mén ne rnebééy lo men-Israel, chen tsa men ynab men lo Ne ne tsaneseyaken Ne xmos men. ");
INSERT INTO zpi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ne wdxiin mén guin lo Ne, wzelo men kesentyent wnab men lo Ne, re men: ―Rzëël ne gun de xyudar kapitanree, ");
INSERT INTO zpi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","porke ryaan zhaa menlaz be no laa zhaa wkyeen ne wyeep xeydoo be. ");
INSERT INTO zpi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lex za Ne yra Ne men; per chene che guex ydxiin Ne ruxyuu kapitan, wxaal kapitan txup tson xmig kapitan ne tsa gue lo Ne: ―Dechey, gunendet lo de, porke rzëëldet noo ne chiid de axtegue ruxyuu noo. ");
INSERT INTO zpi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Por neguin wyezhdet noo ne ndxidye noo de laa zhal noo. Per nozguestee gukyeen ne gyaken xmos noo, laa ne gyaken men nga. ");
INSERT INTO zpi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porke no ke noo rap mén ne rnebééy lo noo, no rap ke noo mén ne rnebééy noo lo. Chene nan noo lo men te men ne tsa men mandad, ra men; chene nan noo lo men ste men ne chiid men lo noo, rdxiid men; chene nan noo lo xmos noo: “Gulaa neree”, rlaa meno. ");
INSERT INTO zpi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ne won Jesus ne re xmig kapitan neguin ne re kapitan, wzee wzak Ne, lex wcheree lo Ne wii Ne lo yra mén ne zanal Ne, re Ne lo men: ―Yna noo lo de ne ni Israel gardet ytsëlo noo ni te mén ne rlaleedx noo zegne rlaleedx ménree noo. ");
INSERT INTO zpi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Le chene wberee yra men guin ne wxaal kapitan, wii men le xmos kapitan che wyaken. ");
INSERT INTO zpi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wluzh nga za Jesus te gyëz ne la Naín yra Ne xpén Ne no le ndalyaa mén. ");
INSERT INTO zpi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chene wdxiin Ne guex rulgyëz guin, wii Ne le mén zakeedx te mengut, xpee te wnabyud; tendxee men nak mëëd lo wnaa guin. Kesentyent ndalyaa mengyëz zanal men. ");
INSERT INTO zpi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chene wii Jesus wnaa guin, wles lextoo Ne men, lex re Ne lo men: ―Goondet de. ");
INSERT INTO zpi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Lex wbig Ne wtee nya Ne txu gyin ne nuu mengut guin; orguin wzutsë yra mén ne zaneey men, lex re Ne lo mengut guin: ―Zhanmenyu, yna noo lo de: ¡Gutsaxee! ");
INSERT INTO zpi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Orguin wzobli mén guin, wzelo men wnii men, lex wdekwent Jesus men lo xnaa men. ");
INSERT INTO zpi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ne wii yra mén neguin, wdxe men, wzelo men wzaknon men Dëdyuzh, re men: ―Te profet ne kesentyent non wrukaa lad be. No re men: ―Dëdyuzh zëdgyun xyudar be. ");
INSERT INTO zpi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ydendxee lo lyu ne la Judea no le yrandxee gyëz ne nak guex nga waknan mén neguin ne wlaa Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wuu xpén Xwa diiz lo Xwa yra neree ne wak. Lex wbëz Xwa men txup men, ");
INSERT INTO zpi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","wxaal Xwa men lo Jesus chen ynabdiiz men lo Ne gan pe laa Ne nga nak ne nuu diiz ne chiid o rap Xwa degne ykambë́z Xwa ste mén. ");
INSERT INTO zpi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Chene wdxiin mén guin ne wxaal Xwa, re men lo Ne: ―Laa Xwa ne rtxobnis wxaal noo zëdnabdiiz noo lo de gan pe laa de nga nak ne nuu diiz ne chiid u rap Xwa degne ykambë́z Xwa ste mén. ");
INSERT INTO zpi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Orgueguin wneseyaken Ne ndalyaa mengyiz, men ne rzak gyelerzebyoob, men ne nuu menzab lextoo, no wlaa Ne ne wyenii bzalo ndal menngwlëë. ");
INSERT INTO zpi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lex wke Ne re Ne lo men: ―Gutsa gue de lo Xwa logne wii de, logne won de. No gu de diiz lo Xwa ne le menngwlëë che rwii, le mennguzh che rzawen, le men ne rzak gyiz ne la lepra che wyaken, le mennkwëët che wyenii gyedyag, le men ne che wet le men che wban, le lo yra menprob che rakzëët xdiznzoon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nzoon men ne ysalzaandet ne rlaleedx men noo. ");
INSERT INTO zpi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chene che sya yra men ne wxaal Xwa, wzelo Jesus wzëët Ne xkwent Xwa lo yra mén ne ndxinno Ne, re Ne: ―¿Pagox wa de wii denbidx? ¿Pe te gobkyii ne rlaa mee zere zerotee wa de wii? ");
INSERT INTO zpi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿U pagox wa de wii? ¿Pe te mén ne zhaandxee rnaa xab wa de wii? Laa de yra de nan de ne men ne zhaandxee rnaa xab no men ne mbaale za lo xgyelembán, ruxyuloow rrey ndxin men. ");
INSERT INTO zpi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Guex neguin, ¿txu wa de wii? ¿Pe te profet wa de wii? Nli we, yna noo lo de, te men ne mazre nondee ke lo te profet wa de wii. ");
INSERT INTO zpi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Laa men nga rakzëët lo xgyiich Dëdyuzh ledne re: Noo yxaal te mén ne saner lo de chen ylaxnëz men xnëz de. ");
INSERT INTO zpi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yna noo lo de ne delo lo yrandxee mén, ni te men ne mazre nondee ke lo Xwa ne rtxobnis gardet tsuu; per mase zenga, mén ne zhindxee non ledne rnebééy Dëdyuzh, men guin nak ne mazre nondee ke lo Xwa. ");
INSERT INTO zpi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ne won yra mén neguin yra men men ne rgoob zeg impwest, wyenen men ne xnëz rlaa Dëdyuzh porke che wrobnis men lo Xwa. ");
INSERT INTO zpi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per le yra men ne nak farisew no le yra maxter ley ne wrobnisdet lo Xwa, wlaandet men logne rlaa Dëdyuzh por laa men. ");
INSERT INTO zpi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","No re Jesus lo men: ―¿Pagox ynesaglo noo mén ne nuu naaree? ¿Pagox rzaglo men? ");
INSERT INTO zpi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rzaglo men minwin ne rkaa wkyit lenlgyeey no ne rkarëzlsaa, nan miin: “Wool noo flawt yra noo, per wyadet de. Nles wolbaan noo, per woondet de.” ");
INSERT INTO zpi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Porke wdxiid Xwa ne rtxobnis, wudet men yralondxee ne ru mén, ni woodet men bin, no re de yra de ne menzab nuu lextoo men. ");
INSERT INTO zpi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Orrenaa zëëd Men ne wdxiid wak Mén, ru men, roo men, no re de, laa men kesentyent ru rootee, laa men rtsëlsaa mendol no laa men rtsëlsaa men ne rgoob zeg impwest. ");
INSERT INTO zpi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Per xgyelenyenii Dëdyuzh raknyoo we por yra mén ne nak xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wbëz te men ne nak farisew Jesus ne tsa Ne gwdu ruxyuu men; lex wdee Ne lenxyuu men wzob Ne lo mezh. ");
INSERT INTO zpi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Gyëz ke guin nuu te wnaa ne kesentyent zeeb dol. Ne waknan men ne le Ne za gwdu ruxyuu farisew, wdxinneey men te bot alabastro, yzaa we perfum. ");
INSERT INTO zpi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Roon men, wzob men guex ledne zu nii Ne; wgaz men nii Ne kon nis lo men, lex wkwiidx meno kon gyitsxtoo men; wtsëlruu men nii Ne, lex wdxiib men perfum guin led nii Ne. ");
INSERT INTO zpi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chene wii farisew guin ne wbëz Ne ne wlaa wnaa guin zenga, nuu lextoo men: “Belne nli profet nak zhanree, nyenen zhaa gan pe klas nak wnaa gwa ne wtee nya led zhaa no gan txu nak men, no nyenen zhaa ne mendol nak men.” ");
INSERT INTO zpi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Lex re Ne lo farisew guin: ―Simon, rap noo te diiz ne yzëët noo lo de. Wke men re men: ―Guzëëto, Maxter. ");
INSERT INTO zpi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Orguin re Ne lo men: ―Zeeb txup mén lo te men ne rbodiin med. Te men zeeb gaaygwyuu denario, le ste men zeeb txupchii we. ");
INSERT INTO zpi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Per kom rundet men gan gyizh meno, wun mén guin ne rbodiin med men perdon yrup men. Orrenaa, guna gan ¿txu menzhe ntozdee gyaan men guin ne rbodiin med? ");
INSERT INTO zpi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Wke Simon, re Simon: ―Por noo, men ne nyezhdee zeeb. Lex re Jesus: ―Zegwa we zeg na de. ");
INSERT INTO zpi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Orguin wcheree lo Jesus wii Ne lo wnaa guin, lex re Ne lo Simon: ―¿Pe wii de ne wlaa wnaaree? Wdee noo lenxyuu de, no wniizdet de nis ndaa nii noo; le wnaaree wgaz men nii noo kon nis lo men, lex wkwiidx meno kon gyitsxtoo men. ");
INSERT INTO zpi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Woodet de bzhid gyedkwes noo, per le wnaaree desde ne wdee noo lenxyuu de, rbë́zdet rtsëlruu men nii noo. ");
INSERT INTO zpi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wguudet de seyt xtoo noo, per le wnaaree wdxiib men perfum led nii noo. ");
INSERT INTO zpi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Por neguin yna noo lo de, le yra xdol men che wak perdon, porke kesentyent ryaan men noo; per le mén ne nuu lextoo ne zeebdet men ndal dol, zhi ryaan men noo. ");
INSERT INTO zpi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Lex re Ne lo wnaa guin: ―Le yra xdol de che wak perdon. ");
INSERT INTO zpi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Orguin wzelo yra mén ne zobno Ne lo mezh rnabdizlsaa men, re men: ―¿Txu nak ménree ne axtegue xdol mén run men perdon? ");
INSERT INTO zpi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Zhich guin re Ne lo wnaa guin: ―Por ne wlaleedx de noo, wláá de lo dol. Zhaas gugya. ");
INSERT INTO zpi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Zhich guin wa Jesus yra Ne chibtxup xpoxter Ne yra gyëz ne nak nes guin, nigle gyëznzhoo, nigle gyëzwin; wzëët Ne dizwen, laa we nga nak ne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","No zanal tebëd wnaa ne wneseyaken Ne no ne wboo Ne menzab lextoo. Lad men nga za Mli ne la Matlen ne wruu guedx menzab lextoo, ");
INSERT INTO zpi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","no zanal Xwan ne nak xewnaa Chuza ne rnebééy lo xdxiin rrey-Herodes, no zanal Susan, no zanal ndalre wnaa ne run xyudar Ne kon logne rapendxee men. ");
INSERT INTO zpi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ndal mén wruu te te gyëz chen kwii men Jesus. Lex chene wdop ndalyaa mén lo Ne, wzelo Ne wuu Ne zegnak te kwent lo men, re Ne: ");
INSERT INTO zpi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Te dxe wruu te mén ne rguu bni, zalabni men zhobxtil. Chene kalaal meno, nuu we wyab nëz, wdee mén wgyichnii meno; lex wyab mgyin wu ma we. ");
INSERT INTO zpi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nuuzego wyab lad gye; chene le we wlen, wbidxo por ne yëtet xkuup nga. ");
INSERT INTO zpi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nuuzego wyab lad lbagyëts; le chene le we zaroo yrupo, wket lbagyëtso. ");
INSERT INTO zpi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Per nuuzego wyab ledne wen lyu. Wroo we, kesentyent wako, nuu we wak axtegue tebgwyuu zhob. Wluzhse re Jesus yra diizree, wnii Ne ndípse, re Ne: ―Men ne rkagyedyag diiz, gon men neree ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Lex wnabdiiz yra xpén Jesus lo Ne gan pe rna kwent guin. ");
INSERT INTO zpi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wke Ne re Ne: ―Laa de yra de, Dëdyuzh wniiz si ne gaknan de logne ngueedx ne rkyeen Ne, per le lo men stebëd men rzëët noo we zegnak te kwent, chen mase mazre rwii men, per nak men zegnak mén ne rwiidet; mase mazre ron men diiz, per ydeedet men kwento. ");
INSERT INTO zpi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Zeree rna kwentree: Zhobbni nak xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Le zhobbni ne wyab nëz nak zegnak mén ne ron xdiiz Dëdyuzh, per rdxiin Bzelo rboo we lextoo men chen ylaleedxdet meno chen yláádet men lo dol. ");
INSERT INTO zpi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Le zhobbni ne wyab lad gye nak zegnak mén ne ron xdiiz Dëdyuzh; rzhiilen men ron meno, per kom nak men zegnak ne yëtet ndal lu, rlaleedxdet meno xche; chene pe rzak men, rsalzaangue meno. ");
INSERT INTO zpi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Le zhobbni ne wyab lad lbagyëts nak zegnak mén ne ron xdiiz Dëdyuzh, per tsoowgue tsoowgue rdee men si rnitleedx meno, por ne za lextoo men yra ne nuu gyëzlyuree no por ne rlaan men ne ylaa men ne rlaan led men, rlaadetre men ne wen. ");
INSERT INTO zpi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Per le zhobbni ne wyab ledne wen lyu, nak zegnak mén ne ron xdiiz Dëdyuzh no ydeblextoo men rlaleedx meno, tebegue laa we nuu xtoo men, no rlaa men ne wen. ");
INSERT INTO zpi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Rut rkaadet te bnii por ne ytsëë men lo we o por ne yzoob meno zhiin loon, sinke rzobgya meno chen yzenii we lo mén ne tee lenyuu. ");
INSERT INTO zpi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Zenga ke, bet ne ngueedx yët ne yrunyoodet, ni yët ne rak rlaanguel ne gaknandet mén, sinke sdxiin dxe ne gaknan méno. ");
INSERT INTO zpi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Por neguin wen wenendxee gukagyedyag ne na noo lo de. Men ne che rukas xdiiz Dëdyuzh, laa Ne ylaa ne mazre tsukas meno; per le men ne rukasdeto, axtegue ne chendxee rukas men, tsukasdetre meno. ");
INSERT INTO zpi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wdxiin xnaa Jesus yra men bech Ne guex ledne zu Ne, per rakdet ybig men lo Ne por tant ndal mén ndxin. ");
INSERT INTO zpi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Orguin waluu mén diiz lo Ne, re men: ―Le xnaa de no le yra bech de zu fwer, rlaan men kwii men de. ");
INSERT INTO zpi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lex wke Ne re Ne: ―Men ne ron xdiiz Dëdyuzh no rlaa meno, men guin nak xnaa noo no nak bech noo. ");
INSERT INTO zpi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Te dxe wdee Jesus lenbark yra Ne xpén Ne, re Ne lo men: ―Yoo tekaa be stebkoo nis. Lex za Ne yra Ne men. ");
INSERT INTO zpi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Or ne za men lo nis, waguees Ne. Tebegue wlen te meroo meduxtee lo nis; wzelo wdaa nis lenbark, le bark chexke zazebgyët. ");
INSERT INTO zpi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Orguin wa men wboo men mkaal lo Ne, re men: ―¡Maxter! ¡Maxter! ¡Le be zazebgyët! Lex waxee Ne wakndux Ne lo meroo guin no le lo nis; wutsëgoo, nonchee chi wak. ");
INSERT INTO zpi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Lex re Ne lo yra xpén Ne: ―¿Gozh xgyelerlaleedx de naa? Per kesentyent wdxe men yra men, rzee rzak men, rnabdizlsaa men, re men: ―¿Pezee nakleg ménree ne axtegue lo mee, axtegue lo nis rnebééy men, no rono xdiiz men? ");
INSERT INTO zpi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Wdxiin Jesus yra Ne xpén Ne lo xelyu men-Gadara ne nak stebkoo nis, ngali lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Chene wruu Ne lenbark, wruu te mgyeey ne nak mengyëz guin, za men zatsëlo men Ne. Che wakxcheroo nuu menzab lextoo men. Rakdetre men xab men, ni nuudetre men yuu, sinke teblose lad baa ka men. ");
INSERT INTO zpi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Chene wii men Jesus, wobtsadii men, wzuzhib men lo Ne, lex ndípse wnii menzab ne nuu lextoo mgyeey guin, re menzab: ―¿Penak rgal de noo, Jesus XPee Dëdyuzhnzoon? Ynab noo lo de ne yzakzidet de noo. ");
INSERT INTO zpi_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Re men zenga porke rkyeen Jesus ne yruu menzab lextoo men. Che wakxcheroo nuu menzab lextoo men; mase rliib mén nii nyatee men kon kaden chen bat tsadet men, per rtxugyaa men kaden; lex rkyenfwers menzab men ra men denbidx. ");
INSERT INTO zpi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Orguin wnabdiiz Jesus lo men, re Ne: ―¿Txu la de? Wke men re men: ―Le noo la Legión. Re men zenga porke ndalyaa nak menzab ne nuu lextoo men. ");
INSERT INTO zpi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lex wnab menzab lo Ne ne yxaaldet Ne men lenpos ne kesentyent gyët. ");
INSERT INTO zpi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kom nga txu gyeey guin ledne zu Jesus ndxin ndal kuch ka ma gwdu, lex wnab menzab lo Jesus ne ydee Ne si tee menzab lextoo yra kuch guin, lex wdee Ne si. ");
INSERT INTO zpi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Orguin wruu menzab lextoo mén guin, watee menzab lextoo yra kuch. Wzelo ma wzhoon maa wxenxtoo ma te ruyúú, wyab ma axtegue lo nis. Nga wobkyiky ma nis, wet maa. ");
INSERT INTO zpi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chene wii yra mén ne rapkwent kuch guin neguin ne wak, orgueguin wzhoon men, lex wa men waluu men diiz lenlgyëz no le ledne ka mén den. ");
INSERT INTO zpi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lex wruu yra mén za men wii neguin ne wak. Chene wdxiin men lo Ne, wii men le mén guin ne wruu menzab lextoo che zobchee lo Ne, che nak men xab men no che nde bnii xgyeryen men. Ne wii yra mén guin neguin, wdxe men. ");
INSERT INTO zpi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yra mén ne wii neguin ne wak, laa men wuu diiz gan pezee wyaken mén guin ne wruu menzab lextoo. ");
INSERT INTO zpi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lex wnab yra mén ne nuu nes Gadara lo Ne ne yruu Ne nga, porke kesentyent rdxe men. Lex wdee Ne lenbark sya Ne. ");
INSERT INTO zpi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Orguin wzelo mgyeey guin ne wruu menzab lextoo wnab men lo Ne ne ydee Ne si tsanal men Ne, per nadet Ne, re Ne lo men: ");
INSERT INTO zpi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Guberee, gugya ruxyuu de, gu de diiz yra ne wlaa Dëdyuzh de. Lex sya mgyeey guin, wuu men diiz ydendxee lenlgyëz neguin ne wlaa Jesus por laa men. ");
INSERT INTO zpi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Chene wberee Jesus stebkoo nis, kesentyent rzhiilen yra mén ne le Ne wberee porke che noze kambë́z men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lex wdxiin te mén ne la Jairo ne rnebééy lenydoo, wzuzhib men wnab men lo Ne ne tsa Ne ruxyuu men, ");
INSERT INTO zpi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porke rap men te xsaap men ne rap zeg chibtxup iz, mer mer guet nzeb. Ne za Ne nëz, kesentyent ndalyaa mén zanal Ne, noze reen men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lad yra mén guin za te wnaa ne rzhuun, che wzaa chibtxup iz ryab men ren, no che wluzh men yra ne rap men por ne ra men lo doctor; per ni te men wundet gan nneseyaken men. ");
INSERT INTO zpi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wbig wnaa guin nes zhich Jesus, wtee nya men luzh xab Ne. Orgueguin wyaag men ren. ");
INSERT INTO zpi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Lex wnabdiiz Jesus, re Ne: ―¿Txuzh wgal led noo? Kom yra mén re: “Ruttee”, wke Bëd yra Bëd xkompanyer Bëd, re Bëd: ―Maxter, noze reen mén de, noze rtxaap men de, no le de rnabdiiz gan txuzh wgal led de. ");
INSERT INTO zpi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Per wke Ne re Ne: ―Nuu mén wgal led noo, porke wyenen noo ne wruu xfwers noo. ");
INSERT INTO zpi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chene wyenen wnaa guin ne wyenen Jesuso, wa men noze rzhiz men, wzuzhib men lo Ne. Lex wxalruu men nes lo yrandxee mén, gan penak wgal men luzh xab Ne no ne orgueguin wyaken men. ");
INSERT INTO zpi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Orguin re Ne lo men: ―Zhiina, por ne wlaleedx de noo, wyaken de. Zhaas gugya. ");
INSERT INTO zpi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Benak kanii Ne lo men, chene wdxiin te xpén Jairo, re men lo Jairo: ―Le xsaap de che wet. Gunendetre de lo Maxter. ");
INSERT INTO zpi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Per chene won No, re Ne lo Jairo: ―Ydxedet de; noze gulaleedx noo, syaken xsaap de. ");
INSERT INTO zpi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chene wdxiin Ne ruxyuu Jairo, wdeedet Ne si ndenal ndal mén Ne lenyuu, nonchee Bëd no le Jacob no le Xwa no le xegwzan mëëd guin. ");
INSERT INTO zpi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yrandxee mén ne ndxin baanske rlaa men, roon men por mëdgwnaa guin. Per re Ne lo men: ―Goondet de; wetet nzaap gwa, noze nexguees nzeb. ");
INSERT INTO zpi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Per lel wzhidxno yra mén guin Ne, porke nan men ne che wet nzeb. ");
INSERT INTO zpi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lex wnëëz Ne nya nzaap guin, ndípse wnii Ne, re Ne lo nzeb: ―Nzebwin, gutsaxee. ");
INSERT INTO zpi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Orguin wban nzeb, waxeegue nzeb; lex wkyeen Ne ne ydee men ne gu nzeb. ");
INSERT INTO zpi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kesentyent wzee wzak xegwzan nzeb, per re Ne lo men ne rut lo gudet men diizo. ");
INSERT INTO zpi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wbëz Jesus yra chibtxup xpén Ne; lex wdee Ne poder lo men chen koo men menzab lextoo mén no chen yneseyaken men yrandxee mén ne rzhuun. ");
INSERT INTO zpi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wxaal Ne men chen yzëët men lo mén zegne rkyeen Dëdyuzh no yneseyaken men mén ne rzhuun. ");
INSERT INTO zpi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","No re Ne lo men yra men: ―Gweeydet de ne ykyiinen de nëz, ni baston, ni bols, ni ne gu de, ni med, ni gweeydet de steb nëz xab de. ");
INSERT INTO zpi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kwaskyertee ruyuu ne ydxiin de, nga ykaa de axtegue ne yruu de gyëz guin. ");
INSERT INTO zpi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Belne nuu gyëz ne ylaandet mén kwii men de, yruu de nga; kwib de guxyudi nii de zegnak te beey ne nadet mén guin nyon men ne wzëët de lo men. ");
INSERT INTO zpi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Lex wruu men za men gyëz por gyëz, rzëët men xdiznzoon Jesucrist no rneseyaken men yrandxee mén ne rzhuun. ");
INSERT INTO zpi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ne won rrey-Herodes ne kalaa Jesus, axtegue nandet men pe wuu lextoo men porke nuu mén re, Xwa ne rtxobnis wban. ");
INSERT INTO zpi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nuuzeg men re, profet-Elías wa wberee; nuuzeg men re, ka txu profet ne wuu chekwlal wban. ");
INSERT INTO zpi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Per re Herodes: ―Noo wxaal mén ne wa men watxuug men xtoo Xwa. ¿Txu wa ryen diiz ne kalaa yra negwa? Por neguin rye Herodes gan pezee kwii Herodes Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Chene wberee yra xpoxter Jesus, wuu men diiz lo Jesus yra ne wlaa men. Lex wano Ne men te ledne yëtet mén, guex ledne nak gyëz-Betsaida. ");
INSERT INTO zpi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Per chene waknan méno, wrunal men Ne. Lex watsëlo Ne men, wzelo Ne wzëët Ne zegne rkyeen Dëdyuzh, no wneseyaken Ne mengyiz. ");
INSERT INTO zpi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chene che rzëë, wbig yra chibtxup xpoxter Ne lo Ne, re men: ―Gugue lo yra ménree gya men chen tsaye men ledne yne men no chen tsaye men ne gu men ledne nak gyëzwin ne guexdee, porke nee ledne ndxin be, ni te mén nuudeto. ");
INSERT INTO zpi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Per wke Ne re Ne lo men: ―Laa de gudee ne gu men. Lex re men lo Ne: ―Per nonchee gaay gyëtxtil no le txup mël neey noo nee, nunegue belne tsa noo tsaka noo ne gu men yra men zeree. ");
INSERT INTO zpi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Zeg gaaymil nak nonchee mgyeey. Per re Ne lo yra xpén Ne: ―Gugue lo men sob men txupchiigue txupchiigue men. ");
INSERT INTO zpi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Lex wkyeen men yra mén guin wzob men. ");
INSERT INTO zpi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Orguin wgoob Ne yra gaay gyëtxtil guin no le yrup mël guin, wkalo Ne gyeybaa, wdee Ne dexkyizhtee lo Dëdyuzh. Wluzh nga wla Ne yra gyëtxtil guin no le yrup mël guin, wdee No lo yra xpén Ne chen ygyiiz meno lo yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wu men yrandxee men axtegue ne wyezaa men, no chene wluzh nga, wsezaa men chibtxup tsegwed yra ne bla ne wrukaa. ");
INSERT INTO zpi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Te dxe chene kanab Jesus lo Dëdyuzh, nonchee yra Ne xpén Ne ndxin, wnabdiiz Ne lo men, re Ne: ―¿Pe re mén txu nak noo? ");
INSERT INTO zpi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wke men re men: ―Nuu men re, Xwa ne rtxobnis nak de; nuuzeg men re, profet-Elías nak de; nuuzeg men re, ka txu ste profet ne wuu chekwlo nak de, laa men wa wban. ");
INSERT INTO zpi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Orguin wnabdiiz Ne lo men ste, re Ne: ―Laa de naa, ¿pe na de txu nak noo? Wke Bëd, re Bëd: ―Laa de nak XeCrist Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Lex re Jesus lo men ne rut lo guedet meno. ");
INSERT INTO zpi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","No re Ne: ―Men ne wdxiid wak Mén, rap men degne kesentyent gak men sufrir, no ylaandet fxuz ne rnebééy lo yra fxuz men yra fxuz maxter ley no le men ne rnebééy lo men-Israel. Yket men men, per chene gyon gbiz, yban ke men. ");
INSERT INTO zpi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Zhich guin re Ne lo men yra men: ―Belne nuu mén rlaan gak xpén noo, rap men degne koleedx men xgyelembán men, chidnal men noo, mase kesentyent gak men sufrir yzaandxee dxe. ");
INSERT INTO zpi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Porke men ne rkaa xgyelembán lextoo, zako perdid; per le men ne rboleedx xgyelembán por ne nak men xpén noo, zap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Pa ykyiin ne gap mén yrandxee ne nuu gyëzlyuree belne laake men rluzh men, laake men rlaa men perdid? ");
INSERT INTO zpi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Belne nuu mén rtuunen ne nak men xpén noo o ne rlaleedx men xdiiz noo, laake no Men ne wdxiid wak Mén ytuunen mén guin chene chiid Men ne wdxiid wak Mén ydebxgyelenzoon Dëdyuzh Xuz men no le yra men xangel Dëdyuzh Xuz men. ");
INSERT INTO zpi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nligue yna noo lo de yra de, ne nuu de zegne ndxin de nee guetetgue sin ne kwiidet de gak ne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chene wluzh zeg xun gbiz ne re Jesus zenga, wyeep Ne te xtoo gyeey chen ynab Ne lo Dëdyuzh; wzano Ne Bëd no le Xwa no le Jacob. ");
INSERT INTO zpi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Or ne kanab Ne lo Dëdyuzh, stelel wtsoow lo Ne, wakngyichdoo xab Ne axtegue wkabnii we. ");
INSERT INTO zpi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tebegue wlalo txup mgyeey ledne zu Ne, kayuu men diiz yra men Ne. Te men nak Moises, ste men nak Elías. ");
INSERT INTO zpi_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kesentyent rkabtsa men yrup men; kayuu men diiz yra men Ne ne che wyob guet Ne Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mase kesentyent zëëden Bëd mkaal yra Bëd xkompanyer Bëd, per wzobna men wii men xgyelenzoon Jesus yra Ne mén guin ne zuno Ne. ");
INSERT INTO zpi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chene le yrup mén guin zabetxee lo Jesus, re Bëd lo Ne: ―Maxter, ¡wen ne zu noo nee gyon noo zeree! Orree yzhexkwaa noo tson guezh: tebo por laa de, stebo por Moises, stebo por Elías. Per ni laa Bëd nandet gan pe rnii Bëd. ");
INSERT INTO zpi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Benak kanii Bëd, tebegue wyab te bëw wrëlo men yra men; kesentyent rdxe Bëd yra Bëd xkompanyer Bëd ne nuu men lad bëw guin yra men. ");
INSERT INTO zpi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lex wlen te rëz lad bëw guin, re we: ―Laa XPee noo nee ne ryaan noo; gugon xdiiz mee. ");
INSERT INTO zpi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wluzhse wlen rëz guin, wii men tete Jesus wyan. Noze wsoow lextoo men yra men, rut lo wuudetgue men diiz neguin ne wii men. ");
INSERT INTO zpi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ne wra gyëël wyët Jesus xtoo gyeey guin yra Ne xpén Ne; kesentyent ndal mén wruu watsëlnëz Ne. ");
INSERT INTO zpi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lad yra mén guin za te mgyeey, ndípse wnii men, re men lo Ne: ―Maxter, gukwii gan penak rzak xpee noo zeree, porke tendxee me rap noo. ");
INSERT INTO zpi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Te menzab rdee lextoo mee, rnegobtsaa men mee, rlaa men ne rzak mee ngyidet gyiz, rnelen men fchiin ruu mee, rzakzi men mee; nadet men yruu men lextoo mee. ");
INSERT INTO zpi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Che wnab noo lo xpén de ne koo men menzab lextoo mee, per wundet men gan. ");
INSERT INTO zpi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Wke Ne re Ne: ―¡Ake menmal ne rlaleedxdet Dëdyuzh! ¿Pa axtegue lalre tyemp ykaa noo lad de no ne gun noo de wantar? Gutano xpee de nee. ");
INSERT INTO zpi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chene le mee guin zabig lo Ne, wtxoon menzab me lyu, wlaa menzab ne wlen xgyiz mee ste; per wakndux Ne lo menzab, wboo Ne menzab lextoo mee, wneseyaken Ne mee, lex wdekwent Ne me lo xuz mee. ");
INSERT INTO zpi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yrandxee mén rzee rzak por yra gyelenzoon ne rlaa Dëdyuzh. Or ne le yra mén ndxin rzee rzak por yra ne rlaa Jesus, re Ne lo yra xpén Ne: ");
INSERT INTO zpi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Gugon neree wen wenendxee no nitleedxdet do. Men ne wdxiid wak Mén, sdekwent mén men lo mén ne yzakzi men. ");
INSERT INTO zpi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per wdeedet men kwent gan pe rna ne re Ne zenga, porke gardet gal ydee men kwento, no wdxe men nnabdiiz men lo Ne gan pe rna diiz guin. ");
INSERT INTO zpi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Zhich guin wzelo xpén Jesus rdildiiz men gan txu men nak men ne mazre nondee lad men yra men. ");
INSERT INTO zpi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ne wyenen Jesus ne rdildiiz men, wlis Ne te mëdwin, wzu Ne mëdwin guin koo Ne. ");
INSERT INTO zpi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Lex re Ne lo men: ―Belne por la noo rukas mén te men ne nak zegnak mëdwinree, noo nga rukas men; no belne rukas men noo, Xuz noo nga ne wxaal noo zëëd noo rukas men. Por neguin men ne zhi non lad de yra de, laa men nak ne mazre nondee. ");
INSERT INTO zpi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Lex re Xwa lo Jesus: ―Maxter, wan noo te mén ne ka kaboo menzab lextoo mén por la de, per wsoow noo porke nuudet men lad be. ");
INSERT INTO zpi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Per re Ne lo men: ―Nsoowdet de; porke mén ne nuudet konter por laa be, xfabor be nuu men. ");
INSERT INTO zpi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chene che wyob gyeep Jesus gyeybaa, wguu xtoo Ne ne zaleen zaleenendxee Ne Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wxaal Ne tebëd xpén Ne wzanergue; wa men te gyëz ne nak lo lyu ne la Samaria chen ye men ledne kwë́z men yra men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Per nadet men-Samaria ndee ledne nbë́z men yra men Ne porke wyenen men ne Jerusalén za men yra men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chene wii Jacob yrup Jacob Xwa ne wlaa yra mén guin zenga, re men lo Ne: ―Dechey, ¿pe rlaan de ynab noo ne ylen gyi gyeybaa yluzho yra ménree zegne wlaa profet-Elías? ");
INSERT INTO zpi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lex wcheree lo Ne, wakndux Ne lo men yrup men, re Ne: ―Laa de nandet de txu lo espíritu ngab de. ");
INSERT INTO zpi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Men ne wdxiid wak Mén zëëdet men ne ygyitxee men xgyelembán mén, sinke le men zëëd ne yselaa men xgyelembán mén. Lex wka Ne nëz za Ne ste gyëz yra Ne men. ");
INSERT INTO zpi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ne za Jesus nëz yra Ne men, re te mgyeey lo Ne: ―Dechey, sanal noo de ledne tsatee de. ");
INSERT INTO zpi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Wke Ne re Ne lo men: ―Mëëz rap ma xebluu maa, maa ne rzhobee rap ma xeftxëës maa; per le Men ne wdxiid wak Mén, yëten men ni ledne gyix xtoo men. ");
INSERT INTO zpi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Lex re Ne lo men ste men: ―Gutanal noo. Per wke men re men: ―Dechey, primer gudee si tsa noo gugyeer noo xuz noo, lex sanal noo de. ");
INSERT INTO zpi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wke Ne re Ne: ―Gudee si gugyeer mengut semengut mengut; per le laa de gutsa yzëët de ne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Lex re men ste men lo Ne: ―Dechey, sanal noo de, per primer gudee si tsaluu noo diiz lo xfamilye noo. ");
INSERT INTO zpi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Per re Ne lo men: ―Men ne rnëëz nii rad, lex rcheree lo men por zhich men, ngyidet men por ne ylaa men ne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chene wluzh wak yra neree, wye Jesus tsonlalno-chii xpén Ne; lex wxaal Ne men txupgue txupgue men, wzanergue men, wa men yra gyëz no le yra den ledne rap Ne degne tsa Ne. ");
INSERT INTO zpi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Lex re Ne lo men yra men: ―Nli ne ndalyaa mén ne rlaan gon xdiiz Dëdyuzh nuu, per yëtet ndal mén ne yzëëto lo men. Por neguin gunab lo Dëdyuzh chen yxaalre Dëdyuzh mén ne yzëëto lo men. ");
INSERT INTO zpi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gutsa, yxaal noo de zegnak mëkzhiil bëën bëënleg lad lob. ");
INSERT INTO zpi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gweeydet de bols, ni med, ni xgyël de, ni sutsëdet de nëz ne guno de mén diiz. ");
INSERT INTO zpi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kwaskyertee lenxyuu mén ne tee de, primer gabtyuzh de men, gue de lo men: “Gyelendxi wlenza lenyuuree.” ");
INSERT INTO zpi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","No belne nuu mén ne nuu lenyuu guin neden gyelendxi guin, che por laa men nako; per belne nedendet meno, por laake de yra de nako. ");
INSERT INTO zpi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nga ruyuu guin ykaa de, logne yniiztee men gu do, goo do, porke mén ne rlaa dxiin rap degne guezh yka men, no ykaadet de yuu por yuu. ");
INSERT INTO zpi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Chene ydxiin de te gyëz ne tsukas mén de, gu de logne yniiztee men; ");
INSERT INTO zpi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","yneseyaken de mengyiz ne nuu nga, no gue de lo men: “Le ne rkyeen Dëdyuzh che zëdyob por laa de yra de.” ");
INSERT INTO zpi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Per belne ydxiin de te gyëz ne rlaandet mén kwii men de, yruu de tsa de runëz, gue de: ");
INSERT INTO zpi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Axtegue xguxyudi laz de ne wkaa nii noo, kwib noo we zegnak te beey ne nadet de nyon de ne rzëët noo. Per gugaknan ne le ne rkyeen Dëdyuzh che zëdyob por laa de yra de.” ");
INSERT INTO zpi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yna noo lo de yra de ne chene ydxiin dxe ne ylaa Dëdyuzh gyelextis, ntozdee sakzi mengyëz guin ke lo men-Sodoma. ");
INSERT INTO zpi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Prob de men-Corazín! ¡Prob de men-Betsaida! Porke belne lad men-Tiro no le lad men-Sidón nyak gyelmilaguer ne wak lad de yra de, che penaadese wsaan men xgyelmal men naa, nbonyoo meno nyak men lër ne rak mén ne ruu gyelgut no ndxiib men di xtoo men. ");
INSERT INTO zpi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Per chene ydxiin dxe ne ylaa Dëdyuzh gyelextis, ntozdee sakzi de ke lo men-Tiro no ke lo men-Sidón. ");
INSERT INTO zpi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Laa de naa men-Capernaum, ¿pe nuu lextoo de ne gyeybaa gya de? ¡Lel axtegue linfyeren gya de! ");
INSERT INTO zpi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Zhich guin re Ne lo xpén Ne ste: ―Log mén ne ykagyedyag ne yzëët de yra de, ne rzëët noo nga rkagyedyag men; mén ne ynadet ykagyedyag ne rzëët de, xdiiz noo nga nadet men ykagyedyag men; men ne nadet ykagyedyag xdiiz noo, xdiiz Dëdyuzh ne wxaal noo zëëd noo nga nadet men ykagyedyag men. ");
INSERT INTO zpi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chene wberee yra tsonlalno-chii mén guin ne wxaal Jesus, kesentyent rzhiilen men, re men lo Ne: ―Dechey, axtegue menzab won xdiiz noo chene wzëët noo la de. ");
INSERT INTO zpi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Lex re Ne lo men: ―Nli we, wii noo pezee wruu Bzelo gyeybaa wyab men gyëzlyu zegnak te ngwzii. ");
INSERT INTO zpi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Noo wniiz poder lo de chen gyichnii de mëël no gyichnii de mëkuu no chen gun de gan ykuudx de ne mal, sin ne bet sakdet de. ");
INSERT INTO zpi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Per yzhiilden de por ne che ron menzab xdiiz de, sinke guzhiilen por ne le la de che kagyiich gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Orke guin kesentyent wzhiilen Jesus por Espíritu Sant, lex re Ne: ―Dëde, laa de ne rnebééy de gyeybaa gyëzlyutee, rzaknon noo de porke wluu de lo men ne nandet yra ne wluudet de lo mennan no lo men ne rdee kwent xgyeryen. Wlaa do Dëde, porke zenga wlaan de ne gako. ");
INSERT INTO zpi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Zhich guin re Ne: ―Laa Xuz noo wniiz yrandxee kos lo noo chen ynebééy noo we. Rut nandet gan txu nak noo, nonchee Xuz noo nano; no rut nandet gan txu nak Xuz noo, nonchee noo nano no le men ne rlaan noo ne gaknano. ");
INSERT INTO zpi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lex wcheree lo Ne nes lo yra xpén Ne, waandxee re Ne lo men: ―Nzoon mén ne rwii neree ne rwii de yra de. ");
INSERT INTO zpi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Porke yna noo lo de, ndal profet no ndal rrey wlaan nwii neree ne rwii de, per wiidet meno, no wlaan men nyon men neree ne ron de yra de, per wondet meno. ");
INSERT INTO zpi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wa te maxter ley wanii men lo Jesus gan pe gue Ne, wnabdiiz men lo Ne, re men: ―Maxter, ¿pagox rap noo degne ylaa noo chen gap noo gyelembán ne nunk luzhdet? ");
INSERT INTO zpi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wke Ne re Ne: ―¿Pagox zëëd lo ley ne wdee Dëdyuzh lo Moises bes? ¿Pezee rdee de kwento? ");
INSERT INTO zpi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wke maxter ley, re men: ―“Gugyaan XDëdyuzh de ydebgyiky ydeblextootee de, ydebxanem de, ydebxfwers de, no gugyaan semén de zegne ryaan ke de de.” ");
INSERT INTO zpi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wke Ne re Ne: ―Wen wke de. Belne rlaa de negwa, zap de gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per kom rlaandet maxter ley yruu xeblaan men, lex re men lo Ne: ―¿Txu nakpee semén noo? ");
INSERT INTO zpi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wke Ne re Ne: ―Wruu te mén Jerusalén za men Jericó, lex wnëëz txup tson ngbaan men, wdee ngbaan xkwent men axtegue wgyixkeben ngbaan men; wgyitxee ngbaan yrandxee ne zaneey men, axtegue xab men wgyitxee ngbaan, lex sya ngbaan. ");
INSERT INTO zpi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Zhich guin wdee te fxuz nga, wii men nex men guin, per noze wdesu men. ");
INSERT INTO zpi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Zenga ke wlaa te mén ne zëëd xnëz Leví, wdee men nga, per nozke wdesu men. ");
INSERT INTO zpi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Per wdee te men-Samaria nga; ne wii men nex men guin, wles lextoo men men; ");
INSERT INTO zpi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","wbig men lo men, lex wlaa men rmed led men ledne nyaan, wguu men seyto yrupo bin, lex wliib men lëro. Wluzh nga wlep men men led xkway men, wdxinno men men ruyuu ledne rbë́z men; nga wapkwent men men. ");
INSERT INTO zpi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chene wra gyëël guin, wboo men medid ne rdxinaa mén txup gbiz, wdee meno lo men ne nako xyuu, re men lo men: “Gugapkwent ménree; belne tenyar de xmed de, noo gyizho chene yberee noo.” ");
INSERT INTO zpi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Orrenaa, delo gyon ménree, guna gan ¿txu menzhe nakpee semén mén guin ne wlaa ngbaan zenga? ");
INSERT INTO zpi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wke maxter ley, re men: ―Men ne wles lextoo mén guin. Lex re Ne: ―Gutsa bes, zenga ke gulaa. ");
INSERT INTO zpi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ne za Jesus nëz yra Ne xpén Ne, wdee Ne te gyëzwin; nga nuu te wnaa ne la Mart. Laa men wdee ruxyuu wbë́z Ne. ");
INSERT INTO zpi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Rap Mart te bël Mart ne la Mli; wzob Mli lo Ne, ron Mli ne rzëët Ne. ");
INSERT INTO zpi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Per le Mart kesentyent nulyaaz Mart gan pezee gak yra xdxiin Mart, lex wbig Mart lo Ne, re Mart: ―Dechey, ¿pe bet zadet lextoo de ne rwii de rsan bël noo yrandxee dxiin lo noo? Gugue lo men gun men xyudar noo. ");
INSERT INTO zpi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Wke Ne re Ne lo Mart: ―Mart, Mart, kesentyent za lextoo de gan pezee gak yra xdxiin de. ");
INSERT INTO zpi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Per tebegue ne mazre rkyiin nuu. Laatee ne mazre rkyiindee wbe Mli, no rut ygyitxeedeto lo Mli. ");
INSERT INTO zpi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tebtir kanab Jesus lo Dëdyuzh; chene wluzh wnab Ne lo Dëdyuzh, re te xpén Ne lo Ne: ―Dechey, guneluu noo ynab noo lo Dëdyuzh zegne wneluu Xwa xpén Xwa. ");
INSERT INTO zpi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wke Ne re Ne: ―Chene rnab de lo Dëdyuzh, zeree gugue: Dëde, laa de ne zob de gyeybaa, kesentyent nzoon la de. Gak zegne rkyeen de. Gak zegne rlaan de nee gyëzlyuree zegne rak ko gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Guseleedx ne gu noo yzaandxee dxe. ");
INSERT INTO zpi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gugun perdon yra xdol noo zegne run noo perdon yra ne mal ne rlaa mén noo. Ydeedet de si ylaa noo ne mal, sinke gukoo noo lo ne mal. ");
INSERT INTO zpi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","No re Ne lo men yra men: ―Yzoopo, belne nuu de te de rap te xmig, lex chiid men lo de gwrool gyëël yna men: “Adxii, guniiz tson gyëtxtil ynab noo, ");
INSERT INTO zpi_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","porke te xmig noo wlenza ruxyuu noo, betlel yëten noo ydee noo gu men.” ");
INSERT INTO zpi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yke de, gue de: “Gunendet de lo noo. Che zemzëë xyuu noo, che nex noo yra noo zhiin noo. Nuudetre tsaxee noo yniiz noo we.” ");
INSERT INTO zpi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yna noo lo de yra de ne belne tsaxeedet de ne ydee de ne rnab men por ne nak men xmig de, per zaxee de ydee de yrandxee ne rkyiinen men por ne ndxiin zu men. ");
INSERT INTO zpi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Por neguin yna noo lo de: Gunab lo Dëdyuzh, laa Ne yseleedx ne rnab de; guye Ne, sël Ne lo de; gukanya txuyaglaa, sxal Ne yaglaa tee de. ");
INSERT INTO zpi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porke men ne rnab lo Ne, laa Ne rseleedx ne rnab men; men ne rye Ne, rzël Ne lo men; men ne rkanya txuyaglaa, sxal Ne yaglaa tee men. ");
INSERT INTO zpi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Zegnak laa de yra de ne nak ngwzan, ¿peguin nuu de rdee te gye lo zhiin de chene rnab ne gyëtxtil lo de? ¿U pe rdee de te mëël lo ne chene rnab ne mël lo de? ");
INSERT INTO zpi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿U peguin rdee de te mëkuu lo ne chene rnab ne dxit lo de? ");
INSERT INTO zpi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Laa de yra de mase mal de no nan de rdee de ne wen lo zhiin de, ¡peleske Dëdyuzh Xuz be ne zob gyeybaa ne yseleedxdet Espíritu Sant gaknonen men ne rnab lo Ne! ");
INSERT INTO zpi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tebtir kaboo Jesus menzab lextoo te mgyeey; laa menzab wsanengup men, no chene le menzab wruu lextoo mén guin, wzelo men wnii men. Kesentyent wzee wzak mén ne wii men neguin. ");
INSERT INTO zpi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Per nuu men re: ―Beelzebu ne rnebééy lo menzab rdee poder lo ménree ne rboo men menzab lextoo mén. ");
INSERT INTO zpi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nuuzeg men por ne ylaa men Ne preb, wnab men lo Ne ne ylaa Ne te gyelmilaguer chen gyakbeey gan pe nli ne Dëdyuzh wxaal Ne. ");
INSERT INTO zpi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Per kom nan Ne gan pe rlebleedx men, lex re Ne lo men: ―Yrandxee gobyeren ne rdil laake xpén, rdiidet gobyeren guin; no yrandxee familye ne rdilelsaa, laake rdiidet men. ");
INSERT INTO zpi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Zenga ke, belne rdilelsaa Bzelo laake yra sebzelo Bzelo, ¿pezee ydii ne rkyeen Bzelo? Na noo neree lo de yra de porke re de ne por xpoder Beelzebu rboo noo menzab lextoo mén; ");
INSERT INTO zpi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","per belne Beelzebu rniiz poder lo noo ne rboo noo menzab lextoo mén, ¿txu rdee poder lo xpén de ne rboo men menzab lextoo mén? Por neguin laake men rbonyoo ne nlidet rnii de. ");
INSERT INTO zpi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Per belne por xpoder Dëdyuzh rboo noo menzab lextoo mén, neguin rna ne le ne rkyeen Dëdyuzh che kayak lad de yra de. ");
INSERT INTO zpi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Chene ndíp te mgyeey rzunzen men xespad men rapkwent men xyuu men, bet rzakdet ne nuu lenxyuu men. ");
INSERT INTO zpi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per belne rdxiin te men ne mazre ndípdee ke lo mén guin, run men gan lo men; rgyitxee men xespad men ne rkalo men, lex rgyiiz men yrandxee xen mén guin. ");
INSERT INTO zpi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Men ne nuudet xfabor noo, rwinyaan men noo; men ne ryedet gan pezee ydaalre xpén noo, rnexoon men xpén noo. ");
INSERT INTO zpi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Chene rruu menzab lextoo mén, zad tsu menzab ledne noze mbidx rkaye menzab ledne yne menzab, per rzëldeto. Lex nuu lextoo menzab: “Mazdee yberee ke noo ledne wruu noo.” ");
INSERT INTO zpi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chene rberee menzab, nak mén guin zegnak te yuu ne noze nexnloob no ne noze xnëz xnëzske nak. ");
INSERT INTO zpi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lex ra menzab raxii menzab sguedx menzab ne mazre ntozdee nak ke lo menzab guin; yra menzab zenga ra rdee lextoo mén guin; mazre ntozdee rak men ke ne nak men chekwlo. ");
INSERT INTO zpi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Or ne le Jesus kazëët yra diizree, wnii te wnaa ne zu lad yra mén nga, ndípse re men: ―¡Nzoon wnaa ne wzan de no ne wguedx de! ");
INSERT INTO zpi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wke Ne re Ne: ―¡Mazre nzoondee men ne ron xdiiz Dëdyuzh no rlaa meno! ");
INSERT INTO zpi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ndalyaa ndalduxtee mén rdxiinre lo Jesus, lex wzelo Ne re Ne lo men: ―Yra mén ne nuu naaree, mal men no le men rnab lo noo ne ylaa noo te gyelmilaguer, per betre gyelmilaguer kwiidet men, nonchee zegne wzak profet-Jonás kwii men. ");
INSERT INTO zpi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Porke zegne wak Jonás te beey por men-Nínive, zenga ke gak Men ne wdxiid wak Mén te beey por yra mén ne nuu naaree. ");
INSERT INTO zpi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","No chene ylaa Dëdyuzh gyelextis, yban wnaa ne wak rrey nes Sur, gue men ne rzëël sakzi yra men ne nuu naaree. Porke kesentyent nat wruu wnaa guin wdxiid men won men logne re rrey-Salomón porke kesentyent nan rrey-Salomón; nee zu te men ne mazre nondee ke lo rrey-Salomón. ");
INSERT INTO zpi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","No chene ylaa Dëdyuzh gyelextis, yban yra men-Nínive, gue men ne rzëël sakzi yra men ne nuu naaree; porke wsaan men-Nínive xgyelmal men chene wzëët Jonás xdiiz Dëdyuzh lo men; nee zu te men ne mazre nondee ke lo Jonás. ");
INSERT INTO zpi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Rut rkaadet te bnii, lex yzu meno ledne ngueedx, ni rtosenruudet men te kaj lo bnii guin, sinke rzobgya meno chen yzenii we lo mén ne tee lenyuu. ");
INSERT INTO zpi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Bzalo me nak zegnak te bnii led me; chene wen bzalo me, ydendxee led me nak zegnak ledne nyenii. Per chene ngyidet bzalo me, ydendxee led me nak zegnak ledne nkeb. ");
INSERT INTO zpi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gugapkwent bnii gwa ne nak bzalo de, tegue gaknkebo. ");
INSERT INTO zpi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Por neguin belne ydendxee led de nak zegnak ledne nyenii no belne axtegue bat nkebdet led de, axtegue mbaale nyenii ydendxee led de cheguin; nako zegnak chene rzenii te bnii lo de. ");
INSERT INTO zpi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Chene wluzhse wnii Jesus, wzano te men ne nak farisew Ne ne tsa Ne gwdu ruxyuu men. Chene wdxiin Ne, wdee Ne wzob Ne lo mezh. ");
INSERT INTO zpi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Wzee wzak farisew chene wii men ne wlaadet Ne zegne nak xkoxtumber men ne nyaa nya Ne antes ne gu Ne. ");
INSERT INTO zpi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Per re Ne lo men: ―Laa de yra de ne nak de farisew, nak de zegnak bas no le zegnak gyaan ne ndaa por led, per le por lenlextoo de teblose gyelegbaan nuu we no le ne mal. ");
INSERT INTO zpi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Nzël de! ¿Pe nandet de ne men ne wzhexkwaa por leen, men guin ke wzhexkwaa por fwer? ");
INSERT INTO zpi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Por neguin mazre guseleedx ne rap de por mén ne yëten ne ykyiinen, chen gaknyoo ne nli wen de. ");
INSERT INTO zpi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Prob de yra de ne nak de farisew! Porke rlachii de bedextil no rlachii de rrud no le yralondxee gyizh ne ru mén, lex rasan de tebchii we por Dëdyuzh, per rlaadet de ne xnëz no ryaandet de Dëdyuzh. Neree nak ne rap de degne ylaa de, sin ne ysalzaandet de negwa ne che rlaa de. ");
INSERT INTO zpi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Prob de yra de ne nak de farisew! Porke rtseleedx de sob de lo yagzhil ne rzob mennon lenydoo no rtseleedx de ne kon gyelenzebnëz gabtyuzh mén de nes lgyeey. ");
INSERT INTO zpi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Prob de yra de ne nak de maxter ley no le yra de ne nak de farisew, gugannaa laa de wen! Per nak de zegnak baa ne nyoodetre nex; rdee mén rgyichnii men ledo sin ne ryenden meno. ");
INSERT INTO zpi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lex wke te maxter ley, re men: ―Maxter, ne re de zegwa, no por noo yra noo rninyaan de. ");
INSERT INTO zpi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wke Jesus, re Ne: ―¡Prob de yra de no de ne nak de maxter ley! Porke rkyeen de mén ylaa men ne gakdetlel ylaa men, no ni laa de zadet lextoo ylaa do. ");
INSERT INTO zpi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Prob de yra de! Porke rzhexkwawen de xbaa profet ne wket laake xpenkwlal de. ");
INSERT INTO zpi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kon neree ne rlaa de, rbonyoo de ne ryan de byen ne wlaa yra xpenkwlal de, porke laa men wket yra profet, le laa de yra de rzhexkwawen xbaa profet guin. ");
INSERT INTO zpi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Por neguin re Dëdyuzh ne nan yrandxee ne gak: “Yxaal noo profet lad men no le poxter; nuu profet no nuu poxter yket mén men; nuuzeg men kwinyaan mén men.” ");
INSERT INTO zpi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Por neguin lo yra mén ne nuu naaree ynab Dëdyuzh kwent por ne wket xpenkwlal men profet ne wuu desde ne waa gyëzlyu, ");
INSERT INTO zpi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","desde Abel axtegue Zacari ne wet guex lo fkuuk lenxeydoo Dëdyuzh. Por neguin na noo ne lo mén ne nuu naaree ynab Dëdyuzh kwent por xren mén guin. ");
INSERT INTO zpi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Prob de yra de ne nak de maxter ley! Porke rdeedet de si gaknan mén gan pezee gak men xpén Dëdyuzh, no ni laa de rakdet xpén Ne, ni rdeedet zeg de si ne gak mén ne rlaan gak xpén Dëdyuzh xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Chene wluzh re Jesus yra diizree, kesentyent wlayaa maxter ley lo Ne yra men men ne nak farisew. Lex wzelo men noze ndal ne wnabdiiz men lo Ne, ");
INSERT INTO zpi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","chen gan pe gue Ne, chen tsël gan pezee ykagyii men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Zhich guin kesentyent ndal mén wdop lo Jesus, por mil wdop men, noze renelsaa men. Lex wzelo Jesus re Ne primerdee lo yra xpén Ne: ―Gugap kwent lo xlebadur men ne nak farisew. Neree rna gugap kwent lo men ne nak farisew porke noze rkanlo men wen men. ");
INSERT INTO zpi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Porke bet ne ngueedx yët ne yrunyoodet, ni yët ne rak rlaanguel ne gaknandet mén. ");
INSERT INTO zpi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Por neguin yrandxee ne re de lo nkeb, zakzëëto yedxe; no yrandxee ne re de rlaanguel por lenyuu, zakzëëto por led yuu. ");
INSERT INTO zpi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Yna noo lo de yra de ne nak de xmig noo, ne ydxedet de mén ne rap poder yket de, waldegue bet gundet men gan ylaa men no xanem de. ");
INSERT INTO zpi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Per yzëët noo lo de gan txu nak ne rap de degne ydxe de: gudxe Dëdyuzh porke laa Ne rap poder yket de, no luzh nga, yxaal ke Ne de linfyeren. Nli we, Dëdyuzh nak ne rap de degne ydxe de. ");
INSERT INTO zpi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Gukwii zegnak mgyinwin; gaay maa rdoo por txup medwin. Per rnitleedxdet Dëdyuzh ma ni te maa. ");
INSERT INTO zpi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Le laa de yra de, axtegue gyitsxtoo de yrandxoo ngab lo Dëdyuzh. Por neguin ydxedet de, porke laa de nondee ke lo ndal mgyinwin. ");
INSERT INTO zpi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Yna noo lo de yra de, mén ne rzëët lo mén ne xpén noo nak men, laake no Men ne wdxiid wak Mén yzëët lo yra xangel Dëdyuzh ne xpén men nak mén guin. ");
INSERT INTO zpi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Per le mén ne rzëëdet lo mén ne xpén noo nak men, laake no Men ne wdxiid wak Mén yzëëdet lo xangel Ne ne xpén men nak mén guin. ");
INSERT INTO zpi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Log mén ne rnii diznyaan por Men ne wdxiid wak Mén, zak men perdon; per le men ne rnii diznyaan por Espíritu Sant, nunk gakdet men perdon. ");
INSERT INTO zpi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Chene tsazu mén de lenydoo o lo jwes o lo xtis, bet tsadet lextoo de gan pe yke de o gan pe gue de, ");
INSERT INTO zpi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","porke chene ydxiin orguin, laa Espíritu Sant yseleedx logne gue de. ");
INSERT INTO zpi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Lad mén ne ndxin nga, wruu te men ne re lo Jesus: ―Maxter, gugue lo bech noo yniiz men ne ryal noo ne wsan xuz noo por noo. ");
INSERT INTO zpi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Per wke Jesus, re Jesus lo men: ―Adxii, ¿txu wzu noo nee ne ylaa noo gyelextis u ne ygyiiz noo ne ryal mén? ");
INSERT INTO zpi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","No re Ne lo men yra men: ―Gugap kwent lo yralondxee gyelendeblextoo, porke mase rap xen mén, per let laadeto nak xgyelembán mén. ");
INSERT INTO zpi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Lex wuu Ne zegnak te kwent lo yra mén guin, re Ne: ―Tebtir wuu te mgyeey ne rik; kesentyent wak yra ne wguu men lo xelyu men. ");
INSERT INTO zpi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Lex wzob menrik guin wlebleedx men, re men: “¿Pezee ylaaleg noo? Yëten noo ledne gutsoow noo yra ne wak lo xelyu noo.” ");
INSERT INTO zpi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Lex re men: “Che nan noo pezee ylaa noo; ychil noo yra xdoow noo, lex ytsoow noo ne mazre nzhoodee; nga gutsoow noo yrandxee ne wak lo xelyu noo no le yrandxee ne rap noo. ");
INSERT INTO zpi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Zhich guin gue noo lo ke noo: Kesentyent ndal ne rap de, zuno wantar ndal iz. Gune, gugu, gugootee, guzhiilen.” ");
INSERT INTO zpi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Per re Dëdyuzh lo men: “Nzël de, negyëëlkeree guet de. ¿Txuzh gyanno yrandxee negwa ne ngutsoow de?” ");
INSERT INTO zpi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Zenga rzak yra mén ne rgutsoow yra ne rap men por laake men, per bet yëten men nes lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Zhich guin re Jesus lo xpén Ne: ―Por neguin yna noo lo de: Bet tsadet lextoo de ne gan pe gu de chen ybán de, ni por lër ne gak de. ");
INSERT INTO zpi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Porke gyelembán nak ne mazre nondee ke lo ne ru me no led me nak ne mazre nondee ke lo xab me. ");
INSERT INTO zpi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gukwii zegnak myaak; rguudet ma bni, ni rkaadet ma kwlaap, ni yëten ma ledne tsutsoowo, ni yëten ma doow, no rseleedx Dëdyuzh ne ru maa. ¿Pe let laadet de yra de nak ne nondee ke lo maa? ");
INSERT INTO zpi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","No ¿txu laa de ne kesentyent rlebleedx gun gan ytsowngoolre xgyelembán? ");
INSERT INTO zpi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Belne rundet de gan ylaa de ne beeytee nak, ¿penak rlebleedx de gan pe ykyiinen de? ");
INSERT INTO zpi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Gukwii pezee rroo gyechil; rlaadeto dxiin, ni rzhexkwaadeto lër, no yna noo lo de ni rrey-Salomón mase mazre zhaandxee wnaa xab men, per wnaadet men zegne rnaa gyee guin. ");
INSERT INTO zpi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Belne zenga rlazhaandxee Dëdyuzh gyizh ne nuu den nedxeree, le yzhe le we che ke reeky leen oren, ¡peleske laa de ne ygakxabdet Dëdyuzh de, ake mén ne rlaleedxdet Dëdyuzh ydeblextoo! ");
INSERT INTO zpi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Por neguin ykalebleedxdet de gan pe gu de, gan pe goo de; bet tsadet lextoo de. ");
INSERT INTO zpi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Porke mén ne zadet xnëz Dëdyuzh, yra neree nak ne za lextoo men; per le laa de yra de, rap de Dëdyuzh Xuz be ne nan ne rkyiinen de yra neree. ");
INSERT INTO zpi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Per guye gan pezee ylaa de ne rkyeen Dëdyuzh, lex laa Ne yseleedx yra neree lo de. ");
INSERT INTO zpi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Ydxedet de yra de zegne nak de xpén noo. Zhindxee de, per laa Dëdyuzh Xuz be wlaan ne no de ynebééy ledne rnebééy Ne. ");
INSERT INTO zpi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gutoo ne rap de, lex gudee med lo mén ne rzak lyaaz; guye gan pezee gap de ne non ne nunk luzhdet ne nuu gyeybaa, ledne rdeedet ngbaan kwano no ledne rluzhdet mlaa we. ");
INSERT INTO zpi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Porke ledne nuu ne mazre nondee por laa de, nga ke nak ledne mazre zadee lextoo de. ");
INSERT INTO zpi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’List gusu yra de; ysuudet de bnii. ");
INSERT INTO zpi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gusu zegne rzu te mos ne noze kambë́z gan pa or yberee xpatron men ne za te dooy, chen yxal men yuu zegne ykanya xpatron men txuyaglaa or ne yberee xpatron men. ");
INSERT INTO zpi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nzoon yra mos ne chene ydxiin xpatron men, le men zobna. Nligue yna noo lo de yra de ne skaa xpatron men mandil lo xab xpatron men, lex yzoob xpatron men men lo mezh, gaa xpatron men nesyaa gu men. ");
INSERT INTO zpi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nzoon men belne ydxiin xpatron men gwrool gyëël o wkebre, le men benak zobna. ");
INSERT INTO zpi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","No gugaknan neree, ne belne nan xpexwaan te yuu gan pa or ydxiin ngbaan tee ngbaan kwan ngbaan lenxyuu men, sobna men ydeedet men si tee ngbaan kwan lenxyuu men. ");
INSERT INTO zpi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Zenga ke laa de yra de, list gugak; porke te dxe ne axtegue ni kambë́zdet de Men ne wdxiid wak Mén, chiid men. ");
INSERT INTO zpi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Lex wnabdiiz Bëd lo Jesus, re Bëd: ―Dechey, ¿pe noze por noo yra noo re de negwa u no por yrandxee mén re do? ");
INSERT INTO zpi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Lex re Ne: ―¿Txu nak te moswen? Laa men nga nak te men ne noze list zu ne rsan xpatron men yra xmos xpatron men lo men chen ydee men ne gu xmos xpatron men or ne ryal gu men. ");
INSERT INTO zpi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nzoon mos guin ne chene rberee xpatron men, le men kalaa dxiin ne ryal ylaa men. ");
INSERT INTO zpi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nligue yna noo lo de yra de ne su xpatron men men ynebééy men yrandxee ne rap xpatron men. ");
INSERT INTO zpi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per belne nuu lextoo mos guin ne ybereedetgue xpatron men, rzelo men rzakzi men semos men, mos mgyeey mos wnaatee, le laa men rzob ru rootee, axtegue rzudxen men. ");
INSERT INTO zpi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Laatee te dxe ne axtegue ni kambë́zdet men xpatron men, ydxiin xpatron men no te or ne axtegue ni nandet men ne ydxiin xpatron men. Kesentyent yzakzi xpatron men men, yxaal xpatron men men ledne rya yra mén ne rlaleedxdet Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Mos ne nan gan pe rlaan xpatron men ylaa men, per rzudet men noze list, ni rlaadet men zegne rlaan xpatron men, kesentyent sakzi mos guin. ");
INSERT INTO zpi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Per le mos ne nandet gan pe rlaan xpatron men ylaa men, lex rlaa men ne rzëël sakzi men, beeytee sakzi men. Porke men ne wseleedx Dëdyuzh gyelenyenii lo, ntozdee ndal ne rap men degne ylaa men. Zenga ke men ne wdee Dëdyuzh poder lo, ntozdee ndal ne gakgyii Dëdyuzh lo men. ");
INSERT INTO zpi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Zëëd noo nee gyëzlyuree zegnak men ne rzobgyi pagoxtee; no ¡zoon noo naal pezee ykagyigoo! ");
INSERT INTO zpi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Rap noo degne sak noo te gyelnaroo, no ¡kesentyent baanske nuu lextoo noo axtegue ne le we gak! ");
INSERT INTO zpi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Pe nuu lextoo de yra de ne gyelendxi zëdneey noo gyëzlyu? Yna noo lo de ne zëdneeydet noo gyelendxi, sinke le noo zëdneey dil. ");
INSERT INTO zpi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Porke desde nedxeree, gaay mén ne nak te familye tilelsaa, tson men gaken tilno txup men, txup men gaken tilno tson men. ");
INSERT INTO zpi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ngwzan-mgyeey tilno laake xpee, le xpee men tilno laake xuz; ngwzan-wnaa tilno laake xsaap, le xsaap men tilno laake xnaa; le ngwzhizh tilno laake xnasweguer, le xnasweguer ngwzhizh tilno laake ngwzhizh. ");
INSERT INTO zpi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","No re Jesus lo yra mén guin: ―Chene rwii de yra de ne ryas bëw nes ledne raaz ngbiz, nan de, syab gyo, no zenga rak. ");
INSERT INTO zpi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","No chene rlen mee nes sur, nan de, neey gak, no rak neey. ");
INSERT INTO zpi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Gugannaa laa de nan! Belne rdee de kwent gan pe rna beey ne ruu zhinybaa no ne ruu gyëzlyu, ¿pezee rdeedet de kwent gan pe rna yra ne kayak lad de yra de naaree? ");
INSERT INTO zpi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Penak ryenden de laake de gan gonezhe nak ne xnëz? ");
INSERT INTO zpi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Belne nuu mén rdxig de lo xtis, guye gan pezee gyan de diiz yrup de men antes ne ydxig men de lo xtis; porke belne ydxig men de lo xtis, sdekwent xtis de lo polisi, chen ysee men de chegyiib. ");
INSERT INTO zpi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ynague noo lo de ne yruudet de chegyiib axtegue ne gyizh de laltee ne ynab xtis lo de. ");
INSERT INTO zpi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Cheguin ke wa tebëd mén lo Jesus, wuu men diiz ne wket Pilato tebëd men-Galilea. Lex wgoots Pilato xren men yra we xren maa ne wseleedx yra mén guin por Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Lex re Jesus lo men: ―¿Pe nuu lextoo de ne por ne ntozdee zeeb mén guin dol ke lo yra men-Galilea, neguin wzak men zenga? ");
INSERT INTO zpi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yna noo lo de yra de ne let zengadeto. Belne laa de ne ysaandet de xgyelmal de, laake zenga ke sak de. ");
INSERT INTO zpi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿U nuu lextoo de ne chene wet chimtson men-Jerusalén ne watxee torre ne zob ledne la Siloé led, ntozdee zeeb men dol ke lo yra men ne nuu Jerusalén? ");
INSERT INTO zpi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yna noo lo de yra de ne let zengadeto. Belne laa de ne ysaandet de xgyelmal de, laake zenga ke sak de. ");
INSERT INTO zpi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lex wuu Jesus zegnak te kwent lo men, re Ne: ―Rap te mgyeey tebzhaan yag-ig lo xelyu men ledne rap men blag ub, lex wa men wii gan pe ka ig lo we, per bet ig wzëldet. ");
INSERT INTO zpi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lex re men lo men ne rapkwent lyu guin: “Gukwii gante, che wyon iz zëëd noo zëdye noo ig lo yagree, per bet ig rzëldet lo we. Gutxuugo, porke noze rlanxii we lo lyu.” ");
INSERT INTO zpi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wke mén guin ne rapkwent lyu guin, re men: “Dechey, zeguezobleso ste izree, ne yseyul noo yu zhiino, lex guu noo beebo. ");
INSERT INTO zpi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pazer skaa nex lo we. Belne ykaadet nex lo we, lex ytxuug bo.” ");
INSERT INTO zpi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Te dxe ne rne men-Israel, kaneluu Jesus mén leen te ydoo. ");
INSERT INTO zpi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nga zob te wnaa ne che wzaa chimtson iz rzhuun. Laa te menzab nak ne wsanmëg men, axtegue rakdetlel gaknli men. ");
INSERT INTO zpi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Chene wii Jesus men, wbëz Ne men, lex re Ne lo men: ―Wnaae, che wbëz gyelgyiz gwa ne rzak de. ");
INSERT INTO zpi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Lex wxob nya Ne led men; orgueguin waknli men. Wzelo men rzaknon men Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Per kesentyent wlayaa mén ne rnebééy lenydoo guin por ne wneseyaken Ne wnaa guin dxe ne rne men-Israel, lex re men lo yra mén: ―Xuup dxe ne rak dxiin nuu; dxe guin gutaa gak de rmed, chiidet de dxe ne rne be. ");
INSERT INTO zpi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Lex wke Ne re Ne: ―¡Gugannaa laa de wen! ¿Pe rchildet de xyuz de u xbur de dxe ne rne be chen tsano de ma gonis? ");
INSERT INTO zpi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Le wnaaree naa ne zëëd xnëz Abraham ne che wzaa chimtson iz rlaa Bzelo ne rzhuun men, ¿peguin nuudet gyaken men dxe ne rne be? ");
INSERT INTO zpi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chene re Ne zenga, wtuunen yra mén ne rlaa lo Ne. Per le yra mén rzhiilen men ne rwii men yra ne nzoon ne rlaa Ne. ");
INSERT INTO zpi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","No re Jesus: ―¿Pagox rzaglo ne rkyeen Dëdyuzh? ¿Pagox ynesaglo noo we? ");
INSERT INTO zpi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Rzaglo we te medx lyagwlizh ne rlabni te mén lo xelyu men. Rroo we axtegue rako zegnak tebzhaan yag, ra mgyin rzhexkwaa ma xeftxëës ma zhuuko. ");
INSERT INTO zpi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Lex re Jesus ste: ―¿Pagox ynesaglo noo ne rkyeen Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Rzaglo we lebadur ne rgoots te wnaa tson medid rin chen ynesegyi we yrandxee ngob. ");
INSERT INTO zpi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Chene za Jesus Jerusalén, rneluu Ne mén yra gyëzwin gyëznzhootee ne rdee Ne. ");
INSERT INTO zpi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lex wnabdiiz te mén lo Ne, re men: ―Dechey, ¿pe zhindxee mén yláá lo dol? Wke Ne re Ne: ");
INSERT INTO zpi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Guye gan pezee tee de nes ruyaglanzun; porke yna noo lo de ne ndalyaa mén ylaan tee, per gakdet tee men. ");
INSERT INTO zpi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Chene le mén ne nako xyuu che waxee wtsëë yuu, yra de belne wyan de fwer, ykanya de txuyaglaa; lex gue de: “Dechey, guxal yuu tee noo.” Per yke men, yna men lo de: “Nandet noo txu ménzhe de.” ");
INSERT INTO zpi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Lex selo de gue de lo men: “Wu noo, woo noo yra noo de, no wneluu de noo ledne nak ruxnëz noo.” ");
INSERT INTO zpi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Per yke men, yna men lo de: “Che na noo lo de ne nandet noo txu ménzhe de. Gubetxee lo noo, mendol.” ");
INSERT INTO zpi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nga goon de axtegue guleey de ne kwii de le Abraham, le Isaac, le Jacob, no le yra profet nuu ledne rnebééy Dëdyuzh, le laa de wyan fwer. ");
INSERT INTO zpi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Porke sdxiin mén ne nuu ydendxee gyëzlyu sob men gu men ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","No ndal men ne nak men lultim naaree, gak men primer; no ndal ke men ne nak men primer, gak men lultim. ");
INSERT INTO zpi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dxe ke guin wdxiin tebëd men ne nak farisew, re men lo Jesus: ―Guruu nee, gugya, porke le Herodes rlaan yket de. ");
INSERT INTO zpi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wke Ne re Ne lo men: ―Gutsa gue de lo mëëzro nak Herodes: “Nedxeree no le yzhe koo noo menzab lextoo mén no yneseyaken noo mengyiz; wiz gyal noo.” ");
INSERT INTO zpi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Per rap noo degne tsa noo ledne ryal tsa noo nedxeree, yzhe lee no le wiz, porke nuudet guet te profet ste gyëz belne nakdeto gyëz-Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Men-Jerusalén, men-Jerusalén, ne rket profet no ne rgugye men ne wxaal Dëdyuzh lad de yra de! ¡Blazhtee tir wlaan noo ntop noo de yra de zegne rtop ngyed zhiin ngyed rguu ma ma lenxpaan maa, per nadet de! ");
INSERT INTO zpi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Por neguin noze nles gyan laz de; no yna noo lo de yra de, ne kwiidetre de noo axtegue ne ydxiin dxe ne gue de: “¡Dëdyuzh gaknonen men ne zëëd por la Dëdyuzh!” ");
INSERT INTO zpi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Te dxe ne rne men-Israel, wa Jesus gwdu ruxyuu te men ne nak farisew ne rnebééy. Le stebëd farisew noze kaleedx gan kox ylaa Ne. ");
INSERT INTO zpi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nga nes lo Ne zob te mgyeey ne nuu gyi. ");
INSERT INTO zpi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Lex wnabdiiz Ne lo maxter ley no le lo yra men ne nak farisew, re Ne: ―¿Pe zak yneseyaken me te mengyiz dxe ne rne me u gakdeto? ");
INSERT INTO zpi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per noze chi wzob men yra men, wkedet men. Orguin wnëëz Ne nya mén guin, wneseyaken Ne men, lex re Ne lo men ne gya men. ");
INSERT INTO zpi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Zhich guin re Ne lo men ne nak farisew: ―Belne nuu de te de gyab te xbur o te xyuz te leen pos dxe ne rne be, ¿pe tsaloodetgue de ma orgueguin? ");
INSERT INTO zpi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Axtegue wkedet men. ");
INSERT INTO zpi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chene wii Jesus pezee rbe mén lo mezh ledne rzob mennon chen sob men, re Ne lo men: ");
INSERT INTO zpi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Chene rbëz mén de ne tsa de te dooy, sobdet de ledne rzob men ne nondee, porke tegue ydxiin ste myooz ne mazre nondee ke laa de. ");
INSERT INTO zpi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Lex chiid men ne wbëz de yrup de mén guin, yna men lo de: “Gudee ledne zob de sob ménree.” Rap de degne suli de nga; kon gyelentu tsa de sob de axtegue lultim. ");
INSERT INTO zpi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Por neguin chene rbëz mén de ne tsa de te dooy, axtegue lultim gusob, chen chene chiid men ne wbëz de, yna men lo de: “Mig, gutee sob de ledne zob men ne nondee.” Zenga gyeep xeblaan de nes lo yra mén ne zob lo mezh. ");
INSERT INTO zpi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porke yra mén ne nuu lextoo non men, men guin gaknondet; le men ne nuu lextoo bet nondet, men guin gaknon. ");
INSERT INTO zpi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","No re Ne lo mén guin ne wbëz Ne ne tsa Ne gwdu: ―Chene rtsoow de te kwe o te xsëë, kwëzdet de men ne nak xmig de, ni men ne nak bech de, ni xparyent de, ni menrik ne nuu guex ruxyuu de, porke tegue no men ytsoow te nesyaa, lex kwëz men de tsa de gwdu ruxyuu men, chen ycheree men ne wdee de wu men. ");
INSERT INTO zpi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mazdee chene rlaa de te lni, gukwëz menprob, menbeer, mennguzh, menngwlëë, ");
INSERT INTO zpi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","chen zenga gaknzoon de, porke men guin gundet gan ycheree ne wlaa de por laa men; per chene yban yra mén ne wbán xnëz, Dëdyuzh yniiz ne ryal de. ");
INSERT INTO zpi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chene won te mén ne zobno Jesus lo mezh ne re Ne zenga, re men lo Ne: ―¡Nzoon men ne sob gu ledne rnebééy Dëdyuzh! ");
INSERT INTO zpi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Lex re Ne lo men: ―Te mgyeey wzhexkwaa men te xsëë, lex re men lo ndalyaa mén ne tsa men gwdu ruxyuu men. ");
INSERT INTO zpi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chene le or ne guxsëë men wdxiin, wxaal men mén ne rlaa dxiin lo men, wa men re men lo yra mén guin: “Gutaa yra de porke le xsëë che nuu.” ");
INSERT INTO zpi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Per wzelo men yra men wren wren ne rak men gyii. Men primer re: “Gyed wkandxee noo tebla lyu; rap noo degne tsa noo wii we. Ynab noo lo de ne gue de lo men ne gundet noo gan tsa noo.” ");
INSERT INTO zpi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Le ste men re: “Gyed wkandxee noo gaay nëz yuz; le noo tsalaa ma preb. Ynab noo lo de ne gue de lo men ne gundet noo gan tsa noo.” ");
INSERT INTO zpi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Le ste men re: “Gyed wtsëlnyandxee noo; gundet noo gan tsa noo.” ");
INSERT INTO zpi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Chene wberee mén guin ne rlaa dxiin, re meno lo xpatron men. Wlaa xpatron men. Lex re xpatron men lo men: “Gyiid gyiidske gutsa runëzyu runëzlestee ne za lenlgyëz, gutsaxii menprob, menbeer, mennguzh, menngwlëë.” ");
INSERT INTO zpi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chene wberee mén guin ne rlaa dxiin lo men, re men lo xpatron men: “Dechey, che wlaa noo zegne wkyeen de, no benak nuur lugar lenyuu.” ");
INSERT INTO zpi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Lex re xpatron men lo men: “Gutsa yde runëz wa no le yde runëznii; gukyeen stebëd mén chiid men, chen gyezaa lenxyuu noo. ");
INSERT INTO zpi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Porke yna noo lo de ne ni te mén ne wbëz noo primer, gudet xsëëree ne wtsoow noo.” ");
INSERT INTO zpi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ndalyaa mén zanal Jesus; lex wcheree lo Ne, re Ne lo men: ");
INSERT INTO zpi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Belne nuu mén zëdnal noo, per ryaandet men noo mazre ke lo xuz men, ke lo xnaa men, ke lo xewnaa men, ke lo zhiin men, ke lo bech men, ke lo bzaan men, o ke lo men laake men, gakdet gak men xpén noo. ");
INSERT INTO zpi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Men ne zëdnal noo, per rlaandet men gak men sufrir, gakdet gak men xpén noo. ");
INSERT INTO zpi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Yzoopo, belne nuu mén rlaan ylep te yuu ne nzhoo, ¿peguin rzobdet men ylebleedx men primer gan palal yrukaa we, chen kwii men gan pe zaglo ne nzen men por ne yzalo meno? ");
INSERT INTO zpi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tegue chene che wgyix men simyent, gundet men gan yzalo meno; yrandxee mén ne wii wgyix men simyent, selo men yzhidxno men men, ");
INSERT INTO zpi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","gue men: “Noze wzelo ménree wlep men yuuree, per wundet men gan nzalo meno.” ");
INSERT INTO zpi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O belne tsa te rrey tilno ste rrey, ¿peguin rzobdet men ylebleedx men primer gan pe zun chiimil xsoldad men gan tilno men men ne zano galmil soldad? ");
INSERT INTO zpi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Belne ryenen men ne gundet men gan lo ste rrey guin, sxaal men mén ne tsa ynii diztsoow lo rrey guin chene benak zu men nat, chen gyakchi xdil men. ");
INSERT INTO zpi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Zenga ke kwaskyertee mén ne rlaandet koleedx ne rap, gakdet gak men xpén noo. ");
INSERT INTO zpi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Zëd, ne wen nako; per belne gaknzhidetro, ¿pezee gak gaknzhi we ste? ");
INSERT INTO zpi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Batre ykyiindeto, ni por ne gako yu, ni por ne tsa we lad beeb, sinke noze ysee méno. Men ne rkagyedyag diiz, gon men neree ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wbig yra men ne rgoob zeg impwest lo Jesus yra men stebëd mendol, chen gon men ne rzëët Ne. ");
INSERT INTO zpi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lex wzelo yra men ne nak farisew yra men maxter ley rnii men por laa Ne, re men: ―Ménree rtsëlsaa men mendol no ru men yra men men. ");
INSERT INTO zpi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Lex re Ne lo men yra men: ");
INSERT INTO zpi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Yzoopo, belne nuu mén rap tebgwyuu mëkzhiil, lex gyab ma te maa. ¿Peguin ysandet men taplalno-chimtap ma guin den chen tsaye men ma ne wyab axtegue ne tsël maa? ");
INSERT INTO zpi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Le chene le ma rzël lo men, rzhiilen men, rxobyen men maa. ");
INSERT INTO zpi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Chene rdxiin men ruxyuu men, rtop men yra xmig men no le yra men ne nuu guex ruxyuu men, lex nan men lo mén guin: “Guzhiilen zegne rzhiilen noo, porke le xpëkzhiil noo ne wyab, le ma che wzël.” ");
INSERT INTO zpi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yna noo lo de yra de ne zenga ke kesentyent nuu gyelgwzhiil gyeybaa por te mendol ne rsaan xgyelmal, ke por taplalno-chimtap menwen ne che rkyiindetre ysaan xgyelmal. ");
INSERT INTO zpi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’O yzoopo, nzen te wnaa chii med plat, lex wyabo tebo. ¿Pe ykaadet men bnii, lex yloob men xyuu men chen ye meno chelo chelondxee axtegue ne tsëlo lo men? ");
INSERT INTO zpi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","No chene le we rzël, rtop men yra xmig men no le yra men ne nuu guex ruxyuu men, lex nan men lo mén guin: “Guzhiilen zegne rzhiilen noo, porke le xmed noo ne wyab, le we che wzël.” ");
INSERT INTO zpi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yna noo lo de yra de ne zenga ke rzhiilen yra xangel Dëdyuzh por te mendol ne rsaan xgyelmal. ");
INSERT INTO zpi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","No re Jesus lo yra mén guin: ―Te mgyeey rap men txup xpee men. ");
INSERT INTO zpi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Lex re mewindee lo xuz mee: “Dëde, guniiz ne ryal noo.” Orguin wdee xuz me ne ryal me te te mee. ");
INSERT INTO zpi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Zhichegue wako, wtoo mewindee yrandxee ne ryal mee, lex kon med guin wruu me sya me nat ledne wdenyaxla mee we yrandxoo, porke wbán me zegne rlaantee mee. ");
INSERT INTO zpi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Chene che wdenya yra xmed mee, wuu gbiin nga ledne nuu mee; wzëldetre ne nyu mee. ");
INSERT INTO zpi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wruu me waye me dxiin lo te mgyeey ne nuu nga, lex wxaal men me xden men chen gapkwent me kuch. ");
INSERT INTO zpi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Baanske rlaan me gu me ne ru kuch, per rut rdeedeto gu mee. ");
INSERT INTO zpi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wyal wdebo, wzob me wlebleedx mee, re mee: “¡Blazhtee mos rap xuz noo ruxyuu me, no axtegue sober rak ne ru men, le noo ka nee retgbiin! ");
INSERT INTO zpi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mazdee yberee noo lo xuz noo, gue noo lo me: Dëde, noze xdol noo wye noo nes lo Dëdyuzh no le nes lo de; ");
INSERT INTO zpi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","che rzëëldetre noo ne ynii de noo zhiin de, gugun noo kwent zegnak te xmos de.” ");
INSERT INTO zpi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Lex wka me nëz sya me ruxyuu xuz mee. ’Benak natre za mee le xuz mee che wii mee. Orguin wles lextoo men mee, noze rzhoon men wa men wtsëlo men mee, wgyeedx men mee, woo men bzhid gyedkwes mee. ");
INSERT INTO zpi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Lex re me lo men: “Dëde, noze xdol noo wye noo nes lo Dëdyuzh no le nes lo de; che rzëëldetre noo ne ynii de noo zhiin de.” ");
INSERT INTO zpi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per re xuz me lo xmos men: “Gyiid gyiidske gukoo lër ne mazre wendee gunegak xpee noo, no gusee te nil xkwen mee, no gukaa gyël nii mee. ");
INSERT INTO zpi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Gutsaxii yuz ne mazre rroodee, guket maa. ¡Gu be, ylaa be te lni! ");
INSERT INTO zpi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Porke xpee noo meree, por noo che wet mee, orree le me wban; che wyab mee, no le me wzël ke.” Lex wzelo men wlaa men lni. ");
INSERT INTO zpi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Le xpee men megol za den; chene wberee me ne wdxiin me guex ruyuu, won me rool musk no rya mén. ");
INSERT INTO zpi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Lex wbëz me te xmos xuz mee, wnabdiiz me lo men gan kox rak. ");
INSERT INTO zpi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Orguin re men lo mee: “Rongue de, le bech de wberee; lex neguin wkyeen xuz de wet te yuz ne mazre rroodee, porke wen ngyëëltee me wlenza mee.” ");
INSERT INTO zpi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Per wlaa megol ne won megol zenga; nadet me ndee me lenyuu. Wap xuz me degne wruu men, wanab men lo me ne tee mee. ");
INSERT INTO zpi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Orguin re me lo xuz mee: “Laa de nan de gan blazh iz kalaa noo dxiin lo de no yrandxee xdiiz de ron noo, per nunk gardet yniiz de mase te chibwin yket noo gu noo yra noo xmig noo. ");
INSERT INTO zpi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Per le naaree ne wlenza xpee de ne watenyaxla xmed de lo yra wnaa ne rkano wren wren mgyeey, le de wket yuz ne mazre rroodee por laa mee.” ");
INSERT INTO zpi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Orguin re xuz me lo mee: “Zhiin, yzaandxee dxe zu de lo noo, no yrandxee ne rap noo, xen de nako. ");
INSERT INTO zpi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per orree kesentyent rzëël ne ylaa be lni no rzëël ne yzhiilen be, porke por noo, le bech de ne che wet, le zhaa wban; che wyab zhaa, no le zhaa wzël lo be ste.” ");
INSERT INTO zpi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","No re Jesus lo yra xpén Ne: ―Wuu te menrik ne rap te mos ne rapkwent yrandxee ne rap menrik guin, lex wa mén wa gue mén lo men ne noze rxiin mos guin yrandxee xen men. ");
INSERT INTO zpi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Lex wbëz men mos guin, re men lo men: “¿Pagox gwa ron noo diiz kalaa de? Guniiz kwent yra dxiin ne rlaa de, porke gakdetre gak de xmos noo.” ");
INSERT INTO zpi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Orguin wzob mos guin wlebleedx men, re men: “¿Pezee ylaaleg noo naaree ne ygyitxee xpatron noo dxiin lo noo? Rundet noo gan ylaa noo dxinden no rtuunen noo ynab noo goon. ");
INSERT INTO zpi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Per che nan noo gan pezee ylaa noo chen gap noo mén ne yniiz ruxyuu ykaa noo chene ygyitxee men dxiin lo noo.” ");
INSERT INTO zpi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Lex wbëz men tegue tegue mén ne zeeb lo xpatron men. Wnabdiiz men lo men ne wdxiin primer, re men: “¿Palal zeeb de lo xpatron noo?” ");
INSERT INTO zpi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wke men re men: “Tebgwyuu barril seyt zeeb noo.” Lex re mos guin lo men: “Le xgyiich de ne ka ne zeeb de nee, gyiid gyiidske guzhexkwaa stebo; guzoob lo we ne txupchii ko zeeb de.” ");
INSERT INTO zpi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Zhich guin wnabdiiz men lo men ste men, re men: “Laa de naa, ¿palal zeeb de?” Wke men re men: “Noo zeeb tebgwyuu medid zhobxtil.” Lex re mos guin lo men: “Le xgyiich de ne ka ne zeeb de nee, guzhexkwaa stebo; guzoob lo we ne taplalego zeeb de.” ");
INSERT INTO zpi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kesentyent wzee wzak menrik guin ne wii men ne kesentyent list xmos men ne wzëlgue gan pezee wlaa xmos men. Mén ne zadet xnëz Dëdyuzh ntozdee list men ke lo mén ne za xnëz Dëdyuzh porke ryegue men gan pezee ylaa men yra semén men. ");
INSERT INTO zpi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Yna noo lo de yra de, gukyiinen ne non ne rap de nee gyëzlyuree chen gap de xmig de, chen chene le ne non guin yra, che rap de men ne ykakwent de ledne gap de gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Mén ne xnëz rlaa dxiin lo ne zhi, zenga ke xnëz rlaa men dxiin lo ne ndal. Le mén ne xnëzdet rlaa dxiin lo ne zhi, xnëzdet ke rlaa men dxiin lo ne ndal. ");
INSERT INTO zpi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Belne xnëzdet rlaa de lo ne non ne nuu gyëzlyuree, ¿txuzh gap de konfyans lo ne nli non ne nuu gyeybaa? ");
INSERT INTO zpi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","No belne xnëzdet rlaa de lo ne nak xen mén, ¿txuzh yniiz ne ryal de? ");
INSERT INTO zpi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ni te mos gakdet ylaa dxiin lo txup patron, porke swinyaan men te men, le ste men gyaan men, o gakwen men lo men te men, le ste men ylaandet men. Zenga ke laa de yra de, gakdet ylaa de dxiin lo Dëdyuzh no sobleedx ke de med. ");
INSERT INTO zpi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kom kesentyent rdeb med lextoo yra men ne nak farisew, ne won men ne re Ne zenga, wzelo men wzhidxno men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Lex re Ne lo men: ―Laa de yra de rlaa de zeg rlaa menwen nes lo mén. Per rnebeey Dëdyuzh lextoo de; porke logne non rzak mén, rbix lextoo Dëdyuzho. ");
INSERT INTO zpi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Yra ne zëëd lo ley ne wdee Dëdyuzh lo Moises no le yra ne wkaa yra profet, wkayakzëëto axtegue ne le Xwa ne rtxobnis wuu. No desde cheguin wzelo wakzëët xdiznzoon Dëdyuzh no le zegne rkyeen Ne, no yrandxee mén rye gan pezee ylaa men chen tee men ledne rnebééy Ne. ");
INSERT INTO zpi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Per mazre mbëëdee nitlo gyeybaa gyëzlyutee ke ne gakdet te diiz ne zëëd lo ley. ");
INSERT INTO zpi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Belne nuu mgyeey rchil xgyeltsëlnya yrup men xewnaa men, lex rtsëlnya men yrup men ste wnaa, reey men dol ne la adulterio. Zenga ke mgyeey ne rtsëlnya wnaa ne che wbil xgyeltsëlnya, laake reey ke men dol ne la adulterio. ");
INSERT INTO zpi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Wuu te menrik ne rak lër ne mazre zhaandxee no ne mazre nyezh non, no yzaandxee dxe rlaa men lniroo. ");
INSERT INTO zpi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wuu ke te menprob ne la Laser, noze yde led men rlen gyeez; ra men rzob men ruxyagruyuu menrik guin. ");
INSERT INTO zpi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Baanske rlaan men gu men ne ratxee zhiin xmezh menrik guin; axtegue mëëk ra rlë lo gyeez ne ndxiib led men. ");
INSERT INTO zpi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Chene wdxiin dxe ne le menprob guin wet, weey angel men sya men ledne nuu Abraham. No wet ke menrik guin, lex wgugyeer mén men. ");
INSERT INTO zpi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Le chene le menrik guin kayak sufrir linfyeren, wlis lo men wii men Abraham axtegue nat, le menprob guin zu koo Abraham. ");
INSERT INTO zpi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Orguin wkarëz men, re men: “Dëd Abraham, gules lextoo de noo; guxaal Laser ysee xkwen Laser lo nis, lex chiid Laser ygaz Laser lo loz noo, porke kesentyent baanske rzak noo lo gyiree.” ");
INSERT INTO zpi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Per wke Abraham, re Abraham lo men: “Zhiin, gunileedx ne wen wa de ydeblo ne wbán de lo gyëzlyu, le Laser baanske wzak. Orrenaa le Laser nuu ledne rzhiilen Laser, le laa de kayak sufrir. ");
INSERT INTO zpi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","No stebo, nuudet tsa mén ne nuu nee wa; ni mén ne nuu wa, nuudet chiid men nee, porke ka te yúroo gwrooltee lad be yra be.” ");
INSERT INTO zpi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Orguin re menrik guin lo Abraham: “Ynab noo lo de bes Dëde, ne yxaal de Laser ruxyuu xuz noo, ");
INSERT INTO zpi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ledne nuu gaay bech noo, chen tsanii Laser lo zhaa, chen chiidet zhaa lo kastigrooree.” ");
INSERT INTO zpi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Lex re Abraham lo men: “Rap zhaa logne wkaa Moises no le logne wkaa yra profet; neguin tsukas zhaa.” ");
INSERT INTO zpi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wke menrik guin, re men: “Ylaleedxdet zhaa we Dëde, per belne yban te mengut tsanii lo zhaa, saan zhaa xgyelmal zhaa.” ");
INSERT INTO zpi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Per re Abraham lo men: “Belne rlaandet zhaa tsukas zhaa ne wkaa Moises ni ne wkaa yra profet, ni ylaleedxdet ke zhaa we, mase yban te mengut.” ");
INSERT INTO zpi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Re Jesus lo yra xpén Ne: ―Syemper zuu ne ysegyee lextoo mén ne gyab men lo dol; per ¡prob mén ne ysegyee lextoo semén ne gyab men lo dol! ");
INSERT INTO zpi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mazre wendee por laa men yliib mén te gyenzhoo ne rkyiinen molin lenyen men, lex ytxoon mén men lo nisdoo, ke ne ysegyee men lextoo te men ne gyed wzelondxee rlaleedx noo ne ye men dol. ");
INSERT INTO zpi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gugap kwent. ’Belne nuu pe dol rlaa xkompanyer de de, gugakndux lo men; belne ysaan meno, gugun men perdon. ");
INSERT INTO zpi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","No belne nuu pe rlaa men de guedx tir te dxe, belne rberee men guedx tir nan men lo de: “Ybereedetre noo ylaa noo we”, rap de degne gun de men perdon. ");
INSERT INTO zpi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Re yra xpoxter Jesus lo Ne: ―Gulaa ne ylaleedxre noo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Lex re Ne lo men yra men: ―Belne rlaleedx de Dëdyuzh mase medid landxel te medx lyagwlizh, zun de gan gue de lo yagree: “Gulaaz nee, gutsa sob de lo nisdoo”, no zono xdiiz de. ");
INSERT INTO zpi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’¿Txu laa de yra de ne rap te mos ne ragaan yuz o ne rapkwent yuz, zegne rberee men, nangue de lo men: “Gutee sob de lo mezh chen gu de”? ");
INSERT INTO zpi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Lel nan de lo men: “Guzhexkwaa xsëë. Gukaa xmandil de lo xab de, gugaa nesyaa guxsëë noo, axtegue ne luzh gu gootee noo; lex gu de, goo de.” ");
INSERT INTO zpi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Axtegue ni dexkyizhtee rdeedet de lo men por ne wlaa men yra ne rkyeen de. ");
INSERT INTO zpi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Zenga ke laa de yra de, chene che wlaa de yra ne rkyeen Dëdyuzh, rap de degne gue de: “Mos ne bat rkyiindet nak be, porke nonchee ne rap be degne ylaa be, neguin wlaa be.” ");
INSERT INTO zpi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ne za Jesus Jerusalén, wdee Ne yra gyëz ne nak lo lyu ne la Samaria no le lo lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ne wdxiin Ne te gyëzwin, wa chii mén ne rzak gyiz ne la lepra watsëlo men Ne, per wbigdet men axtegue lo Ne. ");
INSERT INTO zpi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Lex wkarëz men, re men: ―¡Jesus, Maxter, gules lextoo de noo yra noo! ");
INSERT INTO zpi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chene wii Ne men, re Ne lo men: ―Gutsa lo fxuz gutsaluu led de. Nëzgue za men, wyaken led men. ");
INSERT INTO zpi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ne wii te mén guin ne wyaken men, wberee men, lex ndípse wnii men wzaknon men Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wzuzhib men lo Jesus, wlitlo men axtegue wtee lo men lyu, wdee men dexkyizhtee lo Ne. Men-Samaria nak men. ");
INSERT INTO zpi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Orguin re Ne lo men: ―¿Pe let chiidet nak de yra de ne wyaken? ¿Gozh men sgaa men? ");
INSERT INTO zpi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Pe nonchee menzitree nak ne wberee ne saknon Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Orguin re Ne lo mén guin: ―Gusuli, gugya; por ne wlaleedx de noo, wyaken de. ");
INSERT INTO zpi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wnabdiiz yra men ne nak farisew lo Jesus gan pa or gak ne rkyeen Dëdyuzh, lex wke Ne re Ne: ―Ne rkyeen Dëdyuzh nakdeto ne gak kwii mén. ");
INSERT INTO zpi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Guedet mén: “Le we nee”, o “Le we wa”; porke le ne rkyeen Dëdyuzh che kayak lad de yra de. ");
INSERT INTO zpi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Zhich guin re Ne lo yra xpén Ne: ―Sdxiin dxe ne ylaan de kwii de Men ne wdxiid wak Mén mase tendxee dxe, per kwiidet de men. ");
INSERT INTO zpi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","No zuu mén ne yna lo de: “Le men zu nee”, o “Le men zu wa.” Per tsadet de, ni tsanaldet de men. ");
INSERT INTO zpi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porke zegne raknyoo rkabtsa ne reep nis gyeybaa rnëëzo nesree nesrotee, zenga gak chene ydxiin dxe ne chiid Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per primer rap men degne kesentyent gak men sufrir, no ylaandet mén ne nuu naaree men. ");
INSERT INTO zpi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Zegne wak tyemp ne wuu Noé, zenga ke gak chene chiid Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Porke cheguin ru mén, roo mén, rtsëlnya mén, rdee zhinzaap mén rtsëlnya, axtegue ne le Noé wdee lenbark; wyab gyoroo gyoduxtee, wketo men yrandxee men. ");
INSERT INTO zpi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Zenga ke wak tyemp ne wuu Lot: ru mén, roo mén, rzii mén, rtoo mén, rguu mén bni, rzaa xyuu mén; ");
INSERT INTO zpi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","per chene le Lot wruu Sodoma, wlen gyi gyeybaa no le ne la azufre, wketo yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Zenga ke gak chene ydxiin dxe ne chiid Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Chene ydxiin dxe guin, men ne zob xtoo xyuu rap men degne yzhoon men, koodet men ne nuu lenxyuu men; men ne zu den ybereedet men gya men ruxyuu men. ");
INSERT INTO zpi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gukanzaleedx ne wzak xewnaa Lot. ");
INSERT INTO zpi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Men ne rkaa xgyelembán lextoo, zako perdid; per le men ne rboleedx xgyelembán, zap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Yna noo lo de yra de ne gyëël guin ne chiid Men ne wdxiid wak Mén, ledne nex txup mén te lo loon, te men gya, te men gyan. ");
INSERT INTO zpi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Zenga ke ledne kayuut txup wnaa, te men gya, te men gyan. ");
INSERT INTO zpi_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","No ledne zu txup mgyeey den, te men gya, te men gyan. ");
INSERT INTO zpi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Lex wnabdiiz men lo Ne, re men: ―¿Pazh gak negwa, Dechey? Wke Ne re Ne: ―Zaknyoogoo zegne raknyoo ledne nex mawet, rdop ngolo. ");
INSERT INTO zpi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Wzëët Jesus zegnak te kwent lo men yra men chen yseed men ne yzaandxee dxe ynab men lo Dëdyuzh, sin ne ytxuugdet lextoo men. ");
INSERT INTO zpi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Re Ne: ―Te gyëz wuu te jwes ne rdxedet Dëdyuzh, ni raknzebnëzdet men lo mén. ");
INSERT INTO zpi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Gyëz ke guin wuu te wnabyud ne ranab gyelextis guetse guetse por te dil ne rap men yrup men mén ne rlaa lo men. ");
INSERT INTO zpi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Xche wkaa men zenga, nadet jwes guin nyukasgue men, per zhich guin nuu lextoo jwes guin: “Mase rdxedet noo Dëdyuzh, ni raknzebnëzdet noo lo mén, ");
INSERT INTO zpi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","per por tant zëdlandxiin wnaaree lo noo, ylaache noo xgyelextis men chen chiidetre men, antes ne yneseyal men xpasens noo.” ");
INSERT INTO zpi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","No re Jesus lo men yra men: ―Belne zeree re jwes mal guin, ");
INSERT INTO zpi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¡peleske Dëdyuzh ne tsukasdet xpén Ne ne rnab lo Ne dxe gyëëltee! ¿Peguin tsukasdetgue Ne men? ");
INSERT INTO zpi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yna noo lo de yra de ne zukasgue Ne men. Per chene chiid Men ne wdxiid wak Mén, ¿pe benakleg sël mén ne rlaleedx Dëdyuzh lo men lo gyëzlyuree? ");
INSERT INTO zpi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wzëët Jesus ste zegnak kwent por mén ne nuu lextoo noze laa men xnëz rlaa per le ste mén xnëzdet rlaa, re Ne: ");
INSERT INTO zpi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Wa txup mgyeey lenxeydoo Dëdyuzh wnab men lo Dëdyuzh: te men nak farisew, le ste men nak men ne rgoob zeg impwest. ");
INSERT INTO zpi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Men ne nak farisew, zuli men wnab lo Dëdyuzh, zeree re men: “Dëdyuzhe, dexkyizhtee de ne nakdet noo zegnak gwrol mén ne ngbaan, ne mal, no ne rkano ste wnaa; ni nakdet noo zegnak mén gwa ne rgoob zeg impwest. ");
INSERT INTO zpi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Noo txup tir rkwan noo te leen xman, rudet noo chene rnab noo lo de, no yra ne run noo gan, rlachii noo we, lex rniiz noo tebchii we por laa de.” ");
INSERT INTO zpi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Per le men guin ne rgoob zeg impwest, axtegue nat wzu men, ni wyezhdet men nlisgya lo men gyeybaa, sinke rgap laz men, re men: “¡Dëdyuzh, gules lextoo de noo ne nak noo mendol!” ");
INSERT INTO zpi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yna noo lo de yra de ne chene le men guin ne rgoob zeg impwest wberee ruxyuu men, che wun Dëdyuzh men perdon, per le men ne nak farisew, wundet Dëdyuzh men perdon. Porke yrandxee mén ne rlanon laake, mén guin bet nondet lo Dëdyuzh; le mén ne nuu lextoo ne bet nondet, mén guin gaknon lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wdxinno mén minwin lo Jesus chen yxob nya Jesus xtoo miin; per chene wii xpén Jesus, wakndux men lo yra men ne wdxinno miin. ");
INSERT INTO zpi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Per wbëz Jesus men yra men, lex re Ne lo men: ―Gudee si chiid minwin lo noo, ysoowdet de, porke ledne rnebééy Dëdyuzh, por mén ne nak zegnak minwin nako. ");
INSERT INTO zpi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nligue yna noo lo de yra de ne mén ne rlaandet ylaa ne rnebééy Dëdyuzh gakdet tee men ledne rnebééy Ne belne gakdet men zegnak minwin ne ron diiz. ");
INSERT INTO zpi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wnabdiiz te mén ne rnebééy lo men-Israel lo Jesus, re men: ―Maxter, laa de ne wen de, ¿pagox rap noo degne ylaa noo chen gap noo gyelembán ne nunk luzhdet? ");
INSERT INTO zpi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Wke Jesus, re Ne lo men: ―¿Penak na de ne wen noo? Yët menwen; nonchee Dëdyuzh wen. ");
INSERT INTO zpi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Laa de che nan de gan pagox rkyeen Dëdyuzh: “Ykanodet de mén ne nakdet lzaa de, yketet de mén, kwandet de, ykagyiidet de mén, gugaknzebnëz lo xuz de, gugaknzebnëz lo xnaa de.” ");
INSERT INTO zpi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Orguin re mén guin lo Ne: ―Yrandxee negwa che rlaa noo axtegue ne win noo. ");
INSERT INTO zpi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chene won Ne ne re men zenga, re Ne lo men: ―Benak rak falt ylaa de ste kos: gutoo yrandxee ne rap de, lex gudee med lo menprob, chen gap de ne non ne nuu gyeybaa; lex chiid de chidnal de noo. ");
INSERT INTO zpi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Per chene won mén guin zenga, kesentyent wunles lextoo men, porke kesentyent rik men. ");
INSERT INTO zpi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ne wii Ne ne wunles lextoo men, re Ne: ―¡Kesentyent ngan tee menrik ledne rnebééy Dëdyuzh! ");
INSERT INTO zpi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mazre mbëëdee tee te kamey gyeer ne zob nii gyëtsguzh ke ne tee te menrik ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yra men ne won ne re Ne zenga, re men: ―¿Txuzh nak ne gun gan yláá lo kastig cheguin? ");
INSERT INTO zpi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Lex re Ne lo men: ―Logne rundet mén gan ylaa men, Dëdyuzh si run Ne gan rlaa No. ");
INSERT INTO zpi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Lex re Bëd lo Ne: ―Noo yra noo, wsan noo yrandxee ne rap noo, zëdnal noo de. ");
INSERT INTO zpi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Lex wke Ne re Ne lo Bëd: ―Nligue yna noo lo de yra de ne kwaskyertee mén ne rsan xyuu, rsan xegwzan, rsan bech, rsan xewnaa, o rsan zhiin por ne rlaa men ne rkyeen Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kesentyent ndaldee ne ykakwent men nee gyëzlyuree, no sdxiin dxe ne gap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wbëz Jesus yra chibtxup xpén Ne waandxee, lex re Ne lo men: ―Orree tsa be Jerusalén ledne gak yra xkwent Men ne wdxiid wak Mén zegne wkaa yra profet. ");
INSERT INTO zpi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ydekwent mén men lo menzit, no yzhidxno mén men, yninyaan mén lo men, no ytxonxen mén lo men. ");
INSERT INTO zpi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ydee mén xkwent men; luzh nga yket mén men; per chene gyon gbiz, yban ke men. ");
INSERT INTO zpi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bet wdeedet men kwent gan penak re Ne zenga, ni nandet men gan pe rna ne re Ne zenga. ");
INSERT INTO zpi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Chene che guex ydxiin Jesus gyëz-Jericó, nga zob te menngwlëë runëz rnab men goon. ");
INSERT INTO zpi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ne won men ne rzheedx rdee ndal mén, wnabdiiz men gan kox rak. ");
INSERT INTO zpi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Lex re mén lo men ne Jesus men-Nazaret za nga. ");
INSERT INTO zpi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Lex wkarëz men, re men: ―¡Jesus, XPee David, gules lextoo de noo! ");
INSERT INTO zpi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yra mén ne zaner wakndux men lo mén guin chen gyakchi men, per lel mazre rkarëz men, re men: ―¡XPee David, gules lextoo de noo! ");
INSERT INTO zpi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Orguin wzutsë Ne, lex wkyeen Ne mén waxii mén men. Chene wdxiin men guex lo Ne, wnabdiiz Ne lo men, re Ne: ");
INSERT INTO zpi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Pagox rlaan de ylaa noo por laa de? Wke menngwlëë guin, re men: ―Dechey, rlaan noo gyenii bzalo noo. ");
INSERT INTO zpi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Orguin re Ne lo men: ―¡Gyenii bzalo de! Por ne wlaleedx de noo, wyenii we. ");
INSERT INTO zpi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Orgueguin wyenii bzalo mén guin; zanal men Ne, wzaknon men Dëdyuzh. No yrandxee mén ne wii neguin, no ke men wzaknon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ne wdxiin Jesus gyëz-Jericó, wdee Ne lenlgyëz guin. ");
INSERT INTO zpi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nga nuu te menrik ne la Zaqueo; laa men rnebééy lo men ne rgoob zeg impwest. ");
INSERT INTO zpi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Rlaan men kwii men Ne, per rakdet gan kwii men Ne porke kesentyent ndal mén ndxin no ndopendxee men. ");
INSERT INTO zpi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Por neguin wzaner men noze rzhoon men, wyeep men lo tebzhaan yag ne la sicómoro ne zob nes ledne tee Ne chen gak kwii men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Chene wdee Ne nga, wii Ne nes gya, lex re Ne lo men: ―Zaqueo, gyiid gyiidske gugyët wa, porke ruxyuu de rap noo degne yzëën noo. ");
INSERT INTO zpi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Orguin noze ryob rdxiintee wyët Zaqueo, no kesentyent rzhiilen men wano men Ne ruxyuu men. ");
INSERT INTO zpi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ne wii yra mén neguin, wzelo men yra men rnii men por laa Ne, re men: ―Le Jesus wdxiin ruxyuu te mendol. ");
INSERT INTO zpi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lex wzuli Zaqueo, re men lo Ne: ―Gukwii gante Dechey, ydee noo gwrool ne rap noo lo menprob, no belne nuu pe wkade noo mén chen wak wbaan noo men, ycheree noo tap lal ne wbaan noo lo men. ");
INSERT INTO zpi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Lex re Ne lo men: ―Nedxeree wláá men ne nuu lenyuuree lo dol, porke laake no men rlaleedx Dëdyuzh zegne wlaleedx Abraham Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Le Men ne wdxiid wak Mén zëdye mén ne che wak perdid chen yselaa men men lo dol. ");
INSERT INTO zpi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wzëët Jesus zegnak te kwent lo mén ne kayon ne re Ne, porke che guex ydxiin Ne Jerusalén no porke nuu lextoo yra mén guin pazer orgueguin gak ne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Re Ne lo men: ―Wuu te mgyeey ne nak zhiin mennon, wruu men za men nat chen ylaa mén men rrey, lex yberee ke men. ");
INSERT INTO zpi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Per antes ne yruu men, wbëz men chii xmos men, wdee men ndal med lo men te te men, lex re men lo men: “Gulano medree dxiin axtegue ne yberee noo.” ");
INSERT INTO zpi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Per rwinyaan yrandxee menlaz men men, lex wxaal menlaz men tebëd mén zanal men chen gue men: “Rlaandet noo ne gak ménree xerrey noo.” ");
INSERT INTO zpi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Per wlaa mén men rrey, lex wberee ke men laz men. Chene le men wberee, wbëz men yra xmos men ne wdee men med lo, chen gaknan men gan palal wun men gan te te men. ");
INSERT INTO zpi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wbig men primer, re men: “Dechey, le xmed de nee; wuno gan schii lal ne nako.” ");
INSERT INTO zpi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wke rrey, re rrey lo men: “Weno, te moswen nak de; ya ke ne wen wlaa de kon ne zhi, orrenaa yzu noo de ynebééy de chii gyëz.” ");
INSERT INTO zpi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wbig men ste men, re men: “Dechey, le xmed de nee; wuno gan sgaay lal ne nako.” ");
INSERT INTO zpi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wke rrey, re rrey lo mos guin: “Laa de ynebééy gaay gyëz.” ");
INSERT INTO zpi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Lex wbig men ste men, re men: “Dechey, le xmed de nee; wkaa noo we te lo bayles, wgutsoow noo we. ");
INSERT INTO zpi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Wdxe noo de porke wdee beey nak de, rnëëz de ne nakdet xen de, no rlaap de ne wak ledne wguudet de bni.” ");
INSERT INTO zpi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Lex re rrey lo men: “Mosmal, por xgyelgyedruu de nak ne sakzi de. Belne nan de ne wdee beey nak noo, ne rnëëz noo ne nakdet xen noo, no ne rlaap noo ne wak ledne wguudet noo bni, ");
INSERT INTO zpi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿penak waludet de xmed noo bank cheguin? Lex chene nberee noo, nkakwent noo we ydebzhiino.” ");
INSERT INTO zpi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Lex re rrey guin lo men ne ndxin nga: “Gugyitxee med gwa lo men, gudee we lo men ne nzen chii lal wa.” ");
INSERT INTO zpi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Wke men re men: “Dechey, per che nzen men chii lal wa.” ");
INSERT INTO zpi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wke rrey, re rrey lo men: “Yna noo lo de yra de ne mén ne nzeno, mazre ndaldoo sen men; per le mén ne nzendeto, axtegue ne nzenendxee men ybetxee lo men. ");
INSERT INTO zpi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Le yra mén ne rwinyaan noo ne wlaandet ne gak noo rrey, gutano men nee, lex guket men nes lo noo.” ");
INSERT INTO zpi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chene wluzhse re Jesus zenga, wyuli ke Ne nëz, za Ne Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Chene wdxiin Ne guex Betfagé no le guex Betania guex gyeey ne la Olivos, wxaal Ne txup xpén Ne, ");
INSERT INTO zpi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","re Ne lo men: ―Gutsa gyëzwin ne nak ngali nee. Ne ydxiin de, tsël te bur bëën bëënleg ne kaduu nga lo de no ne rutlel gardet kwib. Ychil de ma, chidno de maa. ");
INSERT INTO zpi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Belne nuu mén ynabdiiz lo de, yna men: “¿Penak rchil de bur gwa?”, yke de, gue de: “Laa Jesus ne rnebééy ykyiinen maa.” ");
INSERT INTO zpi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Lex za xpén Ne, no yrandxee zegne re Ne, zenga wako. ");
INSERT INTO zpi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Chene le men kachil bur guin, wnabdiiz xpexwaan ma lo men, re men: ―¿Penak rchil de bur gwa? ");
INSERT INTO zpi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wke men re men: ―Laa Jesus ne rnebééy ykyiinen maa. ");
INSERT INTO zpi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lex wdxinno men ma lo Jesus, wxob men lër ne rrël men led maa, wzoob men Jesus led maa. ");
INSERT INTO zpi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Zegne zadee Jesus, rgyixnchiil mén lër nëz ledne tee Ne. ");
INSERT INTO zpi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ne che guex ydxiin Ne ledne rzeeb den gyey-Olivos, yrandxee xpén Ne wzelo men noze rakrwid men por tant rzhiilen men no rzaknon men Dëdyuzh por yra gyelmilaguer ne wii men wak. ");
INSERT INTO zpi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Re men: ―¡Dëdyuzh gaknonen rrey ne zëëd por la Dëdyuzh! Gyelendxi nuu gyeybaa; nzoon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Orguin re tebëd men ne nak farisew ne za lad yra mén nga, lo Ne: ―Maxter, gugakndux lo yra xpén de. ");
INSERT INTO zpi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Per wke Ne re Ne lo men: ―Yna noo lo de yra de, belne gyakchi men, selo yra gyeree terëzo. ");
INSERT INTO zpi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Chene le Ne wdxiin guex Jerusalén ne wii Ne gyëz guin, woon Ne por laa we. ");
INSERT INTO zpi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Re Ne: ―Men-Jerusalén, belnaal ydee de kwent gan txu zëëd yniiz gyelendxi lo de, per orrenaa nuudet ydee de kwento porke ngueedxo por laa de. ");
INSERT INTO zpi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Porke sdxiin dxe ne mal por laa de yra de, ne ylep soldad te fchin noze kbii de, lex kwinnap men de; ni te lad gundet de gan yláá de lo men. ");
INSERT INTO zpi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yket men de yra de no yluzh men laz de. Ni te gye gyandet led ste gye, porke wukasdet de mén ne wxaal Dëdyuzh lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Chene wdxiin Jesus Jerusalén, wzelo Ne wnexoon Ne yra mén ne ndxin rtoo no le yra mén ne ndxin rzii ruxeydoo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Re Ne lo men: ―Lo xgyiich Dëdyuzh re: “Xyuu noo, ledne rnab mén lo noo nako”; per le laa de yra de rlaa do zegnak xebluu ngbaan. ");
INSERT INTO zpi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yzaandxee dxe wneluu Jesus mén lenxeydoo Dëdyuzh. Per le fxuz ne rnebééy lo yra fxuz no le maxter ley no le men ne rnebééy lo men-Jerusalén, rye men gan pezee gak yket men Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Per rzëldet pezee ylaa men, porke noze list ndxin yrandxee mén rkagyedyag men ne rnii Ne. ");
INSERT INTO zpi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Te dxe ne nuu Jesus lenxeydoo Dëdyuzh, kaneluu Ne xdiznzoon Dëdyuzh lo mén, wdxiin yra fxuz ne rnebééy lo yra fxuz yra men maxter ley no le yra men men ne rnebééy lo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Lex re men lo Ne: ―Guzëët gan txu wkyeen de ne rlaa de negwa. ¿Txu wnebééy lo de ne rlaa do? ");
INSERT INTO zpi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Wke Ne re Ne lo men: ―Laake no ke noo ynabdiiz lo de yra de, per guke: ");
INSERT INTO zpi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿txuzh wxaal Xwa ne wtxobnis Xwa mén, Dëdyuzh u noze mén? ");
INSERT INTO zpi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lex wzelo men rulsaa men diiz, re men: ―Belne gue be ne Dëdyuzh wxaal Xwa, naap yna zhaa: “¿Penak wlaleedxdet de Xwa cheguin?” ");
INSERT INTO zpi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Belne gue be noze mén wxaal Xwa, sket yrandxee mengyëz be kon gye porke yrandxee men nan ne te profet nak Xwa. ");
INSERT INTO zpi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Lex wke men re men ne nandet men gan txuzh wxaal Xwa ne rtxobnis Xwa mén. ");
INSERT INTO zpi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Wke Ne re Ne lo men: ―Laake ni noo yzëëdet gan txuzh wkyeen noo ne rlaa noo neree. ");
INSERT INTO zpi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Zhich guin wzelo Jesus wuu Ne zegnak te kwent lo yra mén guin, re Ne: ―Wuu te mgyeey ne wlabni blag ub, lex wbodiin meno lo tebëd mén ne rapkwent blag ub. Zhich guin wruu men nga, za men xchese. ");
INSERT INTO zpi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Le chene wdxiin tyemp ne le ub wal gyët, wxaal xpexwaan blag ub guin te xmos men lo yra men ne rapkwento, zaxii xmos men ub ne ryal xpexwaan blag ub guin. Per lel wnëëz yra men ne rapkwent blag ub mos guin, wdee men xkwent men, wzanëz men men nonchee zenga. ");
INSERT INTO zpi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Zhich guin wxaal xpexwaan blag ub ste xmos men; per zenga ke wdee men xkwent mos guin no wninyaan men lo men, wxaal men men nonchegue zenga. ");
INSERT INTO zpi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wxaalgue xpexwaan blag ub ste xmos men; per zenga ke wlaa yra mén guin, wdee men xkwent mos guin axtegue wsewee men men, lex wboo men men lo lyu guin. ");
INSERT INTO zpi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Wyal wdebo, re xpexwaan blag ub: “¿Pezee ylaa noo? Mazdee yxaal xpee noo ne ryaan noo; pazer zaknzebnëz men lo mee.” ");
INSERT INTO zpi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Per chene wii yra mén guin xpee men, wulsaa men diiz, re men: “Laa ménree nak ne gyanno blag ubree; yoo yket be men, chen gyanno bo laa be.” ");
INSERT INTO zpi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Lex wboo yra mén guin mee guin lo lyu guin, wket men mee. ’Naaree naa, ¿pagox ylaa xpexwaan blag ub yra mén guin? ");
INSERT INTO zpi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yna noo lo de ne chiid men yket men yra mén guin, lex ydee men blag ub lo stebëd mén. Chene won yra mén guin zenga, re men: ―¡Naleg Dëdyuzh gakdet zenga! ");
INSERT INTO zpi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Per wii Jesus lo men, lex re Ne: ―¿Pagox rna ne re lo xgyiich Dëdyuzh cheguin? Nga re: Gye ne axtegue rlaandet mén ne rlep yuu, laa we wak gye ne mazre rkyiindee. ");
INSERT INTO zpi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","No kwaskyertee men ne gyab led gye guin, zakbyu men, per belne gyab gye guin led men, zakbyudoo men. ");
INSERT INTO zpi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wlaan yra maxter ley yra men fxuz ne rnebééy lo yra fxuz nguu men Jesus chegyiib orgueguin, porke wyenen men ne por laa por laandxee men wzëët Ne yra diiz guin, per wdxe men mén. ");
INSERT INTO zpi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Lex wxaal men tebëd mén ne noze rkanlo wen, za men gwleedx, chen gan pe gue Ne chen tsël gan pezee ydekwent men Ne lo gobernador. ");
INSERT INTO zpi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Por neguin re men lo Ne: ―Maxter, nan noo yra noo ne ryal ne rnii de no ne rneluu de no ne zadet lextoo de gan txu nak mén, sinke nli ne rneluu de ne ybán mén zegne rlaan Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Guna gan ¿pe wen gyizh noo zeg impwest lo rrey-Roma u wendeto? ");
INSERT INTO zpi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Per kom wyenen Ne ne ngyidet ne rlebleedx men, lex re Ne lo men: ―¿Penak rye de gan pezee gyab noo lo xetramp de? ");
INSERT INTO zpi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Guluu te med lo noo. ¿Txu lo wa no txu la wa ka lo we? Wke men re men: ―Lo rrey-Roma we no le la rrey-Roma we. ");
INSERT INTO zpi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Lex re Ne lo men: ―Guex gudee ne nak xen rrey lo rrey, le ne nak xen Dëdyuzh gudee lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","No delo lo yrandxee diiz ne re Ne nes lo yrandxee mén, axtegue bet wzëldet gan pe nkanlo men chen nkagyii men Ne, lel rzee rzak men yra ne rke Ne. Noze chi wbiin men. ");
INSERT INTO zpi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wa tebëd men ne nak sadusew lo Jesus. Kom rlaleedxdet men ne sban mengut, por neguin re men lo Ne: ");
INSERT INTO zpi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maxter, lo ley ne wdee Dëdyuzh lo Moises zëëd ne belne guet te mén, per wapdet xewnaa men mëëd, bech men rap degne ytsëlnyano wnaa guin, chen gap men mëëd ne gak zegnak zhiin mén guin ne wet. ");
INSERT INTO zpi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tebtir wuu guedx mén, tese bech men yra men; lex wtsëlnya men ne nak mengoldee lo men yra men, per wet men; wuudet zhiin men. ");
INSERT INTO zpi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Lex wtsëlnya men ne wrup yrup men xewnaa men guin. Laake wet ke men; wuudet ke zhiin men. ");
INSERT INTO zpi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Lex wtsëlnya men ne wyon yrup men wnaa guin, zenga ke wzak men. Zenga wlaa men yra men axtegue ne wzaa men guedx, yra men wet; ni te men wuudet zhiin. ");
INSERT INTO zpi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wyal wdebo, wet ke no wnaa guin. ");
INSERT INTO zpi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Orrenaa, chene yban mengut, ¿txu xewnaapee gak wnaa guin ne yrandxee guedx mén guin wtsëlnyano men? ");
INSERT INTO zpi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Wke Ne re Ne lo men: ―Nee gyëzlyuree, rtsëlnya mgyeey, rtsëlnya wnaa. ");
INSERT INTO zpi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Per le men ne yban no ne ryal gap ste gyelembán, che ytsëlnyadetre men, ni mgyeey ni wnaa, ");
INSERT INTO zpi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","porke guetetre men, sinke zegnak angel gak men no zhiin Dëdyuzh nak men por ne wban men. ");
INSERT INTO zpi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Si laake Moises wkaa ne sban mengut, ledne wkaa Moises xkwent gyëtsbne ne kayeeky. Nga wkaa Moises ne XDëdyuzh Abraham nak Dëdyuzh, XDëdyuzh Isaac, XDëdyuzh Jacob. ");
INSERT INTO zpi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nakdet Dëdyuzh XDëdyuzh mengut, sinke le Dëdyuzh nak XDëdyuzh menmbán, porke por Dëdyuzh yrandxee mén mbán. ");
INSERT INTO zpi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Lex re tebëd maxter ley lo Ne: ―Wen wnii de, Maxter. ");
INSERT INTO zpi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wyezhdetre men nnabdiizre men lo Ne. ");
INSERT INTO zpi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Lex wnabdiiz Jesus lo men yra men, re Ne: ―¿Penak re mén ne xpee David nak Crist? ");
INSERT INTO zpi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Si laake David wkaa lo liber Salmos ledne re: Dëdyuzh re lo XDëdyuzh noo: “Gusob koo noo ladbëë ");
INSERT INTO zpi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","axtegue ne ylaa noo ne gyichnii de yrandxee mén ne rlaa lo de.” ");
INSERT INTO zpi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Por neguin belne David ke rnesela Crist XDëdyuzh David, ¿pezee gak Crist xpee David? ");
INSERT INTO zpi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yrandxee mén ndxin ron chene re Jesus lo xpén Ne: ");
INSERT INTO zpi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Gugap maxter ley kwent, porke rtseleedx men gak men lërngool, no rtseleedx men ne kon gyelenzebnëz gabtyuzh mén men nes lgyeey, no rye men lo yagzhil ne rzob mennon lenydoo chen sob men; zenga ke rlaa men chene ra men gwdu, ");
INSERT INTO zpi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","no rgyitxee men xyuu wnabyud, per por ne gyendeto, kesentyent xche rnab men lo Dëdyuzh, per laa men yra men nak ne ntozdee sakzi. ");
INSERT INTO zpi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Chene zu Jesus lenxeydoo Dëdyuzh, wlis lo Ne wii Ne menrik ne rguu goon ledne ruu goon. ");
INSERT INTO zpi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","No wii ke Ne te wnabyudprob, wguu men txup medwin ne kober nga. ");
INSERT INTO zpi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Lex re Ne: ―Nligue yna noo lo de ne nondee goon ne wguu wnabyudprobree ke goon ne wguu yra mén, ");
INSERT INTO zpi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","porke yra mén wguu men ne che wrukaa nya men, per le wnaaree mase lo xgyeleprob men, wguu men logne nzenendxee men ne rdeendxee men lo xelyaaz men. ");
INSERT INTO zpi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wzelo txup tson xpén Jesus ruu men xdiiz xeydoo Dëdyuzh por yra gyezhaandxee ne nyeepo no le por yra ne rasan mén chen gakxnëzro. Lex re Jesus lo men: ");
INSERT INTO zpi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Sdxiin dxe ne luzh yra neree ne rwii de yra de, ni te gye gyandet led ste gye, yrandxoo luzh. ");
INSERT INTO zpi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Lex wnabdiiz men lo Jesus, re men: ―Maxter, ¿pa or gak yra negwa? ¿Pezee gak beey ne tsuu chene le we che wyob gak? ");
INSERT INTO zpi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Orguin re Ne: ―Gugap kwent, ydeedet de si ykade mén de. Porke schiid ndal mén ne ykade, yna men: “Noo nak Crist”; o yna men: “Che wyob chiid Crist.” Per ylaleedxdet de men. ");
INSERT INTO zpi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","No chene gon de diiz ne le dilroo nuu u ne le gyelentoz nuu, ydxedet de; porke zenga nak ne rap degne gak primerdee, per let laadet ne nitlogue gyëzlyu nga. ");
INSERT INTO zpi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","No re Ne: ―Te nacion til yrup ste nacion, te gobyeren til yrup ste gobyeren. ");
INSERT INTO zpi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","No kesentyent ndxeeb yni lyu, no tsuu gbiin, tsuu gyelgyiz nesree nesrotee, le gyeybaa gaknyoo ne kesentyent ndxeeb rnaa, no ndalre beey ne tsuu. ");
INSERT INTO zpi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Per antes ne gak yra neree, ykanal mén de, ynëëz men de tsano men de lenydoo chen ykagyii men de, ysee men de chegyiib, no tsano men de lo rrey no le lo gobernador por ne nak de xpén noo. ");
INSERT INTO zpi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nga nak ne gak gu de xdiiz noo lo men. ");
INSERT INTO zpi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Per tsadetgue lextoo de gan pe gue de lo men. ");
INSERT INTO zpi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porke noo yseleedx diiz ne gue de no yseleedx noo gyelenyenii lo de; ni te mén ne rlaandet kwii de gundet gan ytxuug lo diiz guin, ni gundet men gan gue men ne nlideto. ");
INSERT INTO zpi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Per axtegue xegwzan de, axtegue bech de, axtegue xparyent de, axtegue xmig de ydekwent men de, no sket men de gwrol de, ");
INSERT INTO zpi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","no kwinyaan yrandxee mén de por ne rzëët de xdiiz noo. ");
INSERT INTO zpi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Per axtegue ni te gyitsxtoo de gakdet perdid. ");
INSERT INTO zpi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Belne ysalzaandet de xdiiz noo, zap de gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Chene kwii de ne le soldad ndxin noze kbii gyëz-Jerusalén, cheguin gaknan de ne le dxe ne luzho che wdxiin. ");
INSERT INTO zpi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Cheguin men ne nuu Judea rap men degne yzhoon men gya men gyeey den; men ne nuu Jerusalén rap men degne yruu men nga; men ne zu den ybereedetre men gya men gyëz. ");
INSERT INTO zpi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porke dxe guin nak ne yzakzi Dëdyuzh mén chen gak kumplir yra ne zëëd lo xgyiich Ne. ");
INSERT INTO zpi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Prob yra wnaa ne nakzhiin chene ydxiin dxe guin! ¡Prob yra wnaa ne rap mëëd ne roo dud! Porke kesentyent tsuu gyelenles gyëzlyu no kesentyent sakzi yra mén ne nuu gyëzree. ");
INSERT INTO zpi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nuu men guet kon spad, nuu men gweey mén men tsunyoow men yra nacion; yra men ne nak menzit chiid men ynebééy men Jerusalén axtegue ne yzaa dxe ne wsu Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Cheguin tsuu beey lo ngbiz, no le lo mëëw, no le lo mël ne ndxiib gyeybaa; le gyëzlyu axtegue nandet mén pe ylaa men, ydxe men por tant ndxeeb tsube nisdoo no por tant ndxeeb rgyito. ");
INSERT INTO zpi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nozguestee ne ylebleedx men yra ne gak gyëzlyu, axtegue ykeben men por tant gyelerdxeeb; porke axtegue ne nuu gyeybaa yni. ");
INSERT INTO zpi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Cheguin kwii men Men ne wdxiid wak Mén zëëd men lad bëw ydebxpoder men no ydebxgyelenzoon men. ");
INSERT INTO zpi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chene selo gak yra neree, ndíp guguu lextoo de, gulisgya lo de, porke che wyob yláá de. ");
INSERT INTO zpi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","No re Ne lo men yra men: ―Gukwii zegnak yag-ig o kwaskyertee ste yag. ");
INSERT INTO zpi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chene rwii de ne le we che rreen, ryenengue de ne le mëëw ne rak neey che zëdyob. ");
INSERT INTO zpi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Zenga ke chene kwii de ne le yra neree che kayak, syenengue de ne le ne rkyeen Dëdyuzh che zëdyob. ");
INSERT INTO zpi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Nligue yna noo lo de yra de ne antes ne guet yra mén ne nuu naaree, gak yra neree. ");
INSERT INTO zpi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Gyeybaa no le gyëzlyu snitlo we, per le xdiiz noo tesudet ne gako. ");
INSERT INTO zpi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Gugap kwent, ydeedet de si gun ne mal gan lo de, zegnak gyelguu, zegnak ne za zeebtee lextoo de yra ne nuu gyëzlyuree, chen chene ydxiin dxe guin, yganodet de neree ");
INSERT INTO zpi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","zegne rga maa lo tramp, porke zenga gako por yrandxee mén ne nuu ydendxee gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","List gugak yra de, yzaandxee dxe gunab lo Dëdyuzh, chen gun de gan yláá de lo yra ne gak no chen gun de gan ybig de lo Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yedxe rneluu Jesus mén lenxeydoo Dëdyuzh, le gyëël ra Ne rzëën Ne gyeey ne la Olivos. ");
INSERT INTO zpi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","No rsilgue rdxiin yrandxee mén lenydoo chen gon men ne rzëët Ne. ");
INSERT INTO zpi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chene che wyob lni ne la pask ne ru mén gyëtxtil ne nootsdet lebadur, ");
INSERT INTO zpi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","rye yra fxuz ne rnebééy lo yra fxuz yra men maxter ley gan pezee yket men Jesus chen gyendeto, porke rdxe men mén. ");
INSERT INTO zpi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Lex wdee Bzelo lextoo Judas, men ne la ke Iscariote. Te ke men ne nak xpén Jesus chibtxup nak Judas. ");
INSERT INTO zpi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wa Judas lo fxuz ne rnebééy lo yra fxuz no le lo men ne rnebééy lenxeydoo Dëdyuzh, re Judas gan pezee ydekwent Judas Jesus lo men yra men. ");
INSERT INTO zpi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wzhiilen men ne won meno, lex re men ne ydee men med lo Judas; ");
INSERT INTO zpi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","wna Judas, lex wzelo Judas wye Judas gan pezee ydekwent Judas Jesus lo men chene yët ndal mén. ");
INSERT INTO zpi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Chene wdxiin lni pask ne ru mén gyëtxtil ne nootsdet lebadur no ne rket men te mëkzhiil bëën bëënleg ne ru men lo pask, ");
INSERT INTO zpi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","wxaal Jesus Bëd no le Xwa, re Ne lo men: ―Gutsa yzhexkwaa de ne guxsëë be lo lniree. ");
INSERT INTO zpi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Lex wnabdiiz men lo Ne, re men: ―¿Pazh rlaan de tsazhexkwaa noo we? ");
INSERT INTO zpi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wke Ne re Ne: ―Chene tee de lenlgyëz, ytsëlo de te mén ne neey tebree nis. Tsanal de men axtegue ne ydxiin men ruyuu ledne tee men; ");
INSERT INTO zpi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","lex gue de lo xpexwaan yuu guin: “Zere na Maxter, ¿go lenyuuzhe guxsëë Maxter lo pask yra Maxter xpén Maxter?” ");
INSERT INTO zpi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lex yluu men te lenyunzhen ne nak pisgya lo de, che xnëz nak leeno; nga yzhexkwaa de ne guxsëë be. ");
INSERT INTO zpi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wa yrup mén guin, no yrandxee ne re Ne lo men, wako. Lex wzhexkwaa men ne guxsëë Ne lo pask yra Ne men. ");
INSERT INTO zpi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chene wdxiin or ne guxsëë Ne, wzob Ne lo mezh yra Ne xpoxter Ne. ");
INSERT INTO zpi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Lex re Ne lo men: ―¡Che penaadese rlaan noo gu noo xsëëree yra noo de lo pask, antes ne guet noo! ");
INSERT INTO zpi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Porke yna noo lo de yra de ne ybereedetre noo guxsëë noo lo pask axtegue ne gak pask zegne ryal gako ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Zhich guin wgoob Ne bas ne nuu bin, wdee Ne dexkyizhtee lo Dëdyuzh, lex re Ne: ―Gunëëz neree, gugoo we tebruugue tebruugoo te te de. ");
INSERT INTO zpi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Porke yna noo lo de yra de ne goodetre noo bin ub axtegue ne gak yrandxee ne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Zhich guin wgoob Ne gyëtxtil, wdee Ne dexkyizhtee lo Dëdyuzh, lex wla No wdee No lo men yra men chen gu meno, re Ne: ―Che nan de zeree ke ylaa de chen ynileedx de noo, porke laa neree nak xkwerp noo ne ydekwent noo ne guet por laa de yra de. ");
INSERT INTO zpi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Zenga ke wlaa Ne bas ne nuu bin chene wluzh wuxsëë Ne yra Ne men, lex re Ne: ―Laa binree nak xren noo ne yzhe chene guet noo por laa de yra de, chen gyal te nëzkweb ne gak ydxiin mén lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Per orree le men ne ydekwent noo zob lo mezh ledne zob ke noo. ");
INSERT INTO zpi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Men ne wdxiid wak Mén rap men degne sak men ne che zëëd men ne sak men; per ¡prob mén ne ydekwent men! ");
INSERT INTO zpi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Orguin wzelo men rnabdizlsaa men gan txu nak ne ydekwent Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Zhich guin wzelo yra xpén Jesus rdildizlsaa men gan txu men nak men ne mazre nondee lad men yra men. ");
INSERT INTO zpi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Per re Ne lo men yra men: ―Yra rrey ne nuu gyëzlyu, rnebééy men lo menlaz men zegne rlaantee men. Le yra men ne rnebééy, rnii mén men “men ne rlaa ne wen”. ");
INSERT INTO zpi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per le laa de yra de ylaadet de zenga. Sinke mén ne mazre nondee lad de yra de, rap men degne gak men zegnak te mén ne beeytee non; le men ne rnebééy lo de yra de, rap men degne gak men lo de zegnak men ne rlaa dxiin. ");
INSERT INTO zpi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Txu nak men ne mazre nondee, men ne rzob lo mezh ru u men ne rdxiib nesyaa lo mezh? ¿Pe let men ne zob lo mezh, men guin nak ne nondee? Per noo, nak noo lo de yra de zegnak men ne rdxiib nesyaa lo mezh. ");
INSERT INTO zpi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Laa de yra de nak ne zulel kon noo lo yrandxee ne kazak noo. ");
INSERT INTO zpi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Por neguin noo yseleedx ne laa de ynebééy zegne wseleedx Xuz noo we lo noo. ");
INSERT INTO zpi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Laa de yra de nak ne sob lo xmezh noo, gu de, goo de ledne rnebééy noo, no sob de lo yagzhil chen ylaa de gyelextis lo yrandxee men ne zëëd xnëz yra chibtxup xpee Israel. ");
INSERT INTO zpi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","No re Jesus lo Simon-Bëd: ―Simon, Simon, gukwii gante, le Bzelo wnab de yra de chen ylaa men de zegne rlaa mén chene rbib men zhobxtil; ");
INSERT INTO zpi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","per le noo che wnab lo Dëdyuzh por laa de chen ysalzaandet de ne rlaleedx de noo. Per chene che wberee de lo noo ste, guu de lextoo xkompanyer de chen ysalzaandet men ne rlaleedx men noo. ");
INSERT INTO zpi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Lex re Simon lo Ne: ―Dechey, ysalzaandet noo de, por noo nyaalzhe tsuu noo chegyiib yrup noo de no nyaalzhe axtegue guet noo yrup noo de. ");
INSERT INTO zpi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Orguin wke Ne re Ne: ―Bëd, yna noo lo de ne negyëëlkeree, antes ne ykarëz ngyedgol, che wyon tir wkedxnruu de ne rnebeey de noo. ");
INSERT INTO zpi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Zhich guin wnabdiiz Jesus lo men yra men, re Ne: ―Chene wxaal noo de yra de sin bols, sin med, sin gyël, ¿pe nuu ne wak falt lo de? Wke men re men: ―Bettee. ");
INSERT INTO zpi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Lex re Ne lo men: ―Orrenaa, log mén ne rap bols, gweey meno no sen men med; log mén ne yëten spad, ytoo men lër ne rrël men, yka men tebo. ");
INSERT INTO zpi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porke yna noo lo de yra de ne rap noo degne sak noo ne zëëd lo xgyiich Dëdyuzh ledne re: “Wun mén men kwent lad menmal.” Per yrandxee ne ka lo xgyiich Dëdyuzh ne sak noo, rapo degne gako. ");
INSERT INTO zpi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Orguin re men lo Ne: ―Dechey, nee neey noo txup spad. Wke Ne re Ne: ―Negwaguestee. ");
INSERT INTO zpi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Zhich guin wruu Jesus, za Ne gyey-Olivos zegnak xkoxtumber Ne. Lex zanal yra xpén Ne Ne. ");
INSERT INTO zpi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chene wdxiin Ne nga, re Ne lo yra xpén Ne: ―Gunab lo Dëdyuzh, chen ysegyeedet Bzelo lextoo de. ");
INSERT INTO zpi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Orguin wrunsu Ne lo men yra men, wa Ne zeg medid ne rtxoon mén te gye. Lex wzuzhib Ne nga, wnab Ne lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Re Ne: ―Dëde, belne yna de, guselaa noo lo gyelenlesree; per gakdet zegne rlaan noo, sinke zegne rlaan de. ");
INSERT INTO zpi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Orguin wlalo te angel ne wruu gyeybaa, wdee angel fwers lo Ne. ");
INSERT INTO zpi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Per por tant nles nuu lextoo Ne, mazre rnab Ne lo Dëdyuzh ydebxfwers Ne, no axtegue lyu ryab nis ne rzenisen Ne; nak nis guin zegnak tebgyese tebgyese ren. ");
INSERT INTO zpi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chene wzuli Ne ne wluzh wnab Ne lo Dëdyuzh, wa Ne ledne ndxin xpén Ne. Wdxiin Ne, le men ndxinguees, tant nles nuu lextoo men. ");
INSERT INTO zpi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Lex re Ne lo men: ―¿Penak ndxinguees de? Gutsaxee, gunab lo Dëdyuzh, chen ysegyeedet Bzelo lextoo de. ");
INSERT INTO zpi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Benak kanii Jesus chene wdxiin ndalyaa mén. Men ne la Judas te ke men ne nak xpén Ne chibtxup zaner lo men yra men, lex wbig Judas lo Ne, woo Judas te bzhid gyedkwes Ne. ");
INSERT INTO zpi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Lex re Ne lo Judas: ―Judas, ¿pe kon te bzhid ydekwent de Men ne wdxiid wak Mén? ");
INSERT INTO zpi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chene wii yra men ne ndxinno Ne neguin ne kayak, re men lo Ne: ―Dechey, ¿pe skyits noo spad? ");
INSERT INTO zpi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Orguin wkyits te men guin xespad men gyedyagbëë xmos fxuz ne mazre nondee, wtxugnëz meno. ");
INSERT INTO zpi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Per re Ne lo men: ―Zeka men; che we naa. Lex wtee nya Ne gyedyag mén guin, wkyeed ke No zegnako. ");
INSERT INTO zpi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Zhich guin re Ne lo yra fxuz ne rnebééy lo yra fxuz no le lo men ne rnebééy lo men ne rapkwent xeydoo Dëdyuzh no le lo men ne rnebééy lo men-Israel ne zaxii Ne: ―¿Penak zëëd de zëdnëëz de noo kon spad, kon yag, zeg teleg ngbaan nak noo? ");
INSERT INTO zpi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","No yzaandxee dxe wzu noo lenxeydoo Dëdyuzh, wnëëzdet de noo; per laa xor de nee yra de ne gun Bzelo gan ynebééy Bzelo lo de. ");
INSERT INTO zpi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Orguin wnëëz men Jesus yra men, lex wano men Ne ruxyuu fxuz ne mazre nondee. Le Bëd zanal Ne nat nat. ");
INSERT INTO zpi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nga wzuul mén gyi gwrooltee lo leey, lex wzob men kbii gyi, no Bëd wa wzob lad men yra men. ");
INSERT INTO zpi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chene wii te wnaa ne rlaa dxiin nga ne zob Bëd lo gyi, rwii men lo Bëd, lex re men: ―No ménree nak xpén Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Per wkedxnruu Bëd, re Bëd: ―Wnaae, axtegue rnebeeydet noo mén gwa. ");
INSERT INTO zpi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Orsegue wako, wii men ste men ne zob Bëd, lex re men lo Bëd: ―¿No de nak te xpén men gwa ye? Wke Bëd, re Bëd: ―Let nodet noo. ");
INSERT INTO zpi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wako zeg ste or, re men ste men: ―Nlipee ne no ménree nak te xpén Jesus, porke no men nak men-Galilea. ");
INSERT INTO zpi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lex re Bëd lo men: ―Nandet noo gan pe rnii de. Orke guin ne benak kanii Bëd, wkarëz te ngyedgol. ");
INSERT INTO zpi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Lex wcheree lo Jesus wii Ne lo Bëd. Orguin wnileedx Bëd ne re Ne lo Bëd: “Negyëëlkeree, antes ne ykarëz ngyedgol, che wyon tir wkedxnruu de ne rnebeey de noo.” ");
INSERT INTO zpi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Lex wruu Bëd nga; baanske woon Bëd. ");
INSERT INTO zpi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yra mén ne ndxinnap Jesus, wzelo men rzhidxno men Ne no wdee men xkwent Ne. ");
INSERT INTO zpi_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wtsëë men bzalo Ne no rdee men xkwent Ne, lex re men lo Ne: ―¿Txu rniiz xkwent de gan? ");
INSERT INTO zpi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","No ndalre ne wninyaan men lo Ne. ");
INSERT INTO zpi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Chene wyenii lyu, wdop yra men ne rnebééy lo men-Israel yra men maxter ley no le yra men fxuz ne rnebééy lo yra fxuz, lex wano men Jesus lo xtis-Israel. Nga wnabdiiz men lo Ne, re men: ");
INSERT INTO zpi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Guzëët gan pe laa de nak Crist. Wke Ne re Ne: ―Belne yna noo ne noo ne, ylaleedxdet de noo. ");
INSERT INTO zpi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","No belne ynabdiiz noo lo de yra de, ykedet de, ni yselaadetzeg de noo. ");
INSERT INTO zpi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Per desde orree sob Men ne wdxiid wak Mén koo Dëdyuzhnzoon ladbëë. ");
INSERT INTO zpi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Orguin re men lo Ne: ―¿Laa de nak XPee Dëdyuzh cheguin? Wke Ne re Ne: ―Zegwa we zeg na de. Noo ne. ");
INSERT INTO zpi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Orguin re men: ―Pe ylar be testig si laa be nak ne won diizree ne na ménree. ");
INSERT INTO zpi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lex wzuli men yra men, wano men Jesus lo Pilato. ");
INSERT INTO zpi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nga wzelo men rkagyii men Ne, re men: ―Wga ménree lo noo kagoots men xtoo menlaz noo, no na men ne ryaldet guezh zeg impwest lo rrey-Roma, no na men ne laa men nak Crist no ne laa men nak te rrey. ");
INSERT INTO zpi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Orguin wnabdiiz Pilato lo Ne, re Pilato: ―¿Pe laa de nak xerrey men-Israel? Wke Ne re Ne: ―Zegwa we zeg na de. ");
INSERT INTO zpi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Orguin re Pilato lo fxuz ne rnebééy lo yra fxuz no le lo yra mén ne ndxin nga: ―Ryenen noo ne bet ne mal wlaadet ménree, por neguin rzëldeto lo noo. ");
INSERT INTO zpi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Per lel mazre rderëz men, re men: ―Noze rgoots men xtoo men-Judea por yra ne rneluu men. Galilea wzelo men, naaree naa le men che wlenza no nee. ");
INSERT INTO zpi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ne won Pilato zenga, wnabdiiz Pilato lo men gan pe men-Galilea nak Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Chene re men ne men-Galilea nak Ne, wxaal Pilato Ne lo Herodes ne nak rrey Galilea porke no Herodes ka Jerusalén cheguin. ");
INSERT INTO zpi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Or ne wii Herodes Ne, kesentyent wzhiilen men, porke che wakxche rlaan men kwii men Ne, porke won men ruu mén xdiiz Ne no rlaan men ne ylaa Ne te gyelmilaguer kwii men. ");
INSERT INTO zpi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ndal ne wnabdiiz Herodes lo Ne, per bet wkedet Ne. ");
INSERT INTO zpi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nga ke ndxin yra fxuz ne rnebééy lo yra fxuz no le yra maxter ley, axtegue rbë́zdet rkagyii men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Orguin wzelo Herodes yra Herodes xsoldad Herodes wlaa men Ne zegne rlaantee men, no por ne yzhidxno men Ne, wnegak men Ne te lër ne rak rrey. Zhich guin wxaal ke men Ne lo Pilato. ");
INSERT INTO zpi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dxe guin wtsowxmig Pilato Herodes, porke rlayalsaa men chekwlodee. ");
INSERT INTO zpi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Lex wtop Pilato yra fxuz ne rnebééy lo yra fxuz no le yra men ne rnebééy lo men-Israel no le yra mengyëz. ");
INSERT INTO zpi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Re Pilato lo men: ―Laa de yra de wdxidsan ménree nee; na de ne laa men ka kagoots xtoo mén; per che wnabdizyu noo lo men nes lo de yra de, bet ne mal ne rkagyii de men wzëldet lo noo, ");
INSERT INTO zpi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ni lo Herodes, le men wxaal ke Herodes nee. Che rwii de yra de ne bet ne mal ne rzëël guet men wlaadet men. ");
INSERT INTO zpi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Noze yzakzi noo men, lex yselaa ke noo men. ");
INSERT INTO zpi_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lo lni pask rap Pilato degne rselaa Pilato te mén ne nuu chegyiib. ");
INSERT INTO zpi_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Per wzelo men yra men rderëz men, re men: ―¡Guket men gwa! ¡Guselaa Barrabás! ");
INSERT INTO zpi_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Wguu mén Barrabás chegyiib por ne wzobnadil Barrabás mén Jerusalén no por ne wket Barrabás mén. ");
INSERT INTO zpi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Wlaan Pilato nselaa Pilato Jesus, lex wnii Pilato lo yra men guin ste. ");
INSERT INTO zpi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Per wzelo men yra men mazre rderëz men, re men: ―¡Lo kruz gukaa men! ¡Lo kruz gukaa men! ");
INSERT INTO zpi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ne wyon tir re Pilato lo men yra men: ―¿Penako? ¿Pe ne malzhe wlaa men? Noo ryenen noo ne bet ne mal ne rzëël guet men wlaadet men. Noze yzakzi noo men, lex yselaa ke noo men. ");
INSERT INTO zpi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per lel mazre rderëz yra mén guin, rnab men ne ykaa Ne lo kruz. Por tant ne rderëz men yra men fxuz ne rnebééy lo yra fxuz, wun men gan wak ne wlaan men. ");
INSERT INTO zpi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Orguin wna Pilato wlaa Pilato ne rnab men. ");
INSERT INTO zpi_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wselaa Pilato Barrabás, men ne wlaan yra mén guin ne yláá, no por ne wzobnadil men mén nuu men chegyiib no por ne wket men mén. Lex wdekwent Pilato Jesus lo yra mén chen ylaa men Ne zegne rlaantee men. ");
INSERT INTO zpi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Chene zano men Jesus ne ykaa men Ne lo kruz, nëz wtsëlo men te men-Cirene ne la Simon, den wberee men guin; lex wnëëz men men, wnegweey men men xekruz Ne, lex zanal men zhich Ne. ");
INSERT INTO zpi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ndalyaa mén zanal Ne no ndalyaa wnaa ne roon robtsaatee por ne nles nuu lextoo men por laa Ne. ");
INSERT INTO zpi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Per wii Ne lo men, lex re Ne lo men: ―Wna-Jerusalén, goondet de por noo, sinke gugoon por laake de no le por zhiin de. ");
INSERT INTO zpi_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porke sdxiin dxe ne gue de yra de: “Nzoon wnaa ne che nunla ne gapdet mëëd, nzoon wnaa ne axtegue wkaadet mëëd lextoo no le wnaa ne axtegue wguedxdet mëëd.” ");
INSERT INTO zpi_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Cheguin selo mén gue men lo gyeey: “Gugyab led noo”; no gue men lo bles: “Gugyixlaan noo.” ");
INSERT INTO zpi_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Porke belne zeree rlaa mén yagyaa, ¿pezee ylaaleg men yagbidx? ");
INSERT INTO zpi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","No zano men txup ngbaan chen ykaa men men lo kruz yra men Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Chene wdxiin men ledne la Berxtoo Mengut, wkaa men Jesus lo kruz no wkaa ke men yrup ngbaan guin lo kruz: te men wkaa lo kruz ne zob koo Ne ladbëë, le ste men wkaa lo kruz ne zob koo Ne ladbëg. ");
INSERT INTO zpi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Chene le Ne ka lo kruz, re Ne: ―Dëde, gugun men perdon porke nandet men pe rlaa men. Le yra soldad wa pwest gan txu yganen xab Ne. ");
INSERT INTO zpi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Le yra mén ndxin nga rwii, no axtegue xtis rzhidxno Ne, re men: ―Wselaa ménree ste mén; orrenaa yselaa men men laake men, belne nli laa men nak Crist ne wxaal Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Zenga ke rzhidxno soldad Ne, rbig soldad rdee soldad binaguer goo Ne. ");
INSERT INTO zpi_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Re soldad lo Ne: ―Belne laa de nak xerrey men-Israel, guselaa de laake de. ");
INSERT INTO zpi_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Lex wkaa men leter xtoo xekruz Ne kon diz-griego, kon diz-latín no le kon diz-hebreo, re leter guin: “Laa xerrey men-Israel nee.” ");
INSERT INTO zpi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","No te ngbaan ne ka lo kruz wninyaan lo Ne, re men: ―Belne laa de nak Crist, guselaa de laake de no guselaa noo yrup noo zeree. ");
INSERT INTO zpi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Per wakndux ste mén guin lo men, re men: ―¿Pe rdxedet de Dëdyuzh, no laake kastig ke gwa kadee de? ");
INSERT INTO zpi_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Laa be rzëël be ne kayak be sufrir, porke zeree rgyizh be ne wlaa be, per le ménree bet ne mal wlaadet men. ");
INSERT INTO zpi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Lex re men lo Jesus: ―Jesus, ynileedxchee de noo chene ydxiin de ledne ynebééy de. ");
INSERT INTO zpi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Wke Jesus, re Ne: ―Nligue yna noo lo de, ne nedxekeree tsuu de ledne nuu Dëdyuzh yrup de noo. ");
INSERT INTO zpi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Zeg rwen ngbiz wzelo waknkeb ydendxee gyëzlyu axtegue beytson wzëë. ");
INSERT INTO zpi_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Noze waknkeb lo ngbiz; wrëznzeli kortin ne ka lenxeydoo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Orguin wkarëz Jesus, re Ne: ―Dëde, ledxnya de guu xespíritu noo. Nonchee wluzh re Ne zenga, wetgue Ne. ");
INSERT INTO zpi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chene wii kapitan neguin ne wak, wzaknon men Dëdyuzh, re men: ―Nli ne bet xdoldet ménree. ");
INSERT INTO zpi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yrandxee mén ne ndxin nga no ne wii neguin ne wak, wka men nëz sya men, rzelo men rgap laz men por gyelenles. ");
INSERT INTO zpi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Per le yra mén ne rnebeey Jesus no le yra wnaa ne wrunal Ne axtegue Galilea, wyan men axtegue nat rwii men yra neguin ne kayak. ");
INSERT INTO zpi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Cheguin nuu te mgyeey ne la Xeb, men-Arimatea gyëz ne nak lo lyu ne la Judea nak men. Wen men no ryal ne rlaa men no men nak te xtis-Israel. ");
INSERT INTO zpi_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Kambë́z men ne gak ne rkyeen Dëdyuzh, no wyandet men byen ne wlaa yra mén guin Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Lex wa men lo Pilato wnab men xkwerp Jesus. ");
INSERT INTO zpi_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chene wluzh wlit men Ne lo kruz, wtxël men Ne te saben, lex walu men Ne te lenbaa ne ndeen txugye ledne rutlel gardet tsuu. ");
INSERT INTO zpi_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dxe guin nak ne nulyaaz yra men-Israel gan kox ykyiinen men dxe ne rne men porke che mer selo dxe guin. ");
INSERT INTO zpi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yra wnaa ne wrunal Jesus axtegue Galilea, no men wanal wii men xbaa Jesus no wii men pezee wguu mén Jesus lenbaa. ");
INSERT INTO zpi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chene wberee men ruyuu, wzhexkwaa men perfum no le seyt ne rrenex. Lex wne men dxe ne rne men-Israel zegne zëëd lo ley. ");
INSERT INTO zpi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dxe ne rzelo xman, rsilgue wa yra wnaa guin ruxbaa Jesus. Weey men perfum ne wzhexkwaa men, no wanal stebëd wnaa men. ");
INSERT INTO zpi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chene wdxiin men, wii men le gye ne zemzëë rubaa che zu tebkoo. ");
INSERT INTO zpi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Lex wdee men lenbaa, per wzëldet Jesus lo men. ");
INSERT INTO zpi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Axtegue nandet men pe nlaa men. Tebegue wii men le txup mgyeey ne nak lërrkabnii zuli koo men. ");
INSERT INTO zpi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Por tant rdxe men, wlitlo men wii men lyu. Lex re mgyeey guin lo men: ―¿Penak rye de menmbán lad mengut? ");
INSERT INTO zpi_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yëtre men nee; le men che wban. Gunileedx ne na men lo de chene benak ka men Galilea. ");
INSERT INTO zpi_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Na men lo de ne Men ne wdxiid wak Mén, sdekwent mén men lo mendol chen ykaa men men lo kruz, per chene gyon gbiz, yban ke men. ");
INSERT INTO zpi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Orguin wnileedx men diiz ne re Jesus lo men. ");
INSERT INTO zpi_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chene wberee men ne wa men rubaa, wuu men diizo lo yra chibteb poxter no le lo stebëd xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Laa Mli Matlen no le Xwan no le Mli xnaa Jacob no le stebëd wnaa nak ne wa wuu diiz guin lo yra poxter. ");
INSERT INTO zpi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Per wlaleedxdet men logne re yra wnaa guin, nuu lextoo men pazer noze le men rnii. ");
INSERT INTO zpi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Per wruu Bëd, noze rzhoon Bëd za Bëd rubaa; chene wii Bëd lenbaa, nonchee saben zhoobtee. Orguin wberee Bëd, rzee rzak Bëd ne wii Bëd neguin ne wak. ");
INSERT INTO zpi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dxe ke guin, za txup xpén Jesus te gyëz ne la Emaús, zeg chibteb kilometro ryano kwlo Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Za men ruu men diiz yra neguin ne wak. ");
INSERT INTO zpi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Laatee ne kayuu men diizo, wbig Jesus lo men yrup men, za Jesus yra Jesus men. ");
INSERT INTO zpi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Per mase rwii men Ne, per zegnak te ne rsoow lo men, wnebeeydetgue men Ne. ");
INSERT INTO zpi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Lex wnabdiiz Ne lo men, re Ne: ―¿Pagox gwa ruu de diiz ne zëëd de nëz? ¿Penak nles nuu lextoo de? ");
INSERT INTO zpi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wke te men ne la Cleofas, re men: ―Yrandxee mén nan ne wak Jerusalén che padxe guin. ¿Pe nonchee laa de ka Jerusalén ne nandeto? ");
INSERT INTO zpi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Lex re Ne lo men: ―¿Pagox wak? Orguin re men: ―Ne wzak Jesus zhan-Nazaret, ne nak te profet ne kesentyent rap poder nes lo Dëdyuzh no le nes lo yra mén, nigle por yra ne rlaa zhaa, nigle por yra diiz ne rnii zhaa. ");
INSERT INTO zpi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wdekwent xextis be zhaa yra xextis be fxuz ne rnebééy lo yra fxuz chen ykaa mén zhaa lo kruz; zenga guet zhaa. ");
INSERT INTO zpi_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Le noo yra noo nuu lextoo ne laa zhaa nak ne yselaa men-Israel, per orrenaa nedxeree wyon gbiz ne wak yra neree. ");
INSERT INTO zpi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Le nersilree, wa txup tson wnaa ne nuu lad noo rubaa, lex legue wneche men noo, ");
INSERT INTO zpi_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","porke wzëldet zhaa lo men, lex na men lo noo yra noo ne wlalo txup angel lo men, re angel ne mbán zhaa. ");
INSERT INTO zpi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Zhich guin wague txup tson xkompanyer noo rubaa, no nli ne zenga wak zegne na yra wnaa guin, per wiidet xkompanyer noo zhaa. ");
INSERT INTO zpi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Orguin re Jesus lo men: ―¿Penak rdeedet de kwent, no pa axtegue or ylaleedx de ne re profet? ");
INSERT INTO zpi_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Pe let rapdet Crist ne sak Ne yra neree antes ne gya Ne ledne nzoon? ");
INSERT INTO zpi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Lex wzelo Ne wzëët Ne lo men yrup men yra ne zëëd lo xgyiich Dëdyuzh por laa Ne. Primer wzëët Ne ne zëëd lo liber ne wkaa Moises, zhich guin wzëët Ne ne wkaa yra profet. ");
INSERT INTO zpi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ne wdxiin men gyëz ne za men, wlaa Jesus zeg rlaa men ne tesu. ");
INSERT INTO zpi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Per wkyenfwers men Ne ne yzëën Ne yra ne men, re men lo Ne: ―Guzëën, porke che rzëë no che zëdnit lyu. Orguin wdee Ne lenyuu chen yzëën Ne yra Ne men. ");
INSERT INTO zpi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chene che zob Ne lo mezh yra Ne men, wgoob Ne gyëtxtil, lex wdee Ne dexkyizhtee lo Dëdyuzh; wluzh nga wla No, wdee No lo men yrup men. ");
INSERT INTO zpi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Orguin nak bzalo men zegnak ne wyenii, wnebeey men Ne; per orgueguin nonchee wnitlo Ne. ");
INSERT INTO zpi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Lex rulsaa men diiz, re men: ―Kon rrazón ne nzoon nuu lextoo be chene zëëd be nëz ne zëdyuu zhaa diiz lo be no chene rzëët zhaa gan pe rna ne re lo xgyiich Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Orguin wyuli men nëz, wbë́zdetre men nga. Wberee ke men Jerusalén ledne ndxin yra chibteb xpoxter Ne no le stebëd xkompanyer men ");
INSERT INTO zpi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ne re lo men: ―Nli ne wban Jesus, wlalo Ne lo Simon. ");
INSERT INTO zpi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lex wuu men diiz lo yra poxter logne wzak men nëz no ne gan pezee wnebeey men Jesus chene wla Ne gyëtxtil. ");
INSERT INTO zpi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Benak kayuu men diiz guin, tebegue wlalo Jesus gwrooltee lad men yra men. Wgabtyuzh Ne men, re Ne: ―Dëdyuzh yseleedx gyelendxi lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kesentyent wdxe men yra men, nuu lextoo men pazer te anem rwii men. ");
INSERT INTO zpi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Per re Jesus lo men: ―¿Penak rdxe de? ¿Penak nutxup lextoo de? ");
INSERT INTO zpi_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gukwii nya noo, gukwii nii noo gante, noo ke ne. Gunëëz led noo gante, porke te anem neeydeto bëël, ni nuudeto dxit zegne rwii de nak noo. ");
INSERT INTO zpi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wluzhse re Ne zenga, wluu nya Ne lo men no wluu nii Ne. ");
INSERT INTO zpi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Per kom wlaleedxdetgue meno por tant rzhiilen men no por tant gyelgwzee ne nuu men, lex re Jesus lo men: ―¿Pe nuu pe rap de gu be? ");
INSERT INTO zpi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Orguin wdee men tebla mël wgye lo Ne no le stebla mkuudx ne nuu dxin. ");
INSERT INTO zpi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Lex wnëëz No, wu No nes lo men yra men. ");
INSERT INTO zpi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Zhich guin re Ne lo men: ―Neree ne wzak noo, laa we nga na noo lo de yra de chene benak zu noo lad de: ne rap degne gak xkwent noo ne zëëd lo liber ne wkaa Moises no le ne zëëd lo yra liber ne wkaa yra profet no le lo liber Salmos. ");
INSERT INTO zpi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Orguin wlaa Ne ne wdee bnii xgyeryen men yra men chen ydee men kwent ne zëëd lo xgyiich Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Re Ne lo men: ―Zeree zëëd lo xgyiich Dëdyuzh, ne rap Crist degne sakzi Ne no guet Ne; per chene gyon gbiz, yban ke Ne. ");
INSERT INTO zpi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","No por la Ne yzëët mén xdiiz Dëdyuzh lo yrandxee mén ne nuu ydendxee gyëzlyu, selo men axtegue Jerusalén gue men lo mén ne rap mén degne ysaan xgyelmal mén, ylaleedx men Ne chen gun Dëdyuzh perdon xdol men. ");
INSERT INTO zpi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Laa de yra de nak ne yzëët yra neree lo mén. ");
INSERT INTO zpi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Lex noo yxaal ne re Xuz noo ne yxaal me por laa de yra de. Per nee Jerusalén gukaa axtegue ne ykakwent de poder ne yruu gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Zhich guin wruno Jesus men lenlgyëz-Jerusalén, wano Ne men yra men guex Betania, lex wlisgya nya Ne wneleey Ne men. ");
INSERT INTO zpi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Or ne kaneleey Ne men, wyas Ne lad men sya Ne gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ne wluzhse wzaknon men Ne, wberee ke men Jerusalén, kesentyent rzhiilen men. ");
INSERT INTO zpi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","No yzhe yzhendxee nuu men lenxeydoo Dëdyuzh rzaknon men Dëdyuzh. Zengaw.");
INSERT INTO zpi_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Axtegue antes ne gaa gyëzlyu, che nuu diiz, laa diiz guin nga nak Jesus no che nuu Ne lo Dëdyuzh, laake Ne nga nak Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Che nuu Ne lo Dëdyuzh axtegue antes ne gaa gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Laa Ne wzhexkwaa yrandxee ne nuu; bet yët ne wzhexkwaa noze zhal. ");
INSERT INTO zpi_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Laa Ne rap gyelembán; gyelembán guin nak bnii por yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bnii guin rlaa ne ryenii xgyeryen menmal ne le men ryenen ne mal ne rlaa men, no rundet ne mal gan ytsëë lo bnii guin. ");
INSERT INTO zpi_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wuu te mén ne la Xwa, laa Dëdyuzh wxaal men, ");
INSERT INTO zpi_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","wdxidzëët men xkwent bnii guin, chen yrandxee mén ylaleedxo. ");
INSERT INTO zpi_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Let laadet Xwa nak bnii guin, sinke noze wdxidzëët men xkwento. ");
INSERT INTO zpi_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Porke le merpee bnii guin ne nak Jesus che wdxiid gyëzlyu, laa Ne rlaa ne ryenii xgyeryen yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wuu Ne gyëzlyu, no mase laa Ne wzhexkwaa gyëzlyu, per wnebeeydet mén Ne. ");
INSERT INTO zpi_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wdxiid Ne lo menlaz Ne, per wukasdet menlaz Ne Ne. ");
INSERT INTO zpi_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Per le yrandxee mén ne wukas Ne no ne wlaleedx Ne, wlaa Ne men zhiin Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","per let zegne rlaadet mengyëzlyu ne ruu zhiin men, ni zegne rlaan led mengyëzlyu, ni zegne rlaa mgyeey ne ruu zhiin men, sinke por ne rlaleedx men Ne, che zhiin Dëdyuzh nak men. ");
INSERT INTO zpi_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Diiz guin, wako mén, wdxiid mén guin wuu men lad be. Wii noo xgyelenzoon men yra noo, gyelenzoon ne rap men ne tendxee men nak XPee Dëdyuzh. No kesentyent ryaan men mén, no teblose diznli rnii men. ");
INSERT INTO zpi_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Laa xkwent men nga wzëët Xwa chene re Xwa: ―Laa ménree nga wzëët noo chene re noo: “Zhich noo zëëd te mén ne mazre nondee ke lo noo, porke cheguel nuu men chene wal noo.” ");
INSERT INTO zpi_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Por ne kesentyent ryaan Jesus be, zayaknonenlel Ne be yrandxee be. ");
INSERT INTO zpi_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Por Moises wlenza xley Dëdyuzh lo be, per por Jesucrist waknan be pezee ryaan Dëdyuzh be no waknan be gan gonezhe nak ne nli. ");
INSERT INTO zpi_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Axtegue nunk gardet kwii ni te mén Dëdyuzh, per laa XPee Ne ne tendxee nak ne wluu gan pezee nak Dëdyuzh, porke lo ke Dëdyuzh nuu mee. ");
INSERT INTO zpi_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Chene wxaal men-Israel ne nak xtis-Jerusalén txup tson fxuz no le txup tson men ne zëëd xnëz Leví por ne ynabdiiz men lo Xwa gan txu nak Xwa, ");
INSERT INTO zpi_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","wxalruu Xwa, wkedxnruudet Xwa, re Xwa lo men: ―Let noodet nak Crist. ");
INSERT INTO zpi_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Lex wnabdiiz men ste, re men: ―¿Txu nak de cheguin? ¿Pe laa de nak Elías? Wke Xwa, re Xwa: ―Let noodet ne. Wnabdiizgue men ste, re men: ―Guex, ¿pe laa de nga nak profet ne gyed chiid? Wke Xwa, re Xwa: ―Let noodet ne. ");
INSERT INTO zpi_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Lex re men: ―¿Txu nak de cheguin? Porke rap noo degne ybereneey noo diiz lo yra mén ne wxaal noo. Guzëët gan txu nak de. ");
INSERT INTO zpi_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wke Xwa, re Xwa: ―Noo nak men ne wzëët profet-Isaías chene re zhaa: “Zon de ylen xrëz te mén denbidx, gue men: Guxal te nëz ne tebli ne nak por Dëdyuzh.” ");
INSERT INTO zpi_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yra mén guin ne wa lo Xwa, laa men ne nak farisew wxaal men ");
INSERT INTO zpi_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ne wanabdiiz men lo Xwa, re men: ―Belne let laadet de nak Crist, ni let laadet de nak Elías, ni let laadet de nak profet ne gyed chiid, ¿penak rtxobnis de mén cheguin? ");
INSERT INTO zpi_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Wke Xwa, re Xwa: ―Noo kon nis rtxobnis noo, per lad de yra de nuu te mén ne ni laa de rnebeeydet. ");
INSERT INTO zpi_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Le men gyed zëëd no axtegue ni xgyël men rzëëldet noo ychil noo nii men porke mazre nondee men ke lo noo. ");
INSERT INTO zpi_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yra neree, ledne la Betábara wako stebkoo gyow-Jordán ledne wkatxobnis Xwa mén. ");
INSERT INTO zpi_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ne wra gyëël wii Xwa ne zabig Jesus lo Xwa, lex re Xwa: ―Gukwii, laa ménree nga wxaal Dëdyuzh chen guet men zegnak te mëkzhiil bëën bëënleg chen guezh xdol mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Laa menree nga wzëët noo chene re noo: “Zhich noo zëëd te mén ne mazre nondee ke lo noo, porke cheguel nuu men chene wal noo.” ");
INSERT INTO zpi_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ni noo wnebeeydetgue noo men, per le noo zëdtxobnis kon nis chen ynebeey men-Israel men. ");
INSERT INTO zpi_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","No re ke Xwa: ―Wii noo zëdtseeb Espíritu Sant gyeybaa zegnak te mëër, wyab Ne led men. ");
INSERT INTO zpi_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ni noo wnebeeydetgue noo men; per laa Dëdyuzh ne wxaal noo ne ytxobnis noo kon nis, na lo noo: “Men ne kwii de ne gyab Espíritu Sant led, men guin nak ne ytxobnis kon Espíritu Sant.” ");
INSERT INTO zpi_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Le noo che wii men, por neguin rzëët noo ne XPee Dëdyuzh nak men. ");
INSERT INTO zpi_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Wra gyëël, nga ke zu Xwa ste yra Xwa txup xpén Xwa. ");
INSERT INTO zpi_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Chene wii Xwa ne zatee Jesus nga, re Xwa: ―Gukwii, laa menree nga wxaal Dëdyuzh chen guet men zegnak te mëkzhiil bëën bëënleg. ");
INSERT INTO zpi_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ne won yrup xpén Xwa ne re Xwa zenga, zanalgue men Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chene wcheree lo Jesus, wii Jesus le yrup men zanal, re Jesus lo men: ―¿Kox rye de? Wke men re men: ―Rabí, ¿pazh ka de? (Rabí rna Maxter). ");
INSERT INTO zpi_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wke Jesus, re Jesus lo men: ―Gutanal noo chen kwii de ledne ka noo. Lex wa men wii ledne ka Jesus, nga wnit lyu lo men, porke che zeg beytap wzëë orguin. ");
INSERT INTO zpi_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ndrizh bech Simon-Bëd nak te men ne wanal Jesus ne won men ne re Xwa. ");
INSERT INTO zpi_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ne primerdee wlaa Ndrizh, waye Ndrizh bech Ndrizh Simon, lex re Ndrizh lo bech Ndrizh: ―Che wan noo Mesías (ne rna Crist). ");
INSERT INTO zpi_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Lex wano men Simon lo Jesus; chene wii Jesus Simon, re Jesus lo Simon: ―Laa de nak Simon xpee Jonás, per naaree sela de Cefas (ne rna Bëd). ");
INSERT INTO zpi_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ne wra gyëël, wka Jesus nëz za Ne lo lyu ne la Galilea, lex wtsëlo Ne Blib, re Ne lo Blib: ―Gutanal noo. ");
INSERT INTO zpi_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Men-Betsaida nak Blib, men guin ke nak Ndrizh no men guin ke nak Bëd. ");
INSERT INTO zpi_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Lex waye Blib Natanael, re Blib lo Natanael: ―Che wan noo men ne rakzëët lo liber-ley ne wkaa Moises no le ne wkaa yra profet. Jesus men-Nazaret ne, xpee Xeb. ");
INSERT INTO zpi_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Lex re Natanael: ―¿Peguin sruu te menwen Nazaret? Wke Blib, re Blib: ―Yoo tsa be gante. ");
INSERT INTO zpi_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Chene wii Jesus ne le Natanael zabig guex, re Ne: ―Nee zëëd te merpee men-Israel ne rkadedet. ");
INSERT INTO zpi_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Orguin re Natanael lo Ne: ―¿Pezee rnebeey de noo? Wke Ne re Ne: ―Axtegue antes ne kwëz Blib de, che wii noo de, chene zu de zhiin te yag-ig. ");
INSERT INTO zpi_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Lex re Natanael: ―Maxter, laa de nak XPee Dëdyuzh, laa de nak xerrey men-Israel. ");
INSERT INTO zpi_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Wke Jesus, re Ne: ―¿Pe noze por ne na noo lo de ne wii noo de zhiin yag-ig, neguin rlaleedx de noo? Gyed kwiir de ne mazre nzoondee ke neree. ");
INSERT INTO zpi_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","No re ke Jesus: ―Nligue yna noo lo de, ne swii de zemyal gyeybaa no swii de xangel Dëdyuzh ne zëdtseeb zayeeptee led Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ne wyon gbiz wuu te dooy gyëz-Caná ne nak lo lyu ne la Galilea no xnaa Jesus zu lo dooy guin, ");
INSERT INTO zpi_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","no lo Jesus re mén guin ne ylaa dooy ne tsa Jesus dooy yra Jesus xpén Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chene le bin wbidx, re xnaa Jesus lo Jesus: ―Wbidx xbin men. ");
INSERT INTO zpi_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Wke Jesus, re Jesus: ―Wnaae, ¿penak na de zegwa lo noo? Gardet ydxiin or ne ylaa noo ne ryal ylaa noo. ");
INSERT INTO zpi_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Per re xnaa Jesus lo yra men ne rlaa dxiin nga: ―Gulaa yra ne yna Jesus lo de. ");
INSERT INTO zpi_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nga zu xuup gyus gye ne rdaa nis ne raa nya yra men-Israel no ne raa nii men, zegnak xkoxtumber men. Te te gyus guin rdaa we zeg tebgwyuu liter nis. ");
INSERT INTO zpi_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Lex re Jesus lo men ne rlaa dxiin nga: ―Gusezaa nis yra gyusree. Orguin wsezadoo meno. ");
INSERT INTO zpi_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Zhich guin re Jesus lo men: ―Orrenaa gukoo we tebruu we, gutsadee we lo mén ne zudíp lo dooy. Lex wano meno. ");
INSERT INTO zpi_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chene le mén guin ne zudíp lo dooy wzeeno, le we che wak bin, no ni nandet men pa wzaa we. Nonchee men ne rlaa dxiin nga nano, porke laa men waxii nis. Orguin wbëz mén guin ne zudíp lo dooy men ne kayak xdooy, ");
INSERT INTO zpi_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","lex re men lo men: ―Yrandxee mén, primer rgyiiz men bin ne mazre wendee; chene che kesentyent woo mén bin ne mazre wendee, lex rgyiiz men bin ne nguudxdee. Per le laa de wgutsoow de bin ne mazre wendee, axtegue orree wboo do. ");
INSERT INTO zpi_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Laa primer gyelmilaguer ne wlaa Jesus nee, gyëz-Caná ne nak lo lyu ne la Galilea wlaa No. Zenga wbonyoo Ne xgyelenzoon Ne, ne le yra xpén Ne wlaleedxre Ne. ");
INSERT INTO zpi_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wluzh wak neree, za Ne Capernaum yra Ne bech Ne, no le yra xpén Ne, no le xnaa Ne. Nga wkaa Ne yra Ne men txup tson gbiz. ");
INSERT INTO zpi_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Chene che wyob pask lni ne rlaa men-Israel, za Jesus Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Wdxiin Ne ruxeydoo Dëdyuzh, le yra mén ne katoo yuz, mén ne katoo mëkzhiil, mén ne katoo mëër, ndxin nga rtoo yra maa guin, no zob ke mén ne rtsaa medzit. ");
INSERT INTO zpi_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ne wii Ne ne ndxin yra mén guin nga, wzhexkwaa Ne tebla duu, lex kon duu guin wboo Ne men nga yra men xyuz men no le xpëkzhiil men, no wtxëëts Ne yrandxee xmed mén ne rtsaa medzit, no wnekantaa Ne yra xmezh men, ");
INSERT INTO zpi_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","le lo yra mén ne rtoo mëër re Ne: ―¡Gukoo neree nee! ¡Ylaadet de xyuu Xuz noo zegnak lgyeey! ");
INSERT INTO zpi_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Orguin wnileedx yra xpén Jesus ne ka lo xgyiich Dëdyuzh ledne re: “Tant rlaan noo ganchi noo xyuu de, rlayaa noo ne rzaknondet méno.” ");
INSERT INTO zpi_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Lex re men-Israel lo Ne: ―Gulaa te gyelmilaguer kwii noo chen gyen ne rap de derech ne rlaa de neree. ");
INSERT INTO zpi_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Wke Ne re Ne: ―Gulitla ydooree, tsonegue gbiz ylep ke noo we ste. ");
INSERT INTO zpi_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Lex re men: ―Txuplalno-xuup iz wkalep mén ydooree. ¿Le laa de naa ne ylepo tsonegue gbiz? ");
INSERT INTO zpi_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per let xkwentet ydoo wzëët Ne ne re Ne zenga, sinke led ke Ne wzëët Ne. ");
INSERT INTO zpi_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Por neguin, chene le Ne wban, wnileedx yra xpén Ne diiz guin ne re Ne, wlaleedx men yra diiz ne zëëd lo xgyiich Dëdyuzh no le yra diiz ne re Ne. ");
INSERT INTO zpi_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ne ka Jesus Jerusalén lo lni pask, ndalyaa mén wlaleedx Ne ne wii men yra gyelmilaguer ne rlaa Ne. ");
INSERT INTO zpi_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per wlaleedxdet Ne men, porke nanwen Ne gan kox nuu lextoo men yrandxee men. ");
INSERT INTO zpi_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Rut wkyiinden Ne ne nzëët gan pezee nak mén porke nanwen Ne gan kox nuu lextoo te te mén. ");
INSERT INTO zpi_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wuu te men ne nak farisew ne la Nicodemo, no men nak te men ne rnebééy lo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Gyëël wa menree lo Jesus, re men: ―Maxter, nan noo ne Dëdyuzh wxaal de ne yneluu de noo yra noo. Porke ni te mén gundet gan ylaa gyelmilaguer ne rlaa de belne raknonden Dëdyuzh men. ");
INSERT INTO zpi_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Lex wke Jesus, re Ne: ―Nligue yna noo lo de ne men ne galdet ste, gakdet ydxiin men ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Lex re Nicodemo: ―¿Pezee gak yberee te mengol ne gal men ste? ¿Peguin sak tee men txu xnaa men por ne gal men ste? ");
INSERT INTO zpi_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Wke Jesus, re Ne; ―Nligue yna noo lo de ne men ne yrobnisdet kon nis no le kon Espíritu Sant, gakdet tsuu men ledne rnebééy Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yra mén ne ral zegne ral mengyëzlyu, noze mén nak men; per le mén ne ral por Espíritu Sant, lo Espíritu Sant ngab men. ");
INSERT INTO zpi_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yzeedet sak de ne na noo lo de ne yrandxee mén rap men degne gal men ste. ");
INSERT INTO zpi_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Porke zegnak mee nes ledne rlaantoo rleno, no mase ron de rbii we, per ni nandet de gan pa nëz zëëdo o gan pa nëz za we, zenga ke nak yra mén ne ral por Espíritu Sant. ");
INSERT INTO zpi_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Lex re Nicodemo lo Jesus: ―¿Pezee gak gan gak negwa ne na de? ");
INSERT INTO zpi_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Wke Jesus, re Ne: ―¡Laa de nak maxter lo men-Israel no rdeedet de kwent neree! ");
INSERT INTO zpi_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nligue yna noo lo de, rzëët noo ne nan noo no le ne wii noo, per rlaleedxdet do yra de. ");
INSERT INTO zpi_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Belne rlaleedxdet de noo ne rzëët noo ne rak gyëzlyuree, ¿pezee ylaleedx de noo belne yzëët noo ne rak gyeybaa? ");
INSERT INTO zpi_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ni te mén gardet gyeep gyeybaa sinke nonchee mén ne wruu gyeybaa ne wyët gyëzlyu, laa men nga nak Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Porke zegne wkaa Moises xebneb mëël xtoo yag denbidx, zenga ke Men ne wdxiid wak Mén rap men degne ykaa men lo kruz, ");
INSERT INTO zpi_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","chen yrandxee mén ne ylaleedx mén guin gap gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Por ne tant ryaan Dëdyuzh mengyëzlyu, mase tendxee XPee Ne no wxaal Ne XPee Ne gyëzlyu, chen yrandxee mén ne ylaleedx XPee Ne, gyadet men ledne sakzi men, sinke gap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Porke wxaaldet Dëdyuzh XPee Ne gyëzlyu ne yzakzi XPee Ne mén, sinke le Ne wxaal XPee Ne chen yselaa XPee Ne mén lo dol. ");
INSERT INTO zpi_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Men ne rlaleedx XPee Dëdyuzh, sakzidet men; per le men ne rlaleedxdet XPee Ne, cheguel sakzi men por ne rlaleedxdet men XPee Ne ne tendxee. ");
INSERT INTO zpi_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Cheguel sakzi mén, porke naaree ne wlenza men ne nak bnii, mazre wtseleedx mén ne mal, porke teblose ne mal rlaa men. ");
INSERT INTO zpi_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yrandxee men ne rlaa ne mal, rlaandet men bnii guin no rbigdet men lo we chen gyendet ne rlaa men; ");
INSERT INTO zpi_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","per le men ne rlaa ne nli, rbig men lo bnii guin, chen gaknyoo ne rlaa men zegne rlaan Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Zhich guin wa Jesus yra Ne xpén Ne lo lyu ne la Judea, nga wkaa Ne yra Ne men, wkatxobnis men mén. ");
INSERT INTO zpi_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","No ke Xwa ne rtxobnis katxobnis mén ledne la Enón guex Salim, porke nga nuu naal nis. Lex ra mén lo Xwa rtxobnis Xwa men. ");
INSERT INTO zpi_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chene gardet tsuu Xwa chegyiib, wak neree. ");
INSERT INTO zpi_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Orke guin wdildiiz xpén Xwa yra men tebëd ke men-Israel por koxtumber ne rap men-Israel ne rap men degne raa nya men no le nii men. ");
INSERT INTO zpi_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Lex wa xpén Xwa lo Xwa, re men: ―Maxter, le men ne wtsëlo de rugyow-Jordán ladro no ne wzëët de lo noo yra noo, le men katxobnis mén no yrandxee mén rdxiin lo men. ");
INSERT INTO zpi_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Wke Xwa, re Xwa: ―Ni te mén bet gundet gan ylaa belne let Dëdyuzhdet wseleedxo lo men. ");
INSERT INTO zpi_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Laake de yra de won ne re noo ne let noodet nak Crist, sinke laa Dëdyuzh wxaal noo ne zëdner noo lo Ne. ");
INSERT INTO zpi_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lo te dooy, mgyeey ne rtsëlnya laa men rzuno nzeb. Le xmig men ne zu nga, kesentyent rzhiilen men ne ron men ne rnii mén guin. Zenga ke kesentyent rzhiilen noo orree ne le Ne zu nee. ");
INSERT INTO zpi_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","No laa Ne nak ne mazre zayaknondee, le noo zayanmenosdee. ");
INSERT INTO zpi_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Men ne wruu gyeybaa, laa men nak ne mazre nondee lo yrandxee mén, le mengyëzlyu noze mengyëzlyu nak men no teblose ne nuu gyëzlyu rnii men. Per le men ne wruu gyeybaa, laa men nak ne mazre nondee lo yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ne wii men, neguin rzëët men no le ne won men, per rut rlaleedxdet ne rzëët men. ");
INSERT INTO zpi_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Per belne nuu mén rlaleedx ne rzëët men, men guin rbonyoo ne nli xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Porke men ne wxaal Dëdyuzh ne zëëd men, xdiiz Dëdyuzh rzëët men, porke laa Dëdyuzh nak ne kesentyent rseleedx Espíritu Sant lo men. ");
INSERT INTO zpi_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ryaan Dëdyuzh XPee Ne no wdee Ne yrandxee ne nuu gyëzlyu gyeybaatee lo XPee Ne chen ynebééy XPee No. ");
INSERT INTO zpi_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Men ne rlaleedx XPee Ne, che rap men gyelembán ne nunk luzhdet, per le men ne nadet ylaleedx XPee Ne, gapdet men gyelembán guin, sinke cheguel sguu Dëdyuzh xkastig men. ");
INSERT INTO zpi_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Chene waknan Jesus ne le men ne nak farisew che wyenen ne le Jesus katxobnis no ne ndaldee xpén Jesus ke lo xpén Xwa, ");
INSERT INTO zpi_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(mase let Jesusdet katxobnis mén, sinke xpén Jesus nak ne katxobnis mén.) ");
INSERT INTO zpi_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","wruu Jesus lo lyu ne la Judea sya ke Ne lo lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ne sya Ne lo lyu guin, wap Ne degne wdee Ne lo lyu ne la Samaria. ");
INSERT INTO zpi_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Wdxiin Ne te gyëz ne la Sicar ne nak lo lyu ne la Samaria, guex ledne ka lyu ne wgueed Jacob lo Xeb xpee Jacob. ");
INSERT INTO zpi_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nga zob pos ne rnii mén xpos Jacob, kom che wzaguen Jesus, wzobchee Ne koo pos guin, zeg rwen ngbiz orguin. ");
INSERT INTO zpi_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Le yra xpén Ne za lenlgyëz guin zaka men ne gu men. Orguin wdxiin te wna-Samaria ne zaxii nis rupos guin, lex re Jesus lo men: ―Gugued tebruu xnis de goo noo. ");
INSERT INTO zpi_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Orguin re wnaa guin lo Jesus: ―¿Penak rnab de nis lo noo si men-Israel nak de, le noo nak men-Samaria? (Re wnaa guin zenga, porke rtsëlsaadet men-Israel men-Samaria.) ");
INSERT INTO zpi_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Wke Jesus, re Ne: ―Belne gaknan de gan kox rseleedx Dëdyuzh no gaknan de gan txu nak noo, snab de nis ne goo de lo noo, noo yniiz nis ne rguu gyelembán goo de. ");
INSERT INTO zpi_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Lex re wnaa guin: ―Dechey, ni bet neeydet de ne koo de nis no kesentyent gyët pos. ¿Pazh koo de nis ne rguu gyelembán? ");
INSERT INTO zpi_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Peguin nondee de ke lo Jacob men ne nak xpenkwlal be? Laa men wsan posree nee, nisree woo men yra zhiin men no le yra xmaa men. ");
INSERT INTO zpi_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Wke Jesus, re Ne: ―Yrandxee mén ne roo nisree, rberee ke rlaan men nis ste; ");
INSERT INTO zpi_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","per le mén ne goo nis ne ydee noo, ybereedetre ylaan men nis. Porke nis ne ydee noo, ydaa we lextoo men zegne rdaa we rubzin, laa we ydee gyelembán ne nunk luzhdet lo men. ");
INSERT INTO zpi_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Lex re wnaa guin: ―Dechey, guniiz nis guin goo noo chen ylaandetre noo nis, ni chiidetre noo koo noo nis nee. ");
INSERT INTO zpi_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Lex re Jesus lo wnaa guin: ―Gutsaxii xemgyeey de, lex yberee de. ");
INSERT INTO zpi_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Wke wnaa guin, re men: ―Yëten noo xemgyeey noo. Lex re Jesus: ―Nli rnii de ne yëten de xemgyeey de. ");
INSERT INTO zpi_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porke che wzaa gaay mgyeey wap de, le men gwa ne rap de naaree, let xemgyeeydet de nak men; neguin nan noo ne nli rnii de. ");
INSERT INTO zpi_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ne won wnaa guin zenga, re men: ―Dechey, ryenen noo ne te profet nak de. ");
INSERT INTO zpi_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Xpenkwlal noo yra noo nee gyeeyree wdxiid men wzaknon men Dëdyuzh, per le laa de yra de ne nak de men-Israel, re de ne Jerusalén nak ledne rap mén degne tsa men saknon men Ne. ");
INSERT INTO zpi_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Wke Jesus, re Ne: ―Wnaae, gulaleedx noo ne che wyob saknon mén Dëdyuzh sin ne chiidetre men nee gyeeyree, ni tsadetre men Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Laa de yra de ne nak de men-Samaria, nandet de gan txu rzaknon de, per le noo yra noo nan noo gan txu rzaknon noo; porke lad men-Israel yruu men ne yselaa mén lo dol. ");
INSERT INTO zpi_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sdxiin or no laa orguin nee ne yrandxee mén ne nli rzaknon Dëdyuzh, ylaa meno ydebgyiky ydeblextootee men zegne ryal ylaa meno. Porke zenga rlaan Dëdyuzh ne ylaa yra mén ne rzaknon Ne. ");
INSERT INTO zpi_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dëdyuzh Espíritu nak Ne, no yrandxee mén ne rzaknon Ne, rap men degne ylaa meno ydebgyiky ydeblextootee men zegne ryal ylaa meno. ");
INSERT INTO zpi_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Lex re wnaa guin: ―Nan noo ne schiid Mesías ne la ke Crist; chene chiid men, laa men yzëëto yra we lo be. ");
INSERT INTO zpi_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Orguin re Jesus: ―Noo nak men guin, laa men nee kayuno de diiz. ");
INSERT INTO zpi_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Laatee orguin wberee yra xpén Jesus, kesentyent wzee wzak men ne wii men kayuu Ne diiz yrup Ne te wnaa; per ni te men wnabdiizdet gan pe rlaan wnaa guin o gan pe diizzhe ruu Ne yrup Ne men. ");
INSERT INTO zpi_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nga wsan xree wnaa guin sya men. Wdxiin men lenlgyëz, re men lo mén: ");
INSERT INTO zpi_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Gutaa gante, tsa be kwii de te mén ne wzëët yrandxee ne wlaa noo. ¿Pe let laadet Crist nga? ");
INSERT INTO zpi_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Lex wruu yra mén gyëz guin za men lo Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Myentras ne nuu yra mén guin nëz, wzelo yra xpén Jesus re men lo Jesus: ―Maxter, gugu. ");
INSERT INTO zpi_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wke Ne re Ne: ―Noo che rap noo ne ru noo, rnebeeydet do. ");
INSERT INTO zpi_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Lex wzelo yra xpén Jesus rnabdizlsaa men, re men: ―¿Peguin nuu txu wdxidneey ne wu Jesus? ");
INSERT INTO zpi_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Orguin re Jesus: ―Ne ru noo nak ne ylaa noo ne rlaan Dëdyuzh no ne yseyal noo ne wxaal Ne noo ylaa noo. ");
INSERT INTO zpi_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Re de yra de: “Benak rak falt tap mëëw ne ydxiin kwlaap.” Per yna noo lo de: Gulis lo de gukwii den, le we che wal, wal ylaap de. ");
INSERT INTO zpi_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Men ne rkaa kwlaap rezh rka men; logne rtop men por gyelembán ne nunk luzhdet nako, chen tese yzhiilen men ne rguu bni yra men men ne rkaa kwlaap. ");
INSERT INTO zpi_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nli ne re lo diiz: “Wren mén ne rguu bni, wren mén ne rlaap.” ");
INSERT INTO zpi_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Noo wxaal de walaap de ledne wlaadet de dxiin; wren mén ne wlaa dxiin no laa de walaap ledne wlaa men dxiin. ");
INSERT INTO zpi_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ndalyaa mengyëz guin wlaleedx Jesus por ne re wnaa guin lo men: “Yrandxee ne wlaa noo wzëët Jesus lo noo.” ");
INSERT INTO zpi_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Por neguin chene wdxiin yra mén guin lo Jesus, wnab men lo Ne ne ykaa Ne lo men. Lex wkaa Ne lo men txup gbiz, ");
INSERT INTO zpi_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","no ndalre mén wlaleedx Ne por ne won men diiz ne re Ne laa zhal Ne. ");
INSERT INTO zpi_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Lex re men lo wnaa guin: ―Orree si let nozdet por ne na de lo noo yra noo rlaleedx noo ménree, sinke por ne noo zhal won ne rzëët men, no nan noo ne nli laa men yselaa mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chene wluzh txup gbiz, wruu Jesus lo lyu ne la Samaria za ke Ne lo lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","No laake Ne re, ni te profet rzaknondet mén men laake laz men. ");
INSERT INTO zpi_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Le chene wdxiin Ne Galilea, kesentyent waknzebnëz mén guin lo Ne porke no men wa lni pask Jerusalén wii men yrandxee ne wlaa Ne. ");
INSERT INTO zpi_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Zhich guin wa Ne Caná ste ne nak lo lyu guin ne la Galilea, ledne wlaa Ne nis bin. Capernaum nuu te xsoldad rrey, rzhuun xpee men. ");
INSERT INTO zpi_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chene won men ne le Jesus che wruu lo lyu ne la Judea wdxiin Ne lo lyu ne la Galilea, wa men lo Ne wanab men ne tsa Ne ruxyuu men yneseyaken Ne xpee men porke che mer mer guet mee. ");
INSERT INTO zpi_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Lex re Ne lo men: ―Laa de yra de belne bet gyelmilaguer kwiidet de, bet ylaleedxdet de. ");
INSERT INTO zpi_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Per re men: ―Dechey, yoo tsague be antes ke ne guet xpee noo. ");
INSERT INTO zpi_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Orguin re Jesus lo men: ―Guberee ruxyuu de, le xpee de che wyaken. Wlaleedx men ne re Jesus, syague men ruxyuu men. ");
INSERT INTO zpi_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Chene sya men, wruu xmos men watsëlnëz men men, re men lo men: ―Le xpee de che wyaken. ");
INSERT INTO zpi_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Lex wnabdiiz men gan pa orzhe wzelo wruu xlaa led xpee men, re yra mén guin: ―Naag beyteb wruu xlaa led mee. ");
INSERT INTO zpi_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Orguin wnileedx men ne medid orke guin re Jesus: “Le xpee de che wyaken.” Lex wlaleedx men Jesus yra xfamilyendxee men. ");
INSERT INTO zpi_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Laa neree wrup gyelmilaguer ne wlaa Jesus chene wruu Ne lo lyu ne la Judea ne wdxiin Ne lo lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Zhich guin wak xelni men-Israel Jerusalén, lex wa Jesus lni guin. ");
INSERT INTO zpi_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nga guex ledne ka yaglaa ne la xyaglaa Mëkzhiil zob te tank, Betesda la we diz-hebreo; gaay kordor rapo. ");
INSERT INTO zpi_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ndal mén ne rzhuun ndxin nga, menngwlëë, mennguzh, no le mén ne noze waknet led, kambë́z men ne yni lo nis ne nuu lentank guin. ");
INSERT INTO zpi_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Porke nakse nakse chene ryët te xangel Dëdyuzh rneni ne nis guin, mén ne kwlodee rdee lentank guin or ne rni nis guin, ryaken men kwaskyertee gyelgyiz ne rzak men. ");
INSERT INTO zpi_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Lad yra mén guin nuu te mgyeey ne che wzaa galebchibxun iz rzhuun. ");
INSERT INTO zpi_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Chene wii Jesus nex men nga no ne wyenen Ne ne che wakxcheroo rzhuun men, wnabdiiz Ne lo men, re Ne: ―¿Pe rlaan de gakngyëël de? ");
INSERT INTO zpi_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wke mengyiz guin, re men: ―Dechey, yëten noo txu ysee noo lo nis or ne rni we. Te te chene rlaan noo tee noo, kwlodee ste mén rdee. ");
INSERT INTO zpi_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Lex re Jesus lo men: ―Gutsaxee gulis xloon de, gugya. ");
INSERT INTO zpi_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Orgueguin wyaken mén guin, wlis men xloon men, wzelo men rzaa men. Kom dxe ne rne men-Israel nak dxe guin, ");
INSERT INTO zpi_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","neguin re men-Israel lo mén guin ne wakngyëël: ―Dxe ne rne be nak nedxeree; ndux gweey de xloon de. ");
INSERT INTO zpi_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wke mén guin, re men: ―Laa men ne wneseyaken noo na lo noo: “Gulis xloon de, gugya.” ");
INSERT INTO zpi_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Lex wnabdiiz men lo mén guin, re men: ―¿Txuzh na lo de: “Gulis xloon de, gugya”? ");
INSERT INTO zpi_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per nandet mén guin gan txuzh wneseyaken men, porke le Jesus che woots lad yra menroo menduxtee ne ndxin nga. ");
INSERT INTO zpi_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Zhich guin wtsëlo Jesus mén guin lenxeydoo Dëdyuzh, lex re Ne lo men: ―Gukwii gante, orree ne che wyaken de, ybereedetre de ye de dol ste, tegue sak de ne mazre ntozdee ke ne wzak de. ");
INSERT INTO zpi_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lex sya mén guin, wuu men diiz lo men-Israel ne Jesus nga nak ne wneseyaken men. ");
INSERT INTO zpi_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Por neguin wkanal men-Israel Jesus chen yket men Ne, por ne rlaa Ne gyelmilaguer dxe ne rne men-Israel. ");
INSERT INTO zpi_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Lex wke Ne re Ne lo men: ―Yzaandxee dxe rlaa Dëdyuzh Xuz noo dxiin, no zenga ke rlaa noo we. ");
INSERT INTO zpi_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Por neguin mazre rlaan men-Israel yket men Ne, let nozdet por gyelmilaguer ne rlaa Ne dxe ne rne men-Israel, sinke no por ne rnegalal Ne Ne Dëdyuzh ne rzëët Ne ne Dëdyuzh nak Xuzpee Ne. ");
INSERT INTO zpi_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Orguin re Jesus lo men: ―Nligue yna noo lo de ne bet gakdet ylaa XPee Dëdyuzh noze xkwent mee, sinke le me rlaa ne rwii me rlaa Xuz mee. Porke yrandxee ne rlaa Dëdyuzh, yrandxego rlaa XPee Ne. ");
INSERT INTO zpi_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Porke ryaan Dëdyuzh XPee Ne, por neguin rluu Ne yrandxee ne rlaa Ne lo XPee Ne, no sluu Ne ne mazre nzoondee ne yzee sak de yra de. ");
INSERT INTO zpi_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Porke zegne rdee Dëdyuzh gyelembán lo mengut, zenga ke XPee Ne, rdee me gyelembán lo mén ne rlaan me ne ydee me we. ");
INSERT INTO zpi_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dëdyuzh rut lo rlaadet Ne gyelextis, sinke lo XPee Ne wdee Ne poder ne laa XPee Ne ylaa we, ");
INSERT INTO zpi_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","chen yrandxee mén saknon XPee Ne zegne rzaknon ke men Ne. Mén ne rzaknondet XPee Ne, rzaknondet ke men Ne porke laa Ne wxaal XPee Ne. ");
INSERT INTO zpi_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Nligue yna noo lo de: Men ne rkagyedyag xdiiz noo, lex rlaleedx men Dëdyuzh, che rap men gyelembán ne nunk luzhdet no sakzidetre men. Porke che nakdetre men zegnak mengut, sinke che rap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nligue yna noo lo de ne sdxiin or no laa orguin nee ne gon mén ne nak zegnak mengut xrëz XPee Dëdyuzh; log men ne ykagyedyag xdiiz mee, zap men gyelembán. ");
INSERT INTO zpi_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Porke zegne rap Dëdyuzh poder ne rseleedx Ne gyelembán, zenga ke wdee Ne poder lo XPee Ne ne yseleedx XPee Ne gyelembán, ");
INSERT INTO zpi_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","no wdee ke Ne poder lo XPee Ne ne ylaa XPee Ne gyelextis porke laa XPee Ne nak Men ne wdxiid wak Mén. ");
INSERT INTO zpi_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yzeedet sak de por neree ne rzëët noo porke sdxiin dxe ne gon yrandxee mengut xrëz XPee Dëdyuzh ");
INSERT INTO zpi_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","no sruu men lenxbaa men. Yra mén ne wlaa ne wen, yban men chen gap men gyelembán ne nunk luzhdet; per le yra mén ne wlaa ne mal, yban men chen sakzi men. ");
INSERT INTO zpi_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Noo bet gakdet ylaa noo noze xkwent noo, sinke zegne rkyeen Xuz noo noo, zenga rlaa noo gyelextis no xnëz rlaa noo we, porke rlaadet noo zegne rlaan noo, sinke le noo rlaa zegne rlaan Xuz noo ne wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Belne nonchee noo rzëët xkwent noo, nondet ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Per nuu ste men ne rzëët xkwent noo, no che nan noo ne yra diiz ne rzëët men por noo, nli we. ");
INSERT INTO zpi_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Laa de yra de wxaal mén ne wa wnabdiiz lo Xwa, no yra ne wzëët Xwa nli we. ");
INSERT INTO zpi_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Noo rkyiinden noo ne yzëët mén xkwent noo, per rzëët noo neree lo de chen yláá de lo dol. ");
INSERT INTO zpi_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Xwa wak zegnak te bnii ne wzenii lo mén, no txup tsonegue gbiz wzhiilen de bnii guin yra de. ");
INSERT INTO zpi_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yra ne rlaa noo, laa we rbonyoo ne nondee we ke lo ne wzëët Xwa. Porke ne na Dëdyuzh Xuz noo ne ylaa noo, laa we nak ne kalaa noo no laa we nak ne rbonyoo ne nli Dëdyuzh Xuz noo wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","No ke Dëdyuzh Xuz noo ne wxaal noo zëëd noo wzëët xkwent noo. Nunk gardet gon de xrëz me, ni gardet kwii de me, ");
INSERT INTO zpi_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ni nuudet xdiiz me lextoo de, porke rlaleedxdet de men ne wxaal me. ");
INSERT INTO zpi_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Laa de yra de kesentyent rap de kwent ne rool de lo xgyiich Dëdyuzh, porke nan de ne por laa we gap de gyelembán ne nunk luzhdet, no lo ko nak ne rakzëët xkwent noo. ");
INSERT INTO zpi_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Per rlaandet de ylaleedx de noo chen gap de gyelembán guin. ");
INSERT INTO zpi_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Noo ryedet noo ne ylep mén xeblaan noo. ");
INSERT INTO zpi_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Per nanwen noo gan pezee nak de yra de no nan noo ne ryaandet de Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Laa Xuz noo wxaal noo zëëd noo, per rukasdet de noo, per belne chiid ste mén noze xkwent men, mén guin si zukasgue de men. ");
INSERT INTO zpi_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Pezee ylaleedx de noo, si rtseleedx de ne rlep xkompanyer de xeblaan de, per ryedet de ne laa Dëdyuzh ne tendxee ylep xeblaan de yra de? ");
INSERT INTO zpi_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ylebleedxdet de ne noo gue lo Dëdyuzh yra ne rlaa de, sinke men ne gue we nak Moises, ne rkalo ke de yra de. ");
INSERT INTO zpi_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Porke belne rlaleedx de ne wzëët Moises, slaleedx ke de noo, porke laa Moises wkaa xkwent noo. ");
INSERT INTO zpi_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Per belne rlaleedxdet de ne wkaa Moises, ¿pezee ylaleedx de ne rzëët noo? ");
INSERT INTO zpi_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Zhich guin wa Jesus stebkoo nis-Galilea ledne la ke nis-Tiberias. ");
INSERT INTO zpi_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ndalyaa ndalduxtee mén wa wanal Ne, porke wii men yra gyelmilaguer ne rlaa Ne ne rneseyaken Ne mén ne rzhuun. ");
INSERT INTO zpi_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Lex wyeep Ne te txu gyeey wzob Ne yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Laatee cheguin zëdyob pask lni ne rlaa men-Israel. ");
INSERT INTO zpi_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chene wlis lo Ne, wii Ne ndalyaa ndalduxtee mén za lo Ne, lex re Ne lo Blib: ―¿Pazhleg yka be ne gu yra ménree? ");
INSERT INTO zpi_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Per noze ne re Ne zenga chen gan pe gue Blib, porke che nan Ne gan pe ylaa Ne. ");
INSERT INTO zpi_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Wke Blib, re Blib: ―Per ni lal ne run te mos gan txupgwyuu gbiz gaglodet por ne yka be gyëtxtil chen yganen men mase teblago teblago te te men. ");
INSERT INTO zpi_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lex wke ste xpén Jesus, men ne la Ndrizh bech Simon-Bëd, re men: ");
INSERT INTO zpi_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nee zu te mee ne neey gaay gyëtxtil cebada no le txup mël, per ¿pe ylaandxee neree lo lal ne mén? ");
INSERT INTO zpi_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Lex re Jesus: ―Gugue lo yra mén sob men. Kom kesentyent ndxiib gyizh lugar guin, lex wzob men. Zeg gaaymil nak nonchee mgyeey. ");
INSERT INTO zpi_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Orguin wgoob Jesus gyëtxtil guin, wdee Ne dexkyizhtee lo Dëdyuzh. Wluzh nga wdee No lo yra xpén Ne, lex laa men wgyiizo lo yra mén ne zob nga; zenga ke wlaa Ne mël, wu men laltee ne wlaan men yrandxee men. ");
INSERT INTO zpi_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Chene che wyezaa men, re Ne lo yra xpén Ne: ―Gutop yra ne wrukaa chen xiindeto. ");
INSERT INTO zpi_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Lex wtop men yra gyëtxtilbla ne wrukaa, wsezaa men chibtxup tsegwed delo gaay gyëtxtil guin. ");
INSERT INTO zpi_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ne wii yra mén guin gyelmilaguer ne wlaa Jesus, re men: ―Nli ne laa profet ne rap degne chiid gyëzlyu nee. ");
INSERT INTO zpi_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Per kom wdee Ne kwent ne rlaan yra mén guin sano men Ne lafwers chen ylaa men Ne rrey, lex wyeep Ne mazre gyadee xtoo gyeey guin chen su Ne tete Ne. ");
INSERT INTO zpi_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Chene che zëdnit lyu, wzeeb yra xpén Jesus den wdxiin men runis, ");
INSERT INTO zpi_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","wdee men lenbark wdekaa men stebkoo nis chen ydxiin men Capernaum. Che waknkeb no gardet yberee Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Orguin wzelo noze ndxeeb rak mël lo nis, tant zu mee. ");
INSERT INTO zpi_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Chene che za bark zeg gaay o xuup kilometro, wii men le Jesus za, rzaa Jesus lo nis, zabig Ne lo bark; orguin kesentyent wdxe men. ");
INSERT INTO zpi_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Per re Ne lo men: ―Noo nee, ydxedet de. ");
INSERT INTO zpi_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Axtegue rzhiilen men yra men ne le Jesus wdee lenbark, no orke guin wdxiin men ledne za men. ");
INSERT INTO zpi_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nan yra mén ne wyan stebkoo nis ne tendxee bark zu nga. Chene wra gyëël, wyenen men ne lenbark guin za yra xpén Jesus no wyenen men ne zadet Ne yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Orguin wdxiin txup tson xbark men-Tiberias guex ledne wu men gyëtxtil chene wluzh wdee Jesus dexkyizhtee lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ne wii yra mén guin ne yëtet Jesus nga ni xpén Ne, wdee men lenbark guin za men Capernaum zaye men Ne. ");
INSERT INTO zpi_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chene wdxiin men Capernaum, wzël Jesus lo men, lex re men lo Ne: ―Maxter, ¿pa or wlenza de nee? ");
INSERT INTO zpi_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Wke Ne re Ne: ―Nanwen noo ne ryedet de noo por gyelmilaguer ne wii de wlaa noo, sinke noze por ne wu de axtegue wyezaa de. ");
INSERT INTO zpi_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ylaadet de dxiin noze por gyelwu ne rluzh, sinke gulaa dxiin por gyelwu ne rluzhdet ne rguu gyelembán ne nunk luzhdet, laa gyelwuree nak ne yseleedx Men ne wdxiid wak Mén, porke laa Dëdyuzh nak ne wzu men ne yseleedx meno. ");
INSERT INTO zpi_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Lex wnabdiiz men, re men: ―¿Pagox rap noo degne ylaa noo chen ylaa noo ne rlaan Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Wke Jesus, re Ne: ―Logne rlaan Dëdyuzh ne ylaa de nak ne ylaleedx de men ne wxaal Dëdyuzh ne zëëd men. ");
INSERT INTO zpi_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Lex re men: ―¿Pe gyelmilaguerzhe ylaa de ne kwii noo chen ylaleedx noo de? ¿Pagox run de gan rlaa de? ");
INSERT INTO zpi_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Xpenkwlal be, maná wu men chene wkaa men denbidx zegne zëëd lo xgyiich Dëdyuzh ledne re: “Wdee men gyëtxtil-gyeybaa wu men yra men.” ");
INSERT INTO zpi_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Orguin re Jesus: ―Nligue yna noo lo de ne let Moisesdet wdee gyëtxtil-gyeybaa wu men, sinke laa Xuz noo nak ne rdee merpee gyëtxtil-gyeybaa ru mén. ");
INSERT INTO zpi_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porke gyëtxtil ne rdee Dëdyuzh, laa we nga nak ne wruu gyeybaa, rguu we gyelembán lextoo mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Lex re men lo Ne: ―Dechey, guniiz gyëtxtil guin lo noo yzaandxee dxe. ");
INSERT INTO zpi_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Wke Jesus, re Ne: ―Noo nak gyëtxtil ne rguu gyelembán; mén ne chiid lo noo, ydxiindetre dxe ne ylaanen men; men ne ylaleedx noo, ydxiindetre dxe ne ylaan men nis. ");
INSERT INTO zpi_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Per zegne che na noo lo de, mase che wii de noo, per rlaleedxdet de noo. ");
INSERT INTO zpi_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yrandxee mén ne rniiz Xuz noo lo noo, schiid men lo noo; no yrandxee mén ne chiid lo noo, ychereedet noo men. ");
INSERT INTO zpi_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Porke wruudet noo gyeybaa por ne ylaa noo ne rlaan noo, sinke le noo zëëd por ne ylaa noo ne rlaan Xuz noo ne wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Logne rlaan Xuz noo ne wxaal noo zëëd noo nak ne ni te mén ne wniiz me lo noo ylaadet noo men perdid, sinke yneban noo men chene che lultim dxe. ");
INSERT INTO zpi_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ne rlaan Xuz noo nak ne yrandxee mén ne ykalo XPee me no ne ylaleedx XPee me, gap gyelembán ne nunk luzhdet; noo yneban men chene che lultim dxe. ");
INSERT INTO zpi_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Orguin wzelo yra men-Israel rnii men por Jesus por ne re Ne ne laa Ne nak gyëtxtil ne wruu gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Re men: ―¿Pe let laadet Jesus xpee Xeb nee? Rnebeey be xuz men no rnebeey be xnaa men. ¿Pezee ne yna men ne gyeybaa wruu men? ");
INSERT INTO zpi_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Lex re Jesus lo men: ―Gusaan ne rnii de por noo. ");
INSERT INTO zpi_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Laa Xuz noo wxaal noo zëëd noo. Rut gakdet ylenza lo noo belne yxaaldet Xuz noo men; noo yneban men chene che lultim dxe. ");
INSERT INTO zpi_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lo liber ne wkaa profet re: “Dëdyuzh yneluu yrandxee mén.” Por neguin yrandxee mén ne rkagyedyag xdiiz Dëdyuzh no ne rseed ne rneluu Dëdyuzh, lo noo ylenza men. ");
INSERT INTO zpi_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Nakdeto ne nuu mén che wii Dëdyuzh, sinke nonchee men ne wruu lo Dëdyuzh, laa men guin nak ne che wii Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nligue yna noo lo de, mén ne rlaleedx noo che rap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Noo nak gyëtxtil ne rguu gyelembán. ");
INSERT INTO zpi_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Xpenkwlal de, mase wu men maná denbidx, per wet ke men. ");
INSERT INTO zpi_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Per le gyëtxtil ne rzëët noo lo de gyeybaa wruu we; mén ne gu we, zap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Noo nak gyëtxtilmbán ne wruu gyeybaa; men ne gu gyëtxtilree, zap men gyelembán ne nunk luzhdet. Gyëtxtil ne rdee noo ledpee noo nako; ydee noo we chen gap mengyëzlyu gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Orguin wzelo men-Israel rulsaa men diiz, re men: ―¿Pezee gak yniiz ménree led men gu be? ");
INSERT INTO zpi_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Wke Jesus, re Ne: ―Nligue yna noo lo de, belne gudet de led Men ne wdxiid wak Mén no belne goodet de xren men, gapdet de gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Per le men ne gu led noo no ne goo xren noo, zap men gyelembán ne nunk luzhdet; noo yneban men chene che lultim dxe. ");
INSERT INTO zpi_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porke led noo nak merpee gyelwu, no xren noo nak merpee ne roo mén. ");
INSERT INTO zpi_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Men ne gu led noo no ne goo xren noo, men guin syemper zu kon noo, noo syemper zu kon laa men. ");
INSERT INTO zpi_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Laa Xuz noo wxaal noo, mbán me, no zegne mbán noo por laa me, zenga ke men ne gu led noo, por noo gap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Noo gyëtxtil ne wruu gyeybaa rzëët noo; gyëtxtilree nakdeto zegnak maná ne wu xpenkwlal de, porke mase wu meno, per wet ke men; per le men ne gu gyëtxtilree ne rzëët noo, zap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yra neree wneluu Jesus mén lenydo-Capernaum. ");
INSERT INTO zpi_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chene wluzh won yra xpén Jesus neree, ndalyaa men re: ―Axtegue ne gakdetlel rnii men; ¿txu ykagyedyag ne rnii men? ");
INSERT INTO zpi_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Wdee Jesus kwent ne re men zenga, lex re Ne lo men: ―¿Pe rzaknyaan de neree ne na noo lo de? ");
INSERT INTO zpi_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Pagoxleg tsuu lextoo de belne kwii de gyeep Men ne wdxiid wak Mén ledne wuu men chekwlo? ");
INSERT INTO zpi_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Laa Espíritu Sant rseleedx gyelembán lo mén; belne yëtet Espíritu Sant, bat ykyiindet noze mén. Yra diiz ne wzëët noo lo de yra de, espíritu nako no le gyelembán. ");
INSERT INTO zpi_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per nuu de gardet ylaleedx noo. Re Jesus zenga porke axtegue chekwlo che nan Ne gan txuzh rlaleedxdet Ne no gan txuzh ydekwent Ne. ");
INSERT INTO zpi_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","No re Ne lo men: ―Por neguin na noo lo de ne rut gakdet ylenza lo noo belne yxaaldet Xuz noo men. ");
INSERT INTO zpi_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwlote nga ndalyaa men ne che nak xpén Jesus wsalzaan men Ne, wanaldetre men Ne. ");
INSERT INTO zpi_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Lex wnabdiiz Ne lo yra chibtxup xpén Ne, re Ne: ―¿Pe no de rlaan gya? ");
INSERT INTO zpi_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Wke Simon-Bëd, re Simon-Bëd: ―Dechey, ¿txu lo nak ne tsa noo? Si nonchee xdiiz de nak ne rseleedx gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","No che rlaleedx noo de yra noo no nan noo ne laa de nak Crist XPee Dëdyuzhmbán. ");
INSERT INTO zpi_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Wke Jesus, re Ne: ―Mase noo wye de yra de chibtxup de, per te de nak Bzelo. ");
INSERT INTO zpi_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Xkwent Judas xpee Simon Iscariote rzëët Ne ne re Ne zenga. Porke laa Judas nak men ne wdekwent Ne, mase te ke men ne nak xpén Ne chibtxup nak Judas. ");
INSERT INTO zpi_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wluzh wak yra neguin, wa Jesus wkaa Ne lo lyu ne la Galilea; wlaandet Ne nya Ne nkaa Ne lo lyu ne la Judea porke kaye men-Judea gan pezee yket men Ne. ");
INSERT INTO zpi_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Per kom che wyob lni ne rlaa men-Israel ne ruu men lenguezh, ");
INSERT INTO zpi_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","lex re yra bech Ne lo Ne: ―Guruu nee, gutsa Judea chen no ke yra xpén de ne nuu Judea kwii yra gyelmilaguer ne rlaa de. ");
INSERT INTO zpi_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Porke belne rlaan me ne gaknan mén ne rlaa me, ylaadet mo ngueedx. Laague ne rlaa de gyelmilaguer, gulaa we nes lo yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Re yra bech Jesus zenga, porke ni laa men rlaleedxdet men Ne. ");
INSERT INTO zpi_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Orguin re Ne lo men: ―Gardet ydxiin xor noo, per por laa de yra de kwaskyertee or wen rzak de. ");
INSERT INTO zpi_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Laa de yra de yët gan pe kwentzhe kwinyaan mengyëzlyu de, per noo por ne rzëët noo lo men ne ngyidet ne rlaa men, por neguin rwinyaan men noo. ");
INSERT INTO zpi_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gutsa lni yra de; noo tsadetgue noo, porke gardet ydxiin xor noo. ");
INSERT INTO zpi_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Wluzh re Jesus zenga, wyan ke Ne lo lyu ne la Galilea. ");
INSERT INTO zpi_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Per chene che zase yra bech Jesus, no ke Ne za lni guin, mase rut waknandeto, sinke legue ngueedx za Ne. ");
INSERT INTO zpi_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Zad wkaye yra men-Israel Ne lo lni guin, re men: ―¿Gozh mén guin, bes? ");
INSERT INTO zpi_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ndal mén ne wa lni guin noze wren wren ne rnii men por laa Ne. Gwrol men re: “Menwen men.” Gwrol zeg men re: “Nakdet men menwen, noze rkade men mén.” ");
INSERT INTO zpi_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Per ngueedxendxee ruu men xdiiz Ne por ne rdxe men men ne rnebééy lo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Che wrool ne kayak lni, wdee Ne lenxeydoo Dëdyuzh, wzelo Ne wneluu Ne men-Israel. ");
INSERT INTO zpi_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ne won men yra ne kaneluu Ne men, kesentyent wzee wzak men, re men: ―¿Pezee wlaaleg ménree ne kesentyent ndal ne nan men, no ni wseedet men? ");
INSERT INTO zpi_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Wke Ne re Ne: ―Ne kaneluu noo nakdeto xdiiz noo, sinke le we nak xdiiz Dëdyuzh, laa Ne wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mén ne rlaan ylaa ne rlaan Dëdyuzh, zaknan men belne xdiiz Dëdyuzh rneluu noo o noze xkwent noo rlaa noo we. ");
INSERT INTO zpi_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mén ne rnii noze xkwent men, rlaa meno chen saknon mén men; per le men ne rye gan pezee saknon mén Dëdyuzh ne wxaal men zëëd men, men guin rnii teblose diznli, nunk rkadedet men. ");
INSERT INTO zpi_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Pe let wniizdet Moises ley lo de, no ni te de rlaadet zegne zëëd lo we? ¿Pezee ne rlaan de yket de noo? ");
INSERT INTO zpi_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wke yra mén, re men: ―Menzab nuu lextoo de. ¿Txuzh rlaan yket de? ");
INSERT INTO zpi_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Lex wke Jesus, re Ne: ―Por te gyelmilaguer ne wlaa noo rzee rzak de yra de. ");
INSERT INTO zpi_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Per le laa de mase dxe ne rne be, rguu de mëdbee beey zegne wkyeen Moises (mase let Moisesdet wneselo we, sinke che axtegue xpenkwlal be rlaa we). ");
INSERT INTO zpi_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Belne por ne gun de kumplir ne zëëd lo ley ne wdee Dëdyuzh lo Moises nak ne rguu de mëdbee beey mase dxe ne rne be, orrenaa bes, ¿penak rlaa de lo noo ne wneseyaken noo te mén dxe ne rne be? ");
INSERT INTO zpi_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yleedxdet de mén noze zegne rnaa men, sinke primer gugaknanwen gan pezee nak men. ");
INSERT INTO zpi_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Lex wzelo tebëd men-Jerusalén rnabdizlsaa men, re men: ―¿Pe let laadet ménree nga kaye mén chen yket mén men? ");
INSERT INTO zpi_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","No le men zu nee rnii men nes lo yra mén, no ni te mén bet redet lo men. ¿Peguin che wlaleedx xtis ne laa ménree nak Crist? ");
INSERT INTO zpi_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Per laa be nanwen be gan txu ménzhe nak ménree. Per le chene chiid Crist, rut gaknandet gan txu ménzhe gak Ne. ");
INSERT INTO zpi_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Por neguin or ne kaneluu Jesus lenxeydoo Dëdyuzh, ndípse re Ne: ―¡Re de ne rnebeey de noo no nan de gan txu ménzhe nak noo! Per noo zëëdet noo noze xkwent zhal noo, sinke laa Dëdyuzh ne axtegue rkadedet wxaal noo zëëd noo, no rnebeeydet de Ne. ");
INSERT INTO zpi_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Noo rnebeey noo Ne, porke lo Ne wruu noo no laa Ne wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Orguin wlaan men nnëëz men Jesus chen nzano men Ne, per ni te mén wbigdet nnëëz Ne porke gardet ydxiin xor Ne ne yzuun Ne. ");
INSERT INTO zpi_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Per ndal mén ne ndxin nga wlaleedx Ne, lex re men lo men ne wlaleedxdet Ne: ―¿Pe nuu lextoo de ne chene chiid Crist, ndaldee gyelmilaguer ylaa Ne ke ne rlaa ménree? ");
INSERT INTO zpi_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ne won yra men ne nak farisew ne re yra mén guin zenga, lex waken men yra men fxuz ne rnebééy lo yra fxuz wxaal men men ne rapkwent xeydoo Dëdyuzh chen ynëëz men Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Orguin re Jesus: ―Xchedetre ykaa noo lad de yra de, che wyob ke yberee noo lo Dëdyuzh ne wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Skaye de noo, per tsëldet noo lo de, porke gakdet tsa de ledne gya noo. ");
INSERT INTO zpi_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Lex wzelo yra men-Israel rnabdizlsaa men, re men: ―¿Pazh gya ménree ne gundet be gan tsël men lo be? ¿Peguin sya men lo yra men-Israel ne nunrëëts lad yra mén ne nakdet men-Israel chen yneluu men mén ne nakdet men-Israel? ");
INSERT INTO zpi_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Pagox rna neree ne na men: “Skaye de noo, per tsëldet noo lo de, porke gakdet tsa de ledne gya noo”? ");
INSERT INTO zpi_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ne lultim dxe lni nak dxe ne mazre nondee. Dxe guin wzuli Jesus, ndípse re Ne: ―Belne nuu mén rlaan goo nis, chiid men lo noo, noo ydee nis goo men. ");
INSERT INTO zpi_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Zegne re lo xgyiich Dëdyuzh, lextoo men ne rlaleedx noo ylen nis ne rguu gyelembán. ");
INSERT INTO zpi_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Neree ne re Jesus, rna we ne yra mén ne ylaleedx Ne zaknonen Espíritu Sant men; porke cheguin gardet chiid Espíritu Sant por ne gardet sob Jesus ledne rnebééy Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chene won yra menroo menduxtee guin ne re Jesus zenga, gwrol men re: ―Nli ne profet ne gyed chiid nak ménree. ");
INSERT INTO zpi_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Le stebëd men re: ―Laa Crist nee. Per le stebëd zeg men re: ―¿Pezee gak men Crist si men-Galilea nak men? ");
INSERT INTO zpi_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Pe let redet lo xgyiich Dëdyuzh ne xnëz rrey-David chiid Crist no ne Belén gal Ne, laz ke rrey-David? ");
INSERT INTO zpi_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Por neguin noze wren wren ne wnii mén por Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Gwrol men guin wlaan nsee men Jesus chegyiib, per ni te men wyezhdet nbig nnëëz Ne. ");
INSERT INTO zpi_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chene wberee yra men ne rapkwent xeydoo Dëdyuzh ledne ndxin men ne nak farisew yra men fxuz ne rnebééy lo yra fxuz, re men lo men ne rapkwent ydoo: ―¿Penak zëdnodet de men? ");
INSERT INTO zpi_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wke men re men: ―¡Rutlel gardet gon noo ynii zegne rnii men! ");
INSERT INTO zpi_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Lex re men ne nak farisew: ―¿Pe no de che wgoots men xtoo? ");
INSERT INTO zpi_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Peguin nuu men ne nak xextis be u nuuzeg be ne nak be farisew che wlaleedx men? ");
INSERT INTO zpi_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yra mén ne nandet pezee zëëd lo ley ne wdee Dëdyuzh lo Moises, cheguel sakzi Dëdyuzh men. ");
INSERT INTO zpi_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Lex wke te ke men ne nak farisew ne la Nicodemo ne wa wuu diiz yrup Jesus te gyëël, re men: ");
INSERT INTO zpi_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―¿Pe let zëëdet lo ley ne nuudet yzakzi be te mén belne gardet gon be xdiizpee men por ne gaknan be gan pe wlaa men? ");
INSERT INTO zpi_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wke men re men lo Nicodemo: ―¿Pe no de nak men-Galilea? Guseed lo xgyiich Dëdyuzh wen wenendxee gante chen gaknan de ne ni te profet gardet yruu Galilea. ");
INSERT INTO zpi_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Wluzh nga sya men ruxyuu men te te men. ");
INSERT INTO zpi_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Le Jesus za gyey-Olivos. ");
INSERT INTO zpi_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ne wra gyëël rsil, wa Jesus lenxeydoo Dëdyuzh ste. Ndalyaa mén wdop lo Ne, lex wzob Ne wneluu Ne men. ");
INSERT INTO zpi_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Orguin wdxiin maxter ley yra men men ne nak farisew, wdxinno men te wnaa ne wgano ste mgyeey, wzu men men gwrooltee lad yra men ne ndxin nga, ");
INSERT INTO zpi_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","lex re men lo Ne: ―Maxter, wga wnaaree lo noo or ne kano men ste mgyeey. ");
INSERT INTO zpi_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lo ley ne wdee Dëdyuzh lo Moises zëëd ne kon gye guet wnaa ne nak zeree. Laa de naa, ¿pe yna de? ");
INSERT INTO zpi_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Re men neree lo Ne chen gan pe gue Ne, chen tsël gan pezee ykagyii men Ne. Orguin wzobndeslo Ne wzelo Ne rkaa Ne leter lyu kon xkwen Ne. ");
INSERT INTO zpi_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Per kom rnabdiizre men lo Ne, lex wzobtebli ke Ne re Ne lo men yra men: ―Men ne neeydet ni te dol, men guin primer kyits gye led men. ");
INSERT INTO zpi_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Lex wzobndeslo ke Ne ste kakaa ke Ne leter lyu. ");
INSERT INTO zpi_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ne won yra men guin ne wdxinno wnaa guin ne re Ne zenga, wka men nëz tegue tegue men sya, mengol nak ne primer wzelo wruu axtegue ne wra men sya; wyan Ne noze yrup Ne wnaa guin ne wzu men gwrooltee lad mén. ");
INSERT INTO zpi_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Lex wzobtebli Ne ste. Kom wii Ne ne rutre yët, nonchee wnaa guin zu, re Ne lo men: ―Wnaae, ¿gozh yra mén ne wdxiid wdxidzu de nee? ¿Ni te men wyezhdet nkyits gye led de ye? ");
INSERT INTO zpi_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wke wnaa guin, re men: ―Ni te men Decheye. Lex re Ne lo men: ―Ni noo bet ylaadet noo de. Orrenaa gugya, yedetre de dol. ");
INSERT INTO zpi_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Lex wnii Jesus lo yra mén ste, re Ne: ―Noo nak bnii por mengyëzlyu; men ne chidnal noo, saadet men lo nkeb, sinke lo bnii ne rguu gyelembán saa men. ");
INSERT INTO zpi_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lex re men ne nak farisew lo Ne: ―Laake de rzëët xkwent de; nlidet negwa ne rzëët de. ");
INSERT INTO zpi_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Wke Ne re Ne: ―Ne rzëët noo nli we, nyaalzhe noo ke rzëët xkwent noo. Porke nan noo gan pazh wruu noo no nan noo gan pazh tsa noo; per le laa de yra de nandet de gan pazh wruu noo, ni nandet de gan pazh tsa noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Laa de yra de rlaa de gyelextis noze zegne nak de ne nak de noze mengyëzlyu, per le noo rut lo rlaadet noo gyelextis. ");
INSERT INTO zpi_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Per belne ylaa noo gyelextis, xnëz ylaa noo we, porke let tesdet noo ylaa we, sinke yrup noo Dëdyuzh Xuz noo ne wxaal noo zëëd noo ylaa we. ");
INSERT INTO zpi_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo xley de yra de zëëd ne chene nuu txup testig ne tese rnii, nli ne rnii men. ");
INSERT INTO zpi_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Noo ke nak te men ne rzëët xkwent noo, le ste men nak Xuz noo ne wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lex re men: ―¿Gozh xuz de naa? Wke Jesus, re Ne: ―Laa de yra de rnebeeydet de noo, ni rnebeeydet de Xuz noo; belne nako ne rnebeey de noo, rnebeey ke de Xuz noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yra diizree re Jesus lo mén or ne kaneluu Ne men lenxeydoo Dëdyuzh nes ledne zu yra ne rguu mén goon. Per rut wbigdet nnëëz Ne, porke gardet ydxiin xor Ne ne yzuun Ne. ");
INSERT INTO zpi_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Wberee Jesus re Ne ste: ―Noo sya noo, skaye de noo yra de, per zetno de xdol de, no gakdet tsa de ledne gya noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Orguin re men-Israel: ―¿Peguin sket men men laake men, por neguin na men ne gakdet tsa be ledne gya men? ");
INSERT INTO zpi_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Lex re Ne lo men: ―Laa de yra de mengyëzlyuree nak de, per le noo mengyeybaa nak noo; laa de mengyëzlyu nak de, per le noo nakdet noo mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Por neguin na noo lo de: “Zetno de xdol de.” Porke belne rlaleedxdet de ne noo nak men ne nak noo, zetno de xdol de. ");
INSERT INTO zpi_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Lex wnabdiiz men lo Ne, re men: ―¿Txu nak de, bes? Wke Ne re Ne: ―Che na noo we lo de axtegue chekwlo. ");
INSERT INTO zpi_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ndalre ne rap noo ne yna noo lo de chen yzëët noo yra ne rlaa de, per noo nonchee ne ron noo rnii Xuz noo ne wxaal noo, neguin nak ne rzëët noo lo mengyëzlyu porke Xuz noo ne wxaal noo nli rnii me. ");
INSERT INTO zpi_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per wdeedet men kwent ne Dëdyuzh nga wzëët Jesus ne re Jesus zenga. ");
INSERT INTO zpi_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Por neguin re Ne: ―Chene che wlaa de Men ne wdxiid wak Mén zegne rlaantee de, cheguin gaknan de ne noo nak men ne nak noo no ne bet rlaadet noo noze xkwent noo, sinke le noo rzëët nonchee ne wneluu Xuz noo lo noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Porke Xuz noo ne wxaal noo zëëd noo nak ne raknonen noo; rboleedxdet me noo porke syemper rlaa noo ne rtseleedx me. ");
INSERT INTO zpi_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ne re Jesus zenga, ndalyaa mén wlaleedx Ne. ");
INSERT INTO zpi_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Lex re Jesus lo men-Israel ne che wlaleedx Ne: ―Belne ysalzaandet de xdiiz noo ne rzëët noo lo de, merpee xpén noo gak de, ");
INSERT INTO zpi_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","no zaknan de gonezhe nak ne nli no por ne nli guin nak ne yláá de. ");
INSERT INTO zpi_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wke men re men: ―Noo yra noo xnëz Abraham zëëd noo, rut lo nakdet noo mén ne che wdoo. ¿Penak na de ne yláá noo? ");
INSERT INTO zpi_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Lex re Ne lo men: ―Nligue yna noo lo de, ne yrandxee mén ne rlaa dol che wdoo men lo dol. ");
INSERT INTO zpi_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Te mén ne che wdoo ngabdet men lad zhiin familye ne wka men, per le zhiin familye guin lo familye guin ngab ne. ");
INSERT INTO zpi_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Por neguin belne rselaa XPee Dëdyuzh de, laa de gak men ne nlipee wláá. ");
INSERT INTO zpi_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Che nan noo ne xnëz Abraham zëëd de yra de, per rlaan de yket de noo, porke rlaleedxdet de ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Noo ne wneluu Xuz noo lo noo rzëët noo, zenga ke laa de ne rzëët xuz de neguin rlaa de. ");
INSERT INTO zpi_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wke men re men: ―Abraham nak xuz noo. Lex re Jesus lo men: ―Belne nli zhiin Abraham nak de, slaa de ne wlaa Abraham. ");
INSERT INTO zpi_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Per lel rlaan de yket de noo por ne rzëët noo diznli ne wneluu Dëdyuzh lo noo. ¡Nunk wlaadet Abraham zegwa! ");
INSERT INTO zpi_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Per le laa de ne rlaa ke xuz de rlaa de. Lex re men: ―Noo yra noo yëten noo ste xuz noo; tebegue xuz noo rap noo, laa me nga nak Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Lex re Jesus lo men: ―Belne nli Dëdyuzh nak xuz de, syaan de noo, porke lo Dëdyuzh wruu noo ne zëëd noo; zëëdet noo noze xkwent noo, sinke laa Ne wxaal noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Rdeedet de kwent xdiiz noo porke rlaandet de ykagyedyag de ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bzelo nak xuz de, ne rlaan men ylaa de, neguin nak ne rlaan de ylaa de. Desde ne waa gyëzlyu rlaa Bzelo gyii. Axtegue rlaandet men diznli, porke nunk rniidet men diznli. Chene rkade men, rbonyoo men ne nak men; porke men ne rkade nak men no laa men nak xuz gyelerkade. ");
INSERT INTO zpi_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Per le noo kom diznli rnii noo, rlaleedxdet de noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Txu laa de yra de yzëët belne nuu dol wlaa noo? No belne nli rnii noo, ¿penak rlaleedxdet de noo cheguin? ");
INSERT INTO zpi_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mén ne nak xpén Dëdyuzh, rkagyedyag men xdiiz Ne. Per le laa de yra de nakdet de xpén Ne, por neguin rkagyedyagdet de xdiiz Ne. ");
INSERT INTO zpi_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Lex re yra men-Israel lo Jesus: ―Nli ke rnii noo gon ne men-Samaria nak de no ne menzab nuu lextoo de. ");
INSERT INTO zpi_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Wke Ne re Ne: ―Noo ni te menzab yëtet lextoo noo, sinke le noo rzaknon Xuz noo, per le laa de yra de rzaknondet de noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Noo ryedet noo gan pezee saknon mén noo, mase nuu te Men ne rlaan ne saknon mén noo, laa Men nga nak ne rlaa gyelextis. ");
INSERT INTO zpi_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nligue yna noo ne men ne rlaa ne rzëët noo, nunk guetet men. ");
INSERT INTO zpi_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Lex wke men-Israel, re men: ―Orree si che nan noo ne menzab nuu lextoo de. Abraham no le yra profet wet men, le laa de naa, na ne men ne rlaa ne rzëët de, nunk guetet men. ");
INSERT INTO zpi_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Peguin mazre nondee de ke lo Abraham xpenkwlal noo? Si wet men no wet ke yra profet. Le laa de naa, ¿txuzhleg rzaa lextoo de nak de? ");
INSERT INTO zpi_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Wke Jesus, re Ne: ―Belne noo ke rlep xeblaan noo, bet nondet ne rnii noo por noo. Per men ne rlep xeblaan noo nak Xuz noo, ne na ke de yra de ne nak XDëdyuzh de. ");
INSERT INTO zpi_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Per laa de rnebeeydet de me. Noo si rnebeey noo me, no belne yna noo ne rnebeeydet noo me, noze rkade noo zeg rlaa ke de. Per noo nli rnebeey noo me, no rlaa noo ne rzëët me. ");
INSERT INTO zpi_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham xpenkwlal be, kesentyent rzhiilen men ne kwii men dxe ne chiid noo, no chene wii meno, mazre ntozdee wzhiilen men. ");
INSERT INTO zpi_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lex re men-Israel lo Jesus: ―Ni txupchii iz gardet gap de, ¿pezee ne yna de ne wii de Abraham? ");
INSERT INTO zpi_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Wke Jesus, re Ne: ―Nligue yna noo lo de ne axtegue antes ne tsuu Abraham, che nuu noo. ");
INSERT INTO zpi_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Orguin wgoob men gye ngugye men Ne; per wootsgue Ne lad men, lex wdesu Ne noze lad men yra men, wruu Ne lenxeydoo Dëdyuzh sya Ne. ");
INSERT INTO zpi_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ne wdee Jesus te lugar, wii Ne zu te mgyeey ne cheguel ngwlëë axtegue ne wal men. ");
INSERT INTO zpi_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Lex wnabdiiz yra xpén Ne lo Ne, re men: ―Maxter, ¿penak cheguel ngwlëë mén gwa ne wal men? ¿Pe por xdol xegwzan meno u por xdol ke meno? ");
INSERT INTO zpi_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Wke Ne re Ne: ―Let por xdoldet meno, ni let por xdoldet xegwzan meno, sinke le we nak ne por laa men yrunyoo ne rlaa Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Rap noo degne ylaa noo xdxiin Xuz noo ne wxaal noo zëëd noo, naaster ne benak nyenii, porke chene nitse lyu, rutre gakdet ylaa dxiin. ");
INSERT INTO zpi_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Myentras ne benak zu noo gyëzlyuree, noo nak bnii por yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wluzhse re Ne zenga, wxe Ne tebruu zhen lyu, lex kon zhen guin wzhexkwaa Ne bën, wgueeb No bzalo menngwlëë guin. ");
INSERT INTO zpi_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Lex re Ne lo men: ―Gutsa ga lo de rutank ne la Siloé. (Siloé rna Wxaal.) Orguin wa men waa lo men. Chene wberee men, che rak rwii men. ");
INSERT INTO zpi_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Lex re yra mén ne nuu guex ledne nuu men no le yra mén ne nan ne ngwlëë men: ―¿Pe let laadet ménree nga rzob rnab goon lo mén? ");
INSERT INTO zpi_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Gwrol men re: ―Laa men ne. Gwrol zeg men re: ―Let laadet men ne, noze rzaglo men. Per wke mgyeey guin, re men: ―Noo ne. ");
INSERT INTO zpi_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Lex re men lo mgyeey guin: ―¿Pezee wlaa de ne che rak rwii de? ");
INSERT INTO zpi_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wke men re men: ―Laa men ne la Jesus wzhexkwaa bën, wgueeb meno bzalo noo, lex na men lo noo: “Gutsa ga lo de rutank ne la Siloé.” Lex wa noo. Chene wluzh waa noo lo noo, che rak rwii noo. ");
INSERT INTO zpi_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Lex re men lo mgyeey guin: ―¿Gozh men naa? Wke men re men: ―Nandet noo we. ");
INSERT INTO zpi_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Lex wano men mgyeey guin ne wyenii bzalo, lo yra men ne nak farisew. ");
INSERT INTO zpi_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Per kom dxe ne rne men-Israel nak dxe guin ne wzhexkwaa Jesus bën ne wgueeb Ne bzalo mgyeey guin ne wyenii bzalo, ");
INSERT INTO zpi_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","por neguin wnabdiiz men ne nak farisew lo mgyeey guin gan pezee wyenii bzalo men. Wke men re men: ―Laa Jesus wgueeb bën bzalo noo; lex waa noo lo noo ne le we wyenii. ");
INSERT INTO zpi_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Orguin re gwrol men ne nak farisew: ―Mén ne wlaa negwa nakdet men xpén Dëdyuzh, porke rzaknondet men dxe ne rne be. Per le gwrol men re: ―¿Pezee gun te mendol gan ylaa men gyelmilaguer gwa? Noze wren wren rnii men. ");
INSERT INTO zpi_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lex wberee men wnabdiiz men lo mgyeey guin ne wyenii bzalo, re men: ―¿Laa de naa, pe yna de txu nak mén gwa ne wlaa ne wyenii bzalo de? Lex re mgyeey guin: ―Noo yna te profet nak men. ");
INSERT INTO zpi_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Per le yra men-Israel rlaleedxdet men ne ngwlëë mgyeey guin chekwlo no ne le men che rak rwii; lex wbëz men xegwzan mgyeey guin, ");
INSERT INTO zpi_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","wnabdiiz men lo men, re men: ―¿Pe laa xpee de wa ne cheguel ngwlëë axtegue chene wal? Orrenaa, ¿pezee wlaa me ne che rak rwii mee? ");
INSERT INTO zpi_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wke xegwzan mgyeey guin, re men: ―Noo nan noo ne xpee noo ne no ne cheguel ngwlëë me axtegue chene wal mee; ");
INSERT INTO zpi_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","per nandet noo pezee wlaa me ne che rak rwii mee, ni nandet noo txu wlaa ne wyenii bzalo mee. Lo me gunabdiiz, che mengol mee; laa me yna gan pezee wyenii bzalo mee. ");
INSERT INTO zpi_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Re xegwzan mgyeey guin zenga por ne rdxe men men-Israel, porke che tese wak men-Israel ne kwaskyertee mén ne gue: “Jesus nak Crist”, ydeedetre men si tsa mén guin lenydoo. ");
INSERT INTO zpi_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Por neguin re xegwzan mgyeey guin: “Lo me gunabdiiz, che mengol mee.” ");
INSERT INTO zpi_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Lex wbëz men-Israel mgyeey guin ste, re men lo men: ―Gugon Dëdyuzh, belne nli rnii de, porke noo yra noo nanwen noo ne mendol nak mén gwa. ");
INSERT INTO zpi_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wke mgyeey guin, re men: ―Noo nandet noo belne mendol nak men o nakdet zeg men mendol. Nonchee ne nan noo ne ngwlëë noo chekwlo no ne che rwii noo naaree. ");
INSERT INTO zpi_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Lex wnabdiiz men lo mgyeey guin ste, re men: ―¿Kox wlaa men? ¿Pezee wlaa men ne wyenii bzalo de? ");
INSERT INTO zpi_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wke mgyeey guin, re men: ―Che na noo we lo de yra de, per rlaleedxdet de noo. ¿Penak rlaan de gon do ste? ¿Pe no de rlaan gak xpén men? ");
INSERT INTO zpi_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Lex wninyaan men lo mgyeey guin, re men: ―Laa de xpén men nak de, per le noo yra noo xpén Moises nak noo. ");
INSERT INTO zpi_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","No nan noo ne Dëdyuzh wnii lo Moises. Per le mén gwa, ni nandet noo gan pa wzaa men. ");
INSERT INTO zpi_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Orguin wke mgyeey guin, re men: ―Te gyelgwzee nak negwa ne nandet de gan pa wzaa men, no laa men wlaa ne wyenii bzalo noo. ");
INSERT INTO zpi_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nanwen be ne rkagyedyagdet Dëdyuzh xdiiz mendol, sinke le Ne rkagyedyag nonchee xdiiz mén ne ron xdiiz Ne no ne rlaa ne rlaan Ne. ");
INSERT INTO zpi_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nunk gardet gyen xdiiz te mén ne ylaa ne gyenii bzalo te mén ne cheguel ngwlëë axtegue chene wal. ");
INSERT INTO zpi_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Belne let Dëdyuzhdet wxaal men, bet nyundet men gan nlaa men. ");
INSERT INTO zpi_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Lex re men lo mgyeey guin: ―Laa de axtegue ne wal de, kesentyent neey de dol; ¿pezee ne yneluu de noo? Orguin wboo men mgyeey guin lenydoo. ");
INSERT INTO zpi_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Waknan Jesus ne wboo men mgyeey guin lenydoo, lex chene wzëël Ne men, re Ne lo men: ―¿Pe rlaleedx de XPee Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Lex re mgyeey guin lo Ne: ―Dechey, guzëët gan txuzh ne, chen ylaleedx noo zhaa. ");
INSERT INTO zpi_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Wke Ne re Ne: ―Che wii de zhaa. Laa zhaa nee kayuno de diiz. ");
INSERT INTO zpi_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Orguin wzuzhib mgyeey guin lo Ne, lex re men: ―Rlaleedx noo de, Dechey. ");
INSERT INTO zpi_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Lex re Ne: ―Zëëd noo nee gyëzlyuree chen gak gyelextis, chen gyenii bzalo menngwlëë, le yra men ne rwii gak men zegnak menngwlëë. ");
INSERT INTO zpi_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ne won tebëd men ne nak farisew ne ndxin nga ne re Ne zenga, re men lo Ne: ―¿Peguin no noo nak ngwlëë? ");
INSERT INTO zpi_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Wke Ne re Ne: ―Belne nyak de ngwlëë, nyeeydet de dol. Per kom na de ne rwii de, laa de yra de rap dol por xdol de. ");
INSERT INTO zpi_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Nligue yna noo lo de yra de ne men ne rdeedet nes ruxloo mëkzhiil, sinke wren nes ledne rdee men, ngbaan men, ");
INSERT INTO zpi_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","per le men ne rdee nes ruloo, men guin nak ne rapkwent mëkzhiil. ");
INSERT INTO zpi_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Men ne zunap ruxloo maa, laa men rxalo chen tee men ne rapkwent maa, no chene rbëz men ma por la maa, rnebeey ma xrëz men, lex rboo men maa. ");
INSERT INTO zpi_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","No chene che wboo men ma yra maa, rzaner men lo maa, lex ranal ma men porke rnebeey ma xrëz men. ");
INSERT INTO zpi_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Per ranaldet ma mén ne rnebeeydet maa xrëz, lel rzhoon ma lo men porke rnebeeydet ma xrëz men. ");
INSERT INTO zpi_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Wzëët Jesus neree zegnak te kwent lo men ne nak farisew, per wdeedet men kwent gan pe rna we. ");
INSERT INTO zpi_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Lex wnii Jesus lo men ste, re Ne: ―Nligue yna noo: Noo nak zegnak ruxloo mëkzhiil. ");
INSERT INTO zpi_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yrandxee mén ne wdxiid kwlodee ke lo noo, ngbaan men; yra men ne nak xpén noo wondet men xdiiz mén guin. ");
INSERT INTO zpi_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Noo nak zegnak ruxloo mëkzhiil; men ne tee ruloo guin ne nak noo, sláá men lo dol. No gak men zegnak mëkzhiil ne rruu rdeetee ruloo chen tsël ne gu maa. ");
INSERT INTO zpi_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ngbaan, noze por ne kwan men zëëd men no por ne yket men no por ne yluzh men. Per le noo zëëd noo por ne gap de gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Noo nak zegnak men ne wen rapkwent mëkzhiil; men ne wen rapkwent mëkzhiil, rboleedx men xgyelembán men por laa maa. ");
INSERT INTO zpi_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Per le men ne rapkwent mëkzhiil noze por ne rdeben men med, chene rwii men ne le lob za, rzhoon men, rsantegue men mëkzhiil, porke nakdeto xdxiin men no let xpëkzhiildet men maa. Lex rdxiin lob rnëëz lob ma rket lob ma, le stebëd ma noze rrëëts. ");
INSERT INTO zpi_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Rzhoon men porke noze por ne rdeben men med rapkwent men maa, zadet ma lextoo men. ");
INSERT INTO zpi_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Noo nak zegnak men ne wen rapkwent mëkzhiil; zegne rnebeey noo xpëkzhiil noo no rnebeey ke ma noo, ");
INSERT INTO zpi_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","zenga ke rnebeey Xuz noo noo no rnebeey ke noo Xuz noo. No axtegue rboleedx noo xgyelembán noo por xpëkzhiil noo. ");
INSERT INTO zpi_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Rap ke noo stebëd mëkzhiil ne nuudet lenlooree; rap noo degne tsaxii no maa, zon ma xdiiz noo, saktes ma yra maa no tebegue men ne gapkwent maa. ");
INSERT INTO zpi_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Ryaan Xuz noo noo porke sdee noo si yket mén noo chen yban ke noo. ");
INSERT INTO zpi_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Rut rgyitxeedet xgyelembán noo, sinke xkwent zhal noo ydee noo si yket mén noo. Rap noo poder ne ydee noo si yket mén noo no ne yban ke noo, porke zenga wnebééy Xuz noo lo noo. ");
INSERT INTO zpi_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chene won men-Israel yra diizree, wzelo men noze wren wren ne rnii men ste. ");
INSERT INTO zpi_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ndal men re: ―¿Penak rukas de men, si menzab nuu lextoo men, nzël men? ");
INSERT INTO zpi_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Per nuu ke zeg men re: ―Ni te mén ne nuu menzab lextoo rundet gan ynii zegwa. ¿Peguin zun menzab gan ylaa ne gyenii bzalo menngwlëë? ");
INSERT INTO zpi_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tyemp ne rak nal chene kalaa men-Israel xelni xeydoo Dëdyuzh Jerusalén, ");
INSERT INTO zpi_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","wa Jesus lenydoo. Ne wdee Ne nes ledne la xKordor Salomón, ");
INSERT INTO zpi_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","wbig yra men-Israel noze kbii Ne, lex re men lo Ne: ―¿Pa axtegue or kwë́z gutxup de lextoo noo? Guninli belne laa de nak Crist. ");
INSERT INTO zpi_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Wke Jesus, re Ne: ―Che na noo we, per rlaleedxdet de noo. Yra ne rlaa noo por xpoder Xuz noo, laa we rbonyoo gan txu nak noo. ");
INSERT INTO zpi_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Per laa de rlaleedxdet do porke nakdet de xpén noo. ");
INSERT INTO zpi_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yra men ne nak xpén noo rnebeey men xrëz noo no rnebeey noo men no rdxidnal men noo. ");
INSERT INTO zpi_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Noo rdee gyelembán ne nunk luzhdet lo men, no ydxiindet dxe ne luzh men, ni rut gundet gan ygyitxee men lo noo. ");
INSERT INTO zpi_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Laa Xuz noo wniiz men lo noo, kesentyent rap me poder, no rut gundet gan ygyitxee men lo me. ");
INSERT INTO zpi_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Noo tebegue nak noo yrup noo Xuz noo. ");
INSERT INTO zpi_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Lex wgoob men-Israel gye ste ngugye men Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Orguin re Jesus: ―Ndal ne wen wlaa noo nes lo de yra de por xpoder Xuz noo. ¿Gonezhe wyandet de byen ne gugye de noo? ");
INSERT INTO zpi_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wke men-Israel, re men: ―Gugyedet noo de por ne wen ne wlaa de, sinke por ne rnii de diznyaan por Dëdyuzh. Porke noze mén nak de, no le de rsak de Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Lex re Jesus: ―¿Pe let redet lo ley ledne re Dëdyuzh: “Noo re ne dëdyuzh nak de yra de”? ");
INSERT INTO zpi_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nan be ne nuudet ykedxnruu be logne re lo xgyiich Dëdyuzh, no laa Ne nak ne re ne dëdyuzh la yra mén ne wseleedx Ne xdiiz Ne lo. ");
INSERT INTO zpi_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","No belne Dëdyuzh Xuz noo wzu noo no laa Ne wxaal noo gyëzlyu, ¿penak na de ne noo rnii diznyaan por laa Ne, por ne na noo XPee Dëdyuzh nak noo? ");
INSERT INTO zpi_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Belne let xdxiindet Xuz noo kalaa noo, ylaleedxdet de noo. ");
INSERT INTO zpi_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Per belne laa we kalaa noo, nyaalzhe ylaleedxdet de noo, per gulaleedx ne rlaa noo, chen gaknan de no le ylaleedx de ne Xuz noo raknonen noo no ne noo raknonen Xuz noo. ");
INSERT INTO zpi_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Orguin wlaan men nnëëz men Jesus ste chen nzano men Ne, per wundet men gan. ");
INSERT INTO zpi_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Lex za Ne stebkoo gyow-Jordán ste ledne wkatxobnis Xwa mén primerendxee, nga wkaa Ne. ");
INSERT INTO zpi_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ndal mén wa lo Ne, lex rulsaa men diiz, re men: ―Nli ne ni te gyelmilaguer wlaadet Xwa, per yrandxee ne wzëët Xwa por ménree, nli we. ");
INSERT INTO zpi_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nga wlaleedx ndal mén Ne. ");
INSERT INTO zpi_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Cheguin ke nuu te mén ne la Laser, rzhuun men, men-Betania nak men yra men bzaan men, Mli no le Mart. ");
INSERT INTO zpi_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Laa Mliree ne nak bzaan Laser ne rzhuun nak ne wdxiib perfum led nii Jesus, lex wkwiidx meno kon gyitsxtoo men. ");
INSERT INTO zpi_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yrubël men wxaal diiz lo Jesus, re men: ―Dechey, le xmig de rzhuun. ");
INSERT INTO zpi_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chene won Jesuso, re Ne: ―Gyelgyiz gwa ne rzak men, nakdeto ne guet men, sinke le we nak ne por laa we yrunyoo xgyelenzoon Dëdyuzh no yrunyoo xgyelenzoon XPee Ne. ");
INSERT INTO zpi_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mase kesentyent ryaan Jesus Mart yrubël men no le Laser bzaan men, ");
INSERT INTO zpi_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","no chene won Ne diiz ne rzhuun Laser, wkaar Ne stxup gbiz nga ledne ka Ne. ");
INSERT INTO zpi_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Zhich guin re Ne lo yra xpén Ne: ―Yoo tsa be Judea ste. ");
INSERT INTO zpi_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Lex re yra xpén Ne lo Ne: ―Maxter, naandxegueree nga wlaan yra men-Israel ngugye men de nesro; ¿no le de rlaangue tsa ste? ");
INSERT INTO zpi_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Orguin re Ne lo men: ―¿Pe let chibtxupdet or rak te dxe? Men ne rzaa yedxe bat rakadet nii men, porke nuu bnii ne rzenii gyëzlyu; ");
INSERT INTO zpi_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","per le men ne rzaa gyëël, noze ledne rakatee nii men, porke nyeniidet. ");
INSERT INTO zpi_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wluzhse re Ne zenga, lex re Ne: ―Le xmig be Laser che waguees, per orree tsaloo noo mkaal lo men. ");
INSERT INTO zpi_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Lex re yra xpén Ne: ―Dechey, belne che waguees men, nuu beey syaken men. ");
INSERT INTO zpi_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Per diiz guin ne re Ne rna we ne che wet Laser, le yra xpén Ne nuu lextoo pazer noze waguees Laser. ");
INSERT INTO zpi_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Orguin re Ne: ―Nligue yna noo lo de, che wet Laser. ");
INSERT INTO zpi_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Per rzhiilen noo ne yët noo no, porke zenga wendee por laa de yra de, chen ylaleedx de noo. Yoo tsa be wii lo men gan. ");
INSERT INTO zpi_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Lex re Tmazh ne rnii mén Mzhoz lo stebëd xpén Ne: ―Yoo tsa be no be, chen guet be yra be Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Chene wdxiin Jesus Betania, che wluzh tap gbiz wgueedx Laser. ");
INSERT INTO zpi_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Guex Jerusalén nak Betania, zeg tsonegue kilometro ryano. ");
INSERT INTO zpi_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","No ndal men-Israel wa wanino Mart yrup Mart Mli por ne wet Laser bzaan men. ");
INSERT INTO zpi_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Chene waknan Mart ne le Jesus che mer ydxiin, wruu Mart watsëlnëz Mart Jesus, le Mli wyan ruyuu. ");
INSERT INTO zpi_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Lex re Mart lo Jesus: ―Dechey, belne nako ne ka de nee, nyetet bzaan noo. ");
INSERT INTO zpi_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Per che nan noo ne mase orree slaa Dëdyuzh yrandxee ne ynab de lo Ne. ");
INSERT INTO zpi_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Wke Jesus, re Jesus: ―Sban bzaan de. ");
INSERT INTO zpi_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Orguin re Mart: ―Che nan noo ne sban men chene yban mengut chene che lultim dxe. ");
INSERT INTO zpi_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Lex re Jesus: ―Noo nak men ne rneban mengut no noo ke nak men ne rseleedx gyelembán lo mén. Mén ne rlaleedx noo, mase guet men, per sbán ke men. ");
INSERT INTO zpi_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yrandxee mén ne mbán, belne rlaleedx men noo, nunk guetet men. ¿Pe rlaleedx de neree? ");
INSERT INTO zpi_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wke Mart, re Mart: ―Rlaleedx noo we Dechey; rlaleedx noo ne laa de nak Crist ne rap degne chiid gyëzlyu, laa de nak XPee Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Wluzh re Mart zeree lo Jesus, lex wa men waluu men diiz lo Mli bël men, ngueedxendxee re men lo Mli: ―Le Maxter che wlenza, laa de rbëz Maxter. ");
INSERT INTO zpi_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Zegne won Mli zenga, wzuligue men za men lo Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Gardet tee Jesus lenlgyëz, benak zu Ne ledne wtsëlo Mart Ne. ");
INSERT INTO zpi_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Chene wii yra men-Israel ne ndxinnino Mli ruxyuu Mli ne noze ryob rdxiintee za Mli, wrunal men Mli; nuu lextoo men pazer ruxbaa bzaan Mli za Mli goon Mli. ");
INSERT INTO zpi_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Chene wdxiin Mli ledne zu Jesus, wzuzhib Mli lo Ne, re men: ―Dechey, belne nako ne ka de nee, nyetet bzaan noo. ");
INSERT INTO zpi_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ne wii Jesus ne roon Mli no ne roon yra men-Israel ne zanal Mli, axtegue nandet Ne pe wuu lextoo Ne, wdenles lextoo Ne; ");
INSERT INTO zpi_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","lex wnabdiiz Ne lo men, re Ne: ―¿Pazh wguu de men? Orguin re men: ―Dechey, gutaa tsa be wii gante. ");
INSERT INTO zpi_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Woonegue Ne. ");
INSERT INTO zpi_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Lex re men-Israel: ―Gukwii gante pezee ryaan men Laser. ");
INSERT INTO zpi_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Per le gwrol men re: ―Ménree nga wlaa ne wyenii bzalo menngwlëë, ¿pe bet wakdet nlaa men chen nyetet Laser? ");
INSERT INTO zpi_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kesentyent wdenles lextoo Jesus ste, wbig Jesus ruxbaa Laser; te bluu nako, te gye zemzëë we. ");
INSERT INTO zpi_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Lex re Jesus: ―Gugyitxee gye gwa rubaa. Orguin re Mart bzaan mengut guin: ―Dechey, pazer che ndxiin rree men, porke che wluzh tap gbiz ne wet men. ");
INSERT INTO zpi_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Wke Jesus, re Jesus: ―¿Pe let che nadet noo lo de ne belne rlaleedx de noo, swii de xgyelenzoon Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Orguin wgyitxee men gye guin. Lex wlis lo Jesus wii Ne gyeybaa, re Ne: ―Dëde, dexkyizhtee de ne wkagyedyag de xdiiz noo. ");
INSERT INTO zpi_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Che nan noo ne syemper rkagyedyag de xdiiz noo, per na noo we por yra ménree ne ndxin nee, chen ylaleedx men ne laa de wxaal noo. ");
INSERT INTO zpi_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chene wluzh re Ne zenga, wkarëz Ne, re Ne: ―¡Laser, guruu wa! ");
INSERT INTO zpi_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Orguin wruu Laser, noze nrëldíp lër nii nyatee men no le lo men. Lex re Ne lo yra mén guin: ―Guchil lër gwa led men, gudee si gya men. ");
INSERT INTO zpi_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yra men-Israel ne zanal Mli, ne wii men ne wneban Jesus Laser, ndalyaa men wlaleedx Ne. ");
INSERT INTO zpi_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Per le gwrol men wa lo men ne nak farisew, wa gue men neguin ne wlaa Ne. ");
INSERT INTO zpi_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Lex wa yra fxuz ne rnebééy lo yra fxuz yra men men ne nak farisew wtop men xtis-Israel, re men: ―¿Pezee ylaa be? Porke ndal gyelmilaguer kalaa mén gwa. ");
INSERT INTO zpi_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Belne ydeer be si ylaa men zegwa, yrandxee mén ylaleedx men, no schiid xtis-Roma yluzh men xeydoo XDëdyuzh be no yluzh men xnacion be. ");
INSERT INTO zpi_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Lad ke men yra men nuu te men ne la Caifás ne nak fxuz ne mazre nondee iz guin, lex re fxuz guin: ―Laa de yra de bet nandet de, ");
INSERT INTO zpi_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ni ryenden de ne wendee guet tebegue mén por yra men-Israel ke ne luzh yrandxee men-Israel. ");
INSERT INTO zpi_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Per let nozdet lextoo Caifás wzaa ne re men zenga, sinke, kom laa men nak fxuz ne mazre nondee iz guin, por neguin wguu Dëdyuzh diiz guin lextoo men ne re men ne guet Jesus por yrandxee men-Israel, ");
INSERT INTO zpi_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","no let nozdet por yra men-Israel, sinke no por ne gaktes yra men ne nak xpén Dëdyuzh, yra men men ne nuu ydendxee gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kwlotee cheguin wyan xtis-Israel diiz ne yket men Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Por neguin wkanyoodetre Jesus lad men-Israel, lex wruu Ne nga za Ne te gyëz ne la Efraín ne nak guex denbidx. Nga wkaa Ne yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kom che wyob pask lni ne rlaa men-Israel, ndal mén ne nuu yrandxee gyëz ra Jerusalén chen ylaa men zegnak xkoxtumber men ne rakndaa men nes lo Dëdyuzh antes ne ydxiin pask. ");
INSERT INTO zpi_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Zad wkayetee men Jesus; le chene nuu men lenxeydoo Dëdyuzh, wnabdizlsaa men, re men: ―¿Pe na de? ¿Pe schiid men lni u chiidet men? ");
INSERT INTO zpi_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Le yra fxuz ne rnebééy lo yra fxuz no le yra men ne nak farisew che wnebééy ne belne nuu mén nan gan gozh Jesus, gue meno lo men chen ynëëz men Ne sano men Ne. ");
INSERT INTO zpi_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Xuup gbiz antes pask, wa Jesus Betania, ledne nuu Laser ne wa Jesus waneban Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nga wzhexkwaa men te xsëë por Jesus; laa Mart kagaa nesyaa, le Laser nak te men ne zob lo mezh yra Laser Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Orguin wgoob Mli zeg gwrool liter perfum ne kesentyent nyezh non ne nzhexkwaa kon teblose gyexnazh byaa, wdxiib meno led nii Jesus, lex wkwiidx meno kon gyitsxtoo men. Ydendxee lenyuu wrenex. ");
INSERT INTO zpi_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Orguin re Judas Iscariote ne wak ke te xpén Jesus no ne wdekwent Jesus: ");
INSERT INTO zpi_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Penak wtoodet men perfum gwa no ndoo we lal ne run mos gan zeg te iz, chen nruu med nkyiinen menprob? ");
INSERT INTO zpi_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Per redet Judas zenga por ne za menprob lextoo Judas, sinke por ne ngbaan men; rbaan men med ne rguu mén lenbols, kom laa men nzen bols guin. ");
INSERT INTO zpi_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Lex re Jesus: ―Zeka wnaaree; neree ne wlaa men, wlaa meno chen che list nak noo chene tsugyeer noo. ");
INSERT INTO zpi_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Porke menprob yzaandxee dxe tsuu men lad de, per le noo che xchedetre tsuu noo lad de. ");
INSERT INTO zpi_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ndalyaa men-Israel waknan ne Betania ka Jesus, lex wa men nga, per wadet men noze por ne kwii men Jesus, sinke no por ne kwii men Laser ne wa Jesus waneban Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Por neguin wyan yra fxuz ne rnebééy lo yra fxuz diiz ne yket men no Laser, ");
INSERT INTO zpi_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","porke por ne wneban Jesus Laser, ndal men-Israel zaruu lad men zalaleedx men Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ne wra gyëël guin, menroo menduxtee ndxin Jerusalén por ne gan men lni; ne won men ne le Jesus zadxiin Jerusalén, ");
INSERT INTO zpi_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","wtxuug men zin wzen men, wruu men watsëlnëz men Jesus, noze nesree nesrotee rlen xrëz men, re men: ―¡Nzoon Dëdyuzh! ¡Dëdyuzh gaknonen men ne zëëd por la Dëdyuzh! ¡Laa men nak xerrey men-Israel! ");
INSERT INTO zpi_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kom wzël te bur bëën bëënleg, wzob Jesus led zegne zëëd lo xgyiich Dëdyuzh ledne re: ");
INSERT INTO zpi_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Men gyëz-Sión, ydxedet de; gukwii, le xerrey de zëëd nee, zëdmbib men te bur bëën bëënleg. ");
INSERT INTO zpi_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wdeedetgue xpén Jesus kwent neree, per chene che sya Jesus gyeybaa, wdee men kwent ne zenga zëëd lo xgyiich Dëdyuzh ledne rakzëët xkwent Jesus no zenga wako. ");
INSERT INTO zpi_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mén ne zu yra Jesus chene wbëz Ne Laser ne yruu Laser lenbaa no ne wneban Ne Laser, laa men ruu diiz ne wii men wneban Ne Laser. ");
INSERT INTO zpi_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Por neguin ndal mén wruu watsëlnëz Ne por ne won men gyelmilaguer guin ne wlaa Ne. ");
INSERT INTO zpi_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lex rulsaa yra men ne nak farisew diiz, re men: ―Betre gakdet ylaa be. ¡Gukwii, yrandxee mén za zanal men! ");
INSERT INTO zpi_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lad yra mén ne wa Jerusalén por ne saknon men Dëdyuzh lo lni, ndxin tebëd men-griego; ");
INSERT INTO zpi_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","wbig mén guin lo Blib men ne nak men-Betsaida gyëz ne nak lo lyu ne la Galilea, lex re men lo Blib: ―Dechey, rlaan noo gu noo diiz yra noo Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Orguin wa Blib re Blibo lo Ndrizh, lex wa men yrup men wa gue meno lo Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Wke Ne re Ne: ―Le or ne gaknyoo xgyelenzoon Men ne wdxiid wak Mén che wdxiin. ");
INSERT INTO zpi_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nligue yna noo lo de, ne zegnak te zhobxtil, belne tsuudeto lenlyu, tetegue nako; per belne tsuu we lenlyu, rakndalo. ");
INSERT INTO zpi_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mén ne rkaa xgyelembán lextoo nee gyëzlyuree, zako perdid; per le mén ne rboleedx xgyelembán por ne nak men xpén noo, zap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Belne nuu mén rlaan ylaa xdxiin noo, rap men degne chidnal men noo, no ledne tsuu noo, nga ke tsuu men. Men ne rlaa xdxiin noo, Dëdyuzh Xuz noo ylep xeblaan men. ");
INSERT INTO zpi_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Kesentyent nles nuu lextoo noo orree. ¿Pe gueleg noo? ¿Peguin ze noo: “Dëde, guselaa noo lo gyelenlesree”? Per por neree nerendxee zëëd noo gyëzlyuree. ");
INSERT INTO zpi_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Lex re Ne: ―Dëde, guluu xgyelenzoon de lo yra ménree. Orguin wlen te rëz gyeybaa, re we: ―Che wluu noo we, per sluu noo we ste. ");
INSERT INTO zpi_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ne won yra mén ne ndxin nga rëz guin, nuu men re: ―Ngwzii we. Nuuzeg men re: ―Te angel wnii lo men. ");
INSERT INTO zpi_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lex re Jesus lo men: ―Let por noodet nak rëzree ne won de, sinke por laa de yra de nako. ");
INSERT INTO zpi_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Le or che wdxiin ne gak gyelextis gyëzlyuree no che ke wdxiin or ne koo Dëdyuzh Bzelo nee gyëzlyuree, ynebééydetre men. ");
INSERT INTO zpi_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","No chene che wkaa noo lo kruz, yralondxee mén gak xpén noo. ");
INSERT INTO zpi_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Neree ne re Ne, wzëët Ne gan pezee guet Ne. ");
INSERT INTO zpi_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lex wke yra mén guin, re men lo Ne: ―Noo yra noo nan noo ne lo xgyiich Dëdyuzh zëëd ne nunk guetet Crist. ¿Penak na de ne Men ne wdxiid wak Mén rap men degne ykaa men lo kruz? ¿Txu wa nak Men ne wdxiid wak Mén? ");
INSERT INTO zpi_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Orguin re Ne: ―Xchedetre ykaa noo lad de yra de, noo nak bnii por laa de. Gutanal noo naaster ne benak ka noo lad de chen saadet de lo nkeb. Porke men ne za lo nkeb nandet men pa za men. ");
INSERT INTO zpi_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Por neguin naaster ne benak ka noo lad de yra de, noo nak bnii por laa de, gulaleedx noo chen gak de xpén noo. Wluzhse re Ne yra neree, sya Ne, wkanyoodetre Ne. ");
INSERT INTO zpi_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mase ndal gyelmilaguer wlaa Jesus nes lo men yra men, no wlaleedxdet men Ne, ");
INSERT INTO zpi_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","porke rap degne gak kumplir ne wkaa profet-Isaías ledne re: Dëde, rut rlaleedxdet ne rzëët noo yra noo. Rut ryenden ne rap de poder. ");
INSERT INTO zpi_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Por neguin wlaleedxdet men Ne, porke rap degne gak kumplir ne wkaa ke profet-Isaías ledne re: ");
INSERT INTO zpi_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dëdyuzh wlaa ne wak men zegnak menngwlëë no wlaa Ne ne wakndíp lextoo men, chen kwiidet men, ni ydeedet men kwent, ni ysaandet men xgyelmal men chen gakdet yláá men lo xdol men. ");
INSERT INTO zpi_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Re Isaías neree porke wii men xgyelenzoon Jesus, por neguin wzëët men xkwent Ne. ");
INSERT INTO zpi_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","No mase zenga, ndal men-Israel wlaleedx Ne, axtegue no tebëd men ne rnebééy wlaleedx Ne; per wkedxnruu meno lo mén por ne rdxe men ne ydeedetre yra men ne nak farisew si tsa men lenydoo. ");
INSERT INTO zpi_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Porke mazre wtseleedx men ne saknon mén men ke ne saknon Dëdyuzh men. ");
INSERT INTO zpi_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ndípse wnii Jesus, re Ne: ―Mén ne rlaleedx noo, let nozdet noo rlaleedx men, sinke rlaleedx ke men Xuz noo ne wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Men ne rwii noo, rwii ke men Xuz noo ne wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Noo nak bnii, zëëd noo gyëzlyuree chen por ne men ne ylaleedx noo tsuudetre men lo nkeb. ");
INSERT INTO zpi_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Men ne ron xdiiz noo per rukasdet meno, let noodet yzakzi men; porke zëëdet noo por ne yzakzi noo mén, sinke le noo zëëd por ne yselaa noo mén lo dol. ");
INSERT INTO zpi_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Men ne rukasdet noo no ne rlaandet gon xdiiz noo, che nuu ne yzakzi men. Yra diiz ne wzëët noo, laa we nak ne yzakzi men chene che lultim dxe. ");
INSERT INTO zpi_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Porke noo rniidet noo noze xkwent noo, sinke laa Xuz noo ne wxaal noo nak ne wzëët lo noo gan pe gue noo no gan pe ynii noo. ");
INSERT INTO zpi_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","No nan noo ne por logne wkyeen Xuz noo noo gap mén gyelembán ne nunk luzhdet. Por neguin logne rzëët noo, rzëët noo we zegne wkyeen Xuz noo noo. ");
INSERT INTO zpi_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Antes pask che nan Jesus ne che wyob ydxiin or ne ysan Ne gyëzlyuree chen gya Ne lo Xuz Ne. Kesentyent wyaan Ne yra xpén Ne nee gyëzlyuree, zenga wyaan Ne men axtegue ne le Ne sya. ");
INSERT INTO zpi_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Che wsegyee Bzelo lextoo Judas xpee Simon Iscariote ne ydekwent men Ne, ");
INSERT INTO zpi_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","no che nan Ne ne yrandxee ne nuu gyëzlyu gyeybaatee wdee Xuz Ne lo Ne chen ynebééy No no ne lo Xuz Ne wruu Ne, lo ke Xuz Ne gya Ne. ");
INSERT INTO zpi_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chene kayuxsëë Ne yra Ne men, wzuli Ne wboo xab Ne lërlegya, wgoob Ne te toay wliib No txu Ne. ");
INSERT INTO zpi_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Lex wgaa Ne nis te leen ntsaa, wzelo Ne waa Ne nii yra xpén Ne, lex wkwiidx No kon toay ne nliib txu Ne. ");
INSERT INTO zpi_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chene wdxiin Ne lo Simon-Bëd ne ga Ne nii men, re men lo Ne: ―Dechey, ¿pe lel laa de ga nii noo? ");
INSERT INTO zpi_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Wke Ne re Ne: ―Orree rdeedet de kwent logne kalaa noo, per sdee de kwento tsoow. ");
INSERT INTO zpi_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Lex re Simon-Bëd: ―Nunk ydeedet noo si ga de nii noo. Wke Ne re Ne: ―Belne gadet noo we, gakdetre gak de xpén noo. ");
INSERT INTO zpi_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Orguin re Simon-Bëd: ―Dechey, gugaa we bes, per let nozdet nii noo, sinke no nya noo no le xtoo noo. ");
INSERT INTO zpi_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Lex re Ne: ―Men ne che waz, nonchee nii men rkyiin ydaa, porke che yde men ndaa. Laa de che ndaa de, per let yradet de ndaa. ");
INSERT INTO zpi_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kom che nan Ne gan txuzh nak ne ydekwent Ne, por neguin re Ne: “Let yradet de ndaa.” ");
INSERT INTO zpi_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wluzhse waa Ne nii men yra men, wak ke Ne xab Ne ste; zhich guin wzob ke Ne lo mezh, lex re Ne lo men: ―¿Pe rdee de kwent neree ne wlaa noo? ");
INSERT INTO zpi_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Laa de yra de, Dechey rnii de noo no le Maxter; nli rnii de, porke nli nak noo we. ");
INSERT INTO zpi_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Noo ne nak noo Dechey no le Maxter, no waa noo nii de yra de, zenga ke rap de degne galsaa de nii xkompanyer de. ");
INSERT INTO zpi_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Wlaa noo neree chen kwii de chen no de ylaa zeree zegne wlaa noo. ");
INSERT INTO zpi_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nligue yna noo lo de ne ni te mos nondet mazre ke lo xpatron men, no ni te mén ne ra mandad nondet mazre ke lo mén ne rxaal men. ");
INSERT INTO zpi_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nzoon de belne rdee de kwent neree no belne rlaa do. ");
INSERT INTO zpi_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Let por yradet de rnii noo; nan noo gan txuzh wye noo ne gak xpén noo. Per rap degne gak kumplir ne zëëd lo xgyiich Dëdyuzh ledne re: “Mén ne ru yrup men noo, le men che rwinyaan noo.” ");
INSERT INTO zpi_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ynague noo neree lo de yra de chen chene gako, ylaleedx de ne noo nak men ne nak noo. ");
INSERT INTO zpi_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nligue yna noo lo de ne men ne tsukas mén ne yxaal noo ne tsa men, noo nga tsukas men; no men ne rukas noo, Xuz noo nga ne wxaal noo zëëd noo rukas men. ");
INSERT INTO zpi_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wluzh re Jesus zenga, kesentyent wdenles lextoo Ne, wzëët Ne neree lo xpén Ne, re Ne: ―Nligue yna noo lo de yra de, ne laake de te de nak ne ydekwent noo lo mén chen yzakzi men noo. ");
INSERT INTO zpi_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Orguin wzelo men noze rwilolsaa men te te men, ni nandet men txu por laa rnii Ne. ");
INSERT INTO zpi_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Te men ne nak ke xpoxter Ne ne kesentyent ryaan Ne, zobnka koo Ne. ");
INSERT INTO zpi_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Lex wluu Simon-Bëd senye lo men chen ynabdiiz men lo Ne gan txu por laa rnii Ne. ");
INSERT INTO zpi_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kom koo Ne zobnka men, wnabdiiz men lo Ne, re men: ―Dechey, ¿txuzh ne? ");
INSERT INTO zpi_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Wke Ne re Ne: ―Ygaz noo tebla gyëtxtil; men ne ydee noo we lo, men guin ne. Lex wgaz Ne tebla gyëtxtil, wdee No lo Judas xpee Simon Iscariote. ");
INSERT INTO zpi_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zegne wnëëz Judas gyëtxtil guin, wdegue Bzelo lextoo Judas. Lex re Ne lo Judas: ―Logne ylaa de, gulaa we gyiid gyiidske. ");
INSERT INTO zpi_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Per ni te men ne ndxin lo mezh wdeedet kwent gan penak re Ne lo Judas zenga. ");
INSERT INTO zpi_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kom laa Judas nzen bols ne nuu med, por neguin nuu lextoo men gwrol men pazer ne ykyiin lo lni re Ne lo Judas yka Judas o ka pe ydee Judas lo menprob. ");
INSERT INTO zpi_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Zegne wnëëz Judas gyëtxtil guin, wruugue men. Chexke wnit lyu orguin. ");
INSERT INTO zpi_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Chene che wruu Judas, re Jesus: ―Le or che wdxiin ne gaknyoo xgyelenzoon Men ne wdxiid wak Mén no por laa men gaknyoo xgyelenzoon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","No belne por laa men gaknyoo xgyelenzoon Dëdyuzh, zenga ke konyoo Dëdyuzh xgyelenzoon men no che wyob ylaa No. ");
INSERT INTO zpi_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Zhiin, che xchedetre ykaa noo lad de. Skaye de noo yra de, per zegne re noo lo men-Israel, zenga ke yna noo lo de yra de orree: Gakdet tsa de ledne gya noo. ");
INSERT INTO zpi_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ykyeen noo de ylaa de te ne kweb: Gugyanelsaa; zeree zegne ryaan noo de yra de, zeree ke gugyanelsaa. ");
INSERT INTO zpi_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Porke belne gyanelsaa de, yrandxee mén ydee kwent ne xpén noo nak de. ");
INSERT INTO zpi_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Lex re Simon-Bëd lo Jesus: ―Dechey, ¿pazh tsa de? Wke Ne re Ne: ―Orree gakdetgue chidnal de noo ledne gya noo, per schidnal de noo tsoow. ");
INSERT INTO zpi_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Orguin re Simon-Bëd: ―Dechey, ¿penak gakdetgue chidnal noo de orree? Noo rboleedx noo xgyelembán noo nyaalzhe guet noo por laa de. ");
INSERT INTO zpi_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Wke Ne re Ne: ―¿Pe nli ne rboleedx de xgyelembán de por noo? Nligue yna noo lo de ne antes ne ykarëz ngyedgol, che wyon tir wkedxnruu de ne rnebeey de noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Re Jesus: ―Bet tsuudet lextoo de yra de, noze ne gulaleedx Dëdyuzh no gulaleedx noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ledne nuu Xuz noo kesentyent nlato por ne tsuu méno; belne nako ne nlateto, che na noo we lo de naa. Orrenaa le noo gya ylaxnëz noo ledne tsuu de yra de. ");
INSERT INTO zpi_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","No chene che wlaxnëz noo ledne tsuu de, lex chiid noo ste, sano noo de chen ledne tsuu noo nga ke tsuu de. ");
INSERT INTO zpi_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Laa de yra de nan de pazh gya noo no che nan de nëz. ");
INSERT INTO zpi_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Orguin re Tmazh lo Ne: ―Dechey, nandet noo pazh gya de; ¿pezee gaknan noo nëz? ");
INSERT INTO zpi_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Wke Ne re Ne: ―Noo nak nëz guin no noo nak diznli no le gyelembán. Nonchee por noo gak ydxiin mén lo Dëdyuzh Xuz noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Belne rnebeey de noo, rnebeey ke de Dëdyuzh Xuz noo; no che rnebeey de me desde orree, porke che wii de me. ");
INSERT INTO zpi_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Lex re Blib: ―Dechey, guluu Dëdyuzh Xuz de lo noo, chen sak lextoo noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Wke Ne re Ne: ―¿Blib, palal xche che ka noo lad de yra de no gardet ynebeey de noo? Men ne che wii noo, che wii ke men Dëdyuzh Xuz noo. ¿Penak na de lo noo: “Guluu Dëdyuzh Xuz de lo noo”? ");
INSERT INTO zpi_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Pe rlaleedxdet de ne Dëdyuzh Xuz noo raknonen noo no ne noo raknonen me? Yra diiz ne rzëët noo lo de, rzëëdet noo we noze xkwent noo, sinke Dëdyuzh Xuz noo ne raknonen noo laa me nak ne rlaa yrandxee ne rwii de rlaa noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gulaleedx ne noo raknonen Xuz noo no ne Xuz noo raknonen noo, o belne rlaleedxdet do, gulaleedx noo maske por logne rlaa noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nligue yna noo lo de yra de ne men ne ylaleedx noo, slaa ke men ne rlaa noo, no slaa men ne mazre nzhoodee, porke le noo wal gya lo Xuz noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","No yrandxee ne ynab de lo Dëdyuzh por la noo, noo ylaa we chen por ne por XPee Dëdyuzh gaknyoo xgyelenzoon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Logne ynabtee de lo Dëdyuzh por la noo, noo ylaa we. ");
INSERT INTO zpi_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Belne nli ryaan de noo, gulaa ne rkyeen noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Noo ynab lo Xuz noo ne yxaal me te Espíritu ne guu lextoo de yra de no ne gaknonen de ydeblo siguelendxee; ");
INSERT INTO zpi_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","laa Espíritu guin nak Espíritu Sant, teblose diznli rzëët Ne. Yra men ne nak noze mengyëzlyu, nuudet gaknonen Ne men, porke rwiidet men Ne, ni rnebeeydet zeg men Ne. Per le laa de yra de rnebeey de Ne, porke lad de nuu Ne no laa Ne gaknonen de. ");
INSERT INTO zpi_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ysandet noo de zegnak bzeb; sberee ke noo lo de. ");
INSERT INTO zpi_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wyob kwiidetre men ne nak noze mengyëzlyu noo, per laa de swii de noo no zap de gyelembán ne rap noo porke noo mbán noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chene ydxiin dxe guin, syenen de ne noo raknonen Xuz noo no syenen de ne noo raknonen de no ne tebegue nak de yra de noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Men ne kanzaleedx ne rkyeen noo no rlaa meno, men guin rbonyoo ne nli ryaan men noo. No men ne ryaan noo, syaan ke Xuz noo men, no syaan ke noo men, no sbonyoo noo gan txu nak noo lo men. ");
INSERT INTO zpi_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Lex re Judas (ne nakdet Iscariote): ―Dechey, ¿penak konyoo de gan txu nak de lo noo yra noo, le lo yra men ne nak noze mengyëzlyu konyoodet do? ");
INSERT INTO zpi_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Wke Jesus, re Jesus: ―Belne nli ryaan mén noo, zon men xdiiz noo no syaan ke Xuz noo men no schiid noo yrup noo Xuz noo tsuu noo yra noo men. ");
INSERT INTO zpi_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Men ne ryaandet noo, rondet men xdiiz noo. Yra diiz ne ron de rzëët noo, nakdeto xdiiz noo, sinke le we nak xdiiz Xuz noo ne wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Rzëët noo yrandxee neree lo de yra de myentras ne benak zu noo lad de; ");
INSERT INTO zpi_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","per laa Espíritu Sant ne yxaal Xuz noo por la noo guu lextoo de no yneluu yrandxee kos lo de, no laa Ne ylaa ne ykanzaleedx de yrandxee ne wzëët noo lo de. ");
INSERT INTO zpi_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Noo yseleedx gyelendxi lo de yra de; xgyelendxi noo ne rseleedx noo, nakdeto zegnak xgyelendxi mengyëzlyu. Bet tsadet lextoo de, ni ydxedet de. ");
INSERT INTO zpi_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Che won de ne na noo: “Le noo gya, per sberee ke noo lo de.” Belne nli ryaan de noo, szhiilen de ne gya noo lo Xuz noo porke laa me nondee ke lo noo. ");
INSERT INTO zpi_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Rzëëtgue noo neree lo de yra de chen chene gako, ylaleedx do. ");
INSERT INTO zpi_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Che xchedetre ynii noo lo de, porke le men ne rnebééy gyëzlyuree che zëëd. Mase let laadet men rnebééy lo noo, ");
INSERT INTO zpi_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","per rapo degne gako, chen gaknan mén ne ryaan noo Xuz noo no ne rlaa noo ne ykyeen me noo. Gusuli, guseyoo naa. ");
INSERT INTO zpi_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Re Jesus lo men: ―Noo nak zegnak merpee blag ub, le Xuz noo nak zegnak men ne rzu we, ");
INSERT INTO zpi_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","le yra xpén noo nak zegnak zhuuko. Yrandxee zhuuko ne rkaadet nex lo, rtxuug Xuz noo we; le lo yra ne rkaa nex lo, rladoo mo chen mazre ykaa nex lo we. ");
INSERT INTO zpi_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Laa de yra de che ndaa de por yra diiz ne che wzëët noo lo de. ");
INSERT INTO zpi_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ysalzaandet de noo, ni noo ysalzaandet noo de. Zegnak te zhuuk blag ub nuudet ykaa nex lo we noze laa we belne ngyeedeto lo xeblago, zenga ke nak de, gakdet ytaal de mén ne ylaleedx noo belne ysalzaan de noo. ");
INSERT INTO zpi_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Noo nak zegnak blag ub, le laa de yra de nak zegnak zhuuko. Men ne rsalzaandet noo, ni noo ysalzaandet noo men, men guin nak ne kesentyent ytaal mén ne gak xpén noo; porke bet gakdet ylaa de noze laa de belne yëtet noo lo de. ");
INSERT INTO zpi_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Men ne ysalzaan noo, sak men zegne rzak zhuuk blag ub ne che wrugyaa, rbidxo; rdopo, ra we lo gyi, reekyo. ");
INSERT INTO zpi_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Belne rsalzaandet de noo no belne rsalzaandet ne rlaa de ne wneluu noo de, gunab ne rlaantee de, skakwent do. ");
INSERT INTO zpi_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Chene ytaal de mén ne ylaleedx noo, cheguin gaknyoo xgyelenzoon Xuz noo no cheguin ke gaknyoo ne xpénpee noo nak de. ");
INSERT INTO zpi_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Zegne ryaan Xuz noo noo, zenga ke ryaan noo de yra de; gukanzaleedx ne ryaan noo de. ");
INSERT INTO zpi_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Belne rlaa de ne rkyeen noo, skanzaleedx de ne ryaan noo de, zegne rlaa noo, kanzaleedx noo ne ryaan Xuz noo noo, no rlaa noo ne rkyeen me noo. ");
INSERT INTO zpi_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Rzëët noo neree lo de chen yzhiilen de zegne rzhiilen noo no chen yzhiilenyaanen de. ");
INSERT INTO zpi_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Logne rkyeen noo de ne ylaa de nak ne gugyanelsaa zegne ryaan ke noo de. ");
INSERT INTO zpi_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gyeleryaan ne mazre nzhoodee nak ne koleedx xgyelembán mén por xmig mén. ");
INSERT INTO zpi_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Belne rlaa de ne rkyeen noo de, laa de yra de nak xmig noo. ");
INSERT INTO zpi_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Che yniidetre noo de xmos noo porke te mos nandet men pe nuu lextoo xpatron men, sinke le noo ynii de xmig noo porke yrandxee ne na Xuz noo lo noo wzëët noo lo de. ");
INSERT INTO zpi_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Let laadet de wye noo, sinke noo wye de no che wzu noo de ne laa de tsa ytaal mén ne gak xpén noo no logne rlaan noo nak ne ysalzaandet yra mén guin ne ylaleedx men noo. Zenga yseleedx Xuz noo logne ynabtee de lo me por la noo. ");
INSERT INTO zpi_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Logne rkyeen noo de ne ylaa de nak ne gugyanelsaa. ");
INSERT INTO zpi_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","No re Jesus: ―Belne kwinyaan mengyëzlyu de, gunileedx ne primer noo wzelo men rwinyaan men. ");
INSERT INTO zpi_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Belne noze mengyëzlyu nak de, nyaan mengyëzlyu de zegne ryanelsaa men. Per kom noo wye de lad mengyëzlyu, por neguin rwinyaan men de, porke nakdetre de noze mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gunileedx ne na noo lo de yra de ne ni te mos nondet mazre ke lo xpatron men. Belne wkanal mén noo por ne yzakzi men noo, skanal ke mén de yra de por ne yzakzi men de, no belne wkagyedyag men xdiiz noo, skagyedyag ke men ne yzëët de. ");
INSERT INTO zpi_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yra neree ylaa men de por ne nak de xpén noo, porke rnebeeydet men Xuz noo ne wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Belne ndxiidet noo nnii noo lo men, nyapdet men dol. Per orree yëtre gan pe gak men gyii por yra dol ne rlaa men. ");
INSERT INTO zpi_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mén ne rwinyaan noo, rwinyaan ke men Xuz noo. ");
INSERT INTO zpi_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Belne nlaadet noo gyelmilaguer lad men, gyelmilaguer ne ni te mén gardet ylaa, nyapdet men dol; per orree che wii men wlaa noo we no mase zenga rwinyaan men noo yrup noo Xuz noo. ");
INSERT INTO zpi_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Per rak neree porke rap degne gak kumplir ne zëëd lo xley men ledne re: “Rwinyaan men noo no nakdet gan pe kwentzho.” ");
INSERT INTO zpi_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Per sxaal noo Espíritu ne yruu lo Xuz noo no ne rzëët teblose diznli no ne guu lextoo de; laa Ne yzëët xkwent noo lo de chene chiid Ne. ");
INSERT INTO zpi_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","No ke de yra de yzëët xkwent noo porke axtegue ne wzelo noo, ka be yra be. ");
INSERT INTO zpi_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Rzëët noo neree lo de yra de chen ysalzaandet de ne rlaleedx de noo. ");
INSERT INTO zpi_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ydeedetre mén si tsa de lenydoo, no axtegue sdxiin dxe ne yket men de, lex tsuu lextoo men xdxiin Dëdyuzh wlaa men ne wlaa meno. ");
INSERT INTO zpi_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Zenga ylaa men porke rnebeeydet men Xuz noo, ni rnebeeydet men noo. ");
INSERT INTO zpi_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Rzëët noo neree lo de yra de, chen chene ydxiin dxe guin, ynileedx de ne che wzëët noo we lo de. ’Wzëëdet noo neree lo de axtegue ne wzelo noo porke yra be ka. ");
INSERT INTO zpi_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Per orree le noo gya lo Xuz noo ne wxaal noo zëëd noo, no ni te de rnabdiizdet lo noo gan pazh gya noo. ");
INSERT INTO zpi_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Lel kesentyent nles nuu lextoo de por ne wzëët noo yra neree lo de. ");
INSERT INTO zpi_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Per rzëët noo logne nli lo de yra de, ne mazre wendee ne gya noo. Porke belne gyadet noo, chiidet Espíritu ne guu lextoo de; per belne gya noo, noo yxaal Ne. ");
INSERT INTO zpi_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Chene chiid Ne, laa Ne ylaa ne gaknan mengyëzlyu ne neey men dol no ne gaknan men gan gonezhe nak ne wen no ne slaa Dëdyuzh gyelextis. ");
INSERT INTO zpi_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mendol nak men porke rlaleedxdet men noo. ");
INSERT INTO zpi_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Syenen men ne menwen nak noo porke le noo gya lo Xuz noo no kwiidetre de noo, ");
INSERT INTO zpi_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","no syenen ke men ne slaa Dëdyuzh gyelextis porke che re Ne ne sakzi Ne Bzelo ne rnebééy nee gyëzlyuree. ");
INSERT INTO zpi_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ndalre ne rap noo ne yzëët noo lo de yra de, per ydeedet de kwento orree. ");
INSERT INTO zpi_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Per chene chiid Espíritu ne rzëët teblose diznli, laa Ne yluu yrandxee ne nli lo de, porke yniidet Ne noze xkwent Ne, sinke le Ne ynii yrandxee ne ron Ne no laa Ne ylaa ne gaknan de ne gyed gak. ");
INSERT INTO zpi_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Laa Ne ylanonre noo porke yrandxee xkwent noo nan Ne no slaa Ne ne gaknan do. ");
INSERT INTO zpi_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yrandxee ne rap Xuz noo, xen noo nako. Por neguin na noo lo de yra de ne yrandxee xkwent noo nan Espíritu Sant no slaa Ne ne gaknan do. ");
INSERT INTO zpi_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Che wyob kwiidetre de noo porke le noo gya lo Xuz noo, per xchedet gako kwii ke de noo ste. ");
INSERT INTO zpi_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Lex wzelo tebëd xpén Jesus rnabdizlsaa men, re men: ―¿Pe rna neree ne na men: “Che wyob kwiidetre de noo, per xchedet gako kwii ke de noo ste”? No ¿pe rna ne na men: “Porke le noo gya lo Xuz noo”? ");
INSERT INTO zpi_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Pe rna ne na men: “xchedet gako”? Rdeedet be kwent diiz gwa ne rnii men. ");
INSERT INTO zpi_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Wyenen Jesus ne rlaan men ynabdiiz men lo Ne, lex re Ne lo men: ―¿Penak kanabdizlsaa de por ne na noo lo de: “Che wyob kwiidetre de noo, per xchedet gako kwii ke de noo ste”? ");
INSERT INTO zpi_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nligue yna noo lo de yra de, ne zoon de no zunles lextoo de, per le mengyëzlyu yzhiilen. Mase tsunles lextoo de, per saa ne nunles lextoo de, gako gyelgwzhiil. ");
INSERT INTO zpi_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Zeg rzak te wnaa chene yzan men zhiin men, rzebyoob men porke le or ne yzan men zhiin men che wdxiin, per chene che wzan men ne, ni rnileedxdetre men gyelerzebyoob por gyelgwzhiil ne le ne che wal; ");
INSERT INTO zpi_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","zenga ke rzak de yra de. Orree nles nuu lextoo de, per chene yberee noo lo de ste, kesentyent yzhiilen de kon te gyelgwzhiil ne rut gundet gan ygyitxee lo de. ");
INSERT INTO zpi_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Dxe guin betre ynabdiizdet de lo noo. Nligue yna noo lo de ne laa Xuz noo yseleedx yrandxee ne ynab de lo me por la noo. ");
INSERT INTO zpi_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Axtegue orree bet gardet ynab de lo me por la noo; gunabo no skakwento, chen yzhiilenyaanen de. ");
INSERT INTO zpi_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Yra ne wzëët noo lo de yra de, wzëët noo we zegnak te kwent; per sdxiin dxe ne yzëëdetre noo we zegnak kwent, sinke axtegue nya yzëët noo xkwent Xuz noo lo de. ");
INSERT INTO zpi_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chene ydxiin dxe guin, snab de lo Xuz noo por la noo; nadet noo lo de ne noo ynab lo Xuz noo por laa de yra de, ");
INSERT INTO zpi_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","porke laake ryaan me de yra de, por ne ryaan de noo no por ne rlaleedx de ne lo me wruu noo. ");
INSERT INTO zpi_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Lo Xuz noo wruu noo ne zëëd noo gyëzlyuree, per orree ysan ke noo gyëzlyuree chen yberee ke noo lo Xuz noo. ");
INSERT INTO zpi_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Lex re yra xpén Jesus: ―Orree si axtegue nya rzëët do, rzëëdetre do zegnak kwent. ");
INSERT INTO zpi_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Orree si ryenen noo ne yrandxee kos nan de, cheguel nan de gan kox ynabdiiz me lo de antes ne ynabdiiz mo. Por neguin rlaleedx noo ne lo Dëdyuzh wruu de ne zëëd de. ");
INSERT INTO zpi_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Wke Ne re Ne: ―¿Pe nlipee ne rlaleedx de noo orree? ");
INSERT INTO zpi_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Porke sdxiin or no laa orguin nee, ne noze yrëëts de yra de yka yka xnëz de te te de, ysan de noo tete noo. Per zudet noo tete noo porke laa Xuz noo raknonen noo. ");
INSERT INTO zpi_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Rzëët noo yra neree lo de yra de chen por noo gap de gyelendxi. Sakzi de nee gyëzlyuree, per ydxedet de, porke che wkuudx noo poder ne nuu gyëzlyuree. ");
INSERT INTO zpi_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Wluzhse re Jesus yra neree, wlis lo Ne wii Ne gyeybaa, re Ne: ―Dëde, le or che wdxiin. Gukonyoo xgyelenzoon XPee de chen konyoo ke XPee de xgyelenzoon de. ");
INSERT INTO zpi_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Porke laa de wdee poder lo XPee de chen ynebééy XPee de yrandxee mén no chen ydee XPee de gyelembán ne nunk luzhdet lo yra mén ne wdee de lo XPee de. ");
INSERT INTO zpi_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Laa gyelembán guin nak ne ynebeey men de ne nonchee laa de nak merpee Dëdyuzh no ne ynebeey men Jesucrist ne wxaal de laa de. ");
INSERT INTO zpi_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Che wbonyoo noo xgyelenzoon de nee gyëzlyuree no che wseyal noo ne wxaal de noo ylaa noo. ");
INSERT INTO zpi_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Naaree naa Dëde ne tsuu noo lo de, guniiz gyelenzoon ke ne wap noo lo de axtegue antes ne gaa gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Yra mén ne wniiz de lo noo nee gyëzlyuree, che re noo lo men gan txu nak de. Xpén de nak men, wniiz de men lo noo no wukas men xdiiz de. ");
INSERT INTO zpi_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Orree che ryenen men ne yrandxee ne wniiz de lo noo, lo de wruu we, ");
INSERT INTO zpi_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","porke yra diiz ne wseleedx de lo noo, che wzëët noo we lo men no wlaleedx meno. Che nanwen men ne lo de wruu noo, no rlaleedx men ne laa de wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Rnab noo lo de por laa men; rnabdet noo por yra men ne nak noze mengyëzlyu, sinke le noo rnab por mén ne wniiz de lo noo, porke xpén de nak men. ");
INSERT INTO zpi_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yrandxee men ne nak xpén noo, xpén de nak men, no yrandxee men ne nak xpén de, xpén noo nak men; laa men rbonyoo xgyelenzoon noo. ");
INSERT INTO zpi_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Noo tsuudetre noo nee gyëzlyuree, per le laa men nee gyëzlyuree benak tsuu men, le noo chiid tsuu lo de. Dëde laa de ne bet dol neeydet de, kon xpoder de gugapkwent yra mén ne wniiz de lo noo chen gak men tebegue zegne nak be tebegue yrup be. ");
INSERT INTO zpi_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ydeblo ne wkaa noo nee gyëzlyuree, kon xpoder de wapkwent noo yra mén ne wniiz de lo noo, waknonen noo men; no ni te men wakdet perdid, sinke nonchee men ne cheguel nuu por gak perdid, chen gak kumplir ne zëëd lo xgyiich de. ");
INSERT INTO zpi_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Orrenaa le noo wal chiid lo de; per rzëët noo neree myentras ne benak zu noo nee gyëzlyuree chen yzhiilenyaanen men zegne rzhiilen noo. ");
INSERT INTO zpi_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Che re noo xdiiz de lo men, per rwinyaan mengyëzlyu men porke nakdet men noze mengyëzlyu, zegnak noo, nakdet noo mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Rnabdet noo lo de ne koo de men nee gyëzlyuree, sinke le noo rnab lo de ne gaknonen de men chen ylaadet men ne mal. ");
INSERT INTO zpi_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nakdet men noze mengyëzlyu, zegnak noo, nakdet noo mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gugyitxee xdol men por diznli, porke xdiiz de nak diznli. ");
INSERT INTO zpi_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Zegne wxaal de noo nee gyëzlyuree, zenga ke rxaal noo men lad mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","No por laa men rboleedx noo xgyelembán noo, chen ybetxee xdol men por diznli. ");
INSERT INTO zpi_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Rnabdet noo nonchee por laa men, sinke le noo rnab no por yra mén ne ylaleedx noo chene gon men ne yzëët yra ménree xkwent noo lo men. ");
INSERT INTO zpi_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Dëde, rnab noo ne tebegue gak men yra men, zegnak noo tebegue yrup noo de, zenga ke tebegue gak men yra men be, chen ylaleedx mengyëzlyu ne laa de wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Laake gyelenzoon ne wniiz de lo noo wdee noo lo men, chen gak men tebegue yra men zegnak be tebegue yrup be. ");
INSERT INTO zpi_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Noo raknonen men, laa de raknonen noo, chen gak men tebegue yra men zegne ryal gak men, no chen zenga gyenen mengyëzlyu ne laa de wxaal noo zëëd noo no gyenen mengyëzlyu ne ryaan de yra menree zegne ryaan ke de noo. ");
INSERT INTO zpi_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Dëde, yra mén ne wniiz de lo noo, rlaan noo ne no ke men tsuu ledne tsuu noo chen kwii men gyelenzoon ne wniiz de lo noo, porke cheguel ryaan de noo axtegue antes ne gaa gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dëde, laa de xnëz rlaa de. Rnebeeydet mengyëzlyu de, per noo rnebeey noo de; no che nan yra ménree ne wniiz de lo noo ne laa de wxaal noo zëëd noo. ");
INSERT INTO zpi_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Che re noo lo men gan txu nak de, no zer noo we lo men, chen gyanelsaa men zegne ryaan de noo no chen gaknonen noo men. ");
INSERT INTO zpi_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wluzhse re Jesus yra neree, wruu Ne yra Ne xpén Ne, za Ne stebkoo guexgyow-Cedrón te ledne nuu yag-olivo, wdee Ne lad yag guin yra Ne men. ");
INSERT INTO zpi_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","No ke Judas ne wdekwent Jesus nan gan pazh nak lugar guin, porke ndal tir wa Ne nga yra Ne xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Lex wdxinno Judas tebëd soldad nga no le tebëd mén ne rapkwent xeydoo Dëdyuzh; laa fxuz ne rnebééy lo yra fxuz no le men ne nak farisew wxaal yra men guin. Zanzen men bnii, no zanzen men gyerbël, no zanzen men spad. ");
INSERT INTO zpi_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Per kom che nan Jesus yra ne sak Ne, wruu Ne nga wnabdiiz Ne lo men, re Ne: ―¿Txu rye de? ");
INSERT INTO zpi_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wke men re men: ―Le noo rye Jesus men-Nazaret. Wke Jesus, re Jesus: ―Noo ne. No ke Judas ne ydekwent Jesus zu lad men. ");
INSERT INTO zpi_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","No chene re Jesus: “Noo ne”, wberezhich men yra men wkantaa men lyu. ");
INSERT INTO zpi_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Lex wnabdiiz Jesus lo men ste, re Jesus: ―¿Txu rye de? Wke men re men: ―Le noo rye Jesus men-Nazaret. ");
INSERT INTO zpi_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Orguin re Ne: ―Che na noo lo de ne noo ne. Belne noo rye de, gudee si gya yra ménree. ");
INSERT INTO zpi_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Wak neree chen gak kumplir ne re Ne, chene re Ne: “Ni te mén ne wniiz de lo noo wakdet perdid.” ");
INSERT INTO zpi_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Lex wboo Simon-Bëd spad ne neey Simon-Bëd, wtxugnëz men gyedyagbëë men ne la Malco ne nak xmos fxuz ne mazre nondee. ");
INSERT INTO zpi_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Orguin re Ne lo Bëd: ―Gugutsoow spad gwa xlugaro. Belne Xuz noo rniiz gyelenlesree ne sak noo we, ¿peguin sakdet noo we? ");
INSERT INTO zpi_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Orguin wbig soldad ne rnebééy yra men xsoldad men no le men ne rapkwent xeydoo Dëdyuzh, wnëëz men Jesus wliib men Ne. ");
INSERT INTO zpi_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Wano men Ne primer ruxyuu Anás porke laa men nak xuzsweguer Caifás ne nak fxuz ne mazre nondee iz guin. ");
INSERT INTO zpi_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Laake Caifásree nga nak ne re lo men-Israel ne wendee guet tebegue mén por yra men-Israel. ");
INSERT INTO zpi_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Wanal Simon-Bëd Jesus yrup men ste xpén Ne. Kom rnebeey fxuz ne mazre nondee ste men guin, neguin wdenal men Ne ruxyuu fxuz, ");
INSERT INTO zpi_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","le Bëd wyan zhiin yaglaa por fwer. Lex wruu xpén Ne ne rnebeey fxuz ne mazre nondee, wnii men lo wnaa ne zunap ruyaglaa; por neguin wdee wnaa guin si wdee Bëd. ");
INSERT INTO zpi_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Orguin re wnaa guin lo Bëd: ―¿Pe let nodet de nak te xpén mén gwa? Wke Bëd, re Bëd: ―Let nodet noo. ");
INSERT INTO zpi_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kom rak nyag, lex wgoob yra mén ne rlaa dxiin nga yag, wzuul men gyi, yra men men ne rapkwent xeydoo Dëdyuzh, kazanen men. No Bëd zu lad men rzanen Bëd lo gyi. ");
INSERT INTO zpi_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Wzelo fxuz ne mazre nondee wnabdiiz men lo Jesus xkwent xpén Ne no le xkwent ne rneluu Ne. ");
INSERT INTO zpi_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Orguin re Ne lo men: ―Noo nes lo yrandxee mén wnii noo, bet ne ngueedx wneluudet noo; yzaandxee dxe wneluu noo mén lenxeydoo Dëdyuzh ledne rdop yra men-Israel. ");
INSERT INTO zpi_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Penak rnabdiiz de lo noo? Lo yra mén ne won ne wzëët noo gunabdiiz; laa men nan gan kox wneluu noo lo men. ");
INSERT INTO zpi_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Zegne re Ne zenga, wgapgue te ke men ne rapkwent xeydoo Dëdyuzh temya gyedkwes Ne, re men lo Ne: ―¿Pe zegwa yke de lo fxuz ne mazre nondee? ");
INSERT INTO zpi_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Wke Ne re Ne: ―Belne nuu ne mal wnii noo, guzëët gan pe ne malzho; per belne wen ne wnii noo, ¿penak wgap de gyedkwes noo? ");
INSERT INTO zpi_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Lex wxaal Anás Ne lo Caifás men ne nak fxuz ne mazre nondee, zengategue nliib Ne. ");
INSERT INTO zpi_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Le Bëd benak zuzanen lo gyi. Lex wnabdiiz men ne ndxin nga lo Bëd, re men: ―¿Pe let nodet de nak te xpén mén gwa? Wke Bëd, re Bëd: ―Let nodet noo. ");
INSERT INTO zpi_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nga zu te men ne nak xmos fxuz ne mazre nondee, xparyent men ne wtxuug Bëd gyedyag, re men lo Bëd: ―¿Pe let laadet de nga wii noo zu lad yag-olivo yrup de men? ");
INSERT INTO zpi_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Wkedxnruu Bëd ste ne rnebeey Bëd Jesus; orguin wkarëz te ngyedgol. ");
INSERT INTO zpi_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ne zëdyenii lyu, wruno men Jesus ruxyuu Caifás, wano men Ne ruxyuloow gobernador, per wdeedet men lenyuloow, porke nduxo por laa men. Belne ndee men, nuudetre nyu men ne ruxsëë men lo pask. ");
INSERT INTO zpi_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Por neguin wruu Pilato re Pilato lo men: ―¿Pagox rkagyii de ménree? ");
INSERT INTO zpi_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wke men re men: ―Belne nyakdet men menmal, ndxidnodet noo men lo de. ");
INSERT INTO zpi_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Lex re Pilato lo men: ―Gusano men laa de, gulaa gyelextis lo men zegne zëëd lo xley de. Wke men re men: ―Noo yra noo yëten noo poder ne yket noo ni te mén. ");
INSERT INTO zpi_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Zenga wak kumplir ne re Ne chene wzëët Ne gan pezee guet Ne. ");
INSERT INTO zpi_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Wberee Pilato wdee ke Pilato lenyuloow, lex wbëz Pilato Ne wnabdiiz men lo Ne, re men: ―¿Pe laa de nak xerrey men-Israel? ");
INSERT INTO zpi_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Lex re Ne: ―¿Pe noze lextoo de rlen negwa ne rnabdiiz de lo noo, u nuu ste mén na we lo de? ");
INSERT INTO zpi_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Wke Pilato, re Pilato: ―¿Pe men-Israel nak noo u? Laake menlaz ke de yra men fxuz ne rnebééy lo yra fxuz wnizkwent de lo noo. ¿Kox wlaa de bes? ");
INSERT INTO zpi_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Lex re Ne: ―Noo rnebééydet noo nee gyëzlyuree. Belne nako ne nee gyëzlyuree rnebééy noo, nyap noo xpén noo ne nlaa dil, chen nnëëzdet men-Israel noo. Per noo rnebééydet noo nee gyëzlyuree. ");
INSERT INTO zpi_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Lex re Pilato: ―¿Rrey nak de cheguin? Wke Ne re Ne: ―Zegwa we zeg na de, rrey nak noo. Por neguin wal noo no por neguin zëëd noo nee gyëzlyuree por ne yzëët noo ne nli. Yrandxee mén ne zanal ne nli, rkagyedyag men ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Orguin re Pilato: ―¿Kox nak ne nli? Wluzhse re Pilato zenga, wruu Pilato ste wnii men lo men-Israel, re men: ―Ryenen noo ne bet ne mal wlaadet ménree, por neguin rzëldeto lo noo. ");
INSERT INTO zpi_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Per laa de yra de rap de koxtumber ne lo pask rnab de ne rláá te mén ne nuu chegyiib. Orrenaa, ¿pe rlaan de yselaa noo xerrey men-Israel? ");
INSERT INTO zpi_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wzelo men rderëz men yra men, re men: ―¡Yselaadet de men gwa! ¡Barrabás guselaa! No te ngbaan nak Barrabás. ");
INSERT INTO zpi_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Lex wkyeen Pilato soldad ne ydee soldad xkwent Jesus. ");
INSERT INTO zpi_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","No wzhexkwaa soldad te korongyëts wzoob meno xtoo Ne, no wnegak men Ne te lërnloren. ");
INSERT INTO zpi_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Lex rbig men lo Ne yra men, re men: ―¡Kesentyent non xerrey men-Israel! No rgap men gyedkwes Ne. ");
INSERT INTO zpi_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Lex wruu Pilato ste, re Pilato lo yra mén guin: ―Gukwii, koo noo men fwer chen gyenen de ne bet ne mal wlaadet men, por neguin rzëldeto lo noo. ");
INSERT INTO zpi_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chene wruu Ne, le korongyëts zob xtoo Ne, le lërnloren guin nak Ne. Lex re Pilato: ―¡Le men nee! ");
INSERT INTO zpi_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Zegne wii fxuz ne rnebééy lo yra fxuz yra men men ne rapkwent xeydoo Dëdyuzh ne wruu Ne, wzelo men rderëz men, re men: ―¡Lo kruz gukaa men! ¡Lo kruz gukaa men! Lex re Pilato lo men yra men: ―Gusano men laa de gukaa men lo kruz, porke noo ryenen noo ne bet ne mal wlaadet men, por neguin rzëldeto lo noo. ");
INSERT INTO zpi_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wke yra men-Israel, re men: ―Noo yra noo rap noo xley noo; lo xley noo nak ne zëëd ne rzëël guet men, porke laake men rlaa men XPee Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Chene won Pilato zenga, kesentyent wdxe men. ");
INSERT INTO zpi_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wdee ke men lenyuloow ste, lex wnabdiiz men lo Ne, re men: ―¿Txu ménzhe nak de? Per bet wkedet Ne. ");
INSERT INTO zpi_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Orguin re Pilato lo Ne: ―¿Penak rkedet de lo noo? ¿Pe nandet de ne rap noo poder ne ykyeen noo ykaa de lo kruz u ne yláá zeg de? ");
INSERT INTO zpi_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Wke Ne re Ne: ―Bet nyundet de gan nlaa de noo, belne nniizdet Dëdyuzh si. Por neguin mén ne wnizkwent noo lo de, ntozdee rap men dol ke laa de. ");
INSERT INTO zpi_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Orguin wye Pilato gan pezee nselaa men Ne; per wzelo yra men-Israel rderëz men, re men: ―¡Belne yselaa de men, nakdet de xmig rrey-Roma! Kwaskyertee men ne re laa men nak rrey, rwinyaan men rrey-Roma. ");
INSERT INTO zpi_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ne won Pilato ne re men zenga, wkyeen Pilato wboo mén Ne fwer. Lex wzob Pilato lo yagzhil ledne rlaa Pilato gyelextis; ledne la Pis Gye zu yagzhil guin, le kon diz-hebreo la we Gabata. ");
INSERT INTO zpi_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Dxe bisper pask zeg rwen ngbiz, re Pilato lo men-Israel: ―Le xerrey de nee. ");
INSERT INTO zpi_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Per wzelo men yra men rderëz men, re men: ―¡Guket men! ¡Guket men! ¡Lo kruz gukaa men! Lex re Pilato lo men: ―¿Peguin skaa noo xerrey de lo kruz? Wke yra fxuz ne rnebééy lo yra fxuz, re men: ―Noo yra noo yëten noo ste rrey, nonchee rrey-Roma nak xerrey noo. ");
INSERT INTO zpi_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Orguin wdekwent Pilato Ne lo men yra men, chen tsakaa soldad Ne lo kruz. ");
INSERT INTO zpi_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Wruno men Jesus nga, zaneey Ne xekruz Ne, zano men Ne ledne la Berxtoo Mengut, kon diz-hebreo la we Gólgota. ");
INSERT INTO zpi_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nga wkaa men Ne lo kruz yra Ne stxup mén, tegue men wkaa lo kruz ne zob ydixyda Ne, le laa Ne wyan gwrooltee. ");
INSERT INTO zpi_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Wkaa Pilato leter, lex wkyeen Pilato soldad wazoobo xtoo xekruz Ne, re leter guin: “Laa Jesus men-Nazaret nee, xerrey men-Israel.” ");
INSERT INTO zpi_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ndal men-Israel wool leter guin por ne ka we kon diz-hebreo, kon diz-griego, no le kon diz-latín no por ne guexendxee Jerusalén wkaa Ne lo kruz. ");
INSERT INTO zpi_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Por neguin wa yra fxuz-Israel ne rnebééy lo yra fxuz, wa gue men lo Pilato: ―Nkaadet de “Xerrey men-Israel”, mazdee gutsaa we, gukaa “Men ne re laa men nak Xerrey men-Israel.” ");
INSERT INTO zpi_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Wke Pilato, re Pilato: ―Logne che wkaa noo, zenga gyano. ");
INSERT INTO zpi_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Chene wluzh wkaa soldad Ne lo kruz, wgoob men xab Ne, wlatap meno, tego wganen men te te men. Le ste xab Ne noze ydebnyaa nako ndiibdeto, ");
INSERT INTO zpi_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","lex wulsaa men diiz, re men: ―Ytxëzdet bo, sinke yoo tsa be pwest gan txuzh yganeno. Zenga wak kumplir diiz ne zëëd lo xgyiich Dëdyuzh ledne re: “Wgyizlsaa men xab noo no wa men pwest gan txuzh yganeno.” No zenga wlaa soldad. ");
INSERT INTO zpi_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Guex ledne ka Ne lo kruz zu xnaa Ne no zu bël xnaa Ne no zu Mli xewnaa Cleofas no le Mli Matlen. ");
INSERT INTO zpi_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Chene wii Ne zu xnaa Ne guex nga no le xpoxter Ne ne kesentyent ryaan Ne, re Ne lo xnaa Ne: ―Wnaae, laa zhiin de wa zu wa. ");
INSERT INTO zpi_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Zhich guin re Ne lo xpoxter Ne: ―Laa xnaa de wa zu wa. Desde cheguin wzano xpén Ne xnaa Ne wkaa men ruxyuu xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wluzh re Jesus zenga, kom che nan Ne ne le we yra we che wak, no chen gak kumplir diiz ne zëëd lo xgyiich Dëdyuzh, re Ne: ―Rlaan noo nis. ");
INSERT INTO zpi_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nga zu te byak yzaa we binaguer; lex wgaz te men ne zu nga tebla zhiil kon binaguer guin, wzoob meno xtoo te bëg-hisopo, lex wtee meno ruu Ne. ");
INSERT INTO zpi_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Chene wluzh woo Ne binaguer guin, re Ne: ―Le we yra we che wak. Nonchee neguin re Ne, wlitlo Ne, wetgue Ne. ");
INSERT INTO zpi_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Dxe guin nak bisper pask. Kom rlaandet men-Israel ne zegue ka Jesus lo kruz yra Ne mén guin dxe ne rne men-Israel, porke dxe guin nak dxe ne kesentyent nda por laa men, por neguin wa men wanab men lo Pilato chen ykyeen Pilato mén ne tsakyiits dxitnii mén guin ne ka lo kruz chen guet men no chen ylit men men lo kruz. ");
INSERT INTO zpi_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Lex wa soldad wkyiits men dxitnii te mén guin ne ka lo kruz yra men Ne; zhich guin wkyiits men dxitnii men ste men. ");
INSERT INTO zpi_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Per chene wbig men zhiin xekruz Ne, wii men le Ne che wet. Por neguin wkyiitsdet men dxitnii Ne. ");
INSERT INTO zpi_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Per wbib te ke soldad lans koo Ne, orguin wruu reno no wruu niso. ");
INSERT INTO zpi_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Men ne wii neree rzëëto, no nli ne rzëët men, no nan men ne nli ne rzëët men chen no de yra de ylaleedxo. ");
INSERT INTO zpi_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wak neree chen gak kumplir diiz ne zëëd lo xgyiich Dëdyuzh ledne re: “Ni tebla dxitled men ykyiitsdet mén”, ");
INSERT INTO zpi_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","no le ste ledne re lo xgyiich Dëdyuzh: “Swii mén men ne wbib mén lans led.” ");
INSERT INTO zpi_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chene wluzh wak neree, wa Xeb men-Arimatea wnab Xeb lo Pilato ne ydee Pilato si gweey Xeb Jesus. No Xeb nak te xpén Ne, per legue ngueedx nak Xeb xpén Ne, por ne rdxe Xeb xtis-Israel. Lex wdee Pilato si wa Xeb weey Xeb Ne. ");
INSERT INTO zpi_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","No le Nicodemo ne wa wuu diiz yrup Ne te gyëël, wdxinneey zeg galebchii kil mirra ne noots áloe; ");
INSERT INTO zpi_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","lex zegne zagueeb meno lo lër guin, zenga ke zatxël meno Ne zegnak xkoxtumber men-Israel chene rgugyeer men mengut. ");
INSERT INTO zpi_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Guex ledne wkaa men Ne lo kruz nuu yagnex; lad yag guin nak te baa ne ni te mengut gardet tsuu. ");
INSERT INTO zpi_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nga wguu men Ne, porke guex nga nak baa guin no porke che wal selo dxe pask ne rlaa men-Israel. ");
INSERT INTO zpi_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dxe ne rzelo xman, rsildoogue wa Mli Matlen ruxbaa Jesus, wii men ne le gye ne zemzëë rubaa che zu tebkoo. ");
INSERT INTO zpi_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Orguin noze rzhoon men wa men lo Simon-Bëd no le lo ste xpoxter Jesus ne kesentyent ryaan Ne, re men: ―Weey mén Jesus lenbaa; txu nan gan pazh walu mén men. ");
INSERT INTO zpi_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Lex wruu Simon-Bëd za Simon-Bëd ruxbaa Ne yrup Simon-Bëd ste poxter guin. ");
INSERT INTO zpi_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Noze rzhoon men za men yrup men; per ntozdee rzhoon ste men guin ke lo Simon-Bëd, kwlodee men wdxiin ruxbaa Ne. ");
INSERT INTO zpi_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Lex wgyixlo men lenbaa wii men le lër ne wrël Ne zhoob nga, per wdeedet men lenbaa. ");
INSERT INTO zpi_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Zhich guin wdxiin Simon-Bëd, wdee Simon-Bëd lenbaa no Simon-Bëd wii zhoob lër guin nga ");
INSERT INTO zpi_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","no wii ke men lër ne wrël xtoo Ne ndeebo zhoobo tebkoo, zhoobdeto tese yrupo lër ne wrël Ne. ");
INSERT INTO zpi_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Lex wdee ste poxter guin, men ne wdxiin kwlodee; wii men neguin ne wak, wlaleedx men ne wban Ne. ");
INSERT INTO zpi_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Per gardet ydee men kwent ne re lo xgyiich Dëdyuzh ne rap Jesus degne yban Ne. ");
INSERT INTO zpi_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Orguin wberee ke men ruyuu yrup men. ");
INSERT INTO zpi_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Per le Mli wyan guex rubaa roon men; orguin ne kayoon men, wgyixlo men lenbaa, ");
INSERT INTO zpi_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","wii men zob txup angel ne nak lërngyich ledne waa Jesus, te ne zob ledne waa xtoo Ne, le ste ne zob ledne waa nii Ne. ");
INSERT INTO zpi_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lex wnabdiiz angel guin lo Mli, re ne: ―Wnaae, ¿penak roon de? Wke men re men: ―Porke weey mén Jesus, no nandet noo gan pazh walu mén men. ");
INSERT INTO zpi_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nonchee wluzh re Mli zenga, wcheree lo Mli wii men le Jesus zu nga, per wnebeeydetgue men Ne. ");
INSERT INTO zpi_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Lex re Ne lo men: ―Wnaae, ¿penak roon de? ¿Txu rye de? Nuu lextoo Mli pazer men ne rapkwent yagnex guin ne, lex re Mli: ―Dechey, belne laa de weey men, guzëët gan pazh walu de men, chen tsaxii noo men. ");
INSERT INTO zpi_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Lex re Ne: ―¡Mli! Wcheree lo Mli, re men lo Ne kon diz-hebreo: ―¡Raboni! (Raboni rna Maxter.) ");
INSERT INTO zpi_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Orguin re Ne lo men: ―Ygaldet de noo, porke gardet gya noo lo Xuz noo. Gutsa gue de lo yra xpén noo ne le noo gya lo Dëdyuzh Xuz noo ne nak ke Xuz de yra de, lo XDëdyuzh noo ne nak ke XDëdyuzh de yra de. ");
INSERT INTO zpi_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Lex waluu Mli Matlen diiz lo yra xpén Ne, re Mli Matlen: “Wii noo Jesus no wuu noo diiz yrup noo Jesus.” ");
INSERT INTO zpi_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chene wnit lyu dxe ke guin ne wzelo xman, ndxin yra xpén Jesus, zemzëë yuu nuu men por ne rdxe men xtis-Israel. Lex wlalo Ne, wzu Ne gwrooltee lad men, re Ne: ―Dëdyuzh yseleedx gyelendxi lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wluzhse re Ne zenga, wluu Ne nya Ne no wluu Ne koo Ne lo men. Kesentyent wzhiilen men ne wii men Ne. ");
INSERT INTO zpi_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Orguin re Ne lo men ste: ―Dëdyuzh yseleedx gyelendxi lo de yra de. Zegne wxaal Dëdyuzh Xuz noo noo ne zëëd noo, zenga ke yxaal noo de yra de. ");
INSERT INTO zpi_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wluzh re Ne zenga, lex wleb Ne led men yra men, re Ne lo men: ―Gukakwent Espíritu Sant. ");
INSERT INTO zpi_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Belne gun de mén perdon, che wak men perdon; per belne gundet de men perdon, gakdet men perdon. ");
INSERT INTO zpi_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Chene wlalo Jesus lo yra xpén Ne, yët Tmazh ne rnii men Mzhoz, te ke men ne nak xpén Ne chibtxup nak Tmazh. ");
INSERT INTO zpi_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Lex re stebëd xpén Ne lo Tmazh: ―Wii noo Jesus. Wke Tmazh, re Tmazh: ―Belne kwiidet noo xbeey klab nya Ne no belne yseedet xkwen noo ledne wgyiich klab no belne yseedet nya noo koo Ne ledne wleedx lans, ylaleedxdet noo we. ");
INSERT INTO zpi_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chene wluzh xun gbiz, ndxin yra xpén Ne ste, cheguin si no Tmazh zu lad men; mase zemzëë yuu nuu men, per wlalo Ne, wzu Ne gwrooltee lad men yra men, re Ne lo men: ―Dëdyuzh yseleedx gyelendxi lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Orguin re Ne lo Tmazh: ―Gukwii ledxnya noo, gusee xkwen do, no gubig gusee nya de koo noo. Tsutxupdetre lextoo de, gulaleedxo. ");
INSERT INTO zpi_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Lex wke Tmazh, re Tmazh lo Ne: ―Dechey, laa de nak XDëdyuzh noo. ");
INSERT INTO zpi_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Re Ne lo Tmazh: ―Rlaleedx de noo porke che wii de noo; nzoon men ne rlaleedx noo mase rwiidet men noo. ");
INSERT INTO zpi_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ndal gyelmilaguer ne wlaa Jesus nes lo yra xpén Ne wkaadet lo liberree. ");
INSERT INTO zpi_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Per wkaa yra neree chen ylaleedx de yra de ne Jesus nak Crist XPee Dëdyuzh no chen chene ylaleedx de Ne, gap de gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Zhich guin wlalo Jesus lo tebëd xpén Ne ste chene ndxin men runis-Tiberias. Zeree wlalo Ne: ");
INSERT INTO zpi_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Te chene zu Simon-Bëd yra Simon-Bëd Tmazh ne rnii mén Mzhoz, no le Natanael men-Caná gyëz ne nak lo lyu ne la Galilea, no le yrubech xpee Zebedew, no le stxup xpén Ne, ");
INSERT INTO zpi_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","re Simon-Bëd lo men: ―Le noo tsa gozmël. Re men: ―No noo saa tsa be. Lex wdxiin men ledne zob bark, wdee men leeno za men, per bet mël wzuundet lo men gyëël guin. ");
INSERT INTO zpi_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Chene zëdyenii lyu, wlalo Jesus lo men runis, per nandet men ne Jesus ne. ");
INSERT INTO zpi_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Lex re Ne lo men: ―Zhiin, ¿pe ni te mël gardet yzuun lo de? Wke men re men: ―Axtegue ni te maa. ");
INSERT INTO zpi_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Orguin re Ne lo men: ―Gutxoon xgyix de koo bark ladbëë, suun maa. Lex wtxoon meno, le chene nboo meno, axtegue rakdet koo meno tant ndal mël wzuun. ");
INSERT INTO zpi_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Lex wbig xpoxter Ne ne kesentyent ryaan Ne, re men lo Simon-Bëd: ―¡Jesus ne! Zegne won Simon-Bëd ne Jesus ne, wak xab men, porke nakdet meno, lex wyab men lo nis. ");
INSERT INTO zpi_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Le stebëd xpén Ne wdxinno bark runis, kakamloy men gyix yzaa mël lengyix, porke zobdet bark nat, zeg tebgwyuu ke meter zobo kwlo runis. ");
INSERT INTO zpi_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Chene wruu men lenbark, wii men le gyi che rul, te mël che zhoob lo gyi no le gyëtxtil. ");
INSERT INTO zpi_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Lex re Ne lo men: ―Gutano tebëd mël ne gyed wzuun lo de. ");
INSERT INTO zpi_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Orguin wdee Simon-Bëd lenbark, wgobzengye men gyix axtegue lo yuzh, yzaa mëlnzhoo leeno, tebgwyuuno-txupchibtson ma nuu leeno; no mase lal ma nga nuu, no wrëzdet gyix. ");
INSERT INTO zpi_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Lex re Ne lo men yra men: ―Gutaa yxenzhen de. No ni te men wyezhdet nnabdiiz lo Ne ne nye men: “¿Txu laa de?”, porke nan men ne Jesus ne. ");
INSERT INTO zpi_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Orguin wbig Ne, wgoob Ne gyëtxtil wdee No lo men; zenga ke wlaa Ne mël. ");
INSERT INTO zpi_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Laa ne wak tson tir ne wlalo Ne lo yra xpén Ne nee chene che wban Ne. ");
INSERT INTO zpi_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Chene wluzh wxenzhen men, re Jesus lo Simon-Bëd: ―Simon xpee Jonás, ¿pe ryaandee de noo ke lo yra menree? Wke Simon-Bëd, re Simon-Bëd: ―Ryaan noo de Dechey. Laa de nan de ne ryaan noo de. Lex re Ne: ―Gugapkwent xpén noo bes. ");
INSERT INTO zpi_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Zhich guin re Ne lo Simon-Bëd ste: ―Simon xpee Jonás, ¿pe ryaan de noo? Wke Simon-Bëd, re Simon-Bëd: ―Ryaan noo de Dechey. Laa de nan de ne ryaan noo de. Lex re Ne: ―Gugapkwent xpén noo bes. ");
INSERT INTO zpi_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ne wyon tir ne re Ne lo Simon-Bëd: ―Simon xpee Jonás, ¿pe ryaan de noo? Wdenles lextoo Simon-Bëd por ne wnabdiiz Ne tson tir gan pe ryaan Simon-Bëd Ne. Lex re Simon-Bëd lo Ne: ―Dechey, laa de nan de yrandxoo; nan de ne ryaan noo de. Lex re Ne lo Simon-Bëd: ―Gugapkwent xpén noo bes. ");
INSERT INTO zpi_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nligue yna noo lo de ne chene benak menyu de, wak de xab de, wa de ledne wlaantee de, per chene gyuux de, yzegaa nya de, wren men ne ynegak xab de, tsano men de ledne rlaandet de tsa de. ");
INSERT INTO zpi_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ne re Ne zenga, wzëët Ne gan pezee guet Simon-Bëd chen por xgyelgut Simon-Bëd gaknyoor xgyelenzoon Dëdyuzh. Wluzhse re Ne zenga, lex re Ne lo Simon-Bëd: ―¡Gutanal noo! ");
INSERT INTO zpi_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Chene wcheree lo Simon-Bëd, wii Simon-Bëd no ke xpoxter Jesus ne kesentyent ryaan Ne zanal Ne, men ne wzob ke koo Ne chene wuxsëë men yra men Ne, no ne wnabdiiz ke lo Ne, ne re: “Dechey, ¿txuzh nak ne ydekwent de?” ");
INSERT INTO zpi_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ne wii Simon-Bëd men, re Simon-Bëd lo Ne: ―Dechey, zhan gwa naa, ¿pezee sak zhaa? ");
INSERT INTO zpi_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Wke Ne re Ne: ―Belne nako ne rlaan noo ne ybán zhaa axtegue ne yberee noo, tsuudet de lyaaz neguin. Noze ne gutanal noo. ");
INSERT INTO zpi_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Por neguin wrëëts diiz lad yra xpén Ne ne guetet xpén Ne men guin. Per redet Ne ne guetet men, sinke le Ne re: “Belne nako ne rlaan noo ne ybán zhaa axtegue ne yberee noo, tsuudet de lyaaz neguin.” ");
INSERT INTO zpi_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Laake xpén Ne men guin nak ne rzëët yra neree no ne wkaa yra neree. No nan be ne nli ne rzëët men. ");
INSERT INTO zpi_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ndalre ne wlaa Ne belne nako ne nkaa we tegue tegoo, pazer ni ngadet gyëzlyu nyuu yra liber ne nkaa we lo. Zengaw.");
INSERT INTO zpi_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofil, lo primer gyiich ne wkaa noo, wkaa noo yrandxee ne wlaa Jesus no le yra ne wneluu Ne desde ne wzelo Ne, ");
INSERT INTO zpi_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","axtegue dxe ne wyeep Ne gyeybaa. Antes ne gyeep Ne gyeybaa, por Espíritu Sant re Ne lo yra xpoxter Ne ne wye Ne, logne ylaa men. ");
INSERT INTO zpi_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Chene che wet Ne, lo ke yra men guin nak ne wlalo Ne no noze ndal ne wlaa Ne, zenga wbonyoo Ne ne nli mbán Ne. Txuplal gbiz wlalo Ne lo men no wzëët Ne zegne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chene benak zu Ne yra Ne poxter, wnino Ne men ne yruudet men Jerusalén, re Ne: ―Gukwë́z axtegue ne gak yra diiz ne re Xuz noo, zegne che na noo lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nli ne kon nis wtxobnis Xwa mén, per xchedetre gako ne yrobnis de kon Espíritu Sant. ");
INSERT INTO zpi_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Chene ndxin yra poxter lo Jesus, wnabdiiz men lo Ne, re men: ―Dechey, ¿pe naagueree ynebééy de lo men-Israel? ");
INSERT INTO zpi_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wke Ne re Ne: ―Ryaldet de ne gaknan de gan pa dxe, gan pa or gako; nonchee Xuz noo nan gan pa dxe, gan pa or wsu me ne gako, porke nonchee laa me rap poder. ");
INSERT INTO zpi_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Per chene che waknonen Espíritu Sant de, ykakwent de poder; laa de nak ne yzëët lo mén gyëz-Jerusalén gan txuzh nak noo no le lo yra mén ne nuu yrandxee gyëz ne nak Judea no le ne nak Samaria no le yrandxee gyëz ne nak ledne mazre natdee lo gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chene wluzh re Jesus yra diizree, myentras kawii men yra men lo Ne, wyepgya Ne wrël bëw Ne, wnitlo Ne lad bëw, wiidetre men Ne. ");
INSERT INTO zpi_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Myentras ne kawii men ne syayeep Ne gyeybaa, tebegue wlalo txup mgyeey ne nak lërngyich ledne ndxin men, ");
INSERT INTO zpi_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","re yrup mgyeey guin lo men: ―Men-Galilea, ¿penak kawiitegue de gyeybaa? Jesus ke ne wii de sya gyeybaa, laake Ne yberee ste; zegne wii ke de ne sya Ne, zenga ke yberee Ne. ");
INSERT INTO zpi_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chene wberee yra poxter ne wa men gyeey ne la Olivos, wzaa men tebla, wdxiin ke men Jerusalén, medid zegne zëëd lo ley ne saa mén dxe ne rne men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ne wdxiin men Jerusalén, wyeep men te lenyuu ne txup pis ledne wbë́z men. Laa men nga nak Bëd, Jacob, Xwa, Ndrizh, Blib, Tmazh, Bartolomé, Mdëw, Jacob xpee Alfeo, Simon men ne nak Zelot, no le Judas bech Jacob. ");
INSERT INTO zpi_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Syemper rdop men yra men zeree chen ynab men lo Dëdyuzh yra men Mli xnaa Jesus no le stebëd wnaa no le bech Jesus. ");
INSERT INTO zpi_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Te dxe guin ne wdop zeg tebgwyuuno-gal mén ne rlaleedx Jesucrist, wzuli Bëd gwrooltee lad men yra men, re Bëd lo men: ");
INSERT INTO zpi_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Yra de ne no de rlaleedx Jesucrist, gugaknan neree, ne wap degne wak ne wkaa David lo xgyiich Dëdyuzh zegne re Espíritu Sant lo David; laa ne wkaa David nga nak xkwent Judas men ne wdekwent Jesus lo yra mén ne wa wanëëz Ne. ");
INSERT INTO zpi_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Te ke xkompanyer be wak Judas, dxiin ke ne kalaa be wlaa Judas. ");
INSERT INTO zpi_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kon med ne wgyizh men wka Judas por ne mal ne wlaa Judas, wka Judas tebla lyu. Nga wkantanzhextoo Judas, wrëz txu Judas, wruu yrandxee gyed-xgyee Judas, wet Judas. ");
INSERT INTO zpi_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chene waknan yrandxee men-Jerusalén neree, wnesela men lyu guin Acéldama; Acéldama rna Lyu Ren kon xdiiz men. ");
INSERT INTO zpi_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Porke lo liber Salmos re: Noze zenga gyan xyuu men, rutre tsuudeto. No re ko: Ste mén tee nii men. ");
INSERT INTO zpi_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Nee ndxin yra mgyeey ne nuu lad be ydeblo ne wuu Jesus lad be ");
INSERT INTO zpi_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","desde ne wtxobnis Xwa Jesus, axtegue ne wyeep Ne gyeybaa. Te mgyeey guin rkyiin tee lad noo yra noo ne nak noo poxter chen gun men xyudar noo ne yzëët noo ne nli wban Ne. ");
INSERT INTO zpi_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Lex wye men txup mgyeey lad yra mén guin: Matías no le Xeb Barsabás no rnii ke mén men Justo. ");
INSERT INTO zpi_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Orguin wnab men lo Dëdyuzh, re men: ―Dëde, laa de rnebeywen lextoo yra mén. Delo yrup ménree, guluu gan txu men wbe de ");
INSERT INTO zpi_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","chen tee men nii Judas gak men poxter, ylaa men dxiin ne wsan Judas por xdol Judas, porke le Judas sya ledne ryal gya Judas. ");
INSERT INTO zpi_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Lex wii men gan txu rap swert. Laa Matías wap swert wak poxter ne le poxter wzaa chibtxup ste. ");
INSERT INTO zpi_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Chene wdxiin lni Pentecostés, wdop yrandxee mén ne rlaleedx Jesucrist tebegue lugar. ");
INSERT INTO zpi_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tebegue won men te be ne wruu axtegue gyeybaa, zegnak chene kesentyent rlen mee, wuu be guin ydendxee lenyuu ledne ndxin men. ");
INSERT INTO zpi_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Lex wlalo ndal zegnak loz mén, nako zegnak bël, wrëëtso xtoo men te te men. ");
INSERT INTO zpi_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kesentyent waknonen Espíritu Sant men yrandxee men, wzelo men rnii men ste klas diiz zegne wlaan Espíritu Sant ne ynii men. ");
INSERT INTO zpi_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ndalyaa men-Israel ne rlaa zegne rlaan Dëdyuzh ndxin Jerusalén dxe guin; noze yde lo gyëzlyu wruu men wdxiin men Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chene won men be guin, wdop men wa men wii gan koxo. Chene wdxiin men nga, ni nandet men pe wuu lextoo men, porke ron men rnii yra mén guin ne rlaleedx Jesucrist xdiiz men ne rnii men te te men. ");
INSERT INTO zpi_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kesentyent wzee wzak men axtegue nandet men pe nlaa men, lex re men lo xkompanyer men: ―¿Pe let men-Galileadet nak yra ménree ne kanii? ");
INSERT INTO zpi_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Pezee rnii men xdiiz be te te be? ");
INSERT INTO zpi_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nee ndxin men-Partia, men-Media, men-Elam, men-Mesopotamia, men-Judea, men-Capadocia, men-Ponto, men-Asia, ");
INSERT INTO zpi_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","men-Frigia, men-Panfilia, men-Egipto, no le men-Libia ne nak guex Cirene, no le men-Roma. Gwrol ménree nak men-Israel axtegue ne wal men. Gwrol zeg men gyed wlaleedx Dëdyuzh zegne rlaleedx men-Israel Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","No ndxin ke men-Creta no le men-Arabia. ¡Per yrandxee be ron be rzëët men kon xdiiz be yra gyelenzoon ne rlaa Dëdyuzh! ");
INSERT INTO zpi_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kesentyent wzee wzak yrandxee mén guin axtegue nandet men pe wuu lextoo men, lex wnabdizlsaa men, re men: ―¿Goxleg rna yra neree? ");
INSERT INTO zpi_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Per nuu men lel wzhidxno, re men: ―¡Rzudxen yra ménree! ");
INSERT INTO zpi_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Lex wzuli Bëd tese yra Bëd schibteb poxter, ndípse wnii Bëd, re Bëd: ―Men-Israel no le yra mén ne nuu Jerusalén, gugaknan neree yra de no wen wenendxee gugon logne yna noo lo de. ");
INSERT INTO zpi_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yra ménree rzudxden men zegne nuu lextoo de, porke penendxee beygaa rsil. ");
INSERT INTO zpi_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Neree ne kayak, laa we nga wzëët profet-Joel chene re men: ");
INSERT INTO zpi_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Re Dëdyuzh: “Chene che lultim dxe yxaal noo XEspíritu noo gaknonen yrandxee mén. Yra zhingaan men no le yra zhinzaap men yzëët diiz ne guu noo lextoo men; yra menyu, nuu ne ylalo lo men; le yra mengol nexgyëëlen lo mkaal. ");
INSERT INTO zpi_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chene ydxiin dxe guin, yxaal noo XEspíritu noo gaknonen yra mgyeey no le yra wnaa ne kalaa xdxiin noo, lex yzëët men diiz ne guu noo lextoo men. ");
INSERT INTO zpi_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Le gyeybaa konyoo noo ne yzee sak mén, le gyëzlyu tsuu beey ne nak zegnak ren, zegnak bël, zegnak bëwguux. ");
INSERT INTO zpi_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Gaknkeb lo ngbiz, le mëëw gak zegnak ren antes ne ydxiin dxe ne nzhoo no ne nzoon ne chiid Crist. ");
INSERT INTO zpi_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yrandxee mén ne ynab lo Dëdyuzh, sláá men lo dol.” ");
INSERT INTO zpi_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Men-Israel, gugon yra diizree ne yzëët noo lo de: Wbonyoo Dëdyuzh xgyelnon Jesus men-Nazaret por yra gyelmilaguer ne wlaa Ne nes lo de yra de no le yra beey ne wzee wzak de, no nan de ne nli we. ");
INSERT INTO zpi_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wlaa de Jesus zegne che wlebleedx Dëdyuzh no zegne che nan Dëdyuzh axtegue chekwlo. Wnëëz de Ne yra de wdekwent de Ne lo menmal chen ykaa men Ne lo kruz guet Ne. ");
INSERT INTO zpi_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per wneban Dëdyuzh Ne no wselaa Dëdyuzh Ne lo gyelgut, porke gundet gyelgut gan lo Ne. ");
INSERT INTO zpi_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Laa xkwent Ne nga re rrey-David chene re men: Noo syemper rwii noo zu Dëdyuzh lo noo; wii noo zu Ne koo noo ladbëë; por neguin bet gundet gan lo noo. ");
INSERT INTO zpi_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Por neguin kesentyent rzhiilen lextoo noo no rzhiilen noo rolbaan noo, zet noo, per tebli nuu lextoo noo, porke che nan noo ne sban noo, ");
INSERT INTO zpi_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","porke ydeedet de si gyan noo lenbaa no ydeedet de si xiin xkwerp XPee de ne bet dol rlaadet. ");
INSERT INTO zpi_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Laa de wlaa ne waknan noo nëz ne gak ydxiin noo lo Dëdyuzh ledne gap noo gyelembán. Kesentyent yzhiilen noo ne kwii noo de. ");
INSERT INTO zpi_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Men-Israel, yzëët noo logne nli lo de: David ne nak xpenkwlal be, wet men, wgugyeer mén men, no benak nex xbaa men nee axtegue naaree. ");
INSERT INTO zpi_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Te profet wak men no wkanzaleedx men ne re Dëdyuzh lo men ne lad xfamilye men yruu Crist ne sob ynebééy. ");
INSERT INTO zpi_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Axtegue antes che nan men neree; por neguin re men ne sban Crist no ne gyandet Ne lenbaa, ni xiindet xkwerp Ne. ");
INSERT INTO zpi_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Naaree naa le Dëdyuzh che wneban Jesus guin; no wii noo yra noo ne nli wban Ne. ");
INSERT INTO zpi_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Sya Ne gyeybaa koo Dëdyuzh ladbëë no wkakwent Ne Espíritu Sant ne che re Dëdyuzh; orrenaa le Ne che wxaal Espíritu Sant lo noo yra noo; laa we nee nak ne kawii de yra de no ne kayon de. ");
INSERT INTO zpi_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Porke let Davidet wyeep gyeybaa, porke David ke re: Dëdyuzh re lo XDëdyuzh noo: “Gusob koo noo ladbëë ");
INSERT INTO zpi_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","axtegue ne ylaa noo ne gyichnii de yrandxee mén ne rlaa lo de.” ");
INSERT INTO zpi_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Yrandxee de ne nak de men-Israel, gugaknanwen ne Jesus ke ne wkaa de lo kruz, Dëdyuzh wlaa ne laa Ne rnebééy no wlaa Dëdyuzh Ne Crist. ");
INSERT INTO zpi_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chene won yra mén ne ndxin nga diizree, wdenles lextoo men. Orguin wnabdiiz men lo Bëd no le lo stebëd poxter, re men: ―¿Pagox nak ne ylaa noo? ");
INSERT INTO zpi_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Wke Bëd, re Bëd: ―Gusaan xgyelmal de no gurobnis te te de por la Jesucrist, chen gun Dëdyuzh perdon xdol de no chen yseleedx Ne Espíritu Sant lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Porke diiz guin ne re Dëdyuzh, por laa de yra de nako no le por yra zhiin de no le por yrandxee mén ne nuu nat no le por yrandxee mén ne rlaantee Dëdyuzh kwëz Ne. ");
INSERT INTO zpi_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yra diizree wnii Bëd lo men yra men no ndalre diiz ne wnino Bëd men, re Bëd: ―¡Guruu lad menmal ne nuu naaree! ");
INSERT INTO zpi_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yra mén ne wlaleedx diiz ne wzëët Bëd, wrobnis men. No dxe ke guin wdee zeg stsonmil mén lad men ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kesentyent nulyaaz men yra ne rneluu poxter lo men, tebegue nak men yra men no ra men ru men gyëtxtil tese yra men zegne wkyeen Jesus no rnab men lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kesentyent rzee rzak yrandxee mén por yra gyelmilaguer no le por yra gyelenzoon ne rlaa poxter. ");
INSERT INTO zpi_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yrandxee mén ne wlaleedx Jesucrist, tebegue wak men yra men no runelsaa xyudar xkompanyer men kon logne rapendxee men. ");
INSERT INTO zpi_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Rtoo men xelyu men no rtoo men logne rapendxee men, lex rgyiiz men med lo xkompanyer men segun lyaaz ne rzak men te te men. ");
INSERT INTO zpi_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yzhe yzhendxee rdop men lenxeydoo Dëdyuzh no axtegue nzoon nuu lextoo men ra men gwdu ruxyuu xkompanyer men ydebgyiky ydeblextootee men. ");
INSERT INTO zpi_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Rzaknon men Dëdyuzh, no ryaan yrandxee mén men. Yzaandxee dxe zalandalre Dëdyuzh yra mén ne yláá lo dol. ");
INSERT INTO zpi_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Te dxe wayeep Bëd yrup Bëd Xwa lenxeydoo Dëdyuzh beytson wzëë. Orguin nak ne ranab mén lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nga ruydoo zob te mgyeey ne ngyidet nii axtegue ne wal men. Yzaandxee dxe ra mén razoob mén mgyeey guin ruydoo ledne ka yaglaa ne la Zhaandxee, chen ynab men goon lo yra mén ne rdee lenydoo. ");
INSERT INTO zpi_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Chene wii mgyeey guin ne za tee Bëd lenydoo yrup Bëd Xwa, wnab men te goon lo Bëd. ");
INSERT INTO zpi_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Lex wii wiindxee Bëd yrup Bëd Xwa lo mgyeey guin, re Bëd lo men: ―Gukwii lo noo. ");
INSERT INTO zpi_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Orguin wii men lo Bëd yrup Bëd Xwa. Nuu lextoo men ka pe ydee Bëd lo men. ");
INSERT INTO zpi_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Per re Bëd lo men: ―Yëten noo plat ni or ne yniiz noo lo de, per logne gun noo gan ylaa noo, ylaa noo we por laa de: ¡por la Jesucrist men-Nazaret gusuli, gusaa! ");
INSERT INTO zpi_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Lex wnëëz Bëd nyabëë men wnesuli Bëd men. Orgueguin wuu fwers nii men no le dxitzëdnii men. ");
INSERT INTO zpi_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Axtegue watxegya men wzuli men, wzelo men wzaa men; lex wdenal men Bëd lenydoo yrup Bëd Xwa, rzaa men no ratxegya ratxegya men, rzaknon men Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yrandxee mén ne wii ne le men che rzaa no ne rzaknon men Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","kesentyent wzee wzak men no wdxe men por neguin ne wak, porke rnebeey men mgyeey guin no nan men ne laa men nga rzob rnab goon ruydoo ledne ka yaglaa ne la Zhaandxee. ");
INSERT INTO zpi_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mgyeey guin ne wyaken, rsalzaandetre men Bëd yrup Bëd Xwa. Yrandxee mén wzee wzak, noze rzhoon mén wa men ledne la xKordor Salomón, ledne zu Bëd gyon Bëd mgyeey guin. ");
INSERT INTO zpi_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ne wii Bëd wdop yra mén guin, re Bëd lo men: ―Men-Israel, ¿penak rzee rzak de por neree? ¿Penak rwii de lo noo yrup noo zeg noo leg wlaa ne wyaken ménree? ¿Pe nuu lextoo de por xpoder noo u por ne mbán noo zegne rlaan Dëdyuzh wlaa ne rzaa men? ");
INSERT INTO zpi_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","XDëdyuzh Abraham ne nak xpenkwlal be, XDëdyuzh Isaac, XDëdyuzh Jacob wlaa we; wdee Ne poder lo Jesus XPee Ne ne wdekwent de lo xtis, no chene wlaan Pilato nselaa Pilato Jesus, nadet de. ");
INSERT INTO zpi_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Lugar ne nnab de ne nselaa Pilato Jesus ne bet dol wlaadet no ne kesentyent xnëz nak, lel wnab de ne wláá mén ne wlaa gyii. ");
INSERT INTO zpi_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Zenga wlaa de wket de Jesus ne rseleedx gyelembán lo mén, per wneban Dëdyuzh Ne. Noo yra noo nak ne wii ne nli wban Ne. ");
INSERT INTO zpi_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ménree ne rwii de no ne rnebeey de, por la Jesus wuu fwers nii men no por ne wlaleedx men Jesus, wyaken men nes lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Men-Israel, noo nan noo ne chene wket de Jesus yra de xtis, nandet de pe wlaa de. ");
INSERT INTO zpi_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Per zenga wun Dëdyuzh kumplir yra diiz ne wzëët yra xprofet Ne axtegue chekwlal chene re men: sakzi Crist. ");
INSERT INTO zpi_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Por neguin gusaan xgyelmal de, lex gugak xpén Dëdyuzh, chen ysuu Ne xdol de no chen zenga yseleedx Ne gyelgwzhiil lo de ");
INSERT INTO zpi_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","chene yxaal Ne Jesucrist nee gyëzlyuree ste, Jesucrist ne wsanla Ne axtegue chekwlal chen gaknonen Ne de yra de. ");
INSERT INTO zpi_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Per naaree rap Jesucrist degne gyan Ne gyeybaa axtegue ne ylaxnëz Dëdyuzh yrandxee kos zegne re Dëdyuzh no zegne wzëët yra xprofet Ne ne xnëz wbán chekwlal. ");
INSERT INTO zpi_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Porke re Moises lo yra xpenkwlal be: “Dëdyuzh ylaa ne lad ke de yra de yruu te men ne gak profet ne gak zegnak noo; gon de yrandxee xdiiz men, ");
INSERT INTO zpi_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","porke yrandxee mén ne tsukasdet men, ygabdetre men lad men-Israel no sluzh men.” ");
INSERT INTO zpi_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Yrandxee profet ne wuu chekwlal desde Samuel no axtegue profet ne gyed wuur, che wzëët men yra neree ne kayak naaree. ");
INSERT INTO zpi_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Laa de yra de nak mén ne zëëd xnëz profet guin no por laa de nak yra diiz ne re Dëdyuzh lo yra xpenkwlal be chene re Ne lo Abraham: “Por men ne zëëd xnëz de gaknonen noo yrandxee mén ne nuu gyëzlyu.” ");
INSERT INTO zpi_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Chene wneban Dëdyuzh XPee Ne, primer lo de yra de wxaal Ne XPee Ne chen yneleey Ne de chen ysalzaan de xgyelmal de te te de. ");
INSERT INTO zpi_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Benak kanii Bëd yrup Bëd Xwa lo yra mén, chene wdxiin yra fxuz yra men mén ne rnebééy lo yra men ne rap kwent xeydoo Dëdyuzh no le tebëd men ne nak sadusew. ");
INSERT INTO zpi_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kesentyent rlayaa men porke re Bëd yrup Bëd Xwa lo yra mén ne sban mengut, porke ne wban Jesus nga wrunyoo ne sban mengut. ");
INSERT INTO zpi_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Lex wnëëz men Bëd yrup Bëd Xwa; kom che rzëë, wguu men Bëd chegyiib tebgyëël yrup Bëd Xwa. ");
INSERT INTO zpi_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Per ndal mén ne won yra diiz ne re Bëd yrup Bëd Xwa, wlaleedx men Jesucrist. Yra mén ne wlaleedx Jesucrist nonchee mgyeey, rga men zeg gaaymil. ");
INSERT INTO zpi_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ne wra gyëël, wdop yra mén ne rnebééy lo yra men-Israel lenlgyëz-Jerusalén yra men mengol ne rnebééy no le yra maxter ley. ");
INSERT INTO zpi_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nga zu Anás ne nak fxuz ne mazre nondee, no zu Caifás no le Xwa no le Lej no le yrandxee mgyeey ne nak xfamilye fxuz guin. ");
INSERT INTO zpi_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Orguin wxaal men mén ne waxii Bëd yrup Bëd Xwa, wzu men men gwrooltee lad men yra men, lex wnabdiiz men lo men yrup men, re men: ―¿Txu wnebééy ne rlaa de neree? ¿U txu wkyeen de ne rlaa do? ");
INSERT INTO zpi_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kom kesentyent raknonen Espíritu Sant Bëd, wke Bëd, re Bëd: ―Yra de ne nak de men ne rnebééy gyëz no le yra de ne nak de mengol ne rnebééy lo men-Israel ");
INSERT INTO zpi_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","rnabdiiz lo noo por kwent ne wyaken te mén ne rzhuun; rlaan de gaknan de gan pezee wyaken men. ");
INSERT INTO zpi_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yzëët noo we lo de chen gaknan do no chen gaknan yrandxee men-Israel gan pezee wyaken ménree ne zu lo de yra de: Wyaken men por la Jesucrist zhan-Nazaret; wkaa de zhaa lo kruz, per wneban Dëdyuzh zhaa. ");
INSERT INTO zpi_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Laa Jesusree nga nak ne rlaandet de yra de, wlaa de zhaa zegne rlaa mén ne rlep yuu gye ne axtegue rlaandet men, per orree laa zhaa nak zegnak gye ne mazre rkyiindee. ");
INSERT INTO zpi_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nonchee laa zhaa run gan rselaa be lo dol, porke wxaaldetre Dëdyuzh ni ste mén nee gyëzlyuree ne gun gan yselaa be lo dol. ");
INSERT INTO zpi_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chene wii yra xtis ne rdxedet Bëd rnii Bëd yrup Bëd Xwa no chene wyenen men ne rut nakdet men yrup men, ni nakdet men men ne wseed, wzee wzak men yra men; orguin wdee men kwent ne yra Bëd Jesus wkaa. ");
INSERT INTO zpi_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kom nga ke zu mgyeey guin ne wyaken, por neguin wzëldetre pezee ninyaan men lo Bëd yrup Bëd Xwa. ");
INSERT INTO zpi_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Lex wkyeen xtis wruu Bëd yrup Bëd Xwa ledne ndxin men yra men, le laa men wyan rulsaa men diiz, ");
INSERT INTO zpi_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","re men: ―¿Pezee ylaa be yrup ménree? Yrandxee men-Jerusalén che nan gyelmilaguerree ne wlaa men, gakdet gue be ne nlideto. ");
INSERT INTO zpi_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Per por ne yrëëtsdetre diizree lenlgyëz, logne ylaa be yoo yneche be men, chen desde orree ni ster lo mén yzëëdetre men la Jesus. ");
INSERT INTO zpi_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Lex wbëz xtis Bëd yrup Bëd Xwa ste, re men lo men yrup men ne yzëëdetre men la Jesus, ni yneluudetre men xdiiz Jesus lo mén. ");
INSERT INTO zpi_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wke men yrup men, re men: ―Laake de yra de gugyenen belne wendee ne gon noo xdiiz de lugar ne gon noo xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Porke noo gakdet ysalzaan noo ne yzëët noo yra ne wii noo no le yra ne won noo. ");
INSERT INTO zpi_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Lex wneche xtis Bëd yrup Bëd Xwa ste; wluzh nga wselaa men men yrup men. Wzëldet gan pezee nzakzi men men porke yrandxee mén rzaknon Dëdyuzh por gyelmilaguer guin ne wak. ");
INSERT INTO zpi_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mgyeey guin ne wyaken por gyelmilaguer guin ne wak, mazdee txuplal iz rap men. ");
INSERT INTO zpi_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Chene che wselaa xtis Bëd yrup Bëd Xwa, wa men ledne ndxin yra xkompanyer men, wuu men diiz ne re yra fxuz ne rnebééy lo yra fxuz lo men yrup men no le ne re yra mengol ne rnebééy. ");
INSERT INTO zpi_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chene won yra xkompanyer men yra neree, wzelo men tese wnab men lo Dëdyuzh, re men: ―Dëde, laa de rnebééy, laa de wzhexkwaa gyeybaa gyëzlyutee no le nisdoo no le yrandxee ne nuu lo we. ");
INSERT INTO zpi_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","No por XEspíritu de wnii David ne nak xpén de chene re men: ¿Penak rlayaa mén no penak rlebleedx mén ne bat rkyiindet? ");
INSERT INTO zpi_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wdop yra rrey no yra xtis ne rnebééy te te gyëz tese wak men winyaan men Dëdyuzh yrup Ne XeCrist Ne. ");
INSERT INTO zpi_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’No nli zenga wak, tese wak Herodes yrup men Poncio Pilato nee gyëzree yra men men-Israel no le yra men mén ne nakdet men-Israel, winyaan men Jesus XPee de ne rlaadet dol no ne wye de ne gak Crist. ");
INSERT INTO zpi_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Zenga wlaa men yra ne rap degne gak zegne wlebleedx de axtegue chekwlal. ");
INSERT INTO zpi_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Orrenaa Dëde, gukwii pezee ntoz rlaa men, gugaknonen xpén de chen ydxedet men yzëët men xdiiz de, ");
INSERT INTO zpi_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","no guseleedx xpoder de lo men chen yneseyaken men mengyiz no chen ylaa men gyelmilaguer por la Jesus XPee de ne rlaadet dol. ");
INSERT INTO zpi_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chene wluzh wnab men lo Dëdyuzh, wni ledne ndxin men; no kesentyent waknonen Espíritu Sant men yra men, wdxedet men wzëët men xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yrandxee mén ne rlaleedx Jesucrist, tese wak men, tebegue ne wlebleedx men; ni te men redet ne noze xen men nak yra ne rap men, sinke xen meno yra men. ");
INSERT INTO zpi_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kesentyent rap yra poxter poder wkazëët men ne nli wii men wban Jesucrist, no kesentyent waknonen Dëdyuzh men yra men. ");
INSERT INTO zpi_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ni te mén ne rzak lyaaz yëtet lad men, porke yra men ne rap lyu o ne rap yuu, wtoo meno, wdekwent men yra med ");
INSERT INTO zpi_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","lo poxter, lex laa poxter wgyiizo lo men te te men segun lyaaz ne rzak men. ");
INSERT INTO zpi_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lad men yra men wuu te mgyeey ne la Xeb, men-Chipre nak men; xnëz Leví zëëd men no wnesela ke poxter men Bernabe. (Bernabe rna: Men ne rdee diiz lo mén.) ");
INSERT INTO zpi_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wtoo mgyeey guin tebla lyu ne rap men, lex wdekwent men yra med lo poxter. ");
INSERT INTO zpi_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Per wuu te mgyeey ne la Ananías, le xewnaa men la Safira; wtoo mgyeey guin tebla lyu yrup men xewnaa men. ");
INSERT INTO zpi_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wuu men diiz yrup men xewnaa men wsan men tebla med lo men, tebla ko wdekwent men lo poxter. ");
INSERT INTO zpi_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Lex re Bëd: ―Ananías, ¿penak wdee de si wun Bzelo gan lo de ne rlaan de ykade de Espíritu Sant no wsan de tebla med ne wtoo de lyu lo de? ");
INSERT INTO zpi_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Antes ne ntoo do, ¿pe let xelyudet de nako? Chene che wtoo do, ¿pe let xmedet de nak med? ¿Penak wguu xtoo de wlaa de neree? Let méndet rkade de, sinke Dëdyuzh wlaan de nkade de. ");
INSERT INTO zpi_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Zegne won Ananías diizree, wkantaa men wetgue men. Yrandxee mén ne waknan ne wzak Ananías, kesentyent wdxe men. ");
INSERT INTO zpi_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Orguin wbig tebëd menyu, wtxël men Ananías lër, lex weey men Ananías walugyeer men Ananías. ");
INSERT INTO zpi_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chene wzaa zeg tson or, wdxiin xewnaa Ananías, nandet men pe wak. ");
INSERT INTO zpi_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Wnabdiiz Bëd lo men, re Bëd: ―Guzëët gan ¿pe nli lal nee wtoo de lyu yrup de xemgyeey de? Wke men re men: ―Nli we. ");
INSERT INTO zpi_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Lex re Bëd lo men: ―¿Penak wuu de diiz yrup de xemgyeey de ne rlaan de ykade de Espíritu Sant? Wa zëëd yra men ne walugyeer xemgyeey de; orree gweey ke men de no de. ");
INSERT INTO zpi_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Orke guin wkantaa Safira nes lo Bëd, wetgue Safira. Chene wdee yra menyu guin, wii men le Safira che ke nex wet, lex weey men Safira walugyeer men Safira koo ke xemgyeey Safira. ");
INSERT INTO zpi_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kesentyent wdxe yrandxee mén ne rlaleedx Jesucrist no le yrandxee mén ne waknan neguin ne wak. ");
INSERT INTO zpi_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ndal gyelmilaguer no ndal gyelenzoon wlaa yra poxter nes lo yra mengyëz guin. Yrandxee men ne rlaleedx Jesucrist rdop ledne rnii men xKordor Salomón. ");
INSERT INTO zpi_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kesentyent rlep yra mengyëz guin xeblaan yra mén ne rlaleedx Jesucrist, per ni ste mén wyezhdetgue ndee lad men. ");
INSERT INTO zpi_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Per zhich guin kesentyent zayakndalre mén ne rlaleedx Jesucrist, mgyeey wnaatee, ");
INSERT INTO zpi_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","axtegue wboo mén mengyiz, wgyix men men runëz; nuu men wgyix men lo loon, nuuzeg men wgyix men lo daa, chen chene tee Bëd, tee maske nonchee xeblaa Bëd led men. ");
INSERT INTO zpi_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","No kesentyent ndalyaa mén ne nuu yra gyëz ne nak guex Jerusalén wa Jerusalén wano men mengyiz no le mén ne nuu menzab lextoo, no yrandxee men wyaken. ");
INSERT INTO zpi_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Por neguin kesentyent wakmbidye fxuz ne mazre nondee no le yra mén ne nuu lad men ne nak sadusew ne ndxin lo fxuz nga. ");
INSERT INTO zpi_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wnëëz men poxter, wsee men poxter chegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Per gyëël wa te xangel Dëdyuzh wxal ne chegyiib, wboo ne poxter lenchegyiib, re ne lo poxter: ");
INSERT INTO zpi_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Gutsa lenxeydoo Dëdyuzh yzëët de xkwent gyelembánkweb lo yra mén. ");
INSERT INTO zpi_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ne won poxter zenga, rsilgue wa poxter lenydoo, wzelo poxter wneluu poxter xdiiz Dëdyuzh lo yra mén. Myentras ne kayak yra neguin, le fxuz ne mazre nondee no le stebëd mén ne nuu lad fxuz wtop yrandxee xtis-Israel, mazdee yna noo yrandxee men ne rnebééy lo men-Israel. Lex wxaal men tebëd soldad zaxii poxter lenchegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Per chene wdxiin yra soldad lenchegyiib, wzëldetre poxter; wberee men wluu men diiz, ");
INSERT INTO zpi_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","re men: ―Chene wdxiin noo zhiin yaglachegyiib, chiich ke zemzëë we, le yra soldad zunap ke zhiin yaglachegyiib; per chene wxal noo we, rutre wzëldet. ");
INSERT INTO zpi_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ne won fxuz ne mazre nondee diizree yra men soldad ne rnebééy lo yra soldad ne rapkwent ruxeydoo Dëdyuzh no le yra men fxuz ne rnebééy lo yra fxuz, axtegue nandet men pe wuu lextoo men, rnabdizlsaa men, re men: “¿Pa axtegue kwlo ydxiin yra neree?” ");
INSERT INTO zpi_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Orke guin wdxiin te mgyeey ne re lo men: ―Mén ne wsee de chegyiib, le men nuu lenxeydoo Dëdyuzh rneluu men mén. ");
INSERT INTO zpi_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Orguin za soldad ne rnebééy lo yra soldad, zaxii men poxter yra men xsoldad men; per bet wlaadet men poxter porke wdxe men ngugye mengyëz men. ");
INSERT INTO zpi_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chene wdxinno men poxter, wdxig men poxter nes lo yra xtis-Israel. Lex re fxuz ne mazre nondee lo poxter: ");
INSERT INTO zpi_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Pe let che nadet noo lo de ne ybereedetre de ne yneluu de xdiiz Jesus lo mén? Per orree gukwii nak ne kalaa de, ydendxee Jerusalén katxëëts de diiz gwa no rlaan de ykagyii de noo yra noo ne noo wket Jesus. ");
INSERT INTO zpi_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Wke Bëd yra Bëd stebëd poxter, re Bëd: ―Rap noo degne gon noo xdiiz Dëdyuzh, let xdiizdet mén. ");
INSERT INTO zpi_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Laa Dëdyuzh wneban Jesus ne wket de chene wkaa de Ne lo kruz. ");
INSERT INTO zpi_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dëdyuzh wlanon Jesus, wzoob Ne Jesus koo Ne ladbëë, wlaa Ne Jesus men ne rnebééy no men ne rselaa mén lo dol chen ysaan men-Israel xgyelmal men no chen gun Ne perdon xdol men. ");
INSERT INTO zpi_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Noo yra noo nak ne wii neree no le Espíritu Sant wii we, Espíritu Sant ne rdee Dëdyuzh lo yra mén ne rlaa ne rlaan Ne. ");
INSERT INTO zpi_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chene won men zenga, kesentyent wlayaa men, wlaan men nket men yra poxter. ");
INSERT INTO zpi_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Per lad xtis guin zu te mgyeey ne la Gamaliel ne nak maxter ley no ne nak farisew. Yrandxee mengyëz raknzebnëz lo mgyeey guin; laa men wzuli wkyeen men wruu yra poxter nga tebrrat. ");
INSERT INTO zpi_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Lex re men lo yra xtis: ―Men-Israel, gugap kwent logne ylaa de yra mén gwa. ");
INSERT INTO zpi_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gunileedx ne naandxeree wuu te zhan ne la Teudas, re zhaa laa zhaa nak zhannon, wap zhaa zeg tapgwyuu xpén zhaa. Per chene wket mén zhaa, noze wrëëts yrandxee xpén zhaa; nga ke wluzh yra ne wlaa zhaa. ");
INSERT INTO zpi_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Zhich guin, tyemp ne wdop la yrandxee mén, wuu te zhan ne la Judas ne nak zhan-Galilea, no ndal ke xpén zhaa wap zhaa, per chene wket mén zhaa, nozke wrëëts yrandxee xpén zhaa. ");
INSERT INTO zpi_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Por neguin yna noo lo de, zeka yra mén gwa, guselaa men. Porke yra negwa ne kalaa men, belne noze mén rkyeen men, sluzho. ");
INSERT INTO zpi_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Per belne Dëdyuzh wxaal men ne rlaa meno, gundet de gan ysoow de lo men. Gugap kwent tegue por Dëdyuzh nuu de konter. ");
INSERT INTO zpi_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wukas yra xtis xdiiz Gamaliel. Lex wbëz xtis poxter ste, wdee men xkwent poxter, lex re men lo poxter ne yneluudetre poxter xdiiz Jesus lo mén; zhich guin wselaa ke men poxter. ");
INSERT INTO zpi_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wruu poxter lad xtis nga, kesentyent rzhiilen poxter porke wdee Dëdyuzh si wzakzi mén poxter por ne rlaleedx poxter Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","No rsalzaandet poxter ne rneluu poxter no ne rzëët poxter xdiiz Jesus lo mén, re men ne laa Ne nak Crist. Yrandxee dxe rneluu meno nigle lenxeydoo Dëdyuzh, nigle yuu por yuu. ");
INSERT INTO zpi_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Cheguin ke kom zayakndalre mén ne rlaleedx Jesucrist, wzelo yra mén ne rnii diz-griego re men ne yrandxee dxe ne rgaas ne ru yra wnabyud, zhidoo rkakwent wnabyud ne rnii diz-griego ke lo wnabyud ne rnii diz-hebreo. ");
INSERT INTO zpi_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Lex wtop yra chibtxup poxter yrandxee mén ne rlaleedx Jesucrist, re poxter lo men: ―Ngyidet ne ysalzaan noo ne yzëët noo xdiiz Dëdyuzh por ne ygyiiz noo ne gu mén. ");
INSERT INTO zpi_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Por neguin lad ke de ne no de rlaleedx Jesucrist guye guedx mgyeey ne mbán xnëz no ne nyenii xgyeryen no ne kesentyent raknonen Espíritu Sant, chen laa mén guin ylaa dxiinree. ");
INSERT INTO zpi_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Le noo yra noo ykanab ke lo Dëdyuzh no yzëët ke xdiiz Dëdyuzh lo mén. ");
INSERT INTO zpi_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yrandxee men wyan byen ne gako zenga. Wye men Xteb, mgyeey ne kesentyent rlaleedx Jesucrist no ne raknonen Espíritu Sant, no wye men Blib no le Prócoro no le Nicanor no le Timón no le Parmenas, no le Kwlazh men-Antioquía ne wlaleedx Dëdyuzh chekwlo zegne rlaleedx men-Israel Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Zhich guin wano men yra guedx mgyeey guin lo yra poxter, lex wxob nya poxter xtoo men no wnab poxter lo Dëdyuzh por laa men. ");
INSERT INTO zpi_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Le xdiiz Dëdyuzh zarëëtsre no kesentyent zayakndalre mén ne rlaleedx Jesucrist Jerusalén, axtegue fxuz, ndal fxuz wlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kesentyent waknonen Dëdyuzh Xteb no wdee Ne poder lo Xteb, ndal gyelmilaguer wlaa Xteb no ndal gyelenzoon wlaa Xteb lad mén. ");
INSERT INTO zpi_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lex wzelo tebëd mén ne ra lenydoo ne la Libertados yra men stebëd men-Cirene no le men-Alejandría no le mén ne wruu gyëz ne nak lo lyu ne la Cilicia no le mén ne wruu gyëz ne nak lo lyu ne la Asia, wdildiiz men Xteb. ");
INSERT INTO zpi_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Per wundet men gan lo xdiiz Xteb por gyelenyenii ne rseleedx Espíritu Sant lo Xteb. ");
INSERT INTO zpi_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Lex wgyizh men wka tebëd mén chen gue mén guin ne won men rnii Xteb diznyaan por Moises no le por Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Zenga wun men gan wlayaa yra mengyëz guin no le yra men ne rnebééy no le yra maxter ley, lex wnëëz men Xteb yra men zenga, wano men Xteb lo xtis-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","No wye men stebëd mén ne noze wkade, re mén guin lo xtis: ―Ménree rsalzaandet men ne rnii men dizmal por xeydoo Dëdyuzh no por ley ne wdee Dëdyuzh lo Moises. ");
INSERT INTO zpi_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","No won noo ne re men ne ylitla Jesus ne nak men-Nazaret xeydoo Dëdyuzh no ytsaa Jesus koxtumber ne wsan Moises lo be. ");
INSERT INTO zpi_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Le chene wii yra xtis lo Xteb no le yrandxee mén ne zob nga, axtegue rtsow lo te angel lo Xteb. ");
INSERT INTO zpi_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Lex re fxuz ne mazre nondee lo Xteb: ―¿Pe nli re de zegwa? ");
INSERT INTO zpi_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Wke Xteb, re Xteb: ―Yra de ne nak de xtis no yra de zegne ndxin de nee, gugon ne yna noo lo de. XDëdyuzhnzoon be wlalo lo Abraham xpenkwlal be chene wuu men lo lyu ne la Mesopotamia antes ne gya men tsuu men Harán. ");
INSERT INTO zpi_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Re Ne lo Abraham: “Gusan laz de no gusan yra xparyent de, gugya tsuu de lo lyu ne yluu noo lo de.” ");
INSERT INTO zpi_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Lex wruu Abraham lo xelyu men-Caldea, wa Abraham wuu Abraham Harán. Nga wet xuz Abraham; zhich guin wxaal Dëdyuzh Abraham lo lyuree ledne nuu be yra be naaree. ");
INSERT INTO zpi_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Per chene wlenza Abraham nee, wdeedetgue Dëdyuzh ni teblawin lyuree lo Abraham, per re Ne ne sdee No lo Abraham. Lex chene guet Abraham, gyano lo yra men ne zëëd xnëz Abraham; mase gardet gap Abraham zhiin Abraham tyemp guin. ");
INSERT INTO zpi_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","No re Dëdyuzh lo Abraham ne ste nacion tsuu yra mén ne zëëd xnëz Abraham; menzit gak men nga no le men ne che wdoo, no yzakzi mén men tapgwyuu iz. ");
INSERT INTO zpi_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Per re ke Dëdyuzh lo Abraham: “Noo yzakzi nacion guin ne ylaa yra mén ne zëëd xnëz de zenga. Luzh nga yruu men nga, chiid men saknon men noo lugarree.” ");
INSERT INTO zpi_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","No wyan Dëdyuzh diiz ne nuu ne ydee Ne lo Abraham, per tsuu Abraham te beey. Por neguin chene wzaa xun gbiz ne wal Isaac xpee Abraham, wguu Abraham Isaac beey. Zenga ke wlaa Isaac Jacob xpee Isaac, no zenga ke wlaa Jacob yra chibtxup xpee Jacob, men ne nak xpenkwlal be. ");
INSERT INTO zpi_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Yra zhiin Jacob ne nak xpenkwlal be, wakmbidye men por bech men men ne la Xeb. Lex wtoo men Xeb lo mén ne za Egipto; per waknonen Dëdyuzh Xeb, ");
INSERT INTO zpi_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","wrukaa Xeb lo yra ne wzak Xeb; no wseleedx Ne gyelenyenii lo Xeb no wlaa ne wakwen rrey-Egipto lo Xeb; wzu rrey guin Xeb wnebééy Xeb Egipto no le yrandxee ne nak xen rrey guin. ");
INSERT INTO zpi_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Zhich guin wuu gbiin ydendxee Egipto no le ydendxee Canaán; baanske wlaa yra xpenkwlal be ne waknzoon ne ru men. ");
INSERT INTO zpi_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Per chene waknan Jacob ne nuu zhobxtil Egipto, wxaal Jacob zhiin Jacob mén ne nak xpenkwlal be wa men Egipto tebnii men, waxii men zhobxtil. ");
INSERT INTO zpi_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ne wrupnii men, re Xeb lo men ne bech men nak Xeb; zenga waknan rrey gan txu xnëz zëëd Xeb. ");
INSERT INTO zpi_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Lex wxaal Xeb diiz ne tsa Jacob xuz Xeb tsuu men Egipto yra xfamilyendxee men, tsonlalno-chíín nak men yra men. ");
INSERT INTO zpi_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zenga wa Jacob wuu Jacob Egipto; nga wet Jacob no nga ke wet yra zhiin Jacob ne nak xpenkwlal be. ");
INSERT INTO zpi_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Zhich guin weey mén xpenkwlal be, wgugyeer men men lenbaa ne wka Abraham lo zhiin Hamor gyëz-Siquem. ");
INSERT INTO zpi_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Chene che wyob gak ne re Dëdyuzh lo Abraham, kesentyent wdaal men-Israel Egipto. ");
INSERT INTO zpi_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Cheguin wzelo wnebééy ste rrey Egipto, rnebeeydet men Xeb. ");
INSERT INTO zpi_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wzakzi rrey guin yra xpenkwlal be; wkyeen rrey guin men wasee men yra xpëdbee men ne gyed wal chen guet ne. ");
INSERT INTO zpi_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Cheguin ke wal Moises mëëd ne wtseleedx Dëdyuzh; wapkwent xegwzan ne ne tson mëëw ruxyuu men. ");
INSERT INTO zpi_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Per chene le men wap degne wasee men ne, wzëlen xsaap ke rrey ne, weey xsaap rrey ne, wtxoo men ne zegnak zhiinpee men. ");
INSERT INTO zpi_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Zenga wseed Moises yrandxee xgyelnan men-Egipto, kesentyent wap Moises poder chene rnii Moises nigle por yra ne rlaa Moises. ");
INSERT INTO zpi_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Chene rap Moises txuplal iz, wlen lextoo Moises wa Moises wii lo men-Israel menlaz Moises. ");
INSERT INTO zpi_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ne wii Moises ne le te men-Egipto kadee xkwent te men-Israel, wruu Moises xfabor men-Israel, wket Moises men-Egipto. ");
INSERT INTO zpi_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nuu lextoo Moises ne zenga ndee yra men-Israel kwent ne por Moises yselaa Dëdyuzh men lo men-Egipto, per wdeedet men kwento. ");
INSERT INTO zpi_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wra gyëël guin, wii Moises le txup men-Israel ka kadil, wlaan Moises nsoow lo xdil men, re Moises lo men: “Tese men-Israel nak de. ¿Penak rdilelsaa de?” ");
INSERT INTO zpi_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Orguin wa te mén guin ne kadee xkwent xkompanyer, wtxaap men Moises, re men: “¿Txu wzu de nee ne ynebééy de lo noo no ne ylaa de gyelextis lo noo? ");
INSERT INTO zpi_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Pe nuu lextoo de ne no noo yket de zegne wket de men-Egipto naag?” ");
INSERT INTO zpi_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chene won Moises zenga, wzhoon Moises Egipto, wa Moises wuu Moises lo lyu ne la Madián ledne wak Moises menzit. Nga wap Moises txup mëdbee. ");
INSERT INTO zpi_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Chene wzaa txuplal iz ne nuu Moises nga, wlalo te xangel Dëdyuzh lo Moises lo bël ledne kayeeky gyëtsbne denbidx guex gyey-Sinaí. ");
INSERT INTO zpi_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kesentyent wzee wzak Moises ne wii Moises neguin. Chene wabig guexdee Moises chen kwii Moises wen wenendxee, orguin won Moises xrëz Dëdyuzh, re Ne lo Moises: ");
INSERT INTO zpi_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Noo nak XDëdyuzh Abraham ne nak xpenkwlal de, XDëdyuzh Isaac, XDëdyuzh Jacob.” Orguin wlen wzhiz Moises wdxe Moises, wyezhdetre Moises nwiir Moises nga. ");
INSERT INTO zpi_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Lex re Dëdyuzh lo Moises: “Gukoo xgyël de porke nda ledne zu de. ");
INSERT INTO zpi_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Noo rwii noo pezee baanske rlaa yra xpén noo Egipto, ron noo roon men, neguin wyët noo chen yselaa noo men. Orrenaa gubigdee chen yxaal noo de Egipto.” ");
INSERT INTO zpi_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Laake Moises nga nadet yra men-Israel nyon men xdiiz, lel re men lo Moises: “¿Txu wzu de nee ne ynebééy de no ne ylaa de gyelextis lo noo?” No por te angel ne wlalo lo Moises lo bël ledne kayeeky gyëtsbne, wxaal Dëdyuzh Moises ne ynebééy Moises lo men no ne yselaa Moises men lo men-Egipto. ");
INSERT INTO zpi_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Laa Moises nak ne wboo yra xpenkwlal be Egipto. Laake Moises wlaa gyelmilaguer no le gyelgwzee Egipto no le ledne la lo Nisdoo Nloo no le denbidx ydeblo txuplal iz ne wkano Moises men nga. ");
INSERT INTO zpi_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Laake Moises nga re lo yra men-Israel: “Dëdyuzh ylaa ne lad ke de yra de yruu te men ne gak profet ne gak zegnak noo; gon de xdiiz men.” ");
INSERT INTO zpi_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moiseskeree nga nak ne wkaa yra xpenkwlal be denbidx yrup Moises angel ne wnii lo Moises gyey-Sinaí, no wkakwent Moises xdiiz Dëdyuzh chen yzëët Moiseso lo yra xpenkwlal be, laa diiz guin nak ne wsan Moises lo be yra be. ");
INSERT INTO zpi_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Per nadet yra xpenkwlal be nyon men xdiiz Moises, wukasdet men ne re Moises, sinke lel wlaan men nberee men Egipto ste. ");
INSERT INTO zpi_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Re men lo Aarón: “Guzhexkwaa dëdyuzh ne saner lo be, porke nandet be pe wzak Moises ne wboo be Egipto.” ");
INSERT INTO zpi_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lex wzhexkwaa men te mdoo ne rzaglo mëdyuz, no wket men ndal maa wseleedx men ma lo mdoo guin; wlaa men xelni we tant rzhiilen men ne wzhexkwaa meno. ");
INSERT INTO zpi_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Por neree ne wlaa men, wboleedx Dëdyuzh men, wdee Ne si wzaknon men yra ne ndxiib gyeybaa. Porke zenga zëëd lo xgyiich Ne ne wkaa profet ledne re: Men-Israel, ydeblo txuplal iz ne wuu de denbidx, ¿pe nuu or wket de maa wseleedx de lo noo? ");
INSERT INTO zpi_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Lel wzaknon de xdëdyuzh-Moloc de, zad wkaneey de xguezho, no wzaknon de xestrey xdëdyuzh-Renfán de, bneb ne wzhexkwaa de laake de. Por neguin koo noo de laz de, yxaal noo de mazre nodee ke Babilonia. ");
INSERT INTO zpi_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’No chene wuu yra xpenkwlal be denbidx, wap men guezh ne wlaa men xeydoo Dëdyuzh ledne wgutsoow men gyetabel ne ka ley lo; wzhexkwaa meno zegne wkyeen Dëdyuzh Moises, chene re Dëdyuzh lo Moises ne yzhexkwaa Moiseso zegnak ne che wii Moises. ");
INSERT INTO zpi_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Laa zhiin xpenkwlal be wyanno ydoo guin, lex wlenzaneey meno nee chene wlenza men yra men Josué, chene wladil men lyuree yra men mén ne nakdet men-Israel, men ne wboo Dëdyuzh nes lo men yra men; zenga wzob ydoo guin axtegue ne wdxiin dxe ne wnebééy rrey-David. ");
INSERT INTO zpi_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wtseleedx Dëdyuzh ne rlaa rrey-David, lex wnab rrey-David lo Dëdyuzh ne ydee Dëdyuzh si ylep rrey-David xeydoo Dëdyuzh por ne nak Ne XDëdyuzh Jacob. ");
INSERT INTO zpi_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per laa rrey-Salomón nak ne wlep xeydoo Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","mase nuudet Dëdyuzh lenydoo ne rzhexkwaa mén, zegne re profet chene re men: ");
INSERT INTO zpi_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Re Dëdyuzh: Gyeybaa zob noo rnebééy noo, gyëzlyu zu nii noo. ¿Pezee nak yuu ne ylep de por noo? ¿Pezee nak ledne yne noo? ");
INSERT INTO zpi_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Pe let noodet ke wzhexkwaa we yra we? ");
INSERT INTO zpi_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Per laa de yra de ―re Xteb― kesentyent ndíp xdiiz de, kesentyent ndíp lextoo de, nadet de gon de xdiiz Dëdyuzh, syemper nuu de konter por Espíritu Sant, nak ke de zegnak yra xpenkwlal de. ");
INSERT INTO zpi_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Winyaan xpenkwlal de yrandxee xprofet Dëdyuzh. Axtegue wket men yra profet ne wzëët ne chiid Crist; naaree naa ne le Ne wdxiid, wdekwent de Ne chen yket mén Ne. ");
INSERT INTO zpi_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mase wkakwent de ley lo xangel Dëdyuzh, per rlaadet de zegne zëëd lo we. ");
INSERT INTO zpi_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chene won men yra diizree ne re Xteb, wlayaa wladuxtee men axtegue ruleey men rwii men lo Xteb. ");
INSERT INTO zpi_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Per kom kesentyent raknonen Espíritu Sant Xteb, wkalo Xteb gyeybaa, wii Xteb xgyelenzoon Dëdyuzh no wii Xteb zu Jesus koo Dëdyuzh ladbëë. ");
INSERT INTO zpi_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Lex re Xteb: ―¡Gukwii! Rwii noo zemyal gyeybaa no rwii noo Men ne wdxiid wak Mén zu men koo Dëdyuzh ladbëë. ");
INSERT INTO zpi_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Per zegne won men zenga, wtsëë men gyedyag men yra men, wobtsadii men, ryob rdxiintee wbig men wnëëz men Xteb. ");
INSERT INTO zpi_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Wboo men Xteb lenlgyëz guin, lex wzelo men wgugye men Xteb. Laa te menyu ne la Saulo wapkwent xab yra men guin ne wlaa Xteb zenga. ");
INSERT INTO zpi_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Or ne le men kagugye Xteb, wnab Xteb lo Jesucrist, re Xteb: ―Jesucrist, gukakwent xespíritu noo. ");
INSERT INTO zpi_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Lex wzuzhib Xteb wnii Xteb fwert, re Xteb: ―Dëde, gundet de kwent dolree ne kalaa ménree. Nonchee wluzh re Xteb zenga, wetgue Xteb. ");
INSERT INTO zpi_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","No Saulo wyan byen ne yket men Xteb. Dxe ke guin wzelo mén winyaan men yra men-Jerusalén ne rlaleedx Jesucrist, wkanal men men. Por neguin noze wrëëts men ydendxee lo lyu ne la Judea no le lyu ne la Samaria, nonchee yra poxter wyan Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Laa tebëd mgyeey ne za xnëz Dëdyuzh wgugyeer Xteb, kesentyent woon men ne wet Xteb. ");
INSERT INTO zpi_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Le Saulo wzelo wkanal yra mén ne rlaleedx Jesucrist; wdee Saulo yuu por yuu, wgobzengye Saulo mgyeey wnaatee, wasee Saulo men chegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yra men ne noze wrëëts nesree nesrotee, rzëët men xdiiz Jesucrist lo mén kwaskyertee ledne ra men. ");
INSERT INTO zpi_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Laa Blib wa gyëz ne nak lo lyu ne la Samaria, lex wzelo Blib wzëët Blib xdiiz Jesucrist nga. ");
INSERT INTO zpi_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ndalyaa mén wdop wkagyedyag ne rzëët Blib no rwii men yra gyelmilaguer ne rlaa Blib ");
INSERT INTO zpi_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ne rneseyaken Blib ndal mén ne nuu menzab lextoo; noze robtsaa menzab rruu men lextoo mén, no ndal ke men ne noze waknet led no le mennguzh wyaken. ");
INSERT INTO zpi_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Por neguin kesentyent wzhiilen yra mengyëz guin. ");
INSERT INTO zpi_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Per nga wuu te mgyeey ne la Simon ne che wakxche rlaa gyelebruj, rkade men men-Samaria, rlaa men zegne rlaa mén ne kesentyent non. ");
INSERT INTO zpi_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Yrandxee mén rkagyedyag ne rzëët men, nigle men ne zhi non, nigle men ne non, lex re men yra men: ―Ménree si rap xpoder Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Rukas mén men, porke che wakxche ka men kakade men mén por gyelebruj ne rlaa men. ");
INSERT INTO zpi_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Per chene le mén wlaleedx dizwen ne rkyeen Dëdyuzh ne wzëët Blib no le gan txu nak Jesucrist, mgyeey wnaatee wrobnis. ");
INSERT INTO zpi_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Axtegue no Simon wlaleedxo, wrobnis Simon, lex wzelo Simon wkanal Simon Blib, rzee rzak Simon por yra gyelmilaguer no le gyelenzoon ne rwii Simon rlaa Blib. ");
INSERT INTO zpi_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chene waknan yra poxter ne ka Jerusalén ne le men-Samaria che rlaleedx xdiiz Dëdyuzh, wxaal poxter Bëd no le Xwa ne nak ke poxter, za men Samaria. ");
INSERT INTO zpi_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ne wdxiin men nga yrup men, wnab men lo Dëdyuzh por yra men-Samaria ne che rlaleedx Jesucrist, chen gaknonen Espíritu Sant yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porke gardet gaknonen Espíritu Sant men ni te men; noze wrobnis men por la Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Lex wxob nya Bëd yrup Bëd Xwa xtoo yra mén guin ne le Espíritu Sant waknonen men. ");
INSERT INTO zpi_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ne wii Simon ne raknonen Espíritu Sant yra mén guin ne rxob nya poxter xtoo men, re Simon lo poxter: ");
INSERT INTO zpi_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","―¿Palal rlaan de por poder gwa? Gutoo we yka noo, chen chene yxob nya noo xtoo kwaskyertee mén, gaknonen ke Espíritu Sant men. ");
INSERT INTO zpi_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lex wke Bëd, re Bëd lo men: ―Snitlo de yra de xmed de, porke rlebleedx de ne zun de gan yka de poder ne rseleedx Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yët neguin ne gap de poderree, ni ryaldet de ylaa do, porke nan Dëdyuzh ne ngyidet ne rlebleedx de. ");
INSERT INTO zpi_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Gusaan xgyelmal de, gunab lo Dëdyuzh gan pe gundet Ne perdon negwa ne rlebleedx de. ");
INSERT INTO zpi_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porke rwii noo ne teblose gyelenyaan nuu lextoo de no ne ne mal rnebééy lo de. ");
INSERT INTO zpi_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Lex wke Simon, re Simon: ―Gunab lo Dëdyuzh por noo, chen sakdet noo negwa ne na de. ");
INSERT INTO zpi_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Chene wluzh wzëët Bëd yrup Bëd Xwa yra ne wlaa Jesucrist no ne wzëët men xdiiz Ne lo yra mén guin, wberee ke men Jerusalén; ne wberee men, wdee men ndal gyëz ne nak lo lyu ne la Samaria, wzëët men xdiznzoon Ne. ");
INSERT INTO zpi_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Wluzh nga re te xangel Dëdyuzh lo Blib: ―Guruu Jerusalén, gutsa nes sur, nëz ne rdee denbidx axtegue ne rdxiino gyëz-Gaza. ");
INSERT INTO zpi_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Lex wruu Blib za Blib; nëz wga te mgyey-Etiopía lo Blib. Te mennon nak men, porke laa men nak tesorer lo Candace wnaa ne rnebééy ydendxee Etiopía. Che wak mgyeey guin operar chen tsuudet zhiin men. Jerusalén wa men wazaknon men Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Chene wberee men ne sya men laz men, zob men lenxkarret men kayool men lo liber ne wkaa profet-Isaías. ");
INSERT INTO zpi_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Lex re Espíritu Sant lo Blib: ―Gubig guex lo karret gwa. ");
INSERT INTO zpi_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Chene wbig guex Blib, won Blib kayool mgyeey guin lo liber ne wkaa profet-Isaías, lex wnabdiiz Blib lo men, re Blib: ―¿Pe rdee de kwent negwa ne kayool de? ");
INSERT INTO zpi_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wke men re men: ―¿Pezee ydee noo kwento si rut rzëëdet gan pe rna we lo noo? Lex re men lo Blib ne gyeep Blib lo karret, sob Blib koo men. ");
INSERT INTO zpi_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Zeree re lo xgyiich Dëdyuzh ledne kayool men: Wano mén men chen yket mén men zegne rket mén mëkzhiil, no bet redet men, wlaa men zegne rlaa mëkzhiil bëën bëënleg ne che zu lo mén ne ygaa gyits led maa. ");
INSERT INTO zpi_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wlaa yra mén men logne wlaantee mén, rut wruudet xfabor men; naaree naa ne wket mén men, ¿txu gun gan yzëët yra ne mal ne wlaa mén ne nzëël men? ");
INSERT INTO zpi_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Lex re mgyeey guin lo Blib: ―Gulaa fabor guzëët gan txu por laa rnii profet nee: ¿pe por laake zhaa ne, u por ste mén ne? ");
INSERT INTO zpi_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Lex wzelo Blib wzëët Blib gan pe rna xdiiz Dëdyuzh ledne kayool men, zenga wzëët Blib xdiznzoon Jesucrist lo men. ");
INSERT INTO zpi_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Zhich guin chene wdxiin men yrup men Blib te ledne nuu nis, re men lo Blib: ―Nee nuu nis; ¿pe gakdet yrobnis noo? ");
INSERT INTO zpi_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Wke Blib, re Blib: ―Belne rlaleedx de neree ydebgyiky ydeblextootee de, zako. Wke men re men: ―Rlaleedx noo ne XPee Dëdyuzh nak Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Orguin wkyeen men wnesutsë mén karret, lex wyët men lo karret yrup men Blib, wdee men lo nis wtxobnis Blib men. ");
INSERT INTO zpi_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Chene wruu men lo nis yrup men Blib, weey Espíritu Sant Blib, wiidetre men Blib; per kesentyent rzhiilen men wyuli men nëz ste. ");
INSERT INTO zpi_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tebegue wyenen Blib le Blib che zu gyëz-Azoto, wdee Blib gyëz por gyëz wzëët Blib xdiznzoon Jesucrist, axtegue ne wdxiin Blib Cesarea. ");
INSERT INTO zpi_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Rsalzaandet Saulo ne rneche Saulo yra mén ne rlaleedx Jesucrist, nan Saulo lo men ne yket Saulo men. Por neguin wa Saulo lo fxuz ne mazre nondee, ");
INSERT INTO zpi_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","chen yzhexkwaa men te gyiich gweey Saulo chen gak tsa Saulo yra lenydoo ne zob Damasco, tsaye Saulo yra mén ne rlaleedx Jesucrist, mgyeey wnaatee sano Saulo guu Saulo chegyiib Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Per chene che guex ydxiin Saulo Damasco, tebegue wruu te bnii gyeybaa, kesentyent wkabtsa we kbii ledne za Saulo. ");
INSERT INTO zpi_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Orguin wkantaa Saulo lyu, lex won Saulo te rëz ne re: ―Saulo, Saulo, ¿penak rwinyaan de noo? ");
INSERT INTO zpi_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Orguin wnabdiiz Saulo, re Saulo: ―¿Txu laa de Dechey? Wke rëz guin, re we: ―Noo nak Jesus ne rlaandet de kwii de. Laake de rzakzi de zegne rlaa yuz ne rkanii xtoo yag ne rbib mén led maa. ");
INSERT INTO zpi_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Noze rzhiz Saulo rdxe Saulo, re Saulo: ―Dechey, ¿pagox rlaan de ylaa noo? Orguin re Jesus: ―Gutsaxee, gutee lenlgyëz-Damasco. Nga yna mén logne ylaa de. ");
INSERT INTO zpi_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yra mén ne zano Saulo kesentyent wdxe men, porke won men rëz guin per rut wiidet men. ");
INSERT INTO zpi_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Orguin waxee Saulo, per chene wzuul lo Saulo, wakdetre nwii Saulo. Lex wgoob men nya Saulo wdxinno men Saulo Damasco. ");
INSERT INTO zpi_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nga wkaa Saulo tson gbiz wiidet Saulo, ni bet wudet Saulo, ni bet woodet Saulo. ");
INSERT INTO zpi_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco wuu te mgyeey ne la Ananías ne rlaleedx Jesucrist; wlalo Jesucrist lo mgyeey guin, re Ne: ―¡Ananías! Wke Ananías, re Ananías: ―Le noo zu nee Dëde. ");
INSERT INTO zpi_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Lex re Jesucrist lo Ananías: ―Gusuli, gutsa nëzyu ne la Tebli; ne ydxiin de ruxyuu Judas, ynabdiiz de te mén ne la Saulo ne nak men-Tarso, porke le men kanab lo noo. ");
INSERT INTO zpi_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Wzak men zegnak men ne rnexgyëëlen, wii men wdee te mén ne la Ananías wxob nya led men chen gak kwii men ste. ");
INSERT INTO zpi_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Wke Ananías, re Ananías: ―Dëde, ndalyaa mén che na lo noo yra ne rlaa mén gwa no yra ne mal ne rlaa men men-Jerusalén ne rlaleedx de. ");
INSERT INTO zpi_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Orrenaa le men zëëd nee kon xpermis yra fxuz ne rnebééy lo yra fxuz chen ynëëz men yra xpén de, sano men men ysee men men chegyiib Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Orguin re Jesucrist: ―Gutsa porke che wye noo men ne laa men tsazëët xdiiz noo lo yra mén ne nakdet men-Israel no le lo yra rrey no le lo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Noo ylaa ne gyenen men ne rap men degne kesentyent gak men sufrir por ne rzëët men xdiiz noo. ");
INSERT INTO zpi_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Lex za Ananías ledne ka Saulo, wdxiin Ananías wdee Ananías lenyuu, wxob nya Ananías led Saulo, re Ananías: ―Saulo, Jesucrist ne wlalo lo de ne zëëd de nëz, laa Ne wxaal noo chen gak kwii de ste no chen gaknonen Espíritu Sant de. ");
INSERT INTO zpi_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Orgueguin wruu zegnak xmed mël bzalo Saulo, wyeniigoo. Lex wzuli Saulo, wrobnis Saulo. ");
INSERT INTO zpi_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wluzh nga wu Saulo, lex wuu Saulo fwers ste. Wkaa Saulo stxup stson gbiz yra Saulo men-Damasco ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Lex wzelo Saulo wzëët Saulo xkwent Jesucrist yra lenydoo ne zob Damasco, re Saulo ne XPee Dëdyuzh nak Ne. ");
INSERT INTO zpi_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yra mén ne won ne re Saulo, wzee wzak men, re men: ―¿Pe let laadet ménree nga nak ne rwinyaan yra xpén Jesucrist gyëz-Jerusalén? No ¿pe let laadet ke men nga wlenza nee chen ynëëz men yra mén ne rlaleedx Jesucrist, chen ydekwent men men lo yra fxuz ne rnebééy lo yra fxuz? ");
INSERT INTO zpi_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Per lel mazre wka Saulo fwers rzëët Saulo ne Jesus nak Crist; ne won yra men-Israel ne nuu Damasco ne rzëët Saulo zenga, ni nandet men pe wuu lextoo men. ");
INSERT INTO zpi_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Xchendxegue wkaa Saulo zenga; zhich guin wyan yra men-Israel diiz ne yket men Saulo. ");
INSERT INTO zpi_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dxe gyëëltee rakanap men ledne ka yaglaa rulgyëz chen yket men Saulo; per waknangue Saulo we. ");
INSERT INTO zpi_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lex gyëël wguu yra mén ne rlaleedx Jesucrist Saulo leen te tsegwed nzhoo, wlit men Saulo nes rufchin ne nzëë kbii gyëz. ");
INSERT INTO zpi_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Chene wdxiin Saulo Jerusalén, wlaan Saulo ndee Saulo lad yra mén ne rlaleedx Jesucrist. Per rdxe men Saulo porke rlaleedxdet men ne no Saulo che rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Por neguin wa Bernabe wano Bernabe Saulo lo yra poxter. Lex wzëët Bernabe pezee wlalo Jesucrist lo Saulo no pezee wnii Ne lo Saulo chene za Saulo Damasco no ne wdxedet Saulo wzëët Saulo xdiiz Ne Damasco. ");
INSERT INTO zpi_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Zenga wak ne le Saulo wkaa Jerusalén yra Saulo poxter no axtegue rdxedet Saulo rzëët Saulo xdiiz Ne. ");
INSERT INTO zpi_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Zegne zayuu Saulo diiz yra Saulo men-Israel ne rnii diz-griego, zenga ke zadildiiz Saulo yra Saulo men, lex wlaan men nket men Saulo. ");
INSERT INTO zpi_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chene waknan yra mén ne rlaleedx Jesucrist neguin ne rlaan men ylaa men, wano men Saulo Cesarea; nga wxaal men Saulo za Saulo Tarso. ");
INSERT INTO zpi_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Axtegue cheguin le yra mén ne rlaleedx Jesucrist wbinxnëz, men-Judea no le men-Galilea no le men-Samaria. No mazre mazre zadee men kwent xdiiz Dëdyuzh, no rlaa men ne rlaan Ne, no por ne raknonen Espíritu Sant men, le men zadaalre. ");
INSERT INTO zpi_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Chene wa Bëd wii lo yra mén ne rlaleedx Jesucrist ydendxee nes guin, wa ke Bëd wii no lo yra men-Lida ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nga wdxiin Bëd ledne nex te mgyeey ne rzhuun ne la Eneas. Che wzaa xun iz noze waknet led men. ");
INSERT INTO zpi_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Lex re Bëd lo men: ―Eneas, Jesucrist che wneseyaken de; gutsaxee, gulaxnëz lo xloon de. Orgueguin waxee Eneas. ");
INSERT INTO zpi_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Chene wii yrandxee mén ne nuu Lida no le mén ne nuu lo lyu ne la Sarón ne che wyaken Eneas, no men wlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Cheguin ke nuu te wnaa ne rlaleedx Jesucrist gyëz-Jope, Tabita la men (diz-griego rna we Dorcas). Teblose ne wen rlaa wnaaree no kesentyent run men xyudar mén ne rzak lyaaz. ");
INSERT INTO zpi_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Cheguin ke wlen wzhuun men axtegue wet men. Chene wluzh wgaz mén men, wgyix men men lenyuu pisgya. ");
INSERT INTO zpi_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kom guex Jope nak Lida, zegne waknan yra mén ne rlaleedx Jesucrist ne Lida ka Bëd, wxaal men txup mgyeey wa men wnab men lo Bëd, re men: ―Gulaa fabor yoo tsa be Jope orgueree. ");
INSERT INTO zpi_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Orguin za Bëd yra Bëd men. Chene wdxiin Bëd Jope, wano men Bëd lenyuu ledne nex mengut guin. Orguin wbig yra wnabyud lo Bëd roon men, wluu men yra lër ne wgyib Dorcas chene benak mbán Dorcas. ");
INSERT INTO zpi_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Lex wkyeen Bëd wruu yra mén lenyuu; zhich guin wzuzhib Bëd wnab Bëd lo Dëdyuzh; wii Bëd lo mengut guin, lex re Bëd: ―Tabita, gutsaxee. Orgueguin wzuul lo men; zegne wii men lo Bëd, wzobligue men. ");
INSERT INTO zpi_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Orguin wnëëz Bëd nya men wnesuli Bëd men; lex wbëz Bëd yra mén ne rlaleedx Jesucrist no le yra wnabyud guin chen kwii men ne wban Dorcas. ");
INSERT INTO zpi_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ydendxee gyëz-Jope waknan méno; por neguin kesentyent ndal mén wlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ndal gbiz wkaa Bëd gyëz guin ruxyuu te mén ne la Simon ne rkuudx gyed. ");
INSERT INTO zpi_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Wuu te mgyeey ne la Cornel gyëz-Cesarea, laa men wak kapitan lo tebëd soldad ne la Italiano. ");
INSERT INTO zpi_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Te mgyeey ne za xnëz Dëdyuzh wak Cornel, wzaknon Cornel Dëdyuzh yra Cornel xfamilye Cornel no kesentyent wun Cornel xyudar yra men-Israel ne rzak lyaaz no yzaandxee dxe rnab Cornel lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Te dxe zeg beytson wzëë wzak Cornel zegnak men ne wnexgyëëlen; nya wii Cornel wdee te xangel Dëdyuzh lenyuu ledne zu Cornel, re angel guin lo Cornel: ―¡Cornel! ");
INSERT INTO zpi_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Orguin wii wiindxee Cornel lo angel, noze lo gyelerdxeeb re Cornel: ―¿Pagox rlaan de Dechey? Lex re angel guin: ―Le Dëdyuzh che won yra ne rnab de no rwii Ne yra ne rlaa de ne run de xyudar yra mén ne rzak lyaaz. ");
INSERT INTO zpi_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Guxaal mén tsa men Jope tsaxii men Simon ne la ke Bëd; ");
INSERT INTO zpi_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","le zhaa ka xyuu te zhan ne la ke Simon ne rkuudx gyed no ne zob xyuu guex runisdoo. Laa Simon ne la ke Bëd yna gan kox ylaa de. ");
INSERT INTO zpi_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Chene che sya angel ne wnii lo Cornel, wbëz Cornel txup mén ne rlaa dxiin lo Cornel no le te soldad ne rlaleedx Dëdyuzh no ne rap Cornel konfyans. ");
INSERT INTO zpi_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Wluzhse wuu Cornel yra diiz ne re angel lo Cornel, lex wxaal Cornel men za men Jope. ");
INSERT INTO zpi_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wra gyëël ne za men nëz ne che guex ydxiin men, zeg rwen ngbiz wyeep Bëd xtoo yuu wnab Bëd lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kesentyent wlaanen Bëd, rlaan Bëd gu Bëd; per myentras ne kazhexkwaa mén ne gu Bëd, wzak Bëd zegnak men ne rnexgyëëlen. ");
INSERT INTO zpi_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Wii Bëd wyal gyeybaa no wii Bëd zëdtseeb zegnak tebla lërnzhen nliib ydap skino, wdxiino axtegue lo Bëd. ");
INSERT INTO zpi_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lo lër guin nuu yralondxee maa, maa ne zob tap nii, maa ne rdoob lyu, no le maa ne rzhobee. ");
INSERT INTO zpi_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Lex won Bëd te rëz ne re: ―Bëd, gusuli, guket maa gu de. ");
INSERT INTO zpi_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Wke Bëd, re Bëd: ―Yketet noo ma Dechey, porke nunk gardet gu noo maa ne mbixleedx no ne nzaz. ");
INSERT INTO zpi_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Re rëz guin ste: ―Logne che wlanya Dëdyuzh, yneseladet do ne mbixleedx. ");
INSERT INTO zpi_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tson tir wlalo neguin lo Bëd, lex wberee we wyeep ko gyeybaa ste. ");
INSERT INTO zpi_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Myentras ne kalebleedx Bëd gan pe rna neguin, orke guin wdxiin yra mén ne wxaal Cornel ruxyuu Simon ledne ka Bëd; che noze zad wkanabdiiz men gan pazh zobo. ");
INSERT INTO zpi_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ne wdxiin men, ndípse wnabdiiz men gan pe nga ka te mén ne la Simon ne la ke Bëd. ");
INSERT INTO zpi_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Benak kalebleedx Bëd gan pe rna neguin ne wii Bëd, orguin re Espíritu Sant lo Bëd: ―Gukwii, tson mén ka kaye de. ");
INSERT INTO zpi_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gusuli, gugyët, gutsanal men; tsutxupdet lextoo de porke noo wxaal men. ");
INSERT INTO zpi_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Orguin wyët Bëd re Bëd lo gyon mén guin: ―Noo nak men ne kaye de. ¿Pe dxiinzhe zëëd de? ");
INSERT INTO zpi_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wke men re men: ―Laa kapitan ne la Cornel wxaal noo; te mén ne xnëz rlaa no ne rzaknon Dëdyuzh nak Cornel; yrandxee men-Israel raknzebnëz lo Cornel. Laa te xangel Dëdyuzh re lo Cornel ne yxaal Cornel noo chidtxii noo de, chen tsa de ruxyuu Cornel, gon Cornel ne gue de lo Cornel. ");
INSERT INTO zpi_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Lex wdee Bëd gyon mén guin lenyuu, nga wzëën men yra men Bëd gyëël guin. Ne wyenii lyu za Bëd yra Bëd men no le tebëd men-Jope ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wra gyëël guin, wdxiin men yra men Bëd Cesarea ledne nuu Cornel. Nga kambë́z Cornel men yra Cornel tebëd mén ne nak xparyent Cornel no le yra xmig Cornel ne wtop Cornel. ");
INSERT INTO zpi_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Chene wdxiin Bëd xyuu Cornel, wruu Cornel wtsëlo Cornel Bëd; wzuzhib Cornel lo Bëd wlaan Cornel nzaknon Cornel Bëd. ");
INSERT INTO zpi_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Per wnesuli Bëd Cornel, re Bëd: ―Gusuli, porke noze mén nak noo zegnak ke de. ");
INSERT INTO zpi_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Myentras ne zayuu Bëd diiz yrup Bëd Cornel, wdee Bëd lenyuu, wii Bëd kesentyent ndal mén ndxin. ");
INSERT INTO zpi_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Lex re Bëd lo men: ―Laa de yra de che nan de pezee nak xley men-Israel, ne nuudet ytsëlsaa men mén ne nakdet men-Israel o ne tee men lenxyuu men. Per che wlaa Dëdyuzh ne wyenen noo ne yneseladet noo ni te mén men mbixleedx o men nzaz. ");
INSERT INTO zpi_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Por neguin zegne wxaal Cornel men ne wa wbëz noo, zëëdgue noo, wzuwëëdet noo. Orrenaa ynabdiiz noo gan pe kwentzhe wbëz Cornel noo. ");
INSERT INTO zpi_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Wke Cornel, re Cornel: ―Che wzaa tap gbiz zeg ornaa ke zu noo nee ruxyuu noo, wkwan noo wudet noo, kanab noo lo Dëdyuzh beytson wzëë, tebegue wlalo te mén ne nak lërrkabnii lo noo. ");
INSERT INTO zpi_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Na men lo noo: “Cornel, le Dëdyuzh che won yra ne rnab de no kanzaleedx Ne yra ne rlaa de ne run de xyudar yra mén ne rzak lyaaz. ");
INSERT INTO zpi_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Por neguin guxaal mén tsa men Jope tsaxii men Simon ne la ke Bëd; le zhaa ka xyuu te zhan ne la ke Simon ne rkuudx gyed no ne zob xyuu guex runisdoo. Laa Simon ne la ke Bëd yna gan kox ylaa de.” ");
INSERT INTO zpi_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Por neguin wxaalgue noo mén waxii men de. Wen wlaa de ne zëëd de. Orrenaa rwii Dëdyuzh zu noo nee yra noo, chen gon noo yrandxee ne wxaal Dëdyuzh de yzëët de lo noo. ");
INSERT INTO zpi_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Lex wzelo Bëd wnii Bëd, re Bëd: ―Orree si waknanwen noo ne rbedet Dëdyuzh mén, ");
INSERT INTO zpi_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","sinke kwaskyertee mengyëzlyu ne rlaa ne rlaan Dëdyuzh no ne mbán xnëz, rukas Ne men. ");
INSERT INTO zpi_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dëdyuzh wnii lo yra men-Israel, re Ne ne por Jesucrist gakndxi mén; laa Jesucrist rnebééy lo yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Laa de yra de nanwen de logne wkayakzëët ydendxee Judea, Galilea nak ne wzelo we chene che wdesuse ne wzëët Xwa lo yra mén ne rap men degne yrobnis men. ");
INSERT INTO zpi_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","No nanwen de ne laa Dëdyuzh wdee Espíritu Sant no wdee poder lo Jesus men-Nazaret, no nanwen de ne wkalaa Jesus ne wen, wneseyaken Ne yra mén ne rak sufrir por Bzelo. Wun Ne gan wlaa No porke laa Dëdyuzh raknonen Ne. ");
INSERT INTO zpi_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Noo yra noo nak ne wii yra ne wlaa Jesus ydendxee Judea no le Jerusalén. Wluzh nga wkaa mén Ne lo kruz, wket mén Ne. ");
INSERT INTO zpi_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Per wneban ke Dëdyuzh Ne dxe ne wzaa tson gbiz no wlaa Dëdyuzh ne wlalo Ne lo noo yra noo. ");
INSERT INTO zpi_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wlalodet Ne lo yrandxee mén sinke nonchee lo noo yra noo ne nak noo men ne wye Dëdyuzh axtegue antes, chen kwii noo yra ne ylaa Ne. Noo yra noo wu noo, woo noo yra noo Ne chene che wban Ne. ");
INSERT INTO zpi_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Zhich guin wxaal Ne noo chen yzëët noo lo mén ne laa Dëdyuzh wzu Ne ne ylaa Ne gyelextis lo menmbán menguttee. ");
INSERT INTO zpi_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","No yrandxee profet ne wuu chekwlal wzëët xkwent Jesus, re men ne yrandxee mén ne ylaleedx Ne zak perdon xdol men. ");
INSERT INTO zpi_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Benak kanii Bëd, chene wyët Espíritu Sant waknonen Ne yra mén ne kayon ne rzëët Bëd. ");
INSERT INTO zpi_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yra men-Israel ne rlaleedx Jesucrist no ne wanal Bëd, kesentyent wzee wzak men ne no mén ne nakdet men-Israel waknonen Espíritu Sant. ");
INSERT INTO zpi_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Porke ron men rnii yra mén guin ne nakdet men-Israel ste klas diiz no ne rzaknon men Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Orguin re Bëd lo men: ―¿Txuzh gun gan ysoow ne yrobnis yra ménree ne raknonen Espíritu Sant zegne raknonen ke Espíritu Sant be? ");
INSERT INTO zpi_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Lex wkyeen Bëd wrobnis yra mén guin por la Jesucrist. Wluzh nga wnab men lo Bëd ne ykaales Bëd nga txup tson gbiz yra Bëd men. ");
INSERT INTO zpi_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Won yra poxter diiz no le yra men-Judea ne rlaleedx Jesucrist, ne no mén ne nakdet men-Israel che rlaleedx xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Le chene wberee Bëd Jerusalén, wzelo yra men-Israel ne rlaleedx Jesucrist no ne benak rlaa zegne zëëd lo ley wakndux men lo Bëd, ");
INSERT INTO zpi_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","re men: ―¿Penak watee de lenxyuu mén ne nakdet men-Israel no penak wu de yra de men? ");
INSERT INTO zpi_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Orguin wzelo Bëd wuu Bëd diiz yra ne wak, re Bëd lo men: ");
INSERT INTO zpi_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Chene ka noo Jope, or ne kanab noo lo Dëdyuzh, wzak noo zegnak men ne rnexgyëëlen, wii noo zëdtseeb zegnak tebla lërnzhen nliib ydap skino, wruu we gyeybaa wlenza we axtegue lo noo. ");
INSERT INTO zpi_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Chene wii wiindxee noo gan kox nuu leeno, wii noo nuu maa ne zob tap nii, maa ne ndux, maa ne rdoob lyu, no le maa ne rzhobee. ");
INSERT INTO zpi_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","No won noo te rëz ne na lo noo: “Bëd, gusuli, guket maa gu de.” ");
INSERT INTO zpi_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Wke noo, re noo: “Yketet noo ma Dechey, porke nunk gardet gu noo maa ne mbixleedx no ne nzaz.” ");
INSERT INTO zpi_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lex wlen rëz gyeybaa ste, na we lo noo: “Logne che wlanya Dëdyuzh, yneseladet do ne mbixleedx.” ");
INSERT INTO zpi_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tson tir wlalo lër guin lo noo, lex wberee we wyeep ko gyeybaa ste yra we ne ka lo we. ");
INSERT INTO zpi_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Orke guin wdxiin tson mgyeey ruyuu ledne wbë́z noo, axtegue Cesarea wruu men waye men noo. ");
INSERT INTO zpi_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Na Espíritu Sant lo noo ne tsanal noo men, tsutxupdet lextoo noo, no wzanal ke xuup ménree noo, yra noo zenga wa ruxyuu te mén. ");
INSERT INTO zpi_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Lex wuu men diiz lo noo gan pezee wlalo te angel lo men ne zu men lenxyuu men, re angel guin lo men: “Guxaal mén tsa men Jope tsaxii men Simon ne la ke Bëd; ");
INSERT INTO zpi_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","laa zhaa yzëët gan pezee yláá de lo dol yra de mén ne nuu xyuu de.” ");
INSERT INTO zpi_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Chene wzelo noo wnii noo lo men, wyët Espíritu Sant waknonen Ne men yra men zegne waknonen ke Ne be chene primerendxee. ");
INSERT INTO zpi_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Orguin wnileedx noo diiz ne re Jesucrist chene re Ne: “Nli ne kon nis wtxobnis Xwa mén, per le laa de yra de kon Espíritu Sant yrobnis de.” ");
INSERT INTO zpi_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","No belne laa Dëdyuzh wseleedx lo men logne wseleedx ke Dëdyuzh lo be yra be ne rlaleedx be Jesucrist, ¿txu nak noo ne ysoow noo lo Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chene won mén guin zenga, betre redet men, wzelo men wzaknon men Dëdyuzh, re men: ―No ke lo yra mén ne nakdet men-Israel wseleedx Dëdyuzh ne ysaan men xgyelmal men, chen gap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Yra men ne noze wrëëts por ne winyaan mén men tyemp ne wket mén Xteb, wdxiin men axtegue lo lyu ne la Fenicia no le lo lyu ne la Chipre no le Antioquía, wzëët men xdiznzoon Jesucrist nonchee lo men-Israel, rutre lo wzëëdet meno. ");
INSERT INTO zpi_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lad mén guin nuu txup tson men-Chipre no le men-Cirene. Chene wdxiin men Antioquía, laa men wzëët xdiznzoon Jesucrist no lo yra mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Laa Dëdyuzh waknonen men; por neguin kesentyent ndal mén wlaleedx ne re men, lex wak mén guin xpén Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Chene won men-Jerusalén ne nak xpén Jesucrist yra diizree, wxaal men Bernabe axtegue Antioquía. ");
INSERT INTO zpi_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ne wdxiin Bernabe Antioquía, kesentyent wzhiilen Bernabe ne wii Bernabe che raknonen Dëdyuzh men-Antioquía; lex wnino Bernabe men ne tebegue tsuu lextoo men, ysalzaandet men ne rlaleedx men Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Te mgyeey ne wen nak Bernabe, kesentyent raknonen Espíritu Sant Bernabe no rlaleedx Bernabe Jesucrist ydeblextoo Bernabe. No kesentyent ndal mén wlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Zhich guin wa Bernabe Tarso waye Bernabe Saulo; chene wzël Saulo lo Bernabe, wano Bernabe Saulo Antioquía. ");
INSERT INTO zpi_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nga wkaa men yrup men te iz lo men ne rlaleedx Jesucrist, wkaneluu men ndal mén. Antioquía nak ledne wzelo wnesela mén yra xpén Jesucrist “cristian”. ");
INSERT INTO zpi_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Cheguin ke wruu tebëd profet Jerusalén wa men Antioquía. ");
INSERT INTO zpi_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Lad men nuu te mén ne la Agabo. Laa mén guin wzuli, lex por xpoder Espíritu Sant wnii men, re men ne zuu gbiin ydendxee gyëzlyu. No nli zenga wak tyemp ne wnebééy Claudio. ");
INSERT INTO zpi_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Lex wuu yra xpén Jesucrist diiz ne yxaal men logne gunendxee men gan ydee men te te men, chen gun men xyudar yra men-Judea ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Zenga wlaa men yra men, lex laa Bernabe yrup Bernabe Saulo weeyo wdekwent meno lo yra mén ne rnebééy lo men-Judea ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Cheguin ke wzelo Herodes ne nak rrey wnëëz Herodes tebëd mén ne rlaleedx Jesucrist, chen yzakzi Herodes men. ");
INSERT INTO zpi_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Lex wkyeen Herodes wket mén Jacob bech Xwa kon spad. ");
INSERT INTO zpi_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ne wii Herodes ne wtseleedx yra men-Israel ne wlaa Herodes zenga, wkyeen Herodes yzuun no Bëd. Lo pask wak neree chene ru mén gyëtxtil ne nootsdet lebadur. ");
INSERT INTO zpi_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Chene che wzuun Bëd, wguu men Bëd chegyiib, lex wzu Herodes chimteb soldad ne kwinnap chegyiib; yra soldad guin wak men tapgue tapgue wbinnap men chegyiib. Wlebleedx Herodes ne chene ndesu pask, ndxig Herodes Bëd lo yra mengyëz. ");
INSERT INTO zpi_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Zenga wuu Bëd chegyiib, ndxinnaplel soldad chegyiib, per le yra mén ne rlaleedx Jesucrist, zanablel men lo Dëdyuzh por Bëd. ");
INSERT INTO zpi_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Gyëël ke guin ne nyenii lyu ne ndxig Herodes Bëd lo yra mengyëz, nexguees Bëd; tegue soldad zunap ydixyda Bëd, txup kaden nliib Bëd, le stebëd soldad ndxinnap zhinyaglachegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tebegue wdxiin te xangel Dëdyuzh; orguin wkaa bnii ydendxee lenchegyiib, lex wgal angel koo Bëd wboo angel mkaal lo Bëd, re angel: ―Gyiid gyiidske gutsaxee. Orgueguin wbil kaden yrup nya Bëd. ");
INSERT INTO zpi_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Lex re angel lo Bëd: ―Gugak xab de no gukaa xgyël de nii de. Wlaa Bëd zenga, lex re angel ste: ―Gurël lër ne rrël de, lex gutanal noo. ");
INSERT INTO zpi_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Orguin wrunal Bëd angel guin, ni nandet Bëd gan pe nli neguin ne kayak. Nuu lextoo Bëd pazer noze rnexgyëëlen Bëd. ");
INSERT INTO zpi_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wdesu Bëd yrup Bëd angel ledne primer ndxinnap soldad; zhich guin wdesu Bëd yrup Bëd angel ledne wrup lugar ne ndxinnap soldad. Chene wdxiin Bëd ledne ka yaglagyiib nes runëz, noze zhalo wyalo. Orguin wruu Bëd yrup Bëd angel. Chene che wzaa Bëd tebla yrup Bëd angel ne wdxiin Bëd ledne rdetxuug ste nëz, nga wsan angel Bëd. ");
INSERT INTO zpi_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Orguin wdee Bëd kwent, re Bëd: ―Orree si wyenen noo ne nli Dëdyuzh wxaal xangel Ne chen yselaa Ne noo lo Herodes no le lo yra ne rlaan yra men-Israel nlaa men noo. ");
INSERT INTO zpi_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Chene che wdee Bëd kwent yra neree ne wak, wa Bëd ruxyuu Mli xnaa Xwa ne la ke Mark, ledne ndxin ndalyaa mén ne kanab lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ne wkanya Bëd txuyaglaa ne ka nes runëz, wruu te nzaap ne la Rode, chen kwii nzeb gan txuzh ne. ");
INSERT INTO zpi_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Per chene wnebeey nzeb xrëz Bëd, kesentyent wzhiilen nzeb; lugar ne nxal nzeb yaglaa, lel noze rzhoon nzeb waluu nzeb diiz ne le Bëd zu zhiin yaglaa. ");
INSERT INTO zpi_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wke men yra men, re men lo nzeb: ―¡Noze nzël de! Per wberee nzeb re nzeb ste: ―Rongue de nli we. Lex re men: ―Let Bëdet ne; pazer xefxin Bëdo. ");
INSERT INTO zpi_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Per mazre rkanya Bëd txuyaglaa, le chene wxal men yaglaa ne wii men Bëd, kesentyent wzee wzak men. ");
INSERT INTO zpi_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Orguin wluu Bëd senye lo men ne gyakchi men, lex wuu Bëd diiz lo men gan pezee wboo Dëdyuzh Bëd lenchegyiib, no re Bëd: ―Guguu diizree lo Jacob no le lo yra xkompanyer be ne rlaleedx Jesucrist. Wluzh nga wruu Bëd za Bëd ste lugar. ");
INSERT INTO zpi_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ne wyenii lyu axtegue nandet yra soldad gan pe nlaa soldad, porke wyenden soldad gan pezee wruu Bëd. ");
INSERT INTO zpi_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Lex wkyeen Herodes wa soldad waye soldad Bëd, per kom wundet soldad gan nzël Bëd, lex wnabdizyu Herodes lo yra soldad ne wbinnap Bëd; wluzh nga wkyeen Herodes wket mén yra soldad guin. Wluzh wak yra neree, wruu Herodes lo lyu ne la Judea, wa Herodes wuu Herodes Cesarea. ");
INSERT INTO zpi_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Wkalaa Herodes lo yra men-Tiro no le lo yra men-Sidón, per wyan yra mén guin diiz ne ybig men lo Herodes, lex wtsowxmig men te xpén Herodes ne la Blasto, lex laa Blasto wnii lo Herodes por xkwent yra men guin ne tildetre Herodes men. Wlaa yra mén guin zenga porke nes ledne rnebééy Herodes rruu ne ru men. ");
INSERT INTO zpi_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Zhich guin wsu Herodes te dxe ne gu Herodes diiz yra Herodes mén guin. Chene wdxiin dxe guin, wak Herodes xab Herodes ne rak Herodes ne nak Herodes rrey, lex wzob Herodes ledne rlaa Herodes gyelextis, wzelo Herodes wnii Herodes lo yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Lex wzelo mén noze rakrwid men, re men: ―¡Ménree ne rnii, nakdet men noze mén, sinke te dëdyuzh nak men! ");
INSERT INTO zpi_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Orgueguin wlaa te xangel Dëdyuzh ne wzhuun Herodes, wyezaa mgotx led Herodes axtegue wet Herodes, porke wtseleedx Herodes ne wzaknon mén Herodes, lugar ne nzaknon mén Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Per le xdiiz Dëdyuzh zarëëtsre yrandxee lugar, no zayakndalre mén ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Le Bernabe yrup Bernabe Saulo, chene wberee men ne wyal dxiin ne wlaa men Jerusalén, wzano men Xwa ne la ke Mark, wdxiin ke men Antioquía. ");
INSERT INTO zpi_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lad yra men-Antioquía ne rlaleedx Jesucrist, nuu profet no le mén ne rneluu xdiiz Dëdyuzh. Laa men nga nak Bernabe, nak Simon (men ne la ke Ngas), nak Lucio men-Cirene, nak Saulo, nak Manaén (men ne wroo tese yrup men rrey-Herodes ne wnebééy lo lyu ne la Galilea). ");
INSERT INTO zpi_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Te dxe ne wdop men chen saknon men Dëdyuzh no ne wkwan men wudet men, re Espíritu Sant lo men: ―Gukowaa Bernabe yrup Bernabe Saulo, chen ylaa men dxiin ne wbëz noo men ylaa men. ");
INSERT INTO zpi_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Chene wluzh wkwan men no ne wnab men lo Dëdyuzh, wxob nya men xtoo Bernabe yrup Bernabe Saulo chen gaknonen Dëdyuzh men, lex wguli men men nëz za men yrup men. ");
INSERT INTO zpi_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Laa Espíritu Sant wxaal Bernabe yrup Bernabe Saulo ne za men Seleucia. Nga wuu men bark za men lyu ne la Chipre ne ka lo nisdoo. ");
INSERT INTO zpi_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ne wdxiin men te gyëz ne la Salamina ne nak lo lyu ne la Chipre, nga wzelo men wzëët men xdiiz Dëdyuzh lenxeydoo men-Israel. No Xwa zano men chen gun Xwa xyudar men. ");
INSERT INTO zpi_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wdee men ydendxee lo lyu guin ne ka lo nisdoo, wdxiin men Pafos. Nga wtsëlo men te men-Israel ne nak bruj ne la Barjesus; noze rkade men re men te xprofet Dëdyuzh nak men. ");
INSERT INTO zpi_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Xpén gobernador-Sergio Paulo nak men. Kesentyent nan gobernador guin. Wbëz gobernador guin Bernabe yrup Bernabe Saulo, porke rlaan men gon men xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Brujree (kon diz-griego la men Elimas) wlaan men nsoow men chen nlaleedxdet Sergio Paulo xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lex kesentyent waknonen Espíritu Sant Saulo ne la ke Pabel, wii wiindxee Saulo lo mén guin, ");
INSERT INTO zpi_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","lex re Saulo lo men: ―¡Zhiin Bzelo nak de, kesentyent mal de, teblose rkade de, rwinyaan de ne wen! ¿Pa axtegue or ysaan de ne rsoow de ne tsanal mén xdiiz Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Orree yzakzi Dëdyuzh de; gyanengwlëë de, xche gakdet kwii de xebnii ngbiz. Orgueguin waknkeb bzalo mén guin, wakdetre nwii men, lex wye men gan txu ynëëz nya men. ");
INSERT INTO zpi_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Chene wii gobernador neguin, wlaleedx men Jesucrist, no kesentyent wzee wzak men por yra xdiiz Jesucrist ne wneluu Bernabe yrup Bernabe Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Wruu Pabel Pafos yra Pabel xkompanyer Pabel, wuu Pabel bark za Pabel Perge ne nak lo lyu ne la Panfilia. Nga wsan Xwa Bernabe yrup Bernabe Pabel, wberee ke Xwa Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Zhich guin wruu Pabel yrup Pabel Bernabe Perge, wdxiin men yrup men Antioquía ne nak lo lyu ne la Pisidia. Lex dxe ne rne men-Israel, wa men yrup men lenxeydoo men-Israel, wdee men wzob men. ");
INSERT INTO zpi_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Chene wluzh wool mén ne zëëd lo ley no le ne wkaa yra profet, wnii yra mén ne rnebééy lenydoo guin lo Pabel yrup Pabel Bernabe, re men: ―Zhanbech, belne nuu diiz rlaan de yzëët de lo mén chen ynino de men, zak yzëëto orree. ");
INSERT INTO zpi_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Lex wzuli Pabel, wluu Pabel senye ne kwinchi mén, lex re Pabel: ―Men-Israel no laa de yra de ne nakdet de men-Israel ne kaye de gan pezee ylaa de ne rlaan Dëdyuzh, gugon neree. ");
INSERT INTO zpi_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dëdyuzh wye men-Israel no laa Ne wlaa ne kesentyent wdaal men chene benak nak men menzit ne nuu men Egipto. Zhich guin wboo Ne men yra men lo lyu guin kon xpoder Ne. ");
INSERT INTO zpi_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Wun Ne wantar yra ne wlaa men zeg txuplal iz ydeblo ne wkaa men denbidx. ");
INSERT INTO zpi_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Zhich guin wluzh Ne guedx nacion ne nak lo lyu Canaán, lex wdee Ne lyu guin lo men yra men. ");
INSERT INTO zpi_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Zeree wak zeg tapgwyugwrol iz. Zhich guin wye Ne mén ne wak jwes ne wnebééy lo men yra men. Profet-Samuel wak lultim jwes ne wnebééy lo men. ");
INSERT INTO zpi_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Lex wnab men lo Dëdyuzh ne tsuu te rrey ne ynebééy lo men. Por neguin wzu Dëdyuzh Saul xpee Cis, men ne nak xfamilye Benjamin, wak rrey lo men txuplal iz. ");
INSERT INTO zpi_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Chene wgyitxee Dëdyuzh gyelrrey lo Saul, wzu Ne David wak rrey lo men no re Ne: “Che wii noo ne David xpee Isaí rlaa ne rtseleedx noo no slaa men yrandxee ne rlaan noo.” ");
INSERT INTO zpi_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","No lad ke xnëz Davidree zëëd Jesus. Laa Dëdyuzh wxaal Ne chen yselaa Ne men-Israel lo dol zegne che re Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Antes ne chiid Jesus, che re Xwa lo yrandxee men-Israel ne rap men degne ysaan men xgyelmal men no yrobnis men. ");
INSERT INTO zpi_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","No chene che wyob tesu Xwa gyëzlyuree, re Xwa: “Let noodet nga nak men ne rzaa lextoo de yra de ne chiid. Gyed zëëd men guin no axtegue ni xgyël men rzëëldet noo ychil noo nii men.” ");
INSERT INTO zpi_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Yra de zegne zëëd de xnëz Abraham no laa de yra de ne rye de gan pezee ylaa de ne rlaan Dëdyuzh: por laa de yra de nak diizree ne rselaa mén lo dol. ");
INSERT INTO zpi_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Per nakdeto por men-Jerusalén ni por mén ne rnebééy lo men-Jerusalén, porke wlaandet men nyaknan men gan txu nak Jesus, ni wdeedet men kwent gan pe rna yra xdiiz Dëdyuzh ne wkaa yra profet ne rool men lenydoo te te dxe ne rne men-Israel. Laake men yra men wket Jesus; zenga wun men kumplir yra diiz guin ne wkaa profet. ");
INSERT INTO zpi_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","No mase bet wzëldet lo men ne rzëël guet Ne, per wnab men lo Pilato ne ykyeen Pilato yket mén Ne. ");
INSERT INTO zpi_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Chene wluzhse wlaa men Ne yrandxee zegne zëëd lo xgyiich Dëdyuzh ne sak Ne, wlit mén Ne lo kruz, wguu men Ne lenbaa. ");
INSERT INTO zpi_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Per wneban Dëdyuzh Ne. ");
INSERT INTO zpi_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","No ndal tir wlalo Ne lo yra mén ne wkaa yra Ne chene wruu Ne Galilea ne wa Ne Jerusalén. Orrenaa laa yra men guin ne wii yra neree nak ne rzëëto lo mén. ");
INSERT INTO zpi_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Noo yra noo rzëët dizwenree lo de yra de, ne le ne re Dëdyuzh lo yra menkwlal, ");
INSERT INTO zpi_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","le we che wlaa Ne lo be yra be. Laa we nga wlaa Ne chene wneban Ne Jesus, zegne ka lo salmo ne wrup ledne re: “Laa de nak XPee noo; noo nak xuz de desde nedxeree.” ");
INSERT INTO zpi_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Che wzëët Dëdyuzh ne sneban Ne Jesus chen xiindet xkwerp Jesus, laa we nga re Dëdyuzh chene re Ne: “Lo de yra de ylaa noo ne nzoon no le ne nli ne re noo lo David.” ");
INSERT INTO zpi_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Por neguin ke re ste lo salmo: “Laa de ydeedet de si xiin xkwerp XPee de ne bet dol rlaadet.” ");
INSERT INTO zpi_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Porke zegnak David, chene wluzh wnebééy men lo yra mén ne wuu xetyemp men zegne wkyeen Dëdyuzh men, wet men, wugyeer men zegne wugyeer ke yra gyedxuzgoldoo men no wzhiin xkwerp men. ");
INSERT INTO zpi_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Per le Jesus ne wneban Dëdyuzh, wzhiindet xkwerp Ne. ");
INSERT INTO zpi_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Por neguin rap de degne gaknan de ne por Jesucrist rakzëët ne zak perdon xdol be, ");
INSERT INTO zpi_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","no ne yrandxee mén ne rlaleedx Jesucrist che wak perdon yra xdol men, dol ne wakdet perdon mase wlaa men zegne zëëd lo ley ne wdee Dëdyuzh lo Moises. ");
INSERT INTO zpi_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Por neguin gugap kwent chen sakdet de ne wkaa yra profet ledne re: ");
INSERT INTO zpi_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Gukwii gante, yra de ne rzhidxno de noo, guzee guzak no gunitlo, porke myentras ne mbán de, ylaa noo ne nzoon ne axtegue ni laa de ylaleedxdeto, mase gu mén diizo lo de. ");
INSERT INTO zpi_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Chene wruu Pabel yrup Pabel Bernabe lenxeydoo men-Israel, wnab yra mén guin lo Pabel ne tsa Pabel ste dxe ne rne men-Israel, yzëët Pabel yra diiz guin lo men. ");
INSERT INTO zpi_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Chene wluzh nga ne wruu yra mén lenydoo guin, ndalyaa men-Israel no ndalyaa ke mén ne nakdet men-Israel ne rlaleedx Dëdyuzh zegne rlaleedx men-Israel Dëdyuzh, wanal men Pabel yrup Pabel Bernabe, lex wnino Pabel yra men guin yrup Pabel Bernabe ne ysalzaandet men ne wseleedx Dëdyuzh lo men. ");
INSERT INTO zpi_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Dxe ne wdxiin ste dxe guin ne rne men-Israel, kasi yrandxee mengyëz guin wdop chen gon men xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Per chene wii yra men-Israel ne kesentyent ndal mén wdop, wakmbidye men, re men, nlidet ne rzëët Pabel, wzelo men wninyaan men lo Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Orguin kesentyent waknzholeedx Pabel yrup Pabel Bernabe wnii Pabel lo men, re Pabel: ―Rap noo degne yzëët noo xdiiz Dëdyuzh primer lo de yra de ne nak de men-Israel; per kom rlaandet de gon do no kom rlaandet de yganen de gyelembán ne nunk luzhdet, mazdee le noo tsazëëto lo yra mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Porke zenga wkyeen Dëdyuzh noo yra noo chene re Ne: Wzu noo de zegnak te bnii por yra mén ne nakdet men-Israel, chen tsa de axtegue ydendxee gyëzlyu, tsazëët de gan pezee yláá mén lo dol. ");
INSERT INTO zpi_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ne won yra mén ne nakdet men-Israel diizree, wzhiilen men, wzelo men re men: “Nzoon xdiiz Dëdyuzh.” Yrandxee mén ne che nunla ne gap gyelembán ne nunk luzhdet, wlaleedx men xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Zenga wakzëët xdiiz Dëdyuzh ydendxee nes guin. ");
INSERT INTO zpi_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Per wsegyee men-Israel lextoo tebëd wnaa ne non no ne syemper ra lenydoo no wsegyee ke men lextoo yra mgyeey ne non gyëz guin. Lex wzelo yra mén guin winyaan men Pabel yrup Pabel Bernabe, axtegue ne wnexoon men Pabel yrup Pabel Bernabe nes guin. ");
INSERT INTO zpi_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Orguin wbib Pabel guxyudi nii Pabel yrup Pabel Bernabe, zegnak te beey ne nadet mén guin nyon men ne wzëët Pabel. Lex za Pabel yrup Pabel Bernabe gyëz-Iconio. ");
INSERT INTO zpi_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Per le yra mén ne rlaleedx Jesucrist nga, kesentyent rzhiilen men no kesentyent raknonen Espíritu Sant men. ");
INSERT INTO zpi_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Chene wdxiin Pabel yrup Pabel Bernabe gyëz-Iconio, wa men lenxeydoo men-Israel yrup men, lex wzëët men xdiznzoon Jesucrist, kesentyent nzoon wzëët meno; por neguin kesentyent ndal mén wlaleedxo, nigle men-Israel, nigle mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Per le yra men-Israel ne wlaleedxdeto, wsegyee men lextoo yra mén ne nakdet men-Israel, chen kwinyaan men men ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Per mase zenga, xcher wkaa Pabel yrup Pabel Bernabe nga, no por ne rlaleedx men Jesucrist, wdxedet men wkazëët men lo mén ne ryaan Dëdyuzh mén, no wdee Ne poder lo men yrup men wlaa men ndal gyelmilaguer no ndal gyelenzoon; zenga wbonyoo Dëdyuzh ne nli ne rzëët men. ");
INSERT INTO zpi_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Per wakgwrool yra mengyëz guin, gwrool men wruu xfabor men-Israel, gwrolzeg men wruu xfabor Pabel yrup Pabel Bernabe. ");
INSERT INTO zpi_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Lex wyan men-Israel diiz yra men mén ne nakdet men-Israel no le yra men xtis ne yzakzi men Pabel yrup Pabel Bernabe, gugye men men. ");
INSERT INTO zpi_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Per zegne waknan Pabelo yrup Pabel Bernabe, wruu men nga wa men Listra no le Derbe gyëz ne nak lo lyu ne la Licaonia no le yra gyëz ne nak guex nes guin, ");
INSERT INTO zpi_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","wazëët men xdiznzoon Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra nuu te mgyeey ne ngyidet nii axtegue ne wal men, nuudet saa men; zobchee men nga, ");
INSERT INTO zpi_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","rkagyedyag men ne rzëët Pabel, lex wii Pabel lo men, wyenen Pabel ne rlaleedx men ne syaken men. ");
INSERT INTO zpi_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Orguin ndípse wnii Pabel lo men, re Pabel: ―Gusuli, tebli gusu. Orgueguin wzuli mgyeey guin axtegue watxegya men, wzelo men wzaa men. ");
INSERT INTO zpi_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ne wii yra mén neguin ne wlaa Pabel, wzelo men noze rakrwid men kon diz-Licaonia, re men: ―¡Dëdyuzh ne nak zegnak mén wyët wlenza lad be! ");
INSERT INTO zpi_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Re men, laa Bernabe nak dëdyuzh Júpiter, le Pabel nak dëdyuzh Mercurio, porke laa Pabel nak ne kanii lo men. ");
INSERT INTO zpi_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Orguin wdxiin fxuz ne rlaa dxiin lenydoo ne zob rulgyëz ledne zob ne rlaa mén xdëdyuzh mén; Júpiter rnii men kos guin. Wdxiin fxuz guin wdxinno men tor no wdxinneey men gyee; lex wlaan men nket men tor yra men mén chen nzaknon men Pabel yrup Pabel Bernabe. ");
INSERT INTO zpi_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Per chene waknan Pabelo yrup Pabel Bernabe, wtxëz xab Pabel yrup Pabel Bernabe, watenzeeb men lad yra mén guin, noze robtsaa men, re men: ");
INSERT INTO zpi_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¿Penak rlaa de zegwa yra de si noze mén ke nak noo zegnak ke de yra de? No neguin neguinendxee zëëd noo lo de chen yzëët noo ne ysalzaan de yra kos gwa ne bat rkyiindet ne rlaa de, lex ylaa de ne rlaan Dëdyuzhmbán ne wzhexkwaa gyeybaa gyëzlyutee no le nisdoo no le yrandxee ne nuu lo we. ");
INSERT INTO zpi_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Chekwlal wdee Dëdyuzh si wlaa yrandxee mén logne wlaantee men. ");
INSERT INTO zpi_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Per mase zenga, syemper wbonyoo Ne gan txu nak Ne por yra ne wen ne rlaa Ne. Laa Ne rlag gyo, laa Ne rlaa ne rak yrandxee ne rlabni be, laa Ne rseleedx ne ru be no laa Ne rseleedx gyelgwzhiil lo be. ");
INSERT INTO zpi_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mase re Pabel zenga yrup Pabel Bernabe, per nen nentee wun Pabel gan wsoow Pabel ne wketet men tor guin. ");
INSERT INTO zpi_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Per chene le tebëd men-Israel ne nuu Antioquía wdxiin Listra yra men stebëd mén ne nuu Iconio, wsegyee men lextoo yra mén guin. Lex wgugye men Pabel; nuu lextoo men che wket men Pabel, wgobzengye men Pabel watix men Pabel rulgyëz. ");
INSERT INTO zpi_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Per chene wdop yra mén ne rlaleedx Jesucrist wbiin men kbii Pabel, waxee Pabel wdee ke Pabel lenlgyëz ste. Ne wra gyëël guin, wruu Pabel nga yrup Pabel Bernabe, za Pabel Derbe yrup Pabel Bernabe. ");
INSERT INTO zpi_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Chene wluzh wzëët Pabel xdiznzoon Jesucrist Derbe, ndalyaa mén wlaleedx Jesucrist. Lex wberee ke Pabel wdxiin Pabel Listra no le Iconio no le Antioquía, ");
INSERT INTO zpi_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","wguu Pabel lextoo yra mén ne rlaleedx Jesucrist yrup Pabel Bernabe, re Pabel lo men ne ysalzaandet men ne rlaleedx men Ne, no re Pabel lo men por ne ydxiin me ledne rnebééy Dëdyuzh, rap me degne kesentyent gak me sufrir. ");
INSERT INTO zpi_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","No wye Pabel yrup Pabel Bernabe mén ne ynebééy lo yra mén ne rlaleedx Jesucrist te te gyëz guin, lex chene wluzh wnab Pabel lo Dëdyuzh yrup Pabel Bernabe no chene wluzhse wkwan men, wsan men yra mén guin ledxnya Jesucrist ne che rlaleedx men Ne. ");
INSERT INTO zpi_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Zhich guin wdee Pabel yrup Pabel Bernabe lo lyu ne la Pisidia, wdxiin men lo lyu ne la Panfilia. ");
INSERT INTO zpi_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Wkazëët men xdiiz Jesucrist Perge te gyëz ne nak lo lyu guin, lex za men Atalia. ");
INSERT INTO zpi_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nga wuu men bark yrup men wberee ke men Antioquía ne nak lo lyu ne la Siria, ledne wnab yra xkompanyer men lo Dëdyuzh antes ne yruu men tsa men ne gaknonen Dëdyuzh men yrup men ne ytxëëts men xdiiz Jesucrist. Laa we nee che wlaa men. ");
INSERT INTO zpi_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Chene wdxiin men Antioquía, wtop men yra mén ne rlaleedx Jesucrist, lex wuu men diiz lo yra mén guin gan pezee waknonen Dëdyuzh men lo yra ne wlaa men no gan pezee waknonen Dëdyuzh mén ne nakdet men-Israel no men wlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Xche wkaa men nga lo yra mén ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Cheguin ke wruu tebëd mén lo lyu ne la Judea wa men Antioquía, wzelo men re men lo yra mén ne rlaleedx Jesucrist, belne tsuudet men beey zegne wkyeen Moises, gakdet perdon xdol men. ");
INSERT INTO zpi_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Lex neguin kesentyent wdildiiz Pabel yra mén guin yrup Pabel Bernabe. Lex wye men ne rlaleedx Jesucrist Pabel yrup Pabel Bernabe no wye men tebëd men ne rlaleedx ke Jesucrist chen tsa men Jerusalén gu men diiz yra men poxter no le yra men mén ne rnebééy lo yra men ne rlaleedx Jesucrist gan pezee ylaa men kwent guin. ");
INSERT INTO zpi_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Lex wguli yra men ne rlaleedx Jesucrist men nëz za men yra men, wdee men lo lyu ne la Fenicia no le lo lyu ne la Samaria, wuu men diiz lo yra men ne rlaleedx Jesucrist ne no yra mén ne nakdet men-Israel che rlaleedx Jesucrist. Kesentyent wzhiilen yra mén guin ne won meno. ");
INSERT INTO zpi_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Chene wdxiin Pabel Jerusalén yrup Pabel Bernabe, wa yra men ne rlaleedx Jesucrist yra men poxter no le yra men ne rnebééy lo men ne rlaleedx Jesucrist watsëlo men Pabel yrup Pabel Bernabe. Lex wuu Pabel diiz lo men yrup Pabel Bernabe gan pezee waknonen Dëdyuzh men yrup men lo yra ne wlaa men. ");
INSERT INTO zpi_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Per wzuli tebëd men ne nak farisew ne che rlaleedx Jesucrist, re men: ―Yra mén ne nakdet men-Israel ne che rlaleedx Jesucrist, rkyiin ne tsuu men beey ne ruu men-Israel no rkyiin ne ykyeen be men ne ylaa men zegne zëëd lo ley ne wdee Dëdyuzh lo Moises. ");
INSERT INTO zpi_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Lex wdop poxter yra poxter mén ne rnebééy lo yra men ne rlaleedx Jesucrist chen gu men diiz gan pezee ylaa men. ");
INSERT INTO zpi_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Chene che wakxche kayuu men diiz, wzuli Bëd, re Bëd: ―Yra de che nan de ne che wakxche wye Dëdyuzh noo lad de yra de, chen tsazëët noo xdiznzoon Jesucrist lo yra mén ne nakdet men-Israel chen ylaleedx meno. ");
INSERT INTO zpi_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Rnebeey Dëdyuzh lextoo yrandxee mén, laa Ne wbonyoo ne che xpén Ne nak mén ne nakdet men-Israel porke wseleedx Ne Espíritu Sant lo men zegne wseleedx ke Ne Espíritu Sant lo be yra be. ");
INSERT INTO zpi_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dëdyuzh rbedet Ne mén, porke ne wlaa ke Ne lo be, neguin ke wlaa Ne lo men, wgyitxee Ne xdol men por ne rlaleedx men Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Orrenaa, ¿penak ryandet de byen ne wlaa Dëdyuzh, ne rkyeen de men ne rlaleedx Jesucrist ylaa men ne zëëd lo ley ne ni laa be yra be ni xpenkwlal be wundet gan nlaa ne zëëd lo ley? ");
INSERT INTO zpi_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Si nan be ne por xgyelwen Jesucrist wláá be lo dol zegne wláá ke men lo dol. ");
INSERT INTO zpi_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Orguin wyakchi yrandxee mén, wkagyedyag men ne wzëët Pabel yrup Pabel Bernabe yra gyelmilaguer no le yra gyelenzoon ne wdee Dëdyuzh si wlaa Pabel lad yra mén ne nakdet men-Israel yrup Pabel Bernabe. ");
INSERT INTO zpi_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Chene wluzh wnii Pabel yrup Pabel Bernabe, wke Jacob, re Jacob: ―Gugon ne yna noo lo de yra de: ");
INSERT INTO zpi_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Che won be ne na Simon-Bëd gan pezee wzelo Dëdyuzh waknonen Ne mén ne nakdet men-Israel, chen gak men xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Yra neree ne wak, wako zegne ka lo xgyiich Dëdyuzh ne wkaa profet ledne re: ");
INSERT INTO zpi_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Luzh nga, yberee noo ylep ke noo xyuu David ne che watxee, no ylaxnëz noo logne wyanendxee, yzoob ke noo we ste ");
INSERT INTO zpi_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","chen ye yrandxee mén noo ledne gon men la noo ydendxee lo gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Zeree re Dëdyuzh, laa Ne wzëët neree lo mén axtegue chekwlal. ");
INSERT INTO zpi_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Por neguin ryenen noo ne ngyidet ne gunen be lo yra mén ne nakdet men-Israel ne che za xnëz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nozguestee te gyiich ykaa be yxaal be lo men, ne gudetre men ne che wseleedx mén lo mdoo, no ne ykanodetgue men xkompanyer men belne gardet ytsëlnya men, no gudet men xbëël maa ne rxedet ren, ni gudet men ren. ");
INSERT INTO zpi_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Porke kada gyëz axtegue chekwlal che nuu mén ne rzëët ne zëëd lo ley ne wdee Dëdyuzh lo Moises no yrandxee dxe ne rne be, rool méno lenydoo. ");
INSERT INTO zpi_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Lex wyan poxter diiz yra men men ne che rlaleedx Jesucrist no le men ne rnebééy lo men yra men, ne tsël men ne nuu lad ke men, chen yxaal men men Antioquía yra men Pabel no le Bernabe. Lex wye men Judas ne la ke Barsabás no le Silas. Yrup ménree nak mennon lad yra men ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Lex wdekwent men gyiich guin lo yra mén guin; zeree re lo gyiich guin: “Noo yra noo ne nak noo poxter no le yra men ne che rlaleedx Jesucrist no le men ne rnebééy lo men yra men, rgabtyuzh noo de yra de ne nakdet de men-Israel ne che rlaleedx de Jesucrist ne nuu de Antioquía no le Siria no le Cilicia. ");
INSERT INTO zpi_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Che waknan noo ne lad ke noo nee, wruu txup tson men ne wlenza nes gwa, kagoots men xtoo de yra de por yra diiz ne rzëët men lo de ne na men ne rap de degne tsuu de beey ne ruu yra men-Israel no ne ylaa de zegne zëëd lo ley, per let noodet wkyeen men. ");
INSERT INTO zpi_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Por neguin ryenen noo yra noo ne wen ye noo txup tson mén ne nuu ke lad noo, chen chiid men wii lo de yra men Bernabe no le Pabel ne kesentyent ryaan be. ");
INSERT INTO zpi_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ménree rboleedx men xgyelembán men por ne nak men xpén Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yxaal noo Judas yrup Judas Silas, lex laa zhal men yzëët yra neree lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Porke waknonen Espíritu Sant noo, wyenen noo ne ngyidet ne ykyeen noo de ne ylar de ste kos, nunegue logne rap de degne ylaa de nak ne ");
INSERT INTO zpi_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","gudetre de ne che wseleedx mén lo mdoo, ni gudet de ren, ni gudet de xbëël maa ne rxedet ren, ni ykanodetgue de xkompanyer de belne gardet ytsëlnya de. Belne gap de kwent ne ylaadet de yra neree, wen ylaa de. Wen tsa lo xgyelembán de.” ");
INSERT INTO zpi_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Zhich guin wguli men mén guin nëz za men Antioquía. Chene wdxiin men, wtop men yra men ne rlaleedx Jesucrist, lex wdekwent men gyiich guin lo men. ");
INSERT INTO zpi_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Chene wool meno, kesentyent wzhiilen men por yra dizwen ne zob lo we. ");
INSERT INTO zpi_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Kom no Judas nak profet yrup Judas Silas, neguin kesentyent wnino men yra mén guin ne rlaleedx Jesucrist no wguur men lextoo men. ");
INSERT INTO zpi_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chene che wakxche ka Judas nga yrup Judas Silas, wguli yra men ne rlaleedx Jesucrist men nëz chen yberee ke men lo yra men ne wxaal men, re men lo men: “Zhaas gugya.” ");
INSERT INTO zpi_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Per wlen lextoo Silas wyan Silas nga. ");
INSERT INTO zpi_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","No wyan ke Pabel yrup Pabel Bernabe, wkaneluur men xdiznzoon Jesucrist lo mén no wkazëët meno yra men stebëd mén. ");
INSERT INTO zpi_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Chene wzaa txup tson gbiz, re Pabel lo Bernabe: ―Yoo yberee be tsa be wii lo yra xkompanyer be ne rlaleedx Jesucrist yrandxee gyëz ledne che wazëët be xdiiz Jesucrist, chen tsawii be gan pezee za men. ");
INSERT INTO zpi_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Rlaan Bernabe nzano men Xwa, men ne la ke Mark; ");
INSERT INTO zpi_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","per ryandet Pabel byen, porke wsantegue Mark Pabel lo lyu ne la Panfilia yrup Pabel Bernabe, wanaldetre Mark men ne nzëët men xdiiz Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ni te ni te men wyandet byen. Por neguin wsalzaanelsaa men; le Bernabe wzano Mark, wuu men bark yrup men za men lyu ne la Chipre ne ka lo nisdoo, ");
INSERT INTO zpi_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","le Pabel wzano Silas; lex re yra mén ne rlaleedx Jesucrist lo Pabel: ―Dëdyuzh gaknonen de yrup de. ");
INSERT INTO zpi_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Zhich guin wdee men yra gyëz ne nak lo lyu ne la Siria no le lo lyu ne la Cilicia, wguur men lextoo yra mén ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Wdxiin Pabel Derbe no le Listra yrup Pabel Silas. Listra nuu te mén ne rlaleedx Jesucrist ne la Timotew, xpee te wna-Israel ne rlaleedx Jesucrist nak Timotew, le xuz Timotew nak men-griego. ");
INSERT INTO zpi_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Yrandxee men-Listra no le men-Iconio ne rlaleedx Jesucrist rnii dizwen por Timotew. ");
INSERT INTO zpi_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Rlaan Pabel ne tsanal Timotew Pabel, per antes ne tsanal Timotew Pabel, wguu Pabel Timotew beey ne ruu men-Israel, chen bet guedet yra men-Israel ne nuu nes guin, porke yrandxee men nan ne men-griego nak xuz Timotew. ");
INSERT INTO zpi_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Yrandxee gyëz ledne wa men yrup men, re men lo men ne rlaleedx Jesucrist ne rap men ne rlaleedx Jesucrist degne ylaa men zegne re poxter yra poxter men ne rnebééy lo yra men-Jerusalén ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Zenga nak ne le yrandxee men ne rlaleedx Jesucrist wlaleedxre xdiiz Ne no yzaandxee dxe zayakndalre men. ");
INSERT INTO zpi_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Zhich guin wdee Pabel yra Pabel xkompanyer Pabel lo lyu ne la Frigia no le lo lyu ne la Galacia, per wdeedet Espíritu Sant si ne nzëët Pabel xdiiz Dëdyuzh Asia, por neguin noze wdesu men nga yra men, ");
INSERT INTO zpi_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","wdxiin men lo lyu ne la Misia. Nga wlaan men nya men lo lyu ne la Bitinia, per wdeedet ke Espíritu Sant si ne nya men nga. ");
INSERT INTO zpi_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Noze ke wdesu men lo lyu guin ne la Misia, wdxiin men Troas. ");
INSERT INTO zpi_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nga wlalo te men-Macedonia lo Pabel gyëël, wii Pabel zuli men rnab men lo Pabel, re men: “Gulaa fabor gutaa Macedonia gun de xyudar noo yra noo.” ");
INSERT INTO zpi_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wluzhse wlalo men guin lo Pabel, orgueguin wseyob noo yra noo Pabel chen tsa noo Macedonia porke che nan noo ne laa Dëdyuzh rbëz noo yra noo Pabel chen tsazëët noo xdiznzoon Jesucrist lo mén ne nuu nes guin. ");
INSERT INTO zpi_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas wuu noo bark yra noo, wa noo tebli Samotracia lyu ne ka lo nisdoo; axtegue wra gyëël, wdxiin noo Neápolis. ");
INSERT INTO zpi_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nga wruu noo wdxiin noo Filipos; gyëz guin nak ne mazre nondee ne nak lo lyu ne la Macedonia. Roma ngab gyëz guin; nga wkaa noo txup tson gbiz yra noo. ");
INSERT INTO zpi_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Te dxe ne rne men-Israel, wruu noo fwer lenlgyëz guin yra noo, wa noo te rugyoow ledne won noo diiz ne rdop men-Israel ne ra men rnab men lo Dëdyuzh. Lex wzob noo wuu noo xdiznzoon Jesucrist lo yra wnaa ne wdop nga. ");
INSERT INTO zpi_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lad yra men guin nuu te wnaa ne la Lidia ne rzaknon Dëdyuzh; men-Tiatira nak men, purse lërmorad ne mazre wendee rtoo men. Or ne kayon men ne rzëët Pabel, wxal Dëdyuzh xgyeryen men chen mazre ykagyedyag men ne rzëët Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Zhich guin wrobnis men yra xfamilyendxee men. Wluzh nga wnab men lo noo yra noo, na men: ―Belne ryenen de ne nli rlaleedx noo Jesucrist, yoo tsa be kwë́z de ruxyuu noo. Wun men lafwers wbë́z noo ruxyuu men. ");
INSERT INTO zpi_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Tebtir chene za noo yra noo ledne rnab mén lo Dëdyuzh, wtsëlo noo te nzaap ne nuu menzab lextoo. Laa menzab rlaa ne rlaa nzaap guin gyelensin, kesentyent ryab med nya mén ne wzii nzeb por gyelensin ne rlaa nzeb. ");
INSERT INTO zpi_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Wzelo nzeb zadnal nzeb noo yra noo Pabel, rderëz nzeb, re nzeb: ―Xdxiin Dëdyuzhnzoon rlaa yra mgyeeyree, rzëët men lo de yra de gan pezee yláá de lo dol. ");
INSERT INTO zpi_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ndal gbiz wkalaa nzaap guin zenga. Chene wyëëdense Pabel, wberee Pabel re Pabel lo menzab ne nuu lextoo nzeb: ―Por la Jesucrist ykyeen noo de ne yruu de lextoo nzaapree. Orgueguin wruu menzab lextoo nzeb. ");
INSERT INTO zpi_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Per chene wyenen mén ne wzii nzaap guin ne ryabdetre med nya men, wnëëz men Pabel yrup Pabel Silas, wano men Pabel lo xtis yrup Pabel Silas. ");
INSERT INTO zpi_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Chene wdxinno men Pabel yrup Pabel Silas lo xtis, re men: ―Men-Israelree ka kagoots xtoo mengyëz, ");
INSERT INTO zpi_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","no rneluu men koxtumber ne ynadet be ylaa be no ne ryaldet zeg be ylaa bo, porke men-Roma nak be. ");
INSERT INTO zpi_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Orguin wzelo mengyëz wakntoz men lo Pabel yrup Pabel Silas, lex wboo xtis xab Pabel yrup Pabel Silas, wkyeen xtis gufkoz mén Pabel yrup Pabel Silas. ");
INSERT INTO zpi_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wluzhse ne kesentyent wgufkoz mén Pabel yrup Pabel Silas, lex walu men Pabel yrup Pabel Silas chegyiib, no wkyeen xtis mén ne rapkwent chegyiib ne kwinnaplel men chegyiib, chen yláádet Pabel yrup Pabel Silas. ");
INSERT INTO zpi_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Chene won men ne rapkwent chegyiib zenga, wsee men Pabel yrup Pabel Silas axtegue lenkalabos no wsee men nii Pabel yrup Pabel Silas lad yag, wliib meno kon kaden. ");
INSERT INTO zpi_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Per zeg gwrool gyëël kanab Pabel lo Dëdyuzh yrup Pabel Silas, rolbaan Pabel por Dëdyuzh yrup Pabel Silas; yra mén ne nuu chegyiib ron ne kayolbaan Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tebegue wzelo kesentyent wni lyu, noze zere zerotee rak simyent chegyiib. Orgueguin wyal yrandxee yaglachegyiib no wbil kaden ne nliib yrandxee mén ne nuu chegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Chene wruu mkaal lo men ne rapkwent chegyiib no ne wii men ne zemyal yra yaglachegyiib, wboo men xespad men nket men men laake men, porke nuu lextoo men pazer che wláá yrandxee mén ne nuu chegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Per noze robtsaa Pabel, re Pabel lo men: ―¡Bet ylaadet de de; le noo yra noo nuu ke nee! ");
INSERT INTO zpi_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Lex wnab mén guin ne rapkwent chegyiib te bnii; wdee men lenchegyiib noze rzhoon men noze rzhiz men por gyelerdxeeb, wa men wzuzhib men lo Pabel yrup Pabel Silas. ");
INSERT INTO zpi_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Orgueguin wboo men Pabel yrup Pabel Silas, lex wnabdiiz men, re men: ―Dechey, ¿pagox rap noo degne ylaa noo chen gun Dëdyuzh perdon xdol noo? ");
INSERT INTO zpi_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wke Pabel yrup Pabel Silas, re Pabel: ―Gulaleedx Jesucrist, chen zenga gak perdon xdol de yra de xfamilye de. ");
INSERT INTO zpi_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Lex wzëët Pabel yrup Pabel Silas xdiiz Jesucrist lo men no le lo yra mén ne nuu xyuu men. ");
INSERT INTO zpi_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Gyëël ke guin waa men led Pabel yrup Pabel Silas ledne wrëz ne wga fkoz. Wluzh nga wa men wrobnis men yra xfamilyendxee men. ");
INSERT INTO zpi_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Zhich guin wano men Pabel yrup Pabel Silas ruxyuu men, wdee men ne wu men yrup men. Kesentyent rzhiilen mén guin yra men xfamilye men ne che rlaleedx men Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ne wyenii lyu, wxaal xtis soldad wa soldad wa gue soldad lo men ne rapkwent chegyiib ne yselaa men Pabel yrup Pabel Silas. ");
INSERT INTO zpi_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Lex re men ne rapkwent chegyiib lo Pabel: ―Che wkyeen xtis noo ne yselaa noo de. Che zak gya de, bet tsadet lextoo de. ");
INSERT INTO zpi_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Per wke Pabel, re Pabel: ―Men-Roma nak noo yrup noo no le xtis wkyeen wgufkoz mén noo nes lo yra mengyëz; wluzh nga wsee zhaa noo chegyiib, no ni nadet zhaa gan pe kwentzho. Orrenaa le zhaa rlaan yselaa noo laangue. ¡Per yruudet noo noze zeree! Chiid zhaa laa zhal zhaa koo zhaa noo. ");
INSERT INTO zpi_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Lex wa soldad re soldad yra diiz guin lo xtis. Chene won xtis ne men-Roma nak Pabel yrup Pabel Silas, wdxe xtis. ");
INSERT INTO zpi_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Orguin wa xtis wnab xtis perdon lo Pabel yrup Pabel Silas, lex wboo men men yrup men lenchegyiib, wnab men lo men ne yruu men gyëz guin. ");
INSERT INTO zpi_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Zegne wruu men chegyiib yrup men, wague men ruxyuu Lidia wawii men lo yra men ne rlaleedx Jesucrist; wguur men lextoo yra mén guin, lex wruu men nga sya men. ");
INSERT INTO zpi_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ne sya Pabel yrup Pabel Silas, wdee men Anfípolis no le Apolonia, wdxiin men Tesalónica ledne zob te xeydoo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Wa Pabel lenydoo guin zegnak xkoxtumber Pabel, wzëët Pabel xdiiz Dëdyuzh lo men tson dxe ne rne men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Wzëët Pabel no wluu Pabel ne ka lo xgyiich Dëdyuzh ledne re ne sakzi Crist no chene che wet Ne, yban ke Ne. No re Pabel: ―Jesusree ne rzëët noo lo de yra de, laake Ne nga nak Crist. ");
INSERT INTO zpi_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Gwrol men-Israel wlaleedx Jesucrist, waktes men yra men Pabel no le Silas. No ndal ke men-griego ne rzaknon Dëdyuzh no ndal ke wnaa ne non wlaleedx Ne. ");
INSERT INTO zpi_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Le yra men-Israel ne wlaleedxdet Ne, wakmbidye men; wtop men tebëd menmal ne zad ka, wlaa men te rwidroo lenlgyëz guin. Watee men xyuu Jasón, waye men Pabel yrup Pabel Silas chen koo men men yrup men, ydxig men men nes lo mengyëz. ");
INSERT INTO zpi_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Per kom wzëldet Pabel, por neguin wgobzengye men Jasón no le stebëd mén ne rlaleedx Jesucrist, wano men men nes lo xtis. Rderëz men, re men: ―Yra ménree ne ka kagoots xtoo mén ydendxee gyëzlyu, le men wlenza no nee. ");
INSERT INTO zpi_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Laa Jasón rdee ruxyuu rbë́z men. Yra ménree rlaadet men zegne zëëd lo xley rrey-Roma, porke re men ne nuu ste rrey, laa men nga la Jesus. ");
INSERT INTO zpi_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Chene won mengyëz zenga yra men xtis, wzelo men noze rakrwid men. ");
INSERT INTO zpi_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Per wnegyizh xtis Jasón yra Jasón stebëd mén ne rlaleedx Jesucrist, lex wselaa xtis Jasón yra Jasón mén guin. ");
INSERT INTO zpi_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Zegne wnit lyu, wxaalgue yra mén ne rlaleedx Jesucrist Pabel yrup Pabel Silas za men axtegue Berea. Chene wdxiin men, wa men lenxeydoo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yra men-Israelree, wendee men ke lo mén ne nuu Tesalónica, porke rzhiilen men ron men ne rzëët Pabel no yzhe yzhendxee rool men lo xgyiich Dëdyuzh gan pe nli ne rzëët Pabel lo men. ");
INSERT INTO zpi_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Por neguin ndal mén guin wlaleedx Jesucrist no ndal ke men-griego wlaleedx Ne, nigle mgyeey, nigle wnaa ne non. ");
INSERT INTO zpi_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Per chene waknan yra men-Israel ne nuu Tesalónica ne le Pabel kazëët xdiiz Dëdyuzh no Berea, wa men nga, wsegyee men lextoo yra mén guin chen kwinyaan men Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Per wxaalgue yra men ne rlaleedx Jesucrist Pabel nes runisdoo, le Silas wyanre nga yrup Silas Timotew. ");
INSERT INTO zpi_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Yra mén ne zasan Pabel, axtegue Atenas wasan men Pabel. Ne wberee men, wkeeb Pabel diiz lo men ne tsague Silas yrup Silas Timotew lo Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Myentras ne kambë́z Pabel ne ydxiin Silas yrup Silas Timotew Atenas, axtegue nandet Pabel pe wuu lextoo Pabel ne wii Pabel ndal mdoo rap mengyëz guin. ");
INSERT INTO zpi_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Por neguin wa Pabel lenxeydoo men-Israel wazëët Pabel xkwent Jesucrist lo men-Israel no le lo tebëd mén ne nakdet men-Israel ne rzaknon ke Dëdyuzh, no yzhe yzhendxee razëët Pabelo lo mén ne rdxiintee lenlgyeey. ");
INSERT INTO zpi_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tebëd mén guin zanal zegne rneluu yra mén ne la epicúreos, le stebëd men zanal zegne rneluu yra mén ne la estoicos. Gwrol mén guin re: ―¿Pagox rzëët ménree ne kesentyent rnii men? Le stebëd men re: ―Zem xdiiz dëdyuzh ne rnebeeydet be rzëët men. Re men zenga, por ne kazëët Pabel xdiznzoon Jesucrist no por ne kazëët Pabel ne wban Ne. ");
INSERT INTO zpi_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Orguin wano men Pabel ledne la Areópago ledne rdop men yra men, lex wnabdiiz men lo Pabel, re men: ―¿Pe zak gaknan noo pezee nak yra dizkweb gwa ne kaneluu de? ");
INSERT INTO zpi_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Porke rzëët de diiz ne gardetlel gon noo; por neguin rlaan noo gaknan noo gan pe rna we. ");
INSERT INTO zpi_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Yra men-Atenas no le yra menzit ne nuu nga, tebegue zenga ka men noze rnetesu men tyemp rkagyedyag men ne kweb no ruu men diizo. ");
INSERT INTO zpi_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Lex wzuli Pabel gwrooltee lad men ne ndxin Areópago, re Pabel: ―Men-Atenas, por yra ne rwii noo ryenen noo ne kesentyent rzaknon de yra ne rlaa de xdëdyuzh de. ");
INSERT INTO zpi_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Porke or ne kawii noo lo yra ne rzaknon de, wzël te lwa lo noo ledne ka diiz ne re: “Dëdyuzh ne rnebeeydet be”. Dëdyuzhree ne rzaknon de sin ne rnebeeydet de Ne, laa xdiiz Ne nee kazëët noo lo de yra de. ");
INSERT INTO zpi_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Dëdyuzh wzhexkwaa gyëzlyu no le yrandxee ne nuu lo we, laa Ne rnebééy gyeybaa gyëzlyutee, no nuudet Ne lenydoo ne rzhexkwaa mén, ");
INSERT INTO zpi_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ni rkyiinden Ne gan txu gun xyudar Ne, porke laa Ne rseleedx gyelembán lo be, laa Ne rseleedx mee ne rgoob be no le yrandxee kos. ");
INSERT INTO zpi_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’No por tendxee mén wlaa Dëdyuzh ne nuu yralondxee mén chen tsuu men ydendxee gyëzlyu, no wsu Ne tyemp ne ybán te te mén no gan pa kwlotee tsuu men, ");
INSERT INTO zpi_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","chen ye men Dëdyuzh, mase noze ylaa men zegne rlaa ngwlëë, mase ni natet zu Ne lo te te mén. ");
INSERT INTO zpi_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Porke laa Ne rlaa ne mbán be, laa Ne rlaa ne rni be, laa Ne rlaa ne nuu be. Zegne wkaa ke tebëd menlaz de ledne re: “Zhiin Dëdyuzh nak be yra be.” ");
INSERT INTO zpi_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Por neguin belne che zhiin Dëdyuzh nak be, yët neguin ne tsuur lextoo be ne laa Dëdyuzh nak mdoo ne nak or, ne nak plat, ne nak gye, zegnak ne rzhexkwaa mén zegne rzaatee lextoo men. ");
INSERT INTO zpi_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Chekwlo noze wnetesu Dëdyuzh yra ne wlaa mén porke nandet men pe wlaa men, per orree ydendxee gyëzlyu rkyeen Ne yrandxee mén ne ysaan men xgyelmal men. ");
INSERT INTO zpi_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Porke che wsu Dëdyuzh te dxe ne gak gyelextis lo yrandxee mengyëzlyu no wzu Ne Jesucrist ne laa Jesucrist ylaa we. Chene wneban Ne Jesucrist, wbonyoo Ne ne laa Jesucrist ylaa we. ");
INSERT INTO zpi_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Chene won men ne wban mengut, tebëd men wzhidxno, le stebëd men re: ―Gan pa dxe yzëët de negwa lo noo ste. ");
INSERT INTO zpi_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Lex wruu Pabel lad men. ");
INSERT INTO zpi_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Per le stebëd men wlaleedx ne re Pabel, waktes men yra men Pabel. Lad mén guin nuu te men ne la Dionisio ne nuu lad men ne ndxin Areópago, no le te wnaa ne la Dámaris, no le ndalre mén. ");
INSERT INTO zpi_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Zhich guin wruu Pabel Atenas, za Pabel Corinto. ");
INSERT INTO zpi_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nga wtsëlo Pabel te men-Israel ne la Aquila ne wal lo lyu ne la Ponto; gyed wruundxee men Italia, wdxiin men nga yrup men lzaa men Priscila, porke wkyeen rrey-Claudio ne yruu yrandxee men-Israel Roma. Lex wa Pabel ruxyuu men. ");
INSERT INTO zpi_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kom dxiin ne rlaa men nak ne rzhexkwaa men carpa, dxiin ke guin rlaa Pabel, por neguin wkaa Pabel lo men, wkalaa Pabel dxiin yra Pabel men. ");
INSERT INTO zpi_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Te te dxe ne rne men-Israel, ra Pabel lenxeydoo men-Israel rzëët Pabel xdiiz Dëdyuzh no rye Pabel gan pezee ylaleedx méno, nigle men-Israel, nigle mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Chene wruu Silas yrup Silas Timotew Macedonia ne wdxiin men lo Pabel, che teblose xdiiz Dëdyuzh wkazëët Pabel lo mén no re Pabel lo men-Israel ne laa Jesus nak Crist. ");
INSERT INTO zpi_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Per wzelo yra mén guin winyaan men Pabel no wninyaan men lo Pabel. Lex wbib xab Pabel zegnak te beey ne nadet men guin nyon men ne rzëët Pabel, no re Pabel lo men: ―Laake de yra de rap dol ne gak de perdid nes lo Dëdyuzh, let noodet rap dol. Desde nedxeree le noo tsazëët xdiiz Dëdyuzh lo mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Lex wruu Pabel lenydoo guin, wa Pabel ruxyuu te mgyeey ne la Ticio Justo ne rzaknon Dëdyuzh no ne zob xyuu guex koo ydoo. ");
INSERT INTO zpi_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nga nuu te mén ne la Crispo ne rnebééy lenydoo guin, wlaleedx Crispo Jesucrist yra xfamilyendxee Crispo, no ndal ke men-Corinto wlaleedx Ne chene won men ne wzëët Pabel, lex wrobnis men. ");
INSERT INTO zpi_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Te gyëël wzak Pabel zegnak men ne rnexgyëëlen, wnii Dëdyuzh lo Pabel, re Ne: ―Ydxedet de; gukaar guzëët xdiiz noo lo mén, ysoowdet lextoo de, ");
INSERT INTO zpi_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","porke noo raknonen de; rut gundet gan yzakzi de. Ndal mén ne ylaleedx xdiiz noo rap noo nee gyëzree. ");
INSERT INTO zpi_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Por neguin wkaa Pabel Corinto te izgwrol, wkaneluu Pabel xdiiz Dëdyuzh lo yra mén guin. ");
INSERT INTO zpi_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Per chene wak Galión gobernador Acaya, wdop men-Israel, waken men yra men wnëëz men Pabel, lex wano men Pabel lenyuloow, ");
INSERT INTO zpi_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","re men lo Galión: ―Ménree ka kaneluu ne saknon mén Dëdyuzh zegne zëëdetlel lo xley noo. ");
INSERT INTO zpi_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Che za Pabel nnii Pabel, chene wke Galión, re Galión lo mén guin: ―Belne wlaa men te gyii o te ne ndxeeb, zenga si zukas noo de yra de. ");
INSERT INTO zpi_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Per belne por kwent ne rneluu men nako, no por kwent ne rzëët men la te mén, no por kwent ne rlaadet men zegne zëëd lo xley de, laake de gulaxnëzo. Rlaandet noo ylaa noo gyelextis gwa. ");
INSERT INTO zpi_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Lex wboo Galión yra men guin lenyuloow. ");
INSERT INTO zpi_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Orguin wnëëz yra men-griego Sóstenes ne rnebééy lenxeydoo men-Israel, wdee men xkwent Sóstenes nes ruxyuloow Galión; per ni wukasdet Galión men. ");
INSERT INTO zpi_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Xcher wkaa Pabel Corinto. Zhich guin re Pabel lo yra xkompanyer Pabel ne rlaleedx Jesucrist: “Le noo gya naa.” Per chene wdxiin Pabel Cencrea, wgaa Pabel xtoo Pabel porke che wun Pabel kumplir ne wkebgyee Pabel lo Dëdyuzh. Lex wuu Pabel bark yra Pabel Priscila no le Aquila, za Pabel lo lyu ne la Siria. ");
INSERT INTO zpi_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Chene wdxiin Pabel Efeso, nga wsan Pabel Priscila no le Aquila, le Pabel wa lenxeydoo men-Israel ne zob nga, wnii Pabel lo yra men-Israel ne rdop lenydoo guin. ");
INSERT INTO zpi_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Lex wnab men lo Pabel ne ykaar Pabel nga, per nadet Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ne wruu Pabel nga, re Pabel lo men: ―Rap noo degne Jerusalén tee noo lni ne zëëd. Belne yna Dëdyuzh yberee ke noo ste, chiid noo wii lo de yra de. Lex wuu Pabel bark, wruu Pabel Efeso. ");
INSERT INTO zpi_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Chene wdxiin Pabel Cesarea, wa Pabel Jerusalén wagabtyuzh Pabel yra mén ne rlaleedx Jesucrist; zhich guin za Pabel Antioquía. ");
INSERT INTO zpi_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Chene che wakxche ka Pabel Antioquía, wruu Pabel ste, wa Pabel gyëz por gyëz ne nak lo lyu ne la Galacia no le lo lyu ne la Frigia, waguur Pabel lextoo yra mén ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tyemp guin wdxiin te men-Israel gyëz-Efeso, Alejandría wal men, Apolos la men. Kesentyent rap men diiz rnii men no kesentyent nan men xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Che wen wenendxee wseed men xdiiz Dëdyuzh, no kesentyent rzhiilen men rzëët men no rneluu men zegnak nakendxee xkwent Jesus lo mén, mase nonchee kwent ne wtxobnis Xwa mén nan men. ");
INSERT INTO zpi_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Wdxedet Apolos wzelo Apolos wzëët Apolos xdiiz Dëdyuzh lenxeydoo men-Israel; per chene won Priscila yrup Priscila Aquila ne rzëët Apolos, wano men Apolos tebkoo, wzëët men zegnak nakendxee xdiiz Dëdyuzh lo Apolos. ");
INSERT INTO zpi_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Chene re Apolos ne le Apolos tsa Acaya, wguu yra mén ne rlaleedx Jesucrist lextoo Apolos ne tsa Apolos, lex wkaa men te gyiich wxaal men lo yra mén ne rlaleedx Jesucrist nga chen wen gak men lo Apolos. Chene wdxiin Apolos Acaya, kesentyent wun Apolos xyudar yra mén ne rlaleedx Jesucrist, ");
INSERT INTO zpi_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","porke nes lo yra mén re Apolos ne ngyidet ne rzëët men-Israel, no ni te mén wkedet porke nli neguin ne re Apolos, no nes lo men yra men wool Apolos lo xgyiich Dëdyuzh ledne zëëd xkwent Crist, wzëët Apolos ne Jesus nak Crist. ");
INSERT INTO zpi_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Myentras ne ka Apolos Corinto, le Pabel wa yra gyëz ne nak nes gyeey, wdxiin Pabel Efeso ledne nuu tebëd men ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Lex wnabdiiz Pabel lo men, re Pabel: ―¿Pe wkakwent de Espíritu Sant chene wlaleedx de Jesucrist? Wke men re men: ―Ni gardet gon noo ne nuu Espíritu Sant. ");
INSERT INTO zpi_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Lex wnabdiiz Pabel lo men ste, re Pabel: ―¿Pezee nak gyelrobnis ne wrobnis de yra de bes? Wke men re men: ―Gyelrobnis ne wneluu Xwa. ");
INSERT INTO zpi_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Lex re Pabel lo men: ―Wtxobnis Xwa mén ne wsaan xgyelmal, per re Xwa lo men ne rap men degne ylaleedx men men ne gyed zëëd; laa mén guin nga nak Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Chene wluzhse won men neree, wrobnis men por la Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","No chene wxob nya Pabel xtoo men, waknonen Espíritu Sant men yra men, lex wzelo men wnii men ste klas diiz no wzëët men diiz ne wguu Dëdyuzh lextoo men. ");
INSERT INTO zpi_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Zeg chibtxup nak yra mgyeey guin. ");
INSERT INTO zpi_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tson mëëw wa Pabel lenxeydoo men-Israel, wkazëët Pabel xdiiz Dëdyuzh lo men sin ne wdxedet Pabel; wye Pabel gan pezee ylaleedx men logne rkyeen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Per wakndíp lextoo men gwrol men, nadet men nlaleedx men xdiiz Jesucrist, lel wzelo men rnii men dizmal por xdiiz Jesucrist nes lo yra mén. Orguin wruu Pabel lad men yra Pabel men ne che rlaleedx xdiiz Jesucrist, wano Pabel men lenxyulowskwel te mén ne la Tiranno. Nga wzëët Pabel xdiiz Jesucrist lo men yzaandxee dxe. ");
INSERT INTO zpi_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Zenga wkaa Pabel txup iz, ne le yra mén ne nuu Asia won xdiiz Jesucrist, nigle men-Israel, nigle mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","No por xpoder Dëdyuzh wlaa Pabel gyelmilaguer ne nzoon. ");
INSERT INTO zpi_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Axtegue bayles o lër ne rdee led Pabel, reey méno por mengyiz no ryaken mengyiz no rruu menzab ne nuu lextoo men. ");
INSERT INTO zpi_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Lex neguin no tebëd men-Israel ne zad ka rboo menzab lextoo mén wlaan nkyiinen la Jesus, re men lo menzab: ―Por la Jesus ne rzëët Pabel, ykyeen noo de ne yruu de lextoo ménree. ");
INSERT INTO zpi_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Laa yra guedx xpee te men-Israel ne la Esceva ne nak te fxuz ne rnebééy lo yra fxuz nak ne wlaa neree. ");
INSERT INTO zpi_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Per te chene kalaa men neree, wke te menzab, re menzab lo yra mén guin: ―Rnebeey noo Jesus, no nan noo gan txu nak Pabel, per laa de yra de, ¿txu nak de? ");
INSERT INTO zpi_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Orguin wyab mgyeey ne nuu menzab lextoo led yra mén guin; kom kesentyent ndíp men, wun men gan lo yra mén guin; kesentyent wdee men xkwent men; por neguin wruu yra mén guin ruyuu guin, noze rzhoon men, noze bëël men, noze nloo men ren. ");
INSERT INTO zpi_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kesentyent wdxe yrandxee mén ne nuu Efeso ne waknan men neree, nigle men-Israel, nigle mén ne nakdet men-Israel; wzelo men wzaknon men Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","No ndalyaa mén ne che wlaleedx Jesucrist wa wxobdol nes lo yrandxee mén yra ne mal ne wlaa men. ");
INSERT INTO zpi_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","No ndal ke mén ne wseed gyelebruj wdxiin wdxinneey xliber, lex wzeey meno nes lo yrandxee mén. Chene wboo men kwent, non yra liber guin zeg txupchiimil med plat. ");
INSERT INTO zpi_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Zenga wrëëtsre xdiiz Jesucrist no waknyoo ne rapo poder. ");
INSERT INTO zpi_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Chene che wluzh wak yra neree, wzoob xtoo Pabel ne tsa Pabel Jerusalén, per primer tsa Pabel Macedonia no le Acaya. No re Pabel ne chene che wa Pabel Jerusalén, rap Pabel degne tsa Pabel no Roma. ");
INSERT INTO zpi_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","No wxaal Pabel txup men ne run xyudar Pabel za men Macedonia, Timotew no le Erasto, le Pabel wyanre Asia. ");
INSERT INTO zpi_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Cheguin ke wzelo men-Efeso wlaa men te rwidroo por ne rwinyaan men xdiiz Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Wlaa men rwidroo guin por xdol te mgyeey ne la Demetrio ne rzhexkwaa kos ne plat; rzhexkwaa men ne rzaglo xeydoo mdoo ne la Diana. Kesentyent run men gan med yra men mén ne rlaa dxiin lo men. ");
INSERT INTO zpi_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Lex wtop men tebëd mén ne rlaa dxiin ke guin, re men lo yra mén guin: ―Adxii, che nan de ne kesentyent run be gan med lo dxiinree. ");
INSERT INTO zpi_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Per orree rwii de yra de no ron de ne ka te mén ne la Pabel kazëët men lo mén ne mdoo ne rzhexkwaa mén nakdeto dëdyuzh; zenga wun men gan wlaleedx mén ne rzëët men, let nozdet nee Efeso rzëët meno sinke ydendxee Asia. ");
INSERT INTO zpi_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Por neguin ndxeeb luzh xdxiin be, no let nozdet xdxiin be luzh, sinke no xeydoo mdoo ne non ne la Diana, tsukasdetre méno. Zenga luzh yra xgyelnon mdooree ne rzaknon yrandxee mén ne nuu ydendxee Asia no le mén ne nuu ydendxee gyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Chene won men zenga yra men, kesentyent wlayaa men, wzelo men rderëz men, re men: ―¡Kesentyent non xemdo-Diana be ne nak be men-Efeso! ");
INSERT INTO zpi_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kesentyent ntoz rlaa yra mengyëz guin. Wnëëz men txup men-Macedonia ne nak xkompanyer Pabel, Gayo no le Aristarco, wgobzengye men men yrup men, wdxinno men men ledne ruu junt gyëz. ");
INSERT INTO zpi_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Wlaan Pabel nyatee Pabel lad men chen nnii Pabel lo mén, per wdeedet yra mén ne rlaleedx Jesucrist si. ");
INSERT INTO zpi_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Axtegue no txup tson xtis-Asia ne nak xmig Pabel wxaal diiz lo Pabel, wnab men ne tsateedet Pabel nga. ");
INSERT INTO zpi_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Yra mén guin ne ndxin nga noze wren wren ne rderëz men, ntoz rlaa men yra men, no ndal mén axtegue ni nandet men gan pe kwentzhe wdop men nga. ");
INSERT INTO zpi_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Lad yra menroo menduxtee guin wboo men-Israel te mén ne la Lej, wdxig men Lej nes lo yra mén guin. Lex wlisgya nya Lej chen gyakchi yra men guin, chen ynii Lej por men-Israel nes lo yra mengyëz. ");
INSERT INTO zpi_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Per chene wdee men kwent ne men-Israel ke nak Lej, zeg txup or tese wderëz yra mén guin, re men: ―¡Kesentyent non xemdo-Diana be ne nak be men-Efeso! ");
INSERT INTO zpi_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Chene wun mén ne nak sekretarye gyëz guin gan ne wnegyakchi men yra mén guin, re men: ―Men-Efeso, yrandxee mén ne nuu ydendxee gyëzlyu nan ne gyëzree rapkwent xeydoo Diana xemdonzoon be ne wruu gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Che wen nan de ne nli neree; che we naa, ylaadet de kos sin ylebleedxdet de. ");
INSERT INTO zpi_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Porke ménree ne zëdno de nee bet ne mal wlaadet men ydoo ni bet diznyaan rniidet men por xemdoo be. ");
INSERT INTO zpi_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Belne nuu pe rdil Demetrio ste mén yra Demetrio xkompanyer Demetrio ne rlaa dxiin gwa, por neguin zob yuloow no por neguin nuu xtis, wa tsalaxnëz men xdil men. ");
INSERT INTO zpi_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Per belne nuu ste kos ne rlaan de gak, chene tsuu te xjunt mengyëz, cheguin gakxnëzo. ");
INSERT INTO zpi_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Yra neree ne wak orree ndxeebo por laa be yra be ne ykagyii mén be, yna men laa be wneselo we; naap nandet be gan pe gue be gan pe kwentzhe wako. ");
INSERT INTO zpi_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Wluzhse re men zenga, wrëëts men yra men. ");
INSERT INTO zpi_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Chene che wyakchi yra mén guin, wbëz Pabel yra mén ne rlaleedx Jesucrist chen ynino Pabel men. Wluzh nga re Pabel lo men ne le Pabel wal gya, lex za Pabel lo lyu ne la Macedonia. ");
INSERT INTO zpi_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Wa Pabel ydendxee lo lyu guin, kesentyent wguu Pabel lextoo yra mén ne rlaleedx Jesucrist kon yra diiz ne re Pabel, lex wdxiin Pabel lo lyu ne la Grecia. ");
INSERT INTO zpi_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tson mëëw wkaa Pabel nga. Che nuu Pabel ne tsuu Pabel bark chen nya Pabel lo lyu ne la Siria, chene waknan Pabel ne le yra men-Israel rlaan yzakzi Pabel. Mazdee wguu lextoo Pabel tsa tee ke Pabel lo lyu ne la Macedonia ste. ");
INSERT INTO zpi_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Wanal guedx mén Pabel; laa men nga nak: Sópater men-Berea xpee Pirro, no le stxup men-Tesalónica Aristarco no le Segundo, no le Gayo men-Derbe, no le Timotew, no le stxup men-Asia Tíquico no le Trófimo. ");
INSERT INTO zpi_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Per nëz wzanergue yra menree wkambë́z men noo Troas yrup noo Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Le noo wyanre Filipos yrup noo Pabel; axtegue ne wdesu lni ne ru mén gyëtxtil ne nootsdet lebadur, kon bark wruu noo nga; ne wzaa gaay gbiz wdxiin noo Troas ledne kambë́z men noo. Nga wkaa noo guedx gbiz yra noo men. ");
INSERT INTO zpi_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Dxe ne rzelo xman, wdop noo yra noo chen guxsëë noo zegne wkyeen Jesucrist. Kom che nuu Pabel ne yruu Pabel yra gyëël guin, axtegue gwrool gyëël le Pabel benak kanii lo mén. ");
INSERT INTO zpi_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ndal bnii zobkaa pisgya ledne ndxin noo yra noo. ");
INSERT INTO zpi_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nga zob te menyu ne la Eutico te rumdan. Kom che wakxche kanii Pabel, wundetre menyu guin wantar mkaal, wkanet men mkaal, wxenxtoo men rumdan ne wyon pis. Che wetlel men chene wlis mén men. ");
INSERT INTO zpi_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Orguin wyët Pabel, wzhoob Pabel led men, wgyeedx Pabel men, lex re Pabel lo yra mén: ―Ydxedet de; mbán men. ");
INSERT INTO zpi_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Lex wberee Pabel wyeep ke Pabel ste. Wla Pabel gyëtxtil wu Pabel yra Pabel men guin. Wluzh nga wniir Pabel lo men axtegue ne wyenii lyu; lex wka Pabel nëz za Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Le menyu guin ne wxenxtoo rumdan, syano mén men mbán men. Kesentyent rzhiilen men yra men. ");
INSERT INTO zpi_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Le noo yra noo wuu bark wzanergue noo za noo Asón; nga ytsëlo noo Pabel zegne wyan noo diiz yra noo Pabel, porke laa Pabel wlaan za por lyu. ");
INSERT INTO zpi_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Chene wtsëlo noo Pabel Asón, wdee Pabel lenbark ne nuu noo, wa noo Mitilene yra noo Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wruu noo nga; wra gyëël wdxiin noo ngali lyu ne la Quío ne ka lo nisdoo. Wra ste gyëël wdxiin noo lo lyu ne la Samos ne ka ke lo nisdoo; wra ste gyëël guin wdxiin noo Mileto; per antes ne ydxiin noo Mileto, wne noo Trogilio. ");
INSERT INTO zpi_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Porke che wlebleedx Pabel ne noze tesu Pabel Efeso, chen gakdet Pabel tras Asia, porke rlaan Pabel ne gyob ydxiin Pabel Jerusalén. Nuu lextoo Pabel gan pe gundet Pabel gan ydxiin Pabel Jerusalén chen gan Pabel lni Pentecostés nga. ");
INSERT INTO zpi_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Chene ka noo Mileto yra noo, wkyeen Pabel ne chiid yra men-Efeso ne rnebééy lo yra men ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Chene wlenza men, re Pabel lo men: ―Che nan de yra de pezee kalaa noo desde dxe ne wlenza noo Asia axtegue nedxeree. ");
INSERT INTO zpi_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nunk wugyadet lextoo noo ydeblo ne kalaa noo xdxiin Jesucrist lad de, axtegue roon noo, no noze ndal ne kazak noo por yra ne kalaa men-Israel noo. ");
INSERT INTO zpi_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Per mase zenga, wsalzaandet noo ne rzëët noo ne wen por laa de yra de; wneluu noo we nes lo yrandxee mén no wneluu noo we yuu por yuu. ");
INSERT INTO zpi_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nigle lo men-Israel, nigle lo mén ne nakdet men-Israel, che re noo ne ysaan men xgyelmal men no ylaleedx men Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Orree le noo tsa Jerusalén porke laa Espíritu Sant rxaal noo, ni nandet noo gan pe sak noo no. ");
INSERT INTO zpi_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nonchee ne nan noo ne yrandxee gyëz ledne ra noo, na Espíritu Sant lo noo ne kesentyent yzakzi mén noo no sguu men noo chegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Per ni zadeto lextoo noo, ni xgyelembán noo rkaadet lextoo noo, nonchee ne rlaan noo nak ne yseyal noo dxiinree ne wseleedx Jesucrist lo noo ne yzëët noo diznzoon ne wseleedx Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Gukwii gante; che nan noo ne ni ste de zegne won de ne wzëët noo logne rkyeen Dëdyuzh, kwiidetre de noo. ");
INSERT INTO zpi_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Por neguin yna noo lo de orree, rapdetre noo dol logne sak de. ");
INSERT INTO zpi_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Porke che wzëët noo yrandxee ne rlaan Dëdyuzh ne ylaa de, bet wgyixlaandet noo lo de. ");
INSERT INTO zpi_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Por neguin gugapkwent de laake de no gugapkwent yra mén ne wniiz Espíritu Sant lo de yra de, porke laa Ne wzu de ne gapkwent de yra men ne nak xpén Jesucrist ne wka Jesucrist kon xren Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Che nan noo ne chene che sya noo, schiid tebëd mén ne ylaan yluzh xpén Jesucrist zegne rlaa lob mëkzhiil. ");
INSERT INTO zpi_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","No lad ke de yra de yruu tebëd mén ne yneluu ne nlidet, chen gun men gan tsanal yra mén ne rlaleedx Jesucrist ne rneluu men. ");
INSERT INTO zpi_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Por neguin list gugak yra de; gunileedx ne ydeblo tson iz dxe gyëëltee wsalzaandet noo ne wnino noo de te te de, axtegue woon noo. ");
INSERT INTO zpi_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Orrenaa, ysan noo de yra de ledxnya Dëdyuzh. Gutsukas xdiiz Ne ne rap poder chen guno xyudar de gakfwert de no chen no lo de yniiz Ne ne che re Ne ne ydee Ne lo yra mén ne nak xpén Ne. ");
INSERT INTO zpi_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Noo rut xmed rdebden noo, ni rut xab rdebden noo. ");
INSERT INTO zpi_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Laa de yra de nanwen de ne noo zhal wdxinaa ne wu noo yra noo men ne wun xyudar noo. ");
INSERT INTO zpi_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Che wluu noo lo de yra de ne zenga rap de degne ylaa de dxiin no gun de xyudar yra mén ne yët ne ykyiinen; gukanzaleedx xdiiz Jesucrist chene re Ne: “Mazre nzoondee mén ne rgueed ke mén ne reeden.” ");
INSERT INTO zpi_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Chene wluzhse re Pabel zenga, wzuzhib Pabel wnab Pabel lo Dëdyuzh yra Pabel mén guin. ");
INSERT INTO zpi_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kesentyent woon men yra men, wgyeedx men Pabel, woo men bzhid gyedkwes Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kesentyent wunles lextoo men por ne re Pabel lo men ne kwiidetre men Pabel. Orguin wasan men Pabel axtegue ledne zob bark. ");
INSERT INTO zpi_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nga wyan men yra men, le noo wuu bark yra noo wa noo tebli lyu ne la Cos ne ka lo nisdoo. Ne wra ste gyëël wdxiin noo lyu ne la Rodas ne ka ke lo nisdoo; nga wruu noo wa noo Pátara. ");
INSERT INTO zpi_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nga zu te bark ne tsa lo lyu ne la Fenicia, bark guin wuu noo yra noo za noo. ");
INSERT INTO zpi_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Chene za noo, wii noo Chipre lyu ne ka lo nisdoo; por ladbëë we wdesu noo, za noo Siria. Per kom rap bark degne ysano yúú Tiro, por neguin wdee noo nga. ");
INSERT INTO zpi_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nga wtsëlo noo yra mén ne rlaleedx Jesucrist, lex wkaa noo lo men guedx gbiz. Por Espíritu Sant waknan men ne sak Pabel Jerusalén; por neguin re men lo Pabel ne tsadet Pabel Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Per chene wzaa guedx gbiz, wruu noo nga yra noo. Wa men yra men xewnaa men no le yra men zhiin men wazanëz men noo axtegue runisdoo ne nak rulgyëz guin. Nga wzuzhib noo yra noo men wnab noo lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Lex re noo lo men: “Le noo gya naa.” Zhich guin wdee noo lenbark, le laa men wberee ruxyuu men. ");
INSERT INTO zpi_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ne wruu noo Tiro, wa noo Tolemaida; ngatee wyal wuu noo lenbark yra noo. Ne wruu noo lenbark, wa noo wagabtyuzh noo yra mén ne rlaleedx Jesucrist, lex wkaa noo lo men tebdxe. ");
INSERT INTO zpi_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wra ste gyëël wruu noo nga yra noo Pabel wdxiin noo Cesarea, wa noo ruxyuu Blib men ne rzëët xdiznzoon Jesucrist. Blib guin nak te men ne nuu lad guedx men ne wzël ne rgyiiz ne ru yra mén ne yët ne ykyiinen. Ruxyuu men wkaa noo yra noo. ");
INSERT INTO zpi_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Rap men tap zhinzaap men ne gardet ytsëlnya, ydap nzeb rzëët lo mén diiz ne rguu Dëdyuzh lextoo nzeb. ");
INSERT INTO zpi_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Che ndal gbiz ka noo ruxyuu Blib chene wlenza te profet ne la Agabo ne wruu lo lyu ne la Judea; ");
INSERT INTO zpi_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","zëëd men wii lo noo yra noo. Zegne wlenza men, wnëëz men xsinturon Pabel wliib men yrup nii men no le yrup nya men, lex re men: ―Zere na Espíritu Sant, zeree yliib men-Israel men ne nak neree xsinturon lenlgyëz-Jerusalén, lex ydekwent men men lo yra mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Chene won noo zenga, wnab noo lo Pabel yra noo mén ne nuu nga ne tsadet Pabel Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Wke Pabel, na Pabel: ―¿Penak roon de yra de, rgunles de lextoo noo? Por noo nyaalzhe yliib mén noo no let nozdet yliib men noo, sinke nyaalzhe axtegue yket men noo Jerusalén por ne rzëët noo xdiiz Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Wyenense noo yra noo ne wundet noo gan nsoow noo Pabel, betre redet noo, nunegue ne re noo: ―Gak zegne rlaan Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Zhich guin wzhexkwaa noo xyúú noo yra noo, lex za noo Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wzanal txup tson men-Cesarea noo, men ne rlaleedx ke Jesucrist. Laa men wano noo ruxyuu te men-Chipre ne la Mnasón ne che wakxcheroo rlaleedx Jesucrist; ruxyuu men wbë́z noo yra noo. ");
INSERT INTO zpi_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kesentyent rzhiilen yra men-Jerusalén ne rlaleedx Jesucrist ne wdxiin noo Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wra gyëël, wa noo wii lo Jacob yra noo Pabel; nga ndxin yra mén ne rnebééy lo yra men ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Chene wluzh wgabtyuzh Pabel men, wuu Pabel diiz lo men axtegue zegnak nakendxee yra ne wlaa Pabel por xpoder Dëdyuzh nes lo yra mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Chene won men zenga, wzaknon men Dëdyuzh, lex re men lo Pabel: ―Zhanbech, che nan de ne kesentyent ndalyaa men-Israel ne che rlaleedx Jesucrist nuu, no yrandxee men rkyeen ne rap be degne ylaa be zegne zëëd lo ley ne wdee Dëdyuzh lo Moises. ");
INSERT INTO zpi_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","No won men diiz ne laa de ka rneluu yra men-Israel ne nuu lad mén ne nakdet men-Israel ne ylaadet men zegne zëëd lo ley, rzëët de lo men ne guudet men zhiin men beey ne ruu men-Israel, ni tsanaldet men xkoxtumber be. ");
INSERT INTO zpi_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Orrenaa, ¿pezee ylaa be? Porke sdopleenendxee men chene gaknan men ne wlenza de. ");
INSERT INTO zpi_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mazre gulaa zeree zegne yna noo lo de: Nee lad noo nuu tap mén ne rap degne ylaa ne wkebgyee men lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Gutsano men, gulaa zegne zëëd lo ley yra de men, no gyizh de zegne ygaa xtoo men, chen zenga gyenen mén ne nlidet yra diiz ne rnii mén por laa de porke rlaa de zegne zëëd lo ley. ");
INSERT INTO zpi_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Le por yra mén ne nakdet men-Israel ne che rlaleedx Jesucrist, che wkaa noo te gyiich wxaal noo lo men zegne wyan be diiz ne tsadet lextoo men yra ne zëëd lo ley. Nonchee ne re noo si nak ne gudetre men ne che wseleedx mén lo mdoo, ni gudet men ren, ni gudet men xbëël maa ne rxedet ren, ni ykanodetgue men xkompanyer men belne gardet ytsëlnya men. ");
INSERT INTO zpi_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Orguin wzano Pabel ydap mén guin; wra gyëël, wlaa Pabel zegne zëëd lo ley yra Pabel men, lex wdeno Pabel men lenxeydoo Dëdyuzh chen yluu men diiz gan pa dxe yzaa ne ylaa men ne zëëd lo ley te te men ne yket men maa yseleedx men ma por Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Per chene che mer yzaa guedx gbiz ne rap men degne ylaa men zegne zëëd lo ley, ne wii txup tson men-Israel ne wruu gyëz ne nak lo lyu ne la Asia ne le Pabel zu lenxeydoo Dëdyuzh, wzelo men wlaa men te rwidroo. Wnëëz men Pabel, ");
INSERT INTO zpi_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","wkarëzyaa men, re men: ―¡Men-Israel, gugun xyudar noo! Laa ménree nga nak ne zad ka yrandxee lugar rneluu men mén kos ne nuu konter por menlaz be no le por ley ne wdee Dëdyuzh lo Moises no le por xeydoo Dëdyuzh. Orrenaa le men wdee txup tson mén ne nakdet men-Israel lenxeydoo Dëdyuzh, rgyitno meno no nda we. ");
INSERT INTO zpi_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Re men zenga yra men porke wii men za Pabel lenlgyëz-Jerusalén yrup Pabel te men-Efeso ne la Trófimo; por neguin nuu lextoo men ne no Trófimo wdee Pabel lenxeydoo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Orguin noze nesree nesrotee rruu yra mengyëz guin, noze rzhoon men wdxiin men wnëëz men Pabel, wgobzengye men Pabel, wboo men Pabel lenxeydoo Dëdyuzh; noze ryob rdxiintee wtsëë men yra yaglaa ydoo. ");
INSERT INTO zpi_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Che mer yket men Pabel chene wdxiin diiz lo xkomandant soldad ne le yra men-Jerusalén kalaa te rwidroo. ");
INSERT INTO zpi_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Orgueguin wtop komandant yra soldad no le yra kapitan, lex noze rzhoon men za men yra men ledne ndxin yra mén guin. Chene wii yra mén guin ne wdxiin komandant yra komandant soldad, wdeedetre men xkwent Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Orguin wbig komandant wnëëz komandant Pabel, lex wkyeen komandant soldad wliib men Pabel kon txup kaden no wnabdiiz komandant gan txu nak Pabel no gan kox wlaa Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Noze wren wren ne rderëz yra mén guin; por tant rderëz men, wdeedet komandant kwent gan kox rnii men, lex wkyeen komandant ne tsano soldad Pabel ledne nuu yra soldad. ");
INSERT INTO zpi_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Chene wdxiin soldad nga ne gyeep soldad lo skaler, wap soldad degne weey soldad Pabel tant ntoz rlaa yra mén guin ");
INSERT INTO zpi_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ne zanal, rderëz men, re men: ―¡Guket men! ");
INSERT INTO zpi_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Chene le men wal ysee Pabel ledne nuu yra soldad, wnabdiiz Pabel lo komandant, re Pabel: ―¿Pe zak yna noo txup tson diiz lo de? Wke komandant, re komandant: ―¿Pe run de gan rnii de diz-griego? ");
INSERT INTO zpi_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Pe let laadet de nga nak men-Egipto ne wtsëldil gobyeren, lex wa de nes denbidx wano de tapmil men ne rket mén? ");
INSERT INTO zpi_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Lex re Pabel: ―Men-Israel nak noo, Tarso wal noo, te gyëz ne beendxegue non ne nak lo lyu ne la Cilicia. Gulaa fabor guniiz si ynii noo lo yra ménree. ");
INSERT INTO zpi_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Orguin wdee komandant si wnii Pabel. Wzuli Pabel lo skaler, wluu Pabel senye kon nya Pabel lo yra mén guin ne kwinchi men. Chene che wbinchi men, wnii Pabel diz-hebreo lo men, re Pabel: ");
INSERT INTO zpi_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","―Zhanbech no laa de yra de dechey, gugon ne yna noo chen ykagyiidetre de noo. ");
INSERT INTO zpi_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Chene won men wnii Pabel diz-hebreo, mazre wbinchi men, lex re Pabel lo men: ");
INSERT INTO zpi_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","―Men-Israel nak noo, Tarso wal noo gyëz ne nak lo lyu ne la Cilicia, per nee Jerusalén wroo noo; laa maxter Gamaliel wneluu noo yrandxee zegne zëëd lo xley xpenkwlal be. Teblose xdxiin Dëdyuzh rlaa noo zegne rlaa ke do yra de orree. ");
INSERT INTO zpi_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Chekwlo wkanal noo yra mén ne rlaleedx Jesucrist axtegue wket noo men gwrol men; wnëëz noo mgyeey wnaatee wsee noo men chegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Laa fxuz ne mazre nondee no le yra men ne rnebééy lo men-Israel nan ne nli neree. Porke laa men wniiz gyiich weey noo chen yluu noo we lo yra menlaz be ne nuu Damasco, lex wa noo waye noo yra mén ne rlaleedx Jesucrist nga, chen ynëëz noo men yliib noo men, chidno noo men Jerusalén chen tsuu xkastig men. ");
INSERT INTO zpi_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Per chene za noo nëz ne che guex ydxiin noo Damasco zeg rwen ngbiz, tebegue wruu te bnii gyeybaa, kesentyent wkabtsa we kbii ledne za noo. ");
INSERT INTO zpi_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Orguin wkantaa noo lyu, lex won noo te rëz ne na lo noo: “Saulo, Saulo, ¿penak rwinyaan de noo?” ");
INSERT INTO zpi_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Lex wnabdiiz noo, re noo: “¿Txu laa de Dechey?” Wke rëz guin, na we: “Noo nak Jesus zhan-Nazaret ne rlaandet de kwii de.” ");
INSERT INTO zpi_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wii yra mén ne zano noo bnii guin, per wdeedet men kwent gan pe rna diiz ne na rëz guin lo noo. ");
INSERT INTO zpi_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Lex wnabdiiz noo, re noo: “Dechey, ¿pagox rap noo degne ylaa noo?” Orguin na Ne lo noo: “Gutsaxee, gugyuli ke xnëz de gutsa Damasco. Nga yna mén yrandxee logne rap de degne ylaa de.” ");
INSERT INTO zpi_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kom tant wkabtsa bnii guin, wsan ngwlëë we noo, lex wgoob yra mén ne zano noo nya noo wdxinno men noo Damasco. ");
INSERT INTO zpi_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Nga nuu te mén ne la Ananías ne rlaa yrandxee zegne zëëd lo ley ne wdee Dëdyuzh lo Moises. Yrandxee men-Israel ne nuu nga rzëët ne xnëz mbán Ananías. ");
INSERT INTO zpi_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Laa Ananías wdxiid wii lo noo; zegne wlenza Ananías, na Ananías: “Saulo, gyenii bzalo de ste.” Orgueguin wyenii bzalo noo, wii noo Ananías. ");
INSERT INTO zpi_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","No na Ananías lo noo: “Laa XDëdyuzh xpenkwlal be wye de chen gaknan de logne rlaan Ne ne ylaa de no chen kwii de Crist no chen gon de xrëz Ne. ");
INSERT INTO zpi_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Porke laa de tsazëët xdiiz Ne lo yrandxee mén no gu de diiz yra ne wii de no yra ne won de. ");
INSERT INTO zpi_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Orrenaa, ¿pagox rbë́z de? Gusuli, gurobnis, no gusaan ne rlaa de dol, gunab lo Jesucrist.” ");
INSERT INTO zpi_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Chene wberee noo nee Jerusalén, wa noo lenxeydoo Dëdyuzh wanab noo lo Ne, tebegue wzak noo zegnak men ne rnexgyëëlen. ");
INSERT INTO zpi_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Wii noo Jesucrist, na Ne lo noo: “Gyiid gyiidske guseyob guruu Jerusalén, porke tsukasdet mén ne yzëët de por noo.” ");
INSERT INTO zpi_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Lex re noo lo Ne: “Dechey, che nan men ne noo wa yrandxee lenydoo, wnëëz noo yra mén ne rlaleedx de wsee noo men chegyiib no wdee noo xkwent men. ");
INSERT INTO zpi_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Chene wket mén Xteb ne wzëët xdiiz de, no noo zu nga, wyan noo byen ne yket mén Xteb; noo wapkwent xab yra mén ne wket Xteb.” ");
INSERT INTO zpi_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Per na Ne lo noo: “Guruu, porke sxaal noo de tsa de lo yra mén ne nakdet men-Israel ne nuu nat.” ");
INSERT INTO zpi_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Kwlote nga wkagyedyag yra mén guin ne re Pabel, lex wzelo men rderëz men, re men: ―¡Guket mgyeey gwa! ¡Rzëëldetre ne ybán men! ");
INSERT INTO zpi_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Kom kesentyent rderëz men axtegue rbib men xab men no rtxoon men yudi lo mee, ");
INSERT INTO zpi_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","lex wkyeen komandant ne ysee soldad Pabel ledne nuu yra soldad no wkyeen komandant ne ydee soldad xkwent Pabel chen yzëët Pabel gan penak rderëz men lo Pabel zenga. ");
INSERT INTO zpi_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Per chene che wliib soldad Pabel chen ydee soldad xkwent Pabel, re Pabel lo kapitan ne zu nga: ―¿Pe zak ydee de xkwent te men-Roma, no ni gardet gaknan de gan pe wlaa men? ");
INSERT INTO zpi_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Chene won kapitan zenga, waluu kapitan diiz lo komandant, re kapitan: ―Gugyenen gan pe ylaa de porke men-Roma nak ménro. ");
INSERT INTO zpi_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Orguin wa komandant lo Pabel, lex wnabdiiz komandant, re komandant: ―¿Pe nli ne men-Roma nak de? Wke Pabel, re Pabel: ―Nli we. ");
INSERT INTO zpi_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Orguin re komandant: ―Noo kesentyent nyezh wgyizh noo ne le noo wak men-Roma. Lex re Pabel: ―Per noo axtegue ne wal noo nak noo men-Roma. ");
INSERT INTO zpi_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ne won yra men ne ydee xkwent Pabel ne re Pabel zenga, orgueguin wbetxee men lo Pabel. Axtegue komandant wdxe ne waknan men ne men-Roma nak Pabel no ne wkyeen men wliib mén Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Wra gyëël guin, kom rlaan komandant gaknanwen komandant gan pe kwentzhe rwinyaan men-Israel Pabel, lex wkyeen komandant wchil men Pabel no wkyeen komandant wdop fxuz ne rnebééy lo yra fxuz no le yra xtis-Israel. Lex wboo soldad Pabel, wdxig soldad Pabel lo men. ");
INSERT INTO zpi_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Orguin wii wiindxee Pabel lo xtis-Israel, lex re Pabel: ―Yna noo lo de yra de ne ydeblo ne mbán noo axtegue nedxeree bet zadet lextoo noo, nan Dëdyuzh ne xnëz mbán noo. ");
INSERT INTO zpi_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Lex wkyeen men ne la Ananías ne nak fxuz ne mazre nondee mén ne ndxin guex lo Pabel ne gap men ruu Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Wke Pabel, re Pabel: ―¡Dëdyuzh guu xkastig de ne noze rkanlo de wen de! Belne por ne ylaa de gyelextis zegne zëëd lo ley zob de wa, ¿penak rlaa de zegne zëëdet lo ley cheguin ne rkyeen de gap mén ruu noo? ");
INSERT INTO zpi_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Lex re yra mén ne ndxin nga: ―¿Pe zegwa yke de lo fxuz ne mazre nondee ne nak xefxuz Dëdyuzh? ");
INSERT INTO zpi_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Orguin re Pabel: ―Nandet noo ne fxuz ne mazre nondee nak ménree. Lo xgyiich Dëdyuzh zëëd: “Yniidet de dizmal por mén ne rnebééy laz de.” ");
INSERT INTO zpi_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Orguin wdee Pabel kwent ne tebëd men nak sadusew, le stebëd men nak farisew, lex ndípse re Pabel: ―Zhanbech, farisew nak noo, farisew nak xuz noo. Por ne rlaleedx noo ne sban mengut, por neguin wdxidzu mén noo nee. ");
INSERT INTO zpi_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Chene re Pabel zenga, wzelo yra men ne nak farisew wdildiiz men yra men men ne nak sadusew, lex wakgwrool yra men ne ndxin nga. ");
INSERT INTO zpi_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Porke rlaleedxdet men ne nak sadusew ne sban mengut, ni rlaleedxdet men ne nuu angel, ni espíritu, per le men ne nak farisew rlaleedx men yra neree. ");
INSERT INTO zpi_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Noze rderëzlsaa men yra men. Lex wzuli txup tson maxter ley ne nak farisew, re men: ―Ménree bet ne mal wlaadet men. Pazer te espíritu wnii lo men o te angel, texnad por Dëdyuzh nuu be konter. ");
INSERT INTO zpi_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ne wii komandant ne lel mazre rdildiiz yra mén guin, wdxe komandant ne nlabyu men Pabel. Lex wkyeen komandant ne tsa soldad chen koo soldad Pabel nga, tsasan ke men Pabel ledne nuu yra sesoldad men. ");
INSERT INTO zpi_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Chene wak ste gyëël, wlalo Jesucrist lo Pabel, re Ne: ―Ndíp guguu lextoo de Pabel, porke zegwa zegne wzëët de xkwent noo nee Jerusalén, zegwa ke rap de degne tsazëëto Roma. ");
INSERT INTO zpi_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Chene wyenii lyu, wyan txup tson men-Israel diiz ne yket men Pabel; re men ne bet gudet men, bet goodet men axtegue ne yket men Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mazdee txuplal nak yra mén guin ne re zenga. ");
INSERT INTO zpi_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Lex wa men lo fxuz ne rnebééy lo yra fxuz no le lo men ne rnebééy lo men-Israel, re men: ―Noo yra noo che wyan noo diiz ne bet gudet noo, bet goodet noo axtegue ne yket noo Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Orrenaa, gunab lo komandant yra de xtis-Israel ne chidno men Pabel lo de yzhe, ykanlo de ne rlaan de gaknanwen de pezee nak xkwent Pabel. Le noo yra noo list kwinnap noo chen yket noo Pabel antes ne ylenza Pabel lo de. ");
INSERT INTO zpi_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Per won xpee nzebzaan Pabel ne kanii men zenga, wa me ledne nuu yra soldad, waluu me diiz lo Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Orguin wbëz Pabel te kapitan, re Pabel lo men: ―Gutsanochee mewinree lo komandant, porke rap me te diiz ne yzëët me lo men. ");
INSERT INTO zpi_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Orguin wano kapitan mewin guin lo komandant, lex re kapitan lo komandant: ―Laa Pabel ne nuu chegyiib wbëz noo no wnab zhaa lo noo ne chidno noo mewinree lo de, porke rap me te diiz ne yzëët me lo de. ");
INSERT INTO zpi_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Lex wgoob komandant nya me, wano komandant me tebkoo, lex wnabdiiz komandant lo mee, re komandant: ―¿Pe diizzhe rlaan de yzëët de lo noo? ");
INSERT INTO zpi_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Lex re mee: ―Rongue de le men-Israel wyan diiz ne ynab men lo de ne tsano de Pabel lo xtis-Israel yzhe, ykanlo men ne rlaan men gaknanwen men pezee nak xkwent Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Per ylaleedxdet de men, porke mazdee txuplal nak yra mén ne tsa soblaan nëz ne ykambë́z men Pabel, no che re men ne bet gudet men, ni bet goodet men axtegue ne yket men Pabel. Orrenaa noze list ndxin men, noze kambë́z men gan pe gue de. ");
INSERT INTO zpi_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Orguin re komandant lo mee guin: ―Gugya, rut lo guedet de ne na de negwa lo noo. ");
INSERT INTO zpi_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Wluzh nga wbëz komandant txup kapitan, lex wkyeen komandant men ne ytop men txupgwyuu soldad ne tsa nii, stsonlalno-chii soldad ne tsambib kabay, stxupgwyuu soldad ne gweey lans, chen tsa men Cesarea beygaa gyëël. ");
INSERT INTO zpi_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","No wkyeen komandant ne guu men xab kabay ne kwib Pabel, no re komandant ne zhaas tsano men Pabel chen ngyëël Pabel ydxiin Pabel lo gobernador-Fels. ");
INSERT INTO zpi_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","No wdee komandant te gyiich lo mén guin ne ydee meno lo gobernador, re lo gyiich guin: ");
INSERT INTO zpi_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Noo nak Claudio Lisias, rgabtyuzh noo de gobernador-Fels, kesentyent non de. ");
INSERT INTO zpi_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ménree ne wxaal noo lo de, wnëëz yra men-Israel men, che mer yket men men, per chene waknan noo ne men-Roma nak men, wano noo xsoldad noo, waselaa noo men lo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Kom rlaan noo gaknan noo gan pe kwentzhe rkagyii men-Israel men, por neguin wano noo men lo xtis-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nga waknan noo ne por xkwent xley men yra men rkagyii men men, per rzëëldet ne guet men, ni rzëëldet ne tsuu men chegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kom waknan noo ne che wyan men-Israel diiz ne yket men men, por neguin wxaal noo men lo de wa. Che wnab noo lo yra mén ne rkagyii men ne lo de yzëët men gan pe kwentzhe rkagyii men men.” ");
INSERT INTO zpi_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Wlaa yra soldad zegne wkyeen komandant, gyëël zano men Pabel Antípatris. ");
INSERT INTO zpi_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ne wyeniise lyu, wberee yra soldad ne za nii, le yra soldad ne zambib kabay zaron Pabel axtegue Cesarea. ");
INSERT INTO zpi_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Chene wdxiin men Cesarea, wdee men gyiich guin lo gobernador no wdekwent men Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Wluzhse wool gobernador gyiich guin, wnabdiiz gobernador gan txu ménzhe nak Pabel. Ne waknan men ne men-Cilicia nak Pabel, ");
INSERT INTO zpi_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","re men: ―Chene chiid mén ne rkagyii de, cheguin ykagyedyag noo ne yzëët de. Lex wkyeen men soldad ne guu soldad Pabel lenxyuloow Herodes, per kwinnap ke soldad Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Chene wluzh gaay gbiz, wdxiin fxuz ne mazre nondee ne la Ananías gyëz-Cesarea yra men txup tson men ne rnebééy lo men-Israel no le te lisensyad ne la Tértulo. Lex wbig men yra men lo gobernador chen gue men logne wlaa Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Chene wberee yra soldad ne waxii men Pabel, wzelo Tértulo rkagyii Tértulo Pabel, re Tértulo lo gobernador: ―Dexkyizhtee de gobernador-Fels, por laa de xnëz mbán noo yra noo no por xgyelnan de ndal ne wen zayak laz noo. ");
INSERT INTO zpi_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Yrandxee lugar ryan mén byen yra ne kalaa de. Kesentyent non de, dexkyizhtee de gobernador-Fels. ");
INSERT INTO zpi_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Per por ne gunendet noo lo de xche, ynab noo lo de ne ykagyedyag de txup tsonlaan diiz ne yzëët noo. ");
INSERT INTO zpi_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Waknan noo yra noo ne laa ménree nak zegnak te gyelgyiz lad yra men-Israel, no ydendxee gyëzlyu kazobnadil men mén, no laa men rnebééy lo yra xpén Jesus men-Nazaret. ");
INSERT INTO zpi_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","No wlaan ke men nlaa men xeydoo Dëdyuzh zegnak te ledne bet nondet. Por neguin wnëëz noo men, wlaan noo nlaa noo gyelextis zegne zëëd lo xley noo. ");
INSERT INTO zpi_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Per wlenzague komandant-Lisias yra men xsoldad men, lafwers wla men men lo noo yra noo. ");
INSERT INTO zpi_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Na komandant-Lisias ne lo de chiid noo chen yzëët noo yra ne wlaa ménree. Laa zhal de gunabdizyu lo men gante chen gaknan de ne nli wlaa men yra neree ne rzëët noo. ");
INSERT INTO zpi_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yra men-Israel ne ndxin nga re men ne nli we. ");
INSERT INTO zpi_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Orguin wluu gobernador senye lo Pabel ne ynii Pabel, lex re Pabel: ―Por ne nan noo ne che wakxcheroo rnebééy de nacionree, por neguin bet zadet lextoo noo yke noo lo men ne rkagyii noo. ");
INSERT INTO zpi_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Zak ynabdiiz de laa zhal de gante ne gyed wzaandxee chibtxup gbiz wdxiin noo Jerusalén chen saknon noo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wgadet noo lo men ne kadildiiz noo mén, ni rut wtsëldildet noo lenxeydoo Dëdyuzh, ni lenydoo ne zobre nga, ni lenlgyëz. ");
INSERT INTO zpi_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Yra ménree gundet men gan yzu men testig ne nli yra negwa ne rkagyii men noo. ");
INSERT INTO zpi_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Per logne yxobdol noo si nak ne nli xdxiin Dëdyuzh rlaa noo zegne ryal ne ylaa noo ne nak noo xpén Jesucrist; neree ste religión rnii meno, no rlaa noo neree porke rlaleedx noo yrandxee ne zëëd lo ley no le yra ne wkaa profet. ");
INSERT INTO zpi_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Zegne rlaleedx ke noo ne sneban Dëdyuzh mengut, zenga ke rlaleedx ménree ne sneban Dëdyuzh mengut, nigle men ne wlaa ne wen, nigle men ne wlaa ne mal. ");
INSERT INTO zpi_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Por neguin mase gan pezee rlaatee noo, per syemper xnëz nuu xgyeryen noo, nigle nes lo Dëdyuzh, nigle nes lo mén. ");
INSERT INTO zpi_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Che wakxche ka noo stebkoo, lex wberee noo xnacion noo, wdxinneey noo med ne wxaal mén por menlaz noo no waron noo xgoon noo por Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Neguin kalaa noo lenxeydoo Dëdyuzh, wluzhse wlaa noo zegne zëëd lo ley, no yët ndal mén lenydoo, ni kalaadet noo rwid, chene wlenza tebëd men-Israel ne wruu Asia lo noo. ");
INSERT INTO zpi_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Laa yra mén guin rap degne chiid nee, chen yzëët men gan pe wlaa noo no gan pe kwentzhe rwinyaan men noo. ");
INSERT INTO zpi_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O yra mén ne ndxin nee, yzëët men ne wlaa noo belne nuu pe wzël lo men chene zu noo nes lo yra xtis-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nunegue ne wlaa noo chene zu noo lad men, wnii noo ndípse, re noo: “Por ne rlaleedx noo ne sban mengut, por neguin wdxidzu mén noo nee.” ");
INSERT INTO zpi_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Chene won gobernador-Fels zenga, kom che nanwen men pezee nak xkwent Jesucrist, re men: ―Chene chiid komandant-Lisias, ylaxnëz noo kwent gwa ne kalaa de yra de. ");
INSERT INTO zpi_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Lex wkyeen gobernador kapitan ne gunyoow ke men Pabel, per ydee men si yruu Pabel fwer no ydee men si tsa xmig Pabel lo Pabel tsadee men ne rkyiinen Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Chene che wluzh tson tap gbiz, wdxiin gobernador-Fels ste yrup men Drusila men-Israel ne nak lzaa men. Lex wkyeen men wdxiid Pabel, wkagyedyag men ne wzëët Pabel kwent ne rlaleedx mén Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Per chene wzëët Pabel ne rap mén degne ybán mén xnëz no ne ysoow men lo yra ne mal ne rlebleedx men ylaa men no ne sdxiin dxe ne ydee men kwent lo Dëdyuzh, wdxe gobernador, lex re gobernador: ―Gugya. Chene gyobo kwëz noo de ste. ");
INSERT INTO zpi_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Wlaan gobernador ndee Pabel med lo gobernador chen yselaa men Pabel. Por neguin guetse guetse rbëz men Pabel chen gu men diiz yrup men Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ne wzaa txup iz ne nunyoow Pabel, wruu Fels gyelgobernador, laa Porcio Festo wdee nii Fels. Per kom rlaan Fels gyan Fels wen lo yra men-Israel, wselaadet men Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Chene wzaa tson gbiz ne wdxiin gobernador-Festo Cesarea, wruu men nga wa men Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nga wbig yra fxuz ne rnebééy lo yra fxuz yra men men-Israel ne rnebééy, wzëët men yra ne rkagyii men Pabel lo gobernador. ");
INSERT INTO zpi_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","No wnab men lo gobernador ne yxaaleenendxee gobernador Pabel Jerusalén, porke wlebleedx men nket men Pabel nëz. ");
INSERT INTO zpi_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Wke gobernador, re gobernador: ―Guezenunyoow Pabel Cesarea; wyob ke yberee noo Cesarea. ");
INSERT INTO zpi_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Yra mén ne rnebééy lo de yra de, laa men ryal sanal noo ne yberee noo, belne nuu pe gyii wlaa ménro, no yzëët meno. ");
INSERT INTO zpi_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Zeg te xun chii gbiz wkaa gobernador-Festo Jerusalén, lex wberee ke men Cesarea. Wra gyëël guin wzob men ledne rlaa men gyelextis, lex wkyeen men wdxiid Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Chene wdxiin Pabel, wbig men-Israel, wzelo men noze ndal ne rkagyii men Pabel, per wzudet men testig. ");
INSERT INTO zpi_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Lex re Pabel: ―Bet ne mal wlaadet noo, ni por xley men-Israel, ni por xeydoo Dëdyuzh, ni por rrey-Roma. ");
INSERT INTO zpi_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Per kom rlaan gobernador gyan men wen lo yra men-Israel, wnabdiiz men lo Pabel, re men: ―¿Pe rlaan de tsa de Jerusalén, chen no ylaxnëz noo yra neree ne rkagyii men de? ");
INSERT INTO zpi_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Wke Pabel, re Pabel: ―Lo xtis-Roma zu noo, ledne ryal gakxnëzo. Laa de che nanwen de ne bet ne mal wlaadet noo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Belne nuu pe gyii wlaa noo ne rzëël guet noo, nyaalzhe yket men noo; per belne nlidet wlaa noo yra negwa ne rkagyii men noo, rut ryaldet ydekwent noo lo men. Mazdee guxaal noo lo rrey-Roma. ");
INSERT INTO zpi_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Lex wnabdiiz gobernador-Festo lo yra xpén men ne rzëët gan gonezhe ryal ylaa men. Wluzh wnabdiiz men, re men lo Pabel: ―Laa de wnab ne lo rrey-Roma tsa de; zak yxaal noo de lo rrey-Roma. ");
INSERT INTO zpi_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Chene wluzh tson tap gbiz, wa rrey-Agripa Cesarea yrup men Berenice, wagabtyuzh men gobernador-Festo. ");
INSERT INTO zpi_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kom ndal gbiz wkaa men nga, wzëët gobernador-Festo xkwent Pabel lo rrey, re men: ―Nee nuu te mén ne la Pabel ne wsan Fels chegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Chene wa noo Jerusalén, wbig yra fxuz ne rnebééy lo yra fxuz yra men men ne rnebééy lo men-Israel, wdxiid men lo noo wzëët men yra ne wlaa Pabel, wnab men ne ykyeen noo guet Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Wke noo re noo lo men, rapdet xtis-Roma koxtumber ne ykyeen men guet mén belne gardet ytsëlolsaa men men ne rkagyii men chen gue men ne nlidet neguin ne rkagyii mén guin men. ");
INSERT INTO zpi_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Por neguin chene wdxiid yra men-Israel guin nee, wnetesudet noo tyemp; wrague gyëël guin wzob noo ledne rlaa noo gyelextis, lex wkyeen noo waxii mén Pabel lenchegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Per yra mén ne wdxidzëët gan pe wlaa Pabel, bet ne ndxeeb nadet men zegne rzaa lextoo noo ne nna men. ");
INSERT INTO zpi_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nunegue ne rzëët men yra men nak ne rlaleedxdet Pabel zegne rlaleedx men, sinke le Pabel rlaleedx te mén ne la Jesus ne che wet, per le ne re Pabel mbán men. ");
INSERT INTO zpi_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Kom nandet noo gan pezee nlaa noo zegnak kwent guin, lex wnabdiiz noo lo Pabel gan pe rlaan Pabel tsa Pabel Jerusalén chen no gakxnëzo. ");
INSERT INTO zpi_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Per kom laa Pabel wnab ne lo rrey-Roma yxaal noo Pabel chen laa men ylaxnëz xkwent Pabel, por neguin wkyeen noo ne guezenunyoow Pabel axtegue ne gun noo gan yxaal noo Pabel lo rrey-Roma. ");
INSERT INTO zpi_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Orguin re rrey-Agripa lo gobernador-Festo: ―No noo rlaan gon xdiiz mén gwa. Lex re gobernador-Festo: ―Yzhe ke gon do. ");
INSERT INTO zpi_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wra gyëël guin, wdxiin rrey-Agripa yrup men Berenice. Yrandxee mén waknzebnëz lo men. Wdxiin men yra men soldad ne rnebééy no le yra mén ne mazre nondee gyëz guin, wdee men ledne gon men ne gue Pabel, lex wkyeen gobernador wdxiid Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Zhich guin re gobernador: ―Rrey-Agripa no le yra de zegne ndxin de nee, gukwii gante: Ménree ne zu nee, nigle Jerusalén, nigle nee, yrandxee men-Israel rdxiid lo noo, rnab men ne ykyeen noo guet ménree. ");
INSERT INTO zpi_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Per bet ne wlaa men ne rzëël guet men wzëldet lo noo. Per kom laa men wnab ne lo rrey-Roma tsa men, por neguin che wlebleedx noo ne no yxaal noo men. ");
INSERT INTO zpi_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kom bet ne mal ne wlaa men wzëldet lo noo ne nkaa noo we lo gyiich nxaal noo we lo rrey-Roma, por neguin wdxig noo men lo de yra de no lo de laa zhal de rrey-Agripa, chen chene luzh ynabdizyu de lo men, che sël ne ykaa noo lo gyiich. ");
INSERT INTO zpi_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Porke ryenen noo ne ngyidet yxaal noo te mén ne nunyoow belne guedet noo logne wlaa men. ");
INSERT INTO zpi_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Lex re rrey-Agripa lo Pabel: ―Che zak yzëët de pezee nak xkwent de. Orguin wlis nya Pabel, re Pabel: ");
INSERT INTO zpi_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","―Rrey-Agripa, kesentyent rzhiilen noo ne ynii noo lo de orree, chen yzëët noo yra ne rkagyii men-Israel noo. ");
INSERT INTO zpi_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Porke laa de nanwen de pezee nak yra xkoxtumber noo yra noo ne nak noo men-Israel no gan pe kwentzhe rdildiiz noo. Por neguin rnab noo lo de, gugap pasens ykagyedyag de ne yzëët noo. ");
INSERT INTO zpi_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Yrandxee men-Israel nan men gan pezee wbán noo axtegue ne win noo, nigle laz noo, nigle Jerusalén. ");
INSERT INTO zpi_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","No nan ke men ne axtegue chekwlo nak noo farisew; zak yzëët meno belne rlaan men yzëët meno. Noo wlaa noo yrandxee ne zëëd lo xley men-Israel zegne rlaa men ne nak farisewo, no laa men ne nak farisew nak ne mazre zanaldoo. ");
INSERT INTO zpi_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Orrenaa le men wdxig noo lo xtis por ne rlaleedx noo ne sneban Dëdyuzh mengut zegne che re Ne lo xpenkwlal noo. ");
INSERT INTO zpi_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Yrandxee men ne zëëd xnëz yra chibtxup xpee Israel kambë́z men ne kwii men gak neree ne re Ne; por neguin rzaknon men Dëdyuzh, rlaa men xdxiin Ne dxe gyëëltee. Orrenaa, rrey-Agripa, por ne rlaleedx noo ne sneban Dëdyuzh mengut, por neguin rkagyii men-Israel noo. ");
INSERT INTO zpi_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Pe nuu lextoo de yra de ne gundet Dëdyuzh gan yneban Ne mengut? ");
INSERT INTO zpi_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Chekwlo nuu lextoo noo ne rap noo degne kwinyaan noo xpén Jesus, ");
INSERT INTO zpi_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","no zenga wkalaa noo gyëz-Jerusalén. Kon gyiich ne wniiz yra fxuz ne rnebééy lo yra fxuz, ndal mén ne rlaleedx Jesus wsee noo chegyiib. No chene wket mén xpén Ne, no noo wyan byeno. ");
INSERT INTO zpi_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ndalyaa tir wa noo ydoo por ydoo wzakzi noo men ne rlaleedx Ne, wkyeen noo men lafwers ynii men diznyaan por laa Ne. Zenga wlaa noo yrandxee lenydoo. Kesentyent winyaan noo men, axtegue wkanal noo men ste nacion. ");
INSERT INTO zpi_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Dxiin guin za noo Damasco kon te gyiich ne wniiz yra fxuz ne rnebééy lo yra fxuz lo noo. ");
INSERT INTO zpi_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Per chene za noo nëz, rrey-Agripa, zeg rwen ngbiz wii noo te bnii gyeybaa, ntozdee rzenii we ke lo ngbiz; wkabtsa we kbii ledne za noo yra noo men ne zano noo. ");
INSERT INTO zpi_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Orguin wkantaa noo lyu yra noo, no won noo te rëz kon diz-hebreo ne na lo noo: “Saulo, Saulo, ¿penak rwinyaan de noo? Laake de rzakzi de zegne rlaa yuz ne rkanii xtoo yag ne rbib mén led maa.” ");
INSERT INTO zpi_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Lex re noo: “¿Txu laa de Dechey?” Wke Ne, na Ne: “Noo nak Jesus ne rlaandet de kwii de. ");
INSERT INTO zpi_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Per gutsaxee, gusuli, porke wlalo noo lo de chen yzu noo de ylaa de xdxiin noo no chen yzëët de ne wii de orree no le ne gyed yluur noo lo de. ");
INSERT INTO zpi_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Noo yselaa de lo yra men-Israel, nigle lo yra mén ne nakdet men-Israel. Lo yra ménree yxaal noo de orree. ");
INSERT INTO zpi_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Yxaal noo de lo men chen ylaa de ne tee bnii xgyeryen men, chen ysalzaan men ne mal, tsanal men ne wen, no chen ydeedetre men si ynebééy Bzelo lo men, sinke tsanal men xnëz Dëdyuzh, no chen ylaleedx men noo chen gak perdon xdol men no chen yganen men ne yganen yra mén ne che nak xpén Dëdyuzh.” ");
INSERT INTO zpi_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Rrey-Agripa, won noo diiz wlaa noo yra ne na Jesus lo noo chene wnii Ne lo noo desde gyeybaa. ");
INSERT INTO zpi_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Primer lo men-Damasco wzëët noo xdiiz Ne, zhich guin wzëët noo we lo men-Jerusalén no le lo yra mén ne nuu ydendxee Judea no le lo yra mén ne nakdet men-Israel. Re noo lo men ne rap men degne ysaan men xgyelmal men, lex tsanal men xnëz Dëdyuzh, ylaa men ne ryal ylaa men chen gaknyoo ne che wsaan men xgyelmal men. ");
INSERT INTO zpi_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Por kwentree wnëëz men-Israel noo lenxeydoo Dëdyuzh, wlaan men nket men noo. ");
INSERT INTO zpi_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Per por ne waknonen Dëdyuzh noo, axtegue nedxeree le noo benak zu nee rzëët noo xdiiz Ne lo yrandxee mén, nigle lo mennon, nigle lo kwaskyertee mén. Wzëëdet noo ste kos sinke nonchee yra ne rap degne gak ne wzëët yra profet no le ne wzëët Moises: ");
INSERT INTO zpi_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ne zet Crist no ne laa Ne nak men ne primerendxee yban ke lo yra mengut no ne laa Ne yzëët lo yrandxee mén gan pezee gak men perdon, nigle lo men-Israel, nigle lo mén ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Neree kazëët Pabel chene wnii gobernador-Festo, ndípse re men: ―¡Nzël de Pabel! Por tant rseed de axtegue wyakzël de. ");
INSERT INTO zpi_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Per wke Pabel, re Pabel: ―Nzëldet noo gobernador-Festo; neree ne rzëët noo, nli we no xnëz xnëz nako. ");
INSERT INTO zpi_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nee zob rrey-Agripa, nan zhaa yra neree ne kazëët noo; por neguin rdxedet noo rnii noo nes lo zhaa, porke nanwen noo ne nan zhaa yra neree ne kazëët noo, porke wakdeto ledne ngueedx. ");
INSERT INTO zpi_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","¿Pe rlaleedx de logne wkaa yra profet rrey-Agripa? Nanwen noo ne rlaleedx do. ");
INSERT INTO zpi_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Lex wke rrey-Agripa, re rrey-Agripa: ―Stebla stebruundxee nyun de gan nlaleedx noo Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Lex re Pabel: ―Nyaalzhe stebla stebruundxee o rakre zeg falt, per naleg Dëdyuzh ne let nozdet laa de ylaleedx Jesucrist, sinke no yrandxee mén ne kayon ne rzëët noo nedxeree ylaleedx Jesucrist zegne rlaleedx noo Ne, per sin kadenree. ");
INSERT INTO zpi_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Wluzhse re Pabel zenga, wzuli rrey-Agripa no le gobernador-Festo yra men Berenice no le yra mén ne zobno men nga, ");
INSERT INTO zpi_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","wruu men tebkoo; wzelo men rulsaa men diiz, re men: ―Bet ne rzëël guet ménree wlaadet men, ni rzëëldet ne tsuu men chegyiib. ");
INSERT INTO zpi_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Lex re rrey-Agripa lo gobernador-Festo: ―Nyak nselaa be men belne nnabdet men ne lo rrey-Roma tsa men. ");
INSERT INTO zpi_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Chene che wyan men diiz ne yxaal men noo Italia yra noo, wdekwent men Pabel no le stebëd mén ne nuu chegyiib lo te kapitan ne la Julio ne rnebééy lo tebëd soldad ne la xsoldad Augusto. ");
INSERT INTO zpi_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Lex wuu noo te bark-Adramitio ne che nuu ne yruu tsa Asia. Za noo yra noo Aristarco men-Tesalónica gyëz ne nak lo lyu ne la Macedonia. ");
INSERT INTO zpi_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Wra gyëël guin wdxiin noo Sidón yra noo; kesentyent wen wak kapitan-Julio lo Pabel, wdee Julio si wa Pabel lo yra xmig Pabel chen ydee men logne ykyiinen Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Chene wruu noo Sidón, wdee noo koo lyu ne la Chipre ne ka lo nisdoo, por lad bëg wyano chen ysako mee, porke ngali nes lo noo rasob mee. ");
INSERT INTO zpi_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Zhich guin wdesu noo ngali lo lyu ne la Cilicia no le lo lyu ne la Panfilia, wdxiin noo Mira te gyëz ne nak lo lyu ne la Licia. ");
INSERT INTO zpi_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nga wzël te bark-Alejandría lo kapitan-Julio, Italia tsa we; lex wkyeen men wuu noo bark guin yra noo. ");
INSERT INTO zpi_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ndal gbiz wuu bark nëz tant tsoow za bark, nen nentee wdxiin noo guex Gnido. Kom benak rasob mee, lex watee noo ngali Salmón, wyeky noo lyu ne la Creta ne ka lo nisdoo chen ysako mee. ");
INSERT INTO zpi_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tebrulyu guin za noo; nen nentee wdxiin noo ledne la Buenos Pwertos guex te gyëz ne la Lasea. ");
INSERT INTO zpi_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kom che wakxche za noo zenga yra noo, che ndxeeb tsar bark lo nisdoo, porke che zëdyob mëëw ne rak nal. Por neguin re Pabel lo men yra men ne za lenbark: ");
INSERT INTO zpi_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","―Zhanbech, ryenen noo ne kesentyent ndxeeb ne tsar be, porke sluzh bark, yrëëts yra yúú ne neeyo, no let nozdet laa we luzh, sinke axtegue no laa be luzh. ");
INSERT INTO zpi_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Per mazre wukas kapitan ne re men ne rnexoon bark no ne re men nako xbark ke ne re Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kom wendet nkaa noo nga mëëw ne rak nal, por neguin kasi yra men wlebleedx ne mazre wendee yruu noo nga, gan pe gakdet ydxiin noo Fenice gyëz ne nak lo lyu ne la Creta ledne beeytee rasob mee, chen nga ykaa noo mëëw ne rak nal. ");
INSERT INTO zpi_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Lex wzelo wlen te meles ne zëëd nes sur, nuu lextoo men ne cheguel zak ydxiin men ledne wlebleedx men. Orguin wboo men ancla lo nis, lex wruu bark za bark tebrulyu ne la Creta. ");
INSERT INTO zpi_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Per orsegue wako wlen te meroo meduxtee ne la Euroclidón, ");
INSERT INTO zpi_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","wzelo mee guin rcherezhicho bark. Kom wakdetre gan nya bark nes ledne rlaan men tsa we, wdee men si wtxaap mee bark nes ledne za mee. ");
INSERT INTO zpi_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Wdee bark por zhich tebla lyu ne la Clauda ne ka lo nisdoo ledne beeytee rlen mee, nen nentee wun noo gan yra noo wlep noo kano ne nliib zhich bark lenbark. ");
INSERT INTO zpi_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Chene wluzh wlep noo kano lenbark, wliib men duu kbii bark chen ybilyudeto. Kom rdxe men ne sobdíp bark lo yuzh ne la Sirte, lex wchil men lon ne neey bark, chen ytxaap mee bark nes ledne za mee. ");
INSERT INTO zpi_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Wra gyëël zeglaake rlen mee, lex wzelo men wlebaa men yúú ne neey bark lo nis. ");
INSERT INTO zpi_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ne wzaa tson gbiz, wgoob men yra ne rkyiinen bark wlebaa meno lo nis. ");
INSERT INTO zpi_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ndal gbiz axtegue wruudet lo ngbiz, ni mël ne ndxiib gyeybaa waknyoodet; che nuudetre lextoo noo ne yláá noo por tant ryab gyo no por tant rlen meroo meduxtee. ");
INSERT INTO zpi_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kom che wakxche ne betre rudet noo yra noo, wzu Pabel gwrooltee lad men yra men, lex re Pabel: ―Zhanbech, mazre wendee nyon de xdiiz noo nruudet be Creta chen ntsëlodet be gyelerdxeebree, ni bet yúú nseedet be. ");
INSERT INTO zpi_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Per yna noo lo de yra de, ne ysuudet lextoo de porke ni te de guetet, nonchee bark luzh. ");
INSERT INTO zpi_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Porke negyëëlree wlalo te xangel Dëdyuzh lo noo, Dëdyuzh ne rnebééy lo noo no ne rlaa noo xdxiin. ");
INSERT INTO zpi_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Lex na angel guin lo noo: “Pabel, ydxedet de, porke rap de degne ybig de lo rrey-Roma no por laa de yselaa Dëdyuzh yra mén ne zëëd lenbark, ni te men guetet.” ");
INSERT INTO zpi_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Por neguin zhanbech, ysuudet lextoo de, porke noo rlaleedx noo ne slaa Dëdyuzh zegne na angel lo noo; ");
INSERT INTO zpi_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","per sobdíp bark rulyu ne ka lo nisdoo. ");
INSERT INTO zpi_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Te gyëël ne wzaa txup xman ne za noo lo nisdoo, wdxiin noo lo nisdoo ne la Adriático, noze zere zerotee rlaa mee bark. Zeg gwrool gyëël wyenen yra mén ne rlaa dxiin lenbark ne mer ydxiin noo lyubidx. ");
INSERT INTO zpi_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Lex wdiix men gan palal gyët nak zhiin nis, gal yas rga we; mazre nodee wdiix meno ste, le we che rga chíín yas. ");
INSERT INTO zpi_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Per por ne rdxe men ne tsasob bark lo gye, wtxoon men tap ancla lo nisdoo nes zhich bark chen sutsë we, no zoon men naal pezee gyeniigue lyu. ");
INSERT INTO zpi_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Yra mén ne rlaa dxiin lenbark, wlaan men nzhoon men; wtxoon men kano lo nis, rlaa men zegne rlaa men ne rtxoon ancla lo nis nes xtoo bark. ");
INSERT INTO zpi_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Per wluu Pabel diiz lo kapitan no le lo yra soldad, re Pabel: ―Belne kwë́zdet yra ménree lenbark, gundet de gan yláá de. ");
INSERT INTO zpi_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Lex wtxuug soldad yra duu ne nliib kano chen gyabo lo nis. ");
INSERT INTO zpi_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Chene zëdyenii lyu, re Pabel lo men ne gu men, re Pabel: ―Che wzaa txup xman ragueesdet de, ni bet rudet de. ");
INSERT INTO zpi_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Por neguin yna noo lo de, gugu chen guetet de, porke ni te de gakdet perdid ni te gyitsxtoo. ");
INSERT INTO zpi_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Chene wluzh re Pabel zenga, wgoob Pabel te gyëtxtil, wdee Pabel dexkyizhtee lo Dëdyuzh nes lo men yra men. Lex wla Pabelo, wzelo Pabel wu Pabelo. ");
INSERT INTO zpi_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Orguin wguu lextoo men yra men no men wzelo wu. ");
INSERT INTO zpi_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Txupgwyuuno-tsonlalno-chimteb nak noo yra noo ne nuu noo lenbark. ");
INSERT INTO zpi_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Chene wluzhse wu men ne axtegue wzak lextoo men, wlebaa men yra zhobxtil lo nis chen gakngyiix bark. ");
INSERT INTO zpi_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Chene wyenii lyu, wnebeeydet men ne rlaa dxiin lenbark gan pa lyuzhe wdxiin men, per wii men te ledne nugyëël nisdoo, wyen yuzh, lex wlebleedx men ndxig men bark nga belne gak gan. ");
INSERT INTO zpi_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Wtxuug men yra duu ne nliib ancla, wsan meno lo nis, no wseláá men lo duu ne nliib yag ne rkyiin ne rnexoon men bark. Lex wchiil men lon ne neey bark nes xtoo bark chen ytxaap mee we, zenga wbig bark nes runisdoo. ");
INSERT INTO zpi_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Per wasob xtoo bark ledne ndxin ndal yuzh, axtegue wakdetre nni we, le nes zhicho wzelo rbil por tant ndíp rasob nisdoo ledo. ");
INSERT INTO zpi_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Orguin wlaan yra soldad nket men yra pres, chen xobnisdet men yzhoon men. ");
INSERT INTO zpi_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Per wdeedet kapitan si nlaa men zenga, porke rlaandet men guet Pabel. Lex wkyeen men ne primer men ne run gan rzhobnis gyab lo nis chen ydxiin men lyubidx, ");
INSERT INTO zpi_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","le stebëd men tsanal, xoob men led tabel o led yag ne wbil bark. Zenga wláá noo yrandxee noo ne le noo wdxiin lyubidx. ");
INSERT INTO zpi_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Chene che wláá noo lo nisdoo yra noo, waknan noo ne Malta la lyu guin ne ka lo nisdoo ledne wdxiin noo. ");
INSERT INTO zpi_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Yra mén ne nuu nga, kesentyent wen wak men lo noo yra noo. Wzulbël men gyi chen yzanen noo, por tant ryab gyo no por tant rak nyag. ");
INSERT INTO zpi_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Lex wtop Pabel teblen yagbidx. Zegne wsee Pabelo lo gyi, por ne rkaxlaa wrunzeeb te mëël lado, wkaleey ma nya Pabel, kandiltegue maa. ");
INSERT INTO zpi_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Chene wii yra mén ne nuu nga ne kandil ma nya Pabel, re men lo xkompanyer men: ―Nakbeey ne gyii wlaa mgyeeyree; por neguin mase wláá men lo nisdoo, per ydeedet Dëdyuzh si ne ybánre men. ");
INSERT INTO zpi_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Per wbib nya Pabel, watxee mëël guin lo gyi, no bet wzakdet Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Yra mén guin noze kambë́z men ne nyezaa Pabel gyi o ne nkantaague Pabel nyet Pabel. Per chene wakxche ne wii men ne bet wzakdet Pabel, wtsaa xdiiz men, wzelo men re men ne te dëdyuzh nak Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Guex nga ka xelyu te men ne la Publio ne nak mennondee lo lyu guin ne ka lo nisdoo. Laa men wniiz ruxyuu wbë́z noo; nga wkaa noo tson gbiz. Kesentyent wen wak men lo noo yra noo. ");
INSERT INTO zpi_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Laatee cheguin nex xuz men rzhuun xuz men, rlen men xlaa no rzak men gyibren. Lex wdee Pabel ledne nex men; chene wluzh wnab Pabel lo Dëdyuzh por laa men, wxob nya Pabel led men wneseyaken Pabel men. ");
INSERT INTO zpi_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Chene waknan yra mén ne rzhuun ne nuu nga neguin ne wak, wa men lo Pabel, wneseyaken Pabel men. ");
INSERT INTO zpi_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","No kesentyent wen wak men lo noo yra noo, no chene le noo wal tsuu bark ste, wniiz men yra ne ykyiinen noo nëz. ");
INSERT INTO zpi_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Chene wzaa tson mëëw ne ka noo lo lyu guin ne ka lo nisdoo, lex wdee noo yra noo lenbark-Alejandría ne wzob nga mëëw ne rak nal; nes xtoo we neeyo mdoo ne la Cástor no le mdoo ne la Pólux. ");
INSERT INTO zpi_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Wdxiin noo te gyëz ne la Siracusa, nga wkaa noo tson gbiz. ");
INSERT INTO zpi_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nga wruu noo za noo tebrunisdoo axtegue ne wdxiin noo gyëz ne la Regio. Wra gyëël, wlen te mee nes sur; ne wrup gbiz wdxiin noo gyëz ne la Puteoli. ");
INSERT INTO zpi_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nga wtsëlo noo tebëd men ne rlaleedx Jesucrist, lex na men lo noo yra noo ne ykaa noo lo men te xman. Zhich guin wruu noo za noo Roma. ");
INSERT INTO zpi_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Chene won yra men ne rlaleedx Jesucrist diiz ne ydxiin noo Roma yra noo, wruu men wtsëlnëz men noo axtegue gyëz ne la Foro de Apio no le gyëz ne la Tson Tabernas. Chene wii Pabel yra men guin, wzhiilen Pabel, wdee Pabel dexkyizhtee lo Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ne wdxiin noo Roma yra noo, wdekwent kapitan yra pres lo men ne rnebééy lo yra soldad, per le Pabel wdee xtis si wuu te lenyuu ne waalel; nga wapkwent tebegue soldad Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Chene wzaa tson gbiz ne wdxiin noo Roma yra noo, wbëz Pabel men-Israel ne mazre nondee. Chene wdop men, re Pabel lo men: ―Zhanbech, bet ne mal wlaadet noo men-Israel, ni bet ne mal wlaadet noo por xkoxtumber xpenkwlal be, no le men wnëëz noo Jerusalén wdekwent men noo lo xtis-Roma. ");
INSERT INTO zpi_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Chene wluzh wnabdizyu xtis lo noo, rlaan zhaa nselaa zhaa noo, porke wyenen zhaa ne bet ne rzëël guet noo wlaadet noo. ");
INSERT INTO zpi_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Per kom wzudíp yra men-Israel, por neguin wap noo degne wnab noo ne lo rrey-Roma chiid noo chen laa zhaa ylaxnëz kwentree, per nakdeto ne nuu pe rwinyaan noo men-Israel. ");
INSERT INTO zpi_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Por neguin wbëz noo de yra de chen kwii noo de no chen yzëët noo lo de ne por ne rlaleedx noo ne sban mengut zegne rlaleedx ke yra menlaz bo, por neguin nliib noo kon kadenree. ");
INSERT INTO zpi_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Lex re men: ―Noo yra noo ni te xgyiich men-Judea gardet ynëëz noo ne yzëët men xkwent de lo noo, no ni te menlaz be ne rdxiid nee, bet ne mal nadet men por laa de. ");
INSERT INTO zpi_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Per rlaan noo gon noo xdiiz de gan pe yna de, porke noo yra noo nan noo ne yrandxee lugar rninyaan men religión gwa. ");
INSERT INTO zpi_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Lex wsu men te dxe ne ydop men. Chene wdxiin dxe guin, kesentyent ndalyaa mén wdop ledne nuu Pabel. Wzelo Pabel wnii Pabel lo men yra men, axtegue rsil axtegue wzëë wzëët Pabel zegne rkyeen Dëdyuzh. Wzëët Pabel ne ka lo ley ne wdee Dëdyuzh lo Moises no le ne wkaa yra profet, porke rlaan Pabel ne ylaleedx men Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nuu men wlaleedx ne re Pabel, per nuuzeg men wlaleedxdeto. ");
INSERT INTO zpi_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kom wyandet men byen yra men, wzelo men wrëëts men. Lex re Pabel: ―Nli diiz ne re Espíritu Sant lo profet-Isaías ne wzëët profet-Isaías lo yra xpenkwlal be chene re men: ");
INSERT INTO zpi_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Gutsa gue de lo yra ménro: Mase mazre ykagyedyag de diiz, per ydeedet de kwento; mase mazre kwii de, per bet gyenden de. ");
INSERT INTO zpi_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Porke yra ménree wakndíp lextoo men; rtsëë gyedyag men chen gondet men diiz no rtsëë bzalo men, chen kwiidet men, ni ykagyedyagdet men diiz, ni ydeedet men kwento, ni ysaandet men xgyelmal men chen gakdet yselaa noo men lo xdol men. ");
INSERT INTO zpi_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Por neguin gugaknan yra de ne le lo yra mén ne nakdet men-Israel che rakzëët ne gan pezee gun Dëdyuzh men perdon. Laa men si slaleedx meno. ");
INSERT INTO zpi_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Chene wluzh re Pabel zeree, sya yra mén guin, kesentyent rdildizlsaa men. ");
INSERT INTO zpi_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Txup iz wuu Pabel te lenyuu diin; nga ruu Pabel diiz yra Pabel mén ne rdxiin lo Pabel. ");
INSERT INTO zpi_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Wdxedet Pabel wzëët Pabel lo men zegne rkyeen Dëdyuzh no wzëët Pabel xdiiz Jesucrist sin ne rut wsoowdet.");
INSERT INTO zpi_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Noo nak Pabel ne rlaa xdxiin Jesucrist. Laa Dëdyuzh wye noo ne gak noo xpoxter Jesucrist chen yzëët noo xdiznzoon Ne. ");
INSERT INTO zpi_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Axtegue antes che re Dëdyuzh yra diznzoonree ne wkaa yra xprofet Ne lo xgyiich Ne, ");
INSERT INTO zpi_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","lo diizree rakzëët xkwent Jesucrist XPee Dëdyuzh. Le ne wak Ne mengyëzlyu, xnëz rrey-David zëëd Ne, ");
INSERT INTO zpi_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","per por Espíritu Sant waknyoo ne XPee Dëdyuzh nak Ne chene wban Ne por xpoder Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Por Jesucrist nak ne wseleedx Dëdyuzh lo noo ne noo gak xpoxter Jesucrist, chen tsazëët noo xdiiz Ne; zenga tsuu mén ne ylaleedx Ne ydendxee gyëzlyu no gon men diiz ylaa men ne rlaan Ne. ");
INSERT INTO zpi_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Lad yra men guin ngab de yra de, Dëdyuzh nak ne wye de chen gak de xpén Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Kakaa noo gyiichree yxaal noo lo de yra de ne nuu de Roma; ryaan Dëdyuzh de no wye Ne de chen gak de xpén Ne. Dëdyuzh Xuz be yrup Ne Jesucrist gaknonen de yra de no yseleedx Ne gyelendxi lo de. ");
INSERT INTO zpi_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ne primer ne rlaa noo nak ne por Jesucrist rdee noo dexkyizhtee lo Dëdyuzh por laa de yra de, porke nesree nesrotee nuu xdiiz de ne rlaleedx de Ne. ");
INSERT INTO zpi_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Dëdyuzh ne rlaa noo xdxiin ydebgyiky ydeblextoo noo ne rzëët noo xdiznzoon XPee Ne, nan Ne ne yzaandxee chene rnab noo lo Ne, rnab noo por laa de yra de, ");
INSERT INTO zpi_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","no chene rnab noo lo Ne, syemper rnab noo ne belne yna Ne, chiid noo lo de wa, zegne rlebleedx noo axtegue chekwlo. ");
INSERT INTO zpi_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Porke rlaan noo chiid noo wii lo de, chen gun noo xyudar de lo dxiin ne wseleedx Dëdyuzh lo de chen ysalzaandet do ");
INSERT INTO zpi_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","no chen gulsaa lextoo xkompanyer be zegne rlaleedx be Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Yra de ne no de rlaleedx Jesucrist, rlaan noo gaknan de ne ndal tir wlebleedx noo ndxiid noo wii lo de, per axtegue orree rakdet chiid noo. Wlaan noo ndxiid noo chen nlandalre noo men ne rlaleedx Jesucrist lad de zegne wlandal noo men ledne che wa noo. ");
INSERT INTO zpi_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Rap noo degne yzëët noo xdiznzoon Jesucrist lo yrandxee mén, nigle lo men-griego, nigle lo mengyëzgyiix, nigle lo mennan, nigle lo mennandet. ");
INSERT INTO zpi_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Por neguin kesentyent rlaan noo chiid noo chen yzëët noo xdiznzoon Jesucrist no lo de yra de zegne nuu de Roma. ");
INSERT INTO zpi_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Porke rtuunden noo ne rzëët noo xdiznzoon Jesucrist, porke xpoder Dëdyuzh nako chen yrandxee men ne rlaleedx Jesucrist yláá lo dol, primer lo men-Israel wakzëëto, per laake no ke lo men ne nakdet men-Israel rakzëëto. ");
INSERT INTO zpi_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Porke por xdiznzoon Jesucrist nak ne waknan be ne wun Dëdyuzh be perdon nonchee por ne rlaleedx be Ne, zegne zëëd lo xgyiich Dëdyuzh ledne re: “Men ne che wak perdon por ne rlaleedx men Dëdyuzh zap men stelel gyelembán.” ");
INSERT INTO zpi_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Desde gyeybaa raknyoo ne sakzi Dëdyuzh yra menmal ne xnëzdet rlaa, ne por xgyelmal men rlaandet men gaknan mén ne nli. ");
INSERT INTO zpi_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Porke nan men ne nli nuu Dëdyuzh, no laake Ne wbonyoo ne nli nuu Ne. ");
INSERT INTO zpi_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Mase rwiidet mén Dëdyuzh, per axtegue ne waa gyëzlyu, rwii be yra ne wzhexkwaa Ne; por yra ne wzhexkwaa Ne, rdee be kwent ne ydxiindet dxe ne gyal xpoder Ne no ne laa Ne nak Dëdyuzh; por neguin yëtet gan pe gak men gyii. ");
INSERT INTO zpi_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","No mase nan men ne nuu Dëdyuzh, per rzaknondet men Ne zegne ryal saknon men Ne ne nak Ne Dëdyuzh, ni rdeedet men dexkyizhtee lo Ne, sinke lel waknkeb xgyeryen men, teblose ne bat rkyiindet rlebleedx men. ");
INSERT INTO zpi_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Re men ne nan men, per nzël men; ");
INSERT INTO zpi_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","porke wtsaa men xgyelenzoon Dëdyuzh ne nunk retet por xebneb mén ne ret, no por xebneb maa ne rzhobee, no por xebneb maa ne zob tap nii, no le por xebneb maa ne rdoob lyu. ");
INSERT INTO zpi_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Por neguin wboleedx Dëdyuzh men lo yra ne mbixleedx ne rlaa men; zenga nak ne le men wzelo rlaa men ne mazre ntudee yra men xkompanyer men. ");
INSERT INTO zpi_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Lugar ne ylaleedx men Dëdyuzh, lel rlaleedx men ne nlidet; rzaknon men kos ne wzhexkwaa Dëdyuzh, le laa Ne rzaknondet men, no laa Ne wzhexkwaa yrandxee kos no nonchee laa Ne ryal ne saknon men ydeblo siguelendxee. Zengaw. ");
INSERT INTO zpi_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Por neguin wboleedx Dëdyuzh men yra men lo yra gyelentu ne rlaan led men, axtegue wnaa ne nuu lad men, che rlaadetre men zegne ryal ylaa men, laake sewnaa men rkano men. ");
INSERT INTO zpi_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Zenga ke rlaa yra mgyeey guin, rkanodetre men wnaa, sinke laake sebgyeey men rkano men, axtegue rbab men rwii men lo sebgyeey men, ntu rlaa men. Laake men rye xkastig men ne rlaa men zenga. ");
INSERT INTO zpi_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kom rlaandet men ynebeey men Dëdyuzh zegne ryal ynebeey men Ne, neguin wboleedx Ne men lo yra ne mal ne rlebleedx men, chen ylaa men ne ryaldet ylaa men. ");
INSERT INTO zpi_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Teblose ne ryaldet ylaa men, neguin nak ne rlaa men, kesentyent mal men, ndeblextoo men, wdee lo beey mal men, kesentyent mbidye men, rket men mén, rzobnadil men mén, teblose rkade men, tebegue ne mal nuu lextoo men, kesentyent dizgyizh men, ");
INSERT INTO zpi_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","rkagyii men semén men, rlaandet men Dëdyuzh, raknzebnëzdet men lo semén men, gya nuu lextoo men, rdxin men, noze lextoo men rlen ne mal, rondet men xdiiz xegwzan men, ");
INSERT INTO zpi_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","kesentyent ndíp xdiiz men, rundet men kumplir diiz ne rnii men, ryaandet men semén men, rundet men perdon semén men, rlesdet lextoo men semén men. ");
INSERT INTO zpi_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Che nanwen men ne re Dëdyuzh, yrandxee mén ne rlaa yra neree, rzëël guet men, no zenga le men benak rlaa we, no axtegue rzhiilen men chene rwii men rlaa ste méno. ");
INSERT INTO zpi_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Por neguin yët gan pe gak de gyii ne rleedx de ste mén, nyaalzhe gan txuzhtezhe nak de, porke chene rleedx de ste mén, laake de rlaa ne sakzi de, porke ne rlaa ke men, neguin ke rlaa de. ");
INSERT INTO zpi_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Per nan be ne gyelextis ne rlaa Dëdyuzh ne rzakzi Ne yra men ne rlaa zenga, xnëz rlaa No. ");
INSERT INTO zpi_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Laa de ne rleedx de ste mén no rlaa ke de zegne rlaa men, ¿pe nuu lextoo de ne ylaadet Dëdyuzh gyelextis lo de? ");
INSERT INTO zpi_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Laa de yra de rlaandet de yra ne wen ne rlaa Dëdyuzh por laa de, ne run Ne de wantar no ne rap Ne de pasens, ni rdeedet de kwent ne yra ne wen ne rlaa Ne, rlaa No chen ysaan de xgyelmal de. ");
INSERT INTO zpi_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Per por ne ndíp lextoo de no por ne rlaandet de ysaan de xgyelmal de, laake de rtsowndal kastig ne sak de chene ydxiin dxe ne tsuu xkastig mén, dxe ne ylaa Dëdyuzh gyelextis zegne ryal gako, ");
INSERT INTO zpi_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ydee Ne logne ryal te te mén segun ne wlaa men. ");
INSERT INTO zpi_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Lo yra men ne rye gyelembán ne nunk luzhdet no ne rye gyelenzoon no le gyelnon no ne rsalzaandet ne rlaa ne wen, ydee Ne gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Per le lo yra men ne ngyizh rlayaa Ne no sguu Ne xkastig men por ne rlaandet men gon men diznli, lel dizmal rlaan men gon men. ");
INSERT INTO zpi_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Zuu kastig no le gyelenles por yra men ne rlaa ne mal, primer tsuu xkastig men ne nak men-Israel, lex tsuu xkastig men ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Per le lo yra men ne rlaa ne wen, ydee Dëdyuzh gyelenzoon, gyelnon, gyelendxi, primer ydee No lo men ne nak men-Israel, lex ydee No lo men ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Porke chene ylaa Dëdyuzh gyelextis, kwedet Ne mén. ");
INSERT INTO zpi_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Yrandxee men ne nandet pezee zëëd lo ley ne wdee Dëdyuzh lo Moises, lex rlaa men dol, sakzi men, per sakzidet men zegne zëëd lo ley guin; le yrandxee men ne rlaa dol mase nan men pezee zëëd lo ley guin, zegne zëëd ke lo ley guin, zenga ke sakzi men. ");
INSERT INTO zpi_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Porke let nozdet por ne ykagyedyag mén diiz ne zëëd lo ley nak ne gakxnëz men nes lo Dëdyuzh, sinke por ne ylaa men ne zëëd lo ley, neguin nak ne gakxnëz men. ");
INSERT INTO zpi_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Per le mén ne nakdet men-Israel, mase ni yëten men ley ne wdee Dëdyuzh lo Moises, chene rlaa men ne zëëd lo ley guin noze kon xgyeryen men, laake men nak xley men. ");
INSERT INTO zpi_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Por yra neguin ne rlaa men rbonyoo men ne noze lenlextoo men ryenen men gan kox zëëd lo ley, no ngyidet nuu lextoo men chene rlaa men ne mal; le chene rlaa men ne wen, wen nuu lextoo men. ");
INSERT INTO zpi_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Zenga gak chene ydxiin dxe ne por Jesucrist ylaa Dëdyuzh gyelextis lo mén por yra ne ngueedx ne wlaa men. Ylaa No zegne zëëd lo xdiznzoon Jesucrist ne rzëët noo lo mén. ");
INSERT INTO zpi_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Laa de re de ne men-Israel nak de no re de ne ley ne wdee Dëdyuzh lo Moises rkalo de no ne nzoon nuu lextoo de ne nak de xpén Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","no re de nan de gonezhe rlaan Ne ne ylaa de no ne lo ley nak ne zëëd gonezhe nak ne mazre wendee por laa de, ");
INSERT INTO zpi_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","no re de ne zun de gan yluu de xnëz Dëdyuzh lo menngwlëë no ne zun de gan ylaa de ne tee bnii xgyeryen mén ne zadet xnëz Dëdyuzh, ");
INSERT INTO zpi_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","no re de ne zun de gan yneluu de mén ne bet nandet no le mén ne rdeedet kwent wen, porke lo ley nak ne zëëd yrandxee ne nan de no le ne nli. ");
INSERT INTO zpi_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Belne rneluu de ste mén, ¿penak rneluudet de de laake de? Belne rzëët de lo mén ne kwandet men, ¿penak rbaan de cheguin? ");
INSERT INTO zpi_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","No belne re de ne ykanodet mén men ne nakdet lzaa men, ¿penak rlaa do cheguin? No belne nyaan rwii de mdoo, ¿penak rbaan de ne nuu lenxeydoo mdoo cheguin? ");
INSERT INTO zpi_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Rdxin de ne nan de pezee zëëd lo ley ne wdee Dëdyuzh lo Moises, per rgunyaan de lextoo Dëdyuzh ne rlaadet de zegne zëëd lo ley. ");
INSERT INTO zpi_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Neguinzeg re lo xgyiich Dëdyuzh: “Mén ne nakdet men-Israel rnii diznyaan por Dëdyuzh por xdol de yra de.” ");
INSERT INTO zpi_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Nli ne rkyiin ne ruu beey led men-Israel, belne rlaa men zegne zëëd lo ley; per belne rlaadet men zegne zëëd lo ley, nak ke men zegnak men ne nuudet beey. ");
INSERT INTO zpi_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","No belne rlaa men ne nuudet beey zegne zëëd lo ley, nak ke men zegnak men ne nuu beey, mase nuudet men beey. ");
INSERT INTO zpi_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Men ne nuudet beey per rlaa men zegne zëëd lo ley, laa men nak ne guu gyelentu lo de ne rlaadet de zegne zëëd lo ley, mase rap de ley no mase nuu de beey. ");
INSERT INTO zpi_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Porke ne nak mén men-Israel, let nozdet legya nak ne gak men men-Israel, ni let nozdet por led men tsuu men beey, ");
INSERT INTO zpi_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","sinke men ne nli nak men-Israel, che rzaa xgyeryen men, per wzaadeto por ley, sinke le we wzaa por Espíritu Sant. Men ne che wzaa xgyeryen, Dëdyuzh ylep xeblaan men, let méndet. ");
INSERT INTO zpi_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Naap naa yna de: “¿Pa ykyiin ne nak me men-Israel cheguin? ¿no pa ykyiin ne ruu me beey?” ");
INSERT INTO zpi_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Per noze yralondxee rkyiin ne nak me men-Israel. Ne primer nak ne lo men-Israel wsan xdiiz Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Orrenaa, ¿kox gak ne nuu men-Israel zadet xnëz Dëdyuzh? ¿Peguin ylaadetre Dëdyuzh zegne re Ne ne ylaa Ne? ");
INSERT INTO zpi_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Slaa No; nyaalzhe yrandxee mén rkade, per laa Ne si nli rlaa Ne ne re Ne ne ylaa Ne, zegne re lo xgyiich Ne: Yrandxee mén gaknan ne nli rnii de, no bet gundet men gan ykagyii men de. ");
INSERT INTO zpi_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Per nuu de ne nak de zegnak noze mengyëzlyu gue: “Belne por yra ne mal ne rlaa be nak ne rbonyoo ne xnëz rlaa Dëdyuzh, ¿pagox gue be? ¿Pe ze be ne xnëzdet rlaa Dëdyuzh ne rzakzi Ne be?” ");
INSERT INTO zpi_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","¡Let zengadeto! Porke belne xnëzdet rlaa Dëdyuzh, ¿pezee ylaa Ne gyelextis lo yrandxee mengyëzlyu cheguin? ");
INSERT INTO zpi_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","No ze de: “Belne por ne rkade be nak ne gyenen mén ne nzoon xdiiz Dëdyuzh, ¿penak benak run Dëdyuzh be kwent zegnak mendol cheguin? ");
INSERT INTO zpi_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Belne zenga we, mazre wendee ylaa me ne mal chen ykakwent me ne wen.” Zenga rkagyii mén noo, re men ne zeree nak ne rneluu noo mén, per yra men ne re zenga, rzëël men ne yzakzi Dëdyuzh men. ");
INSERT INTO zpi_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","¿Pagox gue be cheguin? ¿Pe ze be ne ntozdee wen noo yra noo ne nak noo men-Israel ke lo men ne nakdet men-Israel? ¡Let zengadeto! Porke che wbonyoo noo ne yrandxee mén nak mendol, nigle men-Israel, nigle men ne nakdet men-Israel. ");
INSERT INTO zpi_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Porke re lo xgyiich Dëdyuzh: Yët mén ne rlaadet dol, axtegue ni te men yëtet; ");
INSERT INTO zpi_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","yët mén ne rdee kwent, yët mén ne rlaan ye Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Yrandxee men wsalzaan xnëz Dëdyuzh, yrandxee men wak menmal. Yët mén ne rlaa ne wen, axtegue ni te men yëtet. ");
INSERT INTO zpi_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Nak ruu men zegnak baa ne zemyal, no teblose rkade men. Nak gyedruu men zegnak xbenen mëël; ");
INSERT INTO zpi_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","teblose rgyiin rnab men por semén men no teblose diznyaan rnii men. ");
INSERT INTO zpi_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Noze rzhoon men za men chen yket men semén men. ");
INSERT INTO zpi_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kwaskyertee ledne za men, teblose ne bat rkyiindet rlaa men no rzakzi men semén men. ");
INSERT INTO zpi_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Nandet men nuu gyelendxi. ");
INSERT INTO zpi_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Axtegue ni rdxedet men Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Laa be nan be ne yrandxee ne zëëd lo ley ne wdee Dëdyuzh lo Moises por mén ne rlaa ne zëëd lo ley nako, chen bet gakdet men gyii yrandxee men no chen ylaa Dëdyuzh gyelextis lo yrandxee mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Porke let por ne rlaadet mén ne zëëd lo ley nak ne run Dëdyuzh perdon xdol men, sinke le ley nak por ne gaknan men ne mendol nak men. ");
INSERT INTO zpi_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Per naaree che wbonyoo Dëdyuzh gan pezee run Ne perdon xdol mén, per nakdeto por ne rlaa men zegne zëëd lo ley. Yra neree che rakzëëto lo ley no che ke wzëët profeto, ");
INSERT INTO zpi_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ne run Dëdyuzh perdon xdol yrandxee men ne rlaleedx Jesucrist. Tese nak yrandxee mén ");
INSERT INTO zpi_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","porke yrandxee men wlaa dol, ni te men ryaldet yganen xgyelenzoon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Per por xgyelwen Dëdyuzh wun Ne perdon xdol men, noze xla wlaa No bet wgoobdet Ne; wselaa Ne yra mén lo kastig por ne wgyizh Jesucrist xdol men chene wet Ne lo kruz. ");
INSERT INTO zpi_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Dëdyuzh nak ne wxaal Jesucrist nee gyëzlyuree, chen por xren Ne ne yzhe chene guet Ne gak perdon xdol yrandxee mén ne rlaleedx Ne. Wlaa Dëdyuzho chen gaknyoo ne ryal yra ne rlaa Ne por ne rap Ne pasens mén, wundet Ne kwent yra dol ne wlaa men chekwlo, ");
INSERT INTO zpi_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","porke rlaan Ne ne naaree gaknyoo ne ryal ne rlaa Ne chen zenga gaknyoo ne syemper rlaa Ne ne ryal gak no ne run Ne perdon xdol yra mén ne rlaleedx Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Por neguin nuudet tsugya lextoo be. Porke let por ne rlaadet men ne zëëd lo ley nak ne wak perdon xdol men, sinke por ne rlaleedx men Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Por neguin nanwen be ne por ne rlaleedx mén Jesucrist nak ne run Dëdyuzh perdon xdol men, nakdeto por ne rlaa men zegne zëëd lo ley. ");
INSERT INTO zpi_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Naap naa yna de: “¿Peguin noze XDëdyuzh men-Israel nak Dëdyuzh?” ¡Let zengadeto! Sinke no ke XDëdyuzh men ne nakdet men-Israel nak Ne. XDëdyuzh yrandxee mén nak Ne. ");
INSERT INTO zpi_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Porke tendxee Dëdyuzh nuu: laa Ne nak ne run perdon xdol men ne rlaleedx Jesucrist, sin ne rwiidet Ne belne nuu men beey ne ruu men-Israel o yëtet meno. ");
INSERT INTO zpi_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","No naap naa yna de: “¿Pe batre rkyiindet ley naaree ne che rlaleedx be Jesucrist?” ¡Let zengadeto! Lel mazre rzëët be ne zëëd lo ley. ");
INSERT INTO zpi_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Zegnak xkwent Abraham xpenkwlal noo, ¿kox gue be por laa men? ");
INSERT INTO zpi_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Belne por yra ne wlaa Abraham nak ne wun Dëdyuzh perdon xdol Abraham, nyuu gan kox nyugya lextoo Abraham, per let nes lodet Dëdyuzh, sinke nes lo mén. ");
INSERT INTO zpi_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Porke re lo xgyiich Dëdyuzh: “Wlaleedx Abraham Dëdyuzh; por neguin wun Ne Abraham kwent zegnak te men ne nunk wlaadet dol.” ");
INSERT INTO zpi_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Zegnak men ne rlaa dxiin, med ne rezh rka men, nakdeto ne reeden men, sinke ryal meno por ne che wlaa men dxiin. ");
INSERT INTO zpi_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Nuudet gak perdon xdol mén por logne rlaa men, per por ne rlaleedx men Dëdyuzh ne run perdon xdol mén, por neguin nak ne wun Ne men kwent zegnak te men ne nunk wlaadet dol. ");
INSERT INTO zpi_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Zenga ke re rrey-David ne nzoon men ne wun Dëdyuzh perdon xdol, per nakdeto por logne wlaa men, ");
INSERT INTO zpi_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","laa we nga re rrey-David chene re men: Nzoon men ne wun Dëdyuzh perdon xdol no ne wgyitxee Dëdyuzh xdol. ");
INSERT INTO zpi_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Nzoon men ne wundet Dëdyuzh kwent xdol. ");
INSERT INTO zpi_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Naap naa yna de: “¿Pe noze por men ne nuu beey ne ruu men-Israel nak gyelenzoonree?” ¡Let zengadeto! Sinke le we nak no ke por men ne nuudet beey. Che re be ne por ne wlaleedx Abraham Dëdyuzh, wun Ne Abraham kwent zegnak te men ne nunk wlaadet dol. ");
INSERT INTO zpi_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","No sna de: “¿Pa or wlaa No? ¿Pe chene che wuu Abraham beey ne ruu men-Israel u chene gardet tsuu Abraham beey?” Per yzëët noo gan pa or wlaa No: chene gardet tsuu Abraham beey, cheguin wlaa No. ");
INSERT INTO zpi_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Zhich guin wuu Abraham beey zegnak te beey ne che wun Dëdyuzh perdon xdol Abraham por ne wlaleedx Abraham Ne. Zeree nak ne le Abraham wak xuz yrandxee men ne rlaleedx Ne, nyaalzhe yëtet mén guin beey, per por ne rlaleedx men Ne, wun Ne men kwent zegnak te men ne nunk wlaadet dol. ");
INSERT INTO zpi_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","No laake Abraham nak xuz yra mén ne nuu beey, per rlaleedx ke men Dëdyuzh zegne wlaleedx Abraham Dëdyuzh chene gardet tsuu Abraham beey ne ruu men-Israel. ");
INSERT INTO zpi_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Chene re Dëdyuzh lo Abraham ne ygueed Ne gyëzlyuree lo Abraham yra Abraham men ne zëëd xnëz Abraham, nakdeto por ne wlaa Abraham zegne zëëd lo ley, sinke le we nak por ne wun Ne perdon xdol Abraham porke wlaleedx Abraham Ne. ");
INSERT INTO zpi_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Belne nako ne nonchee men ne rlaa zegne zëëd lo ley ykakwent gyëzlyuree zegne che re Dëdyuzh lo Abraham, cheguin si bat ykyiindet ne ylaleedx mén Dëdyuzh no nyaknondet ne re Dëdyuzh lo Abraham. ");
INSERT INTO zpi_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Porke por ley nak ne nuu kastig, per le ledne yëtet ley, let doldet ne ylaadet mén zegne zëëd lo ley. ");
INSERT INTO zpi_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Por neguin por ne wlaleedx Abraham Dëdyuzh, por xgyelwen Ne tesudet ne ylaa Ne zegne che re Ne lo Abraham ne ylaa Ne por yra men ne zëëd xnëz Abraham. Neree ne re Ne nakdeto nonchee por men ne rlaa zegne zëëd lo ley, sinke le we nak no por men ne rlaleedx Dëdyuzh zegne wlaleedx Abraham Dëdyuzh; neguin Abraham nak xuz be yra be ");
INSERT INTO zpi_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","nes lo Dëdyuzh, zegne zëëd lo xgyiich Dëdyuzh ledne re: “Wlaa noo de xuz ndal mengyëzlyu.” Laa Dëdyuzhree nga nak ne wlaleedx Abraham, Dëdyuzh ne rneban mengut no ne rlaa ne ruu yra kos ne gardet tsuu. ");
INSERT INTO zpi_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Mase che nuudetre lextoo Abraham ne tsuu zhiin Abraham, per wlaleedx Abraham ydebgyiky ydeblextootee Abraham logne re Dëdyuzh lo Abraham, zenga nak ne wak Abraham “xuz ndal mengyëzlyu”, zegne che re Dëdyuzh lo Abraham: “Kesentyent ndalyaa mén ne zëëd xnëz de tsuu.” ");
INSERT INTO zpi_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Mase che rap Abraham zeg tebgwyuu iz no che ke gol Sara xewnaa Abraham no mase nuudet nyap men mëëd no mase che wdesu ne gap men mëëd, per syemper wlaleedx Abraham ne re Dëdyuzh lo Abraham. ");
INSERT INTO zpi_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Wtxupdet lextoo Abraham, ni wuudet lextoo Abraham texnad gakdet ne re Dëdyuzh lo Abraham, sinke lel mazre wlaleedx Abraham Ne no mazre wzaknon Abraham Ne, ");
INSERT INTO zpi_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","porke ydebgyiky ydeblextootee Abraham wlaleedx Abraham ne rap Ne poder por ne ylaa Ne ne che re Ne. ");
INSERT INTO zpi_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Por neguin wun Ne Abraham kwent zegnak te men ne nunk wlaadet dol por ne wlaleedx Abraham Ne. ");
INSERT INTO zpi_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ledne re ne wun Dëdyuzh Abraham kwent zegnak te men ne nunk wlaadet dol por ne wlaleedx Abraham Dëdyuzh, wundet Dëdyuzh kwent nonchee Abraham, ");
INSERT INTO zpi_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","sinke no ke laa be yra be wun Dëdyuzh kwent zegnak te men ne nunk wlaadet dol por ne wlaleedx be ne laa Ne wneban Jesucrist ");
INSERT INTO zpi_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ne wdee si wet chen guezh xdol be no ne wban ne le xdol be wak perdon. ");
INSERT INTO zpi_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Wun Dëdyuzh perdon xdol be por ne rlaleedx be Jesucrist, por neguin rap be gyelendxi nes lo Dëdyuzh por Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Porke por ne rlaleedx be Jesucrist, che zak ydxiin be lo Dëdyuzh por xgyelwen Dëdyuzh no rsalzaandet be ne rlaleedx be Jesucrist, no nzoon nuu lextoo be ne nanwen be ne no be yganen xgyelenzoon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","No let nozdet neree, sinke nunzoon ke lextoo be ne rak be sufrir, porke nan be ne chene rak be sufrir, nga rseed be rap be pasens. ");
INSERT INTO zpi_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","No chene che rap be pasens, nga ryen ne run be wantar lo yrandxee ne rzak be, no chene che run be wantar, raknanwen be ne no be gyal xgyelenzoon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","No neguin ne che nanwen be rnexonleedxdeto be, porke kesentyent ryaan Dëdyuzh be por Espíritu Sant ne wseleedx Ne lo be. ");
INSERT INTO zpi_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Chekwlo chene bet wakdet nlaa be por ne nyak perdon xdol be, laatee cheguin wdxiid Jesucrist wet Ne por xdol be ne nak be mendol. ");
INSERT INTO zpi_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Let mbëëdet ne ydee te mén si ne guet men por xkwent ste mén, per ni por te mén ne bet xdoldet, o pazer nuu mén ydee si guet por te men ne kesentyent wen. ");
INSERT INTO zpi_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Per che wbonyoo Dëdyuzh ne ryaan Ne be, porke chene benak nak be mendol, wet Jesucrist por xdol be. ");
INSERT INTO zpi_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Naaree ne che wun Dëdyuzh perdon xdol be por ne wet Jesucrist por laa be, nanwen be ne por Jesucrist yzakzidet Dëdyuzh be. ");
INSERT INTO zpi_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Si chekwlo chene wak be xkontrar Dëdyuzh, laake Ne wlaa ne wakwen be lo Ne por ne wet Jesucrist XPee Ne, ¡peleske naaree ne che nakdetre be xkontrar Ne, ne yselaadet Ne be lo kastig por ne wban Jesucrist XPee Ne! ");
INSERT INTO zpi_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","No let nozdet neree, sinke kesentyent nzoon nuu lextoo be por logne rlaa Ne ne wxaal Ne Jesucrist porke por Jesucrist wakwen be lo Ne. ");
INSERT INTO zpi_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Por te mgyeey nak ne wzelo wuu dol gyëzlyu no por dol nak ne wzelo wuu gyelgut, neguin nak ne yrandxee mén ret, porke yrandxee men rlaa dol. ");
INSERT INTO zpi_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Axtegue chene gardet tsuu ley ne wdee Dëdyuzh lo Moises, che nuu dol gyëzlyu; per wundet Dëdyuzh kwent xdol mén porke gardet tsuu ley. ");
INSERT INTO zpi_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Per mase zenga, yrandxee mén ne wuu desde ne wuu Adán axtegue ne wuu Moises, wap men degne wet men yrandxee men, mase wlaadet men zegnak dol ne wlaa Adán ne wondet Adán xdiiz Dëdyuzh; Adán nak zegnak te beey por men ne chiid. ");
INSERT INTO zpi_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Dol ne wlaa Adán gakdet yzaglo we ne wen ne rseleedx Dëdyuzh. Por xdol tebegue mén nak ne ret yrandxee mén, per mazre ntozdee nzoon ne rseleedx Dëdyuzh lo ndalyaa mén por xgyelwen Dëdyuzh por logne wlaa tebegue mén, laa men nga nak Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Xdol te mén gakdet yzaglo we ne rseleedx Dëdyuzh. Por te dol ne wlaa Adán nak ne nuu xkastig yrandxee mén, per le ne rseleedx Dëdyuzh laa we rlaa ne gak perdon xdol yrandxee mén. ");
INSERT INTO zpi_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Porke por xdol tebegue mén nak ne rap degne ret yrandxee mén, per mazre ntozdee nzoon ne rseleedx Dëdyuzh por xgyelwen Dëdyuzh lo yra men ne wun Dëdyuzh perdon xdol; chene gap yra men guin gyelembán ne nunk luzhdet, laa men ynebééy, tebegue mén ylaa ne ynebééy men; laa men ne ylaa ne ynebééy men nga nak Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Zegne wak ne por te dol ne wlaa Adán nak ne nuu xkastig yrandxee mén, zenga ke por ne wen ne wlaa Jesucrist nak ne nuu perdon por yrandxee mén chen gap men gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Zenga zegne wak ne por tebegue mén ne wondet diiz, yrandxee mén nak mendol, zenga ke por tebegue mén ne won diiz, ndalyaa mén gak perdon xdol. ");
INSERT INTO zpi_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Wdee Dëdyuzh ley lo Moises chen ylaadetre mén dol, per lel mazre walaa men dol, no chene che kesentyent wlaa men dol, mazre wbonyoo Dëdyuzh xgyelwen Dëdyuzh, wun Ne men perdon. ");
INSERT INTO zpi_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Zegne rlaa dol ne por dol rap degne ret yrandxee mén, zenga ke por xgyelwen Dëdyuzh wun Ne mén perdon chen gap men gyelembán ne nunk luzhdet por Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Naap naa yna de: “¿Pe rap be degne ylar be dol chen konyoor Dëdyuzh xgyelwen Ne lo be?” ");
INSERT INTO zpi_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","¡Let zengadeto! Porke laa be ne nak be zegnak men ne che wet, ylaadetre be dol, yëtre neguin ne ylar be dol. ");
INSERT INTO zpi_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","¿Pe nandet de ne wrobnis be por la Jesucrist, neguin rna ne wet be yra be Ne? ");
INSERT INTO zpi_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Porke gyelrobnis guin rna ne wugyeer be yra be Ne, chen yban be gap be ste gyelembán zegne wban ke Ne por xpodernzoon Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","No belne che wet be yra be Ne, zenga ke yban be zegne wban ke Ne. ");
INSERT INTO zpi_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Che nan be ne yra zegne wak be chekwlo wsaan bo chene wkaa Jesucrist lo kruz, chen ysaan be ne rlaan be ylaa be dol no chen gakdetre be zegnak ne che wdoo be lo dol. ");
INSERT INTO zpi_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Porke men ne che wet, che rlaadetre men dol. ");
INSERT INTO zpi_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Belne che wet be yra be Jesucrist, zenga ke ylaleedx be ne sbán be yra be Ne. ");
INSERT INTO zpi_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Che nan be ne wbanse Jesucrist, guetetre Ne ste, che gundetre gyelgut gan yketo Ne. ");
INSERT INTO zpi_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Porke tebtiregue wet Ne por xdol yrandxee mén. Naaree naa ne mbán Ne, mbán Ne por ne ylar Ne xdxiin Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Zenga ke laa de yra de, gugun kwent ne che wet de chen ylaadetre de dol, per mbán de por ne ylaa de xdxiin Dëdyuzh ne che nak de xpén Jesucrist. ");
INSERT INTO zpi_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Por neguin myentras ne mbán de nee gyëzlyuree, ydeedet de si ne ysegyee dol lextoo de ne ylaa de ne rlaan led de. ");
INSERT INTO zpi_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Koleedxdet led de lo dol por ne ylaa we dol. Mazdee gukoleedx de lo Dëdyuzh zegnak men ne che wet no ne wban ke. Gukoleedx led de lo Dëdyuzh por ne ylaa de ne wen. ");
INSERT INTO zpi_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Porke che rundetre dol gan ysegyee dol lextoo de, per nakdeto por ne rlaa de zegne ne zëëd lo ley, sinke le we nak por xgyelwen Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Naap naa yna de: “Naaree ne rlaadetre be zegne zëëd lo ley, sinke le be che mbán por xgyelwen Dëdyuzh, ¿pe rap be degne ylar be dol?” ¡Let zengadeto! ");
INSERT INTO zpi_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","¿Pe nandet de ne chene rdeese de si ne rak de zegnak mén ne che wdoo lo mén, rap de degne gon de xdiiz mén guin? Zenga ke belne nak de zegnak mén ne che wdoo lo dol, laa we ylaa ne guet de, per belne lo Dëdyuzh nak de zegnak mén che wdoo, laa Dëdyuzh nak ne gun perdon xdol de. ");
INSERT INTO zpi_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Dexkyizhtee Dëdyuzh ne mase wak de zegnak mén ne che wdoo lo dol chekwlo, per naaree che zanal de xdiiz Dëdyuzh ydeblextoo de zegne wseed do. ");
INSERT INTO zpi_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Naaree ne nakdetre de zegnak mén ne che wdoo lo dol, che lo Dëdyuzh nak de zegnak mén ne che wdoo. ");
INSERT INTO zpi_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","(Dizmbëë ne ydee de kwent rnii noo, porke che nan noo ne ngan ydee de kwent yra neree.) Zegne wboleedx led de lo dol chekwlo por ne ylaa we ne bat ykyiindet no le ne mal, zenga ke gukoleedxo lo Dëdyuzh naaree, por ne ylaa we zegne rlaan Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Chene benak nak de zegnak mén ne che wdoo lo dol, ni zadet lextoo de ne ylaa de zegne rlaan Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Per, ¿pagox wun de gan ne wlaa de yra ne mal guin? Naaree naa ne rnileedx de ne wlaa do, rtuunen de. Porke laa we nak ne rlaa ne ret mén. ");
INSERT INTO zpi_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Naaree ne nakdetre de zegnak mén ne che wdoo lo dol no ne che lo Dëdyuzh nak de zegnak mén ne che wdoo, che rlaa de zegne rlaan Ne no che zap de gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Porke noze gyelgut run mén gan ne rlaa men dol, per le ne rseleedx Dëdyuzh lo yra xpén Jesucrist nak gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Yra de ne no de rlaleedx Jesucrist, nan de pezee zëëd lo ley ne wdee Dëdyuzh lo Moises, laa ley guin nak ne rnebééy lo mén per nonchee ydeblo ne mbán men. ");
INSERT INTO zpi_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Zenga ke nak te wnaa ne che wtsëlnya, zëëd lo ley ne xpoder xemgyeey men nuu men myentras ne mbán xemgyeey men, per belne guet xemgyeey men, cheguin si che wyan men liber. ");
INSERT INTO zpi_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Por neguin belne ytsëlnya men ste mgyeey myentras ne mbán xemgyeey men, neguin ne ylaa men dolo, adulterio la dol guin; per belne che wet xemgyeey men, cheguin si che wyan men liber. Mase ytsëlnya men ste mgyeey let doldetro. ");
INSERT INTO zpi_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Zenga ke laa de yra de ne no de rlaleedx Jesucrist, por ne wet Jesucrist che wyan de liber ylaadetre de zegne zëëd lo ley ne wdee Dëdyuzh lo Moises porke che nak de zegnak men ne che wet nes lo ley. Che xpén Jesucrist ne wban nak de, che zak ylaa de zegne rlaan Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Porke chene benak rlaa be zegne rlaa men ne nak noze mengyëzlyu, laa ley guin wlaa ne mazre wlaan be ylaa be ne mal ne rzëël guet be. ");
INSERT INTO zpi_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Per naaree ne che nak be zegnak men ne che wet, che wyan be liber ylaadetre be zegne zëëd lo ley guin zegne wap be degne wlaa bo chekwlo. Che zak ylaa be ne rlaan Dëdyuzh naaree ne che rap be gyelembánkweb ne rseleedx Espíritu Sant, per ylaadetre bo zegne zëëd lo ley guin. ");
INSERT INTO zpi_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Naap naa yna de: “¿Pe dol yra ne zëëd lo ley ne wdee Dëdyuzh lo Moises cheguin?” ¡Let zengadeto! Belne yëtet ley, nyaknandet noo gonezhe nak dol, ni nyaknandet noo ne dol ne rdeben me logne rap ste mén belne zëëdet lo ley: “Ydebden de logne rap ste mén.” ");
INSERT INTO zpi_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Per por yra ke ne zëëd lo ley, wlaa dol ne mazre wdeben noo logne rap ste mén. Belne nyakyëtet ley, bet nyundet dol gan nlaa dol noo. ");
INSERT INTO zpi_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Chekwlo noze le noo wbán, wdeedet noo kwent ne zëëd lo ley, per chene wdee noo kwento, mazre wdaal xdol noo, por neguin wak noo zegnak men ne che wet. ");
INSERT INTO zpi_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Zenga nak ne wyenen noo ne ley ke ne ryal nlaa ne nbánre noo, lel wlaa we noo zegnak men ne che wet. ");
INSERT INTO zpi_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Porke por yra ke ne zëëd lo ley nak ne wkade dol noo, wlaa we noo zegnak men ne che wet. ");
INSERT INTO zpi_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Per maldet ley porke xdiiz Dëdyuzh nako, no yrandxee ne zëëd lo we, xdiiz Dëdyuzho, xnëzo no weno. ");
INSERT INTO zpi_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Let leydet wlaa ne wak noo zegnak men ne che wet, sinke laa dol nak ne wlaa we por yra ke ne zëëd lo ley, zenga wbonyoo dol ne nli dol nak dol no zenga wbonyoo ley ne kesentyent mal ne ylaa mén dol. ");
INSERT INTO zpi_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Laa be nan be ne yrandxee ne zëëd lo ley, xdiiz Dëdyuzh nako, per por ne nak noo mengyëzlyu, syemper run dol gan lo noo. ");
INSERT INTO zpi_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Nandet noo penak rzak noo zeree, ne rlaadet noo ne rlaan noo ylaa noo, sinke lel ne rlaandet noo ylaa noo, neguin nak ne rlaa noo. ");
INSERT INTO zpi_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","No chene rlaa noo ne rlaandet noo ylaa noo, nga nak ne ryenen noo ne wen ley. ");
INSERT INTO zpi_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Let noodet rlaa ne rlaandet noo ylaa noo, sinke laa dol ne neey noo nak ne rlaa we. ");
INSERT INTO zpi_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","No nan noo ne bet ne wen rlaadet noo ne nak noo mengyëzlyu, porke mase rlaan noo ylaa noo ne wen, per rundet noo gan ylaa noo we. ");
INSERT INTO zpi_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Rlaadet noo ne wen ne rlaan noo ylaa noo, sinke lel ne mal ne rlaandet noo ylaa noo, neguin nak ne rlaa noo. ");
INSERT INTO zpi_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Per belne rlaa noo ne rlaandet noo ylaa noo, let noodet rlaa we, sinke laa dol ne neey noo nak ne rlaa we. ");
INSERT INTO zpi_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Por neguin nak ne ryenen noo ne chene rlaan noo ylaa noo ne wen, lel ne mal rlaa noo. ");
INSERT INTO zpi_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Por lenlextoo noo kesentyent rtseleedx noo ne zëëd lo xley Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Per ryenen noo ne led noo nuu te ne rsegyee lextoo noo; laa we nga nak dol ne neey noo no ne rsoow rtsëëtee lo noo. ");
INSERT INTO zpi_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","¡Prob noo nga! ¿Txuzhleg nak ne yselaa xanem noo lo gyelgut chene guet xkwerp noo? ");
INSERT INTO zpi_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Per dexkyizhtee Dëdyuzh ne por Jesucrist wselaa Dëdyuzh xanem noo lo gyelgut. Mase rlaan noo ylaa noo ne zëëd lo xley Dëdyuzh, per kom mengyëzlyu nak noo, syemper rlaa noo dol. ");
INSERT INTO zpi_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Yrandxee men ne rlaleedx Jesucrist, yzakzidet Dëdyuzh men, yra men guin rlaadetre men zegne rlaa men ne nak noze mengyëzlyu, sinke le men rlaa zegne rlaan Espíritu Sant. ");
INSERT INTO zpi_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Por ne rlaleedx be Jesucrist, wláá be lo dol no le lo gyelgut por xpoder Espíritu Sant ne rseleedx gyelembán. ");
INSERT INTO zpi_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Ley ne wdee Dëdyuzh lo Moises wundeto gan nselaa we be lo dol por ne nak be noze mengyëzlyu. Por neguin wxaal Dëdyuzh XPee Ne nee gyëzlyuree zegnak noze mengyëzlyu chen guet XPee Ne chen por ne guezh xdol be, zenga nak ne wkuudx Ne poder ne rap dol. ");
INSERT INTO zpi_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Wlaa Ne neree, chen laa be yra be nak ne ylaa ne wen zegne zëëd lo ley, porke rlaadetre be zegne rlaa men ne nak noze mengyëzlyu, sinke le be rlaa zegne rlaan Espíritu Sant. ");
INSERT INTO zpi_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Yra mén ne nak noze mengyëzlyu, teblose ne mal ne nuu gyëzlyu za lextoo men; per le men ne rlaa zegne rlaan Espíritu Sant, ne rlaan ke Espíritu Sant za lextoo men. ");
INSERT INTO zpi_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","No ne za lextoo mén teblose ne mal ne nuu gyëzlyu, laa we ylaa ne guet men; per le ne za lextoo mén ne rlaan Espíritu Sant, neguin ylaa ne gap men gyelembán ne nunk luzhdet no le gyelendxi. ");
INSERT INTO zpi_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Yra mén ne za lextoo teblose ne mal ne nuu gyëzlyu, rwinyaan men Dëdyuzh, porke rlaandet men ylaa men zegne zëëd lo xley Ne, ni rundet zeg men gan ylaa meno. ");
INSERT INTO zpi_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Por neguin yra mén ne nak noze mengyëzlyu, gundet men gan ylaa men zegne rtseleedx Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Per laa de yra de, che rlaadetre de zegne rlaa men ne nak noze mengyëzlyu, sinke le de che rlaa zegne rlaan Espíritu Sant belne nli ne nuu Espíritu Sant lextoo de; le men ne yëtet Espíritu Sant lextoo, let xpéndet Jesucrist nak men. ");
INSERT INTO zpi_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Per belne laa Jesucrist raknonen de, mase guet xkwerp de por dol, per mbán xespíritu de por ne che wun Dëdyuzh perdon xdol de. ");
INSERT INTO zpi_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Dëdyuzh wneban Jesucrist; belne nuu XEspíritu Dëdyuzh guin lextoo de, laake Dëdyuzh guin ne wneban Jesucrist yneban xkwerp de ne guet, chen gap de ste gyelembán por XEspíritu Dëdyuzh ne nuu lextoo de. ");
INSERT INTO zpi_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Por neguin, yra de ne no de rlaleedx Jesucrist, che yëtre neguin ne ylaa de zegne rlaa men ne nak noze mengyëzlyu. ");
INSERT INTO zpi_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Porke belne laa de ne rlaa de zegne rlaa men ne nak noze mengyëzlyu, nunk gyaldet sakzi de; per belne por Espíritu Sant zasalzaan de yra ne mal ne rlaa noze mengyëzlyu, zap de gyelembán ne nunk luzhdet. ");
INSERT INTO zpi_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Yrandxee men ne rlaa ne rlaan Espíritu Sant, zhiin Dëdyuzh nak men. ");
INSERT INTO zpi_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Porke wkakwentet de espíritu ne ylaa ne gak de zegnak mén ne che wdoo lo gyelerdxeeb ste, sinke le de wkakwent Espíritu Sant ne wlaa ne wak de zhiin Dëdyuzh; por neguin nan be lo Dëdyuzh: “¡Abba, Dëde!” ");
INSERT INTO zpi_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","No laake Espíritu Sant raknonen xespíritu be ne raknan be ne zhiin Dëdyuzh nak be. ");
INSERT INTO zpi_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","No por ne nak be zhiin Dëdyuzh, no ke be gyal ne ryal Jesucrist belne rak be sufrir zegne wak Jesucrist sufrir chen no ke be gap gyelenzoon ne rap Ne. ");
INSERT INTO zpi_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","No nanwen noo ne yra ne rak be sufrir naaree, axtegue rzaglodeto gyelenzoon ne gyed kwii be. ");
INSERT INTO zpi_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Yrandxee ne wzhexkwaa Dëdyuzh, zoono naal pezee gyengue gan go menzhe nak yra zhiin Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Porke yrandxee ne wzhexkwaa Dëdyuzh, che wzhiino, per let laadeto wlaan ne wako zenga, sinke laa Dëdyuzh nak ne wlaa we, per syemper kambë́zo ");
INSERT INTO zpi_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","gan pe ylakwebdet Dëdyuzho, chen no we yláá kon gyelenzoon zegne wláá yra men ne nak zhiin Dëdyuzh kon gyelenzoon. ");
INSERT INTO zpi_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Nan be ne axtegue naaree, yrandxee ne wzhexkwaa Dëdyuzh benak baanske rako sufrir zegne rzak wnaa ne rzebyoob men chene rzan men zhiin men. ");
INSERT INTO zpi_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","No let nozdet yra ne wzhexkwaa Dëdyuzh nak ne rak sufrir, sinke no ke be. Dëdyuzh wseleedx Espíritu Sant lo be zegnak te beey ne nuu ne yniiz Dëdyuzh lo be. Kesentyent baanske rak be sufrir ydeblo ne kambë́z be ne gaknyoo ne zhiin Dëdyuzh nak be no ne ylaa Ne xkwerp be zegnak te ne kweb. ");
INSERT INTO zpi_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Por ne rlaleedx be ne zak neree, neguin nak ne wláá be lo dol. Logne che nyoo, rkambë́zdetre mo. ¿Pe dxiin ykambë́z me ne che rwii me? ");
INSERT INTO zpi_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Per belne kambë́z be ne gardet kwii be, rap be degne ykambë́z bo, gyëëten be. ");
INSERT INTO zpi_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Laa Espíritu Sant nak ne run xyudar be chene nandet be pezee ylaa be; porke nandet be pezee ynab be lo Dëdyuzh zegne ryal ynab be lo Ne, laa Espíritu Sant rnab lo Dëdyuzh por laa be, per rnabdet Ne kon diiz. ");
INSERT INTO zpi_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Nan Dëdyuzh gan pe rlebleedx mén no nan Ne gan pe rnab Espíritu Sant lo Ne por yra mén ne nak xpén Ne, porke laa Espíritu Sant si rnab zegne rlaan Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Che nan be ne por ne ryaan be Dëdyuzh no por ne wye Ne be zegne rlaan Ne, yrandxee ne rzak be, laa Dëdyuzh rdee si rzak bo porke weno por laa be. ");
INSERT INTO zpi_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","No axtegue chekwlo, che nan Dëdyuzh gan txu men nak men ne ylaleedx Ne no che wsanla Ne men ne gak men zegnak Jesucrist XPee Ne, chen laa Jesucrist gak men primer lo yrandxee men ne nak zhiin Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Yra men ne wsanla Ne axtegue chekwlo, wbëz Ne men; yra men ne wbëz Ne, wun Ne perdon xdol men; yra men ne wun Ne perdon xdol, wseleedx Ne gyelenzoon lo men. ");
INSERT INTO zpi_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","¿Orrenaa pagox gue be por yra neree? Si Dëdyuzh nak ne raknonen be, ¿txuzh gun gan lo be? ");
INSERT INTO zpi_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Wsoowdet Ne ne nyet XPee Ne, sinke wdee Ne si wet mee por laa be yra be; no belne wdee Ne si wet XPee Ne por laa be, ¡peleske yra kos yniizdet Ne lo be! ");
INSERT INTO zpi_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Yët neguin ne ykagyii mén xpén Dëdyuzh, porke Dëdyuzh nak ne run perdon xdol men. ");
INSERT INTO zpi_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Yët neguin ne ykyeen mén ne sakzi men, porke laa Jesucrist nak ne wet por laa men no wban ke Ne, no naaree naa le Ne zob koo Dëdyuzh ladbëë rnab Ne lo Dëdyuzh por laa be yra be men. ");
INSERT INTO zpi_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Bet gundet gan ylaa ne gyaandetre Jesucrist be: ni gyelenles, ni gyelzi, ni ne ykanal mén be chen yzakzi men be, ni gbiin, ni gyelzi lër, ni gyelerdxeeb, ni gyelgut. ");
INSERT INTO zpi_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Zegne zëëd lo xgyiich Dëdyuzh ledne re: Por ne nak noo xpén de yra noo, yzaandxee dxe rlaan mén yket mén noo, rlaa men noo zeg rlaa mén mëkzhiil ne che zu lo mén chen yket men maa. ");
INSERT INTO zpi_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Per yrandxee neree, rrukaa be lo we por Jesucrist porke ryaan Jesucrist be. ");
INSERT INTO zpi_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Noo nanwen noo ne ni gyelgut, ni gyelembán, ni angel, ni Bzelo, ni poder, ni ne che nuu, ni ne gyed tsuu, ");
INSERT INTO zpi_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ni ne nuu gyeybaa, ni ne nuu linfyeren, ni te ne wzhexkwaa Dëdyuzh gundet gan ylaa ne gyaandetre Dëdyuzh be; por Jesucrist wbonyoo Dëdyuzh ne ryaan Dëdyuzh be. ");
INSERT INTO zpi_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Por ne nak noo xpén Jesucrist, nli rnii noo, rkadedet noo; laa Espíritu Sant rlaa ne rzëët noo ne nli ne ");
INSERT INTO zpi_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","kesentyent nles nuu lextoo noo axtegue nandet noo pe rako, axtegue rbë́zdeto, ");
INSERT INTO zpi_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","porke zoon noo naal pezee yláá menlaz noo chen sakzidet men, nyaalzhe sakzi noo xkwent men, nyaalzhe koleedx Jesucrist noo belne por neguin yláá menlaz noo ");
INSERT INTO zpi_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ne nak men-Israel. Wun Dëdyuzh men kwent zegnak zhiin Dëdyuzh, lo men nak ne wluu Ne xgyelenzoon Ne, wyan Ne men diiz gan kox ylaa Ne por laa men, por laa men nak ley ne wdee Ne lo Moises, wye Ne men ne saknon men Ne, no por laa men nak yra ne re Ne ne ylaa Ne. ");
INSERT INTO zpi_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Xnëz menkwlal zëëd men yra men; laa yra la menkwlal guin nee: Abraham, Isaac, Jacob, no nëz ke guin zëëd Jesucrist chene wuu Ne gyëzlyuree, laa Ne nak Dëdyuzh ne rnebééy yrandxee kos, nzoon Ne ydeblo siguelendxee. Zengaw. ");
INSERT INTO zpi_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Nakdeto ne laa Dëdyuzh rundet kumplir xdiiz Dëdyuzh ne re Dëdyuzh lo men-Israel, sinke le we nak ne let yradet men-Israel nak merpee xpén Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Let yradet men ne zëëd xnëz Abraham nak merpee men ne zëëd xnëz Abraham, porke Dëdyuzh re lo Abraham: “Por Isaac nak ne ydaal men ne chiid xnëz de.” ");
INSERT INTO zpi_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Nee nak ne ryen ne let por ne nakdet mén men-Israel nak ne rak men zhiin Dëdyuzh, sinke men ne rlaleedx ne re Dëdyuzh zegne wlaleedx Abraham ne re Dëdyuzh lo Abraham, men guin nak ne nli nak zhiin Dëdyuzh. ");
INSERT INTO zpi_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Laa neree nga re Dëdyuzh lo Abraham, chene re Ne: “Stebizlnaa chiid noo, cheguin gap Sara te mëdbee.” ");
INSERT INTO zpi_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Let nozdet laa we nee, sinke mëdmzhoz ne wap Rebeca, Isaac xpenkwlal noo nak xuz ne, ");
INSERT INTO zpi_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","13","no axtegue antes ne gal ne, ne ni gardet ylaa ne ne wen ni ne mal, che re Dëdyuzh lo Rebeca: “Yrup mëëd gwa ne zuneey de, mëëd ne gal primer ylaa dxiin lo mëëd ne gal d