﻿USE sofia;
DROP TABLE IF EXISTS sofia.zpg_vpl;
CREATE TABLE zpg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zpg_vpl WRITE;
INSERT INTO zpg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Lo guetzy-rieꞌ ziaad le meññ-güyuꞌ yahc ba xtze ni nac meññ-xfamily Jesucrist ni ziaad de lo xfamily ṟeiy-Davit no Braṉ. ");
INSERT INTO zpg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Braṉ, leeme we xtad Isac, Isac xtad Jacop, Jacop xtad Judá no zrieñ meññ-behtzy Judá. ");
INSERT INTO zpg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá xtad chohp mpyquie-le Fares no Zar, no Tamar we xmam yâme. Fares xtad Esrom, Esrom xtad Aram. ");
INSERT INTO zpg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram xtad Aminadap, Aminadap xtad Nasóṉ, Nasóṉ xtad Salmóṉ. ");
INSERT INTO zpg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmóṉ no Rahab‑e xtad no xmam Boz, Boz no Ṟut‑e xtad no xmam Obet, Obet xtad Isaí. ");
INSERT INTO zpg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí xtad ṟeiy-Davit. Ṟeiy-Davit no ngüna-guhc tziahl Uríaz, leeyâme we xtad no xmam Salomóṉ. ");
INSERT INTO zpg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomóṉ xtad Ṟoboam, Ṟoboam xtad Abíaz, Abíaz xtad Asa. ");
INSERT INTO zpg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa xtad Josafat, Josafat xtad Joram, Joram xtad Uzíaz. ");
INSERT INTO zpg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíaz xtad Jotam, Jotam xtad Acaz, Acaz xtad Ezequíaz. ");
INSERT INTO zpg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíaz xtad Manaséz, Manaséz xtad Amóṉ, Amóṉ xtad Josíaz. ");
INSERT INTO zpg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíaz xtad Jeconíaz no zrieñ meññ-behtzy Jeconíaz, no leññ tiemp-wé günahzy meññ-Babilony meññ-Isṟael no güiyno yâme lee xguiedzy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","No Jeconíaz, leeme we xtad Salatiel ni guhl dze-ba nu meññ-Isṟael ciuda-Babilony; Salatiel xtad Zorobabel. ");
INSERT INTO zpg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel xtad Abiud, Abiud xtad Eliaquim, Eliaquim xtad Azor. ");
INSERT INTO zpg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor xtad Sadoc, Sadoc xtad Aquim, Aquim xtad Eliud. ");
INSERT INTO zpg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud xtad Eleazar, Eleazar xtad Matáṉ, Matáṉ xtad Jacop. ");
INSERT INTO zpg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacop xtad José tziahl Maríe; Maríe, wé guhc xmam Jesúz, ni ra yâme lee Crist. ");
INSERT INTO zpg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Gumm beeiy bygab family ni ziaad yahc de lo xfamily Braṉ to por to, güyuꞌ cators family glo dze-güyuꞌ Braṉ no xtâ dze-güyuꞌ Davit; no scators family glo dze-güyuꞌ Davit no xtâ tiemp-güiyno meññ-Babilony meññ-Isṟael xguiedzy yâme; no gyzac scators family glo tiemp-wé no xtâ dze-guhl Crist. ");
INSERT INTO zpg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mod-rieꞌ bidguiahl Jesucrist: Maríe, xmam me, ba nac diidz guidzña me no José. No antzy ni guidzña yâme, ba neññ guidtap Maríe to mdoo ni guiaad por Spirt-Sant. ");
INSERT INTO zpg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José naꞌ, mpyquie-tziaawy leeme, no hor-gunn me ba nu Maríe de xcuidad, nehx riuꞌladzy me ntzoo me ni nistuꞌ Maríe; leewe gucladzy me nsaꞌn me lee ngaꞌdzy gá lehdy ndruhty nehx ñann. ");
INSERT INTO zpg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ganii ziaꞌr leññ ihqy me ze, biahd to x‑ángel Dioz lo mpcaaḻ, ra leeme: ―José, lii ni ziaad de lo xfamily ṟeiy-Davit, di gynii leññ ihqyiꞌ gyrehzy; bidzña no Maríe, porni mdoo ni guidtap me, por Spirt-Sant‑e guiaad me. ");
INSERT INTO zpg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maríe guidtap me to mdoñooby, no cuy le me JESÚZ. Tzu le me ze, porni leeme guislaa me xmeññ me de lo xguîlquie. ");
INSERT INTO zpg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gyre nirieꞌ guhcu ze lehdy guhc ni ra Dioz profet, ru ne me: ");
INSERT INTO zpg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tzu to ndzabxtohby de xcuidad no guidtap me to mdoñooby, ni tzu le Emanuel, no Emanuel la, neu we: Dioz nu no nó. ");
INSERT INTO zpg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Hor-biuꞌlo José, ptzoo me mod-ra x‑ángel Dioz leeme, no bidzña me no Maríe. ");
INSERT INTO zpg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Per nehx cuaꞌ gahc saꞌ yâme xtâ glo ba guhl mdoo; no güluꞌ José le me JESÚZ. ");
INSERT INTO zpg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesúz guhl me Beléṉ, to guiedzy ni nu lo ṟegioṉ-Judea, tiemp-nac Herody ṟeiy. Lahd meññ ni nann lguia mbial byruu yâme ñaz-ru rlahñ ncübidz, bydzihñ yâme Jerusaléṉ, ");
INSERT INTO zpg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","no ganabdiidz yâme: ―¿Bá glo nu xṟeiy meññ-Isṟael ni ba guhl? Bwieꞌ noꞌ ximbial me ru rlahñ ncübidz, no leewe zid-zacbeeiy noꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hor-bieññ ṟeiy-Herody ze, di rdzial me bia ctzoo me, no zehgu gyre meññ-Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Were pshalcaꞌ ṟeiy-Herody gyre xjefy yahc bahl, no muextr ni ruuḻ yahc xleiy Moiséz lo meññ-guiedzy, no günabdiidz me lee bá glo gahl Crist. ");
INSERT INTO zpg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ra yâme leeme: ―Beléṉ ni nu lo ṟegioṉ-Judea; porni ze bzaa profetu lo guehtzy: ");
INSERT INTO zpg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","No lii, Beléṉ, ni nu lo ṟegioṉ-Judá, rsahquiꞌ lahd gyre guiedzy ni rtzoo mdad ni nu Judá; porni de lii gahl to mpyquie ni ctzoo mdad no ni güieꞌ dmeññaꞌ ni nac meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Were ngaꞌdzy gá pshalcaꞌ Herody meññ-wé yahc ni nann lguia mbial, no günabdiidz me lee buc, pue, bwieꞌ yâme mbial. ");
INSERT INTO zpg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Luxu pshahl Herody leeyâme Beléṉ, no ra leeyâme: ―Lâ tza, lâ dzigüieꞌ bá glo nu mdo-wé; no ru ba bydzial laꞌd leeme, guidne laꞌd naa, lehdy tzan dzigzacbeeiyaꞌ leeme zegahc. ");
INSERT INTO zpg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bylux bieññ yâme gyre ni ne ṟeiy-Herody, were za yâme. No mbial ni bwieꞌ yâme byruu, zau zunieru ru za yâme; no hor-bydzihñu ru nash mdoo, ba nehx güzeꞌru. ");
INSERT INTO zpg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hor-bwieꞌ yâme mbial, modni byxihly yâme. ");
INSERT INTO zpg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Hor-güyuꞌ yâme leññ yuꞌ we naꞌ, bwieꞌ yâme mdoo no xmam me, Maríe; no bisshiby gahc yâme, bzacbeeiy yâme mdoo; no pshal yâme ni ziyno yâme gady mdoo: or, no yahl no ceitnixye ni le mirra. ");
INSERT INTO zpg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","No byluxu, psieññ Dioz leeyâme lo mpcaaḻ di tedy yâme ru nu Herody. Leewe gubyguiat yâme xguiedzy yâme ba gydze ñahz. ");
INSERT INTO zpg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hor-ba zia yâme we naꞌ, güya to x‑ángel Dioz, ra me José lo mpcaaḻ: ―Biahsiꞌ, bigyno mdoo no xmam me Egipt, no tzuy uga xtâ naa diaa csieññ lii; porni Herody gyo me mdoo, ne me igaꞌdy me lee. ");
INSERT INTO zpg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Were biahs José, no guiaal gahc ziyno me mdoo no xmam, zia yâme Egipt. ");
INSERT INTO zpg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wé güyuꞌ yâme glo guhty Herody. Nirieꞌ guhcu ze lehdy guhc ni gu Señor profet, ru ne me: “Pqueen riedz dshiñaꞌ, byruu me Egipt.” ");
INSERT INTO zpg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hor-gunn Herody bisquiee meññ-nann lguia mbial leeme, bydziaꞌdzy me; pshahl me meññ ni biygaꞌdy gyre mbiux-ñooby ni rahp chohp ihz par lo yu ni nu yahc Beléṉ no zrieñ mbiux-nu yahc guingybi, mdid-ra meññ-nann yahc lguia mbial leeme. ");
INSERT INTO zpg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","No mod-wé guhcu, mod-bzaa profet-Jeremíaz: ");
INSERT INTO zpg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bieññ riedz leññ guiedzy-Ṟamá, de ni gayuun meññ no xroꞌ né; Ṟaqueḻ‑e ni gayuun por gyre xiiñ me, no ba di ne me guiandzie me, porni guhty gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Per bylux guhty Herody, to x‑ángel Dioz güya lo mpcaaḻ ru nu José Egipt, ra leeme: ");
INSERT INTO zpg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Biahsiꞌ, no gubyguiatno mdoo no xmam me ru le Isṟael, porni meññ-riñlo yahc ngaꞌdy mdoo, ba guhty. ");
INSERT INTO zpg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","No were biahs José no gubyguiatno me mdoo no xmam lo xṟegióṉ meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Per hor-gunn José biaꞌn Arquelao rtzoo mdad xilgar xtad me, Herody, lo ṟegioṉ-Judea, bydzie me ña meu; no psieññ Dioz leeme lo mpcaaḻ gybiꞌ me ñaz-lo ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Hor-bydzihñ yâme lo ṟegioṉ-rieꞌ, zia yâme to guiedzy ni le Nasaret. Guhcu ze lehdy guhc mod-günii profet yahc, tzu le Jesúz to meññ-Nasaret. ");
INSERT INTO zpg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tzcaḻ gahc, Juaṉ ni rchôbnihs meññ güyuꞌ me lo yu-bihdzy ni nu lo ṟegioṉ-Judea, guzlo galuu me meññ, ");
INSERT INTO zpg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","gaya me: ―Lâ csaan ni nahcsy ni nac laꞌd, porni ba zidgahsh dzé ni ctzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","De Juaṉ‑e ni bzaa profet-Isaíaz lo xguehtzy me, ru ne me: Rieññ gaquee to mpyquie riedz lo yu-bihdzy, ne: “Lâ guistziaawy ru tedy Señor; lâ cshal xguîlmbahñ laꞌd beeiy to ñaz-ndohp par dze-guiaad me.” ");
INSERT INTO zpg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","No nutz Juaṉ shab ni güyaa no xguihtz camell, no riuꞌ to cinturoṉ-guiedy leññ me; no rahgü me ncüshar no roo me dziñdoo ni nu guehsh. ");
INSERT INTO zpg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","No riahd meññ-nu Jerusaléṉ ridguieññ ni rnii me, no zehg riahd xtahl meññ-nu lo ṟegioṉ-le Judea no zrieñ guiedzy ni nu guingybi guiagü-Jordáṉ; ");
INSERT INTO zpg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","no gadee yâme diidz guîlquie ni ptzoo yâme, no pchôbnihs Juaṉ leeyâme lo guiagü-Jordáṉ. ");
INSERT INTO zpg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Hor-bwieꞌ Juaṉ ziaad xtahl meññ-nac yahc fariseu no meññ-nac yahc saduceu par gyrôbnihs, ra me leeyâme: ―¡Laꞌd meññ-dirquihñ ni zidguiahc beeiy mbaḻbeedzy! ¿Dxu ra laꞌd beeiy gylaa laꞌd de lo xguîlné Dioz ni ziaad? ");
INSERT INTO zpg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lâ ctzoo ni nac xñahzû lehdy guieññ ba psaan laꞌd ni nahcsy ni nac laꞌd, ");
INSERT INTO zpg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","no na di gynii leññ ihqy laꞌd, ga laꞌd: “Ba xmeññ Dioz‑e nó porni de lo xfamily Braṉ‑e nó”; porni naa gapyaꞌ laꞌd, Dioz zegahc‑e beeiy ntzoo me xfamily Braṉ xtâ guie ni dxie yahc neꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Zidguiahc meññ‑e beeiy to yag-cuannahsh; no guibyahg ba nashu puexd lehdy gyrug gyre yahg ni nehx mos xcuannahsh no yqueꞌ gueu. ");
INSERT INTO zpg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Naa ni uli we rchôbnisaꞌ laꞌd no nzeꞌ lehdy guieññ psaan laꞌd ni nahcsy ni nac laꞌd; per nu sto ni guiaad lux de ni biaḻaꞌ ni ma beeiyu lee que naa, ni nehx rsahcaꞌ ni xguidguial me niynonu. Beeiy to guîlrrôbnihs gdee me Spirt-Sant ni tzu leññ xguîlmbahñ laꞌd no ctzoo me guîlguxtisy no gue. ");
INSERT INTO zpg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Leeme zidtzoo mod-rtzoo meññ par rboo xguix trigü. Meññ-tziaawy gboo me lee diby lad beeiy rlesytziaawy meññ trigü leññ daꞌwy; no meññ-guîlquie glee me lee lo gue ni di ziuꞌ dzé ziee, beeiy rqueꞌ gue xguix trigü. ");
INSERT INTO zpg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesúz byruu me lo ṟegioṉ-Galilea, no güya me guiagü-Jordáṉ lehdy cchôbnihs Juaṉ leeme. ");
INSERT INTO zpg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Per nehx gucladzy Juaṉ nchôbnihs me Jesúz, no ra me lee: ―Lii we nchôbnihsiꞌ naa, dac‑e naa nchôbnisaꞌ lii, ¿no naꞌ zidyohbyiꞌ naa la? ");
INSERT INTO zpg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ra Jesúz leeme: ―Per naꞌ, gacu ze; porni rquihñu ctzoo nó gyre ni ne Dioz gac. No were pchôbnihs Juaṉ leeme. ");
INSERT INTO zpg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Byluxz byrôbnihs Jesúz, byruu me leññ nzeꞌ; no tohzy byxal gybaa, bwieꞌ me ziaht xiSpirt Dioz lguia me, beeiy to palom. ");
INSERT INTO zpg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","No bieññ to riedz ni byruu gybaa, ne: ―Nirieꞌ we dShiñaꞌ ni ndzin lee, no ni rxilynon lee. ");
INSERT INTO zpg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Luxu güiyno xiSpirt Dioz Jesúz lo yu-bihdzy ru nehx nu meññ, lehdy güieꞌ bêndzab bâḻ beeiy nquihly me Jesúz ntzoo mod-ne me. ");
INSERT INTO zpg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Güyuꞌ Jesúz uga cuarent dzé no cuarent guiaal no nehx güdahgü me mbehty, no byluxu bylahn me. ");
INSERT INTO zpg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","No biahd bêndzab lehdy güieꞌ bâḻ stzoo Jesúz mod-ga me lee. Ra me Jesúz: ―Bâḻ ulihbu Xiiñ Dioz lii, ptzoo mdad gac guie-rieꞌ yahc paṉ. ");
INSERT INTO zpg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ra Jesúz bêndzab: ―Lo Guehtzy ru queꞌ xtiidz Dioz neu: “Dac‑e nunzy no paṉ rbahñ meññ, zehg rbahñ meññ no gyre diidz ni rnii Dioz.” ");
INSERT INTO zpg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Luxu güiyno bêndzab Jesúz ciuda-Jerusaléṉ ni rahc cuent lee Dioz, no gülepy me lee ihqy idoró to ru ma guia, ");
INSERT INTO zpg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","no ra me Jesúz: ―Bâḻ ulihbu Xiiñ Dioz lii, güyubeꞌ lo yu; porni lo Guehtzy ru queꞌ xtiidz Dioz neu: Cshahl Dioz x‑ángel me ni gyla yahc lii. Glesy yâme lii lo ña yâme, lehdy di ctzuné guie nieꞌy. ");
INSERT INTO zpg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ra Jesúz leeme: ―Zegahc‑e lo Guehtzy ru queꞌ xtiidz Dioz neu: “Di gnabiꞌ behch lo Dioz ni rtzoo mdad lii nunzy par güieꞌy bâḻ ctzoo me ni neꞌy.” ");
INSERT INTO zpg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Gyzac güiyno bêndzab leeme ihqy to dahñ ni modni nsuu par bluu leeme nter guiedzylie ru rtzoo meññ mdad no gyre ni rsahc ni nu lou, ");
INSERT INTO zpg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","no ra me Jesúz: ―Naa gdedyaꞌ lii gyre nirieꞌ yahc bâḻ guisshibyiꞌ dloꞌn no gzacbeeiyiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ra Jesúz leeme: ―Byruu de neꞌ, bêndzab, porni lo Guehtzy ru queꞌ xtiidz Dioz neu: “Bzacbeeiy Dioz ni rtzoo mdad lii, no ptzoo nunzy ni ne me.” ");
INSERT INTO zpg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Byluxu, byrusytzu bêndzab de ru zu Jesúz; no biahd yahc x‑ángel Dioz bidguiacno yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Hor-bieññ Jesúz güluꞌ yâme Juaṉ lidzyguiib, za me lo ṟegioṉ-Galilea; ");
INSERT INTO zpg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","per nehx biaꞌn me Nasaret, mazyg zia me guiedzy ni le Capernaum, ni nu coo nisdoo, lo ṟegióṉ ni le Zabulóṉ no Neftalí. ");
INSERT INTO zpg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Guhcu ze lehdy guhc ni bzaa profet-Isaíaz: ");
INSERT INTO zpg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ṟegioṉ-Zabulóṉ no ṟegioṉ-Neftalí, ñaz-ru ria coo nisdoo, stiby chehsh guiagü-Jordáṉ, Galilea, ru nu meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Meññ-nu beeiy to lo guibcawy bwieꞌ to byni-ro, no meññ-nu beeiy lo ximble guîlguhty, güyuꞌ to byni-ro par lee. ");
INSERT INTO zpg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","No guzlo gahc Jesúz gaya me meññ: ―Lâ csaan ni nahcsy ni nac laꞌd, porni ba bydziñgahsh dze-ctzoo Dioz mdad neꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gadedy Jesúz coo nisdoo ni le Galilea, no bwieꞌ me chohp mpyquie; to me le Simóṉ ni zegahc ra yâme lee Pedr, no sto me le Ndréz, behtzy Simóṉ; galee yâme gueshmbaḻ lo nzeꞌ, porni meññ-rnahzy mbaḻ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","No ra Jesúz leeyâme: ―Lâ te náḻ laꞌd naa, no naa ctzon laꞌd meññ ni guidno zrieñ yahc ni gac dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","No psaꞌn gahc yâme xgueshmbaḻ yâme, no za yâme no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Güdedy Jesúz uga, bwieꞌ me schohp mpyquie ni nac yahc xiiñ Zebedeu; to me le Jacob, no behtzy me le Juaṉ. Nu yâme leññ barcü no xtad yâme; gaquieedy yâme gueshmbaḻ. Pquee Jesúz riedz leeyâme, ");
INSERT INTO zpg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","no luxu psaꞌn gahc yâme barcü no xtad yâme uga, no za yâme no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Güya Jesúz gyre guiedzy ni nu lo ṟegioṉ-Galilea, galuu me meññ xtiidz Dioz leññ xiydoo yâme cad guiedzy, no gayuno me meññ diidz de ni rtzoo Dioz mdad, no gasiaḻ me meññ-gayac-ure de gyre guîlguihdz no de gyre yoob ni rdedy meññ. ");
INSERT INTO zpg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Byzaꞌzy ru meññ diidz de Jesúz lo ṟegioṉ-Siry; no riyno yâme gyre meññ ni rahc gyrehzy, ni gayac-ure de gyre gyzasy guîlguihdz no yoob, no meññ ni nu mbenahcsy lee, no meññ-rnahzy mbeꞌ lee, no meññ-di raḻ gyniꞌby; psiaḻ me gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","No xtahl meññ-byruu lo ṟegioṉ-Galilea, no zegahc meññ-byruu lo ṟegioṉ-Decápolis, no meññ-Jerusaléṉ, no meññ-byruu lo ṟegioṉ-Judea, no meññ-nu stiby chehsh guiagü-Jordáṉ, náḻ yâme ru za Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Hor-bwieꞌ Jesúz ziaad xtahl meññ, güyehpy me chehsh to dahñ no gürie me. Gübigy xmeññ me ru dxie me, ");
INSERT INTO zpg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","no guzlo galuu me leeyâme, ra me: ");
INSERT INTO zpg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Dxu ñahc beeiy meññ ni nann nehx rsahc xguîlmbahñ bâḻ nehx nu yâme no Dioz, porni xchieñ yâme gyre ni rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Dxu ñahc beeiy meññ ni ruun, porni Dioz zacno leeyâme no gyre ni nadz ni rdedy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Dxu ñahc beeiy meññ ni ndoo xguîlriehñ, porni ziaad dzé ni gac guiedzylie xchieñ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Dxu ñahc beeiy meññ ni rxilyno ctzoo nunzy ni mos ni ne Dioz, porni Dioz gahc gacno ctzoo yâmeu. ");
INSERT INTO zpg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Dxu ñahc beeiy meññ ni rioob zâ-bynech, porni Dioz zioob leeyâme zegahc. ");
INSERT INTO zpg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Dxu ñahc beeiy meññ ni nye xguîlmbahñ, porni leeyâme zwieꞌ yâme Dioz. ");
INSERT INTO zpg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Dxu ñahc beeiy meññ ni nehx riuꞌladzy guîlrdeḻy, porni Dioz cu le yâme xiiñ gahcme. ");
INSERT INTO zpg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Dxu ñahc beeiy meññ ni rtzoo ni ne Dioz nîcze por leeu rgultihp meññ leeyâme, porni xchieñ yâme we ni rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Dxu ñahc beeiy laꞌd bâḻ por naa zdeḻy meññ laꞌd no ctzoo csahc meññ laꞌd o gynii yâme ni nehx uli contr laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lâ gyxihly, porni gybaa nu to xroꞌ ni mos ni gady laꞌd lee; porni zegahc‑e bgultihp yâme profet yahc ni güyuꞌ ba xtze, dze-dgueññ ziaꞌ nu laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Zidguiahc laꞌd‑e beeiy ziahd lo guiedzylie; per ziahd, bâḻ nnihty ni ndzihgu la, ¿báz‑e naꞌ nquihñu? Nehx nquihñu mbahty gahc, ba nunzy nzahbyu, no nzeꞌ meññu. ");
INSERT INTO zpg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Zidguiahc laꞌd‑e beeiy byniꞌ lo guiedzylie; to guiedzy-ro ni dxie ihqy to dahñ nehx beeiy ñungaꞌdzyu. ");
INSERT INTO zpg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ni nehx ñuꞌ gue to lampr no mbiahzu leññ to caj; mazyg ru guia we rbiahzu, were rguꞌu byniꞌ par gyre meññ-nu leññ yuꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","No zegahc‑e laꞌd, lâ gac beeiy byniꞌ lahd meññ, lehdy güieꞌ yâme ni mos ni rtzoo laꞌd, no cuguia yâme xTad laꞌd ni nu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Di gynii leññ ihqy laꞌd biaḻaꞌ par gnityaꞌ leiy ni bzaa Moiséz o par gnityaꞌ ni bluu profet yahc; nehx biaḻaꞌ par gnityaꞌ leeu, mazyg lehdy gyzaꞌ gyre ni neu. ");
INSERT INTO zpg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gapyaꞌ laꞌd ni uli, mientr nu gybaa no nu guiedzylie, leiy mbehty nehx beeiy gyruu lou, ni to letr ni to punt, xtâ gacr gyre ni nu de ni gac. ");
INSERT INTO zpg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","No leewe, dxu di ctzoo to lahd ni rtzoo Dioz mdad ctzoo meññ, nîcze ñahcu ni ma uxiee, o bâḻ ga yâme zrieñ meññ di ctzoo ni neu la, wé we ma uxiee qysahc ru rtzoo Dioz mdad. Per dxu ctzoo ni neu no zegahc gluu yâme meññ ctzoou la, wé we ma qysahc ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gapyaꞌ laꞌd, bâḻ di gac laꞌd ma meññ-tziaawy que muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, nehx ziuꞌ laꞌd ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ba bieññ laꞌd diidz ni cuaꞌ xmeññ laꞌd ni güyuꞌ ba xtze, neu: “Di igaꞌdyiꞌ, no dxu igaꞌdy la, gac guîlguxtisy chehsh me.” ");
INSERT INTO zpg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per naa gapyaꞌ laꞌd, dxu gydziadzyno zâ-bynech la, gac guîlguxtisy chehsh me. Dxu gynii didz-nahcsy lo zâ-bynech, meññ-nac yahc guxtisy güieꞌ xnahc ctzoo leeme; no dxu gyniwaty lo zâ-bynech, wé tza lo gue ni nu infiern. ");
INSERT INTO zpg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’No leewe, hor-nuy ruꞌ ru rzacbeeiy nó Dioz par gdeedyiꞌ gun, no guitsêlou lii rdziadzyno dxuhch zâ-bynechiꞌ lii, ");
INSERT INTO zpg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","psaꞌn gun ni ziynoy no güya, günino leeme lehdy csiaaḻladzy laꞌd ni rdziadzyno saꞌ laꞌd; no were beeiy guibyguiatiꞌ gdeedyiꞌ gun ni ziynoy. ");
INSERT INTO zpg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Bâḻ dxuhch ctzoo contr lii lo guxtisy la, byo xnahc tzuy dzie tziaawy no leeme antzy ni gydzihñ laꞌd ru dxie juez, lehdy were di cteedy me lii lo ña juez; porni bâḻ gydzihñ laꞌd lo juez la, juez steedy lii lo ña meññ-cu lii lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","No ni ulihbu gapyaꞌ lii, nehx zruuy uga xtâ quixriꞌ gyre ni ne juez. ");
INSERT INTO zpg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ba bieññ laꞌd ba xtze diaa guhc diidz: “Di senoy tziahl meññ.” ");
INSERT INTO zpg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per naa gapyaꞌ laꞌd ni uli, dxu güieꞌ to ngünaa no gyzîbyladzy me lee, ba gahc ptzoo me guîlquie leññ xguîlmbahñ me, beeiy ni ba güzeno me tziahl meññ. ");
INSERT INTO zpg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’No leewe, bâḻ to loꞌy rquihlyu lii ctzooy guîlquie la, güloo leeu, no psaabyu ziht de lii; beeiydí gynihty diby laꞌy ni nac xcuerpiꞌ, no ba dac tzaꞌy infiern nîcze nza gyre ni nac xcuerpiꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No bâḻ to ñay rquihlyu lii ctzooy guîlquie la, pchuꞌ leeu, no psaabyu ziht de lii; beeiydí gynihty diby laꞌy ni nac xcuerpiꞌ, no ba dac tzaꞌy infiern nîcze nza gyre ni nac xcuerpiꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Zegahc ba xtze diaa guhc diidz: “Bâḻ nitisy mpyquie riuꞌladzy csaꞌn tziahl, beeiy gzaa me to guehtzy ni gynii ba ptzily me guîltziahl, no gdee me guetzy-rieꞌ tziahl me.” ");
INSERT INTO zpg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per naa gapyaꞌ laꞌd, to mpyquie ni ctzily guîltziahl no xingünaa, no nehx güzeno ngüna-rieꞌ sto ni nehx tziahl me lee, por xtoḻ me ngüna-rieꞌ zahcu guîlquie par lee bâḻ guidzña no sto mpyquie; no dxu guidzña no to ngünaa ni gübily xguîltziahl, guîlquie gahc‑e zahcu par lee. ");
INSERT INTO zpg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’No ba bieññ laꞌd guhc diidz ni cuaꞌ meññ-güyuꞌ ba xtze, neu: “Na di cteedyiꞌ de ni ctzooy ni ba pcahbyladzyiꞌ no Dioz.” ");
INSERT INTO zpg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per naa gapyaꞌ laꞌd: Na di ycahbyladzy laꞌd de mbehty mód. Di ycahbyladzy laꞌd ni por gybaa, porni nacu ru dxie Dioz; ");
INSERT INTO zpg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni por guiedzylie, porni wé we ru rzu nieꞌ me; ni por Jerusaléṉ, porni leeu xciuda Ṟeiy-ro, lee we Dioz. ");
INSERT INTO zpg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni di ycahbyladzy laꞌd ni nehzy ihqy laꞌd, porni nehx beeiy ntzoo laꞌd ni to xguitz-ihqy laꞌd nquitzy o nyaꞌz. ");
INSERT INTO zpg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Per bâḻ ctzoo laꞌd behch la, lâ gynii “yo”; no bâḻ nehx stzoo laꞌdu, lâ gynii “yac”, porni zrieñ ni nnii laꞌd we ni risnii bêndzab meññ. ");
INSERT INTO zpg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ba bieññ laꞌd ba xtze guhc diidz: “Bâḻ dxuhch ctzuné byzalo sto meññ, mod-wé gahc‑e ctzuné yâme byzalo me; no bâḻ dxuhch ctzuné laiy sto meññ, mod-wé gahc‑e ctzuné yâme to laiy me.” ");
INSERT INTO zpg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per naa gapyaꞌ laꞌd: Di yquelo laꞌd meññ ni rtzoo ni nadz; bâḻ cap yâme lad-drech lo laꞌd, lâ gdee ñahz cap yâme sto ladu zegahc. ");
INSERT INTO zpg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bâḻ dxuhch ne teḻyno laꞌd lehdy ycaꞌ xigmix laꞌd, lâ gdee gydiby shab-xtziguia laꞌd, ycaꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bâḻ dxuhch ctzunñaad laꞌd guu laꞌd xyuu no tziyno laꞌdu to kilómetr, lâ tziyno leeu chohp kilómetr. ");
INSERT INTO zpg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dxu rnab behch lo laꞌd, lâ gdeedyu; no bâḻ dxuhch rnab guistiꞌñ laꞌd lee behch, di ga laꞌd leeyâme “yac”. ");
INSERT INTO zpg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’No zegahc bieññ laꞌd ba xtze guhc diidz: “Bintzi xmígüiꞌ, no gucnéladzy meññ-rdziadzyno lii.” ");
INSERT INTO zpg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per naa gapyaꞌ laꞌd: Lâ guîntzi meññ-rdziadzyno laꞌd, no lâ gnab lo Dioz cu xlaꞌy me meññ-rniwaty lo laꞌd; lâ gac meññ-tziaawy no meññ-néladzy laꞌd, no lâ gnab lo Dioz güieꞌ me meññ-rtzilytó laꞌd no meññ-rgultihp laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","No mod-wé zieññ ni uli laꞌd‑e xiiñ xTad laꞌd ni nu gybaa; porni leeme naꞌ rquee me xincübidz me par meññ-dirquihñ no par meññ-tziaawy, no rtzoo me guio par meññ ni rtzoo ni nac xñahzû no par meññ ni rtzoo ni nehx xñahzû. ");
INSERT INTO zpg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Porni bâḻ laꞌd ndzi laꞌd nunzy meññ ni ndzi laꞌd la, ¿biaz‑e naꞌ ziaad lou par laꞌd? Xtâ meññ-rcuquix mpuezd nac ze. ");
INSERT INTO zpg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","No bâḻ nunzy xirman laꞌd rnii laꞌd diux lee, ¿bia ni mos‑e naꞌ gatzoo laꞌd? Xtâ meññ-nehx rzaclo Dioz nac ze. ");
INSERT INTO zpg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Lâ ctzoo gyre cos xñahzu, beeiy gahc xTad laꞌd ni nu gybaa rtzoo xñahz gyre cos. ");
INSERT INTO zpg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’¡Gax lâ gann, na di gac laꞌd beeiy meññ-tziaawy porni riuꞌladzyt güieꞌ meññ ni mos ni gatzohd! No bâḻ ctzoo laꞌd ze la, xTad laꞌd ni nu gybaa mbehty nehx zdee me laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","No leewe, ru gacnoy meññ-nehx rahp ni tedydzé, di ctzunyetziꞌ lehdy güieꞌ meññ ni gatzooy, mod-rtzoo meññ-ne meññ-tziaawy lee nîcze nehx uliu; rtzoo yâme ze leññ idoo no lo call lehdy cuguia meññ leeyâme no ni rtzoo yâme. Gapyaꞌ laꞌd ni uli, no niwéhzy‑e ba güyuꞌ cuentu. ");
INSERT INTO zpg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Per lii, hor-gacnoy meññ-nehx rahp ni tedydzé, ptzoo leeu ngaꞌdzy gá lehdy di gann ndruhty. ");
INSERT INTO zpg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mod-wé ndruhty nehx zann bâḻ gacnoy; no xTadiꞌ ni rwieꞌ gyre ni rahc ngaꞌdzy, guiscady me lii to xroꞌ ni mos. ");
INSERT INTO zpg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Hor-gynino laꞌd Dioz, di ctzoo laꞌd beeiy rtzoo meññ-ne meññ-tziaawy lee nîcze nehx uliu; porni riuꞌladzy yâme suli yâme lóni ganino yâme Dioz leññ idoo no ru rdedy xtahl meññ leññ guiedzy, lehdy güieꞌ meññ ni rtzoo yâme. Gapyaꞌ laꞌd ni uli, no niwéhzy‑e ba güyuꞌ cuentu. ");
INSERT INTO zpg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Per lii, hor-gyninoy Dioz, güyuꞌ leññ xiryuꞌy no psaagü puert, no günino xTadiꞌ ru nehx zieññ ndruhty; no xTadiꞌ ni rwieꞌ gyre ni rahc ngaꞌdzy, guiscady me lii to xroꞌ ni mos. ");
INSERT INTO zpg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’No hor-gynino laꞌd Dioz, di gynii laꞌd ni nehx gaquihñ ni ba gahc günii laꞌd, beeiy rtzoo meññ-nehx rzaclo Dioz no ni ne bâḻ ma xtahl rnii yâme, ma guieññ Dioz leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Di ctzoo laꞌd mod-rtzoo gahc yâme; porni Dioz ni nac xTad laꞌd lee ba nann me bia gayaadz laꞌd antzy ni gnab laꞌdu. ");
INSERT INTO zpg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Hor-gynino laꞌd Dioz, mod-rieꞌ gynii laꞌd: DTad noꞌ, lii ni nu gybaa, tzuguia ley. ");
INSERT INTO zpg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gydzihñ de ni lii rtzooy mdad. Gac ni racladzyiꞌ neꞌ lo guiedzylie, mod-rahc gahcu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bdee ni tedydzé noꞌ dzêrieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Psiaaḻladzyiꞌ guîlquie ni nzahby noꞌ, mod-rsiaaḻdadzy noꞌ ni dirquihñ ni rtzoo meññ noꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","No bwieꞌ noꞌ lehdy di ctzoo noꞌ ni ne bêndzab, mazyg byla noꞌ de lo ni nadz. Porni lii we ni rtzoo mdad, no ni beeiyu lee gyreu, no ni tzuguia, tirgahc no gyre dzé ni ziaad. Modé gacu. ");
INSERT INTO zpg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Porni bâḻ rsiaaḻladzy laꞌd ni nadz ni rtzoo meññ laꞌd la, Dioz ni nac xTad laꞌd lee ni nu gybaa, zegahc rsiaaḻladzy me xguîlquie laꞌd; ");
INSERT INTO zpg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","per bâḻ di rsiaaḻladzy laꞌd ni nadz ni rtzoo meññ laꞌd la, zegahc‑e Dioz ni nac xTad laꞌd lee, nehx ssiaaḻladzy me guîlquie ni nzahby laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Hor-ctzoo laꞌd ayun, na di ctzutrixd lo laꞌd beeiy meññ-ne meññ-tziaawy lee nîcze nehx uliu; rtzutrixd lo yâme lehdy güieꞌ meññ gatzoo yâme ayun. Gapyaꞌ laꞌd ni uli, no niwéhzy‑e ba güyuꞌ cuentu. ");
INSERT INTO zpg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lii hor-ctzooy ayun, güluhñ ihqy zaꞌgndzi no güdihby loꞌy, ");
INSERT INTO zpg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","lehdy di gann meññ bâḻ gatzooy ayun, mazyg nunzy xTadiꞌ gannu, ni nu ru nehx rwieꞌ ndruhty; no xTadiꞌ ni rwieꞌ gyre ni rahc ngaꞌdzy, guiscady me lii to xroꞌ ni mos. ");
INSERT INTO zpg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Na di gyzîbyladzy laꞌd gac laꞌd ṟicü lo guiedzylie-rieꞌ, ru riuꞌ mblaa rahgü no rac-chieñ cos, no ru riuꞌ gübaan rban. ");
INSERT INTO zpg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma mos lâ cutziaawy ni ma rsahc xtâ gybaa, ru di zaḻ tzu mblaa gahgü leeu, no nehx zac-chieñu, no ru di zaḻ tzu gübaan cuan. ");
INSERT INTO zpg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Porni ru nu ni ma rsahc par laꞌd, wé gahc‑e tzu xguîlmbahñ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Byzalo meññ zidguiahcu beeiy to lampr par xcuerp yâme; no leewe, bâḻ beeiy rwieꞌy la, lo byniꞌ we nuy; ");
INSERT INTO zpg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","no bâḻ nehx rwieꞌy la, lo guibcawy we nuy. No bâḻ neꞌy nuy lo byniꞌ, luxu nehx uliu la, ¡to lo guibcawygüxihñ‑e nuy! ");
INSERT INTO zpg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ndruhty nehx beeiy stzoo dziiñ tohzy no chohp patróṉ; porni nehx beeiy nzobdiidz me no ñahp xpeeiy me gyrop yâme tohzy mdid. To me ñahc ni ne, no sto me ba yac. No mod-wé gahc‑e nehx beeiy gzobdiidz laꞌd Dioz no gyzîbyladzy laꞌd medy zegahc. ");
INSERT INTO zpg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’No leewe gapyaꞌ laꞌd: Na di cu ihqy laꞌd ni gahgü laꞌd o ni goo laꞌd par tedydzé laꞌd; ni di cu ihqy laꞌd lahr ni gutz laꞌd. ¿Dâs‑e ma rsahc xguîlmbahñ laꞌd que guîlroo la, no dâs‑e xcuerp laꞌd ma rsahcu que shab laꞌd la? ");
INSERT INTO zpg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lâ güieꞌ mayaañ ni rzîbydun lo mbeꞌ; nehx rtzoo maꞌ dziiñ ndziib maꞌ behch, ni nehx rtzoo maꞌ cüsech, ni nehx rgutziaawy maꞌ mbehty leññ daꞌwy; per xTad laꞌd ni nu gybaa rdee ni rahgü yâmaꞌ. ¡Dxiclé laꞌd, ma rsahc laꞌd‑e que mayaañ! ");
INSERT INTO zpg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","No ndruhty laꞌd nehx beeiy nniꞌzy stoozy, nîcze ma ñacladzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿No bia nacu rguꞌ ihqy laꞌd shab laꞌd? Lâ güieꞌ xnahc rgaꞌy guiee lo camp; nehx rtzoo yahcu dziiñ ni nehx rzaa yahcu duu; ");
INSERT INTO zpg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","per gapyaꞌ laꞌd, ni ṟeiy-Salomóṉ no gyre ni mos ni güdahp me, nehx biygahl me ñacmos shab me beeiy to lahd yahcu. ");
INSERT INTO zpg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bâḻ Dioz ristziaawy me guix, ni dzêrieꞌ nu lo camp no cshe yqueꞌ gue lee leññ horn, ¡dxiclé laꞌd, ma gdee Dioz ni yquihñ laꞌd‑e, nîcze uxiee rlíladzy laꞌd leeme! ");
INSERT INTO zpg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","No leewe, di cu ihqy laꞌd gnabdiidz laꞌd: “¿Bia gahgü nó?” o “¿bia goo nó?” o “¿biahx‑e gutz nó?” ");
INSERT INTO zpg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Porni meññ ni nehx rzaclo Dioz rguꞌ ihqy yâme gyre nirieꞌ; per xTad laꞌd ni nu gybaa nann me bia gyre rquihñ laꞌd gyre dzé. ");
INSERT INTO zpg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Per nier lâ yquee ihqy laꞌd tzu laꞌd ru rtzoo Dioz mdad no lâ ctzoo gyre cos ni ne me nac xñahzû, no were zdee me gyre ni gayaadz laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","No leewe, di cu ihqy laꞌd xnahc tedydzé laꞌd cshe, porni dze-cshe gyzac zidnou zrieñ ni cu ihqy laꞌd lee. To to dzé nirieꞌ niru zidnou. ");
INSERT INTO zpg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Na di glaꞌdzy laꞌd ni nac meññ, lehdy di gac laꞌd mod-wé gahc. ");
INSERT INTO zpg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porni Dioz stzoo me guîlguxtisy chehsh laꞌd de ni rlaꞌdzy laꞌd ni nac zrieñ; no mdid ni rquee gahc laꞌd zrieñ meññ, leegahcu we squee Dioz mdid laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Bia nacu rlaꞌdzyiꞌ ni nac sto, luxu ma nahcsy ni naquiꞌ que leeme? ");
INSERT INTO zpg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","No bâḻ lii ma nahcsy rtzooy que leeme, ¿bia mód‑e ñahbyiꞌ leeme: “Gacnon lii lehdy csaaniꞌ ni nahcsy ni naquiꞌ”? ");
INSERT INTO zpg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Lii ni ne meññ-tziaawy lee nîcze nehx uliu!, psaan gax gyre ni nahcsy ni naquiꞌ, no were beeiy gacnoy sto meññ csaan ni nahcsy ni nac. ");
INSERT INTO zpg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ni nda, di gdee laꞌdu mbahcü, nabduu nehx stzucas yâmaꞌ leeu aaḻ yquelo yâmaꞌ laꞌd; no di gráḻ laꞌd xni mos laꞌd lo ngutzy yahc, nabduu ssob gloꞌ yâmaꞌ leeu no znihtyu. ");
INSERT INTO zpg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Lâ gnab lo Dioz, no zdee me ni rnab laꞌd; lâ gyo, no zdzial laꞌd ni ryo laꞌd; lâ gynii chehsh puert, no sshalu. ");
INSERT INTO zpg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porni dxu rnab la, rcaꞌ; no dxu ryo la, rdzial ni ryo; no dxu rnii chehsh puert la, rxalu par tzu yâme. ");
INSERT INTO zpg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Dxu de to lahd laꞌd, bâḻ nnab xiiñ lee to paṉ, nehxni ndee laꞌd aaḻ guie leeme? ");
INSERT INTO zpg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O nnab me to mbaḻ laꞌd, ndee laꞌd leeme aaḻ to mbaaḻ la? ");
INSERT INTO zpg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bâḻ laꞌd rdee laꞌd ni mos rcaꞌ xiiñ laꞌd, nîcze meññ-dirquihñ laꞌd, ¡dxiclé Dioz ni nu gybaa ni nac xTad laꞌd lee, zdee me ni mos yahc dxu rnabu lo me! ");
INSERT INTO zpg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’No leewe, mod-racladzy laꞌd ctzoo meññ no laꞌd, mod-wé lâ ctzoo no leeyâme; porni nirieꞌ we rnii xleiy Moiséz, no mod-wé gahc rnii ni bzaa profet yahc. ");
INSERT INTO zpg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Lâ tzu ñaz-ruꞌ puert-mbia. Porni ruꞌ puert no ñahz ni rnidylo meññ la, xlahgu we, no xtahl meññ riuꞌu; ");
INSERT INTO zpg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","per ruꞌ puert no ñahz ni rdee guîlmbahñ meññ la, mbiau, no uxiee meññ‑e rdzial leeu. ");
INSERT INTO zpg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Gax lâ güieꞌ no meññ ni ne leegahc profet lee, luxu mbuxter leeyâme. Hor-ridyo yâme laꞌd, rluuw meññ-tziaawy leeyâme; de xtziguia ndoo yâme beeiy xiily, per leññ xguîlmbahñ yâme zidguiahc yâme beeiy lob ni nya. ");
INSERT INTO zpg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Beeiy ssaclo laꞌd leeyâme no ni nac yâme; porni nehx beeiy nruꞌ blatzy lo lbue-guiahtz, ni nehx beeiy nruꞌ duug lo yag-guiahtz. ");
INSERT INTO zpg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","No mod-wé, gyre yag-tziaawy rdee cuannahsh ni mos; no yag-nadz rdee cuannahsh ni nadz. ");
INSERT INTO zpg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yag-tziaawy nehx beeiy ndee cuannahsh ni nadz, ni yag-nadz nehx beeiy ndee cuannahsh ni mos. ");
INSERT INTO zpg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Gyre yahg ni nehx mos xqueꞌ, rrugu no riau lo gue. ");
INSERT INTO zpg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Meññ zidguiahc beeiy gahc yahg no xqueꞌu gyre mod-nac, no leewe, laꞌd ssaclohd meññ no ni nac yâme. ");
INSERT INTO zpg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Dac‑e gyre meññ ni ne, “Señor, lii ni rtzoo mdad”, tzu ru rtzoo Dioz mdad, mazyg dxu rtzoo ni ba ne dTadaꞌ ni nu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dze-caḻ xtahl meññ ga naa: “Señor, lii ni rtzoo mdad, günino noꞌ meññ gyre ni neꞌy gac, per gax günii noꞌ ley; no porni günii noꞌ ley la, byruu bêndzab meññ no ptzoo noꞌ xtahl milagür yahc.” ");
INSERT INTO zpg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Were ba gynin: “Nehx bzacloꞌn laꞌd; lâ gyruu de naa, meññ-dirquihñ‑e laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’No leewe, dxu rieññ no rtzoo ni ren, zidguiahc beeiy to meññ ni nann bia rtzoo no bzaa xiryuꞌ chehsh guie. ");
INSERT INTO zpg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Guhc guio, guczily gyre guiahgü, byxuu mbedun no güdihñu yu-wé, per nehx biahbu porni zobu chehsh guie. ");
INSERT INTO zpg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Per dxu rieññ no di rtzoo ni ren, zidguiahc beeiy to meññ-waty ni bzaa xiryuꞌ lo yux. ");
INSERT INTO zpg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Guhc guio, guczily gyre guiahgü, byxuu mbedun no güdihñu yu-wé, lé psiahbu lee, no bynitylo gyreu. ");
INSERT INTO zpg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Byluxz günii Jesúz ze, gyre meññ ni gayieññ ni ganii me, rtzunadz yâme mod-rluu me; ");
INSERT INTO zpg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","porni rluu me leeyâme beeiy to meññ-rtzoo mdad, no nehx rluu me beeiy rluu muextr ni ruuḻ yahc xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hor-biaht Jesúz chehsh dahñ, náḻ xtahl meññ leeme. ");
INSERT INTO zpg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hor-wé to mpyquie-gayudz gydo lady gübigy me Jesúz no bisshiby me lo, no ra me lee: ―Señor, lii ni rtzoo mdad, bâḻ racladzyiꞌ la, beeiy csiaḻiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Were pshob ña Jesúz chehsh me, no ra leeme: ―Naa racdadzyaꞌ csiaḻaꞌ lii. ¡Ba biaḻiꞌ we! Lux günii me ze, biaḻ gahc ni gayudz gydo lady mpyquie-caḻ. ");
INSERT INTO zpg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Byluxu, ra Jesúz leeme: ―Na di guyu lo ndruhty; mazyg güya lo bahl, no güiyno gun mod-bluu Moiséz meññ, lehdy gann yâme ba biaḻiꞌ de xguîlguihdziꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hor-bydzihñ Jesúz guiedzy-Capernaum, to capitáṉ ni byruu Ṟom bydziñgahsh leeme, no günab me gacno Jesúz leeme, ");
INSERT INTO zpg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","no ra me lee: ―Señor, lii ni rtzoo mdad, dmósaꞌ nashluꞌn ruꞌ yuꞌ, gayac-ure me, di raḻ gyniꞌby me mbehty no modni gayoob me. ");
INSERT INTO zpg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ra Jesúz leeme: ―Naꞌ tzan zicsiaḻaꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ra capitáṉ leeme: ―Lii ni rtzoo mdad, ndruhty nehx nacaꞌ par guiaadiꞌ xtâ diryuꞌn. Günihzy guiaḻ dmósaꞌ, no ba gahc biaḻ me we. ");
INSERT INTO zpg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Naa nannaꞌ xnahc rahc mdad, porni nu dxu rtzoo mdad naa, no zegahc nu soldad ni rtzon mdad leeyahc. Hor-gapyaꞌ to lahd yâme tza bahch, zia. No hor-gapyaꞌ sto lahd yâme guiaad, ba gahc ziaad. No hor-rshaalaꞌ dmósaꞌ dzictzoo me behch, rtzoo me leeu. ");
INSERT INTO zpg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hor-günii capitáṉ ze, ptzunadz Jesúz, no ra me meññ-náḻ leeme: ―Gapyaꞌ laꞌd ni uli, ni to lahd meññ-Isṟael nehx bydzialaꞌ meññ ni rlíladzy beeiy mpyquie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","No gapyaꞌ laꞌd, xtahl meññ gyruu ñaz-ru rlahñ ncübidz no ñaz-ru riaaz ncübidz par guiaad goo tohzy ruꞌ miax no Braṉ, Isac no Jacop leññ ru rtzoo Dioz mdad; ");
INSERT INTO zpg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","no meññ-nac diidz ñuꞌ ru rtzoo Dioz mdad, gyruu yâme tza yâme lo guibcawy stziuꞌ; uga guun yâme lé gahgü laiy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Luxu ra Jesúz capitáṉ: ―Naꞌ gübiꞌ xiryuꞌy, no gacu mod-neꞌy porni bylíladzyiꞌ. Hor-wé gahc biaḻ xmós capitáṉ. ");
INSERT INTO zpg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Güya Jesúz xiryuꞌ Pedr, no bwieꞌ me nash suegyr-ngünaa Pedr, xle lee. ");
INSERT INTO zpg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Were güdan Jesúz ña me, no biaḻ gahc xixle me; no biahs gahc me, bdee me ni güee Jesúz no xmeññ. ");
INSERT INTO zpg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hor-ba udziedoo, güiyno yâme xtahl meññ-nu mbenahcsy lee ru zu Jesúz; no tohzy günii Jesúz, byruu gahc gyre mbenahcsy leeyâme; no zegahc psiaḻ Jesúz gyre meññ-gayac-ure. ");
INSERT INTO zpg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nirieꞌ guhcu lehdy guhc mod-günii profet-Isaíaz, ru ne me: “Leeme bislaa me nó de gyre dguîlné nó, no ziyno me dguîlguihdz nó.” ");
INSERT INTO zpg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hor-bwieꞌ Jesúz bydzeꞌ meññ guingybi me, ra me xmeññ me: ―Tedy nó stiby chehsh nisdoo. ");
INSERT INTO zpg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Gübigy to muextr ni ruuḻ xleiy Moiséz, ra me Jesúz: ―Muextr, tzan no lii rutisy tzaꞌy. ");
INSERT INTO zpg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ra Jesúz leeme: ―Mbiaz rahp xcuev yahc maꞌ, no zegahc mashiily rahp xguehsh yahc maꞌ; per naa, Mpyquie-Pshahl Dioz Lee, nehx rapaꞌ ru rdzíen. ");
INSERT INTO zpg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sto lahd xmeññ me, ra leeme: ―Señor, lii ni rtzoo mdad, bdee ñahz nier tzan dziycatzyaꞌ dtadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ra Jesúz leeme: ―Náḻiꞌ naa naꞌ; psaꞌn meññ-nac yahc beeiy mînguty ycaꞌdzy yâme xmeññ yâme ni ba guhty. ");
INSERT INTO zpg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Güyuꞌ Jesúz leññ barcü no xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tohzy guzlo byxuu to mbedun-ro lo nisdoo, no lé ruhtz oḻ chehsh barcü. Per hor-wé nishcahsy Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Were güya xmeññ me bicsiuꞌ lo me, ra yâme leeme: ―¡Señor, byla noꞌ! ¡Nó ba gayaꞌb! ");
INSERT INTO zpg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ra me xmeññ me: ―¿Bia nacu zehdy rdzie laꞌd? ¿Nehx ziaꞌ rlíladzy laꞌd naa la? Byluxz günii me ze, biahs me, ptzoo me mdad güyudzie mbeꞌ no nisdoo; no gyreu güyuꞌ dzie. ");
INSERT INTO zpg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Gatzunadz yâme, ganabdiidz saꞌ yâme: ―¿Dxuz‑e leeme mpyquie-rieꞌ? ¡Xnahc‑e xtâ mbedun no nisdoo rzoob xtiidz me! ");
INSERT INTO zpg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hor-bydzihñ Jesúz stiby chehsh nisdoo, lo xilyu meññ-gadaren, byruu chohp mpyquie ni nu lahd baa, bydziñgahsh yâme ru ziaad Jesúz, no nu mbenahcsy leeyâme. Rquelo yâme meññ, no ndruhty nehx beeiy rdedy lo ñahz ru nu yâme. ");
INSERT INTO zpg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","No guzlo pquee yâme riedz: ―¿Bia racladzyiꞌ ctzooy no noꞌ, Jesúz, Xiiñ Dioz? ¿Ziaadiꞌ we lehdy ctzoo csahquiꞌ noꞌ, nîcze dgueññ ziaꞌ gydzihñ dze-nac diidz la? ");
INSERT INTO zpg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gahsh gá de uga nu xtahl ngutzy, gayahgü; ");
INSERT INTO zpg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","no günab mbenahcsy yahc lo Jesúz: ―Bâḻ gbooy noꞌ, bdee ñahz tzu noꞌ ngutzy-wé yahc. ");
INSERT INTO zpg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ra Jesúz mbenahcsy yahc: ―Lâ tza. Byruu gahcu mpyquie-wé yahc no bictzu yahcu ngutzy; no lo hor-wé gahc guzlo byxuunn yâmaꞌ, byrîbydahñ yâmaꞌ to ruꞌ zaꞌn lo nisdoo, no wé pycawy yâmaꞌ, guhty yâmaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Meññ-gayahp yahc ngutzy byxuunn yâme, no hor-bydzihñ yâme leññ guiedzy, bie yâme gyre ni güxahc no ni guhc meññ-güyuꞌ mbenahcsy lee. ");
INSERT INTO zpg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Byluxu, byruu gyre meññ-guiedzy-caḻ, za yâme ru zu Jesúz; no hor-bwieꞌ yâme leeme, günab yâme tza me zrieñ lad. ");
INSERT INTO zpg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Luxu güyuꞌ Jesúz leññ barcü, no güdedy me stiby chehsh nisdoo par bydzihñ me ru nac xguiedzy me. ");
INSERT INTO zpg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Uga bidno meññ to mpyquie-gayac-ure ni di raḻ gyniꞌby mbehty, nash me to lo camill; hor-bwieꞌ Jesúz ulihbu rlíladzy yâme, ra me mpyquie-gayac-ure: ―Byxihly naꞌ, shiꞌñ; xguîlquiey ba psiaaḻdadzyaꞌ gyreu we. ");
INSERT INTO zpg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Chohp tzonn de lahd muextr ni ruuḻ yahc xleiy Moiséz, ganii leññ ihqy yâme: “Mpyquie-rieꞌ rnii me didz-nahcsy contr Dioz.” ");
INSERT INTO zpg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Per Jesúz nann me bia ganii leññ ihqy muextr yahc. Were ra me leeyâme: ―¿Bia nacu nu guîlrieñ-nadz leññ ihqy laꞌd? ");
INSERT INTO zpg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Bia leeu ma nehx ngann, ñapyaꞌ: “Gyre xguîlquiey ba psiaaḻdadzyaꞌ”, o ñapyaꞌ: “Biahsiꞌ no güzeꞌ”? ");
INSERT INTO zpg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Naa, Mpyquie-Pshahl Dioz Lee, glun laꞌd beeiy rsiaaḻdadzyaꞌ xguîlquie meññ. Were ra me mpyquie-di raḻ gyniꞌby: ―Biahsiꞌ, gülesy xcamilliꞌ, no gübiꞌ xiryuꞌy. ");
INSERT INTO zpg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","No biahs mpyquie-wé, zia xiryuꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hor-bwieꞌ meññ nirieꞌ, ptzunadz yâme no güluguia yâme Dioz porni pshahl me meññ-beeiy ctzoo zâ niwé. ");
INSERT INTO zpg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Byruu Jesúz de uga za me sto lad, no bwieꞌ me to mpyquie ni le Mateu, dxie gacuquix mpuezd meññ. Were ra Jesúz leeme: ―Güde, náḻiꞌ naa. No biahs gahc Mateu, za me no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","No hor-nu Jesúz leññ yuꞌ gayahgü, bydzihñ xtahl meññ-rcuquix mpuezd no zegahc zrieñ meññ-rtzoo gyrehzy guîlquie, gürie yâme tohzy ruꞌ miax no Jesúz no xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hor-bwieꞌ meññ-nac yahc fariseu dxie Jesúz lahd meññ-rieꞌ yahc, günabdiidz yâme xmeññ me, ra yâme lee: ―¿Bia nacu rahgü xmuextr laꞌd tohzy no meññ-rcuquix mpuezd no zrieñ meññ-rtzoo gyrehzy guîlquie? ");
INSERT INTO zpg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hor-bieññ Jesúz nirieꞌ, ra me leeyâme: ―Meññ-nzaꞌg nehx rquihñ tza lo doctor, mazyg meññ-gayac-ure. ");
INSERT INTO zpg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lâ tza, no lâ gyzeedy ni ganii lo Guehtzy ru queꞌ xtiidz Dioz, ru neu: “Ni riuꞌdadzyaꞌ la, lâ guioob zâ-bynech laꞌd, no dac aaḻ yquee laꞌd gue ni gacnixye par to gun.” Nehx biaḻaꞌ zidyobyaꞌ meññ-tziaawy, mazyg meññ-guîlquie we zidyobyaꞌ, lehdy csaan yâme ni nahcsy ni nac yâme. ");
INSERT INTO zpg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","To dzé biahd xmeññ Juaṉ ni rchôbnihs, ra yâme Jesúz: ―¿Bia nacu noꞌ no meññ-nac yahc fariseu rtzoo noꞌ ayun, no xmeññiꞌ yac? ");
INSERT INTO zpg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ra Jesúz leeyâme: ―Ru nu meññ lo guîltziahl, ¿nehxni beeiy ñuꞌ yâme trixd no nu ziaꞌr ñoby-gayidzña lahd yâme? Per ziaad dzé ru naa ni zidguiahc beeiy to ñoby-guidzña, ba dgueññaꞌ lahd yâme, were ctzoo yâme ayun no nehx zoo zahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Ndruhty nehx nquieedy diby laꞌy lar-coby to lo lar-gush, porni lar-coby nguiixu lar-gush no ba ma ñacxroꞌ ru nyuhx. ");
INSERT INTO zpg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","No ndruhty nehx rguꞌ vin ni leer güyaa leññ to bush-guiedy ni ba nigush, porni bâḻ leeu ñahcu ze la, nchiahzu bush-guiedy ni ba nigush, no nnitylou vin no zegahcu bush. Leewe vin ni leer güyaa rahpu de ni tzuw leññ bush-guiedy ni ncoby, no were gyropu nehx zahc mbehty. ");
INSERT INTO zpg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mientr ganino Jesúz leeyâme, bydzihñ to mpyquie-nu idoo xcargü, bisshiby me lo Jesúz, no ra me lee: ―Dindzabdxuuraꞌ leer gá guhty; per bâḻ lii guiaadiꞌ no cshob ñay chehsh me la, zbahñ me gyzac‑e. ");
INSERT INTO zpg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Were biahs Jesúz, byruu me za me no xmeññ me, ziyno mpyquie-caḻ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tohzydzi bydzihñ to ngünaa, ba rahp tzipychop ihz gayac-ure me de guidzngünaa, gübigy me ñaz-chehsh Jesúz lahd meññ no güdan me nieꞌ shab; ");
INSERT INTO zpg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","porni ganii leññ ihqy me, ne me: “Bâḻ canzaꞌ shabz me, ziaḻaꞌ we.” ");
INSERT INTO zpg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesúz naꞌ, bidzguiat lo me, bwieꞌ me ngüna-wé, no ra me lee: ―Ba di cu ihqyiꞌ, shiꞌñ; porni rlíladzyiꞌ naa, leewe ba biaḻiꞌ. No lohg hor-wé, biaḻ gahc ngüna-caḻ. ");
INSERT INTO zpg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hor-bydzihñ Jesúz xiryuꞌ mpyquie-nu idoo xcargü, bwieꞌ me ba nu musycü ni gacuadz bdzia, no gayuun meññ-xtahl lé rquee yâme riedz, ");
INSERT INTO zpg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ra me leeyâme: ―Lâ gyruu; dac‑e guhty ndzabwiñ, nishcahsy me we. Meññ-caḻ yahc naꞌ, aaḻ byxidzyno yâme Jesúz hor-günii me ze; ");
INSERT INTO zpg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","were güloo Jesúz leeyâme stziuꞌ, no güyuꞌ me no günahzy me ña ndzabdxuur, no biahs gahc me gübahñ me. ");
INSERT INTO zpg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","No gydo lo ṟegióṉ ru nu yâme, gunn meññu. ");
INSERT INTO zpg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hor-byruu Jesúz de uga, náḻ chohp meññ-ngaḻ leeme, gaquee riedz: ―¡Lii ni ziaad de lo xfamily ṟeiy-Davit, bioob noꞌ! ");
INSERT INTO zpg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hor-güyuꞌ Jesúz leññ yuꞌ, bydzihñ meññ-caḻ ru dxie me, were günabdiidz me leeyâme, ra me: ―¿Rlíladzy laꞌd beeiy csiaḻaꞌ lo laꞌd la? Ra yâme leeme: ―Rlídadzy noꞌ, Señor. ");
INSERT INTO zpg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Were güdan Jesúz lo yâme, no ra leeyâme: ―Gacu mod-rlíladzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","No byxal gahc lo yâme, no bwieꞌ gahc yâme. Ra Jesúz leeyâme: ―Gax lâ gann, na di gu laꞌdu lo ndruhty dxu psiaḻ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per byruhzy yâme de uga, no gydo lo ṟegióṉ bie yâme diidz lo meññ ni ptzoo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bylux byruu meññ-caḻ yahc ru dxie Jesúz, bydziñno zrieñ meññ to ngop ni nu mbenahcsy lee. ");
INSERT INTO zpg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Scâsy güloo Jesúz mbenahcsy, ngop guzlo gahc günii me. Rtzunadz meññ ni bwieꞌ yahc ni guhc, no ne yâme: ―Nito dgueññ güieꞌ meññ zâ nirieꞌ gydo ru nu meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per meññ-nac yahc fariseu ne yâme: ―Mpyquie-rieꞌ beeiy rboo me mbenahcsy meññ, porni bêndzab gahc‑e ni rtzoo mdad gyre mbenahcsy, racno leeme. ");
INSERT INTO zpg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Za Jesúz gyre ciuda no zrieñ guiedzy, galuu me meññ leññ idoo gyre lad. Gayuno me meññ xtiidz Dioz no de ni rtzoo Dioz mdad, no gasiaḻ me meññ-gayac-ure de gyre guîlguihdz. ");
INSERT INTO zpg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hor-bwieꞌ me meññ, bioob me leeyâme, porni nehx nann yâme bia ctzoo yâme no porni zidguiahc yâme beeiy xiily ni nehx rahp dxu güieꞌ lee. ");
INSERT INTO zpg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Luxu ra me xmeññ me: ―Gapyaꞌ laꞌd ni uli, xtahl dziiñ‑e nu, porni xtahl meññ gabiahz guieññ xtiidz Dioz, per meññ-gatzoo xtziiñ Dioz la, uxiee yâme. ");
INSERT INTO zpg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","No leewe, lâ gnab lo Dioz ni nac xbixwaan dziiñ, lehdy cshahl me meññ-tziyno xtiidz me byzaꞌzy. ");
INSERT INTO zpg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pquee Jesúz riedz gydiby tzipychop xmeññ me, no ptzoo me lee meññ ni beeiy ctzoo mdad gyruu mbenahcsy meññ no ni beeiy csiaḻ meññ-gayac-ure de gyre lo guîlguihdz. ");
INSERT INTO zpg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nirieꞌ we le gydiby tzipychop xmeññ me ni güyu-le apóstl yahc: nier gahc, Simóṉ ni zegahc ra yâme lee Pedr, no behtzy me Ndréz; Jacob no behtzy me Juaṉ, gyrop yâme we xiiñ Zebedeu; ");
INSERT INTO zpg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipy no Bartolomé; Tomáz no Mateu ni rcuquix mpuezd; Jacob xiiñ Alfeu; no Lebeu ni ra yâme lee zegahc Tadeu; ");
INSERT INTO zpg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simóṉ ni güyuꞌ lahd to cuib meññ ni le cananist, no Jud-Iscariot ni byluxu bdee Jesúz lo ña meññ-rdziadzyno leeme. ");
INSERT INTO zpg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesúz pshahl me gydiby tzipychop meññ-rieꞌ yahc, no ra me: ―Di tza laꞌd lo ṟegióṉ ru nu meññ-nehx meññ-Isṟael, no di tzu laꞌd ni to xguiedzy meññ-Samary; ");
INSERT INTO zpg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","mazyg lâ tza ru nu meññ-Isṟael ni zidguiahc beeiy xiily ni bynihty. ");
INSERT INTO zpg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lâ tza, no lâ ga leeyâme: “Ba bydziñgahsh dze-rtzoo Dioz mdad.” ");
INSERT INTO zpg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lâ csiaḻ meññ-gayac-ure, lâ guispahñ mînguty, lâ csiaḻ xguîlguihdz meññ-gayudz gydo lady, no lâ ctzoo mdad gyruu mbenahcsy ni nu meññ. Sca-ze cuaꞌ laꞌd ni rdedyaꞌ zehzy, zegahc zehzy lâ ctzoo gyre nirieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Na di tziyno laꞌd medy-or, ni medy-plat, ni medy-cobr, ");
INSERT INTO zpg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni bush par lo ñahz. Na di tziyno laꞌd chohp shab laꞌd, ni sto pár guidguial, ni yagca; porni meññ-rtzoo dziiñ, xñahzu we gdee meññ xguîlroo yâme. ");
INSERT INTO zpg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ru gydzihñ laꞌd to ciuda o zegahc to guiedzy-yaañ, lâ gyo xiryuꞌ meññ ni rahp xpeeiy, no wé lâ tzu xtâ glo gyruu laꞌd de uga. ");
INSERT INTO zpg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Hor-tzu laꞌd ruꞌ yuꞌ, lâ gynii diux meññ-nu yu-wé. ");
INSERT INTO zpg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","No bâḻ meññ-tziaawy leeyâme, ziuꞌ laꞌy ru nu yâme; no bâḻ nehx meññ-tziaawy leeyâme, nehx ziuꞌ laꞌyu, mazyg ziuꞌ laꞌy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","No bâḻ di gdee yâme ñahz gydzihñ laꞌd, o di guieññ yâme laꞌd la, lâ gyruu de yu-wé o de guiedzy-wé, no lâ cuihby yudé nieꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gapyaꞌ laꞌd ni uli, dze-gac xguîlnadz Dioz, ma xroꞌ guîlné gabiahz meññ ni nu guiedzy-wé que meññ-Sodom no meññ-Gomorr. ");
INSERT INTO zpg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Lâ güieꞌ! Naa gashaalaꞌ laꞌd lahd meññ-guiedzylie beeiy riuꞌ xiily lahd lob; lâ gap laꞌd gahc zaꞌgndzi beeiy mbaaḻ, per lâ gacndoo scâsy beeiy ximbue. ");
INSERT INTO zpg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gax lâ gann, porni steedy meññ laꞌd lo ña guxtisy, no zguihñ yâme laꞌd leññ xiydoo yâme; ");
INSERT INTO zpg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","no tziyno yâme laꞌd lo gobernador no lo ṟeiy porni nac laꞌd dmeññaꞌ; mod-rieꞌ beeiy guno laꞌd dtiidzaꞌ leeyâme no zegahc meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Per hor-tziyno yâme laꞌd, di cu ihqy laꞌd bia gynii laꞌd lo guxtisy; porni lo gahc hor-wé, zdzial laꞌd ni gynii laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","No dac‑e laꞌd gynii, mazyg xiSpirt xTad laꞌd ni nu gybaa, wé we guisnii laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’No behtzy gahc meññ zdee behtzy lehdy gaty, no zegahcu zdee xtad meññ xiiñ; no xiiñ meññ zdee xtad yâme no xmam yâme lehdy gaty. ");
INSERT INTO zpg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Gyre meññ zdziadzyno laꞌd porni nac laꞌd dmeññaꞌ; per dxu rtibladzy glo gydibylgaa gyreu, wé zlaa de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hor-igultihp yâme laꞌd to guiedzy, lâ tza sto guiedzy; no gapyaꞌ laꞌd ni uli, antzy ni tza laꞌd gyre guiedzy ru nu meññ-Isṟael, naa, Mpyquie-Pshahl Dioz Lee, guibyguiataꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ndruhty meññ-gazeedy ziaꞌ nehx ma ñann que xmuextr, no ndruhty mós nehx ma nsahc que xpatróṉ. ");
INSERT INTO zpg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Meññ-rzeedy gyxilyno me dze-ba nann me beeiy gahc nann xmuextr me, no to mós gyxilyno me dze-ba rsahc me beeiy gahc xpatróṉ me. Bâḻ xtad meññ-nu to leññ yuꞌ ra yâme lee Bêndzab la, ¡lé dxi de xiiñ mpyquie-rieꞌ! ");
INSERT INTO zpg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’No leewe, di gydzie laꞌd ndruhty. Porni nehx ziaꞌn mbehty ngaꞌdzy no di gyxal lou; no nehx ziaꞌn mbehty ni nungaꞌdzy, gyreu zieññ. ");
INSERT INTO zpg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ni ren laꞌd lo guibcawy, lâ gynii leeu lo byniꞌ; no ni ren laꞌd ngadzydoo, lâ gynii leeu ihqy ndzi yuꞌ lehdy gann gyre meññu. ");
INSERT INTO zpg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","No di gydzie laꞌd meññ-rgaꞌdy cuerp, porni nehx beeiy ngaꞌdy yâme alm; mazyg lâ gydzie dxu beeiy gnidylo cuerp tohzy no alm lo infiern. ");
INSERT INTO zpg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’No gumm nann laꞌd, chohp mayaañ rdoꞌ maꞌ por to mbí medyguib-yaañ. Per nehx ñahb yâmaꞌ lo yu, ni to maꞌ, bâḻ Dioz di gdee ñahz. ");
INSERT INTO zpg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","No laꞌd, xtâ xguitz-ihqy laꞌd‑e nann me blacu. ");
INSERT INTO zpg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","No leewe, di gydzie laꞌd; ma rsahc laꞌd‑e que xtahl mayaañ. ");
INSERT INTO zpg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Dxu gynii dmeññaꞌ lee ñaz-lo zrieñ meññ la, zegahc‑e gynin ñaz-lo dTadaꞌ ni nu gybaa dmeññaꞌ leeyâme; ");
INSERT INTO zpg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","per dxu ga zrieñ meññ nehx dmeññaꞌ lee la, naa zegahc‑e gapyaꞌ dTadaꞌ ni nu gybaa dac‑e dmeññaꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Dac‑e nlâdzy laꞌd biaḻaꞌ cuaqydzien meññ-nu lo guiedzylie; nehx biaḻaꞌ lehdy gacu ze, mazyg biaḻaꞌ lehdy gac meññ chohp cuib. ");
INSERT INTO zpg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Naa biaḻaꞌ lehdy teḻyno meññ-mpyquie xtad gahc, no meññ-ngünaa teḻyno xmam, no xiñ-ulihdzy meññ teḻyno suegyr-ngünaa; ");
INSERT INTO zpg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","xfamily gahc meññ gydziadzyno saꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’No dxu leeme ndzi xtad no xmam mazy que naa la, nehx rquihñ me par ñahc me dmeññaꞌ; o dxu leeme ndzi xiñ-ñooby o xiñ-ndzaꞌb mazy que naa la, zehg nehx rquihñ me par ñahc me dmeññaꞌ; ");
INSERT INTO zpg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","no dxu racladzy gac dmeññaꞌ lee no di ne gbooladzy xtâ xguîlmbahñ, nehx rquihñ me par ñahc me dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dxu gacladzy guislaa xguîlmbahñ leegahc la, zniꞌdyu; per dxu gniꞌdy xguîlmbahñ por naa la, wé zdzial guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Dxu rcaꞌ xtiidz laꞌd, rcaꞌ yâme dtiidzaꞌ zegahc; no dxu rcaꞌ dtiidzaꞌ la, rcaꞌ xtiidz Dioz ni pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dxu rcaꞌ xtiidz to profet ni pshahl Dioz lee, zegahc zady me ni ycaꞌ gahc profet; no dxu rcaꞌ xtiidz to meññ-tziaawy ni rzoob xtiidz Dioz, zegahc zady me ni ycaꞌ gahc meññ-tziaawy. ");
INSERT INTO zpg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","No dxu gdee nîcze to vas nzeꞌ ni ngaaḻ goo dxuhch de lahd dmeññaꞌ ni ma lwiñ, nunzy porni dmeññaꞌ lee la, gapyaꞌ laꞌd ni uli, nehx znihty ni guiscady Dioz leeme. ");
INSERT INTO zpg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bylux ra Jesúz meññ ni nac tzipychop xmeññ me xnahc ctzoo, za me zrieñ guiedzy de lo ṟegioṉ-wé, zigluu me meññ no zigyuno me lee xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Per Juaṉ ni rchôbnihs, nyagü me lidzyguiib, bieññ me ni gatzoo Crist. Were pshahl me chohp xmeññ me ");
INSERT INTO zpg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","zignabdiidz yâme lee, ra yâme lee: ―¿Ulihbu lii ni nac diidz guiaad ni ne Dioz cshahl me lee la, o cuiaaz noꞌ zrieñ? ");
INSERT INTO zpg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Were ra Jesúz leeyâme: ―Lâ tza, no lâ gu diidz lo Juaṉ gyre ni gawieꞌ laꞌd no ni gayieññ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Lâ ga leeme meññ-ngaḻ ba rwieꞌ, meññ-ndang ba rzeꞌ, meññ-gayudz lady riaḻ de xguîlguihdz, meññ-nguat ba rieññ, mînguty rbahñ, no meññ-pobr ba gayieññ xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","No dxu ñahc beeiy meññ ni nehx riatrxan de ni rlíladzy naa. ");
INSERT INTO zpg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lóni zia meññ-pshahl Juaṉ lee, guzlo Jesúz gaya me meññ de ni rtzoo Juaṉ: ―Hor-güya laꞌd lo yu-bihdzy ru ziaad Juaṉ, ¿bia bigüieꞌ laꞌd? ¿To ni zidguiahc beeiy gobgui ni rchaḻ mbeꞌ lee la? ");
INSERT INTO zpg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O bâḻ yac, ¿bia bigüieꞌ laꞌd? ¿To mpyquie ni ruhtz lar-rsahc la? Zoꞌn yacu, porni nann laꞌd, meññ-ruhtz lar-rsahc, li ṟeiy‑e riuꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Were ¿bia bigüieꞌ laꞌd? ¿To profet la? Ze we leeu, no gapyaꞌ laꞌd, mazy que to profet‑e mpyquie ni bigüieꞌ laꞌd lee. ");
INSERT INTO zpg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","De Juaṉ‑e ganii lo Guehtzy ru queꞌ xtiidz Dioz, ni ne: Naa cshaalaꞌ to dmeññaꞌ ni sunier loꞌy, tziyno me dtiidzaꞌ lo meññ; leeme guistziaawy me ru tedyiꞌ scâsy ractziaawy to ñahz. ");
INSERT INTO zpg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Gapyaꞌ laꞌd ni uli, lahd gyre meññ, ndruhty nehx niygahl beeiy Juaṉ ni rchôbnihs; per ni ma lwiñ ru rtzoo Dioz mdad, wé ma qysahc que Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Glohdy dze-biahd Juaṉ ni pchôbnihs meññ no glo hôrrieꞌ, nu meññ ni garuu yahc contr ni ne Dioz ni nu gybaa, no gayo yâme xnahc gyniꞌdy yâme ni rtzoo me mdad. ");
INSERT INTO zpg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Antzy ni guiaad Juaṉ, günii profet yahc no xleiy Moiséz ni nu yahc par gac. ");
INSERT INTO zpg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","No bâḻ ne laꞌd gylíladzy laꞌd nirieꞌ la, Juaṉ, leeme we profet-Elíaz ni nac diidz guiaad. ");
INSERT INTO zpg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bâḻ racladzy laꞌd gann laꞌd bia ganin la, lâ yquee ihqy laꞌd dtiidzaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Dxu nsacaꞌ meññ-nu ni naꞌ? Rluu yâme beeiy mbiux ni rbia rguichiñ lóguiaꞌ no rquee yâme riedz zrieñ zâ-mbiux yâme, ne yâme: ");
INSERT INTO zpg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Pcuadz noꞌ bdzia, per di nyeꞌ laꞌd; biiḻy noꞌ cancioṉ-trixd, per di ñuun laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Porni biahd Juaṉ, nehx rahgü me sca ni rahgü laꞌd, ni nehx roo me sca ni roo laꞌd, no ne laꞌd bêndzab we nu leeme. ");
INSERT INTO zpg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","No zegahc rwieꞌ laꞌd naa, Mpyquie-Pshahl Dioz Lee, rahguaꞌ no roon. Wé ba rnii laꞌd, ne laꞌd to meññ-la no meññ-roo nistzuuñ‑e naa. No ne laꞌd zegahc, naa we xmígü nyug meññ-rcuquix mpuezd no zrieñ meññ-nehx rlaby ni ne leiy. Ze ne laꞌd, per xguîlnann Dioz rdee diidz por ni mos ni rtzoo xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Luxu guzlo ganii Jesúz mod-gashacladzy me no meññ-nu yahc guiedzy ru ba güya me no ru ma xtahl milagür ptzoo me, porni nehx psaan yâme ni nahcsy ni nac yâme, ra me: ");
INSERT INTO zpg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Baazy dzii de meññ-nu yahc guiedzy-Corasíṉ, no meññ-nu yahc guiedzy-Betsaida! Bâḻ meññ-Tiro no meññ-Sidóṉ nwieꞌ yâme gyre milagür ni ptzon leññ xguiedzy laꞌd la, ba xtze naꞌ psaan yâme ni nahcsy ni nac yâme, ñuhtz yâme lar-nahtz no ndziib yâme dé ihqy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Per gapyaꞌ laꞌd, dze-gac xguîlnadz Dioz ma xroꞌ guîlné we ni gabiahz laꞌd que ni gabiahz meññ-Tiro no meññ-Sidóṉ. ");
INSERT INTO zpg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","No laꞌd, meññ-nu guiedzy-Capernaum, ne laꞌd guiahs laꞌd, gybiꞌ laꞌd gybaa, per to ru nadz‑e tza laꞌd. Porni bâḻ gyre milagür yahc ni guhc ru nu laꞌd ñahcu guiedzy-Sodom la, ñuꞌ guiedzy-wé we xtâ ni naꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Per gapyaꞌ laꞌd, dze-gac xguîlnadz Dioz, ma xroꞌ guîlné we ni gabiahz laꞌd que meññ-güyuꞌ guiedzy-Sodom. ");
INSERT INTO zpg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","No byluxu ne Jesúz: ―Rguguian lii, Dad, lii ni rtzoo mdad gybaa no guiedzylie, porni gülungaꞌdzyiꞌ gyre nirieꞌ lehdy di ñieññ meññ-nann no meññ-nniꞌ ihqy leeu, no bluuyu meññ-zidguiahc beeiy mbiux. ");
INSERT INTO zpg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ze ptzooyu, Dad, porni ze biuꞌladzyiꞌ gacu. ");
INSERT INTO zpg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Gyre ni nu, ba bdee dTadaꞌ leeu lo dñan. Ndruhty nehx rzaclo naa mod-rzaclo dTadaꞌ naa, no ndruhty nehx rzaclo dTadaꞌ mod-rzacloꞌn leeme; no dxu racdadzyaꞌ gzaclo dTadaꞌ, zacnon lee. ");
INSERT INTO zpg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Lâ te ru nun, gyre laꞌd ni ba bydzahg de gyre ni rtzoo laꞌd no de ni nuu laꞌd beeiy to yu-naꞌy, no naa gdedyaꞌ ru guisladzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lâ gzobdiidz naa, scâsy mod-yuhz ni riyno to yug rtzoo maꞌ gyre ni ne xbixwaan maꞌ, no zegahc lâ gyzeedy ni rlun; porni rtzon mdad no guîlndoo no nehx rniguian; no tzu leññ xguîlmbahñ laꞌd mos. ");
INSERT INTO zpg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Porni ni ren ctzohd zidguiahcu beeiy to yug ni nehx ngann par tziynot, no nsehzy ni zidguiahc beeiy yuu ni rdedyaꞌ dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lo gahc tiemp-wé to dze-risladzy meññ, güdedy Jesúz leññ to lyu ru dziib trigü; galahn xmeññ me, no guzlo gachuꞌ yâme xdo trigü no gayahgü yâme ladzyu. ");
INSERT INTO zpg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Niwé bwieꞌ meññ-nac yahc fariseu, ra yâme Jesúz: ―Bwieꞌ, gatzoo xmeññiꞌ ni nehx xñahzû gac dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ra Jesúz leeyâme: ―¿Dgueññ guuḻ laꞌd ni ptzoo Davit tzcaḻ la, dze-bylahn me no gahc meññ-zidno me? ");
INSERT INTO zpg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Güyuꞌ me leññ xiydoo Dioz, no güdahgü me paṉ ni guhc gun par Dioz, nîcze nehx xñahzu par Davit ni par meññ-zidno me, porni ne xleiy Moiséz nehx beeiy rahgü nyugz meññ leeu, mazyg nunzy bahl. ");
INSERT INTO zpg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O dgueññ guuḻ laꞌd lo xleiy Moiséz ru ne me, bahl rtzoo yâme dziiñ leññ idoró dze-risladzy meññ, no nehx rahcu guîlquie par leeyâme la? ");
INSERT INTO zpg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gapyaꞌ laꞌd, naa ni ma rsahc que idoró zuun neꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","No bâḻ laꞌd ñieññ laꞌd ni ganii lo Guehtzy ru queꞌ xtiidz Dioz, ru neu: “Ni riuꞌdadzyaꞌ la, lâ guioob zâ-bynech laꞌd, no dac aaḻ yquee laꞌd gue ni gacnixye par to gun”, were nehx nruu laꞌd contr meññ-nehx nu mbehty chehsh. ");
INSERT INTO zpg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Naa we Mpyquie-Pshahl Dioz Lee no rtzon mdad bia beeiy gac dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Byruu Jesúz de wé, güyuꞌ me leññ xiydoo yâme uga. ");
INSERT INTO zpg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nuty to mpyquie uga, gübihdzy to ña me; gumm gayo yâme mod-gyruu yâme contr Jesúz la, günabdiidz yâme, ra yâme leeme: ―¿Xñahzu we bâḻ dxuhch nsiaḻ meññ-gayac-ure dze-risladzy meññ la? ");
INSERT INTO zpg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ra Jesúz leeyâme: ―Dxu de lahd laꞌd, bâḻ rahp to xiily no ñahb maꞌ leññ to guieryu dze-risladzy meññ, ¿dâs‑e nigloo laꞌd leemaꞌ scâsy ñahb maꞌ la? ");
INSERT INTO zpg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","No, ¡ma rsahc to meññ‑e que to xiily! No leewe, xñahzu ctzoo meññ ni mos dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Luxu ra Jesúz mpyquie-caḻ ni gübihdzy ña: ―Biscaa ñay. No biscaa me leeu, no biaḻ gahcu beeiy gahc sto ladu. ");
INSERT INTO zpg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Byluxu byruu meññ-nac yahc fariseu idoo, no guzlo gayo yâme xnahc beeiy igaꞌdy yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Hor-gunn Jesúz nirieꞌ, byruu me de uga; no náḻ xtahl meññ leeme, no gasiaḻ me gyre meññ-gayac-ure yahc, ");
INSERT INTO zpg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","no ra me meññ-rieꞌ yahc di ga yâme ndruhty dxu we leeme. ");
INSERT INTO zpg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mod-wé we guhc ni günii profet-Isaíaz ba xtze, ru ne me: ");
INSERT INTO zpg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nirieꞌ we ni ctzoo dixtziñaꞌ, ni güleꞌn lee, ni ndzin lee, no rxilynon lee. Gdedyaꞌ diSpirtaꞌ ni tzu no leeme, no csieññ me xtâ meññ-nehx meññ-Isṟael ziaad dzé ni ctzon guîlguxtisy. ");
INSERT INTO zpg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nehx zdeḻydiidz me no meññ, ni nehx squee me riedz, ndruhty nehx zieññ xriedz me lo call. ");
INSERT INTO zpg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nehx stzuné me meññ ni ntihdy beeiy to gobgui, no gacno me meññ ni rluu beeiy to mech ni ba nunzy guhsh gaboo, glo dze-güieꞌ me ba gayahc xguîlguxtisy me byzaꞌzy. ");
INSERT INTO zpg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","No byzaꞌzy lo guiedzylie zbiahz meññ guislaa me leeyâme de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","To mpyquie ni ngaḻ no ngop ni nu mbenahcsy lee, güiyno yâme leeme lo Jesúz; no psiaḻ Jesúz leeme, no guzlo gahc gawieꞌ me no ganii me. ");
INSERT INTO zpg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Rtzunadz gyre meññ, no ne yâme: ―¿Dac‑e leeme ni nac diidz guiaad de lo xfamily ṟeiy-Davit la? ");
INSERT INTO zpg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Hor-bieññ meññ-nac yahc fariseu ni ganii meññ, ne yâme: ―Beelzebú, ni nac xjefy gyre mbenahcsy, racno leeme; leewe rboo me mbenahcsy meññ. ");
INSERT INTO zpg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesúz naꞌ nann me bia ganii leññ ihqy cad to meññ-wé yahc, ra me leeyâme: ―Bâḻ meññ-nac yahc xguxtisy to guiedzy nruu chohp cuib no ndeḻy yâme la, nnitylo de ni rtzoo yâme mdad‑e. No bâḻ to ciuda o to family nruu chohp cuib no ndeḻy yâme la, nnidylo saꞌ yâme we. ");
INSERT INTO zpg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","No bâḻ bêndzab mboo me leegahcme, were ba garuu me chehsh gahcme; ¿bia mód‑e naꞌ beeiy ñahc ni nnii me? ");
INSERT INTO zpg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ne laꞌd rboon mbenahcsy porni racno Beelzebú naa; no bâḻ ze leeu la, ¿dxu racno xmeññ laꞌd lehdy gboo yâmeu zegahc? No leewe, leegahc yâme rdee diidz nehx xñahzu ni rnii laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Per naa rboon mbenahcsy porni nu xiSpirt Dioz no naa, no niwé we rdee diidz ba gatzoo Dioz mdad neꞌ ru nu laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Bia mód‑e ñuꞌ dxuhch leññ xiryuꞌ to mpyquie-ndip no ncaꞌ gyre ni rahp me, bâḻ di glihby leeme nier? No mod-wé were beeiy ncaꞌ gyre ni rahp me. ");
INSERT INTO zpg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Dxu nehx nu no naa, garuu contr naa; no dxu nehx racno naa lehdy gac xtahl dmeññaꞌ la, gaboxtzu me meññ ni ba biahd. ");
INSERT INTO zpg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’No leewe gapyaꞌ laꞌd: Dioz csiaaḻladzy me gyre xguîlquie meññ no nitisy didz-nahcsy ni rnii yâme contr leeme; per dxu gynii didz-nahcsy contr xiSpirt Dioz la, wé nehx ssiaaḻladzy Dioz xguîlquie. ");
INSERT INTO zpg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dxu gynii contr naa, Mpyquie-Pshahl Dioz Lee la, Dioz csiaaḻladzy xguîlquie me; per dxu gynii contr Spirt-Sant la, wé nehx ssiaaḻladzy Dioz xguîlquie ni tiemp-rieꞌ ni tiemp-ziaad ziaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Bâḻ to yahg yag-tziaawy leeu la, mos xqueꞌu; per bâḻ nehx yag-tziaawy leeu la, were nehx mos xqueꞌu. Cad to yahg rzaclo meññ leeu por xqueꞌu. ");
INSERT INTO zpg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Laꞌd meññ-dirquihñ ni zidguiahc beeiy mbaḻbeedzy! ¿Bia mód‑e nnii laꞌd ni mos, no meññ-dirquihñ laꞌd? Porni ni rnii meññ, wé we rdee diidz bia nu leññ xguîlmbahñ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Meññ-tziaawy la, rtzoo no rnii ni mos, porni ni mos nu leññ xguîlmbahñ yâme. No meññ-dirquihñ la, wé rtzoo no rnii ni dirquihñ, porni ni dirquihñ nu leññ xguîlmbahñ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Per naa gapyaꞌ laꞌd, dze-gac xguîlnadz Dioz, gyre didz-nadz ni günii meññ lee, gac guîlguxtisy lguiau. ");
INSERT INTO zpg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Xtiidz gahquiꞌ gynii ni naquiꞌ, no gluu yahcu bâḻ nehx nu mbehty chehshiꞌ o bâḻ rahpiꞌ doḻ. ");
INSERT INTO zpg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Lahd meññ-nac yahc fariseu no zrieñ muextr ni ruuḻ yahc xleiy Moiséz, ra yâme Jesúz: ―Muextr, riuꞌdadzy noꞌ nwieꞌ noꞌ ntzooy to ni ngann ni nunzy Dioz beeiy rtzoo. ");
INSERT INTO zpg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ra Jesúz leeyâme: ―Meññ-di rzobdiidz ni nu ni naꞌ, ni pur ni nadz nu leññ ihqy, rnab nwieꞌ to ni ngann ni nunzy Dioz beeiy rtzoo; per ni ngann ni guhc no profet-Jonáz, niwéhzy‑e güieꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Porni mod-güyuꞌ Jonáz tzonn dzé no tzonn guiaal leññ to mbaḻ ni modni xroꞌ, mod-wé gahc‑e naa, Mpyquie-Pshahl Dioz Lee, ziun leññ yu tzonn dzé no tzonn guiaal. ");
INSERT INTO zpg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Meññ-Nínive, dze-gac xguîlnadz Dioz ziahs yâme, no mod-wé zieññ nu guîlquie chehsh meññ-nu ni naꞌ; porni meññ-Nínive byo yâme Dioz hor-bieññ yâme xtiidz me ni bieno Jonáz leeyâme. Per naa ni ma rsahc que Jonáz zuun neꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","No dze-gac xguîlnadz Dioz, ziahs ṟein ni güyuꞌ ñaz-mbenihs no mod-wé zieññ nu guîlquie chehsh meññ-nu ni naꞌ; porni leeme, nîcze ziht güyuꞌ me, per biahd me ru nu Salomóṉ, bidguieññ me xguîlnann. Per naa ni ma rsahc que Salomóṉ zuun neꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Hor-ba byruu mbenahcsy to meññ, ba zau, ganzeꞌu zrieñ lad, gayohbyu ru guisladzyu, no mbahty di rdzialu lgar. ");
INSERT INTO zpg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Were ba neu: “Guibyguiataꞌ ru byruu gahcaꞌ.” Hor-ba gubyguiatu we naꞌ, rwieꞌu xguîlmbahñ meññ-wé beeiy to yuꞌ ni ndahtzy, no nyar no guctziaawy leññ. ");
INSERT INTO zpg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Were rigyohbyu zgahdzy mbenahcsy ni ma udedy que leeu, no hor-ba ptohp saꞌu, ribyguiat yahcu, riuꞌu meññ-wé sto; no ba ma udedy meññ-dirquihñ rahc meññ ni ba byrohp riuꞌ mbenahcsy lee. Mod-wé gahc‑e gac gyre meññ-dirquihñ ni nu ni naꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ganii ziaꞌ Jesúz ze no meññ-nuno me leeyahc, tohzy bydzihñ xmam me no meññ-behtzy me. Biaꞌn yâme stziuꞌ gahc, no racladzy yâme gynino yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Were byruu to lahd gahc meññ, ra leeme: ―Xmamiꞌ no meññ-behtzyiꞌ zu stziuꞌ racladzy gynino lii. ");
INSERT INTO zpg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Per ra me meññ-ra leeme ze: ―¿Dxu we leeme dmamaꞌ, no dxu we leeyâme meññ-dbetzyaꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Luxu, bluu ña me xmeññ me, no ra me: ―Meññ-rieꞌ yahc‑e dmamaꞌ no meññ-dbetzy yahcaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porni nitisy dxu rtzoo mod-racladzy dTadaꞌ ni nu gybaa, wé we dbetzyaꞌ, wé we dsanaꞌ, no wé we dmamaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dze-wé gahc byruu Jesúz ruꞌ yuꞌ, güya me coo nisdo-Galilea no gürie me uga. ");
INSERT INTO zpg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bydohp xtahl meññ leeme; were güyehpy me leññ to barcü, no gürie me, no gyre meññ biaꞌn coo nisdoo. ");
INSERT INTO zpg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","No xtahl ni galuu me meññ-caḻ yahc, ndaagü lo diidz rnii me, ne me: ―Güyuꞌ to mpyquie, güya me lo xilyu me bicchaꞌdz me ladzy trigü lehdy gylahñu. ");
INSERT INTO zpg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Lóni gachaꞌdz me leeu we naꞌ, doozyu biahb coo ñahz; no biahd mayaañ güdahgü yâmaꞌ leeu. ");
INSERT INTO zpg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Stoozyu biahb lahd guie, ru nehx nu xtahl yu; no ngueeḻy gülahñ yahcu, porni uxiee yu rahpu. ");
INSERT INTO zpg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Per hor-byruu ncübidz bdzuu leeyahcu; no gumm nehx ziaꞌ ba günahzyu lo yu zaꞌgndzi la, gübihdzyu. ");
INSERT INTO zpg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Stoozyu biahb ru rlahñ guix-guiahtz; no bygaꞌy guix-guiahtz, no di ndee lgar nniꞌzyu. ");
INSERT INTO zpg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Per stoozyu biahb lo yu-tziaawy ru beeiy cueꞌu mos; nu lahdu cueꞌ diby gayuu gá ladzyu cad to lo xan, no zrieñu cueꞌ sesent, no zrieñu cueꞌ treint. ");
INSERT INTO zpg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bâḻ racladzy laꞌd gann laꞌd bia ganin la, lâ yquee ihqy laꞌd dtiidzaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Luxu xmeññ Jesúz gübigy yâme leeme, no ra yâme leeme: ―¿Bia nacu ndaagü lo diidz rninoy meññ gyre nirieꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ra Jesúz leeyâme: ―Laꞌd, bdee Dioz lsenzy gann laꞌd ni nungaꞌdzy de ni rtzoo me mdad; per leeyâme la, yac. ");
INSERT INTO zpg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Porni dxu beeiy rieññ dtiidzaꞌ la, scaꞌ me dguîlriehñaꞌ mazy, no zahp me xtahl; no dxu di rieññ dtiidzaꞌ, xtâ doozy guîlriehñ ni rahp me zruuw leeme. ");
INSERT INTO zpg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","No leewe rninon leeyâme ndaagü lo diidz: porni rwieꞌ yâme, per rluu yâme beeiy ni di rwieꞌ; rieññ yâme, per nehx nann yâme bia leeu, rluu yâme beeiy ni di rieññ. ");
INSERT INTO zpg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","No lguia ni nac yâme, leeu we ni ba günii profet-Isaíaz, ru ne me: Laꞌd zieññ laꞌd dtiidzaꞌ, per nehx zann laꞌd bia leeu ni bieññ laꞌd; no nîcze zwieꞌ laꞌd xroꞌ cos ni rtzon, per nehx zann laꞌd bia leeu ni bwieꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porni xguîlmbahñ meññ-rieꞌ yahc gucnahdyu, no nehx rieññ yâme xñahz cos, no rluu ndaagü lo yâme; lehdy di güieꞌ yâme, ni di guieññ yâme, ni di gann yâme zaꞌgndzi, ni di gyo yâme naa par nistziawyaꞌ xguîlmbahñ yâme, no nsiaḻaꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Per dxu ñahc beeiy laꞌd, porni nann laꞌd bia rwieꞌ laꞌd no nann laꞌd bia leeu rieññ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Porni gapyaꞌ laꞌd ni uli, güyuꞌ xtahl profet no xtahl meññ-tziaawy ni gucladzy nwieꞌ ni gawieꞌ laꞌd, per di nwieꞌ yâmeu; no gucladzy yâme ñieññ yâme ni gayieññ laꞌd, per di ñieññ yâmeu. ");
INSERT INTO zpg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Lâ guieññ bia rnii ni günin ndaagü lo diidz lguia mpyquie-bicchaꞌdz ladzy trigü lehdy gylahñu: ");
INSERT INTO zpg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Meññ ni rieññ xtiidz Dioz no mod-rtzoo me mdad, no nehx nann yâme bia neu la, riahd bêndzab rboo leeu leññ xguîlmbahñ yâme. Ze we zidguiahc yâme beeiy ladzy ni biahb coo ñahz. ");
INSERT INTO zpg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","No ni biahb lahd guie zidguiahc beeiy meññ ni rcaꞌ gahc xtiidz Dioz hor-rieññ yâmeu no rxilyno yâmeu, ");
INSERT INTO zpg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","per gumm zidguiahc yâme beeiy plant ni nehx günahzy lo yu zaꞌgndzi la, doozy dzé rtibladzy yâme; no hor-riahd xtahl ni nadz ni rdedy yâme, o rgultihp zrieñ meññ leeyâme por xtiidz Dioz, ba gahc rxiññladzy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ni biahb lahd guix-guiahtz zidguiahc beeiy meññ ni rieññ xtiidz Dioz, per rguꞌ ihqy yâme ni nu lo guiedzylie-rieꞌ, no risquiee guîlṟicü leeyâme, no gyre niwé rcau dziiñ ni ntzoo xtiidz Dioz leññ xguîlmbahñ yâme, no rahc yâme beeiy plant ni nehx rqueꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Per ni biahb lo yu-tziaawy naꞌ, wé zidguiahc beeiy meññ ni rieññ xtiidz Dioz zaꞌgndzi. Zidguiahc yâme beeiy plant yahc ni cueꞌ diby gayuu gá ladzyu to lo xan, no zrieñu cueꞌ sesent, no zrieñu cueꞌ treint. ");
INSERT INTO zpg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nirieꞌ we sto ni ra Jesúz leeyâme ndaagü lo diidz: ―Mod-rtzoo Dioz ni nu gybaa mdad, ze we zidguiahcu beeiy to mpyquie ni bicchaꞌdz ladzy pur trigü-mos lo xilyu me lehdy gylahñu; ");
INSERT INTO zpg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","per hor-gyre yâme nishcahsy, güyuꞌ to meññ-rdziadzyno xbixwaan lyu, pchaꞌdz me ladzy guix-nahcsy lahd trigü, no luxu za me. ");
INSERT INTO zpg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hor-bygaꞌy trigü no byruu xdou, bidguieññ guix-nahcsy lahdu zegahc. ");
INSERT INTO zpg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Were ra mós yahc xbixwaan lyu: “Señor, lii bdziibiꞌ pur ladzy ni mos lo lyu. ¿Bá we, pue, byruu ladzy guix-nahcsy ni nu lahdu?” ");
INSERT INTO zpg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Xbixwaan lyu ra leeyâme: “Meññ-rdziadzyno naa we ptzoou.” Were ra mós yahc leeme: “¿Racladzyiꞌ dziglahdz noꞌ guix-nahcsy la?” ");
INSERT INTO zpg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ra me: “Yac, porni bâḻ glahdz laꞌd guix-nahcsy la, duhn zlahdz laꞌd trigü zegahc. ");
INSERT INTO zpg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Beeiydí, zî-gagaꞌyu tohzy no trigü; dze-ba diaa gydohp trigü, were gapyaꞌ meññ-ctzoo dziiñ ctohp yâme nier guix-nahcsy no glihby yâmeu, yqueꞌ gue leeu; no luxu cutziaawy yâme trigü.” ");
INSERT INTO zpg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sto ni ra Jesúz leeyâme ndaagü lo diidz: ―Mod-rtzoo Dioz ni nu gybaa mdad, ze we zidguiahcu beeiy to ladzy mostas ni bdziib to mpyquie lo xilyu. ");
INSERT INTO zpg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","No leeu we ni ma nwiñ ladzy de gyre ladzy yahc ni rdziib meññ; per ru ba byniꞌzyu, rahcu ma xroꞌ que zrieñ ni rbib lo lyu, no rahcu beeiy to yagmble-ro, xtâ no riahd ma-rzîbydun yahc, rid-zaa xguehsh maꞌ lo xṟamu. ");
INSERT INTO zpg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Zegahc günii me ndaagü lo diidz mod-rieꞌ: ―Mod-rtzoo Dioz ni nu gybaa mdad, ze we zidguiahcu beeiy levadur ni bguhtz to ngünaa lee no tzonn cuib rin, lehdy guiahs cob-paṉ. ");
INSERT INTO zpg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Gyre nirieꞌ ra Jesúz meññ pur ndaagü lo diidz, no mbehty nehx ra me leeyâme bâḻ di ñahcu pur ndaagü lo diidz. ");
INSERT INTO zpg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Guhcu ze lehdy guhc mod-bzaa profet, ru ne me: Gynin pur ndaagü lo diidz; gynin ni nungaꞌdzy glo diaa dze-bzaa Dioz guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Byluxu, byruu Jesúz ru zu meññ-xtahl, no güyuꞌ me leññ yuꞌ; were gübigy xmeññ me leeme, no ra leeme: ―Gu noꞌ bia rnii ni güniiy ndaagü lo diidz lguia guix-nahcsy ni nu lo lyu. ");
INSERT INTO zpg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ra Jesúz leeyâme: ―Ni pchaꞌdz pur ladzy ni mos lehdy gylahñu, wé we naa, Mpyquie-Pshahl Dioz Lee; ");
INSERT INTO zpg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","no guiedzylie we rahc cuent lo lyu. Ladzy ni mos, wé we rahc cuent xmeññ Dioz; guix-nahcsy, wé we meññ ni rtzoo ni dirquihñ; ");
INSERT INTO zpg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","no meññ ni rdziadzyno xbixwaan lyu no ni pchaꞌdz ladzy guix-nahcsy, leeme we bêndzab. Dze-gydohp xdo trigü ni gyruu, wé we rahc cuent dze-gynihty guiedzylie, no meññ-ptohp do ni bdee trigü, wé we ángel yahc. ");
INSERT INTO zpg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","No sca-ze rdohp guix-nahcsy par yqueꞌ gue leeu, zegahc‑e gac dze-gydzihñ ni gynihty guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Naa, Mpyquie-Pshahl Dioz Lee, cshaalaꞌ d‑ángelaꞌ gyre ru rtzon mdad, ctohp yâme gyre meññ-rquihly zrieñ meññ ctzoo guîlquie, no gahc meññ-rtzoo ni dirquihñ, ");
INSERT INTO zpg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","lehdy cu yâme lee leññ horn ru gadahl gue; uga guun yâme lé gahgü laiy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Luxu, meññ ni ctzoo ni ne Dioz, ycampytzeꞌ yâme beeiy ncübidz leññ ru rtzoo xTad yâme mdad. Bâḻ racladzy laꞌd gann laꞌd bia ganin la, lâ guieññ zaꞌgndzi. ");
INSERT INTO zpg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Mod-rtzoo Dioz ni nu gybaa mdad, ze we zidguiahcu beeiy ru nungaꞌdzy behch ni rsahc leññ yu. To mpyquie bydzial leeu, no pcaꞌdzy meu uga gahc sto; no modni rxihly me, güya me bictoꞌ me gyre ni rahp me, no bicshii me lyu-wé. ");
INSERT INTO zpg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’No zegahc mod-rtzoo Dioz ni nu gybaa mdad, ze we zidguiahcu beeiy to meññ-rzii no rtoꞌ, gayo me guie-rzaagy ni le perla ni ma rsahc yahc par sii me; ");
INSERT INTO zpg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","no hor-ba bydzial me to ni bueññ guia sahcu, were ptoꞌ me gyre ni rahp me, no güxii me leeu. ");
INSERT INTO zpg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’No zegahc mod-rtzoo Dioz ni nu gybaa mdad, zidguiahcu beeiy to gueshmbaḻ, no ru gráḻ yâmeu lo nisdoo, gynahzyu nyug gyre clasy mbaḻ. ");
INSERT INTO zpg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","No hor-ba bydzeꞌ xgueshmbaḻ yâme porni günahzy yâme xtahl mbaḻ, were ba gyruu yâme coo nisdoo no rbia yâme, rbe yâme mbaḻ-mos, rguꞌ yâme lee leññ dzomby; no mbaḻ-nadz, ba rsaaby yâme lee. ");
INSERT INTO zpg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ze we gac dze-gynihty guiedzylie; gboo ángel meññ-dirquihñ lahd meññ-tziaawy, ");
INSERT INTO zpg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","no cu yâme meññ-dirquihñ leññ horn ru nu gue; uga guun yâme lé gahgü laiy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Luxu günabdiidz Jesúz leeyâme: ―¿Rieññ laꞌd gyre nirieꞌ la? Ra yâme leeme: ―Rieññ noꞌ, Señor. ");
INSERT INTO zpg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ra Jesúz leeyâme: ―Hor-to muextr ni ruuḻ xleiy Moiséz rzeedy me par gann me mod-rtzoo Dioz ni nu gybaa mdad, rahc yâme beeiy xbixwaan to yuꞌ ni gülutziaawy xtahl cos, no hortisy riuꞌladzy me, rboo me nicoby ni gülutziaawy me no zegahcu ni rahp me ba xtze. ");
INSERT INTO zpg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Byluxz günii Jesúz gyre nirieꞌ yahc pur ndaagü lo diidz, byruu me uga. ");
INSERT INTO zpg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bydzihñ me ru nac xguiedzy me, no guzlo galuu me meññ leññ xiydoo yâme, rtzunadz meññ, no ne yâme: ―¿Báhx‑e byzeedy mpyquie-rieꞌ ni nann me? ¿Bia mód‑e rtzoo me milagür-rieꞌ yahc? ");
INSERT INTO zpg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Dâs‑e leeme xiiñ carpinter la? No, ¿dâs‑e xmam me Maríe, no behtzy me Jacob, José, Simóṉ no Jud la? ");
INSERT INTO zpg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Dâs‑e neꞌ zegahc nu gyre meññ-byzan me no nó la? ¿Bia mód‑e nann me gyre nirieꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","No nehx bylaby yâme ni rnii Jesúz lé bydziadzyno yâme leeme. Per ra Jesúz leeyâme: ―To profet rzacbeeiy meññ lee gyre ru ria, per leññ gahc xguiedzy me ba yac, ni leññ xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","No wé nehx ptzoo me xtahl milagür, porni di nlíladzy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lo tiemp-wé Herody, ni nac gobernador lo ṟegioṉ-Galilea, bieññ me diidz lguia Jesúz, ");
INSERT INTO zpg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","no ra me xmós me: ―Mpyquie-wé, Juaṉ ni rchôbnihs‑e leeme; gübahñ me de lahd mînguty gyzac, no leewe beeiyu leeme rtzoo me gyre nirieꞌ yahc ni ngann. ");
INSERT INTO zpg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Günii Herody ze porni leeme ptzoo mdad bygaꞌ Juaṉ, blihby yâme lee caden, no güluꞌ yâme lee lidzyguiib. Ptzoo Herody ze por xtoḻ Herodíaz ni nac tziahl Felipy; Felipy naꞌ, behtzy gahcme we Herody, ");
INSERT INTO zpg_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","no Juaṉ ra me Herody: ―Nehx xñahzu rahpiꞌ tziahl behtzy gahquiꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herody naꞌ riñlo me igaꞌdy me Juaṉ, per rdzie me, porni gyre meññ ne Juaṉ, profet‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Per dze-guhc xilni Herody‑e naꞌ, byeꞌ xindzabdxuur Herodíaz glaꞌy ru dxie yâme, no byxilyno ṟeiy-Herody mod-ptzoo me. ");
INSERT INTO zpg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Leewe bdee xtiidz me, ra me ndzabdxuur: ―Nitisy gnabiꞌ naa, zdedyaꞌu lii. ");
INSERT INTO zpg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Were ra xmam me leeme gnab me ihqy Juaṉ ni rchôbnihs. Leewe, ndzabdxuur ra me Herody: ―Bdee naa leññ to blad ihqy Juaṉ ni rchôbnihs. ");
INSERT INTO zpg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bioobu ṟeiy-Herody; per gumm ba bdee xtiidz me ñaz-lo meññ-dxieno me lee ruꞌ miax la, were ptzoo me mdad gac mod-ne ndzabdxuur. ");
INSERT INTO zpg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","No pshahl gahc me meññ ni bicchuꞌ ihqy Juaṉ leññ lidzyguiib; ");
INSERT INTO zpg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","no luxu bidno yâmeu leññ to blad no bdee yâmeu, cuaꞌ ndzabdxuur, no wé ba bdeedyu cuaꞌ xmam. ");
INSERT INTO zpg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Byluxu, güya xmeññ Juaṉ, gülesy xcuerp me, biycaꞌdzy yâmeu; no luxu güya yâme bigyne yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hor-gunn Jesúz ni guhc Juaṉ, byruu coo me de uga tohg me, no za me to leññ barcü diby lad, to ru ndruhty nehx nu. Per hor-gunn meññ bá glo za me, guiedzy ni nu yahc gahsh byruu meññ gazeꞌ, za ru za me. ");
INSERT INTO zpg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hor-byruu Jesúz leññ barcü, bwieꞌ me xtahl meññ no bioob me leeyahc, no psiaḻ me meññ-gayac-ure ni ziyno yâme lee. ");
INSERT INTO zpg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gumm ba gayahc guiaal la, were gübigy xmeññ Jesúz, ra yâme leeme: ―Neꞌ ba diby lad‑e leeu no ba udzie. Gu meññ-rieꞌ yahc tza yâme guiedzy-yaañ ni nu gahsh de neꞌ, dzicshii yâme ni gahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ra Jesúz xmeññ me: ―Nehx rquihñ tza yâme; lâ gdee ni gahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ra yâme leeme: ―Nehx rahp noꞌ mbehty guîlrahgü, nunzy gaay paṉ no chohp mbaḻ. ");
INSERT INTO zpg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ra Jesúz leeyâme: ―Lâ guidno leeu neꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Lux ptzoo me mdad gyre meññ cuia yâme lo yu ru nu guix-ngay. No luxu cuaꞌ me gydiby gaay paṉ-caḻ lo ña me no gyrop mbaḻ, no gülesy lo me gybaa, bdee me xquix Dioz, no ptzulaꞌy meu no bdee meu cuaꞌ xmeññ me, no wé ba güdiiz yâmeu, cuaꞌ meññ-dxie yahc uga. ");
INSERT INTO zpg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","No gyre yâme güdahgü glo bydzeꞌ yâme; no de guîlrahgü ni biaꞌn, ptohp yâme tzipychop dzomby ni bydzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Meññ-güdahgü, beeiy gaay mily mpyquie, no nehx güyuꞌ cuent meññ-ngünaa ni mbiux. ");
INSERT INTO zpg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bylux nirieꞌ ra Jesúz xmeññ me tzu yâme leññ barcü no tedy yâme stiby chehsh nisdoo sunier ga yâme, eguiid Jesúz gashahl me meññ-bidyo leeme gybiꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Byluxu, güyehpy me chehsh to dahñ, zigynino me Dioz diby lad. No guhc guiaal; biaꞌn me uga lehzyme, ");
INSERT INTO zpg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","eguiid barcü ba za beeiy glaꞌy nisdoo, no guzlo gaguihñ oḻ leeu, porni rxan gaxuu mbedun. ");
INSERT INTO zpg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ba nchuulr‑e naꞌ, bydziñgahsh Jesúz ru za xmeññ me, gazeꞌ me xtziguia nzeꞌ lo nisdoo. ");
INSERT INTO zpg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hor-bwieꞌ xmeññ me ziaad me gazeꞌ me xtziguia nzeꞌ, bydzie yâme, no de dzieeby pquee yâme riedz ne yâme: ―¡Xguiaḻ meññ‑e nirieꞌ! ");
INSERT INTO zpg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Per Jesúz ra leeyâme: ―¡Di yqueꞌladzy laꞌd mbehty; naa we, di gydzie laꞌd! ");
INSERT INTO zpg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Were günii Pedr, ra leeme: ―Bâḻ lii ziaad‑e, Señor, ptzoo mdad guiaḻaꞌ lo nzeꞌ ru ziaadiꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ra Jesúz leeme: ―Güde. No biaht gahc Pedr de leññ barcü, no gazeꞌ gahc me lo nzeꞌ par tza me ru ziaad Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per hor-bieññ Pedr gaxuu mbedun-ro, bydzie me; no guzlo gahc gayaꞌb me, pquee me riedz, ne me: ―¡Gucno naa, Señor! ");
INSERT INTO zpg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Were günahzy gahc Jesúz ña me, no ra leeme: ―¡Lii uxiee rlíladzyiꞌ! ¿Bia nacu cueꞌladzyiꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hor-güyuꞌ yâme leññ barcü, biandzie gahc mbedun. ");
INSERT INTO zpg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","No meññ-nu leññ barcü bisshiby yâme lo Jesúz, no ra yâme leeme: ―Ulihbu we Xiiñ Dioz lii. ");
INSERT INTO zpg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hor-ba güdedy yâme stiby chehsh nisdoo, bydzihñ yâme to lo ṟegióṉ ni le Genesaret. ");
INSERT INTO zpg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Meññ-nu uga, hor-bzaclo yâme Jesúz, psieññ saꞌ yâme gydo lo ṟegioṉ-wé, no güiyno yâme gyre meññ-gayac-ure yahc ru bydzihñ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","No günab yâme leeme gdee me ñahz can yâme nîcze nieꞌ shab me; no gyre meññ-güdanu, biaḻ gahc yâme de xguîlguihdz. ");
INSERT INTO zpg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Were lahd meññ-nac yahc fariseu no zrieñ muextr ni ruuḻ yahc xleiy Moiséz ni byruu yahc Jerusaléṉ gübigy yâme, ra yâme Jesúz: ");
INSERT INTO zpg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Bia nacu nehx rtzoo xmeññiꞌ mod-ne xcostumbr dtadgul nó ni güyuꞌ yahc ba xtze? Porni nehx rguihby ña yâme mod-ne gahcu ctzoo meññ hor-ba dzictahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Per Jesúz günabdiidz leeyâme: ―¿Bia nacu zegahc nehx rzobdiidz laꞌd ni rtzoo Dioz mdad ctzoo meññ, no ma náḻ laꞌd xcostumbr-guhl laꞌd? ");
INSERT INTO zpg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porni Dioz ne me: “Bzacbeeiy xtadiꞌ no xmamiꞌ”; no zegahc ne me: “Dxu gyniwaty lo xtad o lo xmam la, gaty yâme.” ");
INSERT INTO zpg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per ne laꞌd beeiy ga to meññ xtad o xmam: “Nehx beeiy gacnon lii, porni gyre ni rapaꞌ ñacnon lii, ba to gun par Dioz‑e leeu.” ");
INSERT INTO zpg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","No ne laꞌd nitisy dxu gynii ze, ba nehx rahp de ni gacno xtad o xmam. No porni rtzoo laꞌd ni ne xcostumbr-guhl laꞌd, leewe ba nehx rtzoo laꞌd ni rtzoo Dioz mdad ctzoo meññ. ");
INSERT INTO zpg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu, de lehbu we bisnii Dioz profet-Isaíaz de laꞌd, ru ne me: ");
INSERT INTO zpg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Meññ-rieꞌ yahc, xtziguiasy‑e rzacbeeiy yâme naa, per xguîlmbahñ yâme, ziht nuw. ");
INSERT INTO zpg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mbahty nehx rquihñ ni rguguia yâme naa, porni galuu yâme meññ ni nehzy xguîlriehñ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","No ptohp Jesúz meññ-caḻ yahc gyzac, no ra me lee: ―Lâ guieññ, no lâ gann bia ne ni gayieññ laꞌd: ");
INSERT INTO zpg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ni rahgü meññ o ni roo meññ, dac‑e por leeu rtzoo meññ guîlquie. Mazyg ni rnii meññ, wé we rahc guîlquie par leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Luxu gübigy xmeññ Jesúz, ra yâme leeme: ―¿Nanniꞌ la, meññ-nac yahc fariseu bydziaꞌdzy yâme no ni güniiy? ");
INSERT INTO zpg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Per leeme ra me xmeññ me: ―DTadaꞌ ni nu gybaa, gyre plant ni nehx bdziib me, gylahdzu we. ");
INSERT INTO zpg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Zî-nu meññ-rieꞌ; ngaḻ‑e leeyâme ni rluu zâ-ngaḻ ñahz. No bâḻ to ngaḻ tziyno me sto zâ-ngaḻ me la, gyrop yâme we ziahb leññ guieryu. ");
INSERT INTO zpg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Were ra Pedr leeme: ―Gu noꞌ bia rnii nirieꞌ ni ganiiy ndaagü lo diidz. ");
INSERT INTO zpg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ra Jesúz leeme: ―¿Zegahc nehx rieññ laꞌd ni rnin la? ");
INSERT INTO zpg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Nehx nann laꞌd la, gyre ni rahgü meññ zau leññ meññ, no luxu rruuw de xcuerp meññ? ");
INSERT INTO zpg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per ni rnii meññ ziaadu de leññ guîlmbahñ, no niwé we ni rahc guîlquie par meññ. ");
INSERT INTO zpg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porni de leññ guîlmbahñ rruu guîlrieñ-nahcsy, guîlrgaꞌdy, de ni rzeno meññ tziahl zrieñ, de ni rzeno meññ nitisy dxu nehx tziahl yâme lee, guîlgübaan, guîlmbuxter, no guîlrnii didz-nahcsy contr zrieñ. ");
INSERT INTO zpg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nirieꞌ yahc‑e rahc guîlquie par meññ; per de ni nehx rguihby ña meññ hor-ba dzictahgü, nehx guîlquie leeu. ");
INSERT INTO zpg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Byruu Jesúz de uga no za me lo ṟegióṉ ru nu ciuda-Tiro no ciuda-Sidóṉ. ");
INSERT INTO zpg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Byruu to ngünaa ni nehx meññ-Isṟael lee, meññ-Canáṉ leeme no nu me lo ṟegióṉ ru bydzihñ Jesúz; bigyo me Jesúz no gaquee me riedz, ne me: ―¡Señor, lii ni ziaad de lo xfamily ṟeiy-Davit, bioob naa! Dindzaꞌbaꞌ nu mbenahcsy lee, no gatzoo gasahcu leeme. ");
INSERT INTO zpg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per Jesúz di nsaꞌ lo xtiidz me. Were gübigy xmeññ me, ra leeme: ―Gu leeme gybiꞌ me, porni ziaad me, rquee me riedz chehsh ru zioꞌb nó. ");
INSERT INTO zpg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Were ne Jesúz: ―Dioz pshahl me naa nunzy par meññ-Isṟael ni zidguiahc beeiy xiily ni ba bynihty. ");
INSERT INTO zpg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Per ngüna-rieꞌ naꞌ, gübigy me no bisshiby me lo Jesúz, ra me lee: ―¡Señor, gucno naa! ");
INSERT INTO zpg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ra Jesúz leeme: ―Nehx xñahzu gboo mu xpaṉ mbiux no gdee mu leeu, gahgü mbahcü. ");
INSERT INTO zpg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Per ra me Jesúz: ―Ze we leeu, Señor; per zegahc‑e xtâ mbahcü rahgü ni riahb lo yu de ruꞌ xmiax xbixwaan maꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Were ra Jesúz ngüna-caḻ: ―¡Xroꞌ rlíladzyiꞌ! Leewe, beeiy gacu mod-neꞌy. No lo gahc hor-wé, biaḻ gahc xindzaꞌb me. ");
INSERT INTO zpg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Byruu Jesúz de uga, no güdedy me diby coo gá nisdo-Galilea; no luxu güyehpy me chehsh to dahñ no gürie me uga. ");
INSERT INTO zpg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bydzihñ xtahl meññ ru dxie me, no zidno yâme meññ-ndang, meññ-ngaḻ, meññ-ngop, meññ-nrung ña o nrung nieꞌ, no xtahl zrieñ meññ-gayac-ure. Bistzihñ yâme lee ru dxie Jesúz, no psiaḻ me leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","No rtzunadz meññ hor-bwieꞌ yâme meññ-ngop ba rnii, meññ-nrung ña o nrung nieꞌ ba guctziaawy, meññ-ndang ba rzeꞌ, no meññ-ngaḻ ba rwieꞌ. No guzlo yâme gaguguia yâme xDioz meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Luxu günino Jesúz xmeññ me, no ra me leeyahc: ―Rioobaꞌ meññ-rieꞌ yahc, porni ba rahp tzonn dzé nu yâme no naa, no nehx rahp yâme ni gahgü yâme; nehx neu naa cshaalaꞌ leeyâme gybiꞌ yâme no galahn yâme, duhn nre gan leeyâme lo ñahz de guîlrlahn. ");
INSERT INTO zpg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ra xmeññ me leeme: ―¿Per bá glo ndzial nó guîlrahgü par xtahl meññ to ru ndruhty nehx nu, beeiy neꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Günabdiidz Jesúz leeyâme: ―¿Blac paṉ rahp laꞌd? Ra xmeññ me leeme: ―Gahdzyu, no chohp tzonn mbaḻ-yaañ. ");
INSERT INTO zpg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Were ptzoo Jesúz mdad gürie meññ-caḻ yahc lo yu, ");
INSERT INTO zpg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","no cuaꞌ me gydiby gahdzy paṉ-caḻ lo ña me no mbaḻ zegahc; byluxz bdee me xquix Dioz, ptzulaꞌy meu no bdee meu cuaꞌ xmeññ me par güdiiz leeu, cuaꞌ meññ-dxie yahc uga. ");
INSERT INTO zpg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","No gyre yâme güdahgü glo bydzeꞌ yâme; no de guîlrahgü ni biaꞌn, ptohp yâme gahdzy dzomby ni bydzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","No meññ-rieꞌ yahc naꞌ, nac yâme tahp mily meññ-mpyquie no nehx güyuꞌ cuent meññ-ngünaa no mbiux. ");
INSERT INTO zpg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lux pshahl Jesúz gyre meññ zia yâme, no güyuꞌ gahc me leññ barcü no za me lo ṟegioṉ ni le Magdala. ");
INSERT INTO zpg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Meññ-nac yahc fariseu no meññ-nac yahc saduceu bydzihñ yâme; no lehdy nwieꞌ yâme bia beeiy rtzoo Jesúz, günab yâme nluu me leeyâme to ni ngann ni nunzy Dioz beeiy rtzoo. ");
INSERT INTO zpg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Per ra Jesúz leeyâme: ―Hor-racnixni leññ gybaa udzie, bac ne laꞌd: “Tiemp-mos nu nó”; ");
INSERT INTO zpg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","no hor-rbia xcawy no racnixni leññ gybaa rsily, bac ne laꞌd: “Dzêrieꞌ zahc guio.” ¡Laꞌd‑e ni ne meññ-tziaawy lee nîcze nehx uliu! Sca-ze rzaclo laꞌd xnahc za tiémp no ni rwieꞌ laꞌd leññ gybaa, ¡mazyg señal ni gawieꞌ laꞌd neꞌ lo guiedzylie ni gayahc tiemp-rieꞌ, nehx rzaclo laꞌd lee! ");
INSERT INTO zpg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Meññ-di rzobdiidz ni nu ni naꞌ no ni pur ni nadz nu leññ ihqy, rnab nwieꞌ ñahc to ni ngann ni nunzy Dioz beeiy rtzoo; per ba nehx zwieꞌ yâme zrieñ ni ngann ni ñahc, mazyg beeiy ni ngann ni guhc no profet-Jonáz. No luxu, zu meññ-wé yahc, za Jesúz psaꞌn leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Byluxz güdedy xmeññ Jesúz stiby chehsh nisdoo, bitsêlou leeyâme nehx ziyno yâme paṉ ni ñahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","No ra Jesúz leeyâme: ―Gax lâ güieꞌ; lâ gap laꞌd no ni nac meññ-fariseu no ni nac meññ-saduceu, ni zidguiahc yahc beeiy levadur. ");
INSERT INTO zpg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Xmeññ me naꞌ nlâdzy yâme porni di nidno yâme paṉ, leewe günii Jesúz ze. ");
INSERT INTO zpg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Per Jesúz naꞌ nann me bia ganii leññ ihqy xmeññ me, leewe ra me lee: ―¿Bia nacu ne laꞌd nehx rahp laꞌd paṉ? ¡Laꞌd uxiee rlíladzy laꞌd! ");
INSERT INTO zpg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Nehx ziaꞌr rieññ laꞌd, no nehx ritsêlou laꞌd de gaay paṉ ni güdiizaꞌ, güdahgü gaay mily meññ, no blac dzombyu ni biaꞌn ptohp laꞌd la? ");
INSERT INTO zpg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ni di ritsêlou laꞌd de gahdzy paṉ ni güdiizaꞌ, güdahgü tahp mily meññ, no blac dzombyu ptohp laꞌd la? ");
INSERT INTO zpg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Bia nacu nehx rieññ laꞌd nehx ganin lguia paṉ, hor-ren laꞌd: “Gax lâ gann, na di ycaꞌ laꞌd xlevadur meññ-nac yahc fariseu no meññ-nac yahc saduceu”? ");
INSERT INTO zpg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","No were bieññ yâme nehx gaya Jesúz leeyâme di ycaꞌ yâme xlevadur paṉ, mazyg gaya Jesúz leeyâme we, na di ycaꞌ yâme mod-rlíladzy no mod-rluu meññ-nac yahc fariseu no meññ-nac yahc saduceu. ");
INSERT INTO zpg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hor-bydzihñ Jesúz ru le Cesarea de Filipo, günabdiidz me xmeññ me, ra me: ―¿Dxu we ne meññ naa? ");
INSERT INTO zpg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ra yâme leeme: ―Nu yâme ne Juaṉ ni pchôbnihs meññ‑e lii; zrieñ yâme ne Elíaz‑e lii ni güyuꞌ ba xtze; no zrieñ yâme ne Jeremíaz‑e lii, o dxuhch de lahd profet ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Were ra Jesúz leeyâme: ―Naꞌz laꞌd, ¿dxu we ne laꞌd naa? ");
INSERT INTO zpg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ra Simoṉ-Pedr leeme: ―Lii we nac Crist, Xiiñ Dioz-mbahñ. ");
INSERT INTO zpg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Were ra Jesúz leeme: ―Dxu ñahc beeiy lii, Simóṉ, xiiñ Jonáz, porni ndruhty dgueññ ga lii bâḻ ze leeu, mazyg dTadaꞌ ni nu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","No gapyaꞌ lii, lii we Pedr no ley ganiiu “to guie”. Chehsh guie-rieꞌ gzan diydoon; no guîlguhty nehx beeiy ctzoo leeu mbehty. ");
INSERT INTO zpg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gdedyaꞌ lii xllavy gybaa ru rtzoo Dioz mdad; ni ctzooy neꞌ lo guiedzylie, zegahc gacu gybaa; no ni nehx stzooy neꞌ lo guiedzylie, zegahc nehx zahcu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Luxu ra Jesúz xmeññ me na di ga yâme ndruhty bâḻ leeme we ni nac Crist. ");
INSERT INTO zpg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Glohdy dze-wé guzlo Jesúz, ra me xmeññ me rahp me de ni tza me Jerusaléṉ, no luxu mînguhl yahc ni nac guxtisy, no xjefy yahc bahl, no muextr ni ruuḻ yahc xleiy Moiséz, stzoo ssahc yâme leeme gyre gyzasy mód. No ra me zgaꞌdy yâme leeme, per lo tzonn dzé zbahñ me gyzac. ");
INSERT INTO zpg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Were güloo Pedr leeme diby lad, no guzlo ndush bia nacu rnii me ze, no gaya leeme: ―¡Dioz di ñahcladzy, Señor! ¡Nehx zahquiꞌ gyre mod-neꞌy! ");
INSERT INTO zpg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Per Jesúz naꞌ, biehqy me no ra me Pedr: ―¡Byruu diby lad de naa, bêndzab! Riñloꞌy gletyrxaniꞌ naa lehdy di ctzon ni ne Dioz. Porni xguîlriehñiꞌ nehx rdeedyu tohzy no ni ne Dioz, mazyg rdeedyu tohzy no xguîlriehñ meññ. ");
INSERT INTO zpg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Luxu ra Jesúz xmeññ me: ―Dxu racladzy gac dmeññaꞌ lee la, csaan gyre ni nahcsy ni nac, no gbooladzy xtâ xguîlmbahñ, no ctzoo ni ren. ");
INSERT INTO zpg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Porni dxu gacladzy guislaa xguîlmbahñ leegahc la, zniꞌdyu; per dxu gniꞌdy xguîlmbahñ por naa la, wé zdzial guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Porni ¿bá we nquihñu par to meññ ñahc xchieñ me gyre ni nu lo guiedzylie, no luxu nniꞌdy me xguîlmbahñ me? No zegahc, ¿bia beeiy ndee to meññ lehdy nislaa xguîlmbahñ me? ");
INSERT INTO zpg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Porni naa, Mpyquie-Pshahl Dioz Lee, guiaḻaꞌ no d‑ángel yahcaꞌ lo xguîlbyniꞌ dTadaꞌ, no ycuquixaꞌ to to meññ no ni ptzoo. ");
INSERT INTO zpg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gapyaꞌ laꞌd ni uli, nu lahd meññ-rieꞌ ni nu yahc neꞌ, nehx zehty sinn güieꞌ dze-naa, Mpyquie-Pshahl Dioz Lee, ba ziaḻaꞌ no rtzon mdad. ");
INSERT INTO zpg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Güdedy shoꞌb dzé, güiyno Jesúz Pedr, Jacob, no Juaṉ behtzy Jacob, no za yâme nunzy leeyâme ihqy to dañ-suu. ");
INSERT INTO zpg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Uga bwieꞌ yâme bydzee mod-nac lo Jesúz, rcampytzeꞌ lo me beeiy lo ncübidz, no shab me gucnquitzybou lé rguꞌu byniꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lohg hor-wé bwieꞌ yâme Moiséz no Elíaz ni güyuꞌ yahc ba xtze, gayu yâme diidz no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Were ra Pedr Jesúz: ―Señor, ¡lehgxu zuu nó neꞌ! Bâḻ neꞌy la, gzaa noꞌ tzonn ṟamad: tohbyu par lii, stohbyu par Moiséz, no stohbyu par Elíaz. ");
INSERT INTO zpg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ganii ziaꞌ Pedr ze, tohzydzi bihtz to zá leeyâme lé rguꞌu byniꞌ; no lo za-wé bieññ yâme to riedz, ni ne: ―Nirieꞌ we dShiñaꞌ ni ndzin lee, no ni rxilynon lee; lâ guieññ ni ga me laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hor-bieññ xmeññ Jesúz nirieꞌ, bisshiby yâme no ba di nlesy lo yâme nwieꞌ yâme, no modni gadzie yâme. ");
INSERT INTO zpg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Were gübigy Jesúz ru nisshiby yâme, no pshob ña chehsh yâme, no ra leeyâme: ―Lâ guiahs; di gydzie laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","No bwieꞌ yâme, ba ndruhty dgueññ, ba nunzy Jesúz bwieꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lóni gayaht yâme dahñ, ra Jesúz leeyâme: ―Na di gu laꞌd diidz lo ndruhty ni bwieꞌ laꞌd, xtâ glo naa, Mpyquie-Pshahl Dioz Lee, ba gübahñaꞌ de lahd mînguty. ");
INSERT INTO zpg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Luxu günabdiidz xmeññ me leeme: ―¿Bia nacu ne muextr-ruuḻ yahc xleiy Moiséz nier Elíaz‑e guiaad? ");
INSERT INTO zpg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ra Jesúz leeyâme: ―Ni uli we leeu nier Elíaz guiaad, no leeme guistziaawy gyreu. ");
INSERT INTO zpg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per naa gapyaꞌ laꞌd, Elíaz ba biahd me, no nehx bzaclo meññ leeme, mazyg ptzoo yâme leeme nitisy gucladzy yâme; no mod-wé gahc‑e ctzoo csahc yâme naa, Mpyquie-Pshahl Dioz Lee. ");
INSERT INTO zpg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","No were gunn xmeññ me de Juaṉ ni rchôbnihs‑e ganii me. ");
INSERT INTO zpg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ru bydzihñ yâme ru dxie meññ-xtahl‑e naꞌ, gübigy to mpyquie no bisshiby me lo Jesúz, ra me lee: ");
INSERT INTO zpg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Señor, bioob dñoobyaꞌ, porni rnahzy mbeꞌ leeme, no rtzoo rsahcu leeme; xtahl vuelt riahb me lo gue o lo nzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Bidnon leeme lo xmeññiꞌ, per di ñaḻ nsiaḻ yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Hor-bieññ Jesúz nirieꞌ, ra me: ―¡Laꞌd ni nu ni naꞌ, nehx rlíladzy laꞌd naa no meññ-dirquihñ laꞌd! ¿Xtâ buc rapaꞌ de ni tzun lahd laꞌd? ¿Xtâ buc beeiy ctibdadzyaꞌ laꞌd? Lâ guidno leeme neꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Were güdeḻy Jesúz mbenahcsy, no güloo meu ñobywiñ, no glohdy dze-caḻ biaꞌn me nzaꞌg. ");
INSERT INTO zpg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Luxu, ba diby lad no ru ba lehzy yâme, günabdiidz xmeññ Jesúz leeme, ra yâme: ―¿Bia nacu noꞌ di ñaḻ mboo noꞌ mbenahcsy? ");
INSERT INTO zpg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ra Jesúz leeyâme: ―Porni uxiee rlíladzy laꞌd; gapyaꞌ laꞌd ni uli, bâḻ nlíladzy laꞌd nîcze doozy, beeiy ña laꞌd dañ-wé: “Byruu de neꞌ, bicchie sto lad”, no dahñ nruuw; no mbehty nehx ñacngann par laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Per zâ mbenacsy-wé nehx beeiy nruuw sinn gnab meññ lo Dioz no sinn ctzoo meññ ayun. ");
INSERT INTO zpg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hor-nu Jesúz no xmeññ me lo ṟegioṉ-Galilea, ra me leeyahc: ―Naa Mpyquie-Pshahl Dioz Lee; zdee dxuhch naa lo ña meññ-rdziadzyno naa, ");
INSERT INTO zpg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","no zgaꞌdy yâme naa; per lo tzonn dzé zbahñaꞌ gyzac. Hor-bieññ yâme ni günii me, güyuꞌ yâme trixd. ");
INSERT INTO zpg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hor-bydzihñ Jesúz no xmeññ me Capernaum, güya meññ-rcuquix ximpuezd idoró, ra yâme Pedr: ―¿Xmuextriꞌ nehx rguix me mpuezd par idoró la? ");
INSERT INTO zpg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ra Pedr leeyâme: ―Rguix me. Luxu, güyuꞌ Pedr leññ yuꞌ no dgueññ ziaꞌ gynii me, nier Jesúz ra leeme: ―¿Sca nac lii, Simóṉ? Meññ ni rtzoo mdad neꞌ lo guiedzylie, ¿dxu rcuquix yâme mpuezd lee? ¿Xmeññ yâme la, o meññ-zrieñ lad? ");
INSERT INTO zpg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ra Pedr leeme: ―Meññ-zrieñ lad. Ra Jesúz leeme: ―Xmeññ yâme we ba riaꞌn di rguix. ");
INSERT INTO zpg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Per lehdy di gydziaꞌdzy ndruhty, güya coo nisdoo no bráḻ guiatz-mbaḻ leññ nzeꞌ, no mbaḻ ni gbooy nier lee la, leññ ruꞌ maꞌ gydzialiꞌ medy ni ziygahl par quixiꞌ mpuezd; tziynoyu no quixiꞌ xchieñ gyrop nó. ");
INSERT INTO zpg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Leññ gahc dze-wé yahc xmeññ Jesúz günabdiidz yâme Jesúz, ra yâme: ―¿Dxu we ma rsahc de dlahd noꞌ ni tzu ru rtzoo Dioz mdad? ");
INSERT INTO zpg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Were pquee Jesúz riedz to ñôbydxuur, no bzu me lee glaꞌy ru zu yâme. ");
INSERT INTO zpg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","No ra me: ―Gapyaꞌ laꞌd ni uli, bâḻ di csaan laꞌd ni nac laꞌd lehdy gac laꞌd beeiy mbiux la, nehx beeiy tzu laꞌd ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","No leewe, dxu gac beeiy mbiux-rieꞌ ni nehx rguguia leegahc, wé we ma rsahc ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","No bâḻ dxuhch, porni rzobdiidz naa, gacno to beeiy mbiux-rieꞌ la, scâsy ñacno yâme naa we. ");
INSERT INTO zpg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Nitisy dxu por xtoḻ guiatrxan to ni zidguiahc beeiy mbiux-rieꞌ ni rlíladzy yahc naa la, beeiydí nguꞌ meññ to duu yañ me no nlihby yâme to xguie-ro molin lou, no nráḻ meññ leeme leññ nisdoo ru ma guial. ");
INSERT INTO zpg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Baazy dzii meññ ni nu lo guiedzylie no gyre ni por xtoḻ riatrxan yâme lehdy ctzoo yâme guîlquie! Lo guiedzylie tzur ni por xtoḻ guiatrxan meññ, per ¡baazy dzii de meññ ni por xtoḻ guiatrxan zrieñ meññ! ");
INSERT INTO zpg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’No leewe, bâḻ ñay o nieꞌy rquihlyu lii ctzooy guîlquie la, pchuꞌ leeu no psaabyu ziht de lii. Beeiydí tzuy ndanguiꞌ o nrung ñay ru gapiꞌ guîlmbahñ ni nehx zluhx, no dac tzaꞌy queꞌ gyrop ñay o gyrop nieꞌy ru nehx ziuꞌ dzé guiee gue. ");
INSERT INTO zpg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","No bâḻ to loꞌy rquihlyu lii ctzooy guîlquie la, güloo leeu no psaabyu ziht de lii. Beeiydí tzuy no tohzy loꞌy ru gapiꞌ guîlmbahñ ni nehx zluhx, no dac tzaꞌy no gyrop loꞌy lo gue ni nu infiern. ");
INSERT INTO zpg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Na di gboo laꞌd diby lad ni to lahd mbiuxyañ-rieꞌ; porni gapyaꞌ laꞌd, ángel yahc ni rwieꞌ leeyâme tirgahc nu yâme gybaa ru nu dTadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","No naa, Mpyquie-Pshahl Dioz Lee, biaḻaꞌ neꞌ lehdy gylan ni ba rahc cuent ba bynihty. ");
INSERT INTO zpg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Bia ne laꞌd? Bâḻ to meññ rahp me diby gayuu xiily, no bâḻ nnihty to de lahd maꞌ, ¿nehx nsaꞌn me noventaynuevy maꞌ no nigyo me xiily ni ganihty la? ");
INSERT INTO zpg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","No bâḻ ndzial me leemaꞌ, gapyaꞌ laꞌd, ma nxihly me por to xiily we que por noventaynuevy xiily ni nehx bynihty. ");
INSERT INTO zpg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","No zegahc‑e, xTad laꞌd ni nu gybaa nehx racladzy me gynihty ni to de lahd mbiuxyañ-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Bâḻ xirmaniꞌ rtzoo me lii behch, güya tohg lii no günino tohg me, gu leeme ni nadz‑e ni gatzoo me lii. No bâḻ guieññ me xñahzu ni gayahbyiꞌ leeme la, were ba ptzooy gan tzu laꞌd dzie tziaawy gyzac. ");
INSERT INTO zpg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Per bâḻ par leeme nehx xñahzu mod-gayahbyiꞌ leeme la, were gyohbyiꞌ to meññ o chohp meññ mazy tziynoy gyzac, lehdy beeiy guieññ me o lehdy yquihñiꞌ meññ-rieꞌ yahc de testigü. ");
INSERT INTO zpg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","No bâḻ ba di ne me guieññ leeyâme, were ba cteedyiꞌu lo ña meññ-idoo; no bâḻ di guieññ me meññ-idoo la, were gac me par laꞌd beeiy to meññ-nehx rlíladzy Dioz o beeiy to meññ-rcuquix mpuezd. ");
INSERT INTO zpg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Gapyaꞌ laꞌd ni uli, gyre ni glihby laꞌd neꞌ lo guiedzylie, zehg‑e zlihbyu gybaa; no ni cshac laꞌd neꞌ lo guiedzylie, zehg‑e sshacu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Gapyaꞌ laꞌd nirieꞌ: Bâḻ chohp lahd laꞌd ctzoo diidz gnab behch lo Dioz neꞌ lo guiedzylie, dTadaꞌ ni nu gybaa zdee leeu. ");
INSERT INTO zpg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porni rutisy rdohp chohp o tzonn meññ-gaguguia dlen, wé we nun glaꞌy ru nu yâme. ");
INSERT INTO zpg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Luxu gübigy Pedr no ra me Jesúz: ―Señor, ¿bla vuelt rapaꞌ de ni csiaaḻdadzyaꞌ bâḻ rtzoo to rman naa behch ni dirquihñ? ¿Xtâ gahdzy vuelt la? ");
INSERT INTO zpg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ra Jesúz leeme: ―Dac‑e nunzy xtâ gahdzy vuelt, mazyg xtâ setent vuelt gahdzy. ");
INSERT INTO zpg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’No leewe, mod-rtzoo Dioz ni nu gybaa mdad, ze we zidguiahcu beeiy to ṟeiy ni gaboo xcuent bla nzahby xmós me leeme. ");
INSERT INTO zpg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lóni gaboo me cuent‑e naꞌ, bydziñno yâme to de lahd gahc yâme ni nzaby-tarie leeme. ");
INSERT INTO zpg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mpyquie-rieꞌ naꞌ, gumm nehx rahp me bia no quix me ni nzahby me la, were ptzoo ṟeiy mdad gydoꞌ me no gahc tziahl me, no ximbiux me, no zrieñ xcos me ni rahp me, lehdy guiax gyre ni nzahby me. ");
INSERT INTO zpg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Per mos-rieꞌ naꞌ bisshiby me, no ra me: “Señor, güliahz naa stoozy, zguixaꞌ gyre ni nzaabyaꞌ lii.” ");
INSERT INTO zpg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ṟeiy naꞌ bioob leeme, bislaa leeme no ba di nguix me ni nzahby me porni psiaaḻladzy ṟeiy leeu. ");
INSERT INTO zpg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Per byruhzy me de ru dxie ṟeiy, bwieꞌ me sto zâ-mós me ni nzahby leeme doozy. Günahzy gahc me lee, gaguie me yañ, gayiscawy me lee, no gaya me lee: “¡Güdix ni nzahbyiꞌ naa!” ");
INSERT INTO zpg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mos-rieꞌ naꞌ bisshiby lo me, no ra leeme: “Güliahz naa stoozy, zguixaꞌ gyre ni nzaabyaꞌ lii we.” ");
INSERT INTO zpg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Per mpyquie ni gaguihñ leeme nehx bioob leeme, no ptzoo gahc mdad biagü me lidzyguiib lehdy quix gax me, were gyruu me de ru nyagü me. ");
INSERT INTO zpg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nirieꞌ bwieꞌ zrieñ zâ-mós me, bioobu leeyâme de mpyquie-rieꞌ ni bydihñ no nyagü lidzyguiib, no güya gahc yâme, ra yâme ṟeiy gyre mod-bwieꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ṟeiy naꞌ pshalcaꞌ me mpyquie-rieꞌ ni güdihñ mos-nyagü lidzyguiib, ra me lee: “¡Mos-dirquihñ lii! Naa bioobaꞌ lii, ba di nguixiꞌ ni nzahbyiꞌ naa porni bisshibyiꞌ dloꞌn no rahbyiꞌ naa guioobaꞌ lii. ");
INSERT INTO zpg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Modé gahc‑e ñoobiꞌ zâ-mósiꞌ, mod-bioob gahcaꞌ lii.” ");
INSERT INTO zpg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","No bydziaꞌdzy ṟeiy, pteedy gahc leeme lo ña meññ-gdee xguîlné me xtâ glo quix me gyre ni nzahby me. ");
INSERT INTO zpg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ra Jesúz leeyâme: ―Zegahc‑e ctzoo dTadaꞌ ni nu gybaa no laꞌd bâḻ di guioob laꞌd xirman laꞌd nîcze rtzoo yâme laꞌd behch. ");
INSERT INTO zpg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Byluxz günii Jesúz ze, byruu me lo ṟegioṉ-Galilea no za me lo ṟegioṉ-Judea ni riaꞌn stiby chehsh guiagü-Jordáṉ. ");
INSERT INTO zpg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Xtahl meññ náḻ ru za me, no psiaḻ me xtahl meññ-gayac-ure. ");
INSERT INTO zpg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","No lahd meññ-nac yahc fariseu güya gayo xnahc nsiahb yâme Jesúz no to ni ngann, no ra yâme leeme: ―¿Xñahzu we la, bâḻ ntzily to mpyquie guîltziahl no tziahl me por nitisy doḻ? ");
INSERT INTO zpg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ra Jesúz leeyâme: ―¿Nehx ruuḻ laꞌd ni ziaad lo Guehtzy ru queꞌ xtiidz Dioz la, ru neu dze-bzaa Dioz meññ, “bzaa me mpyquie no bzaa me ngünaa”? ");
INSERT INTO zpg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","No ra me: “Leewe rruu to mpyquie coo xtad no coo xmam, no tzu me no tziahl me, no were ba gyrop yâme gac beeiy gahc tohzy meññ.” ");
INSERT INTO zpg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","No leewe, ba dac‑e chohp meññ leeyâme, mazyg ba beeiy gahc tohzy meññ‑e leeyâme. Leezuwe, ni ba ptzoo Dioz lee tohzy, di ctzily ndruhty leeu. ");
INSERT INTO zpg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ra meññ-nac yahc fariseu Jesúz: ―Were, ¿bia nacu ne Moiséz beeiy gzaa mpyquie to guehtzy ni gynii ba ptzily me guîltziahl, no gdee meu tziahl me, no luxu csaꞌn me lee? ");
INSERT INTO zpg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ra Jesúz meññ-nac yahc fariseu: ―Bdee Moiséz ñahz rtzily laꞌd guîltziahl porni nahdy xguîlmbahñ laꞌd; per glo dze-güyaa guiedzylie, nehx ne Dioz ñahcu ze. ");
INSERT INTO zpg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","No naa gapyaꞌ laꞌd, nitisy dxu ctzily guîltziahl no ndzab-tziahl, nîcze nehx güzeno ngüna-rieꞌ sto ni nehx tziahl me lee, no guidzña me no sto ngünaa la, gatzoo mpyquie-rieꞌ guîlquie; no dxu guidzña no to ngünaa ni gübily xguîltziahl la, guîlquie gahc‑e zahcu par lee. ");
INSERT INTO zpg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ra xmeññ Jesúz leeme: ―Bâḻ neꞌy ze leeu la, ma mos‑e nehx guidzña ndruhty. ");
INSERT INTO zpg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ra Jesúz xmeññ me: ―Dac‑e gyre meññ beeiyu lee nehx nidzña, mazyg nunzy meññ ni gdee Dioz lsenzy, wé we beeiy ctzoo ze. ");
INSERT INTO zpg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nu mpyquie-nehx ridzña porni glo guhl yâme nu ni rca gap xiiñ yâme, no nu mpyquie-nehx ridzña porni meññ pca de ni gap xiiñ yâme, no nu meññ-nehx ridzña porni riuꞌladzy yâme ctzoo yâme nunzy xtziiñ Dioz ni rtzoo mdad. Dxu beeiy ctzoo ze, ctzoo leeu. ");
INSERT INTO zpg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Güiyno meññ mbiux par cshob ña Jesúz chehsh yâme no par gnab me lo Dioz por mbiux-rieꞌ yahc; per xmeññ Jesúz naꞌ, ndush yâme lo meññ-zidno mbiux. ");
INSERT INTO zpg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Were ra Jesúz leeyâme: ―Lâ gdee ñahz guiaad mbiux ni zidyo naa, no di yca laꞌd leeyâme; porni dxu gac scâsy mbiux-rieꞌ yahc la, par leeyâme we ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","No bylux pshob ña me chehsh mbiux, luxu byruu me de uga, no za me. ");
INSERT INTO zpg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Güya to mpyquie-ṟicü, no ra me Jesúz: ―Muextr, naa nannaꞌ meññ-tziaawy lii. ¿Bia ni mos ntzon lehdy ñapaꞌ guîlmbahñ ni nehx zluhx? ");
INSERT INTO zpg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ra Jesúz leeme: ―¿Bia nacu rahbyiꞌ naa meññ-tziaawy? Ndruhty nehx meññ-tziaawy lee, mazyg nunzy Dioz. Per bâḻ racladzyiꞌ gapiꞌ guîlmbahñ ni nehx zluhx la, gyre ni rtzoo Dioz mdad ctzoo meññ la, ptzoo leeu. ");
INSERT INTO zpg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ra me Jesúz: ―¿Sca bia leeu? Ra Jesúz leeme: ―Di igaꞌdyiꞌ meññ. Di senoy tziahl meññ. Di cuaniꞌ. Di gyniiy ni nehx uli de meññ. ");
INSERT INTO zpg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bzacbeeiy xtadiꞌ no xmamiꞌ; no bintzi zâ-bynechiꞌ mod-ndzi gahquiꞌ lii. ");
INSERT INTO zpg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ra mpyquie-caḻ leeme: ―Gyre nirieꞌ gatzon mod-ne glo nwiñaꞌ. ¿Bia sto gayaadzaꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ra Jesúz leeme: ―Bâḻ racladzyiꞌ di gydzial mbehty doḻ chehshiꞌ la, güya, ptoꞌ ni rahpiꞌ, no bdee xmedyu ycaꞌ meññ-nehx rahp mbehty, were zahpiꞌ xtahl ni rsahc gybaa; luxu guiaadiꞌ, tzaꞌy no naa. ");
INSERT INTO zpg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hor-bieññ mpyquie-rieꞌ ni miꞌñ ziaꞌ lee ni ra Jesúz leeme, güyuꞌ me trixd za me, porni rahp me xtahl ni rsahc. ");
INSERT INTO zpg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Were ra Jesúz xmeññ me: ―Gapyaꞌ laꞌd ni uli, modni ngann zahcu no to meññ ni rahp xtahl ni rsahc, ndee me ñahz ntzoo Dioz mdad leeme. ");
INSERT INTO zpg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gapyaꞌ laꞌd gyzac, ma nehx ngann ndedy to camell xguiehr igux que to meññ-ṟicü ndee me ñahz ntzoo Dioz mdad leeme. ");
INSERT INTO zpg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ru bieññ xmeññ me ze, modni gatzunadz yâme, no ne yâme: ―¿Dxu we naꞌ beeiy gylaa par tzu lo xñahz Dioz? ");
INSERT INTO zpg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bwiedzie Jesúz leeyâme, no ra me: ―Nehx ñaḻ ntzoo meññ nirieꞌ; per no Dioz, gyreu we beeiy. ");
INSERT INTO zpg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Were ra Pedr leeme: ―Noꞌ psaꞌn noꞌ gyre ni güdahp noꞌ, no zo noꞌ ru zaꞌy. ¿Bia leeu naꞌ ycaꞌ noꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, dze-gydzee gyre cos mod-nac, lee we dze-ba naa, Mpyquie-Pshahl Dioz Lee, dxien to ru mos ru ctzon guîlguxtisy to lo guîlbyniꞌ, were laꞌd ni nac dmeññaꞌ lee, zbia laꞌd zegahc tzipychop lgar ru ctzoo laꞌd guîlguxtisy, no güieꞌ laꞌd ni nac gyre meññ-ziaad de lo xfamily gydiby tzipychop xiiñ Isṟael. ");
INSERT INTO zpg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","No nitisy dxu psaꞌn xiryuꞌ, behtzy o baḻ, byzan, xtad, xmam, tziahl, xiiñ, o xilyu por naa la, Dioz zdee leeme diby gayuu vuelt ma xtahl, no ycaꞌ me guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Per xtahl meññ ni ma rsahc lahd meññ neꞌ la, zdzihñ dze-ma uxiee qysahc yâme; no xtahl meññ ni ma uxiee rsahc lahd meññ neꞌ, wé we ma qysahc. ");
INSERT INTO zpg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Mod-rtzoo Dioz ni nu gybaa mdad, ze we zidguiahcu beeiy ni ptzoo xbixwaan to xroꞌ lyu; mpyquie-rieꞌ naꞌ, byruu me rsily, zigyo me meññ par ctzoo dziiñ lo xilyu me ru dziib blatzy. ");
INSERT INTO zpg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hor-ba bydzial me meññ‑e naꞌ, ra me quix me lee sahc xchieñ to dzé, no pshahl me leeyâme lo xilyu me. ");
INSERT INTO zpg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Gyzac beeiy las-nuevy za me sto, bydzial me zrieñ meññ ni ganzeꞌ lóguiaꞌ zehzy. ");
INSERT INTO zpg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ra me leeyahc: “Lâ tza laꞌd zegahc, lâ dzictzoo dziiñ lo dilyun ru rapaꞌ blatzy; naa quixaꞌ laꞌd nza de ni ctzoo laꞌd dziiñ.” No za yâme. ");
INSERT INTO zpg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Beeiy ribygue gyzac güya xbixwaan lyu, no zegahc güya me beeiy las-trez udzie, no mod-wé gahc ptzoo me. ");
INSERT INTO zpg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Beeiy las-cincü udzie gyzac güya me lóguiaꞌ, no bydzial me zrieñ meññ ni nehx nu xtziiñ, ra me lee: “¿Bia nacu nu laꞌd neꞌ gydo dzé no nehx gatzoo laꞌd dziiñ?” ");
INSERT INTO zpg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ra yâme leeme: “Porni nehx nu dxu ntzono noꞌ dziiñ.” Were ra me: “Lâ tza laꞌd zegahc, lâ dzictzoo dziiñ lo dilyun.” ");
INSERT INTO zpg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Hor-güyuꞌ guiaal‑e naꞌ, ra xbixwaan lyu mpyquie-nu xcargü par güieꞌ gac dziiñ: “Pquee riedz meññ-gatzoo yahc dziiñ, no güdix leeyâme; quixiꞌ nier meññ-bydzihñ últim, no luxu quixiꞌ meññ-bydzihñ nier lee.” ");
INSERT INTO zpg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","No bydzihñ meññ-güyuꞌ lo dziiñ beeiy las-cincü udzie, no cad to yâme biax ni nac sahc xchieñ to dzé. ");
INSERT INTO zpg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bylux bydzihñ meññ-güyuꞌ lo dziiñ nier lee, nlâdzy yâme ma xtahl medy‑e ycaꞌ yâme; per cad to yâme cuaꞌ nunzy ni nac sahc xchieñ diby dzé. ");
INSERT INTO zpg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Byluxu, galesyno yâme, ra yâme xbixwaan dziiñ: ");
INSERT INTO zpg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“¿Bia nacu meññ-rieꞌ ni bydzihñ ba udzie, güdixiꞌ lee mod-güdix gahquiꞌ noꞌ? Leeyâme diby hór mbí ptzoo yâme dziiñ; noꞌ naꞌ ptzoo noꞌ dziiñ gydo dzé no güdihñ nlay noꞌ.” ");
INSERT INTO zpg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Per xbixwaan dziiñ ra me to lahd meññ-rieꞌ yahc: “Mígü, nehx gatzon lii mbehty ni nehx xñahzû. ¿Dâs‑e nac diidz, quixaꞌ lii sahc xchieñ to dzé la? ");
INSERT INTO zpg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cuaꞌ ni ba biaxiꞌ no güya. Naa racdadzyaꞌ gdedyaꞌ meññ-rieꞌ ni bydzihñ udzie mod-cuaꞌ gahquiꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Nehx beeiy ctzon ni ren no dmedyaꞌ la? ¿O rdziaꞌdzyiꞌ porni rioobaꞌ meññ la?” ");
INSERT INTO zpg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Leewe, xtahl meññ ni ma uxiee rsahc lahd meññ neꞌ la, zdzihñ dze-ma qysahc yâme; no xtahl meññ ni ma rsahc lahd meññ neꞌ, wé we ma uxiee qysahc; porni xtahl meññ‑e rqueꞌ riedz lee, per uxiee yâme gybee. ");
INSERT INTO zpg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hor-za Jesúz Jerusaléṉ, güloo me gydiby tzipychop xmeññ me diby lad, no ra me lee: ");
INSERT INTO zpg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Sca-ze gawieꞌ laꞌd, zo nó Jerusaléṉ, no naa, Mpyquie-Pshahl Dioz Lee, uga zdee dxuhch naa lo ña xjefy yahc bahl no lo ña muextr ni ruuḻ yahc xleiy Moiséz. No znii yâme rapaꞌ de ni gatyaꞌ; ");
INSERT INTO zpg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","no luxu gdee yâme naa lo ña meññ-nehx meññ-Isṟael, lehdy ctzuburl yâme naa, ctzoo csahc yâme naa, no yquee yâme naa lo cruzy; per lo tzonn dzé zbahñaꞌ gyzac. ");
INSERT INTO zpg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Luxu bydzihñ ndzab-tziahl Zebedeu tohzy no gyrop xiiñ me ni le Jacob no Juaṉ, no bisshiby me, ra me Jesúz ntzoo ni ganab me. ");
INSERT INTO zpg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ra Jesúz leeme: ―¿Bia racladzyiꞌ? Ra me Jesúz: ―Racdadzyaꞌ mbia dmiꞌñaꞌ to gá lad cooy dze-ba gatzooy mdad, to me mbia xlad-drechiꞌ no sto me mbia xlad-ṟeveziꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Were ra Jesúz xiiñ ngüna-rieꞌ: ―¿Beeiyz ndedy laꞌd ni nadz ni dzictedyaꞌ, ni gac beeiy behch ni nlá ni goon lee la? ¿No beeiyz ndedy laꞌd ni ma nadz ni dzictedyaꞌ, ni gac beeiy ni gachôbnihs meññ naa per pur no guîlné la? Ra yâme leeme: ―Beeiyu noꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ra Jesúz leeyâme: ―Ni dzictedyaꞌ no gzacnon lee, ni uli zegahc dzictedy laꞌdu, no ni ma nadz ni dzictedyaꞌ, zegahc dzictedy laꞌdu; per dxu cuia dcoon lad-drech o lad-ṟevez la, dac‑e naa gdee leeu, mazyg dxu ne dTadaꞌ ba nacu xchieñ, wé we ycaꞌ leeu. ");
INSERT INTO zpg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ru bieññ gydiby stzii xmeññ Jesúz nirieꞌ, bydziadzyno yâme Jacob no Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Per pquee Jesúz riedz leeyâme, no ra me: ―Nann laꞌd xnahc nac meññ-guxtisy ni rahc cuent rtzoo mdad lo guiedzylie-rieꞌ; rtzoo yâme no xmeññ yâme gyre mod-ne yâme. No zrieñ xmeññ yâme ni rsahc la, ni rnii yâme, wé rahc. ");
INSERT INTO zpg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Per no laꞌd dac‑e ze gacu; mazyg nitisy dxu de lahd laꞌd gacladzy qysahc la, rahp de ni gac scâsy xmós laꞌd; ");
INSERT INTO zpg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","no nitisy dxu lahd laꞌd gacladzy ma qysahc que zrieñ la, rahp de ni gac scâsy to mós ni byzee par ctzoo xtziiñ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Xtâ naa, Mpyquie-Pshahl Dioz Lee, nehx biaḻaꞌ lo guiedzylie-rieꞌ lehdy gacno meññ naa; mazyg biaḻaꞌ lehdy gacnon leeyâme no gdedyaꞌ dguîlmbahñaꞌ, gatyaꞌ lehdy quixaꞌ gylaa xtahl meññ de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hor-byruu yâme ciuda ni le Jericó, xtahl meññ ziaad no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Uga dxie chohp meññ-ngaḻ coo ñahz; hor-bieññ yâme zidtedy Jesúz, pquee yâme riedz, ne yâme: ―¡Señor, lii ni ziaad de lo xfamily ṟeiy-Davit, bioob noꞌ! ");
INSERT INTO zpg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Meññ-ziaad no Jesúz naꞌ, byduhsh yâme lo ngaḻ yahc lehdy tzudzie, per ngaḻ naꞌ ma rahc yâme rquee yâme riedz, ne yâme: ―¡Señor, lii ni ziaad de lo xfamily ṟeiy-Davit, bioob noꞌ! ");
INSERT INTO zpg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Were güliahz Jesúz, no pquee me riedz ngaḻ yahc, no ra me lee: ―¿Bia racladzy laꞌd ctzon por laꞌd? ");
INSERT INTO zpg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ra yâme Jesúz: ―Señor, psiaḻ noꞌ lehdy gyxal dlo noꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bioob Jesúz leeyâme, no güdan me lo meññ-rieꞌ yahc. No hor-caḻ gahc byxal lo yâme; no za yâme náḻ yâme ru za Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hor-ba gadzihñ yâme gahsh Jerusaléṉ, no bydzihñ yâme ruꞌ to guiedzy-yaañ ni le Betfagé, coo to dahñ ni le Oliv, ugaty ba pshahl Jesúz chohp de lo tzipychop xmeññ me, ");
INSERT INTO zpg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ra me lee: ―Lâ tza guiedzy-yaañ ni dxie ru tedy ziaꞌr nó. Uga güieꞌ laꞌd to burr-ndzaꞌb nliiby maꞌ yahg no xiiñ maꞌ. Lâ cshac leeyâmaꞌ, no guidno laꞌd leeyâmaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","No bâḻ dxuhch ga laꞌd behch, lâ ga leeyâme: “Señor‑e gaquihñ leeyâmaꞌ; luxu cshahl me leeyâmaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Guhcu ze lehdy guhc ni günii profet no ni bzaa me, ru ne me: ");
INSERT INTO zpg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Lâ ga meññ ni nu ciuda-Sioṉ: “Lâ güieꞌ, xṞeiy laꞌd ziaad ru nu laꞌd no guîlndoo, no dziib me to burr, dziib me to burryañ-nguhl, xiiñ to ma-ruu yuu.” ");
INSERT INTO zpg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Güya xmeññ Jesúz, no guhcu mod-ra me leeyâme; ");
INSERT INTO zpg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","güiyno yâme burr-ndzaꞌb no xiiñ maꞌ, no pshob shab yâme chehsh maꞌ; no güdzib Jesúz leemaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","No meññ-xtahl ni ziaad, gatzihly shab yâme lo ñahz ru tedy Jesúz; no zrieñ yâme gachug ṟam-yaañ ni rahp guix, gaguihsh yâmeu lo ñahz zegahc. ");
INSERT INTO zpg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Meññ ni zunier no zegahcu meññ ni náḻ yahc traz, rquee yâme riedz, ne yâme: ―¡Tzuguia mpyquie ni ziaad de lo xfamily ṟeiy-Davit! ¡Nu laꞌy mpyquie ni ziaad porni Dioz pshahl leeme! ¡Tzuguia Dioz ni nu gybaa! ");
INSERT INTO zpg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hor-bydzihñ Jesúz Jerusaléṉ, gyre meññ-nu leññ ciuda rgaꞌ rdoob, no xtahl yâme ne: ―¿Dxu leeme mpyquie-rieꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","No ra lahd yâme: ―Jesúz‑e leeme, profet ni byruu guiedzy-Nasaret ni nu lo ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Güyuꞌ Jesúz leññ idoró, no guzlo güloo me meññ ni gatoꞌ no meññ ni gazii. No ptixguiat me xmiax meññ-rtzee xmedy meññ no xbangü meññ ni rtoꞌ ximbue; ");
INSERT INTO zpg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","no ra me leeyahc: ―Lo Guehtzy ru queꞌ xtiidz Dioz neu: “Diryuꞌn, par gynino meññ naa we gacu”; per laꞌd gatzoo laꞌdu beeiy ru riungaꞌdzy meññ-gübaan. ");
INSERT INTO zpg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","No gübigy meññ-ngaḻ no meññ-ndang ru zu Jesúz leññ idoró, no psiaḻ me leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Per hor-bwieꞌ xjefy yahc bahl no muextr ni ruuḻ yahc xleiy Moiséz gyre xroꞌ cos ni rtzoo Jesúz, no hor-bieññ yâme gaquee mbiux riedz leññ idoró, ne: “¡Tzuguia mpyquie ni ziaad de lo xfamily ṟeiy-Davit!”, bydziaꞌdzy yâme, ");
INSERT INTO zpg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","no ra yâme Jesúz: ―¿Rieññiꞌ ni ne mbiux-wé yahc la? Ra Jesúz leeyâme: ―Rieññaꞌ. Naꞌz laꞌd, ¿nehx ruuḻ laꞌd ni ganii lo Guehtzy ru queꞌ xtiidz Dioz de nirieꞌ la, ru neu: Xtâ mbiux-yaañ no mdoo guuḻ yâme lehdy cuguia yâme Dioz? ");
INSERT INTO zpg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Luxu psaꞌn Jesúz leeyâme, byruu me ciuda-wé, no za me guiedzy-Betania, no uga bydzie me. ");
INSERT INTO zpg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ni byre guiaal, byruu Jesúz uga, za me Jerusaléṉ gyzac no guzlo galahn me. ");
INSERT INTO zpg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","No bwieꞌ me to yag-duug coo ñahz, no güya me ru zuw, per nehx bydzial me duug lou, xguie guix dziib lou. Were ra me yag-duug: ―¡Ba nehx ziuꞌr dze-yqueꞌ duug loꞌy! No gübihdzy gahcu. ");
INSERT INTO zpg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hor-bwieꞌ xmeññ me nirieꞌ, ptzunadz yâme no ra yâme Jesúz: ―¿Bia mód ngueeḻy gahc gübihdzy yag-duug? ");
INSERT INTO zpg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, bâḻ rlíladzy laꞌd, no nehx rqueꞌladzy laꞌd mbehty la, nehx nunzy ni ptzon no yag-duug ntzoo laꞌd, mazyg zegahc beeiy ña laꞌd dañ-rieꞌ: “Byruu de wé no biahb lo nisdoo”, no ñahcu ze. ");
INSERT INTO zpg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","No gyre ni gnab laꞌd hor-ganino laꞌd Dioz la, zdee meu laꞌd bâḻ rlíladzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Byluxu güyuꞌ Jesúz leññ idoró, no hor-galuu me meññ, xjefy yahc bahl no zrieñ mînguhl yahc ni nac guxtisy lahd meññ-Isṟael, gübigy yâme no ra yâme leeme: ―¿Dxu naquiꞌ par ctzooy gyre nirieꞌ? ¿No dxu guhdzy lii ctzooyu? ");
INSERT INTO zpg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ra Jesúz leeyâme: ―Naa zegahc rapaꞌ to ni gnabdiidzaꞌ laꞌd; no bâḻ ga laꞌd naa xnahc leeu la, naꞌ gapyaꞌ laꞌd dxu nacaꞌ par ctzon gyre nirieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Dxu pshahl Juaṉ lehdy bidchôbnihs me meññ? ¿Dioz ni nu gybaa la, o cuentz meññ? Guzlo gaya saꞌ yâme: ―¿Biaz‑e naꞌ ga nó leeme? Bâḻ nó ga nó Dioz pshahl Juaṉ, za me nó: “¿Biaz nacu naꞌ di nlíladzy laꞌd leeme?” ");
INSERT INTO zpg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","No bâḻ ga nó, cuentz meññ pshahl leeme, ndzieeby gyruu meññ-guiedzy dchehsh nó; porni ne yâme Juaṉ, profet‑e leeme ni günii ni gu Dioz lee. ");
INSERT INTO zpg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Leewe ra yâme Jesúz: ―Nehx nann noꞌ. Were ra Jesúz leeyâme: ―Zegahc naa nehx zapyaꞌ laꞌd dxu nacaꞌ par ctzon gyre nirieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Günabdiidz Jesúz leeyâme, ra me: ―¿Bia ne laꞌd lguia nirieꞌ? To mpyquie rahp chohp xiiñ me, no ra me to de leeyâme: “Shiꞌñ, tzaꞌy dzêrieꞌ dzictzooy dziiñ lo lyu ru bdzibaꞌ blatzy.” ");
INSERT INTO zpg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ra xiiñ me leeme: “¡Nehx neu naa tzan!” Per luxu gyzac ne xiiñ me: “Beeiydí tzan ru gashahl dtadaꞌ naa”, no za me. ");
INSERT INTO zpg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Gyzac ra mpyquie-caḻ sto xiiñ me mod-wé gahc. No wé ra leeme: “Yo, dad, naa tzan.” Per luxu, di ña me. ");
INSERT INTO zpg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Dxu de lo gyrop yâme ptzoo ni ne xtad? Ra yâme Jesúz: ―Ni ra me nier lee. Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, meññ-rcuquix mpuezd no meññ-ngünaa yahc ni nehx rahp tohzy mpyquie, ma ngueeḻy ziuꞌ yâme ru rtzoo Dioz mdad que laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porni Juaṉ ni rchôbnihs bidluu me laꞌd ni nac xñahzû, per di nlíladzy laꞌd mod-ra me laꞌd. Per meññ-rcuquix mpuezd no ngüna-rieꞌ yahc ni nehx rahp tohzy mpyquie, bylíladzy yâme no ptzoo yâme mod-ra Juaṉ leeyâme. Per laꞌd naꞌ, nîcze bwieꞌ laꞌd nirieꞌ, di ne laꞌd ctzee mod-nac laꞌd no di nlíladzy laꞌd xtiidz Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Lâ guieññ sto ni gynin ndaagü lo diidz: Güyuꞌ to xbixwaan to lyu-ro, bdziib me blatzy lo xilyu me, no ptahgü me guingybiu; luxu güdahñ me to guieryu ru gyxii blatzy, no bzaa me beeiy to yuꞌ ni nsuu lehdy ycuniꞌ xmeññ me ru gayahc dziiñ. ’No luxu bdee me lyu-rieꞌ zrieñ meññ-ctzoo dziiñu por glaꞌy, no leeme za me to ru ziht. ");
INSERT INTO zpg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Dze-ba gayahc xicüsech blatzy‑e naꞌ, pshahl me chohp tzonn xmós me, ziycaꞌ ni ctzulaꞌy yâme de lo cüsech ru nu meññ-caḻ yahc ni gatzoo dziiñ. ");
INSERT INTO zpg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per meññ-gatzoo dziiñ lo lyu-rieꞌ naꞌ, aaḻ pquelo yâme mós yahc, güdihñ yâme to me, sto me bgaꞌdy yâme lee, no sto me guznáḻ yâme lee no guie. ");
INSERT INTO zpg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Gyzac pshahl xbixwaan lyu ma xtahl mós que ni güya nier; per gyzac mod-wé gahc guhc yâme. ");
INSERT INTO zpg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’No luxu pshahl xbixwaan lyu-rieꞌ merp xiiñ me, porni ne me: “Stzoo yâme ni gynii me porni dshiñaꞌ leeme.” ");
INSERT INTO zpg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per hor-bwieꞌ meññ-caḻ ni gatzoo yahc dziiñ ziaad xiiñ xbixwaan lyu, ra saꞌ yâme: “Mpyquie-ziaad, leeme we ni guian-no gyrenac dziiñ dze-ba guhty xtad me; igaꞌdy nó leeme lehdy gac dixchieñ nó gyreu.” ");
INSERT INTO zpg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Were günahzy yâme leeme, güloo yâme leeme leññ lyu ru dziib blatzy, no bgaꞌdy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Were ra Jesúz leeyâme: ―Dze-guibyguiat xbixwaan lyu-caḻ, ¿bia ctzoo me no meññ-rieꞌ yahc ni gatzoo dziiñ lo xilyu me? ");
INSERT INTO zpg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ra yâme Jesúz: ―Ba nehx nu guîlrioob, gaty meññ-rieꞌ yahc ni nac meññ-dirquihñ, no gdee xbixwaan lyu-wé xtziiñ me zrieñ meññ ni gdee ni ctzulaꞌy yâme de cad cüsech. ");
INSERT INTO zpg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","No ra Jesúz leeyâme: ―¿Dgueññ guuḻ laꞌd lo Guehtzy ru queꞌ xtiidz Dioz la?, ru neu mod-rieꞌ: Guie ni di ne meññ-rzaa yuꞌ nquihñ, naꞌ lehbu ba nash squiñp ru raa guie ni ma rquihñ lehdy tzaa yuꞌ zaꞌgndzi. Dioz ni rtzoo mdad, leeme we ptzoo leeu, no gatzunadz nó rwieꞌ nó leeu. ");
INSERT INTO zpg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","No leewe racdadzyaꞌ gann laꞌd, ba nehx beeiy tzu laꞌd ru rtzoo Dioz mdad; ba zrieñ meññ‑e tzu ni zidguiahc beeiy meññ-rdee ni nac xchieñ cad cüsech xbixwaanu. ");
INSERT INTO zpg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","No de guie naꞌ ni ganii nó, dxu guiahb chehshu la, stzubiuw lee; no bâḻ leeu guiahbu chehsh dxuhch, dé we ctzoou lee. ");
INSERT INTO zpg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hor-bieññ xjefy yahc bahl no zrieñ meññ-nac yahc fariseu nirieꞌ ni günii Jesúz ndaagü lo diidz, gunn yâme de leeyâme ganii me. ");
INSERT INTO zpg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Gucladzy yâme nnahzy yâme leeme, per rdzie yâme porni meññ-guiedzy ne yâme Jesúz profet‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Gyzac ganii Jesúz ndaagü lo diidz, ra me leeyâme: ");
INSERT INTO zpg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Mod-rtzoo Dioz ni nu gybaa mdad zidguiahcu beeiy to ṟeiy ni ptzoo xguîltziahl xiiñ. ");
INSERT INTO zpg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pshahl me xmós me zigyne meññ-ba psieññ me lee par guiaad; per leeyâme naꞌ di ne yâme ña ru gac guîltziahl. ");
INSERT INTO zpg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Gyzac pshahl me zrieñ xmós me, no ra me lee: “Lâ ga meññ-ba psieññaꞌ leeyahc, guîlrahgü ba nu puexd. Ba bityaꞌ yuhz ni rap yahcaꞌ no zrieñ maꞌ ni ma nro, gyreu ba nu puexd. Lâ ga leeyâme guiaad yâme.” ");
INSERT INTO zpg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per nehx ptzucas meññ-psieññ me leeyahc. To yâme za ruꞌ xilyu, sto me za zictoꞌ, ");
INSERT INTO zpg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","no zrieñ yâme günahzy xmós ṟeiy, ptzoo psahc yâme xtâ no biꞌdy yâme leeyahc. ");
INSERT INTO zpg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Niwé bwieꞌ ṟeiy, bydziaꞌdzy me no pshahl me xsoldad me biygaꞌdy meññ-dirquihñ ni biꞌdy meññ-rtzoo ximdad me no pquee gue gyre yuꞌ ni nu xguiedzy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Luxu ra me zrieñ xmós me: “Ba gyreu nu puexd par sulo guîltziahl, per meññ-psieññaꞌ leeyahc, ba dac‑e leeyâme ni rquihñ guiaad. ");
INSERT INTO zpg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lâ tza lo ñahz ru ma rdedy meññ, no lâ csieññ nitisy dxu güieꞌ laꞌd lee par guiaad yâme.” ");
INSERT INTO zpg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Byluxu za mós lo ñahz no bidno yâme gyre meññ-bwieꞌ yâme lee, meññ-tziaawy yahc no meññ-dirquihñ; no mod-wé bydzeꞌ xiryuꞌ ṟeiy de meññ. ");
INSERT INTO zpg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Per hor-güyuꞌ ṟeiy zigüieꞌ me meññ-ba nu yahc leññ yuꞌ, tohzy bwieꞌ me to mpyquie-nehx nutz zâ gahc lar-nutz zrieñ yâme par lo guîltziahl. ");
INSERT INTO zpg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Were ra me lee: “Mígü, ¿bia mód güyuꞌy neꞌ no nehx nutziꞌ zâ gahc lar-nutz meññ-nu yahc neꞌ par lo guîltziahl?” Per mpyquie ni nutz cuentz lahr nehx günii mbehty. ");
INSERT INTO zpg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Luxu ra ṟeiy meññ-gayacno: “Lâ glihby nieꞌ me no ña me, no lâ gráḻ leeme lo guibcawy stziuꞌ; uga guun me lé gahgü laiy me. ");
INSERT INTO zpg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Porni xtahl meññ‑e rqueꞌ riedz lee, per uxiee yâme gybee.” ");
INSERT INTO zpg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Byluxu güya meññ-nac yahc fariseu, no ptzoo yâme diidz gyo yâme xnahc csiahb yâme Jesúz no to ni nnii me. ");
INSERT INTO zpg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","No mod-wé pshahl yâme chohp tzonn xmeññ yâme, tohzy no zrieñ xmeññ Herody, bydzihñ yâme, ra yâme Jesúz: ―Muextr, noꞌ nann noꞌ gyre ni rniiy, ni uli we leeu, no rluuy ni uli lguia ni racladzy Dioz ctzoo meññ, no nehx rlabyiꞌ ni ne meññ; porni nehx rwieꞌy meññ nunzy de xtziguia. ");
INSERT INTO zpg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Leewe gu noꞌ bia neꞌy: ¿Xñahzu we quix noꞌ mpuezd lo xṟeiy meññ-Ṟom la, o yac? ");
INSERT INTO zpg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per Jesúz nann me guîlrieñ-nahcsy ni ziyno meññ-wé yahc, ra me leeyâme: ―Laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu, ¿bia nacu riñlo laꞌd csiahb laꞌd naa no to ni ngann? ");
INSERT INTO zpg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Lâ gluu naa medy-rguix laꞌd mpuezd. Were bluu yâme leeme to xmedy-guiib meññ-Ṟom. ");
INSERT INTO zpg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ra Jesúz leeyâme: ―¿Dxu lo we nirieé, no dxu le queꞌ neé? ");
INSERT INTO zpg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ra yâme leeme: ―Xchieñ Cézr ni nac xṟeiy meññ-Ṟom. Ra Jesúz leeyâme: ―Lâ gdee Cézr ni nac xchieñ Cézr, no lâ gdee Dioz ni nac xchieñ Dioz. ");
INSERT INTO zpg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hor-bieññ yâme günii Jesúz ze, ptzunadz yâme; no luxu byruu yâme ru zu Jesúz, no za yâme. ");
INSERT INTO zpg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dze-wé gahc, güya meññ-nac yahc saduceu ru nu Jesúz; no meññ-rieꞌ yahc ne yâme nehx zbahñ mînguty; no günabdiidz yâme leeme, ");
INSERT INTO zpg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ra yâme: ―Muextr, Moiséz bzaa me lo leiy, ne me: “Bâḻ to mpyquie rehty me no riaꞌn tziahl me sinn gap xiiñ la, behtzy gahcme guidzña no ngüna-rieꞌ lehdy gap xiiñ yâme xcuent behtzy me ni guhty.” ");
INSERT INTO zpg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Naꞌ hôrrieꞌ, güyuꞌ gahdzy meññ-mpyquie dlahd noꞌ behtzy saꞌ yâme; ni nac lguhl lahd yâme bidzña me, per guhty me; gumm nehx güdahp xiiñ me, leewe bidzña behtzy me no ngünaa ni guhc tziahl me. ");
INSERT INTO zpg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","No zegahcu ni byrohp yâme, no ni bionn yâme, no ze glo byzaꞌ gydiby gahdzy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","No luxu, zegahc guhty ngüna-wé. ");
INSERT INTO zpg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Naꞌz naꞌ, dze-gybahñ mînguty, ¿dxu de lo gahdzy mpyquie-rieꞌ yahc gac tziahl ngüna-wé, porni gyre yâme bidzña no leeme? ");
INSERT INTO zpg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Were ra Jesúz leeyâme: ―Nehx xñahzu ni ne laꞌd, porni nehx rzaclo laꞌd ni ne lo Guehtzy ru queꞌ xtiidz Dioz, no nehx nann laꞌd gyre mod-beeiyu Dioz. ");
INSERT INTO zpg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Porni dze-gybahñ mînguty, ba nehx zidzña meññ no nehx zdee meññ guîltziahl xiiñ, mazyg gac yâme beeiy x‑ángel yahc Dioz ni nu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Per lguia ni gybahñ mînguty, ¿dgueññ guuḻ laꞌd ni ba gu Dioz gahc laꞌd la? Ne me: ");
INSERT INTO zpg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Naa we xDioz Braṉ, Isac no Jacop ni güyuꞌ yahc ba xtze.” No Dioz, dac‑e xDioz mînguty leeme, mazyg xDioz meññ-mbahñ‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hor-bieññ meññ ni günii Jesúz, rtzunadz yâme mod-rluu me meññ. ");
INSERT INTO zpg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Hor-bieññ meññ-nac yahc fariseu ba di ndzial meññ-nac yahc saduceu ni ña yâme Jesúz, bydohp yâme; ");
INSERT INTO zpg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","no to lahd yâme nac muextr ni nann xleiy Moiséz zaꞌgndzi; bignabdiidz me Jesúz lehdy güieꞌ me bia ga leeme no lehdy nsiahb me lee no to ni ngann, ra me lee: ");
INSERT INTO zpg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Muextr, de gyre ni rtzoo Dioz mdad ctzoo nó ni ne lo leiy la, ¿bia ma rsahc lahdu? ");
INSERT INTO zpg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ra Jesúz leeme: ―“Bzacbeeiy Dioz ni rtzoo mdad lii no gydo xguîlmbahñiꞌ, no gydo x‑almiꞌ, no gydo xguîlriehñiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nirieꞌ we ni nier gahc lee, no ni ma rsahc lahd ni rtzoo Dioz mdad ctzoo meññ. ");
INSERT INTO zpg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","No ni byrohpu beeiy gahc nirieꞌ: “Bintzi zâ-bynechiꞌ mod-ndzi gahquiꞌ lii.” ");
INSERT INTO zpg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Gyrop nirieꞌ yahc ni rtzoo Dioz mdad ctzoo meññ, leeu we ni nguña gyre ni ne lo leiy ni bzaa Moiséz no ni rluu yahc gyre profet. ");
INSERT INTO zpg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Zu ziaꞌ meññ-nac yahc fariseu, günabdiidz Jesúz leeyâme, ");
INSERT INTO zpg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ra me: ―¿Bia rnii leññ ihqy laꞌd lguia Crist? ¿Dxu xiiñ leeme? Ra yâme leeme: ―Xiiñ ṟeiy-Davit. ");
INSERT INTO zpg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ra Jesúz leeyâme: ―¿Bia nacu naꞌ bisnii xiSpirt Dioz Davit lehdy gynii me de Crist “Señor ni rtzoo mdad”? Porni Davit gahc ne: ");
INSERT INTO zpg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Günii Dioz, ra me Señor ni rtzoo mdad naa: “Gürie dcoon lad-drech, xtâ glo ctzon gyre meññ-rdziadzyno lii, guisshiby yâme loꞌy.” ");
INSERT INTO zpg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Leewe, bâḻ Davit ra leeme: “Señor ni rtzoo mdad”, ¿bia mód naꞌ ne meññ xiiñ Davit‑e Crist? ");
INSERT INTO zpg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","No ba ndruhty de meññ-rieꞌ di ñaḻ ña yâme Jesúz mbehty, no glohdy dze-wé bydzie yâme nnabdiidzr yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Byluxu ra Jesúz meññ-gayieññ ni ganii me no xmeññ me zegahc: ");
INSERT INTO zpg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, rluu yâme meññ bia rnii xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","No leewe, lâ gzoob xtiidz yâme no lâ ctzoo ni ga yâme laꞌd; per di ctzoo laꞌd mod-rtzoo yâme, porni gydze ni rluu yâme no gydze ni rtzoo yâme. ");
INSERT INTO zpg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Riñlo yâme ctzoo zrieñ meññ gyre ni ngann ni queꞌ lo leiy, ni nac yahc beeiy yu-naꞌy ni rlihby yâme ñuu meññ; luxu di ne yâme canu, nîcze no to ñabiu yâme, lehdy ñacno yâme ñahc mod-neu. ");
INSERT INTO zpg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Rtzoo yâme ni mos lehdy güieꞌzy meññ; rlihby yâme ruꞌ lque yâme no lo xihcü yâme cajyañ-guiedy ni nu guehtzy leññ ni güyaa xtiidz Dioz lo, no rtzuxlahg yâme leeu; no rtzunduhñ yâme xinday lahr ni ruhtz yâme. ");
INSERT INTO zpg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","No ryo yâme ru rbia meññ-ma rsahc ru rotzie yâme no meññ, no mod-wé gahc rtzoo yâme hor-riuꞌ yâme leññ idoo. ");
INSERT INTO zpg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","No hor-ganzeꞌ yâme leññ guiedzy, racladzy yâme gynii meññ diux leeyâme no xroꞌ guîlrzacbeeiy, no riuꞌladzy yâme ga meññ leeyâme: “Muextr.” ");
INSERT INTO zpg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Per laꞌd, di gyo laꞌd ga meññ laꞌd “Muextr”; porni rahp laꞌd nunzy to Muextr, lee we Crist, no gyre laꞌd‑e zidguiahc beeiy tohzy family. ");
INSERT INTO zpg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","No di ga laꞌd cuentz meññ “dad”, porni tohzy Dad‑e rahp laꞌd, ni nu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na di gyxilyno laꞌd ga meññ ma nann laꞌd; porni rahp laꞌd to Muextr ni ma nann, leeme we Crist. ");
INSERT INTO zpg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dxu lahd laꞌd ma rsahc, wé we ni gac beeiy to xmós laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Porni dxu rguguia leegahc, wé nehx zguguia ndruhty lee; no dxu nehx rguguia leegahc, wé we tzuguia. ");
INSERT INTO zpg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Baazy dzii de laꞌd, muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu!, porni nehx rdee laꞌd ñahz tzu meññ ru rtzoo Dioz mdad; no luxu, ni laꞌd gahc di ne tzu, no di ne laꞌd tzu zrieñ meññ ni riuꞌladzy. ");
INSERT INTO zpg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Baazy dzii de laꞌd, muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu!, porni rboo laꞌd xyuꞌ ngünaviud, no sto lad ba zu laꞌd ruuḻ laꞌd laꞌy xtze, rluuw ulihbu meññ-tziaawy laꞌd; no por leeu ma xroꞌ guîlné ycaꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Baazy dzii de laꞌd, muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu!, porni ria laꞌd byzaꞌzy ru nu meññ, lé rdedybish laꞌd nisdoo, rigyo laꞌd meññ ni gluu laꞌd lee lehdy gylíladzy yâme mod-rlíladzy laꞌd; no hor-ba ptzoo laꞌd gan nîcze to lahd yâme, ba rtzoo laꞌd leeme chohp vuelt ma meññ-dirquihñ ni tza infiern beeiy gahc laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Baazy dzii de laꞌd, zidguiahc laꞌd beeiy ngaḻ ni ne gluu meññ ñahz!, ne laꞌd: “Dxu ycahbyladzy behch por idoró, no di ctzoo me leeu, nehx nacu mbehty; per dxu ycahbyladzy behch por or ni nu leññ idoró, wé we rahp de ni ctzoo ni ba günii.” ");
INSERT INTO zpg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Laꞌd‑e meññ-waty no ni zidguiahc beeiy meññ-ngaḻ! ¿Bia leeu ma rsahc: or la, o idoró ni por lee racnda or? ");
INSERT INTO zpg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","No ne laꞌd zegahc: “Dxu ycahbyladzy behch por ltar, no di ctzoo me leeu, nehx nacu mbehty; per dxu ycahbyladzy behch por gun ni rdee meññ lo ltar la, wé we rahp de ni ctzoo ni ba günii.” ");
INSERT INTO zpg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Laꞌd‑e meññ-waty no ni zidguiahc beeiy meññ-ngaḻ! ¿Bia leeu ma rsahc: gun la, o ltar ni por lee racnda gun? ");
INSERT INTO zpg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ren laꞌd dxu rcahbyladzy behch por ltar, nehx rnii me gacu nunzy por ltar, mazyg zegahc por gyre ni dxie lo ltar; ");
INSERT INTO zpg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","no dxu rcahbyladzy por idoró, dac‑e nunzy por idoró rnii yâme gacu, mazyg zegahc rnii yâme gacu por Dioz, ni nu leññ idoró; ");
INSERT INTO zpg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","no dxu rcahbyladzy por gybaa, zegahc rnii yâme gacu porni nacu ru dxie Dioz, no rcahbyladzy yâme por Dioz zegahc ni dxie lgar-wé. ");
INSERT INTO zpg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Baazy dzii de laꞌd, muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, laꞌd‑e ni ne meññ-tziaawy lee nîcze nehx uliu!, porni rdee laꞌd gun par Dioz de lo tzii cuib de ni rtoꞌ laꞌd biatxteḻy, aníz, no comin, no luxu di rtzoo laꞌd ni ma rsahc ni ganii Dioz lo leiy: Ntzoo laꞌd ni nac xñahzû, ñoob laꞌd nyug, no nlíladzy laꞌd Dioz. Wé we racladzyu ctzoo laꞌd sinn di csaꞌn laꞌd stohbyu. ");
INSERT INTO zpg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Zidguiahc laꞌd beeiy ngaḻ ni ne gluu meññ ñahz, per luxu rxan rtzoo laꞌd! Zidguiahcu beeiy ni mboo laꞌd to mbiuhx lo xguîlroo laꞌd, per luxu ráhby laꞌd to camell. ");
INSERT INTO zpg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Baazy dzii de laꞌd, muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu!, porni zidguiahc laꞌd beeiy vas no blad ni nyar nunzy chehsh, per luxu leññ xguîlmbahñ laꞌd beedyu porni bydzeꞌu gyrehzy guîlgübaan no guîlrzîbyladzy. ");
INSERT INTO zpg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseu ni nac beeiy ngaḻ! Lâ quiiby nier leññ xguîlmbahñ laꞌd ni zidguiahc beeiy vas no blad, no mod-wé were zacnye laꞌd de lguia zegahc. ");
INSERT INTO zpg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Baazy dzii de laꞌd, muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu!, porni zidguiahc laꞌd beeiy baa ni bydiꞌ nquitzy, mos chehshu, per luxu leññu bydzeꞌ xdziht mînguty no zrieñ ni nadz yahc. ");
INSERT INTO zpg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ze we nac laꞌd; xtziguia rluuw meññ-tziaawy laꞌd, per leññ xguîlmbahñ laꞌd bydzeꞌ guîlrisquiee no ni dirquihñ. ");
INSERT INTO zpg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Baazy dzii de laꞌd, muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu!, porni rzaa laꞌd xbaa profet yahc, no ristziaawy laꞌd xyuꞌ xbaa meññ ni guhc meññ-tziaawy ba xtze, ");
INSERT INTO zpg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","no luxu ne laꞌd: “Bâḻ ñahc ba nu nó tzcaḻ dze-güyuꞌ dmeññ nó ni güyuꞌ ba xtze la, nehx ñacno nó leeyâme dze-biꞌdy yâme profet yahc.” ");
INSERT INTO zpg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","No leewe, mod-wé laꞌd gahc rdee diidz de lo xfamily meññ-bgaꞌdy profet yahc‑e ziaad laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Were naꞌ, ¡lâ guistibylgaa ni guzlo gatzoo xmeññ laꞌd ni güyuꞌ ba xtze! ");
INSERT INTO zpg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Meññ-dirquihñ laꞌd, zidguiahc laꞌd beeiy mbaḻbeedzy! ¿Bia mód‑e gylaa laꞌd de lo xguîlnadz infiern ni ziaad? ");
INSERT INTO zpg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","No leewe cshaalaꞌ profet ru nu laꞌd, no meññ-nann, no muextr. Per laꞌd zgaꞌdy laꞌd lahd yâme, no squee laꞌd lahd yâme lo cruzy, no zrieñ yâme stzuné laꞌd lee leññ idoo, no zgultihp laꞌd lee de to guiedzy no sto guiedzy. ");
INSERT INTO zpg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","No leewe, no gahc laꞌd quix ni bgaꞌdy yâme meññ-tziaawy ni güyuꞌ yahc ba xtze, xtâ dze-guhty to mpyquie-ptzoo ni nac xñahzû ni güyu-le Abel no xtâ dze-guhty Sacaríaz xiiñ Berequíaz, ni biꞌdy laꞌd lee ruꞌ idoró gahsh ruꞌ ltar ru rqueꞌ gue maꞌ ni rdee yâme gun par Dioz. ");
INSERT INTO zpg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gapyaꞌ laꞌd ni uli, meññ-nu ni naꞌ, wé we ni quix gyreu. ");
INSERT INTO zpg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Baazy dzii laꞌd, meññ-Jerusaléṉ! Laꞌd rgaꞌdy laꞌd profet yahc, no rshadguie laꞌd meññ-rshahl Dioz lee par ñu diidz no laꞌd. ¡Xtahl vuelt gucdadzyaꞌ ntopaꞌ gyre laꞌd, beeiy rtohp nguiedy xiiñ leññ shiily, per di ñacladzy laꞌd! ");
INSERT INTO zpg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Naꞌ lâ güieꞌ, xiryuꞌ laꞌd, ziaꞌnu lehzyu; ");
INSERT INTO zpg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","porni gapyaꞌ laꞌd, glohg hôrrieꞌ ba nehx zwieꞌr laꞌd naa mazy, xtâ glo gynii laꞌd: “¡Nu laꞌy mpyquie ni ziaad porni Dioz pshahl leeme!” ");
INSERT INTO zpg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hor-byruu Jesúz idoró no ba tza me, gübigy xmeññ me leeme, gatzunadz yâme gyre yuꞌ ni nac xchieñ idoró. ");
INSERT INTO zpg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Per ra Jesúz leeyâme: ―¿Rwieꞌ laꞌd gyre niwé yahc la? Gapyaꞌ laꞌd ni uli, ni to guie di ziaꞌn chehsh sto guie. Gyreu we zdiñguie. ");
INSERT INTO zpg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hor-dxie Jesúz chehsh dañ-Oliv, gübigy gahc xmeññ me, no ganabdiidz yâme leeme hor-ba lehzy yâme, ra yâme leeme: ―Gu noꞌ buc gac nirieꞌ. ¿No bia señal güieꞌ noꞌ ni gdee diidz de ni guibyguiatiꞌ no de ni gynihty guiedzylie-rieꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ra Jesúz leeyâme: ―Gax lâ gann, na di guisquiee ndruhty laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porni siahd xtahl meññ-gaquihñ dlen, no gynii yâme leeyâme we nac Crist; no modé zisquiee yâme xtahl meññ. ");
INSERT INTO zpg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Zieññ laꞌd ba gadeḻy meññ byzaꞌzy; per di gydzie laꞌd, porni rahpu de ni gacu ze; per dac ziaꞌr‑e ba dzigynihty guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Porni to guiedzy zdeḻy no sto guiedzy, no to gobiern zdeḻy no sto gobiern; no ziuꞌ guîlguihdz no ziuꞌ guîlrlahn, no zahc xu byzaꞌzy. ");
INSERT INTO zpg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Per gyre nirieꞌ gac dze-ba sulo gac gyrehzy ni nadz. ");
INSERT INTO zpg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’No steedy yâme laꞌd lo ña meññ-ctzoo csahc laꞌd, no zgaꞌdy yâme laꞌd, no gydo-bynac lo guiedzylie zdziadzyno meññ laꞌd porni nac laꞌd dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Dze-wé yahc xtahl meññ ni rlíladzy xtiidz Dioz ziatrxan, no zdee saꞌ yâme lo ña zrieñ meññ, no zdziadzyno saꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","No ziuꞌ xtahl meññ-mbuxter gynii lee nac profet, no zisquiee yâme xtahl meññ. ");
INSERT INTO zpg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Stzoo meññ-xtahl ni dirquihñ, no leewe xtahl meññ ba nehx zîntzi saꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per dxu rtibladzy xtâ glo gydibylgaa gyreu, wé we zlaa de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","No dzigyuno meññ dtiidzaꞌ gyre meññ gydo lo guiedzylie lehdy gann yâme mod-rtzoo Dioz mdad; no were ba gynihty guiedzylie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’No leewe, ru güieꞌ laꞌd to xroꞌ ni nahcsy ni rniꞌdy, no zuw ru nda leññ idoró, lee we de ni günii profet-Daniel ba xtze (dxu ruuḻ guetzy-rieꞌ, guuḻu lehdy gann), ");
INSERT INTO zpg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","were gyre meññ ni nu lo ṟegioṉ-Judea gxuunn yâme, gybiꞌ yâme guehsh. ");
INSERT INTO zpg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","No dxu dziib ihqy yuꞌ, di guiaht me ycaꞌ me behch leññ yuꞌ; ");
INSERT INTO zpg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","no dxu gatzoo dziiñ lo lyu, di guibyguiat me ruꞌ yuꞌ lehdy ycaꞌ shab me. ");
INSERT INTO zpg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Baazy dzii meññ-ngünaa ni nu de xcuidad o caꞌ mdo-yaañ leññ dze-wé yahc! ");
INSERT INTO zpg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lâ gnab lo Dioz di gac nirieꞌ yahc lo tiemp-naḻ o gacu dze-risladzy meññ, lehdy beeiy gxuunn laꞌd ngueeḻy; ");
INSERT INTO zpg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","porni xroꞌ guîlrzacno we gac dze-wé yahc, ni nehx ba güyuꞌ dzé guhc glo dze-güyaa guiedzylie, no ba nehx ziuꞌ dzé gacru. ");
INSERT INTO zpg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","No bâḻ Dioz nehx ntzundop me dze-wé yahc ni gac xroꞌ guîlrzacno la, nehx nlaa ndruhty; per por xmeññ me ni güle me leeyahc, ctzundop meu. ");
INSERT INTO zpg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’No bâḻ dxuhch ga laꞌd: “Lâ güieꞌ, mpyquie-nac Crist, leexme nu neé”, o “Lâ güieꞌ, leexme nu nuú”, di gylíladzy laꞌd ni ne yâme. ");
INSERT INTO zpg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porni siahd meññ ni ga lee nac Crist, o ga lee nac profet, per nehx uliu; no stzoo yâme xroꞌ ni ngann yahc no zrieñ guîlrtzunadz, lehdy guisquiee yâme, bâḻ beeiyu, xtâ meññ ni ba güle Dioz lee. ");
INSERT INTO zpg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ba gahc gayapyaꞌ laꞌd‑e ni dziguiahc. ");
INSERT INTO zpg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","No leewe, bâḻ ga meññ laꞌd: “Lâ güieꞌ, Crist nu lo yu-bihdzy”, na tza laꞌd; o ga yâme laꞌd: “Lâ güieꞌ, leeme nungaꞌdzy neꞌ leññ yuꞌ”, na di gylíladzy laꞌdu. ");
INSERT INTO zpg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porni beeiy to xgue ngüziee we ni gydahl ru rlahñ ncübidz no guieññu xtâ ru riaaz ncübidz, ze we gacu dze-naa, Mpyquie-Pshahl Dioz Lee, guibyguiataꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Rutisy nash cuerp-guty, wé we rdohp deedy. ");
INSERT INTO zpg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Scâsy tedy ni gzacno meññ dze-wé yahc, zacncawy ncübidz no nehx zguꞌ mboo byniꞌ, no ziahb mbial yahc de leññ gybaa, no zniꞌby gyre ni nu leññ gybaa. ");
INSERT INTO zpg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","No zieññ señal leññ gybaa lehdy gann meññ naa, Mpyquie-Pshahl Dioz Lee, guiaḻaꞌ; no gyre lo clasy meññ-nu lo guiedzylie zuun no xroꞌ né, no lóni guiaḻaꞌ lo zá, zwieꞌ yâme beeiyu naa gyreu no zidnon guîlbyni-ro. ");
INSERT INTO zpg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","No cshaalaꞌ d‑ángel yahcaꞌ ni yquee trompet lehdy gydohp gyre meññ ni güleꞌn lee byzaꞌzy lo guiedzylie, xtâ ru rruu gydap mbeꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Lâ gyzeedy nirieꞌ ni rahc no yag-duug: Dze-ba ziaad guix-yaañ lou la, ba nann laꞌd tiempleꞌñ‑e gadziñgahsh. ");
INSERT INTO zpg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","No mod-wé gahc‑e, dze-ba rwieꞌ laꞌd gayahc gyre nirieꞌ, lâ gann gadziñgahsh dze-guiaḻaꞌ, beeiy ni ba zuun ruꞌ puert. ");
INSERT INTO zpg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gapyaꞌ laꞌd ni uli, gyre nirieꞌ gac antzy ni gaty meññ-nu yahc ni naꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Zdedy gybaa no guiedzylie, per ni ganin nehx zdedyu. ");
INSERT INTO zpg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Per dzé no hór ni gac nirieꞌ yahc, ndruhty nehx nann, ni ángel yahc ni nu gybaa; nunzy dTadaꞌ, wé nann buc gacu. ");
INSERT INTO zpg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Beeiy gahc guhc dze-güyuꞌ Noé, zegahc‑e gac dze-guibyguiataꞌ, naa Mpyquie-Pshahl Dioz Lee. ");
INSERT INTO zpg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tzcaḻ antzy ni gac guio-ro, no xtâ dze-güyuꞌ Noé leññ arc ni bzaa me, nu meññ yahc gayahgü, gayoo, gayidzña, no gatzoo xguîltziahl xiiñ; ");
INSERT INTO zpg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","no lóhbni nehx nu ihqy yâme mbehty, guzlo guio-ro no bniꞌdyu gyre yâme. No mod-wé gahc gacu dze-naa, Mpyquie-Pshahl Dioz Lee, guibyguiataꞌ lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lo hor-wé chohp mpyquie zu lo camp; to me tza, sto me guiaꞌn. ");
INSERT INTO zpg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chohp ngünaa gayuꞌd tohzy; to me tza, sto me guiaꞌn. ");
INSERT INTO zpg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’No leewe ren laꞌd, gax lâ güieꞌ, porni nehx nann laꞌd pór guibyguiataꞌ, naa ni rtzoo mdad laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Per lâ guieññ ni dziguiapyaꞌ laꞌd: Bâḻ xbixwaan to yuꞌ ñann me pór ñahd gübaan guiaal la, mbianáꞌ me we, no nehx ndee me ñahz ñuꞌ gübaan, mban ni rahp me. ");
INSERT INTO zpg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","No leewe, laꞌd zegahc lâ tzu puexd; porni naa, Mpyquie-Pshahl Dioz Lee, guibyguiataꞌ hor-nehx nann laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Dxu we mos-tziaawy ni rtzoo xtziiñ xpatróṉ mod-racladzyu, no rsaꞌn xpatróṉ lee xiryuꞌ par gdee ni goo xmeññ me xhóru? ");
INSERT INTO zpg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dxu ñahc beeiy mós ni rsaꞌn xpatróṉ lee yuꞌ par ctzoo dziiñ, no hor-guiaad patróṉ gatzoo xmós me dziiñ zaꞌgndzi. ");
INSERT INTO zpg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gapyaꞌ laꞌd ni uli, ssaꞌn patróṉ xtziiñ me xlad xmos-tziaawy me par gap gyreu. ");
INSERT INTO zpg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per bâḻ mos-wé meññ-dirquihñ leeme no nlâdzy me galeer xpatróṉ me we, ");
INSERT INTO zpg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","no nizlo ntzoo nsahc me zrieñ zâ-mós me, no luxu ñuꞌ me lahd meññ-ngüee, ñahgü me no nzudzyno me lee, ");
INSERT INTO zpg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","no tohzy ndzihñ xpatróṉ me dze-nehx gabiahz me lee, no lohb hor-nehx nann me; ");
INSERT INTO zpg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","were nnahzy patróṉ leeme, nguihñ leeme no nshahl leeme ru za gahc meññ-ne meññ-tziaawy lee nîcze nehx uliu; uga guun me lé gahgü laiy me. ");
INSERT INTO zpg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Were ra Jesúz meññ-nuno me leeyahc: ―Mod-rtzoo Dioz ni nu gybaa mdad, ze we zidguiahcu beeiy tzii ngünaxtohby ni za lo guîltziahl no ziyno yâme lampr ni rquihñ ceihd, no zigydzil-lo yâme ñoby-guidzña. ");
INSERT INTO zpg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gaay yâme risshuunn xguîlriehñ, no zgaay yâme yac. ");
INSERT INTO zpg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Gaay ngüna-nehx risshuunn xguîlriehñ, nehx ziyno yâme ceihd ni cu yâme leññ xlampr yâme hor-ba byre ni nu leññu. ");
INSERT INTO zpg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Per zgaay yâme ni risshuunn xguîlriehñ, wé ziyno dac nunzy xlampr, mazyg zegahc ni nu zrieñ ceihd leññ. ");
INSERT INTO zpg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Per gumm ñoby-guidzña naꞌ galee par gydzihñ me la, meññ-ngüna-rieꞌ yahc naꞌ güyuꞌ mpcaaḻ lo yâme, no gutgahsy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ba beeiy glaꞌy guiaal, tohzy bieññ yâme gaqueꞌ riedz: “¡Ñoby-guidzña ba ziaad; lâ dzigydzil-lo leeme!” ");
INSERT INTO zpg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Gyre meññ-ngünaxtoby-caḻ biahs yâme no guzlo gaguꞌ yâme gue xlampr yâme. ");
INSERT INTO zpg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Gaay yâme we naꞌ, ni nehx risshuunn xguîlriehñ, ra yâme zgaay meññ-ngünaa ni ziyno zrieñ ceihd: “Lâ gdee doozy xceihd laꞌd tzu leññ dlampr noꞌ, porni ba gayieeu.” ");
INSERT INTO zpg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Per meññ-ngüna-rieꞌ naꞌ ra leeyâme: “Bâḻ gacu ze la, nehx ziygahlu ni par noꞌ ni par laꞌd. Ma mos lâ tza ru rtoꞌ yâmeu, lehdy sii ni yquihñ laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Per naabz za gydiby gaay meññ-ngüna-caḻ zicshii ceihd, tohzy bydzihñ ñoby-guidzña. No meññ-ngünaa ni biaꞌn gabiahz, güyuꞌ no leeme ru gac guîltziahl; no luxu biagü puert. ");
INSERT INTO zpg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Stoozy hór bydzihñ zrieñ meññ-ngünaa, no guzlo gaquee yâme riedz: “¡Lii ni rtzoo mdad, pshal yuꞌ, tzu noꞌ!” ");
INSERT INTO zpg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Per ra me: “Gapyaꞌ laꞌd ni uli, nehx nannaꞌ dxu laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ra Jesúz leeyâme: ―Leewe lâ cuianáꞌ, porni nehx nann laꞌd buc o pór guiaḻaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Mod-rtzoo Dioz ni nu gybaa mdad, ze we zidguiahcu beeiy to mpyquie ni ba nu par tza to ru ziht, no pshalcaꞌ me xmós me lehdy csan-no me xmedy me lee. ");
INSERT INTO zpg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’To de leeyâme psan-no me lee gaay mily medy-guiib, sto me bian-no chohp mily, no sto me bian-no diymily, mdid-beeiy gá ctzono yâme dziiñ. No luxu za me ru ba nac diidz tza me. ");
INSERT INTO zpg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ni cuaꞌ gaay mily, ptzoo me dziiñ no leeu, no ptzoou gan zgaay mily. ");
INSERT INTO zpg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","No zegahcu ni cuaꞌ chohp mily, ptzoo me gan schohp mily. ");
INSERT INTO zpg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per ni cuaꞌ diymily, wé güdahñ to guieryu no gülungaꞌdzy meu. ");
INSERT INTO zpg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Xroꞌ tiémp de ni za xpatróṉ yâme, gubyguiat me; no dze-ba biahd patróṉ‑e naꞌ, pshalcaꞌ me gyre xmós me lehdy güieꞌ me bia ptzoo yâme no medy ni bian-no yâme. ");
INSERT INTO zpg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Were bydzihñ nier mpyquie-cuaꞌ gaay mily, no bydziñno me zgaay mily mazy, no ra me: “Señor, bdeedyiꞌ naa gaay mily; no neꞌ zidnon zgaay mily mazy ni ptzon gan no xmedyiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ra xpatróṉ me leeme: “Mos ptzooy; mos-tziaawy‑e lii no rtzooy dziiñ zaꞌgndzi scâsy racladzyu; no sca-ze ptzooy dziiñ mos no doozy ni cuaꞌy, naa zdedyaꞌ lii ma xtahl. Güde, güyuꞌ ru rxilynon dmeññaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Byluxu bydzihñ mpyquie-cuaꞌ chohp mily, no ra me: “Señor, bdeedyiꞌ naa chohp mily, no neꞌ zidnon schohp mily mazy ni ptzon gan no xmedyiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ra xpatróṉ me leeme: “Mos ptzooy; rtzooy dziiñ zaꞌgndzi scâsy racladzyu; no sca-ze ptzooy dziiñ mos no doozy ni cuaꞌy, naa zdedyaꞌ lii ma xtahl. Güde, güyuꞌ ru rxilynon dmeññaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Per hor-bydzihñ sto me ni cuaꞌ diymily, ra me xpatróṉ me: “Señor, naa nannaꞌ rahpiꞌ to guîlmbañ-nahdy; rchuꞌy ru zrieñ dxu bdziib, no rtohpiꞌ ru nehx bdziibiꞌ mbehty. ");
INSERT INTO zpg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","No leewe bydziehbyaꞌ; güyan biglungatzyaꞌ xmedyiꞌ leññ yu. Per leexu zidnon neꞌ.” ");
INSERT INTO zpg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ra xpatróṉ me leeme: “Mos-dirquihñ lii no ntzaabiꞌ; neꞌy ba nanniꞌ rchun ru zrieñ dxu bdziib, no rtopaꞌ ru nehx bdzibaꞌ mbehty. ");
INSERT INTO zpg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Leewe, racladzyu nguꞌy dmedyaꞌ lo bancü, no dze-nibyguiataꞌ, ba ndeedyiꞌu naa no ni ptzoou gan.” ");
INSERT INTO zpg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Luxu ra patróṉ meññ-zu yahc uga: “Lâ gboo diymily ni caꞌ me, no lâ gdeeu ycaꞌ mpyquie-rahp tziiu. ");
INSERT INTO zpg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porni dxu rahp, scaꞌ mazy no zahp xtahl; per dxu nehx rahp, xtâ doozy ni rahp me zruuw leeme. ");
INSERT INTO zpg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","No mos-rieꞌ ni nehx rquihñ, lâ gráḻ leeme lo guibcawy stziuꞌ; uga guun me lé gahgü laiy me.” ");
INSERT INTO zpg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Naa, Mpyquie-Pshahl Dioz Lee, dze-guibyguiataꞌ nacaꞌ Ṟeiy no guidnon gyre x‑ángel Dioz, dze-wé cuian ru mos ru ctzon guîlguxtisy. ");
INSERT INTO zpg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","No gyre meññ ni nu lo guiedzylie gydohp yâme naa, no gboon cad to yâme diby lad, beeiy mpyquie-rahp xiily rboo me xiily lahd chiv. ");
INSERT INTO zpg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","No meññ-zidguiahc beeiy xiily gzun leeyâme dlad-drechaꞌ, no meññ-zidguiahc beeiy chiv gzun leeyâme dlad-ṟevezaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Luxu naa ni nac Ṟeiy gapyaꞌ meññ-zu lad-drech: “Lâ te, laꞌd ni nu xlaꞌy dTadaꞌ lee; lâ tzu ru rtzoo Dioz mdad, ru nac diidz tzu laꞌd xtâ glo dze-bzaa Dioz guiedzylie; ");
INSERT INTO zpg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","porni bylahnaꞌ, no laꞌd bdee ni güdahguaꞌ; byzaagydadzyaꞌ, no laꞌd bdee ni güeen; güzeen beeiy meññ-mbiuhz, no bdee laꞌd ru güyun; ");
INSERT INTO zpg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nehx güdap dshabaꞌ, no laꞌd bdee ni bitzaꞌ; guc-uren, no güyun lidzyguiib, no bidtixlo laꞌd naa.” ");
INSERT INTO zpg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Luxu meññ-rieꞌ yahc ni nac meññ-tziaawy, ga yâme naa: “Señor, ¿buc bwieꞌ noꞌ lii galahniꞌ, no bdee noꞌ ni güdahgüiꞌ? ¿O buc bwieꞌ noꞌ lii gazaagyladzyiꞌ, no bdee noꞌ ni güeey? ");
INSERT INTO zpg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿O buc bwieꞌ noꞌ lii beeiy meññ-mbiuhz, no bdee noꞌ ru güyuꞌy, o biaadz shabiꞌ, no bdee nó ni bihtziꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿O buc bwieꞌ noꞌ lii gayac-urey, o nuy lidzyguiib, no bidtixlo noꞌ lii?” ");
INSERT INTO zpg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Were naa ni nac Ṟeiy gapyaꞌ leeyâme: “Ni uli we ren laꞌd, gyre mod-gucno laꞌd to dmeññaꞌ sca rman-rieꞌ yahc, nîcze rluu uxiee rsahc yâme lahd meññ, scâsy ñahcu naa we gucno laꞌd lee.” ");
INSERT INTO zpg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Luxu gapyaꞌ meññ-zu dlad-ṟevezaꞌ: “Lâ gyruu de naa, laꞌd ni ba nac diidz gynihty; lâ tza lo gue ni nehx ziuꞌ dzé guiee, lee we ni ptahl Dioz lee par bêndzab no gyre x‑ángel me. ");
INSERT INTO zpg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Porni bylahnaꞌ, no nehx bdee laꞌd ni ñahguaꞌ; byzaagydadzyaꞌ, no nehx bdee laꞌd ni ñoon; ");
INSERT INTO zpg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","güzeen beeiy meññ-mbiuhz, no nehx bdee laꞌd ru ñun. Nehx güdap dshabaꞌ, no nehx bdee laꞌd ni ñutzaꞌ; guc-uren, no biaguaꞌ lidzyguiib, no nehx bidtixlo laꞌd naa.” ");
INSERT INTO zpg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Were ba ga meññ-rieꞌ yahc naa: “Señor, ¿buc bwieꞌ noꞌ lii galahniꞌ, o gazaagyladzyiꞌ, o beeiy meññ-mbiuhz, o gydi shabiꞌ ni gutziꞌ, o gayac-urey, o nuy lidzyguiib, no nehx gucno noꞌ lii?” ");
INSERT INTO zpg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Were gapyaꞌ leeyâme: “Ni uli ren laꞌd, gyre mod-di ñacno laꞌd to lahd meññ-rieꞌ yahc, nîcze rluu uxiee rsahc yâme lahd meññ, scâsy ñahcu naa we di ñacno laꞌd lee.” ");
INSERT INTO zpg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","No luxu meññ-rieꞌ yahc ni nac meññ-dirquihñ, ycaꞌ guîlné ni nehx zluhx; no meññ-tziaawy, wé tza ru ycaꞌ guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bylux günii Jesúz gyre nirieꞌ, ra me xmeññ me: ");
INSERT INTO zpg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ba nann laꞌd, ba schohp dzé gayaadz par gac lni-Pascü; no naa, Mpyquie-Pshahl Dioz Lee, zdee meññ naa lo ña meññ-rdziadzyno naa no yquee yâme naa lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Xjefy yahc bahl naꞌ, no muextr ni ruuḻ yahc xleiy Moiséz, no zrieñ mînguhl ni nac guxtisy lahd meññ-Isṟael, bydohp yâme ruꞌ palacy lo xpaty Caifáz ni nac xjefy gyre bahl. ");
INSERT INTO zpg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Uga ptzoo yâme diidz guisquiee yâme lehdy gynahzy yâme Jesúz ngaꞌdzy gá, no igaꞌdy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Per ne yâme: ―Nehx znahzy nó leeme lo lni, lehdy di gybiiñ meññ-guiedzy. ");
INSERT INTO zpg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Güya Jesúz guiedzy-Betania, xiryuꞌ to mpyquie ni le Simóṉ ni biudz lady. ");
INSERT INTO zpg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Lóni dxie Jesúz ruꞌ miax, bydzihñ to ngünaa no to frascü ni güyaa no guie ni le alabastro, no nu to ceitnixye leññu ni modni xguiaꞌ. Ngüna-rieꞌ güluꞌ me ceit-rieꞌ ihqy Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hor-bwieꞌ xmeññ Jesúz ni ptzoo ngüna-rieꞌ, bydziaꞌdzy yâme no ne yâme: ―¿Bia nacu bynihtyu xleꞌzy? ");
INSERT INTO zpg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ceit-rieꞌ beeiy ndoꞌu xguiaꞌ, lehdy ñacno xmedyu meññ-pobr. ");
INSERT INTO zpg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bieññ Jesúz ni ganii yâme, ra me leeyâme: ―¿Bia nacu gatziaꞌdzy laꞌd ngüna-rieꞌ? To ni mos‑e gatzoo me naa. ");
INSERT INTO zpg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Meññ-pobr, tirgahc‑e nu yâme lahd laꞌd; per naa nehx ziunon laꞌd tirgahc. ");
INSERT INTO zpg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Per ni ptzoo ngüna-rieꞌ hor-güluꞌ me ceitnixye dladyaꞌ la, gatzoo meu naa de ni igaꞌdzyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Gapyaꞌ laꞌd ni uli, rutisy gu meññ dtiidzaꞌ lo guiedzylie, zegahc zu yâme diidz ni ptzoo ngüna-rieꞌ, lehdy guitsêlou meññ leeme. ");
INSERT INTO zpg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","To lahd gydiby tzipychop xmeññ Jesúz, ni le Jud-Iscariot, güya me lo xjefy yahc bahl, ");
INSERT INTO zpg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ra me leeyâme: ―¿Bla gdee laꞌd naa bâḻ gdedyaꞌ Jesúz lo ña laꞌd? Were bdee yâme leeme treint medy-plat. ");
INSERT INTO zpg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","No lo hor-wé guzlo gayo me to mód lehdy gdee me Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Primer dzé ni nac lni ni rtzoo meññ-Isṟael, dze-rahgü yâme paṉ ni nehx rahp levadur, gübigy xmeññ Jesúz, no ra yâme leeme: ―¿Bá glo racladzyiꞌ dziguistziaawy noꞌ gyreu lehdy gotziey ni rahc lo lni-Pascü? ");
INSERT INTO zpg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ra Jesúz leeyâme: ―Lâ tza ciuda ru nu to mpyquie-rzaclo laꞌd lee, no lâ ga leeme: “Ze ne Muextr: Ba gadzihñ dzé gac ni por lee biaḻaꞌ; leewe riuꞌdadzyaꞌ ctzon lni-Pascü xiryuꞌy no dmeññaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","No mod-ra Jesúz xmeññ me, mod-wé ptzoo yâme, no uga bistziaawy yâme gyre ni rahc lo lni-Pascü. ");
INSERT INTO zpg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hor-güyuꞌ guiaal‑e naꞌ, gürie Jesúz ruꞌ miax no gydiby tzipychop xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lóni gayahgü yâme, ra me leeyâme: ―Gapyaꞌ laꞌd ni uli, to de lahd laꞌd gdee naa lo ña meññ-rdziadzyno naa. ");
INSERT INTO zpg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Gyre xmeññ me güyuꞌ trixd no guzlo ganabdiidz yâme leeme, to por to yâme ra: ―Señor, ¿dac naa la? ");
INSERT INTO zpg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ra Jesúz leeyâme: ―Dxu gagunihs xpaṉ no naa tohzy leññ blad, wé we gdee naa lo ña meññ. ");
INSERT INTO zpg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Naa, Mpyquie-Pshahl Dioz Lee, rapaꞌ de ni tedyaꞌ gyre ni ganii lo Guehtzy ru queꞌ xtiidz Dioz de naa. Per ¡baazy dzii de mpyquie-gdee naa lo ña meññ! Ma mos‑e di ñahl me. ");
INSERT INTO zpg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Luxu byruu Jud, ni ba nu par gdee Jesúz lo ña meññ-rdziadzyno leeme, ne: ―Muextr, ¿dac naa la? Ra Jesúz leeme: ―Lii ba güniiyu. ");
INSERT INTO zpg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Lóni gayahgü yâme, cuaꞌ Jesúz paṉ lo ña me, no bdee me xquix Dioz. Luxu, ptzulaꞌy meu, no bdee meu cuaꞌ xmeññ me, no ra me leeyâme: ―Lâ ycaꞌ nirieꞌ, no lâ gahgu; dcuerpaꞌ we leeu. ");
INSERT INTO zpg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Luxu cuaꞌ me to cop lo ña me, bdee me xquix Dioz, no bdee meu xmeññ me, ra me lee: ―Lâ goo ni nu leññ cop, gyre laꞌd, ");
INSERT INTO zpg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","porni nirieꞌ we drieñaꞌ ni no lee rdee Dioz diidz nu sto mod-coby par tzu meññ tohzy no leeme, no gyxieꞌu par xtahl meññ hor-gatyaꞌ lehdy guiar xguîlquie yâme. ");
INSERT INTO zpg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gapyaꞌ laꞌd, ba nehx zibyguiat gooraꞌ nirieꞌ ni riaa no blatzy xtâ dze-ba diaa nunon laꞌd ru rtzoo dTadaꞌ mdad, were goo nó nicoby. ");
INSERT INTO zpg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bylux biiḻy yâme himn, byruu yâme, za yâme dañ-Oliv. ");
INSERT INTO zpg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hor-ba bydzihñ yâme, ra Jesúz leeyâme: ―Gyre laꞌd csaꞌn naa guial-rieꞌ; porni lo Guehtzy ru queꞌ xtiidz Dioz neu: “Igatyaꞌ mpyquie-gayahp xiily, no gyre xiily gyraꞌdz.” ");
INSERT INTO zpg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per lux gybahñaꞌ, tzan ṟegioṉ-Galilea, nier naa, no luxu tza laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ra Pedr leeme: ―Nîcze gyre yâme csaꞌn lii, naa nehx ssanaꞌ lii. ");
INSERT INTO zpg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ra Jesúz leeme: ―Gapyaꞌ lii ni uli, guial-rieꞌ gahc‑e, dgueññ ziaꞌ cuiadz rig, lii ba tzonn vuelt güniiy nehx rzacloꞌy naa. ");
INSERT INTO zpg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Gyzac ra Pedr Jesúz: ―Nîcze gatyaꞌ no lii, per nehx zapyaꞌ di rzacloꞌn lii. No zrieñ xmeññ me günii mod-ne gahc Pedr. ");
INSERT INTO zpg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Luxu güya Jesúz no xmeññ me to ru le Getsemaní, no ra me: ―Lâ cuia neꞌ gahc, eguiid naa tzan nú diaa, dzignabaꞌ lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","No ziyno me Pedr no gyrop xiiñ Zebedeu, no guzlo gayuꞌ me trixd no gazacno me xtâ leññ xguîlmbahñ me. ");
INSERT INTO zpg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Were ra me meññ-rieꞌ yahc ni ziyno me: ―Leññ dguîlmbahñaꞌ nu to xroꞌ guîltrixd, lé rluu gatyaꞌ. Lâ guiaꞌn neꞌ, no lâ cuianáꞌ no naa. ");
INSERT INTO zpg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Luxu, za Jesúz stoozy zit-yaañ no bisshiby me lé güdihsh ihqy me lo yu, no günab me lo Dioz, ne me: ―Lii ni nac dTadaꞌ, bâḻ ñahcu ni ñaḻ, bislaa naa de lo ni nadz ni gabiahz naa; per dac‑e gac ni gynin, mazyg ni gyniiy‑e. ");
INSERT INTO zpg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Luxu, gubyguiat me ru biaꞌn xmeññ me, no bwieꞌ me nishcahsy yâme, no ra me Pedr: ―¿Di ñaḻ dxi mbianáꞌ laꞌd no naa nîcze diby hór la? ");
INSERT INTO zpg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lâ cuianáꞌ no lâ gnab lo Dioz lehdy di ctzoo laꞌd ni racladzy bêndzab. Xguîlmbahñ laꞌd racladzy ctzoo ni ulihbu nac xñahzû, per xcuerp laꞌd nehx rtibladzy. ");
INSERT INTO zpg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Gyzac za me, zignab me lo Dioz ni byrohp vuelt, günii me ne me: ―Lii ni nac dTadaꞌ, guîlné ni ba nac diidz tedyaꞌ, bâḻ di zaḻ tedyu sinn gacu la, were gac ni racladzyiꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hor-gubyguiat me, gyzac bwieꞌ me nishcahsy xmeññ me, porni bydzeꞌ mpcaaḻ lo yâme. ");
INSERT INTO zpg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Gyzac psaꞌn me leeyâme, no za me ni bionn vuelt, zignab me lo Dioz mod-günii gahc me. ");
INSERT INTO zpg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Luxu gubyguiat me ru biaꞌn xmeññ me, ra me lee: ―¿Gagahsy ziaꞌr laꞌd no gayisladzy ziaꞌr laꞌd la? Ba bydzihñ hór ni ba nac diidz gdee meññ Mpyquie-Pshahl Dioz Lee lo ña meññ-guîlquie yahc. ");
INSERT INTO zpg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lâ guiahs, tzoꞌ. Lâ güieꞌ, ba gadziñgahsh mpyquie ni gdee naa. ");
INSERT INTO zpg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ganii ziaꞌ Jesúz ze, tohzy bydzihñ Jud, ni lee nac to lahd gydiby tzipychop xmeññ Jesúz, bydziñno me xtahl meññ ni zidno yahc spad no garrot ni pshahl xjefy yahc bahl no zrieñ mînguhl yahc ni nac guxtisy lahd meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jud naꞌ, ni gdee Jesúz lo ña meññ, ba bdee me to señ meññ-ziyno me lee, ra me leeyahc: ―Dxu ycurun lee, wé we leeme; wé lâ gynahzy lee. ");
INSERT INTO zpg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","No nehx byleer mazy, scâsy bydzihñ yâme, ra Jud Jesúz: ―¡Diux, Muextr! No pcuruꞌ me lee. ");
INSERT INTO zpg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ra Jesúz leeme: ―Mígü, ni zidtzooy, ptzoo leeu. Were gübigy gahc meññ-ziyno me lee, no günahzy yâme Jesúz lehdy tziyno yâme lee. ");
INSERT INTO zpg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Per to lahd meññ-zuno Jesúz, güloo xispad me, no pchug me to gydiag xmós xjefy gyre bahl. ");
INSERT INTO zpg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Were ra Jesúz leeme: ―Güluꞌ xispadiꞌ xilgaru. Porni gyre dxu rdeḻy no spad la, no spad gahc‑e gaty yâme. ");
INSERT INTO zpg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Puedy-ladzyiꞌ nehx beeiy nnabaꞌ nshahl dTadaꞌ xtahl ángel yahc ni ñacno naa, no ngueeḻy gahc‑e ntzoo meu? ");
INSERT INTO zpg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","No bâḻ ntzon ze la, ba nehx ñahc ni nu lo Guehtzy ru queꞌ xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Luxu ra Jesúz meññ-zidnahzy leeme: ―¿Zidnot spad no garrot lehdy gynahzy laꞌd naa beeiy to meññ-gübaan la? Gyre dzé güyun ruꞌ idoró no laꞌd, blun meññ, no nehx günahzy laꞌd naa. ");
INSERT INTO zpg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per gyre nirieꞌ gayahcu ze lehdy gac ni ganii lo Guehtzy ru queꞌ xtiidz Dioz ni bzaa profet yahc ba xtze. Lo hor-wé byxuunn gyre xmeññ Jesúz, no psaꞌn yâme leeme lehzyme. ");
INSERT INTO zpg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Meññ-günahzy Jesúz, ziyno yâme leeme li Caifáz ni nac xjefy gyre bahl, no uga bydohp muextr ni ruuḻ yahc xleiy Moiséz no zrieñ mînguhl yahc ni nac guxtisy. ");
INSERT INTO zpg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedr naꞌ, náḻ me ziht gá glo bydzihñ me lo xpaty xiryuꞌ xjefy gyre bahl; no güyuꞌ me, gürie me lahd meññ-rahp ruꞌ idoró, lehdy güieꞌ me bia ctzoo meññ-caḻ yahc. ");
INSERT INTO zpg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Xjefy yahc bahl, no mînguhl yahc ni nac guxtisy, no gyre zrieñ meññ-nac guxtisy, gayo yâme dxu gynii ni nehx uli contr Jesúz, lehdy tzu mód gaty me; ");
INSERT INTO zpg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","per nehx bydzial yâmeu, nîcze bydzihñ xtahl meññ gayisquiee gyre gyzasy mód. Gyzac bydzihñ schohp meññ mazy ni ganii contr leeme, ");
INSERT INTO zpg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ni ne yahc: ―Ne mpyquie-rieꞌ: “Naa beeiy nguiñguien xiydoró Dioz, no lo tzonn dzé nzan leeu gyzac.” ");
INSERT INTO zpg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Were guzli xjefy gyre bahl, no ra me Jesúz: ―¿Nehx neꞌy mbehty la? ¿Bia leeu nirieꞌ ni rnii yâme chehshiꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per Jesúz ba nehx günii me mbehty. Were ra xjefy gyre bahl leeme: ―Por le Dioz ni mbahñ, gahbyiꞌ noꞌ ni nac ni uli, bâḻ lii we nac Crist, Xiiñ Dioz. ");
INSERT INTO zpg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ra Jesúz leeme: ―Lii ba güniiyu. No gapyaꞌ gyre laꞌd, to dzé zwieꞌ laꞌd naa, Mpyquie-Pshahl Dioz Lee, dxien xlad-drech Dioz ni beeiyu lee gyreu. No güieꞌ laꞌd guiaḻaꞌ lo zá ni gyruu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Were güdiix shab xjefy gyre bahl porni bydziaꞌdzy me, no ra me: ―¡Mpyquie-rieꞌ ganii me didz-nahcsy contr Dioz! ¿Bia mazy racdadzy nó tzu dxu gynii? Ba bieññ laꞌd ni ne me. ");
INSERT INTO zpg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Bia ne laꞌd naꞌ? Ra yâme leeme: ―Rahp me doḻ, no rahp me de ni gaty me. ");
INSERT INTO zpg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","No luxu byxîbyshieñ yâme lo me, no güdihñ yâme leeme, zrieñ yâme rgahp lo me, ");
INSERT INTO zpg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","no ra leeme: ―Liix‑e nac Crist. ¡Günii dxu güdihñ lii! ");
INSERT INTO zpg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedr naꞌ dxie me lo paty stziuꞌ, tohzydzi bydzihñ to criad, ra leeme: ―Lii zegahc güyuꞌy tohzy no Jesúz ni byruu lo ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Per günii Pedr “yac”, bieññ gyre meññ-dxieno me lee, no ne me: ―Nehx nannaꞌ de bia ganiiy. ");
INSERT INTO zpg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","No luxu za me ñaz-ruꞌ puert ru bwieꞌ sto criad leeme, no ra ngüna-rieꞌ zrieñ meññ-nu yahc uga: ―Mpyquie-rieꞌ zegahc güyuꞌ me tohzy no Jesúz ni nac meññ-Nasaret. ");
INSERT INTO zpg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Gyzac günii Pedr “yac”, bzaꞌd me le Dioz, no ne me: ―¡Nehx rzacloꞌn mpyquie-wé! ");
INSERT INTO zpg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Stoozy hór meññ-dxie yahc sto lad, gübigy yâme Pedr no ra yâme leeme: ―Ulihbu we to de lahd xmeññ mpyquie-rieꞌ lii, porni xtâ mod-rniiy rdee diidz. ");
INSERT INTO zpg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","No guzlo Pedr ganiwaty me, no gyzac bzaꞌd me le Dioz, no ne me: ―¡Nehx rzacloꞌn mpyquie-wé! Lo gahc hor-wé güriedz rig. ");
INSERT INTO zpg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Were bitsêlou Pedr de ni ra Jesúz leeme: “Dgueññ ziaꞌ cuiadz rig, lii ba tzonn vuelt güniiy nehx rzacloꞌy naa.” Byluxu byruu Pedr de uga, biin me gyre gylux. ");
INSERT INTO zpg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ni byre guiaal, bydohp gyre xjefy yahc bahl no zrieñ mînguhl yahc ni nac guxtisy lahd meññ-Isṟael, ptzoo yâme diidz igaꞌdy yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","No nliiby me, ziyno yâme leeme no bdee yâme leeme lo ña Ponzy Pilat ni nac gobernador. ");
INSERT INTO zpg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jud naꞌ, ni bdee Jesúz lo ña meññ-wé yahc, bwieꞌ me ni gatzoo yâme Jesúz, bioobu leeme no güya me bicsaꞌn me treint medy-plat ni cuaꞌ me lo xjefy yahc bahl no lo zrieñ mînguhl yahc ni nac guxtisy, ");
INSERT INTO zpg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","no ra me leeyâme: ―Naa ptzon guîlquie, porni bdedyaꞌ laꞌd to mpyquie ni nehx nu mbehty chehsh. Per ra yâme leeme: ―Nehx rioobu noꞌ de niwé. ¡Lii bwieꞌ xnahc gaquiꞌ! ");
INSERT INTO zpg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","No byluxz psaaby Jud medy-cuaꞌ me leññ idoró, biygaaḻ me leegahcme lo yahg. ");
INSERT INTO zpg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Xjefy yahc bahl cuaꞌ yâme medy-caḻ no ne yâme: ―Nehx xñahzu cu nó leeu leññ ru nu medy-gun, porni nacu medy ni byzee rieñ. ");
INSERT INTO zpg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bylux ptzoo yâme diidz, were cuaꞌ yâme medy-wé, güxii yâme to lyu ru rboo meññ yu ni bzaa yâme mbras, lehdy gacu lyu ru igaꞌdzy meññ-mbiuhz. ");
INSERT INTO zpg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","No leewe lyu-caḻ güyu-leu xtâ ni naꞌ Lyu-Rieñ. ");
INSERT INTO zpg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","No wé guhc mod-günii profet-Jeremíaz, ru ne me: “Cuaꞌ yâme gydiby treint medy-plat ni güdix meññ-Isṟael lehdy güxii yâme leeme, ");
INSERT INTO zpg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","no güxii yâme xilyu to mpyquie-rzaa mbras-yu, mod-ra Señor naa.” ");
INSERT INTO zpg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Güiyno yâme Jesúz lo gobernador, no ganabdiidz me Jesúz, ra me lee: ―¿Lii we xṞeiy meññ-Isṟael la? Ra Jesúz leeme: ―Lii we neu. ");
INSERT INTO zpg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","No nîcze xjefy yahc bahl no zrieñ mînguhl yahc ni nac guxtisy, gyrehzy ganii yâme contr Jesúz, per nehx günii me mbehty. ");
INSERT INTO zpg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Were ra Pilat leeme: ―¿Nehx rieññiꞌ bia gyre ne yâme contr lii la? ");
INSERT INTO zpg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per Jesúz ba di nnii me mbehty; no leewe modni ptzunadz gobernador. ");
INSERT INTO zpg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lo lni-Pascü naꞌ, ba bieno yâme rislaa gobernador to meññ-nyagü lidzyguiib, nitisy dxu gynii yâme gylaa. ");
INSERT INTO zpg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lo iz-wé nyagü to mpyquie ni rtzoo gyrehzy pur ni dirquihñ, le Barrabáz. ");
INSERT INTO zpg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","No lo hor-gyre meññ-wé yahc bydohp, ra Pilat leeyâme: ―¿Dxu racladzy laꞌd gylaa: Barrabáz la, o Jesúz, ni ra yâme lee Crist? ");
INSERT INTO zpg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat nann me por guîlmvidy‑e bidno yâme Jesúz lo me. ");
INSERT INTO zpg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hor-dxie Pilat ru rtzoo me guîlguxtisy, pshahl ndzab-tziahl me diidz lo me, ra leeme: “Na di ctzooy mbehty no mpyquie-wé ni nehx nu mbehty chehsh, porni por xtoḻ ni gayahc me, ntzie günii dixcaḻaꞌ pur mpcaḻ-nadz ni ndzieeby.” ");
INSERT INTO zpg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per xjefy yahc bahl no zrieñ mînguhl yahc ni nac guxtisy, pquihly yâme meññ-xtahl gnab yâme gylaa Barrabáz no gaty Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ra gobernador leeyâme: ―¿Dxu de lo gyrop yâme racladzy laꞌd guislaan lee? Ra yâme leeme: ―¡Barrabáz! ");
INSERT INTO zpg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ra Pilat leeyâme: ―¿Bia ctzon naꞌ no Jesúz, ni ra yâme lee Crist? Gyre yâme ne: ―¡Pquee leeme lo cruzy! ");
INSERT INTO zpg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ra gobernador leeyâme: ―¿Per bia ni dirquihñ ptzoo me? Per ma rquee yâme riedz, ne yâme: ―¡Yqueꞌ me lo cruzy! ");
INSERT INTO zpg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hor-bwieꞌ Pilat di raḻ gac mbehty mod-ne me, aaḻ guzlo gabiiñ gyre meññ ni garuu contr Jesúz, pshahl me meññ-biycaꞌ nzeꞌ, güdihby ña me ñaz-lo gyre yâme, no ne me: ―Naa nehx rapaꞌ doḻ no xguîlguhty mpyquie-rieꞌ; chehsh laꞌd‑e riaꞌnu. ");
INSERT INTO zpg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Gyre meññ-nu yahc uga, ra leeme: ―¡De ni gaty me, dchehsh noꞌ no chehsh dshiiñ noꞌ guiaꞌnu! ");
INSERT INTO zpg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Were bislaa Pilat Barrabáz; luxu ptzoo me mdad bydihñ Jesúz, no bdee me lee lehdy gaty lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","No ziyno xsoldad gobernador Jesúz leññ palacy ru ne yâme pretorio, no ptohp yâme gyre zrieñ soldad guingybi me. ");
INSERT INTO zpg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Güloo yâme shab me, no bguhtz yâme leeme to lar-xni, ");
INSERT INTO zpg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","no bzaa yâme to coron-guiahtz ni bdziib yâme ihqy me, no bdee yâme to var cuaꞌ me lo ña me lad-drech; no luxu risshiby yâme lo me, rtzuburl yâme leeme, ra yâme leeme: ―¡Nehx zehty xṞeiy meññ-Isṟael! ");
INSERT INTO zpg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","No rxîbyshieñ yâme leeme, no var gahc ni bdee yâme leeme, rboo yâmeu, rguihñ yâmeu ihqy me. ");
INSERT INTO zpg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bylux ptzuburl yâme leeme, güloo yâme lahr ni bguhtz yâme leeme, no bguhtz yâme shab me gyzac, no ziyno yâme leeme ru yquee yâme leeme lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hor-byruu yâme de uga, bwieꞌ yâme to mpyquie ni le Simóṉ, xguiedzy me le Ciren, bguu yâme leeme xcruzy Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","No bydzihñ yâme ru le Gólgota, ni rnii ne: Xilgar Calaver. ");
INSERT INTO zpg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bdee yâme vinagyr ni nutz nze-lá, ñoo Jesúz; güee me doozyu par gunn me bia leeu, no were ba di ñoor meu. ");
INSERT INTO zpg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","No hor-ba pquee yâme leeme lo cruzy, cuaꞌ soldad shab me, no güloo yâme suert lehdy bwieꞌ yâme dxu xlad guiaꞌn cad tohbyu. No modé guhc ni ba xtze diaa günii to profet lguia ni gac Jesúz, ru ne me: “Güdiiz yâme dshabaꞌ, no güloo yâme suert dxu ycaꞌ cad tohbyu.” ");
INSERT INTO zpg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","No luxu gürie yâme, gayahp yâme ru pquee yâme Jesúz lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","No ihqy cruzy queꞌ letrer ni güyaa bia nacu gaty me, neu: NIRIEꞌ WE JESÚZ, XṞEIY MEÑÑ-ISṞAEL. ");
INSERT INTO zpg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","No zegahc pquee yâme chohp meññ-gübaan lo zrieñ cruzy coo ru queꞌ Jesúz, to me lad-drech no sto me lad-ṟevez. ");
INSERT INTO zpg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","No meññ-rdedy yahc uga lé rquee yâme riedz, rtzuburl yâme no rchaḻ ihqy yâme, ");
INSERT INTO zpg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ra yâme leeme: ―Lii ni ne nguiñguie idoró, no lo tzonn dzé nzaayu gyzac, bislaa lii gahc; bâḻ uliu Xiiñ Dioz lii, biahtiꞌ lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","No zegahcu xjefy yahc bahl gatzuburl yâme leeme no zrieñ muextr ni ruuḻ yahc xleiy Moiséz, tohzy no meññ-nac yahc fariseu no zrieñ mînguhl yahc ni nac guxtisy, no gaya saꞌ yâme: ");
INSERT INTO zpg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Zrieñ meññ bislaa me lee, per naꞌ di raḻ guislaa me leegahcme. Bâḻ leeme xṞeiy meññ-Isṟael la, guiaht me lo cruzy naꞌ, no were gylídadzy nó leeme. ");
INSERT INTO zpg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Sca-ze ne me rlíladzy me Dioz la, gyla Dioz leeme naꞌ bâḻ ulihbu ndzi leeme. ¿Dâs ne me Xiiñ Dioz leeme la? ");
INSERT INTO zpg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Xtâ no meññ-gübaan ni queꞌ no leeme lo cruzy, gyrehzy ra leeme zegahc. ");
INSERT INTO zpg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Glo ribygue güyuꞌ guibcawy gydo lo guiedzylie no xtâ las-trez udzie. ");
INSERT INTO zpg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Beeiy hor-wé, las-trez, pquee Jesúz riedz-ndip, ne me: ―Elí, Elí, ¿lama sabactani? ―Nirieꞌ naꞌ neu we: TDiozaꞌ, tDiozaꞌ, ¿bia nacu psaꞌniꞌ naa tohgaꞌ? ");
INSERT INTO zpg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lahd meññ-zu yahc uga, hor-bieññ yâme ni günii me, ra yâme: ―Profet-Elíaz‑e gaquee me riedz lee. ");
INSERT INTO zpg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Lo hor-wé byxuunn to lahd yâme, biycaꞌ to sponj, no gülunihs meu lo vinagyr, no pquee meu ihqy beeiy to gobgui; luxu bdee meu goo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Per zrieñ yâme gaya: ―Lâ gdee ñahz güieꞌ nó bâḻ guiaad Elíaz guislaa leeme. ");
INSERT INTO zpg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Per Jesúz naꞌ, gyzac pquee me riedz ndip, no guhty gahc me. ");
INSERT INTO zpg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lo hor-wé gahc bygaax lar-rsaagü glaꞌy idoró glo guia no xtâ lo yu, no byruuw chohp laꞌy; no lé byzîbyyoob guiedzylie, lé güyuꞌ be guielaꞌ; ");
INSERT INTO zpg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","no byxal xtahl baa, no gübahñ xtahl xmeññ Dioz ni ba guhty; ");
INSERT INTO zpg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","no byruu yâme leññ baa, no hor-ba gübahñ Jesúz, za yâme leññ ciuda-Jerusaléṉ ni rahc cuent lee Dioz, no bwieꞌ xtahl meññ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Xcapitáṉ soldad no zrieñ meññ ni gayahp no leeme ru cueꞌ Jesúz lo cruzy, hor-bieññ yâme byniꞌby guiedzylie no bwieꞌ yâme gyre ni gayahc, bydzie yâme no ne yâme: ―Uli gahcxu we Xiiñ Dioz mpyquie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Xtahl meññ-ngünaa ni biahd no Jesúz dze-byruu me lo ṟegioṉ-Galilea no ni gucno leeme zegahc, zu yâme ziht gawieꞌ yâme; ");
INSERT INTO zpg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","lahd yâme zu Maríe-Magdalen, no Maríe xmam Jacob no José, no xmam xiiñ yahc Zebedeu. ");
INSERT INTO zpg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hor-ba udziedoo, bydzihñ to mpyquie-ṟicü ni le José, xguiedzy me le Arimatea, no zegahc xmeññ Jesúz leeme. ");
INSERT INTO zpg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Güya me, ra me Pilat bâḻ beeiy gdee ñahz glety me xcuerp Jesúz lo cruzy. Were ra Pilat meññ-gayahp gdee yâme ñahz glety José xcuerp Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Were gülety José xcuerp Jesúz, no pchaḻ me lee to lar-nye ");
INSERT INTO zpg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","no biycaꞌdzy me lee leññ to ba-coby ni ñahc xchieñ me ni leer bydahñ coo to guielaꞌ. Bylux ptiꞌx me to xroꞌ guie lehdy ptahgü me ruꞌ baa, no zia me. ");
INSERT INTO zpg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Per Maríe-Magdalen no sto Maríe biaꞌn yâme, dxie yâme uga ruꞌ baa. ");
INSERT INTO zpg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ni byre guiaal no ni güdedy dze-rzaa yâme gyre ni yquihñ par dze-risladzy meññ-Isṟael, güya xjefy yahc bahl no zrieñ meññ-nac yahc fariseu lo Pilat, ");
INSERT INTO zpg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ra yâme leeme: ―Señor, bitsêlou noꞌ dze-mbahñ mbuxter-caḻ, ne me lo tzonn dzé de ni gaty me, gybahñ me sto. ");
INSERT INTO zpg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","No leewe, nshahliꞌ meññ-ñahp ruꞌ baa tzonn dzé, duhn tza xmeññ me guiaal, dziglan xcuerp me, no ga yâme meññ: “Leeme gübahñ de lahd mînguty.” No ba ma zisquiee yâme meññ. ");
INSERT INTO zpg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ra Pilat leeyâme: ―Neꞌ nu soldad. Lâ tziyno leeyâme lehdy gap yâme ruꞌ baa mod-tzúladzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Were güya yâme no psaagü yâme ruꞌ baa dziꞌdzy, ni ba di sshal ndruhty lee, no luxu psaꞌn yâme soldad-gayahp. ");
INSERT INTO zpg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Güdedy dze-risladzy meññ, hor-ba zidtzu byniꞌ primer xdzé seman, Maríe-Magdalen no sto Maríe, güya yâme, bigüieꞌ yâme ruꞌ xbaa Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tohzydzi bieññ yâme gayahc to xu-ro, porni byruu to x‑ángel Señor gybaa, no bydzihñ me ru bygaꞌdzy Jesúz, no güloo me guie-ro ni nyagü ruꞌ baa, no gürie me chehshu. ");
INSERT INTO zpg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Lé rcampytzeꞌ me beeiy xgue ngüziee, no shab me nquitzybou. ");
INSERT INTO zpg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hor-bwieꞌ soldad leeme, bydzie yâme lé rzîbyyoob yâme no gutycawy yâme. ");
INSERT INTO zpg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ra ángel meññ-ngünaa: ―Di gydzie laꞌd. Naa nannaꞌ Jesúz gayo laꞌd lee ni pquee yâme lee lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nehx nu me neꞌ, leeme ba gübahñ, mod-günii me. Lâ te, güieꞌ laꞌd ru pcaꞌdzy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","No lâ tza ngueeḻy gahc, lâ ga xmeññ me: “Leeme ba gübahñ, no tza me lo ṟegioṉ-Galilea sunier ga me lo laꞌd; uga güieꞌ laꞌd leeme.” Leeu we zidnen laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Za meññ-ngüna-caḻ yahc ngueeḻy, byruu yâme de ruꞌ baa gadzie yâme, per zegahc gaxihly yâme; no za-güxuunn yâme, zigyne yâme xmeññ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tohzydzi bwieꞌ yâme Jesúz, no günii me diux leeyâme. Were gübigy yâme Jesúz no bisshiby yâme; güdiehdzy yâme nieꞌ me, no gazacbeeiy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","No ra Jesúz leeyâme: ―Di gydzie laꞌd. Lâ tza, lâ dzigyne dmeññ yahcaꞌ tza yâme lo ṟegioṉ-Galilea, no uga güieꞌ yâme naa. ");
INSERT INTO zpg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lóni za meññ-ngüna-rieꞌ yahc, lahd soldad ni güdahp ruꞌ ba-wé güya yahc leññ ciuda no bigyne yâme xjefy yahc bahl gyre ni guhc. ");
INSERT INTO zpg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jefy-rieꞌ yahc bigynino yâme zrieñ mînguhl yahc ni nac guxtisy lehdy ptzoo yâme diidz. Luxu bdee yâme xtahl medy cuaꞌ soldad, ");
INSERT INTO zpg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","no ra yâme lee: ―Mod-rieꞌ gynii laꞌd: “Guiaal hor-nishcahsy noꞌ, biahd xmeññ me, gülan xcuerp me.” ");
INSERT INTO zpg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","No bâḻ gobernador gann ze gatzoo nó, gynino noꞌ leeme lehdy di gyruu mbehty chehsh laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Were cuaꞌ soldad medy, no ptzoo yâme ni ra meññ-wé yahc leeyâme. No par meññ-Isṟael xtâ dzêrieꞌ, ne yâme ze we guhcu. ");
INSERT INTO zpg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Zahdy gydiby tzipyto xmeññ Jesúz lo ṟegioṉ-Galilea, güya yâme chehsh to dahñ ru ra Jesúz leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hor-bwieꞌ yâme Jesúz, bzacbeeiy yâme leeme; per lahd yâme cueꞌladzy ne dxgann bâḻ leeme we. ");
INSERT INTO zpg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Were gübigy Jesúz leeyâme no ra me leeyahc: ―Dioz ne me ctzon mdad gyre ni nu gybaa no gyre ni nu lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","No leewe ren laꞌd: Lâ tza gydo lo guiedzylie, lâ guno meññ dtiidzaꞌ lehdy gac yâme dmeññaꞌ; no lâ cchôbnihs leeyâme por le dTad nó Dioz, no Xiiñ me, no Spirt-Sant; ");
INSERT INTO zpg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","no lâ gluu leeyâme gzoob yâme diidz gyre ni ba ptzon mdad laꞌd. No naa ba nun no laꞌd gyre dzé, xtâ dze-gynihty guiedzylie. Modé gacu.");
INSERT INTO zpg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Neꞌ rizlo diidz ni rnii de Jesucrist, Xiiñ Dioz. ");
INSERT INTO zpg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ba xtze bzaa profet-Isaíaz lo xguehtzy me ni gu Dioz leeme, no neu: Naa cshaalaꞌ to dmeññaꞌ ni sunier loꞌy, tziyno me dtiidzaꞌ lo meññ; leeme guistziaawy me ru tedyiꞌ scâsy ractziaawy to ñahz. ");
INSERT INTO zpg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Rieññ gaquee to mpyquie riedz lo yu-bihdzy, ne: “Lâ guistziaawy ru tedy Señor; lâ cshal xguîlmbahñ laꞌd beeiy to ñaz-ndohp par dze-guiaad me.” ");
INSERT INTO zpg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Were biahd Juaṉ lo yu-bihdzy, gachôbnihs me meññ no gaya me leeyâme csaan yâme ni nahcsy ni nac yâme lehdy csiaaḻladzy Dioz xguîlquie yâme no gyrôbnihs yâme. ");
INSERT INTO zpg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","No riahd xtahl meññ-nu lo ṟegióṉ ni le Judea ridguieññ ni rnii me, no zehg riahd xtahl meññ-nu Jerusaléṉ. No gadee yâme diidz guîlquie ni ptzoo yâme, no pchôbnihs Juaṉ leeyâme lo guiagü-Jordáṉ. ");
INSERT INTO zpg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","No nutz Juaṉ shab ni güyaa no xguihtz camell, no riuꞌ to cinturoṉ-guiedy leññ me; no rahgü me ncüshar no roo me dziñdoo ni nu guehsh. ");
INSERT INTO zpg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","No hor-gayuno me meññ diidz, ra me leeyâme: ―Nu sto ni guiaad lux de ni biaḻaꞌ ni ma beeiyu lee que naa, ni nehx rsahcaꞌ ni xduu xguidguial me nruñaꞌ nshacaꞌu. ");
INSERT INTO zpg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naa ni uli we ba pchôbnisaꞌ laꞌd no nzeꞌ; per leeme gdee me Spirt-Sant ni tzu leññ xguîlmbahñ laꞌd beeiy to guîlrrôbnihs. ");
INSERT INTO zpg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","No leññ dze-wé yahc bydzihñ Jesúz, byruu me Nasaret, to guiedzy ni nu lo ṟegióṉ ni le Galilea, no pchôbnihs Juaṉ leeme lo guiagü-Jordáṉ. ");
INSERT INTO zpg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lóni garuu me leññ nzeꞌ we naꞌ, bwieꞌ me gaxal gybaa no ziaht xiSpirt Dioz lguia me beeiy to palom. ");
INSERT INTO zpg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","No bieññ to riedz ni byruu gybaa, ne: ―Lii we dShiñaꞌ ni ndzin lee; modni rxilynon lii. ");
INSERT INTO zpg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Byluxu güiyno xiSpirt Dioz leeme lo yu-bihdzy. ");
INSERT INTO zpg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Güyuꞌ Jesúz uga cuarent dzé, no ne bêndzab nwieꞌ bâḻ beeiy nquihly me Jesúz ntzoo mod-ra me lee. No uga güyuꞌ Jesúz lahd maguehsh ni nya, no gayacno x‑ángel yahc Dioz leeme. ");
INSERT INTO zpg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bylux bydahgü Juaṉ lidzyguiib we naꞌ, güya Jesúz lo ṟegioṉ-Galilea, bigyuno me meññ diidz de ni ctzoo Dioz mdad, no ");
INSERT INTO zpg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ne me: ―Ba byzaꞌ dzé, no ba bydziñgahsh dze-ctzoo Dioz mdad neꞌ. Lâ csaan ni nahcsy ni nac laꞌd, no lâ gylíladzy xtiidz me. ");
INSERT INTO zpg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gadedy Jesúz coo nisdoo ni le Galilea, no bwieꞌ me Simóṉ no behtzy me Ndréz, galee yâme gueshmbaḻ lo nzeꞌ; porni meññ-rnahzy mbaḻ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","No ra Jesúz leeyâme: ―Lâ te náḻ laꞌd naa, no naa ctzon laꞌd meññ ni guidno zrieñ yahc ni gac dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","No psaꞌn gahc yâme xgueshmbaḻ yâme, no za yâme no leeme. ");
INSERT INTO zpg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","No güdedy Jesúz stoozy, bwieꞌ me Jacob no Juaṉ, gyrop behtzy xiiñ Zebedeu; nu yâme leññ barcü, gaquieedy yâme gueshmbaḻ. ");
INSERT INTO zpg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pquee gahc Jesúz riedz leeyâme; no psaꞌn yâme xtad yâme Zebedeu leññ barcü gydibyno meññ-gayacno leeyâme, no za yâme no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bydzihñ yâme to guiedzy ni le Capernaum; no dze-risladzy meññ güyuꞌ Jesúz leññ idoo no guzlo galuu me meññ. ");
INSERT INTO zpg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","No rtzunadz yâme mod-rluu me, porni rluu me leeyâme beeiy to meññ-rtzoo mdad, no nehx rluu me beeiy rluu muextr ni ruuḻ yahc xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","No nu to mpyquie leññ ido-rieꞌ ni nu mbenahcsy lee, tohzy pquee me riedz, ");
INSERT INTO zpg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ne me: ―¿Bia ryohbyiꞌ no noꞌ, Jesúz ni nac meññ-Nasaret? ¿Ziaadiꞌ lehdy gniꞌdyiꞌ noꞌ la? Naa nannaꞌ dxu lii. Lii we ni nac Mpyquie-tziaawy ni Pshahl Dioz Lee. ");
INSERT INTO zpg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Per ptzoo Jesúz mdad mbenahcsy, ra me lee: ―¡Güyudzie, no byruu gahc de mpyquie-rieꞌ! ");
INSERT INTO zpg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mbenahcsy naꞌ, bzoobu mbeꞌ mpyquie-rieꞌ, no gaque-lahgü riedz, byruu gahcu de leeme. ");
INSERT INTO zpg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Modni ptzunadz meññ-nu leññ idoo Jesúz, no gaya saꞌ yâme: ―¿Biahx‑e leeu nirieꞌ? ¿To nicoby‑e leeu ni rluu me la? ¡Xnahc‑e rtzoo me mdad xtâ mbenahcsy, no rzoob gahcu xtiidz me! ");
INSERT INTO zpg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","No ngueeḻy, byzaꞌzy lo ṟegioṉ-Galilea, bie meññ diidz ni rtzoo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Byluxz byruu yâme idoo, za Jesúz xiryuꞌ Simóṉ no Ndréz; za yâme no Jacob no Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Suegyr-ngünaa Simóṉ naꞌ nash me, xle leeme; no bieno gahc yâme diidz Jesúz de ni gayahc me. ");
INSERT INTO zpg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Were gübigy Jesúz ru nash me, günahzy ña me, gucno leeme biahs me; no biaḻ gahc xixle me lo hor-wé, no bdee me ni güee Jesúz no xmeññ. ");
INSERT INTO zpg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ru ba udziedoo, naabz güyaaz ncübidz, güiyno yâme gyre meññ ni gayac-ure no ni nu mbenahcsy lee ru zu Jesúz; ");
INSERT INTO zpg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","no gyre meññ-nu yahc leññ guiedzy-caḻ bydohp ruꞌ puert. ");
INSERT INTO zpg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","No psiaḻ Jesúz gyre gyzasy guîlguihdz ni gayahc meññ, no güloo me xtahl mbenahcsy meññ; no ba di ndee me ñahz nnii mbenahcsy yahc, porni nann yahcu dxu we leeme. ");
INSERT INTO zpg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nchuulr, lé ncawy ziaꞌ, biahs Jesúz byruu me güya me ru ndruhty nehx nu, bignab me lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","No Simóṉ no zrieñ meññ-nuno me lee, zigyo yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","No ru bydzial yâme leeme, ra yâme leeme: ―Gyre meññ gayo lii. ");
INSERT INTO zpg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ra Jesúz leeyâme: ―Tzo nó zrieñ ru gahsh de neꞌ, lehdy gunon meññ-nu uga xtiidz Dioz; porni por leeu we biaḻaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","No ze güya me gydo lo ṟegioṉ-Galilea, gayuno me meññ xtiidz Dioz leññ xiydoo yâme, no gaboo me mbenahcsy yahc ni nu meññ. ");
INSERT INTO zpg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","To mpyquie-gayudz gydo lady gübigy me Jesúz no bisshiby me lo, no ra me lee: ―Bâḻ racladzyiꞌ la, beeiy csiaḻiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bioob Jesúz leeme, no pshob ña chehsh me, no ra leeme: ―Naa racdadzyaꞌ csiaḻaꞌ lii. ¡Ba biaḻiꞌ we! ");
INSERT INTO zpg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","No biaḻ gahc lady mpyquie-rieꞌ, no biaꞌn me nyar de xguîlguihdz me. ");
INSERT INTO zpg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Were gu Jesúz leeme tza me, no ra xnahc ctzoo me, ");
INSERT INTO zpg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ne: ―Na di guyu lo ndruhty; mazyg güya lo bahl lehdy güieꞌ me ba biaḻiꞌ, no güiyno gun ni gu Moiséz meññ, lehdy gann yâme ba biaḻiꞌ de xguîlguihdziꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per mpyquie-rieꞌ naꞌ, byruhzy me guzlo gahc gayuno me meññ diidz bia mód biaḻ me. No por leeu, ba di raḻ tzu Jesúz ru neññ leññ zrieñ guiedzy, pur ruꞌ guiedzy riaꞌn me ru nehx ma nu meññ; per gyre lad rruu meññ rdohp ru nu me. ");
INSERT INTO zpg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Güdahpu stoozy dzé gubyguiat Jesúz guiedzy-Capernaum; no bieññ meññ ba nu me ruꞌ yuꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bydohp xtahl meññ ru nu me, ba ni ruꞌ puert nehx nu ru beeiy ndedy meññ; no gayuno me xtiidz Dioz meññ. ");
INSERT INTO zpg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tohzy bydzihñ tahp meññ, zidno yâme to mpyquie-gayac-ure ni di raḻ gyniꞌby mbehty, nash me to lo camill. ");
INSERT INTO zpg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","No gumm di raḻ gydzihñ yâme lo Jesúz porni bydzeꞌ meññu la, were pshal yâme ihqy yuꞌ xderech ru zu Jesúz, lehdy güdahpu to ru gülety yâme mpyquie-rieꞌ ni gayac-ure ni nash lo camill. ");
INSERT INTO zpg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hor-bwieꞌ Jesúz ulihbu rlíladzy yâme, ra me mpyquie-gayac-ure: ―Shiꞌñ, xguîlquiey ba psiaaḻdadzyaꞌ gyreu we. ");
INSERT INTO zpg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dxie chohp tzonn muextr uga ni ruuḻ yahc xleiy Moiséz, ganii leññ ihqy yâme: ");
INSERT INTO zpg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Biahx‑e nacu rnii me ze? Rnii me didz-nahcsy contr Dioz, porni nunzy Dioz‑e beeiy rsiaaḻladzy xguîlquie meññ.” ");
INSERT INTO zpg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Per Jesúz naꞌ, nann me bia ganii leññ ihqy meññ-rieꞌ yahc. Were ra me: ―¿Bia nacu rnii leññ ihqy laꞌd ze? ");
INSERT INTO zpg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Bia leeu ma nehx ngann, ñapyaꞌ mpyquie-rieꞌ ni di raḻ gyniꞌby: “Gyre xguîlquiey ba psiaaḻdadzyaꞌ”, o ñapyaꞌ leeme: “Biahsiꞌ, gülesy xcamilliꞌ no güzeꞌ”? ");
INSERT INTO zpg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Naa, Mpyquie-Pshahl Dioz Lee, glun laꞌd beeiy rsiaaḻdadzyaꞌ xguîlquie meññ. Were ra me mpyquie-di raḻ gyniꞌby: ");
INSERT INTO zpg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Gapyaꞌ lii: Biahsiꞌ, gülesy xcamilliꞌ, no gübiꞌ xiryuꞌy. ");
INSERT INTO zpg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","No biahs gahc me, no gülesy me xcamill me, no byruu me zia me, gawieꞌ gyre meññ. No gatzunadz yâme no gaguguia yâme Dioz no gaya saꞌ yâme: ―Nito dgueññ güieꞌ nó zâ nirieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Luxu gyzac güya Jesúz coo nisdoo; no gadohp xtahl meññ leeme no galuu me lee. ");
INSERT INTO zpg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","No lóni gadedy me naꞌ, bwieꞌ me Leví xiiñ Alfeu, dxie gacuquix mpuezd meññ. Were ra Jesúz leeme: ―Güde, náḻiꞌ naa. No biahs gahc Leví, za me no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","No ru gayahgü Jesúz li Leví, dxie xtahl meññ-rcuquix mpuezd, no zegahc dxie zrieñ meññ-rtzoo gyrehzy guîlquie tohzy ruꞌ miax no Jesúz no xmeññ me; porni nu xtahl meññ ni za no leeme. ");
INSERT INTO zpg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","No muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, ru bwieꞌ yâme gayahgü Jesúz no meññ-caḻ yahc, ra yâme xmeññ me: ―¿Bia nacu rahgü xmuextr laꞌd tohzy no meññ-rcuquix mpuezd no zrieñ meññ-rtzoo gyrehzy guîlquie? ");
INSERT INTO zpg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hor-bieññ Jesúz nirieꞌ, ra me leeyâme: ―Meññ-nzaꞌg nehx rquihñ tza lo doctor, mazyg meññ-gayac-ure, wé we rquihñ tza lo me. Naa nehx biaḻaꞌ zidyobyaꞌ meññ-tziaawy, mazyg meññ-guîlquie we zidyobyaꞌ leeyahc. ");
INSERT INTO zpg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","To dzé, xmeññ Juaṉ ni rchôbnihs gatzoo yâme ayun no zegahcu xmeññ meññ-nac yahc fariseu; no biahd lahd meññ, günabdiidz yâme Jesúz, ra yâme leeme: ―¿Bia nacu xmeññ Juaṉ no xmeññ meññ-nac yahc fariseu rtzoo yâme ayun, no xmeññiꞌ yac? ");
INSERT INTO zpg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ra Jesúz leeyâme: ―Ru nu meññ lo guîltziahl, ¿nehxni beeiy ntzoo yâme ayun no nu ziaꞌr ñoby-gayidzña lahd yâme? Incs nu ziaꞌ me lahd yâme, nehx beeiy nsaꞌn de ni gayoo gayahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per ziaad dzé ru naa ni zidguiahc beeiy to ñoby-guidzña, ba dgueññaꞌ lahd yâme, were ctzoo yâme ayun no nehx zoo zahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ndruhty nehx nquieedy diby laꞌy lar-coby to lo lar-gush; porni bâḻ leeu ñahcu ze la, lar-coby nguiixu lar-gush, no ba ma ñacxroꞌ ru nyuhx. ");
INSERT INTO zpg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","No ndruhty nehx rguꞌ vin ni leer güyaa leññ to bush-guiedy ni ba nigush; porni bâḻ leeu ñahcu ze la, nchiahzu bush-guiedy ni ba nigush, no nnitylou vin no zegahcu bush. Leewe vin ni leer güyaa rahpu de ni tzuw leññ bush-guiedy ni ncoby. ");
INSERT INTO zpg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","To dze-risladzy meññ, güdedy Jesúz leññ to lyu ru dziib trigü, no xmeññ me naꞌ, lóni gadedy yâme guzlo gachuꞌ yâme xdo trigü. ");
INSERT INTO zpg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Were ra meññ-nac yahc fariseu Jesúz: ―¿Bia nacu gatzoo xmeññiꞌ dziiñ ni nehx xñahzû gac dze-risladzy meññ? ");
INSERT INTO zpg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Were ra Jesúz leeyâme: ―¿Dgueññ guuḻ laꞌd ni ptzoo Davit tzcaḻ la, dze-biaadz me ni nquihñ me no bylahn me no gahc meññ-zidno me? ");
INSERT INTO zpg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Güyuꞌ me leññ xiydoo Dioz dze-nac Abiatar xjefy gyre xbahl meññ-Isṟael, no güdahgü me paṉ ni guhc gun par Dioz, ni ne xleiy Moiséz nehx beeiy rahgü nyugz meññ lee, mazyg nunzy bahl; no bdee meu güdahgü meññ-zidno me zegahc. ");
INSERT INTO zpg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","No zegahc ra Jesúz leeyâme: ―Dze-risladzy meññ biaꞌnu we lehdy gacnou meññ, no dac‑e meññ biaꞌn lehdy gzacbeeiy meññ leeu. ");
INSERT INTO zpg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Leewe naa, Mpyquie-Pshahl Dioz Lee, rtzon mdad zegahc bia beeiy gac dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gyzac sto dzé güyuꞌ Jesúz leññ to idoo; no nuty to mpyquie lahd meññ uga, gübihdzy to ña me. ");
INSERT INTO zpg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Guzlo galaꞌdzy yâme Jesúz lehdy güieꞌ yâme bâḻ ssiaḻ me mpyquie-rieꞌ dze-risladzy meññ lehdy gydzial yâme mod-gyruu yâme contr leeme. ");
INSERT INTO zpg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Were ra Jesúz mpyquie ni gübihdzy to ña: ―Biahsiꞌ no bigliahz glawy. ");
INSERT INTO zpg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","No günabdiidz Jesúz meññ-caḻ yahc, ra me: ―¿Bia beeiy ntzoo mu dze-risladzy meññ, ni mos la o ni nahcsy? ¿Nislaa mu to meññ de lo guîlguhty la, o ngaꞌdy mu leeme? Per di nnii yâme mbehty. ");
INSERT INTO zpg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","No bydziaꞌdzy me bwieꞌ me lo gyre meññ-dxie guingybi me, no rioobu leeme leeyâme porni nahdy xguîlmbahñ yâme, no ra me mpyquie ni gübihdzy to ña: ―Biscaa ñay. No biscaa me leeu, no biaḻ gahcu, biaꞌnu nzaꞌg gyzac. ");
INSERT INTO zpg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Byluxu byruu meññ-nac yahc fariseu idoo no guzlo gahc gatzoo yâme diidz tohzy no xmeññ Herody, xnahc igaꞌdy yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","No byruu Jesúz za me no xmeññ me coo nisdo-Galilea, no xtahl meññ náḻ leeme ni byruu yahc lo ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","No ru bieññ zrieñ meññ yahc xroꞌ cos gatzoo Jesúz, bydohp xtahl yâme leeme. Leeyâme we meññ-byruu lo ṟegioṉ-Judea, no ciuda-Jerusaléṉ; no meññ-byruu lo ṟegióṉ ni le Idumea, no meññ-byruu stiby chehsh guiagü-Jordáṉ, no gybi chohp ciuda ni le Tiro no Sidóṉ. ");
INSERT INTO zpg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","No leewe ra Jesúz xmeññ me cu yâme puexd to barcü-yaañ, lehdy di gañ meññ leeme mazy. ");
INSERT INTO zpg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Porni ba psiaḻ me xtahl meññ, nyehgz gyre meññ-gayac-ure za, gayaꞌñ saꞌ lehdy can yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","No hor-rwieꞌ meññ-nu mbenahcsy leeme, risshiby yâme lo me no rquee yâme riedz, ra yâme leeme: ―¡Lii we Xiiñ Dioz! ");
INSERT INTO zpg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per Jesúz byduhsh me lo mbenahcsy yahc, no ra me di gynii yahcu dxu leeme. ");
INSERT INTO zpg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Luxu cueꞌ Jesúz chehsh to dahñ, no ptohp me meññ-gucladzy me. ");
INSERT INTO zpg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","No güle me tzipychop ni gac xmeññ me lee ni tziyno me lee rutisy tza me, no ni cshahl me lee dzigyuno xtiidz me meññ; ");
INSERT INTO zpg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","no gacno me leeyâme lehdy csiaḻ yâme meññ-gayac-ure no gboo yâme mbenahcsy ni nu meññ. ");
INSERT INTO zpg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nirieꞌ we le gydiby tzipychop meññ ni güle me lee: Simóṉ ni güluꞌ Jesúz le Pedr, ");
INSERT INTO zpg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","no güle me Jacob no Juaṉ, gyrop behtzy xiiñ Zebedeu ni güluꞌ Jesúz le Boanerges, ni rnii ne: Xmiꞌñ ngüziee. ");
INSERT INTO zpg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","No güle me Ndréz, Felipy, Bartolomé, Mateu, Tomáz, Jacob leewe xiiñ Alfeu, Tadeu, Simóṉ ni güyuꞌ lahd to cuib meññ ni le cananist, ");
INSERT INTO zpg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","no Jud-Iscariot ni byluxu bdee Jesúz lo ña meññ-rdziadzyno leeme. Luxu güyuꞌ Jesúz leññ to yuꞌ ");
INSERT INTO zpg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","no gyzac bydohp xtahl meññ leeme, ba ni di raḻ gahgü me no xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hor-bieññ xfamily Jesúz naꞌ, güya yâme ziycaꞌ yâme leeme; porni nlâdzy yâme nguidz xguîlriehñ me we. ");
INSERT INTO zpg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","No zegahc dxie xtahl muextr ni ruuḻ xleiy Moiséz ni byruu yahc Jerusaléṉ, ne yâme: ―Beelzebú, ni nac xjefy gyre mbenahcsy, nuno leeme; wé racno leeme lehdy rboo me mbenahcsy meññ. ");
INSERT INTO zpg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Were ptohp Jesúz leeyâme no günino me leeyâme ndaagü lo diidz, ra me: ―¿Bia mód‑e mboo bêndzab leegahcme? ");
INSERT INTO zpg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bâḻ meññ-nac yahc xguxtisy to guiedzy nruu chohp cuib no ndeḻy yâme la, nnitylo de ni rtzoo yâme mdad‑e. ");
INSERT INTO zpg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","No bâḻ to family nruu chohp cuib no ndeḻy yâme la, nnitylo family-wé we. ");
INSERT INTO zpg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","No bâḻ bêndzab nruu me chehsh gahcme la, nehx beeiy ñuꞌr me, ba gahc ndzihñ xdzé me we. ");
INSERT INTO zpg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’No zegahc ndruhty nehx beeiy ñuꞌ leññ xiryuꞌ to mpyquie-ndip lehdy ncaꞌ gyre ni rahp me, bâḻ nier di gylihby me lee; no mod-wé were beeiy ncaꞌ me gyre ni rahp. ");
INSERT INTO zpg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Gapyaꞌ laꞌd ni uli, Dioz csiaaḻladzy gyre xguîlquie meññ no nitisy didz-nahcsy ni rnii meññ contr leeme; ");
INSERT INTO zpg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","per dxu rnii didz-nahcsy contr Spirt-Sant, nehx ziuꞌ dzé ssiaaḻladzy Dioz ni günii me, mazyg ba togahcs‑e nu guîlquie-wé chehsh me. ");
INSERT INTO zpg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ra Jesúz leeyâme ze porni ra yâme: “Nu to mbenahcsy leeme.” ");
INSERT INTO zpg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Luxu bydzihñ xmam Jesúz no meññ-behtzy me per biaꞌn yâme stziuꞌ gahc, no pshahl yâme diidz tza Jesúz ru zu yâme. ");
INSERT INTO zpg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","No meññ-dxie guingybi Jesúz ra yâme leeme: ―Xmamiꞌ no meññ-behtzyiꞌ zu stziuꞌ gayo lii. ");
INSERT INTO zpg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Were ra me leeyâme: ―¿Dxu we leeyâme dmamaꞌ no meññ-dbetzyaꞌ? ");
INSERT INTO zpg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","No bwieꞌ me meññ-dxie guingybi me, no ra me: ―Meññ-rieꞌ yahc‑e dmamaꞌ no meññ-dbetzy yahcaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Porni nitisy dxu rtzoo mod-racladzy Dioz, wé we dbetzyaꞌ, no wé we dsanaꞌ, no wé we dmamaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Gyzac guzlo galuu Jesúz meññ coo nisdo-Galilea, no bydohp xtahl meññ ru zu me; were güyehpy me leññ to barcü ni naḻ lo nzeꞌ, no gürie me; no meññ-caḻ yahc biaꞌn coo nisdoo. ");
INSERT INTO zpg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","No guzlo galuu me meññ-caḻ yahc, ndaagü lo diidz rnii me. Lóni galuu me, ra me meññ-rieꞌ yahc: ");
INSERT INTO zpg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Lâ guieññ nirieꞌ: Güyuꞌ to mpyquie, güya me lo xilyu me bicchaꞌdz me ladzy trigü lehdy gylahñu. ");
INSERT INTO zpg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Lóni gachaꞌdz me leeu we naꞌ, doozyu biahb coo ñahz, no biahd mayaañ güdahgü yâmaꞌ leeu. ");
INSERT INTO zpg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Stoozyu biahb lahd guie, ru nehx nu xtahl yu; no ngueeḻy gülahñ yahcu, porni uxiee yu rahpu. ");
INSERT INTO zpg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Per ru byruu ncübidz bdzuu leeyahcu; no gumm nehx ziaꞌ ba günahzyu lo yu zaꞌgndzi la, gübihdzyu. ");
INSERT INTO zpg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Stoozyu biahb ru rlahñ guix-guiahtz; no bygaꞌy guix-guiahtz no di ndee lgar nniꞌzyu, no nehx cueꞌ lou. ");
INSERT INTO zpg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Per stoozyu biahb lo yu-tziaawy ru beeiy cueꞌu mos; gülahñ yahcu no bygaꞌyu, no lahdu cueꞌ treint gá ladzyu cad to lo xan, no zrieñu cueꞌ sesent, no zrieñu cueꞌ diby gayuu. ");
INSERT INTO zpg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","No ra me leeyâme: ―Bâḻ racladzy laꞌd gann laꞌd bia ganin la, lâ yquee ihqy laꞌd dtiidzaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Byluxu, ru biaꞌn Jesúz tohg leeme, günabdiidz meññ-zu gahsh de leeme no gydiby tzipychop xmeññ me bia rnii ni günii me ndaagü lo diidz. ");
INSERT INTO zpg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ra me leeyâme: ―Laꞌd, bdee Dioz lsenzy gann ni nungaꞌdzy de ni rtzoo me mdad; per zrieñ meññ la, wé gyninon lee pur ndaagü lo diidz. ");
INSERT INTO zpg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Were nîcze ma güieꞌ yâme, guiaꞌn yâme beeiy ni di rwieꞌ; no nîcze ma guieññ yâme, per nehx zann yâme bia leeu, lehdy di ssaan yâme ni nahcsy ni nac yâme no ba di ssiaaḻladzy Dioz xguîlquie yâme. ");
INSERT INTO zpg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","No ra me leeyâme: ―¿Nehx rieññ laꞌd nirieꞌ ni günin ndaagü lo diidz la? ¿Xnahc‑e naꞌ guieññ laꞌd zrieñ ni gapyaꞌ laꞌd ndaagü gahc lo diidz? ");
INSERT INTO zpg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mpyquie-ricchaꞌdz ladzy trigü lehdy gylahñu, leeme zidguiahc beeiy meññ-runo meññ xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","No lahd meññ ni rieññ yahc‑e zidguiahc beeiy ladzy ni biahb coo ñahz; rieññ yâme xtiidz Dioz, per luxu ba ziaad bêndzab rboo leeu leññ xguîlmbahñ yâme. ");
INSERT INTO zpg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","No zegahc zrieñ meññ yahc‑e zidguiahc beeiy ladzy ni biahb lahd guie ru dxie doozy dzii yu: hor-rieññ yâme xtiidz Dioz, rcaꞌ gahc yâmeu no rxilyno yâmeu; ");
INSERT INTO zpg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","per gumm zidguiahc yâme beeiy plant ni nehx günahzy lo yu zaꞌgndzi la, doozy dzé rtibladzy yâme; no leewe, dze-riahd xtahl ni nadz ni rdedy yâme, o rgultihp zrieñ meññ leeyâme por xtiidz Dioz, ba gahc rxiññladzy yâme. ");
INSERT INTO zpg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","No zrieñ yâme zidguiahc beeiy ladzy ni biahb ru rlahñ guix-guiahtz; rieññ yâme xtiidz Dioz, ");
INSERT INTO zpg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per rguꞌ ihqy yâme ni nu lo guiedzylie-rieꞌ, no risquiee guîlṟicü leeyâme, no rzîbyladzy yâme zrieñ cos yahc; no gyre niwé rcau dziiñ ni ntzoo xtiidz Dioz leññ xguîlmbahñ yâme, no rahc yâme beeiy plant ni nehx rqueꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","No zrieñ yâme zidguiahc beeiy ladzy ni biahb lo yu-tziaawy; rieññ yâme xtiidz Dioz no rcaꞌ yâmeu. Zidguiahc yâme beeiy plant yahc ni cueꞌ treint gá ladzyu to lo xan, no zrieñu cueꞌ sesent, no zrieñu cueꞌ diby gayuu. ");
INSERT INTO zpg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Zegahc ra Jesúz leeyâme: ―¿Nehxni ridno mu lampr lehdy cuiahzu leññ to caj o leññ to luꞌn la? Yac, ru guia we rbiahzu, lehdy cuw byniꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Porni nehx nu mbehty ni nungaꞌdzy no di gyxal lou; no nehx ziaꞌn mbehty ni nungaꞌdzy, gyreu gyruu lo byniꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bâḻ racladzy laꞌd guieññ laꞌd bia ganin la, lâ yquee ihqy laꞌd dtiidzaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","No ra me meññ-rieꞌ zegahc: ―Gax lâ gann no ni rieññ laꞌd. Mdid ni rquee gahc laꞌd zrieñ meññ, leegahcu we squee Dioz mdid laꞌd no zdee me laꞌd mazy. ");
INSERT INTO zpg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Porni dxu beeiy rieññ dtiidzaꞌ la, scaꞌ me dguîlriehñaꞌ mazy; no dxu di rieññ dtiidzaꞌ, xtâ doozy guîlriehñ ni rahp me zruuw leeme. ");
INSERT INTO zpg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Zegahc ra Jesúz: ―Beeiy ni rahc ru to mpyquie rchaꞌdz me byni lo to lyu lehdy gylahñu, ze we zidguiahc mod-rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","No rgahsy me guiaal no riahs me rsily, no byni galahñu no ganiꞌzyu, no nehx nann me xnahc rniꞌzyu. ");
INSERT INTO zpg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Porni yu gahc‑e riscaꞌy leeu; nier rboou guix, luxu ba gboo xdou, no ba yqueꞌ lou no rdzeꞌ lo xdou. ");
INSERT INTO zpg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","No dze-ba guryahlu, ba zicchuꞌ yâme leeu, porni ba bydzihñ xicüsechu. ");
INSERT INTO zpg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Zegahc ra Jesúz: ―¿Bia zidguiahc beeiy mod-rtzoo Dioz mdad, o bia ejempl beeiy nsahc nó leeu? ");
INSERT INTO zpg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Zidguiahcu beeiy to ladzy mostas ni rbib lo yu lehdy gylahñu, no leeu ma nwiñu de lo gyre zrieñ ladzy yahc ni nu lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Per incs ba güdzibu, modni rgaꞌyu no rahcu ma nro que gyre zrieñ ni rbib lo lyu, no rboo xuz-roobu, xtâ no ma-rzîbydun yahc beeiy rzaa xguehsh maꞌ leññ ximbleu. ");
INSERT INTO zpg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mod-rieꞌ gayuno Jesúz xtiidz me meññ no xtahl ni rnii me ndaagü lo diidz beeiy nirieꞌ yahc, glohdy ru beeiy guieññ yâme leeu. ");
INSERT INTO zpg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","No mbehty nehx ra Jesúz leeyâme bâḻ di ñahcu pur ndaagü lo diidz; per ru ba lehzyme no xmeññ me, were ba rboxñahz me gyreu. ");
INSERT INTO zpg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dze-caḻ gahc ru ba gayuꞌ guiaal ra Jesúz xmeññ me: ―Tedy nó stiby chehsh nisdo-Galilea. ");
INSERT INTO zpg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Gumm ba dxie me leññ barcü la, güyuꞌ yâme leññu zegahc no za yâme, psaꞌn yâme meññ-xtahl coo nisdoo. No zegahc za zrieñ barcü no leeme. ");
INSERT INTO zpg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Per tohzydzi guzlo byxuu to mbedun-ro lo nisdoo no lé ruhtz oḻ chehsh barcü no gadzeꞌ nzeꞌ leññu. ");
INSERT INTO zpg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","No nash Jesúz traz leññ barcü, nishcahsy me ncuꞌg me to lmad. Were psiuꞌ yâme lo me, no ra yâme leeme: ―¡Muextr! ¿Nehx nacu mbehty la, gayaꞌb nó? ");
INSERT INTO zpg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Were biahs Jesúz, no ptzoo me mdad mbedun; no ra me nisdoo: ―¡Güyudzie! ¡Di ctzuṟidiꞌ! No güliahz gahc mbedun, no gyreu güyuꞌ dzie. ");
INSERT INTO zpg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Byluxu ra Jesúz xmeññ me: ―¿Bia nacu zehdy rdzie laꞌd? ¿Nehx ziaꞌ rlíladzy laꞌd naa la? ");
INSERT INTO zpg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Per leeyâme, modni gadzie yâme no ganabdiidz saꞌ yâme, ra yâme: ―¿Dxuz‑e leeme mpyquie-rieꞌ? ¡Xnahc‑e xtâ mbedun no nisdoo rzoob xtiidz me! ");
INSERT INTO zpg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bydzihñ yâme stiby chehsh nisdoo ru rtzoo meññ-gadaren mdad. ");
INSERT INTO zpg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Scâsy byruu Jesúz leññ barcü, biahd gahc to mpyquie ru zu me ni byruu lahd baa. No mpyquie-rieꞌ naꞌ, nu mbenahcsy lee, ");
INSERT INTO zpg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","no tirgahc nu me lahd baa. No ndruhty di raḻ glihby leeme, nîcze no caden. ");
INSERT INTO zpg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Xtahl vuelt blihby yâme leeme no caden no blihby yâme nieꞌ me no to guiib, per rchug me caden no rlaꞌy me guiib, no ndruhty nehx beeiy rtzoo gan leeme lehdy ñudzie me. ");
INSERT INTO zpg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tirgahc dzé no guiaal, ganzeꞌ me chehsh dahñ no lahd baa, rquee me riedz, no rchug lady gahcme no guie-ndush. ");
INSERT INTO zpg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Per ru bwieꞌ me Jesúz xtâ ziht, byxuunn me biahd me bidguisshiby me lo, ");
INSERT INTO zpg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","no gaquee me riedz ndip, ra me lee: ―¿Bia ryohbyiꞌ no naa Jesúz, Xiiñ Dioz-nu gybaa? ¡Rnabaꞌ lii por le Dioz di ctzoo csahquiꞌ naa! ");
INSERT INTO zpg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Günii me ze, porni ba gu Jesúz leeme: ―¡Mbenahcsy, byruu mpyquie-rieꞌ! ");
INSERT INTO zpg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","No günabdiidz Jesúz leeme, ra me: ―¿Dxu ley? Ra me: ―Dlen Legióṉ, porni xtahl noꞌ we. ");
INSERT INTO zpg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","No ptzunñaad me Jesúz di cshahl me mbe-wé yahc ziht de uga. ");
INSERT INTO zpg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","No gahsh uga chehsh dahñ nu xtahl ngutzy-gayahgü, ");
INSERT INTO zpg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","were ptzunñaad mbenahcsy yahc Jesúz: ―Cshahliꞌ noꞌ ru nu ngutzy, no gdeedyiꞌ ñahz tzu noꞌ leeyâmaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","No bdee Jesúz ñahz gacu ze, no byruu mbenahcsy mpyquie-wé, bictzu yahcu ngutzy. No ma-rieꞌ yahc, por gyre maꞌ beeiy chohp mily maꞌ, tohzydzi byxuunn gyre maꞌ byrîbydahñ yâmaꞌ to ruꞌ zaꞌn xtâ lo nisdoo, no wé leññ nisdoo pycawy yâmaꞌ, guhty yâmaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Byxuunn gahc meññ-gayahp ngutzy, zigyne yâme meññ leññ guiedzy no meññ ni nu yahc dahñ. No güya meññ bigüieꞌ yâme bia leeu ni guhc. ");
INSERT INTO zpg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ru bydzihñ yâme ru zu Jesúz, bwieꞌ yâme mpyquie-wé ni güdahp xtahl mbenahcsy, dxie me no ba nutz shab me no ba nza xguîlriehñ me, no bydzie yâme. ");
INSERT INTO zpg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","No meññ-bwieꞌ yahc leeu, bie yâme diidz lo meññ ni guhc mpyquie-rieꞌ ni güyuꞌ mbenahcsy lee, no ni guhc ngutzy. ");
INSERT INTO zpg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","No guzlo ptzunñaad yâme Jesúz gyruu me de ru rtzoo yâme mdad. ");
INSERT INTO zpg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","No lóni gayuꞌ Jesúz leññ barcü, ptzunñaad mpyquie ni güyuꞌ mbenahcsy lee ndee Jesúz ñahz ña me ru za. ");
INSERT INTO zpg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per nehx bdee Jesúz ñahz, mazyg ra leeme: ―Gübiꞌ xiryuꞌy ru nu xfamilyiꞌ, no bie diidz lo yâme xnahc xroꞌ ni ptzoo Dioz no lii, no mod-bioob me lii. ");
INSERT INTO zpg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Luxu za mpyquie-rieꞌ, no guzlo bie me diidz lo meññ ni nu yahc gyre guiedzy lo ṟegióṉ ni le Decápolis xnahc xroꞌ ni ptzoo Jesúz no leeme. No ptzunadz gyre meññ-wé yahc. ");
INSERT INTO zpg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Gyzac ru güdedy Jesúz leññ barcü stiby chehsh nisdoo, bydohp xtahl meññ guingybi me no biaꞌn me coo nisdoo. ");
INSERT INTO zpg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tohzy bydzihñ to de lahd meññ-nu idoo xcargü, le Jair. No scâsy bwieꞌ me Jesúz bisshiby me lo, ");
INSERT INTO zpg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","no di rbiahz ni ganab me, ra me lee: ―Dindzabdxuuraꞌ ba gayehty. Güde, guidshob ñay chehsh me lehdy guiaḻ me, di gaty me. ");
INSERT INTO zpg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Were za Jesúz no leeme, no náḻt xtahl meññ leeme, lé raꞌñ yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lahd meññ yahc naꞌ, za to ngünaa ba rahp tzipychop ihz gayac-ure me de guidzngünaa. ");
INSERT INTO zpg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","No modni gazacno me ria me xtahl lo doctor, no ba bisree me gyre ni güdahp me, no nehx riaḻ xguîlguihdz me, aaḻ ma gayahcu. ");
INSERT INTO zpg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ru bieññ me bie meññ diidz de Jesúz‑e naꞌ, gübigy me ñaz-chehsh Jesúz lahd meññ yahc, no güdan me lo shab, ");
INSERT INTO zpg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","porni ganii leññ ihqy me, ne me: “Bâḻ canzaꞌ shabz me, ziaḻaꞌ we.” ");
INSERT INTO zpg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","No biandzie gahc xguîlguihdz me; no bieññ me ba biaḻ me. ");
INSERT INTO zpg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hor-wé gahc bieññ Jesúz byruu poder leeme ni rsiaḻ meññ. Were gubyguiat me no güliahz me gawieꞌ me lahd meññ, no ra me: ―¿Dxu güdan lo dshabaꞌ? ");
INSERT INTO zpg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ra xmeññ me leeme: ―Gawieꞌ gahquiꞌ gayaꞌñ meññ lii, no neꞌy: “¿Dxu güdan lo dshabaꞌ?” ");
INSERT INTO zpg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per gawieꞌ Jesúz guingybi me lehdy güieꞌ me dxu güdan lo shab me. ");
INSERT INTO zpg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Were ngüna-wé naꞌ, gadzie me lé rzîbyyoob me, no ba nann me bia guhc me, gübigy me no bisshiby me lo Jesúz, no ra me lee gyre ni uli. ");
INSERT INTO zpg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ra Jesúz leeme: ―Shiꞌñ, porni rlíladzyiꞌ naa, leewe ba biaḻiꞌ. Zaꞌgru güya naꞌ; ba biaḻiꞌ we de xguîlguihdziꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ganii ziaꞌ Jesúz ze, bydzihñ meññ ni byruu xiryuꞌ mpyquie-nu idoo xcargü ni zidne yahc, ra yâme leeme: ―Xindzabdxuuriꞌ ba guhty. ¿Par bia gazacnñaadriꞌ Muextr? ");
INSERT INTO zpg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Per nehx bylaby Jesúz ni ne yâme, ra me mpyquie-wé ni le Jair: ―Di gydziehbyiꞌ; bylíhzyladzyiꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","No nehx bdee me ñahz ña zrieñ meññ no leeme, nunzy Pedr, no Jacob no Juaṉ behtzy Jacob. ");
INSERT INTO zpg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bydzihñ me xiryuꞌ Jair, no bwieꞌ me nyetz meññ no gayuun meññ lé rquee riedz. ");
INSERT INTO zpg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Güyuꞌ me leññ yuꞌ, no ra me meññ-caḻ yahc: ―¿Bia nacu nyetz laꞌd no gayuun laꞌd zehdy mdid? Ndzabdxuur dac‑e guhty me, nishcahsy me we. ");
INSERT INTO zpg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aaḻ gaxidzyno yâme Jesúz. Per leeme naꞌ, güloo me gyre meññ stziuꞌ, no luxu güyuꞌ me no xtad ndzabdxuur no xmam no xmeññ me leññ yuꞌ ru nash ndzabdxuur. ");
INSERT INTO zpg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","No günahzy Jesúz ña ndzabdxuur, no ra me lee: ―Talita, cumi ―ni rnii ne: Ndzabdxuur, lii we gayapyaꞌ, biahsiꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","No biahs gahc ndzabdxuur no güzeꞌ gahc me, tzipychop ihz rahp me. No modni rtzunadz gyre meññ ru bwieꞌ yâme bispahñ Jesúz ndzabdxuur. ");
INSERT INTO zpg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Per ra Jesúz leeyâme, gax lâ gann, di gu yâmeu lo ndruhty. No ra gahc Jesúz leeyâme gdee yâme ni gahgü ndzabdxuur. ");
INSERT INTO zpg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Byruu Jesúz uga no za me ru nac xguiedzy me, no ziyno me xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","No dze-risladzy meññ guzlo galuu me meññ leññ idoo. Nu xtahl meññ uga, no ru bieññ yâme ni ganii Jesúz, rtzunadz yâme, no ra yâme: ―¿Báhx‑e byzeedy me gyre nirieꞌ yahc? ¿Biahx guîlnann‑e nirieꞌ ni rahp me, no milagür-rieꞌ yahc ni rtzoo me? ");
INSERT INTO zpg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Dâs‑e leeme carpinter, xiiñ Maríe no behtzy Jacob, no José, no Jud, no Simóṉ la? ¿Dâs‑e neꞌ zegahc nu meññ-byzan me no nó la? No nehx bylaby yâme ni rnii Jesúz lé bydziadzyno yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Per Jesúz naꞌ, ra leeyâme: ―To profet rzacbeeiy meññ lee gyre ru ria, per leññ gahc xguiedzy me ba yac, ni lahd xfamily me, per ni leññ xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","No di raḻ ntzoo me mbehty milagür uga, nunzy doozy meññ-gayac-ure psiaḻ me lee ru pshob ña me chehsh. ");
INSERT INTO zpg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","No rtzunadz Jesúz nehx bylíladzy yâme leeme. Luxu za me zrieñ guiedzy yahc ni nu gahsh de uga zigluu me meññ. ");
INSERT INTO zpg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","No pquee Jesúz riedz gydiby tzipychop xmeññ me no guzlo gashahl me chohp gá yâme, no ptzoo me leeyâme meññ ni beeiy ctzoo mdad gyruu mbenahcsy meññ. ");
INSERT INTO zpg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","No ra me leeyâme di tziyno yâme mbehty par lo ñahz, nunzy yagca; no di tziyno yâme bush, ni paṉ, ni medy. ");
INSERT INTO zpg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Beeiy yquee yâme xguidguial yâme nieꞌ yâme, per di tziyno yâme chohp shab yâme, nunzy ni nutz yâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","No ra me leeyâme: ―Rutisy gydzihñ laꞌd to yuꞌ, uga lâ tzu xtâ glo gyruu laꞌd leññ guiedzy-caḻ. ");
INSERT INTO zpg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","No bâḻ to guiedzy di gdee ñahz gydzihñ laꞌd no di ne yâme guieññ ni ru laꞌd la, lâ gyruu de uga no lâ cuihby yudé ni queꞌ nieꞌ laꞌd, lehdy gann yâme ni nahcsy‑e ptzoo yâme porni di ntzucas yâme laꞌd. Gapyaꞌ laꞌd ni uli, dze-gac xguîlnadz Dioz, ma xchoꞌ guîlné ni gabiahz meññ-guiedzy-wé que meññ-Sodom no meññ-Gomorr. ");
INSERT INTO zpg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Luxu byruu yâme zigyuno yâme meññ diidz lehdy csaan ni nahcsy ni nac. ");
INSERT INTO zpg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","No gaboo yâme xtahl mbenahcsy ni nu meññ, no güluꞌ yâme ceihd xtahl meññ-gayac-ure no psiaḻ yâme lee. ");
INSERT INTO zpg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bieññ ṟeiy-Herody ni gatzoo Jesúz, porni byzaꞌzy gayu meññ diidz gyre ni gatzoo Jesúz. No ne Herody: ―Juaṉ ni rchôbnihs‑e gübahñ de lahd mînguty gyzac, no leewe beeiyu leeme rtzoo me nirieꞌ yahc ni rtzunadz meññ lee. ");
INSERT INTO zpg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Zrieñ meññ ne: ―Profet-Elíaz‑e leeme ni güyuꞌ ba xtze. No zrieñ yâme ne: ―Profet‑e leeme, beeiy gahc profet yahc ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Per Herody naꞌ, hor-bieññ me nirieꞌ, ne me: ―Leeme we Juaṉ, ni ptzon mdad byruꞌ ihqy, naꞌ ba gübahñ me. ");
INSERT INTO zpg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Günii me ze porni ptzoo me mdad bygaꞌ Juaṉ, blihby yâme lee caden leññ lidzyguiib por xtoḻ Herodíaz ni nac tziahl behtzy gahcme Felipy. Ptzoo Herody ze, porni rahp me tziahl Felipy, beeiy tziahl gahcme. ");
INSERT INTO zpg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Porni gu Juaṉ Herody: ―Nehx xñahzu rahpiꞌ tziahl behtzy gahquiꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","No por leeu bydziadzyno Herodíaz Juaṉ, no racladzy me igaꞌdy me Juaṉ; per di raḻ ctzoo meu, ");
INSERT INTO zpg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","porni rdzie Herody Juaṉ, porni nann me nehx rtzoo Juaṉ cuentz nac no meññ-tziaawy Juaṉ, no leewe rla Herody leeme. No hor-rieññ Herody ru Juaṉ diidz, ba racngannu par Herody, per riuꞌladzy me guieññ me ni ru Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per bydzihñ to dzé we naꞌ, güdahpu to mód, ptzoo Herodíaz ni gucladzy me; dze-byzaꞌ Herody ihz, guhc xilni me, no bzaa yâme xtahl guîlrahgü ni güdahgü xmeññ me ni rsahc, no zrieñ xcomandant xsoldad me, no zrieñ meññ-rahc ni rnii yahc lahd meññ ni nu lo ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Güyuꞌ xindzabdxuur Herodíaz glaꞌy ru dxie yâme gayahgü yâme, no byeꞌ me, no byxilyno ṟeiy-Herody mod-ptzoo me, no zrieñ meññ-dxieno me lee. Were ra ṟeiy-Herody ndzabdxuur: ―Günab naa nitisy neꞌy, no naa gdedyaꞌu lii. ");
INSERT INTO zpg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","No bdee xtiidz me, ra me nzabdxur-rieꞌ: ―Nitisy gnabiꞌ naa, zdedyaꞌu lii nîcze ñahcu glaꞌy ru rtzon mdad. ");
INSERT INTO zpg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Luxu za ndzabdxuur, no ra me xmam me: ―¿Bia gnabaꞌ? Ra xmam me leeme: ―Günab leeme ihqy Juaṉ ni rchôbnihs. ");
INSERT INTO zpg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Gubyguiat gahc ndzabdxuur, za me ru dxie ṟeiy, no ra me lee: ―Racdadzyaꞌ ba gahc ndeedyiꞌ naa leññ to blad ihqy Juaṉ ni rchôbnihs. ");
INSERT INTO zpg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Modni bioobu ṟeiy; per gumm ba pcahbyladzy me ñaz-lo meññ-dxieno me lee ruꞌ miax la, ba nehx biuꞌladzy me ndedyu zehzy no ni günab ndzabdxuur. ");
INSERT INTO zpg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Luegü gahc pshahl ṟeiy to soldad biycaꞌ ihqy Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","No güya gahc soldad leññ lidzyguiib, bicchuꞌ ihqy Juaṉ, no güiyno meu leññ to blad no bdee meu ndzabdxuur; no wé ba bdeedyu cuaꞌ xmam. ");
INSERT INTO zpg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hor-gunn xmeññ Juaṉ nirieꞌ we naꞌ, güya yâme biycaꞌ yâme xcuerp Juaṉ no güiyno yâmeu biycaꞌdzy yâmeu leññ to baa. ");
INSERT INTO zpg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Byluxu bydohp xmeññ Jesúz ni güya ru pshahl Jesúz lee, no bie yâme diidz lo me gyre ni ptzoo yâme no gyre ni bluu yâme meññ. ");
INSERT INTO zpg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ra Jesúz leeyâme: ―Lâ te, tzo nó diby lad to ru ndruhty nehx nu, lehdy guisladzy laꞌd doozy. Porni za ziaad xtahl meññ, ba ni di riob gahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Were za yâme nunzy leeyâme to leññ barcü ru ndruhty nehx nu. ");
INSERT INTO zpg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Per xtahl meññ bwieꞌ za yâme no bzaclo leeyâme. No gyre guiedzy byruu meññ, za ngueeḻy gahc, no nier lee bydzihñ que leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ru byruu Jesúz leññ barcü, bwieꞌ me xtahl meññ no bioob me leeyâme, porni zidguiahc yâme beeiy xiily ni nehx rahp dxu güieꞌ lee; no guzlo galuu me meññ-rieꞌ yahc xtahl cos. ");
INSERT INTO zpg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hor-ba ma udzie we naꞌ, gübigy xmeññ me, ra yâme leeme: ―Neꞌ ba diby lad‑e leeu, no ba udzie. ");
INSERT INTO zpg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gu meññ-rieꞌ yahc tza yâme bahch ru gahsh o zrieñ guiedzy-yaañ ni nu gahsh de neꞌ lehdy ssii yâme paṉ, porni nehx rahp yâme ni gahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Were ra Jesúz leeyâme: ―Lâ gdee ni gahgü yâme. Ra yâme leeme: ―¿Per xnahcs ntzoo noꞌ? Rquihñu sahc xchieñ chohp gayuu xdzé dziiñ, lehdy nicshii noꞌ paṉ ni gahgü gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ra Jesúz leeyâme: ―¿Blac paṉ rahp laꞌd? Lâ dzigüieꞌ. Bylux bigüieꞌ yâme, ra yâme Jesúz: ―Rahp noꞌ gaay paṉ no chohp mbaḻ. ");
INSERT INTO zpg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Luxu ra Jesúz xmeññ me, ga yâme gyre meññ-caḻ yahc cuia yâme por cuib lo guix-ngay. ");
INSERT INTO zpg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Were gürie yâme por cuib, diby gayuu gá no cincuent gá guhc to cuib. ");
INSERT INTO zpg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Byluxu cuaꞌ Jesúz gydiby gaay paṉ-caḻ lo ña me no gyrop mbaḻ, no gülesy lo me gybaa, bdee me xquix Dioz, no ptzulaꞌy me paṉ, bdee meu xmeññ me lehdy quiiz yâmeu ycaꞌ meññ-caḻ yahc. No güdiiz me gyrop mbaḻ zegahc, cuaꞌ gyre meññ-dxie yahc uga. ");
INSERT INTO zpg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","No gyre yâme güdahgü glo bydzeꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","No luxu ptohp yâme tzipychop dzomby paṉ no mbaḻ ni biaꞌn. ");
INSERT INTO zpg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Meññ-mpyquie ni güdahgü, gaay mily yâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Luegü gahc ra Jesúz xmeññ me tzu yâme leññ barcü no tedy yâme stiby chehsh nisdoo sunier ga yâme, no gydzihñ yâme to guiedzy ni le Betsaida, eguiid Jesúz gashahl me meññ-bidyo leeme gybiꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","No bylux pshahl me meññ-caḻ yahc zia, güyehpy me chehsh to dahñ, zignab me lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hor-ba güyuꞌ guiaal‑e naꞌ, ba za barcü beeiy glaꞌy nisdoo, no Jesúz biaꞌn me lehzyme lo yudahñ coo nisdoo. ");
INSERT INTO zpg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","No bwieꞌ me xroꞌ dziiñ par gayisshuunn xmeññ me barcü, porni rxan gaxuu mbedun. Ba nchuulr‑e naꞌ, bydziñgahsh Jesúz ru za xmeññ me, gazeꞌ me xtziguia nzeꞌ lo nisdoo, no gucladzy me tedy gahcme lo yâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ru bwieꞌ yâme ziaad me gazeꞌ me xtziguia nzeꞌ, nlâdzyx yâme xguiaḻ meññ‑e no pquee yâme riedz; ");
INSERT INTO zpg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","porni gyre yâme bwieꞌ no gadzie yâme. Per ra me leeyâme: ―¡Di yqueꞌladzy laꞌd mbehty; naa we, di gydzie laꞌd! ");
INSERT INTO zpg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","No güyuꞌ me leññ barcü tohzy no leeyâme, no biandzie gahc mbedun. No modni rtzunadz yâme, ");
INSERT INTO zpg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","porni nehx gunn yâme xnahc ptzuxtahl me paṉ, no porni ndaagü xguîlriehñ yâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ru ba güdedy yâme stiby chehsh nisdoo, bydzihñ yâme to lo ṟegióṉ ni le Genesaret, no uga blihby yâme barcü ni ziyno yâme. ");
INSERT INTO zpg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ru byruu yâme leññ barcü, bzaclo gahc meññ-caḻ Jesúz, ");
INSERT INTO zpg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","no ngueeḻy gahc güya yâme byzaꞌzy, no guzlo gahc ziyno yâme meññ-gayac-ure lo camill, bydzihñ yâme gyzasy ru rieññ yâme nu Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","No rutisy za me, leññ guiedzy-yaañ yahc, o guiedzy-ro yahc, o leññ ru nu meññ dahñ la, rguihsh yâme meññ-gayac-ure coo ñahz, no rnab yâme leeme gdee me ñahz can yâme nîcze nieꞌ shab me; no gyre meññ-güdanu, biaḻ gahc yâme de xguîlguihdz yâme. ");
INSERT INTO zpg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bydohp meññ-nac yahc fariseu Jesúz, no zegahc lahd muextr ni ruuḻ yahc xleiy Moiséz, ni byruu Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","No bwieꞌ yâme lahd xmeññ Jesúz gayahgü no nehx güdihby ña yâme mod-zidseno gahc meññ-Isṟael, no por leeu byruu yâme contr xmeññ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Porni meññ-nac yahc fariseu no gyre zrieñ meññ-Isṟael, náḻ yâme mod-ne xcostumbr xtadgul yâme ni güyuꞌ yahc ba xtze, no leewe nehx zahgü yâme bâḻ di quiiby nier ña yâme xtahl vuelt. ");
INSERT INTO zpg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","No ru ribyguiat yâme de lóguiaꞌ, rtzoo yâme mod-zidseno gahc yâme, nier rahz yâme, no were rahgü yâme. No nu xtahl zrieñ costumbr-guhl ni rtzoo yâme, sca mod-rguihby yâme vas, no csiht, no vasij-guiib, no luꞌn.) ");
INSERT INTO zpg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","No leewe meññ-nac yahc fariseu no zrieñ muextr ni ruuḻ yahc xleiy Moiséz, ra yâme Jesúz: ―¿Bia nacu nehx rtzoo xmeññiꞌ mod-ne xcostumbr dtadgul nó ni güyuꞌ yahc ba xtze, mazyg rahgü yâme no nehx nye ña yâme? ");
INSERT INTO zpg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ra Jesúz leeyâme: ―Laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu, de lehbu we günii profet-Isaíaz de laꞌd, ru bzaa me lo Guehtzy ru queꞌ xtiidz Dioz, ne me: Meññ-rieꞌ yahc xtziguiasy‑e rzacbeeiy yâme naa, per xguîlmbahñ yâme, ziht nuw. ");
INSERT INTO zpg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mbahty nehx rquihñ ni rguguia yâme naa, porni rluu yâme meññ ni nehzy xguîlriehñ yâme. ");
INSERT INTO zpg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Porni rsaꞌn laꞌd ni rtzoo Dioz mdad ctzoo nó, no náḻ laꞌd xcostumbr-guhl meññ: mod-rguihby yâme csiht no vas ni riuꞌ ni goo yâme leññ; no nu xtahl zrieñ zâ niwé yahc ni rtzoo laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","No zegahc ra Jesúz leeyâme: ―¡Lâ güieꞌ xnahc‑e rsaꞌn laꞌd ni rtzoo Dioz mdad ctzoo meññ lehdy guisnáḻ laꞌd xcostumbr-guhl laꞌd! ");
INSERT INTO zpg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Porni Moiséz naꞌ ne me: “Bzacbeeiy xtadiꞌ no xmamiꞌ”, no zegahc ne me: “Dxu gyniwaty lo xtad o xmam la, gaty yâme.” ");
INSERT INTO zpg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Per laꞌd, ne laꞌd bâḻ ga to meññ xtad o xmam: “Nehx beeiy gacnon lii, porni gyre ni rapaꞌ ñacnon lii, ni le Corbáṉ‑e leeu” (ni rnii ne: to gun par Dioz‑e leeu); ");
INSERT INTO zpg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","no ne laꞌd zegahc, dxu gynii ze la, ba nehx rahp me de ni ñacno me xtad me o xmam me. ");
INSERT INTO zpg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","No mod-wé we rteedy laꞌd ni ne Dioz ze gâsy no xcostumbr-guhl laꞌd ni cuaꞌ laꞌd glo ba xtze diaa, no luxu rteedy laꞌdu meññ-nu ni naꞌ. No rtzoo laꞌd zrieñ xtahl beeiy leegahcu. ");
INSERT INTO zpg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","No ptohp Jesúz meññ-caḻ yahc gyzac, no ra me leeyâme: ―Lâ guieññ ni ren laꞌd, no lâ gann bia ne ni gayieññ laꞌd: ");
INSERT INTO zpg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Gyre ni rahgü meññ, dac‑e por leeu rtzoo meññ guîlquie. Mazyg ni rnii meññ no ni rtzoo meññ, wé we rahc guîlquie par leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Dxu racladzy guieññ bia ganin la, yquee ihqy yâme dtiidzaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ru byruu Jesúz lahd meññ no güyuꞌ me leññ yuꞌ, günabdiidz xmeññ me leeme bia we ni günii me ndaagü lo diidz. ");
INSERT INTO zpg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ra me leeyâme: ―¿Zegahc nehx rieññ laꞌdu la? ¿Nehx nann laꞌd la, ni rahgü meññ nehx beeiy ñahcu guîlquie par leeyâme? ");
INSERT INTO zpg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Porni nehx riuꞌu leññ xguîlmbahñ meññ, mazyg riuꞌu leññ meññ, no luxu rruuw de xcuerp meññ sto. No nirieꞌ günii me, gyre guîlrahgü nyeu we. ");
INSERT INTO zpg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","No zegahc ne Jesúz: ―Ni rnii meññ no ni rtzoo meññ, wé we ni rahc guîlquie par meññ. ");
INSERT INTO zpg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porni de leññ xguîlmbahñ meññ rruu guîlrieñ-nahcsy, ni rzeno yâme tziahl meññ, ni rzeno yâme nitisy dxu nehx tziahl yâme lee, guîlrgaꞌdy, ");
INSERT INTO zpg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","guîlgübaan, guîlrzîbyladzy, ni rahc yâme meññ-dirquihñ, ni risquiee yâme, ni rahp yâme vicy, ni rtzumvidy yâme, guîlrnii didz-waty contr zrieñ, ni rguguia yâme leegahc yâme, no guîlgydi xguîlriehñ. ");
INSERT INTO zpg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gyre ni nacsy-rieꞌ yahc rruuw leññ xguîlmbahñ meññ, no rahcu guîlquie par meññ. ");
INSERT INTO zpg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","No byruu Jesúz uga. Za me lo ṟegióṉ ru nu ciuda-Tiro no ciuda-Sidóṉ. Bydzihñ me xiryuꞌ to meññ, no nehx gucladzy me ñann ndruhty, per di ñaḻ ñuꞌ me ngaꞌdzy. ");
INSERT INTO zpg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Per gunn to ngünaa de leeme ni nu to mbenahcsy to xindzaꞌb. Güya gahc xmam ndzaꞌb no bisshiby me lo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ngüna-rieꞌ naꞌ, mbiuhz‑e leeme ni rnii didz-griegü, meññ-Sirofenisy‑e leeme. Ru bydzihñ me, günab me gboo Jesúz mbenahcsy ni nu xindzaꞌb me. ");
INSERT INTO zpg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Per Jesúz ra leeme: ―Bdee ñahz gahgü gax mbiux, porni nehx xñahzu gboo mu xpaṉ yâme no gdee mu leeu, gahgü mbahcü. ");
INSERT INTO zpg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Per ra ngüna-rieꞌ Jesúz: ―Uliu we Señor, per zegahc‑e xtâ mbahcü riuꞌ leññ miax, rahgü maꞌ ni rsiahb mbiux. ");
INSERT INTO zpg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Were ra Jesúz ngüna-rieꞌ: ―Xñahzu we güniiy. Ba beeiy gybiꞌy; mbenahcsy ba byruu xindzaꞌbiꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Were gübiꞌ me xiryuꞌ me, no bwieꞌ me xindzaꞌb me nashluꞌn, no ba byruu mbenahcsy lee. ");
INSERT INTO zpg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Gyzac byruu Jesúz lo ṟegioṉ-Tiro, no güdedy me lo ṟegioṉ-Sidóṉ no zrieñ guiedzy ni nu lo ṟegioṉ-Decápolis, no bydzihñ me nisdo-Galilea. ");
INSERT INTO zpg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Uga nu to mpyquie ni nguat no di raḻ gynii me zaꞌgndzi. Güiyno yâme leeme lo Jesúz, no günab yâme Jesúz cshob ña chehsh me lehdy guiaḻ me. ");
INSERT INTO zpg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Were güiyno Jesúz mpyquie-rieꞌ diby lad de lahd meññ, no güluꞌ ihqy ña me leññ gydiag mpyquie-rieꞌ, no luxu byxîbyshieñ me no güdan me luhdz mpyquie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Luxu bwieꞌ Jesúz gybaa no cuaꞌ lidzydoo me, no ra me mpyquie-rieꞌ: ―¡Efata! ―ni rnii ne: ¡Byxaliꞌ! ");
INSERT INTO zpg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","No byxal gahc gydiag mpyquie-rieꞌ ni nguat, no guctziaawy gahc luhdz me no günii me zaꞌgndzi. ");
INSERT INTO zpg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","No gu Jesúz leeyâme na di ga yâmeu ndruhty; per nîcze ma ra me meññ-caḻ yahc di gu yâme leeu, ma ru yâmeu lo meññ. ");
INSERT INTO zpg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","No modni rtzunadz gyre meññ, no ne yâme: ―Gyreu rtzoo me mos; xtâ meññ-nguat rshal me gydiag no risnii me meññ-ngop. ");
INSERT INTO zpg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Leññ dze-wé yahc gyzac bydohp xtahl meññ Jesúz, no nehx ziyno yâme ni gahgü yâme. Were ptohp Jesúz xmeññ me, no ra me leeyâme: ");
INSERT INTO zpg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Rioobaꞌ meññ-rieꞌ yahc, porni ba rahp tzonn dzé nu yâme no naa, no nehx rahp ni gahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","No bâḻ naa gapyaꞌ leeyâme gybiꞌ yâme no galahn yâme la, nre gan leeyâme lo ñahz‑e, porni lahd yâme byruu ziht. ");
INSERT INTO zpg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ra xmeññ me leeme: ―¿Per bá glo ndzial ni ñahgü yâme to ru beeiy neꞌ ru ndruhty nehx nu? ");
INSERT INTO zpg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Günabdiidz Jesúz leeyâme, ra me: ―¿Blac paṉ rahp laꞌd? Ra yâme leeme: ―Gahdzyu. ");
INSERT INTO zpg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Were ptzoo me mdad gürie gyre meññ-caḻ yahc lo yu; no cuaꞌ me gydiby gahdzy paṉ lo ña me no bdee me xquix Dioz. Byluxu, ptzulaꞌy meu no bdee meu cuaꞌ xmeññ me, lehdy güdiiz yâmeu cuaꞌ meññ-caḻ yahc. ");
INSERT INTO zpg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","No zegahc güdahp yâme chohp tzonn mbaḻ-yaañ. No bylux bdee Jesúz xquix Dioz por leeyâmaꞌ, zegahc ptzoo me mdad güdiiz xmeññ me leeyâmaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","No gyre yâme güdahgü glo bydzeꞌ yâme; no biaꞌn gahdzy dzomby ni bydzeꞌ ni ba nehx güdahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","No meññ-caḻ ni güdahgü yahc naꞌ, beeiy tahp mily yâme. Luxu ra Jesúz leeyâme gybiꞌ yâme, ");
INSERT INTO zpg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","no güyuꞌ gahc me leññ barcü no xmeññ me, no za me lo ṟegióṉ ni le Dalmanuta. ");
INSERT INTO zpg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bydzihñ meññ-nac yahc fariseu no guzlo gadeḻydiidz yâme no Jesúz; no lehdy nwieꞌ yâme bia beeiy rtzoo me, günab yâme ntzoo me to ni ngann ni nunzy Dioz beeiy rtzoo. ");
INSERT INTO zpg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Cuaꞌ lidzydoo Jesúz, no ra me: ―¿Biahx‑e nacu rnab meññ ni nu yahc ni naꞌ ñahc to ni ngann ni nunzy Dioz beeiy rtzoo? Gapyaꞌ laꞌd ni uli, ba nehx zwieꞌ meññ-ni naꞌ mbehty ni ngann ni ntzunadz yâme lee. ");
INSERT INTO zpg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Byluxu psaꞌn me leeyâme, no gyzac güyuꞌ me leññ barcü, no za me stiby chehsh nisdoo. ");
INSERT INTO zpg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Biaaḻladzy xmeññ Jesúz niyno yâme ni ñahgü yâme, nunzy to paṉ ziyno yâme leññ barcü. ");
INSERT INTO zpg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ra Jesúz leeyâme: ―Gax lâ güieꞌ; lâ gap laꞌd no ni nac meññ-fariseu no ni nac Herody, ni zidguiahc yahc beeiy levadur. ");
INSERT INTO zpg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","No ra saꞌ yâme: ―Günii me ze, porni di nidno nó paṉ. ");
INSERT INTO zpg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Per Jesúz naꞌ, nann me ni ganii xmeññ me. Were ra me leeyâme: ―¿Bia nacu ne laꞌd nehx rahp laꞌd paṉ? ¿Nehx ziaꞌ rieññ laꞌd no nehx nann laꞌd la? ¿Ndaagü xguîlriehñ laꞌd la? ");
INSERT INTO zpg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Rahp lo laꞌd, ¿no di rwieꞌ laꞌd la? No rahp gydiag laꞌd, ¿no di rieññ laꞌd la? ¿Nehx ritsêlou laꞌd la? ");
INSERT INTO zpg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Dze-güdiizaꞌ gaay paṉ güdahgü gaay mily meññ, ¿blac dzombyu bydzeꞌ ni biaꞌn ptohp laꞌd? Ra yâme leeme: ―Tzipychopu. ");
INSERT INTO zpg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―No dze-güdiizaꞌ gahdzy paṉ, güdahgü tahp mily meññ, ¿blac dzombyu bydzeꞌ ni biaꞌn ptohp laꞌd? Ra yâme leeme: ―Gahdzyu. ");
INSERT INTO zpg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Were ra me leeyâme: ―¿Nehx ziaꞌ rieññ laꞌd la? ");
INSERT INTO zpg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Byluxu bydzihñ yâme guiedzy-Betsaida, no güiyno meññ to mpyquie lo Jesúz, no mpyquie-rieꞌ ngaḻ lo me. No günab yâme cshob ña Jesúz chehsh me. ");
INSERT INTO zpg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Were günahzy Jesúz ña ngaḻ, no ziyno me lee diby lad de leññ guiedzy. Bylux byxîbyshieñ me lo, no pshob ña me chehsh lo, no günabdiidz me lee bâḻ beeiy rwieꞌ me behch. ");
INSERT INTO zpg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Guzlo ngaḻ gawieꞌ, no ra me Jesúz: ―Rwien meññ, rluu yâme beeiy yag-rgaꞌy, per ni gazeꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Gyzac pshob ña Jesúz chehsh lo mpyquie-rieꞌ, no bwieꞌ me mos, no biaḻ gahc me; ba gyreu rwieꞌ me zaꞌgndzi. ");
INSERT INTO zpg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Byluxu pshahl Jesúz leeme zia me xiryuꞌ me, no ra leeme: ―Na di guibyguiatiꞌ leññ guiedzy, no di gahbyiꞌ mbehty ndruhty. ");
INSERT INTO zpg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Byluxu güya Jesúz no xmeññ me zrieñ guiedzy-yaañ yahc ni nu lo ṟegióṉ ni le Cesarea de Filipo. Lóni za yâme lo ñahz naꞌ, günabdiidz me xmeññ me, ra me: ―¿Dxu we ne meññ naa? ");
INSERT INTO zpg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ra yâme leeme: ―Nu yâme ne Juaṉ ni pchôbnihs meññ‑e lii; zrieñ yâme ne Elíaz‑e lii ni güyuꞌ ba xtze; no zrieñ yâme ne dxuhch de lahd profet ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ra Jesúz leeyâme: ―Naꞌz laꞌd, ¿dxu we ne laꞌd naa? Ra Pedr leeme: ―Lii we nac Crist. ");
INSERT INTO zpg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Per ra Jesúz leeyâme na di ga yâme ndruhty mbehty de leeme. ");
INSERT INTO zpg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","No guzlo galuu Jesúz xmeññ me ra me, leeme we Mpyquie-Pshahl Dioz Lee no rahp me de ni tedy me xtahl guîlné, no zegahc mînguhl yahc ni nac guxtisy, no xjefy yahc bahl no muextr ni ruuḻ yahc xleiy Moiséz, zruu yâme contr leeme. No zgaꞌdy yâme leeme, per lo tzonn dzé zbahñ me gyzac. ");
INSERT INTO zpg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","No nirieꞌ günii meu nxal lo diidz. Were güiyno Pedr leeme diby lad no guzlo ganindush me bia nacu rnii Jesúz ze. ");
INSERT INTO zpg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Per Jesúz naꞌ biehqy me no bwieꞌ me xmeññ me, günindush me lo Pedr, ra me lee: ―¡Byruu diby lad de naa, bêndzab! Porni xguîlriehñiꞌ nehx rdeedyu tohzy no ni ne Dioz, mazyg rdeedyu tohzy no xguîlriehñ meññ. ");
INSERT INTO zpg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","No luxu pquee Jesúz riedz meññ gydibyno xmeññ me, no ra me leeyahc: ―Dxu racladzy gac dmeññaꞌ lee la, csaan gyre ni nahcsy ni nac, no gbooladzy xtâ xguîlmbahñ, no ctzoo ni ren. ");
INSERT INTO zpg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Porni dxu gacladzy guislaa xguîlmbahñ leegahc la, zniꞌdyu; per dxu gniꞌdy xguîlmbahñ por naa no por dtiidzaꞌ la, wé zahp guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Bá we nquihñu par to meññ ñahc xchieñ me gyre ni nu lo guiedzylie, no luxu nniꞌdy me xguîlmbahñ me? ");
INSERT INTO zpg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","No zegahc, ¿bia beeiy ndee to meññ lehdy nislaa xguîlmbahñ me? ");
INSERT INTO zpg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Porni dxu qytuno naa no dtiidzaꞌ ñaz-lo meññ-rieꞌ yahc ni nu ni naꞌ ni nehx rzobdiidz Dioz no rtzoo guîlquie, zegahc‑e naa, Mpyquie-Pshahl Dioz Lee, stuꞌn gynin dmeññaꞌ leeyâme dze-guiaḻaꞌ no gyre x‑ángel Dioz lo xguîlbyniꞌ dTadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Zegahc ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, nu lahd meññ-rieꞌ ni nu yahc neꞌ nehx zehty sinn güieꞌ mod-rtzoo Dioz mdad ni beeiyu lee gyreu. ");
INSERT INTO zpg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Güdedy shoꞌb dzé, güiyno Jesúz Pedr, Jacob no Juaṉ ihqy to dañ-suu lehzy yâme. Uga bwieꞌ yâme bydzee mod-nac lo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","No pycampytzeꞌ shab me, no gucnquitzybou. No nehx nu mbehty nquitzybo beeiy leeu, nîcze ma nguihby meññu. ");
INSERT INTO zpg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","No bwieꞌ yâme Elíaz no Moiséz ni güyuꞌ yahc ba xtze, gayu yâme diidz no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Were ra Pedr Jesúz: ―Muextr, ¡lehgxu zuu nó neꞌ! Gzaa noꞌ tzonn ṟamad: tohbyu par lii, stohbyu par Moiséz, no stohbyu par Elíaz. ");
INSERT INTO zpg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Xmeññ Jesúz naꞌ gadzie yâme, no nehx nann Pedr bia ganii. ");
INSERT INTO zpg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tohzydzi gúḻ to zá no bihtz ximbleu ru zu yâme, no lo za-wé bieññ to riedz ni ne: ―Nirieꞌ we dShiñaꞌ ni ndzin lee; lâ guieññ ni ga me laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hor-caḻ gahc, bwieꞌ yâme guingybi yâme, no ba ndruhty nehx bwieꞌ yâme, ba nunzy Jesúz zu no leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lóni gayaht yâme dahñ, ra Jesúz leeyâme na di gu yâme diidz lo ndruhty ni bwieꞌ yâme, xtâ glo leeme, Mpyquie-Pshahl Dioz Lee, ba gübahñ me de lahd mînguty. ");
INSERT INTO zpg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","No leewe nehx bie yâme diidz lo ndruhty, nîcze ganabdiidz saꞌ yâme biahx‑e leeu ni rbahñ meññ de lahd mînguty. ");
INSERT INTO zpg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Günabdiidz yâme Jesúz, ra yâme: ―¿Bia nacu ne muextr-ruuḻ yahc xleiy Moiséz nier Elíaz‑e guiaad? ");
INSERT INTO zpg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ra Jesúz leeyâme: ―Ni uli we leeu nier Elíaz‑e guiaad, no leeme guistziaawy gyreu. ¿No bia mód‑e naꞌ güyaa lo Guehtzy ru queꞌ xtiidz Dioz, de ni naa, Mpyquie-Pshahl Dioz Lee, zdeedyaꞌ xtahl guîlné no stzunéladzy meññ naa? ");
INSERT INTO zpg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Per naa gapyaꞌ laꞌd, Elíaz ba biahd me, no ptzoo meññ leeme gyre ni gucladzy yâme, mod-güyaa lo Guehtzy ru queꞌ xtiidz Dioz lguia ni gac me. ");
INSERT INTO zpg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ru gubyguiat yâme ru zu zrieñ xmeññ me we naꞌ, bwieꞌ yâme nu xtahl meññ guingybi xmeññ me, no lahd muextr ni ruuḻ yahc xleiy Moiséz gadeḻydiidz no leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Scâsy bwieꞌ gyre meññ-rieꞌ yahc Jesúz, modni gatzunadz yâme no byxuunn yâme bigynii yâme diux leeme. ");
INSERT INTO zpg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","No günabdiidz Jesúz leeyâme, ra me: ―¿De bia gadeḻydiidz laꞌd no dmeññ yahcaꞌ? ");
INSERT INTO zpg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","To lahd meññ-rieꞌ yahc ra leeme: ―Muextr, zidnon dñoobyaꞌ loꞌy, porni nu to mbenahcsy leeme, no psaꞌnu leeme ngop. ");
INSERT INTO zpg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","No rutisy rnahzyu leeme, rguiñguieu leeme lo yu; no rruu mboo ruꞌ me, no rahgü laiy me, no racnchuhg me. No günabaꞌ xmeññiꞌ mboo leeu leeme, per di ñaḻu leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ra Jesúz leeyâme: ―¡Laꞌd ni nu ni naꞌ, nehx rlíladzyt naa! ¿Xtâ buc rapaꞌ de ni tzun lahd laꞌd? ¿Xtâ buc beeiy ctibdadzyaꞌ laꞌd? Lâ guidno leeme neꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Were güiyno yâme ñobywiñ ru zu Jesúz. Per hor-bwieꞌ mbenahcsy Jesúz, tohzydzi bzoobu mbeꞌ ñobywiñ, no biahb me lo yu, gabihsh gado me no garuu mboo ruꞌ me. ");
INSERT INTO zpg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Günabdiidz Jesúz xtad ñobywiñ, ra me: ―¿Buc diaa rzahc me ze? Ra xtad ñobywiñ Jesúz: ―Glo nyaañ me; ");
INSERT INTO zpg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","no nehx rsaꞌn mbe-wé ni rsiahbu leeme lo gue o lo nzeꞌ, lehdy igaꞌdyu leeme. Per bâḻ beeiyu lii ctzooyu la, bioob noꞌ no gucno noꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ra Jesúz leeme: ―Bâḻ beeiyu lii gylíladzyiꞌ la, gyreu we beeiy no meññ ni rlíladzy naa. ");
INSERT INTO zpg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tohzy günii xtad ñobywiñ ndip, lé pquee me riedz: ―Naa rlídadzyaꞌ lii. ¡Gucno naa lehdy ma gylídadzyaꞌ! ");
INSERT INTO zpg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hor-bwieꞌ Jesúz ngueeḻy gadohp xtahl meññ, ptzoo me mdad mbenahcsy, no ra me lee: ―Mbenahcsy, lii rtzooy meññ ngop no nguat, naa gayapyaꞌ lii: byruu de ñobywiñ-rieꞌ, no ba di guibyguiat tzuriꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Were pquee mbenahcsy riedz ndip no gyzac bzoobu mbeꞌ ñobywiñ, no byruu gahcu de leeme. No rluu me beeiy ni guhty, xtâ ra xtahl yâme: ―Ba guhty me we. ");
INSERT INTO zpg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Per günahzy Jesúz ña me no gülesy leeme, no guzli gahc me. ");
INSERT INTO zpg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bylux güyuꞌ Jesúz leññ yuꞌ, günabdiidz xmeññ me leeme lehzy yâme, ra yâme: ―¿Bia nacu noꞌ di ñaḻ mboo noꞌ mbenacsy-wé? ");
INSERT INTO zpg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ra Jesúz leeyâme: ―Zâ mbenacsy-wé racladzyu gnab mu lo Dioz no ctzoo mu ayun, no were beeiy gboo mu leeu. ");
INSERT INTO zpg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ru byruu yâme uga, güdedy yâme lo ṟegioṉ-Galilea; no nehx gucladzy Jesúz ñann ndruhty, ");
INSERT INTO zpg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","porni galuu me xmeññ me, no ra me leeyâme: ―Naa Mpyquie-Pshahl Dioz Lee; zdee dxuhch naa lo ña meññ-rdziadzyno naa, no zgaꞌdy yâme naa, per lo tzonn dzé zbahñaꞌ gyzac. ");
INSERT INTO zpg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per di ñieññ yâme ni ganii me, no rdzie yâme gnabdiidz yâme leeme bia leeu günii me. ");
INSERT INTO zpg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","No bydzihñ Jesúz no xmeññ me guiedzy-Capernaum. Ru ba nu yâme leññ yuꞌ, günabdiidz Jesúz xmeññ me, ra me: ―¿Bia lguia gadeḻydiidz laꞌd hor-zioꞌb nó lo ñahz? ");
INSERT INTO zpg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Per nehx günii yâme mbehty; porni hor-ziaad yâme lo ñahz gadeḻydiidz yâme dxu de lahd yâme ma qysahc. ");
INSERT INTO zpg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Were gürie Jesúz no pquee me riedz gydiby tzipychop xmeññ me, no ra me lee: ―Bâḻ dxuhch racladzy ma qysahc la, rahp me de ni gac me scâsy ni ndruhty nehx nac lahd gyre zrieñ, no gac me scâsy xmós gyre zrieñ. ");
INSERT INTO zpg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Luxu biycaꞌ me to ñôbydxuur, no bzu me lee glaꞌy ru zu yâme. Luxu cuaꞌ me lee lo ña me, no ra me leeyâme: ");
INSERT INTO zpg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Bâḻ dxuhch, porni rzobdiidz naa, gacno to beeiy mbiux-rieꞌ la, scâsy ñacno yâme naa we; no dxu ycaꞌ dtiidzaꞌ la, dac‑e dtiidzaꞌ gacáꞌ yâme, mazyg gacáꞌ yâme xtiidz Dioz ni pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ra Juaṉ Jesúz: ―Muextr, bwieꞌ noꞌ to mpyquie ni ganii ley lehdy gboo me mbenahcsy meññ, per nehx ganzeno me nó. No ra noꞌ leeme ba di ctzoor me mod-wé, porni dac me ni ganzeno nó lee. ");
INSERT INTO zpg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Were ra Jesúz leeyâme: ―Di ycar laꞌd leeu leeme; porni ndruhty ni beeiy rtzoo to milagür hor-ganii dlen, nehx beeiy luegü gahc nnii ni nahcsy dcheshaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Porni dxu nehx néladzy nó la, gayacno me nó we. ");
INSERT INTO zpg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nitisy dxu gdee to vas nzeꞌ goo laꞌd por dlen, porni nac laꞌd dmeññaꞌ la, gapyaꞌ laꞌd ni uli, nehx znihty ni guiscady Dioz leeme. ");
INSERT INTO zpg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Nitisy dxu por xtoḻ guiatrxan to ni zidguiahc beeiy mbiux-rieꞌ ni rlíladzy yahc naa la, beeiydí nguꞌ meññ to duu yañ me no nlihby yâme to xguie-ro molin lou; luxu nráḻ yâme leeme leññ nisdoo. ");
INSERT INTO zpg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","No bâḻ ñay rquihlyu lii ctzooy guîlquie la, pchuꞌ leeu. Beeiydí tzuy ru gapiꞌ guîlmbahñ ni nehx zluhx no nrung ñay, no ba dac tzaꞌy infiern, queꞌ gyrop ñay, ru nehx ziuꞌ dzé guiee gue. ");
INSERT INTO zpg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Uga nehx rehty mpcuch yahc ni rahgü cuerp, no nehx riee gue. ");
INSERT INTO zpg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Bâḻ nieꞌy rquihlyu lii ctzooy guîlquie la, pchuꞌ leeu. Beeiydí tzuy ru gapiꞌ guîlmbahñ ni nehx zluhx no ndanguiꞌ, no ba dac tzaꞌy infiern, queꞌ gyrop nieꞌy, ru nehx ziuꞌ dzé guiee gue. ");
INSERT INTO zpg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Uga nehx rehty mpcuch yahc ni rahgü cuerp, no nehx riee gue. ");
INSERT INTO zpg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","No bâḻ to loꞌy rquihlyu lii ctzooy guîlquie, güloo leeu; beeiydí tzuy ru rtzoo Dioz mdad no tohzy loꞌy, no ba dac tzaꞌy infiern, queꞌ gyrop loꞌy. ");
INSERT INTO zpg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Uga nehx rehty mpcuch yahc ni rahgü cuerp, no nehx riee gue. ");
INSERT INTO zpg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Porni ziahb xgue guîlné lguia gyre meññ scâsy riuꞌ ziahd lo gyre gun par Dioz. ");
INSERT INTO zpg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ziahd, to ni mos‑e leeu; per bâḻ nnihty ni ndzihgu la, ¿xnahc beeiy ñacndzihgu gyzac? Zegahc laꞌd, lâ gac scâsy ziahd ni ndzihg ni beeiy yquihñ, no lâ tzu dzie tziaawy no saꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Byluxu byruu Jesúz uga, za me lo ṟegioṉ-Judea no zegahc za me stiby chehsh guiagü-Jordáṉ. No gyzac bydohp xtahl meññ leeme, no guzlo galuu me leeyâme mod-rtzoo gahc me. ");
INSERT INTO zpg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","No gübigy lahd meññ-nac yahc fariseu leeme, lehdy nsiahb yâme leeme no to ni ngann. Günabdiidz yâme leeme bâḻ beeiy ntzily to mpyquie guîltziahl no tziahl. ");
INSERT INTO zpg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ra Jesúz leeyâme: ―¿Bia ra Moiséz ctzoo laꞌd? ");
INSERT INTO zpg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ra yâme Jesúz: ―Bdee Moiséz ñahz gzaa to mpyquie ni ba bidzña to guehtzy ni gynii ba ptzily me guîltziahl, no gdee meu tziahl me, no luxu csaꞌn me lee. ");
INSERT INTO zpg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Were ra Jesúz leeyâme: ―Porni nahdy xguîlmbahñ laꞌd, leewe bzaa Moisézu ze ctzoo laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Per glo dze-guzlo güyaa guiedzylie, “Dioz bzaa me mpyquie no bzaa me ngünaa”. ");
INSERT INTO zpg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Leewe rruu to mpyquie coo xtad no coo xmam, no tzu me no tziahl me, ");
INSERT INTO zpg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","no ba gyrop yâme beeiy gahc tohzy meññ.” No leewe, ba dac‑e chohp meññ leeyâme, mazyg ba beeiy gahc tohzy meññ‑e leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","No leewe, ni ba ptzoo Dioz lee tohzy, di ctzily ndruhty leeu. ");
INSERT INTO zpg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ru ba güyuꞌ yâme leññ yuꞌ, günabdiidz xmeññ me leeme lguia nirieꞌ gyzac. ");
INSERT INTO zpg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ra Jesúz leeyâme: ―Nitisy dxu ctzily guîltziahl no tziahl, no guidzña me no sto ngünaa la, gatzoo me guîlquie chehsh ngünaa ni bidzña me nier lee. ");
INSERT INTO zpg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","No bâḻ to ngünaa ctzily me guîltziahl no tziahl me no guidzña me no sto mpyquie la, guîlquie gahc‑e zahcu par leeme. ");
INSERT INTO zpg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Güiyno meññ mbiux yahc lo Jesúz lehdy cu me laꞌy lee. Per xmeññ me ndush yâme lo meññ-zidno mbiux. ");
INSERT INTO zpg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hor-bwieꞌ Jesúz ni gatzoo xmeññ me, bydziaꞌdzy me, no ra me lee: ―Lâ gdee ñahz guiaad mbiux ni zidyo naa, no di yca laꞌd leeyâme; porni dxu gac scâsy mbiux-rieꞌ yahc la, par leeyâme we ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gapyaꞌ laꞌd ni uli, dxu di gap to guîlmbañ-nguhdzy scâsy xguîlmbahñ mbiux la, nehx beeiy tzu ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Luxu, güdiehdzy me mbiux-rieꞌ yahc, no pshob ña me chehsh, güluꞌ me laꞌy lee. ");
INSERT INTO zpg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lóni garuu Jesúz no ba za me gyzac, tohzy bydziñ-güxuunn to mpyquie, bisshiby lo me no günabdiidz, ra leeme: ―Muextr, naa nannaꞌ meññ-tziaawy lii. ¿Bia mód ntzon lehdy ñapaꞌ guîlmbahñ ni nehx zluhx? ");
INSERT INTO zpg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ra Jesúz leeme: ―¿Bia nacu rahbyiꞌ naa meññ-tziaawy? Ndruhty nehx meññ-tziaawy lee, mazyg nunzy Dioz. ");
INSERT INTO zpg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lii nanniꞌ ni rtzoo Dioz mdad ctzoo meññ: “Di senoy tziahl meññ. Di igaꞌdyiꞌ meññ. Di cuaniꞌ. Di gyniiy ni nehx uli de meññ. Di guisquieey. Bzacbeeiy xtadiꞌ no xmamiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ra mpyquie-rieꞌ leeme: ―Muextr, gyre nirieꞌ gatzon mod-ne glo nwiñaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Byluxu bwiedzie Jesúz leeme no guîlndzi, no ra leeme: ―Nu to ni riaadziꞌ: güya, ptoꞌ gyre ni rahpiꞌ, no bdee xmedyu ycaꞌ meññ-nehx rahp mbehty, were zahpiꞌ xtahl ni rsahc gybaa; luxu guiaadiꞌ, gbooladzyiꞌ xtâ xguîlmbahñiꞌ, no tzaꞌy no naa. ");
INSERT INTO zpg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mpyquie-rieꞌ naꞌ, modni bzacno me hor-bieññ me nirieꞌ, no güyuꞌ me trixd za me, porni rahp me xtahl ni rsahc. ");
INSERT INTO zpg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","No byluxu bwieꞌ Jesúz meññ-zu guingybi me, no ra me xmeññ me: ―¡Modni ngann zahcu no meññ ni rahp xtahl ni rsahc, ndee yâme ñahz ntzoo Dioz mdad leeyâme! ");
INSERT INTO zpg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","No ptzunadz xmeññ me no nirieꞌ ni günii me; per gyzac ra Jesúz leeyâme: ―Shiꞌñ, ¡ngannu we par meññ ni riehtz lo guîlṟicü, ndee yâme ñahz ntzoo Dioz mdad leeyâme! ");
INSERT INTO zpg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ma nehx ngann‑e ndedy to camell xguiehr igux que to meññ-ṟicü ndee me ñahz ntzoo Dioz mdad leeme. ");
INSERT INTO zpg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ru bieññ yâme nirieꞌ we naꞌ, ba ma gatzunadz yâme, no ra saꞌ yâme: ―¿Dxu we naꞌ beeiy gylaa par tzu lo xñahz Dioz? ");
INSERT INTO zpg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Bwiedzie Jesúz leeyâme, no ra leeyâme: ―Nehx ñaḻ ntzoo meññ nirieꞌ, per no Dioz beeiyu; porni no leeme gyreu we beeiy. ");
INSERT INTO zpg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Guzlo Pedr gaya me Jesúz: ―Per noꞌ ba psaꞌn noꞌ gyre ni güdahp noꞌ, no zo noꞌ ru zaꞌy. ");
INSERT INTO zpg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, nitisy dxu psaꞌn xiryuꞌ, behtzy o baḻ, byzan, xtad, xmam, tziahl, xiiñ, o xilyu por naa no por dtiidzaꞌ la, ");
INSERT INTO zpg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Dioz zdee leeme diby gayuu vuelt ma xtahl ni naꞌ lo tiemp-rieꞌ: xiryuꞌ, behtzy o baḻ, byzan, xmam, xiiñ, xilyu, nîcze ctzoo csahc meññ leeme zegahc; no dzé ni ziaad, Dioz zdee leeme guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Per xtahl meññ ni ma rsahc lahd meññ neꞌ la, zdzihñ dze-ma uxiee qysahc yâme; no xtahl meññ ni ma uxiee rsahc lahd meññ neꞌ, wé we ma qysahc. ");
INSERT INTO zpg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Za yâme Jerusaléṉ, no zunier Jesúz lo xmeññ me. No xmeññ me naꞌ, gatzunadz yâme, no zrieñ meññ-náḻ leeyâme gadzie. No gyzac güloo Jesúz gydiby tzipychop xmeññ me diby lad, no guzlo gaya me leeyâme gyre ni tedy me. ");
INSERT INTO zpg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ra me leeyâme: ―Sca-ze gawieꞌ laꞌd, zo nó Jerusaléṉ, no uga zdee dxuhch naa, Mpyquie-Pshahl Dioz Lee, lo ña xjefy yahc bahl no lo ña muextr ni ruuḻ yahc xleiy Moiséz. No znii yâme rapaꞌ de ni gatyaꞌ, no zdee yâme naa meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","No stzuburl yâme naa, no sshîbyshieñ yâme naa, no zguihñ yâme naa, no zgaꞌdy yâme naa; per lo tzonn dzé zbahñaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Luxu gübigy Jacob no Juaṉ, xiiñ Zebedeu, lo Jesúz, no ra yâme leeme: ―Muextr, racdadzy noꞌ ntzooy ni nnab noꞌ lii. ");
INSERT INTO zpg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ra Jesúz leeyâme: ―¿Bia racladzy laꞌd ntzon por laꞌd? ");
INSERT INTO zpg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ra yâme leeme: ―Dze-ba rtzooy mdad no xguîlbyniꞌy, ndeedyiꞌ ñahz mbia noꞌ to gá lad cooy, to noꞌ mbia xlad-drechiꞌ no sto noꞌ mbia xlad-ṟeveziꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ra Jesúz leeyâme: ―Nehx nann laꞌd bia rnab laꞌd. ¿Beeiyz ndedy laꞌd ni nadz ni dzictedyaꞌ, ni gac beeiy behch ni nlá ni goon lee la? ¿No beeiyz ndedy laꞌd ni ma nadz ni dzictedyaꞌ, ni gac beeiy ni gachôbnihs meññ naa per pur no guîlné la? ");
INSERT INTO zpg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ra yâme leeme: ―Beeiyu noꞌ. Ra Jesúz leeyâme: ―Ni dzictedyaꞌ no gzacnon lee, ni uli zegahc dzictedy laꞌdu; no ni ma nadz ni dzictedyaꞌ, zegahc dzictedy laꞌdu; ");
INSERT INTO zpg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","per dxu cuia dcoon lad-drech o lad-ṟevez la, dac‑e naa ndedy leeu; mazyg dxu ne Dioz ba nacu xchieñ, wé we ycaꞌ leeu. ");
INSERT INTO zpg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ru bieññ gydiby stzii xmeññ me nirieꞌ, bydziadzyno yâme Jacob no Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Per pquee Jesúz riedz leeyâme, no ra leeyâme: ―Nann laꞌd xnahc nac meññ-guxtisy ni rahc cuent rtzoo mdad xmeññ lo guiedzylie-rieꞌ; rtzoo yâme no xmeññ yâme gyre mod-ne yâme. No zrieñ xmeññ yâme ni rsahc la, ni rnii yâme, wé rahc. ");
INSERT INTO zpg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per no laꞌd dac‑e ze gacu, mazyg nitisy dxu de lahd laꞌd gacladzy qysahc, rahp de ni gac scâsy xmós laꞌd; ");
INSERT INTO zpg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","no nitisy dxu lahd laꞌd gacladzy ma qysahc que zrieñ la, rahp de ni gac scâsy to mós ni byzee par ctzoo xtziiñ gyre zrieñ meññ. ");
INSERT INTO zpg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Porni xtâ naa, Mpyquie-Pshahl Dioz Lee, nehx biaḻaꞌ lo guiedzylie-rieꞌ lehdy gacno meññ naa, mazyg biaḻaꞌ lehdy gacnon leeyâme, no gdedyaꞌ dguîlmbahñaꞌ, gatyaꞌ lehdy quixaꞌ gylaa xtahl meññ de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bydzihñ yâme ciuda ni le Jericó. No lóni garuu Jesúz Jericó no xmeññ me no zrieñ meññ yahc naꞌ, to meññ-ngaḻ le Bartimeu, xiiñ Timeu, dxie me coo ñahz, rnab me gun. ");
INSERT INTO zpg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hor-bieññ me gadedy Jesúz ni nac meññ-Nasaret, guzlo gaquee me riedz, ne me: ―¡Jesúz, lii ni ziaad de lo xfamily ṟeiy-Davit, bioob naa! ");
INSERT INTO zpg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Xtahl yâme byduhsh lo me lehdy tzudzie me, per leeme naꞌ, ma rahc me rquee me riedz, ne me: ―¡Lii ni ziaad de lo xfamily ṟeiy-Davit, bioob naa! ");
INSERT INTO zpg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Were güliahz Jesúz, no ra me: ―Lâ ga leeme guiaad me. Were pquee yâme riedz ngaḻ, no ra yâme leeme: ―Di gyruganiꞌ. Guzli, Jesúz gaquee riedz lii. ");
INSERT INTO zpg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","No güloo gahc ngaḻ lar-xoob chehsh, no biahs me lé cüchahs me, no za me ru zu Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","No ra Jesúz leeme: ―¿Bia racladzyiꞌ ctzon por lii? Ra ngaḻ leeme: ―Muextr, racdadzyaꞌ güien gyzac. ");
INSERT INTO zpg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ra Jesúz leeme: ―Ba beeiy tzaꞌy; bylíladzyiꞌ naa, leewe ba biaḻiꞌ. Lohg hor-caḻ byxal lo me bwieꞌ gahc me, no za me náḻ me ru za Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hor-ba gadzihñ yâme gahsh Jerusaléṉ, gadedy yâme schohp guiedzy ni le Betfagé no Betania, coo to dahñ ni le Oliv, ugaty ba pshahl Jesúz chohp de lo tzipychop xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ra me lee: ―Lâ tza guiedzy-yaañ ni dxie ru tedy ziaꞌr nó, no hor-gydzihñ laꞌd, güieꞌ laꞌd nliiby to burr-yaañ yahg, ni ndruhty ziaꞌ dgueññ cuib lee. Lâ cshac leemaꞌ no lâ guidno leemaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bâḻ dxuhch ga laꞌd: “¿Bia nacu gatzoo laꞌd ze?”, lâ ga leeme: “Señor‑e gaquihñ leemaꞌ, no luxu guidzguiat gahc me leemaꞌ sto.” ");
INSERT INTO zpg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Were za yâme, no bydzial yâme burr, nliiby maꞌ gahsh ruꞌ to puert lo ñahz, no uga pshac yâme leemaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","No lahd meññ-zu uga günabdiidz leeyâme, ra yâme: ―¿Biaz‑e gatzoo laꞌd? ¿Bia nacu gashac laꞌd burr-rieꞌ? ");
INSERT INTO zpg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ra yâme meññ-rieꞌ yahc mod-ra Jesúz leeyâme; no bdee meññ-rieꞌ ñahz tziyno xmeññ Jesúz burr. ");
INSERT INTO zpg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","No güiyno yâme leemaꞌ ru ziaad Jesúz, no pshob shab yâme chehsh maꞌ, no güdzib Jesúz leemaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","No xtahl meññ gatzihly shab yâme lo ñahz ru tedy Jesúz, no zrieñ yâme gaguihsh ṟam-yaañ ni rahp guix ni pchuꞌ yâme lo camp. ");
INSERT INTO zpg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","No meññ ni zunier, no zegahcu meññ ni náḻ yahc traz, rquee yâme riedz, ne yâme: ―¡Tzuguia Dioz! ¡Nu laꞌy mpyquie ni ziaad porni Dioz pshahl leeme! ");
INSERT INTO zpg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Nu laꞌy mod-dziguiahc mdad, mod-ptzoo ngydo-dadgul-Davit mdad nó! ¡Tzuguia Dioz ni nu gybaa! ");
INSERT INTO zpg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Bydzihñ Jesúz Jerusaléṉ, no güya me idoró. Ru bwieꞌ me gyre ni nu leññu, no gumm ba udziedoo la, za gahc me guiedzy-Betania no gydiby tzipychop xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ni byre guiaal, ru byruu yâme guiedzy-Betania, ba galahn Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bwieꞌ me xtâ ziht zu to yag-duug ni dziib guix lo, no güya me bigüieꞌ me duhn queꞌ lou. Hor-bydzihñ me nehx bydzial me duug lou, xguie guix dziib lou, porni nehx xtiémpu ni nqueꞌu. ");
INSERT INTO zpg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Were ra Jesúz yagdug-rieꞌ: ―¡Ba nehx ziuꞌr dze-gahgü ndruhty xduuguiꞌ! No bieññ xmeññ me günii me ze. ");
INSERT INTO zpg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hor-ba bydzihñ yâme Jerusaléṉ, güyuꞌ Jesúz leññ idoró, no guzlo güloo me meññ ni gatoꞌ no meññ ni gazii. No ptixguiat me xmiax meññ-rtzee xmedy meññ, no xbangü meññ ni rtoꞌ ximbue; ");
INSERT INTO zpg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","no ndruhty nehx bdee me ñahz lee tedy no behch ru rtzoo idoró mdad. ");
INSERT INTO zpg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","No rluu me meññ, no ra me lee: ―¿Nehx ziaad lo Guehtzy ru queꞌ xtiidz Dioz la, ru ne me: “Diryuꞌn, par gynino meññ naa we gacu, ni guiaad yahc de gyre guiedzy”? Mazyg laꞌd gatzoo laꞌdu beeiy to ru riungaꞌdzy meññ-gübaan. ");
INSERT INTO zpg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","No nirieꞌ bieññ xjefy yahc bahl no gahc muextr ni ruuḻ yahc xleiy Moiséz, no guzlo gayo yâme xnahc igaꞌdy yâme leeme; rdzie yâme leeme, porni gyre meññ rtzunadz de ni rluu me meññ. ");
INSERT INTO zpg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","No ru ba udziedoo, byruu me leññ guiedzy no xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ni byre guiaal rsily, güdedy yâme no bwieꞌ yâme gübihdzy yag-duug xtâ leññ yu. ");
INSERT INTO zpg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Were bitsêlou Pedr ni günii Jesúz, no ra me lee: ―Muextr, bwieꞌ güieꞌzyiꞌ yag-duug ni güluꞌy dia lee, ba gübihdzyu. ");
INSERT INTO zpg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ra Jesúz leeyâme: ―Lâ gylíladzy Dioz. ");
INSERT INTO zpg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gapyaꞌ laꞌd ni uli, bâḻ dxuhch ña dañ-rieꞌ: “Byruu de wé no biahb lo nisdoo”, no di rqueꞌladzy me mbehty leññ xguîlmbahñ me, mazyg gylíladzy me gac ni ne me, ni rnii me gacu we. ");
INSERT INTO zpg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","No leezuwe gapyaꞌ laꞌd, gyre ni gnab laꞌd hor-ganino laꞌd Dioz la, lâ gylíladzy laꞌd ba cuaꞌ laꞌdu, no zdee Diozu laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","No hor-ganab laꞌd lo Dioz, lâ csiaaḻladzy laꞌd guîlquie ni ptzoo zrieñ meññ no laꞌd, lehdy zegahc Dioz, ni nac xTad laꞌd lee ni nu gybaa, csiaaḻladzy me xguîlquie laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Per bâḻ di rsiaaḻladzy laꞌd guîlquie ni ptzoo meññ no laꞌd la, zegahc‑e xTad laꞌd ni nu gybaa nehx ssiaaḻladzy me guîlquie ni nzahby laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Byluxu gubyguiat yâme Jerusaléṉ gyzac. No lóni gadedy Jesúz ruꞌ idoró naꞌ, biahd xjefy yahc bahl, no muextr ni ruuḻ yahc xleiy Moiséz, no zrieñ mînguhl yahc ni nac guxtisy. ");
INSERT INTO zpg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ra yâme leeme: ―¿Dxu naquiꞌ par ctzooy gyre nirieꞌ? ¿No dxu guhdzy lii ctzooyu? ");
INSERT INTO zpg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ra Jesúz leeyâme: ―Zegahc rapaꞌ to ni gnabdiidzaꞌ laꞌd. No bâḻ ga laꞌd naa la, gapyaꞌ laꞌd dxu nacaꞌ par ctzon gyre nirieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Dxu pshahl Juaṉ lehdy bidchôbnihs me meññ? ¿Dioz ni nu gybaa la, o cuentz meññ? Naꞌz laꞌd, ¿bia ne laꞌd? ");
INSERT INTO zpg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Were ra saꞌ yâme: ―¿Biaz‑e naꞌ ga nó leeme? Bâḻ nó ga nó Dioz pshahl Juaṉ, za me nó: “¿Biaz nacu naꞌ di nlíladzy laꞌd leeme?” ");
INSERT INTO zpg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿O nehxni ña nó cuentz meññ‑e pshahl leeme? Per bydzie yâme meññ-guiedzy, porni gyre yâme rlíladzy Juaṉ ulihbu profet‑e leeme ni günii ni gu Dioz lee. ");
INSERT INTO zpg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","No leewe, ra yâme Jesúz: ―Nehx nann noꞌ. Were ra Jesúz leeyâme: ―Zegahc naa nehx zapyaꞌ laꞌd dxu nacaꞌ par ctzon gyre nirieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","No guzlo Jesúz günino me meññ-wé yahc ndaagü lo diidz, ra me leeyâme: ―Güyuꞌ to mpyquie, bdziib me blatzy to lo xroꞌ lyu, no ptahgü me guingybiu; luxu güdahñ me to guieryu ru gyxii blatzy, no bzaa me beeiy to yuꞌ ni nsuu lehdy ycuniꞌ xmeññ me ru gayahc dziiñ. ’No luxu bdee me lyu-rieꞌ zrieñ meññ-ctzoo dziiñu por glaꞌy, no leeme za me to ru ziht. ");
INSERT INTO zpg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Dze-ba gayahc xicüsech blatzy‑e naꞌ, pshahl me to xmós me ziycaꞌ ni ctzulaꞌy yâme de lo cüsech ru nu meññ-caḻ yahc ni gatzoo dziiñ. ");
INSERT INTO zpg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Per hor-bydzihñ me, aaḻ günahzy yâme leeme, güdihñ yâme leeme, no gubyguiat me zehzy. ");
INSERT INTO zpg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Gyzac pshahl xbixwaan lyu sto mós, za; wé pshadguie yâme lee, gülaꞌy yâme ihqy, no gu yâme lee didz-nahcsy. ");
INSERT INTO zpg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Were pshahl xbixwaan lyu sto mós, za; no nirieꞌ ba bgaꞌdy yâme lee; no mod-wé guhc no xtahl zrieñ mós; lahd yâme bydihñ no lahd yâme bgaꞌdy yâme lee. ");
INSERT INTO zpg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’No xbixwaan lyu rahp ziaꞌr me sto xmeññ me, merp xiiñ me ni ndzi me lee. Byluxu pshahl me lee, no ne me: “Stzoo yâme ni gynii me we, porni dshiñaꞌ leeme.” ");
INSERT INTO zpg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Per meññ-caḻ ni gatzoo yahc dziiñ naꞌ, ra saꞌ yâme: “Mpyquie-ziaad, leeme we ni guian-no gyrenac dziiñ dze-ba guhty xtad me; igaꞌdy nó leeme lehdy gac dixchieñ nó gyreu.” ");
INSERT INTO zpg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","No günahzy yâme leeme, bgaꞌdy yâme leeme, no bicsaaby yâme leeme stziuꞌ de lyu ru dziib blatzy. ");
INSERT INTO zpg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿Biaz‑e naꞌ ctzoo xbixwaan lyu-caḻ ni bdziib blatzy? Guiaad me no igaꞌdy me meññ-rieꞌ yahc, no gdee me lyu-wé ycaꞌ zrieñ meññ. ");
INSERT INTO zpg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Dgueññ guuḻ laꞌd lo Guehtzy ru queꞌ xtiidz Dioz la?, ru neu mod-rieꞌ: Guie ni di ne meññ-rzaa yuꞌ nquihñ, naꞌ lehbu ba nash squiñp ru raa guie ni ma rquihñ lehdy tzaa yuꞌ zaꞌgndzi. ");
INSERT INTO zpg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dioz ni rtzoo mdad, leeme we ptzoo leeu, no gatzunadz nó rwieꞌ nó leeu. ");
INSERT INTO zpg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Gucladzy meññ-caḻ yahc nnahzy yâme Jesúz, porni gunn yâme de leeyâme günii Jesúz nirieꞌ ni ndaagü lo diidz. Per wé naꞌ, gumm rdzie yâme meññ-guiedzy la, psaꞌn yâme leeme, no za yâme. ");
INSERT INTO zpg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Byluxu pshahl yâme lahd meññ-nac yahc fariseu no lahd xmeññ Herody, zignabdiidz yâme Jesúz, nwieꞌ yâme bâḻ nnii me behch lehdy ñuꞌ to mód nruu yâme contr leeme. ");
INSERT INTO zpg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bydzihñ meññ-rieꞌ, ra yâme Jesúz: ―Muextr, noꞌ nann noꞌ gyre ni rniiy ni uli we leeu, no nehx rlabyiꞌ ni ne meññ, porni nehx rwieꞌy meññ nunzy de xtziguia. Rluuy ni uli lguia ni racladzy Dioz ctzoo meññ. Leewe gu noꞌ: ¿Xñahzu we quix noꞌ mpuezd lo xṟeiy meññ-Ṟom la, o yac? ¿Rahp noꞌ de ni quix noꞌu la, o yac? ");
INSERT INTO zpg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per Jesúz naꞌ, nann me leeyâme we ni ne meññ-tziaawy lee nîcze nehx uliu. Were ra me leeyâme: ―¿Bia nacu riñlo laꞌd csiahb laꞌd naa no to ni ngann? Lâ gdee naa to medy-guiib lehdy güienu. ");
INSERT INTO zpg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","No bdee yâmeu, cuaꞌ meu; no ra me leeyâme: ―¿Dxu lo we nirieé, no dxu le queꞌ neé? Ra yâme leeme: ―Xchieñ Cézr ni nac xṟeiy meññ-Ṟom. ");
INSERT INTO zpg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Were ra me meññ-wé yahc: ―Lâ gdee Cézr ni nac xchieñ Cézr, no lâ gdee Dioz ni nac xchieñ Dioz. No ptzunadz yâme no ni günii me. ");
INSERT INTO zpg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Luxu güya meññ-nac yahc saduceu lo Jesúz; no meññ-rieꞌ yahc naꞌ, ne yâme nehx zbahñ mînguty, ra yâme leeme: ");
INSERT INTO zpg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Muextr, Moiséz bzaa me lo leiy, ne me: “Bâḻ to mpyquie rehty me no riaꞌn tziahl me, no nehx güdahp xiiñ la, behtzy gahcme guidzña no ngüna-rieꞌ lehdy gap xiiñ yâme xcuent behtzy me ni guhty.” ");
INSERT INTO zpg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Naꞌ hôrrieꞌ, güyuꞌ gahdzy meññ-mpyquie behtzy saꞌ yâme; no ni nac lguhl lahd yâme bidzña me, per guhty me no biaꞌn tziahl me nehx güdahp xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Were bidzña ni byrohp yâme no ngüna-wé, per guhty me no zegahc nehx güdahp xiiñ me. No zegahc guhcu ni bionn yâme. ");
INSERT INTO zpg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","No mod-wé glo byzaꞌ gydiby gahdzy yâme, no nehx güdahp xiiñ yâme. No luxu zegahc guhty ngüna-wé. ");
INSERT INTO zpg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naꞌz naꞌ, dze-gybahñ mînguty, ¿dxu de leeyâme gac tziahl ngüna-wé, porni gydiby gahdzy yâme bidzña no leeme? ");
INSERT INTO zpg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Were, ra Jesúz leeyâme: ―Nehx xñahzu ni ne laꞌd, porni nehx rzaclo laꞌd ni ne lo Guehtzy ru queꞌ xtiidz Dioz, no nehx nann laꞌd gyre mod-beeiyu Dioz. ");
INSERT INTO zpg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Porni dze-gybahñ mînguty, ba nehx zidzña meññ no nehx zdee meññ guîltziahl xiiñ, mazyg gac yâme beeiy ángel yahc ni nu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","No lguia ni gybahñ mînguty naꞌ, ¿dgueññ guuḻ laꞌd ni bzaa Moiséz lo guehtzy ru bwieꞌ me rdahl biaḻ lo yag-guiahtz la? Ne Moiséz ra Dioz leeme: “Naa we xDioz Braṉ, Isac no Jacop ni güyuꞌ yahc ba xtze.” ");
INSERT INTO zpg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","No Dioz naꞌ, dac‑e xDioz mînguty leeme, mazyg xDioz meññ-mbahñ‑e leeme. No leewe, nehx xñahzu mbehty gahc ni ne laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","To lahd muextr ni nann yahc xleiy Moiséz zaꞌgndzi bieññ me ni gaya meññ-rieꞌ yahc Jesúz no de ni psaꞌ Jesúz lo xtiidz yâme zaꞌgndzi; were gübigy me, no ra me Jesúz: ―¿Bia ni rtzoo Dioz mdad ctzoo nó ma rsahc de lo gyreu? ");
INSERT INTO zpg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ra Jesúz leeme: ―Ni rtzoo Dioz mdad ctzoo meññ, ni ma rsahc de lo gyreu la, leeu we nirieꞌ: “Bieññiꞌ, meññ-Isṟael: Nu tohzy ni rtzoo mdad, no leeme we Dioz ni rtzoo mdad nó. ");
INSERT INTO zpg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bzacbeeiy Dioz ni rtzoo mdad lii no gydo xguîlmbahñiꞌ, no gydo x‑almiꞌ, no gydo xguîlriehñiꞌ, no xtâ ru beeiyu lii.” Nirieꞌ we ni nier gahc lee de lahd ni rtzoo Dioz mdad ctzoo meññ. ");
INSERT INTO zpg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","No ni byrohpu beeiy gahc nirieꞌ: “Bintzi zâ-bynechiꞌ mod-ndzi gahquiꞌ lii.” Nehx nu zrieñ ni rtzoo Dioz mdad ctzoo meññ ni ma rsahc que gyrop nirieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ra muextr leeme ni ruuḻ xleiy Moiséz: ―Xñahzu ni güniiy, Muextr. No uliu mod-neꞌy. Nu tohzy Dioz, no nehx nu zrieñ dioz. ");
INSERT INTO zpg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","No racladzyu gzacbeeiy nó leeme no gydo dguîlmbahñ nó, no gydo dguîlriehñ nó, no gydo d‑alm nó, no xtâ ru beeiyu nó. No guîntzi dsâ-bynech nó mod-ndzi nó nó gahc. No nirieꞌ yahc‑e ma rsahc que gyre gun ni rdee meññ Dioz no ni rquee yâme gue ni gacnixye par leeme. ");
INSERT INTO zpg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ru bwieꞌ Jesúz günii muextr-ruuḻ xleiy Moiséz xñahzu, ra me lee: ―Nehx ziht nuy lehdy ctzoo Dioz mdad lii. Luxu bydzie yâme nnabdiidzr yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lóni galuu Jesúz meññ leññ idoró, ra me: ―¿Bia mód‑e ne muextr ni ruuḻ yahc xleiy Moiséz, xiiñ ṟeiy-Davit‑e Crist? ");
INSERT INTO zpg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Porni bisnii Spirt-Sant Davit gahc, ru ne me: Günii Dioz, ra me Señor ni rtzoo mdad naa: “Gürie dcoon lad-drech, xtâ glo ctzon gyre meññ-rdziadzyno lii, guisshiby yâme loꞌy.” ");
INSERT INTO zpg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davit gahc ra me ni nac Crist: “Señor ni rtzoo mdad.” No leewe, ¿bia mód‑e naꞌ ne meññ lguia ni nac Crist, xiiñ Davit‑e leeme? No xtahl meññ gayieññ ni ganii Jesúz, no gaxilyno yâmeu. ");
INSERT INTO zpg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lo hor-galuu Jesúz meññ, ra me: ―Lâ gap laꞌd no muextr ni ruuḻ yahc xleiy Moiséz. Riuꞌladzy yâme rzeꞌ yâme gutz yâme lar-duhñ ni rsahc. No hor-ganzeꞌ yâme leññ guiedzy, racladzy yâme gynii meññ diux leeyâme no xroꞌ guîlrzacbeeiy. ");
INSERT INTO zpg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","No ryo yâme ru ma mos rbia yâme leññ idoo ru rbia meññ-rsahc; no zegahc ryo yâme ru ma mos rbia yâme ru rotzie yâme no meññ. ");
INSERT INTO zpg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rboo yâme xyuꞌ ngünaviud, no sto lad ba zu yâme ruuḻ yâme laꞌy xtze, rluuw ulihbu meññ-tziaawy leeyâme. Per ma xroꞌ guîlné we ycaꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Dxie Jesúz gahsh ru dxie caj ru riuꞌ gun leññ xiydoró meññ-Isṟael, no gawieꞌ me mod-gaguꞌ meññ medy leññ caj. Xtahl meññ-ṟicü gaguꞌ xtahl medy. ");
INSERT INTO zpg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","No bydzihñ to ngüna-byzahby, güluꞌ me chohp medy-guiib ni uxiee rsahc. ");
INSERT INTO zpg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Were pquee Jesúz riedz xmeññ me, no ra me lee: ―Ni uli gapyaꞌ laꞌd, ngüna-rieꞌ ni viud lee ma xroꞌ gun bdee que gyre zrieñ meññ ni güluꞌ medy leññ caj; ");
INSERT INTO zpg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","porni gyre yâme bdee ni ba biaꞌn; per ngüna-rieꞌ naꞌ, pobr‑e leeme, no bdee me gyrenac ni rahp me, ni ndedydzé gahc me. ");
INSERT INTO zpg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Lóni byruu Jesúz idoró, to lahd xmeññ me ra leeme: ―¡Muextr, bwieꞌ gaññsiꞌ gyre guie-roob no yurob-weé yahc! ");
INSERT INTO zpg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Were ra Jesúz leeme: ―¿Rwieꞌy yurob-rieꞌ yahc la? Ni to guie di ziaꞌn chehsh sto guie. Gyreu we zdiñguie. ");
INSERT INTO zpg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Luxu, hor-dxie Jesúz chehsh dañ-Oliv ru nniꞌ idoró, günabdiidz Pedr leeme, no Jacob, no Juaṉ no Ndréz, lehzy yâme, ra yâme: ");
INSERT INTO zpg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Gu noꞌ buc gac nirieꞌ. ¿No bia señal güieꞌ noꞌ ni gdee diidz de ni ba dziguiahc gyreu? ");
INSERT INTO zpg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Guzlo Jesúz ra leeyâme: ―Gax lâ gann, na di guisquiee ndruhty laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Porni siahd xtahl meññ-gaquihñ dlen, gynii yâme leeyâme we nac Crist; no modé zisquiee yâme xtahl meññ. ");
INSERT INTO zpg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Per dze-guieññ laꞌd ba gadeḻy meññ byzaꞌzy, di gydzie laꞌd porni rahpu de ni gacu ze; per dac ziaꞌr‑e ba dzigynihty guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Porni to guiedzy zdeḻy no sto guiedzy, no to gobiern zdeḻy no sto gobiern; no zahc xu byzaꞌzy, no ziuꞌ guîlrlahn no zbiiñ meññ. Nirieꞌ gac dze-ba sulo gac gyrehzy ni nadz. ");
INSERT INTO zpg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Gax lâ gann, porni tziyno yâme laꞌd lo guxtisy, no iguihñ yâme laꞌd leññ idoo; no tziyno yâme laꞌd lo gobernador no lo ṟeiy porni nac laꞌd dmeññaꞌ; no mod-rieꞌ beeiy guno laꞌd dtiidzaꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Per antzy ni gynihty guiedzylie, rahp meññ de ni guno yâme meññ dtiidzaꞌ gyre guiedzy gydo lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","No dze-gynahzy yâme laꞌd no tziyno yâme laꞌd lo guxtisy, di cu ihqy laꞌd bia gynii laꞌd. Lâ gynii ni gdee Dioz gynii laꞌd lo hor-wé gahc; porni dac‑e laꞌd gynii, mazyg Spirt-Sant‑e guisnii laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","No behtzy gahc meññ zdee behtzy lehdy gaty, no zegahcu zdee xtad meññ xiiñ; no xiiñ meññ zruu yâme contr xtad yâme no xmam yâme lehdy gaty. ");
INSERT INTO zpg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Gyre meññ zdziadzyno laꞌd porni nac laꞌd dmeññaꞌ; per dxu rtibladzy xtâ glo gydibylgaa gyreu, wé we zlaa de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ru güieꞌ laꞌd to xroꞌ ni nahcsy ni rniꞌdy, de ni günii profet-Daniel ba xtze, no zuw ru nehx xilgaru (dxu ruuḻ guetzy-rieꞌ, guuḻu lehdy gann), were gyre meññ ni nu lo ṟegioṉ-Judea gxuunn yâme, gybiꞌ yâme guehsh. ");
INSERT INTO zpg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","No dxu dziib ihqy yuꞌ dze-wé, di guiaht me, no di tzu me leññ yuꞌ ycaꞌ me behch; ");
INSERT INTO zpg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","no dxu gatzoo dziiñ lo lyu, di guibyguiat me ruꞌ yuꞌ lehdy ycaꞌ me shab. ");
INSERT INTO zpg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Baazy dzii meññ-ngünaa ni nu de xcuidad o caꞌ mdo-yaañ leññ dze-wé yahc! ");
INSERT INTO zpg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lâ gnab lo Dioz di gac nirieꞌ lo tiemp-naḻ, ");
INSERT INTO zpg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","porni xroꞌ guîlrzacno we gac dze-wé yahc ni nehx ba güyuꞌ dzé guhc glo dze-bzaa Dioz guiedzylie, xtâ ni naꞌ, no ba nehx ziuꞌ dzé gacru. ");
INSERT INTO zpg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","No bâḻ Dioz ni rtzoo mdad nehx ptzundop me dze-wé yahc ni ziaad la, nehx nlaa ndruhty; per por xmeññ me ni güle me leeyahc, ba ptzundop meu. ");
INSERT INTO zpg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Bâḻ dxuhch ga laꞌd: “Lâ güieꞌ, mpyquie-nac Crist, leexme nu neé”, o “Lâ güieꞌ, leexme nu nuú”, di gylíladzy laꞌd ni ne yâme. ");
INSERT INTO zpg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Porni siahd meññ ni ga lee nac Crist, o ga lee nac profet, per nehx uliu; no stzoo yâme ni ngann yahc no zrieñ guîlrtzunadz, lehdy guisquiee yâme, bâḻ beeiyu, xtâ meññ ni ba güle Dioz lee. ");
INSERT INTO zpg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Gax lâ gann! Ba gahc gayapyaꞌ laꞌd‑e ni dziguiahc. ");
INSERT INTO zpg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Leññ dze-wé yahc, lux tiemp-caḻ ni gzacno meññ, zacncawy ncübidz no nehx zguꞌ mboo byniꞌ, ");
INSERT INTO zpg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","no ziahb mbial yahc de leññ gybaa, no zniꞌby gyre ni nu leññ gybaa. ");
INSERT INTO zpg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","No zwieꞌ yâme naa, Mpyquie-Pshahl Dioz Lee, guiaḻaꞌ lo zá no beeiyu naa gyreu no zidnon guîlbyni-ro. ");
INSERT INTO zpg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","No cshaalaꞌ d‑ángel yahcaꞌ, no dzictopaꞌ gyre meññ ni ba güleꞌn lee byzaꞌzy gydo lo guiedzylie, xtâ ru rruu gydap mbeꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Lâ gyzeedy nirieꞌ ni rahc no yag-duug: Dze-ba ziaad guix-yaañ lou la, ba nann laꞌd tiempleꞌñ‑e gadziñgahsh. ");
INSERT INTO zpg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","No mod-wé gahc‑e, dze-ba rwieꞌ laꞌd gayahc nirieꞌ, lâ gann gadziñgahsh dze-guiaḻaꞌ, beeiy ni ba zuun ruꞌ puert. ");
INSERT INTO zpg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gapyaꞌ laꞌd ni uli, gyre nirieꞌ gac antzy ni gaty meññ-nu yahc ni naꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Zdedy gybaa no guiedzylie, per ni ganin nehx zdedyu. ");
INSERT INTO zpg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Per dzé no hór ni gac nirieꞌ yahc, ndruhty nehx nann, ni ángel yahc ni nu gybaa, no zegahc naa nehx nannaꞌ; nunzy dTadaꞌ, wé nann buc gacu. ");
INSERT INTO zpg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Gax lâ gann, lâ güieꞌ no lâ gnab lo Dioz; porni nehx nann laꞌd buc gydzihñ hór. ");
INSERT INTO zpg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nirieꞌ zidguiahc beeiy to mpyquie ni ba nu par tza to ru ziht, rsaꞌn me diidz no xmós me lehdy gap yâme xiryuꞌ me. No to to yâme bdee me dziiñ ni ctzoo, no ra me meññ-rahp ruꞌ puert güieꞌ me zaꞌgndzi. ");
INSERT INTO zpg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","No leewe ren laꞌd, gax lâ güieꞌ, porni nehx nann laꞌd buc guiaad xbixwaan yuꞌ, bâḻ zidtzu guiaal, o glaꞌy guiaal, o zidnchuulr, o rsily; ");
INSERT INTO zpg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","duhn tohzydzi guiaad me, no na di aaḻ gydzial me laꞌd nishcahsy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ni gapyaꞌ laꞌd, gapyaꞌnu gyre meññ: ¡Gax lâ güieꞌ! ");
INSERT INTO zpg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gayaadz chohp dzé ni gac lni-Pascü, dze-rahgü meññ paṉ ni nehx rahp levadur. Xjefy yahc bahl naꞌ no zrieñ muextr ni ruuḻ yahc xleiy Moiséz, gayo yâme xnahc gynahzy yâme Jesúz ngaꞌdzy gá, lehdy igaꞌdy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Per ne yâme: ―Nehx znahzy nó leeme lo lni, lehdy di gybiiñ meññ-guiedzy. ");
INSERT INTO zpg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Güya Jesúz guiedzy-Betania, xiryuꞌ to mpyquie ni le Simóṉ ni biudz lady. Lóni dxie Jesúz ruꞌ miax, bydzihñ to ngünaa no to frascü ni güyaa no guie ni le alabastro, no nu to ceitnixye leññu ni güyaa no ni le nardo ni nehx nutz mbehty no ni modni xguiaꞌ. Gülaꞌy ngüna-rieꞌ ruꞌ frascü no güluꞌ me ceihd ni nu leññu ihqy Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lahd meññ-dxie uga bydziaꞌdzy yâme, no ra saꞌ yâme: ―¿Bia nacu bynihty ceit-rieꞌ xleꞌzy? ");
INSERT INTO zpg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Beeiy ndoꞌu sahc xchieñ tzonn gayuu xdzé dziiñ, lehdy ñacnou meññ-pobr. No gyrehzy ganii yâme de ngüna-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Per Jesúz ra me: ―Lâ gdee ñahz ngüna-rieꞌ. ¿Bia nacu gatziaꞌdzy laꞌd leeme? Mos‑e nirieꞌ ni gatzoo me naa. ");
INSERT INTO zpg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Meññ-pobr, tirgahc‑e nu yâme lahd laꞌd, no beeiy gacno laꞌd leeyâme hortisy gacladzy laꞌd; per naa nehx ziunon laꞌd tirgahc. ");
INSERT INTO zpg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ngüna-rieꞌ ptzoo me ni beeiy leeme. Ba güluꞌ me nirieꞌ ni nixye dladyaꞌ antzy ni igaꞌdzyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gapyaꞌ laꞌd ni uli, rutisy gu meññ dtiidzaꞌ lo guiedzylie lehdy gylaa meññ de lo guîlnadz ni ziaad la, zegahc zu yâme diidz ni ptzoo ngüna-rieꞌ, lehdy guitsêlou meññ leeme. ");
INSERT INTO zpg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","No Jud-Iscariot naꞌ, to lahd gydiby tzipychop xmeññ Jesúz, güya me lo xjefy yahc bahl lehdy gdee me Jesúz lo ña yâme. ");
INSERT INTO zpg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ru bieññ xjefy bahl nirieꞌ naꞌ, rxihly yâme, no ptzoo yâme diidz gdee yâme medy ycaꞌ Jud; no xtâ glo dze-caḻ ba guzlo gayo Jud to mód lehdy gdee me Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Primer dzé ni nac lni-Pascü, leeu we dze-rahgü meññ paṉ ni nehx rahp levadur, dze-rgaꞌdy yâme xiily ni rdee yâme gun Dioz, ra xmeññ Jesúz leeme: ―¿Bá glo racladzyiꞌ tzo noꞌ dziguistziaawy noꞌ gyreu lehdy gotziey ni rahc lo lni-Pascü? ");
INSERT INTO zpg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Were pshahl Jesúz chohp xmeññ me, no ra me lee: ―Lâ tza ciuda, no uga güieꞌ laꞌd to mpyquie ni ziyno to rieꞌ nzeꞌ. Ba náḻ laꞌd leeme, ");
INSERT INTO zpg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","no ru tzu me, ga laꞌd xbixwaan yuꞌ mod-rieꞌ: “Ze ne Muextr: ¿Bia leññ yuꞌ we ru gotzien no dmeññaꞌ ni rahc lo lni-Pascü?” ");
INSERT INTO zpg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Uga gluu me laꞌd to leññ yu-ro sto pis guia ni ba nu puexd. Uga lâ guistziaawy gyreu lehdy gotzie nó. ");
INSERT INTO zpg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Were byruu xmeññ Jesúz za yâme leññ guiedzy, no guhc gyre mod-ra Jesúz leeyâme. No uga bistziaawy yâme gyre ni rahc lo lni-Pascü. ");
INSERT INTO zpg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hor-güyuꞌ guiaal‑e naꞌ, bydzihñ Jesúz no gydiby tzipychop xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lóni dxie yâme ruꞌ miax‑e naꞌ gayahgü yâme, ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, to lahd laꞌd ni gayahgü no naa gdee me naa lo ña meññ-rdziadzyno naa. ");
INSERT INTO zpg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Güyuꞌ yâme trixd, no guzlo ganabdiidz yâme leeme, to por to yâme ra: ―¿Dac naa la? No sto me ra: ―¿Dac naa la? ");
INSERT INTO zpg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ra Jesúz leeyâme: ―Leeme we to de lahd gydiby tzipychop laꞌd ni gagunihs xpaṉ no naa tohzy leññ blad. ");
INSERT INTO zpg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Naa, Mpyquie-Pshahl Dioz Lee, rapaꞌ de ni tedyaꞌ gyre ni ganii lo Guehtzy ru queꞌ xtiidz Dioz de naa. Per ¡baazy dzii de mpyquie-gdee naa lo ña meññ-rdziadzyno naa! Ma mos‑e di ñahl me. ");
INSERT INTO zpg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lóni gayahgü yâme naꞌ, cuaꞌ Jesúz paṉ lo ña me no bdee me xquix Dioz. Luxu, ptzulaꞌy meu, no bdee meu cuaꞌ xmeññ me, no ra me leeyâme: ―Lâ ycaꞌ nirieꞌ, dcuerpaꞌ we leeu. ");
INSERT INTO zpg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Luxu cuaꞌ me to cop lo ña me, no bylux bdee me xquix Dioz, bdee meu xmeññ me, no güee gyre yâme ni nu leññu. ");
INSERT INTO zpg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","No ra me leeyâme: ―Nirieꞌ we drieñaꞌ ni no lee rdee Dioz diidz nu sto mod-coby par tzu meññ tohzy no leeme, no gyxieꞌu par xtahl meññ hor-gatyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gapyaꞌ laꞌd ni uli, ba nehx zibyguiat gooraꞌ nirieꞌ ni riaa no blatzy xtâ dze-ba diaa nun ru rtzoo Dioz mdad, were goon nicoby. ");
INSERT INTO zpg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bylux biiḻy yâme himn, byruu yâme, za yâme dañ-Oliv. ");
INSERT INTO zpg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Hor-ba bydzihñ yâme, ra Jesúz leeyâme: ―Gyre laꞌd csaꞌn naa guial-rieꞌ, porni lo Guehtzy ru queꞌ xtiidz Dioz neu: “Igatyaꞌ mpyquie-gayahp xiily, no gyre xiily gyraꞌdz.” ");
INSERT INTO zpg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per lux gybahñaꞌ, sunieeraꞌ lo laꞌd tzan lo ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Were ra Pedr leeme: ―Nîcze gyre yâme csaꞌn lii, per naa nehx ssanaꞌ lii. ");
INSERT INTO zpg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ra Jesúz leeme: ―Gapyaꞌ lii ni uli, guial-rieꞌ gahc‑e, dgueññ ziaꞌ cuiadz rig ni gyropu, lii ba tzonn vuelt güniiy nehx rzacloꞌy naa. ");
INSERT INTO zpg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Per Pedr naꞌ ma gaya leeme: ―Nîcze gatyaꞌ no lii, per nehx zapyaꞌ di rzacloꞌn lii. No gyre yâme günii mod-ne gahc Pedr. ");
INSERT INTO zpg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Luxu, za yâme to lgar ru le Getsemaní, no ra Jesúz xmeññ me: ―Lâ cuia neꞌ gahc, eguiid naa gnabaꞌ lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","No ziyno me Pedr no Jacob no Juaṉ, no guzlo gayuꞌ me trixd no gazacno me. ");
INSERT INTO zpg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","No ra me meññ-rieꞌ yahc ni ziyno me: ―Leññ dguîlmbahñaꞌ nu to xroꞌ guîltrixd, lé rluuw gatyaꞌ. Lâ guiaꞌn neꞌ, no lâ cuianáꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Luxu, za Jesúz stoozy zit-yaañ no bisshiby lé güdihsh ihqy me lo yu, no günab me lo Dioz bâḻ ñahcu ni ñaḻ nehx ndzihñ hor-wé ni dzictedy me ni nadz. ");
INSERT INTO zpg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","No ra me: ―DTad-mosaꞌ, gyreu we beeiy no lii. Bislaa naa de lo ni nadz ni gabiahz naa; per dac‑e gac ni gynin, mazyg ni gyniiy‑e. ");
INSERT INTO zpg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Luxu, gubyguiat me ru biaꞌn guionn xmeññ me, no bwieꞌ me nishcahsy yâme. Ra me Pedr: ―Simóṉ, ¿gagahsyiꞌ la? ¿Di ñaḻ dxi mbianáꞌy no naa ni diby hór la? ");
INSERT INTO zpg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lâ cuianáꞌ no lâ gnab lo Dioz, lehdy di ctzoo laꞌd ni racladzy bêndzab. Xguîlmbahñ laꞌd racladzy ctzoo ni nac xñahzû, per xcuerp laꞌd nehx rtibladzy. ");
INSERT INTO zpg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","No gyzac za me, zignab me lo Dioz, no günii me ni günii gahc me primer. ");
INSERT INTO zpg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ru gubyguiat me, gyzac bwieꞌ me nishcahsy xmeññ me, porni bydzeꞌ mpcaaḻ lo yâme. No dgann yâme bia ga yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ni bionn ni gubyguiat me ru biaꞌn xmeññ me, ra me leeyâme: ―¿Gagahsy ziaꞌr laꞌd no gayisladzy ziaꞌr laꞌd la? Ba wé gâsy, ba bydzihñ hór ni ba nac diidz gdee meññ Mpyquie-Pshahl Dioz Lee lo ña meññ-guîlquie. ");
INSERT INTO zpg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lâ guiahs, tzoꞌ. Lâ güieꞌ, ba gadziñgahsh mpyquie ni gdee naa. ");
INSERT INTO zpg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ganii ziaꞌ Jesúz ze, tohzy bydzihñ Jud, ni lee nac to lahd gydiby tzipychop xmeññ Jesúz, bydziñno me xtahl meññ ni zidno yahc spad no garrot, ni pshahl xjefy yahc bahl no muextr ni ruuḻ yahc xleiy Moiséz no zrieñ mînguhl yahc ni nac guxtisy. ");
INSERT INTO zpg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jud naꞌ, ni gdee Jesúz lo ña meññ, ba bdee me to señ, ra me meññ-ziyno me lee: ―Dxu ycurun lee, wé we leeme; wé lâ gynahzy lee, no lâ tziyno leeme di gylaa me. ");
INSERT INTO zpg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","No scâsy bydzihñ me, gübigy gahc me, ra me Jesúz: ―¡Muextr! No pcuruꞌ me lee. ");
INSERT INTO zpg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Were günahzy yâme Jesúz lehdy tziyno yâme lee. ");
INSERT INTO zpg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Per to lahd meññ-zu uga güloo xispad me, no güloo me rid to xmós xjefy gyre bahl, pchug me to gydiag. ");
INSERT INTO zpg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ra Jesúz meññ-günahzy leeme: ―¿Zidnot spad no garrot lehdy gynahzy laꞌd naa beeiy to meññ-gübaan la? ");
INSERT INTO zpg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gyre dzé güyun ruꞌ idoró no laꞌd, blun meññ, no nehx günahzy laꞌd naa. Per nirieꞌ gayahcu ze, lehdy gac ni ganii lo Guehtzy ru queꞌ xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lo hor-wé byxuunn gyre xmeññ Jesúz, no psaꞌn yâme leeme lehzyme. ");
INSERT INTO zpg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nunzy to ñobyxtohby náḻ ru ziyno yâme leeme, no nuud me tohzy lahr. No günahzy yâme leeme, ");
INSERT INTO zpg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","per byruu me leññ lahr, no byxuunn me gaꞌy lady me. ");
INSERT INTO zpg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Güiyno yâme Jesúz lo xjefy gyre bahl; no bydohp zrieñ xjefy yahc bahl, no mînguhl yahc ni nac guxtisy no muextr ni ruuḻ yahc xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","No náḻt Pedr ziht gá glo güyuꞌ me lo xpaty xiryuꞌ xjefy gyre bahl, no gürie me lahd meññ-rahp ruꞌ idoró, gatzeꞌladzy yâme coo gue. ");
INSERT INTO zpg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Xjefy yahc bahl no gyre meññ-nac guxtisy gayo yâme dxu gynii contr Jesúz lehdy tzu mód gaty me; per nehx bydzial yâmeu. ");
INSERT INTO zpg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","No xtahl meññ ganii ni nehx uli contr leeme, per nehx cue-saꞌ ni günii yâme. ");
INSERT INTO zpg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","No lahd gahc meññ-rieꞌ guzli yahc, gayisquiee, ne: ");
INSERT INTO zpg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Noꞌ, bieññ noꞌ günii me: “Naa iguiñguien idoro-rieꞌ ni bzaa meññ lee, no lo tzonn dzé gzan stohbyu, no ba dac‑e meññ gacno tzaau.” ");
INSERT INTO zpg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per nîcze günii meññ-rieꞌ ze, nehx cue-saꞌ ni günii yâme. ");
INSERT INTO zpg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Were guzli xjefy gyre bahl lahd yâme, no günabdiidz me Jesúz, ra me: ―¿Nehx neꞌy mbehty la? ¿Bia leeu nirieꞌ ni rnii yâme chehshiꞌ? ");
INSERT INTO zpg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mazyg Jesúz biandzie me, no nehx günii me mbehty. Per xjefy gyre bahl naꞌ gyzac günabdiidz leeme, ra: ―¿Lii we nac Crist, Xiiñ Dioz-nu laꞌy la? ");
INSERT INTO zpg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ra Jesúz leeme: ―Naa. No zwieꞌ laꞌd naa, Mpyquie-Pshahl Dioz Lee, dxien xlad-drech Dioz ni beeiyu lee gyreu. No güieꞌ laꞌd guiaḻaꞌ lo zá ni gyruu gybaa. ");
INSERT INTO zpg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Were güdiix shab xjefy gyre bahl porni gadziaꞌdzy me, no ra me: ―¿Bia mazy racdadzy nó tzu dxu gynii? ");
INSERT INTO zpg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ba bieññ laꞌd günii me didz-nahcsy contr Dioz. ¿Bia ne laꞌd naꞌ? No gyre yâme günii rahp me doḻ no rahp me de ni gaty me. ");
INSERT INTO zpg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lahd yâme guzlo gaxîbyshieñ leeme. Ptahgü yâme lo me no güdihñ yâme leeme, no ra yâme leeme: ―¡Günii dxu güdihñ lii! No meññ-rahp yahc ruꞌ idoo güdahp lo me. ");
INSERT INTO zpg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedr naꞌ dxie me lo paty, tohzy bydzihñ to xicriad xjefy gyre bahl. ");
INSERT INTO zpg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","No ru bwieꞌ me Pedr gatzeꞌladzy coo gue, bwiedzie me lee, no ra me lee: ―Lii zegahc güyuꞌy tohzy no Jesúz ni nac meññ-Nasaret. ");
INSERT INTO zpg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Per Pedr naꞌ, günii me “yac”, no ra me ngüna-rieꞌ: ―Nehx rzacloꞌn leeme, no nehx nannaꞌ de bia ganiiy. No byruu me stziuꞌ ruꞌ ru riuꞌ yâme. No güriedz gahc rig. ");
INSERT INTO zpg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bwieꞌ criad Pedr uga, no gyzac guzlo gaya me zrieñ meññ yahc uga: ―Mpyquie-rieꞌ, to lahd xmeññ Jesúz‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Per gyzac günii Pedr “yac”, ne me nehx rzaclo me Jesúz. No stoozy hór meññ-nu yahc uga gyzac ra yâme Pedr: ―Ulihbu we to lahd xmeññ mpyquie-rieꞌ lii; porni meññ‑Galilea lii, no rniiy beeiy gahc rnii yâme. ");
INSERT INTO zpg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aaḻ guzlo Pedr ganiwaty me, no bzaꞌd me le Dioz, no ne me: ―¡Nehx rzacloꞌn mpyquie-rieꞌ ni ganii laꞌd de lee! ");
INSERT INTO zpg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tohzydzi güriedz rig ni byrohpu. No bitsêlou Pedr ni ra Jesúz leeme: “Dgueññ ziaꞌ cuiadz rig ni gyropu, lii ba tzonn vuelt güniiy nehx rzacloꞌy naa.” No por mod-wé, guzlo biin me. ");
INSERT INTO zpg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Naabz gayuꞌ byniꞌ bydohp xjefy yahc bahl, no zrieñ mînguhl yahc ni nac guxtisy, no muextr ni ruuḻ yahc xleiy Moiséz no zrieñ meññ-nac guxtisy, ptzoo yâme diidz. No ziyno yâme Jesúz nliiby, no bdee yâme leeme lo ña Pilat. ");
INSERT INTO zpg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ra Pilat leeme: ―¿Lii we xṞeiy meññ-Isṟael la? Ra Jesúz leeme: ―Lii we neu. ");
INSERT INTO zpg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","No xjefy yahc bahl naꞌ, gyrehzy ganii yâme contr Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Gyzac ra Pilat leeme: ―¿Nehx neꞌy mbehty la, no gyre ni rnii yâme contr lii? ");
INSERT INTO zpg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Per Jesúz ba nehx günii me mbehty; no leewe ptzunadz Pilat. ");
INSERT INTO zpg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lo lni-Pascü naꞌ, rislaa Pilat to meññ-nyagü lidzyguiib, nitisy dxu gnab meññ gylaa. ");
INSERT INTO zpg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","To mpyquie ni le Barrabáz, nyagü me lidzyguiib gydibyno zrieñ meññ-rdeḻy yahc ni bgaꞌdy meññ dze-pquelo yâme gobiern. ");
INSERT INTO zpg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","No bydzihñ xtahl meññ, guzlo ganab yâme Pilat ctzoo me mod-rtzoo gahc me, guislaa me to meññ-nyagü lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ra Pilat leeyâme: ―¿Racladzy laꞌd guislaan xṞeiy meññ-Isṟael la? ");
INSERT INTO zpg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Porni nann me por guîlmvidy‑e bidno xjefy yahc bahl Jesúz lo me. ");
INSERT INTO zpg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per xjefy yahc bahl pquihly yâme meññ-xtahl gnab yâme guislaa Pilat Barrabáz. ");
INSERT INTO zpg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ra Pilat leeyâme gyzac: ―¿Biaz naꞌ racladzy laꞌd ctzon no ni ra laꞌd lee xṞeiy meññ-Isṟael? ");
INSERT INTO zpg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ra yâme lé rquee yâme riedz: ―¡Pquee leeme lo cruzy! ");
INSERT INTO zpg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ra Pilat leeyâme: ―¿Per bia ni dirquihñ ptzoo me? Per leeyâme naꞌ, ma rquee yâme riedz, ne yâme: ―¡Pquee leeme lo cruzy! ");
INSERT INTO zpg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","No Pilat, gumm racladzy me ctzoo me ni ganii meññ-rieꞌ yahc la, bislaa me Barrabáz. Bylux ptzoo me mdad bydihñ Jesúz, no bdee me lee lehdy gaty lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","No ziyno soldad Jesúz lo paty leññ palacy, ru ne yâme pretorio, no ptohp yâme gyre zrieñ soldad. ");
INSERT INTO zpg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","No bguhtz yâme Jesúz to lar-morad, no bzaa yâme to coron-guiahtz ni bdziib yâme ihqy me. ");
INSERT INTO zpg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Luxu guzlo gatzoo yâme beeiy ni ganii diux leeme, no ra yâme leeme: ―¡Nehx zehty xṞeiy meññ-Isṟael! ");
INSERT INTO zpg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","No rguihñ yâme to var ihqy me, no rxîbyshieñ yâme leeme, no bisshiby yâme lo me beeiy ni gazacbeeiy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bylux ptzuburl yâme leeme, güloo yâme lar-morad ni bguhtz yâme leeme, no bguhtz yâme shab gahcme, no ziyno yâme leeme ru yquee yâme leeme lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bydzil-lo yâme to mpyquie ni le Simóṉ lóhgni byruu me dahñ, xguiedzy me le Ciren, xtad Lejandr no Ṟufo. Günahzy yâme leeme, biee me xcruzy Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Güiyno yâme Jesúz to ru le Gólgota, ni rnii ne: Xilgar Calaver. ");
INSERT INTO zpg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","No bdee yâme vin leeme ni nutz to ceitnixye ni le mirra, ñoo me; per nehx güee meu. ");
INSERT INTO zpg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","No hor-ba pquee yâme leeme lo cruzy, cuaꞌ soldad shab me, no güloo yâme suert lehdy bwieꞌ yâme dxu xlad guiaꞌn cad tohbyu. ");
INSERT INTO zpg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Guhc beeiy las-nuevy yudzé, pquee yâme Jesúz lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","No diidz ni bzaa yâme uga rnii bia nacu gaty me, neu: “XṞEIY MEÑÑ-ISṞAEL.” ");
INSERT INTO zpg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","No zegahc pquee yâme chohp meññ-gübaan lo zrieñ cruzy coo ru queꞌ Jesúz, to me lad-drech no sto me lad-ṟevez. ");
INSERT INTO zpg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","No guhcu mod-rnii lo Guehtzy ru queꞌ xtiidz Dioz, ru neu: “No pteedy yâme leeme por meññ-nzahby guîlquie.” ");
INSERT INTO zpg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","No meññ-rdedy yahc uga lé rquee yâme riedz, rtzuburl yâme, rchaḻ ihqy yâme, no ra yâme leeme: ―Lii ni ne nguiñguie xiydoró Dioz, no lo tzonn dzé nzaayu gyzac, ");
INSERT INTO zpg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","bislaa lii gahc, no biahtiꞌ lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","No zegahcu xjefy yahc bahl no zrieñ muextr ni ruuḻ yahc xleiy Moiséz rtzuburl yâme leeme, no ra saꞌ yâme: ―Zrieñ meññ bislaa me lee, per naꞌ di raḻ guislaa me leegahcme. ");
INSERT INTO zpg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Guiaht Crist we lo cruzy naꞌ, ni nac xṞeiy meññ-Isṟael, lehdy güieꞌ nó no gylídadzy nó! No gyrop meññ-queꞌ lo cruzy no leeme rtzuburl leeme zegahc. ");
INSERT INTO zpg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hor-bydzihñ ribygue naꞌ, güyuꞌ guibcawy gydo lo guiedzylie no xtâ las-trez udzie. ");
INSERT INTO zpg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","No lo hor-wé, las-trez, pquee Jesúz riedz-ndip, ne me: ―Eloi, Eloi, ¿lama sabactani? ―ni rnii ne: TDiozaꞌ, tDiozaꞌ, ¿bia nacu psaꞌniꞌ naa tohgaꞌ? ");
INSERT INTO zpg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lahd meññ-zu yahc uga, hor-bieññ yâme ni günii me, ra yâme: ―Lâ guieññ, gaquee me riedz profet-Elíaz. ");
INSERT INTO zpg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","No byxuunn to lahd yâme biglunihs me to sponj lo vinagyr, no pquee me leeu ihqy beeiy to gobgui, no bdee meu goo Jesúz, no ra me: ―Lâ gdee ñahz güieꞌ nó bâḻ guiaad Elíaz glety leeme lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Per Jesúz naꞌ, gyzac pquee me riedz ndip, no guhty gahc me. ");
INSERT INTO zpg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","No bygaax lar-rsaagü glaꞌy idoró xtâ guia no xtâ lo yu, no byruuw chohp laꞌy. ");
INSERT INTO zpg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","No capitaṉ-ṟoman ni zu lo Jesúz, hor-bwieꞌ me mod-pquee Jesúz riedz no guhty, ra me: ―Uli gahcxu we Xiiñ Dioz‑e mpyquie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Zegahc zu meññ-ngünaa uga, ziht gá gawieꞌ yâme. Lahd yâme zu Maríe-Magdalen, no Maríe xmam Jacob ni lwiñ no José, no Salomé. ");
INSERT INTO zpg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Meññ-ngüna-rieꞌ yahc náḻ yâme Jesúz, no gucno yâme leeme dze-güyuꞌ me lo ṟegioṉ-Galilea. Zegahc nu zrieñ meññ-ngünaa uga, xtahl yâme, ni güya Jerusaléṉ tohzy no leeme. ");
INSERT INTO zpg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ba udziedoo we, dze-rzaa meññ-Isṟael gyre ni yquihñ yâme par dze-risladzy yâme, no guial-wé rizlo xguîlrisladzy yâme. ");
INSERT INTO zpg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","No lo hor-wé bydzihñ to mpyquie ni le José, xguiedzy me le Arimatea, no rahc cuent leeme lahd xjefy meññ-Isṟael no rsahc ni rnii me, no zegahc gabiahz me dze-ctzoo Dioz mdad. Nehx bydzie me, güya me, ra me Pilat bâḻ beeiy gdee ñahz glety me xcuerp Jesúz lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat naꞌ, nlâdzy me mbahñ ziaꞌ Jesúz‑e; were pshalcaꞌ me capitáṉ, no ra me lee bâḻ ba guhty Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hor-ra capitáṉ leeme gyreu, were bdee me ñahz glety José xcuerp Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Were bicshii José to lar-ro ni mos, no bylux gülety me xcuerp Jesúz, pchaḻ me lee lahr. Luxu, biycaꞌdzy me lee leññ to baa ni bydahñ chehsh guie coo to guielaꞌ, no ptiꞌx me to guie lehdy ptahgü me ruꞌ baa. ");
INSERT INTO zpg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maríe-Magdalen, no Maríe xmam José, bwieꞌ yâme bá glo bygaꞌdzy Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Güdedy dze-risladzy meññ‑e naꞌ, Maríe-Magdalen, no Salomé, no Maríe xmam Jacob, güxii yâme ceitnixye lehdy dziglu yâmeu xcuerp Jesúz. ");
INSERT INTO zpg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","No rsilydoo naꞌ, hor-zidlahñ ncübidz primer xdzé seman, güya yâme ruꞌ xbaa me. ");
INSERT INTO zpg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","No gaya saꞌ yâme: ―¿Dxuz‑e naꞌ gboo guie ni nyagü ruꞌ xbaa me? ");
INSERT INTO zpg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per hor-gülesy lo yâme, bwieꞌ yâme guie-ro ni nyagü ruꞌ baa, ba nehx zuw xilgaru. ");
INSERT INTO zpg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hor-güyuꞌ yâme leññ baa, bwieꞌ yâme to ñobyxtohby ni nac x‑ángel Dioz, dxie me lad-drech, nutz me to larduñ-quitzy; no bydzie yâme. ");
INSERT INTO zpg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Per ra me ngüna-rieꞌ yahc: ―Di gydzie laꞌd. Laꞌd gayo laꞌd Jesúz ni nac meññ-Nasaret, ni pquee yâme lee lo cruzy. Leeme ba gübahñ, nehx nu me neꞌ. Lâ güieꞌ ru güdihsh yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Per lâ tza no lâ ga xmeññ me, no ni le Pedr: “Tza Jesúz lo ṟegioṉ-Galilea, sunier ga me lo laꞌd. No uga güieꞌ laꞌd leeme, mod-ba ra me laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Were byruu meññ-ngüna-rieꞌ yahc ruꞌ baa, gaxuunn yâme porni gadzie yâme, lé rzîbyyoob yâme de dzieeby. No nehx gu yâme mbehty ndruhty, porni rdzie yâme. ");
INSERT INTO zpg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Bylux de ni gübahñ Jesúz rsily ni nac primer xdzé seman, leegaññme bydzihñ ru zu Maríe-Magdalen, no nier leeme bwieꞌ me Jesúz. Leeme we ni güloo Jesúz lee gahdzy mbenahcsy. ");
INSERT INTO zpg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","No güya ngüna-rieꞌ, bicsieññ me xmeññ Jesúz, ni nu yahc trixd no gayuun. ");
INSERT INTO zpg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","No meññ-rieꞌ yahc naꞌ, hor-bieññ yâme mbahñ Jesúz no bwieꞌ Maríe-Magdalen leeme, nehx bylíladzy yâme. ");
INSERT INTO zpg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Byluxu, Jesúz gaññ bydzihñ ru za chohp xmeññ me lo ñahz ni ria dahñ, per bwieꞌ yâme Jesúz ba gydze mód nac me. ");
INSERT INTO zpg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","No güya yâme bigyne yâme zrieñ xmeññ me; per meññ-rieꞌ yahc naꞌ, zegahc nehx bylíladzy yâme ni ra leeyâme. ");
INSERT INTO zpg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Luxu Jesúz gaññ bydzihñ ru nu gydiby tzipyto xmeññ me lo hor-dxie yâme gayahgü yâme. Günindush me lo yâme porni nahdy xguîlmbahñ yâme no porni nehx bylíladzy yâme meññ-bwieꞌ leeme ba gübahñ me. ");
INSERT INTO zpg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","No ra me leeyâme: ―Lâ tza gydo lo guiedzylie, no lâ dzigyuno dtiidzaꞌ gyre meññ. ");
INSERT INTO zpg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dxu rlíladzy dtiidzaꞌ no gyrôbnihs la, wé we zlaa de lo guîlnadz ni ziaad; per dxu nehx rlíladzy dtiidzaꞌ, wé rahp de ni gaty. ");
INSERT INTO zpg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Meññ ni rlíladzy naa, stzoo yâme ni ngann zâ nirieꞌ yahc: Por dlen zboo yâme mbenahcsy meññ; znii yâme gydze diidz; ");
INSERT INTO zpg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bâḻ nnahzy yâme mbaaḻ lo ña yâme, o ñoo yâme ni rahp venen, nehx zahc yâme mbehty; cshob ña yâme chehsh meññ ni gayac-ure, no ziaḻ. ");
INSERT INTO zpg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesúz ni rtzoo mdad naꞌ, bylux günino me xmeññ me, biahs me zia me gybaa, no gürie me coo Dioz lad-drech. ");
INSERT INTO zpg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","No xmeññ me za zigyuno xtiidz me byzaꞌzy. No Jesúz gahc ni rtzoo mdad, racno leeyâme; no ni ngann yahc ni rtzoo yâme rdee diidz, ni gayuno yâme meññ, ni uli we leeu. Modé gacu.");
INSERT INTO zpg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nu xtahl meññ ni ba guzlo rzaa lo guehtzy ni guhc dlahd noꞌ, no riuꞌladzy yâme yqueꞌ gyreu merp mod-guhcu; ");
INSERT INTO zpg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","meññ ni bwieꞌ yahcu glo guzlou bluu yâmeu noꞌ, no bieno yâmeu meññ lehdy byraꞌdzu byzaꞌzy. ");
INSERT INTO zpg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naa zegahc günabdiidzaꞌ mod-nac nieꞌ xñahzu xtâ glo ru guzlou, par gunnaꞌ gyreu. No zegahc biuꞌdadzyaꞌ bzanu zaꞌgndzi, lehdy cshaalaꞌu loꞌy, Teófil, lii ni modni rsahc ni rnii, ");
INSERT INTO zpg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","lehdy ganniꞌ zaꞌgndzi ni nac ni uli de ni bluu yâme lii. ");
INSERT INTO zpg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dze-nac Herody ṟeiy lo ṟegioṉ-Judea, güyuꞌ to bahl ni le Sacaríaz, ni rahc cuent lee de lo xigrup Abíaz. Tziahl me le Elisabet, xiiñ bahl ni ziaad de lo xfamily gahc to bahl ni güyuꞌ le Aróṉ. ");
INSERT INTO zpg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Gyrop yâme meññ-tziaawy lee ñaz-lo Dioz, no di rdzial mbehty ni nahcsy chehsh yâme porni rtzoo yâme gyre ni ne Dioz no ni ne xleiy me. ");
INSERT INTO zpg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nehx güdahp xiiñ yâme, porni nehx gudy xiiñ Elisabet dze-miꞌñ ziaꞌ leeyâme, no ba mînguhl gyrop yâme. ");
INSERT INTO zpg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","To dzé ru byleꞌ xigrup Sacaríaz ni nac yahc bahl par ctzoo yâme xtziiñ Dioz leññ idoró, ");
INSERT INTO zpg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","biahbt suert lguia Sacaríaz par tzu me, yquee me gue ni nixye. No ni rtzoo bahl tzcaḻ, dxu guiahb suert lguia la, wé we yquee gue ni nixye leññ xiydoró Dioz. Were güyuꞌ Sacaríaz zictzoo me dziñ-wé. ");
INSERT INTO zpg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","No xtahl meññ-guiedzy biaꞌn stziuꞌ gahc, ganino yâme Dioz, lóni gaquee me gue ni nixye leññ idoo. ");
INSERT INTO zpg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tohzy bwieꞌ Sacaríaz to x‑ángel Dioz zu xlad-drech ltar ru rqueꞌ gue ni nixye. ");
INSERT INTO zpg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Hor-bwieꞌ Sacaríaz ángel‑e naꞌ, lîc biaadz me no modni bydzie me. ");
INSERT INTO zpg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Were ra ángel leeme: ―Di gydziehbyiꞌ, Sacaríaz. Dioz ba bieññ ni günabiꞌ. Ba guidtap tziahliꞌ Elisabet to mdoñooby, cuy le me Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Modni sshihlyiꞌ no zrieñ meññ zegahc dzé ni ba guhl me, ");
INSERT INTO zpg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","porni mpyquie-rsahc‑e gac me no Dioz. Nehx zoo me vin ni zrieñ nistzuuñ. No antzy ni gahl me, ba nu Spirt-Sant leeme. ");
INSERT INTO zpg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Leeme gacno guibyguiat gyo xtahl meññ-Isṟael Dioz ni rtzoo mdad leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","No ma nier leeme guiaad que Señor; no gac me beeiy mod-guhc gahc profet-Elíaz, porni tohzy ni tzu leññ xguîlmbahñ me no ctzoo me xroꞌ cos, lehdy gactziaawy meññ no guîntzi xiiñ, no lehdy gzobdiidz meññ-nahdy no gac yâme meññ-tziaawy, no mod-wé ctzoo me lehdy cuiahz meññ-Isṟael dze-guiaad Señor. ");
INSERT INTO zpg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Were ra Sacaríaz ángel: ―¿Bia mód gannaꞌ bâḻ ni uli gayahbyiꞌ naa? Zoꞌ naa, di zaḻu we, porni ba mînguhl naa, zegahcu dtziaalaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Were ra ángel leeme: ―Naa we ángel-Gabriel ni nu lo xtziiñ Dioz. Dioz pshahl me naa, zidnen lii nirieꞌ ni nac xtidz-mos me ni gutzyaꞌ lii. ");
INSERT INTO zpg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per gumm di nlíladzyiꞌ ni ren lii la, ba gaquiꞌ ngop xtâ gahlr mdoo, were guibyguiat gyniiy. No gyre ni ren lii, zdzihñ dzé ni gacu. ");
INSERT INTO zpg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Gyre meññ zu yahc stziuꞌ gatzunadz, no ganii leññ ihqy yâme: “¿Biahx‑e nacu galee Sacaríaz leññ idoo?” ");
INSERT INTO zpg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hor-byruu me leññ idoo no bydzihñ me ru zu meññ-caḻ yahc stziuꞌ, di ñaḻ nnino me lee, pur señ gatzoo me, porni ba di raḻ gynii me. Were gunn yâme nu ni bluu Dioz leeme leññ idoo. No ze biaꞌn me, ba di ñaḻ nniir me. ");
INSERT INTO zpg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ru ba byzaꞌ dzé we naꞌ ni ptzoo me xtziiñ Dioz leññ idoo, gyzac zia me xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Luxu, güyuꞌ gahc Elisabet de xcuidad, no ba nehx ria me mbahty leññ gaay mboo, gaguꞌ ihqy me, ne me: ");
INSERT INTO zpg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Gayacno Dioz naa, leewe ptzoo me mod-wé. Ba nehx sshihdzyr meññ naa.” ");
INSERT INTO zpg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ba rahp shoꞌb mboo de ni nu Elisabet de xcuidad me, pshahl Dioz ángel-Gabriel to guiedzy ni le Nasaret ni nu lo ṟegioṉ-Galilea, ");
INSERT INTO zpg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ru nu to ndzabxtohby ni le Maríe ni nac diidz guidzña no to mpyquie, ni le José. José naꞌ, ziaad me de lo xfamily ṟeiy-Davit ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Güyuꞌ ángel ru dxie Maríe, günii diux leeme, no ra leeme: ―Dioz ni rtzoo mdad nu no lii. Güle me lii, no ma nu laꞌy lii de gyre lahd meññ-ngünaa. ");
INSERT INTO zpg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Lîc biaadz Maríe hor-gu ángel leeme mod-wé, no ganii leññ ihqy me bia nacu gu ángel leeme ze. ");
INSERT INTO zpg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Were ra ángel leeme: ―Di gydziehbyiꞌ, Maríe, porni biuꞌladzy Dioz güluꞌ xlaꞌy me lii. ");
INSERT INTO zpg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","No guidguiady to mdoñooby, no cuy le me JESÚZ. ");
INSERT INTO zpg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","To mpyquie-rsahc‑e gac me, no tzu le me Xiiñ Dioz-nu gybaa. No ctzoo Dioz leeme ṟeiy, mod-guhc gahc Davit, xfamily me ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ctzoo me mdad meññ-Isṟael, no nehx ziuꞌ dzé gylux de ni dzictzoo me mdad. ");
INSERT INTO zpg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Were ra Maríe ángel: ―¿Bia mód gacu ze? Naa nehx dxienon mpyquie; ndzabxtohby‑e naa. ");
INSERT INTO zpg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Were ra ángel leeme: ―Guiaad Spirt-Sant, no xguîlbyniꞌ Dioz ni nu gybaa gutzu lii mod-to zá. No leewe, mdoo ni dziguiahl gac me nunzy par Dioz, no tzu le me Xiiñ gahc Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Zegahc to lahd xfamilyiꞌ, Elisabet, guidtap to xiiñ, nîcze ba ngünaguhl leeme. Nîcze ne meññ ba nehx zahp xiiñ me, per ba rahp shoꞌb mboo nu de xcuidad me. ");
INSERT INTO zpg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Porni par Dioz nehx nu mbehty ni ngann. ");
INSERT INTO zpg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Were ra Maríe: ―Naa nun par ctzon nitisy ne Dioz ni rtzoo mdad. Ctzoo me mod-gayahbyiꞌ naa. Luxu, byruu ángel za. ");
INSERT INTO zpg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Leññ gahc dze-wé, ngueeḻy gahc güya Maríe to guiedzy ni nu chehsh dahñ lo ṟegioṉ-Judea. ");
INSERT INTO zpg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","No bydzihñ me xiryuꞌ Sacaríaz, güyuꞌ me günii me diux Elisabet. ");
INSERT INTO zpg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hor-bieññ Elisabet günii me diux, byniꞌby mdoo leññ me, no güyuꞌ gahc Spirt-Sant leeme. ");
INSERT INTO zpg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","No günii me ndip, ra me Maríe: ―Dioz ba güluꞌ xlaꞌy me lii de gyre lahd ngünaa, no ba güluꞌ xlaꞌy me mdoo ni guidtapiꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Dxu we nacaꞌ par guiaad xmam tDiozaꞌ guidtixlo naa? ");
INSERT INTO zpg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ren ze, porni hor-bieññaꞌ güniiy diux naa la, byniꞌby gahc mdoo dleññaꞌ de guîlrxihly. ");
INSERT INTO zpg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dxu ñahc beeiy lii, porni bylíladzyiꞌ dziguiahc ni gu Dioz lii. ");
INSERT INTO zpg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Were ne Maríe: No gyre ni nacaꞌ rguguian Señor ni rtzoo mdad; ");
INSERT INTO zpg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","no leññ dguîlmbahñaꞌ rxilynon Dioz ni guislaa naa de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Porni nîcze xmós me naa ni ndruhty nehx nac, per bylaby me naa. Glohg ngâstoo gyre meññ znii dxu ñahc beeiy naa. ");
INSERT INTO zpg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porni Dioz ni beeiyu lee gyreu, ptzoo me xroꞌ cos no naa; ¡nuguia le me! ");
INSERT INTO zpg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nehx zluhx ni rioob me meññ ni rzacbeeiy leeme. ");
INSERT INTO zpg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Modni xroꞌ cos ba ptzoo me; bniꞌdy me meññ-rguguia leegahc leññ ihqy yâme. ");
INSERT INTO zpg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","No güloo me ṟeiy yahc de ni rtzoo mdad, no gülesyguia me meññ-nehx rguguia leegahc. ");
INSERT INTO zpg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bdee me meññ-rlahn gyre ni riuꞌladzy, no meññ-rahp medy, nehx bdee me lee mbehty. ");
INSERT INTO zpg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gucno me meññ-Isṟael ni nac xmeññ me; no nehx güyuꞌ dzé psaꞌn me ni rioob me leeyahc, ");
INSERT INTO zpg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","porni mod-wé ra me difamily nó ni güyuꞌ ba xtze, lee we ni le Braṉ no zrieñ xfamily me ni guidtzur. ");
INSERT INTO zpg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","No biaꞌn Maríe xiryuꞌ Elisabet beeiy tzonn mboo. Luxu gubyguiat me xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bydzihñ dzé we naꞌ de ni bidtap Elisabet to mdoñooby. ");
INSERT INTO zpg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hor-gunn meññ-nuno me gahsh no gyre xfamily me xroꞌ guîlndzi rahp Dioz no leeme, güya yâme bictixlo yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lo shun dzé de ni guhl mdoo, güiyno yâme leeme par güyuꞌ señ lady me, lehdy guieññ xmeññ Dioz‑e leeme, no ne meññ: ―Ñuꞌ le me Sacaríaz, mod-le gahc xtad me. ");
INSERT INTO zpg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Were ra xmam me: ―Yac. Juaṉ‑e tzu le me. ");
INSERT INTO zpg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ra yâme leeme: ―¿Bia nacu? Nehx nu lahd xfamily laꞌd le ze. ");
INSERT INTO zpg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Were, ptzoo yâme señ Sacaríaz lehdy güieꞌ yâme bia mód riuꞌladzy me tzu le mdoo. ");
INSERT INTO zpg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Were günab Sacaríaz to tabl, bzaa me lou, ne me: “Juaṉ‑e tzu le me.” Modni rtzunadz gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","No lohg hor-wé gubyguiat günii Sacaríaz, no guzlo gahc gaguguia me Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Gyre meññ ni nuno me gahsh ptzunadz yâme hor-bwieꞌ yâme günii me sto. No ru yâmeu lo meññ gyre guiedzy ni nu dahñ lo ṟegioṉ-Judea. ");
INSERT INTO zpg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","No gyre meññ ni gayieññ ni ganii yâme, ganii leññ ihqy yâme, no ne yâme: ―¿Dxuhx‑e gac mdo-rieꞌ? Ne yâme ze, porni neññ ulihbu nu Dioz no leeme. ");
INSERT INTO zpg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","No güyuꞌ gahc Spirt-Sant xtad mdoo, lee we Sacaríaz, no bisnii Dioz leeme, ne me: ");
INSERT INTO zpg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Xquix Señor, ni nac xDioz meññ-Isṟael; biahd me no bislaa me xmeññ me de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dioz gashahl to ni beeiyu lee par guislaa nó de lo guîlnadz ni ziaad, no ziaad me de lo gahc xfamily Davit ni ptzoo xtziiñ Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mod-wé günii Dioz ctzoo me dze-bisnii me xprofet me ni güyuꞌ yahc ba xtze, ");
INSERT INTO zpg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","lehdy beeiy gylaa nó de lo ña meññ-rdziadzyno nó, no meññ-néladzy nó. ");
INSERT INTO zpg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","No ne me zioob me gyre dmeññ nó ni güyuꞌ ba xtze, no nehx ziaaḻladzy me bdee me diidz de ni ziuꞌ sto mod-coby ni ctzoo me no xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Niwé we ni togahcs ra Dioz dtad nó Braṉ ni güyuꞌ ba xtze, ne me gacno me nó, ");
INSERT INTO zpg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","lehdy dze-ba bislaa me nó de lo ña meññ-rdziadzyno nó, beeiy ctzoo nó ni ne me sinn di gydzie nó, ");
INSERT INTO zpg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","no leññ dze-mbahñ nó, tzu nó ctzoo nó ni nac xñahzû no gac nó meññ-nac nunzy par leeme. ");
INSERT INTO zpg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","No lii, shiꞌñ, tzu ley xprofet Dioz ni nu gybaa, porni nier lii tza dzicsieññiꞌ meññ guiaad Señor, no were ba guiaad me. ");
INSERT INTO zpg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","No csieññiꞌ meññ-Isṟael beeiy gylaa yâme de lo guîlnadz ni ziaad porni Dioz beeiy csiaaḻladzy xguîlquie yâme. ");
INSERT INTO zpg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Porni de ni rioob Dioz nó, xroꞌ we leeu; leewe cshahl me to ni gac beeiy ncübidz ni cu byniꞌ ru nu nó, ");
INSERT INTO zpg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","lehdy güieꞌ meññ ni nu lo guibcawygüxihñ no meññ-nu yahc lo ña guîlguhty bia gatzoo yâme, no lehdy gluu me nó to ñaz-mos ru tzu nó dzie tziaawy. ");
INSERT INTO zpg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","No ganiꞌzy ñôbydxuur, no ganiꞌzy ni nu leññ xguîlmbahñ me; no güyuꞌ me lo yu-bihdzy xtâ dzé ni guzlo psieññ me meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Leññ dze-caḻ ptzoo Augusto Cézr mdad gydohp le gyre meññ cad to guiedzy ru rtzoo me mdad. ");
INSERT INTO zpg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nirieꞌ we ni nier guzlo bydohp le meññ, dze-rtzoo Cirenio mdad meññ-nu lo ṟegioṉ-Siry. ");
INSERT INTO zpg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gyre meññ güya xguiedzy ru guhl, bigdee le. ");
INSERT INTO zpg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Leewe byruu José guiedzy-Nasaret ni nu lo ṟegioṉ-Galilea, güya me guiedzy-Beléṉ ni nu lo ṟegioṉ-Judea, ru guhl Davit ni güyuꞌ ba xtze. No José naꞌ, de lo gahc xfamily Davit‑e ziaad me. ");
INSERT INTO zpg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Güya me Beléṉ, bigdee le me tohzy no Maríe, ni ba nac diidz guidzña me lee, no ba nu Maríe de xcuidad. ");
INSERT INTO zpg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dze-nu yâme Beléṉ‑e naꞌ, uga byruu Maríe de xcuidad me. ");
INSERT INTO zpg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mdoo ni bidtap me we xiñ-lguhl me, no bylux guhl pchaḻ me lee lahr no güdihsh me lee leññ to cajóṉ ru rahgü guay guix, porni di ndzial yâme yuꞌ ru ndzihñ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gahsh Beléṉ nu to dahñ ru rdedy meññ guiaal ni gayahp yahc xiily. ");
INSERT INTO zpg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tohzy bydzihñ to x‑ángel Dioz ru dxie yâme, lé güyuꞌ xibyni-ro Dioz gybi yâme. Modni bydzie yâme. ");
INSERT INTO zpg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ra ángel leeyâme: ―Di gydzie laꞌd. Naa zidnen laꞌd to ni dgueññ ziaꞌ guieññ ndruhty, ni gac to guîlrxihly par gyre meññ. ");
INSERT INTO zpg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dzêrieꞌ guhl to mdoo leññ xguiedzy Davit, leeme we ni guislaa meññ de lo guîlnadz ni ziaad. No leeme we nac CRIST ni ctzoo mdad. ");
INSERT INTO zpg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ru gydzial laꞌd to mdoo nash leññ to cajóṉ ru rahgü guay guix, nraḻ lahr la, leeme we mdoo ni gayapyaꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lohg hor-wé bidchileꞌ zrieñ ángel yahc ni byruu gybaa ru zu ángel ni bydzihñ nier lee, guzlo gaguguia yâme Dioz, ne yâme: ");
INSERT INTO zpg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Xquix Dioz ni nu gybaa, no meññ ni nu xlaꞌy me lee, tzu yâme dzie tziaawy lo guiedzylie! ");
INSERT INTO zpg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Byluxu, byruu gyre ángel zia yahc gybaa, guzlo gaya saꞌ meññ-gayahp yahc xiily, ne yâme: ―Tzoꞌ, tzo nó Beléṉ, dzigüieꞌ nó ni ba guhc uga, ni psieññ Dioz nó por x‑ángel me. ");
INSERT INTO zpg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Were za gahc yâme ngueeḻy, no bydzihñ yâme. Bwieꞌ yâme Maríe no José, no bwieꞌ yâme mdoo nash leññ to cajóṉ ru rahgü guay guix. ");
INSERT INTO zpg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hor-bwieꞌ yâme leeme we naꞌ, guzlo bie yâme diidz ni bigyne ángel leeyâme de mdo-wé. ");
INSERT INTO zpg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","No gyre meññ-bieññ ni bie yâme, ptzunadz yâme. ");
INSERT INTO zpg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","No Maríe naꞌ, güdahp me gyre niwé leññ ihqy me no leññ xguîlmbahñ me. ");
INSERT INTO zpg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Luxu, gubyguiat meññ-rictap xiily zia yâme, gadee yâme xquix Dioz no gaguguia yâme Dioz por gyre ni bieññ yâme no ni bwieꞌ yâme, mod-ra ángel leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ni byzaꞌ mdoo shun dzé de ni guhl me, güyuꞌ gahc to señ lady me, porni mod-wé günii Dioz ctzoo xmeññ me. No güluꞌ yâme le me Jesúz, mod-ra ángel Maríe antzy ni tzu de xcuidad me. ");
INSERT INTO zpg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Byzaꞌ dzé we naꞌ, ni rbiahz ngünaa ni rahp mdoo, mod-ganii xleiy Moiséz. Were güiyno yâme mdo-wé idoró Jerusaléṉ, par gac cuent leeme lo xtziiñ Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ptzoo yâme mod-rieꞌ, porni modé we rnii xleiy Dioz: “Gyre mbiux-ñooby ni rahl nier lee, gdee yâme lee par tzu lo xtziiñ Dioz.” ");
INSERT INTO zpg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","No güiyno yâme maꞌ par pquee yâme gue lee par to gun mod-ganii xleiy Dioz: diypar guhg o, bâḻ yac, chohp ximbue. ");
INSERT INTO zpg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tzcaḻ gahc‑e naꞌ, nu to mpyquie-tziaawy Jerusaléṉ, le me Simeóṉ, no rzacbeeiy me Dioz. No nu Spirt-Sant leeme, no gabiahz me guiaad dxu guislaa meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","No ba psieññ Spirt-Sant leeme nehx zehty me antzy ni güieꞌ me Crist ni cshahl Dioz lee. ");
INSERT INTO zpg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mpyquie-rieꞌ, güiyno Spirt-Sant leeme idoró. Wé zu me ru bidno yâme Jesúz par ctzoo yâme mod-ne leiy. ");
INSERT INTO zpg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Cuaꞌ Simeóṉ mdo-caḻ lo ña me, no güluguia me Dioz, ne me: ");
INSERT INTO zpg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Naa rtzon xtziiñiꞌ, Señor, no ba bwien guhc ni guhdzyiꞌ naa, leewe nun mos no ba beeiy glesyiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Porni ba bwien dxu guislaa meññ de lo guîlnadz ni ziaad; ");
INSERT INTO zpg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","leeme we ni ba pshahliꞌ lee lehdy güieꞌ gyre meññ leeme. ");
INSERT INTO zpg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","No leeme we ni gac beeiy to byniꞌ ni gacno meññ-nehx meññ-Isṟael, lehdy gann yâme xtiidziꞌ, no zegahcu xmeññiꞌ, meññ-Isṟael, lehdy guiasguia yâme. ");
INSERT INTO zpg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Rtzunadz José no Maríe ni ganii Simeóṉ lguia Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Luxu, gülulaꞌy Simeóṉ leeyâme, no ra me Maríe, xmam Jesúz: ―Mdo-rieꞌ la, ziaad me we zidsiahb me xtahl meññ-Isṟael no zrieñ yâme zidlesy me lee, no zidluu me meññ bia ne Dioz, per xtahl yâme zdziadzyno leeme. ");
INSERT INTO zpg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","No mod-wé sshal lo ni rnii leññ xguîlmbahñ xtahl meññ. No par lii, Maríe, gyre nirieꞌ zidguiahcu beeiy to güdzihly ni ctedyqueꞌ xguîlmbahñiꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","No zu to ngünaa uga, le An, ni profet lee, xiiñ Fanuel ni nac xfamily Aser. An naꞌ, ba mînguhl leeme. Miꞌñ ziaꞌ leeme dze-bidzña me, no gahdzy ihz gürieno me tziahl me, bidguiehty, ");
INSERT INTO zpg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","no ba rahp ochentaycuatr ihz ni biaꞌn me viud. Tirgahc nu me idoró, rzacbeeiy me Dioz dzé no guiaal, rnino me Dioz no rtzoo me ayun zegahc. ");
INSERT INTO zpg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lo hor-wé bydzihñ me ru caꞌ yâme mdo-caḻ, bdee me xquix Dioz, no guzlo gayuno me meññ diidz de mdo-wé, gaya me leeyahc, wé we ni gabiahz yâme par guislaa meññ-Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bylux ptzoo yâme gyre ni ne xleiy Dioz, gubyguiat yâme xguiedzy yâme, Nasaret ni nu lo ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","No entr ma ganiꞌzy ñôbydxuur, ma gayacnguiehdzy me no gayahp me xguîlnann Dioz; no gaguꞌ Dioz xlaꞌy leeme. ");
INSERT INTO zpg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Gyre ihz ria José no Maríe Jerusaléṉ, rictap yâme lni-Pascü, xilni-ro meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Naabz‑e naꞌ, rahp Jesúz tzipychop ihz, güya gyre yâme, porni ze rtzoo gyre meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Güdedy lni, gubyguiat yâme, eguiid Jesúz biaꞌn Jerusaléṉ ni di ñann xmam me ni José. ");
INSERT INTO zpg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nlâdzy yâme lahd meññ‑e zia Jesúz, güzeꞌ yâme nter to dzé. Byo yâme leeme lahd xfamily yâme no lahd meññ ni rzaclo yâme lee, ");
INSERT INTO zpg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","per nehx bydzial yâme leeme. Gyzac gubyguiat José no Maríe Jerusaléṉ, par zigyo yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lo tzonn dzé bydzial yâme leeme ruꞌ idoró. Dxie me lahd muextr ni ruuḻ yahc xleiy Moiséz, gayieññ me ni rnii yâme no ganabdiidz me leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","No gyre meññ-rieññ ni ganii me rtzunadz yâme, porni nniꞌ ihqy me no nann me bia rnii me. ");
INSERT INTO zpg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Hor-bwieꞌ xtad me no xmam me leeme, ba di rdzial bia ctzoo yâme. Were ra xmam me leeme: ―Dshiñaꞌ, ¿bia nacu gatzooy noꞌ ze? Gaguꞌ dihqy noꞌ lii no gayo noꞌ lii byzaꞌzy no xtadiꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Were ra Jesúz leeyâme: ―¿Bia nacu ryo laꞌd naa? ¿Nehx nann laꞌd la, naa rapaꞌ de ni tzun lo xtziiñ dTadaꞌ? ");
INSERT INTO zpg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per nehx gunn yâme bia günii me. ");
INSERT INTO zpg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Were gubyguiatno me leeyâme, zia yâme Nasaret gyzac. No rzoob me xtiidz yâme. Maríe naꞌ, gyre niwé gayaꞌn leññ ihqy me. ");
INSERT INTO zpg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","No entr ma ganiꞌzy Jesúz, ma gayacxroꞌ xguîlnann me no gaxilyno Dioz leeme no zegahcu meññ. ");
INSERT INTO zpg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lo iz-quinzy, dze-rtzoo to mpyquie ni le Tibery mdad gyre guiedzy ni nac xchieñ meññ-Ṟom, tzcaḻ nac to mpyquie gobernador lo ṟegioṉ-Judea, le me Ponzy Pilat. Herody nac gobernador lo ṟegioṉ-Galilea, behtzy me Felipy nac gobernador lo ṟegioṉ-Iturea no lo ṟegioṉ-Traconite, no sto mpyquie ni le Lisanias, wé nac gobernador lo ṟegioṉ-Abilinia. ");
INSERT INTO zpg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anáz no Caifáz nac yâme xjefy gyre bahl. Tzcaḻ gahc, xiiñ Sacaríaz, lee we Juaṉ, nu me lo yu-bihdzy. No wé nu me günino Dioz leeme. ");
INSERT INTO zpg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juaṉ güdedy me gydo coo guiagü-Jordáṉ, psieññ me meññ csaan yâme ni nahcsy ni nac yâme, lehdy csiaaḻladzy Dioz xguîlquie yâme no gyrôbnihs yâme. ");
INSERT INTO zpg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Neꞌ guhc mod-bzaa profet-Isaíaz lo xguehtzy me ba xtze, ru ne me: Rieññ gaquee to mpyquie riedz lo yu-bihdzy, ne: “Lâ guistziaawy ru tedy Señor; lâ cshal xguîlmbahñ laꞌd beeiy to ñaz-ndohp par dze-guiaad me. ");
INSERT INTO zpg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gydzieꞌ gyre ru nshit, gyre ihqy dahñ, guiaht lo ni nsuuw, ñaz-nleangü gacndohpu, no ni rahp ru dziib gacdibylou. ");
INSERT INTO zpg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","No gyre meññ zwieꞌ mod-guislaa Dioz leeyâme de lo guîlnadz.” ");
INSERT INTO zpg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ru bwieꞌ Juaṉ‑e naꞌ, ziaad xtahl meññ par gyrôbnihs, were ra me leeyâme mod-rieꞌ: ―¡Laꞌd meññ-dirquihñ ni zidguiahc beeiy mbaḻbeedzy! ¿Dxu ra laꞌd beeiy gylaa laꞌd de lo xguîlné Dioz ni ziaad? ");
INSERT INTO zpg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lâ ctzoo ni nac xñahzû lehdy guieññ ba psaan laꞌd ni nahcsy ni nac laꞌd, no na di sulo gynii leññ ihqy laꞌd, ga laꞌd: “Ba xmeññ Dioz‑e nó porni de lo xfamily Braṉ‑e nó”; porni gapyaꞌ laꞌd, Dioz zegahc‑e beeiy ntzoo me xfamily Braṉ xtâ guie ni dxie yahc neꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Zidguiahc meññ‑e beeiy to yag-cuannahsh; no guibyahg ba nashu puexd lehdy gyrug gyre yahg ni nehx mos xcuannahsh no yqueꞌ gueu. ");
INSERT INTO zpg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Were günabdiidz meññ-caḻ leeme, ra yâme: ―¿Biaz mód ntzoo noꞌ? ");
INSERT INTO zpg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ra Juaṉ leeyâme: ―Dxu rahp chohp gmix la, gdee me tohbyu dxu nehx rahpu. No dxu rahp guîlrahgü la, quiiz meu par ycaꞌ meññ ni nehx rahpu. ");
INSERT INTO zpg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Zegahc bydzihñ meññ-rguquix mpuezd par gyrôbnihs yahc, ra yâme Juaṉ: ―Naꞌz noꞌ, muextr, ¿biaz ntzoo noꞌ? ");
INSERT INTO zpg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ra Juaṉ leeyâme: ―Na di iguquix laꞌd ma xtahl de ni rtzoo leiy mdad. ");
INSERT INTO zpg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","No zegahc bydzihñ zrieñ soldad, ra leeme: ―Naꞌz noꞌ, ¿bia ntzoo noꞌ? Ra me leeyâme: ―Na di gbohd xchieñ meññ, no di gynihd ni nehx uli chehsh meññ ni di ntzoo mbehty. Lâ gyxilyno nunzy sahc laꞌd ni riax laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Per gumm gabiahz gyre meññ-wé yahc guiaad Crist la, nlâdzy yâme Juaṉ‑e nac Crist. ");
INSERT INTO zpg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Were ra Juaṉ gyre yâme: ―Naa ni uli we no nzeꞌ rchôbnisaꞌ laꞌd. Per nu sto ni guiaad lux de ni biaḻaꞌ ni ma beeiyu lee que naa, ni xduu xguidguial me nehx rsahcaꞌ par nshacaꞌu. Beeiy to guîlrrôbnihs gdee me Spirt-Sant ni tzu leññ xguîlmbahñ laꞌd no ctzoo me guîlguxtisy no gue. ");
INSERT INTO zpg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","No ctzoo me mod-rtzoo meññ par rboo xguix trigü. Meññ-tziaawy gboo me lee diby lad beeiy rlesytziaawy meññ trigü leññ daꞌwy; no meññ-guîlquie glee me lee lo gue ni di ziuꞌ dzé ziee, beeiy rqueꞌ gue xguix trigü. ");
INSERT INTO zpg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mod-wé no zrieñ mód güluꞌ Juaṉ xguîlriehñ meññ par gasieññ me leeyâme xtidz-mos Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","No zegahc gu me gobernador-Herody ni dirquihñ ni nac de ni rahp me Herodíaz, tziahl Felipy, behtzy gahcme, no zegahc por zrieñ ni nahcsy ni ba ptzoo me. ");
INSERT INTO zpg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Per Herody naꞌ, di ntzucas me, aaḻ güluꞌ dir me Juaṉ lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lóni garôbnihs meññ, güya Jesúz, zegahc bigyrôbnihs. No hor-ganino Jesúz Dioz, byxal gybaa. ");
INSERT INTO zpg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","No biaht Spirt-Sant lguia me beeiy to palom, no bieññ to riedz ni byruu gybaa, ne: ―Lii we dShiñaꞌ ni ndzin lee; modni rxilynon lii. ");
INSERT INTO zpg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Rahp Jesúz beeiy treint ihz, guzlo me xtziiñ me ni zidtzoo me. Ne meññ xiiñ José we leeme. José, leeme we xiiñ Elí; ");
INSERT INTO zpg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí xiiñ Matat, Matat xiiñ Leví, Leví xiiñ Melqui, Melqui xiiñ Jan, Jan xiiñ José, ");
INSERT INTO zpg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José xiiñ Matatíaz, Matatíaz xiiñ Amóz, Amóz xiiñ Nahum, Nahum xiiñ Esli, Esli xiiñ Nagay, ");
INSERT INTO zpg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay xiiñ Mat, Mat xiiñ Matatíaz, Matatíaz xiiñ Semeiy, Semeiy xiiñ José, José xiiñ Judá, ");
INSERT INTO zpg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá xiiñ Joana, Joana xiiñ Ṟesa, Ṟesa xiiñ Zorobabel, Zorobabel xiiñ Salatiel, Salatiel xiiñ Neri, ");
INSERT INTO zpg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri xiiñ Melqui, Melqui xiiñ Adi, Adi xiiñ Cosam, Cosam xiiñ Elmodam, Elmodam xiiñ Er, ");
INSERT INTO zpg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er xiiñ Josué, Josué xiiñ Eliezer, Eliezer xiiñ Jorim, Jorim xiiñ Matat, ");
INSERT INTO zpg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat xiiñ Leví, Leví xiiñ Simeóṉ, Simeóṉ xiiñ Judá, Judá xiiñ José, José xiiñ Jonam, Jonam xiiñ Eliaquim, ");
INSERT INTO zpg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim xiiñ Melea, Melea xiiñ Maináṉ, Maináṉ xiiñ Matata, Matata xiiñ Natáṉ, ");
INSERT INTO zpg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natáṉ xiiñ Davit, Davit xiiñ Isaí, Isaí xiiñ Obet, Obet xiiñ Boz, Boz xiiñ Salmóṉ, Salmóṉ xiiñ Nasóṉ, ");
INSERT INTO zpg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasóṉ xiiñ Aminadap, Aminadap xiiñ Aram, Aram xiiñ Esrom, Esrom xiiñ Fares, Fares xiiñ Judá, ");
INSERT INTO zpg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá xiiñ Jacop, Jacop xiiñ Isac, Isac xiiñ Braṉ, Braṉ xiiñ Taré, Taré xiiñ Nacor, ");
INSERT INTO zpg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor xiiñ Seruc, Seruc xiiñ Ṟagau, Ṟagau xiiñ Pelec, Pelec xiiñ Héber, Héber xiiñ Sala, ");
INSERT INTO zpg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala xiiñ Caináṉ, Caináṉ xiiñ Arfacsad, Arfacsad xiiñ Sem, Sem xiiñ Noé, Noé xiiñ Lamec, ");
INSERT INTO zpg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec xiiñ Matusaléṉ, Matusaléṉ xiiñ Enoc, Enoc xiiñ Jaret, Jaret xiiñ Malalel, Malalel xiiñ Caináṉ, ");
INSERT INTO zpg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Caináṉ xiiñ Enóz, Enóz xiiñ Set, Set xiiñ Adáṉ, no Adáṉ, leeme we xiiñ Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Byruu Jesúz coo guiagü-Jordáṉ, nu Spirt-Sant leeme; no güiyno Spirt gahc leeme lo yu-bihdzy. ");
INSERT INTO zpg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Güyuꞌ me uga leññ cuarent dzé, no ne bêndzab nwieꞌ bâḻ beeiy nquihly me Jesúz ntzoo mod-ra me lee. Nehx güdahgü Jesúz mbehty leññ dze-wé. Güdedy dze-wé yahc, bylahn me. ");
INSERT INTO zpg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Were ra bêndzab leeme: ―Bâḻ ulihbu Xiiñ Dioz lii, ptzoo mdad gac guie-rieꞌ paṉ. ");
INSERT INTO zpg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ra Jesúz leeme: ―Lo Guehtzy ru queꞌ xtiidz Dioz neu: “Dac‑e nunzy no paṉ rbahñ meññ, zehg rbahñ meññ no gyre xtiidz Dioz.” ");
INSERT INTO zpg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Luxu, güiyno bêndzab leeme ihqy to dañ-suu par blu-güxuunn leeme nter guiedzylie ru rtzoo meññ mdad. ");
INSERT INTO zpg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","No ra bêndzab leeme: ―Naa gdedyaꞌ lgar ctzooy mdad nter guiedzylie ni galun lii, no gdedyaꞌ gyre ni rsahc ni nu lou, ycaꞌy. Dixchieñaꞌ we gyreu, naa zdedyaꞌnu nitisy dxu racdadzyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","No bâḻ guisshibyiꞌ dloꞌn no gzacbeeiyiꞌ naa, xchieñiꞌ we gyreu. ");
INSERT INTO zpg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Were ra Jesúz leeme: ―Byruu de neꞌ, bêndzab, porni lo Guehtzy ru queꞌ xtiidz Dioz neu: “Bzacbeeiy Dioz ni rtzoo mdad lii, no ptzoo nunzy ni ne me.” ");
INSERT INTO zpg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Luxu, güiyno bêndzab leeme ihqy idoró Jerusaléṉ ru ma nsuu, no ra leeme: ―Bâḻ ulihbu Xiiñ Dioz lii, güyubeꞌ lo yu. ");
INSERT INTO zpg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Porni lo Guehtzy ru queꞌ xtiidz Dioz neu: Cshahl Dioz x‑ángel me ni gyla yahc lii. ");
INSERT INTO zpg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Glesy yâme lii lo ña yâme, lehdy di ctzuné guie nieꞌy. ");
INSERT INTO zpg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ra Jesúz leeme: ―Lo Guehtzy ru queꞌ xtiidz Dioz neu: “Di gnabiꞌ behch lo Dioz ni rtzoo mdad lii nunzy par güieꞌy bâḻ ctzoo me ni neꞌy.” ");
INSERT INTO zpg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hor-bwieꞌ bêndzab ba di ñaḻ nquihly me Jesúz ntzoo mod-ne me, byrusytzu me de lee doozy dzé. ");
INSERT INTO zpg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Luxu, gubyguiat Jesúz lo ṟegioṉ-Galilea, guzlo me gatzoo me xroꞌ cos porni nu xiSpirt Dioz leeme, no gayu meññ diidz de leeme byzaꞌzy. ");
INSERT INTO zpg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","No za me idoo cad to guiedzy, galuu me meññ xtiidz Dioz no gyre yâme rguguia leeme. ");
INSERT INTO zpg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Bydzihñ Jesúz Nasaret, guiedzy ru byniꞌzy me; no güya me idoo dze-risladzy meññ‑Isṟael, mod-rtzoo gahc me. Ru guzli me lehdy guuḻ me lo Guehtzy ru queꞌ xtiidz Dioz, ");
INSERT INTO zpg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","bdee yâme leeme xguehtzy profet-Isaíaz. Pshal me lou, no bydzial me ru ganii ne: ");
INSERT INTO zpg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nu xiSpirt Dioz naa, porni Dioz güle me naa lehdy csieññaꞌ meññ-pobr xtidz-mos me. Pshahl me naa lehdy gacnon meññ ni gyrehzy gazacno xtâ leññ xguîlmbahñ, no gapyaꞌ meññ ni zidguiahc beeiy ni nu lidzyguiib bia mód beeiy gylaa yâme de lo ni nadz; no cshalaꞌ lo meññ-ngaḻ yahc; no guislaan meññ ni gazaczi yahc. ");
INSERT INTO zpg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","No csieññaꞌ meññ ba bydzihñ tiémp ni güle Dioz lehdy gacno me meññ ni gyo leeme. ");
INSERT INTO zpg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bylux biiḻy me lo Guehtzy ru queꞌ xtiidz Dioz, ptohby meu sto, no bdee meu mpyquie ni rtzoo dziiñ leññ idoo. Luxu, gürie me. Gyre meññ-dxie leññ idoo gawiedzie yahc leeme. ");
INSERT INTO zpg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Luxu, günii me, ne me: ―Dzêrieꞌ gahc‑e guhc ni ganii lo Guehtzy ru queꞌ xtiidz Dioz, ni bieññ laꞌd neꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Gyre yâme gaguguia leeme, no gatzunadz yâme xtiidz me porni mos mod-günii me. No ra saꞌ yâme: ―¿Dâs‑e leeme xiiñ José la? ");
INSERT INTO zpg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ra Jesúz leeyâme: ―Naa nannaꞌ ga laꞌd naa to didz-zaaby ni ne mod-rieꞌ: “Psiaḻ lii gahc, doctor.” Zegahc ga laꞌd naa: “Ptzoo ni ptzooy guiedzy-Capernaum neꞌ leññ xguiedzyiꞌ, güieꞌ nó.” ");
INSERT INTO zpg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","No ra me leeyâme zegahc: ―Gapyaꞌ laꞌd ni uli, to profet nehx rxilyno meññ lee leññ gahc xguiedzy. ");
INSERT INTO zpg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","No ni uli we nirieꞌ: güyuꞌ xtahl ngünaviud nacioṉ-Isṟael ba xtze, dze-mbahñ profet-Elíaz. No leññ tzonn iz-garuḻ ni di ñahc guio, güyuꞌ guîlrlahn uga. ");
INSERT INTO zpg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Per di nshahl Dioz Elíaz nigüieꞌ ru nu yâme, mazyg pshahl Dioz leeme ru nu to ngünaviud guiedzy ni le Sarepta ni nu lo ṟegioṉ-Sidóṉ. ");
INSERT INTO zpg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","No zegahc dze-gübahñ profet-Eliseu, güyuꞌ xtahl meññ-Isṟael gayac-ure, gayudz lady yâme, per ni to yâme nehx biaḻ; nunzy biaḻ to mpyquie ni le Namáṉ, meññ-Siry leeme. ");
INSERT INTO zpg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hor-bieññ gyre meññ-dxie leññ idoo ni ganii me, bydziaꞌdzy yâme. ");
INSERT INTO zpg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","No güloo yâme leeme leññ guiedzy, güiyno yâme leeme ihqy dahñ ru dxie guiedzy-caḻ lehdy nlee yâme leeme leññ zaꞌn. ");
INSERT INTO zpg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per leeme güdedy me lahd yâme, no za me. ");
INSERT INTO zpg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Luxu za Jesúz sto guiedzy-le Capernaum ni nu lo ṟegioṉ-Galilea. Uga guzlo galuu me meññ cad dze-risladzy meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","No rtzunadz yâme mod-rluu me, porni rnii me zaꞌgndzi, mod-rnii to meññ ni rtzoo mdad. ");
INSERT INTO zpg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Leññ gahc ido-wé dxie to mpyquie ni nu mbenahcsy lee, tohzy pquee me riedz, ne me: ");
INSERT INTO zpg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Di guiaadiꞌ neꞌ ru nu noꞌ! ¿Bia ryohbyiꞌ no noꞌ, Jesúz ni nac meññ-Nasaret? ¿Ziaadiꞌ lehdy gniꞌdyiꞌ noꞌ la? Naa rzacloꞌn lii. Lii we ni nac Mpyquie-tziaawy ni Pshahl Dioz Lee. ");
INSERT INTO zpg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Were ptzoo Jesúz mdad mbenacsy-caḻ, ra me lee: ―¡Güyudzie, no byruu gahc de mpyquie-rieꞌ! Luxu, güdiñguie mbenahcsy mpyquie-caḻ lo yu ñaz-lo gyre yâme, no byruu gahcu leeme, no ba mbehty di ntzoou leeme. ");
INSERT INTO zpg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Gyre yâme ptzunadz, no guzlo ra saꞌ yâme: ―¿Biahx diidz‑e rnii mpyquie-rieꞌ? ¡Xnahc‑e rnihzy me no rtzoo me mdad mbenahcsy, no rruu gahcu meññ! ");
INSERT INTO zpg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","No byzaꞌzy lo ṟegióṉ ru meññ ni rtzoo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Byruu Jesúz idoo, za me xiryuꞌ Simóṉ. Bydzihñ me, nash suegyr-ngünaa Simóṉ, xle-gue lee. Were ra yâme Jesúz: ―Racdadzy noꞌ nsiaḻiꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Luxu gübigy Jesúz ru nash me, no ptzoo Jesúz mdad xle, ra me: ―¡Byruu de ngüna-rieꞌ! No biaḻ gahc xixle me, no biahs gahc me, bdee me ni güee Jesúz no xmeññ. ");
INSERT INTO zpg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Naabz güyaaz ncübidz, güiyno yâme gyre meññ ni gayac-ure de gyre gyzasy guîlguihdz ru zu Jesúz; no pshob ña me chehsh meññ-gayac-ure yahc, no biaḻ gahc yâme. ");
INSERT INTO zpg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","No zegahc xtahl meññ güloo me mbenahcsy lee, no hor-garuu mbenahcsy, rquee yahcu riedz, ne yahcu: ―¡Lii we Xiiñ Dioz! Were güdeḻy me mbenahcsy, no ba di ndeer me ñahz nnii yahc, porni nann yahcu leeme we nac Crist. ");
INSERT INTO zpg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Byre guiaal‑e naꞌ, byruu Jesúz diby lad de leññ guiedzy, güya me ru ndruhty nehx nu. Per meññ guzlo yahc gayo leeme byzaꞌzy; hor-bydzial yâme leeme, ptzunñaad yâme leeme ñaꞌn me. ");
INSERT INTO zpg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Per ra me meññ-wé yahc: ―Rapaꞌ de ni tzan zrieñ guiedzy, dzigyunon meññ xtidz-mos Dioz de ni rtzoo me mdad, porni lehdy ctzon modé ni pshahl me naa. ");
INSERT INTO zpg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","No were güya me gydo lo ṟegioṉ-Galilea, gayuno me meññ xtiidz Dioz leññ xiydoo yâme. ");
INSERT INTO zpg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","To dzé zu Jesúz coo to nisdoo ni le Genesaret. Bydzihñ xtahl meññ ru zu me, lé raꞌñ yâme leeme, porni riuꞌladzy yâme guieññ yâme xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bwieꞌ Jesúz chohp barcü-dahtzy coo nzeꞌ, porni ba byruu meññ-ganahzy mbaḻ leññu, no ba gaguihby xgueshmbaḻ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Were güyuꞌ Jesúz leññ to barcü-caḻ, ni nac xchieñ Simóṉ, no günab Jesúz leeme tziyno me barcü coo gá nzeꞌ ru zuw. Luxu, gürie gahc Jesúz leññ barcü, no guzlo gahc galuu me meññ. ");
INSERT INTO zpg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bylux bluu me meññ, ra me Simóṉ: ―Güiyno barcü ru guial, no lâ gráḻ xgueshmbaḻ laꞌd lo nzeꞌ par gynahzy laꞌd mbaḻ. ");
INSERT INTO zpg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ra Simóṉ leeme: ―Muextr, gydo guiaal gatzoo noꞌ dziiñ, per dgueññ gynahzy noꞌ ni to mbaḻ. Per bâḻ neꞌy ze la, naꞌ tzo noꞌ dzigráḻ noꞌu. ");
INSERT INTO zpg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ru bráḻ yâme gueshmbaḻ‑e naꞌ, güyuꞌ gahc xtahl mbaḻ leññu, lé rluuw ba igaaxu. ");
INSERT INTO zpg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Were pquee yâme riedz zrieñ meññ-zidno yâme ni nu leññ sto barcü par tza gacno leeyâme. Were güya yâme, biguistzee yâme gyrop barcü lé rluuw ba guiaꞌbu leññ nzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Per ru bwieꞌ Simoṉ-Pedr niwé we naꞌ, bisshiby me lo Jesúz, ra me lee: ―Nehx rquihñaꞌ par cuiahziꞌ ru zuun, Señor, porni meññ-guîlquie we naa. ");
INSERT INTO zpg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Günii me ze, porni gadzie me por gyre mbaḻ ni bwieꞌ me bygaꞌ, no nehx lehzyme gadzie, zegahcu zrieñ meññ-ziyno me lee. ");
INSERT INTO zpg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","No zegahc bydzie Jacob no Juaṉ, lee we xiiñ Zebedeu, ni rtzoo yahc dziiñ no Simóṉ. Were ra Jesúz Simóṉ: ―Di gydziehbyiꞌ. Glohg ngâstoo ctzon lii to meññ ni guidno zrieñ yahc ni gac dmeññaꞌ lee. ");
INSERT INTO zpg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hor-ba güloo xbarcü yâme lo yudahñ, psaꞌn yâme gyreu uga no za yâme no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Dze-nu Jesúz to guiedzy, bydzihñ to mpyquie ni gayudz gydo lady. Ru bwieꞌ me Jesúz‑e naꞌ, bisshiby me lo, lé güdihsh ihqy me lo yu, ra me lee: ―Señor, lii ni rtzoo mdad, bâḻ racladzyiꞌ la, beeiy csiaḻiꞌ naa we. ");
INSERT INTO zpg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Were pshob ña Jesúz chehsh me, no ra leeme: ―Naa racdadzyaꞌ csiaḻaꞌ lii. ¡Ba biaḻiꞌ we! Lux günii Jesúz ze, biaḻ gahc ni gayudz gydo lady mpyquie-caḻ. ");
INSERT INTO zpg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Were ra Jesúz leeme: ―Na di guyu lo ndruhty; mazyg güya lo bahl lehdy güieꞌ me ba biaḻiꞌ, no güiyno gun ni gu Moiséz meññ, lehdy gann yâme ba biaḻiꞌ de xguîlguihdziꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma gayuguia Jesúz no ma gadohp meññ par guieññ ni rnii me, no par csiaḻ me lee de xguîlguihdz. ");
INSERT INTO zpg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","No lahd lahd gá rrusytzu Jesúz, ria me ru nehx nu meññ, rigynino me Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","To dzé galuu Jesúz meññ, no lahd yâme nu meññ-nac yahc fariseu no muextr ni ruuḻ yahc xleiy Moiséz ni byruu zrieñ guiedzy de lo ṟegioṉ-Galilea, no lo ṟegioṉ-Judea, no ciuda-Jerusaléṉ, gawieꞌ yâme gyre ni gatzoo Jesúz, gasiaḻ me meññ-gayac-ure, porni nu Dioz no leeme. ");
INSERT INTO zpg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tohzy bydzihñ zrieñ meññ, zidno yâme to mpyquie-gayac-ure ni di raḻ gyniꞌby mbehty, nash me to lo camill. Gucladzy yâme nguꞌ yâme leeme leññ yuꞌ ru zu Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Per di ndzial yâme ru ndedy yâme, porni bydzeꞌ meññu. Were cueꞌ yâme ihqy yuꞌ, bigloo yâme diax lehdy gülety yâme mpyquie ni nash lo camill glaꞌy, ru zu Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ru bwieꞌ Jesúz ulihbu rlíladzy yâme, were ra me mpyquie-gayac-ure: ―Mígü, xguîlquiey ba psiaaḻdadzyaꞌ gyreu we. ");
INSERT INTO zpg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Guzlo gahc ganii leññ ihqy muextr ni ruuḻ yahc xleiy Moiséz no zrieñ meññ-nac yahc fariseu, ne yâme: “¿Dxuz‑e nac mpyquie-rieꞌ? Rnii me didz-nahcsy contr Dioz, porni nunzy Dioz‑e beeiy rsiaaḻladzy xguîlquie meññ.” ");
INSERT INTO zpg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Per Jesúz naꞌ, nann me bia ganii leññ ihqy yâme. Were ra me: ―¿Bia nacu rnii leññ ihqy laꞌd ze? ");
INSERT INTO zpg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Bia leeu ma nehx ngann, ñapyaꞌ: “Gyre xguîlquiey ba psiaaḻdadzyaꞌ”, o ñapyaꞌ: “Biahsiꞌ no güzeꞌ”? ");
INSERT INTO zpg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Naa, Mpyquie-Pshahl Dioz Lee, glun laꞌd naa beeiy rsiaaḻdadzyaꞌ xguîlquie meññ. Were, ra me mpyquie-di raḻ gyniꞌby: ―Gapyaꞌ lii: Biahsiꞌ, gülesy xcamilliꞌ, no gübiꞌ xiryuꞌy. ");
INSERT INTO zpg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","No hor-caḻ gahc, biahs mpyquie-gayac-ure ñaz-lo gyre yâme, gülesy xcamill me, no zia gahc xiryuꞌ me, gaguguia me Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Gyre yâme rtzunadz no güluguia yâme Dioz zegahc. No bydzie yâme, ne yâme: ―¡Dzêrieꞌ yaa we bwieꞌ nó xroꞌ cos yahc! ");
INSERT INTO zpg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Luxu, byruu Jesúz, za me sto lad. Hor-gadedy me to lgar‑e naꞌ, bwieꞌ me to meññ-rguquix mpuezd, le Leví, dxie ru rtzoo dziiñ. Were ra Jesúz leeme: ―Güde, náḻiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","No biahs gahc Leví, psaꞌn gyre xtziiñ me, no za me no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leví naꞌ, ptzoo me to lni-ro porni bydzihñ Jesúz xiryuꞌ me, no uga dxieno yâme xtahl meññ-rguquix mpuezd no zrieñ meññ mazy, dxie yahc ruꞌ miax ru gayahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Guzlo meññ-nac yahc fariseu no gahc muextr ni ruuḻ yahc xleiy Moiséz, galesyno yâme chehsh xmeññ Jesúz, ra yâme lee: ―¿Bia nacu rahgü laꞌd no meññ-rguquix mpuezd no zrieñ meññ-rtzoo gyrehzy guîlquie? ");
INSERT INTO zpg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Were ra Jesúz leeyâme: ―Meññ ni nzaꞌg nehx rquihñ tza lo doctor, mazyg meññ-gayac-ure, wé we rquihñ doctor. ");
INSERT INTO zpg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Naa nehx biaḻaꞌ zidyobyaꞌ meññ-tziaawy, mazyg meññ-guîlquie we zidyobyaꞌ leeyahc lehdy csaan yâme ni nahcsy ni nac yâme. ");
INSERT INTO zpg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Luxu ra yâme Jesúz: ―¿Bia nacu xmeññ Juaṉ ni rchôbnihs rtzoo yâme ayun no nehx rbiahz ni rnab yâme lo Dioz, no modé gahc rtzoo xmeññ meññ-nac yahc fariseu, per xmeññiꞌ aaḻ nitisy hór roo yâme no rahgü yâme? ");
INSERT INTO zpg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ra Jesúz leeyâme: ―¿Nehxni beeiy ntzoo laꞌd mdad meññ-nu lo guîltziahl di ñoo ñahgü no nu ziaꞌr ñoby-gayidzña lahd yâme? ");
INSERT INTO zpg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per ziaad dzé ru naa ni zidguiahc beeiy to ñoby-guidzña, ba dgueññaꞌ lahd yâme, were ctzoo yâme ayun no nehx zoo zahgü yâme. ");
INSERT INTO zpg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Gyzac günii Jesúz ndaagü lo diidz, ne me: ―Ndruhty nehx nchug lar-coby par nquieedy meu to lo lar-gush. Porni bâḻ leeu ñahcu ze la, nnidylou nicoby; no luxu, lar-coby zegahc nehx rieññu mos lo lar-gush. ");
INSERT INTO zpg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","No ndruhty nehx rguꞌ vin ni leer güyaa leññ to bush-guiedy ni ba nigush; porni bâḻ leeu ñahcu ze la, nchiahzu bush-guiedy ni ba nigush, no nnitylou vin no zegahcu bush. ");
INSERT INTO zpg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Leewe vin ni leer güyaa rahpu de ni tzuw leññ bush-guiedy ni ncoby, no were gyropu nehx zahc mbehty. ");
INSERT INTO zpg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","No ndruhty ni roo vin-gush nehx ñuꞌladzy ñoo vin ni leer güyaa, porni leeyâme ma rguguia yâme vin-gush, ne yâme: “Leeu we ma mos.” ");
INSERT INTO zpg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","To dze-risladzy meññ, güdedy Jesúz leññ to lyu ru dziib trigü, guzlo gahc xmeññ me gachuꞌ xdo trigü; no gazohb yâme ladzyu no gayahgü yâme leeu. ");
INSERT INTO zpg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Niwé bwieꞌ lahd meññ-nac yahc fariseu, ra gahc leeyâme: ―¿Bia nacu gatzoo laꞌd dziiñ ni ne leiy nehx xñahzu gac dze-risladzy meññ? ");
INSERT INTO zpg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Were ra Jesúz leeyâme: ―¿Dgueññ guuḻ laꞌd ni ptzoo Davit tzcaḻ, dze-bylahn me no gahc meññ-zidno me la? ");
INSERT INTO zpg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Güyuꞌ me leññ xiydoo Dioz no cuaꞌ me paṉ ni guhc gun par Dioz, güdahgü me lee, ni ne leiy nehx beeiy rahgü nyugz meññ lee mazyg nunzy bahl, no bdee meu güdahgü meññ-zidno me zegahc. ");
INSERT INTO zpg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","No ra Jesúz: ―Naa we Mpyquie-Pshahl Dioz Lee no rtzon mdad zegahc bia beeiy gac dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sto dze-risladzy meññ güyuꞌ Jesúz leññ idoo, no guzlo gahc me galuu me meññ. No nuty to mpyquie lahd meññ uga, gübihdzy to ña me lad-drech. ");
INSERT INTO zpg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Uga dxie muextr zegahc ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, guzlo galaꞌdzy yâme Jesúz lehdy güieꞌ yâme bâḻ ssiaḻ me mpyquie-rieꞌ dze-risladzy meññ, lehdy gydzial yâme mod-gyruu yâme contr leeme. ");
INSERT INTO zpg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Per leeme nann me bia ganii leññ ihqy meññ-wé yahc. Were, ra Jesúz mpyquie ni gübihdzy to ña: ―Biahsiꞌ, bigliahz glawy. “Yo” ne mpyquie-caḻ, bigliahz me glawy. ");
INSERT INTO zpg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Were ra Jesúz leeyâme: ―Gnabdiidzaꞌ laꞌd: ¿Bia beeiy ntzoo mu dze-risladzy meññ, ni mos la o ni nahcsy? ¿Nislaa mu to meññ de lo guîlguhty la, o ngaꞌdy mu leeme? ");
INSERT INTO zpg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Luxu, bwiedzie me gyre meññ-dxie gybi me, no ra me mpyquie-caḻ: ―Biscaa ñay. Were biscaa ña mpyquie-caḻ, no biaḻ gahcu. ");
INSERT INTO zpg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Niwé bwieꞌ yâme, modni bydziaꞌdzy yâme, no guzlo gatzoo yâme diidz xnahc ntzoo yâme lehdy gyruu yâme contr Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Leññ gahc dze-wé, güya Jesúz chehsh to dahñ, bigynino me Dioz. No wé güdedy me guiaal, ganino me lee. ");
INSERT INTO zpg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ni byre guiaal‑e naꞌ, ptohp me xmeññ me, no güle me tzipychop yâme. Meññ-wé güluꞌ me le apóstl ni cshahl me lee dzictzoo xtziiñ me. ");
INSERT INTO zpg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Leeyâme we meññ-rieꞌ yahc: Simóṉ, ni gülu-le me lee Pedr, no behtzy me Ndréz, Jacob no Juaṉ, Felipy no Bartolomé, ");
INSERT INTO zpg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateu, Tomáz, Jacob xiiñ Alfeu, Simóṉ ni güyuꞌ lahd to cuib meññ ni le Zelot, ");
INSERT INTO zpg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jud behtzy Jacob, no Jud-Iscariot, ni byluxu bdee Jesúz lo ña meññ-rdziadzyno leeme. ");
INSERT INTO zpg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Luxu, biaht Jesúz dahñ no leeyâme, bydzihñ yâme to rulahtzy. Bydohp xmeññ me no zrieñ meññ yahc ni byruu lo ṟegioṉ-Judea, no ciuda-Jerusaléṉ, no zrieñ meññ byruu coo nisdoo ru nu chohp ciuda ni le Tiro no Sidóṉ. ");
INSERT INTO zpg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Meññ-rieꞌ biahd yâme, bidguieññ yâme ni rnii Jesúz no par csiaḻ me xguîlguihdz yâme. No psiaḻ me meññ-gatzoo gasahc mbenahcsy lee. ");
INSERT INTO zpg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","No gyre yâme racladzy can Jesúz, porni rruu poder leeme ni rsiaḻ gyre meññ-gayac-ure. ");
INSERT INTO zpg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Luxu bwieꞌ Jesúz ru dxie xmeññ me no ra me lee: ―Dxu ñahc beeiy laꞌd ni nehx rahp ni tedydzé, porni xchieñ laꞌd‑e gyre ni rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Dxu ñahc beeiy laꞌd ni rlahn ni naꞌ, porni ziaadr dzé we ni gydzeꞌ laꞌd no ziuꞌ laꞌd mos. ’Dxu ñahc beeiy laꞌd ni gayuun ni naꞌ, porni ziaadr dzé we ni gyxihly laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Dxu ñahc beeiy laꞌd hor-gadziadzyno meññ laꞌd, no rboxtzu yâme laꞌd, no rdeḻy yâme laꞌd, no di ne yâme guieññ le laꞌd ni ne yâme to ni nahcsy‑e lee, no rtzoo yâme ze porni naa we Mpyquie-Pshahl Dioz Lee no rtzoo laꞌd ni ren. ");
INSERT INTO zpg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ma lâ gyxihly xtâ glo ru beeiyu, porni gybaa nu to xroꞌ ni mos ni gady laꞌd lee; porni zegahc‑e bgultihp xtadgul yâme profet yahc ba xtze. ");
INSERT INTO zpg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Per baazy dzii de laꞌd ni rahp xtahl medy, porni ba biahcladzy laꞌd no ni rdibylgaa lo gahc guiedzylie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Baazy dzii de laꞌd ni rahp xtahl ni rahgü, porni ziaadr dzé we ni gylahn laꞌd. ’Baazy dzii de laꞌd ni rxihdzy hôrrieꞌ. Porni ziaadr dzé we ni guieññ laꞌd to guîlrioob xtâ leññ xguîlmbahñ laꞌd, no hor-wé zuun laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Baazy dzii de laꞌd ni rguguia gyre meññ lee, porni mod-wé gahc‑e ptzoo xtadgul meññ-rguguia laꞌd hor-güluguia yâme meññ ni ne lee nac profet, nîcze nehx uliu. ");
INSERT INTO zpg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Per laꞌd ni gayieññ naa, gapyaꞌ laꞌd nirieꞌ: Lâ guîntzi meññ-rdziadzyno laꞌd, no lâ gac meññ-tziaawy no meññ-néladzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Lâ gnab lo Dioz cu xlaꞌy me meññ-rniwaty lo laꞌd, no lâ gnab lo Dioz güieꞌ me meññ-rtzilytó laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bâḻ dxuhch rgahp lo laꞌd, lâ gdee ñahz cap yâme sto ladu zegahc. Bâḻ dxuhch rboo shab-xtziguia laꞌd, lâ gdee gydiby xigmix laꞌd, ycaꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dxu rnab behch lo laꞌd, lâ gdeedyu. No dxu rboo ni nac xchieñ laꞌd, di ga laꞌd leeyâme mbehty. ");
INSERT INTO zpg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mod-racladzy laꞌd ctzoo meññ no laꞌd, mod-wé lâ ctzoo no leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Per bâḻ laꞌd ndzi laꞌd nunzy meññ ni ndzi laꞌd la, ¿biaz‑e naꞌ galesytziaawy laꞌd par gady laꞌd? Niwé gahcx rtzoo meññ-guîlquie. ");
INSERT INTO zpg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","No bâḻ racno laꞌd nunzy meññ-racno laꞌd la, ¿biaz‑e naꞌ galesytziaawy laꞌd par gady laꞌd? Niwé gahcx rtzoo meññ-guîlquie. ");
INSERT INTO zpg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","No bâḻ riscady laꞌd meññ, no luxu gabiahz laꞌd guiscady yâme laꞌd zegahc la, ¿biaz‑e naꞌ galesytziaawy laꞌd par gady laꞌd? Niwé gahcx rtzoo meññ-guîlquie par guibyguiat xchieñ saꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Per laꞌd, lâ guîntzi meññ-néladzy laꞌd, lâ gacno leeyâme, no lâ guiscady leeyâme no na di cuiahz laꞌd guiscady yâme laꞌd. No bâḻ ctzoo laꞌd ze la, ma xroꞌ ni gady laꞌd‑e, no mod-wé zieññ laꞌd‑e ulihbu xiiñ Dioz-nu gybaa. Porni Dioz, meññ-tziaawy‑e leeme xtâ no meññ-nehx rdee xquix leeme, no zegahcu no meññ-dirquihñ. ");
INSERT INTO zpg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Lâ guioob zâ-bynech laꞌd mod-rioob gahc xTad laꞌd meññ. ");
INSERT INTO zpg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Na di glaꞌdzy laꞌd ni nac meññ, no were nehx zahc laꞌd mod-wé gahc. No di gluu ña laꞌd, ga laꞌd meññ-wé gynihty me lo xguîlquie, no were nehx znii Dioz ze chehsh laꞌd. Lâ csiaaḻladzy laꞌd ni rtzoo meññ laꞌd, no were csiaaḻladzy Dioz xguîlquie laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Lâ gdee, no Dioz zdee laꞌd zegahc. No were zdee me laꞌd to mdid ni ma xtahl que ni ba bdee laꞌd, no xtâ zahpr laꞌd mazy; porni mdid ni rquee gahc laꞌd zrieñ meññ, leegahcu we squee Dioz mdid laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Luxu, günii Jesúz ndaagü lo diidz, ra me leeyâme: ―¿Nehxni beeiy nluu ngaḻ sto zâ-ngaḻ me ñahz? Bâḻ leeu ñahcu ze la, gyrop gahc yâme we ñahb tohzy leññ guieryu. ");
INSERT INTO zpg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ndruhty meññ-gazeedy ziaꞌ nehx ma ñann que xmuextr. Uli we zdzihñ dze-zann me beeiy gahc nann xmuextr me, per bâḻ cu ihqy me gyzeedy me. ");
INSERT INTO zpg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Bia nacu rlaꞌdzyiꞌ ni nac sto, luxu ma nahcsy ni naquiꞌ que leeme? ");
INSERT INTO zpg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Bia mód‑e beeiy gahbyiꞌ sto: “Gacnon lii par csaaniꞌ ni nahcsy ni naquiꞌ”; luxu lii ma nahcsy rtzooy que leeme, no nehx rwieꞌy xnahc naquiꞌ? Lii ni ne meññ-tziaawy lee nîcze nehx uliu, psaan gax gyre ni nahcsy ni naquiꞌ, no were beeiy gacnoy sto par csaan ni nahcsy ni nac. ");
INSERT INTO zpg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Nehx nu yag-tziaawy ndee cuannahsh ni nadz, no nehx nu yag-nadz ndee cuannahsh ni mos. ");
INSERT INTO zpg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Cad to yahg rzaclo meññ leeu por xqueꞌu. Nehx beeiy nchuꞌ mu duug lo yag-guiahtz, no nehx beeiy nchuꞌ mu blatzy to lo lbue-guiahtz. ");
INSERT INTO zpg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Meññ zidguiahc yâme we beeiy to yahg ni rqueꞌ xqueꞌ. Meññ-tziaawy la, rtzoo no rnii ni mos, porni ni mos nu leññ xguîlmbahñ yâme. No meññ-dirquihñ la, wé rtzoo no rnii ni dirquihñ, porni ni dirquihñ nu leññ xguîlmbahñ yâme. No diidz ni rruu ruꞌ meññ la, wé we ni rluu bia nu leññ xguîlmbahñ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Niglihg‑e ra laꞌd naa: “Señor, lii ni rtzoo mdad”; luxu, nehx rtzoo laꞌd ni ren. ");
INSERT INTO zpg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gapyaꞌ laꞌd dxu zidguiahc meññ ni ridguieññ dtiidzaꞌ no rtzoo mod-neu. ");
INSERT INTO zpg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Leeme we beeiy to mpyquie ni bzaa to yuꞌ; nier güdahñ me guiat no güloo me nieꞌu chehsh guie; ru byruu nisrodoo, güdedy nzeꞌ ru zob yu-wé, per mbehty di ñahcu, porni zobu chehsh guie. ");
INSERT INTO zpg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Per meññ ni ridguieññ dtiidzaꞌ no nehx rtzoo mod-neu la, wé zidguiahc beeiy sto mpyquie ni bzaa xyuꞌ lo yux, no di mboo nieꞌu zaꞌgndzi; gahdy hor-byruu nisro, bydzihñ nzeꞌ xtâ ru zobu, psiahbu yu-wé, no bynitylo gyreu. ");
INSERT INTO zpg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Byluxz bluu Jesúz meññ, za me guiedzy-Capernaum. ");
INSERT INTO zpg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Uga nu to capitáṉ ni byruu Ṟom, rahp to mós ni ndzi me lee. Per gayac-ure mos-caḻ, ba par gaty. ");
INSERT INTO zpg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ru bieññ capitáṉ gayu meññ diidz de Jesúz, pshahl gahc me chohp tzonn mînguhl yahc ni nac guxtisy lahd meññ-Isṟael, zigyne yâme Jesúz bâḻ beeiy tza me csiaḻ me xmós capitaṉ-wé. ");
INSERT INTO zpg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bydzihñ yâme, gatzunñaad yâme Jesúz, no ra yâme leeme: ―Gucno capitaṉ-rieꞌ; par noꞌ to meññ-rsahc‑e leeme; ");
INSERT INTO zpg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","porni ndzi me meññ-Isṟael, no xtâ diydoo noꞌ, gunn me güyaau. ");
INSERT INTO zpg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","“Yo” ne Jesúz, za no leeyâme. No ru ba gadzihñ yâme gahsh gá de ruꞌ yuꞌ we naꞌ, pshahl capitáṉ xmígü me, zigyne yâme Jesúz mod-rieꞌ: ―Ne capitáṉ: “Lii ni rtzoo mdad, di gydziaꞌdzyiꞌ de ni guiaadiꞌ diryuꞌn, porni ndruhty nehx nacaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","No leewe nehx biaḻaꞌ naa yoꞌby, nidyobyaꞌ lii. Per günihzy, ba gahc biaḻ dmósaꞌ we. ");
INSERT INTO zpg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Naa nannaꞌ xnahc rahc mdad, porni nu dxu rtzoo mdad naa, no zegahc nu soldad ni rtzon mdad leeyahc. Hor-gapyaꞌ to lahd yâme tza bahch, zia. No hor-gapyaꞌ sto lahd yâme guiaad, ba gahc ziaad. No hor-rshaalaꞌ dmósaꞌ dzictzoo me behch, rtzoo me leeu.” ");
INSERT INTO zpg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ru bieññ Jesúz niwé we naꞌ, ptzunadz me no bwieꞌ gahc me lo meññ-zidno me, no günii me ne me: ―Gapyaꞌ laꞌd, ni to lahd meññ-Isṟael nehx bydzialaꞌ meññ ni rlíladzy beeiy mpyquie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","No hor-gubyguiat meññ-bigyne Jesúz ruꞌ yuꞌ, bydzihñ yâme, ba biaḻ xmós capitáṉ. ");
INSERT INTO zpg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Luxu, za Jesúz sto guiedzy ni le Naíṉ. No ziyno me xmeññ me no zrieñ meññ mazy. ");
INSERT INTO zpg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hor-bydzihñ yâme ruꞌ guiedzy, bwieꞌ me ziycaꞌdzy meññ to mînguhty, xñooby to ngünaviud, xiñ-ngahc me. Xtahl meññ-guiedzy ziyno leeme. ");
INSERT INTO zpg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ru bwieꞌ Jesúz ngüna-wé naꞌ, bioob me lee, no ra me: ―Ba di guunriꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Luxu, gübigy me coo taú no güdan me chehshu, no güliahz gahc meññ-ngüyañ leeu. Were günino Jesúz ñoby-guhty, ra me lee: ―¡Biahsiꞌ! Naa we ganino lii. ");
INSERT INTO zpg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Gürieli gahc ñoby-caḻ ni ba guhty no guzlo gahc ganii me. Luxu, bdee Jesúz leeme xmam me. ");
INSERT INTO zpg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ru bwieꞌ gyre yâme ni guhc, bydzie yâme no guzlo gaguguia yâme Dioz, no ne yâme: ―To profet ni beeiyu lee bidtzu dlahd nó. No ne yâme: ―Dioz ba biahd par gacno xmeññ. ");
INSERT INTO zpg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gydo-bynac lo ṟegioṉ-Judea no gyre guiedzy-yaañ ni nu gahsh, gunn meññ ni ptzoo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bie xmeññ Juaṉ diidz lo me ni ptzoo Jesúz. Were pquee Juaṉ riedz chohp xmeññ me, ");
INSERT INTO zpg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","no pshahl me lee bignabdiidz yâme Jesúz bâḻ ulihbu leeme ni nac diidz guiaad ni cshahl Dioz lee, o bâḻ cuiahz yâme zrieñ. ");
INSERT INTO zpg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bydzihñ meññ-pshahl Juaṉ lee, ra yâme Jesúz: ―Juaṉ ni rchôbnihs pshahl me noꞌ, zidnabdiidz noꞌ bâḻ lii we ni nac diidz guiaad ni ne Dioz cshahl me lee o cuiaaz noꞌ zrieñ. ");
INSERT INTO zpg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lohb hor-wé bydzihñ yâme gasiaḻ Jesúz xtahl meññ-gayac-ure no meññ ni nu yoob lee, no meññ ni nu mbenahcsy lee, no pshal me lo meññ-ngaḻ yahc. ");
INSERT INTO zpg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Were ra Jesúz leeyâme: ―Lâ tza, lâ gu diidz lo Juaṉ gyre ni bwieꞌ laꞌd no gyre ni bieññ laꞌd neꞌ. Lâ ga leeme meññ-ngaḻ ba rwieꞌ, meññ-ndang ba rzeꞌ, meññ-gayudz lady riaḻ de xguîlguihdz, meññ-nguat ba rieññ, mînguty rbahñ, no meññ-pobr ba gayieññ xtiidz Dioz; ");
INSERT INTO zpg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","no dxu ñahc beeiy meññ ni rlíladzy naa no nehx rxiññladzy. ");
INSERT INTO zpg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Byluxz byruu meññ-pshahl Juaṉ lee, guzlo Jesúz gaya me meññ bia rtzoo Juaṉ: ―Hor-güya laꞌd lo yu-bihdzy ru ziaad Juaṉ, ¿bia bigüieꞌ laꞌd? ¿To ni zidguiahc beeiy gobgui ni rchaḻ mbeꞌ lee la? ");
INSERT INTO zpg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O bâḻ yac, ¿bia bigüieꞌ laꞌd? ¿To mpyquie ni ruhtz lar-rsahc bigüieꞌ laꞌd lee la? Zoꞌn yacu, porni nann laꞌd, meññ-ruhtz lar-rsahc no ni riuꞌladzy cos de guiedzylie, li ṟeiy‑e riuꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Bia bigüieꞌ laꞌd? ¿To profet la? Ze we leeu, no gapyaꞌ laꞌd, mazy que to profet‑e mpyquie ni bigüieꞌ laꞌd lee. ");
INSERT INTO zpg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","De Juaṉ‑e ganii lo Guehtzy ru queꞌ xtiidz Dioz, ni ne: Naa cshaalaꞌ to dmeññaꞌ ni sunier loꞌy, tziyno me dtiidzaꞌ lo meññ; leeme guistziaawy me ru tedyiꞌ scâsy ractziaawy to ñahz. ");
INSERT INTO zpg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Lâ guieññ ni gapyaꞌ laꞌd: Lahd gyre meññ, nehx güyuꞌ sto profet ni niygahl beeiy Juaṉ ni rchôbnihs; per luxu naꞌ, ni ma lwiñ ru rtzoo Dioz mdad, wé ma qysahc que Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hor-bieññ gyre meññ nirieꞌ, no meññ-rguquix yahc mpuezd, gunn yâme xtiidz Dioz xñahzu we, no biuꞌladzy yâme pchôbnihs Juaṉ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per meññ-nac yahc fariseu naꞌ no zrieñ muextr ni nann yahc leiy, nehx biuꞌladzy yâme ñac yâme xmeññ Dioz, no di ne yâme nchôbnihs Juaṉ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","No ne Jesúz: ―¿Biahx‑e nsacaꞌ meññ-nu ni naꞌ? ");
INSERT INTO zpg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rluu yâme beeiy mbiux ni rbia lóguiaꞌ, rquee riedz saꞌ, ne: “Pcuadz noꞌ bdzia, per di nyeꞌ laꞌd; biiḻy noꞌ cancioṉ-trixd, per di ñuun laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Porni biahd Juaṉ ni rchôbnihs, nehx rahgü sca ni rahgü laꞌd no nehx roo sca ni roo laꞌd, ne laꞌd bêndzab we nu leeme. ");
INSERT INTO zpg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","No zegahc rwieꞌ laꞌd naa, Mpyquie-Pshahl Dioz Lee, rahguaꞌ no roon, no ne laꞌd to meññ-la no meññ-roo nistzuuñ‑e naa. No ne laꞌd zegahc, naa we xmígü nyug meññ-rguquix mpuezd no zrieñ meññ-nehx rlaby ni ne leiy. ");
INSERT INTO zpg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Per xguîlnann Dioz rdee diidz por ni mos ni rtzoo gyre xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Byruu to meññ-nac fariseu, ra me Jesúz: ―Tzo nó diryuꞌn, dzictahgü nó. Were güya Jesúz. Hor-bydzihñ me, gürie me ruꞌ miax. ");
INSERT INTO zpg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Leññ guiedzy-wé nu to ngüna-guîlquie, no ru bieññ me diidz dxie Jesúz xiryuꞌ fariseu, cuaꞌ gahc me to frascü ni güyaa no guie ni le alabastro ni nu ceitnixye leññ, ziyno meu ru dxie Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ru bydzihñ me, gayuun me, no guzlo gahc gaguihby me nieꞌ Jesúz no nzelo me. No luxu, gachee meu no xguitz-ihqy me no gacuruꞌ me nieꞌ Jesúz. No luxu, güluꞌ me ceitnixye nieꞌ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ru bwieꞌ fariseu ni gatzoo me we naꞌ, günii leññ ihqy me, ne me: “Ñahc uliu profet mpyquie-rieꞌ la, ñann me dxu we ngüna-rieꞌ ni gagan leeme, no ñann me ngüna-dirquihñ‑e lee ni nu guîlquie chehsh.” ");
INSERT INTO zpg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Were ra Jesúz fariseu: ―Simóṉ, rapaꞌ to ni gapyaꞌ lii. Ra me Jesúz: ―Guw naa, Muextr. ");
INSERT INTO zpg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ra Jesúz leeme: ―Güyuꞌ chohp mpyquie ni nzahby meññ-ristiꞌñ. To me nzahby medy sahc xchieñ beeiy diby ihz no shun mboo, no sto me nzahby medy sahc xchieñ beeiy cincuent dzé. ");
INSERT INTO zpg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Gumm di ñaḻ nguix yâmeu la, mpyquie-bistiꞌñ ra me gyrop meññ-nzahby: “Ba nehx zguix laꞌd medy ni nzahby laꞌd.” Gu naa naꞌ, ¿dxu de leeyâme ma ndzi mpyquie-bistiꞌñ de lo gyrop yâme? ");
INSERT INTO zpg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ra Simóṉ leeme: ―Zoꞌ naa, mpyquie-nzahby mazy. Ra Jesúz leeme: ―Xñahzu mod-neꞌy. ");
INSERT INTO zpg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Were bidzguiat lo me ru dxie ngüna-caḻ, no luxu ra me Simóṉ: ―¿Bwieꞌy ni ptzoo ngüna-rieꞌ la? Hor-bydzihñaꞌ xiryuꞌy, nehx bdeedyiꞌ nzeꞌ, ñar dnien. Per ngüna-rieꞌ, güdihby me dnien no nzelo me no pchee meu no xguitz-ihqy me. ");
INSERT INTO zpg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nehx pcuruꞌy naa. Ngüna-rieꞌ, xtâ glo hor-bydzihñaꞌ, gacuruꞌ me dnien. ");
INSERT INTO zpg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni di nguꞌy ceihd diqyaꞌ. No leeme güluꞌ me ceitnixye dnien. ");
INSERT INTO zpg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ngüna-rieꞌ ndzi me naa, no gyre xguîlquie me ni modni xtahl, gyreu psiaaḻladzy Dioz lee. Meññ ni uxiee ziaꞌ gasiaaḻladzy Dioz xguîlquie la, uxiee gahc‑e ndzi yâme naa. ");
INSERT INTO zpg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Were ra me ngüna-caḻ: ―Ba psiaaḻdadzyaꞌ xguîlquiey. ");
INSERT INTO zpg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Guzlo zrieñ meññ-dxieno me ruꞌ miax uga, ganii leññ ihqy yâme, ne yâme: ―¿Dxuz‑e leeme mpyquie-rieꞌ? Xtâ guîlquie rsiaaḻladzy me. ");
INSERT INTO zpg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesúz naꞌ, ra me ngüna-caḻ: ―Ba bylaay‑e no ba nehx nu guîlquie chehshiꞌ, porni rlíladzyiꞌ. Zaꞌgru güya naꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Güdahpu stoozy dzé, byruu Jesúz, za me gyre ciuda no zrieñ guiedzy, zigyuno me meññ xtiidz Dioz no mod-rtzoo Dioz mdad. Ziyno me gydiby tzipychop xmeññ me, ");
INSERT INTO zpg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","no zrieñ meññ-ngünaa ni psiaḻ me lee de mbenahcsy no de zrieñ guîlguihdz. Lahd yâme ziaad Maríe, ni zegahc ra yâme lee Magdalen ni güloo me gahdzy mbenahcsy lee; ");
INSERT INTO zpg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","no Juan, tziahl to mpyquie ni le Chus ni rtzoo mdad meññ-rtzoo dziiñ leññ xpalacy Herody; no Susan, no zrieñ meññ-ngünaa mazy ni racno leeme. ");
INSERT INTO zpg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Byruu xtahl meññ to to guiedzy ni nu yahc gahsh, bidgüieꞌ yâme Jesúz; no hor-bydohp yâme we naꞌ, guzlo ganino me meññ ndaagü lo diidz, ne me: ");
INSERT INTO zpg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Güyuꞌ to mpyquie, güya me, bicchaꞌdz me ladzy trigü lehdy gylahñu. Lóni gachaꞌdz me leeu we naꞌ, doozyu biahb coo ñahz ru güdedy meññ ni güzeꞌ leeu, no biahd mayaañ güdahgü yâmaꞌ leeu. ");
INSERT INTO zpg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Stoozyu biahb chehsh guie ru dxie doozy dzii yu. Guzlo gülahñ yahcu, per ngueeḻy gahc gübihdzyu, porni nehx rahpu gohp. ");
INSERT INTO zpg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Stoozyu biahb ru rlahñ guix-guiahtz. No guix-guiahtz ni gülahñ lahdu di ndee ñahz nniꞌzyu. ");
INSERT INTO zpg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Per stoozyu biahb lo yu-tziaawy, wé bygaꞌy no cueꞌ mos: xtâ diby gayuu gá ladzyu cueꞌ to lo xan. Bylux günii me nirieꞌ, günii me ndip, ne me: ―Bâḻ racladzy laꞌd gann laꞌd bia ganin la, lâ yquee ihqy laꞌd dtiidzaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Were ra xmeññ me leeme: ―¿Bia we rnii ni güniiy ndaagü lo diidz? ");
INSERT INTO zpg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ra me leeyâme: ―Laꞌd, bdee Dioz lsenzy gann ni nungaꞌdzy de mod-rtzoo me mdad. Per zrieñ meññ la, wé gyninon lee pur ndaagü lo diidz. Were nîcze güieꞌ yâme, per guiaꞌn yâme beeiy ni di rwieꞌ; no nîcze guieññ yâme, per nehx zann yâme bia leeu. ");
INSERT INTO zpg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Nirieꞌ we ni rnii ni günin ndaagü lo diidz: Ladzy trigü zidguiahc beeiy xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Doozyu ni biahb coo ñahz zidguiahc beeiy meññ-rieññ xtiidz Dioz, per luxu riahd bêndzab rboo leeu leññ xguîlmbahñ yâme lehdy di gylíladzy yâme no lehdy di gylaa yâme de lo guîlnadz. ");
INSERT INTO zpg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ni biahb chehsh guie ru dxie doozy dzii yu la, wé zidguiahc beeiy meññ-leer rieññ xtiidz Dioz no rxilyno yâme leeu; per gumm zidguiahc yâme beeiy plant ni nehx günahzy lo yu zaꞌgndzi la, nunzy doozy dzé rlíladzy yâme; no hor-gzacno yâme por xtiidz Dioz, ba rrugan yâme. ");
INSERT INTO zpg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ni biahb lahd guix-guiahtz zidguiahc beeiy meññ-rieññ xtiidz Dioz, per luxu ma rguꞌ ihqy yâme ni nu lo guiedzylie, no riuꞌladzy yâme gap yâme xtahl medy no ctzoo yâme gyrehzy ni nehx riuꞌladzy Dioz, no modé rahc yâme beeiy plant ni nehx rqueꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Per ni biahb lo yu-tziaawy, wé zidguiahc beeiy meññ-riaꞌn ndip lo xtiidz Dioz; rahp yâme to guîlmbañ-tziaawy no rlaby yâme ni nac xñahzû; rtibladzy yâme nitisy riahd no modé rahc yâme beeiy plant ni rqueꞌ xtahl. ");
INSERT INTO zpg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Nehx nu ndruhty nguꞌ gue to lampr no ntuꞌz behch leeu, o nzu me leeu leññ to luꞌn; mazyg ru guia we rzu me leeu, lehdy hor-tzu meññ yuꞌ, zwieꞌ yâme byniꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Porni nehx ziaꞌn mbehty ngaꞌdzy no di gyxal lou; no nehx ziaꞌn mbehty ni nungaꞌdzy, gyreu zieññ no gyruu lo byniꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Lâ gnâbladzy laꞌd guieññ laꞌd zaꞌgndzi; porni dxu beeiy rquee ihqy dtiidzaꞌ, scaꞌ me dguîlriehñaꞌ mazy; no dxu di yquee ihqy dtiidzaꞌ la, xtâ doozy guîlriehñ ni rzaꞌ leññ ihqy me rahp me, zruuw leeme. ");
INSERT INTO zpg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tohzy bydzihñ xmam Jesúz no meññ-behtzy me ruꞌ yuꞌ ru dxie me leññ, per di ñaḻ ñuꞌ yâme porni bydzeꞌ meññu. ");
INSERT INTO zpg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Were byruu to lahd meññ, ra me Jesúz: ―Xmamiꞌ no meññ-behtzyiꞌ zu stziuꞌ racladzy güieꞌ lii. ");
INSERT INTO zpg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Per ra me: ―Dxu rieññ xtiidz Dioz no rtzoo ni neu, wé we dmamaꞌ no wé we meññ-dbetzy yahcaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","To dzé güyuꞌ Jesúz leññ to barcü no xmeññ me, no ra me leeyâme: ―Tedy nó stiby chehsh nisdoo. Were zahdy yâme. ");
INSERT INTO zpg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hor-ba za yâme we naꞌ, gutgahsy Jesúz. Were guzlo byxuu mbedun-ro no gayuꞌ nzeꞌ leññ barcü, lé rluu ba guiaꞌbu. ");
INSERT INTO zpg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Were psiuꞌ yâme lo Jesúz, ra yâme leeme: ―¡Muextr! ¡Nó ba gayaꞌb! Were biahs Jesúz, ra me mbeꞌ no x‑oḻ nisdoo: ―¡Lâ tzudzie! Güliahz gahc mbedun, no gyreu güyuꞌ dzie. ");
INSERT INTO zpg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Were ra me xmeññ me: ―¿Bia nacu di rlíladzy laꞌd naa? Per aaḻ bydzie yâme Jesúz, porni bwieꞌ yâme rtzoo me ni nehx beeiy rtzoo meññ, no guzlo ganabdiidz saꞌ yâme, ne yâme: ―¿Dxuz‑e leeme mpyquie-rieꞌ? ¡Xnahc‑e xtâ mbedun no nisdoo rzoob xtiidz me! ");
INSERT INTO zpg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Byruu yâme lo ṟegioṉ-Galilea, bydzihñ yâme stiby chehsh nisdoo lo xilyu meññ-gadaren. ");
INSERT INTO zpg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Scâsy byruu Jesúz leññ barcü, biahd gahc to mpyquie ni nac meññ-guiedzy-wé; ba xtze nu mbenahcsy leeme. Gaꞌy me rzeꞌ me no nehx rbia me xiryuꞌ me, mazyg tirgahc nu me lahd baa. ");
INSERT INTO zpg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ru bwieꞌ me Jesúz‑e naꞌ, pquee me to riedz no bisshiby gahc me lo, ra me lee: ―¿Bia racladzyiꞌ ctzooy naa, Jesúz? Naa nannaꞌ lii we Xiiñ Dioz-nu gybaa. Rnabaꞌ di ctzoo csahquiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Günii me ze, porni gatzoo Jesúz mdad gyruu mbenahcsy ni nu leeme. Mbenahcsy naꞌ ba xtze gatzoo gasahcu leeme; no xtahl vuelt rlihby meññ leeme no caden, per rchug me leeu no luxu ba ziyno mbenahcsy leeme ru nehx nu meññ. ");
INSERT INTO zpg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Were ra Jesúz leeme: ―¿Dxu ley? Ra me: ―Dlen Legióṉ. Gu me ze, porni xtahl mbenahcsy nu leeme. ");
INSERT INTO zpg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","No günab mbenahcsy yahc Jesúz di cshahl me leeyahcu leññ guieryu-guiat ru nu mînguty. ");
INSERT INTO zpg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Gahsh gá de uga nu xtahl ngutzy chehsh to dahñ, gayahgü yahc. Günab mbenahcsy Jesúz gdee me lgar tzu yahcu ngutzy-caḻ. Were bdee Jesúz lgar güyuꞌ mbenahcsy leeyâmaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Were byruu mbenahcsy mpyquie-wé, bictzuw ngutzy. Luegü gahc guzlo byxuunn yahc maꞌ. Lóni za yâmaꞌ, byrîbydahñ gyre maꞌ to ruꞌ zaꞌn xtâ lo nisdoo, bigydibylgaa gyre yâmaꞌ, no wé guhty gyre maꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ru bwieꞌ meññ-gayahp ngutzy mod-guhc, byxuunn gahc yâme, zigyne yâme meññ leññ guiedzy no meññ ni nu yahc dahñ. ");
INSERT INTO zpg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Luegü gahc güya meññ bigüieꞌ ni guhc. Hor-bydzihñ yâme ru zu Jesúz, bwieꞌ yâme mpyquie-wé ni byruu mbenahcsy lee, dxie ru zu me, ba nutz shab no ba nza xguîlriehñ. No bydzie yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","No meññ-bwieꞌ yahc mod-ptzoo Jesúz, bie yâme diidz bia mód biaḻ mpyquie ni güyuꞌ mbenahcsy lee. ");
INSERT INTO zpg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Were ra gyre meññ-caḻ yahc Jesúz: ―Rnab noꞌ lii gyruuy de neꞌ, ―porni gadzie yâme leeme. Were güyuꞌ Jesúz leññ barcü lehdy guibyguiat me lo ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Per mpyquie-wé naꞌ ni byruu mbenahcsy lee, antzy ni gyruu Jesúz, ra me lee ña me ru za. Per ra Jesúz leeme: ");
INSERT INTO zpg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Gubyguiat xiryuꞌy no bie diidz lo meññ xnahc xroꞌ ni ptzoo Dioz no lii. Were gubyguiat me xiryuꞌ me, no guzlo bie me diidz lo meññ xnahc xroꞌ ni ptzoo Jesúz no leeme. ");
INSERT INTO zpg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ru gubyguiat Jesúz lo ṟegioṉ-Galilea, bigydzil-lo meññ leeme no guîlrxihly; porni gyre yâme gabiahz leeme. ");
INSERT INTO zpg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tohzydzi bydzihñ to mpyquie-nu idoo xcargü ni le Jair. Bisshiby me lo Jesúz no günab me lee tziyno me lee xiryuꞌ me, ");
INSERT INTO zpg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porni gayac-ure xindzabdxur-ngahc me ni rahp beeiy tzipychop ihz, ba par gaty. Were za yâme, no náḻ xtahl meññ leeme, lé raꞌñ yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lahd yâme za to ngünaa ni gayac-ure de guidzngünaa, ba rahp tzipychop ihz. No ba bisree me gyre ni güdahp me lehdy güdix me doctor ni bdee ṟemedy leeme, per ni to yâme di ñaḻ nsiaḻ leeme. ");
INSERT INTO zpg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Gübigy me ñaz-chehsh Jesúz, no güdan me nieꞌ shab; no lohg hor-wé biaḻ me de xguîlguihdz me ni gazahc me. ");
INSERT INTO zpg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Were ne Jesúz: ―¿Dxu leeme güdan naa? Ra gyre yâme leeme: ―Nehx güdan noꞌ lii. Were Pedr no zrieñ meññ-zu yahc no leeme, ra yâme Jesúz: ―Muextr, meññ-xtahl gadohp gybiy no gayaꞌñ lii, no neꞌy: “¿Dxu güdan naa?” ");
INSERT INTO zpg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ra Jesúz leeyâme: ―Nu meññ-güdan naa, porni bieññaꞌ byruu poder naa ni psiaḻ. ");
INSERT INTO zpg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Bwieꞌ ngüna-wé nehx beeiy ncaꞌdzy me. Were güya me, biguisshiby me lo Jesúz, lé rzîbyyoob me de dzieeby, no günii me ñaz-lo gyre meññ bia nacu güdan me lo shab Jesúz. No ra me lo gahc hor-güdan me lo shab, biaḻ gahc xguîlguihdz me. ");
INSERT INTO zpg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Were ra Jesúz leeme: ―Shiꞌñ, porni rlíladzyiꞌ naa, leewe biaḻiꞌ. Zaꞌgru güya naꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ganii ziaꞌ Jesúz ze, bydzihñ to meññ ni byruu xiryuꞌ mpyquie-nu idoo xcargü ni zidne, ra leeme: ―Xindzabdxuuriꞌ ba guhty. Ba di gzacnñaadriꞌ Muextr. ");
INSERT INTO zpg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hor-bieññ Jesúz mod-ne meññ-bidne, were ra me Jair: ―Di gydziehbyiꞌ. Ni gylíhzyladzyiꞌ, ba gahc biaḻ xindzabdxuuriꞌ we. ");
INSERT INTO zpg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hor-bydzihñ Jesúz xiryuꞌ Jair, nehx bdee me lgar ñuꞌ zrieñ miꞌñ leññ yuꞌ no leeme, nunzy Pedr, no Jacob, no Juaṉ, no xtad no xmam ndzabdxuur. ");
INSERT INTO zpg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Gyre meññ-zu yahc uga gayuun porni rioobu leeyâme ndzabdxuur ni guhty. Per ra Jesúz leeyâme: ―Ba di guunr laꞌd. Dac‑e guhty me, nishcahsy me we. ");
INSERT INTO zpg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Aaḻ guzlo gaxidzyno yâme Jesúz, porni nann yâme ba guhty ndzabdxuur. ");
INSERT INTO zpg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Were günahzy Jesúz ña ndzabdxuur, no ra me lee: ―Ndzabdxuur, biahsiꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Luegü gahc gübahñ me no biahs gahc me, no ra Jesúz leeyâme: ―Lâ gdee ni gahgü me. ");
INSERT INTO zpg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Modni rtzunadz xtad me no xmam me. Per ra Jesúz leeyâme di gu yâme diidz lo ndruhty. ");
INSERT INTO zpg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ptohp Jesúz gydiby tzipychop xmeññ me, ptzoo me leeyâme meññ ni beeiy ctzoo xroꞌ cos, no ni beeiy ctzoo mdad gyruu mbenahcsy meññ, no ni beeiy csiaḻ xguîlguihdz meññ. ");
INSERT INTO zpg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","No luxu, pshahl me leeyâme dzigyuno yâme meññ mod-rtzoo Dioz mdad, no dzicsiaḻ gahc yâme meññ-gayac-ure. ");
INSERT INTO zpg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","No ra me leeyâme: ―Na tziyno laꞌd mbehty par lo ñahz: ni yagca, ni bush, ni paṉ, ni medy, ni chohp shab laꞌd; nunzy ni nutz laꞌd, lâ tziyno. ");
INSERT INTO zpg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yuꞌ ru gydzihñ laꞌd, uga lâ tzu xtâ glo gyruu laꞌd leññ guiedzy-caḻ. ");
INSERT INTO zpg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","No ru di ne yâme gdee ñahz gydzihñ laꞌd, lâ gyruu de uga no lâ cuihby yudé ni queꞌ nieꞌ laꞌd, lehdy gann yâme ni nahcsy‑e ptzoo yâme porni di ntzucas yâme laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Were zahdy yâme, rruu yâme to guiedzy, za yâme sto guiedzy. Gayuno yâme meññ xtiidz Dioz no gasiaḻ yâme meññ-gayac-ure gyre ru ria yâme. ");
INSERT INTO zpg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gunn gobernador-Herody gyre ni gatzoo Jesúz. Per nehx nann me dxuhb we Jesúz, porni nu meññ ne Juaṉ ni rchôbnihs‑e gübahñ gyzac, ");
INSERT INTO zpg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","zrieñ yâme ne Elíaz‑e gübahñ, zrieñ yâme ne dxuhch de lahd profet yahc ni güyuꞌ ba xtze we gübahñ gyzac. ");
INSERT INTO zpg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nehdy Herody: ―Dac‑e Juaṉ leeme, porni Juaṉ ptzon mdad pchuꞌ yâme ihqy. ¿Dxuhx‑e leeme mpyquie-rieꞌ ni rieññaꞌ de lee xtahl cos? No gayo Herody mód par güieꞌ me Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Gubyguiat apóstl yahc de ru pshahl Jesúz leeyâme, no bie yâme diidz lo me gyre ni ptzoo yâme. Luxu, ziyno Jesúz leeyâme diby lad to ru ndruhty nehx nu, gahsh gá to guiedzy ni le Betsaida. ");
INSERT INTO zpg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hor-gunn meññ bá glo za Jesúz, luegü gahc za yâme ru za me; no byxihly Jesúz ru bwieꞌ me gadzihñ yâme, no bieno me leeyâme de mod-rtzoo Dioz mdad, no psiaḻ me meññ-gayac-ure. ");
INSERT INTO zpg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ru ba udzie we naꞌ, gydiby tzipychop apóstl gübigy yâme, ra yâme Jesúz: ―Gu meññ-rieꞌ yahc tza yâme guiedzy-yaañ no zrieñ ru gahsh de neꞌ, lehdy beeiy guisladzy yâme no gyo ni gahgü yâme. Porni neꞌ lo camp, gydi mbehty. ");
INSERT INTO zpg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ra Jesúz leeyâme: ―Lâ gdee ni gahgü yâme. Ra yâme leeme: ―Nehx rahp noꞌ mbehty guîlrahgü, nunzy gaay paṉ no chohp mbaḻ. ¿Racladzyiꞌ dzicshii noꞌ ni gahgü gyre meññ-rieꞌ la? ");
INSERT INTO zpg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Beeiy gaay mily meññ-mpyquie ni zu yahc uga. Were ra Jesúz leeyâme: ―Lâ ga gyre meññ cuia yâme cuib por cuib, cincuent gá yâme. ");
INSERT INTO zpg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Were ptzoo yâme mod-wé par gürie gyre meññ-caḻ yahc. ");
INSERT INTO zpg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Luxu, cuaꞌ Jesúz gydiby gaay paṉ-caḻ lo ña me no gyrop mbaḻ. No gülesy lo me gybaa, bdee me xquix Dioz, no ptzulaꞌy meu, no bdee meu xmeññ me lehdy quiiz yâmeu ycaꞌ meññ-dxie yahc uga. ");
INSERT INTO zpg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gyre yâme güdahgü glo bydzeꞌ yâme. No ptohp xmeññ Jesúz tzipychop dzomby guîlrahgü ni biaꞌn. ");
INSERT INTO zpg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","To dzé ganino Jesúz Dioz to ru diby lad, no zegahc güiyno me xmeññ me, ra me leeyâme: ―¿Dxu we ne meññ naa? ");
INSERT INTO zpg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ra yâme leeme: ―Nu yâme ne Juaṉ ni pchôbnihs meññ‑e lii; zrieñ yâme ne Elíaz‑e lii ni güyuꞌ ba xtze; no zrieñ yâme ne dxuhch de lahd profet ni güyuꞌ ba xtze we gübahñ. ");
INSERT INTO zpg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ra Jesúz leeyâme: ―Naꞌz laꞌd, ¿dxu we ne laꞌd naa? Ra Pedr leeme: ―Lii we nac Crist, ni pshahl Dioz lee. ");
INSERT INTO zpg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Were ra Jesúz leeyâme na di ga yâme ndruhty dxu we leeme, ");
INSERT INTO zpg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","no ra me: ―Naa, Mpyquie-Pshahl Dioz Lee, rapaꞌ de ni tedyaꞌ xtahl guîlné; mînguhl yahc ni nac guxtisy, no xjefy yahc bahl, no muextr ni ruuḻ yahc xleiy Moiséz zruu yâme contr naa no zgaꞌdy yâme naa; per lo tzonn dzé zbahñaꞌ gyzac. ");
INSERT INTO zpg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Luxu, ra me gyre yâme: ―Dxu racladzy gac dmeññaꞌ lee la, csaan gyre ni nahcsy ni nac, no gbooladzy xtâ xguîlmbahñ, no ctzoo ni ren gyre dzé. ");
INSERT INTO zpg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dxu gacladzy guislaa xguîlmbahñ leegahc la, zniꞌdyu; per dxu gniꞌdy xguîlmbahñ por naa la, wé zahp guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mbahty nehx nquihñu par to meññ ñahc xchieñ me gyre ni nu lo guiedzylie, no luxu por leeu nniꞌdy xguîlmbahñ me. ");
INSERT INTO zpg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Porni dxu qytuno naa no dtiidzaꞌ la, zegahc‑e naa, Mpyquie-Pshahl Dioz Lee, stuꞌn gynin dmeññaꞌ leeyâme dze-guiaḻaꞌ lo dguîlbyniꞌn, no lo xguîlbyniꞌ dTadaꞌ no gyre x‑ángel me. ");
INSERT INTO zpg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Dziguiapyaꞌ laꞌd ni uli, nu lahd meññ-rieꞌ ni nu yahc neꞌ, nehx zehty sinn güieꞌ mod-rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Güdedy beeiy shun dzé de ni günii Jesúz mod-wé, güiyno me Pedr, Juaṉ no Jacob ihqy to dahñ par zigynino me Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ru ganino me Dioz, bydzee mod-nac lo me, no gucnquitzybo shab me, lé rcampytzeꞌu. ");
INSERT INTO zpg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lohg hor-wé bydzihñ chohp mpyquie ni güyuꞌ yahc ba xtze ni le Moiséz no Elíaz, guzlo gahc gayuno me lee diidz. ");
INSERT INTO zpg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","No guionn yâme zu to lo byni-ro, gayu yâme lguia de ni dziguiehty Jesúz Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Per Pedr naꞌ nu mpcaaḻ lo me no schohp meññ-zuno me; no nîcze ze leeu, ptibladzy yâme lehdy bwieꞌ yâme xguîlbyniꞌ Jesúz no gyrop mpyquie-zuno me lee. ");
INSERT INTO zpg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hor-ba za Moiséz no Elíaz‑e naꞌ, ra Pedr Jesúz: ―Muextr, ¡lehgxu zuu nó neꞌ! Gzaa noꞌ tzonn ṟamad, tohbyu par lii, stohbyu par Moiséz, no stohbyu par Elíaz. Per Pedr naꞌ, nehx nann me bia ganii me. ");
INSERT INTO zpg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ganii ziaꞌ me ze, tohzydzi gúḻ to zá ru zu yâme, modni bydzie yâme ru bwieꞌ yâme ba nu yâme leññ zá. ");
INSERT INTO zpg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","No lo za-wé bieññ to riedz ni ne: ―Nirieꞌ we dShiñaꞌ ni ndzin lee. Lâ guieññ ni ga me laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Luxu, hor-biandzie riedz-caḻ, ba nunzy Jesúz bwieꞌ yâme, no di nnii yâme mbehty. No leññ dze-caḻ, nehx bie yâme lo ndruhty ni bwieꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sto dzé, ru ziaht yâme dahñ, bigydzil-lo xtahl meññ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lahd yâme ziaad to mpyquie, pquee me riedz, ne me: ―Muextr, bwieꞌ dñoobyaꞌ ni ngacguie ni rapaꞌ; ");
INSERT INTO zpg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","rnahzy mbenahcsy leeme, lé rquee me riedz. No rzoobu mbeꞌ leeme, no rguiñguieu leeme lo yu, lé rboou mboo ruꞌ me; rtzoo rsahcu leeme, no nehx rruuw de leeme. ");
INSERT INTO zpg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ba günabaꞌ xmeññiꞌ mboo leeu leeme, per di ñaḻu leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Were ne Jesúz: ―¡Laꞌd ni nu ni naꞌ, nehx rlíladzyt naa no meññ-dirquihñ laꞌd! ¿Xtâ buc rapaꞌ de ni tzun lahd laꞌd, no xtâ buc beeiy ctibdadzyaꞌ laꞌd? Were ra me mpyquie-wé: ―Dno xiiñiꞌ neꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ru ba gadziñgahsh ñobywiñ ru zu Jesúz, güdiñguie mbenahcsy leeme lo yu, no bzoobu mbeꞌ leeme. Were güdeḻy Jesúz mbenahcsy no psiaḻ gahc me ñobywiñ, no luxu, bdee me lee xtad. ");
INSERT INTO zpg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ptzunadz gyre yâme, porni bwieꞌ yâme rtzoo Dioz ni nehx beeiy rtzoo ndruhty. Lóhgni gatzunadz gyre meññ-caḻ yahc de gyre ni rtzoo Jesúz, ra me xmeññ me: ");
INSERT INTO zpg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Lâ guieññ zaꞌgndzi ni dziguiapyaꞌ laꞌd. Naa Mpyquie-Pshahl Dioz Lee; zdee dxuhch naa lo ña meññ-rdziadzyno naa. ");
INSERT INTO zpg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per di ñieññ yâme ni ne me, porni nehx ziaꞌ rdee Dioz lsenzy gann yâme bia leeu. No rdzie yâme gnabdiidz yâme leeme bia leeu ni günii me. ");
INSERT INTO zpg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Guzlo gadeḻydiidz xmeññ Jesúz dxu de lahd yâme ma qysahc. ");
INSERT INTO zpg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Per Jesúz naꞌ, nann me bia ganii leññ ihqy yâme. Were biycaꞌ me to ñôbydxuur, bzu me lee coo me. ");
INSERT INTO zpg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Luxu, ra me leeyâme: ―Bâḻ dxuhch, porni rzobdiidz naa, gacno me mbiux-rieꞌ la, scâsy ñacno yâme naa we. No dxu ycaꞌ dtiidzaꞌ la, gacáꞌ yâme xtiidz Dioz ni pshahl naa. Porni lahd laꞌd dxu nehx rguguia leegahc la, wé we ni ma rsahc. ");
INSERT INTO zpg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Bylux günii Jesúz, ra Juaṉ leeme: ―Muextr, bwieꞌ noꞌ to mpyquie ni ganii ley lehdy gboo me mbenahcsy meññ, no ra noꞌ leeme ba di ctzoor me mod-wé, porni dac me ni ganzeno nó lee. ");
INSERT INTO zpg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Were ra Jesúz leeyâme: ―Di ycar laꞌd leeu leeme; porni dxu nehx néladzy nó la, gayacno me nó we. ");
INSERT INTO zpg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dze-ba bydziñgahsh ni gybiꞌ Jesúz gybaa, ba nu ihqy me tza me Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","No pshahl me meññ ni guznier zigyo ru gydzíe yâme to guiedzy-yaañ ni nu lo ṟegioṉ-Samary. ");
INSERT INTO zpg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Per hor-gunn meññ-nu leññ guiedzy-caḻ Jerusaléṉ tza me, di ndee yâme lgar ndzihñ me uga. ");
INSERT INTO zpg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ru bwieꞌ Jacob no Juaṉ di ne meññ-wé yahc ndee lgar ndzihñ me uga, were ra yâme Jesúz: ―Lii ni rtzoo mdad, ¿riuꞌladzyiꞌ gnab noꞌ gyruu gue gybaa par gniꞌdy leeyâme la, mod-ptzoo Elíaz ba xtze? ");
INSERT INTO zpg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Were bwiedzie Jesúz lo yâme no byduhsh lo yâme, ra me: ―Nehx nann laꞌd dxu gaquihly laꞌd gynihd ze. ");
INSERT INTO zpg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Dac‑e pshahl Dioz naa lo guiedzylie par zidnityaꞌ meññ. Pshahl me naa we par guislaan leeyâme. Luxu, güdedyñahz gahc yâme, za yâme sto guiedzy. ");
INSERT INTO zpg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hor-za yâme lo ñahz‑e naꞌ, byruu to mpyquie, ra me Jesúz: ―Lii ni rtzoo mdad, tzan no lii rutisy tzaꞌy. ");
INSERT INTO zpg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ra Jesúz leeme: ―Mbiaz rahp xcuev yahc maꞌ, no zegahc mashiily rahp xguehsh yahc maꞌ; per naa, Mpyquie-Pshahl Dioz Lee, nehx rapaꞌ ru rdzíen. ");
INSERT INTO zpg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ra Jesúz sto mpyquie: ―Náḻiꞌ naa. Ra mpyquie-caḻ leeme: ―Señor, lii ni rtzoo mdad, bdee ñahz nier tzan dziycatzyaꞌ dtadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ra Jesúz leeme: ―Psaꞌn meññ-nac yahc beeiy mînguty ycaꞌdzy yâme xmeññ yâme ni ba guhty. Per lii, güya bicsieññ meññ mod-rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Gyzac byruu sto, ra leeme: ―Lii ni rtzoo mdad, riuꞌdadzyaꞌ gácaꞌ xmeññiꞌ no tzo nó rutisy tzaꞌy. Per gax ndeedyiꞌ ñahz ñan nigynen difamilyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ra Jesúz leeme: ―Meññ ni rcaꞌ xtiidz Dioz no luxu nehx rsaan ni nahcsy ni nac, leeyâme we zidguiahc beeiy meññ-ridzguiat lo traz lóni gaquee rad. Zâ meññ-wé nehx rquihñ par tzu lahd xmeññ Dioz ni rtzoo mdad. ");
INSERT INTO zpg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bylux guhc gyre niwé, güle Jesúz setent xmeññ me pshahl me chohp ga yâme, za gyre guiedzy no zrieñ lgar ru tzar me. ");
INSERT INTO zpg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","No ra me leeyâme: ―Gapyaꞌ laꞌd ni uli, xtahl dziiñ‑e nu, porni xtahl meññ gabiahz guieññ xtiidz Dioz, per meññ-gatzoo xtziiñ Dioz, uxiee. No leewe, lâ gnab lo Dioz ni nac xbixwaan dziiñ, lehdy cshahl me meññ-tziyno xtiidz me byzaꞌzy. ");
INSERT INTO zpg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lâ tza. Naa gashaalaꞌ laꞌd lahd meññ-guiedzylie beeiy riuꞌ xiily lahd lob. ");
INSERT INTO zpg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Na tziyno laꞌd bush, ni medy, ni guidguial; no na di gylee laꞌd lo ñahz guno laꞌd diidz meññ. ");
INSERT INTO zpg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ru gydzihñ laꞌd xiryuꞌ meññ, nier lâ gynii diux, lâ ga: “Dioz cu xlaꞌy meññ-nu leññ yu-rieꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bâḻ nu to meññ-tziaawy leññ yu-wé la, ziuꞌ laꞌy leeme ru gynihd diux. Per bâḻ nehx nu ni to meññ-tziaawy la, ba nehx ziuꞌ laꞌy ni to yâme. ");
INSERT INTO zpg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","No tohzy leññ xiryuꞌ meññ-tziaawy‑e guiaꞌn laꞌd; na di gydzíe laꞌd yuꞌ por yuꞌ. Lâ gahgü no lâ goo ni gdee yâme laꞌd; porni meññ-rtzoo dziiñ la, xñahzu we guiax yâme. ");
INSERT INTO zpg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ru gydzihñ laꞌd to guiedzy no gdee meññ ñahz gydzihñ laꞌd xiryuꞌ yâme la, lâ gahgü nitisy gdee yâme laꞌd; ");
INSERT INTO zpg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","no lâ csiaḻ meññ-gayac-ure ni nu uga, no lâ ga leeyâme: “Ba bydziñgahsh dze-ctzoo Dioz mdad ru nu laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Per bâḻ gydzihñ laꞌd to guiedzy ru di ne yâme gylee laꞌd lahd yâme la, lâ tedyñahz gahc, no lâ ga: ");
INSERT INTO zpg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Xtâ xyudé guiedzy-rieꞌ ni queꞌ dnieꞌ noꞌ cuihby noꞌ lehdy gann laꞌd ni nahcsy‑e ptzoo laꞌd porni di ntzucas laꞌd noꞌ.” No lâ ga leeyâme: “Racdadzy noꞌ gann laꞌd ba bydziñgahsh dze-ctzoo Dioz mdad ru nu laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Gapyaꞌ laꞌd ni uli, dze-gac xguîlnadz Dioz, ma xroꞌ guîlné gabiahz meññ-nu guiedzy-wé que meññ-güyuꞌ yahc ciuda-Sodom. ");
INSERT INTO zpg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Baazy dzii de meññ-nu yahc guiedzy-Corasíṉ, no meññ-nu yahc guiedzy-Betsaida! Bâḻ meññ-Tiro no meññ-Sidóṉ nwieꞌ yâme gyre milagür ni ptzon leññ xguiedzy laꞌd la, ba xtze naꞌ psaan yâme ni nahcsy ni nac yâme, ñuhtz yâme lar-nahtz no ndziib yâme dé ihqy yâme. ");
INSERT INTO zpg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Per ma xroꞌ guîlné we gabiahz laꞌd dze-gac xguîlnadz Dioz que ni gabiahz meññ-Tiro no meññ-Sidóṉ. ");
INSERT INTO zpg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","No laꞌd, meññ-nu guiedzy-Capernaum, ne laꞌd guiahs laꞌd gybiꞌ laꞌd gybaa, per to ru nadz‑e tza laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Were ra me xmeññ me ni cshahl me lee: ―Dxu yquee ihqy xtiidz laꞌd la, dtiidzaꞌ we rquee ihqy yâme. No dxu rruu contr laꞌd la, contr naa we rruu yâme. No dxu rruu contr naa la, contr Dioz ni pshahl naa we rruu yâme. ");
INSERT INTO zpg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Gubyguiat gydiby setent meññ-pshahl Jesúz lee rxihly yâme, ra yâme leeme: ―Señor, xtâ mbenahcsy rzoob dtiidz noꞌ ru rnii noꞌ ley. ");
INSERT INTO zpg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ra Jesúz leeyâme: ―Naa bwien byruu bêndzab xtâ leññ gybaa, biahb me beeiy riahb ngüziee. ");
INSERT INTO zpg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Per ba ptzon laꞌd meññ ni beeiy ctzoo xroꞌ cos, xtâ chehsh mbaaḻ no mbiagü beeiy seꞌ laꞌd, no zegahc gyre ni rtzoo bêndzab beeiy zniꞌdy laꞌd lee, no nehx zahc laꞌd mbehty. ");
INSERT INTO zpg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Per di gyxihly laꞌd porni rzoob mbenahcsy xtiidz laꞌd; mazyg lâ gyxihly porni ba nu le laꞌd gybaa. ");
INSERT INTO zpg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lo gahc hor-wé, byxihly Jesúz por xiSpirt Dioz ni nu leeme, ne me: ―Rguguian lii, Dad, lii ni rtzoo mdad gybaa no guiedzylie, porni gülungaꞌdzyiꞌ gyre nirieꞌ lehdy di ñieññ meññ-nann no meññ-nniꞌ ihqy leeu, no ba bluuyu meññ-zidguiahc beeiy mbiux. Ze ptzooyu, Dad, porni ze biuꞌladzyiꞌ gacu. ");
INSERT INTO zpg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Gyre ni nu, ba bdee dTadaꞌ leeu naa lehdy ctzon mdadu. Ndruhty nehx rzaclo naa mod-rzaclo dTadaꞌ naa, no ndruhty nehx rzaclo dTadaꞌ mod-rzacloꞌn leeme; no dxu racdadzyaꞌ gzaclo dTadaꞌ, zacnon lee. ");
INSERT INTO zpg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Luxu, bwieꞌ me xmeññ me no günii me tziaawy gá, ra me nunzy leeyâme: ―Dxu ñahc beeiy meññ ni rwieꞌ gyre ni gawieꞌ laꞌd gayahc. ");
INSERT INTO zpg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Porni gapyaꞌ laꞌd, güyuꞌ xtahl profet no xtahl ṟeiy ni gucladzy nwieꞌ ni gawieꞌ laꞌd, per di nwieꞌ yâmeu; no gucladzy yâme ñieññ yâme ni gayieññ laꞌd, per di ñieññ yâmeu. ");
INSERT INTO zpg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Güya to lahd muextr ni nann yahc xleiy Moiséz zaꞌgndzi, bignabdiidz me Jesúz lehdy güieꞌ me bia ga leeme, no lehdy nsiahb me lee no to ni ngann. Ra me lee: ―Muextr, ¿bia mód ntzon lehdy ñapaꞌ guîlmbahñ ni nehx zluhx? ");
INSERT INTO zpg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ra Jesúz leeme: ―¿Bia ziaad lo leiy ni ruuḻiꞌ, no bia mód rieññiꞌ leeu? ");
INSERT INTO zpg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ra me Jesúz: ―Neu mod-rieꞌ: “Bzacbeeiy Dioz ni rtzoo mdad lii no gydo xguîlmbahñiꞌ, no gydo x‑almiꞌ, no xtâ ru beeiyu lii, no gydo xguîlriehñiꞌ. No bintzi zâ-bynechiꞌ mod-ndzi gahquiꞌ lii.” ");
INSERT INTO zpg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ra Jesúz leeme: ―Mer lehbu we mod-neꞌy. Naꞌ mod-wé we racladzyu ctzooy, lehdy were beeiy gapiꞌ guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per muextr naꞌ, lehdy ñaꞌn me mos lguia ni ganabdiidz me Jesúz mod-wé, were ra me Jesúz: ―¿No dxuz‑e leeme dsâ-bynechaꞌ ni guîntzin lee? ");
INSERT INTO zpg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ra Jesúz leeme: ―Güxahc to mpyquie. Byruu me Jerusaléṉ, za me to guiedzy ni le Jericó. Ru za me lo ñahz, byruu gübaan lo me, gülan yâme gyre xchieñ me, xtâ shab me cuaꞌ yâme. Luxu, güdihñ yâme leeme lé gutycawy me. Luxu, nasht me, za gübaan. ");
INSERT INTO zpg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tohzy güdedy to bahl, bwieꞌ nash me per nehx bylaby leeme. ");
INSERT INTO zpg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Zegahc güdedy sto meññ-Isṟael ni nac levit. Nehx bylaby me mpyquie-wé zegahc, aaḻ güdedy me ziht gá. ");
INSERT INTO zpg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Per hor-zictedy to meññ-samaritan, ni za xviajy, bwieꞌ nash mpyquie-wé coo ñahz, bioob me lee. ");
INSERT INTO zpg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Were güya me ru nash par güdihby me lo xrid no ceihd no alcol. No pchaḻ me lahr lo xrid. No luxu, bdziib me lee guay, ziyno me lee to ruꞌ yuꞌ ru rdzíe meññ. ");
INSERT INTO zpg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","No ni byre guiaal, bdee mpyquie-samaritan medy, cuaꞌ meññ ni bian-no mpyquie-caḻ, sahc xchieñ chohp xdzé dziiñ par güieꞌ me lee, no ra me lee: “Bâḻ ctzooriꞌ ma gaxt la, naa quixaꞌ leeu dze-guibyguiataꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Were ra Jesúz muextr-nann leiy: ―De lo guionn meññ-rieꞌ yahc ni güdedy ru nash mpyquie ni güdihñ gübaan lee, ¿dxu de lahd yâme bintzi zâ-bynech mod-racladzyu? ");
INSERT INTO zpg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ra muextr leeme: ―Mpyquie ni bioob leeme ru nash me. Ra Jesúz leeme: ―Naꞌ la, güya no ptzoo mod-wé gahc, bioob meññ. ");
INSERT INTO zpg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Byluxu za Jesúz no xmeññ me no bydzihñ yâme to guiedzy-yaañ; no uga xiryuꞌ to ngünaa ni le Mart bydzihñ me. ");
INSERT INTO zpg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mart naꞌ, nu to baḻ me ni le Maríe. Scâsy bydzihñ Jesúz xiryuꞌ yâme, gürie gahc Maríe, gayieññ gayu Jesúz diidz. ");
INSERT INTO zpg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Per Mart, ma nu ihqy me xtziiñ me. Were, güya me ru dxie Jesúz, ra me lee: ―Señor, ¡di rwieꞌ dxiꞌy‑e nu tarie dixtziñaꞌ, no gatzonu tohg naa! Gu dbaḻaꞌ guidguiacno me naa. ");
INSERT INTO zpg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ra Jesúz leeme: ―Ba güdedy lo mdid rguꞌ ihqyiꞌ ctzooy dziiñ, Mart. ");
INSERT INTO zpg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tohzy ni ma rquihñ‑e nu par ctzoo meññ; lee we ni ba güle Maríe, no ndruhty nehx zboo leeu leeme. ");
INSERT INTO zpg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","To dzé ganino Jesúz Dioz to lgar. Hor-bylux me, ra to de lahd xmeññ me leeme: ―Lii ni rtzoo mdad, bluu noꞌ gynino noꞌ Dioz, beeiy mod-bluu gahc Juaṉ xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Were ra Jesúz leeyâme: ―Hor-gynino laꞌd Dioz, lâ gynii mod-rieꞌ: DTad noꞌ, lii ni nu gybaa, tzuguia ley. Gydzihñ de ni lii rtzooy mdad. Gac ni racladzyiꞌ neꞌ lo guiedzylie, mod-rahc gahcu gybaa. ");
INSERT INTO zpg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bdee ni tedydzé noꞌ dzêrieꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Psiaaḻladzyiꞌ dguîlquie noꞌ, porni zegahc rsiaaḻdadzy noꞌ ni dirquihñ ni rtzoo meññ noꞌ. No bwieꞌ noꞌ lehdy di ctzoo noꞌ ni ne bêndzab, mazyg byla noꞌ de lo ni nadz. ");
INSERT INTO zpg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","No zegahc ra Jesúz leeyâme mod-rieꞌ: ―De to lahd laꞌd ni rahp to xmígü, no ña laꞌd xiryuꞌ me beeiy glaꞌy guiaal, ña laꞌd leeme: “Mígü, racdadzyaꞌ nistiꞌñiꞌ naa tzonn paṉ, ");
INSERT INTO zpg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","porni bydzihñ to dmíguaꞌ diryuꞌn, dgapaꞌ mbehty ni gdedyaꞌ gahgü me.” ");
INSERT INTO zpg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","No nnii me ña me: “Di ctziaꞌdzyiꞌ naa. Ba ptaaguaꞌ diryuꞌn no gyre noꞌ ba nash. Nehx beeiy guiasaꞌ par gdedyaꞌnu lii.” ");
INSERT INTO zpg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Gapyaꞌ laꞌd ni uli, bâḻ ntzunñaad laꞌd leeme la, ñahs me we, ndee me ni gayo laꞌd, per dac porni mígü laꞌd no leeme, mazyg porni gatzunñaad laꞌd leeme. ");
INSERT INTO zpg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","No mod-wé gahc‑e, lâ ctzoo: Lâ gnab lo Dioz, no zdee me ni rnab laꞌd; lâ gyo, no zdzial laꞌd ni ryo laꞌd; lâ gynii chehsh puert, no sshalu. ");
INSERT INTO zpg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porni dxu rnab la, rcaꞌ; no dxu ryo la, rdzial ni ryo; no dxu rnii chehsh puert la, rxalu par tzu yâme. ");
INSERT INTO zpg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Dxu de to lahd laꞌd, bâḻ nnab xiiñ lee to paṉ, nehxni ndee laꞌd aaḻ guie leeme? O nnab me to mbaḻ laꞌd, ¿ndee laꞌd leeme aaḻ to mbaaḻ xilgar ni ganab me la? ");
INSERT INTO zpg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O bâḻ nnab me to lunguiedy gahgü me, ¿ndee laꞌd leeme aaḻ to mbiagü la? ");
INSERT INTO zpg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bâḻ laꞌd rdee laꞌd ni mos rcaꞌ xiiñ laꞌd, nîcze meññ-dirquihñ laꞌd, ¡lê dxiclé Dioz ni nu gybaa ni nac xTad laꞌd lee, zdee me Spirt-Sant dxu rnab! ");
INSERT INTO zpg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","To dzé güloo Jesúz mbenahcsy to mpyquie ni ngop. No scâsy byruu mbenahcsy leeme, luegü gahc günii me. Rtzunadz meññ ni bwieꞌ mod-guhc. ");
INSERT INTO zpg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Per zrieñ yâme ne: ―Mpyquie-rieꞌ beeiy rboo me mbenahcsy meññ, porni Beelzebú, ni nac xjefy gyre mbenahcsy, racno leeme. ");
INSERT INTO zpg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","No zrieñ yâme, lehdy nwieꞌ yâme bia beeiy rtzoo me, günab yâme ntzoo me to ni ngann ni nunzy Dioz beeiy rtzoo. ");
INSERT INTO zpg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Per leeme naꞌ, nann me bia ganii leññ ihqy cad to meññ-wé yahc. Were ra me leeyâme: ―Bâḻ meññ-nac xguxtisy to guiedzy nruu yâme chohp cuib no ndeḻy yâme la, nnitylo de ni rtzoo yâme mdad‑e. No bâḻ to family nruu chohp cuib no ndeḻy yâme la, nnidylo saꞌ yâme we. ");
INSERT INTO zpg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","No zegahc‑e, bâḻ bêndzab nruu me chehsh gahcme la, ¿bia mód‑e naꞌ beeiy ñahc ni nnii me? Ren ze, porni ne laꞌd Beelzebú, wé we racno naa lehdy rboon mbenahcsy meññ. ");
INSERT INTO zpg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Per bâḻ uliu rboon mbenahcsy porni racno Beelzebú naa la, ¿dxu racno xmeññ laꞌd lehdy gboo yâmeu zegahc? No leewe, leegahc yâme rdee diidz nehx xñahzu ni rnii laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Naa rboon mbenahcsy porni nu Dioz no naa, no niwé we rdee diidz ba gatzoo Dioz mdad neꞌ ru nu laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Hor-to mpyquie-ndip rahp xiryuꞌ zaꞌgndzi la, ndruhty nehx beeiy ñuꞌ leññ xiryuꞌ me lehdy ncaꞌ ni rahp me. ");
INSERT INTO zpg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per bâḻ ñahd sto ni ma ndip que leeme, wé ntzoo gan leeme no mboo gyre guiib ni rahp me par yquelo me, no nguiiz gyre ni rahp me lahd xmeññ. ");
INSERT INTO zpg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Dxu nehx nu no naa, garuu contr naa; no dxu nehx racno naa lehdy gac xtahl dmeññaꞌ la, gaboxtzu me meññ ni ba biahd. ");
INSERT INTO zpg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ru ba byruu mbenahcsy to meññ, ba zau, ganzeꞌu zrieñ lad, gayohbyu ru guisladzyu; per mbahty di rdzialu lgar, no were ba neu: “Guibyguiataꞌ ru byruu gahcaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hor-ba gubyguiatu we naꞌ, rwieꞌu xguîlmbahñ meññ-wé beeiy to yuꞌ ni nyar no guctziaawy leññ. ");
INSERT INTO zpg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Were rigyohbyu zgahdzy mbenahcsy ni ma udedy que leeu; no hor-ba ptohp saꞌu, ribyguiat yahcu, riuꞌu meññ-wé sto; no ba ma udedy meññ-dirquihñ rahc meññ ni ba byrohp riuꞌ mbenahcsy lee. ");
INSERT INTO zpg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ganii ziaꞌ Jesúz ze, tohzydzi günii to ngünaa, modni ndip, ne me: ―¡Dxu ñahc beeiy ngüna-bidtap lii no bisniꞌzy lii! ");
INSERT INTO zpg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ra Jesúz leeme: ―Mahbu we dxu ñahc beeiy meññ ni rieññ xtiidz Dioz no rtzoo mod-neu. ");
INSERT INTO zpg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Gadohp ziaꞌ meññ ru zu Jesúz, guzlo ne me: ―Meññ ni nu yahc ni naꞌ, meññ-dirquihñ‑e leeyâme; ne yâme nwieꞌ yâme ñahc to ni ngann ni nunzy Dioz beeiy rtzoo. Per ba nehx zwieꞌ yâme zrieñ ni ngann ni ñahc, mazyg beeiy ni ngann ni guhc no Jonáz. ");
INSERT INTO zpg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ni guhc no Jonáz, leeu we to señal ni bwieꞌ meññ ni nu Nínive. No naa we Mpyquie-Pshahl Dioz Lee no ni gac no naa, leeu we to señal ni güieꞌ meññ-nu ni naꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","No dze-gac xguîlnadz Dioz, ziahs ṟein ni güyuꞌ ñaz-mbenihs, no mod-wé zieññ nu guîlquie chehsh meññ-nu ni naꞌ; porni leeme, nîcze ziht güyuꞌ me, per biahd me ru nu Salomóṉ, bidguieññ me xguîlnann. Per naa ni ma rsahc que Salomóṉ zuun neꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Meññ-Nínive, dze-gac xguîlnadz Dioz ziahs yâme, no mod-wé zieññ nu guîlquie chehsh meññ-nu ni naꞌ; porni meññ-Nínive byo yâme Dioz ru bieññ yâme xtiidz me ni bieno Jonáz leeyâme. Per naa ni ma rsahc que Jonáz zuun neꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ndruhty nehx nguꞌ gue to lampr no nzu leeu ru ngaꞌdzy o ntuꞌz to caj leeu; mazyg ru guia we rzu me leeu, lehdy hor-tzu meññ yuꞌ, zwieꞌ yâme byniꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Byzalo meññ zidguiahcu beeiy to lampr par xcuerp yâme. Bâḻ byzaloꞌy rahp byniꞌ la, nuy lo byniꞌ we. Per bâḻ byzaloꞌy nehx rahp byniꞌ la, lo guibcawy‑e nuy. ");
INSERT INTO zpg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gax lâ güieꞌ ni rtzooy, lehdy di csiee guibcawy byniꞌ ni rahpiꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","No leewe, bâḻ uliu nuy lo byniꞌ, no nehx nuy lo guibcawy la, were zwieꞌy gyrenac cos zaꞌgndzi, scâsy mbiahziꞌ to lo xibyniꞌ lampr. ");
INSERT INTO zpg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Byluxz günii Jesúz, byruu gahc to meññ-nac fariseu, ra leeme: “Tzo nó diryuꞌn, dzictahgü nó.” Were za yâme xiryuꞌ me. Bydzihñ yâme, gürie Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ru bwieꞌ fariseu di nguihby ña Jesúz mod-ne costumbr-guhl, ptzunadz me. ");
INSERT INTO zpg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Were, ra Jesúz leeme: ―Laꞌd ni nac meññ-nac yahc fariseu, zidguiahc laꞌd‑e beeiy vas no blad ni nyar nunzy chehsh, per luxu leññ xguîlmbahñ laꞌd beedyu porni bydzeꞌu gyrehzy guîlgübaan no zrieñ ni dirquihñ. ");
INSERT INTO zpg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Meññ-waty! Rtzoo laꞌd beeiy ni dgann bâḻ ni bzaa gahc xcuerp meññ, wé gahc‑e bzaa xguîlmbahñ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Per de ni rahp laꞌd, lâ gdee gun ycaꞌ meññ-byzahby, no were guieññ ba nye xguîlmbahñ laꞌd, no dac nunzy de lguia. ");
INSERT INTO zpg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Baazy dzii de laꞌd, fariseu!, porni ne laꞌd rzoob laꞌd xtiidz Dioz, per nehx uliu rtzohd gyre ni racladzy me. Nîcze rdee laꞌd gun par Dioz de lo tzii cuib de ni rtoꞌ laꞌd biatxteḻy, ṟud, no zrieñ clasy ni rdziib laꞌd, per ni nac xñahzû nehx rtzucas laꞌd par ctzohd, ni nehx rzacbeeiy laꞌd Dioz no gydo xguîlmbahñ laꞌd. Wé we racladzyu ctzoo laꞌd sinn di csaꞌn laꞌd stohbyu. ");
INSERT INTO zpg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Baazy dzii de laꞌd, fariseu! Laꞌd riuꞌladzy laꞌd cuia laꞌd leññ idoo ru ma mos ru rbia meññ-rsahc; no hor-ganzeꞌ laꞌd, racladzy laꞌd gynii meññ diux laꞌd no xroꞌ guîlrzacbeeiy. ");
INSERT INTO zpg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Baazy dzii de laꞌd, muextr ni ruuḻ yahc xleiy Moiséz no meññ-nac yahc fariseu, laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu!, porni zidguiahc laꞌd beeiy baa ni ba bynihty; wéhdyx‑e rdedy meññ chehsh sinn gann. ");
INSERT INTO zpg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Were byruu to lahd muextr ni nann leiy, ra leeme: ―Muextr, gyre mod-ganiiy la, noc noꞌ we gaguiñdiidziꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ra Jesúz leeme: ―¡Baazy dzii de laꞌd, muextr ni nann yahc leiy! Rtzohd mdad meññ ctzoo ni nehx beeiy, no laꞌd di ne ctzoo mbehty gahcu. ");
INSERT INTO zpg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Baazy dzii de laꞌd ni rzaa xbaa profet yahc ni bgaꞌdy xtadgul laꞌd lee! ");
INSERT INTO zpg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mod-rtzoo gahc laꞌd‑e rdee diidz riuꞌladzy laꞌd ni nahcsy yahc ni ptzoo ngydo-xtadgul laꞌd. Porni leeyâme biꞌdy meññ ni günii yahc xtiidz Dioz, no laꞌd ba gazaa xbaa yâme. ");
INSERT INTO zpg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Dioz bac nann me we xnahc nac laꞌd, no leewe günii me, ne me: “Cshaalaꞌ profet, no apóstl. Per zgaꞌdy meññ lahd yâme, no ni riaꞌn we, zgultihp yâme lee.” ");
INSERT INTO zpg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","No meññ-nu ni naꞌ, rahp de ni iguquix Dioz lee ni bgaꞌdy yâme profet xtâ glo dzé ni güyaa guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Lee we xtâ dze-guhty to mpyquie ni güyu-le Abel no xtâ dze-guhty Sacaríaz ni biꞌdy yâme lee ruꞌ idoró gahsh ruꞌ ltar ru rqueꞌ gue maꞌ ni nac gun par Dioz. Leewe gapyaꞌ laꞌd, gyre nirieꞌ we rahp meññ-nu ni naꞌ de ni quix. ");
INSERT INTO zpg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Baazy dzii de laꞌd, muextr ni nann yahc leiy! Porni rcaꞌdzy laꞌd ni uli, di nehd gluuw meññ lehdy di gann ndruhty leeu. Nehx rlíladzy laꞌd leeu, ni di ne laꞌd gdee lgar meññ ni riuꞌladzy ñahc dmeññaꞌ lee. ");
INSERT INTO zpg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bylux günii Jesúz, modni bydziadzyno muextr yahc leeme no meññ-nac yahc fariseu, no guzlo ganabdiidz yâme leeme gyrehzy, ");
INSERT INTO zpg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","lehdy ndzial yâme mod-nruu yâme contr leeme. ");
INSERT INTO zpg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lo gahc hor-wé guzlo bydohp mily no mily meññ ru zu Jesúz, lé raꞌñ saꞌ yâme. No guzlo ra me nier xmeññ me: ―Lâ gap laꞌd no ni nac meññ-fariseu, ni zidguiahc beeiy levadur; leeu we de ni ne yâme meññ-tziaawy leeyâme nîcze nehx uliu. ");
INSERT INTO zpg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Porni nehx ziaꞌn mbehty ngaꞌdzy no di gyxal lou; no nehx ziaꞌn mbehty ni nungaꞌdzy, gyreu zieññ. ");
INSERT INTO zpg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","No leewe, ni günii laꞌd lo guibcawy, gyreu zruu lo byniꞌ. No gyre ni günii laꞌd ngadzydoo la, xtâ ihqy ndzi yuꞌ zieññu. ");
INSERT INTO zpg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Laꞌd ni nac dmíguaꞌ, gapyaꞌ laꞌd: Na di gydzie laꞌd meññ-rgaꞌdy cuerp, porni niwéhzy‑e beeiy ctzoo yâme. ");
INSERT INTO zpg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mazyg dziguiapyaꞌ laꞌd nirieꞌ: Lâ gydzie dxu beeiy gnidylo xguîlmbahñ meññ, no beeiy glee meññ lo infiern. Wé lâ gydzie lee. ");
INSERT INTO zpg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Dâs‑e rdoꞌ gaay mayaañ por chohp mbí medy-guiib la? Per nehx riaaḻladzy Dioz ni to yâmaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","No laꞌd, xtâ xguitz-ihqy laꞌd‑e nann me blacu. Leewe di gydzie laꞌd; ma rsahc laꞌd‑e que xtahl mayaañ. ");
INSERT INTO zpg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Gapyaꞌ laꞌd, dxu gynii dmeññaꞌ lee ñaz-lo zrieñ meññ la, zegahc‑e gynin ñaz-lo gyre x‑ángel Dioz dmeññaꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Per dxu ga zrieñ meññ nehx dmeññaꞌ lee la, mod-wé gahc‑e gynin ñaz-lo x‑ángel Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Naa Mpyquie-Pshahl Dioz Lee; gyre dxu gynii contr naa la, Dioz csiaaḻladzy xguîlquie me; per dxu gynii didz-nahcsy contr Spirt-Sant la, wé nehx ssiaaḻladzy Dioz xguîlquie. ");
INSERT INTO zpg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ru tziyno meññ laꞌd lo xjefy meññ-idoo, o lo juez no lo guxtisy, di cu ihqy laꞌd bia ga laꞌd leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Lo hor-wé Spirt-Sant, wé we gacno lehdy gann laꞌd bia gynii laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Byruu to lahd meññ, ra me Jesúz: ―Muextr, gu dbetzyaꞌ ctzulaꞌy noꞌ xtziiñ ngydo-dtad noꞌ, lehdy ycan ni nac dixchieñaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ra Jesúz leeme: ―Dac‑e juez naa par ctzulayaꞌ xtziiñ meññ. ");
INSERT INTO zpg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Luxu, ra me gyre meññ-caḻ: ―Gax lâ gann no gyre guîlrzîbyladzy. Porni niglihg‑e ñahp meññ gyrehzy, no luxu lo Dioz nehx rquihñ zâ gyre niwé mbehty. ");
INSERT INTO zpg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","No luxu, günii me ndaagü lo diidz mod-rieꞌ, ne me: ―Güyuꞌ to mpyquie-ṟicü, rahp me to lyu-ro, gyrehzy bdziib me lou, no cue-tarie gyre ni bdziib me. ");
INSERT INTO zpg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Were guzlo günii leññ ihqy me, ne me: “¿Bia mód naꞌ dzictzon? Nehx rapaꞌ ru cutziawyaꞌ gyre dicüsechaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Gyzac ne me: “Ba nannaꞌ bia dzictzon. Ctzilyaꞌ dtaꞌwyaꞌ no gzan zrieñu ni ma xroꞌ. Mod-wé cutziawyaꞌ gyre ni cchun no zrieñ ni ba rapaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Luxu, gapyaꞌ naa gahc: Naꞌr yaaxu ba rahpiꞌ xtahl ni nu-tziaawy par xroꞌ tiémp. Bisladzy naꞌ, güdahgü naꞌ, güee naꞌ, byxihly naꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Per Dioz ra leeme: “Mpyquie-waty, guial-rieꞌ gahc‑e gatyiꞌ, no gyre ni ngutziaawyiꞌ, dac‑e par lii leeu.” ");
INSERT INTO zpg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mod-wé we rahc meññ ni riuꞌladzy gap xtahl medy, per par Dioz nehx rahp yâme mbehty. ");
INSERT INTO zpg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Luxu, ra Jesúz xmeññ me: ―No leewe gapyaꞌ laꞌd: Na di cu ihqy laꞌd ni gahgü laꞌd, ni di cu ihqy laꞌd lahr ni gutz laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Porni ma rsahc xguîlmbahñ laꞌd‑e que guîlroo, no ma rsahc xcuerp laꞌd‑e que shab laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lâ güieꞌ xnahc mbiahc nehx rtzoo maꞌ dziiñ ndziib maꞌ behch, ni nehx rtzoo maꞌ cüsech; no nehx rahp maꞌ daꞌwy, ni sto ru ngutziaawy maꞌ ni gahgü maꞌ; per leexyâmaꞌ we mbahñ, porni Dioz rdee ni rahgü yâmaꞌ. ¡Lê dxiclé laꞌd ma rsahc laꞌd‑e que mashiily! ");
INSERT INTO zpg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","No ndruhty laꞌd nehx beeiy nniꞌzy stoozy, nîcze ma ñacladzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bâḻ nehx beeiy ctzoo laꞌd to cos ni uxiee la, niglihg‑e cu ihqy laꞌd gyrehzy. ");
INSERT INTO zpg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Lâ güieꞌ xnahc rgaꞌy guiee lo camp; nehx rtzoo yahcu dziiñ ni nehx rzaa yahcu duu; per gapyaꞌ laꞌd, ni ṟeiy-Salomóṉ no gyre ni mos ni güdahp me, nehx biygahl me ñacmos shab me beeiy to lahd yahcu. ");
INSERT INTO zpg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Per bâḻ Dioz ristziaawy me guix, ni dzêrieꞌ nu lo camp no cshe yqueꞌ gue lee leññ horn, ¡lê dxiclé laꞌd, ma rguꞌ ihqy Dioz laꞌd‑e, nîcze uxiee rlíladzy laꞌd leeme! ");
INSERT INTO zpg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","No leewe, ren laꞌd di cu ihqy laꞌd bia gahgü laꞌd o bia goo laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Porni meññ-guiedzylie ni nehx ryo Dioz rguꞌ ihqy yâme gyre nirieꞌ; per xTad laꞌd ni nu gybaa nann me bia gyre rquihñ laꞌd gyre dzé. ");
INSERT INTO zpg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Per lâ yquee ihqy laꞌd tzu laꞌd ru rtzoo Dioz mdad, no were zdee me gyre ni gayaadz laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","No ra me xmeññ me: ―Di gydzie laꞌd. Naa nehx rboo diqyaꞌ laꞌd ni zidguiahc beeiy xiily ni rapaꞌ. Nîcze uxiee laꞌd, per xTad laꞌd ni nu gybaa, riuꞌladzy me gdee me laꞌd gyre ni rtzoo me mdad. ");
INSERT INTO zpg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Lâ ctoꞌ ni rahp laꞌd lehdy gacno laꞌd meññ-byzahby. No bâḻ ctzoo laꞌd ze la, rahc cuent gagutziaawy xmedy laꞌd‑e ru di znihtyu. No mod-wé galesytziaawy laꞌd ni ma rsahc xtâ gybaa ru nehx ziuxu no ru di zaḻ tzu meññ-gübaan o ñuꞌ mblaa gahgü leeu. ");
INSERT INTO zpg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","No leewe ru nu ni ma rsahc par laꞌd, wé gahc‑e tzu xguîlmbahñ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","No zegahc ra me leeyâme: ―Lâ tzu puexd no ba nutz shab laꞌd, no lâ cu gue xlampr laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Lâ gac beeiy mós ni gabiahz hor-guibyguiat xpatróṉ de lo guîltziahl par cshal yuꞌ scâsy cuagü me chehsh puert. ");
INSERT INTO zpg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dxu ñahc beeiy mós yahc ni dxienáꞌ no gabiahz xpatróṉ. Gapyaꞌ laꞌd ni uli, ziuꞌ patróṉ yuꞌ, leegahcme gac beeiy to mós, za me xmós me: “Lâ cuia ruꞌ miax par gdedyaꞌ ni gahgü laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nîcze guiaad patróṉ glaꞌy guiaal o zidnchuulr, per bâḻ güieꞌ me dxienáꞌ yâme, dxu ñahc beeiy mos-wé yahc. ");
INSERT INTO zpg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Per lâ guieññ ni dziguiapyaꞌ laꞌd: Bâḻ xbixwaan to yuꞌ ñann me pór ñahd gübaan guiaal la, mbianáꞌ me we, no nehx ndee me ñahz ñuꞌ gübaan ncaꞌ ni rahp me. ");
INSERT INTO zpg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","No laꞌd zegahc, lâ tzu puexd, porni naa, Mpyquie-Pshahl Dioz Lee, guibyguiataꞌ hor-nehx nann laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Were günabdiidz Pedr Jesúz, ra me lee: ―Lii ni rtzoo mdad, ¿par dxu we nirieꞌ ni güniiy ndaagü lo diidz? ¿Par noꞌzy la, o par gyre meññ? ");
INSERT INTO zpg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ra Jesúz leeme: ―¿Dxu we mos-tziaawy ni rtzoo xtziiñ xpatróṉ mod-racladzyu, no rsaꞌn xpatróṉ lee xiryuꞌ par gdee ni goo xmeññ me xhóru? ");
INSERT INTO zpg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dxu ñahc beeiy mós ni rsaꞌn xpatróṉ lee yuꞌ par ctzoo dziiñ, no hor-guiaad patróṉ gatzoo xmós me dziiñ zaꞌgndzi. ");
INSERT INTO zpg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Gapyaꞌ laꞌd ni uli, ssaꞌn patróṉ xtziiñ xlad xmos-tziaawy me par gap gyreu. ");
INSERT INTO zpg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per bâḻ mos-wé nlâdzy me galeer xpatróṉ me we, no nizlo ntzoo nsahc me zrieñ zâ-mós me no criad, no ñoo ñahgü me no nzuhdzy me, ");
INSERT INTO zpg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","no tohzy ndzihñ xpatróṉ me dze-nehx gabiahz me lee no hor-nehx nann me, were nnahzy patróṉ leeme, nguihñ leeme no nshahl leeme ru nu meññ-dirquihñ. ");
INSERT INTO zpg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Mós ni nann bia racladzy xpatróṉ no luxu nehx riuꞌ puexd, no di ne gzobdiidz la, wé we xtahl guîlné scaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","No mós ni nehx nann bia racladzy xpatróṉ no cuentz rtzoo la, zegahc scaꞌ xguîlné me, per ma uxiee gá. Dxu rcaꞌ xtahl, rahp de ni gdee xtahl, no dxu guian-no xtahl ni gap la, zegahc xtahl gnab yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Naa guîlné we bidnon lo guiedzylie, ñahcu ni ñaḻ la, ba gayahcu naꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Rapaꞌ de ni tedyaꞌ to ni nadz. Por leeu we modni gazacnon hôrrieꞌ no xtâ hor-ba bylux güdeedyaꞌ leeu. ");
INSERT INTO zpg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gapyaꞌ laꞌd, dac‑e nlâdzy laꞌd biaḻaꞌ cuaqydzien meññ-nu lo guiedzylie, aaḻ teḻy yâme we. ");
INSERT INTO zpg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Glohdy dzêrieꞌ, ru nu gaay meññ leññ to yuꞌ, tzonn yâme squelo schohp, no gyruu schohp yâme squelo leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","No dad gahc squelo xiñ-ñooby, no gyruu xiñ-ñooby me squelo leeme; no mam gahc squelo xiñ-ndzaꞌb, no xiñ-ndzaꞌb gahcme squelo leeme; no squelo suegyr-ngünaa xiñ-ulihdzy, no gyruu xiñ-ulihdzy me, squelo leeme. ");
INSERT INTO zpg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ra Jesúz meññ-caḻ yahc: ―Ru rwieꞌ laꞌd rzob mbezá ru riaaz ncübidz, ne gahc laꞌd guio we ba dziguiahc, no rruqueꞌu mod-ne laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","No dze-rxuu mbenihs, ne laꞌd nlay‑e ba dziguiahc, no rahcu mod-wé. ");
INSERT INTO zpg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Laꞌd‑e ni ne meññ-tziaawy lee nîcze nehx uliu! Laꞌd rzaclo laꞌd xnahc za tiémp no ni rwieꞌ laꞌd leññ gybaa no lo guiedzylie. ¿Bia mód‑e naꞌ nehx rzaclo lo laꞌd ni gawieꞌ laꞌd gayahc neꞌ ni naꞌ? ");
INSERT INTO zpg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Laꞌd gahc lâ güieꞌ bâḻ xñahzu gatzohd. ");
INSERT INTO zpg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bâḻ dxuhch ctzoo contr lii lo guxtisy no tzaꞌy no leeme ru dxie juez la, byo xnahc tzuy dzie tziaawy no leeme antzy ni gydzihñ laꞌd, lehdy were ba di tziyno me lii lo juez; porni bâḻ gydzihñiꞌ lo juez la, juez steedy lii lo ña meññ-cu lii lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Gapyaꞌ lii, xtâ quixriꞌ gyre ni nzahbyiꞌ, were gyruuy ru nuy. ");
INSERT INTO zpg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Leññ gahc dze-wé, güya zrieñ meññ, bigyne yâme Jesúz de ni bgaꞌdy Pilat meññ-byruu lo ṟegioṉ-Galilea lóni gagaꞌdy yâme maꞌ lehdy yqueꞌ gue gun par Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Were ra Jesúz leeyâme: ―¿Nlâdzy laꞌd meññ-Galilea guhc yâme mod-wé porni ma meññ-guîlquie leeyâme que zrieñ xmeññ yâme la? ");
INSERT INTO zpg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Gapyaꞌ laꞌd, dac‑e por leeu guhty yâme. Laꞌd znihty laꞌd‑e zegahc, bâḻ di csaan laꞌd ni nahcsy ni nac laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿No nlâdzy laꞌd ma meññ-guîlquie we dicioch meññ ni guhty dze-pshaꞌd to torr lee ni güyuꞌ Siloé que zrieñ meññ-Jerusaléṉ la? ");
INSERT INTO zpg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Gapyaꞌ laꞌd, dac‑e por leeu guhty yâme. Bâḻ laꞌd di csaan laꞌd ni nahcsy ni nac laꞌd la, znihty gyre laꞌd‑e zegahc. ");
INSERT INTO zpg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Were günii Jesúz nirieꞌ ndaagü lo diidz, ra me leeyâme: ―Güyuꞌ to mpyquie, rahp me to yag-duug lo xilyu me. To dzé we naꞌ, güya me bigüieꞌ me bâḻ ba queꞌ lou. Bydzihñ me, bwieꞌ me gydi mbehty lou. ");
INSERT INTO zpg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Were ra me mpyquie-gayahp xilyu me: “Ba tzonn ihz riaḻaꞌ ridyobyaꞌ duug lo yag-rieꞌ, per di rdzialaꞌu. Beeiydí pchug leeu nabduu niglihg gaquihñu lyu ru zuw.” ");
INSERT INTO zpg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Were ra mpyquie-gayahp leeu: “Lii ni rtzoo mdad, zî-zuw leññ iz-rieꞌ, no naa cuaqyaꞌ yu xánu no cun abonu, ");
INSERT INTO zpg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","duhn beeiy yqueꞌu; no bâḻ di yqueꞌu la, were cchuguiꞌ leeu.” ");
INSERT INTO zpg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","To dze-risladzy meññ galuu Jesúz meññ leññ to idoo. ");
INSERT INTO zpg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lahd yâme dxie to ngüna-ba rahp dicioch ihz nchuꞌñ me porni nu mbenahcsy leeme, no di raḻ guiaḻ me. ");
INSERT INTO zpg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ru bwieꞌ Jesúz leeme we naꞌ, pquee riedz leeme, no ra leeme: ―Shiꞌñ, xguîlguihdziꞌ, ba biaḻu we. ");
INSERT INTO zpg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Luxu, pshob ña Jesúz chehsh me, no guzli gahc ngüna-wé, gucderech me, no luxu guzlo gadee me xquix Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Niwé bwieꞌ mpyquie-nu idoo xcargü, bydziaꞌdzy me porni psiaḻ Jesúz ngüna-wé dze-risladzy meññ. Luxu ra me gyre meññ-dxie yahc uga: ―Nu shoꞌb dzé par ctzoo meññ dziiñ; leññ dze-wé we guiaad laꞌd par guiaḻ laꞌd, no dac dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Were ra Jesúz leeme: ―Laꞌd ni ne meññ-tziaawy lee nîcze nehx uliu, ¿dâs‑e rshac laꞌd xyuhz laꞌd o xburr laꞌd dze-risladzy meññ, par tziynot leemaꞌ goo maꞌ nzeꞌ la? ");
INSERT INTO zpg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ngüna-rieꞌ, de lo gahc xfamily Braṉ‑e ziaad me, no ba rahp dicioch ihz rahc cuent nliiby me de guîlguidz-rieꞌ ni rtzoo bêndzab mdad lee. ¿Nehx xñahzu ñiaḻ me dze-risladzy meññ la? ");
INSERT INTO zpg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hor-günii Jesúz ze, pytuꞌ meññ-rdziadzyno leeme. Per gyre zrieñ meññ gaxihly ru bwieꞌ yâme xroꞌ cos ni ptzoo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","No ra Jesúz leeyâme zegahc: ―¿Bia zidguiahc beeiy mod-rtzoo Dioz mdad, o bia beeiy nsahc nó leeu? ");
INSERT INTO zpg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Zidguiahcu beeiy to ladzy mostas ni bdziib to mpyquie lo xilyu; bygaꞌyu no guhcu to yagmble-ro, xtâ no rzaa ma-rzîbydun yahc xguehsh maꞌ lo xṟamu. ");
INSERT INTO zpg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Gyzac günii Jesúz, ra me leeyâme: ―¿Bia beeiy nsahc nó mod-rtzoo Dioz mdad? ");
INSERT INTO zpg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Zidguiahcu beeiy levadur ni bguhtz to ngünaa lee no tzonn cuib rin, lehdy guiahs cob-paṉ. ");
INSERT INTO zpg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Güdedy Jesúz xtahl ciuda no xtahl guiedzy, galuu me meññ xtiidz Dioz, lóhgni za me Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Byruu to lahd meññ, günabdiidz ra leeme: ―Lii ni rtzoo mdad, ¿uxiee meññ ni gylaa de lo guîlnadz la? Were ra Jesúz leeme: ");
INSERT INTO zpg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Lâ gnâbladzy laꞌd par tzu laꞌd ñaz-ruꞌ puert-mbia. Gapyaꞌ laꞌd, xtahl meññ‑e gacladzy tzuw, per di zaḻu. ");
INSERT INTO zpg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Porni hor-xbixwaan yuꞌ ba biahs no ptahgü puert, were laꞌd ni zu stziuꞌ gacladzy tzu. Hor-caḻ ba ga laꞌd leeme: “Lii ni rtzoo mdad, pshal yuꞌ, tzu noꞌ.” Per ga me laꞌd: “Nehx nannaꞌ dxu meññ laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Were ga laꞌd leeme: “Per tohzy no lii güdahgü noꞌ no güee noꞌ, no tohzy bluuy gyre noꞌ lo call.” ");
INSERT INTO zpg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Gyzac ga me laꞌd: “¿Dâs‑e ba ren laꞌd la, nehx nannaꞌ dxu meññ laꞌd? Lâ gyruu de naa, meññ-dirquihñ‑e laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Uga guun laꞌd, lé gahgü laiy laꞌd hor-güieꞌ laꞌd meññ-güyuꞌ ba xtze, lee we Braṉ, Isac, Jacop no gyre profet nu yahc ru rtzoo Dioz mdad, no luxu ba biaꞌn laꞌd stziuꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Porni gyruu meññ ñaz-ru rlahñ ncübidz no ñaz-ru riaaz ncübidz, no ñaz-mbeguiaꞌ no ñaz-mbenihs, par guiaad goo tohzy ruꞌ miax leññ ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","No nu meññ ni ma uxiee rsahc lahd meññ neꞌ, per uga ma qysahc yâme. No nu meññ ni ma rsahc lahd meññ neꞌ, per uga ma uxiee qysahc yâme. ");
INSERT INTO zpg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Leññ dze-wé gahc biahd meññ-nac yahc fariseu, ra yâme Jesúz: ―Byruu de neꞌ, bwieꞌ ba lad tzaꞌy. Bâḻ nuy neꞌ la, zgaꞌdy Herody lii we. ");
INSERT INTO zpg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Were ra Jesúz leeyâme: ―Lâ tza, lâ dzigyne mpyquie-mañ-wé: “Dzêrieꞌ no cshe csiaḻaꞌ meññ-rahp mbenahcsy no zrieñ meññ-gayac-ure yahc, no widz luxaꞌ dixtziñaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Rapaꞌ de ni tzan dzêrieꞌ, cshe no widz par gydzihñaꞌ Jerusaléṉ, porni wé we rahp de ni gaty gyre meññ ni nac yahc profet. ");
INSERT INTO zpg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Baazy dzii laꞌd, meññ-Jerusaléṉ! Laꞌd rgaꞌdy laꞌd profet yahc, no rshadguie laꞌd meññ-rshahl Dioz lee par ñu diidz no laꞌd. ¡Xtahl vuelt gucdadzyaꞌ ntopaꞌ gyre laꞌd, beeiy rtohp nguiedy xiiñ leññ shiily, per di ñacladzy laꞌd! ");
INSERT INTO zpg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Naꞌ lâ güieꞌ, xiryuꞌ laꞌd ziaꞌnu lehzyu; no gapyaꞌ laꞌd, glohg hôrrieꞌ ba nehx zwieꞌr laꞌd naa mazy, xtâ glo gydzihñr to dzé ni gynii laꞌd: “¡Nu laꞌy mpyquie ni ziaad porni Dioz ni rtzoo mdad pshahl leeme!” ");
INSERT INTO zpg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","To dze-risladzy meññ, güya Jesúz bictahgü me xiryuꞌ to meññ-guxtisy ni nac fariseu. No dxie zrieñ fariseu, galaꞌdzy leeme bia gynii me o bia ctzoo me. ");
INSERT INTO zpg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Uga dxie to mpyquie ni nu gue lee. ");
INSERT INTO zpg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Were günabdiidz Jesúz muextr ni nann yahc leiy no meññ-nac yahc fariseu, ra me leeyahc: ―¿Xñahzu we la, nsiaḻ mu meññ-gayac-ure dze-risladzy meññ, o yac? ");
INSERT INTO zpg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per di ndzial yâme bia ña yâme leeme. Were günahzy me ña mpyquie-caḻ par psiaḻ me lee. Luxu, ra me lee: ―Güya naꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","No ra me meññ-nac yahc fariseu: ―¿Dxu de lahd laꞌd, bâḻ to xburr o to xyuhz ñahb leññ to guieryu dze-risladzy meññ, nehx mboo laꞌd leemaꞌ scâsy ñahb maꞌ la? ");
INSERT INTO zpg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Per di ñaḻ gahc ndzial yâme bia ña yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ru bwieꞌ Jesúz meññ-psieññ yâme lee gabe ru ma mos par cuia yâme ruꞌ miax, günii me ndaagü lo diidz, ra me leeyâme mod-rieꞌ: ");
INSERT INTO zpg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ru tzaꞌy to lo guîltziahl, na di cuiay ru ma mos, nabduu hor-gydzihñ sto meññ ni ma rahp xpeeiy yâme lee, ");
INSERT INTO zpg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","bac guiaad meññ-psieññ lii, ga lii: “Biahsiꞌ ru dxiey lehdy cuia mpyquie-rieꞌ.” Hor-caḻ naꞌ, ba stuꞌy, porni ba biahsiꞌ de ru dxiey, no ba dzicchiey ru dxie meññ-nehx rahp xpeeiy yâme lee. ");
INSERT INTO zpg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Por lee we ren, ru tzaꞌy lo guîltziahl, gürie to ru rbia meññ-ma uxiee rsahc, lehdy hor-güieꞌ meññ-psieññ lii dxie dziiy ru nehx mos, hor-caḻ ga me lii: “Mígü, güde cuiay curieꞌ. Neꞌ nu to lgar ma mos par lii.” No mod-wé ziuguiay lahd meññ ni dxienoy ruꞌ miax. ");
INSERT INTO zpg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porni dxu rguguia leegahc, wé nehx zguguia ndruhty lee; no dxu nehx rguguia leegahc, wé we tzuguia. ");
INSERT INTO zpg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Were ra me mpyquie-psieññ leeme: ―Hor-riuꞌladzyiꞌ ctzooy to lni o to guîlroo, na di csieññiꞌ xmígüiꞌ, ni behtzyiꞌ, ni zrieñ xfamilyiꞌ, ni meññ-ṟicü ni nunoy gahsh. Porni leeyâme beeiy stzoo yâme mod-wé gahc no lii, no mod-wé rahc cuent ba güdix yâme ni bdeedyiꞌ güee yâme. ");
INSERT INTO zpg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mazyg hor-riuꞌladzyiꞌ ctzooy to lni, psieññ meññ-byzahby, meññ-nrung ña o nieꞌ, no meññ-ngaḻ; ");
INSERT INTO zpg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","no dxu ñahc beeiy lii, porni zâ meññ-wé yahc nehx rahp yâme bia ndee yâme lii. Ba xtâ Dioz diaa we guiscady lii ni ma xroꞌ dze-glesy me gyre meññ ni bzoob xtiidz me. ");
INSERT INTO zpg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hor-bieññ yâme günii Jesúz ze, byruu to lahd yâme ni dxie ruꞌ miax, ra leeme: ―Dxu ñahc beeiy meññ-cuia ruꞌ miax par gahgü ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Were ra me lee: ―Güyuꞌ to mpyquie, bicsieññ me xtahl meññ par guiaad lehdy gotzie yâme xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","No biygahl hór‑e naꞌ, pshahl me xmós me zigyne meññ-ba psieññ me lee par guiaad, porni ba nu guîlroo. ");
INSERT INTO zpg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Per gyre meññ-caḻ yahc byo ni günii lehdy di ña niguiotzie. To me ne: “Nehx zian, porni leer gá güxin diby laꞌy lyu. Rapaꞌ de ni tzan dzigüienu. Ptzoo xroꞌ psenzy naa, nehx beeiy tzan.” ");
INSERT INTO zpg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Sto me we ne: “Nehx zian, porni leer gá güxin tzii yuhz ni rquee rad. Rapaꞌ de ni tzan dzigüien bâḻ beeiy ctzoo yâmaꞌ dziiñ. Ptzoo xroꞌ psenzy naa, nehx beeiy tzan.” ");
INSERT INTO zpg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sto me ne: “Nehx zian, porni leer bidzñan, nehx beeiy tzan.” ");
INSERT INTO zpg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ru gubyguiat mós ni bigyne leeyâme we naꞌ, ra me xpatróṉ me mod-ra meññ-rieꞌ leeme. Bydziaꞌdzy patróṉ, ra me xmós me: “Güya ngueeḻy gahc lóguiaꞌ no lo ñahz leññ guiedzy, guidnoy nitisy meññ-gydzialiꞌ: meññ-byzahby, meññ-nrung ña o nieꞌ, no meññ-ngaḻ.” Were güya mós. ");
INSERT INTO zpg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hor-gubyguiat me, ra me xpatróṉ me: “Señor, ba güyan ru pshahliꞌ naa, per nur lgar leññ yuꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Gyzac ra patróṉ xmós me: “Güya zrieñ lo ñahz diby lad de leññ guiedzy no nitisy dxu güieꞌy, ptzunñaad leeyâme guiaad yâme lehdy gydzeꞌ meññ leññ diryuꞌn. ");
INSERT INTO zpg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gapyaꞌ gyre laꞌd, ni to meññ ni nehx biuꞌladzy ñahd, zegahc yaax ngâstoo ba nehx ziuꞌ dzé guidtahgü yâme neꞌ diryuꞌn.” ");
INSERT INTO zpg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hor-za Jesúz Jerusaléṉ, modni xtahl meññ náḻ leeme. Were bidzguiat lo me, bwieꞌ me leeyâme, no ne me: ");
INSERT INTO zpg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Bâḻ dxuhch náḻ naa, per ma ndzi me xtad me, xmam me, tziahl me, xiiñ me, behtzy me o baḻ me no byzan me, no xtâ bâḻ ma ndzi me leegahcme, wé nehx beeiy gac dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Dxu racladzy gac dmeññaꞌ lee no di ne gbooladzy xtâ xguîlmbahñ, nehx beeiy gac me dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bâḻ to meññ racladzy gzaa beeiy to yuꞌ ni nsuu lehdy ycuniꞌ xmeññ me ru gayahc dziiñ, ¿dâs‑e nier mboo xcuent me bla medy racladzyu yquihñ me par gydibylgaau la? ");
INSERT INTO zpg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","No bâḻ leeme sulo me no di gboo xcuent me nier la, ru ba bianrungu, gyre meññ güieꞌ leeu sshidzyno leeme, ");
INSERT INTO zpg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","no za yâme: “Mpyquie-rieꞌ gülohzy me xán to yuꞌ, no luxu di ñaḻ nistibylgaa me leeu.” ");
INSERT INTO zpg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","No zegahc‑e rtzoo ṟeiy ni racladzy dzicteḻy no sto ṟeiy. Nier gax risshuunn xguîlriehñ me we zaꞌgndzi, bâḻ beeiyu leeme nunzy tzii mily soldad tziyno me par dzicteḻyno me gaḻ mily soldad. ");
INSERT INTO zpg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","No bâḻ nann me di zaḻ teḻyno me ṟeiy-wé la, ni ctzohdy me we, cshahl me diidz lo hor-nu ziaꞌ ziht, ga me lee: “Beeiydí, cchug nó lo guîlrdeḻy lehdy tzu nó dzie tziaawy.” ");
INSERT INTO zpg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","No mod-wé gahc‑e, dxu di ne csaꞌn gyre ni rahp, nehx beeiy gac me dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Ziahd, to ni mos‑e leeu. Per bâḻ nnihty ni ndzihgu, ¿báz‑e naꞌ nquihñu? ");
INSERT INTO zpg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ba nehx nquihñu mbahty, ni par abon. Ni rahctyu we, rzahbyu. Bâḻ racladzy laꞌd guieññ laꞌd bia ganin la, lâ yquee ihqy laꞌd dtiidzaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Xtahl meññ-rguquix mpuezd no zrieñ meññ-guîlquie ziaad yâme ru zu Jesúz lehdy guieññ yâme ni ganii me. ");
INSERT INTO zpg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Per meññ-nac yahc fariseu naꞌ, no muextr ni ruuḻ yahc xleiy Moiséz, galesyno yâme chehsh Jesúz, ne yâme: ―Mpyquie-rieꞌ rtohp me nyug meññ-guîlquie no xtâ rahgü me tohzy no leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Were günino Jesúz leeyâme ndaagü lo diidz, ne me: ");
INSERT INTO zpg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Bâḻ ñahp to de lahd laꞌd diby gayuu xiily, no nnihty to maꞌ, ¿nehx nsaꞌn me gydiby noventaynuevy maꞌ lo camp no nigyo me ma-ganihty xtâ glo ndzial maꞌ la? ");
INSERT INTO zpg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hor-ba bydzial maꞌ, nshob me leemaꞌ ruꞌ xihcü me, rxihly me, ba zidno me leemaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","No ru ba bydzihñ me xiryuꞌ me, ptohp me xmígü me no meññ-nuno me gahsh, ra me lee: “Lâ te, güieꞌ laꞌd dshiilyaꞌ ni bynihty. Rxihlyaꞌ, ba bydzial maꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","No zegahc‑e gapyaꞌ laꞌd, ma xroꞌ guîlrxihly nu gybaa por to meññ-guîlquie ni rsaan ni nahcsy ni nac, que por noventaynuevy meññ-tziaawy ni ba byo Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Dzigyunon laꞌd sto ejempl. Bâḻ to ngünaa caꞌ me tzii medy-guiib sahc xchieñ beeiy tzii xdzé dziiñ, no nniꞌdy me tohbyu, ¿nehx ntahl me gue par nyo meu zaꞌgndzi xtâ glo ndzial meu la? ");
INSERT INTO zpg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","No ru ba bydzial meu, ntohp me xmígü me no meññ-nuno me gahsh, ña me lee: “Lâ te, güieꞌ laꞌd ba bydzialaꞌ dmedyaꞌ ni bnityaꞌ. Rxihlyaꞌ, porni ba bydzialaꞌu.” ");
INSERT INTO zpg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","No gapyaꞌ laꞌd, zegahc‑e rxihly x‑ángel Dioz ru to meññ-guîlquie rsaan ni nahcsy ni nac. ");
INSERT INTO zpg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Gyzac ra Jesúz leeyâme, ne me: ―Güyuꞌ to mpyquie, rahp chohp xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","To dzé ra ñoby-ma lwiñ xtad: “Dad, racdadzyaꞌ gdeedyiꞌ naa dziiñ ni nac dixchieñaꞌ.” “Yo” ne xtad me, ptzulaꞌy dziiñ par cuaꞌ gyrop yâme. ");
INSERT INTO zpg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Güdahpu stoozy dzé ptoꞌ ñobywiñ gyre ni cuaꞌ. Luxu za me, zigyzeꞌ me xguiedzy meññ ru modni ziht. Uga güdziht me gyre xmedy me. ");
INSERT INTO zpg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Naabz‑e naꞌ güdziht me gyreu, bydzun guîlrahgü lgar-nu me, no guzlo bylahn me. ");
INSERT INTO zpg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Were güya me, bigyo me dziiñ to lo mpyquie ni nu lgar-caḻ. Were bdee mpyquie-caḻ dziiñ leeme, bictap me ngutzy to ruꞌ ranch. ");
INSERT INTO zpg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Xtâ xguîlrahgü ngutzy rzîbyladzy me gahgü me, per ndruhty nehx rdeedyu leeme. ");
INSERT INTO zpg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Hor-caḻ were bihdu ihqy me, ne me: “Xiryuꞌ dtadaꞌ rahp me xtahl mós, uga lé riaꞌn ni rahgü yâme, no naa gayehtyaꞌ de guîlrlahn neꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Beeiydí, guibyguiataꞌ xiryuꞌ dtadaꞌ. Hor-gydzihñaꞌ, gapyaꞌ leeme: Dad, ba ptzon guîlquie contr Dioz no contr lii. ");
INSERT INTO zpg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ba nehx rquihñaꞌ tzu dlen xiiñiꞌ. Tzun cooy, gácaꞌ to xmósiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Luxu, biahs me, günahzy me ñahz, zia me xiryuꞌ xtad me. ’Lé ziht ziaꞌ ziaad me, bwieꞌ xtad me leeme no bioob leeme. No za-güxuunn gahc bigydzil-lo leeme, güdiehdzy leeme no gudzy coo ruꞌ me. ");
INSERT INTO zpg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Were ra ñobywiñ leeme: “Dad, ba ptzon guîlquie contr Dioz no contr lii. Ba nehx rquihñaꞌ tzu dlen xiiñiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per xtad me naꞌ ra xmós yahc: “Lâ gboo laaḻ to lahr ni ma mos par gutz me, no lâ cu to beꞌ ña me, no lâ yquee guidguial nieꞌ me. ");
INSERT INTO zpg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","No lâ dziycaꞌ yuzngul-yaañ ni ma nro no igaꞌdy laꞌd leemaꞌ par gahgü nó, no ctzoo nó lni. ");
INSERT INTO zpg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Porni dzé ni byruu me dcoon, par naa la, ren guhty me we. Per naꞌ, leexme we gubyguiat gyzac. Par naa, bynihty me we. Per naꞌ, leexme we bydzial gyzac.” No guzlo ptzoo yâme lni. ");
INSERT INTO zpg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Betzy-lguhl me we dgueññ, porni za me zictzoo me dziiñ lo camp. Hor-gubyguiat me de lo dziiñ‑e naꞌ no gadzihñ me gahsh ruꞌ yuꞌ, bieññ me dxie saꞌ xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Were pquee me riedz to lahd mós par günabdiidz me lee bia nacu dxie saꞌ xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ra mós leeme: “Porni biahd behtzyiꞌ, no ptzoo xtadiꞌ mdad guhty yuzngul-yaañ ni ma nro, porni biahd me, nzaꞌg me.” ");
INSERT INTO zpg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Per betzy-lguhl me naꞌ, modni bydziaꞌdzy no ba ni di ne me gybigy ruꞌ yuꞌ. Were za xtad me ziycaꞌ leeme, par tzu me leññ yuꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Per ra me xtad me: “Lii nanniꞌ bla ihz gatzon xtziiñiꞌ, no gyre leññ iz-wé rzobaꞌ xtiidziꞌ, no nito dgueññ gdeedyiꞌ nîcze to chiv-yaañ naa par ntzon lni no dmígü yahcaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","No aaḻ gaññ ru biahd xiiñiꞌ ni bictzit xmedyiꞌ no meññ-ngünaa yahc ni nehx rahp tohzy mpyquie, biꞌdyiꞌ yuzngul-yaañ ni ma nro lehdy gac xilni me.” ");
INSERT INTO zpg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Were ra xtad me leeme: “Shiꞌñ, per lii nu gahquiꞌ no naa we. Gyre ni rapaꞌ la, xchieñiꞌ we leeu. ");
INSERT INTO zpg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Naꞌ hôrrieꞌ ren gac xilni behtzyiꞌ no gyxihly nó, porni par nó la, ba guhty me we, no naꞌ leexme we biahd; par nó la, ba bynihty me we, no naꞌ leexme bydzial nó lee.” ");
INSERT INTO zpg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","No zegahc bieno Jesúz nirieꞌ xmeññ me, ra me leeyâme: ―Güyuꞌ to mpyquie-ṟicü, rahp me to xmós me ni rwieꞌ gayahc gyre xtziiñ me no gyre ni rtoꞌ me. To dzé we naꞌ, güya meññ bigyne xpatróṉ me, ra yâme leeme: “Nehx rtzoo xmósiꞌ dziiñ zaꞌgndzi, ganiꞌdy me xmedyiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Were pshalcaꞌ gahc patróṉ xmós me, ra me lee: “¿Ulizu mod-ra meññ naa ba nehx gatzooy dziiñ zaꞌgndzi? Racdadzyaꞌ gdeedyiꞌ naa gyre guehtzy ni rahpiꞌ ni queꞌ le meññ lo ni nzahby yahc naa, porni ba nehx beeiy ctzooriꞌ dixtziñaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Were guzlo ganii leññ ihqy xmós me ne: “¿Biaz mód‑e naꞌ dzictzon? Porni dpatróṉaꞌ ba gaboo me naa lo dziiñ. Naa di raḻ ctzon dziiñ lo camp, no rtuꞌn seen gnabaꞌ medy lo meññ. ");
INSERT INTO zpg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Naa nannaꞌ bia ctzon lehdy dze-ba byruun lo xtziiñ me, ba nu dxu gdee lgar gydzihñaꞌ xiryuꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Were, pshalcaꞌ me to por to meññ ni nzahby xpatróṉ me. To mpyquie-bydzihñ nier lee, ra me lee: “¿Bla nzahbyiꞌ dpatróṉaꞌ?” ");
INSERT INTO zpg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ra leeme: “Nzaabyaꞌ leeme diby gayuu tamb ceihd.” Were ra me lee: “Cuaꞌ xguehtzyiꞌ no bzaa stohbyu; gülahqy nunzy cincuent lou, lehdy were di zguixiꞌ gyreu.” ");
INSERT INTO zpg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Gyzac bydzihñ sto, ra me lee: “Naꞌz lii, ¿bla nzahbyiꞌ?” Ra mpyquie-rieꞌ leeme: “Diby gayuu bush-roob trigü.” Ra me mpyquie-wé: “Cuaꞌ xguehtzyiꞌ no bzaa stohbyu; gülahqy nunzy ochent lou.” ");
INSERT INTO zpg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","No bzaclo patróṉ xguîlmañ mós lé ptzunadz patróṉ mod-ptzoo me guîlmañ. No ze we ma mañ meññ-nehx nu lo xtiidz Dioz mod-rtzoo yâme no zrieñ meññ-nac zâ leeyâme, que meññ-nu lo xibyniꞌ Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Per gapyaꞌ laꞌd, lâ ctzoo nirieꞌ: Lâ yquihñ guîlṟicü ni rahp laꞌd lo guiedzylie-rieꞌ par gap laꞌd xtahl mígü, lehdy hor-ba byreu no nehx rahp laꞌd mbehty neꞌ, per nu dxu gabiahz laꞌd lgar ru ba nehx zehty ndruhty. ");
INSERT INTO zpg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Dxu rtzoo ni nac xñahzû nîcze no ni uxiee la, zegahc‑e stzoo me ni nac xñahzû no ni xtahl. No dxu nehx rtzoo ni nac xñahzû no ni uxiee la, zegahc‑e nehx stzoo me ni nac xñahzû no ni xtahl. ");
INSERT INTO zpg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bâḻ laꞌd di raḻ ctzohd ni nac xñahzû no ni rsahc lo guiedzylie-rieꞌ la, zegahc‑e nehx beeiy ycaꞌ laꞌd ni ulihbu rsahc lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","No bâḻ nehx rtzoo laꞌd ni nac xñahzû no xchieñ meññ la, ndruhty nehx zdee laꞌd ni nu par ncaꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ni to mós nehx beeiy stzoo dziiñ tohzy no chohp patróṉ; porni nehx beeiy nzobdiidz me no ñahp xpeeiy me gyrop yâme tohzy mdid. To me ñahc ni ne, no sto me ba yac. No mod-wé gahc‑e nehx beeiy gzobdiidz laꞌd Dioz no gyzîbyladzy laꞌd medy zegahc. ");
INSERT INTO zpg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Meññ-nac yahc fariseu naꞌ, gumm rzîbyladzy yâme medy la, hor-bieññ yâme ni günii Jesúz, gyrehzy günii yâme de leeme. ");
INSERT INTO zpg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Were ra Jesúz leeyâme: ―Laꞌd rteedy laꞌd laꞌd gahc por meññ-tziaawy ñaz-lo meññ, per Dioz rzaclo xguîlmbahñ laꞌd. Porni ni riuꞌladzy meññ lee la, néladzy Dioz leeu. ");
INSERT INTO zpg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Xleiy Moiséz no xtiidz profet, güyuꞌu par ctzoo meññ mod-neu. Per glohdy dze-biahd Juaṉ ni rchôbnihs, guzlo gayieññ meññ lguia mod-rtzoo Dioz mdad, no gyre yâme ganâbladzy par tzu yâme lo xñahz me. ");
INSERT INTO zpg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ma nehx ngann nnihty gybaa no guiedzylie, que nnihty to punt ni nu lo xleiy Dioz sinn di gac mod-neu. ");
INSERT INTO zpg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Dxu ctzily guîltziahl no tziahl no guidzña no sto ngünaa la, gatzoo me guîlquie. No dxu guidzña no to ngünaa ni gübily xguîltziahl la, guîlquie gahc‑e zahcu par lee. ");
INSERT INTO zpg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Güyuꞌ to mpyquie-ṟicü no ruhtz me pur lar-morad ni rsahc, no gyre dzé rtzoo me lni xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","No güyuꞌ sto mpyquie-le Lasr, bydzeꞌ guiedz gydo lady me, rnab me gun. Riaty me, ricchie me nieꞌ xiryuꞌ ṟicü-caḻ. ");
INSERT INTO zpg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wé dxie me, racladzy me ñahgü dzii me nîcze guîlrahgü ni riahb lo yu de ruꞌ xmiax ṟicü. No xtâ riahd mbahcü rliaꞌ xguiedz me. ");
INSERT INTO zpg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bydzihñ dzé we naꞌ, guhty Lasr, no x‑ángel Dioz güiyno xispirt me gybaa ru nu Braṉ. No bydzihñ dzé guhty ṟicü zegahc, no bygaꞌdzy me, ");
INSERT INTO zpg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","zia me infiern no hor-gazacno me ru nu me lo gue, gülesy lo me, bwieꞌ me dxie Lasr coo Braṉ. ");
INSERT INTO zpg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Were pquee me riedz, ra me: “Dad-Braṉ, ¡bioob naa! Pshahl Lasr igadz ihqy ña me lo nzeꞌ no guiaad me guiscaaḻ me dluhdzaꞌ, porni modni gazacnon neꞌ lo gue ru nun.” ");
INSERT INTO zpg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ra Braṉ leeme: “Shiꞌñ, bitsêlou lii, güdahpiꞌ gyrehzy ni byxilynoy dze-güyuꞌy lo guiedzylie. No Lasr bzaczi me dze-güyuꞌ me lo guiedzylie; per naꞌ cuaꞌ me to lgar-mos ru nu me, no lii cuaꞌy lgar-nahcsy ru gazacziy. ");
INSERT INTO zpg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","No dac‑e niwéhzy leeu. Nu to ru modni guiat glawy entr noꞌ no laꞌd. Por mod-wé nehx beeiy ña meññ-nu neꞌ ru nuy. No zegahc meññ-nu ru nuy nehx beeiy ñahd yâme ru nu noꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Were ra ṟicü leeme: “Were rnabaꞌ lii, dad-Braṉ, pshahl Lasr tza me xiryuꞌ dtadaꞌ ");
INSERT INTO zpg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ru nu gaay dbetzyaꞌ, dzigyuno me diidz leeyâme lehdy di guiaad yâme lgarnacsy-rieꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ra Braṉ leeme: “Ba rahp yâme xtiidz Dioz ni bzaa Moiséz no profet yahc ni güyuꞌ ba xtze. Niwé we güieꞌ yâme bia ne.” ");
INSERT INTO zpg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ra ṟicü leeme: “Uliꞌyu mod-neꞌy, dad-Braṉ. Per bâḻ to mînguty gyzac mbahñ no ña nigyne leeyâme la, were nyo yâme Dioz lehdy nsaan yâme ni nahcsy ni nac yâme.” ");
INSERT INTO zpg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ra Braṉ leeme: “Bâḻ di ne yâme yquee ihqy ni bzaa Moiséz no profet yahc la, zegahc‑e nehx squee ihqy yâme bâḻ ña to mînguty nigyne leeyâme.” ");
INSERT INTO zpg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ra Jesúz xmeññ me: ―Nehx ziaadz ni yquihly meññ par guiatrxan; per ¡baazy dzii de meññ ni por xtoḻ me zrieñ ctzoo guîlquie! ");
INSERT INTO zpg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Beeiydí nguꞌ meññ duu yañ me, no nlihby yâme to xguie-ro molin lou no nráḻ yâme leeme leññ nisdoo; niwéhdy‑e ñahc meññ ni por xtoḻ guiatrxan to ni leer bylíladzy dtiidzaꞌ no zidguiahc beeiy mbiux. ");
INSERT INTO zpg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Lâ güieꞌ laꞌd laꞌd gahc! ’Bâḻ to xirmaniꞌ ctzoo guîlquie contr lii la, güluꞌ xguîlriehñ me lehdy di ctzoor meu. No bâḻ ga me csiaaḻladzyiꞌ ni ptzoo me lii la, psiaaḻladzyiꞌ leeu. ");
INSERT INTO zpg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nîcze ctzoo me guîlquie contr lii gahdzy vuelt to dzé, per bâḻ to to vuelt guiaad me, ga me lii: “Rnabaꞌ psiaaḻladzyiꞌ ni ptzon lii”, were psiaaḻladzyiꞌ leeu. ");
INSERT INTO zpg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ra apóstl yahc Jesúz: ―Lii ni rtzoo mdad, gucno noꞌ ma gylídadzy noꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Were ra me leeyâme: ―Bâḻ laꞌd nlíladzy laꞌd nîcze doozy, beeiy ña laꞌd to yag-duug ni zu neꞌ: “Bylahdziꞌ de ru dziibiꞌ, no güya güdzib lo nisdoo”, no nzoobu xtiidz laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Bâḻ dxuhch de laꞌd rahp to xmós, no hor-ba biahd me de ni biyquee me rad o bigyaan me yuhz, ¿nehxni ña laꞌd leeme: “Gürie, gooy”? ");
INSERT INTO zpg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yac, mazyg ña laꞌd leeme we: “Bzaa dguîlrotzien, bihtz shabiꞌ zaꞌgndzi no bidno lo dmiaxaꞌ gyre ni gahguaꞌ no ni goon. Luxu, were ba gahgüiꞌ no gooy.” ");
INSERT INTO zpg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Nehxni rdee mu xquix mós porni rtzoo me nunzy ni rahc mdad leeme? ");
INSERT INTO zpg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","No zegahc‑e laꞌd, hor-ba bylux gyre ni ra Dioz laꞌd ctzohd, were ga laꞌd: “Noꞌ we beeiy mos-nehx rquihñ, porni ni psaꞌn Dioz lo dña noꞌ, niwéhzy ptzoo noꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lóni za Jesúz Jerusaléṉ, güdedy me ru ndziaalu ṟegioṉ-Samary no ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hor-ba gadzihñ me sto guiedzy-yaañ‑e naꞌ, byruu tzii meññ-gayac-ure ni gayudz lady ru ziaad me, per di ndziñgahsh yâme leeme, ziht gahc güliahz yâme ");
INSERT INTO zpg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","no pquee yâme riedz leeme, ne yâme: ―¡Jesúz, Muextr, bioob noꞌ! ");
INSERT INTO zpg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hor-bwieꞌ Jesúz leeyâme naꞌ, ra me leeyahc: ―Lâ tza lo bahl, lehdy güieꞌ me ba biaḻ laꞌd‑e. No lo hor-za yâme, doozy ziaꞌ güzeꞌ yâme, biaḻ gahc yâme. ");
INSERT INTO zpg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Were to lahd yâme bwieꞌ ba biaḻ xguîlguihdz, gubyguiat gahc me, gaquee me riedz, gaguguia me Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","No bisshiby me lo Jesúz, lé güdihsh ihqy me lo yu, par bdee me xquix. No mpyquie-rieꞌ naꞌ, meññ-samaritan‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Were ne Jesúz: ―Tzii yâme ni biaḻ de xguîlguihdz. ¿Óz zguee yâme naꞌ? ");
INSERT INTO zpg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tohzy mpyquie-rieꞌ gubyguiat bdee xquix Dioz, nîcze meññ-stiby lad leeme no ni nehx xfamily meññ-Isṟael lee beeiy nó. ");
INSERT INTO zpg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Luxu, ra me mpyquie-wé: ―¡Biahsiꞌ, gübiꞌ! Ba biaḻiꞌ we, porni bylíladzyiꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Günabdiidz meññ-nac yahc fariseu Jesúz buc sulo ctzoo Dioz mdad. Were ra me leeyâme: ―Dze-sulo ctzoo Dioz mdad, dac‑e ni güieꞌ meññ leeu, sca mod-nwieꞌ yâme behch cos. ");
INSERT INTO zpg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ndruhty nehx znii, ña: “Leeu ba gayahc neꞌ”, o “Leexu ba gayahc uga”; porni ba gahc gatzoo Dioz mdad lahd laꞌd‑e. ");
INSERT INTO zpg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","No ra me xmeññ me: ―Ziaad dzé we ni gacladzy laꞌd güieꞌ laꞌd naa, Mpyquie-Pshahl Dioz Lee, nîcze stiby dzé mbí, per nehx zwieꞌ laꞌd naa. ");
INSERT INTO zpg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","No nîcze gynii meññ, ga: “Leeme zu neꞌ”, o “Leeme zu uga”, per di gylíladzy laꞌd ni di tza laꞌd dzigüiehd. ");
INSERT INTO zpg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porni beeiy to xgue ngüziee we gydahl no zieññu byzaꞌzy leññ gybaa, ze we gacu dze-naa, Mpyquie-Pshahl Dioz Lee, guibyguiataꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per nier, rapaꞌ de ni tedyaꞌ gyrehzy ni nadz, no meññ-nu ni naꞌ squelo yâme naa. ");
INSERT INTO zpg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mod-guhc gahc dze-güyuꞌ Noé, zegahc‑e gac dze-naa, Mpyquie-Pshahl Dioz Lee, guibyguiataꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tzcaḻ güyuꞌ meññ ni gayahgü, gayoo, gayidzña xtâ dze-güyuꞌ Noé leññ arc ni bzaa me. No luxu, guzlo guhc guio-ro no bniꞌdyu gyre meññ ni di nlíladzy ni ra me lee. ");
INSERT INTO zpg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mod-wé gahc‑e ptzoo meññ dze-güyuꞌ Lot. Tzcaḻ nu meññ ni gayahgü, gayoo, gazii, gatoꞌ, gaguꞌ byni, gazaa yuꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per dze-byruu Lot leññ ciuda-Sodom, byruu gue gybaa no guie ni gaqueꞌ gue, no gyre meññ-güyuꞌ yahc uga, bniꞌdyu lee. ");
INSERT INTO zpg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","No mod-wé gahc‑e gatzoo meññ dze-naa, Mpyquie-Pshahl Dioz Lee, guibyguiataꞌ lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’No dxu dziib ihqy yuꞌ dze-wé, no gyre ni rahp me nu leññ yuꞌ, di guiaht me ycaꞌ me leeu leññ yuꞌ; no dxu gatzoo dziiñ lo lyu, di guibyguiat me ruꞌ yuꞌ lehdy ycaꞌ me behch. ");
INSERT INTO zpg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","¡Lâ guitsêlou laꞌd ni guhc ndzab-tziahl Lot! ");
INSERT INTO zpg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dxu rnâbladzy guislaa xguîlmbahñ leegahc la, zniꞌdyu; per dxu csaꞌnu ladzyña Dioz la, wé zahp guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’No gapyaꞌ laꞌd, guiaal ni dziguiahc nirieꞌ, ru nash chohp meññ lo luꞌn, to me tza, sto me guiaꞌn. ");
INSERT INTO zpg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chohp ngünaa gayuꞌd tohzy; to me tza, sto me guiaꞌn. ");
INSERT INTO zpg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Zegahc‑e ru zu chohp mpyquie lo camp, to me tza, sto me guiaꞌn. ");
INSERT INTO zpg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ru bieññ yâme ni günii Jesúz, günabdiidz yâme leeme: ―Lii ni rtzoo mdad, ¿bá glo we gac niwé? Ra me leeyâme: ―Rutisy nash cuerp-guty, wé we rdohp deedy zegahc. ");
INSERT INTO zpg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Günino Jesúz leeyâme ndaagü lo diidz gyzac lehdy di gyrugan yâme de ni rnino yâme Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ra me leeyâme: ―Güyuꞌ to juez leññ to guiedzy, no nehx rdzie me Dioz ni nehx rlaby me meññ. ");
INSERT INTO zpg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","No leññ gahc guiedzy-wé güyuꞌ to ngünaviud, tirgahc ria me lo juez, rigynino me lee par ntzoo guîlguxtisy chehsh meññ-rdziadzyno leeme. ");
INSERT INTO zpg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Leññ xroꞌ tiémp di ne juez ntzucas leeme, per bydzihñ to dzé, ne juez: “Nîcze nehx rdziehbyaꞌ Dioz, ni nehx rlabyaꞌ ndruhty, ");
INSERT INTO zpg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mazyg porni ridtziaꞌdzy ngüna-rieꞌ naa, beeiydí ctzon ni ganab me lehdy di guiaadr me ctziaꞌdzy me naa.” ");
INSERT INTO zpg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Were ne Jesúz: ―Lâ guitsêlou laꞌd ni günii juez-dirquihñ. ");
INSERT INTO zpg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Nehxni Dioz nehx ntzoo me guîlguxtisy par ñacno me xmeññ me ni gaquee riedz leeme dzé no guiaal? ¿Ne laꞌd nlee Dioz par ñacno me leeyâme la? ");
INSERT INTO zpg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Gapyaꞌ laꞌd, leeme ngueeḻy gahc‑e zacno me xmeññ me. Naa Mpyquie-Pshahl Dioz Lee, no dze-guibyguiataꞌ, ¿zdzial ziaꞌraꞌ meññ-rlíladzy Dioz lo guiedzylie la? ");
INSERT INTO zpg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gyzac günii Jesúz ndaagü lo diidz par meññ ni ne meññ-tziaawy leeyahc no luxu di rlaby yâme zâ-bynech, ne me: ");
INSERT INTO zpg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Güya chohp mpyquie ruꞌ idoró, bignab yâme lo Dioz. To me we meññ-nac fariseu ni rguguia leegahc, sto me we meññ-guîlquie ni rguquix mpuezd. ");
INSERT INTO zpg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseu we zuli, no ne: “Rdedyaꞌ xquixiꞌ, Dioz, porni nehx nacaꞌ beeiy zrieñ meññ. Nehx rbaanaꞌ, nehx rtzon mbehty ni dirquihñ, no nehx rzenon ndzab-tziahl sto, ni nehx nacaꞌ beeiy mpyquie-zu wé ni rguquix mpuezd. ");
INSERT INTO zpg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Naa rtzon ayun chohp vuelt to leññ seman, no rdedyaꞌ lii to cuib de lo tzii cuib medy ni rtzon gan.” ");
INSERT INTO zpg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Per mpyquie-rguquix mpuezd naꞌ zu ziht, ni di ne glesy lo gybaa, mazyg rbihby lidzydoo me, no ne me: “¡Bioob naa, Dioz, porni meññ-guîlquie naa!” ");
INSERT INTO zpg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Were ne Jesúz: ―Gapyaꞌ laꞌd, mpyquie-rguquix mpuezd zia me, ba güdedy me beeiy ni nehx nzahby guîlquie; per fariseu naꞌ, nehx güdedy me ze. Porni dxu rguguia leegahc, wé nehx zguguia ndruhty lee; no dxu nehx rguguia leegahc, wé we tzuguia. ");
INSERT INTO zpg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Meññ güiyno yâme mbiux yahc lo Jesúz par cu me laꞌy lee. Per hor-bwieꞌ xmeññ Jesúz ni gayahc, ndush yâme lo meññ-zidno mbiux. ");
INSERT INTO zpg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Were pquee Jesúz riedz leeyâme par guiaad mbiux ru zu me, no ra me xmeññ me: ―Lâ gdee ñahz guiaad mbiux ni zidyo naa, no di yca laꞌd leeyâme; porni dxu gac scâsy mbiux-rieꞌ la, par leeyâme we ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gapyaꞌ laꞌd ni uli, dxu di gap to guîlmbañ-nguhdzy scâsy xguîlmbahñ mbiux la, nehx beeiy tzu ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","To mpyquie-nu idoo xcargü günabdiidz me Jesúz, ra me lee: ―Muextr, naa nannaꞌ meññ-tziaawy lii. ¿Bia mód ntzon lehdy ñapaꞌ guîlmbahñ ni nehx zluhx? ");
INSERT INTO zpg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ra Jesúz leeme: ―¿Bia nacu rahbyiꞌ naa meññ-tziaawy? Ndruhty nehx meññ-tziaawy lee, mazyg nunzy Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Per lguia ni ganabdiidziꞌ naa la, lii nanniꞌ ni rtzoo Dioz mdad ctzoo meññ: “Di senoy tziahl meññ; di igaꞌdyiꞌ meññ; di cuaniꞌ; di gyniiy ni nehx uli de meññ; bzacbeeiy xtadiꞌ no xmamiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Were ra mpyquie-wé leeme: ―Gyre nirieꞌ gatzon mod-ne glo nwiñaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Hor-bieññ Jesúz ni günii me we naꞌ, ra leeme: ―Per nu ziaꞌr to ni riaadziꞌ: güya, ptoꞌ gyre ni rahpiꞌ no bdee xmedyu meññ-nehx rahp mbehty, were zahpiꞌ xtahl ni rsahc gybaa; luxu guiaadiꞌ, tzaꞌy no naa. ");
INSERT INTO zpg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Per hor-bieññ me nirieꞌ, modni güyuꞌ me trixd, porni rahp me xtahl ni rsahc. ");
INSERT INTO zpg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Bwieꞌ Jesúz modni gazacno me, ra: ―¡Modni ngann zahcu no meññ ni rahp xtahl ni rsahc ndee yâme ñahz ntzoo Dioz mdad leeyâme! ");
INSERT INTO zpg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Porni ma nehx ngann ndedy to camell xguiehr igux que ndee to meññ-ṟicü ñahz ntzoo Dioz mdad leeme. ");
INSERT INTO zpg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Gyre meññ-bieññ ni ne me, ra yâme leeme: ―¿Dxu we naꞌ beeiy gylaa par tzu lo xñahz Dioz? ");
INSERT INTO zpg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ra Jesúz leeyâme: ―Gyre ni nehx ñaḻ ntzoo meññ, no Dioz beeiyu. ");
INSERT INTO zpg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Were ra Pedr leeme: ―Lii ni rtzoo mdad, noꞌ psaꞌn noꞌ gyre ni güdahp noꞌ, no zo noꞌ ru zaꞌy. ");
INSERT INTO zpg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, nitisy dxu psaꞌn xiryuꞌ, xtad no xmam, behtzy o baḻ, byzan, tziahl, o xiiñ par ctzoo mod-rtzoo Dioz mdad la, ");
INSERT INTO zpg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Dioz zdee leeme ma xtahl que ni psaꞌn me ni naꞌ, no dzé ni ziaad Dioz zdee leeme guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Güloo Jesúz gydiby tzipychop xmeññ me diby lad, ra me lee: ―Ba tzo nó Jerusaléṉ, no uga dziguiahc gyre ni bzaa profet ba xtze de naa, Mpyquie-Pshahl Dioz Lee. ");
INSERT INTO zpg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Zdee yâme naa lo ña meññ-nehx meññ-Isṟael, no stzuburl yâme naa, no zdeḻy yâme naa, no sshîbyshieñ yâme naa. ");
INSERT INTO zpg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Zguihñ yâme naa, no zgaꞌdy yâme naa; per lo tzonn dzé zbahñaꞌ gyzac. ");
INSERT INTO zpg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Per di ñieññ xmeññ me ni ra me leeyâme, porni dgann yâme bia we ne me, no ngannu par leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lóni gadziñgahsh Jesúz ciuda ni le Jericó, uga dxie to meññ-ngaḻ coo ñahz, rnab me gun. ");
INSERT INTO zpg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ru bieññ me gadedy xtahl meññ, günabdiidz me bia gayahc. ");
INSERT INTO zpg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ra yâme leeme: ―Jesúz ni nac meññ-Nasaret gadedy neꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Were guzlo gaquee me riedz, ne me: ―¡Jesúz, lii ni ziaad de lo xfamily ṟeiy-Davit, bioob naa! ");
INSERT INTO zpg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Per meññ-zunier yahc byduhsh lo me lehdy tzudzie me; per ma rahc me rquee me riedz, ne me: ―¡Bioob naa, Jesúz! ");
INSERT INTO zpg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Were güliahz Jesúz, no pshahl me meññ biycaꞌ mpyquie-wé ni ngaḻ. Hor-bydzihñ me gahsh, ra Jesúz leeme: ");
INSERT INTO zpg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Bia racladzyiꞌ ctzon por lii? Ra me Jesúz: ―Lii ni rtzoo mdad, racdadzyaꞌ cshaliꞌ dloꞌn lehdy güien. ");
INSERT INTO zpg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ra Jesúz leeme: ―Ba byxal loꞌy. Ba biaḻiꞌ we, porni rlíladzyiꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lohg hor-caḻ byxal lo me, no za me náḻ me ru za Jesúz, gaguguia me Dioz. No gyre meññ ni bwieꞌ, güluguia yâme Dioz zegahc. ");
INSERT INTO zpg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Bydzihñ Jesúz Jericó no güdedy gahc me glaꞌy ciuda. ");
INSERT INTO zpg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Uga nu to mpyquie ni le Saqueu; leeme nac xjefy meññ-rguquix mpuezd no ṟicü leeme. ");
INSERT INTO zpg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ganâbladzy me güieꞌ me Jesúz lehdy gzaclo me dxu lee, per di raḻu leeme porni xtahl meññ ziaad no Jesúz, no porni ndop me zegahc. ");
INSERT INTO zpg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ni ptzohdy me, güdedy-güxuunn me no bictzib me to lo yag-duug ñaz-ru tedy Jesúz lehdy güieꞌ me lee. ");
INSERT INTO zpg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hor-bydzihñ Jesúz lgar-wé, bwieꞌ dziib me lo yahg, ra leeme: ―Saqueu, biahtiꞌ ngueeḻy gahc, porni xiryuꞌy‑e gydzihñaꞌ dzêrieꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","“Yo” ne Saqueu, biat-güxuunn me lo yahg, gaxihly me ziyno me Jesúz xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ru bwieꞌ gyre meññ dxie Jesúz leññ xiryuꞌ Saqueu, guzlo galesyno yâmeu, ne yâme: “¡Lâ güieꞌ xnahc‑e dxie Jesúz leññ xiryuꞌ to meññ-guîlquie!” ");
INSERT INTO zpg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Were guzli Saqueu, ra me Jesúz: ―Lii ni rtzoo mdad, gdedyaꞌ glaꞌy gyre ni rapaꞌ ycaꞌ meññ-nehx rahp ni tedydzé. No bâḻ güluquixaꞌ dxuhch ma xtahl de ni nzahby me la, naa guidzguiataꞌ leeu, ctzon leeu tahp cuib. ");
INSERT INTO zpg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Were ra Jesúz leeme no zrieñ meññ-dxieno me lee: ―Niwé rdee diidz glohg ngâstoo, ba bylaa meññ-nu leññ yu-rieꞌ de lo guîlnadz ni ziaad. Porni mpyquie-rieꞌ, de lo gahc xfamily Braṉ‑e ziaad me. ");
INSERT INTO zpg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Naa, Mpyquie-Pshahl Dioz Lee, zidyobyaꞌ meññ ni rahc cuent ba bynihty par guislaan leeyâme de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Lóhgni gayieññ meññ ganii Jesúz mod-wé, guzlo günino me leeyâme ndaagü lo diidz sto, porni ba bydziñgahsh me Jerusaléṉ, no porni nlâdzyx meññ nwieꞌ gahc yâme gyre mod-rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ra me leeyâme: ―Byruu to mpyquie de lahd gahc xfamily meññ-rahc ni rnii, za to guiedzy modni ziht, ziycaꞌ xguehtzy me lehdy dze-guibyguiat me gac me ṟeiy xguiedzy me. ");
INSERT INTO zpg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Antzy ni tza me we naꞌ, pshalcaꞌ me tzii xmós me par bdee me to gá medy-guiib ni modni rsahc, cuaꞌ yâme par ctzono yâmeu dziiñ xtâ glo guibyguiat me. ");
INSERT INTO zpg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","’Per mpyquie-rieꞌ naꞌ, néladzy meññ-xguiedzy me leeme, no por lee we, hor-ba za me, pshahl gahc yâme zrieñ meññ zigyne mod-rieꞌ: “Nehx riuꞌdadzy noꞌ gac mpyquie-rieꞌ dṟeiy noꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nîcze di ñuꞌladzy yâme, per guhc me ṟeiy. No luxu, gubyguiat gahc me xguiedzy me. Hor-ba bydzihñ me we naꞌ, pshalcaꞌ me to por to mos-bdee me medy lee, par gann me bla ptzoo cad to medy-guiib gan. ");
INSERT INTO zpg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mpyquie-bydzihñ nier lee, ra me: “Señor, xmedyiꞌ ni bdeedyiꞌ naa ptzoou gan stzii cuib.” ");
INSERT INTO zpg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ra me lee: “Mos ptzooy no mos-tziaawy lii; sca-ze ptzooy dziiñ mos no doozy ni bdedyaꞌ lii la, zdedyaꞌ lii tzii guiedzy par ctzooy mdad lee.” ");
INSERT INTO zpg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bydzihñ sto me, ra leeme: “Señor, xmedyiꞌ ni bdeedyiꞌ naa ptzoou gan zgaay cuib.” ");
INSERT INTO zpg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ra me lee zegahc: “Zdedyaꞌ lii gaay guiedzy par ctzooy mdad lee.” ");
INSERT INTO zpg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Per sto me bydzihñ, ra leeme: “Señor, xmedyiꞌ zidnon mdid-bdee gahquiꞌ naa. Gülutziawyaꞌ leeu leññ to bay. ");
INSERT INTO zpg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bydziehbyaꞌ ntzonon dziiñ leeu, porni nannaꞌ rahpiꞌ to guîlmbañ-nahdy, rcaꞌy ni nehx gülahqyiꞌ, no rchuꞌy ni zrieñ dxu bdziib.” ");
INSERT INTO zpg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Were ra me lee: “Mos-dirquihñ lii. Mod-rnihzyiꞌ, rzacloꞌn dxu lii. Bâḻ nanniꞌ nahdy dguîlmbahñaꞌ, xtâ rcan ni nehx gülaqyaꞌ no rchun ru zrieñ dxu bdziib, ");
INSERT INTO zpg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿bia nacu, pue, di nguꞌy dmedyaꞌ lo bancü, lehdy dze-nibyguiataꞌ diryuꞌn, ba ndeedyiꞌu naa no ni ba ptzoou gan?” ");
INSERT INTO zpg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Luxu, ra me meññ-zu yahc uga: “Lâ gboo medy-wé leeme, no lâ gdeeu ycaꞌ mpyquie-ptzoo leeu tzii cuib.” ");
INSERT INTO zpg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Were ra yâme leeme: “Señor, ¡per leeme ba rahp me stzii diaa cuibu!” ");
INSERT INTO zpg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ra ṟeiy leeyâme: “Gapyaꞌ laꞌd, dxu rahp, scaꞌ mazy; per dxu nehx rahp, xtâ doozy ni rahp me zruuw leeme. ");
INSERT INTO zpg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","No gyre meññ-rdziadzyno naa ni nehx biuꞌladzy ñahcaꞌ ṟeiy la, lâ guidno leeyâme neꞌ. Lâ igaꞌdy leeyâme ñaz-dloꞌn.” ");
INSERT INTO zpg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bylux günii Jesúz niwé, byruu me, za me Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","No hor-bydzihñ me gahsh de chohp guiedzy ni le Betfagé no Betania, coo to dahñ ni le Oliv, ugaty ba pshahl me chohp de lo tzipychop xmeññ me, ");
INSERT INTO zpg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ra me lee: ―Lâ tza guiedzy-yaañ ni dxie ru tedy ziaꞌr nó, no hor-gydzihñ laꞌd, güieꞌ laꞌd nliiby to burr-yaañ ni ndruhty ziaꞌ dgueññ cuib lee. Lâ cshac leemaꞌ, no guidno laꞌd leemaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","No bâḻ gyruu dxuhch ga laꞌd: “¿Bia nacu gashac laꞌd leemaꞌ?”, lâ ga leeme: “Señor‑e yquihñ leemaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Were za chohp xmeññ me no bydzial yâme leemaꞌ, no guhcu mod-ra Jesúz leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hor-gashac yâme leemaꞌ we naꞌ, byruu xbixwaan maꞌ, ra leeyâme: ―¿Bia nacu gashac laꞌd dburraꞌ? ");
INSERT INTO zpg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ra yâme leeme: ―Porni Señor‑e yquihñ leemaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Were güiyno yâme leemaꞌ ru ziaad Jesúz, pshob shab yâme chehsh maꞌ, no luxu bdziib yâme Jesúz leemaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","No guzlo gahc meññ gatzihly shab yâme lo ñahz ru tedy Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hor-gadzihñ yâme gahsh gá ru riaht ñahz chehsh dañ-Oliv, gyre xmeññ me ni náḻ guzlo gaquee yâme riedz, porni modni gaxihly yâme, no gaguguia yâme Dioz por gyre xroꞌ cos ni gawieꞌ yâme gatzoo Jesúz, ");
INSERT INTO zpg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ne yâme: ―¡Nu laꞌy ṟeiy ni ziaad porni Dioz pshahl leeme! ¡Nu gybaa dzie tziaawy, no riuguia Dioz ni dziib guia! ");
INSERT INTO zpg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Lahd gahc yâme we naꞌ, ziaad chohp tzonn meññ-nac yahc fariseu, ra yâme Jesúz: ―Muextr, güdeḻy meññ ni ziaad gaquee yahc riedz. ");
INSERT INTO zpg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd, bâḻ meññ-rieꞌ yahc guiandzie, guie yahc ni dxie neꞌ squee riedz. ");
INSERT INTO zpg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hor-bydzihñ Jesúz gahsh gá de Jerusaléṉ, guzlo biin me por meññ-nu yahc uga, ");
INSERT INTO zpg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","no ne me: ―¡Bâḻ ndee laꞌd cuent, nîcze dzêrieꞌ, bia nla xguiedzy laꞌd la, nruqueꞌ laꞌd mos‑e! Per laꞌd ba nehx zdee laꞌd cuent, porni ngannu par laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Zdzihñ dzé guiaad meññ ni néladzy laꞌd lee, cu-glawy yâme xguiedzy laꞌd no ctzoo csahc yâme laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Zgaꞌdy yâme laꞌd no zniꞌdy yâme xguiedzy laꞌd, no nehx ssaꞌn yâme ni to guie ni dziib chehsh saꞌ sinn di ctzily yâme leeu. Zahc gyre niwé, porni dze-biaḻaꞌ lahd laꞌd, nehx bdee laꞌd cuent bâḻ Dioz‑e biahd ru nut. ");
INSERT INTO zpg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ru ba bydzihñ yâme Jerusaléṉ, güyuꞌ Jesúz leññ idoró, no guzlo güloo me meññ ni gatoꞌ no meññ ni gazii, ");
INSERT INTO zpg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","no ra me: ―Ganii lo Guehtzy ru queꞌ xtiidz Dioz neu: “Diryuꞌn, par gynino meññ naa we nacu”; per laꞌd gatzoo laꞌdu beeiy to ru riungaꞌdzy meññ-gübaan. ");
INSERT INTO zpg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","No gyre dzé galuu me meññ ruꞌ idoró; per xjefy yahc bahl, no gahc muextr ni ruuḻ yahc xleiy Moiséz, no zrieñ meññ-rahc ni rnii yahc lahd meññ-guiedzy, gayo yâme bia mód ctzoo yâme lehdy igaꞌdy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Per nehx rdzial yâme xnahc ctzoo yâme, porni gyre meññ zu yahc gaquee ihqy ni ganii me. ");
INSERT INTO zpg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","To dzé galuu Jesúz meññ xtiidz Dioz ruꞌ idoró. Lo hor-wé, bydzihñ xjefy yahc bahl no muextr ni ruuḻ yahc xleiy Moiséz, no zrieñ mînguhl yahc ni nac guxtisy. ");
INSERT INTO zpg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ra yâme leeme: ―Guhdzyu noꞌ: ¿dxu naquiꞌ par ctzooy gyre nirieꞌ? ¿o dxu guhdzy lii ctzooyu? ");
INSERT INTO zpg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ra Jesúz leeyâme: ―Zegahc rapaꞌ to ni gnabdiidzaꞌ laꞌd, lâ ga naa: ");
INSERT INTO zpg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Dxu pshahl Juaṉ lehdy bidchôbnihs me meññ? ¿Dioz ni nu gybaa la, o cuentz meññ? ");
INSERT INTO zpg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Were ra saꞌ yâme: ―¿Biaz‑e naꞌ ga nó leeme? Bâḻ nó ga nó Dioz pshahl Juaṉ, za me nó: “¿Biaz nacu naꞌ di nlíladzy laꞌd leeme?” ");
INSERT INTO zpg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","No bâḻ nó ga nó cuentz meññ pshahl leeme la, sshadguie meññ-guiedzy nó we, porni gyre meññ rlíladzy profet‑e Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ni ptzohdy yâme, beeiydí, ra yâme Jesúz: ―Nehx nann noꞌ dxu pshahl leeme par bidchôbnihs me meññ. ");
INSERT INTO zpg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ra Jesúz leeyâme: ―Zegahc nehx zapyaꞌ laꞌd dxu nacaꞌ par ctzon gyre nirieꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Luxu, gyzac guzlo Jesúz ganino me meññ ndaagü lo diidz, ra me leeyâme: ―Güyuꞌ to mpyquie, bdziib me blatzy to lo xroꞌ lyu, no luxu bdee meu zrieñ meññ-ctzoo dziiñu por glaꞌy. Luxu za me to guiedzy ru ziht no gylee meu xroꞌ tiémp. ");
INSERT INTO zpg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Dze-ba gayahc xicüsech blatzy‑e naꞌ, pshahl me to xmós me, ziycaꞌ ni ctzulaꞌy yâme de lo cüsech ru nu meññ-caḻ yahc ni gatzoo dziiñ. Per ru bydzihñ me, aaḻ güdihñ yâme leeme, no gubyguiat me zehzy. ");
INSERT INTO zpg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Gyzac pshahl me sto xmós me, za; per ru bydzihñ me zehg güdihñ yâme leeme, no gu yâme leeme didz-nahcsy, no gubyguiat me zehzy. ");
INSERT INTO zpg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ni bionn vuelt pshahl xbixwaan lyu sto mós, za; ru bydzihñ me we naꞌ, zegahc ptzuné yâme leeme, no blaag yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Were ne xbixwaan lyu: “¿Xnahcs‑e naꞌ dzictzon? Beeiydí, cshaalaꞌ dshiñaꞌ ni ndzin lee; wé duhn ctzoo yâme ni gynii hor-gydzihñ me ru nu yâme.” ");
INSERT INTO zpg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Per scâsy bwieꞌ meññ-caḻ leeme, guzlo gahc gaya saꞌ yâme: “Mpyquie-ziaad, leeme we ni guian-no gyrenac dziiñ dze-ba guhty xtad me; igaꞌdy nó leeme lehdy gac dixchieñ nó gyreu.” ");
INSERT INTO zpg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Were güloo yâme leeme leññ lyu ru dziib blatzy, no bgaꞌdy yâme leeme. Ra Jesúz leeyâme: ―¿Biaz‑e naꞌ ctzoo xbixwaan lyu-caḻ meññ-rieꞌ yahc? ");
INSERT INTO zpg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ni ctzohdy me la, guiaad me no igaꞌdy me meññ-rieꞌ yahc, no gdee me lyu-wé, ycaꞌ zrieñ meññ. Ru bieññ meññ günii Jesúz mod-wé, ne yâme: ―¡Di ñahcladzy Dioz ñahc nó mod-wé! ");
INSERT INTO zpg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Were bwieꞌ Jesúz gyre yâme, no ne me: ―¿Nann laꞌd bia rnii ni nu lo Guehtzy ru queꞌ xtiidz Dioz la?, ru neu mod-rieꞌ: Guie ni di ne meññ-rzaa yuꞌ nquihñ, naꞌ lehbu ba nash squiñp ru raa guie ni ma rquihñ lehdy tzaa yuꞌ zaꞌgndzi. ");
INSERT INTO zpg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","No leewe, dxu guiahb chehsh guie-wé la, stzubiuw lee; per bâḻ guie-wé guiahbu chehsh dxuhch la, ctzudéu lee. ");
INSERT INTO zpg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Gucladzy xjefy yahc bahl no muextr ni ruuḻ yahc xleiy Moiséz nnahzy yâme Jesúz lohg hor-ganii me, porni bdee yâme cuent de leeyâme günii Jesúz nirieꞌ ni ndaagü lo diidz. Per di ntzoo yâmeu, porni rdzie yâme meññ-guiedzy. ");
INSERT INTO zpg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Güliahz yâme güyuꞌr to mód, were güluꞌ yâme meññ-güya par nisquiee leeme, ndedy por meññ-tziaawy par nwieꞌ bâḻ nnii me behch, lehdy ñuꞌ mod-nnahzy yâme leeme par niyno yâme leeme lo gobernador. ");
INSERT INTO zpg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ru bydzihñ yâme, ra yâme leeme mod-rieꞌ: ―Muextr, noꞌ nann noꞌ gyre ni rniiy no gyre ni rluuy meññ, ni uli we leeu, no par lii tohzy mdid‑e rsahc gyre meññ. Rluuy ni uli lguia ni racladzy Dioz ctzoo meññ. ");
INSERT INTO zpg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Leewe gu noꞌ: ¿xñahzu we quix noꞌ mpuezd lo xṟeiy meññ-Ṟom la, o yac? ");
INSERT INTO zpg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Per Jesúz nann me guîlrieñ-nahcsy ni zidno yâme. Were ra me leeyâme: ―¿Bia nacu riñlo laꞌd csiahb laꞌd naa no to ni ngann? ");
INSERT INTO zpg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Lâ gluu naa to medy-guiib ni zidnot. ¿Dxu lo we nirieé, no dxu le queꞌ neé? Ra yâme leeme: ―Xchieñ Cézr ni nac xṟeiy meññ-Ṟom. ");
INSERT INTO zpg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ra me meññ-wé yahc: ―¿Biaz mazy? Lâ gdee Cézr ni nac xchieñ Cézr, no lâ gdee Dioz ni nac xchieñ Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","No di ñaḻ ndzial yâme bia mód ntzoo yâme contr leeme, aaḻ modni ptzunadz yâme no mod-günii me, no ba di nnabdiidzr yâme leeme mbehty. ");
INSERT INTO zpg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Güdedy nirieꞌ, gyzac güya meññ-nac yahc saduceu lo Jesúz; no meññ-rieꞌ yahc naꞌ, ne yâme nehx zbahñ mînguty; ");
INSERT INTO zpg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ra yâme Jesúz: ―Muextr, Moiséz bzaa me lo leiy, ne me: “Bâḻ to mpyquie rehty me no riaꞌn tziahl me no nehx güdahp xiiñ la, behtzy gahcme guidzña no ngüna-rieꞌ lehdy gap xiiñ yâme xcuent behtzy me ni guhty.” ");
INSERT INTO zpg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Naꞌ hôrrieꞌ, güyuꞌ gahdzy meññ-mpyquie behtzy saꞌ yâme; no ni nac lguhl lahd yâme bidzña me, per guhty me no biaꞌn tziahl me nehx güdahp xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Were bidzña ni byrohp yâme no ngüna-caḻ, no zegahc guhty no di ñahp xiiñ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Gyzac bidzña ni bionn yâme no ngüna-caḻ no nehx güdahp xiiñ yâme. No mod-wé glo byzaꞌ gydiby gahdzy yâme ni cuaꞌ ngüna-caḻ. ");
INSERT INTO zpg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","No por últim, zegahc guhty ngüna-wé. ");
INSERT INTO zpg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Naꞌz naꞌ, dze-gybahñ mînguty, ¿dxu de leeyâme gac tziahl ngüna-wé, porni gydiby gahdzy yâme bidzña no leeme? ");
INSERT INTO zpg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Were, ra Jesúz leeyâme: ―Lo guiedzylie-rieꞌ ridzña mpyquie no ngünaa, no rdee meññ guîltziahl xiiñ. ");
INSERT INTO zpg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Per meññ ni gybahñ sto no ni beeiy ctzoo yahc gan tzu lo guiedzylie-coby, uga ba nehx zidzña, no nehx zdee meññ guîltziahl xiiñ. ");
INSERT INTO zpg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","No dze-ba gübahñ meññ la, ba nehx ziuꞌ dzé gaty yâme. Beeiy gahc ángel ni nu gybaa we gac yâme. No meññ-gybahñ yahc sto, wé ba xiiñ Dioz‑e leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","No lguia ni gybahñ mînguty naꞌ, Moiséz gahc bzaa me lo guehtzy lguiau, ru queꞌ ni ra Dioz leeme ru bwieꞌ me rdahl biaḻ lo yag-guiahtz; no ne me ni rtzoo mdad we xDioz Braṉ, Isac no Jacop ni güyuꞌ yahc ba xtze. ");
INSERT INTO zpg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","No Dioz naꞌ, dac‑e xDioz mînguty leeme, mazyg xDioz meññ-mbahñ‑e leeme; no par leeme la, gyre meññ‑e mbahñ, nîcze nehx nu yâme lo guiedzylie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Were, ra lahd muextr leeme ni ruuḻ yahc xleiy Moiséz: ―Leeu mod-neꞌy, Muextr. ");
INSERT INTO zpg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","No ba bydzie yâme nnabdiidzr yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ra Jesúz leeyâme: ―¿Bia mód‑e ne meññ, xiiñ ṟeiy-Davit‑e Crist? ");
INSERT INTO zpg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","No luxu, Davit gahc bzaa lo libr-Salm, ne me: Günii Dioz, ra me Señor ni rtzoo mdad naa: “Gürie dcoon lad-drech, ");
INSERT INTO zpg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","xtâ glo ctzon gyre meññ-rdziadzyno lii, guisshiby yâme loꞌy.” ");
INSERT INTO zpg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davit gahc ra me Crist: “Señor ni rtzoo mdad.” Were, ¿bia mód‑e naꞌ ne meññ lguia Crist, xiiñ Davit‑e leeme? ");
INSERT INTO zpg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Gyre meññ gayieññ ru ra Jesúz xmeññ me: ");
INSERT INTO zpg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Lâ gap laꞌd no muextr ni ruuḻ yahc xleiy Moiséz. Riuꞌladzy yâme rzeꞌ yâme ruhtz yâme lar-duhñ ni rsahc. No ru ganzeꞌ yâme leññ guiedzy, racladzy yâme gynii meññ diux leeyâme no xroꞌ guîlrzacbeeiy. No ryo yâme ru ma mos rbia yâme leññ idoo ru rbia meññ-rsahc; no zegahc ryo yâme ru ma mos rbia yâme ru rotzie yâme no meññ. ");
INSERT INTO zpg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Rboo yâme xyuꞌ ngünaviud, no sto lad ba zu yâme ruuḻ yâme laꞌy xtze, rluuw ulihbu meññ-tziaawy leeyâme; per ma xroꞌ guîlné we ycaꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bwieꞌ Jesúz, gaguꞌ meññ-ṟicü modni xtahl medy leññ caj ru riuꞌ gun. ");
INSERT INTO zpg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","To ngüna-byzahby, wé bwieꞌ me güluꞌ gun chohp medy-guiib ni uxiee dzii rsahc. ");
INSERT INTO zpg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Were ne Jesúz: ―Ni uli gapyaꞌ laꞌd, ngüna-rieꞌ ni viud lee, ma xroꞌ gun bdee que gyre zrieñ meññ-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Porni gyre yâme bdee ni ba biaꞌn; per ngüna-rieꞌ naꞌ, pobr‑e leeme, no bdee me gyrenac ni rahp me ni ndedydzé gahc me. ");
INSERT INTO zpg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Güyuꞌ lahd meññ ni gatzunadz mod-güyaa idoró, ne yâme pur guie-mos ziynou no zehg mos gyre zrieñ ni biscady meññ mod-to gun par Dioz. Were ra Jesúz leeyâme: ");
INSERT INTO zpg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Zdzihñ to dzé zdiñguie gyrenac ni gatzunadz laꞌd lee. Per ni to guie di ziaꞌn chehsh sto guie; gyreu znihty. ");
INSERT INTO zpg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Were günabdiidz yâme, ra yâme leeme: ―Muextr, ¿buc‑e gac nirieꞌ? ¿No bia señal güieꞌ noꞌ ni gdee diidz de ni ba dziguiahcu? ");
INSERT INTO zpg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ra Jesúz leeyâme: ―Gax lâ gann, na di guisquiee meññ laꞌd. Porni siahd xtahl meññ-gaquihñ dlen, no gynii yâme leeyâme we nac Crist, no ga yâme ba gadziñgahsh dze-gynihty guiedzylie. Per na di guisnáḻ laꞌd leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","No dze-guieññ laꞌd ba gadeḻy meññ byzaꞌzy, di gydzie laꞌd porni nier niwé yahc‑e rahp de ni gac. Per dac ziaꞌr‑e ba dzigynihty guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","No ne me: ―To guiedzy zdeḻy no sto guiedzy, no to gobiern zdeḻy no sto gobiern. ");
INSERT INTO zpg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","No zahc xu-roob, ziuꞌ guîlrlahn no ziuꞌ guîlguihdz byzaꞌzy. No zwieꞌ meññ ni ndzieeby no xroꞌ señal leññ gybaa. ");
INSERT INTO zpg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Per antzy ni gac gyre nirieꞌ, znahzy yâme laꞌd no zgultihp yâme laꞌd. Tziyno yâme laꞌd lo xjefy meññ-idoo no cu yâme laꞌd lidzyguiib, no tziyno yâme laꞌd lo guxtisy no lo gobernador. Gyre niwé ctzoo yâme laꞌd, porni nac laꞌd dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Per lo hor-wé zahp laꞌd mod-guno laꞌd dtiidzaꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","No na di cu ihqy laꞌd bia gynii laꞌd par gyla laꞌd laꞌd gahc lo meññ-rdziadzyno laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porni naa gacno laꞌd par gynihd no sshalaꞌ xguîlriehñ laꞌd, no ndruhty ni rdziadzyno laꞌd di zaḻu lee no laꞌd, no di zaḻ gynii yâme nehx uli ni ganii laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","No xtâ xtad gahc laꞌd no xmam laꞌd zdee yâme laꞌd lo ña zrieñ meññ, no xtâ behtzy gahc laꞌd, no zrieñ xfamily laꞌd, no xmígü gahc laꞌd. No xtâ zgaꞌdy yâme lahd laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","No gyre meññ zdziadzyno laꞌd, porni nac laꞌd dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Per Dioz zacno me laꞌd. Nehx znihty ni to xguitz-ihqy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","No bâḻ ctibladzy laꞌd la, scaꞌ laꞌd to guîlmbahñ no Dioz ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’No hor-güieꞌ laꞌd ba gülu-glawy soldad Jerusaléṉ la, lâ gann ba dzigynihtyu we. ");
INSERT INTO zpg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","No gyre meññ ni nu lo ṟegioṉ-Judea gxuunn yâme, gybiꞌ yâme guehsh; no meññ-nu yahc Jerusaléṉ, gxuunn yâme de leññ ciuda; meññ ni za yahc dziiñ, ba di guibyguiat yâme leññ ciuda. ");
INSERT INTO zpg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porni dze-gac guîlnadz, leeu we par gac gyre ni ganii lo Guehtzy ru queꞌ xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Baazy dzii meññ-ngünaa ni nu de xcuidad o caꞌ mdo-yaañ leññ dze-wé yahc! Porni xroꞌ guîlrzacno no guîlné tedy meññ-nu lgar-wé yahc. ");
INSERT INTO zpg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Xtahl yâme zgaꞌdy meññ lee no nu yâme zguꞌ yâme lee lidzyguiib zrieñ guiedzy. No meññ-nehx meññ-Isṟael stzoo ssahc yâme Jerusaléṉ, xtâ dzé ni gynii Dioz, were guiandzieu. ");
INSERT INTO zpg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’No luxu, tzu señal leññ gybaa: gydzee mod-nac ncübidz, no mboo zegahc, no mbial. Ba di zdzial meññ bia ctzoo de tant dzieeby por ṟid-ro ni ctzoo nisdoo no oḻ. ");
INSERT INTO zpg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lé zdiñguie meññ lo yu beeiy ni retycawy de dzieeby hor-güieꞌ yâme ni dziguiahc lo guiedzylie; porni zniꞌby gyre ni nu leññ gybaa. ");
INSERT INTO zpg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","No zwieꞌ yâme naa, Mpyquie-Pshahl Dioz Lee, guiaḻaꞌ to lo zá, no beeiyu naa gyreu no zidnon guîlbyni-ro. ");
INSERT INTO zpg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hor-güieꞌ laꞌd sulo gac gyre niwé, lâ gyxihly no lâ glesy ihqy laꞌd, porni ba gadziñgahsh dzé ni gylaa laꞌd togahcs. ");
INSERT INTO zpg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","No günii me sto ni ndaagü lo diidz, ne me: ―Lâ güieꞌ ru ba yag-duug no zrieñ yahg, ");
INSERT INTO zpg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ziaad guix-yaañ lou la, ba nann laꞌd tiempleꞌñ‑e ba gadziñgahsh. ");
INSERT INTO zpg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","No mod-wé gahc‑e, dze-ba rwieꞌ laꞌd gayahc nirieꞌ, lâ gann ba gadziñgahsh de ni rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Gapyaꞌ laꞌd ni uli, gyre nirieꞌ gac antzy ni gaty meññ-nu yahc ni naꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Zdedy gybaa no guiedzylie, per ni ganin nehx zdedyu. ");
INSERT INTO zpg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Lâ gap laꞌd laꞌd gahc, no na di ctzunahdy aaḻ xguîlmbahñ laꞌd no guîl-la no guîlngüee, no na di cu ihqy laꞌd ni yquihñ laꞌd lo guiedzylie, lehdy di gydzihñ dze-wé tohzy dirpentzy sinn tzu laꞌd puexd; ");
INSERT INTO zpg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","porni gacu beeiy to gueshmbaḻ‑e guiahb chehsh gyre meññ ni nu gydo lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","No leewe, lâ tzu puexd no lâ gnab lo Dioz tirgahc lehdy beeiy gylaa laꞌd de lo gyre ni dziguiahc, no lehdy beeiy gydzihñ laꞌd lo Mpyquie-Pshahl Dioz Lee. ");
INSERT INTO zpg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yudzé rluu Jesúz meññ ruꞌ idoró. Guiaal ria me to dahñ ni le Oliv, no uga rdedy me guiaal. ");
INSERT INTO zpg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","No gyre meññ ria idoo cad rsily par guieññ yâme ni rnii me. ");
INSERT INTO zpg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ba gadzihñ lni-Pascü ni rtzoo meññ-Isṟael, dze-rahgü meññ paṉ ni nehx rahp levadur. ");
INSERT INTO zpg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Xjefy bahl yahc naꞌ, no muextr ni ruuḻ yahc xleiy Moiséz guzlo gayo yâme xnahc dzictzoo yâme lehdy igaꞌdy yâme Jesúz, porni rdzie yâme meññ-guiedzy. ");
INSERT INTO zpg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","To dzé güyuꞌ bêndzab Jud-Iscariot, to lahd gydiby tzipychop xmeññ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Güya me ru nu xjefy yahc bahl no ru nu zrieñ xjefy meññ-rahp ruꞌ idoró, bictzoo me diidz no meññ-wé yahc bia mód gdee me Jesúz lo ña yâme. ");
INSERT INTO zpg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Modni rxihly yâme, no ptzoo yâme diidz gdee yâme medy ycaꞌ Jud. ");
INSERT INTO zpg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","“Yo” ne Jud, no xtâ glo dze-caḻ ba guzlo gayo me to mód lehdy gdee me Jesúz lo ña yâme sinn di gann meññ-guiedzy. ");
INSERT INTO zpg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ba bydzihñ dze-wé naꞌ, dze-rahgü meññ paṉ ni nehx rahp levadur, dze-rgaꞌdy yâme xiily ni rdee yâme gun Dioz lo lni-Pascü. ");
INSERT INTO zpg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Were, pshahl Jesúz Pedr no Juaṉ, ra me leeyâme: ―Lâ tza, lâ dziguistziaawy gyreu lehdy gotzie nó ni rahc lo lni-Pascü. ");
INSERT INTO zpg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ra yâme leeme: ―¿Bá glo racladzyiꞌ dziguistziaawy noꞌ leeu? ");
INSERT INTO zpg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ra Jesúz leeyâme: ―Ru gydzihñ laꞌd ciuda, uga güieꞌ laꞌd to mpyquie ni ziyno to rieꞌ nzeꞌ. Ba náḻ laꞌd leeme xtâ ru tzu me yuꞌ, ");
INSERT INTO zpg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","no ga laꞌd xbixwaan yuꞌ mod-rieꞌ: “Ze ne Muextr: ¿Bia leññ yuꞌ we ru gotzien no dmeññaꞌ ni rahc lo lni-Pascü?” ");
INSERT INTO zpg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Uga gluu me laꞌd to leññ yu-ro sto pis guia ni ba nu puexd. Uga lâ guistziaawy gyreu. ");
INSERT INTO zpg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Güyaty yâme no guhc gyre mod-ra Jesúz leeyâme. No uga bistziaawy yâme gyre ni rahc lo lni-Pascü. ");
INSERT INTO zpg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ru biygahl hór‑e naꞌ, were gürie Jesúz no x‑apóstl me ruꞌ miax. ");
INSERT INTO zpg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","No ra me leeyâme: ―Dgann laꞌd blaty‑e riuꞌdadzyaꞌ gotzien no laꞌd xguîlrahgü lni-Pascü antzy ni gatyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Porni gapyaꞌ laꞌd, ba nehx zibyguiat gahgüraꞌnu xtâ dze-ba diaa gayahcu ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Luxu cuaꞌ me to cop lo ña me, bdee me xquix Dioz, no ra me leeyâme: ―Lâ ycaꞌ nirieꞌ, no lâ goo de leeu gyre laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Porni gapyaꞌ laꞌd, ba nehx zibyguiat gooraꞌ nirieꞌ ni riaa no blatzy xtâ ba diaa bydzihñ dzé ni rtzoo Dioz mdad, were goonu. ");
INSERT INTO zpg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","No cuaꞌ me paṉ lo ña me no bdee me xquix Dioz, no ptzulaꞌy meu, bdee meu cuaꞌ xmeññ me, no ra me leeyâme: ―Nirieꞌ we dcuerpaꞌ ni rdedyaꞌ por laꞌd. Mod-rieꞌ ctzoo laꞌd, mod-gatzoo nó ngâstoo, lehdy di guiaaḻladzy laꞌd naa. ");
INSERT INTO zpg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","No bylux güetzie yâme, mod-wé gahc ptzoo me no cop-wé, cuaꞌ meu no ra me leeyâme: ―Cop-rieꞌ we ni rdee diidz nu sto mod-coby lehdy tzu meññ tohzy no Dioz, no gacu por drieñaꞌ ni gyxieꞌ par laꞌd hor-gatyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’No ruꞌ gahc miax-dxie nó we, dxie mpyquie-gdee naa lo ña meññ-rdziadzyno naa. ");
INSERT INTO zpg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Naa, Mpyquie-Pshahl Dioz Lee, rapaꞌ de ni tedyaꞌ gyre ni ba nac diidz. Per ¡baazy dzii de mpyquie-gdee naa lo ña meññ-rdziadzyno naa! ");
INSERT INTO zpg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Were guzlo günabdiidz saꞌ yâme, ne yâme: “¿Dxuhx de nó we ctzoo ze?” ");
INSERT INTO zpg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","No guzlo gadeḻydiidz yâme dxu de lahd yâme ma qysahc. ");
INSERT INTO zpg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Were ra Jesúz leeyâme: ―Ṟeiy yahc ni rtzoo mdad lo guiedzylie-rieꞌ, rtzoo yâme xmeññ yâme gyre mod-ne yâme; no zrieñ meññ ni rahc ni rnii la, riuꞌladzy yâme ga meññ meññ-tziaawy we leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per laꞌd, na di gac laꞌd beeiy gahc leeyâme, mazyg dxu racladzy ma qysahc lahd laꞌd la, rahp de ni gac scâsy ni ndruhty nehx nac. No dxu rtzoo mdad, rahp de ni gac scâsy to mós ni racno zrieñ meññ. ");
INSERT INTO zpg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Dxu ma rsahc: ni rbia ruꞌ miax roo la, o mós ni rbahqy guîlroo? Ni rbia ruꞌ miax, wé we ma rsahc. Per naa nun lahd laꞌd par gacnon meññ scâsy to mós. ");
INSERT INTO zpg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Laꞌd güyuno laꞌd naa lo gyre ni nadz ni ba güdeedyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Leewe, gdedyaꞌ laꞌd ru ctzohd mdad mod-bdee gahc dTadaꞌ ru rtzon mdad, ");
INSERT INTO zpg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","lehdy were gahgü laꞌd no goo laꞌd ruꞌ miax ru ctzon mdad. No uga cuia laꞌd par ctzoo laꞌd guîlguxtisy lguia gyre meññ-ziaad de lo xfamily gydiby tzipychop xiiñ Isṟael. ");
INSERT INTO zpg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Luxu, zegahc ne Jesúz: ―Simóṉ, Simóṉ, bwieꞌ güieꞌzyiꞌ. Ba günab bêndzab gdedyaꞌ lgar ctzoo me laꞌd gyre gyzasy, beeiy rtzoo meññ trigü ru rboo yâme xguixu. ");
INSERT INTO zpg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Per ba günabaꞌ lo Dioz gacno me lii lehdy di csaꞌniꞌ de ni rlíladzyiꞌ naa. Per dze-ba gubyguiat gyohbyiꞌ naa sto, gucno zrieñ meññ-xirmaniꞌ par di gyrugan yâme. ");
INSERT INTO zpg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ra Simóṉ leeme: ―Lii ni rtzoo mdad, naa ru tzaꞌy‑e tzan. Bâḻ tzaꞌy lidzyguiib la, noc naa wé tza, no ru gatyiꞌ la, wé gahc‑e gatyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Were ra Jesúz leeme: ―Pedr, gapyaꞌ lii ni uli, guial-rieꞌ gahc‑e ni dgueññ ziaꞌ cuiadz rig, lii ba tzonn vuelt güniiy nehx rzacloꞌy naa. ");
INSERT INTO zpg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Luxu, ra Jesúz leeyâme: ―Dze-güyat ru pshaalaꞌ laꞌd, nehx güiyno laꞌd bush, ni medy, ni chohp pár guidguial, ¿biaadz laꞌd behch la? Ra yâme leeme: ―Mbehty di ñaadz noꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Were ra Jesúz leeyâme: ―Per ngâstoo, dxu laꞌd ni rahp bush la, lâ tziyno leeu, no lâ tziyno medy zegahc. No dxu nehx rahp spad la, ctoꞌ xchomp me, par sii me leeu. ");
INSERT INTO zpg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porni gapyaꞌ laꞌd, nirieꞌ we ni nu lo Guehtzy ru queꞌ xtiidz Dioz ni ganii de mod-rapaꞌ de ni gácaꞌ, neu: “Pteedy yâme leeme por meññ-guîlquie.” Ni nu lo xtiidz Dioz ni ganii de naa la, rahpu de ni gacu. ");
INSERT INTO zpg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Were ra yâme Jesúz: ―Lii ni rtzoo mdad, neꞌ nu chohp spad. Ra me leeyâme: ―Ba niwéhzy. ");
INSERT INTO zpg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Luxu, byruu Jesúz, za me dañ-Oliv mod-rtzoo gahc me, no náḻ xmeññ me leeme. ");
INSERT INTO zpg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bydzihñ yâme uga, ra me xmeññ me: ―Lâ gnab lo Dioz lehdy gacno me laꞌd par di ctzoo laꞌd ni racladzy bêndzab. ");
INSERT INTO zpg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","No luxu, za me beeiy mdid-rráḻt meññ to guie. Bydzihñ me, bisshiby me, guzlo ganino me Dioz, ");
INSERT INTO zpg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ra me: ―Dad, bâḻ racladzyiꞌ la, bislaa naa de lo ni nadz ni gabiahz naa; per dac‑e gac ni ren, mazyg gac ni neꞌy. ");
INSERT INTO zpg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Lo hor-ganino me Dioz, biahd to ángel ni byruu gybaa gucno leeme. ");
INSERT INTO zpg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","No lo hor-ma gazaczi me, ma ndip ganino me Dioz, no garuu nisluhn leeme, lé beeiy mod-rdzuhñ rieñ lo yu. ");
INSERT INTO zpg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ru bylux günino me xTad me, biahs me, güya me ru biaꞌn xmeññ me. Bydzihñ me, bwieꞌ me nishcahsy yâme porni nu yâme trixd. ");
INSERT INTO zpg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Were, ra me leeyâme: ―¿Bia nacu nishcahsy laꞌd? Lâ guiahs, no lâ gnab lo Dioz lehdy gacno me laꞌd, par di ctzoo laꞌd ni racladzy bêndzab. ");
INSERT INTO zpg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ganii ziaꞌ Jesúz ze, tohzy bydzihñ xtahl meññ. No Jud, ni lee nac to lahd gydiby tzipychop xmeññ Jesúz, leeme zunier lo yâme. Ru bydzihñ me, gübigy gahc me lo Jesúz par pcuruꞌ me lee. ");
INSERT INTO zpg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Were ra Jesúz leeme: ―Jud, ¿pcuruꞌy naa par gdeedyiꞌ naa, Mpyquie-Pshahl Dioz Lee, lo ña meññ-rieꞌ la? ");
INSERT INTO zpg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hor-bwieꞌ xmeññ me ni ba gayahc, ra yâme Jesúz: ―Lii ni rtzoo mdad, ¿squelo noꞌ leeyâme no spad la? ");
INSERT INTO zpg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Byruu to lahd yâme, güloo me rid to xmós xjefy gyre bahl, pchug me gydiag-drech mós. ");
INSERT INTO zpg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Were ra Jesúz leeyâme: ―¡Zî-nu yâme! Ba niwéhzy. No güdan Jesúz ru byrug gydiag mpyquie-wé no biaḻ gahcu. ");
INSERT INTO zpg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Luxu, ra me xjefy yahc bahl, no zrieñ xjefy meññ-rahp ruꞌ idoró, no zrieñ mînguhl yahc ni nac guxtisy ni zidnahzy leeme: ―¿Zidnot spad no garrot lehdy gynahzy laꞌd naa beeiy to meññ-gübaan la? ");
INSERT INTO zpg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Gyre dzé güyun ruꞌ idoró no laꞌd, per nehx günahzy laꞌd naa. Per ngâstoo were ba bydzihñ hór par gac ni ne laꞌd, no par gac ni ne ni rtzoo mdad lo guibcawy. ");
INSERT INTO zpg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Were günahzy yâme Jesúz, ziyno yâme leeme xiryuꞌ xjefy gyre bahl, no náḻt Pedr ziht gá. ");
INSERT INTO zpg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ru bydzihñ yâme we naꞌ, gülahqy yâme gue glaꞌy stziuꞌ, luxu gürie yâme gybiu. Noc Pedr gürie lahd yâme. ");
INSERT INTO zpg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tohzy byruu to criad, bwieꞌ dxie me coo gue, no ra: ―Mpyquie-rieꞌ zegahc güyuꞌ me tohzy no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Per Pedr naꞌ günii me, ra me ngüna-wé: ―Yac. Ni nehx rzacloꞌn leeme. ");
INSERT INTO zpg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Leññ stiby ṟat byruu sto mpyquie, ra leeme: ―Lii zegahc xmeññ Jesúz lii. Gyzac ra Pedr leeme: ―Nehx uliu, ño. Dac‑e xmeññ me naa. ");
INSERT INTO zpg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Güdahpu beeiy stiby hór, byruu sto lahd yâme, ne: ―Ni ulihbu, mpyquie-rieꞌ zehg ziaad me no Jesúz, porni meññ-Galilea we leeme. ");
INSERT INTO zpg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Were ra Pedr mpyquie-wé: ―Ni nehx nannaꞌ de bia ganiiy. Ganii ziaꞌ Pedr ze, tohzydzi güriedz rig. ");
INSERT INTO zpg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bidzguiat gahc lo Jesúz, bwieꞌ me ru dxie Pedr. Were bitsêlou Pedr de ni ra Jesúz leeme: “Dgueññ ziaꞌ cuiadz rig, lii ba tzonn vuelt güniiy nehx rzacloꞌy naa.” ");
INSERT INTO zpg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Byluxu byruu Pedr de uga, biin me gyre gylux. ");
INSERT INTO zpg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Gyre meññ-gayahp Jesúz guzlo gatzuburl yâme leeme, no gaguihñ yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Psaagü yâme lo me no luxu rgahp yâme lo me, no ra yâme leeme: ―¡Günii dxu güdihñ lii! ");
INSERT INTO zpg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","No günii yâme xtahl ni nahcsy lguia me lehdy ptzuburl yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ni byre guiaal, bydohp gyre mînguhl yahc ni nac guxtisy lahd meññ-Isṟael, no xjefy yahc bahl no zrieñ muextr ni ruuḻ yahc xleiy Moiséz. No luxu, ziyno yâme Jesúz ru dxie gyre xguxtisy yâme, no uga ra yâme leeme: ");
INSERT INTO zpg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―¿Lii we nac Crist la? Guhdzyu noꞌ naꞌ. Ra Jesúz leeyâme: ―Nîcze ñapyaꞌ laꞌd uliu, nehx zlíladzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","No bâḻ nnabdiidzaꞌ laꞌd behch la, di zdzial laꞌd bia ga laꞌd naa, ni di zislahd naa. ");
INSERT INTO zpg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Glohg ngâstoo naa, Mpyquie-Pshahl Dioz Lee, ba dzicchien xlad-drech Dioz ni beeiyu lee gyreu. ");
INSERT INTO zpg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ra gyre yâme leeme: ―¿Lii we, pue, Xiiñ Dioz la? Ra me leeyâme: ―Laꞌd gahc‑e ne ze leeu. ");
INSERT INTO zpg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Were ra saꞌ yâme: ―¿Bia mazy racdadzy nó tzu dxu gynii? Nó ba bieññ nó bia ne me. ");
INSERT INTO zpg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Luxu, biahs gyre meññ-bydohp yahc no ziyno yâme Jesúz lo Pilat. ");
INSERT INTO zpg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Uga guzlo günii yâme contr leeme no ne yâme: ―Mpyquie-rieꞌ we ni gaquihly dmeññ noꞌ. Ra me noꞌ di quix noꞌ mpuezd lo xgobiern Cézr, no ne me leegahcme we nac Crist, ni ziaad de ṟeiy. ");
INSERT INTO zpg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Were ra Pilat leeme: ―¿Lii we xṞeiy meññ-Isṟael la? Ra Jesúz leeme: ―Lii we neu. ");
INSERT INTO zpg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Were ra Pilat xjefy yahc bahl no zrieñ meññ: ―Nehx rdzialaꞌ mbehty doḻ lguia mpyquie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Per leeyâme naꞌ, ma rahc yâme rquee yâme riedz, ne yâme: ―Rtziiñ me meññ gydo lo ṟegioṉ-Judea no ni rluu me. Guzlo me lo ṟegioṉ-Galilea no glo bydzihñ me xtâ neꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ru bieññ Pilat ni rquee yâme riedz la, were günabdiidz me bâḻ meññ-Galilea we Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","No hor-gunn me we naꞌ, meññ-Galilea Jesúz, were ptzoo me mdad pshahl yâme leeme lo Herody, porni leeme rtzoo mdad Galilea. No leññ dze-wé yahc nu Herody Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Byxihly Herody hor-bwieꞌ me Jesúz‑e naꞌ, porni ba bieññ me bie meññ diidz de leeme, no ba xtze riuꞌladzy me güieꞌ me ctzoo Jesúz behch ni ngann ni nunzy Dioz beeiy rtzoo. ");
INSERT INTO zpg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","No gyrehzy günabdiidz me lee, per ba mbehty di nnii Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Uga dxie xjefy yahc bahl no muextr ni ruuḻ yahc xleiy Moiséz, gyrehzy ganii yâme contr leeme par di gylaa me. ");
INSERT INTO zpg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Guzlo Herody no gahc xsoldad me güdeḻy yâme Jesúz gyrehzy mód, no lehdy ptzuburl yâme leeme bguhtz yâme leeme to lahr mod-ruhtz ṟeiy. No luxu, pshahl me Jesúz lo Pilat gyzac. ");
INSERT INTO zpg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","No xtâ dze-wé ba guhc Herody mígü no Pilat; antzy rdziadzyno saꞌ yâme we. ");
INSERT INTO zpg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Were ptohp Pilat gyre xjefy yahc bahl, no meññ-nac guxtisy, no meññ-guiedzy, ");
INSERT INTO zpg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ra me lee: ―Bidno laꞌd mpyquie-rieꞌ neꞌ, ne laꞌd gachaḻ me xguîlriehñ meññ. Per günabdiidzaꞌ leeme ñaz-lo laꞌd, no ba bwieꞌ laꞌd nehx bydzialaꞌ mbehty doḻ lguia me mod-ne laꞌd nac me. ");
INSERT INTO zpg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","No zegahcu Herody nehx bydzial mbehty doḻ lguia me. Leewe bidzguiat leeme dlo nó gyzac. Mpyquie-rieꞌ nehx nu doḻ chehsh me par gaty me. ");
INSERT INTO zpg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ctzon mdad gydihñ me, no luxu, guislaan leeme. ");
INSERT INTO zpg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","No gyre ihz lo lni-Pascü rahp Pilat de ni guislaa me to meññ ni ndaagü lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Per lo hor-wé, guzlo gyre yâme gaquee riedz, ne: ―¡Ptzoo mdad gaty me, no bislaa Barrabáz! ");
INSERT INTO zpg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabáz naꞌ, psaagü yâme leeme lidzyguiib, porni pquihly me meññ byruu contr guxtisy, no bgaꞌdy me meññ. ");
INSERT INTO zpg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gyzac günino Pilat leeyâme sto, porni gucladzy me nislaa me Jesúz; ");
INSERT INTO zpg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","per leeyâme naꞌ ma rahc yâme gaquee yâme riedz, ne yâme: ―¡Pquee leeme lo cruzy! ¡Pquee leeme lo cruzy! ");
INSERT INTO zpg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Gyzac ra Pilat leeyâme ni bionn vuelt: ―¿Per bia ni dirquihñ ptzoo me? Naa nehx rdzialaꞌ mbehty doḻ lguia me par gaty me. Beeiydí, ctzon mdad gydihñ me, no luxu guislaan leeme. ");
INSERT INTO zpg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per leeyâme, aaḻ ma rquee yâme riedz, ne yâme yqueꞌ me lo cruzy. No mod-wé xtâ glo pquihly yâme Pilat gacu mod-ne yâme no mod-ne xjefy yahc bahl. ");
INSERT INTO zpg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","“Yo” ne Pilat, bzoob xtiidz yâme. ");
INSERT INTO zpg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","No mod-wé bislaa Pilat mpyquie-dirquihñ ni nu lidzyguiib ni pquihly meññ byruu contr guxtisy xtâ no bgaꞌdy, porni leeme günab yâme gylaa. No Jesúz, wé bdee me lee lehdy guhcu mod-racladzy yâme. ");
INSERT INTO zpg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ru ziyno yâme Jesúz par yquee yâme leeme lo cruzy, günahzy yâme to meññ-Ciren ni le Simóṉ, lóhgni byruu me dahñ. Bguu yâme leeme cruzy ni yqueꞌ Jesúz lo, no náḻ me chehsh gahc Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","No náḻ xtahl meññ Jesúz, no meññ-ngünaa náḻ gayuun yahc lé rquee yâme riedz por xroꞌ guîlrioob. ");
INSERT INTO zpg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","No bidzguiat lo Jesúz, bwieꞌ me leeyâme, no ra me: ―Ngüna-Jerusaléṉ, di ruun laꞌd por naa. Lâ guun por laꞌd gahc no por xiiñ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porni ziaad dzé ni ga meññ: “Dxu ñahc beeiy ngünaa yahc ni di raḻ gap xiiñ, no ni ngünaxtohby lee, no ni nehx güdahp mdoo par ñadzy.” ");
INSERT INTO zpg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","No hor-caḻ ga meññ dañ-roob yahc: “Lâ gyxaꞌd noꞌ”; no ga yâme dañ-wiñ yahc: “Lâ iguhtz yu noꞌ.” ");
INSERT INTO zpg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bâḻ mod-rieꞌ gatzoo yâme naa, ni zidguiahc beeiy yag-yeꞌ, ¡lê dxiclé laꞌd ni zidguiahc beeiy yag-bihdzy! ");
INSERT INTO zpg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","No ziyno yâme chohp meññ-ptzoo ni dirquihñ lehdy gaty yâme tohzy no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ru bydzihñ yâme ru le Xilgar Calaver, pquee yâme Jesúz lo cruzy, no zegahc pquee yâme gyrop meññ-ptzoo ni dirquihñ lo zrieñ cruzy coo ru queꞌ Jesúz, to me lad-drech no sto me lad-ṟevez. ");
INSERT INTO zpg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Were günino Jesúz Dioz, ra me lee: ―Dad, psiaaḻladzyiꞌ xguîlquie yâme. Porni nehx nann yâme bia gatzoo yâme. No luxu, güdiiz soldad yahc shab Jesúz, güloo yâme suert lehdy bwieꞌ yâme dxu xlad guiaꞌn cad tohbyu. ");
INSERT INTO zpg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bydzeꞌ meññ uga ni gawieꞌ. Zu guxtisy yahc gawieꞌ no gatzuburl yâme leeme, ne yâme: ―Zrieñ meññ bislaa me lee. Naꞌ guislaa me leegahcme, güieꞌ nó bâḻ uliu leeme Crist, ni güle Dioz lee. ");
INSERT INTO zpg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Gübigy soldad yahc gatzuburl leeme zegahc, gadee yâme vinagyr goo me. ");
INSERT INTO zpg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","No ra yâme leeme: ―Bâḻ xṞeiy meññ-Isṟael lii, bislaa lii gahc. ");
INSERT INTO zpg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","No ihqy cruzy ru queꞌ me lo, queꞌ letrer ni güyaa no didz-griegü, latíṉ, no didz-hebreu, ne: NIRIEꞌ WE XṞEIY MEÑÑ-ISṞAEL. ");
INSERT INTO zpg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Günii to meññ-ptzoo ni dirquihñ ni queno me lee, ra leeme: ―Bâḻ uliu Crist lii, pchuꞌ lii gahc de ru queꞌy, no pchuꞌ noꞌ zegahc. ");
INSERT INTO zpg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Were güdeḻy sto zâ-meññ-dirquihñ me, ra leeme: ―Di rdzie dxiꞌy Dioz‑e, rwiehguiꞌ tohzy ru quee nó no leeme lehdy gaty nó. ");
INSERT INTO zpg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nó quee nó neꞌ porni rahp nó doḻ, no leewe gaguix nóu neꞌ. Per mpyquie-rieꞌ nehx ptzoo me mbehty ni dirquihñ. ");
INSERT INTO zpg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","No luxu, ra me: ―Jesúz, guitsêlohdyu lii de naa dze-sulo ctzooy mdad. ");
INSERT INTO zpg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ra Jesúz leeme: ―Gapyaꞌ lii ni uli: Dzêrieꞌ gahc‑e tzuy no naa to ru mos. ");
INSERT INTO zpg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Beeiy ribygue, güyuꞌ guibcawy gydo lo guiedzylie no xtâ las-trez udzie, ");
INSERT INTO zpg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","porni gucncawy lo ncübidz; no bygaax lar-rsaagü glaꞌy idoró, byruuw chohp laꞌy. ");
INSERT INTO zpg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Lo gahc hor-caḻ pquee Jesúz riedz, ne me: ―Dad, lo ñay‑e rsanaꞌ dguîlmbahñaꞌ. No günihzy me ze, guhty gahc me. ");
INSERT INTO zpg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hor-bwieꞌ capitaṉ-ṟoman gyre niwé yahc, güluguia me Dioz, ne me: ―Uli gahcxu we, mpyquie-rieꞌ meññ-tziaawy-e leeme. ");
INSERT INTO zpg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","No ru ba bwieꞌ gyre meññ de ni ba guhty Jesúz no gyre ni guhc hor-guhty me, were zia yâme lé rbihby lidzydoo yâme. ");
INSERT INTO zpg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Per meññ-rzaclo me lee no zrieñ meññ-ngünaa ni náḻ leeme dze-byruu yâme lo ṟegioṉ-Galilea, zu yâme ziht gá, gawieꞌ yâme ni gayahc. ");
INSERT INTO zpg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Güyuꞌ to mpyquie ni le José, xguiedzy me le Arimatea, nuw lo ṟegioṉ-Judea, no rahc cuent leeme lahd xjefy meññ-Isṟael. Meññ-tziaawy leeme no rtzoo me ni nac xñahzû. ");
INSERT INTO zpg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mpyquie-rieꞌ naꞌ, zegahc gabiahz me gydzihñ de ni rtzoo Dioz mdad, no nehx biuꞌladzy me mod-ptzoo zrieñ jefy yahc diidz, ni mod-ptzoo yâme. ");
INSERT INTO zpg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Leeme güya bignab gdee Pilat lgar glety me xcuerp Jesúz lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bylux gülety me Jesúz, pchaḻ me lee lahr no biycaꞌdzy me lee leññ to baa ni bydahñ coo to guielaꞌ, ru dgueññ ziaꞌ igaꞌdzy ndruhty. ");
INSERT INTO zpg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nirieꞌ guhcu dze-rzaa yâme gyre ni yquihñ dze-risladzy yâme, ni ba sulo. ");
INSERT INTO zpg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","No meññ-ngünaa ni byruu tohzy no leeme lo ṟegioṉ-Galilea, güya yâme zegahc, bwieꞌ yâme ru nash ba-wé no bia mód bygaꞌdzy Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Byluxu, gubyguiat yâme ruꞌ yuꞌ, bistziaawy yâme ceitnixye no zrieñ ni nixye. No luxu, güdahp yâme dze-risladzy meññ, mod-ne leiy. ");
INSERT INTO zpg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Primer xdzé seman, lé rsilydoo, güya ngüna-caḻ yahc ruꞌ xbaa Jesúz, güiyno yâme ceitnixye ni bistziaawy yâme; no ziyno yâme zrieñ meññ-ngünaa. ");
INSERT INTO zpg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hor-bydzihñ yâme, bwieꞌ yâme guie-ro ni nyagü ruꞌ baa, ba nehx zuw xilgaru; ");
INSERT INTO zpg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","no güyuꞌ yâme leññ baa, per ba nehx nash xcuerp Jesúz uga. ");
INSERT INTO zpg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ba di rdzial bia ctzoo yâme lo hor-wé. Tohzy bwieꞌ yâme zu chohp mpyquie uga, rzaagy shab. ");
INSERT INTO zpg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gumm gadzie yâme la, byruꞌñ yâme, di ne yâme glesy lo. Ra mpyquie-caḻ leeyâme: ―¿Bia nacu ryo laꞌd meññ-mbahñ ru rgaꞌdzy mînguty? ");
INSERT INTO zpg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nehx nu me neꞌ; leeme ba gübahñ. Lâ guitsêlou laꞌd ni günii me dze-güyuꞌ me no laꞌd lo ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tzcaḻ ne me rahp meññ-guîlquie de ni gynahzy yâme Mpyquie-Pshahl Dioz Lee, no squee yâme leeme lo cruzy, per lo tzonn dzé gybahñ me. ");
INSERT INTO zpg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Were, bitsêlou leeyâme ni günii Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Luxu, byruu yâme de ruꞌ baa, no bigyuno yâme gyre ni guhc lo gydiby tzipyto apóstl yahc no zrieñ xmeññ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Meññ-ngünaa naꞌ ni bigyne apóstl yahc, leeyâme we nirieꞌ: Maríe-Magdalen, Juan, Maríe xmam Jacob, no zrieñ meññ-ngünaa. ");
INSERT INTO zpg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Per di nlíladzy apóstl ni ra meññ-ngünaa leeyâme, porni rluuw cuentz nac ganii yâme. ");
INSERT INTO zpg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Per Pedr naꞌ za-güxuunn me, zigüieꞌ me ruꞌ baa. Bydzihñ me, güdishlo gahc me leññ baa, bwieꞌ me nash lahr diby lad. Luxu, gubyguiat me zia me ruꞌ yuꞌ, nu ihqy me bia guhc no xcuerp Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dze-wé gahc za chohp de lahd xmeññ Jesúz to guiedzy ni le Emaúz, beeiy tzipyto kilómetr rahpu de Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Za yâme, gayu yâme diidz de gyre ni guhc. ");
INSERT INTO zpg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Lóni za yâme gayu yâme diidz, biygahl Jesúz leeyâme par za me tohzy no leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nîcze gawiehg yâme leeme, per di ndee Dioz lsenzy nzaclo gahc yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Were ra Jesúz leeyâme: ―¿Bia leeu ni gayu laꞌd ziaad laꞌd, no bia nacu neññ nu laꞌd trixd? ");
INSERT INTO zpg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Were ra mpyquie-le Cleofas leeme: ―De lahd gyre meññ-mbiuhz ni bydzihñ Jerusaléṉ, ¿nunzy lii nehx nann ni guhc uga leññ dze-rieꞌ yahc la? ");
INSERT INTO zpg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Were ra me: ―¿Bia leeu ni guhc? Ra yâme leeme: ―Gayu noꞌ ni guhc to mpyquie ni le Jesúz ni nac meññ-Nasaret. Leeme we to profet ni beeiyu lee gyreu, no günii me no ptzoo me pur ni rsahc ñaz-lo Dioz no ñaz-lo meññ. ");
INSERT INTO zpg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","No gayu noꞌ mod-ptzoo xjefy yahc bahl leeme no gahc dguxtisy noꞌ, bdee yâme leeme lo ña meññ-biꞌdy leeme, no pquee yâme leeme lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Noꞌ dxi ne noꞌ leeme we ni gyla meññ-Isṟael. No dzêrieꞌ ba rahp tzonn dzé ni guhty me. ");
INSERT INTO zpg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","No rtzunadz noꞌ, porni güya meññ-ngünaa ni nu dlahd noꞌ ruꞌ baa nga-rsily; ");
INSERT INTO zpg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bydzihñ yâme, bwieꞌ yâme nehx nash xcuerp me leññ baa. Were biahd yâme, bidne yâme noꞌ, no ne yâme bwieꞌ yâme ángel yahc ni ra leeyâme: “Jesúz mbahñ.” ");
INSERT INTO zpg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Were gyzac güya dlahd noꞌ bigüieꞌ ru bygaꞌdzy me. Bydzihñ yâme, bwieꞌ yâme uliu mod-ne meññ-ngünaa, per nehx bwieꞌ yâme xcuerp Jesúz. ");
INSERT INTO zpg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Were ra Jesúz leeyâme: ―¡Modni nwaty laꞌd no uxiee rieññ laꞌd par gylíladzy laꞌd gyre ni günii profet yahc ba xtze! ");
INSERT INTO zpg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ne laꞌd nehx güdahp Crist de ni tedy me gyre niwé, no were tzu me ru mos ru tirg riuguia me la? ");
INSERT INTO zpg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","No guzlo gayu me ni ziaad lo Guehtzy ru queꞌ xtiidz Dioz, ni ganii de leegahcme. Guzlo me nier ni queꞌ lo guehtzy ni bzaa Moiséz, no luxu bie me ni queꞌ lo guetzy-bzaa zrieñ profet ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bydzihñ yâme guiedzy ru za yâme we naꞌ, ptzoo Jesúz beeiy ni tedyñahz gahc. ");
INSERT INTO zpg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Were ptzunñaad yâme, ra yâme leeme: ―Bian-no noꞌ. Ba udzie, no ba casy gayuꞌ guiaaḻ. Were güyuꞌ Jesúz leññ yuꞌ, biaꞌn me no leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ru ba dxie yâme ruꞌ miax‑e naꞌ, cuaꞌ me paṉ lo ña me, gülulaꞌy meu no güdiiz meu, cuaꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lo hor-wé, guhc yâme beeiy ni byxal lo, no were bzaclo yâme leeme. Per hor-wé bynitylo gahcme ba di nwieꞌr yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","No ra saꞌ yâme: ―¡Yalxu we xtiidz me lé rsiahnu leññ dguîlmbahñ nó lóni zioꞌb nó lo ñahz, ganii me de ni ziaad lo Guehtzy ru queꞌ xtiidz Dioz no gaboxñahz me leeu dlo nó! ");
INSERT INTO zpg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","No ba di nlee yâme mazy, gubyguiat gahc yâme Jerusaléṉ gyzac. Bydzihñ yâme, nu gydiby tzipyto apóstl yahc no zrieñ meññ-rman ni bydohp yahc tohzy lgar. ");
INSERT INTO zpg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ra yâme meññ-leer byruu lo ñaz-ria Emaúz: ―¡Uliu gübahñ Señor ni rtzoo mdad! Simóṉ ba bwieꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","No bie yâme ni guhc yâme lo ñahz zegahc, no güdiizr me paṉ, were bzaclo yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ganii ziaꞌ yâme ze, tohzy bydzihñ Jesúz lahd yâme, no günii me diux, ra me leeyâme: ―Tzu xguîlmbahñ laꞌd dzie tziaawy. ");
INSERT INTO zpg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aaḻ bydzie yâme. Nlâdzyx yâme xguiaḻ meññ‑e gawieꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Were günii Jesúz, ra leeyâme: ―¿Bia nacu rdzie laꞌd, no bia nacu gyrehzy rzaꞌladzy laꞌd? ");
INSERT INTO zpg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lâ güieꞌ ru güyaaz clav dñan no dnien. Naa gahc‑e. Lâ can naa no lâ güieꞌ. To xguiaḻ meññ nehx rahp dziht ni biahl, mod-rwieꞌ laꞌd rapaꞌnu. ");
INSERT INTO zpg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bylux günii me ze, bluu me leeyâme ña me no nieꞌ me ru güyaaz clav. ");
INSERT INTO zpg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Per leeyâme naꞌ, tant gaxihly yâme no gatzunadz yâme, ba lé di raḻ gylíladzy yâme ni gawieꞌ yâme. Were ra Jesúz leeyâme: ―¿Rahp laꞌd behch neꞌ par ñahgü mu la? ");
INSERT INTO zpg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Were bdee yâme leeme diby laꞌy mbaḻ ni bygueꞌ no diby laꞌy xguiaht macer ni rahp dziñ. ");
INSERT INTO zpg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Were cuaꞌ meu, no güdahgü meu ñaz-lo gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","No ra me: ―Ni guhcaꞌ la, lee we ni ren laꞌd dze-nun no laꞌd: Gutzyaꞌ laꞌd gyre ni ganii de naa ni queꞌ lo xleiy Moiséz no ni queꞌ lo guehtzy ni bzaa zrieñ profet no ni ziaad lo libr-Salm, rahpu de ni gac mod-neu. ");
INSERT INTO zpg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","No were pshal me xguîlriehñ xmeññ me par bieññ yâme ni ganii lo Guehtzy ru queꞌ xtiidz Dioz, ");
INSERT INTO zpg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","no ra me: ―Ze we queꞌ lo Guehtzy, rahp Crist de ni gaty, no lo ni rionn dzé gybahñ me sto, ");
INSERT INTO zpg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","no cshahl me dxu tza dzigyuno meññ yahc diidz de leeme par csaan yâme ni nahcsy ni nac yâme lehdy csiaaḻladzy Dioz xguîlquie yâme. No sulo xtiidz me Jerusaléṉ no xtâ glo iguw gydo lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Laꞌd‑e beeiy gu leeu zaꞌgndzi, porni bwieꞌ laꞌd gyreu. ");
INSERT INTO zpg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","No naa sshaalaꞌ ni bdee xtiidz dTadaꞌ par guiaad tzu no laꞌd. Per cuiahz laꞌd, tzu laꞌd neꞌ gahc ciuda-Jerusaléṉ, ycaꞌr laꞌd ni gacno laꞌd ni gyruu gybaa lehdy beeiy ctzoo laꞌd xroꞌ cos, were beeiy gyruu laꞌd de neꞌ. ");
INSERT INTO zpg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Luxu, byruno Jesúz leeyâme Jerusaléṉ, no güiyno me leeyâme Betania. Bydzihñ yâme uga, gülesy ña Jesúz lehdy cu me laꞌy leeyâme. ");
INSERT INTO zpg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lóni gaguꞌ me laꞌy leeyâme, biahs me zia me gybaa. ");
INSERT INTO zpg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bylux bzacbeeiy yâme leeme, gubyguiat yâme Jerusaléṉ no to guîlrxihly ni modni xroꞌ; ");
INSERT INTO zpg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","no xtâ tzcaḻ tirg ria yâme idoró, rigzacbeeiy yâme Dioz, no rguguia yâme leeme. Modé gacu.");
INSERT INTO zpg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dze-guzlo Dioz bzaa me guiedzylie, ba gahc nu ni le Diidz, no nu me no Dioz, no Dioz gahc‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","No dze-güyaa guiedzylie ba gahc nu me no Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","No por leegahcme bzaa Dioz gyre ni nu, no ñahcu dac por leeme, nehx ñuꞌ mbehty ni ba nu. ");
INSERT INTO zpg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ladzyña me nu guîlmbahñ, no guîlmbañ-rieꞌ nacu beeiy byniꞌ par gyre meññ. ");
INSERT INTO zpg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Byni-rieꞌ naꞌ, rdalgueu beeiy lo guibcawy, no ni nac beeiy guibcawy di raḻ csiee leeu. ");
INSERT INTO zpg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Güyuꞌ to mpyquie ni pshahl Dioz lee, ni le Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Biahd me lehdy gynii me no gdee me diidz dxu lee nac beeiy byniꞌ, lehdy gyre meññ gylíladzy de dxu ganii Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dac‑e Juaṉ nac beeiy byniꞌ, mazyg biahd me lehdy gdee me diidz dxu lee nac beeiy byniꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","No ni ulihbu lee nac byni-rieꞌ, ziaad me lo guiedzylie, zidno me guîlbyniꞌ par gyre meññ. ");
INSERT INTO zpg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Leegahcme ni le Diidz, biahd me lo guiedzylie; no nîcze por leegahcme güyaa guiedzylie, per meññ-nu lo guiedzylie nehx bzaclo leeme. ");
INSERT INTO zpg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Biahd me lahd meññ-xguiedzy me, per meññ-xguiedzy me nehx bylaby leeme. ");
INSERT INTO zpg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Per gyre meññ ni cuaꞌ xtiidz me xtâ leññ xguîlmbahñ no bylíladzy leeme, ptzoo me leeyahc xiiñ Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","No meññ-rieꞌ yahc nehx guhl yâme mod-rahl meññ-nu lo guiedzylie, ni dac mod-rahp meññ xiiñ, ni dac porni to mpyquie biuꞌladzy gacu ze, mazyg Dioz ne gac yâme xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","No leegahcme ni le Diidz, guhl me lo guiedzylie no güyuꞌ me dlahd noꞌ, no nu laꞌy leeme, no ptzoo me pur ni nac ni uli. No bwieꞌ noꞌ xguîlbyniꞌ me ni neññ leeme we nac Xiñ-ngahc Dioz ni nac xTad me lee. ");
INSERT INTO zpg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juaṉ bdee diidz de leeme, no ne: ―De leeme we ni ren hor-günin: “Nu sto ni guiaad lux de ni biaḻaꞌ ni ma rsahc que naa, porni ba gahc nu me ma xtze diaa antzy que naa.” ");
INSERT INTO zpg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","De gyre ni xroꞌ ni mos ni nu no Dioz cuaꞌ nó gyre nó, no nehx rsandzie ni rguꞌ xlaꞌy me nó. ");
INSERT INTO zpg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dioz pshahl me leiy no Moiséz, per xlaꞌy Dioz no ni nac ni uli, bidno Jesucrist leeyahcu. ");
INSERT INTO zpg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nehx nu ndruhty ba bwieꞌ Dioz ni to; mazyg Xiñ-ngahc me, ni nu tohzy no leeme, wé we bluu nó dxu we leeme. ");
INSERT INTO zpg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nirieꞌ we diidz ni bdee Juaṉ, dze-meññ-Isṟael ni rtzoo yahc mdad pshahl yâme lahd bahl tohzy no meññ-nac levit ni nu Jerusaléṉ, bignabdiidz yâme leeme, ra yâme: ―¿Dxu we lii? ");
INSERT INTO zpg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nehx pcaꞌdzy Juaṉ, ra me leeyâme: ―Dac‑e naa nac Crist. ");
INSERT INTO zpg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Zegahc günabdiidz yâme, ra yâme leeme: ―¿Dxuz‑e lii? ¿Lii we profet-Elíaz la? Ra Juaṉ leeyâme: ―Dac‑e naa. Gyzac ra yâme leeme: ―¿Lii we profet ni gabiaaz noꞌ guiaad la? Ra me: ―Yac. ");
INSERT INTO zpg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ra yâme leeme: ―¿Dxuz‑e naꞌ lii? Rahp noꞌ de ni tziyno noꞌ diidz lo meññ-pshahl noꞌ. ¿Bia neꞌy de lii gahc? ");
INSERT INTO zpg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Were ra Juaṉ leeyâme: ―Naa we to meññ ni rquee riedz lo yu-bihdzy, ne: “Lâ cshal xguîlmbahñ laꞌd beeiy rxal to ñaz-ndohp par dze-guiaad Señor”, ―mod-günii profet-Isaíaz ba xtze. ");
INSERT INTO zpg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Meññ-bignabdiidz Juaṉ, meññ-nac yahc fariseu we pshahl leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","No günabdiidz yâme, ra yâme leeme: ―¿Biaz nacu rchôbnihsiꞌ meññ bâḻ dac lii nac Crist, ni profet-Elíaz, ni profet ni gabiaaz noꞌ guiaad? ");
INSERT INTO zpg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ra Juaṉ leeyâme: ―Naa rchôbnisaꞌ meññ no nzeꞌ, per lahd gahc laꞌd nu to ni nehx rzaclo laꞌd dxu lee. ");
INSERT INTO zpg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Leeme we guiaad lux de ni biaḻaꞌ. Leeme ma rsahc me que naa, per ni xduu xguidguial me nehx rsahcaꞌ par nshacaꞌu. ");
INSERT INTO zpg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nirieꞌ guhcu to guiedzy ru le Betania ni nu stiby chehsh guiagü-Jordáṉ, ñaz-ru rlahñ ncübidz, ru gachôbnihs Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ni byre guiaal bwieꞌ Juaṉ ziaad Jesúz gadziñgahsh leeme, no günii Juaṉ, ne me: ―¡Lâ güieꞌ mpyquie-rieꞌ, leeme we Xiily ni rdee Dioz, wé rboo xguîlquie meññ-nu lo guiedzylie! ");
INSERT INTO zpg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","De leeme we günin: “Dze-ba bylux biaḻaꞌ guiaad sto mpyquie ni ma rsahc que naa, porni ba gahc nu me ma xtze diaa antzy que naa.” ");
INSERT INTO zpg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Naa nehx bzacloꞌn leeme; per biaḻaꞌ gachôbnisaꞌ meññ no nzeꞌ lehdy gzaclo meññ-Isṟael leeme. ");
INSERT INTO zpg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","No zegahc bdee Juaṉ diidz, ra me: ―Bwien byruu Spirt-Sant gybaa beeiy to palom ni biaht no biaꞌn lguia Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nehx bzacloꞌn leeme, per Dioz ni pshahl naa zidchôbnisaꞌ meññ no nzeꞌ, ra naa: “Dxu güieꞌy guiaht diSpirtaꞌ lguia, wé we ni gdee Spirt-Sant beeiy to guîlrrôbnihs.” ");
INSERT INTO zpg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naa bwien, no rdedyaꞌ diidz leeme we Xiiñ Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ni byre guiaal, gyzac zu Juaṉ uga no chohp de lahd xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hor-bwieꞌ Juaṉ gadedy Jesúz, ra me: ―¡Lâ güieꞌ mpyquie-rieꞌ, leeme we Xiily ni rdee Dioz! ");
INSERT INTO zpg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Niwé bieññ gyrop xmeññ Juaṉ, náḻ gahc yâme ru za Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bidzguiat lo Jesúz, bwieꞌ me náḻ chohp xmeññ Juaṉ leeme, ra me leeyahc: ―¿Bia gayo laꞌd? Ra yâme leeme: ―Muextr, ¿bá glo nuy? ");
INSERT INTO zpg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ra Jesúz leeyâme: ―Lâ te lehdy güieꞌ laꞌd. Were güya gahc yâme no gunn yâme bá glo nu Jesúz, no biaꞌn yâme no leeme dze-caḻ, porni ba udzie, ba beeiy las-cuatr. ");
INSERT INTO zpg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","De lo gyrop meññ-bieññ ni günii Juaṉ, no ni za yahc ru za Jesúz, to me le Ndréz, behtzy Simoṉ-Pedr. ");
INSERT INTO zpg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ndréz, nier bigyo me behtzy me Simóṉ, no ra me lee: ―Bydzial noꞌ dxu lee nac Mesíaz ―ni rnii neu, ni nac Crist. ");
INSERT INTO zpg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","No Ndréz ziyno gahc me Simóṉ ru nu Jesúz. Ru bwieꞌ Jesúz Simóṉ, ra me lee: ―Lii we Simóṉ, xiiñ Jonáz, per tzu ley Cefas ―ni rnii neu, Pedr. ");
INSERT INTO zpg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ni byre guiaal biuꞌladzy Jesúz za me lo ṟegioṉ-Galilea, no uga bydzial me Felipy, no ra me lee: ―Náḻiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipy naꞌ, meññ-Betsaida leeme, ru nac gahc xguiedzy Ndréz no Simóṉ. ");
INSERT INTO zpg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipy bigyo me Natanael, no ra me lee: ―Bydzial noꞌ to meññ ni de lee bzaa Moiséz lo guehtzy ru queꞌ leiy, no ni de lee bzaa profet yahc. Leeme le Jesúz, xiiñ José ni nu guiedzy-Nasaret. ");
INSERT INTO zpg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ra Natanael leeme: ―¿Nehxni beeiy nruu meññ-tziaawy Nasaret? Ra Felipy Natanael: ―Güde lehdy güieꞌy. ");
INSERT INTO zpg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ru bwieꞌ Jesúz gadziñgahsh Natanael leeme, ne me: ―Neꞌ ziaad to ni ulihbu meññ-Isṟael lee ni nehx nu guîlrisquiee no lee. ");
INSERT INTO zpg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Were ra Natanael Jesúz: ―¿Bia mód rzacloꞌy ni nacaꞌ? Ra Jesúz leeme: ―Antzy ni dzigyo Felipy lii, bwien lii xán yag-duug. ");
INSERT INTO zpg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ra Natanael Jesúz: ―Muextr, lii we Xiiñ Dioz; lii we xṞeiy meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ra Jesúz leeme: ―¿Rlíladzyiꞌ naa nunzy porni ren bwien lii xán yag-duug la? Zrieñ ni ma xroꞌ we zwieꞌy que niwé. ");
INSERT INTO zpg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Zegahc ra me lee: ―Naa we Mpyquie-Pshahl Dioz Lee, no gapyaꞌ laꞌd ni uli, zwieꞌ laꞌd gybaa nxalu, no x‑ángel yahc Dioz riehpy no riaht ru zuun. ");
INSERT INTO zpg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ni bionn dzé guhc guîltziahl to guiedzy ni le Caná ni nu lo ṟegioṉ-Galilea, no xmam Jesúz zu me uga ru gayahc guîltziahl. ");
INSERT INTO zpg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Zegahc psieññ yâme Jesúz no xmeññ, no güya yâme lo guîltziahl. ");
INSERT INTO zpg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hor-ba byre vin, ra xmam Jesúz leeme: ―Ba byre vin ni rahp yâme. ");
INSERT INTO zpg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ra Jesúz leeme: ―Mam, ¿bia nacu gayahbyiꞌu naa? Dgueññ ziaꞌ gydzihñ dzé ni ctzon ni ba nac diidz. ");
INSERT INTO zpg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Were ra xmam me meññ-gayacno yahc: ―Lâ ctzoo nitisy ga me laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Zu shoꞌb guiuhs uga ni güyaa de guie ni riuꞌ nzeꞌ leññ, ni rquihñ meññ-Isṟael lee par gacnyar yâme lehdy guiaꞌn yâme nye lo Dioz mod-rtzoo gahc yâme xtâ ba xtze diaa; no to to guiuhs riuꞌ beeiy ochent o diby gayuu litr nzeꞌ leññu. ");
INSERT INTO zpg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ra Jesúz meññ-gayacno yahc: ―Lâ guistzee guius-wé yahc no nzeꞌ. Were bistzee yâme leeyahcu. ");
INSERT INTO zpg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Luxu ra Jesúz leeyâme: ―Lâ gboo doozyu, lâ tziyno ycaꞌ meññ-nu xcargü lni. No ze ptzoo yâme. ");
INSERT INTO zpg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Meññ-nu xcargü lni güee doozy nze-rieꞌ ni ba guhc vin, no nehx nann me bá byruuw; nunzy mós ni gayacno nann bá byruuw, porni leeyâme güloou leññ guiuhs. Were meññ-nu xcargü lni pquee me riedz ñoby-gayidzña, ");
INSERT INTO zpg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ra me lee: ―To lo lni gyre meññ nier vin-ma mos rdee yâme roo meññ, no hor-ba güee yâme xtahl, were ba rdee yâme vin-nehx byruqueꞌ mos. No lii naꞌ, gülutziaawyiꞌ vin-ma mos xtâ hôrrieꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nirieꞌ ni ptzoo Jesúz guiedzy-Caná lo ṟegioṉ-Galilea, wé we ni ngann ni nier lee ptzoo me, no wé guzlo rwieꞌ meññ xroꞌ ni rtzoo me; no xmeññ me bylíladzy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bylux nirieꞌ za Jesúz guiedzy ni le Capernaum no xmam me, no meññ-behtzy me, no zrieñ xmeññ me; no güyuꞌ yâme uga doozy dzé. ");
INSERT INTO zpg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ba zidgahsh lni-Pascü ni rtzoo meññ-Isṟael, leewe Jesúz güya me Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","No leññ idoró, bwieꞌ me meññ ni gatoꞌ bueiy, xiily, no ximbue, no meññ-dxie yahc ruꞌ miax ni gatzee xmedy meññ. ");
INSERT INTO zpg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Were cuaꞌ me duu, psiuꞌg meu no gachaḻ meu, güloo me gyre meññ-caḻ yahc stziuꞌ de idoró no xshiily yâme no xbueiy yâme; no meññ-rtzee yahc medy, pchaꞌdz me xmedy yâme zegahc, no ptiꞌx me xmiax yahc yâme. ");
INSERT INTO zpg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","No ra me meññ ni gatoꞌ ximbue: ―¡Lâ gboo gyre nirieꞌ neꞌ! ¡Di ctzoo laꞌd xiryuꞌ dTadaꞌ to yu-lóguiaꞌ! ");
INSERT INTO zpg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Were bitsêlou xmeññ me ni rnii lo Guehtzy ru queꞌ xtiidz Dioz, ru neu: “Tant racdadzyaꞌ gacnda xiryuꞌy, lé zidguiahcu beeiy gue ni rdzuu dguîlmbahñaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ra meññ-Isṟael leeme ni rtzoo mdad: ―¿Bia ni ngann ctzooy lehdy gann noꞌ dxu naquiꞌ ctzooy gyre nirieꞌ? ");
INSERT INTO zpg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ra Jesúz leeyâme: ―Lâ iguiñguie idoro-rieꞌ, no leññ tzonn dzé ba bzan leeu sto. ");
INSERT INTO zpg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Were ra yâme leeme: ―Cuarentayseiz ihz guhc dziiñ par biahs ido-rieꞌ. ¿No lii neꞌy leññ tzonn dzé ba bzaay leeu sto la? ");
INSERT INTO zpg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per idoo de ni ganii Jesúz naꞌ, de xcuerp gahcme we ganii me. ");
INSERT INTO zpg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","No leewe, dze-gübahñ me de lahd mînguty, xmeññ me bitsêlou leeyâme nirieꞌ ni günii me, no bylíladzy yâme ni rnii lo Guehtzy ru queꞌ xtiidz Dioz, no zegahc bylíladzy yâme ni günii Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ru nu Jesúz Jerusaléṉ lo lni-Pascü ni rtzoo meññ-Isṟael, xtahl meññ bylíladzy leeme porni bwieꞌ yâme gatzoo me xtahl ni ngann. ");
INSERT INTO zpg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per Jesúz rqueꞌladzy leeyâme, porni rzaclo me ni nac gyre meññ. ");
INSERT INTO zpg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","No nehx rbiahz me ña ndruhty leeme ni nac cad to meññ, porni nann me ni nu leññ xguîlmbahñ meññ. ");
INSERT INTO zpg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Güyuꞌ to mpyquie-nac fariseu ni le Nicodem, no rsahc ni rnii me lahd gyre meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Güya me guiaal ru nu Jesúz, no ra me lee: ―Muextr, nann noꞌ Dioz pshahl lii guidluuy noꞌ, porni rtzooy xtahl ni ngann, no ndruhty nehx beeiy ntzoo leeyahcu bâḻ nehx nu Dioz no lee. ");
INSERT INTO zpg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ra Jesúz leeme: ―Gapyaꞌ lii ni uli, dxu di gahl gyzac, nehx beeiy tzu ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ra Nicodem leeme: ―Per ¿bia mód‑e ñahl to meññ gyzac no ba mînguhl lee? ¿Nehxni beeiy ñuꞌ me leññ xmam me sto no ñahl me gyzac? ");
INSERT INTO zpg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ra Jesúz leeme: ―Gapyaꞌ lii ni uli, dxu di gahl de nzeꞌ no de xiSpirt Dioz, nehx beeiy tzu ru rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ni gahl de meññ la, meññ gahc‑e lee; no dxu gahl de xiSpirt Dioz, spirt‑e lee. ");
INSERT INTO zpg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Di gzacnganniꞌ de ni ren lii: “Rahp meññ de ni gahl gyzac.” ");
INSERT INTO zpg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mbeꞌ rutisy rahcu rdedyu no rieññiꞌ xṟidu, per nehx nanniꞌ bá glo ziaadu o bá glo tzau. Mod-wé gahc zidguiahc gyre dxu gahl de xiSpirt Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Gyzac günabdiidz Nicodem, ra leeme: ―¿Bia mód beeiy ñahc nirieꞌ? ");
INSERT INTO zpg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ra Jesúz leeme: ―¿Lii naquiꞌ muextr-rsahc lahd meññ-Isṟael, no nehx rieññiꞌ nirieꞌ la? ");
INSERT INTO zpg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Gapyaꞌ lii ni uli, rnii noꞌ ni nann noꞌ, no rdee noꞌ diidz ni bwieꞌ noꞌ; per nehx rlíladzy laꞌd ni ra noꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bâḻ nehx rlíladzy laꞌd naa hor-runon laꞌd de ni nu lo guiedzylie-rieꞌ, ¿bia mód‑e nlíladzy laꞌd naa hor-runon laꞌd de ni nu gybaa? ");
INSERT INTO zpg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Nehx nu ndruhty ba güya gybaa, mazyg naa gahc, Mpyquie-Pshahl Dioz Lee ni byruu gybaa, no gybaa we dilgaraꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","No mod-gülesy Moiséz to xfigur mbaaḻ to lo yahg lo yu-bihdzy ba xtze, modé gahc‑e naa, Mpyquie-Pshahl Dioz Lee, rapaꞌ de ni guiasaꞌ, ");
INSERT INTO zpg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","lehdy gyre dxu gylíladzy naa, di znihty, mazyg gap me guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Porni ndzi Dioz meññ-nu lo guiedzylie, xtâ no bdee Xiñ-ngahc me, lehdy gyre dxu gylíladzy leeme, di znihty, mazyg gap guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dioz nehx pshahl Xiiñ me lo guiedzylie lehdy gniꞌdy me meññ lo xguîlquie, mazyg lehdy guislaa me meññ de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Dxu rlíladzy Xiiñ Dioz nehx znihty lo xguîlquie; per dxu nehx rlíladzy leeme, znihty lo xguîlquie, porni nehx rlíladzy me Xiñ-ngahc Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","No por nirieꞌ we gynihty meññ lo xguîlquie: porni biahd ni nac beeiy byniꞌ lo guiedzylie, per meññ aaḻ ma biuꞌladzy yâme ni nac beeiy guibcawy, no nehx biuꞌladzy yâme ni nac beeiy byniꞌ, porni rtzoo yâme ni nahcsy yahc. ");
INSERT INTO zpg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Gyre dxu rtzoo ni nahcsy néladzy me ni nac beeiy byniꞌ, no nehx rbigy me beeiy lo byniꞌ, lehdy ndruhty di zann ni rtzoo me. ");
INSERT INTO zpg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Per dxu rtzoo ni nac xñahzû rbigy beeiy lo byniꞌ, no modé neññ rtzoo me mod-racladzy Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bylux nirieꞌ, güya Jesúz no xmeññ me gydo lo ṟegioṉ-Judea, no bylee yâme uga, no gachôbnihs me meññ. ");
INSERT INTO zpg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juaṉ zegahc gachôbnihs me meññ to ru le Enóṉ, gahsh gá ru le Salim, porni Enóṉ nu nze-ro; no uga ria meññ rigyrôbnihs. ");
INSERT INTO zpg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nirieꞌ guhc dze-dgueññ ziaꞌ cu yâme Juaṉ lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Per lahd xmeññ Juaṉ guzlo gadeḻydiidz yâme no lahd meññ-Isṟael lguia ni racnyar meññ lehdy guiaꞌn yâme nye lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","No güya yâme, ra yâme Juaṉ: ―Muextr, mpyquie ni güya ru zuꞌy stiby chehsh guiagü-Jordáṉ, ni bdeedyiꞌ diidz de lee, gachôbnihs me, no gadohp gyre meññ leeme. ");
INSERT INTO zpg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ra Juaṉ leeyâme: ―Ndruhty nehx beeiy ntzoo zâ niwé bâḻ Dioz nehx ndee ñahz gacu. ");
INSERT INTO zpg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Laꞌd gahc beeiy gdee diidz ni günin dac‑e naa nac Crist, mazyg pshahl Dioz naa no biaḻaꞌ nier naa que leeme, lehdy gdedyaꞌ diidz de ni guiaad me. ");
INSERT INTO zpg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","To lo guîltziahl, ñoby-gayidzña dxie me coo ndzaꞌb ni gayidzña me lee; no xmígü me ni dxie, rieññ me rnii ñoby-gayidzña no modni rxihly me. No mod-wé gahc‑e, naa hôrrieꞌ ba gaxihlyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Racladzyu to to dzé qysahc me mazy, no naa gácaꞌ ma lwiñ. ");
INSERT INTO zpg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Dxu byruu gybaa ni pshahl Dioz lee, ma rsahc me que gyre meññ; no dxu nu lo guiedzylie, de lo gahc guiedzylie we lee, no rnii pur ni rahc lo guiedzylie. Per ni byruu gybaa, ma rsahc me que gyre meññ, ");
INSERT INTO zpg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","no rnii me ni bwieꞌ me no ni bieññ me, per ndruhty nehx rlíladzy ni runo me lee. ");
INSERT INTO zpg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Per dxu rlíladzy ni runo me lee, rdee diidz Dioz rnii ni uli; ");
INSERT INTO zpg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","porni dxu pshahl Dioz lee, xtiidz gahc Dioz‑e rnii, porni Dioz nehx rca me xiSpirt me par xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dioz ni nac dTad nó, ndzi me Xiiñ me, no bdee me lee de ni rtzoo Xiiñ me mdad gyre ni nu. ");
INSERT INTO zpg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dxu rlíladzy Xiiñ Dioz rahp guîlmbahñ ni nehx zluhx; per dxu nehx rlíladzy, nehx zahp me guîlmbañ-rieꞌ, mazyg nu guîlné chehsh me ni rshahl Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Bieññ meññ-nac yahc fariseu ma xtahl meññ gadohp Jesúz, no ma xtahl meññ gachôbnihs me que Juaṉ, ");
INSERT INTO zpg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","nîcze nehx Jesúz rchôbnihs, mazyg xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Hor-gunn Jesúz ni ganii meññ-nac yahc fariseu, byruu me ṟegioṉ-Judea, no gubyguiat me za me ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Lóni za me, nier güdedy me lo ṟegioṉ-Samary. ");
INSERT INTO zpg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","No bydzihñ me to guiedzy ni le Sicar, ni nu lo ṟegioṉ-Samary, gahsh gá to lyu ni biscady Jacop xiiñ me José. ");
INSERT INTO zpg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Uga nu to pos, rnii yâme leu xpos Jacop. No Jesúz bydzahg me de ni güzeꞌ me, no gürie me ruꞌ pos-wé, ba beeiy ribygue. ");
INSERT INTO zpg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Lo hor-wé bydzihñ to ngüna-samaritan zigloo me nzeꞌ, no ra Jesúz leeme: ―Bdee doozy xinzeꞌy goon. ");
INSERT INTO zpg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Xmeññ Jesúz naꞌ, za yâme leññ guiedzy zicshii yâme guîlrahgü. ");
INSERT INTO zpg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ra ngüna-samaritan Jesúz: ―¿Bia mód neꞌy gdedyaꞌ nzeꞌ lii, no naquiꞌ meññ-Isṟael, no naa nacaꞌ meññ-samaritan? (Porni meññ-Isṟael nehx rwieꞌ saꞌ yâme mos no meññ-samaritan.) ");
INSERT INTO zpg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ra Jesúz leeme: ―Bâḻ ñanniꞌ bia rdee Dioz, no bâḻ ñanniꞌ dxu we naa ni ganab nzeꞌ lii, lii we nnabiꞌyu naa, no naa ndedyaꞌ lii ni zidguiahc beeiy nzeꞌ ni rdee guîlmbahñ. ");
INSERT INTO zpg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ra ngüna-samaritan leeme: ―Señor, nehx nu bia no gbooyu, no guiat leññ pos. ¿Bá glo ncaꞌy nzeꞌ ni rdee guîlmbahñ ni ndeedyiꞌ naa? ");
INSERT INTO zpg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Dtadgul noꞌ Jacop ni güyuꞌ ba xtze, leeme we psan-no pos-rieꞌ noꞌ, no neꞌ gahc‑e cuaꞌ me nzeꞌ ni güee me, no ni güee xmiꞌñ me, no xnimal me zegahc. ¿Nehxni ma rsahquiꞌ que leeme? ");
INSERT INTO zpg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ra Jesúz leeme: ―Gyre dxu roo nze-rieꞌ, zibyguiat ssaagyladzy; ");
INSERT INTO zpg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","per dxu ñoo nzeꞌ ni gdedyaꞌ, nehx zibyguiat ssaagyladzy; porni leññ xguîlmbahñ me gdedyaꞌ ni zidguiahc beeiy nzeꞌ ni rda, no gacu guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ra ngüna-samaritan leeme: ―Señor, bdee naa nze-wé, lehdy di guibyguiat gyzaagydadzyaꞌ, no di guibyguiat guidloon nzeꞌ neꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ra Jesúz leeme: ―Güya, biycaꞌ tziahliꞌ, no guiaadiꞌ neꞌ gyzac. ");
INSERT INTO zpg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ra ngüna-caḻ leeme: ―Nehx rapaꞌ dtziaalaꞌ. Ra Jesúz leeme: ―Xñahzu we ni güniiy, nehx rahpiꞌ tziahliꞌ; ");
INSERT INTO zpg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","porni gaay mpyquie bidzñay no lee, no mpyquie ni dxienoy hôrrieꞌ, ba nehx bidzñay no lee; ni uli we ni güniiy. ");
INSERT INTO zpg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ra ngüna-caḻ leeme: ―Señor, zoꞌ naa profet‑e lii. ");
INSERT INTO zpg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Dtadgul yahc noꞌ ni güyuꞌ ba xtze bzacbeeiy yâme Dioz neꞌ lo dañ-rieꞌ, per laꞌd ni nac meññ-Isṟael, ne laꞌd Jerusaléṉ‑e racladzyu dzigzacbeeiy meññ Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ra Jesúz leeme: ―Ngünaa, bylíladzy ni gapyaꞌ lii. Zdzihñ dzé ni gzacbeeiy meññ Dioz ni nac dTad nó, no ba nehx siahd laꞌd dañ-rieꞌ, ni ba di zia laꞌd Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Laꞌd rzacbeeiy laꞌd ni nehx nann laꞌd dxu lee; per noꞌ nann noꞌ dxu rzacbeeiy noꞌ lee; porni de meññ-Isṟael ziaad dxu guislaa meññ de lo guîlnadz. ");
INSERT INTO zpg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Per zdzihñ dzé, no hôrrieꞌ gahc‑e dze-wé, meññ ni ulihbu rzacbeeiy Dioz ni nac dTad nó, gzacbeeiy yâme leeme por xiSpirt me no ni nac ni uli, porni Dioz ni nac dTad nó racladzy me gacu ze no meññ-rzacbeeiy leeme. ");
INSERT INTO zpg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dioz, Spirt‑e leeme, no dxu rzacbeeiy leeme, rquihñu gzacbeeiy yâme leeme por xiSpirt me no ni nac ni uli. ");
INSERT INTO zpg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ra ngüna-samaritan leeme: ―Naa nannaꞌ guiaad ni lee nac Mesíaz, ni ra yâme lee Crist; no dze-guiaad me, za me noꞌ gyreu. ");
INSERT INTO zpg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ra Jesúz leeme: ―Naa ni gayuno diidz lii we ni neꞌy guiaad. ");
INSERT INTO zpg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lo hor-wé bydzihñ xmeññ me, no ptzunadz yâme gayu Jesúz diidz no to ngünaa. Per ndruhty di nnabdiidz leeme bia gayu yâme, o bia ganabdiidz me ngüna-caḻ. ");
INSERT INTO zpg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Were psaꞌn ngüna-caḻ xrieꞌ, no güya me leññ guiedzy, no ra me meññ: ");
INSERT INTO zpg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Lâ te, güieꞌ laꞌd to mpyquie ni ra naa gyre ni ptzon. ¿Dxgann dac‑e leeme nac Crist la? ");
INSERT INTO zpg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Byruu yâme leññ guiedzy no za yâme ru dxie Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lóni zia ngüna-caḻ, xmeññ Jesúz naꞌ gaya leeme: ―Muextr, güdahgü. ");
INSERT INTO zpg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Per leeme ra me leeyâme: ―Naa rapaꞌ to guîlrahgü ni nehx rzaclo laꞌd lee. ");
INSERT INTO zpg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Were ganabdiidz saꞌ xmeññ me, ne: ―¿Dxuhch bidno ni gahgü me la? ");
INSERT INTO zpg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Per Jesúz ra leeyâme: ―Ni zidguiahc beeiy dguîlrahguaꞌ, leeu we de ni ctzon ni ne Dioz ni pshahl naa, no luxaꞌ xtziiñ me. ");
INSERT INTO zpg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ne laꞌd: “Riaadz ziaꞌ stahp mboo par gydzihñ cüsech”; per naa gapyaꞌ laꞌd: Lâ güieꞌ gyre meññ-rieꞌ ni ziaad, zidguiahc yâme we beeiy cüsech ni ba bydzihñ no ba gaye. ");
INSERT INTO zpg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Dxu runo meññ xtiidz Dioz, zidguiahc me we beeiy meññ-gatzoo cüsech, no scaꞌ me ni zidguiahc beeiy sahcu; no cüsech-rieꞌ, leeu we par gap meññ guîlmbahñ ni nehx zluhx, lehdy scâsy meññ-guzlo gatzoo dziiñ no zegahc meññ-rtzoo cüsech, rxihly gyrop cuib yâme. ");
INSERT INTO zpg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","No ni uli we rnii to didz-zaaby ni ne: “To meññ rdziib, no dze-ba nu cüsech zrieñ rchuꞌ.” ");
INSERT INTO zpg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naa gashaalaꞌ laꞌd beeiy ni zictzoo laꞌd cüsech ru nehx bdziib laꞌd. Zrieñ meññ ptzoo dziiñ beeiy ni bdziib leeu, no laꞌd ctzoo xicüsechu. ");
INSERT INTO zpg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Xtahl meññ-samaritan ni nu guiedzy-wé bylíladzy yâme Jesúz no ni günii ngüna-caḻ de ni ra me: “Gu me naa gyre ni ba ptzon.” ");
INSERT INTO zpg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ru bydzihñ meññ-samaritan ru dxie Jesúz, ra yâme leeme guiaꞌn me no leeyâme; no biaꞌn me uga chohp dzé. ");
INSERT INTO zpg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","No ma xtahl yâme bylíladzy hor-bieññ yâme ni günii me lehbme. ");
INSERT INTO zpg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","No ra yâme ngüna-caḻ: ―Hôrrieꞌ rlídadzy noꞌ, nehx nunzy de ni guhdzyiꞌ noꞌ, mazyg porni noꞌ gahc ba bieññ noꞌ ni günii me, no ba nann noꞌ ni uli we leeme nac Crist ni guislaa meññ-nu lo guiedzylie de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Güdedy chohp dzé byruu Jesúz ṟegioṉ-Samary, za me ṟegioṉ-Galilea, ");
INSERT INTO zpg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","porni Jesúz gahc günii me, to profet nehx rzacbeeiy meññ lee leññ gahc xguiedzy. ");
INSERT INTO zpg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Per ru bydzihñ Jesúz ṟegioṉ-Galilea, bdee meññ-Galilea ñahz no guîlrxihly bydzihñ me, porni dze-güya yâme lni-Pascü Jerusaléṉ, bwieꞌ yâme gyre ni ptzoo me uga. ");
INSERT INTO zpg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Luxu gubyguiat Jesúz guiedzy-Caná ni nu lo ṟegioṉ-Galilea, ru ptzoo me nzeꞌ vin. No guiedzy-Capernaum nu to mpyquie-rtzoo xtziiñ ṟeiy, rahp to xiñ-ñooby me gayac-ure. ");
INSERT INTO zpg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hor-gunn mpyquie-rtzoo xtziiñ ṟeiy byruu Jesúz ṟegioṉ-Judea no biahd me ṟegioṉ-Galilea, güya me günab me tza Jesúz xiryuꞌ me lehdy csiaḻ xiiñ me ni gayac-ure lé rluu ba dziguiehty. ");
INSERT INTO zpg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Were ra Jesúz leeme: ―Nehx rlíladzy laꞌd naa, bâḻ di güieꞌ laꞌd ctzon ni ngann no zrieñ guîlrtzunadz. ");
INSERT INTO zpg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Per mpyquie-caḻ ra me Jesúz: ―Señor, tzoꞌ ngueeḻy gahc, antzy ni gaty dshiñaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ra Jesúz leeme: ―Nehx zehty xiiñiꞌ, gubyguiat xiryuꞌy. No bylíladzy mpyquie-caḻ ni ra Jesúz leeme, no zia me. ");
INSERT INTO zpg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hor-ba zia me xiryuꞌ me, mós yahc ni rtzoo xtziiñ me, bigydzil-lo yâme leeme, ra yâme leeme: ―¡Xiiñiꞌ ba biaḻ! ");
INSERT INTO zpg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Were günabdiidz me leeyâme beeiy pór guzlo biaḻ me. Ra yâme leeme: ―Naag la un güdedy ribygue, byruu xixle me. ");
INSERT INTO zpg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","No xtad ñôbydxuur, bitsêlou leeme naabz hor-wé gu Jesúz leeme: “Nehx zehty xiiñiꞌ”; no bylíladzy me Jesúz gydiby xmiꞌñ me. ");
INSERT INTO zpg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nirieꞌ we ni byrohp ni ngann ni ptzoo Jesúz lo ṟegioṉ-Galilea ru gubyguiat me, byruu me ṟegioṉ-Judea. ");
INSERT INTO zpg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Güdedy doozy dzé gayahc to lni Jerusaléṉ ni rtzoo meññ-Isṟael, no gyzac güya Jesúz uga. ");
INSERT INTO zpg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","No Jerusaléṉ, gahsh ru ne yâme xPuert Xiily, dxie to guial, no lo didz-hebreu leu Betesda; no rahpu gaay corredor. ");
INSERT INTO zpg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Leññ corredor-wé yahc nash xtahl meññ-gayac-ure. Lahd yâme ngaḻ, lahd yâme ndang, no lahd yâme di raḻ gyniꞌby mbehty; no gabiahz yâme hor-rdziꞌ nzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","No lahd ga riaht to ángel ru dxie nze-caḻ, rdziꞌ me lou, no dxu nier riuꞌ lou, riaḻ gahc de nitisy guîlguihdz ni rzahc. ");
INSERT INTO zpg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nuty to mpyquie lahd yâme uga, ba rahp treintayoch ihz de ni gayac-ure me. ");
INSERT INTO zpg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ru bwieꞌ Jesúz leeme, no gunn Jesúz mpyquie-wé ba xtze nash me ze, were ra Jesúz leeme: ―¿Racladzyiꞌ guiaḻiꞌ la? ");
INSERT INTO zpg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ra me Jesúz: ―Señor, nehx rapaꞌ ndruhty ni nguꞌ naa lo guial lóni rdziꞌ nzeꞌ. Cad gá ganâbdadzyaꞌ tzun, riuꞌ zrieñ nier que naa. ");
INSERT INTO zpg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ra Jesúz leeme: ―Biahsiꞌ, gülesy xcamilliꞌ, no güzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hor-wé gahc biaḻ mpyquie-wé, no gülesy xcamill me no guzlo gazeꞌ me. Per gumm nacu dze-risladzy meññ la, ");
INSERT INTO zpg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","meññ-Isṟael ni rtzoo mdad, ra yâme mpyquie-wé ni psiaḻ Jesúz lee: ―Nehx xñahzu tziynoy xcamilliꞌ, porni dzêrieꞌ, dze-risladzy meññ‑e leeu. ");
INSERT INTO zpg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ra mpyquie-wé leeyâme: ―Mpyquie-psiaḻ naa we ra naa: “Gülesy xcamilliꞌ no güzeꞌ.” ");
INSERT INTO zpg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Meññ-Isṟael ni rtzoo mdad, ra yâme leeme: ―¿Dxu we leeme ni ra lii: “Gülesy xcamilliꞌ no güzeꞌ”? ");
INSERT INTO zpg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per mpyquie-wé ni biaḻ, nehx nann me dxu psiaḻ leeme, porni Jesúz bynihty gahc me lahd meññ-xtahl ni nu uga. ");
INSERT INTO zpg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Byluxu, bidgüieꞌ Jesúz leeme ruꞌ idoró, no ra leeme: ―Bwieꞌ, hôrrieꞌ ba biaḻiꞌ. Ba di ctzooy guîlquie gyzac, lehdy di guibyguiat gaquiꞌ behch ni ma nadz. ");
INSERT INTO zpg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Were za gahc me, zigyne me meññ-Isṟael ni rtzoo mdad, ra me Jesúz‑e psiaḻ leeme. ");
INSERT INTO zpg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","No leewe meññ-Isṟael ni rtzoo mdad, guzlo gayo yâme Jesúz lehdy igaꞌdy yâme leeme, porni ptzoo me nirieꞌ yahc dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Per ra Jesúz leeyâme: ―DTadaꞌ nehx rsaꞌn me de ni rtzoo me dziiñ, no zegahc naa rtzon dziiñ. ");
INSERT INTO zpg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Por nirieꞌ meññ-Isṟael ni rtzoo mdad ma gayo yâme xnahc igaꞌdy yâme Jesúz, porni nehx nunzy ni di rlaby me dze-risladzy meññ, mazyg gatzoo me leeme beeiy gahc Dioz, ru rnii me Dioz‑e merp xTad me. ");
INSERT INTO zpg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, nehx rtzoo Xiiñ Dioz mbehty tohg me; ni rwieꞌ me rtzoo xTad me, wé we rtzoo me. Gyre ni rtzoo xTad me, niwé gahc‑e rtzoo me. ");
INSERT INTO zpg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","XTad me ndzi leeme, no rluu leeme gyre ni rtzoo; no zluur leeme zrieñ ni ma xroꞌ que nirieꞌ yahc, xtâ lé ctzunadz laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","No mod-rispahñ xTad me mînguty yahc no rdee me guîlmbahñ leeyâme, zegahc‑e rdee Xiiñ Dioz guîlmbahñ dxu racladzy me gdee meu lee. ");
INSERT INTO zpg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Porni xTad me nehx rtzoo me guîlguxtisy chehsh ndruhty, mazyg ra me nunzy Xiiñ me ctzoo guîlguxtisy, ");
INSERT INTO zpg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","lehdy gzacbeeiy gyre meññ Xiiñ Dioz mod-rzacbeeiy gahc yâme xTad me. Dxu nehx rzacbeeiy Xiiñ Dioz, nehx rzacbeeiy yâme xTad me ni pshahl leeme. ");
INSERT INTO zpg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Gapyaꞌ laꞌd ni uli: Dxu rquee ihqy ni ren, no rlíladzy Dioz ni pshahl naa, wé zahp guîlmbahñ ni nehx zluhx; no di znihty me lo xguîlquie me, mazyg zidguiahc me beeiy ni ba güdedy de lo guîlguhty, no ba rahp me guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Naa gapyaꞌ laꞌd ni uli, ziaad to dzé, no naꞌ gahc‑e leeu, ru guieññ mînguty xriedz Xiiñ Dioz; no dxu ctzoo ni ra me, gap guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Porni xTad me rdee guîlmbahñ ni nehx zluhx; modé gahc‑e bdee xTad me de ni beeiyu Xiiñ me rdee me guîlmbahñ; ");
INSERT INTO zpg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","no zegahc günii xTad me leeme ctzoo me guîlguxtisy, porni leeme we Mpyquie-Pshahl Dioz Lee. ");
INSERT INTO zpg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Di ctzunadz laꞌd no nirieꞌ, porni zdzihñ dzé gyre meññ ni ba guhty zieññ xriedz me, ");
INSERT INTO zpg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","no zruu yâme leññ baa. Meññ-ptzoo ni nac xñahzû mod-ne Dioz, zbahñ yâme lehdy gap yâme guîlmbahñ ni nehx zluhx; per meññ-ptzoo ni nehx riuꞌladzy Dioz, zbahñ yâme lehdy gynihty yâme lo xguîlquie yâme. ");
INSERT INTO zpg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Nehx beeiy rtzon mbehty ni ne dguîlriehñaꞌ. Mod-ra dTadaꞌ naa, mod-wé we rtzon guîlguxtisy; no xñahzu ni rtzon, porni nehx ryobyaꞌ ctzon ni racdadzyaꞌ, mazyg ni racladzy dTadaꞌ ni pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Bâḻ naa ndedyaꞌ diidz de naa gahc la, ni nnin nehx nsahcu. ");
INSERT INTO zpg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nu sto ni rdee diidz de naa, no nannaꞌ ni rnii me de naa, ni uli we leeu. ");
INSERT INTO zpg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Laꞌd pshahl meññ-bignabdiidz Juaṉ; no ni günii me, ni uli we leeu. ");
INSERT INTO zpg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Per naa nehx gabiaazaꞌ tzu dxu gdee diidz de naa; mazyg ren ze, lehdy gylaa laꞌd de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juaṉ zidguiahc me beeiy to bial ni gaguꞌ byniꞌ; no byxilyno laꞌd xibyniꞌ me doozy dzé. ");
INSERT INTO zpg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Per naa rapaꞌ sto ni rdee diidz ni ma rsahc que ni bdee Juaṉ diidz. Naa rtzon ni ne dTadaꞌ ctzon, no leegahcu rdee diidz leeme pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","No zegahc dTadaꞌ ni pshahl naa, bdee me diidz de naa. No nehx rieññ laꞌd ni ne me, ni nehx rwieꞌ laꞌd leeme. ");
INSERT INTO zpg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","No nehx nu xtiidz me leññ xguîlmbahñ laꞌd, porni nehx rlíladzy laꞌd naa ni pshahl me lee. ");
INSERT INTO zpg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Laꞌd ruuḻ laꞌd lo Guehtzy zaꞌgndzi ru queꞌ xtiidz Dioz, porni lou racladzy laꞌd gydzial laꞌd bia mód gap laꞌd guîlmbahñ ni nehx zluhx; no nîcze Guehtzy gahc ru queꞌ xtiidz Dioz rdee diidz de naa, ");
INSERT INTO zpg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","per nehx racladzy laꞌd gylíladzy laꞌd naa, lehdy ñahp laꞌd guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Naa nehx racdadzyaꞌ cuguia meññ naa. ");
INSERT INTO zpg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","No naa rzacloꞌn laꞌd, no nannaꞌ nehx rzacbeeiy laꞌd Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naa, dTadaꞌ we pshahl naa, no nehx rlíladzy laꞌd naa; no bâḻ ñahd sto ni nnii ni ne xguîlriehñ, wé we nlíladzy laꞌd lee. ");
INSERT INTO zpg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Bia mód‑e gylíladzy laꞌd, aaḻ laꞌd gahc rguguia saꞌ, no ni nac tohzy Dioz, nehx ryo laꞌd cuguia me laꞌd? ");
INSERT INTO zpg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Di gyzaꞌ leññ ihqy laꞌd naa gapyaꞌ dTadaꞌ ni nac laꞌd; mazyg guehtzy gahc‑e ni bzaa Moiséz ni de lee gabiahz laꞌd lee, leegahcu ganii ni nac laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Porni bâḻ nlíladzy laꞌd ni rnii lo Xguehtzy Moiséz la, zegahc‑e nlíladzy laꞌd naa, porni de naa we bzaa me. ");
INSERT INTO zpg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Per bâḻ nehx rlíladzy laꞌd ni bzaa me la, ¿bia mód‑e nlíladzy laꞌd ni ren laꞌd? ");
INSERT INTO zpg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bylux nirieꞌ za Jesúz stiby chehsh nisdoo ni le Galilea, no zegahc leu Tiberias. ");
INSERT INTO zpg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Xtahl meññ náḻ ru za me, porni rwieꞌ yâme rtzoo me xtahl ni ngann ni rsiaḻ me meññ-gayac-ure. ");
INSERT INTO zpg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Were güyehpy Jesúz chehsh to dahñ, no gürie me uga no xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ba zidgahsh lni-Pascü, lni ni rtzoo meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Lóni bwieꞌ Jesúz ziaad xtahl meññ ru dxie me, ra me Felipy: ―¿Báhx‑e ssii nó ni gahgü gyre meññ-rieꞌ yahc? ");
INSERT INTO zpg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Günii me ze lehdy güieꞌ me bia ga Felipy leeme, porni ba gahc nann me bia ctzoo me. ");
INSERT INTO zpg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Were ra Felipy leeme: ―Sahc xchieñ chohp gayuu xdzé dziiñ nehx niygahlu par nzee ni ñoo to to yâme nîcze doozy. ");
INSERT INTO zpg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","To lahd xmeññ me ni le Ndréz, behtzy Simoṉ-Pedr, ra me Jesúz: ");
INSERT INTO zpg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―To ñobywiñ caꞌ gaay paṉ-cebad neꞌ no chohp mbaḻ; per ¿bia dziix‑e niwé par xtahl meññ? ");
INSERT INTO zpg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Were ra Jesúz xmeññ me: ―Lâ ga gyre meññ-wé cuia yâme. Nu xtahl guix-ngay uga ru gürie yâme, no por gyre yâme beeiy gaay mily mpyquie. ");
INSERT INTO zpg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Cuaꞌ Jesúz paṉ-caḻ yahc lo ña me, no bylux bdee me xquix Dioz, bdee meu cuaꞌ xmeññ me; no xmeññ me güdiizu, cuaꞌ meññ-dxie yahc uga. No mod-wé gahc ptzoo me no mbaḻ, güdahgü yâme glo bydzeꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","No ru bylux güee yâme, ra Jesúz xmeññ: ―Lâ ctohp gyre ni biaꞌn, lehdy di gynihty mbehtyu. ");
INSERT INTO zpg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Were ptohp yâme ni biaꞌn, no bistzee yâme tzipychop dzomby de lo gaay paṉ-cebad. ");
INSERT INTO zpg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hor-bwieꞌ meññ-caḻ yahc ni ngann ni ptzoo Jesúz, ne yâme: ―Mpyquie-rieꞌ we ulihbu profet ni nac diidz guiaad lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Per Jesúz nann me riñlo meññ-wé yahc tziyno leeme lehdy gac me ṟeiy, nîcze nehx riuꞌladzy me. Leewe gyzac byrusytzu me, cueꞌ me dahñ tohg me. ");
INSERT INTO zpg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ru ba güyuꞌ guiaal, biaht xmeññ Jesúz coo nisdoo, ");
INSERT INTO zpg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","no güyuꞌ yâme leññ to barcü, za yâme gadedybish yâme nisdoo par gydzihñ yâme guiedzy-Capernaum. Ba ncawy, per Jesúz dgueññ guibyguiat me. ");
INSERT INTO zpg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tohzy guzlo byxuu mbedun, lé rlesyu oḻ lo nisdoo ru za xmeññ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hor-za yâme ba beeiy gaay o shoꞌb kilómetr, bwieꞌ yâme gazeꞌ Jesúz xtziguia nzeꞌ, gadziñgahsh me xbarcü yâme, no bydzie yâme. ");
INSERT INTO zpg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Were ra Jesúz leeyâme: ―¡Naa we, di gydzie laꞌd! ");
INSERT INTO zpg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","No were byxihly yâme ru güyuꞌ me leññ barcü, no hor-wé gahc bydzihñ yâme ru za yâme. ");
INSERT INTO zpg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Byre guiaal, meññ-biaꞌn stiby chehsh nisdoo gunn yâme nehx nur mazy barcü uga, nunzy ni güyuꞌ xmeññ Jesúz leññ, no zau. No gunn yâme Jesúz nehx za me no xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Per zrieñ barcü ni byruu ciuda-Tiberias bydzihñu gahsh de ru güdahgü yâme paṉ ru bdee Jesúz xquix Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ru bwieꞌ meññ-wé yahc nehx nu Jesúz uga ni xmeññ me, güyuꞌ yâme leññ barcü ni bydzihñ uga no za gahc yâme guiedzy-Capernaum, zigyo yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hor-bydzihñ yâme stiby chehsh nisdoo, bwieꞌ yâme Jesúz, no günabdiidz yâme, ra yâme leeme: ―Muextr, ¿pór bydzihñiꞌ neꞌ? ");
INSERT INTO zpg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, gayo laꞌd naa, dac‑e porni bwieꞌ laꞌd ptzon ni ngann, mazyg porni güdahgü laꞌd glo bydzeꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Di cu ihqy laꞌd ctzoo laꞌd dziiñ lehdy gap laꞌd guîlrahgü ni rre, mazyg lâ cu ihqy laꞌd gap laꞌd ni zidguiahc beeiy guîlrahgü ni nehx zre no gdee guîlmbahñ ni nehx zluhx. Naa we Mpyquie-Pshahl Dioz Lee, no guîlragü-rieꞌ zdedyaꞌu laꞌd, porni dTadaꞌ Dioz, ba günii me ze ctzon. ");
INSERT INTO zpg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Günabdiidz yâme leeme: ―¿Bia mód ctzoo noꞌ lehdy gac mod-racladzy Dioz? ");
INSERT INTO zpg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ra Jesúz leeyâme: ―Ni racladzy Dioz ctzoo laꞌd, gylíladzy laꞌd naa ni pshahl me lee. ");
INSERT INTO zpg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ra yâme leeme: ―¿Bia ni ngann rtzooy, nwieꞌ noꞌ lehdy gylídadzy noꞌ lii? ¿Bluu noꞌ ni beeiy rtzooy? ");
INSERT INTO zpg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Dmeññ nó ni güyuꞌ ba xtze güdahgü yâme maná dze-güyuꞌ yâme lo yu-bihdzy, mod-ganii lo Guehtzy ru queꞌ xtiidz Dioz: “Dioz bdee leeyâme paṉ ni byruu gybaa, güdahgü yâme lee.” ");
INSERT INTO zpg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, dac‑e Moiséz bdee paṉ ni byruu gybaa laꞌd, mazyg dTadaꞌ we rdee ni ulihbu paṉ ni rruu gybaa. ");
INSERT INTO zpg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porni paṉ ni rdee Dioz, leeu we ni biaht gybaa no rdee guîlmbahñ meññ-nu lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ra yâme leeme: ―Señor, bdee noꞌ paṉ-wé tirgahc. ");
INSERT INTO zpg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ra Jesúz leeyâme: ―Naa we paṉ ni rdee guîlmbahñ. Dxu ryo naa, nehx ziuꞌ dzé gylahn; no dxu rlíladzy naa, nehx ziuꞌ dzé ssaagyladzy. ");
INSERT INTO zpg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Per mod-ba ren laꞌd, nîcze ba bwieꞌ laꞌd naa, nehx rlíladzy laꞌd naa. ");
INSERT INTO zpg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Gyre meññ ni gdee dTadaꞌ lee par gac dmeññaꞌ lee, zidyo yâme naa; no meññ ni ryo naa, nehx rboon lee diby lad. ");
INSERT INTO zpg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Naa biataꞌ gybaa dac‑e par ctzon ni racdadzyaꞌ, mazyg lehdy ctzon ni racladzy dTadaꞌ ni pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","No dTadaꞌ ni pshahl naa, nehx racladzy me nnityaꞌ ni to meññ ni bdee me naa, mazyg racladzy me guispahñaꞌ leeyâme dze-gydibylgaa guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Porni dTadaꞌ racladzy me gyre meññ ni gzaclo naa no gylíladzy naa, gap yâme guîlmbahñ ni nehx zluhx; no naa zispahñaꞌ leeyâme dze-gydibylgaa guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","No guzlo meññ-Isṟael galesyno yâme ni günii Jesúz, porni ne me: “Naa we paṉ ni biaht gybaa.” ");
INSERT INTO zpg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","No ne yâme: ―¿Dâs‑e leeme Jesúz xiiñ José la, no rzaclo nó xtad me no xmam me? ¿Bia nacu rnii me biaht me gybaa? ");
INSERT INTO zpg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Were ra Jesúz leeyâme: ―Di gzuhl laꞌd diidz. ");
INSERT INTO zpg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ndruhty nehx zyo naa, bâḻ dTadaꞌ ni pshahl naa di yquee riedz leeyâme; no naa zispahñaꞌ leeyâme dze-gydibylgaa guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lo guehtzy ni bzaa to de lahd profet neu: “Gyre yâme zluu Dioz lee.” No leewe, gyre meññ ni guieññ no gyzeedy ni rluu dTadaꞌ, ridyo naa par gac dmeññaꞌ lee. ");
INSERT INTO zpg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Dac‑e ren nu dxu ba bwieꞌ dTad nó Dioz; nunzy naa ni pshahl me, wé we ba bwieꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Gapyaꞌ laꞌd ni uli, dxu gylíladzy naa, gap guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Naa zidguiahc beeiy paṉ ni rdee guîlmbahñ. ");
INSERT INTO zpg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Xtadgul yahc laꞌd ni güyuꞌ ba xtze, güdahgü yâme maná dze-güyuꞌ yâme lo yu-bihdzy, no nîcze güdahgü yâmeu, guhty yâme; ");
INSERT INTO zpg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","per naa ganin de ni zidguiahc beeiy paṉ ni byruu gybaa; dxu gahgü leeu, nehx znihty. ");
INSERT INTO zpg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naa we ni zidguiahc beeiy paṉ ni rdee guîlmbahñ ni byruu gybaa; dxu gahgü paṉ-rieꞌ, gap guîlmbahñ ni nehx zluhx. No paṉ-rieꞌ ni zdedyaꞌ, dcuerpaꞌ we leeu, lehdy meññ-nu lo guiedzylie gap yâme guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Guzlo meññ-Isṟael galesyno yâme, no ra saꞌ yâme: ―¿Bia mód‑e ne me gdee xcuerp me gahgü nó? ");
INSERT INTO zpg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, naa we Mpyquie-Pshahl Dioz Lee, no bâḻ di gahgü laꞌd dcuerpaꞌ no di goo laꞌd drieñaꞌ, nehx zahp laꞌd guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dxu gahgü dcuerpaꞌ no goo drieñaꞌ zahp guîlmbahñ ni nehx zluhx, no naa zispahñaꞌ lee dze-gydibylgaa guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porni dcuerpaꞌ we ni ulihbu guîlrahgü, no drieñaꞌ, leeu we ni ulihbu guîlroo. ");
INSERT INTO zpg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Dxu gahgü dcuerpaꞌ no goo drieñaꞌ, nu no naa no naa nun no lee. ");
INSERT INTO zpg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","DTadaꞌ ni pshahl naa rdee me guîlmbahñ, no zegahc naa mbahñaꞌ por leeme; no mod-wé dxu gahgü de naa, gdedyaꞌ lee guîlmbahñ. ");
INSERT INTO zpg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Naa we paṉ ni biaht gybaa. Paṉ-rieꞌ dac‑e sca maná ni güdahgü xtadgul yahc laꞌd ni güyuꞌ ba xtze, no nîcze güdahgü yâmeu per guhty yâme; per dxu gahgü de paṉ-rieꞌ gap guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Nirieꞌ günii Jesúz guiedzy-Capernaum, hor-galuu me meññ leññ idoo. ");
INSERT INTO zpg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ru bieññ xmeññ yahc Jesúz nirieꞌ, xtahl yâme ne: ―Modni ngann ni galuu me; ¿dxu we beeiy ncaꞌ leeu? ");
INSERT INTO zpg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesúz naꞌ, nann me gatixcann ni günii me no xmeññ me, were ra me leeyâme: ―¿Nirieꞌ rzacnñaad laꞌd la? ");
INSERT INTO zpg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Naꞌz naꞌ, ¿bia nnii laꞌd bâḻ nwieꞌ laꞌd naa, Mpyquie-Pshahl Dioz Lee, guiasaꞌ zian gybaa sto ru güyu gahcaꞌ? ");
INSERT INTO zpg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","XiSpirt Dioz‑e ni rdee guîlmbahñ ni nehx zluhx; nehx nu to meññ ni beeiy ndee leeu. No ni gayapyaꞌ laꞌd ziaadu de xiSpirt Dioz, no rdeedyu guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per nu ziaꞌr lahd laꞌd ni nehx rlíladzy. Günii Jesúz nirieꞌ porni nann me dxu nehx rlíladzy yahc leeme, no dxu gdee leeme lo ña meññ-rdziadzyno leeme. ");
INSERT INTO zpg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","No ra me: ―Leewe ren laꞌd ndruhty nehx zidyo naa, bâḻ di cshahl dTadaꞌ lee. ");
INSERT INTO zpg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","No glohdy dze-wé xtahl ni ba nac xmeññ me psaꞌn yâme leeme, no ba nehx ria yâme no leeme. ");
INSERT INTO zpg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Were ra Jesúz gydiby tzipychop xmeññ me: ―¿Zegahc riñlo laꞌd gyrusytzu laꞌd de naa la? ");
INSERT INTO zpg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ra Simoṉ-Pedr leeme: ―Señor, ¿per dxu we beeiy nisnaaḻ noꞌ lee? Diidz ni runoy meññ, leeu we zidno guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Noꞌ ba bylídadzy noꞌ, no nann noꞌ lii we nac Crist, Xiiñ Dioz-mbahñ. ");
INSERT INTO zpg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ra Jesúz leeyâme: ―¿Dâs‑e naa güleꞌn tzipychop laꞌd la? Luxu to lahd laꞌd nac beeiy bêndzab. ");
INSERT INTO zpg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ru günii Jesúz ze, de Jud‑e ganii me, xiiñ Simoṉ-Iscariot; porni Jud gdee leeme lo ña meññ-rdziadzyno leeme, nîcze xmeññ gahcme lee de lo ni nac gydiby tzipychop. ");
INSERT INTO zpg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Byluxu, güya Jesúz byzaꞌzy lo ṟegioṉ-Galilea. Nehx biuꞌladzy me ñaꞌn me lo ṟegioṉ-Judea, porni meññ-Isṟael yahc ni rtzoo mdad gayo leeme, lehdy igaꞌdy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Per ba gadziñgahsh xilni yu-guix yahc ni rtzoo meññ-Isṟael, ");
INSERT INTO zpg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","leewe ra meññ-behtzy me leeme: ―Di guiaꞌniꞌ neꞌ; güya lo ṟegioṉ-Judea lo lni, lehdy xmeññiꞌ ni nu uga güieꞌ yâme ni ngann ni rtzooy. ");
INSERT INTO zpg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Porni ndruhty ni racladzy gzaclo meññ lee, nehx ntzoo behch ngaꞌdzy. Bâḻ rtzooy zâ nirieꞌ, ptzoo leeyahcu ñaz-lo gyre meññ. ");
INSERT INTO zpg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Günii meññ-behtzy me ze, porni xtâ no leeyâme nehx rlíladzy leeme. ");
INSERT INTO zpg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Were ra Jesúz leeyâme: ―Dgueññ ziaꞌ gydzihñ dze-guieññ meññ dxu naa; per par laꞌd naꞌ, nitisy dzé we mos. ");
INSERT INTO zpg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Meññ-nu lo guiedzylie nehx néladzy yâme laꞌd; per naa néladzy yâme, porni rdedyaꞌ diidz ni nahcsy ni rtzoo yâme. ");
INSERT INTO zpg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Lâ tza; naa nehx zian, porni dgueññ ziaꞌ gyzaꞌ dzé tzan. ");
INSERT INTO zpg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bylux günii me ze, biaꞌn me lo ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Per bylux za meññ-behtzy Jesúz lni, za Jesúz zegahc, per dac ru neññ, mazyg mod-ngaꞌdzy gá. ");
INSERT INTO zpg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","No meññ-Isṟael ni rtzoo mdad gayo leeme lo lni, no ne yâme: ―¿Óz mpyquie-caḻ‑e? ");
INSERT INTO zpg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","No gyrehzy ganii yâme de leeme. Nu yâme ne: “Mpyquie-tziaawy we leeme”; per zrieñ yâme ne: “Yac, dac‑e meññ-tziaawy leeme, risquiee me meññ‑e.” ");
INSERT INTO zpg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","No pur ngaꞌdzy ru meññ diidz de leeme, porni rdzie yâme meññ-Isṟael ni rtzoo mdad. ");
INSERT INTO zpg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Per dze-nac glaꞌy lni, güya Jesúz leññ idoró, no guzlo galuu me meññ. ");
INSERT INTO zpg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","No meññ-Isṟael ni rtzoo mdad gatzunadz yâme, no ne yâme: ―¿Bia mód‑e nann me gyre nirieꞌ, no dac me ni byzeedy? ");
INSERT INTO zpg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ra Jesúz leeyâme: ―Ni rlun meññ, dac‑e de naa leeu, mazyg Dioz ni pshahl naa we xchieñ leeu. ");
INSERT INTO zpg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dxu riuꞌladzy ctzoo ni racladzy Dioz, zann bâḻ ni rlun meññ ziaadu de Dioz, o bâḻ ganin ni ne dguîlriehñaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Dxu rnii ni ne xguîlriehñ, racladzy cuguia meññ lee; per naa racdadzyaꞌ tzuguia dTadaꞌ ni pshahl naa; leewe rnin ni uli, no nehx risquieen. ");
INSERT INTO zpg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Dâs‑e bdee Moiséz leiy laꞌd la? No luxu, ndruhty de laꞌd nehx rtzoo ni neu. ¿Bia nacu naꞌ racladzy laꞌd igaꞌdy laꞌd naa? ");
INSERT INTO zpg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ra yâme leeme: ―¡Mbenahcsy‑e nu lii, rniiy cuentz! ¿Dxu riñlo igaꞌdy lii? ");
INSERT INTO zpg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ra Jesúz leeyâme: ―Gyre laꞌd rtzunadz por to ni ngann ni ptzon dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moiséz ne me tzu señ lady mdoñooby (nîcze nehx nier Moiséz ptzoou, mazyg xtadgul yahc laꞌd ni güyuꞌ ba ma xtze diaa que dze-güyuꞌ Moiséz), no leewe rtzoo laꞌdu nîcze dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Naꞌ hôrrieꞌ, bâḻ rguꞌ laꞌd señ lady mdoñooby dze-risladzy meññ, no mod-wé gazobdiidz laꞌd ni ne xleiy Moiséz, ¿bia nacu rdziadzyno laꞌd naa porni psiaḻaꞌ nter xcuerp to mpyquie dze-risladzy meññ? ");
INSERT INTO zpg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Hor-gynii laꞌd lguia ni rtzoo zrieñ, gax lâ güieꞌ zaꞌgndzi, were gynii laꞌd ni nac xñahzû. ");
INSERT INTO zpg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Were guzlo gaya lahd saꞌ meññ-nu Jerusaléṉ: ―¿Dac‑e leeme ni gayo yâme lee gaty la? ");
INSERT INTO zpg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lâ güieꞌ, xnahc‑e ganii me ñaz-lo nyug, no ndruhty nehx ra leeme mbehty. ¿O ba bylíladzy guxtisy yahc‑e, ulihbu leeme nac Crist la? ");
INSERT INTO zpg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mpyquie-rieꞌ, nann nó dxu meññ leeme; per Crist naꞌ, dze-guiaad me, ndruhty nehx zann dxu meññ leeme. ");
INSERT INTO zpg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bieññ me ganii meññ-wé yahc leññ idoró hor-galuu me meññ, were günii me ma ndip, ra me: ―¡Rzaclo laꞌd naa, no nann laꞌd dxu naa! Per dac‑e biaḻaꞌ ctzon ni ne dguîlriehñaꞌ. Mazyg ni pshahl naa rnii ni uli, no nehx rzaclo laꞌd leeme. ");
INSERT INTO zpg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Per naa rzacloꞌn leeme, porni ru nu me byruun, no leeme pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Were gucladzy yâme niyno yâme leeme lidzyguiib, per ndruhty di ñaḻ nnahzy leeme, porni dgueññ ziaꞌ gydzihñ dzé de ni igaꞌ me. ");
INSERT INTO zpg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Xtahl yâme bylíladzy leeme, no günii yâme: ―Dze-guiaad Crist, ¿nehxni ntzoo me ma xtahl ni ngann que ni rtzoo mpyquie-rieꞌ? ");
INSERT INTO zpg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bieññ lahd meññ-nac yahc fariseu ni galesyno zrieñ meññ lguia Jesúz; were ptzoo yâme diidz no zrieñ xjefy yahc bahl no pshahl yâme xmeññ yâme ni rahp ruꞌ idoró par nnahzy yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Were ra Jesúz leeyâme: ―Doozy dzé we tzunon laꞌd, luxu guibyguiataꞌ ru nu dTadaꞌ ni pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","No gyo laꞌd naa, per di zdzial laꞌd naa, porni nehx beeiy tza laꞌd ru tzun. ");
INSERT INTO zpg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Guzlo ganabdiidz saꞌ meññ-Isṟael ni rtzoo mdad, ra yâme: ―¿Baz‑e naꞌ ne me tza me no nehx zdzial nó leeme? ¿Gybiꞌ me zrieñ guiedzy ru nu-raꞌdz zrieñ dmeññ nó lahd gydze meññ ni gluu me lee la? ");
INSERT INTO zpg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Bia rnii ni ra me nó ze: “Gyo laꞌd naa, per di zdzial laꞌd naa, porni nehx beeiy tza laꞌd ru tzun”? ");
INSERT INTO zpg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Últim dzé ni gayahc lni, leeu we dzé ni ma rsahc, guzli Jesúz no günii me ndip, ne me: ―Dxu rzaagyladzy, guidyo naa no ba di ssaagyladzy. ");
INSERT INTO zpg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mod-ne lo Guehtzy ru queꞌ xtiidz Dioz, dxu gylíladzy naa, zahc leññ xguîlmbahñ me beeiy ru gada nze-xtahl ni rdee guîlmbahñ. ");
INSERT INTO zpg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nirieꞌ günii Jesúz lguia Spirt-Sant ni tzu leññ xguîlmbahñ meññ ni gylíladzy leeme; porni xiSpirt Dioz dgueññ ziaꞌ guiaad, mazyg xtâ guibyguiatr Jesúz gybaa lo guîlbyniꞌ, were guiaad xiSpirt me. ");
INSERT INTO zpg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Lahd gahc meññ-wé, ru bieññ yâme ni günii Jesúz, ne yâme: ―Mpyquie-rieꞌ we ulihbu profet ni guiaad. ");
INSERT INTO zpg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Zrieñ yâme ne: ―Mpyquie-rieꞌ nac Crist. Per zrieñ yâme ne: ―¿Nehxni ṟegioṉ-Galilea nruu Crist? ");
INSERT INTO zpg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Lo Guehtzy ru queꞌ xtiidz Dioz rniiu guiaad Crist de lo xfamily Davit no guiedzy-Beléṉ, ru nac xguiedzy Davit. ");
INSERT INTO zpg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","No mod-wé, to to meññ gydze ni ganii lguia Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","No zrieñ yâme gucladzy niyno leeme lidzyguiib, per ndruhty di ñaḻ nnahzy leeme. ");
INSERT INTO zpg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hor-gubyguiat meññ-rahp ruꞌ idoró, ra xjefy yahc bahl no meññ-nac yahc fariseu leeyâme: ―¿Bia nacu di nnahzy laꞌd leeme no nidnot leeme? ");
INSERT INTO zpg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ra meññ-rahp ruꞌ idoró leeyâme: ―¡Ndruhty dgueññ guieññ noꞌ nluu meññ beeiy leeme! ");
INSERT INTO zpg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Were ra meññ-nac yahc fariseu leeyâme: ―¿Laꞌd zegahc ba bisquiee me lee la? ");
INSERT INTO zpg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Nehxni ba nu dxuhch de dlahd noꞌ ni nac guxtisy, o lahd meññ-nac yahc fariseu, ba bylíladzy leeme? ");
INSERT INTO zpg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Per meññ-rieꞌ yahc, ni nehx nann leiy, Dioz gniꞌdy leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","No Nicodem, ni güya tzcaḻ ru nu Jesúz guiaal, nu me lahd meññ-nac fariseu; no ra me leeyâme: ");
INSERT INTO zpg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Dleiy nó neu, gax guieññ nó ni gynii to meññ par gann nó bia ptzoo me, no were beeiy gynii nó bâḻ gaty me. ");
INSERT INTO zpg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ra yâme Nicodem: ―¿Meññ-Galilea lii zegahc la? Biiḻy lo Guehtzy zaꞌgndzi ru queꞌ xtiidz Dioz, güieꞌzyiꞌ, dgueññ gyruu ni to profet ṟegioṉ-Galilea. ");
INSERT INTO zpg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Byluxu to to yâme zia xiryuꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Per Jesúz za me to dahñ ni le Oliv. ");
INSERT INTO zpg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","No ni byre guiaal, rsily, za me idoró gyzac, no bydohp meññ leeme, no gürie me, guzlo galuu me meññ. ");
INSERT INTO zpg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Muextr yahc naꞌ ni ruuḻ xleiy Moiséz no zrieñ meññ-nac yahc fariseu, bidno yâme to ngünaa ni bygano sto mpyquie ni nehx tziahl me lee, no bzu yâme leeme glaꞌy ru dxie Jesúz lahd meññ, ");
INSERT INTO zpg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","no ra yâme Jesúz: ―Muextr, ngüna-rieꞌ bygano me sto mpyquie ni nehx tziahl me lee. ");
INSERT INTO zpg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","No lo xleiy Moiséz neu, zâ ngüna-wé, hor-igaꞌ yâme, gaty yâme no guie. Lii naꞌ, ¿bia neꞌy? ");
INSERT INTO zpg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Leeyâme naꞌ, gayo yâme bia lguia gyruu yâme contr Jesúz. Per Jesúz naꞌ, byruꞌñ me no guzlo gazaa me lo yu no ihqy ña me. ");
INSERT INTO zpg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Gumm gatzunñaad yâme ganabdiidz yâme leeme la, were gürieli me no ra me meññ-wé yahc: ―Dxu laꞌd nehx rahp guîlquie, nier lee cshadguie leeme. ");
INSERT INTO zpg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","No gyzac byruꞌñ me, no gazaa me lo yu sto. ");
INSERT INTO zpg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ru bieññ yâme günii Jesúz ze, no nann yâme nehx nyar xguîlriehñ yâme, guzlo byruu to por to yâme, nier gahc ni ma mînguhl glo byre yâme byruu; no biaꞌn ngüna-caḻ ni bzu yâme lee glaꞌy ru dxie Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Gyzac gürieli Jesúz, no ndruhty di nwieꞌ me mazyg nunzy ngüna-caḻ, were ra Jesúz leeme: ―¿Óz meññ ni garuu contr lii naꞌ? ¿Ndruhty ba nehx günii rahp de ni gatyiꞌ la? ");
INSERT INTO zpg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ra me Jesúz: ―Ndruhty günii ze, Señor. Were ra Jesúz leeme: ―Naa zegahc nehx zapyaꞌ rahpiꞌ de ni gatyiꞌ. Gübiꞌ naꞌ, no ba di ctzooriꞌ guîlquie. ");
INSERT INTO zpg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Gyzac günino Jesúz meññ, ra me: ―Naa zidguiahcaꞌ beeiy byniꞌ par meññ-nu lo guiedzylie; dxu gac dmeññaꞌ, lee nehx ziuꞌ beeiy lo guibcawy, mazyg zahp me beeiy byniꞌ ni rdee guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Were ra meññ-nac yahc fariseu leeme: ―Lii gadeedyiꞌ diidz de lii gahc, leewe nehx rsahc ni rniiy. ");
INSERT INTO zpg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ra Jesúz leeyâme: ―Nîcze gadedyaꞌ diidz de naa gahc, per ni ganin rsahcu, porni nannaꞌ bá byruun no nannaꞌ bá tzan; no laꞌd nehx nann laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Rnii laꞌd ni nac meññ mod-rtzoo meññ-nu lo guiedzylie. Naa nehx rnin ni nac ndruhty. ");
INSERT INTO zpg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Per bâḻ rnin ni nac meññ, ni rnin rsahcu, porni dac‑e ni ne dguîlriehñaꞌ rnin, mazyg dTadaꞌ ni pshahl naa we ra naa bia gynin de ni nac meññ. ");
INSERT INTO zpg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo xleiy laꞌd neu, bâḻ chohp meññ gdee diidz tohzy mód, were rsahc ni gynii yâme. ");
INSERT INTO zpg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Naa gahc‑e gadedyaꞌ diidz de naa, no dTadaꞌ ni pshahl naa we, rdee diidz de naa zegahc. ");
INSERT INTO zpg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ra yâme leeme: ―¿Bá glo nu xTadiꞌ? Ra Jesúz leeyâme: ―Nehx rzaclo laꞌd naa, per ni dTadaꞌ; bâḻ nzaclo laꞌd naa, zegahc‑e nzaclo laꞌd dTadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nirieꞌ yahc günii Jesúz ru galuu me meññ leññ idoró ru rguꞌ yâme gun. No ndruhty nehx günahzy leeme, porni dgueññ gydzihñ dze-ba nac diidz. ");
INSERT INTO zpg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Gyzac ra Jesúz leeyâme: ―Naa tzan, no gyo laꞌd naa, per zehty laꞌd lo xguîlquie laꞌd. Ru tzan, nehx beeiy ziuꞌ laꞌdu. ");
INSERT INTO zpg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Were ne meññ-Isṟael ni rtzoo mdad: ―¿Dac‑e la, ganii me igaꞌdy me leegahcme, no leewe ne me di zaḻ tzo nó ru tza me? ");
INSERT INTO zpg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ra Jesúz leeyâme: ―Laꞌd de neꞌ lo yu we laꞌd, per naa de gybaa we naa; de lo guiedzylie-rieꞌ we laꞌd, per naa dac‑e de lo guiedzylie-rieꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","No leewe ren laꞌd zehty laꞌd lo xguîlquie yahc laꞌd; porni bâḻ nehx rlíladzy laꞌd naa we ni ba gahc nu, lo gahc xguîlquie laꞌd‑e zehty laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Were ra yâme leeme: ―¿Dxuz‑e lii? Ra Jesúz leeyâme: ―¿Dâs ba gahc ren laꞌd la? ");
INSERT INTO zpg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Rapaꞌ xtahl ni ñapyaꞌ no ni nnin de ni nac laꞌd. Per ni pshahl naa rnii ni uli; no ni bieññaꞌ de leeme, wé we ren meññ-nu lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per di ñieññ yâme bâḻ de dTad nó Dioz gaya Jesúz leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","No leewe, ra Jesúz leeyâme: ―Naa we Mpyquie-Pshahl Dioz Lee, no dze-ba gülesy laꞌd naa lo cruzy, were zann laꞌd naa we ni ba gahc nu, no nehx rtzon mbehty ni ne dguîlriehñaꞌ, mazyg ni rluu dTadaꞌ naa, wé we rtzon. ");
INSERT INTO zpg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Leeme pshahl naa no nuno me naa; dTadaꞌ nehx rsaꞌn me naa tohgaꞌ, porni rtzon ni riuꞌladzy me. ");
INSERT INTO zpg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hor-günii Jesúz ze, xtahl yâme bylíladzy leeme. ");
INSERT INTO zpg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ra Jesúz meññ-Isṟael yahc ni ba bylíladzy leeme: ―Bâḻ nehx ssaꞌn laꞌd de ni gzoob laꞌd dtiidzaꞌ, zahc laꞌd ni ulihbu dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","No ssaclo laꞌd ni nac ni uli, no leeu zislaa laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ra yâme leeme: ―De lo xfamily Braṉ‑e noꞌ, no nito dgueññ gac noꞌ mós ni byzee lehdy ñahc noꞌ beeiy ni nliiby. ¿Bia nacu neꞌy gylaa noꞌ? ");
INSERT INTO zpg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, dxu rtzoo guîlquie, guîlquie gahc‑e rtzoo mdad leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","To mós ni byzee nehx riaꞌn me no xfamily xpatróṉ me xtâ gaty me; mazyg xiiñ patróṉ, wé we rian-no xfamily. ");
INSERT INTO zpg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Leewe bâḻ Xiiñ Dioz guislaa me laꞌd de lo ña guîlquie, wer yaax‑e gylaa laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nannaꞌ uliu de lo xfamily Braṉ‑e laꞌd; per riñlo laꞌd igaꞌdy laꞌd naa, porni nehx riuꞌladzy laꞌd ni rnin. ");
INSERT INTO zpg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Naa rnin ni bwien dze-nun no dTadaꞌ, per laꞌd rtzohd ni ne xtad laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ra yâme Jesúz: ―¡Braṉ‑e dtad noꞌ! Ra Jesúz leeyâme: ―Bâḻ ñahc uliu xtad laꞌd Braṉ, ntzoo laꞌd mod-ptzoo me. ");
INSERT INTO zpg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","No nîcze gayapyaꞌ laꞌd ni nac ni uli ni bluu Dioz naa, per riñlo laꞌd igaꞌdy laꞌd naa. ¡Braṉ nehx güyuꞌ dzé ptzoo me ze! ");
INSERT INTO zpg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ni rtzoo xtad laꞌd, leegahcu rtzoo laꞌd. Ra yâme leeme: ―Dac‑e zrieñ dxu xiiñ noꞌ; Dioz, tohzy leeme we dtad noꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ra Jesúz leeyâme: ―Bâḻ ñahc uliu Dioz xtad laꞌd, nîntzi laꞌd naa, porni naa ru nu Dioz‑e byruun ziaḻaꞌ neꞌ. Nehx ziaḻaꞌ ctzon ni ne dguîlriehñaꞌ, mazyg Dioz‑e pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Bia nacu di raḻ guieññ laꞌd ni runon lad? Nehx rieññ laꞌd porni nehx riuꞌladzy laꞌd ni rnin. ");
INSERT INTO zpg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bêndzab, leeme we xtad laꞌd, no racladzy laꞌd ctzohd ni riuꞌladzy me. Pur guîlrgaꞌdy rtzoo me glo ba xtze diaa, no nehx rnii me ni uli. Ru risquiee me, leegahcme rdee diidz mbuxter‑e leeme, no nier leeme bisquiee. ");
INSERT INTO zpg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Leewe, nîcze rnin ni nac ni uli, nehx rlíladzy laꞌd naa. ");
INSERT INTO zpg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Dxu de laꞌd beeiy nluu bia guîlquie rapaꞌ? Bâḻ rnin ni uli, ¿bia nacu nehx rlíladzy laꞌd naa? ");
INSERT INTO zpg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dxu nu no Dioz, wé we rieññ xtiidz Dioz; gumm nehx nu laꞌd no Dioz la, leewe di ne laꞌd guieññ. ");
INSERT INTO zpg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Were ra meññ-Isṟael yahc leeme: ―Ni uli we rnii noꞌ, lii nehx naquiꞌ dmeññ noꞌ, meññ-samaritan lii, no nu mbenahcsy lii. ");
INSERT INTO zpg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ra Jesúz leeyâme: ―Nehx nu mbenahcsy naa. Ni rtzon la, rzacbeeiyaꞌ dTadaꞌ; no laꞌd naꞌ, rnii laꞌd ni nahcsy contr naa. ");
INSERT INTO zpg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Naa nehx gayobyaꞌ cuguia meññ naa, per Dioz ne gacu ze, no rnii me de ni nac meññ. ");
INSERT INTO zpg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gapyaꞌ laꞌd ni uli, dxu rzoob dtiidzaꞌ nehx znihty. ");
INSERT INTO zpg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ra meññ-Isṟael leeme: ―Hôrrieꞌ were ba bzaclo noꞌ nu mbenahcsy lii. Braṉ no zrieñ profet guhty yâme; no naꞌ lii neꞌy: “Dxu gzoob xtiidziꞌ nehx znihty.” ");
INSERT INTO zpg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ma rsahquiꞌ que dtadgul noꞌ Braṉ ni güyuꞌ ba xtze la? Leeme guhty me, no zegahcu zrieñ profet yahc. ¿Dxu we neꞌy naquiꞌ? ");
INSERT INTO zpg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ra Jesúz leeyâme: ―Bâḻ naa rguguian naa gahc la, were nehx rsahcu. Per dTadaꞌ we rguguia naa, ni ne laꞌd xDioz laꞌd lee. ");
INSERT INTO zpg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Per luxu nehx rzaclo laꞌd leeme. No naa rzacloꞌn leeme; no bâḻ nnin nehx rzacloꞌn leeme la, ñahcaꞌ mbuxter beeiy gahc laꞌd. Per we naꞌ, ni uli we rzacloꞌn leeme, no rzobdiidzaꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Xtadgul laꞌd Braṉ ni güyuꞌ ba xtze, byxihly me güieꞌ me dzé ni guiaḻaꞌ. No dze-bwieꞌ meu, modni byxihly me. ");
INSERT INTO zpg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Were ra yâme Jesúz: ―Per ni cincuent ihz nehx rahpiꞌ, ¿bia mód neꞌy bwieꞌy Braṉ? ");
INSERT INTO zpg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, naa we ni ba gahc nu antzy ni bidtzu Braṉ. ");
INSERT INTO zpg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Were günahzy yâme guie par nshaꞌd yâmeu Jesúz; per Jesúz bynitylo me no güdedy me lahd yâme, byruu me idoró. ");
INSERT INTO zpg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ru gadedy Jesúz, bwieꞌ me to mpyquie ni guhl ngaḻ. ");
INSERT INTO zpg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Were ra xmeññ me leeme: ―Muextr, ¿bia nacu guhl mpyquie-rieꞌ ngaḻ lo me? ¿Por xguîlquie xtad me o xmam me la, o por xguîlquie gahcme? ");
INSERT INTO zpg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ra Jesúz leeyâme: ―Dac‑e por xguîlquie me leeu, ni dac‑e por xguîlquie xtad me ni xmam me leeu; mazyg guhl me ze lehdy güieꞌ meññ ni beeiy ctzoo Dioz no leeme. ");
INSERT INTO zpg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Leegâ nun neꞌ, rapaꞌ de ni ctzon xtziiñ Dioz ni pshahl naa, porni zdzihñ dzé ba ndruhty nehx beeiy ctzoo dziiñ. ");
INSERT INTO zpg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Leegâ nun lo guiedzylie, naa zidguiahcaꞌ beeiy byniꞌ par meññ-nu lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Byluxz günii Jesúz ze, byxîbyshieñ me lo yu, no ptzoo meu bann no güxo meu ruꞌ lo mpyquie ni ngaḻ. ");
INSERT INTO zpg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","No ra me lee: ―Güya bictiiby loꞌy ru rdohp nzeꞌ ru le Siloé ―ni rnii ne: Ni pshahl sto lee. Were güya mpyquie-caḻ ni ngaḻ, bictiiby lo; no glo gubyguiat me, ba rwieꞌ me. ");
INSERT INTO zpg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Meññ-nu yahc gahsh de ru nu mpyquie-rieꞌ, no zrieñ meññ ni nann yahc ngaḻ lo me, ne yâme: ―¿Dac‑e leeme ni rbia rnab gun la? ");
INSERT INTO zpg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nu yâme ne: ―Leeme we. Zrieñ yâme ne: ―Yac, dac‑e leeme, per rluu beeiy leeme. Per leegahcme ne: ―Naa we. ");
INSERT INTO zpg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Were ra yâme leeme: ―¿Bia mód‑e byxal loꞌy? ");
INSERT INTO zpg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ra me meññ-wé yahc: ―To mpyquie ni le Jesúz‑e ptzoo bann, no güxo meu ruꞌ dloꞌn, no ra me naa: “Güya ruꞌ nzeꞌ ni le Siloé, bictiiby loꞌy.” Were güyan, no scâsy güdiibyaꞌ dloꞌn, bwie gahcaꞌ byniꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Were ra yâme leeme: ―¿Óz me naꞌ? Ra me leeyâme: ―Nehx nannaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Luxu güiyno yâme mpyquie-guhc ngaḻ lo meññ-nac yahc fariseu. ");
INSERT INTO zpg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Guhcu to dze-risladzy meññ ni ptzoo Jesúz bann no psiaḻ me lo mpyquie-rieꞌ, ");
INSERT INTO zpg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","leewe günabdiidz meññ-nac yahc fariseu mpyquie-rieꞌ bia mód byxal lo me no ba rwieꞌ me. Ra me leeyâme: ―Güxo Jesúz bann ruꞌ dloꞌn, no luxu güdiibyaꞌ leeu, no bwie gahcaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lahd gahc meññ-nac yahc fariseu, ne yâme: ―Mpyquie-wé ni le Jesúz, nehx ziaad me de Dioz, porni nehx rlaby me dze-risladzy meññ. Zrieñ yâme ne: ―¿Bia mód beeiy ctzoo me xtahl ni ngann zâ nirieꞌ bâḻ ñahc me meññ-guîlquie? No to to yâme gydze ni rnii, no nehx güdahp yâme tohzy guîlriehñ. ");
INSERT INTO zpg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Were gyzac günabdiidz yâme mpyquie ni guhc ngaḻ, ra yâme leeme: ―Sca-ze pshal me loꞌy no rwieꞌy, ¿bia neꞌy de leeme? Ra me: ―Naa la, ren profet‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Per meññ-Isṟael ni nac guxtisy nehx bylíladzy yâme bâḻ mpyquie-rieꞌ guhc ngaḻ no naꞌ ba rwieꞌ. Were pshalcaꞌ yâme xtad me no xmam me, ");
INSERT INTO zpg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","no günabdiidz yâme leeyahc: ―¿Mpyquie-rieꞌ we xiiñ laꞌd, ni ne laꞌd guhl ngaḻ la? ¿Bia mód‑e ba rwieꞌ me? ");
INSERT INTO zpg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Xtad me no xmam me ra yâme: ―Leeme we dshiiñ noꞌ, no ngaḻ lo me dze-guhl me; ");
INSERT INTO zpg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","per nehx nann noꞌ bia mód‑e ba rwieꞌ me, ni nehx nann noꞌ dxu psiaḻ lo me. Lâ gnabdiidz leeme; ba xchoꞌ me we, beeiy ga me laꞌd xnahc biaḻ lo me. ");
INSERT INTO zpg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Xtad me no xmam me bydzie yâme, leewe günii yâme ze; porni meññ-Isṟael ni rtzoo mdad, ba ptzoo yâme diidz bâḻ dxuhch gynii Jesúz, leeme we nac Mesíaz, ba gahc gboo yâme lee idoo tohgzy. ");
INSERT INTO zpg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Leewe günii xtad me no xmam me, ne yâme: “Lâ gnabdiidz leeme; ba xchoꞌ me we.” ");
INSERT INTO zpg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Gyzac meññ-Isṟael ni rtzoo mdad, pshalcaꞌ yâme mpyquie ni gucngaḻ, no ra yâme leeme: ―Güluguia Dioz, gu noꞌ ni uli. Noꞌ nann noꞌ mpyquie-wé ni le Jesúz meññ-guîlquie we leeme. ");
INSERT INTO zpg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ra me leeyâme: ―Nehx nannaꞌ bâḻ meññ-guîlquie leeme o yac, mazyg ni nannaꞌ, ngaḻ‑e guhcaꞌ, per naꞌ ba rwien. ");
INSERT INTO zpg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Gyzac ra yâme leeme: ―¿Bia ptzoo me lii? ¿Bia mód psiaḻ me loꞌy? ");
INSERT INTO zpg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ra me leeyâme: ―Dâs‑e ba ren laꞌd, no di rieññ laꞌd. ¿Bia nacu riñlo laꞌd gyninu gyzac? ¿Racladzy laꞌd gac laꞌd xmeññ me zegahc la? ");
INSERT INTO zpg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Luxu güdeḻy yâme leeme ru günii me ze, no ra yâme leeme: ―Lii we xmeññ mpyquie-wé, per noꞌ xmeññ Moiséz‑e noꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Noꞌ nann noꞌ Dioz günii me no Moiséz; per mpyquie-wé, ni nehx nann noꞌ bá byruu me. ");
INSERT INTO zpg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ra mpyquie-rieꞌ leeyâme: ―Rtzunadzaꞌ we nehx nann laꞌd bá byruu me, no naa naꞌ, psiaḻ me dloꞌn. ");
INSERT INTO zpg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","No nann nó Dioz nehx rieññ me ni rnab meññ-guîlquie; per dxu rzacbeeiy leeme no rtzoo ni ne me, wé we rieññ me lee bia rnab. ");
INSERT INTO zpg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Glo ba xtze diaa dgueññ guieññ tzu dxuhch nsiaḻ lo meññ ni guhl ngaḻ. ");
INSERT INTO zpg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bâḻ mpyquie-wé nehx ziaad de Dioz la, zegahc‑e nehx beeiy ntzoo me mbehty ni ngann. ");
INSERT INTO zpg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ra yâme leeme: ―Lii ni nac to meññ-guîlquie glo guhliꞌ, ¿riñloꞌy gluuy noꞌ la? No güloo yâme leeme idoo tohgzy. ");
INSERT INTO zpg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Gunn Jesúz ba güloo yâme mpyquie-rieꞌ idoo tohgzy; no hor-bwieꞌ Jesúz leeme, ra leeme: ―¿Rlíladzyiꞌ Mpyquie-Pshahl Dioz Lee la? ");
INSERT INTO zpg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ra me Jesúz: ―Señor, gu naa dxu we leeme, lehdy gylídadzyaꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ra Jesúz leeme: ―Ba bwieꞌy leeme, no naa we leeme, ni ganino lii. ");
INSERT INTO zpg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Were ra me Jesúz: ―Rlídadzyaꞌ, Señor. No bisshiby me lo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Luxu ne Jesúz: ―Naa biaḻaꞌ lo guiedzylie-rieꞌ lehdy gynin ni nac meññ; dxu zidguiahc beeiy ngaḻ la, güieꞌ yâme porni rlíladzy yâme naa; no dxu ne rwieꞌ per nehx rlíladzy naa, gac beeiy ngaḻ. ");
INSERT INTO zpg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lahd meññ-nac yahc fariseu ni zu gahsh ru zu Jesúz, ru bieññ yâme ni günii me, ra yâme leeme: ―¿Neꞌy la, noꞌ we ngaḻ zegahc? ");
INSERT INTO zpg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ra Jesúz leeyâme: ―Bâḻ ñahc ngaḻ laꞌd, nehx ñahp laꞌd guîlquie; per naꞌ, gumm ne laꞌd nxal lo laꞌd la, rahp laꞌd guîlquie. ");
INSERT INTO zpg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Gapyaꞌ laꞌd ni uli, dxu nehx riuꞌ ñaz-ruꞌ xpuert corra ru riuꞌ xiily, no aaḻ riubeꞌ corra la, gübaan‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Per dxu riuꞌ ñaz-ruꞌ puert, leeme we meññ-gayahp xiily. ");
INSERT INTO zpg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","No meññ ni rahp ruꞌ puert rshal tzu me, no were rnii me to to le xiily ni nac xchieñ me, no rzaclo maꞌ xriedz me, no rboo me leeyâmaꞌ leññ corra. ");
INSERT INTO zpg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","No ru ba güloo me gyre xshiily me, riyno me leeyâmaꞌ, no ba náḻ maꞌ leeme, porni rzaclo maꞌ xriedz me. ");
INSERT INTO zpg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Per meññ-nehx rzaclo maꞌ lee, nehx ssobdiidz maꞌ lee, aaḻ sshuunn maꞌ, porni nehx rzaclo maꞌ xriedz. ");
INSERT INTO zpg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Günii Jesúz ejempl-rieꞌ, per di ñieññ yâme bia rniiu. ");
INSERT INTO zpg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Gyzac ra Jesúz leeyâme: ―Gapyaꞌ laꞌd ni uli, naa nacaꞌ beeiy to puert ñaz-ru riuꞌ xiily. ");
INSERT INTO zpg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Gyre dxu nier lee biahd que naa, gübaan‑e leeyâme; leewe di nlaby xiily leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naa nacaꞌ beeiy xpuert ru rtzoo Dioz mdad; no meññ-tzu ñaz-ruꞌ puert-rieꞌ, zlaa de lo guîlnadz ni ziaad, no zahc me beeiy xiily ni riuꞌ no rruu no rdzial ni rahgü. ");
INSERT INTO zpg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Gübaan riahd me par cuan me, no igaꞌdy me, no gnidylo me meññ; per naa ziaḻaꞌ lehdy gdedyaꞌ laꞌd guîlmbahñ ni nehx zluhx, no lehdy di guiaadz mbehty ni mos leññ xguîlmbahñ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naa nacaꞌ beeiy to meññ ni rahp xiily zaꞌgndzi. Mod-wé we nacaꞌ no dmeññaꞌ, rdedyaꞌ dguîlmbahñaꞌ gatyaꞌ por leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Per meññ ni riax no nehx rahp xiily zaꞌgndzi, ru rwieꞌ me ba ziaad lob, rsaꞌn me gyre xiily no rxuunn me, porni nehx xchieñ me leeyâmaꞌ; no lob riznáḻ maꞌ xiily, lé rgaꞌdy maꞌ lee no rchaꞌdz maꞌ lee. ");
INSERT INTO zpg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","No meññ-wé ni riax, rxuunn me porni nehx rlaby me xiily, mazyg sahc xchieñ dziiñ, wé we queꞌ ihqy me lee. ");
INSERT INTO zpg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Naa nacaꞌ beeiy meññ ni rahp xiily zaꞌgndzi; rzacloꞌn dmeññaꞌ, no leeyâme rzaclo yâme naa. ");
INSERT INTO zpg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","No mod-rzaclo dTadaꞌ naa no zegahc rzacloꞌn leeme, mod-wé gahc rzacloꞌn dmeññaꞌ, no rdedyaꞌ dguîlmbahñaꞌ gatyaꞌ por dmeññaꞌ ni zidguiahc yahc beeiy xiily. ");
INSERT INTO zpg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","No rapaꞌ zrieñ dmeññaꞌ sto lad ni nehx rzaclo laꞌd lee ni zidguiahc beeiy xiily; no dziycan leeyâme zegahc. Zieññ yâme ni gynin no ssobdiidz yâme naa, no zahc yâme tohzy cuib no gyre meññ-nu yahc neꞌ, no tohzy dxu ni gap leeyâme zaꞌgndzi. ");
INSERT INTO zpg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Leewe ndzi dTadaꞌ naa, porni rdedyaꞌ dguîlmbahñaꞌ gatyaꞌ lehdy guibyguiat ycanu. ");
INSERT INTO zpg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ndruhty nehx gboou naa, mazyg naa gahc‑e rdedyaꞌu. Beeiyu naa gdedyaꞌu, no beeiyu naa guibyguiat ycanu. Nirieꞌ we ne dTadaꞌ ctzon. ");
INSERT INTO zpg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ru bieññ meññ-Isṟael yahc ni günii Jesúz, gyzac to to yâme gydze ni rnii. ");
INSERT INTO zpg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Xtahl lahd yâme ne: ―Nu mbenahcsy leeme, leewe nguidz ihqy me. ¿Bia nacu rquee ihqy laꞌd ni ganii me? ");
INSERT INTO zpg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Per zrieñ yâme ne: ―Meññ-nu mbenahcsy lee nehx nnii mod-rnii me. ¿Nehxni beeiy nsiaḻ mbenahcsy lo meññ-ngaḻ? ");
INSERT INTO zpg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lo tiemp-ncohby, dze-rtzoo meññ-Isṟael xilni idoró Jerusaléṉ, ");
INSERT INTO zpg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","nu Jesúz ruꞌ idoró, no gadedy me ru le Xcorredor Salomóṉ. ");
INSERT INTO zpg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","No meññ-Isṟael yahc, gülu-glawy yâme leeme, no ra yâme leeme: ―¿Bucs‑e gahbyiꞌ noꞌ ni uli? Bâḻ uliu lii nac Crist, gu gahcu noꞌ togahcs. ");
INSERT INTO zpg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ra Jesúz leeyâme: ―¿Dâs ba gahc ren laꞌd la, no nehx rlíladzy laꞌd naa? Naa rtzon ni ra dTadaꞌ naa, no leeyahcu rdee diidz dxu naa; ");
INSERT INTO zpg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","per nehx rlíladzy laꞌd, porni nehx dmeññaꞌ laꞌd ni zidguiahc beeiy xiily. ");
INSERT INTO zpg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Dmeññaꞌ ni zidguiahc beeiy xiily rieññ ni rnin, no rzacloꞌn leeyâme; no ru ba zunieeraꞌ, ba náḻ yâme naa. ");
INSERT INTO zpg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","No naa gdedyaꞌ leeyâme guîlmbahñ ni nehx zluhx, no nehx znihty ni to yâme, no ndruhty nehx zboo leeyâme naa. ");
INSERT INTO zpg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","DTadaꞌ bdee leeyâme naa, no leeme ma beeiyu lee que zrieñ, no ndruhty nehx beeiy mboo leeyâme ladzyña me. ");
INSERT INTO zpg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Naa no dTadaꞌ nac noꞌ tohzy. ");
INSERT INTO zpg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Gyzac günahzy meññ-Isṟael guie par nshaꞌd yâmeu leeme. ");
INSERT INTO zpg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Per Jesúz ra leeyâme: ―DTadaꞌ gucno ptzon xtahl ni mos ni bwieꞌ laꞌd; ¿por bia de leeyahcu naꞌ, cshadguie laꞌd naa? ");
INSERT INTO zpg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ra yâme leeme: ―Dacu por behch ni mos ni ptzooy cshadguie noꞌ lii, mazyg porni rniiy didz-nahcsy contr Dioz; porni nîcze meññ-guiedzylie lii, rtzooy lii gahc Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ra Jesúz leeyâme: ―Lo leiy ni ruuḻ laꞌd lee, queꞌ ru ne Dioz: “Naa günin dioz‑e laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","(No nann nó ni rnii lo Guehtzy ru queꞌ xtiidz Dioz, nehx beeiy nniiu ni nehx uli); no Dioz güluꞌ le me dioz meññ ni cuaꞌ xtiidz me ba xtze. ");
INSERT INTO zpg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","No sca-ze Dioz güle naa no pshahl me naa lo guiedzylie, ¿bia mód‑e naꞌ, ne laꞌd naa ganin didz-nahcsy contr Dioz hor-günin Xiiñ Dioz naa? ");
INSERT INTO zpg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bâḻ nehx gatzon mod-rtzoo gahc dTadaꞌ, di gylíladzy laꞌd naa. ");
INSERT INTO zpg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Per bâḻ rtzon ni ne dTadaꞌ, nîcze nehx rlíladzy laꞌd naa, ni rtzon, wé we la, gylíladzy laꞌd lee lehdy gann laꞌd ni uliu dTad nó Dioz nu no naa, no naa nun no leeme. ");
INSERT INTO zpg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Gyzac riñlo yâme nnahzy yâme Jesúz, per bylaa me de lo ña yâme no di ñaḻu leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Luxu gubyguiat Jesúz stiby chehsh guiagü-Jordáṉ, no güyuꞌ me uga ru güyuꞌ Juaṉ antzy, dze-gachôbnihs me meññ. ");
INSERT INTO zpg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","No xtahl meññ ria ru nu Jesúz, no ne yâme: ―Juaṉ ni rchôbnihs nehx ptzoo mbehty ni ngann, per gyre ni günii me de mpyquie-rieꞌ, gyreu ni uli. ");
INSERT INTO zpg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","No uga xtahl meññ bylíladzy yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Güyuꞌ to mpyquie-gayac-ure ni le Lasr. Xguiedzy me le Betania, ru nac xguiedzy meññ-byzan me ni le Maríe no Mart. ");
INSERT INTO zpg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maríe naꞌ, byzan Lasr ni gayac-ure, leeme we ni güluꞌ ceitnixye nieꞌ Jesúz no pchee me leeu no xguitz-ihqy me. ");
INSERT INTO zpg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Gyrop meññ-ngüna-rieꞌ yahc naꞌ, pshahl yâme meññ-bigyne Jesúz, no ra yâme lee: ―Señor, xmígüiꞌ gayac-ure. ");
INSERT INTO zpg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ru bieññ Jesúz günii yâme ze, were ne me: ―Guîlguidz-wé dac‑e par igaꞌdyu leeme, mazyg par tzuguia Dioz, no zegahc por leeu tzuguia Xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","No nîcze ndzi Jesúz Mart, no Maríe no Lasr, ");
INSERT INTO zpg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","hor-ra yâme leeme gayac-ure Lasr, Jesúz nehx byruu me ru nu me, biaꞌn me schohp dzé mazy. ");
INSERT INTO zpg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Byluxu, ra Jesúz xmeññ: ―Tzo nó ṟegioṉ-Judea gyzac. ");
INSERT INTO zpg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ra xmeññ me leeme: ―Muextr, rahp doozy dzé riñlo meññ-Isṟael ni nu ñaz-wé ngaꞌdy yâme lii no guie, ¿no naꞌ neꞌy tzaꞌy uga gyzac la? ");
INSERT INTO zpg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ra Jesúz leeyâme: ―¿Dâs‑e tzipychop hór nu byniꞌ to dzé la? Dxu rzeꞌ yudzé, mbehty nehx rraḻ nieꞌ, porni rwieꞌ me byniꞌ ni nu lo guiedzylie-rieꞌ; ");
INSERT INTO zpg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","per dxu rzeꞌ guiaal, gyrehzy rraḻ nieꞌ, porni nehx nu me lo byniꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bylux günii me ze, were ra me: ―Dmígü nó Lasr ba nishcahsy, per dzicsiun lo me. ");
INSERT INTO zpg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ra xmeññ me leeme: ―Señor, bâḻ nishcahsy me, ziaḻ me we. ");
INSERT INTO zpg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesúz naꞌ gaya leeyâme de ni ba guhty Lasr, per xmeññ me nlâdzy yâme de mpcaaḻ‑e ganii Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Were ra Jesúz leeyâme nxal lo diidz: ―Lasr ba guhty. ");
INSERT INTO zpg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","No rxihlyaꞌ de ni nehx nun uga, no mod-wé ma mos par laꞌd lehdy gylíladzy laꞌd. Per tzo nó dzigüieꞌ nó leeme. ");
INSERT INTO zpg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomáz, ni ra yâme lee Dídimo (porni guhl me tohzy no sto meññ), gu me zrieñ xmeññ Jesúz: ―Tzo nó zegahc, lehdy gaty nó tohzy no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Dze-bydzihñ Jesúz Betania, ba rahp tahp dzé de ni bygaꞌdzy Lasr. ");
INSERT INTO zpg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","No Betania, riaꞌnu beeiy tzonn kilómetr de Jerusaléṉ; ");
INSERT INTO zpg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","no xtahl meññ-Isṟael riahd ridtixlo Maríe no Mart, lehdy di gzacno yâme mazy de ni guhty byzan yâme. ");
INSERT INTO zpg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Hor-gunn Mart ziaad Jesúz, güya me bigydzil-lo me lee; per Maríe, biaꞌn ruꞌ yuꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Were ra Mart Jesúz: ―Señor, bâḻ lii ñuꞌy neꞌ, nehx ñehty dsanaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Per nîcze guhcu ze, nannaꞌ Dioz‑e zdee me lii gyre ni gnabiꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ra Jesúz leeme: ―Byzaniꞌ zbahñ me we gyzac. ");
INSERT INTO zpg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ra Mart leeme: ―Nannaꞌ zbahñ me dze-gybahñ gyre mînguty dze-gydibylgaa guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Were ra Jesúz leeme: ―Naa we ni rispahñ mînguty, no naa we ni rdee guîlmbahñ ni nehx zluhx. Dxu rlíladzy naa, nîcze gaty, per zbahñ gyzac. ");
INSERT INTO zpg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","No dxu mbahñ no rlíladzy naa, nehx ziuꞌ dzé znihty. ¿Rlíladzyiꞌ ni ren lii la? ");
INSERT INTO zpg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ra Mart Jesúz: ―Rlídadzyaꞌ, Señor; naa rlídadzyaꞌ lii we nac Crist, Xiiñ Dioz, ni biahd lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bylux günii Mart ze, bigyne me Maríe ra me lee ngaꞌdzy gá: ―Muextr ba bydzihñ, no ne me tzaꞌy ru zu me. ");
INSERT INTO zpg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Scâsy bieññ Maríe ra Mart leeme ze, za gahc me zigydzil-lo me Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Dgueññ ziaꞌ gydzihñ Jesúz leññ guiedzy; zu ziaꞌ me ru bwieꞌ Mart leeme. ");
INSERT INTO zpg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Meññ-Isṟael naꞌ ni dxie yahc leññ yuꞌ no ni gayuunladzy Maríe de ni guhty byzan me, ru bwieꞌ yâme biahs me byru-güxuunn me, náḻ gahc yâme leeme, nlâdzy yâme ruꞌ baa we za me, zigyuun me. ");
INSERT INTO zpg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Hor-bydzihñ Maríe ru zu Jesúz, bisshiby gahc me lo, no ra me lee: ―Señor, bâḻ lii ñuꞌy neꞌ, nehx ñehty dsanaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ru bwieꞌ Jesúz gayuun Maríe no gayuun zrieñ meññ-Isṟael ni za no Maríe, güyuꞌ me trixd no bioobu leeme, ");
INSERT INTO zpg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","no ra me: ―¿Bá glo pcaꞌdzy laꞌd leeme? Ra yâme leeme: ―Güde güieꞌy, Señor. ");
INSERT INTO zpg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","No biin Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ra saꞌ meññ-Isṟael: ―¡Lâ güieꞌ xnahc‑e rioobu leeme Lasr! ");
INSERT INTO zpg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lahd gahc meññ-rieꞌ gaya saꞌ yâme: ―Mpyquie-rieꞌ ni psiaḻ lo ngaḻ, ¿di ñaḻ dxi nislaa me Lasr de lo guîlguhty la? ");
INSERT INTO zpg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Xroꞌ ni gayoobu Jesúz gyzac, gübigy me ma gahsh ru bygaꞌdzy Lasr. To leññ cuev‑e leeu, no ndaagu no to guie-ro. ");
INSERT INTO zpg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","No ra Jesúz leeyâme: ―Lâ gboo guie ni ndaagü ruꞌ baa. Mart, byzan Lasr ni guhty, ra me Jesúz: ―Señor, ba rahp tahp dzé de ni bygaꞌdzy me, ba nadz‑e rlaa me. ");
INSERT INTO zpg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ra Jesúz leeme: ―¿Dâs ba ren lii bâḻ gylíladzyiꞌ la, zwieꞌy xroꞌ ni rtzoo Dioz‑e? ");
INSERT INTO zpg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Were güloo yâme guie ni ndaagü ruꞌ baa. No gülesy lo Jesúz gybaa, ne me: ―Dad, rdedyaꞌ xquix lii, porni rieññiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nannaꞌ lii rieññiꞌ naa; per ren ze porni rioobaꞌ meññ-zu yahc neꞌ, no lehdy gylíladzy yâme lii we pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bylux günii me ze, günii me ma ndip, ne me: ―¡Lasr, byruu de wé! ");
INSERT INTO zpg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","No byruu gahc Lasr leññ baa no ba mbahñ me, nraḻ lahr nieꞌ me no ña me, no ndaagü lo me no sto lahr. Were ra Jesúz leeyâme: ―Lâ gboo lahr ni nraḻ me lehdy tza me. ");
INSERT INTO zpg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","No leewe, xtahl meññ-Isṟael ni biahd bidtixlo Maríe no ni bwieꞌ ni ptzoo Jesúz, bylíladzy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Per lahd gahc meññ-rieꞌ yahc güya ru nu meññ-nac yahc fariseu, no ra yâme lee ni ptzoo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Per xjefy yahc bahl no meññ-nac yahc fariseu, psieññ yâme zrieñ meññ-nac guxtisy, no bydohp yâme no lee, no ra yâme: ―¿Xnahc ctzoo nó naꞌ? Porni mpyquie-rieꞌ rtzoo me xtahl ni ngann. ");
INSERT INTO zpg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bâḻ gdee nó ñahz ctzoor me mod-rieꞌ, gyre meññ zlíladzy leeme; no luxu guiaad xsoldad meññ-Ṟom ni rtzoo mdad, guidnidylo yâme diydoró nó, no zegahc gyre dmeññ nó. ");
INSERT INTO zpg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Per to lahd yâme ni le Caifáz, ni nac xjefy gyre bahl iz-wé, ra leeyâme: ―Laꞌd nehx nann laꞌd mbehty, ");
INSERT INTO zpg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ni dgueññ guieññ laꞌd, ma mos ñehty tohzy meññ por gyre dmeññ nó, lehdy di nnihty gyre nó. ");
INSERT INTO zpg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Per Caifáz naꞌ, nehx günii me ni nehzy xguîlriehñ me, mazyg porni leeme nac xjefy gyre bahl iz-wé, leewe bisnii Dioz leeme de ni gaty Jesúz por gyre meññ-Isṟael; ");
INSERT INTO zpg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","no nehx nunzy por gyre meññ-Isṟael, mazyg zegahc lehdy gydohp gyre xiiñ Dioz tohzy ni nu byzaꞌzy. ");
INSERT INTO zpg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","No glohdy dze-wé, gyre meññ-Isṟael ni rtzoo mdad, ptzoo yâme diidz igaꞌdy yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","No leewe, Jesúz ba nehx rzeꞌ me neññ lahd meññ-Isṟael; beeiydí byruu me ru nac ṟegioṉ-Judea, no za me coo yu-bihdzy, sto guiedzy ni le Efraíṉ. Uga güyuꞌ me no xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ba bydziñgahsh lni-Pascü ni rtzoo meññ-Isṟael, no xtahl yâme ni nu zrieñ guiedzy, za yâme Jerusaléṉ antzy ni gac lni par gacnyar yâme lehdy guiaꞌn yâme mos lo Dioz, mod-rtzoo gahc yâme xtâ ba xtze diaa. ");
INSERT INTO zpg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","No gayohdy yâme Jesúz, no ganabdiidz saꞌ yâme ruꞌ idoró: ―¿Bia ne laꞌd? ¿Siahd me we lo lni la? ");
INSERT INTO zpg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Xjefy yahc bahl no zrieñ meññ-nac yahc fariseu, psieññ yâme meññ, bâḻ dxuhch gann bá glo nu Jesúz, guidne leeyâme, lehdy gynahzy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Shoꞌb dzé antzy ni gac lni-Pascü, güya Jesúz guiedzy-Betania, ru nu Lasr ni bispahñ me lee de ni guhty. ");
INSERT INTO zpg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Uga ptzoo yâme to guîlrotzie, porni bydzihñ Jesúz; Mart gabahqy ni gahgü yâme, no Lasr dxie lahd meññ-dxie ruꞌ miax no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bidno Maríe beeiy glaꞌy litr ceitnixye ni güyaa no ni le nardo ni nehx nutz mbehty, no ni modni xguiaꞌ. Güluꞌ meu nieꞌ Jesúz, no luxu pchee meu no xguitz-ihqy me. No gucnixye gydo leññ yuꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","No to xmeññ Jesúz, ni le Jud-Iscariot, ni gdee Jesúz lo ña meññ-rdziadzyno lee, günii me, ne me: ");
INSERT INTO zpg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Bia nacu di ndoꞌ ceit-wé sahc xchieñ tzonn gayuu xdzé dziiñ, lehdy ñacnou meññ-pobr? ");
INSERT INTO zpg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Per Jud günii me ze, dac porni ndzi me meññ-pobr, mazyg porni gübaan leeme, no lo ña me nu bush ru nu xmedy yâme, no rban me lo medy ni rguꞌ yâme leññ bush. ");
INSERT INTO zpg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Were ra Jesúz leeme: ―Bdee ñahz leeme; nirieꞌ gülutziaawy meu we par dze-igaꞌdzyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Meññ-pobr, tirgahc‑e nu yâme lahd laꞌd, per naa nehx ziunon laꞌd tirgahc. ");
INSERT INTO zpg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Xtahl meññ-Isṟael gunn nu Jesúz guiedzy-Betania, no güya yâme uga, nehx nunzy par güieꞌ yâme Jesúz, mazyg zegahc par güieꞌ yâme Lasr ni bispahñ Jesúz lee de ni guhty. ");
INSERT INTO zpg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Leewe xjefy yahc bahl ptzoo yâme diidz ngaꞌdy yâme Lasr zegahc, ");
INSERT INTO zpg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","porni por xtoḻ me xtahl meññ-Isṟael ba nehx rlaby yâme xjefy yahc bahl, no ba galíladzy yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ni byre guiaal, xtahl meññ ni za lni-Pascü, ru bieññ yâme ziaad Jesúz Jerusaléṉ, ");
INSERT INTO zpg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","cuaꞌ yâme xguix yag-zihñ bigydzil-lo yâme leeme, no rquee yâme riedz, ne yâme: ―¡Tzuguia Dioz! ¡Nu laꞌy mpyquie ni ziaad porni pshahl Dioz leeme! ¡Nu laꞌy xṞeiy meññ-Isṟael! ");
INSERT INTO zpg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","No bydzial Jesúz to burr-wiñ, güdzib me lee, mod-rnii lo Guehtzy ru queꞌ xtiidz Dioz, ru neu: ");
INSERT INTO zpg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Di gydzie laꞌd, meññ-guiedzy-Sióṉ; lâ güieꞌ xṞeiy laꞌd ziaad, dziib to burr-wiñ. ");
INSERT INTO zpg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Leññ dze-guzlo gayahc gyre nirieꞌ, xmeññ Jesúz nehx bieññ yâmeu; per güdedy dze-wé yahc ru ba gübahñ Jesúz no biahs me zia me lo guîlbyniꞌ gybaa, were bitsêlou leeyâme de ni nirieꞌ yahc ni guhc, nuw lo Guehtzy ru queꞌ xtiidz Dioz, ru ganiiu ni ctzoo Jesúz no ni gac me. ");
INSERT INTO zpg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","No meññ-güya yahc ruꞌ baa no Jesúz dze-pquee me riedz Lasr, ru nu leññ baa no gübahñ de ni guhty, leeyâme gayu diidz ni bwieꞌ yâme ptzoo Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","No por leeu, meññ-bieññ yahc nirieꞌ ni ngann ni ptzoo Jesúz, güya yâme, bigydzil-lo yâme leeme ru ziaad me Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Per meññ-nac yahc fariseu ra saꞌ yâme: ―Ba bwieꞌ laꞌd la, di zaḻ ctzoo nó mbehty. Lâ güieꞌ, xnahc gyre meññ gadohp leeme. ");
INSERT INTO zpg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Zegahc za chohp tzonn meññ-nehx meññ-Isṟael, ni nac meññ-griegü, lahd gyre meññ-zigzacbeeiy Dioz lo lni-Pascü. ");
INSERT INTO zpg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Meññ-rieꞌ byo yâme Felipy, to meññ-byruu guiedzy-Betsaida ni nu lo ṟegioṉ-Galilea, no ra yâme leeme: ―Señor, racdadzy noꞌ gzaclo noꞌ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Were güya Felipy, no ra meu Ndréz; no luxu, za gyrop yâme zigyne yâmeu Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ra Jesúz leeyâme: ―Naa we Mpyquie-Pshahl Dioz Lee, no ba bydzihñ dze-tzuguian. ");
INSERT INTO zpg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Gapyaꞌ laꞌd ni uli, bâḻ to ladzy trigü di gacu beeiy ni guhty no gutz yu leeu la, tirgahc‑e tohzyu; per bâḻ gutz yu leeu, were rlahñu no racxtahlu. ");
INSERT INTO zpg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Dxu ne ma rsahc xguîlmbahñ, zniꞌdyu; per dxu ne nehx rsahc xguîlmbahñ lo guiedzylie-rieꞌ no gzoob dtiidzaꞌ, nehx zniꞌdyu mazyg scaꞌ me guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Dxu riuꞌladzy ctzoo dixtziñaꞌ, ctzoo ni ren; no ru tzun, wé we ziuꞌ dxu gatzoo dixtziñaꞌ. No dxu rtzoo dixtziñaꞌ, zguguia dTadaꞌ lee. ");
INSERT INTO zpg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Hôrrieꞌ nu to ni ndzieeby leññ diqyaꞌ. ¿No biaz‑e naꞌ nnin? ¿Ñapyaꞌ la: “Dad, bislaa naa de lo ni nadz ni dzictedyaꞌ”? Per par leegahcu we biaḻaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dad, güluguia ley. Tohzy bieññ to riedz gybaa, ne: ―Ba güluguianu, no zguguianu sto. ");
INSERT INTO zpg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Meññ-bieññu ni zu yahc uga, ne yâme ngüziee we günii, no zrieñ yâme ne: ―To ángel‑e günino leeme. ");
INSERT INTO zpg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Were ra Jesúz leeyâme: ―Dac‑e por naa bieññ riedz-rieꞌ, mazyg por laꞌd‑e. ");
INSERT INTO zpg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ba bydzihñ dzé lehdy gac guîlguxtisy chehsh meññ-nu lo guiedzylie-rieꞌ; no bêndzab ni rtzoo mdad lo guiedzylie-rieꞌ, ba bydzihñ dze-gyruu me diby lad. ");
INSERT INTO zpg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Per dze-ba biasaꞌ de lo guiedzylie, squeen riedz gyre meññ guiaad ru nun. ");
INSERT INTO zpg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mod-rieꞌ günii Jesúz bia mód gaty me. ");
INSERT INTO zpg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ra meññ-wé yahc leeme: ―Noꞌ nann noꞌ leiy ganiiu, nehx zehty Crist. ¿Bia mód naꞌ neꞌy, rahp Mpyquie-Pshahl Dioz Lee de ni guiahs? ¿Dxu we leeme Mpyquie-Pshahl Dioz Lee? ");
INSERT INTO zpg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ra Jesúz leeyâme: ―Hôrrieꞌ nu ni nac beeiy byniꞌ ru nu laꞌd stoozy dzé. Lâ tzu lou leegâ nuw no laꞌd, lehdy di tzu laꞌd beeiy lo guibcawy; porni dxu nu beeiy lo guibcawy, nehx nann bá za. ");
INSERT INTO zpg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Leegâ nun no laꞌd, lâ gylíladzy naa ni nac beeiy byniꞌ, lehdy gac laꞌd meññ ni nu lo byniꞌ. Bylux günii Jesúz ze, byruu me no güyungaꞌdzy me. ");
INSERT INTO zpg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nîcze gatzoo Jesúz xtahl ni ngann bwieꞌ yâme, per nehx rlíladzy yâme leeme, ");
INSERT INTO zpg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","lehdy gac ni bzaa profet-Isaíaz, ru günii me: Señor, ¿dxu bylíladzy xtiidziꞌ ni ganii noꞌ? ¿No dxu ba nann ni beeiyu lii? ");
INSERT INTO zpg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Leewe di raḻ gylíladzy yâme, porni zegahc günii profet-Isaíaz, ne me: ");
INSERT INTO zpg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dioz ptzoo leeyâme beeiy ngaḻ, no ptzunahdy xguîlmbahñ yâme; lehdy di güieꞌ yâme, ni di gann yâme zaꞌgndzi, ni di gyo yâme naa par nistziawyaꞌ xguîlmbahñ yâme, no nsiaḻaꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Günii Isaíaz nirieꞌ, porni ma antzy diaa bwieꞌ me xguîlbyniꞌ Jesúz, no günii meu. ");
INSERT INTO zpg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Xtahl meññ-Isṟael bylíladzy yâme Jesúz ru bieññ yâme nirieꞌ, xtâ no lahd meññ-nac yahc guxtisy. Per por zrieñ meññ-nac yahc fariseu, ni rdzie yâme lee gboo leeyâme idoo tohgzy, di ne yâme gynii mbehty; ");
INSERT INTO zpg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","porni ma riuꞌladzy yâme guiaꞌn yâme mos no meññ, no dac no Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Günii Jesúz ndip, ne me: ―Dxu rlíladzy naa, nehx rlíladzy nunzy naa, mazyg rlíladzy me dTadaꞌ ni pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","No dxu rzaclo naa, rzaclo me dTadaꞌ ni pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naa nacaꞌ beeiy byniꞌ, no biaḻaꞌ lo guiedzylie lehdy dxu gylíladzy naa nehx ziaꞌn me beeiy lo guibcawy. ");
INSERT INTO zpg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Per dxu rieññ dtiidzaꞌ no nehx ctzoo mod-neu, dac‑e naa ni ctzoo guîlguxtisy chehsh yâme; porni dac‑e biaḻaꞌ par gnityaꞌ meññ lo xguîlquie, mazyg biaḻaꞌ we par guislaan leeyâme de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Dxu nehx riuꞌladzy no di ne ctzoo ni ren, rahp me dxu ctzoo guîlguxtisy chehsh me: diidz ni ba günin, leegahcu we ctzoo guîlguxtisy chehsh me dze-gydibylgaa guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Naa dac‑e ni ne dguîlriehñaꞌ rnin; dTadaꞌ ni pshahl naa, wé we ptzoo mdad bia gynin no bia glun meññ. ");
INSERT INTO zpg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","No nannaꞌ ni rtzoo dTadaꞌ mdad ctzoo meññ, rdeedyu guîlmbahñ ni nehx zluhx. Leewe ni rnin, niwé gahc ne dTadaꞌ gynin. ");
INSERT INTO zpg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Antzy ni gydzihñ lni-Pascü, Jesúz nann me ba bydzihñ dzé ni gyruu me guiedzylie-rieꞌ no gybiꞌ me ru nu xTad me. No leeme bintzi me xmeññ me ni nu lo guiedzylie, mod-wé gahc ndzi me leeyâme xtâ glo dze-guhty me. ");
INSERT INTO zpg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ru gayagü-tzie yâme we naꞌ, ba güluꞌ bêndzab guîlrieñ-nahcsy leññ xguîlmbahñ Jud-Iscariot, xiiñ Simóṉ, lehdy gdee me Jesúz lo ña meññ-rdziadzyno Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Per Jesúz naꞌ, nann me ba psaꞌn xTad me gyreu lo ña me lehdy ctzoo me mdad, no nann me byruu me ru nu Dioz, no ru nu gahc Dioz guibyguiat me. ");
INSERT INTO zpg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Leewe ru gayahgü yâme, biahs me, no güloo me lar-nutz me xtziguia, cuaꞌ me to toall, blihby me xigülaan me. ");
INSERT INTO zpg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Luxu güluꞌ me nzeꞌ leññ to mbras, no guzlo güdihby me nieꞌ xmeññ me, no gasiab meu no toall ni blihby me xigülaan me. ");
INSERT INTO zpg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ru ba dzictiiby me nieꞌ Pedr‑e naꞌ, ra Pedr leeme: ―Señor, ¿aaḻ lii quiibyiꞌ dnien la? ");
INSERT INTO zpg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ra Jesúz leeme: ―Ni gatzon hôrrieꞌ nehx rieññiꞌu; sto dzé were zanniꞌ bia nacu. ");
INSERT INTO zpg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ra Pedr leeme: ―Nehx beeiy gdedyaꞌ ñahz quiibyiꞌ dnien. Ra Jesúz leeme: ―Bâḻ di quiibyaꞌ nieꞌy la, di zaḻ gacriꞌ dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Were ra Pedr leeme: ―Señor, ¡di quiibyiꞌ nunzy dnien, güdihby dñan no diqyaꞌ zegahc! ");
INSERT INTO zpg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ra Jesúz leeme: ―Dxu leer guhz, nunzy nieꞌ guiar, porni nter me nyar; no ba nyar laꞌd‑e, nîcze dac gyre laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesúz naꞌ, nann me dxu de xmeññ me gdee leeme lo ña meññ-rdziadzyno leeme, leewe günii me: “Nîcze dac gyre laꞌd nyar.” ");
INSERT INTO zpg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","No byluxz güdihby Jesúz nieꞌ xmeññ me, bihtz me shab-ruhtz me xtziguia, no gürie me ruꞌ miax gyzac, no luxu, ra me leeyâme: ―¿Nann laꞌd bia ptzon no laꞌd la? ");
INSERT INTO zpg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ra laꞌd naa Muextr, no ra laꞌd naa Señor; no xñahzu mod-ne laꞌd, porni ze leeu. ");
INSERT INTO zpg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","No sca-ze naa, ni nac Señor no ni nac Muextr, güdiibyaꞌ nieꞌ laꞌd, no zegahc‑e laꞌd quiiby nieꞌ saꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ba blun laꞌd xnahc ptzon, lehdy ctzoo laꞌd mod-ptzo gahcaꞌ no laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gapyaꞌ laꞌd ni uli, to mós dac‑e ma rsahc me que patróṉ; no meññ-ria mdad dac‑e ma rsahc me que meññ-rshahl leeme. ");
INSERT INTO zpg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bâḻ rieññ laꞌd gyre nirieꞌ, no ctzoo laꞌdu, dxu ñahc beeiy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Nehx ganin de gyre laꞌd; nannaꞌ dxu gyre güleꞌn lee. Per rahp de ni gac ni rnii lo Guehtzy ru queꞌ xtiidz Dioz, ru neu: “Ni rahgü tohzy no naa, byruu me contr naa.” ");
INSERT INTO zpg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ba gahc gayapyaꞌnu laꞌd‑e, lehdy hor-ba gayahcu, gylíladzy laꞌd naa we ni ba gahc nu. ");
INSERT INTO zpg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gapyaꞌ laꞌd ni uli, dxu rcaꞌ xtiidz meññ-gashaalaꞌ, rcaꞌ me dtiidzaꞌ; no dxu rcaꞌ dtiidzaꞌ la, rcaꞌ xtiidz Dioz ni pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bylux günii Jesúz ze, gyzac ra me no xroꞌ guîlrioob: ―Gapyaꞌ laꞌd ni uli, to de lahd laꞌd gdee naa lo ña meññ-rdziadzyno naa. ");
INSERT INTO zpg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Were guzlo gawieꞌ lo saꞌ xmeññ me, no ne yâme de dxu we ne me, gdee leeme lo ña meññ-rdziadzyno leeme. ");
INSERT INTO zpg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","To de lahd xmeññ me ni ndzi me lee, ni dxie coo me ruꞌ miax, ");
INSERT INTO zpg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ptzoo Simoṉ-Pedr señ lehdy gnabdiidz dxu de lee ganii me. ");
INSERT INTO zpg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Were güriequeꞌ me Jesúz, no ra me lee: ―Señor, ¿dxu we leeme ni neꞌy gdee lii lo ña meññ-rdziadzyno lii? ");
INSERT INTO zpg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ra Jesúz leeme: ―Cunisaꞌ diby laꞌy paṉ, no dxu gdedyaꞌu lee, wé we leeme. No gülunihs Jesúz diby laꞌy paṉ no bdee meu Jud, xiiñ Simoṉ-Iscariot. ");
INSERT INTO zpg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","No scâsy cuaꞌ Jud paṉ, güyuꞌ bêndzab xguîlmbahñ me. Were ra Jesúz leeme: ―Ni dzictzooy, ptzoo leeu ngueeḻy gahc. ");
INSERT INTO zpg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Per ndruhty de leeyâme ni dxie yahc ruꞌ miax di ñieññ bia nacu ra Jesúz leeme ze. ");
INSERT INTO zpg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gumm lo ña Jud nu bush ni nu xmedy yâme leññ la, leewe lahd yâme nlâdzy gaya Jesúz leeme ssii me behch par lo lni-Pascü, o gdee me behch ycaꞌ meññ-pobr. ");
INSERT INTO zpg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Bylux güdahgü Jud paṉ-caḻ, byruu gahc me, za me; no hor-wé ba güyuꞌ guiaal. ");
INSERT INTO zpg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bylux byruu Jud, ra Jesúz: ―Naa we Mpyquie-Pshahl Dioz Lee, no ba bydzihñ hor-guieññ riuguian, no por naa zegahc zieññ riuguia Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","No sca-ze riuguia Dioz por naa, zegahc‑e Dioz gahc zguguia me naa, no stzoo meu ngueeḻy gahc. ");
INSERT INTO zpg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Shiꞌñ, ba nehx ziun no laꞌd mazy. Zyo laꞌd naa, per mod-re gahcaꞌ meññ-Isṟael, gayapyaꞌ laꞌd hôrrieꞌ: Nehx beeiy tza laꞌd ru tzan. ");
INSERT INTO zpg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ni gatzon mdad ctzoo laꞌd, to nicoby‑e leeu: Lâ guîntzi saꞌ laꞌd; no mod-ndzi gahcaꞌ laꞌd, mod-wé lâ guîntzi saꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","No bâḻ ndzi saꞌ laꞌd, were gyre meññ zwieꞌ dmeññaꞌ we laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ra Simoṉ-Pedr Jesúz: ―Señor, ¿bá tzaꞌy? Ra Jesúz leeme: ―Ru tzan, nehx beeiy tzaꞌy no naa ngâstoo. Per gapru dzé were tzaꞌy. ");
INSERT INTO zpg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ra Pedr leeme: ―Señor, ¿bia nacu di zaḻ tzan no lii ngâstoo? ¡Naa gatyaꞌ por lii! ");
INSERT INTO zpg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ra Jesúz leeme: ―¿Neꞌy gatyiꞌ por naa la? Gapyaꞌ lii ni uli: Ni dgueññ ziaꞌ cuiadz rig, lii ba tzonn vuelt güniiy nehx rzacloꞌy naa. ");
INSERT INTO zpg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Di cu ihqy laꞌd mbehty. Lâ gylíladzy Dioz, no lâ gylíladzy naa zegahc. ");
INSERT INTO zpg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Leññ xiryuꞌ dTadaꞌ nu xtahl yuꞌ ru tzu meññ; no bâḻ di ñahcu ze, nehx ñapyaꞌ laꞌd tzan dziguistziawyaꞌ to ru tzu laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","No luxz tzan dziguistziawyaꞌ ru tzu laꞌd, guiaḻaꞌ gyzac guidcan laꞌd, lehdy tzu laꞌd ru tzu gahcaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","No nann laꞌd bá glo tzan, no nann laꞌd ñahz ni za ru tzan. ");
INSERT INTO zpg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ra Tomáz leeme: ―Señor, nehx nann noꞌ bá tzaꞌy. ¿Bia mód‑e gann noꞌ ñahz? ");
INSERT INTO zpg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ra Jesúz leeme: ―Naa we beeiy to ñahz, no rlun ni uli, no rdedyaꞌ guîlmbahñ ni nehx zluhx. Ndruhty nehx zdzihñ ru nu dTadaꞌ bâḻ di gacu por naa. ");
INSERT INTO zpg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bâḻ rzaclo laꞌd naa, zegahc‑e ssaclo laꞌd dTadaꞌ; no glohg hôrrieꞌ ba gazaclo laꞌd leeme, porni gawieꞌ laꞌd leeme. ");
INSERT INTO zpg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ra Felipy leeme: ―Señor, bluu noꞌ xTadiꞌ, no niwéhzy‑e racdadzy noꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ra Jesúz leeme: ―Felipy, ba xtze nun no laꞌd, ¿no nehx rzacloꞌy naa la? Dxu rwieꞌ naa, rwieꞌ dTadaꞌ; ¿bia nacu neꞌy: “Bluu noꞌ xTadiꞌ”? ");
INSERT INTO zpg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Nehx rlíladzyiꞌ la, naa nunon dTadaꞌ, no leeme nuno me naa? Gyre ni ren laꞌd, dac‑e renu laꞌd ni ne dguîlriehñaꞌ, mazyg dTadaꞌ ni nuno naa, wé we rtzoo gyreu. ");
INSERT INTO zpg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Lâ gylíladzy naa de ni nunon dTadaꞌ, no leeme nuno me naa; o bâḻ yac, lâ gylíladzy naa por gyre ni rtzon. ");
INSERT INTO zpg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Gapyaꞌ laꞌd ni uli: dxu rlíladzy naa, ni rtzon, stzoo meu zegahc; no ma xtahl ni stzoo me, porni naa tzan ru nu dTadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Naa stzon gyre ni gnab laꞌd por dlen, lehdy tzuguia dTadaꞌ por naa. ");
INSERT INTO zpg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nitisy gnab laꞌd por dlen, naa stzonu. ");
INSERT INTO zpg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Bâḻ ndzi laꞌd naa, lâ ctzoo ni rtzon mdad ctzoo meññ. ");
INSERT INTO zpg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","No naa gnabaꞌ dTadaꞌ, no cshahl me sto ni gacno laꞌd no tirgahc tzu no laꞌd: ");
INSERT INTO zpg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","wé we xiSpirt Dioz ni gluu laꞌd ni uli. Wé nehx ziuno meññ-nu lo guiedzylie ni nehx xmeññ Dioz lee, porni nehx rwieꞌ yâme no nehx rzaclo yâme lee. Per laꞌd naꞌ, rzaclo laꞌd xiSpirt Dioz, porni lee nuno laꞌd no ziuno laꞌd tirgahc. ");
INSERT INTO zpg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nehx ssanaꞌ laꞌd nunzy laꞌd; guibyguiataꞌ lehdy tzunon laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Leññ doozy hór, zrieñ meññ-nu lo guiedzylie ba nehx zwieꞌ yâme naa, per laꞌd zwieꞌ laꞌd naa; no porni gybahñaꞌ gyzac, leewe laꞌd zegahc zbahñ laꞌd gyzac. ");
INSERT INTO zpg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dze-wé ni gybahñaꞌ gyzac, zann laꞌd naa nunon dTadaꞌ, no laꞌd nunot naa, no naa nunon laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Dxu nann ni rtzon mdad ctzoo meññ, no rzobdiidz meu, wé we ndzi naa. No dTadaꞌ ndzi me meññ-ndzi naa, no naa zegahc ndzin meññ-ndzi naa, no glun leeme dxu we naa. ");
INSERT INTO zpg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Günabdiidz Jud Jesúz (per dac Jud-Iscariot), ra me: ―Señor ¿bia nacu noꞌ zwieꞌ noꞌ lii, no zrieñ meññ-nu lo guiedzylie nehx zwieꞌ lii? ");
INSERT INTO zpg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ra Jesúz leeme: ―Dxu ndzi naa, wé we ssoob dtiidzaꞌ; no ndzi dTadaꞌ lee, no ziuꞌ noꞌ no lee tohzy no dTadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Dxu nehx ndzi naa, nehx rzoob dtiidzaꞌ. No diidz ni ren laꞌd, dac‑e ni ne dguîlriehñaꞌ leeu, mazyg dTadaꞌ ni pshahl naa, wé we ra naa gynin ze. ");
INSERT INTO zpg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Gyre nirieꞌ gayapyaꞌ leegâ nun no laꞌd; ");
INSERT INTO zpg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","per Spirt-Sant ni cshahl dTadaꞌ lee gacno laꞌd dilgaraꞌ, wé we gluu laꞌd gyre cos, no ga laꞌd gyzac ni ba ren laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Naa cun xguîlmbahñ laꞌd dzie tziaawy; no nehx stzonu beeiy rtzoo meññ-nu lo guiedzylie. Di cu ihqy laꞌd mbehty, ni di gydzie laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ba bieññ laꞌd ni ren laꞌd: “Tzan no guibyguiataꞌ lehdy tzunon laꞌd gyzac.” Bâḻ ulihbu ndzi laꞌd naa, sshihly laꞌd‑e de ni ba nann laꞌd tzan ru nu dTadaꞌ, porni leeme we rtzoo mdad naa. ");
INSERT INTO zpg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ba gahc gayapyaꞌnu laꞌd‑e antzy ni gacu, were ru ba gayahcu, gylíladzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ba di zaḻ zniraꞌ mazy no laꞌd, porni ziaad ni rtzoo mdad lo guiedzylie-rieꞌ, per no naa di zaḻu leeme. ");
INSERT INTO zpg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Mazyg racladzyu gacu ze lehdy gann meññ rzacbeeiyaꞌ dTadaꞌ no rtzon ni gu me naa ctzon. Lâ guiahs, tzoꞌ de neꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","No ne Jesúz: ―Naa we ni ulihbu beeiy to xan blatzy, no dTadaꞌ we ni rixye leeu. ");
INSERT INTO zpg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Gyre xúzu ni nehx rqueꞌ, rchug meu, no gyre ni rqueꞌ, rixye meu lehdy yqueꞌu mazy. ");
INSERT INTO zpg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Laꞌd naꞌ, ba nye xguîlmbahñ laꞌd por dtiidzaꞌ ni ba ren laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Lâ tzu tohzy no naa, mod-nun tohzy no laꞌd. To xúz blatzy ni ba byrug nehx beeiy nqueꞌu; no zegahc‑e laꞌd, nehx beeiy ntzoo laꞌd mbehty bâḻ nehx nu laꞌd tohzy no naa. ");
INSERT INTO zpg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Naa we beeiy to xan blatzy, no laꞌd‑e beeiy xúzu. Dxu nu tohzy no naa, no nun tohzy no lee, wé we beeiy xúzu ni rqueꞌ xtahl, porni bâḻ di tzu laꞌd tohzy no naa, nehx beeiy ctzoo laꞌd mbehty. ");
INSERT INTO zpg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Dxu di tzu tohzy no naa ssahby diby lad no zbihdzy, beeiy xúz yahc ni rdohp no rqueꞌ gue lee. ");
INSERT INTO zpg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Bâḻ di csaꞌn laꞌd de ni nu laꞌd tohzy no naa, no ctzoo laꞌd gyre ni rlun laꞌd, lâ gnab nitisy racladzy laꞌd, no scaꞌ laꞌdu. ");
INSERT INTO zpg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","No riuguia dTadaꞌ bâḻ gatzoo laꞌd ze, no were neññ ulihbu dmeññaꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mod-ndzi dTadaꞌ naa, mod-wé gahc ndzin laꞌd; di csaꞌn laꞌd guîlndzi ni rapaꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bâḻ rtzoo laꞌd ni rtzon mdad ctzoo meññ, were neññ nu laꞌd lo guîlndzi ni rapaꞌ laꞌd, mod-naa no dTadaꞌ, rtzon ni rtzoo me mdad, no nun lo xguîlndzi me. ");
INSERT INTO zpg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ren laꞌd nirieꞌ yahc lehdy gyxihly laꞌd mod-gaxihly gahcaꞌ, no lehdy tzu laꞌd no guîlrxihly. ");
INSERT INTO zpg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nirieꞌ we ni gatzon mdad ctzoo laꞌd: Guîntzi saꞌ laꞌd mod-ndzi gahcaꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Guîlndzi ni ma xroꞌ, leeu we de ni gdee mu xguîlmbahñ mu por xmígü mu. ");
INSERT INTO zpg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bâḻ ctzoo laꞌd ni gatzon mdad laꞌd, were dmíguaꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ba nehx znin dmósaꞌ laꞌd, porni meññ-nac mós ni rtzoo xtziiñ meññ, nehx nann yâme ni rtzoo xpatróṉ yâme. Rnin dmíguaꞌ laꞌd, porni ba ren laꞌd gyre ni ra dTadaꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Dac‑e laꞌd güle naa, mazyg naa we güleꞌn laꞌd, lehdy tza laꞌd no gyruqueꞌ ni ctzoo laꞌd, no nehx znihtyu. No mod-wé, nitisy gnab laꞌd lo dTadaꞌ por dlen, zdee meu laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nirieꞌ we ni gatzon mdad ctzoo laꞌd: Lâ guîntzi saꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Bâḻ meññ-nu lo guiedzylie néladzy yâme laꞌd la, lâ gann nier naa we gucnéladzy yâme. ");
INSERT INTO zpg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bâḻ ñahc laꞌd de leeyâme la, nîntzi yâme laꞌd, mod-ndzi gahc saꞌ yâme. Per naa güleꞌn laꞌd lahd yâme, leewe néladzy yâme laꞌd, porni ba nehx rtzoo laꞌd mod-rtzoo gahc yâme. ");
INSERT INTO zpg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Lâ guitsêlou laꞌd diidz ni ren laꞌd: “To mós, dac‑e ma rsahc me que patróṉ.” Bâḻ bgultihp yâme naa, zegahc‑e zgultihp yâme laꞌd; bâḻ biuꞌladzy yâme dtiidzaꞌ, zegahc‑e ziuꞌladzy yâme xtiidz laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Gyre nirieꞌ stzoo yâme laꞌd porni nac laꞌd dmeññaꞌ, no porni nehx rzaclo yâme dTadaꞌ ni pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Bâḻ naa di ñaḻaꞌ ñunon diidz leeyâme, nehx ñahp yâme guîlquie. Per naꞌ, ba nehx nu guîlrioob no leeyâme por xguîlquie yâme. ");
INSERT INTO zpg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Dxu néladzy naa, zegahc‑e néladzy yâme dTadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nehx ñahp yâme guîlquie bâḻ naa nehx ptzon lahd yâme mbehty ni ngann ni nehx beeiy ntzoo zrieñ meññ. Per naꞌ ba bwieꞌ yâme gyre ni ptzon, no nîcze ze leeu, néladzy yâme naa no néladzy yâme dTadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Per nirieꞌ gacu ze lehdy gac ni rnii lo xleiy yâme, ru queꞌu: “Nehx gatzon leeyâme mbehty, per néladzy yâme naa.” ");
INSERT INTO zpg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Dze-guiaad to ni gacno laꞌd, ni gdee dTadaꞌ no cshaalaꞌ lee, wé we xiSpirt me ni gluu laꞌd ni uli, wé we zdee diidz de naa. ");
INSERT INTO zpg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","No laꞌd zegahc zdee diidz de naa, porni nu laꞌd no naa xtâ dze-guzloꞌn. ");
INSERT INTO zpg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Gayapyaꞌ laꞌd nirieꞌ lehdy di yqueꞌladzy laꞌd mbehty. ");
INSERT INTO zpg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Zboo yâme laꞌd idoo tohgzy, no zdzihñ dzé xtâ no igaꞌdy yâme laꞌd; no nitisy dxu ctzoo ze, nlâdzy yâme mod-wé racladzy Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ctzoo yâme ze, porni nehx rzaclo yâme naa, no nehx rzaclo yâme dTadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ren laꞌd nirieꞌ lehdy dze-ba gayahcu, guitsêlou laꞌd ba renu laꞌd‑e. ’Nehx gutzyaꞌ laꞌd nirieꞌ antzy, porni nu ziaꞌraꞌ no laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Per hôrrieꞌ tzan ru nu dTadaꞌ ni pshahl naa, no ndruhty de laꞌd nehx rnabdiidz naa bá tzan; ");
INSERT INTO zpg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","mazyg nu laꞌd trixd, porni ren laꞌd ze. ");
INSERT INTO zpg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Per gapyaꞌ laꞌd ni uli: Naa tzan lehdy tzu laꞌd ma mos. Porni bâḻ naa di tzan la, nehx siahd xiSpirt Dioz ni gacno laꞌd. Ru ba zan, wé cshaalaꞌ lee. ");
INSERT INTO zpg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","No dze-guiaad xiSpirt me, wé zluu meññ-nu lo guiedzylie de ni nu yâme lo guîlquie, no de bia leeu ni nac xñahzû, no de ni rahc xguîlguxtisy Dioz. ");
INSERT INTO zpg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Lguia ni nu yâme lo guîlquie we porni nehx rlíladzy yâme naa; ");
INSERT INTO zpg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","lguia bia leeu ni nac xñahzû we porni tzan ru nu dTadaꞌ no ba di zwieꞌ laꞌd naa. ");
INSERT INTO zpg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","No lguia rahc xguîlguxtisy Dioz‑e porni bêndzab, ni rahc ni rnii lo guiedzylie-rieꞌ, ba ptzoo Dioz guîlguxtisy chehsh me. ");
INSERT INTO zpg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Nu xtahl ni ñapyaꞌ laꞌd, per hôrrieꞌ nehx ziaꞌn gyreu leññ ihqy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dze-guiaad xiSpirt Dioz, ni rnii gahc pur ni uli, wé we gluu laꞌd gyre ni uli; porni nehx zniiu nunzy ni ne xguîlriehñu, mazyg gyre ni rieññu, wé we gdeeu diidz zegahc, no zluuw laꞌd ni dziguiahcr. ");
INSERT INTO zpg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Leeu zguguiau naa, porni zluuw laꞌd dtiidzaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Gyre ni rahp dTadaꞌ, zegahc dixchieñaꞌ leeyahcu; no leewe ren laꞌd xiSpirt me zluuw laꞌd dtiidzaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Leññ doozy dzé, ba di zwieꞌ laꞌd naa; per tedy stoozy dzé gyzac zwieꞌ laꞌd naa, porni tzan ru nu dTadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Guzlo lahd xmeññ me ganabdiidz saꞌ: ―¿Bia leeu ni ne me ze? Leññ doozy dzé ba di zwieꞌ nó leeme, per tedy stoozy dzé gyzac zwieꞌ nó leeme, no de ni ne me tza me ru nu xTad me. ");
INSERT INTO zpg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Bia leeu ni ne me “leññ doozy dzé”? Nehx rieññ nó bia leeu ni ne me. ");
INSERT INTO zpg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Per Jesúz nann me racladzy xmeññ me gnabdiidz leeme bia leeu ni ne me, were ra me leeyâme: ―¿Ganabdiidz saꞌ laꞌd la, de ni ren laꞌd leññ doozy dzé ba di zwieꞌ laꞌd naa, per tedy stoozy dzé gyzac zwieꞌ laꞌd naa? ");
INSERT INTO zpg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Gapyaꞌ laꞌd ni uli, zuun laꞌd no ziuꞌ laꞌd trixd, no meññ-nu lo guiedzylie sshihly yâme. No nîcze tzu laꞌd trixd, per zdzee xguîltrixd laꞌd no zahcu to guîlrxihly. ");
INSERT INTO zpg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","To ngünaa, ru ba bydzihñ ni gahl ximdoo, rguꞌ ihqy me porni ba bydzihñ hor-tedy me yoob; per hor-ba bylux guhl ximdoo, ba nehx ritsêlou leeme yoob ni güdedy me, mazyg rxihly me, porni ba guhl to mdoo lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","No mod-wé gahc‑e laꞌd hôrrieꞌ rguꞌ ihqy laꞌd ni dziguiahcaꞌ; per ru güien laꞌd gyzac, were ba sshihly xguîlmbahñ laꞌd no to guîlrxihly ni ndruhty nehx beeiy gboo. ");
INSERT INTO zpg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Dze-wé ba nehx znabdiidz laꞌd naa mbehty. Gapyaꞌ laꞌd ni uli, nitisy gnab laꞌd lo dTadaꞌ por dlen la, leeme zdee meu laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Xtâ hôrrieꞌ mbehty dgueññ gnab laꞌd por dlen; lâ gnab, no scaꞌ laꞌd lehdy tzu to ni gyxilyno laꞌd mazy. ");
INSERT INTO zpg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Pur nyagü lo diidz rapyaꞌ laꞌd nirieꞌ yahc; per ziaad dzé ni ba nehx zahcu ze, ba nxal lo diidz‑e zunon laꞌd lguia dTadaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","No dze-wé znab laꞌd lo dTadaꞌ por dlen. No nehx zapyaꞌ laꞌd gnabaꞌ lo dTadaꞌ por laꞌd; ");
INSERT INTO zpg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","porni ndzi gahc dTadaꞌ laꞌd, no porni ndzi laꞌd naa no bylíladzy laꞌd de Dioz‑e biaḻaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ru nu dTadaꞌ byruun biaḻaꞌ guiedzylie, no ba csanaꞌ guiedzylie lehdy guibyguiataꞌ ru nu me. ");
INSERT INTO zpg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Were ra xmeññ me leeme: ―Hôrrieꞌ yaa gyre ni neꞌy gayieññ noꞌ, no ba nehx ganiiy nyagü lo diidz. ");
INSERT INTO zpg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Hôrrieꞌ ba bwieꞌ noꞌ nanniꞌ gyre cos, nîcze ndruhty nehx nnabdiidz lii behch. Leewe rlídadzy noꞌ ru nu Dioz‑e byruuy. ");
INSERT INTO zpg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ra Jesúz leeyâme: ―¿Hôrrieꞌ were rlíladzy laꞌd la? ");
INSERT INTO zpg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ba gadzihñ hór, no ba gahc bydzihñu, to to laꞌd gynahzy gydze lad, no csaꞌn laꞌd naa tohgaꞌ. Per dac‑e tohgaꞌ guiaꞌn, porni dTadaꞌ nuno naa. ");
INSERT INTO zpg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Gyre nirieꞌ ren laꞌd, lehdy tzu xguîlmbahñ laꞌd dzie tziaawy porni nu laꞌd no naa. Lo guiedzylie, zdedy laꞌd ni nadz; per di gydzie laꞌd, porni naa ba ptzon gan bêndzab lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Bylux günii Jesúz gyre nirieꞌ, bwieꞌ me gybaa, no ne me: ―Dad, ba bydzihñ hór. Güluguia naa lehdy naa zegahc cuguian lii. ");
INSERT INTO zpg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Porni por lii we rtzon mdad gyre meññ, lehdy gdedyaꞌ guîlmbahñ ni nehx zluhx gyre meññ ni pshahliꞌ bidyo naa. ");
INSERT INTO zpg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lihzy‑e ni ulihb Dioz lee, no bâḻ gzaclo yâme lii no naa ni pshahliꞌ lee, were zahp yâme guîlmbañ-wé ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ba ptzon gyre ni guhdzyiꞌ naa, no modé güluguian lii neꞌ lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Naꞌ hôrrieꞌ, Dad, güluguia naa cooy, mod-güyuguian no lii antzy ni tzaa guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Meññ-güle yahquiꞌ lo guiedzylie no bdeedyiꞌ naa, blun leeyâme dxu lii. Xmeññiꞌ we leeyâme, no bdeedyiꞌ leeyâme naa, no ba gazoob yâme xtiidziꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Naꞌ ba nann yâme gyre ni bdeedyiꞌ naa ziaadu de lii, ");
INSERT INTO zpg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","porni xtiidziꞌ ni bdeedyiꞌ naa, ba bienonu leeyâme no cuaꞌ yâmeu leññ xguîlmbahñ yâme. No ba nann yâme ni ulihb ru nuy byruun, no ba bylíladzy yâme lii pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ganabaꞌ lii por leeyâme. Nehx ganabaꞌ por gyre meññ-nu lo guiedzylie, mazyg por meññ ni bdeedyiꞌ naa, porni xmeññiꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","No gyre dmeññaꞌ zegahc‑e xmeññiꞌ leeyâme; no xmeññiꞌ zegahc‑e dmeññaꞌ leeyâme; no riuguian por leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Naꞌ ba nehx ziun lo guiedzylie; per leeyâme ziuꞌr yâme lo guiedzylie; no naa tzan ru nuy. Dad, nehx nu ndruhty beeiy lii, bwieꞌ dmeññaꞌ no xpoderiꞌ ni bdeedyiꞌ naa, lehdy gap yâme tohzy guîlriehñ beeiy gahc nó. ");
INSERT INTO zpg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dze-nun no leeyâme lo guiedzylie, naa bwien leeyâme no xpoderiꞌ ni bdeedyiꞌ naa; naa bylan leeyâme, no ndruhty de leeyâme nehx bynihty, mazyg ni ba gahc nac diidz gynihty, mod-ne lo Guehtzy ru queꞌ xtiidziꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Per naꞌ tzan ru nuy; no ren nirieꞌ leegâ nun lo guiedzylie, lehdy gyxihly yâme mod-gaxihly gahcaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naa bienon leeyâme xtiidziꞌ; no por leeu meññ-nu lo guiedzylie gucnéladzy leeyâme, porni ba nehx rtzoo yâme mod-rtzoo meññ-nu lo guiedzylie, beeiy gahc naa nehx rtzon mod-rtzoo meññ-nu lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nehx ganabaꞌ gbooy leeyâme de lo guiedzylie, mazyg gylay leeyâme de lo ña bêndzab. ");
INSERT INTO zpg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ba nehx rtzoo yâme mod-rtzoo meññ-nu lo guiedzylie, beeiy gahc naa nehx rtzon mod-rtzoo meññ-nu lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","No rnabaꞌ ptzoo leeyâme nunzy par lii hor-gayieññ yâme ni nac ni uli; xtiidziꞌ ni uli we leeu. ");
INSERT INTO zpg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mod-pshahliꞌ naa lahd meññ-nu lo guiedzylie, mod-wé gahc gashaalaꞌ leeyâme lahd meññ-nu lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","No por leeyâme nacaꞌ nunzy par lii, lehdy zegahc gac yâme nunzy par lii por xtiidziꞌ ni nac ni uli. ");
INSERT INTO zpg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Nehx ganabaꞌ lii nunzy por leeyâme, mazyg ganabaꞌ zegahc por meññ-gylíladzy naa por diidz ni guno yâme lee. ");
INSERT INTO zpg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Rnabaꞌ lii gap yâme tohzy guîlriehñ beeiy gahc mod-nuy no naa, Dad, no mod-nun no lii; mod-wé gahc, gap yâme tohzy guîlriehñ no nó, lehdy gylíladzy meññ-nu lo guiedzylie lii we pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mod-güluguiay naa, mod-wé gahc güluguian leeyâme, lehdy gap yâme tohzy guîlriehñ, mod-naa no lii rahp nó tohzy guîlriehñ. ");
INSERT INTO zpg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Lii nunoy naa no naa nun no leeyâme, lehdy ulihbu gap yâme tohzy guîlriehñ, no mod-wé zann meññ-nu lo guiedzylie lii pshahl naa no ndziy dmeññaꞌ mod-ndzi gahquiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Dad, dmeññaꞌ ni bdeedyiꞌ naa, racdadzyaꞌ tzu yâme ru tzun, lehdy güieꞌ yâme guîlbyniꞌ ni bdeedyiꞌ naa, porni ndziy naa glo antzy ni tzaa guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dad, lii ni rtzoo ni nac xñahzû, meññ-nu lo guiedzylie nehx rzaclo yâme lii, per naa rzacloꞌn lii, no dmeññaꞌ ni bdeedyiꞌ naa nann yâme lii pshahl naa. ");
INSERT INTO zpg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Blun leeyâme dxu lii, no galú ziaꞌraꞌ leeyâme, lehdy guîlndzi ni rahpiꞌ naa leegahcu gap yâme, no lehdy tzun no leeyâme. ");
INSERT INTO zpg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bylux günii Jesúz nirieꞌ yahc, byruu me no xmeññ me, za yâme stiby chehsh guiâgülahsy ni le Cedróṉ, no güyuꞌ yâme leññ to lyu ru zu yag-rgaꞌy. ");
INSERT INTO zpg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jud, ni bdee Jesúz lo ña meññ-rdziadzyno leeme, zegahc nann ru nu lyu-wé, porni xtahl vuelt Jesúz no xmeññ me rdohp yâme uga. ");
INSERT INTO zpg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Güya Jud ru nu lyu-wé no soldad no zrieñ meññ ni rahp ruꞌ idoró, ni pshahl xjefy yahc bahl no meññ-nac yahc fariseu lee. Ziyno yâme lampr no xgue guier-bihdzy no spad. ");
INSERT INTO zpg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Per Jesúz nann me ni dziguiahc me, byruu me no günabdiidz me, ra me meññ-wé yahc: ―¿Dxu ryo laꞌd lee? ");
INSERT INTO zpg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ra yâme leeme: ―Jesúz ni nac meññ-Nasaret. Ra Jesúz leeyâme: ―Naa we. No Jud, ni gadee Jesúz lo ña meññ-wé, nu lahd yâme. ");
INSERT INTO zpg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hor-ra Jesúz leeyâme: “Naa we”, biatrxan yâme, no biahb yâme lo yu. ");
INSERT INTO zpg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Gyzac ra Jesúz leeyâme: ―¿Dxu ryo laꞌd lee? Gyzac ra yâme leeme: ―Jesúz ni nac meññ-Nasaret. ");
INSERT INTO zpg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ra Jesúz leeyâme: ―¿Dâs ba ren laꞌd: “Naa we”? Bâḻ naa gayo laꞌd, lâ gdee ñahz gybiꞌ meññ-rieꞌ yahc. ");
INSERT INTO zpg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","No wé guhc ni günii Jesúz, ru ne me: “Dad, meññ-bdee yahquiꞌ naa, nehx bynihty ni to yâme.” ");
INSERT INTO zpg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Hor-wé güloo Simoṉ-Pedr to spad ni ziyno me, no pchug me gydiag-drech xmós xjefy gyre bahl. No mos-wé, le me Malcü. ");
INSERT INTO zpg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Were ra Jesúz Pedr: ―Güluꞌ xispadiꞌ xilgaru; gyre ni nadz ni gabiahz naa ni ne dTadaꞌ tedyaꞌ, ¿nehx zdeedyaꞌu la? ");
INSERT INTO zpg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Gyre soldad no xcomandant yâme, no zrieñ meññ-rahp ruꞌ idoró, günahzy yâme Jesúz no blihby yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Güiyno yâme leeme nier xiryuꞌ Anáz, suegyr Caifáz, no iz-wé Caifáz nac me xjefy gyre bahl. ");
INSERT INTO zpg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifáz, leegahcme we ni ra meññ-Isṟael ni rtzoo mdad, ma mos‑e par leeyâme ñehty tohzy meññ por gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pedr naꞌ no sto xmeññ gahc Jesúz, náḻ yâme Jesúz. No mpyquie-rieꞌ ni nac sto xmeññ Jesúz, rzaclo xjefy gyre bahl leeme, no leewe güyuꞌ me lo xpaty bahl tohzy no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Per Pedr biaꞌn me stziuꞌ ruꞌ puert. Were byruu mpyquie-nac xmeññ Jesúz, ni rzaclo xjefy gyre bahl lee, günii me no ngüna-rahp ruꞌ puert par güyuꞌ Pedr. ");
INSERT INTO zpg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ngüna-rahp ruꞌ puert naꞌ, ra me Pedr: ―¿No lii we xmeññ mpyquie-rieꞌ la? Ra Pedr leeme: ―Yac, dac‑e xmeññ me naa. ");
INSERT INTO zpg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gumm gayahc ncohby la, xmós yahc xjefy gyre bahl no meññ-rahp ruꞌ idoró, gülahqy yâme gue no gatzeꞌladzy yâme. Zuhdy Pedr lahd yâme, gatzeꞌladzy zegahc. ");
INSERT INTO zpg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Guzlo xjefy gyre bahl ganabdiidz me Jesúz de xmeññ no de ni rluu me meññ. ");
INSERT INTO zpg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ra Jesúz leeme: ―Naa günin ñaz-lo nyug, no gyre meññ bieññ. Rlun meññ leññ idoo yahc no zegahc leññ idoró ru rdohp gyre meññ-Isṟael, no mbehty dgueññ gynin ngaꞌdzy. ");
INSERT INTO zpg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Bia nacu ganabdiidziꞌ naa? Beeiy gnabdiidziꞌ meññ-bieññ ni günin. Leeyâme nann bia günin. ");
INSERT INTO zpg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ru günii Jesúz ze, byruu to lahd meññ-rahp ruꞌ idoró, güdahp lo me, no ra leeme: ―¿Bia nacu ridzguiatiꞌ diidz lo xjefy gyre bahl ze? ");
INSERT INTO zpg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ra Jesúz leeme: ―Gu naa bia günin ni nehx xñahzû; no bâḻ xñahzu günin, ¿bia nacu güdihñiꞌ naa? ");
INSERT INTO zpg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Byluxu, nliiby gahc Jesúz, pshahl Anáz leeme lo xjefy gyre bahl ni le Caifáz. ");
INSERT INTO zpg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Zu Pedr, gatzeꞌladzy me coo gue. Ra yâme leeme: ―¿Dac‑e xmeññ Jesúz lii la? Ra Pedr: ―Yac, dac‑e xmeññ me naa. ");
INSERT INTO zpg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Byruu to xmós xjefy gyre bahl, xfamily mpyquie-pchug Pedr gydiag, ra leeme: ―¿Dâs‑e bwien lii no leeme leññ lyu ru zu yag-rgaꞌy la? ");
INSERT INTO zpg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Gyzac günii Pedr nehx rzaclo me Jesúz, no lohg hor-wé güriedz rig. ");
INSERT INTO zpg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Byruno yâme Jesúz xiryuꞌ Caifáz, ziyno yâme leeme xpalacy gobernador. Gumm ba zidtzu byniꞌ la, nehx güyuꞌ meññ-Isṟael no Jesúz leññ palacy; porni bâḻ leeyâme ñuꞌ, ba nehx ntzoo yâme mod-ne xleiy yâme, no ba nehx beeiy ñahgü yâme guîlrahgü ni rzaa yâme lo lni Pascü. ");
INSERT INTO zpg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","No leewe byruu Pilat stziuꞌ, ra leeyâme: ―¿Bia ptzoo mpyquie-wé zidno laꞌd leeme neꞌ? ");
INSERT INTO zpg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ra yâme Pilat: ―Bâḻ ñahc me meññ-tziaawy, nehx nidno noꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ra Pilat leeyâme: ―Lâ tziyno leeme, lâ ctzoo guîlguxtisy lguia me mod-rnii xleiy laꞌd. Ra meññ-Isṟael Pilat: ―Dleiy noꞌ nehx rdee ñahz ngaꞌdy noꞌ ndruhty. ");
INSERT INTO zpg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Günii yâme ze lehdy guhc mod-ne Jesúz hor-günii me bia mód gaty me. ");
INSERT INTO zpg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Gyzac güyuꞌ Pilat leññ palacy, no pquee me riedz Jesúz, no ra me lee: ―¿Lii we xṞeiy meññ-Isṟael la? ");
INSERT INTO zpg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ra Jesúz leeme: ―¿Ni ne xguîlriehñiꞌ, wé rahbyiꞌ naa la, o zrieñ dxu rahbyu lii de naa? ");
INSERT INTO zpg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ra Pilat leeme: ―¿Nlâdzyiꞌ meññ-Isṟael‑e naa la? Meññ-xguiedzy gahquiꞌ no xjefy yahc bahl bidno lii neꞌ ru nun. ¿Bia ptzooy? ");
INSERT INTO zpg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ra Jesúz leeme: ―Ru rtzon mdad, dac‑e de lo guiedzylie-rieꞌ leeu. No bâḻ leeu ñahcu ze la, nquelo dmeññaꞌ we, lehdy meññ-Isṟael ni rdziadzyno naa, di nnahzy yâme naa. Per ru rtzon mdad, dac‑e neꞌ leeu. ");
INSERT INTO zpg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ra Pilat leeme: ―¿Ni uli ṟeiy lii la? Ra Jesúz leeme: ―Lii neꞌy ṟeiy naa. Par nirieꞌ we guhlaꞌ no biaḻaꞌ lo guiedzylie, lehdy gdedyaꞌ diidz de ni nac ni uli. Gyre meññ ni rzaclo ni uli, rieññ yâme naa. ");
INSERT INTO zpg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ra Pilat leeme: ―¿Bia we leeu ni uli? Bylux günabdiidz Pilat Jesúz, byruu me, güya me gyzac ru zu meññ-Isṟael, no ra me leeyahc: ―Naa nehx rdzialaꞌ mbehty doḻ lguia mpyquie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Per ba bieno laꞌd rislaan to meññ-nyagü lidzyguiib lo lni-Pascü. ¿Racladzy laꞌd guislaan xṞeiy meññ-Isṟael la? ");
INSERT INTO zpg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Gyre yâme gyzac gaquee riedz, ne: ―¡Dac‑e leeme gylaa! ¡Barrabáz bislaa! Per Barrabáz, gübaan‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Were ptzoo Pilat mdad bydihñ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","No bzaa soldad to coron-guiahtz no bdziib yâmeu ihqy Jesúz, no bguhtz yâme leeme to lar-morad, ");
INSERT INTO zpg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","no ra yâme leeme: ―¡Nehx zehty xṞeiy meññ-Isṟael! No luxu rgahp yâme lo me. ");
INSERT INTO zpg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Gyzac byruu Pilat, ra leeyâme: ―¡Lâ güieꞌ! Zidnon mpyquie-rieꞌ stziuꞌ, lehdy güieꞌ laꞌd nehx rdzialaꞌ mbehty doḻ lguia me. ");
INSERT INTO zpg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Byruu Jesúz, ba nu coron-guiahtz ihqy me, no ba nutz me to lar-morad. Were ra Pilat leeyâme: ―¡Neꞌ zu mpyquie-bidno laꞌd lee! ");
INSERT INTO zpg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hor-xjefy yahc bahl no meññ-rahp yahc ruꞌ idoró bwieꞌ yâme Jesúz, pquee yâme riedz, ne yâme: ―¡Pquee leeme lo cruzy! ¡Pquee leeme lo cruzy! Ra Pilat leeyâme: ―Lâ tziyno leeme, lâ yquee leeme lo cruzy laꞌd, porni naa nehx rdzialaꞌ mbehty doḻ lguia me. ");
INSERT INTO zpg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Meññ-Isṟael ra yâme Pilat: ―Noꞌ rahp noꞌ to leiy, no ni ne dleiy noꞌ la, rahp me de ni gaty me porni ne me Xiiñ Dioz leeme. ");
INSERT INTO zpg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hor-bieññ Pilat nirieꞌ, ma bydzie me. ");
INSERT INTO zpg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Gyzac güyuꞌ me leññ palacy, no ra me Jesúz: ―¿Dxu meññ lii? Per Jesúz nehx gu leeme mbehty. ");
INSERT INTO zpg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ra Pilat leeme: ―¿Nehx racladzyiꞌ csaꞌy lo dtiidzaꞌ la? ¿Nehx nanniꞌ la, naa beeiy nqueen lii lo cruzy, no zegahc beeiy nislaan lii? ");
INSERT INTO zpg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Were ra Jesúz leeme: ―Mbehty nehx beeiy ntzooy naa, bâḻ dac gybaa byruu diidz; no leewe, dxu bidno naa loꞌy, ma xroꞌ guîlquie rahp. ");
INSERT INTO zpg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Glohdy hor-wé byo Pilat xnahc guislaa me Jesúz; per meññ-Isṟael rquee yâme riedz, gaya yâme Pilat: ―¡Bâḻ guislaay leeme, nehx xmígüiꞌ emperador-Cézr! ¡Gyre dxu ne lee nac ṟeiy, rruu yâme contr emperador-Cézr! ");
INSERT INTO zpg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ru bieññ Pilat günii yâme ze, ptzoo me mdad byruu Jesúz stziuꞌ, no bicchie me ru rtzoo me guîlguxtisy, to ru le De Guie, ni rnii lo didz-hebreu Gabata. ");
INSERT INTO zpg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Dze-wé nacu dze-rzaa yâme gyre ni yquihñ yâme lo lni-Pascü, beeiy ribygue. Were ra Pilat meññ-Isṟael: ―¡Neꞌ zu xṟeiy laꞌd! ");
INSERT INTO zpg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Per meññ-Isṟael rquee yâme riedz, ne yâme: ―¡Gaty me! ¡Gaty me! ¡Pquee leeme lo cruzy! Ra Pilat leeyâme: ―¿Yqueen xṞeiy laꞌd lo cruzy la? Ra xjefy bahl yahc leeme: ―Noꞌ nehx rahp noꞌ zrieñ ṟeiy; nunzy Cézr, wé we dṟeiy noꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","No luxu bdee Pilat Jesúz lehdy gaty me lo cruzy, no ziyno soldad yahc leeme. ");
INSERT INTO zpg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Byruu Jesúz de uga, ziyno me cruzy ni yquee yâme leeme lo, no za me ru le Xilgar Calaver, ni rnii lo didz-hebreu Gólgota. ");
INSERT INTO zpg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Uga pquee yâme leeme lo cruzy, no pquee yâme schohp meññ lo zrieñ cruzy coo ru queꞌ me, to gá lad to yâme. ");
INSERT INTO zpg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ihqy cruzy ru queꞌ me, queꞌ letrer ni ptzoo Pilat mdad güyaa, no neu: JESÚZ NI NAC MEÑÑ-NASARET, XṞEIY MEÑÑ-ISṞAEL. ");
INSERT INTO zpg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Xtahl meññ-Isṟael biiḻy leeu, porni gahsh ruꞌ guiedzy pquee yâme Jesúz lo cruzy, no letr ni bzaa yâme ihqy cruzy, güyaau no didz-hebreu, didz-latíṉ, no didz-griegü. ");
INSERT INTO zpg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","No leewe xjefy yahc xbahl meññ-Isṟael ra yâme Pilat: ―Di gzaayu, “xṞeiy meññ-Isṟael”; mazyg bzaau, “Leeme ne nac me xṞeiy meññ-Isṟael.” ");
INSERT INTO zpg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ra Pilat leeyâme: ―Ni ba bzan, ba nehx beeiy gydzeeu. ");
INSERT INTO zpg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bylux pquee soldad Jesúz lo cruzy, cuaꞌ yâme shab me, ptzoo yâmeu tahp cuib, to cuibu par to gá soldad. No zegahc cuaꞌ yâme shab me ni ruhtz me xtziguia, no gumm güyaau no tohzy lar-nter xtâ guia no xtâ lo yu la, ");
INSERT INTO zpg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","leewe ra saꞌ soldad yahc: ―Nehx stzulaꞌy nó leeu, mazyg güieꞌ nó dxu rahp suert, wé we ycaꞌ leeu. No mod-wé guhc ni rnii lo Guehtzy ru queꞌ xtiidz Dioz, ru neu: “Güdiiz yâme dshabaꞌ, no güloo yâme suert dxu ycaꞌ cad tohbyu.” Leewe ni ptzoo soldad yahc ze. ");
INSERT INTO zpg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gahsh ru queꞌ Jesúz lo cruzy, zu xmam me, no baḻ xmam me, no Maríe tziahl Cleofas, no Maríe-Magdalen. ");
INSERT INTO zpg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ru bwieꞌ Jesúz ru zu xmam me, no coo xmam me zu to xmeññ me ni ndzi me lee, ra me xmam me: ―Mam, wé zu xiiñiꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","No luxu ra me mpyquie-nac xmeññ me lee: ―Wé zu xmamiꞌ. Glohdy dze-wé zia xmam Jesúz xiryuꞌ mpyquie-caḻ, ni nac xmeññ Jesúz lee. ");
INSERT INTO zpg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesúz nann me gyre ni nac diidz gac ba guhcu, no lehdy gac ni rnii lo Guehtzy ru queꞌ xtiidz Dioz, were günii me: ―Rzaagydadzyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Caꞌ yâme to csiht, nu vinagyr leññu. Gülunihs yâme to sponj lo vinagyr, no pquee yâmeu ihqy to yahg ni le hisop, no bistzihñ yâmeu ruꞌ me ru queꞌ me lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","No byluxz güee me vinagyr, ne me: ―Gyreu ba bylux. No bgaaḻ ihqy me, no guhty gahc me. ");
INSERT INTO zpg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Dze-wé nacu dze-rzaa yâme gyre ni yquihñ yâme lo lni-Pascü, no ba sulo dze-risladzy meññ-Isṟael, no nacu to dzé ni ma nda; leewe xjefy yahc bahl nehx racladzy yâme guiaꞌn xcuerp meññ-rieꞌ yahc lo cruzy. Were günab yâme Pilat cshahl me xmeññ me dziglaꞌy nieꞌ meññ-queꞌ yahc lo cruzy no glety yâme lee. ");
INSERT INTO zpg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Were güya soldad, gülaꞌy nieꞌ meññ-queꞌ lo cruzy gyrop coo ru queꞌ Jesúz, nier nieꞌ to me, were nieꞌ sto me. ");
INSERT INTO zpg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Hor-bydziñgahsh soldad ru queꞌ Jesúz, bwieꞌ yâme ba guhty me, ba di nlaꞌy yâme nieꞌ me. ");
INSERT INTO zpg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Per to lahd gahc soldad gülezy lanz coo leññ Jesúz, no lo hor-wé byruu rieñu no nzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ni bwieꞌ nirieꞌ gadee diidz ni guhc, no ni rnii me ni uli we leeu; no nann me ni uli ni rnii me lehdy gylíladzy laꞌd zegahc. ");
INSERT INTO zpg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nirieꞌ yahc guhcu ze, lehdy gac ni rnii lo Guehtzy ru queꞌ xtiidz Dioz, ru neu: “Nehx gülaꞌy yâme mbehty xdziht me.” ");
INSERT INTO zpg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","No sto lad lo gahc Guehtzy ru queꞌ xtiidz Dioz neu: “Güieꞌ yâme ni ptedyqueꞌ yâme lanz lee.” ");
INSERT INTO zpg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bylux gyre nirieꞌ, to mpyquie ni le José, no xguiedzy me le Arimatea, ra me Pilat bâḻ beeiy ndee ñahz glety me xcuerp Jesúz. José naꞌ, zegahc‑e xmeññ Jesúz leeme, per ngaꞌdzy porni rdzie me meññ-Isṟael; no Pilat bdee ñahz José güya biglety xcuerp Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Zegahc bydzihñ Nicodem, bidno beeiy treint kil ni nixye ni güyaa no mirra no nutzu áloe. Nicodem, leeme ni güya ru nu Jesúz to guiaal. ");
INSERT INTO zpg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","No mod-wé José no Nicodem pchaḻ yâme xcuerp Jesúz no lahr ni güluꞌ yâme ni nixye lee, mod-rtzoo gahc meññ-Isṟael ru ba dziycaꞌdzy yâme mînguty. ");
INSERT INTO zpg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Gahsh ru pquee yâme Jesúz lo cruzy nu to lyu, no leññ lyu-caḻ nu to baa ni leer bydahñ no ndruhty dgueññ igaꞌdzyu. ");
INSERT INTO zpg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Uga pcaꞌdzy yâme xcuerp Jesúz, porni gahshu, no porni guhcu dze-rzaa yâme gyre ni yquihñ dze-risladzy meññ-Isṟael, no ba sulou. ");
INSERT INTO zpg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Primer xdzé seman, güya Maríe-Magdalen ruꞌ baa hor-dzictzu byniꞌ, ncawy ziaꞌ; bydzihñ me, bwieꞌ me ba byruu guie-ro ni nyagü ruꞌ baa. ");
INSERT INTO zpg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Rxuunn me, za me ru nu Simoṉ-Pedr, no wé gahc nu sto mpyquie ni ndzi Jesúz lee no xmeññ me lee zegahc, ra me leeyahc: ―¡Güloo yâme Señor leññ baa, no nehx nann noꞌ bá biycaꞌdzy yâme leeme! ");
INSERT INTO zpg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Byruu Pedr no sto mpyquie ni xmeññ Jesúz lee, za yâme ruꞌ baa. ");
INSERT INTO zpg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Gaxuunn gyrop yâme; per sto me ma byxuunn que Pedr, no ma nier lee bydzihñ ruꞌ baa. ");
INSERT INTO zpg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Byruꞌñ me no bwieꞌ me leññ baa, wé nash lar-byraḻ Jesúz, per di ñuꞌ me leññ baa. ");
INSERT INTO zpg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Bylux de ni bydzihñ me, bydzihñ gahc Simoṉ-Pedr no güyuꞌ gahc leññ baa; no bwieꞌ me zegahc lar-byraḻ xcuerp Jesúz; ");
INSERT INTO zpg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","no luxu bwieꞌ me lahr ni byraḻ ihqy Jesúz, ndoobyu nashu gydze lad, no gydze gahc lad nash lahr ni byraḻ xcuerp Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Luxu güyuꞌ sto xmeññ Jesúz ni bydzihñ nier lee, no bwieꞌ me gyreu no bylíladzy me gübahñ Jesúz gyzac, ");
INSERT INTO zpg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","porni dgueññ ziaꞌ guieññ yâme ni rnii lo Guehtzy ru queꞌ xtiidz Dioz, ru neu, leeme zbahñ me gyzac de lahd mînguty. ");
INSERT INTO zpg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Luxu, gubyguiat xmeññ Jesúz ruꞌ yuꞌ ni güya ruꞌ baa. ");
INSERT INTO zpg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Per Maríe biaꞌn ruꞌ baa gayuun. No lóni gayuun me, byruꞌñ me lehdy güieꞌ me leññ baa, ");
INSERT INTO zpg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","no modé bwieꞌ me chohp ángel, nutz lar-quitzy dxie ru guht xcuerp Jesúz. To me dxie ñaz-ihqy baa no sto me dxie ñaz-nieꞌu. ");
INSERT INTO zpg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ra ángel yahc leeme: ―¿Ngünaa, bia nacu ruuniꞌ? Were ra me leeyâme: ―Porni ziyno yâme xcuerp Señor ni nacaꞌ xmeññ, no nehx nannaꞌ bá glo ziyno yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Naabz günii me ze, bidzguiat lo me, bwieꞌ me Jesúz, per nehx bzaclo me bâḻ Jesúz‑e ni gawieꞌ me lee. ");
INSERT INTO zpg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ra Jesúz leeme: ―Ngünaa, ¿bia nacu ruuniꞌ? ¿Dxu ryohbyiꞌ? Nlâdzy Maríe meññ-rahp lyu-wé ganii no leeme, were ra me lee: ―Señor, bâḻ lii ziyno leeme, gu naa bá glo bictishiꞌ leeme, lehdy dziycan leeme. ");
INSERT INTO zpg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Were ra Jesúz leeme: ―¡Maríe! Bidzguiat lo Maríe no günii me didz-hebreu, ra me Jesúz: ―¡Raboni! ―ni rnii neu, Muextr. ");
INSERT INTO zpg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ra Jesúz leeme: ―Di caniꞌ naa, porni dgueññ ziaꞌ tzan ru nu dTadaꞌ. Per güya, no gu dmeññ yahcaꞌ: Tzan ru nu dTadaꞌ ni zegahc xTad laꞌd lee, no tDiozaꞌ ni zegahc xDioz laꞌd lee. ");
INSERT INTO zpg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Were za Maríe-Magdalen, zigyne me xmeññ Jesúz de ni bwieꞌ me Señor, no ra Maríe leeyâme ni ra Jesúz leeme. ");
INSERT INTO zpg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ru güyuꞌ guiaal de dze-wé gahc, primer xdzé seman, nyagü yuꞌ dxie xmeññ Jesúz porni rdzie yâme meññ-Isṟael. Jesúz gaññ bydzihñ glaꞌy ru dxie yâme leññ yuꞌ, no günii me diux, ra me: ―Tzu xguîlmbahñ laꞌd dzie tziaawy. ");
INSERT INTO zpg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bylux günii me ze, bluu me ru güyaaz clav ña me, no bluu coo leññ me bwieꞌ xmeññ me, no rxihly yâme gawieꞌ yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Luxu ra Jesúz leeyâme gyzac: ―Tzu xguîlmbahñ laꞌd dzie tziaawy. Mod-pshahl dTadaꞌ naa, modé gahc cshaalaꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","No luxu, blo me mbeꞌ leeyâme, no ra me lee: ―Lâ ycaꞌ Spirt-Sant. ");
INSERT INTO zpg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dxu guioob laꞌd lee no xguîlquie, zidguiahc yâme beeiy ni nehx ptzoo guîlquie; no dxu di guioob laꞌd lee de xguîlquie, ba biaꞌn gahc yâme we no xguîlquie yâme. ");
INSERT INTO zpg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","De lo gydiby tzipychop xmeññ Jesúz, to lahd yâme ni le Tomáz, ni ra yâme lee Dídimo, dgueññ me ru biahd Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Per zrieñ yâme ni bwieꞌ Jesúz ra yâme Tomáz: ―Bwieꞌ noꞌ Señor. Per Tomáz ra leeyâme: ―Bâḻ nehx nwien xseñ clav ña me no nlezy ihqy dñan ru güyaaz clav, no nlezy dñan zegahc coo leññ me ru güyaaz lanz, nehx nlídadzyaꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Güdahpu shun dzé, no gyzac bydohp xmeññ Jesúz leññ yuꞌ, were ba nu Tomáz lahd yâme, no nyagü gahc yuꞌ, Jesúz gaññ bydzihñ glaꞌy ru dxie yâme leññ yuꞌ, no ra leeyâme: ―Tzu xguîlmbahñ laꞌd dzie tziaawy. ");
INSERT INTO zpg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Luxu, ra me Tomáz: ―Bwieꞌ dñan no güdan ru güyaaz clav; no güdan coo dleññaꞌ ru güyaaz lanz. Ba di yqueꞌladzyiꞌ, mazyg bylíladzy. ");
INSERT INTO zpg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Were ra Tomáz leeme: ―¡Señor, lii we rtzoo mdad naa, no lii we tDiozaꞌ! ");
INSERT INTO zpg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ra Jesúz leeme: ―¿Bwieꞌriꞌ naa, were bylíladzyiꞌ la? ¡Dxu ñahc beeiy meññ ni rlíladzy naa sinn güieꞌ! ");
INSERT INTO zpg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ptzoo Jesúz xtahl ni ngann ni bwieꞌ xmeññ me ni nehx güyaa lo libr-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Per ni ganii lo guetzy-rieꞌ güyaau lehdy gylíladzy laꞌd Jesúz, leeme nac Crist, Xiiñ Dioz, no lehdy hor-gylíladzy laꞌd leeme, gap laꞌd guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bylux niwé, Jesúz gaññ bydzihñ gyzac ru nu xmeññ me coo nisdo-Tiberias, no guhcu mod-rieꞌ: ");
INSERT INTO zpg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nuty Simoṉ-Pedr, tohzy no Tomáz, ni ra yâme lee Dídimo, no Natanael, xguiedzy me le Caná ni nu lo ṟegioṉ-Galilea, no xiiñ yahc Zebedeu no schohp xmeññ Jesúz. ");
INSERT INTO zpg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ra Simoṉ-Pedr leeyâme: ―Naa tzan dzigynaazyaꞌ mbaḻ. Ra yâme leeme: ―Zehg‑e tzo noꞌ no lii. Güyuꞌ yâme leññ to barcü no za yâme; per guial-caḻ di nnahzy yâme mbehty mbaḻ. ");
INSERT INTO zpg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hor-ba zidtzu byniꞌ, bwieꞌ yâme Jesúz zu coo nisdoo, per nehx bzaclo yâme bâḻ Jesúz leeme. ");
INSERT INTO zpg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Were ra Jesúz leeyâme: ―Shiꞌñ, ¿ba günahzy laꞌd mbaḻ la? Ra yâme leeme: ―Yac, dgueññ gynahzy noꞌ mbehty maꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ra Jesúz leeyâme: ―Lâ gráḻ xgueshmbaḻ laꞌd lad-drech de barcü lehdy gynahzy laꞌd leemaꞌ. No ze ptzoo yâme. Luxu ba di raḻ gboo yâme xgueshmbaḻ yâme, porni xtahl mbaḻ nu leññu. ");
INSERT INTO zpg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","To xmeññ gahc Jesúz, ni ndzi me lee, ra me Pedr: ―¡Jesúz‑e, leeme ni rtzoo mdad! Scâsy bieññ Simoṉ-Pedr Jesúz leeme, bihtz shab-xtziguia me (porni güloo meu leññ barcü), no cüchahs me güyuꞌ me lo nzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","No zrieñ yâme bistzihñ barcü coo nzeꞌ, no gazûbyñu yâme gueshmbaḻ ni bydzeꞌ mbaḻ leññ; no de lo nzeꞌ ru naḻ barcü ni nu yâme leññ, rahpu beeiy diby gayuu metr par gydzihñu lo yudahñ. ");
INSERT INTO zpg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ru biaht yâme lo yudahñ, bwieꞌ yâme ba dxie gue no nash mbaḻ gayagy, no dxie paṉ. ");
INSERT INTO zpg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ra Jesúz leeyâme: ―Lâ guidno chohp tzonn mbaḻ ni leer günahzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Güyehpy Simoṉ-Pedr leññ barcü no gazûbyñu me gueshmbaḻ ni nu mbaḻ leññ lo yudahñ, bydzeꞌu de mbaḻ-roob, diby gayuu cincuentaytrez maꞌ, no nîcze xtahl maꞌ, per nehx bygaax gueshmbaḻ ni nu yâmaꞌ leññ. ");
INSERT INTO zpg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ra Jesúz leeyâme: ―Lâ te, gagü-rsily laꞌd. No ndruhty de leeyâme nehx ptzoo par nnabdiidz dxu leeme, porni nann yâme Jesúz‑e leeme ni rtzoo mdad. ");
INSERT INTO zpg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Luxu gübigy Jesúz, cuaꞌ me paṉ no güdiiz meu, cuaꞌ xmeññ me, no zegahc güdiiz me mbaḻ. ");
INSERT INTO zpg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nirieꞌ we ni bionn vuelt Jesúz gaññ bydzihñ ru nu xmeññ me bylux de ni gübahñ me de lahd mînguty. ");
INSERT INTO zpg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bylux güersily yâme, ra Jesúz Simoṉ-Pedr: ―Simóṉ, xiiñ Jonáz, ¿ndziy naa mazy de ni ndzi gyre meññ-rieꞌ naa la? Ra Pedr leeme: ―Lii nanniꞌ, Señor, ndzin lii. Ra Jesúz leeme: ―Bwieꞌ dmeññ yahcaꞌ; zidguiahc yâme beeiy xiily. ");
INSERT INTO zpg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Gyzac ra Jesúz leeme: ―Simóṉ, xiiñ Jonáz, ¿ndziy naa la? Ra Pedr leeme: ―Lii nanniꞌ, Señor, ndzin lii. Ra Jesúz leeme: ―Bwieꞌ dmeññ yahcaꞌ; zidguiahc yâme beeiy xiily. ");
INSERT INTO zpg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ni bionn vuelt ra Jesúz leeme: ―Simóṉ, xiiñ Jonáz, ¿ndziy naa la? Güyuꞌ Pedr trixd, porni ba tzonn vuelt gaya Jesúz bâḻ ndzi Pedr leeme. Were ra Pedr leeme: ―Señor, lii nanniꞌ gyreu; lii nanniꞌ ndzin lii. Ra Jesúz leeme: ―Bwieꞌ dmeññaꞌ; zidguiahc yâme beeiy xiily. ");
INSERT INTO zpg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Gapyaꞌ lii ni uli, dze-miꞌñ ziaꞌ lii ruhtz shabiꞌ tohguiꞌ no riay rutisy neꞌy; per dze-ba mînguhl lii, stzihly xihcuiꞌ, no zrieñ dxu iguhtz shabiꞌ no tziyno lii ru nehx riuꞌladzyiꞌ. ");
INSERT INTO zpg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nirieꞌ günii Jesúz, gaya me Pedr bia mód gaty lehdy Pedr, no xguîlguhty me, cuguia me Dioz. Bylux günii Jesúz ze, ra me Pedr: ―Náḻiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Hor-bidzguiat lo Pedr, bwieꞌ me ziaad sto xmeññ Jesúz ni ndzi Jesúz lee, ni gürie gahc coo Jesúz ru güdagü-tzie yâme últim guiaal, no ni gu Jesúz: “Señor, ¿dxu leeme ni gdee lii lo ña meññ-rdziadzyno lii?” ");
INSERT INTO zpg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedr, hor-bwieꞌ leeme, ra me Jesúz: ―Señor, naꞌz mpyquie-rieꞌ ni náḻ dchehsh nó, ¿bia mód gac me? ");
INSERT INTO zpg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ra Jesúz leeme: ―Bâḻ gacdadzyaꞌ guiaꞌn me no nehx zehty me xtâ glo guibyguiataꞌ la, nehx rahpiꞌ de ni ganniꞌ leeu. Mazyg lii, náḻiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nirieꞌ ni ra Jesúz Pedr gunn zrieñ xmeññ yahc Jesúz, per ba gydze mód bieññ yâmeu; nlâdzy yâme günii Jesúz‑e, ra me Pedr, nehx zehty mpyquie-wé. Per nehx günii Jesúz ze, mazyg ne me: “Bâḻ gacdadzyaꞌ la, guiaꞌn me no nehx zehty me xtâ glo guibyguiataꞌ, nehx rahpiꞌ de ni ganniꞌ leeu.” ");
INSERT INTO zpg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Meññ-rieꞌ, leegahcme we xmeññ Jesúz ni gadee diidz de nirieꞌ yahc, no bzaa meu lo guehtzy. No nann noꞌ ni uli ni rnii me. ");
INSERT INTO zpg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","No zegahc nur xtahl ni ptzoo Jesúz; bâḻ gyreu ñaa lo guehtzy to por tohbyu, zoꞌ naa nehx ñuꞌ lgar gydo lo guiedzylie ru ñuꞌ gyre guehtzy ni ñaau lo.");
INSERT INTO zpg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Lo libr ni bzan nier lee, Teófil, ziaad gyre ni ptzoo Jesúz no ni bluu me, xtâ glo dzé ni guzlo xtziiñ me, ");
INSERT INTO zpg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","no xtâ glo dzé ni biahs me, zia me gybaa. Dze-nu ziaꞌr me lo guiedzylie, güle me meññ ni guhc x‑apóstl me, no gucno Spirt-Sant leeme par bluu me meññ-wé yahc bia ne me ctzoo yâme. ");
INSERT INTO zpg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Guhty me, per ru ba gübahñ me sto, bidtzu me lahd x‑apóstl me no güyuꞌ xtahl mód ni bluu me leeyâme ni uli we mbahñ me. No leññ cuarent dzé, rwieꞌ yâme leeme lahd gá, no bluu me leeyâme lguia ni rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","No leññ dze-wé ni nu Jesúz no apóstl, ra me leeyâme: ―¡Di gyruhd Jerusaléṉ! Lâ cuiahz gacr ni ba bdee Dioz xtiidz me ctzoo me, no niwé we ni ba bienon laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Porni Juaṉ ni uli no nzeꞌ we pchôbnihs me meññ. Per laꞌd, lahd gahc dze-rieꞌ yahc guidtzu Spirt-Sant xguîlmbahñ laꞌd no gacu beeiy to guîlrrôbnihs. ");
INSERT INTO zpg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","To dzé zu Jesúz no x‑apóstl me, ra yâme leeme: ―Lii ni rtzoo mdad, ¿ctzooy ni naꞌ gahc de ni guibyguiat ctzoo meññ-Isṟael mdad leegahc yâme la? ");
INSERT INTO zpg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ra Jesúz leeyâme: ―Ni ne Dioz gac la, dac‑e lehdy gann laꞌd bia dzé o buc gacu; nunzy Dioz‑e rtzoo mdad bucu; ");
INSERT INTO zpg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","per hor-ba bidtzu Spirt-Sant xguîlmbahñ laꞌd, tzu gahc xpoder Dioz laꞌd, no dzigyuno laꞌd meññ dtiidzaꞌ Jerusaléṉ, no gydo lo ṟegioṉ-Judea no lo ṟegioṉ-Samary, no gydo-bynac lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Byluxz bieno me diidz leeyâme modé, lóhgni gawieꞌ yâme leeme, biahs me zia me gybaa, güyuꞌ me leññ to zá no ba di nwieꞌr yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Lóni gawiedzie yâme leññ gybaa ru za Jesúz, tohzy bydzihñ chohp mpyquie ru zu yâme nutz lar-quitzybo, ");
INSERT INTO zpg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ra leeyâme: ―Meññ-Galilea, ¿bia nacu rwiedzie laꞌd leññ gybaa? Jesúz ni güyuꞌ gahc no laꞌd, no gawieꞌ laꞌd zia me gybaa, mod-wé gahc‑e guibyguiat me lo guiedzylie sto. ");
INSERT INTO zpg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Were gubyguiat apóstl yahc xtâ to dahñ ni le Oliv, ziaad yâme par Jerusaléṉ, güzeꞌ yâme mdid-beeiy ria meññ-Isṟael dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Scâsy bydzihñ yâme Jerusaléṉ, güyehpy gahc yâme guia sto leññ yuꞌ ru rdzíe yâme. Leeyâme we meññ-rieꞌ yahc: Pedr, Jacob, Juaṉ, Ndréz, Felipy, Tomáz, Bartolomé, Mateu, Jacob xiiñ Alfeu, Simóṉ ni güyuꞌ lahd to cuib meññ ni le Zelot, no Jud behtzy Jacob. ");
INSERT INTO zpg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Gyre meññ-rieꞌ yahc nehx rsaꞌn de ni rdohp yâme, zegahcu meññ-ngünaa, no gahc Maríe xmam Jesúz, no meññ-behtzy me, no tohzy rnab yâme lo Dioz no rnino yâme Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Leññ dze-wé bydohp beeiy diby gayuu gaḻ meññ-rman. No lóni nu yâme tohzy, guzli Pedr lahd yâme, ra leeyâme: ");
INSERT INTO zpg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Rman, ba xtze bisnii Spirt-Sant Davit lguia Jud, ni guznier lo meññ ni günahzy yahc Jesúz. No gyre niwé ni güyaa lo Guehtzy ru queꞌ xtiidz Dioz, güdahpu de ni guhcu. ");
INSERT INTO zpg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jud naꞌ, güzeꞌ me no noꞌ, ptzoo me dziiñ tohzy no noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Per leeme, güxii me to lyu no medy ni cuaꞌ me lo ni dirquihñ ni ptzoo me; wé biahb me, bzu ihqy me no güriahz leññ me, lé byruu xsiee me. ");
INSERT INTO zpg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ru gunn meññ-Jerusaléṉ mod-guhty me uga, güluꞌ yâme le lyu-wé Acéldama, ni rnii lo xtiidz yâme: Lyu ru byxieꞌ rieñ. ");
INSERT INTO zpg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Zegahc ṟeiy-Davit günii me de Jud lo libr-Salm ni bzaa me, ne me: Guiaꞌn xiryuꞌ me, ndruhty nehx ziuꞌu. No günii me zegahc, ne me: Tzu sto meññ ni ctzoo dziiñ xilgar me. ");
INSERT INTO zpg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’No leewe gybee sto meññ dlahd gahc nó guiaꞌn xilgar Jud, per to meññ ni güzeꞌ gahc no noꞌ leññ gyre dzé ni güyuꞌ Jesúz no noꞌ, ");
INSERT INTO zpg_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","glo dze-pchôbnihs Juaṉ leeme no xtâ dze-zia me gybaa. Rquihñu we gybee sto meññ dlahd noꞌ, lehdy gdee diidz tohzy no noꞌ de ni Jesúz gübahñ me sto. ");
INSERT INTO zpg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","No were güle yâme chohp mpyquie: To me le José-Barsabáz ni ra yâme lee zegahc Just; no sto me le Matíaz. ");
INSERT INTO zpg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Luxu, günab yâme lo Dioz, ne yâme: ―Lii ni rtzoo mdad no rzacloꞌy to to xguîlmbahñ meññ, bluu noꞌ dxu de gyrop mpyquie-rieꞌ cueꞌy ");
INSERT INTO zpg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","lehdy gac me apóstl ni ctzoo dziiñ ni psaꞌn Jud, ni ba zia xilgar por xguîlquie. ");
INSERT INTO zpg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Byluxz günab yâme lo Dioz, güloo yâme suert, no biahb suert lguia Matíaz; no xtâ glo dze-wé biaꞌn me lahd gydiby tzipyto apóstl no guhc yâme tzipychop gyzac. ");
INSERT INTO zpg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dze-bydzihñ lni ni le Pentecostéz, to xilni meññ-Isṟael, xmeññ Crist bydohp yâme, nu yâme tohzy. ");
INSERT INTO zpg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tohzydzi bieññ to ṟid-ro ni byruu gybaa beeiy ru rxuu mbedun-ro, no güyuꞌ ṟid-caḻ leññ yuꞌ ru dxie yâme. ");
INSERT INTO zpg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","No bwieꞌ yâme biahd xtahl gue-yaañ beeiy bial no biaꞌnu chehsh to to yâme. ");
INSERT INTO zpg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","No hor-wé gahc güyuꞌ Spirt-Sant xguîlmbahñ yâme, no guzlo ganii yâme zrieñ xtiidz meññ; to to yâme günii ni gayisnii Spirt-Sant leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Leññ dze-wé yahc nu xtahl meññ-Isṟael Jerusaléṉ ni byruu yahc zrieñ guiedzy gyre lad. Leeyâme ulihbu rzobdiidz xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hor-bieññ yâme ṟidé we naꞌ, bigüieꞌ yâme ru nu apóstl yahc, bydohp meññ-xtahl uga. Rtzunadz yâme, porni gayieññ yâme ganii apóstl yahc xtiidz yâme. ");
INSERT INTO zpg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Modni rtzunadz yâme, no ra saꞌ yâme: ―¿Dâs‑e meññ-Galilea gyre meññ-rieꞌ ni ganii la? ");
INSERT INTO zpg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","No naꞌ, ¿xnahc‑e gayieññ nó ganii yâme dtiidz nó ni bynizyno nó? ");
INSERT INTO zpg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Neꞌ gawieꞌ nó nu meññ-Partia, meññ-Media, meññ-Elamm, meññ-Mesopotamia, meññ-Judea, meññ-Capadocia, meññ-Ponto, meññ-ziaad yahc ñaz-Asia, ");
INSERT INTO zpg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","meññ-Frigia, meññ-Panfilia, meññ-Egipt no meññ-África ni nu gahsh Ciren. No nu meññ-Ṟom zegahc ni nu neꞌ ni nac meññ-Isṟael no zrieñ meññ-bidbiꞌ lahd yâme ni rtzoo yahc ni ne xleiy meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Zegahc ziaad meññ-Cret no meññ-Araby; zrieñx meññ‑e nó, no ¡xnahc‑e gayieññ nó ganii yâme gyre xroꞌ cos yahc ni rtzoo Dioz no gayieññ nó leeu lo dtiidz nó! ");
INSERT INTO zpg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gyre yâme rtzunadz no gazacngann yâmeu, ra saꞌ yâme: ―¿Biahx‑e leeu gyre ni gawieꞌ nó? ");
INSERT INTO zpg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Per zrieñ yâme aaḻ gaxidzyno, ne yahc: ―¡Meññ-rieꞌ nzuhdzy yâme we! ");
INSERT INTO zpg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Were guzli Pedr no gydiby tzipychop apóstl, günii me ndip ra me leeyâme: ―Meññ-Judea no gyre laꞌd ni nu neꞌ Jerusaléṉ, gayapyaꞌ laꞌd rquihñu gann laꞌd nirieꞌ, no leewe lâ guieññ zaꞌgndzi ni gynin. ");
INSERT INTO zpg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nehx leeu mod-ne laꞌd. Meññ-rieꞌ yahc dac‑e nzuhdzy yâme. Rsily ziaꞌr‑e ngâstoo, leer las-nuevy. ");
INSERT INTO zpg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ni gawieꞌ laꞌd gayahc la, leeu we ni günii profet ni le Joel. Mpyquie-rieꞌ günii me, ne me: ");
INSERT INTO zpg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ze ne Dioz: Leññ dzé ni gadziñgahsh gynihty guiedzylie, cshaalaꞌ diSpirtaꞌ lguia gyre meññ. Xiñ-ñooby laꞌd no xiñ-ndzaꞌb laꞌd, zisnin leeyâme; no xiiñ laꞌd ni mêññxtohby lee, zwieꞌ yâme ni glun leeyâme beeiy lo mpcaaḻ. No xmeññ laꞌd ni mînguhl lee, znii xcaaḻ yâme ni rnin. ");
INSERT INTO zpg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","No leññ dze-wé yahc zdedyaꞌ diSpirtaꞌ meññ-mpyquie no meññ-ngünaa ni rtzoo dixtziñaꞌ, no guisnin leeyâme ni dziguiahc. ");
INSERT INTO zpg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Leññ gybaa zwieꞌ meññ guîlrtzunadz ni ctzon. No zegahcu lo guiedzylie zwieꞌ yâme señal yahc: rieñ no gue, no guiahs guhsh. ");
INSERT INTO zpg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Zacncawy lo ncübidz, no zac-nixni lo mboo beeiy rieñ, dze-dgueññ gydzihñ ni guiaad Señor, to dze-ro ni rsahc. ");
INSERT INTO zpg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","No nitisy dxu gnab lo Dioz gylaa la, zlaa de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Meññ-Isṟael, lâ guieññ ni gapyaꞌ laꞌd. Nann laꞌd Dioz bluu me de ni pshahl me Jesúz, to meññ-Nasaret, no gucno me lee lehdy ptzoo Jesúz xroꞌ cos yahc, no guîlrtzunadz, no ni ngann, no ptzoo me leeu ñaz-lo laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Per Dioz ba gahc nann me bia dziguiahc Jesúz, bdee me ñahz günahzy laꞌd leeme, no guhc ni ba ne me gac. No ru ba nu Jesúz lo ña laꞌd, gucno meññ-dirquihñ laꞌd pquehd leeme lo cruzy. No mod-wé bgaꞌdy laꞌd leeme. ");
INSERT INTO zpg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per Dioz bispahñ leeme, güloo leeme ladzyña guîlguhty, porni guîlguhty nehx beeiy ncau leeme. ");
INSERT INTO zpg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ṟeiy-Davit günii me lguia Jesúz, ne me: Naa nannaꞌ tirgahc‑e nu Dioz no naa, No nehx zruganaꞌ, porni gayacno me naa. ");
INSERT INTO zpg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","No leewe rxihlyaꞌ, no rguguian leeme. Naa nannaꞌ guîlguhty nehx stzoo naa mbehty, mazyg glesy Dioz naa, ");
INSERT INTO zpg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","porni lii nehx ssaꞌniꞌ naa lahd mînguty, ni nehx zdeedyiꞌ ñahz gynihty xcuerp xiiñiꞌ ni ndziy lee. ");
INSERT INTO zpg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bluuy naa ñahz ni rdee guîlmbahñ ni nehx ziuꞌ dzé gynihty; no zegahc rxihlyaꞌ porni nuy no naa. ");
INSERT INTO zpg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Rman, gapyaꞌ laꞌd ni uli, gyre nó nann ngydo-ṟeiy-Davit ni guhc difamily nó, guhty me no bygaꞌdzy me, no xbaa me, leexu nu ziaꞌ no nó glo naꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Per ṟeiy-Davit, profet leeme, no leewe nann me togahcs günii Dioz gdee to ṟeiy nó ni gyruu de lo gahc xfamily me no ni guiaꞌn ctzoo mdad xilgar me. ");
INSERT INTO zpg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ṟeiy-Davit, scâsy ni nwieꞌ me ni dziguiahcr lguia ni gübahñ Crist. Leewe günii gahcme, ne me nehx ziaꞌn Crist lahd mînguty, no nehx znihty xcuerp me. ");
INSERT INTO zpg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","No leeme we Jesúz ni bispahñ Dioz lee, no noꞌ bwieꞌ noꞌ guhcu mod-wé. ");
INSERT INTO zpg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","No leewe, biahs me zia me zicchie me coo Dioz lad-drech, no xTad me Dioz bdee Spirt-Sant cuaꞌ me, ni ba nac diidz tzu no leeme. No luxu, güdiiz me nirieꞌ ni gawieꞌ laꞌd no ni gayieññ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dac‑e ṟeiy-Davit biahs zia gybaa, nîcze leegahcme ne: Ze ne Dioz, ra me Señor ni rtzoo mdad naa: “Gürie dcoon lad-drech, ");
INSERT INTO zpg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","xtâ glo ctzon de ni gyre meññ ni rdziadzyno lii guisshiby yâme loꞌy.” ");
INSERT INTO zpg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Laꞌd meññ-Isṟael, racdadzyaꞌ gann laꞌd ni uli: Jesúz ni gazataꞌ lee, ni pquee laꞌd lee lo cruzy la, leeme we ni ptzoo Dioz lee Señor ni rtzoo mdad no ni nac Crist. ");
INSERT INTO zpg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","No diidz ni bieno Pedr leeyâme bydzihñu xtâ leññ xguîlmbahñ yâme, no günabdiidz yâme Pedr no zrieñ apóstl, ra yâme lee: ―Rman, lâ ga noꞌ, ¿xnahc ntzoo noꞌ naꞌ? ");
INSERT INTO zpg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ra Pedr leeyâme: ―Lâ csaan ni nahcsy ni nac laꞌd, no to to laꞌd lâ gyrôbnihs por le Jesucrist lehdy guieññ ba psiaaḻladzy Dioz xguîlquie laꞌd; no zdee me Spirt-Sant laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nirieꞌ ni bdee Jesúz xtiidz me cshahl me, par laꞌd‑e leeu, no zegahcu par xiiñ laꞌd no xtâ gyre meññ ni nur ziht; leeu we gyre meññ ni yqueer tDioz nó riedz lee, leeme we ni rtzoo mdad. ");
INSERT INTO zpg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","No nirieꞌ no zrieñ yahc diidz güluꞌ Pedr xguîlriehñ yâme, ne me: ―¡Lâ gyruu lahd meññ-dirquihñ ni nu ni naꞌ par di gynihty laꞌd dze-gynihty yâme! ");
INSERT INTO zpg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","No leewe, gyre meññ ni bylíladzy ni günii Pedr, byrôbnihs yâme; no dze-wé güyuꞌ beeiy stzonn mily meññ lo xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","No nehx rrugan yâme de ni gatzoo yâme ni galuu apóstl yahc leeyâme. No tohzy nu gyre yâme, no rahgü yâme no rnab yâme lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gyre meññ ni nu uga rtzunadz por xroꞌ cos yahc no zrieñ ni ngann ni ptzoo apóstl yahc. ");
INSERT INTO zpg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","No gyre meññ ni ba bylíladzy xtiidz Dioz ba tohzy guîlriehñ rahp yâme, no to to yâme ni rahp xcos, rdee yâmeu beeiy gahc ñahcu xchieñ gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","No rtoꞌ xtziiñ yâme no zrieñ ni rahp yâme, rguiiz yâme sahcu rcaꞌ meññ-rman ni gayaadz ni yquihñ. ");
INSERT INTO zpg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","No gyre dzé rdohp yâme leññ idoró tohzy. No zegahc ria yâme xiryuꞌ saꞌ yâme, rahgü yâme tohzy no guîlrxihly, no ndruhty yâme nehx rguguia leegahc. ");
INSERT INTO zpg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tirgahc gaguguia yâme Dioz, no gyre meññ ni nu leññ guiedzy-caḻ biuꞌladzy ni gatzoo yâme. No to to dzé ma gane yâme, porni gayislaa Dioz xtahl meññ de lo guîlnadz no gayuꞌ gahc yâme lahd xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","To udzie güya Pedr idoró no Juaṉ beeiy las-trez, porni hor-wé rdohp meññ-Isṟael rignab yâme lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hor-gayuꞌ yâme ruꞌ idoró we naꞌ, bwieꞌ yâme dxie to mpyquie ruꞌ puert, ndang me glo guhl me. Gyre dzé riyno meññ leeme ruꞌ puert ni le Puert-Mos lehdy gnab me gun lo meññ ni ria idoró. ");
INSERT INTO zpg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ru bwieꞌ me ba dzictzu Pedr no Juaṉ leññ idoró, günab me gun leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Were bwieꞌ Pedr no Juaṉ ru dxie me, no ra Pedr leeme: ―¡Bwieꞌ noꞌ! ");
INSERT INTO zpg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Were bwieꞌ me leeyâme, nlâdzy me gun‑e gdee yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ra Pedr leeme: ―Nehx zidnon medy-plat ni medy-or par ndedyaꞌ lii, per ni rapaꞌ, wé we gdedyaꞌ lii; leewe gayapyaꞌ lii, por le Jesucrist meññ-Nasaret, biahsiꞌ no güzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Luxu, günahzy Pedr ña-drech me, gülesy leeme no guctziaawy gahc gyrop nieꞌ me. ");
INSERT INTO zpg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","No biahs gahc me, guzli me, no guzlo gahc gazeꞌ me. Güyuꞌ me leññ idoró tohzy no Pedr no Juaṉ, gazeꞌ me no lé riubeꞌ me guia no gadee me xquix Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Gyre meññ ni nu uga bwieꞌ gazeꞌ me, gadee me xquix Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Modni rtzunadz yâme no bydzie yâme porni bwieꞌ yâme biaḻ me no porni nann yâme leeme we mpyquie ni di raḻ seꞌ, ni rnab gun rbia ruꞌ idoró, ruꞌ puert ni le Puert-Mos. ");
INSERT INTO zpg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","No mpyquie ni biaḻ nieꞌ, ba di ne gahc me guislaa ña Pedr no Juaṉ. Gyre meññ modni rtzunadz, za-güxuunn yahc zigüieꞌ ru zu yâme leññ to ru le Xcorredor Salomóṉ. ");
INSERT INTO zpg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hor-bwieꞌ Pedr‑e naꞌ gadohp meññ, were ra me leeyâme: ―Meññ-Isṟael, ¿bia nacu rtzunadz laꞌd no bia nacu gawiedzie laꞌd noꞌ? ¿Nlâdzy laꞌd noꞌ psiaḻ mpyquie-rieꞌ nunzy porni rwieꞌ laꞌd beeiyu noꞌ, o porni rzacbeeiy noꞌ Dioz la? ");
INSERT INTO zpg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Per dac‑e ze leeu. Mpyquie-rieꞌ biaḻ me par güluguia Dioz Xiiñ me Jesúz. Dioz-rieꞌ, leeme we xDioz dmeññ nó ni güyuꞌ yahc ba xtze, lee we xDioz Braṉ, Isac no Jacop. Jesúz‑e ni bigynahzy laꞌd lee no ni güiynot lee lo guxtisy. No ru gucladzy Pilat nislaa leeme, di ñacladzy laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Per nehx günab laꞌd gylaa Jesúz, to mpyquie-tziaawy ni rtzoo ni nac xñahzû, aaḻ günab laꞌd bylaa to mpyquie-rgaꞌdy meññ. ");
INSERT INTO zpg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","No modé bgaꞌdy laꞌd mpyquie ni rdee guîlmbahñ, per Dioz bispahñ leeme de lahd mînguty. No de niwé we rdee noꞌ diidz ni bwieꞌ noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Porni Jesúz beeiyu lee, leewe biaḻ nieꞌ mpyquie-rieꞌ ni gawieꞌ laꞌd no ni rzaclo laꞌd lee. No porni rlídadzy noꞌ Jesúz, leewe biaḻ nieꞌ mpyquie-rieꞌ zaꞌgndzi ñaz-lo gyre laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Meññ-Isṟael, naa nannaꞌ bgaꞌdy laꞌd Jesúz porni ndaagü xguîlriehñ laꞌd, leewe ptzohd mod-ptzoo gahc xguxtisy yahc laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ptzoo laꞌd leeme ze lehdy guhc mod-günii profet yahc ba xtze, ru ne yâme Crist ni pshahl Dioz lee, tedy me gyrehzy ni nadz. ");
INSERT INTO zpg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","No leewe, lâ gyo Dioz no lâ csaan ni nahcsy ni nac laꞌd, lehdy csiaaḻladzy Dioz gyre xguîlquie laꞌd, no were zactziaawy xguîlmbahñ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","No Dioz cshahl me Jesúz lo guiedzylie sto ni güle me lee ba xtze diaa par guiaad guislaa nó de lo guîlnadz. ");
INSERT INTO zpg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Per Crist guiaꞌnr me gybaa xtâ dze-ba diaa bistziaawy Dioz gyre ni nu par gac, mod-günii xprofet me ni güyuꞌ yahc ba xtze. ");
INSERT INTO zpg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Porni Moiséz ra me dmeññ nó ni güyuꞌ yahc ba xtze: “Gyruu to profet lahd gahc dmeññ nó. Cshahl Dioz leeme mod-pshahl gahc me naa. Lâ gzoob xtiidz profet-wé gyre mod-ga me laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Porni gyre dxu di gzoob xtiidz me la, zruu lahd xmeññ me.” ");
INSERT INTO zpg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’No gyre profet, xtâ Samuel diaa, günii yâme ni gayahc ni naꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Laꞌd‑e meññ ni ziaad de profet yahc, no par laꞌd‑e bdee Dioz diidz ni ctzoo me no dtadgul yahc nó ba xtze, dze-gu me Braṉ: “Gyre meññ ni tzu lo guiedzylie scaꞌ yâme dlaꞌyaꞌ por xiiñ yahquiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","No hor-bispahñ Dioz Xiiñ me Jesúz, nier gahc ru nu laꞌd pshahl me lee, par güluꞌ xlaꞌy me laꞌd, lehdy to to laꞌd csaan ni nahcsy ni nac. ");
INSERT INTO zpg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Gayuno ziaꞌ Pedr no Juaṉ diidz meññ, tohzy bydzihñ bahl yahc, no xjefy meññ-rahp ruꞌ idoró, no meññ-nac yahc saduceu. ");
INSERT INTO zpg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gyre yâme modni gadziaꞌdzy porni galuu Pedr meññ no Juaṉ lguia ni guhty Jesúz no gübahñ me sto no zegahc gybahñ meññ ni ba guhty. ");
INSERT INTO zpg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","No günahzy gahc yâme Pedr no Juaṉ, güluꞌ yâme lee lidzyguiib par gyruu xtâ gyrer guiaal, porni ba udzie bygaꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Per xtahl meññ bylíladzy xtiidz Dioz ni bieno Pedr no Juaṉ leeyâme; nunzy meññ-mpyquie byne yâme beeiy gaay mily. ");
INSERT INTO zpg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ni byre guiaal, xguxtisy guiedzy, no zrieñ mînguhl yahc ni nac guxtisy no muextr ni ruuḻ yahc xleiy Moiséz, bydohp yâme Jerusaléṉ, ");
INSERT INTO zpg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","no Anáz ni nac xjefy gyre bahl, Caifáz, Juaṉ, Lejandr no gyre meññ-xfamily xjefy yahc gyre bahl. ");
INSERT INTO zpg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Were pshalcaꞌ yâme Pedr no Juaṉ, bzu yâme lee glawy, no ra yâme lee: ―¿Dxu no xtiidz gatzoo laꞌd mod-rieꞌ, o dxu pshahl laꞌd ctzoo laꞌd ze? ");
INSERT INTO zpg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedr naꞌ, ulihbu nu Spirt-Sant xguîlmbahñ me, were ra me meññ-wé yahc: ―Laꞌd ni dxie neꞌ ni nac xguxtisy guiedzy, no zrieñ mînguhl yahc ni nac guxtisy lahd meññ-Isṟael: ");
INSERT INTO zpg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ganabdiidz laꞌd noꞌ lguia ni gucno noꞌ to mpyquie ni nguidz nieꞌ no xnahc biaḻ me. ");
INSERT INTO zpg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Beeiy gynii noꞌu ñaz-lo laꞌd lehdy gann gyre meññ-Isṟael leeu. Mpyquie-rieꞌ ni zu lo laꞌd ni biaḻ nieꞌ, Jesúz meññ-Nasaret, wé we psiaḻ leeme. Lee we Jesúz ni biꞌdy laꞌd lee to lo cruzy. Per Dioz bispahñ leeme de lahd mînguty. ");
INSERT INTO zpg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","No Jesúz, leeme we zidguiahc beeiy guie ni di ne laꞌd nquihñ ru rzaa laꞌd yuꞌ, per naꞌ lehbu ba nash squiñp ru raa guie ni ma rquihñ lehdy tzaa yuꞌ zaꞌgndzi. ");
INSERT INTO zpg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","No lehzyme we beeiy guislaa nó, porni nehx nu sto meññ ni pshahl Dioz lee lo guiedzylie lehdy nislaa nó de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ptzunadz gyre meññ-nac guxtisy hor-bwieꞌ yâme ganii Pedr no Juaṉ no nehx rdzie yâme, no porni gunn yâme nehx meññ-güya scuely leeyâme. No bzaclo yâme meññ-rieꞌ we ni güzeꞌ no Jesúz. ");
INSERT INTO zpg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","No gawieꞌ yâme zuno Pedr no Juaṉ mpyquie-caḻ ni biaḻ nieꞌ. No leewe gydi bia mód nruu yâme contr Pedr no Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Were ptzoo guxtisy mdad byruu meññ-wé diby lad, par biaꞌn yâme lehzy yâme, bie yâme diidz, ");
INSERT INTO zpg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ra saꞌ yâme: ―¿Bia mód‑e naꞌ ntzoo nó mpyquie-rieꞌ yahc? Nehx beeiy ncaꞌdzy nó nirieꞌ ni ngann ni ptzoo yâme, porni gyre meññ ni nu yahc Jerusaléṉ ba nanndoo leeu. ");
INSERT INTO zpg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Per par di gannr gyre meññ leeu mazy la, gzu nó didz-nahcsy lo yâme lehdy ba di gluu yâme meññ mazy lguia Jesúz. ");
INSERT INTO zpg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Were pshalcaꞌ yâme Pedr gyzac no Juaṉ, ra yâme lee: ―Gax lâ gann, glohdy ngâstoo, na di gyniir laꞌd no gluur laꞌd meññ mazy lguia Jesúz. ");
INSERT INTO zpg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Were günii Pedr no Juaṉ, ra leeyâme: ―Lâ güieꞌzy zaꞌgndzi bâḻ ma xñahzu gzoob noꞌ xtiidz laꞌd xilgar ni nzoob noꞌ xtiidz Dioz; ");
INSERT INTO zpg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","porni nehx beeiy csaꞌn noꞌ de ni gynii noꞌ gyre ni bwieꞌ noꞌ no gyre ni bluu Jesúz noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Luxu bislaa guxtisy leeyâme. Per nier gax bzu yâme didz-nahcsy lo Pedr no Juaṉ. No ba di ndzial guxtisy bia ntzoo leeyâme, porni gyre meññ gaguguia Dioz porni bwieꞌ yâme biaḻ mpyquie-caḻ. ");
INSERT INTO zpg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mpyquie ni biaḻ nieꞌ por xmilagür Dioz, rahp me mazy de cuarent ihz. ");
INSERT INTO zpg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bylux byruu Pedr no Juaṉ lidzyguiib, gubyguiat yâme ru nu xirman yâme, bieno yâme diidz lee gyre ni ra xjefy yahc bahl leeyâme no zrieñ mînguhl yahc ni nac guxtisy. ");
INSERT INTO zpg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Hor-bieññ yâme nirieꞌ we naꞌ, guzlo gyre yâme gaguguia yâme Dioz, ra yâme: ―Señor, lii ni rtzoo mdad noꞌ, lii we ni bzaa gybaa, guiedzylie, nisdoo, no gyre cos ni nu lou. ");
INSERT INTO zpg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","No lii güninoy Davit ni ptzoo xtziiñiꞌ ba xtze, no bisnii Spirt-Sant leeme, ne me: ¿Biahx‑e nacu aaḻ rdziaꞌdzy meññ? ¿Biahx‑e nacu, aaḻ ni nehx rquihñ, rguꞌ ihqy yâme? ");
INSERT INTO zpg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bydohp ṟeiy yahc ni nu byzaꞌzy no jefy yahc par guhc yâme tohzy, byruu yâme contr Dioz no contr Crist ni pshahl me lee. ");
INSERT INTO zpg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’No mod-wé guhc leññ guiedzy-rieꞌ. Herody no Ponzy Pilat, guhc yâme tohzy no meññ-nehx meññ-Isṟael no gahc zrieñ meññ-Isṟael, par byruu yâme contr Xiiñiꞌ Jesúz ni güleꞌy lee. ");
INSERT INTO zpg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gyre ni güniiy ba xtze gac la, lee we gyre ni ba ptzoo yâme. ");
INSERT INTO zpg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Señor, noꞌ meññ-rtzoo xtziiñiꞌ, no meññ-rieꞌ yahc riñlo yâme ctzie yâme noꞌ; rnab noꞌ lii gucno noꞌ lehdy guno noꞌ xtiidziꞌ meññ no di gydzie noꞌ mbehty. ");
INSERT INTO zpg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Rnab noꞌ csiaḻiꞌ meññ-gayac-ure no gacnoy noꞌ ctzoo noꞌ ni ngann yahc no zrieñ guîlrtzunadz hor-gzaꞌd noꞌ le Xiiñiꞌ Jesúz, mpyquie-tziaawy ni pshahliꞌ lee. ");
INSERT INTO zpg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Scâsy bylux günab yâme lo Dioz, bieññ yâme byniꞌby ru dxie yâme. No hor-wé güyuꞌ Spirt-Sant xguîlmbahñ gyre yâme, no guzlo bieno yâme meññ xtiidz Dioz no nehx rdzie yâme. ");
INSERT INTO zpg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Gyre meññ ni ba bylíladzy xtiidz Dioz, tohzy guîlriehñ rahp yâme no ndruhty nehx ne par lehzy gyre ni rahp, mazyg ne yâme, xchieñ gyre yâme we leeu. ");
INSERT INTO zpg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apóstl yahc naꞌ, no xroꞌ poder gayuno yâme diidz meññ de ni bwieꞌ yâme gübahñ Jesúz, no Dioz modni gaguꞌ xlaꞌy leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","No leewe, ndruhty de leeyâme nehx riaadz mbehty porni gyre meññ-rman ni rahp lyu o yuꞌ, rtoꞌ yâmeu no riyno yâme sahcu ");
INSERT INTO zpg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","rcaꞌ apóstl; no apóstl rguiiz leeu, rcaꞌ meññ-rman ni gayaadz ni yquihñ. ");
INSERT INTO zpg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","De lahd yâme güyuꞌ to mpyquie le José, per apóstl yahc ptzee le me, güluꞌ yâme le me Bernabé (lo xtiidz yâme rniiu, To ni Risshihly). Meññ-Chipre leeme, no ziaad me de lo xfamily Leví. ");
INSERT INTO zpg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mpyquie-rieꞌ, güdahp me to lyu, per ptoꞌ me leeu no güiyno me sahcu bdee meu apóstl yahc. ");
INSERT INTO zpg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Per güyuꞌ sto mpyquie lahd yâme le Ananíaz, tziahl me le Safir. Zegahc ptoꞌ yâme to lyu ni güdahp yâme. ");
INSERT INTO zpg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Per mpyquie-rieꞌ nehx bdee me gyre sahcu apóstl yahc, mazyg ptzoo me diidz no tziahl me, güloo yâme lo xmedyu guian-no yâme. Ru bicsaꞌn me leeu we naꞌ, ");
INSERT INTO zpg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ra Pedr leeme: ―Ananíaz, ¿bia nacu bdeedyiꞌ ñahz güyuꞌ bêndzab xguîlmbahñiꞌ, neꞌy nisquieey Spirt-Sant, bian-noy lo medy ni ptoꞌy lyu? ");
INSERT INTO zpg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Dâs‑e guhc xchieñiꞌ lyu antzy ni ctoꞌyu la? No medy ni cuaꞌy ru ba bylux ptoꞌy leeu, ¿dâs‑e guhcu xmedyiꞌ la? ¿Biaz nacu naꞌ ptzooy ze? Dac‑e meññ bisquieey. ¡Dioz‑e gucladzyiꞌ nisquieey lee! ");
INSERT INTO zpg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Scâsy bieññ Ananíaz günii Pedr ze, biahb gahc me lo yu no guhty me. Gyre meññ, modni bydzie ni bieññ mod-guhc. ");
INSERT INTO zpg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Hor-bwieꞌ yâme guhty me, biahd chohp tzonn mpyquiextohby, pchaḻ lahr leeme no biycaꞌdzy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Güdahpu beeiy tzonn hór de ni guhc niwé, tohzy bydzihñ tziahl Ananíaz. Per nehx nann me bâḻ ba guhty tziahl me. ");
INSERT INTO zpg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Were ra Pedr leeme: ―¿Ulizu gyre sahc lyu nirieꞌ ni bidno tziahliꞌ la? Ra me Pedr: ―Uliu, gyre sahcu we ni bidno me. ");
INSERT INTO zpg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ra Pedr leeme: ―¿Bia nacu guhc laꞌd tohzy ne laꞌd nwieꞌ laꞌd bâḻ beeiy nisquiee laꞌd xiSpirt Dioz? Meññ-ziaad yahc wé ni ba dzictzu leññ yuꞌ, tziahliꞌ we biycaꞌdzy yâme. Ngâstoo wé ba tziyno yâme lii, igaꞌdzyiꞌ zegahc. ");
INSERT INTO zpg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lohg hor-wé biahb Safir lo yu ñaz-lo Pedr no guhty gahc me. Ru bydzihñ mpyquiextohby, bwieꞌ yâme ba nash Safir lo yu guhty. Gyzac güya yâme biycaꞌdzy yâme leeme coo gahc ru bygaꞌdzy tziahl me Ananíaz. ");
INSERT INTO zpg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gyre meññ-idoo modni bydzie no gyre meññ-bieññ mod-guhc. ");
INSERT INTO zpg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Gucno Dioz apóstl yahc par ptzoo yâme xtahl ni ngann no zrieñ guîlrtzunadz yahc leññ guiedzy ru nu yâme. No leññ ru le Xcorredor Salomóṉ rdohp gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Per zrieñ meññ rdzie tzu lahd yâme, nîcze modni gaguguia meññ-guiedzy leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Xtahl meññ-mpyquie gane ni galíladzy xtiidz Dioz, zegahcu meññ-ngünaa. ");
INSERT INTO zpg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Meññ-gayac-ure yahc, güloo yâme lee leññ yuꞌ no güdihsh yâme lee lo ñahz. Nu yâme nash lo luꞌn no nu yâme nash lo daꞌ, lehdy ru tedy Pedr, ni yqueꞌzy ximble me chehsh yâme, bac biaḻ lahd yâme. ");
INSERT INTO zpg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","No zegahc meññ-nu yahc gahsh gá de Jerusaléṉ bidno yâme meññ-gayac-ure no meññ-gatzoo gasahc mbenahcsy lee; no gyre yâme biaḻ. ");
INSERT INTO zpg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Niwé bwieꞌ xjefy gyre bahl no meññ-nac yahc saduceu ni nuno me lee, modni ptzumvidy yâme; ");
INSERT INTO zpg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","no günahzy gahc yâme apóstl yahc, güluꞌ yâme lee lidzyguiib leññ guiedzy. ");
INSERT INTO zpg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Per Dioz pshahl me to ángel guiaal, bicshal lidzyguiib lehdy güloo leeyâme. No luxu, ra leeyâme: ");
INSERT INTO zpg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Lâ tza idoró, lâ guno meññ diidz lguia guîlmbañ-coby ni rdee Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","No mod-wé ptzoo yâme: Scâsy byre guiaal, güya gahc yâme idoró no guzlo galuu yâme meññ. Lóni galuu yâme meññ, biahd xjefy gyre bahl no zrieñ meññ-idoo bydohp yâme no pshalcaꞌ yâme gyre mînguhl ni rahc ni rnii lahd meññ-Isṟael, lehdy ptzoo yâme diidz bia mód ctzoo yâme apóstl. Luxu ptzoo yâme mdad meññ-rahp ruꞌ idoró za ziycaꞌ apóstl yahc lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bydzihñ yâme pshal yâme lidzyguiib, per ndruhty nehx bydzial yâme lee. Gubyguiat yâme, ");
INSERT INTO zpg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ra yâme guxtisy: ―Ndruhty nehx bydzial noꞌ lee leññ lidzyguiib. Nyagu dziꞌdzy no nu soldad yahc ni gayahpu. Per hor-pshal noꞌu, ndruhty nehx bydzial noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ru bieññ xjefy gyre bahl ni ne yâme no xjefy meññ-rahp ruꞌ idoró no xjefy yahc bahl, ba di rdzial bia ctzoo yâme, ra saꞌ yâme: ―¿Xnahc‑e naꞌ dzigydibylgaa nirieꞌ? ");
INSERT INTO zpg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lohb hor-wé bydzihñ to mpyquie, ra leeyâme: ―Meññ-güluꞌ laꞌd lee lidzyguiib nu yahc leññ idoró, galuu yâme meññ. ");
INSERT INTO zpg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Were güya xjefy soldad no xmeññ me biycaꞌ leeyâme, per sinn di ntzoo nsahc leeyâme, porni rdzie yâme cshadguie meññ-guiedzy leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ru bydzihñ yâme, güiyno yâme apóstl ru dxie guxtisy yahc. Were ra xjefy gyre bahl leeyâme: ");
INSERT INTO zpg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Dâs‑e ba ra noꞌ laꞌd na di gluur laꞌd meññ lguia Jesúz la? Per laꞌd nehx rieññ laꞌd. Gyre meññ-Jerusaléṉ ba bieññ ni galuu laꞌd no gadzibguîlquie dir laꞌd noꞌ, nehd noꞌ biꞌdy mpyquie-wé. ");
INSERT INTO zpg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Were ra Pedr leeyâme no zrieñ apóstl: ―Racladzyu gzoob noꞌ nier xtiidz Dioz que xtiidz meññ. ");
INSERT INTO zpg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","XDioz difamily nó ni güyuꞌ yahc ba xtze, leeme we bispahñ Jesúz ni biꞌdy laꞌd lee lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Per Dioz güluguia leeme, no dxie me coo Dioz lad-drech lehdy ctzoo me mdad gyre meññ no par guislaa me meññ de lo guîlnadz ni ziaad, lehdy meññ-Isṟael, csaan yâme ni nahcsy ni nac yâme no csiaaḻladzy Dioz xguîlquie yâme. ");
INSERT INTO zpg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Noꞌ nann noꞌ ni uli we nirieꞌ porni bwieꞌ noꞌu, no nehx nunzy noꞌ, mazyg zegahc Spirt-Sant ni rdee Dioz meññ-rzoob xtiidz me. ");
INSERT INTO zpg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hor-bieññ yâme nirieꞌ we naꞌ, modni bydziaꞌdzy yâme, gucladzy yâme ngaꞌdy yâme apóstl yahc. ");
INSERT INTO zpg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Per lahd guxtisy yahc nu to meññ-nac fariseu ni le Gamaliel, nac me to muextr ni nann xleiy Moiséz zaꞌgndzi. No mpyquie-rieꞌ rahp xpeeiy meññ-guiedzy leeme. Were biahs me, günab me gyruu apóstl yahc diby lad doozy hór. ");
INSERT INTO zpg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Luxu ra me guxtisy: ―Laꞌd ni nac meññ-Isṟael, gax lâ güieꞌ zaꞌgndzi bâḻ xñahzu ctzuné laꞌd mpyquie-rieꞌ yahc. ");
INSERT INTO zpg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Lâ guitsêlou laꞌd ni ptzoo Teudas to tiémp. Ptohp me beeiy tahp gayuu meññ ni cueꞌ coo me lehdy ñahc me to jefy. Per di ñaḻu leeme, aaḻ bgaꞌdy meññ leeme. No gyre meññ ni cueꞌ coo me byraꞌdz yahc, no wéhdy byluxu. ");
INSERT INTO zpg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","No mod-wé gahc ptzoo sto meññ-Galilea ni le Jud leññ dzé ni gadohp le gyre meññ. Pquihly me xtahl meññ cueꞌ coo me. Per zegahc bgaꞌdy meññ leeme, no gyre meññ ni cueꞌ coo me byraꞌdz yahc. ");
INSERT INTO zpg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","No leewe, gayapyaꞌ laꞌd guislaa laꞌd mpyquie-rieꞌ yahc, no di ctzoo laꞌd leeyâme mbehty. Bâḻ meññ güxiññ ihqy ni gatzoo yâme la, zdzihñ to dzé we znihtyu. ");
INSERT INTO zpg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Per bâḻ de Dioz ziaadu la, nehx zaḻ csandzie laꞌd leeu. Lâ güieꞌ gá, na di aaḻ gyruu laꞌd contr Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Beeiy bzoob yâme xtiidz Gamaliel. Luxu pshalcaꞌ yâme apóstl yahc, güdihñ yâme lee no ra yâme lee: ―Ba di gluur laꞌd meññ lguia Jesúz. No bislaa yâme leeyahc. ");
INSERT INTO zpg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Byruu apóstl yahc de ru dxie guxtisy, modni rxihly yâme porni gülesyguia Dioz leeyâme xtâ bdee me ñahz guhc yâme gyrehzy porni xmeññ Jesúz leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","No nehx psandzie yâme ni gayuno yâme meññ xtiidz Jesucrist. Tirgahc galuu yâme meññ leññ idoró, no zegahcu ria yâme yuꞌ por yuꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Leññ gahc tiemp-wé, ba ma gane xtahl xmeññ Crist. No guzlo meññ-rnii didz-griegü ni nu lahd yâme galesyno yâme meññ-rnii didz-hebreu. Ne yâme meññ-ngünaviud ni nu lahd yâme, nehx riygahl ni rcaꞌ par tedydzé, porni nehx rcaꞌ yâme tohzy mdid no meññ-ngünaviud ni nac meññ-hebreu. ");
INSERT INTO zpg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Were gydiby tzipychop apóstl ptzoo yâme diidz ptohp yâme gyre xmeññ Crist. Hor-ba bydohp gyre yâme we naꞌ, ra apóstl leeyâme: ―Nehx xñahzu csaꞌn noꞌ dixtziiñ noꞌ de ni rigyuno noꞌ meññ xtiidz Dioz nunzy par quiiz noꞌ ni gaquihñ meññ-rieꞌ yahc. ");
INSERT INTO zpg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Leezuwe, rman, beeiydí lâ cue gahdzy mpyquie lahd laꞌd ni nann laꞌd rtzoo ni mos, no ni rahp guîlriehñ, no ni neññ ulihbu nu Spirt-Sant xguîlmbahñ. No leeyâme csan-no noꞌ ctzoo dziñ-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Noꞌ nehx ssaꞌn noꞌ dixtziiñ noꞌ de ni rnab noꞌ lo Dioz no de ni dzigyuno noꞌ meññ xtiidz me. ");
INSERT INTO zpg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Gyre yâme biuꞌladzy mod-ne apóstl yahc, no mod-wé ptzoo yâme. Güle yâme rman-rieꞌ yahc: Stebn, to mpyquie ni ulihbu rlíladzy xtiidz Dioz no ni ulihbu nu Spirt-Sant xguîlmbahñ; no Felipy, Prócoro, Nicanor, Timóṉ, Parmenas no Nicoláz, to meññ-byruu ciuda-Antioquía ni guzlo rtzoo ni ne xleiy meññ-Isṟael antzy ni gac me xmeññ Crist. ");
INSERT INTO zpg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Byluxu, bidno yâme meññ-rieꞌ yahc lo apóstl par günab lo Dioz no pshob ña chehsh meññ-gübee. ");
INSERT INTO zpg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","No xtiidz Dioz ma gayann meññu, no gane xtahl xmeññ Crist Jerusaléṉ; no zegahc xtahl bahl yahc bylíladzy xtiidz Dioz no guzlo bzobdiidz yâmeu. ");
INSERT INTO zpg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","To mpyquie ni le Stebn, ulihbu nu xlaꞌy Dioz leeme no beeiyu leeme rtzoo me xroꞌ guîlrtzunadz yahc no zrieñ ni ngann leññ guiedzy ru nu me. ");
INSERT INTO zpg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","To dzé we naꞌ biahd to cuib meññ-ria idoo ni le: Ru rdohp meññ-ba nehx nac mós ni rzee. No tohzy no leeyâme ziaad meññ-Ciren, meññ-Alejandría, meññ-Cilicy no meññ-Asia. No guzlo gadeḻydiidz yâme no Stebn. ");
INSERT INTO zpg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Per di ñaḻ ntzoo yâme gan leeme por guîlnann ni rahp me no por xiSpirt Dioz ni risnii leeme. ");
INSERT INTO zpg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Leewe güdix yâme chohp tzonn meññ par günii ni nehx uli contr leeme, ne: ―Noꞌ bieññ noꞌ ganii me didz-nahcsy contr Moiséz no contr Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","No mod-wé pquihly yâme meññ-guiedzy byruu contr Stebn, no gahc mînguhl yahc ni nac guxtisy no muextr ni ruuḻ yahc xleiy Moiséz. Günahzy yâme leeme, güiyno yâme leeme lo guxtisy yahc ni rahc ni rnii. ");
INSERT INTO zpg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","No güiyno yâme meññ-biax lehdy bisquiee yâme guxtisy, ra yâme: ―Mpyquie-rieꞌ nehx rsaꞌn me ni rnii me contr diydoró nó ni nda, ni nehx rsaꞌn me ni rruu me contr xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","No bieññ noꞌ ganii me, ne me Jesúz ni nac meññ-Nasaret, zguiñguie me idoro-rieꞌ, no stzee me costumbr ni ganii xleiy Moiséz ctzoo nó. ");
INSERT INTO zpg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Gyre meññ ni dxie yahc uga, bwieꞌ yâme lo Stebn, no hor-wé lé rluuw beeiy lo x‑ángel Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Were ra xjefy gyre bahl leeme: ―¿Uliu la, rniiy mod-ne meññ-wé yahc? ");
INSERT INTO zpg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ra Stebn leeyâme: ―Betzy no laꞌd ni zidguiahc beeiy dad, lâ guieññ ni gapyaꞌ laꞌd. Dioz ni nu to ru mos, günino me dtad nó Braṉ ni güyuꞌ ba xtze ru nu ziaꞌ me lo ṟegioṉ-Mesopotamia, dze-dgueññ gybiꞌ me Haráṉ, ");
INSERT INTO zpg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ra me lee: “Psaꞌn xguiedzyiꞌ no xfamilyiꞌ no gybiꞌy ru gapyaꞌ lii.” ");
INSERT INTO zpg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","No ze ptzoo me, byruu me lo ṟegioṉ-Caldea, no zia me Haráṉ. No dze-ba guhty xtad me, Dioz bidno leeme neꞌ ru nu laꞌd ni naꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Per nehx cuaꞌ me ni diby laꞌy lyu par ñahc xchieñ me, per ra Dioz leeme: “Lyu-rieꞌ zahcu xchieñ xfamilyiꞌ dzé ni ba guhtyiꞌ”, nîcze nehx ziaꞌ rahp xiiñ me tiemp-wé. ");
INSERT INTO zpg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","No zegahc ra Dioz leeme: “Xfamilyiꞌ ziuꞌ yâme to ru rtzoo zrieñ meññ mdad, no gac yâme mós ni gyzee par ctzoo xtziiñ zrieñ meññ, no stzoo ssahc meññ leeyâme leññ tahp gayuu ihz.” ");
INSERT INTO zpg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Per Dioz ra leeme: “Naa ycuquixaꞌ meññ-wé yahc ni ctzoo csahc leeyâme. No luxu, gyruu yâme de uga, guiaad yâme neꞌ, gzacbeeiy yâme naa.” ");
INSERT INTO zpg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","No bdee Dioz diidz ni ctzoo me no Braṉ de ni tzu señ lady gyre xmiꞌñ me ni nac mdoñooby lo shun dzé de ni gahl yâme. No leewe, Braṉ bidguiahl to xiiñ me güyuꞌ le Isac, no lo shun dzé de ni guhl me, güluꞌ Braṉ señ lady me. No Isac bidguiahl xiiñ me güyuꞌ le Jacop, no Jacop bidguiahl tzipychop xiiñ me, no leeyâme we dtadgul yahc nó ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Meññ-rieꞌ yahc naꞌ ni nac dtadgul yahc nó ni güyuꞌ ba xtze, gucnéladzy yâme to behtzy yâme ni güyuꞌ le José. No por leeu ptoꞌ yâme leeme, cuaꞌ meññ-güiyno leeme Egipt. Per Dioz gucno me José, ");
INSERT INTO zpg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","bislaa me lee de lo gyre ni nadz ni güdedy me. No bdee me guîlnann lee, no porni gucno Dioz leeme, leewe gyre ni ptzoo me biuꞌladzy Faraóṉ, xṟeiy Egipt. No por leeu günii ṟeiy gac José xgobernador Egipt no zegahc ctzoo me mdad gyre ni nu li ṟeiy. ");
INSERT INTO zpg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Dze-nac José gobernador, bidtzu guîlrlahn Egipt no gydo lo ṟegioṉ-Canáṉ. Gyre dmeññ nó ni güyuꞌ dze-wé yahc, nehx rahp yâme ni gahgü yâme ru nu yâme. ");
INSERT INTO zpg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ru bieññ Jacop diidz de ni Egipt nu trigü, were pshahl me xmiꞌñ me, leeyâme we dmeññ nó ni güyuꞌ ba xtze güya bicshii leeu. Nirieꞌ we ni nier lee güya yâme. ");
INSERT INTO zpg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ni byrohpu güya yâme, were ba gu José leeme we behtzy yâme. No mod-wé, gunn Faraóṉ dxu meññ‑e José. ");
INSERT INTO zpg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Güdahpu dzé, were günab José biahd xtad me Egipt no gydiby gyre xfamily me. Setentaycincü yâme por gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","No leewe, bidbiꞌ Jacop Egipt, no wé guhty me, no zegahcu xmiꞌñ me ni nac dtadgul yahc nó ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","No Siquem diaa bygaꞌdzy yâme, to lo lyu ru güxii Braṉ lo xmiꞌñ Hamor ni nu uga. ");
INSERT INTO zpg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Dze-ba gadziñgahsh ni gac mod-bdee Dioz xtiidz me Braṉ, dmeññ nó ni güyuꞌ ba xtze, modni bydáhl yâme Egipt. ");
INSERT INTO zpg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","No leññ dze-wé, bidtzu sto ṟeiy Egipt, no nehx bzaclo me José. ");
INSERT INTO zpg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ṟeiy-wé bisquiee me dmeññ nó ni güyuꞌ ba xtze, no ptzoo psahc me lee, no ptzoo me mdad leeyâme psaaby ximdoñooby yâme scâsy rahl, lehdy di gydáhl yâme. ");
INSERT INTO zpg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Lo tiemp-wé bidguiahl Moiséz, to mdoo ni byxilyno Dioz lee. No tzonn mboo güdahp xtad no xmam me leeme leññ yuꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ru ba di ñaḻ ngungaꞌdzyr yâme leeme, were güloo yâme leeme, no psaꞌn yâme leeme lehzyme, no xiñ-ndzaꞌb gahc ṟeiy-Faraóṉ bydzial leeme. No wé bisniꞌzy leeme scâsy ñahcu xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","No wé nu me, byzeedy me gyre ni nann meññ-Egipt, no xroꞌ guîlnann günii me no ptzoo me gyreu. ");
INSERT INTO zpg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Cuarent ihz rahp me, biuꞌladzy me bictixlo me meññ-xguiedzy me, lee we meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Hor-bydzihñ me we naꞌ, bwieꞌ me gatzoo gasahc to meññ-Egipt to meññ-Isṟael. Were günahzy me meññ-Egipt, biꞌdy me lee par bislaa me xmeññ me. ");
INSERT INTO zpg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ptzoo Moiséz mod-wé porni nlâdzy me ñieññ meññ-xguiedzy me Dioz‑e pshahl leeme par gboo me leeyâme de ru nac yâme mós. Per xmeññ me nehx bieññ yâmeu. ");
INSERT INTO zpg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ni byre guiaal, gyzac bwieꞌ Moiséz schohp meññ-Isṟael gadeḻy yahc. Were za me zictzily me leeyahc, bydzihñ me ra me lee: “¿Bia nacu rdeḻy laꞌd? ¿Dâs‑e nann laꞌd la, meññ-tohzy guiedzy‑e laꞌd?” ");
INSERT INTO zpg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Were byruu mpyquie-wé ni gatzoo gasahc sto meññ xguiedzy gahc, pchaꞌby me Moiséz no ra me lee: “¿Dxu günii lii gac guxtisy par ctzooy mdad noꞌ no par gahbyiꞌ noꞌ nehx xñahzu gatzoo noꞌ? ");
INSERT INTO zpg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿O neꞌy igaꞌdyiꞌ naa mod-bgaꞌdy gahquiꞌ to meññ-Egipt naag la?” ");
INSERT INTO zpg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Hor-bieññ Moiséz niwé, byxuunn gahc me zia me ru le Madiáṉ. Uga güyuꞌ me guhc me meññ-mbiuhz, no uga bidtap tziahl me chohp xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Güdahpu scuarent ihz, bwieꞌ Moiséz to x‑ángel Dioz to lo yag-guiahtz ru gadahl bial lo yu-bihdzy, gahsh gá to dahñ ni le Sinaí. ");
INSERT INTO zpg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ru bwieꞌ Moiséz niwé naꞌ, ptzunadz me. No lóni gabigy me gahsh gá lehdy güieꞌ me bia leeu, tohzydzi bieññ me günii Dioz, ra leeme: ");
INSERT INTO zpg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Naa we xDioz xmeññiꞌ ni güyuꞌ yahc ba xtze, xDioz Braṉ, Isac no Jacop.” Niwé bieññ Moiséz, bydzie me lé rzîbyyoob me, no ba di nlesy ihqy me lehdy nwieꞌ me. ");
INSERT INTO zpg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","No ra Dioz leeme: “Güloo guidguial nieꞌy porni ru zuꞌy, lgar-nda we leeu. ");
INSERT INTO zpg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Naa gawien gyre ni nadz ni gadedy dmeññaꞌ ni nu yahc Egipt, no gayieññaꞌ xriedz yâme modni gazacno yâme. No por lee we ziaḻaꞌ lehdy gboon leeyâme de ru nu yâme. Güde naꞌ, naa cshaalaꞌ lii Egipt, lehdy tzaꞌy ru nu yâme.” ");
INSERT INTO zpg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Moiséz, leeme we ni byruu meññ-Isṟael contr lee ru ra yâme leeme: “¿Dxu günii lii gac guxtisy par ctzooy mdad noꞌ no par gahbyiꞌ noꞌ nehx xñahzu gatzoo noꞌ?” Per leegahcme we ni günino to x‑ángel Dioz lee ni bwieꞌ me lo yag-guiahtz, no modé pshahl Dioz leeme lehdy gac me xguxtisy meññ-Isṟael no lehdy gboo me leeyâme de ru nu yâme. ");
INSERT INTO zpg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Leewe ptzoo me xroꞌ guîlrtzunadz yahc no zrieñ ni ngann ru nu me Egipt, no ru güdedy yâme Nisdo-Xni par güloo me dmeññ yahc nó ru guhc yâme mós. No zegahc ptzoo me xroꞌ guîlrtzunadz yahc no zrieñ ni ngann leññ cuarent ihz dze-güzeꞌ yâme lo yu-bihdzy tohzy no xmeññ me ni güloo me lee Egipt. ");
INSERT INTO zpg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","No Moiséz, leegahcme we ni ra meññ-Isṟael: “Dioz cshahl me sto profet ni gyruu lahd gahc laꞌd mod-pshahl gahc me naa, lâ ctzoo gyre mod-ga me laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moiséz gahc‑e ni güyuꞌ no dmeññ nó ni güyuꞌ ba xtze lo yu-bihdzy. Wé günino x‑ángel Dioz leeme ihqy dahñ ni le Sinaí. No leeme cuaꞌ xtiidz Dioz ni rdee guîlmbahñ, no bdee meu nó. ");
INSERT INTO zpg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Per dmeññ nó ni güyuꞌ ba xtze di ne yâme ntzoo mod-ne me, aaḻ byruu yâme contr leeme, no biuꞌladzy yâme nibyguiat yâme Egipt. ");
INSERT INTO zpg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ra yâme Aróṉ: “Bzaa figur ni gac yahc tdioz noꞌ par gluu noꞌ ñahz lehdy guibyguiat noꞌ Egipt. Porni Moiséz güloo me noꞌ Egipt, no naꞌ nehx nann noꞌ bia nacu dgueññ guiaad me.” ");
INSERT INTO zpg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","No were bzaa yâme to xfigur to yuz-yaañ. Luxu, biꞌdy yâme maꞌ par bdee yâme gun figur-caḻ, no ptzoo yâme to lni par bzacbeeiy yâme figur ni bzaa yâme. ");
INSERT INTO zpg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","No por leeu byrusytzu Dioz de leeyâme, no bdee me ñahz rzacbeeiy yâme mbial yahc ni queꞌ leññ gybaa, mod-ganii xtiidz Dioz ni bzaa profet yahc, neu: Meññ-Isṟael, ¿nehxni par naa biꞌdy laꞌd maꞌ ni guhc gun leññ cuarent ihz ni güzeꞌ laꞌd lo yu-bihdzy? ");
INSERT INTO zpg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Xilgar ni ñahcu mod-wé, aaḻ güiyno laꞌd xnich xdioz laꞌd ni le Moloc no xfigur ximbial xdioz laꞌd ni le Refáṉ. No bzaa laꞌd figur-rieꞌ yahc lehdy bzacbeeiy laꞌd leeyahcu. Leewe naa sshaalaꞌ laꞌd ma ziht de ciuda-Babilony. ");
INSERT INTO zpg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Dtadgul yahc nó ni güyuꞌ ba xtze, güdahp yâme idoo de lahr ru güyuꞌ yâme lo yu-bihdzy, no leññu güdahp yâme leiy ni bdee Dioz Moiséz. No Dioz bluu Moiséz bia mód gzaa yâme idoo. No mod-bluu me Moiséz, mod-wé bzaa yâmeu. ");
INSERT INTO zpg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","No ido-rieꞌ bian-no dmeññ nó leeu ni güyuꞌ no Josué ru ba guhty Moiséz, no bidno yâmeu neꞌ dze-bdee Dioz ñahz bisshuunn yâme meññ-nehx meññ-Isṟael de lo xilyu. No mod-wé biahdu xtâ glo xtiémp Davit. ");
INSERT INTO zpg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ṟeiy-Davit naꞌ, güluꞌ Dioz xlaꞌy leeme, leewe günab me nzaa me to yuꞌ ni ñahc xiryuꞌ Dioz, xDioz Jacop. ");
INSERT INTO zpg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per di ñaḻ nzaa meu, mazyg ṟeiy-Salomóṉ, wé bzaa leeu, ");
INSERT INTO zpg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","nîcze ni ulihbu Dioz ni nu gybaa nehx beeiy ñahc xiryuꞌ me to yuꞌ ni rzaa meññ. Mod-günii profet, ne: ");
INSERT INTO zpg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Gybaa, wé ru rbian rtzon mdad, no lo guiedzylie, wé we ru rzu dnien. ¿Bia yuꞌ we naꞌ beeiy nzaa laꞌd par ñahc diryuꞌn?, ne Dioz ni rtzoo mdad. ¿Bia mód‑e naꞌ beeiy nzaa laꞌd to ru nisdadzyaꞌ? ");
INSERT INTO zpg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","No luxu naa gahc bzan gybaa no gyrenac cos ni nu lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Per laꞌd, pur meññ-nahdy xguîlmbahñ laꞌd no meññ-dirquihñ, nehx riuꞌladzy laꞌd guieññ laꞌd xtiidz Dioz. Rruu laꞌd contr Spirt-Sant. Tohzy nac laꞌd no xmeññ laꞌd ni güyuꞌ yahc ba xtze. ");
INSERT INTO zpg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","No gyre profet yahc ni güyuꞌ ba xtze, bgultihp xmeññ yahc laꞌd lee. Biꞌdy yâme meññ ni günii guiaad to mpyquie ni rtzoo ni nac xñahzû ni cshahl Dioz lee lo guiedzylie. No dze-biahd me, bdee laꞌd leeme lo ña meññ-rdziadzyno leeme, no luxu biꞌdy laꞌd leeme. ");
INSERT INTO zpg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","No laꞌd ni cuaꞌ leiy ni bdee Dioz no ni bidno ángel yahc, nehx gatzoo laꞌd mod-neu. ");
INSERT INTO zpg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Hor-bieññ guxtisy nirieꞌ we naꞌ, bydziaꞌdzy yâme, no byruu gahc yâme contr Stebn lé rahgü laiy yâme. ");
INSERT INTO zpg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stebn naꞌ, ulihbu nu Spirt-Sant xguîlmbahñ me, bwieꞌ me gybaa to ru ulihbu mos ru dxie Dioz no dxie Jesúz coo Dioz lad-drech. ");
INSERT INTO zpg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Were ra me meññ-wé yahc: ―¡Lâ güieꞌ! Naa gawien nxal gybaa, no gawien Mpyquie-Pshahl Dioz lee, dxie me coo Dioz lad-drech. ");
INSERT INTO zpg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Per leeyâme pquee yâme riedz, no psaagü gydiag yâme lehdy di guieññ yâme ni ganii me, no pquelo gahc yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Günahzy yâme leeme, güloo yâme leeme leññ guiedzy. Luxu guzlo pshadguie yâme leeme. Meññ-ptzoo contr leeme lo guxtisy, psaꞌn shab yâme lo ña to ñobyxtohby ni le Saul par güdahp meu. ");
INSERT INTO zpg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lóhgni gashadguie yâme leeme, ganab me lo Dioz, ra me lee: ―Señor Jesúz, ladzyñay‑e rsanaꞌ dispirtaꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Luxu, bisshiby me no günii me ndip, ne me: ―Señor, rnabaꞌ lii csiaaḻladzyiꞌ guîlquie-rieꞌ ni gatzoo meññ-rieꞌ yahc. Byluxz günii me ze, guhty me. ");
INSERT INTO zpg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","No Saul biuꞌladzy me biꞌdy yâme Stebn. Dze-wé gahc guzlo gagultihp yâme gyre meññ-idoo ni nu yahc Jerusaléṉ. Nunzy apóstl biaꞌn, zrieñ yâme byxuunn, zia gydo lo ṟegioṉ-Judea, no gydo lo ṟegioṉ-Samary. ");
INSERT INTO zpg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","No lahd meññ ni ulihbu rzacbeeiy Dioz, wé güya biycaꞌdzy Stebn, no modni run-no yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Per Saul ganzeꞌ me yuꞌ por yuꞌ, ganahzy me meññ-idoo, riyno me lee lidzyguiib nyug mpyquie, no ngünaa. ");
INSERT INTO zpg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Gyre meññ-byxuunn yahc Jerusaléṉ, gayuno yâme meññ xtiidz Crist gyre ru za yâme. ");
INSERT INTO zpg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","To de lahd yâme ni le Felipy, güya me to ciuda ni nu lo ṟegioṉ-Samary, bieno me meññ xtiidz Crist uga. ");
INSERT INTO zpg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Xtahl meññ ria riguieññ ni rnii me, no gyre meññ rquee gydiag leeme, porni rwieꞌ yâme rtzoo me xroꞌ ni ngann. ");
INSERT INTO zpg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","No xtahl meññ ni rahp yahc mbenahcsy zegahc rsiaḻ me lee, no rruu mbenahcsy leeyâme lé rquee riedz, ba za. No rsiaḻ me meññ-gayac-ure ni di raḻ gyniꞌby xcuerp, no rsiaḻ me meññ-ndang. ");
INSERT INTO zpg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","No leewe, gyre meññ-Samary modni rxihly. ");
INSERT INTO zpg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Per güyuꞌ to mpyquie leññ ciuda-wé ni le Simóṉ. Pur guîlbrujü ptzoo me no ptzunadz gyre meññ-Samary porni bwieꞌ yâme ni rtzoo me. No ne me meññ-rsahc‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","No xtâ meññ ni ma uxiee rsahc no xtâ meññ ni ma rsahc pquee gydiag ni rnii me, ne yâme: ―Mpyquie-rieꞌ we xpoder-ro Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Rquee gydiag yâme leeme porni ba rahp xroꞌ tiémp de ni gayisquiee me leeyâme no xguîlbrujü me. ");
INSERT INTO zpg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Per ru bylíladzy meññ-Samary xtiidz Dioz ni galuu Felipy leeyâme de ni rtzoo Dioz mdad no lguia Jesucrist, were byrôbnihs yâme nyug mpyquie, no ngünaa. ");
INSERT INTO zpg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Xtâ no Simóṉ bylíladzy mod-rluu Felipy no byrôbnihs me zegahc. No tirgahc nu me no Felipy, ria me rutisy ria. Rtzunadz me rwieꞌ me gyre ni ngann no xroꞌ milagür ni rtzoo Felipy. ");
INSERT INTO zpg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Hor-bieññ apóstl yahc ni nu Jerusaléṉ ba bylíladzy meññ-Samary xtiidz Dioz, were pshahl yâme Pedr uga, no Juaṉ. ");
INSERT INTO zpg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ru bydzihñ Pedr no Juaṉ Samary, günab yâme lo Dioz lehdy ycaꞌ meññ-wé yahc Spirt-Sant, ");
INSERT INTO zpg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","porni ndruhty ziaꞌ de lahd yâme dgueññ ycaꞌ Spirt-Sant, nunzy byrôbnihs yâme porni bylíladzy yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Luxu pshob ña Pedr chehsh yâme no Juaṉ, no cuaꞌ gahc yâme Spirt-Sant. ");
INSERT INTO zpg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Hor-bwieꞌ Simóṉ rshob ña apóstl yahc chehsh meññ, no ba gahc güyuꞌ Spirt-Sant xguîlmbahñ yâme, were ra me: ―Gdedyaꞌ medy laꞌd ");
INSERT INTO zpg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","bâḻ gdee laꞌd naa poder-rieꞌ, lehdy nitisy dxu cshob dñan chehsh la, ba gahc ycaꞌ yâme Spirt-Sant. ");
INSERT INTO zpg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ra Pedr leeme: ―Xmedyiꞌ, ru gynihty gahquiꞌ we gynihtyu, porni nlâdzyiꞌ beeiy nziiy to ni rdee Dioz‑e. ");
INSERT INTO zpg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nehx beeiy ctzooy dziiñ ni gatzoo noꞌ, porni xguîlmbahñiꞌ nehx nyeu lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Psaan gyre ni nahcsy ni naquiꞌ, no günab lo Dioz duhn beeiy csiaaḻladzy me gyre guîlrieñ-nahcsy ni rahpiꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Naa rwien xguîlmbahñiꞌ bydzeꞌu no guîlmvidy, no di raḻ gyruuy gyre lo ni nadz. ");
INSERT INTO zpg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Were ra Simóṉ leeyâme: ―Lâ gnab lo Dioz por naa, lehdy di gácaꞌ mbehty ni ba ra laꞌd naa. ");
INSERT INTO zpg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bylux bieno yâme meññ xtiidz Dioz no bdee yâme diidz ni bwieꞌ yâme guhc lahd yâme, were gubyguiat Pedr no Juaṉ Jerusaléṉ. Lóni zia yâme güdedy yâme zrieñ guiedzy ni nu lo ṟegioṉ-Samary, gayuno yâme meññ xtiidz Crist. ");
INSERT INTO zpg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Luxu biahd to x‑ángel Dioz, günino me Felipy, ra me lee: ―Güya lad-mbenihs, cuaꞌ ñahz ni rruu Jerusaléṉ no ni za ñaz-lo guiedzy-Gasa. Ñaz-rieꞌ we ru nac yu-bihdzy. ");
INSERT INTO zpg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Were za Felipy ru ra ángel leeme. No wé za me, bwieꞌ me to meññ-Etiopía. Mpyquie-rieꞌ nac me to meññ-nehx beeiy ridzña no ba güya me idoró Jerusaléṉ, lehdy bigzacbeeiy me Dioz. Rtzoo me dziiñ lahd xmeññ ṟein ni le Candace. Ngüna-rieꞌ naꞌ, leeme we ni rtzoo mdad meññ-Etiopía, no mpyquie-rieꞌ nac xjefy xtesorer me. ");
INSERT INTO zpg_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mpyquie-rieꞌ, ba zia xguiedzy me hor-bwieꞌ Felipy leeme. Dxie me leññ carret gayuuḻ me lo libr ni bzaa profet-Isaíaz. ");
INSERT INTO zpg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Were ra xiSpirt Dioz Felipy: ―Gübigy ru ziaad carret-wé. ");
INSERT INTO zpg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Hor-ba gübigy Felipy gahsh ru ziaad carret, bieññ me gayuuḻ mpyquie-wé xtiidz Dioz ni ziaad lo xlibr profet-Isaíaz. Were ra me lee: ―¿Rieññiꞌ ni gayuuḻiꞌ la? ");
INSERT INTO zpg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ra mpyquie-wé leeme: ―¿Bia mód‑e guieññaꞌnu no gydi dxu gluu naa bia rniiu? Luxu ra me Felipy: ―Güyuꞌ leññ carret, tzo nó tohzy. ");
INSERT INTO zpg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ni gayuuḻ me, ziaadu lo Guehtzy ru queꞌ xtiidz Dioz, ru neu: Güiyno yâme leeme beeiy riyno meññ xiily ru gaty; no beeiy racndoo xiily lo meññ ni rga lady maꞌ, modé gahc gucndoo me no nehx günii me mbehty. ");
INSERT INTO zpg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ptzoo psahc yâme leeme beeiy to meññ-dirquihñ, no nehx guhc guîlguxtisy lguia gyre ni ptzoo yâme leeme. Ndruhty nehx beeiy rgab meññ ni ziaad de leeme, porni biꞌdy yâme leeme lo guiedzylie-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Bylux biiḻy me nirieꞌ, were ra me Felipy: ―Ganabaꞌ lii gahbyiꞌ naa: ¿De dxu ganii profet-Isaíaz nirieꞌ? ¿De leegahcme la, o de zrieñ meññ? ");
INSERT INTO zpg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Were Felipy guzlo bluu leeme me xtâ neꞌ ru gayuuḻ mpyquie-rieꞌ lo Guehtzy ru queꞌ xtiidz Dioz, no bieno me diidz lee zaꞌgndzi lguia Jesúz. ");
INSERT INTO zpg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Lóni za yâme lo ñahz, bydzihñ yâme to ru queꞌ nzeꞌ. Were ra mpyquie-rieꞌ Felipy: ―Wé queꞌ nzeꞌ. ¿Bia riaadzaꞌ par nrôbnisaꞌ? ");
INSERT INTO zpg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ra Felipy leeme: ―Beeiy nrôbnihsiꞌ bâḻ ba ulihbu rlíladzyiꞌ no gydo xguîlmbahñiꞌ. Ra me Felipy: ―Naa rlídadzyaꞌ Jesucrist, Xiiñ Dioz‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Were, biscuiahz me carret no biaht gyrop yâme par pchôbnihs Felipy leeme. ");
INSERT INTO zpg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","No scâsy byruu yâme leññ nzeꞌ za gahc Felipy, ziyno xiSpirt Dioz leeme, no ba nehx bwieꞌr me lee. Per mpyquie-rieꞌ ni nac to meññ-nehx beeiy ridzña naꞌ, rxihly me zia me. ");
INSERT INTO zpg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Glo bieññ Felipy ba nu me sto guiedzy ni le Azoto. No güdedy me guiedzy no guiedzy gayuno me meññ xtiidz Crist, no mod-wé xtâ glo bydzihñ me ciuda-Cesarea. ");
INSERT INTO zpg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Per Saul ganzeꞌ me gayo me xmeññ Crist lehdy gaty. Leewe, güya me lo xjefy gyre bahl, ");
INSERT INTO zpg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","bignab me guehtzy lehdy tziyno meu gyre xiydoo meññ-Isṟael ni nu ciuda-Damascü, lehdy ru gydzial me meññ-ba nu yahc lo ni le Xñahz Crist, guhcu mpyquie o ngünaa, beeiy gynahzy me lee, tziyno me lee Jerusaléṉ, tzu yahc lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Per ru ba gadziñgahsh me Damascü, tohzydzi bydihñ to byniꞌ guingybi me ni byruu gybaa. ");
INSERT INTO zpg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","No biahb me lo yu no bieññ me to riedz, ra leeme: ―Saul, Saul, ¿bia nacu gagultihpiꞌ naa? ");
INSERT INTO zpg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Were günii me, ne me: ―¿Dxu lii, Señor? Ra riedz-caḻ leeme: ―Naa we Jesúz, ni gagultihpiꞌ lee. Lii gatzunéy lii gahc, beeiy racné yuhz ru rloꞌ maꞌ lo behch ni ndushgue. ");
INSERT INTO zpg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lé rzîbyyoob Saul de dzieeby, günii me ne me: ―Señor, ¿bia racladzyiꞌ ctzon? Ra Jesúz leeme: ―Biahsiꞌ, güya leññ ciuda ru zaꞌy. Uga ga yâme lii bia rahpiꞌ de ni ctzooy. ");
INSERT INTO zpg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Gyre meññ ni ziyno Saul, bydzie yâme lé ni di ñaḻ nnii yâme mbehty, porni bieññ yâme riedz-caḻ per nehx bwieꞌ yâme ndruhty. ");
INSERT INTO zpg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Glo biahs Saul lo yu ba di raḻ güieꞌ me, nîcze nxal lo me. No leewe, günahzy yâme ña me, ziyno yâme leeme Damascü. ");
INSERT INTO zpg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Leññ tzonn dzé di ñaḻ nwieꞌ me, no di ñahgü me, no di ñoo me mbehty. ");
INSERT INTO zpg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Uga Damascü nu to xmeññ Crist ni le Ananíaz, no Dioz ba psieññ leeme mod-beeiy lo mpcaaḻ, ra leeme: ―Ananíaz. Were ra Ananíaz Dioz: ―Günii, Señor, naa gayieññ. ");
INSERT INTO zpg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Were ra Dioz leeme: ―Güya to ñahz ni le Ndohp, no ru gydzihñiꞌ xiryuꞌ Jud, gnabdiidziꞌ por to mpyquie ni le Saul, meññ-Tars. Wé nu me no ganab me lo Dioz, ");
INSERT INTO zpg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","no mod-beeiy lo mpcaaḻ ba bwieꞌ me to mpyquie ni le Ananíaz, güyuꞌ ru nu me no pshob ña chehsh me par byxal lo me sto. ");
INSERT INTO zpg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hor-bieññ Ananíaz ra Dioz leeme ze, were ne Ananíaz: ―Señor, xtahl meññ ru diidz dloꞌn mpyquie-rieꞌ gyrehzy ni nahcsy gatzoo me. Leeme we ni gatzoo gasahc xmeññiꞌ ni nu yahc Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","No naꞌ ziaad me neꞌ, zidno me guehtzy ni cuaꞌ me lo xjefy yahc bahl par gynahzy me xmeññiꞌ tziyno me lee lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Per Dioz ra me Ananíaz: ―Güya, porni ba güleꞌn leeme lehdy guno me dtiidzaꞌ meññ-nehx meññ-Isṟael no xṟeiy yâme, no meññ-Isṟael gahc. ");
INSERT INTO zpg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","No naa glun leeme blaty‑e tedy me ni nadz par ctzoo me dixtziñaꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Were za Ananíaz, no bydzihñ me, güyuꞌ me leññ yuꞌ ru nu Saul, pshob ña me chehsh, no ra me lee: ―Rman-Saul, Jesúz ni rtzoo mdad ni günino lii lo ñahz ru ziaadiꞌ, pshahl me naa lehdy gyxal loꞌy no lehdy ulihbu tzu Spirt-Sant xguîlmbahñiꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","No hor-caḻ gahc byruu mod-beeiy laz leññ lo Saul, no were bwieꞌ me zaꞌgndzi. Luxu biahs me, no byrôbnihs gahc me. ");
INSERT INTO zpg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","No byluxu güee me no güyuꞌ gan leeme sto. No biaꞌn me doozy dzé no xmeññ Crist ni nu yahc Damascü. ");
INSERT INTO zpg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","No guzlo gahc Saul gayuno me meññ diidz leññ idoo, ne me: “Jesúz, leeme we Xiiñ Dioz.” ");
INSERT INTO zpg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Gyre meññ ni gayieññ mod-rluu Saul, rtzunadz yâme, ne yâme: ―¿Dâs‑e mpyquie-rieꞌ ni gagultihp meññ ni rlíladzy xtiidz Jesúz ni nu yahc Jerusaléṉ la? No leeme biahd neꞌ par tziyno meññ-wé yahc lo xjefy yahc bahl lehdy tzu yâme lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Per Saul ma ganii me no nehx rlaby me mbehty, ne me: “Jesúz, leeme we nac Crist”, no xtâ meññ-Isṟael ni nu yahc Damascü, gatixcann me lee. ");
INSERT INTO zpg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Güdahpu stoozy dzé, meññ-Isṟael ba gatzoo yâme diidz lehdy igaꞌdy yâme Saul. ");
INSERT INTO zpg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dzé no guiaal gabiahz yâme leeme gyre ruꞌ xpuert ciuda par igaꞌdy yâme leeme hor-tedy me, per gunn gahc me gabiahz yâme leeme lehdy gaty me. ");
INSERT INTO zpg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Were guiaal güluꞌ xmeññ Crist leeme leññ to dzomby, no gülety yâme leeme ñaz-ruꞌ guibiñ ni nu gybi ciuda. No mod-wé bylaa me, di ñehty me. ");
INSERT INTO zpg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Hor-bydzihñ Saul Jerusaléṉ gucladzy me ñuꞌ me tohzy no xmeññ Crist. Per gyre yâme rdzie leeme, porni nehx rlíladzy yâme bâḻ uliu xmeññ Crist leeme. ");
INSERT INTO zpg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Were güiyno Bernabé leeme, bydziñno leeme lo apóstl yahc. No bieno me diidz apóstl yahc mod-bwieꞌ Saul Jesúz lo ñahz, no mod-günino leeme, no mod-bieno me diidz meññ-Damascü lguia Jesúz no nehx rlaby me mbehty. ");
INSERT INTO zpg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","No were biaꞌn Saul lahd yâme Jerusaléṉ, no tirgahc nu me no leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tirgahc runo me meññ xtiidz Dioz lguia Jesúz sinn gydzie me, no rdeḻydiidz meññ-Isṟael no leeme ni rnii yahc didz-griegü. Per leeyâme gucladzy ngaꞌdy leeme. ");
INSERT INTO zpg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ru gunn meññ-rman náḻ yâme igaꞌdy yâme leeme, were güiyno yâme leeme Cesarea, no de wé pshahl yâme leeme xguiedzy me ni le Tars. ");
INSERT INTO zpg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","No were ba dzie tziaawy nu gyre xmeññ Crist ni rdohp leññ idoo ni nu gydo lo ṟegióṉ yahc ni le Judea, Galilea no Samary. No to to dzé ganiꞌzy ni gayann yâme lguia ni rlíladzy yâme, no rzacbeeiy yâme Dioz. No ma gane meññ ni galíladzy xtiidz Dioz, porni gayacno Spirt-Sant leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Hor-güya Pedr bictixlo me xmeññ Dioz ni nu yahc gyre lad, güya me zegahc bictixlo me xmeññ Dioz ni nu yahc to ciuda ni le Lida. ");
INSERT INTO zpg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Uga bzaclo me to mpyquie ni le Eneaz, ba rahp shun ihz gayac-ure, nashluꞌn me porni di raḻ gyniꞌby me mbehty. ");
INSERT INTO zpg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Were ra Pedr leeme: ―Eneaz, Jesucrist csiaḻ lii. Biahsiꞌ, gülesy xluꞌniꞌ. No hor-caḻ gahc biahs Eneaz. ");
INSERT INTO zpg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Hor-bwieꞌ meññ-nu Lida no meññ-nu yahc Saróṉ biaḻ mpyquie-wé, byo yâme Crist. ");
INSERT INTO zpg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Leññ tiemp-wé nu to ngünaa ciuda-Jope, xmeññ Crist leeme, le me Tabita, no lo didz-griegü, le me Dorc. Ngüna-rieꞌ, meññ-tziaawy leeme, tirgahc racno me meññ ni gayaadz behch. ");
INSERT INTO zpg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Leññ dze-wé yahc günahzy guihdz leeme no guhty me. Hor-bwieꞌ yâme ba guhty me, bgahz yâme leeme me mod-ne xcostumbr meññ-Isṟael, no bictish yâme leeme sto leññ yuꞌ ni rrohpu pis. ");
INSERT INTO zpg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","No Jope, gahsh gáu de ciuda-Lida ru nu Pedr. Scâsy gunn xmeññ Crist uga nu Pedr, pshahl yâme chohp meññ bigyne leeme guiaad me ngueeḻy gahc. ");
INSERT INTO zpg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Were biahd Pedr no leeyâme. Scâsy bydzihñ Pedr, ziyno yâme leeme leññ yuꞌ ru nash xcuerp Dorc. No gadohp meññ-ngünaviud yahc uga gayuun. No galuu yâme Pedr vestid yahc no gmix-duhñ yahc ni güdib Dorc dze-mbahñ. ");
INSERT INTO zpg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Luxu güloo Pedr meññ-wé yahc stziuꞌ. No bisshiby me günab me lo Dioz; byluxu bwieꞌ me ru nash xcuerp Dorc, no ra me lee: ―¡Tabita, biahsiꞌ! No byxal gahc lo Dorc. No scâsy bwieꞌ me Pedr, gürieli me. ");
INSERT INTO zpg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Were günahzy Pedr ña me par biahs me. No lux pquee Pedr riedz xmeññ Dioz ni nu uga no zrieñ meññ-ngünaviud biahd yâme, bwieꞌ yâme ba gübahñ me. ");
INSERT INTO zpg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Gyre meññ-nu Jope gunn ni guhc, no xtahl yâme bylíladzy Jesúz ni rtzoo mdad. ");
INSERT INTO zpg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","No biaꞌn Pedr xtze Jope, xiryuꞌ to mpyquie ni le Simóṉ ni rtzoo curtir guiedy. ");
INSERT INTO zpg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Güyuꞌ to mpyquie ciuda ni le Cesarea, le me Corneḻy. Nac me xcapitáṉ to batallóṉ soldad ni le Italian. ");
INSERT INTO zpg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mpyquie-rieꞌ, gydibyno xmiꞌñ me, ulihbu rzobdiidz me Dioz no rzacbeeiy me lee. No modni rdee me medy-gun par meññ ni riaadz ni rquihñ, no tirgahc rnab me lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","To udzie beeiy las-trez, bwieꞌ me to x‑ángel Dioz güyuꞌ ru dxie me, no ra leeme: ―¡Corneḻy! ");
INSERT INTO zpg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Were bwiedzie Corneḻy leeme, modni gadzie me, ra me ángel: ―¿Bia racladzyiꞌ, Señor? Were ra ángel leeme: ―Dioz rieññ me lii hor-rnabiꞌ lo me, no gawieꞌ me gyre ni gayacnoy meññ. ");
INSERT INTO zpg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cshahliꞌ xmósiꞌ, tza yâme Jope, dziycaꞌ yâme Simóṉ, ni ra yâme lee Pedr. ");
INSERT INTO zpg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Leeme nu xiryuꞌ sto Simóṉ, ni rtzoo curtir guiedy, gahsh gá coo nisdoo zob xiryuꞌ me. Leeme ga lii bia ctzooy. ");
INSERT INTO zpg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Scâsy byruu ángel, pshalcaꞌ gahc Corneḻy chohp xmós me no sto xsoldad me ni ulihbu rzoob xtiidz Dioz, ");
INSERT INTO zpg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","bieno me diidz leeyâme gyre mod-ra ángel leeme, no luxu pshahl me lee Jope ru nu Pedr. ");
INSERT INTO zpg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ni byre guiaal‑e naꞌ beeiy glaꞌy dzé, ru ba gadziñgahsh yâme Jope, hor-wé cueꞌ Pedr ihqy yuꞌ guia, zignab me lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","No hor-wé ba galahn me. Lóni gatzoo yâme ni gahgü me, tohzydzi guhc me beeiy ni ganii xcaaḻ, ");
INSERT INTO zpg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","bwieꞌ me nxal gybaa no bwieꞌ me ziaht lo mbeꞌ beeiy to mant nliiby gydap squiñu. ");
INSERT INTO zpg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Leññ mant-caḻ ziaad gyre clasy maꞌ ni rahp tahp nieꞌ, no ma-rzîbyleññ no ma-rzîbyshiily. ");
INSERT INTO zpg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","No hor-wé bieññ me to riedz, ra leeme: ―Biahsiꞌ, Pedr, biꞌdy no güdahgü. ");
INSERT INTO zpg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Were günii Pedr, ne me: ―Yac, Señor; porni naa nito dgueññ gahguaꞌ mbehty ni ne leiy nehx beeiy gahgü meññ lee porni nehx nyeu. ");
INSERT INTO zpg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Gyzac ra riedz-caḻ leeme: ―Ni ba günii Dioz nye la, di gyniiy nehx nyeu. ");
INSERT INTO zpg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tzonn vuelt ra riedz-caḻ leeme mod-wé, no luxu güyehpy mant-caḻ gybaa sto. ");
INSERT INTO zpg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","No nu ihqy Pedr ni bwieꞌ me guia, ne me: “¿Biahx‑e nacu ni bwien mod-wé?” No hor-wéhb bydzihñ meññ ni pshahl Corneḻy lee ni ganabdiidz bá glo nu Simóṉ. Scâsy bydzihñ yâme ruꞌ yuꞌ, ");
INSERT INTO zpg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","günabdiidz yâme bâḻ wé nu sto Simóṉ ni ra yâme lee Pedr. ");
INSERT INTO zpg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nu ziaꞌ ihqy Pedr ni bwieꞌ me, ra xiSpirt Dioz leeme: ―Gayo tzonn meññ lii. ");
INSERT INTO zpg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Biahtiꞌ. Güya no leeyâme no di yqueꞌladzyiꞌ mbehty, porni naa we pshaalaꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Were biaht Pedr, günino me meññ-pshahl Corneḻy lee, ra me lee: ―Naa we ni gayo laꞌd. ¿Bia ctzoo laꞌd naa? ");
INSERT INTO zpg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ra yâme leeme: ―Pshahl to capitáṉ noꞌ ni le Corneḻy, to mpyquie-tziaawy no rzacbeeiy me Dioz; mpyquie-rieꞌ gyre meññ-Isṟael rdee diidz meññ-tziaawy leeme. Güya to x‑ángel Dioz, ra leeme cshalcaꞌ me lii, tzaꞌy xiryuꞌ me par guieññ me ni gahbyiꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Luxu bdee Pedr xiryuꞌ me, güyuꞌ yâme. Ni byrer guiaal, were za Pedr no leeyâme no zrieñ meññ-rman ni nu yahc Jope. ");
INSERT INTO zpg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ni byrohpu dzé bydzihñ yâme Cesarea ru gabiahz Corneḻy leeyâme no xfamily no zrieñ xmígü me ni psieññ me lee. ");
INSERT INTO zpg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Hor-bydzihñ Pedr ruꞌ yuꞌ, byruu Corneḻy bigydzil-lo leeme no bisshiby lo me, bzacbeeiy leeme. ");
INSERT INTO zpg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Were günahzy Pedr ña me no gülesy leeme, ra leeme: ―Biahsiꞌ, di ctzooy mod-wé, porni meññ gahc‑e naa beeiy gahc lii. ");
INSERT INTO zpg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","No lóni gayu yâme diidz, güyuꞌ Pedr leññ yuꞌ no bwieꞌ me dxie xtahl meññ ni bydohp uga. ");
INSERT INTO zpg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ra me leeyâme: ―Laꞌd nann laꞌd dleiy noꞌ neu nehx beeiy tzu meññ-Isṟael lahd meññ-mbiuhz, ni leññ xiryuꞌ nehx beeiy ziuꞌ yâme. Per Dioz ba bluu me naa ndruhty nehx beeiy csacaꞌ lee ma uxiee que naa no nehx beeiy gynin nehx nye mod-rtzoo yâme. ");
INSERT INTO zpg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","No leewe, scâsy bydzihñ meññ-bigyne naa, ziaḻ gahcaꞌ sinn nzuulaꞌ diidz. Naꞌ racdadzyaꞌ gannaꞌ bia nacu pshalcaꞌ laꞌd naa. ");
INSERT INTO zpg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ra Corneḻy leeme: ―Rahp tahp dzé beeiy gahc hôrrieꞌ, lo hor-gatzon ayun no ganabaꞌ lo Dioz leññ diryuꞌn, tohzydzi bydzihñ to mpyquie, nutz me to lar-quitzybo lé rcampytzeꞌu, ");
INSERT INTO zpg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ra me naa: “Corneḻy, Dioz rieññ me lii hor-rnabiꞌ lo me, no gawieꞌ me gyre ni gayacnoy meññ. ");
INSERT INTO zpg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pshahl diidz lo Simóṉ ni le Pedr ni nu Jope, guiaad me. Leeme nu xiryuꞌ sto Simóṉ ni rtzoo curtir guiedy ni nu gahsh gá coo nisdoo. Ru guiaad me, leeme ga lii bia ctzooy.” ");
INSERT INTO zpg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","No leewe ngueeḻy gahc pshalcan lii; no mos ptzooy ziaadiꞌ. No naꞌ Dioz nu me neꞌ tohzy no noꞌ lehdy guieññ noꞌ gyre ni pshahl me lii zidney noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Were guzlo ganii Pedr, ne me: ―Naꞌ ba bieññaꞌ ni uli par Dioz tohzy mdid‑e rsahc gyre meññ. ");
INSERT INTO zpg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","No rxilyno me meññ-gyre nacióṉ ni rzacbeeiy leeme no rtzoo ni nac xñahzû. ");
INSERT INTO zpg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","No nirieꞌ, leegahcu we xtiidz me ni psieññ me meññ-Isṟael lehdy tzu yahc dzie tziaawy por Jesucrist; no Crist‑e rtzoo mdad gyre ni nu lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Laꞌd nann laꞌd gyre ni guhc gydo lo ṟegioṉ-Judea, ni guzlo xtâ ṟegioṉ-Galilea bylux de ni bieno Juaṉ xtiidz Dioz meññ no pchôbnihs me leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","No nann laꞌd pshahl Dioz Jesúz ni nac meññ-Nasaret no güluꞌ me Spirt-Sant no zegahc poder xguîlmbahñ, no Jesúz güzeꞌ me gucno me meññ no psiaḻ me meññ ni nu bêndzab lee, porni nu Dioz no leeme. ");
INSERT INTO zpg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Noꞌ bwieꞌ noꞌ gyre ni ptzoo me lo ṟegioṉ-Judea no leññ ciuda-Jerusaléṉ. No meññ-Isṟael ni nu yahc uga biꞌdy yâme leeme, pquee yâme leeme lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Per Dioz bispahñ leeme lo ni bionn dzé, no Dioz bdee me lsenzy bwieꞌ noꞌ leeme. ");
INSERT INTO zpg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nehx bwieꞌ gyre meññ leeme, nunzy noꞌ bwieꞌ leeme porni güle Dioz noꞌ ba xtze lehdy guhcu modé. Noꞌ güdahgü noꞌ no güee noꞌ tohzy no leeme dze-bylux gübahñ me de lahd mînguty. ");
INSERT INTO zpg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","No pshahl me noꞌ dzigyuno noꞌ meññ xtiidz me no ga noꞌ leeyâme leeme we ni ba güle Dioz lee par ctzoo guîlguxtisy lguia gyre meññ ni mbahñ no gyre meññ ni ba guhty. ");
INSERT INTO zpg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","No gyre profet ni güyuꞌ yahc ba xtze günii yâme, ne yâme gyre meññ ni gylíladzy leeme la, ziar xguîlquie. ");
INSERT INTO zpg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Gayuno ziaꞌ Pedr diidz leeyâme, tohzydzi bidtzu Spirt-Sant xguîlmbahñ meññ-gayieññ ni ganii me. ");
INSERT INTO zpg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Gyre meññ-rman ni nac meññ-Isṟael, ni nu señ lady, ni biahd no Pedr, modni ptzunadz yâme hor-bwieꞌ yâme cuaꞌ meññ-nehx meññ-Isṟael Spirt-Sant. ");
INSERT INTO zpg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gunn yâme niwé, porni guzlo gahc ganii meññ-nehx meññ-Isṟael gydze diidz, no gaguguia yâme Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Were ra Pedr meññ-ziyno me lee: ―¿Nehxni nnii mu nehx beeiy nrôbnihs meññ-rieꞌ yahc ni cuaꞌ Spirt-Sant ni ba cuaꞌ nó? ");
INSERT INTO zpg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","No ptzoo me mdad byrôbnihs yâme porni ba bylíladzy yâme Jesucrist. No luxu, günab yâme guiaꞌn Pedr no leeyâme doozy dzé. ");
INSERT INTO zpg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ngueeḻy gahc bieññ apóstl yahc diidz no zrieñ meññ-rman ni nu yahc Judea xtâ no meññ-nehx meññ-Isṟael zegahc ba bylíladzy xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hor-bydzihñ Pedr Jerusaléṉ, lahd meññ-rman ni nac meññ-Isṟael, lee we meññ-nu yahc señ lady, guzlo galesyno yâme, ");
INSERT INTO zpg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ra yâme leeme: ―¿Bia nacu güyay ru nu meññ-nehx meññ-Isṟael? Xtâ no güeey no leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Were guzlo Pedr gu leeyâme bia gyre guhc xtâ glo ru guzlou, ra me leeyâme: ");
INSERT INTO zpg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Dze-nun Jope, lóni ganabaꞌ lo Dioz, bwien beeiy lo mpcaaḻ ziaht beeiy to mant-ro gybaa, nliiby gydap squiñu no bydzihñu xtâ gahsh ru dxien. ");
INSERT INTO zpg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Hor-pcunin‑e naꞌ par bwien bia nu leññ mant-caḻ, bwien nu gyre clasy maꞌ leññu ni rahp tahp nieꞌ, ma-nya, ma-rzîbyleññ, no ma-rzîbyshiily. ");
INSERT INTO zpg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","No bieññaꞌ to riedz leññ gybaa, ra naa: “Biahsiꞌ, Pedr. Biꞌdy no güdahgü.” ");
INSERT INTO zpg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Were günin, ren: “Yac, Señor; porni naa nito dgueññ gahguaꞌ mbehty ni ne leiy nehx beeiy gahgü meññ lee porni nehx nyeu.” ");
INSERT INTO zpg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Were gyzac günii riedz-caḻ ni byruu gybaa, ra naa: “Ni ba günii Dioz nye la, di gyniiy nehx nyeu.” ");
INSERT INTO zpg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tzonn vuelt guhcu mod-wé, no luxu gubyguiat mant-caḻ gybaa sto. ");
INSERT INTO zpg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Lo hor-wé bydzihñ tzonn meññ ruꞌ yuꞌ ni pshahl meññ-nu Cesarea lee. ");
INSERT INTO zpg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","No hor-wé ra xiSpirt Dioz naa tzan no leeyâme, no di yqueꞌdadzyaꞌ mbehty. No zegahc güya sshoꞌb rman-rieꞌ yahc no naa. Bydzihñ noꞌ, güyuꞌ noꞌ leññ xiryuꞌ to mpyquie, ");
INSERT INTO zpg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ni bieno diidz noꞌ mod-güya to ángel xiryuꞌ me, ra leeme: “Pshahl diidz Jope, par guiaad Simóṉ ni ra yâme lee Pedr. ");
INSERT INTO zpg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Leeme ga lii bia mód ctzooy par gylaay de lo guîlnadz ni ziaad no xmiꞌñiꞌ zegahc.” ");
INSERT INTO zpg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","No lóni gayunon leeyâme xtiidz Dioz, tohzy bidtzu Spirt-Sant xguîlmbahñ yâme, mer mod-guhc gahc nó tzcaḻ. ");
INSERT INTO zpg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Were bitsêlou naa mod-ne Crist ni rtzoo mdad: “Juaṉ rchôbnihs me no nzeꞌ. Per laꞌd la, no Spirt-Sant‑e gyrôbnihs laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bâḻ Dioz bdee leeyâme ni ba bdee me nó dzé bylídadzy nó Jesucrist ni rtzoo mdad la, ¿dxuz‑e naꞌ nacaꞌ par nruun contr ni rtzoo Dioz? ");
INSERT INTO zpg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hor-bieññ yâme ni ne Pedr, ba nehx güniir yâme mbehty, mazyg guzlo güluguia yâme Dioz, ne yâme: ―¡Xnahc‑e xtâ no meññ-nehx meññ-Isṟael ba bdee Dioz lsenzy csaan ni nahcsy ni nac yâme par gap yâme guîlmbahñ ni nehx zluhx! ");
INSERT INTO zpg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bylux biꞌdy meññ Stebn, guzlo bgultihp yâme zrieñ xmeññ Crist, no modé gübiꞌ lahd xmeññ me zrieñ lgar; gübiꞌ yâme xtâ lo ṟegioṉ-Fenicia, no ru le Chipre ni nu nisdoo guingybi, no xtâ Antioquía. No wé nu yâme bieno yâme xtiidz Dioz nunzy meññ-nac meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Per lahd yâme nu meññ-Chipre no meññ-Ciren ni güya Antioquía no guzlo gayuno yâme meññ-nehx meññ-Isṟael diidz lguia Jesúz ni rtzoo mdad. ");
INSERT INTO zpg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","No Dioz nu me no meññ-wé yahc ni bie xtiidz me lo zrieñ meññ, no leewe xtahl meññ-uga bylíladzy no byo yâme Crist. ");
INSERT INTO zpg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ru gunn meññ-idoo ni nu yahc Jerusaléṉ nirieꞌ, pshahl gahc yâme Bernabé güya Antioquía. ");
INSERT INTO zpg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Hor-bydzihñ me ru nu meññ-wé yahc, byxihly me porni bwieꞌ me mod-güluꞌ Dioz xlaꞌy me leeyâme. No güluꞌ me xguîlriehñ yâme di csaꞌn yâme de ni gazobdiidz yâme Crist no gydo xguîlmbahñ yâme. ");
INSERT INTO zpg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","No Bernabé, meññ-tziaawy leeme no ulihbu nu Spirt-Sant xguîlmbahñ me no modni rlíladzy me Dioz. No leewe xtahl meññ bylíladzy Crist. ");
INSERT INTO zpg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Luxu byruu Bernabé, güya me ciuda ni le Tars, bigyo me Saul; no bylux bydzial me lee, gubyguiat me no lee Antioquía. ");
INSERT INTO zpg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","No leññ diby ihz güyuno yâme meññ-idoo ni nu uga, no bluu yâme xtahl meññ. No nier neꞌ günii yâme le xmeññ Crist mod-rieꞌ: “cristian”. ");
INSERT INTO zpg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Leññ dze-wé yahc bydzihñ chohp tzonn profet yahc Antioquía ni byruu Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bisnii xiSpirt Dioz to de lahd yâme ni le Agabo, ne me: “Ziuꞌ to guîlrlahn gydo-bynac lo guiedzylie ru nu meññ.” No nirieꞌ guhcu xtiémp to ṟeiy ni le Claudio. ");
INSERT INTO zpg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Were xmeññ yahc Crist ptzoo yâme diidz cshahl yâme ni gacno meññ-rman ni nu yahc lo ṟegioṉ-Judea. No mod-wé ptzoo yâme, to to yâme bdee ni beeiy rahp. ");
INSERT INTO zpg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Pshahl yâme Bernabé no Saul Judea, bicsaꞌn gyre ni ptohp yâme. Bydzihñ gyrop yâme, bdee yâmeu, cuaꞌ rman yahc ni rsahc ni rnii. ");
INSERT INTO zpg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Leññ gahc dze-wé yahc guzlo ptzoo ṟeiy-Herody mdad ctzoo csahc yâme lahd meññ-idoo. ");
INSERT INTO zpg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Günahzy yâme Jacob, behtzy Juaṉ, no ptzoo Herody mdad biꞌdy yâme leeme no spad. ");
INSERT INTO zpg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bwieꞌ Herody biuꞌladzy meññ-Isṟael ni guhty Jacob. Were ptzoo me mdad günahzy yâme Pedr zegahc leññ dze-lni, dze-rahgü meññ-Isṟael paṉ ni nehx rahp levadur. ");
INSERT INTO zpg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ptzoo me mdad güyuꞌ Pedr lidzyguiib, no luxu psaꞌn me tahp cuib soldad ni gayahp. Tahp gá soldad guhc to cuib. Ganii leññ ihqy Herody gboo me Pedr tedyz lni lehdy tziyno me lee lo meññ-guiedzy. ");
INSERT INTO zpg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","No leewe, güyuꞌ Pedr lidzyguiib, per meññ-idoo nehx rsandzie ganab lo Dioz por leeme. ");
INSERT INTO zpg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nash Pedr leññ lidzyguiib guial-caḻ, no ba tzusy byniꞌ gboo Herody leeme lehdy tza me lo meññ-guiedzy. Nishcahsy me glaꞌy chohp soldad, no nliiby me chohp caden, no zrieñ soldad gayahp ruꞌ lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tohzydzi bydzihñ to x‑ángel Dioz, lé güyuꞌ byniꞌ leññ lidzyguiib. Güdihñ ña me coo leññ Pedr lehdy psiuꞌ me lo, no ra me lee: ―Biahs laaḻiꞌ. No lo hor-wé gahc xgann caden ni nliiby ña Pedr byxacu. ");
INSERT INTO zpg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","No ra ángel leeme: ―Bihtz shabiꞌ no pquee xguidguialiꞌ nieꞌy. Byluxz pquee xguidguial me nieꞌ me, ra ángel leeme: ―Bihtz shab-ruhtziꞌ xtziguia no náḻiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Were byruu Pedr, náḻ leeme. Per nehx rlíladzy me bâḻ ni uli ni gatzoo ángel. Nlâdzyx me ganii xcaaḻ me we. ");
INSERT INTO zpg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Güdedy yâme ru gayahp to cuib soldad, no gyzac güdedy yâme ni rrohp cuib soldad ni gayahp. No ru bydzihñ yâme ruꞌ to puert-guiib ni rruu ñaz-lo call, byxal gahcu xgannu, no byruu yâme. Güdedyr yâme to call, no wé byrusytzu ángel, psaꞌn me nunzy Pedr. ");
INSERT INTO zpg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","No were bihd xguîlriehñ Pedr, ne me: ―Nirieꞌ ni ulix‑e leeu. Dioz pshahl x‑ángel me güloo naa lidzyguiib lehdy gylaan de lo ña Herody no de gyre ni nadz ni racladzy meññ-Isṟael ntzoo naa. ");
INSERT INTO zpg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mod-wé ganii leññ ihqy me, za me xiryuꞌ Maríe xmam Juaṉ, ni ra yâme lee Marcü, ru dxie xtahl xmeññ Crist ganab lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Hor-bydzihñ Pedr li Maríe, gülagü me chehsh puert. Were byruu to ndzabxtohby ni le Rode, za zigüieꞌ dxu we leeme. ");
INSERT INTO zpg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ru bzaclo me xriedz Pedr‑e naꞌ, di nshal me puert porni modni gaxihly me. Gubyguiat-güxuunn me sto, bigyne me meññ-dxie leññ yuꞌ, ra me leeyâme Pedr‑e zu chehsh puert. ");
INSERT INTO zpg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Per nehx bylíladzy yâme, aaḻ ra yâme leeme: ―¡Zoꞌn nguidz ihqyiꞌ we! Per leeme gaya me ni uli Pedr‑e leeme. Were ra yâme leeme: ―X‑ángel me we. ");
INSERT INTO zpg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedr naꞌ nehx rsaꞌn de ni gabagü me chehsh puert. Ru pshal yâme puert‑e naꞌ, rtzunadz yâme hor-bwieꞌ yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Were ptzoo me señ güyudzie yâme. Luxu bieno me diidz leeyâme mod-güloo Dioz leeme lidzyguiib. No ra me: ―Gyre ni gayun lo laꞌd, lâ gu leeu lo Jacob no lo zrieñ meññ-rman. No luxu, byruu me za me zrieñ lad. ");
INSERT INTO zpg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ni byre guiaal‑e naꞌ, ba di rdzial bia ctzoo soldad yahc, porni dgann yâme bia guhc Pedr, dgueññ me leññ lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Were pshahl Herody meññ bigyo yâme Pedr, per nehx bydzial yâme leeme. Bwieꞌ Herody di ndzial yâme Pedr, were psaꞌn meu chehsh soldad yahc ni güdahp ruꞌ lidzyguiib. No ptzoo me mdad guhty gyre soldad-wé yahc. Byluxu, byruu Herody Judea, zia me Cesarea no uga biaꞌn me. ");
INSERT INTO zpg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Leññ dze-wé yahc zegahc gadziadzyno Herody meññ-Tiro no meññ-Sidóṉ. Were meññ-wé yahc ptzoo yâme diidz gydzihñ yâme lo Herody. Günino yâme to xmeññ me ni le Blasto ni nu lo xtziiñ me. Mpyquie-rieꞌ biuꞌladzy me mod-ra yâme leeme. Leewe gucno me meññ-wé yahc, lehdy di gydziadzynor Herody gyrop ciuda-wé, porni de lo ṟegióṉ ru rtzoo Herody mdad riahd ni rdedydzé yâme. ");
INSERT INTO zpg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Were psieññ Herody leeyâme guiaad yâme to dzé. Ru ba bydzihñ dzé ni guiaad yâme, bihtz shab me ni ruhtz ṟeiy. No luxu, bicchie me ru rbia me de ṟeiy, no guzlo ganii me. ");
INSERT INTO zpg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Were meññ ni gayieññ guzlo rquee yâme riedz, ne yâme: ―¡Dac‑e cuentz meññ mpyquie-rieꞌ! ¡To dioz‑e leeme! ");
INSERT INTO zpg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","No hor-caḻ gahc biahd to x‑ángel Dioz ni rtzoo mdad, pshahl to guihdz günahzy leeme, porni bdee me ñahz psahc meññ leeme Dioz. No leewe güyuꞌ mcuch leeme guhty me, no leemaꞌ güdahgü leeme. ");
INSERT INTO zpg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Per xtiidz Dioz to to dzé ma gayann meññ leeu byzaꞌzy. ");
INSERT INTO zpg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bylux dziiñ ni ptzoo Bernabé no Saul Jerusaléṉ, gubyguiat yâme Antioquía sto, ziyno yâme Juaṉ, ni ra yâme lee Marcü. ");
INSERT INTO zpg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nu profet no muextr yahc lahd meññ-idoo ni nu Antioquía. Lee we Bernabé, no Simóṉ ni ra yâme lee Niger, no Lucy ni nac meññ-Ciren, no Manaéṉ ni byniꞌzy tohzy no ṟeiy-Herody, no Saul. ");
INSERT INTO zpg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","To dzé we naꞌ, hor-nu meññ-rman tohzy, gyre yâme gadee xquix Dioz no gatzoo yâme ayun, ra Spirt-Sant leeyâme: ―Cshahl laꞌd Bernabé no Saul ni ba güleꞌn lee. Tza yâme, dzictzoo yâme dziiñ ni ba ren. ");
INSERT INTO zpg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bylux ptzoo yâme ayun no günab yâme lo Dioz, were pshob ña yâme chehsh Bernabé no chehsh Saul, no pshahl yâme lee lehdy dzictzoo xtziiñ Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","No pshahl Spirt-Sant leeyâme to guiedzy ni le Seleucia. No de uga güyuꞌ yâme leññ barcü, güya yâme sto lyu ni le Chipre ni nu nisdoo guingybi. ");
INSERT INTO zpg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bydzihñ yâme to ciuda ni le Salamina ru rbiahz barcü. Uga bieno yâme meññ xtiidz Dioz leññ xiydoo meññ-Isṟael. No ziyno yâme Juaṉ-Marcü ni gayacno leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Luxu güya yâme gydo-bynac lgar-wé xtâ glo bydzihñ yâme to guiedzy ni le Pafos, no uga bydzial yâme to meññ-Isṟael ni le Barjesúz, rtzoo me guîlbrujü, no risquiee me meññ, ne me xprofet Dioz leeme, per nehx uliu. ");
INSERT INTO zpg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mpyquie-rieꞌ tirgahc nehx rruu me ru nu gobernador ni le Sergio Paulo, to mpyquie ni nniꞌ ihqy. Pshalcaꞌ gobernador-rieꞌ Bernabé no Saul güya ru nu me, porni riuꞌladzy me guieññ me xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Per mpyquie ni rtzoo guîlbrujü naꞌ, ni ra yâme lee Elimas lo didz-griegü, gucladzy me nca me Bernabé no Saul, no nehx gucladzy me nlíladzy gobernador xtiidz Dioz ni bieno apóstl yahc leeme. ");
INSERT INTO zpg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saul naꞌ, ni ra yâme lee zegahc Pabl, ulihbu nu Spirt-Sant xguîlmbahñ me, bwiedzie me brujü-caḻ, ");
INSERT INTO zpg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","no ra me lee: ―Xiiñ bêndzab, lii pur risquieey no rtzooy ni dirquihñ, no rruuy contr ni nac xñahzû, no nehx rsaaniꞌ de ni rtiꞌxiꞌ xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Per naꞌ, Dioz gyruu contr lii, gaquiꞌ ngaḻ no nehx zwieꞌy xibyniꞌ ncübidz leññ doozy dzé. Lohg hor-wé gucngaḻ me, no ba di raḻ seꞌ me tohg leeme, ba gayo me dxu gynahzy ña me. ");
INSERT INTO zpg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Hor-bwieꞌ gobernador mod-guhc Elimas, bylíladzy me no rtzunadz me lguia xtiidz Crist ni rluu apóstl yahc. ");
INSERT INTO zpg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Byluxu byruu Pabl Pafos, güyuꞌ me leññ barcü no meññ-ziyno me lee, za yâme Perge, to guiedzy ni nu lo ṟegioṉ-Panfilia. Per Juaṉ naꞌ psaꞌn leeyâme uga, gubyguiat me zia me Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Were byruu yâme Perge, güya yâme Antioquía lo ṟegioṉ-Pisidia. No dze-risladzy meññ, güyuꞌ yâme leññ xiydoo meññ-Isṟael no gürie yâme. ");
INSERT INTO zpg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bylux biiḻy meññ-nu yahc idoo xcargü lo libr ru ziaad leiy no lo libr ni bzaa profet, were ra yâme Pabl no Bernabé: ―Betzy, bâḻ rahp laꞌd behch ni cu laꞌd xguîlriehñ meññ-guiedzy la, beeiy gynii laꞌdu. ");
INSERT INTO zpg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Were guzli Pabl, ptzoo me señ no ña me lehdy guieññ yâme ni gynii me, no ra me: ―Lâ guieññ ni gapyaꞌ laꞌd, meññ-Isṟael no zegahcu laꞌd ni nehx meññ-Isṟael ni rzacbeeiy yahc Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dioz ni nu gybaa ni rlíladzy meññ-Isṟael lee, leeme we ni güle dmeññ nó ni güyuꞌ yahc ba xtze, no ptzoo me lee to nacioṉ-ro dze-nu yâme xilyu meññ-Egipt. No gumm beeiyu leeme la, güloo me leeyâme Egipt. ");
INSERT INTO zpg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","No ptibladzy me leeyâme leññ cuarent ihz ni güzeꞌ yâme lo yu-bihdzy. ");
INSERT INTO zpg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","No bniꞌdy me gahdzy nacióṉ ni güyuꞌ lo ṟegioṉ-Canáṉ, no bdee me xilyu yâme cuaꞌ dmeññ nó ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","No bdee me juez leeyâme leññ tahp gayuu cincuent ihz, xtâ profet-Samuel ni guhc últim xjuez yâme. ");
INSERT INTO zpg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bylux nirieꞌ, günab yâme to ṟeiy ni ptzoo mdad leeyâme. No Dioz bdee leeyâme to ṟeiy ni le Saúl, wé ptzoo mdad leeyâme leññ cuarent ihz. Xtad me le Cis, to mpyquie ni ziaad de lo xfamily Benjamíṉ. ");
INSERT INTO zpg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Dze-ba güloo Dioz Saúl de ni nac me ṟeiy, were ba güluꞌ me Davit guhc xṟeiy yâme. No ne Dioz: “Bydzialaꞌ Davit, xiiñ Isaí, to mpyquie ni riuꞌdadzyaꞌ mod-nac no stzoo gyre mod-racdadzyaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","No de lo gahc xfamily Davit‑e byruu Jesúz ni pshahl Dioz lee par guislaa meññ-Isṟael de lo guîlnadz ni ziaad, mod-bdee Dioz xtiidz. ");
INSERT INTO zpg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","No dze-dgueññ ziaꞌr guiaad Jesúz, güdedy Juaṉ bieno me xtiidz Dioz meññ-Isṟael, ra me lee: “Lâ csaan ni nahcsy ni nac laꞌd, lâ gyo Dioz no lâ gyrôbnihs.” ");
INSERT INTO zpg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","No dze-ba gadziñgahsh ni gaty Juaṉ günii me, ne me: “¿Dxu we ne laꞌd naa? Dac‑e naa ni gabiahz laꞌd lee; per nu sto ni guiaad lux de ni biaḻaꞌ ni nehx rsahcaꞌ ni xduu xguidguial me nshacaꞌ.” ");
INSERT INTO zpg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Betzy, laꞌd ni ziaad de lo xfamily Braṉ, no lahd laꞌd ni rzacbeeiy yahc Dioz: par gyre laꞌd‑e pshahl Dioz xtiidz me lehdy gann laꞌd bia mód beeiy gylaa meññ de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Meññ-nu yahc Jerusaléṉ no xguxtisy yâme nehx nann yâme dxu we Jesúz, ni nehx rieññ yâme ni rnii lo libr ni bzaa profet yahc ba xtze, nîcze ruuḻ yâme leeu leññ idoo gyre dze-risladzy meññ. Dze-biꞌdy yâme Jesúz, ptzoo yâme ni rnii lou. ");
INSERT INTO zpg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","No nîcze nehx bydzial yâme mbehty doḻ chehsh me par ñehty me, per günab yâme Pilat ptzoo mdad guhty me. ");
INSERT INTO zpg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Hor-ba bylux ptzoo yâme gyre ni rnii lo Guehtzy ru queꞌ xtiidz Dioz lguia me, were gülety yâme leeme lo cruzy lehdy bygaꞌdzy me. ");
INSERT INTO zpg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Per Dioz bispahñ leeme. ");
INSERT INTO zpg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","No leññ xtahl dzé ni bylux gübahñ me de lahd mînguty, bwieꞌ xmeññ me leeme ni byruu tohzy no leeme lo ṟegioṉ-Galilea dze-biahd yâme Jerusaléṉ. No leeyâme we ni runo xtiidz me dmeññ yahc nó. ");
INSERT INTO zpg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Naa no Bernabé zegahc zidgyuno noꞌ laꞌd diidz lguia ni bdee Dioz xtiidz me dmeññ yahc nó ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Leewe, nó ni ziaad de leeyâme, Dioz ba ptzoo me par nó ni günii me dze-bispahñ me Jesúz, mod-ziaadu lo libr ni rrohp salm, ni ne: “Lii we dShiñaꞌ; glohdy dzêrieꞌ zieññ dShiñaꞌ we lii.” ");
INSERT INTO zpg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dioz ba xtze we günii me guispahñ me Jesúz de lahd mînguty lehdy di gynihty xcuerp. Leewe lo Guehtzy ru queꞌ xtiidz Dioz, ne me: “Ni ulihbu diidz ni ba bdedyaꞌ Davit, zdedyaꞌu laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","No leewe rnii lo xtiidz Dioz sto salm, ne me: “Nehx zdeedyiꞌ ñahz gynihty xcuerp mpyquie-tziaawy ni güleꞌy lee.” ");
INSERT INTO zpg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Niwé yahc dac‑e de Davit ganiiu, porni ptzoo me dziiñ ni ne Dioz gac lahd meññ leññ dzé yahc ni güyuꞌ me. Davit naꞌ, bydzihñ dzé guhty me no bygaꞌdzy me ru bygaꞌdzy gahc xfamily me, no bynihty xcuerp me. ");
INSERT INTO zpg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Per mpyquie ni bispahñ Dioz lee, wé nehx bynihty xcuerp. ");
INSERT INTO zpg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","No leezuwe, betzy, racdadzyaꞌ gann laꞌd: por leeme we beeiy csiaaḻladzy Dioz xguîlquie laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Dxu rlíladzy leeme la, wé ssiaaḻladzy Dioz xguîlquie ni nehx beeiy ntzoo xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gax lâ güieꞌ, mod-günii profet yahc di guiahbu chehsh laꞌd, ru ne yâme: ");
INSERT INTO zpg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Lâ güieꞌ, laꞌd ni rxidzyno ni nac ni uli, lâ ctzunadz no lâ gynihty; porni gawieꞌ gahc laꞌd ni gatzon lóni mbahñ laꞌd, per nehx zlíladzy laꞌdu nîcze tzu dxu gunou laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ru ba byruu Pabl xiydoo meññ-Isṟael no zrieñ meññ-ziyno me, günab meññ-nehx meññ-Isṟael leeyâme guibyguiat yâme sto dze-risladzy meññ lehdy gyzac gluu yâme lee. ");
INSERT INTO zpg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Hor-ba garuu meññ-bydohp leññ idoo we naꞌ, xtahl meññ-Isṟael no zrieñ meññ ni ba guzlo gazobdiidz ni ne xleiy Moiséz, za yahc no Pabl no Bernabé. Pabl naꞌ no Bernabé, bieno yâme diidz meññ-rieꞌ zaꞌgndzi no güluꞌ yâme xguîlriehñ di csaꞌn yâme laꞌy ni ba bdee Dioz leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Güdahpu stiby seman, dze-risladzy meññ, casy gyre meññ ni nu yahc leññ ciuda güya yahc biguieññ xtiidz Dioz ni galuu yâme. ");
INSERT INTO zpg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Per meññ-Isṟael, modni güyuꞌ guîlrisnieꞌ leññ xguîlmbahñ yâme hor-bwieꞌ yâme xtahl meññ gadohp. Guzlo gahc ganii yâme didz-nahcsy contr Pabl, ne yâme nehx uliu ni ganii me. ");
INSERT INTO zpg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pabl naꞌ no Bernabé nehx rdzie yâme, ra yâme meññ-wé: ―Güdahp noꞌ de ni bieno noꞌ xtiidz Dioz nier laꞌd ni nac meññ-Isṟael; per gumm garuu laꞌd chehshu, no rwieꞌ laꞌd nehx par laꞌd guîlmbahñ ni nehx zluhx la, ngâstoo were ba tzo noꞌ ru nu meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Porni mod-wé we ptzoo Dioz mdad noꞌ, ne me: Ba güleꞌn lii lehdy gaquiꞌ beeiy to byniꞌ par meññ-nehx meññ-Isṟael, no lii dzigyunoy dtiidzaꞌ meññ ni nu gydo lo guiedzylie lehdy gann yâme bia mód gylaa yâme de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Hor-bieññ meññ-nehx meññ-Isṟael mod-günii me, byxihly yâme, no ne yâme mos mod-ne xtiidz Dioz, no bylíladzy gyre yâme ni ba güle Dioz leeyahc lehdy gap guîlmbahñ ni nehx zluhx. ");
INSERT INTO zpg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","No meññ ni nu yahc gydo lo ṟegioṉ-caḻ bieññ yâme xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Per meññ-Isṟael pquihly yâme meññ-ngünaa ni rzacbeeiy Dioz no ni rahp meññ xpeeiy lee, no zrieñ meññ-rsahc ni rnii yahc leññ ciuda-wé, par byo yâme mod-bgultihp meññ Pabl no Bernabé, no bisshuunn yâme lee de lo xṟegióṉ yâme. ");
INSERT INTO zpg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Luxu güdzihby yudé nieꞌ Pabl no Bernabé beeiy to señ de ni nahcsy‑e gatzoo meññ-uga. No luxu za yâme sto ciuda ni le Iconio. ");
INSERT INTO zpg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Per xmeññ Crist ni biaꞌn yahc Antioquía, rxihly yâme no ulihbu nu Spirt-Sant xguîlmbahñ yâme. ");
INSERT INTO zpg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Dze-nu Pabl no Bernabé ciuda-Iconio, güyuꞌ yâme leññ xiydoo meññ-Isṟael. No por mod-günii yâme lguia Jesúz, xtahl meññ-Isṟael bylíladzy, zegahcu meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Per zrieñ meññ-Isṟael ni nehx rlíladzy Jesúz pquihly yâme meññ-nehx meññ-Isṟael par bydziadzyno yâme gyre meññ-rman. ");
INSERT INTO zpg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","No leewe biaꞌn Pabl uga no Bernabé xtze, bieno yâme meññ xtiidz Dioz no nehx bydzie yâme. No Dioz bluu me ni uli ganii Pabl no Bernabé lguia xlaꞌy me por gyre ni ngann no zrieñ guîlrtzunadz yahc ni gucno Dioz rtzoo yâme. ");
INSERT INTO zpg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","No meññ ni nu yahc leññ ciuda-wé, guhc yâme chohp cuib. Doozy yâme queꞌ coo meññ-Isṟael, stoozy yâme queꞌ coo apóstl. ");
INSERT INTO zpg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Were meññ-Isṟael ptzoo yâme diidz no zrieñ meññ-nehx meññ-Isṟael no xguxtisy yâme par ctzoo csahc yâme Pabl no Bernabé, cshadguie yâme lee. ");
INSERT INTO zpg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Hor-gunn Pabl no Bernabé leeu, byruu gahc yâme de uga, za yâme ru le Listra no ru le Derbe, xciuda Licaonia, no gydo-bynac ñaz-wé güya yâme, ");
INSERT INTO zpg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","bieno yâme meññ xtiidz Crist. ");
INSERT INTO zpg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Leññ ciuda-rieꞌ ni le Listra, bydzial Pabl to mpyquie ni ndang, di raḻ seꞌ me glo dze-guhl me. ");
INSERT INTO zpg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mpyquie-rieꞌ dxie me gayieññ me ni ganii Pabl. Were bwieꞌ Pabl ru dxie me no bzaclo leeme ulihbu galíladzy me beeiy csiaḻ Dioz leeme. ");
INSERT INTO zpg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Were ra Pabl leeme: ―¡Biahsiꞌ no guzli! No biahs me lé güyubeꞌ me guia, no güzeꞌ gahc me. ");
INSERT INTO zpg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Hor-bwieꞌ meññ-Licaonia ni ptzoo Pabl, guzlo gahc gaquee yâme riedz lo xtiidz yâme, ne yâme: ―¡Dioz ba biaht yahc dlahd nó beeiy gahc meññ-guiedzylie! ");
INSERT INTO zpg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ne yâme: ―Bernabé we dioz-Júpiter, no Pabl we dioz-Mercurio, porni leeme we ni rluu. ");
INSERT INTO zpg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Xtâ bahl ni rtzoo dziiñ xiydoo dioz-Júpiter ni nu ruꞌ guiedzy, bidno me yuhz yahc no bidno me guiee ni guctziaawy. Leeme no meññ-guiedzy gucladzy yâme ngaꞌdy yâme yuz-caḻ par to gun lehdy ntzoo yâme xilni apóstl yahc. ");
INSERT INTO zpg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Hor-gunn Bernabé no Pabl ni gatzoo yâme, güdiix shab yâme no güyuꞌ yâme lahd meññ, ra yâme lee: ");
INSERT INTO zpg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¿Bia nacu gatzoo laꞌd ze? Meññ gahc‑e noꞌ beeiy gahc laꞌd. Por niwéhb we zioꞌb noꞌ lehdy ga noꞌ laꞌd ba di ctzoor laꞌd ni nehx rquihñ mbahty. Lâ gyo Dioz-mbahñ ni bzaa gybaa, guiedzylie, nisdoo no gyre ni nu. ");
INSERT INTO zpg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dzé ni ba güdedy yahc, Dioz bdee me ñahz meññ ptzoo ni ne xguîlriehñ. ");
INSERT INTO zpg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Per leeme psaꞌn me ni rdee diidz lguia gyre ni mos ni rtzoo me: Leeme we ni rtzoo guio lehdy yqueꞌ ni rdziib nó, no lehdy gap nó ni gahgü nó no lehdy tzu nó mos. ");
INSERT INTO zpg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nîcze günii apóstl gyre nirieꞌ, penzy pca yâme meññ lehdy di ntzoo yâme xilni apóstl no gyre gun ni bidno yâme. ");
INSERT INTO zpg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","No leññ dze-wé bydzihñ zrieñ meññ-Isṟael ni byruu yahc Antioquía no meññ-byruu yahc ciuda-Iconio, pquihly yâme meññ pshadguie Pabl; no luxu, güzûbyñu yâme lee bicsaaby yâme lee diby lad de leññ guiedzy, nlâdzy yâme ba guhty me. ");
INSERT INTO zpg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Were bydohp xmeññ Crist gybi ru nash me, no biahs me, zia me leññ guiedzy sto. Ni byre guiaal, za me no Bernabé ciuda-Derbe. ");
INSERT INTO zpg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ru bydzihñ yâme uga, bieno yâme meññ xtiidz Crist. Xtahl meññ bylíladzy guhc yahc xmeññ Crist. Luxu, güya yâme Listra sto, no Iconio no Antioquía. ");
INSERT INTO zpg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Gyre lgar-wé gucno yâme xmeññ Crist lehdy di gyxiññladzy yâme de ni galíladzy yâme xtiidz Dioz, no ra yâme leeyahc: ―Par tzu nó ru rtzoo Dioz mdad la, nier tedy nó gyrehzy ni nadz. ");
INSERT INTO zpg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","No to to idoo güle yâme rman yahc ni rsahc ni rnii. No lux günab yâme lo Dioz no ptzoo yâme ayun, psaꞌn yâme meññ-rieꞌ yahc lo ña Dioz ni galíladzy yâme lee. ");
INSERT INTO zpg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Luxu güdedy yâme lo ṟegioṉ-Pisidia, were bydzihñ yâme lo ṟegioṉ-Panfilia. ");
INSERT INTO zpg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bylux bieno yâme meññ xtiidz Dioz guiedzy-Perge; were byruu yâme, güya yâme ciuda-Atalia. ");
INSERT INTO zpg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Uga güyuꞌ yâme leññ barcü lehdy gubyguiat yâme Antioquía ru nu xmeññ Dioz ni psaꞌn leeyâme tzcaḻ lo xguîlndzi Dioz lehdy dzictzoo yâme xtziiñ me, no naꞌ ba bylux ptzoo yâmeu. ");
INSERT INTO zpg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ru bydzihñ yâme Antioquía, ptohp yâme gyre meññ-idoo no bieno yâme diidz lee gyre mod-gucno Dioz leeyâme ru güya yâme, no mod-bdee Dioz ñahz bylíladzy meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","No xtze güyuꞌ Pabl no Bernabé uga no xmeññ yahc Crist. ");
INSERT INTO zpg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Leññ dze-wé yahc bydzihñ doozy meññ ni byruu lo ṟegioṉ-Judea, guzlo galuu yâme meññ-rman ni nu yahc Antioquía, ra yâme lee: “Racladzyu tzu señ lady laꞌd, were beeiy gylaa laꞌd de lo guîlnadz, porni mod-wé ganii lo xleiy Moiséz.” ");
INSERT INTO zpg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","No por leeu, Pabl no Bernabé güdeḻydiidz no leeyâme. Were guhc diidz de ni Pabl no Bernabé no zrieñ meññ-idoo tza Jerusaléṉ, dzigyuno yâme apóstl no rman yahc ni rsahc ni rnii ni nu uga lguiau. ");
INSERT INTO zpg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","No pshahl meññ-idoo leeyâme za yâme, no lóni gadedy yâme lo ṟegioṉ-Fenicia no Samary, bieno yâme diidz meññ-rman de ni zegahc meññ-nehx meññ-Isṟael ba galíladzy xtiidz Dioz. Hor-bieññ yâme nirieꞌ, modni byxihly yâme. ");
INSERT INTO zpg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Dze-bydzihñ yâme Jerusaléṉ, meññ-idoo yahc no apóstl yahc no rman yahc ni rsahc ni rnii, byxilyno yâme Pabl no Bernabé hor-bydzihñ yâme uga, no bie Pabl no Bernabé diidz lo yâme mod-gucno Dioz leeyâme gyre ru güya yâme. ");
INSERT INTO zpg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Were guzli meññ-nac yahc fariseu ni ba bylíladzy xtiidz Crist, ne yâme: ―Racladzyu tzu señ lady meññ-nehx meññ-Isṟael ni ba bylíladzy xtiidz Dioz, no ga nó leeyâme ctzoo yâme ni ne xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Were bydohp apóstl yahc no rman yahc ni rsahc ni rnii par güieꞌ yâme bia mód ctzoo yâme lguiau. ");
INSERT INTO zpg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bylux günii to to yâme ni ne xguîlriehñ, were guzli Pedr, ra leeyâme: ―Rman, nann laꞌd Dioz güle me naa lahd laꞌd lehdy dzigyunon meññ-nehx meññ-Isṟael xtiidz Crist, lehdy gylíladzy yâme leeme zegahc. ");
INSERT INTO zpg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dioz ni rzaclo xguîlmbahñ meññ, bdee me diidz hor-bdee me Spirt-Sant leeyâme, mod-ptzoo gahc me no nó. ");
INSERT INTO zpg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dioz nehx gaboo leeyâme diby lad porni tohzy mdid rsahc me leeyâme no nó. Leeme ba güdihby me xguîlmbahñ meññ-wé yahc porni bylíladzy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Per naꞌ, ¿biaz nacu garuu laꞌd chehsh ni gatzoo Dioz? Riñlo laꞌd ctzoo zrieñ xmeññ Crist to ni ngann ni zidguiahc beeiy to yuu ni naꞌy ni ñuu yâme, per ni nó gahc ni ngydo-dtadgul yahc nó di ñaḻ ntzoo mod-neu. ");
INSERT INTO zpg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mazyg nó rlídadzy nó zlaa nó de lo guîlnadz ni ziaad por xlaꞌy Jesúz ni rtzoo mdad, no modé gahc‑e zislaa me meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","No were biandzie gyre yâme, gayieññ yâme ni ganii Bernabé no Pabl lguia blaty gucno Dioz ptzoo yâme ni ngann yahc no zrieñ xroꞌ cos yahc ru güya yâme ru nu meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bylux günii yâme, were günii Jacob, ne me: ―Lâ guieññ ni gapyaꞌ laꞌd, rman. ");
INSERT INTO zpg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simóṉ bie me diidz mod-ba guzlo gayacno Dioz meññ-nehx meññ-Isṟael, lehdy gac yâme xmeññ me zegahc. ");
INSERT INTO zpg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","No mod-wé we ziaadu lo xtiidz Dioz ni bzaa profet ba xtze, ru günii me, ne me: ");
INSERT INTO zpg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Gylux nirieꞌ guibyguiataꞌ, no gzan xiryuꞌ Davit ni bydinguie; no guistziawyaꞌ ni biaꞌn par gacu mod-nacu tzcaḻ, ");
INSERT INTO zpg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","lehdy gyre zrieñ meññ gyo Dioz, xtâ no meññ-nehx meññ-Isṟael, ni ba pqueen riedz lee gyo yâme naa. ");
INSERT INTO zpg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Modé ne Dioz, no ba xtze diaa we günii me gacu mod-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’No leewe ren nehx xñahzu ña nó meññ-nehx meññ-Isṟael ni gayo Dioz, ctzoo yâme ni ne xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mazyg gzaa nó to guehtzy ni cshahl nó lo yâme, no ga nó leeyâme di gahgü yâme ni rbia lo cuentz figur, ni di seno yâme ni nehx tziahl yâme lee, ni di gahgü yâme maꞌ ni retycawy, ni di gahgü yâme rieñ. ");
INSERT INTO zpg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Porni xleiy Moiséz, glo ba xtze diaa we nu dxu rluu leeu leññ idoo ni nu to to guiedzy, ru ruuḻ yâme lou gyre dze-risladzy meññ. ");
INSERT INTO zpg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Were apóstl yahc, no rman yahc ni rsahc ni rnii, no zrieñ meññ-idoo ptzoo yâme diidz par güle yâme chohp tzonn meññ-mpyquie de lahd yâme lehdy cshahl yâme lee Antioquía tohzy no Pabl no Bernabé. Güle yâme Jud ni zegahc le Barsabáz, no Silas. Gyrop mpyquie-rieꞌ yahc‑e, meññ-rsahc ni rnii yahc lahd meññ-rman. ");
INSERT INTO zpg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","No mod-rieꞌ ganii lo guehtzy ni bzaa yâme par tziyno rman-rieꞌ yahc: “Noꞌ ni nac apóstl, tohzy no rman yahc ni rsahc ni rnii, gashahl noꞌ diux lo rman yahc ni nehx meññ-Isṟael ni nu Antioquía, no zegahc ni nu Siry no ni nu Cilicy. ");
INSERT INTO zpg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ba nann noꞌ güya meññ ru nu laꞌd ni byruu dlahd noꞌ, per dac‑e noꞌ pshahl leeyâme. Pchaḻ yâme laꞌd porni ne yâme tzu señ lady laꞌd no ctzoo laꞌd ni queꞌ lo xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","No leewe, gyre noꞌ ba güyuꞌ noꞌ tohzy guîlriehñ, güle noꞌ lahd meññ-rman ni zidgüieꞌ ru nu laꞌd, tohzy no rman-Bernabé no rman-Pabl ni ndzi noꞌ leeyahc. ");
INSERT INTO zpg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Rman-rieꞌ yahc xtahl vuelt bylaa ngaꞌdy meññ leeyâme, porni rzoob yâme xtiidz Jesucrist ni rtzoo mdad nó. ");
INSERT INTO zpg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","No leewe, pshahl noꞌ Jud no Silas par ga yâme laꞌd ni uli we ni queꞌ lo guetzy-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nehx riuꞌladzy Spirt-Sant, ni noꞌ zegahc, par ctzoo noꞌ mdad laꞌd ctzohd zrieñ cos, mazyg nirieꞌ yahc: ");
INSERT INTO zpg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Di gahgü laꞌd ni rbia par to gun lo cuentz figur, ni di gahgü laꞌd rieñ, ni maꞌ ni retycawy, no di seno laꞌd ni nehx tziahl laꞌd lee. Niwé yahc‑e ni ctzohd no zruqueꞌ lad mos. Zaꞌgru tzu laꞌd.” ");
INSERT INTO zpg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Luxu, pshahl yâme meññ-wé yahc, za Antioquía. Bydzihñ yâme, ptohp yâme gyre meññ-idoo no luxu bdee yâme guehtzy lee ni ziyno yâme. ");
INSERT INTO zpg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bylux biiḻy meññ-rman lo guetzy-wé, modni byxihly yâme, porni mod-ganiiu gucnou leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jud naꞌ no Silas, ni zegahc nac yahc profet, gucno yâme rman-wé yahc, xtze bieno yâme diidz lee, ra yâme: “Di gyrugan laꞌd de lo xtiidz Dioz.” ");
INSERT INTO zpg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Xtze biaꞌn yâme uga, no hor-ba guibyguiat yâme ru nu meññ-pshahl leeyâme, were ra meññ-rman ni nu Antioquía leeyâme: “Zaꞌgru lâ tza, gydzihñ laꞌd mos.” ");
INSERT INTO zpg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Per Silas biuꞌladzy me biaꞌn me uga no meññ-rman. ");
INSERT INTO zpg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pabl no Bernabé zegahc biaꞌn yâme Antioquía. Leeyâme no zrieñ yahc meññ-rman, rigyuno yâme no rluu yâme meññ xtiidz Crist. ");
INSERT INTO zpg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Güdahpu stoozy dzé ra Pabl Bernabé: ―Tzo nó dzictixlo nó meññ-rman gyre ciuda ru ba gahc güyo nó bigyuno nó meññ xtiidz Dioz, lehdy güieꞌ nó xnahc nu yâme. ");
INSERT INTO zpg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé biuꞌladzy me niyno yâme Juaṉ, ni zegahc le Marcü; ");
INSERT INTO zpg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","per Pabl nehx biuꞌladzy porni to vuelt psaꞌn Juaṉ-Marcü leeyâme Panfilia, nehx güya me no leeyâme nigyuno yâme meññ xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","No ba di ñaḻ ñuꞌ yâme tohzy guîlriehñ, beeiydí to to yâme ptzoo dziiñ gydze; Bernabé güiyno me Marcü, güyuꞌ yâme leññ barcü, za yâme Chipre. ");
INSERT INTO zpg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pabl naꞌ biuꞌladzy me tziyno me Silas, no byruu yâme ru ba günab meññ-rman por leeyâme no psaꞌn leeyâme ladzyña Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Luxu, güya yâme zrieñ ṟegioṉ ru le Siry no Cilicy, bigluu yâme meññ-idoo lehdy gann yâme xtiidz Dioz mazy no di gyrugan yâme. ");
INSERT INTO zpg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bydzihñ yâme guiedzy ni le Derbe no de wé byruu yâme güya yâme Listra. Uga bydzial yâme to xmeññ Crist ni le Timoteu; xmam me meññ-Isṟael‑e leeme no rlíladzy me Crist, no xtad Timoteu, wé we meññ-griegü. ");
INSERT INTO zpg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Meññ-rman ni nu yahc Listra no ni nu yahc Iconio, bdee yâme diidz de ni Timoteu rtzoo me ni mos. ");
INSERT INTO zpg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","No leewe biuꞌladzy Pabl tziyno leeme dzigyuno yâme meññ xtiidz Dioz, per nier güluꞌ me señ lady Timoteu lehdy di gynii meññ-Isṟael ni nu ñaz-wé yahc mbehty chehsh me, porni gyre yâme nann xtad Timoteu meññ-griegü leeme. ");
INSERT INTO zpg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Luxu za yâme, gayuno yâme xmeññ Crist ni nu to to guiedzy ru bydzihñ yâme bia mód ne apóstl yahc no rman yahc ni rsahc ni rnii ni bydohp Jerusaléṉ, no günii yâme ni ctzoo meññ-rman ni nehx meññ-Isṟael leeyahc. ");
INSERT INTO zpg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","No modé ba ma zaꞌgndzi gayuꞌ meññ-idoo de ni rlíladzy yâme, no to to dzé ba ma gane yâme. ");
INSERT INTO zpg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Per lo ṟegioṉ-Asia nehx bdee Spirt-Sant ñahz ña Pabl no Silas nigyuno yâme meññ xtiidz Dioz. No por leeu güdedyñahz yâme lo regioṉ-Frigia no Galacia. ");
INSERT INTO zpg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bydzihñ yâme ru rizlo sto ṟegióṉ ni le Misia; uga gucladzy yâme ña yâme lo ṟegioṉ-Bitinia, per xiSpirt Jesúz di ndee ñahz ña yâmeu. ");
INSERT INTO zpg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Leewe güdedyñahz yâme lo ṟegioṉ-Misia xtâ bydzihñ yâme ciuda ni le Troas ru rbiahz barcü. ");
INSERT INTO zpg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","No guial-caḻ günii xcaaḻ Pabl to meññ-nu lo ṟegioṉ-Macedony, zu gaya leeme: “Guiaadiꞌ Macedony, gacnoy noꞌ.” ");
INSERT INTO zpg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Leewe, di nleer noꞌ, zo gahc noꞌ ṟegioṉ-Macedony, porni ne noꞌ Dioz‑e gashahl noꞌ uga, dzigyuno noꞌ meññ xtiidz Crist. ");
INSERT INTO zpg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Were güyuꞌ noꞌ leññ barcü ru le Troas no güyo noꞌ lyu ni le Samotracia ni nu nisdoo guingybi. Ni byre guiaal bydzihñ noꞌ ciuda ni le Neápolis. ");
INSERT INTO zpg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De uga byruu noꞌ güyo noꞌ Filipos, to ciuda ru rtzoo meññ-Ṟom mdad. No ciuda-wé we ni ma xroꞌ lahd gyre guiedzy ni nu Macedony. Doozy dzé bylee noꞌ uga. ");
INSERT INTO zpg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","No to dze-risladzy meññ byruu noꞌ leññ ciuda, güyo noꞌ coo guiahgü, to ru ria meññ-Isṟael rignab yâme lo Dioz. Uga gürie noꞌ, no bieno noꞌ xtiidz Dioz meññ-ngünaa ni bydohp lgar-wé. ");
INSERT INTO zpg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","To de lahd yâme le Lidy, meññ-Tiatira leeme. Ngüna-rieꞌ rtoꞌ me lar-morad ni rsahc no rzacbeeiy me Dioz. Lóni gayieññ me ni ganii Pabl, pshal Dioz xguîlmbahñ me bylíladzy meu. ");
INSERT INTO zpg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","No byluxu, byrôbnihs me tohzy no gyre xmiꞌñ me. No ra me noꞌ: ―Bâḻ rwieꞌ laꞌd neññ ulihbu ba bylídadzyaꞌ Dioz la, rnabaꞌ gybiꞌ laꞌd diryuꞌn. No ptzoo me gan gübiꞌ noꞌ xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sto dzé we naꞌ, ru zo noꞌ ru rnab noꞌ lo Dioz, bwieꞌ noꞌ to criad ni byzee ni nu bêndzab lee, ndzabxtohby leeme. Bêndzab naꞌ risnii leeme de ni dziguiahcr, no xroꞌ medy rtzoo me gan par meññ-rtzoo yahc mdad leeme, porni rnii me ni riuꞌladzy meññ gann. ");
INSERT INTO zpg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ngüna-rieꞌ náḻ me Pabl no noꞌ, gaquee me riedz, ne me: ―Mpyquie-rieꞌ yahc la, xtziiñ Dioz ni nu gybaa we gatzoo yâme. Leeyâme gayuno yâme laꞌd xtiidz Dioz lehdy beeiy gylaa laꞌd de lo guîlnadz ni ziaad. ");
INSERT INTO zpg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","No leññ gyre dzé ni rwieꞌ me noꞌ, tohzy mod-wé rnii me. No were pshacladzy Pabl, bidzguiat lo me, bwieꞌ me ngüna-wé no günii me, ne me: ―Bêndzab, gayapyaꞌ lii por le Jesucrist: Byruu de ngüna-wé. No lohg hor-wé byruu bêndzab ni nu ngüna-wé. ");
INSERT INTO zpg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Hor-bwieꞌ meññ-rtzoo mdad leeme ba di raḻ gdee me diidz mod-antzy no ba gydi mód ctzoo me gan medy ni ycaꞌ yâme la, günahzy gahc yâme Pabl no Silas, ziyno yâme lee lo guxtisy ni nu uga. ");
INSERT INTO zpg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bydziñno yâme leeyahc, ra yâme guxtisy: ―Meññ-rieꞌ yahc ni nac meññ-Isṟael, gaquihly yâme meññ-dguiedzy nó lehdy gybiiñ yahc. ");
INSERT INTO zpg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","No galuu yâme lee zrieñ costumbr ni nehx beeiy ycaꞌ nó no ni nehx beeiy ctzoo nó mod-ne, porni nó nac nó meññ-Ṟom. ");
INSERT INTO zpg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Were byruu meññ-guiedzy contr Pabl no Silas, no ptzoo guxtisy mdad byruu shab yâme no bydihñ yâme no var. ");
INSERT INTO zpg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bylux güdihñ meññ-wé leeyâme zaꞌgndzi, were guhc mdad güyuꞌ yâme lidzyguiib. No ra yâme mpyquie-rahp ruꞌ lidzyguiib: “Gapiꞌ leeyâme zaꞌgndzi lehdy di gyruu yâme.” ");
INSERT INTO zpg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ru bieññ me mod-ra guxtisy leeme, güluꞌ me Pabl no Silas ma leññ diaa lidzyguiib. No güluꞌ me gyrop nieꞌ meññ-wé yahc leññ xguiehr chohp tros ni le cepo lehdy di gylaa yâme. ");
INSERT INTO zpg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Per Pabl naꞌ ganab me lo Dioz beeiy glaꞌy guiaal no Silas, no gayuuḻ yâme himn. Gyre meññ ni nyagü lidzyguiib gayieññ gayuuḻ yâme no ganab yâme lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tohzy guzlo guhc to xu-ro, lé za ziaad lidzyguiib. Lo hor-wé byxal gyre xpuert lidzyguiib no byxac caden yahc ni nliiby gyre meññ-nyagü. ");
INSERT INTO zpg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","No biuꞌlo mpyquie-gayahp ruꞌ lidzyguiib, bwieꞌ me ba nxal gyre xpuert lidzyguiib. Güloo gahc me xispad me lehdy ngaꞌdy me leegahcme, porni nlâdzy me ba bylaa meññ-wé ni nu yahc lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Were pquee Pabl riedz, ra leeme: ―¡Di ctzunéy lii! Gyre noꞌ nu neꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Were mpyquie-rahp ruꞌ lidzyguiib, günab me gue no güyu-güxuunn me, bisshiby me lo Pabl no lo Silas lé rzîbyyoob me. ");
INSERT INTO zpg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","No luxu, güloo me leeyâme lidzyguiib, no ra me: ―¿Bia mód ntzon par nlaan de lo guîlnadz ni ziaad? ");
INSERT INTO zpg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ra yâme leeme: ―Bylíladzyiꞌ Jesucrist ni rtzoo mdad no were beeiy zlaay de lo guîlnadz ni ziaad, no modé zlaa xmiꞌñiꞌ zegahc. ");
INSERT INTO zpg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","No bieno yâme leeme xtiidz Crist ni rtzoo mdad, no gyre xmiꞌñ me ni nu xiryuꞌ me. ");
INSERT INTO zpg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","No guial-caḻ gahc güdihby me lo xrid Pabl no Silas, no byrôbnihs gahc me gydibyno gyre xmiꞌñ me. ");
INSERT INTO zpg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","No güiyno me Pabl xiryuꞌ me no Silas par bdee yâme ni güdahgü. No rxihly me no gyre xmiꞌñ me, porni ba bylíladzy yâme xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ni byre guiaal‑e naꞌ, pshahl guxtisy xmeññ yâme, bigyne mpyquie-rahp ruꞌ lidzyguiib, ra yâme leeme: ―Ba beeiy guislaay mpyquie-wé yahc. ");
INSERT INTO zpg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Were mpyquie-rahp ruꞌ lidzyguiib ra me Pabl: ―Pshahl guxtisy meññ-bidne guislaan laꞌd. No leewe, naꞌ hôrrieꞌ ba beeiy gyruu laꞌd, no zaꞌgru tza laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Per Pabl naꞌ, ra me xmeññ guxtisy: ―Noꞌ meññ-Ṟom‑e noꞌ, no ptzoo guxtisy mdad bydihñ noꞌ ñaz-lo nyug no di ñahc nier guîlguxtisy, no güluꞌ yâme noꞌ lidzyguiib. ¿No naꞌ ne yâme gyruu noꞌ ngaꞌdzy la? ¡Nehx beeiyu! Guiaad yâme leeyâme, guidloo yâme noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Hor-bieññ guxtisy ni ra Pabl xmeññ yâme, bydzie yâme porni gunn yâme meññ-Ṟom‑e Pabl no Silas. ");
INSERT INTO zpg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","No were güya merp guxtisy, bignab yâme csiaaḻladzy Pabl no Silas gyre ni ptzoo yâme, no güloo yâme lee lidzyguiib. No ra yâme lee: ―Lâ guieññ, lâ gyruu leññ ciuda-rieꞌ, lâ tza zrieñ lad. ");
INSERT INTO zpg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Hor-byruu yâme lidzyguiib, zia yâme xiryuꞌ Lidy. No bylux bieno yâme diidz meññ-rman di gyrugan yahc, byruu yâme za yâme. ");
INSERT INTO zpg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Lóni za Pabl no Silas, güdedy yâme guiedzy-Anfípolis no guiedzy-Apolonia. Luxu bydzihñ yâme to ciuda ni le Tesalónyc, ru nu to xiydoo meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pabl naꞌ, güya me ido-wé porni modé rtzoo me gyre ru ria me. No leññ tzonn seman gyre dze-risladzy meññ, bluu me leeyâme ni ganii lo Guehtzy ru queꞌ xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Bluu me leeyâme no güloxñahz me ru ziaadu de ni Crist nehx ndedy de ni guhty me no gübahñ me de lahd mînguty. No ra me leeyâme: ―Jesúz, ni gayunon laꞌd de lee, leegahcme we nac Crist. ");
INSERT INTO zpg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Lahd meññ-Isṟael bylíladzy, no cueꞌ yâme coo Pabl no Silas. Zegahc xtahl meññ-griegü ni rzacbeeiy Dioz, biuꞌladzy yâme mod-bluu me, no zegahc zrieñ meññ-ngünaa ni rahp xpeeiy meññ lee leññ guiedzy-rieꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Per zrieñ meññ-Isṟael ni nehx rlíladzy, ptzumvidy yâme lguia mod-gadohp meññ Pabl no Silas; no leewe ptohp yâme doozy meññ-dirquihñ ni nehx rtzoo dziiñ, lehdy gübiiñ yâme leññ ciuda. Bictzu yâme li to mpyquie ni le Jasóṉ, bigyo yâme Pabl no Silas lehdy nteedy yâme lee lo ña meññ-guiedzy. ");
INSERT INTO zpg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Per di ndzial yâme Pabl ni Silas. Were günahzy yâme Jasóṉ no zrieñ meññ-rman, güzûbyñu yâme lee, ziyno yâme lee lo guxtisy, za yâme gaquee yâme riedz ne yâme: ―Meññ-rieꞌ yahc‑e ni gachaḻ xguîlriehñ meññ gyre lad, naꞌ ba bydzihñ yâme neꞌ zegahc. ");
INSERT INTO zpg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","No Jasóṉ‑e bdee xiryuꞌ bydzihñ yâme; no gyre yâme garuu contr xleiy meññ-Ṟom, ne yâme Jesúz, leeme we sto ṟeiy. ");
INSERT INTO zpg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ru bieññ meññ-guiedzy no guxtisy ni ganii meññ-rieꞌ yahc, gübiiñ yâme. ");
INSERT INTO zpg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Per ptzoo guxtisy mdad Jasóṉ no zrieñ meññ-rman güdix yâme, no were bylaa yâme. ");
INSERT INTO zpg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Guiaal gahc güloo meññ-rman Pabl no Silas, za yâme ñaz-Berea. Ru bydzihñ yâme Berea, za yâme xiydoo meññ-Isṟael ni nu uga. ");
INSERT INTO zpg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","No meññ-rieꞌ ma nxal xguîlriehñ yâme, nehx nac yâme beeiy meññ-Tesalónyc. Biuꞌladzy yâme mod-rluu Pabl no Silas, no zaꞌgndzi gayuuḻ yâme lo Guehtzy ru queꞌ xtiidz Dioz gyre dzé lehdy güieꞌ yâme bâḻ uliu modé ziaadu. ");
INSERT INTO zpg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","No leewe, xtahl meññ-Isṟael bylíladzy xtiidz Dioz; no de lahd meññ-griegü bylíladzy xtahl yâme, meññ-ngünaa ni rahp xpeeiy meññ lee, no zegahcu meññ-mpyquie. ");
INSERT INTO zpg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Per meññ-Isṟael ni nu yahc Tesalónyc, ru bieññ yâme diidz de ni galuu Pabl xtiidz Dioz meññ-Berea, güya gahc yâme uga, pquihly yâme meññ-xtahl gübiiñ. ");
INSERT INTO zpg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Per meññ-rman ni nu yahc Berea, pshahl gahc yâme Pabl ñaz-coo nisdoo. Silas no Timoteu, wé biaꞌn yahc uga. ");
INSERT INTO zpg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","No meññ-bicsaꞌn Pabl, güiyno yâme leeme xtâ ciuda ni le Atenas. No hor-gubyguiat yâme, bidno yâme diidz de ni ne Pabl tza Silas no Timoteu ngueeḻy gahc ru nu me Atenas. ");
INSERT INTO zpg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Leññ dze-nu Pabl Atenas, gabiahz me Silas no Timoteu, bioobu leeme porni gawieꞌ me bydzeꞌ cuentz figur leññ ciuda ni rzacbeeiy meññ lee. ");
INSERT INTO zpg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","No leewe, ria me xiydoo meññ-Isṟael rigluu me xtiidz Dioz leeyâme, no zegahc zrieñ meññ-nehx meññ-Isṟael ni rzacbeeiy Dioz. No gyre dzé ria me leññ guiedzy ru ma rdohp xtahl meññ lehdy guno me lee xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","No meññ-rdee diidz de ni ma ngann, güdeḻydiidz yâme no leeme. Lahd yâme we meññ-epicúreo no zrieñ yâme we meññ-estoico. Hor-bieññ yâme mod-günii Pabl, lahd yâme ne: ―¿Biaz‑e leeu ni rnii mpyquie-rieꞌ no nehx riandzie me? Sto cuib yâme ne: ―Mpyquie-rieꞌ la, galuu me meññ gzacbeeiy xdioz meññ zrieñ guiedzy. Günii yâme ze, porni runo Pabl leeyâme diidz lguia Jesúz no de ni gübahñ me. ");
INSERT INTO zpg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Were güiyno yâme Pabl to dahñ ni le Areópago ru rdohp guxtisy par gap yâme junt. Bydzihñ yâme uga, ra yâme leeme: ―¿Beeiy gluuy noꞌ bia leeu ni gayunoy meññ la, nito dgueññ guieññ noꞌ gynii ndruhty de leeu? ");
INSERT INTO zpg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Par noꞌ, ngann ni rluuy. Racdadzy noꞌ gann noꞌ bia rniiu. ");
INSERT INTO zpg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ra yâme leeme ze, porni meññ-Atenas no meññ-mbiuhz ni nu yahc uga, nehx riuꞌladzy yâme sto cos, mazyg riuꞌladzy yâme guieññ yâme behch ni dgueññ guieññ yâme no gu yâme ni nehx ziaꞌr nann meññ. ");
INSERT INTO zpg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Were guzli Pabl glaꞌy ru dxie guxtisy yahc, ra me meññ-Atenas ni bydohp ru le Areópago: ―Gyre ni rwien leññ xciuda laꞌd, lee we ni rdee diidz modni rlíladzy laꞌd xṟeligióṉ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ru güdeedyaꞌ ru rzacbeeiy laꞌd xdioz yahc laꞌd, bwien to ltar, queꞌ lou ni ganii ne: NIRIEꞌ PAR DIOZ NI NEHX RZACLO MEÑÑ LEE. No Dioz ni rzacbeeiy laꞌd lee sinn gann laꞌd dxu we leeme, xtiidz me we ni dzigyunon laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Dioz ni bzaa guiedzylie no gyre ni nu lou, leeme we rtzoo mdad gybaa no gyre ni rwieꞌ nó lo guiedzylie. No nehx beeiy ñahc xiryuꞌ me to idoo ni rzaa meññ lee, ");
INSERT INTO zpg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ni nehx rquihñ me dxuhch par gacno leeme, porni mbehty nehx riaadz me. Leeme we rdee guîlmbahñ gyre meññ, no de ni rcaꞌ nó mbeꞌ no rdee me gyre ni rquihñ nó. ");
INSERT INTO zpg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’No de to meññ ni bzaa me lee, wé we byruu gyre meññ ni nu gydo lo guiedzylie. Leeme we bzaa me meññ lehdy tzu yâme gydo lo guiedzylie. No leeme günii buc ctzoo to to nacióṉ mdad no xtâ bá glohdy. ");
INSERT INTO zpg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Dioz ptzoo me ze lehdy gyo meññ leeme, per bâḻ beeiy gydzial yâme leeme ru gayo yâme leeme tziaawy tziaawy gá beeiy lo guibcawy. Per Dioz, gahsh gahc‑e nu me de to to meññ. ");
INSERT INTO zpg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","No por leeme we mbahñ nó, rniꞌby nó, no nu nó lo guiedzylie. Uliu we mod-ne lahd xpoet laꞌd, ne yâme: “Xfamily me we nó.” ");
INSERT INTO zpg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Gumm uliu xfamily Dioz nó la, nehx nu par bia csahc nó Dioz cuentz figur ni rzaa meññ lee de or, de plat, de guie, ni de zrieñ cos mazy ni rziññ ihqy yâme. ");
INSERT INTO zpg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dioz ba ptzoo me beeiy ni di nwieꞌ me gyre zâ niwé ni ptzoo meññ-güyuꞌ ba xtze, porni ptzoo yâmeu por guîldgann. Per naꞌ rtzoo me mdad gyre meññ gyo yâme leeme par csaan yâme ni nahcsy ni nac yâme. ");
INSERT INTO zpg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Porni Dioz ba güle me to dzé ctzoo me guîlguxtisy lguia gyre meññ no to mod-nac xñahzu, no ctzoo meu por mpyquie ni ba güle me lee. No Dioz bluu me gyre meññ nirieꞌ ni uli we leeu dze-bispahñ me mpyquie-rieꞌ de lahd mînguty. ");
INSERT INTO zpg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nu yâme modni byxidzynou hor-bieññ yâme günii Pabl de ni gybahñ meññ de lahd mînguty. Zrieñ yâme ra leeme: ―Sto gaññ dzé gluuy noꞌ de niwé. ");
INSERT INTO zpg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Byluxu byruu Pabl de ru dxie meññ-wé yahc ni nac guxtisy. ");
INSERT INTO zpg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Per lahd yâme bylíladzy mod-bluu me, no za gahc yâme no leeme. Lahd meññ-bylíladzy ziaad to mpyquie ni le Dionisy ni nu lahd guxtisy-wé ni rdohp chehsh dañ-Areópago, no sto ngünaa ni le Dámaris, no zrieñ meññ yahc. ");
INSERT INTO zpg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Byruu Pabl Atenas, güya me to ciuda ni le Corint. ");
INSERT INTO zpg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Uga bzaclo me to meññ-Isṟael, ni le Aquil, ni byruu ñaz-lo ṟegioṉ-Ponto. Tziahl mpyquie-rieꞌ le Priscil. Byruu yâme Italy porni Claudy, ni rtzoo mdad meññ-Ṟom, ptzoo me mdad byruu gyre meññ-Isṟael xilyu Ṟom. Leer gá bydzihñ yâme Corint, no güya Pabl bictixlo leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pabl naꞌ, gumm zâ gahc dziiñ ni rtzoo yâme rtzoo me la, leewe biaꞌn me no leeyâme no ptzoo yâme dziiñ tohzy; rzaa yâme de lahr ni riaa yuꞌ ni riuꞌ meññ lo camp. ");
INSERT INTO zpg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","No gyre dze-risladzy meññ, ria Pabl xiydoo meññ-Isṟael, runo me diidz lee no zegahcu meññ-nehx meññ-Isṟael lehdy tzúladzy yâme gyo yâme Crist. ");
INSERT INTO zpg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Dze-bydzihñ Silas no Timoteu ru nu Pabl de ni byruu yâme ṟegioṉ-Macedony, nunzy xtziiñ Dioz ptzoo Pabl, bluu me meññ-Isṟael xtiidz Dioz, ne me: Jesúz, leeme we nac Crist. ");
INSERT INTO zpg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Per leeyâme aaḻ bydziaꞌdzy yâme, byruu yâme contr leeme. Niwé bwieꞌ me, cuaꞌ shab me güdzihby me yudé lee, guhcu to señ ba csaꞌn me leeyâme, no ra me: ―Naꞌ, ba laꞌd‑e rahp doḻ bâḻ gynihty laꞌd. Naa ba nehx nu mbehty dcheshaꞌ, ba gubychie ni nac dcuentaꞌ we. Glohdy ngâstoo were ba tzan ru nu meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Luxu byruu me de ru nu me, zia me xiryuꞌ to mpyquie ni le Just, ni zob xiryuꞌ coo idoo, no ulihbu rzacbeeiy me Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","No to mpyquie ni le Crispo ni nu idoo xcargü, bylíladzy me Jesúz ni rtzoo mdad, gydibyno gyre xmiꞌñ me. No zegahc xtahl meññ-nu Corint bylíladzy hor-bieññ yâme mod-bluu Pabl. No byrôbnihs gahc yâme. ");
INSERT INTO zpg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","To guiaal‑e naꞌ Crist günino me Pabl lo mpcaaḻ, ra me lee: ―Bieno dtiidzaꞌ meññ. Di gydziehbyiꞌ, ni di tzudziey. ");
INSERT INTO zpg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Porni naa we nuno lii no ndruhty nehx zaḻ ctzoo lii mbehty. Ciuda-rieꞌ nu xtahl dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Were biaꞌn Pabl Corint leññ diby iz-garuḻ, bluu me meññ-wé yahc xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Per leññ tiémp ni nac Galióṉ xgobernador ṟegioṉ-Acaya, ptzoo meññ-Isṟael diidz par byruu yâme contr Pabl, günahzy yâme leeme, güiyno yâme leeme lo guxtisy. ");
INSERT INTO zpg_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Hor-bydzihñ yâme, ra yâme guxtisy: ―Mpyquie-rieꞌ gaquihly me meññ gzacbeeiy Dioz gydze mód, ba dac mod-ganii leiy. ");
INSERT INTO zpg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Naabz ba sulo Pabl gynii, guzlo gahc günii gobernador, ra me meññ-Isṟael ni zidno yahc Pabl: ―Ñahc behch ni nadz ni xroꞌ o to ni dirquihñ ptzoo mpyquie-rieꞌ la, naa ñapaꞌ de ni ñieññaꞌ laꞌd, meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Per naꞌ bidno laꞌd leeme, gazaꞌd laꞌd de ni rnii me, no de le meññ, no de xleiy laꞌd la, laꞌd gahc lâ güieꞌ xnahc ctzoo laꞌd leeu, porni nehx neu naa ctzon guîlguxtisy lguia zâ nirieꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","No ptzoo gahc gobernador mdad byruu yâme de ru dxie me. ");
INSERT INTO zpg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Were günahzy yâme to meññ-Isṟael ni le Sóstenes ni nu idoo xcargü, güdihñ yâme leeme ñaz-lo guxtisy yahc; per nehx ptzoo Galióṉ mbehty. ");
INSERT INTO zpg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Per Pabl, xtze biaꞌn me Corint. Were ra me meññ-rman ba tza me sto lad, no byruno me Aquil no Priscil, güya yâme to guiedzy ni le Cencrea. No uga byga ihqy me porni pcahbyladzy me lguia behch lo Dioz. No cuaꞌ yâme to barcü, za yâme ṟegioṉ-Siry. ");
INSERT INTO zpg_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ru bydzihñ yâme Éfeso, uga psaꞌn me Aquil no Priscil. Leeme za me xiydoo meññ-Isṟael, bigyuno me leeyahc xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Biuꞌladzy meññ-wé yahc ñaꞌn me stoozy dzé no leeyâme, per di ne me. ");
INSERT INTO zpg_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mazyg ra me leeyâme: ―Rapaꞌ de ni tzan Jerusaléṉ lehdy tzun uga lo lni ni ziaad. Per guibyguiataꞌ gyzac guidtixloꞌn laꞌd, bâḻ Dioz gdee lsenzy. Were güyuꞌ me leññ barcü no byruu me Éfeso. ");
INSERT INTO zpg_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ru bydzihñ me Cesarea güya me Jerusaléṉ, bictixlo me meññ-idoo, no luxu güdedy me za me Antioquía. ");
INSERT INTO zpg_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Lux güyuꞌ me uga doozy dzé, byruu me güya me gydo-bynac lo ṟegioṉ-Galacia no lo ṟegioṉ-Frigia, galuu me gyre xmeññ Crist lehdy di gyrugan yâme. ");
INSERT INTO zpg_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Leññ dze-wé yahc bydzihñ to meññ-Isṟael Éfeso ni le Apol, xguiedzy me le Alejandría. Mpyquie-rieꞌ, modni mos ru me diidz no ulihbu nann me mod-rnii lo Guehtzy ru queꞌ xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Byzeedy me zaꞌgndzi lguia mod-racladzy Crist. No riuꞌladzy me runo meu meññ, no rluu me meññ zaꞌgndzi lguia Crist, per mazyg la, nann me nunzy ni bluu Juaṉ ni pchôbnihs meññ. ");
INSERT INTO zpg_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Were guzlo Apol galuu me meññ leññ xiydoo meññ-Isṟael no nehx rdzie me. Ru bieññ Priscil no Aquil mod-rluu me, güloo yâme leeme diby lad par bluu yâme leeme ma zaꞌgndzi mod-racladzy Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","No ru ba günii Apol tza me lo ṟegioṉ-Acaya, gucno meññ-rman leeme par za me, no pshahl yâme to guehtzy lo xmeññ Crist ni nu yahc uga lehdy gdee yâme ñahz tzu me lahd yâme no gac yâme meññ-tziaawy no leeme. Dze-ba nu me lahd yâme, modni gucno me meññ ni ba bylíladzy yahc xtiidz Dioz; ");
INSERT INTO zpg_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","porni ñaz-lo nyug bluu me ru ziaadu lo Guehtzy ru queꞌ xtiidz Dioz neu: Jesúz, leeme we nac Crist; no meññ-Isṟael ni nehx rlíladzy leeu, di rdzial bia nnii yâme. ");
INSERT INTO zpg_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Lóni nu Apol Corint, Pabl güdedy me ru nu dahñ yahc no biahd me Éfeso. Dze-bydzihñ me Éfeso, bwieꞌ me doozy xmeññ Crist, ");
INSERT INTO zpg_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","no günabdiidz me leeyâme, ra me: ―¿Cuaꞌ laꞌd Spirt-Sant dze-bylíladzy laꞌd xtiidz Dioz la? Ra yâme leeme: ―Ni dgueññ guieññ noꞌ gynii ndruhty bâḻ nu Spirt-Sant. ");
INSERT INTO zpg_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Were ra Pabl leeyâme: ―¿Biaz leeu bylíladzy laꞌd par byrôbnihs laꞌd? Ra yâme leeme: ―Lo xguîlrseedy Juaṉ‑e byrôbnihs noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ra Pabl leeyâme: ―Juaṉ pchôbnihs me meññ ni gayo yahc lo xñahz Dioz no ba psaan ni nahcsy ni nac. Per ra Juaṉ leeyâme gylíladzy yâme sto ni guiaad lux de ni biahd me, no leeme we Jesúz ni nac Crist. ");
INSERT INTO zpg_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ru bieññ yâme mod-ne Pabl, byrôbnihs gahc yâme por le Jesúz ni rtzoo mdad lehdy guieññ xmeññ me leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","No hor-pshob ña Pabl chehsh yâme, bidtzu Spirt-Sant xguîlmbahñ yâme, no guzlo gahc ganii yâme gydze diidz no ganii yâme ni gayisnii Dioz leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Beeiy tzipychop meññ-mpyquie por gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Leññ tzonn mboo ni nu Pabl uga, ria me xiydoo meññ-wé yahc, rigyuno me leeyâme xtiidz Dioz no nehx rdzie me. Byo me xnahc beeiy bieññ yâme zaꞌgndzi no lehdy bylíladzy yâme mod-rluu me lguia mod-rtzoo Dioz mdad. ");
INSERT INTO zpg_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Per lahd yâme ulihbu di ne nlíladzy, aaḻ guzlo ganii yâme gyrehzy ni nahcsy lguia ni le Xñahz Crist ñaz-lo meññ. Niwé bwieꞌ Pabl, were byrusytzu me de leeyâme, no güiyno me xmeññ Crist par bydohp gyre yâme xiryuꞌ to mpyquie ni le Tiranno ru rdohp meññ par gyzeedy. Wé bluu me leeyâme gyre dzé. ");
INSERT INTO zpg_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Leññ chohp ihz bluu me meññ xtiidz Dioz uga, no por leeu gyre meññ ni nu lo ṟegioṉ-Asia bieññ xtiidz Jesúz ni rtzoo mdad. No meññ-rieꞌ ni bieññ, leeyâme we meññ-Isṟael no zegahc zrieñ meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","No gucno Dioz Pabl, ptzoo me xroꞌ milagür. ");
INSERT INTO zpg_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nunzy ni riyno meññ bay o behch lahr ni byleꞌ xcuerp me, no rshob yâmeu chehsh meññ-gayac-ure, ba gahc biaḻ yâme, xtâ no meññ-rahp mbenahcsy riaḻ yâme mod-wé. ");
INSERT INTO zpg_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Per ganzeꞌ zrieñ meññ-Isṟael uga rsiaḻ yâme meññ ni rahp mbenahcsy; gucladzy yâme nquihñ yâme le Jesucrist zegahc. Ra yâme mbenahcsy ni nu meññ: ―Gayapyaꞌ laꞌd, lâ gyruu de meññ-nu laꞌd lee por le Jesucrist, ni ru Pabl xtiidz. ");
INSERT INTO zpg_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nirieꞌ rtzoo gahdzy xiiñ to meññ-Isṟael ni le Esceva. Mpyquie-rieꞌ nac me xjefy gyre bahl. ");
INSERT INTO zpg_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Per ra mbenahcsy leeyâme: ―Naa rzacloꞌn Jesúz, no nannaꞌ dxu we Pabl. Per laꞌd, ¿dxu nac laꞌd? ");
INSERT INTO zpg_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Lo hor-wé gahc byruu mpyquie-rahp mbenahcsy contr leeyâme, güdihñ leeyâme, ptzuné leeyâme lé byruu rid leeyâme, no güdiix shab yâme lé gaꞌy lady yâme za yâme byxuunn yâme de xiryuꞌ mpyquie-caḻ. ");
INSERT INTO zpg_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Gyre meññ ni nu Éfeso gunn yahc nirieꞌ, no meññ-Isṟael no zegahc meññ-nehx meññ-Isṟael gunn leeu. Modni bydzie gyre yâme, no güluguia yâme le Jesúz ni rtzoo mdad. ");
INSERT INTO zpg_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","No zegahc biahd xtahl meññ ni ba bylíladzy yahc xtiidz Dioz, bdee yâme diidz gyre ni nahcsy ni ptzoo yâme. ");
INSERT INTO zpg_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","No zegahc biahd xtahl meññ ni byzeedy yahc guîlbrujü, bidno xlibr yâme no pquee yâme gue leeu ñaz-lo gyre meññ. No ru güloo yâme cuent beeiy bla pysahc gyre libr ni cueꞌ gue, gunn yâme pysahc gyreu beeiy cincuent mily medy-plat. ");
INSERT INTO zpg_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","No mod-wé gayann meññ xtiidz Dioz, no güyuꞌu zaꞌgndzi leññ xguîlmbahñ xtahl meññ. ");
INSERT INTO zpg_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bylux gyre nirieꞌ, ne Pabl ba tza me Macedony, no zegahc lo ṟegioṉ-Acaya. No luxu guibyguiat me Jerusaléṉ. No ne me rahp me de ni tza me Ṟom ru ba bylux güya me Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Luxu pshahl me chohp meññ-racno leeme, lee we Timoteu no Erasto, za yâme ṟegioṉ-Macedony. Leeme biaꞌn me lo ṟegioṉ-Asia stoozy dzé. ");
INSERT INTO zpg_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Leññ gahc dze-wé modni gülesyno xtahl meññ-Éfeso lguia ni le Xñahz Crist. ");
INSERT INTO zpg_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nirieꞌ guhcu porni to mpyquie ni le Demetyr ni rtzoo dziiñ de plater, rzaa me figur-yaañ ni nac beeiy xiydoo xdioz meññ-Éfeso ni le Dian. No modni xroꞌ medy rdeedyu leeme no zrieñ meññ-rtzono me dziiñ. ");
INSERT INTO zpg_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","To dzé ptohp me gyre xmeññ me no zrieñ meññ-rtzoo yahc zâ dziñ-wé, ra me leeyahc: ―Betzy, laꞌd nann laꞌd de dziiñ ni rtzoo nó, leeu rdeeu nó xroꞌ medy; ");
INSERT INTO zpg_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","per ngâstoo gawieꞌ laꞌd no gayieññ laꞌd bia gyre gayahc lguia ni ganii Pabl, ne me: “Ni rzaa meññ la, dac‑e dioz leeu.” No ba xtahl meññ galíladzy mod-rluu me, no dac nunzy meññ-rieꞌzy, zegahcu gyre meññ-nu yahc gydo lo ṟegioṉ-Asia. ");
INSERT INTO zpg_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","No ndzieeby gynihty dtziiñ nó. No dac nunzy niwé, xtâ no xiydoo tdioz nó Dian güieꞌ laꞌd bâḻ dac ziaaḻladzy meññ leeu no gynihty ni rsahcu; no gyre meññ-nu lo ṟegion-Asia no zrieñ meññ-nu yahc lo guiedzylie, ba di gzacbeeiy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Hor-bieññ yâme mod-günii Demetyr, modni bydziaꞌdzy yâme, no guzlo rquee yâme riedz, ne yâme: ―¡Dac‑e cuentz‑e Dian, xdioz meññ-Éfeso! ");
INSERT INTO zpg_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","No guzlo gahc gabiiñ gyre meññ leññ ciuda-wé. No bigynahzy yâme gyrop meññ-Macedony ni le Gay no Aristarcü ni zidno Pabl lee. Güzûbyñu yâme gyrop meññ-rieꞌ, güiyno yâme lee to ru rtzoo yâme junt. ");
INSERT INTO zpg_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Gucladzy Pabl ña me uga nigynino me meññ-guiedzy, per di ndee xmeññ Crist ñahz. ");
INSERT INTO zpg_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","No zegahc pshahl lahd guxtisy ni nu Asia diidz lo Pabl, ni xmígü me lee, ra yâme leeme di tza me ru gadohp meññ-wé yahc. ");
INSERT INTO zpg_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lahd yâme rquee riedz ganii to cos, no zrieñ yâme gydze ni ganii, no gyre yâme nyetz, no zrieñ yâme nehx nann bia nacu bydohp yâme uga. ");
INSERT INTO zpg_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Were güle meññ-Isṟael to mpyquie lahd yâme ni le Lejandr, lé rchaꞌby yâme leeme bistzihñ yâme leeme ru beeiy güieꞌ gyre meññ leeme par gynino me meññ-wé yahc bia nacu gatzoo yâme ze. Were ptzoo me señ meññ-guiedzy par ñudzie yâme lehdy gynii me. ");
INSERT INTO zpg_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Per hor-gunn yâme meññ-Isṟael leeme, aaḻ guzlo gyre yâme pquee riedz, ne yâme: ―¡Dac‑e cuentz‑e Dian, xdioz meññ-Éfeso! Pquee yâme riedz modé beeiy leññ chohp hór. ");
INSERT INTO zpg_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Were byruu secretary xchieñ Éfeso, günino me meññ-wé yahc lehdy güyudzie yâme, no ra me: ―Laꞌd ni nac meññ-Éfeso, gyre meññ nann de ni laꞌd‑e ni gayahp xiydoo Dian no xfigur me ni byruu gybaa no biahb lo guiedzylie. ");
INSERT INTO zpg_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ndruhty nehx beeiy nnii nehx uliu mod-gayapyaꞌ laꞌd. No leewe, lâ tzudzie, no di ctzoo laꞌd mbehty sinn di guisshuunn xguîlriehñ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gyrop mpyquie ni bidno laꞌd lee neꞌ dgueññ ctzoo yâme xiydoo laꞌd behch, ni dgueññ gynii yâme mbehty didz-nahcsy contr xdioz laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Bâḻ Demetyr no meññ-rtzono me dziiñ gadeḻyno yâme dxuhch la, par niwé we nu guxtisy; beeiy tza yâme lo, no wé to to yâme beeiy gynii bia racladzy. ");
INSERT INTO zpg_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","No bâḻ rahp laꞌd zrieñ behch ni gynii laꞌd la, lâ csaꞌnu hor-gac diaa junt xchieñ gyre meññ-guiedzy lehdy gac guîlguxtisy lguiau. ");
INSERT INTO zpg_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Porni ndzieeby‑e csiahb meññ-Ṟom doḻ dchehsh nó por gyre ṟid ni gayahc dzêrieꞌ, porni nehx nu bia nnii nó bâḻ leeyâme nshalcaꞌ yâme nó par gann yâme bia nacu ni gabiiñ meññ neꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","No bylux günii me mod-rieꞌ, ra me meññ-guiedzy gybiꞌ yâme. ");
INSERT INTO zpg_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Bylux biandzie meññ de ni gübiiñ yâme, pshalcaꞌ Pabl gyre xmeññ Crist lehdy güluꞌ me xguîlriehñ yâme no güdiehdzy me leeyâme porni ba gyruu me uga. Byluxu, byruu me za me Macedony. ");
INSERT INTO zpg_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Gyre guiedzy ni nu gydo-bynac ñaz-wé güya me bieno me diidz meññ, no rxilyno yâme ni runo me leeyâme. No luxu güya me sto ru le Grecia. ");
INSERT INTO zpg_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tzonn mboo güyuꞌ me uga. No ru ba nu me par tza me lo ṟegioṉ-Siry leññ barcü, were bieññ me diidz ba nu meññ-Isṟael de ni gynahzy leeme. Ni ptzohdy me, beeiydí günahzy me sto ñahz par güdedy me Macedony gyzac. ");
INSERT INTO zpg_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Zidno me to meññ-Berea ni le Sópater; no zegahc meññ-Tesalónyc yahc ni le Aristarcü no Segund; no Gay ni nac meññ-Derbe, no Timoteu; no Tíquico no Trófimo ni nac yahc meññ-Asia. ");
INSERT INTO zpg_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Rman-rieꞌ yahc guznier yâme bigliahz yâme noꞌ sto guiedzy ni le Troas. ");
INSERT INTO zpg_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","No noꞌ, güdedyr lni ni rahgü meññ paṉ ni nehx rahp levadur, were byruu noꞌ Filipos. Gaay dzé güyuꞌ noꞌ leññ barcü, were bydzihñ noꞌ Troas, wé bydzial noꞌ leeyâme. No uga biaꞌn noꞌ zgahdzy dzé. ");
INSERT INTO zpg_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Primer xdzé seman bydohp xmeññ Crist guiaal par güdiiz yâme paṉ ni güdahgü yâme, no bluu Pabl leeyâme. No gumm ne me rahp me de ni tza me sto lad ni gyre guiaal la, xtze bie me diidz xtâ beeiy glaꞌy guiaal. ");
INSERT INTO zpg_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","To leññ cuart guia diaa güyuꞌ gyre noꞌ, no naḻ xtahl lampr leññ cuart-wé ni nu gue lee. ");
INSERT INTO zpg_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Dlahd noꞌ dxie to ñobyxtohby ruꞌ ventan, le Euticü. Pabl naꞌ, xtze bluu me, leewe günahzy mpcaaḻ Euticü, gutgahsy me, tohzydzi byzaꞌn me lo yu, byruu me xtâ lo diaa ni bionn pis guia. No gülesy yâme leeme, ba guhty me. ");
INSERT INTO zpg_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Were biaht Pabl bisshiby coo me no güdiehdzy leeme, no ra me: ―Di gydzie laꞌd. ¡Leeme mbahñ! ");
INSERT INTO zpg_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Luxu cueꞌ Pabl guia sto, güdiiz me paṉ ni güdahgü yâme. Byluxz güdahgü yâme, gyzac guzlo bluu me leeyâme sto xtâ glo ba zidtzu byniꞌ; were byruu me za me. ");
INSERT INTO zpg_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","No Euticü, ni biahb ruꞌ ventan, zigyno yâme leeme ruꞌ yuꞌ, no rxihly yâme porni mbahñ me. ");
INSERT INTO zpg_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pabl za me gazeꞌ me, porni mod-wé biuꞌladzy me. Per noꞌ zo noꞌ leññ barcü ma nier noꞌ par bigliaaz noꞌ leeme to guiedzy ni le Asóṉ. ");
INSERT INTO zpg_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","No uga bydzial me noꞌ. De wé güyuꞌ me leññ barcü no noꞌ par güyo noꞌ sto guiedzy ni le Mitilene. ");
INSERT INTO zpg_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Güyuꞌ noꞌ leññ barcü, no ni byre guiaal güdeedy noꞌ xderech lyu ni le Quío ni nu nisdoo guingybi. No sto dzé mazy güyuꞌ noꞌ leññ barcü, no bydzihñ noꞌ sto lyu ni le Samos ni nu nisdoo guingybi no ru rbiahz barcü. Bisdadzy noꞌ sto guiedzy ni le Trogilio, no ni byre guiaal bydzihñ noꞌ sto guiedzy ni le Mileto. ");
INSERT INTO zpg_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","No güdedyñahz gahc noꞌ, ba di ño noꞌ Éfeso porni nehx gucladzy Pabl ñaꞌn me Asia. Riob me gydzihñ me Jerusaléṉ, bâḻ beeiyu, dze-sulor lni-Pentecostéz. ");
INSERT INTO zpg_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Dze-nu noꞌ Mileto, pshalcaꞌ Pabl rman yahc ni rsahc ni rnii ni nu Éfeso. ");
INSERT INTO zpg_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","No hor-bydzihñ yâme, ra Pabl leeyâme: ―Laꞌd nann laꞌd bia mód ptzon lahd laꞌd glohdy dze-bydzihñaꞌ de lo ṟegioṉ-Asia. ");
INSERT INTO zpg_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Gyre leññ tiemp-güyun lahd laꞌd ptzon xtziiñ Dioz dac par cuguia meññ naa, mazyg lehdy gyo yâme Dioz. No xtahl vuelt lé runaꞌ hor-bwien mod-rtzoo meññ-rieꞌ no güdeedyaꞌ xtahl ni nadz porni meññ-Isṟael gucladzy ntzoo nsahc yâme naa. ");
INSERT INTO zpg_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","No di ncatzyaꞌ mbehty ni beeiy gacno laꞌd, mazyg bienon laꞌd xtiidz Dioz. Naa blun laꞌd ñaz-lo nyug no güyan xtâ xiryuꞌ laꞌd par blun laꞌd leeu. ");
INSERT INTO zpg_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Naa gutzyaꞌ meññ-Isṟael, no zegahcu meññ-nehx meññ-Isṟael, csaan yâme ni nahcsy ni nac yâme lehdy csiaaḻladzy Dioz xguîlquie yâme, no gylíladzy yâme Jesucrist ni rtzoo mdad nó. ");
INSERT INTO zpg_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","No naꞌ rapaꞌ de ni tzan Jerusaléṉ mod-ne Spirt-Sant, nîcze nehx nannaꞌ bia gyre gácaꞌ uga. ");
INSERT INTO zpg_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Mazyg ni nannaꞌ la, gyre guiedzy ru rian, gaya Spirt-Sant naa de ni tzun lidzyguiib no tedyaꞌ zrieñ ni nadz. ");
INSERT INTO zpg_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Per naa mbehty nehx rgu diqyaꞌ lee, per ni dguîlmbahñaꞌ nehx rsahc par naa, lehdy no guîlrxihly guistibylgaan ni gatzon no lehdy luxaꞌ dziiñ ni ba ne Jesúz ni rtzoo mdad, lee we gunon meññ xtiidz me de ni rguꞌ Dioz xlaꞌy me meññ. ");
INSERT INTO zpg_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’No ngâstoo nannaꞌ ndruhty de laꞌd, ni güyan lahd no bienon lee diidz de ni rtzoo Dioz mdad, ba nehx ziuꞌ dzé güieꞌ laꞌd naa sto. ");
INSERT INTO zpg_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","No leewe, racdadzyaꞌ gapyaꞌ laꞌd, bâḻ dxuhch gaty no nehx rlíladzy xtiidz Dioz par ctzoo mod-neu la, ba dac‑e naa rap doḻ. ");
INSERT INTO zpg_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nehx nu mbehty ni dgueññ gapyaꞌ laꞌd de gyre ni ne Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Naꞌ la, lâ güieꞌ por laꞌd gahc, no por gyre meññ-idoo. Porni Spirt-Sant‑e güle laꞌd par gac laꞌd meññ-tzu idoo xcargü lehdy gap laꞌd no güieꞌ laꞌd xmeññ Crist, ni güxii me lee por xrieñ gahcme lo cruzy. ");
INSERT INTO zpg_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Porni nannaꞌ, dze-ba byruun ru nu laꞌd, siahd meññ-mbuxter lahd laꞌd ni zidguiahc beeiy mbeedzy, zisquiee yâme laꞌd gyrehzy par gyraꞌdz laꞌd; no nehx zioob yâme laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","No lahd gahc laꞌd zruu meññ-gluu ni nehx uli no znii gyrehzy ni nahcsy par yquihly yâme xmeññ Crist yquee coo yâme. ");
INSERT INTO zpg_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","¡Gax lâ gann! Lâ guitsêlou laꞌd leññ tzonn ihz, dzé no guiaal nehx psandzien de ni gülun xguîlriehñ to to laꞌd lé binaꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Naꞌ ngâstoo, rman, ba ladzyña Dioz‑e csanaꞌ laꞌd, zegahcu lo xtiidz me ni ganii ndzi me meññ. Xtiidz me zacnou laꞌd ma gylíladzy laꞌd leeme. No Dioz zdee me laꞌd ni ba ne me ycaꞌ gyre meññ ni nac nunzy par leeme. ");
INSERT INTO zpg_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nehx byzîbydadzyaꞌ xmedy meññ, ni shab ndruhty. ");
INSERT INTO zpg_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","No nann laꞌd naa ptzon dziiñ lehdy güdapaꞌ ni güdedydzéꞌn tohzy no meññ-güyunon lee. ");
INSERT INTO zpg_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nann laꞌd mod-wé we blun laꞌd, ctzoo nó dziiñ par gacno nó meññ-nehx rahp ni tedydzé. No guitsêlou nó ni günii Jesúz ru ne me: “Mahbu we dxu ñahc beeiy meññ ni riscady que meññ ni rady.” ");
INSERT INTO zpg_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Bylux günii Pabl mod-wé, bisshiby me no meññ-bieno me diidz lee, no günab me lo Dioz tohzy no leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Byluxu, gyre yâme ruun, no güdiehdzy yâme Pabl no gudzy yâme coo ruꞌ me. ");
INSERT INTO zpg_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","No güyuꞌ yâme trixd, porni ra Pabl leeyâme ba nehx ziuꞌ dzé güieꞌ yâme leeme sto. No bicsaꞌn yâme leeme ru cuaꞌ me barcü par za me. ");
INSERT INTO zpg_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ru ba psaꞌn noꞌ leeyâme, güyuꞌ noꞌ leññ barcü no güyo noꞌ to lyu ni le Cos ni nu nisdoo guingybi. Ni byre guiaal, güyo noꞌ sto lyu ni le Ṟodas ni nu nisdoo guingybi, no luxu byruu noꞌ uga güyo noꞌ sto ru le Pátara. ");
INSERT INTO zpg_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","No uga bydzial noꞌ to barcü ni tza to ṟegióṉ ni le Fenicia. Güyuꞌ noꞌ leññu, no zo noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Hor-zo noꞌ lo nisdoo, bwieꞌ noꞌ sto lyu ni le Chipre ni nu nisdoo guingybi; no güdedy noꞌ ñaz-mbenihs de ru riaꞌnu. No güyo noꞌ ñaz-lo ṟegioṉ-Siry. Bydzihñ noꞌ to ciuda ni le Tir ru rbiahz barcü, no wé byruu noꞌ leññ barcü, porni lgar-wé psaꞌn barcü yuu ni zidnou. ");
INSERT INTO zpg_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Leññ guiedzy-rieꞌ bydzial noꞌ xmeññ Crist yahc. Biaꞌn noꞌ ru nu yâme leññ gahdzy dzé. Meññ-rieꞌ yahc bisnii xiSpirt Dioz leeyâme, ra yâme Pabl di tza me Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Per ru bydo noꞌ gahdzy dzé, were byruu noꞌ. Gyre meññ-wé yahc no tziahl yâme no ximbiux yâme, bicsuñahz yâme noꞌ, byruu noꞌ leññ guiedzy no bydzihñ noꞌ coo nisdoo, bisshiby noꞌ lo yux par günino noꞌ Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Bylux güdiehdzy dsaꞌ noꞌ, güyuꞌ noꞌ leññ barcü. Leeyâme zia xiryuꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Byruu noꞌ Tir, bydzihñ noꞌ Tolemaida ru bictixlo noꞌ zrieñ meññ-rman, no biaꞌn noꞌ ru nu yâme diby dzé. ");
INSERT INTO zpg_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ni byre guiaal, byruu noꞌu güyo noꞌ Cesarea. Uga bydzihñ noꞌ to li meññ-rman ni le Felipy ni tirgahc rigyuno meññ xtiidz Crist, no leeme rahc cuent lee lahd gahdzy meññ-rman ni rahp cargü de ni racno apóstl yahc. ");
INSERT INTO zpg_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Felipy naꞌ, rahp tahp xiiñ me ngünaxtohby lee. No risnii Spirt-Sant gydap yâme, runo yâme meññ xtiidz Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Güdahpu doozy dzé de ni nu noꞌ uga, bydzihñ to profet ni byruu lo ṟegioṉ-Judea, le me Agabo. ");
INSERT INTO zpg_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ru biahd me bidtixlo me noꞌ, cuaꞌ me xcinturóṉ Pabl, no blihby meu ña me no nieꞌ me, no ne me: ―Mod-rieꞌ ne Spirt-Sant: “Glihby meññ-Isṟael xbixwaan cinturoṉ-rieꞌ ru tza me Jerusaléṉ, no cteedy yâme leeme lo ña meññ-nehx meññ-Isṟael.” ");
INSERT INTO zpg_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Hor-bieññ noꞌ nirieꞌ no zrieñ meññ-nu uga, ra noꞌ Pabl di tza me Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Were ra me noꞌ: ―¿Bia nacu gayuun laꞌd no rguꞌ laꞌd naa trixd? Naa nun puexd dac nunzy par gylihbyaꞌ, mazyg zegahc par gatyaꞌ Jerusaléṉ porni nacaꞌ xmeññ Jesúz ni rtzoo mdad. ");
INSERT INTO zpg_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bwieꞌ noꞌ di ne me ntzoo mod-ra noꞌ leeme, were ne noꞌ: ―Gac ni racladzy Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Luxu, güyuꞌ noꞌ puexd no zo noꞌ Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","No lahd xmeññ Crist ni byruu Cesarea, güya yahc Jerusaléṉ no noꞌ. Hor-bydzihñ noꞌ, güiyno yâme noꞌ xiryuꞌ to mpyquie ni le Mnasóṉ, meññ-Chipre leeme, no ba xtze nac me xmeññ Crist. Bdee xiryuꞌ me, güyuꞌ noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Modni byxilyno meññ-rman yahc noꞌ ru bydzihñ noꞌ Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ni byre guiaal güiyno Pabl noꞌ bictixlo noꞌ Jacob. Bydzihñ noꞌ, dxie gyre rman yahc ni rsahc ni rnii. ");
INSERT INTO zpg_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bylux günii Pabl diux leeyâme, were bieno me leeyâme gyre mod-gucno Dioz leeme ru güya me ru nu meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Hor-bieññ yâme mod-ne Pabl, bdee yâme xquix Dioz, no luxu ra yâme leeme: ―Rman, lii nanniꞌ mily yahc meññ-Isṟael ba bylíladzy xtiidz Dioz, per glo naꞌ ne yâme racladzyu gac gyre ni ne xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","No ba bieññ yâme de ni gyre meññ-Isṟael ni nu yahc lahd meññ-nehx meññ-Isṟael, galuuy leeyâme di ctzoo yâme ni ne xleiy Moiséz, no rahbyiꞌ leeyâme di cu yâme señ lady ximdoñooby yâme, no di ctzoo yâme mod-ne zrieñ costumbr ni zidno yâme glo ba xtze. ");
INSERT INTO zpg_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Xnahc‑e naꞌ gacu? Hor-guieññ yâme diidz ba nuy neꞌ, zdohp gahc gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Beeiydí ptzoo mod-ga noꞌ lii: Neꞌ dxie tahp mpyquie dlahd nó ni ba pcahbyladzy lguia behch lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Güiyno leeyâme idoró, no gyre laꞌd la, lâ ctzoo ni ne leiy lehdy guieññ nehx nu guîlquie chehsh laꞌd. No lii, güdix sahc ni iga ihqy yâme, no mod-wé gann yâme nehx uliu ni ganii yâme contr lii. Ru ba ptzooy ze, were gann meññ zegahc‑e rtzooy ni ne xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Per meññ-nehx meññ-Isṟael ni ba bylíladzy yahc xtiidz Dioz, ba bzaa noꞌ to guehtzy pshahl noꞌ lo yâme, gaya noꞌ leeyâme di ctzoo yâme gyre mod-wé. Mazyg di gahgü yâme maꞌ ni rgaꞌdy meññ par to gun lo cuentz figur, ni di gahgü yâme rieñ, ni maꞌ ni retycawy, no di seno yâme ni nehx tziahl yâme lee. ");
INSERT INTO zpg_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","No ptzoo Pabl mod-ra yâme leeme, güiyno me gydap mpyquie-rieꞌ yahc ni byre guiaal, par ptzoo yâme ni ne leiy ctzoo meññ lehdy guieññ ba nyar yâme. Luxu güyuꞌ me leññ idoró, bigyne me bahl zibla dzé riaadz lehdy gyluhx ni gatzoo yâme lehdy gann yâme buc tziyno to to yâme xgun. ");
INSERT INTO zpg_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Naabz ba dzigydo yâme gahdzy dzé, bwieꞌ chohp tzonn meññ-Isṟael nu Pabl leññ idoró, meññ-rieꞌ yahc byruu yâme lo ṟegion-Asia. Guzlo gahc pquihly yâme gyre meññ-nu uga lehdy gübiiñ yâme, no günahzy gahc yâme Pabl, ");
INSERT INTO zpg_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","no guzlo gaquee yâme riedz, ne yâme: ―¡Meññ-Isṟael, lâ gacno noꞌ gynahzy nó mpyquie-rieꞌ! Leeme we ni ganzeꞌ byzaꞌzy galuu me meññ, ne me nehx rtzoo meññ-Isṟael ni nac xñahzû, no ra me meññ di ctzoo yâme ni ne xleiy Moiséz, no rruu me contr diydoró nó. No nehx nunzy niriehzy, ba bidno me meññ-nehx meññ-Isṟael xtâ leññ diydoo nó ni nda, ba ptzoo me leeu beeiy cuentz lgar. ");
INSERT INTO zpg_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Günii yâme ze porni ba bwieꞌ yâme gazeꞌ Pabl leññ ciuda no to meññ-Éfeso, ni le Trófimo, no nlâdzy yâme ba bidno me lee leññ idoró. ");
INSERT INTO zpg_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","No leewe, hor-bieññ meññ-guiedzy mod-günii yâme we naꞌ, bydohp gahc yâme. Bydzihñ yâme günahzy yâme Pabl, güzûbyñu yâme leeme güloo yâme leeme leññ idoró, no ptahgü gahc yâme gyre ruꞌ xpuertu. ");
INSERT INTO zpg_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ba nu yâme de ni igaꞌdy yâme leeme, tohzy gunn xcomandant batallóṉ gabiiñ gyre meññ ni nu Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Were ptohp gahc me soldad yahc no zrieñ capitáṉ, no za yâme ru gayahc ṟid-rieꞌ. Hor-bwieꞌ yâme ziaad comandant no xsoldad, were psandzie yâme de ni gaguihñ yâme Pabl. ");
INSERT INTO zpg_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","No güyuꞌ gahc comandant günahzy me Pabl no ptzoo me mdad blihby yâme leeme chohp caden. Luxu, günabdiidz me dxu nac Pabl no bia ptzoo me. ");
INSERT INTO zpg_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Per guzlo yâme gaquee yâme riedz, lahd yâme ganii to cos no zrieñ yâme gydze ni ganii. Gatzunyetz yâme, ba ni di rieññ comandant bia ganii yâme, were ptzoo me mdad güiyno soldad Pabl cuartel. ");
INSERT INTO zpg_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ru bydzihñ yâme ruꞌ scaler xchieñ cuartel, soldad yahc güiyno yâme Pabl lo ña yâme par di nguihñ meññ-guiedzy leeme, porni ba ma gadziaꞌdzy yâme. ");
INSERT INTO zpg_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Gyre yâme náḻ gaquee riedz, ne: ―¡Gaty me! ");
INSERT INTO zpg_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Hor-ba dziglu yâme Pabl leññ cuartel, günino me xcomandant batallóṉ, ra me lee: ―¿Beeiy ndeedyiꞌ ñahz naa la, ñunon lii chohp tzonn diidz? Were ra comandant leeme: ―¿Beeiyz rniiy didz-griegü la? ");
INSERT INTO zpg_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Dâs‑e lii to meññ-Egipt ni rahp doozy tiémp ptohp xtahl meññ par byruu yahc contr gobiern, no güiyno me tahp mily meññ-rgaꞌdy lo yu-bihdzy la? ");
INSERT INTO zpg_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ra Pabl leeme: ―Meññ-Isṟael‑e naa. To ciuda ni le Tars, wé we guhlaꞌ, no lee we to ciuda ni rtzoo mdad xtahl guiedzy ni nu lo ṟegioṉ-Cilicy. Per rnabaꞌ ndeedyiꞌ ñahz nninon meññ-guiedzy. ");
INSERT INTO zpg_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","“Yo” ne comandant, bdee ñahz leeme. Were guzli me lo scaler, no luxu ptzoo me señ meññ-guiedzy no ña me par tzudzie yâme. Ru ba güyudzie yâme, were guzlo günino me leeyâme no didz-hebreu, ra me leeyâme: ");
INSERT INTO zpg_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","―Betzy no mînguhl yahc, lâ yquee gydiag laꞌd, dzigyunon laꞌd ni uli de gyre ni ptzon. ");
INSERT INTO zpg_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hor-bieññ yâme günii me didz-hebreu zaꞌgndzi, ma güyudzie gyre yâme, no ra Pabl leeyâme: ");
INSERT INTO zpg_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","―Meññ-Isṟael‑e naa. No guhlaꞌ to ciuda ni le Tars ni nu lo ṟegioṉ-Cilicy. Per neꞌ we byniꞌzyaꞌ, Jerusaléṉ. Muextr ni bluu naa le Gamaliel. Leeme bluu naa gyre ni ne xleiy difamily yahc nó ni güyuꞌ ba xtze, no naa ryobyaꞌ mód ctzon ni ne Dioz, scâsy mod-rtzoo gahc laꞌd ni naꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Naa tzcaḻ bgultipaꞌ meññ ni ba nu yahc lo ni le Xñahz Crist, ren gaty yâme. Rian rigynaazyaꞌ leeyâme, rgun leeyâme lidzyguiib nyug mpyquie no ngünaa. ");
INSERT INTO zpg_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Xjefy gyre bahl no gyre mînguhl yahc ni nac guxtisy, beeiy gdee yâme diidz ni uli we ganin, no leegahc yâme bdee guetzy-güiynon lo xjefy meññ-Isṟael ni nu ciuda-Damascü par bdee yâme ñahz gynaazyaꞌ xmeññ Crist ni güyuꞌ uga no nidnon leeyâme neꞌ Jerusaléṉ, lehdy ncaꞌ xguîlné yâme. ");
INSERT INTO zpg_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Per naabz gadzihñaꞌ gahsh gá Damascü, beeiy ribygue, tohzydzi bydahl to byni-ro dguingybin ni byruu gybaa; ");
INSERT INTO zpg_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","lé biahbaꞌ lo yu no bieññaꞌ to riedz, ra naa: “Saul, Saul, ¿bia nacu gagultihpiꞌ naa?” ");
INSERT INTO zpg_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Were günin: “¿Dxu lii, Señor?” No günii riedz-caḻ sto, ra naa: “Naa we Jesúz ni nac meññ-Nasaret, ni gagultihpiꞌ lee.” ");
INSERT INTO zpg_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Gyre meññ ni zidnon lee, bwieꞌ yâme byni-caḻ no modni bydzie yâme. Per riedz ni günino naa, nehx bieññ yâme. ");
INSERT INTO zpg_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Were ren leeme: “Señor, ¿biaz naꞌ neꞌy ctzon?” Were ra me naa: “Biahsiꞌ no güya Damascü ru zaꞌy. Uga ga yâme lii bia gyre nu par ctzooy.” ");
INSERT INTO zpg_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Luxu zo noꞌ Damascü. Per ba dmeññ yahcaꞌ nnaazy dñan, porni gucngaḻ dloꞌn hor-bwien byniro-caḻ. ");
INSERT INTO zpg_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Uga nu to mpyquie le Ananíaz ni rzacbeeiy Dioz no rtzoo gyre ni ne xleiy Moiséz. Gyre meññ-Isṟael ni nu yahc lgar-wé ne yâme mpyquie-tziaawy‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","No biahd me ru nun, ra me naa: “Rman-Saul, ba güieꞌy sto.” No byxal gahc dloꞌn no bwien leeme. ");
INSERT INTO zpg_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Luxu ra me naa: “XDioz difamily nó ni güyuꞌ yahc ba xtze, leeme güle lii lehdy ganniꞌ bia riuꞌladzy me ctzooy, no lehdy güieꞌy Xiiñ me ni rtzoo ni nac xñahzû no lehdy guieññiꞌ xriedz xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","No lii gdee diidz de xiiñ me lehdy gann gyre meññ ni bwieꞌy no ni bieññiꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Per naꞌ, biahsiꞌ, di gyleeriꞌ. Güya bigyrôbnihs, no günab lo Señor guiar xguîlquiey.” ");
INSERT INTO zpg_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Ru gubyguiataꞌ Jerusaléṉ sto, güyan idoró to dzé bignabaꞌ lo Dioz. No hor-wé, tohzydzi guhcaꞌ beeiy ni ganii xcaaḻ. ");
INSERT INTO zpg_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Bwien Señor gaya me naa: “Byruu laaḻ de Jerusaléṉ, ba di gyleeriꞌyu mazy. Meññ-rieꞌ yahc nehx zlíladzy yâme dtiidzaꞌ ni gunoy leeyâme.” ");
INSERT INTO zpg_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Were ren leeme: “Señor, leeyâme nann yâme rian byzaꞌzy rigynaazyaꞌ xmeññiꞌ xtâ leññ idoo. Riynon leeyâme lidzyguiib no rguihñaꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","No dzé ni biꞌdy yâme to xmeññiꞌ ni le Stebn ni runo meññ xtiidziꞌ, noc naa bwienu mos igaꞌdy yâme leeme, no xtâ güdapaꞌ shab meññ ni pshadguie leeme.” ");
INSERT INTO zpg_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Per ra Señor naa: “Güya, porni ziht diaa we cshaalaꞌ lii ru nu meññ-nehx meññ-Isṟael.” ");
INSERT INTO zpg_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Xtâ wéhdy bieññ meññ-guiedzy ni günii Pabl. Luxu guzlo pquee yâme riedz, ne yâme: ―¡Gaty me! ¡Nehx nu par bia gylaa me! ");
INSERT INTO zpg_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Gaquee yâme riedz lé rbihby shab yâme lo mbeꞌ no rlee yâme yudé guia. ");
INSERT INTO zpg_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Niwé bwieꞌ comandant, ptzoo me mdad güyuꞌ Pabl leññ cuartel, no ptzoo me mdad iguihñ yâme leeme lehdy gdee me diidz bia nacu zehdy gaquee meññ riedz contr leeme. ");
INSERT INTO zpg_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Hor-ba nliiby me par iguihñ yâme leeme, were ra me capitáṉ: ―¿Xñahzu la, iguihñ laꞌd to meññ-Ṟom sinn di ñahc nier guîlguxtisy? ");
INSERT INTO zpg_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nirieꞌ bieññ capitáṉ, bigyne me comandant, ra me lee: ―¿Nanniꞌ bia we gatzooy la? Mpyquie-rieꞌ ni neꞌy gydihñ, meññ-Ṟom‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Were güya comandant ru nliiby Pabl, ra me lee: ―¿Ulizu meññ-Ṟom lii? Ra Pabl leeme: ―¡Uliu! ");
INSERT INTO zpg_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Were ra comandant leeme: ―Naa xroꞌ medy güdixaꞌ lo gobiern lehdy bdee yâme ñahz guhcaꞌ meññ-Ṟom. Ra Pabl leeme: ―Per naa nácaꞌnu xtâ dze-guhlaꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nirieꞌ bieññ meññ-zu ba dzictihñ leeme, byrusytzu gahc yâme de leeme; xtâ no comandant, bydzie hor-gunn me meññ-Ṟom‑e Pabl, porni ptzoo me mdad bylihby Pabl no caden. ");
INSERT INTO zpg_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ni byre guiaal, were ptzoo comandant mdad pshadzy yâme Pabl no pshalcaꞌ me xjefy yahc bahl no gyre meññ-nac yahc guxtisy Jerusaléṉ, porni riuꞌladzy me gann me bia nacu garuu meññ-Isṟael contr Pabl. Hor-ba nu gyre yâme we naꞌ, bidno me Pabl no bzu me lee lo gyre meññ-wé yahc. ");
INSERT INTO zpg_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Were bwiedzie Pabl lo meññ-nac yahc guxtisy, no ra me leeyâme: ―Betzy, xtâ ngâstoo rapaꞌ to guîlrieñ-mos lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Were günii Ananíaz ni nac xjefy gyre bahl, ra me meññ-zu yahc gahsh ru zu Pabl: ―Lâ cap guidruꞌ me. ");
INSERT INTO zpg_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Were ra Pabl leeme: ―¡Dioz iguquixu lii, ni ne meññ-tziaawy lee nîcze nehx uliu! ¿Dâs‑e dxiey wé lehdy ctzooy guîlguxtisy dilguian mod-ne leiy la? Per naꞌ, rruuy chehsh leiy no mod-gatzooy mdad iguihñ xmeññiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Meññ-zu yahc uga, ra yâme Pabl: ―¡Ganii dxiꞌy didz-nahcsy lo xjefy gyre xbahl Dioz! ");
INSERT INTO zpg_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ra Pabl leeyâme: ―Betzy, nehx nannaꞌ bâḻ xjefy gyre bahl‑e leeme. Naa nannaꞌ lo guehtzy ni queꞌ xtiidz Dioz neu: “Di gyniiy didz-nahcsy to lo meññ-guxtisy ni rtzoo mdad xguiedzyiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pabl naꞌ, bwieꞌ me nehx tohzy cuib meññ-nac yahc guxtisy: doozy yâme meññ-nac saduceu, no stoozy yâme meññ-nac yahc fariseu. Were günii me ndip, ra me leeyâme: ―Betzy, meññ-nac fariseu we naa no xiiñ meññ-nac fariseu zegahc. Naa gabiaazaꞌ zdzihñ to dzé zbahñ gyre meññ ni ba guhty, no por lee we gayahc guîlguxtisy dilguian. ");
INSERT INTO zpg_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Hor-bieññ yâme günii me ze, guzlo gadeḻydiidz meññ-nac yahc fariseu no meññ-nac yahc saduceu, no meññ-wé ni bydohp byruu yâme chohp cuib. ");
INSERT INTO zpg_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Porni meññ-nac saduceu nehx rlíladzy yâme bâḻ zbahñ meññ ni ba guhty yahc, ni nehx rlíladzy yâme bâḻ nu ángel ni spirt. Per meññ-nac yahc fariseu rlíladzy gyre nirieꞌ ni nehx rlíladzy meññ-nac saduceu. ");
INSERT INTO zpg_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","No por leeu xroꞌ ṟid ptzoo yâme. Were biahs lahd muextr ni ruuḻ yahc xleiy Moiséz ni nac meññ-fariseu, ne yâme: ―Nehx rdzial noꞌ mbehty ni nahcsy lguia mpyquie-rieꞌ. Duhn dxuhch spirt günino leeme o, bâḻ yac, dxuhch ángel la, di gyruu nó contr Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Bwieꞌ comandant ba ma xroꞌ ṟid gatzoo yâme, bydzie me ntzudé yâme Pabl. Were pshalcaꞌ me soldad biahd lehdy güloo yâme Pabl, ziyno yâme lee leññ cuartel sto. ");
INSERT INTO zpg_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ni güyuꞌ sto guiaal, biahd Jesúz bidnino me Pabl no ra me lee: ―Di gydziehbyiꞌ. Mod-güniiy de naa neꞌ Jerusaléṉ, mod-wé gahc‑e gyniiy ru gydzihñiꞌ Ṟom. ");
INSERT INTO zpg_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ni byre guiaal, ptohp saꞌ doozy meññ-Isṟael no ptzoo yâme diidz ngaꞌdy yâme Pabl, no bdee xtiidz yâme de ni tzu-dia yâme, bâḻ goo yâme o gahgü yâme no dgueññ igaꞌdy yâme leeme. ");
INSERT INTO zpg_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","No mazy de cuarent yâme ptzoo yahc diidz ntzoo mod-wé. ");
INSERT INTO zpg_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","No güya yâme lo xjefy yahc bahl no lo mînguhl yahc ni nac guxtisy lahd meññ-Isṟael, ra yâme lee: ―Noꞌ ba bdee dtiidz noꞌ de ni tzu-dia noꞌ bâḻ gahgü noꞌ o goo noꞌ no dgueññ igaꞌdy noꞌ Pabl. ");
INSERT INTO zpg_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Naꞌ racdadzy noꞌ ctzohd diidz no meññ-nac yahc guxtisy par ga laꞌd comandant gboo me Pabl, guidno me lee lo laꞌd cshe. Lâ guisquiee leeme, lâ ga leeme nur zrieñ ni gnabdiidz laꞌd leeme lehdy gann laꞌd ma zaꞌgndzi lguia gyre ni ptzoo me; eguiid noꞌ tzu noꞌ puexd par igaꞌdy noꞌ leeme lóni ziaad ziaꞌr me lo laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Per to xñobywiñ ndzab-byzan Pabl bieññ me ni gatzoo yâme diidz, güya gahc me ruꞌ cuartel ru nu Pabl, bigyne meu lee. ");
INSERT INTO zpg_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","No pshalcaꞌ gahc Pabl to de lahd capitáṉ, ra me lee: ―Tziynoy ñobywiñ-rieꞌ lo comandant. Rahp me diidz ni guno me lee. ");
INSERT INTO zpg_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Were ziyno me ñobywiñ. Bydzihñ me, ra me comandant: ―Pabl ni nyagü lidzyguiib pquee me riedz naa güyan ru nu me, no ra me naa guidnon ñobywiñ-rieꞌ neꞌ, guno me diidz lii. ");
INSERT INTO zpg_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Were günahzy comandant ña ñobywiñ, güiyno me lee diby lad, no ra me lee: ―¿Bia diidz gunoy naa? ");
INSERT INTO zpg_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Were ra ñobywiñ leeme: ―Zidnen lii xtahl meññ-Isṟael ba ptzoo yâme diidz guisquiee yâme, ga yâme lii: “Ctzooy mdad tza Pabl cshe lo meññ-nac yahc guxtisy, lehdy gann yâme ma zaꞌgndzi lguia ni ptzoo me.” ");
INSERT INTO zpg_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Per di gylíladzyiꞌ leeyâme; porni ma de cuarent meññ-Isṟael ngaꞌdzy gabiahz leeme. Gyre meññ-rieꞌ yahc ba bdee xtiidz yâme de ni tzu-dia yâme bâḻ gahgü yâme o goo yâme no dgueññ igaꞌdy yâme Pabl. No ba nu yâme puexd, ba nunzy xtiidziꞌ we gabiahz yâme. ");
INSERT INTO zpg_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Luxu, ra comandant ñobywiñ: ―Ba beeiy tzaꞌy no di guy lo ndruhty ni guhdzyiꞌ naa. ");
INSERT INTO zpg_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Were pshalcaꞌ comandant chohp xcapitáṉ me par ptzoo me mdad lee cu yâme puexd chohp gayuu soldad ni seꞌ, no setent yâme ni cuib guay, no schohp gayuu yâme ni tziyno lanz, lehdy gyruu yâme las-nuevy guiaal, tza yâme Cesarea. ");
INSERT INTO zpg_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","No ptzoo me mdad tziyno yâme guay ni cuib Pabl lee, no ra me leeyâme zaꞌgndzi tziyno yâme leeme lo gobernador ni le Felsy. ");
INSERT INTO zpg_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","No bzaa me to guehtzy ni ganii ne: ");
INSERT INTO zpg_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Gashaalaꞌ guetzy-rieꞌ loꞌy gobernador-Felsy, lii ni modni rsahc ni rnii; naa we Claudy-Lisias. Ganin diux lii. ");
INSERT INTO zpg_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mpyquie-rieꞌ ni zidno dmeññaꞌ loꞌy, meññ-Isṟael‑e günahzy leeme, gucladzy yâme ngaꞌdy yâme leeme. Per naa di ndedyaꞌ ñahz, güyo noꞌ no dsoldadaꞌ par byla noꞌ leeme, porni gunnaꞌ meññ-Ṟom leeme. ");
INSERT INTO zpg_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","No güiynon leeme lo meññ-nac yahc xguxtisy meññ-Isṟael par ñannaꞌ bia nacu ni garuu yâme contr leeme. ");
INSERT INTO zpg_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","No were gunnaꞌ garuu yâme contr leeme nunzy porni ne yâme nehx rtzoo me ni ne xleiy yâme. Per nehx nu mbehty chehsh me par ñehty me ni par ñuꞌ me lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pshaalaꞌ leeme loꞌy porni gunnaꞌ ba nu meññ-Isṟael puexd de ni igaꞌdy yâme leeme, no ba ptzon mdad guiaad meññ-garuu yahc contr leeme par ga yâme lii bia leeu ptzoo me. Zaꞌgru tzuy.” ");
INSERT INTO zpg_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Were ptzoo soldad mod-guhc mdad leeyâme. Güloo yâme Pabl guiaal, ziyno yâme leeme xtâ to ru le Antípatris. ");
INSERT INTO zpg_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ni byrohp dzé, soldad ni za yahc gazeꞌ gubyguiat cuartel. Nunzy soldad yahc ni dziib guay za no Pabl. ");
INSERT INTO zpg_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Scâsy bydzihñ yâme Cesarea, bdee gahc yâme guehtzy cuaꞌ gobernador no pteedy yâme Pabl lo ña me. ");
INSERT INTO zpg_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Bylux biiḻy gobernador lo guehtzy ni bdee yâme leeme, günabdiidz me Pabl bia lo ṟegióṉ byruu me. Hor-gunn me meññ-Cilicy Pabl, ");
INSERT INTO zpg_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","were ra me lee: ―Hor-ba diaa bydzihñ meññ-garuu contr lii, were guieññaꞌ ni gyniiy. Luxu, ptzoo me mdad gydaꞌb Pabl leññ xpalacy Herody. ");
INSERT INTO zpg_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Güdahpu gaay dzé, bydzihñ Ananíaz ni nac xjefy gyre bahl no zrieñ mînguhl ni rahc ni rnii, no zidno yâme to mpyquie ni gynii por leeyâme, le Tértulo. Bydzihñ yâme lo gobernador par ctzoo yâme contr Pabl. ");
INSERT INTO zpg_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Hor-ba pshalcaꞌ yâme Pabl, guzlo gahc Tértulo ganii gyrehzy contr leeme, ra me gobernador: ―De xquix lii, nu noꞌ dzie tziaawy, no gyre ru nu dmeññ noꞌ xtahl cos gayahc zaꞌgndzi por xguîlnanniꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Rguguia noꞌ lii rutisy rahc guîlguxtisy ni rtzooy, gobernador-Felsy, lii ni modni rsahc ni rnii, no rdee noꞌ xquix lii por gyreu. ");
INSERT INTO zpg_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nur zrieñ ni ñunon lii, per nehx racdadzyaꞌ gboon xtiémpiꞌ, mazyg guieññiꞌ ni guno noꞌ lii ngueeḻy gá. ");
INSERT INTO zpg_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ba gunn noꞌ mpyquie-rieꞌ zidguiahc me beeiy guîlzi, no xtoḻ me rahc meññ-Isṟael chohp tzonn cuib byzaꞌzy ru ganzeꞌ me. Leeme we ni nac to xjefy xmeññ Jesúz ni nac meññ-Nasaret, ");
INSERT INTO zpg_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","xtâ no gucladzy me ntzoo me diydoró noꞌ beeiy to cuentz lgar. Leewe günahzy noꞌ leeme par nwieꞌ noꞌ xnahc ñahc me mod-ne dleiy noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Per biahd gahc comandant ni le Lisias, byruu me contr noꞌ no güloo me Pabl dña noꞌ, ");
INSERT INTO zpg_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","no ra me gyre meññ-garuu yahc contr Pabl: “Lâ tza lo diaa gobernador.” No leewe zioꞌb noꞌ. Lii beeiy gnabdiidziꞌ leeme par ganniꞌ ni uli de ni ganii noꞌ contr leeme. ");
INSERT INTO zpg_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Gyre meññ-Isṟael ni dxie yahc ru dxie gobernador, ne yâme ni uli we gyre ni ganii Tértulo. ");
INSERT INTO zpg_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Were ptzoo gobernador señ Pabl par gynii me, no were günii Pabl, ne: ―Rxihlyaꞌ beeiy gapyaꞌ lii bia nacu rnin no rtzon ze, porni nannaꞌ lii naquiꞌ juez lo nacioṉ-rieꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Leer rahp tzipychop dzé de ni bydzihñaꞌ Jerusaléṉ no zan idoró lehdy gzacbeeiyaꞌ Dioz. Lii beeiy gnabdiidziꞌ meññ bâḻ nehx uliu. ");
INSERT INTO zpg_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ndruhty de lahd meññ-garuu contr naa nehx bwieꞌ gadeḻydiidzaꞌ no meññ leññ idoró, ni nehx bwieꞌ yâme naa gayisteḻyaꞌ meññ zrieñ idoo, ni leññ ciuda. ");
INSERT INTO zpg_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Meññ-rieꞌ yahc di zaḻ gdee yâme diidz bâḻ uliu gyre ni ganii yâme contr naa. ");
INSERT INTO zpg_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Per nirieꞌ ni uli we ren lii: Naa rzacbeeiyaꞌ Dioz ni bzacbeeiy gahc dmeññ noꞌ ni güyuꞌ yahc ba xtze, per rtzon leeu mod-ne ni le Xñahz Crist. Nirieꞌ we ni ne meññ-rieꞌ yahc to ñahz ni nehx uli. No naa rlídadzyaꞌ gyre ni ziaad lo leiy ni bzaa Moiséz no ni bzaa profet yahc ni güyuꞌ ba xtze. ");
INSERT INTO zpg_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","No naa gabiaazaꞌ ni gabiahz gahc yâme lguia ni rlídadzy noꞌ ctzoo Dioz, de ni zdzihñ to dzé zbahñ gyre meññ ni ba guhty, guhc me meññ-tziaawy o meññ-dirquihñ, gyre yâme gybahñ. ");
INSERT INTO zpg_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","No por lee we tirgahc ryobyaꞌ xnahc gapaꞌ to guîlrieñ-mos lo Dioz no lo meññ zegahc. ");
INSERT INTO zpg_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Naa güyun xguiedzy meññ xtze, no gyzac gubyguiataꞌ dguiedzyaꞌ par gucnon meññ-nehx rahp mbehty no par bdedyaꞌ gun par Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Niwé gatzon leññ idoró hor-biahd lahd meññ-Isṟael ni byruu lo ṟegioṉ-Asia, no naa ba ptzon gyre mod-ganii leiy ctzoo mu par guiar xguîlquie mu. Zidnon doozy meññ hor-wé no nehx gatzuṟid noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Meññ-wé yahc‑e ñahd neꞌ, nnii bia nacu garuu yâme contr naa no bâḻ nu bia ptzon. ");
INSERT INTO zpg_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bâḻ yac la, gynii meññ-rieꞌ yahc ni dxie neꞌ bia guîlquie bydzial yâme dcheshaꞌ dze-güiyno yâme naa lo guxtisy Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Mazyg, dzé nun lahd yâme günin ndip: “Naa nun lo ña laꞌd porni rlídadzyaꞌ zdzihñ to dzé zbahñ gyre meññ ni ba guhty.” ");
INSERT INTO zpg_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felsy naꞌ, gumm ba nann me lguia ni le Xñahz Crist ni bzaꞌd Pabl la, leewe scâsy bieññ me mod-günii Pabl, ra gahc me leeyâme: ―Gac guîlguxtisy lguia nirieꞌ xtâ guiaadr Lisias ni nac comandant, no modé gannaꞌ zaꞌgndzi xnahc ziaadu. ");
INSERT INTO zpg_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","No luxu, ptzoo me mdad to capitáṉ gydaꞌb Pabl, per beeiy gyruzeꞌ me doozy no di yca yâme xmígü me ni dzictixlo leeme no guidno ni tedydzé me. ");
INSERT INTO zpg_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Güdahpu stoozy dzé, biahd Felsy no tziahl me ni le Drusila, to meññ-Isṟael. Gyzac pshalcaꞌ me Pabl sto par bieno diidz leeme de ni gylíladzy mu Jesucrist. ");
INSERT INTO zpg_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Per hor-gazaꞌd Pabl racladzyu ctzoo meññ ni nac xñahzû, no gann yâme bia rtzoo yâme, no zegahc bia leeu ctzoo Dioz meññ dzé ni ziaad, modni bydzie gobernador, no ra me Pabl: ―Beeiydí gübiꞌ. Ru ba rapaꞌ tiémp, cshalcan lii lehdy gu nó diidz sto. ");
INSERT INTO zpg_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Xtahl vuelt pshalcaꞌ gobernador Pabl, ru me diidz no lee, porni riuꞌladzy me ña Pabl leeme nguix lo me lehdy nislaa me lee. ");
INSERT INTO zpg_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Leññ chohp ihz güyuꞌ yâme ze no bidruu Felsy de ni nac me gobernador. No güyuꞌ sto mpyquie xilgar me, le Porcio Festo. No Felsy, lehdy guiaꞌn me mos no meññ-Isṟael, nehx güloo me Pabl lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fest naꞌ bydzihñ me Cesarea par guhc me gobernador, no tzonn dzé güdahpu byruu meu, güya me Jerusaléṉ. ");
INSERT INTO zpg_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Uga nu me, biahd xjefy yahc bahl no zrieñ meññ ni ma rahc ni rnii yahc lahd meññ-Isṟael bidtzoo yâme contr Pabl lo me. Günab yâme ");
INSERT INTO zpg_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ñacno me leeyâme cshalcaꞌ me Pabl Jerusaléṉ. Günii yâme ze lehdy ngaꞌdy yâme Pabl lo ñahz hor-ñahd me. ");
INSERT INTO zpg_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Per Fest ra leeyâme: ―Pabl nu me lidzyguiib Cesarea, no leññ gahc dze-rieꞌ yahc naa guibyguiataꞌ Cesarea sto. ");
INSERT INTO zpg_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","No leewe, naa tziynon lahd xmeññ laꞌd ni rtzoo mdad laꞌd, lehdy were bâḻ ptzoo mpyquie-rieꞌ behch ni dirquihñ la, uga gynii yâme bia ptzoo me. ");
INSERT INTO zpg_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Beeiy shun o tzii dzé bylee gobernador Jerusaléṉ, no gubyguiat me Cesarea. Ni byre guiaal bicchie me ru rbia gobernador, no ptzoo me mdad biahd Pabl. ");
INSERT INTO zpg_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Scâsy bydzihñ me, gübigy gahc gyre meññ-Isṟael gybi me ni bidno gobernador lee de Jerusaléṉ. No günii yâme contr leeme gyrehzy ni dirquihñ, per di ñaḻ ndee yâme diidz bâḻ uliu gyre ni ne yâme ptzoo me. ");
INSERT INTO zpg_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Per Pabl günii me nehx uliu ni ganii yâme contr leeme, ne me: ―Naa mbehty ni dirquihñ dgueññ ctzon chehsh xleiy meññ-Isṟael, ni chehsh idoró, ni contr emperador xchieñ meññ-Ṟom. ");
INSERT INTO zpg_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fest naꞌ, riuꞌladzy me gyxilyno meññ-Isṟael leeme, no leewe ra me Pabl: ―¿Racladzyiꞌ tzaꞌy Jerusaléṉ la? Uga diaa guieññaꞌ gyre nirieꞌ ni ganii yâme contr lii. ");
INSERT INTO zpg_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ra Pabl leeme: ―¡Neꞌ nun ru rtzoo emperador xchieñ meññ-Ṟom mdad; neꞌ gyduhn bia mód ziaad ni ganii yâme contr naa! Lii nanniꞌ mbehty ni dirquihñ dgueññ ctzon contr meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Bâḻ ptzon behch ni dirquihñ ni xroꞌ par gatyaꞌ la, beeiy gatyaꞌ. Per bâḻ nehx uliu gyre ni ganii yâme contr naa la, ndruhty nehx beeiy gdee naa lo ña yâme. Lo ña emperador-Cézr, wé we rnabaꞌ tedyu. ");
INSERT INTO zpg_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Were bieno gobernador diidz meññ-rdee guîlriehñ leeme lguia ni ctzoo me, no luxu ra me Pabl: ―Bâḻ neꞌy lo emperador-Cézr tzaꞌy la, naꞌ tzaꞌyu. ");
INSERT INTO zpg_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Güdahpu stoozy dzé de nirieꞌ, güya ṟeiy-Agripa Cesarea no Berenice, bictixlo yâme gobernador-Fest. ");
INSERT INTO zpg_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Gumm bylee yâme Cesarea la, bieno gobernador diidz ṟeiy-rieꞌ lguia ni nu contr Pabl, ra me lee: ―Nu to mpyquie lidzyguiib neꞌ lo diaa x‑ihz gobernador-Felsy, ni ba byruu. ");
INSERT INTO zpg_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Dze-güyan Jerusaléṉ, biahd xjefy yahc bahl no zrieñ mînguhl ni rsahc ni rnii lahd meññ-Isṟael, bidtzoo yâme contr leeme dloꞌn. No günab yâme ntzon mdad ñehty me. ");
INSERT INTO zpg_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Per naa gutzyaꞌ leeyâme, noꞌ meññ-Ṟom, nehx rtzoo noꞌ ze de ni nteedy noꞌ to meññ lo ña zrieñ meññ lehdy gaty, bâḻ dgueññ guieññ me ni ganii meññ-garuu contr leeme lo guxtisy, lehdy gynii me bâḻ uliu ni ganii yâme contr leeme. ");
INSERT INTO zpg_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","No leewe, scâsy biahd yâme neꞌ, nehx byleeraꞌ. Ni byre gahc guiaal gürien dilgaraꞌ no pshalcan mpyquie-rieꞌ ni nu yâme contr lee. ");
INSERT INTO zpg_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Per hor-günii meññ-garuu contr leeme no bieññaꞌ leeu, nehx günii yâme contr leeme ni rzaꞌ leññ diqyaꞌ ren ptzoo me. ");
INSERT INTO zpg_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Mazyg günii yâme contr leeme lguia xṟeligióṉ yâme no de ni rluu me meññ lguia to mpyquie ni guhty, ni le Jesúz, per ne Pabl mbahñ me. ");
INSERT INTO zpg_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","No ba di rdzialaꞌ bia mód ntzon no ni günii gyre yâme. Were günabdiidzaꞌ leeme, lee we Pabl, bâḻ riuꞌladzy me tza me Jerusaléṉ lehdy uga gyduhn bia mód ziaadu. ");
INSERT INTO zpg_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Per leeme günab me tza me lo emperador-Augusto lehdy leeme güieꞌ xnahc gacu. Leewe ptzon mdad gydaꞌb me neꞌ lidzyguiib xtâ ru ba beeiyu, were cshaalaꞌ leeme lo emperador. ");
INSERT INTO zpg_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Were ne Agripa: ―Zegahc riuꞌdadzyaꞌ guieññaꞌ ni rnii me. Ra Fest leeme: ―Cshe gahc guieññiꞌ ni gynii me. ");
INSERT INTO zpg_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ni byre guiaal, biahd ṟeiy no gahc Berenice. Nutz yâme lar-modni mos, no bydzihñ yâme tohzy no xjefy yahc soldad no mpyquie-ma rsahc yahc ni rnii lahd meññ-guiedzy, no güyuꞌ yâme leññ yuꞌ ru rbia meññ-guxtisy. Scâsy bydzihñ yâme, pshalcaꞌ gahc gobernador Pabl, ");
INSERT INTO zpg_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","no günii me, ne me: ―Ṟeiy-Agripa, no gyre laꞌd ni dxie neꞌ: Mpyquie-rieꞌ ni gawieꞌ laꞌd lee, meññ-Isṟael‑e biahd yahc bidtzoo contr leeme dloꞌn neꞌ Cesarea no zegahcu Jerusaléṉ. Nehx riandzie yâme de ni ganab yâme gaty me. ");
INSERT INTO zpg_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Per naa gunnaꞌ nehx ptzoo me mbehty par ñehty me. No leegahcme günab me, ne me: “Emperador xchieñ meññ-Ṟom güieꞌ xnahc gacu.” Ngâstoo la, nun par cshaalaꞌ leeme lo emperador-Augusto ru racladzy me tza me. ");
INSERT INTO zpg_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","No gumm nehx rdzialaꞌ bia gzan lo guehtzy ni cshaalaꞌ lo emperador, leewe zidnon leeme lo gyre laꞌd, no mahbu lii zidnon leeme loꞌy, ṟeiy-Agripa, lehdy gnabdiidz laꞌd leeme de ni rtzoo me, no mod-wé were tzu ni gzan lo guehtzy ni cshaalaꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Porni naa rwien nehx xñahzu cshaalaꞌ to meññ-nyagü lidzyguiib lo emperador sinn di gzan lo guehtzy bia ptzoo me. ");
INSERT INTO zpg_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Were ra ṟeiy-Agripa Pabl: ―Beeiy gyniiy bia nacu garuu meññ contr lii. Were gülesy ña Pabl no guzlo ganii me nehx nu bia nacu gaty me, ne me: ");
INSERT INTO zpg_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","―Rxihlyaꞌ, ṟeiy-Agripa, porni dzêrieꞌ guieññiꞌ ni gynin de ni garuu meññ-Isṟael contr naa. ");
INSERT INTO zpg_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","No rxihlyaꞌ porni nannaꞌ mahbu lii nanndooy gyre xleiy meññ-Isṟael no gyre xcostumbr yâme, no leewe rnabaꞌ guieññiꞌ ni dziguiapyaꞌ lii no di cshacladzyiꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Gyre meññ-Isṟael nann yâme xnahc güyun lahd yâme ru nac dguiedzyaꞌ no zegahcu Jerusaléṉ glo nyaañaꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Leeyâme nann gyreu. Bâḻ racladzy yâme la, beeiy gdee yâme diidz, glo ba xtze meññ-nac fariseu we naa. No meññ-nac yahc fariseu la, leeyâme we ni ma rtzoo gyre ni ne xleiy dṟeligióṉ nó. ");
INSERT INTO zpg_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","No hôrrieꞌ nun neꞌ porni rlídadzyaꞌ stzoo Dioz mod-bdee me xtiidz me dmeññ noꞌ ni güyuꞌ yahc ba xtze. ");
INSERT INTO zpg_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dmeññ nó ni ziaad de lo gydiby tzipychop xiiñ Isṟael zegahc gabiahz yâme gac mod-bdee Dioz xtiidz me leeyâme, no por lee we dzé no guiaal rzacbeeiy yâme Dioz ni nu gybaa. No porni rtzon mod-wé gahc‑e, ṟeiy-Agripa, lee we ni garuu meññ-Isṟael contr naa. ");
INSERT INTO zpg_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Naꞌz laꞌd, ¿nehx rlíladzy laꞌd bâḻ beeiy zispahñ Dioz mînguty la? ");
INSERT INTO zpg_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Naa tzcaḻ, dguîlriehñaꞌ we ctzon gyrehzy contr le Jesúz ni nac meññ-Nasaret, no leññ diqyaꞌ ren, mos‑e gatzon. ");
INSERT INTO zpg_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","No mod-wé ptzon Jerusaléṉ. No xjefy yahc bahl, leeyâme bdee guehtzy naa par günaazyaꞌ xtahl xmeññ Dioz par gülun leeyâme lidzyguiib, no ru bgaꞌdy meññ leeyâme, naa zegahc byxilynon leeu. ");
INSERT INTO zpg_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Xtahl vuelt güyan leññ gyre idoo, ptzo psacaꞌ leeyâme lehdy gynii yâme didz-nahcsy contr Crist. Ulihbu bydziadzynon leeyâme, xtâ xguiedzy zrieñ meññ güyan bigynaazyaꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’No niwé gahc‑e zictzon ru zan Damascü, ru pshahl xjefy yahc bahl naa, no leegahc yâme bdee guehtzy ziynon. ");
INSERT INTO zpg_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Per lóni zan lo ñahz, ṟeiy-Agripa, beeiy ribygue, tohzydzi bwien bydahl to byniꞌ ni byruu gybaa no ma rzaagyu que xgue ncübidz, no bydahlu dguingybin no guingybi dmeññaꞌ ni ziynon lee. ");
INSERT INTO zpg_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Gyre noꞌ biahb lo yu hor-wé, no bieññaꞌ to riedz ra naa lo didz-hebreu, ne: “Saul, Saul, ¿bia nacu gagultihpiꞌ naa? Lii gatzunéy lii gahc beeiy racné yuhz ru rloꞌ maꞌ lo behch ni ndushgue.” ");
INSERT INTO zpg_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Were günin, ren: “¿Dxu lii, Señor?” Were günii Señor, ra me naa: “Naa we Jesúz ni gagultihpiꞌ lee. ");
INSERT INTO zpg_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Biahsiꞌ de ru nashiꞌ, guzli. Naa ganinon lii lehdy ctzooy dixtziñaꞌ no lehdy gunoy diidz meññ lguia ni bwieꞌy ngâstoo no zrieñ ni gluraꞌ lii. ");
INSERT INTO zpg_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","No naa zislaan lii de lo ña meññ-Isṟael no de lo ña meññ-nehx meññ-Isṟael. No ba dzicshaalaꞌ lii ru nu yâme, ");
INSERT INTO zpg_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","par gluuy leeyâme ni uli de naa, lehdy gyruu yâme de lo guibcawy, guiaad yâme lo byniꞌ, no lehdy di ctzoor bêndzab mdad leeyâme, no ctzoo yâme ni ne Dioz; no gylíladzy yâme naa lehdy csiaaḻdadzyaꞌ xguîlquie yâme, no mod-wé zdee Dioz leeyâme ni ycaꞌ meññ ni ba nac nunzy par leeme.” ");
INSERT INTO zpg_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’No leewe, ṟeiy-Agripa, nehx ptzunahdyaꞌ de ni günino Señor naa xtâ gybaa, ");
INSERT INTO zpg_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","mazyg guzloꞌn bienon xtiidz Dioz nier gahc meññ-nu Damascü, no meññ-Jerusaléṉ, no meññ-nu yahc lo ṟegioṉ-Judea. No zegahc bienonu meññ-nehx meññ-Isṟael. Ren leeyâme csaan yâme ni nahcsy ni nac yâme no gyo yâme Dioz, no ctzoo yâme mod-racladzy me lehdy guieññ ulihbu rahc cuent leeyâme no Dioz. ");
INSERT INTO zpg_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","No por leeu günahzy meññ-Isṟael naa ruꞌ idoró, no gucladzy yâme ngaꞌdy yâme naa. ");
INSERT INTO zpg_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Per Dioz gayacno me naa xtâ ngâstoo gayunon meññ xtiidz me, guhcu meññ-ndruhty nehx nac o meññ-rahc ni rnii. Gyre ni ganin ziaadu lo libr ni bzaa profet yahc no ni bzaa Moiséz, ru bzaa yâme gyre ni rahp yahc de ni gac. ");
INSERT INTO zpg_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","No nirieꞌ we ni bzaa yâme, neu: Crist rahp me de ni tedy me gyrehzy ni nadz, no ru ba guhty me, nier gahc leeme gybahñ de lahd mînguty; no guno me diidz meññ bia mód tzu yâme lo byniꞌ par gylaa yâme de lo guîlnadz ni ziaad, nyug meññ-Isṟael, nyug meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Lóni ganii Pabl gyre niwé yahc lehdy gann yâme mbehty ni nahcsy nehx nu contr leeme, pquee Fest riedz, ne me: ―¡Nguidz ihqyiꞌ we, Pabl! Tant byzeedyiꞌ, leewe ba lé nguidz ihqyiꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Were ne Pabl: ―Nehx nguidz diqyaꞌ, Fest, lii ni modni rsahc ni rnii. Xñahzu we mod-ganin no ni uli we gyre ni ren. ");
INSERT INTO zpg_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Wé dxie ṟeiy-Agripa, nanndoo me xnahc ziaad gyre mod-günin, no leewe günin ñaz-lo me no di ndziehbyaꞌ. Naa nannaꞌ nann me ulihbu guhc gyre nirieꞌ, porni dacu ni guhc ru ngaꞌdzy. ");
INSERT INTO zpg_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","¿Rlíladzyiꞌ mod-ganii lo libr yahc ni bzaa profet la, ṟeiy-Agripa? Naa nannaꞌ rlíladzyiꞌ mod-ganiiu. ");
INSERT INTO zpg_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Were günii ṟeiy-Agripa, ra me Pabl: ―¡Por chohp tzonn diidz ni neꞌy riñloꞌy ctzooy gan gácaꞌ xmeññ Crist! ");
INSERT INTO zpg_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Were ra Pabl leeme: ―Por chohp tzonnu o xtahlu, nehx nunzy par lii. Naa rnabaꞌ lo Dioz par gyre meññ-bieññ yahc ni günin dzêrieꞌ, lehdy gylíladzy yâme beeiy gahc naa, ¡per dac nlihby yâme mod-nliibyaꞌ no caden hôrrieꞌ! ");
INSERT INTO zpg_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Byluxu biahs ṟeiy no gobernador no Berenice, no gahc gyre meññ-dxieno yâme. ");
INSERT INTO zpg_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Byruu yâme diby lad, gaya saꞌ yâme: ―Nehx nu mbehty doḻ chehsh mpyquie-rieꞌ par gaty me, ni nehx nu bia nacu guiaꞌn me lidzyguiib. ");
INSERT INTO zpg_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Were ra ṟeiy-Agripa gobernador-Fest: ―Beeiy nislaa nó leeme we, bâḻ di nnab me tza me lo emperador-Cézr. ");
INSERT INTO zpg_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Hor-ba nac diidz tzo noꞌ nacioṉ-Italia, pteedy yâme Pabl no zrieñ meññ-nu yahc lidzyguiib lo ña to mpyquie ni le July ni nac xcapitáṉ to cuib soldad ni rahc cuent lee lahd batallóṉ ni le Augusto. ");
INSERT INTO zpg_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Güyuꞌ noꞌ leññ to barcü-ro ni ria to ciuda ni le Adramitio ru rbiahz barcü, no hor-güyuꞌ noꞌ leññu, ba nuw de ni gyruuw par tzau xtâ ru rbiahz yahc barcü coo ṟegioṉ-Asia. No zegahc ziyno noꞌ Aristarcü, meññ-Tesalónyc ni nu lo ṟegioṉ-Macedony. ");
INSERT INTO zpg_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ni byre guiaal bydzihñ noꞌ Sidóṉ ru rbiahz barcü. No July naꞌ, bioob me Pabl hor-bydzihñ noꞌ uga. Bdee me ñahz güya Pabl bictixlo xmígü par gucno yâme leeme no ni tedydzé me. ");
INSERT INTO zpg_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Hor-byruu noꞌ Sidóṉ, gaguihñ mbedun-ro barcü ni nu noꞌ leññ. Leewe güdedy noꞌ gahsh gá to lyu ni le Chipre ni nu nisdoo guingybi; wé nehx ma rxuu mbeꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Were güdeedy noꞌ to lo nisdoo ru rtzoo Cilicy mdad no Panfilia. Biaht noꞌ xtâ to guiedzy ni le Mira, ni nu lo ṟegioṉ-Licia. ");
INSERT INTO zpg_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Uga bydzial capitáṉ to barcü ni rruu guiedzy-Alejandría, ria Italia. Güyuꞌ noꞌ leññu par zo noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Modni tziaawy gá za barcü lo nisdoo leññ xtahl dzé, no modni gucngannu par bydzihñ noꞌ gahsh gá guiedzy-Gnido porni gydze lad gaguihñ mbeꞌ de ru nac diidz zo noꞌ. Were güdahp noꞌ de ni güdeedy noꞌ xderech sto lyu ni le Cret ni nu nisdoo guingybi. Ñaz-wé riaꞌn guiedzy-Salmóṉ. ");
INSERT INTO zpg_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Zo noꞌ leññ barcü gahsh gá coou, nîcze ngannu, xtâ glo bydzihñ noꞌ to ru le Buenos Puertos, ni riaꞌn gahsh to guiedzy ni le Lasea. ");
INSERT INTO zpg_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ba xroꞌ tiémp ganiꞌdy noꞌ, no ba ndzieeby par gxuunn barcü lo nisdoo, porni ba gadzihñ tiemp-naḻ. Leewe, ra Pabl meññ-ziyno leeme: ");
INSERT INTO zpg_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","―Naa rwien ndzieeby mod-zo nó. Duhn znihty barcü gydibyno gyre yuu ni zidnou. No dxgann bâḻ dac gydibyno nó znihty. ");
INSERT INTO zpg_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Per capitáṉ nehx pquee ihqy me ni ra Pabl leeyâme, ma pquee ihqy me ni ne mpyquie ni risshuunn barcü no ni ne xbixwaanu. ");
INSERT INTO zpg_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Lgar-rieꞌ naꞌ ru rbiahz barcü, nehx mosu ñuꞌ meññu tiemp-naḻ; no leewe casy gyre yâme ne ma mos‑e gyruu noꞌu, lehdy güieꞌ noꞌ bâḻ beeiy gydzihñ noꞌ xtâ to guiedzy ni le Fenice, ni nac sto ru rbiahz barcü ru rtzoo Cret mdad, no lehdy guiaꞌn noꞌu tiemp-naḻ. Lgar-wé nehx ma rxuu mbedunu, no rwieꞌu gyrop coo ru riaꞌb ncübidz. ");
INSERT INTO zpg_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Guzlo byxuu to mbenihs ndoo gá, nlâdzy yâme beeiy ndzihñ noꞌ uga mod-wé. Were byruu noꞌ, zo noꞌ diby coo gá nisdoo ru rtzoo Cret mdad. ");
INSERT INTO zpg_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Per leer gá zo noꞌ, byruu to mbedun-ro ni ra yâme lee Euroclidóṉ, guzlo gaguihñu barcü, ");
INSERT INTO zpg_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","no modé ziyno mbeꞌ leeu. Di ñaḻ niyno noꞌ leeu ru racdadzy noꞌ. Ba ru ne mbeꞌ, bdee noꞌ ñahz tziynou noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Güdedy noꞌ sto lyu-yaañ ni le Clauda ni nu nisdoo guingybi, biaꞌn noꞌ lad-ru ma uxiee rxuu mbeꞌ. Uga güdahp noꞌ de ni güluꞌ noꞌ barcü-yaañ ni ziyno noꞌ leññ barcü-ro, per modni gucngannu. ");
INSERT INTO zpg_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ru ba gülesy noꞌu, no güluꞌ noꞌu leññ barcü-ro, were cuaꞌ yâme duu, blihby yâme barcü-ro par di gybihshu. Gumm gadzie yâme tzaaz barcü lo yux gahsh gá ru le Sirte la, gülety yâme lahr ihqy barcü ni rqueꞌ mbeꞌ lo par tza barcü lo nisdoo, no luxu bdee yâme ñahz za barcü mod-ne mbeꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ni byre guiaal tohzy mdid gaguihñ mbeꞌ barcü, were cuaꞌ yâme gyre yuu ni zidnou, psaaby yâme lee lo nzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","No ni bionn dzé gyre ni rquihñ leññ barcü, psaaby noꞌ lee lo nzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","No modni xtze nehx bwieꞌ noꞌ xibyniꞌ ncübidz ni mbial. Ba ne noꞌ nehx zlaa noꞌ, porni gatzoo gasahc mbedun barcü. ");
INSERT INTO zpg_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ba modni xtze dgueññ gahgü meññ-ziaad leññ barcü, were biahs Pabl, ra me meññ-wé yahc: ―Bâḻ laꞌd nzoob laꞌd dtiidzaꞌ ñaꞌn nó Cret la, dac‑e mod-rieꞌ ndedy nó gyrehzy. No nehx nnihty gyre ni ba bniꞌdy laꞌd neꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Per di gydzie laꞌd. Ni to nó nehx zehty. Nunzy barcü, wé we znihty. ");
INSERT INTO zpg_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ntzie biahd to ángel ni pshahl Dioz ni nacaꞌ xmeññ no ni rtzon xtziiñ, ");
INSERT INTO zpg_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","no ángel wé ra naa: “Di gydziehbyiꞌ, Pabl. Lii nehx zdedy de ni gydzihñiꞌ lo emperador-Cézr. Por lii we zioob Dioz gyre meññ-zidnoy.” ");
INSERT INTO zpg_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","No leewe, di gydzie laꞌd. Naa nannaꞌ Dioz stzoo me ni bidne x‑ángel me naa. ");
INSERT INTO zpg_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Per barcü rahpu de ni gydzihñu lo yudahñ bahch lyu ru nu nisdoo guingybi. ");
INSERT INTO zpg_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","To guiaal‑e naꞌ, ni ba byzaꞌ noꞌ beeiy chohp seman de ni ziyno mbedun noꞌ lo nisdoo ni le Adria, beeiy glaꞌy guiaal meññ-ziyno barcü gunn yâme ba gadzihñ noꞌ gahsh gá lo yudahñ. ");
INSERT INTO zpg_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Were güloo yâme mdid beeiy blaty guial nzeꞌ. Rahpu treintayseiz metr. Ma stoozy delanty gyzac güloo yâme mdid nzeꞌ sto, ba rahpu veintisiet metr. ");
INSERT INTO zpg_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ba rdzie yâme dzicchileꞌ barcü guielaꞌ leññ nzeꞌ, were cuaꞌ yâme tahp guib-roob ni nliiby, gülety yâmeu leññ nzeꞌ traz de barcü no blibyno yâmeu barcü, no riob yâme tzu laaḻ byniꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","No hor-wé meññ-ziyno barcü riñlo nxuunn leññ barcü-yaañ ni nu leññ barcü-ro. Ptzoo yâme beeiy ni galety zrieñ guib-roob delanty. Per nehx uliu, lidxi barcü-yaañ galety yâme. ");
INSERT INTO zpg_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Niwé bwieꞌ Pabl, were ra me capitáṉ no zrieñ soldad: ―Bâḻ meññ-wé yahc di guiaꞌn yâme leññ barcü la, zehty gyre laꞌd‑e. ");
INSERT INTO zpg_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Were pchug soldad duu ni nliiby barcü-yaañ par biahbu lo nzeꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ba zidtzu byniꞌ we naꞌ, ra Pabl gyre meññ-nu leññ barcü gahgü yâme, no ra me leeyâme: ―Ba rahp chohp seman dgueññ gahgü laꞌd mbehty, nunzy nu ihqy laꞌd xnahc gac nó. ");
INSERT INTO zpg_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Rnabaꞌ laꞌd, lâ gahgü lehdy tzu gan laꞌd. Ndruhty de dlahd nó nehx znihty, ¡ni to guitz-ihqy! ");
INSERT INTO zpg_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Bylux günii Pabl mod-rieꞌ, cuaꞌ gahc me paṉ lo ña me, no bdee me xquix Dioz ñaz-lo yâme. No luxu güdiiz meu, no guzlo gayahgü me. ");
INSERT INTO zpg_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Were gyre yâme byxihly no güdahgü yâme zegahc. ");
INSERT INTO zpg_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Chohp gayuu setentayseiz noꞌ ni ziaad leññ barcü por gyre noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Bylux güdahgü yâme ni biuꞌladzy yâme, cuaꞌ yâme trigü ni biaꞌn, blee yâme lee lo nisdoo lehdy gucnsehzy barcü. ");
INSERT INTO zpg_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ru ba güyuꞌ byniꞌ we naꞌ, bwieꞌ yâme lyu, per nehx nann yâme bá glo leeu. Per ba gawieꞌ yâme coo ru bydo nisdoo, no ba neññ yudahñ. No were ra saꞌ yâme güieꞌ yâme bâḻ beeiy guistzihñ yâme barcü lgar-wé. ");
INSERT INTO zpg_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","No pchug yâme xduu guib-caḻ ni nliiby barcü, biahbu leññ nzeꞌ, no luxu ptzaꞌdz yâme duu ni nliiby yahc timóṉ ni rtzoo mdad ba lad tza barcü. Luxu pquee yâme lahr ihqy barcü no biscaa yâmeu delanty par tziyno mbeꞌu, no guzlo za barcü xderech yudahñ. ");
INSERT INTO zpg_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Per aaḻ, bigyleꞌ barcü ru dxie xtahl yux ru rbiiñ nzeꞌ, no wé biaꞌnu. Nter glaꞌyu delanty ba ni di rniꞌby. No traz de leeu galaꞌy oḻ ni riahs lo nisdoo. ");
INSERT INTO zpg_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Niwé bwieꞌ soldad, gucladzy yâme ngaꞌdy yâme meññ-ziyno yâme lee ni za lidzyguiib par di gyxoob yâme lo nzeꞌ no gxuunn yâme. ");
INSERT INTO zpg_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Per capitáṉ, nehx bdee ñahz ñahcu ze, porni nehx racladzy me gaty Pabl. Leewe, ra me: “Dxu nann rxoob lo nzeꞌ, lâ gyxoob par gyruu laꞌd lo yudahñ; ");
INSERT INTO zpg_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","no zrieñ laꞌd ni di raḻ gyxoob, lâ cuib lo tabl, o lo behch ni bylaꞌy xchieñ barcü, lehdy gydzihñ laꞌd lo yudahñ.” No mod-wé ptzoo yâme lehdy bydzihñ yâme lo yudahñ. No ni to yâme nehx guhty. ");
INSERT INTO zpg_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Hor-ba bylaa gyre noꞌ de lo nisdoo, were gunn noꞌ lyu ru bydzihñ noꞌ ni nu nisdoo guingybi, leu Malta. ");
INSERT INTO zpg_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Gyre meññ-nu uga, bioob yâme noꞌ. Scâsy bydzihñ noꞌ, gülahqy gahc yâme gue par ctzeꞌdadzy noꞌ, porni gayahc guio no gayahc naḻ. ");
INSERT INTO zpg_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ru gadziib Pabl doozy yag-bihdzy lo gue we naꞌ ni bictohp me, tohzydzi byruu to mbaḻbeedzy leññu ni gayisshuunn coblay lee, güdahgü maꞌ ña me no byguieedy gahc maꞌu. ");
INSERT INTO zpg_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Hor-bwieꞌ meññ-nu yahc uga nguieedy mbaaḻ ña Pabl ru güdahgü maꞌ, ra saꞌ yâme: ―Mpyquie-rieꞌ la, meññ-rgaꞌdy‑e leeme. Lo nisdoo we beeiy bylaa me, per naꞌ ba nehx zlaa me por guîlquie ni nzahby me. ");
INSERT INTO zpg_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Per Pabl naꞌ, güdzihby ña me lehdy blee me mbaaḻ lo gue no mbehty nehx guhc me. ");
INSERT INTO zpg_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","No zuhdy yâme gawieꞌ yâme bâḻ tzu gue ña me o pór ba biahb me guhty me. Bwieꞌ yâme ba rahp hór de ni guhcu no mbehty dgueññ gac me, were ba guzlo ne yâme mpyquie-rieꞌ la, dac‑e cuentz meññ leeme, to dioz‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Gahsh gá de uga nash lyu yahc ni nac xchieñ to mpyquie ni le Publio. Leeme we rtzoo mdad meññ-nu uga. No bdee xiryuꞌ me, güyuꞌ noꞌ tzonn dzé, no bdee me ni güdahgü noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","No leññ dze-wé nash xtad Publio gayac-ure, günahzy xle leeme no guidzrieñ. Were güya Pabl bictixlo leeme, no byluxz günab Pabl lo Dioz, pshob ña chehsh me no psiaḻ gahc leeme. ");
INSERT INTO zpg_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Niwé bieññ zrieñ meññ-gayac-ure yahc ni nu uga. Biahd gahc yâme ru nu Pabl, no zegahc biaḻ gyre yâme. ");
INSERT INTO zpg_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","No xtahl ni bidno yâme biscady yâme noꞌ. No hor-ba tzo noꞌ, gyzac bidno yâme gyre ni yquihñ noꞌ ru tzo noꞌ leññ barcü. ");
INSERT INTO zpg_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tzonn mboo güyuꞌ noꞌ uga. Luxu, güyuꞌ noꞌ leññ sto barcü ni zegahc bydzihñ Malt no ni biaꞌn gydo leññ tiemp-naḻ. Barcü-rieꞌ nac xchieñ Alejandría, no guia de barcü queꞌ chohp figur ni nac xchieñ Cástor no Pólucs. ");
INSERT INTO zpg_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Bydzihñ noꞌ to ciuda ni le Siracusa ru rbiahz barcü. Tzonn dzé bylee noꞌ uga. ");
INSERT INTO zpg_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Gyzac zo noꞌ diby coo gá nisdoo no bydzihñ noꞌ ciuda ni le Regio. Ni byre guiaal, gyzac guzlo gaxuu mbenihs lo nisdoo. Ni byre sto guiaal, bydzihñ noꞌ to guiedzy ni le Puteoli. ");
INSERT INTO zpg_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Uga bydzial noꞌ meññ-rman yahc, no günab yâme noꞌ biaꞌn noꞌ no leeyâme leññ gahdzy dzé. Luxu, byruu noꞌ, zo noꞌ Ṟom. ");
INSERT INTO zpg_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Gunn meññ-rman yahc ni nu Ṟom zo noꞌu; were biahd yâme biddzil-lo yâme noꞌ xtâ to guiedzy ni le Foro de Apio, no zrieñ yâme biddzil-lo noꞌ to guiedzy ni le Tzonn Tabern. Hor-bwieꞌ Pabl leeyâme, bdee me xquix Dioz no byxihly me. ");
INSERT INTO zpg_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","No hor-bydzihñ noꞌ Ṟom, pteedy capitáṉ meññ-tzu lidzyguiib lo ña xjefy soldad. Per Pabl, bdee yâme ñahz lee güyuꞌ sto yuꞌ no to soldad ni gayahp leeme. ");
INSERT INTO zpg_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Lo tzonn dzé de ni bydzihñ Pabl Ṟom, pshalcaꞌ me meññ-rsahc ni rnii yahc lahd meññ-Isṟael ni nu uga, no hor-ba gyre yâme bydzihñ, ra me: ―Betzy, naa mbehty ni dirquihñ dgueññ ctzon contr dmeññ nó, ni dgueññ gyruun contr xcostumbr dmeññ yahc nó ni güyuꞌ yahc ba xtze. Per xtâ Jerusaléṉ diaa günahzy yâme naa no pteedy yâme naa lo ña meññ-Ṟom. ");
INSERT INTO zpg_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Günabdiidz yâme naa bia ptzon, no ru di ndzial mbehty contr naa par ñehtyaꞌ, gucladzy yâme nislaa yâme naa. ");
INSERT INTO zpg_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Per meññ-Isṟael nehx riandzie yâme de ni garuu yâme contr naa. Leewe günabaꞌ ziaḻaꞌ xtâ neꞌ lehdy güieꞌ Cézr xnahc gacu. Ni dac‑e ziaḻaꞌ neꞌ par gyruun contr dmeññaꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","No leewe, pshalcan laꞌd par gyninon laꞌd. Nun lgar-rieꞌ nliibyaꞌ nunzy porni rlídadzyaꞌ ba bydzihñ dzé ni gabiahz meññ-Isṟael lee. ");
INSERT INTO zpg_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Were ra yâme leeme: ―Ndruhty dgueññ cshahl guehtzy dlo noꞌ, no ndruhty de lo ṟegioṉ-Judea dgueññ gynii de lii, ni ndruhty dmeññ nó ni rruu uga riahd neꞌ ña noꞌ behch de lii. ");
INSERT INTO zpg_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Racdadzy noꞌ guieññ noꞌ bia leeu ni neꞌy, porni gyre lad rruu meññ contr ṟeligioṉ-rieꞌ ni leer gayieññ noꞌ. ");
INSERT INTO zpg_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Were ptzohdy yâme diidz bia dzé guidguieññ yâme ni ne me. No bydzihñ dzé we, xtahl meññ güya ru nu me. Glo rsily no xtâ glo udzie bieno me leeyâme xtiidz Dioz bia mód ctzoo yâme lehdy beeiy gdee yâme ñahz ctzoo Dioz mdad leeyâme. No pquihñ me xleiy Moiséz no xlibr profet yahc par bluu me leeyâme Jesúz‑e ni gabiahz yâme. ");
INSERT INTO zpg_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nu lahd yâme bylíladzy mod-bluu Pabl, no zrieñ yâme nehx bylíladzy. ");
INSERT INTO zpg_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","No gumm nehx güyuꞌ yâme tohzy guîlriehñ la, hor-zia yâme we naꞌ, ra Pabl leeyâme: ―Uliu mod-bisnii Spirt-Sant profet-Isaíaz ba xtze, ra me meññ-Isṟael: ");
INSERT INTO zpg_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Güya, guhdzy meññ-guiedzy-rieꞌ: Laꞌd zieññ laꞌd dtiidzaꞌ, per nehx zann laꞌd bia leeu ni bieññ laꞌd; no nîcze zwieꞌ laꞌd xroꞌ cos ni rtzon, per nehx zann laꞌd bia leeu ni bwieꞌ laꞌd. ");
INSERT INTO zpg_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Porni xguîlmbahñ meññ-rieꞌ yahc gucnahdyu, no nehx rieññ yâme xñahz cos, no rluu ndaagü lo yâme, lehdy di güieꞌ yâme, ni di guieññ yâme, ni di gann yâme zaꞌgndzi, ni di gyo yâme naa par nistziawyaꞌ xguîlmbahñ yâme, no nsiaḻaꞌ leeyâme. ");
INSERT INTO zpg_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Racdadzyaꞌ gann laꞌd nirieꞌ: Dioz ba gashahl xtiidz me lahd meññ-nehx meññ-Isṟael lehdy guieññ yâme beeiy guislaa Dioz leeyâme de lo guîlnadz ni ziaad. No leeyâme ulihbu zieññ yâme. ");
INSERT INTO zpg_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Hor-bieññ meññ-Isṟael mod-ne Pabl, zia gahc yâme, gadeḻydiidz yâme lguia ni bieññ yâme. ");
INSERT INTO zpg_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Chohp ihz güyuꞌ Pabl leññ to yuꞌ ni güdix me, no bdee me ñahz bydzihñ gyre meññ ni ria ru nu me. ");
INSERT INTO zpg_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","No runo me diidz leeyâme xnahc ctzoo yâme lehdy ctzoo Dioz mdad leeyâme, no rluu me leeyâme xtiidz Jesucrist ni rtzoo mdad. Günii me nxal lo diidz no ndruhty nehx pca leeme.");
INSERT INTO zpg_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Naa Pabl, rtzon xtziiñ Jesucrist. Dioz pquee me riedz naa lehdy gácaꞌ apóstl, no güle me naa lehdy gunon meññ xtiidz me ");
INSERT INTO zpg_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ni ba xtze diaa ne me gdee me, mod-bzaa yahc xprofet me lo Guehtzy ru queꞌ xtiidz me. ");
INSERT INTO zpg_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Diidz ni queꞌ lou ganiiu de Xiiñ me, Jesucrist ni rtzoo mdad nó. Crist guhl me lo guiedzylie, no biahd me de lo xfamily ṟeiy-Davit. ");
INSERT INTO zpg_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","No por xiSpirt Dioz ni nehx nu ndruhty beeiy lee, gübahñ Crist de lahd mînguty, no mod-wé no xroꞌ poder, bieññ Xiiñ Dioz‑e leeme. ");
INSERT INTO zpg_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","No por Jesucrist, güluꞌ Dioz xlaꞌy me naa guhcaꞌ apóstl, no pshahl me naa ctzon xtziiñ me, lehdy meññ-gyre nacióṉ gylíladzy no gzoob xtiidz me; rtzon dziñ-rieꞌ par tzuguia Crist. ");
INSERT INTO zpg_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","No laꞌd zegahc, Dioz pquee me riedz laꞌd lehdy gac laꞌd xmeññ Jesucrist. ");
INSERT INTO zpg_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Gashaalaꞌ guetzy-rieꞌ lo gyre laꞌd ni nu Ṟom, ni ndzi Dioz lee no pquee me riedz lee par gac xmeññ me: Dioz ni nac dTad nó no Jesucrist ni rtzoo mdad cu xlaꞌy laꞌd no tzu laꞌd dzie tziaawy. ");
INSERT INTO zpg_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nier gahc, por Jesucrist gadedyaꞌ xquix Dioz por gyre laꞌd, porni byzaꞌzy lo guiedzylie gayann meññ mod-rlíladzy laꞌd Jesucrist. ");
INSERT INTO zpg_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Dioz ni rtzon xtziiñ no gydo dguîlmbahñaꞌ, runon meññ xtiidz Xiiñ me, leeme nann nehx rsandzien rzataꞌ laꞌd lóni rninon leeme. ");
INSERT INTO zpg_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","No rnabaꞌ lo Dioz, bâḻ ne me, beeiy gyruqueꞌu tzan dzictixloꞌn laꞌd. ");
INSERT INTO zpg_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Porni riuꞌdadzyaꞌ güien laꞌd no gacnon ycaꞌ laꞌd xlaꞌy xiSpirt Dioz, lehdy tzu laꞌd ma zaꞌgndzi lo xtiidz me; ");
INSERT INTO zpg_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","o sno, lehdy gacno dsaꞌ nó de ni rlídadzy nó, porni mod-rlíladzy laꞌd zacnou naa, no mod-rlídadzyaꞌ zacnou laꞌd. ");
INSERT INTO zpg_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Racdadzyaꞌ gann laꞌd, rman, xtahl vuelt riuꞌdadzyaꞌ dzictixloꞌn laꞌd, per riuꞌ sto ni rca naa no xtâ hôrrieꞌ di raḻu. Naa riuꞌdadzyaꞌ ctzon xtziiñ Dioz ru nu laꞌd, lehdy tzu xtahl meññ lo xtiidz Crist, mod-ptzon lahd zrieñ meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Zidguiahcu beeiy ni nzaabyaꞌ gyre meññ, guhc me meññ-nu ciuda o meññ-nu guiedzy-yaañ, o guhc me meññ-nann o meññ-nehx nann. ");
INSERT INTO zpg_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","No leewe zegahc laꞌd ni nu yahc Ṟom, modni riuꞌdadzyaꞌ guidgyunon laꞌd xtiidz Crist. ");
INSERT INTO zpg_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Naa nehx rtunon xtiidz Crist, porni por leeu we Dioz rislaa me meññ ni rlíladzy leeu, nier gahc meññ-Isṟael, no naꞌ zegahc meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Xtiidz Crist rnii bia mód cteedy Dioz meññ beeiy ni nehx nzahby guîlquie porni bylíladzy yâme, mod-rnii lo Guehtzy ru queꞌ xtiidz Dioz neu: “Dxu tedy beeiy ni nehx nzahby guîlquie, porni rlíladzy me Dioz, wé we gap guîlmbahñ ni nehx zluhx.” ");
INSERT INTO zpg_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","No xtâ gybaa ziaad xguîlné Dioz chehsh gyre meññ-dirquihñ ni rtzoo ni nehx xñahzû, no nehx rdeedyu ñahz gann meññ ni nac ni uli. ");
INSERT INTO zpg_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Nann yâme gyre ni beeiy guieññ meññ lguia mod-nac Dioz, porni Dioz gahc bluu meu gann meññu. ");
INSERT INTO zpg_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Porni Dioz nehx nwieꞌ ndruhty leeme mod-nac me no mod-beeiyu leeme ni nehx ziuꞌ dzé zdibylgaa. Per glo dzé ni güyaa guiedzylie neññdoo mod-nac me por gyre ni bzaa me. Leewe, ni par nnii yâme nehx rahp yâme doḻ. ");
INSERT INTO zpg_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","No nîcze nann yâme dxu we Dioz, per nehx rzacbeeiy yâme leeme mod-racladzyu, ni nehx rdee yâme xquix leeme. Aaḻ ni dirquihñ nu ihqy yâme, no porni nahdy xguîlmbahñ yâme nu yâme beeiy to lo guibcawy. ");
INSERT INTO zpg_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ne yâme meññ-nann leeyâme, per luxu gucwaty yâme; ");
INSERT INTO zpg_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","no nehx bzacbeeiy yâme Dioz ni nu lo xguîlbyniꞌ no ni nehx ziuꞌ dzé zehty, aaḻ rzacbeeiy yâme figur ni güyaa beeiy meññ ni rehty, no xfigur mashiily, ma-rahp tahp nieꞌ, no ma-rzîbyleññ. ");
INSERT INTO zpg_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Leewe Dioz güloo ihqy leeyâme ctzoo yâme gyrehzy ni nahcsy ni riuꞌladzy yâme, no mod-wé no xcuerp gahc yâme rtzoo yâme no saꞌ yâme ni zidno guîlrtuꞌ. ");
INSERT INTO zpg_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Nehx bylíladzy yâme ni ulihbu Dioz, mazyg byo yâme ni nehx uli, no bzacbeeiy yâme ni bzaa Dioz, no nehx bzacbeeiy yâme Dioz, leeme nehx zdibylgaa de ni nu laꞌy leeme. Modé gacu. ");
INSERT INTO zpg_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","No leewe Dioz güloo ihqy leeyâme lehdy ctzoo yâme ni nahcsy yahc ni riuꞌladzy yâme ni ristuꞌ, xtâ no psaꞌn ngünaa de ni cuiano yâme mpyquie, aaḻ zâ-ngünaa gahc yâme rbiano yâme. ");
INSERT INTO zpg_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","No zegahcu mpyquie, psaꞌn yâme de ni cuiano yâme ngünaa, aaḻ ptzoo saꞌ yâme mod-ne xvicy yâme, mpyquie rbiano zâ-mpyquie gahc, no rtzoo yâme ni zidno guîlrtuꞌ, no leewe riahd guîlné chehsh yâme, porni rtzoo yâme ni nehx xñahzû. ");
INSERT INTO zpg_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","No gumm di ne yâme gylaby yâme Dioz la, Dioz zegahc güloo ihqy leeyâme, gap yâme guîlrieñ-nahcsy, lehdy ctzoo yâme ni nehx xñahzû. ");
INSERT INTO zpg_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Leññ xguîlmbahñ yâme bydzeꞌ gyrehzy ni nehx xñahzû, rzeno yâme ni nehx tziahl yâme lee, rtzoo yâme ni nahcsy, guîlrzîbyladzy, guîlrtzoo ni dirquihñ. No bydzeꞌ xguîlmbahñ yâme de guîlmvidy, guîlrgaꞌdy, guîlrdeḻydiidz, guîlrisquiee no ni nahcsy yahc. ");
INSERT INTO zpg_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","No rlesyno yâme meññ, rquee yâme guîlquie meññ, rruu yâme contr Dioz, rtzilytó yâme meññ, rguguia leegahc yâme, rniguia yâme, rziññ ihqy yâme ni nahcsy, nehx rzobdiidz yâme xingüzahn yâme, ");
INSERT INTO zpg_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","nwaty yâme, nehx rtzoo yâme mod-rdee xtiidz yâme, nehx ndzi yâme ndruhty, nehx rsiaaḻladzy yâme ni rtzoo zrieñ leeyâme, no nehx rioob yâme ndruhty. ");
INSERT INTO zpg_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Nîcze nanndoo yâme ne Dioz gyre meññ ni rtzoo ze, guîlguhty‑e gabiahz leeyâme, per nehx rsaan yâme de ni rtzoo yâmeu, aaḻ rxilyno yâme rtzoo zrieñ meññ mod-wé gahc. ");
INSERT INTO zpg_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Leewe nitisy dxu lii, ni par nniiy nehx rahpiꞌ doḻ, porni rlaꞌdzyiꞌ ni nac zrieñ, no luxu mod-wé gahc naquiꞌ, no por niwé rsiahbiꞌ guîlquie chehsh gahquiꞌ. ");
INSERT INTO zpg_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","No nann nó xñahzu we xguîlguxtisy Dioz hor-rtzoo meu chehsh meññ ni rtzoo ze. ");
INSERT INTO zpg_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","No lii ni rlaꞌdzy ni nac zrieñ, no luxu mod-wé gahc naquiꞌ, ¿nlâdzyiꞌ zlaay de lo xguîlnadz Dioz la? ");
INSERT INTO zpg_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","¿O neꞌy nehx rsahc xguîlndoo Dioz ni nehx rahp mdid, no nehx rshacladzy me gabiahz me lii la? ¿No nehx nanniꞌ la, de ni xguîlndoo me gacnou lii lehdy csaaniꞌ ni nahcsy ni naquiꞌ? ");
INSERT INTO zpg_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Per por xguîlnahdyiꞌ no ni di neꞌy csaan ni nahcsy ni nu leññ xguîlmbahñiꞌ, leewe gayisney guîlné chehsh gahquiꞌ par dzé ni guiaad xguîlné Dioz, dze-ctzoo me guîlguxtisy, ");
INSERT INTO zpg_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","no zguquix me to to meññ no ni ptzoo. ");
INSERT INTO zpg_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Zdee me guîlmbahñ ni nehx zluhx gyre meññ ni nehx rxiññladzy rtzoo ni nac xñahzû, no ni gabiahz cuguia Dioz lee, no glesyguia Dioz lee, no gdee Dioz lee guîlmbahñ ni nehx zdibylgaa; ");
INSERT INTO zpg_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","per zdziaꞌdzy Dioz no sshahl me guîlné chehsh meññ-di ne gzobdiidz no nehx rtzoo ni nac xñahzû, mazyg rtzoo yâme ni nahcsy. ");
INSERT INTO zpg_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Gyrehzy ni nadz no guîlrzacno zdee me meññ-rtzoo ni dirquihñ, nier gahc meññ-Isṟael no zegahcu meññ-nehx meññ-Isṟael. ");
INSERT INTO zpg_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Per meññ ni rtzoo ni nac xñahzû, cuguia Dioz lee, no glesyguia Dioz lee, no cu Dioz lee dzie tziaawy, nier gahc meññ-Isṟael no zegahcu meññ-nehx meññ-Isṟael, ");
INSERT INTO zpg_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","porni par Dioz tohzy mdid‑e rsahc gyre meññ. ");
INSERT INTO zpg_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Gyre meññ ni nehx nann xleiy Moiséz no rtzoo guîlquie, znihty yâme sinn leiy; no zegahc gyre meññ ni nann xleiy Moiséz no rtzoo guîlquie, zahc guîlguxtisy chehsh yâme mod-ne leiy. ");
INSERT INTO zpg_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Porni dac‑e gannz meññ xleiy Moiséz tedy beeiy ni nehx nzahby guîlquie lo Dioz, mazyg dxu rtzoo mod-neu, wé we tedy beeiy ni nehx nzahby guîlquie. ");
INSERT INTO zpg_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","No meññ-nehx meññ-Isṟael, nîcze nehx nann yâme xleiy Moiséz, per hor-rtzoo yâme ni ne leiy, galuu yâme bia leeu ni nac xñahzû no ni nehx xñahzû, ");
INSERT INTO zpg_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","no mod-rtzoo yâme neññ zidguiahcu beeiy ni queꞌ leiy leññ xguîlmbahñ yâme. No xguîlriehñ gahc yâme rsieññ leeyâme bâḻ nyar xguîlmbahñ yâme o yac. ");
INSERT INTO zpg_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","No gyre nirieꞌ gac dze-ctzoo Dioz guîlguxtisy lguia ni nu ngaꞌdzy yahc leññ xguîlmbahñ meññ, no stzoo meu por Jesucrist, mod-ne gahc xtiidz Crist ni runon meññ. ");
INSERT INTO zpg_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Lii neꞌy meññ-Isṟael lii, no neꞌy xleiy Moiséz racnou lii, no rguguiay lii gahc neꞌy nuy mos no Dioz. ");
INSERT INTO zpg_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Byzeedyiꞌ bia racladzy Dioz ctzooy, no leiy rluuw lii cueꞌy ni nac xñahzû. ");
INSERT INTO zpg_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","No neꞌy beeiy gluuy meññ ni zidguiahc beeiy ngaḻ bá glo za ñahz, no neꞌy naquiꞌ beeiy to byniꞌ par meññ-nu beeiy lo guibcawy. ");
INSERT INTO zpg_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","No neꞌy beeiy gluuy meññ ni nehx nann, no naquiꞌ xmuextr meññ ni zidguiahc beeiy mbiux, porni nanniꞌ xleiy Moiséz ru queꞌ gyre ni rquihñ gann meññ no gyre ni uli. ");
INSERT INTO zpg_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Lii naꞌ, bâḻ rluuy zrieñ meññ, ¿bia nacu nehx rluuy lii gahc? Lii rahbyiꞌ meññ di cuan yâme, ¿bia nacu rbaniꞌ? ");
INSERT INTO zpg_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Bâḻ neꞌy nehx xñahzu seno meññ tziahl sto meññ, ¿bia nacu rzenoy tziahl meññ? Bâḻ rruuy chehsh de ni rzacbeeiy meññ cuentz figur, ¿bia nacu rbaniꞌ ni nu leññ idoo ru nu cuentz figur? ");
INSERT INTO zpg_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Rniguiay porni neꞌy nanniꞌ leiy, luxu nehx rzacbeeiyiꞌ Dioz, porni nehx rtzooy ni ne leiy. ");
INSERT INTO zpg_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Leewe lo Guehtzy ru queꞌ xtiidz Dioz neu: “Por xtoḻ laꞌd meññ-nehx meññ-Isṟael rnii didz-nahcsy contr Dioz.” ");
INSERT INTO zpg_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","No ni uli we leeu, bâḻ nu señ ladyiꞌ no rtzooy ni ne leiy, were rsahc señ; per bâḻ nu señ ladyiꞌ no luxu nehx rtzooy ni ne leiy, were zidguiahcu beeiy ni di ñuꞌ señ ladyiꞌ. ");
INSERT INTO zpg_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Per meññ-nehx nu señ lady no rtzoo ni ne leiy, ¿dâs‑e la, zidguiahcu beeiy ni ñuꞌ señ lady me? ");
INSERT INTO zpg_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Hor-meññ ni nehx nu señ lady rtzoo gyre ni ne leiy, galuu yâme gac guîlguxtisy chehshiꞌ, porni nehx rtzooy ni ne leiy, nîcze rahpiꞌ leeu lo guehtzy no nu señ ladyiꞌ. ");
INSERT INTO zpg_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Porni par gac meññ ulihbu meññ-Isṟael, dac‑e de ni rahlz me lahd meññ-Isṟael, no ni ulihbu tzu señ lady meññ, dac‑e de xtziguia xcuerp meññ leeu; ");
INSERT INTO zpg_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","mazyg meññ-nye xguîlmbahñ, wé we ulihbu meññ-Isṟael; no meññ ni nu xiSpirt Dioz leññ xguîlmbahñ, wé we ulihbu nu señ lee, no dac‑e mod-ziaadu lo xleiy Moiséz, ni dac‑e meññ cuguia leeme, mazyg Dioz‑e cuguia leeme. ");
INSERT INTO zpg_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Were naꞌ, ¿bia leeu ni rlesyguia meññ-Isṟael?, ¿o rsahcu tzu señ lady meññ la? ");
INSERT INTO zpg_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Rsahcu de gyre gyzasy mód, porni nier gahc leeyâme psan-no Dioz xtiidz. ");
INSERT INTO zpg_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","No nîcze lahd yâme nehx bzoob diidz mod-ne Dioz, ¿nehxni por leeu nisquiee Dioz no ni ba ne me, nîcze zrieñ di rzoob xtiidz me? ");
INSERT INTO zpg_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","¡Yac, dac‑e ze leeu! Dioz nehx nisquiee me, nîcze gyre meññ risquiee, mod-rnii lo Guehtzy ru queꞌ xtiidz Dioz neu: Zieññ meññ ni uli we rniiy, no rtzooy gan ru rruu meññ contr lii. ");
INSERT INTO zpg_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Hôrrieꞌ gynin beeiy ni ñahcu cuentz diidz. Hor-rtzoo nó ni nehx xñahzû, racnou guieññ mod-rtzoo Dioz xñahzu la, ¿bia nnii nó? ¿Beeiy nnii nó nehx xñahzu rtzoo Dioz rshahl me guîlné dchehsh nó la? ");
INSERT INTO zpg_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","¡Yac, dac‑e ze leeu! Bâḻ Dioz nehx ntzoo ni nac xñahzû, ¿bia mód beeiy ntzoo me guîlguxtisy lguia meññ-nu lo guiedzylie? ");
INSERT INTO zpg_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","No bâḻ dguîlrisquieen nquihñu lehdy ni uli ni ne Dioz tzuguiau mazy la, ¿bia nacu ne me nzaabyaꞌ guîlquie? ");
INSERT INTO zpg_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","No bâḻ ñahcu ze, ¿bia nacu di ctzoo nó ni dirquihñ lehdy ndeedyu ni mos? No nirieꞌ we ni rnii lahd meññ ni rruu contr naa, ne yâme modé galun; per zâ meññ-wé yahc, xñahzu we gynihty yâme lo xguîlquie yâme. ");
INSERT INTO zpg_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Naꞌz naꞌ, ¿nó ni nac meññ-Isṟael, ma rsahc nó que zrieñ meññ la? ¡Yac, dac‑e ze leeu! Porni meññ-Isṟael no zegahc meññ-nehx meññ-Isṟael, guîlquie rtzoo mdad gyre yâme, mod-ba bluu noꞌu; ");
INSERT INTO zpg_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","mod-rnii lo Guehtzy ru queꞌ xtiidz Dioz neu: Ñaz-lo Dioz nehx nu meññ-tziaawy, nehx nu ndruhty gahc; ");
INSERT INTO zpg_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ndruhty di ne guieññ, ndruhty di ne gyo Dioz. ");
INSERT INTO zpg_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Gyre meññ ba psaꞌn Dioz beeiy ni bynityxñahz, gyre yâme pur meññ-dirquihñ lee. Ndruhty nehx rtzoo ni nac xñahzû, nehx nu ndruhty gahc. ");
INSERT INTO zpg_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ruꞌ yâme zidguiahcu beeiy baa ni nxal; no guîlrisquiee rnii yâme. Zidguiahcu beeiy ni nu xvenen mbaaḻ lo luhdz yâme; ");
INSERT INTO zpg_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","tirgahc rgu-dia yâme no rzîbyxyahn yâme. ");
INSERT INTO zpg_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Nshuhc nieꞌ yâme par dziygaꞌdy yâme; ");
INSERT INTO zpg_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","rutisy za yâme rnidylo yâme meññ no rtzuné yâme meññ, ");
INSERT INTO zpg_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","no nehx nann yâme xnahc tzu meññ dzie tziaawy. ");
INSERT INTO zpg_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Nehx rguꞌ ihqy yâme gzacbeeiy yâme Dioz. ");
INSERT INTO zpg_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Nó nann nó gyre ni rnii xleiy Dioz, rniiu ze par meññ ni rtzoo leiy mdad lee, lehdy ndruhty di gynii nehx nu mbehty chehsh, no Dioz ctzoo guîlguxtisy lguia gyre meññ-nu lo guiedzylie; ");
INSERT INTO zpg_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","porni ndruhty nehx zdedy beeiy ni nehx nzahby guîlquie lo Dioz porni rtzoo ni ne leiy, porni nunzy par gann nó nzahby nó guîlquie, leewe nu leiy. ");
INSERT INTO zpg_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Per naꞌ, Dioz ba bluu me mod-rteedy me meññ beeiy ni nehx nzahby guîlquie sinn ctzoo meññ ni ne leiy, no leiy gahc neu mod-wé, no zegahcu lo ni bzaa profet yahc. ");
INSERT INTO zpg_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Dioz rteedy me meññ beeiy ni nehx nzahby guîlquie, bâḻ gylíladzy yâme Jesucrist; rtzoo me modé no gyre meññ ni rlíladzy leeme, nitisy dxu nac yâme. ");
INSERT INTO zpg_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Gyre meññ ptzoo guîlquie, no ziht nu yâme de lo xguîlbyniꞌ Dioz. ");
INSERT INTO zpg_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Per Dioz, por xlaꞌy me, zehzy rteedy me meññ beeiy ni nehx nzahby guîlquie, porni Crist Jesúz bislaa leeyâme. ");
INSERT INTO zpg_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Dioz bdee me Crist guhc beeiy to gun, no byxieꞌ xrieñ me, no mod-wé güdix me xguîlquie meññ ni gylíladzy leeme. Guhcu ze lehdy guieññ rtzoo Dioz ni nac xñahzû, no nehx pshacladzy me pteedy me xguîlquie meññ zehzy ba xtze diaa. ");
INSERT INTO zpg_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Nirieꞌ guhcu ze zegahc, lehdy guieññ de ni Dioz rtzoo me ni nac xñahzû ni naꞌ, no nehx rahp me guîlquie, no rteedy me meññ beeiy ni nehx nzahby guîlquie porni rlíladzy yâme Jesúz. ");
INSERT INTO zpg_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","¿Bá glo naꞌ riaꞌn ni rniguia meññ? ¡Riaꞌnu diby lad! ¿Bia nacu? ¿Porni rtzoo meññ ni ne leiy la? Yac, mazyg porni rlíladzy meññ Crist. ");
INSERT INTO zpg_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","No leewe ba nann nó hor-gylíladzy meññ Crist, rteedy Dioz leeyâme beeiy ni nehx nzahby guîlquie, no dac porni rtzoo yâme ni ne xleiy Moiséz. ");
INSERT INTO zpg_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","¿Nehxni Dioz nunzy xDioz meññ-Isṟael leeme? ¿Dâs‑e zegahc xDioz meññ-nehx meññ-Isṟael leeme la? Uliu xDioz yâme we leeme zegahc, ");
INSERT INTO zpg_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","porni tohzy Dioz‑e nu. No meññ ni nu señ lady no rlíladzy yâme Crist la, Dioz cteedy leeyâme beeiy ni nehx nzahby guîlquie. No zegahc meññ-nehx nu señ lady no rlíladzy yâme Crist la, Dioz cteedy leeyâme beeiy ni nehx nzahby guîlquie. ");
INSERT INTO zpg_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Were naꞌ, ¿porni rlídadzy nó Crist, mboo nó diby lad ni ne xleiy Dioz la? ¡Yac, dac‑e ze leeu! Mazyg ma gatzoo nó ni ne xleiy Dioz porni rlídadzy nó Crist. ");
INSERT INTO zpg_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","¿Bia beeiy nnii nó de ni guhc dtadgul noꞌ Braṉ ni güyuꞌ ba xtze? ");
INSERT INTO zpg_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Bâḻ ñahc Braṉ beeiy ndedy me beeiy ni nehx nzahby guîlquie por behch yahc ni ptzoo me, were ñuꞌ bia nacu nguguia me leegahcme, per nehx nsahcu lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Porni lo Guehtzy ru queꞌ xtiidz Dioz neu: “Braṉ bylíladzy me Dioz, no leewe pteedy Dioz leeme beeiy ni nehx nzahby guîlquie.” ");
INSERT INTO zpg_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Per naꞌ, dxu rtzoo dziiñ riax me, no ni rcaꞌ me dac‑e rady meu, mazyg rcaꞌ me sahc xchieñ dziiñ‑e ni ptzoo me. ");
INSERT INTO zpg_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Dioz rteedy me meññ beeiy ni nehx nzahby guîlquie, dac por behch ni ntzoo me, mazyg porni rlíladzy me Dioz ni rteedy meññ-dirquihñ beeiy ni nehx nzahby guîlquie. ");
INSERT INTO zpg_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ṟeiy-Davit gahc günii dxu ñahc beeiy meññ ni cteedy Dioz lee beeiy ni nehx nzahby guîlquie dac por behch yahc ni ntzoo me. ");
INSERT INTO zpg_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Ne ṟeiy-Davit: Dxu ñahc beeiy meññ ni rsiaaḻladzy Dioz ni dirquihñ ni nac yâme, no rteedy me xguîlquie yâme zehzy. ");
INSERT INTO zpg_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Dxu ñahc beeiy meññ ni nehx ritsêlou Dioz xguîlquie yâme. ");
INSERT INTO zpg_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","¿Nehxni laꞌy nacu nunzy par meññ ni nu señ lady, o zegahcu par meññ-nehx nu señ lady la? Ne noꞌ Dioz pteedy me Braṉ beeiy ni nehx nzahby guîlquie porni bylíladzy me Dioz. ");
INSERT INTO zpg_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Per ¿buc pteedy Dioz Braṉ beeiy ni nehx nzahby guîlquie? ¿Bylux de ni güyuꞌ señ lady me la? Yac, dac‑e bylux de ni güyuꞌ señ lady me, mazyg antzy‑e. ");
INSERT INTO zpg_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","No güyuꞌ señ lady Braṉ, no bdeedyu diidz nacu beeiy to sell de ni pteedy Dioz leeme beeiy ni nehx nzahby guîlquie, porni bylíladzy me Dioz antzy ni tzu señ lady me. Mod-wé guhc me beeiy xtad gyre meññ ni rlíladzy Dioz, nîcze nehx nu señ lady yâme, per Dioz cteedy leeyâme beeiy ni nehx nzahby guîlquie, porni rlíladzy yâme. ");
INSERT INTO zpg_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","No Braṉ zegahc zidguiahc me beeiy xtad meññ-ba nu señ lady, no rlíladzy yâme Dioz mod-bylíladzy Braṉ antzy ni tzu señ lady me. ");
INSERT INTO zpg_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Dioz bdee xtiidz me Braṉ no meññ ni ziaad de lo xfamily Braṉ de ni gac scâsy xiiñ yâme gyre meññ-nu lo guiedzylie; nirieꞌ naꞌ, dac‑e porni ptzoo Braṉ ni ne xleiy Moiséz, mazyg porni bylíladzy me Dioz, no leewe pteedy Dioz leeme beeiy ni nehx nzahby guîlquie. ");
INSERT INTO zpg_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Per bâḻ nunzy meññ ni rtzoo ni ne xleiy Moiséz ycaꞌ yâme ni ba bdee Dioz la, were ba xleꞌ nlíladzy yâme, no ba nehx nquihñ ni ba bdee Dioz xtiidz me. ");
INSERT INTO zpg_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Porni xleiy Moiséz zidnou xguîlné Dioz; per ru nehx nu leiy la, zegahc nehx zahp meññ doḻ de ni nehx rtzoo yâme ni neu. ");
INSERT INTO zpg_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Leewe, lehdy di gynihty ni bdee Dioz xtiidz me ni ba ra me Braṉ par gyre meññ ni ziaad de lo xfamily me, guhcu to laꞌy ni gudy Braṉ porni bylíladzy me, no dac‑e nunzy par meññ-rtzoo ni ne xleiy Moiséz leeu, mazyg zegahc par meññ ni rlíladzy Dioz mod-bylíladzy Braṉ. Mod-wé Braṉ zidguiahc me beeiy dtad gyre nó, ");
INSERT INTO zpg_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","mod-rnii lo Guehtzy ru queꞌ xtiidz Dioz: “Ptzon lii beeiy xtad meññ-xtahl nacióṉ.” Nirieꞌ we Dioz ni bylíladzy Braṉ lee, Dioz ni rispahñ mînguty, no ni rnii ni gac ziaꞌr beeiy ni ba guhc. ");
INSERT INTO zpg_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Nîcze rluu nehx beeiy ñahp Braṉ xiiñ, per bylíladzy me no güliahz me, leewe guhc me beeiy xtad meññ-xtahl nacióṉ, mod-ra Dioz leeme: “Ze we gacxtahl meññ ni ziaad de lo xfamilyiꞌ.” ");
INSERT INTO zpg_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Per Braṉ nehx psaꞌn me de ni rlíladzy me, mazyg ma bylíladzy me, nîcze nann me ba yahc za xtze me porni ba rahp me casy diby gayuu ihz, no zegahcu tziahl me, Sar, di raḻ gap xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","No nehx cueꞌladzy me diidz ni bdee Dioz leeme, mazyg ma bylíladzy me lee, no modé ma bzacbeeiy me Dioz; ");
INSERT INTO zpg_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","nehx cueꞌladzy Braṉ mbehty gahc de ni Dioz beeiyu lee ctzoo gyre ni ba bdee xtiidz me. ");
INSERT INTO zpg_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","No leewe Dioz pteedy leeme beeiy ni nehx nzahby guîlquie. ");
INSERT INTO zpg_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","No dac‑e nunzy par Braṉ güyaau lo guehtzy de ni pteedy Dioz leeme beeiy ni nehx nzahby guîlquie, ");
INSERT INTO zpg_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","mazyg zegahc‑e güyaau par nó, de ni Dioz steedy me nó beeiy ni nehx nzahby guîlquie, porni rlídadzy nó Dioz ni bispahñ Jesúz ni rtzoo mdad nó. ");
INSERT INTO zpg_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Dioz bdee me Jesúz guhty por dguîlquie nó, no gübahñ lehdy tedy nó beeiy ni nehx nzahby guîlquie. ");
INSERT INTO zpg_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Dioz pteedy me nó beeiy ni nehx nzahby guîlquie porni bylídadzy nó Jesucrist, no leewe nu nó dzie tziaawy no Dioz por Jesucrist ni rtzoo mdad nó. ");
INSERT INTO zpg_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Porni bylídadzy nó Crist, leewe ba nu nó gahsh no Dioz, no zaꞌgndzi nu nó no leeme. No rxihly nó lóni gabiaaz nó tzu nó lo xguîlbyniꞌ me. ");
INSERT INTO zpg_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","No dac nunzy nirieꞌ, mazyg zegahc rxihly nó hor-rdedy nó ni nadz yahc, porni nann nó hor-rdedy nó ni nadz la, racnou lehdy ctibdadzy nó; ");
INSERT INTO zpg_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","no de ni rtibdadzy nó, zacnou gyxilyno Dioz nó; no de ni rxilyno Dioz nó, zacnou cuiaaz nó ni ba ne me. ");
INSERT INTO zpg_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","No de ni cuiaaz nó ni ba ne me la, nehx ristuꞌu nó, porni Dioz bdee me xguîlndzi me leññ dguîlmbahñ nó por Spirt-Sant ni bdee me nó. ");
INSERT INTO zpg_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Dze-guhc nó meññ-dirquihñ no di raḻ nlaa nó de lo guîlnadz, Crist guhty me por nó dze-ba byzaꞌ dzé ni nac diidz. ");
INSERT INTO zpg_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nann nó ngannu we par to meññ, ñehty me xilgar sto meññ, nîcze ñahcu por to meññ-tziaawy; per duhn dxuhch ñehty por to ni ulihbu meññ-tziaawy. ");
INSERT INTO zpg_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Per Dioz naꞌ, rluu me xguîlndzi me nó, nîcze guhc nó meññ-guîlquie, Crist bidguiehty me por nó. ");
INSERT INTO zpg_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","No naꞌ, gumm ba rdedy nó beeiy ni nehx nzahby guîlquie por xrieñ Crist ni byxieꞌ dze-guhty me la, nanndoo nó gylaa nó por leeme de lo xguîlné Dioz. ");
INSERT INTO zpg_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Porni dze-güyuꞌ guîlrdziaꞌdzy entr nó no Dioz, güloo me ni rca lehdy gydzihñ nó lo me mos por xguîlguhty Xiiñ me. No naꞌ, gumm ba bydzihñ nó mos lo me la, mahbu we zlaa nó porni mbahñ Xiiñ me. ");
INSERT INTO zpg_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","No nehx nunzy nirieꞌ, mazyg zegahc rxilyno nó Dioz por Jesucrist ni rtzoo mdad nó, porni por Crist ba bydzihñ nó mos lo Dioz. ");
INSERT INTO zpg_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Guîlquie naꞌ, güyuꞌu lo guiedzylie por xtoḻ tohzy mpyquie ni le Adáṉ, no porni güyuꞌ guîlquie, leewe güyuꞌ guîlguhty, no modé guîlguhty güdedyu gyre meññ porni gyre meññ ptzoo guîlquie. ");
INSERT INTO zpg_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Dze-dgueññ tzu xleiy Moiséz ba nu guîlquie lo guiedzylie, per ru nehx nu leiy, zegahc guîlquie nehx rcaꞌ Dioz cuentu. ");
INSERT INTO zpg_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Per glo xtiémp Adáṉ no xtâ xtiémp Moiséz, guîlguhty ptzoou mdad gayehty meññ, nîcze xguîlquie yâme nehx guhcu mod-ptzoo Adáṉ, di nzobdiidz me; no ni ptzoo Adáṉ, rdeeu diidz de Crist ni guiaad. ");
INSERT INTO zpg_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Per xguîlquie Adáṉ, nehx niygahlu laꞌy ni riscady Dioz nó. No por xguîlquie me, guhty xtahl meññ; per laꞌy ni riscady Dioz nó por Jesucrist, ma xroꞌu lehdy tzu xtahl meññ mos. ");
INSERT INTO zpg_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Xguîlquie tohzy Adáṉ nehx niygahlu laꞌy ni riscady Dioz meññ; porni de tohzy guîlquie guzlo ganihty gyre meññ lou, per por xlaꞌy Dioz rdedy meññ beeiy ni nehx nzahby guîlquie, nîcze ptzoo yâme xtahl guîlquie. ");
INSERT INTO zpg_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Bâḻ por xguîlquie tohzy Adáṉ, guzlo gatzoo guîlguhty mdad gyre meññ, mahbu lo guîlmbahñ ni nehx zluhx ctzoo yâme gan por tohzy Jesucrist, porni cuaꞌ yâme xroꞌ xlaꞌy Dioz, no rdedy yâme beeiy ni nehx nzahby guîlquie. ");
INSERT INTO zpg_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Leewe por tohzy xguîlquie Adáṉ rnihty gyre meññ lo guîlquie, modé gahc por tohzy ni nac xñahzû ni ptzoo Crist beeiy tedy gyre meññ beeiy ni nehx nzahby guîlquie lehdy gap yâme guîlmbahñ no Dioz. ");
INSERT INTO zpg_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Sca-ze porni tohzy Adáṉ nehx bzobdiidz me Dioz la, xtahl meññ guhc meññ-guîlquie; modé gahc‑e tohzy Crist, porni bzobdiidz me Dioz, leewe zdedy xtahl meññ beeiy ni nehx nzahby guîlquie. ");
INSERT INTO zpg_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Leiy naꞌ, güyuꞌu lehdy gydáhl guîlquie; per lóni bydáhl guîlquie la, ba mahbu bydáhl xlaꞌy Dioz. ");
INSERT INTO zpg_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Leewe, sca-ze guîlquie ptzoo mdad lehdy güyuꞌ guîlguhty la, modé gahc laꞌy ni rdee Dioz, rtzoou mdad lehdy rdedy nó beeiy ni nehx nzahby guîlquie, no lehdy gap nó guîlmbahñ ni nehx zluhx por Jesucrist, ni rtzoo mdad nó. ");
INSERT INTO zpg_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","¿Bia b