﻿USE sofia;
DROP TABLE IF EXISTS sofia.zpcNT_vpl;
CREATE TABLE zpcNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zpcNT_vpl WRITE;
INSERT INTO zpcNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ni rguixogueꞌn quie ja xuzixtaꞌo Jesucristo. Naca Abraham len rey David xuzixtaꞌo Jesucristo. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham guquëꞌ xuzi Isaac, naꞌ Isaac guquëꞌ xuzi Jacob, naꞌ Jacob guquëꞌ xuzi Judá len ja bichinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Naꞌ Judá guquëꞌ xuzi Fares len Zara, naꞌ lao z̃naꞌjëꞌ Tamar. Naꞌ Fares guquëꞌ xuzi Esrom, naꞌ Esrom guquëꞌ xuzi Aram. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Naꞌ Aram guquëꞌ xuzi Aminadab, naꞌ Aminadab guquëꞌ xuzi Naasón, naꞌ Naasón guquëꞌ xuzi Salmón. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Naꞌ Salmón guquëꞌ xuzi Booz, naꞌ lao z̃naꞌnëꞌ Rahab. Naꞌ Booz guquëꞌ xuzi Obed, naꞌ lao z̃naꞌnëꞌ Rut. Naꞌ Obed guquëꞌ xuzi Isaí. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Naꞌ Isaí guquëꞌ xuzi rey David, naꞌ rey David lënëꞌ z̃gula Urías gucajëꞌ xuzi z̃naꞌ Salomón. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Naꞌ Salomón guquëꞌ xuzi Roboam, naꞌ Roboam guquëꞌ xuzi Abías, naꞌ Abías guquëꞌ xuzi Asa. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Naꞌ Asa guquëꞌ xuzi Josafat, naꞌ Josafat guquëꞌ xuzi Joram, naꞌ Joram guquëꞌ xuzi Uzías. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Naꞌ Uzías guquëꞌ xuzi Jotam, naꞌ Jotam guquëꞌ xuzi Acaz, naꞌ Acaz guquëꞌ xuzi Ezequías. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Naꞌ Ezequías guquëꞌ xuzi Manasés, naꞌ Manasés guquëꞌ xuzi Amón, naꞌ Amón guquëꞌ xuzi Josías. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Naꞌ Josías guquëꞌ xuzi Jeconías len ja bichinëꞌ tiempo cati unitaꞌ benꞌ Babilonia cati yahuaꞌajëꞌ preso benꞌ Israel lao yedyi quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Te beyudyi naꞌ, Jeconías guquëꞌ xuzi Salatiel, naꞌ Salatiel guquëꞌ xuzi Zorobabel. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Naꞌ Zorobabel guquëꞌ xuzi Abiud, naꞌ Abiud guquëꞌ xuzi Eliaquim, naꞌ Eliaquim guquëꞌ xuzi Azor. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Naꞌ Azor guquëꞌ xuzi Sadoc, naꞌ Sadoc guquëꞌ xuzi Aquim, naꞌ Aquim guquëꞌ xuzi Eliud. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Naꞌ Eliud guquëꞌ xuzi Eleazar, naꞌ Eleazar guquëꞌ xuzi Matán, naꞌ Matán guquëꞌ xuzi Jacob. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Naꞌ Jacob guquëꞌ xuzi José, benꞌ quie María, naꞌ María guquëꞌ z̃naꞌ Jesús, benꞌ naca Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Lao tiempo uzu Abraham hasta bdyinnan tiempo uzu rey David, udaohue chidaꞌ tiempo unitaꞌjëꞌ. Lëscanꞌ lao tiempo uzu rey David hasta bdyinnan tiempo yehuaꞌa benꞌ Babilonia benꞌ Israel preso yedyi quiejëꞌ, udaohue itu chidaꞌ tiempo unitaꞌjëꞌ. Lëscanꞌ lao tiempo yehuaꞌa benꞌ Babilonia benꞌ Israel preso yedyi quiejëꞌ hasta bdyinnan tiempo golo Cristo, udaohue itu cueꞌ chidaꞌ tiempo unitaꞌjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Caora cati golo Jesucristo guca caniga: Z̃naꞌnëꞌ María napëꞌ compromiso utzaganaꞌlënëꞌ José. Pero antes binesiꞌ laguedyijëꞌ sujëꞌ tuz̃e, caora naꞌ gucabëꞌ José banuꞌa María xcuidiꞌ. Pero por nun quie Bichi Be quie Diuzi nuꞌanëꞌ xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José naquëꞌ benꞌ huen bireꞌennëꞌ gaohuëꞌ María xquia lao yedyi. Reꞌennëꞌ usannëꞌ lenëꞌ sin que inezi ja benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tu racanëꞌ pensari bi huenëꞌ, cati ptilalao tu ángel quie Diuzi lenëꞌ lao bichi gala quiëꞌ. Naꞌra una ángel rëbinëꞌ lëbëꞌ: ―José, z̃iꞌi suba David luëꞌ, bidzeboꞌ siuꞌ María gacanëꞌ z̃guloꞌ, porque nun quie Bichi Be quie Diuzi banuꞌanëꞌ xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lëbëꞌ su tu z̃iꞌinëꞌ, naꞌ hueloꞌ laobiꞌ JESUS. Canaꞌ hueloꞌ laobiꞌ porque z̃iꞌinëꞌ ute uselabiꞌ dulaꞌ xquia quie benꞌ yedyi quiebiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yugulu cabëꞌ guca naꞌ, bzunan diꞌidzaꞌ quie Diuzi cabëꞌ una Diuzi lao naꞌa tu benꞌ udixogueꞌ xtiꞌidzaꞌnëꞌ tiempote. Cani unëꞌ dza naꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Huazu tu nigula cuidiꞌ, benꞌ binesulë beꞌmbyu, huaꞌanëꞌ tu z̃iꞌinëꞌ. Naꞌ siꞌ laobiꞌ Emanuel. Ta inaro xtiꞌidzaꞌro: Zëlë Diuzi raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cati udëlebë José lao bichi gala quienëꞌ, bënëꞌ cabëꞌ gudyi ángel quie Diuzi lëbëꞌ. Aoz̃iꞌnëꞌ María para z̃gulanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero biuzulënëꞌ lëbëꞌ cabëꞌ rzulë ja benëꞌ z̃gulajëꞌ hasta que golo z̃iꞌinëꞌ nëro. Naꞌ bëꞌnëꞌ lao z̃iꞌinëꞌ JESUS. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Cati golo Jesús lao yedyi Belén ga nebaba Judea, caora naꞌ uzu tu benꞌ lao Herodes naquëꞌ rey. Naꞌra bdyin ja benꞌ zaꞌ zacaꞌ ga rlë obidza, bdyinjëꞌ ciudad Jerusalén. Nacajëꞌ benꞌ psëdi quie bélo. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Naꞌra unabajëꞌ: ―¿Gaz̃i zu rey quie benꞌ Israel, benꞌ zagolo? Nitaꞌndoꞌ zacaꞌ ga rlë obidza blëꞌëndoꞌ bélo ta naca seña golobiꞌ. Quie lenaꞌ zaꞌndoꞌ ta gapalaꞌnndoꞌbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cati unezi rey Herodes cabëꞌ unayaquëꞌ, lega ptëbi pensari quienëꞌ lëbëꞌ. Lëscanꞌ yugulu ja benꞌ ciudad Jerusalén, lega ptëbi pensari quiejëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Naꞌra guz̃i rey Herodes yugulu ja xanꞌ pxuzi len ja benꞌ rusëdi ja ley rnao benꞌ Israel. Naꞌ unabanëꞌ rëbinëꞌ lëjëꞌ: ―¿Ganꞌ galo benꞌ naca Cristo? ");
INSERT INTO zpcNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Naꞌ ra unajëꞌ rëbijëꞌ lëbëꞌ: ―Galoguëꞌ yedyi Belén ga nebaba Judea, porque cani rnën lëꞌë guichi bë profeta dza naꞌte: ");
INSERT INTO zpcNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Leꞌe benꞌ yedyi Belén quie yu nebaba Judá, baꞌalaꞌcazi naca yedyi quiele yedyi daoꞌ, hualo ladole tu benꞌ inabëꞌra, benꞌ inabëꞌ benꞌ Israel, benꞌ quie Diuzi. Canaꞌ rnën lëꞌë guichi. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Naꞌra balarazi guz̃i rey Herodes yaca benꞌ psëdi quie bélo. Unabanëꞌ lëjëꞌ dyëꞌëdi bi tiempo golo bélo. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Naꞌ useꞌelaꞌnëꞌ lëjëꞌ Belén rëbinëꞌ lëjëꞌ: ―Uletzio Belén inabale dyëꞌëdi bi raca quie xcuidiꞌ. Cati babedzelelebiꞌ nadetixogueꞌle nëꞌëdiꞌ tacuenda guidariaꞌ gapalaꞌnaꞌbiꞌ. ―Canaꞌ unanëꞌ rëbinëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Te beyudyi una rey Herodes gudyijëꞌ lëjëꞌ canaꞌ, naꞌra zio benꞌ psëdi quie bélo. Naꞌra lëbélo blëꞌëjëꞌ caora nitaꞌjëꞌ zacaꞌ ga rlë obidza, udyialaona laojëꞌ hasta que bdyinnan laohue ga zu xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Cati blëꞌëjëꞌ ga bdyin bélo, lega bedaohuetzeguejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Caora uyuꞌujëꞌ luꞌu yuꞌu, blëꞌëjëꞌ xcuidiꞌ lëbiꞌ z̃naꞌbiꞌ María. Naꞌra uditzuz̃ibijëꞌ udapalaꞌnjëꞌ bdaoꞌ naꞌ. Naꞌra laosalotejëꞌ caja quiejëꞌ nuꞌajëꞌ, bëꞌjëꞌbiꞌ regalo ta nuꞌajëꞌ, bëꞌjëꞌbiꞌ oro len yalo len ja aceite z̃io. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Beyudyi naꞌ, guca tu chopa dza nitaꞌjëꞌ naꞌ cati uxusajëꞌ de que bireyaꞌalaꞌ yeyojëꞌ ganꞌ uzaꞌjëꞌ, ganꞌ reꞌ rey Herodes. Quie lenaꞌ uz̃iꞌjëꞌ neza tula zeyojëꞌ yedyi quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ude beyudyi bezaꞌ ja benꞌ psëdi quie bélo yenaꞌjëꞌ xcuidiꞌ, naꞌra uxusa José blëꞌënëꞌ tu ángel quie Diuzi rëbinëꞌ lëbëꞌ: ―Uyasabachiꞌ udëꞌëlaꞌ bdaoꞌ naꞌ len z̃naꞌbiꞌ. Uz̃unolëloꞌbiꞌ tziolaꞌobiꞌ yu nebaba Egipto. Naꞌ yegaꞌnlaꞌobiꞌ hasta que iniaꞌ luëꞌ gala tzioꞌ, porque rey Herodes hueguiloguëꞌbiꞌ ta gutiëꞌbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Naꞌra udëlebë José, uyasanëꞌ, uz̃iꞌnëꞌ xcuidiꞌ len z̃naꞌbiꞌ lao rëla ziojëꞌ yu nebaba Egipto. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Naꞌzi begaꞌnjëꞌ ulezajëꞌ uzujëꞌ hasta que bdyin hora guti rey Herodes. Canaꞌ guca tacuenda bzu diꞌidzaꞌ quie Diuzi cabëꞌ gudyinëꞌ profeta rëbinëꞌ lëbëꞌ cani: “Yu nebaba Egipto babeyëz̃aꞌ z̃iꞌinaꞌ yerobiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cati gucabëꞌ rey Herodes uz̃iꞌ ja yëꞌ benꞌ psëdi quie bélo, naꞌra bdzaꞌnëꞌ, bënëꞌ mandado gati ja xcuidiꞌ de chopa iza huio para z̃anle, biꞌ necuaꞌ Belén len ja biꞌ necuaꞌ yedyi regaꞌn gaꞌalaꞌ. Canaꞌ bënëꞌ mandado según cabëꞌ tiempo una ja benꞌ psëdi quie bélo gudyijëꞌ lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Canaꞌ bzu diꞌidzaꞌ quie profeta Jeremías caora unëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Yero tu rchiꞌ ja benꞌ yedyi Ramá, rbedyijëꞌ rnayaꞌjëꞌ. Naꞌ rbedyi ja nigula quie ja benꞌ Israel por nun quie z̃iꞌijëꞌ. Bireyudyicazi cuedyijëꞌ ta yezujëꞌ gusto danꞌ aguti z̃iꞌijëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pero bëꞌ beyudyi guti rey Herodes, caora naꞌ ptilalao tu ángel quie Diuzi lao bichi gala quie José ga zunëꞌ yedyi nebaba Egipto. Naꞌra gudyinëꞌ lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Uyasa, uz̃iꞌlë xcuidiꞌ len z̃naꞌbiꞌ. Uleyozi lao yedyi nebaba Israel, porque aguti yaca benꞌ reꞌen guti xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Naꞌra uyasa José uz̃iꞌnëꞌ xcuidiꞌ len z̃naꞌbiꞌ, ziolënëꞌ lëbiꞌ lao yedyi ga nebaba Israel. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero cati unezi José rnabëꞌ Arquelao lao laza xuzinëꞌ Herodes, naꞌra bdzebinëꞌ yeyonëꞌ naꞌ. Bdzebinëꞌ como danꞌ aoxusanëꞌ ta bitzionëꞌ estado Judea. Quie lenaꞌ zionëꞌ estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Caora bdyinnëꞌ naꞌ, naꞌra zionëꞌ tzesunëꞌ yedyi Nazaret. Canaꞌra bzu diꞌidzaꞌ quie ja profeta ca unajëꞌ de quie ina ja benëꞌ naca Jesús benꞌ yedyi Nazaret. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Naꞌra uyo Juan bautista yu nebaba Judea ga naca lato dachi. Uyonëꞌ yetixogueꞌnëꞌ ja benëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Naꞌra nëꞌ rëbinëꞌ lëjëꞌ: ―Reyaꞌalaꞌ utzaꞌle pensari quiele usanle ca tamala ruele, porque baruen bago dza inabëꞌ Diuzi lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Quie Juan unë profeta Isaías caora unëꞌ: Huazu benꞌ naꞌ lao lato dachi ga bidyia yuꞌu. Huanëꞌ zidzo rëbinëꞌ laguedyinëꞌ caniga: “Huele hueluba neza quiele cuenda huida benꞌ naca xaꞌnro, usalole tu neza li.” ");
INSERT INTO zpcNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Guco Juan laꞌariꞌ de guitzaꞌ quie z̃aba camello. Naꞌ tu cincho guidi bdzeꞌnëꞌ lëꞌënëꞌ. Udaonëꞌ bëchiꞌzu, hueꞌenëꞌ bdyinꞌdaoꞌ quie bezu cera ta rdzela guixiꞌ daoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Naꞌ rio ja benꞌ Jerusalén renaꞌjëꞌ ruzënagajëꞌ quienëꞌ. Lëzi rio ja benꞌ yedyi nebaba Judea len ja benꞌ nitaꞌ gaꞌalaꞌ ga de yao Jordán. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Caora naꞌ cati uxubalëpijëꞌ dulaꞌ xquia quiejëꞌ, naꞌra bëꞌ Juan laojëꞌ luꞌu yao Jordán. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Cati blëꞌë Juan bdyin ja benꞌ partido fariseo len ja benꞌ partido saduceo zaꞌjëꞌ ganꞌ ruꞌe Juan lao ja benëꞌ, naꞌra nëꞌ rëbinëꞌ lëjëꞌ: ―¡Ca bëla rguiꞌidyiꞌ benëꞌ nacale! ¿Nuz̃i udixogueꞌ leꞌe ta te ilale cabëꞌ castigo quie Diuzi bazaꞌ gaꞌalaꞌzi? ");
INSERT INTO zpcNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ulehue dyaꞌa ta uluꞌen nacan li aotzaꞌ pensari quiele, aruele quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bihuele pensari bihue Diuzi leꞌe castigo por nun quie nacale z̃iꞌi suba Abraham. Porque rniaꞌ leꞌe hasta yo huaca hue Diuzi benꞌ gaca z̃iꞌi Abraham. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ca quie yebandyo baden listo para ichugon yaga ta birbia taz̃ixi ta tzeina, canaꞌ nacarën quiele. Chi bihue quiele xtiꞌidzaꞌ Diuzi ca rnënëꞌ, huataꞌ castigo quiele tziole lao guiꞌ gabila. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nëꞌëdiꞌ tali ruꞌa lao benëꞌ conlë nisa yelaꞌ gacajëꞌ seña de que aotzaꞌ pensari quiejëꞌ aruejëꞌ quie Diuzi. Pero bazaꞌ tu benꞌ zazaꞌra zenao nëꞌëdiꞌ. Lëbëꞌ udzeꞌnëꞌ Bichi Be quie Diuzi luꞌu guicho laxtaꞌo ja benꞌ rale quienëꞌ. Lëzi huenëꞌ mandado tzei yaca benꞌ birale quienëꞌ lao guiꞌ gabila. Nacarëꞌ benꞌ z̃e ca nëꞌëdiꞌ. Tanto nacarëꞌ benꞌ z̃e ca nëꞌëdiꞌ, ni siquiera biyeyaz̃ogaꞌ cuiogaꞌ guidi yuꞌu niꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Bazënëꞌ becueꞌ ta uchaꞌanëꞌ trigo len bëbi quien. Naꞌra yeziꞌchiꞌnëꞌ trigo luꞌu lidyin. Yeyudyin naꞌ uzeinëꞌ bëbi quien lao guiꞌ ta biyeyulacazi. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naꞌra uzaꞌ Jesús yu nebaba Galilea bdyinnëꞌ ga de yao Jordán ga zu Juan cuenda hueꞌ Juan laonëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Naꞌ biguꞌun Juan hueꞌnëꞌ lao Jesús. Lenaꞌ unëꞌ gudyinëꞌ Jesús: ―Luëꞌla reyaꞌalaꞌ hueꞌloꞌ laohuaꞌ. ¿Naꞌ como bazaoꞌ niga ta huaꞌ laoloꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Naꞌra una Jesús rëbëꞌ Juan: ―Reyaꞌalaꞌcazi hueꞌloꞌ laohuaꞌ, porque canaꞌ reꞌennan huero ta uzuro duz̃e cabëꞌ una Diuzi. Naꞌra guca Juan de acuerdo, bëꞌnëꞌ lao Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Naꞌra beyudyi bëꞌ Juan lao Jesús, bero Jesús luꞌu nisa. Caora naꞌ laoyalote guibá blëꞌë Jesús uyëzi Bichi Be quie Diuzi ca quie ga rëzi paloma. Bdyinnëꞌ ga zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Naꞌra unë Diuzi ga zuëꞌ guibá unëꞌ: ―Lëz̃iꞌinaꞌ ni, nedyëꞌëdaꞌbiꞌ. Redaohuedaꞌ zuaꞌ gusto conlë lëbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Naꞌra guca dza uquiëꞌ Bichi Be quie Diuzi Jesús lao lato dachi ga bidyia yuꞌu. Naꞌ lao lato naꞌ bdyinrë xanꞌ taxiꞌibiꞌ guꞌunna iquixi Jesús huenëꞌ tamala. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Lëganꞌ naꞌ begaꞌn Jesús chopa galo dza len chopa galo yela, biudaohuëꞌ. Bëꞌ guca lao chopa galo dza, naꞌ uduenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Naꞌra ubigaꞌ xanꞌ taxiꞌibiꞌ ganꞌ zë Jesús rëbina lënëꞌ: ―Chi nacoꞌ z̃iꞌi Diuzi, bë mandado iyaca yo niga yëta xtila. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Naꞌra una Jesús rëbinëꞌ taxiꞌibiꞌ: ―Lëꞌë guichi laꞌiya quie Diuzi nan ca niga: “Quele tuzi yelaꞌ huao gaoro yeziꞌro fuerza, denꞌ lëscanꞌ ruen dyiabëꞌ hue quiero ca na Diuzi ta yeziꞌro fuerza.” ");
INSERT INTO zpcNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Naꞌra uquiëꞌ taxiꞌibiꞌ Jesús lao yedyi laꞌiya Jerusalén. Naꞌra pcuëna lënëꞌ guicho idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Naꞌ rëbinan lënëꞌ: ―Chi tali nacoꞌ z̃iꞌi Diuzi, uquino cuinloꞌ guicho idaoꞌ. Bibi ziꞌ gaqueloꞌ, como danꞌ na guichi laꞌiya quie Diuzi ca niga: Iseꞌelaꞌ Diuzi yaca ángel quienëꞌ ta gapajëꞌ luëꞌ. Huidajëꞌ idehuia inaꞌjëꞌ luëꞌ cuenda ni lëꞌëtiꞌ bigacoꞌ ziꞌ chanꞌ naꞌ ga reꞌ yo. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Naꞌra una Jesús gudyinëꞌ xanꞌ taxiꞌibiꞌ: ―Lëzi narë lëꞌë guichi laꞌiya quie Diuzi: “Bihuenële Diuzi bizinaquezi chi uzunëꞌ diꞌidzaꞌ cabëꞌ unëꞌ, chi biuzunëꞌ diꞌidzaꞌ cabëꞌ unëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tatula uquiëꞌcazi taxiꞌibiꞌ lënëꞌ lao yaꞌa sibi gula. Bluꞌenan lënëꞌ duz̃ete yedyi de lao yedyi layu. Bluꞌenan lënëꞌ cabëꞌ naca yelaꞌ z̃e quien. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Naꞌra una xanꞌ taxiꞌibiꞌ rëbin lënëꞌ: ―Duz̃eten gunaꞌ quioꞌ chi quitzoꞌ z̃iboꞌ tzionlaꞌadyoꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Canaꞌra una Jesús rëbinëꞌ lënan: ―Beyo, Satanás, porque lëꞌë guichi laꞌiya quie Diuzi nan caniga: “Tzionlaꞌadyiꞌro tuzi Diuzi quiero. Tuzi lëbëꞌ huero ca mandado ruenëꞌ quiero.” ");
INSERT INTO zpcNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Naꞌra zeyo taxiꞌibiꞌ ganꞌ zë Jesús. Naꞌ lazaꞌte ja ángel, gucalëjëꞌ lëbëꞌ ta yeziꞌnëꞌ fuerza. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cati unezi Jesús de Juan luꞌu dyiguiba, bebiꞌnëꞌ zeyoguëꞌ yu nebaba Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero bibegaꞌnnëꞌ yedyi Nazaret, uyoguëꞌ yesunëꞌ yedyi lao Capernaum ga reꞌ ruꞌa lagun ga naca bezaꞌ quie yu nebaba Zabulón len yu nebaba Neftalí. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Canaꞌ guca ta bzu diꞌidzaꞌ quie Diuzi bzu profeta Isaías lëꞌë guichi tiempote. Cani rnën: ");
INSERT INTO zpcNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Lao yu nebaba Zabulón len yu nebaba Neftalí, ga de neza zion ruꞌa lagun itzalaꞌ yao Jordán, ga reꞌ yu nebaba Galilea, lao yu naꞌ nitaꞌ benꞌ binaca benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Lëja benꞌ naꞌ rdajëꞌ lao lato lao chula, pero aoseꞌelaꞌ Diuzi benꞌ gacalë lëjëꞌ cabëꞌ racalë xniꞌ guiꞌ lëjëꞌ ta ilëꞌëjëꞌ ga naca chula. Lëja benꞌ naꞌ rdajëꞌ lao lato lao chula, pero useꞌelaꞌ Diuzi benꞌ gacalë lëjëꞌ cabëꞌ racalë xniꞌ guiꞌ lëjëꞌ ta ilëꞌëjëꞌ ga naca chula. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Caora naꞌ uzulao Jesús udixogueꞌnëꞌ benëꞌ xtiꞌidzaꞌ Diuzi unëꞌ: ―Reyaꞌalaꞌ utzaꞌle pensari quiele, porque baruen bago dza inabëꞌ Diuzi lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Zio Jesús yuꞌunëꞌ neza zacaꞌ ruꞌa lagun Galilea. Naꞌ blëꞌënëꞌ chopa benꞌ rze bela. Tunëꞌ laonëꞌ Simón, benꞌ laorë Pedro. Naꞌ itunëꞌ laonëꞌ Andrés. Naca Andrés bichi Simón. Naꞌ yuꞌujëꞌ rulëtojëꞌ yëxo luꞌu nisa. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Naꞌra una Jesús gudyinëꞌ leyaquëꞌ: ―Ulenao nëꞌëdiꞌ. Cabëꞌ ruele cuiole bela yuꞌu luꞌu nisa, canaꞌ uluꞌenaꞌ leꞌe cuiole benꞌ nao xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Laohue naꞌtezi lapsantejëꞌ yëxo quiejëꞌ ziolëjëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Lëꞌëtiꞌzi ude Jesús zioguëꞌ mazara cati blëꞌënëꞌ ichopa ja benëꞌ naca bichëꞌ. Tunëꞌ laonëꞌ Santiago, itunëꞌ laonëꞌ Juan. Nacayaquëꞌ z̃iꞌi Zebedeo. Yuꞌujëꞌ lao barco len xuzijëꞌ rudaꞌjëꞌ yëxo quiejëꞌ. Naꞌra blidza Jesús lëjëꞌ ta unaojëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Naꞌra lapsanrëtejëꞌ barco len xuzijëꞌ ziolëjëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zio Jesús yugulu yedyi nebaba Galilea. Ruzioñeꞌenëꞌ benëꞌ luꞌu idaoꞌ quiejëꞌ laonan sinagoga tu tu yedyi ga rdenëꞌ. Udixogueꞌ Jesús ca naca tahuen quie xtiꞌidzaꞌ Diuzi baruen bagozi dza inabëꞌ Diuzi yedyi layu. Lëscanꞌ beyue Jesús yugulu cueꞌ yelaꞌ hueꞌ yuꞌu ja benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nezijëꞌ quie Jesús yugulu benꞌ nitaꞌ yedyi nebaba Siria. Naꞌ uquiëꞌjëꞌ yaca benꞌ redzagalaoja bitezi yelaꞌ hueꞌ, len benꞌ yuꞌu ja taxiꞌibiꞌ, len benꞌ raca z̃uguti, len benꞌ naz̃i. Naꞌra beyue Jesús lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Zë ja benꞌ unao Jesús. Unao benꞌ yedyi nebaba Galilea, len benꞌ yedyi nebaba Decápolis, len benꞌ ciudad Jerusalén, len benꞌ yedyi nebaba Judea, len benꞌ nitaꞌ yedyi reꞌ itzalaꞌ yao Jordán. Tu canaꞌ ja yedyi udaojëꞌ lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cati blëꞌë Jesús babeguꞌudiꞌ benꞌ zë, naꞌra urënëꞌ tu lao yaꞌa ureꞌnëꞌ. Naꞌra beyëcho ja benꞌ quienëꞌ lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Canaꞌ uzulao Jesús ruzioñeꞌenëꞌ lëjëꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Yedaohue nu yaca benꞌ raca yëchiꞌ ca naca dulaꞌ xquia quie, danꞌ naque quiejëꞌ ga rnabëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yedaohue nu yaca benꞌ raque bayëchiꞌ quie dulaꞌ xquia ta raca lao yedyi layu, danꞌ yeyuez̃elaꞌadyiꞌ Diuzi lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Yedaohue nu yaca benꞌ gaxo, danꞌ gaque quieyaquëꞌ layu ganꞌ una Diuzi hueꞌnëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Yedaohue nu yaca benꞌ reꞌen inao xneza Diuzi cabëꞌ reꞌen gao yoꞌo nu benꞌ rdue rbili, danꞌ Diuzicazi gacalënëꞌ lëjëꞌ ta inaoyaquëꞌ xnezëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Yedaohue nu yaca benꞌ reyëchiꞌlaꞌadyiꞌ benꞌ tula, danꞌ yeyëchiꞌlaꞌadyiꞌ Diuzi lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Yedaohue nu yaca benꞌ anaca yëri laxtaꞌohue, danꞌ hualëꞌëyaquëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Yedaohue nu yaca benꞌ rue dyiabëꞌ cueꞌ chizi laxtaꞌo benëꞌ, danꞌ huëbi Diuzi leyaquëꞌ: “Z̃iꞌinaꞌ leꞌe.” ");
INSERT INTO zpcNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Yedaohue nu yaca benꞌ racatzegue tamala quie por nun quie ruejëꞌ ca reꞌen Diuzi, danꞌ naque quiejëꞌ ga rnabëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Yedaohuele leꞌe cati inayaꞌ benëꞌ leꞌe huenëjëꞌ leꞌe bizinaquezi, siꞌjëꞌ leꞌe yëꞌ, inëjëꞌ quiele por nun quie naole xnezaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yedaohuele sule gusto como danꞌ huataꞌ tu tahuen gula quiele gun Diuzi leꞌe guibá. Yaca benꞌ profeta, benꞌ useꞌelaꞌDiuzi, bizinaquezi psacaꞌrë ja benëꞌ lëjëꞌ dza tiempote tu binenitaꞌle. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","―Ca quie nu zediꞌ naca quiele. Pero chanꞌ naꞌ abeyula zediꞌ, ¿biz̃i huero ta huen dyin tatula? Bira gueꞌennan huenan dyin. Anacan zi ta chuꞌunron ta utzutzu ulio benëꞌ len. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ca quie nu guiꞌ ta ilëꞌë benëꞌ ga naca chula, canaꞌ naca quiele. Tu yedyi reꞌ lao yaꞌa, bigaca igüiꞌonan ta biilëꞌëron. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nunu rusë guiꞌ candil uzulen ta iseniꞌna luꞌu cajón. Reyaꞌalaꞌ uzëron tu luꞌu yuꞌu ga naca sibi cuenda ilëꞌë ja yugulu benꞌ yuꞌu luꞌu yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Canaꞌ naca quiele, reyaꞌalaꞌ tale dyëꞌëdi lao ja benëꞌ tacuenda ilëꞌëjëꞌ ruele tadyaꞌa ca reꞌen Diuzi huele. Canaꞌ hue ja benëꞌ, huejëꞌ benꞌ z̃e Xuziro Diuzi, benꞌ zu guibá. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","―Bigaquele chi zaꞌa chuꞌunaꞌ ley quie Diuzi ta bëꞌnëꞌ Moisés. Quele zaꞌa chuꞌunaꞌ cabëꞌ ta una ja profeta, dechanꞌ zaꞌa ta uzuaꞌ diꞌidzaꞌ cabëꞌ bzujëꞌ lëꞌë guichi laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tali ca rniaꞌ leꞌe, tu lala nede guibá len yedyi layu, ni lëꞌëtiꞌ ta rna lao ley biten canaꞌzi. Uzu diꞌidzaꞌ quien yugulute ca rnan. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Quie lenaꞌ nu benꞌ birue bala ruzu diꞌidzaꞌ ca mandado rue lëꞌë guichi laꞌiya quie Diuzi, lëscanꞌ rusëdijëꞌ benꞌ tula ta bihuejëꞌ bala ca mandado ruen, nacajëꞌ benꞌ latoquiëzi ga rnabëꞌ Diuzi guibá. Pero nu benꞌ rue bala ruzu diꞌidzaꞌ ca mandado rue lëꞌë guichi laꞌiya quie Diuzi, lëscanꞌ rusëdijëꞌ benꞌ tula ta huejëꞌ bala ca mandado ruen, nacajëꞌ benꞌ balaꞌana ga rnabëꞌ Diuzi guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Porque rniaꞌ leꞌe, chi bihue quiele quie Diuzi dyaꞌara, quele cabëꞌ rue ja benꞌ rusëdi ley quie Moisés len ja benꞌ partido fariseo, bisaqueꞌ yeyole ga rnabëꞌ Diuzi guibá. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","―Banezile ca gudyi Moisés xuzixtaꞌoro: “Bireyaꞌalaꞌ gutile benëꞌ. Nutezi benꞌ ruti benëꞌ, reyaꞌalaꞌ ichugobëꞌle quiëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero nëꞌëdiꞌ rniaꞌ leꞌe, nutezi benꞌ idzaꞌ bichi laguedyi, huachugobëꞌ Diuzi quiëꞌ. Lëscanꞌ nutezi benꞌ inayaꞌ bichi laguedyi, huarugobëꞌ quiëꞌ ga reyudyi yelaꞌ rnabëꞌ. Lëscanꞌ nutezi benëꞌ idzaꞌ bichi laguedyi yëbinëꞌ lëjëꞌ: “Benꞌ raca loco luëꞌ” z̃udyizi ruen quienëꞌ tzionëꞌ lao guiꞌ gabila. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Chi zioꞌ nuꞌaloꞌ gun quioꞌ ruꞌaba luꞌu idaoꞌ, naꞌ yezaꞌlaꞌadyoꞌ de ta de quie bichi laguedyoꞌ conlë luëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","naꞌra pcaꞌn gun quioꞌ lao ruꞌaba naꞌzi, zatzioloꞌ tzeguëꞌz̃elaꞌadyoꞌ bichi laguedyoꞌ. Naꞌtera yebiꞌloꞌ hueꞌloꞌ gun quioꞌ lao ruꞌaba. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Chi nu benꞌ rao xquia leꞌe, iquiëꞌjëꞌ leꞌe lao juzgado, tu neziole tu neza, bëꞌlë diꞌidzaꞌ bichi laguedyile, a ver nacala yegaꞌnle yelaꞌ bitziole lao juez. Porque si no, hue juez mandado policía quiëꞌ, udzeꞌjëꞌ leꞌe luꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Diꞌidzaꞌ li rniaꞌ leꞌe, biyerole luꞌu dyiguiba hasta que udyiale dumi ca ta inaba juez leꞌe. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","―Banezile cabëꞌ una xuzixtaꞌoro Moisés canaꞌte: “Bireyaꞌalaꞌ talële nigula tula.” ");
INSERT INTO zpcNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero nëꞌëdiꞌ rniaꞌ leꞌe, nutezi benꞌ rebane ja nigula reꞌennëꞌ bi huenëꞌ lënëꞌ nigula, naꞌ luꞌu guicho laxtaꞌohuëꞌ nacan ca quie bagusilëcazinëꞌ lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Pues ugunro chi tu laoloꞌ yebë ruhuaꞌn luëꞌ dulaꞌ xquia, reyaꞌalaꞌ cuioloꞌn chuꞌunloꞌn zituꞌ, como danꞌ dyaꞌalanꞌ initi tu laoloꞌ, quele ca ta tzioꞌ duz̃etioꞌ lao guiꞌ gabila. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Lëzi ugunro chi naꞌaloꞌ yebë ruhuaꞌn luëꞌ dulaꞌ xquia, reyaꞌalaꞌ ichugoꞌn uruꞌunnan, como danꞌ dyaꞌalanꞌ initi tu naꞌaloꞌ quele ca ta tzio duz̃etioꞌ lao guiꞌ gabila. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","―Lëscanꞌ una xuzixtaꞌoro Moisés dza naꞌte: “Nutezi benꞌ reꞌen usan nigula quie, reyaꞌalaꞌ ichisanëꞌ guichi ga ruꞌen diꞌidzaꞌ bira reꞌennëꞌ sulënëꞌ nigula. Reyaꞌalaꞌ hueꞌnëꞌn nigula quienëꞌ, naꞌtera huazaquëꞌ usannëꞌ nigula quienëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero nëꞌëdiꞌ rniaꞌ leꞌe, chi nu benꞌ rsan z̃gulë, naꞌ beziꞌ z̃gulëꞌ beꞌmbyu tula, nacan xquia quie nigula naꞌ lao Diuzi. Solamente chanꞌ udalë z̃gulëꞌ beꞌmbyu tula, canaꞌra huazaqueꞌ usan beꞌmbyu naꞌ z̃gulëꞌ. Lëscanꞌ nutezi benꞌ beziꞌ nigula psan xquiuhue, nacan xquia quienëꞌ lao Diuzi. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","―Lëscanꞌ banezile ca una Moisés gudyinëꞌ xuzixtaꞌoro: “Reyaꞌalaꞌ uzuloꞌ diꞌidzaꞌ cabëꞌ unaoꞌ hueloꞌ bguntioꞌ Diuzi.” ");
INSERT INTO zpcNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero nëꞌëdiꞌ rniaꞌ leꞌe, bireyaꞌalaꞌ ugunle Diuzi ca cuendazi. Biugunle nu guibá, porque danꞌ ga reꞌ Diuzi rnabëꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Canaꞌrë biugunrële nu yedyi layu, porque danꞌ ga ruzu niꞌa Diuzi. Biugunrële ciudad Jerusalén, porque danꞌ ciudad quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Lëzi biugunrële guichole, porque quele huacale utzaꞌle gacan bezëri gaso ni tu guitzaꞌ guichole. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tuzi iquëbile inale tali. Chi inëro ugunro Diuzi ca cuendazi, quie taxiꞌibiꞌ zaꞌn danꞌ rnëro canaꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","―Lëscanꞌ banezile cabëꞌ una xuzixtaꞌoro Moisés dza naꞌte: “Chi nu benꞌ bdyiaguiꞌnëꞌ tu laoloꞌ, o tu leiloꞌ, o bi ta de quioꞌ, napoꞌ derecho udyiaguiꞌloꞌ tu laohuëꞌ, o tu leiyëꞌ, o bi ta de quiëꞌ tacuenda iyaca laohue quiëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero nëꞌëdiꞌ rniaꞌ leꞌe: Biyeyuele laohue quie ja benꞌ rue mala quiele. Chi nu benꞌ aodapa xagoꞌ, bëꞌle lato capëꞌ itzalaꞌ xagoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chi nu benꞌ hueja cuenda luëꞌ lao ja benꞌ rnabëꞌ ta siꞌnëꞌ camisa quioꞌ, bëꞌrënëꞌ len chamarra quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Chi nu benꞌ ruegadyi luëꞌ huaꞌaloꞌ yuaꞌ quienëꞌ tu legua, biꞌalan chopa legua. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chi nu benꞌ rnabayëchiꞌ luëꞌ bi cosa, bëꞌnëꞌn. Chi nu benꞌ rnaba presta bi ta de quioꞌ, bihueloꞌ zidi, bëꞌnëꞌn ta rnabëꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","―Lëscanꞌ banezile ca una xuzixtaꞌoro dza naꞌte: “Edyëꞌële amigo quiele, udiele benꞌ rudie leꞌe.” ");
INSERT INTO zpcNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero nëꞌëdiꞌ rniaꞌ leꞌe: Edyëꞌëlale benꞌ rudieja leꞌe. Inabale tahuen lao Diuzi quie ja benꞌ rudzeꞌdeꞌ leꞌe. Huele dyaꞌa quie ja benꞌ rudie leꞌe. Ulehueꞌlë Diuzi diꞌidzaꞌ inabale tahuen quie ja benꞌ rnayaꞌ dilalë leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Canaꞌ gacale dugalo z̃iꞌi Xuziro Diuzi zu guibá. Canaꞌ rue Diuzi lënëꞌ obidza quiëꞌ. Useniꞌnan duz̃ete yedyi layu ga nitaꞌ ja benꞌ mala len ja benꞌ huen. Naꞌ rseꞌelaꞌrëꞌ nisa yo quiëꞌ lao ja benëꞌ, laꞌacazi benꞌ rue tadyaꞌa, laꞌacazi benꞌ rue tamala. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chi rapachiꞌle tuzi benꞌ rapachiꞌ leꞌe, biugunle rlëꞌë Diuzi leꞌe benꞌ laxtaꞌo yëri por nun quie ruele canaꞌ. Porque canaꞌ ruerë hasta benꞌ malaja, benꞌ binao xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Chi rda rnëlële tuzi ja benꞌ nubëꞌzile, biugunle tadyaꞌa gula ruele. Porque hasta benꞌ binuebëꞌ Diuzi ruerëjëꞌ canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Reyaꞌalaꞌ gacale benꞌ laxtaꞌo yëri cabëꞌ naca Xuziro Diuzi zu guibá benꞌ laxtaꞌo yëri. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Naꞌ una Jesús: ―Reyaꞌalaꞌ huele cabëꞌ reꞌen Diuzi huele du guicho du laꞌadyiꞌle, pero bihuelen tacuendazi ta ilëꞌë benëꞌ leꞌe nacale benꞌ huen. Chi huelen tacuendazi ta ilëꞌë benëꞌ leꞌe nacale benꞌ huen, bigataꞌ quiele ta gun Xuziro Diuzi leꞌe ga rnabëꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Lenaꞌ cati gacalële benꞌ rdziogue bi cosa, biuluꞌetele ladza inale cani biaꞌ cabëꞌ rue ja benꞌ rionlaꞌadyiꞌ Diuzi de ladzazi caora riojëꞌ luꞌu idaoꞌ, caora rdajëꞌ tu neza. Canaꞌ ruejëꞌ tacuenda inë benëꞌ quiejëꞌ dyaꞌa. Pero tali ca rniaꞌ, tanaꞌzi de babëjëꞌ gan, bibira de hueꞌ Diuzi lëjëꞌ ga rnabëꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero leꞌe cati gacalële benꞌ rdziogue bi cosa, biuluꞌetele ladza yelaꞌ binezi ja benëꞌ chi bi ruele, baꞌalaꞌcazi benꞌ naca bichile. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dyaꞌalanꞌ gacalële benëꞌ balarazi. Naꞌ Xuziro Diuzi rlëꞌënëꞌ cabëꞌ tadyaꞌa ruele balarazi, lënëꞌ gunnëꞌ quiele ga rnabëꞌ guibá. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","―Cati hueꞌlële Diuzi diꞌidzaꞌ, bihuele ca rue ja benꞌ rionlaꞌadyiꞌ Diuzi de ladzazi. Lega raxejëꞌ hueꞌlëjëꞌ Diuzi diꞌidzaꞌ zëtela luꞌu idaoꞌ. Canaꞌ ruejëꞌ con ga ziojëꞌ zacaꞌlao ja benëꞌ. Pero tali ca rniaꞌ, tanaꞌzi de babëjëꞌ ganꞌ. Bibira de hueꞌ Diuzi lëjëꞌ ga rnabëꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero cati hueꞌlële Diuzi diꞌidzaꞌ, reyaꞌalaꞌ ucuiꞌole tu tule tu ga negachiꞌ. Tuzile conlë Xuziro Diuzi hueꞌlëlenëꞌ diꞌidzaꞌ. Naꞌ Xuziro Diuzi rlëꞌënëꞌ cabëꞌ tadyaꞌa ruele balarazi, lënëꞌ gunnëꞌ quiele ga rnabëꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Cati hueꞌlële Diuzi diꞌidzaꞌ, biinale diꞌidzaꞌ ladzazi, bihuele zëtela diꞌidzaꞌ cabëꞌ rue benꞌ binuebëꞌ Diuzi. Ruejëꞌ pensari chi uzënaga Diuzi quiejëꞌ nun quie danꞌ ruꞌelëjëꞌ Diuzi diꞌidzaꞌ zëtela. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bihuele cabëꞌ rue lëjëꞌ, porque danꞌ Xuziro Diuzi banezinëꞌ bidanꞌ rdzioguele cati zainabale laohuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lenaꞌ reyaꞌalaꞌ hueꞌlële Diuzi diꞌidzaꞌ cani: Xuzindoꞌ Diuzi zuloꞌ guibá, naca laꞌiya laoloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Rbezandoꞌ guida dza inabëꞌloꞌ lao yedyi layu cabëꞌ rnabëꞌloꞌ guibá ga zuloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gunoꞌ ta gaondoꞌ quie naꞌadza cabëꞌ ta rdzioguendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Beziꞌz̃e quiendoꞌ cabëꞌ tamala babëndoꞌ cabëꞌ reziꞌz̃endoꞌ tamala bë ja benëꞌ len nëtoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gacalaoꞌ nëtoꞌ ta biiguinondoꞌ lao tamala, ucuasa ucuiꞌoloꞌ tamala zaꞌ gaca quiendoꞌ. Porque tuzoꞌ luëꞌ nacoꞌ ga zelaozi yelaꞌ rnabëꞌ quioꞌ, ga zelaozi yelaꞌ huaca quioꞌ, ga zelaozi yelaꞌ z̃e quioꞌ tuzioli. Amén. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Canaꞌ rniaꞌ leꞌe porque chi leꞌe rziꞌz̃ele quie ja benꞌ rueja tamala quiele, lëscanaꞌ huaziꞌz̃erë Xuziro Diuzi zu guibá quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero chi bisiꞌz̃ele quie laguedyile, bisiꞌz̃erë Xuziro Diuzi dulaꞌ xquia quiele. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","―Cati huele ubasi, bihuenëlaole bayëchiꞌ cabëꞌ rue benꞌ rionlaꞌadyiꞌ Diuzi de ladzazi. Lëjëꞌ ruzutelaojëꞌ bayëchiꞌ tacuenda ilëꞌë ja benëꞌ ruejëꞌ ubasi. Pero tali ca rniaꞌ, tanaꞌzi de babëjëꞌ gan, bibira hueꞌ Diuzi lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero leꞌe cati huele ubasi, ulequibi laole, ulequin guichole dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Canaꞌ huele tacuenda bigacabëꞌ ja benëꞌ de que ruele ubasi. Tuzi Xuziro Diuzi zulënëꞌ leꞌe, gunnëꞌ tadyaꞌa gula quiele guibá ga rnabëꞌnëꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","―Bireyaꞌalaꞌ uzule guichole huele cuinle benꞌ uñaꞌa lao yedyi layu ga reyulazin, ga rbiaguiꞌzin, ga rban benëꞌ len. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Reyaꞌalaꞌ uzule guichole huele quie Diuzi tacuenda utupale yelaꞌ uñaꞌa quiele guibá ga bireyulazin, ga birbiaguiꞌzin, ga bisaqueꞌ cuan benëꞌ len. Chi huele canaꞌ, nacale ca quie yelaꞌ uñaꞌa lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pues ga rutupa ja benëꞌ yelaꞌ uñaꞌa quiejëꞌ, chi lao yedyi layu, chi guibá, lenaꞌ uluꞌen ca bi pensari raquejëꞌ, chi quie cuinzijëꞌ, chi quie Diuzi. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","―Chi ruꞌele lato raca guicho laxtaꞌole pensari dyaꞌa, canaꞌ sí, ruele tadyaꞌa, neyaniꞌ pensari quiele rlëꞌële racalële benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero chi ruꞌele lato zu guicho laxtaꞌole yelaꞌ z̃ëꞌ, canaꞌ sí, huele tamala, nechula pensari quiele, birlëꞌële gacalële benëꞌ. Chi lao laza yuꞌule pensari dyaꞌa, naꞌ ruꞌele lato su guicho laxtaꞌole yelaꞌ z̃ëꞌ, lenaꞌ naca mala gula quiele, nechulatzegue pensari quiele. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","―Nitu nunu saqueꞌ uzu chopa xaꞌne, porque danꞌ udienëꞌ tunëꞌ, naꞌ itunëꞌ idyëꞌënëꞌ, uzunëꞌ diꞌidzaꞌ quie tunëꞌ, naꞌ quie itunëꞌ biuzunëꞌ diꞌidzaꞌ. Canaꞌ naca quiero len Diuzi. Chi nuzu guichoro rzaꞌlaꞌadyiꞌro dumi, bisaqueꞌ uzuro guichoro Diuzi. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","―Rniaꞌ leꞌe, bidëbile quie ta yoꞌole, quie ta gaole, quie ta tebanle, ni quie z̃aba quiele ta gacole. ¿Quele zacaꞌra yelaꞌ neban quiero quele ca ta gaoro? ¿Quele zacaꞌra cuinro quele ca z̃aba quiero? ");
INSERT INTO zpcNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ulenaꞌcara cabëꞌ rue ja bguini rdajabaꞌ ladza. Birazajabaꞌ, bireziꞌjabaꞌ usecho udzeꞌtzaꞌojabaꞌ gaojabaꞌ, nechanꞌ Xuziro Diuzi zu guibá rugaonëꞌjabaꞌ. ¿Binezile zacaꞌra leꞌe quele ca lëjabaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Nuz̃i ca leꞌe huaca huezu huele cuinle igatzo metro yelaꞌ huegoꞌ nun quie rdëbile quie ta rdzioguele? ");
INSERT INTO zpcNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Bixquienꞌ rdëbile nacala gaca idzela z̃aba quiele? Ulenaꞌcara cabëꞌ reꞌeni ja yo guixiꞌ. Biruejan dyin, biruejan laꞌariꞌ ta gaca z̃abajan. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nechanꞌ rniaꞌ leꞌe, ni rey Salomón, baꞌalaꞌcazi guquëꞌ benꞌ uñaꞌa gula, bibdyinnëꞌ sutzaꞌohuëꞌ cabëꞌ zutzaꞌo ja yo guixiꞌ badan gula. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ulenaꞌ cabëꞌ rugaco Diuzi z̃aba guixiꞌ badanzi ta de naꞌadza, baꞌalaꞌcazi du uxezi uzei benëꞌ len, ¿biz̃i binezile ruetera Diuzi tadyaꞌa quiele quele ca nu ja yo guixiꞌ? Leꞌe rdzioguele sudyiꞌilële Diuzi dyëꞌëdi. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Lenaꞌ bireyaꞌalaꞌ idëbile inale: “¿Ga zaꞌ ta gao ta yoꞌoro? ¿Ga zaꞌ z̃aba quiero?” ");
INSERT INTO zpcNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Leꞌe bireyaꞌalaꞌ huele canaꞌ, porque danꞌ canꞌ rue ja benꞌ binuebëꞌ Diuzi. Rdëbijëꞌ rdajëꞌ quilojëꞌ ga idzelejëꞌ ta gaojëꞌ len ta yoꞌojëꞌ. Pero cabëꞌ leꞌe, zu Xuzile benꞌ zu guibá, nezinëꞌ yugulute bidanꞌ rdzioguele. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hueꞌle lato inabëꞌ Diuzi leꞌe, huele ta yuꞌu niꞌa xnezi quie Diuzi ca raxenëꞌ. Naꞌtera gunnëꞌ yugulute ta rdzioguele. ");
INSERT INTO zpcNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bidëbile chi bi tazëdi zaꞌ quiele du uxe du huidzo, porque durpende chanꞌ du uxezi zaꞌrë cuëchilile gacan reglo. Tu dza tu dza rdëbile quien, huele pensari bi gaca ta cueꞌlina. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Naꞌ una Jesús: ―Bireyaꞌalaꞌ inële quie laguedyile, yelaꞌ biinë Diuzi quiele ca ruele. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Con cabëꞌ rlëꞌële laguedyile, chi benꞌ huen, chi benꞌ mala, canaꞌrë ilëꞌë Diuzi leꞌe. Con cabëꞌ inële quie laguedyile, canaꞌrë inë Diuzi quiele ca ruele. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Cómo nezile yegunniꞌale bigazi tadaoꞌ mala rue benëꞌ, naꞌ binezile yegunniꞌale ca tamala gulatera ruele cuinle? ");
INSERT INTO zpcNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Cómo yëbile laguedyile: “Bencara lato cuiogaꞌ bëbi daoꞌ yuꞌu laoloꞌ”, naꞌ birnaoꞌ cuinloꞌ bichu yaga yuꞌu laoloꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Leꞌe benꞌ rnë diꞌidzaꞌ ladzazi, zaolio bichu yaga yuꞌu laoloꞌ, naꞌtera ilëꞌëloꞌ yebioloꞌ bëbi daoꞌ yuꞌu lao laguedyile. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Bireyaꞌalaꞌ hueꞌle ja becoꞌ ta naca laꞌiya quie Diuzi, porque biz̃i chanꞌ lalëzibaꞌ yeguiꞌimbaꞌ leꞌe. Lëscanꞌ bireyaꞌalaꞌ chuꞌunle ta naca tatzaoꞌ quie Diuzi lao ja cuchi, porque biz̃i chanꞌ utzutzu uliobaꞌn. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","―Chi inabaro Diuzi bi cosa, gunnëꞌn. Chi rguiloro ta naca tali quie Diuzi, huadzeleron. Chi ulidzaronëꞌ, huequëbinëꞌ quiero. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Canaꞌ rniaꞌ leꞌe, porque nu benꞌ rnaba lao Diuzi bi cosa, hueꞌnëꞌn lënëꞌ. Lëscanꞌ nu benꞌ rguilo ta naca tali quie Diuzi, huadzelenëꞌn. Nu benꞌ rulidza Diuzi, huequëbinëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Nuz̃i leꞌe rnaꞌle hueꞌle yola z̃iꞌile lao laza ta rnababiꞌ pan? ");
INSERT INTO zpcNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Nuz̃i leꞌe rnaꞌle hueꞌle bëlala z̃iꞌile lao laza ta rnababiꞌ bela? ");
INSERT INTO zpcNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Chi leꞌe nacale benꞌ z̃ëꞌë, pero nezile hueꞌle tahuen z̃iꞌile, ¡biz̃ira Xuziro Diuzi zu guibá neziterëꞌ hueꞌnëꞌ tahuen benꞌ rnaba len laohuëꞌ! ");
INSERT INTO zpcNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Cabëꞌ reꞌenle huelële laguedyile leꞌe, canaꞌ reyaꞌalaꞌ huerële len laguedyile. Canaꞌ ruen mandado quiele huele lëꞌë guichi ley pcaꞌn Diuzi lao naꞌa Moisés len guichi bë ja benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi tiempote. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","―Taguizi naca ruꞌa yuꞌu quie guibá. Lëruꞌa yuꞌu naꞌ reyaꞌalaꞌ tzuꞌule. Taz̃era naca ruꞌa yuꞌu quie gabila. Lëscanꞌ talaꞌagaꞌra nacarë neza quien. Benꞌ zë gulara reyuꞌujëꞌ ruꞌa yuꞌu naꞌ, reziꞌjëꞌ neza naꞌla. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero taguizi naca ruꞌa yuꞌu quie guibá. Lëscanꞌ taguizi nacarë neza quien. Lëꞌëtiꞌzija naca ja benꞌ ruzuja diꞌidzaꞌ quiaꞌ cabëꞌ rniaꞌ. Lëzijëꞌ redzelejëꞌ neza zeyo guibá. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","―Gapale cuidado quie ja benꞌ huiziꞌ yëꞌ, benꞌ rnaja quie Diuzi rnëjëꞌ. Nacajëꞌ benꞌ zaꞌzija ruejëꞌ gaxo gula cabëꞌ rue becoꞌ z̃iꞌilaꞌ. Pero bëꞌ ruezijëꞌ, dechanꞌ luꞌu laxtaꞌolajëꞌ yuꞌu yelaꞌ snia quiejëꞌ, ruejëꞌ ca rue coyote. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Huezuyezaquele cabëꞌ ruejëꞌ chi balejëꞌ nacajëꞌ benꞌ quie Diuzi. Bicuia bedzuliꞌ lao luba yëchiꞌ. Lëscanꞌ bicuia higo lao yaga yëchiꞌ. Lëcanaꞌ rue ja benꞌ binaca ja benꞌ quie Diuzi. Birlëꞌëro huejëꞌ tadyaꞌa cabëꞌ rue Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yugulu yaga huen rbian taz̃ixi naca dyaꞌa, pero nu yaga median, birbian tadyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tu yaga huen bisaqueꞌ cuian taz̃ixi binaca dyaꞌa. Lëzi tu yaga median bisaqueꞌ cuian taz̃ixi naca dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yugulu yaga birbia ta gaoro ichuguron ibidyin uzeiron. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Naꞌra rniaꞌ leꞌe, según cabëꞌ ruejëꞌ, canaꞌ yezaquele cabëꞌ nacajëꞌ, chi nacajëꞌ cabëꞌ quie tu yaga huen, o chi nacajëꞌ cabëꞌ quie tu yaga median. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","―Quele yugu ja benꞌ na nëꞌëdiꞌ: “Señor, Señor”, yeyojëꞌ guibá ga rnabëꞌ Diuzi, dechanꞌ yaca benꞌ ruzu diꞌidzaꞌ quie Xuzaꞌ, benꞌ zu guibá, lëzijëꞌ yeyojëꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cati idyin dza hue Diuzi juicio, canaꞌ ina benꞌ zë nëꞌëdiꞌ: “Señor, Señor, laoloꞌ bzëtondoꞌ udixogueꞌndoꞌ benëꞌ xtiꞌidzoꞌ. Lëscanaꞌ bzëtondoꞌ laoloꞌ uliondoꞌ taxiꞌibiꞌ yuꞌu ja benëꞌ. Lëscanꞌ bzëtondoꞌ laoloꞌ bëndoꞌ tazë yelaꞌ huaca quioꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero canaꞌra yëpaꞌjëꞌ: “Binubëꞌcazidaꞌ leꞌe. Ulebigaꞌ tzalaꞌla, leꞌe benꞌ bë ja tamala.” Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","―Cani nacan quie yaca benꞌ ruzënaga ruzu diꞌidzaꞌ quiaꞌ. Naca quienëꞌ ca quie tu benꞌ rioñeꞌe, benꞌ bë yuꞌu quie tu lao lachiꞌ ga reꞌrara yu. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Naꞌra ben nisa yosiuꞌ, uyala yao, ben be bedunꞌ, pero bibyalan, porque reꞌn tu lao lachiꞌ ga naca yu huala. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero benꞌ ruzënaga, naꞌ birue quienëꞌ ca rniaꞌ, naca quienëꞌ ca quie tu benꞌ tondo, benꞌ bë yuꞌu quie tu lao yu yolo, yu bireꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bëꞌ ben nisa yosiuꞌ, bëꞌ uyala yao, bëꞌ ben be bedunꞌ, naꞌra byala yuꞌu. Tu casion z̃e gula guca quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cati beyudyi unë Jesús, rebane ja benꞌ zë nitaꞌja naꞌ cabëꞌ ruëꞌ rusëdiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Porque rusëdinëꞌ lëjëꞌ ca quie benꞌ de yelaꞌ rnabëꞌ quie, quele cabëꞌ rusëdi ja benꞌ rusëdi ley pcaꞌn Diuzi lao naꞌa Moisés dza naꞌte. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cati beyëzi Jesús lao yaꞌa, benꞌ zë beyao lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Caora naꞌ laobigaꞌte gaꞌalaꞌ tu benꞌ raca yelaꞌ hueꞌ ta ruzudzoꞌ cuerpo quienëꞌ. Laoditzute z̃ibëꞌ lao Jesús rëbinëꞌ lënëꞌ: ―Señor, chi gueꞌenloꞌ, huuꞌ cule yeyueloꞌ yelaꞌ hueꞌ racaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Naꞌra udan Jesús naꞌanëꞌ lënëꞌ rëbinëꞌ lënëꞌ: ―Hueꞌendaꞌ iyacoꞌ yëri. Canaꞌzi ta una Jesús, labeyacate yelaꞌ hueꞌ racanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Naꞌra una Jesús rëbinëꞌ lënëꞌ: ―Ni tu ganu quixogueꞌloꞌ bi guca beyacoꞌ. Tu uyotezi cuinzoꞌ lao pxuzi. Naꞌ hueꞌloꞌ gun quie Diuzi cabëꞌ mandado bë Moisés yelaꞌ inezi ja benëꞌ abeyacoꞌ yelaꞌ hueꞌ racoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Naꞌra zio Jesús ciudad Capernaum. Lëzi laoyote tu benꞌ naca capitán quie ja soldado quie ciudad Roma ga zë Jesús. Caora naꞌ unabayëchiꞌnëꞌ ");
INSERT INTO zpcNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","rëbinëꞌ Jesús: ―Señor, de tu mozo quiaꞌ raca z̃hueꞌbiꞌ z̃an yuꞌu. Nesecobiꞌ, redzagalaolëbiꞌn, rlatzeguen. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Naꞌra rëbi Jesús lënëꞌ: ―Uletzaꞌ yeyuꞌabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Naꞌra rëbi capitán lënëꞌ: ―Señor, binacaꞌ zi ta hueloꞌnëꞌ z̃e guidatiuꞌ z̃an yuꞌu quiaꞌ. Tu bëꞌzi diꞌidzaꞌ, bë mandado yeyaca mozo quiaꞌ. Nezdaꞌ huazaqueꞌ hueloꞌ tu mandadozi inaoꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","porque lëzi canaꞌ naca quiaꞌ. Zu xaꞌnaꞌ, benꞌ belao rnabëꞌnëꞌ nëꞌëdiꞌ. Lëscanaꞌ napariaꞌ soldado benꞌ rnabiꞌa. Cati rëpaꞌ tujëꞌ: “Tzioꞌ niga”, huayonëꞌ. Cati rëpaꞌ itunëꞌ: “Uda”, huidëꞌ. Cati rëpaꞌ mozo quiaꞌ bi ta huebiꞌ, ruebiꞌn. Canaꞌ nacarë quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cati be Jesús cabëꞌ una capitán rëbinëꞌ lënëꞌ, tu rebanezinëꞌ rëbinëꞌ ja benꞌ zenaoja lënëꞌ: ―Tali rniaꞌ leꞌe, lao yugu ja benꞌ Israel, binedilaꞌ ni tujëꞌ benꞌ rioñeꞌe cabëꞌ rioñeꞌe benꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Rniaꞌ leꞌe, benꞌ zë, benꞌ binaca benꞌ Israel, yedyinjëꞌ gatezi parte yedyi layu cueꞌlëjëꞌ tuz̃e len xuzixtaꞌoro Abraham, len xuzixtaꞌoro Isaac, len xuzixtaꞌoro Jacob ta gaolëjëꞌ lëjëꞌ guibá ga rnabëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero zë benꞌ Israel, benꞌ reyaꞌalaꞌ yeyoja guibá ga zu Diuzi, naca quiejëꞌ tzeguꞌunjëꞌ lao lato lao chula ga cuedyijëꞌ ziꞌlaza gula, ga gaojëꞌ leijëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Naꞌra rëbi Jesús capitán naꞌ: ―Beyo z̃an yuꞌu quioꞌ. Huacacazi cabëꞌ az̃elaꞌadyoꞌ. Caora naꞌtezi labeyacate mozo quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Naꞌra uyo Jesús z̃an yuꞌu quie Pedro. Naꞌ blëꞌënëꞌ z̃naꞌ nigula quie Pedro denëꞌ z̃la, raca z̃hueꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Naꞌra caora uz̃e Jesús nëꞌë, labedubaten. Naꞌra labeyasatëꞌ uzulaohuëꞌ ruꞌenëꞌ laze ta gaojëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cati aochula, uquiëꞌjëꞌ lao Jesús benꞌ zëja raca z̃hueꞌ, benꞌ yuꞌuja bichi be quie taxiꞌibiꞌ. Con tu laꞌanazi diꞌidzaꞌ rebioguëꞌ tzalaꞌla taxiꞌibiꞌ yuꞌujëꞌ. Canaꞌ beyuerënëꞌ yuguja benꞌ raca z̃hueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Canaꞌ bzun diꞌidzaꞌ cabëꞌ una profeta Isaías caora unëꞌ cani: “Lëbëꞌ begubëꞌ yelaꞌ tzen quiero, beyuenëꞌ yelaꞌ hueꞌ quiero.” ");
INSERT INTO zpcNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cati blëꞌë Jesús benꞌ zë baneyëcholënëꞌ, bënëꞌ mandado udelënëꞌ ja benꞌ quienëꞌ itzalaꞌla lagun. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Naꞌra bdyin tu maestro, benꞌ rusëdi ley quie Moisés. Naꞌra gudyinëꞌ Jesús: ―Maestro, reꞌendaꞌ inaohuaꞌ luëꞌ con gatezi zioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Naꞌra bequëbi Jesús quienëꞌ: ―Yaca beꞌezaꞌ, zu beló quiejabaꞌ. Lëscanꞌ ja bguini, dyia lidyijabaꞌ. Pero nëꞌëdiꞌ nacaꞌ bichi yugulu benëꞌ, bizu lidyaꞌ ga idyinaꞌ suaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Itu benꞌ nacarëcazi benꞌ quienëꞌ unëꞌ rëbinëꞌ Jesús: ―Señor, ben lato tzetapaꞌ xuzaꞌ, porque bagatinëꞌ. Naꞌtera yeguidaꞌ inaohuaꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Naꞌra bequëbi Jesús gudyinëꞌ lënëꞌ: ―Unaozi nëꞌëdiꞌ. Bë lato ucachiꞌ yaca benꞌ birue quie xtiꞌidzaꞌ Diuzi xuzoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Naꞌra uyuꞌu Jesús luꞌu barco len ja benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Caora naꞌ bënan tu be bedunꞌ huala gula, rudyigaten nisa rudzon luꞌu barco. Pero rasila Jesús cati ruen canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Naꞌra uyo yaca benꞌ quienëꞌ yesebëjëꞌ lënëꞌ, rëbijëꞌ lënëꞌ: ―¡Señor, psela nëtoꞌ! ¡Areꞌen yëto barco luꞌu nisa! ");
INSERT INTO zpcNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Naꞌra unë Jesús rëbinëꞌ lëjëꞌ: ―¿Bixquienꞌ lega rdzebile? ¡Biralele ucuasa ucuiꞌo Diuzi raꞌo! Naꞌra uyasanëꞌ, udilalënëꞌ be bedunꞌ len nisa. Caora naꞌ bguenan ureꞌn chizi. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Naꞌra rebane ja benꞌ quienëꞌ najëꞌ: ―¿Ca nuz̃i naca benꞌ niga? Lente be bedunꞌ, lente nisa ralen quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Cati bdyin Jesús itzalaꞌ lagun ga lao yu nebaba Gadara, caora naꞌ labdyinte chopa benꞌ bro luꞌu yerobá dyia naꞌ. Rupatejëꞌ yuꞌujëꞌ taxiꞌibiꞌ. Naꞌ bdyinjëꞌ lao Jesús. Tantozi nacajëꞌ benꞌ snia gula, ni tu ganu rerugue te tu neza zacaꞌ ga yuꞌujëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Naꞌra uzulaojan rbedyiyaꞌzijan najan rëbijan Jesús: ―¿Bi de quioꞌ conlë nëtoꞌ zaoꞌ niga, Jesús z̃iꞌi Diuzi? ¿Quele baodyialaolaloꞌ blaꞌloꞌ hueloꞌ nëtoꞌ castigo, naꞌ binedyin hora? ");
INSERT INTO zpcNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gaꞌalaꞌzi ga zë Jesús yuꞌu ja cuchi zë. Lëganꞌ naꞌ laꞌadyiꞌjabaꞌ rguilojabaꞌ ta raojabaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Naꞌra bë ja taxiꞌibiꞌ zëdi rëbijan Jesús: ―Chi yebioloꞌ nëtoꞌ tzalaꞌla, ben lato tzuꞌundoꞌ luꞌu cuchila. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Naꞌra rëbi Jesús lëjan: ―Uletzuꞌujabaꞌ. Naꞌra bero ja taxiꞌibiꞌ yuꞌu ja benëꞌ yetzuꞌujan luꞌu cuchila. Tu chiꞌzi raca canaꞌ, yequinojabaꞌ cuinjabaꞌ tu ruꞌa yaꞌa ga naca stëbi. Laga luꞌu lagun yetzuꞌujabaꞌ uyëpijabaꞌ gutijabaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Quie lenaꞌ yaca benꞌ rapa lëjabaꞌ bez̃unojëꞌ danꞌ bdzebijëꞌ bedyinjëꞌ yedyi quiejëꞌ. Naꞌra uzulaojëꞌ ruꞌejëꞌ diꞌidzaꞌ cabëꞌ guca quie ja benꞌ bero ja taxiꞌibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Naꞌra bro ja benꞌ zë yedyi naꞌ, ziojëꞌ ganꞌ zë Jesús. Laonabayëchiꞌtejëꞌ rëbijëꞌ lënëꞌ: ―Yeroloꞌ yeyoꞌ lao yu quiendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Beyuꞌu Jesús tatula luꞌu barco. Belaꞌguëꞌ itzalaꞌ lagun, bedyinnëꞌ lao yedyi quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Naꞌ biꞌajëꞌ tu benëꞌ z̃i, benꞌ z̃uba lao belaga nuꞌa ja benëꞌ lënëꞌ. Caora blëꞌë Jesús cabëꞌ z̃elaꞌadyiꞌyaquëꞌ yeyuenëꞌ lënëꞌ, naꞌra unëꞌ rëbëꞌ benꞌ raca z̃hueꞌ: ―Bidzeboꞌ, bichaꞌ. Cabëꞌ quie ja dulaꞌ xquia quioꞌ, aoz̃iꞌz̃iaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Naꞌra bala ja maestro, benꞌ rusëdija ley quie Moisés, bëjëꞌ pensari luꞌu guicho laxtaꞌojëꞌ cani: “Huadzaꞌ Diuzi benꞌ niga cabëꞌ diꞌidzaꞌ unëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero como danꞌ anezi Jesús cabëꞌ pensari racajëꞌ, naꞌra unëꞌ rëbëꞌ lëjëꞌ: ―¿Bixquienꞌ racale pensari canaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ca nurlan nacaran yalo huaꞌ quie benꞌ z̃i niga? ¿Nacaran yalo chi yëpaꞌnëꞌ: “Aoz̃iꞌz̃iaꞌ xquia quioꞌ”, o chi nacaran yalo yëpaꞌnëꞌ: “Uyasa, beziꞌ belaga quioꞌ, beyo”? ");
INSERT INTO zpcNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero como nacaꞌ bichi yugulu benëꞌ, lenaꞌ reꞌendaꞌ inezile de yelaꞌ rnabëꞌ quiaꞌ ta siꞌz̃iaꞌ dulaꞌ xquia quie ja benꞌ nitaꞌ lao yedyi layu. Naꞌra unëꞌ rëbinëꞌ benꞌ z̃i: ―Beyasa, beyuꞌa belaga quioꞌ. Beyo z̃an yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Naꞌra beyasëꞌ zeyoguëꞌ z̃an yuꞌu quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Caora blëꞌë ja benëꞌ cabëꞌ bë Jesús, tu bebanezijëꞌ. Naꞌra uzulaojëꞌ rapalaꞌnjëꞌ Diuzi por nun quie danꞌ babëꞌnëꞌ yelaꞌ huaca quienëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Naꞌra bezaꞌ Jesús ga beyuenëꞌ benꞌ z̃i, caora naꞌ blëꞌënëꞌ tu benꞌ lao Mateo, reꞌnëꞌ tu ga ruquiz̃unëꞌ quie impuesto. Naꞌra unëꞌ rëbëꞌ lëbëꞌ: ―Uda, unao nëꞌëdiꞌ. Naꞌra uyasa Mateo bëlënëꞌ lënëꞌ tuz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Biz̃i guca naꞌ tu reꞌnëꞌ raohuëꞌ z̃an yuꞌu, cati bdyin ja benꞌ zë, benꞌ huequiz̃u, lenrë ja benꞌ cacuendazi. Udaolëjëꞌ Jesús tuz̃e len ja benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pero bëꞌ blëꞌë yaca benꞌ partido fariseo tuz̃ezi udaolë Jesús len lëjëꞌ, naꞌra unabajëꞌ benꞌ quie Jesús rëbijëꞌ lëjëꞌ: ―¿Bixquienꞌ raolë maestro quiele tuz̃ezi len ja benꞌ huequiz̃u len ja benꞌ cacuendazi? ");
INSERT INTO zpcNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Bëꞌ be Jesús canaꞌ, naꞌra unëꞌ rëbinëꞌ lëjëꞌ: ―Ca quie benꞌ zu dyaꞌa, birnaban benꞌ yeyue lënëꞌ. Pero benꞌ raca z̃hueꞌ, rnaban benꞌ yeyue lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Uletzio huele pensari yelaꞌ tzioñeꞌele bi nan lëꞌë guichi laꞌiya quie Diuzi ga rnan caniga: “Raxera Diuzi yeyëchiꞌlaꞌadyiꞌro benëꞌ, quele ca ta hueꞌro Diuzi gun.” Quele zaꞌ rëz̃aꞌ benꞌ na “bibi xquia naca quiaꞌ”, sino que zaꞌ rëz̃aꞌ benꞌ nezi de dulaꞌ xquia quie tacuenda yetzaꞌjëꞌ pensari quiejëꞌ inaojëꞌ xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Bdyin ja benꞌ quie Juan bautista lao Jesús rnabajëꞌ lënëꞌ: ―¿Bixquienꞌ nëtoꞌ len ja benꞌ partido fariseo ruetzeguendoꞌ ubasi, naꞌ ja benꞌ quioꞌ biruejëꞌ ubasi? ");
INSERT INTO zpcNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Naꞌra bequëbi Jesús rëbinëꞌ lëjëꞌ: ―Yaca benꞌ zioja ga raca lani quie huetzaganaꞌ, bireyaꞌalaꞌ sujëꞌ bayëchiꞌ tu nezu benꞌ rutzaganaꞌ len lëjëꞌ. Pero cati idyin dza birazulë benꞌ rutzaganaꞌ len lëjëꞌ, caora naꞌ sí, huazujëꞌ bayëchiꞌ huejëꞌ ubasi. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Bisaqueꞌ yedaꞌro laꞌariꞌ cubi binetzëri lëꞌë laꞌariꞌ gula, porque huetzereꞌnan igan ruꞌa laꞌariꞌ gula, ichezan len mazara. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Lëscanꞌ bisaqueꞌ caꞌro nupi z̃ixi luꞌu bolsa guidi gula, porque bëꞌ sulao ilëbin, huedzaꞌn ichezan len. Lao rupatelan cuiaguiꞌ. Lenaꞌ reyaꞌalaꞌ caꞌron tu luꞌu guidi cubi. Canaꞌ sí, bibi gaca quie lao rupaten. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tu raca nerueꞌ Jesús diꞌidzaꞌ len ja benëꞌ, cati bdyin tu benꞌ rnabëꞌ quie ja benꞌ Israel ganꞌ zë Jesús. Naꞌ gutanëꞌ uzuruꞌala lao Jesús rëbinëꞌ lënëꞌ: ―Zabeyudyi guti tu z̃iꞌinaꞌ nigula. Pero chanꞌ naꞌ luëꞌ guidoꞌ ixubaloꞌ naoꞌ lëbiꞌ, huebambiꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Naꞌra uz̃iꞌnëꞌ ziolënëꞌ ja benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Naꞌra tu neziojëꞌ tu neza, cati ubigaꞌ tu nigula raca z̃hueꞌ xcuꞌudzula Jesús, uz̃enëꞌ diba zu niꞌa z̃abëꞌ. Aziote lao chipchopa iza ruzun lënëꞌ ubaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Canaꞌ bënëꞌ porque guquenëꞌ chi tu guxuzëꞌ z̃aba Jesús, yeyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Cati beyëcho Jesús rnëꞌë ga zë nigula, rëbinëꞌ lënëꞌ: ―Bidzeboꞌ, zanaꞌ. Como danꞌ rzudyiꞌilëloꞌ nëꞌëdiꞌ, abeyacoꞌ. Caora naꞌtezi labeyacatëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Naꞌra uz̃iꞌnëꞌ zioguëꞌ bdyinnëꞌ z̃an yuꞌu quie benꞌ rnabëꞌ, benꞌ nequiëꞌ lënëꞌ. Naꞌ blëꞌënëꞌ bala yuꞌute ja músico listo ta tzecachiꞌjëꞌ lëbiꞌ. Lëzi canaꞌ blëꞌërënëꞌ ruꞌbe gula bayuꞌuja benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Naꞌra unëꞌ rëbinëꞌ lëjëꞌ: ―Ulero ga yuꞌule niga. Para nëꞌëdiꞌ quele natibiꞌ, dechanꞌ tu rasizibiꞌ. Naꞌra bz̃idyijëꞌ Jesús cabëꞌ unëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cati beyudyi betzatzanëꞌ lëjëꞌ, naꞌra uyuꞌunëꞌ ga de nigula baguti, uz̃enëꞌ naꞌabiꞌ besebannëꞌbiꞌ. Caora naꞌ beyasabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Naꞌ tzadi unezi ja benꞌ quie ja yedyi naꞌ cabëꞌ bë Jesús besebannëꞌ nigula daoꞌ de baguti. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lazune Jesús yezaꞌnëꞌ ganꞌ naꞌ cati unao chopa benꞌ laochula lënëꞌ. Rbedyiyaꞌzijëꞌ rëbijëꞌ Jesús: ―¡Beyëchiꞌlaꞌadyiꞌ nëtoꞌ, luëꞌ z̃iꞌi rey David! ");
INSERT INTO zpcNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cati uyuꞌu Jesús luꞌu yuꞌu, naꞌra ubigaꞌja benꞌ laochula laohuëꞌ, naꞌra unabëꞌ lëjëꞌ: ―¿Rzudyiꞌilële nëꞌëdiꞌ huacaꞌ yeyuaꞌ leꞌe naꞌ? Naꞌra najëꞌ: ―Rzudyiꞌilëndoꞌ luëꞌ, Señor. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Naꞌra udëbi Jesús laojëꞌ rëbinëꞌ lëjëꞌ: ―Yeyacale con cabëꞌ rzudyiꞌilële nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Naꞌra labeyacate laojëꞌ dyëꞌëdi. Naꞌra bë Jesús mandado gudyinëꞌ lëjëꞌ: ―Nitu nitu biquixogueꞌle cabëꞌ biaꞌ quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero lapencara brojëꞌ cati uzulaojëꞌ rguixogueꞌjëꞌ tu tu yedyi cabëꞌ bë Jesús quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Naꞌra zezaꞌjëꞌ zeyojëꞌ cati zaꞌ bala ja benꞌ nequiëꞌ tu benꞌ birnë lao Jesús, benꞌ yuꞌu taxiꞌibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Naꞌra bebio Jesús tzalaꞌla taxiꞌibiꞌ yuꞌunëꞌ. Caora naꞌ beyacanëꞌ benëtenëꞌ. Naꞌra rebane ja benëꞌ rnajëꞌ: ―Binelëꞌëcaziro gaca lao ja yedyi quie benꞌ Israel cabëꞌ raca niga naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Naꞌra na ja benꞌ partido fariseo: ―Benꞌ niga rebioguëꞌ taxiꞌibiꞌ yuꞌu ja benëꞌ lao naꞌa xanꞌ taxiꞌibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Naꞌra rda Jesús yugulu yedyi yela len ja yedyi daoꞌ, ruxiꞌdzeꞌnëꞌ lëjëꞌ luꞌu idaoꞌ sinagoga quiejëꞌ. Rguixogueꞌnëꞌ lëjëꞌ xtiꞌidzaꞌ Diuzi, benꞌ rnabëꞌ lao yedyi layu. Naꞌra beyuenëꞌ bitezi yelaꞌ hueꞌ yuꞌu ja benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bëꞌ rlëꞌë Jesús ja benëꞌ, guquenëꞌ bayëchiꞌ quiejëꞌ, danꞌ redzagalaojëꞌ rëpi reyëzijëꞌ ca quie ja becoꞌ z̃iꞌilaꞌ bizu benꞌ rapa ja lëbaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Naꞌra unëꞌ rëbinëꞌ ja benꞌ quienëꞌ: ―Tali rniaꞌ, lega de dyin quiero gacalëro usëdiro ja benëꞌ cabëꞌ reꞌen Diuzi huejëꞌ, pero biyuꞌute ja benꞌ zë, benꞌ gacalë usëdi lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Quie lenaꞌ naꞌ, reyaꞌalaꞌ inabale lao Diuzi ta iseꞌelëꞌ ja benꞌ gacalë raꞌo usëdi lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Naꞌra betupa Jesús lao chipchopa benꞌ quienëꞌ. Bëꞌnëꞌ lëjëꞌ yelaꞌ huaca quienëꞌ ta cuiojëꞌ tzalaꞌla taxiꞌibiꞌ yuꞌu ja benëꞌ, lëscanꞌ ta yeyuerëjëꞌ bitezi yelaꞌ hueꞌ yuꞌu ja benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cani lao ja chipchopa benꞌ quie Jesús: tunëꞌ laonëꞌ Simón, benꞌ laorë Pedro, len bichinëꞌ Andrés, len Santiago, len bichinëꞌ Juan z̃iꞌi Zebedeo, ");
INSERT INTO zpcNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","len Felipe, len Bartolomé, len Tomás, len Mateo, benꞌ huequiz̃u, len Santiago, z̃iꞌi Alfeo, len Tadeo, ");
INSERT INTO zpcNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","len Simón, benꞌ partido cananista, len Judas Iscariote, benꞌ psedyin Jesús lao naꞌa benꞌ rnabëꞌ, benꞌ bëti lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Naꞌra useꞌelaꞌ Jesús lao chipchopa benꞌ quienëꞌ ta tzetixogueꞌjëꞌ benëꞌ xtiꞌidzaꞌ Diuzi. Naꞌra zagudyinëꞌ lëjëꞌ cabëꞌ huejëꞌ, unëꞌ rëbinëꞌ lëjëꞌ caniga: ―Tziole puro yedyi quie ja benꞌ Israel. Bitziole yedyi quie ja benꞌ tula. Bitziorële ja yedyi quie ja benꞌ Samaria. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Uletziotezi yedyi quie ja benꞌ Israel. Benꞌ naꞌ naca quiejëꞌ ca quie becoꞌ z̃iꞌilaꞌ neniti xaꞌne. Canaꞌ naca quiejëꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Uletzio tzetixogueꞌlejëꞌ baruen bagozi dza guida benꞌ iseꞌelaꞌ Diuzi ta inabëꞌnëꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Uleyue yaca benꞌ raca yelaꞌ hueꞌ ta rutao cuinjëꞌ len ja benꞌ raca z̃hueꞌ. Uleseban benꞌ bagutija. Ulebio tzalaꞌla taxiꞌibiꞌ yuꞌu ja benëꞌ. Runaꞌ leꞌe yelaꞌ huaca quiaꞌ ta yeyuele ja benëꞌ, pero bihuelenan de laz̃o. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Bihuaꞌale dumi, ni oro, ni plata, ni cobre. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni tu bihuaꞌale ga udzeꞌle dumi. Tuzi cueꞌ z̃abale nacole. Tuzi huaracho nuliole tziole. Ni xaga bisele. Nu benꞌ racalële, lëbenꞌ naꞌ naca cuenda quiejëꞌ gunjëꞌ ta rdzioguele. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Cati idyinle tu yedyi z̃e o chi tu yedyi daoꞌ, quilole ga zu tu benꞌ dyaꞌa. Naꞌ yegaꞌnle hasta que idyin hora yezaꞌle. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bëꞌ tzuꞌule z̃an yuꞌu quienëꞌ, gapalaꞌnlejëꞌ yëbilejëꞌ: “Huelaꞌiya Diuzi leꞌe ta sule chizi.” ");
INSERT INTO zpcNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chi benꞌ naca xaꞌn yuꞌu ruenëꞌ zi z̃elaꞌadyiꞌ, inabarale lao Diuzi sunëꞌ chizi. Pero chi binaquëꞌ zi benꞌ rue z̃elaꞌadyiꞌ, bira inabale lao Diuzi ta sunëꞌ chizi. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Chi nu ja benꞌ bisiꞌjëꞌ leꞌe dyëꞌëdi, naꞌ chi bireꞌenjëꞌ uzënagarëjëꞌ quiele, yerozile z̃an yuꞌu o chi yedyi ga bireꞌenjëꞌ leꞌe. Usisile bëxte dyia niꞌale cati yerole ta nacan seña binacan dulaꞌ quiele chi baodyiaguiꞌjëꞌ hue Diuzi lëjëꞌ castigo. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tali cabëꞌ rniaꞌ leꞌe, cati idyin dza gaca juicio, huera Diuzi castigo fuertera quie ja yedyi ga bibejëꞌ leꞌe bala, quele cabëꞌ bë Diuzi quie ciudad Sodoma len ciudad Gomorra. Bzei Diuzi lao rupate yedyi naꞌ besulatëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Naꞌ una Jesús: ―Ulenaꞌcara ca niaꞌ leꞌe. Rseꞌelaꞌ leꞌe ca quie becoꞌ z̃iꞌilaꞌ lado ja lobo. Lenaꞌ rnaban huele listo ca quie nu bëla. Rnabarën huele z̃elaꞌadyiꞌ gaxo ca paloma. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gapale cuidado, porque huetzehuaꞌarëjëꞌ leꞌe lao naꞌa ja benꞌ rnabëꞌ. Gunrëjëꞌ leꞌe ziꞌ ga reguꞌudiꞌjëꞌ luꞌu idaoꞌ sinagoga. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hasta huetzehuaꞌajëꞌ leꞌe lao ja benꞌ gobierno, len lao ja rey, len lao ja benꞌ rnabëꞌtera, porque danꞌ biraxejëꞌ nacale benꞌ quiaꞌ. Canaꞌ sí, huacale inële quiaꞌ lao ja benꞌ Israel len lao ja benꞌ binaca benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cati tzehuaꞌajëꞌ leꞌe lao naꞌa ja benꞌ rnabëꞌ, bidëbile quie biz̃idanꞌ yëbilejëꞌ, bidëbile bi huele yëbilejëꞌ. Porque cati babdyin hora sacaꞌle canaꞌ, Diuzcazi gunnëꞌ ta inale. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Porque quele leꞌecazi cuinle inële, Bichi Be quie Diuzila, inëcazinëꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Cani hue yaca benëꞌ, usedyinjëꞌ benëꞌ biꞌ bichinëꞌ lao naꞌa ja benꞌ rnabëꞌ ta gutijëꞌbiꞌ. Lëzirë ja beꞌmbyu usedyinrëjëꞌ z̃iꞌijëꞌ lao naꞌa ja benꞌ rnabëꞌ ta gutirëjëꞌbiꞌ. Naꞌ laz̃iꞌizi ja benëꞌ yeyëchojabiꞌ tilajabiꞌ xuzijabiꞌ, quilojabiꞌ bihuejabiꞌ ta gutiyacabiꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Benꞌ zë tzuꞌuja udie leꞌe nun quie danꞌ baralele quiaꞌ. Nu benꞌ sue inao nëꞌëdiꞌ laꞌacazi bitezi raca quienëꞌ, benꞌ naꞌ sí, huade ilanëꞌ gaquëꞌ benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cati baruenë ja benëꞌ quie tu yedyi leꞌe bizinaquezi, layez̃unotele yeyole yedyi tula. Tali ca rniaꞌ, bicala nedu lao yedyi quie ja benꞌ Israel tzetale tzetixogueꞌlejëꞌ xtiꞌidzaꞌ cati yeguidaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ca ruenë ja benëꞌ tu maestro, canaꞌ huenërëjëꞌ yaca benꞌ rusëdinëꞌ. Lëscanꞌ ca ruenëjëꞌ tu benꞌ napa mozo, canaꞌ huenërëjëꞌ mozo quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nu benꞌ rsëdi, reyaꞌalaꞌ sunëꞌ dispuesto usaca yaca benëꞌ lëbëꞌ con cabëꞌ rsacajëꞌ maestro quienëꞌ. Lëscanꞌ nu benꞌ naca mozo, reyaꞌalaꞌ sunëꞌ dispuesto usaca ja benëꞌ lëbëꞌ cabëꞌ rusacajëꞌ xaꞌnnëꞌ. Chi ina yaca benëꞌ yëbijëꞌ tu benꞌ necuaꞌ familia: “Nacoꞌ xanꞌ taxiꞌibiꞌ”, lëscanꞌ yëbijëꞌ z̃iꞌinëꞌ: “Nacoꞌ z̃iꞌi xanꞌ taxiꞌibiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Naꞌ una Jesús: ―Quie lenaꞌ bireyaꞌalaꞌ idzebile bi ruenë ja benëꞌ leꞌe. Rniaꞌ leꞌe ni tu ta rue yaca benëꞌ balarazi yegaꞌnnan canaꞌzi biyezacaꞌlaona, decazi de huanezan. Lëzi ni tu ta nezi yaca benëꞌ de negachiꞌ yegaꞌnnan canaꞌzi biyezacaꞌlaona, decazide huanezan. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Cabëꞌ diꞌidzaꞌ ruꞌeliaꞌ leꞌe bëꞌ baochula, lëdiꞌidzaꞌ naꞌ yëbile ja benëꞌ bëꞌ baoyaniꞌ. Lëzi cabëꞌ diꞌidzaꞌ ruꞌeliaꞌ leꞌe xcuꞌudzu yuꞌu, lëdiꞌidzaꞌ naꞌ yëbile ja benëꞌ zacaꞌlaojëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bidzebile bi hue ja benëꞌ, porque danꞌ baꞌalaꞌcazi gacajëꞌ gutijëꞌ leꞌe, bigacajëꞌ gutijëꞌ bichi be quiele. Reyaꞌalaꞌ idzebile Diuzi, benꞌ gaca udyiaguiꞌ leꞌe len bichi be quiele iseꞌelëꞌ leꞌe len bichi be quiele lao guiꞌ gabila. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Naꞌ ledaoꞌzi zacaꞌ chopa bguini daoꞌ ga rutiꞌjëꞌbaꞌ, pero ni tu bguini daoꞌ biz̃u biiguinubaꞌ sino que binezi Xuziro Diuzi biguca bguinubaꞌ layu. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hasta len guitzaꞌ guichoro nezi Diuzi balan naca. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lenaꞌ bireyaꞌalaꞌ idzebile, porque zacaꞌra leꞌe quele ca ja bguini daoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Naꞌ una Jesús: ―Nutezi benꞌ rnë cule nëꞌëdiꞌ lao ja benëꞌ, canaꞌrë iniaꞌ cule lëjëꞌ lao Xuzaꞌ Diuzi zu guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero nu benꞌ rnë condre nëꞌëdiꞌ lao ja benëꞌ, canaꞌrë iniaꞌ condre lëjëꞌ lao Xuzaꞌ Diuzi zu guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Naꞌ una Jesús: ―Biinale bigalo dila quie ja benëꞌ tanun quie danꞌ bidaꞌ lao yedyi layu, sino que hualo dila. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Por nun quie danꞌ chi gale nu benëꞌ quiaꞌ, huazu z̃iꞌijëꞌ condre xuzijëꞌ, huazu z̃iꞌijëꞌ nigula condre z̃naꞌjëꞌ, huazu z̃ualidyijëꞌ condre benꞌ gula quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Canaꞌ tzuꞌujëꞌ hasta quie udiejëꞌ familiazi quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Nu benꞌ nedyëꞌëra nu xuzi z̃nëꞌë quele cabëꞌ nëꞌëdiꞌ, binaquëꞌ zi gacanëꞌ benꞌ quiaꞌ. Lëzi nu benꞌ nedyëꞌëra z̃iꞌine, quele cabëꞌ nëꞌëdiꞌ, binacarëꞌ zi gacanëꞌ benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nu benꞌ bireꞌen usacayudyi cuinnëꞌ inaonëꞌ nëꞌëdiꞌ, binaquëꞌ zi gaquëꞌ benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nu benꞌ bireꞌen izane cuine gatinëꞌ por nun quiaꞌ nëꞌëdiꞌ, lëbenꞌ naꞌ initilanëꞌ yelaꞌ neban ta hueꞌ Diuzi lënëꞌ guibá. Pero benꞌ rzane cuine, benꞌ zu puesto gati por nun quiaꞌ nëꞌëdiꞌ, hueꞌla Diuzi yelaꞌ neban quienëꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Naꞌ una Jesús: ―Chi nu benꞌ rezilaꞌadyiꞌ leꞌe, lëscanꞌ nëꞌëdiꞌcazirë rezilaꞌadyiꞌrëjëꞌ. Chi nu benꞌ rezilaꞌadyiꞌ nëꞌëdiꞌ, lëscanꞌ rezilaꞌadyiꞌrëjëꞌ Diuzi, benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nu benꞌ rezilaꞌadyiꞌrë ca una yaca profeta, porque danꞌ nacayaquëꞌ benꞌ zaꞌlao Diuzi, naꞌra con cabëꞌ hue Diuzi benꞌ profeta benꞌ z̃e, canaꞌ huerë Diuzi lëbëꞌ benꞌ z̃e. Nu benꞌ rezilaꞌadyiꞌrë ca una tu benꞌ quie Diuzi, porque danꞌ naquëꞌ benꞌ quie Diuzi, naꞌtera con cabëꞌ hue Diuzi benꞌ quienëꞌ benꞌ z̃e, canaꞌ huerë Diuzi lëbëꞌ benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nu benꞌ hueꞌ chanꞌ tu vasozi nisa zaga benꞌ quiaꞌ, porque danꞌ naquëꞌ benꞌ quiaꞌ, decazide hue Diuzi lëbëꞌ benꞌ z̃e. ―Canaꞌ una Jesús gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Cati beyudyi pxiꞌidzeꞌ Jesús lao chipchopa benꞌ quiëꞌ, caora naꞌ zeyoguëꞌ tzetixogueꞌnëꞌ ja benëꞌ yuꞌuja yedyi regaꞌn gaꞌalaꞌ ganꞌ rdëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Naꞌ dyiguiba yuꞌu Juan naꞌ cati unezinëꞌ cabëꞌ barue Cristo. Naꞌra useꞌelaꞌnëꞌ bala benꞌ quienëꞌ ta tzenaꞌjëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Naꞌra unajëꞌ rëbijëꞌ lënëꞌ: ―¿Nacoꞌ benꞌ na Diuzi iseꞌelaꞌnëꞌ o chi benꞌ tula reyaꞌalaꞌ cuezandoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Naꞌra bequëbi Jesús rëbinëꞌ lëjëꞌ: ―Uletzio uletzeguëdyi Juan cabëꞌ rlëꞌële rele. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ulehueꞌ lënëꞌ diꞌidzaꞌ yëbilenëꞌ cabëꞌ babeyaca ja benꞌ laochula, barelëꞌëjëꞌ. Naꞌ ja benꞌ z̃i, babeyacajëꞌ, baredajëꞌ. Naꞌ ja benꞌ yuꞌu yelaꞌ hueꞌ ta rutao lëjëꞌ, babeyacajëꞌ, babez̃ijëꞌ. Naꞌ ja benꞌ bireja, babeyacajëꞌ, bareyejëꞌ. Naꞌ ja benꞌ bagutija, babebanrëjëꞌ. Naꞌ ja benꞌ yëchiꞌ, rguixoguiꞌajëꞌ ca na xtiꞌidzaꞌ Diuzi ta inezijëꞌ bi huejëꞌ ta yeyojëꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Huaca huen quie benꞌ biusan sudyiꞌilë nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cati bezaꞌ ja benꞌ quie Juan, naꞌra uzulao Jesús ruꞌelënëꞌ benëꞌ diꞌidzaꞌ rëbinëꞌjëꞌ ca naca quie Juan. Cani unëꞌ: ―¿Bidanꞌ uyole yenaꞌle lao lato dachi ga bidyia yuꞌu? ¿Uyole yenaꞌle tu yaga yëto ruꞌa be niꞌnila? ");
INSERT INTO zpcNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Quele lenaꞌ uyole yenaꞌle. ¿Biz̃idanꞌ uyole yenaꞌle chi quele lenaꞌ uyole yenaꞌle? ¿O chi uyole yenaꞌle tu benꞌ zë z̃abe tzaoꞌ? Naꞌ nu benꞌ zë z̃abe tzaoꞌ bitajëꞌ lao lato dachi ga bidyia yuꞌu. Quele lenaꞌ uyole yenaꞌle. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Cabiz̃i uyole yenaꞌle? ¿Uyole yenaꞌle tu benꞌ naca profeta? Talicazi naca Juan profeta. Nacarëꞌ benꞌ tzaoꞌra ca ja profeta. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Lëquie Juan naꞌ, benꞌ cuialao laohuaꞌ, quie lëbëꞌ rguixogueꞌ guichi laꞌiya quie Diuzi cani: Iseꞌelaꞌ Diuzi tu benꞌ cuialao neza ga tzaꞌ cuenda tzetixogueꞌnëꞌ yaca benëꞌ huidaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tali rniaꞌ leꞌe, lao yugu ja benëꞌ baoyuꞌuja yedyi layu hasta naꞌa, nitujëꞌ binegacajëꞌ benꞌ z̃e ca Juan bautista. Dechanꞌ nu benꞌ binacate z̃e ga rnabëꞌ Diuzi guibá, nacacazirëꞌ benꞌ z̃era ca Juan. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Desde cati bida Juan bautista hasta naꞌa, raca ja benëꞌ dila condre yelaꞌ rnabëꞌ quie Diuzi. Du rdilajëꞌ rguilojëꞌ bi huejëꞌ ta useyudyi usedujëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yugulu ja benꞌ udixogueꞌ tiempote cabëꞌ na Diuzi, len cabëꞌ na diꞌidzaꞌ bzu Moisés lëꞌë guichi hasta cati blaꞌ Juan, unëjëꞌ quie dza zazaꞌra cati inabëꞌ Diuzi lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Chi ralele ca niaꞌ quie Juan, huanezile babidalanëꞌ lao laza profeta Elías, benꞌ yeguidacazi. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Reyaꞌalaꞌ tzuꞌu guicho nagale ca niaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Cabi diꞌidzaꞌ iniaꞌ leꞌe ta tzioñeꞌele cabëꞌ naca yelaꞌ zidi quie ja benꞌ nitaꞌ naꞌa? Ruejëꞌ ca quie xcuidiꞌ reꞌ lao yeꞌeya bireꞌenjabiꞌ quitulëjabiꞌ laguedyi xcuidiꞌjabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Naꞌra laguedyi xcuidiꞌjabiꞌ rucuedyijabiꞌ bdyio tacuenda uyaꞌa ja xcuidiꞌ bireꞌen quitu. Pero bireꞌenjabiꞌ uyaꞌajabiꞌ. Lenaꞌ laguedyi xcuidiꞌjabiꞌ bilajabiꞌ canción bayëchiꞌ tacuenda cuedyi ja xcuidiꞌ bireꞌen quitu. Pero ni canaꞌ biuredyijabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Naꞌra bëꞌ bida Juan, biudaotzaꞌonëꞌ bihueꞌenëꞌ vino. Naꞌ leꞌe unale quiëꞌ yuꞌunëꞌ taxiꞌibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Naꞌra bëꞌ bidaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, raohuaꞌ riꞌogaꞌ cabëꞌ ta riꞌo rao ja benëꞌ. Naꞌ rnële quiaꞌ benꞌ riꞌo raolëꞌënaꞌ, benꞌ rdalë ja benꞌ mala len ja benꞌ huequiz̃u. Lenaꞌ niaꞌ leꞌe, yelaꞌ sinꞌ quie Diuzi nenacazi nacan huen. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Naꞌ ra uzulao Jesús regunniꞌanëꞌ ja benꞌ yedyi ganꞌ babërëꞌ yelaꞌ huaca quienëꞌ como ja benëꞌ yuꞌu naꞌ biptzaꞌjëꞌ pensari quiejëꞌ cabëꞌ gudyinëꞌ lëjëꞌ. Naꞌra unëꞌ rëbinëꞌ lëjëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Bayëchiꞌzi gaca quie leꞌe benꞌ ciudad Corazín! ¡Bayëchiꞌzi gaca quie leꞌe benꞌ ciudad Betsaida! Chanꞌ naꞌ guca milagro lao ciudad quie ja benꞌ Tiro, len lao ciudad quie ja benꞌ Sidón cabëꞌ milagro guca lao yedyi quiele tiempote, babetzaꞌjëꞌ pensari quiejëꞌ, babeyacajëꞌ benꞌ quie Diuzi chanꞌ naꞌ. Lëzi canaꞌ, chanꞌ canaꞌcala bagucojëꞌ laꞌariꞌ ta nena yuꞌujëꞌ bayëchiꞌ, naꞌ bdaꞌrëjëꞌ de guichojëꞌ cabëꞌ costumbre gutaꞌ quiejëꞌ cati renabajëꞌ perdón quiejëꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero niaꞌ leꞌe, cati idyin dza gaca juicio, castigo hualara gataꞌ quiele, quele ca castigo gataꞌ quie ja benꞌ ciudad Tiro len ja benꞌ ciudad Sidón. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Lëscanaꞌ leꞌe benꞌ ciudad Capernaum, bigaquele chi huapalaꞌn Diuzi leꞌe yeyole guibá, dechanꞌ lao guiꞌ gabilala tziole, porque chanꞌ naꞌ gucarë milagro lao ciudad Sodoma cabëꞌ milagro guca lao ciudad quiele, nereꞌ ciudad Sodoma nedian hasta naꞌa chanꞌ canaꞌcala. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lëzi canaꞌ rniaꞌ leꞌe, cati idyin dza gaca juicio, huataꞌrë tu castigo hualara quiele, quele ca castigo gataꞌ quie ja benꞌ ciudad Sodoma. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lëlao tiempo naꞌ una Jesús rëbinëꞌ Xuzinëꞌ caniga: ―Benꞌ z̃e nacoꞌ luëꞌ Xuzaꞌ. Nacoꞌ xanꞌ guibá len yedyi layu. Diuxcaleloꞌ por nun quie danꞌ babluꞌeloꞌ ca naca tali quioꞌ lao yaca benꞌ nezi rdzioguejëꞌ inezijëꞌn. Pero pcachiꞌloꞌ ca naca tali quioꞌ lao ja benꞌ na rioñeꞌejëꞌ, pero bëꞌ nazijëꞌ birioñeꞌejëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Canaꞌ nacan Xuzaꞌ, porque canaꞌ reꞌenloꞌ gacan. ―Canaꞌ una Jesús rëbinëꞌ Xuzinëꞌ. Naꞌ una Jesús rëbinëꞌ benꞌ quiëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","―Yugulute ta de baben Xuzaꞌ nëꞌëdiꞌ. Tuzi Xuzaꞌ Diuzi nubëꞌnëꞌ nëꞌëdiꞌ nacaꞌ z̃iꞌinëꞌ. Naꞌ benꞌ reꞌen huebëꞌ cabëꞌ naca Diuzi, nëꞌëdiꞌ uzioñeꞌedaꞌ lëjëꞌ ta huebëꞌjëꞌ cabëꞌ naca Diuzi. Tuzaꞌ nëꞌëdiꞌliaꞌ lëjëꞌ nubëꞌndoꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Uleda gacalële nëꞌëdiꞌ tuz̃e, yugulu leꞌe, benꞌ barexaque quie dulaꞌ xquia quie, benꞌ barexaque cabëꞌ tazëdi raca quie. Nëꞌëdiꞌ gunaꞌ huezilaꞌadyiꞌ quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ulehue quiele diꞌidzaꞌ quiaꞌ cabëꞌ rniaꞌ leꞌe. Ulesëdi cabëꞌ naca quiaꞌ como danꞌ nacaꞌ benꞌ z̃elaꞌadyiꞌ, benꞌ laxtaꞌo gaxo. Chi hue quiele cabëꞌ niaꞌ leꞌe, huataꞌ yelaꞌ huezilaꞌadyiꞌ quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ca naca dyin reꞌendaꞌ huele, binacatigan zëdi. Ca naca yuaꞌ reꞌendaꞌ huaꞌale, binacatigan ziꞌi. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Naꞌra guca dza naꞌ tu dza huezilaꞌadyiꞌ, uzaꞌ Jesús ziolënëꞌ yaca benꞌ quienëꞌ udejëꞌ ga nazajëꞌ trigo. Naꞌ nun quie udue yaca benꞌ quie Jesús, sulaojëꞌ ralojëꞌ dao quie trigo raojëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Cati blëꞌë ja benꞌ fariseo cabëꞌ rue ja benꞌ quie Jesús, naꞌ unëjëꞌ rëbijëꞌ Jesús: ―Unaꞌcara, barue ja benꞌ quioꞌ dyin ta biruꞌen lato huejëꞌ dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Naꞌ unë Jesús rëbinëꞌ lëjëꞌ: ―¿Binelabale cabëꞌ bë rey David lënëꞌ yaca benꞌ quiëꞌ bëꞌ uduejëꞌ dza naꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Uyuꞌunëꞌ luꞌu idaoꞌ rnabëꞌra udaohuëꞌ yëta xtila naca gun quie Diuzi ta biruꞌen lato gaohuëꞌ, ni lëbëꞌ, ni benꞌ quiëꞌ. Tuzi ja pxuzizi ruꞌen lato gaojëꞌn. Pero cala xquia bënëꞌ, bënëꞌ canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Lëzi binenaꞌle lëꞌë ley quie Moisés ga rguixogueꞌn quie ja pxuzi, benꞌ rue dyin luꞌu idaoꞌ rnabëꞌra? Bibezilaꞌadyiꞌjëꞌ dza huezilaꞌadyiꞌ, pero bëjëꞌ dyin luꞌu idaoꞌ rnabëꞌra, dechanꞌ quele xquia bëjëꞌ, bëjëꞌ canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Naꞌra rniaꞌ leꞌe, nacaraꞌ nëꞌëdiꞌ balaora ca idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Leꞌe binetzioñeꞌele cabëꞌ na lëꞌë guichi laꞌiya quie Diuzi ga una Diuzi: “Reꞌendaꞌ yeyëchiꞌlaꞌadyiꞌle benëꞌ. Lenaꞌ nacaran belao quele ca ta udyiale nu bia naca gun quiaꞌ ruꞌaba.” Chi uyoñeꞌele cabëꞌ na Diuzi, bigaole xquia benꞌ bide falta quie. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nëꞌëdiꞌ, bichi yugulu benëꞌ, rnabiꞌa quie yugulute ta raca dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Naꞌra uzaꞌ Jesús zioguëꞌ uyuꞌunëꞌ luꞌu idaoꞌ quieyaquëꞌ laona sinagoga. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Naꞌ zu tu beꞌmbyu neseco nëꞌë. Naꞌra yaca benꞌ zu naꞌ rguilolaꞌadyiꞌjëꞌ gaojëꞌ Jesús xquia. Lenaꞌ unabajëꞌ lëbëꞌ: ―¿Ruꞌen lato yeyuero benëꞌ dza huezilaꞌadyiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Naꞌra bequëbi Jesús rëbinëꞌ lëjëꞌ: ―¿Chi nu leꞌe zu tu becoꞌ z̃iꞌilaꞌ quiele bguinubaꞌ luꞌu pozo dza huezilaꞌadyiꞌ, quele seguro naꞌ huayole tzeliolebaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Como binezile zacaꞌra tu beꞌmbyu quele ca tu becoꞌ z̃iꞌilaꞌ? Quie lenaꞌ ruꞌen lato yeyuero benëꞌ dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Naꞌra una Jesús rëbinëꞌ benꞌ neseco nëꞌë: ―Bli naoꞌ. Naꞌ cati belinëꞌ nëꞌë, beyacan cabëꞌ naca itzalaꞌ nëꞌë dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Naꞌ uzaꞌ ja benꞌ fariseo ziojëꞌ uzulaojëꞌ rusaqueꞌjëꞌ bi huejëꞌ ta gutijëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Cati unezi Jesús guꞌunjëꞌ gutijëꞌ lëbëꞌ, uzëꞌë zioguëꞌ tatula. Naꞌ benꞌ zë gula zio zenao lëbëꞌ. Reyuenëꞌ yugulu yaca benꞌ raca z̃hueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Naꞌra bë Jesús lëjëꞌ mandado ta biquixogueꞌjëꞌ cabëꞌ bënëꞌ quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Canaꞌ bë Jesús tacuenda su diꞌidzaꞌ cabëꞌ una profeta Isaías dza naꞌte caora udixogueꞌnëꞌ ca una Diuzi caniga: ");
INSERT INTO zpcNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Benꞌ niga benꞌ rue dyin lao lazaꞌ, benꞌ uliogaꞌ, nedyëꞌëdaꞌnëꞌ redaohuedaꞌ cabëꞌ ruenëꞌ. Udziꞌa Bichi Be quiaꞌ luꞌu guicho laxtaꞌonëꞌ. Huaguixogueꞌnëꞌ yaca benꞌ nitaꞌ lao yedyi layu ca tali rchugubiꞌa quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bihuenëꞌ huenë, biinënëꞌ snia, bihuenëꞌ zëdi tu neza. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Xelaꞌadyiꞌnëꞌ benꞌ raca bayëchiꞌ quie, yeyëchiꞌlaꞌadyiꞌnëꞌ benꞌ reꞌen usan xquia quie. Canaꞌ huenëꞌ hasta que idyinnëꞌ inabëꞌnëꞌ huenëꞌ tali lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sudyiꞌilë yaca benꞌ nitaꞌ lao yedyi layu lënëꞌ. Canaꞌ udixogueꞌ Isaías tanun quie Diuzi dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Naꞌra uquiëꞌjëꞌ tu benꞌ laochula, benꞌ birnë, lao Jesús. Benꞌ naꞌ uyuꞌu taxiꞌibiꞌ luꞌu laxtaꞌonëꞌ. Beyue Jesús lënëꞌ, belëꞌënëꞌ, benënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Naꞌ bebane ja benꞌ zë unajëꞌ rëbijëꞌ laguedyijëꞌ: ―¿Quele benꞌ niga z̃iꞌi David, benꞌ useꞌelaꞌ Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Naꞌ cati be yaca benꞌ partido fariseo cabëꞌ una ja benëꞌ, naꞌra unajëꞌ rëbijëꞌ lëjëꞌ: ―Yelaꞌ huaca quie Beelzebú xanꞌ taxiꞌibiꞌ rbio benꞌ niga yaca taxiꞌibiꞌ yuꞌu laxtaꞌo benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Naꞌ gucabëꞌ Jesús cabëꞌ pensari racajëꞌ. Quie lenaꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Chi zu tu gobierno nacajëꞌ zë cueꞌ rdilalëjëꞌ laguedyijëꞌ, naꞌra bisibëꞌjëꞌ zidza. Lëscanꞌ nu yedyi, o nu familia, chi rdilalëjëꞌ laguedyijëꞌ, huadzatzajëꞌ, bira tzuꞌujëꞌ tzaz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Canaꞌ nacarën quie Satanás. Chi Satanás rbionan yaca taxiꞌibiꞌ quienan, chi rdilalënan laguedyinan, bisuenan inabëꞌnan zidza. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Naꞌ leꞌe nale rbiogaꞌ taxiꞌibiꞌ yuꞌu laxtaꞌo benëꞌ tanun quie yelaꞌ huaca quie Beelzebú. Naꞌra niaꞌ leꞌe chi nacan canaꞌ, ¿nuz̃i ruꞌe yelaꞌ huaca quie ja benꞌ quiele rbiojëꞌ taxiꞌibiꞌ? Naꞌzi ruluꞌen quiele nequixile cabëꞌ nale. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nëꞌëdiꞌ rbiogaꞌ yaca taxiꞌibiꞌ conlë yelaꞌ huaca quie Bichi Be quie Diuzi. Lenaꞌ ruluꞌen abdyin yelaꞌ huaca quie Diuzi laole, pero birezaquele abdyinnan. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Bisaqueꞌ tzuꞌu benëꞌ z̃an yuꞌu quie tu benꞌ tzutzu huala ta siꞌnëꞌ ta de quienëꞌ chi biuquionëꞌ lënëꞌ. Chi uquionëꞌ lënëꞌ, naꞌra huazaqueꞌ siꞌnëꞌ ta de quienëꞌ. Canaꞌ ruaꞌ quie xanꞌ taxiꞌibiꞌ, ruquiogaꞌnan tacuenda bira inabëꞌnan. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Nu benꞌ bizëlë nëꞌëdiꞌ tzaz̃e, naca quienëꞌ ca quie benꞌ rudie nëꞌëdiꞌ. Nu benꞌ biracalë nëꞌëdiꞌ ruaꞌ dyin quie Diuzi, naca quienëꞌ ca quie benꞌ rchugu dyin quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Tanaꞌ lenaꞌ rniaꞌ leꞌe, zu Diuzi dispuesto siꞌz̃enëꞌ yugulu xquia quie ja benëꞌ, yugulu diꞌidzaꞌ mala rnëjëꞌ, pero chi rna ja benëꞌ: “Dyin quie taxiꞌibiꞌ” naꞌ dyin quie Bichi Be quie Diuzi naꞌ, chi canaꞌ rutasi runiojëꞌ lëbëꞌ, bide yelaꞌ huaziꞌz̃e quiejëꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nutezi benꞌ rnë condre nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ, zu Diuzi dispuesto yeziꞌz̃enëꞌ dulaꞌ xquia quiejëꞌ. Pero nu benꞌ rnë: “Dyin quie taxiꞌibiꞌ” naꞌ dyin quie Bichi Be quie Diuzi naꞌ, biyeziꞌz̃e Diuzi dulaꞌ xquia de quiejëꞌ danꞌ unajëꞌ canaꞌ. Tuzioli huanao dulaꞌ xquia quiejëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Naꞌ una Jesús: ―Nu yaga dyaꞌa rbian taz̃ixi dyaꞌa, pero nu yaga mala birbian taz̃ixi dyaꞌa. Según cabëꞌ naca taz̃ixi dyia yaga, lenaꞌ rluꞌen chi yaga dyaꞌa, chi yaga mala. Ca nu yaga rbian taz̃ixi dyaꞌa, canaꞌ nacarën quiaꞌ como danꞌ ruaꞌ dyin dyaꞌa racaliaꞌ benëꞌ. Lenaꞌ ruquixile inale dyin quie taxiꞌibiꞌ ruaꞌ. Birue taxiꞌibiꞌ tadyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Benꞌ mala gula nacale! Bisaqueꞌ inale tadyaꞌa como danꞌ binacale benꞌ dyaꞌa. Ca naca diꞌidzaꞌ yuꞌu ruꞌale, canaꞌ nacan ta yuꞌu luꞌu guicho laxtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Benꞌ dyaꞌa rnajëꞌ tadyaꞌa, danꞌ yuꞌu tadyaꞌa luꞌu guicho laxtaꞌojëꞌ. Pero leꞌe rnale tamala, danꞌ yuꞌu tamala luꞌu guicho laxtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Naꞌra rniaꞌ leꞌe, yugulu diꞌidzaꞌ mala rnë ja benëꞌ, huezacaꞌlaon lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Según bi naque diꞌidzaꞌ rnële dza rdale lao yedyi layu, huachugobëꞌcazi Diuzi quiele, chi de dulaꞌ xquia quiele, chi bide dulaꞌ xquia quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Naꞌra yaca benꞌ partido fariseo len yaca benꞌ rusëdi ley quie Moisés, unajëꞌ rëbijëꞌ Jesús: ―Maestro, reꞌenndoꞌ ilëꞌëndoꞌ hueloꞌ tu milagro tacuenda inezindoꞌ chi nacoꞌ benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Yaca benꞌ yuꞌu tamala luꞌu guicho laxtaꞌohue, benꞌ rudyiga Diuzi tzalaꞌla, reꞌentejëꞌ ilëꞌëjëꞌ tu milagro ta gaca seña ta inezijëꞌ chi tali useꞌelaꞌ Diuzi nëꞌediꞌ. Pero tuzi milagro ilëꞌëjëꞌ, hualëꞌëjëꞌ ca milagro bë Diuzi dza uda profeta Jonás lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ca guca quie Jonás dza naꞌ, uyuꞌunëꞌ luꞌu lëꞌë tu bela z̃e tzona dza len tzona yela, canaꞌ gacarë quiaꞌ nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ. Huayuꞌa luꞌu yu tzona dza len tzona yela. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Naꞌra rniaꞌ leꞌe, huezuli yaca benꞌ yedyi Nínive gaojëꞌ leꞌe xquia dza gaca juicio como danꞌ lëjëꞌ sí, ptzaꞌjëꞌ pensari quiejëꞌ caora udixogueꞌ Jonás lëjëꞌ diꞌidzaꞌ quie Diuzi dza naꞌ. Pero leꞌe, biruzënagale quiaꞌ baꞌalaꞌcazi nacaraꞌ benꞌ z̃era ca Jonás. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lëscanaꞌ huezuli reina quie yaca yedyi nebaba Arabia gaohuëꞌ leꞌe xquia dza gaca juicio como danꞌ lëbëꞌ sí, uzaꞌnëꞌ yedyi quienëꞌ zionëꞌ zituꞌ gula ta uzënaguëꞌ ca diꞌidzaꞌ unë rey Salomón, benꞌ rioñeꞌe. Pero leꞌe, biruzënagale quiaꞌ baꞌalaꞌcazi nacaraꞌ benꞌ z̃era ca rey Salomón. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Naꞌ una Jesús: ―Cati rero bala ja taxiꞌibiꞌ luꞌu guicho laxtaꞌo ja benëꞌ, rdana ga naca bidyi rguilona ga suna. Caora biredzelena ga suna, naꞌra rnëna: ");
INSERT INTO zpcNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Hueyaꞌa ga bezaꞌa.” Cati abedyinnan beyuꞌunan luꞌu laxtaꞌo benꞌ naꞌ tatula ganꞌ bronan, caora naꞌ rlëꞌëna naca benꞌ naꞌ ca quie tu yuꞌu dachi neluba dyëꞌëdi. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Naꞌra uyonan yexiꞌnan igadyi laguedyin ta nacara mala ca lëna. Canaꞌ yuꞌujan yugujan luꞌu laxtaꞌo benꞌ naꞌ. Canaꞌ racatera mala quienëꞌ quele cati yuꞌun tuzin luꞌu laxtaꞌonëꞌ. Canaꞌ gacarë quiele nun quie danꞌ yuꞌu tamala luꞌu guicho laxtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Naꞌ neruꞌelë Jesús benëꞌ diꞌidzaꞌ cati bdyin z̃nëꞌë lënëꞌ yaca biꞌ bichinëꞌ. Begaꞌnjëꞌ laliꞌa reguilojëꞌ lëbëꞌ ta hueꞌlëjëꞌ lëbëꞌ diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Naꞌra unë tu benꞌ zëlë Jesús rëbinëꞌ Jesús: ―Bablaꞌ z̃naoꞌ len ja biꞌ bichoꞌ. Nitaꞌjëꞌ laliꞌa, reꞌenjëꞌ hueꞌlëjëꞌ luëꞌ diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Naꞌ una Jesús rëbinëꞌ benꞌ udixogueꞌ lëbëꞌ cati bdyin z̃nëꞌë: ―Bablaꞌ z̃naꞌa len ja biꞌ bichaꞌ. Pero niaꞌ leꞌe, nitaꞌrë benꞌ naca ca quie z̃naꞌa, len benꞌ naca ca quie biꞌ bichaꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Naꞌ bluꞌe Jesús ganꞌ zë ja benꞌ quienëꞌ unëꞌ rëbinëꞌ benꞌ naꞌ: ―Ja benꞌ rale quiaꞌ, nacajëꞌ ca quie z̃naꞌa, ca quie biꞌ bichaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Con nutezi benꞌ rue quie xtiꞌidzaꞌ Xuzaꞌ, benꞌ zu guibá, lëlëjëꞌ nacajëꞌ ca quie biꞌbichaꞌ, ca quie biꞌ zanaꞌ, ca quie z̃naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Naꞌra guca dza naꞌ uzaꞌ Jesús z̃an yuꞌu uyoguëꞌ yequeꞌnëꞌ ruꞌa nisa lagun. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Naꞌ como danꞌ beguꞌudiꞌ benꞌ zë ganꞌ reꞌnëꞌ, uyuꞌunëꞌ luꞌu barco ureꞌnëꞌ. Naꞌ begaꞌn ja benëꞌ ruꞌa nisa lagun. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Naꞌra conlë diꞌidzaꞌ ta nacan irupa iyunala unë Jesús psëdinëꞌ leyaquëꞌ cani: ―Uyo tu beꞌmbyu guza trigo. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Naꞌ ca ruejëꞌ quie trigo, tu ruziozijëꞌn layu. Naꞌra bala bini trigo yequeꞌjan tu neza. Naꞌ bdyin bguini aodaobaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ibalan yequeꞌjan lado yo ga biz̃ubatica yu. Naꞌ laolëtejan danꞌ z̃uban yu lasi. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Cati bena oba, naꞌ ubidyin danꞌ biyuꞌu luena zituꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ibalan yequeꞌjan lado yëchiꞌ. Naꞌ bibë yëchiꞌ lato gueꞌenin dyëꞌëdi. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ibalan yequeꞌjan ga naca yu dyaꞌa. Naꞌ bëꞌjan usecho dyaꞌa quien. Balan udyian tu gayuhua z̃ubaꞌ quien. Ibalan udyian tzona galo z̃ubaꞌ quien. Ibalan udyian galobechi z̃ubaꞌ quien. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Chi babele dyëꞌëdiꞌ, ulezënaga canꞌ rniaꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Naꞌra ubigaꞌ ja benꞌ quie Jesús ga zënëꞌ unabajëꞌ lëbëꞌ: ―¿Bixquienꞌ puro diꞌidzaꞌ ta nacan irupa iyunala rusëdioꞌ benëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Ruzioñeꞌe Diuzi leꞌe bi reꞌen ina diꞌidzaꞌ rguixogueꞌn quie yelaꞌ rnabëꞌ quie Diuzi. Pero yaca benꞌ binaca benꞌ quiaꞌ, biuzioñeꞌe Diuzi lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nu benꞌ ruzënaga cabëꞌ rniaꞌ, huacalë Diuzi lëbëꞌ ta tzioñeꞌenëꞌ dyëꞌëdi. Pero nu benꞌ biruzënaga cabëꞌ rniaꞌ, hualaꞌadyiꞌjëꞌ cabëꞌ tadaoꞌ abejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tanaꞌ lenaꞌ rguixoguiꞌa benëꞌ conlë yaca diꞌidzaꞌ ta nacan irupa iyunala, como danꞌ baꞌalaꞌcazi rlëꞌëjëꞌ cabëꞌ ruaꞌ, ruezijëꞌ ca benꞌ birlëꞌë, baꞌalaꞌcazi rejëꞌ cabëꞌ rniaꞌ, ruezijëꞌ ca benꞌ bire. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Canaꞌ naca quiejëꞌ cabëꞌ una profeta Isaías dza naꞌ unëꞌ: Ruzënagajëꞌ dyëꞌëdi, pero birioñeꞌejëꞌ. Rlëꞌëjëꞌ dyëꞌëdi, pero biracabëꞌjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Canaꞌ ruejëꞌ danꞌ yuꞌu tazidi luꞌu guicho laxtaꞌojëꞌ. Ruezijëꞌ ca benꞌ bire, ruezijëꞌ ca benꞌ netzudiꞌ laohue. Bireꞌenjëꞌ ilëꞌëjëꞌ, nica reꞌenjëꞌ guejëꞌ. Bireꞌenjëꞌ tzioñeꞌejëꞌ, nica reꞌenjëꞌ guidajëꞌ ta inaojëꞌ xneza Diuzi yelaꞌ naꞌ yeziꞌz̃enëꞌ dulaꞌ xquia quiejëꞌ. Canaꞌ una Isaías dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pero leꞌe sí, raca tahuen gula quiele danꞌ tali reꞌenle ilëꞌële ca rue Diuzi, tali reꞌenle guele ca rna Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tali ca rniaꞌ leꞌe, benꞌ zë, benꞌ unitaꞌ dza naꞌ, guꞌunjëꞌ ilëꞌëjëꞌ cabëꞌ ta rlëꞌële, guꞌunjëꞌ guejëꞌ cabëꞌ ta rele, pero biuz̃aqueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Naꞌ una Jesús: ―Uzënagale ta iniaꞌ leꞌe ca bi reꞌen inë diꞌidzaꞌ quie benꞌ bë guza. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nu benꞌ ruzënaga ca naca yelaꞌ rnabëꞌ quie Diuzi, pero biralejëꞌ bihue quieyaquëꞌ xtiꞌidzaꞌ Diuzi, hue xanꞌ taxiꞌibiꞌ ta galaꞌadyiꞌjëꞌ cabëꞌ bejëꞌ. Canaꞌ raca quiejëꞌ ca quie bini trigo yequeꞌjan tu neza. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lëscanꞌ nu benꞌ redaohue ruzënaga xtiꞌidzaꞌ Diuzi, ");
INSERT INTO zpcNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pero bihue quieyaquëꞌn zidza, naca quiejëꞌ ca quie bini trigo yequeꞌ lado yo ga biz̃ubatica yu biyuꞌu luena zituꞌ. Cati raca zëdi quiejëꞌ, cati rusaca benëꞌ lëjëꞌ bizinaquezi tanun quie danꞌ rue quieyaquëꞌ xtiꞌidzaꞌ Diuzi, naꞌra rusanjëꞌn, bira rue quieyaquëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Lëscanꞌ nu benꞌ ruzënaga xtiꞌidzaꞌ Diuzi, pero rdëbijëꞌ bi raca quiejëꞌ lao yedyi layu, rzaꞌlaꞌadyiꞌjëꞌ yelaꞌ uñaꞌa, naca quiejëꞌ ca quie bini trigo yequeꞌn lado yëchiꞌ. Danꞌ rdëbijëꞌ bi raca quiejëꞌ rzaꞌlaꞌadyiꞌjëꞌ yelaꞌ uñaꞌa, quie lenaꞌ biruꞌen lato huejëꞌ dyin quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero nu benꞌ ruzënaga xtiꞌidzaꞌ Diuzi, naꞌ ralejëꞌn hue quieyaquëꞌn, naca quiejëꞌ ca quie bini trigo yequeꞌn yu dyaꞌa bëꞌn usecho. Balan rbian tu gayuhua z̃ubaꞌ. Ibalan rbian tzona galo z̃ubaꞌ. Ibalan rbian galobechi z̃ubaꞌ. Canaꞌ nacajëꞌ ca quie bini trigo. Canaꞌ gacarajëꞌ mazara benꞌ nao xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Naꞌra udixogueꞌ Jesús itu diꞌidzaꞌ, unëꞌ rëbinëꞌ lëjëꞌ cani: ―Rniaꞌ leꞌe naca yelaꞌ rnabëꞌ quie Diuzi ca quie tu benꞌ guza bini trigo layela quie. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero du rëla caora rasinëꞌ, uyo tu biꞌ rudie lëbëꞌ guzanëꞌ bini quie guixiꞌ mala lado trigo layela quiëꞌ. Naꞌ bezaꞌnëꞌ zeyoguëꞌ z̃an yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Naꞌra guꞌuni guixiꞌ mala lëbi len trigo. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Naꞌ uyo ja mozo quienëꞌ yetixogueꞌjëꞌ lëbëꞌ, najëꞌ rëbijëꞌ lëbëꞌ: “Señor, baguzandoꞌ puro bini trigo layela quioꞌ, ¿ga zaꞌ guixiꞌ mala den lado trigo quioꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Naꞌ una xaꞌnjëꞌ rëbinëꞌ lëjëꞌ: “Tu benꞌ rudie nëꞌëdiꞌ bë canaꞌ.” Naꞌ una mozo quienëꞌ rëbijëꞌ lëbëꞌ: “¿Reꞌenloꞌ tziondoꞌ tzeguelondoꞌ guixiꞌ mala?” ");
INSERT INTO zpcNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero unë xanꞌ mozo rëbinëꞌ lëjëꞌ: “Bihuele canaꞌ, danꞌ hualorële trigo chanꞌ naꞌ galole guixiꞌ mala. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ulesannan gueꞌenigaran lëbi. Cati yeziꞌa usecho quie trigo, canaꞌ huaꞌ mandado zagalo mozo quiaꞌ guixiꞌ mala uquiojëꞌn manojo ibidyin tzeina. Naꞌtera yeziꞌjëꞌ trigo yeziꞌtzaꞌojëꞌn z̃an lidyaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Naꞌra udixogueꞌ Jesús itu diꞌidzaꞌ, unëꞌ rëbinëꞌ lëjëꞌ cani: ―Naca yelaꞌ rnabëꞌ quie Diuzi ca quie tu bini mostaza ta guza beꞌmbyu layela quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tali naca bini mostaza tadaoꞌ bicuꞌ ca yaca los demás ja bini. Pero cati reꞌenin racan tu yaga z̃e, caora naꞌ rdyin bguini ruebaꞌ lidyibaꞌ lao tacaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Lëscanꞌ udixogueꞌ Jesús itu ejemplo, unëꞌ rëbinëꞌ lëjëꞌ cani: ―Naca yelaꞌ rnabëꞌ quie Diuzi ca quie lëꞌëtiꞌ levadura. Rutupe nigula levadura len tzona medida yëzo trigo ta tzuꞌun duz̃e cuba, naꞌ chëz̃in. ―Canaꞌ una Jesús rëbinëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Naꞌ con puro diꞌidzaꞌ ta nacan irupa iyunala udixogueꞌ Jesús ja benëꞌ. Biudixogueꞌnëꞌ lëjëꞌ con diꞌidzaꞌ binaca diꞌidzaꞌ ta nacan irupa iyunala. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Canaꞌ bënëꞌ tacuenda uzu diꞌidzaꞌ ca diꞌidzaꞌ udixogueꞌ profeta Isaías cabëꞌ rnën lëꞌë guichi laꞌiya cani: Huaguixogueꞌnëꞌ ja benëꞌ zë diꞌidzaꞌ ta nacan irupa iyunala. Huanënëꞌ tu ta bineye ja benëꞌ desde dza cati udixu Diuzi yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Naꞌ gudyi Jesús ja benëꞌ: ―Abeyudyi diꞌidzaꞌ. Naꞌ bedzatzajëꞌ bezaꞌrë Jesús beyuꞌunëꞌ z̃an yuꞌu. Caora naꞌ bebigaꞌ ja benꞌ quienëꞌ rëbijëꞌ lëbëꞌ: ―Reꞌenndoꞌ huuꞌ cule yexiꞌidzoꞌ nëtoꞌ quie diꞌidzaꞌ rnën quie guixiꞌ mala ulë lado trigo. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Naꞌra una Jesús rëbinëꞌ lëjëꞌ: ―Nëꞌëdiꞌ nacaꞌ bichi yugulu benëꞌ, naca quiaꞌ ca quie benꞌ raza bini trigo. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Naꞌ dyilayu ni naca quien ca quie layela ga razaꞌ bini trigo. Naꞌ yaca benꞌ rue quie xtiꞌidzaꞌ Diuzi, naca quiejëꞌ ca quie bini trigo. Naꞌ benꞌ rue cabëꞌ reꞌen xanꞌ taxiꞌibiꞌ, naca quiejëꞌ ca quie guixiꞌ mala. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Naꞌ xanꞌ taxiꞌibiꞌ naca quien ca quie benꞌ guza guixiꞌ mala. Bëꞌ reziꞌa usecho, lenaꞌ rnën quie dza cati iyudyi dyilayu. Naꞌ yaca ángel nacajëꞌ ca quie mozo quiaꞌ reziꞌjëꞌ usecho. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Cabëꞌ hue ja mozo uzeijëꞌ guixiꞌ mala, canaꞌ gaca quie benꞌ rue cabëꞌ reꞌen taxiꞌibiꞌ bëꞌ iyudyi dyilayu. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nëꞌëdiꞌ, bichi yugulu benëꞌ, huaseꞌelaꞌ yaca ángel quiaꞌ tzexiꞌjëꞌ yugulu benꞌ rudzeꞌyela laguedyi, len yugulute yaca los demás benꞌ napa dulaꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Naꞌ udzeꞌjëꞌ lëjëꞌ luꞌu guiꞌ gabila cuedyiyaꞌjëꞌ. Tanto rei rlajëꞌ gaojëꞌ leijëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pero yaca benꞌ rue quie xtiꞌidzaꞌ Diuzi, huataꞌ xniꞌ quiejëꞌ ca tu rnaꞌ xniꞌ oba. Canaꞌ gaca quiejëꞌ zujëꞌ ga rnabëꞌ Xuziro Diuzi tuzioli. Ulehue pensari cabëꞌ niaꞌ leꞌe, danꞌ ruen zi tzioñeꞌele. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Naꞌ una Jesús: ―Yelaꞌ rnabëꞌ quie Diuzi nacan ca quie tu tatzaoꞌ zacaꞌn zaꞌalaꞌ gula ta negachiꞌ luꞌu yu. Naꞌ caora bedzele tu beꞌmbyu len, becachiꞌnëꞌn tatula luꞌu yu ga bedzelenëꞌn. Naꞌra redaohuetzeguenëꞌ tzionëꞌ tzeguetiꞌnëꞌ yugulu ta de quienëꞌ ta yeyaꞌohuëꞌ layu naꞌ ga bedzelenëꞌ tu tatzaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Naꞌ una Jesús: ―Yelaꞌ rnabëꞌ quie Diuzi nacan ca quie tu benꞌ reꞌen gaꞌo tu perla zacaꞌn zaꞌalaꞌ gula. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Caora abdzelenëꞌ perla naꞌ, naꞌra tzionëꞌ tzeguetiꞌnëꞌ yugulu ta de quienëꞌ ta yeyaꞌohuëꞌ perla naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Naꞌ una Jesús: ―Yelaꞌ rnabëꞌ quie Diuzi nacan ca quie du yëxo rudzeꞌ benëꞌ luꞌu nisadaoꞌ ga tzuꞌu yugu cueꞌ bela. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Caora abedzaꞌ bela du yëxo, naꞌra rebiojëꞌn ruꞌa yu bidyi. Naꞌ rbeꞌjëꞌ rsërejëꞌ bia dyaꞌa, redzeꞌjëꞌbaꞌ luꞌu gaꞌ. Naꞌ reruꞌunjëꞌ tzalaꞌla bia binaca dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Canaꞌ gaca cati iyudyi quie dyilayu. Huayo ja ángel ta tzesëreyaquëꞌ benꞌ mala len benꞌ dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Naꞌ huaruꞌunyaquëꞌ yaca benꞌ mala luꞌu guiꞌ gabila cuedyiyaꞌjëꞌ. Tanto rei rlajëꞌ gaojëꞌ leijëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Naꞌra unaba Jesús rëbinëꞌ lëjëꞌ: ―¿Baoyoñeꞌele yugulu cabëꞌ ta aoniaꞌ leꞌe? Naꞌ unajëꞌ rëbijëꞌ Jesús: ―Ajaꞌ Señor, aoyoñeꞌendoꞌ yugun. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Tahuen naꞌ aoyoñeꞌele, danꞌ nu benꞌ rsëdi guichi laꞌiya quie Diuzi, naꞌ rioñeꞌenëꞌ cabëꞌ nan, naca quienëꞌ ca quie benꞌ xanꞌ yuꞌu, benꞌ gabi rdziogue quie. Aoz̃iꞌnëꞌ tagula ta pcaꞌn xuzinëꞌ quienëꞌ. Lëscanꞌ bënëꞌ gan tazëra tacubi. Tanaꞌ lenaꞌ bibi rdzioguenëꞌ z̃an yuꞌu quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Cati beyudyi bëꞌlë Jesús leyaquëꞌ diꞌidzaꞌ, naꞌ bezëꞌë zeyoguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Naꞌ bedyinnëꞌ yedyi quiëꞌ, uzulaohuëꞌ rusëdiëꞌ ja benëꞌ luꞌu idaoꞌ sinagoga. Naꞌra beban ja benëꞌ rëbijëꞌ: ―¿Ga uyo benꞌ niga huesëdi como rioñeꞌenëꞌ ta zë? ¿Cómo raquëꞌ rue milagro? ");
INSERT INTO zpcNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naꞌ z̃iꞌi carpintero naquëꞌ. Z̃nëꞌë naca María. Naca bichinëꞌ Santiago, len José, len Simón, len Judas. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lëscanaꞌrë biꞌ zannëꞌ, nitaꞌjabiꞌ ladoro niga. ¿Ga psëdinëꞌ cabëꞌ danꞌ rnënëꞌ raꞌo? ―Canaꞌ unajëꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pero bibëjëꞌ lëbëꞌ casa cabëꞌ unëꞌ. Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Con gatezi tzio benꞌ rguixogueꞌ diꞌidzaꞌ quie Diuzi, nitaꞌ benꞌ hue lëbëꞌ casa. Pero benꞌ lao yedyi quiëꞌ len benꞌ naca familia quiëꞌ, bihuejëꞌ lëbëꞌ casa. ―Canaꞌ una Jesús rëbinëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tanaꞌ lenaꞌ, bibë Jesús zë milagro ganꞌ, danꞌ bibëjëꞌ casa quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Naꞌra guca dza naꞌ naca Herodes gobernador, benꞌ rnabëꞌ estado Galilea. Naꞌ udixogueꞌ yaca benëꞌ Herodes cabëꞌ rue Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Naꞌra una Herodes rëbinëꞌ laguedyinëꞌ: ―Benꞌ rue canaꞌ naquëꞌ Juan bautista. Bebannëꞌ bezëꞌë ga yuꞌu ja benꞌ huati. Tanaꞌ de fuerza quiëꞌ ruenëꞌ milagro. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Naꞌ aoz̃iꞌ Herodes z̃gula bichinëꞌ Felipe. Lënigula naꞌ laohuëꞌ Herodías. Naꞌ tanun quie Herodías bë Herodes mandado bëxuyaquëꞌ Juan, bdzeꞌjëꞌ lëbëꞌ luꞌu dyiguiba, pquiojëꞌ lëbëꞌ caden. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Canaꞌ bë Herodes como danꞌ una Juan gudyinëꞌ lëbëꞌ: ―Bireyaꞌalaꞌ huelaꞌonëꞌ ca nigula quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Naꞌ guꞌun Herodes gutinëꞌ Juan, pero bdzebinëꞌ ja benëꞌ danꞌ rlëꞌëjëꞌ Juan benꞌ rnë lao laza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Naꞌ cati uzu dza lani quie Herodes, uyo z̃iꞌi nigula Herodías ta byaꞌabiꞌ lao ja benꞌ yuꞌu ja ga raca lani. Lega yaxe Herodes cabëꞌ bëbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tanto yaxenëꞌ cabëꞌ bëbiꞌ unëꞌ rëbinëꞌ lëbiꞌ: ―Con bitezi ta inaboꞌ nëꞌëdiꞌ, naguncazaꞌn, ruguntiaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naꞌra como danꞌ abegaꞌnlëbiꞌ z̃naꞌbiꞌ diꞌidzaꞌ cabëꞌ inababiꞌ lëbëꞌ, naꞌra unabiꞌ rëbibiꞌ Herodes: ―Reꞌendaꞌ gunloꞌ nëꞌëdiꞌ guicho Juan bautista dyian tu luꞌu plato. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Cati be rey Herodes cabëꞌ una nigula daoꞌ, guquenëꞌ bayëchiꞌ. Pero bënëꞌ mandado huejëꞌ cabëꞌ unababiꞌ lëbëꞌ, como danꞌ canaꞌ abgunnëꞌ Diuzi, babe benꞌ yuꞌuja lani ca diꞌidzaꞌ bëꞌlënëꞌ nigula daoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Naꞌra bënëꞌ mandado yechugojëꞌ lubaꞌ Juan ga yuꞌunëꞌ luꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Naꞌ yechugojëꞌn yesanjëꞌ guicho Juan dyian luꞌu plato. Beziꞌ nigula daoꞌ len, beyuꞌebiꞌn z̃naꞌbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Naꞌ bdyin benꞌ quie Juan beziꞌjëꞌ cuerpo quienëꞌ ta pcachiꞌjëꞌn. Ude naꞌ, uyojëꞌ yetixogueꞌjëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Naꞌ cati unezi Jesús cabëꞌ guca quie Juan, naꞌra uzëꞌë zioguëꞌ cuinzëꞌ luꞌu barco bdyinnëꞌ ruꞌa lagun ga bizu ja benëꞌ. Pero cati unezi ja benëꞌ ganꞌ zio Jesús, naꞌ uzaꞌjëꞌ ziojëꞌ ruꞌa yu bidyi yetilajëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cati bero Jesús luꞌu barco, blëꞌënëꞌ nitaꞌ ja benꞌ zë rbezajëꞌ lëbëꞌ. Naꞌ beyëchiꞌlaꞌadyiꞌnëꞌ lëjëꞌ, beyuenëꞌ ja benꞌ raca z̃hueꞌ nuꞌajëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Como danꞌ barala, naꞌ uyo ja benꞌ quie Jesús yeguëdyijëꞌ lëbëꞌ: ―Baodzeꞌ naꞌa. Gabi yuꞌu dyia niga. Naꞌ gudyijëꞌ yeyojëꞌ ja yedyi reꞌ gaꞌalaꞌ ta gaꞌojëꞌ ta gaojëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Biruen zi yeyojëꞌ. Ulehueꞌjëꞌ ta gaojëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Naꞌ unajëꞌ rëbijëꞌ Jesús: ―Gaꞌyoꞌzi yëta xtila len chopazi bela de. Gabira bide. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Uleguncaran niga. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Naꞌra bë Jesús mandado cueꞌ ja benëꞌ lao guiz̃i. Naꞌ aoz̃iꞌnëꞌ gaꞌyoꞌ yëta xtila len chopa bela. Naꞌ bëxunëꞌn unëꞌë guibá rëbinëꞌ Diuzi: “Diuxcaleloꞌ.” Naꞌ bz̃uz̃unëꞌ yëta xtila, bëꞌnëꞌn ja benꞌ quienëꞌ, udisijëꞌn bëꞌjëꞌn benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yugulujëꞌ udaojëꞌ belojëꞌ dyëꞌëdi. Beyudyi bedaojëꞌ, bedzaꞌ chipchopa gaꞌ naga ta yoz̃o begaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Gaꞌyoꞌ mila beꞌmbyu udaoja, apartela ja nigula len ja xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Naꞌra bë Jesús mandado tzuꞌu ja benꞌ quienëꞌ luꞌu barco ta cuialaojëꞌ lëbëꞌ tziojëꞌ itzalaꞌ lagun. Naꞌ begaꞌn Jesús ta yeseꞌelëꞌ ja benëꞌ yeyojëꞌ z̃an yuꞌu quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bëꞌ beyudyi beseꞌelëꞌ ja benëꞌ z̃an yuꞌu quiejëꞌ, naꞌra zio Jesús urënëꞌ lao yaꞌa tzegueꞌlënëꞌ Diuzi diꞌidzaꞌ cuinzinëꞌ. Cati uxin, nezu Jesús naꞌ cuinzinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Naꞌ nezu Jesús lao yaꞌa cati abdyin barco gatzo lagun. Naꞌra uzulao rda be bedunꞌ, bdaꞌn nisa lëꞌë barco, redyigan len guzu xcuꞌudzula, biruꞌen lato tenan. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Naꞌ du balara rzaꞌ Jesús lao nisa ubiguëꞌ gaꞌalaꞌ ga reꞌjëꞌ luꞌu barco. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cati blëꞌë ja benꞌ quienëꞌ lëbëꞌ rzaꞌnëꞌ lao nisa, naꞌra bdzebijëꞌ uredyiyaꞌjëꞌ unëjëꞌ: ―¡Ludzaꞌ benꞌ huati rzaꞌ naꞌ! ");
INSERT INTO zpcNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Naꞌ unë Jesús rëbinëꞌ lëjëꞌ: ―¡Nëꞌëdiꞌ Jesús! ¡Bidzebile! ");
INSERT INTO zpcNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Naꞌ una Pedro rëbinëꞌ Jesús: ―Señor, chi luëꞌ naꞌ, ben lato saꞌ lao nisa guidaꞌ ganꞌ zaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Uda, chiꞌ. Naꞌ uyëzi Pedro lao barco uzulaohuëꞌ rzaꞌnëꞌ lao nisa ta idyinnëꞌ ga zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Caora gucabëꞌ Pedro rda be bedunꞌ fuerte gula, naꞌ bdzebinëꞌ uzulaohuëꞌ bëtoguëꞌ luꞌu nisa. Lenaꞌ uredyiyaꞌnëꞌ rëbinëꞌ Jesús: ―Psela nëꞌëdiꞌ, Señor. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Naꞌra labëxute Jesús nëꞌë rëbinëꞌ lënëꞌ: ―¡Biz̃i ledaoꞌzi zudyiꞌilëloꞌ nëꞌëdiꞌ! ¿Bixquienꞌ rdzeboꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cati beyuꞌujëꞌ luꞌu barco, naꞌ uleza be. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Naꞌra yaca benꞌ yuꞌu luꞌu barco, uditzuz̃ibijëꞌ lao Jesús rëbijëꞌ lëbëꞌ: ―Luëꞌ sí, tali nacoꞌ z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Naꞌ udejëꞌ lao lagun bdyinjëꞌ itzalaꞌ lagun ga nebaba Genesaret. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Caora bezaque ja benꞌ nitaꞌ naꞌ Jesús naꞌ, naꞌra useꞌelaꞌjëꞌ diꞌidzaꞌ lao yugulu benꞌ yedyi nitaꞌja naꞌ. Naꞌ nuꞌajëꞌ benꞌ raca z̃hueꞌ bdyinjëꞌ ga zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Naꞌ unabajëꞌ chi bihueꞌnëꞌ lato guxujëꞌ siquiera diba zu niꞌa z̃abëꞌ. Naꞌ yugulu ja benꞌ bëxuja len, beyacajëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Naꞌra uzaꞌ bala benꞌ partido fariseo len bala benꞌ rusëdi ley quie Moisés, uzaꞌjëꞌ ciudad Jerusalén bdyinjëꞌ ga zu Jesús. Naꞌ ubigaꞌjëꞌ rëbijëꞌ lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Bixquienꞌ birue ja benꞌ quioꞌ cabëꞌ naca costumbre quie xuzixtaꞌoro? Birguibijëꞌ naꞌajëꞌ cati zagaojëꞌ tacuenda ilëꞌë Diuzi lëjëꞌ nacajëꞌ yëri. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―¿Bixquienꞌ reruꞌunle tzalaꞌla cabëꞌ mandado bë Diuzi huero, naꞌ nenaole costumbre ruele ta biuna Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dza tiempote una Diuzi: “Gapalaꞌnle xuzi z̃naꞌle.” Lëscanꞌ una Diuzi: “Nu benꞌ rnayaꞌ quie xuzi z̃nëꞌë, reyaꞌalaꞌ gatinëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero leꞌe rnale ruꞌen lato ina benëꞌ yëbijëꞌ xuzi z̃naꞌjëꞌ: “Bibi de gunaꞌ leꞌe, danꞌ yugulu ta de quiaꞌ babiꞌa Diuzi gacan gun quienëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Leꞌe rnale chi yëbiro xuzi z̃naꞌro canaꞌ, bira nacan cuenda quiero gacalëro xuzi z̃naꞌro. Canaꞌ rudyigale tzalaꞌla cabëꞌ mandado bë Diuzi huero, naꞌ nenaole costumbre ruele ta biuna Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Leꞌe benꞌrnë diꞌidzaꞌ de ladzazi! Dyëꞌëdi udixogueꞌ benꞌ profeta Isaías cabëꞌ raca quiele caora bzunëꞌ diꞌidzaꞌ lëꞌë guichi laꞌiya quie Diuzi dza naꞌ. Lëdiꞌidzaꞌ naꞌ rnën caniga: ");
INSERT INTO zpcNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Lëbenꞌ niga rionelaꞌadyiꞌjëꞌ Diuzi de diꞌidzaꞌzi, birionelaꞌadyiꞌjëꞌ nëꞌëdiꞌ du guicho du laꞌadyiꞌjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bibi sirve gapalaꞌnjëꞌ Diuzi. Ta racazi laꞌadyiꞌjëꞌ rusëdijëꞌ benëꞌ, yëꞌ rziꞌjëꞌ rnajëꞌ canaꞌ una Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Naꞌra guz̃i Jesús ja benëꞌ rëbinëꞌ lëjëꞌ: ―Ulezëcara nagale ta tzioñeꞌele: ");
INSERT INTO zpcNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ca ta tzuꞌu luꞌu ruꞌa benëꞌ gaojëꞌ, binacajëꞌ badzaꞌ lao Diuzi. Pero diꞌidzaꞌ mala rero luꞌu ruꞌajëꞌ, lenaꞌ nuen benëꞌ badzaꞌ lao Diuzi. ―Canaꞌ una Jesús rëbinëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Naꞌra ubigaꞌ ja benꞌ quie Jesús ga zënëꞌ rëbijëꞌ lëbëꞌ: ―¿Bigucabëꞌloꞌ bdzaꞌ ja benꞌ partido fariseo cabëꞌ unaoꞌ bachi? ");
INSERT INTO zpcNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Nacajëꞌ ca quie guixiꞌ mala. Naꞌ biz̃i puro bini dyaꞌa raza Xuzaꞌ Diuzi zu guibá. Yugulu ta biguza Xuzaꞌ Diuzi, huadolon len luenan. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ulesan quiejëꞌ. Nacajëꞌ ca quie benꞌ laochula, benꞌ tzehuaꞌa itu benꞌ laochula. Chi tzehuaꞌa tu benꞌ laochula itu benꞌ laochula tu neza, rupatejëꞌ iguinujëꞌ luꞌu yëro. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Naꞌ una Pedro rëbinëꞌ Jesús: ―Yexiꞌidzoꞌ nëtoꞌ bi reꞌen ina diꞌidzaꞌ baonaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―¿Lente leꞌe biuyoñeꞌerële? ");
INSERT INTO zpcNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Binezile yugu ta rao benëꞌ zion luꞌu lëꞌëjëꞌ, te naꞌ yeguichijëꞌn binuen lëjëꞌ badzaꞌ lao Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero diꞌidzaꞌ mala rero luꞌu ruꞌajëꞌ, len ulën laxtaꞌojëꞌ. Lenaꞌ nuen lëjëꞌ badzaꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Cati rero pensari mala luꞌu laxtaꞌojëꞌ, caora naꞌ rutijëꞌ laguedyijëꞌ, rdalëjëꞌ nigula quie benꞌ tula, rdalëjëꞌ nigula cuidiꞌ, rbanjëꞌ quie laguedyijëꞌ, rziꞌjëꞌ yëꞌ laguedyijëꞌ, ruꞌejëꞌ diꞌidzaꞌ biz̃o. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chi ruejëꞌ canaꞌ, nacajëꞌ badzaꞌ lao Diuzi. Pero chi raojëꞌ du bineyëri naꞌajëꞌ, lenaꞌ binuen lëjëꞌ badzaꞌ lao Diuzi. ―Canaꞌ una Jesús rëbinëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Naꞌ uzaꞌ Jesús zioguëꞌ. Naꞌ ga bdyinnëꞌ nacan gaꞌalaꞌ ga reꞌ ciudad Tiro len ciudad Sidón. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Naꞌ uzaꞌ tu nigula Cananea, benꞌ nitaꞌ ciudad naꞌ, zioguëꞌ bdyinnëꞌ ga zu Jesús. Rbedyiyaꞌnëꞌ unëꞌ rulidzanëꞌ Jesús: ―Señor, z̃iꞌi rey David luëꞌ, beyëchiꞌlaꞌadyiꞌ nëꞌëdiꞌ. Yuꞌu taxiꞌibiꞌ luꞌu laxtaꞌo z̃iꞌinaꞌ nigula. Lega ruluquen lëbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ni tu diꞌidzaꞌ biunë Jesús. Naꞌ ubigaꞌ ja benꞌ quiëꞌ unajëꞌ rëbijëꞌ lëbëꞌ: ―Ulaoloꞌ nigula ni, danꞌ zaꞌnëꞌ zenaonëꞌ raꞌo, rbedyiyaꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Lao ja benꞌ Israelzi aoseꞌelaꞌ Diuzi nëꞌëdiꞌ. Nacajëꞌ ca quie becoꞌ z̃iꞌilaꞌ aoniti tu neza. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Naꞌ ubigaꞌ nigula ga zë Jesús, uditzunëꞌ z̃ibinëꞌ laohuëꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Señor, gucalë nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Bireyaꞌalaꞌ siꞌro yelaꞌ huao ta regaꞌn rao yaca xcuidiꞌ, tzechuꞌunron ta gao yaca becoꞌ daoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero naꞌ una nigula naꞌ rëbinëꞌ Jesús: ―Sí, Señor, pero lente yaca becoꞌ daoꞌ raoyacabaꞌ yaca pedazo rguino layu ga rao yaca xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Zanaꞌ, danꞌ rzudyiꞌilëloꞌ nëꞌëdiꞌ dyëꞌëdi gula, huacan cabëꞌ reꞌenloꞌ. ―Canaꞌ una Jesús rëbinëꞌ lëbëꞌ. Naꞌra lëhora naꞌtezi, beyaca z̃iꞌinëꞌ dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Naꞌ uzaꞌ Jesús zioguëꞌ udenëꞌ ruꞌa lagun quie Galilea, bdyinnëꞌ urënëꞌ ureꞌnëꞌ tu lao yaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Naꞌ bdyin ja benꞌ zë ga zë Jesús. Nuꞌajëꞌ nu benꞌ z̃i, len benꞌ laochula, len benꞌ biraca rnë, len benꞌ neseco nëꞌë, len benꞌ neseco niꞌe. Nuꞌajëꞌ zë benꞌ raca z̃hueꞌ. Naꞌ udixojëꞌ lëjëꞌ laohuëꞌ, beyuenëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Canaꞌ beban ja benëꞌ cati blëꞌëjëꞌ cabëꞌ bë Jesús quie benꞌ naca mala quie. Blëꞌëjëꞌ benë benꞌ biraca inë, blëꞌëjëꞌ abelëꞌë benꞌ laochula. Naꞌra unajëꞌ rëbijëꞌ laguedyijëꞌ: “Naca Diuzi quie benꞌ Israel benꞌ z̃e.” Canaꞌ unajëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Naꞌ guz̃i Jesús yaca benꞌ quienëꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Reyëchiꞌlaꞌadyaꞌ yaca benꞌ niga, danꞌ baguca tzona dza zulëjëꞌ nëꞌëdiꞌ niga, abeya ta gaojëꞌ. Bireyaꞌalaꞌ yeseꞌelaꞌjëꞌ z̃an yuꞌu quiejëꞌ, danꞌ binegaojëꞌ usuꞌunan lëjëꞌ tu neza. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Naꞌ una ja benꞌ quienëꞌ rëbijëꞌ lëbëꞌ: ―Biz̃i huero idzelero yelaꞌ huao ta gao ja benꞌ zë niga. Gabi yuꞌu dyia ni. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―¿Bala yëta xtila de quiele? Naꞌ unajëꞌ rëbijëꞌ Jesús: ―Gadyizin len tu chopazi bela daoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Naꞌ ra bë Jesús mandado cueꞌ ja benëꞌ layu. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Naꞌ uz̃iꞌnëꞌ bëxunëꞌ gadyi yëta xtila len ja bela, unëꞌ rëbinëꞌ Diuzi: “Diuxcaleloꞌ”. Naꞌra bz̃uz̃unëꞌn bëꞌnëꞌn benꞌ quiëꞌ, udisijëꞌn bëꞌjëꞌn yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Naꞌ aodaojëꞌ yugulujëꞌ belojëꞌ. Ude beyudyi naꞌ, bedzaꞌ gadyi chicuiti tayoz̃o begaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Naꞌ aodao tapa mila beꞌmbyu, apartela nigula len xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ude beyudyi udaojëꞌ, beseꞌelaꞌ Jesús lëjëꞌ z̃an yuꞌu quiejëꞌ. Naꞌ uyuꞌunëꞌ luꞌu barco uzaꞌnëꞌ zionëꞌ yu nebaba Magdala. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Naꞌra uyo benꞌ partido fariseo, len benꞌ partido saduceo yenaꞌjëꞌ Jesús ta huejëꞌ trampa quienëꞌ ta gaojëꞌ lëbëꞌ xquia chi bihue ca ta inabajëꞌ huenëꞌ. Canaꞌ unabajëꞌ huenëꞌ tu milagro quie z̃an guibá ta ilëꞌëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Como danꞌ rnaꞌ z̃na guibá du zadzeꞌ, naꞌra inale: “Huen dyaꞌa uxe.” ");
INSERT INTO zpcNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Lëscanꞌ cati zë beo z̃na guibá du ziladaoꞌ, naꞌra inale: “Bihuen dyaꞌa naꞌa.” Pero rniaꞌ leꞌe, benꞌ tondo nacale. Banezile bi ta ilëꞌële ta yezaqueꞌle chi huen dyaꞌa, chi bihuen dyaꞌa, du naꞌa, du uxe. Pero binezile bi ta ilëꞌële ta yezaqueꞌle bi raca lao yedyi layu dza quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yelaꞌ benꞌ mala quiele, yelaꞌ psanlaꞌadyiꞌ Diuzi quiele, rnabale huaꞌ milagro ilëꞌële. Pero rniaꞌ leꞌe, tuzi milagro ilëꞌële, huelëꞌële gaca quiaꞌ cabëꞌ milagro guca quie benꞌ profeta Jonás. Te beyudyi una Jesús canaꞌ, psannëꞌ lëjëꞌ uzaꞌnëꞌ zioguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Naꞌ uzaꞌ Jesús lënëꞌ yaca benꞌ quienëꞌ ziojëꞌ itzalaꞌ lagun. Naꞌ agulaꞌadyiꞌ ja benꞌ quie Jesús huaꞌajëꞌ yëta xtila. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Naꞌra una Jesús rëbinëꞌ lëjëꞌ: ―Cani rniaꞌ leꞌe, gapale cuidado quie levadura quie benꞌ partido fariseo len benꞌ partido saduceo. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Naꞌ uzulao ja benꞌ quie Jesús rëbijëꞌ laguedyijëꞌ: ―Quie danꞌ binuꞌaro yëta xtila unëꞌ raꞌo canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Caora naꞌ gucabëꞌ Jesús cabëꞌ pensari racajëꞌ, naꞌra unëꞌ rëbinëꞌ lëjëꞌ: ―¿Bixquienꞌ rdëbile quie yëta xtila? ¡Binegalele dyëꞌëdi quiaꞌ! ");
INSERT INTO zpcNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Binetzioñeꞌele cabëꞌ naca quiaꞌ? ¿Agulaꞌadyiꞌle cabëꞌ biaꞌ quie lao gaꞌyoꞌ yëta xtila? ¿Birezaꞌlaꞌadyiꞌle bala gaꞌ naga ta yoz̃o begaꞌn beziꞌle? ");
INSERT INTO zpcNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Lëzi birezaꞌlaꞌadyiꞌle cabëꞌ biaꞌ quie gadyi yëta xtila bz̃oz̃ogaꞌn udao ja tapa mila ja benëꞌ? ¿Birezaꞌlaꞌadyiꞌle bala chicuiti ta yoz̃o begaꞌn beziꞌle? ");
INSERT INTO zpcNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Bixquienꞌ biuyoñeꞌele quele quie yëta xtila uniaꞌ caora uniaꞌ leꞌe ta gapale cuidado quie levadura quie benꞌ partido fariseo len benꞌ partido saduceo? ");
INSERT INTO zpcNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Naꞌra uyoñeꞌejëꞌ biunë Jesús quie levadurazi ta rudzeꞌjëꞌ yëta xtila. Unërë Jesús quie pensari raca ja benꞌ partido fariseo len ja benꞌ partido saduceo. Unëꞌ reyaꞌalaꞌ gapajëꞌ cuidado ta bigacajëꞌ pensari ca pensari raca ja benꞌ partido fariseo len ja benꞌ partido saduceo. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cati bdyinlë Jesús yaca benꞌ quienëꞌ yu nebaba Cesarea de Filipo, naꞌra unëꞌ rëbinëꞌ ja benꞌ quiëꞌ: ―¿Biz̃i rna ja benëꞌ nacaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Naꞌra una ja benꞌ quie Jesús rëbinëꞌ lëbëꞌ: ―Balajëꞌ rnajëꞌ nacoꞌ Juan bautista. Ibalajëꞌ rnajëꞌ nacoꞌ profeta Elías, o chi profeta Jeremías. Ibalajëꞌ rnajëꞌ nacoꞌ tu benꞌ profeta tula, benꞌ unitaꞌ dza naꞌla. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―¿Cabiz̃i ina leꞌe nacaꞌ nëꞌëdiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Naꞌra una Simón Pedro rëbinëꞌ lëbëꞌ: ―Luëꞌ nacoꞌ Cristo, z̃iꞌi Diuzi, benꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Naꞌra una Jesús rëbinëꞌ Pedro: ―Tahuen gula baonaoꞌ, Simón, z̃iꞌi Jonás. Quele benëꞌ bzioñeꞌenëꞌ luëꞌ cabëꞌ nacaꞌ nëꞌëdiꞌ, dechanꞌ Xuzaꞌ Diuzi zu guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nëꞌëdiꞌ rniaꞌ luëꞌ nacoꞌ Pedro, ta inaro xtiꞌidzaꞌro “yo”. Con cabëꞌ unaoꞌ quiaꞌ unaoꞌ nacaꞌ z̃iꞌi Diuzi, canaꞌ cuiogaꞌ yaca benꞌ gale quiaꞌ, yaca benꞌ rue quie xtiꞌidzaꞌ. Baꞌalaꞌcazi chi yugulu taxiꞌibiꞌ huejan dila ta udyiaguiꞌjan ja benꞌ rale quiaꞌ, bisuejan huejan gan. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gunaꞌ luëꞌ yelaꞌ rnabëꞌ quiaꞌ ta tzetixogueꞌloꞌ ja benëꞌ bi huejëꞌ ta tzuꞌujëꞌ ga rnabëꞌ Diuzi. Con cabëꞌ yëboꞌjëꞌ huejëꞌ, nacan zi huejëꞌn, naꞌ huazu Diuzi puesto con ca inaoꞌ. Lëscanꞌ con cabëꞌ yëboꞌjëꞌ bihuejëꞌ, nacan zi bihuejëꞌn, naꞌ lëscanꞌ huazu Diuzi puesto con ca inaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Naꞌ ra gudyi Jesús lëjëꞌ ta biquixogueꞌjëꞌ benëꞌ de que lëbëꞌ naquëꞌ Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Naꞌra uzulao Jesús ruxiꞌidzeꞌnëꞌ yaca benꞌ quiëꞌ de que ruen zi yeyonëꞌ ciudad Jerusalén. Ruxiꞌidzeꞌnëꞌ lëjëꞌ cabëꞌ usaca yaca benëꞌ, len ja benꞌ rnabëꞌ, len ja xanꞌ pxuzi, len ja benꞌ rusëdi ley quie Moisés lëbëꞌ, naꞌ gutijëꞌ lëbëꞌ, pero huebannëꞌ lao tzona dza. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Naꞌra uquiëꞌ Pedro Jesús tzalaꞌla uzulaonëꞌ rdilanëꞌ Jesús rëbinëꞌ lëbëꞌ: ―¡Bigueꞌen Diuzi gaca quioꞌ cabëꞌ naoꞌ, Señor! ¡Nica gacazi quioꞌ luëꞌ canaꞌ! ");
INSERT INTO zpcNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Naꞌra uyëcho Jesús ta inë Pedro laohuëꞌ rëbinëꞌ lëbëꞌ: ―Bebigaꞌ tzalaꞌla, Satanás. Tazëdi gula rueloꞌ quiaꞌ. Biracoꞌ pensari quie Diuzi. Pensari quie benëꞌ yuꞌuloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Naꞌra una Jesús rëbinëꞌ ja benꞌ quienëꞌ: ―Chi nu benꞌ reꞌen inao nëꞌëdiꞌ, reꞌennan bira inaoyaquëꞌ ca rna pensari quieyaquëꞌ. Reꞌennan bidzebiyaquëꞌ naoyaquëꞌ nëꞌëdiꞌ yugu dza, baꞌalaꞌcazi ruen z̃udyi guti benëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nu benꞌ rdzebi inao nëꞌëdiꞌ, danꞌ rdzebinëꞌ gatinëꞌ tanun quiaꞌ, bihueꞌ Diuzi lëbëꞌ yelaꞌ neban tuzioli. Pero nu benꞌ inao nëꞌëdiꞌ birdzebinëꞌ gatinëꞌ tanun quiaꞌ, hueꞌ Diuzi lëbëꞌ yelaꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Biz̃i gan de quie nu benëꞌ anaca quie lao yugulute ta de lao yedyi layu, chi bigataꞌ yelaꞌ neban quiëꞌ tuzioli? ¿Ca gacala dumi reꞌennan ta gaꞌo yaca benëꞌ yelaꞌ naban tuzioli? ");
INSERT INTO zpcNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nacaꞌ bichi yugulu benëꞌ. Huayaꞌa, pero naꞌ yeguidaꞌ tatula lao yedyi layu, zeyuꞌa yelaꞌ rnabëꞌ quie Xuzaꞌ. Caora naꞌ yeguidaliaꞌ yaca ángel quienëꞌ ta ichuguliaꞌ quie ja benëꞌ, quiz̃ogaꞌjëꞌ cabëꞌ bëjëꞌ dza udajëꞌ lao dyilayu, chi bëjëꞌ tahuen, chi bëjëꞌ tamala. ");
INSERT INTO zpcNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tali rniaꞌ leꞌe, binegati bala leꞌe nitaꞌ niga len nëꞌëdiꞌ tu binelëꞌë inabiꞌa lao yedyi layu, nëꞌëdiꞌ bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Naꞌra guca lao xopa dza, uquiëꞌ Jesús Pedro, len Santiago, len Juan biꞌ bichi Santiago, uzaꞌjëꞌ ziojëꞌ tu lao yaꞌa sibi. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Naꞌ zë Jesús laojëꞌ cati betzaꞌ cuinnëꞌ, unaꞌ laohuëꞌ ca xniꞌ oba. Naꞌ z̃abëꞌ betzaꞌn unaꞌn bezëri gula ca xniꞌ guiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Naꞌra blëꞌëjëꞌ labdyinte Moisés len Elías ruꞌelëjëꞌ Jesús diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Naꞌ una Pedro rëbinëꞌ Jesús: ―Señor, tahuen naꞌ nitaꞌndoꞌ niga. Chi reꞌenloꞌ, huendoꞌ tzona yuꞌu guiz̃idaoꞌ. Huendoꞌ tun quioꞌ, huendoꞌ itun quie Moisés, len itun quie Elías. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Naꞌ tu raca zë Pedro nanëꞌ canaꞌ, cati zaꞌ tu beo bezëri gula bdubin lëjëꞌ. Naꞌ luꞌu beo naꞌ bejëꞌ tu rchiꞌ benëꞌ unënëꞌ nëꞌ: ―Lëz̃iꞌinaꞌ niga, lega nedyëꞌëdaꞌnëꞌ. Lega rexedaꞌ ca ruenëꞌ. Ulezënaga cabëꞌ rnanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Naꞌ cati be ja benꞌ quie Jesús canaꞌ, naꞌ udzeꞌjëꞌ gutajëꞌ layu guzu ruꞌala danꞌ bdzebitzeguejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Naꞌra bebigaꞌ Jesús ganꞌ dejëꞌ naꞌ blapanëꞌ lëjëꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Uleyasa, bidzebile. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Naꞌ cati beyasajëꞌ, rnaꞌjëꞌ tuzi Jesús zënëꞌ naꞌ. Ganura nitaꞌ len lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Naꞌ bëꞌ zezaꞌjëꞌ zeyëzijëꞌ lëꞌë yaꞌa naꞌ, una Jesús rëbinëꞌ lëjëꞌ: ―Biquixogueꞌle ja benëꞌ cabëꞌ ta blëꞌële guca quiaꞌ, nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ. Caora agutiaꞌ bebanaꞌ, naꞌra huazaqueꞌ quixogueꞌlejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Naꞌra una ja benꞌ quie Jesús rëbijëꞌ lënëꞌ: ―Rna yaca benꞌ rusëdi ley quie Moisés de que zaꞌ guida Elías tanëro, naꞌra guida benꞌ iseꞌelaꞌ Diuzi. ¿Ta balejëꞌ rnajëꞌ canaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Tali naꞌ zaꞌ guida Elías tanëro, ucuezanëꞌ duz̃ete cuenda guida itu benꞌ iseꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero nëꞌëdiꞌ rniaꞌ leꞌe, abida Elías, pero bibezaque ja benëꞌ chi lëbëꞌ. Psacajëꞌ lëbëꞌ bizinaquezi. Lëscanꞌ nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ, usacajëꞌ nëꞌëdiꞌ bizinaquezi. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Naꞌra gucabëꞌ benꞌ quie Jesús unënëꞌ quie Juan bautista caora unëꞌ: “Tali naꞌ zaꞌ guida Elías tanëro.” ");
INSERT INTO zpcNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cati bedyinjëꞌ ga neguꞌudiꞌ ja benëꞌ, naꞌra ubigaꞌ tu beꞌmbyu ganꞌ zë Jesús uditzunëꞌ z̃ibinëꞌ laohuëꞌ unëꞌ rëbinëꞌ lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Señor, ¿biyeyëchiꞌlaꞌadyoꞌ z̃iꞌinaꞌ? Racabiꞌ z̃uguti. Lega rusacan lëbiꞌ. Tazë lasa babzalan lëbiꞌ lao guiꞌ len luꞌu nisa. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ni rdehuaꞌabiꞌ lao ja benꞌ quioꞌ, pero birzaqueꞌjëꞌ yeyuejëꞌbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Naꞌ una Jesús rëbinëꞌ benꞌ zu naꞌ: ―Leꞌe biralele quiaꞌ. Biyuꞌule pensari dyaꞌa. ¿Gaca tu tiempo suliaꞌ leꞌe, naꞌ bigalele quiaꞌ? ¿Gaca tu tiempo suliaꞌ leꞌe, naꞌ birioñeꞌele? Yexiꞌbiꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Naꞌra udila Jesús taxiꞌibiꞌ yuꞌu luꞌu laxtaꞌo xcuidiꞌ byu. Naꞌ bebioguëꞌ lenan. Canaꞌ labeyacatebiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ude beyudyi naꞌ, uquiëꞌ benꞌ quie Jesús lëbëꞌ tzalaꞌla unajëꞌ rëbijëꞌ lëbëꞌ: ―¿Bixquienꞌ biuz̃aqueꞌndoꞌ yebiondoꞌ taxiꞌibiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Biuz̃aqueꞌle danꞌ binegalele dyëꞌëdi. Tali rniaꞌ leꞌe, naca bini mostaza tu bini daoꞌ bicuꞌzi. Naꞌ chi hue quiele xtiꞌidzaꞌ Diuzi laꞌacazi lëꞌëtiꞌdaoꞌ bicuꞌzi ca tadaoꞌ bicuꞌ naca bini mostaza, huazaqueꞌ yëbile tu yaꞌa: “Beyo yesu naꞌla”, naꞌ huayon. Pues huazaqueꞌ huele yugulute. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero ca naca taxiꞌibiꞌ bebiogaꞌ naꞌa, chi biulidzale Diuzi, chi bihuele ubasi, bisaqueꞌ cuiolen yeyon. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tu raca rdalë Jesús benꞌ quienëꞌ estado Galilea, udixogueꞌnëꞌ lëjëꞌ cabëꞌ gaca quienëꞌ danꞌ naquëꞌ bichi yugulu benëꞌ. Unëꞌ usedyin ja benëꞌ lëbëꞌ lao naꞌa ja benꞌ rudie lëbëꞌ ");
INSERT INTO zpcNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ta gutijëꞌ lëbëꞌ, pero huebannëꞌ tatula gaca lao tzona dza. Cati be yaca benꞌ quienëꞌ cabëꞌ unëꞌ, guqueꞌjëꞌ bayëchiꞌ gula. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Naꞌra uzaꞌ Jesús lënëꞌ ja benꞌ quiëꞌ ziojëꞌ bdyinjëꞌ ciudad Capernaum. Naꞌ uyo benꞌ huequiz̃u quie idaoꞌ rnabëꞌra yenaꞌjëꞌ Pedro unajëꞌ rëbijëꞌ lëbëꞌ: ―¿Biquiz̃u maestro quiele impuesto quie idaoꞌ rnabëꞌra? ");
INSERT INTO zpcNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Naꞌ una Pedro rëbinëꞌ lëjëꞌ: ―Ajaꞌ, huaguiz̃unëꞌn. Naꞌ uzaꞌ Pedro zionëꞌ z̃an yuꞌu. Cati bdyinnëꞌ z̃an yuꞌu, naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―¿Bi ca inaoꞌ, Simón? ¿Cati ruquiz̃u ja rey impuesto, nuz̃i ruquiz̃ujëꞌ? ¿Ruquiz̃ujëꞌ benꞌ yedyi quiejëꞌ o chi ruquiz̃ojëꞌ benꞌ zaꞌ yedyi tula? ");
INSERT INTO zpcNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Naꞌ una Pedro rëbinëꞌ lëbëꞌ: ―Ruquiz̃ujëꞌ benꞌ zaꞌ yedyi tula. Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Tanaꞌ lenaꞌ biruen zi quiz̃u benꞌ yedyi quie rey impuesto. ");
INSERT INTO zpcNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero ta biidzaꞌ nitujëꞌ raꞌo, quiz̃oro quie impuesto. Naꞌ uyo ruꞌa lagun, bdzeꞌ yëchiꞌ luꞌu nisa. Cati guëbi bela len, yeyaꞌalaꞌn len lëbaꞌ, caora naꞌ ixaꞌloꞌ ruꞌabaꞌ yedzeleloꞌ centavo ta quiz̃uloꞌ para luëꞌ len nëꞌëdiꞌ quie impuesto. Naꞌ uyo yetiz̃oꞌn naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Naꞌra bebigaꞌ yaca benꞌ quie Jesús unajëꞌ rëbijëꞌ lëbëꞌ: ―¿Nuz̃i benꞌ nacara benꞌ belao entre nëtoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Naꞌ guz̃i Jesús tu xcuidiꞌ byu bzunëꞌbiꞌ gatzo laꞌojëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Unëꞌ rëbinëꞌ lëjëꞌ: ―Tali rniaꞌ leꞌe, chi biutzaꞌle pensari quiele, galele quie Diuzi ca rale nu xcuidiꞌ quie xuzibiꞌ, bisaqueꞌ tziole guibá ga rnabëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nu benꞌ rzudyiꞌilë Diuzi cabëꞌ rzudyiꞌilë xcuidiꞌ xuzibiꞌ, lëbenꞌ naꞌ nacara benꞌ belao guibá ga rnabëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nu benꞌ rziꞌ xcuidiꞌ ca biꞌ niga tanun quiaꞌ, nuen quienëꞌ lente nëꞌëdiꞌ rziꞌrënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Naꞌ una Jesús: ―Nu benꞌ rudzeꞌyela tu xcuidiꞌ rale quiaꞌ ta huebiꞌ tamala, hue Diuzi lëbëꞌ castigo z̃e gula. Tadyaꞌacala quienëꞌ erio tu yo z̃e lubaꞌnëꞌ tzechuꞌunjëꞌ lëbëꞌ luꞌu yao z̃e ga naca zituꞌ gula, quele ca castigo hue Diuzi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nacan bayëchiꞌ gula quie ja benꞌ nitaꞌ lao yedyi layu, danꞌ birdziogue nu rudzeꞌyela lëjëꞌ huejëꞌ tamala. Nitaꞌcazi nu rudzeꞌyela ja benëꞌ huejëꞌ tamala, pero hue Diuzi castigo z̃e gula nu benꞌ rudzeꞌyela benëꞌ huejëꞌ tamala. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Quie lenaꞌ, chi rnën leꞌe huelële niꞌa naꞌale tamala, nacalan dyaꞌa ichugulen chuꞌunlen zituꞌ tziole guibá ca benꞌ nedyipa niꞌa nëꞌë, quele ca ta tziole guiꞌ gabila tuzioli len niꞌa naꞌale. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Lëscanꞌ chi rnën leꞌe huelële laole tamala, nacalan dyaꞌa cuiolen chuꞌunlen zituꞌ tziole guibá ca benꞌ nero yolaohue, quele ca ta tziole guiꞌ gabila len rupa laꞌa yolaole. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Naꞌ una Jesús: ―Bireyaꞌalaꞌ ilëꞌële ziꞌ nu xcuidiꞌ rale quiaꞌ. Rniaꞌ leꞌe zu ángel, benꞌ rapa ja xcuidiꞌ, zujëꞌ lao Xuzaꞌ Diuzi zu guibá yugu dza. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ, uzaꞌa bidaꞌ lao dyilayu tacuenda ute uselaꞌ yugu benꞌ nitaꞌ lao yedyi layu como danꞌ yelaꞌ napa xquia quiejëꞌ tziojëꞌ lao guiꞌ gabila. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Bica nale? Chi rapa tu beꞌmbyu tu gayuhua becoꞌ z̃iꞌilaꞌ, naꞌ aoniti tubaꞌ, ¿quele ucaꞌnnëꞌjabaꞌ naꞌazi tu tzediloguëꞌ bia uniti? ");
INSERT INTO zpcNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chi yedzelenëꞌbaꞌ, lega yedaohuenëꞌ biunitibaꞌ. Redaohuenëꞌ quie yaca bia biuniti, pero redaohueteranëꞌ quie bia uniti bedzela. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lëscanꞌ Xuziro Diuzi zu guibá, bireꞌennëꞌ initi ni tu xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Naꞌ una Jesús: ―Chi bë tu benꞌ rue quie xtiꞌidzaꞌ Diuzi tu tamala quioꞌ, reyaꞌalaꞌ hueꞌlaoꞌnëꞌ tu diꞌidzaꞌ rupazile ta inezinëꞌ ca tamala bënëꞌ quioꞌ. Canaꞌ gacalëloꞌnëꞌ usannëꞌ tamala, huenëꞌ tadyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero chi bihuenëꞌ casa quioꞌ, naꞌ reyaꞌalaꞌ guëz̃oꞌ ichopa tzona benꞌ rue quie xtiꞌidzaꞌ Diuzi ta gacajëꞌ testigo. Canaꞌ initaꞌ chopa tzona benꞌ naca testigo quioꞌ cabëꞌ naca diꞌidzaꞌ hueꞌlaoꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Chi bihuenëꞌ casa quie ja testigo quioꞌ, naꞌra yëboꞌ ja yugulu benꞌ rue quie xtiꞌidzaꞌ Diuzi cabëꞌ danꞌ bënëꞌ quioꞌ. Naꞌ chi bihuenëꞌ casa quie ja yugulu benꞌ rue quie xtiꞌidzaꞌ Diuzi, naꞌra reyaꞌalaꞌ ilëꞌëlenëꞌ ca nu benꞌ binuebëꞌ chi zu Diuzi, ilëꞌëlenëꞌ ca nu benꞌ mala gula. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Tali rniaꞌ leꞌe, con cabëꞌ yëbile yaca benꞌ rue quie xtiꞌidzaꞌ Diuzi ta hueyaquëꞌ quie benꞌ bë tamala, nacan zi hueyaquëꞌn, huazu Diuzi puesto con ca inale. Lëzi con cabëꞌ yëbile yaca benꞌ rue quie xtiꞌidzaꞌ Diuzi ta bihueyaquëꞌ quie benꞌ bë tamala, nacan zi bihueyaquëꞌn, lëscanꞌ huazu Diuzi puesto con ca inale. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Lëzi rniaꞌ leꞌe, chi chopa leꞌe begaꞌnle de acuerdo hueꞌlële Xuzaꞌ Diuzi zu guibá diꞌidzaꞌ, inabale bi ta reꞌenle huenëꞌ, naꞌ huenëꞌ ca ta unabale huenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Lëzi rniaꞌ leꞌe, ga reguꞌudiꞌ chopa tzona benꞌ rale quiaꞌ, rulidzajëꞌ nëꞌëdiꞌ, nazuaꞌ gatzo laꞌojëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Naꞌra bebigaꞌ Pedro ga zë Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―Señor, ¿bala lasa ruen zi siꞌz̃iaꞌ quie benꞌ rue quie xtiꞌidzaꞌ Diuzi ca tamala ruenëꞌ quiaꞌ? ¿Lao gadyi lasazi siꞌz̃iaꞌ quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Naꞌra una Jesús rëbinëꞌ Pedro: ―Quele lao gadyi lasazi siꞌz̃eloꞌ quienëꞌ, pero con balatezi lasa inabanëꞌn siꞌz̃eloꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Naꞌ una Jesús: ―Naꞌ rniaꞌ leꞌe cabëꞌ rnabëꞌ Diuzi. Ruenëꞌ ca nu rey, benꞌ bëlë ja mozo quienëꞌ cuenda gaca tu reyaꞌalaꞌjëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Uzulaonëꞌ ruenëꞌ cuenda len ja mozo quiëꞌ cati yexiꞌnëꞌ tunëꞌ, benꞌ reyaꞌalaꞌ quienëꞌ dumi z̃e gula. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero como bide dumi ta yeguiz̃uguëꞌ quie rey, naꞌra bë rey mandado gutiꞌnëꞌ yugulu ta de quienëꞌ, huenëꞌ dyin sin laz̃u len nigula quienëꞌ len z̃iꞌinëꞌ ta yelaꞌ ta reyaꞌalaꞌnëꞌ quie rey. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Naꞌra uditzuz̃ibi mozo naꞌ lao rey naꞌ, unabayëchiꞌnëꞌ rëbinëꞌ rey: “Señor, uz̃iꞌz̃e quiaꞌ. Nayequiz̃ugaꞌn duz̃enan.” ");
INSERT INTO zpcNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naꞌ beyëchiꞌlaꞌadyiꞌ rey naꞌ lëbëꞌ, unëꞌ rëbinëꞌ lëbëꞌ: “Huaziꞌz̃iaꞌ quioꞌ, gabi reyaꞌaloꞌ quiaꞌ. Anacoꞌ libre.” ");
INSERT INTO zpcNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Cati beronëꞌ ganꞌ zu rey naꞌ, naꞌra bedilanëꞌ itu mozo laguedyinëꞌ, benꞌ reyaꞌalaꞌ quienëꞌ tu chopa tzona dumi daoꞌ. Naꞌ aoz̃enëꞌ du lubaꞌnëꞌ rëbinëꞌ lënëꞌ: “¡Udiz̃u ta reyaꞌaloꞌ quiaꞌ!” ");
INSERT INTO zpcNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Naꞌra uditzuz̃ibi laguedyinëꞌ unabayëchiꞌnëꞌ rëbinëꞌ lënëꞌ: “Señor, uz̃iꞌz̃e quiaꞌ. Nayequiz̃ugaꞌn duz̃enan.” ");
INSERT INTO zpcNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero biguꞌunnëꞌ, naꞌ uyonëꞌ yedzeꞌnëꞌ lënëꞌ luꞌu dyiguiba ta yeguiz̃unëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cati blëꞌë ja mozo tula cabëꞌ bënëꞌ quienëꞌ, lega beyëchiꞌlaꞌadyiꞌjëꞌ lënëꞌ uyojëꞌ yeguëdyijëꞌ rey naꞌ ca ta uz̃acanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Naꞌra guz̃i rey naꞌ mozo quiëꞌ unëꞌ rëbinëꞌ lënëꞌ: “¡Benꞌ mala gula nacoꞌ! Nëꞌëdiꞌ uz̃iꞌz̃iaꞌ quioꞌ ca ta reyaꞌaloꞌ quiaꞌ como danꞌ unabayëchoꞌ laohuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Reyaꞌalaꞌ yeyëchiꞌlaꞌadyiꞌraoꞌ laguedyiloꞌ cabëꞌ biaꞌ nëꞌëdiꞌ, beyëchiꞌlaꞌadyaꞌ luëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Naꞌra bdzaꞌtzegue rey naꞌ lënëꞌ. Bënëꞌ mandado udzeꞌjëꞌ lënëꞌ luꞌu dyiguiba ta yeguiz̃unëꞌn ta reyaꞌalaꞌnëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Naꞌ bëꞌ beyudyi diꞌidzaꞌ una Jesús, unëꞌ rëbinëꞌ benꞌ quienëꞌ: ―Cabëꞌ bë rey naꞌ, canaꞌrë hue Xuzaꞌ Diuzi zu guibá conlë leꞌe, chi bisiꞌz̃ele quie laguedyile du guicho du laꞌadyiꞌle cabëꞌ tamala bënëꞌ quiele, lëscanꞌ bisiꞌz̃e Diuzi leꞌe cabëꞌ tamala ruele. ―Canaꞌ una Jesús rëbinëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Te beyudyi una Jesús canaꞌ, uzaꞌnëꞌ estado Galilea, ziolënëꞌ yaca benꞌ quiëꞌ estado Judea itzalaꞌ yao Jordán. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Naꞌ unao ja benꞌ zë lëbëꞌ ga zioguëꞌ beyuenëꞌ ja benꞌ raca z̃hueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Naꞌra bebigaꞌ chopa tzona benꞌ partido fariseo ga zë Jesús ta huejëꞌ lëbëꞌ trampa gaojëꞌ lëbëꞌ xquia. Tanaꞌ unajëꞌ rëbijëꞌ lëbëꞌ: ―¿Ta bala nitu nitu biruꞌen lato usanjëꞌ nigula quiejëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―¿Binenaꞌle cabëꞌ rnë lëꞌë laꞌiya guichi quie Diuzi? ¿Binenezile cabëꞌ bënëꞌ cati ulëchinëꞌ dyilayu, bzaloguëꞌ tu beꞌmbyu len tu nigula? ");
INSERT INTO zpcNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Lëscanꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Quie lenaꞌ rusan beꞌmbyu xuzi z̃nëꞌë ta sulënëꞌ nigula quienëꞌ, gacajëꞌ tuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Cati banacajëꞌ tuzi, bira naca quiejëꞌ ca quie chopa benëꞌ. Dyin quie Diuzi nuelëjëꞌ tuzi. Tanaꞌ lenaꞌ biruꞌen lato usanjëꞌ laguedyijëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Naꞌ unajëꞌ rëbijëꞌ lëbëꞌ: ―¿Bixquienꞌ, chiꞌ, bëꞌ Moisés lato ichisa beꞌmbyu guichi ga rueꞌn diꞌidzaꞌ bira reꞌennëꞌ sulënëꞌ nigula? Naꞌ hueꞌnëꞌ nigula guichi ta usannëꞌ lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Yelaꞌ zidi quie ja benëꞌ bëꞌ Moisés lato usanjëꞌ nigula quiejëꞌ. Pero dza ulëchi Diuzi dyilayu, biguꞌunnëꞌ hue yaca benëꞌ canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nëꞌëdiꞌ rniaꞌ leꞌe, chi rusan beꞌmbyu nigula quiëꞌ, naꞌ uz̃iꞌnëꞌ nigula tula, lenaꞌ nacan xquia quiëꞌ lao Diuzi. Chi psannëꞌ lëbëꞌ danꞌ udalënëꞌ beꞌmbyu tula, lenaꞌ binacan xquia quiëꞌ lao Diuzi. Lëscanꞌ chi yeziꞌ beꞌmbyu tu nigula psan xquiuhue, lenaꞌ nacan xquia quiëꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Naꞌ una benꞌ quie Jesús rëbinëꞌ lëbëꞌ: ―Chi nacan cabëꞌ rnaoꞌ quie beꞌmbyu len nigula quienëꞌ, bisiꞌcalanëꞌ nigula. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Quele yugu ja benëꞌ rioñeꞌejëꞌ cabëꞌ rnë lëꞌë guichi laꞌiya quie Diuzi. Yaca benꞌ bëꞌ Diuzi yelaꞌ rioñeꞌe quie, lëjëꞌ rioñeꞌejëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bala ja beꞌmbyu binaca quiejëꞌ sulëjëꞌ nigula. Canaꞌ naca quiejëꞌ cati golotejëꞌ. Ibala ja beꞌmbyu binaca quiejëꞌ sulëjëꞌ nigula, danꞌ ulio benëꞌ bini quiejëꞌ. Ibala ja benëꞌ bisulëjëꞌ nigula tacuenda huejëꞌ puro dyin quie Diuzi. Nu benꞌ ruzënaga cabëꞌ rniaꞌ, reyaꞌalaꞌ uzënagajëꞌ dyëꞌëdi. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Naꞌra nequiëꞌ ja benëꞌ bala ja xcuidiꞌ ga zë Jesús ta guxonëꞌ guichojabiꞌ ta huelaꞌiyanëꞌ lëjabiꞌ hueꞌlënëꞌ Diuzi diꞌidzaꞌ tanun quiejabiꞌ. Pero ja benꞌ quienëꞌ uzulaojëꞌ rdilajëꞌ ja benꞌ nequiëꞌ ja xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Naꞌ una Jesús rëbinëꞌ benꞌ quiëꞌ: ―Ulesan quiejëꞌ. Guidagara ja xcuidiꞌ sulëjabiꞌ nëꞌëdiꞌ. Nu benꞌ tzio ga rnabëꞌ Diuzi ruen zi sudyiꞌilëjëꞌ Diuzi cabëꞌ rzudyiꞌilë xcuidiꞌ len xuzijabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Naꞌ bëxonëꞌ guicho ja xcuidiꞌ ta bëlaꞌiyanëꞌ lëjabiꞌ. Ude naꞌ uzëꞌë zioguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Naꞌra uyo tu benꞌ ruꞌabe yenaꞌnëꞌ Jesús. Naꞌ unanëꞌ rëbinëꞌ lëbëꞌ: ―Maestro, benꞌ huen nacoꞌ. ¿Ca bi reyaꞌalaꞌ huaꞌ ta gataꞌ yelaꞌ neban quiaꞌ tuzioli? ");
INSERT INTO zpcNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Naꞌ una Jesús rëbinëꞌ lënëꞌ: ―Benꞌ huen unaoꞌ nëꞌëdiꞌ. Tahuen naꞌ unaoꞌ nëꞌëdiꞌ canaꞌ, como danꞌ tuzi Diuzi naquëꞌ benꞌ huen. Naꞌ chi reꞌenloꞌ tzioꞌ guibá gataꞌ yelaꞌ neban quioꞌ tuzioli, ruen zi hue quioꞌ cabëꞌ naca mandamiento quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Naꞌ unanëꞌ rëbinëꞌ Jesús: ―¿Ca bi mandamiento reyaꞌalaꞌ hue quiaꞌ? Naꞌ una Jesús rëbinëꞌ lënëꞌ: ―Bigutioꞌ benëꞌ, bitalaoꞌ z̃gula benꞌ tula, bicuanloꞌ quie benëꞌ, bisiuꞌ yëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gapalaꞌnloꞌ xuzi z̃naoꞌ, edyëꞌëloꞌ benëꞌ ca nedyëꞌëloꞌ cuinloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Naꞌ una benꞌ ruꞌabe rëbinëꞌ Jesús: ―Yugulute cabëꞌ naoꞌ, ruaꞌnan cati nacatiaꞌ xcuidiꞌ. ¿Biz̃ira ta rdzioguedaꞌ huaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Naꞌ una Jesús rëbinëꞌ lënëꞌ: ―Chi reꞌenloꞌ hueloꞌ yugulu ca reꞌen Diuzi hueloꞌ, uyo yeguëtiꞌ ta de quioꞌ, bëꞌ ja benꞌ yëchiꞌ centavo quien. Chi hueloꞌ canaꞌ, naꞌra gataꞌ tadyaꞌa quioꞌ ga zu Diuzi guibá. Naꞌ guidoꞌ inaoloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero cati be benꞌ ruꞌabe ca una Jesús, naꞌra zeyonëꞌ raquenëꞌ bayëchiꞌ danꞌ nacanëꞌ benꞌ uñaꞌa gula. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Naꞌra una Jesús rëbinëꞌ ja benꞌ quiëꞌ: ―Tali rniaꞌ leꞌe, zëdi gula nacan tzio yaca benꞌ uñaꞌa guibá ga zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Rniaꞌ leꞌe tatula, cabëꞌ nacan zëdi gula te tu camello luꞌu niꞌa yëchiꞌ, canaꞌ nacarën zëdi quie benꞌ uñaꞌa tzionëꞌ ilëꞌënëꞌ ga zu Diuzi guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Naꞌ bëꞌ be ja benꞌ quie Jesús cabëꞌ unëꞌ, tu bebanzijëꞌ unajëꞌ rëbijëꞌ laguedyijëꞌ: ―¿Ca nuz̃i saqueꞌ tzio guibá ga zu Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Naꞌ unaꞌ Jesús rëbinëꞌ lëjëꞌ: ―Ca ta bigaca ja benëꞌ huejëꞌ, Diuzi sí, racanëꞌ ruenëꞌn como danꞌ raca rue Diuzi yugulute. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Naꞌra una Pedro rëbinëꞌ Jesús: ―Señor, nusandoꞌ yugulu ta de quiendoꞌ ta inaondoꞌ luëꞌ. ¿Ca biz̃i ta gaca quiendoꞌ guibá? ");
INSERT INTO zpcNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Tali rniaꞌ leꞌe, cati idyin dza yecubi yugulute ta de naꞌa, cati cuiꞌa nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ, xlatogaꞌ, naꞌra leꞌe, benꞌ unao nëꞌëdiꞌ, caora naꞌ cueꞌrële lao chipchopa xlatole ta ichugulile lao chipchopa cueꞌ benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Rniaꞌ leꞌe, yugu benꞌ psan z̃an yuꞌu quie, o chi nu biche, o chi nu zane, o chi nu xuze z̃nëꞌë, o chi nu z̃gule, o chi nu z̃iꞌine, o chi nu layu quie tanun quiaꞌ nëꞌëdiꞌ, hueꞌra Diuzi lëbëꞌ tu gayuhua lasa mazara ca ta psannëꞌ. Lëzi hueꞌ Diuzi lënëꞌ yelaꞌ neban quienëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero bala benꞌ naca benꞌ belao niga lao yedyi layu, bira gacajëꞌ benꞌ belao dza yedyinjëꞌ ga zu Diuzi. Lëscanꞌ bala benꞌ binaca benꞌ belao niga lao yedyi layu, huacajëꞌ benꞌ belao dza yedyinjëꞌ ga zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Naꞌ una Jesús: ―Naꞌ rniaꞌ leꞌe cabëꞌ rue Diuzi. Ruenëꞌ ca nu benꞌ xanꞌ layela, benꞌ uyo balara yegueꞌlë benëꞌ diꞌidzaꞌ ta yeziꞌjëꞌ usecho quie bedzuliꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Naꞌ bëꞌlënëꞌ benꞌ hue dyin quienëꞌ diꞌidzaꞌ ta quiz̃uguëꞌ lëjëꞌ tu dumi plata tu dza. Ude naꞌ useꞌelëꞌ lëjëꞌ tzeguejëꞌ dyin layela quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ude naꞌ uzëꞌë zioguëꞌ ca du las nueve quie zila. Naꞌ blëꞌënëꞌ bala benꞌ rda canaꞌzi laꞌo yedyi. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Naꞌ unëꞌ rëbinëꞌ lëjëꞌ: “Uletziorë leꞌe, tzeguele dyin yeziꞌle usecho quiaꞌ. Naquiz̃ugaꞌ leꞌe quie tu dza quiele.” Naꞌ uyojëꞌ hue dyin quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Naꞌ uzëꞌë zioguëꞌ tatula ca du laꞌodza, bënëꞌ cabëꞌ bënëꞌ zila quie benꞌ hue dyin quienëꞌ. Lëzi uzëꞌë zioguëꞌ tatula ca du las tres quie zadzeꞌ, bënëꞌ cabëꞌ bënëꞌ laꞌodza quie benꞌ hue dyin quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Naꞌra uzëꞌë zioguëꞌ laꞌo yedyi tatula ca du las cinco quie zadzeꞌ. Naꞌ bedilanëꞌ ibala ja benꞌ rdaja canaꞌzi. Naꞌ unëꞌ rëbinëꞌ lëjëꞌ: “¿Bixquienꞌ rda leꞌe niga canaꞌzi bedu dza, gabi dyin ruele?” ");
INSERT INTO zpcNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Naꞌ unajëꞌ rëbijëꞌ lëbëꞌ: “Rdandoꞌ canaꞌzi como danꞌ nitu nunu bida ina nëtoꞌ huendoꞌ dyin.” Naꞌra unëꞌ rëbinëꞌ lëjëꞌ: “Uletziorë leꞌe tzeguele dyin layela quiaꞌ. Naquiz̃ugaꞌ leꞌe quie tu dza quiele.” ");
INSERT INTO zpcNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cati baodzeꞌ, naꞌra unë xanꞌ layela rëbinëꞌ benꞌ quiz̃u mozo: “Guz̃i ja mozo naꞌ, quiz̃uloꞌjëꞌ. Tanëro quiz̃uloꞌ benꞌ uyuꞌu cati beyudyite dyin. Naꞌra quiz̃uloꞌ benꞌ uyuꞌu tanëro.” ");
INSERT INTO zpcNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Naꞌra ude ja benꞌ yuꞌu ja dyin ca du las cinco quie zadzeꞌ. Naꞌ aodiz̃uguëꞌ lëjëꞌ quie bedu dza quiejëꞌ tu huio dumi plata. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Naꞌra ude ja benꞌ yuꞌu ja dyin tanëro. Naꞌ guquejëꞌ huaguiz̃uguëꞌ lëjëꞌ mazara. Pero udiz̃uguëꞌ lëjëꞌ tu huiocazi dumi plata. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bëꞌ uz̃iꞌjëꞌ xlaz̃ujëꞌ rnëjëꞌ rdzaꞌjëꞌ rëbijëꞌ xaꞌn layela: ");
INSERT INTO zpcNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ja benꞌ uyuꞌu cati beyudyite dyin, ca tu horazi bëjëꞌ dyin. Naꞌ udiz̃uloꞌjëꞌ lëbi len nëtoꞌ bëndoꞌ dyin bedu dza aozuendoꞌ tala bedu dza.” ");
INSERT INTO zpcNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Naꞌ una xanꞌ layela rëbinëꞌ tu benꞌ uyuꞌu dyin tanëro: “Bichaꞌ, quele tamala biaꞌ quioꞌ. ¿Quele begaꞌnro diꞌidzaꞌ quiz̃ugaꞌ luëꞌ tu dumi plata quie tu dza quioꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ni de xlaz̃uloꞌ, beyo. Chi reꞌendaꞌ quiz̃ugaꞌ benꞌ uyuꞌu cati beyudyite dyin lëbi cabëꞌ aodiz̃ugaꞌ luëꞌ, abihuena quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿O chi bireꞌenloꞌ huaꞌ ca reꞌendaꞌ len dumi quiaꞌ? ¿O chi raquez̃ëꞌloꞌ nëꞌëdiꞌ danꞌ ruaꞌ tadyaꞌa?” ");
INSERT INTO zpcNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Naꞌra nëꞌëdiꞌ rniaꞌ leꞌe, bala benꞌ binaca benꞌ belao niga lao yedyi layu, huacajëꞌ benꞌ belao dza yedyinjëꞌ ga zu Diuzi. Lëscanꞌ bala benꞌ naca benꞌ belao niga lao yedyi layu, bira gacajëꞌ benꞌ belao dza yedyinjëꞌ ga zu Diuzi. Rëz̃i Diuzi benꞌ zë, benꞌ inao xnezëꞌ, pero balazijëꞌ guida inao xnezëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Naꞌ uzaꞌ Jesús lënëꞌ chipchopa benꞌ quienëꞌ ziojëꞌ ciudad Jerusalén. Naꞌ tu neza guz̃inëꞌ lëjëꞌ tzalaꞌla unëꞌ rëbinëꞌ lëjëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ablëꞌële bazioro ciudad Jerusalén ganꞌ usedyin benëꞌ nëꞌëdiꞌ lao naꞌa xanꞌ pxuzi, len lao naꞌa benꞌ rusëdi ley quie Moisés. Naꞌ rusaqueꞌjëꞌ nëꞌëdiꞌ nacala ca huejëꞌ gutijëꞌ nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Naꞌ lëjëꞌ usedyinjëꞌ nëꞌëdiꞌ lao naꞌa benꞌ zaꞌ yedyi tula ta utitujëꞌ nëꞌëdiꞌ, gunjëꞌ nëꞌëdiꞌ ziꞌ, udaꞌjëꞌ nëꞌëdiꞌ lëꞌë yaga cruzo gatiaꞌ. Pero huebanaꞌ lao tzona dza. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Naꞌra bebigaꞌ rupa z̃iꞌi Zebedeo, Juan len Santiago, len z̃naꞌjëꞌ ga zë Jesús. Naꞌ uditzu z̃naꞌjëꞌ z̃ibinëꞌ lao Jesús ta inabëꞌ lëbëꞌ tu cule. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―¿Biz̃i danꞌ reꞌenloꞌ huaꞌ quioꞌ? Naꞌ unëꞌ rëbinëꞌ Jesús: ―Chi bihuuꞌ cule, hueloꞌ mandado cueꞌ z̃iꞌinaꞌ niga cuëtoꞌ cati bareꞌloꞌ xlatoloꞌ rnabëꞌloꞌ. Rnabaꞌ huuꞌ mandado cueꞌbiꞌ tubiꞌ zaquëꞌ yebë, itubiꞌ cueꞌbiꞌ zaquëꞌ yegaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Naꞌra una Jesús rëbinëꞌ lëjëꞌ: ―Binezile cabëꞌ danꞌ aonabale nëꞌëdiꞌ. ¿Huazuele sacale cabëꞌ usaca benëꞌ nëꞌëdiꞌ? ¿Huazuele yedzagalaole cabëꞌ yedzagalaohuaꞌ? Naꞌ unajëꞌ rëbijëꞌ lëbëꞌ: ―Ajaꞌ, huazuendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Tali ca nale. Usaca benëꞌ leꞌe cabëꞌ usacajëꞌ nëꞌëdiꞌ, naꞌ yedzagalaole cabëꞌ yedzagalaohuaꞌ. Pero quele nëꞌëdiꞌ huaꞌ mandado ta cueꞌle cuëtaꞌ tzalaꞌ huio. Xuzaꞌ Diuzi huenëꞌ mandado nu benꞌ cueꞌ cuëtaꞌ tzalaꞌ huio. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Cati be ichi benꞌ quie Jesús cabëꞌ unaba Santiago len bichinëꞌ Juan, naꞌra bdzaꞌjëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero guz̃i Jesús lëjëꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Leꞌe nezile dyëꞌëdi cabëꞌ rue ja benꞌ naca gobierno, rnabëꞌjëꞌ ziꞌlaza. Redaohuejëꞌ huejëꞌ mandado zëdi hue ja benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero leꞌe, bireyaꞌalaꞌ huele canaꞌ. Nu benꞌ rnabëꞌ quie ja benꞌ rue quie xtiꞌidzaꞌ Diuzi, ruen zi gacalëjëꞌ laguedyijëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Lëscanꞌ nu benꞌ belao quie ja benꞌ rue quie xtiꞌidzaꞌ Diuzi, ruen zi huejëꞌ pensari bi huejëꞌ ta gataꞌ tadyaꞌa quie laguedyijëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Huele cabëꞌ ruaꞌ nëꞌëdiꞌ, benꞌ bichi yugulu benëꞌ. Quele bidaꞌ ta hue ja benëꞌ tadyaꞌa quiaꞌ. Bidaꞌ ta huaꞌ tadyaꞌa quiejëꞌ, gatiaꞌ lao lazajëꞌ gacajëꞌ libre, bira inao dulaꞌ xquia quiejëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cati uzaꞌjëꞌ yedyi Jericó, unao benꞌ zë gula Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Naꞌ ga udejëꞌ reꞌ chopa benꞌ laochula cuëta neza. Cati bejëꞌ zaꞌ Jesús, naꞌra uredyiyaꞌjëꞌ unajëꞌ rëbijëꞌ Jesús: ―Señor, z̃iꞌi suba xuzixtaꞌoro rey David luëꞌ. Beyëchiꞌlaꞌadyiꞌnëtoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Naꞌ udila ja benëꞌ lëjëꞌ rëbijëꞌ lëjëꞌ ta cueꞌjëꞌ chizi. Pero uredyiyaꞌrajëꞌ zidzo gula unajëꞌ rëbijëꞌ Jesús: ―Señor, z̃iꞌi suba xuzixtaꞌoro rey David luëꞌ. Beyëchiꞌlaꞌadyiꞌ nëtoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Naꞌra uleza Jesús guz̃inëꞌ ja benꞌ laochula, unëꞌ rëbinëꞌ lëjëꞌ: ―¿Biz̃i danꞌ reꞌenle huaꞌ quiele? ");
INSERT INTO zpcNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Naꞌ unajëꞌ rëbijëꞌ Jesús: ―Señor, reꞌenndoꞌ yelëꞌëndoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Naꞌra beyëchiꞌlaꞌadyiꞌ Jesús lëjëꞌ, uz̃enëꞌ laojëꞌ labelëꞌëtejëꞌ unaojëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Naꞌ bdyinjëꞌ yedyi Betfagé ga nacan gaꞌalaꞌ ga reꞌ ciudad Jerusalén. Lëscanꞌ nacan gaꞌalaꞌ ga reꞌ tu yaꞌa laona yaꞌa Olivos. Naꞌra useꞌelaꞌ Jesús chopa benꞌ quienëꞌ ");
INSERT INTO zpcNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","rëbinëꞌ lëjëꞌ: ―Uletzio yedyi naꞌ. Naꞌ yedzelele tu burra neriobaꞌ lëbaꞌ z̃iꞌibaꞌ. Ulexëdyibaꞌ ulequiëꞌbaꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Chi ina benëꞌ rëbijëꞌ leꞌe: “¿Bixquienꞌ iquiëꞌlebaꞌ?” naꞌ yëbilejëꞌ: “Reꞌen Señor naꞌ lëbaꞌ. Naꞌ laidesantendoꞌbaꞌ itu chiꞌ.” ―Canaꞌ una Jesús rëbinëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Canaꞌ guca ta uzu diꞌidzaꞌ quie Diuzi ta bzu benꞌ profeta lëꞌë guichi. Lëdiꞌidzaꞌ nan caniga: ");
INSERT INTO zpcNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Uleyëbi benꞌ ciudad Jerusalén caniga: “Leꞌe benꞌ ciudad Jerusalén, ulenaꞌ, azaꞌ rey quiele, naquëꞌ benꞌ gaxo, dyianëꞌ tu burra, z̃iꞌi bia ruꞌa yuaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Naꞌra uyo ja benꞌ quiëꞌ, bëjëꞌ cabëꞌ mandado bë Jesús huejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Naꞌ uquiëꞌjëꞌ burra len z̃iꞌibaꞌ uxubajëꞌ z̃abajëꞌ xcuꞌudzubaꞌ, naꞌ udyia Jesús lëbaꞌ, ziojëꞌ bdyinjëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Benꞌ zë nitaꞌjëꞌ tu neza udixujëꞌ z̃abajëꞌ ga ude Jesús. Ibalajëꞌ uchugujëꞌ tacaꞌ palma udixurëjëꞌn tu neza ga udenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Naꞌ ja benꞌ zioja dyialao lao Jesús len ja benꞌ zioja zenao lëbëꞌ, uzulaojëꞌ rnëjëꞌ zidzo rnajëꞌ: ―¡Benꞌ z̃e luëꞌ, z̃iꞌi rey David! Laꞌiya nacoꞌ zaoꞌ lao naꞌa Diuzi. ¡Benꞌ z̃e Diuzi! ");
INSERT INTO zpcNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cati uyuꞌu Jesús ciudad Jerusalén, naꞌ bebane ja benëꞌ unajëꞌ rëbijëꞌ laguedyijëꞌ: ―¿Nuz̃i benꞌ niga? ");
INSERT INTO zpcNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ibalajëꞌ unajëꞌ rëbijëꞌ lëjëꞌ: ―Benꞌ profeta Jesús, benꞌ yedyi Nazaret quie estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ude naꞌ uyuꞌu Jesús luꞌu idaoꞌ rnabëꞌra belaohuëꞌ ja benꞌ yuꞌu huëtiꞌ luꞌu idaoꞌ rnabëꞌra naꞌ. Bzalëꞌ ja mesa quie ja benꞌ rutzaꞌ dumi. Lëscanꞌ bzalëꞌ silla quie ja benꞌ yuꞌu huëtiꞌ paloma. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Naꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Lëꞌë guichi laꞌiya quie Diuzi rnan caniga: “Idaoꞌ rnabëꞌra quiaꞌ nacan ga hueꞌlë ja benëꞌ Diuzi diꞌidzaꞌ. Pero leꞌe abetzaꞌlen ruelen ca beló ga reguꞌudiꞌ benꞌ uban.” ");
INSERT INTO zpcNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Naꞌ luꞌu idaoꞌ rnabëꞌra ga zë Jesús, ubigaꞌ bala benꞌ laochula len benꞌ z̃i, naꞌ beyuenëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero ja xanꞌ pxuzi len ja benꞌ rusëdi ley quie Moisés, bdzaꞌjëꞌ cati blëꞌëjëꞌ cabëꞌ milagro bë Jesús. Lëscanꞌ bdzaꞌjëꞌ cati bejëꞌ rnë ja xcuidiꞌ zidzo luꞌu idaoꞌ rnabëꞌra najabiꞌ: “Benꞌ z̃e luëꞌ, z̃iꞌi rey David.” ");
INSERT INTO zpcNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Naꞌ bdzaꞌjëꞌ unajëꞌ rëbijëꞌ Jesús: ―¿Abeloꞌ cabëꞌ na ja xcuidiꞌ? Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Ajaꞌ, bedaꞌ cabëꞌ rnajabiꞌ. Pero leꞌe, ¿cómo binelabale cabëꞌ nan quiejabiꞌ lëꞌë guichi laꞌiya quie Diuzi? Rnën nan caniga: Dyin bë Diuzi rula ja xcuidiꞌ daoꞌ, biꞌ neraꞌadyiꞌ, alabanza huen gula. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naꞌra psan Jesús lëjëꞌ uzaꞌnëꞌ ciudad Jerusalén ziolënëꞌ yaca benꞌ quiëꞌ yedyi Betania. Naꞌ begaꞌnjëꞌ tu yela. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Naꞌ beteyu zila, uzëꞌë ziolënëꞌ yaca benꞌ quiëꞌ ciudad Jerusalén. Naꞌ tu neza zioguëꞌ cati uduenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Naꞌ blëꞌënëꞌ zu tu yaga higo cuëta neza. Naꞌ udenëꞌ unëꞌë ta yedzelenëꞌ taz̃ixi quien, pero gabi bedzelenëꞌ. Naꞌ una Jesús: ―Bira cuiacazi yaga ni taz̃ixi. Naꞌ laobidyite yaga higo. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cati blëꞌë ja benꞌ quiëꞌ cabëꞌ guca quie yaga higo, naꞌra bebanejëꞌ unajëꞌ rëbijëꞌ Jesús: ―¿Cabiz̃i guca quie yaga higo laobidyiten? ");
INSERT INTO zpcNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Tali rniaꞌ leꞌe, chi rzudyiꞌilële Diuzi du guicho du laꞌadyiꞌle, huazaqueꞌ huele cabëꞌ biaꞌ quie yaga higo. Naꞌ quele tuzi quie len huele, pero lëscanꞌ huazaqueꞌrë huele mandado te tu yaꞌa tzion luꞌu nisadaoꞌ, naꞌ huayonan. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Con bita inabale lao Diuzi hueꞌlëlenëꞌ diꞌidzaꞌ, chi rzudyiꞌilële Diuzi du guicho du laꞌadyiꞌle, gunnëꞌn quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Naꞌra beyuꞌu Jesús luꞌu idaoꞌ rnabëꞌra tatula. Naꞌ tu zunëꞌ rusëdinëꞌ benëꞌ cati ubigaꞌ ja xanꞌ pxuzi, len ja benꞌ rnabëꞌ quie ja benꞌ Israel, unajëꞌ rëbijëꞌ Jesús: ―¿Bi yelaꞌ rnabëꞌ de quioꞌ? ¿Nu quie yelaꞌ rnabëꞌ blaoloꞌ benꞌ yuꞌu huëtiꞌ luꞌu idaoꞌ rnabëꞌra? ");
INSERT INTO zpcNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Lëscanꞌ reꞌendaꞌ inabaꞌ leꞌe tu diꞌidzaꞌ. Chi iquëbile quiaꞌ dyëꞌëdi, naꞌra iniaꞌ leꞌe nu quie yelaꞌ rnabëꞌ blaohuaꞌ benꞌ yuꞌu huëtiꞌ luꞌu idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Nuz̃i useꞌelaꞌ Juan ta hueꞌnëꞌ lao benëꞌ? ¿Useꞌelaꞌ Diuzi lëbëꞌ? ¿O chi ta racazi laꞌadyiꞌnëꞌ bidëꞌ? Naꞌ uzulaojëꞌ najëꞌ rëbijëꞌ laguedyijëꞌ: ―Chi yëbironëꞌ: “Diuzi useꞌelëꞌ lëbëꞌ”, naꞌ huanëꞌ raꞌo: “¿Bixquienꞌ bigulele quienëꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero chi yëbironëꞌ: “Ta racazi laꞌadyiꞌnëꞌ bidëꞌ”, caora naꞌ huadzaꞌ ja benꞌ yedyi raꞌo, danꞌ najëꞌ rnë Juan tanun quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Naꞌra unajëꞌ rëbijëꞌ Jesús: ―Binezindoꞌ nu benꞌ useꞌelaꞌ lëbëꞌ. Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Lëscanꞌ nëꞌëdiꞌ, biiniaꞌ leꞌe nu quie yelaꞌ rnabëꞌ blaohuaꞌ benꞌ yuꞌu huëtiꞌ luꞌu idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Naꞌ una Jesús lëjëꞌ: ―¿Bi ca inale ca naca diꞌidzaꞌ iniaꞌ leꞌe? Uzu tu beꞌmbyu zu chopa z̃iꞌinëꞌ. Naꞌ yëbëꞌ tubiꞌ: “Z̃iꞌinaꞌ, tzioꞌ naꞌa yeziuꞌ usecho quie bedzuliꞌ quiaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naꞌ una z̃iꞌinëꞌ rëbinëꞌ lëbëꞌ: “¡Binan quiaꞌ tzaꞌa!” Pero ude naꞌ beyuebiꞌ pensari uyocazibiꞌ hue dyin. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Naꞌ uyo xuzijabiꞌ yaguëdyinëꞌ itu z̃iꞌinëꞌ: “Ziꞌinaꞌ, tzioꞌ naꞌa yeziuꞌ usecho quie bedzuliꞌ quiaꞌ.” Naꞌ unabiꞌ rëbibiꞌ xuzibiꞌ: “Hueꞌencazi tzaꞌa.” Pero biuyobiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Naꞌ inabaꞌ leꞌe: ¿Nula z̃iꞌinëꞌ bë cabëꞌ reꞌennëꞌ huejabiꞌ lao rupatejabiꞌ? Naꞌ unajëꞌ rëbijëꞌ Jesús: ―Biꞌ gudyëꞌ tanëro. Naꞌra una Jesús rëbinëꞌ lëjëꞌ: ―Tali rniaꞌ leꞌe, ja benꞌ nale benꞌ mala gula, len ja nigula rutiꞌ gusto quie, zaꞌ lëjëꞌ yeyuꞌujëꞌ ga rnabëꞌ Diuzi ca leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bida Juan bautista udixogueꞌnëꞌ leꞌe cabëꞌ reyaꞌalaꞌ huele ta hue quiele xtiꞌidzaꞌ Diuzi, naꞌ bigulele quienëꞌ. Pero yaca benꞌ mala gula len ja nigula rutiꞌ gusto quie, lëjëꞌ sí, gulejëꞌ quienëꞌ. Pero leꞌe baꞌalaꞌcazi blëꞌële cabëꞌ bë Juan, biptzaꞌle pensari quiele ta galele quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Naꞌ una Jesús: ―Uzënagale ca naca itu diꞌidzaꞌ iniaꞌ leꞌe. Uzu tu xanꞌ layela, benꞌ guza bedzuliꞌ. Bënëꞌ tu liꞌo psioguëꞌn. Lëzi udixunëꞌ tu yo lagaꞌ ga usinëꞌ nisa bedzuliꞌ. Bërënëꞌ tu yuꞌu sibi de yo ga cuia benꞌ rapa bedzuliꞌ. ’Naꞌ pcaꞌnnëꞌn lao naꞌa benꞌ hue dyin, uzaꞌnëꞌ zionëꞌ zituꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cati bdyin tiempo quie usecho quie bedzuliꞌ, naꞌra useꞌelëꞌ ja mozo quienëꞌ tzenabajëꞌ benꞌ hue dyin quie usecho ta reduꞌulaꞌ benꞌ xanꞌ layela yeziꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero bëxo benꞌ hue dyin ja benꞌ uyo. Naꞌ bëꞌjëꞌ quie tunëꞌ, bëtijëꞌ itunëꞌ, naꞌ udijëꞌ yo itunëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Naꞌ useꞌelaꞌ xanꞌ layela ja mozo tula. Pero bëcazi benꞌ hue dyin quiejëꞌ lëbi ca benꞌ uyo tanëro. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Abeyudyi bëjëꞌ canaꞌ, useꞌelëꞌ z̃iꞌinëꞌ, guquenëꞌ chi huaparajëꞌ z̃iꞌinëꞌ balaꞌana. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero cati blëꞌë ja benꞌ hue dyin abdyin z̃iꞌi xanꞌ layela, naꞌra unajëꞌ rëbijëꞌ laguedyijëꞌ: “Biꞌ zaꞌ ni, lëbiꞌ gaque quiebiꞌ layela. Uletzaꞌ gutirobiꞌ ta gaque quiero layela de niga.” ");
INSERT INTO zpcNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Canaꞌ bëjëꞌ, bëxojëꞌ lëbiꞌ, bebiojabiꞌ layela, bëtijëꞌ lëbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Naꞌ una Jesús unabanëꞌ lëjëꞌ: ―Cati yedyin xanꞌ layela, ¿biz̃i reyaꞌalaꞌ huenëꞌ quie ja benꞌ hue dyin? ");
INSERT INTO zpcNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Naꞌ unajëꞌ rëbijëꞌ Jesús: ―Yelaꞌ benꞌ mala quiejëꞌ, reyaꞌalaꞌ gutinëꞌ lëjëꞌ, biyëchiꞌlaꞌadyiꞌnëꞌ lëjëꞌ. Reyaꞌalaꞌ ucaꞌnnëꞌn lao naꞌa benꞌ hue dyin, benꞌ tula, benꞌ tzesan quie usecho ta reduꞌulaꞌ benꞌ xanꞌ layela yeziꞌnëꞌ tiempo quienan. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―¿Binelabale cabëꞌ nan lëꞌë guichi laꞌiya quie Diuzi? Rnan caniga: Yo lagaꞌ uruꞌun benꞌ rue huecuaꞌ, lëyo naꞌ beziꞌ Diuzi, bzunëꞌn ga rzulao besu. Dyin dyaꞌa bë Diuzi beyuenëꞌn yo belao ta guxuꞌn besu. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tanaꞌ lenaꞌ iniaꞌ leꞌe, como danꞌ biralele quiaꞌ, canaꞌ naca quiele ca quie benꞌ rue huecuaꞌ, benꞌ uruꞌun yo. Quie lenaꞌ bicuio Diuzi leꞌe gacale benꞌ hue dyin quienëꞌ. Naꞌ huabio Diuzi benꞌ tula, benꞌ tzesan ca quie usecho ta reyaꞌalaꞌ Diuzi yeziꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nu benꞌ bireꞌen gale quiaꞌ, gaca quienëꞌ ca quie benꞌ bguino lao yo, guquëꞌ hueꞌ z̃e. Lëscanꞌ nu benꞌ chuꞌun nëꞌëdiꞌ tzalaꞌla, huachuguliaꞌ quienëꞌ. Gaca quienëꞌ ca quie benꞌ pxaꞌdaꞌ yo lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Naꞌ cati be ja xanꞌ pxuzi len ja benꞌ partido fariseo cabëꞌ na ejemplo unë Jesús, naꞌra gucabëꞌjëꞌ rnë Jesús quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Naꞌ guꞌunjëꞌ guxujëꞌ Jesús, pero bdzebijëꞌ idzaꞌ ja benꞌ yedyi, danꞌ na ja benꞌ yedyi rnë Jesús tanun quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Naꞌ bzu Jesús itu diꞌidzaꞌ unëꞌ rëbinëꞌ lëjëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Naꞌ rniaꞌ leꞌe cabëꞌ rue Diuzi rnabëꞌnëꞌ. Ruenëꞌ ca nu rey, benꞌ bë tu lani cati ptzaganaꞌ z̃iꞌinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Naꞌ useꞌelaꞌ rey benꞌ tzelidza ja benꞌ guida lao lani, pero biguꞌunjëꞌ guidajëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Naꞌ useꞌelaꞌ rey naꞌ benꞌ tula ta tzelidzajëꞌ ja benꞌ guida lao lani unëꞌ rëbinëꞌ lëjëꞌ: “Uleyëbijëꞌ abëtiaꞌ ja bëdyihuaga quiaꞌ, bia naca ja reꞌene, bapsiñaꞌa ta gaojëꞌ. Yugun nacan puesto laguidatejëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero bibida benꞌ reyaꞌalaꞌ guida. Tunëꞌ uyonëꞌ layela quienëꞌ. Itunëꞌ uyonëꞌ huëtiꞌ quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Naꞌ los demás, bëxujëꞌ benꞌ useꞌelaꞌ rey tzalidza lëjëꞌ, bëꞌjëꞌ lëjëꞌ ziꞌ, bëtijëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Naꞌra bdzaꞌtzegue rey naꞌ. Useꞌelëꞌ soldado quienëꞌ tzeguëtijëꞌ lëjëꞌ, tzezeijëꞌ yedyi quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Naꞌ una rey rëbinëꞌ benꞌ tzelidza: “Yugun nacan puesto guida ja benëꞌ.” Pero benꞌ blidzajëꞌ guidaja, biguꞌun rey naꞌ. Naꞌ unëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","“Uletzio tzetale tu neza tzelidzale con nu benꞌ yedzagale ta guidajëꞌ lani quie huetzaganaꞌ.” Canaꞌ unëꞌ gudyinëꞌ benꞌ tzelidza. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Naꞌ uzaꞌjëꞌ yetajëꞌ tu neza utupajëꞌ benꞌ bedzagajëꞌ, laꞌacazi benꞌ mala, laꞌacazi benꞌ dyaꞌa. Canaꞌ bedzaꞌ ja benëꞌ z̃an yuꞌu quie rey. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Naꞌra uyuꞌu rey luꞌu yuꞌu ta inëꞌ benꞌ bdyinja. Naꞌ blëꞌënëꞌ reꞌ tu beꞌmbyu, pero binaconëꞌ z̃abanëꞌ ca naca z̃aba benꞌ bdyin ga raca lani quie huetzaganaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Naꞌ una rey rëbinëꞌ lënëꞌ: “Bichaꞌ, ¿biz̃i guca uyuꞌuloꞌ reꞌloꞌ ni, binacoloꞌ z̃aboꞌ ca naca z̃aba benꞌ bdyin ga raca lani quie huetzaganaꞌ?” Naꞌ ureꞌnëꞌ chizi. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Naꞌ una rey rëbinëꞌ benꞌ ruꞌe laze: “Ulequio niꞌa naꞌanëꞌ. Ulechuꞌunnëꞌ lao lato chula ga cuedyinëꞌ gao leinëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Rëz̃i Diuzi benꞌ zë, benꞌ inao xnezëꞌ, pero balazijëꞌ guida inao xnezëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Naꞌra uyo ja benꞌ partido fariseo begaꞌnjëꞌ diꞌidzaꞌ len laguedyijëꞌ huejëꞌ trampa quie Jesús ta quilojëꞌ diꞌidzaꞌ ta gaojëꞌ lëbëꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Naꞌ useꞌelaꞌjëꞌ ibala benꞌ naca partido quiejëꞌ tuz̃e len bala benꞌ naca partido Herodes, unajëꞌ rëbijëꞌ Jesús: ―Maestro, nezindoꞌ rnaoꞌ tali, rusëdioꞌ benëꞌ ca naca xneza Diuzi. Tuzicazi ca ruꞌelaoꞌ benëꞌ diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Unacara cabëꞌ naca tu pensari quioꞌ: ¿Rnabandoꞌ luëꞌ chi run Diuzi lato quiz̃oro impuesto lao rey quie benꞌ romano? ");
INSERT INTO zpcNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Naꞌra gucabëꞌ Jesús cabëꞌ modo reguilojëꞌ ta huejëꞌ tamala quiëꞌ. Naꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Benꞌ huiziꞌ yëꞌ nacale. ¿Bixquienꞌ reꞌenle huele trampa quiaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Uleluꞌecara nëꞌëdiꞌ bi naque dumi ruquiz̃ole impuesto. Naꞌ bluꞌejëꞌ lëbëꞌ tu dumi denario. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bëꞌ blëꞌë Jesús len, naꞌ unabanëꞌ lëjëꞌ: ―¿Nu benꞌ zu laohue lëꞌë dumi? ¿Bi na letra dyia lëꞌën? ");
INSERT INTO zpcNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Naꞌ unajëꞌ rëbijëꞌ Jesús: ―Lao rey quie benꞌ romano zu lëꞌën. Naꞌra una Jesús rëbinëꞌ lëjëꞌ: ―Ulehueꞌ benꞌ naca gobierno ta reduꞌulanëꞌ siꞌnëꞌ. Lëscanꞌ ulehueꞌ Diuzi ta reduꞌulanëꞌ siꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cati bejëꞌ cabëꞌ una Jesús, naꞌra tu begaꞌnzijëꞌ rebanejëꞌ. Naꞌ psanjëꞌ quiëꞌ zeyojëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lëdza naꞌtezi uyo bala ja benꞌ partido saduceo yenaꞌjëꞌ Jesús. Naꞌra birale ja benꞌ partido saduceo chi hueban benꞌ huati. Tanaꞌ lenaꞌ unajëꞌ rëbijëꞌ Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, una Moisés chi guti tu beꞌmbyu zu z̃gule, naꞌ ganu z̃iꞌinëꞌ zu, reyaꞌalaꞌ yeziꞌ benꞌ bichinëꞌ xcula benꞌ guti tacuenda su z̃iꞌijëꞌ lao laza z̃iꞌi benꞌ guti. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Naꞌ guca dza naꞌ uzu gadyi bichi beꞌmbyu yedyi quiendoꞌ. Naꞌ ptzaganaꞌ benꞌ nëro, pero gutinëꞌ ganu z̃iꞌinëꞌ uzu. Lenaꞌ abeziꞌ benꞌ bichinëꞌ, benꞌ urupe, nigula quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lëscanꞌ guti benꞌ urupe ganu z̃iꞌinëꞌ uzu. Lenaꞌ abeziꞌ benꞌ bichinëꞌ, benꞌ uyune, nigula quienëꞌ. Pero cabëꞌ guca quie benꞌ nëro len benꞌ urupe, lëscanaꞌ guca quie benꞌ uyune len los demás yaca bichinëꞌ hasta lao gadyi bichijëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ude naꞌ gutirë nigula quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Naꞌra inabandoꞌ luëꞌ, cati yeban ja benꞌ baguti, ¿nulajëꞌ naquëꞌ quiejëꞌ lëbëꞌ lao gadyijëꞌ como yugujëꞌ uzulëjëꞌ lëbëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Leꞌe sí, nequixile como danꞌ binezile cabëꞌ rnan lëꞌë guichi laꞌiya quie Diuzi. Lëscanꞌ binezile ca naca yelaꞌ huaca quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cati babeban ja benꞌ baguti, bisulëjëꞌ laguedyijëꞌ ca z̃gulajëꞌ ca xquiujëꞌ. Gaca quiejëꞌ ca quie yaca ángel quie Diuzi, benꞌ yuꞌuja guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Naꞌ quie benꞌ baguti yeban, ¿binelabale lëꞌë guichi laꞌiya quie Diuzi cabëꞌ unëꞌ leꞌe? Unëꞌ caniga: ");
INSERT INTO zpcNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nacaꞌ Diuzi quie xuzixtaꞌoloꞌ Abraham, len quie xuzixtaꞌoloꞌ Isaac, len quie xuzixtaꞌoloꞌ Jacob.” Canaꞌ una Diuzi. Lenaꞌ niaꞌ leꞌe, Diuzi rlëꞌënëꞌ lëjëꞌ ca benꞌ neban, como danꞌ rlëꞌë Diuzi tuzicazi ca benꞌ neban len benꞌ aguti. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cati be ja benëꞌ cabëꞌ una Jesús quie benꞌ guti beban, naꞌra tu bebanezijëꞌ cabëꞌ diꞌidzaꞌ rusëdinëꞌ ja benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cati unezi benꞌ partido fariseo cabëꞌ bë Jesús quie benꞌ partido saduceo, biubinjëꞌ binajëꞌ yëbijëꞌ Jesús, naꞌra beguꞌudiꞌjëꞌ ga zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Naꞌ tu benꞌ quiejëꞌ, benꞌ rusëdi ley quie Moisés, guꞌunnëꞌ huenëꞌ trampa quie Jesús. Canaꞌ unëꞌ rëbinëꞌ lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿nula mandamiento nacaran belao quie ley pcaꞌn Diuzi lao naꞌa Moisés? ");
INSERT INTO zpcNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―“Idyëꞌëro xaꞌnro Diuzi du guicho du laꞌadyiꞌro.” ");
INSERT INTO zpcNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lëlenaꞌ nacaran mandamiento belaora. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Derë itu mandamiento nacarën belao. Ilëꞌëtiꞌzi birnën lëbi ca mandamiento belaora. Len rnan caniga: “Idyëꞌële laguedyile cabëꞌ nedyëꞌële cuinle.” ");
INSERT INTO zpcNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Naꞌ niaꞌ leꞌe duz̃e ca na ley pcaꞌn Diuzi lao naꞌa Moisés len duz̃e ca una ja benꞌ profeta dza naꞌ, nacan quie chopa mandamiento belao. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tu raca neneguꞌudiꞌ ja benꞌ partido fariseo, ");
INSERT INTO zpcNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―¿Bi ca nale quie benꞌ naca Cristo? ¿Nu z̃iꞌinëꞌ naquëꞌ? Naꞌ unajëꞌ rëbijëꞌ lëbëꞌ: ―Z̃iꞌi rey David naquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―¿Ca biz̃i guca caora una rey David, du yuꞌunëꞌ Bichi Be quie Diuzi, unëꞌ naca Cristo Señor quienëꞌ? Porque canaꞌ una David caora unëꞌ caniga: ");
INSERT INTO zpcNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Una Diuzi rëbinëꞌ benꞌ naca Señor quiaꞌ: “Ureꞌ cuëtaꞌ zaquëꞌ yebë niga, hasta idyin dza cuëchaꞌ xniꞌaloꞌ yaca benꞌ rudie luëꞌ.” Canaꞌ una rey David. ");
INSERT INTO zpcNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Naꞌ rnabaꞌ leꞌe, ¿cómo naca Cristo z̃iꞌi suba rey David, chi cuin rey David unëꞌ naca Cristo Señor quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Naꞌ ni tu diꞌidzaꞌ biubinjëꞌ yëbijëꞌ lëbëꞌ. Desde dza naꞌ, bira beyaz̃ojëꞌ inabarajëꞌ lëbëꞌ bi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Naꞌra una Jesús rëbinëꞌ ja benëꞌ nitaꞌ naꞌ len ja benꞌ quienëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ja benꞌ rusëdi ley quie Moisés, len ja benꞌ partido fariseo, nacan dyin quiejëꞌ rusëdijëꞌ benëꞌ cabëꞌ nan lëꞌë guichi ley ta pcaꞌn Diuzi lao naꞌa Moisés. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Naꞌ reyaꞌalaꞌ hue quiele ca inajëꞌ, pero binaole huele cabëꞌ ruejëꞌ, como danꞌ biruejëꞌ tuzi ca najëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ruejëꞌ ca quie benꞌ ruguaꞌa yuaꞌ ziꞌ gula laguedyi, tu ta bisueyaquëꞌ. Pero biyeyëchiꞌlaꞌadyiꞌjëꞌ yaca benëꞌ ni siquiera ledaoꞌzi ta gacalëjëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tuzi ta ilëꞌë benëꞌ lëjëꞌ dyaꞌa ruejëꞌ, pero bëꞌ ruezijëꞌ raxejëꞌ udaꞌjëꞌ tu guichi daoꞌ quie Diuzi z̃basijëꞌ. Raxejëꞌ utubijëꞌ itu guichi quie Diuzi z̃ichojëꞌ. Raxejëꞌ gacojëꞌ z̃abajëꞌ tona. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Reꞌenjëꞌ cueꞌjëꞌ ga naca tzaoꞌ cati raojëꞌ ga raca lani. Lëscanꞌ reꞌenjëꞌ cueꞌjëꞌ ga rbeꞌ benꞌ balaꞌana luꞌu idaoꞌ sinagoga. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Reꞌenjëꞌ gapalaꞌn benëꞌ lëjëꞌ dyëꞌëdi du tu neza. Raxejëꞌ yëbi ja benëꞌ lëjëꞌ: “Maestro.” ");
INSERT INTO zpcNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Bihuele lato ta ina ja benëꞌ leꞌe: “Maestro”, porque yugulule naca tuzi bichile, lëscanꞌ tuzi nëꞌëdiꞌ nacaꞌ maestro quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Lëzi nitu nitu benꞌ nitaꞌ lao yedyi layu, bihuele lato yëbilejëꞌ: “Xuzaꞌ”, porque tuzi Xuziro zu, benꞌ zu guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Lëscanꞌ bihuele lato ta ina ja benëꞌ leꞌe: “Xaꞌnaꞌ luëꞌ”, porque tuzi nëꞌëdiꞌ nacaꞌ xaꞌnle. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Naꞌ rniaꞌ leꞌe, con nu benꞌ racalë laguedyi, lënëꞌ nacarëꞌ benꞌ belao ladole. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Porque nu benꞌ rue z̃e cuine, lëbenꞌ naꞌ nacarëꞌ benꞌ yëchiꞌ lao Diuzi. Pero nuꞌ benꞌ birue cuine benꞌ z̃e, lëbenꞌ naꞌ nacarëꞌ benꞌ z̃e lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Leꞌe benꞌ rusëdi ley quie Moisés, len leꞌe benꞌ partido fariseo, nacan bayëchiꞌ gula quiele! Biruele tuzi ca nale. Ruzaꞌagale hue quie benëꞌ xtiꞌidzaꞌ Diuzi. Leꞌe birue quiele xtiꞌidzaꞌ Diuzi, lëscanꞌ bireꞌenle hue quie benꞌ tula xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Leꞌe benꞌ rusëdi ley quie Moisés, len leꞌe benꞌ partido fariseo, nacan bayëchiꞌ gula quiele! Biruele tuzi ca nale. Rgubale yuꞌu quie ja nigula guti xquiuhue, pero ta ilëꞌë ja benëꞌ leꞌe benꞌ rue quie ca rna Diuzi, naꞌ ruꞌelële Diuzi diꞌidzaꞌ zë. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Leꞌe benꞌ rusëdi ley quie Moisés, len leꞌe benꞌ partido fariseo, nacan bayëchiꞌ gula quiele! Biruele tuzi ca nale. Ratale con gatezi ta quilole nu benꞌ hue quie cabëꞌ ruele. Pero nu benꞌ usëdile ta hue quie cabëꞌ ruele, huacaterajëꞌ benꞌ malara ta tziojëꞌ guiꞌ gabila ca leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Huaca bayëchiꞌ quiele! Reꞌenle uluꞌele benꞌ tula ga tzionëꞌ, pero benꞌ laochula leꞌe. Naꞌ leꞌe nale: “Chi ruguntero Diuzi ruzëtoro idaoꞌ rnabëꞌra chi bi tu ta huero, biruen zi hueron. Pero chi ruguntero Diuzi ruzëtoro oro reꞌ luꞌu idaoꞌ rnabëꞌra, lenan sí, ruen zi hueron.” ");
INSERT INTO zpcNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Pero iniaꞌ leꞌe, benꞌ tondo, benꞌ laochula leꞌe! Binaca laꞌiya oro cuinzin. Tanun quie reꞌn luꞌu idaoꞌ rnabëꞌra, tanaꞌ naca laꞌiyan. Naca idaoꞌ rnabëꞌra laꞌiyaran ca oro reꞌ luꞌun. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Lëscanꞌ rnarële: “Chi ruguntero Diuzi ruzëtoro ruꞌaba chi bi tu ta huero, biruen zi hueron. Pero chi ruguntero Diuzi ruzëtoro gun dyia ruꞌaba, lenan sí, ruen zi hueron.” ");
INSERT INTO zpcNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pero iniaꞌ leꞌe, ¡benꞌ tondo, benꞌ laochula leꞌe! Binaca laꞌiya gun cuinzin. Tanun quie dyian ruꞌaba, tanaꞌ naca laꞌiyan. Naca ruꞌaba laꞌiyaran ca gun dyia laonan. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Chi ruguntero Diuzi ruzëtoro ruꞌaba chi bi tu ta huero, quele tuzi ruꞌaba ruzëtoro como danꞌ tuzi naca ruꞌaba len gun. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Chi ruguntero Diuzi ruzëtoro idaoꞌ rnabëꞌra chi bi tu ta huero, quele tuzi idaoꞌ rnabëꞌra ruzëtoro como tuzi naca idaoꞌ rnabëꞌra len Diuzi, benꞌ zu luꞌun. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Lëscanꞌ chi ruguntero Diuzi ruzëtoro guibá chi bi tu ta huero, canaꞌ ruzëtorëro Diuzi lënëꞌ xlatoguëꞌ ga reꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Leꞌe benꞌ rusëdi ley quie Moisés, len leꞌe benꞌ partido fariseo, nacan bayëchiꞌ gula quiele! Biruele tuzi ca nale. Lente ja laꞌagaꞌ ta ruen z̃iꞌ yelaꞌ huao quiele ruꞌele Diuzi tu cueꞌna quie lao chi cueꞌna, pero biruele bala quie ta naca belaora quie mandamiento quie Diuzi. Biruele tali. Bireyëchiꞌlaꞌadyiꞌle benëꞌ. Birue quiele quie Diuzi du guicho du laꞌadyiꞌle. Tanëro reyaꞌalaꞌ huele ta nacara belao quie Diuzi, naꞌtera hueꞌle Diuzi tu cueꞌna quie lao chi cueꞌna quie ta de quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Leꞌe reꞌenle uluꞌele benꞌ tula ga tzionëꞌ, pero benꞌ laochula leꞌe! ¡Leꞌe ruele z̃e ta naca lëꞌëtiꞌzi, naꞌ biruele z̃e ta naca belao! ");
INSERT INTO zpcNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Leꞌe benꞌ rusëdi ley quie Moisés, len leꞌe benꞌ partido fariseo, nacan bayëchiꞌ gula quieleꞌ Biruele tuzi ca nale. Rguibile dyëꞌëdi xcuꞌudzula taza len plato. Naꞌ rudzeꞌle luꞌun ta rbanle quie benëꞌ rziꞌlejëꞌ yëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Leꞌe benꞌ partido fariseo, nacale ca benꞌ laochula. Nacale ca taza plato neyëri xcuꞌudzun, pero yuꞌu luꞌun ta bayatza. Uletzaꞌ pensari yuꞌu luꞌu guicho laxtaꞌole, naꞌtera gacale yëri duz̃ele lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Leꞌe benꞌ rusëdi ley quie Moisés, len leꞌe benꞌ partido fariseo, huaca bayëchiꞌ gula quiele! Biruele tuzi ca nale. Nacale ca quie ta rucuaꞌjëꞌ ga de benꞌ huati. Rudzeꞌjëꞌn ta bezëri xcuꞌudzun, pero luꞌunan yuꞌu chita quie benꞌ huati len ta bayatza. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Canaꞌ naca quie leꞌe. Rlëꞌë ja benëꞌ leꞌe benꞌ huen, pero bëꞌ ruezile biruele tuzi ca nale, yuꞌu pensari mala luꞌu guicho laxtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Leꞌe benꞌ rusëdi ley quie Moisés, len leꞌe benꞌ partido fariseo, huaca bayëchiꞌ gula quiele! Biruele tuzi ca nale. Leꞌe rucuaꞌle ba quie benꞌ huati, benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi dza naꞌte. Lëzi ruetzaꞌole ba quie ja benꞌ bë quie xtiꞌidzaꞌ Diuzi dza naꞌte. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Naꞌ lëzi rnale rëbile laguedyile: “Chanꞌ raꞌo nitaꞌro dza unitaꞌ xuzixtaꞌoro, biguꞌunro guti xuzixtaꞌoro ja benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi.” ");
INSERT INTO zpcNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ca diꞌidzaꞌ rnële ruluꞌen dyëꞌëdi nezile bëti xuzixtaꞌole benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi dza naꞌte. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Naꞌ leꞌe reꞌenle useyudyile huele cabëꞌ uzulao xuzixtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Leꞌe ruele ca rue bëla rguiꞌidyiꞌ laga cabëꞌ bë xuzixtaꞌole! ¿Biz̃i ca huele ta bihue Diuzi leꞌe castigo tziole guiꞌ gabila? ");
INSERT INTO zpcNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Quie lenaꞌ iseꞌelaꞌ laole ja benꞌ quixogueꞌ xtiꞌidzaꞌ Diuzi, benꞌ nezi rusëdi quie Diuzi. Pero leꞌe gutile balajëꞌ, naꞌ ibalajëꞌ udaꞌle lëjëꞌ lëꞌë yaga cruzo. Naꞌ ibalajëꞌ hueꞌle ziꞌ luꞌu idaoꞌ sinagoga quiele ulaolejëꞌ tu tu yedyi. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Canaꞌ hue Diuzi dulaꞌ quiele, danꞌ bëtile ja benꞌ quienëꞌ, desde dza cati ureꞌ dyilayu caora bëti Caín Abel, hasta dza bëtijëꞌ Zacarías, benꞌ naca z̃iꞌi Berequías. Bëti xuzixtaꞌole lëbëꞌ ruꞌa idaoꞌ rnabëꞌra gaꞌalaꞌ ga zu ruꞌaba. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tali rniaꞌ leꞌe, huida dulaꞌ xquia quie xuzixtaꞌole, benꞌ bëti benꞌ quie Diuzi, gacan z̃baꞌagaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Naꞌ una Jesús: ―Benꞌ ciudad Jerusalén, benꞌ ciudad Jerusalén, leꞌe rutile ja benꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi. Leꞌe rguile yo ja benꞌ rseꞌelaꞌ Diuzi laole. Zë lasa guꞌundaꞌ gapaꞌ leꞌe ca rapa biu z̃iꞌibaꞌ z̃an xilabaꞌ, pero biguꞌunle. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ilëꞌëtiꞌzi idachi ciudad quiele yegaꞌnnan canaꞌzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tanaꞌrniaꞌ leꞌe, ilëꞌëtiꞌzi bira ilëꞌële nëꞌëdiꞌ. Cati idyin dza inale: “Naca laꞌiya benꞌ useꞌelaꞌ Diuzi”, naꞌtera ilëꞌële nëꞌëdiꞌ tatula. ―Canaꞌ una Jesús rëbinëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Naꞌra bero Jesús luꞌu idaoꞌ rnabëꞌra, uzaꞌnëꞌ zioguëꞌ cati bebigaꞌ benꞌ quienëꞌ ga zënëꞌ. Naꞌ uzulaojëꞌ rebanejëꞌ ca naca idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Ulenaꞌ cabëꞌ naca idaoꞌ rnabëꞌra. Pero tali rniaꞌ, huabiaguiꞌn duz̃eten, ni tu yo bira yegaꞌnnan xcuꞌudzu laguedyin. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Naꞌra uzaꞌjëꞌ ziojëꞌ ga zu tu yaꞌa laona yaꞌa Olivos. Naꞌ ureꞌ Jesús cati bebigaꞌ ja benꞌ quiëꞌ ga reꞌnëꞌ tu ganu dyilaꞌ, unajëꞌ rëbijëꞌ lëbëꞌ: ―Reꞌenndoꞌ inaoꞌ nëtoꞌ bata cuiaguiꞌ idaoꞌ rnabëꞌra. Lëzi reꞌenndoꞌ inaoꞌ biz̃i gaca cati yeguidoꞌ tatula, naꞌ lëscanaꞌrë cati iyudyi quie dyilayu. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Gapale cuidado ta bisiꞌ benëꞌ leꞌe yëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Huida benꞌ zë inajëꞌ napajëꞌ yelaꞌ rnabëꞌ quiaꞌ. Lëscanꞌ inajëꞌ: “Nacaꞌ Cristo”. Pero huaziꞌjëꞌ yëꞌ benꞌ zë. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ina ja benëꞌ ga raca dila, ga sulao dila, pero bidzebile, danꞌ ruen zi gacacazi canaꞌ. Nerdziogue idyin dza iyudyi dyilayu. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dila zë gaca tu yedyi conlë ja benꞌ yedyi tula. Naꞌ yedyi zë gaca ubin, gaca yelaꞌ hueꞌ, gaca uz̃uꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Canaꞌ gaca cati sulao yedzagalao ja benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Naꞌ usedyin benëꞌ leꞌe lao naꞌa ja benꞌ rnabëꞌ ta usacajëꞌ leꞌe bizinaquezi, gutijëꞌ leꞌe. Udie benëꞌ leꞌe danꞌ nacale benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lëdza naꞌ usan benꞌ zë bira galejëꞌ quiaꞌ. Udiejëꞌ laguedyijëꞌ, usedyinjëꞌ laguedyijëꞌ lao naꞌa benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Huida benꞌ zë, benꞌ hueziꞌ yëꞌ, inajëꞌ rnëjëꞌ tanun quie Diuzi, pero benꞌ zë siꞌjëꞌ yëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tantozi gaca tazëdi, bira idyëꞌë yaca benëꞌ laguedyijëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero nu benꞌ sue biusan inao nëꞌëdiꞌ dza zunëꞌ lao dyilayu, huaziꞌ Diuzi lëjëꞌ yeyojëꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Huayo ja benëꞌ tzetixogueꞌjëꞌ xtiꞌidzaꞌ Diuzi duz̃e yedyi layu ta inezijëꞌ zu Diuzi dispuesto yeyojëꞌ tzasulëjëꞌ lëbëꞌ ga rnabëꞌnëꞌ. Te naꞌ, yeyudyi quie dyilayu. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Bzu profeta Daniel diꞌidzaꞌ lëꞌë guichi cabëꞌ naca tu ta udyiaguiꞌ benëꞌ, ratza Diuzi len. Reyaꞌalaꞌ tzioñeꞌele cabëꞌ niaꞌ leꞌe. Caora ilëꞌële badyia tu ta udyiaguiꞌ benëꞌ, ratza Diuzi len luꞌu idaoꞌ rnabëꞌra, ");
INSERT INTO zpcNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","naꞌra reyaꞌalaꞌ yez̃uno ja benꞌ nitaꞌ estado Judea yeyojëꞌ guixiꞌ daoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Chi nitaꞌjëꞌ laliꞌa, tanto ruguinte yez̃unojëꞌ, bireyaꞌalaꞌ yeyuꞌujëꞌ luꞌu yuꞌu quiejëꞌ siꞌjëꞌ bi ta de. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Lëscanaꞌ chi zujëꞌ layela, reyaꞌalaꞌ yez̃unojëꞌ biyezaꞌjëꞌ yeyojëꞌ tzez̃iꞌjëꞌ z̃abajëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Gaca bayëchiꞌ quie ja nigula nuꞌa z̃iꞌine len ja nigula zu xcuidiꞌ raꞌadyiꞌ dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Reyaꞌalaꞌ hueꞌlële Diuzi diꞌidzaꞌ ta gacalënëꞌ leꞌe ta biuz̃unole tiempo ruen zaga, nica dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Canaꞌ lega yedzagalao yaca benëꞌ. Desde dza cati ureꞌ dyilayu, binedzagalao yaca benëꞌ cabëꞌ yedzagalao benꞌ yez̃uno dza zezaꞌ. Lëscanꞌ, bëꞌ yeyudyi bedzagalaojëꞌ, ganura benꞌ tula yedzagalao cabëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Chi biichugu Diuzi dza yedzagalaojëꞌ, biilajëꞌ. Pero huachugu Diuzi dza naꞌ cuenda gacalënëꞌ yaca benꞌ ulionëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Chi ina ja benëꞌ yëbijëꞌ leꞌe: “Ulenaꞌ, ni zu Cristo”, chi yëbijëꞌ leꞌe: “Ulenaꞌ, naꞌ zu Cristo”, bigalele quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Huida ja benꞌ huiziꞌ yëꞌ huejëꞌ cuinjëꞌ Cristo, huejëꞌ cuinjëꞌ benꞌ inë tanun quie Diuzi. Huejëꞌ milagro tacuenda siꞌjëꞌ yëꞌ len benꞌ ulio Diuzi, pero bihuejëꞌ gan siꞌjëꞌ benꞌ ulio Diuzi yëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Baoniaꞌ leꞌe huaca tu ta binegaca. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tanaꞌ lenaꞌ chi ina benëꞌ yëbijëꞌ leꞌe: “Ulenaꞌ, naꞌ zu Cristo lao lato dachi”, bitziole naꞌ. Chi yëbijëꞌ leꞌe: “Ulenaꞌ, naꞌ zu Cristo luꞌu yuꞌu”, bigalele quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bigalele quiejëꞌ como danꞌ cati yeguidaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, hualëꞌë yaca benëꞌ nëꞌëdiꞌ cabëꞌ ilëꞌë benëꞌ xniꞌ yesa cati rëpin ga rlë obidza rdi xniꞌn hasta ga reyen obidza. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Caora rlëꞌële recho ja bëchi ladza, canaꞌ inezile de tazigo raojabaꞌ. Lëcanaꞌ gaca inezile ganꞌ gaca canꞌ baoniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Naꞌ una Jesús: ―Layeyudyite dza yedzagalaojëꞌ, naꞌra yechula obidza, bira inaꞌ xniꞌ biuꞌ, huaguinu bélo gan dyian, huaz̃isi yugulu ta dyia guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Hualëꞌë benëꞌ tu ta binelëꞌëjëꞌ guibá. Lenaꞌ uluꞌen abdyin dza yeguidaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ. Naꞌ huabedyi yugulu ja benꞌ nitaꞌ lao yedyi layu, hualëꞌëjëꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, zaꞌa luꞌu beo. Hualëꞌëjëꞌ taz̃e de yelaꞌ huaca quiaꞌ, taz̃e de yelaꞌ rnabëꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naꞌra iseꞌelaꞌ yaca ángel quiaꞌ ta cuedyijëꞌ trompeta quiejëꞌ zidzo gula. Caora naꞌ yeguꞌudiꞌ ja benꞌ uliogaꞌ nëꞌëdiꞌ saꞌjëꞌ duz̃e yedyi layu guidajëꞌ ga zuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ulehue pensari ca raca quie yaga higo. Cati naca tacaꞌn reꞌene, naꞌ rasi laꞌagaꞌ quien, naꞌ nezile bazezaꞌ biuꞌ uba. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lëscanꞌ cati ilëꞌële araca cabëꞌ baoniaꞌ leꞌe, reyaꞌalaꞌ inezile baruen bagozi dza iyudyi quie dyilayu. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tali rniaꞌ leꞌe, tu bineya z̃iꞌi suba benꞌ nitaꞌ naꞌa, bëꞌ gaca cabëꞌ baoniaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Huade quie ta dyia guibá len lao dyila yu canaꞌzi, pero quie diꞌidzaꞌ rniaꞌ, biten canaꞌzi. Decazide gacan. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Nunu nezi bata idyin dza iyudyi dyilayu. Binezi ja ángel dyia guibá, binezdaꞌ nëꞌëdiꞌ z̃iꞌi Diuzi. Tuzi Xuzaꞌ Diuzi nezinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Cabëꞌ guca dza uzu Noé dyilayu, lëscanaꞌ gaca cati yeguidaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Naꞌ dza naꞌ cati baruen bago gaca juicio nisa, bigulejëꞌ. Nitaꞌjëꞌ riꞌo raojëꞌ, rutzaganaꞌ ja z̃iꞌijëꞌ hasta bdyin dza cati uyuꞌu Noé luꞌu barco quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Naꞌ bigucabëꞌjëꞌ bi gaca quiejëꞌ hasta dyin dza guca juicio nisa, canaꞌ biꞌa nisa yugulujëꞌ gutijëꞌ. Lëscanaꞌ gaca cati yeguidaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Cati idyin dza naꞌ, chi zu chopa benëꞌ layela, naꞌ yequiëꞌ ja ángel tunëꞌ, itunëꞌ yegaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Lëscanaꞌ chi zu chopa nigula hueto, naꞌ yequiëꞌ ja ángel tunëꞌ, itunëꞌ yegaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ulesu listo como danꞌ binezile bi hora yeguidaꞌ nëꞌëdiꞌ nacaꞌ xaꞌnle. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ulehue pensari canꞌ niaꞌ leꞌe. Chi nezi xaꞌn yuꞌu bi hora guida benꞌ uban du rëla, huazunëꞌ listo ta inaꞌnëꞌ bihuenëꞌ lato tzuꞌu benꞌ uban luꞌu yuꞌu quienëꞌ cuannëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Quie lenaꞌ, sule listo, como danꞌ cati ruele pensari biguidaꞌ, huidaꞌ, lëhora naꞌ cati guidaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Naꞌ una Jesús: ―Rniaꞌ leꞌe tu ejemplo quie tu mozo, benꞌ rioñeꞌe ruzu diꞌidzaꞌ. Naꞌ pcaꞌn xaꞌnnëꞌ lënëꞌ ta ugaonëꞌ ja benꞌ mozo quienëꞌ. Naꞌ uzaꞌnëꞌ zioguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Naꞌ huatzaxe xaꞌnnëꞌ lënëꞌ cati yedyinnëꞌ ilëꞌënëꞌ rue mozo zaꞌ cabëꞌ ta bënëꞌ lëbëꞌ mandado. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tali rniaꞌ leꞌe, ucaꞌn xaꞌnnëꞌ lao naꞌanëꞌ yugulu ta de quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero chi biruenëꞌ tahuen, chi raquenëꞌ biyedyinneza xaꞌnnëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","chi usacanëꞌ ja mozo quienëꞌ bizinaquezi, chi rdalënëꞌ benꞌ z̃udyi tuz̃e hueꞌe, ");
INSERT INTO zpcNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","naꞌ yedyin xaꞌnnëꞌ cati raquenëꞌ biyedyin xaꞌnnëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","naꞌra hue xaꞌnnëꞌ lëbëꞌ castigo ca castigo hue Diuzi benꞌ birue tuzi ca nayaquëꞌ. Huayojëꞌ guiꞌ gabila ga cuedyiyaꞌjëꞌ, ga gaojëꞌ leijëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Naꞌ una Jesús: ―Reꞌendaꞌ iniaꞌ leꞌe tu diꞌidzaꞌ cabëꞌ rue Diuzi inabëꞌnëꞌ cati idyin dza naꞌ. Nacan ca quie chi nigula cuidiꞌ, benꞌ uzaꞌja zioja ga raca huetzaganaꞌ. Nuꞌajabiꞌ lámpara yudzo aceite ta tziojabiꞌ lidyi bibyu utzaganaꞌ ta tzelezajabiꞌ lëbiꞌ guidabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Naꞌ guca gaꞌyoꞌ nigula listo. Naꞌ igaꞌyoꞌjabiꞌ bigucajabiꞌ listo. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Naꞌ ja nigula binaca listo bibiꞌajabiꞌ tu frasco huio aceite ta yeyudzo lámpara bëꞌ bebidyi aceite quien. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero ja nigula listo biꞌajabiꞌ tu frasco huio aceite len lámpara quiejabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Naꞌ udzë biꞌbyu utzaganaꞌ guidabiꞌ. Naꞌ unan gasijabiꞌ gusijabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Naꞌra ca du gatzo yela bejabiꞌ rbedyiyaꞌ ja benëꞌ unajëꞌ: “¡Bazaꞌ biꞌbyu utzaganaꞌ! ¡Ulero gapalaꞌnlebiꞌ!” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Naꞌ uyasa ja nigula cuidiꞌ yugujabiꞌ bgaꞌalaꞌjabiꞌ lámpara quiejabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Naꞌ lao gaꞌyoꞌjabiꞌ biguca listo gudyijabiꞌ igaꞌyoꞌjabiꞌ naca listo rëbijabiꞌ lëjabiꞌ: “Ulegun ledaoꞌ aceite quiele nëtoꞌ, danꞌ bareyula lámpara quiendoꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Naꞌra una gaꞌyoꞌjabiꞌ listo rëbijabiꞌ lëjabiꞌ: “Bigunndoꞌn, danꞌ chi gunndoꞌn, bigaquen quiendoꞌ lente leꞌe. Uletzio tzegueꞌlen ga rutiꞌnëꞌn ta gataꞌ quiele.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Naꞌ tu zio ja gaꞌyoꞌjabiꞌ biguca listo tzegueꞌjabiꞌ aceite, tu naꞌ bdyin biꞌbyu utzaganaꞌ. Naꞌ uyuꞌu igaꞌyoꞌjabiꞌ de aceite quie conlë biꞌbyu utzaganaꞌ luꞌu yuꞌu ga raca huetzaganaꞌ. Naꞌ besiojëꞌ yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ude naꞌ bedyin igaꞌyoꞌjabiꞌ unajabiꞌ rëbijabiꞌ biꞌbyu utzaganaꞌ: “¡Señor, Señor, usalu yuꞌu tzuꞌundoꞌ!” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Naꞌ una biꞌbyu utzaganaꞌ rëbibiꞌ lëjabiꞌ: “Tali binubëꞌdaꞌ leꞌe.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Naꞌ una Jesús rëbinëꞌ benꞌ quienëꞌ: ―Ulehue listo, danꞌ binezile bi dza, bi hora, yeguidaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Naꞌ una Jesús: ―Reꞌendaꞌ iniaꞌ leꞌe itu diꞌidzaꞌ cabëꞌ rue Diuzi rnabëꞌnëꞌ. Ruenëꞌ ca tu benꞌ reꞌen tzio yedyi tula. Tu zazaꞌnëꞌ tzionëꞌ guz̃inëꞌ ja mozo quienëꞌ ta pcaꞌnnëꞌ centavo quienëꞌ lao naꞌajëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Naꞌ biz̃i tu benꞌ mozo quiëꞌ bëꞌnëꞌ cadu gaꞌyoꞌ mila dumi plata. Itunëꞌ bëꞌnëꞌ cadu chopa mila dumi plata. Itunëꞌ bëꞌnëꞌ cadu tu mila dumi plata. Bëꞌnëꞌ quie quiejëꞌ dumi cabëꞌ nezinëꞌ ruelëjëꞌ dyin dumi. Naꞌra uzëꞌë zioguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Benꞌ mozo, benꞌ uz̃iꞌ gaꞌyoꞌ mila naꞌ, bëlënëꞌn dyin bënëꞌ gan igaꞌyoꞌ mila z̃iꞌinan. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Lëscanꞌ benꞌ uz̃iꞌ chopa mila, bëlënëꞌn dyin bënëꞌ gan ichopa mila z̃iꞌinan. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero naꞌ benꞌ uz̃iꞌ tu mila, uyonëꞌ yecachiꞌnëꞌn yeguenëꞌ tu yero ga bdzeꞌnëꞌn luꞌu yu. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Bëꞌ guca zë dza, naꞌ bedyin xanꞌ ja benꞌ mozo guz̃inëꞌ lëjëꞌ beyuelënëꞌ lëjëꞌ z̃ubaba. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Naꞌ tanëro bdyin benꞌ uz̃iꞌ gaꞌyoꞌ mila yesannëꞌ dumi. Naꞌ unëꞌ rëbinëꞌ xaꞌnnëꞌ: “Señor, benloꞌnëꞌ gaꞌyoꞌ mila. Naꞌ ni de igaꞌyoꞌ mila z̃iꞌinan ta biaꞌ gan.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Naꞌ una xaꞌnnëꞌ rëbinëꞌ lëbëꞌ: “Tahuen gula cabëꞌ baoꞌ. Mozo dyaꞌa nacoꞌ, ruzuloꞌ diꞌidzaꞌ quiaꞌ. Tadyaꞌa bëlaoꞌ tadaoꞌ pcaꞌnaꞌ lao naoꞌ, tanaꞌ ucaꞌnaꞌ lao naoꞌ taz̃era, idaohuero suro tuz̃e.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Naꞌ taorupe bdyin benꞌ uz̃iꞌ chopa mila yesannëꞌ dumi. Naꞌ unëꞌ rëbinëꞌ xaꞌnnëꞌ: “Señor, benloꞌnëꞌ chopa mila. Naꞌ ni de ichopa mila z̃iꞌinan ta biaꞌ gan.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Naꞌ una xaꞌnnëꞌ rëbinëꞌ lëbëꞌ: “Tahuen gula cabëꞌ baoꞌ. Mozo dyaꞌa nacoꞌ, ruzuloꞌ diꞌidzaꞌ quiaꞌ. Tadyaꞌa bëlaoꞌ tadaoꞌ pcaꞌnaꞌ lao naoꞌ, tanaꞌ ucaꞌnaꞌ lao naoꞌ taz̃era, idaohuero suro tuz̃e.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pero naꞌ taoyune bdyin benꞌ uz̃iꞌ tu mila. Naꞌ unëꞌ rëbinëꞌ xaꞌnnëꞌ: “Señor, nezdaꞌ nacoꞌ benꞌ reꞌen mozo quie ta huejëꞌ dyin gaca z̃iꞌinan dumi quioꞌ. Huetzagaoꞌ mandado ja mozo quioꞌ ta yeziꞌjëꞌ usecho gaca z̃iꞌinan quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Lenaꞌ bdzebaꞌ udyiayaꞌa dumi quioꞌ. Tanaꞌ yecachaꞌn luꞌu yu. Naꞌ ni de dumi quioꞌ. Gabi guca quien.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Naꞌ una xaꞌnnëꞌ rëbinëꞌ lënëꞌ: “Mozo mala z̃an huëdi nacoꞌ. Neziloꞌ huetzaguiaꞌ mandado ja mozo quiaꞌ ta yeziꞌjëꞌ usecho gaca z̃iꞌinan quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tanaꞌ reyaꞌalaꞌ huelaoꞌ dyin dumi quiaꞌ ta gaca z̃iꞌinan cuenda cati yelaꞌ tatula yeziꞌa dumi quiaꞌ len z̃iꞌinan.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Naꞌ una xaꞌnnëꞌ rëbinëꞌ benꞌ nitaꞌja naꞌ: “Uleguba tu mila dumi neziꞌnëꞌ. Ulehueꞌn benꞌ nezë chi mila. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nu benꞌ ruelë dyin ta pcaꞌnaꞌ lao nëꞌë, hueꞌraꞌlënëꞌ tazëra gacaran sobre. Pero nu benꞌ biruelë dyin ta pcaꞌnaꞌ lao nëꞌë, huegubaꞌ ta pcaꞌnaꞌ lao nëꞌë. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Naꞌra uledzeꞌ mozo z̃an huëdi niga lao lato chula ga cuedyinëꞌ, ga yedzagalaonëꞌ, ga gao leinëꞌ.” ―Canaꞌ una Jesús rëbinëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Naꞌ una Jesús: ―Cati yeguidaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, huabiꞌa xlatogaꞌ. Hueguidaliaꞌ ja ángel quiaꞌ. Huapalaꞌn ja benëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Naꞌ yeguꞌudiꞌ yugulu benꞌ tu tu yedyi de lao dyilayu laohuaꞌ. Useriaꞌ ja benëꞌ cuiogaꞌjëꞌ chopa cueꞌ cabëꞌ rue benꞌ rapa becoꞌ z̃iꞌilaꞌ, rbioguëꞌ becoꞌ z̃iꞌilaꞌ tzalaꞌla, naꞌ rbioguëꞌ chivo itzalaꞌla. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Canaꞌ huabiogaꞌ benꞌ nao xnezaꞌ zaquëꞌ yebë, pero huabiogaꞌ benꞌ binao xnezaꞌ zaquëꞌ yegaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Naꞌ iniaꞌ yëbaꞌ ja benꞌ zu zaquëꞌ yebë: “Uleda leꞌe, benꞌ neyëri laxtaꞌohue lao Diuzi. Uletzuꞌu guibá ga arnabëꞌ xuzaꞌ, ga pcuezanëꞌ desde dza cati ureꞌte dyilayu. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Lenaꞌ naca quiele, como danꞌ cati uduaꞌ, benle nëꞌëdiꞌ ta udaohuaꞌ. Cati ubilidaꞌ, benle nëꞌëdiꞌ ta huaꞌa. Cati uzaꞌa yedyi tula blaꞌa z̃an yuꞌu quiele, benle posada quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Cati bdzioguedaꞌ z̃abaꞌ, benle nëꞌëdiꞌ ta gucuaꞌ. Cati gucaꞌ z̃huiꞌa, cati gutaꞌ dyiguiba, bidale bedenaꞌle nëꞌëdiꞌ.” Canaꞌ yëbaꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Naꞌra ina benꞌ neyëri laxtaꞌohue lao Diuzi yëbijëꞌ nëꞌëdiꞌ: “Señor, ¿bata blëꞌëndoꞌ luëꞌ udueloꞌ, naꞌ benndoꞌ ta udaoloꞌ? ¿Bata blëꞌëndoꞌ luëꞌ ubililoꞌ, naꞌ benndoꞌ ta hueꞌ eloꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Bata blëꞌëndoꞌ luëꞌ uzaoꞌ yedyi tula blaoꞌ z̃an yuꞌu quiendoꞌ, naꞌ benndoꞌ posada quioꞌ? ¿Bata blëꞌëndoꞌ bdziogueloꞌ z̃aboꞌ, naꞌ benndoꞌ gucoloꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Bata blëꞌëndoꞌ luëꞌ gutaꞌloꞌ luꞌu dyiguiba, naꞌ bedenaꞌndoꞌ luëꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Naꞌra iniaꞌ yëbaꞌjëꞌ: “Tali rniaꞌ leꞌe, yugute ta babële beyëchiꞌlaꞌadyiꞌle bichaꞌ, benꞌ nao xnezaꞌ, laꞌacazi benꞌ yëchiꞌ gula, canaꞌ beyëchiꞌlaꞌadyiꞌle nëꞌëdiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Naꞌra iniaꞌ yëbaꞌ ja benꞌ nitaꞌ zaquëꞌ yegaꞌ: “Ulebigaꞌ tzalaꞌla leꞌe benꞌ yuꞌu deꞌ lao Diuzi. Uletzio guiꞌ gabila ta bireyula tuzioli ta pcueza Diuzi quie xanꞌ taxiꞌibiꞌ len ja ángel quienan. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Lenaꞌ gaca quiele tziole, como danꞌ cati uduaꞌ, bibenle nëꞌëdiꞌ ta gaohuaꞌ. Cati ubilidaꞌ, bibenle nëꞌëdiꞌ ta yoꞌogaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Cati uzaꞌa yedyi tula blaꞌa z̃an yuꞌu quiele, bibenle posada quiaꞌ. Cati bdzioguedaꞌ z̃abaꞌ, bibenle ta gacuaꞌ. Cati guca z̃huiꞌa, gutaꞌ luꞌu dyiguiba, bibidale bedenaꞌle nëꞌëdiꞌ.” Canaꞌ yëbaꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Naꞌra inajëꞌ yëbijëꞌ nëꞌëdiꞌ: “Señor, ¿bata blëꞌëndoꞌ luëꞌ udueloꞌ? ¿Bata blëꞌëndoꞌ luëꞌ ubililoꞌ? ¿Bata blëꞌëndoꞌ luëꞌ uzaoꞌ yedyi tula blaoꞌ z̃an yuꞌu quiendoꞌ? ¿Bata blëꞌëndoꞌ luëꞌ bdziogueloꞌ z̃aboꞌ? ¿Bata blëꞌëndoꞌ luëꞌ guca z̃hueꞌloꞌ? ¿Bata blëꞌëndoꞌ luëꞌ gutaꞌloꞌ luꞌu dyiguiba, naꞌ bibeyëchiꞌlaꞌadyiꞌndoꞌ luëꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Naꞌ iniaꞌ yëbaꞌjëꞌ: “Tali rniaꞌ leꞌe, yugute ta bibële bibeyëchiꞌlaꞌadyiꞌle ja benꞌ nao xnezaꞌ, laꞌacazi benꞌ yëchiꞌ gula, canaꞌ bibeyëchiꞌlaꞌadyiꞌle nëꞌëdiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Caora naꞌ tziojëꞌ guiꞌ gabila ta bireyula tuzioli. Pero ja benꞌ neyëri laxtaꞌohue lao Diuzi, huayojëꞌ tzesulëjëꞌ Diuzi guibá tuzioli. ―Canaꞌ una Jesús rëbinëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cati beyudyi una Jesús canaꞌ, naꞌ unëꞌ rëbinëꞌ benꞌ quienëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Como banezile, ichopa dzazi idyin gaꞌalaꞌ lani pascua. Naꞌ usedyin benëꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, lao naꞌa benꞌ rnabëꞌ ta udaꞌjëꞌ nëꞌëdiꞌ lëꞌë yaga cruzo. ―Canaꞌ una Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Naꞌra caora naꞌ, beguꞌudiꞌ ja benꞌ naca xanꞌ pxuzi, len yaca los demás benꞌ rusëdi ley quie Moisés, len benꞌ rnabëꞌ quie benꞌ Israel, beguꞌudiꞌjëꞌ laliꞌa palacio quie Caifás, benꞌ naca xanꞌ pxuzi rnabëꞌra iza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Naꞌ psaqueꞌjëꞌ bi huejëꞌ ta guxujëꞌ Jesús balarazi gutijëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Canaꞌ unajëꞌ rëbijëꞌ laguedyijëꞌ: ―Bireyaꞌalaꞌ gutironëꞌ tu neraca lani ta biidzaꞌ ja benëꞌ raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Naꞌra uzaꞌ Jesús lënëꞌ yaca benꞌ quiëꞌ ziojëꞌ yedyi Betania uyuꞌujëꞌ yuꞌu quie Simón, benꞌ guca yelaꞌ hueꞌ ta ruzudzoꞌ cuerpo quienëꞌ dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Naꞌ ubigaꞌ tu nigula ga reꞌ Jesús lao mesa. Nuꞌ anëꞌ tu frasco yo alabastro yudzo aceite tzaoꞌ ta rlaꞌn z̃ixi z̃eo. Naꞌ blatonëꞌn guicho Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Cati blëꞌë ja benꞌ quie Jesús cabëꞌ bë nigula, naꞌra bdzaꞌjëꞌ unajëꞌ rëbijëꞌ laguedyijëꞌ: ―¿Bixquienꞌ beditoguëꞌ aceite canaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Reyaꞌalaꞌ gutiꞌnëꞌn zacaꞌn dumi z̃e tacuenda gacalënëꞌ benꞌ yëchiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Naꞌ be Jesús cabëꞌ rnajëꞌ, naꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―¿Bixquienꞌ ruele zëdi nigula niga? Tadyaꞌa bënëꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nitaꞌcazi benꞌ yëchiꞌ ladole yugu dza. Pero nëꞌëdiꞌ, baruen bago dza bira suliaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Lenaꞌ blatonëꞌ aceite rlaꞌn z̃ixi z̃eo guichogaꞌ, danꞌ baruen bago dza gatiaꞌ udzeꞌjëꞌ cuerpo quiaꞌ luꞌu beló yo. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tali rniaꞌ leꞌe, con gatitezi tzetixogueꞌ benëꞌ xtiꞌidzaꞌ Diuzi inajëꞌ cabëꞌ reꞌen Diuzi gataꞌ yelaꞌ neban quie yaca benëꞌ tuzioli, quixogueꞌrëjëꞌ cabëꞌ bë nigula niga quiaꞌ. Canaꞌ yezaꞌlaꞌadyiꞌjëꞌ cabëꞌ bënëꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Naꞌra uyo tu benꞌ quie Jesús, benꞌ lao Judas Iscariote, yegueꞌlënëꞌ ja xanꞌ pxuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Naꞌ una Judas rëbinëꞌ lëjëꞌ: ―¿Gaca gunle nëꞌëdiꞌ chanꞌ usedyinaꞌ Jesús lao naꞌale? Naꞌ udiz̃ujëꞌ lëbëꞌ galobechi dumi plata. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Naꞌra rusaqueꞌ Judas nacala huenëꞌ ta usedyinnëꞌ Jesús lao naꞌa ja xanꞌ pxuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dza nëro uzu dza lani, dza rao ja benꞌ Israel yëta xtila biyuꞌun levadura, bebigaꞌ ja benꞌ quie Jesús ga zënëꞌ unajëꞌ rëbijëꞌ Jesús: ―¿Ga reꞌenloꞌ usiñaꞌndoꞌ ta gaoro quie lani pascua? ");
INSERT INTO zpcNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Uletzio ciudad Jerusalén tzenaꞌle tu benꞌ zu naꞌ. Naꞌ yëbilenëꞌ: “Cani una maestro: Baruen bago dza gatiaꞌ. Quie lenaꞌ gaoliaꞌ ja benꞌ quiaꞌ quie lani pascua z̃an yuꞌu quioꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Naꞌ bë ja benꞌ quie Jesús cabëꞌ bënëꞌ lëjëꞌ mandado. Uyojëꞌ psiñaꞌjëꞌ ta gaojëꞌ rtzeꞌ quie lani pascua. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cati bagula, bdyin Jesús ureꞌlënëꞌ ja chipchopa benꞌ quiëꞌ lao mesa. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tu raca neyuꞌujëꞌ raojëꞌ, una Jesús rëbinëꞌ lëjëꞌ: ―Tali rniaꞌ leꞌe, ladole zu tu benꞌ usedyin nëꞌëdiꞌ lao naꞌa benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Naꞌ guquejëꞌ bayëchiꞌ gula. Naꞌ unë tu huiojëꞌ rëbijëꞌ Jesús: ―Señor, ¿quele nëꞌëdiꞌ huaꞌ cabëꞌ unaoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Naꞌra una Jesús rëbinëꞌ lëjëꞌ: ―Nu benꞌ udyilë nëꞌëdiꞌ tuz̃e yëta quie luꞌu plato dyia niga, lëbëꞌ usedyinnëꞌ nëꞌëdiꞌ lao naꞌa benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Decazide gaca quiaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, cabëꞌ rnën lëꞌë guichi laꞌiya quie Diuzi. Pero bayëchiꞌ gula ta zaꞌ gaca quie benꞌ usedyin nëꞌëdiꞌ lao naꞌa benꞌ rnabëꞌ. Tadyaꞌacala quienëꞌ chanꞌ biuzunëꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Naꞌ una Judas, benꞌ usedyin Jesús lao naꞌa benꞌ rnabëꞌ, rëbinëꞌ lëbëꞌ: ―Maestro, ¿quele nëꞌëdiꞌ huaꞌ cabëꞌ unaoꞌ? Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Ajaꞌ, luëꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Naꞌ tu raca neraojëꞌ, bëxu Jesús yëta xtila unëꞌ rëbinëꞌ Diuzi: “Diuxcaleloꞌ.” Naꞌ bz̃uz̃unëꞌn bëꞌnëꞌn ja benꞌ quiëꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Ulegao, lëlen nacan ca quie cuerpo quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ude naꞌ, bëxunëꞌ tu copa vino nisa bedzuliꞌ, unëꞌ rëbinëꞌ Diuzi: “Diuxcaleloꞌ.” Naꞌ bëꞌnëꞌn ja benꞌ quienëꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Uleyoꞌon yugulule. Lëlen nacan ");
INSERT INTO zpcNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ca quie ren quiaꞌ. Lenaꞌ ilatogaꞌ gatiaꞌ cuenda yegaꞌntzaꞌolë Diuzi leꞌe tacubi, lëscanꞌ cuenda gataꞌ yelaꞌ hueziꞌz̃e quie yaca benꞌ zë. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pero rniaꞌ leꞌe, bira yoꞌogaꞌ vino nisa bedzuliꞌ tatula. Hasta que idyin dza zulële nëꞌëdiꞌ ga rnabëꞌ Xuzaꞌ Diuzi, naꞌtera yoꞌogaꞌ tacubi tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Naꞌ ude beyudyi bilajëꞌ tu himno, uzaꞌjëꞌ ziojëꞌ yaꞌa Olivos. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Naꞌ una Jesús rëbinëꞌ ja benꞌ quienëꞌ: ―Huasanle nëꞌëdiꞌ yugulule naꞌayela. Gaca quiele ca rnan lëꞌë guichi laꞌiya quie Diuzi: “Hueꞌ Diuzi lato guti ja benëꞌ xanꞌ becoꞌ z̃iꞌilaꞌ, naꞌtera huedzatza ja becoꞌ z̃iꞌilaꞌ quienëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero iyudyi guti ja benëꞌ nëꞌëdiꞌ, huebanaꞌ tatula, huabialaohuaꞌ laole tziole estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Naꞌra una Pedro rëbinëꞌ Jesús: ―Baꞌalaꞌcazi yugulujëꞌ usanjëꞌ luëꞌ, pero nëꞌëdiꞌ, biusancazaꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Naꞌ una Jesús rëbinëꞌ Pedro: ―Tali rniaꞌ luëꞌ, tu binecuedyi biu naꞌayela, huëboꞌ benëꞌ binubëꞌloꞌ nëꞌëdiꞌ tzona lasa. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Naꞌ una Pedro rëbinëꞌ Jesús: ―Baꞌalaꞌcazi chi gutirëjëꞌ nëꞌëdiꞌ len luëꞌ, biyëpaꞌ ja benëꞌ binubëꞌdaꞌ luëꞌ. Canaꞌrë una yaca los demás benꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Naꞌra bdyinlë Jesús ja benꞌ quienëꞌ ga lao Getsemaní, naꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Ni ulecueꞌ tu raca tzaꞌa niꞌ tzegueꞌliaꞌ Diuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Naꞌ uquiëꞌ Jesús Pedro len chopa z̃iꞌi Zebedeo, udyialaorajëꞌ ilëꞌëtiꞌ ga uzulao guque Jesús bayëchiꞌ gula. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Tanto raquedaꞌ bayëchiꞌ gula, reꞌennan gutin nëꞌëdiꞌ. Leꞌe yegaꞌnle niga, pero bigasile huele nëꞌëdiꞌ tuz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Naꞌra udyialaoranëꞌ ilëꞌëtiꞌ gutanëꞌ guzu ruꞌala layu, bëꞌlënëꞌ Diuzi diꞌidzaꞌ unëꞌ rëbinëꞌ Diuzi: ―Xuzaꞌ Diuzi, chi saqueꞌ ucachiꞌ ucuiꞌoloꞌ nëꞌëdiꞌ ca naca tazëdi gula bazaꞌ gaca quiaꞌ. Nacan ca quie tu taslaꞌ gula yoꞌogaꞌ. Pero bihueloꞌ cabëꞌ reꞌendaꞌ, hueloꞌ cabëꞌ reꞌencazoꞌ gaca. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Naꞌ zezaꞌnëꞌ bedyinnëꞌ ga nitaꞌ ja benꞌ quienëꞌ. Cati blëꞌënëꞌ arasijëꞌ, naꞌra unëꞌ rëbinëꞌ Pedro: ―¿Quele biuz̃aqueꞌle bigasile ni tu hora ta huele nëꞌëdiꞌ tuz̃e? ");
INSERT INTO zpcNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bigasile. Ulehueꞌlë Diuzi diꞌidzaꞌ tacuenda bihue xanꞌ taxiꞌibiꞌ leꞌe gan huele xquia ca tazëdi gula bazaꞌ quiele. Tali reꞌenle huelële nëꞌëdiꞌ tuz̃e, pero nerdzioguele fuerza quie Diuzi ta huele cabëꞌ reꞌenle huele. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Naꞌ taorupe zio Jesús yegueꞌlënëꞌ Diuzi diꞌidzaꞌ unëꞌ caniga: ―Xuzaꞌ Diuzi, chi bisaqueꞌ te canaꞌzi ca naca tazëdi gula bazaꞌ gaca quiaꞌ, naꞌra gacacazi ca reꞌenloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Naꞌra zezaꞌnëꞌ bedyinnëꞌ tatula ga nitaꞌ ja benꞌ quienëꞌ, pero nerasijëꞌ, danꞌ lega yuꞌu bichi gala laojëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Naꞌ psannëꞌ lëjëꞌ zioguëꞌ taoyune lasa yegueꞌlënëꞌ Diuzi diꞌidzaꞌ. Unëꞌ rëbinëꞌ Diuzi cabëꞌ unëꞌ taorupe. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Naꞌra zezaꞌnëꞌ tatula bedyinnëꞌ ga nitaꞌ ja benꞌ quienëꞌ. Naꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Naꞌa sí, gasile yeziꞌlaꞌadyiꞌle. Abdyin hora usedyin benëꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, lao naꞌa benꞌ napaja dulaꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ulechasa, tzioro. Bazaꞌ benꞌ usedyin nëꞌëdiꞌ lao naꞌa benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Naꞌ nezë Jesús ruꞌenëꞌ diꞌidzaꞌ cati bdyin Judas, benꞌ naca benꞌ quienëꞌ lao chipchopajëꞌ. Bdyinlënëꞌ ja benꞌ zë nuꞌajëꞌ macheta, nuꞌajëꞌ yaga. Bdyinjëꞌ useꞌelaꞌ ja xanꞌ pxuzi len ja benꞌ rnabëꞌ lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Naꞌ Judas, benꞌ usedyin Jesús lao naꞌajëꞌ, begaꞌnlënëꞌ lëjëꞌ diꞌidzaꞌ dza naꞌ caora gudyinëꞌ lëjëꞌ cani: ―Con benꞌ gaohuaꞌ tu situ xaꞌague, lëbenꞌ naꞌ guxule preso. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Naꞌ ubigaꞌ Judas ga zë Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―¡Padiux, Maestro! Caora naꞌ udaohuëꞌ Jesús tu situ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Padiux, bichaꞌ. ¿Bi rueloꞌ zaoꞌ niga? Naꞌra ubigaꞌjëꞌ bëxujëꞌ Jesús preso uquiëꞌjëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Caora naꞌ ulio tu benꞌ quie Jesús macheta quienëꞌ, uchugunëꞌ naga benꞌ naca mozo quie xanꞌ pxuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Naꞌ una Jesús rëbinëꞌ lënëꞌ: ―Bedzeꞌ macheta quioꞌ luꞌu lidyin. Nu benꞌ rdilaja conlë macheta, lëlëcazin gutin lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Binezoꞌ ca huelëcazi Xuzaꞌ nëꞌëdiꞌ? Chanꞌ inabaꞌ xuzaꞌ, iseꞌelëꞌ mazla tzona galo chi mila ja ángel ta gacalëjëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero chi inabaꞌ xuzaꞌ ta iseꞌelëꞌ ja ángel, naꞌ bisaqueꞌ gaca quiaꞌ cabëꞌ rnën lëꞌë guichi laꞌiya quie Diuzi ca reyaꞌalaꞌ gaca quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Naꞌra una Jesús rëbinëꞌ ja benꞌ bdyin bëxu lëbëꞌ: ―¿Abrole nuꞌale macheta, nuꞌale yaga, ta guxule nëꞌëdiꞌ? ¿Raquele nëꞌëdiꞌ benꞌ uban? Yugu dza rbiꞌa luꞌu idaoꞌ rnabëꞌra rusëdiaꞌ benëꞌ, pero bibëxule nëꞌëdiꞌ caora naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero canaꞌ guca tacuenda uzu diꞌidzaꞌ cabëꞌ diꞌidzaꞌ quie Diuzi bzu benꞌ profeta lëꞌë guichi dza naꞌte. Naꞌra psanlaꞌadyiꞌ ja benꞌ quie Jesús lëbëꞌ bz̃unojëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Naꞌ uquiëꞌ benꞌ bëxu Jesús preso lao Caifás, benꞌ naca xanꞌ pxuzi rnabëꞌra. Lenaꞌ neguꞌudiꞌ ja benꞌ rusëdi ley quie Moisés, len ja benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pero zio Pedro naohuëꞌ lëjëꞌ zituꞌla, bdyinnëꞌ laliꞌa yuꞌute quie xanꞌ pxuzi rnabëꞌra. Naꞌ uyuꞌunëꞌ ureꞌnëꞌ lado ja policía ta ilëꞌënëꞌ cabiz̃i gaca iyudyin. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Naꞌ rusaqueꞌ ja xanꞌ pxuzi, len yugu ja benꞌ rnabëꞌ quie idaoꞌ rnabëꞌra bi huejëꞌ ta gaojëꞌ Jesús xquia ta gutijëꞌ lëbëꞌ, baꞌalaꞌcazi tafalso gaojëꞌ lëbëꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero bibedzelejëꞌ ca inajëꞌ, baꞌalaꞌcazi unë ja benꞌ zë diꞌidzaꞌ falso contra lëbëꞌ. Naꞌ beyudyite bdyin chopa testigo falso. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Naꞌ unajëꞌ rëbijëꞌ benꞌ nitaꞌja naꞌ: ―Lëbenꞌ niga unëꞌ: “Udyiayaꞌa idaoꞌ rnabëꞌra, naꞌ yelisaꞌn tatula lao tzona dza.” ");
INSERT INTO zpcNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Naꞌra uzuli xanꞌ pxuzi rnabëꞌra, unëꞌ rëbinëꞌ Jesús: ―¿Bixquienꞌ birequëboꞌ? ¿Bi ca naoꞌ danꞌ rnëjëꞌ cabëꞌ unaoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero chizi begaꞌn Jesús. Naꞌ una xanꞌ pxuzi rnabëꞌra rëbinëꞌ Jesús: ―Rguntiaꞌ Diuzi zu guibá, guenëꞌ chi rnaoꞌ tali. Unë nëtoꞌ chi tali nacoꞌ Cristo, z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Tali nacaꞌ Cristo, z̃iꞌi Diuzi, cabëꞌ unaoꞌ. Lëscanꞌ iniaꞌ leꞌe, hualëꞌële nëꞌëdiꞌ, bichi yugulu benëꞌ, cati cuiꞌa zaquëꞌ yebë cuëta Diuzi, benꞌ de yelaꞌ rnabëꞌ z̃e quie. Lëscanꞌ hualëꞌële nëꞌëdiꞌ cati yeguidaꞌ tatula lao beo zë z̃an guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Naꞌra tantozi bdzaꞌ xanꞌ pxuzi rnabëꞌra, uchezanëꞌ z̃abëꞌ unëꞌ rëbinëꞌ ja benꞌ nitaꞌ naꞌ: ―Rnayaꞌ benꞌ niga Diuzi cabëꞌ rnëꞌ. Bira rnaban testigo tula. Abele cabëꞌ diꞌidzaꞌ unëꞌ rnayaꞌnëꞌ Diuzi. ¿Bi ca nale huero quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Naꞌ unajëꞌ rëbijëꞌ xanꞌ pxuzi rnabëꞌra: ―Napëꞌ dulaꞌ xquia, reyaꞌalaꞌ gatinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Naꞌra bdaꞌjëꞌ z̃enꞌ laohuëꞌ, bëꞌjëꞌ lëbëꞌ ziꞌ. Ibalajëꞌ udijëꞌ laohuëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","unajëꞌ rëbijëꞌ lëbëꞌ: ―Chi nacoꞌ Cristo, unacara nu udi luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tu neraca canaꞌ, ureꞌ Pedro laliꞌa. Naꞌ ubigaꞌ tu nigula rue dyin lao xaꞌne ga reꞌ Pedro unanëꞌ rëbinëꞌ lëbëꞌ: ―Lëscanaꞌ luëꞌ, rdalëraoꞌ Jesús, benꞌ estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Naꞌra una Pedro rëbinëꞌ lënëꞌ: ―Binubëꞌdaꞌ nu benꞌ naoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Naꞌ zio Pedro zënëꞌ ruꞌa puerta cati blëꞌë itu nigula zë naꞌ. Naꞌra una nigula naꞌ rëbinëꞌ ja benꞌ zë naꞌ: ―Lëscanꞌ lëbenꞌ naꞌ rdalërënëꞌ Jesús, benꞌ yedyi Nazaret. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Naꞌ una Pedro rëbinëꞌ lëjëꞌ: ―Ruguntiaꞌ Diuzi binubëꞌdaꞌ benꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tu chiꞌzi ude beyudyi naꞌ, ubigaꞌ ja benꞌ nitaꞌja naꞌ ga zë Pedro, unajëꞌ rëbijëꞌ Pedro: ―Tali luëꞌ nacaraoꞌ benꞌ quie benꞌ naꞌ como danꞌ nenate cabëꞌ rueloꞌ ruꞌeloꞌ diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Naꞌra rugunte Pedro Diuzi hue Diuzi lëbëꞌ castigo chi binacan tali cabëꞌ rnëꞌ. Naꞌ unëꞌ rëbinëꞌ ja benꞌ nitaꞌ naꞌ: ―Binubëꞌdaꞌ nu benꞌ nale canaꞌ. Caora naꞌ laoredyite tu biu. ");
INSERT INTO zpcNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Naꞌ bezaꞌlaꞌadyiꞌ Pedro cabëꞌ una Jesús gudyinëꞌ lëbëꞌ: “Tu binecuedyi biu naꞌayela, naꞌ tzona lasa yëboꞌ benëꞌ binubëꞌloꞌ nëꞌëdiꞌ.” Naꞌ bero Pedro zionëꞌ uredyinëꞌ ziꞌlaza gula. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Naꞌ cati uyaniꞌ naꞌ, begaꞌn yugu ja xanꞌ pxuzi, len ja benꞌ rnabëꞌ quie benꞌ Israel diꞌidzaꞌ bi huejëꞌ ta gutijëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Naꞌra nuquiojëꞌ Jesús psedyinjëꞌ lëbëꞌ lao naꞌa Poncio Pilato, benꞌ naca gobernador. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cati blëꞌë Judas cabëꞌ ruejëꞌ quie Jesús gutijëꞌ lëbëꞌ, naꞌra beyaquenëꞌ cabëꞌ bënëꞌ. Naꞌ uyonëꞌ yesannëꞌ lao ja xanꞌ pxuzi, len ja benꞌ rnabëꞌ galobechi dumi plata ta udiz̃ujëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Naꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Abiaꞌ tu xquia, psedyinaꞌ tu benꞌ bibi dulaꞌ xquia quie de lao naꞌale, naꞌ gutilenëꞌ. Pero naꞌ unajëꞌ rëbijëꞌ lëbëꞌ: ―¿Bi cuenda quie nëtoꞌ? Nacan cuenda quioꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Naꞌra bzala Judas dumi plata luꞌu idaoꞌ rnabëꞌra uyoguëꞌ bdzeꞌnëꞌ du quienëꞌ uzë ladza ta gutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Naꞌ beziꞌ ja xanꞌ pxuzi dumi plata unajëꞌ rëbijëꞌ laguedyijëꞌ: ―Bireyaꞌalaꞌ udzeꞌro dumi niga luꞌu caja ga yuꞌu gun quie Diuzi, como danꞌ xlaz̃o quie benꞌ bëti benëꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Naꞌra labegaꞌntejëꞌ diꞌidzaꞌ bi huejëꞌ conlë dumi yeyaꞌojëꞌ tu cueꞌ layu ga ucachiꞌjëꞌ benꞌ binaca benꞌ Israel. Naꞌ layu beyaꞌojëꞌ laona layu quie benꞌ rue taza plato dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pero naꞌa biralaona canaꞌ. Anexuba ja benëꞌ laona layu quie ren. Canaꞌ laona hasta naꞌadza. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Canaꞌ uzu diꞌidzaꞌ cabëꞌ una profeta Jeremías dza naꞌ. Lëdiꞌidzaꞌ naꞌ rnën caniga: “Aodiz̃u benꞌ Israel galobechi dumi plata precio quienëꞌ. Lëdumi aoz̃iꞌjëꞌ beyaꞌojëꞌ tu cueꞌ layu quie benꞌ rue taza plato. Canaꞌ una Diuzi gudyinëꞌ nëꞌëdiꞌ.” Canaꞌ una profeta Jeremías. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Naꞌra uquiëꞌjëꞌ psedyinjëꞌ Jesús lao naꞌa benꞌ naca gobernador. Naꞌ una benꞌ naca gobernador rëbinëꞌ Jesús: ―¿Nacoꞌ rey quie benꞌ Israel? Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Nacaꞌ rey quiejëꞌ cabëꞌ unaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Cati rao ja xanꞌ pxuzi, len benꞌ rnabëꞌ Jesús xquia, bibequëbinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Naꞌ una Pilato rëbinëꞌ Jesús: ―¿Quele bireloꞌ cabëꞌ najëꞌ raojëꞌ luëꞌ xquia? ");
INSERT INTO zpcNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero bibequëbi Jesús tatula. Tanaꞌ lenaꞌ lega beban gobernador. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Naꞌ de tu costumbre quiejëꞌ yebio gobernador tu benꞌ preso yuꞌu luꞌu dyiguiba tu raca lani pascua. Naꞌ yebio gobernador nutezi benꞌ reꞌen ja benëꞌ yero. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Naꞌ yuꞌu tu benꞌ lao Barrabás luꞌu dyiguiba. Nezi ja benëꞌ dyëꞌëdi naquëꞌ benꞌ mala. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Naꞌra bëꞌ beguꞌudiꞌ ja benëꞌ, naꞌ una Pilato rëbinëꞌ lëjëꞌ: ―¿Ca nuz̃ilajëꞌ reꞌenle yebiogaꞌ luꞌu dyiguiba? ¿Reꞌenle yebiogaꞌ Barrabás? ¿O chi reꞌenle yebiogaꞌ Jesús, benꞌ na useꞌelaꞌ Diuzi lëbëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Canaꞌ unëꞌ rëbinëꞌ lëjëꞌ danꞌ gucabëꞌnëꞌ yelaꞌ z̃ëꞌ quie benꞌ rnabëꞌ psedyinjëꞌ Jesús lao naꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Naꞌra tu ureꞌ Pilato ga ruenëꞌ justicia, caora useꞌelaꞌ z̃gulëꞌ diꞌidzaꞌ gudyinëꞌ lëbëꞌ: “Usanloꞌ quie benꞌ naꞌ, danꞌ bibi xquia napëꞌ. Uxusaꞌ udiyele cabëꞌ raca quienëꞌ. Lega rdëbidaꞌ quioꞌ chi biusanloꞌnëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero bëꞌlë ja xanꞌ pxuzi len ja benꞌ rnabëꞌ ja benëꞌ diꞌidzaꞌ ta inabajëꞌ ta yero Barrabás, pero ta gutijëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Naꞌ una gobernador rëbinëꞌ lëjëꞌ tatula: ―¿Nulajëꞌ lao rupajëꞌ reꞌenle yebiogaꞌ luꞌu dyiguiba? Naꞌ unajëꞌ rëbijëꞌ lëbëꞌ: ―Barrabás. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Naꞌ unaba Pilato rëbinëꞌ lëjëꞌ: ―¿Biz̃i huaꞌ quie Jesús, benꞌ na useꞌelaꞌ Diuzi lëbëꞌ? Naꞌ yugutejëꞌ unajëꞌ rëbijëꞌ Pilato: ―¡Udaꞌloꞌnëꞌ lëꞌë yaga cruzo! ");
INSERT INTO zpcNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Naꞌ una Pilato rëbinëꞌ lëjëꞌ: ―¿Biz̃i xquia bënëꞌ? Pero naꞌ unajëꞌ zidzo rëbijëꞌ lëbëꞌ: ―¡Udaꞌloꞌnëꞌ lëꞌë yaga cruzo! ");
INSERT INTO zpcNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Cati gucabëꞌ Pilato bisaqueꞌ gaca areglo, lëzi blëꞌënëꞌ bdzaꞌ ja benëꞌ, naꞌ bënëꞌ mandado yexiꞌjëꞌ nisa udibinëꞌ nëꞌë lao ja benëꞌ, unëꞌ rëbinëꞌ lëjëꞌ: ―Binaca cuenda quiaꞌ nëꞌëdiꞌ danꞌ gatinëꞌ. Rniaꞌ leꞌe gabi xquia bënëꞌ. Nacan cuenda quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Naꞌ una yugujëꞌ rëbijëꞌ lëbëꞌ: ―Cuenda quiendoꞌ len z̃iꞌindoꞌ nacan danꞌ gatinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Naꞌra bebio Pilato Barrabás luꞌu dyiguiba. Bënëꞌ mandado udi ja soldado Jesús guidi, naꞌ udaꞌjëꞌ lëbëꞌ lëꞌë yaga cruzo. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Naꞌ uquiëꞌ ja soldado Jesús lao palacio. Caora naꞌ beguꞌudiꞌ yugu ja laguedyi soldado quiejëꞌ, bzujëꞌ lëbëꞌ gatzo laꞌohue. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Naꞌ ulëchojëꞌ z̃abëꞌ, bgacojëꞌ lëbëꞌ tu laꞌariꞌ z̃na. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Naꞌ bdzeꞌjëꞌ guichoguëꞌ tu coron yëchiꞌ, psejëꞌ lëbëꞌ tu xaga zacaꞌ nëꞌë yebë. Naꞌra uditzujëꞌ z̃ibijëꞌ laohuëꞌ rutitujëꞌ lëbëꞌ unajëꞌ rëbijëꞌ lëbëꞌ: ―¡Viva luëꞌ, Rey quie benꞌ Israel! ");
INSERT INTO zpcNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Lëscanꞌ bdaꞌjëꞌ lëbëꞌ z̃enꞌ. Naꞌ begubajëꞌ xaga zenëꞌ udijëꞌn guicho Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ude beyudyi ptitujëꞌ lëbëꞌ, belëchojëꞌ tu laꞌariꞌ z̃na guconëꞌ, begacojëꞌ lëbëꞌ z̃abacazëꞌ. Naꞌ uquiëꞌjëꞌ lëbëꞌ ta udaꞌjëꞌ lëbëꞌ lëꞌë yaga cruzo. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Naꞌ du tu neza bedilajëꞌ tu benꞌ yedyi Cirene laonëꞌ Simón. Naꞌ bëjëꞌ mandado huaꞌanëꞌ yaga cruzo. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Canaꞌ bdyinjëꞌ ga laona Gólgota, ta inaro xtiꞌidzaꞌro: Yaꞌa chita guicho benꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Naꞌ bëꞌjëꞌ ta yoꞌoguëꞌ vino nequixi taslaꞌ gula. Bëꞌ hueꞌenëꞌn ledaoꞌ bicuꞌ, biguꞌunnëꞌ yoꞌoguëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Naꞌ ude beyudyi bdaꞌ soldado lëbëꞌ lëꞌë yaga cruzo, naꞌra bëjëꞌ suerte bëꞌjëꞌ laze z̃abëꞌ. Canaꞌ uzu diꞌidzaꞌ bzu benꞌ profeta lëꞌë guichi dza naꞌ. Lëdiꞌidzaꞌ rnan caniga: “Bëjëꞌ suerte bëꞌjëꞌ laze z̃abaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Naꞌra ureꞌ soldado ta rapajëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Naꞌ guicho cruzo bdyiajëꞌ tu letrero ga rguixogueꞌn ca bi xquia bënëꞌ danꞌ bëtijëꞌ lëbëꞌ. Lëꞌë letrero unan caniga: “Jesús, Rey quie benꞌ Israel.” ");
INSERT INTO zpcNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Lëscanꞌ bdaꞌrëjëꞌ chopa benꞌ uban lëꞌë ichopa yaga cruzo. Bzujëꞌ tun zaquëꞌ yebë cuëta Jesús, itun bzujëꞌ zaquëꞌ yegaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Naꞌ ude ja benëꞌ ptitujëꞌ lëbëꞌ ruta guicho laojëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Unajëꞌ rëbijëꞌ lëbëꞌ: ―Luëꞌ unaoꞌ udyiaguiꞌloꞌ idaoꞌ rnabëꞌra, naꞌ yeyueloꞌn lao tzona dza, psela cuinloꞌ naꞌa. Chi tali z̃iꞌi Diuzi luëꞌ, beyëzi lëꞌë yaga cruzo. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Lëscanꞌ ja xanꞌ pxuzi, len ja benꞌ rusëdi ley quie Moisés, len ja benꞌ partido fariseo, len ja benꞌ rnabëꞌ ptitujëꞌ lëbëꞌ. Naꞌ unajëꞌ rëbijëꞌ laguedyijëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Pte pselanëꞌ benꞌ tula, nechanꞌ biuz̃aqueꞌnëꞌ uselanëꞌ cuinnëꞌ. Chi tali naquëꞌ Rey quie benꞌ Israel, hueyëzëꞌ lëꞌë yaga cruzo ta galero quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Lëscanꞌ unëꞌ zudyiꞌilënëꞌ Diuzi. Ca rusela Diuzi lëbëꞌ naꞌa chi tali raque Diuzi lëbëꞌ como danꞌ unëꞌ naquëꞌ z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Naꞌ lente benꞌ uban, benꞌ bdaꞌrëjëꞌ lëꞌë yaga cruzo, ptiturëjëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Naꞌ bechula lao duz̃e ciudad naꞌ. Cadu laꞌodza uzulaon, naꞌ beyudyin ca du las tres quie zadzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lëhora naꞌtezi uredyiyaꞌ Jesús zidzo unëꞌ: ―Elí, Elí, ¿lama sabactani? ―ta inaro xtiꞌidzaꞌro: Xuzaꞌ Diuzi, Xuzaꞌ Diuzi, ¿bixquienꞌ apsanlaꞌadyoꞌ nëꞌëdiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Naꞌ be ja benꞌ nitaꞌ naꞌ cabëꞌ una Jesús. Naꞌ unajëꞌ rëbijëꞌ laguedyijëꞌ: ―Profeta Elías rëz̃i benꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Caora naꞌ laziote tu benꞌ zu naꞌ yexiꞌnëꞌ tu ta naca yunꞌ ca z̃iꞌilaꞌ laona esponja. Naꞌ bdzeꞌnëꞌn luꞌu vino slaꞌ bzunëꞌn lao yaga ta bdyinnan sibi ga daꞌ Jesús ta supinëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero una ibala ja benꞌ zë naꞌ rëbijëꞌ lëbëꞌ: ―Psan naꞌ. Yaꞌ inaꞌro chi guida Elías uselanëꞌ benꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Naꞌ uredyiyaꞌ Jesús zidzo tatula, gutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lëhora naꞌtezi breꞌeza laꞌariꞌ zë gatzo laoꞌ idaoꞌ rnabëꞌra. Babreꞌezan gucan chopa laꞌa. Lëscanꞌ guca uz̃uꞌ ulaꞌan yo yela. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Naꞌ beyalo beló yo ga yuꞌu benꞌ huati. Beban ja zë benꞌ baguti, benꞌ bë quie xtiꞌidzaꞌ Diuzi dza uzujëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Cati abeban Jesús, naꞌra brojëꞌ luꞌu beló yo, uyojëꞌ ciudad naca laꞌiya Jerusalén. Naꞌ blëꞌë ja benꞌ zë lëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Naꞌ cati blëꞌë xanꞌ soldado lënëꞌ ja soldado quienëꞌ cabëꞌ guca uz̃uꞌ len itu ta guca, naꞌra bdzebijëꞌ unajëꞌ rëbijëꞌ laguedyijëꞌ: ―Tali naca benꞌ ni z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Naꞌ nitaꞌ ja nigula zë zituꞌ rnaꞌjëꞌ cabëꞌ raca quie Jesús. Gucalëjëꞌ unaojëꞌ lëbëꞌ desde dza uzaꞌnëꞌ estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Naꞌ zëlë lëjëꞌ María Magdalena, len María z̃naꞌ Santiago, len José, len z̃naꞌ yaca z̃iꞌi Zebedeo. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cati agula, bdyin tu benꞌ uñaꞌa, benꞌ yedyi Arimatea laohuëꞌ José. Naquëꞌ benꞌ nao xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Naꞌ uyonëꞌ yenaꞌnëꞌ Pilato unabanëꞌ cuerpo quie Jesús ta tzecachiꞌnëꞌn. Naꞌ bë Pilato mandado ta hueꞌjëꞌ lëbëꞌ cuerpo quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Naꞌ uz̃iꞌ José cuerpo quie Jesús, bdubinëꞌn tu laꞌariꞌ yëri. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Naꞌ yehuaꞌanëꞌn bdzeꞌnëꞌn luꞌu tu beló yo ta zabeyudyi bënëꞌ. Naꞌ zaotacorëꞌ ruꞌa beló yo tu yo z̃e gula ta naca lagaꞌ. Ude beyudyi naꞌ, bezëꞌë zeyoguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Naꞌ ruꞌa beló yo naꞌ ureꞌ María Magdalena lënëꞌ itu María tula. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Naꞌ beteyu naꞌ dza saodo, dza huezilaꞌadyiꞌ quiejëꞌ, uyo ja xanꞌ pxuzi, len ja benꞌ partido fariseo yenaꞌjëꞌ Pilato ");
INSERT INTO zpcNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","unajëꞌ rëbijëꞌ lëbëꞌ: ―Señor, nëtoꞌ rezaꞌlaꞌadyiꞌndoꞌ cabëꞌ una benꞌ huiziꞌ yëꞌ naꞌ cati uzuëꞌ, unëꞌ huezaꞌnëꞌ ga de benꞌ huati huebannëꞌ tatula lao tzona dza. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tanaꞌ lenaꞌ ruen zi hueloꞌ mandado gapa ja soldado ruꞌa beló yo lao tzona dza. Canaꞌ bisaqueꞌ tzio ja benꞌ quienëꞌ du rëla tzelanjëꞌ cuerpo quienëꞌ tacuenda yëbijëꞌ ja benëꞌ: “Bezaꞌnëꞌ ga de benꞌ huati bebannëꞌ.” Chi huaca hue benꞌ quienëꞌ canaꞌ, mazara yëꞌ siꞌjëꞌ benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Naꞌ una Pilato rëbinëꞌ lëjëꞌ: ―Ni nitaꞌ tu cueꞌ soldado, benꞌ gapa ja ruꞌa beló yo. Ulequiëꞌjëꞌ ta gapajëꞌ dyëꞌëdi ruꞌa beló yo. ");
INSERT INTO zpcNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Naꞌra uyojëꞌ uquiëꞌjëꞌ soldado. Pquichijëꞌ tu sello ga nedila ruꞌa yo ta nutacojëꞌ ruꞌa beló. Naꞌ pcaꞌnjëꞌ ja soldado, benꞌ rapa ruꞌa beló yo. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cati uyaniꞌ dza tula du bala dza domingo, uyo María Magdalena lënëꞌ itu María tula yenaꞌjëꞌ ruꞌa beló yo. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Caora naꞌ lagucate tu uz̃uꞌ nun quie uyëzi tu ángel quie Diuzi guibá, bdubanëꞌ yo nutacojëꞌ ruꞌa beló, ureꞌnëꞌ laonan. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Naꞌ ruseniꞌ laohuëꞌ ca xniꞌ yesa. Lëscanꞌ z̃abëꞌ rnaꞌn raca titiꞌ bezëri gula. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Cati blëꞌë ja soldado ángel, naꞌ lega bdzebijëꞌ uz̃izan lëjëꞌ byalajëꞌ layu, gutajëꞌ ca quie benꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Naꞌ una ángel rëbinëꞌ ja nigula: ―Bidzebile. Nezdaꞌ reguilole Jesús, benꞌ guti lëꞌë yaga cruzo. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bira zunëꞌ niga. Abebannëꞌ cabëꞌ unëꞌ gaca quienëꞌ. Uledacara, ulenaꞌ ga bdzeꞌjëꞌ cuerpo quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Uletzio tzeguedyile ja benꞌ quienëꞌ abezaꞌnëꞌ ga de benꞌ huati, abebannëꞌ. Huabialaohuëꞌ leꞌe tu neza Galilea. Naꞌte hualëꞌële lëbëꞌ. Lenaꞌ ruen zi quixoguiꞌa leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Naꞌ du rdzebi ja nigula, uzaꞌjëꞌ taria gan de beló yo, ziojëꞌ redaohuejëꞌ tzeguedyijëꞌ ja benꞌ quie Jesús cabëꞌ guca. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Naꞌ ptilalao Jesús lëjëꞌ tu neza ugapëꞌ diuz̃i lëjëꞌ. Naꞌ ibigaꞌjëꞌ gan zë Jesús gutajëꞌ layu bdaꞌ ruꞌajëꞌ uyonelaꞌadyiꞌjëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Naꞌ una Jesús rëbinëꞌ lëjëꞌ: ―Bidzebile. Uletzio tzeguedyile ja bichaꞌ benꞌ quiaꞌ ta tziojëꞌ Galilea. Naꞌte ilëꞌëjëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tu raca nezio ja nigula tu neza, uzaꞌ bala ja soldado uyojëꞌ ciudad Jerusalén yeguëdyijëꞌ ja xanꞌ pxuzi cabëꞌ guca quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Naꞌ uyo ja xanꞌ pxuzi yeguëdyijëꞌ ja benꞌ rnabëꞌ ta yegaꞌnjëꞌ diꞌidzaꞌ bi huejëꞌ. Naꞌ bëꞌjëꞌ ja soldado dumi z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Naꞌ unajëꞌ rëbijëꞌ ja soldado: ―Cani yëbile benëꞌ. Du rëla du rasile, bida ja benꞌ quie Jesús, bedelanjëꞌ cuerpo quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Chi inezi gobernador cabëꞌ guca quiele, nëtoꞌ gacalëndoꞌ leꞌe ta bibi zëdi gaca quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Naꞌra uz̃iꞌ ja soldado dumi, uyojëꞌ yeguëdyijëꞌ ja benëꞌ cabëꞌ gudyi xanꞌ pxuzi len ja benꞌ rnabëꞌ lëjëꞌ. Cabëꞌ una ja soldado guca quie cuerpo quie Jesús, canaꞌ na ja benëꞌ guca quien hasta naꞌadza. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Naꞌ uzaꞌ ja chiptu benꞌ quie Jesús ziojëꞌ estado Galilea. Naꞌ bdyinjëꞌ ga zu tu yaꞌa, ga gudyi Jesús lëjëꞌ tziojëꞌ dza naꞌte. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lëganꞌ naꞌ blëꞌëjëꞌ Jesús uyonelaꞌadyiꞌjëꞌ lëbëꞌ. Naꞌ nitaꞌ ja benꞌ quienëꞌ biralejëꞌ chi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Naꞌ ubigaꞌ Jesús ganꞌ nitaꞌ ja benꞌ quienëꞌ unëꞌ rëbinëꞌ lëjëꞌ: ―Apcaꞌn Diuzi lao naꞌa inabiꞌa lao duz̃e guibá len duz̃e dyilayu. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tanaꞌ lenaꞌ iniaꞌ leꞌe, uletzio duz̃e yedyi layu tzetixogueꞌle ja benëꞌ xtiꞌidzaꞌ, usëdilejëꞌ inaojëꞌ xnezaꞌ. Ulehueꞌ lao ja benꞌ nao xnezaꞌ uzëtole Diuzi, uzëtole nëꞌëdiꞌ, uzëtole Bichi Be quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Naꞌ usëdilejëꞌ huejëꞌ duz̃e cabëꞌ baoniaꞌ leꞌe. Bigalaꞌadyiꞌle suliaꞌ leꞌe tuzioli hasta iyudyi dyila yu. Amén.");
INSERT INTO zpcNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Cani guca dza naꞌ cati uzulao Juan udixogueꞌnëꞌ quie Jesucristo, benꞌ naca z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Azio zëra iza bzu profeta Isaías xtiꞌidzaꞌ Diuzi lëꞌë guichi. Canaꞌ udixogueꞌ Diuzi danꞌ rnën caniga: Huaseꞌelaꞌ tu benꞌ cuialao neza ga tzioꞌ cuenda tzetixogueꞌnëꞌ yaca benëꞌ huidoꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Huazu benꞌ naꞌ lao lato dachi ga bidyia yuꞌu, huanëꞌ zidzo yëbinëꞌ laguedyinëꞌ caniga: “Huele hueluba neza quiele cuenda huida benꞌ naca xaꞌnro, usalole tu neza li.” ");
INSERT INTO zpcNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Canaꞌ guca bida Juan lao lato dachi ga bidyia yuꞌu, bëꞌnëꞌ lao yaca benëꞌ. Canaꞌ unëꞌ gudyinëꞌ leyaquëꞌ de quie reyaꞌalaꞌ utzaꞌyaquëꞌ pensari quieyaquëꞌ, hueyaquëꞌ lato ta hueꞌ Juan laoyaquëꞌ cuenda yeziꞌz̃e Diuzi dulaꞌ xquia quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Uyo yaca benꞌ quie estado Judea len yaca benꞌ ciudad Jerusalén, bdyinyaquëꞌ ga zë Juan. Caora uxubalëpiyaquëꞌ ca tamedian bëyaquëꞌ, naꞌra bëꞌ Juan laoyaquëꞌ luꞌu yao Jordán. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Guco Juan laꞌariꞌ de guitzaꞌ quie z̃aba camello. Lëscanꞌ tu cincho guidi bdzeꞌnëꞌ lëꞌënëꞌ. Udaonëꞌ bëchiꞌzu, hueꞌenëꞌ bdyinꞌdaoꞌ quie bezu cera ta rdzela guixiꞌ daoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Naꞌra udixogueꞌnëꞌ yaca benꞌ uyo ga zënëꞌ gudyinëꞌ leyaquëꞌ: ―Benꞌ zezaꞌra zenao nëꞌëdiꞌ, nacarëꞌ benꞌ z̃e ca nëꞌëdiꞌ. Tanto nacarëꞌ benꞌ z̃e ca nëꞌëdiꞌ, ni lëꞌëtiꞌ bibi zacaꞌ ni siquiera biyeyaz̃ogaꞌ cuiogaꞌ guidi yuꞌu niꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nëꞌëdiꞌ ruꞌa laole conlë nisa, pero benꞌ zezaꞌra zenao nëꞌëdiꞌ, udzeꞌnëꞌ Bichi Be quie Diuzi luꞌu guicho laxtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Naꞌra uzaꞌ Jesús yedyi Nazaret quie estado Galilea zionëꞌ bdyinnëꞌ ga zë Juan. Lëganꞌ naꞌ bëꞌ Juan laonëꞌ luꞌu yao Jordán. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cati bero Jesús luꞌu yao, blëꞌënëꞌ uyalo guibá, blëꞌënëꞌ uyëzi Bichi Be quie Diuzi ca rëzi biu bdyinnëꞌ ga zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Naꞌra unë Diuzi ga zuëꞌ guibá unëꞌ: ―Luëꞌ nacoꞌ z̃iꞌinaꞌ, nedyëꞌëdaꞌ luëꞌ. Lega redaohuedaꞌ ca rueloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Naꞌra uquiëꞌ Bichi Be quie Diuzi Jesús lao lato dachi ga bidyia yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Lëganꞌ naꞌ uzunëꞌ lao chopa galo dza ga uzurë yaca bia guixiꞌ. Naꞌra bdyinrë Satanás ga zë Jesús guꞌunnan iquixi Jesús huenëꞌ tamala. Pero naꞌa useꞌelaꞌ Diuzi yaca ángel quienëꞌ ta gacalëyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Caora baode bdzeꞌyaquëꞌ Juan luꞌu dyiguiba, naꞌra uzaꞌ Jesús zionëꞌ yaca yedyi nebaba Galilea ta tzetixogueꞌnëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Naꞌra una Jesús gudyinëꞌ leyaquëꞌ: ―Babdyin hora cati inabëꞌ Diuzi lao yedyi layu. Reyaꞌalaꞌ utzaꞌle pensari quiele, hue quiele xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Naꞌra uzaꞌ Jesús zioguëꞌ ruꞌa lagun Galilea. Naꞌ blëꞌënëꞌ Simón len bichinëꞌ Andrés. Rueyaquëꞌ dyin quieyaquëꞌ rudzeꞌyaquëꞌ du yëxo luꞌu nisa ta tzuꞌu yaca bela. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―¡Ulenao nëꞌëdiꞌ! Cabëꞌ ruele cuiole bela yuꞌu luꞌu nisa, canaꞌ uluꞌenaꞌ leꞌe cuiole benꞌ nao xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Caora naꞌ lapsanteyaquëꞌ du yëxo quieyaquëꞌ, bira uz̃eyaquëꞌ bela, ziolëyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Biz̃i cati uzaꞌra Jesús ilëꞌëtiꞌ, blëꞌënëꞌ chopa z̃iꞌi Zebedeo, tunëꞌ laonëꞌ Santiago, itunëꞌ laonëꞌ Juan. Reꞌyaquëꞌ luꞌu barco daoꞌ quieyaquëꞌ reguibayaquëꞌ du yëxo quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Naꞌ caora guz̃i Jesús leyaquëꞌ, pcaꞌnyaquëꞌ barco daoꞌ quieyaquëꞌ lao naꞌa xuziyaquëꞌ len itu mozo, ziolëyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Naꞌ uzaꞌyaquëꞌ zioyaquëꞌ bdyinyaquëꞌ yedyi Capernaum. Cati bdyin dza saodo, dza huezilaꞌadyiꞌ quieyaquëꞌ, uyuꞌu Jesús luꞌu idaoꞌ quieyaquëꞌ laona sinagoga ta usëdinëꞌ yaca benꞌ bedupa naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Naꞌra tu bebanziyaquëꞌ ca gudyi Jesús leyaquëꞌ, como danꞌ rusëdinëꞌ leyaquëꞌ ca benꞌ de yelaꞌ rnabëꞌ quie cuinzëꞌ, cala ca yaca benꞌ rusëdi ley pcaꞌn Diuzi lao naꞌa Moisés. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Naꞌ luꞌu idaoꞌ ga zë Jesús bdyin tu benꞌ yuꞌu bichi be mala luꞌu laxtaꞌonëꞌ. Caora naꞌ uredyiyaꞌ bichi be mala yuꞌu benꞌ naꞌ rëbinan Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Bixquienꞌ zaoꞌ niga ga zundoꞌ, luëꞌ Jesús, benꞌ yedyi Nazaret? ¿Quele zaoꞌ niga ta tilalaoꞌ udyiaguiꞌloꞌ nëtoꞌ? Nubëꞌdaꞌ luëꞌ, nacoꞌ benꞌ laꞌiya, benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Naꞌra udila Jesús lëbin, rëbinëꞌ bichi be mala: ―¡Bira inëloꞌ! ¡Bero ganꞌ yuꞌuloꞌ luꞌu laxtaꞌo benꞌ niga! ");
INSERT INTO zpcNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Caora naꞌ tu rz̃izizi benꞌ naꞌ zënëꞌ yuꞌunëꞌ bichi be mala, naꞌra uredyiyaꞌn beronan gan yuꞌun zeyonan. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Canaꞌ tu bebanzi yaca benëꞌ, du rdzebiyaquëꞌ unëyaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Nuz̃i naca benꞌ niga? ¿Biz̃i huesëdi cubi ruenëꞌ? ¿Como hasta yaca bichi be mala raleyacan quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Canaꞌ guca luegozi unezi yaca benꞌ nitaꞌ yedyi nebaba Galilea cabëꞌ rue Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Naꞌra cati beroyaquëꞌ idaoꞌ sinagoga, uzaꞌ Jesús zioguëꞌ len Santiago len Juan bdyinyaquëꞌ lidyi Simón len Andrés. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Naꞌ de benꞌ gula quie Simón lao belaga yuꞌunëꞌ z̃la. Quie lenaꞌ gudyiyaquëꞌ Jesús cabëꞌ raca quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Caora naꞌ ude Jesús ganꞌ de nigula naꞌ lao belaga. Ca bdyin Jesús naꞌ, bëxunëꞌ naꞌa nigula, uchisanëꞌ lëbëꞌ. Ca uyasëꞌ, caora naꞌ bero tala yuꞌunëꞌ. Naꞌra bë nigula naꞌ ta udaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Naꞌra caora gula uxin banaca chula, uquiëꞌ yaca benëꞌ nu benꞌ raca z̃hueꞌ, len nu benꞌ yuꞌu bichi be mala luꞌu laxtaꞌohuëꞌ, bdyinyaquëꞌ ganꞌ zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Naꞌ bedupa yugulu benꞌ yedyi naꞌ laliꞌa yuꞌu ga zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Naꞌ nacala yelaꞌ hueꞌ racayaquëꞌ, beyue Jesús leyaquëꞌ, bebionëꞌ bichi be mala yuꞌuyaquëꞌ. Bibëꞌnëꞌ lato inëyacan como neziyacan nu naquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Naꞌra du bala cati nenaca chula, uyasa Jesús zionëꞌ ruꞌa yedyi ta hueꞌlënëꞌ Diuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Caora uyasa Simón len yaca compañero quienëꞌ, blëꞌëyaquëꞌ ganu Jesús dyilaꞌ, caora naꞌ uzaꞌyaquëꞌ yediloyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Naꞌ cati bedzeleyaquëꞌ lëbëꞌ, unëyaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Benꞌ zë zaꞌ, rguiloyaquëꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tzioro lao yedyi tula ganꞌ nacara gaꞌalaꞌ cuenda quixogueꞌriaꞌ leyaquëꞌ xtiꞌidzaꞌ Diuzi. Tanaꞌ lenaꞌ bidaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Canaꞌ uyo Jesús yugulu yedyi nebaba Galilea, uyuꞌunëꞌ luꞌu idaoꞌ sinagoga quieyaquëꞌ udixogueꞌnëꞌ yaca benꞌ nitaꞌ naꞌ xtiꞌidzaꞌ Diuzi, bebionëꞌ yaca bichi be mala yuꞌuyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Naꞌra bebigaꞌ tu benꞌ yuꞌu yelaꞌ hueꞌ ca pindo ganꞌ zë Jesús, uditzu z̃ibinëꞌ lao Jesús unëyëchiꞌnëꞌ rëbinëꞌ Jesús: ―Uz̃iꞌz̃e quiaꞌ. Chi reꞌenloꞌ, huaca yeyueloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naꞌra beyëchiꞌlaꞌadyiꞌ Jesús lëbëꞌ. Blinëꞌ nëꞌë bëxunëꞌ lëbëꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Reꞌendaꞌ huaꞌ ca naoꞌ. Hueyuaꞌ luëꞌ naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Caora naꞌ lapsante yelaꞌ hueꞌ quiëꞌ lëbëꞌ, labeyacatëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Naꞌra unë Jesús rëbinëꞌ benꞌ naꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ni tu nunu yëboꞌ canꞌ babiaꞌ quioꞌ. Tuzi ta rniaꞌ, uyo yaluꞌe cuinloꞌ lao pxuzi. Naꞌ bëꞌnëꞌ tu ta reyaꞌalaꞌ hueꞌloꞌnëꞌ cabëꞌ rnë lëꞌë ley quie Moisés danꞌ babeyëriloꞌ. Canaꞌ hueloꞌ ta inezi yaca benëꞌ babez̃i yelaꞌ hueꞌ yuꞌuloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero zio benꞌ naꞌ udixogueꞌnëꞌ laguedyinëꞌ cabëꞌ guca quiëꞌ. Quie lenaꞌ bira uz̃aqueꞌ tzeta Jesús zaquëꞌlao laꞌo yaca yedyi. Puro ruꞌa yedyi ga bidyia yuꞌu udanëꞌ. Pero uzaꞌ yaca benëꞌ quie quie yedyi quieyaquëꞌ zioyaquëꞌ bdyinyaquëꞌ ga rda Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bëꞌ baode chopa tzona dza, naꞌ bedyin Jesús ciudad Capernaum. Tzadi unezi yaca benëꞌ bedyin Jesús z̃an yuꞌu quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Quie lenaꞌ bedupa yaca benꞌ zë ganꞌ zë Jesús. Tanto bedupa yaca benꞌ zë, lente laliꞌa bedzaꞌyaquëꞌ. Naꞌ udixogueꞌ Jesús leyaquëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Naꞌra bdyinra itapa benëꞌ len belaga ga z̃uba tu benꞌ z̃i. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero biuz̃aqueꞌ tzuꞌulëyaquëꞌ benꞌ z̃i luꞌu yuꞌu ganꞌ zë Jesús, danꞌ nitaꞌ benꞌ zë. Quie lenaꞌ urëyaquëꞌ lun yuꞌu, udubayaquëꞌ yaga dacoꞌ lun yuꞌu, bzuyaquëꞌ tu yëro ta pchizayaquëꞌ belaga layu ga z̃uba benꞌ z̃i. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Caora blëꞌë Jesús cabëꞌ bëyaquëꞌ rzudyiꞌilëyaquëꞌ lëbëꞌ de que huacanëꞌ yeyuenëꞌ benꞌ z̃i, naꞌra unë Jesús rëbinëꞌ benꞌ z̃i: ―Bichaꞌ, baoz̃iꞌz̃iaꞌ dulaꞌ xquia quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Biz̃i bago ureꞌ chopa tzona benꞌ rusëdi ley ta pcaꞌn Diuzi lao naꞌa Moisés. Naꞌra bëyaquëꞌ pensari unayaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Bixquienꞌ una benꞌ niga canaꞌ? Barnayaꞌnëꞌ Diuzi unëꞌ canaꞌ como danꞌ tuzi Diuzi huaca siꞌz̃e dulaꞌ xquia quiero, quele benꞌ ni.” ");
INSERT INTO zpcNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero gucabëꞌ Jesús ca naca pensari quieyaquëꞌ. Lenaꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Bixquienꞌ ruele pensari canaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ca nurlan nacaran yalo huaꞌ quie benꞌ z̃i niga? ¿Nacaran yalo chi yëpaꞌnëꞌ: “Aoz̃iꞌz̃iaꞌ dulaꞌ xquia quioꞌ”, o chi yëpaꞌnëꞌ: “Uyasa, beziꞌ belaga quioꞌ, bezaꞌ beyo”? ");
INSERT INTO zpcNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pues nacaꞌ bichi yugulu benëꞌ. Naꞌra uluꞌenaꞌ leꞌe de yelaꞌ rnabëꞌ quiaꞌ lao yedyi layu ta yeziꞌz̃iaꞌ dulaꞌ xquia quie yaca benëꞌ. Naꞌra una Jesús rëbinëꞌ benꞌ z̃i: ");
INSERT INTO zpcNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Rniaꞌ luëꞌ, uyasa, beziꞌ belaga quioꞌ, beyo z̃an yuꞌu quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Caora naꞌ uyasa benꞌ z̃i, beziꞌnëꞌ belaga quiëꞌ, zeyoguëꞌ, udenëꞌ ganꞌ nitaꞌ yaca benëꞌ. Naꞌ bëyaquëꞌ Diuzi benꞌ z̃e unayaquëꞌ: ―Ni tu lasa binelëꞌëro cabëꞌ bë benꞌ ni. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Naꞌ uyo Jesús ruꞌa lagun Galilea tatula. Caora babedupa benꞌ zë ga zë Jesús, naꞌra psëdinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bëꞌ beyudyi naꞌ, uzaꞌ Jesús zionëꞌ udenëꞌ blëꞌënëꞌ Leví, z̃iꞌi Alfeo, reꞌnëꞌ ga reꞌ benꞌ huequiz̃u. Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Unao nëꞌëdiꞌ. Naꞌra uzaꞌnëꞌ ziolënëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bëꞌ baode chopa tzona dza, uyo Jesús yetaonëꞌ z̃an yuꞌu quie Leví. Lëscanꞌ uyorë zë benꞌ huequiz̃u len zë benꞌ de dulaꞌ xquia quie, ureꞌrëlëyaquëꞌ Jesús lënëꞌ yaca benꞌ quienëꞌ. Guca benꞌ zë, benꞌ unao lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pero caora blëꞌë yaca benꞌ rusëdi ley quie Moisés len yaca benꞌ partido fariseo cabëꞌ rue Jesús, raonëꞌ tzaz̃e len benꞌ huequiz̃u len benꞌ de dulaꞌ xquia quie, naꞌra unayaquëꞌ rëbiyaquëꞌ benꞌ quie Jesús: ―¿Bixquienꞌ riꞌo rao maestro quiele tzaz̃e len benꞌ huequiz̃u len benꞌ de dulaꞌ xquia quie? ");
INSERT INTO zpcNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Naꞌ cati babe Jesús cabëꞌ unayaquëꞌ, naꞌra unënëꞌ rëbinëꞌ leyaquëꞌ: ―Yaca benꞌ biraca z̃hueꞌ, biruen zi guida médico ta yeyuenëꞌ leyaquëꞌ. Pero nu benꞌ raca z̃hueꞌ, sí ruen zi guida médico. Quele zaꞌ rëz̃aꞌ benꞌ nazi bibi xquia rue, dechanꞌ zaꞌ rëz̃aꞌ benꞌ reꞌen yez̃i dulaꞌ xquia quie. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naꞌra guca tu dza rue benꞌ quie Juan bautista len benꞌ partido fariseo ubasi, naꞌ bdyin chopa tzona benëꞌ ga zë Jesús unayaquëꞌ lëbëꞌ: ―¿Bixquienꞌ birue yaca benꞌ quioꞌ ubasi cabëꞌ rue benꞌ quie Juan len benꞌ partido fariseo? ");
INSERT INTO zpcNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Naꞌ una Jesús gudyinëꞌ leyaquëꞌ: ―¿Rnabaꞌ leꞌe chi rue yaca benꞌ bdyin ga raca huetzaganaꞌ ubasi tu nezu biꞌ utzaganaꞌ len leyaquëꞌ? Tu nezu biꞌ utzaganaꞌ len leyaquëꞌ, birueyaquëꞌ ubasi. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero chi guida benꞌ rudie benꞌ utzaganaꞌ, chi guxuyaquëꞌ lëbiꞌ, hueyaquëꞌ lëbiꞌ ziꞌ, tzehuaꞌayaquëꞌ lëbiꞌ ga tula, naꞌra hue yaca amigo quie biꞌ utzaganaꞌ ubasi. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Lëscanꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Bisaqueꞌ taꞌ laꞌariꞌ cubi lëꞌë laꞌariꞌ gula chi binetzërin, porque huetzereꞌnan icanan ruꞌa laꞌariꞌ gula, naꞌ ichezan len mazara. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Lëscanꞌ bisaqueꞌ caꞌro nupi z̃ixi luꞌu bolsa guidi gula, porque bëꞌ sulao ilëbin, huedzaꞌn ichezan len. Canaꞌ huabiaguiꞌ lao rupa cueꞌten. Quie lenaꞌ ruen zi caꞌro nupi z̃ixi luꞌu bolsa guidi cubi. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Naꞌra bdyin tu dza saodo, dza huezilaꞌadyiꞌ quieyaquëꞌ, uzaꞌ Jesús lënëꞌ yaca benꞌ quiëꞌ udeyaquëꞌ layela ga neduza trigo. Naꞌ uditzu yaca benꞌ quie Jesús dao trigo ta gaoyaquëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Naꞌra una yaca benꞌ partido fariseo rëbiyaquëꞌ Jesús: ―¿Bixquienꞌ rue yaca benꞌ quioꞌ dyin rguitzuyaquëꞌ dao quie trigo dza huezilaꞌadyiꞌ, dza bireyaꞌalaꞌ huero dyin? ");
INSERT INTO zpcNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Binulabale lëꞌë guichi cabëꞌ bë rey David dza uduenëꞌ lënëꞌ yaca benꞌ quiëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Uyuꞌu rey David luꞌu idaoꞌ rnabëꞌra cati naca Abiatar xaꞌn pxuzi rnabëꞌra, uz̃iꞌnëꞌ yëta xtila naca laꞌiya ta ruꞌeyaquëꞌ Diuzi. Naꞌ udaonëꞌn bëꞌnëꞌn len yaca benꞌ dzaganëꞌ, udaoyaquëꞌ ta bireyaꞌalaꞌ gaoyaquëꞌ, ta reyaꞌalaꞌ gao yaca pxuzizi. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Udixu Diuzi dza huezilaꞌadyiꞌ ta gacalën yaca benëꞌ. Quele udixu Diuzi dza huezilaꞌadyiꞌ ta gaca xaꞌnyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nacaꞌ bichi yugulu benëꞌ. De yelaꞌ rnabëꞌ quiaꞌ huaꞌ mandado bi hue yaca benëꞌ dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Naꞌra uyuꞌu Jesús tatula luꞌu idaoꞌ sinagoga. Lëganꞌ naꞌ zë tu benꞌ neseco nëꞌë. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Biz̃i naꞌ rbëꞌnao yaca benëꞌ Jesús chi hueyuenëꞌ benꞌ neseco nëꞌë dza saodo, dza huezilaꞌadyiꞌ, tacuenda gaoyaquëꞌ lëbëꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Naꞌ unë Jesús gudyinëꞌ benꞌ neseco nëꞌë: ―Uda uzë gatzo laꞌo niga. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Naꞌra una Jesús rëbinëꞌ yaca benꞌ nitaꞌ naꞌ: ―¿Biz̃i reyaꞌalaꞌ huero dza huezilaꞌadyiꞌ? ¿Reyaꞌalaꞌ huero tadyaꞌa o tamala? ¿Reyaꞌalaꞌ uselaro benëꞌ o gutiro benëꞌ? Pero begaꞌnyaquëꞌ chizi, bibi unayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Naꞌra du rdzaꞌnëꞌ unaꞌnëꞌ leyaquëꞌ dyëꞌëdi. Guquenëꞌ bayëchiꞌ nun quie yelaꞌ zidi quieyaquëꞌ. Naꞌ unëꞌ rëbinëꞌ benꞌ neseco nëꞌë: ―Bli naꞌaloꞌ. Biz̃i ca blinëꞌ nëꞌë beyacaten dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Naꞌra uzaꞌ yaca benꞌ partido fariseo zioyaquëꞌ ta hueꞌlëyaquëꞌ benꞌ partido Herodes diꞌidzaꞌ bi hueyaquëꞌ ta gutiyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pero uzaꞌ Jesús zionëꞌ ruꞌa lagun Galilea. Lëscanꞌ ziorë yaca benꞌ zë, benꞌ uzaꞌ yedyi nebaba Galilea, unaoyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Cati unezi yaca benëꞌ cabëꞌ tahuen gula bë Jesús, naꞌra uzaꞌyaquëꞌ yedyi nebaba Judea, len ciudad Jerusalén, len yedyi nebaba Idumea, len yedyi reꞌ itzalaꞌla yao Jordán, len yedyi Tiro, len yedyi Sidón, bdyinyaquëꞌ ga zënëꞌ ta ilëꞌëyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Quie lenaꞌ bë Jesús mandado yaca benꞌ quiëꞌ ta tzioyaquëꞌ tzexiꞌyaquëꞌ tu barco ga tzuꞌunëꞌ como danꞌ benꞌ zë pquiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Canaꞌ guca quienëꞌ como danꞌ tanto beyuenëꞌ yaca benꞌ raca z̃hueꞌ, pquiyaquëꞌ bëxuyaquëꞌ lëbëꞌ ga zëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Naꞌ caora blëꞌë yaca bichi be mala lëbëꞌ, uditzu z̃ibiyacan uredyiyaꞌyacan unayacan Jesús: ―Z̃iꞌi Diuzi luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero udila Jesús leyacan ta biyëbiyacan benëꞌ naquëꞌ z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Naꞌra uzaꞌ Jesús zionëꞌ ga zu tu lëꞌë yaꞌa. Lëganꞌ naꞌ guz̃i Jesús benꞌ reꞌennëꞌ gaca nombrar benꞌ quienëꞌ. Naꞌ uzaꞌyaquëꞌ zioyaquëꞌ bdyinyaquëꞌ ga zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Naꞌra bënëꞌ nombrar chipchopa benꞌ gaca benꞌ quienëꞌ, benꞌ rue lëbëꞌ tuz̃e, benꞌ iseꞌelaꞌ ta quixogueꞌyaquëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Lëscanꞌ bëꞌnëꞌ yelaꞌ rnabëꞌ ta yeyueyaquëꞌ benꞌ raca z̃hueꞌ, lëscanꞌ ta cuioyaquëꞌ yaca bichi be mala yuꞌu yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Cani naca lista quie chipchopa benꞌ ulionëꞌ: Ulionëꞌ tu benꞌ lao Simón, benꞌ uxubanëꞌ laohuëꞌ Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ulionëꞌ tu benꞌ lao Santiago len bichinëꞌ Juan. Nacayaquëꞌ z̃iꞌi Zebedeo. Uxubanëꞌ laoyaquëꞌ Boanerges, ta inaro xtiꞌidzaꞌro: Z̃iꞌi hueziuꞌ como danꞌ nacayaquëꞌ benꞌ rgüinꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Lëscanꞌ ulionëꞌ tu benꞌ lao Andrés, len tu benꞌ lao Felipe, len tu benꞌ lao Bartolomé, len tu benꞌ lao Mateo, len tu benꞌ lao Tomás, len itu benꞌ lao Santiago, z̃iꞌi Alfeo, len tu benꞌ lao Tadeo, len itu benꞌ lao Simón, benꞌ naca partido cananeo. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Lëscanꞌ ulionëꞌ Judas Iscariote, benꞌ psedyin Jesús lao naꞌa yaca benꞌ rnabëꞌ. Beyudyi ulio Jesús chipchopa benꞌ quienëꞌ, ziolënëꞌ leyaquëꞌ bdyinyaquëꞌ z̃an yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Naꞌ tantozi bedupa benꞌ zë tatula ga zënëꞌ, bibëꞌn lato ni siquiera ta gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cati unezi yaca familia quienëꞌ cabëꞌ raca quienëꞌ, uzaꞌyaquëꞌ tzexiꞌyaquëꞌ lëbëꞌ, como danꞌ nayaquëꞌ naquëꞌ benꞌ luco. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lëscanꞌ yaca benꞌ rusëdi ley quie Moisés, benꞌ uzaꞌ ciudad Jerusalén, unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Bayuꞌu benꞌ ni Beelzebú, benꞌ naca xanꞌ yaca bichi be mala. Yelaꞌ huaca quie xanꞌ taxiꞌibiꞌ raca rbionëꞌ yaca bichi be mala. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Naꞌra guz̃i Jesús leyaquëꞌ unëꞌ gudyinëꞌ leyaquëꞌ cani. ―¿Biz̃i hue xanꞌ taxiꞌibiꞌ Satanás ta yebionëꞌ laguedyi taxiꞌibiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chanꞌ tu cueꞌ gobierno gaca zë cueꞌ partido, chanꞌ tilalëyaquëꞌ laguedyiyaquëꞌ benꞌ naca partido, bisue gobierno huen dyin zidza. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lëscanꞌ chi tu cueꞌ familia raca rdilalëyaquëꞌ familia quieyaquëꞌ, bisueyaquëꞌ tzuꞌuyaquëꞌ z̃an yuꞌu tzaz̃e zidza. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chi cuin Satanás rdyiaguiꞌnan dyin quienan, bisaqueꞌ sue dyin quienan zidza, hueyudyi huedu quien. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Bisaqueꞌ tzuꞌu benëꞌ luꞌu yuꞌu quie tu benꞌ tzutzu huala ta cubayaquëꞌ ta de quienëꞌ chi zuëꞌ z̃an yuꞌu. Tanëro rnaban uquioyaquëꞌ lëbëꞌ, naꞌra huazaqueꞌ cubayaquëꞌ ta de quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Tu ta naca li rniaꞌ leꞌe, zu Diuzi dispuesto siꞌz̃enëꞌ bitezi tamala rue yaca benëꞌ. Lëscanꞌ zuëꞌ dispuesto siꞌz̃enëꞌ bitezi diꞌidzaꞌ mala rnë yaca benëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","pero nu benꞌ na diꞌidzaꞌ contra Bichi Be quie Diuzi, biyeziꞌz̃e Diuzi leyaquëꞌ, huanao dulaꞌ xquia quieyaquëꞌ leyaquëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Canaꞌ una Jesús gudyinëꞌ leyaquëꞌ, danꞌ unayaquëꞌ yuꞌunëꞌ bichi be mala. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Naꞌ beyudyi una Jesús, bdyin z̃nëꞌë len yaca biꞌ bichinëꞌ yuꞌu ga reꞌnëꞌ, pero begaꞌnyaquëꞌ laliꞌa danꞌ nadzaꞌ benëꞌ luꞌu yuꞌu. Naꞌ gudyiyaquëꞌ benꞌ ulidza lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Biz̃i yaca benꞌ reꞌ neyëcho ga reꞌ Jesús unayaquëꞌ rëbiyaquëꞌ Jesús: ―Abdyin z̃naoꞌ len yaca biꞌ bichoꞌ, rguiloyaquëꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Nuz̃i naca z̃naꞌa? ¿Nuz̃i naca biꞌ bichaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Caora naꞌ unaꞌ Jesús yaca benꞌ reꞌ neyëcho ga reꞌnëꞌ, unënëꞌ rëbinëꞌ leyaquëꞌ: ―Yugu leꞌe benꞌ reꞌ niga, nacale ca quie z̃naꞌa, nacale ca quie biꞌ bichaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nëꞌëdiꞌ rniaꞌ nutezi benꞌ rue quie cabëꞌ reꞌen Xuzaꞌ, naquëꞌ ca biꞌ bichaꞌ, ca biꞌ zanaꞌ, ca z̃naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Bezulao Jesús tatula usëdinëꞌ yaca benëꞌ ruꞌa lagun Galilea. Tanto bdupa benꞌ zë, uyuꞌu Jesús tu luꞌu barco daoꞌ zën lao nisa. Naꞌ ureꞌ Jesús luꞌu barco naꞌ, pero begaꞌn yaca benëꞌ ruꞌa lagun. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Con diꞌidzaꞌ ta nacan irupa iyunala psëdi Jesús leyaquëꞌ. Cani unëꞌ psëdinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Uzëcara nagale ca niaꞌ leꞌe. Uyo tu benꞌ raza bini trigo. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Según ca razayaquëꞌ bini trigo, ruzalëꞌ bini trigo layu. Naꞌra bala bini trigo yaqueꞌn tu neza ga bdyinte yaca bguini besaꞌobaꞌn udaobaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ibala bini trigo yaqueꞌn ga de yo, ga binacan tubelaozi yu. Naꞌra lëbini naꞌ laolënezaten danꞌ yaqueꞌn ga binacan tubelaozi yu. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero cati bena oba ziꞌ, naꞌra byëtzona ubidyin como danꞌ biuyuꞌu luena zituꞌ luꞌu yu. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ibala bini trigo yaqueꞌn ga ilë guixiꞌ yëchiꞌ. Naꞌ bëꞌ guꞌunin, bibë guixiꞌ yëchiꞌ lato gueꞌeni bini trigo dyëꞌëdi. Quie lenaꞌ bibi usecho bëꞌnan. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero ibala bini trigo yaqueꞌn ga naca tubelaozi yu ga ulëna guꞌunin dyëꞌëdi bëꞌnan usecho dyaꞌa. Bala dyigoꞌ biꞌan galobechi bini, ibalan biꞌan tzona galo bini, ibalan biꞌan tu gayuhua bini. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Naꞌra una Jesús: ―Leꞌe babe ulezë nagale canꞌ uniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Naꞌ cati ude beyudyi naꞌ, begaꞌn Jesús lënëꞌ chipchopa benꞌ quienëꞌ len itu chopa benꞌ zë gaꞌalaꞌ ga zëꞌ. Naꞌra unabayaquëꞌ Jesús bi reꞌen ina diꞌidzaꞌ gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Lenaꞌ unë Jesús rëbinëꞌ leyaquëꞌ: ―Ruzioñeꞌe Diuzi leꞌe bi reꞌen ina diꞌidzaꞌ rguixogueꞌn quie yelaꞌ rnabëꞌ quienëꞌ. Pero quie yaca benꞌ biruzënaga cabëꞌ rniaꞌ, rniaꞌ leyaquëꞌ conlë puro diꞌidzaꞌ ta naca irupa iyunala ");
INSERT INTO zpcNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","como danꞌ baꞌalaꞌcazi rlëꞌëyaquëꞌ dyëꞌëdi, rueziyaquëꞌ ca benꞌ birlëꞌë, baꞌalaꞌcazi reyaquëꞌ dyëꞌëdi, rueziyaquëꞌ ca benꞌ bire, como danꞌ bireꞌenyaquëꞌ utzaꞌyaquëꞌ pensari quieyaquëꞌ yeziꞌz̃e Diuzi dulaꞌ xquia quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Biuyoñeꞌele bi reꞌen ina diꞌidzaꞌ ta nacan irupa iyunala quie benꞌ guza bini trigo? ¿Biz̃i huele ta tzioñeꞌele bi reꞌen ina diꞌidzaꞌ bineniaꞌ leꞌe? ");
INSERT INTO zpcNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Naca benꞌ raza bini trigo ca quie benꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bala benëꞌ nacayaquëꞌ ca quie bini trigo yaqueꞌn tu neza beziꞌ bguini aodaobaꞌn. Ruzënagayaquëꞌ xtiꞌidzaꞌ Diuzi, pero beyudyi bzënagayaquëꞌn, lardyinte xanꞌ taxiꞌibiꞌ ta cuionëꞌ ca diꞌidzaꞌ uyuꞌu luꞌu guicho laxtaꞌoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ibala benëꞌ nacayaquëꞌ ca quie bini trigo yaqueꞌn lao yo ga binacan tubelaozi yu. Ruzënagayaquëꞌ raxeyaquëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero binacayaquëꞌ ca quie bini trigo yuꞌun luena zituꞌ luꞌu yu. Biregaꞌn xtiꞌidzaꞌ Diuzi luꞌu guicho laxtaꞌoyaquëꞌ. Cati rue yaca benëꞌ leyaquëꞌ bizinaquezi nun quie ruzënagajëꞌ xtiꞌidzaꞌ Diuzi, naꞌra rusanyaquëꞌ bira rue quieyaquëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ibala benëꞌ nacayaquëꞌ ca quie bini trigo yaqueꞌn ga rlë guixiꞌ yëchiꞌ. Ruzënagayaquëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero rzaꞌlaꞌadyiꞌyaquëꞌ ta de lao yedyi layu. Nun quie rziꞌ dumi quieyaquëꞌ leyaquëꞌ yëꞌ, lega reꞌenyaquëꞌ gataꞌ quieyaquëꞌ zë cosa. Quie lenaꞌ binacayaquëꞌ ca quie bini trigo ruꞌen usecho. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero ibala benëꞌ ruzënagayaquëꞌ xtiꞌidzaꞌ Diuzi, rue quieyaquëꞌ len. Nacayaquëꞌ ca quie bini trigo yaqueꞌn ga naca tubelaozi yu. Balayaquëꞌ nacayaquëꞌ ca quie dyigoꞌ biꞌan galobechi bini, ibalayaquëꞌ nacayaquëꞌ ca quie dyigoꞌ biꞌan tzona galo bini, ibalayaquëꞌ nacayaquëꞌ ca quie dyigoꞌ biꞌan tu gayuhua bini. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Lëscanꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Nunu ugaꞌalaꞌ lámpara ta utacaron caja, ni ta ucachiꞌron z̃an belaga. Ruen zi uzuro lámpara sibi ta cuëchin z̃niꞌ duz̃ete. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Canaꞌ nacarën quie yaca benëꞌ. Yugulu ta pcachiꞌ yaca benëꞌ, huadyin dza yebio Diuzi ta pcachiꞌyaquëꞌ, naꞌ cuionëꞌn zacaꞌlao ta ilëꞌë ja benëꞌ len. Lëscanꞌ yugulu diꞌidzaꞌ negachiꞌ rnë yaca benëꞌ, huadyin dza quixogueꞌ Diuzi ca diꞌidzaꞌ negachiꞌ unayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ulezënaga ca rniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Lëscanꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Ulehue quiele cabëꞌ babele baoniaꞌ. Cabëꞌ ruele racalële laguedyile, canaꞌ hue Diuzi iyacalënëꞌ leꞌe. Naꞌ mazara iyacalë Diuzi leꞌe, benꞌ ruzënaga xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nu benꞌ hue quie ta tzioñeꞌenëꞌ bi na xtiꞌidzaꞌ Diuzi, uzioñeꞌera Diuzi lëbëꞌ mazara. Pero nu benꞌ bihue quie ta tzioñeꞌenëꞌ bi na xtiꞌidzaꞌ Diuzi, hueguba Diuzi hasta tadaoꞌ lëꞌëtiꞌ baoyoñeꞌenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Lëscanꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Naca yelaꞌ rnabëꞌ quie Diuzi ca quie bi raca quie bini trigo cati raza benëꞌ len luꞌu yu. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bëꞌ beyudyi bënëꞌ guza, caora naꞌ rezëꞌë redyinnëꞌ z̃an yuꞌu ratanëꞌ rasinëꞌ quie rtzeꞌ, rasanëꞌ quie zila. Canaꞌ ruenëꞌ rde dza tu rlë bini trigo reꞌenina, binezi benꞌ naꞌ birue bini trigo ta ilëna gueꞌenina. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Naꞌra tu cuinzi yu rsegulan bini. Tanëro rlën len laꞌagaꞌ daoꞌ quien. Naꞌ bëꞌ banacan tahuala, ilë dao quien. Bëꞌ bardzatza dao quien, canaꞌ cuian trigo. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cati aobidyi trigo, naꞌra rchugujëꞌn reziꞌjëꞌn, danꞌ babdyin dza quie usecho quien. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Lëscanꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Con bidanꞌ utilalëbi yelaꞌ rnabëꞌ quie Diuzi? ¿Con bi diꞌidzaꞌ reꞌennan ta uzioñeꞌedaꞌ leꞌe? ");
INSERT INTO zpcNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naca yelaꞌ rnabëꞌ quie Diuzi ca quie tu bini mostaza ta raza benëꞌ luꞌu yu. Naca bini mostaza bini daoꞌ biz̃u gula. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero cati bayuꞌun luꞌu yu, hualëna hueꞌenina gacan tu yaga z̃e gula. Tanto naca tona xuꞌuzan quien, hasta huida yaca bguini, bia dyia xile, ta yezilaꞌadyiꞌbaꞌ ga zë z̃ula quien. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Canaꞌ una Jesús psëdinëꞌ yaca benëꞌ xtiꞌidzaꞌ Diuzi. Bzunëꞌ zë diꞌidzaꞌ ta gacalën leyaquëꞌ ta tzioñeꞌeyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Puro lao naꞌa diꞌidzaꞌ ta nacan irupa iyunala psëdi Jesús yaca benëꞌ, pero cati zuëꞌ tuzinëꞌ len yaca benꞌ quiëꞌ, caora naꞌ pxiꞌidzeꞌnëꞌ leyaquëꞌ bi reꞌen ina diꞌidzaꞌ ta nacan irupa iyunala. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Cati bagula uxin banaca chula, naꞌ una Jesús rëbinëꞌ yaca benꞌ quiëꞌ: ―Yaꞌ tzioro itzalaꞌ lagun. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Naꞌra udeyaquëꞌ ga zë yaca benꞌ naꞌ, uyuꞌuyaquëꞌ luꞌu barco ga ureꞌ Jesús uzaꞌyaquëꞌ zioyaquëꞌ itzalaꞌ lagun. Lëscanꞌ ziorë ichopa tzona barco nuꞌan benëꞌ len leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Binedyinyaquëꞌ itzalaꞌ lagun cati uzulao rda tu be bedunꞌ fuerte gula. Tanto raca be bedunꞌ, ben gan uyudzo nisa luꞌu barco, ilëꞌëtiꞌzi bibedzaꞌ nisa luꞌu barco. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Naꞌ zaquëꞌ z̃bam barco ureꞌ Jesús rasinëꞌ lao xcugonëꞌ. Pero psebë yaca benꞌ quiëꞌ lëbëꞌ, unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¡Maestro! ¿Birdëbiloꞌ galaꞌ gatiro luꞌu nisa? ");
INSERT INTO zpcNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Naꞌra uyasa Jesús udilanëꞌ be bedunꞌ. Lëscanꞌ unëꞌ gudyinëꞌ nisa: ―¡Ureꞌ chizi! ¡Bira huuꞌ zëdi! Caora naꞌ uleza be bedunꞌ, begaꞌn chizi lao lagun. ");
INSERT INTO zpcNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Naꞌra una Jesús rëbinëꞌ yaca benꞌ quiëꞌ: ―¿Bixquienꞌ rdzebile? ¿Bixquienꞌ biralele ute usela Diuzi raꞌo? ");
INSERT INTO zpcNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero begaꞌn yaca benꞌ quienëꞌ rdzebiyaquëꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Nuz̃i naca benꞌ niga como hasta be bedunꞌ len nisa ralen quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Naꞌra bdyin Jesús lënëꞌ yaca benꞌ quienëꞌ itzalaꞌ lagun ganꞌ nitaꞌ yaca benꞌ Gadara. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ca bro Jesús luꞌu barco, labdyinte tu benꞌ yuꞌu bichi be mala ganꞌ zë Jesús. Babronëꞌ ga dyia yaca beló ga rucachiꞌyaquëꞌ benꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yugu dza, yugu yela, zunëꞌ naꞌ ga dyia beló. Ni tu benꞌ nitaꞌ naꞌ biuzueyaquëꞌ uquioyaquëꞌ lëbëꞌ con caden. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zë lasa pquioyaquëꞌ lënëꞌ con caden naꞌanëꞌ len niꞌanëꞌ, pero uchugunëꞌn bz̃uz̃u pquinonëꞌn. Nitu nunu uzue ucaxo lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yugu dza, yugu yela, udanëꞌ ga dyia beló du lëꞌë yaꞌa, rbedyiyaꞌnëꞌ rziꞌnëꞌ yo rguinëꞌ cuinnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Caora blëꞌënëꞌ Jesús zituꞌla, naꞌra uyuꞌunëꞌ be zionëꞌ yeditzu z̃ibinëꞌ lao Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Naꞌ uredyiyaꞌ bichi be mala yuꞌunëꞌ rëbina Jesús: ―¿Bixquienꞌ zaoꞌ niga? Luëꞌ Jesús, z̃iꞌi Diuzi zu sibi. Rnabayëchaꞌ luëꞌ lao Diuzi ta biutzagalaoloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Canaꞌ una bichi be mala rëbina Jesús como danꞌ gudyi Jesús len: ―Bichi be mala luëꞌ, bero benꞌ ni. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Naꞌ unaba Jesús rëbinëꞌ len: ―¿Bi laoloꞌ? Naꞌ bequëbina rëbina Jesús: ―Xopa mila laohuaꞌ danꞌ nacandoꞌ zë. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Lëscanꞌ unabayëchiꞌnëꞌ Jesús ta biuseꞌelaꞌ Jesús leyacan ga naca zituꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Biz̃i gaꞌalaꞌ ganꞌ zë Jesús nitaꞌ yaca cuchi zë lao ledaꞌ. Rquiꞌnyacabaꞌ ta yedzeleyacabaꞌ bi gaoyacabaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Naꞌ unabayëchiꞌ yaca bichi be mala rëbiyacan Jesús: ―Huuꞌ cule iseꞌeloꞌ nëtoꞌ ganꞌ nitaꞌ yaca cuchi. Ben lato tzuꞌundoꞌ leyacabaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Naꞌra bëꞌ Jesús lato ta tzuꞌuyacan luꞌu yaca cuchi. Canaꞌ beroyacan beꞌmbyu beyuꞌuyacan yaca cuchi. Naꞌ nitaꞌ cadu chopa mila cuchi lao ledaꞌ naꞌ. Caora beyuꞌu yaca bichi be mala luꞌu yaca cuchi, naꞌ uxitiyacabaꞌ beyëziyacabaꞌ lëꞌë ledaꞌ uyuꞌuyacabaꞌ luꞌu nisa ga gutiyacabaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Naꞌ biz̃i bz̃uno yaca benꞌ rapa cuchi. Du rdzebiyaquëꞌ yetixogueꞌyaquëꞌ du tu neza len laꞌo yedyi bi guca. Lenaꞌ bdyin yaca benëꞌ ta inaꞌyaquëꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Naꞌ caora bdyinyaquëꞌ ga zë Jesús, blëꞌëyaquëꞌ benꞌ babero yaca bichi be mala. Blëꞌëyaquëꞌ areꞌnëꞌ chizi, banaconëꞌ z̃abanëꞌ, babeyuꞌunëꞌ pensari. Naꞌ lega bdzebiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Naꞌ yaca benꞌ blëꞌë cabëꞌ bë Jesús, udixogueꞌyaquëꞌ yaca benꞌ bdyin naꞌ cabëꞌ guca quie benꞌ uyuꞌu bichi be mala, lëscanꞌ cabëꞌ guca quie yaca cuchi. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Naꞌra unabayëchiꞌyaquëꞌ Jesús ta biyegaꞌnnëꞌ yu nebaba yedyi quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Caora beyuꞌu Jesús luꞌu barco, unaba benꞌ bero yaca bichi be mala chi bigun Jesús lato ta tziolënëꞌ Jesús ganꞌ tzioguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero bibëꞌ Jesús lëbëꞌ lato. Lenaꞌ unëꞌ gudyinëꞌ benꞌ naꞌ: ―Beyo z̃an yuꞌu quioꞌ yetixogueꞌ familia quioꞌ cabëꞌ guca quioꞌ beyëchiꞌlaꞌadyiꞌ Diuzi luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Naꞌra zeyonëꞌ tzetixogueꞌnëꞌ yaca benꞌ nitaꞌ ganꞌ de chi yedyi quie yu laona Decápolis yugulu cabëꞌ bë Jesús quienëꞌ. Naꞌra caora be yaca benëꞌ canꞌ unëꞌ, begaꞌnyaquëꞌ bebanziyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Naꞌra beyuꞌu Jesús luꞌu barco uz̃ëꞌë zionëꞌ itzalaꞌ lagun. Caora bdyinnëꞌ naꞌ, babedupa benꞌ zë ganꞌ zënëꞌ. Naꞌ begaꞌn Jesús ruꞌa lagun naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Naꞌ bdyin tu xanꞌ idaoꞌ sinagoga laonëꞌ Jairo ganꞌ zë Jesús. Caora blëꞌënëꞌ Jesús, uditzu z̃ibinëꞌ laohuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Naꞌ unabayëchiꞌnëꞌ rëbinëꞌ Jesús: ―Barati z̃iꞌinaꞌ. Chi huuꞌ cule, ¿bisaoꞌ ta idedaꞌloꞌ naoꞌ z̃iꞌinaꞌ cuenda yeyueloꞌbiꞌ ta bigatibiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Naꞌra ziolë Jesús lëbëꞌ, pero lëscanꞌ ziorë yaca benꞌ zë pquiꞌyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Naꞌ entre yaca benꞌ ziolë Jesús uzu tu nigula raca quie biuꞌ quienëꞌ chopa tzona lasa tu biuꞌ. Bazio chipchopa iza ruen quienëꞌ canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Uyonëꞌ yenëꞌ zë benꞌ médico, beya dumi quienëꞌ bënëꞌ gasto, pero biuz̃iꞌ yelaꞌ hueꞌ quienëꞌ remedio. Naꞌ remedio uz̃iꞌnëꞌ, bigucalën lëbëꞌ, bdyiaguiꞌn mazara lëbëꞌ, iziꞌra bëna. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Naꞌra babe nigula naꞌ cabëꞌ reyue Jesús benꞌ raca z̃hueꞌ. Quie lenaꞌ yesënëꞌ xcuꞌudzu Jesús ga zë yaca benëꞌ, bdaꞌnëꞌ z̃benëꞌ z̃abëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Canaꞌ bë nigula naꞌ como danꞌ guquenëꞌ: “Chi udaꞌ z̃biaꞌ z̃aba Jesús, hueyacaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Naꞌra caora bdaꞌnëꞌ z̃benëꞌ z̃aba Jesús, bebidyi ren, bero yelaꞌ hueꞌ yuꞌunëꞌ, gucabëꞌnëꞌ babeyacanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lëscanꞌ gucabëꞌ Jesús babeyuenëꞌ nu benꞌ raca z̃hueꞌ conlë yelaꞌ huaca quienëꞌ. Quie lenaꞌ beyëchoguëꞌ rnëꞌë yaca benꞌ zë xcuꞌudzëꞌ, unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Nuz̃i bdaꞌ z̃be z̃abaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Naꞌra una yaca benꞌ quiëꞌ rëbiyaquëꞌ lëbëꞌ: ―Rlëꞌëloꞌ ruquiꞌ yaca benëꞌ luëꞌ, naꞌra naoꞌ, “¿Nuz̃i bdaꞌ z̃be nëꞌëdiꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero unaꞌ Jesús yaca benꞌ zë naꞌ ta idzelenëꞌ nu benꞌ bdaꞌ z̃be lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Naꞌra unezi nigula bi guca quienëꞌ. Quie lenaꞌ du rz̃izinëꞌ, du rdzebinëꞌ, bebigaꞌnëꞌ uditzu z̃ibinëꞌ lao Jesús, gudyinëꞌ lëbëꞌ cabëꞌ guca quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Naꞌ una Jesús rëbinëꞌ nigula naꞌ: ―Zanaꞌ, babeyacoꞌ nun quie rzudyiꞌilëloꞌ nëꞌëdiꞌ. Beyo z̃an yuꞌu quioꞌ, bira idëboꞌ. Apsan yelaꞌ hueꞌ quioꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Neruꞌelë Jesús nigula naꞌ diꞌidzaꞌ cati bdyin chopa tzona benꞌ uzaꞌ yuꞌu quie benꞌ naca xanꞌ idaoꞌ sinagoga. Naꞌ unayaquëꞌ rëbiyaquëꞌ xanꞌ sinagoga: ―Baguti z̃iꞌiloꞌ. Bira cule hueloꞌ maestro zëdi. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero bibë Jesús casa ca unayaquëꞌ. Naꞌ unëꞌ rëbinëꞌ xanꞌ sinagoga: ―Bidzeboꞌ. Sudyiꞌilëloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Naꞌra bibëꞌ Jesús lato tziolë yaca benꞌ zë naꞌ len lëbëꞌ. Naꞌ uquiëꞌnëꞌ Pedro, len Santiago, len Juan bichi Santiago. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Cati bdyinyaquëꞌ ruꞌa yuꞌu quie xanꞌ sinagoga, blëꞌë Jesús nitaꞌ benꞌ zë, yuꞌuyaquëꞌ ruꞌbe, rbedyiyaꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Caora uyuꞌu Jesús lënëꞌ tzona benꞌ quiëꞌ luꞌu yuꞌu naꞌ, unëꞌ rëbinëꞌ yaca benꞌ nitaꞌ naꞌ: ―¿Bixquienꞌ ruꞌule ruꞌbe rbedyiyaꞌle? Baꞌalaꞌcazi agutibiꞌ, raca quiebiꞌ ca quie biꞌ rasizi. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero bz̃idyiyaquëꞌ ca una Jesús. Caora naꞌ bë Jesús mandado yeroyaquëꞌ luꞌu yuꞌu. Naꞌ uquiëꞌ Jesús tzona benꞌ quiëꞌ len xuzi z̃naꞌ bidaoꞌ huati. Uyuꞌuyaquëꞌ luꞌu cuarto ga de biꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naꞌ bëxu Jesús naꞌabiꞌ unëꞌ rëbinëꞌbiꞌ: ―Talita cumi ―ta inaro xtiꞌidzaꞌro: Zanaꞌ, rniaꞌ luëꞌ, uyasa. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Caora beyudyi una Jesús canaꞌ, uyasa nigula daoꞌ bedabiꞌ. Baozubiꞌ chipchopa iza. Naꞌ begaꞌn xuzi z̃naꞌ bidaoꞌ tu bebanzitzegueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero gudyi Jesús leyaquëꞌ ta biquixogueꞌyaquëꞌ yaca benëꞌ cabëꞌ bënëꞌ quie bidaoꞌ huati. Lëscanꞌ bënëꞌ mandado ta hueꞌyaquëꞌbiꞌ ta gaobiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Naꞌra uzaꞌ Jesús zionëꞌ bedyinnëꞌ yedyi quienëꞌ lënëꞌ yaca benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Caora guca dza saodo, dza huezilaꞌadyiꞌ quieyaquëꞌ, uyuꞌu Jesús luꞌu idaoꞌ sinagoga ta usëdinëꞌ yaca benꞌ bdupa naꞌ. Naꞌ tu rebanzi yaca benꞌ bzënaga canꞌ unëꞌ. Lenaꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Gaz̃i yesëdi benꞌ niga? ¿Biz̃i bënëꞌ banaquëꞌ benꞌ de yelaꞌ rioñeꞌe quie? ¿Biz̃i ruenëꞌ, ruenëꞌ ta binelëꞌëro? ");
INSERT INTO zpcNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pues naca benꞌ niga benꞌ rchaꞌa yaga. Z̃iꞌi María naquëꞌ. Naca Santiago, len José, len Judas, len Simón biꞌ bichinëꞌ. Ni nitaꞌ ladoro yaca biꞌ zannëꞌ. Quie lenaꞌ bibëyaquëꞌ casa quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Lenaꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Nu benꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi, rapalaꞌncazi yaca benëꞌ lëbëꞌ. Pero benꞌ yedyi quienëꞌ, len familia quienëꞌ, len benꞌ zu z̃an yuꞌu quienëꞌ, birapalaꞌnyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Quie lenaꞌ bibë Jesús yelaꞌ huaca quienëꞌ ladoyaquëꞌ. Tu chopazi benꞌ raca z̃hueꞌ bdaꞌnëꞌ nëꞌë beyuenëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Naꞌ bebanzi Jesús danꞌ tu bzënagaziyaquëꞌ canꞌ unëꞌ, naꞌ bibëyaquëꞌ lëbëꞌ casa. Naꞌra uzaꞌ Jesús zioguëꞌ yaca yedyi nitaꞌ gaꞌalaꞌ, uzulaonëꞌ rguixogueꞌnëꞌ yaca benꞌ nitaꞌ yaca yedyi naꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Caora naꞌ betupa Jesús chipchopa benꞌ quienëꞌ, bëꞌnëꞌ yelaꞌ huaca quienëꞌ ta yebioyaquëꞌ yaca bichi be mala yuꞌu benëꞌ. Naꞌra chopa huioyaquëꞌ useꞌelëꞌ leyaquëꞌ tu tu yedyi. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Naꞌra bënëꞌ mandado bihuaꞌayaquëꞌ bi cosa tu neza. Bënëꞌ mandado tuzi xaga huaꞌayaquëꞌ. Bihuaꞌayaquëꞌ ni yëxo, ni yëta, ni dumi. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Reyaꞌalaꞌ udeyaquëꞌ huaracho, reyaꞌalaꞌ gacoyaquëꞌ tu cueꞌzi z̃abayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Luꞌu yuꞌu ganꞌ idyinle, naꞌ yegaꞌnle hasta que yezaꞌle yeyole yedyi tula. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Caora abdyinle tu yedyi, chi bireꞌen yaca benëꞌ siꞌyaquëꞌ leꞌe dyëꞌëdi, chi bireꞌenyaquëꞌ uzënagayaquëꞌ quiele, naꞌra yerole ganꞌ, usisile niꞌale ta gasi bëxte dyia niꞌale ta uluꞌen quieyaquëꞌ dulaꞌ quieziyaquëꞌ nenao dulaꞌ xquia quieyaquëꞌ leyaquëꞌ. Nacan tali ca rniaꞌ leꞌe, cati abdyin dza gaca juicio, huedzagalaora benꞌ bibzënaga quiele mazara ca benꞌ ciudad Sodoma len benꞌ ciudad Gomorra. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Naꞌra zioyaquëꞌ tzetixogueꞌyaquëꞌ benëꞌ gudyiyaquëꞌ leyaquëꞌ ca reꞌen Diuzi utzaꞌyaquëꞌ pensari quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lëscanꞌ bebioyaquëꞌ yaca bichi be mala yuꞌu yaca benëꞌ, bzuyaquëꞌ aceite guicho yaca benꞌ raca z̃hueꞌ, beyacayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Naꞌra bdyin dza be rey Herodes cabëꞌ rue Jesús nun quie ruꞌe yaca benëꞌ diꞌidzaꞌ cabëꞌ ruenëꞌ. Naꞌ guque rey Herodes pensari nëꞌ: ―Babeban Juan bautista. Quie lenaꞌ ruenëꞌ milagro. ―Canaꞌ una rey Herodes naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Naꞌ una bala benëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Naquëꞌ Elías, benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi dza naꞌ. Naꞌ ibala yaca benëꞌ unayaquëꞌ: ―Naquëꞌ benꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi cabëꞌ bë benꞌ unitaꞌ tiempote. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Caora be rey Herodes cabëꞌ una yaca benëꞌ, naꞌra unëꞌ: ―Benꞌ naꞌ naquëꞌ Juan, benꞌ biaꞌ mandado uchuguyaquëꞌ lubaꞌnëꞌ. Naꞌra babebannëꞌ tatula. ―Canaꞌ una rey Herodes naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Lëcanaꞌ bë rey Herodes, bënëꞌ mandado bëxo yaca soldado Juan bdzeꞌyaquëꞌ lëbëꞌ luꞌu dyiguiba. Nun quie z̃gulanëꞌ Herodías bënëꞌ mandado pquioyaquëꞌ lëbëꞌ con caden luꞌu dyiguiba. Pues guca Herodías z̃gula benꞌ tula, benꞌ lao Felipe. Pero baoz̃iꞌ rey Herodes z̃gula Felipe, bazulënëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Quie lenaꞌ una Juan dza naꞌte gudyinëꞌ rey Herodes: ―Bireyaꞌalaꞌ sulaoꞌ nigula quie biꞌ bichoꞌ Felipe. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Quie lenaꞌ lega udie Herodías Juan guꞌunnëꞌ gutinëꞌ lëbëꞌ, pero biubinnëꞌ bi huenëꞌ ta gutinëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Canaꞌ guca quie Herodías como danꞌ nezi rey Herodes naca Juan benꞌ huen, benꞌ laꞌiya. Quie lenaꞌ bdzebi Herodes bibëꞌnëꞌ lato hue nigula naꞌ tamala Juan. Lëscanꞌ, baꞌalaꞌcazi biuyoñeꞌe rey Herodes dyëꞌëdi cabëꞌ gudyi Juan lëbëꞌ, bzënaguëꞌ quienëꞌ con gusto. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero bdyin dza rbëꞌnidyi Herodías cabëꞌ huenëꞌ ta gati Juan. Lëdza naꞌ bë rey Herodes tu lani quie dza cumpleaños quienëꞌ. Bëꞌnëꞌ ta gao yaca benꞌ rnabëꞌ lao naꞌanëꞌ, len yaca benꞌ naca xanꞌ soldado quienëꞌ, len yaca los demás benꞌ belao, benꞌ nitaꞌ yedyi nebaba Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Naꞌ uyuꞌu tu nigula daoꞌ, biꞌ naca z̃iꞌi Herodías, ganꞌ raca lani naꞌ ta uyaꞌabiꞌ zaquëꞌlao lao yaca benꞌ naꞌ. Caora naꞌ lega yaxe Herodes len yaca benꞌ raolënëꞌ rtzeꞌ cabëꞌ byaꞌa nigula daoꞌ naꞌ. Naꞌ una Herodes rëbinëꞌ biꞌ nigula daoꞌ: ―Con bitezi ta inaboꞌ nëꞌëdiꞌ, nagunaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Naꞌra bguntenëꞌ Diuzi hueꞌnëꞌ nigula daoꞌ con ta inababiꞌ, baꞌalaꞌcazi inababiꞌ gatzo yedyi ga rnabëꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Naꞌ bero nigula daoꞌ yeguëdyibiꞌ z̃naꞌbiꞌ rëbibiꞌ lëbëꞌ: ―¿Biz̃i inabaꞌ rey naꞌ? Naꞌ una z̃naꞌbiꞌ rëbinëꞌ lëbiꞌ: ―Unaba guicho Juan bautista. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Naꞌra beyuꞌu nigula daoꞌ ga reꞌ rey naꞌ, naꞌ gudyibiꞌ lënëꞌ: ―Reꞌendaꞌ laguntegazoꞌ guicho Juan bautista tu luꞌu plato. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Naꞌ guqueyëchiꞌ rey Herodes danꞌ unaba nigula daoꞌ guicho Juan. Pero como babguntenëꞌ lao Diuzi, babe yaca benꞌ zë lao lani quienëꞌ ca ta unëꞌ gudyinëꞌ nigula daoꞌ, biuz̃aqueꞌ yëbinëꞌbiꞌ bihueꞌnëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Quie lenaꞌ luegozi bënëꞌ mandado uyo tu soldado ta tzexiꞌnëꞌ guicho Juan. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Naꞌ uyo soldado uyuꞌunëꞌ luꞌu yuꞌu dyiguiba, uchugunëꞌ lubaꞌ Juan, zeyuꞌanëꞌn tu luꞌu plato ga raca lani, bëꞌnëꞌn nigula daoꞌ naꞌ. Naꞌ uyo nigula yesambiꞌn lao z̃naꞌbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cati unezi yaca benꞌ quie Juan agutinëꞌ, caora naꞌ uzaꞌyaquëꞌ yexiꞌyaquëꞌ cuerpo quienëꞌ ta pcachiꞌyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bëꞌ beyudyi naꞌ, bedyin yaca benꞌ quie Jesús gudyiyaquëꞌ lëbëꞌ yugulu ta bëyaquëꞌ psëdiyaquëꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Uletzaꞌ tzioro ruꞌa yedyi ga binitaꞌ benëꞌ cuenda yezilaꞌadyiꞌro. Canaꞌ una Jesús danꞌ tantozi rdyin benꞌ rdyin, zazaꞌ benꞌ zazaꞌ, ni siquiera bibëꞌnan lato ta gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Naꞌra uzaꞌ Jesús lënëꞌ yaca benꞌ quiëꞌ, uyuꞌuyaquëꞌ luꞌu barco ta tzioyaquëꞌ ruꞌa yedyi ga nunu nitaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero blëꞌë yaca benꞌ zë azio Jesús bezaqueyaquëꞌ lëbëꞌ. Quie lenaꞌ uyuꞌuyaquëꞌ be, uzaꞌyaquëꞌ quie quie yedyi quieyaquëꞌ zioyaquëꞌ bdyinyaquëꞌ rbezayaquëꞌ ga idyin Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Caora bdyin Jesús naꞌ, blëꞌënëꞌ nitaꞌ benꞌ zë rbezayaquëꞌ lëbëꞌ. Naꞌ beyëchiꞌlaꞌadyiꞌnëꞌ leyaquëꞌ, como danꞌ naca quieyaquëꞌ ca quie yaca becoꞌ z̃iꞌilaꞌ neniti xaꞌne. Naꞌra bezulao Jesús rusëdinëꞌ leyaquëꞌ diꞌidzaꞌ zëra. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Caora baoyaꞌ dza, bazaꞌ rdzeꞌ, una yaca benꞌ quiëꞌ rëbiyaquëꞌ lëbëꞌ: ―Bardzeꞌ barala, quele biyuꞌu dyia niga. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mejorla yeseꞌeloꞌ yaca benëꞌ yeyoyaquëꞌ laꞌo yedyi gaꞌalaꞌ ta gaꞌoyaquëꞌ ta gaoyaquëꞌ, porque bide ta gaoyaquëꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Naꞌ una Jesús rëbinëꞌ yaca benꞌ quiëꞌ: ―Ulehueꞌ ta gaoyaquëꞌ. Naꞌ unayaquëꞌ: ―¿Reꞌenloꞌ tzegueꞌendoꞌ chopa gayuhua dumi denario yëta xtila ta gaoyaquëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Bala yëta xtila nuꞌale? Uletzio tzenaꞌle. Naꞌra caora uneziyaquëꞌ unayaquëꞌ Jesús: ―Gaꞌyoꞌ yëta xtila len chopa bela. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Naꞌ bë Jesús mandado ureꞌ yaca benëꞌ tu cueꞌ huioyaquëꞌ lao guiz̃i. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Naꞌ ganꞌ ureꞌyaquëꞌ, ureꞌ benꞌ ureꞌ tu gayuhua. Naꞌ reꞌ benꞌ ureꞌrë igatzo gayuhua. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Caora naꞌ uz̃iꞌ Jesús lao gaꞌyoꞌ yëta xtila len chopa bela. Bëꞌ bazënëꞌn, unëꞌë ladza rëbinëꞌ Diuzi diuxcaleloꞌ. Naꞌ bz̃uz̃unëꞌn bëꞌn laze. Bëꞌnëꞌn yaca benꞌ quiëꞌ ta udisiyaquëꞌn gao yaca benëꞌ. Lëscanꞌ bz̃uz̃urënëꞌ yaca bela ta gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Naꞌ udao yuguluteyaquëꞌ, udaoyaquëꞌ ca tu beloyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Begaꞌnra ichipchopa gaꞌ naga yëta xtila yuz̃o len bela yuz̃o ta beziꞌyaquëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Naca yaca benꞌ udao ca du gaꞌyoꞌ mila beꞌmbyu, apartela nigula len xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Naꞌ bë Jesús mandado yeyuꞌu yaca benꞌ quienëꞌ luꞌu barco cuenda cuialaonezayaquëꞌ lëbëꞌ idyinyaquëꞌ ganꞌ de ciudad Betsaida, tu rëbi Jesús yaca benëꞌ ta yeyoyaquëꞌ z̃an yuꞌu quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Caora bedzatza yaca benëꞌ, uzaꞌnëꞌ zionëꞌ lëꞌë yaꞌa ta hueꞌlënëꞌ Diuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Biz̃i barala uxin zio yaca benꞌ quie Jesús begaꞌnyaquëꞌ gatzo laꞌo lagun. Naꞌ begaꞌn Jesús nezënëꞌ ruꞌa yu bidyi quie lagun. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Naꞌ blëꞌë Jesús raca rdilalë benꞌ quienëꞌ be bedunꞌ, biruꞌen lato ta usaꞌyaquëꞌ barco lao lagun. Naꞌ ilëꞌëtiꞌzi tzeniꞌ, bebigaꞌ Jesús ga reꞌyaquëꞌ luꞌu barco rzaꞌnëꞌ lao nisa ta tenëꞌ ga reꞌ barco naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Cati blëꞌëyaquëꞌ zio Jesús rzëꞌë tu lao nisa, guqueyaquëꞌ chi ludzaꞌ benꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Naꞌ lega bdzebiyaquëꞌ uredyiyaꞌyaquëꞌ. Pero una Jesús rëbinëꞌ leyaquëꞌ: ―Bidzebile, nëꞌëdiꞌ zaꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Caora uyuꞌu Jesús luꞌu barco ganꞌ yuꞌuyaquëꞌ, naꞌ lapsante be bedunꞌ. Pero lega rebanetzegueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Canaꞌ guca quieyaquëꞌ, como danꞌ binetzioñeꞌeyaquëꞌ cabëꞌ yelaꞌ huaca bë Jesús quie yëta xtila. Nenacan zidi luꞌu guicho laxtaꞌoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Naꞌra zioyaquëꞌ bdyinyaquëꞌ ruꞌa lagun ga de yaca yedyi nebaba Genesaret. Lëganꞌ naꞌ pquioyaquëꞌ barco quieyaquëꞌ ruꞌa lagun. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Caora broyaquëꞌ luꞌu barco labezaquete yaca benꞌ nitaꞌ naꞌ Jesús naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Naꞌ uyuꞌuyaquëꞌ be, uyoyaquëꞌ yugu yedyi de naꞌ, yexiꞌyaquëꞌ yaca benꞌ raca z̃hueꞌ, uxubayaquëꞌ leyaquëꞌ lao belaga, yesanyaquëꞌ leyaquëꞌ ga neziyaquëꞌ zu Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Con ga ude Jesús, chi yedyi daoꞌ, chi yedyi z̃e, chi ciudad, udixoyaquëꞌ belaga ganꞌ z̃uba benꞌ raca z̃hueꞌ du tu neza, unabayaquëꞌ cule hueꞌ Jesús lato ta udaꞌyaquëꞌ siquiera tacayaquëꞌ niꞌa z̃abanëꞌ. Naꞌ yugu benꞌ bdaꞌ taque z̃abanëꞌ, bero yelaꞌ hueꞌ yuꞌuyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Naꞌra guca dza bdyin bala benꞌ naca partido fariseo len bala benꞌ rusëdi ley quie Moisés, benꞌ uzaꞌ ciudad Jerusalén, bebigaꞌyaquëꞌ ga zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Naꞌ blëꞌëyaquëꞌ rao bala benꞌ quie Jesús du binequibi naꞌayaquëꞌ. Quie lenaꞌ udaoyaquëꞌ leyaquëꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Cani rue yaca benꞌ naca partido fariseo len yaca los demás benꞌ Israel. Nenaoyaquëꞌ costumbre quie xuzixtaꞌoyaquëꞌ, bigaoyaquëꞌ chi binequibi naꞌayaquëꞌ zë lasa. Pero quele rguibi naꞌayaquëꞌ danꞌ nacan besu, dechanꞌ danꞌ inayaquëꞌ canaꞌ yeyëri laxtaꞌoyaquëꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Lëscanꞌ, caora rioyaquëꞌ lao yeꞌeya redyinyaquëꞌ z̃an yuꞌu, bigaoyaquëꞌ chi binegazuyaquëꞌ yao. Lëscanꞌ dera zë costumbre nenaoyaquëꞌ, rguibiyaquëꞌ nu taza, nu candi, nu yaca traste de guíba. Lente belaga quieyaquëꞌ rguibiyaquëꞌ como danꞌ inayaquëꞌ canaꞌ yeyërin lao Diuzi.) ");
INSERT INTO zpcNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Naꞌra una yaca benꞌ naca partido fariseo len yaca benꞌ rusëdi ley quie Moisés, rëbiyaquëꞌ Jesús: ―¿Bixquienꞌ binao yaca benꞌ quioꞌ costumbre quie xuzixtaꞌoro? Raoyaquëꞌ du binequibi naꞌayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Dyëꞌëdi una Moisés cabëꞌ ruele, biruele cabëꞌ nale. Canaꞌ una Moisés caora bzunëꞌ diꞌidzaꞌ lëꞌë guichi nan ca niga: Yaca benꞌ niga rapalaꞌnyaquëꞌ Diuzi de diꞌidzaꞌzi, birapalaꞌnyaquëꞌ lëbëꞌ du guicho du laꞌadyiꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bibi sirve rionlaꞌadyiꞌyaquëꞌ Diuzi. Puro mandado quie benëꞌ rusëdiyaquëꞌ nayaquëꞌ mandado quie Diuzi naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Lëscanꞌ unarë Jesús: ―Leꞌe rutele diꞌidzaꞌ quie Diuzi tzalaꞌla tacuenda huele costumbre quie xuzixtaꞌole. Lenaꞌ rguibile candi quiele, rguibile vaso quiele. Lenaꞌ dera costumbre ta naca lëbizi quiele ruele quie xuzixtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Lëscanꞌ unaranëꞌ: ―Rutele tzalaꞌla ca naca mandamiento quie Diuzi ta inaole costumbre quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Dyëꞌëdi rnën lëꞌë guichi bë Moisés: “Reyaꞌalaꞌ gapalaꞌnle xuzile len z̃naꞌle.” Lëscanꞌ rnën: “Nu benꞌ rudzeꞌdeꞌ xuzi z̃nëꞌë, reyaꞌalaꞌ gatinëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero leꞌe nale chi yëbi benëꞌ xuzi z̃nëꞌë: “Bide ta gacaliaꞌ leꞌe, como danꞌ yugulu ta de quiaꞌ nacan gun quie Diuzi.” ");
INSERT INTO zpcNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Naꞌra leꞌe nale chi yëbi benëꞌ xuzi z̃nëꞌë canaꞌ, biruen zi gacalënëꞌ xuzi z̃nëꞌë. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Canaꞌ rutele tzalaꞌla ca naca mandamiento quie Diuzi ta inaole costumbre quiele. Lëscanꞌ rusëdile z̃iꞌile ta inaorëyacabiꞌ hueyacabiꞌ cabëꞌ ruele. Lëscanꞌ zëra costumbre de quiele nacan lëbi ca costumbre naole quie xuzixtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Naꞌra beyëz̃i Jesús yaca benëꞌ tatula unëꞌ rëbinëꞌ leyaquëꞌ: ―Ulezëcara nagale ta tzioñeꞌele cabëꞌ rniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Quele ta gao yaca benëꞌ nuen leyaquëꞌ badzaꞌ lao Diuzi, dechanꞌ pensari median rero luꞌu guicho laxtaꞌoyaquëꞌ, lëlenaꞌ nuen leyaquëꞌ badzaꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nu leꞌe reꞌen ye, ulezë nagale. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Naꞌra uzaꞌ Jesús zionëꞌ bdyinnëꞌ z̃an yuꞌu quienëꞌ. Caora naꞌ unaba yaca benꞌ quiëꞌ lëbëꞌ ca bi reꞌen ina diꞌidzaꞌ unëꞌ bachi. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Lëscanꞌ leꞌe birioñeꞌele? ¿Binezile ta rao yaca benëꞌ binuen leyaquëꞌ badzaꞌ lao Diuzi, ");
INSERT INTO zpcNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","como biruꞌun luꞌu laxtaꞌoyaquëꞌ, dechanꞌ ruꞌun luꞌu lëꞌëyaquëꞌ, te naꞌ rguichiyaquëꞌn? Canaꞌ una Jesús pxiꞌidzeꞌnëꞌ raꞌo yugulu yelaꞌ huao nacan ta gaoro, binuen raꞌo badzaꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Lëscanꞌ una Jesús cani: ―Yaca pensari median rero luꞌu guicho laxtaꞌo benëꞌ, lëlenaꞌ nuen leyaquëꞌ badzaꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nun quie pensari median rero luꞌu guicho laxtaꞌo benëꞌ, quie lenaꞌ rtilayaquëꞌ nigula cuidiꞌ, rbanyaquëꞌ quie laguedyiyaquëꞌ, rutiyaquëꞌ laguedyiyaquëꞌ, rtilayaquëꞌ z̃gula laguedyiyaquëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","rzaꞌlaꞌadyiꞌyaquëꞌ ta de quie laguedyiyaquëꞌ, rueyaquëꞌ tabayatza, rziꞌyaquëꞌ yëꞌ, rguiloyaquëꞌ nigula yugu dza, racaz̃ëꞌjëꞌ laguedyiyaquëꞌ, rueyaquëꞌ z̃e cuinyaquëꞌ, biyuꞌuyaquëꞌ gracia. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Canaꞌ naca tamala rero luꞌu guicho laxtaꞌo yaca benëꞌ nuen leyaquëꞌ badzaꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Naꞌra uzaꞌ Jesús ganꞌ zioguëꞌ bdyinnëꞌ ga naca yu nebaba ciudad Tiro len ciudad Sidón. Bdyinnëꞌ tu luꞌu yuꞌu zu naꞌ, pero biguꞌunnëꞌ inezi yaca benëꞌ ganꞌ bdyinnëꞌ, pero bedzelecazi yaca benëꞌ ganꞌ bdyinnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Lëscanꞌ laonezite tu nigula yuꞌu z̃iꞌinëꞌ bichi be mala ga bdyin Jesús. Quie lenaꞌ uzaꞌnëꞌ bdyinnëꞌ ga zë Jesús uditzu z̃ibinëꞌ laohuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Naꞌra lënigula naꞌ binaquëꞌ benꞌ Israel, naquëꞌ benꞌ Sirofenicia. Bidëꞌ unabëꞌ chi biyebio Jesús bichi be mala yuꞌu z̃iꞌinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Naꞌ una Jesús rëbinëꞌ nigula naꞌ: ―Tanëro ruen zi gacaliaꞌ yaca benꞌ Israel, benꞌ naca ca quie z̃iꞌinaꞌ, como danꞌ binacan huen siꞌro yelaꞌ huao ta gao yaca xcuidiꞌ, naꞌ tzechuꞌunroꞌn ta gao yaca becoꞌ daoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Naꞌ una nigula rëbinëꞌ Jesús: ―Laga canꞌ naoꞌ, Señor, pero lente yaca becoꞌ daoꞌ raoyacabaꞌ yaca pedazo rguino layu ga rao yaca xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Tahuen baonaoꞌ. Beyo z̃an yuꞌu quioꞌ. Babero bichi be mala yuꞌu z̃iꞌiloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Caora naꞌ bezëꞌë zeyoguëꞌ bedyinnëꞌ z̃an yuꞌu, blëꞌënëꞌ z̃uba z̃iꞌinëꞌ nigula lao belaga, babero bichi be mala yuꞌubiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Naꞌra uzaꞌ Jesús yu nebaba ciudad Tiro, len yu nebaba ciudad Sidón. Udenëꞌ ga reꞌ chi yedyi bdyinnëꞌ ruꞌa lagun Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Lëganꞌ naꞌ ga bdyinnëꞌ, bdyin yaca benꞌ nequiëꞌ tu benꞌ xcuedzo, benꞌ rcaca ruꞌe. Unabayaquëꞌ chi biudëꞌë nëꞌë benꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Naꞌra ubigaꞌ Jesús tzalaꞌla len benꞌ naꞌ, pqui Jesús z̃benëꞌ luꞌu naga benꞌ naꞌ, blëpinëꞌ z̃enꞌ quienëꞌ z̃benëꞌ bdaꞌnëꞌn lao ludyi benꞌ xcuedzo, benꞌ rcaca ruꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Caora naꞌ unëꞌë guibá, uz̃iꞌlaꞌadyiꞌnëꞌ unëꞌ rëbinëꞌ benꞌ naꞌ: ―¡Efata! ―ta inaro diꞌidzaꞌ quiero: ¡Beyalo! ");
INSERT INTO zpcNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Caora naꞌ beyalo naga benꞌ naꞌ barenëꞌ. Lëscanꞌ beyaca ludyinëꞌ benënëꞌ dyëꞌëdi. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Naꞌra bë Jesús mandado yaca benꞌ quiëꞌ ta biyëbiyaquëꞌ canꞌ bënëꞌ quie benꞌ naꞌ. Pero ca bënëꞌ leyaquëꞌ mandado, canaꞌ mazara gudyiyaquëꞌ yaca benëꞌ cabëꞌ bë Jesús quie benꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lega begaꞌnyaquëꞌ bebanyaquëꞌ cabëꞌ ruenëꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Yugulu ta rue Jesús nacan dyaꞌa. Hasta yaca benꞌ xcuedzo, reyuenëꞌ leyaquëꞌ reyeyaquëꞌ, lëscanꞌ hasta yaca benꞌ birnë, reyuenëꞌ leyaquëꞌ renëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Guca dza naꞌ bedupa yaca benꞌ zë ganꞌ zë Jesús. Naꞌ babeya ta nuꞌayaquëꞌ ta gaoyaquëꞌ. Lenaꞌ guz̃i Jesús yaca benꞌ quienëꞌ, unëꞌ rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Bareyëchiꞌlaꞌadyaꞌ yaca benꞌ nitaꞌ niga, danꞌ bazio tzona dza naꞌa nitaꞌlëyaquëꞌ nëꞌëdiꞌ, naꞌ babeya ta nuꞌayaquëꞌ ta gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Chanꞌ yeseꞌelaꞌyaquëꞌ z̃an yuꞌu quieyaquëꞌ binegaoyaquëꞌ, usuꞌunan leyaquëꞌ tu neza, danꞌ balayaquëꞌ uzaꞌyaquëꞌ zituꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Naꞌ una yaca benꞌ quie Jesús rëbiyaquëꞌ lëbëꞌ: ―¿Pero biz̃i huero ta gao yaca benꞌ nitaꞌ niga ga bidyia yuꞌu? ");
INSERT INTO zpcNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Bala yëta xtila nuꞌale? Naꞌ bequëbiyaquëꞌ: ―Gadyin nuꞌandoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Naꞌra bë Jesús mandado ureꞌ yaca benëꞌ layu, uz̃iꞌnëꞌ yëta xtila nuꞌa yaca benꞌ quiëꞌ, blidzëꞌ Diuzi rëbinëꞌ lëbëꞌ: “Xcaleloꞌ.” Naꞌ bz̃uz̃uguëꞌn bëꞌnëꞌn yaca benꞌ quiëꞌ ta udisiyaquëꞌn bëꞌyaquëꞌn yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Lëscanꞌ nuꞌa benꞌ quienëꞌ chopa tzona bela daoꞌ. Naꞌ uz̃iꞌ Jesús lëbaꞌ, blidzëꞌ Diuzi ta bëlaꞌiyanëꞌbaꞌ, bënëꞌ mandado ta udisi yaca benꞌ quienëꞌ leyacabaꞌ, bëꞌyaquëꞌbaꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Naꞌ udaoyaquëꞌ hasta beloyaquëꞌ. Biz̃i tayuz̃o begaꞌn sobre igadyi chicuiti gucan. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Naꞌ yaca benꞌ udao gucayaquëꞌ cadu tapa mila. Naꞌ bë Jesús mandado yedzatzayaquëꞌ zeyoyaquëꞌ z̃an yuꞌu quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Caora naꞌ uyuꞌunëꞌ luꞌu barco lënëꞌ yaca benꞌ quiëꞌ uzaꞌyaquëꞌ zioyaquëꞌ yu nebaba Dalmanuta. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Naꞌra bdyin yaca benꞌ naca partido fariseo ganꞌ zë Jesús, uyuꞌulëyaquëꞌ lëbëꞌ huenë. Naꞌ ta hueyaquëꞌ lëbëꞌ prueba unabayaquëꞌ uluꞌenëꞌ leyaquëꞌ tu yelaꞌ huaca quienëꞌ ladza ta ilëꞌëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Naꞌ uz̃iꞌlaꞌadyiꞌ Jesús unëꞌ gudyinëꞌ leyaquëꞌ: ―¿Bixquienꞌ reꞌen yaca benꞌ nitaꞌ naꞌa ilëꞌëyaquëꞌ huaꞌ tu yelaꞌ huaca quiaꞌ ladza? Tali rniaꞌ leꞌe, bihuaꞌ tu yelaꞌ huaca quiaꞌ ladza ta ilëꞌëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Naꞌ pcaꞌn Jesús yaca benꞌ naca partido fariseo, beyuꞌunëꞌ luꞌu barco lënëꞌ yaca benꞌ quiëꞌ, zioyaquëꞌ itzalaꞌ lagun. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Biz̃i gulaꞌadyiꞌ yaca benꞌ quie Jesús ta nuꞌayaquëꞌ ta gaoyaquëꞌ. Tuzi yëta xtila biꞌayaquëꞌ luꞌu barco naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Huele pensari. Gapale cuidado cabëꞌ naca levadura quie benꞌ naca partido fariseo, len benꞌ naca partido Herodes. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Naꞌ una yaca benꞌ quie Jesús rëbiyaquëꞌ laguedyiyaquëꞌ: ―Danꞌ rdzioguero yëta xtila ta gaoro, lenaꞌ unëꞌ canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pero gucabëꞌ Jesús ca naca pensari quieyaquëꞌ biuyoñeꞌeyaquëꞌ cabëꞌ unëꞌ. Canaꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Bixquienꞌ nale rdzioguele yëta xtila ta gaole? ¿Bixquienꞌ binetzioñeꞌele, nica reyuele pensari? ¿Bixquienꞌ naca zidi luꞌu guicho laxtaꞌole? ");
INSERT INTO zpcNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Quele birlëꞌële dyëꞌëdi cabëꞌ ruaꞌ? ¿Quele birele dyëꞌëdi cabëꞌ rniaꞌ? ¿Quele agulaꞌadyiꞌle? ");
INSERT INTO zpcNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cati bz̃uz̃ugaꞌ gaꞌyoꞌ yëta xtila biaꞌ laze ta gao gaꞌyoꞌ mila beꞌmbyu, ¿bala gaꞌ naga ta yuz̃o begaꞌn? Naꞌ unayaquëꞌ: ―Chipchopa gaꞌ naga. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Lëscanꞌ cati bz̃uz̃ugaꞌ gadyi yëta xtila biaꞌ laze ta gao tapa mila beꞌmbyu, ¿bala chicuiti nadzaꞌ begaꞌn? Naꞌ unayaquëꞌ: ―Gadyi chicuiti. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―¿Binetzuꞌule pensari ca naca yelaꞌ huaca quiaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Naꞌra bdyinyaquëꞌ yedyi Betsaida ga uquiëꞌ yaca benꞌ yedyi naꞌ tu benꞌ laochula ga zë Jesús. Naꞌ unabayaquëꞌ Jesús tu cule ta udëꞌë nëꞌë lao benꞌ laochula. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Naꞌ uz̃e Jesús naꞌa benꞌ laochula uquiëꞌnëꞌ lëbëꞌ ruꞌa yedyila. Tanëro bdaꞌnëꞌ z̃enꞌ lao benꞌ laochula, naꞌtera bdaꞌnëꞌ nëꞌë lao benꞌ naꞌ, unabanëꞌ lëbëꞌ chi barelëꞌënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Naꞌ una benꞌ laochula rëbinëꞌ Jesús: ―Barelëꞌëdaꞌ yaca benëꞌ. Rnaꞌyaquëꞌ ca quie yaca yaga, pero rzaꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Naꞌra bedaꞌ Jesús nëꞌë lao benꞌ laochula tatula. Con canaꞌ benaꞌ benꞌ naꞌ dyëꞌëdi, beyaca laohuëꞌ, belëꞌënëꞌ dyëꞌëdi. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Naꞌ bë Jesús mandado zeyo benꞌ naꞌ z̃an yuꞌu quiëꞌ, unëꞌ rëbinëꞌ lëbëꞌ: ―Bitzataoꞌ laꞌo yedyi. Biyëboꞌ benëꞌ cabëꞌ biaꞌ quioꞌ beyaca laoloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Naꞌ uzaꞌ Jesús ziolënëꞌ yaca benꞌ quiëꞌ yedyi Cesarea de Filipo. Naꞌ du tu neza unaba Jesús rëbinëꞌ leyaquëꞌ: ―¿Cabiz̃i rna yaca benëꞌ nacaꞌ nëꞌëdiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Naꞌ una yaca benꞌ quiëꞌ rëbiyaquëꞌ Jesús: ―Rna balayaquëꞌ nacoꞌ Juan bautista, babebanloꞌ tatula. Ibalayaquëꞌ rnayaquëꞌ nacoꞌ Elías, naꞌ ibalayaquëꞌ rnayaquëꞌ nacoꞌ itu benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi tiempote. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Naꞌ leꞌe, ¿nuz̃i nale nacaꞌ? Naꞌ una Pedro rëbinëꞌ Jesús: ―Luëꞌ nacoꞌ benꞌ Cristo, benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pero bë Jesús mandado ta nitu nunu yëbiyaquëꞌ nu naquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Naꞌra uzulao Jesús rusëdinëꞌ yaca benꞌ quiëꞌ cabëꞌ gaca quienëꞌ yedzagalaotzeguenëꞌ gatinëꞌ dza zazaꞌra. Gudyinëꞌ leyaquëꞌ naquëꞌ bichi yugulu benëꞌ, usebiꞌn yaca benꞌ gula, len yaca xanꞌ pxuzi, len yaca benꞌ rusëdi ley quie Moisés lëbëꞌ. Lëscanꞌ gudyinëꞌ leyaquëꞌ gutiyaquëꞌ lëbëꞌ, pero huebannëꞌ tatula gaca lao tzona dza. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Canaꞌ una Jesús gudyinëꞌ leyaquëꞌ. Naꞌra uquiëꞌ Pedro Jesús tzalaꞌla tu neza uzulaonëꞌ rdilanëꞌ Jesús, danꞌ una Jesús canꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero beyëcho Jesús unëꞌë dyëꞌëdi yaca benꞌ quiëꞌ, udilëꞌ Pedro rëbinëꞌ lëbëꞌ: ―Ubigaꞌ tzalaꞌla Satanás. Biracoꞌ pensari quie Diuzi, racoꞌ pensari quie benëꞌzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Naꞌra guz̃i Jesús yaca benꞌ quiëꞌ len yaca los demás benꞌ nitaꞌ naꞌ, unëꞌ gudyinëꞌ leyaquëꞌ: ―Chi nu yaca benëꞌ reꞌen inao nëꞌëdiꞌ, ruen zi bira inaoyaquëꞌ ca rna pensari quieyaquëꞌ. Ruen zi bidzebiyaquëꞌ inaoyaquëꞌ nëꞌëdiꞌ yugu dza, baꞌalaꞌcazi ruen z̃udyi guti yaca benëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nu benꞌ rdzebi inao nëꞌëdiꞌ, danꞌ rdzebinëꞌ gatinëꞌ tanun quiaꞌ, bihueꞌ Diuzi lëbëꞌ yelaꞌ neban tuzioli. Pero nu benꞌ inao nëꞌëdiꞌ, birdzebinëꞌ gatinëꞌ tanun quiaꞌ len tanun quie xtiꞌidzaꞌ Diuzi, hueꞌ Diuzi lëbëꞌ yelaꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Biz̃i gan de quie nu benꞌ anaca quiëꞌ lao yugulute ta de lao yedyi layu, chi bigataꞌ yelaꞌ neban quienëꞌ tuzioli? ");
INSERT INTO zpcNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ca gacala dumi reꞌennan ta gaꞌo yaca benëꞌ yelaꞌ neban tuzioli? ");
INSERT INTO zpcNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Chi nu benꞌ chuꞌunlaꞌadyiꞌ nëꞌëdiꞌ yedueꞌyaquëꞌ hue quieyaquëꞌ canꞌ rniaꞌ zacaꞌlao lao yaca benꞌ nitaꞌ lao yedyi layu, benꞌ birue quie xtiꞌidzaꞌ Diuzi, benꞌ rue xquia, lëscanꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, huaruꞌunlaꞌadyaꞌ leyaquëꞌ cati yeguidaꞌ inabiꞌa lao yedyi layu ca rey. Zeyuꞌa yelaꞌ huaca quie Xuzaꞌ Diuzi len yaca ángel naca laꞌiya quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Lëscanꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Tali rniaꞌ leꞌe, binegati bala leꞌe nitaꞌ niga len nëꞌëdiꞌ tu binelëꞌële ca naca yelaꞌ rnabëꞌ quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Guca lao xopa dza, uzaꞌ Jesús uquiëꞌnëꞌ Pedro, len Santiago, len Juan zioyaquëꞌ urëyaquëꞌ lao ledaꞌ ga zu tu yaꞌa z̃e. Caora badyiayaquëꞌ laona, naꞌ bazë Jesús zacaꞌlao lao yaca benꞌ quiëꞌ cati betzaꞌ cuinnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Naꞌ guca z̃abanëꞌ tu laꞌariꞌ bezëri di. Ni tu yaca benꞌ rguibi laꞌariꞌ bisaqueꞌyaquëꞌ quibiyaquëꞌ laꞌariꞌ gacan bezëri ca guca z̃abanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Naꞌ blëꞌëyaquëꞌ abdyin Elías len Moisés ruꞌelëyaquëꞌ Jesús diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Naꞌra una Pedro rëbinëꞌ Jesús: ―Maestro, tahuen naꞌ nezëndoꞌ lëndoꞌ luëꞌ niga. Ben lato huendoꞌ tzona yuꞌu daoꞌ de guiz̃i. Huendoꞌ tun quioꞌ, itun quie Moisés, itun quie Elías. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Naꞌ begaꞌn benꞌ quie Jesús rdzebiyaquëꞌ. Pero danꞌ unë Pedro naꞌ, binezinëꞌ bi nëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naꞌra bdyin tu beo bdubin leyaquëꞌ ganꞌ nitaꞌyaquëꞌ. Biz̃i lado beo naꞌ beyaquëꞌ rchiꞌ Diuzi unëꞌ rëbinëꞌ leyaquëꞌ: ―Lëz̃iꞌinaꞌ niga, lega nedyëꞌëdaꞌnëꞌ. Ulezënaga cabëꞌ rnanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Caora naꞌ blëꞌëyaquëꞌ ituzi Jesús zënëꞌ, ganura blëꞌëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Naꞌ cati reyëziyaquëꞌ lëꞌë yaꞌa, bë Jesús mandado nitu nunu yëbiyaquëꞌ cabëꞌ blëꞌëyaquëꞌ hasta quie gatinëꞌ naꞌ yebannëꞌ lëbëꞌ, benꞌ naca bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Quie lenaꞌ nitu nunu gudyiyaquëꞌ cabëꞌ blëꞌëyaquëꞌ ganꞌ, pero bëꞌyaquëꞌ diꞌidzaꞌ entre lëziyaquëꞌ como danꞌ biuyoñeꞌeyaquëꞌ bi na diꞌidzaꞌ quiëꞌ caora unëꞌ gatinëꞌ naꞌ yebannëꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Naꞌ unayaquëꞌ rëbiyaquëꞌ Jesús: ―¿Tabala naꞌ ca ina yaca benꞌ rusëdi ley quie Moisés de que tanëro ruen zi yeguida Elías, naꞌtera guida benꞌ iseꞌelaꞌ Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tabala naꞌ hueguida Elías tanëro ta yecubinëꞌ yugulute. ¿Quele binezile danꞌ rna lëꞌë guichi laꞌiya quie Diuzi cabëꞌ gaca quiaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ? Rnën lëꞌë guichi naꞌ danꞌ yedzagalaohuaꞌ usacaꞌ yaca benëꞌ nëꞌëdiꞌ bizinaquezi. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero rniaꞌ leꞌe, babida benꞌ naca Elías, pero naꞌ psacaꞌyaquëꞌ lëbëꞌ bizinaquezi laga con ca rna lëꞌë guichi laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ude beyudyi naꞌ, zezaꞌyaquëꞌ bdyinyaquëꞌ ga nitaꞌ yaca los demás benꞌ quie Jesús. Naꞌ blëꞌëyaquëꞌ nitaꞌ benꞌ zë ganꞌ. Naꞌ nitaꞌrë yaca benꞌ rusëdi ley quie Moisés uyuꞌuyaquëꞌ huenë len yaca benꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Caora blëꞌëyaquëꞌ Jesús, begaꞌnyaquëꞌ bebanziyaquëꞌ, uyuꞌuyaquëꞌ be, bdyinyaquëꞌ ga zë Jesús, gapayaquëꞌ lëbëꞌ diuz̃i. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Naꞌ una Jesús gudyinëꞌ yaca benꞌ quiëꞌ: ―¿Biz̃i una benꞌ rusëdi ley quie Moisés uyuꞌuyaquëꞌ huenë len leꞌe? ");
INSERT INTO zpcNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Caora naꞌ una tu benꞌ zë gaꞌalaꞌ rëbinëꞌ Jesús: ―Maestro, nequiꞌa tu z̃iꞌinaꞌ byu niga. Yuꞌubiꞌ bichi be mala, biraca inëbiꞌ, biraca yebiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Con gatezi rede yelaꞌ hueꞌ xiꞌibiꞌ daꞌabiꞌ, rguinlëbiꞌ yu. Bëꞌ debiꞌ layu, rulio rulibibiꞌ, rao leibiꞌ, raca bdyinꞌ ruꞌabiꞌ. Danꞌ raca quiebiꞌ canaꞌ, bayëchiꞌ gula raca quiebiꞌ. Aonabaꞌ yaca benꞌ quioꞌ chi biyebioyaquëꞌ bichi be mala yuꞌubiꞌ, pero biuz̃aqueꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Naꞌ una Jesús rëbinëꞌ yaca benꞌ nitaꞌ naꞌ: ―¡Ay, leꞌe benꞌ birale! ¿Bala iza reꞌennan yegaꞌnliaꞌ leꞌe hasta que galele cabëꞌ rniaꞌ? ¿Bala iza reꞌennan suedaꞌ suliaꞌ leꞌe? Uletzexiꞌbiꞌ guidabiꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Naꞌ yexiꞌyaquëꞌbiꞌ. Caora blëꞌë bichi be mala Jesús, bëꞌ naꞌ guca quie biꞌbyu ca z̃uguti. Naꞌ bguꞌumbiꞌ layu, rz̃izibiꞌ, rdulabiꞌ, raca bdyinꞌ ruꞌabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Naꞌ unaba Jesús rëbinëꞌ xuzibiꞌ: ―¿Gaca bazio naꞌ ulëna? Biz̃i unë xuzibiꞌ: ―Nenacatebiꞌ xcuidiꞌ ulëna. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Zë lasa babzalan lëbiꞌ laguiꞌ, babzalan lëbiꞌ luꞌu yao ta udyiaguiꞌn lëbiꞌ, pero birzaqueꞌn. Naꞌ chanꞌ gacoꞌ yeyueloꞌbiꞌ, yeyëchiꞌlaꞌadyoꞌ nëtoꞌ gacalëloꞌ nëtoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Naꞌra una Jesús gudyinëꞌ lëbëꞌ: ―Binaoꞌ chanꞌ gacoꞌ. Chi rzudyiꞌilëloꞌ nëꞌëdiꞌ, huaca hueloꞌ yugulute. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Biz̃i naꞌ unë xuzi xcuidiꞌ naꞌ zidzo rëbinëꞌ Jesús: ―Rzudyiꞌiliaꞌ luëꞌ, gacalaoꞌ nëꞌëdiꞌ ta sudyiꞌiliaꞌ luëꞌ mazara. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Caora blëꞌë Jesús bdupa yaca benꞌ zë ga zënëꞌ, naꞌ udilanëꞌ bichi be mala unëꞌ rëbinëꞌn: ―Dyin quioꞌ bire birnë biꞌ niga. Rniaꞌ luëꞌ, bero ganꞌ yuꞌuloꞌ naꞌ, bira huelaoꞌbiꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Naꞌ uredyiyaꞌ bichi be mala pxizin biꞌbyu tatula, begaꞌmbiꞌ debiꞌ ca benꞌ huati. Lenaꞌ una yaca benꞌ nitaꞌ naꞌ: ―Bagutibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naꞌra bëxo Jesús naꞌabiꞌ ta bechisanëꞌbiꞌ, bezubiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ude beyudyi naꞌ, caora uyuꞌu Jesús lënëꞌ yaca benꞌ quiëꞌ luꞌu yuꞌu, naꞌ unayaquëꞌ rëbiyaquëꞌ Jesús: ―¿Bixquienꞌ biuz̃aqueꞌndoꞌ yebiondoꞌ bichi be mala? ");
INSERT INTO zpcNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Ca naca bichi be mala bebiogaꞌ, chi bihueꞌlële Diuzi diꞌidzaꞌ, chi bihuele ubasi, biyerona. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Naꞌ bezaꞌ Jesús lënëꞌ yaca benꞌ quiëꞌ zioyaquëꞌ yedeyaquëꞌ estado Galilea. Naꞌ biguꞌun Jesús inezi yaca benëꞌ yedeyaquëꞌ ganꞌ naꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","danꞌ ruzioñeꞌenëꞌ yaca benꞌ quienëꞌ, gudyinëꞌ leyaquëꞌ cabëꞌ gaca quiëꞌ, benꞌ naca bichi yugulu benëꞌ. Naꞌra gudyinëꞌ leyaquëꞌ usedyin yaca benëꞌ lëbëꞌ lao naꞌa benꞌ rnabëꞌ ta gutiyaquëꞌ lëbëꞌ, pero gaca lao tzona dza huebannëꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero biuyoñeꞌe yaca benꞌ quiëꞌ canꞌ unëꞌ gudyinëꞌ leyaquëꞌ. Naꞌ bibeyaz̃oyaquëꞌ inabayaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Biz̃i bdyin Jesús lënëꞌ yaca benꞌ quiëꞌ ciudad Capernaum tatula, beyuꞌuyaquëꞌ luꞌu yuꞌu ganꞌ uzaꞌyaquëꞌ. Naꞌ una Jesús rëbinëꞌ yaca benꞌ quiëꞌ: ―¿Biz̃i diꞌidzaꞌ ruꞌelële laguedyile danꞌ zezaꞌle huenë cati zezaꞌro tu neza? ");
INSERT INTO zpcNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero bibequëbiyaquëꞌ begaꞌnyaquëꞌ chizi danꞌ zezaꞌyaquëꞌ rnëyaquëꞌ tu neza quie nula leyaquëꞌ nacara benꞌ belao. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Naꞌ ureꞌ Jesús gudyinëꞌ yaca chipchopa benꞌ quienëꞌ ta ibigaꞌyaquëꞌ ganꞌ reꞌnëꞌ. Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Nu leꞌe reꞌen gaca benꞌ belaora entre leꞌe, ruen zi gaquëꞌ benꞌ zenaote quie leꞌe, benꞌ gacalë laguedyi. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Naꞌra guz̃i Jesús tu xcuidiꞌ bzunëꞌbiꞌ gatzo laꞌo ganꞌ nitaꞌyaquëꞌ. Te naꞌ uz̃iꞌnëꞌbiꞌ bdyianëꞌbiꞌ laz̃ibinëꞌ unëꞌ gudyinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nu benꞌ rziꞌ tu xcuidiꞌ ca biꞌ niga lao laohuaꞌ nëꞌëdiꞌ, rziꞌrënëꞌ nëꞌëdiꞌ. Naꞌ tu benꞌ rziꞌ nëꞌëdiꞌ, quele tuzaꞌ nëꞌëdiꞌ rziꞌnëꞌ, lëscanꞌ rziꞌrënëꞌ benꞌ pseꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Naꞌra una Juan rëbinëꞌ Jesús: ―Maestro, bablëꞌëndoꞌ rda tu benëꞌ rzëtoguëꞌ rnanëꞌ laoloꞌ rebioguëꞌ bichi be mala yuꞌu benëꞌ. Naꞌra gudyindoꞌnëꞌ bira huenëꞌn danꞌ binaquëꞌ tu cueꞌ quiero. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero una Jesús rëbinëꞌ leyaquëꞌ: ―Gabi yëbile nu benꞌ rue canaꞌ, como danꞌ chi nu yaca benëꞌ rueyaquëꞌ yelaꞌ huaca rzëtoyaquëꞌ laohuaꞌ, quele condre nëꞌëdiꞌ rnëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nu benꞌ birue condre raꞌo, nacacazi quieyaquëꞌ ca quie benꞌ rnëcule raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nutezi benꞌ gun leꞌe bi cosa siquiera tu vaso nisa nun quie nacale benꞌ quiaꞌ, huaguiz̃ucazi Diuzi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Nutezi benꞌ rudzeꞌyela tu xcuidiꞌ rale quiaꞌ ta huebiꞌ xquia, hue Diuzi lëbëꞌ castigo huala gula. Tadyaꞌacala quienëꞌ irio tu yo z̃e len du lubaꞌnëꞌ tzechuꞌun yaca benëꞌ lëbëꞌ luꞌu yao z̃e, quele ca castigo hue Diuzi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chi rnën leꞌe huelële naꞌale tamala, nacaran dyaꞌa ichugulen tziole guibá ca benꞌ nedyipa nëꞌë, quele ca zu rupa naꞌale tziole guiꞌ gabila ga bireyulan, ");
INSERT INTO zpcNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ga gao bëla benëꞌ tuzioli, bireyula guiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Lëscanꞌ chi rnën leꞌe huelële niꞌale tamala, nacaran dyaꞌa ichugurëlen tziole guibá ca benꞌ nedyipa niꞌe, quele ca zu rupa niꞌale tziole guiꞌ gabila bireyulan, ");
INSERT INTO zpcNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ga gao bëla benëꞌ tuzioli, bireyula guiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Lëscanꞌ chi rnën leꞌe huelële laole tamala, nacaran dyaꞌa cuiolen tziole guibá ca benꞌ nero yolaohue, quele ca ta tziole guiꞌ gabila len rupa laꞌa yolaole, ");
INSERT INTO zpcNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ga gao bëla benëꞌ tuzioli, bireyula guiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Cabëꞌ rudzeꞌ benëꞌ zediꞌ luꞌu bëꞌëlaꞌ, canaꞌ udzeꞌ Diuzi guiꞌ luꞌu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","De ga hue zediꞌ dyin, pero chanꞌ aodyiaguiꞌn, bira huen dyin, ¿biz̃i huero ta iyacan huen dyin tatula? Quie lenaꞌ bigacale ca benꞌ aodyiaguiꞌ, benꞌ birue dyin, mejorla nitaꞌlële laguedyile dyëꞌëdi, bitilale. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Naꞌra uzaꞌ Jesús lënëꞌ yaca benꞌ quiëꞌ ciudad Capernaum zioyaquëꞌ estado Judea, lëscanꞌ zioyaquëꞌ tzalaꞌla yao Jordán. Con ga zioyaquëꞌ redupa yaca benëꞌ ganꞌ zë Jesús. Naꞌ ca modo quie Jesús, bezulaonëꞌ rusëdinëꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Biz̃i naꞌ bdyin chopa tzona benꞌ naca partido fariseo ganꞌ naꞌ ta hueyaquëꞌ trampa quie Jesús iguinonëꞌ lao diꞌidzaꞌ quienëꞌ. Quie lenaꞌ unabayaquëꞌ lëbëꞌ chi ruꞌen lato usan yaca benëꞌ nigula quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Naꞌ una Jesús bequëbinëꞌ leyaquëꞌ: ―¿Bi na lëꞌë guichi bë Moisés? ");
INSERT INTO zpcNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Naꞌ unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Bëꞌ Moisés lato hue yaca benëꞌ tu guichi ta usanyaquëꞌ nigula quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Yelaꞌ zidi quie yaca benëꞌ bëꞌ Moisés lato usanyaquëꞌ nigula quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero binacan canaꞌ dza naꞌ caora ulëchi Diuzi dyilayu udixonëꞌ yugulu ta de. “Lëdza naꞌ bzaloguëꞌ chopa benëꞌ, tu beꞌmbyu len tu nigula.” ");
INSERT INTO zpcNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Quie lenaꞌ rsan yaca beꞌmbyu xuzi z̃nëꞌë ta rzulënëꞌ nigula quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Canaꞌ naca quieyaquëꞌ ca quie tuzi benëꞌ. Bira nacayaquëꞌ chopa, dechanꞌ nacayaquëꞌ ca quie tuzi benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Quie lenaꞌ bireyaꞌalaꞌ usan yaca benëꞌ laguedyiyaquëꞌ como danꞌ bë Diuzi gacayaquëꞌ tuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Biz̃i caora bedyin Jesús lënëꞌ yaca benꞌ quiëꞌ luꞌu yuꞌu, naꞌ unabarayaquëꞌ Jesús quie benꞌ rsan laguedyi. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Naꞌ una Jesús: ―Nu benꞌ rsan nigula quie, naꞌ rzulënëꞌ nigula tula, nacan xquia quienëꞌ lao Diuzi, bënëꞌ yelaꞌ stuꞌ quie nigula quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Lëscanꞌ chi rsan nigula beꞌmbyu quienëꞌ, naꞌ rzulënëꞌ beꞌmbyu tula, nacan xquia quienëꞌ lao Diuzi, bënëꞌ yelaꞌ stuꞌ quie beꞌmbyu quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Naꞌra bdyin yaca benëꞌ ganꞌ zë Jesús nequiëꞌyaquëꞌ z̃iꞌiyaquëꞌ ta udaꞌnëꞌ nëꞌë guichoyacabiꞌ huelaꞌiyanëꞌ leyacabiꞌ. Pero udila yaca benꞌ quie Jesús yaca benꞌ nequiëꞌ z̃iꞌine. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Caora blëꞌë Jesús udila yaca benꞌ quiëꞌ leyaquëꞌ, naꞌ bdzaꞌnëꞌ unëꞌ rëbinëꞌ yaca benꞌ quiëꞌ: ―Biudzunle yaca xcuidiꞌ. Guidagarayacabiꞌ ni como danꞌ ca naca quieyacabiꞌ, rue quieyacabiꞌ ca rna xuziyacabiꞌ, lëcanaꞌ nacarën quie benꞌ zio rue quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tali rniaꞌ leꞌe, chi nu yaca benꞌ birue quieyaquëꞌ xtiꞌidzaꞌ Diuzi ca rue xcuidiꞌ quie xuzibiꞌ, bisaqueꞌ yeyoyaquëꞌ guibá ganꞌ zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Naꞌ bdyia Jesús tu huio xcuidiꞌ laz̃ibinëꞌ bdëꞌë nëꞌë guichoyacabiꞌ bëlaꞌiyanëꞌ yuguluyacabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Naꞌra caora beyuꞌu Jesús neza azeyolënëꞌ yaca benꞌ quiëꞌ, naꞌ bdyin tu benꞌ uyuꞌu be, uditzu z̃ibinëꞌ lao Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―Maestro, benꞌ huen nacoꞌ. Nainaoꞌ, ¿ca biz̃i reyaꞌalaꞌ huaꞌ ta gataꞌ yelaꞌ neban quiaꞌ tuzioli? ");
INSERT INTO zpcNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Naꞌ una Jesús: ―¿Bixquienꞌ naoꞌ nacaꞌ benꞌ huen? Tahuencazi naoꞌ canaꞌ, como tuzi Diuzi naquëꞌ benꞌ huen. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Luëꞌ baneziloꞌ ca rna lëꞌë guichi laꞌiya quie Diuzi: “Biutiloꞌ nigula quie benꞌ tula. Bigutioꞌ benëꞌ. Bicuanloꞌ quie benëꞌ. Bisiuꞌ benëꞌ yëꞌ. Udapalaꞌn xuzoꞌ len z̃naoꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Naꞌra unë benꞌ naꞌ rëbinëꞌ Jesús: ―Yugulu ca rnaoꞌ, rue quiecazaꞌn zaꞌcazaꞌ naohuaꞌn desde nacatiaꞌ xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Caora naꞌ unaꞌ Jesús laohuëꞌ nedyëꞌënëꞌ lëbëꞌ, unëꞌ rëbinëꞌ lëbëꞌ: ―De tu ta nerdziogueloꞌ hueloꞌ. Bëtiꞌ yugulu ta de quioꞌ, naꞌ uz̃iꞌ dumi naꞌ, bëꞌ yaca benꞌ yëchiꞌ len. Canaꞌ gunra Diuzi taz̃era quioꞌ bëꞌ yedyinloꞌ guibá. Naꞌ uda unao nëꞌëdiꞌ gacoꞌ benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero cati be benꞌ naꞌ canꞌ una Jesús, naꞌ begaꞌnnëꞌ guquenëꞌ beyëchiꞌ gula, como danꞌ naquëꞌ benꞌ uñaꞌa huala gula. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Naꞌ unaꞌ Jesús yaca benꞌ quiëꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Zëdi gula nacan quie benꞌ uñaꞌa ta yeyoyaquëꞌ guibá ganꞌ zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Naꞌra bebanzi yaca benꞌ quie Jesús cabëꞌ unëꞌ quie benꞌ uñaꞌa. Pero tatula unëꞌ rëbinëꞌ leyaquëꞌ: ―Bichaꞌ, zëdi gula nacan ta yeyo ga zu Diuzi yaca benꞌ rzudyiꞌilë dumi quieyaquëꞌ ta gacalën leyaquëꞌ yeyoyaquëꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nacaran yalo te tu camello naga yëchiꞌ, quele ca ta tzuꞌu benꞌ uñaꞌa guibá ganꞌ zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Naꞌ bebanzi yaca benꞌ quie Jesús unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Chi nacan zëdi gula quie benꞌ uñaꞌa, ¿nuz̃i saqueꞌ yeyo guibá ganꞌ zu Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Naꞌ unaꞌ Jesús leyaquëꞌ unëꞌ: ―Tu ta bisaqueꞌ hue yaca benëꞌ, Diuzi sí, huazaqueꞌnëꞌ huenëꞌn, como danꞌ raca Diuzi ruenëꞌ yugulute. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Naꞌ una Pedro rëbinëꞌ Jesús: ―Señor, nëtoꞌ bapcaꞌnndoꞌ yugulu ta de quiendoꞌ cuenda zaꞌndoꞌ naondoꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Nacan tali canꞌ rniaꞌ leꞌe. Con nutiꞌtezi benꞌ pcaꞌn nu yuꞌu quieyaquëꞌ, nu bichi, nu zane, nu xuzi, nu z̃nëꞌë, nu z̃gule, nu z̃iꞌine, nu layela quie, nun quie naoyaquëꞌ nëꞌëdiꞌ rue quieyaquëꞌ xtiꞌidzaꞌ Diuzi, ");
INSERT INTO zpcNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hueyuꞌera Diuzi tu gayuhua mazara quieyaquëꞌ dza rdayaquëꞌ lao yedyi layu. Hueyuꞌera Diuzi quieyaquëꞌ nu yuꞌu, nu bichi, nu zane, nu z̃nëꞌë, nu z̃iꞌine, nu layela quie, baꞌalaꞌcazi rue yaca benëꞌ lëyaquëꞌ bizinaquezi. Lëscanꞌ hueꞌ Diuzi lëyaquëꞌ yelaꞌ neban tuzioli bëꞌ bayedyinyaquëꞌ guibá ganꞌ zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero bala benꞌ naca benꞌ belao niga lao yedyi layu, bira gacayaquëꞌ benꞌ belao dza yedyinyaquëꞌ ga zu Diuzi. Lëscanꞌ bala benꞌ binaca benꞌ belao niga lao yedyi layu, huacayaquëꞌ benꞌ belao dza yedyinyaquëꞌ ga zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Naꞌ bëꞌ bezaꞌ Jesús lënëꞌ yaca benꞌ quiëꞌ, zeyuꞌuyaquëꞌ neza ta yedyinyaquëꞌ ciudad Jerusalén. Naꞌ udyialao Jesús lao yaca benꞌ quiëꞌ. Naꞌ tu bebanzi yaca benꞌ quiëꞌ birdzebi Jesús tzionëꞌ ciudad Jerusalén. Naꞌ unao yaca benꞌ quienëꞌ lëbëꞌ du rdzebiyaquëꞌ bi gaca quieyaquëꞌ. Naꞌ guz̃i Jesús leyaquëꞌ ta tzez̃eyaquëꞌ lëbëꞌ gudyinëꞌ leyaquëꞌ bi gaca quienëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Ulezëcara nagale. Tzioro Jerusalén ga usacaꞌ yaca benëꞌ nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ, tamala. Usedyinyaquëꞌ nëꞌëdiꞌ lao naꞌa yaca xanꞌ pxuzi len yaca benꞌ rusëdi ley quie Moisés. Huachugubëꞌyaquëꞌ quiaꞌ inayaquëꞌ reyaꞌalaꞌ gatiaꞌ. Naꞌ usedyinyaquëꞌ nëꞌëdiꞌ lao naꞌa yaca benꞌ uzaꞌ yedyi tula. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Naꞌ utitu yaca benꞌ uzaꞌ yedyi tula nëꞌëdiꞌ. Hueyaquëꞌ nëꞌëdiꞌ ziꞌ, udaꞌyaquëꞌ z̃enꞌ laohuaꞌ, gutiyaquëꞌ nëꞌëdiꞌ. Pero bëꞌ gaca lao tzona dza, huebanaꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naꞌra Santiago len Juan, benꞌ z̃iꞌi Zebedeo, ubigaꞌyaquëꞌ ga zë Jesús unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Maestro, reꞌenndoꞌ gunloꞌ ca ta inabandoꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Biz̃i reꞌenle gunaꞌ leꞌe? ");
INSERT INTO zpcNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Naꞌ unayaquëꞌ rëbiyaquëꞌ Jesús: ―Reꞌenndoꞌ gunoꞌ lato ta cueꞌndoꞌ tzalaꞌ huio cuëtalaoꞌ ga tzereꞌloꞌ inabëꞌloꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Binezile cabiz̃i inabale gunaꞌ. ¿Huazuele sacale cabëꞌ usaca benëꞌ nëꞌëdiꞌ? ¿Huazuele yedzagalaole cabëꞌ yedzagalaohuaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Naꞌ bequëbiyaquëꞌ rëbiyaquëꞌ Jesús: ―Huazuendoꞌ. Naꞌ biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Tali naꞌ ca nale. Usacacazi benëꞌ leꞌe cabëꞌ usacayaquëꞌ nëꞌëdiꞌ, lëscanꞌ yedzagalaocazile cabëꞌ yedzagalaohuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero bisaqueꞌ gunaꞌ leꞌe lato cueꞌle tzalaꞌ huio cuëtaꞌ ga tzeriꞌa como danꞌ binaca parte quiaꞌ gunaꞌ leꞌe lato cueꞌle cuëtaꞌ. Naca parte quie Diuzi hueꞌnëꞌ lato nu benꞌ cueꞌ cuëtaꞌ lëꞌënaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Naꞌra cati unezi yaca los demás benꞌ quie Jesús cabëꞌ unaba Santiago len Juan hueꞌnëꞌ quieyaquëꞌ, naꞌ bdzaꞌyaquëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero guz̃i Jesús leyaquëꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Leꞌe nezile dyëꞌëdi cabëꞌ rue yaca benꞌ naca gobierno, rnabëꞌyaquëꞌ ziꞌlaza. Lega rueyaquëꞌ mandado zëdi ta rue yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero leꞌe bireyaꞌalaꞌ huele canaꞌ. Nu leꞌe reꞌen gaca benꞌ z̃e entre leꞌe, reyaꞌalaꞌ gaquëꞌ benꞌ gaxo, benꞌ gacalë laguedyi. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nu leꞌe reꞌen gaca benꞌ belao entre leꞌe, reyaꞌalaꞌ gaquëꞌ ca quie mozo quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hasta nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ, quele bidaꞌ ta gaca yaca benëꞌ ca yaca mozo quiaꞌ, bidaꞌ ta gacaꞌ ca quie mozo quieyaquëꞌ. Lëscanꞌ bidaꞌ ta gatiaꞌ quiz̃ugaꞌ quie xquia quieyaquëꞌ cuenda gataꞌ yelaꞌ neban quieyaquëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Naꞌ bdyin Jesús lënëꞌ yaca benꞌ quiëꞌ yedyi Jericó. Caora udeyaquëꞌ yedyi, naꞌ bazëyaquëꞌ ruꞌa yedyi, caora naꞌ bdupa yaca benꞌ zë ganꞌ zënëꞌ. Biz̃i cuëta neza ureꞌ tu benꞌ laochula, benꞌ lao Bartimeo. Naquëꞌ z̃iꞌi Timeo, ureꞌnëꞌ tu neza rnabëꞌ caridad. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Naꞌra caora benëꞌ bazaꞌ Jesús, benꞌ yedyi Nazaret, uzulaonëꞌ rnënëꞌ zidzo rëbinëꞌ Jesús: ―¡Jesús, z̃iꞌi suba rey David, yeyëchiꞌlaꞌadyoꞌ nëꞌediꞌ! ");
INSERT INTO zpcNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Naꞌ udila yaca benëꞌ lëbëꞌ gudyiyaquëꞌ ta cueꞌnëꞌ chizi, pero unërëꞌ zidzora uredyiyaꞌnëꞌ: ―Z̃iꞌi suba rey David, yeyëchiꞌlaꞌadyoꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Naꞌ biz̃i uleza Jesús unëꞌ rëbinëꞌ yaca benꞌ nitaꞌ naꞌ: ―Uleyëbi benꞌ naꞌ guidëꞌ ni. Naꞌ uyoyaquëꞌ yexiꞌyaquëꞌ lëbëꞌ gudyiyaquëꞌ lëbëꞌ: ―Bidzeboꞌ, uzuli, yaꞌ, como danꞌ rëz̃i Jesús luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Naꞌ ulëchonëꞌ gabán quienëꞌ, laozulitenëꞌ zionëꞌ ga zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―¿Biz̃i reꞌenloꞌ huaꞌ quioꞌ? Naꞌ una benꞌ laochula: ―Maestro, reꞌendaꞌ yeyueloꞌ laohuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Danꞌ rzudyiꞌilëloꞌ nëꞌëdiꞌ, quie lenaꞌ babeyaca laoloꞌ. Baoca, yeyo. Biz̃i caora una Jesús canaꞌ, beyaca laohuëꞌ belëꞌënëꞌ, ziolënëꞌ Jesús tu neza. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Naꞌra bdyinyaquëꞌ ga zu tu yaꞌa laonan yaꞌa Olivos. Baruen bago ta idyinyaquëꞌ ciudad Jerusalén. Lëscanꞌ banacaten gaꞌalaꞌ len yedyi Betfagé len yedyi Betania. Naꞌ useꞌelaꞌ Jesús chopa benꞌ quiëꞌ ");
INSERT INTO zpcNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","unëꞌ rëbinëꞌyaquëꞌ: ―Uletzio yedyi reꞌ niꞌ. Bëꞌ zaidyinle ruꞌa yedyi, huadzelele tu burra daoꞌ neriobaꞌ nunu necuia lëbaꞌ. Naꞌ ixëdyilebaꞌ yequiëꞌlebaꞌ nila. Yeyudyi uhuenaꞌbaꞌ dyin, natzesanlebaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Chi inaba yaca benëꞌ leꞌe bixquienꞌ rexëdyilebaꞌ, naꞌ yëbileyaquëꞌ: Reꞌen xaꞌnndoꞌ lëbaꞌ. Bëꞌ yeyudyi uhuenëꞌbaꞌ dyin, canaꞌ idesanndoꞌbaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Naꞌ uzaꞌyaquëꞌ bdyinyaquëꞌ tu neza ganꞌ zë burra daoꞌ neriobaꞌ cuëta ruꞌa yuꞌu. Naꞌ pxëdyiyaquëꞌbaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Biz̃i naꞌ unë yaca benꞌ nitaꞌ bago unayaquëꞌ rëbiyaquëꞌ benꞌ quie Jesús: ―¿Bixquienꞌ rxëdyile burra daoꞌ naꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Naꞌra bequëbiyaquëꞌ gudyiyaquëꞌ yaca benꞌ nitaꞌ naꞌ cabëꞌ gudyi Jesús leyaquëꞌ. Naꞌra psan yaca benëꞌ leyaquëꞌ yequiëꞌyaquëꞌ burra daoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Naꞌ zezaꞌyaquëꞌ bedyinlëyaquëꞌ ga zë Jesús. Ulëchoyaquëꞌ gabán quieyaquëꞌ uxubayaquëꞌn xcuꞌudzu burra daoꞌ, udyia Jesús lëbaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Naꞌ uzaꞌyaquëꞌ zioyaquëꞌ udixu yaca benëꞌ gabán quieyaquëꞌ tu neza ta gapalaꞌnyaquëꞌ lëbëꞌ. Lëscanꞌ uchugo yaca benëꞌ bena yaga dyia laꞌagaꞌ udixuyaquëꞌn tu neza ganꞌ te Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Naꞌ yaca benꞌ zenao lëbëꞌ tu neza len yaca benꞌ udyialao lao len lëbëꞌ, uzulaoyaquëꞌ rbedyiyaꞌyaquëꞌ unayaquëꞌ: ―¡Naca Xuziro Diuzi benꞌ z̃e! ¡Benꞌ laꞌiya nacoꞌ, bidoꞌ tanun quie Diuzi! ");
INSERT INTO zpcNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Laꞌiya naca xlatoꞌ ta zezaꞌra lao xlato xuzixtaꞌoro rey David! ¡Naca Xuziro benꞌ z̃e! ");
INSERT INTO zpcNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Canaꞌ bdyin Jesús ciudad Jerusalén, uyuꞌunëꞌ luꞌu idaoꞌ rnabëꞌra zu naꞌ. Te beyudyi unaꞌnëꞌ duz̃e cabëꞌ naca naꞌ, naꞌ zezaꞌlënëꞌ lao chipchopa benꞌ quienëꞌ zioyaquëꞌ yedyi Betania danꞌ bazaꞌ rdzeꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Naꞌ beteyu zila, bezaꞌnëꞌ Betania ziolënëꞌ yaca benꞌ quiëꞌ cati uduenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Naꞌ blëꞌë Jesús zituꞌ zu tu yaga higo badyian laꞌagaꞌ. Naꞌ uyoguëꞌ ta inëꞌë chi bidyian taz̃ixi. Pero bibi taz̃ixi dyian, puro laꞌagaꞌ dyian danꞌ quele tiempo quien. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Naꞌ unë Jesús gudyinëꞌ yaga: ―Desde naꞌa bira cuialoꞌ taz̃ixi ta gao yaca benëꞌ. Biz̃i naꞌ be yaca benꞌ quiëꞌ cabëꞌ unëꞌ rëbinëꞌ yaga. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Naꞌra bedyinyaquëꞌ ciudad Jerusalén, uyo Jesús tatula ruꞌa idaoꞌ rnabëꞌra, blaohuëꞌ yaca benꞌ yuꞌu huëtiꞌ ganꞌ. Bzalanëꞌ layu mesa quie yaca benꞌ rutzaꞌ dumi. Bzalanëꞌ silla que yaca benꞌ rutiꞌ biu. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Bibëꞌ Jesús lato ta te yaca benëꞌ len yuaꞌ quieyaquëꞌ ruꞌa idaoꞌ rnabëꞌra naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Naꞌ una Jesús rëbinëꞌ yaca benꞌ yuꞌu huëtiꞌ: ―Lëꞌë guichi laꞌiya quie Diuzi rnan cani: “Luꞌu idaoꞌ rnabëꞌra ni nacan ga ulidza benꞌ quie yugulu nación Diuzi.” Pero leꞌe aptzaꞌlen ruelen ca quie beló ga yuꞌu benꞌ uban. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Naꞌ yeguedyi yaca benëꞌ yaca xanꞌ xuzi len yaca benꞌ rusëdi ley quie Moisés cabëꞌ bë Jesús quie yaca benꞌ yuꞌu huëtiꞌ ruꞌa idaoꞌ rnabëꞌra. Naꞌ uzulaoyaquëꞌ reguilolaꞌadyiꞌyaquëꞌ bi hueyaquëꞌ ta gutiyaquëꞌ Jesús, danꞌ rdzebiyaquëꞌ lëbëꞌ nun quie raxe yaca benëꞌ ca na Jesús rusëdinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Naꞌ baoyaꞌ dza, zezaꞌ Jesús ziolënëꞌ yaca benꞌ quiëꞌ zeyoyaquëꞌ Betania. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Caora uyeniꞌ dza tula, bezaꞌyaquëꞌ uyuꞌuyaquëꞌ neza blëꞌëyaquëꞌ aobidyi yaga higo lente lue quien. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Naꞌ bezaꞌlaꞌadyiꞌ Pedro cabëꞌ una Jesús quie yaga higo, naꞌ unëꞌ rëbinëꞌ Jesús: ―Maestro, unaꞌcara, aobidyi yaga higo bdzeꞌdeꞌloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Sudyiꞌilële Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tali rniaꞌ leꞌe, con nutezi benꞌ yëbi yaꞌa niga: “Beyo, yeyuꞌu luꞌu nisadaoꞌ”, naꞌ chi du guicho du laꞌadyiꞌyaquëꞌ rzudyiꞌilëyaquëꞌ Diuzi, huenëꞌ ca yëbiyaquëꞌ yaꞌa, naꞌra huaca quie yaꞌa ca yëbiyaquëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Quie lenaꞌ rniaꞌ leꞌe, cati hueꞌlële Diuzi diꞌidzaꞌ ta inabalenëꞌ bi cosa, chi rzudyiꞌilële Diuzi du guicho du laꞌadyiꞌle gun Diuzi ca ta inabalenëꞌ, naꞌra guncazinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Lëscanꞌ cati hueꞌlële Diuzi diꞌidzaꞌ, chi nede tu tamala bë yaca benëꞌ quiele, yeziꞌz̃ele quieyaquëꞌ. Canaꞌ hueziꞌz̃erë Xuziro Diuzi zu guibá dulaꞌ xquia quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero chi biyeziꞌz̃ele quieyaquëꞌ, lëscanꞌ biyeziꞌz̃e Xuziro Diuzi zu guibá dulaꞌ xquia quiele. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Naꞌra bezaꞌyaquëꞌ zioyaquëꞌ bedyinyaquëꞌ ciudad Jerusalén tatula. Naꞌ caora uyuꞌu Jesús luꞌu idaoꞌ rnabëꞌra rdanëꞌ naꞌ, caora naꞌ bdyin yaca xanꞌ pxuzi len yaca benꞌ rusëdi ley quie Moisés ga rdëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Naꞌ unayaquëꞌ rëbiyaquëꞌ Jesús: ―Una nëtoꞌ, ¿nu ben yelaꞌ rnabëꞌ quioꞌ, danꞌ bablaoloꞌ benꞌ yuꞌu huëtiꞌ luꞌu idaoꞌ rnabëꞌra? ");
INSERT INTO zpcNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Naꞌ una Jesús gudyinëꞌ leyaquëꞌ: ―Lëscanꞌ reꞌendaꞌ inabaꞌ leꞌe tu diꞌidzaꞌ. Chi yequëbile ta inabaꞌ leꞌe, naꞌ iniaꞌ leꞌe nu ben yelaꞌ rnabëꞌ quiaꞌ danꞌ biaꞌ canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Naꞌ inabaꞌ leꞌe: ¿Nuz̃i useꞌelaꞌ Juan ta bëꞌnëꞌ lao yaca benëꞌ? ¿Useꞌelaꞌ Diuzi lëbëꞌ o ta racazi laꞌadyiꞌnëꞌ bidëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Naꞌra uzulaoyaquëꞌ rtzaloyaquëꞌ ruꞌelëyaquëꞌ laguedyiyaquëꞌ diꞌidzaꞌ nayaquëꞌ: ―¿Cabiz̃i yëbironëꞌ? Chanꞌ yëbironëꞌ: “Diuzi useꞌelëꞌ lëbëꞌ”, tanaꞌ huanëꞌ raꞌo: “¿Bixquienꞌ bigulele quienëꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero bisaqueꞌ yëbironëꞌ: “Ta racazi laꞌadyiꞌnëꞌ bidëꞌ.” Naꞌ bdzebiyaquëꞌ yëbiyaquëꞌ Jesús canꞌ, como danꞌ neziyaquëꞌ huadzaꞌ yaca benëꞌ leyaquëꞌ nun quie rna yaca benëꞌ naca Juan benꞌ useꞌelaꞌ Diuzi, benꞌ rguixogueꞌ xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Quie lenaꞌ unayaquëꞌ rëbiyaquëꞌ Jesús: ―Binezindoꞌ. Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Lëscanꞌ nëꞌëdiꞌ, biiniaꞌ leꞌe nu ben yelaꞌ rnabëꞌ quiaꞌ, danꞌ bablaohuaꞌ benꞌ yuꞌu huëtiꞌ luꞌu idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Naꞌra una Jesús diꞌidzaꞌ ni rëbinëꞌ benëꞌ: ―Uzu tu benꞌ guza bedzuliꞌ layela quienëꞌ. Lëscanꞌ psioguëꞌn ulëchinëꞌn corale, udixunëꞌ tu yo lagaꞌ ga usinëꞌ nisa bedzuliꞌ. Lëscanꞌ bënëꞌ tu yuꞌu de yo ga cuia benëꞌ ta gapayaquëꞌ bedzuliꞌ quienëꞌ. ’Naꞌra bëꞌnëꞌn lao naꞌa yaca benëꞌ naca ladyinëꞌë, uzaꞌnëꞌ zioguëꞌ zituꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Biz̃i cati bdyin biuꞌ quie usecho quie bedzuliꞌ, naꞌ beseꞌelaꞌ xanꞌ layela tu benꞌ zu laohuëꞌ ta tzenabanëꞌ tu ta reduꞌulanëꞌ siꞌnëꞌ quie bedzuliꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero belaꞌcala bëꞌyaquëꞌ ziꞌ benꞌ useꞌelaꞌ xaꞌnyaquëꞌ. Naꞌ bezaꞌnëꞌ gabi zeyuꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Naꞌra beseꞌelaꞌ benꞌ xanꞌ layela benꞌ tula zioguëꞌ. Pero lagazi udiyaquëꞌ lëbëꞌ yo, bëꞌyaquëꞌ guicho benꞌ naꞌ ziꞌ, ptasi bnioyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Naꞌ biz̃i beseꞌelaꞌ xanꞌ layela benꞌ tula zioguëꞌ, pero bëtiyaquëꞌ lënëꞌ. Te naꞌ beseꞌelaꞌ xanꞌ layela benꞌ zë, uyo tu huio tu huioyaquëꞌ. Con bala benꞌ useꞌelaꞌ xanꞌ layela bëꞌyaquëꞌ ziꞌ, ibalayaquëꞌ bëtiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Biz̃i ga beyudyicala uzu tu z̃iꞌi xanꞌ layela, lega nedyëꞌënëꞌ lëbëꞌ. Naꞌ useꞌelëꞌ z̃iꞌinëꞌ unëꞌ: “Decazide gapalaꞌnyaquëꞌ z̃iꞌinaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero bëꞌ blëꞌë yaca benꞌ naca ladyinëꞌë layela babdyin z̃iꞌi xaꞌnyaquëꞌ, naꞌra unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: “Biꞌ niga, gaca quiebiꞌ layu niga cati bagati xuzibiꞌ. Uletzaꞌ gutirobiꞌ cuenda siꞌro layu niga gacan quiero.” ");
INSERT INTO zpcNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Naꞌ bëxoyaquëꞌbiꞌ bëtiyaquëꞌbiꞌ, ulioyaquëꞌbiꞌ ganꞌ de layela. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Naꞌra unaba Jesús yaca benëꞌ nitaꞌ naꞌ unëꞌ: ―¿Cabiz̃i reyaꞌalaꞌ hue benꞌ naca xanꞌ layela? Decazide huedyinnëꞌ ganꞌ de layela quienëꞌ ta gutinëꞌ yaca benꞌ nuꞌenëꞌ ladyinëꞌë, hueꞌnëꞌ yaca benꞌ tula gaca ladyinaꞌayaquëꞌ layela quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Lëscanꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Binenaꞌle ca rnën lëꞌë guichi quie Diuzi? Cani rnën: Yo lagaꞌ ta baoruꞌun yaca benꞌ hue huecuaꞌ, lëyo naꞌ besiꞌ Diuzi bzunëꞌn ga naca belao, ga rzulao bezu. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Canaꞌ bë Diuzi. Nacan tadyaꞌa gula. Nacan ziꞌ ta yebanziro. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Naꞌra guꞌunyaquëꞌ guxuyaquëꞌ Jesús udzeꞌyaquëꞌ lëbëꞌ luꞌu dyiguiba como danꞌ gucabëꞌyaquëꞌ unë Jesús diꞌidzaꞌ naꞌ condre leyaquëꞌ. Pero como danꞌ bdzebiyaquëꞌ bi hue yaca benëꞌ quieyaquëꞌ, psanyaquëꞌ quienëꞌ, bezaꞌyaquëꞌ zeyoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ude beyudyi naꞌ, useꞌelaꞌyaquëꞌ chopa tzona benꞌ naca partido fariseo len ichopa tzona benꞌ naca partido quie rey Herodes ta tzenabayaquëꞌ Jesús diꞌidzaꞌ ta hueyaquëꞌ trampa quienëꞌ chi biguinonëꞌ lao diꞌidzaꞌ quienëꞌ ta saqueꞌ gaoyaquëꞌ lëbëꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Quie lenaꞌ bdyinyaquëꞌ ganꞌ zë Jesús unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Maestro, banezindoꞌ luëꞌ rusëdioꞌ yaca benëꞌ diꞌidzaꞌ naca li. Naꞌ biruꞌ cuenda bi naque yaca benëꞌ sino rusëdioꞌ leyaquëꞌ tali xneza Diuzi. Unacara nëtoꞌ: ¿Ruꞌen lato quiz̃oro quie impuesto quie benꞌ naca gobierno romano? ¿Reyaꞌalaꞌ quiz̃oron o chi bireyaꞌalaꞌ quiz̃oron? ");
INSERT INTO zpcNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero gucabëꞌ Jesús ca naca pensari mala yuꞌuyaquëꞌ birueyaquëꞌ ca rnayaquëꞌ. Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Bixquienꞌ reꞌenle cuëchile trampa quiaꞌ? Uletzexiꞌ tu dumi plata ta inaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Naꞌra yexiꞌyaquëꞌ tu dumi plata. Naꞌ caora blëꞌënëꞌn, unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Nu guicho, nu laohue daꞌ lëꞌën? Naꞌ bequëbiyaquëꞌ unayaquëꞌ Jesús: ―Daꞌ lëꞌën guicho laohue benꞌ naca gobierno quie benꞌ romano. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Ulehueꞌ benꞌ naca gobierno ta reduꞌulanëꞌ siꞌnëꞌ. Lëscanꞌ ulehueꞌ Diuzi ta reduꞌulanëꞌ siꞌnëꞌ. Naꞌ tu bebanziyaquëꞌ canꞌ unëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tanaꞌ uyorë yaca benꞌ partido Saduceo ganꞌ zë Jesús. Naꞌ leyaquëꞌ rnayaquëꞌ biyeban yaca benꞌ baguti. Quie lenaꞌ unayaquëꞌ rëbiyaquëꞌ Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, ca naca diꞌidzaꞌ bzu Moisés lëꞌë guichi, rnën chi baguti tu beꞌmbyu, naꞌ begaꞌn z̃gulanëꞌ tu cuinzëꞌ, nunu z̃iꞌiyaquëꞌ uzu, reyaꞌalaꞌ yeziꞌ bichinëꞌ nigula quie benꞌ baguti tacuenda yezu xcuidiꞌ yeziꞌ lao benꞌ baguti. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Naꞌ ugunro guca gadyi bichiyaquëꞌ. Naꞌ benꞌ nëro uz̃iꞌnëꞌ nigula quienëꞌ. Pero ni tu z̃iꞌiyaquëꞌ biuzu gutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Naꞌ biz̃i benꞌ urupe beziꞌnëꞌ nigula quie benꞌ bichinëꞌ, benꞌ baguti. Lëzi gutirënëꞌ, nunu z̃iꞌiyaquëꞌ uzurë. Naꞌ biz̃i benꞌ uyune beziꞌrënëꞌ nigula quie benꞌ bichinëꞌ, benꞌ baguti. Lëzirë gutirënëꞌ nunu z̃iꞌiyaquëꞌ uzurë. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Canaꞌ guca quie lao gadyiteyaquëꞌ, yaca benꞌ uzulë nigula. Gabeyudyicala quie nigula gutirënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naꞌra chi tali naꞌ yeban yaca benꞌ huati, ¿ca nurlayaquëꞌ naca z̃gulayaquëꞌ nigula naꞌ, como danꞌ lao gadyi bichiyaquëꞌ uzulëyaquëꞌ lëbëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Naꞌ bequëbi Jesús rëbinëꞌ leyaquëꞌ: ―Lega nequixile como danꞌ binezile cabëꞌ rnën lëꞌë guichi laꞌiya quie Diuzi. Lëscanꞌ binezile cabëꞌ naca yelaꞌ huaca quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cati babeban yaca benꞌ baguti, naꞌ bira sulëyaquëꞌ laguedyiyaquëꞌ ca z̃gulayaquëꞌ, ca xquiuyaquëꞌ. Gaca quieyaquëꞌ ca quie yaca ángel quie Diuzi, benꞌ yuꞌuyaca guibá. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero quie benꞌ baguti yeban, ¿binelabale lëꞌë guichi laꞌiya quie Diuzi cabëꞌ gudyi Diuzi Moisés dza naꞌ caora uzë Moisés ganꞌ reꞌ yaga raꞌalaꞌ guiꞌ birena? Lëganꞌ naꞌ una Diuzi rëbinëꞌ Moisés: “Nacaꞌ Diuzi quie xuzixtaꞌoloꞌ Abraham, len quie xuzixtaꞌoloꞌ Isaac, len quie xuzixtaꞌoloꞌ Jacob.” ");
INSERT INTO zpcNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Canaꞌ una Diuzi gudyinëꞌ leyaquëꞌ, baꞌalaꞌcazi bagutiyaquëꞌ azio zë iza caora. Lenaꞌ ruluꞌen rlëꞌë Diuzi leyaquëꞌ ca benꞌ neneban, quele ca benꞌ baguti. Tanaꞌ lenaꞌ lega nequixile. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Naꞌra bdyinrë tu benꞌ rusëdi ley quie Moisés. Dyëꞌëdi babenëꞌ cabëꞌ diꞌidzaꞌ bequëbi Jesús yaca benëꞌ. Naꞌ como nezinëꞌ dyëꞌëdi requëbi Jesús bi pregunta rnaba yaca benëꞌ, unëꞌ rëbinëꞌ lëbëꞌ: ―¿Ca nurla mandamiento rnabëꞌran raꞌo hue quiero len? ");
INSERT INTO zpcNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Cani naca mandamiento rnabëꞌran raꞌo: “Ulezëcara nagale, leꞌe benꞌ Israel. Tuzi Diuzi quiero zu, ganura Diuzi tula zu. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Reyaꞌalaꞌ idyëꞌëro Diuzi quiero du guicho du laꞌadyiꞌro.” Lenaꞌ naca mandamiento rnabëꞌran raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lëscanꞌ derë itu mandamiento nacan belao reyaꞌalaꞌ hue quiero. Cani rnën: “Reyaꞌalaꞌ idyëꞌëro laguedyiro cabëꞌ nedyëꞌëro cuinro.” Tuzi len naca mandamiento rnabëꞌra quiero, hue quiero len. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Naꞌra una benꞌ rusëdi ley quie Moisés rëbinëꞌ Jesús: ―Tahuen gula naꞌ cabëꞌ unaoꞌ, Maestro. Nacan tali unaoꞌ tuzi Diuzi zu, ganura Diuzi tula zu. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Lëscanꞌ zacaꞌran lao Diuzi idyëꞌëronëꞌ du guicho du laꞌadyiꞌro, lëscanꞌ idyëꞌëro laguedyiro ca nedyëꞌëro cuinro. Lenaꞌ zacaꞌran lao Diuzi quele ca yaca bia rutiro ruzeiro ruꞌaba ta hueꞌrobaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Naꞌra caora be Jesús cabëꞌ diꞌidzaꞌ dyaꞌa una benꞌ naꞌ, naꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Ilëꞌëtiꞌzi nerdziogueloꞌ gacoꞌ benꞌ tzuꞌu guibá ga rnabëꞌ Diuzi. Naꞌra nitu yaca benꞌ nitaꞌ naꞌ beyaz̃oyaquëꞌ inabayaquëꞌ lëbëꞌ diꞌidzaꞌ mazara. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Naꞌra rusëdi Jesús yaca benꞌ bdupa luꞌu idaoꞌ rnabëꞌra, unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Ca biz̃i ina yaca benꞌ rusëdi ley quie Moisés, como nayaquëꞌ naca Cristo z̃iꞌisuba rey David? ");
INSERT INTO zpcNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Porque cuin rey David, du yuꞌunëꞌ Bichi Be quie Diuzi, unëꞌ cani: Una Diuzi rëbinëꞌ benꞌ naca Señor quiaꞌ: “Ureꞌ cuëtaꞌ zaquëꞌ yebë niga hasta idyin dza cuëchaꞌ xniꞌaloꞌ yaca benꞌ rudie luëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Quie lenaꞌ rnabaꞌ leꞌe, ¿cómo naca Cristo z̃iꞌisuba rey David, chi cuin rey David unëꞌ naca Cristo Señor quienëꞌ? Biz̃i lega redaohue yaca benëꞌ canꞌ una Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Naꞌra ca rusëdi Jesús yaca benëꞌ, unëꞌ rëbinëꞌ leyaquëꞌ: ―Gapale cuidado bihuele ca rue yaca benꞌ rusëdi ley quie Moisés. Lega rexeyaquëꞌ laꞌariꞌ naca tona. Lega rexeyaquëꞌ gapalaꞌn yaca benëꞌ leyaquëꞌ ga rdayaquëꞌ tu neza. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lega rexeyaquëꞌ cueꞌyaquëꞌ ga rbeꞌ benꞌ balaꞌana chi luꞌu idaoꞌ sinagoga, chi ga raca lani. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Zidza rulidzayaquëꞌ Diuzi cuenda ilëꞌë yaca benëꞌ leyaquëꞌ benꞌ quie Diuzi, pero bëꞌ rueziyaquëꞌ danꞌ reguilolaꞌadyiꞌyaquëꞌ bi hueyaquëꞌ ta cubayaquëꞌ ta de quie yaca nigula baguti xquiuhue. Quie lenaꞌ huera Diuzi leyaquëꞌ tu castigo huala gula. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Naꞌ guca tu dza zë Jesús luꞌu idaoꞌ rnabëꞌra blëꞌënëꞌ rudzeꞌ yaca benëꞌ dumi quieyaquëꞌ luꞌu caja ga yuꞌun gun quie idaoꞌ. Blëꞌënëꞌ rudzeꞌ zë benꞌ uñaꞌa yalao dumi luꞌu caja naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Lëscanꞌ blëꞌënëꞌ bdzeꞌ tu nigula guti xquiuhue chopa dumi daoꞌ lasi de cobre ta zacaꞌn ledaoꞌzi luꞌu caja naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Naꞌra guz̃i Jesús yaca benꞌ quiëꞌ, unëꞌ gudyinëꞌ leyaquëꞌ: ―Tali rniaꞌ leꞌe, nigula naꞌ naquëꞌ benꞌ yëchiꞌ gula, aguti xquiuhuëꞌ, pero ca naca dumi bdzeꞌnëꞌ luꞌu caja, nacaran dumi z̃e quele ca ta bdzeꞌ yaca benꞌ uñaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta begaꞌnnan sobre quieyaquëꞌ bdzeꞌyaquëꞌ luꞌu caja naꞌ. Pero lënigula benꞌ yëchiꞌ, bdzeꞌnëꞌ ca tu dumi daoꞌ dezi quienëꞌ ta raꞌonëꞌ ta raonëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Naꞌra cati bro Jesús luꞌu idaoꞌ rnabëꞌra, unëꞌ tu benꞌ quienëꞌ rëbinëꞌ lëbëꞌ: ―¡Maestro, unaꞌ ca naca badan yo necuaꞌ besu, unaꞌ ca naca badan idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Pero naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Bablëꞌëloꞌ ca reꞌ idaoꞌ rnabëꞌra niga nacan taz̃e. Pero huadyin dza ni tu yo bira yegaꞌnnan lao laguedyin, huabiaguiꞌ duz̃eten. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Naꞌra uzaꞌyaquëꞌ zioyaquëꞌ ga zu yaꞌa Olivos tzalaꞌ berobayu ganꞌ reꞌ idaoꞌ rnabëꞌra. Biz̃i naꞌ caora ureꞌ Jesús ganꞌ, bebigaꞌ Pedro, len Santiago, len Juan, len Andrés, beroyaquëꞌ tzalaꞌla len Jesús unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Reꞌenndoꞌ inaoꞌ nëtoꞌ bata gaca canꞌ unaoꞌ. ¿Cabiz̃i seña gataꞌ cati baruen bago iyudyi yedyi layu? ");
INSERT INTO zpcNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Gapale cuidado tacuenda nunu siꞌ leꞌe yëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","porque huida benꞌ zë inayaquëꞌ nun quiaꞌ bidayaquëꞌ, inayaquëꞌ nacayaquëꞌ Cristo, pero yëꞌ rziꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Pero cati rele rna yaca benëꞌ raca dila yaca yedyi len yaca yedyi tula, rnayaquëꞌ ruen z̃udyi gaca dila mazara yedyi, biidzebile, porque reꞌen ca reꞌena gacan canꞌ, pero nezura ta gaca tu bineyudyi yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Huadila yaca yedyi conlë yaca yedyi tula, huadila yaca gobierno conlë yaca gobierno tula. Gaca uz̃uꞌ niꞌnila. Lëzi huataꞌ ubin, huataꞌ zëdi lao yedyi layu. Pero cala beyudyi naꞌ ta yedzagalao yaca benëꞌ, dechanꞌ uzulaozin naꞌ cabëꞌ ta yedzagalaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Gapale cuidado porque usedyin yaca benëꞌ leꞌe lao naꞌa yaca benꞌ rnabëꞌ, lëscanꞌ huaguiyaquëꞌ leꞌe luꞌu yaca idaoꞌ sinagoga. Usedyinyaquëꞌ leꞌe lao yaca benꞌ naca gobernador, len lao yaca benꞌ naca rey ta uquëpiyaquëꞌ leꞌe danꞌ naole hue quiele xtiꞌidzaꞌ. Canaꞌ huaguixogueꞌleyaquëꞌ xtiꞌidzaꞌ Diuzi tanun quiaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Zayeyudyi quie yedyi layu, huaguixogueꞌ yaca benëꞌ xtiꞌidzaꞌ Diuzi duz̃e yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Lëscanꞌ cati tzehuaꞌayaquëꞌ leꞌe lao naꞌa yaca benꞌ rnabëꞌ, bidëbile quie biz̃i danꞌ yëbileyaquëꞌ, ni siquiera bihuele pensari. Yëbileyaquëꞌ ca diꞌidzaꞌ udzeꞌ Diuzi guichole lëhora naꞌ, porque quele leꞌe cuinle inële, dechanꞌ Bichi Be quie Diuzi gunnëꞌ ta yeyëbileyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Lëscanꞌ usedyin benëꞌ hasta biꞌ bichiyaquëꞌ lao naꞌa yaca benꞌ rnabëꞌ ta gutiyaquëꞌ leyaquëꞌ. Lëzi usedyin benëꞌ z̃iꞌiyaquëꞌ lao naꞌa benꞌ rnabëꞌ, hasta usedyin yaca xcuidiꞌ xuzi z̃naꞌyaquëꞌ cuenda guti yaca benꞌ rnabëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Huadie yaca benꞌ nitaꞌ lao yedyi layu leꞌe, danꞌ naole xnezaꞌ. Pero nu benꞌ nao nëꞌëdiꞌ du guicho du laꞌadyiꞌ, benꞌ biusan nëꞌëdiꞌ hasta dza gatiëꞌ, huataꞌ yelaꞌ neban quienëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Bzu profeta Daniel diꞌidzaꞌ lëꞌë guichi dza tiempote rguixogueꞌn quie ta naca bayatza gula, ta rudyiaguiꞌ benëꞌ. (Reyaꞌalaꞌ tzioñeꞌe nu benꞌ rulaba diꞌidzaꞌ ni.) Caora ilëꞌële badyian ga bireyaꞌalaꞌ cuian, naꞌ racate baguin iz̃uno yaca benꞌ nitaꞌ estado Judea tzioyaquëꞌ ga zu yaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Lëscanꞌ lëdza naꞌ, chi nitaꞌ yaca benëꞌ laliꞌa quie yuꞌu quieyaquëꞌ, bireyaꞌalaꞌ yeyuꞌuyaquëꞌ luꞌu yuꞌu ta siꞌyaquëꞌ bi cosa quieyaquëꞌ, reyaꞌalaꞌ laiz̃unoteyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Lëzi chi nitaꞌ yaca benëꞌ layela quieyaquëꞌ rueyaquëꞌ dyin, bireyaꞌalaꞌ yeyoyaquëꞌ z̃an yuꞌu ta siꞌyaquëꞌ ni z̃abayaquëꞌ, reyaꞌalaꞌ laiz̃unoteyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Gaca beyëchiꞌ gula quie yaca nigula nuꞌa z̃iꞌine len yaca nigula rugaꞌadyi z̃iꞌine dza gaca canꞌ rniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ulidzale Diuzi ta bigaca quiele iz̃unole biuꞌ zaga. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Canaꞌ rniaꞌ como danꞌ bazaꞌ dza lega huala gula yedzagalao yaca benëꞌ. Naꞌ yedzagalaorayaquëꞌ quele ca yaca los demás benëꞌ. Desde ulëchi Diuzi dyilayu, bibedzagalao yaca benëꞌ cabëꞌ yedzagalao yaca benꞌ nitaꞌ dza yeyudyi yedu quie yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Chi bihue Diuzi uchugunëꞌ dza yedzagalaoyaquëꞌ, ni tuyaquëꞌ bisueyaquëꞌ, huabiaguiꞌ yuguluyaquëꞌ. Pero huachugu Diuzi dza naꞌ nun quie nedyëꞌënëꞌ yaca benꞌ quienëꞌ, benꞌ ulioguëꞌ gaca benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Chi ina yaca benëꞌ rëbiyaquëꞌ leꞌe: “Ulenaꞌcara, ni zu Cristo”, o “Ulenaꞌcara, naꞌ zu Cristo”, bigalele quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Huida yaca benꞌ huiziꞌ yëꞌ inayaquëꞌ nacayaquëꞌ Cristo, inayaquëꞌ nacayaquëꞌ benꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi. Hueyaquëꞌ milagro, hueyaquëꞌ seña tacuenda siꞌyaquëꞌ yëꞌ hasta yaca benꞌ ulio Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero leꞌe, ulehue listo. Lenaꞌ baoniaꞌ leꞌe ca ta binegaca quiele cuenda inezile sule listo. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Pero lëdza naꞌ, cati beyudyi bedzagalaotzegue yaca benëꞌ, huechula obidza bira gataꞌ xniꞌ quie te dza, lëscanꞌ huechula biuꞌ bira gataꞌ xniꞌ biuꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Lëscanꞌ huaguinu yaca beló dyian guibá. Huazisi yugulu ta dyia guibá huaguinun. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Naꞌra hualëꞌë yaca benëꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ. Hualëꞌëyaquëꞌ yeguidaꞌ lao beo zë ladza, zeyuꞌa yelaꞌ huaca quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Naꞌ iseꞌelaꞌ yaca ángel quiaꞌ ta tzetupayaquëꞌ yaca benꞌ quiaꞌ, yaca benꞌ uliogaꞌ, laꞌacazi nitaꞌyaquëꞌ zituꞌ lao yedyi layu, laꞌacazi nitaꞌyaquëꞌ zituꞌ guibá ―Canaꞌ una Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Lëscanꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Ulehue pensari cabëꞌ naca quie yaga higo. Caora badyia benue len laꞌagaꞌ cubi quien, banezile bazaꞌ biuꞌ yo. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lëscanꞌ caora rlëꞌële baraca lao yedyi layu cabëꞌ rniaꞌ leꞌe niga, huanezile bazaꞌ bago dza yeyudyi dyilayu, ilëꞌëtiꞌzi rdziogue. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tali rniaꞌ leꞌe, tu bineya z̃iꞌi suba benꞌ nitaꞌ naꞌa bëꞌ gaca cabëꞌ baoniaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Huade quie ta dyia guibá len lao yedyi layu canaꞌzi, pero ca naca diꞌidzaꞌ rniaꞌ, biten canaꞌzi. Decazide gacan. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Pero ca bi hora, ca bi dza yeguidaꞌ tatula, nitu nunu nezi. Binezi yaca ángel zu guibá, binezi ni siquiera nëꞌëdiꞌ, z̃iꞌi Diuzi. Tuzi Xuzaꞌ Diuzi nezinëꞌ bëꞌ gaca yeguidaꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Quie lenaꞌ ulesu listo, gapale cuidado, uleulidza Diuzi yugu dza como danꞌ binezile bëꞌ yeguidaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Banaca quiaꞌ ca quie tu benꞌ uzaꞌ zio zituꞌ. Caora binetzionëꞌ, rcaꞌnnëꞌ mozo quiëꞌ z̃an yuꞌu quiëꞌ ta gapayaquëꞌ ta de quienëꞌ, bëꞌnëꞌ bi dyin hueyaquëꞌ. Lëscanꞌ pcaꞌnnëꞌ tu mozo ta sëꞌ cuëta ruꞌa yuꞌu ta cuezëꞌ bëꞌ yelaꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ulesu listo como danꞌ binezile bëꞌ yeguidaꞌ tatula. Binezile chi yeguidaꞌ zadzëꞌ, chi yeguidaꞌ du gatzo yela, chi yeguidaꞌ cati rbedyi biu, chi yeguidaꞌ du zila. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Gapale cuidado ta sule puesto caora yeguidaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ca ta rniaꞌ leꞌe, lëscanꞌ rnëriaꞌ yugulu benëꞌ: Ulesu listo. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Naꞌra ichopa dza galaꞌ lani pascua cati gaoyaquëꞌ yëta xtila binequixi levadura. Naꞌ beguilolaꞌadyiꞌ yaca xanꞌ pxuzi len yaca benꞌ rusëdi ley quie Moisés bi hueyaquëꞌ ta guxuyaquëꞌ Jesús balarazi gutiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Naꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Biguxuro Jesús tu raca lani cuenda naꞌ biidzaꞌ yaca benꞌ yedyi bitilalëyaquëꞌ raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Naꞌra caora bedyin Jesús lënëꞌ yaca benꞌ quiëꞌ yedyi Betania, naꞌ uyuꞌunëꞌ lidyi tu benꞌ lao Simón, benꞌ yuꞌu yelaꞌ hueꞌ ca pindo. Biz̃i caora bareꞌyaquëꞌ lao mesa gaoyaquëꞌ, bdyin tu nigula nuꞌë frasco de yo laona alabastro. Luꞌu frasco naꞌ nedzaꞌn tubelaozi aceite rlaꞌ z̃ixi z̃eo laonan nardo. Naꞌ aceite naꞌ ruhueyaquëꞌn dyin rlaꞌoyaquëꞌn yaca benꞌ huati. Naꞌ ulaꞌ nigula frasco naꞌ blatoguëꞌ aceite guicho Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Naꞌ bala benꞌ reꞌ naꞌ bdzaꞌyaquëꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Bixquienꞌ bedito nigula ni aceite? ");
INSERT INTO zpcNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mejorla chi bëtiꞌnëꞌn como danꞌ zacaꞌn tzona gayuhua dumi denario tacuenda siꞌnëꞌ dumi hueꞌnëꞌn yaca benꞌ yëchiꞌ. Naꞌ udilayaquëꞌ nigula naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Ulesan quie nigula. ¿Bixquienꞌ ruelëlenëꞌ zëdi? Tadyaꞌa gula babënëꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nitaꞌcazi yaca benꞌ yëchiꞌ conlë leꞌe yugu dza. Con batatezi reꞌenle, huaca gacalële leyaquëꞌ. Pero nëꞌëdiꞌ bisuaꞌ len leꞌe tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ca ta huaca hue nigula ni, canaꞌ bënëꞌ quiaꞌ. Badyialaonëꞌ blatoguëꞌ aceite rlaꞌ z̃ixi z̃eo cuerpo quiaꞌ quie dza gatiaꞌ igachaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tali rniaꞌ leꞌe, con gatatezi rguixogueꞌ yaca benëꞌ xtiꞌidzaꞌ Diuzi duz̃e yedyi layu, huanëyaquëꞌ cabëꞌ bë nigula ni para nëꞌëdiꞌ, canaꞌ yezaꞌlaꞌadyiꞌ yaca benëꞌ cabëꞌ bënëꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Naꞌra uyo Judas Iscariote yegueꞌlënëꞌ yaca xanꞌ pxuzi diꞌidzaꞌ cuenda yegaꞌnlënëꞌ leyaquëꞌ diꞌidzaꞌ ta usedyinnëꞌ Jesús lao naꞌayaquëꞌ. Naꞌ naca Judas benꞌ quie Jesús entre chipchopa benꞌ naca benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Naꞌ lega bedaohue yaca xanꞌ pxuzi cabëꞌ gudyi Judas leyaquëꞌ. Begaꞌnlëyaquëꞌ lëbëꞌ diꞌidzaꞌ ta hueꞌyaquëꞌ lëbëꞌ dumi. Naꞌra uzulao Judas beguilolaꞌadyiꞌnëꞌ bi huenëꞌ usedyinnëꞌ Jesús lao naꞌa yaca xanꞌ pxuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Biz̃i dza nëro quie lani pascua udaoyaquëꞌ yëta xtila binequixi levadura, bëtiyaquëꞌ tu becoꞌ z̃iꞌilaꞌ ta bezaꞌlaꞌadyiꞌyaquëꞌ ca guca quie xuzixtaꞌoyaquëꞌ dza uzaꞌyaquëꞌ nación Egipto. Lëdza naꞌ una yaca benꞌ quie Jesús rëbiyaquëꞌ lëbëꞌ: ―¿Gaz̃i reꞌenloꞌ tziondoꞌ tzaguendoꞌ ta gaoro rtzeꞌ quie lani pascua? ");
INSERT INTO zpcNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Naꞌra useꞌelaꞌ Jesús chopa benꞌ quienëꞌ gudyinëꞌ leyaquëꞌ: ―Uleyo ciudad Jerusalén. Bëꞌ baidyinle hualëꞌële tu beꞌmbyu zeyuꞌa tu reꞌe yudzon nisa. Lëbenꞌ naꞌ reyaꞌalaꞌ inaole. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Cati babeyuꞌunëꞌ luꞌu yuꞌu, reyaꞌalaꞌ yëbile xanꞌ yuꞌu ga beyuꞌunëꞌ: “Cani una Maestro: ¿Gaz̃i zu luꞌu cuarto ga gaolënëꞌ yaca benꞌ quiëꞌ rtzeꞌ quie lani pascua?” ");
INSERT INTO zpcNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naꞌra hualuꞌe xanꞌ yuꞌu leꞌe tu luꞌu cuarto naca chopa xcuia. Lëganꞌ naꞌ tzaguele ta gaoro. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Naꞌ uzaꞌ chopa benꞌ quie Jesús zioyaquëꞌ ciudad Jerusalén. Caora bedyinyaquëꞌ guca quieyaquëꞌ laga ca gudyi Jesús leyaquëꞌ gaca. Naꞌ tu luꞌu cuarto naꞌ bëyaquëꞌ ta gaoyaquëꞌ rtzeꞌ quie lani pascua. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Caora bagula, bedyin Jesús lënëꞌ yaca benꞌ quiëꞌ ganꞌ gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Naꞌ cati baoreꞌyaquëꞌ ta gaoyaquëꞌ, una Jesús rëbinëꞌ yaca benꞌ quiëꞌ: ―Tali rniaꞌ leꞌe, ladoro ni reꞌ tu benꞌ raolëro tuz̃e, benꞌ usedyin nëꞌëdiꞌ lao naꞌa yaca benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Biz̃i uzulao raqueyëchiꞌyaquëꞌ uzulaoyaquëꞌ rnabayaquëꞌ tu huioyaquëꞌ lëbëꞌ: ―¿Quele nëꞌëdiꞌ huaꞌ cabëꞌ naoꞌ naꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Entre lao chipchopale niga, huaro tu benꞌ laguedyiro hue canꞌ rniaꞌ. Tzaz̃e rudyilënëꞌ nëꞌëdiꞌ yëta xtila luꞌu plato niga. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pues cani gaca quiaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, decazide gaca quiaꞌ cabëꞌ na lëꞌë guichi laꞌiya quie Diuzi. Pero bayëchiꞌ gula gaca quie benꞌ usedyin nëꞌëdiꞌ lao naꞌa benꞌ rnabëꞌ. Nacaran dyaꞌa quienëꞌ chi bigolocalanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tu neraoyaquëꞌ rtzeꞌ, uz̃iꞌ Jesús tu yëta xtila, bëlaꞌiyanëꞌn bz̃uz̃unëꞌn udisinëꞌn bëꞌnëꞌn yaca benꞌ quiëꞌ. Naꞌ unëꞌ gudyinëꞌ leyaquëꞌ: ―Ulegaona. Naca yëta xtila niga ca quie cuerpo quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Lëzi uz̃iꞌ Jesús tu vaso nisa bedzuliꞌ. Beyudyi bëlaꞌiyanëꞌn, bëꞌnëꞌn yaca benꞌ quiëꞌ tu huioyaquëꞌ lao yuguluyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Naca nisa bedzuliꞌ ni ca quie ren quiaꞌ. Lenaꞌ ilatogaꞌ gatiaꞌ cuenda yegaꞌntzaꞌolë Diuzi leꞌe tacubila. Lenaꞌ ilatogaꞌ cuenda gataꞌ yelaꞌ hueziꞌz̃e quie benꞌ zë lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tali rniaꞌ leꞌe, bira yoꞌogaꞌ vino nisa bedzuliꞌ tatula. Hasta idyin dza zulële nëꞌëdiꞌ ga rnabëꞌ Diuzi, naꞌtera yoꞌogaꞌ tacubi tatula. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ude beyudyi bilayaquëꞌ tu alabanza, naꞌ uzaꞌyaquëꞌ zioyaquëꞌ ga zu yaꞌa Olivos. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Yugulule usanlaꞌadyiꞌle nëꞌëdiꞌ naꞌayela. Cabëꞌ rnën lëꞌë guichi laꞌiya quie Diuzi cani: “Huaꞌ mandado gati benꞌ naca xaꞌn z̃iꞌilaꞌ, naꞌ yedzatza yaca becoꞌ z̃iꞌilaꞌ quienëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero cati bagutiaꞌ bebanaꞌ, naꞌra huabialaohuaꞌ laole tu neza Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Naꞌ una Pedro rëbinëꞌ lëbëꞌ: ―Baꞌalaꞌcazi usanlaꞌadyiꞌ yugulu benëꞌ leꞌe, pero nëꞌëdiꞌ biusanlaꞌadyaꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Naꞌ una Jesús rëbinëꞌ Pedro: ―Tali rniaꞌ luëꞌ. Naꞌayela, cati zacuedyi biu chopa lasa, huëboꞌ yaca benëꞌ binubëꞌloꞌ nëꞌëdiꞌ tzona lasa. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Biz̃i unë Pedro du guicho du laꞌadyiꞌnëꞌ rëbinëꞌ Jesús: ―Baꞌalaꞌcazi reꞌennan gatiliaꞌ luëꞌ tuz̃e, pero biyëpaꞌ yaca benëꞌ binubëꞌdaꞌ luëꞌ. Naꞌ lëscanꞌ canaꞌ una yaca los demás benꞌ quiëꞌ con ca beyaquëꞌ gudyi Pedro Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Naꞌ uzaꞌyaquëꞌ zioyaquëꞌ bdyinyaquëꞌ tu ga lao Getsemaní. Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Ulecueza ni. Huayaꞌa ta hueꞌliaꞌ Diuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Biz̃i uquiëꞌnëꞌ Pedro, len Santiago, len Juan, uzaꞌyaquëꞌ ilëꞌëtiꞌ. Caora bdyinyaquëꞌ naꞌ, lega uzulaon rutëbin lëbëꞌ, lega gucayëchiꞌtzeguenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Lenaꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Lega raquedaꞌ bayëchiꞌ. Baruen gutin nëꞌëdiꞌ. Ulecueza nëꞌëdiꞌ niga. Bigasile. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Naꞌra udenëꞌ ilëꞌëtiꞌ ganꞌ nitaꞌ yuna benꞌ quiëꞌ, gutanëꞌ ruzu ruꞌala layu, blidzëꞌ Diuzi chi bisaqueꞌ ucachiꞌ ucuiꞌo Diuzi ca tazëdi gula zaꞌ gaca quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Naꞌ blidzëꞌ Diuzi unëꞌ: ―Xuzaꞌ Diuzi, huacoꞌ hueloꞌ yugulute. Ucachiꞌ ucuiꞌoloꞌ ca tazëdi gula zaꞌ gaca quiaꞌ. Pero bihueloꞌ cabëꞌ reꞌendaꞌ nëꞌëdiꞌ, hueloꞌ cabëꞌ reꞌencazoꞌ gaca. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Naꞌra uyasa Jesús bezaꞌnëꞌ bedyinnëꞌ ganꞌ de yuna benꞌ quiëꞌ, blëꞌënëꞌ barasiyaquëꞌ. Naꞌ una Jesús rëbinëꞌ Pedro: ―Simón, ¿barasioꞌ? ¿Quele biuzueloꞌ inaꞌhuialoꞌ ni tu hora? ");
INSERT INTO zpcNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bigasile. Ruen zi ulidzale Diuzi tacuenda bihue taxiꞌibiꞌ leꞌe gan huele xquia ca tazëdi gula bazaꞌ quiele. Tali reꞌenle huelële nëꞌëdiꞌ tuz̃e, pero nerdzioguele fuerza ta huele cabëꞌ reꞌenle. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Naꞌra zio Jesús tatula ganꞌ baoyoguëꞌ, naꞌ blidzëꞌ Diuzi tatula unëꞌ gudyinëꞌ lëbëꞌ ca diꞌidzaꞌ unëꞌ tanëro. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Naꞌ bezaꞌnëꞌ bedyinnëꞌ tatula ganꞌ de yuna benꞌ quiëꞌ. Blëꞌënëꞌ nerasiyaquëꞌ nun quie danꞌ yuꞌu bichi gula laojëꞌ. Lenaꞌ bibequëbiyaquëꞌ ca diꞌidzaꞌ gudyi Jesús leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Naꞌ uzaꞌ Jesús zionëꞌ tatula ta hueꞌlënëꞌ Diuzi diꞌidzaꞌ. Caora bedyinnëꞌ ta beyuna lasa ganꞌ de yuna benꞌ quiëꞌ, unëꞌ rëbinëꞌ leyaquëꞌ: ―Naꞌa sí, tahuencazi gasile yezilaꞌadyiꞌle. Zelao tu canaꞌzi. Babdyin hora usedyinyaquëꞌ nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ, lao naꞌa yaca benꞌ de dulaꞌ xquia quie. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ulechasa, tzioro. Bazaꞌ benꞌ usedyin nëꞌëdiꞌ lao naꞌayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Biz̃i bineyudyi ina Jesús canaꞌ, caora labdyinte Judas, benꞌ naca benꞌ quie Jesús lado chipchopa benꞌ quienëꞌ. Naꞌ bdyinlënëꞌ benꞌ zë, benꞌ useꞌelaꞌ yaca xanꞌ pxuzi, len yaca benꞌ rusëdi ley quie Moisés, len los demás yaca benꞌ rnabëꞌ. Nuꞌayaquëꞌ macheta len yaga. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Naꞌ begaꞌnlë Judas leyaquëꞌ diꞌidzaꞌ huenëꞌ seña ta uluꞌenëꞌ leyaquëꞌ nu benꞌ naca Jesús. Lenaꞌ unëꞌ gudyinëꞌ leyaquëꞌ: ―Nu benꞌ gaohuaꞌ xague psitu, lëbenꞌ naꞌ naca Jesús. Laguxutelenëꞌ iquiëꞌlenëꞌ dyëꞌëdi. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Naꞌ ca bdyinnëꞌ ganꞌ zë Jesús bebigaꞌnëꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Maestro, Maestro. Naꞌra udaohuëꞌ psitu xaguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Caora naꞌ bëxuyaquëꞌ Jesús bëyaquëꞌ lëbëꞌ preso. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Biz̃i ulio tu benꞌ quie Jesús macheta quienëꞌ udinëꞌn uchugunëꞌ naga criado quie benꞌ rnabëꞌra quie yaca xanꞌ pxuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Naꞌra una Jesús rëbinëꞌ yaca benꞌ nitaꞌ naꞌ: ―¿Barzaꞌle nuꞌale macheta, nuꞌale yaga ta guxule nëꞌëdiꞌ huele nëꞌëdiꞌ preso ca quie ta guxule huele preso tu benꞌ uban? ");
INSERT INTO zpcNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yugu dza zuliaꞌ leꞌe luꞌu idaoꞌ rnabëꞌra psëdiaꞌ yaca benëꞌ, pero bibëxule nëꞌëdiꞌ caora naꞌ. Pero reꞌen ca reꞌena uzun xtiꞌidzaꞌ Diuzi ca rnën lëꞌë guichi laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Naꞌra yaca benꞌ quie Jesús psanlaꞌadyiꞌyaquëꞌ lëbëꞌ, bz̃unoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Biz̃i bdyin tu biꞌbyu ganꞌ. Naꞌ nadubinëꞌ tu laꞌariꞌ yuaꞌ naonëꞌ Jesús. Biz̃i naꞌ bëxuyaquëꞌ lëbëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero udubanëꞌ laꞌariꞌ yuaꞌ nadubinëꞌ, bz̃unonëꞌ dú guidinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Naꞌra uquiëꞌyaquëꞌ Jesús ga reꞌ benꞌ naca xanꞌ pxuzi rnabëꞌra. Naꞌ beguꞌudiꞌ yaca xanꞌ pxuzi, len yaca benꞌ rnabëꞌ, len yaca benꞌ rusëdi ley quie Moisés. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Biz̃i unao Pedro Jesús zituꞌla. Bdyinnëꞌ laliꞌa yuꞌu quie benꞌ naca xanꞌ pxuzi rnabëꞌra. Naꞌ ureꞌnëꞌ ruꞌa guiꞌ len yaca policía ta yedzeꞌenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Naꞌra yaca xanꞌ pxuzi len yaca los demás benꞌ rnabëꞌ, beguilolaꞌadyiꞌyaquëꞌ ta gaoyaquëꞌ Jesús xquia cuenda gataꞌ causa gutiyaquëꞌ lëbëꞌ, pero biuz̃aqueꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Balayaquëꞌ unëyaquëꞌ diꞌidzaꞌ falso conlë Jesús, pero biunëyaquëꞌ tuzi ca inëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Naꞌ uzuli ibalayaquëꞌ unërëyaquëꞌ diꞌidzaꞌ falso conlë lëbëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nëtoꞌ bendoꞌ unëꞌ udyiaguiꞌnëꞌ idaoꞌ rnabëꞌra quie xuzixtaꞌoro, unëꞌ cati gaca lao tzona dza, yeyuenëꞌ idaoꞌ rnabëꞌra tula, ta bibë yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero nica ca unayaquëꞌ quie idaoꞌ rnabëꞌra, biuyuꞌurë xnezi ca unayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Naꞌra uzuli benꞌ naca xanꞌ pxuzi rnabëꞌra unëꞌ rëbinëꞌ Jesús: ―¿Bixquienꞌ birequëboꞌ? ¿Bi ca naoꞌ quie diꞌidzaꞌ rnëyaquëꞌ conlë luëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero uzë Jesús chizi, bibequëbinëꞌ. Tatula una benꞌ naca xanꞌ pxuzi rnabëꞌra rëbinëꞌ Jesús: ―¿Nacoꞌ benꞌ Cristo, z̃iꞌi Diuzi laꞌiya? ");
INSERT INTO zpcNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Nëꞌëdiꞌ z̃e. Lëscanꞌ hualëꞌële nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ, cati bariꞌa zaquëꞌ yebë cuëta lëꞌë Diuzi, benꞌ de yelaꞌ huaca quie. Lëscanꞌ hualëꞌële nëꞌëdiꞌ cati yeguidaꞌ lao yedyi layu tu lao beo zë ladza. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Naꞌra nun quie danꞌ lega bdzaꞌ benꞌ naca xanꞌ pxuzi rnabëꞌra, pchezëꞌ z̃abëꞌ unëꞌ rëbinëꞌ yaca benꞌ nitaꞌ naꞌ: ―¿Cabiz̃ira testigo reꞌennan inë conlë benꞌ niga? ");
INSERT INTO zpcNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Babele unëꞌ diꞌidzaꞌ ta inayaꞌnëꞌ Diuzi. ¿Biz̃i huero quienëꞌ? Naꞌ unayaquëꞌ yuguluyaquëꞌ de que reyaꞌalaꞌ gatinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Naꞌra uzulaoyaquëꞌ bdaꞌyaquëꞌ lëbëꞌ z̃enꞌ, pcachiꞌyaquëꞌ laohuëꞌ udyibiyaquëꞌ lëbëꞌ begoro, unayaquëꞌ gudyiyaquëꞌ lëbëꞌ: ―¡Una nuz̃i udyibi luëꞌ begoro! Lëscanꞌ udyibirë yaca policía lëbëꞌ begoro. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ga zë Pedro laliꞌa bdyin tu criada quie benꞌ naca xanꞌ pxuzi rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Biz̃i caora blëꞌë biꞌ criada reꞌ Pedro redzëꞌënëꞌ cuëta guiꞌ, naꞌ unaꞌbiꞌ lëbëꞌ dyëꞌëdi unabiꞌ: ―Lëzi luëꞌ nacoꞌ benꞌ quie Jesús, benꞌ yedyi Nazaret. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Naꞌ una Pedro gudyinëꞌ lëbiꞌ: ―Binubiꞌa benꞌ naꞌ, nica nezdaꞌ bi inaoꞌ. Naꞌ beronëꞌ zënëꞌ cuëta ruꞌa yuꞌu. Caora naꞌ uredyi biu tu. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Biz̃i tatula unaꞌ biꞌ criada Pedro unëbiꞌ rëbibiꞌ yaca benꞌ nitaꞌ naꞌ: ―Naca benꞌ ni tuz̃e len leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero tatula unë Pedro binubëꞌnëꞌ Jesús. Naꞌ guca itu chiꞌ cati una yaca benꞌ nitaꞌ naꞌ gudyiyaquëꞌ Pedro: ―Talicazi nacoꞌ tuz̃e len leyaquëꞌ, como danꞌ nacoꞌ benꞌ Galilea rnëloꞌ ca rnë benꞌ Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Naꞌ una Pedro bdzeꞌdeꞌnëꞌ cuinnëꞌ bguntenëꞌ Diuzi gudyinëꞌ leyaquëꞌ: ―Binubiꞌa nu benꞌ nale canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Caora naꞌ laoredyite biu taorupe. Naꞌra bezaꞌlaꞌadyiꞌ Pedro cabëꞌ gudyi Jesús lëbëꞌ unëꞌ: “Ca zacuedyi biu chopa lasa, huëboꞌ yaca benëꞌ binubëꞌloꞌ nëꞌëdiꞌ tzona lasa.” Caora naꞌ beyuenëꞌ pensari cabëꞌ una Jesús, naꞌ uredyinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Caora baoyaniꞌ dza tula, bedupa yaca xanꞌ pxuzi, len yaca benꞌ gula, len yaca benꞌ rusëdi ley quie Moisés, len yaca los demás benꞌ rnabëꞌ, bëyaquëꞌ junta. Pquioyaquëꞌ Jesús uquiëꞌyaquëꞌ psedyinyaquëꞌ lëbëꞌ lao naꞌa Pilato. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Naꞌ unaba Pilato rëbinëꞌ Jesús: ―¿Tabala nacoꞌ rey quie benꞌ Israel? Naꞌra bequëbi Jesús rëbinëꞌ Pilato: ―Ca unaoꞌ, canaꞌ nacaꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Biz̃i naꞌ udao yaca xanꞌ pxuzi Jesús xquia z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Lenaꞌ una Pilato rëbinëꞌ Jesús: ―¿Bixquienꞌ birequëboꞌ? Huala rao yaca benꞌ niga luëꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero begaꞌn Jesús chizi, bibequëbinëꞌ. Quie lenaꞌ biubin Pilato bi pensari huenëꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Naꞌ de tu costumbre quie Pilato yebionëꞌ tu benꞌ preso yuꞌu luꞌu dyiguiba tu raca lani pascua. Naꞌ yebio Pilato nutezi benꞌ reꞌen yaca benëꞌ yero. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Naꞌra luꞌu dyiguiba yuꞌu yaca benꞌ bëti benëꞌ, benꞌ udilalë gobierno. Naꞌ yuꞌurë tu benꞌ lao Barrabás luꞌu dyiguiba, benꞌ nuelë leyaquëꞌ tuz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Naꞌ bdyin yaca benëꞌ ga zë Pilato unabayaquëꞌ chi biyebionëꞌ tu benꞌ yuꞌu luꞌu dyiguiba según ca naca costumbre. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Canaꞌ una Pilato rëbinëꞌ leyaquëꞌ: ―¿Reꞌenle yebiogaꞌ benꞌ na naquëꞌ rey quie benꞌ Israel? ");
INSERT INTO zpcNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Canaꞌ una Pilato, porque gucabëꞌnëꞌ yelaꞌ z̃ëꞌ quie yaca xanꞌ pxuzi psedyinyaquëꞌ Jesús laohuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Naꞌ begaꞌn yaca xanꞌ pxuzi diꞌidzaꞌ ta yëbiyaquëꞌ yaca benëꞌ ta inabayaquëꞌ yebio Pilato Barrabás. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Naꞌ una Pilato rëbinëꞌ yaca benꞌ nitaꞌ naꞌ: ―¿Biz̃i reꞌenle huaꞌ quie benꞌ na naquëꞌ rey quie benꞌ Israel? ");
INSERT INTO zpcNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Naꞌ uredyiyaꞌyaquëꞌ bequëbiyaquëꞌ: ―¡Udaꞌloꞌnëꞌ lëꞌë yaga cruzo! ");
INSERT INTO zpcNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Biz̃i naꞌ una Pilato gudyinëꞌ leyaquëꞌ: ―¿Biz̃i xquia bënëꞌ? Pero tatula uredyiyaꞌyaquëꞌ: ―Udaꞌloꞌnëꞌ lëꞌë yaga cruzo. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Naꞌra como biguꞌun Pilato idzaꞌ yaca benëꞌ lëbëꞌ, bzuëꞌ diꞌidzaꞌ bebioguëꞌ Barrabás luꞌu dyiguiba. Lëscanꞌ bënëꞌ mandado qui yaca soldado Jesús guidi, naꞌtera udaꞌyaquëꞌ lëbëꞌ lëꞌë yaga cruzo gatinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Biz̃i uquiëꞌ yaca soldado Jesús zioyaquëꞌ bdyinyaquëꞌ laliꞌa quie palacio (diꞌidzaꞌ quieyaquëꞌ laona pretorio). Naꞌ guz̃iyaquëꞌ yaca los demás benꞌ naca soldado laguedyiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Caora naꞌ bgacoyaquëꞌ Jesús tu laꞌariꞌ morado, bdzeꞌyaquëꞌ tu coron yëchiꞌ guichonëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Lëscanꞌ uredyiyaꞌyaquëꞌ ptituyaquëꞌ lëbëꞌ unayaquëꞌ: ―¡Viva rey quie benꞌ Israel! ");
INSERT INTO zpcNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Caora naꞌ udiyaquëꞌ yaga guichonëꞌ, bdaꞌyaquëꞌ z̃enꞌ laohuëꞌ, ptituyaquëꞌ uditzu z̃ibiyaquëꞌ bëyaquëꞌ ca quie benꞌ rapalaꞌn lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Beyudyi ptituyaquëꞌ lëbëꞌ, naꞌ belëchoyaquëꞌ laꞌariꞌ morado, begacoyaquëꞌ lëbëꞌ z̃abëꞌ, uquiëꞌyaquëꞌ lëbëꞌ ta udaꞌyaquëꞌ lëbëꞌ lëꞌë yaga cruzo gatinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Naꞌ du tu neza ganꞌ zioyaquëꞌ, bedzagayaquëꞌ tu benꞌ yedyi Cirene laohuëꞌ Simón, benꞌ xuzi Alejandro len Rufo. Bezëꞌë layela ga uyoguëꞌ. Naꞌra bë yaca soldado mandado biꞌanëꞌ yaga cruzo nuꞌa Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Naꞌ zioyaquëꞌ bdyinyaquëꞌ ga laona Gólgota (ta inaro xtiꞌidzaꞌro: Yaꞌa chita guicho benꞌ huati). ");
INSERT INTO zpcNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Biz̃i bëꞌyaquëꞌ lëbëꞌ vino nequixi taslaꞌ gula laona mirra, pero biguꞌunnëꞌ yoꞌonëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Naꞌra bdaꞌ yaca soldado lëbëꞌ lëꞌë yaga cruzo. Te beyudyi naꞌ, bëyaquëꞌ sorteo ca nu xlaz̃oyaquëꞌ gaca quieyaquëꞌ z̃aba Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Baruen las nueve te dza cati bdaꞌyaquëꞌ Jesús lëꞌë yaga cruzo. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Naꞌ guicho cruzo bdyiayaquëꞌ tu letrero ga rguixogueꞌn bi causa de quienëꞌ danꞌ bëtiyaquëꞌ lëbëꞌ. Lëꞌë letrero rnën caniga: “Rey quie benꞌ Israel.” ");
INSERT INTO zpcNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Lëzi bdaꞌrëyaquëꞌ chopa benꞌ uban lëꞌë yaga cruzo. Bzuyaquëꞌ tun zaquëꞌ yebë cuëta Jesús, itun bzuyaquëꞌ zaquëꞌ yegaꞌla. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Canaꞌ guca quienëꞌ bzun diꞌidzaꞌ ca rnën lëꞌë guichi laꞌiya quie Diuzi cani: “Psacayaquëꞌ lëbëꞌ ca benꞌ mala.” ");
INSERT INTO zpcNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Naꞌra ptasi bnio yaca benꞌ rede ganꞌ nedaꞌ Jesús lëꞌë yaga cruzo. Uredyiyaꞌyaquëꞌ tu rtulazi guichoyaquëꞌ unayaquëꞌ rëbiyaquëꞌ Jesús: ―Luëꞌ naoꞌ huadyiaguiꞌloꞌ idaoꞌ rnabëꞌra, naꞌtera yecuboꞌn gaca lao tzona dza, ");
INSERT INTO zpcNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","psela cuinloꞌ, beyëzi lëꞌë yaga cruzo. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lëscanꞌ ptitu yaca xanꞌ pxuzi len yaca benꞌ rusëdi ley quie Moisés lëbëꞌ, unayaquëꞌ gudyiyaquëꞌ laguedyiyaquëꞌ: ―Pselanëꞌ benꞌ tula, naꞌ bigaquëꞌ uselanëꞌ cuinnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chi Cristo luëꞌ, chi rey quie benꞌ Israel luëꞌ, beyëzi lëꞌë yaga cruzo ilëꞌëndoꞌ, naꞌtera galendoꞌ quioꞌ. Hasta ichopa yaca benꞌ nedaꞌlë yaga cruzo cuëta lëꞌë Jesús, ptasi bniorëyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Caora bagaꞌalaꞌ laꞌodza, bechula lao duz̃e ciudad naꞌ hasta reda tzona. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Caora naꞌ uredyiyaꞌ Jesús unëꞌ: ―Eloi, Eloi, ¿lama sabactani? ―ta inaro xtiꞌidzaꞌro: Xuzaꞌ Diuzi, Xuzaꞌ Diuzi, ¿bixquienꞌ bapsanlaꞌadyoꞌ nëꞌëdiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Naꞌra una yaca benꞌ nitaꞌ bago rëbiyaquëꞌ laguedyiyaquëꞌ: ―Ulezë nagale, rëz̃inëꞌ Elías. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Naꞌ laziote tu benꞌ nitaꞌ naꞌ yexiꞌnëꞌ tu ta naca yunꞌ ca z̃iꞌilaꞌ laona esponja. Naꞌ bdzeꞌnëꞌn luꞌu vino slaꞌ bzunëꞌn lao yaga ta bdyinnan sibi ga daꞌ Jesús ta supinëꞌn. Pero una bala yaca benꞌ nitaꞌ naꞌ: ―Psan quienëꞌ. Yaꞌ inaꞌro chi guida Elías ta uchizanëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Naꞌra uredyiyaꞌ Jesús gutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Caora naꞌ, breꞌeza laꞌariꞌ naꞌalan luꞌu idaoꞌ rnabëꞌra, gucan chopa laꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Naꞌ uzë xanꞌ yaca soldado zaquëꞌlao lao Jesús. Caora blëꞌënëꞌ cabëꞌ uredyiyaꞌ Jesús gutinëꞌ, unëꞌ rëbinëꞌ laguedyinëꞌ: ―Tali naca benꞌ ni z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Lëzi lëganꞌ naꞌ nitaꞌrë yaca nigula rnaꞌyaquëꞌ Jesús zituꞌla. Ladoyaquëꞌ naꞌ zu María Magdalena, len María z̃naꞌ Santiago biꞌ nëchiꞌ, len José, len Salomé. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Lëleyaquëꞌ unaoyaquëꞌ Jesús cati udanëꞌ lao yaca yedyi nebaba Galilea gucalëyaquëꞌ lëbëꞌ. Lëzi nitaꞌrë yaca nigula tula, benꞌ uyolënëꞌ Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Naꞌ gula rdzeꞌ dza bëyaquëꞌ ta gaoyaquëꞌ quie dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Bdyin tu benꞌ yedyi Arimatea laonëꞌ José. Naquëꞌ tu benꞌ rnabëꞌ entre yaca benꞌ rnabëꞌ quie benꞌ Israel. Rbezëꞌ dza inabëꞌ Diuzi lao duz̃e yedyi layu. Naꞌ beyaz̃oguëꞌ uyoguëꞌ ga zu Pilato yenabanëꞌ chi bihueꞌnëꞌ lato tzecachiꞌnëꞌ cuerpo quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Naꞌ bebanzi Pilato lagutite Jesús. Naꞌ guz̃ëꞌ benꞌ naca xanꞌ soldado unabanëꞌ lëbëꞌ chi tali baguti Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Caora gudyi xanꞌ soldado Pilato tali naꞌ baguti Jesús, naꞌra bëꞌnëꞌ lato ta yeyuꞌa José cuerpo quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Naꞌ uyo José yegueꞌnëꞌ tu laꞌariꞌ ta yetupanëꞌ cuerpo quie Jesús. Naꞌ beziꞌnëꞌ cuerpo quie Jesús betubinëꞌn laꞌariꞌ, bdzeꞌnëꞌn luꞌu tu beló yo ta uquiꞌn yaca benëꞌ según ca naca costumbre quieyaquëꞌ. Naꞌ uz̃iꞌnëꞌ tu yo taꞌa, bdaꞌnëꞌn ruꞌa beló yo. ");
INSERT INTO zpcNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Biz̃i María Magdalena, len María z̃naꞌ José, blëꞌëyaquëꞌ ganꞌ bdzëꞌ José cuerpo quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Caora baode dza saodo, dza huezilaꞌadyiꞌ quieyaquëꞌ, uyo María Magdalena, len María z̃naꞌ Santiago, len Salomé ta gaꞌoyaquëꞌ aceite rlaꞌ z̃ixi z̃eo ta ulaꞌoyaquëꞌ cuerpo quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Naꞌ caora uyaniꞌ zila daoꞌ dza domingo, dza nëro quieyaquëꞌ, uyoyaquëꞌ ganꞌ zu beló yo ganꞌ de cuerpo quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Naꞌ unayaquëꞌ: ―¿Nuz̃i yëbiro ta cubayaquëꞌ yo taꞌa daꞌ ruꞌa beló? ");
INSERT INTO zpcNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Cati bdyinyaquëꞌ ganꞌ, blëꞌëyaquëꞌ bira daꞌ yo taꞌa ruꞌa beló yo. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Naꞌ uyuꞌuyaquëꞌ luꞌu beló yo, blëꞌëyaquëꞌ tu ángel nacanëꞌ ca tu forma biꞌbyu ruꞌabe. Reꞌnëꞌ zaquëꞌ yebë luꞌu beló yo, naconëꞌ tu laꞌariꞌ bezëri. Naꞌ lega bdzebiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Naꞌra unë ángel naꞌ rëbinëꞌ leyaquëꞌ: ―Bidzebile. Bazaꞌle denaꞌle Jesús, benꞌ yedyi Nazaret, benꞌ guti lëꞌë yaga cruzo. Bira denëꞌ niga, babebannëꞌ. Ulenaꞌcara ga udixoyaquëꞌ cuerpo quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Uleyo uletzeguëdyi Pedro len yaca los demás yaca benꞌ quie Jesús de que huabialaohuëꞌ laole neza Galilea. Hualëꞌëlenëꞌ ganꞌ con ca rniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Biz̃i naꞌ bero yaca nigula luꞌu beló yo. Du rdzebiyaquëꞌ du rz̃iziyaquëꞌ uyuꞌuyaquëꞌ be. Nitu nunu benꞌ bedilayaquëꞌ tu neza bigudyiyaquëꞌ cabëꞌ blëꞌëyaquëꞌ como canꞌ rdzebiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Biz̃i beyudyi beban Jesús dza domingo, dza nëro quieyaquëꞌ, tanëro ptilalaohuëꞌ María Magdalena, benꞌ bebio Jesús gadyi bichi be mala. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naꞌra uyo María tzetixogueꞌnëꞌ yaca benꞌ unao Jesús dza naꞌ. Begaꞌnyaquëꞌ guqueyëchiꞌyaquëꞌ uredyiyaquëꞌ nun quie danꞌ guti Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Naꞌ cati beyaquëꞌ cabëꞌ gudyi María leyaquëꞌ de que beban Jesús, blëꞌë María lëbëꞌ, biguleyaquëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Te beyudyi naꞌ, betzaꞌ cuin Jesús yetilalaohuëꞌ chopa benꞌ zio layela, benꞌ nao xnezëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Naꞌ lëscanꞌ uyoyaquëꞌ yetixogueꞌyaquëꞌ yaca los demás benꞌ nao xneza Jesús de que babebannëꞌ, denꞌ biguleyaquëꞌ quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Te beyudyi naꞌ, ptilalao Jesús yaca chiptu benꞌ quienëꞌ tu reꞌyaquëꞌ lao mesa neraoyaquëꞌ. Naꞌra udilanëꞌ leyaquëꞌ nun quie yelaꞌ zidi quieyaquëꞌ biguleyaquëꞌ quie benꞌ gudyi leyaquëꞌ blëꞌëyaquëꞌ lëbëꞌ bebannëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Naꞌ una Jesús gudyinëꞌ leyaquëꞌ: ―Uletzio lao duz̃e yedyi layu tzetixogueꞌle yugulu benëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Naꞌ nu benꞌ gale quiaꞌ, benꞌ nao xnezaꞌ, benꞌ siꞌ laohue, huaziꞌ Diuzi lëbëꞌ guibá. Pero nu benꞌ bigale quiaꞌ, benꞌ binao xnezaꞌ, huachugubëꞌ Diuzi quienëꞌ yeyonëꞌ guiꞌ gabila. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Cani naca seña hue yaca benꞌ inao xnezaꞌ. Du rzëtoyaquëꞌ laohuaꞌ huebioyaquëꞌ yaca bichi be mala yuꞌu yaca benëꞌ. Huacayaquëꞌ inayaquëꞌ diꞌidzaꞌ quie benꞌ tula. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Chi guxuyaquëꞌ bëla rguiꞌidyiꞌ, bibi huebaꞌ quieyaquëꞌ. Chi yoꞌoyaquëꞌ tu ta naca veneno, bibi huena quieyaquëꞌ. Chi udaꞌ naꞌayaquëꞌ yaca benꞌ raca z̃hueꞌ, hueyacayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bëꞌ beyudyi unë Señor quiero Jesús canaꞌ, beyëpinëꞌ ladza zeyonëꞌ guibá ga reꞌnëꞌ zaquëꞌ yebë quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Naꞌ uzaꞌ yaca benꞌ quie Jesús ta quixogueꞌyaquëꞌ xtiꞌidzaꞌ Diuzi duz̃e yedyi layu. Gucalë Señor quiero Jesús leyaquëꞌ, bënëꞌ yelaꞌ huaca quienëꞌ ta uluꞌen xtiꞌidzaꞌ Diuzi naꞌ rguixogueꞌyaquëꞌ. Amén.");
INSERT INTO zpcNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yaca benꞌ zë babzuyaquëꞌ diꞌidzaꞌ lëꞌë guichi ta yuꞌu niꞌa xnezi con ca guca quiendoꞌ dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bzuyaquëꞌ diꞌidzaꞌ lëꞌë guichi ca ta una yaca benꞌ blëꞌë cabëꞌ guca desde dza zasu Jesús. Lëleyaquëꞌ udixogueꞌrëyaquëꞌ diꞌidzaꞌ laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Lëscanꞌ nëꞌëdiꞌ unabaꞌyudyaꞌ dyëꞌëdi cabëꞌ guca desde dza ga uzulaon quie Jesús. Lëlenaꞌ raquedaꞌ tahuen naꞌ huaꞌ itu guichi ni ta iseꞌelaꞌn laoloꞌ bichaꞌ Teófilo. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Lëlenaꞌ ruaꞌ cuenda inezile dyëꞌëdi nacan diꞌidzaꞌ li ca ta udixogueꞌyaquëꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lëdza naꞌ uzu rey Herodes rnabëꞌnëꞌ estado Judea, zurë itu benꞌ naca pxuzi laonëꞌ Zacarías. Naquëꞌ tu cueꞌ len yaca benꞌ nao pxuzi lao Abías. Naca nigula quie Zacarías z̃iꞌi suba Aarón, benꞌ gucarë pxuzi dza naꞌte. Lëbëꞌ laohuëꞌ Elisabet. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Blëꞌë Diuzi leyaquëꞌ benꞌ dyaꞌa. Bzuyaquëꞌ diꞌidzaꞌ ca rna ley yuꞌu diꞌidzaꞌ laꞌiya quie Diuzi. Lëlenaꞌ nunu saqueꞌ gao leyaquëꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero nunu z̃iꞌiyaquëꞌ uzu, danꞌ guca Elisabet benꞌ bidyi. Lao rupayaquëꞌ nacayaquëꞌ benꞌ gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Biz̃i bdyin dza babedulaꞌ turno quie tu cueꞌ pxuzi benꞌ nacalë Zacarías tzaz̃e. Babedulaꞌ turno rioyaquëꞌ luꞌu idaoꞌ rnabëꞌra, danꞌ nacayaquëꞌ pxuzi ta hueꞌlëyaquëꞌ Diuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ca costumbre quie yaca pxuzi bedulaꞌ Zacarías uyuꞌuguëꞌ luꞌu idaoꞌ rnabëꞌra ta udzeꞌnëꞌ dzen yalo lao becugo. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Biz̃i caora rei dzen yalo lao becugo, naꞌra nitaꞌ yaca benꞌ zë laliꞌa rlidzayaquëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Caora naꞌ ptilalao tu ángel quie Diuzi bazëguëꞌ zaquëꞌ yebë lao becugo. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Biz̃i caora blëꞌë Zacarías tu ángel, tu bdzebizinëꞌ, bira ubinnëꞌ bi nëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Naꞌra una ángel rëbinëꞌ Zacarías: ―Zacarías, bidzeboꞌ, babe Diuzi ca naca oración quioꞌ rnaloꞌ. Nigula quioꞌ Elisabet huaꞌ z̃iꞌinëꞌ huazu z̃iꞌiloꞌ ixuboꞌ laobiꞌ Juan. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Lega yedaohuelaꞌobiꞌ. Lëscanꞌ yedaohuerë yaca benꞌ zë cati bazubiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Canaꞌ gaca quiele danꞌ huacabiꞌ benꞌ z̃e, huacabiꞌ benꞌ balaꞌana lao Diuzi. Biyoꞌobiꞌ vino, biyoꞌobiꞌ ta xudyibiꞌ. Huayuꞌubiꞌ Bichi Be que Diuzi desde yuꞌutebiꞌ luꞌu lëꞌë z̃naꞌbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Huacalëbiꞌ yaca benꞌ zë, benꞌ Israel, ta yetzaꞌyaquëꞌ pensari quieyaquëꞌ ta yenaoyaquëꞌ xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Lëbiꞌ cuialaonezabiꞌ ta quixogueꞌbiꞌ benëꞌ bazaꞌ benꞌ iseꞌelaꞌ Diuzi. Con ca bë profeta Elías, bënëꞌ yelaꞌ huaca quie Diuzi, canaꞌ huerë z̃iꞌiloꞌ yedzeꞌbiꞌ pensari quie Elías luꞌu guicho laxtaꞌo yaca benëꞌ ta bitilalë xuziyaquëꞌ len z̃iꞌiyaquëꞌ, lëscanꞌ ta galerë yaca benꞌ birale quie Diuzi. Canaꞌ huebiꞌ tacuenda chezilaꞌadyiꞌ yaca benëꞌ yeziꞌyaquëꞌ benꞌ iseꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Biz̃i naꞌ unaba Zacarías ángel: ―¿Cabiz̃i huaꞌ ta inezdaꞌ gaca quiaꞌ cabëꞌ baonaoꞌ? Porque nëꞌëdiꞌ banacaꞌ benꞌ gula. Lëscanaꞌ benꞌ gula naca nigula quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Naꞌra una ángel rëbinëꞌ lëbëꞌ: ―Nëꞌëdiꞌ laohuaꞌ Gabriel. Ruaꞌ mandado rue Diuzi. Useꞌelëꞌ nëꞌëdiꞌ ta detixoguiꞌa luëꞌ ca tadyaꞌa hue Diuzi quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ca naca biguleloꞌ canꞌ baoniaꞌ luëꞌ, huegaꞌnloꞌ bira gaca inëloꞌ hasta que idyin dza galo xcuidiꞌ quioꞌ. Uzun diꞌidzaꞌ canꞌ baoniaꞌ cati idyin dza. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Biz̃i yaca benꞌ nitaꞌ laliꞌa, rbezayaquëꞌ ta yero Zacarías rebanyaquëꞌ danꞌ rdzëtzegue Zacarías luꞌu idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Babero Zacarías luꞌu idaoꞌ rnabëꞌra bedapaꞌ ruꞌanëꞌ bira guca inënëꞌ. Biz̃i yaca benëꞌ gucabëꞌyaquëꞌ guca quiëꞌ ca benꞌ uxusa. Blëꞌënëꞌ tu ta blëꞌënëꞌ luꞌu idaoꞌ rnabëꞌra. Biz̃i señazi ruenëꞌ rluꞌenëꞌ benëꞌ bira guca inënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Babeyudyi ca tu dza uzunëꞌ luꞌu idaoꞌ rnabëꞌra, naꞌ bezëꞌ zeyoguëꞌ z̃an yuꞌu quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ude beyudyi guca canꞌ, z̃gulëꞌ Elisabet, banuꞌa z̃iꞌinëꞌ, begaꞌnnëꞌ zunëꞌ z̃an yuꞌu quienëꞌ lao gaꞌyoꞌ biuꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Naꞌra unëꞌ: “Ca ta bacuan bë Diuzi quiaꞌ ta bira inë yaca benëꞌ quiaꞌ bizinaquezi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Biz̃i bezu lao xopa biuꞌ bëꞌlë ángel Gabriel Elisabet diꞌidzaꞌ, beseꞌelaꞌ Diuzi lëbëꞌ tatula lao yedyi Nazaret ga nebaba Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Beseꞌelëꞌ lëbëꞌ ta tzanëꞌë tu nigula cuidiꞌ, benꞌ binehuebëꞌ beꞌmbyu. Lëlëbiꞌ laobiꞌ María. Lënigula naꞌ banapabiꞌ diꞌidzaꞌ len biꞌ lao José ta utzaganaꞌyacabiꞌ. Naca José z̃iꞌi suba rey David. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Biz̃i uyuꞌu ángel luꞌu yuꞌu ga zu María, unëꞌ rëbinëꞌ lëbiꞌ: ―Padiux, raxetzague Diuzi ca rueloꞌ. Zucazi Diuzi rnëꞌë luëꞌ. Huelaꞌiya Diuzi luëꞌ ca nurla yaca nigula tula. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Naꞌra cati blëꞌë María ángel, tu bebanzibiꞌ cabëꞌ gudyi ángel lëbiꞌ. Canaꞌ guquebiꞌ: “¿Bixquienꞌ una ángel nëꞌëdiꞌ canaꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Naꞌra una ángel rëbinëꞌ lëbiꞌ: ―María, bidzeboꞌ huacalëcazi Diuzi luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Naꞌra huayuꞌu bdaoꞌ byu luꞌu yuꞌuz̃ixoꞌ. Naꞌ ixuboꞌ laobiꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Huacabiꞌ benꞌ z̃e lao Diuzi. Huacabiꞌ z̃iꞌi Diuzi zu guibá. Hueꞌ Diuzi yelaꞌ rnabëꞌ quienëꞌ ta inabëꞌnëꞌ ca unabëꞌ xuzixtaꞌonëꞌ rey David. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Canaꞌ inabëꞌnëꞌ tuzioli yaca benꞌ Israel. Biyeyudyi yedu yelaꞌ rnabëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Biz̃i unaba María ángel: ―¿Como gaca quiaꞌ con ca baonaoꞌ, denꞌ binesuliaꞌ beꞌmbyu? ");
INSERT INTO zpcNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Biz̃i una ángel rëbinëꞌ María: ―Huayëzi Bichi Be quie Diuzi ga zuloꞌ. Ca idubi tu beo, canaꞌ huadubi yelaꞌ huaca quie Diuzi zu sibi luëꞌ. Lëbdaoꞌ su naꞌ, huacabiꞌ benꞌ naca laꞌiya quie Diuzi, huacabiꞌ z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Lëzi benꞌ diadza quioꞌ Elisabet, huazurë z̃iꞌinëꞌ baꞌalaꞌcazi banaquëꞌ benꞌ gula, benꞌ una yaca benëꞌ naquëꞌ nigula bidyi. Biz̃i naꞌa lao xopa biuꞌ banuꞌa z̃iꞌinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Para Diuzi bibi zëdi gaquenëꞌ tu ta huenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Naꞌra una María rëbibiꞌ ángel: ―Nacacazaꞌ benꞌ hue dyin quie Diuzi. Hueꞌencazi huegara Diuzi quiaꞌ cabëꞌ baonaoꞌ. Naꞌra bezaꞌ ángel zeyoguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lëdza naꞌ, laozaꞌte María ziobiꞌ yedyi ga zu yaꞌa, yedyi nebaba Judea. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Biz̃i cati bdyimbiꞌ ga zu lidyi Zacarías, naꞌ uyuꞌubiꞌ luꞌu yuꞌu rgapabiꞌ diuz̃i Elisabet. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Caora be Elisabet bgapa María lëbëꞌ diuz̃i, canaꞌ bda bdaoꞌ yuꞌu luꞌu yuꞌuz̃ixinëꞌ. Biz̃i caora naꞌ uyuꞌu Bichi Be quie Diuzi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Naꞌra unë Elisabet zidzo rëbinëꞌ María: ―Babëlaꞌiya Diuzi luëꞌ cala ca nurla yaca nigula. Lëzi babëlaꞌiyanëꞌ z̃iꞌiloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Nuz̃i nacaꞌ nëꞌëdiꞌ babidoꞌ idenaoꞌ nëꞌëdiꞌ? Nacoꞌ luëꞌ z̃naꞌ benꞌ iseꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ca naca bidoꞌ rgapoꞌ nëꞌëdiꞌ diuz̃i, caora naꞌ bda bdaoꞌ yuꞌu luꞌu yuꞌuz̃ixaꞌ redaohuebiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tadyaꞌa gula gaca quioꞌ baguleloꞌ con canꞌ baona Diuzi como danꞌ uzucazin diꞌidzaꞌ canꞌ baonanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Naꞌra una María: Raxedaꞌ rniaꞌ naca Diuzi benꞌ z̃e gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Redaohue guicho laxtaꞌohuaꞌ ca rue Diuzi, benꞌ ute usela nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Babeyëchiꞌlaꞌadyiꞌ Diuzi nëꞌëdiꞌ, nacaꞌ benꞌ hue dyin quienëꞌ. Huana yaca benꞌ zazaꞌ zanitaꞌ tahuen gula guca quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Naca Diuzi benꞌ rnabëꞌ lao yugulute. Tadyaꞌa gula bënëꞌ quiaꞌ. Naca Diuzi benꞌ laꞌiya. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tuzioli reyëchiꞌlaꞌadyiꞌnëꞌ yaca benꞌ rapalaꞌn lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bënëꞌ yelaꞌ huaca quienëꞌ. Pcaxonëꞌ yaca benꞌ rue z̃e cuine. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Begubëꞌ yelaꞌ rnabëꞌ quie yaca benꞌ rnabëꞌ, bëꞌnëꞌn yaca benꞌ yëchiꞌ, benꞌ ruzu diꞌidzaꞌ quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yaca benꞌ udue, bipcaꞌnnëꞌ leyaquëꞌ sin gaoyaquëꞌ, pero yaca benꞌ uñaꞌa, begaꞌnyaquëꞌ bigutaꞌ ta gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gucalënëꞌ yaca benꞌ yedyi Israel, yaca benꞌ quienëꞌ. Bigulalaꞌadyiꞌnëꞌ leyaquëꞌ beyëchiꞌlaꞌadyiꞌnëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Canaꞌ bënëꞌ ca naca diꞌidzaꞌ begaꞌnlënëꞌ xuzixtaꞌoro, bënëꞌ ca naca diꞌidzaꞌ begaꞌnlënëꞌ Abram len diadza quienëꞌ para tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Biz̃i guca lao tzona biuꞌ uzu María lidyi Elisabet. Ude naꞌ bezaꞌbiꞌ zeyobiꞌ lidyibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Biz̃i bdyin uyaꞌ biuꞌ ta su bdaoꞌ quie Elisabet, naꞌ uzu tu bidaoꞌ byu quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bëꞌ unezi yaca benꞌ diadza quienëꞌ, len yaca benꞌ lao yedyi baozu bdaoꞌ quienëꞌ, bdyinyaquëꞌ denaꞌyaquëꞌ lëbëꞌ ca tahuen gula guca quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Biz̃i guca lao xuna dza, bdyin yaca benꞌ uzu tu xëdyidaoꞌ cuin bdaoꞌ según ca naca ley quieyaquëꞌ. Canaꞌ guꞌunyaquëꞌ yeyuꞌeyaquëꞌ laobiꞌ ca lao xuzibiꞌ Zacarías. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Naꞌra una z̃naꞌ bdaoꞌ: ―Biyeyuꞌero laobiꞌ lao xuzibiꞌ. Hueꞌro laobiꞌ Juan. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Biz̃i unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―­­¿Bixquienꞌ ilaobiꞌ Juan? Ni tu yaca benꞌ diadza quioꞌ bizu yaca benꞌ lao canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Naꞌra bëyaquëꞌ seña unabayaquëꞌ xuzi bdaoꞌ ta ineziyaquëꞌ ca biz̃i reꞌen xuzibiꞌ ilaobiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Naꞌra unabanëꞌ tu yaga taꞌa bzuguëꞌ letra bzunëꞌ: “Laobiꞌ Juan.” Biz̃i tu begaꞌnziyaquëꞌ bebanyaquëꞌ canꞌ guca. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Biz̃i caora naꞌ benë Zacarías, ruenëꞌ Diuzi benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Begaꞌn yaca benꞌ lao yedyi tu bebanziyaquëꞌ. Naꞌ bëꞌlë yaca benꞌ nitaꞌ yedyi nebaba Judea laguedyiyaquëꞌ diꞌidzaꞌ cabëꞌ guca quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ca naca lao yugulu benꞌ unezi, gucayaquëꞌ pensari unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Ca biz̃i gaca quie xcuidiꞌ naꞌ? Canaꞌ unajëꞌ danꞌ talicazi bëlaꞌiya Diuzi lëbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Naꞌra Zacarías, benꞌ naca xuzi bdaoꞌ, du yuꞌunëꞌ Bichi Be quie Diuzi, unëꞌ cabëꞌ reꞌen Diuzi inënëꞌ. Lëlenaꞌ unëꞌ cani: ");
INSERT INTO zpcNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Benꞌ z̃e naca Diuzi quie benꞌ raꞌo, benꞌ Israel, como danꞌ babidëꞌ len raꞌo, nacaro benꞌ quienëꞌ, bapte pselanëꞌ raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Baoseꞌelëꞌ tu benꞌ ute usela raꞌo, benꞌ de yelaꞌ huaca quie. Lëlëbëꞌ naquëꞌ z̃iꞌi suba rey David, benꞌ naca siervo quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Canaꞌ naca diꞌidzaꞌ begaꞌnlë Diuzi xuzixtaꞌoro tiempote. Conlë yaca benꞌ udixogueꞌ diꞌidzaꞌ laꞌiya quienëꞌ, canaꞌ udixogueꞌ Diuzi binꞌ huenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Unëꞌ ute uselanëꞌ raꞌo quie yaca benꞌ rudie rdzaꞌ raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Unëꞌ yeyëchiꞌlaꞌadyiꞌnëꞌ yaca benꞌ naca xuzixtaꞌoro. Bigalaꞌadyiꞌnëꞌ huenëꞌ cabëꞌ diꞌidzaꞌ naca laꞌiya begaꞌnlënëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Lëscanꞌ para raꞌo, begaꞌnlënëꞌ raꞌo diꞌidzaꞌ. Canaꞌ naca diꞌidzaꞌ begaꞌnlë Diuzi xuzixtaꞌoro Abraham. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Unëꞌ ute uselëꞌ raꞌo bibi hue yaca benꞌ rudie rdzaꞌ raꞌo para naoro xnezëꞌ sin idzebiro. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Canaꞌ gacaro benꞌ hue quie lëbëꞌ, benꞌ naca laꞌiya quienëꞌ dza rdaro lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Naꞌra luëꞌ z̃iꞌinaꞌ, huacoꞌ benꞌ quixogueꞌ xtiꞌidzaꞌ Diuzi zu guibá, como danꞌ huabialaonezoꞌ lao benꞌ iseꞌelaꞌ Diuzi ta tzetixogueꞌloꞌ benëꞌ de que huida benꞌ iseꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Canaꞌ hueloꞌ cuenda inezi yaca benꞌ Israel cabëꞌ bë Diuzi ta ute uselanëꞌ raꞌo, yeziꞌz̃enëꞌ dulaꞌ xquia quiero. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tanun quie nedyëꞌë Xuziro Diuzi raꞌo reyëchiꞌlaꞌadyiꞌnëꞌ raꞌo, aoseꞌelëꞌ tu benꞌ uzioñeꞌe raꞌo desde guibá ga zuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Canaꞌ bë Diuzi cuenda tzioñeꞌe yaca benꞌ rda lao lato lao chula, yaca benꞌ ruen z̃udyi gatiyaca. Canaꞌ bë Diuzi quiero cuenda gacalënëꞌ raꞌo, yedzelero naoro xnezëꞌ, cueꞌ chizi luꞌu guicho laxtaꞌoro. Canaꞌ una Zacarías dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Biz̃i xcuidiꞌ guꞌunibiꞌ labezi, gucabiꞌ biꞌ huala, yuꞌubiꞌ Bichi Be quie Diuzi. Naꞌra uzubiꞌ lao lato ga bidyia yuꞌu hasta bdyin dza uzulaobiꞌ rguixogueꞌbiꞌ yaca benꞌ Israel xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Biz̃i lao dza naꞌ, uzu tu benꞌ naca gobierno, benꞌ rnabëꞌra laohuëꞌ Augusto. Naꞌ bënëꞌ mandado ta guca censo quie lao duz̃e yedyi con ga rnabëꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lëcenso naꞌ gucan tanëro caora uyo Cirenio gobernador quie yu nebaba Siria. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gucan quie lao yugulute yaca benꞌ con gatezi nitaꞌyaquëꞌ de yeyoyaquëꞌ lao yedyi ga goloyaquëꞌ tacuenda tzuꞌu laoyaquëꞌ lao lista. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Canaꞌ guca bero José yedyi Nazaret ga nebaba Galilea zioguëꞌ yedyi Belén ga nebaba Judea. Lëganꞌ naꞌ ga golo rey David como danꞌ naca José benꞌ diadza quie rey David. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bedyin José len María Belén para tzuꞌu laoyaquëꞌ lao lista. Naca María biꞌ banapalë diꞌidzaꞌ José baꞌalaꞌcazi banuꞌa z̃iꞌibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Biz̃i banitaꞌyaquëꞌ Belén naꞌ, bdyin dza golo bdaoꞌ quie María. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Biz̃i golo bdaoꞌ nëro quie María. Beyudyi naꞌ beziꞌyaquëꞌ bdaoꞌ betubiyaquëꞌbiꞌ laꞌariꞌ bexubayaquëꞌbiꞌ lao yaga z̃an yuꞌu ga yuꞌu bëdyihuaga. Canaꞌ guca quieyaquëꞌ, danꞌ bigutaꞌ lato luꞌu yuꞌu quie yaca benëꞌ gasiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Biz̃i gaꞌalaꞌ ga reꞌ Belén nitaꞌ yaca benꞌ rapa becoꞌ z̃iꞌilaꞌ. Regaꞌnlëyaquëꞌ becoꞌ z̃iꞌilaꞌ quieyaquëꞌ layela ta rapayaquëꞌbaꞌ yedu yela. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Lëcanaꞌ labdyinte tu ángel quie Diuzi ganꞌ nitaꞌ yaca benꞌ rapa becoꞌ z̃iꞌilaꞌ. Caora naꞌ bdyin yelaꞌ huaca quie Diuzi ulëchin xniꞌ ganꞌ nitaꞌyaquëꞌ. Lega begaꞌnyaquëꞌ bdzebiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Naꞌra una ángel rëbinëꞌ leyaquëꞌ: ―Bidzebile, porque nëꞌëdiꞌ nuꞌa tu diꞌidzaꞌ dyaꞌa nacan ta yedaohue lao yugulute benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lëlenaꞌ rniaꞌ leꞌe agolo tu bdaoꞌ yedyi Belén ga golo rey David. Lëbdaoꞌ naꞌ ute uselabiꞌ yaca benëchiꞌ. Bagolo benꞌ naca Cristo, benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ta inezile nacan tali ca rniaꞌ, huedzelele bdaoꞌ bdubibiꞌ laꞌariꞌ z̃ubabiꞌ lao yaga z̃an yuꞌu ga yuꞌu bëdyihuaga. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Biz̃i yesazi bdyinra yaca ángel zëra, benꞌ zaꞌ guibá ganꞌ zë ángel, ruejëꞌ Diuzi benꞌ z̃e unayaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Benꞌ z̃e Diuzi zu sibi! ¡Huaca tadyaꞌa gula quie yaca benꞌ nitaꞌ lao yedyi layu, benꞌ hue quie Diuzi! ");
INSERT INTO zpcNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Biz̃i babeyudyi naꞌ, beyëpi yaca ángel guibá. Naꞌ begaꞌn yaca benꞌ rapa becoꞌ z̃iꞌilaꞌ nayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Huayoro tzenaꞌro canꞌ guca yedyi Belén con ca baona Diuzi raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Canaꞌ uzaꞌyaquëꞌ zioyaquëꞌ taria bdyinyaquëꞌ ga zu María len José len bdaoꞌ z̃ubabiꞌ lao yaga z̃an yuꞌu ga yuꞌu yaca bëdyihuaga. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ca blëꞌëyaquëꞌ bdaoꞌ, canaꞌra bëꞌyaquëꞌ diꞌidzaꞌ con canꞌ gudyi ángel leyaquëꞌ cabëꞌ guca uzu bdaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ca naca be lao yugulute yaca benꞌ nitaꞌ ganꞌ, lega bebanyaquëꞌ canꞌ una yaca benꞌ rapa becoꞌ z̃iꞌilaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Biz̃i María nezizi luꞌu laxtaꞌonëꞌ ca naca una yaca benëꞌ. Canaꞌ gucanëꞌ pensari ca unajëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Naꞌ bezaꞌ yaca benꞌ rapa becoꞌ z̃iꞌilaꞌ zeyoyaquëꞌ rueyaquëꞌ Diuzi benꞌ z̃e ca ta beyaquëꞌ len ca ta blëꞌëyaquëꞌ. Bzucazi Diuzi diꞌidzaꞌ con ca una ángel gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Guca lao xuna dza bzuyaquëꞌ bdaoꞌ tu xëdyidaoꞌ ca costumbre quieyaquëꞌ. Biz̃i naꞌ pxubayaquëꞌ lao bdaoꞌ JESUS cabëꞌ una ángel ilaobiꞌ tu binehuaꞌa María bdaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Biz̃i baoyaꞌ dza ta yeyëri nigula según ca rna lëꞌë guichi yuꞌu ley quie Moisés. Caora naꞌ uzaꞌyaquëꞌ ziolëyaquëꞌ bdaoꞌ ciudad Jerusalén ta uluꞌeyaquëꞌ bdaoꞌ pxuzi luꞌu idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bëyaquëꞌ canaꞌ bzuyaquëꞌ diꞌidzaꞌ con ca naca ley quie Diuzi yuꞌu lëꞌë guichi. Cani rnan lëꞌë guichi: “Naca yugulu bdaoꞌ byu nëro biꞌ naca laꞌiya lao Diuzi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Lenaꞌ uyoyaquëꞌ yehuaꞌayaquëꞌ biu ta uzio pxuzi ren quiebaꞌ lao becugo ga zu idaoꞌ rnabëꞌra. Bzuyaquëꞌ diꞌidzaꞌ cabëꞌ rguixogueꞌn lëꞌë guichi laꞌiya quie Diuzi cani: “Reyaꞌalaꞌ tzehuaꞌale lao pxuzi tu pare biu lasi, naꞌ chi bizu biu lasi, huaꞌale chopa paloma daoꞌ.” Canaꞌ rnën lëꞌë guichi. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lëtiempo naꞌ uzu tu benꞌ lao Simeón zunëꞌ Jerusalén. Naquëꞌ benꞌ dyaꞌa, rapalaꞌnnëꞌ Diuzi, rbezanëꞌ dza guida benꞌ iseꞌelaꞌ Diuzi, benꞌ ute usela benꞌ Israel. Yuꞌucazi Simeón Bichi Be quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Babzioñeꞌe Bichi Be quie Diuzi lëbëꞌ de que tu binegatinëꞌ hualëꞌënëꞌ benꞌ naca Cristo, benꞌ iseꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Conlë Bichi Be quie Diuzi ziolë Simeón luꞌu idaoꞌ rnabëꞌra. Biz̃i cati ziolëyaquëꞌ bdaoꞌ luꞌu idaoꞌ rnabëꞌra ta uzuyaquëꞌ diꞌidzaꞌ con ca na lëꞌë guichi ley, ");
INSERT INTO zpcNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","lëhora naꞌ uz̃iꞌ Simeón bdaoꞌ bnidaguëꞌ bdaoꞌ uxubanëꞌbiꞌ lao z̃ichonëꞌ bëguëꞌ Diuzi benꞌ z̃e unëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Xuzaꞌ Diuzi, huaca usanloꞌnëꞌ gatiaꞌ cueꞌ chizi luꞌu guicho laxtaꞌohuaꞌ, danꞌ babzuloꞌ diꞌidzaꞌ con ca unaoꞌ nëꞌëdiꞌ, nacaꞌ benꞌ rue ca mandado reꞌenloꞌ huaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Conlë laohuaꞌ bablëꞌëdaꞌ benꞌ ute usela yaca benëchiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aoseꞌeloꞌnëꞌ bidëꞌ lao yedyi layu cuenda ilëꞌë yaca benëchiꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Naquëꞌ ca xniꞌ guiꞌ useniꞌ ta ilëꞌë benꞌ rda lao lato lao chula, yaca benꞌ binaca benꞌ Israel. Nun quienëꞌ gapalaꞌn yaca benꞌ nitaꞌ lao yedyi layu yaca benꞌ Israel, yaca benꞌ naca benꞌ quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Naꞌ beban José len z̃naꞌ bdaoꞌ cabëꞌ una Simeón quie bdaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Naꞌra bëlaꞌiya Simeón bdaoꞌ gudyinëꞌ María z̃naꞌ Jesús: ―Naca laza xcuidiꞌ quioꞌ usanlaꞌadyiꞌ Diuzi benꞌ Israel, yaca benꞌ bichezilaꞌadyiꞌ lëbiꞌ. Lëzi nacarë lazabiꞌ yeziꞌ Diuzi benꞌ Israel, yaca benꞌ chezilaꞌadyiꞌ lëbiꞌ. Huaca quiebiꞌ bichezilaꞌadyiꞌ benꞌ zë lëbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Lëcanaꞌ uluꞌen ca naca pensari yuꞌu luꞌu laxtaꞌo quie quie yaca benëꞌ. Denꞌ para quioꞌ luëꞌ, huacan bayëchiꞌ. Huacan ca quie chezi tu espada huen chopa laꞌa laxtaꞌoloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Lëganꞌ naꞌ uzu tu nigula laohuëꞌ Ana. Udixogueꞌrënëꞌ diꞌidzaꞌ laꞌiya quie Diuzi. Banaquëꞌ benꞌ gula, naquëꞌ z̃iꞌi Fanuel, benꞌ diadza quie Aser. Nenacatëꞌ cuidiꞌ uz̃iꞌ xquiuhuëꞌ lëbëꞌ. Uzulënëꞌ xquiuhuëꞌ lao gadyi iza, ude naꞌ guti xquiuhuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Biz̃i tu litzaꞌ begaꞌnnëꞌ napëꞌ tapa galo tapa iza. Pero bipsanlaꞌadyiꞌnëꞌ quie idaoꞌ rnabëꞌra. Zucazëꞌ te dza len rtzeꞌ rulidzëꞌ Diuzi ruenëꞌ ubasi. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Canaꞌ bdyin Ana ganꞌ zëyaquëꞌ rëbinëꞌ Diuzi diuxcaleloꞌ. Naꞌra uzulaohuëꞌ rguixogueꞌnëꞌ ca naca quie bdaoꞌ Jesús para yaca benꞌ nitaꞌ rbeza dza guida benꞌ iseꞌelaꞌ Diuzi, benꞌ ute usela yaca benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Babeyudyi guca lao yugulute cabëꞌ mandado rue ley quie Diuzi, naꞌra bezaꞌyaquëꞌ zeyoyaquëꞌ estado Galilea bedyinyaquëꞌ yedyi quieyaquëꞌ Nazaret. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naꞌ biz̃i guꞌuni bdaoꞌ, gucabiꞌ biꞌ huala, biꞌ rioñeꞌe. Bëlaꞌiya Diuzi lëbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yugu iza rio José len z̃naꞌ Jesús ciudad Jerusalén ga raꞌalaꞌ lani pascua ta rezalaꞌadyiꞌ yaca benꞌ Israel dza uzaꞌ xuzixtaꞌoyaquëꞌ nación Egipto. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cati uyaꞌ Jesús lao chipchopa iza, uyolëbiꞌ xuzi z̃naꞌbiꞌ lani ciudad Jerusalén con ca naca biuꞌ benëbiꞌ quieyaquëꞌ rueyaquëꞌ lani pascua. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Biz̃i babeyudyi lani, bezaꞌ José len z̃naꞌ Jesús zeyoyaquëꞌ bigucabëꞌyaquëꞌ chi begaꞌn Jesús ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Gucayaquëꞌ pensari zezaꞌ Jesús len yaca benꞌ zezaꞌ uyorë lani. Canaꞌ guca lao tu dza bezaꞌyaquëꞌ. Caora rnaꞌyaquëꞌ ganu Jesús zezaꞌ, udayaquëꞌ rguiloyaquëꞌbiꞌ lado diadza quieyaquëꞌ, len yaca benꞌ nubëꞌyaquëꞌ, denꞌ ganu Jesús zezaꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nunu bedzeleyaquëꞌ. Naꞌ bezaꞌyaquëꞌ zeyoyaquëꞌ ciudad Jerusalén tatula ta yeguiloyaquëꞌbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Biz̃i guca lao tzona dza naꞌ, bedzeleyaquëꞌbiꞌ luꞌu idaoꞌ rnabëꞌra. Reꞌbiꞌ lado yaca benꞌ rusëdi diꞌidzaꞌ yuꞌu luꞌu guichi laꞌiya quie Diuzi. Rzënagabiꞌ ca rnayaquëꞌ rnababiꞌ leyaquëꞌ tu chopa diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ca naca yugulu benꞌ rzënaga canꞌ nabiꞌ, tu begaꞌnziyaquëꞌ bebanziyaquëꞌ ca naca yelaꞌ rioñeꞌe quiebiꞌ, lëzi bebanziyaquëꞌ ca naca diꞌidzaꞌ bedyiꞌibiꞌ gudyibiꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Biz̃i caora blëꞌë xuzi z̃naꞌbiꞌ lëbiꞌ, tu begaꞌnziyaquëꞌ bebanyaquëꞌ. Naꞌra unë z̃naꞌbiꞌ rëbinëꞌ lëbiꞌ: ―Ziꞌinaꞌ, ¿bixquienꞌ baoꞌ canaꞌ? Rdëbindoꞌ quioꞌ. Aodaliaꞌ xuzoꞌ reguilondoꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Canaꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―¿Bixquienꞌ rdale reguilole nëꞌëdiꞌ? ¿Binezile ruen zi uzuaꞌ diꞌidzaꞌ huaꞌ mandado quie Xuzaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Biz̃i leyaquëꞌ biuyoñeꞌeyaquëꞌ canꞌ una Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Canaꞌ bezaꞌyaquëꞌ zeyoyaquëꞌ yedyi Nazaret, pero ralecazi Jesús quie xuzi z̃naꞌbiꞌ. Naꞌ z̃naꞌbiꞌ nudzeꞌnëꞌ luꞌu guicho laxtaꞌonëꞌ cabëꞌ bë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ca naca Jesús naꞌ guꞌunibiꞌ uyaꞌabiꞌ pensari. Blëꞌë Diuzi lëbiꞌ nacabiꞌ biꞌ huen. Lëzi blëꞌërë yaca benëꞌ nacabiꞌ biꞌ huen. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Biz̃i guca lao chiꞌinuꞌ iza uzu tu benꞌ lao Tiberio, naquëꞌ gobierno rnabëꞌra. Caora naꞌ uzurë itu benꞌ lao Poncio Pilato, naquëꞌ gobierno quie estado Judea. Lëzi uzurë itu benꞌ lao Herodes, naquëꞌ gobierno quie estado Galilea. Lëzi uzurë tu bichi Herodes, benꞌ lao Felipe, naquëꞌ gobierno quie yu nebaba Iturea len yu nebaba Traconite. Lëzi uzurë itu benꞌ lao Lisanias, naquëꞌ gobierno quie yu nebaba Abilinia. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Lëscanꞌ lëiza naꞌ, naca Anás len Caifás yaca pxuzi rnabëꞌra. Biz̃i Diuzi bëꞌnëꞌ tu diꞌidzaꞌ Juan, z̃iꞌi Zacarías. Naꞌ zu Juan lao lato ga bidyia yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Canaꞌ uyo Juan lao duz̃e ruꞌa yao Jordán unëꞌ rëbinëꞌ benëꞌ: “Reyaꞌalaꞌ yetzaꞌle pensari quiele cuenda yeziꞌz̃e Diuzi dulaꞌ xquia quiele, canaꞌra huaꞌ laole.” ");
INSERT INTO zpcNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Gucan canꞌ ca bzu Isaías diꞌidzaꞌ lëꞌë guichi laꞌiya quie Diuzi dza naꞌ. Naquëꞌ benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi unëꞌ: Huazu benꞌ naꞌ lao lato dachi ga bidyia yuꞌu, huanëꞌ zidzo rëbinëꞌ laguedyinëꞌ caniga: “Huele hueluba neza quiele cuenda huida benꞌ naca xaꞌnro, usalole tu neza li. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yesedzaꞌle ga naca pozo, yeyuele baꞌa ga naca loma, yebiolile ga naca neza yuco, yupaꞌale ga naca neza stëbi. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Canaꞌ ilëꞌë lao yugulute benëchiꞌ ca hue Diuzi ta ute uselanëꞌ leyaquëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Naꞌra cati bdyin yaca benëꞌ ga zë Juan ta hueꞌnëꞌ laoyaquëꞌ, lëscanꞌ bdyinrë yaca benꞌ rnabëꞌ quieyaquëꞌ. Canaꞌ una Juan rëbinëꞌ leyaquëꞌ: ―¡Ca naca bëla bia mala, canaꞌ nacarële! ¿Ca nuz̃i udixogueꞌ leꞌe ta ilale ca naca tu castigo huala gula bazaꞌ bago ilëꞌële? ");
INSERT INTO zpcNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ulehue quiele tadyaꞌa cuenda uluꞌen talicazi aptzaꞌle pensari quiele. Bira inale: “Bihue Diuzi raꞌo castigo nun quie nacaro z̃iꞌi suba Abraham.” Porque rniaꞌ leꞌe, hasta len yo niga huazaqueꞌ hue Diuzi yaca benꞌ naca z̃iꞌisuba Abraham. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ca naca quie yaga birbia taz̃ixi, canaꞌ naca quiele. Bade yebandyo puesto ta ichugon yaca yaga birbia taz̃ixi tzuꞌun tzeina laguiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Naꞌra unaba yaca benëꞌ nayaquëꞌ: ―¿Cabiz̃i reꞌenloꞌ huendoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Naꞌra una Juan rëbinëꞌ leyaquëꞌ: ―Chi de chopa cueꞌ z̃abale, ulesiꞌ tu cueꞌn ulehueꞌn benꞌ bide z̃abe. Lëscanꞌ nu yelaꞌ huao quiele, ulehueꞌn benꞌ bide ta gao. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Biz̃i bdyinrë yaca benꞌ huequiz̃u ta hueꞌ Juan laoyaquëꞌ. Biz̃i unayaquëꞌ rëbiyaquëꞌ Juan: ―Maestro, ¿cabiz̃i ca huendoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Naꞌra una Juan rëbinëꞌ leyaquëꞌ: ―Ca tu ruezi mandado lao ley uquiz̃ule yaca benëꞌ, bira uquiz̃uleyaquëꞌ de mazara. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Lëzi unabarë bala yaca benꞌ naca soldado unayaquëꞌ: ―Biz̃i nëtoꞌ, ¿cabiz̃i ca huendoꞌ? Naꞌra una Juan rëbinëꞌ leyaquëꞌ: ―Bicubale bicuanle quie benëꞌ. Ni ta utzebile gaole leyaquëꞌ xquia, chi bibi rueyaquëꞌ. Lëscanꞌ ulechezilaꞌadyiꞌ ca tu ta raz̃ule. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Naꞌ biz̃i yaca benëꞌ raqueyaquëꞌ Juan naquëꞌ benꞌ Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Naꞌra una Juan rëbinëꞌ lao yuguluteyaquëꞌ: ―Tali nëꞌëdiꞌ ruꞌa laole con nisa, pero zazaꞌra benꞌ udzeꞌ Bichi Be quie Diuzi luꞌu guicho laxtaꞌo benꞌ rue quie xtiꞌidzaꞌ Diuzi. Pero benꞌ birue quie xtiꞌidzaꞌ Diuzi, udzeꞌnëꞌ lëjëꞌ lao guiꞌ gabila. Dera yelaꞌ rnabëꞌ quiëꞌ ca nëꞌëdiꞌ. Tanto naquëꞌ benꞌ belao, ni lëꞌëtiꞌ bibi zacaꞌ ni siquiera biyeyaz̃ogaꞌ cuiogaꞌ guidi yuꞌu niꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Bazënëꞌ beladzoꞌ ta ulubëꞌ trigo. Te naꞌ yetupëꞌ trigo yeziꞌtzaꞌonëꞌn. Lëzi utuparëꞌ guixiꞌ uzalanëꞌn laguiꞌ ga tzeina lao guiꞌ bireyula. ―Canaꞌ una Juan gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Lëscanꞌ gudyinëꞌ leyaquëꞌ diꞌidzaꞌ zëra unëꞌ udixogueꞌnëꞌ yaca benëꞌ diꞌidzaꞌ laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lëzi udilarëꞌ Herodes, benꞌ naca gobierno, danꞌ bezulënëꞌ Herodías z̃gula bichinëꞌ Felipe. Lëzi udilarënëꞌ lëbëꞌ danꞌ bëranëꞌ tamala. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Naꞌ biz̃i Herodes, lao laza uzënaguëꞌ quie Juan, bërëlëꞌ mazara tamala, bdzeꞌguëꞌ Juan luꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ca zatzio Juan luꞌu dyiguiba, cati nezënëꞌ ruꞌenëꞌ lao benëꞌ, lëzi bëꞌnëꞌ lao Jesús. Ca zë Jesús rlidzëꞌ Diuzi, canaꞌ uyalo guibá. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Biz̃i caora naꞌ ga zë Jesús, uyëzi Bichi Be quie Diuzi ca rëzi biu. Naꞌra unë Diuzi ga zuëꞌ guibá unëꞌ: ―Z̃iꞌinaꞌ luëꞌ. Nedyëꞌëdaꞌ luëꞌ. Lega redaohuedaꞌ ca rueloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús bazunëꞌ ca du galobechi iza cati uzulaonëꞌ udixogueꞌnëꞌ diꞌidzaꞌ laꞌiya quie Diuzi. Según ca una yaca benëꞌ naquëꞌ z̃iꞌi José, dechanꞌ naquëꞌ z̃iꞌi suba Elí, benꞌ naca xuzi María. ");
INSERT INTO zpcNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Naꞌ naca Elí z̃iꞌi Matat, naꞌ naca Matat z̃iꞌi Leví, naꞌ naca Leví z̃iꞌi Melqui, naꞌ naca Melqui z̃iꞌi Jana, naꞌ naca Jana z̃iꞌi José, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","naꞌ naca José z̃iꞌi Matatías, naꞌ naca Matatías z̃iꞌi Amós, naꞌ naca Amós z̃iꞌi Nahum, naꞌ naca Nahum z̃iꞌi Esli, naꞌ naca Esli z̃iꞌi Nagai, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","naꞌ naca Nagai z̃iꞌi Maat, naꞌ naca Maat z̃iꞌi Matatías, naꞌ naca Matatías z̃iꞌi Semei, naꞌ naca Semei z̃iꞌi José, naꞌ naca José z̃iꞌi Judá, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","naꞌ naca Judá z̃iꞌi Joana, naꞌ naca Joana z̃iꞌi Resa, naꞌ naca Resa z̃iꞌi Zorobabel, naꞌ naca Zorobabel z̃iꞌi Salatiel, naꞌ naca Salatiel z̃iꞌi Neri, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","naꞌ naca Neri z̃iꞌi Melqui, naꞌ naca Melqui z̃iꞌi Adi, naꞌ naca Adi z̃iꞌi Cosam, naꞌ naca Cosam z̃iꞌi Elmodam, naꞌ naca Elmodam z̃iꞌi Er, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","naꞌ naca Er z̃iꞌi Josué, naꞌ naca Josué z̃iꞌi Eliezer, naꞌ naca Eliezer z̃iꞌi Jorim, naꞌ naca Jorim z̃iꞌi Matat, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","naꞌ naca Matat z̃iꞌi Leví, naꞌ naca Leví z̃iꞌi Simeón, naꞌ naca Simeón z̃iꞌi Judá, naꞌ naca Judá z̃iꞌi José, naꞌ naca José z̃iꞌi Jonán, naꞌ naca Jonán z̃iꞌi Eliaquim, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","naꞌ naca Eliaquim z̃iꞌi Melea, naꞌ naca Melea z̃iꞌi Mainán, naꞌ naca Mainán z̃iꞌi Matata, naꞌ naca Matata z̃iꞌi Natán, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","naꞌ naca Natán z̃iꞌi rey David, naꞌ naca rey David z̃iꞌi Isaí, naꞌ naca Isaí z̃iꞌi Obed, naꞌ naca Obed z̃iꞌi Booz, naꞌ naca Booz z̃iꞌi Salmón, naꞌ naca Salmón z̃iꞌi Naasón, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","naꞌ naca Naasón z̃iꞌi Aminadab, naꞌ naca Aminadab z̃iꞌi Aram, naꞌ naca Aram z̃iꞌi Esrom, naꞌ naca Esrom z̃iꞌi Fares, naꞌ naca Fares z̃iꞌi Judá, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","naꞌ naca Judá z̃iꞌi Jacob, naꞌ naca Jacob z̃iꞌi Isaac, naꞌ naca Isaac z̃iꞌi Abraham, naꞌ naca Abraham z̃iꞌi Taré, naꞌ naca Taré z̃iꞌi Nacor, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","naꞌ naca Nacor z̃iꞌi Serug, naꞌ naca Serug z̃iꞌi Ragau, naꞌ naca Ragau z̃iꞌi Peleg, naꞌ naca Peleg z̃iꞌi Heber, naꞌ naca Heber z̃iꞌi Sala, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","naꞌ naca Sala z̃iꞌi Cainán, naꞌ naca Cainán z̃iꞌi Arfaxad, naꞌ naca Arfaxad z̃iꞌi Sem, naꞌ naca Sem z̃iꞌi Noé, naꞌ naca Noé z̃iꞌi Lamec, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","naꞌ naca Lamec z̃iꞌi Matusalén, naꞌ naca Matusalén z̃iꞌi Enoc, naꞌ naca Enoc z̃iꞌi Jared, naꞌ naca Jared z̃iꞌi Mahalaleel, naꞌ naca Mahalaleel z̃iꞌi Cainán, ");
INSERT INTO zpcNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","naꞌ naca Cainán z̃iꞌi Enós, naꞌ naca Enós z̃iꞌi Set, naꞌ naca Set z̃iꞌi Adán, naꞌ naca Adán z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Du yuꞌu Jesús Bichi Be quie Diuzi zeyoguëꞌ ruꞌa yao Jordán tatula. Pquiëꞌ Bichi Be quie Diuzi lëbëꞌ lao lato ga bidyia yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Biz̃i guca uzuguëꞌ lao lato lao chopa galo dza. Naꞌ uyo xanꞌ taxiꞌibiꞌ ganꞌ zënëꞌ reꞌennan ta iquixi Jesús huenëꞌ tamala. Ca tu lao dza uzunëꞌ naꞌ, biudaonëꞌ lega uduenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Naꞌra una xanꞌ taxiꞌibiꞌ rëbin lëbëꞌ: ―Chi dulaꞌadyoꞌ nacoꞌ z̃iꞌi Diuzi, bë yo niga iyacan yëta xtila. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Naꞌra rëbi Jesús len: ―Lëꞌë guichi laꞌiya quie Diuzi rnan caniga: “Cala yelaꞌ huaozi uteban yaca benëꞌ, lëscanꞌ ca naca diꞌidzaꞌ rnë Diuzi, utebannan leyaquëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Biz̃i naꞌa, xanꞌ taxiꞌibiꞌ uquiëꞌn lëbëꞌ lao yaꞌa sibi, naꞌ bluꞌen lëbëꞌ lao duz̃e yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Biz̃i una xanꞌ taxiꞌibiꞌ rëbin lëbëꞌ: ―Gunaꞌ luëꞌ lao yugulu yelaꞌ rnabëꞌ quie yedyi layu niga nun quie nacan ladyinaꞌa. Naꞌ huaꞌa len nu benꞌ raxedaꞌ huaꞌa len. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chi quitzo z̃iboꞌ laohuaꞌ tzionlaꞌadyoꞌ nëꞌëdiꞌ, naꞌ gunaꞌ lao yuguluten luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Naꞌra una Jesús rëbinëꞌn: ―Bebigaꞌ tzalaꞌla, Satanás, porque lëꞌë guichi ga yuꞌu diꞌidzaꞌ laꞌiya quie Diuzi rnan caniga: “Tuzi Diuzi tzionlaꞌadyiꞌro uzuro diꞌidzaꞌ ca mandado ruenëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ude naꞌ uquiëꞌ xanꞌ taxiꞌibiꞌ lëbëꞌ ciudad Jerusalén, urëlëna lëbëꞌ guicho lun idaoꞌ rnabëꞌra. Naꞌ unan rëbin lëbëꞌ: ―Chi dulaꞌadyoꞌ nacoꞌ z̃iꞌi Diuzi, uxiti ganꞌ niga para layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bigacoꞌ ziꞌ iguinoloꞌ layu como canaꞌ rnan lëꞌë guichi laꞌiya quie Diuzi nan: Iseꞌelaꞌ Diuzi ángel quienëꞌ ta inaꞌyaquëꞌ luëꞌ ta bibi gaca quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Hueyuxuyaquëꞌ luëꞌ ta bibi gaca quioꞌ, ni yo bihuenan ziꞌ niꞌaloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Naꞌra una Jesús rëbinëꞌn: ―Lëzi rnarën lëꞌë guichi laꞌiya rnan: “Bihuenële Diuzi bizinaquezi chi uzunëꞌ, chi biuzunëꞌ diꞌidzaꞌ cabëꞌ unëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Biz̃i bira ubin xanꞌ taxiꞌibiꞌ bihuena ta iquixi Jesús huenëꞌ tamala, canaꞌ guca bebigaꞌn zeyon bibënan Jesús zëdi tu chiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Biz̃i Jesús, du yuꞌunëꞌ Bichi Be quie Diuzi, zeyoguëꞌ bedyinnëꞌ estado Galilea. Canaꞌ guca gudyi yaca benꞌ laguedyiyaquëꞌ quie quie yedyi reꞌ gaꞌalaꞌ cabëꞌ rue Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Psëdinëꞌ leyaquëꞌ luꞌu idaoꞌ con ga yedyi uyoguëꞌ. Yuguluyaquëꞌ udapalaꞌnjëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Naꞌra beyo Jesús yedyi Nazaret ga bgulanëꞌ. Biz̃i dza saodo, dza huezilaꞌadyiꞌ quieyaquëꞌ, uyuꞌunëꞌ luꞌu idaoꞌ sinagoga ca rionëꞌ yugu dza huezilaꞌadyiꞌ. Naꞌ uzulinëꞌ rlabëꞌ lëꞌë guichi ga yuꞌu diꞌidzaꞌ laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Naꞌ bëꞌyaquëꞌ lëbëꞌ guichi laꞌiya ta bzu profeta Isaías. Caora blinëꞌn, naꞌ yetilëꞌ ga rnan cani: ");
INSERT INTO zpcNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Yuꞌucazi Bichi Be quie Diuzi nëꞌëdiꞌ nun quie danꞌ ulionëꞌ nëꞌëdiꞌ ta quixoguiꞌa diꞌidzaꞌ laꞌiya quienëꞌ yaca benꞌ yëchiꞌ. Lëzi useꞌelaꞌrëꞌ nëꞌëdiꞌ ta yeyuez̃iaꞌ yaca benꞌ raca bayëchiꞌ quie, lëzi ta huaꞌ libre ca benꞌ nao xquia quieyaquëꞌ leyaquëꞌ, lëzi ta yelëꞌë yaca benꞌ nechula laohue, lëzi ta ute uselaꞌ yaca benꞌ baoz̃aca ziꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","lëzi ta quixoguiꞌa yaca benëꞌ babdyin dza hue Diuzi tu cule z̃e quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ude naꞌ betubinëꞌ guichi yuꞌu diꞌidzaꞌ laꞌiya quie Diuzi, beyuꞌenëꞌn benꞌ naca cuenda luꞌu idaoꞌ sinagoga, naꞌ bebeꞌnëꞌ. Biz̃i yugulu yaca benꞌ yuꞌu luꞌu idaoꞌ sinagoga, begaꞌnziyaquëꞌ rebanyaquëꞌ rnaꞌyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Canaꞌ unëꞌ gudyinëꞌ leyaquëꞌ: ―Ca naca naꞌa, babzun diꞌidzaꞌ lëꞌë guichi bablabaꞌ bele. ―Canaꞌ unëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Naꞌra yugulu benëꞌ unëyaquëꞌ dyaꞌa quienëꞌ, tu begaꞌnyaquëꞌ bebanziyaquëꞌ ca naca diꞌidzaꞌ dyaꞌa gula unë Jesús. Naꞌ biz̃i unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Cala biꞌ niga z̃iꞌi José? ");
INSERT INTO zpcNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tali huanale nëꞌëdiꞌ cani: “Chi tali nacoꞌ benꞌ rue milagro, bë itun ni ilëꞌëndoꞌ.” Lëscanꞌ inale nëꞌëdiꞌ: “Ca ta babendoꞌ baoꞌ milagro yedyi Capernaum, canaꞌ bërë itun niga yedyi quioꞌ ilëꞌëndoꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Biz̃i nernë Jesús rëbinëꞌ leyaquëꞌ: ―Tali ca rniaꞌ leꞌe, con gatezi de yedyi rda benꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi, hualëꞌë yaca benëꞌ lëbëꞌ dyaꞌa. Naꞌ biz̃i benꞌ lao yedyi quienëꞌ biilëꞌëyaquëꞌ lëbëꞌ dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tali ca rniaꞌ leꞌe, unitaꞌ zë nigula guti xquiuhue yedyi quie yaca benꞌ Israel dza naꞌ caora uzu profeta Elías. Lëdza naꞌ biben nisayo lao tzona iza yugatzo. Lega ubin huala gula gutaꞌ lao yedyi quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero biuseꞌelaꞌ Diuzi Elías con garla nitaꞌ nigula guti xquiuhue. Tuzi yedyi Sarepta, naꞌ uzu tu nigula guti xquiuhue, lëganꞌ naꞌ useꞌelaꞌ Diuzi Elías ga regaꞌnnan gaꞌalaꞌ para yedyi Sidón. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Lëzirë unitaꞌ zë benꞌ yuꞌu yelaꞌ hueꞌ ca mal de pindo yedyi Israel caora uzurë benꞌ naca profeta Eliseo dza naꞌ. Naꞌra lëdza naꞌ nurla nuyaca benꞌ yuꞌu yelaꞌ hueꞌ ca mal de pindo beyaca. Tuzi Naamán, benꞌ zaꞌ yu nebaba Siria, lëbenꞌ naꞌ beyaca. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ca naca yaca benꞌ yuꞌu luꞌu idaoꞌ sinagoga, bdzaꞌtzegueyaquëꞌ babeyaquëꞌ canꞌ una Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Naꞌra uzuliyaquëꞌ bëxoyaquëꞌ lëbëꞌ lao yedyi uquiëꞌyaquëꞌ lëbëꞌ lao yaꞌa zu cuëta yedyi ta utulayaquëꞌ lëbëꞌ z̃anle. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero tu brozi Jesús ladoyaquëꞌ zioguëꞌ ga tula. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Biz̃i naꞌ bdyin Jesús yedyi Capernaum ga nebaba Galilea. Lëganꞌ naꞌ uyuꞌunëꞌ idaoꞌ sinagoga ta psëdinëꞌ yaca benëꞌ dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Biz̃i yaca benëꞌ tu bebanziyaquëꞌ ca diꞌidzaꞌ rnëꞌ rusëdinëꞌ leyaquëꞌ como danꞌ cabëꞌ rna benꞌ rnabëꞌ, canaꞌ unëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Biz̃i luꞌu idaoꞌ sinagoga zë tu benꞌ yuꞌu bichi be xiꞌibiꞌ. Lëbenꞌ naꞌ uredyiyaꞌnëꞌ unëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Psan nëtoꞌ. ¿Bixquienꞌ zaoꞌ ta hueloꞌ nëtoꞌ zëdi? Jesús benꞌ yedyi Nazaret luëꞌ. ¿Cala zaoꞌ udyiaguiꞌloꞌ nëtoꞌ? Nubëꞌdaꞌ luëꞌ nacoꞌ benꞌ laꞌiya, benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Naꞌra udila Jesús bichi be xiꞌibiꞌ rëbinëꞌn: ―¡Chizi, bero benꞌ naꞌ ganꞌ yuꞌuloꞌ! Caora naꞌ bero bichi be xiꞌibiꞌ beꞌmbyu ganꞌ yuꞌuna, bguꞌunnëꞌ layu, denëꞌ zaquëꞌlao yaca benꞌ nitaꞌ rnaꞌ. Naꞌ beron zeyon, ni lëꞌëtiꞌ bibi ziꞌ guquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Naꞌ begaꞌn yuguluyaquëꞌ bdzebiyaquëꞌ nayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Cabiz̃i una benꞌ niga? De yelaꞌ rnabëꞌ quienëꞌ rnabëꞌnëꞌ yaca taxiꞌibiꞌ reron ga yuꞌuyacan benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Naꞌ canaꞌ guca unezi yaca benëꞌ nitaꞌ lao duz̃e yedyi regaꞌn gaꞌalaꞌ cabëꞌ bë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Biz̃i babero Jesús luꞌu idaoꞌ sinagoga zioguëꞌ z̃an yuꞌu quie Simón. Biz̃i benꞌ gula quie Simón yuꞌunëꞌ z̃la huala. Naꞌra unabayëchiꞌyaquëꞌ lao Jesús ta tzanëꞌë lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Naꞌra ude Jesús zionëꞌ ganꞌ de benꞌ yuꞌu tala huala. Caora udila Jesús xanꞌ z̃la, canaꞌ beron, laoyasatenëꞌ bëꞌ laze ta udaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bazaꞌ rdzeꞌ yehuaꞌa yaca benëꞌ benꞌ yuꞌu nacala yelaꞌ hueꞌ ganꞌ zë Jesús. Naꞌra caora bdaꞌ nëꞌë quie quieyaquëꞌ, canaꞌ beyacayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ca naca yaca benꞌ raca z̃hueꞌ, lëzirë bero bichi be xiꞌibiꞌ rbedyiyaꞌyacan nayacan rëbiyacan Jesús: ―Luëꞌ nacoꞌ z̃iꞌi Diuzi. Biz̃i udila Jesús leyacan bibëꞌnëꞌ lato inëyacan danꞌ neziyacan lëbëꞌ naquëꞌ Cristo, benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Baoyaniꞌ dza tula, bro Jesús zioguëꞌ ruꞌa yedyila ta sunëꞌ tuzëꞌ. Biz̃i yaca benëꞌ reguiloyaquëꞌ lëbëꞌ naꞌ bedzeleyaquëꞌ ganꞌ zënëꞌ. Reꞌenyaquëꞌ yegaꞌn Jesús sunëꞌ lënëꞌ leyaquëꞌ ganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―De tzaꞌa yedyi tula ta tzetixoguiꞌa yaca benëꞌ ca rnabëꞌ Diuzi reyaꞌalaꞌ hue quieyaquëꞌ xtiꞌidzëꞌ. Quie lenaꞌ useꞌelaꞌ Diuzi nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Canaꞌ uyo Jesús udixogueꞌnëꞌ xtiꞌidzaꞌ Diuzi luꞌu idaoꞌ sinagoga quie yaca yedyi estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Biz̃i bdyin dza uzëguëꞌ ruꞌa nisa lagun Genesaret. Lega bdyin yaca benꞌ zë gula hasta rquidiꞌyaquëꞌ lëbëꞌ danꞌ reꞌenyaquëꞌ uzënagayaquëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Naꞌra blëꞌë Jesús chopa barco dachi zën bago ruꞌa nisa. Bero yaca benꞌ rze bela luꞌun, reꞌyaquëꞌ ruꞌa lagun rguibiyaquëꞌ duyëxo ta rzeyaquëꞌ bela. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Naꞌ uyuꞌu Jesús tu luꞌu barco. Biz̃i barco naꞌ nacan quie Simón. Naꞌ gudyinëꞌ Pedro ta udyiganëꞌn ta bicueꞌn gaꞌalaꞌ ruꞌa nisa. Naꞌ ureꞌnëꞌ laona uzulaohuëꞌ rusëdinëꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Babeyudyi psëdinëꞌ yaca benëꞌ, naꞌ unëꞌ rëbinëꞌ Simón: ―Yaꞌlë barco ni ga naca zituꞌ lao lagun niga. Naꞌ uledzeꞌ yëxo quiele luꞌu nisa tacuenda tzuꞌun bela. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Naꞌ una Simón rëbinëꞌ lëbëꞌ: ―Maestro, bedu yela uyuꞌundoꞌ ta sendoꞌ bela, pero ni tubaꞌ bibdulaꞌ quiendoꞌ. Denꞌ chi luëꞌ naoꞌ, udziꞌa yëxo luꞌu nisa. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Biz̃i babdzeꞌyaquëꞌ yëxo luꞌu nisa uyuꞌuna bela zë gula. Tanto bedzaꞌn uyuꞌun bela naꞌ, urugu du lëꞌë yëxo. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Canaꞌ bëlëyaquëꞌ naꞌayaquëꞌ seña ta guida benꞌ yuꞌu luꞌu barco tula ta gacalëyaquëꞌ leyaquëꞌ. Naꞌra zioyaquëꞌ psedzaꞌyaquëꞌ bela lao rupate barco. Tanto yelaꞌ ziꞌi quieyacan, bareꞌen yetuyacan luꞌu nisa. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Biz̃i bëꞌ blëꞌë Simón Pedro canꞌ guca, naꞌ uditzu z̃ibinëꞌ ureꞌnëꞌ lao Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―Bibi zacaꞌ conlë luëꞌ, porque nacaꞌ benꞌ napa dulaꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Una Simón canꞌ, danꞌ bdzebinëꞌ lente yaca benꞌ zëlënëꞌ. Blëꞌëyaquëꞌ canꞌ guca uz̃eyaquëꞌ bela zë gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Lëzi Santiago len bichibiꞌ Juan, z̃iꞌi Zebedeo, nacayaquëꞌ tuzi len Simón, bdzebitzegueyaquëꞌ. Naꞌra una Jesús rëbinëꞌ Simón: ―Bidzeboꞌ, desde naꞌa cabëꞌ ruele cuiole bela yuꞌu luꞌu nisa, canaꞌ uluꞌenaꞌ leꞌe cuiole benꞌ nao xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Biz̃i babedyinyaquëꞌ len barco quieyaquëꞌ ruꞌa nisa, naꞌ pcaꞌnyaquëꞌn uz̃iꞌyaquëꞌ uzaꞌyaquëꞌ ziolëyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Biz̃i bazu Jesús lao yedyi, bdyin tu benꞌ yuꞌu yelaꞌ hueꞌ ca mal de pindo. Biz̃i bëꞌ blëꞌënëꞌ Jesús, uditzu z̃ibinëꞌ ureꞌnëꞌ bdaꞌte laohuëꞌ layu unabayëchiꞌnëꞌ rëbinëꞌ Jesús: ―Señor, chi reꞌenloꞌ huaca yeyueloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Naꞌra bdaꞌ naꞌa Jesús benꞌ naꞌ rëbinëꞌ lëbëꞌ: ―Reꞌendaꞌ yeyuaꞌ luëꞌ. Ca unëꞌ canaꞌ, biz̃i labez̃ite yelaꞌ hueꞌ naca ca mal de pindo yuꞌu benꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Naꞌra bë Jesús mandado rëbinëꞌ lëbëꞌ: ―Ni tu nunu yëboꞌ canꞌ babiaꞌ quioꞌ. Tuzi ta rniaꞌ luëꞌ, uyo yaluꞌe cuinloꞌ lao pxuzi. Naꞌ bëꞌ pxuzi tu ta reyaꞌalaꞌ hueꞌloꞌnëꞌ ca ta rnabëꞌ lëꞌë guichi ley quie Moisés tanun quie babeyëriloꞌ. Hueloꞌ canꞌ ta inezi yaca benëꞌ babez̃i yelaꞌ hueꞌ uyuꞌuloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero mazera unezi yaca benëꞌ cabëꞌ rue Jesús. Bdyin benꞌ zë gula ganꞌ zënëꞌ ta rzënagayaquëꞌ ca rnëꞌ, lëzirë ta yeyuerënëꞌ nacala yelaꞌ hueꞌ yuꞌuyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Biz̃i zio Jesús lao lato ga binitaꞌ yaca benëꞌ. Lëganꞌ naꞌ rulidzëꞌ ruꞌelënëꞌ Diuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Biz̃i bdyin tu dza rusëdi Jesús yaca benëꞌ. Lëganꞌ naꞌ reꞌ yaca benꞌ naca partido fariseo len yaca benꞌ rsëdi ley quie Moisés. Uzaꞌyaquëꞌ yedyi quie estado Galilea len yedyi quie estado Judea, len ciudad Jerusalén. Biz̃i naꞌa, conlë yelaꞌ huaca quienëꞌ, gucalë Diuzi Jesús, beyuenëꞌ yaca benꞌ raca z̃hueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lëscanaꞌ bdyin yaca benꞌ nuꞌa benꞌ z̃i lao belaga. Reꞌenyaquëꞌ udzeꞌyaquëꞌ lëbëꞌ luꞌu yuꞌute ta quixoyaquëꞌ lëbëꞌ lao Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Biz̃i biuz̃aqueꞌyaquëꞌ tzuꞌulëyaquëꞌ benꞌ z̃i luꞌu yuꞌu danꞌ nitaꞌ benꞌ zë gula. Naꞌ urëyaquëꞌ lun yuꞌu udubayaquëꞌ teja, bzuyaquëꞌ tu yero cuenda pchizayaquëꞌ belaga ga z̃uba benꞌ z̃i, psedyinyaquëꞌ lëbëꞌ gatzo laoꞌ ga nitaꞌ benëꞌ zaquëꞌlao lao Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Caora blëꞌë Jesús rueyaquëꞌ pensari huaca Jesús yeyuenëꞌ benꞌ z̃i, naꞌra unëꞌ rëbinëꞌ lëbëꞌ: ―Rniaꞌ luëꞌ, aoz̃iꞌz̃iaꞌ dulaꞌ xquia quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Biz̃i yaca benꞌ rsëdi ley quie Moisés, len yaca benꞌ naca partido fariseo, gucayaquëꞌ pensari unayaquëꞌ: “¿Nuz̃i benꞌ niga rnayaꞌnëꞌ Diuzi rnëꞌ canꞌ? Ni tu benëꞌ bisaqueꞌ yeziꞌz̃eyaquëꞌ dulaꞌ xquia quie laguedyiyaquëꞌ. Tuzi Diuzi naquëꞌ benꞌ yeziꞌz̃e quiero.” ");
INSERT INTO zpcNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Naꞌra banezi Jesús cabëꞌ naca pensari racayaquëꞌ. Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Bixquienꞌ racale pensari canaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ca nurlan nacaran yalo huaꞌ quie benꞌ z̃i niga? ¿Nacaran yalo chi yëpaꞌnëꞌ: “Aoz̃iꞌz̃iaꞌ dulaꞌ xquia quioꞌ”, o chi nacaran yalo yëpaꞌnëꞌ: “Uyasa, beziꞌ belaga quioꞌ, bezaꞌ, beyo”? ");
INSERT INTO zpcNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pues cani huaꞌ ta uluꞌenaꞌ leꞌe de yelaꞌ rnabëꞌ quiaꞌ, nacaꞌ bichi yugulu benëꞌ, ta yeziꞌz̃iaꞌ dulaꞌ xquia quie yaca benꞌ nitaꞌ lao yedyi layu. Naꞌra unëꞌ rëbinëꞌ benꞌ z̃i: ―Rniaꞌ luëꞌ, beyasa, beziꞌ belaga quioꞌ, beyo z̃an yuꞌu quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Canaꞌ labeyasate benꞌ z̃i zacaꞌlao yaca benꞌ nitaꞌ rnaꞌ, beziꞌnëꞌ yada quiëꞌ ga uz̃ubanëꞌ. Naꞌ bezëꞌë zeyoguëꞌ z̃an yuꞌu quiëꞌ ruenëꞌ Diuzi benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Biz̃i lao yugulute yaca benꞌ nitaꞌ rnaꞌ, bëyaquëꞌ Diuzi benꞌ z̃e. Tu bebanziyaquëꞌ canꞌ guca quie benꞌ z̃i. Du rdzebiyaquëꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Tu ta binelëꞌëro babë benꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ude beyudyi bë Jesús canꞌ, uzëꞌë zioguëꞌ blëꞌënëꞌ tu benꞌ huequiz̃u laonëꞌ Leví. Lëbenꞌ naꞌ reꞌnëꞌ ga rquiz̃uguëꞌ benëꞌ. Naꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Uda, unao nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Biz̃i uzuli Leví pcaꞌnnëꞌ ta de quienëꞌ zioguëꞌ naohuëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ude naꞌ, bë Leví tu lani z̃e z̃an yuꞌu quienëꞌ ruenëꞌ Jesús benꞌ z̃e. Lëzi bdyinrë mazara benꞌ huequiz̃u, len yaca benꞌ tula ureꞌyaquëꞌ lao mesa. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Biz̃i yaca benꞌ naca partido fariseo, len yaca benꞌ rsëdi ley quie Moisés udilayaquëꞌ benꞌ quie Jesús unayaquëꞌ rëbiyaquëꞌ leyaquëꞌ: ―¿Bixquienꞌ raole riꞌolële tzaz̃e len yaca benꞌ huequiz̃u, len yaca benꞌ de dulaꞌ xquia quie? ");
INSERT INTO zpcNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Benꞌ zu dyaꞌa, benꞌ biraca z̃hueꞌ, biruen zi guida benꞌ yeyue lëbëꞌ. Pero benꞌ raca z̃hueꞌ, ruen zi guida benꞌ yeyue lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Cala bidaꞌ rbiogaꞌ yaca benꞌ raca pensari bibi dulaꞌ xquia quie de, dechanꞌ bidaꞌ rbiogaꞌ yaca benꞌ nezi de dulaꞌ xquia quie tacuenda yetzaꞌyaquëꞌ pensari quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Naꞌra unabayaquëꞌ rëbiyaquëꞌ Jesús: ―Ablëꞌëndoꞌ yaca benꞌ quie Juan len yaca benꞌ naca partido fariseo, rueyaquëꞌ ubasi rlidzayaquëꞌ Diuzi yugu dza, naꞌ yaca benꞌ quioꞌ, ¿bixquienꞌ riꞌo raoziyaquëꞌ, biruejëꞌ ubasi? ");
INSERT INTO zpcNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―¿Reꞌenle hue yaca benꞌ naca amigo, yaca benꞌ babdyin ganꞌ raca huetzaganaꞌ ubasi tu nezu benꞌ utzaganaꞌ len yaca amigo quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Biz̃i rniaꞌ leꞌe, huadyin dza cati bira zulë benꞌ utzaganaꞌ len yaca amigo quienëꞌ. Lëscanaꞌra hue yaca amigo quienëꞌ ubasi. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Lëzi unë Jesús itu ejemplo cani: ―Bireyaꞌalaꞌ yedaꞌ laꞌariꞌ cubi lëꞌë laꞌariꞌ gula cati binetzëri laꞌariꞌ cubi. Huazaꞌlaoran ichezan laꞌariꞌ gula, udyiaguiꞌran len, biyegaꞌnnan lëbizi. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Lëscanꞌ bireyaꞌalaꞌ caꞌro nupi z̃ixi tu luꞌu guidi bolsa gula, porque chi caꞌro nupi z̃ixi luꞌu guidi bolsa gula, huachezan len huabiaguiꞌ lao rupa cueꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lenaꞌ reꞌennan tzudzu nupi z̃ixi luꞌu bolsa guidi cubi ta sibeꞌn zi dza, birezan. Lëcanaꞌ bicuiaguiꞌ lao rupaten. ");
INSERT INTO zpcNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Lëscanꞌ quie nu benꞌ riꞌo puro nupi huala bireꞌenyaquëꞌ yoꞌoyaquëꞌ nupi z̃ixi. Huanayaquëꞌ: “Nupi huala nacaran huen ta yoꞌoro.” ");
INSERT INTO zpcNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Biz̃i guca tu dza huezilaꞌadyiꞌ, uzaꞌ Jesús lënëꞌ yaca benꞌ quienëꞌ zioyaquëꞌ udeyaquëꞌ layela ga neduza trigo. Naꞌ uditzu yaca benꞌ quienëꞌ laon ta rchibiyaquëꞌn ta gaoyaquëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Naꞌra una yaca benꞌ naca partido fariseo rëbiyaquëꞌ Jesús: ―¿Bixquienꞌ ruele dyin uditzule lao bini trigo naꞌa dza huezilaꞌadyiꞌ, dza bireyaꞌalaꞌ huero dyin? ");
INSERT INTO zpcNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―¿Binelabale lëꞌë guichi laꞌiya quie Diuzi cabëꞌ bë rey David dza uduenëꞌ lënëꞌ yaca benëꞌ quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Uyuꞌunëꞌ luꞌu idaoꞌ rnabëꞌra, uz̃iꞌnëꞌ yëta xtila naca laꞌiya ta ruꞌe pxuzi Diuzi. Naꞌ udao rey David len, lëscanꞌ bëꞌnëꞌn yaca benꞌ dzaganëꞌ. Caora naꞌ udaoyaquëꞌ ta bireyaꞌalaꞌ gaoyaquëꞌ. Udaoyaquëꞌ ta reyaꞌalaꞌ gao pxuzizi. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Naꞌ unë Jesús rëbinëꞌ leyaquëꞌ: ―Nëꞌëdiꞌ, bichi yugulu benëꞌ, de yelaꞌ rnabëꞌ quiaꞌ ta huaꞌ mandado bi hue yaca benëꞌ dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Biz̃i bezu itu dza, dza huezilaꞌadyiꞌ, uyuꞌu Jesús luꞌu idaoꞌ sinagoga bezulaohuëꞌ rusëdiguëꞌ benëꞌ. Biz̃i naꞌa zë tu benꞌ neseco nëꞌë yebë. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Lëzi zërë benꞌ rsëdi ley quie Moisés, len yaca benꞌ naca partido fariseo, rbeꞌnaoyaquëꞌ chi hueyue Jesús benꞌ neseco nëꞌë dza huezilaꞌadyiꞌ tacuenda ga gaoyaquëꞌ lëbëꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero banezi Jesús ca naca pensari quieyaquëꞌ. Naꞌra unëꞌ blidzëꞌ benꞌ naꞌa bidyi: ―Rniaꞌ luëꞌ, uzuli uda, desë gatzo laoꞌ ni. Naꞌra ude benꞌ neseco nëꞌë, yasënëꞌ gatzo laoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Reꞌendaꞌ inabacaraꞌ leꞌe tu diꞌidzaꞌ ¿ca bidanꞌ reyaꞌalaꞌ huero dza huezilaꞌadyiꞌ? ¿Ruꞌen lato huero tahuen o huero tamala? ¿Ruꞌen lato ute uselaro benëꞌ o chi gutiro benëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Biz̃i Jesús unaꞌnëꞌ yaca benꞌ nitaꞌ ganꞌ zënëꞌ. Ude naꞌ unëꞌ rëbinëꞌ benꞌ neseco nëꞌë: ―Bli naꞌaloꞌ. Caora bli naꞌa benꞌ neseco nëꞌë, beyacaten dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Biz̃i yaca benꞌ nitaꞌ naꞌ, lega bdzaꞌtzegueyaquëꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Ca biz̃i huero quie benꞌ niga ta bira huenëꞌ ca ruenëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Biz̃i bezu dza tula uzaꞌ Jesús uyoguëꞌ ga zu tu yaꞌa ta hueꞌlënëꞌ Diuzi diꞌidzaꞌ. Lao bedu yela bëꞌlënëꞌ Diuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Biz̃i baoyeniꞌ dza tula, guz̃inëꞌ yaca benꞌ quiëꞌ, ulioguëꞌ lao chipchopa yaca benꞌ gaca benꞌ quiëꞌ, benꞌ gaca apóstol. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Lëyaca benꞌ rguixogueꞌn laohue niga: Ulioguëꞌ Simón, naꞌ uxuba Jesús laohuëꞌ Pedro. Lëscanꞌ ulioguëꞌ Andrés, biꞌ bichi Simón, len Santiago, len Juan, len Felipe, len Bartolomé, ");
INSERT INTO zpcNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","len Mateo, len Tomás, len Santiago z̃iꞌi Alfeo, len Simón, benꞌ naca tu cueꞌ partido cananista, ");
INSERT INTO zpcNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","len Judas, biꞌ bichi Santiago, len Judas Iscariote, benꞌ usedyin Jesús lao naꞌa yaca benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Naꞌ beyëzi Jesús lao yaꞌa len yaca benꞌ quienëꞌ. Yazëyaquëꞌ ga naca yu lachiꞌ. Lëganꞌ naꞌ nitaꞌ benꞌ zë. Lëganꞌ naꞌ zërë benꞌ uzaꞌ estado Judea, len benꞌ nitaꞌ ciudad Jerusalén, len yaca benꞌ uzaꞌrë bago ruꞌa nisadaoꞌ ga reꞌ yedyi Tiro len yedyi Sidón. Lëleyaquëꞌ bdyinyaquëꞌ ta uzënagayaquëꞌ bi na Jesús len ta yeyue Jesús yaca benꞌ raca z̃hueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yaca benꞌ redzagalao, yaca benꞌ yuꞌu bichi be xiꞌibiꞌ, beyue Jesús leyaquëꞌ beyacayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Lao yugulu yaca benëꞌ reꞌenyaquëꞌ udaꞌ naꞌayaquëꞌ Jesús, danꞌ neziyaquëꞌ con yelaꞌ huaca quienëꞌ yeyuenëꞌ leyaquëꞌ chi bi yelaꞌ hueꞌ yuꞌuyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Naꞌra unaꞌ Jesús yaca benꞌ quienëꞌ naꞌ unëꞌ: ―Yedaohue leꞌe chi racayëchiꞌle ca naca dulaꞌ xquia babële, danꞌ naca quiele ga rnabëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Yedaohue leꞌe chi reꞌenle gataꞌ ta yuꞌu niꞌa xnezi quie Diuzi cabëꞌ gueꞌen benꞌ rdue gaohuëꞌ, porque danꞌ gataꞌcazi quiele ca reꞌenle gataꞌ. ’Yedaohue leꞌe chi racayëchiꞌle rbedyile ca dulaꞌ xquia de lao yedyi layu, porque danꞌ huadyin dza sule gusto uz̃idyile. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Yedaohue leꞌe cati rudie benëꞌ leꞌe, cati rbioyaquëꞌ leꞌe tzalaꞌla, cati utasi unioyaquëꞌ leꞌe, cati inëyaquëꞌ nacale benꞌ mala tanun quie danꞌ naole nëꞌëdiꞌ, benꞌ naca bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Reyaꞌalaꞌ yedaohuetzeguele bëꞌ gaca quiele canaꞌ, danꞌ huataꞌ tu tadyaꞌa gula quiele cati bazule guibá. Con canꞌ psaca xuzixtaꞌo yaca benꞌ nitaꞌ naꞌa, udila unëlëyaquëꞌ yaca benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi, canaꞌ usacarëyaquëꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Beyëchiꞌ gula nacan quie leꞌe, benꞌ uñaꞌa, benꞌ binao xneza Diuzi, porque ca tu ta dezi lao dyilayu niga naca quiele, bira gataꞌ mazara. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Beyëchiꞌ gula nacan quie leꞌe, benꞌ detzague ta gao, benꞌ birlidza Diuzi, porque huadyin dza tuele, bira gataꞌ ta gaole. ’Beyëchiꞌ gula nacan quie leꞌe, benꞌ redaohue ruz̃idyi, benꞌ birue quie xtiꞌidzaꞌ Diuzi, porque huadyin dza cuedyile cabëꞌ bayëchiꞌ zaꞌ gaca quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Beyëchiꞌ gula nacan quie leꞌe, chi ilëꞌë yugulu benëꞌ leꞌe benꞌ dyaꞌa, dechanꞌ binacale benꞌ dyaꞌa, porque canaꞌ bë xuzixtaꞌo benꞌ niga, blëꞌëyaquëꞌ benꞌ dyaꞌa benꞌ nazi rguixogueꞌyaquëꞌ xtiꞌidzaꞌ Diuzi, denꞌ benꞌ huiziꞌ yëꞌ. Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","―Pero leꞌe benꞌ ruzënaga ca rniaꞌ, reyaꞌalaꞌ idyëꞌële yaca benꞌ rdzaꞌ rgüinꞌ leꞌe, huele tadyaꞌa lële benꞌ rudie leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Inabale tadyaꞌa lao Diuzi quie benꞌ rudzeꞌdeꞌ leꞌe, ulidzale Diuzi gaca tahuen quie benꞌ rutasi runio leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chi nu benëꞌ rgapaꞌ xagale, ulehueꞌnëꞌ itzalaꞌn capanëꞌ. Chi nu benëꞌ rguba gabán quiele, ulehueꞌnëꞌ lente camisa quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ulehueꞌ nutezi benëꞌ ta inabayaquëꞌ leꞌe. Chi nu yaca benꞌ aoz̃iꞌyaquëꞌ ta de quiele, biyenabalen. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ulehuelë yaca benëꞌ con cabëꞌ reꞌenle huelë yaca benëꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Chi leꞌe nedyëꞌële tuzi benꞌ nedyëꞌë leꞌe, bihuele pensari tadyaꞌa ruele, porque lente yaca benꞌ mala ruerëyaquëꞌ canꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Chi leꞌe ruele tadyaꞌa len tuzi benꞌ rue tadyaꞌa len leꞌe, bihuele pensari tadyaꞌa ruele, porque lente yaca benꞌ mala ruerëyaquëꞌ canꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Chi leꞌe hueꞌle presta tuzi benꞌ runrë leꞌe presta, bihuele pensari tadyaꞌa ruele, porque lente yaca benꞌ mala ruꞌerëyaquëꞌ presta tuzi benꞌ ruꞌerë presta leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero leꞌe, reyaꞌalaꞌ idyëꞌële benꞌ rudie leꞌe, reyaꞌalaꞌ huelële yaca benëꞌ dyaꞌa, reyaꞌalaꞌ hueꞌleyaquëꞌ ta inabayaquëꞌ presta, biinabale yeyueyaquëꞌ laohue quiele. Chi huele cabëꞌ rniaꞌ, taz̃era gun Diuzi quiele. Chi huele cabëꞌ rniaꞌ, lenaꞌ uluꞌen tali nacale benꞌ quie Diuzi zu sibi. Rniaꞌ leꞌe, huele ca rue Diuzi, porque naca Diuzi benꞌ dyaꞌa gula. Tuzi ca rue Diuzi ruenëꞌ tadyaꞌa lente yaca benꞌ birëbi lëbëꞌ diuxcaleloꞌ, benꞌ birue tahuen. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Reyaꞌalaꞌ idyëꞌële yaca benëꞌ cabëꞌ nedyëꞌë Xuziro Diuzi yaca benëꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","―Biinëbiz̃ole quie laguedyile, canaꞌ biyeyue biz̃o Diuzi len leꞌe. Biudyiaguiꞌle laguedyile, yelaꞌ naꞌ biudyiaguiꞌrë Diuzi leꞌe. Yeziꞌz̃ele quie laguedyile, yelaꞌ naꞌ yeziꞌz̃erë Diuzi quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Hueꞌle ta de quiele benꞌ bide quie, canaꞌ yeyun Diuzi leꞌe ta de quienëꞌ. Ca rue Diuzi biyeyunnëꞌ lëꞌëtiꞌzin, hueyunnëꞌ mazara ta yuñaꞌa ta de quienëꞌ. Con ca huelële laguedyile, canaꞌ huelë Diuzi leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Naꞌra una Jesús unëꞌ tu chopa diꞌidzaꞌ ni: ―¿Huazaqueꞌ usaꞌ tu benꞌ laochula itu benꞌ laochula? ¿Cala huaguinu lao rupateyaquëꞌ luꞌu ga naca stëbi? ");
INSERT INTO zpcNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nu benꞌ bineyudyi huesëdi quie, binegaquëꞌ ca raca maestro quienëꞌ. Pero nu benꞌ babeyudyi huesëdi quie, naꞌra gacanëꞌ ca tu raca maestro quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Como dyëꞌëdi rnaꞌle bëbi daoꞌ yuꞌu luꞌu lao biꞌ bichile? ¿Naꞌ laole leꞌe, birnaꞌle yuꞌun bicho yaga? ");
INSERT INTO zpcNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Como reyaz̃ole rëbile biꞌ bichile: “Bichaꞌ, ben lato yebiogaꞌ bëbi daoꞌ yuꞌu laoloꞌ”? ¿Naꞌ birezaquele quiele cuinle yuꞌun bicho yaga? ¡Leꞌe benꞌ birue tuzi ca nale! Tanëro ulebio bicho yaga yuꞌu luꞌu laole, canaꞌra hualëꞌële dyëꞌëdi ta yebiole bëbi daoꞌ yuꞌu lao biꞌ bichile. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","―Birbia yaga dyaꞌa tu ta naca slaꞌ. Lëzirë birbia taz̃ixi yaga median. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pues quie quie yaga rlëꞌëro chi yaga dyaꞌa, chi yaga median, según ca naca ta rbialaon. Bicuia higos lao yaga yëchiꞌ. Lëscanꞌ bicuia bedzuliꞌ lao luba yëchiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lëzi beꞌmbyu huen, diꞌidzaꞌ huen rero luꞌu laxtaꞌonëꞌ rnënëꞌ. Naꞌ biz̃i beꞌmbyu mala, diꞌidzaꞌ mala rero luꞌu laxtaꞌonëꞌ rnënëꞌ. Porque danꞌ según ca naca ta yuꞌu luꞌu laxtaꞌo benëꞌ, chi tahuen, chi tamala, canaꞌ iron luꞌu laxtaꞌoyaquëꞌ inëyaquëꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","―¿Bixquienꞌ nale nëꞌëdiꞌ, “Señor, Señor”, naꞌ birue quiele ca rniaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Niaꞌ leꞌe ca naca quie benꞌ nao nëꞌëdiꞌ, benꞌ rue quie ca niaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lëcanaꞌ naca quie benꞌ bë yuꞌu quie, pquiꞌnnëꞌ zituꞌ luꞌu yu ta pcuaꞌnëꞌ besu quie yuꞌu. Caora baben tu yusiuꞌ huala, biuz̃aqueꞌn usuriꞌn besu, danꞌ yuꞌun zituꞌ yu. ");
INSERT INTO zpcNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Naꞌ biz̃i benꞌ re ca rniaꞌ, pero biruenëꞌ nëꞌëdiꞌ casa ca rniaꞌ, naca quiëꞌ ca quie benꞌ pcuaꞌ besu delao yuzi. Caora baben tu yusiuꞌ huala, caora naꞌ pquinun besu, bguinu yuꞌu, begaꞌnten lao lato. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Biz̃i cati beyudyi unë Jesús gudyinëꞌ yaca benëꞌ, naꞌ bezëꞌë zioguëꞌ yedyi Capernaum. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lëganꞌ naꞌ zu tu benꞌ romano, benꞌ rnabëꞌ soldado, naquëꞌ capitán. Biz̃i zu tu criado quienëꞌ, benꞌ nedyëꞌënëꞌ, tahuala raca z̃hueꞌnëꞌ, bagazi gatinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Biz̃i cati be capitán babdyin Jesús ganꞌ, naꞌ useꞌelëꞌ tu benꞌ rnabëꞌ quie yaca benꞌ Israel ta inabayëchiꞌnëꞌ chi biguida Jesús yeyuenëꞌ benꞌ de raca z̃hueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Biz̃i bëꞌ bdyinyaquëꞌ ga zë Jesús, naꞌ unëyëchiꞌyaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Benꞌ naca xanꞌ soldado, naquëꞌ benꞌ huen, zacaꞌnëꞌ hueloꞌ ca cule reꞌennëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","danꞌ rlëꞌënëꞌ yaca benꞌ yedyi quiero benꞌ huen. Lëlëbëꞌ bënëꞌ mandado bëyaquëꞌ idaoꞌ sinagoga quiero. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Naꞌra uzaꞌ Jesús ziolënëꞌ leyaquëꞌ. Biz̃i baidyinyaquëꞌ bago z̃an yuꞌu quie xanꞌ soldado, naꞌ useꞌelaꞌ xanꞌ soldado yaca benꞌ nacalënëꞌ amigo rëbiyaquëꞌ Jesús: ―Señor, ni tu bigacoꞌ zëdi, porque bibi zacaꞌ ta guidoꞌ tzuꞌuloꞌ luꞌu yuꞌu quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tanaꞌ lenaꞌ bibeyaz̃ogaꞌ guidaꞌ cuinaꞌ denaꞌa luëꞌ. Con tu diꞌidzaꞌzi inaoꞌ iyaca criado quiaꞌ hueyacabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Biz̃i zu benꞌ rnabëꞌ nëꞌëdiꞌ. Lëzirë nacariaꞌ benꞌ rnabëꞌ quie soldado. Cati huaꞌ mandado ga tzioyaquëꞌ, huayoyaquëꞌ. Lëzi cati huaꞌ mandado guidayaquëꞌ, huidayaquëꞌ. Lëzi cati rueriaꞌ mandado criado quiaꞌ, ruebiꞌ yugute ta ruaꞌbiꞌ mandado. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Cati be Jesús ca una xanꞌ soldado, tu bebanzi Jesús ca unëꞌ. Naꞌra unaꞌnëꞌ ga nitaꞌ yaca benꞌ nao lëbëꞌ, unëꞌ rëbinëꞌ leyaquëꞌ: ―Tali nacan. Ni tu yaca benꞌ Israel, binelëꞌëdaꞌ benꞌ hue quie cabëꞌ rue benꞌ niga, rzudyiꞌilënëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Biz̃i bëꞌ bedyin yaca benꞌ useꞌelaꞌ xanꞌ soldado z̃an yuꞌu quiëꞌ, bedyinyaquëꞌ rnaꞌyaquëꞌ babeyaca benꞌ criado, benꞌ raca z̃hueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Baode guca canꞌ, naꞌ uzaꞌ Jesús ziolënëꞌ yaca benꞌ quienëꞌ yedyi lao Naín. Lëzi ziorë benꞌ zë len leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Biz̃i cati bdyin Jesús bago ruꞌa yedyi, blëꞌënëꞌ banuꞌayaquëꞌ benꞌ huati ta tzacachiꞌyaquëꞌ lëbiꞌ. Biz̃i biꞌ guti nacabiꞌ z̃iꞌi nigula nati xquiuhue. Tuzi biꞌ naꞌ uzu quienëꞌ. Ziolë yaca benꞌ zë, benꞌ lao yedyi, len nigula naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Biz̃i bëꞌ blëꞌë Jesús nigula naꞌ, beyëchiꞌlaꞌadyiꞌnëꞌ lëbëꞌ, unëꞌ rëbinëꞌ lëbëꞌ: ―Bicuedyoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naꞌ ubigaꞌ Jesús yedaꞌ nëꞌë lëꞌë caja quie biꞌ huati. Canaꞌ uleza yaca benꞌ nuꞌa lëbiꞌ. Naꞌra unë Jesús rëbinëꞌ biꞌ huati: ―Xcuidiꞌ, rniaꞌ luëꞌ: ¡Beyasa! ");
INSERT INTO zpcNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Caora naꞌ uyasabiꞌ ganꞌ debiꞌ luꞌu caja quiebiꞌ, areꞌbiꞌ, rnëbiꞌ. Naꞌra beyuꞌe Jesús lëbiꞌ z̃naꞌbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Biz̃i caora blëꞌë yaca benꞌ nitaꞌ naꞌ, lega bdzebiyaquëꞌ. Bëyaquëꞌ Diuzi benꞌ z̃e unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Bablaꞌ tu benꞌ rue yelaꞌ huaca, benꞌ useꞌelaꞌ Diuzi ladoro ganꞌ nitaꞌro. Lëzi unarëyaquëꞌ: ―Diuzi baoseꞌelëꞌ benꞌ ni ta gacalënëꞌ benꞌ Israel, benꞌ yedyi quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Canaꞌ guca unezi yaca benꞌ quie estado Judea, len yaca benꞌ yedyi reꞌ bago con canꞌ bë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Biz̃i be Juan cabëꞌ yelaꞌ huaca bë Jesús nun quie gudyi benꞌ quienëꞌ lëbëꞌ cabëꞌ rue Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Canaꞌ guz̃inëꞌ chopa benꞌ quienëꞌ ta uyoyaquëꞌ yenabayaquëꞌ Jesús chi tali naquëꞌ benꞌ una Diuzi iseꞌelaꞌnëꞌ, benꞌ rbezayaquëꞌ guida, o chi cala lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yaca benꞌ useꞌelaꞌ Juan bdyinyaquëꞌ ga zë Jesús rëbiyaquëꞌ lëbëꞌ: ―Useꞌelaꞌ Juan bautista nëtoꞌ ta denabandoꞌ luëꞌ chi nacoꞌ benꞌ una Diuzi iseꞌelaꞌnëꞌ, o chi reyaꞌalaꞌ nitaꞌndoꞌ cuezandoꞌ guida benꞌ tula. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Biz̃i caora nitaꞌlëyaquëꞌ Jesús, blëꞌëyaquëꞌ beyue Jesús nacala yelaꞌ hueꞌ mala yuꞌu yaca benëꞌ, beyacayaquëꞌ. Lëzi blëꞌëyaquëꞌ bebionëꞌ bichi be xiꞌibiꞌ yuꞌu yaca benëꞌ, blëꞌëyaquëꞌ beyuenëꞌ yaca benꞌ laochula, benꞌ birlëꞌë, belëꞌëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Naꞌra una Jesús rëbinëꞌ yaca benꞌ quie Juan: ―Uleyo uletzetixogueꞌ Juan ca ta babiaꞌ bablëꞌële babele. Uleyëbinëꞌ quie yaca benꞌ laochula, barelëꞌëyaquëꞌ, lëscanꞌ quie yaca benꞌ z̃i, baredayaquëꞌ, lëscanꞌ quie yaca benꞌ yuꞌu yelaꞌ hueꞌ ca mal de pindo, areyëriyaquëꞌ, lëscanꞌ quie yaca benꞌ xcuedzo, bareyeyaquëꞌ, lëscanꞌ quie yaca benꞌ baguti, rebanyaquëꞌ tatula. Naꞌ biz̃i yaca benꞌ yëchiꞌ, rguixoguiꞌayaquëꞌ diꞌidzaꞌ laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yedaohue yaca benꞌ biyeyati inao nëꞌëdiꞌ. ―Canaꞌ una Jesús gudyinëꞌ benꞌ quie Juan. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Biz̃i cati zeyo yaca benꞌ useꞌelaꞌ Juan, naꞌ uzulao Jesús rëbinëꞌ yaca benëꞌ ca naca quie Juan, unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Nuz̃i uyole yenaꞌle lao lato ga bidyia yuꞌu? ¿Uyole yenaꞌle tu benꞌ yunꞌlaꞌadyiꞌ ca raca tu z̃isi rz̃izi rdan bëꞌ rda be bedunꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Chi biuyole yenaꞌle benꞌ yunꞌlaꞌadyiꞌ, ¿nuz̃i uyole yenaꞌle? ¿Uyole yenaꞌle benꞌ zutzaoꞌ, benꞌ naco laꞌariꞌ dyaꞌa? Leꞌe dyëꞌëdi banezile benꞌ naco laꞌariꞌ dyaꞌa, benꞌ zu luꞌu yuꞌu dyaꞌa, nitaꞌyaquëꞌ laoꞌ yedyi ga zu rey, binitaꞌyaquëꞌ lao lato ga bidyia yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pues ca rniaꞌ leꞌe, ¿nuz̃i uyole yenaꞌle? ¿Uyole yenaꞌle benꞌ rguixogueꞌ diꞌidzaꞌ laꞌiya quie Diuzi? Talicazi rguixogueꞌ Juan diꞌidzaꞌ laꞌiya quie Diuzi. Nacarëꞌ benꞌ z̃e ca benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi dza naꞌtela. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Lëquie Juan rnën lëꞌë guichi laꞌiya quie Diuzi cani: Huaseꞌelaꞌ benꞌ cuialao neza tzetixogueꞌnëꞌ yaca benëꞌ yëbinëꞌ leyaquëꞌ cani: “Ca rue benꞌ rluba neza, benꞌ rue dyaꞌa xnezi, canaꞌ huele utzaꞌle pensari quiele, danꞌ bazaꞌ benꞌ iseꞌelaꞌ Diuzi.” Canaꞌ rnën lëꞌë guichi laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Naꞌra ca rniaꞌ leꞌe, entre lado yaca benꞌ nitaꞌ lao yedyi layu niga, nunura benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi zu nacara z̃e ca Juan. Naꞌ biz̃i, benꞌ zu guibá, benꞌ birnabëꞌtica ga zu Diuzi, nacaranëꞌ z̃e ca Juan. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Naꞌ biz̃i yaca benꞌ huequiz̃u, benꞌ bëꞌ Juan laohue, len yaca los demás benꞌ bëꞌ Juan laohue, caora beyaquëꞌ ca una Jesús, bezaqueyaquëꞌ naca Diuzi benꞌ rue tali, benꞌ rue ta yuꞌu niꞌa xnezi. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Naꞌ biz̃i yaca benꞌ partido fariseo, len yaca benꞌ rusëdi ley quie Moisés, yaca benꞌ bibë lato hueꞌ Juan laohue, biguꞌunyaquëꞌ ca tadyaꞌa guꞌun Diuzi hue Juan quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Naꞌ una Jesús rëbinëꞌ yaca benꞌ naꞌ: ―¿Ca bi ejemplo uluꞌen cabëꞌ naca pensari quie yaca benꞌ nitaꞌ naꞌa? ¿Ca bi ejemplo rnaban ta huaꞌ diꞌidzaꞌ cabëꞌ rueyaquëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rue yaca benꞌ nitaꞌ naꞌa ca quie xcuidiꞌ reꞌ lao yeꞌeya rëbiyacabiꞌ laguedyiyacabiꞌ: “Rcuedyindoꞌ flauta, naꞌra biquitule biuyaꞌale. Rulandoꞌ canción bayëchiꞌ, lëscanꞌ biuredyile.” ");
INSERT INTO zpcNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Canaꞌ naca quiele, porque bida Juan bautista, biudaonëꞌ pan, bihueꞌenëꞌ vino, naꞌ leꞌe unale yuꞌunëꞌ bichi be xiꞌibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Lëzi nëꞌëdiꞌ, bichi yugulu benëꞌ, bidaꞌ raohuaꞌ riꞌogaꞌ, naꞌ leꞌe unale nacaꞌ benꞌ riꞌo raolëꞌë, benꞌ naca amigo quie benꞌ de dulaꞌ xquia quie, len yaca benꞌ huequiz̃u. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero yaca benꞌ naocazi xneza Diuzi, lëleyaquëꞌ ruluꞌeyaquëꞌ ca naca quie yelaꞌ rioñeꞌe quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Biz̃i gudyi tu benꞌ naca partido fariseo Jesús chi biguidëꞌ z̃an yuꞌu quienëꞌ ta gaohuëꞌ. Naꞌra bdyin Jesús uyuꞌunëꞌ luꞌu yuꞌu ureꞌnëꞌ lao mesa. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lëlao yedyi naꞌ zu tu nigula mala. Caora unezinëꞌ babdyin Jesús z̃an yuꞌu quie benꞌ naca partido fariseo, naꞌra uzëꞌë z̃an yuꞌu quiëꞌ nuꞌë tu frasco alabastro yudzon aceite rlaꞌ z̃ixi z̃eo. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Naꞌ ureꞌnëꞌ xniꞌa Jesús uzulaonëꞌ rbedyinëꞌ, rlaꞌonëꞌ nisa rero laohuëꞌ niꞌa Jesús. Ude naꞌ rziꞌnëꞌ guitzaꞌ guichonëꞌ resebidyinëꞌ niꞌa Jesús, raonëꞌ situ niꞌa Jesús, uz̃iꞌnëꞌ aceite rlaꞌ z̃ixi z̃eo, blaꞌonëꞌn niꞌa Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Biz̃i benꞌ naca partido fariseo, benꞌ bëꞌ ta udao Jesús, cati blëꞌënëꞌ cabëꞌ bë nigula, naꞌ guquëꞌ pensari unëꞌ: “Chi tali benꞌ niga naquëꞌ benꞌ useꞌelaꞌ Diuzi, huacabëꞌnëꞌ ca naca nigula rquiꞌ lënëꞌ, danꞌ naquëꞌ nigula mala.” ");
INSERT INTO zpcNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Naꞌra una Jesús rëbinëꞌ Simón: ―Simón, reꞌendaꞌ iniaꞌ luëꞌ tu diꞌidzaꞌ. Naꞌra una Simón rëbinëꞌ Jesús: ―Una nëꞌëdiꞌ, maestro. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Uzu chopa beꞌmbyu reyaꞌalaꞌyaquëꞌ dumi quie benꞌ rue presta dumi. Tunëꞌ reyaꞌalëꞌ gaꞌyoꞌ gayuhua dumi plata. Naꞌ itunëꞌ reyaꞌalëꞌ gatzo gayuhua. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Naꞌ como lao rupayaquëꞌ biuz̃aqueꞌyaquëꞌ yeyuꞌeyaquëꞌ benꞌ unabayaquëꞌ presta dumi, quie lao rupateyaquëꞌ beziꞌz̃e benꞌ unabayaquëꞌ presta dumi. Naꞌra rnabaꞌ luëꞌ tu diꞌidzaꞌ: Lao rupayaquëꞌ, ¿ca nulayaquëꞌ lao rupayaquëꞌ reyaꞌalaꞌ gacayaquëꞌ agradecer mazara quie benꞌ naꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Naꞌra una Simón rëbinëꞌ Jesús: ―Raquedaꞌ benꞌ reyaꞌalaꞌ yalao quie benꞌ bë presta dumi. Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Napoꞌ rson cabëꞌ unaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Biz̃i beyëcho Jesús rnaꞌnëꞌ ganꞌ zë nigula, unëꞌ rëbinëꞌ Simón: ―¿Rlëꞌëloꞌ nigula niga? Nëꞌëdiꞌ baoyuꞌa luꞌu yuꞌu quioꞌ, naꞌ bibenloꞌ nisa tzëri niꞌa. Naꞌ nigula niga baodibinëꞌ niꞌa con nisa uredyinëꞌ besebidyinëꞌn con guitzaꞌ guichonëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Baoyuꞌa luꞌu yuꞌu quioꞌ, naꞌ biudaoloꞌ situ xagaꞌ ca naca costumbre de quiero. Pero desde uyuꞌa luꞌu yuꞌu quioꞌ, birsan nigula ni raonëꞌ situ niꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Biblaꞌoloꞌ aceite guichogaꞌ ca naca costumbre de quiero, naꞌ nigula niga bablaꞌonëꞌn niꞌa aceite rlaꞌ z̃ixi z̃eo. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Quie lenaꞌ rniaꞌ luëꞌ, ca tu ta nedyëꞌë nigula niga nëꞌëdiꞌ, lenaꞌ ruluꞌen nezinëꞌ de yelaꞌ huenitilao quienëꞌ ca nacala tamala babënëꞌ. Pero nu benꞌ bë lëꞌëtiꞌzi tamala, lëzi lëꞌëtiꞌzi nedyëꞌënëꞌ benꞌ beziꞌz̃e quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Naꞌra una Jesús rëbinëꞌ nigula: ―Abeziꞌz̃iaꞌ ca naca dulaꞌ xquia babaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Naꞌ biz̃i yaca benꞌ dyiarë lao mesa, yaca benꞌ bdyinrë udaorë, unayaquëꞌ laguedyiyaquëꞌ: ―¿Nuz̃i naca benꞌ niga yeziꞌz̃enëꞌ quie dulaꞌ xquia quie benëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Naꞌra una Jesús rëbinëꞌ nigula: ―Danꞌ rzudyiꞌilëloꞌ nëꞌëdiꞌ, babeyëriloꞌ lao Diuzi. Beyo, bira idëbiloꞌ quie dulaꞌ xquia quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ude beyudyi uzu Jesús lidyi Simón, naꞌ uzaꞌlënëꞌ lao chipchopa benꞌ quienëꞌ. Zioyaquëꞌ yedyi tu yedyi rguixogueꞌnëꞌ yaca benëꞌ cabëꞌ naca yelaꞌ rnabëꞌ quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Lëzi ziorë yaca nigula len Jesús. Lëyaca nigula beyue Jesús yelaꞌ hueꞌ yuꞌuyaquëꞌ, bebionëꞌ bichi be xiꞌibiꞌ yuꞌuyaquëꞌ. Ladoyaquëꞌ naꞌ ziorë benꞌ lao María Magdalena. Lëlëbëꞌ bebio Jesús gadyi bichi be xiꞌibiꞌ uyuꞌunëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Lëzi ziorë tu nigula lao Juana, z̃gula benꞌ lao Chuza, benꞌ naca gobierno quie rey Herodes. Lëzi ziorë itu nigula lao Susana, len yaca nigula bëꞌrë ta de quieyaquëꞌ ta gucalëyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Biz̃i ca zioyaquëꞌ yedyi tu yedyi bdyin yaca benꞌ zë ga zë Jesús. Caora babdupa benꞌ zë ganꞌ zënëꞌ, naꞌra unëꞌ tu diꞌidzaꞌ ta nacan irupa iyunala rëbinëꞌ leyaquëꞌ cani: ");
INSERT INTO zpcNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Zio tu benꞌ gaza bini trigo. Caora rzalanëꞌ bini trigo ca costumbre quieyaquëꞌ, bala bini yaqueꞌn tu neza, naꞌ ude ja benëꞌ bliojëꞌn, lëscanꞌ aodaorë yaca bguini len. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ibala bini trigo yaqueꞌn lao yo ga z̃uba tzayeꞌzi yu. Bëꞌ ulën ubidyin, danꞌ binacan tubelaozi yu. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ibala bini trigo yaqueꞌn ga rlë guixiꞌ yëchiꞌ. Biz̃i guixiꞌ yëchiꞌ guꞌunin, naꞌ bdyiaguiꞌn bini trigo. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ibala bini trigo yaqueꞌn ga naca tubelaozi yu. Guꞌunin huen bëꞌn usecho dyaꞌa. Udyian tu gayuhua bini trigo quie lao tu niꞌan. Beyudyi unë Jesús diꞌidzaꞌ unëꞌ zidzo unëꞌ: ―Leꞌe babe, ulezë nagale canꞌ rniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Naꞌra unaba yaca benꞌ quie Jesús ga huen dyin diꞌidzaꞌ unëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Naꞌra unëꞌ rëbinëꞌ yaca benꞌ quiëꞌ: ―Uzioñeꞌecazi Diuzi leꞌe ca naca quie yelaꞌ rnabëꞌ quienëꞌ. Naꞌ yaca benꞌ tula, rëbaꞌ leyaquëꞌ conlë diꞌidzaꞌ ta nacan irupa iyunala como danꞌ baꞌalaꞌcazi rlëꞌëyaquëꞌ, rueyaquëꞌ ca benꞌ birlëꞌë, baꞌalaꞌcazi reyaquëꞌ, rueyaquëꞌ ca benꞌ birioñeꞌe. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Cani naca quie diꞌidzaꞌ ta nacan irupa iyunala: Bini trigo ruen ca quie xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Naꞌ bini yaqueꞌ tu neza, ruen ca quie benëꞌ babzënaga xtiꞌidzaꞌ Diuzi, pero biz̃i zaꞌ xanꞌ taxiꞌibiꞌ reguban ca naca diꞌidzaꞌ babeyaquëꞌ ta bira hue quieyaquëꞌn, biyeyëriyaquëꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Naꞌ bini yaqueꞌ lao yo ga z̃uba tzayeꞌzi yu, ruen ca quie benꞌ babzënaga xtiꞌidzaꞌ Diuzi, naꞌ uyezilaꞌadyiꞌyaquëꞌn bë quieyaquëꞌn tu chiꞌ. Pero danꞌ nacayaquëꞌ ca quie lue bini biuyuꞌun zituꞌ yu, quie lenaꞌ tu chiꞌzi bë quieyaquëꞌn. Cati gutaꞌ zëdi quieyaquëꞌ, naꞌ psanyaquëꞌ, bira bë quieyaquëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Naꞌ bini yaqueꞌ ga rlë guixiꞌ yëchiꞌ, ruen ca quie benꞌ bzënaga xtiꞌidzaꞌ Diuzi, pero bibë quieyaquëꞌn. Naoziyaquëꞌ neza quieyaquëꞌ, rdëbiyaquëꞌ quie dza rdayaquëꞌ lao yedyi layu, rzaꞌlaꞌadyiꞌyaquëꞌ ta de lao dyilayu. Lëlëyaquëꞌ naca quieyaquëꞌ ca quie bini bibëꞌ usecho. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Naꞌ bini yaqueꞌ lao tubelaozi yu, ruen ca quie benꞌ bzënaga xtiꞌidzaꞌ Diuzi, naꞌ bëyaquëꞌ quieyaquëꞌn. Du guicho du laꞌadyiꞌyaquëꞌ naoyaquëꞌn. Lëlëyaquëꞌ naca quieyaquëꞌ ca quie bini bëꞌ usecho dyaꞌa. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","―Nunu ugaꞌalaꞌ lámpara ta utacoron caja, ni ta ucachiꞌron z̃an belaga. Ruen zi uzuro lámpara sibi ta useniꞌn ta ilëꞌë benꞌ zaꞌ tzuꞌu luꞌu yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Cabëꞌ naca quie lámpara, canaꞌ nacarën quie yaca benëꞌ. Yugulu ta pcachiꞌ yaca benëꞌ, huadyin dza yebio Diuzi ta pcachiꞌyaquëꞌ, cuionëꞌn zacaꞌlao ta ilëꞌë ja benëꞌ len. Lëscanꞌ yugulu diꞌidzaꞌ negachiꞌ rnë yaca benëꞌ, huadyin dza quixogueꞌ Diuzi ca diꞌidzaꞌ negachiꞌ unayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ulezë nagale dyëꞌëdi. Nu benꞌ rue quie ta tzioñeꞌenëꞌ bi na xtiꞌidzaꞌ Diuzi, uzioñeꞌera Diuzi lëbëꞌ mazara, pero nu benꞌ bihue quie ta tzioñeꞌenëꞌ xtiꞌidzaꞌ Diuzi, hueguba Diuzi hasta tadaoꞌ baoyoñeꞌenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Biz̃i bdyin z̃naꞌ Jesús len yaca biꞌ bichinëꞌ ganꞌ zënëꞌ, pero biuz̃aqueꞌ tzuꞌuyaquëꞌ luꞌu yuꞌu danꞌ nitaꞌ yaca benꞌ zë gula ganꞌ zënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Naꞌra tu benꞌ zë ganꞌ zënëꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Laliꞌa babdyin z̃naoꞌ len yaca biꞌ bichoꞌ. Reꞌenyaquëꞌ hueꞌlëyaquëꞌ luëꞌ diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Biz̃i una Jesús rëbinëꞌ yaca benꞌ nitaꞌ rzënaga: ―Con nu benꞌ rzënaga rue quienëꞌ xtiꞌidzaꞌ Diuzi, lëleyaquëꞌ naquëꞌ ca quie z̃naꞌa, ca quie biꞌ bichaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Biz̃i dza tula uyuꞌu Jesús lënëꞌ yaca benꞌ quiëꞌ luꞌu barco, naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Tzioro tzalaꞌla lagun. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Naꞌra uzaꞌyaquëꞌ zioyaquëꞌ tzalaꞌla lagun. Naꞌ tu zaidyinrayaquëꞌ gutaꞌ Jesús gusinëꞌ. Canaꞌ uzulao rda tu be bedunꞌ huala gula lao nisa, baredzaꞌ nisa luꞌu barco bareꞌennan yeton. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Naꞌra psebë yaca benꞌ quienëꞌ lëbëꞌ, unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¡Maestro! ¡Maestro! ¡Bareto barco luꞌu nisa! Canaꞌ uyasa Jesús udilanëꞌ be bedunꞌ ta rda lao nisa. Lëcanaꞌ lapsanten laoreꞌten chizi. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Naꞌra unëꞌ rëbinëꞌ yaca benꞌ quienëꞌ: ―¿Bixquienꞌ biuzudyiꞌilële Diuzi ta ute uselanëꞌ raꞌo? Biz̃i leyaquëꞌ du rdzebiyaquëꞌ, unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Nuz̃i benꞌ niga rnabëꞌnëꞌ be bedunꞌ len nisa ralen quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Biz̃i bdyinyaquëꞌ yu nebaba Gadara ta reꞌn tzalaꞌ lagun ganꞌ nebaba estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Biz̃i bëꞌ bero Jesús luꞌu barco, caora naꞌ ubigaꞌ tu benꞌ yedyi naꞌ. Baoca zi dza yuꞌunëꞌ bichi be xiꞌibiꞌ. Rdanëꞌ du guidinëꞌ, biraconëꞌ z̃abanëꞌ. Nica zuzëꞌ z̃an yuꞌu, denꞌ zunëꞌ ga rcachiꞌyaquëꞌ benꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Cati blëꞌënëꞌ Jesús, naꞌ uditzu z̃ibinëꞌ ureꞌnëꞌ lao Jesús uredyiyaꞌnëꞌ rëbinëꞌ Jesús: ―¿Bixquienꞌ zaoꞌ niga hueloꞌ nëꞌëdiꞌ zëdi? Nubëꞌdaꞌ luëꞌ Jesús, z̃iꞌi Diuzi zu guibá. Rnabayëchaꞌ laoloꞌ ta biutzagalaoloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Canaꞌ una benꞌ naꞌ danꞌ bë Jesús mandado ta yero bichi be xiꞌibiꞌ yuꞌunëꞌ, danꞌ rnabëꞌcazin yuꞌun lëbëꞌ. Biz̃i baoca zë lasa rquioyaquëꞌ lëbëꞌ naꞌanëꞌ len niꞌanëꞌ, pero ruz̃uz̃u ruquinonëꞌn, rz̃unonëꞌ rquiëꞌn lëbëꞌ lao lato ga bidyia yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Naꞌra unaba Jesús len: ―¿Bi laoloꞌ? Naꞌ bequëbin rëbin lëbëꞌ: ―Xopa mila laohuaꞌ. Canaꞌ unan danꞌ neyë yaca taxiꞌibiꞌ uyuꞌu benꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Naꞌra una yaca bichi be xiꞌibiꞌ unabayëchiꞌyacan ta biuseꞌelaꞌ Jesús leyacan luꞌu yero zituꞌ gula ga yedzagalaoyacan. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lëganꞌ naꞌ nitaꞌ cuchi zë lao yaꞌa yuꞌuyacabaꞌ huao. Naꞌ unabayëchiꞌyacan Jesús ta tzetzuꞌuyacan yaca cuchi. Naꞌra bëꞌnëꞌ lato leyacan tzetzuꞌuyacan cuchi. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Canaꞌ guca bero yaca bichi be xiꞌibiꞌ benꞌ naꞌ, zioyacan yetzuꞌuyacan cuchi. Biz̃i ca uyuꞌuyacan cuchi, uxitiyacabaꞌ luꞌu barranca bguinuyacabaꞌ luꞌu nisa ga gutiyacabaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Biz̃i caora blëꞌë yaca benꞌ rapa cuchi cabëꞌ guca quieyacabaꞌ, naꞌ bdzebiyaquëꞌ uzaꞌyaquëꞌ zioyaquëꞌ tzetixogueꞌyaquëꞌ yaca benꞌ lao yedyi len yaca benꞌ zio layela cabëꞌ guca. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Canaꞌ zio yaca benëꞌ tzenaꞌyaquëꞌ cabëꞌ guca. Cati bdyinyaquëꞌ ganꞌ zë Jesús, blëꞌëyaquëꞌ benꞌ uyuꞌu bichi be xiꞌibiꞌ. Blëꞌëyaquëꞌ areꞌnëꞌ chizi xniꞌa Jesús, anaconëꞌ z̃abanëꞌ, abeyuꞌunëꞌ pensari. Caora naꞌ, tu begaꞌnziyaquëꞌ bdzebiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ca naca yaca benꞌ blëꞌë, udixogueꞌyaquëꞌ cabëꞌ guca quie benꞌ uyuꞌu bichi be xiꞌibiꞌ beroyacan ganꞌ uyuꞌuyacan. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nun quie canꞌ guca, gudyi yaca benꞌ yedyi Gadara ta yezaꞌ Jesús yeyoguëꞌ ga tula, danꞌ rdzebiyaquëꞌ canꞌ guca. Naꞌ bezaꞌ Jesús beyuꞌunëꞌ luꞌu barco zeyoguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pero tu binezaꞌ Jesús, unabayëchiꞌ benꞌ uyuꞌu bichi be xiꞌibiꞌ chi bisaqueꞌ tziolënëꞌ lëbëꞌ con ga zioguëꞌ. Biz̃i una Jesús gudyinëꞌ lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Bigaca saoꞌ. Beyo z̃an yuꞌu quioꞌ, yetixogueꞌ yaca benꞌ nitaꞌ z̃an yuꞌu quioꞌ con cabëꞌ bë Diuzi quioꞌ beyacoꞌ. Naꞌra bezaꞌnëꞌ zeyoguëꞌ udixogueꞌnëꞌ yaca benëꞌ lao yedyi con cabëꞌ bë Jesús beyuenëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Biz̃i cati bedyin Jesús tatula ga uzëꞌë itzalaꞌ lagun, biz̃i yaca benëꞌ beziꞌyaquëꞌ lëbëꞌ dyëꞌëdi danꞌ nitaꞌyaquëꞌ rbezayaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lëscanꞌ bdyin tu benꞌ lao Jairo, naquëꞌ benꞌ napa dyin luꞌu idaoꞌ sinagoga. Lëlëbëꞌ bdyinnëꞌ uditzu z̃ibinëꞌ z̃niꞌa Jesús. Naꞌ unabëꞌ cule lao Jesús ta tzio Jesús z̃an yuꞌu quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Unëꞌ canaꞌ danꞌ zu tuzi z̃iꞌinëꞌ nigula. Lëz̃iꞌinëꞌ nigula naꞌ chipchopa iza zubiꞌ, naꞌ debiꞌ raca z̃hueꞌbiꞌ bagatibiꞌ. Ca naca zio Jesús lënëꞌ leyaquëꞌ lado yaca benëꞌ, lega rquidiꞌ yaca benëꞌ lëbëꞌ ganꞌ zionëꞌ yuꞌunëꞌ neza. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lëladoyaquëꞌ naꞌ zio tu nigula zu ubaꞌa aoca lao chipchopa iza. Aoyonëꞌ lao médico zë, bënëꞌ gasto dumi quiëꞌ. Ni tu médico biuz̃aqueꞌyaquëꞌ yeyueyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Lëlëbëꞌ yasëꞌ bago xcuꞌudzu Jesús bdaꞌnëꞌ z̃benëꞌ z̃aba Jesús. Ca bdaꞌnëꞌ z̃benëꞌ z̃aba Jesús, laolezate quie ubaꞌa quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―¿Nuz̃i bdaꞌ z̃be z̃abaꞌ? Naꞌra una yugo yaca benëꞌ zë naꞌ rëbiyaquëꞌ Jesús: ―Nunu bdaꞌ z̃be z̃aboꞌ. Lëscanꞌ una Pedro len yaca benꞌ laguedyinëꞌ, rëbiyaquëꞌ lëbëꞌ: ―Maestro, rquidiꞌ yaca benëꞌ luëꞌ de lao rupalaꞌate, naꞌ como rnaoꞌ: “¿Nuz̃i bdaꞌ z̃be z̃abaꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Naꞌra una Jesús: ―Zu tu benꞌ bdaꞌ z̃be z̃abaꞌ, danꞌ gucabëꞌdaꞌ bro yelaꞌ huaca quiaꞌ beyaca benꞌ bdaꞌ z̃be z̃abaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Biz̃i cati blëꞌë nigula gucabëꞌ Jesús canꞌ bë nigula, du rdzebinëꞌ bdyinnëꞌ uditzu z̃ibinëꞌ z̃niꞌa Jesús. Naꞌ unëꞌ udixogueꞌnëꞌ zaquëꞌlao lao yaca benëꞌ, danꞌ bdaꞌnëꞌ z̃benëꞌ z̃aba Jesús. Lëzi udixogueꞌrënëꞌ beyacanëꞌ caora bdaꞌnëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Biz̃i una Jesús rëbinëꞌ nigula: ―Zanaꞌ, danꞌ zudyiꞌilëloꞌ nëꞌëdiꞌ, babeyacoꞌ. Beyo, cueꞌ chizi luꞌu guicho laxtaꞌoloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Caora zë Jesús nernënëꞌ, cati bdyin tu benꞌ uzaꞌ z̃an yuꞌu quie Jairo, benꞌ napa dyin luꞌu idaoꞌ sinagoga. Naꞌ unëꞌ rëbinëꞌ Jairo: ―Baguti z̃iꞌiloꞌ. Bira cule hueloꞌ Maestro zëdi. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Biz̃i cati be Jesús ca unëꞌ, naꞌ unëꞌ rëbinëꞌ Jairo: ―Biidzeboꞌ. Sudyiꞌilëloꞌ nëꞌëdiꞌ con lëzin hueyaca z̃iꞌiloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Cati bdyinyaquëꞌ z̃an yuꞌu quie Jairo, bibëꞌnëꞌ lato nurla tzuꞌulënëꞌ luꞌu yuꞌu. Naꞌ uyuꞌulënëꞌ Pedro, len Jacobo, len Juan, len xuzi z̃naꞌ xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Biz̃i rbedyi lao yuguluyaquëꞌ raca beyëchiꞌ quieyaquëꞌ quie biꞌ huati. Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Bicuedyile. Leꞌe nale bagutibiꞌ, pero nëꞌëdiꞌ niaꞌ rasizibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Biz̃i yaca benëꞌ bz̃idyiyaquëꞌ quienëꞌ, danꞌ unëꞌ canꞌ, danꞌ baneziyaquëꞌ banati xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Naꞌra bëxo Jesús naꞌa xcuidiꞌ huati, naꞌ unëꞌ zidzo unëꞌ: ―Xcuidiꞌ, uyasa. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ca unëꞌ canaꞌ, babeban xcuidiꞌ labeyasatebiꞌ. Naꞌ bë Jesús mandado ta hueꞌyaquëꞌ ta gao xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Biz̃i xuzi z̃naꞌ xcuidiꞌ huati, tu begaꞌnziyaquëꞌ bebanyaquëꞌ canꞌ guca. Naꞌ gudyi Jesús leyaquëꞌ: ―Ni tu nunu yëbile cabëꞌ biaꞌ quie biꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Naꞌra betupa Jesús lao chipchopa benꞌ quienëꞌ bëꞌnëꞌ yelaꞌ huaca quienëꞌ ta yebioyaquëꞌ bichi be xiꞌibiꞌ yuꞌu yaca benëꞌ, lëscanꞌ ta yeyueyaquëꞌ nacala yelaꞌ hueꞌ yuꞌu yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Useꞌelaꞌnëꞌ leyaquëꞌ tzetixogueꞌyaquëꞌ yaca benëꞌ de que bazaꞌ dza inabëꞌ Diuzi lao yaca benꞌ nitaꞌ lao yedyi layu, lëzi ta yeyueyaquëꞌ benꞌ raca z̃hueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Bëꞌ baziole yuꞌule neza, ni tu bibi huaꞌale, ni tu yaga, ni tu yëxo, ni ta gaole, ni dumi. Nica huaꞌale chopa cueꞌ z̃abale, tu cueꞌzin huaꞌale. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ga idyinle z̃an yuꞌu quie benëꞌ ga gasile, biutzaꞌle. Tuzi ga gasile hasta que idyin dza yezaꞌle. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Chi ga bireꞌenyaquëꞌ yeziꞌyaquëꞌ leꞌe, ulezaꞌ lao yedyi, gusile bëxte yu dyia niꞌale ta gacan tu seña de que bibë quieyaquëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Naꞌ bezaꞌyaquëꞌ zioyaquëꞌ lao duz̃ete yedyi ta quixogueꞌyaquëꞌ ca hue Diuzi ta gataꞌ yelaꞌ neban quiejëꞌ tuzioli, lëzi ta yeyueyaquëꞌ yaca benꞌ raca z̃hueꞌ lao duz̃e ganꞌ rdayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Caora naꞌ Herodes, benꞌ naca gobernador, unezinëꞌ lao duz̃ete cabëꞌ rue Jesús. Naꞌ rdëbinëꞌ raquëꞌ pensari, danꞌ rna yaca benëꞌ rnayaquëꞌ quie Jesús naquëꞌ Juan bautista babebannëꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Naꞌ balayaquëꞌ rnayaquëꞌ quie Jesús naquëꞌ profeta Elías abelaꞌnëꞌ tatula. Naꞌ ibalayaquëꞌ rnayaquëꞌ quie Jesús naquëꞌ benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi tiempote, benꞌ beban tatula. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Biz̃i una Herodes rëbinëꞌ laguedyinëꞌ: ―Nëꞌëdiꞌ biaꞌ mandado ichuguyaquëꞌ lubaꞌ Juan agutinëꞌ. ¿Naꞌ nuz̃i benꞌ rda ruenëꞌ cabëꞌ ca diꞌidzaꞌ ruꞌe yaca benëꞌ? Naꞌra Herodes guꞌunnëꞌ ilëꞌënëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Biz̃i bëꞌ bedyin yaca benꞌ quienëꞌ ganꞌ zu Jesús, caora naꞌ gudyiyaquëꞌ lëbëꞌ con canꞌ bëyaquëꞌ ganꞌ uyoyaquëꞌ. Naꞌra uquiëꞌ Jesús leyaquëꞌ ziolënëꞌ leyaquëꞌ tu lao lato ga regaꞌnnan gaꞌalaꞌ yedyi Betsaida. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bëꞌ unezi yaca benëꞌ azioguëꞌ ruꞌa yedyila, naꞌ zioyaquëꞌ ganꞌ zënëꞌ. Naꞌ beziꞌnëꞌ leyaquëꞌ udixogueꞌnëꞌ leyaquëꞌ quie yelaꞌ rnabëꞌ quie Diuzi. Lëzi beyuerënëꞌ yaca benꞌ raca z̃hueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Biz̃i bardzeꞌ baraꞌ dza, ubigaꞌ yaca benꞌ quiëꞌ ganꞌ zënëꞌ rëbiyaquëꞌ lëbëꞌ: ―Gudyi yaca benëꞌ yeyoyaquëꞌ con ga reꞌ yedyi gaꞌalaꞌ ta tzetiloyaquëꞌ ta gaoyaquëꞌ ta yezilaꞌadyiꞌyaquëꞌ, porque ganꞌ zëro niga, bide ta gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Naꞌra una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ―Ulehueꞌ yaca benëꞌ ni ta gaoyaquëꞌ. Naꞌra unayaquëꞌ rëbiyaquëꞌ Jesús: ―Binuꞌandoꞌ tazë. Gaꞌyoꞌzi yëta xtila len ichopa bela ta nuꞌandoꞌ. Lëzin de chi bitziondoꞌ tzegueꞌndoꞌ mazara ta gao yaca benꞌ niga. ―Canaꞌ unayaquëꞌ rëbiyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Naꞌ biz̃i nitaꞌ ca du gaꞌyoꞌ mila beꞌmbyu ganꞌ zë Jesús. Naꞌra una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ―Uleyëbiyaquëꞌ cueꞌyaquëꞌ lao gatzo gayuhua huioyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Canaꞌ ureꞌyaquëꞌ lao gatzo gayuhua huioyaquëꞌ lao yuguluyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Naꞌra uz̃iꞌ Jesús lao gaꞌyoꞌ yëta xtila len lao chopa bela bazënëꞌn. Naꞌ unëꞌë ladza unëꞌ rëbinëꞌ Diuzi “Diuxcaleloꞌ.” Ude naꞌ, bëꞌnëꞌn yaca benꞌ quienëꞌ ta quisiyaquëꞌn hueꞌyaquëꞌ ta gao yaca benꞌ reꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Biz̃i udao yuguluteyaquëꞌ beloyaquëꞌ. Ude naꞌ besedzaꞌyaquëꞌ chipchopa gaꞌ naga yaca ta yoz̃o beganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Biz̃i bdyin tu dza zulë Jesús yaca benꞌ quienëꞌ tu cuinziyaquëꞌ cati bëꞌlë Jesús Diuzi diꞌidzaꞌ. Naꞌ unëꞌ rëbinëꞌ yaca benꞌ quienëꞌ: ―¿Nuz̃i na yaca benëꞌ nacaꞌ nëꞌëdiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Naꞌra una yaca benꞌ quienëꞌ rëbiyaquëꞌ lëbëꞌ: ―Balayaquëꞌ nayaquëꞌ luëꞌ nacoꞌ Juan bautista, naꞌ ibalayaquëꞌ nayaquëꞌ nacoꞌ Elías. Pero ibalayaquëꞌ nayaquëꞌ nacoꞌ benꞌ udixogueꞌrë xtiꞌidzaꞌ Diuzi tiempote, benꞌ beban. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Caora naꞌ unëꞌ rëbinëꞌ yaca benꞌ quienëꞌ: ―¿Naꞌa leꞌe, nuz̃i nale nacaꞌ nëꞌëdiꞌ? Naꞌ unë Pedro: ―Luëꞌ nacoꞌ benꞌ Cristo, benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Biz̃i Jesús unëꞌ gudyinëꞌ leyaquëꞌ dyëꞌëdi ta biyëbiyaquëꞌ benëꞌ naquëꞌ benꞌ Cristo, benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Nëꞌëdiꞌ, bichi yugulu benëꞌ, lega yedzagalaohuaꞌ. Yaca benꞌ rnabëꞌ, len yaca xanꞌ pxuzi, len yaca benꞌ rsëdi ley quie Moisés, huaruꞌunlaꞌadyiꞌyaquëꞌ nëꞌëdiꞌ, gutiyaquëꞌ nëꞌëdiꞌ. Pero te gaca lao tzona dza, huebanaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Lëzi unarëꞌ rëbinëꞌ leyaquëꞌ: ―Chi nu yaca benꞌ reꞌen inao nëꞌëdiꞌ, ruen zi bira inaoyaquëꞌ ca rna pensari quieyaquëꞌ. Ruen zi biidzebiyaquëꞌ naoyaquëꞌ nëꞌëdiꞌ yugu dza, baꞌalaꞌcazi ruen z̃udyi guti ja benëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chi nu yaca benꞌ rdzebi inaoyaquëꞌ nëꞌëdiꞌ, danꞌ rdzebiyaquëꞌ gatiyaquëꞌ tanun quiaꞌ, bigataꞌ yelaꞌ neban quiejëꞌ tuzioli. Pero nu yaca benꞌ bibdzebi inaoyaquëꞌ nëꞌëdiꞌ, bibdzebiyaquëꞌ gatiyaquëꞌ tanun quiaꞌ, lëlëyaquëꞌ huataꞌcazi yelaꞌ neban quieyaquëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Biz̃i gan de quie nu benëꞌ anaca quiëꞌ lao yugulute ta de lao yedyi layu, chi bigataꞌ yelaꞌ neban quiëꞌ tuzioli? ");
INSERT INTO zpcNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chi nu benꞌ chuꞌunlaꞌadyiꞌ nëꞌëdiꞌ yedueꞌyaquëꞌ hue quieyaquëꞌ canꞌ baoniaꞌ, lëzi nëꞌëdiꞌ, bichi yugulu benëꞌ, huaruꞌunlaꞌadyaꞌ leyaquëꞌ cati yeguidaꞌ inabiꞌa lao yedyi layu ca rey. Zeyuꞌa yelaꞌ huaca quie Xuzaꞌ Diuzi len yaca ángel naca laꞌiya quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tali ca rniaꞌ leꞌe, binegati bala leꞌe nitaꞌ niga len nëꞌëdiꞌ tu binelëꞌële ca naca yelaꞌ huaca quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Biz̃i bëꞌ guca lao xuna dza una Jesús canaꞌ, urënëꞌ tu lao yaꞌa ta hueꞌlënëꞌ Diuzi diꞌidzaꞌ. Naꞌ uquiëꞌnëꞌ Pedro, len Santiago, len Juan. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Biz̃i ca uzulaonëꞌ ruꞌelënëꞌ Diuzi diꞌidzaꞌ, canaꞌ betzaꞌ laohuëꞌ len z̃abanëꞌ gucan bezëri di. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Caora naꞌ labdyinte Moisés len Elías ga zë Jesús, ruꞌelëyaquëꞌ lëbëꞌ diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Naꞌ tu xniꞌ z̃e ureꞌ ganꞌ zëyaquëꞌ tu ruꞌelëyaquëꞌ lëbëꞌ diꞌidzaꞌ unayaquëꞌ ca gaca quienëꞌ gatinëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Baꞌalaꞌcazi Pedro len benꞌ laguedyinëꞌ barnatzeguen gasiyaquëꞌ, begaꞌnyaquëꞌ rnaꞌyaquëꞌ ca naca yelaꞌ huaca quie Jesús bluꞌen ga zënëꞌ len chopa benꞌ ruꞌelënëꞌ diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Biz̃i bëꞌ bezaꞌ yaca benꞌ bëꞌlë Jesús diꞌidzaꞌ, naꞌ una Pedro rëbinëꞌ Jesús: ―Maestro, tahuen naꞌ zundoꞌ lëndoꞌ luëꞌ niga. Ben lato huendoꞌ tzona yuꞌu daoꞌ de guiz̃i. Huendoꞌ tun quioꞌ, itun quie Moisés, itun quie Elías. ―Canaꞌ una Pedro denꞌ binezinëꞌ bi nëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Biz̃i ca naca ruꞌe Pedro diꞌidzaꞌ, bdyin tu beo bdubin leyaquëꞌ ganꞌ nitaꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Biz̃i lado beo naꞌ beyaquëꞌ rchiꞌ Diuzi unëꞌ rëbinëꞌ leyaquëꞌ. ―Lëz̃iꞌinaꞌ niga, benꞌ nedyëꞌëdaꞌ. Ulezënaga quiëꞌ cabëꞌ nëꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ude beyaquëꞌ rchiꞌ Diuzi, blëꞌëyaquëꞌ ituzi Jesús zënëꞌ naꞌ. Ganura nitaꞌ len lëbëꞌ. Naꞌ begaꞌnyaquëꞌ bira unëyaquëꞌ. Lëzi bibi gudyiyaquëꞌ yaca benëꞌ ca guca quieyaquëꞌ ca blëꞌëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Biz̃i bezu dza tula, beyëziyaquëꞌ ga zu yaꞌa. Caora naꞌ uyo benꞌ zë gula yetilalaoyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Naꞌra unë tu benꞌ zë ladoyaquëꞌ unëguëꞌ zidzo: ―Maestro, bë tu cule, inaꞌloꞌ z̃iꞌinaꞌ niga. Zelao tuzi lëbiꞌ naca z̃iꞌinaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yuꞌubiꞌ tu bichi be mala ruxun lëbiꞌ rbedyiyaꞌbiꞌ. Rde naꞌ reruꞌunnan lëbiꞌ layu, raca bdyinꞌ ruꞌabiꞌ. Lega rulëtzaguen lëbiꞌ, bireꞌennan usannan lëbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bagudyaꞌ yaca benꞌ quioꞌ ta yebioyaquëꞌ bichi be mala yuꞌubiꞌ, pero biuz̃aqueꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Naꞌra una Jesús rëbinëꞌ yaca benëꞌ: ―¡Leꞌe, benꞌ zidi yaladyiꞌ, biralele! ¿Ca balala dza reꞌennan sëliaꞌ leꞌe suedaꞌ canꞌ ruele? Yaxiꞌ z̃iꞌiloꞌ dehuaꞌabiꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Biz̃i cati bdyin biꞌ yuꞌu taxiꞌibiꞌ bago ganꞌ zë Jesús, udi taxiꞌibiꞌ lëbiꞌ layu, pxizeran lëbiꞌ. Naꞌra udila Jesús bichi be xiꞌibiꞌ yuꞌubiꞌ beron zeyon beyacabiꞌ. Ude naꞌ beyuꞌenëꞌbiꞌ xuzibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Biz̃i begaꞌn yugulu benꞌ nitaꞌ naꞌ bebanyaquëꞌ ca naca yelaꞌ huaca quie Diuzi bë Jesús. Tu reban yaca benëꞌ, naꞌ una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Ulezënaga dyëꞌëdi con canꞌ niaꞌ. Nëꞌëdiꞌ, bichi yugulu benëꞌ, usedyin yaca benëꞌ nëꞌëdiꞌ lao naꞌa benꞌ rudie nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Biz̃i yaca benꞌ quienëꞌ biuyoñeꞌeyaquëꞌ ca unëꞌ. Binedyin hora ta tzioñeꞌeyaquëꞌ canꞌ unëꞌ. Lëzi bireyaz̃oyaquëꞌ inabayaquëꞌ yexiꞌidzëꞌ leyaquëꞌ cabiz̃i unëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Biz̃i yaca benꞌ quie Jesús rtzaloyaquëꞌ unayaquëꞌ: ―¿Nurla raꞌo gacararo belao cati idyinro ga zu Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero nezi Jesús ca naca pensari racayaquëꞌ. Lëcanaꞌ uz̃iꞌnëꞌ tu xcuidiꞌ bzënëꞌbiꞌ cuëta lëꞌënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Naꞌra unëꞌ rëbinëꞌ yaca benꞌ quienëꞌ: ―Chi nu yaca benꞌ reziꞌ xcuidiꞌ niga tanun quiaꞌ, lëscanꞌ reziꞌrëyaquëꞌ nëꞌëdiꞌ. Chi nu yaca benꞌ reziꞌ nëꞌëdiꞌ, lëscanꞌ reziꞌrëyaquëꞌ benꞌ useꞌelaꞌ nëꞌëdiꞌ. Quie lenaꞌ, nu leꞌe racalë laguedyi, biruele belao cuinle, lëbenꞌ naꞌ nacarëꞌ benꞌ belao entre leꞌe lao yugulule. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Naꞌra una Juan rëbinëꞌ Jesús: ―Maestro, bablëꞌëndoꞌ rda tu benꞌ rzëtoguëꞌ laoloꞌ rebioguëꞌ bichi be xiꞌibiꞌ yuꞌu benëꞌ. Begadyindoꞌnëꞌ udilalëndoꞌnëꞌ, danꞌ ruenëꞌ canaꞌ birdalënëꞌ raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Naꞌra una Jesús rëbinëꞌ Juan: ―Bihuegadyile benꞌ rue canꞌ, danꞌ nu benꞌ birue condre raꞌo, nacacazi quieyaquëꞌ ca quie benꞌ rnëculë raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Biz̃i baruen bago idyin dza yeyo Jesús guibá, naꞌ uzëꞌë du laꞌadyiꞌnëꞌ bdzeꞌnëꞌ neza zionëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Naꞌ aoseꞌelëꞌ benꞌ quienëꞌ udyialaoyaquëꞌ zioyaquëꞌ tu yedyi quie estado Samaria ta quiloyaquëꞌ lato ga idyinyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Biz̃i yaca benꞌ Samaritano, biguꞌunyaquëꞌ hueyaquëꞌ lato ta yegaꞌnyaquëꞌ ganꞌ, danꞌ neziyaquëꞌ bazioyaquëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Biz̃i cati be yaca benꞌ quie Jesús cabëꞌ bë yaca benꞌ Samaritano, naꞌra una Santiago len Juan rëbiyaquëꞌ Jesús: ―Señor, ¿reꞌenloꞌ guëz̃iro guiꞌ zaꞌ guibá ta uzeina utachin leyaquëꞌ cabëꞌ bë profeta Elías dza naꞌla? ");
INSERT INTO zpcNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Naꞌra unaꞌ Jesús leyaquëꞌ udilanëꞌ leyaquëꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Leꞌe binezile ca pensari calëla yuꞌule, danꞌ unale canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nëꞌëdiꞌ, bichi yugulu benëꞌ, cala bidaꞌ ta aodyiayaꞌ yaca benëꞌ, bidaꞌ ta ute uselaꞌ leyaquëꞌ. Naꞌ uz̃iꞌyaquëꞌ zioyaquëꞌ yedyi tula. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Biz̃i azioyaquëꞌ yuꞌuyaquëꞌ neza cati bdyin tu benꞌ unëꞌ rëbinëꞌ Jesús: ―¿Señor, huazaꞌliaꞌ luëꞌ con gatezi tzioꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Zu beló ga rasi yaca beꞌezaꞌ. Lëzi dyiarë lidyi bguini ga rasiyacabaꞌ. Pero nëꞌëdiꞌ, bichi yugulu benëꞌ, bizu lidyaꞌ ga idyinaꞌ suaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naꞌra una Jesús rëbinëꞌ benꞌ itu: ―Uda, unao nëꞌëdiꞌ. Naꞌ bequëbinëꞌ rëbinëꞌ Jesús: ―Señor, ben nëꞌëdiꞌ lato tzetapaꞌ xuzaꞌ, danꞌ bagatinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Bë lato ucachiꞌ yaca benꞌ birue quie xtiꞌidzaꞌ Diuzi xuzoꞌ. Pero naꞌ luëꞌ, uda ta quixogueꞌloꞌ benëꞌ xtiꞌidzaꞌ Diuzi ca naca yelaꞌ rnabëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Naꞌra una itu benꞌ rëbinëꞌ Jesús: ―Señor, reꞌendaꞌ inaohuaꞌ luëꞌ, pero ben lato tzeguedyaꞌ yaca benꞌ zu z̃an yuꞌu, chi usanyaquëꞌ nëꞌëdiꞌ ta inaohuaꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Nu benꞌ birnaꞌ tuzi xnezaꞌ inaonëꞌ nëꞌëdiꞌ, chi reyëchonëꞌ rnaꞌnëꞌ xcuꞌudzule, lenaꞌ ruluꞌen rnan quienëꞌ inaonëꞌ neza tula. Naꞌ binaca quienëꞌ ga zu Diuzi rnabëꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bëꞌ ude unë Jesús diꞌidzaꞌ, naꞌ ulioguëꞌ itzona galo chi benëꞌ ta useꞌelaꞌnëꞌ chopa huioyaquëꞌ zioyaquëꞌ yedyi tu yedyi ta udyialaonezayaquëꞌ con ganꞌ tzio Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ―Tali rniaꞌ leꞌe, nitaꞌ benꞌ zë, benꞌ rbeza uzënaga xtiꞌidzaꞌ Diuzi, naca quieyaquëꞌ ca quie usecho. Pero tu chopaziyaquëꞌ naca benꞌ reziꞌ usecho quie Diuzi, benꞌ rguixogueꞌ xtiꞌidzëꞌ. Tanaꞌ lenaꞌ, ruguin inabale Diuzi iseꞌelëꞌ mazara benꞌ yeziꞌ usecho, benꞌ quixogueꞌ xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Naꞌ uletzio leꞌe. Yezaꞌlaꞌadyiꞌle rseꞌelaꞌ leꞌe naca quiele ca quie becoꞌ z̃iꞌilaꞌ tziole lado yaca benꞌ naca ca lobo. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bihuaꞌale dumi, bihuaꞌale yëxo, bihuaꞌale ni itu cueꞌ guidi uliole. Lëzi bitzële hueꞌlële yaca benëꞌ zë diꞌidzaꞌ tu neza ganꞌ ziole. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Cati bayuꞌule luꞌu yuꞌu quie benëꞌ, reyaꞌalaꞌ inale yëbile xanꞌ yuꞌu: “Huabëchi Diuzi chizi luꞌu guicho laxtaꞌole ganꞌ zule niga.” ");
INSERT INTO zpcNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chi reziꞌyaquëꞌ leꞌe dyëꞌëdi, canaꞌ huabeꞌ chizi luꞌu guicho laxtaꞌoyaquëꞌ. Pero chi bireziꞌyaquëꞌ leꞌe dyëꞌëdi, bicueꞌ chizi luꞌu guicho laxtaꞌoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cati idyinle yuꞌu ganꞌ idyinle, naꞌazi sule, naꞌazi gaole yoꞌole con ta runyaquëꞌ. Nu benꞌ rue dyin, napëꞌ derecho quiz̃u xaꞌnnëꞌ lëbëꞌ. Tuzi yuꞌu ganꞌ idyinle naꞌ yegaꞌnle. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Cati idyinle tu yedyi ga reziꞌyaquëꞌ leꞌe, ulegao ta udyiayaquëꞌ laole gaole. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Lëzi yeyuele benꞌ raca z̃hueꞌ yedyi ganꞌ idyinle yëbileyaquëꞌ: “Babdyin dza hue quiele xtiꞌidzaꞌ Diuzi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Chi yedyi ganꞌ bdyinle biguꞌunyaquëꞌ yeziꞌyaquëꞌ leꞌe, uleta lao neza quieyaquëꞌ inale cani: ");
INSERT INTO zpcNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bëxte yu quie yedyi ni udaꞌn luꞌu huaracho quiendoꞌ, usisindoꞌn yedyibin ta nacan tu seña bibë quiele xtiꞌidzaꞌ Diuzi. Ruen zi inezile babdyin dza hue quiele xtiꞌidzaꞌ Diuzi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Rniaꞌ leꞌe, dza gaca juicio, huataꞌra castigo huala quie benꞌ yedyi bibeziꞌ leꞌe. Huacaran mazara cabëꞌ bë Diuzi quie yaca benꞌ ciudad Sodoma dza naꞌla. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","―¡Bayëchiꞌ gula gaca quie leꞌe, benꞌ yedyi Corazín! ¡Lëzi bayëchiꞌ gula gaca quie leꞌe, benꞌ yedyi Betsaida! Chi blëꞌë benꞌ yedyi Tiro len benꞌ yedyi Sidón ca yelaꞌ huaca bë Diuzi lao leꞌe, biunaoyaquëꞌ huerayaquëꞌ tamala quieyaquëꞌ dza naꞌla. Chi blëꞌëyaquëꞌ, abetzaꞌyaquëꞌ pensari quieyaquëꞌ, gucoyaquëꞌ laꞌariꞌ gaso, bdyiayaquëꞌ de guichoyaquëꞌ ta uluꞌen baneziyaquëꞌ ca tamala bëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Quie lenaꞌ, cati bdyin dza hue Diuzi juicio, huataꞌra castigo huala gula quiele, cala ca castigo gaca quie benꞌ yedyi Tiro len benꞌ yedyi Sidón. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Naꞌra leꞌe, benꞌ yedyi Capernaum, biinale rlëꞌë Diuzi leꞌe benꞌ huen yeyole guibá, dechanꞌ leꞌe yeyole lao guiꞌ gabila. Naꞌ una Jesús rëbinëꞌ yaca benꞌ quiëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","―Nu yaca benꞌ ruzënaga quiele, canaꞌ ruzënagarëyaquëꞌ quiaꞌ. Nu yaca benꞌ rusebiꞌ leꞌe, canaꞌ rusebiꞌrëyaquëꞌ nëꞌëdiꞌ. Chi nu benꞌ rusebiꞌ nëꞌëdiꞌ, canaꞌ rusebiꞌrëyaquëꞌ benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Naꞌra cati bedyin tzona galo chi yaca benꞌ useꞌelaꞌ Jesús, redaohueyaquëꞌ unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Señor, lente yaca bichi be xiꞌibiꞌ guleyacan quiendoꞌ cati bzëtondoꞌ laoloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Blëꞌëdaꞌ bguino xanꞌ taxiꞌibiꞌ Satanás z̃an guibá, uyëzin ca rëzi bdyito hueziuꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Naꞌra gunaꞌ leꞌe yelaꞌ huaca quiaꞌ ta nuliole yaca bëla, naꞌ nuliole yaca xuniꞌ, bibi hueyacabaꞌ quiele. Lëscanꞌ gunaꞌ leꞌe yelaꞌhuaca quiaꞌ ta huele gan xanꞌ taxiꞌibiꞌ bihuelënan leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tahuen naꞌ rale yaca taxiꞌibiꞌ quiele. Pero lenaꞌ binacaten ta yedaohuele. Nacaran ta yedaohuele danꞌ bazu laole lëꞌë guichi quie Diuzi de guibá. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lëhora naꞌ, du yuꞌu Jesús Bichi Be quie Diuzi, lega redaohuenëꞌ unëꞌ: ―Xuzaꞌ Diuzi, nacoꞌ benꞌ z̃e, nacoꞌ benꞌ rnabëꞌ guibá len lao yedyi layu. Luëꞌ pcachoꞌ yelaꞌ huaca quioꞌ quie yaca benꞌ na rioñeꞌe. Naꞌ bluꞌeloꞌ yelaꞌ huaca quioꞌ yaca benꞌ rale quioꞌ ca rue xcuidiꞌ ralebiꞌ quie xuzibiꞌ. Canaꞌ baoꞌ xuzaꞌ, danꞌ canaꞌ reꞌenloꞌ gaca. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Lao naꞌa babën xuzaꞌ yugulute. Nunu nuebëꞌ nëꞌëdiꞌ ca nuebëꞌ xuzaꞌ nëꞌëdiꞌ. Lëscanꞌ nunu nuebëꞌ xuzaꞌ ca nuebiꞌa xuzaꞌ. Yaca benꞌ baoliogaꞌ, lëleyaquëꞌ nuebëꞌyaquëꞌ xuzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Biz̃i unaꞌ Jesús yaca benꞌ quienëꞌ, unëꞌ rëbinëꞌ lëziyaquëꞌ: ―Tahuen gula naca quie leꞌe, danꞌ rlëꞌële cabëꞌ ruaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Rniaꞌ leꞌe canꞌ, danꞌ yaca benꞌ zë, benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi dza naꞌ, len yaca benꞌ naca rey, guꞌunyaquëꞌ ilëꞌëyaquëꞌ ca naca ta rlëꞌële, pero biblëꞌëyaquëꞌ. Guꞌunyaquëꞌ yeyaquëꞌ ca naca ta rele, pero bibeyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Biz̃i tu dza tula, uyo tu benꞌ rusëdi ley quie Moisés ganꞌ zë Jesús ta huenëꞌ Jesús prueba ca bi diꞌidzaꞌ yequëbinëꞌ. Naꞌ unëꞌ rëbinëꞌ Jesús: ―Maestro, ¿ca bi reyaꞌalaꞌ huaꞌ ta gataꞌ yelaꞌ neban quiaꞌ tuzioli? ");
INSERT INTO zpcNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―¿Biz̃i rna lëꞌë guichi ley quie Moisés? ¿Ca bi ca inaoꞌ rnën? ");
INSERT INTO zpcNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Naꞌra bequëbi benꞌ rusëdi ley quie Moisés unëꞌ rëbinëꞌ Jesús: ―“Reyaꞌalaꞌ idyëꞌëro Diuzi quiero du guicho du laꞌadyiꞌro. Lëzi reyaꞌalaꞌ idyëꞌëro laguedyiro cabëꞌ nedyëꞌëro cuinro.” ");
INSERT INTO zpcNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Lagazi unaoꞌ. Chi hue quioꞌ ca unaoꞌ, huataꞌ yelaꞌ neban quioꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero benꞌ rusëdi ley quie Moisés, guꞌunnëꞌ gacalënëꞌ cuinnëꞌ cabëꞌ diꞌidzaꞌ gudyinëꞌ Jesús. Canaꞌ unëꞌ rëbinëꞌ Jesús: ―¿Nuz̃i benꞌ naca laguedyaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Uzaꞌ tu benꞌ ciudad Jerusalén zionëꞌ yedyi Jericó. Biz̃i tu neza ganꞌ zionëꞌ, naꞌ bro yaca benꞌ uban ulanyaquëꞌ ta nuꞌë. Bëꞌyaquëꞌ lëbëꞌ ziꞌ, pcaꞌnyaquëꞌ lëbëꞌ du guidinëꞌ. Begaꞌnnëꞌ tu neza, ilëꞌëtiꞌzi bigutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Biz̃i naꞌ zio tu pxuzi tu neza ganꞌ de benꞌ naꞌ. Biz̃i bëꞌ blëꞌënëꞌ benꞌ de tu neza, naꞌ udenëꞌ tzalaꞌla zioguëꞌ yuꞌunëꞌ neza. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Lëscanꞌ uderë tu benꞌ naca z̃iꞌi suba Leví ganꞌ de benꞌ naca ziꞌ. Lëzi cati blëꞌënëꞌ benꞌ naꞌ, tu udezinëꞌ zionëꞌ yuꞌunëꞌ neza. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lëzi zio tu benꞌ uzaꞌ tu yedyi quie estado Samaria tu neza ganꞌ de benꞌ naca ziꞌ. Biz̃i ca blëꞌënëꞌ lëbëꞌ ganꞌ denëꞌ, naꞌ beyëchiꞌlaꞌadyiꞌnëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Naꞌra ubigaꞌnëꞌ ganꞌ de benꞌ naca ziꞌ, blaꞌonëꞌ aceite len vino ganꞌ naca hueꞌ. Ude naꞌ ptubinëꞌ laꞌariꞌ lao hueꞌ. Naꞌ pcuënëꞌ lëbëꞌ xcuꞌudzu bia quienëꞌ uquiëꞌnëꞌ lëbëꞌ con ganꞌ idyinyaquëꞌ yegaꞌnyaquëꞌ. Lëganꞌ naꞌ unëꞌë lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Biz̃i bezu dza tula, tu binesëꞌë, ulio benꞌ Samaria chopa dumi plata bëꞌnëꞌn benꞌ naca xanꞌ yuꞌu ganꞌ bdyinyaquëꞌ. Naꞌ unëꞌ rëbinëꞌ lëbëꞌ: “Gapoꞌ naꞌ hueꞌloꞌ ta gao benꞌ niga. Chi biguque dumi niga, naꞌ aozaꞌlaoraꞌ quiz̃ugaꞌ bëꞌ yediaꞌ tatula.” ");
INSERT INTO zpcNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Naꞌ una Jesús rëbinëꞌ benꞌ rusëdi ley quie Moisés: ―Pues rnabaꞌ luëꞌ, lao yuna yaca benꞌ ude naꞌ, ¿ca nurlayaquëꞌ naca benꞌ laguedyi benꞌ guca ziꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Naꞌra una benꞌ rsëdi ley quie Moisés rëbinëꞌ Jesús: ―Benꞌ beyëchiꞌlaꞌadyiꞌ benꞌ guca ziꞌ. Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Beyo, bërë con cabëꞌ bë benꞌ naꞌ, benꞌ beyëchiꞌlaꞌadyiꞌ benꞌ guca ziꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Naꞌ uzaꞌ Jesús uyuꞌunëꞌ neza zionëꞌ bdyinnëꞌ ga de tu yedyi. Lëganꞌ naꞌ zu tu nigula laonëꞌ Marta. Lëlëbëꞌ beziꞌnëꞌ Jesús z̃an yuꞌu quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Naꞌ zu tu z̃ila Marta laonëꞌ María. Ureꞌnëꞌ xniꞌa Jesús ta uzënaganëꞌ cabëꞌ rna Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero lega rdyine Marta quie dyin quienëꞌ rusiñaꞌnëꞌ ta gaoyaquëꞌ. Naꞌra ubigaꞌnëꞌ ga reꞌ Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―Señor, ¿bixquienꞌ birdëbiloꞌ quiaꞌ nëꞌëdiꞌ? Apcaꞌn z̃ilaꞌ María nëꞌëdiꞌ. Tuzaꞌ ruaꞌ dyin niga. Gudyi z̃ilaꞌ tu diꞌidzaꞌ yeguidabiꞌ gacalëbiꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Marta, Marta, lega rdyineloꞌ rdëbiloꞌ quie dyin quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero ta uzënagaro xtiꞌidzaꞌ Diuzi nacaran belao. Cabëꞌ rue María, reꞌbiꞌ ruzënagabiꞌ canꞌ niaꞌ, lenaꞌ nacaran huen. Bisaqueꞌ yëpaꞌbiꞌ: “Beyo, bicueꞌloꞌ rzënagoꞌ canꞌ rniaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Biz̃i bdyin tu dza uzu Jesús tu lao lato ga bëꞌlënëꞌ Diuzi diꞌidzaꞌ. Bëꞌ beyudyi bëꞌlënëꞌ Diuzi diꞌidzaꞌ, naꞌ unë tu benꞌ quienëꞌ rëbinëꞌ lëbëꞌ: ―Señor, psëdi nëtoꞌ cabëꞌ huendoꞌ ta hueꞌlëndoꞌ Diuzi diꞌidzaꞌ cabëꞌ bë Juan psëdinëꞌ yaca benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Naꞌra una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ―Cati hueꞌlële Diuzi diꞌidzaꞌ, inale cani: Xuzindoꞌ Diuzi zuloꞌ guibá, naca laꞌiya laoloꞌ. Rbezandoꞌ guida dza inabëꞌloꞌ lao yedyi layu cabëꞌ rnabëꞌloꞌ guibá ga zuloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gunoꞌ ta gaondoꞌ quie naꞌadza cabëꞌ ta rdzioguendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Beziꞌz̃e quiendoꞌ tamala bëndoꞌ cabëꞌ reziꞌz̃endoꞌ tamala bë yaca benëꞌ len nëtoꞌ. Gacalaoꞌ nëtoꞌ ta biiguinondoꞌ lao tamala, ucuasa ucuiꞌoloꞌtamala zaꞌ gaca quiendoꞌ. Amén. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Lëzi unarë Jesús rëbinëꞌ leyaquëꞌ: ―Ugunro lao tu leꞌe tziole gatzo yela lidyi tu amigo quiele yëbilenëꞌ: “Amigo, ben nëꞌëdiꞌ tzona yëta xtila ");
INSERT INTO zpcNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","como danꞌ bablaꞌ tu biꞌ amigo quiaꞌ z̃an yuꞌu. Naꞌ bibi de ta huaꞌabiꞌ gaobiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Lëzi ugunro bequëbi benꞌ zu luꞌu yuꞌu unëꞌ: “Bihueloꞌ nëꞌëdiꞌ zëdi, danꞌ baneyeyo yuꞌu quiaꞌ. Lëzi arasi yaca xcuidiꞌ quiaꞌ rz̃ubayacabiꞌ lao cama len nëꞌëdiꞌ. Bisaqueꞌ chasaꞌ gunaꞌ luëꞌ danꞌ rnaboꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pues rniaꞌ leꞌe, chi lëbëꞌ biuyasëꞌ hueꞌnëꞌ ta rnaba benꞌ naꞌ, baꞌalaꞌcazi naquëꞌ biꞌ amigo quienëꞌ, reꞌen ca reꞌennan chasëꞌ hueꞌnëꞌ yugulu ta rdziogue amigo quienëꞌ tacuenda bira bizëdi huenëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Cani rniaꞌ leꞌe: Ulenaba Diuzi ta rdzioguele, naꞌ gunnëꞌn. Ulequilo tali quie Diuzi, naꞌ huadzelan. Ulelidza Diuzi ganꞌ zunëꞌ, naꞌ huenëꞌ quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ruen zi huele canaꞌ, porque nu benꞌ rnaba Diuzi ta rdzioguenëꞌ, naꞌ hueꞌnëꞌn. Lëscanꞌ nu benꞌ rguilo tali quie Diuzi, naꞌ huadzelenëꞌn. Lëscanꞌ nu benꞌ rulidza Diuzi ganꞌ zunëꞌ, naꞌ huenëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Bi ca nale leꞌe xuzi xcuidiꞌ? ¿Hueꞌle z̃iꞌile yola lao laza inababiꞌ yëta xtila? Lëzi, ¿hueꞌle z̃iꞌile bëlala lao laza inababiꞌ bela? ");
INSERT INTO zpcNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Lëzi, ¿hueꞌle z̃iꞌile xuniꞌla lao laza inababiꞌ chita? ");
INSERT INTO zpcNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Chi leꞌe, benꞌ rda lao yedyi layu niga, chi nezile hueꞌle z̃iꞌile tu tadyaꞌa, naꞌ biz̃i Xuzile Diuzi zu guibá, neziranëꞌ ca leꞌe hueꞌnëꞌ benëꞌ tu tadyaꞌa, hasta udzeꞌnëꞌ Bichi Be quienëꞌ luꞌu guicho laxtaꞌo yaca benꞌ unaba len. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Biz̃i bdyin tu dza bebio Jesús tu bichi be xiꞌibiꞌ yuꞌu tu benꞌ bero. Caora bero bichi be xiꞌibiꞌ gan yuꞌun, labeyacate benꞌ naꞌ, benënëꞌ. Naꞌra begaꞌn yaca benëꞌ bebanyaquëꞌ cabëꞌ guca quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Canaꞌ una bala benëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Conlë yelaꞌ huaca quie Beelzebú, benꞌ naca xanꞌ taxiꞌibiꞌ, rebio benꞌ niga bichi be xiꞌibiꞌ yuꞌu yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Biz̃i ibalayaquëꞌ unabayaquëꞌ hue Jesús tu yelaꞌ huaca quie Diuzi z̃an guibá chi tali naquëꞌ benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero banezi Jesús cabëꞌ pensari raca yaca benëꞌ. Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Chi tu cueꞌ gobierno gaca zë cueꞌ partido, chi tilalëyaquëꞌ laguedyiyaquëꞌ benꞌ naca partido, bisue gobierno inabëꞌyaquëꞌ zidza. Lëzi chi gataꞌ dila quie yaca benꞌ z̃an yuꞌu, huaroyaquëꞌ huadzatzayaquëꞌ, bira saqueꞌ suyaquëꞌ tuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Lëzi canaꞌ nacarë quie Satanás. Chi rbio Satanás laguedyi bichi be xiꞌibiꞌn yuꞌu benëꞌ, bira saqueꞌ inabëꞌnan zidza. Niaꞌ leꞌe canaꞌ, como danꞌ nale conlë yelaꞌ huaca quie Beelzebú rebiogaꞌ bichi be xiꞌibiꞌ yuꞌu yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pero chi nacan tali ca nale, ¿biz̃i nale quie yaca benꞌ naca leꞌe tuz̃e, yaca benꞌ rebio bichi be xiꞌibiꞌ yuꞌurë yaca benëꞌ? Lenaꞌ huanayaquëꞌ leꞌe bisaqueꞌ taxiꞌibiꞌ yebion laguedyi xiꞌibiꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero conlë yelaꞌ huaca quie Diuzi rebiogaꞌ bichi be xiꞌibiꞌ yuꞌu yaca benëꞌ. Lenaꞌ uluꞌen azëcazi ladole yelaꞌ huaca quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Baruen quie Satanás ca quie tu benꞌ huala, benꞌ nuxu espada quie, benꞌ rapa lao yugulute ta de quie. Bisaqueꞌ tzuꞌu benꞌ tula siꞌ ta de quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Naꞌra chi guida tu benꞌ hualara ca lëbëꞌ, benꞌ dera yelaꞌ huaca quie, huenëꞌ gan ucaxonëꞌ lëbëꞌ. Canaꞌ cubanëꞌ espada quienëꞌ ta rzugadyilenëꞌ. Canaꞌ siꞌnëꞌ lao yugulute ta de quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Nu benꞌ birnëcule nëꞌëdiꞌ, condre nëꞌëdiꞌ zënëꞌ. Lëzi nu benꞌ biracalë nëꞌëdiꞌ, condre nëꞌëdiꞌ ruenëꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","―Biz̃i cati bero tu bichi be xiꞌibiꞌ ga yuꞌun benëꞌ, naꞌ rdan tu lao lato bidyi rguilon ga tzuꞌunan yezilaꞌadyiꞌn. Biz̃i cati birdzela ga tzuꞌun, naꞌ racan pensari: “Hueyaꞌa tatula ganꞌ brogaꞌ ta yeyuꞌa tatula.” ");
INSERT INTO zpcNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Biz̃i bëꞌ yedyinnan ganꞌ brona beꞌmbyu, anaca quienëꞌ ca quie tu z̃an yuꞌu neluba dyaꞌa, begaꞌnnan dyaꞌa gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Naꞌra tzion tzaxiꞌn igadyi bichi be xiꞌibiꞌ nacara mala ca len. Naꞌra tzuꞌu yuguluyacan beꞌmbyu. Biz̃i benꞌ naꞌ huacara mala quienëꞌ cabëꞌ naca quienëꞌ tanëro. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tu rnë Jesús rëbinëꞌ benëꞌ, naꞌ unë tu nigula zidzo rëbinëꞌ Jesús: ―Naca huen quie nigula biꞌa bgaꞌadyiꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Nacara huen quie benꞌ re rzënaga ca rna Diuzi, naꞌ rue quieyaquëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Biz̃i bdyinra yaca benꞌ zë ganꞌ zë Jesús, naꞌ uzulaonëꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Benꞌ mala naca benꞌ nitaꞌ naꞌa. Rnabarëyaquëꞌ huaꞌ yelaꞌ huaca ta zaꞌ guibá ilëꞌëyaquëꞌ. Pero bihuaꞌ yelaꞌ huaca ta zaꞌ guibá ca reꞌenyaquëꞌ. Ca yelaꞌ huaca bë Diuzi lënëꞌ profeta Jonás, canaꞌ huerënëꞌ lënëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Cabëꞌ guca quie Jonás, bë Diuzi yelaꞌ huaca len lëbëꞌ ta bluꞌenëꞌ yaca benꞌ nitaꞌ yedyi Nínive ga useꞌelaꞌ Diuzi lëbëꞌ, lëzi canaꞌ gacarë quiaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ. Hue Diuzi len nëꞌëdiꞌ tu yelaꞌ huaca ta uluꞌenëꞌ yaca benꞌ nitaꞌ naꞌa de que useꞌelaꞌnëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dza gaca juicio cati ichuguli Diuzi quie yaca benꞌ nitaꞌ naꞌa, lëcanaꞌ guida nigula rnabëꞌ lao yedyi nebaba Arabia ta ichugubëꞌnëꞌ quiele. Canaꞌ huenëꞌ como danꞌ lëbëꞌ uzëꞌë yedyi reꞌ zituꞌ zioguëꞌ yezënaguëꞌ ca ta rioñeꞌe Salomón dza naꞌla. Pero ladole zuaꞌ nëꞌëdiꞌ, benꞌ rnabëꞌra ca Salomón, naꞌ leꞌe biruzënagale quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Lëzi dza gaca juicio cati ichuguli Diuzi quie yaca benꞌ nitaꞌ naꞌa, lëcanaꞌ guida yaca benꞌ unitaꞌ yedyi Nínive dza naꞌla ta ichugubëꞌyaquëꞌ quiele. Canaꞌ hueyaquëꞌ como danꞌ leyaquëꞌ betzaꞌyaquëꞌ pensari quieyaquëꞌ caora cati bdyin Jonás udixogueꞌnëꞌ leyaquëꞌ xtiꞌidzaꞌ Diuzi. Pero ladole zuaꞌ nëꞌëdiꞌ, benꞌ rnabëꞌra ca Jonás, naꞌ leꞌe biruzënagale quiaꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","―Ni tule biugaꞌalaꞌle lámpara ucuiꞌolen ga negachiꞌ, nica quixolen z̃an caja. Ruen zi ixubalen sibi ta useniꞌn ta ilëꞌë yaca benꞌ zaꞌ tzuꞌu yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Naca laole ca quie tu lámpara rseniꞌn luꞌu guicho laxtaꞌole. Chi inaꞌle dyëꞌëdi hue quiele xtiꞌidzaꞌ Diuzi, lenaꞌ ruluꞌen quiele yuꞌu pensari quie Diuzi luꞌu guicho laxtaꞌole. Pero chi biinaꞌle dyëꞌëdi, chi bihue quiele xtiꞌidzaꞌ Diuzi, lenaꞌ ruluꞌen quiele rdale lao lato lao chula. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gapale cuidado hue quiele xtiꞌidzaꞌ Diuzi ta bitale lao lato lao chula. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chi rue quiele du guicho du laꞌadyiꞌle xtiꞌidzaꞌ Diuzi, canaꞌ tzioñeꞌele ca naca tali quie Diuzi, canaꞌ gaca quiele ca quie benꞌ zë lámpara ta useniꞌn ilëꞌënëꞌ ga zionëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Biz̃i babeyudyi unë Jesús canaꞌ, naꞌra gudyi tu benꞌ partido fariseo Jesús ta tzionëꞌ z̃an yuꞌu quienëꞌ ta gaonëꞌ. Naꞌ zio Jesús uyuꞌunëꞌ luꞌu yuꞌu quienëꞌ yaqueꞌnëꞌ ruꞌa mesa. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Naꞌra tu bebanzi benꞌ partido fariseo rnëꞌë ta biudibi naꞌa Jesús tu zagaonëꞌ. Biunao Jesús ca naca costumbre unaoyaquëꞌ rnayaquëꞌ danꞌ rguibi naꞌayaquëꞌ, canaꞌ neyëriyaquëꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Leꞌe benꞌ partido fariseo, rguibile xcuꞌudzu plato taza quiele, pero leꞌe yuꞌu pensari mala luꞌu guicho laxtaꞌole, rbanle ruele tamedian quie laguedyile. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Leꞌe benꞌ zidi! ¿Binezile reꞌen Diuzi huerële yëri luꞌu guicho laxtaꞌole? ");
INSERT INTO zpcNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pero chi reꞌenle huele yëri luꞌu guicho laxtaꞌole, ulehueꞌ ta de quiele yaca benꞌ yëchiꞌ. Naꞌtera gacale yëri duz̃ele. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Bayëchiꞌ gula naca quie leꞌe, benꞌ partido fariseo! Biz̃i lente guixiꞌ cuan ruꞌele Diuzi tu cueꞌn quie lao chi cueꞌna. Pero biruele bala ta yuꞌu niꞌa xnezi quie Diuzi, nica nedyëꞌële Diuzi. Lenaꞌ zacaꞌra huele, cala ca ta ruꞌele Diuzi tu cueꞌn quie lao chi cueꞌna, pero rupaten reyaꞌalaꞌ huele. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Bayëchiꞌ gula naca quie leꞌe, benꞌ partido fariseo! Lega raxele cueꞌle silla ga rbeꞌ yaca benꞌ balaꞌana luꞌu idaoꞌ sinagoga. Naꞌ lëzi lega raxele gapalaꞌn benëꞌ leꞌe ga ziole yuꞌu neza. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Bayëchiꞌ gula naca quie leꞌe, benꞌ rusëdi ley quie Moisés, len leꞌe, benꞌ partido fariseo! Leꞌe biruele tuzi ca nale. Naca quiele ca quie yerobá nadacon bëbi. Naꞌ biz̃i yaca benëꞌ rdeyaquëꞌ laonan bineziyaquëꞌ chi yerobá naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Naꞌra una tu benꞌ rusëdi ley quie Moisés rëbinëꞌ Jesús: ―Maestro, ca diꞌidzaꞌ unëloꞌ, lëzi rnëraoꞌ condre nëtoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―¡Bayëchiꞌ gula naca quie leꞌe, benꞌ rusëdi ley quie Moisés! Ruele cabëꞌ rue benꞌ rucuaꞌ yuaꞌ ziꞌi gula lao laguedyin tu ta bisueyaquëꞌ. Reꞌenle inao yaca benëꞌ leꞌe, hue quieyaquëꞌ ca inale, naꞌ inale canaꞌ reꞌen Diuzi hueyaquëꞌ, baꞌalaꞌcazi zëdi gula nacan ta hue quieyaquëꞌ len. Naꞌra leꞌe ni lëꞌëtiꞌ biyeyëchiꞌlaꞌadyiꞌle yaca benëꞌ gacalële leyaquëꞌ ta hue quieyaquëꞌ len. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Bayëchiꞌ gula naca quie leꞌe, benꞌ rusëdi ley quie Moisés! Como danꞌ cabëꞌ bë xuzixtaꞌole dza naꞌla bëtiyaquëꞌ nu benꞌ uda udixogueꞌ xtiꞌidzaꞌ Diuzi, canaꞌ reꞌenle huerële. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nacale de acuerdo con canꞌ bë xuzixtaꞌole. Chi leꞌe uzurële dza uzu xuzixtaꞌole, lëzi bëtile yaca benꞌ uda udixogueꞌ xtiꞌidzaꞌ Diuzi. Gucalële lëbizi xuzixtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Yelaꞌ rioñeꞌe quie Diuzi unëꞌ cani: “Huaseꞌelaꞌ yaca benꞌ quixogueꞌ diꞌidzaꞌ quiaꞌ laoyaquëꞌ. Naꞌra gutiyaquëꞌ balayaquëꞌ, naꞌ hualaoyaquëꞌ ibalayaquëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pero leꞌe, benꞌ nitaꞌ naꞌa, huaziꞌ Diuzi cuenda quiele quie yelaꞌ guti quie yugulu yaca benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi, desde dza ureꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Pues desde dza ulato ren quie Abel hasta dza bëtiyaquëꞌ Zacarías luꞌu idaoꞌ xcuꞌudzu becugo, lëlenaꞌ huaziꞌ Diuzi cuenda quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Bayëchiꞌ gula naca quie leꞌe, benꞌ rusëdi ley quie Moisés! Leꞌe ruzaꞌagale tzioñeꞌe yaca benëꞌ xtiꞌidzaꞌ Diuzi. Leꞌe birioñeꞌele xtiꞌidzaꞌ Diuzi, nica ruꞌele lato tzioñeꞌe yaca benꞌ reꞌen tzioñeꞌe len. ―Canaꞌ una Jesús gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bëꞌ una Jesús canꞌ gudyinëꞌ leyaquëꞌ, naꞌra bdzaꞌtzeguera yaca benꞌ rusëdi ley quie Moisés, len yaca benꞌ partido fariseo. Caora naꞌ uzulaoyaquëꞌ rueyaquëꞌ lëbëꞌ zëdi unabayaquëꞌ lëbëꞌ mazara diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Lega rbeꞌnaoyaquëꞌ lëbëꞌ reꞌenyaquëꞌ hueyaquëꞌ trampa quie Jesús ca diꞌidzaꞌ yequëbinëꞌ tacuenda ga gaoyaquëꞌ lëbëꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Biz̃i banitaꞌ benꞌ zë gula ga zë Jesús. Tantozi babdupa benꞌ zë, barquidiꞌyaquëꞌ laguedyiyaquëꞌ. Naꞌra una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ―Gapale cuidado bihuele ca rue yaca benꞌ naca partido fariseo, danꞌ nacayaquëꞌ benꞌ rlidza Diuzi de diꞌidzaꞌ ladzazi. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yugulu ta bë yaca benëꞌ negachiꞌzi, decazide yezacalaon quieyaquëꞌ lao Diuzi cabëꞌ bëyaquëꞌ. Ni tu ta bë yaca benëꞌ raqueyaquëꞌ chi nunu blëꞌë, decazide yezacalaon quieyaquëꞌ lao Diuzi cabëꞌ bëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yugulu ca naca diꞌidzaꞌ negachiꞌ rna yaca benëꞌ, huadyin dza yezacalaon quieyaquëꞌ lao Diuzi cabëꞌ diꞌidzaꞌ unayaquëꞌ. Lëzi yugulu diꞌidzaꞌ raque yaca benëꞌ diꞌidzaꞌ negüiꞌo, huadyin dza inezi yugulu benëꞌ cabëꞌ diꞌidzaꞌ unayaquëꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","―Leꞌe amigo quiaꞌ, rniaꞌ leꞌe: Biidzebile nu benꞌ reꞌen guti leꞌe, como danꞌ bëꞌ bagutiyaquëꞌ leꞌe, bira bide bihueyaquëꞌ quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ta rniaꞌ leꞌe nu benꞌ reyaꞌalaꞌ idzebile. Reyaꞌalaꞌ idzebile Diuzi como danꞌ de yelaꞌ rnabëꞌ quienëꞌ yeziꞌnëꞌ yelaꞌ neban quie yaca benëꞌ, naꞌ udzeꞌnëꞌ leyaquëꞌ luꞌu guiꞌ gabila. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Lëscanꞌ rniaꞌ leꞌe: ¿Cala rutiꞌyaca benëꞌ gaꞌyoꞌ bguini daoꞌ lao chopa dumi daoꞌ lasi? Naꞌ biz̃i laꞌacazi nacabaꞌ bguini daoꞌ biz̃u, biralaꞌadyiꞌ Diuzi quieyacabaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ta rniaꞌ leꞌe, hasta guitzaꞌ guichole nulaba Diuzi lao yuguluten. Biidzebile, zacaꞌrale lao Diuzi mazara ca yaca bguini daoꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","―Ta rniaꞌ leꞌe, nu benꞌ rnë cule nëꞌëdiꞌ lao yaca benꞌ nitaꞌ lao yedyi layu, lëzi nëꞌëdiꞌ, bichi yugulu benëꞌ, huaniaꞌ cule leyaquëꞌ lao yaca ángel quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero nu yaca benꞌ bichezilaꞌadyiꞌ nëꞌëdiꞌ lao yaca benꞌ nitaꞌ lao yedyi layu, lëzi nëꞌëdiꞌ bichezilaꞌadyaꞌ leyaquëꞌ lao yaca ángel quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Nu benꞌ rnëxiꞌibiꞌ condre nëꞌëdiꞌ, bichi yugulu benëꞌ, ruꞌen lato yeziꞌz̃e Diuzi quieyaquëꞌ. Pero nu benꞌ rnëxiꞌibiꞌ condre Bichi Be quie Diuzi, biyeziꞌz̃e Diuzi quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Cati usedyinyaquëꞌ leꞌe lao naꞌa benꞌ napa dyin luꞌu idaoꞌ sinagoga, o chi lao naꞌa yaca juez, o chi lao naꞌa yaca benꞌ rnabëꞌ, bidëbile bi diꞌidzaꞌ inale yequëbile yëbileyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Cati idyin hora inale yequëbile yëbileyaquëꞌ, caora naꞌ huacalë Bichi Be quie Diuzi leꞌe bi inale yequëbile yëbileyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Biz̃i lado yaca benꞌ naꞌ, uzë tu benëꞌ unëꞌ rëbinëꞌ Jesús: ―Maestro, aguti xuzaꞌ. Gudyi benꞌ bichaꞌ gunnëꞌ ta de quie xuzaꞌ ca tu ta reduꞌuledaꞌ siꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Rniaꞌ luëꞌ, binacan dyin quiaꞌ para huaꞌa laze quiele quie ta de quie xuzile. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Lëscanꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Gapale cuidado ta bisaꞌlaꞌadyiꞌle ta de lao yedyi layu, como danꞌ nacaran belao quiele gataꞌ yelaꞌ neban quiele tuzioli, cala ca ta saꞌlaꞌadyiꞌle ta de lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Naꞌra una Jesús tu ejemplo cani: ―Uzu tu benꞌ uñaꞌa. Guzanëꞌ lao yu quienëꞌ. Lega guca usecho quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Biz̃i benꞌ uñaꞌa guquëꞌ pensari unëꞌ: “¿Ca biz̃i huaꞌ? Bide ga udziꞌa usecho quiaꞌ, danꞌ lega gucana.” ");
INSERT INTO zpcNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Lenaꞌ guquëꞌ pensari unëꞌ: “Banezdaꞌ ca ta huaꞌ. Uquinugaꞌ yuꞌu ga udziꞌa usecho, bigaquen. Lenaꞌ hueraꞌ taz̃era tacuenda gaquen ga udziꞌa usecho quiaꞌ len yugulu ta de quiaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lëscanꞌ guquëꞌ pensari unëꞌ cuinzinëꞌ: “Lega guca usecho quiaꞌ. Huaquen lao zë iza. Quie lenaꞌ abdyin hora yezilaꞌadyaꞌ, zuaꞌ contento, yoꞌogaꞌ, gaohuaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero naꞌ una Diuzi rëbinëꞌ benꞌ uñaꞌa: “Benꞌ tondo luëꞌ, naꞌayela gatioꞌ. Naꞌ yugulu ta de quioꞌ, ¿nuz̃i gaca quie len?” ");
INSERT INTO zpcNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Canaꞌ nacan quie benꞌ uñaꞌa chi rcuezanëꞌ quiëꞌ cuinzinëꞌ dza rdanëꞌ lao yedyi layu. Naꞌ biz̃i Diuzi rlëꞌënëꞌ lëbëꞌ benꞌ yëchiꞌ gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Beyudyi una Jesús canaꞌ, unëꞌ rëbinëꞌ yaca benꞌ quienëꞌ: ―Con ca rniaꞌ leꞌe, bidëbile ga zaꞌ ta gaole. Bidëbile ga zaꞌ ta gacole. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nacaran belao hue quiele xtiꞌidzaꞌ Diuzi dza rdale lao yedyi layu, cala ca ta idëbile ga zaꞌ ta gaole, ta gacole. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ulenaꞌcara ca raca quie yaca bguini. Birazaraꞌnyacabaꞌ, biruerëyacabaꞌ ga udzeꞌyacabaꞌ ta gaobaꞌ, denꞌ rgaocazi Diuzi leyacabaꞌ. Naꞌ biz̃i leꞌe, ¡zacaꞌrale ca yaca bguini! ");
INSERT INTO zpcNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nitu nitule, baꞌalaꞌcazi rdëbitzeguele, bisaqueꞌ udaꞌrale ni itu hora ta yezurale lao yedyi layu bëꞌ beya dza quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Naꞌ chi ni ilëꞌëtiꞌ bisaqueꞌ udaꞌrale yezurale lao yedyi layu bëꞌ beya dza quiele, ¿bixquienꞌ rdëbile ga zaꞌ ta gaole, ga zaꞌ ta gacole? ");
INSERT INTO zpcNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ulenaꞌcara ca reꞌeni yaca yo. Birueyacan dyin, biraꞌaban yëla. Naꞌ biz̃i rniaꞌ leꞌe, ni rey Salomón, baꞌalaꞌcazi guconëꞌ laꞌariꞌ tzaoꞌ, laꞌariꞌ baquitu, bibetilan lëbizi yelaꞌ baquitu quie yo. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Cabëꞌ rue Diuzi rapëꞌ yo ta de lao layëla, baꞌalaꞌcazi gaca tu chopa dza huabidyin tzuꞌun laguiꞌ tzeina, canaꞌ huaparë Diuzi leꞌe, pero mazara leꞌe, benꞌ rdëbi ga zaꞌ ta gaole, ga zaꞌ ta gacole. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Quie lenaꞌ, bitale idëbile quilole ga zaꞌ ta gaole, ga zaꞌ ta yoꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bihuele canaꞌ, danꞌ canaꞌ rue yaca benꞌ rda lao yedyi layu, rdëbiyaquëꞌ bi ta gataꞌ quieyaquëꞌ. Pero zucazi Xuziro Diuzi, rnëꞌë leꞌe, banezinëꞌ bi ta rdzioguele. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ta nacaran belao hue quiele inaole xneza Diuzi, lëcanaꞌ gunnëꞌ lao yugulute ta rdzioguele. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","―Bidzebile, nacale ca quie becoꞌ z̃iꞌilaꞌ quiaꞌ, bia napaꞌ. Baꞌalaꞌcazi naca tu chopale, lega redaohue Xuziro Diuzi gunnëꞌ lato yedyinle ga zunëꞌ rnabëꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ulegutiꞌ ta de quiele. Dumi danꞌ gutiꞌle ta de quiele, naꞌ ulehueꞌn benꞌbide quie. Canaꞌ huacara tadyaꞌa quiele guibá, gun Diuzi quiele ta de guibá. Naꞌ ta gataꞌ quiele guibá, bisaqueꞌ cuan benëꞌ len, nica nu tzuꞌu udyiaguiꞌ len. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Con ga reꞌenle gataꞌ yelaꞌ uñaꞌa quiele, chi lao yedyi layu, chi guibá, lenaꞌ uluꞌen ca bi pensari racale, chi quie cuinzile, chi quie Diuzi. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","―Ulesu listo, ulehue ca rue benꞌ rugaꞌalaꞌ lámpara quie, barbezëꞌ chi benꞌ idyin z̃an yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Reyaꞌalaꞌ huele ca rue benꞌ zu rapa z̃an yuꞌu quie xaꞌne, benꞌ rbeza bëꞌ yedyin xaꞌnnëꞌ ganꞌ tzioguëꞌ ga raca huetzaganaꞌ. Rbezëꞌ ulidza xaꞌnnëꞌ lëbëꞌ ruꞌa yuꞌu ta isaloguëꞌ ta yeyuꞌu xaꞌnnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tahuen gula naca quie benꞌ rapa yuꞌu bëꞌ yedyin xaꞌnnëꞌ, ilëꞌënëꞌ zuëꞌ, rnëꞌë birasinëꞌ. Lëlenaꞌ nacan tali rniaꞌ leꞌe, cuin xaꞌnnëꞌ huabëchinëꞌ lëbëꞌ lao mesa, hueꞌnëꞌ laze ta gao benꞌ rapa yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Lëzi tahuen gula naca quie benꞌ rapa yuꞌu chi zuëꞌ rnëꞌë birasinëꞌ bëꞌ yedyin xaꞌnnëꞌ, baꞌalaꞌcazi du gatzo yela, baꞌalaꞌcazi du bala. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Uzënagale ca rniaꞌ leꞌe ni. Chi tu benꞌ xanꞌ yuꞌu ineziguëꞌ bi hora idyin benꞌ uban, naꞌra sunëꞌ inëꞌë bigasinëꞌ, bihuëꞌnëꞌ lato ta tzuꞌu benꞌ uban luꞌu yuꞌu ta cuannëꞌ ta de quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Naꞌ biz̃i leꞌe, ulesu listo cuezale yeguidaꞌ, como danꞌ caora bibi pensari racale yeguidaꞌ, lao durpendizi yeguidaꞌ lao yedyi layu nëꞌëdiꞌ, bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Naꞌra una Pedro rëbinëꞌ Jesús: ―¿Señor, unëloꞌ diꞌidzaꞌ ta nacan irupa iyunala para nëtoꞌzi o chi unëloꞌn lao duz̃etela? ");
INSERT INTO zpcNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Rniaꞌ diꞌidzaꞌ ta nacan irupa iyunala para nutezi benꞌ rioñeꞌe, para nutezi benꞌ ruzu diꞌidzaꞌ ca rna xaꞌnnëꞌ. Lëbenꞌ naꞌ hue xaꞌnnëꞌ ladyinaꞌanëꞌ ta inëꞌë benꞌ nitaꞌ z̃an yuꞌu quienëꞌ ta hueꞌnëꞌ ta gaoyaquëꞌ caora idyin hora gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tahuen gula gaca quie benꞌ zu rapa yuꞌu quie xaꞌnnëꞌ, chi bëꞌ yedyin xaꞌnnëꞌ ilëꞌënëꞌ rzuguëꞌ diꞌidzaꞌ con canꞌ gudyinëꞌ xaꞌnnëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tali ca rniaꞌ, benꞌ naca xanꞌ yuꞌu, hueꞌnëꞌ ladyinaꞌa yugulu ta de quienëꞌ lao naꞌa benꞌ udapa yuꞌu quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Biz̃i chanꞌ benꞌ zu rapa z̃an yuꞌu quie xaꞌnnëꞌ, chi racanëꞌ pensari huadzë xaꞌnnëꞌ biyedyinnezëꞌ, chi sulaonëꞌ tilalënëꞌ inëlënëꞌ yaca benꞌ rue dyin z̃an yuꞌu quie xaꞌnnëꞌ, chi sulaocalanëꞌ gaonëꞌ yoꞌonëꞌ xudyinëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","naꞌra bëꞌ yedyin xaꞌnnëꞌ dza birbezëꞌ yedyin xaꞌnnëꞌ, hualëꞌënëꞌ canꞌ ruenëꞌ, huenëꞌ lëbëꞌ tu castigo huala gula, iseꞌelëꞌ lëbëꞌta tzionëꞌ lado yaca los demás benꞌ bibzu diꞌidzaꞌ quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Nu benꞌ zu lao xaꞌnnëꞌ nezinëꞌ ca ta reꞌen xaꞌnnëꞌ huenëꞌ, denꞌ bibzunëꞌ diꞌidzaꞌ huenëꞌ ca guꞌun xaꞌnnëꞌ, huataꞌ castigo huala gula quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero nu benꞌ zu lao xaꞌnnëꞌ, pero binezinëꞌ ca ta reꞌen xaꞌnnëꞌ huenëꞌ, pues baꞌalaꞌcazi reyaꞌalaꞌ gataꞌ castigo quienëꞌ cabëꞌ bënëꞌ, pero danꞌ biunezinëꞌ canꞌ bënëꞌ, yubëꞌëzi castigo gataꞌ quienëꞌ. Nu benꞌ bëꞌ Diuzi taz̃e, lëlëbëꞌ yenaba Diuzi yeyuꞌenëꞌ taz̃era. Lëscanꞌ nu benꞌ pcaꞌn Diuzi tazë lao nëꞌë, lëlëbëꞌ yenaba Diuzi usedyinnëꞌ tazëra lao nëꞌë. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","―Nëꞌëdiꞌ bidaꞌ ta cuëchaꞌ ca quie guiꞌ lao yedyi layu. Lenaꞌ reꞌentzeguedaꞌ gaꞌalaꞌn naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Bazaꞌ dza gatiaꞌ lëꞌë yaga cruzo. Lega rutëbin nëꞌëdiꞌ rbezaꞌ bëꞌ yeyudyi gatiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Naꞌ rniaꞌ leꞌe, ¿raquele bidaꞌ lao yedyi layu ta bira gataꞌ zëdi huedila quiele? Rniaꞌ leꞌe, cala lenaꞌ bidaꞌ, dechanꞌ bidaꞌ ta iro chopa cueꞌ yaca benꞌ nitaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ga sulaon naꞌa, ga sulaon quie dza zazaꞌra. Huaca quie lao gaꞌyoꞌ benꞌ nitaꞌ z̃an yuꞌu, huaroyaquëꞌ chopa cueꞌ. Tzonayaquëꞌ huaca condre quie chopayaquëꞌ. Naꞌ ichopayaquëꞌ huaca condre quie tzonayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Huaca xuzi z̃naꞌ xcuidiꞌ condre quie z̃iꞌiyaquëꞌ. Naꞌ huaca z̃iꞌiyaquëꞌ condre quie xuzi z̃naꞌyacabiꞌ. Huaca z̃naꞌ beꞌmbyu condre quie z̃ualidyinëꞌ. Naꞌ huaca z̃ualidyinëꞌ condre quie benꞌ gula quiebiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Naꞌra una Jesús rëbinëꞌ yaca benꞌ nitaꞌ naꞌ: ―Cati rlëꞌële rasa beo ga reguin obidza, lenaꞌ inale huen nisayo, naꞌra huen cabëꞌ nale. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Lëzi cati rlëꞌële bazaꞌ be tzalaꞌ ga reguin obidza, lenaꞌ inale huen z̃la, naꞌra huen cabëꞌ nale. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Leꞌe benꞌ rlidza Diuzi de diꞌidzaꞌ ladzazi, banezile huele pensari canꞌ hue beo len canꞌ hue be, ¿naꞌ bixquienꞌ binezile huele pensari canꞌ raca quiele dza rdale lao yedyi layu? Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","―¿Bixquienꞌ biracale pensari ca naca tali ca reyaꞌalaꞌ huele? ");
INSERT INTO zpcNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chi zu tu benꞌ reyaꞌalaꞌle quie, naꞌ reꞌennëꞌ quiz̃ole quienëꞌ uquiëꞌnëꞌ leꞌe lao benꞌ napa dyin, ruen zi yegaꞌntzaꞌole laonëꞌ tu neza tu binedyinle lao benꞌ napa dyin. Chi baziolëlenëꞌ lao juez, hue juez mandado udzeꞌ policía leꞌe luꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Naꞌ rniaꞌ leꞌe, gabi yerole hasta que quiz̃ole yugulute ca ta reyaꞌalaꞌle. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lëhora naꞌ bdyin yaca benëꞌ rëbiyaquëꞌ Jesús canꞌ bë Pilato bëtinëꞌ chopa tzona benꞌ estado Galilea. Pquixinëꞌ ren quieyaquëꞌ len ren quie bia guixiꞌ ta bdyiayaquëꞌ lao becugo quie idaoꞌ rnabëꞌra zu ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Ca biz̃i pensari racale cabëꞌ guca quie yaca benꞌ Galilea? ¿Raquele nacarayaquëꞌ benꞌ bëra tamala quie, cala ca yaca benꞌ lao yedyi quiele? ");
INSERT INTO zpcNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Naꞌra rniaꞌ leꞌe, binacan canꞌ. Naꞌ leꞌe, chi biyetzaꞌle pensari quiele inaole xneza Diuzi, biyeziꞌ Diuzi leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Ca biz̃i pensari racale cabëꞌ guca quie yaca chiꞌinuꞌbetzona yaca benꞌ guti bdacoꞌ torre Siloé leyaquëꞌ? ¿Raquele nacarayaquëꞌ benꞌ de dulaꞌ xquia quie, cala ca yaca los demás benꞌ nitaꞌ lao ciudad Jerusalén? ");
INSERT INTO zpcNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Lenaꞌ rniaꞌ leꞌe, binacan canꞌ. Naꞌ leꞌe chi biyetzaꞌle pensari quiele inaole xneza Diuzi, biyeziꞌ Diuzi leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Naꞌra una Jesús tu ejemplo ni: ―Uzu tu beꞌmbyu zu tu yaga higo quienëꞌ lao layela quienëꞌ. Naꞌra uzëꞌë zioguëꞌ tzenaꞌnëꞌn chi badyian higo, naꞌ blëꞌënëꞌ ni tu higo bidyia lao yaga. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Naꞌra una benꞌ zu yaga higo quie, rëbinëꞌ benꞌ rapa layela quiëꞌ: “Unaꞌcara, azio tzona iza ridaꞌ denaꞌa yaga higo ni chi dyian taz̃ixi, pero ni tu higo binelëꞌëdaꞌ cuialaonan. Mejorla ichuguloꞌn, ¿bixquienꞌ ruꞌeron lato zun layu niga, chi birbian higo?” ");
INSERT INTO zpcNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Naꞌra una benꞌ rapa layela rëbinëꞌ xaꞌnnëꞌ: “Señor, psan quien, biichuguron zazugaran itu iza naꞌa. Ta huaꞌ cuëchaꞌ tu pozo z̃annan tacuenda udyiaꞌn bena. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Con ca huaꞌ quien, a ver chi bicuian taz̃ixi. Pero chi bicuian taz̃ixi, naꞌtera ichuguron.” ");
INSERT INTO zpcNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Uzu tu dza saodo, dza huezilaꞌadyiꞌ quieyaquëꞌ, uyuꞌu Jesús luꞌu idaoꞌ sinagoga ga rsëdinëꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lëganꞌ naꞌ zë tu nigula raca z̃hueꞌnëꞌ. Azio chiꞌinuꞌbetzona iza uyuꞌunëꞌ tu bichi be xiꞌibiꞌ, naꞌ becaꞌnnan lëbëꞌ bego, bira guca yelinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Biz̃i cati blëꞌë Jesús lëbëꞌ, naꞌ guz̃inëꞌ lëbëꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Nigula, hueyuaꞌ luëꞌ ca naca yelaꞌ hueꞌ yuꞌuloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Naꞌra bdaꞌ naꞌanëꞌ xcuꞌudzu nigula. Caora bdaꞌnëꞌ nëꞌë nigula, labelitenëꞌ. Naꞌ uzulaonëꞌ ruenëꞌ Diuzi benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero lega bdzaꞌ benꞌ napa dyin luꞌu idaoꞌ sinagoga, danꞌ beyue Jesús benꞌ xcuꞌudzu bego dza huezilaꞌadyiꞌ. Naꞌra unë benꞌ napa dyin luꞌu idaoꞌ sinagoga rëbinëꞌ yaca benëꞌ: ―Xopa dza nacan ta huero dyin. Lëdza naꞌ reyaꞌalaꞌ guida benꞌ raca z̃hueꞌ ta iyacayaquëꞌ, cala naꞌadza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Luëꞌ benꞌ rlidza Diuzi de diꞌidzaꞌ ladzazi, ¿cala rxëdyoꞌ huaga quioꞌ o burro quioꞌ ta tzehuaꞌaloꞌbaꞌ yoꞌobaꞌ nisa dza huezilaꞌadyiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Naꞌ nigula niga naquëꞌ z̃iꞌi suba Abraham. Naꞌ biz̃i xanꞌ taxiꞌibiꞌ Satanás nuquion lëbëꞌ nuen bego xcuꞌudzunëꞌ azio chiꞌinuꞌbetzona iza. Naꞌ biz̃i luëꞌ, ¿bixquienꞌ naoꞌ bireyaꞌalaꞌ yexëdyaꞌ tanuquio xanꞌ taxiꞌibiꞌ nigula ni dza huezilaꞌadyiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Biz̃i caora una Jesús canꞌ, bedueꞌtzegue yaca benꞌ rue condre lëbëꞌ. Pero yaca los demás benëꞌ, lega redaohueyaquëꞌ blëꞌëyaquëꞌ ca yelaꞌ huaca babë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Naꞌra una Jesús rëbinëꞌ yaca benëꞌ: ―¿Ca biz̃i huaꞌ ta yexiꞌidzaꞌ leꞌe ca naca ga rnabëꞌ Diuzi? ¿Ca bi diꞌidzaꞌ reꞌennan iniaꞌ leꞌe ta inezile dyëꞌëdi? ");
INSERT INTO zpcNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nacan ca quie tu bini mostaza ta guza tu benëꞌ lao layu quiëꞌ. Naꞌ biz̃i bini mostaza, laꞌacazi tu bini daoꞌ bicuꞌ, pero guꞌunin gucan tu yaga z̃e gula. Naꞌ bdyin yaca bia xila bëyacabaꞌ lidyibaꞌ lao tacaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Lëscanꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Ca bi diꞌidzaꞌ reꞌennan iniaꞌ leꞌe ta inezile dyëꞌëdi ca naca ga arnabëꞌ Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nacan ca quie tu levadura ta rziꞌ nigula rlaꞌadyiꞌnëꞌn con tzona medida yezo. Conlë lenaꞌ rëz̃in duz̃e cuba racan taz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Naꞌra uzaꞌ Jesús uyuꞌunëꞌ neza tatula zionëꞌ ciudad Jerusalén. Naꞌ ga rdyinnëꞌ tu tu yedyi neza ciudad Jerusalén uzulaonëꞌ rguixogueꞌnëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Naꞌra unaba tu benëꞌ lëbëꞌ rëbinëꞌ lëbëꞌ: ―Señor, ¿hueziꞌ Diuzi benꞌ zë yeyoyaquëꞌ guibá o chi tu chopaziyaquëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Naca gui ruꞌa yuꞌu guibá. Dulaꞌadyiꞌle ulehue quiele tacuenda saqueꞌ tzuꞌule lëruꞌa yuꞌu naca gui. Rniaꞌ leꞌe, benꞌ zë gula initaꞌ gueꞌenyaquëꞌ tzuꞌuyaquëꞌ, pero bisaqueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Caora bapsio benꞌ xanꞌ yuꞌu naꞌ, biz̃i leꞌe initaꞌle laliꞌa, naꞌ ibigaꞌle ruꞌa yuꞌu, uxidyile ruꞌa yuꞌu, naꞌ inale: “Señor, isaloloꞌ ruꞌa yuꞌu niga.” Naꞌ biz̃i benꞌ xanꞌ yuꞌu inënëꞌ luꞌu yuꞌute yëbinëꞌ leꞌe: “Binubëꞌdaꞌ nu leꞌe.” ");
INSERT INTO zpcNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Naꞌra leꞌe inale yëbile benꞌ xanꞌ yuꞌu: “Aodaolëndoꞌ luëꞌ, bahueꞌelëndoꞌ luëꞌ tuzi. Lëzi psëdioꞌ yaca benëꞌ yedyi quiendoꞌ xtiꞌidzaꞌ Diuzi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Naꞌra inë benꞌ xanꞌ yuꞌu yëbinëꞌ leꞌe: “Baoniaꞌ leꞌe, binubëꞌdaꞌ leꞌe. Uleyo bira huele nëꞌëdiꞌ zëdi, leꞌe benꞌ mala.” ");
INSERT INTO zpcNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Quie lenaꞌ cuedyile ziꞌlaza gula gao leile caora ilëꞌële Abraham, len Isaac, len Jacob, len yaca los demás benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi dza naꞌla anitaꞌyaquëꞌ guibá, naꞌ biz̃i leꞌe, naca bayëchiꞌ quiele initaꞌle laliꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Rniaꞌ leꞌe, huida yaca benꞌ uzaꞌ lao duz̃e yedyi layu yeguꞌudiꞌyaquëꞌ guibá ta cueꞌyaquëꞌ lao mesa quie Diuzi ta gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bala benꞌ nitaꞌ lao yedyi layu niga, binacajëꞌ benꞌ z̃e, pero huacajëꞌ benꞌ z̃e dza yedyinjëꞌ ga zu Diuzi. Lëscanꞌ bala benꞌ naca benꞌ z̃e lao yedyi layu niga, bira nacajëꞌ benꞌ z̃e dza yedyinjëꞌ ga zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lëdza naꞌ bdyin yaca benꞌ partido fariseo gudyiyaquëꞌ Jesús: ―Uzaꞌ uyo ga tula, danꞌ reꞌen rey Herodes gutinëꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Uleyo uletzeguëdyi lëbenꞌ mañoso ca rniaꞌ leꞌe, niaꞌ: “Itu chopa tzona dza suaꞌ yebiogaꞌ bichi be xiꞌibiꞌ yuꞌu yaca benëꞌ, yeyueriaꞌ yaca benꞌ raca z̃hueꞌ. Naꞌ baruen bago dza iyudyi huaꞌ dyin quiaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero decazide huaꞌ dyin cabëꞌ dyin nagun Diuzi huaꞌ. Nerdziogue itu chopa tzona dza ga idyintiaꞌ ciudad Jerusalén como danꞌ lëciudad naꞌ nacan ciudad ga rutiyaquëꞌ benꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Leꞌe benꞌ ciudad Jerusalén, rutile yaca benꞌ zaꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi. Lëzi leꞌe benꞌ ciudad Jerusalén, rguile yo yaca benꞌ useꞌelaꞌ Diuzi laole. Zë lasa guꞌundaꞌ gapaꞌ leꞌe cabëꞌ rue nu biu benaꞌ, rapabaꞌ z̃iꞌibaꞌ, rguëdyibaꞌ z̃iꞌibaꞌ z̃an xilabaꞌ. Pero naꞌ leꞌe, biguꞌunle. ");
INSERT INTO zpcNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lenaꞌ apsanlaꞌadyiꞌ Diuzi leꞌe. Naꞌra rniaꞌ leꞌe, ibaba dza bira ilëꞌële nëꞌëdiꞌ. Hasta quie idyin dza yëbile nëꞌëdiꞌ: “Benꞌ naca laꞌiya luëꞌ, benꞌ useꞌelaꞌ Diuzi, naꞌtera ilëꞌële nëꞌëdiꞌ tatula.” ");
INSERT INTO zpcNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Biz̃i bezu dza tula, dza huezilaꞌadyiꞌ. Caora naꞌ zio Jesús ta gaohuëꞌ z̃an yuꞌu quie benꞌ napa dyin, benꞌ naca partido fariseo. Naꞌra rbëꞌnao yaca benꞌ laguedyinëꞌ chi bi hue Jesús dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Naꞌ lëganꞌ naꞌ zë tu benꞌ yuꞌu yelaꞌ hueꞌ gui. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Naꞌra una Jesús rëbinëꞌ yaca benꞌ rusëdi ley quie Moisés, len yaca benꞌ naca partido fariseo: ―¿Biz̃i na lao ley? ¿Ruꞌen lato yeyuaꞌ benꞌ raca z̃hueꞌ dza huezilaꞌadyiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Caora naꞌ begaꞌnyaquëꞌ chizi, bira unëyaquëꞌ. Naꞌra bëxunëꞌ naꞌa benꞌ yuꞌu gui, beyuenëꞌ lëbëꞌ. Ude naꞌ una Jesús gudyinëꞌ benꞌ beyuenëꞌ: “Aoca, beyo.” ");
INSERT INTO zpcNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Naꞌ una Jesús gudyinëꞌ benꞌ partido fariseo: ―Chi nu leꞌe rguino burro o huaga quiele luꞌu barranca, baꞌalaꞌcazi nacan dza huezilaꞌadyiꞌ, ¿quele huayole tzaliolebaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Naꞌra bira ubinyaquëꞌ bi yëbiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bëꞌ blëꞌë Jesús ca rue yaca benꞌ bdyin ga zëꞌë, blëꞌënëꞌ rsereyaquëꞌ ga cueꞌyaquëꞌ reꞌenyaquëꞌ cueꞌyaquëꞌ ga cueꞌ benꞌ balaꞌanara. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ tu diꞌidzaꞌ: ―Cati ziole ga raca huetzaganaꞌ, bicueꞌle ga rbeꞌ benꞌ balaꞌanara. Biz̃i chanꞌ zazaꞌra benꞌ nacara belao cueꞌnëꞌ ganꞌ reꞌloꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Biz̃i bareꞌloꞌ ga rbeꞌ benꞌ balaꞌanara, naꞌ inë benꞌ rue lani yëbinëꞌ luëꞌ: “Uzuli, bëꞌ lato cueꞌ benꞌ niga ganꞌ bareꞌloꞌ.” Cati inanëꞌ luëꞌ canaꞌ, canaꞌ yedueꞌloꞌ yeyoloꞌ tzareꞌloꞌ xcuꞌudzula. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Naꞌ ca ta reyaꞌalaꞌ huele cati tziole lani, cueꞌle xcuꞌudzutela. Naꞌra cati ilëꞌë benꞌ rue lani reꞌloꞌ xcuꞌudzutela, naꞌra inëꞌ luëꞌ: “Amigo, ude nila cueꞌloꞌ ga rbeꞌ benꞌ balaꞌanara.” Canaꞌ gaca balaꞌana quiele len yaca benꞌ bareꞌ lao mesa. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Naꞌ rniaꞌ leꞌe, nu benꞌ rue z̃e cuine, huadyin dza hue Diuzi lëbëꞌ benꞌ yubeꞌezi. Naꞌ biz̃i nu benꞌ rue yubeꞌezi cuine, huadyin dza hue Diuzi lëbëꞌ benꞌ z̃e. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Lëzi unërë Jesús rëbinëꞌ benꞌ rue lani: ―Cati hueloꞌ lani biguëz̃oꞌ benꞌ naca amigo quioꞌ, ni biꞌ bichoꞌ, ni xuzi z̃naoꞌ, nica benꞌ uñaꞌa, como danꞌ huadyin dza yeyueyaquëꞌ laohue quioꞌ, gunrëyaquëꞌ ta gaoloꞌ. Conlë lëzin yeyuen laohue quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Naꞌ ca ta reyaꞌalaꞌ hueloꞌ cati hueloꞌ lani, reyaꞌalaꞌ guëz̃oꞌ yaca benꞌ yëchiꞌ, len yaca benꞌ ca guicho ca lao, len yaca benꞌ z̃i, len yaca benꞌ laochula. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Chi hueloꞌ canaꞌ, canaꞌ gataꞌ tahuen gulara quioꞌ yedaohueloꞌ bëꞌ idyin dza useban Diuzi benꞌ bë quie xtiꞌidzaꞌnëꞌ. Huataꞌ tadyaꞌa quioꞌ lao Diuzi danꞌ bëꞌloꞌ ta udao yaca benꞌ raca bayëchiꞌ quie, baꞌalaꞌcazi bide dumi ta quiz̃oyaquëꞌn ni ta yeyueyaquëꞌ laohue quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Biz̃i bëꞌ be tu benꞌ reꞌ lao mesa cabëꞌ una Jesús, naꞌra unëꞌ: ―Lega gaca huen quie benꞌ gao yelaꞌ huao ga zu Diuzi rnabëꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Uzu tu beꞌmbyu dza naꞌ, bëꞌnëꞌ laze ta gao yaca benꞌ zë, benꞌ guëz̃inëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bëꞌ beyudyi bapcuezëꞌ ta gao yaca benëꞌ guëz̃inëꞌ, naꞌ useꞌelaꞌnëꞌ criado quienëꞌ unëꞌ rëbinëꞌ lëbëꞌ: “Uyo, yexiꞌ yaca benꞌ guida gao yaca. Banaca laze ta gaoyaquëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Biz̃i yaca benꞌ rëz̃inëꞌ ta gao, unabayaquëꞌ ta yeziꞌz̃enëꞌ quieyaquëꞌ. Naꞌra benꞌ nëro unëꞌ gudyinëꞌ criado quie benꞌ naꞌ: “Zabeyudyi huaꞌa tu layu. Len reꞌendaꞌ tzenaꞌa. Ta nacanꞌ niaꞌ luëꞌ yëboꞌnëꞌ yeziꞌz̃enëꞌ quiaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Naꞌ unë benꞌ urupe rëbinëꞌ benꞌ zio tzexiꞌ lëbëꞌ: “Baoz̃iaꞌ gaꞌyoꞌ pare bëdyihuaga. Lëbaꞌ tzaꞌliaꞌ huaꞌbaꞌ prueba. Lenaꞌ niaꞌ bisaqueꞌ saꞌa, yeziꞌz̃enëꞌ quiaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Naꞌ una benꞌ uyune rëbinëꞌ benꞌ zio tzexiꞌ lëbëꞌ: “Zabeyudyi ptzaganaꞌa. Yelaꞌ naꞌ bisaqueꞌ saꞌa.” ");
INSERT INTO zpcNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Biz̃i bëꞌ bedyin criado, naꞌ udixogueꞌnëꞌ xaꞌnnëꞌ cabëꞌ gudyi yaca benëꞌ lëbëꞌ. Naꞌra bdzaꞌtzegue xaꞌnnëꞌ unëꞌ rëbinëꞌ criado quiëꞌ: “Uyo yenaꞌ laꞌo yedyi, yexiꞌ yaca benꞌ yëchiꞌ, len yaca benꞌ ca guicho ca lao, len yaca benꞌ z̃i, len yaca benꞌ laochula.” ");
INSERT INTO zpcNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Naꞌra bedyin criado quie benꞌ naꞌ unëꞌ rëbinëꞌ lëbëꞌ: “Señor, babiaꞌ ca mandado baoꞌ. Pero nerunnan lato guidara benëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Naꞌra una xaꞌnnëꞌ tatula rëbinëꞌ lëbëꞌ: “Uyo yenaꞌ laꞌo yedyi du tu neza. Bë bala iquiëꞌloꞌyaquëꞌ cuenda yedzaꞌ yaca benëꞌ luꞌu yuꞌu quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yelaꞌ naꞌ rniaꞌ, ni tu yaca benꞌ baguz̃aꞌ tanëro, benꞌ bibida gao quiaꞌ, bira de lato gaoyaquëꞌ ta pcuezaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Benꞌ zë gula zenaoyaquëꞌ Jesús. Naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Chi nu benꞌ reꞌen inao nëꞌëdiꞌ, ruen zi idyëꞌëranëꞌ nëꞌëdiꞌ cala ca xuzëꞌ, ca z̃nëꞌë, ca z̃gulanëꞌ, ca z̃iꞌinëꞌ, ca biꞌ bichinëꞌ, ca biꞌ zannëꞌ, cala ca yelaꞌ neban quienëꞌ. Chi binedyëꞌëranëꞌ nëꞌëdiꞌ cala ca familia quienëꞌ, ca yelaꞌ neban quienëꞌ, bisaqueꞌ gacanëꞌ benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nu benꞌ rdzebi inao xnezaꞌ nun quie ruen z̃udyi guti benëꞌ lëbëꞌ, bisaqueꞌ gacanëꞌ benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Chi leꞌe reꞌenle huele tu yuꞌu ¿cala reyaꞌalaꞌ huele pensari usaqueꞌle chi huaque dumi quiele ta useyudyile yuꞌu? ");
INSERT INTO zpcNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Chi tu benꞌ uzulaohue rcuaꞌnëꞌ luꞌu yu barbëchinëꞌ xniꞌa besu, naꞌ biz̃i chi biguque dumi quienëꞌ ta useyudyinëꞌ yuꞌu, naꞌ yaca benꞌ ilëꞌë, utituyaquëꞌ uz̃idyiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Naꞌ inayaquëꞌ quienëꞌ: “Benꞌ niga aozulaonëꞌ ruenëꞌ yuꞌu quienëꞌ, naꞌ biguque dumi quienëꞌ ta useyudyinëꞌn.” ");
INSERT INTO zpcNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Chi zu tu rey, naꞌ zu itu rey reꞌennëꞌ tilalënëꞌ lëbëꞌ. Naꞌ napëꞌ chi mila soldado. Naꞌ biz̃i itu rey napëꞌ galo mila soldado quienëꞌ. Caora cati bazaꞌ tilarëyaquëꞌ, ¿cala reyaꞌalaꞌ huenëꞌ pensari chi huaque chi mila soldado quienëꞌ ta tilalënëꞌ benꞌ napa galo mila soldado? ");
INSERT INTO zpcNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chi bapsaquenëꞌ bisuenëꞌ tilalënëꞌ itu rey, naꞌra tu nezu itu rey zituꞌ, reyaꞌalaꞌ iseꞌelaꞌnëꞌ tu benꞌ tzio lao lazëꞌ ta tzeguedyinëꞌ itu rey ta yegaꞌntzaꞌoyaquëꞌ bitilayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Lenaꞌ uniaꞌ leꞌe ta inezile nutiꞌtezile reꞌenle inaole nëꞌëdiꞌ, chi bisule puesto ta usanle yugulu ta de quiele inaole nëꞌëdiꞌ, bisaqueꞌ gacale benꞌ quiaꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","―De ga hue zediꞌdyin chi nacan snaꞌa. Pero chi bira nacan snaꞌa, ¿ca biz̃i huero ta iyacan snaꞌa? ");
INSERT INTO zpcNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Bibi dyin huena, ni para quie layu, ni para bena. Nacan ta chuꞌunro. Nule babe, ulezënaga cabëꞌ baoniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Biz̃i yaca benꞌ zë, benꞌ huequiz̃u len yaca benꞌ nao neza mala, beguꞌudiꞌyaquëꞌ zë lasa ganꞌ zë Jesús ta uzënagayaquëꞌ cabëꞌ unëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Naꞌ biz̃i yaca benꞌ partido fariseo, len yaca benꞌ rusëdi ley quie Moisés, rtzaloyaquëꞌ canꞌ rue Jesús, unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Benꞌ niga reziꞌnëꞌ yaca benꞌ nao neza mala, raolënëꞌ leyaquëꞌ tzaz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Naꞌ tu diꞌidzaꞌ ni una Jesús rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Chi zu tu gayuhua becoꞌ z̃iꞌilaꞌ quiele, naꞌ aoniti tubaꞌ, ¿cala ucaꞌnle yaca bia biuniti ga nitaꞌyacabaꞌ dyaꞌa? ¿Cala huayole tzedilole itu bia neniti hasta que yedzelelebaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bëꞌ yedzelelebaꞌ ¿cala lega yedaohuele hueziꞌlebaꞌ yequiëꞌlebaꞌ z̃an yuꞌu? ");
INSERT INTO zpcNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Naꞌ bëꞌ bedyinle z̃an yuꞌu quiele ¿cala guëz̃ile yaca benꞌ naca amigo quiele? ¿Cala yëbileyaquëꞌ: “Huero lani, danꞌ babedzeledaꞌ becoꞌ z̃iꞌilaꞌ quiaꞌ, bia uniti”? ");
INSERT INTO zpcNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Lenaꞌ rniaꞌ leꞌe, cabëꞌ guca quie xanꞌ becoꞌ z̃iꞌilaꞌ, canaꞌ nacarë quie Diuzi. Yedaohueranëꞌ quie tu benꞌ betzaꞌ pensari quie, benꞌ unao neza mala, naꞌ inaonëꞌ xneza Diuzi, cala ca yaca benꞌ zë, yaca benꞌ ziocazi nao xnezëꞌ. Naꞌ itu diꞌidzaꞌ ni una Jesús rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","―Lëzi rniaꞌ leꞌe, chi zu tu nigula de chi dumi plata quiëꞌ, naꞌ bëxo tun, ¿cala ugaꞌalaꞌnëꞌ lámpara quiëꞌ, ulubanëꞌ luꞌu yuꞌu quienëꞌ dyëꞌëdi, yeguilonëꞌn hasta que yedzelenëꞌn? ");
INSERT INTO zpcNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Naꞌ biz̃i bëꞌ bedzelenëꞌn, lega bedaohuenëꞌ. Naꞌ guëz̃inëꞌyaca amiga quienëꞌ inëꞌ yëbinëꞌ leyaquëꞌ: “Huero tu lani, danꞌ babedzeledaꞌ dumi quiaꞌ ta uniti.” ");
INSERT INTO zpcNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Lëzi rniaꞌ leꞌe, canꞌ guca bedaohue nigula, canaꞌ yedaohuerë yaca ángel quie Diuzi cati yetzaꞌ pensari quie tu benꞌ unao neza mala, naꞌ inaonëꞌ xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Lëscanꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Uzu tu beꞌmbyu uzu chopa z̃iꞌinëꞌ byu. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Naꞌ biz̃i z̃iꞌinëꞌ byu, biꞌ nëchiꞌla, unabiꞌ rëbibiꞌ xuzibiꞌ: “Xuzaꞌ, ¿bigunloꞌ nëꞌëdiꞌ ta reduꞌuledaꞌ siꞌa? Naꞌra xuzibiꞌ bëꞌnëꞌ laze, bëꞌnëꞌbiꞌ ta reduꞌulebiꞌ siꞌbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Biz̃i guca tu chopa tzona dza, ptupa z̃iꞌinëꞌ nëchiꞌ ta de quiebiꞌ biꞌabiꞌ yuguluten. Naꞌ uzaꞌbiꞌ ziobiꞌ yedyi reꞌ zituꞌ ga beditobiꞌ dumi quiebiꞌ uyuꞌubiꞌ pensari mala ca bëbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pero bëꞌ beditobiꞌ yugulu ta de quiebiꞌ, naꞌ bdyin dza guca tu ubin huala gula yedyi naꞌ. Bira gutaꞌ ta gaobiꞌ, naꞌ lega uduebiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Naꞌra uzaꞌbiꞌ ziobiꞌ tzetilobiꞌ bi dyin huebiꞌ lao tu benꞌ zu lao yedyi ganꞌ bdyimbiꞌ. Naꞌ biz̃i benꞌ naꞌ useꞌelaꞌnëꞌbiꞌ ga de layu quienëꞌ ta gapabiꞌ cuchi quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tanto uduebiꞌ guꞌumbiꞌ gaobiꞌ ca ta bëꞌyaquëꞌ yaca cuchi ta gaobaꞌ. Pero naꞌ lëbiꞌ nunu bëꞌ ta gaobiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Naꞌra gucabiꞌ pensari: “¡Nacala benꞌ zë rueyaquëꞌ dyin z̃an yuꞌu quie xuzaꞌ, birdziogueyaquëꞌ ta gaoyaquëꞌ! ¡Naꞌ niga nëꞌëdiꞌ rudaꞌa huatiaꞌ yelaꞌ rdue quiaꞌ! ");
INSERT INTO zpcNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yezaꞌcalaꞌ yeyaꞌa z̃an yuꞌu quie xuzaꞌ ta yëpaꞌnëꞌ: Xuzaꞌ, uz̃iꞌz̃e quiaꞌ. Baoquixaꞌ lao Diuzi. Baoquixaꞌ laoloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Bira bizacaꞌ inaoꞌ nëꞌëdiꞌ nacaꞌ z̃iꞌiloꞌ. Bë nëꞌëdiꞌ cuenda ca nu benꞌ rue dyin quioꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Naꞌra bezaꞌbiꞌ beyuꞌubiꞌ neza zeyobiꞌ z̃an yuꞌu quie xuzibiꞌ. ’Nezezaꞌbiꞌ tu neza zituꞌ caora blëꞌë xuzibiꞌ bazezaꞌbiꞌ. Naꞌ beyëchiꞌlaꞌadyiꞌnëꞌ lëbiꞌ zionëꞌ udëdyinëꞌbiꞌ udaonëꞌbiꞌ situ xagabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Naꞌ biz̃i una biꞌbyu naꞌ rëbibiꞌ xuzibiꞌ: “Xuzaꞌ, uz̃iꞌz̃e quiaꞌ. Baoquixaꞌ lao Diuzi. Baoquixaꞌ laoloꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Naꞌ biz̃i una xuzibiꞌ rëbinëꞌ yaca biꞌ criado quiëꞌ: “Uletzio cuiole tu cueꞌ laꞌariꞌ dyaꞌara ta ugacolebiꞌ. Lëzi uletzexiꞌ tu anillo ta udzeꞌle z̃bebiꞌ len itu cueꞌ guidi ta udzeꞌle niꞌabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Lëzi uletzio tzexiꞌle tu bëdyihuaga, bia nacara nuꞌunu, bia gutiro gaoro ta huero lani. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Canaꞌ huero como danꞌ z̃iꞌinaꞌ niga anaca quiebiꞌ ca quie tu benꞌ baguti beban. Aonitibiꞌ, pero naꞌ babelaꞌbiꞌ bazulëbiꞌ raꞌo niga.” Naꞌ uzulaoyaquëꞌ rueyaquëꞌ lani. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Naꞌ biz̃i z̃iꞌinëꞌ biꞌ huaca, negaꞌmbiꞌ layela. Bëꞌ bezaꞌbiꞌ layela bedyimbiꞌ bago ganꞌ zu yuꞌu, bebiꞌ rgüedyi raca hueyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Naꞌra guz̃ibiꞌ tu criado quie xuzibiꞌ unababiꞌ lëbiꞌ bi guca z̃an yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Naꞌ una biꞌ criado rëbibiꞌ lëbiꞌ: “Babelaꞌ biꞌ bichoꞌ. Naꞌ bë xuzoꞌ mandado babëtiyaquëꞌ tu bëdyihuaga nuꞌunu, danꞌ babelaꞌ biꞌ bichoꞌ dyaꞌa, bibi guca quiebiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Naꞌ biz̃i biꞌ bichibiꞌ huaca, lega rdzaꞌbiꞌ bireꞌembiꞌ yeyuꞌubiꞌ luꞌu yuꞌu. Lenaꞌ bro xuzibiꞌ unabanëꞌ cule laobiꞌ ta yeyuꞌubiꞌ luꞌu yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Naꞌra una biꞌ bichibiꞌ huaca rëbibiꞌ xuzibiꞌ: “Luëꞌ nezoꞌ dyëꞌëdi gula azio zë iza zuaꞌ ruaꞌ dyin quioꞌ. Bireguitzogaꞌ diꞌidzaꞌ quioꞌ. Ni tu lasa bibenloꞌ nëꞌëdiꞌ ni tu chivo ta gutiaꞌ huaꞌ lani gaoliaꞌ yaca biꞌ amigo quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Naꞌ z̃iꞌiloꞌ niga, babelaꞌbiꞌ tatula. Baoyobiꞌ beditobiꞌ dumi babëꞌloꞌbiꞌ conlë yaca nigula mala. Naꞌ luëꞌ babetioꞌ bëdyihuaga nuꞌunu ta gaole huele lani.” ");
INSERT INTO zpcNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Naꞌra una xuzibiꞌ rëbinëꞌbiꞌ: “Z̃iꞌinaꞌ, zucazoꞌ ni len nëꞌëdiꞌ yugu dza. Tanaꞌ lenaꞌ yugulu ta de quiaꞌ nacacazin quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero nacacazin huen huero lani yedaohuero, danꞌ babelaꞌ biꞌ bichoꞌ. Naca quiebiꞌ ca quie benꞌ baguti beban. Aonitibiꞌ belaꞌbiꞌ bazulëbiꞌ raꞌo tatula.” ―Canaꞌ una Jesús gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Lëzi cani una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ―Uzu tu benꞌ uñaꞌa zu tu benꞌ nuꞌenëꞌ ladyinaꞌanëꞌ ta de quienëꞌ. Naꞌ biz̃i una yaca benëꞌ unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: “Benꞌ nuꞌeloꞌ ladyinëꞌë ta de quioꞌ, lega rueditoguëꞌ ta de quioꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Naꞌra benꞌ naca xaꞌnnëꞌ guz̃inëꞌ lëbëꞌ yëbinëꞌ lëbëꞌ: “¿Biz̃i bëloꞌ conlë ta de quiaꞌ de que na yaca benëꞌ rueditoloꞌ ta de quiaꞌ? Besio cuenda quie dyin babaoꞌ, danꞌ bira reꞌendaꞌ gaca ladyinaoꞌ ta de quiaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Naꞌ biz̃i benꞌ naca ladyinëꞌë ta de quie xaꞌne, naꞌ guquëꞌ pensari: “¿Ca biz̃i huaꞌ chi yeguba xaꞌnaꞌ xchinaꞌ? Biracaꞌ huaꞌ dyin guixiꞌ. Lëzi redueꞌdaꞌ taꞌa tu tu yuꞌu inabaꞌ ta gaohuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Naꞌa banezdaꞌ ca huaꞌ cuenda initaꞌ benꞌ gacalë nëꞌëdiꞌ cati babeguba xaꞌnaꞌ xchinaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Naꞌra guz̃inëꞌ tu huio yaca benꞌ reyaꞌalaꞌ quie xaꞌnnëꞌ. Naꞌra unabëꞌ benꞌ nëro rëbinëꞌ lëbëꞌ: “¿Gaca tu reyaꞌaloꞌ quie benꞌ xaꞌnaꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Naꞌra bequëbinëꞌ unëꞌ: “Reyaꞌalaꞌ tu gayuhua frasco aceite.” Naꞌ una benꞌ naca ladyinëꞌë rëbinëꞌ lëbëꞌ: “Ni ziaꞌ guichi nexuboꞌ lao xaꞌnaꞌ. Caga naꞌa ureꞌ bë itu guichi de gatzo gayuhuazi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Biz̃i naꞌ unëꞌ rëbinëꞌ benꞌ urupe: “Naꞌ luëꞌ, ¿gacaz̃i reyaꞌaloꞌ quie xaꞌnaꞌ?” Naꞌra una benꞌ naꞌ: “Reyaꞌalaꞌ tu gayuhua bolsa bini trigo.” Naꞌra unëꞌ rëbinëꞌ lëbëꞌ: “Ni ziaꞌ guichi nexuboꞌ lao xaꞌnaꞌ. Caga naꞌa bë itu guichi de tapa galozi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Naꞌ biz̃i xanꞌ benꞌ naꞌ, bezaquenëꞌ ca bë benꞌ bëꞌnëꞌ ladyinëꞌë, naquëꞌ listo ta siꞌnëꞌ benëꞌ yëꞌ. Naꞌ una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ―Lëcanaꞌ nacan quie yaca benꞌ rda birnao xneza Diuzi, lega rzebilaꞌadyiꞌyaquëꞌ nacayaquëꞌ listo ta siꞌyaquëꞌ benëꞌ yëꞌ, cala ca yaca benꞌ rda rnao xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’¿Cabiz̃i reꞌenle iniaꞌ leꞌe quie benꞌ guca ladyinëꞌë? ¿Reꞌenle iniaꞌ leꞌe huele ca lëbëꞌ siꞌle benꞌ yëꞌ cuenda gataꞌ dumi quiele hueꞌlen yaca benꞌ reꞌenle gaca amigo quiele? ¿Reꞌenle iniaꞌ leꞌe canaꞌ huele tacuenda gacalë amigo quiele leꞌe ta yeziꞌ Diuzi leꞌe sulëlenëꞌ tuzioli? ");
INSERT INTO zpcNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Bigaca iniaꞌ leꞌe canꞌ, como danꞌ chi nu benꞌ rapa dyëꞌëdi tadaoꞌ lëꞌëtiꞌ nuꞌe xaꞌnnëꞌ lëbëꞌ, lenaꞌ uluꞌena quienëꞌ gaparëꞌ dyëꞌëdi tazëra hueꞌ xaꞌnnëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Lëzi chi leꞌe ziole rueditole con ganzi ta de quiele lao yedyi layu niga, ¿cómo naꞌa gueꞌenrële gun Diuzi leꞌe ta de quienëꞌ guibá? ");
INSERT INTO zpcNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","’Chi leꞌe biziole gapale dyëꞌëdi ta de quie benꞌ tula, ¿bixquienꞌ raquele gun Diuzi ta gataꞌ quiecazile? ");
INSERT INTO zpcNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nu benꞌ rue dyin lao xaꞌne, bisaqueꞌ uzunëꞌ chopa xaꞌnnëꞌ. Huataꞌ zëdi quiëꞌ quie lao rupa yaca benꞌ xaꞌnnëꞌ. Tuëꞌ huatzaxenëꞌ, naꞌ ituëꞌ bitzaxenëꞌ. Tuëꞌ biuzunëꞌ diꞌidzaꞌ quiëꞌ, naꞌ ituëꞌ uzunëꞌ diꞌidzaꞌ quiëꞌ. Chi rzaꞌlaꞌadyiꞌle dumi, bisaqueꞌ huele dyin quie Diuzi. ―Canaꞌ una Jesús gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Biz̃i yaca benꞌ naca partido fariseo, unitaꞌyaquëꞌ rzënagayaquëꞌ canꞌ una Jesús quie dumi. Danꞌ lega rexeyaquëꞌ gataꞌ dumi quieyaquëꞌ, tanaꞌ lenaꞌ uzulaoyaquëꞌ rtituyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Leꞌe, lega reꞌenle ilëꞌë yaca benëꞌ leꞌe benꞌ huen. Pero nezi Diuzi ca naca pensari mala yuꞌu luꞌu guicho laxtaꞌole. Rapa yaca benëꞌ leꞌe balaꞌana, pero Diuzi ratzanëꞌ ca ruele. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","―Hasta dza uzu Juan lao yedyi layu unabëꞌ ley quie Moisés len diꞌidzaꞌ ca una yaca benꞌ profeta. Desde lëdza naꞌ rguixogueꞌ yaca benëꞌ de que bazaꞌ dza inabëꞌ Diuzi lao yedyi layu. Lëcanaꞌ bareguꞌudiꞌ yaca benꞌ zë, yaca benꞌ reꞌen hue bala inabëꞌ Diuzi leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Pero ca naca quie lao ley, nacaran yalo yeyudyi yedu quie guibá len yedyi layu, cala ca biuzun diꞌidzaꞌ ca rnan lëꞌë guichi ga yuꞌu ley quie Diuzi. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","―Chi tu beꞌmbyu bapsannëꞌ nigula zulënëꞌ, naꞌ beziꞌnëꞌ nigula tula, aoquixinëꞌ nacan xquia quienëꞌ lao Diuzi. Naꞌ lëzi, chi tu beꞌmbyu beziꞌnëꞌ nigula psan xquiuhue, aoquixinëꞌ nacan xquia quienëꞌ lao Diuzi. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","―Lëscanꞌ iniaꞌ leꞌe, uzu tu benꞌ uñaꞌa guconëꞌ laꞌariꞌ dyaꞌa, laꞌariꞌ baquitu. Naꞌ biz̃i ruenëꞌ lani yugu dza, udaonëꞌ tadyaꞌa gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Lëscanꞌ uzu tu benꞌ yëchiꞌ gula laonëꞌ Lázaro. Lega dyianëꞌ yedzoꞌ zidzo. Naꞌ rbeꞌnëꞌ layu ruꞌa yuꞌu quie benꞌ uñaꞌa yugu dza. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Biz̃i benꞌ yëchiꞌ rbezëꞌ rnëꞌë chi hueꞌ benꞌ uñaꞌa lëꞌëtiꞌ ta beganꞌ udaohuëꞌ. Naꞌ yaca becoꞌ ubigaꞌyacabaꞌ rlëꞌëyacabaꞌ yedzoꞌ dyianëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Biz̃i bdyin dza guti Lázaro. Naꞌra bequiëꞌ yaca ángel lëbëꞌ ta sunëꞌ guibá ganꞌ zu Abraham. Naꞌ lëzi benꞌ uñaꞌa gutinëꞌ pcachiꞌyaquëꞌ lëbëꞌ luꞌu yu. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Naꞌra uyuꞌunëꞌ luꞌu guiꞌ gabila ga redzagalaohuëꞌ. Cati bechisa laonëꞌ rnëꞌë zituꞌ ga zu Abraham len Lázaro. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Naꞌra uredyiyaꞌnëꞌ zidzo unëꞌ: “Xuzaꞌ Abraham, beyëchiꞌlaꞌadyiꞌ nëꞌëdiꞌ, useꞌelaꞌ Lázaro ulaꞌonëꞌ z̃benëꞌ nisa ta guidëꞌ dedzeꞌnëꞌn luꞌu ruꞌa yeyaꞌalaꞌ lëꞌëtiꞌ ganꞌ yuꞌa niga, porque lega tahuala redzagalaohuaꞌ ganꞌ yuꞌa laguiꞌ niga.” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Naꞌra una Abraham gudyinëꞌ lëbëꞌ: “Z̃iꞌinaꞌ, bezaꞌlaꞌadyiꞌ guca dyaꞌa gula quioꞌ dza uzuloꞌ lao yedyi layu. Naꞌ biz̃i Lázaro niga, biguca dyaꞌa quienëꞌ. Lenaꞌ rezilaꞌadyiꞌnëꞌ zunëꞌ niga len nëꞌëdiꞌ. Naꞌ luëꞌ redzagalaoloꞌ ganꞌ yuꞌuloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lëzi zu tu barranca ga nitaꞌndoꞌ niga. Naꞌ bisaqueꞌ guidandoꞌ ga zuloꞌ. Lëzi luëꞌ bisaqueꞌ guidoꞌ niga.” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Naꞌra unë benꞌ uñaꞌa rëbinëꞌ Abraham: “Rnabayëchaꞌ laoloꞌ, xuzaꞌ Abraham, ta iseꞌeloꞌ Lázaro z̃an yuꞌu quie xuzaꞌ ");
INSERT INTO zpcNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ganꞌ nitaꞌ gaꞌyoꞌ biꞌ bichaꞌ ta yëbinëꞌ leyacabiꞌ canꞌ raca quiaꞌ niga tacuenda biguidayacabiꞌ ganꞌ yuꞌa niga redzagalohuaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Naꞌra una Abraham rëbinëꞌ lëbëꞌ: “Decazi guichi ga yuꞌu xtiꞌidzaꞌ Diuzi ta pcaꞌnnëꞌ lao naꞌa Moisés len yaca los demás benꞌ udixogueꞌ xtiꞌidzëꞌ. Lenaꞌ reyaꞌalaꞌ hueyaquëꞌ bala ulabayaquëꞌn.” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Naꞌra unë benꞌ naꞌ rëbinëꞌ Abraham: “Nacan tali ca naoꞌ, xuzaꞌ Abraham, pero chi tzio tu benꞌ baguti beban tzetixogueꞌnëꞌ leyacabiꞌ, canaꞌ yetzaꞌyacabiꞌ pensari quieyacabiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Naꞌra una Abraham rëbinëꞌ lëbëꞌ: “Chi bihueyacabiꞌ bala cabëꞌ diꞌidzaꞌ yuꞌu lëꞌë guichi laꞌiya quie Diuzi ta pcaꞌnnëꞌ lao naꞌa Moisés, len yaca los demás benꞌ udixogueꞌ xtiꞌidzëꞌ, nica yetzaꞌyacabiꞌ pensari quieyacabiꞌ baꞌalaꞌcazi tzio tu benꞌ baguti beban tzetixogueꞌnëꞌ leyacabiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Naꞌ una Jesús rëbinëꞌ yaca benꞌ quiëꞌ: ―Birdziogue nu benꞌ udzeꞌyela laguedyi ta inën leyaquëꞌ hueyaquëꞌ tamala. Pero hue Diuzi tu castigo huala gula quie benꞌ udzeꞌyela laguedyi. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Quie nu benꞌ rudzeꞌyela xcuidiꞌ, huacaran huen quienëꞌ chi uquioyaquëꞌ tu yo z̃e lubaꞌnëꞌ, naꞌ uzalayaquëꞌ lëbëꞌ luꞌu yao z̃e gatinëꞌ luꞌu nisa, cala ca castigo hue Diuzi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ulegapa cuidado cabëꞌ ruele. ’Uletila biꞌ bichile chanꞌ uquixibiꞌ bëbiꞌ condre leꞌe. Naꞌ chi betzaꞌbiꞌ pensari quiebiꞌ, uleziꞌz̃e quiebiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","’Baꞌalaꞌcazi baoquixibiꞌ babëbiꞌ condre leꞌe gadyi lasa lao tu dza, baꞌalaꞌcazi gadyi lasa bidabiꞌ unabiꞌ leꞌe: “Uz̃iꞌz̃e quiaꞌ, bira huaꞌ canaꞌ”, uleziꞌz̃e quiebiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Naꞌ una yaca benꞌ quie Jesús rëbiyaquëꞌ lëbëꞌ: ―Gacalaoꞌ nëtoꞌ ta sudyiꞌilëndoꞌ Diuzi dyëꞌëdi. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Chi tali sudyiꞌilële Diuzi, laꞌacazi lëꞌëtiꞌzi, huazaqueꞌ yëbile tu yaga: “Uzaꞌ, uyo yetzuꞌu luꞌu yao z̃e”, naꞌ yaga hualen quiele cabëꞌ yëbilen. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","―Chi zu tu benꞌ rue dyin z̃an yuꞌu quiele ¿cala tanëro reyaꞌalaꞌ usiñaꞌnëꞌ ta gaole, te naꞌ huazaqueꞌ gaorënëꞌ, baꞌalaꞌcazi babënëꞌ dyin bedu dza? ");
INSERT INTO zpcNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Cala tali naꞌ yëbileyaquëꞌ: “Psiñaꞌ ta gaohuaꞌ, te aodaohuaꞌ bahuaꞌa, natera huazaqueꞌ gaoloꞌ yoꞌoloꞌ”? ");
INSERT INTO zpcNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Cala tali naꞌ biyëbile benꞌ rue dyin z̃an yuꞌu quiele: “Diuxcalele babële ca ta reꞌendaꞌ huele”, como danꞌ ca ta reyaꞌalaꞌ huecaziyaquëꞌ bëyaquëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Lëscanꞌ canaꞌ nacarën quie leꞌe. Caora babeyudyi babële yugulu ca una Diuzi leꞌe, naꞌtera reyaꞌalaꞌ yëbile Diuzi: “Nacandoꞌ benꞌ bibi zacaꞌte inaoꞌ nëtoꞌ diuxcalele, como danꞌ ca ta reyaꞌalaꞌcazi huendoꞌ bëndoꞌ.” ―Canaꞌ una Jesús gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Naꞌ uzaꞌ Jesús uyuꞌunëꞌ neza ta zionëꞌ ciudad Jerusalén udenëꞌ lao bezaꞌ estado Galilea ga sulao estado Samaria. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bëꞌ bdyinnëꞌ ganꞌ de tu yedyi, lëganꞌ naꞌ bro chi benꞌ yuꞌu yelaꞌ hueꞌ ca mal de pindo. Begaꞌnyaquëꞌ zituꞌ con ganꞌ zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Naꞌ uredyiyaꞌyaquëꞌ zidzo rëbiyaquëꞌ lëbëꞌ: ―¡Jesús, Maestro, yeyëchiꞌlaꞌadyoꞌ nëtoꞌ ca nacandoꞌ! ");
INSERT INTO zpcNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Cati blëꞌë Jesús leyaquëꞌ cabëꞌ nacayaquëꞌ, unëꞌ rëbinëꞌ leyaquëꞌ: ―Uletzio uletzeluꞌe cuinle lao pxuzi. Caora naꞌ uzaꞌyaquëꞌ zioyaquëꞌ. Biz̃i tu neza ganꞌ zioyaquëꞌ bez̃i yelaꞌ hueꞌ yuꞌuyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Naꞌra bëꞌ blëꞌë tunëꞌ babez̃inëꞌ ca naca yelaꞌ hueꞌ yuꞌunëꞌ, naꞌ bebiꞌnëꞌ zeyonëꞌ ganꞌ zë Jesús unënëꞌ zidzo ruenëꞌ Diuzi benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Naꞌ ureꞌnëꞌ uditzu z̃ibinëꞌ lao Jesús, bdaꞌte laohue layu ta rëbinëꞌ Jesús: “Diuxcaleloꞌ.” Lëbenꞌ naꞌ naquëꞌ benꞌ estado Samaria. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―¿Cala chi leꞌe beyaca? ¿Ganaz̃i iga yaca benꞌ beyacarë? ");
INSERT INTO zpcNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Lëbenꞌ niga, benꞌ binaca benꞌ Israel, ¿tuzi lëbëꞌ bebiꞌnëꞌ zezaꞌnëꞌ niga ta ruenëꞌ Diuzi benꞌ z̃e? ");
INSERT INTO zpcNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Bezuli, beyo. Danꞌ rzudyiꞌilëloꞌ Diuzi, lenaꞌ babez̃i yelaꞌ hueꞌ yuꞌuloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Naꞌ bdyin tu dza una yaca benꞌ partido fariseo rëbiyaquëꞌ Jesús: ―¿Bata sulao inabëꞌ Diuzi lao yedyi layu? Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Bide bi ilëꞌële cati sulao inabëꞌ Diuzi lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bisaqueꞌ yëbile benëꞌ: “Barnabëꞌ Diuzi yedyi niꞌ o “Barnabëꞌ Diuzi yedyi naꞌ” como danꞌ pensari yuꞌu luꞌu guicho laxtaꞌole, lenaꞌ inabëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Naꞌ bezu dza tula una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ―Huadyin dza cati gueꞌenle suliaꞌ leꞌe siquiera itu dzazi, pero bisaqueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lëdza naꞌ ina yaca benëꞌ leꞌe: “Bazunëꞌ ni” o “Bazunëꞌ naꞌ” naꞌ bigalele quieyaquëꞌ. Bitziole inaole leyaquëꞌ ga tzioyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Cabëꞌ rlëꞌële quie bdyito hueziuꞌ ratzo rtinan z̃an guibá, canaꞌ ilëꞌële nëꞌëdiꞌ, bichi yugulu benëꞌ, cati idyin dza yeguidaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero ca naca naꞌa, ruen zi yedzagalaotzaguiaꞌ usebiꞌ yaca benꞌ nitaꞌ naꞌa nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Cabëꞌ bë yaca benꞌ unitaꞌ lao yedyi layu tiempote caora uzu Noé, canaꞌ huerë yaca benꞌ initaꞌ lao yedyi layu caora yeguidaꞌ tatula nëꞌëdiꞌ, bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Riꞌo raoyaquëꞌ, rtzaganaꞌyaquëꞌ, rtzaganaꞌrë z̃iꞌiyaquëꞌ hasta bdyin dza uyuꞌu Noé len familia quienëꞌ luꞌu barco quienëꞌ. Lëcanaꞌ ben yusiuꞌ huala gula, guca juicio quie nisa, guti lao yuguluteyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lëzi canaꞌ bërë yaca benꞌ unitaꞌ lao yedyi layu tiempote caora uzu Lot. Riꞌo raoyaquëꞌ, raꞌo rutiꞌyaquëꞌ, razaraꞌnyaquëꞌ rueyaquëꞌ yuꞌu quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero cati bro Lot ciudad Sodoma, lëcanaꞌ bz̃exo Diuzi juicio guiꞌ, uyëzin z̃an guibá, bëtin yuguluteyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lëzi canaꞌ gacarë quie yaca benëꞌ initaꞌ dza bëꞌ yeguidaꞌ lao yedyi layu nëꞌëdiꞌ, bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Lëdza bëꞌ yeguidaꞌ tatula, chi initaꞌ yaca benëꞌ laliꞌa, bireyaꞌalaꞌ yeyuꞌuyaquëꞌ luꞌu yuꞌu quieyaquëꞌ ta cuioyaquëꞌ ta de quieyaquëꞌ nun quie danꞌ ruen baguinzi iz̃unoyaquëꞌ. Lëscanꞌ chi ziorëyaquëꞌ layela, bireyaꞌalaꞌ yeyoyaquëꞌ z̃an yuꞌu quieyaquëꞌ nun quie danꞌ ruen baguinzi iz̃unoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bigalalaꞌadyiꞌle cabëꞌ guca quie z̃gula Lot. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nu benꞌ rdzebi gati, yelaꞌ naꞌ binaoyaquëꞌ nëꞌëdiꞌ, bigataꞌ yelaꞌ neban quieyaquëꞌ tuzioli. Pero nu yaca benꞌ birdzebi gati, yaca benꞌ nao nëꞌëdiꞌ, huataꞌ yelaꞌ neban quieyaquëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Cani rniaꞌ leꞌe, lëyela cati yeguidaꞌ tatula, useriaꞌ yaca benꞌ nao nëꞌëdiꞌ, naꞌ iquiëꞌ yaca ángel leyaquëꞌ. Por ejemplo, chi rasi chopa benëꞌ tzaz̃e lao belaga, iquiëꞌ yaca ángel tunëꞌ, naꞌ yegaꞌn itunëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chi zu chopa nigula rutuyaquëꞌ tzaz̃e lao guichi, iquiëꞌ yaca ángel tunëꞌ, naꞌ yegaꞌn itunëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chi zu chopa beꞌmbyu rueyaquëꞌ dyin tzaz̃e layela, iquiëꞌ yaca ángel tunëꞌ, naꞌ yegaꞌn itunëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bëꞌ beyaquëꞌ canꞌ unëꞌ, naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¿Gaz̃i gaca canꞌ baonaoꞌ, Señor? Naꞌra bequëbinëꞌ rëbinëꞌ leyaquëꞌ: ―Caora rlëꞌële rëcho yaca bëchi ladza, canaꞌ inezile de ta zigo raoyacabaꞌ. Lëcanaꞌ gaca inezile ganꞌ gaca canꞌ baoniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Una Jesús tu diꞌidzaꞌ ni psëdinëꞌ yaca benꞌ quienëꞌ ca ta reyaꞌalaꞌ hueꞌlëyaquëꞌ Diuzi diꞌidzaꞌ yugu dza. Bireyaꞌalaꞌ yeyatiyaquëꞌ, bireyaꞌalaꞌ usanlaꞌadyiꞌyaquëꞌ ulidzayaquëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ―Biz̃i de tu yedyi ga uzu tu juez birapalaꞌnnëꞌ Diuzi, nica rapalaꞌnnëꞌ benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lëlao yedyi naꞌ, lëzi uzurë tu nigula, benꞌ baguti xquiuhue. Riotezi rionëꞌ lao juez ta rnabëꞌ huenëꞌ justicia quiëꞌ len quie benꞌ raca dilalënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Baguca zë lasa biguꞌun juez huenëꞌ justicia quie nigula. Biz̃i naꞌra guca juez pensari unëꞌ: “Baꞌalaꞌcazi nunu rdzebaꞌ, nica Diuzi, nica yaca benëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","por nun quie danꞌ nigula niga rdazi rdëꞌ ruenëꞌ nëꞌëdiꞌ zëdi, tanaꞌ lenaꞌ huacaliaꞌnëꞌ huaꞌ justicia quiëꞌ cuenda bira guidëꞌ hueranëꞌ nëꞌëdiꞌ zëdi. Bardanëꞌëdaꞌ rdazi rdanëꞌ ruenëꞌ nëꞌëdiꞌ zëdi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Canaꞌla bë juez mala pensari ca unëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Naꞌ niaꞌ leꞌe, ¿biz̃i raquele ca hue Diuzi? ¿Raquele bigacalë Diuzi yaca benꞌ quienëꞌ, benꞌ rulidza lëbëꞌ yugu dza yugu yela? ¿Raquele huadzë Diuzi bigacalënëꞌ yaca benꞌ quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Rniaꞌ leꞌe, bitzë Diuzi. Labezi gacalënëꞌ yaca benꞌ quiëꞌ. Pero cati yeguidaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, ¿huadzeledaꞌ benꞌ rzudyiꞌilë Diuzi, lao yedyi layu? ");
INSERT INTO zpcNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Lëzi itu diꞌidzaꞌ ni una Jesús quie yaca benꞌ rlëꞌë cuine benꞌ dyaꞌa, naꞌ rlëꞌëyaquëꞌ laguedyiyaquëꞌ benꞌ mala. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Uyo chopa benëꞌ luꞌu idaoꞌ rnabëꞌra ta ulidzayaquëꞌ Diuzi. Tunëꞌ naquëꞌ benꞌ partido fariseo. Naꞌ itunëꞌ naquëꞌ benꞌ huequiz̃u pquiz̃unëꞌ benëꞌ mazara ca ta reduꞌulanëꞌ siꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Biz̃i zutezi benꞌ partido fariseo rulidzanëꞌ Diuzi unëꞌ cani: “Xuzaꞌ Diuzi, niaꞌ diuxcaleloꞌ como danꞌ binacaꞌ ca benꞌ uban, binacaꞌ ca benꞌ mala, binacaꞌ ca benꞌ rutilë nigula quie benꞌ tula. Binacaꞌ ca benꞌ huequiz̃u niga. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nëꞌëdiꞌ ruaꞌ ubasi chopa lasa lao tu xman. Naꞌ runaꞌ tu cueꞌ lao chi cueꞌ ca tu ta ruaꞌ gan.” Canaꞌ unëꞌ gudyinëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Naꞌ biz̃i benꞌ huequiz̃u, begaꞌnnëꞌ zëꞌ zituꞌla ganꞌ zë benꞌ fariseo. Nica reyaz̃onëꞌ yechisa laonëꞌ ladza. Naꞌ uzulaonëꞌ rcudyinëꞌ ruꞌachuꞌunnëꞌ unëꞌ rëbinëꞌ Diuzi: “Xuzaꞌ Diuzi, beyëchiꞌlaꞌadyiꞌ nëꞌëdiꞌ como danꞌ de dulaꞌ xquia quiaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Naꞌra iniaꞌ leꞌe, beziꞌz̃e Diuzi dulaꞌ xquia de quie benꞌ huequiz̃u, zeyoguëꞌ z̃an yuꞌu quienëꞌ. Biz̃i quie benꞌ partido fariseo nenaocazi dulaꞌ xquia quiëꞌ lëbëꞌ. Rniaꞌ leꞌe, nu benꞌ rue z̃e cuine, huadyin dza hue Diuzi lëbëꞌ benꞌ yubeꞌezi. Naꞌ biz̃i nu benꞌ rue yubeꞌezi cuine, huadyin dza hue Diuzi lëbëꞌ benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Naꞌ guca dza bdyin yaca benëꞌ ganꞌ zë Jesús, nequiëꞌyaquëꞌ xcuidiꞌ quieyaquëꞌ ta uquichinëꞌ naꞌanëꞌ ta huelaꞌiyanëꞌ leyacabiꞌ. Naꞌ biz̃i cati blëꞌë yaca benꞌ quie Jesús nequiëꞌyaquëꞌ xcuidiꞌ quieyaquëꞌ, naꞌ udilayaquëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Naꞌra guz̃i Jesús yaca benꞌ quienëꞌ rëbinëꞌ leyaquëꞌ: ―Biudzunle yaca xcuidiꞌ. Guidagarayacabiꞌ ni como danꞌ ca naca quieyacabiꞌ, rue quieyacabiꞌ quie xuziyacabiꞌ, lëcanaꞌ nacarën quie benꞌ zio rue quie xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tali ca rniaꞌ leꞌe, chi nu yaca benꞌ birue quieyaquëꞌ xtiꞌidzaꞌ Diuzi ca rue xcuidiꞌ quie xuzibiꞌ, bisaqueꞌ yeyoyaquëꞌ guibá ganꞌ zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Biz̃i bdyin tu benꞌ rnabëꞌ ganꞌ zë Jesús, naꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Maestro, benꞌ huen nacoꞌ. Nainaoꞌ, ¿ca biz̃i reyaꞌalaꞌ huaꞌ ta gataꞌ yelaꞌ neban quiaꞌ tuzioli? ");
INSERT INTO zpcNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―¿Bixquienꞌ naoꞌ nacaꞌ benꞌ huen? Tahuencazi naoꞌ canaꞌ, como tuzi Diuzi naquëꞌ benꞌ huen. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Luëꞌ baneziloꞌ ca rna lëꞌë guichi laꞌiya quie Diuzi: “Biutiloꞌ nigula quie benꞌ tula. Bigutioꞌ benëꞌ. Bicuanloꞌ quie benëꞌ. Bisiuꞌ benëꞌ yëꞌ. Lëzi udapalaꞌn xuzoꞌ len z̃naoꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Naꞌra unë benꞌ naꞌ rëbinëꞌ Jesús: ―Yugulu ca rnaoꞌ, ruequiecazaꞌ len zaꞌcazaꞌ naohuaꞌn desde nacatiaꞌ xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bëꞌ be Jesús canꞌ unëꞌ, naꞌra unëꞌ rëbinëꞌ lëbëꞌ: ―De tu ta nerdziogueloꞌ hueloꞌ. Bëtiꞌ yugulu ta de quioꞌ, naꞌ bëꞌn yaca benꞌ yëchiꞌ. Canaꞌ gunra Diuzi taz̃e quioꞌ bëꞌ yedyinloꞌ ganꞌ zunëꞌ guibá. Naꞌ uda unao nëꞌëdiꞌ gacoꞌ benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Naꞌ biz̃i bëꞌ be benꞌ naꞌ ca una Jesús, naꞌ begaꞌnnëꞌ guquenëꞌ beyëchiꞌ gula, como danꞌ naquëꞌ benꞌ uñaꞌa huala gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Caora blëꞌë Jesús guqueyëchiꞌnëꞌ, naꞌra unëꞌ rëbinëꞌ yaca benëꞌ: ―Zëdi gula nacan quie yaca benꞌ uñaꞌa ta yeyoyaquëꞌ guibá ganꞌ zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nacaran yalo te tu camello naga yëchiꞌ, cala ca ta yeyuꞌu benꞌ uñaꞌa guibá ganꞌ zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Naꞌ yaca benꞌ be canꞌ unëꞌ, unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Chi nacan zëdi gula yeyuꞌu yaca benꞌ uñaꞌa guibá ganꞌ zu Diuzi, ¿ca nuz̃i saqueꞌ yeyuꞌu? ");
INSERT INTO zpcNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tu ta bisaqueꞌ hue yaca benëꞌ, Diuzi sí, huazaqueꞌnëꞌ huenëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Naꞌ biz̃i unë Pedro rëbinëꞌ Jesús: ―Señor, nëtoꞌ bapcaꞌnndoꞌ yugulu ta de quiendoꞌ cuenda zaꞌndoꞌ inaondoꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Nacan tali canꞌ rniaꞌ leꞌe. Con nutiꞌtezi benꞌ pcaꞌn nu yuꞌu, nu xuzi, nu z̃nëꞌë, nu bichi, nu z̃gule, nu z̃iꞌine tanun quie danꞌ bazionëꞌ naonëꞌ xneza Diuzi, ");
INSERT INTO zpcNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hueyuꞌera Diuzi taz̃era quienëꞌ dza rdanëꞌ lao yedyi layu cala ca tu ta pcaꞌnnëꞌ. Naꞌ bëꞌ yedyinnëꞌ guibá ganꞌ zu Diuzi, hueꞌnëꞌ lëbëꞌ yelaꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Naꞌ guz̃i Jesús lao chipchopa benꞌ quienëꞌ ubigaꞌyaquëꞌ tzalaꞌla unëꞌ rëbinëꞌ leyaquëꞌ: ―Uletzaꞌ tzioro ciudad Jerusalén ga uzu diꞌidzaꞌ ca diꞌidzaꞌ bzu yaca benꞌ quie Diuzi lëꞌë guichi dza naꞌte. Lëꞌë lëguichi naꞌ rguixogueꞌn cabëꞌ usacaꞌ yaca benëꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Naꞌ yaca benꞌ yedyi quiaꞌ usedyinyaquëꞌ nëꞌëdiꞌ lao naꞌa benꞌ tula ta utituyaquëꞌ utasi unioyaquëꞌ nëꞌëdiꞌ, udaꞌyaquëꞌ z̃enꞌ laohuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Lëzi huaguiyaquëꞌ gutiyaquëꞌ nëꞌëdiꞌ. Biz̃i bëꞌ gaca lao tzona dza, huebanaꞌ yerogaꞌ ganꞌ ucachiꞌyaquëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero yaca benꞌ quie Jesús biuyoñeꞌeyaquëꞌ cabëꞌ gudyi Jesús leyaquëꞌ. Binacan quieyaquëꞌ ta tzioñeꞌeyaquëꞌ canꞌ unëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bagazi idyinyaquëꞌ yedyi Jericó, naꞌ reꞌ tu benꞌ laochula tu neza ganꞌ zioyaquëꞌ rnabëꞌ caridad. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Biz̃i bëꞌ be benꞌ laochula rde yaca benꞌ zë gula, caora naꞌ unabanëꞌ yaca benꞌ binꞌ guca danꞌ rdezi rdeyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Huade Jesús, benꞌ yedyi Nazaret, ganꞌ reꞌloꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Quie lenaꞌ unëꞌ zidzo: ―¡Jesús, z̃iꞌi suba rey David, beyëchiꞌlaꞌadyiꞌ nëꞌëdiꞌ! ");
INSERT INTO zpcNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Biz̃i yaca benꞌ dyialao laohuëꞌ, rdilayaquëꞌ lëbëꞌ ta bira inënëꞌ, pero unërëꞌ zidzora unëꞌ: ―Z̃iꞌi suba rey David, beyëchiꞌlaꞌadyiꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Biz̃i uleza Jesús, bënëꞌ mandado yexiꞌyaquëꞌ benꞌ laochula. Caora bdyinnëꞌ gaꞌalaꞌ ganꞌ zë Jesús, naꞌra unaba Jesús lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Ca biz̃i reꞌenloꞌ huaꞌ quioꞌ? Naꞌ bequëbi benꞌ laochula nëꞌ: ―Señor, reꞌendaꞌ yelëꞌëdaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Babeyacoꞌ, barelëꞌëloꞌ naꞌa nun quie rzudyiꞌilëloꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ca tu beyudyizi unëꞌ canaꞌ, labelëꞌëte benꞌ laochula, uz̃iꞌnëꞌ zionëꞌ naonëꞌ Jesús ruenëꞌ Diuzi benꞌ z̃e. Lëzi yaca benꞌ blëꞌë canꞌ bënëꞌ quie benꞌ laochula, bëyaquëꞌ Diuzi benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Naꞌra bëꞌ bdyin Jesús yedyi Jericó udenëꞌ lao yedyi naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Lëlao yedyi naꞌ uzu tu benꞌ uñaꞌa laonëꞌ Zaqueo. Nacanëꞌ xanꞌ benꞌ huequiz̃u. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","LëZaqueo reꞌennëꞌ ilëꞌënëꞌ Jesús cuenda huebëꞌnëꞌ lëbëꞌ. Pero birzaqueꞌnëꞌ ilëꞌënëꞌ lëbëꞌ, danꞌ lega bguꞌudiꞌ yaca benꞌ zë gula. Naꞌ lëbëꞌ naquëꞌ benꞌ chaco, binaquëꞌ benꞌ huegoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Naꞌra zionëꞌ taria udyialaonëꞌ bdyinnëꞌ ganꞌ zu tu yaga laona sicómoro cuëta neza ganꞌ zio Jesús. Biz̃i naꞌ urënëꞌ lao yaga ta ilëꞌënëꞌ Jesús dyëꞌëdi. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Biz̃i cati bdyin Jesús ganꞌ, bechisa laonëꞌ rnaꞌnëꞌ lao yaga ganꞌ dyia Zaqueo. Naꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Zaqueo, labe beyëzi ganꞌ dyialoꞌ como danꞌ z̃an yuꞌu quioꞌ idyinaꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Biz̃i Zaqueo labezi beyëzinëꞌ ganꞌ dyianëꞌ lao yaga. Bedaohuenëꞌ bequiëꞌnëꞌ Jesús z̃an yuꞌu quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bëꞌ blëꞌë yaca benëꞌ bazio Jesús z̃an yuꞌu quie Zaqueo, naꞌra uzulaoyaquëꞌ rtzaloyaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ unayaquëꞌ bazio Jesús yedyinnëꞌ z̃an yuꞌu quie tu benꞌ hueziꞌ yëꞌ, benꞌ mala gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Naꞌra bareꞌyaquëꞌ luꞌu lidyi Zaqueo, uzulinëꞌ unëꞌ rëbinëꞌ Jesús: ―Señor, huaꞌ yaca benꞌ yëchiꞌ gatzo ta de quiaꞌ. Chi baoz̃iaꞌ benëꞌ yëꞌ ulanaꞌ quieyaquëꞌ, naꞌ yeyuꞌayaquëꞌ lao tapa cueꞌ ta aoz̃iaꞌ quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Naꞌra una Jesús rëbinëꞌ Zaqueo: ―Lenaꞌ ruluꞌen tali abetzaꞌloꞌ pensari quioꞌ, naꞌ barue quioꞌ xtiꞌidzaꞌ Diuzi. Banacoꞌ dugalo z̃iꞌi suba Abraham. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nëꞌëdiꞌ, bichi yugulu benëꞌ, bidaꞌ lao yedyi layu ta ute uselaꞌ benꞌ ruen z̃udyi quie yeyoyaquëꞌ lao guiꞌ gabila. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tu nerzënaga yaca benëꞌ ca rna Jesús, unëꞌ itu diꞌidzaꞌ danꞌ baregaꞌn gaꞌalaꞌ ga reꞌ ciudad Jerusalén, lëscanꞌ danꞌ guqueyaquëꞌ ilëꞌëtiꞌzi rdziogue ta idyin dza inabëꞌ Diuzi lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ―Uzu tu benꞌ balaꞌana. Naꞌ uzëꞌë zionëꞌ yedyi reꞌ zituꞌ ta cuioyaquëꞌ lëbëꞌ gaquëꞌ rey yedyinnëꞌ tatula ta inabëꞌnëꞌ lao yedyi quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero tu zaironëꞌ saꞌnëꞌ, naꞌ guz̃inëꞌ lao chi yaca benꞌ hueꞌnëꞌ ladyinëꞌë. Naꞌ bëꞌnëꞌ quie quieyaquëꞌ tu dumi z̃e. Tanaꞌ unëꞌ gudyinëꞌ leyaquëꞌ: “Ulehue negocio conlë dumi babënaꞌ leꞌe. Naꞌ bëꞌ yeguidaꞌ huero cuenda.” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Naꞌ biz̃i yaca benꞌ lao yedyi quienëꞌ, lega rudieyaquëꞌ lëbëꞌ. Caora naꞌ useꞌelaꞌyaquëꞌ yaca benëꞌ zio zenaoyaquëꞌ lëbëꞌ ta yëbiyaquëꞌ benꞌ reꞌ yedyi ganꞌ zioyaquëꞌ: “Birexendoꞌ benꞌ ni ta gaquëꞌ rey quiendoꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero gucacazinëꞌ rey quieyaquëꞌ. Ude naꞌ bedyinnëꞌ lao yedyi quienëꞌ. Cati bedyinnëꞌ, naꞌ guz̃inëꞌ yaca benꞌ nuꞌenëꞌ ladyinëꞌë dumi quienëꞌ ta inezinëꞌ gaca tu ta bëlëyaquëꞌ gan dumi quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Naꞌra unë benꞌ nëro rëbinëꞌ lëbëꞌ: “Señor, dumi benloꞌ nëꞌëdiꞌ, babëliaꞌn gan ichi cueꞌ mazara ca tu ta benloꞌ nëꞌëdiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Naꞌra una rey naꞌ rëbinëꞌ lëbëꞌ: “Tahuen gula babaoꞌ. Naꞌ nun quie bzuloꞌ diꞌidzaꞌ baoꞌ huen conlë lëꞌëtiꞌzi pcaꞌnaꞌ lao naꞌaloꞌ, naꞌra gacoꞌ benꞌ rnabëꞌ quie lao chi yedyi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Lëzi bdyin benꞌ urupe unëꞌ rëbinëꞌ rey naꞌ: “Señor, dumi quioꞌ benloꞌ nëꞌëdiꞌ, babëliaꞌn gan igaꞌyo cueꞌ mazara ca tu ta benloꞌ nëꞌëdiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Naꞌra una rey naꞌ rëbinëꞌ lëbëꞌ: “Gacoꞌ benꞌ rnabëꞌ lao gaꞌyoꞌ yedyi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Biz̃i bdyin benꞌ uyune unëꞌ rëbinëꞌ rey naꞌ: “Señor, ni zeyuꞌa dumi benloꞌ nëꞌëdiꞌ. Ptubaꞌn laꞌariꞌ bdzeꞌtzaꞌohuaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bibëliaꞌ dumi quioꞌ negocio, danꞌ rdzebaꞌ chanꞌ initin idzaꞌloꞌ nëꞌëdiꞌ, danꞌ nezdaꞌ nacoꞌ benꞌ reguëꞌë bireꞌenloꞌ initi ta de quioꞌ. Nezdaꞌ ruelaoꞌ dumi quioꞌ negocio ga gacan seguro hue guichon.” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Naꞌra una rey naꞌ rëbinëꞌ benꞌ naꞌ: “Benꞌ mala gula nacoꞌ. Con canꞌ rnaoꞌ ruluꞌen quioꞌ aoquixoꞌ bibë quioꞌ hueloꞌ ca reꞌendaꞌ. Chi nezoꞌ nacaꞌ benꞌ reguëꞌë, benꞌ rue negocio ga gacan seguro hue guichon, ");
INSERT INTO zpcNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿bixquienꞌ biyelëchoꞌ dumi quiaꞌ lao banco tacuenda hue guichon yeziꞌa dumi quiaꞌ len guichon bëꞌ yelaꞌ z̃an yuꞌu?” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Naꞌra una rey naꞌ gudyinëꞌ yaca benꞌ nitaꞌ naꞌ: “Ulesiꞌ dumi biꞌa benꞌ naꞌ, naꞌ ulehueꞌna benꞌ biꞌa chi dumi.” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Naꞌ unayaquëꞌ rëbiyaquëꞌ rey naꞌ: “Pero Señor, badecazi chi dumi quienëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Naꞌ una rey naꞌ rëbinëꞌ leyaquëꞌ: “Nu benꞌ rue quie ca ta pcaꞌn xaꞌnnëꞌ ladyinëꞌë, lëlëbëꞌ hueꞌra xaꞌnnëꞌ lëbëꞌ mazara. Pero nu benꞌ birue quie ca ta pcaꞌn xaꞌnnëꞌ ladyinëꞌë, hueguba xaꞌnnëꞌ ca ta bëꞌnëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pero ca naca yaca benꞌ rudie nëꞌëdiꞌ, yaca benꞌ birexe gacaꞌ rey quieyaquëꞌ, uletzexiꞌyaquëꞌ gutileyaquëꞌ zaquëꞌ laohuaꞌ ni.” ");
INSERT INTO zpcNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bëꞌ beyudyi una Jesús canaꞌ, beyuꞌuyaquëꞌ neza tatula uzaꞌyaquëꞌ zioyaquëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Cati baruen bago idyinyaquëꞌ yedyi Betfagé len yedyi Betania, ga nacan gaꞌalaꞌ ganꞌ zu tu yaꞌa Olivos, lëganꞌ naꞌ useꞌelaꞌnëꞌ chopa benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Naꞌ unëꞌ gudyinëꞌ leyaquëꞌ: ―Uletzio yedyi reꞌ niꞌ gaꞌalaꞌ. Bëꞌ idyinle ganꞌ, huatzaxacale tu burra neriobaꞌ, bia nitu nunu necuia. Uxëdyilebaꞌ nadahuaꞌalebaꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Chi ilëꞌë yaca benëꞌ leꞌe inayaquëꞌ leꞌe bixquienꞌ rxëdyilebaꞌ, naꞌ reyaꞌalaꞌ yëbileyaquëꞌ reꞌen Señor lëbaꞌ ta cuianëꞌbaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Naꞌra uzaꞌ yaca benꞌ quie Jesús zioyaquëꞌ ganꞌ useꞌelaꞌnëꞌ leyaquëꞌ. Naꞌ laga guca quieyaquëꞌ cabëꞌ gudyi Jesús leyaquëꞌ yexacayaquëꞌ lëganꞌ nerio burra. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Naꞌ caora barxëdyiyaquëꞌ burra, canaꞌ bdyincazi xanꞌ burra, naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Bixquienꞌ rxëdyile burra quiaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Reꞌen Señor lëbaꞌ ta cuianëꞌbaꞌ. Bëꞌ idyinnëꞌ ganꞌ ziondoꞌ, nadesanndoꞌbaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Naꞌ bequiëꞌyaquëꞌbaꞌ ganꞌ zë Jesús, uxubayaquëꞌ z̃abayaquëꞌ xcuꞌudzu burra ta udyianëꞌ lëbaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tu neyuꞌu Jesús neza zionëꞌ ciudad Jerusalén, ulëchoyaquëꞌ z̃abayaquëꞌ udixuyaquëꞌn tu neza ganꞌ tenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Caora bdyinyaquëꞌ ganꞌ zu leto quie yaꞌa Olivos, canaꞌ uzulao yaca benꞌ zio nao Jesús unëyaquëꞌ zidzo. Lega redaohueyaquëꞌ bëyaquëꞌ Diuzi benꞌ z̃e ca naca yelaꞌ huaca bënëꞌ blëꞌëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Lenaꞌ unayaquëꞌ zidzo: ―Benꞌ naca laꞌiya benꞌ niga. Naquëꞌ rey quiero. Diuzi useꞌelaꞌnëꞌ lëbëꞌ. Redaohue yaca benꞌ nitaꞌ guibá ca ruenëꞌ. Naca Diuzi benꞌ z̃e gula. ―Canaꞌ unayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Naꞌ biz̃i nitaꞌ bala yaca benꞌ partido fariseo lado yaca benꞌ zio nao Jesús. Naꞌ unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Maestro, reyaꞌalaꞌ tiloꞌ yaca benꞌ zaꞌ nao luëꞌ niga ta bira inayaquëꞌ canꞌ nayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Naꞌ bequëbi Jesús rëbinëꞌ leyaquëꞌ: ―Rniaꞌ leꞌe, chi yegaꞌn yaca benꞌ niga chizi, huanë yaca yo ni zidzo lao lazayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cati bdyinyaquëꞌ gaꞌalaꞌ ga reꞌ ciudad Jerusalén, naꞌ blëꞌënëꞌ ciudad naꞌ, naꞌ uredyinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Quie lao ciudad naꞌ unëꞌ cani: ―Bidaꞌ ta ucuasa ucuiꞌogaꞌ leꞌe cueꞌ chizi laxtaꞌole tuzioli, pero bireꞌenle birezaquele nëꞌëdiꞌ. Quie lenaꞌ baode quiele naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bazaꞌ dza gaca bayëchiꞌ gula quiele. Hualaꞌ yaca benꞌ zë, yaca benꞌ rudie leꞌe. Huayëchoyaquëꞌ lao ciudad quiele uzaꞌagayaquëꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Gutiyaquëꞌ leꞌe len z̃gulale len z̃iꞌile. Yelaꞌte uquinuyaquëꞌ yuꞌu quiele. Canaꞌ gaca quiele como danꞌ bibë quiele nëꞌëdiꞌ dza bidaꞌ guꞌundaꞌ suliaꞌ leꞌe tuz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Naꞌra uyuꞌu Jesús luꞌu idaoꞌ rnabëꞌra blaonëꞌ yaca benꞌ yuꞌu raꞌo rutiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Lëꞌë guichi ganꞌ yuꞌu diꞌidzaꞌ laꞌiya quie Diuzi nan cani: “Luꞌu idaoꞌ rnabëꞌra ni nacan ga rlidza yaca benëꞌ Diuzi.” Pero leꞌe abetzaꞌlen ruelen ca quie beló ga yuꞌu benꞌ uban. ―Canaꞌ una Jesús gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pero yugu dza rio Jesús luꞌu idaoꞌ rnabëꞌra ruxiꞌidzeꞌnëꞌ yaca benëꞌ. Pero yaca xanꞌ pxuzi, len yaca benꞌ rusëdi ley quie Moisés, len yaca benꞌ napa dyin quie lao yedyi, reguilolaꞌadyiꞌyaquëꞌ rnaꞌyaquëꞌ ca hueyaquëꞌ ta gutiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero biubinyaquëꞌ bi hueyaquëꞌ ta gutiyaquëꞌ lëbëꞌ, como danꞌ nitaꞌ yaca benꞌ zë gula rexeyaquëꞌ uzënagayaquëꞌ canꞌ rnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Biz̃i bdyin tu dza zë Jesús luꞌu idaoꞌ rnabëꞌra ruxiꞌidzëꞌ yaca benëꞌ ca reꞌen Diuzi hueyaquëꞌ ta yeyëri laxtaꞌoyaquëꞌ laohuëꞌ. Naꞌ bdyin yaca xanꞌ pxuzi, len yaca benꞌ rusëdi ley quie Moisés, len yaca benꞌ napa dyin quie yulaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Una nëtoꞌ ¿nu ben yelaꞌ rnabëꞌ quioꞌ, danꞌ bablaoloꞌ yaca benꞌ yuꞌu huëtiꞌ luꞌu idaoꞌ rnabëꞌra? ");
INSERT INTO zpcNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Lëscanꞌ reꞌendaꞌ inabaꞌ leꞌe tu diꞌidzaꞌ. Naꞌ yequëbile quiaꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Nuz̃i useꞌelaꞌ Juan bautista? ¿Useꞌelaꞌ Diuzi lëbëꞌ o ta racazi laꞌadyiꞌnëꞌ bidëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Naꞌra uzulaoyaquëꞌ rtzaloyaquëꞌ ruꞌelëyaquëꞌ laguedyiyaquëꞌ diꞌidzaꞌ unayaquëꞌ: ―¿Cabiz̃i yëbironëꞌ? Chanꞌ yëbironëꞌ: “Diuzi useꞌelëꞌ lëbëꞌ”, naꞌ huanëꞌ raꞌo: “¿Bixquienꞌ bigulele quienëꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Naꞌ chi yëbironëꞌ: “Ta racazi laꞌadyiꞌnëꞌ bidëꞌ”, naꞌ huadzaꞌ yaca benëꞌ raꞌo, ruen z̃udyi huaguiyaquëꞌ raꞌo yo, gutiyaquëꞌ raꞌo como danꞌ rnayaquëꞌ useꞌelaꞌ Diuzi Juan rguixogueꞌnëꞌ xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Naꞌra unayaquëꞌ rëbiyaquëꞌ Jesús: ―Binezindoꞌ nu benꞌ useꞌelaꞌ Juan bautista. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Lëzi unarë Jesús rëbinëꞌ leyaquëꞌ: ―Lëscanꞌ nëꞌëdiꞌ, biiniaꞌ leꞌe nu ben yelaꞌ rnabëꞌ quiaꞌ bablaohuaꞌ yaca benꞌ yuꞌu huëtiꞌ luꞌu idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Naꞌra una Jesús itu diꞌidzaꞌ ni rëbinëꞌ yaca benëꞌ: ―Uzu tu benꞌ guzanëꞌ bedzuliꞌ lao layu quienëꞌ. Ude naꞌ pcaꞌnnëꞌn lao naꞌa yaca benꞌ gaca ladyinëꞌë layela quienëꞌ. Naꞌ uzëꞌë zioguëꞌ yedyi reꞌ zituꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Biz̃i cati bdyin biuꞌ quie usecho quie bedzuliꞌ, naꞌ beseꞌelaꞌ xanꞌ layela tu benꞌ zu laohuëꞌ ta tzenabanëꞌ tu ta reduꞌulanëꞌ siꞌnëꞌ quie bedzuliꞌ quienëꞌ. Pero belaꞌcala bëꞌyaquëꞌ ziꞌ benꞌ useꞌelaꞌ xaꞌnyaquëꞌ. Naꞌ bezaꞌnëꞌ gabi zeyuꞌanëꞌ, bedyinëꞌ lao xaꞌnnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Naꞌra beseꞌelaꞌ benꞌ xanꞌ layela benꞌ tula zioguëꞌ. Pero lëzi utasi unioyaquëꞌ lëbëꞌ, bëꞌyaquëꞌ lëbëꞌ ziꞌ, gabi bëꞌyaquëꞌ lëbëꞌ. Naꞌ zeyoguëꞌ bedyinëꞌ lao xaꞌnnëꞌ, gabi zeyuꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Biz̃i benꞌ xanꞌ layela, tatula beseꞌelaꞌnëꞌ benꞌ tula, benꞌ uyune. Lëzi bërëyaquëꞌ lëbëꞌ hueꞌ, blaoyaquëꞌ lëbëꞌ, gabi zeyuꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Pues guca benꞌ xanꞌ layela pensari unëꞌ: “¿Ca biz̃ira huaꞌ? Naꞌ iseꞌelaꞌ z̃iꞌinaꞌ biꞌ nedyëꞌëdaꞌ. Cati ilëꞌëyaquëꞌ lëbiꞌ, chica huapalaꞌnyaquëꞌ lëbiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero bëꞌ blëꞌë yaca benꞌ naca ladyinëꞌë layela babdyin z̃iꞌi xaꞌnyaquëꞌ, naꞌra unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: “Biꞌ niga gaca quiebiꞌ layu niga cati bagati xuzibiꞌ. Uletzaꞌ gutirobiꞌ cuenda siꞌro layu niga gacan quiero.” ");
INSERT INTO zpcNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Naꞌra bëxoyaquëꞌbiꞌ, ulioyaquëꞌbiꞌ ganꞌ de layela, bëtiyaquëꞌ lëbiꞌ. Naꞌra unaba Jesús yaca benꞌ nitaꞌ naꞌ tu diꞌidzaꞌ unëꞌ: ―¿Cabiz̃i hue xanꞌ layela len leyaquëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pues huedyinnëꞌ ganꞌ de layela quienëꞌ ta gutinëꞌ yaca benꞌ nuꞌenëꞌ ladyinëꞌë, hueꞌnëꞌ yaca benꞌ tula gaca ladyinaꞌayaquëꞌ layela quienëꞌ. Naꞌra caora be yaca benëꞌ cabëꞌ una Jesús, naꞌ unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Birda chi tamala ca tamala bë yaca benꞌ guca ladyinëꞌë layela. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Naꞌra unaꞌ Jesús leyaquëꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Chi nacan canꞌ rnale, ¿ga huen dyin diꞌidzaꞌ yuꞌu lëꞌë guichi laꞌiya quie Diuzi rnën caniga?: Yo lagaꞌ ta baoruꞌun benꞌ hue huecuaꞌ, lëyo naꞌ beziꞌ Diuzi bzunëꞌn ga naca belao, ga rzulao besu. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Naꞌ rniaꞌ leꞌe, nu yaca benꞌ iguino lëlao yo naꞌ, huayoz̃o iguinoyaquëꞌ. Lëscanꞌ chi iguino yo idacon leyaquëꞌ, huatzutzon leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Naꞌra yaca xanꞌ pxuzi, len yaca benꞌ rusëdi ley quie Moisés, guꞌunyaquëꞌ guxuyaquëꞌ Jesús luegozi, danꞌ bezaqueyaquëꞌ quieyaquëꞌ unë Jesús diꞌidzaꞌ quie yaca benꞌ guca ladyinëꞌë layela. Pero bibeyaz̃oyaquëꞌ bi hueyaquëꞌ quienëꞌ, danꞌ rdzebiyaquëꞌ bi hue yaca benëꞌ quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Biz̃i cabëꞌ beguilolaꞌadyiꞌyaquëꞌ bëyaquëꞌ, useꞌelaꞌyaquëꞌ benꞌ ruezi cuine ca benꞌ balaꞌana ta tzenabayaquëꞌ Jesús diꞌidzaꞌ chi iquixinëꞌ inëꞌ calëla tacuenda ga saqueꞌ gaoyaquëꞌ lëbëꞌ xquia lao benꞌ naca gobierno. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Quie lenaꞌ bdyinyaquëꞌ ganꞌ zë Jesús unayaquëꞌ rëbiyaquëꞌ Jesús: ―Maestro, banezindoꞌ luëꞌ rxiꞌidzeꞌloꞌ yaca benëꞌ diꞌidzaꞌ naca li. Naꞌ biruꞌ cuenda bi naque yaca benëꞌ, sino rxiꞌidzeꞌloꞌ benëꞌ tali ca naca xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Unacara nëtoꞌ: ¿Ruꞌen lato quiz̃oro quie impuesto quie benꞌ naca gobierno romano? ¿Huaguiz̃oron o biquiz̃oron? ");
INSERT INTO zpcNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero banezi Jesús ca naca pensari mala yuꞌuyaquëꞌ reguilolaꞌadyiꞌyaquëꞌ bi hueyaquëꞌ quienëꞌ. Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Bixquienꞌ reꞌenle cuëchile trampa quiaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Uleuluꞌecara nëꞌëdiꞌ tu dumi. ¿Nu guicho, nu laohue daꞌ lëꞌën? Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Daꞌ lëꞌë dumi nu guicho, nu lao benꞌ naca gobierno. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Ulehueꞌ benꞌ naca gobierno ta reduꞌulanëꞌ siꞌnëꞌ. Lëscanꞌ ulehueꞌ Diuzi ta reduꞌulanëꞌ siꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Naꞌ gabi uz̃aqueꞌyaquëꞌ ga iquixi Jesús ca diꞌidzaꞌ rnëꞌ lao benëꞌ. Belaꞌcala tu bebanziyaquëꞌ canꞌ unëꞌ. Babira biubinyaquëꞌ bi yëbiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ude naꞌ uyorë yaca benꞌ partido saduceo ganꞌ zë Jesús. Naꞌra rna yaca benꞌ partido saduceo biyeban yaca benꞌ baguti. Quie lenaꞌ unayaquëꞌ rëbiyaquëꞌ Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, ca naca diꞌidzaꞌ bzu Moisés lëꞌë guichi, rnën chi baguti tu beꞌmbyu, naꞌ begaꞌn z̃gulanëꞌ tu cuinzëꞌ, nunu z̃iꞌiyaquëꞌ uzu, ruen zi yeziꞌ biꞌ bichinëꞌ nigula quie benꞌ baguti tacuenda yezu xcuidiꞌ yeziꞌ lao benꞌ baguti. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Naꞌ ugunro guca gadyi bichiyaquëꞌ. Naꞌ benꞌ nëro uz̃iꞌnëꞌ nigula quienëꞌ. Pero ni tu z̃iꞌiyaquëꞌ biuzu gutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Naꞌ biz̃i benꞌ urupe beziꞌnëꞌ nigula quie benꞌ bichinëꞌ, benꞌ baguti. Lëzi gutirënëꞌ, nunu z̃iꞌiyaquëꞌ uzurë. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Naꞌ biz̃i benꞌ uyune beziꞌrënëꞌ nigula quie benꞌ bichinëꞌ, benꞌ baguti. Lëzirë gutirënëꞌ nunu z̃iꞌiyaquëꞌ uzurë. Canaꞌ guca quie lao gadyiteyaquëꞌ, yaca benꞌ uzulë nigula. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ga beyudyicala quie nigula, gutirënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Naꞌra chi tali naꞌ yeban yaca benꞌ huati, ¿ca nurlayaquëꞌ naca z̃gulayaquëꞌ nigula naꞌ, como danꞌ lao gadyi bichiyaquëꞌ uzulëyaquëꞌ lëbëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Naꞌ bequëbi Jesús rëbinëꞌ leyaquëꞌ: ―Lao yedyi layu niga rzulë beꞌmbyu nigula, lëscanꞌ rzulë nigula beꞌmbyu. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero yaca benꞌ yeban yeyo guibá ga zu Diuzi, bira sulëyaquëꞌ laguedyiyaquëꞌ ca nu z̃gulayaquëꞌ, ca nu xquiuyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Lëscanꞌ bira gatiyaquëꞌ. Cabëꞌ bigati yaca ángel, canaꞌ bigatirëyaquëꞌ. Tali nacayaquëꞌ z̃iꞌi Diuzi, danꞌ babebanyaquëꞌ huatzezulëyaquëꞌ Diuzi tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Naꞌ rguixogueꞌ yaca diꞌidzaꞌ bzu Moisés lëꞌë guichi de que yeban yaca benꞌ baguti. Caora zë Moisés ganꞌ reꞌ yaga raꞌalaꞌ guiꞌ bireina, lëganꞌ naꞌ una Diuzi gudyinëꞌ Moisés: “Nacaꞌ Diuzi quie xuzixtaꞌoloꞌ Abraham, len quie xuzixtaꞌoloꞌ Isaac, len quie xuzixtaꞌoloꞌ Jacob.” ");
INSERT INTO zpcNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Canaꞌ una Diuzi quieyaquëꞌ, baꞌalaꞌcazi bagutiyaquëꞌ azio zë iza caora. Lenaꞌ ruluꞌen rlëꞌë Diuzi leyaquëꞌ ca benꞌ neneban, cala ca benꞌ baguti. Pues rlëꞌë Diuzi yugulu benëꞌ ca yaca benꞌ neban. Birlëꞌënëꞌ leyaquëꞌ ca benꞌ baguti. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Biz̃i bala yaca benꞌ rusëdi ley quie Moisés, benꞌ nitaꞌ naꞌ, ruzënagayaquëꞌ bi na Jesús, unayaquëꞌ rëbiyaquëꞌ Jesús: ―Tahuencazi cabëꞌ baonaoꞌ, Maestro. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Naꞌ biz̃i bira biubinyaquëꞌ bi diꞌidzaꞌ inabayaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Nacan tali ca nale, nale naca benꞌ Cristo z̃iꞌi rey David. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pero cuin rey David, caora bzunëꞌ diꞌidzaꞌ lëꞌë guichi Salmos, unëꞌ cani: Una Diuzi rëbinëꞌ benꞌ naca Señor quiaꞌ: “Ureꞌ cuëtaꞌ zaquëꞌ yebë niga, ");
INSERT INTO zpcNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta idyin dza cuëchaꞌ xniꞌaloꞌ yaca benꞌ rudie luëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Quie lenaꞌ rnabaꞌ leꞌe: ¿Cómo naca benꞌ Cristo z̃iꞌi rey David, chi cuin rey David unëꞌ naca benꞌ Cristo Señor quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Naꞌ benꞌ zë nitaꞌ bzënagayaquëꞌ ca una Jesús caora unëꞌ rëbinëꞌ yaca benꞌ quienëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Gapale cuidado bihuele ca rue yaca benꞌ rusëdi ley quie Moisés. Lega rexeyaquëꞌ gacoyaquëꞌ laꞌariꞌ naca tona. Lega rexeyaquëꞌ gapalaꞌn yaca benëꞌ leyaquëꞌ ga rdayaquëꞌ tu neza. Lega rexeyaquëꞌ cueꞌyaquëꞌ ga rbeꞌ benꞌ balaꞌana, chi luꞌu idaoꞌ sinagoga, chi ga raca lani. ");
INSERT INTO zpcNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Zidza rulidzayaquëꞌ Diuzi cuenda ilëꞌë yaca benëꞌ leyaquëꞌ benꞌ quie Diuzi, pero bëꞌ rueziyaquëꞌ reguilolaꞌadyiꞌyaquëꞌ bi hueyaquëꞌ ta cubayaquëꞌ ta de quie yaca nigula baguti xquiuhue. Quie lenaꞌ huera Diuzi leyaquëꞌ tu castigo huala gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Naꞌ guca tu dza zë Jesús luꞌu idaoꞌ rnabëꞌra blëꞌënëꞌ rudzeꞌ yaca benꞌ uñaꞌa dumi quieyaquëꞌ luꞌu caja ga yuꞌun gun quie idaoꞌ rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Lëzi blëꞌënëꞌ bdzeꞌ tu nigula guti xquiuhue chopa dumi daoꞌ lasi de cobre luꞌu caja naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Naꞌ una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ―Tali rniaꞌ leꞌe, nigula naꞌ naquëꞌ benꞌ yëchiꞌ, aguti xquiuhuëꞌ, pero ca naca dumi bdzeꞌnëꞌ luꞌu caja, nacaran dumi z̃e cala ca ta bdzeꞌ yaca benꞌ uñaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ta begaꞌnnan sobre quieyaquëꞌ bdzeꞌyaquëꞌ luꞌu caja naꞌ, pero lënigula benꞌ yëchiꞌ, bdzeꞌnëꞌ ca tu dumi daoꞌ dezi quienëꞌ ta raꞌonëꞌ ta raonëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Naꞌra yaca benꞌ quie Jesús, bëꞌlëyaquëꞌ laguedyiyaquëꞌ diꞌidzaꞌ unayaquëꞌ quie idaoꞌ rnabëꞌra de que nacan badan gula, len yo necuaꞌ besu, len tu ta psalaꞌadyiꞌ yaca benëꞌ bëꞌyaquëꞌ quie idaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Huadyin dza iguino duz̃e ca ta rnaꞌle niga. Ni tu yo bira yegaꞌnnan xcuꞌudzu laguedyin. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Naꞌra yaca benꞌ quie Jesús unabayaquëꞌ Jesús rëbiyaquëꞌ lëbëꞌ: ―Maestro, ¿bata gaca canꞌ rnaoꞌ? ¿Ca biz̃i gaca ta uluꞌen nëtoꞌ cati baruen bago dza gaca canꞌ rnaoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Gapale cuidado ta bisiꞌ yaca benëꞌ leꞌe yëꞌ. Porque huida benꞌ zë inayaquëꞌ: “Nëꞌëdiꞌ nacaꞌ Cristo.” Lëscanꞌ inayaquëꞌ: “Abdyin hora yeyudyi yedu quie dyila yu.” Pero bigalele quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Lëzi cati babele baozulao huedila, rdilalë nación conlë itu nación, lëscanꞌ rdilalë benëꞌ conlë gobierno quieyaquëꞌ, bidzebile. Huataꞌcazi huedila quie lao yedyi layu, pero nerdziogue idyin dza yeyudyi yedu quie lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Lëscanꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Huaca dilalë tu nación itu nación. Huaca dilalë tu yedyi itu yedyi. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lëscanꞌ niꞌnizi quie lao yedyi layu huaca uz̃uꞌ huala, huataꞌ ubin, huataꞌ yelaꞌ hueꞌ. Lëscanꞌ hualëꞌë yaca benëꞌ ta utzebin leyaquëꞌ zaꞌn guibá huazën ladza. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero tu zagaca canꞌ, guxu yaca benëꞌ leꞌe hueyaquëꞌ leꞌe bizinaquezi. Iquiëꞌyaquëꞌ leꞌe luꞌu yaca idaoꞌ sinagoga ta gaoyaquëꞌ leꞌe xquia. Lëscanꞌ udzeꞌyaquëꞌ leꞌe luꞌu dyiguiba, usedyinyaquëꞌ leꞌe lao naꞌa benꞌ naca gobierno danꞌ baralele bazaꞌle naole nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Canaꞌ gaca quiele tacuenda inële cule nëꞌëdiꞌ laoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bidëbile ca bi yëbileyaquëꞌ cuenda gacalële cuinle laoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bidëbile como danꞌ gacaliaꞌ leꞌe bi diꞌidzaꞌ yequëbile yeyëbileyaquëꞌ cuenda initaꞌ yaca benꞌ rudie leꞌe chizi, bira ibinyaquëꞌ bi inayaquëꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hasta benꞌ naca familia quiele, len benꞌ naca amigo quiele, huaziꞌyaquëꞌ leꞌe yëꞌ. Usedyin nu xuzile, nu bichile, nu diadza quiele, nu amigo quiele leꞌe lao naꞌa benꞌ rnabëꞌ. Gutiyaquëꞌ bala leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Huadi yaca benꞌ nitaꞌ lao yedyi layu leꞌe danꞌ naole xnezaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero bibi gaca quiele, ni tu guitzaꞌ guichole bicuiaguiꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chi hue quiele biusanlaꞌadyiꞌle naole xnezaꞌ, huataꞌ yelaꞌ neban quiele tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Cati ilëꞌële baneyëchote yaca soldado ciudad Jerusalén, huanezile baruen bago dza udyiaguiꞌyaquëꞌ lao ciudad naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Naꞌra yaca benꞌ nitaꞌ estado Judea, ruguinte iz̃unoyaquëꞌ tzioyaquëꞌ ga zu yaꞌa. Lëscanꞌ yaca benꞌ nitaꞌ ciudad Jerusalén, ruguinte eroyaquëꞌ tzioyaquëꞌ huaz̃uno. Lëscanꞌ yaca benꞌ nitaꞌ lao layela, bireyaꞌalaꞌ yeyoyaquëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Lëdza gaca canꞌ nacan dza hue Diuzi castigo. Nacan dza uzucazi yugulu diꞌidzaꞌ ca diꞌidzaꞌ yuꞌu lëꞌë guichi laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Huaca bayëchiꞌ gula quie yaca nigula nuꞌa bdaoꞌ, len yaca nigula rugaꞌadyi bdaoꞌ dza gaca canꞌ. Lega yedzagalao yaca benꞌ Israel, hue Diuzi leyaquëꞌ tu castigo huala gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Naꞌ guti yaca soldado balayaquëꞌ. Naꞌ ibalayaquëꞌ uquioyaquëꞌ hueyaquëꞌ leyaquëꞌ preso iquiëꞌyaquëꞌ leyaquëꞌ yaca yedyi zë, yedyi tula. Tanaꞌ lenaꞌ inabëꞌ yaca benꞌ zaꞌ yedyi tula lao ciudad Jerusalén hasta idyin dza bira hue Diuzi lato inabëꞌyaquëꞌ lao ciudad naꞌ. Naꞌ una Jesús: ");
INSERT INTO zpcNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","―Ude naꞌ huataꞌ ta naca seña ladza. Huechula obidza, bira gataꞌ xniꞌ biuꞌ, huaguino yaca bélo. Huaca tondo yaca benꞌ nitaꞌ lao yedyi layu. Huadzebiyaquëꞌ yeyaquëꞌ xchiꞌ nisadaoꞌ ruen ruꞌbe huala gula ga rbigaꞌ rdan ruꞌa yu bidyi. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Huayunꞌyaquëꞌ tanto idzebiyaquëꞌ ca gaca quieyaquëꞌ lao yedyi layu. Huazisi huaguino yaca bélo dyian guibá. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lëcanaꞌ hualëꞌë yaca benꞌ nitaꞌ lao yedyi layu nëꞌëdiꞌ, bichi yugulu benëꞌ. Hualëꞌëyaquëꞌ yeguidaꞌ lao beo zë ladza. Hualëꞌëyaquëꞌ nëꞌëdiꞌ de yelaꞌ huaca quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cati baraca canꞌ rniaꞌ, naꞌra bidzebile, reyaꞌalaꞌ yechisa guichole inaꞌle ladza como danꞌ ilëꞌëtiꞌzi rdziogue ute uselaꞌ leꞌe ca ta raca quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Lëzirë unë Jesús itu diꞌidzaꞌ ni, unëꞌ rëbinëꞌ leyaquëꞌ: ―Ulenaꞌcara ca raca quie yaga higo o bitezi yaga tula. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cati ilëꞌële bagusin laꞌagaꞌ gula, barebian laꞌagaꞌ reꞌene quien, banezile bazaꞌ biuꞌ oba. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lëzirë cati ilëꞌële baraca cabëꞌ rniaꞌ leꞌe, reyaꞌalaꞌ inezile bazaꞌ dza inabëꞌ Diuzi lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Tali rniaꞌ leꞌe, tu bineya z̃iꞌisuba benꞌ nitaꞌ naꞌa, bëꞌ gaca cabëꞌ rniaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Huade quie ta dyia guibá len lao yedyi layu canaꞌzi, pero ca naca diꞌidzaꞌ rniaꞌ leꞌe, biten canaꞌzi. Decazide huazun diꞌidzaꞌ cabëꞌ rniaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ulegapa cuidado, bihueꞌle lato gacale zidi tzuꞌu pensari mala luꞌu guicho laxtaꞌole. Bihuele tabayatza, bihuele hueꞌe, bidëbile quie ta gaole, bidëbile quie ta gacole, yelaꞌ naꞌ biyebanle dza yeguidaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Porque cabëꞌ rdzebi bia guixiꞌ bëꞌ rdacobaꞌ luꞌu trampa, canaꞌ yedzebi yaca benꞌ nitaꞌ lao duz̃e yedyi layu dza yeguidaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lenaꞌ niaꞌ leꞌe, ulesu listo. Ulehueꞌlë Diuzi diꞌidzaꞌ yugu dza, yugu yela, cuenda ucuasa ucuiꞌonëꞌ leꞌe ca tamala zaꞌ gaca lao yedyi layu. Ulehue quiele cuenda yetilalaole nëꞌëdiꞌ, bichi yugulu benëꞌ. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ruxiꞌidzeꞌ Jesús yaca benëꞌ luꞌu idaoꞌ rnabëꞌra te dza. Naꞌ biz̃i quie sadzeꞌ rionëꞌ ga zu yaꞌa lao Olivos ga reguesinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Biz̃i yaca benꞌ zë rdyinyaquëꞌ yugu zila luꞌu idaoꞌ rnabëꞌra ta rzënagayaquëꞌ ca diꞌidzaꞌ ruxiꞌidzëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Naꞌ baruen bago ta hue yaca benꞌ Israel lani pascua ta gaoyaquëꞌ yëta xtila binequixi levadura. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Biz̃i yaca xanꞌ pxuzi len yaca benꞌ rusëdi ley quie Moisés, lega reguilolaꞌadyiꞌyaquëꞌ bi hueyaquëꞌ ta gutiyaquëꞌ Jesús. Pero bireyaz̃oyaquëꞌ, danꞌ rdzebiyaquëꞌ idzaꞌ yaca benëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Naꞌ biz̃i tu benꞌ naca benꞌ quie Jesús lado ichiptu yaca benꞌ quie Jesús bëꞌnëꞌ lato uyuꞌu xanꞌ taxiꞌibiꞌ Satanás luꞌu laxtaꞌonëꞌ. Lëbenꞌ naꞌ laonëꞌ Judas Iscariote. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Naꞌ uyo Judas tzegueꞌlënëꞌ diꞌidzaꞌ yaca xanꞌ pxuzi, len yaca benꞌ napa dyin quie idaoꞌ rnabëꞌra ta yeguilolaꞌadyiꞌyaquëꞌ bi hueyaquëꞌ ta usedyinnëꞌ Jesús lao naꞌayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Leyaquëꞌ lega bedaohueyaquëꞌ begaꞌnlëyaquëꞌ lëbëꞌ diꞌidzaꞌ ta hueꞌyaquëꞌ lëbëꞌ dumi. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Naꞌ uzulaonëꞌ beguilolaꞌadyiꞌnëꞌ bi huenëꞌ ta usedyinnëꞌ Jesús lao naꞌayaquëꞌ cati nunu benꞌ nitaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bdyincazi dza bëyaquëꞌ lani pascua cati gaoyaquëꞌ yëta xtila ta binequixi levadura, lëscanꞌ gutirëyaquëꞌ becoꞌ z̃iꞌilaꞌ quie lani pascua. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Lenaꞌ una Jesús rëbinëꞌ chopa benꞌ quienëꞌ, Pedro len Juan: ―Uletzio ta ucuezale ta gaoro rtzeꞌ quie lani pascua. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Naꞌra unabayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¿Gaz̃i reꞌenloꞌ tziondoꞌ ta tzacuezandoꞌ ta gaoro? ");
INSERT INTO zpcNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Biz̃i naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Uletzio ciudad Jerusalén. Caora babdyinle ruꞌa ciudad, lëganꞌ naꞌ yedilale tu beꞌmbyu zeyuꞌa tu reꞌ yudzo nisa. Lëbenꞌ naꞌ inaole ganꞌ zeyonëꞌ yedyinnëꞌ z̃an yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Naꞌ tzuꞌule yëbile benꞌ naca xanꞌ yuꞌu: “Cani na Maestro: ¿Gaz̃i zu luꞌu yuꞌu ga gaolëndoꞌnëꞌ rtzeꞌ quie lani pascua?” ");
INSERT INTO zpcNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naꞌra uluꞌenëꞌ leꞌe tu luꞌu yuꞌu z̃e de chopa xcuia ga baneluban banacan dyaꞌa. Lëganꞌ naꞌ ucuezale ta gaoro. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Naꞌ uzaꞌyaquëꞌ zioyaquëꞌ gucan laga con canꞌ gudyi Jesús leyaquëꞌ. Lëganꞌnaꞌ pcuezayaquëꞌ ta gaoyaquëꞌ rtzeꞌ quie lani pascua. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cati bdyin hora gaoyaquëꞌ quie rtzeꞌ, naꞌ uzaꞌ Jesús ziolënëꞌ yaca benꞌ quienëꞌ uyuꞌuyaquëꞌ luꞌu yuꞌu ureꞌyaquëꞌ lao mesa. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Lega bareꞌendaꞌ gaoliaꞌ leꞌe rtzeꞌ quie lani pascua tu zagatiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Rniaꞌ leꞌe, bira gaoliaꞌ leꞌe rtzeꞌ quie lani pascua. Caora babzu diꞌidzaꞌ ca una Diuzi arnabëꞌnëꞌ lao yedyi layu, canaꞌtera gaoliaꞌ leꞌe rtzeꞌ quie lani pascua tatula. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Naꞌra uz̃iꞌnëꞌ tu copa, bazënëꞌn lao nëꞌë, unëꞌ rëbinëꞌ Diuzi: ―Diuxcaleloꞌ. Ude naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Uleguxun tu tule, uleyoꞌon. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Rniaꞌ leꞌe, bira yoꞌogaꞌ nisa quie bedzuliꞌ. Caora babdyin dza arnabëꞌ Diuzi lao yedyi layu, canaꞌtera yoꞌogaꞌ nisa bedzuliꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Naꞌ uz̃iꞌnëꞌ tu yëta xtila bazënëꞌn lao nëꞌë unëꞌ rëbinëꞌ Diuzi: ―Diuxcaleloꞌ. Ude naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Lëyëta xtila ni nacan ca quie cuerpo quiaꞌ. Huatiaꞌ cuenda gataꞌ yelaꞌ hueziꞌz̃e quiele lao Diuzi. Cabëꞌ aodaoro rtzeꞌ niga, canaꞌ huerële ta yezaꞌlaꞌadyiꞌle nëꞌëdiꞌ cabëꞌ biaꞌ quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Lëzirë, ude beyudyi udaoyaquëꞌ, beziꞌnëꞌ itu copa unëꞌ rëbinëꞌ leyaquëꞌ: ―Naca nisa bedzuliꞌ yudzu copa ni ca quie ren quiaꞌ. Lenaꞌ ilatogaꞌ gatiaꞌ cuenda yegaꞌntzaꞌolë Diuzi leꞌe tacubila. Lenaꞌ ilatogaꞌ cuenda gataꞌ yelaꞌ hueziꞌz̃e quiele lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Pero tu benꞌ reꞌ len nëꞌëdiꞌ lao mesa ni, lëbenꞌ naꞌ usedyinnëꞌ nëꞌëdiꞌ lao naꞌa benꞌ rudie nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nëꞌëdiꞌ, bichi yugulu benëꞌ, banugunnan gatiaꞌ. Pero bayëchiꞌ gula gaca quie benꞌ usedyin nëꞌëdiꞌ lao naꞌa benꞌ rudie nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Naꞌra unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Nuz̃i raꞌo usedyinronëꞌ lao naꞌa benꞌ rudie lëbëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Naꞌra yaca benꞌ quie Jesús uyuꞌuyaquëꞌ huenë len laguedyiyaquëꞌ ca nulayaquëꞌ gacara benꞌ belao entre leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Yaca benꞌ naca gobierno lao yedyi layu niga, lega dyiabëꞌyaquëꞌ hue yaca benëꞌ ca ta reꞌenyaquëꞌ. Naꞌ nayaquëꞌ nacayaquëꞌ benꞌ belao. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero naꞌ leꞌe bireyaꞌalaꞌ huele ca rueyaquëꞌ. Bireyaꞌalaꞌ hue cuinle benꞌ belao. Reyaꞌalaꞌ gacalële laguedyile. Reyaꞌalaꞌ ilëꞌële cuinle ca benꞌ criado. Chi huele canaꞌ, tali naꞌ nacale benꞌ belao ca reꞌen Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Quie lao benꞌ nitaꞌ lao yedyi layu niga, rbeꞌcazi xaꞌnyaquëꞌ lao mesa ta gaoyaquëꞌ ta rudyia criado quieyaquëꞌ. Pero nëꞌëdiꞌ, laꞌacazi nacaꞌ xaꞌnle, zuaꞌ ladole ruaꞌ ca quie criado quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Naꞌ como danꞌ bipsanlaꞌadyiꞌle nëꞌëdiꞌ dza cati guca zëdi gula quiaꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","quie lenaꞌ, gunaꞌ leꞌe lato cueꞌle gaole yoꞌole len nëꞌëdiꞌ lao mesa quiaꞌ ga yedyinaꞌ inabiꞌa. Lëscanꞌ gunaꞌ leꞌe lato cueꞌle ga gaca xlatole ichugolile quie lao chipchopa cueꞌ benꞌ Israel. Cabëꞌ bë Xuzaꞌ, pcaꞌnnëꞌ yelaꞌ rnabëꞌ quienëꞌ ta inabiꞌa, canaꞌ hueriaꞌ quiele, ucaꞌnaꞌ yelaꞌ rnabëꞌ quiaꞌ ta inabëꞌle. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Lëzi unërë Jesús: ―Simón, Simón, reꞌen xanꞌ taxiꞌibiꞌ Satanás huelën leꞌe prueba, chi usanlaꞌadyiꞌle nëꞌëdiꞌ, chi biusanlaꞌadyiꞌle nëꞌëdiꞌ. Reꞌennan usisin leꞌe ca rsisi benëꞌ bini trigo. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero bablidzaꞌ Diuzi ta gacalënëꞌ luëꞌ ta biusanlaꞌadyoꞌ nëꞌëdiꞌ. Naꞌra cati barenaoloꞌ xnezaꞌ tatula, naꞌ utipaloꞌ yaca benꞌ bichoꞌ, benꞌ nao xnezaꞌ, ta inaorayaquëꞌ mazara xnezaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Naꞌra una Simón rëbinëꞌ Jesús: ―Zucazaꞌ dispuesto tzaliaꞌ luëꞌ, baꞌalaꞌcazi udzeꞌyaquëꞌ raꞌo luꞌu dyiguiba, o chi gutiyaquëꞌ raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Pedro, rniaꞌ luëꞌ, bala tu binecuedyi biu, huanaoꞌ tzona lasa binubëꞌloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Cati useꞌelaꞌ leꞌe ga uyole dza naꞌ, bibiꞌale yëxo, bibiꞌale dumi, bibiꞌale itu cueꞌ guidi ta uliole, ¿bdzioguele bi ta bdzioguele? Naꞌ unayaquëꞌ rëbiyaquëꞌ Jesús: ―Bibi bdzioguendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Babetzaꞌ ca niaꞌ huele. Chi de yëxo quiele, reyaꞌalaꞌ huaꞌalen, lëzi huaꞌarële dumi. Chi bide macheta quiele, gutiꞌle gabán quiele ta gaꞌole macheta quiele huaꞌalen. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Lenaꞌ rniaꞌ leꞌe, decazide uzun diꞌidzaꞌ ganꞌ rnën quiaꞌ lëꞌë guichi laꞌiya quie Diuzi cani: “Hualëꞌëyaquëꞌ nëꞌëdiꞌ benꞌ mala.” Pues uzucazi yugulu diꞌidzaꞌ ganꞌ rnën quiaꞌ lëꞌë guichi laꞌiya. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Señor, decazi chopa macheta quiendoꞌ. Naꞌ bequëbi Jesús unëꞌ: ―Conlë lëcazin hueꞌennan. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Naꞌra ca rue Jesús yugu rdzeꞌ, uzaꞌnëꞌ zionëꞌ ganꞌ zu yaꞌa lao Olivos. Lëscanꞌ uzaꞌrë yaca benꞌ quienëꞌ ziolëyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bëꞌ bdyinyaquëꞌ ganꞌ, naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ―Ulidzale Diuzi cuenda yeziꞌle fuerza ta bihue xanꞌ taxiꞌibiꞌ leꞌe gan bihuele xquia ca tazëdi bazaꞌ gaca quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lëganꞌ naꞌ begaꞌn yaca benꞌ quienëꞌ udyialao Jesús ilëꞌëtiꞌ ca tu ga rdyin yo cati reruꞌunron. Naꞌ ureꞌnëꞌ uditzu z̃ibinëꞌ layu blidzëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Naꞌ unëꞌ rëbinëꞌ Diuzi: ―Xuzaꞌ Diuzi, inabaꞌ laoloꞌ ucuasa ucuiꞌoloꞌ nëꞌëdiꞌ ca tazëdi gula bazaꞌ gaca quiaꞌ. Nacan ca quie tu ta naca slaꞌ ruen zi yoꞌogaꞌn. Pero zuaꞌ dispuesto gaca quiaꞌ cabëꞌ reꞌenloꞌ luëꞌ, cala ca reꞌendaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Biz̃i naꞌ bdyinte tu ángel zaꞌ guibá ganꞌ zënëꞌ, gucalënëꞌ lëbëꞌ beziꞌnëꞌ fuerza. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Naꞌ tanto bedzagalaonëꞌ guquenëꞌ bayëchiꞌ gula, gucanëꞌ nisa yesa blaton layu nacan ca ren quienëꞌ tu rlidzëꞌ Diuzi du guicho du laꞌadyiꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Biz̃i bëꞌ beyudyi blidzëꞌ Diuzi, naꞌ bezulinëꞌ zeyoguëꞌ ganꞌ nitaꞌ yaca benꞌ quienëꞌ, blëꞌënëꞌ barasiyaquëꞌ, danꞌ banexaqueyaquëꞌ tanto rdëbiyaquëꞌ racayëchiꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Lenaꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Bixquienꞌ rasizile? Ulechasa ulelidza Diuzi cuenda yeziꞌle fuerza ta bihue xanꞌ taxiꞌibiꞌ leꞌe gan bihuele xquia ca tazëdi gula bazaꞌ gaca quiele. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nerna Jesús ruꞌelënëꞌ yaca benꞌ quiëꞌ diꞌidzaꞌ cati bdyin Judas ganꞌ zënëꞌ dyialaotenëꞌ lao yaca benꞌ ziolënëꞌ lëbëꞌ tuz̃e. Lëcanaꞌ ubigaꞌnëꞌ ganꞌ zë Jesús udaonëꞌ situ xaganëꞌ. Naca Judas tuz̃e len ichiptu yaca benꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Judas, con tu situ baodaoloꞌ xagaꞌ, ¿lenaꞌ babaoꞌ entregar nëꞌëdiꞌ, bichi yugulu benëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Naꞌ biz̃i cati blëꞌë yaca benꞌ quie Jesús bi raca quienëꞌ, naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Señor, ¿reꞌenloꞌ cuiondoꞌ macheta quiendoꞌ tilalëndoꞌ leyaquëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Biz̃i naꞌ ulio tu benꞌ quie Jesús macheta quienëꞌ, udinëꞌ benꞌ criado quie xanꞌ pxuzi, uchugunëꞌ naguëꞌ yebë. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Psan quieyaquëꞌ, canaꞌzi. Ude naꞌ bdaꞌ Jesús nëꞌë naga benꞌ naꞌ, labeyacaten. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Naꞌra una Jesús gudyinëꞌ yaca xanꞌ pxuzi, len yaca benꞌ napa dyin quie idaoꞌ rnabëꞌra, len yaca los demás benꞌ rnabëꞌ, benꞌ ziorë guxu lëbëꞌ: ―¿Cala benꞌ uban raquele nacaꞌ danꞌ nuꞌale macheta, nuꞌale yaga zaꞌle guxule nëꞌëdiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Cati uzuliaꞌ leꞌe luꞌu idaoꞌ rnabëꞌra yugu dza, nica beyaz̃ole guxule nëꞌëdiꞌ. Pero naꞌra abdyin hora quiele cati huelële nëꞌëdiꞌ ca ta rnan quiele leꞌe, benꞌ rda lao lato laochula. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Naꞌ bëxuyaquëꞌ lëbëꞌ uquiëꞌyaquëꞌ lëbëꞌ z̃an yuꞌu quie xanꞌ pxuzi. Naꞌ ziorë Pedro zituꞌla zenaonëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Cati bdyinyaquëꞌ naꞌ, ulëchiyaquëꞌ guiꞌ laliꞌa ganꞌ rbeꞌyaquëꞌ neyëchoyaquëꞌ ruꞌa guiꞌ ta yedzeꞌeyaquëꞌ. Naꞌ ureꞌrë Pedro ladoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Biz̃i tu nigula, biꞌ naca criada, bëꞌ blëꞌëbiꞌ Pedro reꞌnëꞌ ruꞌa guiꞌ, naꞌ begaꞌmbiꞌ rnaꞌbiꞌ lao Pedro. Beyudyi unaꞌbiꞌ lëbëꞌ dyëꞌëdi, naꞌ unëbiꞌ rëbibiꞌ lëbëꞌ: ―Lëzi benꞌ reꞌ niga, naquëꞌ benꞌ quie benꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Naꞌ una Pedro rëbinëꞌ lëbiꞌ: ―Nigula, binubëꞌdaꞌ benꞌ naoꞌ canꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bëꞌ guca itu chiꞌ, blëꞌë benꞌ tula Pedro ganꞌ reꞌnëꞌ. Naꞌ una benꞌ naꞌ rëbinëꞌ lëbëꞌ: ―Lëzi luëꞌ nacaraoꞌ benꞌ quieyaquëꞌ. Pero naꞌ una Pedro rëbinëꞌ lëbëꞌ: ―Binacaꞌ benꞌ quieyaquëꞌ. Binubëꞌdaꞌ benꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Biz̃i bëꞌ guca ca itu hora, naꞌ unë itu benꞌ nitaꞌ naꞌ rëbinëꞌ Pedro: ―Tali naca benꞌ ni benꞌ quie benꞌ naꞌ, como danꞌ nacarëꞌ benꞌ estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Naꞌra una Pedro rëbinëꞌ benꞌ una canaꞌ: ―Binezdaꞌ quie benꞌ rnaoꞌ, binubëꞌdaꞌ benꞌ naꞌ. Lëcanaꞌ, caora nernë Pedro canaꞌ, naꞌ uredyi biu. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Naꞌ beyëcho Jesús unaꞌnëꞌ lao Pedro. Caora naꞌ bezaꞌlaꞌadyiꞌ Pedro con ca una Jesús gudyinëꞌ lëbëꞌ: “Bala tu binecuedyi biu, huanaoꞌ tzona lasa binubëꞌloꞌ nëꞌëdiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Naꞌra ubigaꞌ Pedro tzalaꞌla zionëꞌ ga uredyinëꞌ ziꞌlaza gula. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Naꞌ yaca benꞌ napa Jesús, ptituyaquëꞌ lëbëꞌ, udyibiyaquëꞌ lëbëꞌ begorro. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Lëscanꞌ pquioyaquëꞌ laꞌariꞌ laohuëꞌ, udyibiyaquëꞌ laohuëꞌ, unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Unacara nu udyibi luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Lëscanꞌ lega diꞌidzaꞌ ziꞌ unëyaquëꞌ gudyiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Biz̃i bëꞌ uyaniꞌ dza tula, bedupa yaca benꞌ napa dyin, len yaca xanꞌ pxuzi, len yaca benꞌ rusëdi ley quie Moisés, uquiëꞌyaquëꞌ Jesús ziolëyaquëꞌ lëbëꞌ ganꞌ reꞌ yaca benꞌ napa dyin. Naꞌ unabayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Unacara nëtoꞌ ¿nacoꞌ benꞌ na Diuzi iseꞌelëꞌ? Naꞌra bequëbi Jesús rëbinëꞌ leyaquëꞌ: ―Chanꞌ iniaꞌ leꞌe nacaꞌ benꞌ na Diuzi iseꞌelëꞌ, nica galele quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Lëzi chi inabaꞌ leꞌe tu diꞌidzaꞌ, nica yequëbile quiaꞌ, nica usanle nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero bazaꞌ dza huatzeriꞌa nëꞌëdiꞌ, bichi yugulu benëꞌ, zaquëꞌ yebë cuëta Diuzi, benꞌ dera yelaꞌ rnabëꞌ quie. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Biz̃i lao yuguluteyaquëꞌ unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¿Nacoꞌ z̃iꞌi Diuzi? Naꞌ bequëbi Jesús rëbinëꞌ leyaquëꞌ: ―Sí, nacaꞌ z̃iꞌi Diuzi con canꞌ nale. ");
INSERT INTO zpcNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Naꞌra unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Ca nura testigo reꞌennan guida? Cuincaziro babero cabëꞌ baona benꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Naꞌra yugulu yaca benꞌ reꞌ ganꞌ, uzuliyaquëꞌ uquiëꞌyaquëꞌ Jesús tzahuaꞌayaquëꞌ lëbëꞌ lao Pilato, benꞌ naca gobernador. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Lëganꞌ naꞌ udaoyaquëꞌ lëbëꞌ xquia, unayaquëꞌ rëbiyaquëꞌ Pilato: ―Benꞌ niga rudzeꞌyelanëꞌ yaca benꞌ yedyi quiendoꞌ rëbinëꞌ leyaquëꞌ bireyaꞌalaꞌ quiz̃oro impuesto quie gobierno romano. Lëzi nanëꞌ naquëꞌ benꞌ useꞌelaꞌ Diuzi, naꞌ nanëꞌ naquëꞌ rey quiendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Naꞌra unaba Pilato Jesús rëbinëꞌ lëbëꞌ: ―¿Tabala nacoꞌ rey quie benꞌ Israel? Naꞌ bequëbi Jesús rëbinëꞌ Pilato: ―Nacaꞌ cabëꞌ unaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Naꞌra una Pilato rëbinëꞌ yaca xanꞌ pxuzi, len yaca los demás benꞌ nitaꞌ naꞌ: ―Gabi dulaꞌ de quie benꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Naꞌ biz̃i leyaquëꞌ unërayaquëꞌ zidzo gula rëbiyaquëꞌ Pilato: ―Con ga baodenëꞌ rudzeꞌyelanëꞌ yaca benëꞌ. Pues barudzeꞌyelanëꞌ yaca benꞌ quie yaca yedyi quie estado Judea len yaca benꞌ quie yaca yedyi quie estado Galilea. Naꞌ bablaꞌnëꞌ niga ta udzeꞌyelanëꞌ yaca benꞌ lao ciudad niga. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bëꞌ be Pilato canꞌ unayaquëꞌ quie Jesús, naꞌ unabanëꞌ leyaquëꞌ chi tali naca Jesús benꞌ quie estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Naꞌ caora bequëbiyaquëꞌ tali naquëꞌ benꞌ quie estado Galilea, naꞌ useꞌelaꞌnëꞌ Jesús lao Herodes, danꞌ naca Herodes gobernador quie estado Galilea, lëscanꞌ danꞌ bazurë Herodes ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Biz̃i bëꞌ blëꞌë Herodes bdyin Jesús ganꞌ zunëꞌ, lega redaohuenëꞌ como danꞌ azio zë dza reꞌennëꞌ ilëꞌënëꞌ lëbëꞌ. Babenëꞌ canꞌ na yaca benëꞌ canꞌ ruenëꞌ. Lenaꞌ reꞌennëꞌ ilëꞌënëꞌ lëbëꞌ chi bihuenëꞌ tu milagro. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Naꞌ uzulaonëꞌ rnabanëꞌ Jesús zë pregunta, pero bibequëbi Jesús quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Lëganꞌ naꞌ bdyinrë yaca xanꞌ pxuzi, len yaca benꞌ rusëdi ley quie Moisés, udaoyaquëꞌ lëbëꞌ xquia. Diꞌidzaꞌ zëra bëyaquëꞌ condre Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Biz̃i Herodes len yaca soldado quienëꞌ uzulaoyaquëꞌ rueyaquëꞌ lëbëꞌ bizinaquezi. Bgacoyaquëꞌ lëbëꞌ tu laꞌariꞌ tzaoꞌ ca quie laꞌariꞌ raco rey ta utituyaquëꞌ lëbëꞌ. Ude naꞌ beseꞌelaꞌyaquëꞌ lëbëꞌ tatula lao Pilato. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Du dza naꞌla, Herodes len Pilato, biyuꞌuyaquëꞌ dyaꞌa bigucayaquëꞌ amigo, pero caora naꞌ beyacayaquëꞌ amigo. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Naꞌ bë Pilato mandado bedupa yaca xanꞌ pxuzi, len yaca benꞌ napa dyin, len yaca benꞌ lao yedyi. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Naꞌra una Pilato rëbinëꞌ leyaquëꞌ: ―Leꞌe badehuaꞌale benꞌ niga ni, nale rudzeꞌyelanëꞌ yaca benëꞌ, pero bapquëpaꞌ lëbëꞌ zaquëꞌ lao leꞌe, naꞌ leꞌe bablëꞌële bibi dulaꞌ de quienëꞌ con ca inale raole lëbëꞌ xquia. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Lëscanꞌ Herodes pquëpinëꞌ lëbëꞌ bibi falta de quienëꞌ beseꞌelaꞌnëꞌ lëbëꞌ niga. Bablëꞌële bibi dulaꞌ de quienëꞌ cuenda huaꞌ mandado guti yaca soldado lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Quie lenaꞌ huaꞌ mandado qui yaca soldado lëbëꞌ guidi, naꞌtera usanaꞌnëꞌ. ―Canaꞌ una Pilato rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Naꞌ biz̃i bëꞌ gaꞌalaꞌ lani, de yebio Pilato tu benꞌ naca preso luꞌu dyiguiba con ca gueꞌen yaca benëꞌ. Canaꞌ naca costumbre quieyaquëꞌ yebioyaquëꞌ tu benꞌ naca preso dza lani pascua. Biz̃i Pilato guꞌunnëꞌ usannëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero yaca benꞌ nitaꞌ naꞌ uzulaoyaquëꞌ uredyiyaꞌyaquëꞌ unëyaquëꞌ zidzo: ―¡Biusanloꞌ benꞌ naꞌ! ¡Yebioloꞌ Barrabás! ");
INSERT INTO zpcNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Biz̃i benꞌ lao Barrabás yuꞌunëꞌ luꞌu dyiguiba, danꞌ udilalënëꞌ yaca benꞌ rnabëꞌ quie lao yedyi, lëzi bëtinëꞌ benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Naꞌ como guꞌun Pilato usannëꞌ Jesús, bëꞌlënëꞌ yaca benꞌ nitaꞌ naꞌ mazara diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero uredyiyaꞌyaquëꞌ zidzo unayaquëꞌ: ―¡Udaꞌloꞌnëꞌ lëꞌë yaga cruzo! ¡Udaꞌloꞌnëꞌ lëꞌë yaga cruzo! ");
INSERT INTO zpcNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Naꞌra tabeyuna lasa una Pilato rëbinëꞌ leyaquëꞌ: ―¿Biz̃i tamala babënëꞌ? Bibi dulaꞌ de quienëꞌ cuenda huaꞌ mandado guti yaca soldado lëbëꞌ. Quie lenaꞌ huaꞌ mandado qui yaca soldado lëbëꞌ guidi, naꞌtera usanaꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero naꞌ unëra yaca benëꞌ zidzora uredyiyaꞌyaquëꞌ rëbiyaquëꞌ Pilato ta huenëꞌ mandado udaꞌyaquëꞌ Jesús lëꞌë yaga cruzo. Tanto uredyiyaꞌ yaca benꞌ nitaꞌ naꞌ len yaca xanꞌ pxuzi, bëyaquëꞌ gan gucan cabëꞌ guꞌunyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Canaꞌ guca bë Pilato mandado cabëꞌ unabayaquëꞌ huenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Canaꞌ guca ulio Pilato con benꞌ guꞌunyaquëꞌ yero luꞌu dyiguiba, benꞌ guca dilalë benꞌ napa dyin, benꞌ bëti benëꞌ. Canaꞌ guca psedyin Pilato Jesús lao naꞌa yaca benꞌ hue bizinaquezi conlë lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Caora bëꞌ nequiëꞌyaquëꞌ Jesús ta udaꞌyaquëꞌ lëbëꞌ lëꞌë yaga cruzo, naꞌ bëxoyaquëꞌ tu benꞌ lao Simón, benꞌ yedyi Cirene, benꞌ zezaꞌ layela. Naꞌ bëyaquëꞌ mandado biꞌanëꞌ yaga cruzo zionëꞌ nuꞌanëꞌn zioguëꞌ zenaohuëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Naꞌ yaca benꞌ zë gula zioyaquëꞌ zenaoyaquëꞌ leyaquëꞌ. Lëscanꞌ zenao nigula zë zioyaquëꞌ rbedyiyaꞌyaquëꞌ raqueyaquëꞌ beyëchiꞌ, danꞌ rusacayaquëꞌ Jesús bizinaquezi. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Naꞌ biz̃i Jesús beyëchiꞌnëꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Leꞌe nigula ciudad Jerusalén, bicuedyile por nëꞌëdiꞌ. Yelaꞌcala cuedyile por leꞌe len z̃iꞌile. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porque bazaꞌ dza gaca bayëchiꞌ gula quiele. Naꞌ tanto gaca bayëchiꞌ quiele, bisule gusto chi zu z̃iꞌile, bisule gusto chi nuꞌale bdaoꞌ, bisule gusto chi rugaꞌadyile xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lëdza naꞌ tanto idzebile bi gaca quiele, hueguilole ga ucachiꞌlaole ga naca lëꞌë yaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Niaꞌ leꞌe chi ruelëyaquëꞌ yaga yaꞌa bizinaquezi, ¿biz̃ira huelëyaquëꞌ yaga bidyi? ");
INSERT INTO zpcNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Lëzi nequiëꞌrëyaquëꞌ chopa yaca benꞌ bë tamala ta gutiyaquëꞌ leyaquëꞌ tzaz̃e len Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Naꞌ cati bdyinyaquëꞌ ga laona chita guicho benꞌ huati, lëganꞌ naꞌ bdaꞌyaquëꞌ lëbëꞌ lëꞌë yaga cruzo. Lëzirë bdaꞌrëyaquëꞌ chopa yaca benꞌ bë tamala. Tunëꞌ bdaꞌyaquëꞌ zaquëꞌ yebë, naꞌ itunëꞌ bdaꞌyaquëꞌ zaquëꞌ yegaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Cati barudaꞌyaquëꞌ Jesús lëꞌë yaga cruzo unëꞌ rëbinëꞌ Diuzi: ―Xuzaꞌ Diuzi, beziꞌz̃e quieyaquëꞌ, danꞌ bineziyaquëꞌ bi rueyaquëꞌ. Ude beyudyi naꞌ, bë yaca soldado tu sorteo entre leyaquëꞌ ca nulayaquëꞌ gaca quie z̃aba Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Biz̃i yaca benꞌ nitaꞌ naꞌ, begaꞌnyaquëꞌ rnaꞌyaquëꞌ lëbëꞌ. Naꞌ lente yaca benꞌ napa dyin rutituyaquëꞌ lëbëꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Gucalënëꞌ benꞌ tula, gacalëgaranëꞌ cuinnëꞌ chi tali naquëꞌ benꞌ Cristo, benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Lëscanꞌ ptiturë yaca soldado lëbëꞌ. Bebigaꞌyaquëꞌ ganꞌ dëꞌë, rziꞌyaquëꞌ vino naca slaꞌ ruyoꞌoyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Chi tali nacoꞌ rey quie benꞌ Israel, pte psela cuinloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Lëꞌë yaga cruzo zaquëꞌ ga zu guichoguëꞌ, bdaꞌyaquëꞌ tu yaga taꞌa dyian letra griego, len letra latín, len letra hebreo. Lëꞌë yaga taꞌa rnan cani: “Benꞌ ni naquëꞌ rey quie yaca benꞌ Israel.” ");
INSERT INTO zpcNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Biz̃i tu benꞌ bë tamala, benꞌ daꞌrë cuëta lëꞌënëꞌ lëꞌë yaga cruzo, ptiturënëꞌ Jesús rëbinëꞌ lëbëꞌ: ―Chi tali nacoꞌ benꞌ Cristo, pte psela cuinloꞌ len nëtoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero benꞌ itu laguedyinëꞌ udilanëꞌ lëbëꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―¿Nica rdzeboꞌ Diuzi hora cati gatioꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ca naca raꞌo de dulaꞌ xquia quiero, naꞌa redzagalaoro barguiz̃oro ca naca tamala bëro. Ta reyaꞌalaꞌcazi gataꞌ castigo quiero, pero benꞌ niga redzagalaonëꞌ, denꞌ bibi tamala de bënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Naꞌra unëꞌ gudyinëꞌ Jesús: ―Jesús, cati bazuloꞌ ganꞌ inabëꞌloꞌ, yezaꞌlaꞌadyoꞌ quiaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Tali rniaꞌ luëꞌ, naꞌa dza bazuloꞌ len nëꞌëdiꞌ guibá ganꞌ zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Biz̃i cati baruen cadu gatzo dza, bechula lao duz̃e ciudad naꞌ hasta reda tzona quie sadzeꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bechula lao ubidza. Caora naꞌ breꞌeza laꞌariꞌ zë gatzo laoꞌ idaoꞌ rnabëꞌra gucan chopa laꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Naꞌra uredyiyaꞌ Jesús unëꞌ rëbinëꞌ Diuzi: ―Xuzaꞌ Diuzi, rucaꞌnaꞌ bichi be quiaꞌ lao naꞌaloꞌ. Ude beyudyi unëꞌ canaꞌ, gutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Biz̃i benꞌ naca capitán quie yaca soldado romano, cati bablëꞌënëꞌ canꞌ guca quie Jesús, bënëꞌ Diuzi benꞌ z̃e unëꞌ: ―Tali benꞌ niga naquëꞌ benꞌ huen, bibi tamala bënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Naꞌ biz̃i yaca benꞌ bida blëꞌë yaca canꞌ guca quie Jesús, zeyoyaquëꞌ z̃an yuꞌu rbibiyaquëꞌ ruꞌachuꞌuyaquëꞌ, danꞌ raqueyaquëꞌ beyëchiꞌ cabëꞌ bëyaquëꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero yaca benꞌ unao Jesús, lenrë yaca nigula unao lëbëꞌ desde dza uzaꞌnëꞌ estado Galilea, begaꞌnyaquëꞌ nitaꞌyaquëꞌ zituꞌla rnaꞌyaquëꞌ canꞌ guca quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Lëganꞌ naꞌ uzurë tu benꞌ dyaꞌa, benꞌ rue quie xtiꞌidzaꞌ Diuzi laonëꞌ José. Naquëꞌ benꞌ yedyi lao Arimatea quie estado Judea. Napëꞌ dyin, naquëꞌ benꞌ rnabëꞌ quie yaca benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Lëbenꞌ lao José rbezëꞌ dza guida benꞌ iseꞌelaꞌ Diuzi ta inabëꞌnëꞌ lao yedyi layu. Bibënëꞌ tuzi cabëꞌ bë yaca los demás benꞌ naparë dyin. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Naꞌra uyonëꞌ yenabanëꞌ lao Pilato chi bihueꞌnëꞌ lato ta yechisanëꞌ cuerpo quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Naꞌ ude bechisanëꞌ cuerpo quie Jesús lëꞌë yaga cruzo, betubinëꞌ lëbëꞌ laꞌariꞌ, bdzeꞌnëꞌ lëbëꞌ tu luꞌu yero beló yo ta zapquiꞌinyaquëꞌ, nitu nunu nedzeꞌyaquëꞌ ganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lëdza naꞌ nacan dza vierna cati rucuezayaquëꞌ ta gaoyaquëꞌ quie dza huezilaꞌadyiꞌ. Baodzeꞌ bagazi sulao dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Naꞌ yaca nigula unao Jesús desde dza uzaꞌnëꞌ estado Galilea, uyoyaquëꞌ yenaꞌyaquëꞌ ganꞌ bdzeꞌyaquëꞌ cuerpo quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ude beyudyi naꞌ, bezaꞌyaquëꞌ zeyoyaquëꞌ z̃an yuꞌu quieyaquëꞌ bapcuezayaquëꞌ aceite rlaꞌ z̃ixi z̃eo len güento ta ilëpiyaquëꞌ cuerpo quie Jesús. Ude beyudyi bëyaquëꞌ canꞌ, bezilaꞌadyiꞌyaquëꞌ según ca rnan lëꞌë guichi laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Naꞌ bala bazaꞌ reniꞌ dza domingo, zio yaca nigula ganꞌ de yero beló yo ganꞌ pcachiꞌyaquëꞌ Jesús. Nuꞌayaquëꞌ aceite rlaꞌ z̃ixi z̃eo ta pcuezayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Biz̃i bëꞌ bdyinyaquëꞌ ganꞌ, rnaꞌyaquëꞌ baneyalo ruꞌa yero beló yo. Bira daꞌ yo lagaꞌ ruꞌa yero ganꞌ bdaꞌyaquëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Naꞌra uyuꞌuyaquëꞌ yero beló yo rnaꞌyaquëꞌ bira de cuerpo quie Señor Jesús ganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lega begaꞌnyaquëꞌ bdzebiyaquëꞌ. Bira biubinyaquëꞌ bi hueyaquëꞌ. Caora naꞌ blëꞌëyaquëꞌ bazë chopa beꞌmbyu zaquëꞌ laoyaquëꞌ nacoyaquëꞌ laꞌariꞌ bezëri di ta raca titiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Naꞌ biz̃i bezëtaꞌ laoyaquëꞌ layu, lega bdzebiyaquëꞌ. Naꞌ una yaca beꞌmbyu rëbiyaquëꞌ leyaquëꞌ: ―¿Bixquienꞌ rdale reguilole tu benꞌ naban ganꞌ rucachiꞌyaquëꞌ benꞌ huati? ");
INSERT INTO zpcNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Bira denëꞌ niga. Babebannëꞌ zunëꞌ tatula. Ulezaꞌlaꞌadyiꞌ canꞌ unëꞌ leꞌe cati nezulënëꞌ leꞌe estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Lëdza naꞌ unëꞌ gudyinëꞌ leꞌe decazide usedyin yaca benëꞌ lëbëꞌ lao naꞌa yaca benꞌ rnabëꞌ, naꞌ udaꞌyaquëꞌ lëbëꞌ lëꞌë yaga cruzo, pero bëꞌ gaca lao tzona dza, huebannëꞌ tatula lëbëꞌ, benꞌ bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Lëcanaꞌ bezaꞌlaꞌadyiꞌyaquëꞌ ca una Jesús gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ude beyudyi naꞌ, beroyaquëꞌ luꞌu yero beló yo bezaꞌyaquëꞌ zioyaquëꞌ udixogueꞌyaquëꞌ lao chiptu yaca benꞌ quie Jesús, len yaca los demás benꞌ nao xneza Jesús canꞌ guca quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Naꞌ lëyaca nigula, benꞌ uyo yetixogueꞌ yaca benꞌ quie Jesús, tuëꞌ laohuëꞌ María Magdalena, ituëꞌ laohuëꞌ Juana, ituëꞌ laohuëꞌ María, naquëꞌ z̃naꞌ Santiago. Lëscanꞌ uyorë yaca nigula naca laguedyiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Naꞌ biz̃i yaca benꞌ quie Jesús guqueyaquëꞌ calëla canꞌ gudyi yaca nigula leyaquëꞌ. Biguleyaquëꞌ quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Denꞌ uyocazi Pedro uyuꞌunëꞌ be zionëꞌ taria ganꞌ de yero beló yo. Naꞌ bëꞌ unaꞌnëꞌ luꞌu yero beló yo, blëꞌënëꞌ laꞌariꞌ ta ptubiyaquëꞌ cuerpo quie Jesús, begaꞌnnan reꞌnan cuinzin. Naꞌra tu bebanzinëꞌ canꞌ blëꞌënëꞌ bezaꞌnëꞌ zeyoguëꞌ z̃an yuꞌu quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lëdza naꞌatezi, bezaꞌ chopa yaca benꞌ unao xneza Jesús ciudad Jerusalén, zeyoyaquëꞌ yedyi quieyaquëꞌ laona Emaús. Naꞌ ciudad Jerusalén para yedyi quieyaquëꞌ nacan tzona legua. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Zioyaquëꞌ ruꞌeyaquëꞌ diꞌidzaꞌ ca bë yaca benꞌ ciudad Jerusalén psacayaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Biz̃i tu rzaꞌyaquëꞌ zioyaquëꞌ ruꞌeyaquëꞌ diꞌidzaꞌ, cati ubigaꞌ cuin Jesús cuëta leyaquëꞌ baziolënëꞌ leyaquëꞌ tzaz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero baꞌalaꞌcazi blëꞌëyaquëꞌ lëbëꞌ, bibezaqueyaquëꞌ chi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―¿Biz̃i guca rnële yuꞌule neza? ¿Bixquienꞌ raqueyëchiꞌle? ");
INSERT INTO zpcNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Naꞌ tu benꞌ ziolë laguedyi laonëꞌ Cleofas unënëꞌ rëbinëꞌ Jesús: ―Banezi yugulu benëꞌ canꞌ guca ciudad Jerusalén nionasigazi. ¿Cala zuraoꞌ luëꞌ ciudad Jerusalén, naꞌ biunezoꞌ binꞌ guca? ");
INSERT INTO zpcNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Naꞌra unaba Jesús leyaquëꞌ: ―¿Cabiz̃i guca ganꞌ? Naꞌ unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Guca tu tamala gula quie tu benꞌ lao Jesús, benꞌ yedyi Nazaret. Guquëꞌ benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi. Bënëꞌ yelaꞌ huaca, psëdinëꞌ yaca benëꞌ diꞌidzaꞌ dyaꞌa. Yaxe Diuzi len yaca benëꞌ canꞌ bënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero yaca xanꞌ pxuzi, len yaca los demás benꞌ napa dyin quiero, psedyinyaquëꞌ lëbëꞌ lao naꞌa benꞌ bdaꞌ lëbëꞌ lëꞌë yaga cruzo bëtiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pero nëtoꞌ guquendoꞌ naquëꞌ benꞌ useꞌelaꞌ Diuzi ta ute uselanëꞌ raꞌo benꞌ Israel cuenda bira inabëꞌ yaca benꞌ naca gobierno romano raꞌo. Naꞌ biz̃i azio lao tzona dza bëtiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero naꞌa zila, bala yaca nigula nacalëndoꞌ tuzi unaondoꞌ lëbëꞌ, uyoyaquëꞌ luꞌu beló yo ganꞌ pcachiꞌyaquëꞌ lëbëꞌ. Naꞌ begaꞌnndoꞌ rebanendoꞌ ca gudyiyaquëꞌ nëtoꞌ blëꞌëyaquëꞌ ganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Belaꞌyaquëꞌ udixogueꞌyaquëꞌ nëtoꞌ bide cuerpo quienëꞌ luꞌu yero beló yo ganꞌ pcachiꞌyaquëꞌ lëbëꞌ. Unayaquëꞌ blëꞌëyaquëꞌ chopa benꞌ naca ángel, benꞌ una babeban Jesús zunëꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Lëzirë ibala beꞌmbyu laguedyindoꞌ, benꞌ unao lëbëꞌ, uyoyaquëꞌ uyuꞌuyaquëꞌ luꞌu yero beló yo, naꞌ blëꞌëyaquëꞌ nacan tali canꞌ una yaca nigula, pero naꞌ biblëꞌëyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Taz̃e nerdzioguele tzioñeꞌele cabëꞌ na xtiꞌidzaꞌ Diuzi. Lega ruen zëdi quiele galele yugulu cabëꞌ una yaca benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi dza naꞌla. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Biz̃i binezile rnan lëꞌë guichi laꞌiya quie Diuzi yedzagalao benꞌ iseꞌelaꞌ Diuzi gatinëꞌ, te naꞌ yebannëꞌ tatula hue Diuzi lëbëꞌ benꞌ z̃era? ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Naꞌra uzulaonëꞌ ruxiꞌidzeꞌnëꞌ leyaquëꞌ ca na diꞌidzaꞌ laꞌiya quie Diuzi ganꞌ rguixogueꞌn quie benꞌ iseꞌelaꞌ Diuzi. Conlë diꞌidzaꞌ bzu Moisés lëꞌë guichi uzulaonëꞌ ruxiꞌidzeꞌnëꞌ leyaquëꞌ, bzalaorëꞌ unarëꞌ mazara hasta ganꞌ bzu yaca profeta diꞌidzaꞌ lëꞌë guichi. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bëꞌ bdyinyaquëꞌ yedyi ganꞌ zioyaquëꞌ, labëtenëꞌ badyinzi ta sëꞌë tzuꞌunëꞌ neza tatula. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero leyaquëꞌ bdyiabëꞌyaquëꞌ quienëꞌ ta yegaꞌnnëꞌ len leyaquëꞌ. Lenaꞌ unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Begaꞌnlë nëtoꞌ niga. Bazaꞌ rchula bahuen rtzeꞌ. Naꞌra begaꞌnnëꞌ len leyaquëꞌ ganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Caora baoreꞌlënëꞌ leyaquëꞌ lao mesa ta gaoyaquëꞌ rtzeꞌ, naꞌ uz̃iꞌnëꞌ tu yëta xtila unëꞌ rëbinëꞌ Diuzi diuxcaleloꞌ. Beyudyi naꞌ, bz̃oz̃oguëꞌn bëꞌnëꞌn leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lëcanaꞌ beyeniꞌ laoyaquëꞌ bezaqueyaquëꞌ lëbëꞌ. Naꞌ biz̃i lëbëꞌ tu beyulazinëꞌ, bira blëꞌëyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Naꞌra unayaquëꞌ bëꞌyaquëꞌ diꞌidzaꞌ lao rupayaquëꞌ unëyaquëꞌ: ―¿Cala tali naꞌ bedaohue guicho laxtaꞌoro caora zaꞌlënëꞌ raꞌo tu neza ruxiꞌidzeꞌnëꞌ raꞌo quie diꞌidzaꞌ zu lëꞌë guichi laꞌiya quie Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Naꞌra labeyuꞌuteyaquëꞌ neza tatula, zioyaquëꞌ ciudad Jerusalén ganꞌ yetilayaquëꞌ nitaꞌ yaca chiptu benꞌ quie Jesús, len yaca los demás benꞌ unao lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Naꞌ una yaca benꞌ bguꞌudiꞌ ganꞌ, rëbiyaquëꞌ benꞌ zabdyin: ―Nacan tali babeban Señor quiero. Bablëꞌë Simón lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Naꞌ unayaquëꞌ rëbiyaquëꞌ leyaquëꞌ canꞌ guca quieyaquëꞌ tu neza bëꞌlëyaquëꞌ Jesús diꞌidzaꞌ, pero bibezaqueyaquëꞌ chi lëbëꞌ hasta bz̃oz̃onëꞌ yëta xtila bëꞌnëꞌn leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Biz̃i nenitaꞌteyaquëꞌ neruꞌeyaquëꞌ diꞌidzaꞌ cati bdyin Jesús yësazi bazënëꞌ ladoyaquëꞌ blidzanëꞌ leyaquëꞌunëꞌ: ―Cueꞌ chizi laxtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero lega bdzebiyaquëꞌ guqueyaquëꞌ blëꞌëyaquëꞌ ludzaꞌ benꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lenaꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―¿Bixquienꞌ rdzebile? ¿Bixquienꞌ raquele cala nëꞌëdiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ulenaꞌcara naꞌa len niꞌa, nëꞌëdiꞌcazi. Neyaꞌa nëꞌëdiꞌ nacaꞌ benëꞌ, binacaꞌ ludzaꞌ benꞌ huati. Tu ludzaꞌ benꞌ huati binacan bëꞌëlaꞌ, biyuꞌun chita canꞌ rlëꞌële nacaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tu ruꞌelënëꞌ leyaquëꞌ diꞌidzaꞌ, bluꞌenëꞌ leyaquëꞌ nëꞌë len niꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero como danꞌ binegaleyaquëꞌ chi lëbëꞌ, begaꞌnyaquëꞌ rebaneyaquëꞌ redaohueyaquëꞌ, unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Bide lëꞌëtiꞌ quiele gunle lëꞌëtiꞌ gaohuaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Naꞌra bëꞌyaquëꞌ lëbëꞌ tu naga bela banegüechi len tu yëta quie bezo yudzu bdyinꞌdaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Naꞌra uz̃iꞌnëꞌn udaonëꞌn zaquëꞌlao leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Baguca quiaꞌ cabëꞌ canꞌ baoniaꞌ leꞌe gaca quiaꞌ dza naꞌla, dza cati nezuliaꞌ leꞌe. Agudyaꞌ leꞌe decazide uzun yugulu diꞌidzaꞌ canꞌ rnan quiaꞌ nëꞌëdiꞌ lëꞌë guichi bë Moisés, len guichi bë yaca profeta, len guichi Salmos. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Naꞌra pxiꞌidzeꞌnëꞌ leyaquëꞌ canꞌ na lëꞌë guichi laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Lenaꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Cani rnën lëꞌë guichi laꞌiya quie Diuzi. Rnan decazide gati benꞌ iseꞌelaꞌ Diuzi lao yedyi layu. Te beyudyi naꞌ, yebannëꞌ tatula gaca lao tzona dza. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Lëscanꞌ rnan lëꞌë guichi laꞌiya quie Diuzi ruen dyiabëꞌ tzio yaca benꞌ quienëꞌ tzetixogueꞌyaquëꞌ yaca benꞌ nitaꞌ lao duz̃e yedyi layu de que reyaꞌalaꞌ yetzaꞌyaquëꞌ pensari quieyaquëꞌ inaoyaquëꞌ nëꞌëdiꞌ cuenda yeziꞌz̃e Diuzi dulaꞌ xquia quieyaquëꞌ. Ciudad Jerusalén reyaꞌalaꞌ sulaoyaquëꞌ quixogueꞌyaquëꞌ, naꞌtera tzioyaquëꞌ yedyi tula. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Leꞌe nacale testigo quiaꞌ blëꞌële baguca quiaꞌ canꞌ rnan lëꞌë guichi laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Naꞌ iseꞌelaꞌ Bichi Be quie Diuzi ta tzuꞌunëꞌ luꞌu guicho laxtaꞌole canꞌ una Xuzaꞌ huenëꞌ quiele. Quie lenaꞌ cuezale niga ciudad Jerusalén hasta que chezi Bichi Be quie Diuzi tzuꞌunëꞌ luꞌu guicho laxtaꞌole cuenda gataꞌ yelaꞌ huaca quiele. ―Canaꞌ una Jesús gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Biz̃i naꞌ uquiëꞌ Jesús leyaquëꞌ broyaquëꞌ lao ciudad Jerusalén uzaꞌyaquëꞌ bdyinyaquëꞌ yedyi Betania. Ude beyudyi naꞌ, uchisanëꞌ nëꞌë bëlaꞌiyanëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bëꞌ beyudyi bëlaꞌiyanëꞌ leyaquëꞌ, naꞌ beyëpinëꞌ ladza yeyonëꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Naꞌ uyonlaꞌadyiꞌyaquëꞌ lëbëꞌ ganꞌ. Ude beyudyi naꞌ, bezaꞌyaquëꞌ zeyoyaquëꞌ ciudad Jerusalén tatula. Naꞌ lega redaohueyaquëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","riocaziyaquëꞌ yugu dza luꞌu idaoꞌ rnabëꞌra rulidzayaquëꞌ rueyaquëꞌ Diuzi benꞌ z̃e. Amén.");
INSERT INTO zpcNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Caora binecueꞌ lao yedyi layu, bazucazi tu benꞌ naca xtiꞌidzaꞌ Diuzi. Lëbenꞌ naꞌ zulënëꞌ Diuzi tuz̃e, lëscanꞌ naquëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Desde aodixu Diuzi yedyi layu, bazulanëꞌ nacalënëꞌ Diuzi tzaz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Conlë lëbëꞌ bë Diuzi yugulu ta de lao yedyi layu. Ni tu ta bë Diuzi bibënnëꞌn sin lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Por lëbëꞌ de yelaꞌ neban quiero. Naquëꞌ ca quie tu guiꞌ ta useniꞌn uluꞌen xnezaro ga rdaro. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lëguiꞌ naꞌ rseniꞌn quie yaca benꞌ rda lao lato lao chula. Nitu nitu nunu saqueꞌ usula len. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Uzu tu benꞌ lao Juan, benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Bidëꞌ udixogueꞌnëꞌ benëꞌ unëꞌ huida tu benꞌ naca ca quie guiꞌ rseniꞌn ga naca chula. Lëcanaꞌ guca Juan testigo de que huida benꞌ naca ca quie guiꞌ rseniꞌn ga naca chula. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan binaquëꞌ benꞌ zazaꞌ, benꞌ naca ca guiꞌ rseniꞌn ga naca chula. Nacazëꞌ tu testigo ta useꞌelaꞌ Diuzi ta quixogueꞌnëꞌ quie benꞌ zazaꞌ, benꞌ naca ca quie guiꞌ rseniꞌn ga naca chula. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Naꞌra babidacazi benꞌ naca ca quie guiꞌ rseniꞌn ga naca chula, benꞌ ruꞌe diꞌidzaꞌ li, benꞌ ruzioñeꞌe yaca benꞌ nitaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bidanëꞌ lao yedyi layu. Udixogueꞌnëꞌ benëꞌ diꞌidzaꞌ laꞌiya quie Diuzi. Baꞌalaꞌcazi conlë lëbëꞌ bë Diuzi yugulu ta de lao yedyi layu, bibezaque yaca benëꞌ chi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Lëbëꞌ uzunëꞌ lao yedyi quienëꞌ, naꞌ biz̃i yaca benꞌ lao yedyi quienëꞌ, biuyezilaꞌadyiꞌyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero con bala benꞌ uyezilaꞌadyiꞌ lëbëꞌ, lëbenꞌ naꞌ bëꞌnëꞌ derecho gacayaquëꞌ z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pero netzaꞌ quie yaca benꞌ gaca z̃iꞌi Diuzi, porque cala mandado quie benëꞌ gacajëꞌ z̃iꞌi Diuzi, cala danꞌ golojëꞌ nitaꞌjëꞌ lao yedyi layu gacajëꞌ z̃iꞌi Diuzi, dechanꞌ Diuzicazi bë canaꞌ gacajëꞌ z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Benꞌ naca xtiꞌidzaꞌ Diuzi guquëꞌ tu beꞌmbyu. Uzunëꞌ lado raꞌo tu chiꞌ. Blëꞌëndoꞌ yelaꞌ huaca quienëꞌ, blëꞌëndoꞌ tuzi lëbëꞌ naquëꞌ z̃iꞌi Diuzi, benꞌ nedyëꞌë raꞌo, benꞌ ruꞌe diꞌidzaꞌ li. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Unë Juan udixogueꞌnëꞌ quie benꞌ naꞌ unëꞌ: ―Quie benꞌ naꞌ uniaꞌ caora niaꞌ benꞌ zazaꞌra zenao nëꞌëdiꞌ, nacarëꞌ benꞌ z̃e ca nëꞌëdiꞌ como bazulanëꞌ caora uzuaꞌ nëꞌëdiꞌ. ―Canaꞌ una Juan. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yelaꞌ benꞌ huen quienëꞌ taz̃e naꞌ bënëꞌ quiero bëlaꞌiyanëꞌ raꞌo yuguluro. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lao naꞌa Moisés pcaꞌn Diuzi ley quienëꞌ. Pero lao naꞌa Cristo neziro nedyëꞌë Diuzi raꞌo, neziro ca naca tabala quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nitu nitu nunu nuebëꞌ Diuzi. Tuzi z̃iꞌinëꞌ, benꞌ dugalo nacalë Diuzi tuz̃e, lënëꞌ ruzioñeꞌenëꞌ raꞌo ta huebëꞌro Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yaca benꞌ Israel, yaca benꞌ nitaꞌ ciudad Jerusalén, useꞌelaꞌyaquëꞌ yaca pxuzi len yaca benꞌ naca familia quie Leví ta yenabayaquëꞌ Juan chi naquëꞌ benꞌ Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Biz̃i dyëꞌëdi unëꞌ: ―Cala nëꞌëdiꞌ benꞌ Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Naꞌra tatula unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¿Nuz̃i nacoꞌ luëꞌ chiꞌ? ¿Nacoꞌ benꞌ profeta, o chi nacoꞌ benꞌ lao Elías? Naꞌ biz̃i una Juan rëbinëꞌ leyaquëꞌ: ―Cala Elías nëꞌëdiꞌ. Pero tatula unayaquëꞌ rëbiyaquëꞌ Juan: ―¿Nacoꞌ benꞌ profeta, benꞌ zazaꞌra? Naꞌra bequëbinëꞌ unanëꞌ: ―Cala nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Biz̃i tatula rëbiyaquëꞌ lëbëꞌ: ―¿Nuz̃i nacoꞌ luëꞌ chiꞌ? Deyeyuꞌandoꞌ tu diꞌidzaꞌ quioꞌ ta inezi yaca benꞌ useꞌelaꞌ nëtoꞌ. ¿Cabiz̃i inaoꞌ? ¿Nuz̃i nacoꞌ luëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Naꞌra una Juan rëbinëꞌ leyaquëꞌ: ―Nacaꞌ tu benꞌ rnë zidzo lao lato ga bidyia yuꞌu. Niaꞌ canꞌ con ca baona profeta Isaías, benꞌ uzu dza naꞌte, niaꞌ: “Usalole tu neza li, danꞌ bazaꞌ xaꞌnro, benꞌ useꞌelaꞌ Diuzi.” ");
INSERT INTO zpcNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Naꞌ biz̃i yaca benꞌ uyo yegueꞌlë Juan diꞌidzaꞌ, nacayaquëꞌ benꞌ useꞌelaꞌ yaca benꞌ partido fariseo. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Chi binacoꞌ benꞌ Cristo, ni Elías, ni benꞌ profeta, ¿naꞌa bixquienꞌ ruꞌeloꞌ lao yaca benëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Naꞌra una Juan rëbinëꞌ leyaquëꞌ: ―Tali ruꞌa lao yaca benëꞌ con nisa, pero entre ladole huida tu benꞌ binubëꞌle. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Zazaꞌrëꞌ zenaohuëꞌ nëꞌëdiꞌ. Tanto naquëꞌ benꞌ z̃era ca nëꞌëdiꞌ, ni lëꞌëtiꞌ bibi zacaꞌ ni siquiera biyeyaz̃ogaꞌ cuiogaꞌ guidi yuꞌu niꞌanëꞌ. ―Canaꞌ una Juan. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Lëcanaꞌ uz̃acayaquëꞌ lao lato laona Betábara, ga regaꞌnnan gaꞌalaꞌ ga de yao Jordán, con ganꞌ bëꞌ Juan lao yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Biz̃i beteyu blëꞌë Juan bazaꞌ Jesús gaꞌalaꞌ. Naꞌ unëꞌ rëbinëꞌ yaca benꞌ nitaꞌ naꞌ: ―Ulenaꞌ, lëbenꞌ ni naquëꞌ ca becoꞌ z̃iꞌilaꞌ, bia naca gun quie Diuzi. Lëlëbëꞌ cubëꞌ dulaꞌ xquia quie yaca benëꞌ nitaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Quie benꞌ niga uniaꞌ caora niaꞌ: “Benꞌ zazaꞌra zenao nëꞌëdiꞌ, nacarëꞌ benꞌ z̃e ca nëꞌëdiꞌ, como danꞌ bazulanëꞌ caora uzuaꞌ nëꞌëdiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Biz̃i nëꞌëdiꞌ biunezdaꞌ nu naquëꞌ, pero zaꞌ ruꞌa lao yaca benꞌ Israel con nisa tacuenda ineziyaquëꞌ nu naquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Lëzi unarë Juan: ―Blëꞌëdaꞌ uyezi Bichi Be quie Diuzi, zaꞌnëꞌ guibá ca uyezi biu, yasënëꞌ ga zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Biz̃i nëꞌëdiꞌ biunezdaꞌ nu naquëꞌ. Pero benꞌ useꞌelaꞌ nëꞌëdiꞌ ta zaꞌ ruꞌa lao yaca benëꞌ unëꞌ rëbinëꞌ nëꞌëdiꞌ: “Cati ilëꞌëloꞌ Bichi Be quiaꞌ chezinëꞌ tzasënëꞌ ga zë tu beꞌmbyu, lëbenꞌ naꞌ udzeꞌnëꞌ Bichi Be quie Diuzi luꞌu laxtaꞌo yaca benëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Blëꞌëdaꞌ guca quie benꞌ ni con ca una Diuzi. Quie lenaꞌ nacaꞌ testigo lëlëbëꞌ naquëꞌ z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Biz̃i beteyu tula, zë Juan len chopa yaca benꞌ nao lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Cati blëꞌënëꞌ ude Jesús ganꞌ zënëꞌ unëꞌ: ―Ulenaꞌ, lëbenꞌ ni naquëꞌ ca becoꞌ z̃iꞌilaꞌ, bia naca gun quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lao rupate yaca benꞌ zio nao Juan, beyaquëꞌ ca una Juan. Naꞌra zioyaquëꞌ unaoyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Naꞌra beyëcho Jesús unaꞌnëꞌ xcuꞌudzunëꞌ blëꞌënëꞌ zio yaca benëꞌ zenao lëbëꞌ. Naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Cabiz̃i rguilole? Naꞌra unëyaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Maestro, ¿gaz̃i idyinloꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Naꞌra una Jesús: ―Uleda, hualëꞌële ganꞌ idyinaꞌ. Naꞌra uz̃iꞌyaquëꞌ ziolëyaquëꞌ lëbëꞌ blëꞌëyaquëꞌ ganꞌ bdyinnëꞌ. Lëganꞌ naꞌ begaꞌnlëyaquëꞌ lëbëꞌ danꞌ uyëꞌënëꞌ dza, baruen cadu reda tapa quie zadzeꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Biz̃i lado chopa benꞌ be ca una Juan unaoyaquëꞌ Jesús, zu tunëꞌ laohuëꞌ Andrés, biꞌ bichi Simón Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Canaꞌ laoyote Andrés yedilonëꞌ ga zu bichinëꞌ Simón, naꞌ gudyinëꞌ lënëꞌ: ―Abedilandoꞌ benꞌ useꞌelaꞌ Diuzi, benꞌ naca Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Naꞌra uquiëꞌ Andrés biꞌ bichinëꞌ Simón ganꞌ zë Jesús. Biz̃i caora blëꞌë Jesús Andrés len Simón, unëꞌ rëbinëꞌ Simón: ―Luëꞌ Simón, z̃iꞌi Jonás, ixubaꞌ laoloꞌ Cefas, ta inaro: Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lëzirë beteyu tula, Jesús uz̃iꞌnëꞌ zionëꞌ Galilea. Lëganꞌ naꞌ bedilanëꞌ Felipe, naꞌ gudyinëꞌ lëbëꞌ: ―Unao nëꞌëdiꞌ gacoꞌ benꞌ quiaꞌ ―unëꞌ rëbinëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Naꞌra benꞌ yedyi Betsaida naca Felipe. Lëlao yedyi naꞌ zurë Andrés len Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Biz̃i Felipe bedilanëꞌ Natanael nëꞌ rëbinëꞌ lëbëꞌ: ―Bedilandoꞌ tu benꞌ rnën quie lëꞌë guichi bë Moisés, len yaca guichi bë yaca benꞌ profeta. Lëbenꞌ naꞌ laohuëꞌ Jesús, z̃iꞌi José, benꞌ yedyi Nazaret. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naꞌra una Natanael rëbinëꞌ Felipe: ―¿Cabiz̃i tu tahuen ero lao yedyi Nazaret? Naꞌra bequëbi Felipe: ―Uda, ilëꞌëloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Caora blëꞌë Jesús bazaꞌ Natanael, naꞌra unë Jesús cani: ―Bazaꞌ tu benꞌ naca dugalo benꞌ Israel, benꞌ birziꞌ yëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Biz̃i Natanael unëꞌ rëbinëꞌ Jesús: ―¿Cómo nubëꞌloꞌ nëꞌëdiꞌ? Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Bala blëꞌëdaꞌ luëꞌ ga reꞌloꞌ z̃an yaga higo tu binequixogueꞌ Felipe luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Naꞌra una Natanael rëbinëꞌ Jesús: ―Maestro, luëꞌ nacoꞌ z̃iꞌi Diuzi, benꞌ zaꞌ inabëꞌ yaca benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Biz̃i una Jesús rëbinëꞌ Natanael: ―¿Baguleloꞌ danꞌ niaꞌ blëꞌëdaꞌ luëꞌ ga reꞌloꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lëzi unarë Jesús rëbinëꞌ leyaquëꞌ: ―Tali rniaꞌ leꞌe, nacaꞌ bichi yugulu benëꞌ, naꞌ hualëꞌële tzalo guibá chezi yeyëpi yaca ángel idyinjëꞌ gan zuaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Guca lao tzona dza, naꞌ guca huetzaganaꞌ yedyi Caná quie estado Galilea. Biz̃i yedyi naꞌ zurë z̃naꞌ Jesús, blëꞌënëꞌ caora naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Biz̃i ganꞌ guca huetzaganaꞌ, bërëjëꞌ Jesús invitar len yaca benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Biz̃i naꞌ guca bebidyi vino nisa bedzuliꞌ ta riꞌoyaquëꞌ. Naꞌra una z̃naꞌ Jesús rëbinëꞌ lëbëꞌ: ―Babebidyi vino, gabira yudzon. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Naꞌra una Jesús rëbinëꞌ z̃nëꞌë: ―Z̃naꞌa, ¿bixquienꞌ naoꞌ nëꞌëdiꞌ canaꞌ? Binedyin hora uluꞌenaꞌ benëꞌ yelaꞌ huaca quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Naꞌ biz̃i unëꞌ z̃nëꞌë rëbinëꞌ yaca benꞌ ruꞌe laze: ―Ulehue yugulu con ta ruebiꞌ leꞌe mandado huele ―nëꞌ rëbinëꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Biz̃i ganꞌ nitaꞌyaquëꞌ naꞌ, nitaꞌrë xopa yesoꞌ yela de yo. Ca biuꞌ benëbi quie yaca benꞌ Israel, lëyesoꞌ naꞌ nacan ta yudzon nisa ta rguibiyaquëꞌ cuinyaquëꞌ lente ta de quieyaquëꞌ. Lao tu huiona yudzon cadu gatzo gayuhua litro o cadu tzona galo chi litro nisa. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Naꞌra una Jesús rëbinëꞌ yaca benꞌ ruꞌe laze: ―Usedzaꞌle yesoꞌ naꞌ nisa. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Caora bedzaꞌ lao xopa yesoꞌ, naꞌ una Jesús rëbinëꞌ yaca benꞌ ruꞌe laze: ―Ulecuion, ulehueꞌ benꞌ naca xanꞌ lani. Biz̃i laodaꞌteyaquëꞌn yehuaꞌayaquëꞌn bëꞌyaquëꞌn benꞌ xanꞌ lani. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Biz̃i benꞌ naca xanꞌ lani, byubinëꞌ nisa babeyacan vinola, pero binezinëꞌ ga zaꞌn. Tuzi yaca benꞌ ruꞌe laze baneziyaquëꞌ ga zaꞌn. Canaꞌ guca guz̃i benꞌ naca xanꞌ lani biꞌ utzaganaꞌ ");
INSERT INTO zpcNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","unëꞌ rëbinëꞌbiꞌ: ―Yaca benëꞌ rue nu lani ruꞌecaziyaquëꞌ tanëro vino naca dyaꞌa. Caora riꞌo yaca benꞌ rida lani ta zila, naꞌ ruꞌeyaquëꞌ vino sisa. Naꞌ biz̃i luëꞌ, pcaꞌnloꞌ vino dyaꞌa hasta naꞌtera baolioloꞌn barequisioꞌn ―nëꞌ rëbinëꞌ biꞌbyu. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Canaꞌ naca milagro nëro bë Jesús yedyi Caná quie estado Galilea, ga uzulaonëꞌ bluꞌenëꞌ yelaꞌ huaca quienëꞌ. Danꞌ bënëꞌ canaꞌ, lëcanaꞌ gule yaca benꞌ zio nao lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ude beyudyi naꞌ, uzëꞌë ziolënëꞌ z̃nëꞌë, len bichinëꞌ, len yaca benꞌ quienëꞌ yedyi lao Capernaum. Lëganꞌ naꞌ begaꞌnyaquëꞌ baba dza. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Danꞌ bazu bago gaꞌalaꞌ lani pascua ta rezaꞌlaꞌadyiꞌyaquëꞌ ca guca bro xuzixtaꞌoyaquëꞌ nación Egipto, lëcanaꞌ uzaꞌ Jesús bdyinnëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ca bdyinnëꞌ laliꞌa quie idaoꞌ rnabëꞌra ciudad Jerusalén, naꞌ blëꞌënëꞌ nitaꞌ yaca benꞌ rutiꞌ huaga, len benꞌ rutiꞌ becoꞌ z̃iꞌilaꞌ, len benꞌ rutiꞌ biu. Lëscanꞌ blëꞌënëꞌ yaca benꞌ rutzaꞌ dumi. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Biz̃i cati blëꞌë Jesús ca rue yaca benꞌ yuꞌu huëtiꞌ laliꞌa idaoꞌ rnabëꞌra, naꞌ uz̃iꞌguëꞌ tu guidi udinëꞌ blaonëꞌ yaca benꞌ yuꞌu rutiꞌ lente huaga lente becoꞌ z̃iꞌilaꞌ quieyaquëꞌ. Naꞌ quie benꞌ retzaꞌ dumi, uruꞌunnëꞌ mesa quieyaquëꞌ layu, gusi dumi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Naꞌra gudyinëꞌ yaca benꞌ rutiꞌ biu rëbinëꞌ leyaquëꞌ: ―¡Ulecuba yugulu ta de niga! ¡Bihuele yuꞌu quie yeꞌeya yuꞌu quie Xuzaꞌ! ");
INSERT INTO zpcNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Canaꞌ bezaꞌlaꞌadyiꞌ yaca benꞌ quiëꞌ canꞌ rnën lëꞌë guichi laꞌiya quie Diuzi cani: “Tanto rdëbidaꞌ quie yuꞌu quioꞌ, raquedaꞌ bayëchiꞌ ca tamala rue yaca benëꞌ quien.” ");
INSERT INTO zpcNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Naꞌra una yaca benꞌ Israel rëbiyaquëꞌ Jesús: ―Bluꞌe nëtoꞌ tu seña ta inezindoꞌ de yelaꞌ rnabëꞌ quioꞌ danꞌ blaoloꞌ yaca benꞌ yuꞌu huëtiꞌ laliꞌa idaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Chi leꞌe udyiaguiꞌle idaoꞌ rnabëꞌra niga, nëꞌëdiꞌ yechizaꞌ tu tacubi gaca lao tzona dza. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Biz̃i una yaca benꞌ Israel rëbiyaquëꞌ lëbëꞌ: ―Yaca benꞌ bë idaoꞌ rnabëꞌra niga, bëyaquëꞌn lao chopa galo xopa iza, ¿naꞌ como luëꞌ naoꞌ gaca lao tzona dza yechizaloꞌ tu tacubi? ―Canaꞌ unayaquëꞌ rëbiyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero caora unë Jesús canaꞌ, cala quie idaoꞌ naꞌ unënëꞌ, quie cuinzinëꞌ unënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Biz̃i caora guti Jesús bebannëꞌ tatula, caora naꞌ lëlenaꞌ bezaꞌlaꞌadyiꞌ yaca benꞌ unao lëbëꞌ con ca unëꞌ. Lëlenaꞌ guleyaquëꞌ ca rnën lëꞌë guichi laꞌiya quie Diuzi lente ca una Jesús gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Caora uzu Jesús ciudad Jerusalén, caora naꞌ guca lani pascua. Lëcanaꞌ yaca benꞌ zë guleyaquëꞌ quienëꞌ danꞌ blëꞌëyaquëꞌ yelaꞌ huaca quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Biz̃i Jesús gucabëꞌnëꞌ biguleyaquëꞌ dulaꞌadyiꞌyaquëꞌ, danꞌ nezinëꞌ bi pensari yuꞌu luꞌu guicho laxtaꞌo yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Lëlenaꞌ birnaban nu yëbi Jesús bi pensari yuꞌu luꞌu guicho laxtaꞌo yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Uzu tu benꞌ partido fariseo laonëꞌ Nicodemo. Naquëꞌ benꞌ rnabëꞌ quie yaca benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Biz̃i Nicodemo uyonëꞌ rdzeꞌ ga zu Jesús rëbinëꞌ lëbëꞌ: ―Maestro, banezindoꞌ luëꞌ nacoꞌ benꞌ useꞌelaꞌ Diuzi ta uzioñeꞌeloꞌ nëtoꞌ, danꞌ nitu nitu nunu nehue yelaꞌ huaca ca rueloꞌ luëꞌ chi Diuzi bizulënëꞌ luëꞌ tzaz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Tali ca rniaꞌ luëꞌ, chi nu benꞌ bigalo taorupe, bisaqueꞌ yedyinnëꞌ guibá ga rnabëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Biz̃i Nicodemo unëꞌ rëbinëꞌ Jesús: ―¿Biz̃i hue tu benꞌ gula galonëꞌ taorupe? ¿Huazaqueꞌ yeyuꞌunëꞌ luꞌu lëꞌë z̃nëꞌë ta galonëꞌ taorupe? ");
INSERT INTO zpcNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Chi nu benꞌ biralo conlë nisa, naꞌtera lëscanꞌ conlë Bichi Be quie Diuzi, bisaqueꞌ yedyinnëꞌ guibá ga rnabëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nu benꞌ rzu de z̃iꞌi beꞌmbyu, nacacazëꞌ beꞌmbyu. Pero nu benꞌ rzu de Bichi Be quie Diuzi, nacacazëꞌ benꞌ yuꞌu Bichi Be quie Diuzi luꞌu laxtaꞌohue. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Biyebaneloꞌ con canꞌ rniaꞌ luëꞌ: “Rnaban galo benëꞌ taorupe.” ");
INSERT INTO zpcNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Cabëꞌ quie be, rdanan ni, rdanan naꞌ, rero xchiꞌnan, pero naꞌ bineziro galaꞌ zaꞌn, galaꞌ zion. Lëcanaꞌ nacarë quie yaca benꞌ ralo lao naꞌa Bichi Be quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Naꞌra na Nicodemo rëbinëꞌ Jesús: ―¿Cabiz̃i gaca ca unaoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Biz̃i Jesús nëꞌ rëbinëꞌ lëbëꞌ: ―Nacoꞌ tu maestro quie benꞌ Israel, ¿cómo binezoꞌ con ca baoniaꞌ luëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tali ca rniaꞌ luëꞌ, ca ta nezindoꞌ baonandoꞌ nacandoꞌ testigo ca ta blëꞌëndoꞌ, pero naꞌ leꞌe biralele cabëꞌ baonandoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chi binezile ca naca baoniaꞌ leꞌe bi raca lao yedyi layu, ¿cabiz̃i huele para inezile ta iniaꞌ leꞌe bi raca guibá? ");
INSERT INTO zpcNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Nitu nunu uyo guibá yedyin quixogueꞌ benëꞌ bi raca guibá. Tuzaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, idetixogueꞌnaꞌ benëꞌ bi raca guibá. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Cabëꞌ bë Moisés bëguëꞌ tu bëla de bronce, bdaꞌguëꞌbaꞌ lëꞌë yaga sibi, lëcanaꞌ gacarë quiaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, udaꞌrë benëꞌ nëꞌëdiꞌ lëꞌë yaga cruzo. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Canaꞌ gaca quiaꞌ tacuenda gataꞌ yelaꞌ neban tuzioli quie nu benꞌ gale quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Biz̃i tanto nedyëꞌë Diuzi yaca benëꞌ nitaꞌ lao yedyi layu, useꞌelëꞌ tu litzaꞌ z̃iꞌinëꞌ tacuenda nutezi benꞌ nao xnezëꞌ, bicuiaguiꞌyaquëꞌ, denꞌ gataꞌ yelaꞌ neban quiejëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Cala useꞌelaꞌ Diuzi z̃iꞌinëꞌ lao yedyi layu ta huenëꞌ castigo quie yaca benëꞌ, denꞌ useꞌelaꞌ Diuzi lëbëꞌ ta ute uselanëꞌ leyaquëꞌ hueꞌnëꞌ yelaꞌ neban quiejëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Nu yaca benꞌ nao xneza z̃iꞌi Diuzi, bihue Diuzi castigo quieyaquëꞌ. Pero nu yaca benꞌ binao xneza z̃iꞌinëꞌ, huataꞌcazi castigo quieyaquëꞌ, danꞌ biunaoyaquëꞌ xneza benꞌ naca tu litzaꞌ z̃iꞌinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nu yaca benꞌ biunao xneza z̃iꞌinëꞌ, baochuguli Diuzi quieyaquëꞌ huataꞌ castigo quiejëꞌ, porque cati bdyin z̃iꞌinëꞌ lao yedyi layu bzioñeꞌenëꞌ quie Diuzi, caora naꞌ yaxerayaquëꞌ tayaquëꞌ lao lato lao chula, biguleyaquëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yugulute yaca benꞌ rue tamedian rudieyaquëꞌ benꞌ ruzioñeꞌe quie Diuzi. Bireꞌenyaquëꞌ naoyaquëꞌ xnezëꞌ, porque danꞌ rdzebiyaquëꞌ su be ca tamedian rueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero yaca benꞌ nao tali, raxeyaquëꞌ naoyaquëꞌ xneza benꞌ ruzioñeꞌe quie Diuzi, porque danꞌ canaꞌ su be de que rueyaquëꞌ tadyaꞌa cabëꞌ reꞌen Diuzi hueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bëꞌ beyudyi naꞌ, uzaꞌ Jesús ziolënëꞌ yaca benꞌ quienëꞌ estado Judea. Lëganꞌ naꞌ begaꞌnyaquëꞌ tu chiꞌ ga bëꞌyaquëꞌ lao yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Lëzirë zu Juan ruꞌenëꞌ lao yaca benëꞌ ganꞌ lao Enón, ganꞌ de nisa zila. Nacan gaꞌalaꞌ para yedyi Salim. Lëganꞌ naꞌ bedupa yaca benëꞌ, naꞌ bëꞌ Juan laoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Canaꞌ guca caora binedzeꞌyaquëꞌ Juan luꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Biz̃i bala yaca benꞌ quie Juan uyuꞌulëyaquëꞌ tu benꞌ Israel huenë ruꞌeyaquëꞌ diꞌidzaꞌ ca costumbre naoyaquëꞌ quie idaoꞌ ta gacan yëri lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Naꞌra uyoyaquëꞌ rëbiyaquëꞌ Juan: ―Maestro, benꞌ uzulë luëꞌ itzalaꞌ yao Jordán, lëbenꞌ unaoꞌ nëtoꞌ dza naꞌ, benꞌ zë baruꞌenëꞌ laohue, bazioyaquëꞌ lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Biz̃i una Juan rëbinëꞌ leyaquëꞌ: ―Ni tu nunu de yelaꞌ rnabëꞌ quie, chi cala Diuzi bëꞌnëꞌn lao nëꞌë. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Leꞌe banezile dyëꞌëdi ca uniaꞌ. Binacaꞌ benꞌ Cristo. Nacaꞌ benꞌ rguixogueꞌ benëꞌ de que huida benꞌ Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cristo naquëꞌ ca quie benꞌ utzaganaꞌ. Lëzirë yaca benꞌ nao xnezëꞌ, naca quieyaquëꞌ ca quie nigula utzaganaꞌ. Nëꞌëdiꞌ nacaꞌ ca quie amigo quie benꞌ utzaganaꞌ. Biz̃i benꞌ naca amigo quie benꞌ utzaganaꞌ, redaohuenëꞌ uzënaguëꞌ yenëꞌ bi na benꞌ utzaganaꞌ. Quie lenaꞌ redaohuedaꞌ rzënagaꞌ yedaꞌ bi na benꞌ Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Lëbëꞌ ziorëꞌ raquëꞌ benꞌ z̃era ca nëꞌëdiꞌ, reyaꞌalaꞌ taꞌ puro z̃anle. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Benꞌ zaꞌ guibá, arnabëꞌnëꞌ lao yugulute benëꞌ. Benꞌ ralo lao yedyi layu, nacacazëꞌ benꞌ dugalo de lao yedyi layu. Raquëꞌ pensari quie ta raca lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pero benꞌ zaꞌ guibá, ruꞌenëꞌ diꞌidzaꞌ ca ta blëꞌënëꞌ len ca ta benëꞌ. Biz̃i naꞌ yaca benëꞌ biraleyaquëꞌ quienëꞌ cabëꞌ nanëꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Chi nu benꞌ ralenëꞌ ca diꞌidzaꞌ na benꞌ zaꞌ guibá, lenaꞌ uluꞌen ralenëꞌ bi na Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Benꞌ useꞌelaꞌ Diuzi, rnëguëꞌ diꞌidzaꞌ quie Diuzi. Dulaꞌadyiꞌcazi yuꞌunëꞌ Bichi Be quie Diuzi luꞌu guicho laxtaꞌonëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Xuziro Diuzi nedyëꞌëcazinëꞌ z̃iꞌinëꞌ. Nuꞌeguëꞌ yugulute ta de lao naꞌa z̃iꞌinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nu yaca benꞌ nao xneza benꞌ Cristo z̃iꞌi Diuzi, bagutaꞌ yelaꞌ neban quieyaquëꞌ tuzioli. Pero quie nu yaca benëꞌ binao xneza z̃iꞌi Diuzi, bibi yelaꞌ neban tuzioli gataꞌ quieyaquëꞌ, yelaꞌcala hue Diuzi lëyaquëꞌ tu castigo huala gula. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Biz̃i bdyin dza blëꞌë yaca benꞌ fariseo de que unao benꞌ zëra Jesús ca benꞌ unao Juan. Lëzi bëꞌ Jesús lao benꞌ zëra ca Juan. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero cala Jesús bëꞌnëꞌ lao benëꞌ, dechanꞌ yaca benꞌ quienëꞌ, lëlëyaquëꞌ bëꞌyaquëꞌ lao yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Caora gucabëꞌ Jesús ca rna yaca benꞌ fariseo, naꞌ uzëꞌë estado Judea zioguëꞌ bdyinnëꞌ estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Con ganꞌ zionëꞌ reꞌennan tenëꞌ estado Samaria. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Canaꞌ bdyinnëꞌ yedyi Sicar quie estado Samaria. Nacan gaꞌalaꞌ ganꞌ de layu bëꞌ Jacob z̃iꞌinëꞌ José canaꞌte gula. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Biz̃i bdyinnëꞌ ganꞌ reꞌ pozo nisa ta ulëchi xuzixtaꞌonëꞌ Jacob. Naꞌ como danꞌ banexaquenëꞌ yuꞌunëꞌ neza, caora naꞌ ureꞌnëꞌ ruꞌa pozo aruen cadu gatzo dza. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Biz̃i yaca benꞌ quienëꞌ zioyaquëꞌ laꞌo yedyi ta gaꞌoyaquëꞌ ta gaoyaquëꞌ. Canaꞌ guca bdyin tu nigula benꞌ Samaria ta cuioguëꞌ nisa ganꞌ reꞌ pozo. Naꞌra una Jesús rëbinëꞌ nigula: ―Ben nisa yoꞌogaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Naꞌra una nigula naꞌ rëbinëꞌ Jesús: ―¿Cómo luëꞌ, benꞌ Israel, rnaboꞌ nëꞌëdiꞌ, benꞌ Samaritana, nisa yoꞌoloꞌ? (Canaꞌ una nigula gudyinëꞌ Jesús danꞌ biyuꞌulë benꞌ Samaria tuzi len benꞌ Israel.) ");
INSERT INTO zpcNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Biz̃i una Jesús rëbinëꞌ nigula: ―Chanꞌ ineziloꞌ ca rue run Diuzi, lëzi chanꞌ nubëꞌraoꞌ nu benꞌ rnaba luëꞌ nisa ta yoꞌoguëꞌ, naꞌ huanabacazoꞌ nëꞌëdiꞌ nisa yoꞌoloꞌ, guncazaꞌ nisa neban. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Naꞌra una nigula rëbinëꞌ Jesús: ―Señor, bibi nuꞌacazoꞌ ta cuioloꞌ nisa. Lëzi danꞌ reꞌn zituꞌ, tanaꞌ lenaꞌ rniaꞌ luëꞌ ¿gaz̃i tzexiuꞌ nisa naoꞌ nisa neban naꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ulëchi xuzixtaꞌoro Jacob pozo niga ga hueꞌenëꞌ cuinnëꞌ len z̃iꞌinëꞌ len yaca bia guixiꞌ udapëꞌ. Niaꞌ luëꞌ, ¿biz̃i rnabëꞌroꞌ luëꞌ ca lëbëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Naꞌ biz̃i Jesús nëꞌ rëbinëꞌ nigula: ―Lao yugulute yaca benꞌ yoꞌo nisa niga, bicuezan ta rbiliyaquëꞌn, huiꞌoyaquëꞌn tatula. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero nu yaca benꞌ yoꞌo nisa huaꞌ nëꞌëdiꞌ, bira ibiliyaquëꞌ. Huaca quieyaquëꞌ ca quie tu ga ralo nisa luꞌu laxtaꞌoyaquëꞌ tacuenda gataꞌ yelaꞌ neban quiejëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Naꞌra una nigula rëbinëꞌ Jesús: ―Señor, ben nisa naoꞌ gunoꞌ yoꞌogaꞌ, yelaꞌ naꞌ bira guidaꞌ ruꞌa pozo ni ideliogaꞌ nisa. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Biz̃i unë Jesús rëbinëꞌ nigula: ―Beyo yexiꞌ xquiuloꞌ guidalaoꞌnëꞌ ganꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Naꞌra una nigula rëbinëꞌ lëbëꞌ: ―Nunu xquiuhuaꞌ zu. Naꞌ biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Tali ca unaoꞌ naoꞌ ganu xquiuloꞌ zu. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Naꞌ biz̃i nëꞌ niaꞌ, baozulaoꞌ lao gaꞌyoꞌ beꞌmbyu. Naꞌ benꞌ zulaoꞌ naꞌa, cala xquiuloꞌ. Lëlënaꞌ nacacazin tali ca unaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Bëꞌ be nigula ca una Jesús, unëꞌ rëbinëꞌ lëbëꞌ: ―Señor, rlëꞌëdaꞌ luëꞌ nacoꞌ tu benꞌ quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nëꞌëdiꞌ niaꞌ de que uyonlaꞌadyiꞌ yaca benꞌ xuzixtaꞌondoꞌ Diuzi ganꞌ zu yaꞌa niga. Naꞌ biz̃i leꞌe, benꞌ Israel, nale ciudad Jerusalén, lëganaꞌ reyaꞌalaꞌ tzionlaꞌadyiꞌ yaca benëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Biz̃i una Jesús rëbinëꞌ nigula: ―Nigula, gule canꞌ niaꞌ naꞌ, huadyin dza tzionlaꞌadyiꞌle Diuzi, pero cala niga ganꞌ zu yaꞌa guidale, lëscanꞌ cala ciudad Jerusalén tziole. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Leꞌe benꞌ Samaritano, binezile nu tzionlaꞌadyiꞌle, pero nëtoꞌ banezcazindoꞌ nu tzionlaꞌadyiꞌndoꞌ. Conlë yaca benꞌ Israel pcaꞌn Diuzi diꞌidzaꞌ quienëꞌ tacuenda inezi yaca benëꞌ bi reꞌen Diuzi huejëꞌ ta yeyëri laxtaꞌojëꞌ laohuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Baruen bago idyin hora cati yaca benꞌ rionlaꞌadyiꞌ Diuzi tzionlaꞌadyiꞌyaquëꞌ lëbëꞌ conlë Bichi Be quienëꞌ, lëscanꞌ conlë diꞌidzaꞌ li cabëꞌ reꞌen Diuzi. Lëyaca benꞌ rue canaꞌ, raxe Diuzi tzionlaꞌadyiꞌyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Naca Diuzi benꞌ bichi be. Lëlenaꞌ yaca benꞌ rionlaꞌadyiꞌ lëbëꞌ, reyaꞌalaꞌ tzionlaꞌadyiꞌyaquëꞌ lëbëꞌ conlë bichi be quieyaquëꞌ, lëscanꞌ conlë diꞌidzaꞌ li cabëꞌ reꞌen Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Naꞌra una nigula rëbinëꞌ lëbëꞌ: ―Pues nëꞌëdiꞌ banezdaꞌ de que huida benꞌ naca Cristo. Lëscanꞌ cati guidëꞌ, uzioñeꞌenëꞌ raꞌo lao yugulute. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Nëꞌëdiꞌ nacaꞌ benꞌ Cristo, benꞌ ruꞌelë luëꞌ diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Naꞌra cati bedyin yaca benꞌ quienëꞌ ganꞌ zënëꞌ, tu bebanziyaquëꞌ ruꞌelë Jesús diꞌidzaꞌ nigula Samaritana. Pero bibeyaz̃ocaziyaquëꞌ bi yëbiyaquëꞌ lëbëꞌ bi diꞌidzaꞌ ruꞌelënëꞌ nigula. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Canaꞌ guca pcaꞌn nigula reꞌe quienëꞌ, bezëꞌë zioguëꞌ laꞌo yedyi quienëꞌ yetixogueꞌnëꞌ yaca benꞌ yedyi naꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Yaꞌ tzioro ilëꞌëro tu beꞌmbyu laga unëꞌ nëꞌëdiꞌ ca naca ta babiaꞌ. ¿Cala lëbëꞌ naquëꞌ benꞌ Cristo? ");
INSERT INTO zpcNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Naꞌra uzaꞌ yaca benꞌ lao yedyi yenáꞌyaquëꞌ ganꞌ zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tu zadyinra benꞌ lao yedyi, caora naꞌ una yaca benꞌ quie Jesús rëbiyaquëꞌ lëbëꞌ: ―Maestro, ¿biraoloꞌ lëꞌëtiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ―Leꞌe binezile decazi ta gaohuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Naꞌra uzulao yaca benꞌ quienëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Cala biblëꞌëro babida yaca benꞌ bedehuaꞌa ta udaohuëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Biz̃i una Jesús rëbinëꞌ yaca benꞌ quiëꞌ: ―Ruzuaꞌ diꞌidzaꞌ quie benꞌ useꞌelaꞌ nëꞌëdiꞌ. Lëlenaꞌ gaca quiaꞌ ca quie benꞌ baodao. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","’Naꞌ leꞌe nale: “Neruꞌen lato itapa biuꞌ ta yeziꞌro usecho.” Naꞌ biz̃i nëꞌëdiꞌ niaꞌ: “Ulenaꞌcara ca naca quie layela como danꞌ bade yeza bidyi baguca yeziꞌron.” ");
INSERT INTO zpcNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ca naca quie benꞌ beziꞌ usecho, canaꞌ huaziꞌguëꞌ xlaz̃oguëꞌ. Huazulëcazinëꞌ Diuzi tuzioli. Tanaꞌ lenaꞌ redaohue lao rupateyaquëꞌ, ca benꞌ raza, ca benꞌ yeziꞌ usecho. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nacan tali ca na benëꞌ: “Tuëꞌ raza, naꞌ ituëꞌ yeziꞌnëꞌ usecho.” ");
INSERT INTO zpcNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Biz̃i nëꞌëdiꞌ iseꞌelaꞌ leꞌe ta yeziꞌle usecho quie Diuzi ga biguzale. Nacan ta guza benꞌ tula, benꞌ ruerë dyin quie Diuzi. Naꞌ biz̃i leꞌe redaohuele yeziꞌle usecho quie Diuzi. Reꞌen Diuzi inao yaca benëꞌ xnezëꞌ. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Naꞌ biz̃i yaca benꞌ zë, benꞌ Samaria, benꞌ nitaꞌ yedyi Sicar, guleyaquëꞌ quie Jesús danꞌ una nigula: “Unanëꞌ nëꞌëdiꞌ yugulu ca ta babiaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Biz̃i cati bdyin yaca benꞌ Samaria ganꞌ zë Jesús, caora naꞌ unëyëchiꞌyaquëꞌ para yegaꞌnlë Jesús leyaquëꞌ. Naꞌra begaꞌn Jesús uzulënëꞌ leyaquëꞌ lao chopa dza. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Lëcanaꞌ guca gulera yaca benꞌ zë quie Jesús beyaquëꞌ ca unanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Naꞌra unayaquëꞌ rëbiyaquëꞌ nigula: ―Naꞌra bagulendoꞌ quienëꞌ. Cala rquincara luëꞌ inaoꞌ nëtoꞌ bidëꞌ. Banezindoꞌ ca naca diꞌidzaꞌ ruꞌenëꞌ. Banezindoꞌ talicazi lëbëꞌ naquëꞌ benꞌ Cristo, benꞌ ute usela yaca benꞌ nitaꞌ lao yedyi layu. ―Canaꞌ nayaquëꞌ rëbiyaquëꞌ nigula. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ude lao chopa dza uzulënëꞌ leyaquëꞌ estado Samaria, naꞌ uzëꞌë zionëꞌ estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Canaꞌ guca uzaꞌnëꞌ bdyinnëꞌ estado Galilea. Naꞌra cuinnëꞌ unëꞌ cabëꞌ raca quie yaca benꞌ rguixogueꞌ diꞌidzaꞌ laꞌiya quie Diuzi. Birapalaꞌn benꞌ lao yedyi quienëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pues cati bdyinnëꞌ estado Galilea, naꞌ yaca benꞌ nitaꞌ ganꞌ bdyinnëꞌ, beziꞌyaquëꞌ lëbëꞌ dyëꞌëdi como danꞌ baoyoyaquëꞌ ciudad Jerusalén dza naꞌ cati raca lani quie pascua, blëꞌëyaquëꞌ cabëꞌ bënëꞌ cati uyoguëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Biz̃i naꞌ bdyinnëꞌ ciudad Caná quie estado Galilea. Lëganaꞌ bexinoguëꞌ nisa beyuenëꞌn vino. Naꞌra ciudad Capernaum zu tu benꞌ rnabëꞌ naquëꞌ empleado quie gobierno rey. Naꞌ zu tu z̃iꞌinëꞌ raca z̃hueꞌbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Caora unezi benꞌ empleado uzaꞌ Jesús estado Judea bdyinnëꞌ estado Galilea, naꞌ uzëꞌë zioguëꞌ tzeguedyinëꞌ Jesús ta tzionëꞌ z̃an yuꞌu quienëꞌ ta yeyuenëꞌ z̃iꞌi benꞌ naꞌ, porque debiꞌ raca z̃hueꞌbiꞌ bagatibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Naꞌra una Jesús rëbinëꞌ benꞌ naꞌ: ―Leꞌe bigalele chi biilëꞌële tu seña quie yelaꞌ huaca huaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Biz̃i una benꞌ naca empleado: ―Señor, chi huuꞌ cule, latziotero antes naꞌa binegati z̃iꞌinaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Biz̃i Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―Beyo z̃an yuꞌu quioꞌ. Bigati z̃iꞌiloꞌ. Biz̃i benꞌ empleado gulenëꞌ ca gudyi Jesús lëbëꞌ. Naꞌ bezëꞌë zeyoguëꞌ z̃an yuꞌu quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cati zeyoguëꞌ gatzo neza, binedyinnëꞌ z̃an yuꞌu quienëꞌ, caora naꞌ bedzaganëꞌ yaca benꞌ zulaohuëꞌ. Naꞌ biz̃i unayaquëꞌ rëbiyaquëꞌ benꞌ xaꞌnyaquëꞌ: ―Hueyaca z̃iꞌiloꞌ, bigatibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Biz̃i benꞌ empleado unabëꞌ yaca benꞌ zulaohuëꞌ unëꞌ: ―¿Ca biz̃i hora berobiꞌ tala? Naꞌra una yaca benꞌ zulaonëꞌ rëbiyaquëꞌ lëbëꞌ: ―Niogue ca reda tu quie zadzëꞌ, canaꞌ bezubiꞌ dyaꞌa berobiꞌ tala. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Biz̃i benꞌ empleado xuzi xcuidiꞌ raca z̃hueꞌ, bezaquenëꞌ caora gudyi Jesús lëbëꞌ: “Hueyaca z̃iꞌiloꞌ bigatibiꞌ”, lëhora naꞌ labeyacatebiꞌ. Canaꞌ guca gulenëꞌ quie Jesús. Lëscanꞌ gule yugulute yaca benꞌ nitaꞌ z̃an yuꞌu quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Lëcanaꞌ guca laorupe lasa bluꞌeguëꞌ seña quie yelaꞌ huaca quienëꞌ caora cati uzëꞌë estado Judea bdyinnëꞌ estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ude beyudyi beyue Jesús yaca benꞌ raca z̃hueꞌ, naꞌtera guca dza raca lani quie benꞌ Israel. Tanaꞌ uzaꞌ Jesús zionëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ga bdyinnëꞌ ciudad Jerusalén, naꞌ reꞌ naꞌ tu pozo nisa. Naꞌ diꞌidzaꞌ hebreo lao pozo nisa naꞌ pozo nisa Betesda. Nuꞌan gaꞌyoꞌ ruꞌa yuꞌu ga ruꞌu benëꞌ. Regaꞌnnan gaꞌalaꞌ ga zu tu ruꞌa yuꞌu belao. Lëruꞌa yuꞌu naꞌ neziꞌlaona ruꞌa yuꞌu quie becoꞌ z̃iꞌilaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Lëlugar naꞌ nitaꞌ yaca benꞌ zë, benꞌ raca z̃hueꞌ, len benꞌ laochula, len benꞌ z̃i, len benꞌ neseco biraca saꞌ. Rbezayaquëꞌ bëꞌ chechu ta nisa. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Rbezayaquëꞌ ganꞌ danꞌ bayuꞌu rdyin ángel ga reꞌ pozo nisa ta utanëꞌn. Biz̃i benꞌ yubi tzuꞌu tanëro luꞌu nisa caora sulao chechu tanan, lëbenꞌ naꞌ laiyacate con bitiꞌtezi yelaꞌ hueꞌ racanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Lëganꞌ naꞌ de tu benꞌ raca z̃hueꞌ azio lao galobechi xuna iza raca z̃hueꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Biz̃i Jesús bdyinnëꞌ blëꞌënëꞌ de benꞌ naꞌ raca z̃hueꞌnëꞌ, gucabëꞌnëꞌ azio zë iza raca z̃hueꞌnëꞌ. Naꞌra una Jesús rëbinëꞌ benꞌ raca z̃hueꞌ: ―¿Reꞌenloꞌ yero yelaꞌ hueꞌ yuꞌuloꞌ ta yeyacoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Naꞌra una benꞌ raca z̃hueꞌ rëbinëꞌ Jesús: ―Señor, nunu dyilaꞌ udzeꞌ nëꞌëdiꞌ luꞌu pozo nisa cati sulao tanan. Biz̃i nëꞌëdiꞌ, cati reꞌendaꞌ tzuꞌa tanëro, laruꞌute benꞌ tula. ―nëꞌ rëbinëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Uyasa, uz̃iꞌ daꞌa quioꞌ, beda. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Biz̃i ca una Jesús canaꞌ, labeyasate benꞌ raca z̃hueꞌ, beziꞌguëꞌ daꞌa quiëꞌ nuꞌanëꞌn rdalënëꞌn. Pero dza rezilaꞌadyiꞌ bë Jesús canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Lenaꞌ una yaca benꞌ Israel rëbiyaquëꞌ benꞌ beyaca: ―Naꞌadza nacan dza huezilaꞌadyiꞌ. Biruꞌen lato taloꞌ huaꞌaloꞌ daꞌa quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Naꞌra bequëbi benꞌ beyaca unëꞌ rëbinëꞌ leyaquëꞌ: ―Benꞌ beyue nëꞌëdiꞌ unëꞌ: “Uyasa, uz̃iꞌ daꞌa quioꞌ beda.” ");
INSERT INTO zpcNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¿Nuz̃i benꞌ una luëꞌ canaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Biz̃i benꞌ beyaca biunezinëꞌ bi lao benꞌ beyue lëbëꞌ, danꞌ labezaꞌte Jesús udenëꞌ zionëꞌ lado benꞌ zë. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Biz̃i zio Jesús luꞌu idaoꞌ rnabëꞌra. Lëganaꞌ bedilanëꞌ benꞌ beyuenëꞌ, naꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Canaca naꞌa babeyacoꞌ, bira hueloꞌ bizinaquezi ta bira gaca quioꞌ ta hualara canꞌ baguca quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Canaꞌ guca uyo benꞌ beyaca yeguëdyinëꞌ yaca benꞌ Israel, unëꞌ rëbinëꞌ leyaquëꞌ: ―Jesús naꞌ, lëbëꞌ beyuenëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bëꞌ unezi yaca benꞌ Israel cabëꞌ una benꞌ beyaca, caora naꞌ rnaojëꞌ Jesús reꞌenyaquëꞌ gutijëꞌ lëbëꞌ, danꞌ beyuenëꞌ benꞌ z̃i dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Naꞌ biz̃i Jesús unëꞌ rëbinëꞌ leyaquëꞌ: ―Danꞌ rue Xuzaꞌ Diuzi dyin yugu dza, lëlenaꞌ hueriaꞌ dyin yugu dza. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ca be yaca benꞌ Israel ca una Jesús canꞌ, mazara bdzaꞌyaquëꞌ guꞌunyaquëꞌ gutiyaquëꞌ lëbëꞌ, danꞌ bibënëꞌ casa quie ley quie dza huezilaꞌadyiꞌ. Lëscanꞌ bënëꞌ cuinnëꞌ ca Diuzi caora unëꞌ quie Diuzi naca Diuzi Xuzinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tali ca rniaꞌ leꞌe, nëꞌëdiꞌ z̃iꞌi Diuzi, bibi de huaꞌ chanꞌ bizu Diuzi conlë nëꞌëdiꞌ. Ca ta blëꞌëdaꞌ rue Xuzaꞌ, lëlenaꞌ rueriaꞌ nëꞌëdiꞌ. Canꞌ rue Xuzaꞌ, canaꞌ rueriaꞌ nëꞌëdiꞌ z̃iꞌinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pues Diuzi nedyëꞌënëꞌ nëꞌëdiꞌ z̃iꞌinëꞌ, rluꞌenëꞌ nëꞌëdiꞌ ruaꞌ yugulu ta ruenëꞌ. Zazaꞌra uluꞌenëꞌ nëꞌëdiꞌ z̃iꞌinëꞌ tu ta nacara z̃e, tu ta binelëꞌële huebanle cati ilëꞌëlen. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Cabëꞌ rue Xuzaꞌ, resebannëꞌ benꞌ baguti, lëscanaꞌ nëꞌëdiꞌ z̃iꞌinëꞌ, huaꞌa benëꞌ yelaꞌ neban tuzioli, benꞌ reꞌendaꞌ gataꞌ yelaꞌ neban quie. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Cala Xuzaꞌ ichugobëꞌnëꞌ quie yaca benëꞌ. Lao naꞌa nëꞌëdiꞌ z̃iꞌinëꞌ napcaꞌnnëꞌ yelaꞌ rnabëꞌ quienëꞌ ta ichugobiꞌa quie yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Bë Xuzaꞌ canaꞌ tacuenda lao yugulute yaca benëꞌ gapalaꞌnyaquëꞌ nëꞌëdiꞌ z̃iꞌi Diuzi cabëꞌ rapalaꞌnyaquëꞌ Xuzaꞌ. Chi nu yaca benëꞌ birapalaꞌnyaquëꞌ nëꞌëdiꞌ z̃iꞌi Diuzi, lëlenaꞌ ruluꞌen birapalaꞌnyaquëꞌ Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Tali ca rniaꞌ, con nu benꞌ rzënaga canꞌ baoniaꞌ, lenaꞌ ruluꞌen raleyaquëꞌ quie benꞌ useꞌelaꞌ nëꞌëdiꞌ, naꞌ de yelaꞌ neban quiëꞌ tuzioli, bigataꞌ castigo quienëꞌ. Naca quienëꞌ ca quie benꞌ baguti beban tatula, bira gatinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tali ca rniaꞌ, abdyin dza uzënaga yaca benꞌ birale quiaꞌ cabëꞌ diꞌidzaꞌ rniaꞌ nëꞌëdiꞌ z̃iꞌi Diuzi. Naca quieyaquëꞌ ca quie benꞌ nati, danꞌ biraleyaquëꞌ quiaꞌ cabëꞌ diꞌidzaꞌ rniaꞌ. Nu yaca benꞌ uzënaga diꞌidzaꞌ gale quiaꞌ cabëꞌ rniaꞌ, hueꞌ Diuzi leyaquëꞌ yelaꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Napa Xuzaꞌ yelaꞌ rnabëꞌ ta hueꞌnëꞌ lëjëꞌ yelaꞌ neban tuzioli. Lëzi baben Xuzaꞌ Diuzi nëꞌëdiꞌ z̃iꞌinëꞌ yelaꞌ rnabëꞌ ta huaꞌa yaca benëꞌ yelaꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Lëzi benrë Xuzaꞌ Diuzi nëꞌëdiꞌ yelaꞌ rnabëꞌ ta ichugobiꞌa quie yaca benëꞌ danꞌ nacaꞌ bichi yugulu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Biyebanle canꞌ baoniaꞌ, huadyin dza ye yugulute yaca benꞌ huati rchiꞌa cati iniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Lëhora naꞌ yero yaca benꞌ huati luꞌu yëroba. Naꞌ biz̃i yaca benꞌ bë dyaꞌa hueyataꞌ yelaꞌ neban quieyaquëꞌ para tuzioli. Pero naꞌ biz̃i yaca benꞌ bë dulaꞌ xquia, useban Diuzi leyaquëꞌ ta huenëꞌ leyaquëꞌ castigo. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Bibi de huaꞌ cuinzaꞌ. Rchugobiꞌa quie yaca benëꞌ ca ta una Diuzi nëꞌëdiꞌ huaꞌ. Tanaꞌ rchugobiꞌa huaꞌ tu ta yuꞌu niꞌa xnezi. Cala ta racazi laꞌadyaꞌ huaꞌ denꞌ huaꞌ ca reꞌen Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Chi rniaꞌ cule quiaꞌ cuinzaꞌ, lenaꞌ bibi sirve ta uluꞌen nu nacaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero zu itu benꞌ rnë cule nëꞌëdiꞌ naquëꞌ testigo quiaꞌ. Naꞌ ca ta rnënëꞌ cule quiaꞌ nëꞌëdiꞌ, lenaꞌ uluꞌen nu nacaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Biz̃i leꞌe useꞌelaꞌle yaca benꞌ uyo yenaba Juan. Naꞌ ca ta bequëbi Juan nacan tali. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Biruguinte inë tu benëꞌ cule nëꞌëdiꞌ. Ca diꞌidzaꞌ rniaꞌ leꞌe, nacan ta galele quiaꞌ gataꞌ yelaꞌ neban quiele tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ca diꞌidzaꞌ una Juan nacan ca quie yëri raꞌalaꞌ rseniꞌn. Biz̃i leꞌe, yedaohuele bzënagale ca diꞌidzaꞌ unëꞌ tu chiꞌzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Decazira cule quiaꞌ nëꞌëdiꞌ ta nacaran belao ca diꞌidzaꞌ una Juan ta uluꞌen nu nacaꞌ. Biaꞌ yelaꞌ huaca quiaꞌ tuz ca una Xuzaꞌ nëꞌëdiꞌ huaꞌ. Lëlenaꞌ uluꞌen leꞌe tali useꞌelaꞌ Xuzaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Lëzi Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ, zënëꞌ cule conlë nëꞌëdiꞌ ta uluꞌen leꞌe nu nacaꞌ laꞌacazi nitu lasa bibele xchiꞌnëꞌ, biblëꞌë lao cuinle lënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Cabëꞌ leꞌe binetzuꞌu diꞌidzaꞌ quie Diuzi luꞌu guicho laxtaꞌole. Biralele quiaꞌ nëꞌëdiꞌ nacaꞌ benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Leꞌe rusëdile dyëꞌëdi ca rna lëꞌë guichi laꞌiya quie Diuzi como danꞌ raquele chi rusëdilen dyëꞌëdi, canaꞌ gataꞌ yelaꞌ neban quiele tuzioli. Naꞌ biz̃i lëꞌë guichi naꞌ rnëcazin quiaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero leꞌe, bireꞌenle guidale naole nëꞌëdiꞌ ta gataꞌ yelaꞌ neban quiele tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Tuzi nacaliaꞌ Diuzi laꞌacazi gapale nëꞌëdiꞌ balaꞌana, laꞌacazi bigapale nëꞌëdiꞌ balaꞌana. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lëscanꞌra nubëꞌdaꞌ leꞌe. Nezdaꞌ binedyëꞌële Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tanun quie Xuzaꞌ bidaꞌ lao yedyi layu, pero naꞌ leꞌe biuyezilaꞌadyiꞌle nëꞌëdiꞌ. Biz̃i chanꞌ zaꞌ benꞌ tula ta racazi laꞌadyiꞌnëꞌ benꞌ naꞌla gueꞌenle. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Cabiz̃i huele inaole xneza Diuzi, chi lao laza huele ta gueꞌen tuzi Diuzi leꞌe, naꞌ ruele ta gueꞌen yaca benëꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Biinale chi nëꞌëdiꞌ huaohuaꞌ leꞌe xquia lao Diuzi. Cuin Moisés, benꞌ nale sulële dyaꞌa lao Diuzi, lëbëꞌ gaonëꞌ leꞌe xquia lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Biz̃i chanꞌ ralele quie Moisés cabëꞌ unëꞌ, lëscanaꞌ reyaꞌalaꞌ galerële quiaꞌ, como danꞌ bzu Moisés diꞌidzaꞌ lëꞌë guichi ta rguixogueꞌn quie nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Biz̃i chanꞌ leꞌe biralele cabëꞌ diꞌidzaꞌ bzu Moisés lëꞌë guichi, ¿cabiz̃i huele galele cabëꞌ diꞌidzaꞌ rniaꞌ leꞌe? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Te beyudyi una Jesús canaꞌ, uzëꞌë zioguëꞌ itzalaꞌ lagun Galilea. Lëlagun naꞌ neziꞌlaona lagun Tiberias. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Biz̃i yaca benꞌ zë gula zioyaquëꞌ naoyaquëꞌ lëbëꞌ, danꞌ blëꞌëyaquëꞌ ca naca yelaꞌ huaca quienëꞌ reyuenëꞌ yaca benꞌ raca z̃hueꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Canaꞌ guca urë Jesús zionëꞌ ga zu tu yaꞌa. Lao yaꞌa naꞌ ureꞌnëꞌ lënëꞌ yaca benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Baruen bago quie lani pascua quie yaca benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Cati unaꞌ Jesús ca yaca benꞌ zë nao lëbëꞌ, naꞌra unëꞌ rëbinëꞌ Felipe: ―¿Ca gaz̃i tzexiꞌro ta gao yaca benꞌ zë gula niga? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús bënëꞌ pruebazi Felipe a ver bi ca inanëꞌ, danꞌ dyëꞌëdi banezinëꞌ cuinnëꞌ ca huenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Naꞌra unë Felipe rëbinëꞌ Jesús: ―Nica gaquezi lao chopa gayuhua dumi denarios ta gaꞌoro yëta xtila ta gao yaca benꞌ niga. Ni tu bicho huion bigaquen gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Naꞌra una Andrés, biꞌ bichi Simón Pedro, benꞌ nao Jesús, unëꞌ rëbinëꞌ lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ni zu tu xcuidiꞌ nuꞌabiꞌ gaꞌyoꞌ yëta xtila len chopa bela, pero niaꞌ ¿ca biz̃i huero gaquen gao lao yugulute benꞌ nitaꞌ niga? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Uleyëbi lao yuguluteyaquëꞌ cueꞌyaquëꞌ. Biz̃i ganꞌ ureꞌyaquëꞌ, naꞌ de guiz̃i yaꞌa. Naꞌ ureꞌ yaca lao gaꞌyoꞌ mila beꞌmbyu. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ude naꞌ uz̃iꞌ Jesús yëta xtila naꞌ, bazënëꞌn bëꞌlënëꞌ Diuzi diꞌidzaꞌ unëꞌ: “Diuxcaleloꞌ”, naꞌ bëꞌnëꞌn yaca benꞌ quienëꞌ. Naꞌ biz̃i yaca benꞌ quienëꞌ, udisiyaquëꞌn bëꞌyaquëꞌn ca tu yaca benꞌ reꞌ ganꞌ nitaꞌyaquëꞌ. Lëzi canaꞌ bërëꞌ quie bela, udaoyaquëꞌ ca tu rnan quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bëꞌ beyudyi udaoyaquëꞌ beloyaquëꞌ, naꞌ una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ―Uletupa, uleziꞌ ca tu ta begaꞌn ta bigaca ditoguen. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Canaꞌ guca yeziꞌyaquëꞌ tayoz̃o gucan lao chipchopa gaꞌ naga ca tu ta begaꞌn udaoyaquëꞌ quie lao gaꞌyoꞌ yëta xtila. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Naꞌ biz̃i yaca benëꞌ blëꞌëyaquëꞌ ca naca yelaꞌ huaca bë Jesús, unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Tali benꞌ ni naquëꞌ benꞌ useꞌelaꞌ Diuzi lao yedyi layu ta quixogueꞌnëꞌ raꞌo xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Naꞌ como gucabëꞌ Jesús bareꞌenyaquëꞌ iquiëꞌyaquëꞌ lëbëꞌ tzionëꞌ rey quieyaquëꞌ a la fuerza, canaꞌ uzaꞌ Jesús lënëꞌ yaca benꞌ quiëꞌ zionëꞌ urënëꞌ tu yaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Caora aodzeꞌ bareꞌen ixin, uzaꞌyaquëꞌ zioyaquëꞌ ruꞌa nisa lagun. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Biz̃i yaca benꞌ quie Jesús, uyuꞌuyaquëꞌ luꞌu barco azioyaquëꞌ lao nisa ta idyinyaquëꞌ ciudad Capernaum. Naꞌ baruen chula, nunu Jesús bdyin ganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Biz̃i luꞌu nisa ganꞌ zioyaquëꞌ naꞌ, uzulao raca tu be bedunꞌ huala gula, biꞌa be nisa rxitin ladza. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Caora aruen gaꞌyoꞌ xopa kilómetro aozaꞌlëyaquëꞌ barco, blëꞌëyaquëꞌ rzaꞌ Jesús lao nisa, azioguëꞌ bago ganꞌ reꞌyaquëꞌ luꞌu barco. Biz̃i canaꞌ guca bdzebitzegueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Nëꞌëdiꞌ zaꞌ niga, bidzebile. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Biz̃i redaohueyaquëꞌ ta tzuꞌu Jesús luꞌu barco ganꞌ yuꞌuyaquëꞌ. Ca uyuꞌu Jesús luꞌu barco itu chiꞌzi bdyinyaquëꞌ ruꞌa nisa ganꞌ tzioyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Beteyu tula, biz̃i begaꞌn yaca benëꞌ ruꞌa nisa lagun ganꞌ uzaꞌ yaca benꞌ quie Jesús. Naꞌ biz̃i bezaꞌlaꞌadyiꞌyaquëꞌ uyuꞌu yaca benꞌ quie Jesús tuzi barco de ruꞌa nisa. Lëzirë bezaꞌlaꞌadyiꞌrëyaquëꞌ bizio Jesús lënëꞌ yaca benꞌ quienëꞌ luꞌu barco. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Naꞌ bdyin yaca barco tula ganꞌ, barco ta uzaꞌ ciudad Tiberias. Regaꞌnnan gaꞌalaꞌ ganꞌ udaoyaquëꞌ yëta xtila len bela, ganꞌ bëꞌlë Jesús Diuzi diꞌidzaꞌ gudyinëꞌ lëbëꞌ: “Xcaleloꞌ”. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Biz̃i caora blëꞌëyaquëꞌ nunu Jesús lënëꞌ yaca benꞌ quienëꞌ zu ganꞌ, naꞌ uyuꞌuyaquëꞌ yaca barco de ganꞌ zioyaquëꞌ ciudad Capernaum ta yeguiloyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cati bdyinyaquëꞌ itzalaꞌ lagun, bedilayaquëꞌ Jesús unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Maestro, ¿ca bata blaoꞌ niga? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tali ca rniaꞌ leꞌe, leꞌe rdale reguilole nëꞌëdiꞌ danꞌ aodaole abelole. Cala reguilole nëꞌëdiꞌ danꞌ agulele quie yelaꞌ huaca biaꞌ blëꞌële. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Biquilole tuzi yelaꞌ huao yedu yebidyi. pero ulequilorë yelaꞌ huao biyedu yebidyi, yelaꞌ huao nuꞌan yelaꞌ neban tuzioli. Lëyelaꞌ huao naꞌ gunaꞌ leꞌe. Nëꞌëdiꞌ, bichi yugulu benëꞌ, babluꞌe Xuzaꞌ Diuzi leꞌe cabëꞌ ruzuaꞌ diꞌidzaꞌ quiëꞌ. ―Canaꞌ guca una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Biz̃i rnabayaquëꞌ lëbëꞌ rnayaquëꞌ: ―¿Ca biz̃i reyaꞌalaꞌ huendoꞌ ta huendoꞌ ca reꞌen Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Ca ta reꞌen Diuzi huele, reꞌennëꞌ galele quiaꞌ nëꞌëdiꞌ, benꞌ useꞌelëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Biz̃i unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¿Cabiz̃i yelaꞌ huaca hueloꞌ ta uluꞌeloꞌ ilëꞌëndoꞌ galendoꞌ quioꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Lenaꞌ rnandoꞌ danꞌ yaca benꞌ xuzixtaꞌoro udaoyaquëꞌ yëta xtila lao maná lao lato ga bidyia yuꞌu con cabëꞌ ca rnan lëꞌë guichi laꞌiya quie Diuzi: “Diuzi bëꞌnëꞌ ta udaoyaquëꞌ yëta xtila zaꞌ guibá.” ―Canaꞌ gudyiyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tali ca rniaꞌ leꞌe. Cala Moisés bëꞌnëꞌ yëta xtila zaꞌ guibá, dechanꞌ Xuzaꞌ Diuzi bëꞌnëꞌn ta udaoyaquëꞌ. Lëzi Xuzaꞌ Diuzi gunnëꞌ leꞌe yëta xtila ta zaꞌ guibá. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Lëyëta xtila gun Diuzi zaꞌten de guibá nuꞌan yelaꞌ neban tuzioli para yaca benꞌ nitaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Señor, guncazoꞌ yëta xtila nao gunoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Nëꞌëdiꞌ nacaꞌ lëyëta xtila nuꞌan yelaꞌ neban tuzioli. Con nu yaca benꞌ guida nao nëꞌëdiꞌ, biyeyudyi yedu yelaꞌ neban quieyaquëꞌ. Huaca quieyaquëꞌ ca quie benꞌ bitue, benꞌ birbili. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Con canꞌ baonëcazaꞌ leꞌe, baꞌalaꞌcazi bablëꞌële nëꞌëdiꞌ, biralele quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nu yaca benꞌ gun Xuzaꞌ Diuzi guida nao nëꞌëdiꞌ, biyesebiꞌayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nëꞌëdiꞌ zaꞌ guibá ta uzuaꞌ diꞌidzaꞌ quie Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ. Huaꞌ cabëꞌ unanëꞌ, bihuaꞌ ta racazi laꞌadyaꞌ. Huaꞌ cabëꞌ mandado bë Xuzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ca reꞌen Xuzaꞌ Diuzi, benꞌ useꞌelaꞌ nëꞌëdiꞌ, reꞌennëꞌ ni tu yaca benëꞌ guida nao nëꞌëdiꞌ bicuiaguiꞌyaquëꞌ. Reꞌennëꞌ usebancazaꞌ leyaquëꞌ dza gaca juicio. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ca reꞌen Xuzaꞌ Diuzi, benꞌ useꞌelaꞌ nëꞌëdiꞌ, reꞌennëꞌ gataꞌcazi yelaꞌ neban tuzioli quie yaca benꞌ gale quiaꞌ nëꞌëdiꞌ z̃iꞌinëꞌ. Huasebanaꞌyaquëꞌ dza gaca juicio. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Con ca be yaca benꞌ Israel una Jesús unëꞌ naquëꞌ ca quie yëta xtila zaꞌ guibá, lenaꞌ udyialaꞌadyiꞌyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Naꞌ nayaquëꞌ: ―¿Cala benꞌ niga Jesús, z̃iꞌi José? ¿Cómo nëꞌ naquëꞌ benꞌ zaꞌ guibá, dechanꞌ nubëꞌro xuzinëꞌ len z̃naꞌnëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Ulesan, biinële con ganzi quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nunu guida nao nëꞌëdiꞌ, chi biben Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ, leyaquëꞌ. Naꞌ lënëꞌëdiꞌ usebancazaꞌ leyaquëꞌ dza gaca juicio. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Luꞌu libro ga yuꞌu diꞌidzaꞌ bzu yaca benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi rnan cani: “Diuzi ruzioñeꞌenëꞌ lao yugulu yaca benëꞌ.” Tanaꞌ rniaꞌ, con nu yaca benꞌ rzënaga ca na diꞌidzaꞌ quie Xuzaꞌ, uzioñeꞌe Xuzaꞌ leyaquëꞌ. Lëyaca benꞌ naꞌ guidayaquëꞌ inaoyaquëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Nitu nitu yaca benëꞌ binelëꞌëyaquëꞌ Xuzaꞌ. Tuzaꞌ nëꞌëdiꞌ, benꞌ uzaꞌ ga zunëꞌ, bablëꞌëdaꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tali ca rniaꞌ leꞌe, nu yaca benꞌ gale quiaꞌ, badecazi yelaꞌ neban quieyaquëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nacaꞌ ca quie yëta xtila nuꞌan yelaꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yaca benꞌ xuzixtaꞌoro udaoyaquëꞌ yëta xtila lao maná lao lato ga bidyia yuꞌu, pero bëꞌ bdyin dza gatiyaquëꞌ gutiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero nëꞌëdiꞌ rniaꞌ quie yëta xtila uzaꞌ guibá, con nu yaca benꞌ gao len, bigaticaziyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nëꞌëdiꞌ nacaꞌ ca quie yëta xtila uzaꞌ guibá nuꞌan yelaꞌ neban tuzioli. Con nu yaca benꞌ gao lëyëta xtila nebancaziyaquëꞌ tuzioli. Cuinaꞌ gatiaꞌ tacuenda gataꞌ yelaꞌ neban quie yaca benëꞌ. Quie lenaꞌ bëꞌëlaꞌ quiaꞌ nacan ca yëta xtila nuꞌan yelaꞌ neban tuzioli. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Biz̃i yaca benꞌ Israel bëꞌlëyaquëꞌ laguedyiyaquëꞌ diꞌidzaꞌ unayaquëꞌ: ―¿Cómo na benꞌ niga gunnëꞌ bëꞌëlaꞌ quienëꞌ gaoro? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tali ca rniaꞌ leꞌe, nëꞌëdiꞌ bichi yugulu benëꞌ, chi leꞌe bigaole bëꞌëlaꞌ quiaꞌ, chi leꞌe biyoꞌorële ren quiaꞌ, bigataꞌ yelaꞌ neban quiele. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nu yaca benꞌ gao bëꞌëlaꞌ quiaꞌ yoꞌo ren quiaꞌ, de yelaꞌ neban quieyaquëꞌ tuzioli. Nëꞌëdiꞌ huesebanaꞌyaquëꞌ dza gaca juicio. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bëꞌëlaꞌ quiaꞌ nacan dugalo yelaꞌ huao gaole. Lëzirë ren quiaꞌ nacarën dugalo ta yoꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nu yaca benꞌ gao bëꞌëlaꞌ quiaꞌ, yoꞌo ren quiaꞌ, zulëcaziyaquëꞌ nëꞌëdiꞌ tzaz̃e, lëzi nëꞌëdiꞌ zuliaꞌyaquëꞌ tzaz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ, nebancazinëꞌ. Naꞌ biz̃i nëꞌëdiꞌ, nebanaꞌ por nun quienëꞌ. Lëzi canaꞌ gacarë quie benꞌ gao bëꞌëlaꞌ quiaꞌ, nebanyaquëꞌ por nun quiaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nëꞌëdiꞌ rniaꞌ quie yëta xtila zaꞌ guibá. Con nu yaca benꞌ gao lëyëta xtila naꞌ, badecazi yelaꞌ neban quieyaquëꞌ tuzioli. Pero quie yëta xtila lao maná ta udao yaca benꞌ xuzixtaꞌoro, baꞌalaꞌcazi udaoyaquëꞌn, cati bdyin dza gatiyaquëꞌ gutiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ, luꞌu idaoꞌ sinagoga ciudad Capernaum. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ca be yaca benꞌ canꞌ unao Jesús, naꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Zëdi gula naca ca diꞌidzaꞌ unëꞌ raꞌo. ¿Nuz̃i nezi bidanꞌ unënëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Biz̃i Jesús gucabëꞌnëꞌ ca pensari racayaquëꞌ ruꞌeyaquëꞌ diꞌidzaꞌ de que tziojëꞌ contra lëbëꞌ. Naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Quele resebiꞌle canꞌ baoniaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Cabiz̃i huele chi ilëꞌële nëꞌëdiꞌ, bichi yugulu benëꞌ, yeyëpaꞌ yeyaꞌa guibá ga zuaꞌ dza naꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Bichi Be quie Diuzi, lëbëꞌ runnëꞌ yelaꞌ neban quiele. Bibi de hue bëꞌëlaꞌ z̃ubaꞌ quiele lao Diuzi. Ca diꞌidzaꞌ baoniaꞌ leꞌe, lëdiꞌidzaꞌ naꞌ nacan tali, rnën quie Bichi Be quie Diuzi, benꞌ run yelaꞌ neban. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero nenitaꞌ bala leꞌe biralele quiaꞌ. Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ, danꞌ nezinëꞌ desde caora naꞌte nu benꞌ gale quienëꞌ, nu benꞌ bigale quienëꞌ. Lëzi nezinëꞌ nu benꞌ usedyin lëbëꞌ lao naꞌa yaca benꞌ guti lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Lenaꞌ uniaꞌ leꞌe canꞌ, ni tu yaca benëꞌ bisaqueꞌ guidayaquëꞌ naoyaquëꞌ nëꞌëdiꞌ, chi Xuzaꞌ bibënnëꞌ yaca benꞌ saꞌlë nëꞌëdiꞌ. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Canaꞌ guca apsanlaꞌadyiꞌ yaca benꞌ zë Jesús, yaca benꞌ unao lënëꞌ. Bira uyoyaquëꞌ inaoyaquëꞌ lëbëꞌ con ga zioguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Canaꞌ guca una Jesús rëbinëꞌ lao chipchopa benꞌ quienëꞌ, benꞌ begaꞌn: ―Lëzi leꞌe, ¿reꞌenle ibigaꞌle tzalaꞌla, bira inaole nëꞌëdiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Naꞌra una Simón Pedro rëbinëꞌ lëbëꞌ: ―Señor, ¿ca nuz̃ila benꞌ tziolëndoꞌ, como tuzoꞌ luëꞌ rnaoꞌ diꞌidzaꞌ rguixogueꞌn quie yelaꞌ neban tuzioli? ");
INSERT INTO zpcNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ca naca nëtoꞌ, bagulendoꞌ quioꞌ. Nezindoꞌ luëꞌ nacoꞌ benꞌ Cristo z̃iꞌi Diuzi, benꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Banebiogaꞌ lao chipchopa leꞌe gacale benꞌ quiaꞌ, pero biz̃i ladole ni, zu tule nuelë tuz̃e len bichi be xiꞌibiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ca una Jesús canaꞌ, unëꞌ quie Judas Iscariote, z̃iꞌi benꞌ lao Simón. LëJudas naꞌ naquëꞌ tuz̃e len ichiptu yaca benꞌ quie Jesús. Lëbëꞌ usedyinnëꞌ Jesús lao naꞌa yaca benꞌ guti lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Beyudyi guca canꞌ, uzaꞌ Jesús zioguëꞌ estado Galilea. Bireꞌennëꞌ sunëꞌ estado Judea, danꞌ lëganꞌ naꞌ rda yaca benꞌ Israel reꞌenyaquëꞌ gutiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Danꞌ baruen bago quie lani quie yuꞌu guiz̃i, ");
INSERT INTO zpcNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","naꞌra una yaca biꞌ bichi Jesús rëbinëꞌ lëbëꞌ: ―Biyegaꞌnloꞌ niga, beyo estado Judea tacuenda yediloꞌ yaca benꞌ rnao luëꞌ ta inezirëyaquëꞌ cabëꞌ rueloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Chi reꞌenloꞌ inezi yaca benëꞌ cabëꞌ rueloꞌ, bihueloꞌ negachiꞌzi. Naꞌ como barueloꞌ tu ta binelëꞌë yaca benëꞌ, bzaꞌlao bënan zacaꞌlao ta ilëꞌë yaca benëꞌ. ―Canaꞌ unayaquëꞌ rëbiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nica yaca biꞌ bichi Jesús biguleyaquëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Binedyin hora uluꞌenaꞌ yaca benëꞌ ca ta huaꞌ ilëꞌëyaquëꞌ. Pero ca naca leꞌe, huazaqueꞌ tziole lani bitezi hora. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yaca benꞌ nitaꞌ lao yedyi layu biudzeꞌlaꞌadyiꞌyaquëꞌ leꞌe. Pero ca naca nëꞌëdiꞌ, sí, udzeꞌlaꞌadyiꞌyaquëꞌ nëꞌëdiꞌ, danꞌ rguixoguiꞌa ca naca tamedian rueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Uletzio leꞌe lani. Bisaꞌ nëꞌëdiꞌ naꞌa, danꞌ binedyin hora saꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ude beyudyi una Jesús canaꞌ, begaꞌncazinëꞌ estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ude uzaꞌ yaca biꞌ bichi Jesús zioyaquëꞌ lani, naꞌtera uzaꞌrënëꞌ zionëꞌ lani, pero biuyoguëꞌ zaquëꞌlao, uyoguëꞌ negachiꞌzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Biz̃i yaca benꞌ Israel reguiloyaquëꞌ lëbëꞌ ga raca lani unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Gaz̃i zio Jesús? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Biz̃i yaca benꞌ zë unëyaquëꞌ quie Jesús. Balayaquëꞌ unayaquëꞌ naquëꞌ benꞌ huen. Naꞌ ibalayaquëꞌ unayaquëꞌ binaquëꞌ benꞌ huen, unayaquëꞌ rdanëꞌ rziꞌnëꞌ yëꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Biz̃i yaca benëꞌ rnëyaquëꞌ negachiꞌzi quie Jesús, danꞌ rdzebiyaquëꞌ ye yaca benꞌ rnabëꞌ quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Araca gatzo lani cati uyuꞌu Jesús luꞌu idaoꞌ rnabëꞌra zu naꞌ, naꞌ uzulaohuëꞌ rusëdiguëꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Naꞌ du rebanyaquëꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Cómo benꞌ niga rueguëꞌ zi rioñeꞌe? ¿Gaz̃i uyonëꞌ huesëdi? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Ca diꞌidzaꞌ rusëdiaꞌ leꞌe niga, binacan diꞌidzaꞌ quiaꞌ cuinzaꞌ, nacan diꞌidzaꞌ quiaꞌ len benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Chi nu yaca benꞌ reꞌen hue ca reꞌen Diuzi, lenaꞌ huaneziyaquëꞌ cabëꞌ naca diꞌidzaꞌ rniaꞌ, chi tuz̃e rnëliaꞌ Diuzi, o chi rniaꞌ ta racazi laꞌadyaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nu benꞌ rnë ta racazi laꞌadyiꞌnëꞌ reꞌennëꞌ para gueꞌen ja benëꞌ lëbëꞌ. Pero nu benꞌ rnëlë Diuzi tuz̃e, ruꞌenëꞌ diꞌidzaꞌ li, birziꞌnëꞌ yëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Quele Moisés bënnëꞌ leꞌe ley quie Diuzi? Naꞌ biz̃i leꞌe birue quiele cabëꞌ na ley naꞌ. ¿Ca bixquienꞌ reꞌenle gutile nëꞌëdiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Naꞌ biz̃i una yaca benëꞌ rëbiyaquëꞌ lëbëꞌ: ―Yuꞌuloꞌ bichi be quie taxiꞌibiꞌ. ¿Ca nuz̃i reꞌen guti luëꞌ danꞌ naoꞌ canꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Leꞌe rebanele cabëꞌ biaꞌ yelaꞌ milagro quiaꞌ tu dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Biz̃i Moisés bënëꞌ mandado bzu xuzixtaꞌoro tu xëdyidaoꞌ cuin xcuidiꞌdaoꞌ byu. Pero tanëro xuzixtaꞌotelaro bëꞌ canꞌ, cala Moisés. Lëscanꞌ leꞌe ruzule tu xëdyidaoꞌ xcuidiꞌdaoꞌ byu quiele, baꞌalaꞌcazi dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Leꞌe naole ruele ca una Moisés, ruzule tu xëdyidaoꞌ xcuidiꞌdaoꞌ byu quiele baꞌalaꞌcazi dza huezilaꞌadyiꞌ tacuenda uzucazile diꞌidzaꞌ ca unëꞌ. Naꞌ biz̃i nëꞌëdiꞌ, danꞌ beyuaꞌ tu benꞌ z̃i dza huezilaꞌadyiꞌ, lenaꞌ rdzaꞌtzeguele nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Biichugulile con ganzi. Cati ichugulile, ulechuguli tu ta yuꞌu niꞌa xnezi quie. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Biz̃i bala yaca benꞌ nitaꞌ ciudad Jerusalén unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Cala benꞌ niga reguilo yaca benꞌ rnabëꞌ ta gutiyaquëꞌ lëbëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Zacaꞌlao zaꞌ ja benꞌ zë naꞌ zënëꞌ rnënëꞌ. Bibi reyaz̃o yaca benꞌ rnabëꞌ bihueyaquëꞌ quienëꞌ. ¿Cala baneziyaquëꞌ tali naquëꞌ Cristo? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Raꞌo baneziro dyëꞌëdi ga yedyi golonëꞌ. Pero cati guida benꞌ Cristo, nica neziro ga yedyi galoguëꞌ. ―Canaꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Canaꞌ guca zë Jesús luꞌu idaoꞌ rnabëꞌra quie yaca benꞌ Israel rusëdinëꞌ leyaquëꞌ, naꞌ benëꞌ ca rna yaca benëꞌ. Naꞌra unënëꞌ zidzo rëbinëꞌ leyaquëꞌ: ―Cabëꞌ leꞌe banubëꞌle nëꞌëdiꞌ, banezile ga gologaꞌ. Pero cala bidaꞌ ta racazi laꞌadyaꞌ. Bidaꞌ tanun quie benꞌ zu tuzioli, benꞌ binubëꞌle. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero nëꞌëdiꞌ, nubëꞌdaꞌnëꞌ. Uzaꞌ ga zunëꞌ. Lëlëbëꞌ useꞌelaꞌnëꞌ nëꞌëdiꞌ. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Canaꞌ guca guꞌunyaquëꞌ guxuyaquëꞌ hueyaquëꞌ lëbëꞌ preso, pero bibeyaz̃oyaquëꞌ guxuyaquëꞌ lëbëꞌ, danꞌ binedyin dza idyinnëꞌ lao naꞌayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero yaca benꞌ zë, guleyaquëꞌ quienëꞌ. Naꞌra unayaquëꞌ: ―Talicazi benꞌ ni naquëꞌ benꞌ Cristo. Por nun quie yelaꞌ huaca quienëꞌ bënëꞌ, lenaꞌ aoneziro naquëꞌ benꞌ Cristo. ¿Ca nuz̃ira guida huera yelaꞌ huaca ca lëbëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Caora be yaca benꞌ partido fariseo ca diꞌidzaꞌ ruꞌe yaca benëꞌ, naꞌ leyaquëꞌ len xanꞌ pxuzi, useꞌelaꞌyaquëꞌ yaca policía luꞌu idaoꞌ rnabëꞌra ta tzeguëxoyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Naꞌra una Jesús rëbinëꞌ yaca benëꞌ: ―Dza nababa dzazi zuliaꞌ leꞌe niga, te naꞌ yeyaꞌa ganꞌ zu benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Leꞌe huadale yeguilole nëꞌëdiꞌ, pero biyedzelele nëꞌëdiꞌ, danꞌ bisaqueꞌ guidale ganꞌ yeyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Naꞌ biz̃i yaca benꞌ Israel rnabayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Ca gaz̃i yeyo benꞌ niga, naꞌ raꞌo biyedzelero ganꞌ yeyoguëꞌ? ¿Huayoguëꞌ ganꞌ nitaꞌ yaca benꞌ quiero, benꞌ uzaꞌ yaca zio yaca yedyi griego? ¿Cala huayonëꞌ usëdinëꞌ yaca benꞌ griego? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ca biz̃i reꞌen ina diꞌidzaꞌ unëꞌ raꞌo: “Leꞌe huadale yeguilole nëꞌëdiꞌ, pero biyedzelele nëꞌëdiꞌ, danꞌ bisaqueꞌ guidale ganꞌ yeyaꞌa.”? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mero dza yeyudyi lani nacan dza belao. Lëdza naꞌ uzuli Jesús unëꞌ zidzo rëbinëꞌ yaca benëꞌ: ―Con nu yaca benꞌ rbili, ruen zi inaoyaquëꞌ nëꞌëdiꞌ tacuenda gataꞌ ta yoꞌoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Con nu benꞌ rale quiaꞌ, gaca quienëꞌ con ca rnë lëꞌë guichi laꞌiya quie Diuzi: “Huaca laxtaꞌoyaquëꞌ ca quie ga de yao nuꞌan yelaꞌ neban.” ");
INSERT INTO zpcNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Caora cati una Jesús canaꞌ, quie Bichi Be quie Diuzi unëꞌ. Naꞌ huadyin dza huayuꞌu Bichi Be quie Diuzi luꞌu guicho laxtaꞌo yaca benꞌ rue quie quie xtiꞌidzaꞌ Jesús, pero binedyin dza gaca canꞌ danꞌ bineyo Jesús guibá ta tzequeꞌnëꞌ cuëta lëꞌë Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Entre bala yaca benëꞌ be ca una Jesús, naꞌ biz̃i unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Tali benꞌ niga naquëꞌ benꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi, benꞌ una Diuzi iseꞌelaꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Balayaquëꞌ unayaquëꞌ: ―Lëlëbëꞌ naquëꞌ benꞌ Cristo, benꞌ useꞌelaꞌ Diuzi. Naꞌ ibalayaquëꞌ unayaquëꞌ: ―¿Quele, cala estado Galilea zaꞌ benꞌ Cristo? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Lëꞌë guichi laꞌiya quie Diuzi rnën quie benꞌ Cristo naquëꞌ benꞌ z̃iꞌisuba rey David, benꞌ galo yedyi Belén, mero yedyi ga uzu rey David. ―Canaꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Canaꞌ guca, danꞌ brojëꞌ zë cueꞌ unayaquëꞌ diꞌidzaꞌ udeudela quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lenaꞌ balayaquëꞌ guꞌunyaquëꞌ guxuyaquëꞌ Jesús ta udzeꞌyaquëꞌ lëbëꞌ luꞌu dyiguiba, pero bibeyaz̃oyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yaca benꞌ naca policía, benꞌ napa dyin quie idaoꞌ uyoyaquëꞌ regunniꞌajëꞌ Jesús bedyinyaquëꞌ ga nitaꞌ yaca benꞌ partido fariseo len yaca xanꞌ pxuzi. Biz̃i naꞌ una yaca benꞌ partido fariseo len yaca xanꞌ pxuzi rëbiyaquëꞌ policía: ―¿Bixquienꞌ bibequiëꞌle lëbëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Naꞌra bequëbi yaca policía rëbiyaquëꞌ leyaquëꞌ: ―Nitu nitu nunu rnë ca lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Naꞌra una yaca benꞌ partido fariseo rëbiyaquëꞌ leyaquëꞌ: ―¿Lente leꞌe babëꞌle lato uz̃iꞌnëꞌ leꞌe yëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Biz̃i binezile nitu yaca benꞌ rnabëꞌ, lëzi nitu benꞌ partido fariseo, biguleyaquëꞌ quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Biz̃i yaca benꞌ yedyi bineziyaquëꞌ ca na lëꞌë guichi laꞌiya quie Diuzi. Lëlenaꞌ danꞌ nacayaquëꞌ benꞌ yuꞌu deꞌ. ―Canaꞌ una yaca benꞌ rnabëꞌ rëbiyaquëꞌ yaca policía. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Biz̃i Nicodemo naquerëꞌ benꞌ partido fariseo, benꞌ uyo yegueꞌlë diꞌidzaꞌ Jesús rtzeꞌ, unëꞌ rëbinëꞌ yaca benꞌ laguedyinëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Según ca naca ley quiero, biruꞌen lato ichugobëꞌro quie yaca benëꞌ chi bineyero bi rueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Biz̃i unayaquëꞌ rëbiyaquëꞌ Nicodemo: ―¿Lëzi luëꞌ, zaꞌraoꞌ estado Galilea? Psëdin unaꞌ lëꞌë guichi laꞌiya quie Diuzi, hualëꞌëloꞌ biuzaꞌ benꞌ iseꞌelaꞌ Diuzi estado Galilea. ");
INSERT INTO zpcNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Naꞌra bezaꞌyaquëꞌ zeyoyaquëꞌ z̃an yuꞌu quie quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Biz̃i Jesús uz̃iꞌnëꞌ zioguëꞌ ga zu yaꞌa laona yaꞌa Olivos. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cati uyaniꞌ dza tula, zeyo Jesús luꞌu idaoꞌ rnabëꞌra. Naꞌ beguꞌudiꞌ yaca benëꞌ ganꞌ zënëꞌ. Biz̃i naꞌ ureꞌnëꞌ rusëdinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Naꞌra yaca benꞌ rusëdi ley quie Moisés len yaca benꞌ partido fariseo, uquiëꞌyaquëꞌ tu nigula, benꞌ rdalë beꞌmbyu binaca xquiuhue. Bablëꞌë benëꞌ binꞌ bë nigula naꞌ len beꞌmbyu. Canaꞌ guca danꞌ bëxoyaquëꞌ nigula naꞌ lado benꞌ zë ganꞌ nitaꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Naꞌra unayaquëꞌ rëbiyaquëꞌ Jesús: ―Maestro, bablëꞌë yaca benëꞌ binꞌ bë nigula ni, aptilëꞌ beꞌmbyu binaca xquiuhuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Rnën lëꞌë guichi ley quie Moisés de quie reyaꞌalaꞌ gutiro con yo benꞌ rue cabëꞌ bë nigula niga. ¿Cabiz̃i naoꞌ luëꞌ? ―una yaca benꞌ naꞌ gudyijëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Unayaquëꞌ canꞌ ta yeyaquëꞌ cabiz̃i yequëbi Jesús. Reguilolaꞌadyiꞌyaquëꞌ ta gaoyaquëꞌ lëbëꞌ xquia. Naꞌ biz̃i Jesús byëchonëꞌ layula uzulaonëꞌ bënëꞌ letra layu conlë z̃benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Como danꞌ rnabazi rnabayaquëꞌ lëbëꞌ, canaꞌ guca bezulinëꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Nutezi leꞌe bibi xquia nehuaꞌ, tanëro leꞌe ulequi nigula ni yo. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Naꞌ biz̃i beyëchonëꞌ tatula layu. Bënëꞌ letra tatula layu conlë z̃benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Biz̃i yaca benꞌ nitaꞌ ga zë Jesús, bëꞌ beyaquëꞌ bi una Jesús, gucabëꞌyaquëꞌ pensari quieyaquëꞌ raon leyaquëꞌ xquia. Canaꞌ guca bezaꞌ tu huio tu huioyaquëꞌ. Tanëro bezaꞌ yaca benꞌ gula, canaꞌ guca bezaꞌ lao yuguluteyaquëꞌ. Begaꞌn nigula ituzinëꞌ ganꞌ zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Caora bezuli Jesús, blëꞌënëꞌ nuranu yaca benëꞌ dyilaꞌ. Biz̃i ituzi nigula begaꞌn ganꞌ zë Jesús. Naꞌra una Jesús rëbinëꞌ nigula: ―Nigula, ¿ganaz̃i yaca benꞌ rao luëꞌ xquia? ¿Quele nitu nitu nunu ichugobëꞌ quioꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Biz̃i una nigula naꞌ rëbinëꞌ lëbëꞌ: ―Nunu ichugobëꞌ quiaꞌ, Señor. Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Nica nëꞌëdiꞌ biichugobiꞌa quioꞌ. Pues naꞌ beyo, bira huuꞌ bizinaquezi. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Unë Jesús tatula rëbinëꞌ yaca benëꞌ: ―Nacaꞌ ca quie tu guiꞌ ta useniꞌn quie yugulu benꞌ rda lao lato lao chula. Chi nu yaca benëꞌ nao nëꞌëdiꞌ, bitayaquëꞌ lao lato lao chula. Huadayaquëꞌ ga rseniꞌ xniꞌ guiꞌ, ga idzeleyaquëꞌ yelaꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Naꞌra una yaca benꞌ partido fariseo rëbiyaquëꞌ Jesús: ―Luëꞌ rnëloꞌ cule quioꞌ cuinzoꞌ. Ca diꞌidzaꞌ rnëloꞌ naꞌ bibizacaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Baꞌalaꞌcazi rniaꞌ cule quiaꞌ, pero zacaꞌ diꞌidzaꞌ rniaꞌ, danꞌ banezdaꞌ ganꞌ zaꞌa, banezdaꞌ ganꞌ yeyaꞌa. Pero ca naca leꞌe, nica nezizile ganꞌ zaꞌa, nica nezizile ganꞌ yeyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Leꞌe rchugobëꞌle cabëꞌ raca lao yedyi layu. Pero ca naca nëꞌëdiꞌ, nitu nitu nunu rchugobiꞌa quie. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero chi ichugobiꞌa quie benëꞌ, huaꞌ tu ta yuꞌu niꞌa xnezi danꞌ cala cuinzaꞌ ichugobiꞌa, ichugobëꞌlëcazaꞌ Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Luꞌu libro ga yuꞌu ley quiele, rnën quie chopa benꞌ naca testigo. Chi tuzi ca rnayaquëꞌ, lenaꞌ nacan tali cabëꞌ rnëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Biz̃i niaꞌ leꞌe, nëꞌëdiꞌ rniaꞌ cule quiaꞌ, lëzi rnërë Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ, cule quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¿Gaz̃i naoꞌ zu xuzoꞌ? Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Cabëꞌ leꞌe, binubëꞌle nëꞌëdiꞌ. Lëzi canaꞌ binubëꞌle Xuzaꞌ. Chi leꞌe nubëꞌle nëꞌëdiꞌ, lëzi canaꞌ huebëꞌrële Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Una Jesús canaꞌ tu nersëdinëꞌ yaca benëꞌ luꞌu idaoꞌ rnabëꞌra ga z̃uba tu caja ga rudzeꞌyaquëꞌ gun. Pero nituyaquëꞌ bibeyaz̃oyaquëꞌ guxoyaquëꞌ lëbëꞌ, danꞌ binedyin hora idyinnëꞌ lao naꞌa yaca benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Una Jesús tatula rëbinëꞌ leyaquëꞌ: ―Nëꞌëdiꞌ hueyaꞌa guibá ga uzaꞌa. Leꞌe hueguilole nëꞌëdiꞌ, pero huatile du nao dulaꞌ xquia quiele leꞌe. Nitule bisaqueꞌ yezaꞌle ganꞌ yeyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Naꞌra una yaca benꞌ Israel rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Cala gutinëꞌ cuinnëꞌ? ¿Cala lenaꞌ danꞌ unanëꞌ: “Bisaqueꞌ yezaꞌle ganꞌ yeyaꞌa”? ");
INSERT INTO zpcNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Leꞌe zaꞌle lao yedyi layu niga, pero nëꞌëdiꞌ nacaꞌ benꞌ zaꞌ guibá. Leꞌe nacale quie benꞌ lao yedyi layu niga, pero nëꞌëdiꞌ binacaꞌ quie benꞌ lao yedyi layu niga. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tanaꞌ lenaꞌ rniaꞌ leꞌe, huatile du nao dulaꞌ xquia quiele leꞌe. Huatile conlë dulaꞌ xquia quiele chi biralele ca niaꞌ nu nacaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Naꞌra unayaquëꞌ rëbiyaquëꞌ Jesús: ―¿Nuz̃i nacoꞌ luëꞌ? Naꞌ una Jesús: ―Desde dza naꞌte, baoniaꞌ leꞌe nu nacaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tazë de ta iniaꞌ leꞌe, lëzi tazë de ta ichuguliaꞌ quiele leꞌe. Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ, rnëguëꞌ puro diꞌidzaꞌ naca li. Ca diꞌidzaꞌ baoniaꞌ leꞌe, lëdiꞌidzaꞌ naꞌ bedaꞌ una Xuzaꞌ nëꞌëdiꞌ. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero naꞌ yaca benꞌ biuyoñeꞌeyaquëꞌ cati unë Jesús quie Xuzinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tanaꞌ lenaꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Cati baolisale nëꞌëdiꞌ sibi, nëꞌëdiꞌ bichi yugulu benëꞌ, lëcanaꞌ inezile nuz̃i nacaꞌ. Lëzi inezirële cala ta racazi laꞌadyaꞌ ruaꞌ, denꞌ rnëcazaꞌ ca ta bzioñeꞌe Xuzaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ, zulëcazëꞌ nëꞌëdiꞌ tuz̃e. Birsannëꞌ nëꞌëdiꞌ zuaꞌ tuzaꞌ, danꞌ ruzucazaꞌ diꞌidzaꞌ cabëꞌ rnanëꞌ. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ca be yaca benëꞌ ca una Jesús, caora naꞌ gule yaca benꞌ zë quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Biz̃i una Jesús rëbinëꞌ yaca benꞌ Israel con bala yaca benꞌ rale quienëꞌ: ―Chi leꞌe naole hue quiele canꞌ rniaꞌ leꞌe, nacacazile benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Lenaꞌ huanezcazile nacan tali ta una Diuzi. Lenaꞌ danꞌ gacale libre. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Nëtoꞌ nacandoꞌ z̃iꞌisuba Abraham. Desde dza naꞌte banacandoꞌ libre. ¿Cómo luëꞌ naoꞌ gacandoꞌ libre? ");
INSERT INTO zpcNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tali ca rniaꞌ, nu benꞌ rue xquia, naca quieyaquëꞌ ca quie benꞌ nadaꞌo. Naca xquia quieyaquëꞌ ca quie xaꞌnyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nu benꞌ nadaꞌo, binaquëꞌ familia quie xaꞌnnëꞌ. Pero nu z̃iꞌi xaꞌnnëꞌ, nacacazibiꞌ familia quie xaꞌne. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chi yez̃i z̃iꞌi Diuzi xquia quiele, talicazi nacale libre. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Banezdaꞌ leꞌe nacale benꞌ z̃iꞌisuba Abraham, pero reꞌenle gutile nëꞌëdiꞌ, danꞌ rsebiꞌle diꞌidzaꞌ rniaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nëꞌëdiꞌ rniaꞌ cabëꞌ una Xuzaꞌ nëꞌëdiꞌ. Pero naꞌ leꞌe ruzule diꞌidzaꞌ cabëꞌ mandado rue benꞌ naca xuzile leꞌe. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Naꞌra unayaquëꞌ rëbiyaquëꞌ Jesús: ―Abraham naquëꞌ xuzindoꞌ. Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Chi nacale dugalo z̃iꞌi Abraham, huerële canꞌ bënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Baꞌalaꞌcazi aoniaꞌ leꞌe diꞌidzaꞌ li ca ta una Diuzi nëꞌëdiꞌ, naꞌ leꞌe reꞌenle gutile nëꞌëdiꞌ. Bibë Abraham canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Leꞌe ruele laga ca rue benꞌ naca xuzile. Naꞌra unayaquëꞌ rëbiyaquëꞌ Jesús: ―Binacandoꞌ z̃iꞌi benꞌ tula. Tuzi Diuzi naquëꞌ xuzindoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Chi tali naca Diuzi xuzile, huadyëꞌële nëꞌëdiꞌ danꞌ uzaꞌ ga zu Diuzi. Cala bidaꞌ ta racazi laꞌadyaꞌ, denꞌ bidaꞌ tanun quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Bixquienꞌ bireꞌenle yele con ca rniaꞌ? Pues niaꞌ leꞌe, birele danꞌ bireꞌenle hue quiele con ca rniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Xanꞌ taxiꞌibiꞌ naca xuzile. Lenaꞌ danꞌ reꞌenle huerële cabëꞌ ruenan. Desde canaꞌte rutinan benëꞌ, biruenan tali. Ca pensari yuꞌu laxtaꞌonan, canaꞌ rziꞌnan yëꞌ. Nacanan benꞌ huiziꞌ yëꞌ. Nacarënan xuzi yugulu benꞌ huiziꞌ yëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Danꞌ rniaꞌ leꞌe ta naca tali, ta yuꞌu niꞌa xnezi, quie lenaꞌ bireꞌenle galele quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Nuz̃i leꞌe ulenacara chi nëꞌëdiꞌ de dulaꞌ quiaꞌ? Chi rniaꞌ ta naca tali, ¿bixquienꞌ biralele quiaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nu benꞌ naca quie Diuzi, uzënagayaquëꞌ xtiꞌidzaꞌ Diuzi. Pero leꞌe, danꞌ binacale benꞌ quie Diuzi, lenaꞌ bireꞌenle uzënagale hue quiele xtiꞌidzaꞌ Diuzi. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Naꞌra una yaca benꞌ Israel rëbiyaquëꞌ Jesús: ―¿Cala tali rnandoꞌ nacoꞌ benꞌ samaritano bayuꞌuloꞌ bichi be xiꞌibiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Biyuꞌa bichi be xiꞌibiꞌ. Ca ta ruaꞌ, ruaꞌ Xuzaꞌ benꞌ z̃e. Naꞌ biz̃i leꞌe, rutasi runiole nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nëꞌëdiꞌ bihuaꞌ cuinaꞌ benꞌ z̃e, pero zucazi benꞌ rue nëꞌëdiꞌ benꞌ z̃e. Lëbëꞌ ichugobëꞌnëꞌ quiele. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tali ca rniaꞌ leꞌe, chi nu yaca benꞌ hue quie diꞌidzaꞌ rniaꞌ, bigaticazinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Naꞌra una yaca benꞌ Israel rëbiyaquëꞌ lëbëꞌ: ―Baguquelindoꞌ yuꞌucazoꞌ bichi be xiꞌibiꞌ. Pues Abraham len yaca benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi, gutiyaquëꞌ. Naꞌ biz̃i luëꞌ naoꞌ: “Chi nu yaca benëꞌ hue quie diꞌidzaꞌ rniaꞌ, bigaticazinëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Nacaroꞌ luëꞌ benꞌ z̃e ca xuzixtaꞌondoꞌ Abraham? Lëbëꞌ gutinëꞌ, lëzirë gutirë yaca los demás benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi, naꞌa ¿ca nuz̃i naoꞌ nacoꞌ luëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Chi ruaꞌ cuinaꞌ benꞌ z̃e, bibi zacaꞌn ca niaꞌ. Pero Xuzaꞌ, benꞌ nale naca Diuzi quiele, lënëꞌ ruenëꞌ nëꞌëdiꞌ benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nëꞌëdiꞌ niaꞌ leꞌe binubëꞌle lëbëꞌ, pero nëꞌëdiꞌ sí, nubëꞌdaꞌ lëbëꞌ. Chi inaro de que niaꞌ binubëꞌdaꞌ lëbëꞌ, lenaꞌ nacariaꞌ benꞌ huiziꞌ yëꞌ ca leꞌe. Pero biiniaꞌ canꞌ, como danꞌ nacan tali nubëꞌdaꞌ lëbëꞌ, ruzuaꞌ diꞌidzaꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bedaohue xuzixtaꞌole Abraham dza blëꞌënëꞌ bdyinaꞌ yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Naꞌra una yaca benꞌ Israel rëbiyaquëꞌ Jesús: ―Binedyinloꞌ gatzo gayuhua iza, ¿cómo luëꞌ naoꞌ blëꞌëloꞌ xuzixtaꞌondoꞌ Abraham? ");
INSERT INTO zpcNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tali ca rniaꞌ leꞌe, tu binegalo xuzixtaꞌole Abraham, bazucazaꞌ nëꞌëdiꞌ. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Biz̃i naꞌ uz̃iꞌyaquëꞌ yo guꞌunyaquëꞌ quiyaquëꞌn Jesús. Naꞌ ubiguëꞌ tzalaꞌla luꞌu idaoꞌ rnabëꞌra beroguëꞌ bedenëꞌ zioguëꞌ ladoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ganꞌ uz̃iꞌ Jesús zionëꞌ blëꞌënëꞌ tu benꞌ laochulacazi nacatëꞌ gologuëꞌ naquëꞌ xcuidiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Naꞌra una yaca benꞌ quie Jesús rëbiyaquëꞌ lëbëꞌ: ―Maestro, ¿bixquienꞌ golo benꞌ niga nechula laohuëꞌ? ¿Nu quie dulaꞌ xquia guca laohuëꞌ canꞌ? ¿Idulaꞌ xquia quie xuzëꞌ, o chi dulaꞌ xquia quie cuinzëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Naꞌra una Jesús rëbinëꞌ yaca benꞌ quiëꞌ: ―Cala gucan quie dulaꞌ xquia quie cuinzëꞌ, ni quele dulaꞌ xquia quie xuzinëꞌ. Gucan canꞌ tacuenda inezi yaca benëꞌ cabëꞌ hue Diuzi yelaꞌ huaca quienëꞌ gacalënëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Naꞌ niaꞌ leꞌe naꞌa te dza naca baguin racaten dyabëꞌ huaꞌ dyin quie Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ. Cati baodzeꞌ, nuranu saqueꞌ hue dyin. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tu raca zuaꞌ lao yedyi layu, nacaꞌ ca quie guiꞌ rseniꞌn ga naca chula ta ilëꞌë yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ude beyudyi una Jesús canaꞌ, uruꞌunëꞌ z̃enꞌ layu, bënëꞌ ledaoꞌ gunꞌ conlë z̃enꞌ quienëꞌ. Ude naꞌ uz̃iꞌnëꞌn blëpinëꞌn lao benꞌ laochula. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Naꞌra una Jesús rëbinëꞌ benꞌ laochula: ―Uyo yetibi laoloꞌ luꞌu pozo nisa lao Siloé, ta inaro xtiꞌidzaꞌro: Pozo nisa quie benꞌ uyo lao laza benꞌ tula. Biz̃i uyo benꞌ laochula yetibinëꞌ laohuëꞌ, naꞌ biz̃i bedyinnëꞌ z̃an yuꞌu quienëꞌ baoyalo laohuëꞌ barlëꞌënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Naꞌra yaca benꞌ nitaꞌ gaꞌalaꞌ ga zu benꞌ abeyalo laohue, len yacara los demás benꞌ tula, benꞌ bezaque chi lënëꞌ requeꞌnëꞌ rnabëꞌ gun, caora naꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Cala benꞌ niga requeꞌ rnaba gun yugu dza? ");
INSERT INTO zpcNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bala yaca benëꞌ unayaquëꞌ: ―Lëlëbëꞌ. Ibalayaquëꞌ unayaquëꞌ: ―Lëbëꞌ raquero. Pero biz̃i cuincazi benꞌ beyalo laohue unëꞌ: ―Lënëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Naꞌra unabayaquëꞌ lëbëꞌ: ―¿Biz̃i baoꞌ ta belëꞌëloꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naꞌra bequëbinëꞌ rëbinëꞌ leyaquëꞌ: ―Lëbenꞌ lao Jesús bënëꞌ gunꞌ blëpinëꞌn laohuaꞌ. Bëꞌ beyudyi blëpinëꞌ gunꞌ laohuaꞌ, naꞌra unëꞌ nëꞌëdiꞌ: “Uyo yetibi laoloꞌ luꞌu pozo nisa lao Siloé.” Biz̃i naꞌ uyaꞌa yetibaꞌ laohuaꞌ, canaꞌ gucaꞌ barlëꞌëdaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Naꞌra unabayaquëꞌ lënëꞌ: ―¿Ganaz̃i benꞌ naoꞌ canaꞌ? Naꞌra unëꞌ: ―Binezdaꞌ gala zionëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Naꞌra uquiëꞌyaquëꞌ benꞌ beyalo laohue psedyinyaquëꞌ lëbëꞌ ganꞌ nitaꞌ yaca benꞌ partido fariseo. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Canaꞌ bëyaquëꞌ, danꞌ beyue Jesús laohue benꞌ naꞌ dza saodo, dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Naꞌra pquëpiyaquëꞌ benꞌ beyalo laohue ca guca danꞌ belëꞌënëꞌ. Cani unëꞌ rëbinëꞌ leyaquëꞌ: ―Blëpiguëꞌ gunꞌ laohuaꞌ. Ude naꞌ uyaꞌa yetibaꞌn. Canaꞌ guca belëꞌëdaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Naꞌra una bala yaca benꞌ partido fariseo: ―Benꞌ naoꞌ bë canꞌ, binaquëꞌ benꞌ quie Diuzi, danꞌ bibënëꞌ bala dza huezilaꞌadyiꞌ quiero. Naꞌ biz̃i ibalayaquëꞌ unayaquëꞌ: ―Chi naquëꞌ benꞌ napa dulaꞌ xquia, ¿cabiz̃i guca bënëꞌ yelaꞌ huaca ta belëꞌë benꞌ niga? Canaꞌ guca unëyaquëꞌ diꞌidzaꞌ udeudela. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Naꞌra unayaquëꞌ rëbiyaquëꞌ benꞌ beyalo laohue: ―¿Cabiz̃i naoꞌ luëꞌ quie benꞌ naoꞌ beyue laoloꞌ? Naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ―Nëꞌëdiꞌ rniaꞌ naquëꞌ benꞌ useꞌelaꞌ Diuzi. ―Canaꞌ unëꞌ rëbinëꞌ yaca benꞌ partido fariseo. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero bigulecaziyaquëꞌ chi tali guquëꞌ benꞌ laochula. Naꞌ tacuenda yezacalao bi guca quienëꞌ, guz̃iyaquëꞌ xuzi z̃naꞌ benꞌ beyalo laohue. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Naꞌra unabayaquëꞌ xuzi z̃naꞌ benꞌ naꞌ rëbiyaquëꞌ leyaquëꞌ: ―¿Z̃iꞌile ni unale nechula laonëꞌ cati uzutenëꞌ? Chi nale nechula laonëꞌ, ¿cómo barlëꞌënëꞌ naꞌa? ");
INSERT INTO zpcNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Naꞌ biz̃i unayaquëꞌ rëbiyaquëꞌ leyaquëꞌ: ―Nandoꞌ z̃iꞌindoꞌ. Nezindoꞌ desde bdaoꞌtenëꞌ nechula laonëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Binezcazindoꞌ bi guca danꞌ barlëꞌënëꞌ. Nica nezizindoꞌ nu benꞌ bë ta belëꞌënëꞌ. Banacanëꞌ benꞌ huaca. Ulenabacaranëꞌ lënëꞌ. Huananëꞌ cuinnëꞌ bi guca quienëꞌ danꞌ barelëꞌënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Canaꞌ una xuzi z̃naꞌ benꞌ beyalo laohue, danꞌ rdzebiyaquëꞌ bi hue yaca benꞌ rnabëꞌ, como danꞌ banuz̃iꞌa yaca benꞌ rnabëꞌ bihueꞌyaquëꞌ lato tzuꞌu benꞌ luꞌu idaoꞌ sinagoga, benꞌ rale quie Jesús naquëꞌ benꞌ Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tanaꞌ lenaꞌ unayaquëꞌ rëbiyaquëꞌ yaca benꞌ rnabëꞌ: “Banaquëꞌ benꞌ huaca. Ulenabacaranëꞌ lënëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Biz̃i yaca benꞌ rnabëꞌ guz̃iyaquëꞌ tatula benꞌ beyalo laohue, unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Tali una nëtoꞌ, danꞌ huecazi Diuzi ca inaoꞌ. Biz̃i nëtoꞌ banezindoꞌ benꞌ naꞌ naquëꞌ benꞌ de dulaꞌ xquia quie. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naꞌra una benꞌ beyalo laohue rëbinëꞌ leyaquëꞌ: ―Binezicazidaꞌ chi naquëꞌ benꞌ de dulaꞌ xquia quie, o chi bede dulaꞌ xquia quienëꞌ. Zelao naꞌ ta nezdaꞌ, gucaꞌ benꞌ laochula, biz̃i naꞌa barelëꞌëdaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Lenaꞌ unabayaquëꞌ lëbëꞌ tatula: ―¿Biz̃i bënëꞌ quioꞌ danꞌ naoꞌ beyuenëꞌ luëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ―Baoniaꞌ leꞌe canꞌ bënëꞌ, pero bibi bala ruele quiaꞌ. ¿Bixquienꞌ rnabale nëꞌëdiꞌ tatula? ¿Cala reꞌenle inaorële lëbëꞌ, gacale benꞌ quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Biz̃i mazara bdzaꞌ yaca benꞌ rnabëꞌ lëbëꞌ rëbiyaquëꞌ lëbëꞌ: ―Luëꞌ naoloꞌ benꞌ naꞌ. Biz̃i nëtoꞌ naondoꞌ rzundoꞌ diꞌidzaꞌ ca una Moisés. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nëtoꞌ banezindoꞌ dyëꞌëdi ca bë Diuzi bëꞌlënëꞌ Moisés diꞌidzaꞌ. Pero quie benꞌ naꞌ, nica nezindoꞌ ga zaꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naꞌra unë benꞌ beyalo laohue rëbinëꞌ leyaquëꞌ: ―Nacan ta yebanero ca nale, nale binezile ga zaꞌnëꞌ. ¿Cómo binezile ga zaꞌ tu benꞌ guca beyuenëꞌ nëꞌëdiꞌ barlëꞌëdaꞌ naꞌa? ");
INSERT INTO zpcNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dyëꞌëdi neziro bire Diuzi yaca benꞌ napa dulaꞌ xquia. Con tuzi yaca benꞌ rionlaꞌadyiꞌ lëbëꞌ, yaca benꞌ rue quie xtiꞌidzëꞌ, lëjëꞌ re Diuzi quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Desde ureꞌte lao yedyi layu, nunu nehue cabëꞌ bë benꞌ niga, bënëꞌ ta yelëꞌë tu benꞌ laochulacazi nacatëꞌ gologuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Chi benꞌ naꞌ biuzaꞌnëꞌ tzionëꞌ lao Diuzi, bibi de huenëꞌ cuinzinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Naꞌra una yaca benꞌ partido fariseo rëbiyaquëꞌ lëbëꞌ: ―Yelaꞌ benꞌ mala quioꞌ nacoꞌ canꞌ gololoꞌ. ¿Naꞌ como luëꞌ reꞌenloꞌ yexiꞌidzeꞌloꞌ nëtoꞌ uzioñeꞌeloꞌ nëtoꞌ? Canꞌ guca ulioyaquëꞌ lëbëꞌ luꞌu idaoꞌ sinagoga. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Biz̃i Jesús unezinëꞌ ulio yaca benꞌ partido fariseo benꞌ baoyalo laohue luꞌu idaoꞌ sinagoga. Naꞌ bedila Jesús lëbëꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―¿Raleloꞌ quie benꞌ naca z̃iꞌi Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Naꞌra una benꞌ baoyalo laohue rëbinëꞌ Jesús: ―Señor, una nu benꞌ naꞌ tacuenda galedaꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Nëꞌëdiꞌ, benꞌ ruꞌelë luëꞌ diꞌidzaꞌ, nacaꞌ benꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Caora naꞌ uditzo z̃ibinëꞌ lao Jesús rëbinëꞌ lëbëꞌ: ―Baraledaꞌ quioꞌ, Señor. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Naꞌ biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Nëꞌëdiꞌ bidaꞌ lao yedyi layu ta huaꞌ juicio. Lëzirë bidaꞌ tacuenda yelëꞌë yaca benꞌ birlëꞌë. Pero quie yaca benꞌ bireꞌen gale quiaꞌ, bidaꞌ ta yechula laohueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Biz̃i bala yaca benꞌ partido fariseo nitaꞌyaquëꞌ gaꞌalaꞌ ga zë Jesús, bëꞌ beyaquëꞌ canꞌ unanëꞌ, naꞌtera unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¿Biz̃i ca naoꞌ? ¿Nacarëndoꞌ benꞌ laochula? ");
INSERT INTO zpcNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Chi tali binezile bi ruele, bide dulaꞌ xquia quiele. Pero como dyëꞌëdi banezile bi ruele, lenaꞌ decazi dulaꞌ xquia quiele. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Tali ca rniaꞌ leꞌe, nu benꞌ bitzuꞌu ruꞌa corrale ga yuꞌu becoꞌ z̃iꞌilaꞌ, denꞌ negachiꞌ ruꞌunëꞌ xcuꞌudzule, lëbenꞌ naꞌ naquëꞌ benꞌ uban, benꞌ reꞌen cuan becoꞌ z̃iꞌilaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Benꞌ ruꞌu ruꞌa corrale, ga yuꞌu becoꞌ z̃iꞌilaꞌ, lëbenꞌ naꞌ naquëꞌ dugalo benꞌ rapa becoꞌ z̃iꞌilaꞌ, benꞌ naca xaꞌmbaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Benꞌ rapa ruꞌa corrale, rsaloguëꞌ ruꞌa corrale ta tzuꞌu benꞌ rapa becoꞌ z̃iꞌilaꞌ, benꞌ naca xaꞌmbaꞌ. Biz̃i rezaque yaca becoꞌ z̃iꞌilaꞌ xchiꞌ benꞌ rapa lëbaꞌ, benꞌ naca xaꞌmbaꞌ. Rëz̃iguëꞌ tu tubaꞌ según cabëꞌ laobaꞌ quie quiejabaꞌ ta cuioguëꞌbaꞌ luꞌu corrale. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Rde reyudyi rbioguëꞌ lao yugulutebaꞌ, naꞌ rebialao benꞌ rapa lëbaꞌ laoyacabaꞌ. Biz̃i leyacabaꞌ yenaoyacabaꞌ benꞌ rapa lëbaꞌ, benꞌ naca xaꞌmbaꞌ danꞌ rezaqueyacabaꞌ xchiꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero binaoyacabaꞌ benꞌ binubëꞌyacabaꞌ. Huaz̃unoyacabaꞌ lëbëꞌ, danꞌ binubëꞌyacabaꞌ xchiꞌnëꞌ. Rezaqueyacabaꞌ cala benꞌ rapa lëbaꞌ, benꞌ naca xaꞌmbaꞌ. ―Canaꞌ una Jesús rëbinëꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Lëtu diꞌidzaꞌ ni gudyi Jesús yaca benëꞌ, pero biz̃i biuyoñeꞌejëꞌ bi na diꞌidzaꞌ una Jesús quie xaꞌn becoꞌ z̃iꞌilaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Naꞌra una Jesús tatula rëbinëꞌ leyaquëꞌ: ―Tali ca rniaꞌ leꞌe, nëꞌëdiꞌ nacaꞌ ca quie ruꞌa corrale ga ruꞌu yaca becoꞌ z̃iꞌilaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yaca benꞌ babida caora bineguidaꞌ, guꞌunyaquëꞌ cuanyaquëꞌ yaca becoꞌ z̃iꞌilaꞌ. Pero biz̃i yaca becoꞌ z̃iꞌilaꞌ bibëyacabaꞌ bala inaoyacabaꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Danꞌ nacaꞌ ca quie ruꞌa corrale, lenaꞌ con nu yaca benꞌ tzuꞌu ruꞌa corrale ganꞌ zuaꞌ, lëlëyaca benꞌ naꞌ gataꞌ yelaꞌ neban quiejëꞌ tuzioli. Huaca quieyaquëꞌ ca quie yaca becoꞌ z̃iꞌilaꞌ ruꞌu rero luꞌu corrale ga de guiz̃i yaꞌa ta gaoyacabaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Rida yaca benꞌ uban ta cuanyaquëꞌ gutiyaquëꞌ udyiaguiꞌyaquëꞌ yaca benëꞌ. Pero bidaꞌ nëꞌëdiꞌ ta gataꞌcazi yelaꞌ neban quieyaquëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nëꞌëdiꞌ nacaꞌ dugalo benꞌ rapa becoꞌ z̃iꞌilaꞌ, benꞌ naca xaꞌmbaꞌ. Zuaꞌ puesto gatiaꞌ tacuenda bicuiaguiꞌyacabaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero nu benꞌ rue dyin de laz̃o, cati ilëꞌënëꞌ zaꞌ lobo, caora naꞌ iz̃unoguëꞌ ucaꞌnnëꞌ yaca becoꞌ z̃iꞌilaꞌ, danꞌ binaquëꞌ dugalo benꞌ rapa becoꞌ z̃iꞌilaꞌ, benꞌ naca xaꞌmbaꞌ. Binacayacabaꞌ bia quienëꞌ. Canaꞌ gaca guida lobo guxubaꞌ utzatzabaꞌ yaca becoꞌ z̃iꞌilaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pero benꞌ binaca xaꞌmbaꞌ rueguëꞌ dyin de laz̃o, lenaꞌ uz̃unoguëꞌ bibi cuenda huenëꞌ quie yaca becoꞌ z̃iꞌilaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Nëꞌëdiꞌ nacaꞌ dugalo benꞌ rapa becoꞌ z̃iꞌilaꞌ, benꞌ naca xaꞌmbaꞌ. Cabëꞌ Xuzaꞌ nubëꞌnëꞌ nëꞌëdiꞌ, canaꞌ nubëꞌdaꞌ Xuzaꞌ. Lëzirë cabëꞌ nubëꞌdaꞌ yaca benꞌ naca ca quie becoꞌ z̃iꞌilaꞌ quiaꞌ, canaꞌ nubëꞌyaquëꞌ nëꞌëdiꞌ. Zuaꞌ puesto gatiaꞌ tacuenda bicuiaguiꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Lëzirë nitaꞌ yaca benꞌ tula nacarëyaquëꞌ ca quie becoꞌ z̃iꞌilaꞌ quiaꞌ. Bizuyaquëꞌ ni len nëꞌëdiꞌ. Lenaꞌ huatzaz̃iꞌayaquëꞌ guidayaquëꞌ ta sulëyaquëꞌ nëꞌëdiꞌ, danꞌ baraleyaquëꞌ quiaꞌ. Nacarëyaquëꞌ tuzi len yaca los demás benꞌ barale quiaꞌ. Canaꞌ iyacayaquëꞌ tu z̃ezi, naꞌ tuzaꞌ nëꞌëdiꞌ gacaꞌ xaꞌnyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Xuzaꞌ nedyëꞌënëꞌ nëꞌëdiꞌ danꞌ zuaꞌ puesto gatiaꞌ, te naꞌ yeziꞌa yelaꞌ neban quiaꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","’Nunu rzaqueꞌ guti nëꞌëdiꞌ chi bihuaꞌyaquëꞌ lato. Gusto quiaꞌ zuaꞌ puesto gatiaꞌ, te naꞌ yeziꞌa yelaꞌ neban quiaꞌ tatula. Canaꞌ mandado bë Xuzaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ude beyudyi be yaca benꞌ Israel ca una Jesús, naꞌtera unëyaquëꞌ udeudela. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yaca benꞌ zë unëyaquëꞌ quienëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Bixquienꞌ ruele bala rzënagale quienëꞌ? Yuꞌu bichi be xiꞌibiꞌ luꞌu laxtaꞌonëꞌ, naquëꞌ benꞌ loco. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Biz̃i ibalayaquëꞌ unayaquëꞌ: ―Nu benꞌ yuꞌu bichi be xiꞌibiꞌ, birnënëꞌ ca rnë benꞌ ni. ¿Quele, chi benꞌ yuꞌu bichi be xiꞌibiꞌ, bisaqueꞌnëꞌ yeyuenëꞌ benꞌ laochula ta yelëꞌënëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Biz̃i bdyin dza hue yaca benꞌ Israel lani ta yezaꞌlaꞌadyiꞌyaquëꞌ dza guca laꞌiya idaoꞌ rnabëꞌra quieyaquëꞌ. Biuꞌ bëyaquëꞌ lani, nacan biuꞌ zaga. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Uyuꞌu Jesús luꞌu idaoꞌ rnabëꞌra rdanëꞌ bago ruꞌa idaoꞌ neziꞌlaonan ruꞌa idaoꞌ Salomón. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Biz̃i yaca benꞌ rnabëꞌ quie benꞌ Israel uyëchoyaquëꞌ Jesús rnayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¿Bataz̃i iyudyi rutëbiloꞌ nëtoꞌ ca diꞌidzaꞌ inaoꞌ nëtoꞌ? Chi luëꞌ nacoꞌ benꞌ Cristo, una nëtoꞌ tu lasagazi. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Baoniaꞌ leꞌe, pero biralele. Ca naca yelaꞌ huaca babiaꞌ conlë Xuzaꞌ, lenaꞌ ruluꞌenan leꞌe nu nacaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero leꞌe biralele quiaꞌ, danꞌ binacale benꞌ naca becoꞌ z̃iꞌilaꞌ quiaꞌ ca ta baonëcazaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Biz̃i yaca benꞌ naca becoꞌ z̃iꞌilaꞌ quiaꞌ, rzënagayaquëꞌ diꞌidzaꞌ rniaꞌ. Nëꞌëdiꞌ nubëꞌdaꞌ leyaquëꞌ, canaꞌra guidayaquëꞌ inaoyaquëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nëꞌëdiꞌ huaꞌyaquëꞌ yelaꞌ neban tuzioli ta bicuiaguiꞌcaziyaquëꞌ. Nitu nitu nunu saqueꞌ cuba leyaquëꞌ lao naꞌa como danꞌ ");
INSERT INTO zpcNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Xuzaꞌ bënnëꞌ leyaquëꞌ nëꞌëdiꞌ. Nacara Xuzaꞌ benꞌ z̃era ca yaca benëꞌ. Nitu nitu nunu saqueꞌ cuba leyaquëꞌ lao naꞌa Xuzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Xuzaꞌ len nëꞌëdiꞌ nacandoꞌ tuz̃e. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Biz̃i yaca benꞌ rnabëꞌ quie benꞌ Israel, tatula uz̃iꞌyaquëꞌ yo, guꞌunyaquëꞌ quiyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero una Jesús rëbinëꞌ leyaquëꞌ: ―Zë lasa biaꞌ tadyaꞌa delante lao leꞌe conlë yelaꞌ huaca quie Xuzaꞌ. Chi biaꞌ tadyaꞌa, ¿bixquienꞌ reꞌenle quile nëꞌëdiꞌ yo? ");
INSERT INTO zpcNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Naꞌra unayaquëꞌ rëbiyaquëꞌ Jesús: ―Cala reꞌenndoꞌ quindoꞌ luëꞌ yo danꞌ babaoꞌ tadyaꞌa, pero danꞌ rnayaꞌloꞌ Diuzi ca rnaoꞌ. Benëꞌcazi nacoꞌ, naꞌ rueloꞌ cuinloꞌ ca Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Naꞌra una Jesús rëbinëꞌ yaca benꞌ rnabëꞌ: ―Lëꞌë guichi ga bzu Moisés diꞌidzaꞌ laꞌiya quie Diuzi, rguixogueꞌn ca una Diuzi rëbinëꞌ yaca benëꞌ cani: “Leꞌe nacale ca yaca diuzi.” ");
INSERT INTO zpcNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Canaꞌ una Diuzi quie yaca benꞌ uzënaga quienëꞌ unëꞌ rëbinëꞌ leyaquëꞌ: “Leꞌe nacale ca yaca diuzi.” Naꞌ biz̃i baneziro diꞌidzaꞌ licazi zun lëꞌë guichi laꞌiya quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Chi Diuzi ulioguëꞌ nëꞌëdiꞌ useꞌelaꞌnëꞌ nëꞌëdiꞌ lao yedyi layu niga, ¿bixquienꞌ leꞌe nale rnayaꞌ Diuzi danꞌ niaꞌ nacaꞌ z̃iꞌi Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Chi birzuaꞌ diꞌidzaꞌ cabëꞌ rna Xuzaꞌ nëꞌëdiꞌ, bigalecazile quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero chi rzuaꞌ diꞌidzaꞌ cabëꞌ rna Xuzaꞌ nëꞌëdiꞌ, ruen zi galele quiaꞌ por nun quie len tacuenda inezile tu lasagazi nacaliaꞌ Xuzaꞌ tuz̃e, lëscanꞌ nacalë Xuzaꞌ nëꞌëdiꞌ tuz̃e. ―Canaꞌ una Jesús rëbinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Biz̃i yaca benꞌ rnabëꞌ, tatula guꞌunyaquëꞌ guxuyaquëꞌ Jesús ta hueyaquëꞌ lëbëꞌ preso, pero aode ulanëꞌ lao naꞌa yaca benꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Biz̃i beyo Jesús tatula itzalaꞌ yao Jordán. Naꞌ begaꞌnnëꞌ ganꞌ bëꞌ Juan lao yaca benëꞌ dza naꞌte. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yaca benꞌ zë uyoyaquëꞌ yenaꞌyaquëꞌ Jesús. Naꞌra unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Baꞌalaꞌcazi bibë Juan yelaꞌ milagro, pero yugulu ca ta unëꞌ quie benꞌ niga nacan tali. ");
INSERT INTO zpcNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Naꞌra yaca benꞌ zë uyo ganꞌ zënëꞌ, guleyaquëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Naꞌ uzu tu benꞌ guca z̃hueꞌ, benꞌ lao Lázaro. Naquëꞌ benꞌ yedyi Betania lënëꞌ chopa zannëꞌ, María len Marta. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","LëMaría naꞌ uyonëꞌ dza naꞌte yelatonëꞌ aceite rlaꞌ z̃ixi z̃eo niꞌa Jesús. Ude naꞌ besebidyinëꞌn conlë guitzaꞌ guichonëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Canaꞌ guca useꞌelaꞌ rupa zan Lázaro tu benꞌ uyo ganꞌ zu Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―Señor, raca z̃hueꞌ Lázaro, benꞌ naca amigo quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bëꞌ be Jesús ca una benꞌ naꞌ, naꞌ unëꞌ rëbinëꞌ lëbëꞌ: ―Ca naca yelaꞌ hueꞌ racanëꞌ, bisuen gutin lëbëꞌ. Raca z̃hueꞌnëꞌ tacuenda uluꞌen ca naca yelaꞌ huaca quie Diuzi, lente yelaꞌ huaca quiaꞌ nëꞌëdiꞌ z̃iꞌi Diuzi. ―Canaꞌ una Jesús rëbinëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Baꞌalaꞌcazi nedyëꞌëtzegue Jesús Lázaro len Marta len z̃ilanëꞌ María, ");
INSERT INTO zpcNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","bilaoyotenëꞌ caora benëꞌ raca z̃hueꞌ Lázaro. Begaꞌnnëꞌ uzurëꞌ ichopa dza ganꞌ zuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Guca lao chopa dza unëꞌ rëbinëꞌ yaca benꞌ quienëꞌ: ―Uletzaꞌ tzioro tatula estado Judea. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Naꞌra una yaca benꞌ quie Jesús rëbiyaquëꞌ lëbëꞌ: ―Maestro, ta zaracagazi guꞌun yaca benꞌ quiyaquëꞌ luëꞌ yo ganꞌ naoꞌ tzioro. Naꞌ biz̃i luëꞌ, ¿reꞌenloꞌ tzioro tatula? ");
INSERT INTO zpcNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Nuꞌacazi chipchopa hora lao tu dza. Chi raꞌo rdaro te dza, bichaꞌoro danꞌ rseniꞌ xniꞌ obidza. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero chi raꞌo rdaro lao chula, decazide huachaꞌoro, danꞌ birseniꞌ xniꞌ obidza ilëꞌëro. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Te beyudyi una Jesús canaꞌ, naꞌra unëꞌ rëbinëꞌ yaca benꞌ quiëꞌ: ―Benꞌ amigo quiero Lázaro, barasinëꞌ, pero huayaꞌa usebiaꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Naꞌra una yaca benꞌ quienëꞌ rëbiyaquëꞌ lëbëꞌ: ―Señor, chi lëbëꞌ rasizinëꞌ, hueyacanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero unë Jesús canꞌ danꞌ baguti Lázaro, cala rasizinëꞌ. Biz̃i raque yaca benꞌ quienëꞌ de que rasizi Lázaro. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Naꞌra una Jesús dyëꞌëdi rëbinëꞌ leyaquëꞌ: ―Baguticazi Lázaro. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Redaohuedaꞌ danꞌ biuzuaꞌ naꞌ ta ilëꞌëdaꞌ cati guti Lázaro. Redaohuedaꞌ danꞌ cabëꞌ guca quienëꞌ nacan ta gacalën leꞌe ta galerale quiaꞌ nëꞌëdiꞌ. Pues naꞌ uletzaꞌ tzioro ganꞌ denëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Biz̃i Tomás, benꞌ uxubayaquëꞌ laohue benꞌ guidiꞌ, unëꞌ gudyinëꞌ laguedyinëꞌ, benꞌ quie Jesús: ―Uletzaꞌ tziolëronëꞌ ta gatilëronëꞌ tzaz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Caora bdyin Jesús ganꞌ, bazio lao tapa dza babgachiꞌla Lázaro luꞌu beló yo. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yedyi Betania regaꞌn gaꞌalaꞌ ga reꞌ ciudad Jerusalén. Nacan chopa legua yugatzo. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Zë yaca benꞌ Israel uyoyaquëꞌ ganꞌ nitaꞌ Marta len María, reyuez̃eyaquëꞌ leyaquëꞌ danꞌ guti zanyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bëꞌ be Marta bazaꞌ Jesús, naꞌ uyoguëꞌ yelezanëꞌ lëbëꞌ. Pero María begaꞌnnëꞌ z̃an yuꞌu quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Naꞌra una Marta rëbinëꞌ Jesús: ―Señor, chanꞌ zucaloꞌ laoꞌ nëtoꞌ niga, beyaca Lázaro zanndoꞌ, bigutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nezdaꞌ yugulu ta inaboꞌ Diuzi, guncazinëꞌn luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Biꞌ zanle huebannëꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Naꞌ bequëbi Marta rëbinëꞌ Jesús: ―Banezdaꞌ hueban biꞌ zanaꞌ dza iyudyi lao yedyi layu, dza yeban yugulu yaca benꞌ baguti. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Nëꞌëdiꞌ nacaꞌ benꞌ useban yaca benꞌ huati, yeyuꞌayaquëꞌ yelaꞌ neban tatula. Con nu benëꞌ gale quiaꞌ, baꞌalaꞌcazi gatiyaquëꞌ, huebanyaquëꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Niaꞌ luëꞌ yaca benꞌ neban, yaca benꞌ rale quiaꞌ, tuzioli bitziojëꞌ lao guiꞌ gabila. ¿Baguleloꞌ canꞌ baoniaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Naꞌra una Marta rëbinëꞌ Jesús: ―Señor, raledaꞌ quioꞌ luëꞌ nacoꞌ benꞌ Cristo, z̃iꞌi Diuzi. Luëꞌ nacoꞌ benꞌ una Diuzi iseꞌelaꞌnëꞌ lao yedyi layu. ―Canaꞌ unëꞌ rëbinëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ude beyudyi una Marta canꞌ, uzëꞌë yeguëdyinëꞌ benꞌ z̃ilanëꞌ María. Unëꞌ diꞌidzaꞌ balanzi rëbinëꞌ lëbëꞌ: ―Bazaꞌ Maestro, guëz̃inëꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ca be María ca una Marta, laozaꞌtenëꞌ zionëꞌ ganꞌ zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Binetzuꞌu Jesús laꞌo yedyi. Tu neza nenitaꞌlënëꞌ yaca benꞌ quiëꞌ ga bedilanëꞌ Marta. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yaca benꞌ bdyin z̃an yuꞌu, caora blëꞌëyaquëꞌ uzuli María uzaꞌnëꞌ zionëꞌ taria, lëscanꞌ uz̃iꞌrëyaquëꞌ xnezayaquëꞌ zioyaquëꞌ naoyaquëꞌ lëbëꞌ. Guqueyaquëꞌ chi zionëꞌ cuedyinëꞌ ganꞌ pcachiꞌyaquëꞌ Lázaro. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Biz̃i cati bdyin María ganꞌ zë Jesús, uditzu z̃ibinëꞌ lao Jesús, unëꞌ rëbinëꞌ lëbëꞌ: ―Señor, chanꞌ zucaloꞌ laoꞌ nëtoꞌ niga, beyaca Lázaro zanndoꞌ, bigutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Biz̃i cati blëꞌë Jesús rbedyi María len yaca benꞌ zio nao lëbëꞌ, rdëbinëꞌ guca beyëchiꞌ luꞌu laxtaꞌonëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―¿Ga mero pcachiꞌlenëꞌ? Naꞌ biz̃i unayaquëꞌ: ―Señor, yaꞌ ilëꞌëloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Biz̃i naꞌ uredyi Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Naꞌra una yaca benꞌ ziorë nao: ―Ulenaꞌ, lega nedyëꞌënëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Biz̃i bala yaca benꞌ ziolë leyaquëꞌ unayaquëꞌ: ―Benꞌ niga bënëꞌ ta belëꞌë benꞌ birlëꞌë, ¿cómo naꞌ bibi bënëꞌ ta iyaca Lázaro ta bigatinëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Biz̃i Jesús racatzeguenëꞌ beyëchiꞌ tatula. Naꞌ ubigaꞌnëꞌ bago ruꞌa beló yo ganꞌ pcachiꞌyaquëꞌ Lázaro. Naꞌ daꞌ tu yo z̃e ruꞌa beló. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Lenaꞌ una Jesús rëbinëꞌ leyaquëꞌ: ―Ulecuba yo daꞌ ruꞌa beló. Biz̃i Marta, zan benꞌ huati, unëꞌ rëbinëꞌ Jesús: ―Señor, bazio lao tapa dza gutinëꞌ, barlaꞌnëꞌ zigo. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―¿Cala baoniaꞌ luëꞌ, chi raleloꞌ canꞌ baoniaꞌ, hualëꞌëloꞌ hue Diuzi yelaꞌ huaca quienëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Caora naꞌ udubayaquëꞌ yo daꞌ ruꞌa beló. Biz̃i naꞌ unaꞌ Jesús sibi ladza, blidzanëꞌ Diuzi: ―Xuzaꞌ, diuxcaleloꞌ danꞌ reloꞌ cati niaꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nezcazidaꞌ reloꞌ cati rniaꞌ luëꞌ. Pero por nun quie yaca benꞌ nitaꞌ niga, lenaꞌ bëꞌliaꞌ luëꞌ diꞌidzaꞌ zaquëꞌlao laoyaquëꞌ tacuenda uzënagayaquëꞌ ineziyaquëꞌ luëꞌ useꞌeloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ude beyudyi unë Jesús canꞌ, naꞌ unëꞌ zidzo unëꞌ: ―Lázaro, bero ganꞌ deloꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Caora naꞌ bero Lázaro ganꞌ denëꞌ. Nedubi laꞌariꞌ naꞌanëꞌ len niꞌanëꞌ. Lëzi bdaco laꞌariꞌ laohuëꞌ. Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Ulexëdyi laꞌariꞌ dubi naꞌanëꞌ len niꞌanëꞌ. Ulesannëꞌ yeyoguëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yaca benꞌ ziolë María ganꞌ, blëꞌëyaquëꞌ cabëꞌ bë Jesús besebannëꞌ Lázaro. Lëcanaꞌ yaca benꞌ zë guleyaquëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Biz̃i balayaquëꞌ uyoyaquëꞌ yetixogueꞌyaquëꞌ yaca benꞌ partido fariseo cabëꞌ bë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Naꞌra yaca benꞌ partido fariseo len yaca xanꞌ pxuzi bedupayaquëꞌ bëyaquëꞌ junta len yaca los demás benꞌ rnabëꞌ. Naꞌra unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Ca biz̃i huero quie benꞌ naꞌ? Lega ruenëꞌ yelaꞌ huaca ta binelëꞌëro. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Chi hueꞌroguëꞌ lato tanëꞌ huenëꞌ canꞌ, naꞌ huanao yaca benꞌ zë lënëꞌ. Biz̃i huadzaꞌ yaca benꞌ rnabëꞌ quie benꞌ romano, huaseꞌelaꞌyaquëꞌ soldado udyiaguiꞌyaquëꞌ idaoꞌ rnabëꞌra quiero lente ciudad quiero. ―Canaꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Biz̃i benꞌ naca xanꞌ pxuzi lëiza naꞌ, benꞌ lao Caifás, unëꞌ gudyinëꞌ leyaquëꞌ: ―Leꞌe netondole ca diꞌidzaꞌ rnale. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nica nenezile nacaran dyaꞌa quiero gati tuzi benëꞌ lao laza yaca benꞌ yedyi, cala ca ta gati yuguluro. ―Canaꞌ una Caifás. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Danꞌ lëiza naꞌ nacanëꞌ xanꞌ pxuzi unëꞌ canꞌ. Pero cala cuenta quienëꞌ unëꞌ canꞌ. Biunezinëꞌ unëꞌ cuenta quie Diuzi cati unëꞌ gati Jesús lao laza yaca benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pero cala tuzi lao laza benꞌ Israel gati Jesús, lëscanꞌ gati Jesús lao laza yugulu yaca benꞌ gale quienëꞌ, yaca benꞌ nedzatza nitaꞌ yaca yedyi tula. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Lëdza naꞌ psaque yaca benꞌ rnabëꞌ quie benꞌ Israel ca hueyaquëꞌ gutiyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Canaꞌ guca bira uda Jesús zaquëꞌlao len yaca benꞌ Israel. Tanaꞌ uzëꞌë estado Judea zioguëꞌ yedyi lao Efraín ga nacan gaꞌalaꞌ lao lato ga bidyia yuꞌu. Lëganꞌ naꞌ begaꞌnlënëꞌ yaca benꞌ quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Baruen bago ta hueyaquëꞌ lani ta rezaꞌlaꞌadyiꞌyaquëꞌ quie xuzixtaꞌoyaquëꞌ caora broyaquëꞌ nación Egipto. Tanaꞌ lenaꞌ yaca benꞌ zë, yaca benꞌ yedyi, uzaꞌyaquëꞌ zioyaquëꞌ ciudad Jerusalén ta yeyëriyaquëꞌ cuinyaquëꞌ lao Diuzi según costumbre quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Naꞌra yaca benꞌ naꞌ rdayaquëꞌ reguiloyaquëꞌ Jesús. Caora rioyaquëꞌ luꞌu idaoꞌ rnabëꞌra, naꞌ unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Biz̃i raquele? ¿Huida Jesús lani, o chi biguidanëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Canaꞌ guca bë yaca benꞌ partido fariseo len yaca xanꞌ pxuzi mandado gudyiyaquëꞌ benëꞌ con nu yaca benꞌ ilëꞌë Jesús laquixogueꞌteyaquëꞌ leyaquëꞌ tacuenda guxuyaquëꞌ lëbëꞌ hueyaquëꞌ lëbëꞌ preso. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Zaidyinla lao xopa dza gaꞌalaꞌ lani cati rezaꞌlaꞌadyiꞌyaquëꞌ quie xuzixtaꞌoyaquëꞌ. Caora naꞌ uzaꞌ Jesús uyoguëꞌ yedyi Betania ganꞌ zu Lázaro, benꞌ baguti, pero beseban Jesús lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lëganꞌ naꞌ psiñaꞌayaquëꞌ yelaꞌ huao ta gapayaquëꞌ Jesús balaꞌana. Caora naꞌ bë Marta laze ta udaoyaquëꞌ, naꞌ udaorë Lázaro tuz̃e len leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Naꞌra uz̃iꞌ María gatzo litro aceite rlaꞌ z̃ixi z̃eo ta rbioyaquëꞌ yo lao nardo. Lëaceite naꞌ bibi nequixin, zacaꞌn zaꞌalaꞌ gula. Biz̃i naꞌ blëpinëꞌn niꞌa Jesús, naꞌ uz̃iꞌnëꞌ guitzaꞌ guichonëꞌ blaꞌonëꞌn aceite laꞌo niꞌa Jesús. Canaꞌ bedu luꞌu yuꞌu ureꞌ be z̃eo gula. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Naꞌra una tu benꞌ quie Jesús laonëꞌ Judas Iscariote. Lëbëꞌ naquëꞌ z̃iꞌi tu benꞌ lao Simón. Naꞌ baꞌalaꞌcazi naquëꞌ benꞌ quie Jesús, lëlëbëꞌ usedyinnëꞌ Jesús lao naꞌa yaca benꞌ guti lëbëꞌ. Naꞌ una Judas rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Bixquienꞌ bibëtiꞌguëꞌ aceite rlaꞌ z̃ixi z̃eo, danꞌ zacaꞌn tzona gayuhua dumi denario tacuenda siꞌnëꞌ dumi quien hueꞌnëꞌn yaca benꞌ yëchiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Canaꞌ una Judas, pero bireyëchiꞌlaꞌadyiꞌnëꞌ quie yaca benꞌ yëchiꞌ. Rdëbinëꞌ quie dumi, danꞌ naquëꞌ benꞌ uban. Rapanëꞌ bolsa yuꞌu dumi tacuenda saqueꞌ cuannëꞌ dumi yuꞌu luꞌu bolsa naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Naꞌra una Jesús rëbinëꞌ Judas: ―Psan quienëꞌ. Pues baodyialaonëꞌ bënëꞌ quie dza gatiaꞌ igachaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nitaꞌcazi benꞌ yëchiꞌ lao yedyi layu yugu dza, pero nëꞌëdiꞌ, itu chopa dzazi zuliaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yaca benꞌ zë, yaca benꞌ Israel, caora uneziyaquëꞌ bazu Jesús yedyi Betania, uzaꞌyaquëꞌ uyoyaquëꞌ ganꞌ zunëꞌ. Uyoyaquëꞌ yenaꞌyaquëꞌ lëbëꞌ len Lázaro, benꞌ baguti, pero beseban Jesús lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Naꞌra yaca benꞌ xanꞌ pxuzi bapsaqueyaquëꞌ bi hueyaquëꞌ ta gutirëyaquëꞌ Lázaro. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Canaꞌ psaqueyaquëꞌ, danꞌ barale zë yaca benꞌ Israel quie Jesús por nun quie danꞌ psebannëꞌ Lázaro. Canaꞌ bira bë yaca benꞌ yedyi naꞌ tzaz̃e len yaca benꞌ rnabëꞌ quieyaquëꞌ, pero guleyaquëꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yaca benꞌ zë gula uyoyaquëꞌ ciudad Jerusalén ga raca lani ta rezaꞌlaꞌadyiꞌyaquëꞌ quie xuzixtaꞌoyaquëꞌ. Biz̃i bezu dza tula uneziyaquëꞌ huadyin Jesús lani ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Caora naꞌ uchugoyaquëꞌ laꞌagaꞌ palma ta biꞌayaquëꞌ yelezayaquëꞌ Jesús tu neza. Caora bedilayaquëꞌ lëbëꞌ unëyaquëꞌ zidzo: ―Benꞌ z̃e gula naca Diuzi. Naca laꞌiya benꞌ uzaꞌ lao xaꞌnro Diuzi. Naca laꞌiya rey quiero, benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Naꞌra zë tu burra ganꞌ zioguëꞌ. Naꞌ udyia Jesús lëbaꞌ con ca rguixogueꞌn lëꞌë guichi laꞌiya quie Diuzi cani: ");
INSERT INTO zpcNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Leꞌe benꞌ yedyi Sión, biidzebile. Ulenaꞌ bazaꞌ Rey quiele, bdyianëꞌ tu burro. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Dza naꞌla biuyoñeꞌe yaca benꞌ quie Jesús con ca rnën lëꞌë guichi laꞌiya quie Diuzi. Pero ude beyudyi gutinëꞌ bebannëꞌ zeyonëꞌ guibá, canaꞌra bezaꞌlaꞌadyiꞌyaquëꞌ con ca rna lëꞌë guichi. Bezaqueyaquëꞌ guca quie Jesús tali con ca rnën lëꞌë guichi naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yaca benëꞌ nitaꞌ ganꞌ zë Jesús caora guz̃inëꞌ Lázaro yeronëꞌ luꞌu beló yo besebannëꞌ lëbëꞌ, lëyaca benꞌ naꞌ, udixogueꞌyaquëꞌ ca naca blëꞌëyaquëꞌ bi bë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tanaꞌ lenaꞌ uzaꞌ yaca benëꞌ yedzagayaquëꞌ Jesús tu neza, danꞌ babeyaquëꞌ ca naca quie yelaꞌ huaca babënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Biz̃i yaca benꞌ partido fariseo unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Bablëꞌëro bira bide huero. Ulenaꞌcara lao yugulute benëꞌ zioyaquëꞌ banaoyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lado yaca benꞌ nitaꞌ lao lani ciudad Jerusalén, nitaꞌrë bala benꞌ griego. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Leyaquëꞌ ubigaꞌyaquëꞌ bago ga zë Felipe, benꞌ yedyi Betsaida quie estado Galilea, naꞌ unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Señor, reꞌenndoꞌ tzeyubindoꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Naꞌra uyo Felipe ganꞌ zë Andrés gudyinëꞌ lëbëꞌ cabëꞌ una yaca benꞌ griego. Biz̃i naꞌ zio rupayaquëꞌ yetixogueꞌyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Bagazi idyin hora quiaꞌ nëꞌëdiꞌ, bichi yugulu benëꞌ, huatiaꞌ yebanaꞌ, yeyaꞌa guibá tatula ga uzaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tali ca rniaꞌ leꞌe naꞌa quie bini trigo. Nacacazi tuzin chi bitzuꞌun luꞌu yu guꞌudzon. Pero chi bini razaro yeyuꞌudzon luꞌu yu, hualë laxtaꞌona ta yeyunan bini zë gula. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Canaꞌ nacarë quie yaca benëꞌ. Chi nu benꞌ bireꞌen inao nëꞌëdiꞌ danꞌ ruen z̃udyi initi yelaꞌ neban quienëꞌ, bibi yelaꞌ neban gataꞌ quienëꞌ tuzioli. Pero chi nu benꞌ inao nëꞌëdiꞌ baꞌalaꞌcazi ruen z̃udyi initi yelaꞌ neban quienëꞌ, lëbenꞌ naꞌ decazi yelaꞌ neban quienëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Chi nu benꞌ reꞌen guida gaca benꞌ quiaꞌ, reyaꞌalaꞌ guidayaquëꞌ inaoyaquëꞌ nëꞌëdiꞌ. Con gatezi tzezuaꞌ, lëzi ganꞌ naꞌ huazurëlëyaquëꞌ nëꞌëdiꞌ. Nu yaca benꞌ gaca benꞌ quiaꞌ, huapalaꞌn Xuzaꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Baraca yëchiꞌ luꞌu laxtaꞌohuaꞌ. ¿Cabiz̃i iniaꞌ yëpaꞌ Xuzaꞌ? ¿Iniaꞌ yëpaꞌnëꞌ: “Ute uselaoꞌ nëꞌëdiꞌ canꞌ gaca quiaꞌ gatiaꞌ”? Bigacacazi yëpaꞌ Xuzaꞌ canꞌ, porque nun quie lenaꞌ useꞌelaꞌnëꞌ nëꞌëdiꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Xuzaꞌ, uluꞌeloꞌ yaca benëꞌ ca naca yelaꞌ huaca quioꞌ. ―Canaꞌ una Jesús rëbinëꞌ Xuzinëꞌ. Biz̃i beyaquëꞌ de guibáte zaꞌ xchiꞌ Diuzi unëꞌ: ―Babluꞌecazaꞌ yaca benëꞌ yelaꞌ huaca quiaꞌ. Tatula huaꞌ yelaꞌ huaca quiaꞌ ta ilëꞌëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Biz̃i yaca benꞌ rzënaga nitaꞌyaquëꞌ ganꞌ zë Jesús, caora beyaquëꞌ xchiꞌ Diuzi unayaquëꞌ: ―Unë tu huiziuꞌ. Ibalayaquëꞌ unayaquëꞌ: ―Tu ángel bëꞌlënë lëbëꞌ diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Tahuen naꞌ bë Diuzi quiele unëꞌ bele xchiꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Babdyincazi hora naꞌa uluꞌe Diuzi ca tamala rue yaca benëꞌ. Biz̃i lëcanaꞌ udyiaguiꞌ Diuzi dyin quie xanꞌ taxiꞌibiꞌ. Lëlëna rnabëꞌna yaca benëꞌ nitaꞌ lao yedyi layu niga. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te yeyudyi udaꞌ yaca benëꞌ nëꞌëdiꞌ lëꞌë yaga cruzo gatiaꞌ, caora naꞌ hueyëz̃aꞌ lao yugulute yaca benëꞌ ta gacayaquëꞌ benꞌ yenao nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Una Jesús canꞌ tacuenda inezi yaca benëꞌ cabëꞌ gaca gatinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Naꞌ biz̃i una yaca benëꞌ rëbinëꞌ lëbëꞌ: ―Babendoꞌ ca rna yaca benꞌ rulaba guichi yuꞌu ley de que benꞌ Cristo nebancazinëꞌ tuzioli. Naꞌra ¿cómo luëꞌ rnaoꞌ benꞌ naca bichi yugulu benëꞌ gatinëꞌ lëꞌë yaga cruzo? ¿Ca nuz̃ila benꞌ naca bichi yugulu benëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Nëꞌëdiꞌ nacaꞌ ca quie tu guiꞌ rseniꞌn ga naca chula. Nezuliaꞌ leꞌe itu chopa dzazi. Reyaꞌalaꞌ huele bala ca rniaꞌ leꞌe naꞌa nezuaꞌ ni len leꞌe cuenda biquixile. Nu benꞌ rda lao lato lao chula, binezinëꞌ ga tzioguëꞌ huaquixinëꞌ xnezëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Reyaꞌalaꞌ galele quiaꞌ nacaꞌ ca quie tu guiꞌ rseniꞌn ga naca chula naꞌa nezuaꞌ ni len leꞌe tacuenda gacale benꞌ quiaꞌ, benꞌ rda lao lato lao xniꞌ. Ude beyudyi una Jesús canꞌ, zioguëꞌ pcachiꞌlaonëꞌ, bira blëꞌëjëꞌ gala zionëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Baꞌalaꞌcazi bë Jesús zë yelaꞌ huaca zaquëꞌlao yaca benëꞌ Israel, bigulecaziyaquëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Guca canꞌ danꞌ decazide uzun diꞌidzaꞌ ca bzu Isaías lëꞌë guichi dza naꞌla. Lëꞌë guichi naꞌ rnën cani: Señor, ¿nuz̃i gale ca naca diꞌidzaꞌ laꞌiya quioꞌ rguixoguiꞌa benëꞌ. ¿Nuz̃i bluꞌeloꞌ ca naca yelaꞌ huaca quioꞌ? Canaꞌ una Isaías dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Canaꞌ biguꞌunyaquëꞌ galeyaquëꞌ quie Jesús. Lëscanꞌ bzu Isaías diꞌidzaꞌ lëꞌë guichi rnën cani: ");
INSERT INTO zpcNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Yelaꞌ yeladyiꞌ quieyaquëꞌ bë Diuzi leyaquëꞌ ca quie benꞌ laochula, bënëꞌ zidi luꞌu laxtaꞌoyaquëꞌ, cuenda baꞌalaꞌcazi rlëꞌëyaquëꞌ, gaca quieyaquëꞌ ca benꞌ birlëꞌë, lëscanꞌ cuenda baꞌalaꞌcazi tzuꞌu diꞌidzaꞌ luꞌu guichoyaquëꞌ, gaca quieyaquëꞌ ca benꞌ birioñeꞌe. Canaꞌ biinaoyaquëꞌ xneza Diuzi ta yeyëri laxtaꞌoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Canaꞌ una Isaías dza naꞌ danꞌ unezinëꞌ naca Jesús benꞌ rue yelaꞌ huaca quie Diuzi. Quie lenaꞌ unënëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero gulecazi zë yaca benꞌ Israel, lente yaca benꞌ rnabëꞌ quiejëꞌ guleyaquëꞌ quie Jesús. Pero bibluꞌeyaquëꞌn zaquëꞌlao chi raleyaquëꞌ, danꞌ rdzebiyaquëꞌ yaca benꞌ partido fariseo chi yebioyaquëꞌ leyaquëꞌ luꞌu yaca idaoꞌ sinagoga. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Lenaꞌ rluꞌen raxerayaquëꞌ ca balaꞌana hue yaca benëꞌ len leyaquëꞌ, quele ca balaꞌana hue Diuzi len leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Biz̃i unë Jesús zidzo rëbinëꞌ leyaquëꞌ: ―Con nu yaca benꞌ rue quie diꞌidzaꞌ quiaꞌ, lëscanꞌ ruerë quieyaquëꞌ diꞌidzaꞌ quie Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Con nu yaca benꞌ nuebëꞌ nëꞌëdiꞌ, lëscanꞌ nuebëꞌrëyaquëꞌ benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nëꞌëdiꞌ nacaꞌ ca quie tu guiꞌ rseniꞌn ga naca chula. Nu yaca benꞌ gale quiaꞌ, bitayaquëꞌ lao lato lao chula. Tanaꞌ lenaꞌ bidaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero chi nu yaca benëꞌ babe diꞌidzaꞌ canꞌ baoniaꞌ, naꞌ birue quieyaquen, cala nëꞌëdiꞌ ichugobiꞌa quieyaquëꞌ. Bidaꞌ lao yedyi layu ta ute uselaꞌ yaca benëꞌ, cala ta ichugobiꞌa quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nu benꞌ yesebiꞌ nëꞌëdiꞌ, benꞌ birue quie ca naca diꞌidzaꞌ baoniaꞌ, decazide zu benꞌ ichugobëꞌ gaca juicio quieyaquëꞌ. Ta bibëyaquëꞌ bala ca naca diꞌidzaꞌ baoniaꞌ, lëlenaꞌ ichugobëꞌn quieyaquëꞌ dza yeyudyi lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Cabëꞌ nëꞌëdiꞌ, quele ta racazi laꞌadyaꞌ rniaꞌ. Rniaꞌ ca una Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ. Lëlëbëꞌ unanëꞌ nëꞌëdiꞌ ca bi diꞌidzaꞌ iniaꞌ usëdiaꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Banezdaꞌ bë Xuzaꞌ mandado ta gataꞌ yelaꞌ neban tuzioli quie yaca benꞌ gale quiaꞌ. Pues con canꞌ rniaꞌ, rniaꞌ ca una Xuzaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Raca falta dza gaꞌalaꞌ lani pascua ta rezaꞌlaꞌadyiꞌyaquëꞌ ca guca quie xuzixtaꞌoyaquëꞌ. Caora naꞌ gucabëꞌ Jesús abdyin hora gatinëꞌ yeyoguëꞌ guibá ga zu Xuzëꞌ. Pues nedyëꞌëcazi Jesús yaca benꞌ rale quienëꞌ, benꞌ nitaꞌ lao yedyi layu. Biyeyudyi yedu nedyëꞌënëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Biz̃i Judas Iscariote, z̃iꞌi Simón, uyuꞌunëꞌ pensari quie xanꞌ taxiꞌibiꞌ ta reguilolaꞌadyiꞌnëꞌ ca huenëꞌ usedyinnëꞌ Jesús lao naꞌa yaca benꞌ guti lëbëꞌ. Biz̃i Jesús dyëꞌëdi nezinëꞌ uzaꞌnëꞌ guibá ga zu Diuzi hueyoguëꞌ ga zu Xuzinëꞌ tatula. Nezirënëꞌ pcaꞌn Xuzinëꞌ duz̃e yelaꞌ rnabëꞌ quienëꞌ lao naꞌanëꞌ. Naꞌ biz̃i caora uyuꞌuyaquëꞌ huao rtzeꞌ, uzulinëꞌ ruꞌa mesa ga reꞌnëꞌ, udubëꞌ z̃abëꞌ de laohue, uz̃iꞌnëꞌ tu toalla pquionëꞌn lëꞌë siꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Naꞌra uz̃iꞌnëꞌ tu palangan udzaꞌnëꞌn nisa. Naꞌ uzulaonëꞌ rguibinëꞌ niꞌa yaca benꞌ quienëꞌ, besebidyinëꞌn conlë toalla pquionëꞌ lëꞌë siꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Cati zionëꞌ quibinëꞌ niꞌa Simón Pedro, naꞌ una Pedro rëbinëꞌ Jesús: ―Señor, ¿huaguiboꞌ niꞌa? ");
INSERT INTO zpcNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Cabëꞌ naꞌa binetzioñeꞌeloꞌ cabëꞌ huaꞌ quioꞌ, pero terala, huayoñeꞌeloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Naꞌra una Pedro rëbinëꞌ lëbëꞌ: ―Bigacacazi quiboꞌ niꞌa nëꞌëdiꞌ. Biz̃i Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―Chi bigaca quibaꞌ niꞌaloꞌ, bira nacoꞌ tuz̃e len nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Biz̃i Simón Pedro unëꞌ rëbinëꞌ Jesús: ―Señor, cala tuzi niꞌa quiboꞌ, lëscanꞌ quiboꞌ naꞌa lente guichogaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Naꞌra una Jesús rëbinëꞌ Pedro: ―Nu benꞌ zagozo yao, birnaban tzequëzunëꞌ yao luegozi. Niꞌazinëꞌ rquin tzërina, danꞌ banaquëꞌ benꞌ yëri. Leꞌe banacale benꞌ yëri pero cala lao yugulule. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Naꞌ una Jesús: “Cala lao yugulule”, danꞌ nezinëꞌ nu benꞌ usedyin lëbëꞌ lao naꞌa yaca benꞌ guti lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ude beyudyi udibinëꞌ niꞌa yaca benꞌ quienëꞌ, beyaconëꞌ z̃abëꞌ de laohue, bebeꞌnëꞌ tatula ruꞌa mesa unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Banezile cabëꞌ babiaꞌ quiele? ");
INSERT INTO zpcNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Leꞌe nale nëꞌëdiꞌ: “Maestro”, lëscanꞌ nale nëꞌëdiꞌ: “Señor.” Nacan tali quiele ca nale nëꞌëdiꞌ, danꞌ tali nacaꞌ maestro, nacatiaꞌ Señor quiele. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Como nëꞌëdiꞌ, benꞌ naca maestro, benꞌ naca Señor quiele, baodibaꞌ niꞌale leꞌe, naꞌra leꞌe, reyaꞌalaꞌ quibirële niꞌa tu itu laguedyile. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Babluꞌenaꞌ leꞌe cabëꞌ reyaꞌalaꞌ huele quie laguedyile con canꞌ babiaꞌ quiele. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tali rniaꞌ leꞌe, ni tu benꞌ naca mozo birnabëꞌnëꞌ como ca xaꞌnnëꞌ. Lëzi ni tu benꞌ rio mandado quie benꞌ tula, birnabëꞌnëꞌ como ca benꞌ useꞌelaꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chi baoyoñeꞌele cabëꞌ baoniaꞌ leꞌe, chi hue quielen, yedaohuele, naꞌ sule gusto. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Cala rniaꞌ quie lao yugulutele. Nëꞌëdiꞌ anezdaꞌ nu leꞌe aoliogaꞌ nacale benꞌ quiaꞌ. Pero decazide uzun diꞌidzaꞌ ca rnan lëꞌë guichi laꞌiya quie Diuzi: “Con tu benꞌ gaolë nëꞌëdiꞌ, lëbenꞌ naꞌ huenëꞌ condre nëꞌëdiꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Desde naꞌa rniaꞌ leꞌe ca ta zaꞌ gaca quiaꞌ cuenda galele quiaꞌ niaꞌ leꞌe nu nacaꞌ cati idyin dza gaca quiaꞌ canꞌ baoniaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tali rniaꞌ leꞌe, con nu yaca benꞌ chezilaꞌadyiꞌ quie benꞌ iseꞌelaꞌ, lëscanꞌ rezilaꞌadyiꞌrëyaquëꞌ nëꞌëdiꞌ. Naꞌ con nu yaca benꞌ chezilaꞌadyiꞌ nëꞌëdiꞌ, rezilaꞌadyiꞌrëyaquëꞌ benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ude beyudyi una Jesús canꞌ, guca yëchiꞌnëꞌ, lega ptëbin luꞌu laxtaꞌonëꞌ. Naꞌ claro gula unëꞌ rëbinëꞌ yaca benꞌ quienëꞌ: ―Tali rniaꞌ leꞌe, zu tu benꞌ zu ladole ni, benꞌ usedyin nëꞌëdiꞌ lao naꞌa yaca benꞌ guti nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Naꞌra uzulaoyaquëꞌ rnaꞌyaquëꞌ lao laguedyiyaquëꞌ. Bineziyaquëꞌ nulayaquëꞌ rnë Jesús quie canꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Uzu tu benꞌ quienëꞌ ureꞌnëꞌ cuëta lëꞌë Jesús ga udaoyaquëꞌ rtzeꞌ. Lega nedyëꞌë Jesús lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Biz̃i Simón Pedro bënëꞌ seña lao benꞌ ureꞌ cuëta lëꞌë Jesús ta inabëꞌ nuz̃ila quieyaquëꞌ rnë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Canaꞌ una benꞌ ureꞌ cuëta lëꞌë Jesús rëbinëꞌ lëbëꞌ: ―¿Señor, nuz̃ila nëtoꞌ rnaoꞌ canꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Con nu benꞌ huaꞌa yëta xtila bdyiaꞌ luꞌu plato niga, lëlëbenꞌ naꞌ usedyinnëꞌ nëꞌëdiꞌ lao naꞌa yaca benꞌ guti nëꞌëdiꞌ. Caora naꞌ uz̃iꞌnëꞌ tu bicho yëta xtila ta bdyianëꞌ luꞌu plato bëꞌnëꞌn Judas Iscariote, z̃iꞌi Simón. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ca uz̃iꞌ Judas yëta xtila, canaꞌ layuꞌute bichi be quie xanꞌ taxiꞌibiꞌ luꞌu laxtaꞌonëꞌ. Caora naꞌ una Jesús rëbinëꞌ Judas: ―Ca ta racoꞌ pensari hueloꞌ, bëtegan. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero nitu yaca benꞌ raolënëꞌ lao mesa biuyoñeꞌeyaquëꞌ bixquienꞌ gudyinëꞌ Judas canꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Como Judas naca ladyinaꞌanëꞌ bolsa ga yuꞌu dumi, quie lenaꞌ guqueyaquëꞌ reꞌen Jesús tzio Judas ta gaꞌonëꞌ ta gaoyaquëꞌ quie lani o chi ta gaꞌonëꞌ ta hueꞌnëꞌ yaca benꞌ yëchiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ca beyudyi udao Judas yëta xtila ta bëꞌ Jesús lënëꞌ, caora naꞌ bezaꞌnëꞌ baruen lao rtzeꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ude uzaꞌ Judas zioguëꞌ, naꞌ una Jesús rëbinëꞌ yaca benꞌ quienëꞌ: ―Abdyin hora uluꞌenaꞌ leꞌe yelaꞌ huaca quiaꞌ, nëꞌëdiꞌ bichi yugulu benëꞌ. Lëzi uluꞌenaꞌ leꞌe yelaꞌ huaca quie Xuzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Cabëꞌ nëꞌëdiꞌ bichi yugulu benëꞌ, uluꞌenaꞌ leꞌe yelaꞌ huaca quie Xuzaꞌ, lëscanꞌ uluꞌerë Xuzaꞌ leꞌe yelaꞌ huaca quiaꞌ nëꞌëdiꞌ z̃iꞌinëꞌ. Baruen baba dzazi gaca canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bichaꞌ, calara zidza zuliaꞌ leꞌe niga. Leꞌe huadale yeguilole nëꞌëdiꞌ. Naꞌra iniaꞌ leꞌe con canꞌ bagudyaꞌ yaca los demás benꞌ Israel dza naꞌ: Con ganꞌ yeyaꞌa, bisaqueꞌ yezaꞌrële len nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Rniaꞌ leꞌe tu mandamiento cubi: Idyëꞌële tu itu laguedyile. Naꞌra cabëꞌ ruaꞌ nëꞌëdiꞌ, nedyëꞌëdaꞌ leꞌe, lëcanaꞌ huerële, idyëꞌële tu itu laguedyile. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chi idyëꞌële tu itu laguedyile, lëcanaꞌ huanezi yugulu benëꞌ nacale benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Biz̃i Simón Pedro unanëꞌ rëbinëꞌ Jesús: ―Señor, ¿gaz̃i yeyoloꞌ? Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Ganꞌ yeyaꞌa bisaqueꞌ yezaꞌloꞌ naꞌa. Pero terala yeguidale ganꞌ yeyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Naꞌra una Pedro rëbinëꞌ lëbëꞌ: ―Señor, ¿bixquienꞌ bisaqueꞌ yezaꞌliaꞌ luëꞌ naꞌa? Zuaꞌ puesto gatiaꞌ lao lazoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Biz̃i Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―¿Nacan tali zuloꞌ puesto naoꞌ gatioꞌ lao lazaꞌ? Tali ca rniaꞌ luëꞌ, zahuen bala binecuedyi biu, huanaoꞌ tzona lasa binubëꞌloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Nernë Jesús rëbinëꞌ leyaquëꞌ: ―Bigapale cuidado. Rzudyiꞌilële Diuzi, lëzirë reyaꞌalaꞌ sudyiꞌilële nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Luꞌu guibá ga zu Xuzaꞌ, detzegue lato ga tzezule. Chi bide lato, iniaꞌ leꞌe bide lato. Lenaꞌ yeyaꞌa guibá tzeguiaꞌ dyaꞌa ga tzezule. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ude yeyudyi yeyaꞌa guibá tzeguiaꞌ dyaꞌa ga tzezule, caora naꞌ yeguidaꞌ tatula dez̃iaꞌ leꞌe cuenda sulële nëꞌëdiꞌ luꞌu guibá tuz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Leꞌe banezile ga zio neza ganꞌ yedyinaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Naꞌra una Tomás rëbinëꞌ Jesús: ―Señor, binezindoꞌ ganꞌ yedyinloꞌ, ¿cómo luëꞌ naoꞌ banezindoꞌ ganꞌ zio neza? ");
INSERT INTO zpcNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Nëꞌëdiꞌ nacaꞌ neza guibá, benꞌ rnë tali, benꞌ run yelaꞌ neban tuzioli. Tuzaꞌ nëꞌëdiꞌ nacaꞌ benꞌ uluꞌe yaca benëꞌ yedyinyaquëꞌ ga zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Chi tali banubëꞌle nëꞌëdiꞌ, lëzi nubëꞌrële Xuzaꞌ. Desde naꞌa banubëꞌle Xuzaꞌ, barlëꞌëlenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Naꞌra una Felipe rëbinëꞌ Jesús: ―Señor, ben lato ilëꞌëndoꞌ Xuziro Diuzi. Tanaꞌzi inabandoꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Quie lenaꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Felipe, zidza baoca zuliaꞌ leꞌe, ¿quele binubëꞌloꞌ nëꞌëdiꞌ? Nu benꞌ bablëꞌë nëꞌëdiꞌ, lëbenꞌ naꞌ bablëꞌërënëꞌ Xuzaꞌ. ¿Naꞌ bixquienꞌ naoꞌ nëꞌëdiꞌ: “Ben lato ilëꞌëndoꞌ Xuziro Diuzi”? ");
INSERT INTO zpcNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Binezile nëꞌëdiꞌ zulëcazaꞌ Xuzaꞌ, lëzi zulëcazinëꞌ nëꞌëdiꞌ? Ca naca diꞌidzaꞌ baoniaꞌ leꞌe nacan diꞌidzaꞌ ta una Xuzaꞌ nëꞌëdiꞌ, cala diꞌidzaꞌ quiaꞌ cuinzaꞌ. Cala ta racazi laꞌadyaꞌ uniaꞌ. Naca Xuzaꞌ benꞌ zulëcazi nëꞌëdiꞌ tzaz̃e. Ruecazinëꞌ ca reꞌennëꞌ gaca. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Galele zulëcazaꞌ Xuzaꞌ, lëzi Xuzaꞌ zulëcazinëꞌ nëꞌëdiꞌ. Chi biralele con canꞌ baoniaꞌ leꞌe, galele quiaꞌ por nun quie ta biaꞌ blëꞌële. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tali ca rniaꞌ leꞌe, con nu benꞌ rale quiaꞌ, huerëyaquëꞌ ca ta babiaꞌ. Lëzi huerayaquëꞌ mazara ca ta babiaꞌ, danꞌ yedyinaꞌ ganꞌ zu Xuzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yugulu ta inabale lao Xuzaꞌ, uzëtole laohuaꞌ inabalen, naꞌ nëꞌëdiꞌ z̃iꞌinëꞌ, gunaꞌn tacuenda uluꞌenaꞌ yelaꞌ huaca quie Xuzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Con bitezi inabale uzëtole laohuaꞌ, nagunaꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Chi leꞌe nedyëꞌële nëꞌëdiꞌ, ulehue quiele ca naca mandamiento baoniaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nëꞌëdiꞌ yëpaꞌ Xuzaꞌ ta iseꞌelaꞌnëꞌ itu benꞌ gacalë leꞌe. Lëbëꞌ yeyuez̃elaꞌadyiꞌnëꞌ leꞌe, huazulëcazinëꞌ leꞌe tuzioli. Naquëꞌ Bichi Be quie Diuzi, benꞌ uzioñeꞌe leꞌe ta naca tali. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pero nu yaca benꞌ nitaꞌ lao yedyi layu, bichezilaꞌadyiꞌyaquëꞌ lëbëꞌ, nica nelëꞌëyaquëꞌ lëbëꞌ, nica huebëꞌyaquëꞌ lëbëꞌ. Pero leꞌe nubëꞌle lëbëꞌ, danꞌ zulëcazinëꞌ leꞌe yuꞌunëꞌ luꞌu laxtaꞌole tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Biucaꞌnaꞌ leꞌe cuinzile. Hueguidacazaꞌ tatula suliaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ibaba dza ilëꞌë yaca benëꞌ nitaꞌ lao yedyi layu nëꞌëdiꞌ. Pero leꞌe, hualëꞌëcazile nëꞌëdiꞌ. Huataꞌ yelaꞌ neban quiele tuzioli, danꞌ nacale benꞌ quiaꞌ nëꞌëdiꞌ, benꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dza gaca canꞌ hualëꞌële zulëcazaꞌ Xuzaꞌ tuz̃e, lëscanꞌ leꞌe lëlënëꞌëdiꞌ, lëscanꞌ nëꞌëdiꞌ len leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nu benꞌ hue quie ca naca mandamiento baoniaꞌ leꞌe, lenaꞌ rluꞌen quienëꞌ tali nedyëꞌënëꞌ nëꞌëdiꞌ. Naꞌra idyëꞌërë Xuzaꞌ nu benꞌ nedyëꞌë nëꞌëdiꞌ. Lëzi nëꞌëdiꞌ nedyëꞌëdaꞌ con nu benꞌ nedyëꞌë nëꞌëdiꞌ, uluꞌenaꞌyaquëꞌ yelaꞌ huaca quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Naꞌra unë Judas, pero Judas tula, cala Judas Iscariote, rëbinëꞌ Jesús: ―Señor, ¿bixquienꞌ uluꞌeloꞌ nëtoꞌ yelaꞌ huaca quioꞌ, naꞌ biuluꞌeloꞌn yaca benꞌ nitaꞌ lao yedyi layu? ");
INSERT INTO zpcNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Nu yaca benꞌ nedyëꞌë nëꞌëdiꞌ, rue quieyaquëꞌ xtiꞌidzaꞌ, nadyëꞌë Xuzaꞌ leyaquëꞌ. Nëꞌëdiliaꞌ Xuzaꞌ huazulëcazindoꞌ leyaquëꞌ tuz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pero nu yaca benꞌ binedyëꞌë nëꞌëdiꞌ, birue quieyaquëꞌ xtiꞌidzaꞌ. Ca naca diꞌidzaꞌ baoniaꞌ leꞌe, cala ta racazi laꞌadyaꞌ uniaꞌ leꞌe, diꞌidzaꞌ quiaꞌ nacan diꞌidzaꞌ una Xuzaꞌ, benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Tu neraca nezuliaꞌ leꞌe itu chiꞌ, rguixogueꞌnaꞌ leꞌe ca diꞌidzaꞌ baoniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Cati bira zuaꞌ ni len leꞌe, huaseꞌelaꞌ Xuzaꞌ Bichi Be quienëꞌ lao lazaꞌ ta gacalënëꞌ leꞌe huaz̃elaꞌadyiꞌnëꞌ leꞌe. Lëzi uzioñeꞌenëꞌ leꞌe usaꞌlaꞌadyiꞌnëꞌ leꞌe yugulute ca ta baoniaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Baruen bago dza yeyaꞌa pero huabëchaꞌ chizi luꞌu laxtaꞌole con ca reꞌ chizi luꞌu laxtaꞌohuaꞌ. Canaꞌ dugalo cueꞌn chizi luꞌu laxtaꞌole, quele ca rue yaca benꞌ nitaꞌ lao yedyi layu, quele dugalo cuëchijëꞌ chizi luꞌu laxtaꞌole. Lëlenaꞌ bidëbile, bidzebile. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Babele uniaꞌ leꞌe de que hueyaꞌa guibá hueguidaꞌ tatula suliaꞌ leꞌe. Chi tali nedyëꞌële nëꞌëdiꞌ, huedaohuele yele diꞌidzaꞌ yedyinaꞌ ga zu Xuzaꞌ. Nacara Xuzaꞌ benꞌ z̃e ca nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Desde naꞌa rniaꞌ leꞌe ta zaꞌ gaca quiaꞌ cuenda yezaꞌlaꞌadyiꞌle cabëꞌ uniaꞌ leꞌe galele quiaꞌ cati idyin dza gaca quiaꞌ canꞌ baoniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Birabi zë diꞌidzaꞌ hueꞌliaꞌ leꞌe, danꞌ bazaꞌ xanꞌ taxiꞌibiꞌ. Lëna rnabëꞌna yaca benëꞌ nitaꞌ lao yedyi layu. Pero birnabëꞌna nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ruzucazaꞌ diꞌidzaꞌ ca ta una Xuzaꞌ nëꞌëdiꞌ tacuenda inezi yaca benëꞌ nitaꞌ lao yedyi layu de que nedyëꞌëdaꞌ Xuzaꞌ. Ulechasa ganꞌ ni. Uletzaꞌ ga tula. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Biz̃i neruꞌelë Jesús leyaquëꞌ diꞌidzaꞌ unëꞌ: ―Nëꞌëdiꞌ nacaꞌ ca quie luba bedzuliꞌ. Naca Xuzaꞌ ca quie benꞌ rapa luba bedzuliꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Huachuguëꞌ yaca tacaꞌ luba ta bidyia taz̃ixi tzechuꞌunnëꞌn. Naꞌ luba dyia bedzuliꞌ, uluba uchaꞌanëꞌn tacuenda cuiaran taz̃ixi. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Leꞌe nacale benꞌ yëri lao Diuzi danꞌ rue quiele ca ta bapsëdiaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ta reyaꞌalaꞌ huele biusanle nëꞌëdiꞌ nacalëcazile nëꞌëdiꞌ tuz̃e cabëꞌ nacalëcazaꞌ leꞌe tuz̃e. Tu tacaꞌ luba bedzuliꞌ bizun lëꞌë luba quien, bisaqueꞌ cuian taz̃ixi. Lëzi leꞌe, chi binacalëcazile nëꞌëdiꞌ tuz̃e, naca quiele ca quie luba bidyia taz̃ixi. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Nëꞌëdiꞌ nacaꞌ ca quie luba. Naꞌ biz̃i leꞌe nacale ca quie tacaꞌ luba. Chi nacalëcazile nëꞌëdiꞌ tuz̃e cabëꞌ nacalëcazaꞌ leꞌe tuz̃e, naca quiele ca quie luba bedzuliꞌ dyia taz̃ixi. Chi binacalëcazile nëꞌëdiꞌ tuz̃e, bibi de huele. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nu yaca benꞌ binacalë nëꞌëdiꞌ tuz̃e, gaca quienëꞌ ca quie tacaꞌ luba bidyia taz̃ixi. Nacan ta chuꞌun yaca benëꞌ tzalaꞌla ta utupayaquëꞌn ibidyin uzeiyaquëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Chi nacalëcazile nëꞌëdiꞌ tzaz̃e, chi bigalaꞌadyiꞌle ca ta bapsëdiaꞌ leꞌe, naꞌ con bitezi inabale nëꞌëdiꞌ, guncazaꞌn leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Cati rue quiele diꞌidzaꞌ quie Xuzaꞌ, canaꞌ balaꞌana nacale ca quie luba bedzuliꞌ dyian taz̃ixi. Lëcanaꞌ uluꞌen talicazi nacale benꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nëꞌëdiꞌ nedyëꞌëdaꞌ leꞌe ca nedyëꞌë Xuzaꞌ nëꞌëdiꞌ. Ulenao nëꞌëdiꞌ con canꞌ nedyëꞌëdaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Chi hue quiele cabëꞌ baoniaꞌ leꞌe, canaꞌ idyëꞌëdaꞌ leꞌe cabëꞌ nedyëꞌë Xuzaꞌ nëꞌëdiꞌ, ruaꞌ cabëꞌ unanëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Cabëꞌ diꞌidzaꞌ baoniaꞌ leꞌe, nacan ta yedaohuele lële nëꞌëdiꞌ su gusto luꞌu laxtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ni rniaꞌ leꞌe tu diꞌidzaꞌ belao: Reꞌendaꞌ idyëꞌële tu itu laguedyile con canꞌ ruaꞌ nedyëꞌëdaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Chi baguti tu benëꞌ lao laza amigo quienëꞌ ta uselanëꞌ lëbëꞌ, lëlenaꞌ uluꞌen lega nedyëꞌë benꞌ naꞌ amigo quienëꞌ. Ganura zu nedyëꞌëra benꞌ amigo quienëꞌ ca benꞌ naꞌ, benꞌ guti. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Leꞌe nacacazile amigo quiaꞌ chi hue quiele diꞌidzaꞌ con canꞌ baoniaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Bira iniaꞌ leꞌe nacale ca quie mozo quiaꞌ, porque binezi yaca mozo bi rue xaꞌnyaquëꞌ. Iniaꞌ leꞌe nacale amigo quiaꞌ, porque aoniaꞌ leꞌe ca ta una Xuzaꞌ nëꞌëdiꞌ, banezcazile bi ruenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Cala leꞌe uliole nëꞌëdiꞌ, denꞌ nëꞌëdiꞌ uliogaꞌ leꞌe ta tziole huele dyin quie Diuzi siꞌle usecho ta de tuzioli. Canaꞌ, guncazi Xuzaꞌ yugulu ta inabale uzëtole laohuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Naꞌra tatula iniaꞌ leꞌe: Reꞌendaꞌ idyëꞌële tu itu laguedyile. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Chi rudie yaca benꞌ nitaꞌ lao yedyi layu leꞌe, bigalaꞌadyiꞌle tanëro bdieyaquëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Chi leꞌe nacale tuzi len benꞌ nitaꞌ lao yedyi layu, gueꞌenyaquëꞌ leꞌe con ca gueꞌenyaquëꞌ yaca benꞌ quieyaquëꞌ. Pero nëꞌëdiꞌ uliogaꞌ leꞌe ladoyaquëꞌ, quie lenaꞌ rudieyaquëꞌ leꞌe, danꞌ bira nacale tuzi len leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bigalaꞌadyiꞌle con canꞌ baoniaꞌ leꞌe: Benꞌ rue dyin lao xaꞌne, binaquëꞌ benꞌ z̃e ca xaꞌnnëꞌ. Chi rudie yaca benëꞌ nëꞌëdiꞌ, lëzi udieyaquëꞌ leꞌe. Chi bë quieyaquëꞌ con canꞌ baoniaꞌ bagudyaꞌyaquëꞌ, lëzirë hue quieyaquëꞌ con canꞌ inale yëbileyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Naꞌ usacayaquëꞌ leꞌe bizinaquezi, porque danꞌ nacale benꞌ quiaꞌ, binubëꞌyaquëꞌ benꞌ useꞌelaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Bibi dulaꞌ napayaquëꞌ chi nëꞌëdiꞌ bibidaꞌ bibëꞌliaꞌyaquëꞌ diꞌidzaꞌ. Pero danꞌ bidaꞌ, bëꞌliaꞌyaquëꞌ diꞌidzaꞌ, lëlenaꞌ birson gataꞌ quieyaquëꞌ, naocazi dulaꞌ xquia quieyaquëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nu yaca benꞌ rudie nëꞌëdiꞌ, lëscanꞌ rudierëyaquëꞌ Xuzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bibi dulaꞌ napayaquëꞌ chi nëꞌëdiꞌ bibiaꞌ yelaꞌ huaca quiaꞌ ladoyaquëꞌ. Pero bablëꞌëcaziyaquëꞌ ca ta biaꞌ. Naꞌ biz̃i baꞌalaꞌcazi bablëꞌëyaquëꞌ canꞌ babiaꞌ, rudiecaziyaquëꞌ nëꞌëdiꞌ, lëscanꞌ rudierëyaquëꞌ Xuzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero racan canꞌ ta uzun diꞌidzaꞌ con canꞌ zu lëꞌë guichi ley ga rnën: “Rudiecaziyaquëꞌ nëꞌëdiꞌ, baꞌalaꞌcazi bibi dulaꞌ quiaꞌ de.” ");
INSERT INTO zpcNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Caora guida benꞌ iseꞌelaꞌ tanun quie Xuzaꞌ, naꞌ lëbenꞌ naꞌ gacalënëꞌ leꞌe huez̃elaꞌadyiꞌnëꞌ leꞌe. Naca lëbenꞌ naꞌ Bichi Be quie Xuzaꞌ, benꞌ rnë puro diꞌidzaꞌ li. Huanënëꞌ cule quiaꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Lëzi leꞌe huanërële cule nëꞌëdiꞌ danꞌ zulële nëꞌëdiꞌ tzaz̃e desde dza uzulaoro rdaro tuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Cabëꞌ diꞌidzaꞌ rniaꞌ leꞌe, biyeyatile danꞌ lëdiꞌidzaꞌ naꞌ gacalën leꞌe ta inaole nëꞌëdiꞌ. Yaca benëꞌ rudie nëꞌëdiꞌ ");
INSERT INTO zpcNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","huebioyaquëꞌ leꞌe luꞌu yaca idaoꞌ sinagoga. Huadyin dza gaqueyaquëꞌ chi mandado quie Diuzi gutiyaquëꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Canaꞌ hueyaquëꞌ como danꞌ binubëꞌyaquëꞌ Xuzaꞌ, lëzi binubëꞌyaquëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ca diꞌidzaꞌ ni rniaꞌ leꞌe, nacan ta yezaꞌlaꞌadyiꞌle con canꞌ baoniaꞌ leꞌe caora bazaꞌ gaca quiele canꞌ baoniaꞌ. ’Biuniaꞌ leꞌe dzaꞌ naꞌ ca ta rniaꞌ leꞌe naꞌa, como danꞌ nezuliaꞌ leꞌe dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero baidyin hora yeyaꞌa tzezuliaꞌ benꞌ useꞌelaꞌ nëꞌëdiꞌ. Naꞌ ni tule biunabale nëꞌëdiꞌ ganꞌ yeyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pero danꞌ rniaꞌ leꞌe ni, lenaꞌ baraqueyëchiꞌ luꞌu laxtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero rniaꞌ leꞌe ta naca tali. Huaca huen quiele chi yeyaꞌa, porque chi biyeyaꞌa, biguida Bichi Be quie Diuzi ta sulënëꞌ leꞌe gacalënëꞌ leꞌe huez̃elaꞌadyiꞌnëꞌ leꞌe. Chi yeyaꞌa ga zu Xuzaꞌ, huaseꞌelaꞌ Bichi Be quienëꞌ ga zule. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cati guida lëbëꞌ uzioñeꞌenëꞌ yaca benëꞌ nitaꞌ lao yedyi layu ta ineziyaquëꞌ decazi dulaꞌ xquia quieyaquëꞌ, lëzi ta ineziyaquëꞌ reꞌen Diuzi tzëri laxtaꞌoyaquëꞌ, lëzirë ta ineziyaquëꞌ huachugobëꞌ Diuzi quieyaquëꞌ con canꞌ bëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Danꞌ biraleyaquëꞌ quiaꞌ, lenaꞌ decazi dulaꞌ xquia quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nun quie danꞌ yeyaꞌa ga zu Xuzaꞌ, lenaꞌ huanezi yaca benꞌ nitaꞌ lao yedyi layu reꞌen Diuzi tzëri laxtaꞌoyaquëꞌ. Naꞌ biz̃i leꞌe, itu chiꞌzi zuliaꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Naꞌra huanezi yaca benëꞌ nitaꞌ lao yedyi layu hue Diuzi juicio quieyaquëꞌ con cabëꞌ baochugobëꞌ Diuzi quie xanꞌ taxiꞌibiꞌ, benꞌ rnabëꞌ lao benꞌ nitaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Tazë nede ta iniaꞌ leꞌe, pero leꞌe bitzioñeꞌelen naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Cati guida Bichi Be quie Diuzi, benꞌ rnë tali, lëbëꞌ uzioñeꞌenëꞌ leꞌe ta naca tabala quie Diuzi. Quele huananëꞌ ta racazi laꞌadyiꞌnëꞌ, denꞌ tanun quie Diuzi inanë. Uzioñeꞌenëꞌ leꞌe ca ta zaꞌ gaca dza zazaꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Huenëꞌ nëꞌëdiꞌ benꞌ zëꞌ. Nezinëꞌ cabëꞌ diꞌidzaꞌ rniaꞌ, uzioñeꞌenëꞌ leꞌe cabëꞌ nacan. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yugute ca rna Xuzaꞌ nacan ta inëriaꞌ leꞌe. Lenaꞌ rniaꞌ nezi Bichi Be quie Diuzi cabëꞌ diꞌidzaꞌ rniaꞌ, uzioñeꞌenëꞌ leꞌe cabëꞌ nacan. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Biz̃i gaca tu chiꞌzi birlëꞌële nëꞌëdiꞌ, te naꞌ itu chiꞌzi yelëꞌële nëꞌëdiꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Naꞌra unë yaca benꞌ quie Jesús rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Ca biz̃i naca diꞌidzaꞌ unëꞌ raꞌo? Unëꞌ gaca tu chiꞌzi birlëꞌëroguëꞌ, te naꞌ nëꞌ itu chiꞌzi hualëꞌëroguëꞌ tatula. Lëzi narëꞌ gaca quienëꞌ canaꞌ danꞌ yeyonëꞌ ganꞌ zu Xuzinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ca biz̃i naca diꞌidzaꞌ unëꞌ caora unëꞌ: “Gaca tu chiꞌzi”? Birioñeꞌero cabëꞌ diꞌidzaꞌ unëꞌ raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Biz̃i gucabëꞌ Jesús biuyoñeꞌeyaquëꞌ ca diꞌidzaꞌ gudyinëꞌ leyaquëꞌ. Tanaꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Baonëcazaꞌ leꞌe gaca tu chiꞌzi birlëꞌële nëꞌëdiꞌ, te naꞌ itu chiꞌzi yelëꞌële nëꞌëdiꞌ tatula. ¿Lëdiꞌidzaꞌ naꞌ biuyoñeꞌele rnabale laguedyile? ");
INSERT INTO zpcNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tali ca rniaꞌ leꞌe, huaqueyëchiꞌle huabedyile baidyin hora guti yaca benëꞌ nëꞌëdiꞌ. Naꞌ biz̃i yaca benëꞌ nitaꞌ lao yedyi layu, huedaohueyaquëꞌ danꞌ gatiaꞌ. Pero baꞌalaꞌcazi huaqueyëchiꞌle tu chiꞌzi, te naꞌ huedaohuele bëꞌ yelëꞌële nëꞌëdiꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tu nigula nuꞌa z̃iꞌine, bëꞌ idyin hora su bdaoꞌ quienëꞌ, redzagalaonëꞌ ta su bdaoꞌ quienëꞌ. Biz̃i caora baozu bdaoꞌ quienëꞌ, hualaꞌadyiꞌnëꞌ ca ta babedzagalaonëꞌ, danꞌ lega redaohuetzeguenëꞌ baozu z̃iꞌinëꞌ byu. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lëscanaꞌ nacarë quie leꞌe. Redzagalaole naꞌa, pero cati yeguidaꞌ denaꞌa leꞌe, lëcanaꞌ lega yedaohuele. Nitu nitu nunura uzu leꞌe bayëchiꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Lëdza naꞌ birabi inabale nëꞌëdiꞌ. Tali ca rniaꞌ leꞌe, guncazi Xuzaꞌ yugulu ca ta inabale lënëꞌ uzëtole laohuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Desde dza naꞌ binuzëtole laohuaꞌ bi ta rnabale Xuzaꞌ. Ulenaba con canꞌ baoniaꞌ leꞌe. Canaꞌ guncazi Xuzaꞌ leꞌe ca ta inabalenëꞌ tacuenda gaca huen quiele sule dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Diꞌidzaꞌ baoniaꞌ leꞌe nacan diꞌidzaꞌ canezi tzioñeꞌelen. Pero huadyin dza bira iniaꞌ leꞌe diꞌidzaꞌ canezi tzioñeꞌelen, huaniaꞌ leꞌe diꞌidzaꞌ ta tzioñeꞌele labezi inezile quie Xuzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Lëdza naꞌ uzëtole laohuaꞌ inabale Xuzaꞌ bi ta reꞌenle inabalenëꞌ. Caora naꞌ bira inaban inabaꞌ Xuzaꞌ gunnëꞌ bi ta reꞌenle. Nedyëꞌëcazi Xuzaꞌ leꞌe. Nedyëꞌënëꞌ leꞌe porque danꞌ nedyëꞌële nëꞌëdiꞌ, ralele danꞌ niaꞌ uzaꞌ ga zu Xuzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tali naꞌ uzaꞌ ga zu Xuzaꞌ bidaꞌ lao yedyi layu. Pero naꞌ abdyin hora huezaꞌ lao yedyi layu, yeyaꞌa ga zu Xuzaꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Caora naꞌ una yaca benꞌ quienëꞌ rëbiyaquëꞌ lëbëꞌ: ―Naꞌra rnëloꞌ diꞌidzaꞌ ta tzioñeꞌendoꞌ labezi, quele diꞌidzaꞌ canezi tzioñeꞌendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Naꞌra banezindoꞌ luëꞌ nezoꞌ quie lao yugulute. Nica inabandoꞌ luëꞌ banezoꞌ bi ta inabandoꞌ luëꞌ. Quie lenaꞌ banezindoꞌ de que luëꞌ nacoꞌ benꞌ uzaꞌ ga zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―¿Naꞌra banezile? ");
INSERT INTO zpcNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bagazi idyin hora yedzatzale tziole quie quiele ucaꞌnle nëꞌëdiꞌ tuzaꞌ. Pero bizucazaꞌ tuzaꞌ danꞌ zucazi Xuzaꞌ len nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ca diꞌidzaꞌ baoniaꞌ leꞌe nacan ta cuëchin chizi luꞌu guicho laxtaꞌole, lëscanꞌ ta sudyiꞌilëcazile nëꞌëdiꞌ. Yedzagalaole lao yedyi layu niga, pero bidzebile como danꞌ babiaꞌ gan lao xanꞌ taxiꞌibiꞌ, benꞌ rnabëꞌna lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ude beyudyi una Jesús canaꞌ, pchisa laohuëꞌ unaꞌnëꞌ z̃an guibá unëꞌ: ―Xuzaꞌ, abdyin hora quiaꞌ. Hueloꞌ nëꞌëdiꞌ z̃iꞌiloꞌ benꞌ z̃e con ca ruaꞌ luëꞌ benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nëꞌëdiꞌ, z̃iꞌiloꞌ, bapcaꞌnloꞌ lao naꞌa yelaꞌ rnabëꞌ quioꞌ ta inabiꞌa lao yugulu benëꞌ. Canaꞌ huaꞌa yaca benꞌ pcaꞌnloꞌ lao naꞌa yelaꞌ neban tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Decazi yelaꞌ neban quieyaquëꞌ tuzioli tanun quie danꞌ nubëꞌyaquëꞌ luëꞌ tuzoꞌ nacoꞌ Diuzi. Lëzirë nubëꞌrëyaquëꞌ nëꞌëdiꞌ, Jesucristo, benꞌ useꞌeloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Babiaꞌ luëꞌ benꞌ z̃e lao yedyi layu niga. Babzuaꞌ diꞌidzaꞌ quioꞌ, babiaꞌ ca ta useꞌeloꞌ nëꞌëdiꞌ huaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Xuzaꞌ, hueloꞌ nëꞌëdiꞌ benꞌ z̃e caora yeguidaꞌ tatula ganꞌ zuloꞌ cabëꞌ baoꞌ dza naꞌ, baoꞌ nëꞌëdiꞌ benꞌ z̃e tu binecueꞌ yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ca yaca benꞌ ulioloꞌ lado yaca benꞌ nitaꞌ lao yedyi layu, babzioñeꞌenaꞌyaquëꞌ ca nacoꞌ. Nacayaquëꞌ benꞌ quioꞌ. Lëleyaquëꞌ pcaꞌnloꞌ lao naꞌa, baraleyaquëꞌ diꞌidzaꞌ quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Baneziyaquëꞌ lao naꞌaloꞌ zaꞌ yugulute ta pcaꞌnloꞌ lao naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ca naca diꞌidzaꞌ pcaꞌnloꞌ lao naꞌa, barue quieyaquëꞌn. Baneziyaquëꞌ tali uzaꞌ ga zuloꞌ, baraleyaquëꞌ de que luëꞌ useꞌeloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Rnabaꞌ cule laoloꞌ por yaca benꞌ pcaꞌnloꞌ lao naꞌa, danꞌ nacayaquëꞌ benꞌ quioꞌ. Cala rnabaꞌ por yaca benꞌ nitaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yugulu yaca benꞌ quiaꞌ, nacarëyaquëꞌ benꞌ quioꞌ. Lëzirë yugulu yaca benꞌ quioꞌ, nacarëyaquëꞌ benꞌ quiaꞌ. Lëleyaquëꞌ rueyaquëꞌ nëꞌëdiꞌ benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Ca naca nëꞌëdiꞌ, bira suaꞌ lao yedyi layu niga. Pero leyaquëꞌ nezuyaquëꞌ lao yedyi layu ni. Biz̃i nëꞌëdiꞌ hueguidaꞌ ganꞌ zuloꞌ. Xuzaꞌ, benꞌ laꞌiya nacoꞌ, conlë yelaꞌ huaca quioꞌ gacalaoꞌ yaca benꞌ pcaꞌnloꞌ lao naꞌa tacuenda gacayaquëꞌ tuzi pensari cabëꞌ nacaliaꞌ luëꞌ tuzi pensari. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Udapachaꞌa yaca benꞌ pcaꞌnloꞌ lao naꞌa dza uzuliaꞌ leyaquëꞌ lao yedyi layu niga. Conlë yelaꞌ huaca quioꞌ pcuasa pcuiꞌogaꞌyaquëꞌ, nituyaquëꞌ biuniti. Tuzi benꞌ uniti unitinëꞌ tacuenda uzun diꞌidzaꞌ ca rnan lëꞌë guichi laꞌiya quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Naꞌra hueguidaꞌ ganꞌ zuloꞌ. Pero tu raca nezuaꞌ lao yedyi layu niga, rniaꞌ luëꞌ diꞌidzaꞌ tacuenda yedaohueyaquëꞌ ca redaohuedaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Bapcaꞌnaꞌ diꞌidzaꞌ quioꞌ lao naꞌayaquëꞌ. Rudie yaca benꞌ nitaꞌ lao yedyi layu leyaquëꞌ, danꞌ bizulëyaquëꞌ leyaquëꞌ tuzi. Nacayaquëꞌ ca nëꞌëdiꞌ, bizuliaꞌ yaca benꞌ nitaꞌ lao yedyi layu tuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Cala rnabaꞌ ta cuioloꞌyaquëꞌ lao yedyi layu, rnabaꞌ ta ucuasa ucuiꞌoloꞌyaquëꞌ ca ta reꞌen xanꞌ taxiꞌibiꞌ huenan quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ca naca nëꞌëdiꞌ, bizuliaꞌ yaca benꞌ nitaꞌ lao yedyi layu tuzi, lëzi canaꞌ nacarë quieyaquëꞌ, bizulërëyaquëꞌ yaca benꞌ nitaꞌ lao yedyi layu tuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Udzeꞌloꞌyaquëꞌ lao naꞌaloꞌ. Uzioñeꞌeloꞌyaquëꞌ ca naca tabala quioꞌ. Naca diꞌidzaꞌ quioꞌ diꞌidzaꞌ li. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Como luëꞌ baoseꞌeloꞌ nëꞌëdiꞌ bidaꞌ lado yaca benꞌ nitaꞌ lao yedyi layu, lëzirë canaꞌ nëꞌëdiꞌ iseꞌelaꞌyaquëꞌ lado yaca benꞌ nitaꞌ lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Por nun quieyaquëꞌ babdyiaꞌ cuinaꞌ lao naꞌaloꞌ cuenda udzeꞌloꞌyaquëꞌ lao naꞌaloꞌ ineziyaquëꞌ ca naca tabala quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Cala por tuzi leyaquëꞌ rnabaꞌ cule, lëscanꞌ rnabaꞌ cule por yaca benꞌ zagalera quiaꞌ ga tzioyaquëꞌ tzetixogueꞌyaquëꞌ diꞌidzaꞌ quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Rnabaꞌ cule laoloꞌ gacalaoꞌyaquëꞌ ta initaꞌyaquëꞌ tuzi tzuꞌulëyaquëꞌ raꞌo tzaz̃e ca nacalaoꞌ nëꞌëdiꞌ, ca nacaliaꞌ luëꞌ. Canaꞌ reꞌendaꞌ Xuzaꞌ, reꞌendaꞌ initaꞌyaquëꞌ tuzi tacuenda inezi yaca benꞌ nitaꞌ lao yedyi layu de que luëꞌ useꞌeloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Baoyuꞌuliaꞌ leyaquëꞌ tuzi ca naca luëꞌ zulaoꞌ nëꞌëdiꞌ tuzi tacuenda tzuꞌuyaquëꞌ tuzi pensari cabëꞌ rue raꞌo, yuꞌuro tuzi pensari. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tuzi nacaliaꞌ leyaquëꞌ, lëscanꞌ tuzi nacoꞌ len nëꞌëdiꞌ. Lëcanaꞌ gacarëyaquëꞌ tuzi, inezi yaca benꞌ nitaꞌ lao yedyi layu de que luëꞌ useꞌeloꞌ nëꞌëdiꞌ, nedyëꞌëloꞌyaquëꞌ cabëꞌ nedyëꞌëloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Xuzaꞌ, ca yaca benꞌ pcaꞌnloꞌ lao naꞌa, reꞌendaꞌ sulëyaquëꞌ nëꞌëdiꞌ ganꞌ tzesuaꞌ tacuenda ilëꞌëyaquëꞌ yelaꞌ huaca quiaꞌ benloꞌ nëꞌëdiꞌ nun quie nedyëꞌëloꞌ nëꞌëdiꞌ desde binecueꞌte lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Xuzaꞌ, benꞌ laꞌiya nacoꞌ. Ca naca yaca benꞌ nitaꞌ lao yedyi layu, binubëꞌyaquëꞌ luëꞌ, pero nëꞌëdiꞌ sí, nubëꞌdaꞌ luëꞌ. Ca naca yaca benꞌ quiaꞌ, benꞌ nitaꞌlë nëꞌëdiꞌ niga, baneziyaquëꞌ luëꞌ useꞌeloꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Babzioñeꞌenaꞌ leyaquëꞌ ca nacoꞌ. Neruzioñeꞌeraꞌyaquëꞌ mazara ca nacoꞌ tacuenda idyëꞌëyaquëꞌ tu ituyaquëꞌ ca nedyëꞌëloꞌ nëꞌëdiꞌ, gacalëyaquëꞌ nëꞌëdiꞌ tuz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ude beyudyi unë Jesús canaꞌ, uzaꞌnëꞌ ziolënëꞌ yaca benꞌ quienëꞌ tzalaꞌ yao Cedrón. Lëganꞌ naꞌ dyiatzegue yaga ganꞌ begaꞌnlënëꞌ yaca benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Lëzi Judas, benꞌ usedyin lëbëꞌ lao naꞌa yaca benꞌ guti lëbëꞌ, nubëꞌrënëꞌ ganꞌ, danꞌ riozi rio Jesús lënëꞌ yaca benꞌ quienëꞌ ganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Canaꞌ guca uyo Judas yexiꞌnëꞌ yaca soldado len yaca benꞌ naca xaga idaoꞌ, yaca benꞌ useꞌelaꞌ yaca xanꞌ pxuzi, len yaca benꞌ partido fariseo. Nuꞌayaquëꞌ espada, nuꞌayaquëꞌ lámpara, nuꞌayaquëꞌ yëri yaga, bdyinyaquëꞌ ganꞌ zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Como Jesús nezinëꞌ binꞌ gaca quienëꞌ, naꞌra bronëꞌ ganꞌ nitaꞌlënëꞌ yaca benꞌ quienëꞌ, unëꞌ rëbinëꞌ yaca benꞌ bdyin guxu lëbëꞌ: ―¿Nuz̃i benꞌ reguilole? ");
INSERT INTO zpcNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Reguilondoꞌ Jesús, benꞌ yedyi Nazaret. Biz̃i Jesús unëꞌ rëbinëꞌ leyaquëꞌ: ―Nëꞌëdiꞌ benꞌ reguilole. Lëzi zërë Judas lënëꞌ yaca benꞌ bdyin guxu Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Naꞌ una Jesús rëbinëꞌ leyaquëꞌ: “Nëꞌëdiꞌ benꞌ reguilole”, naꞌtera guca bebigaꞌyaquëꞌ guzu xcuꞌudzula, bguꞌunyaquëꞌ layu. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Biz̃i unë Jesús tatula rëbinëꞌ leyaquëꞌ: ―¿Nuz̃i benꞌ reguilole? Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Reguilondoꞌ Jesús, benꞌ yedyi Nazaret. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Baonëcazaꞌ leꞌe nëꞌëdiꞌ benꞌ reguilole. Chi reguilole tuzaꞌ nëꞌëdiꞌ, ulesan yaca benꞌ niga yeyoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Una Jesús canꞌ ta uzun diꞌidzaꞌ ca unëꞌ rëbinëꞌ Xuzinëꞌ dza naꞌ: “Yaca benꞌ pcaꞌnloꞌ lao naꞌa, nituyaquëꞌ biuniti.” ");
INSERT INTO zpcNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Canaꞌ guca ulio Simón Pedro espada nuꞌanëꞌ udinëꞌn uchuguëꞌ naga yebë benꞌ lao Malco, benꞌ zulao xanꞌ pxuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Biz̃i una Jesús rëbinëꞌ Pedro: ―Bedzeꞌ espada quioꞌ luꞌu lidyin. ¿Cala binenezoꞌ decazide yedzagalaohuaꞌ ca ta banugun Xuzaꞌ quiaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Naꞌ biz̃i yaca soldado, len comandante quieyaquëꞌ, len yaca xaga idaoꞌ, bëxuyaquëꞌ Jesús pquioyaquëꞌ lëbëꞌ bëyaquëꞌ lëbëꞌ preso. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Naꞌra uquiëꞌyaquëꞌ lëbëꞌ z̃an yuꞌu quie Anás, benꞌ naca benꞌ gula quie Caifás. Lëiza naꞌ naca Caifás pxuzi rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","LëCaifás naquëꞌ benꞌ una dza naꞌla: “Nacalan huenla gati tuzi benëꞌ lao laza yaca benꞌ yedyi, cala ca ta gati yuguluro.” Canaꞌ unëꞌ dza naꞌla. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Naꞌ Simón Pedro len itu benꞌ quie Jesús, unaoyaquëꞌ yaca benꞌ nequiëꞌ Jesús. Biz̃i lëbenꞌ quie Jesús nubëꞌnëꞌ benꞌ naca xanꞌ pxuzi rnabëꞌra, lenaꞌ uyuꞌulënëꞌ Jesús laliꞌa quie yuꞌu quie xanꞌ pxuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Biz̃i Pedro begaꞌnnëꞌ ruꞌa yuꞌu quie laliꞌa. Naꞌra lëbenꞌ quie Jesús, benꞌ nubëꞌ pxuzi rnabëꞌra, broguëꞌ ruꞌa yuꞌu, bëꞌlënëꞌ nigula diꞌidzaꞌ, nigula rapa ruꞌa yuꞌu, ta bdzeꞌnëꞌ Pedro luꞌu laliꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Naꞌra una nigula naꞌ rëbinëꞌ Pedro: ―¿Cala nacaraoꞌ benꞌ quienëꞌ? Naꞌra una Pedro rëbinëꞌ nigula: ―Binacaꞌ benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Biz̃i yaca benꞌ zulao xanꞌ pxuzi len yaca xaga idaoꞌ, ulëchiyaquëꞌ guiꞌ laliꞌa como danꞌ ruen zaga. Unitaꞌyaquëꞌ ruꞌa guiꞌ ta yedzeꞌeyaquëꞌ. Lëzirë Pedro uzërënëꞌ len leyaquëꞌ tzaz̃e ruꞌa guiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Biz̃i benꞌ naca pxuzi rnabëꞌra, unabëꞌ Jesús nu benꞌ naca yaca benꞌ quienëꞌ, lëzi unabëꞌ bidanꞌ rsëdinëꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Biz̃i nëꞌëdiꞌ zaquëꞌlao yaca benëꞌ uniaꞌ rusëdiaꞌyaquëꞌ. Luꞌu idaoꞌ sinagoga, lëzi luꞌu idaoꞌ rnabëꞌra ganꞌ reguꞌudiꞌ yugulu benꞌ Israel, lëganꞌ naꞌ rsëdiaꞌyaquëꞌ. Bipsëdiaꞌyaquëꞌ balarazi. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Bixquienꞌ rnaboꞌ nëꞌëdiꞌ bidanꞌ rsëdiaꞌ? Unabacara yaca benꞌ babe cabëꞌ baoniaꞌ. Leyaquëꞌ huanayaquëꞌ ca diꞌidzaꞌ uniaꞌ. Baneziyaquëꞌ ca diꞌidzaꞌ gudyaꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ude beyudyi una Jesús canꞌ, biz̃i udapa tu benꞌ xaga idaoꞌ ruꞌa Jesús, unëꞌ rëbinëꞌ lëbëꞌ: ―¿Bixquienꞌ rëboꞌ pxuzi rnabëꞌra canaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Chi birniaꞌ diꞌidzaꞌ li, unacara bi diꞌidzaꞌ binacan diꞌidzaꞌ li. Pero chi rniaꞌ diꞌidzaꞌ li, ¿bixquienꞌ udapoꞌ ruꞌa? ");
INSERT INTO zpcNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Naꞌra bë Anás mandado uquiëꞌyaquëꞌ Jesús anerioguëꞌ lao Caifás, benꞌ nacarë pxuzi rnabëꞌra. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tu neraca quie Jesús canꞌ, biz̃i Pedro nezënëꞌ ruꞌa guiꞌ ta yedzeꞌenëꞌ. Naꞌra unaba yaca benꞌ nitaꞌ ganꞌ zënëꞌ: ―¿Cala nacaraoꞌ luëꞌ benꞌ quie Jesús? Naꞌ biz̃i Pedro unëꞌ rëbinëꞌ leyaquëꞌ: ―Binacaꞌ benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Naꞌra unë tu benꞌ zulao xanꞌ pxuzi, benꞌ naca familia quie benꞌ uchugu Pedro nague, rëbinëꞌ Pedro: ―¿Cala blëꞌëdaꞌ luëꞌ zëlaoꞌ Jesús ganꞌ dyia yaga? ");
INSERT INTO zpcNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Naꞌra una Pedro rëbinëꞌ leyaquëꞌ: ―Cala nëꞌëdiꞌ. Ca beyudyi unëꞌ canaꞌ, laoredyite biu tu. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Naꞌra uquiëꞌyaquëꞌ Jesús lidyi Caifás zioyaquëꞌ ga zu palacio ga reꞌ gobierno quieyaquëꞌ, naꞌ bazaꞌ reniꞌ. Biz̃i yaca benꞌ Israel, biuyuꞌuyaquëꞌ luꞌu palacio, danꞌ binaca benꞌ naca gobernador benꞌ Israel. Según naca costumbre quieyaquëꞌ, raqueyaquëꞌ bineyëriyaquëꞌ lao Diuzi chi tzuꞌuyaquëꞌ luꞌu lidyi benꞌ binaca benꞌ Israel. Nica gacazi gaoyaquëꞌ quie lani pascua len benꞌ binaca benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tanaꞌ lenaꞌ bro Pilato luꞌu palacio, zionëꞌ ga nitaꞌ yaca benëꞌ, unëꞌ rëbinëꞌ leyaquëꞌ: ―¿Cabiz̃i bë benꞌ niga, naꞌ raolenëꞌ xquia? ");
INSERT INTO zpcNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Chanꞌ binaquëꞌ benꞌ rue xquia, bidehuaꞌandoꞌnëꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Naꞌra una Pilato rëbinëꞌ leyaquëꞌ: ―Ulequiëꞌ benꞌ niga, ichugobëꞌle ca rna ley quiele leꞌe. Naꞌ biz̃i una yaca benꞌ Israel rëbiyaquëꞌ Pilato: ―Binapandoꞌ derecho gutindoꞌ yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Canaꞌ bzun diꞌidzaꞌ ca unë Jesús gaca quienëꞌ gatinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Naꞌra Pilato beyuꞌunëꞌ luꞌu palacio guz̃inëꞌ Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―¿Nacoꞌ rey quie benꞌ Israel? ");
INSERT INTO zpcNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―¿Ta racazi quioꞌ rnaboꞌ nëꞌëdiꞌ, o chi ta reloꞌ ca rna yaca benëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Naꞌra una Pilato rëbinëꞌ lëbëꞌ: ―¿Bixquienꞌ raqueloꞌ nacariaꞌ benꞌ Israel? Yaca benꞌ yedyi quioꞌ, len yaca xanꞌ pxuzi, leyaquëꞌ psedyinyaquëꞌ luëꞌ ganꞌ ni. ¿Cabiz̃i baoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Nacaꞌ benꞌ rnabëꞌ, pero cala quie lao yedyi layu niga. Chanꞌ nacaꞌ benꞌ rnabëꞌ quie lao yedyi layu niga, huadila yaca benꞌ nao nëꞌëdiꞌ len yaca benꞌ rudie nëꞌëdiꞌ ta biusedyinyaquëꞌ nëꞌëdiꞌ lao naꞌa yaca benꞌ reꞌen guti nëꞌëdiꞌ. Quie lenaꞌ rniaꞌ binacaꞌ benꞌ rnabëꞌ quie lao yedyi layu niga. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Naꞌra una Pilato rëbinëꞌ Jesús: ―¿Bi ca naoꞌ? ¿Nacacazoꞌ rey? Biz̃i Jesús unëꞌ rëbinëꞌ lëbëꞌ: ―Nacacazaꞌ rey con canꞌ baonaoꞌ. Para lenaꞌ bidaꞌ gologaꞌ lao yedyi layu ta quixoguiꞌa yaca benëꞌ ta naca tabala. Nu yaca benꞌ nao tabala rzënagacaziyaquëꞌ ca rniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Naꞌra una Pilato rëbinëꞌ lëbëꞌ: ―¿Ca bidanꞌ naca tabala? Ude beyudyi pquëpi Pilato Jesús, bero Pilato tatula luꞌu palacio zionëꞌ ga nitaꞌ yaca benꞌ Israel unëꞌ rëbinëꞌ leyaquëꞌ: ―Nëꞌëdiꞌ rniaꞌ leꞌe, nitu xquia binehue benꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Cabëꞌ leꞌe, de tu costumbre quiele yebiogaꞌ tu benꞌ de luꞌu dyiguiba ca raꞌalaꞌ lani pascua. ¿Biz̃i ca nale? ¿Reꞌenle yebiogaꞌ benꞌ naca rey quiele? ");
INSERT INTO zpcNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Naꞌra uredyiyaꞌyaquëꞌ unëyaquëꞌ zidzo rëbiyaquëꞌ Pilato: ―Biyebioloꞌ benꞌ naꞌ. Bebio Barrabás. Canaꞌ unayaquëꞌ rëbiyaquëꞌ Pilato. Naꞌ biz̃i Barrabás naquëꞌ tu benꞌ uban. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Caora naꞌ bë Pilato mandado udi yaca soldado Jesús guidi. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lëscanꞌ bzu yaca soldado tu coron dyia yëchiꞌ guicho Jesús, bgacoyaquëꞌ lëbëꞌ tu laꞌariꞌ z̃na chula, ");
INSERT INTO zpcNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","uzëyaquëꞌ zaquëꞌlao Jesús unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―¡Viva rey quie yaca benꞌ Israel! Caora naꞌ udiyaquëꞌ begoro xtalaonëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Naꞌra bro Pilato tatula luꞌu palacio unëꞌ rëbinëꞌ yaca benꞌ Israel: ―Ulenaꞌcara, bequiꞌa benꞌ ni sënëꞌ laole ta inezile bibi nitu xquia binehuenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Biz̃i ulioyaquëꞌ Jesús luꞌu palacio, nezu coron yëchiꞌ guichonëꞌ, nenacorënëꞌ laꞌariꞌ z̃na chula. Naꞌra una Pilato rëbinëꞌ leyaquëꞌ: ―Ulenaꞌcara bazë benꞌ ni. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ca blëꞌë yaca xanꞌ pxuzi len yaca benꞌ xaga idaoꞌ Jesús, naꞌtera uredyiyaꞌyaquëꞌ unëyaquëꞌ zidzo: ―¡Uledaꞌ benꞌ naꞌ lëꞌë yaga cruzo! ¡Uledaꞌ benꞌ naꞌ lëꞌë yaga cruzo! Biz̃i unë Pilato rëbinëꞌ leyaquëꞌ: ―Ulequiëꞌnëꞌ leꞌe, uledaꞌnëꞌ leꞌe lëꞌë yaga cruzo. Nëꞌëdiꞌ niaꞌ nitu xquia bibi nehuenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Naꞌra una yaca benꞌ Israel rëbiyaquëꞌ Pilato: ―Nëtoꞌ de tu ley quiendoꞌ. Según ca rna ley quiendoꞌ, reyaꞌalaꞌ gati benꞌ niga, danꞌ nëꞌ naquëꞌ z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ca be Pilato canꞌ unayaquëꞌ, caora naꞌ bdzebinëꞌ mazara. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Beyuꞌu Pilato luꞌu palacio tatula pquëpinëꞌ Jesús: ―¿Gaz̃i zaoꞌ luëꞌ? Pero Jesús uzënëꞌ chizi, bibequëbinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Naꞌra una Pilato rëbinëꞌ lëbëꞌ: ―¿Bixquienꞌ birudyiꞌiloꞌ diꞌidzaꞌ? ¿Binezoꞌ nëꞌëdiꞌ de yelaꞌ rnabëꞌ quiaꞌ huaꞌ mandado udaꞌyaquëꞌ luëꞌ lëꞌë yaga cruzo, o chi usanaꞌ luëꞌ, huaꞌ luëꞌ libre? ");
INSERT INTO zpcNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Bibi yelaꞌ rnabëꞌ quioꞌ luëꞌ de ta ichugubaoꞌ quiaꞌ chanꞌ Diuzi chi bibënnëꞌn luëꞌ. Tanaꞌ lenaꞌ nacara xquia quie benꞌ psedyin nëꞌëdiꞌ laoloꞌ, cala ca luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Lëhora naꞌ beguilolaꞌadyiꞌ Pilato ta usannëꞌ Jesús, huenëꞌ lëbëꞌ libre. Pero biz̃i yaca benꞌ Israel uredyiyaꞌyaquëꞌ unayaquëꞌ zidzo: ―Chi usanloꞌnëꞌ huuꞌnëꞌ libre, binacoꞌ amigo quie rey César, benꞌ rnabëꞌra raꞌo. Nu benꞌ ina naquëꞌ rey, lëbenꞌ naꞌ naquëꞌ enemigo quie rey César. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Biz̃i cati be Pilato bi una yaca benëꞌ, naꞌ bënëꞌ mandado bro Jesús luꞌu palacio. Ude naꞌ bebeꞌ Pilato xlatonëꞌ ga rchugobëꞌnëꞌ quie yaca benëꞌ. Lëlugar naꞌ neziꞌlaona diꞌidzaꞌ hebreo Gabata, ta inaro xtiꞌidzaꞌro: Layu ga yuꞌu yo lagaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mero laꞌodza, dza iteyu gaꞌalaꞌ lani pascua, una Pilato rëbinëꞌ yaca benꞌ Israel: ―¡Ni bazë rey quiele! ");
INSERT INTO zpcNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Biz̃i naꞌ uredyiyaꞌyaquëꞌ unëyaquëꞌ zidzo: ―¡Gatigaranëꞌ, gatigaranëꞌ! ¡Uledaꞌ benꞌ naꞌ lëꞌë yaga cruzo! Naꞌra una Pilato rëbinëꞌ leyaquëꞌ: ―¿Bixquienꞌ reꞌenle udaꞌndoꞌ rey quiele lëꞌë yaga cruzo? Pero biz̃i yaca xanꞌ pxuzi, unayaquëꞌ rëbiyaquëꞌ Pilato: ―Tuzi César naquëꞌ rey quiero. Nunura benꞌ tula zu naca rey quiero. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ude naꞌ psedyin Pilato Jesús lao naꞌayaquëꞌ ta udaꞌyaquëꞌ lëbëꞌ lëꞌë yaga cruzo, naꞌ uquiëꞌyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Lëcanaꞌ guca ziolëyaquëꞌ Jesús banuꞌanëꞌ tuzëꞌ yaga cruzo, bdyinyaquëꞌ ganꞌ neziꞌlaona diꞌidzaꞌ hebreo Gólgota, ta inaro xtiꞌidzaꞌro: Chita guicho benꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Lëganꞌ naꞌ bdaꞌyaquëꞌ Jesús lëꞌë yaga cruzo. Bdaꞌyaquëꞌ ichopa benëꞌ tzalaꞌ huio cuëta lëꞌë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bë Pilato mandado bdyiayaquëꞌ letra guicho cruzo rnën cani: “Jesús, benꞌ yedyi Nazaret, benꞌ naca rey quie yaca benꞌ Israel.” ");
INSERT INTO zpcNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Naꞌra yaca benꞌ zë, yaca benꞌ Israel blabayaquëꞌ letra, danꞌ nacan gaꞌalaꞌ ga reꞌ ciudad Jerusalén. Lao tzona cueꞌ diꞌidzaꞌ bdyiayaquëꞌ letra. Bdyiayaquëꞌ letra hebreo, len letra griego, len letra latín. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tanaꞌ lenaꞌ una yaca benꞌ xanꞌ pxuzi rëbiyaquëꞌ Pilato: ―Biudyiale letra rnën “Benꞌ naca rey quie yaca benꞌ Israel.” Mejorla udyiale letra inën “Benꞌ una nacaꞌ rey quie yaca benꞌ Israel.” ");
INSERT INTO zpcNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Naꞌra una Pilato rëbinëꞌ leyaquëꞌ: ―Ca letra babdyiaꞌ, yegaꞌnnan canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ude beyudyi udaꞌ yaca soldado Jesús lëꞌë yaga cruzo, uz̃iꞌyaquëꞌ z̃abanëꞌ bëꞌyaquëꞌ laze lao tapayaquëꞌ. Uz̃iꞌrëyaquëꞌ capa quienëꞌ. Nacan de tu dibazi, binacan de chopa yoꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Danꞌ nacan de tu dibazi, lenaꞌ una yaca soldado: ―Bichezaron. Mejorla huero tu suerte ta ineziro nularo gaca quie len. Canaꞌ guca bzun diꞌidzaꞌ ca rnën lëꞌë guichi quie Diuzi ga rnan: “Bëꞌyaquëꞌ laze z̃abaꞌ, uziꞌyaquëꞌn. Bëyaquëꞌ suerte quien.” Canaꞌ bë yaca soldado. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bago ga zu cruzo ga daꞌ Jesús, lëganꞌ naꞌ zë z̃nëꞌë, len z̃ila z̃nëꞌë, len María z̃gula Cleofas, lërë María Magdalena. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Naꞌra blëꞌë Jesús zë z̃nëꞌë bago len tu benꞌ quienëꞌ, benꞌ nedyëꞌënëꞌ. Naꞌ nacanꞌ unëꞌ rëbinëꞌ z̃nëꞌë: ―Z̃naꞌa, naꞌ zë z̃iꞌiloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Lëzirë unërënëꞌ benꞌ quienëꞌ: ―Naꞌ zë z̃naꞌloꞌ. Canaꞌ guca bequiëꞌ benꞌ quienëꞌ z̃nëꞌë z̃an yuꞌu quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Biz̃i banezi Jesús babzunëꞌ yugulute diꞌidzaꞌ ca guꞌun Xuzinëꞌ Diuzi. Naꞌra tacuenda zuran diꞌidzaꞌ ca rnën lëꞌë guichi quie Diuzi, lenaꞌ unëꞌ: ―Barbilidaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lëganꞌ naꞌ zu tu yesoꞌ yudzo vino banacan zi. Uz̃iꞌyaquëꞌ tu ta naca yunꞌ rzupiꞌ vino, bzuyaquëꞌn lao yaga, blaꞌoyaquëꞌn vino banacan zi. Ude naꞌ bzuyaquëꞌn ruꞌa Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Biz̃i caora bzuyaquëꞌn ruꞌa Jesús uzupinëꞌn, caora naꞌ unëꞌ: ―Babeyudyite bzun diꞌidzaꞌ. Ca beyudyi unëꞌ canaꞌ, bzëtaꞌ guichonëꞌ gutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Biz̃i dza naꞌ nacan dza iteyu gaꞌalaꞌ lani pascua. Lenaꞌ biguꞌun yaca benꞌ Israel yegaꞌn benëꞌ lëꞌë yaga cruzo, danꞌ dza iteyu gaꞌalaꞌ lani, nacan dza z̃e quie lani. Tanaꞌ lenaꞌ unabayaquëꞌ tu cule lao Pilato chi bihuenëꞌ mandado ta quitzu yaca soldado chita niꞌa yaca benꞌ daꞌ lëꞌë yaga cruzo, naꞌ yegubayaquëꞌ leyaquëꞌ ganꞌ daꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Canaꞌ uyo yaca soldado uditzuyaquëꞌ chita niꞌa yaca benꞌ udaꞌ lëꞌë yaga cruzo cuëta lëꞌë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ca bdyinyaquëꞌ cuëta lëꞌë Jesús, blëꞌëyaquëꞌ bagutinëꞌ. Tanaꞌ lenaꞌ bira uditzuyaquëꞌ chita niꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero tu soldado udyibinëꞌ lanza ruꞌachuꞌu Jesús. Caora naꞌ blato ren len nisa ganꞌ udyibi soldado lanza. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nëꞌëdiꞌ, Juan, blëꞌëdaꞌ canꞌ bëyaquëꞌ quienëꞌ. Nacaꞌ testigo cabëꞌ blëꞌëdaꞌ. Nacan tabala cabëꞌ rniaꞌ quienëꞌ tacuenda galele quienëꞌ inaole xnezëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tanaꞌ lenaꞌ guca quienëꞌ ta bzun diꞌidzaꞌ con ca rnan lëꞌë guichi quie Diuzi ganꞌ rnan: “Biquitzuyaquëꞌ ni tu chita quienëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Lëzi zurë itu diꞌidzaꞌ lëꞌë guichi laꞌiya quie Diuzi ga rnan: “Hualëꞌë yaca benꞌ bdyibi lanza ruꞌachuꞌuhue lëbëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ude beyudyi guca canꞌ, unaba tu benꞌ lao José, benꞌ yedyi Arimatea, chi bihueꞌ Pilato lato ta yeyuꞌanëꞌ cuerpo quie Jesús. Naca José benꞌ unao Jesús, pero negachiꞌzi, danꞌ rdzebinëꞌ quie yaca benꞌ rnabëꞌ. Naꞌ biz̃i Pilato bëꞌnëꞌ lato uyo José ta beyuꞌanëꞌ cuerpo quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Lëzirë bdyin Nicodemo, benꞌ uyo rtzeꞌ yegueꞌlë Jesús diꞌidzaꞌ dza naꞌla. Bdyinnëꞌ nuꞌë galobechi kilo aceite mirra nequixin itu ta lao áloes ta rlaꞌn z̃ixi z̃eo. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Caora naꞌ beziꞌyaquëꞌ cuerpo quie Jesús, ptubiyaquëꞌ lëbëꞌ laꞌariꞌ ta laꞌo aceite rlaꞌ z̃ixi z̃eo, según ca naca costumbre quie yaca benꞌ Israel rcachiꞌyaquëꞌ benꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Biz̃i gaꞌalaꞌ ganꞌ bdaꞌyaquëꞌ Jesús lëꞌë yaga cruzo, lëganꞌ naꞌ de tu lao lato ga dyia yaca yaga. Biz̃i lao lato naꞌ, zu tu yo beló cubi ga nitu yaca benꞌ huati binecachiꞌyaquëꞌ ganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Biz̃i luꞌu beló cubi naꞌ, pcachiꞌyaquëꞌ Jesús danꞌ zun gaꞌalaꞌ baruen bago dza huezilaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Biz̃i bala dza domingo nernaꞌ chula, uz̃iꞌ María Magdalena zionëꞌ ganꞌ zu beló yo ganꞌ pcachiꞌyaquëꞌ Jesús. Naꞌra blëꞌënëꞌ bira daꞌ yo lagaꞌ ta bdaꞌyaquëꞌ ruꞌa beló yo ganꞌ pcachiꞌyaquëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Caora naꞌ taria zaꞌ María ga zuaꞌ nëꞌëdiꞌ, benꞌ Jesús nedyëꞌë, zëliaꞌ Simón Pedro, ta unëꞌ nëtoꞌ unëꞌ: ―Babiꞌayaquëꞌ cuerpo quie Señor quiero. Bineziro ga yehuaꞌayaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Naꞌra uzaꞌliaꞌ Pedro ziondoꞌ yenaꞌndoꞌ ganꞌ pcachiꞌyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Brondoꞌ rupandoꞌ ziondoꞌ tzaz̃e. Biz̃i nëꞌëdiꞌ udyialaoraꞌ bdyinnezaꞌ ganꞌ ca Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Biz̃i byëchogaꞌ blëꞌëdaꞌ ganꞌ reꞌ laꞌariꞌ ptubiyaquëꞌ lëbëꞌ, pero biuyuꞌa luꞌu beló. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Biz̃i ca blaꞌ Simón Pedro, uyuꞌunëꞌ luꞌu beló yo, blëꞌërënëꞌ reꞌ laꞌariꞌ ptubiyaquëꞌ lëbëꞌ ganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Lëzirë blëꞌërënëꞌ reꞌ squiela laꞌariꞌ bdzeꞌyaquëꞌ guichonëꞌ. Blëꞌënëꞌ nedubin, bireꞌn tuzi len laꞌariꞌ ptubiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Naꞌra uyuꞌuriaꞌ nëꞌëdiꞌ luꞌu beló, blëꞌëdaꞌ canꞌ naca reꞌ yaca laꞌariꞌ, guledaꞌ tabala beban Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Biz̃i binegalendoꞌ ca rnan lëꞌë guichi laꞌiya quie Diuzi ganꞌ rnan de que baꞌalaꞌcazi gati Jesús, huebancazinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Naꞌra beziꞌndoꞌ zeyondoꞌ z̃an yuꞌu quiendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Biz̃i begaꞌn María rbedyinëꞌ zënëꞌ ruꞌa beló yo. Du rbedyinëꞌ bzëtaꞌ guichonëꞌ rnëꞌë luꞌu beló. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Naꞌra blëꞌënëꞌ chopa ángel nacoyaquëꞌ laꞌariꞌ bezëri. Reꞌyaquëꞌ ganꞌ udixuyaquëꞌ cuerpo quie Jesús, tunëꞌ zaquëꞌ xquichonëꞌ, ituëꞌ zaquëꞌ z̃niꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Naꞌra una yaca ángel rëbiyaquëꞌ María: ―Nigula, ¿bixquienꞌ rbedyoꞌ? Naꞌra bequëbinëꞌ rëbinëꞌ leyaquëꞌ: ―Danꞌ babiꞌayaquëꞌ Señor quiendoꞌ. Binezindoꞌ ganꞌ yehuaꞌayaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tu beyudyizi unëꞌ canꞌ, cati beyëchoguëꞌ rnëꞌë Jesús naꞌ zë ganꞌ. Pero bibezaquenëꞌ chi Jesús naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Caora naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Nigula, ¿bixquienꞌ rbedyoꞌ? ¿Nuz̃i reguiloloꞌ? Biz̃i María raquenëꞌ chi benꞌ rapa ganꞌ dyia yaca yaga. Naꞌra unëꞌ rëbinëꞌ lëbëꞌ: ―Señor, chi luëꞌ biꞌaloꞌ cuerpo, una nëꞌëdiꞌ ganꞌ yehuaꞌaloꞌnëꞌ ta cuenda tzaꞌ tzez̃iꞌanëꞌ yeyuꞌanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―¡María! Naꞌ biz̃i lëbëꞌ, beyalëꞌ unëꞌ rëbinëꞌ Jesús diꞌidzaꞌ hebreo: ―¡Raboni! ―ta inaro xtiꞌidzaꞌro: Maestro. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Naꞌ una Jesús rëbinëꞌ lëbëꞌ: ―Biudaꞌloꞌ naoꞌ nëꞌëdiꞌ, danꞌ bineyaꞌa guibá ganꞌ zu Xuzaꞌ. Ta reꞌendaꞌ iniaꞌ luëꞌ, beyo ganꞌ nitaꞌ yaca benꞌ bichaꞌ, benꞌ rnao nëꞌëdiꞌ, yëboꞌyaquëꞌ nëꞌëdiꞌ hueyaꞌa guibá ga zu Xuziro, benꞌ naca Diuzi quiero. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Biz̃i María Magdalena uyonëꞌ yetixogueꞌnëꞌ yaca benꞌ quie Jesús de que bablëꞌënëꞌ Señor quiero. Unëꞌ udixogueꞌnëꞌ leyaquëꞌ ca diꞌidzaꞌ gudyi Jesús lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Lëdza naꞌ, dza domingo rtzeꞌ, beguꞌudiꞌ yaca benꞌ quie Jesús tu luꞌu yuꞌu neyeyo, danꞌ rdzebiyaquëꞌ quie yaca benꞌ rnabëꞌ. Biz̃i uyuꞌu Jesús yatilalaohuëꞌ leyaquëꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Cueꞌ chizi luꞌu laxtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ude beyudyi unëꞌ canꞌ, bluꞌenëꞌ yaca benꞌ naꞌ naꞌanëꞌ len ruꞌachuꞌunnëꞌ. Lega redaohueyaquëꞌ blëꞌëyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Naꞌra una Jesús tatula rëbinëꞌ leyaquëꞌ: ―Cueꞌ chizi luꞌu laxtaꞌole. Cabëꞌ baoseꞌelaꞌ Xuzaꞌ nëꞌëdiꞌ babzuaꞌ diꞌidzaꞌ quienëꞌ, lëcanaꞌ nëꞌëdiꞌ iseꞌelaꞌ leꞌe ta uzule diꞌidzaꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Naꞌra blubëꞌ laoyaquëꞌ, unëꞌ rëbinëꞌ leyaquëꞌ: ―Tzuꞌu luꞌu laxtaꞌole Bichi Be quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nu yaca benꞌ bë xquia yeziꞌz̃ele quie, bira nao xquia quieyaquëꞌ leyaquëꞌ babez̃inan. Lëzirë nu yaca benꞌ biyeziꞌz̃ele quie, naocazi xquia quieyaquëꞌ leyaquëꞌ bibez̃inan. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Naꞌ Tomás, nacarënëꞌ benꞌ quie Jesús lao chipchopayaquëꞌ, naquëꞌ benꞌ uxubayaquëꞌ laohue benꞌ guidiꞌ, naꞌ biuzunëꞌ caora uyo Jesús tanëro yenaꞌnëꞌ yaca benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Lëlenaꞌ yaca benꞌ laguedyinëꞌ, yaca benꞌ quie Jesús, unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Bablëꞌëndoꞌ Señor quiero. Naꞌra una Tomás rëbinëꞌ leyaquëꞌ: ―Bigaledaꞌ babebannëꞌ chi biilëꞌëdaꞌ naꞌanëꞌ ganꞌ guca hueꞌ, naꞌ uquiaꞌ z̃biaꞌ ganꞌ udiyaquëꞌ bdido, lëscanꞌ uquiaꞌ tacaꞌ ruꞌachuꞌunnëꞌ ganꞌ udyibiyaquëꞌ lanza. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Guca lao xuna dza, cati beguꞌudiꞌ yaca benꞌ quie Jesús tu luꞌu yuꞌu tatula. Naꞌ zurë Tomás len leyaquëꞌ. Baꞌalaꞌcazi neyeyo ruꞌa yuꞌu, uyuꞌu Jesús luꞌu yuꞌu yasënëꞌ gatzo laꞌo ganꞌ nitaꞌyaquëꞌ. Unëꞌ rëbinëꞌ leyaquëꞌ tatula: ―Cueꞌ chizi luꞌu laxtaꞌole. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Naꞌra unëꞌ rëbinëꞌ Tomás: ―Unaꞌ luꞌu tacaꞌ, naꞌ pqui z̃beloꞌ ni. Lëscanꞌ bli naꞌaloꞌ, pqui tacoꞌ luꞌu ruꞌachuꞌa. Bira gacoꞌ benꞌ birale, pero gule babebanaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Naꞌra una Tomás rëbinëꞌ lëbëꞌ: ―Nacoꞌ Señor quiaꞌ, nacoꞌ Diuzi quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Biz̃i una Jesús rëbinëꞌ lëbëꞌ: ―Tomás, danꞌ bablëꞌëloꞌ nëꞌëdiꞌ, quie lenaꞌ baguleloꞌ. Yedaohuecazi yaca benꞌ rale quiaꞌ, baꞌalaꞌcazi binelëꞌëyaquëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Bëra Jesús yelaꞌ huaca tula lao yaca benꞌ quienëꞌ, pero birguixogueꞌn lëꞌë guichi ni yugulu yelaꞌ huaca bënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Babzuaꞌ diꞌidzaꞌ ni lëꞌë guichi ta rguixogueꞌn ca bë Jesús tacuenda galele quienëꞌ naquëꞌ Cristo, z̃iꞌi Diuzi, naꞌ gataꞌ yelaꞌ neban tuzioli quiele. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ude beyudyi bë Jesús canꞌ, ptilalaohuëꞌ tatula yaca benꞌ quienëꞌ ruꞌa lagun Tiberias. Ni ruꞌen diꞌidzaꞌ ca bë Jesús ptilalaonëꞌ yaca benꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Lëdza naꞌ uzë Simón Pedro tzaz̃e len Tomás, benꞌ nexubayaquëꞌ laohue benꞌ guidiꞌ, len Natanael, benꞌ yedyi Caná quie estado Galilea, len yaca z̃iꞌi Zebedeo, len ichopa yaca benꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Biz̃i una Simón Pedro rëbinëꞌ leyaquëꞌ: ―Huayaꞌa tzexiaꞌ bela. Biz̃i unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Lëzi nëtoꞌ huazaꞌrëndoꞌ len luëꞌ. Naꞌra uyuꞌuyaquëꞌ luꞌu barco zioyaquëꞌ lao nisa. Bedu yela rdayaquëꞌ lao nisa, pero nitu bela nunu uz̃eyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bazaꞌ tzeniꞌ bdyin Jesús zënëꞌ ruꞌa lagun. Pero biz̃i yaca benꞌ quienëꞌ, reꞌyaquëꞌ luꞌu barco, bibezaqueyaquëꞌ chi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Bichaꞌ, ¿babële gan bela gaoro? Biz̃i unayaquëꞌ rëbiyaquëꞌ lëbëꞌ: ―Ni tubaꞌ binehuendoꞌ gan. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Uledzeꞌ du yëxo quiele zaquëꞌ yebë ganꞌ nitaꞌle luꞌu barco ta tzuꞌu bela. Naꞌra bëyaquëꞌ cabëꞌ una Jesús bdzeꞌyaquëꞌ du yëxo luꞌu nisa. Caora naꞌ bedzaꞌten uyuꞌun bela zë gula, bira uzueyaquëꞌ yebioyaquëꞌ du yëxo. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Biz̃i una tu benꞌ quie Jesús, benꞌ Jesús nedyëꞌë, rëbinëꞌ Pedro: ―Señor quiero benꞌ naꞌ. Naꞌra como danꞌ nelëcho z̃aba Pedro reꞌnëꞌ luꞌu barco, ca benëꞌ ca uniaꞌ, labeyacatenëꞌ z̃abëꞌ laohue, udaꞌnëꞌ luꞌu nisa ta yedyinnëꞌ ganꞌ zë Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Naꞌra yaca los demás benꞌ begaꞌn luꞌu barco, psaꞌyaquëꞌ barco ta yedyinyaquëꞌ layu bidyi. Tzegubayaquëꞌ du yëxo nedzaꞌten bela como danꞌ nerdziogue itu gayuhua metrozi ta yedyinyaquëꞌ layu bidyi. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Caora bedyinyaquëꞌ layu bidyi, broyaquëꞌ barco blëꞌëyaquëꞌ reꞌ baoꞌ guiꞌ z̃uban tu bela. Lëzi derë yëta xtila ganꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Naꞌra una Jesús rëbinëꞌ leyaquëꞌ: ―Uletzexiꞌ tu chopa bela baoz̃ele bachi. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Biz̃i beyuꞌu Simón Pedro luꞌu barco, tzegubanëꞌ du yëxo ganꞌ yuꞌu yaca bela. Nedzaꞌten tu gayuhua yugatzo tzona bela yela. Baꞌalaꞌcazi bedzaꞌten bela, biurugon. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Biz̃i una Jesús rëbinëꞌ leyaquëꞌ: ―Uleda gaole rzila. Naꞌra leyaquëꞌ nituyaquëꞌ bibeyaz̃oyaquëꞌ inabayaquëꞌ nu naquëꞌ danꞌ babezaqueyaquëꞌ lëbëꞌ naquëꞌ Señor quiero. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Naꞌra ubigaꞌ Jesús ganꞌ nitaꞌyaquëꞌ, uz̃iꞌnëꞌ yëta xtila len bela bëꞌnëꞌn leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Canaꞌ guca lao tzona lasa ptilalao Jesús yaca benꞌ quienëꞌ ude beyudyi gutinëꞌ bebannëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ude beyudyi udaoyaquëꞌ rzila, una Jesús rëbinëꞌ Simón Pedro: ―Simón, z̃iꞌi Jonás, ¿nedyëꞌëroꞌ nëꞌëdiꞌ ca nedyëꞌëloꞌ nutezi benꞌ tula? Naꞌra una Pedro rëbinëꞌ lëbëꞌ: ―Señor, luëꞌ nezoꞌ nedyëꞌëdaꞌ luëꞌ. Biz̃i una Jesús rëbinëꞌ Pedro: ―Reꞌendaꞌ uzioñeꞌeloꞌ yaca benꞌ barale quiaꞌ. Nacayaquëꞌ ca quie becoꞌ z̃iꞌilaꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Naꞌ taorupe una Jesús rëbinëꞌ Pedro: ―Simón, z̃iꞌi Jonás, ¿nedyëꞌëloꞌ nëꞌëdiꞌ? Naꞌra una Pedro rëbinëꞌ lëbëꞌ: ―Señor, luëꞌ nezoꞌ nedyëꞌëcazaꞌ luëꞌ. Biz̃i una Jesús tatula rëbinëꞌ Pedro: ―Reꞌendaꞌ uzioñeꞌeloꞌ yaca benꞌ barale quiaꞌ. Nacayaquëꞌ ca quie becoꞌ z̃iꞌilaꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Naꞌ taoyune unaba Jesús Pedro rëbinëꞌ lëbëꞌ: ―Simón, z̃iꞌi Jonás, ¿nedyëꞌëcazoꞌ nëꞌëdiꞌ? Biz̃i Pedro begaꞌnnëꞌ gucayëchiꞌnëꞌ, danꞌ unaba Jesús lëbëꞌ lao yuna lasa chi nedyëꞌënëꞌ lëbëꞌ. Naꞌra unëꞌ rëbinëꞌ Jesús: ―Señor, luëꞌ banezoꞌ yugulute, banezoꞌ nedyëꞌëcazidaꞌ luëꞌ. Naꞌra una Jesús tatula rëbinëꞌ Pedro: ―Reꞌendaꞌ uzioñeꞌeloꞌ yaca benꞌ barale quiaꞌ. Nacayaquëꞌ ca quie becoꞌ z̃iꞌilaꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tali ca rniaꞌ luëꞌ, cati gucoꞌ biꞌ ruꞌabe, cuinzoꞌ gucoloꞌ z̃aboꞌ uyoloꞌ con ga reꞌenloꞌ, pero cati gacoꞌ benꞌ gula, hualioꞌ naꞌaloꞌ tacuenda ugaco benꞌ tula luëꞌ z̃aboꞌ ta tzehuaꞌayaquëꞌ luëꞌ con ga bireꞌenloꞌ tzioloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Una Jesús canꞌ tacuenda ineziro ca hue Pedro huenëꞌ Diuzi benꞌ z̃e hora gatinëꞌ. Ude beyudyi unë Jesús canꞌ, naꞌ unëꞌ rëbinëꞌ Pedro: ―Unao nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ca beyëcho Pedro, blëꞌënëꞌ nëꞌëdiꞌ zaꞌ naohuaꞌ leyaquëꞌ. Nedyëꞌëtzegue Jesús nëꞌëdiꞌ. Naꞌ uriꞌa cuëta lëꞌë Jesús caora udaondoꞌ rtzeꞌ dza naꞌ. Caora naꞌ unabaꞌ rëpaꞌnëꞌ: “Señor, ¿ca nuz̃i usedyin luëꞌ lao yaca benꞌ reꞌen guti luëꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Caora blëꞌë Pedro nëꞌëdiꞌ, unëꞌ rëbinëꞌ Jesús: ―Señor, ¿cabiz̃i gaca quie benꞌ niga? ");
INSERT INTO zpcNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Naꞌra una Jesús rëbinëꞌ Pedro: ―Chi reꞌendaꞌ sura benꞌ niga zidza hasta que bëꞌ yeguidaꞌ tatula, ¿biz̃cuenda quioꞌ luëꞌ rnaboꞌ nëꞌëdiꞌ? Pero luëꞌ, unao nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Canaꞌ guca bro diꞌidzaꞌ lado yaca benꞌ barale quie Jesús cabëꞌ gaca quiaꞌ bigatiaꞌ. Pero cala canaꞌ una Jesús, sino que unëꞌ: “Chi reꞌendaꞌ sura benꞌ niga zidza, hasta que bëꞌ yeguidaꞌ tatula, ¿biz̃cuenda quioꞌ luëꞌ rnaboꞌ nëꞌëdiꞌ?” Canaꞌ una Jesús rëbinëꞌ Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nëꞌëdiꞌ, benꞌ quie Jesús, bzuaꞌ diꞌidzaꞌ ni lëꞌë guichi. Blëꞌëdaꞌ nacaꞌ testigo cabëꞌ guca quie Jesús. Banezile nacan tali canꞌ baoniaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Lëzi dera ta bë Jesús. Chanꞌ uzuro lëꞌë guichi yugulute ta bë Jesús, bigaque lao yedyi layu gataꞌ libro ga ruꞌen diꞌidzaꞌ ta bë Jesús. Amén.");
INSERT INTO zpcNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Estimado Teófilo, lëꞌë guichi biaꞌ tanëro, rguixogueꞌn quie Jesús yugulu cabëꞌ bënëꞌ len yugulu cabëꞌ psëdinëꞌ yaca benëꞌ desde dza uzulaonëꞌ rusëdinëꞌ benëꞌ ");
INSERT INTO zpcNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta dza beyëpinëꞌ ladza. Pero zayeyëpinëꞌ ladza, ulionëꞌ lao chipchopa benꞌ quienëꞌ. Caora naꞌ lao naꞌa Bichi Be quie Diuzi unëꞌ gudyinëꞌ leyaquëꞌ bi hueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ude beyudyi agutinëꞌ bebannëꞌ, caora naꞌ zionëꞌ ptilëꞌ ja benꞌ quienëꞌ, uzulënëꞌ leyaquëꞌ lao chopa galo dza ta ineziyaquëꞌ tabala bebannëꞌ. Lëscanꞌ unëꞌ rëbinëꞌ leyaquëꞌ ca rna Diuzi rnabëꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tu binezaꞌnëꞌ guibá unëꞌ gudyinëꞌ leyaquëꞌ ta biyezaꞌyaquëꞌ ciudad Jerusalén. Naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ―Nizi cuezale gaca quiele ca una Xuzaꞌ huenëꞌ quiele ");
INSERT INTO zpcNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","según cabëꞌ agudyaꞌ leꞌe. Naꞌ tali naꞌ bëꞌ Juan laole conlë nisa, pero netzaꞌla ca hue Diuzi quiele, iseꞌelëꞌ Bichi Be quienëꞌ ta tzuꞌunëꞌ laxtaꞌole ichopa tzona dza. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Naꞌra cati bdyin dza, bedupa benꞌ quie Jesús tatula bëꞌlëjëꞌ lëbëꞌ diꞌidzaꞌ: ―¿Señor, rnabandoꞌ luëꞌ chi babdyin hora huuꞌ mandado yenabëꞌro lao yedyi quiero tatula como unabëꞌ xuzixtaꞌoro dza naꞌte? ");
INSERT INTO zpcNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Naꞌra bequëbi Jesús nëꞌ rëbinëꞌ leyaquëꞌ: ―Binacan quiele inezile bi hora, bi tiempo, hue Xuziro Diuzi bi reꞌennëꞌ huenëꞌ, porque tuzi Diuzi de yelaꞌ rnabëꞌ quienëꞌ bi reꞌennëꞌ huenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero leꞌe, caora baoyuꞌu Bichi Be quie Diuzi luꞌu guicho laxtaꞌole, canaꞌ gataꞌ quiele yelaꞌ huaca quie Diuzi. Te naꞌ tziole tzetixogueꞌle yaca benëꞌ len cabëꞌ biaꞌ cabëꞌ uniaꞌ. Tanëro tziole ciudad Jerusalén. Naꞌ tziorële estado Judea len estado Samaria. Naꞌtera hasta duz̃e yedyi layu tziole. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ude beyudyi unëꞌ canaꞌ, tu nernaꞌyaquëꞌ lëbëꞌ, beyëpi Jesús ladza, bdubi beo lëbëꞌ, bira blëꞌëyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nernaꞌyaquëꞌ ladza ga zio Jesús, caora labdyinte chopa ángel nacoyaquëꞌ laꞌariꞌ bezëri. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Naꞌra unayaquëꞌ rëbiyaquëꞌ benꞌ quie Jesús: ―¡Benꞌ Galilea! ¿Bixquienꞌ rebanle rnaꞌle ladza ganꞌ zeyo Jesús guibá? Rnandoꞌ leꞌe cabëꞌ blëꞌële beyëpinëꞌ ladza zeyonëꞌ guibá, canaꞌ yeguidanëꞌ lao yedyi layu tatula. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Naꞌra uzaꞌyaquëꞌ yaꞌa Olivos bdyinyaquëꞌ ciudad Jerusalén. Biz̃i yaꞌa ga uzaꞌyaquëꞌ nacan gaꞌalaꞌ para idyinjëꞌ ciudad Jerusalén. Bigucan gatzo legua. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Naꞌ cati bdyinyaquëꞌ ciudad Jerusalén, bdyinyaquëꞌ ga reꞌ tu yuꞌu chopa xcuia, urëyaquëꞌ ga nacan lao chopa xcuia naꞌ. Entre leyaquëꞌ laojëꞌ Pedro, len Juan, len Santiago, len Andrés, len Felipe, len Tomás, len Bartolomé, len Mateo, len Santiago z̃iꞌi Alfeo, len Simón benꞌ partido cananista, len Judas z̃iꞌi Santiago. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yugu dza bedupalëjëꞌ María, z̃naꞌ Jesús, len yaca benꞌ bichi Jesús, len yaca itu chopa nígula tacuenda hueꞌlëjëꞌ Diuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Biz̃i bdyin dza beguꞌudiꞌ du tu gayuhua galo benꞌ rale quie Jesús. Naꞌ gatzo laoꞌ reꞌ Pedro uzulinëꞌ rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Bichaꞌ, zanaꞌ, bisaqueꞌ te canaꞌzi diꞌidzaꞌ quie Diuzi. Reꞌen ca reꞌena gaca quie Judas laga con ca una rey David lao naꞌa Bichi Be quie Diuzi, porque bë Judas tuz̃e len yaca benꞌ bëxo Jesús, benꞌ bë lëbëꞌ preso. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Lëscanꞌ bë Judas raꞌo tuz̃e udixogueꞌlëronëꞌ yaca benëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Beyaꞌonëꞌ tu cueꞌ layu conlë dumi ta udiz̃uyaquëꞌ lëbëꞌ quie tamala bënëꞌ. Pero bdyin dza bgudyinëꞌ yu utin guidi lëꞌënëꞌ, naꞌ brote xlonëꞌ yaqueꞌn layula. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Por lenaꞌ uxuba benꞌ Jerusalén lao layu quienëꞌ Acéldama, ta inaro xtiꞌidzaꞌro: Layu ga ulato ren. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Porque rnën luꞌu libro Salmos cani: Huadachi yuꞌu quienëꞌ, yegaꞌnnan canaꞌzi. Ganura dyilaꞌ su luꞌu lidyinëꞌ. Lëzi cani rnën: Huaziꞌ benꞌ tula dyin quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Naꞌra nerna Pedro rëbinëꞌ leyaquëꞌ: ―Ladoro niga zu yaca benꞌ uzaꞌlë raꞌo tuz̃e caora uzulaoro udalëro Jesús ");
INSERT INTO zpcNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","desde cati bëꞌ Juan lao benëꞌ hasta dza beyëpi Jesús ladza. Reꞌennan cuioro benꞌ tula tacuenda gacarënëꞌ testigo conlë raꞌo de que nacan tabala babeban Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Naꞌra ulioyaquëꞌ chopa beꞌmbyu. Tunëꞌ laonëꞌ Matías, itunëꞌ laonëꞌ José, benꞌ laorë Barsabás, lëscanꞌ laorënëꞌ Justo. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Naꞌ biz̃i bëꞌlë yaca apóstol Diuzi diꞌidzaꞌ rëbiyaquëꞌ lëbëꞌ: ―Xuzindoꞌ Diuzi, luëꞌ nezoꞌ cabëꞌ naca pensari quie quiendoꞌ. Una nëtoꞌ nu benꞌ reꞌenloꞌ cuiondoꞌ lao rupa yaca benꞌ nitaꞌja ni ");
INSERT INTO zpcNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tacuenda saꞌlënëꞌ nëtoꞌ yegaꞌnnëꞌ lao laza Judas. Cabëꞌ bë Judas, gucanëꞌ benꞌ mala, zeyonëꞌ ga reyaꞌalaꞌ zagacanëꞌ castigo. ");
INSERT INTO zpcNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Naꞌra bëyaquëꞌ sorteo lao rupayaquëꞌ. Naꞌ biz̃i Matías bënëꞌ gan sorteo bënëꞌ tuz̃e lao ichiptu ja apóstol. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Naꞌra guca dza lani quie usecho quie trigo laona lani quie pentecostés. Por lani naꞌ, bdupa yaca benꞌ quie Jesús tu luꞌu yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Biz̃i desde guibá ga zu Diuzi zaꞌ chiꞌ ca tu be bedunꞌ fuerte. Cati bdyinnan, uyuꞌun luꞌu yuꞌu gan reꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Lëzi, tu ta raꞌalaꞌ ca guiꞌ ptilalaonan leyaquëꞌ. Nacan forma ca ludyi benëꞌ. Naꞌra bdyinnan bdzatzana ziona tu huioyaquëꞌ ga reꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Caora naꞌ uyuꞌu Bichi Be quie Diuzi luꞌu laxtaꞌoyaquëꞌ yugulujëꞌ. Lenaꞌ uzulaoyaquëꞌ rnëyaquëꞌ diꞌidzaꞌ quie benꞌ tula. Yelaꞌ huaca quie Bichi Be quie Diuzi lagucateyaquëꞌ diꞌidzaꞌ quie benꞌ yedyi tula. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Naꞌra ciudad Jerusalén unitaꞌ zë benꞌ Israel, benꞌ rezaꞌlaꞌadyiꞌ Diuzi. Zë yedyi bdzatzajëꞌ bdyinyaquëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Biz̃i caora beyaquëꞌ rnë benꞌ quie Jesús xtiꞌidzaꞌ tu tujëꞌ, begaꞌnyaquëꞌ rebanyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Biz̃i yelaꞌ uban guca quieyaquëꞌ unayaquëꞌ: ―Benꞌ rnë diꞌidzaꞌ niga, ¿quele benꞌ estado Galilea? ¿Cómo arnëyaquëꞌ diꞌidzaꞌ quie tu turo? ");
INSERT INTO zpcNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Cómo rero xtiꞌidzaꞌro ga goloro? ");
INSERT INTO zpcNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Niga nitaꞌ benꞌ Partia, len benꞌ Media, len benꞌ Elam, len benꞌ Mesopotamia, len benꞌ Judea, len benꞌ Capadocia, len benꞌ Ponto, len benꞌ Asia, ");
INSERT INTO zpcNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","len benꞌ Frigia, len benꞌ Panfilia, len benꞌ Egipto, len benꞌ Africa ga nebaba yedyi Cirene, ");
INSERT INTO zpcNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","len benꞌ Creta len benꞌ Arabia. Benꞌ Israel nacayaquëꞌ. Uzaꞌyaquëꞌ yedyi quiejëꞌ bdyinyaquëꞌ ciudad Jerusalén. Lëzi niga rda yaca benꞌ Roma, benꞌ bida tu hueltazi. Balayaquëꞌ nacayaquëꞌ benꞌ Israel, ibalayaquëꞌ baꞌalaꞌcazi binacayaquëꞌ benꞌ Israel, rnaoyaquëꞌ costumbre quie ja benꞌ Israel. ¿Cómo, pues, rnë benꞌ estado Galilea diꞌidzaꞌ quie tu turo, rguixogueꞌyaquëꞌ raꞌo cabëꞌ naca yelaꞌ huaca quie Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Biz̃i lega reban ja benꞌ zaꞌja yedyi tula, porque binezijëꞌ bi raca quiejëꞌ. Lenaꞌ nayaquëꞌ rëbijëꞌ laguedyiyaquëꞌ: ―¿Biz̃i raca niga? ");
INSERT INTO zpcNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Naꞌra ibalayaquëꞌ ptitojëꞌ yaca benꞌ quie Jesús rëbiyaquëꞌ laguedyijëꞌ: ―Az̃udyiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Naꞌra uzuli Pedro len ichiptu ja apóstol. Uzulaonëꞌ rnëꞌ zidzo rëbinëꞌ yaca benëꞌ nitaꞌ naꞌ: ―Uzëcara nagale, leꞌe benꞌ estado Judea len leꞌe benꞌ ciudad Jerusalén. Reꞌendaꞌ iniaꞌ leꞌe tu chopa diꞌidzaꞌ nacan belao yele. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bigacale pensari aoz̃udyindoꞌ, porque nenacara baguin. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Cala aoz̃udyindoꞌ, dechanꞌ ruen quiendoꞌ ca una profeta Joel dza naꞌte cati unëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dza baruen bago yedu yedyi layu, udzeꞌ Diuzi Bichi Be quienëꞌ luꞌu laxtaꞌo benëꞌ. Por lenaꞌ quixogueꞌ z̃iꞌiro cabëꞌ naca diꞌidzaꞌ laꞌiya quie Diuzi. Por lenaꞌ uluꞌe Diuzi biꞌ ruꞌabe quiero tu ta bineluꞌenëꞌ raꞌo. Por lenaꞌ hue Diuzi mandado ixusa benꞌ gula quiero, pero tu ta binexusayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Lëzi zaidyinra dza, udzeꞌ Diuzi Bichi Be quienëꞌ luꞌu laxtaꞌo nu benꞌ naca benꞌ quienëꞌ, chi beꞌmbyu, chi nigula. Por lenaꞌ quixogueꞌjëꞌ benëꞌ xtiꞌidzaꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lëzi z̃an guibá uluꞌe Diuzi tu ta yebanro ilëꞌëron. Pues huenëꞌ seña quienëꞌ lao yedyi layu como hualato ren, huayala guiꞌ duz̃e, huabeꞌ dzen ca beola. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lëzi huechula obidza, inaꞌ biuꞌ z̃nazi como ca ren. Canaꞌ gaca tu dza antes zaidyin dza hue Diuzi juicio. Naca lëdza naꞌ dza belao, gaca tu ta binelëꞌëro. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Biz̃i yugulu benꞌ ulidza Diuzi, benꞌ rzëto laohuëꞌ, ute usela Diuzi leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Naꞌra nernë Pedro rëbinëꞌ leyaquëꞌ: ―Uzëcara nagale cabëꞌ iniaꞌ leꞌe benꞌ Israel. Jesús, benꞌ yedyi Nazaret, babluꞌe Diuzi lao leꞌe lega yaxenëꞌ ca bënëꞌ como danꞌ lao naꞌanëꞌ bë Diuzi yelaꞌ huaca quienëꞌ zacaꞌlao leꞌe. Dyëꞌëdi nezile cabëꞌ guca quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pues según ca pensari bë Diuzi huenëꞌ dza naꞌte, napsedyinnëꞌ Jesús lao naꞌale. Naꞌra leꞌe bële lëbëꞌ preso, bdaꞌlenëꞌ lëꞌë yaga cruzo bëtilenëꞌ, bële tuz̃e conlë yaca benꞌ mala. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero pseban Diuzi lëbëꞌ. Tuzioli bira gatinëꞌ, porque bira saqueꞌ yelaꞌ guti huenan gan Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Naꞌra nernë Pedro rëbinëꞌ leyaquëꞌ con cabëꞌ una rey David quie Jesús dza naꞌla: Bablëꞌëdaꞌ zu Diuzi rnaꞌ ruhuianëꞌ nëꞌëdiꞌ yugu dza. Zuëꞌ cuëtaꞌ zaquëꞌ yebë rapanëꞌ nëꞌëdiꞌ. Quie lenaꞌ birdzebaꞌ bi tamala gaca quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Quie lenaꞌ zu gusto luꞌu guichi laxtaꞌohuaꞌ, redaohuedaꞌ ruꞌeliaꞌ Diuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Quie lenaꞌ birdzebaꞌ rbezaꞌ dza useban Diuzi cuerpo quiaꞌ, porque biusan Diuzi alma quiaꞌ yeyon gabila ga de yaca benꞌ huati. Lëscanꞌ bihueꞌnëꞌ lato itabo cuerpo quiaꞌ nëꞌëdiꞌ, benꞌ laꞌiya quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Abzioñeꞌe Diuzi nëꞌëdiꞌ cabëꞌ naca xnezëꞌ. Nu benꞌ inao xnezëꞌ, huataꞌ yelaꞌ neban quieyaquëꞌ tuzioli. Legazi redaohuedaꞌ danꞌ zuliaꞌ Diuzi tuz̃e. Naꞌra nernë Pedro rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","―Bichaꞌ, nacan tali aguti xuzixtaꞌoro rey David dza naꞌla. Pues apcachiꞌyaquëꞌ lëbëꞌ, nerezaꞌlaꞌadyiꞌro ga de ba quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Naꞌra como guca rey David benꞌ profeta, benꞌ rguixogueꞌ diꞌidzaꞌ quie Diuzi, quie lenaꞌ unezinëꞌ begaꞌnlë Diuzi lëbëꞌ diꞌidzaꞌ de que gaca tu z̃iꞌi subanëꞌ benꞌ naca Cristo, huatzequeꞌnëꞌ xlatonëꞌ inabëꞌnëꞌ. Babgunte Diuzi cuinnëꞌ gacan ca unëꞌ gacan. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Lëscanꞌ ca benꞌ bablëꞌë una rey David useban Diuzi Cristo. Quie Cristo unëꞌ caora unëꞌ biusan Diuzi yeyo alma quienëꞌ guiꞌ gabila ga de benꞌ huati. Bihueꞌnëꞌ lato itabo cuerpo quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nëtoꞌ yugulundoꞌ nacandoꞌ testigo pseban Diuzi Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Canaꞌ ureꞌnëꞌ zaquëꞌ yebë cuëta Diuzi ga naca xlato benꞌ balaꞌana. Lëscanꞌ useꞌelaꞌ Diuzi Bichi Be quienëꞌ según diꞌidzaꞌ begaꞌnlë Diuzi Jesús dza naꞌ. Por lëbëꞌ bablëꞌële babele yelaꞌ huaca quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Naꞌra quele rey David beyëpinëꞌ ladza, sino que lëbëꞌ unëꞌ quie Jesús cati unëꞌ cani: Una Diuzi rëbinëꞌ benꞌ naca Señor quiaꞌ: “Ureꞌ cuëtaꞌ zaquëꞌ yebë niga, ");
INSERT INTO zpcNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta idyin dza cuëchaꞌ xniꞌaloꞌ ja benꞌ rudie luëꞌ.” Naꞌra nernë Pedro rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","―Reyaꞌalaꞌ inezi yugulu benꞌ Israel du laꞌadyiꞌyaquëꞌ de que lëbenꞌ bdaꞌyaquëꞌ lëꞌë yaga cruzo naquëꞌ benꞌ bë Diuzi nombrar Señor quiero lëscanꞌ Cristo quiero. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ude beyudyi bzënagayaquëꞌ ca una Pedro, caora naꞌ ben bayëchiꞌ pensari quiejëꞌ unabayaquëꞌ rëbiyaquëꞌ Pedro len los demás apóstoles: ―Bichaꞌ, ¿biz̃i ca huendoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Naꞌra una Pedro rëbinëꞌ leyaquëꞌ: ―Uletzaꞌ pensari quiele, ulehue lato hueꞌndoꞌ laole quie quiele rzëtondoꞌ lao Jesucristo tacuenda yeziꞌz̃e Diuzi dulaꞌ xquia quiele. Canaꞌ udzeꞌnëꞌ Bichi Be quienëꞌ luꞌu guicho laxtaꞌole con cabëꞌ una Diuzi huenëꞌ quiele dza naꞌte. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pero quele para leꞌezi una Diuzi canaꞌ dza naꞌte, lëscanꞌ quie ja z̃iꞌile zazaꞌ, lëscanꞌ quie ja benꞌ binaca benꞌ Israel, para nutezi benꞌ cuio Diuzi gaca benꞌ gale quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Canaꞌ una Pedro bëꞌnëꞌ leyaquëꞌ consejo rëbinëꞌ leyaquëꞌ: ―Ulebigaꞌ tzalaꞌla bihuele tuz̃e yaca benꞌ birzënaga quie Diuzi, benꞌ nebiaguiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pues naꞌra zëyaquëꞌ uyezilaꞌadyiꞌjëꞌ gulejëꞌ ca una Pedro. Dza naꞌ, tu dzazi, gule ja tzona mila benëꞌ, bëjëꞌ tuz̃e len yaca apóstol. Naꞌra bëꞌ ja apóstol laoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bipsanjëꞌ inaojëꞌ ca gudyi yaca apóstol leyaquëꞌ. Begaꞌnlëyaquëꞌ laguedyiyaquëꞌ tuzi, bëꞌlëyaquëꞌ Diuzi diꞌidzaꞌ, bedupajëꞌ bz̃uz̃uyaquëꞌ yëta xtila. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Naꞌra tu rebanzi benꞌ birale cabëꞌ bë ja apóstol yelaꞌ milagro quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Biz̃i begaꞌn benꞌ quie Jesús de acuerdo entre leyaquëꞌ, bëꞌyaquëꞌ laze entre lëjëꞌ yugulu ta de quieyaquëꞌ. Lëzi chi nitaꞌ benꞌ bide dumi quie, ");
INSERT INTO zpcNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","naꞌra bëtiꞌyaquëꞌ ta de quieyaquëꞌ bëꞌyaquëꞌ benꞌ bide dumi quie. ");
INSERT INTO zpcNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tu dza, tu dza, beguꞌudiꞌyaquëꞌ luꞌu idaoꞌ rnabëꞌra, lëscanꞌ luꞌu yuꞌu quie tu tuyaquëꞌ uyoyaquëꞌ yetaoyaquëꞌ. Legazi redaohueyaquëꞌ udaoyaquëꞌ tuz̃e, bz̃uz̃uyaquëꞌ yëta xtila bezaꞌlaꞌadyiꞌjëꞌ Jesús, ");
INSERT INTO zpcNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","udapalaꞌnyaquëꞌ Diuzi. Blëꞌë yaca benꞌ yedyi quieyaquëꞌ leyaquëꞌ ben huen. Naꞌra tu dza, tu dza, psere Diuzi nura benꞌ gale quiëꞌ, gaquëꞌ tuz̃e len yaca los demás benꞌ barue quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Naꞌra bdyin dza zio Pedro len Juan luꞌu idaoꞌ rnabëꞌra tacuenda hueꞌlëyaquëꞌ Diuzi diꞌidzaꞌ. Según ca costumbre quie ja benꞌ Israel naꞌ, rioyaquëꞌ zadzëꞌ du reda tzona. Biz̃i naꞌ ruꞌa idaoꞌ naꞌ reꞌ tu benꞌ z̃i, pero cati golotëꞌ naz̃inëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yugu dza ralëchiyaquëꞌ lëbëꞌ ruꞌa idaoꞌ rnabëꞌra laonan ruꞌa badan tacuenda inabëꞌ caridad con nu benꞌ zioja luꞌu idaoꞌ rnabëꞌra naꞌ. Unabayëchiꞌnëꞌ benꞌ bede zio luꞌu idaoꞌ rnabëꞌra tu caridad. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Caora blëꞌë benꞌ z̃i Pedro len Juan, unëyëchiꞌnëꞌ hueꞌyaquëꞌ tu caridad quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Naꞌra blidzayaquëꞌ lëbëꞌ rëbijëꞌ lëbëꞌ: ―¡Unaꞌcara nëtoꞌ! ");
INSERT INTO zpcNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Biz̃i unaꞌ benꞌ z̃i leyaquëꞌ guquëꞌ pensari hueꞌyaquëꞌ tu caridad quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero naꞌra una Pedro rëbinëꞌ benꞌ z̃i: ―Bibi oro, bibi plata, ziaꞌ gunaꞌ luëꞌ, pero tu ta nezdaꞌ gacaliaꞌ luëꞌ, rniaꞌ: ¡Uzuli! ¡Uzaꞌ! porque yelaꞌ huaca quie Jesús, benꞌ yedyi Nazaret, hueyuenëꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Naꞌra bëxu Pedro nëꞌë yebë. Caora cati uchisanëꞌ nëꞌë, labezute niꞌanëꞌ yu, laoxititenëꞌ uzulaonëꞌ rzaꞌnëꞌ. Naꞌra ziolë benꞌ z̃i leyaquëꞌ luꞌu idaoꞌ rnabëꞌra, zionëꞌ rxitinëꞌ ruenëꞌ Diuzi benꞌ z̃e. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Caora blëꞌë ja benëꞌ ca rue benꞌ z̃i, barzaꞌnëꞌ ruenëꞌ Diuzi benꞌ z̃e, ");
INSERT INTO zpcNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","biz̃i tu begaꞌnziyaquëꞌ rebaneyaquëꞌ ca guca quienëꞌ. Bezaqueyaquëꞌ lëbëꞌ ureꞌnëꞌ yugu dza ruꞌa idaoꞌ rnabëꞌra unabayëchiꞌnëꞌ benëꞌ tu caridad quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Naꞌra bdyin Pedro, len Juan, len benꞌ beyuejëꞌ ga zu tu lachila quie idaoꞌ laona lachila quie Salomón. Biz̃i bireꞌen benꞌ beyuejëꞌ usannëꞌ leyaquëꞌ. Pues benꞌ zë beguitejëꞌ gan zë Pedro len Juan, tu bebanzijëꞌ cabëꞌ guca quie benꞌ beyuejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Caora blëꞌë Pedro banitaꞌ ja benꞌ zë, naꞌra unëꞌ rëbinëꞌ lejëꞌ: ―Bichaꞌ, nacale benꞌ Israel ca nëꞌëdiꞌ. Biyebanle inaꞌle nëtoꞌ como si fuera yelaꞌ huaca quiendoꞌ beyuendoꞌ benꞌ ni. Bigacale pensari yelaꞌ rionlaꞌadyiꞌ quiendoꞌ barezaꞌ benꞌ z̃i. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Cala lenaꞌ beyacanëꞌ, dechanꞌ yelaꞌ huaca quie Diuzi quie xuzixtaꞌoro Abraham, len Isaac, len Jacob beziꞌ niꞌanëꞌ fuerza. Pues tuzi Diuzi naꞌ pcaꞌnnëꞌ lao naꞌa z̃iꞌinëꞌ Jesús naquëꞌ benꞌ rnabëꞌ lao yugulute. Pero leꞌe bële yelaꞌ mala quiele psedyinle Jesús lao naꞌa ja benꞌ rnabëꞌ. Caora cati guꞌun Pilato yebionëꞌ Jesús dyiguiba, leꞌe biguꞌunle. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Calëla unabale guꞌunle yebio Pilato tu benꞌ ruti benëꞌ. Biguꞌunle yebio Pilato tu benꞌ naca laꞌiya, benꞌ dyaꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Leꞌe guꞌunle gati benꞌ run yelaꞌ neban quiero, pero Diuzi psebannëꞌ lëbëꞌ. Nacandoꞌ testigo pseban Diuzi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Reꞌendaꞌ iniaꞌ leꞌe de que cuin Jesús beyuenëꞌ benꞌ z̃i, benꞌ beyaca bezaquele. Beyue Jesús lëbëꞌ caora bzëtondoꞌ laonëꞌ ralendoꞌ quienëꞌ. Canaꞌ labeyacatëꞌ zëꞌ laole rlëꞌëtelenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Naꞌra nernë Pedro rëbinëꞌ leyaquëꞌ: ―Bichaꞌ, banezdaꞌ de que caora bëtile Jesús, binezile bi bële, lëzi benꞌ rnabëꞌ quiele, binezirëjëꞌ bi bëjëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero guca quie Jesús de acuerdo con ca una Diuzi dza naꞌte caora bzu benꞌ profeta xtiꞌidzaꞌ Diuzi lëꞌë guichi. Naꞌra rnën de que huadyin dza yedzagalao benꞌ naca Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Por lenaꞌ reyaꞌalaꞌ utzaꞌle pensari quiele, inaole xneza Diuzi tacuenda yeziꞌz̃enëꞌ dulaꞌ xquia quiele, naꞌ cuëchinëꞌ chizi luꞌu guicho laxtaꞌole, ");
INSERT INTO zpcNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","huenëꞌ mandado yeguida Jesús tatula como naca Jesús benꞌ ulio Diuzi desde canaꞌte ta gacalënëꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero huadzënëꞌ guibá hasta que idyin dza hue Diuzi mandado uzunëꞌ xtiꞌidzaꞌnëꞌ con cabëꞌ rnën lëꞌë guichi laꞌiya bë benꞌ profeta, benꞌ unitaꞌ dza naꞌla, benꞌ naca laꞌiya quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Quie lenaꞌ una Moisés dza naꞌte gudyinëꞌ xuzixtaꞌoro cani: “De entre laguedyiziro iseꞌelaꞌ Diuzi itu benꞌ quixogueꞌ xtiꞌidzëꞌ laga con ca useꞌelaꞌnëꞌ nëꞌëdiꞌ. Reꞌennan huele bala yugulu con ca inëꞌ leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Porque nu benꞌ bihue bala con ca inëꞌ, udyiaguiꞌ Diuzi lëjëꞌ. Bihueꞌ Diuzi lato initaꞌlëjëꞌ yaca benꞌ quienëꞌ.” Canaꞌ una Moisés. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Lëscanꞌ yugulu yaca los demás benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi dza naꞌ, desde Samuel lente yaca benꞌ zezaꞌra, unëjëꞌ quie dza rda Jesús lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ca diꞌidzaꞌ begaꞌnlë Diuzi leyaquëꞌ, lëscanꞌ negaꞌnnan para leꞌe caora una Diuzi rëbinëꞌ xuzixtaꞌoro Abraham cani: “Por tu z̃iꞌisuboꞌ huaca huen gula quie yugulu benꞌ nitaꞌ lao yedyi layu.” ");
INSERT INTO zpcNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Naꞌra quie lenaꞌ ulio Diuzi z̃iꞌinëꞌ Jesús, useꞌelaꞌnëꞌ lëbëꞌ laole tanëro tacuenda gaca tahuen gula quiele, usanle bira huele tamala. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Naꞌra neruꞌelë Pedro lënëꞌ Juan yaca benëꞌ diꞌidzaꞌ caora bdyin yaca pxuzi, len yaca xanꞌ policía quie idaoꞌ rnabëꞌra, len tu cueꞌ benꞌ Israel nacajëꞌ quie partido saduceo. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Rdzaꞌyaquëꞌ Pedro len Juan porque rdayaquëꞌ ruꞌelëyaquëꞌ yaca benëꞌ diꞌidzaꞌ rnayaquëꞌ de que cabëꞌ guca quie Jesús bebannëꞌ nacan prueba huadyin dza yebanrë yaca benꞌ huati. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Naꞌra bëyaquëꞌ leyaquëꞌ preso, bdzeꞌyaquëꞌ leyaquëꞌ luꞌu dyiguiba ga begaꞌnyaquëꞌ tu yela porque aodzeꞌ. Lenaꞌ bibëꞌnan lato tzesëyaquëꞌ lao benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Naꞌra benꞌ zë, benꞌ bzënaga quiejëꞌ, guleyaquëꞌ diꞌidzaꞌ quie Diuzi, ptzaꞌyaquëꞌ pensari quieyaquëꞌ. Por lenaꞌ uye benꞌ barale quie Jesús cadu gaꞌyoꞌ mila beꞌmbyu, apartela nigula. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Naꞌ biz̃i beteyu dza tula, bedupa benꞌ rnabëꞌ quie ciudad Jerusalén tacuenda hueyaquëꞌ junta. Bdyinrë yaca benꞌ gula, len benꞌ rnabëꞌ quie idaoꞌ rnabëꞌra, len benꞌ escribas, benꞌ rusëdi diꞌidzaꞌ bzu Moisés lëꞌë guichi. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bdyinrë xanꞌ pxuzi laonëꞌ Anás, len Caifás, len Juan, len Alejandro, lente yugulu diadza quie xanꞌ pxuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Naꞌra bëyaquëꞌ mandado tzexiꞌjëꞌ Pedro len Juan ta tzesëjëꞌ laojëꞌ. Caora bazëyaquëꞌ naꞌ, naꞌra una benꞌ rnabëꞌ rëbinëꞌ leyaquëꞌ: ―¿Bi yelaꞌ rnabëꞌ de quiele rdale niga ruele cabëꞌ reꞌenle? ¿Nuz̃i useꞌelaꞌ leꞌe? ");
INSERT INTO zpcNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Naꞌra du yuꞌu Pedro Bichi Be quie Diuzi, unëꞌ rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","―Leꞌe benꞌ rnabëꞌ quie ciudad Jerusalén, len leꞌe benꞌ gula, chi reꞌenle inezile bi yelaꞌ rnabëꞌ de quiendoꞌ bëndoꞌ tu huen beyuendoꞌ benꞌ neseco niꞌe, ");
INSERT INTO zpcNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","chi reꞌenle inandoꞌ leꞌe len lo demás benꞌ Israel, nainandoꞌ de que por yelaꞌ huaca quie Jesucristo, benꞌ yedyi Nazaret, babeyaca benꞌ niga. Lëcazi benꞌ bdaꞌle lëꞌë yaga cruzo, benꞌ pseban Diuzi, lëbëꞌ beyuenëꞌ benꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Leꞌe bële ca benꞌ rue huecuaꞌ, benꞌ uruꞌun tzalaꞌla yo lagaꞌ. Naꞌ Jesús naquëꞌ ca quie yo lagaꞌ uruꞌunle tzalaꞌla, pero uz̃iꞌ Diuzi yo lagaꞌ uruꞌunle, bzunëꞌn ga rzulao besu. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Pues ni tu benꞌ tula biuseꞌelaꞌ Diuzi ta ute uselanëꞌ raꞌo. Tuzi Jesús naꞌ useꞌelaꞌ Diuzi lao yedyi layu ta ute uselanëꞌ raꞌo yeyoro guibá. ―Canaꞌ una Pedro, rëbinëꞌ benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Naꞌra caora be yaca benꞌ rnabëꞌ ca una Pedro len Juan, blëꞌëyaquëꞌ birdzebijëꞌ, naꞌra tu rebanzijëꞌ porque unezijëꞌ naca Pedro len Juan benꞌ birlëꞌëtica guichi. Pero bezaquejëꞌ naca Pedro len Juan benꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pero como naꞌ zëlëjëꞌ benꞌ beyueyaquëꞌ, bira ubin benꞌ rnabëꞌ bi inayaquëꞌ contra leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Naꞌra bebiojëꞌ Pedro len Juan luꞌu yuꞌu gan nitajëꞌ tacuenda hueꞌyaquëꞌ diꞌidzaꞌ entre lëzijëꞌ bi hueyaquëꞌ quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Naꞌra ruꞌeyaquëꞌ diꞌidzaꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―¿Bi huero? Nacan tali bëyaquëꞌ tu yelaꞌ milagro. Nun quie banezi yugulu benꞌ yedyi cabëꞌ bëyaquëꞌ, bisaqueꞌ yëbiro benꞌ yedyi bibi yelaꞌ milagro nehueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Naꞌra ta iyudyi quie asunto ta bira huen zëdi lao benꞌ yedyi, mejorla uzëgadyiro quiejëꞌ de que bireyaꞌalaꞌ inëyaquëꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Naꞌra beyëz̃i yaca benꞌ rnabëꞌ Pedro len Juan tatula, bzëgadyiyaquëꞌ quiejëꞌ de que bireyaꞌalaꞌ inëyaquëꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Caora naꞌ una Pedro len Juan, rëbiyaquëꞌ leyaquëꞌ: ―Reyaꞌalaꞌ huele pensari chi nacaran huen huendoꞌ cabëꞌ reꞌenle, naꞌ bihuendoꞌ cabëꞌ reꞌen Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nëtoꞌ bisaqueꞌ usanndoꞌ yëbindoꞌ benëꞌ ca ta blëꞌëndoꞌ ca ta bendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Naꞌ bzëgadyi yaca benꞌ rnabëꞌ quieyaquëꞌ tatula. Pero psanyaquëꞌ leyaquëꞌ canaꞌzi, beroyaquëꞌ zeyoyaquëꞌ. Biubinjëꞌ bi huejëꞌ quiejëꞌ, porque danꞌ yugu benꞌ yedyi rueyaquëꞌ Diuzi benꞌ z̃e, danꞌ blëꞌëyaquëꞌ beyaca benꞌ z̃i. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Lëbenꞌ naꞌ, benꞌ beyaca niꞌe por yelaꞌ milagro quie Diuzi, mazla chopa galo iza napanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Naꞌra psan yaca benꞌ rnabëꞌ lejëꞌ, uz̃iꞌyaquëꞌ zioyaquëꞌ bdyinyaquëꞌ ga nitaꞌ los demazara benꞌ quie Jesús, bëꞌleyaquëꞌ leyaquëꞌ diꞌidzaꞌ bicara danꞌ gudyi yaca xanꞌ pxuzi len yaca benꞌ gula. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ude beyudyi beyaquëꞌ ca una Pedro len Juan, caora naꞌ yuguluyaquëꞌ blidzayaquëꞌ Diuzi rëbiyaquëꞌ lëbëꞌ: ―Xuzindoꞌ Diuzi, luëꞌ bëloꞌ guibá, baoꞌ dyila yu, baoꞌ nisadaoꞌ lente yugulu ta de luꞌuna. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Luëꞌ conlë Bichi Be quioꞌ, baoꞌ mandado bzu rey David diꞌidzaꞌ quioꞌ lëꞌë guichi laꞌiya ga rnën caniga: ¿Bixquienꞌ raca dila lao yedyi layu? ¿Bixquienꞌ racajëꞌ pensari bizinaquezi? ");
INSERT INTO zpcNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abedupa ja benꞌ rnabëꞌ quieyaquëꞌ tacuenda huejëꞌ contra Diuzi len z̃iꞌinëꞌ, benꞌ naca Cristo. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Canaꞌ una rey David dza naꞌ: ―Naꞌra bablëꞌëndoꞌ nacan tabala yedyi ni bë rey Herodes, len Poncio Pilato, len benꞌ Israel, len benꞌ yedyi tula tuz̃e contra z̃iꞌiloꞌ Jesús, benꞌ laꞌiya quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pero bëyaquëꞌ cabëꞌ mandado baoꞌ dza naꞌte gaca quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Naꞌra, Xuzindoꞌ Diuzi, unaꞌ como reꞌenyaquëꞌ utzebiyaquëꞌ nëtoꞌ. Gucalë nëtoꞌ como nacandoꞌ benꞌ quioꞌ cuenda bidzebindoꞌ yeyondoꞌ tzetixogueꞌndoꞌ benëꞌ diꞌidzaꞌ quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Uquichoꞌ naꞌaloꞌ yeyueloꞌ yaca benꞌ raca z̃hueꞌ. Uquichoꞌ naꞌaloꞌ ta gaca yelaꞌ huaca quioꞌ lao naꞌa z̃iꞌiloꞌ Jesús, benꞌ laꞌiya quioꞌ. ―Canaꞌ unayaquëꞌ rëbiyaquëꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Caora beyudyi bëꞌlëyaquëꞌ Diuzi diꞌidzaꞌ, naꞌra bzisin ganꞌ beguꞌudiꞌyaquëꞌ. Du yuꞌuyaquëꞌ Bichi Be quie Diuzi, birdzebijëꞌ quixogueꞌjëꞌ benëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Naꞌra yaca benꞌ zë, benꞌ nao xneza Jesús, guca pensari quiejëꞌ yugutejëꞌ tuzi. Entre leyaquëꞌ, yugulu ta de quieyaquëꞌ, gucan para quie yugutejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Naꞌra yaca apóstol bipsanyaquëꞌ quixogueꞌyaquëꞌ benëꞌ cabëꞌ guca quie xaꞌnro Jesús caora gutinëꞌ bebannëꞌ. Pero xtiꞌidzaꞌjëꞌ biꞌan fuerza valor, porque Diuzi gucalënëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Lëscanꞌ entre leyaquëꞌ, ni tu gabi bdziogueyaquëꞌ, como danꞌ yugo benꞌ de quie, chi yuꞌu, chi layu, bëtiꞌyaquëꞌn la hora rdzioguejëꞌ dumi, ");
INSERT INTO zpcNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","naꞌ uz̃iꞌjëꞌn bëꞌjëꞌn apóstol. Naꞌra bë apóstol mandado ta udisiyaquëꞌ dumi quie tu tuyaquëꞌ con nu benꞌ bide quie. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Naꞌ ladoyaquëꞌ uzu tu benꞌ naca familia quie xuzixtaꞌoro Leví laonëꞌ José. Lao isla Chipre gologuëꞌ. Uxuba ja apóstol laonëꞌ Bernabé, ta inaro xtiꞌidzaꞌro: Benꞌ huen, benꞌ z̃elaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Lëbenꞌ naꞌ bëtiꞌnëꞌ layu quienëꞌ bëꞌnëꞌ apóstol dumi quien. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero uzu tu benꞌ laonëꞌ Ananías lënëꞌ z̃gulanëꞌ Safira. Pues naꞌ bëtiꞌyaquëꞌ tu layu quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pero binahue dumi quien bëꞌnëꞌ apóstol, nechanꞌ baoz̃iꞌnëꞌ lëꞌëtiꞌ quienëꞌ tu partenëꞌ bëꞌnëꞌn apóstol como si fuera nahue dumi quien. ―Pues dyëꞌëdi banezi z̃gulëꞌ cabëꞌ bënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Naꞌra una Pedro rëbinëꞌ Ananías: ―Ananías, ¿biquienꞌ uyuꞌuloꞌ pensari xiꞌibiꞌ, uz̃ioꞌ Bichi Be quie Diuzi yëꞌ, binaoꞌ uz̃iꞌloꞌ lëꞌëtiꞌ dumi tu parte quioꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nunu bë mandado gutiꞌoꞌn, cuinzoꞌ bëtiꞌoꞌn. Nunu una luëꞌ yeyunloꞌ dumi quien, cuinzoꞌ beyunloꞌn. ¿Biquienꞌ uyuꞌuloꞌ pensari median, baoꞌ canaꞌ? Diuzi uz̃iꞌloꞌ yëꞌ, quele benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Naꞌra ude beyudyi be Ananías xtiꞌidzaꞌ Pedro, tu bguꞌunzëꞌ layu gutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Caora naꞌ bdyin chopa tzona biꞌbyu ptubiyacabiꞌ lëbëꞌ con laꞌariꞌ laoz̃iꞌtejabiꞌ lëbëꞌ nuꞌajabiꞌ yecachiꞌyacabiꞌ lëbëꞌ. Por lenaꞌ yugo ja benëꞌ unezi cabëꞌ uz̃aca Ananías, legazi bdzebijëꞌ canꞌ guca. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Naꞌra aodela cadu tzona hora, caora bdyin z̃gula Ananías ga zë Pedro. Pero binenezinëꞌ bi baguca quie xquiuhuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Caora naꞌ unaba Pedro rëbinëꞌ lëbëꞌ: ―¡Una chi nahue dumi ca tu ta bëtiꞌle layu quiele! Pues bequëbi nigula rëbinëꞌ Pedro: ―Ajaꞌ, nahuena. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Naꞌra una Pedro rëbinëꞌ nigula: ―¿Bixquienꞌ begaꞌnlëloꞌ xquiuloꞌ de acuerdo bële prueba Bichi Be quie Diuzi? Naꞌ bazaꞌ ja benꞌ yecachiꞌ xquiuloꞌ, lëzi huetzecachiꞌrëjabiꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Caora naꞌ tu bguꞌunzëꞌ lao Pedro gutinëꞌ. Cati uyuꞌu ja biꞌbyu ga denëꞌ, blëꞌëyacabiꞌ bagutirënëꞌ. Lëzi uliojabiꞌ lëbëꞌ uz̃iꞌyacabiꞌ yecachiꞌyacabiꞌ lëbëꞌ cuëta lëꞌë ga pcachiꞌyacabiꞌ xquiunëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Quie lenaꞌ ptzebitzegue benꞌ quie Jesús len los demás benꞌ unezi cabëꞌ guca quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Naꞌra zë lasa bë yaca apóstol yelaꞌ milagro lao benꞌ yedyi. Caora naꞌ bedupa yaca benꞌ quie Jesús ga laonan Lachila quie Salomón. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Blëꞌë ja benꞌ yedyi leyaquëꞌ benꞌ huen, pero bdzebiyaquëꞌ yedupalëyaquëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pero unaocazi benꞌ zë xneza Jesús, beꞌmbyu len ja nigula. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hasta que ulioyaquëꞌ benꞌ raca z̃hueꞌ udixojëꞌ leyaquëꞌ du tu neza lao belaga o chi lao daꞌa. Rbezayaquëꞌ te pxin quie Pedro ga deyaquëꞌ ta yeyacayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Lëzi bdyin zë benëꞌ quie yedyi reꞌ gaꞌalaꞌ, nuꞌarëyaquëꞌ benꞌ raca z̃hueꞌ len benꞌ yuꞌu taxiꞌibiꞌ. Naꞌ yugulutejëꞌ beyacayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Naꞌra yelaꞌ z̃ëꞌ quie xanꞌ pxuzi len benꞌ partido saduceo, ");
INSERT INTO zpcNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","bëxoyaquëꞌ apóstol bdzeꞌyaquëꞌ leyaquëꞌ luꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ca du bala bdyin tu ángel quie Diuzi ga de ja apóstol luꞌu dyiguiba, psalonëꞌ ruꞌa yuꞌu dyiguiba, ulionëꞌ yaca apóstol unëꞌ rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Tziole luꞌu idaoꞌ rnabëꞌra quixogueꞌle benëꞌ xtiꞌidzaꞌ Diuzi yëbilejëꞌ quie yelaꞌ neban tuzioli ruꞌe Diuzi benꞌ nao xnezëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ude beyudyi beyaquëꞌ ca una ángel, caora uyeniꞌ naꞌ, uzaꞌyaquëꞌ zioyaquëꞌ luꞌu idaoꞌ rnabëꞌra bezulaoyaquëꞌ rguixogueꞌyaquëꞌ benëꞌ xtiꞌidzaꞌ Diuzi. Hora naꞌ balara uyasa xanꞌ pxuzi lënëꞌ yaca benꞌ quiëꞌ, uzaꞌyaquëꞌ zioyaquëꞌ ga hueyaquëꞌ junta bënëꞌ mandado guida yugulu benꞌ rnabëꞌ quie benꞌ Israel. Caora abguꞌudiꞌyaquëꞌ yuguluyaquëꞌ, hora naꞌ bë xanꞌ pxuzi mandado tzio policía tzexiꞌjëꞌ apóstol luꞌu yuꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Naꞌra uyo policía tzexiꞌyaquëꞌ apóstol, pero ganu ja apóstol bedzeleyaquëꞌ luꞌu dyiguiba. Por lenaꞌ bezaꞌyaquëꞌ zeyoyaquëꞌ ganꞌ rueyaquëꞌ junta, ");
INSERT INTO zpcNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","unayaquëꞌ rëbiyaquëꞌ yaca benꞌ rnabëꞌ: ―Bëꞌ bdyindoꞌ neyeyo dyiguiba con candado, blëꞌëndoꞌ zu policía rapajëꞌ ruꞌa dyiguiba. Pero caora usalondoꞌ ruꞌa yuꞌu dyiguiba, nunu dyilaꞌ luꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Naꞌra yaca xanꞌ pxuzi len xanꞌ policía quie idaoꞌ, caora beyaquëꞌ ca una policía, rdzebitzegueyaquëꞌ ga yeyudyi yedu asunto naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Biz̃i cati blaꞌ tu benꞌ blaꞌ, udixogueꞌnëꞌ leyaquëꞌ unëꞌ: ―Luꞌu idaoꞌ rnabëꞌra bazë ja benꞌ bdzeꞌle luꞌu dyiguiba, baruꞌelëyaquëꞌ yaca benꞌ yedyi diꞌidzaꞌ tatula. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Naꞌra laziote xanꞌ policía len benꞌ quiëꞌ yexiꞌyaquëꞌ leyaquëꞌ. Pero bibëꞌyaquëꞌ quieyaquëꞌ, porque rdzebiyaquëꞌ udaꞌ yaca benꞌ yedyi leyaquëꞌ yo. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Naꞌra zequiëꞌyaquëꞌ apóstol ga rueyaquëꞌ junta yesanyaquëꞌ leyaquëꞌ lao benꞌ rnabëꞌ tatula. Naꞌra una xanꞌ pxuzi rëbinëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Barzëgadyindoꞌ quiele bira inale quie Jesús. ¿Naꞌ biz̃i bële? Nerguixogueꞌle yugulu benꞌ ciudad Jerusalén rëbileyaquëꞌ ca naca pensari quiele, reꞌenle gale benꞌ yedyi de que dulaꞌ quiendoꞌ guti Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Naꞌra una Pedro lënëꞌ yaca los demás apóstol: ―Decazide huendoꞌ cabëꞌ reꞌen Diuzi, bihuendoꞌ cabëꞌ reꞌenle leꞌe. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Leꞌe bëtile Jesús bdaꞌle lëbëꞌ lëꞌë yaga cruzo, pero Diuzi naꞌ psebannëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Bë Diuzi nombrar lëbëꞌ gaquëꞌ benꞌ reꞌ zaquëꞌ yebë cuëtanëꞌ ga naca xlato benꞌ balaꞌana. Ulionëꞌ lëbëꞌ gaquëꞌ xaꞌnro, benꞌ ute usela raꞌo tacuenda utzaꞌro pensari median quiero yeziꞌz̃e Diuzi dulaꞌ xquia quiero. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nacandoꞌ testigo tali naꞌ. Lëscanꞌ Bichi Be quie Diuzi, benꞌ yuꞌu guicho laxtaꞌo benꞌ nao xneza Diuzi, naquëꞌ testigo tali naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Caora beyudyi beyaquëꞌ diꞌidzaꞌ una Pedro, naꞌra lega bdzaꞌtzegue benꞌ rnabëꞌ, guꞌunyaquëꞌ gutiyaquëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero entre leyaquëꞌ uzu tu benꞌ quie partido fariseo laonëꞌ Gamaliel. Naquëꞌ benꞌ huen, benꞌ psëdi ley quie Moisés. Naꞌra bënëꞌ mandado yero ja apóstol lao junta ga reꞌ benꞌ rnabëꞌ cuezayaquëꞌ tu chiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Caora bero yaca apóstol, naꞌra una Gamaliel rëbinëꞌ laguedyinëꞌ: ―Benꞌ Israel, gapale cuidado bi reꞌenle huele quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bigalaꞌadyiꞌle cabëꞌ guca quie tu benꞌ lao Teudas. Azio iza uzunëꞌ unëꞌ naquëꞌ benꞌ belao. Unao ca du tapa gayuhua benëꞌ lëbëꞌ. Pero bdyin dza bëti soldado lëbëꞌ, bdzatza bez̃uno yaca benꞌ unao lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Beyudyi bedu quie Teudas, uzu itu benꞌ Galilea lao Judas dza bë gobierno censo blabanëꞌ benëꞌ. Guꞌunrënëꞌ tilalënëꞌ soldado quie gobierno. Unaorë ja benꞌ zë lëbëꞌ, pero bëtirë soldado lëbëꞌ. Lëzi bdzatzarë bz̃unorë benꞌ unao lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Lenaꞌ rniaꞌ leꞌe, mejorla usanro quieyaquëꞌ, bira huerojëꞌ zëdi. Porque chi ta racazi laꞌadyiꞌjëꞌ ruejëꞌ, huabezan. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero chi tu ta rueyaquëꞌ nacan quie Diuzi, baꞌalaꞌcazi reꞌenle cuezan, bicuezan. Naꞌra gapale cuidado ta bihuele contra Diuzi. ―Canaꞌ una Gamaliel gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pues naꞌra aoz̃iꞌyaquëꞌ xtiꞌidzaꞌ Gamaliel. Caora naꞌ beyëz̃iyaquëꞌ apóstol tatula. Caora bazëyaquëꞌ naꞌ, bë benꞌ rnabëꞌ mandado udi policía leyaquëꞌ con guidi. Lëscanꞌ bzëgadyiyaquëꞌ quiejëꞌ tatula ta bira inëyaquëꞌ quie Jesús. Ude beyudyi naꞌ, bëꞌ benꞌ rnabëꞌ permiso yero ja apóstol naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Caora naꞌ beroyaquëꞌ ga reꞌ benꞌ rnabëꞌ lao junta zeyoyaquëꞌ redaohueyaquëꞌ danꞌ bedzagalaoyaquëꞌ por nun quie Jesús. Yugu dza uzaꞌyaquëꞌ ziojëꞌ luꞌu idaoꞌ rnabëꞌra o chi luꞌu yuꞌu quie tu tu benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bipsanyaquëꞌ inëyaquëꞌ quie Jesucristo. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Naꞌra dza naꞌte, tu dza huio, uyera mazera benꞌ quie Jesús. Pero bala benꞌ quie Jesús, benꞌ rnë diꞌidzaꞌ griego, uyuꞌuyaquëꞌ huenë conlë benꞌ quie Jesús, benꞌ rnëja diꞌidzaꞌ hebreo. Naꞌra una benꞌ rnë diꞌidzaꞌ griego rëbiyaquëꞌ yaca apóstol: ―Benꞌ rnë diꞌidzaꞌ hebreo, biruꞌeyaquëꞌ laze parejo. Caora udisiyaquëꞌ ta gao nigula bizu xquiuhue, ledaoꞌzi ruꞌeyaquëꞌ nigula bizu xquiuhue quiendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Naꞌra bedupa lao chipchopa apóstol len yaca los demás benꞌ quie Jesús, unayaquëꞌ rëbiyaquëꞌ leyaquëꞌ: ―Bireyaꞌalaꞌ usanndoꞌ rguixogueꞌndoꞌ benëꞌ xtiꞌidzaꞌ Diuzi ta hueꞌndoꞌ laze yelaꞌ huao naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mejorla cuiole gadyi benꞌ huen, benꞌ de pensari, benꞌ rale quie Bichi Be quie Diuzi du guicho du laꞌadyiꞌyaquëꞌ, naꞌ huele mandado quisiyaquëꞌ yelaꞌ huao parejo. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Naꞌra nëtoꞌ, biusanndoꞌ rulidzandoꞌ Diuzi rguixogueꞌndoꞌ benëꞌ xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Naꞌra yaxe yugulu benꞌ quie Jesús cabëꞌ una yaca apóstol. Caora naꞌ ulioyaquëꞌ Esteban, benꞌ rale quie Bichi Be quie Diuzi du guicho du laꞌadyiꞌnëꞌ. Lëzi ulioyaquëꞌ Felipe, len Prócoro, len Nicanor, len Timón, len Parmenas, len Nicolás benꞌ yedyi tula. Naca Nicolás benꞌ yedyi Antioquía, benꞌ unao religión quie benꞌ Israel dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Naꞌra bzuyaquëꞌ leyaquëꞌ lao yaca apóstol, pquichi yaca apóstol naꞌayaquëꞌ guichojëꞌ, bëꞌlëyaquëꞌ Diuzi diꞌidzaꞌ por leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Naꞌra yugu dza udixogueꞌ ja apóstol mazera benëꞌ xtiꞌidzaꞌ Diuzi. Por lenaꞌ taz̃e uye benꞌ rnao xneza Jesús ciudad Jerusalén. Lente zë yaca pxuzi, unaorëyaquëꞌ xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Naꞌra taz̃e gucalë Diuzi Esteban bënëꞌ yelaꞌ huaca quie Diuzi lao ja benꞌ yedyi nitaꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero bala ja benꞌ uzaꞌ yedyi Cirene, len benꞌ uzaꞌ yedyi Alejandría, len benꞌ uzaꞌ yedyi Cilicia, len benꞌ uzaꞌ yaca yedyi nebaba Asia, len benꞌ rio luꞌu idaoꞌ sinagoga quie benꞌ bira naca benꞌ nadaꞌo, uyuꞌuyaquëꞌ huenë conlë Esteban. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero biubinyaquëꞌ bi nayaquëꞌ porque gucalë Bichi Be quie Diuzi lëbëꞌ bdzeꞌnëꞌ luꞌu guichonëꞌ bi diꞌidzaꞌ unëlënëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Quie lenaꞌ udiz̃oyaquëꞌ benëꞌ ta inayaquëꞌ diꞌidzaꞌ contra Esteban. Caniꞌ una benꞌ uz̃iꞌ dumi rëbiyaquëꞌ laguedyiyaquëꞌ: ―Nëtoꞌ bendoꞌ unë Esteban diꞌidzaꞌ xiꞌibiꞌ contra Moisés len Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Canaꞌ bëjëꞌ gan bdzaꞌ ja benꞌ yedyi, len ja benꞌ gula, len ja benꞌ rusëdi ley quie Moisés lëbëꞌ. Naꞌra uquiëꞌyaquëꞌ lëbëꞌ, psedyinyaquëꞌ lëbëꞌ ga reꞌ benꞌ rnabëꞌ lao junta. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Udiloyaquëꞌ benꞌ unë diꞌidzaꞌ falso contra lëbëꞌ. Naꞌ lëyaca benꞌ naꞌ, unayaquëꞌ rëbiyaquëꞌ benꞌ rnabëꞌ: ―Birsan benꞌ niga rnëꞌ diꞌidzaꞌ contra idaoꞌ rnabëꞌra quiero. Lëzi ruenëꞌ contra ley pcaꞌn xuzixtaꞌoro Moisés. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nëtoꞌ bendoꞌ unëꞌ udyiaguiꞌ Jesús idaoꞌ rnabëꞌra quiero. Lëscanꞌ unëꞌ utzaꞌ Jesús costumbre quiero ta pcaꞌn xuzixtaꞌoro Moisés. ");
INSERT INTO zpcNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ude beyudyi unajëꞌ canaꞌ, naꞌra unaꞌ benꞌ rue junta lao Esteban, pero blëꞌëyaquëꞌ beyaca laonëꞌ ca quie lao ángel. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Naꞌra unaba xanꞌ pxuzi rëbinëꞌ Esteban: ―¿Nacan tali cabëꞌ unayaquëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Naꞌra bequëbi Esteban rëbinëꞌ leyaquëꞌ: ―Bichaꞌ, xuzaꞌ, ulezëcara nagale cabëꞌ iniaꞌ leꞌe. Azio zë iza, bluꞌe Diuzi xuzixtaꞌoro Abraham yelaꞌ huaca quienëꞌ caora cati binetzesu Abraham yedyi Harán, nezunëꞌ yu nebaba Mesopotamia. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Lëdza naꞌ una Diuzi rëbinëꞌ Abraham: “Psan diadza quioꞌ, psan yedyi quioꞌ, beyo yedyi tula ga uluꞌenaꞌ luëꞌ.” Canaꞌ una Diuzi gudyinëꞌ Abraham. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Por lenaꞌ uzaꞌ Abraham yu nebaba benꞌ Caldea, zionëꞌ yesunëꞌ yedyi Harán. Biz̃i cati aguti xuzi Abraham, bë Diuzi mandado bezaꞌ Abraham yedyi Harán, belaꞌnëꞌ yedyi niga ga nitaꞌro naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero bibëꞌ Diuzi lëbëꞌ ga gaque quienëꞌ sunëꞌ, ni siquiera tu pedazozi. Pero begaꞌnlë Diuzi lëbëꞌ diꞌidzaꞌ de que idyin dza gaque quienëꞌ ga sunëꞌ, naꞌ bëꞌ bagutinëꞌ gaque quie z̃iꞌinëꞌ. Naꞌra laꞌacazi ga nu z̃iꞌinëꞌ nenitaꞌ caora, begaꞌnlë Diuzi lëbëꞌ diꞌidzaꞌ canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Lëzi una Diuzi de que initaꞌ z̃iꞌisuba Abraham yedyi quie benꞌ tula ga hueyaquëꞌ dyin sin laz̃u, naꞌ hue yaca benëꞌ ziꞌ quieyaquëꞌ lao tapa gayuhua iza. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lëscanꞌ una Diuzi rëbinëꞌ Abraham dza naꞌ: “Huachugobiꞌa quie benꞌ bëꞌ ziꞌ quieyaquëꞌ. Te iyudyi naꞌ yezaꞌ z̃iꞌisubaꞌ yedyi naꞌ yelaꞌjëꞌ niga ga tzionlaꞌadyiꞌyaquëꞌ nëꞌëdiꞌ.” Canaꞌ una Diuzi. Naꞌra nernë Esteban rëbinëꞌ yaca benꞌ rnabëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","―Lëzi bë Diuzi mandado uzu Abraham tu xëdyidaoꞌ z̃iꞌinëꞌ byu ta gaca seña uluꞌen ca diꞌidzaꞌ begaꞌnlë Diuzi lëbëꞌ. Por lenaꞌ, caora aoca tu xunꞌ golo z̃iꞌinëꞌ Isaac, naꞌra bzunëꞌ tu xëdyidaoꞌ lëbiꞌ. Con ca bë Abraham lënëꞌ z̃iꞌinëꞌ Isaac, canaꞌ bërë Isaac lënëꞌ z̃iꞌinëꞌ Jacob. Lëzi con ca bë Isaac lënëꞌ z̃iꞌinëꞌ Jacob, canaꞌ bërë Jacob lënëꞌ chipchopa z̃iꞌinëꞌ byu. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Yelaꞌ z̃ëꞌ quie yaca z̃iꞌi Jacob, bëtiꞌyaquëꞌ tu bichiyaquëꞌ laonëꞌ José, uz̃iꞌ benꞌ zio Egipto lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Pero gucalë Diuzi lëbëꞌ pcuasa pcuiꞌonëꞌ tamala zaꞌ gaca quienëꞌ. Canaꞌ guca José benꞌ yuꞌu pensari, yexe rey Faraón lëbëꞌ. Tantozi yexe Faraón José, ulionëꞌ lëbëꞌ ta tzionëꞌ gaquëꞌ xanꞌ benꞌ rnabëꞌ lao nación Egipto. Lëscanꞌ ulionëꞌ lëbëꞌ gaquëꞌ xanꞌ benꞌ rue dyin luꞌu lidyinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Naꞌra dza naꞌte guca tu obin huala gula nación Egipto len nación Canaán. Fuerte bedzagalao xuzixtaꞌoro, bibdzeleyaquëꞌ bi gaoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Caora unezi Jacob de que rdzela trigo nación Egipto, naꞌra useꞌelaꞌnëꞌ z̃iꞌinëꞌ ganꞌ, pero bibezaqueyaquëꞌ chi biꞌ bichiyaquëꞌ José. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Naꞌra taorupe zioyaquëꞌ bdyinyaquëꞌ nación Egipto, caora naꞌ una José rëbinëꞌ leyaquëꞌ: “Nëꞌëdiꞌ nacaꞌ bichile, José.” Canaꞌra bezaqueyaquëꞌ lëbëꞌ. Canaꞌ bdyin hora unezi rey Faraón de que naca José ren quie benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Naꞌra guz̃i José xuzinëꞌ Jacob lente yugulu familia quienëꞌ, uzaꞌyaquëꞌ zioyaquëꞌ bdyinyaquëꞌ nación Egipto. Naꞌra entre yaca benꞌ bdyin nacajëꞌ tzona galo chiꞌinuꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Canaꞌ guca unitaꞌ Jacob nación Egipto. Naꞌra caora bdyin dza quienëꞌ, gutinëꞌ. Lëzi caora bdyinrë dza quie z̃iꞌinëꞌ, gutirëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Caora azio iza, bebio z̃iꞌi subayaquëꞌ chita quieyaquëꞌ yecachiꞌyaquëꞌn yedyi Siquem. Naꞌ bdzeꞌyaquëꞌ chita quieyaquëꞌ luꞌu beló ta hueꞌ Abraham desde canaꞌte. Con dumi plata quienëꞌ hueꞌnëꞌn lao ja z̃iꞌi Hamor, benꞌ yedyi Siquem. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Caora cati ilëꞌëtiꞌzi idyin hora uzu Diuzi diꞌidzaꞌ cabëꞌ diꞌidzaꞌ begaꞌnlënëꞌ Abraham dza naꞌte, caora naꞌ baoye benꞌ Israel gucajëꞌ benꞌ zë. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pero uzulao rnabëꞌ tu rey cubi quie benꞌ Egipto. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pues rey naꞌ, binubëꞌnëꞌ José. Udilalënëꞌ xuzixtaꞌoro, bëꞌnëꞌ leyaquëꞌ ziꞌ, uz̃iꞌnëꞌ leyaquëꞌ yëꞌ, bënëꞌ mandado ucaꞌn xuzixtaꞌoro bdaoꞌ zagolo quieyaquëꞌ luꞌu guixiꞌ ta gatiyacabiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Naꞌra bdyin hora golo Moisés, pero badanla zubiꞌ. Pero como rnabëꞌ rey gati bdaoꞌ quie ja benꞌ Israel, quie lenaꞌ pcachiꞌ z̃naꞌbiꞌ lëbiꞌ luꞌu yuꞌu. Pero cati aode tzona biuꞌ, bira uz̃aqueꞌnëꞌ ucachiꞌnëꞌbiꞌ luꞌu yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Quie lenaꞌ psanyaquëꞌ lëbiꞌ luꞌu guixiꞌ, pero beziꞌ z̃iꞌi rey nigula lëbiꞌ, uz̃iꞌnëꞌbiꞌ psegulanëꞌbiꞌ ca quie xcuidiꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Canaꞌ guca psëdi Moisés yugulu ta nezi benꞌ nación Egipto. Guquëꞌ benꞌ yuꞌu pensari, udapalaꞌn benëꞌ lëbëꞌ, porque dyin dyaꞌa bënëꞌ, diꞌidzaꞌ li unënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Chopa galo iza zunëꞌ caora cati guꞌunnëꞌ gacalënëꞌ laguedyinëꞌ benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Canaꞌ zionëꞌ yeyubinëꞌ leyaquëꞌ ga rueyaquëꞌ dyin. Pero blëꞌënëꞌ tu benꞌ Egipto rdilalënëꞌ tu benꞌ Israel. Biz̃i naꞌ gucalë Moisés laguedyinëꞌ, bëtinëꞌ benꞌ Egipto. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pero guque Moisés de que nezi benꞌ Israel reꞌen Diuzi gacalë Moisés leyaquëꞌ yezaꞌyaquëꞌ nación Egipto. Pero biuneziyaquëꞌ canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Biz̃i bete yu naꞌ, zezio Moisés tatula ga zu laguedyinëꞌ bedilanëꞌ chopa benꞌ Israel rdilayaquëꞌ. Naꞌra como reꞌen Moisés bitilayaquëꞌ, unëꞌ rëbinëꞌ leyaquëꞌ: “¡Bichaꞌ! ¿Bixquienꞌ reꞌenle hueꞌle laguedyile ziꞌ?” ");
INSERT INTO zpcNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pero biz̃i benꞌ rdilayaca bdyiganëꞌ Moisés tzalaꞌla, unëꞌ rëbinëꞌ lëbëꞌ: “¿Nu ulio luëꞌ rnabëꞌloꞌ nëtoꞌ ca juez quiendoꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Quele reꞌenloꞌ gutioꞌ nëꞌëdiꞌ ca bëtioꞌ benꞌ Egipto niogue?” ");
INSERT INTO zpcNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cati be Moisés ca unëꞌ, naꞌra zeyonëꞌ huez̃uno yesunëꞌ yu nebaba Madián. Canaꞌ uzunëꞌ yedyi tula, yedyi binacan quienëꞌ, ptzaganaꞌnëꞌ uzu chopa z̃iꞌinëꞌ byu. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Caora baguca ichopa galo iza tu luꞌu guixiꞌ, naꞌ zu tu lato dachi ruen gaꞌalaꞌ ga zu tu yaꞌa laona Sinaí ga bdyin tu ángel ptilalaonëꞌ Moisés. Naꞌ uzë ángel naꞌ luꞌu tu yaga yëchiꞌ raꞌalaꞌn yuꞌun guiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Caora blëꞌë Moisés ángel naꞌ, tu begaꞌnzinëꞌ rebannëꞌ. Cati ubigaꞌnëꞌ gaꞌalaꞌ tacuenda ilëꞌënëꞌ dyëꞌëdi, caora naꞌ una Diuzi rëbinëꞌ lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nëꞌëdiꞌ nacaꞌ Diuzi quie xuzixtaꞌoloꞌ Abraham, len xuzixtaꞌoloꞌ Isaac, len xuzixtaꞌoloꞌ Jacob.” Caora be Moisés ca una Diuzi, rz̃izinëꞌ rdzebinëꞌ inaꞌnëꞌ mazera. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Naꞌra unëra Diuzi rëbinëꞌ Moisés: “Ulëcho huarache quioꞌ porque naca laꞌiya ga zëloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Pues abedaꞌ rulidza ja benꞌ quiaꞌ nitaꞌ Egipto nëꞌëdiꞌ. Ablëꞌëdaꞌ ca redzagalaojëꞌ. Baoyëzaꞌ ta ute uselaꞌ leyaquëꞌ. Udacara, iseꞌelaꞌ luëꞌ nación Egipto.” Canaꞌ una Diuzi rëbinëꞌ Moisés. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Naꞌra nernë Esteban rëbinëꞌ leyaquëꞌ: ―Baꞌalaꞌcazi biuyezilaꞌadyiꞌ yaca benꞌ Israel Moisés, baꞌalaꞌcazi unayaquëꞌ rëbiyaquëꞌ Moisés: “¿Nu ulio luëꞌ ta inabëꞌloꞌ nëtoꞌ ca juez quiendoꞌ?”, naꞌ useꞌelaꞌ Diuzi Moisés ta inabëꞌnëꞌ ute uselanëꞌ leyaquëꞌ. Conlë ángel, benꞌ ptilalao lëbëꞌ luꞌu yaga yëchiꞌ, useꞌelaꞌ Diuzi Moisés. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Naꞌra lëMoisés ulionëꞌ xuzixtaꞌoro hora bezaꞌyaquëꞌ beroyaquëꞌ nación Egipto, bënëꞌ yelaꞌ huaca quie Diuzi ga reꞌ tu nisadaoꞌ laona Nisadaoꞌ Z̃na. Lëscanꞌ bënëꞌ yelaꞌ huaca quie Diuzi hora uda yaca benꞌ Israel gabi yuꞌu dyia chopa galo iza. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Lëzi lëMoisés unëꞌ rëbinëꞌ benꞌ Israel: “De entre leꞌe huabio Diuzi itu benꞌ ina leꞌe xtiꞌidzaꞌ Diuzi laga con ca ulionëꞌ nëꞌëdiꞌ. Ulehue bala ca inëꞌ leꞌe.” ");
INSERT INTO zpcNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lëscanꞌ lëMoisés naꞌ ziolënëꞌ benꞌ Israel cati uzaꞌyaquëꞌ udayaquëꞌ tu paraje gabi yuꞌu dyia lao chopa galo iza. Conlë Moisés naꞌ bëꞌlë ángel diꞌidzaꞌ lëꞌë yaꞌa Sinaí. Lëbëꞌ udixogueꞌnëꞌ xuzixtaꞌoro diꞌidzaꞌ bëꞌlë ángel lëbëꞌ. Lëdiꞌidzaꞌ naꞌ, diꞌidzaꞌ neban, pcaꞌn Moisés para raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero bigule xuzixtaꞌoro diꞌidzaꞌ pcaꞌn Moisés. Guꞌunyaquëꞌ uzaꞌlaꞌadyiꞌjëꞌn yezaꞌjëꞌ yeyoyaquëꞌ nación Egipto tatula. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Cati nezio Moisés lëꞌë yaꞌa, caora naꞌ unayaquëꞌ rëbiyaquëꞌ Aarón, benꞌ xanꞌ pxuzi: “Reꞌenndoꞌ hueloꞌ chopa tzona diuzi ta huaꞌaro tu neza ta ucuasa ucuiꞌon raꞌo bi tamala zaꞌ gaca quiero, porque binezindoꞌ bi guca quie Moisés, benꞌ ulio raꞌo nación Egipto.” ");
INSERT INTO zpcNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Naꞌra bzaloyaquëꞌ tu bëdyihuaga daoꞌ de oro. Bëtirëyaquëꞌ tu becoꞌ z̃iꞌilaꞌ bdyiayaquëꞌbaꞌ lao bëdyihuaga de oro ca gun quiebaꞌ. Lega yexeyaquëꞌ diuzi bëyaquëꞌ naꞌaziyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Canaꞌ psanlaꞌadyiꞌ Diuzi leyaquëꞌ ta tzionlaꞌadyiꞌyaquëꞌ yaca tadyia guibá. Quie lenaꞌ guca quieyaquëꞌ con ca rna lëꞌë guichi bë yaca profeta ga rguixogueꞌn ca una Diuzi: Leꞌe benꞌ Israel, ¿para nëꞌëdiꞌ bëtile bia bdyialebaꞌ ruꞌaba dza rdale lao lato dachi chopa galo iza? ");
INSERT INTO zpcNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Quele para nëꞌëdiꞌ, pero bële con naꞌazile diuzi uyonlaꞌadyiꞌle. Nuꞌale tu rumita daoꞌ de laꞌariꞌ quie Moloc. Nuꞌarële tu ta naca forma quie bélo, laona Renfán. Lenaꞌ unale naca Diuzi quiele. Quie lenaꞌ huaꞌ castigo quiele, huabiogaꞌ hualaohuaꞌ leꞌe yedyi quiele tziole zituꞌ, tzesule yedyi quie benꞌ tula yedyi laona Babilonia. Canaꞌ una Diuzi gudyinëꞌ xuzixtaꞌoro dza naꞌte. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Naꞌra nernë Esteban rëbinëꞌ leyaquëꞌ: ―Dza rda xuzixtaꞌoro lao lato gabi yuꞌu dyia, nuꞌayaquëꞌ tu yuꞌu de laꞌariꞌ, lenaꞌ gucan idaoꞌ quieyaquëꞌ. Luꞌen naꞌ bzuyaquëꞌ yaca yo taꞌa ga bzu Diuzi ley quienëꞌ. Lëyuꞌu de laꞌariꞌ naꞌ, bëyaquëꞌn con ca una Diuzi hueyaquëꞌn, porque Diuzi bluꞌenëꞌ Moisés ca reꞌennëꞌ hue benꞌ Israel yuꞌu de laꞌariꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Naꞌra bdyin dza aguti Moisés. Caora naꞌ ulio Diuzi tu benꞌ lao Josué gaquëꞌ benꞌ rnabëꞌ quie xuzixtaꞌoro lao laza Moisés. Biz̃i lao naꞌa Josué bdyin xuzixtaꞌoro layu ga begaꞌnlë Diuzi leyaquëꞌ diꞌidzaꞌ gaca layu quieyaquëꞌ. Caora naꞌ gucalë Diuzi leyaquëꞌ blaonëꞌ benꞌ nitaꞌ layu naꞌ zioyaquëꞌ huez̃uno. Lao naꞌa Diuzi bëyaquëꞌ gan, bzuyaquëꞌ yuꞌu de laꞌariꞌ layu quieyaquëꞌ bëꞌ bdyinjëꞌ naꞌ. Canaꞌzi begaꞌnnan hasta bdyin dza rda rey David. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Pero rey David, lega nedyëꞌë Diuzi lëbëꞌ. Caora naꞌ guꞌun rey David huenëꞌ tu idaoꞌ z̃egula ga initaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero quele rey David bënëꞌn nechanꞌ z̃iꞌinëꞌ Salomónla bënëꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero sibila zu Diuzi, binitaꞌnëꞌ luꞌu idaoꞌ ta bë benëꞌzi. Lenaꞌ nacan de acuerdo con ca una Diuzi caora unëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Naca ladza ca quie xlatogaꞌ ga riꞌa. Naca yedyi layu ca quie lato ga rezilaꞌadyiꞌ niꞌa. ¿Ca bi cueꞌ yuꞌu huele para nëꞌëdiꞌ? ¿Gaz̃i naca lato ga yezilaꞌadyaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Biz̃i binezile conlë naꞌa biaꞌ yugulu ta de? Canaꞌ una Diuzi gudyinëꞌ xuzixtaꞌoro dza naꞌte. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Naꞌra nernë Esteban rëbinëꞌ leyaquëꞌ: ―Yelaꞌ zidi quiele birioñeꞌele ruele ca benꞌ binubëꞌ Diuzi. Siempre biralele quie Bichi Be quienëꞌ. Ruele tamala laga con ca bë xuzixtaꞌoro. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Nu benꞌ profeta biudilalë xuzixtaꞌoro? Leyaquëꞌ bëtiyaquëꞌ benꞌ udixogueꞌ de que guida Cristo. Biz̃i cati bidëꞌ detëꞌë lao yedyi layu, leꞌe udaole lëbëꞌ xquia, unële diꞌidzaꞌ contra lëbëꞌ, bëtilenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Pcaꞌn Diuzi ley quienëꞌ lao naꞌa Moisés para leꞌe, pero leꞌe, biralele quien. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Naꞌra ude beyudyi be yaca benꞌ rnabëꞌ ca una Esteban, mazera bdzaꞌtzegueyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero Esteban, du yuꞌunëꞌ Bichi Be quie Diuzi, unaꞌnëꞌ guibá blëꞌënëꞌ xniꞌ guiꞌ ga zu Diuzi. Blëꞌërënëꞌ zë Jesús zaquëꞌ yebë quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Naꞌra una Esteban rëbinëꞌ yaca benꞌ rnabëꞌ: ―¡Ulenaꞌcara! Rlëꞌëdaꞌ uyalo guibá ga zu Diuzi. Rlëꞌëdaꞌ benꞌ naca bichi yugulu benëꞌ. Zënëꞌ zaquëꞌ yebë quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero lapsiote yaca benꞌ rnabëꞌ nagayaquëꞌ, uredyiyaꞌyaquëꞌ zidzo, ");
INSERT INTO zpcNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","labëxoteyaquëꞌ uquiëꞌyaquëꞌ lëbëꞌ ruꞌa yedyila. Caora naꞌ ulëchoyaquëꞌ gaban quieyaquëꞌ pcaꞌnyaquëꞌn lao naꞌa tu benꞌ cuidiꞌ laonëꞌ Saulo. Naꞌra uzulaoyaquëꞌ rguiyaquëꞌ lëbëꞌ yo ta gatiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pero du rguiyaquëꞌ Esteban yo, blidzëꞌ Jesús rëbinëꞌ lëbëꞌ: ―Señor Jesús, beziꞌ nëꞌëdiꞌ yeguidaꞌ ga zuloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Naꞌra uditzu Esteban z̃ibinëꞌ, unëꞌ zidzo rëbinëꞌ Jesús: ―Señor, uz̃iꞌz̃e quieyaquëꞌ rueyaquëꞌ xquia rutiyaquëꞌ nëꞌëdiꞌ. Ude beyudyi unëꞌ canaꞌ, gutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Naꞌra redaohue Saulo danꞌ bëtiyaquëꞌ Esteban. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Biz̃i caora bagutinëꞌ, uyo chopa tzona benꞌ rue quie xtiꞌidzaꞌ Diuzi biꞌayaquëꞌ cuerpo quienëꞌ ta yecachiꞌyaquëꞌ. Legazi rbedyiyaquëꞌ raqueyaquëꞌ bayëchiꞌ. Caora naꞌ uzulao yaca benëꞌ usacayaquëꞌ bizinaquezi benꞌ quie Jesús, benꞌ nitaꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Canaꞌ guca zëdi quie benꞌ quie Jesús, porque bipsan Saulo bënëꞌ contra leyaquëꞌ. Uyuꞌunëꞌ luꞌu yuꞌu quie quieyaquëꞌ, ulionëꞌ leyaquëꞌ luꞌu yuꞌu quiejëꞌ udzeꞌnëꞌ leyaquëꞌ luꞌu dyiguiba, laꞌachi nigula, laꞌachi beꞌmbyu. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Quie lenaꞌ bdzatza yaca benꞌ quie Jesús zioyaquëꞌ yedyi tula, zioyaquëꞌ yedyi reꞌ estado Judea len yedyi reꞌ estado Samaria. Pero biuzaꞌ yaca apóstol, begaꞌnyaquëꞌ ciudad Jerusalén. Naꞌ yaca benꞌ bedzatzaja uzaꞌ ciudad Jerusalén, zioyaquëꞌ rguixogueꞌyaquëꞌ benëꞌ xtiꞌidzaꞌ Diuzi tu tu yedyi ga bdyinyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Uzaꞌrë tu benꞌ quie Jesús laonëꞌ Felipe. Uzëꞌë zionëꞌ tu yedyi quie estado Samaria. Caora bdyinnëꞌ gudyinëꞌ yaca benꞌ yedyi naꞌ de que naca Jesús benꞌ Cristo, benꞌ useꞌelaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Naꞌra labedupate benꞌ yedyi naꞌ, labzënagateyaquëꞌ xtiꞌidzaꞌ Felipe, porque blëꞌëyaquëꞌ ruenëꞌ yelaꞌ huaca quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Caora naꞌ beyue Felipe yaca benꞌ yuꞌu taxiꞌibiꞌ. Bero yaca taxiꞌibiꞌ ga yuꞌuyacan uredyiyaꞌyacan. Lëscanꞌ beyuenëꞌ benꞌ z̃i, beyacayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Quie lenaꞌ lega bedaohue yaca benꞌ yedyi naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pero yedyi naꞌ ga uyo Felipe, uzu tu benꞌ rue brujo laonëꞌ Simón. Yelaꞌ brujo quienëꞌ, uz̃iꞌnëꞌ benꞌ quie Samaria yëꞌ unëꞌ naquëꞌ benꞌ belao, benꞌ balaꞌana. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Por lenaꞌ bzënagayaquëꞌ ca gudyinëꞌ leyaquëꞌ laꞌachi xcuidiꞌ, laꞌachi benꞌ huaca. Yugulujëꞌ bëyaquëꞌ lëbëꞌ caso, unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Benꞌ ni ruenëꞌ yelaꞌ huaca quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Naꞌra azio zë iza uz̃iꞌnëꞌ leyaquëꞌ yëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero caora bdyin Felipe, gudyinëꞌ leyaquëꞌ quie yelaꞌ rnabëꞌ quie Diuzi, gudyirënëꞌ leyaquëꞌ con cabëꞌ una Jesús, caora naꞌ guleyaquëꞌ quienëꞌ. Por lenaꞌ bëꞌ Felipe laoyaquëꞌ, tanto nigula como ca beꞌmbyu. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hasta cuin Simón gulerënëꞌ diꞌidzaꞌ quie Jesús, bëꞌrë Felipe laonëꞌ. Caora naꞌ udalënëꞌ Felipe tuz̃e, pero tu bebanzinëꞌ ca yelaꞌ huaca quie Diuzi bë Felipe. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Caora unezi ja apóstol nitaꞌ ciudad Jerusalén de que uyezilaꞌadyiꞌ benꞌ Samaria xtiꞌidzaꞌ Diuzi, naꞌra useꞌelaꞌyaquëꞌ Pedro len Juan zioyaquëꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Caora bdyinyaquëꞌ naꞌ, blidzayaquëꞌ Diuzi unabayaquëꞌ Diuzi uchizëꞌ Bichi Be quienëꞌ tzuꞌunëꞌ luꞌu guicho laxtaꞌo benꞌ Samaria barale quie Jesús, ");
INSERT INTO zpcNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","porque binetzuꞌu Bichi Be quie Diuzi luꞌu guicho laxtaꞌoyaquëꞌ. Caora cati bëꞌ Felipe laoyaquëꞌ dza naꞌte, tu bzëtozinëꞌ lao Jesús, quele uyuꞌuyaquëꞌ Bichi Be quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Quie lenaꞌ bdaꞌ Pedro len Juan naꞌayaquëꞌ guichoyaquëꞌ, laoyuꞌuteyaquëꞌ Bichi Be quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Caora blëꞌë Simón cabëꞌ bëyaquëꞌ uyuꞌu Bichi Be quie Diuzi luꞌu guicho laxtaꞌo benëꞌ cati bdaꞌyaquëꞌ naꞌayaquëꞌ guicho benëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","naꞌ unëꞌ rëbinëꞌ benꞌ apóstol: ―Gacatezi dumi inaboꞌ nagunaꞌn, chi uluꞌele nëꞌëdiꞌ bi huaꞌ tacuenda tzuꞌu Bichi Be quie Diuzi luꞌu guicho laxtaꞌo benëꞌ cati udaꞌa naꞌa guichoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Naꞌra bequëbi Pedro rëbinëꞌ Simón: ―Udyiaguiꞌ Diuzi luëꞌ lente dumi plata quioꞌ, porque racoꞌ pensari huaziꞌ Diuzi dumi plata tacuenda uchizanëꞌ Bichi Be quienëꞌ tzuꞌunëꞌ luꞌu guicho laxtaꞌo benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bide lato ni derecho quioꞌ huelaoꞌ nëtoꞌ tuz̃e, porque bineyëri laxtaꞌoloꞌ lao Diuzi, ");
INSERT INTO zpcNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","psan tamala quioꞌ. Unaba lao Diuzi chi yeziꞌz̃enëꞌ pensari median quioꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ca quie nisa slaꞌ ratza ja benëꞌ nacoꞌ. Yelaꞌ mala quioꞌ nacoꞌ ca quie benꞌ de luꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Naꞌra una Simón rëbinëꞌ apóstol: ―Huele cule inabale lao Diuzi yeziꞌz̃enëꞌ quiaꞌ, bigaca quiaꞌ con ca baonale nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Caora ude beyudyi udixogueꞌ apóstol yaca benꞌ nitaꞌ naꞌ xtiꞌidzaꞌ Diuzi, naꞌra bezaꞌyaquëꞌ zeyoyaquëꞌ ciudad Jerusalén, rguixogueꞌrëyaquëꞌ benꞌ Samaria nitaꞌ tu tu yedyi ga bedeyaquëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ude beyudyi naꞌ, bdyin tu ángel quie Diuzi ga zë Felipe rëbinëꞌ lëbëꞌ: ―Uz̃iꞌ, uyo tu lao lato ga bidyia yuꞌu, ga rde neza zaꞌ ciudad Jerusalén para yedyi Gaza. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Naꞌra uz̃iꞌnëꞌ zionëꞌ. Du tu neza naꞌ, zezaꞌ benꞌ bedilanëꞌ, benꞌ nación Etiopía. Benꞌ naꞌ naquëꞌ eunuco, benꞌ rapa dumi quie tu nigula lao Candace. Naca Candace reina quie nación Etiopía. Pues benꞌ naꞌ uyonëꞌ ciudad Jerusalén ga uyonlaꞌadyiꞌneꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Caora naꞌ reꞌnëꞌ luꞌu tu carro daoꞌ raꞌalaꞌ chopa bia zeyonëꞌ yedyinnëꞌ yedyi quienëꞌ. Naꞌra du reꞌnëꞌ luꞌu carro daoꞌ, rnaꞌnëꞌ guichi quie benꞌ profeta Isaías. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Caora naꞌ una Bichi Be quie Diuzi rëbinëꞌ Felipe: ―Uyo tzenaoꞌ benꞌ reꞌ luꞌu carro daoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Canaꞌ zio Felipe ga reꞌnëꞌ, pero benëꞌ rnënëꞌ diꞌidzaꞌ quie benꞌ profeta Isaías. Caora naꞌ una Felipe rëbinëꞌ lëbëꞌ: ―¿Rioñeꞌeloꞌ bi na diꞌidzaꞌ rnëloꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Naꞌra unëꞌ rëbinëꞌ Felipe: ―¿Biz̃i huaꞌ tzioñeꞌedaꞌ con ca rna lëꞌë guichi, chi ganu dyilaꞌ uzioñeꞌe nëꞌëdiꞌ? Ude beyudyi unëꞌ canaꞌ, gudyinëꞌ Felipe cuënëꞌ luꞌu carro ta cueꞌnëꞌ cuëtëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Naꞌra parte gan blabanëꞌ xtiꞌidzaꞌ Diuzi rnën cani: Naca quienëꞌ ca quie becoꞌ z̃iꞌilaꞌ guti benëꞌ. Lëzi naca quienëꞌ ca quie tu becoꞌ z̃iꞌilaꞌ rchugu benëꞌ guitzaꞌ quiebaꞌ, pero bibi unëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ptitoyaquëꞌ lëbëꞌ. Bibëyaquëꞌ justicia quienëꞌ. ¿Biz̃i huero inaro quie benꞌ yedyi quienëꞌ? Porque mero leyaquëꞌ bëtiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ude beyudyi unëꞌ lëꞌë guichi, naꞌra unëꞌ gudyinëꞌ Felipe: ―Una nëꞌëdiꞌ chi una benꞌ profeta quiëꞌ cuinnëꞌ o chi unëꞌ quie benꞌ tula. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Caora naꞌ uzulao Felipe rzioñeꞌenëꞌ lëbëꞌ con ca rna lëꞌë guichi gudyinëꞌ lëbëꞌ con ca guca quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Biz̃i cati bdyinyaquëꞌ ga zu nisa, una benꞌ Etiopía rëbinëꞌ Felipe: ―Abdyinro ga zu nisa. ¿A ver bi ca naoꞌ luëꞌ, chi bisaqueꞌ hueꞌloꞌ laohuaꞌ nëꞌëdiꞌ niga? ");
INSERT INTO zpcNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Naꞌra una Felipe rëbinëꞌ lëbëꞌ: ―Chi raleloꞌ quie Jesús du guicho du laꞌadyoꞌ, huazaqueꞌ huaꞌ laoloꞌ luëꞌ niga. Naꞌra bequëbi benꞌ naꞌ unëꞌ: ―Du guicho du laꞌadyaꞌ raledaꞌ naca Jesucristo z̃iꞌi Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Canaꞌ bë benꞌ naꞌ mandado cueza carro daoꞌ quienëꞌ ziolënëꞌ Felipe ruꞌa nisate, uyuꞌuyaquëꞌ luꞌu nisa bëꞌ Felipe laonëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cati beroyaquëꞌ luꞌu nisa, laoquiëꞌte Bichi Be quie Diuzi Felipe. Bira blëꞌë benꞌ naꞌ lëbëꞌ. Pero benꞌ naꞌ, lega redaohuenëꞌ bezaꞌnëꞌ zeyonëꞌ xquiedyinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Naꞌra labedyinte Felipe tu yedyi laona Azoto. Hora naꞌ bedenëꞌ yedyi tu yedyi rëbinëꞌ benëꞌ xtiꞌidzaꞌ Jesús con ca guca quienëꞌ hasta bdyinnëꞌ ciudad Cesarea. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Naꞌra bipsancazi Saulo yelaꞌ rdzaꞌ quienëꞌ reꞌennëꞌ gutinëꞌ benꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Por lenaꞌ uyonëꞌ yanabëꞌ guichi lao xanꞌ pxuzi tacuenda tzionëꞌ tzedilanëꞌ huenëꞌ preso nu benꞌ rnao xneza Jesús ciudad Damasco. Guꞌunnëꞌ tzuꞌunëꞌ idaoꞌ sinagoga quieyaquëꞌ guxonëꞌ iseꞌelaꞌnëꞌ leyaquëꞌ ciudad Jerusalén, chi beꞌmbyu, chi nigula. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pero ilëꞌëtiꞌzi binedyinnëꞌ yedyi, cati uyëzi tu xniꞌ guiꞌ zaꞌn sibi guibá yatilan lëbëꞌ ga zionëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Caora naꞌ bdinëꞌ yu, benëꞌ unë Jesús rëbinëꞌ lëbëꞌ: ―Saulo, ¿bixquienꞌ ruꞌ contra nëꞌëdiꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Naꞌra unaba Saulo: ―¿Nuz̃i luëꞌ, Señor? Hora naꞌ unë Jesús tatula, rëbinëꞌ lëbëꞌ: ―Nëꞌëdiꞌ laohuaꞌ Jesús. Nacaꞌ benꞌ rueloꞌ contra. Pero cala nëꞌëdiꞌ ruꞌ contra, nechanꞌ contra cuinzoꞌ rueloꞌ ca quie tu bëdyi huaga rulibibaꞌ nu lëꞌë yaga duchiꞌ nuꞌa xaꞌmbaꞌ ta rulaohuëꞌbaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Pero du rdzebi, du rz̃izi Saulo, unëꞌ rëbinëꞌ Jesús: ―¿Biz̃i ca reꞌenloꞌ huaꞌ, Señor? Naꞌra una Jesús, rëbinëꞌ lëbëꞌ: ―Beyasa, uyo ciudad Damasco. Bëꞌ bazuloꞌ ciudad naꞌ, naiseꞌelaꞌ benꞌ ina luëꞌ bi hueloꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Naꞌra uyasa Saulo gan denëꞌ layu. Caora bexaꞌ laonëꞌ, biblëꞌënëꞌ. Pero yaca benꞌ ziolënëꞌ, lega bdzebiyaquëꞌ, porque biblëꞌëyaquëꞌ nu benꞌ blidza Saulo. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Caora naꞌ bëxoyaquëꞌ nëꞌë uquiëꞌyaquëꞌ lëbëꞌ ciudad Damasco, ");
INSERT INTO zpcNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","pero lao tzona dza bibi blëꞌënëꞌ, bibi udaonëꞌ, bibi hueꞌenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Naꞌ ciudad Damasco zu tu benꞌ quie Jesús laonëꞌ Ananías. Caora naꞌ ptilalao Jesús lëbëꞌ ga zëꞌ rulidzëꞌ lëbëꞌ: ―Ananías. Pero ca quie benꞌ uxusa guca quienëꞌ benëꞌ unë Jesús. Naꞌra una Ananías: ―Ni zuaꞌ, Señor. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Naꞌra una Jesús rëbinëꞌ lëbëꞌ: ―Uz̃iꞌ, uyo ga rde tu lecan laona lecan li. Tzioloꞌ lidyi Judas, naꞌ yedzeleloꞌ tu benꞌ yedyi Tarso laonëꞌ Saulo. Huelaoꞌnëꞌ diꞌidzaꞌ, porque rulidzanëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Gaca quiëꞌ ca tu benꞌ rxusazi ilëꞌënëꞌ luëꞌ. Naꞌ udaꞌloꞌ naoꞌ guichonëꞌ tacuenda yelëꞌënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Caora be Ananías ca una Jesús, naꞌra unëꞌ rëbinëꞌ lëbëꞌ: ―Señor, zë lasa babedaꞌ cabëꞌ rue Saulo. Legazi bënëꞌ median contra yaca benꞌ quioꞌ nitaꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Naꞌ bazaꞌnëꞌ ni, nuꞌanëꞌ guichi quie yaca xanꞌ pxuzi. Conlë guichi naꞌ de yelaꞌ rnabëꞌ quiëꞌ ta guxonëꞌ huenëꞌ preso nu benꞌ rulidza luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero una Jesús, rëbinëꞌ lëbëꞌ: ―Uz̃iꞌ, uyo ga bdyinnëꞌ, porque uliogaꞌ lëbëꞌ tzeguedyinëꞌ benꞌ quie nación tula, len yaca rey quieyaquëꞌ, len benꞌ Israel diꞌidzaꞌ laꞌiya quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Naꞌ hueꞌliaꞌnëꞌ diꞌidzaꞌ cabëꞌ yedzagalaonëꞌ yëbinëꞌ benëꞌ diꞌidzaꞌ laꞌiya quiaꞌ. ―Canaꞌ una Jesús gudyinëꞌ Ananías. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Naꞌra uzaꞌ Ananías zionëꞌ bdyinnëꞌ yuꞌu ga bdyin Saulo, bdaꞌnëꞌ nëꞌë guicho Saulo, unëꞌ rëbinëꞌ lëbëꞌ: ―Bichaꞌ Saulo, Señor Jesús, benꞌ ptilalao luëꞌ tu neza ga zaꞌloꞌ, lëbëꞌ useꞌelaꞌnëꞌ nëꞌëdiꞌ bazaꞌ niga tacuenda yelëꞌëloꞌ tzuꞌuloꞌ Bichi Be quie Diuzi. ―Canaꞌ una Ananías gudyinëꞌ Saulo. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hora naꞌ bro tu ta naca ca z̃ezaꞌ bela luꞌu lao Saulo belëꞌënëꞌ tatula. Naꞌra uyasëꞌ bëꞌ Ananías lëbëꞌ laohuëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ude beyudyi naꞌ beyaonëꞌ beziꞌnëꞌ fuerza, begaꞌnnëꞌ ciudad Damasco chopa tzona dza yeyubinëꞌ benꞌ quie Jesús zuyaca naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Naꞌra uzulao Saulo rguixogueꞌnëꞌ benꞌ Israel, benꞌ nitaꞌ Damasco de que naca Jesús z̃iꞌi Diuzi. Rionëꞌ luꞌu sinagoga quieyaquëꞌ rëbinëꞌ leyaquëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Canaꞌ tu rebanzi yaca benꞌ be ca una Saulo, unayaquëꞌ rëbiyaquëꞌ laguedyijëꞌ: ―¿Cala lëbëꞌ bënëꞌ contra benꞌ quie Jesús, benꞌ nitaꞌ ciudad Jerusalén? ¿Cala lëbëꞌ blaꞌnëꞌ ni ta huenëꞌ benꞌ quie Jesús preso, usedyinnëꞌ leyaquëꞌ lao naꞌa yaca xanꞌ pxuzi? ―Canaꞌ unayaquëꞌ quie Saulo. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero birdzebi Saulo rguixogueꞌnëꞌ leyaquëꞌ de que naca Jesús benꞌ useꞌelaꞌ Diuzi. Bluꞌenëꞌ leyaquëꞌ lëꞌë guichi laꞌiya quie Diuzi ga rnën naca Jesús benꞌ Cristo. Bënëꞌ gan biubin yaca benꞌ Israel, benꞌ nitaꞌ ciudad Damasco, bi inayaquëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pero bazio zë dza zunëꞌ naꞌ, naꞌra guca yaca benꞌ Israel de acuerdo ta gutiyaquëꞌ Saulo. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lenaꞌ yugu dza, yugu yela, ureꞌyaquëꞌ neza ruꞌa yedyi tacuenda guxoyaquëꞌ gutiyaquëꞌ lëbëꞌ. Pero unezi Saulo cabëꞌ guꞌunyaquëꞌ hueyaquëꞌ quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Hora naꞌ du rtzeꞌ, uquiëꞌ benꞌ quie Jesús lëbëꞌ, urëyaquëꞌ ga zu tu ventan z̃e lëꞌë besu zio ruꞌa yedyi, uyuꞌunëꞌ luꞌu tu chicuiti z̃e ta uchizayaquëꞌ lëbëꞌ layu tacuenda ulanëꞌ zionëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Caora bedyinnëꞌ ciudad Jerusalén guꞌunnëꞌ huelënëꞌ benꞌ quie Jesús tuz̃e. Pero rdzebiyaquëꞌ lëbëꞌ, porque bineneziyaquëꞌ chi tali banaquëꞌ benꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Por lenaꞌ uquiëꞌ Bernabé lëbëꞌ ga nitaꞌ ja apóstol yaguëdyinëꞌ leyaquëꞌ cabëꞌ guca quie Saulo blëꞌënëꞌ Jesús tu neza Damasco, bëꞌlë Jesús lëbëꞌ diꞌidzaꞌ, birdzebinëꞌ udixogueꞌnëꞌ benꞌ Damasco xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hora naꞌ uyezilaꞌadyiꞌyaquëꞌ lëbëꞌ begaꞌnlënëꞌ leyaquëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Naꞌra birdzebinëꞌ uzulaonëꞌ rguixogueꞌnëꞌ benëꞌ xtiꞌidzaꞌ Diuzi. Uyuꞌunëꞌ huenë lënëꞌ tu cueꞌ benꞌ Israel, benꞌ raca diꞌidzaꞌ griego, pero ureꞌ unaoyaquëꞌ bi hueyaquëꞌ ta gutiyaquëꞌ Saulo. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Caora unezi los demás benꞌ quie Jesús de que reꞌenyaquëꞌ gutiyaquëꞌ lëbëꞌ, uquiëꞌyaquëꞌ lëbëꞌ ciudad Cesarea, naꞌtera useꞌelaꞌyaquëꞌ lëbëꞌ yedyi Tarso. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Naꞌra ja benꞌ quie Jesús nitaꞌ yedyi quie estado Judea, len benꞌ nitaꞌ estado Galilea, len benꞌ nitaꞌ estado Samaria, uzujëꞌ contento. Du guicho du laꞌadyiꞌjëꞌ unaojëꞌ xneza Jesús. Yugu dza rapalaꞌnyaquëꞌ Diuzi gucalë Bichi Be quie Diuzi leyaquëꞌ. Canaꞌ mazera uye benꞌ bëlë leyaquëꞌ tuz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Caora naꞌ rio Pedro rayubinëꞌ benꞌ quie Jesús con bi yedyi nitaꞌyaquëꞌ. Canaꞌ uyonëꞌ yeyubinëꞌ yaca benꞌ quie Jesús, benꞌ nitaꞌ yedyi Lida. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lëyedyi naꞌ yatilanëꞌ tu benꞌ z̃i laonëꞌ Eneas. Azio xuna iza denëꞌ lao belaga naz̃inëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Naꞌ una Pedro rëbinëꞌ lëbëꞌ: ―¡Eneas, hueyue Jesucristo luëꞌ! ¡Uyasa, beyue laze belaga quioꞌ! Naꞌra caora uyasëꞌ, labeyacatenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Biz̃i naꞌ caora blëꞌë yugo benꞌ yedyi Lida len yugo benꞌ yedyi Sarón cabëꞌ guca quienëꞌ beyacanëꞌ, canaꞌra psanyaquëꞌ costumbre gula quieyaquëꞌ unaoyaquëꞌ xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Naꞌra dza naꞌte uzu tu nigula yedyi Jope laonëꞌ Tabita. Naꞌ diꞌidzaꞌ griego laorënëꞌ Dorcas. Naquëꞌ benꞌ nao xneza Jesús. Yugu dza gucalënëꞌ benꞌ yëchiꞌ, bëꞌnëꞌ leyaquëꞌ ta de quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Biz̃i naꞌ bdyin dza guca z̃hueꞌnëꞌ gutinëꞌ. Caora naꞌ bgazujëꞌ lëbëꞌ yao uxubayaquëꞌ lëbëꞌ sibi tu luꞌu cuarto chopa xcuia. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Naꞌra como uneziyaquëꞌ yedyi Lida zu Pedro, lëscanꞌ como reꞌn gaꞌalaꞌzi, useꞌelaꞌjëꞌ chopa beꞌmbyu tzenabayaquëꞌ Pedro, chi bisaqueꞌ sëꞌë luegozi. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Naꞌra uzaꞌ Pedro ziolënëꞌ leyaquëꞌ. Caora bedyinyaquëꞌ uquiëꞌyaquëꞌ lëbëꞌ luꞌu cuarto chopa xcuia ga de nigula. Luꞌu cuarto naꞌ nitaꞌ ja nigula guti xquiuhue rbedyiyaquëꞌ, bluꞌeyaquëꞌ Pedro vestido quieyaquëꞌ ta bë Dorcas cati nezunëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Naꞌra bë Pedro mandado yero ja nigula luꞌu cuarto. Caora beroyaquëꞌ, uditzu z̃ibinëꞌ blidzëꞌ Diuzi. Ude beyudyi naꞌ, byëchunëꞌ unaꞌnëꞌ benꞌ huati, unëꞌ rëbinëꞌ lënëꞌ: ―Tabita, uyasa. Cati una Pedro canaꞌ, labez̃aꞌte lao nigula, unaꞌnëꞌ Pedro uyasanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bëxu Pedro naꞌanëꞌ gucalënëꞌ lëbëꞌ uzulinëꞌ. Naꞌra beyëz̃i Pedro yaca nigula guti xquiuhue lente los demás benꞌ quie Jesús. Bluꞌenëꞌ leyaquëꞌ de que neban Dorcas. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Naꞌra yugulu benꞌ yedyi Jope uneziyaquëꞌ cabëꞌ guca quie nigula naꞌ. Caora naꞌ uzulao zëyaquëꞌ naoyaquëꞌ xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Naꞌra zë dza begaꞌn Pedro yedyi Jope. Uzunëꞌ lidyi tu benꞌ lao Simón, benꞌ rutiꞌ z̃aba bëdyihuaga. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Naꞌra ciudad Cesarea uzu tu benꞌ laonëꞌ Cornelio. Naquëꞌ xanꞌ tu gayuhua soldado. Naꞌ naca soldado quienëꞌ tu cueꞌ benꞌ italiano. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Lëbëꞌ lente yugulu familia quienëꞌ udapalaꞌnyaquëꞌ Diuzi. Gucalënëꞌ benꞌ Israel, bëꞌnëꞌ caridad quiejëꞌ, rulidzëꞌ Diuzi yugu dza. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Biz̃i bdyin dza blëꞌë Cornelio tu ángel quie Diuzi. Uzë ángel naꞌ bdyinnëꞌ ga zë Cornelio. Zadzeꞌ cadu las tres guca quienëꞌ canaꞌ. Pero ca quie benꞌ uxusa guca quiëꞌ blëꞌënëꞌ lëbëꞌ. Naꞌra una ángel naꞌ rëbinëꞌ lëbëꞌ: ―Cornelio. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Du rdzebi Cornelio unaꞌnëꞌ ángel rëbinëꞌ lëbëꞌ: ―¿Bi naoꞌ, Señor? Naꞌra una ángel rëbinëꞌ Cornelio: ―Raxe Diuzi ca diꞌidzaꞌ ruꞌeloꞌnëꞌ, lëscanꞌ raxenëꞌ ca rueloꞌ ruꞌeloꞌ benꞌ yëchiꞌ caridad. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hora naꞌ iseꞌeloꞌ chopa tzona benꞌ tzio yedyi Jope tzexiꞌyaquëꞌ tu benꞌ lao Simón Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Zunëꞌ z̃an yuꞌu quie tu benꞌ laorë Simón, benꞌ rutiꞌ guidi. Zu yuꞌu quienëꞌ gaꞌalaꞌ ruꞌa nisadaoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ude beyudyi una ángel canaꞌ, zeyonëꞌ. Caora naꞌ beyëz̃i Cornelio chopa biꞌ criado quienëꞌ len tu soldado quienëꞌ, benꞌ rapalaꞌn Diuzi, benꞌ de confianza, ");
INSERT INTO zpcNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","gudyinëꞌ leyaquëꞌ con cabëꞌ guca quienëꞌ, naꞌ useꞌelaꞌnëꞌ leyaquëꞌ yedyi Jope. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Naꞌ beteyu, tu nezioyaquëꞌ tu neza gaꞌalaꞌ ga zu yedyi Jope, caora naꞌ cadu laꞌodza urë Pedro lun yuꞌu, como naca lun yuꞌu quiejëꞌ baꞌa. Naꞌra zënëꞌ guicho yuꞌu naꞌ uzulaonëꞌ ruꞌelënëꞌ Diuzi diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Hora naꞌ rduenëꞌ unabëꞌ hue benꞌ ga zunëꞌ ta gaonëꞌ. Pero tu neruꞌeyaquëꞌ laze ta gaonëꞌ, cati guca quienëꞌ ca quie benꞌ rxusa. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Caora naꞌ blëꞌënëꞌ uyalo guibá, uyëzi tu ta naca ca quie tu laꞌariꞌ yuaꞌ nerio idapa isquinan. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Laona naꞌ dyilaꞌ zë cueꞌ bia guixiꞌ, bia dyia tapa niꞌe, len zë cueꞌ bëla len bguini. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Caora naꞌ be Pedro una tu benꞌ rëbinëꞌ lëbëꞌ: ―Pedro, uyasa. Bëtibaꞌ, udaobaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Naꞌra una Pedro: ―Bigaohuaꞌbaꞌ, Señor, porque ni tu lasa binegaohuaꞌ tu ta biruꞌen lato gaohuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Naꞌ be Pedro una benꞌ naꞌ tatula rëbinëꞌ lëbëꞌ: ―Tu ta aona Diuzi gaoloꞌ, binaoꞌ biruꞌen lato gaoloꞌn. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Beyunate lasa guca quie Pedro canaꞌ, naꞌra beyëpi laꞌariꞌ yuaꞌ zeyon guibá tatula. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Neraque Pedro bi reꞌen inë diꞌidzaꞌ unë benꞌ naꞌ cati bdyin benꞌ useꞌelaꞌ Cornelio ruꞌa yuꞌu. Rdayaquëꞌ reguiloyaquëꞌ lidyi Simón. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Caora naꞌ bdyinyaquëꞌ unayaquëꞌ zidzo chi zu Simón, benꞌ laorë Pedro, z̃an yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Neraca Pedro pensari cabëꞌ naca ta blëꞌënëꞌ, caora cati unë Bichi Be quie Diuzi rëbinëꞌ lëbëꞌ: ―Abdyin tzona benꞌ reguilo luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Beyëzi, beyolëyaquëꞌ. Bidëboꞌ bibi gaca quioꞌ, porque nëꞌëdiꞌ biaꞌ mandado dexiꞌyaquëꞌ luëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Naꞌra beyëzi Pedro yetilanëꞌ leyaquëꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Nëꞌëdiꞌ reguilole. ¿Nuz̃i useꞌelaꞌ leꞌe zaꞌle niga? ");
INSERT INTO zpcNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Naꞌra unayaquëꞌ rëbiyaquëꞌ Pedro: ―Nëtoꞌ zaꞌndoꞌ mandado quie capitán Cornelio. Naca Cornelio tu benꞌ balaꞌana, benꞌ rionlaꞌadyiꞌ Diuzi. Rapalaꞌn yugulu benꞌ Israel lëbëꞌ. Naꞌra blaꞌndoꞌ ni, porque niogue bdyin tu ángel quie Diuzi lidyi Cornelio gudyinëꞌ lëbëꞌ ta guidandoꞌ dexiꞌndoꞌ luëꞌ tacuenda uzënaga Cornelio bi diꞌidzaꞌ yëboꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Naꞌra uz̃iꞌ Pedro leyaquëꞌ luꞌu yuꞌu begaꞌnyaquëꞌ tu yela. Caora cati beteyu, uyasayaquëꞌ ziolë Pedro leyaquëꞌ. Lëzi uquiëꞌrë Pedro chopa tzona benꞌ nao xneza Jesús, benꞌ nitaꞌ yedyi Jope. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Naꞌra cadu zila dza urupe bedyinyaquëꞌ ruꞌa ciudad Cesarea. Caora naꞌ guz̃i Cornelio diadza quiëꞌ len nu amigo zudyiꞌilënëꞌ tacuenda cuezayaquëꞌ idyin Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Cati bdyin Pedro ruꞌa yuꞌu, hora naꞌ zio Cornelio yetilëꞌ lëbëꞌ, uditzu z̃ibinëꞌ lao Pedro, uyonlaꞌadyiꞌnëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero belisa Pedro lëbëꞌ unëꞌ: ―Uzuli, lëzi benëꞌzi ca luëꞌ nacaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Du ruꞌeyaquëꞌ diꞌidzaꞌ, uyuꞌuyaquëꞌ luꞌu yuꞌu quie Cornelio, blëꞌë Pedro babedupa benꞌ zë luꞌu lidyinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Naꞌra una Pedro rëbinëꞌ leyaquëꞌ: ―Dyëꞌëdi banezile con ca naca costumbre quiendoꞌ benꞌ Israel. Nacan z̃udyi huelëndoꞌ benꞌ binaca benꞌ Israel tuz̃e. Ni siquiera ta tzuꞌundoꞌ luꞌu yuꞌu quieyaquëꞌ biruꞌen lato. Pero naꞌa sí, abzioñeꞌe Diuzi nëꞌëdiꞌ de que bireyaꞌalaꞌ iniaꞌ biruꞌen lato hueliaꞌ benꞌ binaca benꞌ Israel tuz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Por lenaꞌ bibi zëdi biaꞌ zaꞌliaꞌ yaca benꞌ useꞌeloꞌ dexiꞌ nëꞌëdiꞌ. Naꞌ biz̃i, ¿ca reꞌenloꞌ huaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Naꞌra una Cornelio rëbinëꞌ Pedro: ―Azio tapa dza naꞌ, cadu hora naꞌa, zuaꞌ z̃an yuꞌu niga ruaꞌ ubasi rulidzaꞌ Diuzi. Caora naꞌ detilalao tu benꞌ naco laꞌariꞌ bezëri di nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Naꞌ una benꞌ naꞌ rëbinëꞌ nëꞌëdiꞌ: “Cornelio, re Diuzi hora rulidzoꞌ lëbëꞌ. Lëzi rlëꞌënëꞌ hora ruꞌeloꞌ benꞌ yëchiꞌ caridad. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Naꞌ pseꞌelaꞌ benꞌ quioꞌ yedyi Jope tzexiꞌyaquëꞌ tu benꞌ lao Simón Pedro. Zuëꞌ z̃an lidyi itu benꞌ lao Simón, benꞌ huëtiꞌ guidi. Huedzelejëꞌ lidyinëꞌ zunëꞌ gaꞌalaꞌ ruꞌa nisadaoꞌ. Caora bablaꞌnëꞌ quioꞌ naꞌ, hueꞌlënëꞌ luëꞌ diꞌidzaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pues beyudyi unëꞌ canaꞌ, laoseꞌelaꞌtiaꞌ mozo quiaꞌ dexiꞌyaquëꞌ luëꞌ. Babaoꞌ tu huen blaoꞌ niga. Hora naꞌ rlëꞌë Diuzi nitaꞌro niga tacuenda uzënagandoꞌ diꞌidzaꞌ reꞌen Diuzi inaoꞌ nëtoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","35","Naꞌra una Pedro rëbinëꞌ leyaquëꞌ: ―Hora sí, aoyoñeꞌedaꞌ de que tuzi ca rue Diuzi yeyëchiꞌlaꞌadyiꞌnëꞌ nu benꞌ huen, benꞌ rapalaꞌn lëbëꞌ, chi benꞌ Israel, chi benꞌ quie nación tula. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Una Diuzi dza naꞌ gudyinëꞌ nëtoꞌ benꞌ Israel de que lao naꞌa Jesucristo, benꞌ naca Señor quie yugulu benëꞌ, huataꞌ tadyaꞌa yegaꞌnnan huen quie yaca benëꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Dyëꞌëdi nezile cabëꞌ guca lao yaca yedyi quie benꞌ Israel. Uzulao Jesús udixogueꞌnëꞌ xtiꞌidzaꞌ Diuzi estado Galilea dza naꞌ cati beyudyi udixogueꞌ Juan bautista xtiꞌidzaꞌ Diuzi bëꞌ lao yaca benëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Lëzi dyëꞌëdi nezile useꞌelaꞌ Diuzi Bichi Be quienëꞌ bëlënëꞌ Jesús yelaꞌ huaca quienëꞌ, udanëꞌ bënëꞌ puro tadyaꞌa, beyuenëꞌ yaca benꞌ yuꞌu taxiꞌibiꞌ nun quie nuelë Diuzi lëbëꞌ tuz̃e. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nëtoꞌ blëꞌëndoꞌ yugulu ta bë Jesús caora zuëꞌ udëꞌ estado Judea len ciudad Jerusalén. Ude beyudyi naꞌ bdaꞌyaquëꞌ lëbëꞌ lëꞌë yaga cruzo bëtiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero bëꞌ baode tzona dza pseban Diuzi lëbëꞌ bidëꞌ detilalaonëꞌ nëtoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pero nëtoꞌzi ptilalaonëꞌ, quele yugulu benëꞌ. Ulio Diuzi nëtoꞌ dza naꞌte ta gacandoꞌ testigo cabëꞌ guca quienëꞌ gutinëꞌ bebannëꞌ. Nëtoꞌ udaondoꞌ hueꞌendoꞌ len lëbëꞌ cati bebannëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Naꞌra useꞌelaꞌ Diuzi nëtoꞌ tzetixogueꞌndoꞌ benëꞌ diꞌidzaꞌ quienëꞌ rëbindoꞌyaquëꞌ de que ulio Diuzi Jesús benꞌ hue juicio quie yugulu benëꞌ, laꞌachi benꞌ neban, laꞌachi benꞌ baguti. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Lëscanꞌ desde dza naꞌte una yaca benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi rëbiyaquëꞌ quie Jesús, unayaquëꞌ gataꞌ yelaꞌ hueziꞌz̃e quie yugulu benꞌ nao xnezëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bineyudyi hueꞌlë Pedro lejëꞌ diꞌidzaꞌ caora uyuꞌu Bichi Be quie Diuzi luꞌu guicho laxtaꞌo benꞌ bzënaga diꞌidzaꞌ quiëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Naꞌra uzulaoyaquëꞌ rnëyaquëꞌ diꞌidzaꞌ tula, diꞌidzaꞌ binaca quieyaquëꞌ, rulidzayaquëꞌ Diuzi. Naꞌra yaca benꞌ Israel, benꞌ uzaꞌlë Pedro, tu begaꞌnzijëꞌ rebanziyaquëꞌ porque hasta benꞌ tulala, benꞌ binaca benꞌ Israel, uyuꞌurëyaquëꞌ Bichi Be quie Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Naꞌra una Pedro rëbinëꞌ laguedyinëꞌ: ―¿Quele baoyuꞌuyaquëꞌ Bichi Be quie Diuzi laga ca uyuꞌunëꞌ raꞌo? Quie lenaꞌ nunu udzon hueꞌro laoyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Caora naꞌ bë Pedro mandado hueꞌyaquëꞌ laoyaquëꞌ uzëtoyaquëꞌ lao Jesucristo. Ude beyudyi naꞌ unabayaquëꞌ yegaꞌnlë Pedro leyaquëꞌ chopa tzona dza. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Naꞌra unezi yaca apóstol len los demás benꞌ quie Jesús nitaꞌ estado Judea de que banaorë benꞌ tulala, benꞌ binaca benꞌ Israel, xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cati bedyin Pedro ciudad Jerusalén, naꞌra yaca benꞌ Israel, benꞌ nao xneza Jesús, udilayaquëꞌ Pedro unayaquëꞌ ");
INSERT INTO zpcNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","rëbiyaquëꞌ lëbëꞌ: ―¿Biquienꞌ uyuꞌuloꞌ luꞌu yuꞌu quie benꞌ tulala, yaca benꞌ binaca benꞌ Israel, udaolaoꞌ tuz̃e len leyaquëꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Naꞌra una Pedro rëbinëꞌ leyaquëꞌ yugulu con cabëꞌ guca quienëꞌ unëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Uyaꞌa yedyi Jope. Naꞌ caora blidzaꞌ Diuzi, guca quiaꞌ ca quie tu benꞌ rxusa, blëꞌëdaꞌ uyëzi tu ta naca ca quie tu laꞌariꞌ yuaꞌ nerio idapa isquinan guibá. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Caora unaꞌ dyëꞌëdi, blëꞌëdaꞌ dyilaꞌ zë cueꞌ bia guixiꞌ, bia dyia tapa niꞌe, len zë cueꞌ bëla, len bguini. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Hora naꞌ bedaꞌ unë tu benꞌ una nëꞌëdiꞌ: “Pedro, uyasa. Bëtibaꞌ, udaobaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero agudyaꞌ benꞌ naꞌ: “Bigaohuaꞌbaꞌ, Señor, porque ni tu lasa binegaohuaꞌ tu biruꞌen lato gaohuaꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Naꞌra una benꞌ naꞌ rëbinëꞌ nëꞌëdiꞌ tatula: “Tu ta aona Diuzi gaoloꞌ, binaoꞌ biruꞌen lato gaoloꞌn.” ");
INSERT INTO zpcNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Beyunate lasa unëꞌ nëꞌëdiꞌ canaꞌ, naꞌra beyëpin zeyonan ladza. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Caora naꞌ bdyin tzona yaca benꞌ reguilo nëꞌëdiꞌ, benꞌ uzaꞌyaca yedyi Cesarea dexiꞌyaquëꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Hora naꞌ una Bichi Be quie Diuzi rëbinëꞌ nëꞌëdiꞌ: “Uz̃iꞌ, uyolëyaquëꞌ. Bibi cuidado gapoꞌ.” Por lenaꞌ uzaꞌa uquiëꞌa xopa benꞌ nao xneza Jesús ziondoꞌ ga zu benꞌ useꞌelaꞌ yaca benꞌ dexiꞌ nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Caora bdyindoꞌ lidyi benꞌ naꞌ, udixogueꞌnëꞌ nëtoꞌ con cabëꞌ blëꞌënëꞌ nëꞌ bdyin tu ángel lidyinëꞌ rëbinëꞌ lëbëꞌ: “Useꞌelaꞌ benꞌ quioꞌ tzioyaquëꞌ yedyi Jope tzexiꞌyaquëꞌ tu benꞌ lao Simón Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Lëbëꞌ inëꞌ luëꞌ cabëꞌ hueloꞌ ta ute usela Diuzi luëꞌ lente yugo diadza quioꞌ.” Canaꞌ una ángel rëbinëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Naꞌra uzulaohuaꞌ ruꞌeliaꞌyaquëꞌ diꞌidzaꞌ, caora naꞌ uyuꞌu Bichi Be quie Diuzi luꞌu guicho laxtaꞌoyaquëꞌ laga ca uyuꞌunëꞌ luꞌu guicho laxtaꞌoro dza naꞌte. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Hora naꞌ bezaꞌlaꞌadyaꞌ diꞌidzaꞌ una Jesús caora unëꞌ: “Tali bëꞌ Juan laole conlë nisa, pero netzaꞌla ca hue Diuzi quiele, iseꞌelëꞌ Bichi Be quienëꞌ ta tzuꞌunëꞌ luꞌu laxtaꞌole.” ");
INSERT INTO zpcNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pues como bëꞌ Diuzi lato tzuꞌu Bichi Be quienëꞌ luꞌu laxtaꞌoyaquëꞌ laga con cabëꞌ bënëꞌ quiero, benꞌ nao xneza Señor quiero Jesucristo, ¿nuz̃i naca nëꞌëdiꞌ bihuaꞌ ca reꞌen Diuzi huaꞌ? ");
INSERT INTO zpcNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Naꞌra yaca benꞌ quie Jesús, benꞌ nitaꞌ ciudad Jerusalén, caora beyaquëꞌ cabëꞌ diꞌidzaꞌ ruꞌe Pedro, bira pquëpiyaquëꞌ lëbëꞌ, unayaquëꞌ rëbiyaquëꞌ laguedyiyaquëꞌ: ―Diuzi naquëꞌ benꞌ z̃e. Como hasta benꞌ tulala, benꞌ binaca benꞌ Israel, reꞌen Diuzi utzaꞌyaquëꞌ pensari quieyaquëꞌ tacuenda gataꞌ yelaꞌ neban quieyaquëꞌ tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Naꞌra cati bëtiyaquëꞌ Esteban dza naꞌte, lëscanꞌ uzulaoyaquëꞌ rueyaquëꞌ contra yaca los demás benꞌ nao xneza Jesús, benꞌ nitaꞌja naꞌ. Por lenaꞌ bdzatzajëꞌ uzaꞌyaquëꞌ ziojëꞌ yedyi tula. Ziojëꞌ ciudad Antioquía, ziojëꞌ yedyi nebaba Fenicia, ziojëꞌ yedyi nebaba Chipre. Naꞌra yaca benꞌ uzaꞌja ciudad Jerusalén, biudixogueꞌyaquëꞌ yugulu benëꞌ xtiꞌidzaꞌ Diuzi, dechanꞌ entre yaca benꞌ Israelzi udixogueꞌjëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero ibala benꞌ nao xneza Jesús, benꞌ uzaꞌja yedyi nebaba Chipre, len benꞌ uzaꞌja yedyi nebaba Cirene, zioyaquëꞌ bdyinyaquëꞌ ciudad Antioquía uzulaoyaquëꞌ rguixogueꞌyaquëꞌ benꞌ tulala, benꞌ binacaja benꞌ Israel, xtiꞌidzaꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Naꞌra bë Diuzi yelaꞌ huaca quiëꞌ lao naꞌayaquëꞌ. Por lenaꞌ zëyaquëꞌ psanyaquëꞌ costumbre gula quieyaquëꞌ, unaoyaquëꞌ xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Naꞌra benꞌ nao xneza Jesús, benꞌ nitaꞌ ciudad Jerusalén, caora uneziyaquëꞌ cabëꞌ guca ciudad Antioquía, useꞌelaꞌyaquëꞌ Bernabé ciudad naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Caora bdyinnëꞌ naꞌ, blëꞌënëꞌ bë Diuzi yelaꞌ huaca quienëꞌ, bëlaꞌiyanëꞌ leyaquëꞌ. Naꞌra redaohuetzegue Bernabé unëyuenëꞌ leyaquëꞌ ta inaorayaquëꞌ xneza Jesús du guicho du laꞌadyiꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Canaꞌ bë Bernabé como danꞌ naquëꞌ benꞌ dyaꞌa, benꞌ yuꞌu Bichi Be quie Diuzi, benꞌ nao xneza Jesús du guicho du laꞌadyiꞌ. Canaꞌ bënëꞌ gan gule benꞌ zë, benꞌ nao xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ude beyudyi naꞌ, uzaꞌ Bernabé zionëꞌ yedyi Tarso tzedilanëꞌ Saulo. Caora bedzelenëꞌ lëbëꞌ, uquiëꞌnëꞌ lëbëꞌ ciudad Antioquía. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Naꞌra lao tu iza nayaꞌ begaꞌnyaquëꞌ len benꞌ nao xneza Jesús psëdiyaquëꞌ benꞌ zë xtiꞌidzaꞌ Diuzi. Naꞌ yaca benꞌ nitaꞌ ciudad Antioquía, leyaquëꞌ uxubayaquëꞌ tanëro lao benꞌ nao xneza Jesús benꞌ cristiano. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Caora naꞌ ciudad Antioquía bdyin chopa tzona benꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi, benꞌ uzaꞌyaca ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Naꞌra uzuli tu benꞌ zaꞌ leyaquëꞌ laonëꞌ Agabo ga bedupa yaca benꞌ nao xneza Jesús. Du yuꞌunëꞌ Bichi Be quie Diuzi, unëꞌ rëbinëꞌ leyaquëꞌ: ―Una Diuzi nëꞌëdiꞌ gaca tu obin huala duz̃e yedyi layu. ―Canaꞌ unëꞌ gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pues gucan con ca unëꞌ. Guca tu obin huala tiempo uzu tu benꞌ lao Claudio, benꞌ naca rey quie benꞌ romano. Naꞌra yaca benꞌ nao xneza Jesús nitaꞌ ciudad Antioquía, udilojëꞌ modo gacalëyaquëꞌ laguedyiyaquëꞌ benꞌ nao xneza Jesús, benꞌ nitaꞌ estado Judea. ");
INSERT INTO zpcNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Canaꞌ ptupayaquëꞌ lëꞌëtiꞌ huio dumi iseꞌelaꞌyaquëꞌn lao naꞌa Bernabé len Saulo ta tzehuaꞌayaquëꞌn tzesanyaquëꞌn lao naꞌa yaca benꞌ nao xneza Jesús, benꞌ nitaꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Naꞌra dza naꞌ uzulao rey Herodes ruenëꞌ contra yaca benꞌ quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Bënëꞌ mandado guti soldado quienëꞌ Santiago, benꞌ bichi Juan. Bëtiyaquëꞌ lëbëꞌ conlë espada quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Caora blëꞌë rey Herodes de que raxe benꞌ Israel ruenëꞌ contra benꞌ quie Jesús, naꞌra bëxorënëꞌ Pedro bënëꞌ lëbëꞌ preso. Bdzeꞌnëꞌ lëbëꞌ luꞌu dyiguiba dza rueyaquëꞌ lani cati rezaꞌlaꞌadyiꞌ benꞌ Israel dza bezaꞌ yaca xuzixtaꞌoyaquëꞌ nación Egipto. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Naꞌra ude beyudyi bdzeꞌnëꞌ lëbëꞌ luꞌu dyiguiba, bë rey Herodes mandado zio chiꞌinuꞌbetu soldado ta gapayaquëꞌ lëbëꞌ. Tapazi soldado udapayaquëꞌ lëbëꞌ tu chiꞌ huio. Naꞌra psaqueꞌ rey Herodes cuionëꞌ Pedro luꞌu dyiguiba cati ude dza lani tacuenda guti ja soldado lëbëꞌ zaquëꞌlao lao benꞌ yedyi. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tu nede Pedro luꞌu dyiguiba, caora naꞌ rulidza yaca benꞌ quie Jesús Diuzi du guicho du laꞌadyiꞌyaquëꞌ por nun quie Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pues binedyin hora tzeniꞌ ta cuio rey Herodes Pedro luꞌu dyiguiba. Nede Pedro narionëꞌ chopa caden rasinëꞌ entre chopa soldado. Lëzi zë ja mazera soldado rapayaquëꞌ ruꞌa yuꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Caora naꞌ ureꞌ xniꞌ guiꞌ luꞌu dyiguiba labdyinte tu ángel quie Diuzi. Naꞌra ptanëꞌ Pedro ta psebënëꞌ lëbëꞌ rëbinëꞌ lëbëꞌ: ―Labe uyasa. Bëꞌ uyasa Pedro, cuinzi cadena bguinojan danꞌ narionëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Na ꞌuna ángel tatula rëbinëꞌ lëbëꞌ: ―Pquio cincho quioꞌ bde huarache quioꞌ. Ude beyudyi bë Pedro con ca una ángel gudyinëꞌ lëbëꞌ, naꞌra una ángel rëbinëꞌ lëbëꞌ tatula: ―Bdubi gabán quioꞌ unao nëꞌëdiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Caora naꞌ zio Pedro zenaonëꞌ ángel, pero biraquenëꞌ chi tali cabëꞌ raca quienëꞌ len ángel, dechanꞌ raquenëꞌ rxusanëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Naꞌra chopa cueꞌ udeyaquëꞌ ga zë soldado rapa dyiguiba, bdyinyaquëꞌ ga zu puerta de guíba ga beyudyite yeroyaquëꞌ laꞌo yedyi. Naꞌ tu cuinzina uyalo puerta naꞌ bedeyaquëꞌ beroyaquëꞌ luꞌu dyiguiba. Ledaoꞌzi bezaꞌyaquëꞌ naꞌ lazeyote ángel, begaꞌn Pedro tuzinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Canaꞌra gucabëꞌ Pedro nacan li cabëꞌ guca quienëꞌ, unëꞌ: ―Pues nacan li de que useꞌelaꞌ Diuzi tu ángel quienëꞌ ta pselanëꞌ nëꞌëdiꞌ con ca reꞌen rey Herodes len ja benꞌ Israel huejëꞌ quiaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Naꞌra zionëꞌ racanëꞌ pensari cabëꞌ guca quienëꞌ bdyinnëꞌ lidyi María, z̃naꞌ Juan, benꞌ laorë Marcos. Pero luꞌu yuꞌu naꞌ babedupa benꞌ zë, benꞌ nao xneza Jesús, rulidzayaquëꞌ Diuzi por nun quie Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Naꞌra bdyinnëꞌ laliꞌa zënëꞌ ruꞌa yuꞌu ruxidyiguëꞌ lëꞌë puerta. Caora naꞌ zio tu nigula daoꞌ laobiꞌ Rode tzenaꞌbiꞌ nu ruxidyi puerta, ");
INSERT INTO zpcNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","caora naꞌ bezaquebiꞌ chiꞌ Pedro, pero biusalobiꞌ puerta nun quie redaohuebiꞌ bebiꞌbiꞌ zeyobiꞌ luꞌu yuꞌu gan nitaꞌ ja benꞌ rulidza Diuzi yeguëdyibiꞌ leyaquëꞌ babdyin Pedro zënëꞌ ruꞌa yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Naꞌra una ja benꞌ nitaꞌ luꞌu yuꞌu rëbiyaquëꞌ lëbiꞌ: ―¿Que raca tondulo? Pero lëbiꞌ nabiꞌ talicazi bdyin Pedro ruꞌa puerta. Naꞌra unayaquëꞌ rëbiyaquëꞌ lëbiꞌ: ―Cala lëbëꞌ, dechanꞌ ángel quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pero zëcazi Pedro ruxidyiguëꞌ lëꞌë puerta. Naꞌ cati usaloyaquëꞌ puerta blëꞌëyaquëꞌ lëbëꞌ, lega bdzebiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Naꞌra bënëꞌ seña conlë nëꞌë ta yegaꞌnyaquëꞌ chizi. Caora naꞌ gudyinëꞌ leyaquëꞌ cabëꞌ guca ulio Diuzi lëbëꞌ luꞌu dyiguiba. Quie lenaꞌ unëꞌ rëbinëꞌ leyaquëꞌ: ―Uletzeguëdyi Santiago lente yaca los demás bichiro cabëꞌ ta uz̃acaꞌ berogaꞌ luꞌu dyiguiba. Ude beyudyi naꞌ, uz̃iꞌnëꞌ zeyoguëꞌ ga tula. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Biz̃i cati uyeniꞌnaꞌ ziladaoꞌ, legazi uyuꞌu soldado ruꞌbe, porque bineziyaquëꞌ bi guca quie Pedro. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Canaꞌ bë rey Herodes mandado tzio soldado tula tzediloyaquëꞌ Pedro, pero ganu Pedro bedzeleyaquëꞌ. Hora naꞌ beyëz̃inëꞌ pquëpinëꞌ ja soldado rapa dyiguiba, pero biubinyaquëꞌ bi inayaquëꞌ. Naꞌra bë rey Herodes mandado gati yaca soldado. Ude beyudyi naꞌ, uzaꞌnëꞌ estado Judea zionëꞌ yesunëꞌ ciudad Cesarea. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Naꞌra puro yedyi ga rnabëꞌ rey Herodes naꞌ raꞌo yaca benꞌ yedyi Tiro len benꞌ yedyi Sidón ta raoyaquëꞌ. Pero rey Herodes naꞌ rdzaꞌnëꞌ leyaquëꞌ. Quie lenaꞌ gucayaquëꞌ de acuerdo ta tzenaꞌyaquëꞌ lëbëꞌ ta hueꞌlëyaquëꞌ lëbëꞌ diꞌidzaꞌ. Por lenaꞌ yeyubiyaquëꞌ tu benꞌ lao Blasto, benꞌ naca empleado quie rey Herodes, cuenda naꞌ chi huenëꞌ tu cule hueꞌlënëꞌ rey Herodes diꞌidzaꞌ ta yegaꞌntzaꞌolë rey Herodes leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Cati bdyin dza ruꞌelë rey Herodes leyaquëꞌ diꞌidzaꞌ, guconëꞌ z̃abanëꞌ ta racocazi rey, yequeꞌnëꞌ xlatonëꞌ ga rbezëꞌ benëꞌ, uzulaonëꞌ ruꞌelënëꞌ yaca benëꞌ diꞌidzaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Naꞌra yaca benꞌ bzënaga quienëꞌ, unëyaquëꞌ zidzo nayaquëꞌ: ―¡Quele benëꞌ rnë, nechanꞌ tu diuzi rnë! ");
INSERT INTO zpcNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Bineyudyi diꞌidzaꞌ caora labdyinte tu ángel quie Diuzi bënëꞌ ta gaca z̃hueꞌ rey Herodes, porque bigudyinëꞌ yaca benꞌ bzënaga quienëꞌ de que bireyaꞌalaꞌ tzionlaꞌadyiꞌjëꞌ lëbëꞌ, tuzi Diuzi reyaꞌalaꞌ tzionlaꞌadyiꞌjëꞌ. Naꞌra udao bëla daoꞌ biz̃u yuꞌu luꞌu lëꞌënëꞌ lëbëꞌ gutinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tu dza, tu dza, ziorarë xtiꞌidzaꞌ Diuzi cabëꞌ udixogueꞌjëꞌ duz̃e yedyi reꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Naꞌra Bernabé len Saulo, caora beyudyi dyin quieyaquëꞌ, bezaꞌyaquëꞌ ciudad Jerusalén zeyoyaquëꞌ ciudad Antioquía uquiëꞌyaquëꞌ Juan, benꞌ laorë Marcos. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Naꞌra entre ja benꞌ nao xneza Jesús nitaꞌ ciudad Antioquía, uzu yaca benꞌ psëdi udixogueꞌ xtiꞌidzaꞌ Diuzi. Uzu tu benꞌ lao Simón Gaso. Lëscanꞌ uzurë tu benꞌ yedyi Cirene laonëꞌ Lucio. Lëscanꞌ uzurë itunëꞌ laonëꞌ Manaén, benꞌ abgulalë Herodes. Naca Herodes gobernador quie estado Galilea. Lëzi ciudad Antioquía nitaꞌlë Saulo len Bernabé len los demásyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Biz̃i cati guca tu dza rionlaꞌadyiꞌyaquëꞌ Diuzi rueyaquëꞌ ubasi, hora naꞌ unë Bichi Be quie Diuzi gudyinëꞌ lejëꞌ: ―Uleudaꞌ Bernabé len Saulo ta tzioyaquëꞌ hueyaquëꞌ ca tu dyin reꞌendaꞌ hueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Quie lenaꞌ bipsanjëꞌ bëyaquëꞌ ubasi. Caora naꞌ du rulidzayaquëꞌ Diuzi, naꞌ bdaꞌyaquëꞌ naꞌajëꞌ guicho Bernabé len Saulo unabayaquëꞌ gacalë Diuzi leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Naꞌra useꞌelaꞌ Bichi Be quie Diuzi leyaquëꞌ uzaꞌyaquëꞌ zioyaquëꞌ ciudad Seleucia. Caora naꞌ udejëꞌ yedyi naꞌ uyuꞌuyaquëꞌ luꞌu barco ta idyinyaquëꞌ isla Chipre. Naquiëꞌjëꞌ Juan Marcos ta gacalënëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Naꞌra cati bdyinyaquëꞌ yedyi Salamina. Caora naꞌ rioyaquëꞌ luꞌu sinagoga quie ja benꞌ nacaja benꞌ Israel, uzulaoyaquëꞌ rguixogueꞌjëꞌ leyaquëꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pues udayaquëꞌ duz̃ete isla Chipre bdyinyaquëꞌ yedyi Pafos. Naꞌ yatilayaquëꞌ tu benꞌ Israel laonëꞌ Barjesús. Naquëꞌ benꞌ brujo, nanëꞌ rnëꞌ puro xtiꞌidzaꞌ Diuzi, dechanꞌ benꞌ hueziꞌ yëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Pues benꞌ brujo naꞌ zuëꞌ lao benꞌ naca gobernador laonëꞌ Sergio Paulo. Pues gobernador naꞌ naquëꞌ benꞌ de pensari. Bënëꞌ mandado tzexiꞌyaquëꞌ Bernabé len Saulo, porque reꞌennëꞌ yenëꞌ con cabëꞌ naca xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero benꞌ brujo naꞌ laorënëꞌ Elimas, bënëꞌ contra Bernabé len Saulo. Biguꞌunnëꞌ gale gobernador xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Naꞌra Saulo naꞌ laorënëꞌ Pablo, du yuꞌunëꞌ Bichi Be quie Diuzi, unaꞌnëꞌ benꞌ brujo dyëꞌëdi, unëꞌ gudyinëꞌ lëbëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","―Benꞌ hueziꞌ yëꞌ, benꞌ mala nacoꞌ. Nacoꞌ z̃iꞌi taxiꞌibiꞌ. Puro tamedian rguiloloꞌ rueloꞌ. ¿Bixquienꞌ birsanloꞌ rziuꞌ benëꞌ yëꞌ bireꞌenloꞌ galeyaquëꞌ xtiꞌidzaꞌ Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pues naꞌra abdyin hora hue Diuzi luëꞌ castigo. Gacoꞌ benꞌ laochula. Zëdza ni siquiera xniꞌ obidza bira ilëꞌëloꞌ. Caora naꞌ laochulate lao benꞌ brujo, bira blëꞌënëꞌ. Naꞌ unabayëchiꞌnëꞌ gudyinëꞌ nu benꞌ bëxo nëꞌë, benꞌ bequiëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Caora blëꞌë gobernador cabëꞌ guca quie benꞌ brujo, naꞌra gulenëꞌ xtiꞌidzaꞌ Diuzi. Tu begaꞌnzinëꞌ bebanzinëꞌ con cabëꞌ naca yelaꞌ huaca quie xtiꞌidzaꞌ Señor quiero Jesucristo. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Naꞌra Pablo lënëꞌ yaca benꞌ zaꞌlënëꞌ, uzaꞌyaquëꞌ yedyi Pafos con luꞌu barco zioyaquëꞌ bdyinyaquëꞌ yedyi Perge ga nebaba Panfilia. Pero Juan Marcos naꞌ psanlaꞌadyiꞌnëꞌ leyaquëꞌ bezaꞌnëꞌ naꞌ, bedyinnëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Caora naꞌ udeyaquëꞌ yedyi Perge bdyinyaquëꞌ ciudad Antioquía ga nebaba Pisidia. Caora guca dza huezilaꞌadyiꞌ, uzaꞌyaquëꞌ zioyaquëꞌ luꞌu sinagoga ureꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ude beyudyi unë yaca benꞌ reꞌ naꞌ diꞌidzaꞌ bzu Moisés len yaca los demás benꞌ profeta lëꞌë guichi, naꞌra useꞌelaꞌ yaca xanꞌ sinagoga tu benꞌ unë gudyinëꞌ leyaquëꞌ: ―Bichaꞌ, chi reꞌenle yëbile ja benëꞌ bi diꞌidzaꞌ, huazaqueꞌ yëbilejëꞌn naꞌa. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pues naꞌra uzuli Pablo ga reꞌnëꞌ, bënëꞌ seña conlë naꞌanëꞌ tacuenda naꞌ initaꞌjëꞌ chizi uzënagayaquëꞌ quienëꞌ. Naꞌra unëꞌ rëbinëꞌ leyaquëꞌ: ―Ulezëcara nagale leꞌe benꞌ Israel len yugulu leꞌe benꞌ rionlaꞌadyiꞌrë Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Psere Diuzi xuzixtaꞌoro bënëꞌ uyeyaquëꞌ gucayaquëꞌ benꞌ zë dza nenitaꞌjëꞌ yu binaca quieyaquëꞌ, yu nebaba nación Egipto. Conlë yelaꞌ huaca quienëꞌ gucalënëꞌ xuzixtaꞌoro bezaꞌyaquëꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pero con paciencia uz̃iꞌz̃e Diuzi quieyaquëꞌ dza udayaquëꞌ chopa galo iza tu paraje ga bidyia yuꞌu. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Caora naꞌ bdyiaguiꞌ Diuzi gadyi yedyi ta nebaba Canaán, bëꞌnëꞌ xuzixtaꞌoro layu quie benꞌ naꞌ gucan quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Naꞌra cadu tapa gayuhua iza yu gatzo ulio Diuzi yaca benꞌ gaca juez quieyaquëꞌ ta inabëꞌnëꞌ leyaquëꞌ. Canaꞌzi begaꞌnnan hasta dza rda tu benꞌ profeta laonëꞌ Samuel. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Hora naꞌ unaba xuzixtaꞌoro usere Diuzi tu rey, benꞌ inabëꞌ leyaquëꞌ. Naꞌra ulio Diuzi tu benꞌ laonëꞌ Saúl, z̃iꞌi Cis. Naquëꞌ diadza quie xuzixtaꞌoro Benjamín, benꞌ unitaꞌ dza naꞌte. Naꞌra guquëꞌ rey quieyaquëꞌ cadu chopa galo iza. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pero uderala cati beziꞌ Diuzi yelaꞌ rnabëꞌ quie Saúl, bënëꞌ mandado gaca David rey quieyaquëꞌ lao laza Saúl. Naꞌra quie rey David unë Diuzi caora unëꞌ rëbinëꞌ xuzixtaꞌoro: “Naꞌa sí, baoliogaꞌ David z̃iꞌi Isaí ta gaquëꞌ rey quiele, porque rexedaꞌnëꞌ ruenëꞌ du guicho du laꞌadyiꞌnëꞌ con ta reꞌendaꞌ huenëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Naꞌra nernë Pablo rëbinëꞌ leyaquëꞌ: ―Según ca compromiso bë Diuzi dza naꞌte, ulionëꞌ de entre yaca z̃iꞌisuba rey David nu benꞌ ute usela raꞌo yeyoro ga zu Diuzi. Naca Jesús lëbenꞌ ulionëꞌ ta ute uselanëꞌ raꞌo. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pues tu zaquixogueꞌ Jesús xtiꞌidzaꞌ Diuzi, udixogueꞌ Juan bautista raꞌo de que yuguluro reyaꞌalaꞌ utzaꞌro pensari quiero cuenda hueꞌ Juan laoro. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Naꞌra cati baruen bago dza gati Juan unëꞌ: “Raquele nacaꞌ Cristo, pero binacaꞌ Cristo. Zazaꞌrala benꞌ naca Cristo. Tantozi nacarëꞌ benꞌ belao ca nëꞌëdiꞌ, ni lëꞌëtiꞌ bibizacaꞌ ni siquiera biyeyaz̃ogaꞌ cuiogaꞌ guidi yuꞌu niꞌanëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Naꞌra nernë Pablo rëbinëꞌ lejëꞌ: ―Leꞌe benꞌ z̃iꞌisuba xuzixtaꞌohuaꞌ Abraham, len leꞌe benꞌ tula, benꞌ rionlaꞌadyiꞌrë Diuzi, nacan para leꞌe diꞌidzaꞌ rniaꞌ niga. Rguixogueꞌn quie benꞌ ute usela raꞌo yeyoro ga zu Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Pues ja benꞌ nitaꞌ ciudad Jerusalén lente benꞌ rnabëꞌ quieyaquëꞌ, binezijëꞌ chi z̃iꞌi Diuzi naca Jesús. Lëzi raqueyaquëꞌ rioñeꞌeyaquëꞌ bi reꞌen ina diꞌidzaꞌ bzu benꞌ profeta lëꞌë guichi caora cati rulabajëꞌ luꞌu sinagoga dza sábado. Pero birioñeꞌeyaquëꞌn, dechanꞌ bëyaquëꞌ yelaꞌ mala con ca una benꞌ profeta hueyaquëꞌ udaoyaquëꞌ Jesús xquia guꞌunyaquëꞌ gutiyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Biz̃i biubinyaquëꞌ bi hueyaquëꞌ ta guti benꞌ rnabëꞌ Jesús, porque bibi dulaꞌ xquia de quienëꞌ. Canaꞌ guꞌunjëꞌ guti Pilato Jesús ta gatinëꞌ ca quie benꞌ de dulaꞌ xquia quie. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Naꞌra caora baguca quie Jesús con ca rna lëꞌë guichi laꞌiya quie Diuzi ca gaca quie Jesús, bechizayaquëꞌ lëbëꞌ ga gutiëꞌ lëꞌë yaga cruzo yecachiꞌyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero pseban Diuzi lëbëꞌ zionëꞌ ptilëꞌ con yaca benꞌ quienëꞌ, benꞌ uzaꞌlë lëbëꞌ estado Galilea bdyinyaquëꞌ ciudad Jerusalén. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Pues zidza uzulënëꞌ yaca benꞌ quiëꞌ naꞌ. Leyaquëꞌ rguixogueꞌjëꞌ benëꞌ con ca guca quie Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Lëzi nëtoꞌ zëndoꞌ niga rguixogueꞌndoꞌ leꞌe xtiꞌidzaꞌ Diuzi, rguixogueꞌndoꞌ leꞌe de que según compromiso bëlë Diuzi xuzixtaꞌoro dza naꞌte, bzuëꞌ diꞌidzaꞌ quiëꞌ caora cati psebannëꞌ Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Lëzi para raꞌo pseban Diuzi lëbëꞌ, como nacaro z̃iꞌisuba leyaquëꞌ. Pseban Diuzi lëbëꞌ con cabëꞌ rguixogueꞌn lëꞌë guichi salmo chopa cabëꞌ rnën caniga: “Luëꞌ nacoꞌ z̃iꞌinaꞌ. Abdyin dza uluꞌenaꞌ yaca benꞌ nitaꞌ lao yedyi layu z̃iꞌinaꞌ luëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Lëzi una Diuzi dza naꞌte de que usebannëꞌ Jesús tacuenda yebannëꞌ tuzioli bira gaticazinëꞌ. Quie lenaꞌ unëꞌ caora nëꞌ: “Huecazaꞌ huen quiele según ca compromiso bëliaꞌ xuzixtaꞌole rey David.” ");
INSERT INTO zpcNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Lëzi rnën lëꞌë guichi tula cabëꞌ hue Diuzi quie z̃iꞌinëꞌ. Lenaꞌ rnën cani: “Bihueꞌnëꞌ lato itabo cuiaguiꞌ cuerpo quie z̃iꞌinëꞌ, benꞌ naca laꞌiya quienëꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Naꞌra nernë Pablo rëbinëꞌ leyaquëꞌ: ―Pues xuzixtaꞌoro rey David, bënëꞌ cumplir con ca gudyi Diuzi lëbëꞌ dza nezunëꞌ yedyi layu. Pero bdyin dza quienëꞌ gutinëꞌ yecachiꞌyaquëꞌ lëbëꞌ ga racachiꞌyaquëꞌ xuzixtaꞌoro. Naꞌra utabo cuerpo quienëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","pero biutabo cuerpo quie Jesús, porque pseban Diuzi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bichaꞌ, reyaꞌalaꞌ inezile de que lao naꞌa Jesús yeziꞌz̃e Diuzi dulaꞌ xquia quiele. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Lëscanꞌ lao naꞌa Jesús hualëꞌë Diuzi yugu benꞌ nao xneza Jesús benꞌ laxtaꞌo yëri. Pero quie ley pcaꞌn Diuzi lao naꞌa Moisés, bide fuerza valor quie ley naꞌ ta ilëꞌë Diuzi benꞌ nao ley naꞌ benꞌ laxtaꞌo yëri. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pues quie lenaꞌ gapale cuidado ta bigaca quiele con ca bzu ja benꞌ profeta lëꞌë guichi cati una Diuzi cani: ");
INSERT INTO zpcNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Huaꞌ tu yelaꞌ milagro quiaꞌ dza rdale yedyi layu, pero yelaꞌ yaladyiꞌ quiele, bigalele quie yelaꞌ milagro quiaꞌ huaꞌ. Baꞌalaꞌcazi nu benꞌ yexiꞌidzeꞌnëꞌ leꞌe, bigalecazile. Tu yebanzile ilëꞌële con ca huaꞌ entre leꞌe, pero como danꞌ biralele, lenaꞌ udyiaguiꞌa leꞌe. Canaꞌ una Pablo udixogueꞌnëꞌ leyaquëꞌ con cabëꞌ una Diuzi dza naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Naꞌra cati bero Pablo len yaca laguedyinëꞌ luꞌu sinagoga, benꞌ zë, benꞌ bzënaga quiëꞌ, unabajëꞌ lëbëꞌ chi biyeguidëꞌ ixunꞌ ta yexiꞌidzeꞌnëꞌ leyaquëꞌ mazera. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Naꞌra bedzatzayaquëꞌ luꞌu sinagoga, pero zë benꞌ Israel len benꞌ tula, benꞌ naotzegue religión quie benꞌ Israel, unaoyaquëꞌ ziolëyaquëꞌ Pablo len Bernabé tu neza. Caora naꞌ bëꞌ Pablo len Bernabé leyaquëꞌ consejo gudyiyaquëꞌ leyaquëꞌ biyuhuëdiyaquëꞌ inaoyaquëꞌ xneza Diuzi nun quie ulio Diuzi nedyëꞌë Diuzi leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Naꞌra beyaꞌ xunꞌ bedupa casi yugu benꞌ yedyi luꞌu sinagoga ta uzënagayaquëꞌ con cabëꞌ rna xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Naꞌra cati blëꞌë yaca los demás benꞌ Israel cabëꞌ abedupa benꞌ zë uzënagayaquëꞌ ca una Pablo, caora naꞌ gucaz̃ëꞌyaquëꞌ uzulaoyaquëꞌ rnëlëyaquëꞌ Pablo hasta ptasi bnioyaquëꞌ lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pues hora naꞌ bibdzebi Pablo len Bernabé unayaquëꞌ rëbiyaquëꞌ leyaquëꞌ cani: ―Pues tanëro reyaꞌalaꞌ zaꞌndoꞌ quixogueꞌndoꞌ leꞌe xtiꞌidzaꞌ Diuzi porque nacale benꞌ Israel. Pero naꞌ leꞌe bireꞌenle uzënagale. Bireꞌenle gun Diuzi leꞌe yelaꞌ neban tuzioli. Quie lenaꞌ yezaꞌndoꞌ niga tzetixogueꞌndoꞌ yaca benꞌ binaca benꞌ Israel con cabëꞌ rna xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Porque canaꞌ useꞌelaꞌ Diuzi nëtoꞌ unëꞌ gudyinëꞌ cani: Bzuaꞌ leꞌe ca quie tu guiꞌ z̃e tacuenda ilëꞌë yaca benꞌ tula, benꞌ binaca benꞌ Israel. Iseꞌelaꞌ leꞌe ta tzetixogueꞌle xtiꞌidzaꞌ yaca benꞌ nitaꞌ yedyi zituꞌ gula. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Naꞌra bëꞌ be yaca benꞌ binaca benꞌ Israel ca unë Pablo, legazi redaohueyaquëꞌ nayaquëꞌ naca dyaꞌa xtiꞌidzaꞌ Diuzi. Pues gule yaca benꞌ ulio Diuzi, yaca benꞌ reꞌen Diuzi gataꞌ yelaꞌ neban quie tuzioli. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Naꞌra bipsan benꞌ quie Jesús quixogueꞌyaquëꞌ benꞌ nitaꞌ yugulu yedyi reꞌ naꞌ xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero bala benꞌ Israel bëꞌlëyaquëꞌ benꞌ belao quie yedyi, lente bala nigula balaꞌana diꞌidzaꞌ. Unabayaquëꞌ chi bigacalëyaquëꞌ leyaquëꞌ ta yebioyaquëꞌ Pablo len Bernabé ciudad naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Caora naꞌ pchibi Pablo len Bernabé yu bëxte dyia huarache quieyaquëꞌ, porque según costumbre quieyaquëꞌ, lenaꞌ nacan seña de que psaca benꞌ ciudad naꞌ leyaquëꞌ bizinaquezi. Caora naꞌ bezaꞌjëꞌ ziojëꞌ ciudad Iconio. ");
INSERT INTO zpcNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero con ca tu yaca benꞌ bagule xtiꞌidzaꞌ Jesús, uyuꞌuyaquëꞌ Bichi Be quie Diuzi redaohuetzegueyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Naꞌra bëꞌ bdyin Pablo len Bernabé ciudad Iconio, zioyaquëꞌ uyuꞌuyaquëꞌ luꞌu sinagoga quie benꞌ Israel. Naꞌ bëꞌlëyaquëꞌ benꞌ bedupa luꞌu sinagoga naꞌ diꞌidzaꞌ. Caora naꞌ benꞌ zë guleyaquëꞌ ca gudyi Pablo len Bernabé leyaquëꞌ, tanto benꞌ Israel como ca benꞌ binaca benꞌ Israel. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero yaca benꞌ Israel, benꞌ birale cabëꞌ diꞌidzaꞌ ruꞌe Pablo len Bernabé, unëyaquëꞌ contra leyaquëꞌ. Naꞌra ja benꞌ binaca benꞌ Israel, guleyaquëꞌ ca diꞌidzaꞌ unë benꞌ Israel contra lejëꞌ, blëꞌëyaquëꞌ benꞌ mala benꞌ nao xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Quie lenaꞌ begaꞌn Pablo len Bernabé zidza naꞌ. Birdzebijëꞌ udixogueꞌyaquëꞌ con cabëꞌ rna xtiꞌidzaꞌ Jesús. Pues bëꞌ Diuzi leyaquëꞌ lato hueyaquëꞌ yelaꞌ milagro quienëꞌ tacuenda inezi yaca benꞌ yedyi naꞌ de que huacalë Diuzi nutezi benꞌ gale xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Quie lenaꞌ guca yaca benꞌ ciudad Iconio chopa cueꞌ. Tu cueꞌyaquëꞌ bëlëyaquëꞌ benꞌ Israel, benꞌ binao xneza Jesús tuz̃e. Pero itu cueꞌjëꞌ bdaꞌyaquëꞌ yaca apóstol. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Quie lenaꞌ guca yaca benꞌ binao xneza Jesús de acuerdo len benꞌ rnabëꞌ quieyaquëꞌ ta hueyaquëꞌ leyaquëꞌ bizinaquezi quiyaquëꞌ leyaquëꞌ yo. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Biz̃i caora unezi Pablo len Bernabé ca reꞌenyaquëꞌ hueyaquëꞌ quieyaquëꞌ, uzaꞌyaquëꞌ zioyaquëꞌ yu nebaba Licaonia, udeyaquëꞌ ciudad Listra len ciudad Derbe, uderëyaquëꞌ yaca ciudad tula, ciudad reꞌ gaꞌalaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Con ga udeyaquëꞌ, udixogueꞌjëꞌ benëꞌ con cabëꞌ rna xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Naꞌra ciudad Listra uzu tu beꞌmbyu, benꞌ biraca saꞌ. Ni tu lasagazi binesaꞌnëꞌ. Puro reꞌtezinëꞌ como naz̃inëꞌ desde cati galotenëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Naꞌra reꞌnëꞌ rzënaguëꞌ con cabëꞌ diꞌidzaꞌ ruꞌe Pablo. Naꞌra unaꞌ Pablo lëbëꞌ dyëꞌëdi, gucabëꞌnëꞌ rzudyiꞌilë benꞌ z̃i Diuzi rbezëꞌ yeyue Diuzi lëbëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Naꞌra unë Pablo zidzo gudyinëꞌ lëbëꞌ: ―Uzuli, bezu niꞌaloꞌ derecho. Caora naꞌ uxitinëꞌ labezutenëꞌ niꞌanëꞌ yu, laozulaotenëꞌ rzaꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Biz̃i cati blëꞌë ja benëꞌ cabëꞌ bë Pablo quie benꞌ z̃i, unëyaquëꞌ zidzo rëbiyaquëꞌ laguedyiyaquëꞌ: ―¡Baoyëzi chopa diuzi quiero! ¡Nacajëꞌ forma quie benëꞌ detilalaoyaquëꞌ raꞌo niga! ");
INSERT INTO zpcNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Naꞌ unëyaquëꞌ xtiꞌidzaꞌyaquëꞌ, diꞌidzaꞌ quie benꞌ Licaonia. Unayaquëꞌ naca Bernabé tu diuzi laonëꞌ Júpiter. Lëzi unayaquëꞌ naca Pablo itu diuzi laonëꞌ Mercurio. Naꞌra unayaquëꞌ naca Pablo diuzi Mercurio, porque nayaquëꞌ naca Mercurio benꞌ ruꞌetzegue diꞌidzaꞌ cabëꞌ ruꞌe Pablo. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Naꞌra ruꞌa ciudad naꞌ zu tu idaoꞌ quie diuzi Júpiter. Pues naꞌ bro tu pxuzi quie idaoꞌ naꞌ, bdyinnëꞌ ga zë Pablo len Bernabé. Naquiëꞌnëꞌ bëdyihuaga, bia nuetzaꞌonëꞌ con yo. Naꞌra pxuzi lënëꞌ yaca benꞌ nitaꞌ naꞌ, reꞌenyaquëꞌ tzionlaꞌadyiꞌyaquëꞌ Pablo len Bernabé nayaquëꞌ yaca diuzi leyaquëꞌ. Reꞌenyaquëꞌ gutiyaquëꞌ bëdyihuaga ca quie gun quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Naꞌra cati gucabëꞌ Pablo len Bernabé cabëꞌ reꞌenyaquëꞌ huejëꞌ, caora naꞌ uzulaoyaquëꞌ rchezayaquëꞌ z̃abayaquëꞌ, yuꞌuyaquëꞌ lado yaca benëꞌ naꞌ unëyaquëꞌ zidzo rëbiyaquëꞌ leyaquëꞌ: ");
INSERT INTO zpcNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Benëꞌ! ¿Bixquienꞌ ruele tamedian quiele ruele canaꞌ? Lëzi benëꞌzi ca leꞌe nacarëndoꞌ zaꞌndoꞌ quixogueꞌndoꞌ leꞌe ta usanle ta bibi sirve rionlaꞌadyiꞌle benëꞌ. Reyaꞌalaꞌ tzionlaꞌadyiꞌle tuzi Diuzi zu guibá, Diuzi neban tuzioli. Como lëbëꞌ bënëꞌ guibá, lëbëꞌ bzaloguëꞌ dyila yu, lëbëꞌ udixuguëꞌ nisadaoꞌ. Hasta con lao yugulute bënëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Naꞌra dza naꞌte baꞌalaꞌcazi bë yaca benꞌ binaca benꞌ Israel ta rnazin quieyaquëꞌ, bibë Diuzi castigo quieyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Birsannëꞌ ruluꞌenëꞌ yelaꞌ huaca quienëꞌ. Ruluꞌenëꞌ benꞌ huen naquëꞌ danꞌ tadyaꞌa babënnëꞌ quiero. Por lëbëꞌ ruen nisayo, rero usecho dyaꞌa, runnëꞌ yugulu ta raoro yugu dza tzuꞌuro gusto lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pero baꞌalaꞌcazi una Pablo len Bernabé canaꞌ, canezi bëyaquëꞌ gan bibëti yaca benꞌ yedyi bëdyihuaga ca quie gun quiejëꞌ ta tzionlaꞌadyiꞌjëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Naꞌra cati bdyin yaca benꞌ Israel, benꞌ uzaꞌja ciudad Antioquía len benꞌ uzaꞌrëja ciudad Iconio, bëꞌlëyaquëꞌ benꞌ ciudad diꞌidzaꞌ ta huejëꞌ contra Pablo len Bernabé. Quie lenaꞌ uzulao ja benꞌ ciudad naꞌ rguijëꞌ Pablo yo ta gutiyaquëꞌ lëbëꞌ. Caora guqueyaquëꞌ baguti Pablo, hora naꞌ udubayaquëꞌ lëbëꞌ yatixojëꞌ ruꞌa ciudadtela. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Naꞌra bedupa yaca benꞌ quie Jesús nayëchoyaquëꞌ ganꞌ de Pablo. Caora naꞌ beyasa Pablo zeyonëꞌ lao ciudad tatula. Pues beteyu dza tula, uzaꞌlë Pablo Bernabé zioyaquëꞌ ciudad Derbe. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Naꞌra udixogueꞌrëjëꞌ benꞌ ciudad Derbe con cabëꞌ rna xtiꞌidzaꞌ Diuzi. Naꞌ bëyaquëꞌ gan gule benꞌ zë, gucayaquëꞌ benꞌ nao xneza Jesús. Ude beyudyi naꞌ, bedeyaquëꞌ ciudad Listra, bedeyaquëꞌ ciudad Iconio, bedeyaquëꞌ ciudad Antioquía. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Naꞌra ja ciudad ga bedeyaquëꞌ, bëꞌyaquëꞌ diꞌidzaꞌ z̃elaꞌadyiꞌ yaca benꞌ nao xneza Jesús, unëyueyaquëꞌ leyaquëꞌ con cabëꞌ reyaꞌalaꞌ hueyaquëꞌ inaoyaquëꞌ du guicho du laꞌadyiꞌjëꞌ xneza Jesús. Lëzi unayaquëꞌ rëbiyaquëꞌ leyaquëꞌ: ―Huetzague benëꞌ bizinaquezi quiele, porque canaꞌ ruejëꞌ quie nu benꞌ nao xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Lëzi ulioyaquëꞌ benꞌ napa dyin, benꞌ racalë benꞌ nao xneza Jesús quie quie ciudad ga nitaꞌ benꞌ nao xneza Jesús. Pues beyudyi naꞌ, bëyaquëꞌ ubasi bëꞌlëyaquëꞌ Diuzi diꞌidzaꞌ blidzayaquëꞌ lëbëꞌ chi biucuasa ucuiꞌonëꞌ bi tamala gaca quie benꞌ ulioyaquëꞌ como danꞌ barue quieyaquëꞌ xtiꞌidzaꞌnëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ude beyudyi naꞌ, uzaꞌyaquëꞌ zioyaquëꞌ udeyaquëꞌ yu nebaba Pisidia, naꞌ bdyinyaquëꞌ yu nebaba Panfilia. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Lëzi udejëꞌ ciudad Perge ga udixogueꞌrëjëꞌ benꞌ ciudad naꞌ con cabëꞌ rna xtiꞌidzaꞌ Diuzi. Beyudyi naꞌ uzaꞌyaquëꞌ zioyaquëꞌ ciudad Atalia. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Naꞌra ciudad naꞌ bezaꞌyaquëꞌ con luꞌu barco zezaꞌyaquëꞌ bedyinyaquëꞌ ciudad Antioquía tatula ga nitaꞌ yaca benꞌ nao xneza Jesús, benꞌ useꞌelaꞌ leyaquëꞌ yetixogueꞌyaquëꞌ benëꞌ xtiꞌidzaꞌ Diuzi. Lëyaca benꞌ naꞌ bëꞌlëyaquëꞌ Diuzi diꞌidzaꞌ por nun quieyaquëꞌ dza zioyaquëꞌ naꞌ. Naꞌ beyudyi tu ca dyin quie Diuzi bëyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Naꞌra caora bedyinyaquëꞌ, bdupa yaca benꞌ nao xneza Jesús nitaꞌ ciudad Antioquía. Uzulao Pablo ruꞌenëꞌ diꞌidzaꞌ con cabëꞌ gucalë Diuzi leyaquëꞌ. Lëzi gudyinëꞌ leyaquëꞌ con cabëꞌ ulio Diuzi benꞌ binaca benꞌ Israel rnaorëyaquëꞌ xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Naꞌra Pablo len Bernabé begaꞌnyaquëꞌ zidza ciudad naꞌ len yaca los demás benꞌ nao xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pero tiempo naꞌ bdyin chopa tzona benëꞌ ciudad Antioquía, benꞌ uzaꞌja estado Judea. Naꞌra unayaquëꞌ rëbiyaquëꞌ benꞌ nao xneza Jesús: ―Yugu benꞌ binaca benꞌ Israel, benꞌ banao xneza Jesús, rnaban hueyaquëꞌ lato su tu xëdyidaoꞌ cuinyaquëꞌ cabëꞌ rna lëꞌë guichi ley pcaꞌn Moisés dza naꞌte. Porque chi binaoyaquëꞌ con cabëꞌ rna lëꞌë guichi ley naꞌ, biyeziꞌ Diuzi leyaquëꞌ yeyoyaquëꞌ guibá dza gatiyaquëꞌ. ―Canaꞌ unayaquëꞌ gudyijëꞌ lejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Quie lenaꞌ legazi uyuꞌu Pablo len Bernabé huenë len leyaquëꞌ. Pues como bibegaꞌnjëꞌ de acuerdo, naꞌra entre yaca benꞌ nao xneza Jesús nitaꞌ naꞌ, bëyaquëꞌ nombrar Pablo len Bernabé len ichopa tzona benꞌ tzio ciudad Jerusalén tacuenda hueꞌjëꞌ diꞌidzaꞌ conlë ja apóstol len yaca benꞌ belao quie yaca benꞌ nao xneza Jesús nitaꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Naꞌra yaca benꞌ nao xneza Jesús nitaꞌ ciudad Antioquía useꞌelaꞌyaquëꞌ lejëꞌ uzaꞌyaquëꞌ udeyaquëꞌ ja ciudad nebaba Fenicia len ja ciudad nebaba Samaria. Naꞌra tu tu ciudad ga udeyaquëꞌ udixogueꞌyaquëꞌ leyaquëꞌ cabëꞌ rue yaca benꞌ binaca benꞌ Israel barsanlaꞌadyiꞌyaquëꞌ costumbre quie xuzixtaꞌoyaquëꞌ, barnaoyaquëꞌ xneza Jesús. Naꞌra quie lenaꞌ, legazi redaohue yaca benꞌ nao xneza Jesús nitaꞌ ja ciudad ga udeyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Caora bedyinyaquëꞌ ciudad Jerusalén, pues yaca apóstol, len yaca los demás benꞌ nao xneza Jesús, len yaca benꞌ napa dyin quieyaquëꞌ, bgapajëꞌ leyaquëꞌ diuz̃i. Naꞌra bdzeꞌ Pablo len Bernabé diꞌidzaꞌ yugulu con cabëꞌ bë Diuzi gucalënëꞌ leyaquëꞌ ga udixogueꞌjëꞌ benëꞌ con cabëꞌ rna xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero naꞌ uzuli bala benꞌ nao xneza Jesús, benꞌ nacarë quie partido fariseo. Naꞌra nu benꞌ naca partido fariseo, legazi rnaoyaquëꞌ guichi ley pcaꞌn Diuzi lao naꞌa Moisés. Quie lenaꞌ unayaquëꞌ rëbiyaquëꞌ yaca los demás benꞌ nao xneza Jesús cani: ―Yugu benꞌ binaca benꞌ Israel, yaca benꞌ nao xneza Jesús, reyaꞌalaꞌ uzu tu xëdyidaoꞌ cuinyaquëꞌ. Lëzi reyaꞌalaꞌ huero mandado huejëꞌ cumplir con ca rna lëꞌë guichi ley pcaꞌn Diuzi lao naꞌa Moisés. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Naꞌra bedupa yaca apóstol len yaca benꞌ napa dyin quie benꞌ nao xneza Jesús tacuenda hueyaquëꞌ pensari con cabëꞌ una yaca benꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Caora naꞌ legazi uyuꞌuyaquëꞌ huenë. Cati beyudyi naꞌ, naꞌra uzuli Pedro rëbinëꞌ leyaquëꞌ: ―Bichaꞌ, dyëꞌëdi nezile de que dza naꞌte ulio Diuzi nëꞌëdiꞌ de entre raꞌo ta quixoguiꞌa benꞌ binaca benꞌ Israel xtiꞌidzaꞌ Diuzi, porque lëscanꞌ reꞌen Diuzi inaoyaquëꞌ xnezëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nezi Diuzi bitezi pensari raca yugo benëꞌ. Quie lenaꞌ bzioñeꞌenëꞌ leyaquëꞌ de que zuëꞌ dispuesto yeziꞌnëꞌ leyaquëꞌ. Naꞌ biz̃i baꞌalaꞌcazi binacajëꞌ benꞌ Israel, bdzeꞌnëꞌ Bichi Be quienëꞌ luꞌu guicho laxtaꞌoyaquëꞌ laga ca bdzeꞌnëꞌ Bichi Be quienëꞌ luꞌu guicho laxtaꞌoro. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Como tuzi rue Diuzi len leyaquëꞌ len raꞌo, aodibi Diuzi laxtaꞌoyaquëꞌ nun quie barue quieyaquëꞌ xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Naꞌa ¿bixquienꞌ racale pensari binezi Diuzi bi bënëꞌ? Pues ni raꞌo ni xuzixtaꞌoro bibëro gan inaoro duz̃e guichi ley pcaꞌn Diuzi lao naꞌa Moisés. Naꞌra ¿bixquienꞌ, pues, reꞌenle inao yaca benꞌ binaca benꞌ Israel ley quiero? Lenaꞌ nacan ca quie chi uguaꞌaroyaquëꞌ yuaꞌ ziꞌi, tu ta bisuejëꞌ huaꞌayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Biz̃i dyëꞌëdi neziro de que laga cabëꞌ ute usela Señor Jesús quiero por yelaꞌ benꞌ huen quienëꞌ, lëscanꞌ ute usela Jesús yaca benꞌ binaca benꞌ Israel, yaca benꞌ rue quie xtiꞌidzëꞌ. ―Canaꞌ una Pedro gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Naꞌra uzulao Bernabé len Pablo ruꞌeyaquëꞌ diꞌidzaꞌ con cabëꞌ gucalë Diuzi leyaquëꞌ bëyaquëꞌ nu yelaꞌ milagro lao benꞌ binacaja benꞌ Israel. Quie lenaꞌ unitaꞌ yaca benꞌ naꞌ chizi yugutejëꞌ rzënagayaquëꞌ con cabëꞌ una Bernabé len Pablo. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pues beyudyi bëꞌyaquëꞌ diꞌidzaꞌ naꞌ, naꞌra una Santiago rëbinëꞌ leyaquëꞌ: ―Bichaꞌ, uzëcara nagale quiaꞌ. Pues agudyi ");
INSERT INTO zpcNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro raꞌo de que babdyin hora cuio Diuzi entre ja benꞌ binaca benꞌ Israel nu benꞌ reꞌen gaca benꞌ quienëꞌ galeyaquëꞌ xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Lenaꞌ nacan de acuerdo con cabëꞌ una ja benꞌ gula, benꞌ udixogueꞌ xtiꞌidzaꞌ Diuzi dza naꞌ. Lenaꞌ rnën lëꞌë guichi quie Diuzi cani: ");
INSERT INTO zpcNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Cabëꞌ rue yaca benëꞌ, reyueyaquëꞌ recubiyaquëꞌ yedyi quieyaquëꞌ, canaꞌ hueriaꞌ conlë yaca benꞌ Israel. Huadyin dza gacaliaꞌ yaca benꞌ Israel ta yenaoyaquëꞌ xnezaꞌ tatula cabëꞌ unao xuzixtaꞌoyaquëꞌ xnezaꞌ dza uda rey David lao yedyi layu. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Canaꞌ huaꞌ tacuenda inaorë yaca los demás benꞌ binaca benꞌ Israel xnezaꞌ, lente yugu benꞌ naca benꞌ laꞌiya quiaꞌ, benꞌ rzëto laohuaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Canaꞌ una Diuzi bzioñeꞌenëꞌ raꞌo. Desde dza naꞌte unëꞌ udixogueꞌnëꞌ xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Naꞌra nernë Santiago rëbinëꞌ leyaquëꞌ: ―Quie lenaꞌ niaꞌ bireyaꞌalaꞌ huero zëdi benꞌ binacaja benꞌ Israel, benꞌ psanja pensari gula quiejëꞌ barnaojëꞌ xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tuzi ca reyaꞌalaꞌ huero iseꞌelaꞌro tu guichi ta quixogueꞌroyaquëꞌ bireyaꞌalaꞌ gaoyaquëꞌ bëꞌëlaꞌ bdyia benëꞌ lao ruꞌaba ta bëꞌyaquëꞌ ídolo quieyaquëꞌ. Lëzi bireyaꞌalaꞌ gaoyaquëꞌ bëꞌëlaꞌ quie nu bia bibro ren hora gutibaꞌ. Lëscanꞌ, con nutezi bia guixiꞌ, bireyaꞌalaꞌ gaoyaquëꞌ ren quiebaꞌ. Lëzi bireyaꞌalaꞌ gatalëyaquëꞌ nigula binaca z̃gulayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Canaꞌ reꞌennan hueja benꞌ binacaja benꞌ Israel, benꞌ barnaoja xneza Diuzi tacuenda biudzeꞌlaꞌadyiꞌ ja benꞌ Israel, porque desde tiempote uzucazi ja benꞌ nao ley pcaꞌn Moisés. Quie quie yedyi quiero nitaꞌ yaca benꞌ Israel rulabajëꞌ guichi ley naꞌ luꞌu sinagoga yugu dza saodo. ―Canaꞌ una Jacobo gudyinëꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Naꞌra ja apóstol, len yaca benꞌ napa dyin quie benꞌ nao xneza Jesús, len los demásyaquëꞌ, psaqueꞌyaquëꞌ cabëꞌ huejëꞌ ta cuioyaquëꞌ entre leyaquëꞌ benꞌ tziolë Pablo len Bernabé ciudad Antioquía. Quie lenaꞌ ulioyaquëꞌ tu benꞌ lao Judas Barsabás, len itunëꞌ laonëꞌ Silas. Nacayaquëꞌ benꞌ balaꞌana entre ja benꞌ nao xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Naꞌra lëscanꞌ bëyaquëꞌ tu guichi ta nuꞌayaquëꞌ. Lëꞌë guichi naꞌ rnën cani: “Nëtoꞌ, yaca apóstol len yaca los demás benꞌ napa dyin entre yaca benꞌ nao xneza Jesús, rgapandoꞌ diuz̃i leꞌe como benꞌ bichindoꞌ, benꞌ barnao xneza Jesús. Baoseꞌelaꞌndoꞌ guichi ni lao leꞌe benꞌ binaca benꞌ Israel, benꞌ nitaꞌ ciudad Antioquía, len leꞌe benꞌ nitaꞌ yedyi nebaba Siria, len leꞌe benꞌ nitaꞌ yedyi nebaba Cilicia. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Banezindoꞌ babida chopa tzona benꞌ uzaꞌ yedyi ni badeyubiyaquëꞌ leꞌe ta hueꞌlëyaquëꞌ leꞌe diꞌidzaꞌ, pero ca bëyaquëꞌ pquixiyaquëꞌ pensari quiele bëyaquëꞌ leꞌe zëdi. Pero cala nëtoꞌ useꞌelaꞌndoꞌyaquëꞌ, dechanꞌ ta racazi laꞌadyiꞌjëꞌ bëjëꞌ canaꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Quie lenaꞌ gucandoꞌ de acuerdo, uliondoꞌ de entre nëtoꞌ chopa benꞌ guidalë bichiro Pablo len bichiro Bernabé ideyubiyaquëꞌ leꞌe inayaquëꞌ leꞌe ca naca pensari quiendoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Naca Pablo len Bernabé benꞌ uyocazi ja ciudad tula tanun quie Señor quiero Jesucristo ga ruenan z̃udyi guti ja benëꞌ lejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Lëscanaꞌ useꞌelaꞌndoꞌ Judas len Silas ta uxiꞌidzeꞌyaquëꞌ leꞌe yugulu cabëꞌ naca pensari quiendoꞌ niga. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Naꞌra según pensari quie Bichi Be quie Diuzi len pensari quiendoꞌ, nacan huen bihuendoꞌ mandado inaole duz̃e ley quie Moisés. Ca rnandoꞌ leꞌe niga, canaꞌzi nacan zi quiele huele. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Pues bireyaꞌalaꞌ gaole bëꞌëlaꞌ bdyia benëꞌ ruꞌaba ta bëꞌyaquëꞌ ídolo quieyaquëꞌ. Lëzi bigaole bëꞌëlaꞌ quie nu bia bibro ren hora gutibaꞌ. Lëscanꞌ con nutezi bia guixiꞌ, bireyaꞌalaꞌ gaole ren quiebaꞌ. Lëzi bireyaꞌalaꞌ gatalële nigula binaca z̃gulale. Chi hue quiele uzule diꞌidzaꞌ ca nandoꞌ leꞌe niga, canaꞌ huele ta yuꞌu niꞌa xnezi. Naꞌ yugu dza rulidzandoꞌ Diuzi gacalënëꞌ leꞌe.” Canaꞌ unën lëꞌë guichi naꞌ ta useꞌelaꞌyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pues canaꞌ guca uzaꞌyaquëꞌ zioyaquëꞌ ciudad Antioquía ptupayaquëꞌ yaca benꞌ nao xneza Jesús, bëꞌyaquëꞌ leyaquëꞌ guichi nuꞌayaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Naꞌra cati bablabayaquëꞌ guichi naꞌ, legazi bedaohueyaquëꞌ con cabëꞌ diꞌidzaꞌ z̃elaꞌadyiꞌ rnën lëꞌë guichi naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Naꞌra como Judas len Silas nacarëyaquëꞌ benꞌ rguixogueꞌ xtiꞌidzaꞌ Diuzi, hora naꞌ bëꞌlëyaquëꞌ leyaquëꞌ diꞌidzaꞌ z̃elaꞌadyiꞌ mazera. Naꞌra nun quie diꞌidzaꞌ unayaquëꞌ gucalëyaquëꞌ leyaquëꞌ ta inaorayaquëꞌ dulaꞌadyiꞌjëꞌ xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Biz̃i naꞌ caora baguca zidza zuyaquëꞌ ciudad naꞌ, bë yaca benꞌ quie Jesús tu despedida ta yezaꞌyaquëꞌ yedyinyaquëꞌ ciudad ga nitaꞌ ja benꞌ useꞌelaꞌ leyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero Silas psaqueꞌnëꞌ yegaꞌnnëꞌ ciudad Antioquía. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Lëzi begaꞌnrë Pablo len Bernabé ciudad naꞌ. Naꞌra leyaquëꞌ len yaca los demás benꞌ quie Jesús, udixogueꞌyaquëꞌ benëꞌ con cabëꞌ rna xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pues caora baode tu tiempo, una Pablo rëbinëꞌ Bernabé: ―Yaꞌ tzioro tatula tzeyubiro ja bichiro nitaꞌ yugu ciudad con ga udero udixogueꞌro yaca benëꞌ con cabëꞌ rna xtiꞌidzaꞌ Diuzi dza naꞌ. Tzioro tzenaꞌro bi raca quiejëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Pues naꞌra guꞌun Bernabé iquiëꞌyaquëꞌ Juan Marcos, ");
INSERT INTO zpcNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","pero Pablo naꞌ biguꞌunnëꞌ, porque danꞌ psanlaꞌadyiꞌ Juan leyaquëꞌ dza uyoyaquëꞌ yaca yedyi nebaba Panfilia. Biuyolënëꞌ leyaquëꞌ ta tzetixogueꞌyaquëꞌ benëꞌ con cabëꞌ rna xtiꞌidzaꞌ Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tantozi uyuꞌuyaquëꞌ huenë naꞌ, uzaꞌyaquëꞌ quie quieyaquëꞌ. Naꞌra uquiëꞌ Bernabé Marcos uzaꞌyaquëꞌ zioyaquëꞌ isla Chipre. ");
INSERT INTO zpcNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pero Pablo, por tu partela, ulionëꞌ Silas benꞌ tziolë lëbëꞌ. Naꞌra bëꞌ beyudyi blidza benꞌ nao xneza Jesús Diuzi ta gacalënëꞌ Pablo len Silas con ga tzioyaquëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","caora naꞌ uzaꞌyaquëꞌ zioyaquëꞌ yedyi ga nebaba Siria len yedyi ga nebaba Cilicia. Con ga udeyaquëꞌ mazera bëꞌyaquëꞌ benꞌ nao xneza Jesús diꞌidzaꞌ z̃elaꞌadyiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Naꞌra bedyin Pablo len Silas ga reꞌ ciudad Derbe len ciudad Listra. Naꞌ yexacayaquëꞌ tu benꞌ lao Timoteo naquëꞌ benꞌ quie Jesús. Naca z̃naꞌnëꞌ benꞌ Israel, lëzi nacarënëꞌ benꞌ nao xneza Jesús. Naca xuzinëꞌ benꞌ griego. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Rna ja benꞌ nao xneza Jesús nitaꞌ ciudad Listra, len benꞌ nao xneza Jesús nitaꞌ ciudad Iconio, de que naca Timoteo benꞌ dyaꞌa gula. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Caora naꞌ guꞌun Pablo uquiëꞌnëꞌ Timoteo, pero como nitaꞌ zë benꞌ Israel ganꞌ tzioyaquëꞌ, lëscanꞌ como nezi yaca benꞌ Israel binaca xuzi Timoteo benꞌ Israel, quie lenaꞌ bzu Pablo tu xëdyidaoꞌ Timoteo tacuenda biudzeꞌlaꞌadyiꞌ ja benꞌ Israel nitaꞌ ja ciudad ga tzioyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Naꞌra uzaꞌyaquëꞌ zioyaquëꞌ. Pero tu tu ciudad ga udeyaquëꞌ udixogueꞌyaquëꞌ benꞌ nao xneza Jesús nitaꞌja naꞌ con cabëꞌ una yaca apóstol len benꞌ napa dyin caora bëjëꞌ junta ciudad Jerusalén. Lëscanꞌ gudyijëꞌ lejëꞌ ta uzujëꞌ diꞌidzaꞌ ca diꞌidzaꞌ una yaca benꞌ bë junta. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Pues canaꞌ guca quie benꞌ quie Jesús nitaꞌ ga udejëꞌ, uz̃elaꞌadyiꞌyaquëꞌ naoyaquëꞌ xneza Jesús du guicho du laꞌadyiꞌjëꞌ. Quie lenaꞌ uyera mazera benꞌ nao xneza Jesús tu dza tu dza. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pues como bibëꞌ Bichi Be quie Diuzi lato quixogueꞌyaquëꞌ benꞌ nitaꞌ yaca ciudad nebaba Asia con cabëꞌ rna xtiꞌidzaꞌ Diuzi, uzaꞌyaquëꞌ udeyaquëꞌ yaca ciudad nebaba Frigia len yaca ciudad nebaba Galacia ");
INSERT INTO zpcNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","hasta bdyinyaquëꞌ ga beyudyi yu nebaba Misia. Hora naꞌ guꞌunyaquëꞌ tziorayaquëꞌ mazera ta idyinyaquëꞌ yaca ciudad nebaba Bitinia, pero lëzi bibëꞌ Bichi Be quie Diuzi lato. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Quie lenaꞌ bezaꞌyaquëꞌ bedeyaquëꞌ yu nebaba Misia bedyinyaquëꞌ ciudad Troas. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Caora naꞌ ca du rëla, uxusa Pablo blëꞌënëꞌ tu benꞌ Macedonia zënëꞌ rnabayëchiꞌnëꞌ rëbinëꞌ lëbëꞌ: “Naguidoꞌ Macedonia ga zundoꞌ tacuenda gacalaoꞌ nëtoꞌ.” ");
INSERT INTO zpcNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Hora naꞌ ude beyudyi blëꞌë Pablo con cabëꞌ uxusanëꞌ, naꞌra labëteyaquëꞌ puesto quieyaquëꞌ ta tzioyaquëꞌ Macedonia. Lëzi nëꞌëdiꞌ, Lucas, uyaliaꞌ leyaquëꞌ. Nacaꞌ benꞌ bzu diꞌidzaꞌ lëꞌë guichi ni. Naꞌra con cabëꞌ uxusa Pablo, lenaꞌ unezindoꞌ de que reꞌen Diuzi tziondoꞌ tzetixogueꞌndoꞌ benꞌ Macedonia con cabëꞌ rna xtiꞌidzëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Naꞌra uzaꞌndoꞌ ciudad Troas con luꞌu barco ziondoꞌ tu li ta idyinndoꞌ isla Samotracia. Caora beteyu dza tula bdyinndoꞌ ciudad Neápolis. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Naꞌra uzaꞌndoꞌ ziondoꞌ ciudad Filipos. Pues ciudad Filipos nacan yedyi belaora quie ja ciudad nebaba Macedonia. Pues nitaꞌ casi puro benꞌ romano ciudad naꞌ. Naꞌra begaꞌnndoꞌ naꞌ chopa tzona dza. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Biz̃i guca tu dza saodo naꞌ uzaꞌndoꞌ ziondoꞌ tu ruꞌa yao z̃e de ruꞌa yedyi naꞌ. Lëlugar naꞌ nacan ga rio ja benꞌ Israel ruꞌelëyaquëꞌ Diuzi diꞌidzaꞌ. Naꞌra ureꞌndoꞌ naꞌ uzulaondoꞌ rguixogueꞌndoꞌ con cabëꞌ rna xtiꞌidzaꞌ Diuzi lao ja nigula bdupayaca naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Naꞌra entre ja nigula naꞌ ureꞌ tunëꞌ laonëꞌ Lidia. Naquëꞌ benꞌ ciudad Tiatira. Naquëꞌ benꞌ rutiꞌ laꞌariꞌ tzaꞌo, laꞌariꞌ culuri morado. Lëzi naquëꞌ benꞌ rionlaꞌadyiꞌ Diuzi. Naꞌra bdzeꞌ Diuzi lëbëꞌ pensari ta hue quienëꞌ con cabëꞌ rna diꞌidzaꞌ ruꞌe Pablo rëbinëꞌ leyaquëꞌ. Canaꞌ uzulaonëꞌ inaonëꞌ xneza Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Caora naꞌ bëꞌyaquëꞌ laonëꞌ lente yaca familia quienëꞌ. Pues beyudyi naꞌ, unëꞌ nëtoꞌ du laꞌadyiꞌnëꞌ: ―Chi psaqueꞌle de que tali banacaꞌ benꞌ rnao xneza Jesús, guidale sule z̃an yuꞌu quiaꞌ chopa tzona dza. Naꞌra canaꞌ guca quiendoꞌ, begaꞌnndoꞌ lidyinëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Pues bdyin hora tatula ziondoꞌ ga naca lugar ruendoꞌ orar. Pero du tu neza yetilandoꞌ tu niguladaoꞌ yuꞌubiꞌ taxiꞌibiꞌ. Naꞌra conlë taxiꞌibiꞌ ruebiꞌ divinar. Lëzi nacabiꞌ biꞌ nadaꞌo, biꞌ rue dyin sin laz̃u. Pues como ruebiꞌ divinar quie benëꞌ, legazi ruebiꞌ gan dumi z̃e para quie ja xaꞌmbiꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Naꞌra uzulao nigula naobiꞌ nëtoꞌ ga ziondoꞌ rnëbiꞌ zidzo rëbibiꞌ benꞌ nitaꞌ ciudad naꞌ: ―Yaca benꞌ ni rueyaquëꞌ mandado quie tuzi Diuzi zu sibi. Rguixogueꞌyaquëꞌ benëꞌ con cabëꞌ rna xtiꞌidzaꞌ Diuzi ta hue quieyaquëꞌn ta yeyoyaquëꞌ guibá dza gatiyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Naꞌra canaꞌ guca bazio zëdza nao niguladaoꞌ nëtoꞌ ga riondoꞌ hasta que bdyin dza bdzaꞌ Pablo lëbiꞌ. Caora naꞌ beyëchonëꞌ unëꞌ rëbinëꞌ taxiꞌibiꞌ yuꞌubiꞌ: ―Rzëtogaꞌ lao Jesucristo, yeroloꞌ ganꞌ yuꞌuloꞌ. Pues caora naꞌtezi laberote taxiꞌibiꞌ yuꞌu niguladaoꞌ naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero cati blëꞌë yaca xanꞌ nigula de que bira saqueꞌ hueyaquëꞌ gan dumi por lëbiꞌ, caora naꞌ bëxoyaquëꞌ Pablo len Silas, uquiëꞌyaquëꞌ lejëꞌ yulaoꞌ ga reꞌ yaca benꞌ rnabëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Naꞌra psedyinyaquëꞌ lejëꞌ lao yaca juez unayaquëꞌ rëbiyaquëꞌ ja juez: ―Yaca benꞌ ni nacayaquëꞌ benꞌ Israel. Rdayaquëꞌ rguiloyaquëꞌ huedila lao yedyi quiero niga. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Reꞌenyaquëꞌ siꞌro inaoro cabëꞌ naca pensari quiejëꞌ, pero biruꞌen lato inaoro xneza quieyaquëꞌ, porque danꞌ nacaro benꞌ romano. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Naꞌra yaca benꞌ yedyi naꞌ, bdzaꞌtzegueyaquëꞌ Pablo len Silas. Hora naꞌ bë ja juez mandado ilëcho policía z̃abajëꞌ tacuenda quiyaquëꞌ lejëꞌ con bara. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Beyudyi uditzagueyaquëꞌ lejëꞌ con bara, bdzeꞌyaquëꞌ lejëꞌ luꞌu dyiguiba, gudyiyaquëꞌ benꞌ rapa dyiguiba ta gapëꞌ lejëꞌ dyëꞌëdi. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Quie lenaꞌ uquiëꞌ benꞌ rapa dyiguiba lejëꞌ guichote ga beyudyite dyiguiba, bdzeꞌnëꞌ niꞌajëꞌ luꞌu yëro dyia chopa yaga taꞌa ta resiotejëꞌ con candado. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Naꞌ cadu gatzo yëla reꞌ Pablo len Silas rueyaquëꞌ orar rulayaquëꞌ alabanza quie Diuzi, pero yaca los demás preso deyaquëꞌ rzënagayaquëꞌ cabëꞌ rula Pablo len Silas. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Pues caora naꞌ tu sasazi, ben tu uz̃uꞌ huala gula bzisin dyiguiba. Dyin quie uz̃uꞌ naꞌ, uyalo yugu puerta quie dyiguiba. Lëzi yugu caden naꞌ nario ja preso beyedyijan bguinojan layu. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Cati udëlebë benꞌ rapa dyiguiba, blëꞌënëꞌ nayalo ja puerta quie dyiguiba. Caora naꞌ ulëchonëꞌ espada quienëꞌ ta yeyutinëꞌ cuinnëꞌ, porque guquenëꞌ baola yaca preso de ja naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Hora naꞌ unë Pablo zidzo gudyinëꞌ lëbëꞌ: ―Bibi tamala hueloꞌ quioꞌ, porque nicazi nitaꞌndoꞌ yugundoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Naꞌra unaba benꞌ rapa dyiguiba guiꞌ zionëꞌ tariara uyuꞌunëꞌ luꞌu dyiguiba. Tantozi rdzebinëꞌ zionëꞌ uditzu z̃ibinëꞌ laojëꞌ, ");
INSERT INTO zpcNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ulionëꞌ Pablo len Silas ga dejëꞌ unëꞌ rëbinëꞌ lejëꞌ: ―Señores, ¿biz̃i ca reyaꞌalaꞌ huaꞌ ta yeyëri laxtaꞌohuaꞌ lao Diuzi? ");
INSERT INTO zpcNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Naꞌra bequëbijëꞌ rëbijëꞌ lëbëꞌ: ―Reyaꞌalaꞌ hue quioꞌ xtiꞌidzaꞌ Señor Jesús. Canaꞌ yeyëri laxtaꞌoloꞌ lao Diuzi, canaꞌ yeyëri laxtaꞌo familia quioꞌ lao Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pues udixogueꞌjëꞌ lëbëꞌ lente yugu yaca familia quienëꞌ nitaꞌja naꞌ con cabëꞌ rna xtiꞌidzaꞌ Señor Jesús. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lëzi yëla naꞌtezi hora naꞌ, udibi benꞌ rapa dyiguiba ga naca Pablo len Silas hueꞌ. Naꞌra bëꞌyaquëꞌ lao benꞌ rapa dyiguiba lente yugo familia quienëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Beyudyi naꞌ uquiëꞌnëꞌ Pablo len Silas lidyinëꞌ ga bgaonëꞌ leyaquëꞌ. Hora naꞌ lëbëꞌ lente yugo familia quienëꞌ, legazi redaohueyaquëꞌ, porque danꞌ barnaojëꞌ xneza Diuzi. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pero caora uyeniꞌ zila naꞌ, useꞌelaꞌ yaca juez policía gan zë benꞌ rapa dyiguiba gudyiyaquëꞌ lëbëꞌ ta yebionëꞌ Pablo len Silas luꞌu dyiguiba. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Caora naꞌ unë benꞌ rapa dyiguiba rëbinëꞌ Pablo: ―Ablaꞌ diꞌidzaꞌ quie ja juez naꞌ reꞌenyaquëꞌ yebiogaꞌ leꞌe. Pues naꞌ yerole dyëꞌëdi, yeyole huen. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero una Pablo gudyinëꞌ lejëꞌ: ―Nëtoꞌ banacandoꞌ cuenda quie ciudad Roma. Según ley quie benꞌ romano, biruꞌen lato quiyaquëꞌ nëtoꞌ udzeꞌyaquëꞌ nëtoꞌ dyiguiba sin nica negacazi justicia quiendoꞌ. ¿Cómo pues bareꞌenyaquëꞌ yebioyaquëꞌ nëtoꞌ nagachiꞌzi? ¡Pues bisaqueꞌ usacayaquëꞌ nëtoꞌ canaꞌ! Ni cuezandoꞌ hasta que guidayaquëꞌ cuinyaquëꞌ yebioyaquëꞌ nëtoꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Naꞌra hora naꞌ uyo ja policía yeguëdyiyaquëꞌ yaca juez con ca una Pablo. Pues cati unezi yaca juez de que naca Pablo len Silas cuenda quie ciudad Roma, lenaꞌ legazi bdzebigaziyaquëꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Caora naꞌ uyo yaca juez ganꞌ de Pablo len Silas yeguëdyijëꞌ lejëꞌ ta yeziꞌz̃e Pablo len Silas quieyaquëꞌ. Canaꞌ guca bebioyaquëꞌ lejëꞌ luꞌu dyiguiba. Naꞌ unabayëchiꞌjëꞌ lejëꞌ ta yezaꞌjëꞌ yerojëꞌ ciudad naꞌ. ");
INSERT INTO zpcNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pues bëꞌ beroyaquëꞌ dyiguiba naꞌ, zioyaquëꞌ yeyu