﻿USE sofia;
DROP TABLE IF EXISTS sofia.zosNT_vpl;
CREATE TABLE zosNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zosNT_vpl WRITE;
INSERT INTO zosNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yøn lista vi'nata'mbø pø'nis chacyajupø 'yune jutipø'omo pø'naj Jesucristo. Davijdis y Abraha'mis chacyajupø 'yune'omo pø'naj Jesucristo. ");
INSERT INTO zosNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Oy Abraha'mis 'yune Isaac y Isaajquis 'yune Jacob, y oy Jacojbis 'yune Judá, y ityajque'tuti Juda'is 'yatzi y myuqui. ");
INSERT INTO zosNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Oyaj Juda'is 'yune Fares y Zara; y Zara'is myama Tamar. Oy Faresis 'yune Esrom y Esro'mis 'yune Aram. ");
INSERT INTO zosNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Oyajque't Ara'mis 'yune Aminadab, y Aminadajbis 'yune Naasón, Naaso'nis 'yune Salmón, ");
INSERT INTO zosNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmo'nis 'yune Booz; y Boosis myama Rahab. Entonces oy Boojsis 'yune Obed y Obejdis myama Rut. Ocye't Obejdis 'yune Isaí, ");
INSERT INTO zosNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","y Isai'is 'yune aṉgui'mba David, Davijdis 'yune Salomón, y Salomo'nis myama Uriasisna'ṉe yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Entonces oy Salomo'nis 'yune Roboam, Roboa'mis 'yune Abías, Abiasis 'yune Asa. ");
INSERT INTO zosNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa'is 'yune Josafat, Josafajtis 'yune Joram, Jora'mis 'yune Uzías, ");
INSERT INTO zosNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziajsis 'yune Jotam, Jota'mis 'yune Acaz, Acasis 'yune Ezequías, ");
INSERT INTO zosNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiasis 'yune Manasés, Manasesis 'yune Amón, Amo'nis 'yune Josías. ");
INSERT INTO zosNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiasis 'yune Jeconías; y ityajque'tuti Jeconiasis myuqui jic tiempo cuando obligado ñømaṉyajtøj Israel pønda'm Balilonia nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Y jøsicam cuando jena'ṉ ityaju'c Babilonia nasomo, oy Jeconiasis 'yune Salatiel, y Salatiejlis 'yune Zorobabel, ");
INSERT INTO zosNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabejlis 'yune Abiud, Abiujdis 'yune Eliaquim, Eliaqui'mis 'yune Azor, ");
INSERT INTO zosNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azojris 'yune Sadoc, Sadojquis 'yune Aquim, y Aqui'mis 'yune Eliud, ");
INSERT INTO zosNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliujdis 'yune Eleazar, Eleasaris 'yune Matán, y Mata'nis 'yune Jacob. ");
INSERT INTO zosNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Y Jacojbis 'yune José; y José Maria'is jyaya, y María Jesusis myama, Jesús ñøjayajpapø Cristo Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Así que desde Abraham hasta David it catorce nac oy vi'na pø'nis 'yune. Oy 'yune'is 'yune, y entonces je 'yune'is 'yune hasta ta'n catorce nac. Y desde David hasta que nømaṉyajtøju Babilonia nasomo itque't catorce nac oy vi'napø pø'nis 'yune'is 'yune, y eyapa catorce nac hasta que pø'naj Cristo. ");
INSERT INTO zosNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cuando maṉba'cna'ṉ pø'naj Jesucristo, yø'cse o tucnømi: ijtuna'ṉ myama Maria'is cyompromiso Joseji'ṉ para que va'cø cyo'tøjcajyajø. Pero antes quena'ṉ va'c ityaj tyumø'omo, min chi'yaj cuenta que ji'ndame tyumbø María; pero Masanbø Espiritu Santo'is milagropit oy une pa'te. ");
INSERT INTO zosNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Como jyaya José tum pøn siempre chøcpapø'is vøjpø tiyø, qui'psu va'cø yaj cyompromiso Mariaji'ṉ; pero va'cø ñu'mdzacø, va'cø jana syijcatyøj María. ");
INSERT INTO zosNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mientras que jetsena'ṉ nø qui'psu, Jose'is cyønapasyi'øy tum angeles ndø Comi Diosis cyø'vejupø, y aṉgelesis ñøjayu: ―José; mitz Davijdis mi 'yune: U mi ña'ṉdzu va'cø mi mbøjcøchoṉ María como mi yomo, porque je une maṉbapø isi, Masanbø Espiritu Santo'ise milagropit maṉba isi. ");
INSERT INTO zosNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Y je maṉba is une, maṉba mi yac nøyi'aj JESUS. Y jetse ñøyi porque maṉbapø yaj cotzocyaj cyojapit ñe pyøn. ");
INSERT INTO zosNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Y cuando jetse tujcu, viyu'ṉaju lo que chamuse tza'maṉvajcopapø pø'nis ndø Comi Diosis chi'use qui'psocuy va'cø chamø. Y lo que chamuse, viyu'ṉaju. Ndø Comi Dios nømu: ");
INSERT INTO zosNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Je papiñomo ji'name tyumbø, y maṉba is une. Y maṉba ñøyi'aj Emanuel. Y je palabra Emanuel nømbapøte: que Dios tø øtzji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Y José mø'ṉdonsa'u ñapasyi'omo, y chøjcu lo que ndø Comi Diosis 'yaṉgelesis chajmayuse, y ñøtøjcøy María tyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero ja ñø'itøtøcna'ṉ como yomose hasta que is Maria'is vi'na pønbø 'yune, y cyojtayaj ñøyi JESUS. ");
INSERT INTO zosNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús pø'naj tum cumgu'yomo ñøyipø'is Belén, Judea nasombø cumguy cuando Herodes Judea nasombø aṉgui'mba. Entonces nu'cyaj Jerusalén cumgu'yomo pøn tzu'ṉyajupø jama qui'mgucyøsi, y matza 'ya'myajpapø'is. ");
INSERT INTO zosNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Y cyø'ocvacyaju je'is: ―¿Jut it jic Israel pø'nis 'yaṉgui'mbata'm jic pø'najupøtøc? Porque jama qui'mgucyøsi isatyam je'is myatza, y mindamupøm chønø yø'qui va'cø ṉgujnejatyamø va'cø ṉgøna'tzøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pero cuando aṉgui'mbapø Herodesis myusu que pø'naj eyapø aṉgui'mba, entonces hasta jujchese tujcu; y mumu pøn jic Jerusale'nombø'is jetseti o'ca jujchese tucyajque'tu. ");
INSERT INTO zosNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Entonces jic aṉgui'mba'is vyejayaj pane'is cyovi'najøta'm y lo que 'yaṉmayajpapø'sna'ṉ Israel pø'nis 'yaṉgui'mgutya'm, y 'yocva'cyaju aṉgui'mba'is jujna'ṉ ma pø'naj Cristo. ");
INSERT INTO zosNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Entonces je'is 'yaṉdzoṉyaju ñøjayaju: ―Maṉba pø'naje Bele'ṉomo, Judá nasombø cumgu'yomo, porque jetse jachø'y cha'maṉvacpapø'is Diosis 'yote, porque jyay yø'cse: ");
INSERT INTO zosNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Y mitz Belén gumguy pønda'm Judea nasomda'mbø, ji'n menos mi 'yaṉgui'mi que eyata'mbø covi'najø Judea nasomo. Porque mi ṉgumgu'yomo mijtzaṉgø'm it más ijtu'is aṉgui'mguy, maṉba'is 'ya'm ø ṉgumguy Israel. Jetse jyay cha'maṉvacpapø'is. ");
INSERT INTO zosNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Entonces Herodesis ñu'mvejayaj matza 'ya'myajpapø'is y 'yocva'cyaju mero jujchøc quejtzo'tz matza. ");
INSERT INTO zosNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Entonces Herodesis cyø'vejyaju matza 'ya'myajpapø'is Belén gumgu'yomo, y ñøjayaju: ―Maṉdam jiṉø, y cø'ocvactam vøjø jic une. Y cuando mi mba'jtamba, tø tzajmatyamø, va'cø maṉgue'tati øjtzi va'cø maṉ ṉgujnejacye'ta. ");
INSERT INTO zosNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Cyøma'nøyaju'cam je aṉgui'mba, maṉyaj matza 'ya'myajpapø'is. Y isyaju jama qui'mgucyøsi matza vi'najpa maṉu hasta que ijtumø je une, y jen te'ṉdzø'yu. ");
INSERT INTO zosNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Cuando jic pø'nis isyaj matza, tzi'ṉbø'yaj vøti. ");
INSERT INTO zosNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Cuando nømna'ṉ cya'ṉdøjcøyaj tøjcomo, isyaj une myama Mariaji'ṉ. Entonces cutquecyaju y vya'ṉjamyaju je une. Luego 'yaṉvacyaj cyaja y vyactzi'yaj oro y pomo y suñi viquicpapø perfume. ");
INSERT INTO zosNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Y jøsicam Diosis chajmayaj cyønapasyi'omo que va'cø jana vitu'yaj ijtumø Herodes; por eso eyapø tu'ṉom vitu'yaju para va'cø ñu'cyaj ñasomda'm. ");
INSERT INTO zosNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Y maṉyaju'cam jic 'ya'myajpapø'is matza, ndø Comi Diosis 'yaṉgeles cyønapasyi'øy Jose'is. Y aṉgelesis ñøjayu: ―Te'nchu'ṉø y pøc yøṉ une myamaji'ṉ y maṉ Egipto nasomo hasta que øtz mi nøjambacsye'ṉomo. Porque Herodesis mapø mye'tz je une para que va' yaj ca'ø. ");
INSERT INTO zosNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Entonces te'nchu'ṉ José y pyøc je une myamaji'ṉ y tzu'ṉyaj tzu'i, maṉyaj Egipto nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jen o ityaju hasta que ca' Herodes. Entonces jetse tujcu que maṉyaj Egipto'omo para que va'cø tyucø ndø Comi Diosis chi'use tza'maṉvajcopyapø qui'pscocuy va'cø chamø: “Egipto nasomo ⁿveja'yø ø ⁿUne va'cø chu'ṉø”. ");
INSERT INTO zosNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cuando Herodesis chi' cuenta que 'yaṉgøma'cøyaj 'ya'myajpapø'is matza, qui'sca'comø'nu. Por eso chi' orden va'cø yaj ca'yaj mumu une metza ameta'mbø y mas che'ta'mbø lo que ityajupøna'ṉ Belén gumgu'yomo y ribera'omo. Jic metza ame tiempo chajmayaju'csye'ṉomo 'ya'myajpapø'is matza cuando quej matza. ");
INSERT INTO zosNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jetse viyu'ṉaju jachø'yuse tza'maṉvajcopapø Jeremiasis, je'is chamu: ");
INSERT INTO zosNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Mandøj ote Ramá cumgu'yomo, vo'yajpa y vejyajpa pømi, y Raquejlisna'ṉe nø cyøveju 'yune. Ji'namna'ṉ syun va'cø chambasencia'ajtøjø porque ca'yajupømete. ");
INSERT INTO zosNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pero jøsi'cam ca'u Herodes, y entonces tum ndø Comi Diosis 'yaṉgelesis cyejay napasyi'omo José jiṉø Egipto nasomo. Y ñøjayu: ");
INSERT INTO zosNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Te'nchu'ṉø, pøc je une myamaji'ṉ y vitu' Israel nasomo; porque ca'yaju'am maṉbapø'sna'ṉ yaj ca'yaje. ");
INSERT INTO zosNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Entonces José te'ñchu'ṉu y ñømaṉ je une myamaji'ṉ Israejlis ñasomda'm. ");
INSERT INTO zosNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero Jose'is myusu que cuando ca'u Herodes, tzø'cye't 'yune Arquelao va'cø 'yaṉgui'mø Judea nasomo jyata'is itcu'yomo. Y por eso José na'tzu va' maṉ jiṉø. Entonces tzajmatyøj ñapasyi'omo Galilea nasomo va'cø myavø. Y jiṉ o maṉ José cyo'uneji'n y myamaji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Cuando nu'c jeni, maṉ it Nazaret cumgu'yomo. Jetse viyu'ṉaju lo que chamyaju cha'maṉvacpapø'is que Jesús ma ñøyi'aj nazareno. ");
INSERT INTO zosNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jic tiempo'omo min Juan nøyø'opyapø, min chamgøpucs ja ijnømømø Judea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nømu: ―Qui'psvitu'tamø porque pronto'am maṉba aṉgui'm tzajpomopø Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tza'maṉvajcopapø Isaiasis o chame que maṉba it pøn; y Juanete jic pøn Isaiasis chamupø. Isaías nømu: Nø vyejnøm ni i ja ityømø, nømba: “Como ndø vøjø tzøjcatyamba tuṉ møja'n aṉgui'mbapøcøtoya, jetse mi ndzocoy hay que va'cø mi vøjø ndzøcatyamø porque maṉba min ndø Comi”. ");
INSERT INTO zosNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jua'nis tyucu, camello copø'nisna'ṉe pyøcpø. Y chec vatcuy nacapøte, y vyi'cpana'ṉ aju y cyu'tpana'ṉ yumi tzinu. ");
INSERT INTO zosNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Y Jerusalén gumgu'yomda'mbø, y jic Judea nasomda'mbø, y tome Jordán nø'om ityajupø; mumu miñaju va'cø cyøma'nøyaj Juan. ");
INSERT INTO zosNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Cuando chamyajpana'ṉ cyoja, Jua'nis ñø'yøyaju Jordán nø'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jua'nis isu que nø ñu'cyaju vøti fariseo va'ṉjajmocuy ñø'ijtupø'is y saduceo va'ṉjajmocuy ñø'ijtupø'is. Miñaju va'cø ñø'yøyajø. Y ñøjayaju Jua'nis: ―¡Tzanse mi yandzita'm mijtzi! ¿Ti'ajcuy mi ṉgui'pstamba o'ca muspa mi mbyotyamø va'cø jana mi ṉgyastigatzøctam Diosis cuando qui'syca'pa ñe'cø? Ji'n mus mi mbojyatyam Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","”Tzøctam vøjø jujche syunbase cuando mi ṉgui'psvitu'tamu'jcam; ");
INSERT INTO zosNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","y u mi ṉgui'pstamu que maṉba mi ṉgyotzoctame porque Abraham mi mbeca jata tzu'ṉgutya'm. Porque øtz mi nøjanda'mbøjtzi que hasta yøṉ tza' Diosis muspa yac pønvituyajø va'cø Abraha'mis 'yune'ajyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Como tum pøn ñø'ijtu'is jacha listo va'cø tyøṉyaj cuy ji'n tyø'mayajepø va'cø pyoṉbø'yajø juctyøjcomo, jetse Dios listo yøti va'cø cyastigatzøcyaj pøn ji'n chøcyajepø'is vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Øtz viyuṉse mi nø'yøndya'mbøjtzi nø'ji'ṉ porque mi ngui'psvitu'tamu'am vøjpø ticøsi. Pero ma min øjtzaṉgø'mø mas pømi'øyupø que ji'n øjtzi. Øtz ji'nchø vøjpø como jicse. Va'cø chøjcay nu'csocuy jicø myøja'ṉombø pøngøtoya syunba más vøjpø pøn que øjtzi, porque ji'n aunque i'is mus chøjcaye. Je'is maṉba mi nø'yøndyam Masanbø Espiritu Santoji'ṉ y juctyøcji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Como tum pøn ñø'ijtu'is cyø'omo yemguy listo va'cø cyøsujø trigo pyuj va'cø pyuj ñaca, jetse je maṉbapø mini, je'is maṉba cyøpiṉyaj pøn. Y como vøjpø pyuj ndø tu'mba va'cø ndø aṉne'ṉgø, y ñaca ndø pyoṉbø'japya; jetse je'is maṉba yac tu'myaj vøjta'mbø pøn tyøjcomo y yatzita'mbø maṉba pyoṉbø'yaj nunca ji'n tu'yipø juctyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Entonces Jesús tzu'ṉ Galilea nasomo y nu'c Jordán nø'omo ijtumø Juan, para que va'cø ñø'yøyø Jua'nis. ");
INSERT INTO zosNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Primero ja syun Jua'nis va'cø ñø'yøy ndø Comi Jesús. Jua'nis ñøjay ndø Comi: ―Øjtzi vøjø va' mi ndø nø'yøy mijtzi y mitz mi min para que øtz va'cø mi ⁿnø'yøyø. ");
INSERT INTO zosNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero Jesusis ñøjayu: ―Yaj jetsepø mi ṉgui'psocuy; porque jetse tiene que va'cø ndø tzøcø va'cø ndø tzøc Diosis syunbase. Entonces Jua'ṉis vyo'møjayu va'cø ñø'yøy Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cuando Jesús nø'yøyu, put je nø'cø'mø, y tumø hora aṉvac tzap; y Jesusis isu Diosis 'Yespiritu nø myø'nu como palomase y jetcøsi nu'cu. ");
INSERT INTO zosNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Entonces mandøju nø vyejmø'n ote tzajpomo, nømu: ―Yøṉø ø Une sunbapø øjtzi, jetcøtoya casøpyøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Luego Espiritu'is ñømaṉ Jesús ni i jya'ityømø para que va'cø chøjquis yatzi'ajcu'is a ver o'ca muspa yac tocoy Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesús o it jana cu'ti cuarenta dias chu'ji'ṉ jamaji'ṉ, y jøsi'cam osu. ");
INSERT INTO zosNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Entonces tyo'møy Jesús yatzi'ajcu'is va'cø chøjquis a ver o'ca muspa chøctocoya. Yatzi'ajcu'is ñøjay Jesús: ―Si de veras o'ca Diosise mi 'yune, yac panvitu yøṉ tza'. ");
INSERT INTO zosNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero Jesusis 'yaṉdzoṉu: ―Ji'nø maṉ mbaṉdzøqui porque it Diosis 'yote jachø'yupø, nømba: “Ji'n solo cu'tcuji'ṉdi queñaje pøn, sino mumu lo que chambapø ote Diosis, jetji'ṉ jamacøtyajpa”. ");
INSERT INTO zosNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Entonces yatzipø'is ñømaṉ Jesús masan gumguy Jerusale'nomo y ñøqui'm møji masandøj copajcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Y ñøjayu: ―Viyuṉse o'ca Diosis mi 'yune, locsmø'nø, tøjpaṉque'c nasomo; porque it Diosis 'yote jachø'yupø nømba: Diosis ma chi' orden aṉgeles para que va'cø mi ṉgüendatzøcø, maṉba mi ñømaṉ cyø'ji'ṉ va'cø jana mi nejpinduc ni jutipø tza'cøsi, ni ti jana mi ndzøcø. ");
INSERT INTO zosNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesusis 'yaṉdzoṉu: ―También it Diosis 'yote jachø'yupø: “U mi ndzøjquis a prueba ndø Comi Dios”. ");
INSERT INTO zosNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Otra vez yatzipø'is ñømaṉ Jesús ye'ṉupø cotzøjcøsi y cøyin isindzi mumu ijtuse cumguy nascøsi y myøja'ṉo'majcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y yatzi'ajcu'is ñøjayu Jesús: ―Ma mi ndzi' aṉgui'mguy mumu yøṉgøsi o'ca mi ṉgyujnepya va'cø mi ndø va'ṉjam øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Entonces Jesusis ñøjayu: ―Mavø, Satanás, ji'na mi ṉgujnejaye; porque it Diosis 'yote jachø'yupø, nømba: “Va'ṉjam ndø Comi Dios, y solo je'is ñu'csocuy tzøjcayø”. ");
INSERT INTO zosNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Entonces je yatzi'ajcuy tzu'ṉu, chac jen Jesús y miñaj angeles va'cø cyotzoṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cuando Jesusis myanu que Juan preso'omna'ṉ ijtu, maṉ Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero ja chø'y jic Nazaret cumgu'yomo, sino maṉ it Capernaum cumgu'yomo. Je cumguy mar saya'om ijtu, Zabulón y Neftalí nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jetse viyu'ṉaju lo que jyachø'yuse tza'maṉvajcopyapø Isaiasis; je'is jyayu: ");
INSERT INTO zosNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Jic Zabulón nasomo y jic Neftalí nasomo, jic Majraṉvinpø tu'ṉombø; Jordán nø'cøtu'møṉ, Galilea nasomo ityajumø lo que ji'ndyet Israel pønda'm; ");
INSERT INTO zosNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Pi'tzø'ajcu'yomo ityajupø pø'nis isyaj møjapø sø'ṉgø. Jetsena'ṉe ma ca'yaj pi'tzø'ajcu'yomo, pero min syø'ṉocpacyaj møja sø'ṉgø'is. ");
INSERT INTO zosNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Entonces Jesusis cha'maṉvactzo'tzu, nømu: ―Qui'psvitu'tamø, porque pronto'am maṉba aṉgui'mi tzajpomopø Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús nømna'ṉ cyøjtu Galilea mar saya'omo cuando isyaj nø cyoque nucyaju tum pøn myuquiji'ṉ. Tum ñøyina'ṉ Simón, y mismo tumbø'is ñøyina'ṉ Pedro. Y eyapø Andresna'ṉ ñøyi. Coque nuctayuta'mete y nømna'ṉ ñacsyaj ataraya nø'cø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Entonces Jesusis ñøjayaju: ―Ma tø pa'jtamø. Yøti ji'n ma mi nuctam coque, sino pøn maṉba mi yac mindam øtzcø'mø. Porque øtz jetse maṉba mi yac yostame. ");
INSERT INTO zosNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Entonces luego chacyaj 'yataraya y maṉyaj Jesusji'ṉ va'cø vityajø. ");
INSERT INTO zosNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Usy vit Jesús y isyaj metzcuy Zebedeo'is 'yune, tum ñøyipø'is Jacobo, y tum ñøyipø'is Juan. Barco'omna'ṉ ityaj jyataji'ṉ nømna'ṉ vyøjøtzøcyaj 'yataraya. ");
INSERT INTO zosNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Cuando Jesusis vyejayaju, chacyaj byarco jeni jyataji'ṉ maṉyaj Jesusji'n va'cø vityajø. ");
INSERT INTO zosNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesusis nømna'ṉ 'yocvit Galilea nas y tumdumbø Israel pø'nis tyu'mgutyøjcomo nømna'ṉ cha'mindzi'yaj vøjpø ote jujche aṉgui'mbase Dios. Y yac tzocyajpana'ṉ aunque jujchepø ca'cuy ñø'ityaju'is. ");
INSERT INTO zosNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Y mumu Siria cumgu'yomda'mbø'is myusyajque'tu que Jesús yac tzojcopya, y ñømijnayaj mumu toya nø isyajupø'is ca'cuji'ṉ, ji'n tumø cuentata'mbø'is cya'cuy. Ñømiñaj yatzi'ajcu'is yacsutzøcyajupø y tu'yajpapø y ñømijnayajque't ji'n musi vityajø. Y Jesusis yac tzocyaju mumu. ");
INSERT INTO zosNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Maṉ pya'tyaj Jesús vøti pø'nis; Galilea nasomda'mbø'is y Decápolis nasomda'mbø'is, y Jerusalén gumguyomda'mbø'is, y Judea nasomda'mbø'is y Jordán nø'cøtu'maṉda'mbø'is. Mumu maṉ pya'tyaje Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cuando Jesusis isyaj vøti pøṉ, qui'm cotzøjcøsi y jen po'cschø'yu. Y vyocøtøjcøyaj ñøtuṉdøvø'is. ");
INSERT INTO zosNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Y Jesusis 'yaṉmacho'chaj yø'cse: ");
INSERT INTO zosNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Contento ityajpa cyønøctøyøyajpa'is que ja it vøjpø tiyø choco'yomo, porque jetseta'mbø 'yaṉgui'myajpa y cuidatzøcyajpa Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","”Contento ityajpa maya'yajpapø, porque Diosis maṉba yajayaj myaya'cuy. ");
INSERT INTO zosNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","”Contento ityajpa ji'n cyoquipi'is vyin, porque je'is ma pyøjcøchoṉyaj nasacopac Diosis chamdzi'yajupø. ");
INSERT INTO zosNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","”Contento ityajpa ityaju'is gyanas va'cø chøcyaj Diosis syunbase, porque maṉba cyotzoṉyaj Diosis va'cø chøcyaj vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","”Contento ityajpa lo que tyoya'ṉøyajpapø'is tyøvø, porque ñe'c Diosis maṉba tyoya'ṉøyajque'te. ");
INSERT INTO zosNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","”Contento ityajpa los que limpiota'mbø'is chocoy, porque je'is ma isyaj Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","”Contento ityajpa jic cojecsyajpapø'is va' yaj quipcuy, porque jet maṉba ñøjayaj Diosis: Øjchøṉ mi unenda'm. ");
INSERT INTO zosNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","”Contento ityajpa los que yacsutzøcyajtøjupø nø chøcyaju aṉcø Diosis syunbase, porque tzajpombø itcuy je'is ñe'ayajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","”Contento mi ijtamba cuando pø'nis mi ndyopa'o'nøtyamba y mi yacsutzøctamba y mi ṉgyø'o'nøndyamba cosa ji'n vyiyuṉda'mbø ticøsi. O'ca jetse mi ⁿyacsutzøctamba porque øtz mi ndø va'ṉjamdamba ancø, ");
INSERT INTO zosNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","casøtyamø y contento ijtamø; porque maṉba mi ṉgyoyojtam Diosis tzajpomo. Porque jetseti yacsutzøcyajque't tza'maṉvajcoyajpapø pøn vi'na antes que mitz mi ijtamba. ");
INSERT INTO zosNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","”Mitz ṉgyana cuentata'mete yø'c nascøsi. Pero o'ca jic cana ji'n cyana'ome, entonces ji'n mus ndø yac yosa. Tiene que va'cø ndø patzpø' va'cø myaṉvitu'yaj pø'nis. Jetse mitz o'ca ji'n mi yostam vøjø Dioscøtoya, igual mi mbyatzpø'tandøjpa. ");
INSERT INTO zosNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","”Mitz syø'ṉgø cuentata'mete nascøsi. Tum cumguy lomacøsi ijtu donde quiera quejpa. ");
INSERT INTO zosNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ni ji'n ndø ja'mbay no'a va'cø ndø cot cajacøtøjcø'mø; mejor ndø cotpa ye'ṉumø va'cø cyøsø'ṉoy ityajuse tøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","También mitzta'm tzøjque'tati vøjø y jetse por cuenta mi sø'ṉdaṉgue'tpati pø'nis vyi'naṉdøjquita'm. Entonces cuando pø'nis isyapa que mi ndzøctamba vøj mitzta'm, maṉba vyøcotzøcyaj ndø Janda tzajpom ijtupø. ");
INSERT INTO zosNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","”U mi ṉgui'pstamu o'ca mi'nøjtzi va'cø ⁿyajay Diosis 'yaṉgui'mocuy, o va'cø yajay tza'maṉvajcoyajpapø pø'nis 'yaṉma'yocuy. Ja mi'nøjtzi va'cø ⁿyajayø, sino va'cø ⁿyaj coputa. ");
INSERT INTO zosNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Porque viyuṉse mi ndzajmatyamba, hasta que yajpa tzap y nas, ni tum letra, ni tum punto Diosis 'yaṉgui'mocu'is ñe ji'n ma yaje hasta tucpa tiyø chamba. ");
INSERT INTO zosNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Por eso o'ca ndø tzacpa aunque sea tum aṉgui'mocuy más ji'n myøja'ṉombø, y jetse ndø aṉmayajpa eyata'mbø va'cø chøcyajque'ta; entonces tø øtz ji'n ma tø valetzøjque't Diosis itcu'yomo. Pero o'ca ndø yaj coputpa, y ndø aṉmayajpa eyata'mbø va'cø chøcyajque'ta, entonces maṉba tø møja'ṉo'majø tzajpombø Dios 'yanqui'mbamø. ");
INSERT INTO zosNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mi nøjandya'mbøjtzi que o'ca ji'n mi ijtam más vøjø que 'yaṉmayajpapø'is aṉgui'mocuy ityajpase, y fariseo aṉma'yocuy ñø'ityajupø'is ityajpase, entonces ni jujche ji'n mus mi ndyøjcøy tzajpombø Dios 'yaṉgui'mbamø. ");
INSERT INTO zosNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","”Mi ñchajmatyandøju'am jujche tzajmayajtøju pecapøn, jej nømyaju: “Uy yaj ca'otyame, pues yaj ca'opyapø tiene que va'cø cyastigatzøctøjø”. ");
INSERT INTO zosNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero mi nøjandya'mbøjtzi que o'ca mi ṉgui'sca'pa mi ndøvøji'ṉ, tiene que va'cø mi ṉgyastigatzøctøjø. O'ca mi ndopa'o'nøpya mi ndøvø, tiene que va'cø mi ⁿyaj coja'ajø aṉgui'myajpapø pø'nis cuando tu'myaju'cam. Y o'ca mi ṉgoraje nøjapya mi ndøvø: “ⁿJyovi mijtzi”. Entonces como jetse mi nøjapya mi ndøvø, por eso ya mero yatzi'ajcu'yomo mi myaṉba. ");
INSERT INTO zosNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","”Jetcøtoya o'ca nø mi nøminu aunque tiyø va'cø mi ṉgot altarcø'mø para Dioscøtoya, y jen mi ⁿjyajmundzøcpa que mi ndøvø'is nømdi mi ṉgui'sayu, porque ja mi ñømaṉ mi ndøvø vøjø, ");
INSERT INTO zosNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","entonces tzac jeni mi ndzi'ocuy altarcø'mø, y maṉ vi'na'c va'cø o'nøy mi ndøvø va'cø jyajmbø cyoraje. Entonces maṉgue't altarcø'mø va'cø mi ndzi' lo que maṉbapø mi ndzi' Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","”O'ca mi ṉgui'sapapø'is mi ṉgyøva'cøpya, mientras tu'ṉomdøc mi ijtamu antes que mi ñu'ctam atcanicø'mø, 'yo'nøy vøjø jetse va'c yac tzø'yø, va'cø jyajmbø' quipcuy. Porque o'ca ji'n mi vøjøndzøc jetse, maṉba mi ṉgyøva'cøy atcanicøsi, y je'is maṉba mi yac nuc policia'is y maṉba mi syomi. ");
INSERT INTO zosNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Viyuṉsye mi nøjambyøjtzi: hasta que mi ṉgoyojaṉga'mba mi ja'ndze, ji'n ma mi mbyut preso'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","”Mi mandambati que ji'n vøj va'cø ndø cøtzøjcøy ndø ⁿjaya, o ndø ⁿyomo, va'cø jana ndø nø'it eyapø. ");
INSERT INTO zosNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero øtz mi nøjanda'mbøjtzi: O'ca mi a'maṉga'pa eyapø yomo y sunba mi o'nøyø, es como mi ndzøjcu'am aunque ja mi ndzøcøpø, y jetze mi ṉgui'psocu'yomo mi ṉgøtzøjcøyupømete mi ⁿyomo. ");
INSERT INTO zosNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","”Jetcøtoya o'ca mi ndzø'naṉ vitø'mis mi yaj cojapa'tpa, tzucsputø y patzpø'ø. Porque va'co mi yac tocoy tum vitøm, menos toya que va'cø coṉñapø mi mbyatzpø'tøj yatzi'ajcu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Y o'ca mi ndzø'na'ṉis mi yaj cojapa'tpa, tøcspø'ø y patzpø'ø. Va'cø mi ṉgyø'cøtø'csø menos toya que va'cø mi mbyatzpø'tøj coṉñapø yatzi'ajcu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","”Tzamdøjupøte vi'na: “O'ca pø'nis chacpa yomo, syunba va'cø chi' yomo toto que co'tøjcajaṉvajcu'am”. ");
INSERT INTO zosNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero mi nøjandambati mijtzi: O'ca pø'nis chacpa yomo comecti, yomo'is ja cyøtzøjcøyø, entonces yomo'is maṉba pyøc eyapø pøn y jetse cyøtzøjcøpya jyaya, pero jyaya'is it cyoja porque ñec chajcu. Y pyøjcu'is tzactøjupø yomo jet cojapa'tpa. ");
INSERT INTO zosNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","”También mi mandamu que peca pø'nis vi'na chamyaju: “O'ca ndø Comi Diosis vyi'naṉdøjqui mi ñømba: Viyuṉse Dios maṉba ndzøqui; entonces tiene que va'cø mi ndzøcø”. ");
INSERT INTO zosNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero mi nøjandyambati mijtzi: U mi ndzambøc Dios como testigos que viyuṉ nø mi nchamu, ni u mi ndzambøc tzap, porque Diosise 'yaṉgui'mgu pyo'cscuy. ");
INSERT INTO zosNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni u mi ndzambøc nas, porque je Diosis tye'nguy. Ni u mi ndzambøc Jerusalén, porque møja'ṉombø aṉgui'mba'is cyumguy. ");
INSERT INTO zosNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni u mi ndzambøc mi ṉgopac, porque ji'n mus mi yac popo'aj ni yac yøjcaj ni tumø mi ⁿvay. ");
INSERT INTO zosNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pero tum nacti nømø “jø'ø”, o “ji'nda”. Jenche'ṉomdi tzamø. O'ca más mi ndzamaṉøpya, yatipø'is mi ñøtzøcpa. ");
INSERT INTO zosNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","”Mi mandamu'am que tzamdøju pecapøn: “O'ca pø'nis chaṉgo'tzapya tyøvø'is vyitøm, eyapø'is muspa chaṉgo'tzacye't ji'quis vyitøm va'cø parejo tzø'yaj queyaṉ do'tita'm mye'chcø'i. Y o'ca pø'nis chaṉbujtapya tyøvø'is tyøtz, eyapø'is muspa ñøpujtacye't ji'quis tyøtz, va'cø parejo tøtztucu'ajyajø”. ");
INSERT INTO zosNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero øtz mi nøjaṉdya'mbøjtzi: U mi nø tu'mbajcajtamu. O'ca mi nchaṉdøjpa mi ndzø'naṉ acapajcøsi, nøjayø: Muspa mi ndø tzaṉque't tu'møn, øtz jin ma mi ndzave. ");
INSERT INTO zosNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","O'ca aunque i'is mi ṉgyøva'cøpya y sunba pyøjcay mi ṉgamisa, nøjayø: O'ca más nø mi sunu, tø pøjcacye'tati ø ñchaqueta. ");
INSERT INTO zosNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O'ca aunque i'is mi 'yobligatzøcpa va'cø nømaṉjay chømi media legua, pues nømaṉjayø y nøjayø: Mati mi nøma'ṉøjacye't mi ndzømi eyapø media leguanaque't. ");
INSERT INTO zosNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","O'ca mi ⁿvya'cpa aunque tiyø aunque i'is, muspa mi ndzi'ø. Y o'ca aunque i'is sunba ñu'cs aunque ti mijtzene, u mi nøjayø: Ji'n mus mi nu'cschi'ø. ");
INSERT INTO zosNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","”También mi mandamu'am que tzamdøju'am vi'na: “Sunø mi amigo y qui'say mi enemigo”. ");
INSERT INTO zosNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero mi ndzajmatyambati mi øjtzi: Sundamø mi enemigota'm, o'nøtyam Dios va'cø cyotzoṉ mi enemigo aunque mi enemigo'is mi ṉgyø'o'nøpya. Tzøjcatyam bien mi ṉgui'sapyapø'is. O'nøtyam Dios va'cø cyotzoṉ Diosis mi enemigo aunque mi enemigo'is mi ndyopa'o'nøpya y mi ⁿyacsutzøcpa. ");
INSERT INTO zosNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jetse tzajpombø ndø Janda'is mi 'yune, porque je'is yaj qui'mba jama y nøcsø'ṉøpya mumu pøn parejo, sea yatzita'mbø, vøjta'mba; y je'is yaj quecpa tuj mumu pøngøtoya; o'ca sea chøcpapø'is Diosis syunbase, sea ji'ṉ chøqui'is Diosis syunbase. ");
INSERT INTO zosNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pues o'ca mi amigo mi sunba porque je'is mi syunba, Diosis ji'n mi ṉgyoyoje porque mi sunba mi amigo; porque jetsetique't cobratzøcyajpapø para gobiernocøtoya nay nøsyuñajtøjpa 'yamigoji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y o'ca vøj mi nømaṉba na's mi amigo, y eyapø ji'n mi nømaṉ vøjø, ji'n mi ndzøc vøjpø tiyø. Pues aunque i'is ñømaṉba vøj 'yamigo. ");
INSERT INTO zosNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jetcøtoya tzøctam puro vøjpø tiyø como ndø Janda tzajpombø'is chøcpase. ");
INSERT INTO zosNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","”Cuando mi ndzøctamba vøjpø tiyø, u mi ndzøctam pø'nis vyi'naṉdøjqui va'cø mi ⁿvyøṉgotzøc pø'nis; porque o'ca mi ndzøcpa vøjø va'cø mi ⁿvyøṉgotzøc pø'nis, entonces ndø Janda tzajpom ijtupø'is ji'n mi ñchi' ni ti coyoja. ");
INSERT INTO zosNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cuando mi ṉgotzoṉba pobre, uy mi ndzamgøpucs ti mi ndzøjcu. Porque ityaj pøn chi'yajpapø'is pobre tumin vøti pø'nomo va'cø isyaj vøti pø'nis; que sea tu'mguy tøjcomo, sea calle'omo. Jic chi'yajpapø'is tumin sunba va'cø vyøcotzøcyaj vøti pø'nis. Pero mi nøjandyamba viyuṉsye que jic chi'yajpapø'is pobre tumin vyøcotzøcyajpa pø'nis, pero ni ti coyoja ji'n ma chi'yaj Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero mitz cuando mi ndzi'pa pobre tumin, ni i u mi yac musu, ne'c musø ti mi ndzi'u. ");
INSERT INTO zosNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jetse nu'mdzi'ø; aunque nu'mdi nø mi ndzøjcu, pero ndø Janda'is nømdi isu, y je'is maṉba mi ñchi' mi ngoyoja. ");
INSERT INTO zosNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","”Y cuando mi o'nøndyamba Dios, u mi ndzøctam jujche chøcyajpase vya'ṉjamba tzøcpa'is. Jetseta'mbø'is gyustatzøcyajpa va'cø tye'ñaj tu'mguy tøjcomo y calle tzove'omo va'cø jen conocsyajø va'cø isyaj aunque i'is, jeteme gyustatzøcyajpapø. Pero viyuṉ nø mi ndzajmayu que lo que gyusto ñø'ityaju, jetemete cyoyoja. Ni ti cyoyoja ji'n ma chi'yaj Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero mijtzi cuando mi o'nømbya Dios, tøjcøy mi ṉguarto'omo y aṉgojøy mi ⁿvin, y o'nøy ndø Janda lo que ji'n ndø isi. Y ndø Janda'is tø ispa aunque ndø tumgø'y tø itø, y je'is maṉba mi ṉgyoyoje. ");
INSERT INTO zosNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","”Y cuando mi o'nømbya Dios, uy comeque jana tumnac ndzama misma oración. Porque jetse chøcyajpa ji'n cyomusyaje'is Dios. Cyomo'yajpa que Diosis maṉba myane o'ca jana ndumnac nø chamyaj tiyete. ");
INSERT INTO zosNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pero u mi ndzøctam je'is chøcyajpase. Porque ndø Janda'is ispa ti'is mi nchøjcapya falta antesti mi ⁿva'cpa ti sunba mi ⁿva'ṉgø. ");
INSERT INTO zosNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pero cuando mi o'nøndyamba Dios, yø'cse nømdamø: Ø Jandata'm tzajpom mi ijtupø'is, yaj cøna'tzøjay mi nøyi. ");
INSERT INTO zosNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Minø mi aṉgui'moya. Yac tucø mi sunbase; jujche tzajpomo, jetze nascøs yac tucø. ");
INSERT INTO zosNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tø tzi'tam tumdum jama ndø jamaṉgøtcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tø yaj cotocotyamø ø ṉgoja, jujche øtz ⁿyaj cotocotya'mbøjtzi ti tzøjcatya'mbøjtzi aunque i'is. ");
INSERT INTO zosNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","O'ca yatzipø'is tzøjquista'mbøjtzi va'cø jujche yaj cojapajtamø, uy tø yac maṉdam jeni, sino tø yaj cotzoctam jana tø nuc yatzipø'is. Porque mijtzi aṉgui'mopyapø myøja'ṉombø, y vøj va'cø mi vøṉgotzøctam øjtzi mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","”Porque o'ca mitz ⁿyaj cotocotyamba mi ñchøjcatyambapø'is yatzitzoco'yajcuy, entonces maṉba mi ⁿyaj cotocotyaṉgue't ndø Janda'is. ");
INSERT INTO zosNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero o'ca ji'n mi ⁿyaj cotocotyam mi ñchøjcatyambapø'is yatzitzoco'yajcuy, entonces ndø Janda'is ji'n ma mi ⁿyaj cotocojatyam mi yandzitzoco'yajcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","”Cuando jana cu'ti mi ijtamba mi va'ṉjajmocuycøtoya, u yacsyu quene como chøcyajpase aṉgøma'cø'oyajpapø pø'nis. Pero ñe'cti jetse nø cyenu va'cø myusyaj pø'nis que jana cu'ti ityajpa. Viyuṉ nø mi ndzajmayu que jetemete cyoyoja, ni ti coyoja ji'n ma chi' Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero mitz cuando jana cu'ti ⁿijtu, jas mi ⁿvay y vinche'a, ");
INSERT INTO zosNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","va'cø jana myusyaj pø'nis que jana cu'ti mi ⁿijtu. Pero ndø Janda ji'n ndø isipø, je'is mi ⁿispa. Y je'is maṉba mi ñchi' mi ṉgoyoja pø'nis vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","”U mi aṉne'c ricu'ajcuy yø'c nascøsi, porque yø'c yø'pø'pa y putzpa y yajpa mumu tiyø; y ityaj nu'myajpapø, je'is ñu'myajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pero más vøjø va'cø mi aṉne'c mi ringu'ajcuy tzajpomo. Jiṉ ni ti ji'n yø'pø'i, ni ji'n pyutzi, ni ji'n yaje, ni ja ij nu'mbapø va'cø ñu'mø. ");
INSERT INTO zosNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Porque jut ijtumø mi ricu'ajcuy, jendi maṉba itque't mi ndzocoy. ");
INSERT INTO zosNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","”Ndø vindøm por cuenta ndø coṉña'is ño'ase. O'ca ndø vindøm sø'ṉba vøjø, muspa tø vitø. Jetse ndø tumø chocoy va'cø ndø sunø tzajpombø ricu'ajcuy, vøj tø itpa, ndø tzi'pa cuenta tiyø vøjpø. ");
INSERT INTO zosNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero o'ca ji'n syø'ṉ ndø vindøm, pitzø'ajcu'yom tø itpa. Jetse o'ca ndø sunba nascøspø ricu'ajcuy, como pi'tzø'omse tø itpa. Así es que o'ca ndø qui'psocuy ji'n vyøjø, ni ti ja it vyø'om putpa. ");
INSERT INTO zosNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","”Ji'n mus ndø yosay tumnajcøsi metzcuy comi. Porque tum comi maṉba ndø suni, y tum ji'n maṉba ndø suni; o tum ndø comi ndø yosapya vøjø, y tum ji'n ndø yosay vøjø. O'ca Dios ndø yosapya, ji'n mus ndø yosay ricu'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","”Por eso nø mi ndzajmatyamu: U mi nømaya'tamu ti maṉba mi ṉgu'jtame ti maṉba mi uctame, ni u mi nømaya'tamu jujche maṉba mi nducu'øtyam mi ⁿvin. Porque Diosis más mi yac yajmapya mi ṉguenguy que ji'n cu'tcuy; y mi ⁿvin más mi yac yajmapya que ji'n tucu. ");
INSERT INTO zosNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","A'mdam møji sititvityajpapø paloma. Ni ti ji'n ñipyaje, ni ji'n cyosechatzøcyaje; ni ji'n jyojøyaj troja, pero pyø'nøyajpa tzajpom ijtupø ndø Janda'is, y mitz mas vøti mi yac yamdamba je'is que ji'n paloma. ");
INSERT INTO zosNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Será que it mijtzomda'm muspapø ye'ṉaṉøy medio metro vøti nø qui'psu aṉcø? Pues ji'n musi. ");
INSERT INTO zosNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","”¿Ticøtoya mi maya'ndamba ti maṉba mi mestame? A'mdamø lirio jøyø tza'mom ityajpapø jujche tzocyajpa. Ji'n yosyaje ni ji'n pi'tyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero øtz nø mi ndzajmatyamu que møja'ṉ aṉgui'mba Salomón vøjpø itcu'yomo ja o mescøyoje va'cø chi'ṉø como tum jøyø chi'ṉbase. ");
INSERT INTO zosNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Por eso o'ca Diosis jetse suñi yaj quenba ta'ṉø que yøti ijtu y jyo'pit poṉbø'tøjpa juctyøjcomo, está seguro Diosis maṉba mi yac mescøyojtam mijta'm; mijtzi mi mbyønda'm usypøtite mi va'ṉjajmoṉgutya'm. ");
INSERT INTO zosNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Por eso u myaya'tamu, u ñømdamu: “¿Ti maṉba ndø cu'jtame, ti maṉba ndø uctame, ti maṉba ndø mestame?” ");
INSERT INTO zosNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Porque jetseta'mbø tiyø mye'chajpa ji'n Diosis cuenta'ṉomda'mbø'is. Pero tzajpom ndø Janda'is ispa mumu ti ja mi nø'indøpø. ");
INSERT INTO zosNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mejor me'tzam vi'na va'cø mi ijtam Diosis 'yaṉgui'mgu'yomo, y va'cø mi ijtam Diosis syunbase, jetse Diosis maṉba mi ñchi'a'ṉøtyam tucusepø cu'tcusepø. ");
INSERT INTO zosNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Por eso u mi myaya'ndamu jujche maṉba mi ijtam jyo'pit, porque jyo'pit maṉba it otro eyapø ti va'cø mi ṉgømaya'que'ta. Tumdum jama it ti va'cø ndø cømaya'ø. ");
INSERT INTO zosNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","”U mi nømu it mi ndøvø'is cyoja, entonces Dios ji'n ma nømi que it mi ne'. ");
INSERT INTO zosNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porque jujchepø castigo tø nømba va'cø tzi'tøj ndø tøvø; jetsepø castigø maṉba tø tzi'que't Diosis. Como mujcu cuenta maṉba tø tzi' Diosis castigo parejo como tø nømbase va'cø cyastigatzøc ndø tøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Porque o'ca it møjapø cuy mi vindø'momo, ji'n mus mi is che'pø putzi mi ndøvø'is vyitø'momo va'cø mi ñømbutø. Jetseti ji'n mus mi ndzam que it mi ndøvø'is cyoja cuando vøti it mi ne'. ");
INSERT INTO zosNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Ti'ajcuy mi nøjapya mi ndøvø: “Øjtzi ma'ṉba sujput putzi puchtøjcøy mi vindø'momo”, cuando it møja cuy mi ne' mi vindø'momo? ");
INSERT INTO zosNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yach qui'psocuy mi nø'ijtu'is: nøputø mi vindø'momo ijtupø møja cuy vi'na, entonces muspa mi is vøja va'cø mus nøput putzi mi ndøvø'is vyitø'momo. Jetsetique't nøput vi'na yatzitzoco'yajcuy mi ndzoco'yomo ijtupø como møja cusye, y entonces muspa mi ndza'maṉvajcay mi ndøvø'is cyoja como chøtøpø putzise. ");
INSERT INTO zosNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","U mi ndza'maṉvac masan ote tuyiseta'mbø pøn, porque como tuyi'is tø nøcquetzquetzvøpyase, jetse maṉba mi nchøctame. Va'cø ndø patzpø suñipø namcha orøsepø yoya'is vyi'naṉdøjqui, ji'n chøjcay cuenda que vøjpø tiyø y maṉvituvituvøyajpa. Jetsetique't va'cø ndø tza'maṉvac yatzipø pøn vøjpø tiyø, ji'n chøjcay cuenda, y sijcusye ñømaṉba. ");
INSERT INTO zosNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","”Va'ctamø, y mi ñchi'tandøjpa; me'tztamø, y mi mba'jtambati; co'cstam aṉdyuṉ, y mi 'yaṉvajcatyandøjpa. ");
INSERT INTO zosNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porque mumu vya'cpapø'is pyøjcøchoṉba ti nø vya'cu; y mye'tzpapø'is pya'tpa ti nø mye'tzu: y cyocspapø'is aṉdyuṉ, aṉdzoṉyajtøjpa. ");
INSERT INTO zosNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","”O'ca mi une'is vya'cpa pan, ¿acaso tza' maṉba mi ndzi? Pues ji'n ma mi ndzi'tza'. ");
INSERT INTO zosNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Y o'ca vya'cpa coque, ¿acaso tzan maṉba mi ndzi'? Pues ji'n tzan ma mi ndzi'. ");
INSERT INTO zosNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Aunque mitzta'm mi yandzi'ta'mbøte, pero mi ndzi'tamba mi une vøjpø tiyø, entonces más seguro ndø Janda tzajpombø'is más maṉba mi nchi'tam vøjpø tiyø o'ca mi ⁿva'ctamba ñe'jcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","”Jujche mi sunba va'cø chøcyaj pø'nis mitzcøtoya, jetseti tzøctaṉgue't jic pøngøtoya; porque jetseti it aṉgui'mguy Diosis chi'upø Moisés, y jetse cha'maṉva'cyajpana'ṉ tza'maṉvajcoyajpapø pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","”Pøctam cayipø tuṉ dzo'tzcuy. Porque pe'tzi tuṉ dzo'tzcuy y møjapøte tuṉ nu'cpapø tocoñømbamø, y jiṉ maṉgo'nømba tiṉdiṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero cayi tuṉ dzo'tzcuy y cayipøte tuṉ nu'cpapø tø quendambamø, y metz tu'caṉbø'nisti pya'tyajpa jic tuṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","”Tzøctam cuenda u mi 'yaṉgøma'cøy aṉgøma'cø'oyajpa pø'nis que minba y nømyajpa: “Øtz Diosis chø pyøn”, pero aṉgøma'cø'oyajpapøtite. Chøcyajpa vyin como borrego, pero it qui'psocuy como tza'ma copønse. ");
INSERT INTO zosNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Y como ndø cøque'nøpya cuy o'ca vøjpø cuyete o'ca vøj tyøm, jetsetique't va'cø ndø tzi' cuenta jujche chøcpase pø'nis, jetse ndø mustambati jujchepø pøn jicø. Porque como apit cucyøsi ji'n it uva, ni apit ta'nøcøsi ji'n it higo cu'is tyøm, jetsetique't yatzipø pø'nis ji'n chøc vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Así es que vøjpø cuy tø'majpa y vøjti tyøm, pero cuando ji'n vyøjpø cuy tø'majpa, ji'n vyøj tyøm. ");
INSERT INTO zosNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jetsetique't vøjpø cucyøsi ji'n mus it ji'n vyøjpø tyøm. Y ji'n vyøjpø cucyøsi ji'n it vøjpø tyøm. ");
INSERT INTO zosNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","O'ca cu'is tyøm ji'n vyøjpø, tøṉdøjpa y poṉbø'tøjpa. ");
INSERT INTO zosNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Por eso jetsetique't va'cø tø tzi' cuenta jujche chøcpase pø'nis, jetse ndø mustamba pøn jicø jujchepøte. ");
INSERT INTO zosNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","”Vøtita'mbø'is nøjapyøjtzi: “Øjtzø mi Ṉgomi, øjtzø mi Ṉgomi”; pero mi nøjandya'mbøjtzi que ji'n mumu maṉba tøjcøyaje tzajpombø Diosis cuenta'ṉomo. Tøjcøyajpa chøcyajpapø'is ø Janda'is syunbapø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sone pø'nis maṉba nøja'yøjtzi jic jamacøsi: “Øjtzø mi Ṉgomi, øjtzø mi Ṉgomi, mi nøyiṉgøsi tza'maṉvajcatya'møjtzi, y mi nøyiṉgøsi macpujta'møjtzi yatzi'ajcuy, y mi nøyiṉgøsi oy ndø tzøqui vøti milagro”. ");
INSERT INTO zosNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Entonces ma'ṉbø ⁿnøjayaje: “Ja mi ispøcta'møjtzi. Tzu'ṉdamø øtzcø'mø mi ndzøctambapø'is yatzipø tiyø”. ");
INSERT INTO zosNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","”Jetcøtoya i'is cyøma'nøjapya lo que øtz ndza'maṉvacpase, y chøcpa, es como qui'psocu'yøyupø pønse tza'cøs oyu'is ño'jtzø'y tyøc. ");
INSERT INTO zosNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","O quec tuj, o pømi'aj nø', o poy sava. Y pømi oy ñucjo'y tøc nø'is. Pero ja jyu'mbø'ø porque tza'cøs no'jtzø'yupø. ");
INSERT INTO zosNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero i'is cyøma'nøjapya lo que øtz ndza'maṉvacpase, y ji'n chøqui, es como jovipø pønse oyu'is chøc tyøc po'yocøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","O quec tuj, pømi'aj nø', y poy sava y nø'is pømi ñuc tøc y yac ju'mbø'u y completamente po'ctocoyu. ");
INSERT INTO zosNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cuando Jesusis ñøte'ndzø'y tzamdzamnecyuy, ñømaya'jayajpana'ṉ pø'nis Jesusis 'yaṉma'yocuy. ");
INSERT INTO zosNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Porque 'yaṉmayajpana'ṉ como vøjpø aṉgui'mbase, y ji'ndyete como ñe 'yaṉmayajpapø'is aṉgui'mguy 'yaṉmayajpasena'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Y mø'n Jesús lomacøsi y vøti pøn parejo mø'ñaj jetji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Y cyømin Jesús tum yachputzi'øyupø pø'nis, y min cyujnejay ndø Comi vyi'naṉdøjqui y ñøjayu: ―Øjchøṉ mi Ṉgomi, mitz it mi musocuy va'cø mi ndø yac tzoca, o'ca sunba mi ndø yac tzoca. ");
INSERT INTO zosNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Entonces Jesusis cyojtay cyø' pøngøsi y ñøjayu: ―Su'nbøjtzi va'cø mi nchoca; yøti mi yac tzocpøjtzi. Cuando Jesús nøm jetse, jicsye'cti ca'epø tzojcu. ");
INSERT INTO zosNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Entonces Jesusis ⁿñøjayu: ―Mavø, pero ni i u chajmayu. Ma yac is mi ⁿvin pane que mi ñchojcu'am, y va'ctzi' pane tzi'ocuy como aṉgui'muse Moisés. Jetse maṉba myusyaj pø'nis que mi ñchojcu'am. ");
INSERT INTO zosNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Y cuando Jesús tøjcøy Capernaum cumgu'yomo, cyømin tum soldado covi'najø'is. Minu ñøjay va'cø cyotzova. ");
INSERT INTO zosNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ñøjay Jesús: ―Ø ṉgoyospa tze'som ijtu ø ndøcmø, yo'capøte vyin y nø syun doya'isco'nu. ");
INSERT INTO zosNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesusis ñøjayu: ―Ma'ṉbø mave va'cø ⁿyac tzoca. ");
INSERT INTO zosNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero soldado covi'najø'is 'yaṉdzoṉu: ―Vøjtina'ṉ va'cø mi ndøjcøy ø ndøjcomo, øtz mi sunbana'ṉtzi. Pero como mitz ⁿmyøja'ṉ aṉgui'mbate y øtz ni ti ji'n ø ⁿyoscuy, por eso ji'n mus mi ⁿyac tøjcøy ø ndøjcomo. Pero na's mi ondeji'ṉ muspa mi ndø yac tzojcay ø ṉgoyospa. ");
INSERT INTO zosNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Porque it ø ṉgovi'najø y øtz tiene que va'cø ndzøc je'is chambase. Y øtz nø'it soldado ø ngø'aṉvini. Cuando øtz nøja'mbøjtzi: “Mavø”, y maṉba. Cuando øtz nøja'mbøjtzi que minø, y mingue'tpa. Cuando nøjambya ø ṉgoyosypa: “Chøc yøcse”, y chøcpa. (Como mitz más it mi aṉgui'mguy; muspa mi yac tzoc mi ondeji'ṉ.) ");
INSERT INTO zosNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cuando Jesusis myan jetsepø vejvejnecuy, almiratzøjcu y ñøjayaj nø jyøsnaco'ṉyaju'is: ―Viyuṉse mi nøjandya'mbøjtzi que ni ji'n Israel pø'nomo ja mbya'tøtø'ctzi va'ṉjajmopapø pøn como yøṉ emøcpø pøn va'ṉjajmopyase. ");
INSERT INTO zosNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Viyunse øtz mi nøjandya'møjtzi que vøti emøcpø pøn maṉba tzu'ṉyaje jama mingucyøsi y jama tø'pcucyøsi y maṉba tøjcøyaj aṉgui'mbamø tzajpomopø Dios. Y maṉba po'csaṉdø'pyaj va'cø vi'cyaj Abrahamji'ṉ y Isaacji'ṉ y Jacobji'n. ");
INSERT INTO zosNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero Abraha'mis 'yune lo que maṉbana'ṉ tøjcøyaj tzajpombø aṉgui'mgucyø'mø, jet maṉba tzø'yaj como patzpøcuy cuenta pi'tzø'ajcu'yomo. Jen maṉba vejyaje toyapit y maṉba quetztiquitiquivøyaj tyøtz. ");
INSERT INTO zosNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Entonces Jesusis ñøjay soldado covi'najøpø: ―Muspa mi maṉ mi ndøcmø, como mi ndø va'ṉjambase, jetse maṉba ndzøc mitzcøtoya. Entonces misma hora jicsyecti tzoc mbøñṉga'e. ");
INSERT INTO zosNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Entonces Jesús nu'cu Pedro'is tyøjcomo, y jeni isu Pedro'is myo'ot mama tze'som ijtu y nø ñutzø'øyu. ");
INSERT INTO zosNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Y Jesusis pi'quisay cyø' y entonces chajcu nutzø'is. Y ca'epø te'ṉchu'ṉu y minu cyu'tcuchøjcayaje. ");
INSERT INTO zosNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cuando tzu'i'ajnømu, ñømijnayajpana'ṉ Jesús sone pøn lo que yatzi'ajcu'is ñøtzøcyajupø; y Jesusis tumnac va'cø 'yojnay yatzi'ajcuy, yatzi'ajcu'is pochacyaj pøn y vøjti ityaj qui'psocuy; y también Jesusis yac tzocyaj mumu ca'eta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jetse tujcu va'cø viyu'ṉajø lo que vi'na cha'maṉvajcuse cha'maṉvajcopyapø Isaiasis cuando nømu: “Je'is pyøjcøcho'ṉaytam ø ndoya y yac tzojca'yø ø ṉga'cuyta'm”. ");
INSERT INTO zosNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Y isu Jesusis que sone pø'nis itcøvitu'vitu'vøyaju, 'yaṉgui'myaj ñøtuṉdøvø va'cø jyacyaj marcøtu'møn. ");
INSERT INTO zosNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Y minu tum myuspapø'is Moisesis 'yaṉgui'mguy y je'is cyønu'cu Jesús ñøjayu: ―Maestro, øtz ma'ṉbø mi mba'te juti nø mi mya'ṉøyu. ");
INSERT INTO zosNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Y Jesusis ñøjayu: ―Tziji'is ityajpa chatøc, y møji vityajpapø paloma'is ityajpa ño'sa; pero øtz mumu Pø'nis chø Tyøvø, ja it ni juti itpamø'tzi. ");
INSERT INTO zosNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Y eyapø pøn, que ñøtuṉdøvøte, je'is ñøjay Jesús: ―Señor, tzacø vi'na va'cø ñijpay ø janda. ");
INSERT INTO zosNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesusis ñøjayu: ―Mi tø pa'tø; y tzajcayajø je ca'upø yac ñipyaj ca'upø tyøvø'is. ");
INSERT INTO zosNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Entonces tøjcøy Jesús barco'omo, y ñøtuṉdøvø'is maṉ pya'tyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Y joviseti minu jetecø'mø pømipø sava, y nø'is ñøctapsøy barco y te'mdøjcøyu barco'omo. Pero Jesús øṉuna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Entonces tyo'møyaj ñøtuṉdøvø'is y yac sa'yaju y ñøjmayaju: ―¡Señor, tø yaj cotzoca, ma'ṉbø tø sucsca'tame! ");
INSERT INTO zosNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Je'is ñøjayaju: ―¿Ticøtoya mi ña'tztamba? ¡Usyti mi va'ṉjajmondyamba! Jicsye'c te'nchu'ṉu y 'yojnay sava y nø', y vøṉbø'u, vø'ajco'nømu. ");
INSERT INTO zosNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Y pøn o'ca jujchese tucyaju y ñømyaju: ―¿Tiyø pønete, que hasta sava'is y majris cyøna'tzøyajpa? ");
INSERT INTO zosNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Y nu'cyaju marcøtu'møṉ Gadara nasomo. Cuando jena'ṉ ityaju'c, miñaj metzpøn ñøc'ijtøyajupø yatzi'ajcu'is. Jicø pøn tzu'ṉyaju ityajumø anima tzatøc, porque jen ityaju nijpoñømbamø. Yatzita'mna'ṉete, ni i'sna'ṉ ji'n mus cyøjtay jic tu'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jicsye'c vejaṉgøtyaju nømyaju: ―Mijtzi Diosis 'yune, ¿ti'ajcuy minba mi ndø molestatzøctame? ¿Minu mijtzi yø'qui va'cø mi ndø yac toya istame antes que nu'cpa hora? Jetse ñøjayaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Y usy ya'ay ya'ay ijtu vøti yoya nø cyu'tu. ");
INSERT INTO zosNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Y yatzi'ajcu'is ñømgo'nayaj Jesús: ―O'ca mi ndø nøpujtamba, tø yac tøjcøtyam jic yoya'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Y Jesuis ñøjayaju: ―Maṉdamø. Entonces putyaju y tøjcøyaj vøti yoya'omo. Y mumu yoya jovi'ajyaju pyatzmø'ñaj vyin quetza'omo y tzipo'jtøjcøyaj nø'cø'mo y su'csca'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Y yoya cyoquenbapø'is poyaju, y maṉyaju cumgu'yomo y chamnøvityaj jujche tucyaju y jujche vø'ayaj je pøn ñøc'ititvøyajupø yatzi'ajcu'is. ");
INSERT INTO zosNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Entonces vøti cumgupyø'nis maṉ choṉyaj Jesús; y isyaju'c, vya'cayaju Jesús va'cø chu'ṉø ñasomo, va'cø maṉ emøc. ");
INSERT INTO zosNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Entonces tøjcøy Jesús barco'omo y vitjajcu nø'cøtu'møṉ, y nu'cu ñe cyumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Y jiṉø ñø miñaj pøn yo'capø ji'n musipø vitø. Cajtzay chøqui'omo cyapnømiñaju. Cuando isu Jesusis jujche vya'ṉjamyaju; ñøjmay ca'epø: ―Ø ⁿune, u myaya'e, mi ñchø'pya cøvajcupø mi ṉgojaji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Y ityajuna'ṉ jen 'yaṉmayajpapø'is Moisesis yaṉgui'mguy, y metzcuy tu'cay je'tomo qui'psocu'yomo nømyaju: “Yøṉ pø'nis cyø'o'nøpya Dios. Chøcpa vyin como Diose, y pønete”. ");
INSERT INTO zosNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero Jesusis cyønøctøyøjay ti nø qui'psyaju y ñøjayaju: ―¿Ticøtoya nañchoc ṉgui'pstamba yatzipø tiyø mi ndzocøyomo? ");
INSERT INTO zosNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ti más fácil, va'cø tø nomø: “Mi nchø'pya cøvajcøyupø mi ṉgojaji'ṉ”, o va'cø tø nømø: “Te'nchu'ṉø y ca'ṉbø'ø”? ");
INSERT INTO zosNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero maṉba mi isindzi que øjtzi mumu Pø'nis chøṉ Tyøvø, øtz nø'it aṉgui'mguy nascøsi va'cø yaj cotocojay aunque i'is cyoja. Entonces Jesusis ñøjay ca'epø: ―Te'nchu'ṉø, piṉ mi ṉgajtzay chøqui y maṉ mi ndøcmø. ");
INSERT INTO zosNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jicsye'cti te'nchu'ṉu y maṉ tyøcmø. ");
INSERT INTO zosNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Isyaj vøti pø'nis y ñømaya'yaju, y myøja'ṉ vøcotzøcyaj Dios porque Diosis chi' pøn aṉgui'mguy jetse va' yosa. ");
INSERT INTO zosNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Y tzu'ṉ jeni Jesús maṉ vitpø'i. Nømna'ṉ vyitpø'u, isu pøn cobratzøjcopapø ñøyipø'is Mateo. Jiṉna'ṉ po'cs coyojoñømbamø. Jesusis ñøjayu: ―Mi tø nøtu'ṉajø. Y Mateo te'nchu'ṉu y maṉ pya't Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesús maṉ covi'c Mateo'is tyøcmø. Y vøti cobratzøjcoyajpapø y eyapø cojapatyajupø nu'cyaj tyøcmø, nømna'ṉ pyo'csyaj mesacø'mø Jesusji'ṉ y ñøtuṉdøvøji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ityaj jeni fariseo aṉma'yocuy ñø'ityajupø'is, y cuando je'is isyaju que Jesús nø pyo'cs mesacø'mø jetsepø pønji'ṉ, entonces fariseo'is ñøjayaj Jesusis ñøtuṉdøvø: ―¿Ticøtoya vi'caṉdø'pyajpa mi maestro cobratzøjcoyajpapøji'ṉ y cojapa'tyajupøji'ṉ? ");
INSERT INTO zosNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pero myan Jesusis, y 'yaṉdzoṉu: ―Como sa'sapø pø'nis ji'n syuñaj médico, sino ca'epø'is syuñajpa; jetse ja cyojapa'tyajøpø pø'nis ji'ṉ nø suñaj yaj cøtoco'opyapø, sino ityaju'is cyoja, je'is suñajpa yaj cøtoco'opyapø. ");
INSERT INTO zosNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pero maṉdamø, ma aṉmandyamø ti sunba chamø yøṉ jachø'yupø Diosis 'yote: “Ji'n o suni va'cø mi ndø tzi aunque tiyø, sino øtz su'nbøjtzi va'cø mi ndoya'ṉøtyam mi ndøvø”. Porque ja mi'nø ⁿvejayaj vøjta'mbø pøn va'cø qui'psvitu'yajø, sino mi'nø ⁿvejayaj coja 'øyajupø va'cø qui'psvitu'yajø. ");
INSERT INTO zosNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Entonces nø'yø'opyapø Jua'nis ñøtuṉdøvø'is cyønu'cyaju Jesús y yaṉgøva'cyaju: ―¿Ticøtoya øtz ji'nø cu'jtame, y también ityajpa jetse jana cu'ti fariseo, ji'n cyu'tyaje metza tu'ca jama'omo vya'ṉjajmocucyøtoya; pero mi nønduṉdøvø cu'tyajpa mumu jamasye? ");
INSERT INTO zosNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesusis 'yaṉdzoṉu: ―Como tu'myajupø co'tøjcajcucyøtoya ji'n maya'yaje mientras pøn maṉbapø co'tøjcaje jendi ijtu, jetse ø nønduṉdøvø ji'n ma ityaj jana cu'ti mientras øtz yø'c ijtu. Pero cuando øtz maṉba emøc, jana cu'ti maṉba ityaje maya'cupit. ");
INSERT INTO zosNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","”Ji'n ndø pa'jna'que jome tucuji'ṉ pecapø tucu. Jetse va'cø ndø pa'jna'cø, tzitzvøjøtzøjque'tpa pecapø tucu, y más yajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni ji'n ndø tijtøy jomepø uva'is ñø' peca naca cojtocu'yomo. O'ca jetse ndø tzøcpa, naca cojtocuy tzitzpa y uva nø' titpø'pa y yajpa cojtocuy. Sino jomepø uva nø' ndø tijtøpya jomepø cojtocu'yomo y jetze mye'chcøyi ji'n tocoyaje. Jetsetique't pecapøji'ṉ ji'n mus ndø mot jomepø aṉma'yocuy. ");
INSERT INTO zosNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mientras Jesusis nømna'ṉ cham jetse, min tum Israel pøn covi'najøpø y cyutcøne'cay Jesús y ñøjmayu: ―Ca'u'am ø yom'une; pero minø y cot mi ṉgø' ø uneṉgøsi y maṉba visa'e. ");
INSERT INTO zosNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Entonces Jesús te'nchu'ṉu y maṉ pya'te, Jesusis ñøtuṉdøvø'is maṉ pya'tyajque'te. ");
INSERT INTO zosNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mientras nø tyuṉajyaju, minu tum yomo macvøstøjcay ame nø toya'isupø ca'cu'is, nømna'ṉ ñø'pi'nøyu yomo ca'cu'is. Jic yomo'is pyoya'ṉøy Jesús jyøsmø y pi'quisay Jesusis tyucu coso. ");
INSERT INTO zosNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nømu ñe'c qui'psocu'yomo: “Na's va'cø mbi'quisay tyucu, tzocpøjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús que'najvitu'u y is yomo y ñøjayu: ―Ø mi une, u myaya'e, porque mi ndø va'ṉjajmu, mi ñchojcu'am. Y misma hora tzojcu. ");
INSERT INTO zosNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Entonces tøjcøy Jesús covi'najø'is tyøjcomo isyaj nømna'ṉ cyøvo'yaj nømna'ṉ cyøvejyaj ca'upø. ");
INSERT INTO zosNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Y Jesusis ñøjmayaju: ―Tzu'ṉdam yø'qui yøṉ itcu'yomo. Yom'une ja cya'øpøte, sino øṉupøtite. Pero mumu aṉbø'nis syijcayaj Jesús, porque myusyaju que ca'upøte. ");
INSERT INTO zosNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pero myacputpø'yaju'cam vøtipøn, entonces tøjcøy Jesús tøjcomo y cho'ṉbøjcay une'is cyø', y yom'une te'nchu'ṉu. ");
INSERT INTO zosNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Y chamgøpo'yaj mumu jic nasomo ti o chøc Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Después tzu'ṉ Jesús jeni, maṉu. Metzcuy to'tita'mbø'is nømna'ṉ myacyaj Jesús; vyejayaju ñøjayaj Jesús: ―¡Davijdis mi 'yune, tø toya'ṉøtyamø! ");
INSERT INTO zosNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Y cuando Jesús tøjcøyumna'ṉ tøjcomo, to'tita'mbø'is cyønu'cyaju Jesús y Jesusis 'yaṉgøva'cyaju: ―¿Mi va'ṉjamdambatija o'ca øtz muspa yac sø'ṉaṉvajcatyam mi vindøm? Pø'nis 'yandzoṉyaju: ―Jø'ø, øjtzø mi Ṉgomi, øtz mi va'ṉjamdambati'tzi. ");
INSERT INTO zosNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Entonces Jesusis pi'quisayaj vyitøm y ñøjmayaju: ―Jujche mi va'ṉjamdambase, jetse maṉba tyuqui. ");
INSERT INTO zosNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jisye'cti sø'ṉyaj vyitøm. Entonces Jesusis chijpana aṉgui'myaju ñøjayu va'cø jana ni i chajmayajø o'ca tzocyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero tzu'ṉyaju y mumu jic nasomo chajmayaj aunque iyø ti chøc Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mientras nømna'ṉ chu'ṉyaj tzocyajupø pøn, eyapø'is ñømijnayaj Jesús umapøtique't, yatzi'ajcu'is ñøc'ijtøyupø. ");
INSERT INTO zosNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tan pronto que yatzi'ajcuy ñøpujtayu Jesusis, pøn tzamdzamnecho'tzu. Mumu pøn maya'yaju nømyaju: ―Nuncatøc ja ndø istam yøcsepø milagro'ajcuy Israel pø'nomda'm. ");
INSERT INTO zosNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero fariseo pøn nømyaju: ―Covi'najøpø yatzi'ajcu'is chi'pa yøṉ pøn musocuy va'cø mus ñøpujtayaj eyapø yatzi'ajcuy ityajupø pø'nis choco'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Entonces Jesusis ñøc vijtøyu møja cumguy y che' cumguy. Nømna'ṉ 'yaṉmayaju Israel pø'nis tyu'mgutyøjcomo, y cha'maṉvajcu vøjpø ote jujche aṉgui'mbase Dios. Yac tzocyajpana'ṉ Jesusis aunque jujchepø ca'cuy ñø'ijtu'is, y aunque jujche nø tyoya'isupø. ");
INSERT INTO zosNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Cuando Jesusis isu vøti pøn, entonces tyoya'ṉøyaju porque maya'yajpana'ṉ y ni ti ji'naṉ mus chøcyajø; como borrego ja it ni i'is cyoqueñajpa, jetseti ityaj pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Entonces Jesusis ñøjayaj ñøtuṉdøvø: ―Como tum cosecha o'ca it vøti cosecha y usyco'ni pøn yosyajpapø, jetse viyuṉse Diosis yoscuy vøti ijtu y ja it yosyajpapø. ");
INSERT INTO zosNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Como tiene que va'cø ndø o'nøtyam vø' cosecha va'cø mye'tz más coyosyajpapø, jetse syunba va'cø mi o'nøndyam Dios va'cø cyø'vejyaj más pøn ñe' yoscuycøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Entonces macvøstøjcay ñøtuṉdøvø vyejay Jesusis va'cø miñajø, y chi'yaj aṉgui'mguy va'cø yac tzacyaj pøn yatzi'ajcuy y va'cø mus yac tzocyaj toya isyajupø aunque jujchepø ca'cu'is. ");
INSERT INTO zosNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yøṉømete macvøstøjcapya apostolesis ñøyipø: Vinbø, Simøn, y mismo Simøn yac ñøyi'ajyajque'tuti Pedro; metzcu'yombø Andrés Simo'nis myuqui; tu'ca'yombø Jacobo; macsycu'yombø Juan, Jacobo'is myuqui. Jacobo y Juan Zebedeo'sta'm 'yune. ");
INSERT INTO zosNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Mosa'yombø Felipe; tujta'yajcuy Bartolomé, cu'ya'yajcuy Tomás; tucutujta'yajcuy Mateo, cobratzøjcopyapø; macstujta'yajcuy Jacobo, Alfeo'is 'yune; majca'yajcuy Lebeo ñøyi'ajque'tuti Tadeo. ");
INSERT INTO zosNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Mactu'majcuy Simón cananista; y macvøstøjca'yajcuy Judas Iscariote oyu'is chi'ocuyaju Jesús 'yenemigo'is cyø'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesusis cyø'vejyaj yøṉ macvøstøjcay pøn y yøcse 'yaṉgui'myaju: ―U mi maṉdamu ityajumø pøn lo que ji'ndyet Israel pøn, ni u mi ṉgya'ṉdøjcøtyam Samaria pø'nis cyumgu'yomda'm. ");
INSERT INTO zosNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sino maṉdamø Israel pø'nomo, porque jetse ityaju como tocoyajupø borregose. ");
INSERT INTO zosNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Maṉdamø y tza'maṉvactam yø'cse: Nø tyome'aj tiempo va'cø 'yaṉgui'm tzajpombø Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pero mitz yac tzoctam ca'eta'mbø; yac visa'tam ca'yajupø; y yac tzoctam yach putzi'øyajupø; yac libre'ajyaj pøn ñø'ityaju'is yatzi'ajcuy. Mi ⁿvya'ctzi'tøju vøjpø tiyø, jetseti va'ctzi'taṉgue't vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","”Uy ñømaṉdam ni jujchepø tumin mi mbolsa'omo, ni oropø, ni platapø, ni cobrepø. ");
INSERT INTO zosNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","U mi nømaṉdam tucu cotcuy tuṉgøtoya, u mi nømaṉdam ni tum camisya, jetse nømaṉdam mi ṉgoso jana ni tiyø, ni u mi nømaṉdam ni cutyacusepø. Porque como yospapø pøn tiene que va'cø pyønøtyøjø, jetse mitz maṉba mi mbyø'nøtyandøjque'te. ");
INSERT INTO zosNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","”Pero aunque jutipø cumgu'yomo o ribera'omo mi ndyøjcøtyamba, aṉgøva'ctam o'ca it vøjpø pøn mi mbyøjcøchoṉdamba'is. Tzø'tyam je'is tyøcmø hasta que mi ndzactamba je cumguy. ");
INSERT INTO zosNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cuando mi nu'ctamba tyøcmø, vøpøpit yuschi'tamø. ");
INSERT INTO zosNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Y o'ca tøjcomda'mbø vøjta'mbote, tzi'yaj dyus vøjpø. Y o'ca ji'n vyøjta'm, u mi ndzi'yaj dyus. ");
INSERT INTO zosNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Y o'ca ji'n mi mbyøjcøchoṉdame o'ca ji'n mi myajnandyame, entonces tzac'yenbøtamø je tøjcomda'mbø o je cumgu'yomda'mbø; y mi ṉgøtijtøy mi ṉgoso cumguy pyo'yoji'ṉ como seña que yatzita'mbøte. ");
INSERT INTO zosNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Viyuṉsye mi ndzajmatya'mbøjtzi que cuando Diosis maṉba cyøme'chaj pøn cyojaji'ṉ, menosti manba toya'isyaj Sodoma y Gomorra cumgu'yomda'mbø. Y ja mi mbyøjcøchoṉdamøpø'is más maṉba toya'isyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","”¡Cøma'nøtyamø! Nø mi ṉgø'vejtamu mi ṉgui'satyøjpamø, y maṉba mi ijtam peligro'omo como borrego yatzipø copøngucmø. Por eso ijtam qui'psocu'yøyupø como tzan qui'psocu'yøyuse, pero ijtaṉgue't como palomase que ni ti ji'n tø maṉba tzøjcaye. ");
INSERT INTO zosNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tzøcta cuenda, porque pø'nis maṉba mi ñuctame, y aṉgui'mba'is vyi'naṉdøjqui maṉba mi ñømaṉdandøji, y maṉba mi ñacstochøctandøji Israel pø'nis tu'mguy tøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Y maṉba mi ñømaṉdandøji aṉgui'myajpa'is vyi'naṉdøjqui y gobierno'is vyi'naṉdøjquita'm porque mi ndø va'ṉjamdamba ancø. Jetse muspa mi ndza'mistame jujche øtz ndzøcpase, va'cø myusyajø je'tista'm y va'cø myusyajø lo que ji'ndyet Israel pø'nis ti ndzøcpøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cuando mi ñømaṉdandøjpa aṉgui'mba'is vyi'naṉdøjqui, u ma mi nø'uṉgui'ajtamu ti maṉba mi ndzajmayaje, jujche maṉba mi aṉdzoṉdame. Porque jicsye'c Diosis maṉba mi nchi'tam qui'psocuy jujche maṉba mi 'yaṉdzo'ṉotyame. ");
INSERT INTO zosNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Entonces ji'ndyet mi ne' onde mi ndzamba, sino ndø Janda'is 'Yespiritu'is mi nchi'tamuse qui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","”Maṉba it pøn maṉba'is chi'ocuyaj mismo tyøvø va'cø yaj ca'tøjø. Maṉba it jata maṉba'is chi'ocuyaj mismo ñe 'yune va'cø yaj ca'tøjø. Maṉba it une maṉba'is ñøquipyaj mismo jyata y myama hasta va'cø chi'ocuyajyajø va'cø yaj ca'yajtøjø. ");
INSERT INTO zosNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Porque mi ndøvø mi ndø va'ṉjamdamba ancø, por eso vøti pø'nis maṉba mi ṉgui'satyame. Pero o'ca mi ndondamba hasta que yajpa jetsepø toya'iscuy, maṉba mi ṉgyotzoctame. ");
INSERT INTO zosNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","O'ca mi ⁿyacsutzøctamba tum cumgu'yomo, pochactamø, maṉdam ne'co cumguy. Y ja mi ṉgøtpøjatyamøctøc mumu Israel cumguy cuando vitu'que'tpa øjtzi aunque i'is Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","”Como øtz maestro chøṉø y comi chøṉø ji'n ø cøna'tzøyaje, jetse mitz mi 'yaṉma'yombapø y mi ṉgyoyospa y menos ji'n ma mi ṉgyøna'tzøyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vøjø o'ca nø 'yaṉmayupø itpa como myaestrose. Jujche yacsutzøcyajpøjtzi øjchøṉ maestro y øjchøṉ comi, jetse maṉba mi ⁿyacsutzøctandøjque'te. Øtz jatase y mitz ø unese mi nø'ijtamba. Y o'ca nømyajpa que øtz yatzipø chøṉø como yatzi'ajcuy ñøyipø'is Beelzebú yatzise, entonces maṉba nømyaje que mitz jetseti mi yandzita'mgue't. ");
INSERT INTO zosNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","”Por eso u mi ñatztam maṉba'is mi ⁿyacsutzøctame pøn. Porque aunque tiyø aṉgøvø'nupø maṉba queje; mumu tiyø ji'n ndø musipø, jøsicam maṉba queje. ");
INSERT INTO zosNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lo que mi nu'm ndzajmatya'møjtzi, entonces muspa mi ⁿvejpø va'cø myan aunque i'is. Lo que mi nu'm dzajmatyamba mi ṉgojicø'mø, jet møji vejpø' va'cø myustøj mumu pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yaj ca'opyapø ji'n mus mi na'ndzø, porque sisti yaj ca'pa, y mi espiritu ji'n mus yaj ca'aye. Pero na'tzamø muspapø'is mi mbyatztøjcøtyam infierno'omo maṉbamø tocoyaj mi sis y mi espiritu. ");
INSERT INTO zosNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","”Aunque metzcuy che'ta'mbø paloma ndø ma'ajpa mosay centavocøsi, pero ni tum ji'n queque nascøsi o'ca ji'n syun ndø Janda Diosis va'cø cyeca. ");
INSERT INTO zosNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jetse mi ṉgyoquendaṉgue'tpa mijtzi Diosis. Y mijtzi hasta jujche it mi ⁿvay mi ṉgopajcomo cyomuspa Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Por eso u mi ña'tztamu. Porque Diosis vyi'naṉdøjqui más mi ⁿvyaletzøctamba que vøti nambaloma. ");
INSERT INTO zosNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","”O'ca mi ndzamba aunque i'is vyi'naṉdøjqui o'ca mi ndø va'ṉjamba, entonces øtz maṉba ndzamque't tzajpomopø ndø Janda'is vyi'naṉdøjqui que mi ndø va'ṉjamba. ");
INSERT INTO zosNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero o'ca mi ndzamba aunque i'is vyinaṉdøjqui que ji'n mi ndø va'ṉjame; entonces øtz maṉbati ndzamgue't tzajpombø ø Janda'is vyi'naṉdøjqui que ji'n mi ndø va'ṉjame. ");
INSERT INTO zosNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","”U mi ṉgui'pstamu o'ca mi'nøjtzi va'cø yac ijnøm vøjø nascøsi. Ja mi'nøjtzi va'cø yac ijnøm vøjø, sino porque minu aṉcø øjtzi, maṉba quipnømi. ");
INSERT INTO zosNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Porque eyapø'is va'ṉjamba øjtzi y eyapø'is ji'n va'ṉjame, por eso une'is maṉba qui'say jyata; yom'une'is maṉba qui'say myama; saque'is maṉba qui'say syaque mama. ");
INSERT INTO zosNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Y mismo tøjcomda'mbø'is maṉba na nøqui'sayajtøji. ");
INSERT INTO zosNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","”Por eso tiene que va'cø mi it dispuesto va'cø ndzac mi janda y mi mama o'ca je'is mi ṉgui'sapya øtzcøtoya; porque si no, entonces ji'n mus mi it øtzji'ṉ. Jetsetique't tiene que va'cø mi it dispuesto va'cø mi ndzac mi ⁿune o'ca je'is mi ṉgui'sapya øtzcøtoya. Porque si no, ji'n mus mi it øtzji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Y o'ca mi ña'tzpa va'cø mi ndyoya'isø mi ndø pa'tu aṉcø como øtz mase toya'is cruscøsi, entonces ji'n mus mi it øtzji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Cyoquenba'is vyin, maṉba tocoye; chi'ocuyajpa'is vyin øtzcøtoya, jet maṉba quene. ");
INSERT INTO zosNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","”Mbyøjcøchoṉba'is mijtzi, jetseti pøjcøchoṉgue'tpa øjtzi. Y pøjcøchoṉba'is øjtzi, jetseti pyøjcøchoṉque'tpa cø'veju'is øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pyøjcøchoṉba'is tza'maṉvajcopyapø porque Diosis cyø'veju, Diosis maṉba cyoyoje. Igual como cyoyojpa tza'maṉvajcopyapø, jetseti maṉba cyoyojque't pyøjcøchoṉba'is tza'maṉvajcopyapø. Pyøjcøchoṉba'is vøjpø pøn porque vøjpø pønete, vøjpø pø'nis pyøcpase cyoyoja, jetseti maṉba pyøjque't cyoyoja. ");
INSERT INTO zosNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Viyuṉse mi ndzajmatyamba que o'ca it ø nønduṉdøvø aunque pobre y ni ti aṉgui'mguy ja ñø'itø, y aunque i'is vya'ctzi'pa usyøc mamba nø' porque ø nønduṉdøvø aṉcø, entonces mati pyøjque't cyoyoja vya'ctzi'u'is nø'. ");
INSERT INTO zosNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesusis jetse nømna'ṉ 'yaṉgui'myaj macvøstøjcay ñøtuṉdøvø; y cuando yaj aṉma'yocuy, tzu'ṉyaj jeni, maṉyaj emøc. Y Jesús nømna'ṉ 'yaṉma'yoyu y cha'maṉvac 'yote tometa'mbø cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Entonces Juan nø'yø'yopyapø preso'omna'ṉ ijtu. Y Jua'ṉis min myusi ti nø chøc Jesusis. Y cyø'vejyaj metzcuy ñu'cscuy va'cø maṉ 'yo'nøyaj Jesús, ");
INSERT INTO zosNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","va'cø yaṉgøva'cyajø: ―¿A ver o'ca mijtzamate Cristo mi ṉgyø'vejupø Diosis lo que maṉbapø mini? Porque o'ca ji'ndyet mi jiṉgø, maṉba ⁿjo'ctam eyapø. ");
INSERT INTO zosNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesusis 'yaṉdzoṉu ñøjayaju: ―Ma tzamgøjtatyam Juan ti nø mi mandamu y ti nø mi istamu. ");
INSERT INTO zosNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mi istamba que to'tipø'is vyitøm nøm syø'ṉu, nø mus vyityaj vøjø mø'ṉga'ṉyajpapø; nøm chocyaju yachputzi'øyajupø, cojipø'is myañajpa'm ote; nø vyisa'yaj ca'yajupø, pobreta'mbø nø chajmatyøj vøjpø ote. ");
INSERT INTO zosNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Contento mi itpa o'ca tumchocoy mi ndø va'ṉjamba; o'ca ji'n mi myejtzaṉ gui'psi. ");
INSERT INTO zosNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cuando maṉyaju Jua'nis ñu'cscuy, entonces Jesusis chajmayaj sone pøn jujchepøte Juan. Jesusis ñøjayaj vøti pøn: ―¿Ti'ajcuy o mi myaṉdam ni i ja ityømø? ¿Ti o mi ṉgøque'nøtyame jiṉø? ¿Será mi 'yondyamu va'cø a'mdam cape yac micsupø sava'is? Seguro que ji'ndyet jetcøtoya mi 'yoñdyamu. ");
INSERT INTO zosNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Entonces ticøtoya o myaṉ mi ṉgøque'nøtyame jiṉø? ¿Será que mi 'yoñdyamu va'cø ṉgøque'nøtyam pøn suñi nø cyenupø tucuji'ṉ mescøyojupø? Ji'ndyet jete, porque tzi'ṉga'møyupø ji'n ma vyit tza'momo; angui'mba'is pyalacio'omo ityajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Entonces ji'ndyet jicø oyu mi ṉgøque'nøtyame; sino ¿ticøtoya o mi amdame? ¿No será que tza'maṉvajcopyapø o mi a'mdame? Jø'ø, viyuṉete jet o mi a'mdame. Porque o mi a'mdam Juan y Juan más myøja'ṉombøte que ji'n aunque jutipø tza'maṉvajopyapø. ");
INSERT INTO zosNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Porque it Diosis 'yote jachø'yupø jujche ma yos Juan, yøcse chamba que Diosis ñøjay ndø Comi: Yøṉ pøn øtz ṉgø'vejpøjtzi nu'cscuy nø minbapø'is ote antes que mi myinba mijtzi, como si fuera mi nduṉ vyøjøtzøjcuse. Je'is maṉba chajmayaj pøn va'cø ityaj jajmecøs va'cø mi mbyøjcøchoṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nøjayajque't Jesusis: ―Viyuṉsye mi ndzajmatyamba que nascøsi nunca ja o it más myøja'ṉombø pøn que ji'n Juan nø'yø'yopyapø. Pero más pobre y más ji'n 'yaṉgui'mipø pøn tzajpombø Dios aṉgui'mbamø, más myøja'ṉombøte que ji'n Juan. ");
INSERT INTO zosNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","”Desde que Juan nø'yø'yopyapø nø'yø'yocho'tzu hasta como yøti, pø'nis syunba cyøquipyaj tzajpombø Diosis itcuy; pyømiji'ṉ yatzita'mbø pø'nis sunba 'yocyajyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Porque mumu tza'maṉvajcoyajpapø pø'nis cha'maṉvacyajpana'ṉ Diosis itcuy, y jachø'tyøjupø aṉgui'mgu'is chamque'tpatina'ṉ hasta que Jua'nis cha'maṉvactzo'tzu. ");
INSERT INTO zosNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Y o'ca sunba mi va'ṉjajmø, maṉba mi ndzajmaye que como tzajmatyøju que Elías ma nu'qui, por eso Juan mismo pønditque't Eliaspø. ");
INSERT INTO zosNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","O'ca it mi ṉgoji, cøma'nøyø ti chøṉ mi ndzajmapyøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","”Maṉba mi ndzajmatyame isepø pønda'mete ityajpasepø nacøsi yøti. Es como une nø myøjtzøyajuse plaza'omo, jetseti ityajpa. Vyejayajpa undyøvø'is ñøjayajpa: ");
INSERT INTO zosNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mi yac vejatyamu suscuy y ja syun mi 'yendza. Mi vajnandyamu nijpocuy vaneji'ṉ, y ja mi ⁿvyo'ndamø”. ");
INSERT INTO zosNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Como une ji'n sun myøjtzøyaj ni etzcuy ni ji'n sun møjtzøyaj como ca'nømuse, jetse mitz ji'n sundam ni Juan ni ji'n mi ndø sundam ndøvø. Porque Juan ji'na'ṉ tumø ucyaj, tumø cu'tyaj pønji'ṉdam, y ja mi mbøjcøchoṉdam Juan, mi ñømdamu que yatzi'ajcu'is ñøc'ijtøyu. ");
INSERT INTO zosNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Y cuando mi'nø øjtzi, mumu Pø'nis chøn Tyøvø, tumø cu'tpøjtzi, tumø ucpøjtzi pønji'ṉda'm, y ja mi ndø sundaṉgue'tati øjtzi; mi ñømdamba que øtz cu'tco'nba, y vøti ⁿucpa øtz topyapø vinu; y 'yamigo'ajpøjtzi yatzitambø pøn como cobratzøjcoyajpapø y cojatzøcyajupø. Pero o'ca pøn vøj itpa, ndø tzi'pa cuenta que ñø'it vøjpø qui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Entonces Jesusis 'yojnayaj cumguy jutipø'om o chøc vøti milagro'ajcuy, porque ja chacyaj yach qui'psocuy. Nømu: ");
INSERT INTO zosNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Ay mijtzi Corazín cumgu'yomda'mbø! ¡Ay mijtzi Betsaida cumgu'yomda'mbø! Ja sun mi ndzactam yach qui'psocuy, por eso maṉba mi ndyoya'istame. O'ca isyajuna'ṉ Tiro cumgu'yombø'is y Sidón cumgu'yombø'is milagro'ajcuy mitz mi istamuse, ya'møjcam qui'psvitu'yajuna'n. Myesyajpanaṉ tucu tzøcyajupø costal y po'csyajuna'ṉ cujya'momo va'cø queja o'ca nø ñømaya'yaj cyoja. ");
INSERT INTO zosNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero mi nøjandyamba que jic jama cuando Diosis maṉba cyøme'chaj mumu pøn cyojaji'ṉ, menos maṉba cyastigatzøcyajtøj Tiro cumgu'yomda'mbø y Sidón cumgu'yomda'mbø, que ji'n mijtzi Corazín cumgu'yomda'mbø y Betsaida cumgu'yomda'mbø. Mitz más maṉba mi ṉgyastigatzøctame. ");
INSERT INTO zosNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y mijtzi Capernaum cumgu'yombø, mi ṉgomo'tyamba que vøj mi ijtamu como tzajpomse, pero hasta infierno'om maṉba mi yac mø'ndøj cø'yi. O'cana'ṉ isyaj Sodoma cumgu'yomda'mbø'is milagro'ajcuy jujche mitz istamusepø, tzø'yuna'ṉ jic cumguy hasta como yøti, ja 'yoc yajøna'n. ");
INSERT INTO zosNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Por eso jetcøtoya mi nøjandyamba mijtzi Capernaum cumgu'yomda'mbø'is que cuando Diosis maṉba cyøme'chaj pøn cyojapit, menos maṉba cyastigatzøcyaj Sodoma cumgu'yomda'mbø, y mijtzi más maṉba mi ṉgyastigatzøctame. ");
INSERT INTO zosNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jic jama'omo Jesusis 'yo'nøy Dios nømu: ―Øjtzø mi Janda; mijtzi Cyomi tzajpis, mijtzi Cyomi nasacopajquis. Mi møja'ṉ vøṉgotzøcpøjtzi, porque mi ⁿyaj cønøctøyøyaj che' unese ji'n myusoyajepø yøcsepø aṉma'yocuy, pero qui'psocu'yøyupø y musopyapø ja mi ⁿyaj cønøctøyøyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Vøj jetse, Jatay, porque mi ñømu que vøj jetse. Jetse 'yo'nøy jyata Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Entonces Jesusis chamque'tu: ―Ø ṉgø'om tzi'ø mumu tiyø ø Janda Diosis. Ni i'is ji'n comus øjtzi, øtz Diosis 'Yune chøṉø, sino ø Janda'is comuspøjtzi. Jetsetique ni i'is más ji'n cyomus ø Janda, solamente øtz ṉgomuspøjtzi, como øtz 'Yune chøṉø. Solamente i ø ne'c sunba yaj comusø, je'is cyomusque'tpati ø Janda. ");
INSERT INTO zosNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mindam øtzcø'mø nø mi me'tztamu'is cotzojcuy y ji'n mi mba'jtame, y mi ñindutamu'am como jemetzpø tzømis tø yac nitu'pase. Mindam øtzcø'mø, øtz maṉba mi yac sapøctame. ");
INSERT INTO zosNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mindam øtzcø'mø va'cø mi yostam øtzji'ṉ y aṉmatyam øtzcø'mø, porque øtz pasenciapø chøṉø, y como jujche pobrepø pø'nis qui'psocuy, jetseti ø ngui'psocucye't. Jetse maṉba mi syapøctam mi ndzoco'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Porque øtzji'n va'cø mi ⁿyosø, ji'n mi ñindu'i, y omba tzøcø lo que øtz aṉgui'mbase. ");
INSERT INTO zosNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jic eyaco jama, nømna'ṉ cyøtyaj Jesús trigo cama'omo co'aṉjamguy jama'omo. Y Jesusis ñøtuṉdøvø nømna'ṉ 'yosyaju. Por eso quitpøcyaj trigo'is tyøm va'cø cyø'syajø. ");
INSERT INTO zosNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pero cuando fariseo va'ṉjajmocuy ñø'ijtupø'is isyaju que jetse nø chøcyaju, ñøjayaj Jesús: ―A'mø, lo que ji'n musipø ndø tzøcø, jetse nø chøcyaj co'aṉjamguy jama'omo mi nønduṉdøvø'is. ");
INSERT INTO zosNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero ñøjayaj Jesusis: ―Viyuṉsye mi ndu'njo'tyamuti jujche chøc Davijdis ya'møc cuando nømna'ṉ 'yosyaju ñøtuṉdøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mi ndu'ndambati jujche tøjcøyaj David Diosis tyøjcomo y cyø'syaj cyømasa'nøyu pan, lo que ji'na'ṉ musipø cyø'sø. Davijdis cyø's ñøtuṉdøvøji'ṉ, pero jetsepø pan na's pane'is muspa cyø'sø. Ja it derecho va'cø cyø's eyapø'is jetsepø paṉ. (Pero David ji'n mi ṉgojatzi'tame.) ");
INSERT INTO zosNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Y mi ndu'ndambati aṉgui'mgu'yomo que pane muspa yosyaj masandøjcomo co'aṉjamguy jama'omo y ji'ṉ cyojapa'tyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Masandøc myøja'ṉombøte; pero mi nøja'ndya'mbøjtzi que yø'c ijtøjtzi más myøja'ṉ aṉgui'mbapø chøṉø que ji'n masandøc. ");
INSERT INTO zosNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","It jachøyupø que Dios nømu: “Øtz su'nbøjtzi va'cø mi ndyoya'ṉøyø más que ji'nø suni va'cø mi ndzi' pane aunque tiyø ø ṉgüentacøsi”. O'cana'ṉ mi ṉgønøctøyøpya ti sunba cham jetse, ja mi ṉgyojacøtzøjcøyøna'ṉ ja itø'is cyoja. ");
INSERT INTO zosNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Porque øjtzi mumu Pø'nis chøṉ Tyøvø, øtz aṉgui'mba ti muspa ndø tzøcø sapøjcuy jama'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús tzu'ṉ jen y maṉ conocscutyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jen ijtuna'ṉ pøn tøtzpø'upø'is cyø', y va'cøti pya'tyaj ticøs cyøva'cøyaj Jesús, 'yocva'cyaj Jesús fariseo'is: ―A ver o'ca muspa tø tzo'yø'yoy co'aṉjamguy jama'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Y Jesusis ñøjayu: ―O'ca ijtu mi mborrego y quecpa tzatøjcomo co'aṉjamguy jama'omo, viyuṉse maṉba mi ⁿjyundonbutø, y jetse maṉba mi ⁿyose aunque sea sapøjcuy jama. ");
INSERT INTO zosNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pero pøn masti coyoja'øyu que ji'ṉ borrego. Por eso va'cø ndø tzøc vøjø, ji'n ya'induc Diosis co'aṉjamguy jama'omo, muspa ndø tzøcø. ");
INSERT INTO zosNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Entonces ñøjay Jesusis tøtzpø'upø'is cyø': ―Tzøcøte'n mi ṉgø'. Pues cuando chøcøte'nu cyø', tzoctonde'nu, vøjti tzø'y como tu'maṉbø cyø'se. ");
INSERT INTO zosNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pero cuando tzu'ṉyaju jeni fariseo, tza'maṉdø'pyaju a ver jujche muspa yaj ca'yaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pero cuando Jesusis myusu jujche nø yach cøqui'psøyaju, tzu'ṉ jeni y maṉ emøc. Y vøti pø'nis maṉ pya'tyaje. Y mumu ca'eta'mbø yaj cøyindzocyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesusis chajmayaju va'cø jana cyotzamyajø ipø pønete. ");
INSERT INTO zosNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jetse chøjcu va'cø viyu'ṉajø lo que jujche chajmayuse tza'maṉvajcopyapø Isaiasis. Isaiasis jyachø'yu que jujche nøm Dios: ");
INSERT INTO zosNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jicø ø nu'cscuy ṉgøpi'ṉøjtzi, jic sungomø'nbøjtzi, contento itpøjtzi porque vøjpø pønete. Jicø ø nu'cscucyøsi maṉba ṉgojtay ø Espiritu, y maṉba chambucsi mumu pø'nomo que øtz ndzøcpa justicia vøjpø. ");
INSERT INTO zosNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jic ø nu'cscuy ji'n ma quipi, ji'n ma vyejaṉgøti; Ni i'is ji'n ma myajnay 'yaṉnaca calle'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Como cape ca'tzuse ja itø'is pyømi, jet maṉba cyotzove; y como no'a chi'mchi'mnepyapøse ni ticøtoya ji'n yose, jet maṉba cyotzoṉgue'te, hasta que yac tzøctøjpa vøjpø justicia. ");
INSERT INTO zosNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y mumu pø'nis maṉba vya'ṉjamyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Entonces ñønu'cyaj Jesuscø'mø tum pøn to'tipø y umapø porque yatzi'ajcu'is yacsutzøjcu. Y Jesusis yac tzojcu va'cø mus 'yone y va'cø isoya. ");
INSERT INTO zosNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Entonces ñømaya'yaju jutznøm tzojcu, y nømyaju: ―Yøṉøm ocsyote Davijdis 'yune Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Cuando fariseo'is myusyaju que jetse nø ñømyaj pøn, entonces fariseo nømyaju que Jesús yospa yatzi'ajcu'is cyovi'najøji'ṉ ñøyipø'is Beelzebul, je'is cyotzoṉba va'cø myacpø'yaj yatzi'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesusis myusu ti nø qui'psyajupø y ñøjayaju: ―O'ca gobierno'is pyøn quipyajpa ñe'comda'm, yajpa 'yaṉgui'mguy. Y o'ca cumgupyøn quipyajpa ñe'comda'm, yajpa cumguy. Jetsetique't o'ca tumbø familia quijpaṉdocoyajpa ñe'comda'm, yajyajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Entonces jetsetique't o'ca Satanasis ñu'cscuy quipyajpana'ṉ ñe'comda'm, entonces ve'nbø'tøjpana'ṉ y pronto maṉbana'ṉ ocyaj Satanasis 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Y o'ca yatzi'ajcu'is cotzoṉbana'ṉtzi va'cø macpø'yaj yatzi'ajcuy, entonces ¿será que yatzi'ajcu'is cyotzoṉyajque'tpa mi fariseo tøvø va'cø myacpøyajø yatzi'ajcuy? Entonces ji'n mus mi ndø queyaṉ gøtza'møyø porque mi nønduṉdøvø'is jetseti chøcyajque'tpa. ");
INSERT INTO zosNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero o'ca øtz macpø'yajpa yatzi'ajcuy Diosis Espirituji'ṉ, entonces Diosis mi yac istamba 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","”Ni i'is ji'n mus tøjcøy pømi'øyupø pø'nis tyøjcomo va'cø pyøcpø'jay cyote mientras que jendi it vø'tøc. Solamente o'ca myocspa vø'tøc, entonces cyøpøcpa. ");
INSERT INTO zosNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","”Ji'n vyø'mø'is øtzji'ṉ va'cø itø, qui'sapyøjtzi, i'is ji'n sun yos øtzji'n va'cø vyejtu'myaj pøn, je'is yac potyocoyajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","”Jetcøtoya mi nøjandya'mbøjtzi; aunque jujche it cyoja, aunque jujche cø'o'nø'opya pøn, Diosis yaj cotocojapya cyoja. Pero o'ca pø'nis cyø'o'nøpya Masanbø Espiritu Santo, nunca ji'n jutznøm yaj cøtocoye; cojapa'tu tumanajcøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","O'ca pø'nis cø'o'nøpya øjtzi, øtz mumu Pø'nis chøṉ Tyovø, pues Diosis yaj cøtocopya. Pero o'ca pø'nis cyø'o'nøpya Masanbø Espiritu Santo, nuṉca ji'n cyøtocoye, ni yøti y ni jujchøc. ");
INSERT INTO zosNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","”Ndø muspa que o'ca cuy vøjpøte, tyøm vøjpøtique't. Y o'ca ji'n vyøj cuy, ji'n vyøj tyøm. Porque tø'mis tø tzi'pa cuenta jujchepø cuyete. Jetseti ndø tzi'que'tpa cuenta pøn o'ca jujchepø pønete o'ca vøjpø ti chøcpa. ");
INSERT INTO zosNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Mitz tzanse mi ⁿyandzita'm! ¿Jutznøm muspa mi ndzamdam vøjpø tiyø? Porque mi ne'c mi ⁿyandzita'mdique't. Porque ndø tzoco'yomo ndø qui'pspa tiyete, entonces ndø aṉnaca'is chamba. ");
INSERT INTO zosNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vøjpø pø'nis ñø'it choco'cyøsi vøjpø tiyø aṉne'cupø, y jetseti chamgue'tpa vøjpø tiyø. Y yatzipø ti ñø'it aṉne'cupø chocoyomo yatzipø pø'nis, y yatzipø ti chamgue'tpati. ");
INSERT INTO zosNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jetcøtoya mi nøjandya'mbøjtzi: mumu ti joviseti mi ndzamba, tiene que va'cø mi yaṉdzo'ṉoya Diosis vyi'naṉdøjqui ticøtoya jetse o mi ndzame. Jetse maṉba tyuc jic jama cuando Diosis maṉba cyøme'tzay aunque i'is cyoja. ");
INSERT INTO zosNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Porque o'ca vøjpø ti mi ndzamu, jetse mi ṉgyotzocpa, o'ca yatzipø ti mi ndzamu, jetse mi ndyocopya. ");
INSERT INTO zosNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Entonces ityajuna'ṉ 'yaṉmayajpapø'is aṉgui'mguy y fariseo aṉma'yocuy nø'ityajupø'is. Je'is ñøjayaj Jesus: ―Maestro, suṉda'mbøjtzi va'cø mi ndø yac istam milagro'ajcuy va'cø mustamø que Diosis mi ṉgyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pero Jesusis ñøjayaju: ―Yøtita'mbø pøn yatzita'mbøte y cøtzøjcø'yoyajpapøte. Sunba isyaj milagro'ajcuy, pero ji'n maṉ yac isyaje, sino tza'maṉvajcopyapø Jonás tujcuse, jet senate jujche øtz maṉbase tujque'te. ");
INSERT INTO zosNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Oy it Jonás møja coque'is chejcomo tu'cay jama chuji'ṉ jamaji'ṉ. Jetsetique't øtz mumu Pø'nis chøn Tyøvø øtz ca'upø maṉba it tzatøjcomo tu'cay jama chu'ji'ṉ jamaji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive cumgu'yomda'mbø pø'nis cyøma'nøyaju ti o chambucsi Jonasis, y qui'psvitu'yaju. Jic jama cuando Diosis maṉba cyøme'chaj mumu pøn cyojaji'ṉ, entonces Nínive cumgu'yomda'mbø maṉba tumø'ityaje yøtita'mbø pønji'n y maṉba istøji que más vøti yøtita'mbø pø'nis cyoja. Porque yøti yø'c ijtøjtzi más myøja'ṉombø chøṉ que ji'n Jonás, y ji'n ø va'ṉjamyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jic jama cuando Diosis maṉba cøme'chaj mumu pøn cyojapit; jic aṉgui'mbapø yomo minupø sujromo va'cø tyu'n ya'møcpø aṉgui'mba Salomón, je yomo maṉba te'ñaje yøti ityajupø pønji'ṉ Diosis vyi'naṉdøjqui; y yomo'is maṉba yaj queje que más ityaj cyoja yøti ityajupø pønis ñe' que menos je'is ñe'. Porque je yomo minu más ya'i nasomo va'cø cyøma'nøy Salomo'nis qui'psocuy, y yø'c it øjtzi más qui'psocu'yøyupø que ji'n Salomón, y ji'n va'ṉjamyaj øjtzi yøti ityajupø pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","”Cuando yatzi'ajcu'is chacpa pøn, je yatzi'ajcuy maṉba viti tøtzø nasomo va'cø mye'tz jut muspa sapøcø, y ji'n pya'te. ");
INSERT INTO zosNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Entonces nømba yatzi'ajcuy: “Øtz mismo pø'nomo ma'nbø vitu'que'te ju'tø pujtumø”. Cuando nu'cpa pyujtumø, pya'tpa pø'nis chocoy como tøc jojquipø, ocpejtupø, y vøjøtzøjcupø. ");
INSERT INTO zosNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Entonces mye'tzaṉøpya cu'yay espiritu tøvø más yatzita'mbø que ji'n ñe'cø. Y tøjcøyajpa va'cø ityaj mismo tumbø pø'nis choco'yomo jutipø'omo vi'na pujtumø. Y jetse más peor tucpa jic pøn que ji'n vi'na ijtusena'ṉ. Jetseti ma tucyajque'te yatzita'mbø pøn ityajupø yøti. ");
INSERT INTO zosNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús nømna'ṉ vyejvejneyaj pønji'ṉ y miñaj Jesusis myama y myuquita'm. A'ṉgom tzø'yaju, sunbana'ṉ 'yo'nøyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Y tum pø'nis ñøjay Jesús: ―Jeni nø tye'ñaj mi mama y mi muṉguita'm a'ṉgomo. Sunba mi 'yo'nøyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesusis 'yaṉdzoṉu chajmayupø'is: ―Ma'ṉbø mi ndzajmay i ø mama y i ø muṉgui. ");
INSERT INTO zosNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Entonces Jesusis qui'psøjayaj cyø'ji'ṉ ñøtuṉdøvø y nømu: ―Jic øjtzø mama, jic øjtzø muṉguita'm. ");
INSERT INTO zosNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porque aunque jutipø chøcpa'is tzajpom ijtupø ø Janda Diosis syunbase, jicø øjtzø muṉgui, øjtzø mama. ");
INSERT INTO zosNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Je mismo jama tzu'ṉ Jesús tyøjcomo y maṉ po'cse majraṉvini. ");
INSERT INTO zosNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pero como cyønu'co'ñaj vøti pø'nis, tøjcøy Jesús barco'omo y jen po'csu. Y vøti pøn jen tzø'y majraṉvini. ");
INSERT INTO zosNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Y Jesusis vøti aṉma'yocuy cha'maṉvajcu. Chamu jujche yosnømbase nascøsi va'cø tø aṉmayø. Yøcse nømu: ―Ijtuna'ṉ tum pøn, tzu'ṉu va'cø maṉ vijcøy tømbu nastajecøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Cuando nømna'ṉ vyijcu tømbu, vene quecyaj tu'ṉomo y jyu'cyaju paloma'is. ");
INSERT INTO zosNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Y vene quecyaj tza'cøs ijtumø tzeja nas. Y tumø ora nayu porque nasatzejati. ");
INSERT INTO zosNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero cuando put ja'maṉsøṉ, poṉga'u; nascøtøjtzøyu porque ja tøjcøy jojmo vyatzi. ");
INSERT INTO zosNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Y vene apijta'nø'omo quecyaju, y ye'ṉyaj ta'nø, ñu'scøpajcøyu ta'nø'is, y ja chocyaj nipi. ");
INSERT INTO zosNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero vene quec vøjpø nasomo, y tzojcu, tø'maj vøjø. Vene'cse'nomo tum kilo nijpu chi' mosis kilo; vene'csye'ṉomo tum kilo nijpu chi' sesenta kilo; y vene'csye'ṉomo tum kilo nijpu chi' veinte kilo. ");
INSERT INTO zosNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ijtam mi ṉgoji, ¡cøma'nøtyamø! ");
INSERT INTO zosNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Entonces ñøtuṉdøvø'is cyømiñaj Jesús, min 'yocva'cyaje: ―¿Ti'ajcuy ndzamba jujche yosnømbase nascøsi jetse va'cø mi aṉma'yoya? ");
INSERT INTO zosNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesusis 'yaṉdzoṉu ñøjmayaju: ―Porque mijtzi mi yac mustamba Diosis lo que ni i ja yac mus vi'nati jujche aṉgui'mba Tzajpombø, pero eyata'mbø pøn ja yac musyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Porque ñø'ijtupø'is qui'psocuy va'cø cyønøctøyøyø, tzi'aṉøtyøjpa más qui'psocuy más vøti va'cø cyønøctøyøyø, y ja itøpø'is qui'psocuy va'cø cyønøctøyøyø, yac jøcøjatyøjpa lo que ñø'ijtupø usyi. ");
INSERT INTO zosNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Por eso ndzajmayajpa historia; porque a'myajpa pero ji'n isyaje; y myañajpati pero ji'n cyøma'nøyaje, ni ji'n cyønøtøyøyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mismo jetseti chøcyajque'tpa como chamuse tza'maṉvajcopyapø Isaiasis. Isaías nømu: Mi manjo'ndyamba, pero ji'n mi nøctøyøtyame, Mi isjo'tyambati, pero ji'n mi mustame tiyø nø mi ⁿistamu. ");
INSERT INTO zosNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porque choco'yom yøṉ pø'nis ji'n syunaj vøjpø tiyø, y ji'n cyøma'nøyaje cyoji'is, y itzco'tzneyajpa. Porque o'cana'ṉ ji'n jetse, isyajpatina'ṉ vyitø'mis; myañajpana'ṉ cyoji'is, y nøctøyøyajpana'n choco'yomo, y vitu'yajpana'ṉ øjtzøcø'mø, y øtz ⁿyaj cotzocyajpana'ṉtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","”Pero mijtzi contentoco'ni mi ijtamu porque mi istamba mi vindø'mis y mi myandamba mi ṉgoji'is. ");
INSERT INTO zosNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Porque viyuṉse mi ndzajmatyamba que sone ya'møcpø tza'maṉvajcoyajpapø'is y vøjta'mbø pø'nis sunbana'ṉ isyajø lo que mitz mi istambase, pero ja isyajø. Y sunbana'ṉ myañajø lo que mitz mi mandambase, pero ja myañajø. ");
INSERT INTO zosNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","”Yøti cøma'nøtyamø; maṉba mi ndzajmatyame ti sunba cham tømbu aṉma'yocu'is. ");
INSERT INTO zosNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Como tømbu quecpa tuṉgøsi y jyu'cpa paloma'is, jetsetique't cuando pø'nis myanba Tzajpombø'is 'yaṉgui'mguy y ji'n nøctøyøyi, entonces minba yatzipø y yac tzu'ṉapya chococøspø ote lo que nu'c chococyøsi como tømbu quecpase nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Y como vene tømbu quecyaj tzejamø nas tza'cøsi, jetseti itque't pyøjcøchoṉu'is Diosis 'yote yøti, y casøyajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero como tømbu'is 'yune ja choca, jetsetique't pø'nis usyaṉ ora vya'ṉjamba, pero cuando nøm isu'c toya y yacsutzøctøjpa porque vya'ṉjamba Diosis 'yote, entonce jyajmbø'pa, ji'nam vya'ṉjajme. ");
INSERT INTO zosNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Y como vene tømbu quec ta'nø'omo y apijta'nø'is ja choca, jetsetique't vene pø'nis cyøma'nøjayajpa Diosis 'yote, pero qui'pspa jujche va'cø cyøjtay jama, y qui'pspa va'cø ricu'ajø, y Diosis 'yote ji'ṉ chøjcay cuenda. Entonces ni ti ja itø. ");
INSERT INTO zosNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Y como vene tømbu quecyaj vøjpø nasomo, jetsetique't it cyøma'nøjayu'is Diosis 'yote y cyønøctøyøpya y vøj itpa. Y como vene'csye'ṉomo tum kilo nijpu chi' mosis, y vene'csye'ṉomo sesenta, y vene'csye'ṉomo treinta; jetseti pøn vene vø'ajyajque'tpati vøti y vene vyø'ayajpa usyta'm. ");
INSERT INTO zosNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Chajmayaj Jesusis eyapø aṉmacuy, nømu: ―Como ñasom ñijpu pø'nis vøjpø tømbu, jetsetique't tzajpombø Diosis 'yaṉma'yocuy. ");
INSERT INTO zosNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Porque ñajsom ñip vøjpø tømbu. Entonces øṉyaju'csye'ṉom pøn, min vø'nipi'is 'yenemigo, y je'is ñijpay yachta'nø trigo'omo, y maṉu. ");
INSERT INTO zosNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Y nay trigo y cuando min po' jyøyø, entonces quejque'tuti yachta'nø. ");
INSERT INTO zosNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Entonces cyoyosyajpapø pø'nis cyønu'cyaj vø'nipi y ñøjayaju: “Señor, como vøjpø tømbu mi nijpu nasomo, ¿jutznøm nay yach ta'nø?” ");
INSERT INTO zosNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Y vø'nipi'is ñøjayaju: “Ø enemigo'is jetseti tzøjcayu”. Entonces yosyajpapø pø'nis ñøjayaj vø'nipi: “¿Vøjøm ndø cøvisø?” ");
INSERT INTO zosNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero vø'nipi'is ñøjayaju: “Ji'nda, porque o'ca mi ⁿvispa yach ta'nø, parejo maṉba visputque't trigo. ");
INSERT INTO zosNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mejor tzactamø va'cø tumø ye'ṉø hasta que ndø tucpa. Entonces ma'ṉbø ⁿnøjayaj tyucyajpapø'is: Vi'na vispujtam yachta'nø y vajtaṉdø'pø va'cø ndø poṉdam juctyøjcomo. Y trigo cojtamø aṉne'cu'yomo”. ");
INSERT INTO zosNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesusis chajmayajque't eyapø aṉma'yocuy, nømu: ―Como mostaza tømbuse lo que pø'nis pyøjcu y ñijpu yoscuñasomo, jetsetique't tzajpombø aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Viyuṉse mostaza tømbu más chøtøtya'mbø que eyapø tømbu, pero cuando tzocpa, møja'ajpa pyoc más que eyata'mbø nipi, como cusye møja'ajpa, y miñajpa sitityajpapø paloma y chøcyajpa ño'sa 'yaṉmaṉgøsi. (Jetseti Diosis 'yaṉgui'mguy møja'ajque'tpa). ");
INSERT INTO zosNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesusis chajmayajque't eyapø aṉma'yocuy; nømu: ―Como yaj qui'mbapø'is pan, jetseti tzajpombø aṉgui'mguy. Tum yomo'is pyøc usyi yaj qui'mbapø'is pan y myot tu'cuy muquipø harina vaye'omo. Y usypø'isti yaj qui'mba mumu aunque ji'n cyeje. (Jetsetique't Diosis 'yaṉgui'mguy qui'mbati maṉba). ");
INSERT INTO zosNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mumu yøcseta'mbø tiyø cha'maṉvajcayaj Jesusis vøti pøn. Siempre chamu mumu ti ndø ispa yø'c nascøsi, entonces cha'maṉvajcu que Diosis 'yañma'yocuy jetsetique't. ");
INSERT INTO zosNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jetse chøc Jesúsis va'cø yac viyuṉajø lo que Diosis ñucscu'is cha'maṉvac vi'napø ora'omo. Diosis ñu'cscuy nømu: Ma'ṉbø ndzam mumu ti nascøs ndø ispase y entonces ma'ṉba ndza'maṉva'c que jetseti Diosis 'yaṉma'yocuy. Jetse øtz ma'ṉbø ndza'maṉvajcayaje lo que ni i'sna'ṉ ji'n myusi vi'na desde que jomectøju nasacopac. ");
INSERT INTO zosNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Entonces Jesusis ñøjmayaj vøti pøn va'cø myaṉyajø, y Jesús tøjcøy tøjcomo. Y ñøtuṉdøvø'is cyønu'cyaj Jesús y ñøjayaju: ―Tø tza'maṉvajcatyamø tiyø aṉma'yocuyete yachta'nø nijpupø yoscuñasomo. ");
INSERT INTO zosNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Entonces Jesusis ñøjayaju: ―Ñijpapø'is vøjpø tømbu øjchøṉø, mumu Pø'nis chøn Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Y yoscuñas, nasacopajquete; y vøjpø tømbu, vya'ṉjamyajupø'is Diosis 'yaṉgui'mguy. Yachta'ṉø, vya'njamyajpapø'is yatzi'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y ñijpupø'is yachta'nø, diablo'isete. Cuando yajpa'c nasacopac, entonces tyucyajpa tøm; tyucyajpapø'is aṉgelesta'mete. ");
INSERT INTO zosNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jetsemete como jujche vyajtandø'pyajpa yachta'nø y pyoṉbø'yajpa juctyøjcomo, jetseti ma tujque'te cuando yajpa'c yøṉ nasacopac. ");
INSERT INTO zosNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Øtz mumu Pø'nis chøṉ Tyøvø, øtz ma'ṉbø ṉgø'vejyaj ø aṉgelesta'm va'cø piṉaṉdø'pyaj mumu pøn yac tocoyajpapø'is tyøvø y mumu chøcyajpapø'is yatzitzoco'yajcuy. Y maṉba ñøputyaje va'cø chu'ṉyaj jeni ne'c aṉgui'mbamø. ");
INSERT INTO zosNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Y pi'ṉaṉdø'jpøyajupø maṉba pyajtzøyaj juctyøjcomo. Jiṉ maṉba vejyaje, maṉba tøtz cø'syaj toyapit. ");
INSERT INTO zosNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Entonces chøcyajpapø'is Diosis syunbase maṉba sø'ṉyaj como jamase ndø Janda Diosis itcu'yomo. Ijtu mi ṉgojita'm ¡cøma'nøtyamø! ");
INSERT INTO zosNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","”Como tumin nipcøvø'nupø yoscuñasomo, jetsetique't tzajpombø aṉgui'mguy. Cuando pø'nis pya'tpa tumin aṉgøvø'nupø yoscuñasomo, mismo jiṉdi cyøvø'ngue'tpa, y casøpya y maṉba y mya'apya mumu lo que ñø'ijtupø, va'cø jyuy nas jut pya'tumø tumin. ");
INSERT INTO zosNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","”Jetsetique't como tum namcha ma'a vitu'vitu'opyapø myetzpapø'is vøjta'mbø namcha, jetseti tzajpombø aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cuando pø'nis pya'tpa más suñi quenbapø namcha, más coyoja'øyupø, entonces maṉba y mya'ajpa mumu lo que ñø'ijtupø va'cø mus jyuy jic coyoja'øyupø namcha. ");
INSERT INTO zosNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","”También jujche ataraya nacsyajpa nø'cø'mø, jetsetique't tzajpombø aṉgui'mguy. Ataraya nacsyajpa nø'cø'mø y ñujcaṉdø'pdø'pvøyajpa aunque juchpø coque. ");
INSERT INTO zosNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cuando taspa ataraya, jyøcøputyajpa acapoya y po'cschø'yajpa va'cø piṉyaj coque. Vøjta'mbø cyotyajpa vaca'omo, y ji'n vyøjta'mbø pyatzputputvøyajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jetseti ma chøjque't Diosis cuando yajpa nasasacopac. Maṉba vitputyaj aṉgeles va'cø piṉaṉdø'pyaj vøjta'mbø pøn, y ji'n vyøjta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ji'n vyøjta'mbø maṉba pyajtzøyaj juctyøjcomo. Jiṉø maṉba vejyaje vo'yaje, maṉba cyø'syaj tyøtz toyapit. ");
INSERT INTO zosNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Entonces 'yocva'cyaju Jesusis: ―¿Nømdija mi ṉgønøctøyøtyamu yøcseta'mbø aṉmacuy? Y 'yandzoṉyaju: ―Jø'ø, nømdi nøctøyøtyamu. ");
INSERT INTO zosNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Y Jesusis ñøjayaju: ―Por eso mumu 'yaṉmapyapø'is aṉgui'mguy, o'ca 'yaṉmapya jujche 'yangui'mbase tzajpombø Dios, entonces jic pø'nis chøcpa como tum vø'tøjquis chøcpase cuando ñøputpa 'yaṉne'cpamø jometa'mbø tiyø y pecata'mbø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Cha'maṉjej Jesusis jetsepø aṉma'yocuy, y cuando cøjtu, tzu'ṉu. ");
INSERT INTO zosNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ñu'c ñe' cyumgu'yomo. Jiṉ aṉma'yopyana'ṉ conocscutyøjcomo. Y ñømaya'yajpana'ṉ 'yaṉma'yocuy y nømyaju: ―¿Jut musoy jicø, va'cø mus chøc yøcsepø milagro'ajcuy? ");
INSERT INTO zosNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pues yøṉømete carpintero'is 'yune, y myama Mariate, y yø'c ityaj myuqui Jacobo, José, Simón, y Judas. ");
INSERT INTO zosNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Y yø'c ityaj myuqui yomota'mbø øjtzomda'm. ¿Jut jetse musoyu? ");
INSERT INTO zosNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Por eso cyonocyaj Jesús. Pero Jesusis ñøjayaju: ―Mumu vyøpøpøngotzøcyajpa tum tza'maṉvajcopyapø, pero ñe' ñasomda'mbø'is y ñe' tyøjcomda'mbø'is ji'n vyøpøpøngotzøcyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Y por eso ja chøcyaj Jesusis vøti milagro'ajcuy jiṉø porque ja vya'ṉjamdøjø. ");
INSERT INTO zosNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jicø tiempo'omo aṉgui'mbapø Herodesis myusu tina'ṉ nø chøc Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Y Herodesis ñøjayaj myenosti aṉgui'myajpapø: ―Yønømete Juan nø'yø'opyapø visa'upø. Jetcøtoya muspa chøc milagro'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Porque Herodesis vi'ña'ṉi o yac nuctøj Juan y yac mocstøju cadenaji'ṉ y yac somdøju. Entonces ijtuna'ṉ Herodesis myuqui Felipe, y ijtuna'ṉ Felipe'is yomo Herodías. Herodesis yac somdøj Juan porque jic yomo Herodiasis jetse syunu. ");
INSERT INTO zosNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jetse syunu porque Jua'nis ñøjapyana'ṉ Herodes: ―U mi nø'ijtay mi muṉgui Felipe'is yomo porque cojate. ");
INSERT INTO zosNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Sunbana'ṉ yaj ca' Juaṉ Herodesis, pero ña'chajpana'n vøti pøn, porque mumu pø'nis vya'ṉjamyaju que Jua'ṉis cha'maṉvacpa Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero cuando o cosø'ṉayaj Herodesis cyumpli'años, Herodiasis yom'une ejtzu vejyajtøjupø'is vyi'naṉdøjqui, y yac tzi'ṉu Herodesis. ");
INSERT INTO zosNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Entonces Herodesis ñøjay papiñomo que maṉba chi' ti sunba vya'cø, nømu que va'cø cyastigatzøc Diosis o'ca ji'n chi'i. ");
INSERT INTO zosNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Entonces papiñomo'is myama'is chajmay ti syunba va' vya'cø, y papiñomo'is ñøjay Herodes: ―Tø tzi'ay nø'yø'opya Jua'nis cyopac pulatu'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Entonces maya' aṉgui'mba Herodes, porque na'tzpa yaj ca'ø. Pero como chambøjcay Diosis ñøyi que maṉba chi' ti syunba vya'cø, y ñe'cji'ṉ po'csyaj mesacø'mo, je'is myañaju que jetse chajmayu, entonces 'yaṉgui'mu va'cø chi'yajø. ");
INSERT INTO zosNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","'Yaṉgui'mu va'cø cyo'cøtø'csø Juan preso'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Y cuando cyo'cøtøcsu, ñømijnayaj cyopac pulatu'omo y chi'yaj papiñomo y je'is myama chøcøtzi'u. ");
INSERT INTO zosNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Entonces parejo vityajpapøji'ṉ Juan nu'cyaju y pyøjcayaj cyoṉna y ñijpayaju. Entonces después maṉ chajmayaj Jesús o'ca yaj ca'tøj Juan. ");
INSERT INTO zosNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cuando Jesusis myusu, tzu'ṉ jeni, barco'om tøjcøyu tyumgø'y, maṉ emøc. Ni i ja ityømø maṉu. Pero cuando myusyaj vøti pø'nis, maṉ pya'tyaj Jesús. Tzu'ṉyaj ne'cø cumguy nas vitpa maṉyaju maṉ mye'chaj Jesús jut pya'tyajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Entonces cuando put Jesús barco'om, is vøti pøn. Entonces tyoya'ṉøyaju. Pya'tyaj ca'eta'mbø, yac tzocyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cuando tza'i'ajnømu, cyønu'cyaj Jesús ñøtuṉdøvø'is, ñøjayaju: ―Yø'c tza'momdite, ni ti ja itø, y maṉbam tzu'i'ajnømi. Yaj cu'tcumye'chaj vøti pøn ityajumø cumguy. ");
INSERT INTO zosNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero Jesusis ñøjayaj ñøtuṉdøvø: ―Ji'ndyet pyena va'cø myaṉyaj emøc; mitz tzi'yaj cu'tcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Y je'is ñøjayaj Jesús: ―Nø'ijta'møjtzi na's mosay pandite, y metzcuy coque. ");
INSERT INTO zosNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesusis ñøjayaju: ―Yø'c nømindamø. ");
INSERT INTO zosNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Y 'yaṉqui'myaj Jesusis pøn: ―Po'cstam mu'como. Entonces pyøc Jesusis mosay pan y metzcuy coque y quengui'm møji tzajpomo, y cyømasa'nøyu. Entonces vyen pan vye'ndzi'yaj ñøtuṉdøvø y ñøtuṉdøvø'is vye'ndzi'yaj sone pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Y mumu cu'tasyaju. Y entonces cuando cu'tyaju'cam, piṉdasyaju macvøstøjcay vaca cyu'tzacyajupø panji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Puro pøndi myayaj mosay mil cyu'tyaju'is pan. Ja myayaj yomo y une. ");
INSERT INTO zosNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jicsye'cti Jesusis yac tøjcøyaj ñøtuṉdøvø barco'omo yac vi'na jacyaju nø'cøtu'møṉ mientras ñe'c ñøjayaj vøti pøn va'cø myaṉyaja'am. ");
INSERT INTO zosNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yac maṉyaju'cam vøti pøn, entonces ñe'c Jesús qui'm cotzøjcøsi va'cø 'yo'nøy Dios tyumgø'y. Cuando tzu'i'ajnømu, Jesús tyumdi tzø'y jeni. ");
INSERT INTO zosNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mientras que barco nømna'ṉ myaṉ marcucmø, nømna'ṉ yac tze'ṉmin tze'ṉmaṉ barco nø'is, porque sava'is ja yac tu'ṉaj barco. ");
INSERT INTO zosNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cuando maṉba'ctøc sø'ṉbønømi cuando pi'tzøctøc, Jesusis cyønu'cyaju, nø'vingøsna'ṉ nø vyijtu. ");
INSERT INTO zosNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cuando isyaj ñøtuṉdøvø'is nø' vingøs nø vyijtupø, chøcna'chaju, y na'tze vejyaju nømyaju: ―Anima nø vyijtu. ");
INSERT INTO zosNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero Jesusis 'yo'nøyaju ñøjayaju: ―Uy chocomochi'ajtame, øjti chøṉø; uy ña'tztame. ");
INSERT INTO zosNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Entonces Pedro'is ñøjayu: ―Øjtzø mi Ngomi, o'ca mijtzete, aṉgui'mø jetseti nø' vingøsi va'cø vitque't øjtzi; hasta jut mi ijtumø mijtzi, jendi va'cø nu'que't øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesusis ñøjayu: ―Yø'c minø. Y mø'n Pedro barco'omo y nø' vingøsi vijtu va'cø ñu'c Jesuscø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero cuando isu que pømi nø pyoy sava, chøcna'tzu; y cøvøṉdzo'tz nø'cø'mø. Entonces na'tzeveju, ñøjayu: ―Øjtzø mi Ṉgomi, mi tø yaj cotzoca. ");
INSERT INTO zosNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jicsye'cti jyascøtøjcøy cyø'cøs Jesusis; ñøjayu: ―Ji'ndyet mi 'yomba va'ṉjajmoye. ¿Ticøtoya mi myetzaṉgui'pspa? ");
INSERT INTO zosNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Entonces cuando tøjcøyaj barco'om, poya'ṉjej sava. ");
INSERT INTO zosNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Entonces ityajupø barco'omo cyutcøne'cayaj Jesús y ñøjayaju: ―Viyuṉete mijtzete Diosis 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Entonces jyacyaj mar, maṉyaj marcøtu'møṉ, y nu'cyaj Genesaret nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Y como ispøcyaj Jesús jiṉda'mbø pø'nis, cyø'vejyaj ote mumu tometa'mbø lugajromo que nu'c Jesús. Jetcøtoya ñømijnayaj jeni mumu ca'eta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Y ñøjayaju: ―Tø yac pi'quisay aunque sea mi nducu aṉbena. Y pi'quisayaju'is tyucu cøyin dzocyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Entonces miñaj 'yaṉmayajpapø'is Moisesis 'yaṉgui'mguy y fariseota'm. Jerusalén gumgu'yomo tzu'ṉyaju cyønu'cyaj Jesús y ñøjayaju: ");
INSERT INTO zosNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Ti'ajcuy ji'n chøjcayaj vi'nata'mbø'is cyostumbre mi nønduṉdøvø'sta'm? Porque cuando maṉba cu'tyaje, ji'n cø'che'yaje en la forma como vi'nata'mbø'is chamyajuse va'cø tø cø'che'ø va'ṉjajmocucyøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pero Jesusis 'yaṉdzoṉyaju, ñøjayaju: ―Y mitzta'm, ¿ti'ajcuy ji'n mi ṉgo'aṉjamdamø lo que Diosis chamupø tiyø cuando mi ndzøctamba mi ṉgostumbreta'm? ");
INSERT INTO zosNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porque Dios aṉgui'mu: “Cøna'tzøy mi janda y mi mama. Y yatzicotzøcpapø'is jyata o myama, tiene que va'cø cya'ø”. ");
INSERT INTO zosNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero mitz ñømdamba que o'ca pø'nis ñøjapya jyata o myama: “Ji'n mus mi ṉgotzova porque lo que maṉbapøna'ṉ mi ndzi', Diosis yoscucyøtoya ndzi'umtzi”. ");
INSERT INTO zosNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Y mi ñømdamba que o'ca pøn nømba jetse, ji'ndyet pyena va'cø cyotzoṉ jyata o myama. Jetze ji'n mi ndzøctame lo que Diosis chamuse va'cø ndø tzøcø, va'cø mi ndzøctam mi ṉgostumbreta'm. ");
INSERT INTO zosNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mi 'yaṉgøma'cø'otyambapøte, viyuṉ chamu tza'maṉvajcopyapø Isaiasis jujchepø mi mbyønda'mete cuando jyayu que Dios nømu: ");
INSERT INTO zosNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yøṉ pø'nis na's 'yaṉnacaji'ṉdi vøcotzøcyajpøjtzi, pero ji'n ø va'ṉjamyaje choco'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Como que va'ṉjamyajpase nø chøcyaju y ji'nø va'ṉjamyaje, porque aṉma'yoyajpa pø'nisti 'yaṉgui'mguji'ṉ como si fuera ø ne'ji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Entonces Jesusis vyejnu'cyaj vøti pøn vyingø'mø y ñøjayaju: ―Cøma'nøtyamø va'cø mi ṉgønøctøyøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ji'n tø yatzi'aj ndø cu'tcu'is lo que tøjcøpyapø ndø aṉna'como. Sino tø yatzi'ajpa lo que ndø aṉnaṉga'stit ma chame. ");
INSERT INTO zosNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Entonces cyønu'cyaj Jesús ñøtuṉdøvø'is y ñøjayaju: ―¿Mi ndzøjcayutija cuenta o'ca qui'sca'yaj fariseo cuando myañaj lo que mitz ndzamuse? ");
INSERT INTO zosNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero Jesusis ñøjayaju: ―Tzøj cuenda que como ta'nø ndø vispø'pase, jetsetique't aṉma'yoyajpapø aunque jujchepø aṉgui'mocuji'ṉ lo que ji'ndyet tzajpom ijtupø ndø Janda Diosis ñe, Diosis maṉba yajaye. ");
INSERT INTO zosNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Por eso jic fariseota'mgue't tzac yenbø'yajø. Como to'tipø pønse ityajpa. O'ca to'tipø'is ñøvitpa to'ti tøvø, maṉba quecyaj mye'chcø'y tzatøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Entonces Pedro'is ñøjay Jesús: ―Tø tza'maṉvajcayø jetsepø aṉma'yocuy. ");
INSERT INTO zosNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús nømu: ―¿Ti'ajcuy ni mitz ji'n mi ṉgønøctøyøtyaṉgue'te? ");
INSERT INTO zosNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Porque mi mustambati que mumu lo que tøjcøpya ndø aṉna'como mø'nba ndø tzejcomo, y jøsi'cam putque'tpati. ");
INSERT INTO zosNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero lo que putpa ndø aṉnaca'omo, ndø tzoco'yom tzu'ṉba y je'is tø yatzi'ajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porque pø'nis choco'yomda'm putpa yatzipø qui'psocuy, qui'pspa va'cø yaj ca'oya, va'cø cyøtzøjcøy pyøndøvø yomocøsi, va' myøtzi nø'it yomo, va'cø ñu'mø, va'cø syutzø, va' che'moya. ");
INSERT INTO zosNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jetseta'mbø ti'is yatzi'ajpa pøn. Pero ja cyø'che'a, jetse va'cø tø vi'cø, ji'n tø yatzi'aj jetse. ");
INSERT INTO zosNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Entonces tzu'ṉ jen Jesús, maṉ emøc maṉ cyo'aṉjajmbamø Tiro y Sidón cumgu'is. ");
INSERT INTO zosNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jendina'ṉ it tum yomo Canaan nasomo tzu'ṉupø. Minu, vyejay Jesús, ñøjayu: ―Øtzø mi Ṉgomi, Davijdis mi 'yune, tø toya'ṉøyø. Ijtu ø yom'une nø yacsutzøjcupø yatzi'ajcu'is y vøti toya'ispa. ");
INSERT INTO zosNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ja 'yandzoṉ Jesusis ni jujche. Entonces miñaj Jesusis ñøtuṉdøvø y ñøjayaju: ―Yac maṉ jic yomo, porque vejpa minba ø jøsaṉgø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Entonces Jesús nømu: ―Diosis cø'vej øjtzi va'cø ṉgotzoṉ saṉ Israel cumgupyøn lo que ityaju tocoyajupø borregose. ");
INSERT INTO zosNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero yomo'is cyønu'c tome Jesús y cyutcøne'cayu y ñøjayu: ―Øjtzø mi Ṉgomi, mitz tø cotzova. ");
INSERT INTO zosNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Y Jesusis 'yaṉdzoṉu: ―Ji'nø mus mi ṉgotzova porque mitz ji'ndyet mi Israel pøn, y va'cø ṉgotzoṉ ji'dyet Israel pøn es como va'cø ndø cøpøc une cyu'tcuji'ṉ, tuyi va'cø ndø tzi'ayø. ");
INSERT INTO zosNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Y yomo'is ñøjay Jesús: ―Pues viyuṉbø ti mi ndzamba, øjtzø mi Ṉgomi, pero aunque mi ndø tuyicotzøca, tø cotzøva; porque hasta tuyi'is piṉyajpa cøvi'caṉ quecpapø cyomi'is myesacøtøjcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Entonces 'yandzoṉ Jesusis: ―Tzamyomo, vøj mi vya'ṉjajmombya. Yac tuc mi sunbase. Jicsye'c misma hora tzoc 'yune. ");
INSERT INTO zosNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Entonces Jesús ijtumø tzu'ṉu y cøt Galilea majraṉvini. Entonces qui'm cotzøjcøsi y jen po'cschø'yu. ");
INSERT INTO zosNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Y cyønu'cyaj vøti pø'nis. Ñømiñaj cømø'ṉgaṉyajpapø, y to'tita'mbø, y umata'mbø, yacsyuta'mbø, y vøti eyaco ca'cuji'ṉbø; y cyojtayaju Jesusis cyosocø'mø, y Jesusis yac tzocyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jetse vøti pø'nis myañaju nø vyejvejneyaju umata'mbø, isyaj que tzocyaju'am yacsuta'mbø, nøm vyityaj vøjø cømø'ṉgaṉyajpapø, to'tita'mbø isoyajpa'am. Entonces vøti pø'nis ñømaya'comø'ñaju myøjaṉ vøcotzøcyaj Dios lo que cyotzoṉyajpapø'is Israel pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Entonces Jesusis vyejayaj ñøtuṉdøvø y ñøjayaju: ―Yøṉ pønda'm ndoya'ṉøyajpøjtzi porque tu'cay jama ityajpamø øtzji'ṉ yø'qui y ja it ti va'cø cyu'tyajø. Ji'n suni yac maṉyajø jana cu'ti, uytim myochquecyaj tu'ṉomo ose'is. ");
INSERT INTO zosNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Entonces ñøjayaj Jesús ñøtuṉdøvø'is: ―Pero ¿jut ndø pa'tpa cu'tcuy va'cø cu'tasyaj vøti pøn yø'qui ni i ja ityømø? ");
INSERT INTO zosNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Y Jesusis 'yocva'cyaju: ―¿Jujche mi nø'ijtam pan? Y ñøjayaju: ―Cu'yay, y metz tu'cay namgoque. ");
INSERT INTO zosNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Entonces ñøjayaj vøti pøn: ―Po'csta nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Entonces pyøc cu'yay pan y namgoque; cyø'ji'ṉ cho'ṉu y ñøjay Dios: “Yøscøtoya”. Entonces vyen ve'nu vyendzi'yaj ñøtuṉdøvø'omo, y je'is syajyaju vøti pø'nomo. ");
INSERT INTO zosNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Y mumu cu'tasyaju. Y después piṉyaju lo que tzø'yupø y cu'yayna tasque't vaca. ");
INSERT INTO zosNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Y cu'tyajupø macsycuy mil pønda'mna'ṉete. Ja myayajø yomo y une. ");
INSERT INTO zosNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Entonces Jesusis yac maṉyaj vøti pøn. Ñe'c Jesús tøjcøy barco'omo y maṉ Magdala nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo aṉma'yocuy ñø'ijtayajupø'is y saduceo aṉma'yocuy ñø'ijtayajupø'is 'yo'nøyaj Jesús. Sunbana'ṉ 'yaṉgøma'cøyajø a ver o'ca chøcpa cyoja va'cø mus cyøtza'møyajø. Vya'cayaju Jesús va'cø chøjcayaj milagro'ajcuy va'cø a'mdøjø que ñø'ijtay tzajpomopø Diosis pyømi. ");
INSERT INTO zosNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero Jesusis 'yaṉdzoṉyaju: ―Tza'i'cam mi ñømdamba: “Maṉba vø'ajnømi porque it tzapas o'na”. ");
INSERT INTO zosNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y namdzu mi ñømdamba: “Ma min tuj, it tzapas o'na y pi'tzø'ajco'nømu”. Mitz vøj mi ndzøctamba mi ⁿvin pero ji'ndyet ⁿvyøjta'mbø pøn. Porque muspa mi ṉgøque'nøtyamø ti cyotzamba tzajpis, pero ti nø tyujcu yøṉ tiempo'omo, ji'n mi ṉgue'nøtyame. ");
INSERT INTO zosNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yatzita'mbø y cøtzøjcø'yoyajpapø pø'nis sunba isyaj milagro'ajcuy, pero ji'n ma isyaj ni jujchepø milagro'ajcuy; sino jujche tujcuse tza'maṉvajcopyapø Jonás, jet señate que jujche maṉba tuqui. Y chacyaj Jesusis, maṉ emøc. ");
INSERT INTO zosNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cuando Jesusis ñøtuṉdøvø jacyaj marcøtu'møṉ, jya'jmbø'yaj va'cø ñømaṉyaj pan. ");
INSERT INTO zosNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Entonces Jesusis ñøjayaju: ―U mi mbøjcøchoṉdamu yaj qui'mbapø'is pan fariseo'is y saduceo'is ñe'ta'm que ji'ndyet vyøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Y ñøtuṉdøvø'is nømna'ṉ qui'psyaju y na ñøjayajtøju: ―Jetse ocsyo nømba porque jay ndø nømindam øtz pan. ");
INSERT INTO zosNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Cuando myus Jesusis ti nø qui'psyaju, ñøjayaju: ―Usyti mi va'ṉjajmondyambapøte. ¿Ti'ajcuy jetse mi ⁿvyejvejnendyamba que ja mi nømindam pan? ");
INSERT INTO zosNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ji'ndøc mi ṉgønøctøyøtyame ni ji'n mi jamdame. Cuando venve'nøjtzi mosay paṉ mosay mil pø'nomo, jamchø'tyamø jutzø vaca oy mi mbiṉdame. ");
INSERT INTO zosNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Y cuando venve'nøjtzi cu'yay paṉ macsycuy mil pø'nomo, jamdaṉgue'ta jutzø vaca o mi mbiṉdame. ");
INSERT INTO zosNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ti'ajcuy ji'n mi ṉgønøctøyøtyame que ji'ndyet paṉ nø ndzamu cuando mi ⁿnøjandya'møjtzi va'cø jana mi mbøjcøchoṉdamø yaj qui'mbapø'is pan fariseo'is y saduceo'is ne'ta'm? ");
INSERT INTO zosNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Entonces cyønøctøyøyaju ñøtuṉdøvø'is que ji'ndet yaj qui'mbapø'is pan nø chamu, sino va'cø jana pyøjcøchojṉayajø fariseo'is y saduceo'is 'yaṉma'yocutya'm. ");
INSERT INTO zosNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Entonces Jesús nu'cu tome ispamø Cesarea Filipo cumguy y jen 'yaṉgøva'cyaj ñøtuṉdøvø: ―¿Ti chamyajpa pø'nis que ipø pøn chøṉ øjtzi, mumu Pø'nis chøṉ Tyøvø? ");
INSERT INTO zosNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Y ñøjayaju: ―Ñømyajpa vene que mijtzømete nø'yø'opyapø Juan. Eyapø nømyajpa que mijtzømete Elías. Eyapø nømyajpa que mijtzømete Jeremías o eyapø tza'maṉvajcopyapø. ");
INSERT INTO zosNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Entonces Jesusis ñøjayau: ―¿Jujche mi ñømdamba mijtzi que ipø pøn chøṉø øjtzi? ");
INSERT INTO zosNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Y 'yaṉdzoṉ Simón Pedro'is ñøjayu: ―Mijtzømete Cristo, quenbapø Diosise mi 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Y Jesusis ñøjayu: ―Contentoco'ni mijtzi Simón, Jonasis 'yune. Porque ji'ndyet pø'nis mi yac nøctøyøy jetsepø qui'psocuy, sino tzajpom ijtupø ø Janda'is mi yac mijnay mi ṉgui'psocuy jetsepø. ");
INSERT INTO zosNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Øtz mi nøja'mbyøjtzi, mijtzømete Pedro, mijtzømete como tza'se. Y como tza'cøs ño'tzo'chajpa, jetze mitzji'ṉ maṉbø yac nøcøtzo'tz aṉma'yocuy va'cø vyøti'ajyajø va'ṉjamyajpa'stzi. Y yatzi'ajcu'yombø'is va' ñøquipø va'ṉjamyajpapø'is øjtzi, ji'n ma tyone. ");
INSERT INTO zosNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma'ṉbø mi ndzi' aṉgui'mguy va'cø mi yac tøjcøyaj pøn aṉgui'mbamø tzajpombø Dios. Lo que mi ya'inducpa nascøsi, jetse ma tzø'y tzajpomo. Y lo que ji'n mi ya'induc nascøsi, tzajpom ji'ndi ma ya'indujque'te. ");
INSERT INTO zosNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jicsye'c Jesusis 'yaṉgui'myaj ñøtundøvø que va' jana chajmay ni iyø que jetømete Cristo Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jic jama Jesusis cha'maṉvactzo'tzayaju ñøtuṉdøvø que tiene que va' myaṉ Jerusalén gumgu'yomo y que maṉba yacsutzøcyaj tzambø'nista'm y pane covi'najø'is y myusyajpapø'is Moisesis 'yaṉgui'mguy; y maṉba yaj ca'yaje, y tu'cay jamapit maṉba yac visa'tøji. ");
INSERT INTO zosNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Entonces Pedro'is ñøman Jesús emøc y 'yojnayu y ñøjayu: ―Uy jetse tzame, ø mi Ṉgomi. Uy syun Diosis va'cø jana jetse mi ndyucø. ");
INSERT INTO zosNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero Jesusis cyøque'nøy Pedro y ñøjayu: ―Tzu'ṉ øtzcø'mø; Satanasis mi yac tzamba jetse. Nø mi ndø ya'indujcu va'cø jana ndzøc Diosis syunbase. Porque ji'n mi ṉgui'psi como Diosis qui'pspase, sino mi ṉgui'pspa como pø'nis qui'pscøpoyajpase. ");
INSERT INTO zosNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Entonces Jesusis ñøjayaj ñøtuṉdøvø: ―O'ca i'is sunba maṉ pa'tø, tiene que va' i'nbø' vyin, y tiene que va'cø it dispuesto va'cø cya'que'tati como øtz dispuesto'tzi va'cø ca'ø cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Porque o'ca ji'n sun cya'ø øtzcotoya, entonces tocopya, y o'ca ca'pa øtzcøtoya, entonces maṉba pya't quenguy. ");
INSERT INTO zosNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","O'ca pøn ricu'ajpa hasta que ñe'ajpa mumu ijtuse nascøsi y tocopya Diosmø, ¿ti ñøvø'ajpa? Ni tiyø ji'n nøvø'aje porque pø'nis ji'n jujche cyoyoj Dios va'cø chi' quenguy. ");
INSERT INTO zosNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Porque øtz mumu Pø'nis choṉ Tyøvø øtz ma'ṉbø mini ø Janda Diosis myøja'ṉo'majcu'yomo ñe 'yaṉgelesji'ṉda'm. Y jicsye'c ma'ṉbø ndzi'yaj tumdum pøn cyoyoja. Chøjcu'is vøjø ma'ṉbø ndzi' vøjpø cyoyoya, y ja chøcøpø'is vøjø, jetseti ma'ṉbø cyoyojque't ji'n vyøjpø tiji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Viyuṉsye mi ñøjandya'mbøjtzi, ityaj yø'qui mijtzomda'mbø que ji'n ma cya'yaje hasta que isyajpa øjtzi cuando minba øjtzi va'cø 'yaṉgui'mgu'yøyø mumu Pø'nis chøṉ Tyøvø øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Cøjtu'cam tujtay jama, ñømaṉ Jesusis Pedro y Jacobo, y Jacobo'is tyøvø Juan. Y maṉyaj ne'ti ye'ṉupø cotzøjcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Y jiṉø Jesús eyati quenu je'is vyi'naṉdøjqui. Syø'ṉ vyinaca como jamase, y tyucu popo'aju como nø syø'ṉuse. ");
INSERT INTO zosNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jicsye'c quejyaj Moisés y Elías. Jena'ṉ nø chamdzamneyaju Jesusji'n. ");
INSERT INTO zosNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Entonces Pedro'is ñøjay Jesús: ―Ø Ṉgomi, vøj tø tzø'tyam yø'qui. O'ca mi sunba mijtzi, ma'ṉbø ndzøctam tu'cay pe'chtøc øjtzi, tum mitzcøtoya, tum Moisescøtoya, y tum Eliascøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mientras jetse nømna'ṉ cham Pedro'is, min sø'ṉbapø o'na y o'nacøtøjcømø tzø'yaju. Jicsye'c myañaj ote nø vyejput o'na'omo, nømu: ―Yøṉ øjtzø ⁿUne lo que sunbapø øjtzi, je'is tzi'pa gusto. Cøma'nøtyam a ver ti nø chamu. ");
INSERT INTO zosNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cuando Jesusis ñøtuṉdøvø'is myañaju jetsepø ote, japcønecyaj nascøsi porque na'tzaṉgøtyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Entonces min Jesús y pi'quisyaju y ñøjayaju: ―Te'nchu'ṉdamø; u ña'tztame. ");
INSERT INTO zosNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Quende'ñaju, entonces na Jesusti isyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Entonces mø'ñaju cotzøjcøsi y Jesusis 'yaṉgui'myaju: ―U mi ndzajmatyam ni iyø ti mi istamu hasta que øjtzi visa'pøjtzi oyu'cam ca'e øtz mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Entonces ñøtuṉdøvø'is 'yoc'va'cyaj Jesús ñøjayaju: ―¿Ti'ajcuy nømyajpa 'yaṉmayajpapø'is Moisesis aṉgui'mguy que Elías tiene que va' vi'na minø? ");
INSERT INTO zosNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","'Yaṉdzoṉyaj Jesusis: ―Viyuṉsye Elías maṉba vi'na mini y maṉba vyøjøtzøc mumu tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero mi ndzajmatyaṉgue'tpati'tzi que Elías oyu'am, y ja ispøcyaj ipø pønete. Pero chøjcayaju ti syuñajpase pø'nis. Jujche pø'nis yac toya'isyaj jicø, jetseti pø'nis maṉba yac toya'isyajque'te øjtzi mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jicsye'c ñøtuṉdøvø'is cyønøctøyøyaju que Jesusis nømna'ṉ cham nø'yøyopyapø Juan que Eliasse minu. ");
INSERT INTO zosNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cuando Jesús ñøtuṉdøvøji'ṉ nu'cyaj ityajumø vøti pøn, tyo'møy Jesús tum pø'nis y cutcøne'cay Jesusis vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Y ñøjmayu: ―Øjtzø mi Ṉgomi, toya'ṉøjay ø ⁿjaya une porque ñø'ijtu tu'ca'cuy y vøti ispa toya, jø'nø jønø quecpa juctyøjcomo y jetsetique't nø'cø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Y nømijna'yøjtzi ø ⁿune mi nønduṉdøvøji'ṉ, pero ja mus yac tzocyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Entonces Jesusis ñøjayu: ―¡Mi mbyønda'm ji'n mi vya'ṉjajmondyamepø'is y yatzi mi ṉgui'psocutya'm! Aburritzøcpa øjtzi va'cø it mitzji'ṉ, ṉgo'i'nbati mijtzi va'cø mi nømaṉjandyam pasencia. Nømindam yø'c je nga'e. ");
INSERT INTO zosNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Entonces Jesusis 'yojnay yatzi'ajcuy y yac put ṉga'e'is choco'yomo, y misma hora tzojcu. ");
INSERT INTO zosNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Después ne'ti 'yo'nøyaj Jesús ñøtuṉdøvø'is y 'yocva'cyaju: ―¿Ti'ajcuy ja mus nømbujtam øjtzi yatzi'ajcuy? ");
INSERT INTO zosNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Y Jesusis ñøjayaju: ―Porque ji'n mi va'ṉjajmotyam vøjø. Porque viyuṉse mi ñøjandya'mbøjtzi: O'ca mi nø'ijtam va'ṉjajmocuy que møja'ajpa como mostaza tømbu møja'ajpase, y mi nøjandyamba yøṉ cotzøc: “Tzu'ṉ yø'qui y maṉ emøc”; y cotzøc maṉba maṉ emøc. Y ja it ni tiyø ji'n musipø mi ndzøcø. Muspa mi ndzøc mumu tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero yøcsepø yatzi'ajcuy ji'n sun pyutø. Tiene que va'cø ndø o'nøtyam Dios jana cu'tipø va'cø mus ndø macputø. ");
INSERT INTO zosNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Cuando tumø'om vityaj Jesús ñøtuṉdøvøji'ṉ Galilea nasomo, Jesusis ñøjayaju: ―Pø'nis chøṉ Tyøvø øjtzi maṉba tzi'ocuyajtøj pø'nis cyø'omda'm. ");
INSERT INTO zosNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Y pø'nis maṉba yaj ca'yaj øjtzi, y tu'cay jamapit minba yac visa'tøji. Y ñøtuṉdøvø maya'comø'ñaju. ");
INSERT INTO zosNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cuando Jesús nu'cyaju ñøtuṉdøvøji'ṉ Capernaum cumgu'yomo, cyømiñaj Pedro cobratzøjcoyajpapø'is, y 'yocva'cyaj Pedro: ―¿Ji'n cyoyoj impuesto mi maestro'is masandøjcøtoya? ");
INSERT INTO zosNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Y 'yaṉdzoṉ Pedro'is ñøjmayu: ―Jø'ø, cyøcoyojpapøtite. Entonces cuando tøjcøy Pedro tøjcomo, Jesusis 'yo'nøy vi'na Pedro, ñøjayu: ―¿Ti mi ndzamba, Simón? ¿Icøsi vya'cayajpa cøcoyojocuy nascøsta'mbø aṉgui'mba'is? ¿Mismo ñe cyumguy tøvøcøsi, o emøcpø pøngøsi? ");
INSERT INTO zosNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","'Yaṉdzoṉ Pedro'is: ―Emøcta'mbø pøn vya'cayajpa va'cø cyøcoyojyajø vyin. Y Jesús nømu: ―Entonces mismo cyumguy tøvø ji'n vya'cayaje va'cø cyøcoyojyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero va'cø ni iyø jana ni ti chajmayø, maṉ majromo va' maṉ syuyø. Y vinbø coque mi nu'cpa, pøcø y aṉvajcay coque'is 'yaṉnaca. Jeni maṉba mi mba'j tumin. Nømavø je tumin va'cø mi ngøcoyojay mi mbarte y ø ne. ");
INSERT INTO zosNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mismo jic tiempo ñøtuṉdøvø'is cyønu'cyaj Jesús y 'yocva'cyaju: ―¿Ipø pønete más myøja'ṉombø aṉgui'mbamø tzajpombø Dios? ");
INSERT INTO zosNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Entonces Jesusis vyejay che'pø une y yac te'n cujcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Y ñøjayaj ñøtuṉdøvø: ―Viyuṉse mi nøjandya'mbøjtzi, tiene que va'cø mi ṉgui'psvitu'ø y va'cø mi ñø'it qui'psocuy como une'is qui'psocusye va'cø jana mi møja'ṉgotzøc mi ⁿvin. O'ca ji'n mi ṉgui'psvitu' jetse, ji'n mus mi ndyøjcøy tzajpomopø Diosis aṉgui'mgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Por eso che' chøcpapø'is vyin como yøṉ unese, jetømete más myøja'ṉombøte aṉgui'mbamø tzajpombø Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Y pyøjcøchoṉba'is vøjø tum yø'csepø che'pø une ø nøyiṉgøsi, es como øtz nø pøjcu. ");
INSERT INTO zosNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","”O'ca it tum yøcsepø che'pø une y jic une'is va'ṉjambøjtzi, o'ca aunque i'is isindzi'pa jic une jujche va'cø chøc yatzitzoco'yajcuy, jic isindzi'upø'is yatzitzoco'yajcuy maṉba castigatzøctøj vøti. O'ca syi'najaytøj møjapø vacucha cyønøcø'mø y pyatztøjcøtyøj nø'cømø va'cø syucsca', menostina'ṉ toya jetse que maṉbase castigatzøctøji. ");
INSERT INTO zosNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","”¡Vøti maṉba isyaj toya nascøspø pø'nis, porque vøti it isindzi'papø'is tyøvø va'cø chøc yatzitzoco'yajcuy! Jetseta'mbø tiene que va'cø ityajø; pero ¡vøti maṉba is toya isindzi'papø'is tyøvø va'cø chøc yatzitzoco'yajcuy! ");
INSERT INTO zosNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","”Jetcøtoya o'ca mi ṉgø'is mi ṉgoso'is mi ñøtocopya, tøcspø'ø, y patzpø'ø; porque más vøjø cø'tyucupø costyucupø va'cø mi ñdyøjcøy tø quenbamø mumu jama que ji'n coṉñapø va'cø mi ndyøjcøy ji'n yajepø juctyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Y o'ca mi vindø'mis mi ñøtocopya, potztonbutø, y patzpø'ø. Más vøjø va'cø mi ndyøjcøy tu'maṉ vitømbø tø quenbamø mumu jama, que ji'n va'cø mi mbyatztøjcøtyøj metzcupyø mi vindømji'ṉ infierno'omopø juctyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","”Tzøjcay cuenda jana mi menos chøcø ni jutipø va'ṉjambapø'is øjtzi aunque che'pø. Pues mi nøjandya'mbøjtzi que angeles lo que cuendatzøcyajpapø'is je che'ta'mbø une mumu jama ityajpa tzajpombø ndø Janda'is vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Porque øjtzi mumu Pø'nis chøn Tyøvø mi'nøjtzi va'cø yaj cotzocyaj tocoyajupø pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","”¿Ti mi ndzamdamba? O'ca tumbø pø'nis ñø'it byorrego mosis, y tocopa tumø, ¿ti chøcpa? Pues jiṉdi chacpa noventa y nueve cotzøjcø'mø y tocoyupø borrego cyenvitpa va' mye'tza. ");
INSERT INTO zosNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y o'ca pya'tpa, casøpya. Noventa y nueve lo que ja opø tocoye, jet ji'ṉ cyøcajsøy más. Pero lo que oyupø tocoye jet más cyøcasøpya porque pya'tu'am. ");
INSERT INTO zosNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jetsetique't tzajpom ijtupø ndø Janda Diosis ni tum ji'n syuni va'cø tyocoy yøṉ che'ta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","”O'ca mi ndøvø'is mi ⁿyacsutzøcpa, cømavø va'cø o'nøy tumgø'y jicø y tzajmay que it cyoja. Y o'ca vyø'møpyati, maṉba mi it vøjø jetji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero o'ca ji'n vyø'mø'i ti mi ndzajmayu, nømaṉ tumø o metzcuy eyapø pøn como testigos ma's mi ṉgotzamgue'te que viyuṉsepø nø mi ndzajmayu. ");
INSERT INTO zosNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Y o'ca ji'n vyø'møyi ni jetse, tza'maṉvajcayø va'ṉjajmoyajpapø'is tyu'mgu'yomo. O'ca ni ji'n vyø'møyi jetse vøti pø'nis vyi'naṉdøjqui, entonces es mejor va'cø mi ñømø que jic pø'nis ji'n vya'ṉjam ni tiyø, como cobratzøjcopyapø para Romacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","”Viyuṉse mi nøjandyamba que lo que mi ya'inductamba yø'c nascøsi, jetseti tzajpom tzø'cye'tpa ya'indujcupø. Y lo que ji'n mi ya'inductam yø'c nacøsi, jetse syeguitzøcpa tzajpomo jana ya'inductøjøpø. ");
INSERT INTO zosNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","”Mi ndzamvøjøtzøjcatyaṉgue'tpati'tzi que o'ca mitzji'ṉda'mbø metzpø'nis sunba vya'cyaj aunque tiyø Dioscøsi, y mi ndumø tzocoy entre metzpøn mi ⁿva'ctamba mismo tumbø tiyø, entonces tzajpom ijtupø ndø Janda'is maṉba mi ñchi'tam mi ⁿva'ctamuse. ");
INSERT INTO zosNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porque metzcuy tu'cay tu'myajpamø ø nøyiṉgøsi, jetji'ṉ maṉba it øjtzi. Jetse nøm Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Entonces Pedro'is cyønu'c Jesús y 'yoc va'cu ñøjayu: ―¿Jujche nac vøjø va'cø ⁿyaj cøtocoy minbapø'is vya'c yaj cøtococuy? ¿Yaj cøtoco'pyøjtzi siete veces? ");
INSERT INTO zosNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesusis ñøjayu: ―Mi nøja'pyøjtzi que cu'yay nac usyco'ni, más vøjø siete veces setenta va'cø mi ⁿyaj cøtocojay mi ndøvø'is cyoja. ");
INSERT INTO zosNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","”Por eso como tum aṉgui'mba sunbapø'is yaj coyojyaj jya'tzi coyosyajpapø pøn, jetsetigue't tzajpombø aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aṉgui'mba'is vyejayaj ja'chajpapø y ñømiñaj tum jya'tzpapø'is vøti millones peso. ");
INSERT INTO zosNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Como ja it tipit cyoyojpa, entonces cyomi'is 'yaṉgui'mu va'cø mya'aj pøn yomoji'ṉ y 'yuneji'ṉ y mumu lo que ñø'ijtupø va'cø cyoyoj jya'tze. ");
INSERT INTO zosNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Entonces yospa pø'nis cyutcøne'cay cyomi vyi'naṉdøjqui y vo'pa ñøjayu: “Øjtzi ø ngomi, tø toya'ṉøy ndøvø; maṉba mi ṉgoyojpø'i”. ");
INSERT INTO zosNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Entonces cyomi'is ñømaṉjay pasencia, yaj cøtocojay jya'tze y yac tzø'y libre. ");
INSERT INTO zosNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero jic coyospapø tzu'ṉu y pya't cyoyospa tøvø ñu'cspa'is tumin mosis peso. Jyascøtøjcøy cyønøcø'mø mana'ṉ myo'jca'e, ñøjayu: “¡Tø coyojayø lo que mi ndø ja'ndzapyase!” ");
INSERT INTO zosNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Entonces jya'tzpapø'is cyutcøne'cay cyoyospa tyøvø y vo'pa ñøjayu: “Tø toya'ṉøyø y maṉba mi ṉgoyojpø'jaye”. ");
INSERT INTO zosNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero ja tyoya'ṉøyø, yac somdøju hasta que cyoyojpø'pa jya'tze. ");
INSERT INTO zosNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cuando eyapø coyospapø tyøvø'is isyaju ti chøjcu, ñømaya'yaju y maṉyaju y chajmayaj cyomi ti tujcu. ");
INSERT INTO zosNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Entonces cyomi'is vyejay yac somdøjupø'is y ñøjayu: “¡Mi yandzitzocopyøte mi ṉgyoyospapø'is! Øtz mi ⁿyaj cøtocopø'jay mi ja'ndze porque vo'pa mi ndø va'ṉgayu. ");
INSERT INTO zosNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jetse sunba va'cø mi ⁿyaj cøtococye'tøna'ṉ mi ṉgoyospa tøvø jujche øtz mi ⁿyaj cøtocoyuse”. ");
INSERT INTO zosNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Entonces cyomi qui'syca'comø'nu y 'yaṉgui'mu va'cø cyastigatzøctøjø hasta que cyoyojque'tpa mumu lo que jya'tzpase. ");
INSERT INTO zosNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jetseti maṉba mi nchøctaṉgue't tzajpom ijtupø ndø Janda'is o'ca ji'n mi ⁿyaj cøtocotyam mi ndumø tzocoy aunque iyø. ");
INSERT INTO zosNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Cuando tujcu jetsepø tza'maṉvajcocuy, Jesús tzu'ṉ Galilea nasomo y nu'cu Judea nasomo Jordán nø'cøtumøṉ ijtumø. ");
INSERT INTO zosNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Y maṉ pya'tyaj Jesús vøti pø'nis, y jeni Jesusis yac tzocyaj ca'eta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Entonces va'cø chøjquisyaj a ver o'ca muspa yac ondocoya, metzcuy tu'cay Fariseo'is cyønu'cyajque't Jesús va'cø 'yaṉgøma'cø'isyajø. 'Yaṉgøva'cyaju: ―¿A ver o'ca aṉgui'mgu'is ya'inducpa va'cø jana chac yomo co'tojquis aunque ticøtoya? ");
INSERT INTO zosNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Y Jesusis 'yaṉdzoṉyaju: ―¿Ti'ajcuy ji'n mi jajmundzøctam tiyø ijtu jachø'yupø Diosis 'yote? Jen chamba que tzo'tzcu'yomo: “Diosis chøc pøn jayapø y yomopø”. ");
INSERT INTO zosNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Y nømu: “Por eso pø'nis chacpa jyata y myama tyumgø'y va'cø it yomoji'ṉ y metzcuy tumø'ajyajpa”. ");
INSERT INTO zosNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Así es que ji'ndyet metzcuy sino tumdite. Por eso pø'nis ji'n mus vye'ndzac yomo porque lo que Diosis tyumøtzøjcupøte, pø'nis ji'n mus vye'na. ");
INSERT INTO zosNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Y fariseo'is ñøjmayaju: ―Entonces ¿por qúe 'yaṉqui'm Moisesis que o'ca pø'nis chacpa yomo, va'cø chi' co'tøjcajaṉvajcuy toto; y jetse muspa chacø? ");
INSERT INTO zosNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Pero Jesusis 'yaṉdzoṉyaju: ―Moisesis mi nchi'tam permiso va'cø mi ndzactam mi ⁿyomo porque ji'n mi sundam vøjpø tiyø. Pero cuando Diosis jyomectzo'tz pøn, ji'ndyet jetse. ");
INSERT INTO zosNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pero øtz mi nøjandya'mbøjtzi: O'ca yomo'is ja cyøtzøjcøyø y pø'nis chacpa yomo, y co'tøjcajpa eyapø yomoji'ṉ, jetse cyøtzø'cø'opya. Y o'ca pøn co'tøjcajpa chajcupø yomoji'ṉ, jetse cøtzøcø'cye'tpati. ");
INSERT INTO zosNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Entonces ñøtuṉdøvø'is ñøjayaj Jesús: ―O'ca jetse tiene que va'cø it pøn yomoji'ṉ, más vøj va'cø jana co'tøjcajø. ");
INSERT INTO zosNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Y Jesusis ñøjayaju: ―Ji'n mus pyøjcøchoṉyaj yøṉ aṉma'yocuy aunque i'is. Unico lo que Diosis chi'yajpapø qui'psocuy, je'is muspa pyojcøchoṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Porque it pøn que ji'n yomo'øyaje porque jetse pø'najyaju, it pøn que ji'n yomo'øyaje porque caputzøcyajtøju. Y itque't pøn que ji'n yomo'øyaje va'cø mus yos más vøjø tzajpombø itcucøtoya. I'is muspa pyøjcøchoṉ yøṉ aṉma'yocuy, muspa pyøjcøchova. ");
INSERT INTO zosNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Entonces ñønu'cyaj une Jesuscø'mø va'cø cyot cyø' jetcøsi Jesusis y va'cø 'yo'nøy Dios unecøtoya. Pero ñøtundøvø'is 'yojnayaju ñønu'cyaju'is 'yune. ");
INSERT INTO zosNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero Jesusis ñøjmayaju: ―Yac miñaj une øtzcø'mø, u mi ya'inductamu. Porque jetsepø'omo aṉgui'ba tzajpombø Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Entonces unecøsta'm cyot cyø'; y después tzu'ṉ jiṉø. ");
INSERT INTO zosNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jøsi'cam tum mbøñga'e'is o tyu'n Jesús, y 'yocva'cu: ―Vøjpøte mi Myaestro, ¿ti vøjø va'cø ndzøcø va'cø mba't mumu jamapø quenguy? ");
INSERT INTO zosNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Pero Jesusis ñøjayu: ―¿Ticøtoya mi ndø nøjapya: “Vøjpø mi Myaestro”? Ja it ni i vøjpø; na más que Diosti vøjø. Pero o'ca sunba mi mba't mumu jamapø quenguy, co'aṉjam aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Y mbøñga'e'is ñøjayu: ―¿Jutita'mbø aṉgui'mguy? Y Jesusis ñøjayu: U yaj ca'oye; u cyøtzøjcø'yoye; u ñu'mi; u mi ṉgyøsujtzø'yoyu; ");
INSERT INTO zosNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","cøna'tzøy mi janda y mi mama; y sunø mi ndøvø como jujche mi ⁿvin mi sunbase. ");
INSERT INTO zosNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Entonces ñøjay mbøñga'e'is: ―Yøcsepø aṉgui'mguy ndzøjcu'mtzi desde que une'csye'ṉo'mtzi; ¿ti más muspa ndzøc øjtzi? ");
INSERT INTO zosNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesusis ñøjayu: ―O'ca sunba mi ndzøc como Diosis syunbase ta'nemø, mavø, y ma ma'ajpø'pø'vøyø mi mumu ndiyø mi nø ijtupø. Y tumin sajtzi'yaj pobreta'mbø. Jetse maṉba mi ricu'aj tzajpomo. Y minø, mi tø pa'tø. ");
INSERT INTO zosNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero cuando mbøñga'e'is myan jetze, maya'u y maya'pa tzu'ṉu; porque ricupøna'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Entonces Jesusis ñøjayaj ñøtuṉdøvø: ―Viyuṉsye mi nøjandya'mbøjtzi: Penapit tøjcøpya ricupø pøn tzajpomopø Dios aṉgui'mbamø. ");
INSERT INTO zosNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mi nøjandyaṉgue'tpøjtzi que más facil va'cø cyøt camello copøn acusya sutu'omo que tum ricu ji'n maṉ tøjcøy aṉgui'mbamø Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cuando ñøtundøvø'is myañaj jetse, maya'comø'ñaju. Y 'yocva'cyaju: ―Entonces, ¿i muspa cotzoca? ");
INSERT INTO zosNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesusis 'ya'maṉga'yaju y ñøjayaju: ―Pø'nis ji'n mus chøc jetse, pero Diosis aunque ti muspa chøcø. ");
INSERT INTO zosNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Entonces Pedro'is ñøjay Jesús: ―Øtz nø'ijta'møjtzi aunque tiyø, jen ndzajcøjtzi; y yøti nø mi mba'tu, ¿jujche tø vø'ajtamba yøti? ");
INSERT INTO zosNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Y Jesusis ñøjayu: ―Viyuṉsye mi nøjandya'mbøjtzi, jic tiempo cuando jomecotzøctøjpa mumu tiyø, cuando øtz mumu Pø'nis chøṉ Tyøvø, øtz po'cspa y møja'ṉom aṉgui'mba øjtzi, entonces mitz o mi ndø pa'jtame, maṉba mi mbyo'cstaṉgue't macvøstøjcapyø aṉgui'mbapø'is pyo'cscu'yomo va'cø mi aṉgui'mayajø macvøstøjcay Israejlis 'yune'is 'yuneta'm vøti'ajyajupø. ");
INSERT INTO zosNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y mumu lo que tzu'ṉba itcu'yomo øtzcøtoya y jendi tzø'yajpa tyøc, o 'yatzi' o chøtzø, o myuqui, o jyata, o myama, o yomo, o 'yune, o ñas; o'ca para øtzcøtoya tzu'ṉba, maṉba pyøjcøchoṉ mosis nac más y maṉba quen mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Y vøti más covi'najøpø pøn yøti, ji'n ma 'yaṉgui'myaje, ma tzø'yaj aunque ipø pønse. Y vøti ni ti aṉgui'mguy ja ñø'ityajøpø'is yøti, jet maṉba covi'najø'ajyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","”Jujche chøc vø'nipi'is, jetse chøcpa Diosis. Ijtuna'ṉ pøn ñø'ijtu'is yosaṉ. Namdzuti tzu'ṉu maṉ mye'tz coyosyajpapø va'cø ñøyosyajø 'yuva nipi'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Vyø'møyaju va'cø cyoyojyajtøj tum tumin ñøyipø'is denario tumdum jama. Y yac maṉyaju va'cø maṉ yosyaje uva nipi'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Y a las nuevese'ṉomo maṉgue'tuti vø' yosaṉ plaza'omo. Jen pya'tyaj pøn nø syunde'nmate'ñaju. ");
INSERT INTO zosNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Y vø'yosa'ṉis ñøjayaju: “Maṉ yostaṉgue'ta ø ⁿuva nipi'omo. Maṉba mi ṉgoyojtam coyojo'ñømbase”. Y maṉyaju maṉ yosyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jetseti chøjque't panguc jamasye'ṉomo; jetseti chøjque't las tressye'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Entonces cyomi'is maṉ vyøco'a'mvøjøtzøcyajque't plaza'omo las cincosye'ṉomo. Jen pya'tyaj eyapø ji'n nø yosyajupø y ñøjayaju: “¿Ti'ajcuy jetse mi ndzøctamba, cøti jama mi ndye'ndamu ji'n nø mi ⁿyostamu?” ");
INSERT INTO zosNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Y 'yaṉdzoṉyaju: “Porque ni i'is ja chi'tamø yoscuy”. Entonces vø'yosa'ṉis ñøjayaju: “¿Ji'n sun maṉ mi yostam ø ⁿuva nipi'omo? Maṉba mi ṉgoyojtam coyojo'ñømbase”. ");
INSERT INTO zosNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Y entonces cuando maṉbana'ṉ tø'p jama, vø'yosa'ṉis ñøjay 'ya'mbapø'is nø yosyajupø: “Vejayajø nø yosyajupø y coyojyajø vi'na jøsi'cam yostøjcøyajupø, y último coyojyaj vi'na yostøjcøyajupø”. ");
INSERT INTO zosNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Entonces miñaju las cincose'ṉomo yostøjcøyajupø, y tumdum pøn coyojtøj tum denario tumin. ");
INSERT INTO zosNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Entonces miñajque't namdzuti yostøjcøyajupø. Je'is cyomo'yaju que más maṉba cyoyoja'ṉøyajtøji. Pero jetseti coyojyajtøjque'tu, tumdum pøn tum denario. ");
INSERT INTO zosNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cuando pyøjcøchoṉyaju, oñaju; cyø'o'nøyaj vø'yosaṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Nømyaju: “Øtz cøti jama yosta'møjtzi; cøti jama poṉdøj jama'is, y parejo coyojtandøj usyaṉ hora yosyajupøji'ṉ”. ");
INSERT INTO zosNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Y vø'yosa'ṉis 'yandzoṉu, ñøjay tumbøn: “Con tal que ji'n mi ñu'mi, achø, porque ne'c mi vø'møyu va'cø mi ṉgoyos tum denariocøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pøc mi ṉgoyoja va' mi myavø. Øtz su'nbøjtzi va'cø parejo ṉgoyojyaj mitzji'ṉ tza'i yostøjcøyajupøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Øtz it ø derecho va'cø yac yos o ndumin suṉbase ø ne'ṉgø. Porque øtz suṉba ancø ø ndøvø, y mitz ṉgui'syca'pa”. ");
INSERT INTO zosNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jetsemete Diosmøte jøsmøta'mbø maṉba vi'na cotyajtøji, y vi'nata'mbø jøsmø maṉba cotyajtøji. Porque it vøti pøn vejyajtøjupø, pero usyti cøpiṉyajtøju. ");
INSERT INTO zosNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nømna'ṉ myaṉ Jesús Jerusalén gumgu'yomo va' ñu'cø. Y ne'ti ñømaṉyaj macvøstøjcay ñøtundøvø y ñøvejvejneyaju mientras tu'ṉajyaju, ñøjayaju: ");
INSERT INTO zosNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Tzi'tam cuenta que nømdi maṉdam Jerusalén gumgu'yomo, y øjtzi mumu Pø'nis chøn Tyøvø maṉba tzi'ocu'yajtøji va'cø tzøjca'yajøjtzi ti sunba tzøjcayajø pane covi'najø'is y aṉma'yoyajpapø'is aṉgui'mguji'ṉ; je'is maṉba chamyaje que syunba va'cø yaj ca'tøjø. ");
INSERT INTO zosNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Y ma'ṉbø tzi'ocu'yaje eyapø pø'nis cyø'omo lo que ji'ndyet Israel pøn va'cø sijcayajø, va'cø nacsyajø, va'cø ma'møyaj cruzcøsi va'cø ca'ø; pero tu'cay jamapit ma'ṉbø visa'e. ");
INSERT INTO zosNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeo'is 'yune'is myama'is cyønu'cyaj Jesús 'yuneji'ṉ y cyu'tcøne'cayu va'cø vya'c tum favor. ");
INSERT INTO zosNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Y Jesusis ñøjayu: ―¿Ti sunba? Y je'is ñøjay Jesús: ―Su'nbøjtzi va'cø mi yac po'csyaj yøṉ metzcuy ø ⁿune tu'maṉ du'maṉ mi sayamaye cuando mi minba va'cø 'yaṉgui'mø; va'cø mi yac po'cs tumø mi ndzø'na'ṉomo, y tumø mi aṉna'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Entonces Jesusis 'yaṉdzoṉu ñøjayu jic metz pøn: ―Ji'n mi mustame ti nø mi ⁿva'ctamu. ¿Muspaja mi ṉgøjtatyam møja'ṉ toya como øtz ma'ṉbase nøṉgøti como saṉ toya va'cø ndø isø? Y je'is 'yaṉdzoṉyaj Jesús: ―Muspa ndø nøṉgøjtam jetsepø toya. ");
INSERT INTO zosNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Y Jesusis ñøjayaju: ―Viyu'ṉete mitz maṉba mi nøṉgøjtam møja'ṉ doya como øtz maṉbase nøṉgøt toya como saṉ completamenta toya va'cø ndø isø. Pero øtz ji'n mus ndzam i maṉba po'cs tu'møn du'møn ø sayamaye. Pero ndø Janda Diosis maṉba yac pocsyaj jic pøn lo que jutipøcøtoya ñe'c vyøjøtzøjcu jic po'cscuy. ");
INSERT INTO zosNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Cuando eyapø majcay ñøtuṉdøvø'is myañaju metzcuy tyøvø, qui'sayaj metzcuy tyøvø porque ticøtoya ma vya'cyaj más aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero Jesusis vyejmiñaju y ñøjayaju: ―Mitz mi mustamba que nascøsta'mbø covi'najø'is 'yaṉgui'myajpa tyøvøcøsi, y myøja'ṉomda'mbø pø'nis yø'møc teymøc yac maṉyajpa tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero mijtzomda'm ji'n jetse. I'is sunba myøja'ṉomajø mijtzomda'm, tiene que va'cø chøc vyin coyospa pønse. ");
INSERT INTO zosNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Y i'is syunba va'cø cyovi'najø'ajø, tiene que va'cø chøc vyin como aunque i'sti ñu'cscusye. ");
INSERT INTO zosNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hasta øtz mumu pø'nis chøṉ tyøvø mi'nøjtzi ji'ndyet øtz va'cø nu'csyaj ø mbøndøvø; sino que øtz mi'nøjtzi va'cø ndzøc nu'csocuy, y va'cø ndzi'ocu'yaj ø ⁿvin va'cø yaj ca'tøjø va'cø jyumbutyaj vøti pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cuando nømna'ṉ chu'ṉyaj Jericó cumgu'yomo, vøtipøn nømna'ṉ vyityaj Jesusji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Y po'cspana'ṉ metzcuy pøn to'tita'mbø tu'ṉu saya'omo, y myañaju que nø cyøt Jesús. Entonces vejyaju y ñøjmayaju: ―¡Øjtzø mi Ṉgomi, Davidis mi 'yune, tø toya'ṉøtyamø! ");
INSERT INTO zosNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Y vøti pø'nis 'yojnayaju va'cø jana vyejyajø. Pero más pømi vejaṉgøtyaju, jicø nømyaju: ―¡Øjtzø mi ṉgomi, Davijdis mi 'yune, tø toya'ṉøtyamø! ");
INSERT INTO zosNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Entonces Jesusis cyøte'ndzøyaju y vyejayaju: ―¿Ti mi sundamba va'cø ndzøc mitzcøtoyata'm? ");
INSERT INTO zosNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Y 'yandzonyaju: ―Øjtzø mi Ṉgomi, su'nbøjtzi va'cø syøṉdam ø vindøm. ");
INSERT INTO zosNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Entonces Jesusis tyoya'ṉøyaju; pi'quisay vyitøm y jicsye'c sø'ṉyaj vyitøm: y myajcøtøjcøyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Entonces tomemna'ṉ nø ñu'cyaj Jerusalén gumgu'yomo, y nu'cyaj Betfagé cumgu'yomo. Je cumgu'is tyome ispa Olivo cotzøc. Jiṉø metzcuy ñøtuṉdøvø cyø'vej Jesusis va'cø chøcyaj nu'csocuy; ");
INSERT INTO zosNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ñøjayaju: ―Maṉdam jiṉ jic tu'møn ijtupø che' cumgu'yomo. Jiṉ maṉba mi mba'jtam jø'mdøju burro 'yuneji'ṉbø. Pu'pøtamø nømindam yø'qui. ");
INSERT INTO zosNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Y o'ca i'is ti mi ñchajmatyamba, nøjatyamø: “Porque ndø Comi'is nø syunu, maṉba ñu'csi”, y prontoti maṉba yac maṉyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Y jetse tujcu va'cø yac viyu'ṉajø lo que chamuse tza'maṉvajcopyapø'is. Je'is chamu: ");
INSERT INTO zosNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Nøjayaj Sión gumgu'yomda'mbø: “Mi møja'ṉ Aṉqui'mba jicø nø minumø. Pasenciapøte y burro nø pyo'csu, burro'is 'yune nø pyo'csayu”. ");
INSERT INTO zosNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Entonces maṉyaj nu'cscuy chøcyaj jujche chajmayajuse Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ñømijnayaj Jesús burro 'yuneji'ṉbø, y cyøto'cøyaj tyucuji'ṉ y yac poc'syaj Jesús je burro. ");
INSERT INTO zosNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Y vøti pø'nis tuṉ cyøto'cøyaj tyucuji'ṉ, y eyata'mbø'is tyøcsayaj cu'yu' aṉmaṉ y tyo'cøyaj tu'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Entonces vi'najyajupø y jøsmø nø minajupø vejaṉgøtpa nø myaṉyaju; vejyaju, nømyaju: ―¡Ndø vøngotzøcta'i Davijdis 'Yune! ¡Vøjpøte jicø nø minupø ndø Comi Diosis ñøyicøsi! ¡Ndø vøṉgotzoctay møjipø Dios! ");
INSERT INTO zosNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Y cuando Jesús tøjcøy Jerusale'ṉomo, mumu cumgu'yomda'mbø nømna'ṉ vyejvityaju. Vøti pø'nis 'yocva'cyaju, ñøjayaju: ―¿Iyøṉ yøṉø? ");
INSERT INTO zosNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Y eyapø'is 'yaṉdzoṉyaju, ñøjayaju: ―Yøṉømete Jesús, Nazaret cumgu'yombø tza'maṉvajcopyapø; Galilea nasom tzu'ṉupø. ");
INSERT INTO zosNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jøsi'cam tøjcøy Jesús Diosis myasandøjcomo y cøyin myacputpø'yaju ma'ayajpapø y ju'yoyajpapø; y pye'tzvitu'jayaj myesya cyacpøyajpapø'is tumin, y paloma ma'a pø'nis pyo'cscuy pyatzvitu'jayajque'tu. ");
INSERT INTO zosNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Y ñøjayaju: ―It jachøyupø Diosis 'yote: “Ø ndøc maṉba ñøjayaje tøc juti 'yo'nøyajpamø Dios”. Pero mitz mi ndø nøctøjcøjatyam yøṉ masandøc como si fuera aṉgøvø'ñajpamø nu'myajpapø. ");
INSERT INTO zosNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Entonces cyømiñaj Jesús masandøjcomo to'tita'mbø'is y cømø'ṉgaṉyajpapø pø'nis, y yac tzocyaj Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero pane covi'najø y 'yaṉmayajpapø'is aṉgui'mguy qui'sca'yaju cuando isyaj myøja'ṉomda'mbø tiyø nø chøc Jesusis y une nømna'ṉ vyejaṉgøtyaju masandøjcomo. Nømna'ṉ nømyaj une: “¡Ndø vøṉgotzøcta'i Davijdis 'Yune!” Pane covi'najø y 'yaṉmayajpapø'is aṉgui'mguy qui'syca'yaju y ");
INSERT INTO zosNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ñøjayaj Jesús: ―¿Nømidija mi manu ti nø chamyaj jic une'is? Jesusis 'yaṉdzoṉyaju: ―Jø'ø, manu'mtzi, pero jajmutzøctam mi ndu'ndamuse it Diosis 'yote jachø'yupø yø'cse nø ñømu: Une y tzu'chajpapøtøc mi ndzi'yaj qui'psocuy saṉ vøjø va'cø mi ⁿvyøṉgotzøcyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Entonces Jesusis chacyaju, tzu'ṉu Jerusalén gumgu'yomo, maṉ Betania cumgu'yomo y jiṉ øṉu. ");
INSERT INTO zosNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Y jyo'pit namdzu nøma'ṉ vyitu'u Jesús Jerusalén gumgu'yomo y tu'ṉomo nømna'ṉ 'yosu. ");
INSERT INTO zosNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Y is higo cuy jiṉ tu'ṉaṉvi'ni tome ijtupø y maṉ mye'tzay tyøm o'ca ijtu. Pero ja pya'tay tyøm, saṉ 'yayti ijtu. Por eso Jesusis ñøjay higo cuy: ―¡Mitz nunca ji'n ma mi ndyø'majque'te! Y jicsye'cti tøtzca'u higo cuy. ");
INSERT INTO zosNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Y ñøtuṉdøvø'is isyaju y ñømaya'yaju y nømyaju: ―¡Tan pronto tøtz ca' higo cuy! ");
INSERT INTO zosNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Entonces Jesusis ñøjayaju: ―Viyuṉsye mi ndzajmatya'mbøjtzi; o'ca tumø chocoy mi va'ṉjajmondyamba y ji'n mi myejtzaṉdzoco'yajtame, ji'ṉ na's cuy maṉba mus mi yac tøtztame; sino o'ca yøṉ cotzøc mi nøjandyamba: “Tzu'ṉ jeni y tøjcøy majromo”, y tzu'ṉba. ");
INSERT INTO zosNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","O'ca mi ⁿva'ṉjamdamba, aunque ti mi ⁿva'ctamba Dioscøsi, mi ñchi'tamba. ");
INSERT INTO zosNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Después cuando tøjcøy Jesús masandøjomo va'cø 'yaṉma'yoya, cyønu'cyaj pane covi'najø'is y Israel tzambø'nis y 'yocva'cyaju: ―¿Jutzpø aṉqui'mgupit jetse mi ndzøcpa? ¿I'is mi nchi' aṉgui'mguy va'cø mi ndzøc yøcseta'mbø tiyø? ");
INSERT INTO zosNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Y Jesusis 'yaṉdzoṉyaju, ñøjayaju: ―Øtz maṉba mi ⁿocva'ctaṉgue'te; y o'ca vøj mi ndø aṉdzoṉdamba, maṉba mi ndzajmatyame i'is tzi'ø aṉgui'mguy va'cø ndzøc yøcseta'mbø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿I'is chi' Juan aṉgui'mguy va'cø nø'yø'yoya? ¿O tzajpombø Diosis chi'u, o nascøspø pø'nis? Entonces pane covi'naj y Israel tzambøn vejvejneyaj ñe'comda'm nañøjmayajtøju: ―O'ca tø nømba: “Diosis chi' Juan aṉgui'mguy”; entonces maṉba tø nøjatyame: “¿Ti'ajcuy ja mi ⁿvya'ṉjamdam Juan?” ");
INSERT INTO zosNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y o'ca tø nømba: “Pø'nis chi'u Juan aṉgui'mguy”; tø na'tzpa que maṉba qui'syca' vøti pøn. Porque mumu vya'ṉjamyajpa que Diosis cyø'vej Juan va'cø cha'maṉvajcoya. ");
INSERT INTO zosNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Por eso ñøjayaj Jesús: ―Ji'nø mustam i'is chi' Juan aṉgui'mguy. Entonces ñøjayaj Jesusis: ―Pues ni øtz ji'n ma mi ndzajmatyame i'is tzi'ø aṉgui'mguy va'cø ndzøc yøcseta'mbø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","”Pero a ver ti mi ṉgui'pstamba. Ijtuna'ṉ tum pøn ijtu'is metzcuy 'yune. Cyømaṉ atzipø y ñøjmayu: “Ø ⁿune; maṉ yos yøti uva nipi'omo”. ");
INSERT INTO zosNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Une'is 'yaṉdzoṉu y nømu: “¡Ji'nø sun maṉ øjtzi!” Pero jøsi'cam qui'psvitu'u, oti mave, maṉ yose. ");
INSERT INTO zosNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Y eyapø 'yune cyømaṉgue'tu, igual ñøjayu va'cø maṉ yosa. 'Yaṉdzoṉ je'is ñøjayu: “Jøy, Jatay, ma'ṉbøjtzi”, y ja myavø. ");
INSERT INTO zosNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","A ver ti mi ndzamdamba, ¿jutipø'is chøjcay jyata'is syunbase? Y ñøjayaju: ―Vi'na aṉgui'mupø une'is chøjcu jyata'is syunbase. Entonces Jesusis ñøjayaju: ―Viyuṉsye mi nøjandya'mbøjtzi; gobierno'is cyobratzojcoyajpapø y møtzi yomo más vi'na tøjcøyajpa aṉgui'mbamø Dios que ji'n mijtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porque minu Juan nø'yø'opyapø mijtzomda'm va'cø mi aṉmandyamø viyuṉbø tuṉ, y ja mi ⁿvya'ṉjamdamø. Pero cobratzojcoyajpapø'is y møtzi yomo'is vya'ṉjamyaju. Aunque istamuti que jetse qui'psvituyaju, pero mitzta'm ja mi ṉgui'psvitu'tamø, ni ja mi ⁿvya'ṉjamdamø. ");
INSERT INTO zosNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ñøjacye't Jesusis: ―Cøma'nøtyam eyapø aṉma'yocuy. Ijtuna'ṉ tum vø'nas chøjcu'is uva nipi. 'Yaṉgøve'cøyu, y ño'tz tza' tzica cuenta je'tomo va'cø chø'y uva'is ñø' cuando cyømi'tzpa uva. Chøc torre va'cø quendzu'ṉø va'cø ñøjque'nøyø nipi. ”Y chacyaj yosyajpapø va'cø cuidatzøcyajø, y ya'i maṉu eyapø cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cuando nu'c 'yaṉsøṉ, vø'nasis cyø'vejyaj chøsi ityajumø cuidatzøcyajpapø'is va'cø pyøjcøchoṉyaj cosecha jujche maṉbase pyøc vø'ne'is. ");
INSERT INTO zosNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero cuidatzøcyajpapø'is ñu'cyaj chøsi, tum ñacs vitu'vitu'vøyaju, eyapø yaj ca'yaju; eyapø pyu'ṉga'yaj tza'ji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Entonces vø'nasis cyø'vejyajque't eyata'mbø chøsi más vøti que ji'n vi'nase, pero igualti yacsutzøcyajque'tu. ");
INSERT INTO zosNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","”Al fin cyø'vej vø'nasis ñe 'yune, nømu: “Tiene que va' cyøna'tzøyaj ø ⁿune”. ");
INSERT INTO zosNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero cuidatzøcyajpapø'is isyaj vø'nasis 'yune y nañøjayajtøju: “Yø'nis maṉba ñøtzø'y nipi. Ma ndø yaj ca'tamø va'cø ndø cøpøctamø”. ");
INSERT INTO zosNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Y ñucyaju, ñøputyaj uva nipi'omo, y yaj ca'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Entonces cuando vitu'pa vø'nas, ¿ti maṉba chøjcayaj cuidatzøcyajpapø'is nipi vø'nasis? ");
INSERT INTO zosNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ñøjayaju: ―Pues ji'n ma tyoya'ṉøyaj jic yatzita'mbø pøn. Maṉba yaj ca'yaje, y uva nipi maṉba chi'yaj eyapø pøn va'cø cuidatzøcyajø maṉba'is cyove'nducyaje ijtu'cam tyøm. ");
INSERT INTO zosNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Entonces Jesusis ñøjayajque'tu pane covi'najø y tzambøn govi'najø: ―Jajmutzøctam mi ndyu'ndamba jachø'yupø Diosis 'yote; jen chamba: Ijtuna'ṉ tum tza' que tøc tzøcyajpapø'is ja syuñajø. Pero jøsicam eyapø'is cyøpiṉ mismo jic tza' va'cø cyota esquina'omo porque más vøjpø tza. Jetse chøc ndø Comi'is y ndø ispa que chøcpa maya'aṉbø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jetøtoya mi nøjandya'mbøjtzi: Mitz maṉba mi yac tzactaṉtøj aṉgui'mguy mitz mi nø'ijtatyamupø Diosis cuenta'ṉomo, y maṉba tzi'tøj aṉgui'mguy eyapø maṉba'is chøc vøjø como cyove'ndujcupø'is cosecha Diosis cuentacøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aunque iyø quecpapø jicø tza'cøsi, pyajcøquitpa vyin, pero icøs quecpa je tza', nama pu'ṉgøvenba. ");
INSERT INTO zosNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Cuando pane covi'najø'is y fariseo'is cyøma'nøyaju jetsepø aṉma'yocuy, chi'yaj cuenta que yatzipø cove'nducyajupø'is jujche chøcyajuse, Jesusis sunba ñømø que jetseti nø chøcyajque't ji'quista'm. ");
INSERT INTO zosNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Por eso sunbana'ṉ ñu'cyaj Jesús. Pero ña'chaj vøti pøn, porque vøti pønis vya'ṉjamyaju que Jesús tza'maṉvajcopyapøte Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Entonces Jesusis cha'maṉvajque't jujche tucnømbase Dios aṉgui'mbamø. Ñøjayaju: ");
INSERT INTO zosNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Como tum aṉgui'mba oyu'is chøc søṉdzøjcuy cuando co'tøjcaj 'yune, jetseti chøjque'tpa Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aṉgui'mba'is cyø'vej ñu'cscuy va'cø chajmayaj vejyajtøjupø va'cø ñu'cyaj sø'ṉajcu'yomo, pero ja syun miñajø. ");
INSERT INTO zosNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Entonces cyø'vejvøjøtzøcyajque't eyapø nu'cscuy va'cø vøco vejvøjøtzøcyajque'ta, ñøjmayaju: “Tzajmayaj vejyajtøjupø que listo'am cu'tcuy, yaj ca'u'am ø vaṉgas y eyapø copøn tzaṉgata'mbø. Mumu tiyø listo'am ijtu va'cø ñu'cyaja'am va'cø 'ya'mayaj co'tøjcajcuy”. ");
INSERT INTO zosNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero vejyajtøjupø'is ja chøjcayaj cuenda, ja ñu'cyaja'm. Tum maṉ yose tza'momo, tum maṉ ma'a cote. ");
INSERT INTO zosNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Eyata'mbø'is ñucyaju aṉgui'mba'is ñu'cscuy, yacsutzøcyaju, yaj ca'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Cuando jetse myusu, qui'syca'comø'nu aṉgui'mba y cyø'vejyaj syoldado va'cø yaj ca'yaj yaj ca'ayaju'is ñu'cscuy y va'cø pyoṉbøjay cyumguy. ");
INSERT INTO zosNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jicsye'c aṉgui'mba'is ñøjayaj eyapø ñu'cscuy: “Listo'am mumu tiyø co'tøjcajcucyøtoya. Pero vejyajtøjupø ji'ndyet vyøjta'mbø, por eso ja miñajø. ");
INSERT INTO zosNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yøti maṉdam ijnømumø callemaye y i mi mba'tyajpa, vejayajø va'cø min a'myaj co'tøjcajcuy”. ");
INSERT INTO zosNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Y maṉyaj vijnømbamø callemaye y aunque i pya'tyaju, vyejtu'myaju va'cø 'ya'myaj co'tøjcajcuy; aunque yatzipø, aunque vøjpø; y jetse ijnømuna'ṉ vøti co'tøjcajcu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","”Y cuando aṉgui'mba tøjcøyu va'cø 'ya'myaj tu'myajupø, is tum pøn que ja myescøyojapø co'tøjcajcucyøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Y aṉgui'mba'is ñøjayu: “Achø, ¿ticøtoya ja myescøyojapø co'tøjcajcucyøtoya mi min yø'qui?” Y pøn ja 'yaṉdzo'ṉoya. ");
INSERT INTO zosNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Entonces aṉgui'mba'is ñøjayaj chøsi: “Mo'csatyam cyø' y cyoso y jetse ñømavø. Y a'ṉgom pajtzøy pi'tzø'ajcu'yomo. Jen maṉba vo'e maṉba cyø's tyøtz maya'cu'is”. ");
INSERT INTO zosNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Porque vøti pøn vejayajtøjpa, pero usyi cøpiṉyajtøjpa. ");
INSERT INTO zosNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Entonces manyaj fariseo y qui'pscøpo'yaju jujche muspa 'yaṉgøma'cøyaj Jesús a ver o'ca muspa yac ondocoya va'cø mus cyøtza'møyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Por eso Jesuscø'mø yø'ṉis cyø'vejyaj ñøtuṉdøvø møja'ṉ aṉgui'mba Herodesis ñe'ji'ṉ. Je'is ñøjayaj Jesús: ―Maestrø, musta'mbøjtzi que siempre mi ndzamba viyuṉda'mbø tiyø. Y viyuṉse mi ndzamba syunbase Diosis va'cø ndø tzøcø. Y ji'n mi ndzøjcay cuenda ti qui'psyajpa pø'nis, ni jujchepø pøn ji'n mi ndzøjcay cuenda, ni che'pø ni møjapø. ");
INSERT INTO zosNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Entonces por eso tø tzajmayø ti mi ṉgui'pspa: o'ca vøjø va'cø ndø cøcoyoja Roma cumgu'yombø aṉgui'mbacøsi, o ji'n vyøjø. ");
INSERT INTO zosNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero Jesusis myusu que ji'n vyøjpø pø'najcupit nø 'yocva'cyaju y ñøjayaju: ―¿Ticøtoya sunba mi ndø aṉgøma'cøtyamø? Yatzipø mi ṉgui'psocutya'm aunque vøjse mi ndø o'nømbya. ");
INSERT INTO zosNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tø yac istam tumin ndø cøcoyojtambapøji'ṉ. Y yac isyaj tumin. ");
INSERT INTO zosNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Y Jesusis ñøjayaju: ―¿I'is cyene, i'is ñøyi ij tumingøsi? ");
INSERT INTO zosNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","'Yaṉdzoṉyaju: ―Roma'ombø aṉgui'mba'is cyene y ñøyi ij tumingøsi. Entonces Jesusis ñøjayaju: ―Pues entonces lo que Roma'ombø aṉgui'mba'is ñe, jet tzi'tamø jicø, y lo que Diosis señe, jej tzi'taṉgue'ta Diosti. ");
INSERT INTO zosNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cuando pø'nis myañaj jetse, ñømaya'yaju, porque ji'na'ṉ nø qui'psyaju o'ca jetse maṉba 'yaṉdzoṉyaje. Chacyaj Jesús, maṉyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Y mismo jama cyømiñaj Jesús saduceo aṉma'yocuy ñø'ityajupø'is. Yøṉda'm nømyajpa que ji'n ma visa'nømi, y 'yocva'cyaj Jesús, ");
INSERT INTO zosNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ñøjayaju: ―Maestro, Moisesis jya'yøyu que o'ca pøn ca'pa y ji'n chac une, tiene que va'cø pyøjcay yomo myuqui'is va'cø ityaj 'yune por cuenta que 'yatzi'se 'yune. ");
INSERT INTO zosNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pues ijtuna'ṉ øjtzomo cu'yatya'mbø tøvø. Vinbø o co'tøjcaje pero ca'u y ja chac une. Y myuqui'is pyøjcay yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jetseti ca'que'tuti, ja chajque'tati une. Y tu'cayombø jetseti tujque'tu, y cøyin jetseti tucyaju hasta que ta'n cu'yay. ");
INSERT INTO zosNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Y último yomo ca'que'tuti. ");
INSERT INTO zosNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Entonces cuando visa'yajpa ca'yajupø, ¿jutipø'is maṉba ñø'it je yomo?, como cu'yapø'is ñø'oyaj tumbø yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pero 'yaṉdzoṉ Jesusis ñøjayaju: ―Mi ṉguivucatzøctamu porque ji'n mi myusatyam Diosis jyachø'yupø ote, ni ji'n mi mustame ti muspa chøc Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Porque cuando visa'yajpa ca'yajupø, ji'n ma cyo'tøjcajyaje, ni ji'n ma syajyaj 'yune. Pero maṉba ityaj como jujche Diosis 'yangeles tzajpom ityajpase. ");
INSERT INTO zosNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero ma'ṉbø ndza'maṉvajca'ṉøyi o'ca visa'yajpa ca'yajupø. Mi ndu'ndamu'am lo que Diosis mi ñchajmapya libro'omo. (Cuando ya'møjcam ca'yajuna'ṉ Abraham, Isaac, y Jacob) Dios nømu: ");
INSERT INTO zosNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Øjchøṉ Dios, va'ṉjamyajpøjtzi Abraha'mis, y Isaajquis y Jacojbis”. Jetse nøm Dios. Pero ca'yajupø'is ji'nam jutznøm ma vya'ṉjamyaj Dios, sino queñajpapø'is vya'ṉjamyajpa. ");
INSERT INTO zosNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cuando myañaj vøti pø'nis, entonces ñømaya'jayaj 'yaṉma'yocuy. ");
INSERT INTO zosNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cuando myañaj fariseo'is jujche Jesusis yac vøṉbø'yaj saduceota'm, entonces tu'myaj fariseo. ");
INSERT INTO zosNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Y ijtuna'ṉ tum je'tom aṉma'yopyapø aṉgui'mguji'ṉ, je'is chøjquisu a ver o'ca yac vøṉbø'pa Jesús. 'Yocva'cu, ñøjayu: ");
INSERT INTO zosNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, entre ijtuse jachø'yupø Diosis 'yaṉgui'mocuy, ¿jutipø más møjapø? ");
INSERT INTO zosNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Y Jesusis ñøjayu: ―“Sunø mi Ṉgomi Dios mi ndumø tzocoy, mi ndumø espirituji'ṉ: y mi ndumø quipsocuji'ṉ”. ");
INSERT INTO zosNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yøṉømete vi'napø y más møjapø aṉgui'mocuy. ");
INSERT INTO zosNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y metza'ombø'is parejo chamba: “Sunø mi ndøvø como juche mi ⁿvin mi sunbase”. ");
INSERT INTO zosNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jic metzcuy aṉgui'mocuy va'cø ndø tzøcø, ndø yaj coputpø'pa mumu aṉgui'mocuy. ");
INSERT INTO zosNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mientras que nømdøc tu'myaj fariseo, ");
INSERT INTO zosNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesusis 'yocva'cyaju: ―¿Ti mi ṉgui'pstamba mijtzi, i'ise 'yune Cristo? Ñøjayaju: ―Cristo Davijdis 'yunete. ");
INSERT INTO zosNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Entonces Jesusis ñøjayaju: ―Entonces ¿ti'ajcuy Davijdis cyomi'ajpa Cristo? Porque Masanbø Espiritu Santo'is yac mijnay David qui'psocuy jetse va'cø chamø, nømu: ");
INSERT INTO zosNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ndø Janda Diosis ñøjay ø Ṉgomi: “Po'cs ø ndzø'na'ṉomo hasta que øtz yac monchi'ajyajpa mi enemigo, por cuenta mi ṉgosopit va'cø mi ṉgøte'nøyajø”. ");
INSERT INTO zosNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jetse David nømu que Cyomite; pero o'ca Cyomite, ji'n jujche mus 'yune'ajø. ");
INSERT INTO zosNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y ni i'is ni ti ja mus chamø. Y desde entonces ni i'is ja ñø'it valor va'cø 'yocva'jque't Jesús aunque tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Entonces Jesusis ñøjayaj vøti pøn ñøtuṉdøvøji'ṉ: ");
INSERT INTO zosNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Myusyajpapø'is aṉgui'mguy y fariseo, je'is ñø'ityaj aṉgui'mguy va'cø cha'maṉvacyaj Moisesis 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Por eso mumu ti mi ñchajmatyamba, cøma'nøtyamø y co'aṉjamdamø. Pero u mi ndzøctam je'is chøcyajpase. Porque je'tis na más que chamyajpa, pero ñe'c ji'n chøcyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pues chi'yajpa aṉgui'mocuy, pero es como va'cø tø cojtay tzømi jemetzpø ji'n musipø ndø tzømø, pero ñe'c ji'n suni tø cotzoṉyajø ni usyi. Jetse chi'yajpa aṉgui'mocuy ji'n musipø ndø tzøcø, y ni ñe'c jetsepø ji'n chøcyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mumu ti chøcyajpa na's va'cø isyaj pø'nis que ti nø chøcyaju. Jachø'yupø Diosis 'yote tyucucøsi myesyajpa, y yac pøji'ajyajpa tyucu coso va'cø cyomo'yajø que vøjpø pønete. ");
INSERT INTO zosNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Cuando it søṉdzøjcuy, sunba pyo'csyaj más myøja'ṉombø pøn po'cspamø, y jetsetique't tu'mguy tøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Syunba va'cø yuschi'yajtøjø calle'omo como møja'ṉombø pøn yuschi'yajpase, y syunba va'cø ñøjay aunque i'is que maestrota'mete. ");
INSERT INTO zosNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","”Pero mitz ji'n mus mi ñøjandyandøjø maestro, porque tumdi mi Maestrota'm y Cristote lo que Diosis cyø'vejupø; y mumu mijtzi mi ndyøvøta'mete. ");
INSERT INTO zosNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Y ni i ji'n mus mi janda'aj nascøsi. Tumdi mi Janda lo que tzajpomo ijtupø. ");
INSERT INTO zosNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni ji'n mus mi ñøjmandyandøjø que mi ṉgovi'najø, porque tumdi mi Ṉgovi'najø y Cristote. ");
INSERT INTO zosNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Y más myøja'ṉombø pøn mijtzomda'm tiene que va'cø ñu'csocuy chøcø mitzcøtoyata'm. ");
INSERT INTO zosNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sunba'is myøjacotzøc vyin ñe'cø, maṉba tzø'y como aunque jutzpø pobrese, pero aunque jutzpø pobrese chøcpapø'is vyin, jet maṉba yac møja'ṉo'majtøji. ");
INSERT INTO zosNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","”¡Lástima mijta'm mi aṉmandyambapø'is aṉgui'mocuy y fariseota'm, mi 'yaṉgøma'cø'otyambapøte! Maṉba mi ndyoya'istame. Ji'n mi yac tøjcøyaj pøn Diosis itcu'yomo; ni mi ne'ṉgø ji'n mi ndyøjcøtyame, ni lo que nø tyøjcøyaju, mitz ji'n mi yac tøjcøyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","”¡Lástima mijta'm mi aṉmañdyambapø'is aṉgui'mocuy y fariseota'm, mi 'yaṉgøma'cø'otyambapøte! Maṉba mi istam toya. Porque mi ṉgøpøctamba yaṉbac yomo tyøcji'ṉ y entonces mi ndzøctamba pøjipø conocscuy va'cø ñømnømø que mi ⁿvyøjta'mbøte. Por eso más maṉba mi ṉgyastigatzøctandøji. ");
INSERT INTO zosNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","”¡Lástima mijta'm mi aṉmandyambapø'is aṉgui'mocuy y mi fariseota'm; mi 'yaṉgøma'cø'otyambapøte! Maṉba mi ndyoya'istame. Mi ocvijtamba nasacopac y mar va'cø mi yac pøjcøchoṉ mi va'ṉjajmoṉguy tum pøn. Y cuando pyøjcøchoṉba je'is, más mi ⁿyac yatzi'ajtamba jic pøn que ji'n mi ne'cta'm, y por eso parejo maṉba mi myaṉdam infierno'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","”¡Lástima mijta'm, maṉba mi ndyoya'istame. Como to'tipø pø'nis ji'n mus ñøvit tyo'ti tyøvø, jetse mitzta'mgue't. Sunba mi aṉmandyam mi ndøvø, y mi ne'c mi ⁿjyovinda'm. Porque cuando aunque i'is chamba ti maṉba chøqui y nømba: “Ndza'mbøjtzi masandøjcøsi porque jetse ma'ṉbø ndzøqui”; mi ñømdamba que aunque jetse chamø, ji'ndyet pyena va'cø chøcø. Pero o'ca chamba: “Masandøjcombø orocøsi ndza'mbøjtzi porque ma'ṉba ndzøqui”; entonces mi ñømdamba que tiene que va'cø chøcø, porque chambøc oro. ");
INSERT INTO zosNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mi ⁿjyovinda'm, y ji'n mi ṉgyønøctøyøtyame! Porque masandøc más valetzøcpa que oro, porque masandøjquis cyømasa'nøpya oro. Por eso va'cø chambøc masandøc más valetzøcpa que va'cø chambøc oro. ");
INSERT INTO zosNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Y también o'ca pøn nømba: “Ṉdza'mbøjtzi altarcøsi porque jetse ma ndzøqui”. Entonces mi ñømdamba que ji'ndyet pyena va'cø chøcø aunque altarcøs chamø. Pero o'ca chamba: “Ndza'mbøjtzi altajrom tzi'tøjupø ticøsi que jetse ma'ṉbø ndzøqui”. Entonces mi ñømdamba que tiene que va'cø chøcø. ");
INSERT INTO zosNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Mi ⁿjyovinda'm y ji'n mi ṉgyønøctøyøtyame! Altar más valetzøcpa que altajrombø tzi'tøjcuy, porque altajris cyømasa'nøpya tzi'tøjcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pues i'is chambøcpa altar, ji'n na's jet chambøqui, sino chambøjque'tpa lo que ijtu altajromo. ");
INSERT INTO zosNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Y chambøcpa'is masandøc, ji'n na's masandøc chambøqui, sino Diosti chambøcpa, porque Dios itpa masandøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y chambøcpa'is tzap chambøjque'tpati Diosis pyo'cscuy y chambøjque'tpati pyo'cscuyom po'cspapø. ");
INSERT INTO zosNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","”¡Lástima mijta'm mi aṉmandyambapø'is aṉgui'mocuy y fariseota'm, mi 'yaṉgøma'cø'yotyambapøte! Maṉba mi ndyoya'istame. Mi nducpacse'ṉomo yerbabuena, y eneldo y cominos, mi majcay ve'nba y tum mi ndzi'pa pane Diosis cuentacøsi como ituse aṉgui'mguy, pero usypø angui'mgutite. Jetse mi yaj copujtamba aṉgui'mguy, pero ji'n mi yaj copujtam más myøja'ṉombø aṉgui'mguy. Va'cø ndø tzøc vøjpø justicia'ajcuy, va'cø ndø toya'ñøy ndø tøvø, va'cø ndø va'ṉjam Dios; jetemete más myøja'ṉombø aṉgui'mguy, pero ji'n mi yaj coput jetsepø. Vene mi nø'ijtupø vøjøpøte va'cø mi ndzi' pane Diosis cuentacøsi, pero va' jana mi jajmbø más myøja'ṉombø aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Como to'tipø'is ji'n mus isindzi' ni iyø, jetse mitz ji'n mus mi aṉmay mi ndøvø. Porque como si fuera va'cø ndø nømbut usu cuando ñøjquejcøpya usu'is ndø ujcuy, va'cø jana ndø ndzø'tø usu, pero camello copøn va'cøna'ṉ ndø tzø'tø; jetse mi ndzøctamba. Porque uspø aṉgui'mguy mi yaj coputpa, pero más myøja'ṉombø aṉgui'mguy ji'n mi ndzøjcay cuenda. ");
INSERT INTO zosNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","”¡Lástima mijta'm mi aṉmandyambapø'is aṉgui'mocuy y fariseo'sta'm, mi 'yaṉgøma'cø'yotyambapøte! Maṉba mi istam toya. Como tum pulato tum pozuelo mi ndze'pa vingøsi y jojmo ji'n mi ndze'e; jetse mijtzi mi ndzøcpa mi ⁿvin como vøjpø pønse. Pero jojmo mi ndzoco'yomo mi ṉgui'pstamba va' mi ñu'mø, y mi sundamba aunque ti mi ⁿvingøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mi fariseo, to'tipø pønse ji'n mi ṉgønøctøyøque'te; o'ca mi ṉgøtze'pa pozuelo jojmo, entonces suñi cøva'cpa. Jetse sungue'tpa va'cø mi ñø'it vøjpø qui'psocuy jojmo mi ndzoco'yomo. Entonces, vingøs jetsetique't. ");
INSERT INTO zosNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","”¡Lástima mijta'm mi aṉmandyambapø'is aṉgui'mocuy y fariseota'm, mi 'yaṉgøma'cø'yotyambapøte! Maṉba mi ṉgyastigatzøtandøji. Como popo yaj quejnayajpa ca'upø'is chatøc va'cø suñi quena, pero jojmo it anima pac y musyaṉ quenba; ");
INSERT INTO zosNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","jetsetique't mitzta'm. Aunque mi ndzøctamba mi ⁿvin como vøjpø pønse, pero møsyaṉ mi ṉgui'psocutya'm. Mi ñø'ijtam qui'psocuy va'cø mi aṉgøma'cø'yotyamø y va'cø mi ndzøctam yatzitzoco'yajcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","”¡Lástima mijta'm mi aṉmandyambapø'is aṉgui'mocuy y fariseota'm, mi 'yaṉgøma'cø'yotyambapøte! Maṉba mi ṉgyastigatzøctandøji. Mi ndzøctamba tøc anima tzatøc cuenta para tza'maṉvajcoyajpapøcøtoya y suñi mi yaj quejnayajpa tza' seña cuenta niptøjumø vøjta'mbø pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mi ñømdamba: “O'ca ijtamuna'ṉtzi ya'møc cuando ityajuna'n ø janda tzu'ṉguy, ja ṉgotzoṉdamøna'ṉtzi cuando je'is yaj ca'yaj tza'maṉvajcoyajpapø”. ");
INSERT INTO zosNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jetse mi ne' me va'njamdamba que yaj ca'yajpapø'is tza'maṉvajcoyajpapø, je'is mi 'yuneta'm mijtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Entonces jujche chøctzo'chajuse mi janda tzu'ṉgu'is, jetseti muspa mi ndzoctaṉgue't mijtzi ta'nemø! ");
INSERT INTO zosNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","”¡Como tzanse mi ndzøctamba mijtzi, y como tza'nise mi 'yuneta'm! Ji'n ma mi ṉgyotzoctame, jiṉ tiene que va'cø mi ṉgo'aṉgøtyamø infierno'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jetcøtoya mi nøjandya'mbøjtzi: Ma'ṉba mi ṉgø'vejatyam cha'maṉvacyajpapø'is Diosis 'yote, y qui'psocu'yøyajupø, y myusyajpapø'is aṉgui'mguy. Pero jic øtz ṉgø'vejpapø, vene maṉba mi yaj ca'tame, y vene maṉba mi ma'møtyame cruscøsi, vene maṉba mi nacstochøctame mi ngonocscutyøjcomda'm, maṉba mi macpø'tame cumguñamaye. ");
INSERT INTO zosNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Por eso maṉba mi yaj coja'ajtandøji porque yaj cayajtøju vøjpø pøn. Mumu vøjpø pøn yaj ca'yajtøjupø nascøsi desde que yaj ca'tøj vøjpø pøn Abel hasta que mi ⁿyaj ca'tam Berequiasis 'yune ñøyipø'is Zacarías lo que mi ⁿyaj ca'tamu masandøc y altar cujcomo. Porque yac jø'tayaj jic vøjpø pø'nis ñø'pin, maṉba mi ⁿyaj coja'ajtandøji. ");
INSERT INTO zosNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Viyuṉse mi ndzajmatyamba que mitzta'm yøtita'mbø pøn, maṉba mi yaj coja'ajtandøji porque yac jø'tayajtøj mumu jic vøjpø pø'nis ñø'pin desde vi'nacse'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","”¡Ay mi Jerusalén gumgu'yomda'mbø'is, ay mi Jerusalén gumgu'yomda'mbø'is; mi yaj ca'tambapø'is tza'maṉvajcoyajpapø, y mi mbuṉga'tambapø'is mijta'm pøn lo que Diosis cyø'vejyajupø! ¡Pero como jujche cajsyi'is yac tu'myajpa 'yune syajacø'mø, jetse sone nac sunbana'ṉtzi mi ⁿyac tu'mdaṉgue't øjtzi; pero ja mi sundam jetse! ");
INSERT INTO zosNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tzøctam cuenda que mi ndøc jetseti maṉba mi ndzactam jojquipø. ");
INSERT INTO zosNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Porque mi ndzajmatyambati'tzi que ji'n ma mi ndø istame hasta que mi ñømdamba: “Tø vøjcotzøcta'i jicø nø minupø ndø Comi'is ñøyicøsi”; jicsye'c maṉba mi ndø istaṉgue'te. ");
INSERT INTO zosNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tzu'ṉ Jesús masandøjcomo y nømna'ṉ myaṉu. Y cyønu'cyaj Jesús ñøtuṉdøvø'is va'cø isindzi'yaj jujche suñi quenba masandøc, y eyata'mbø tøc tome isyajtøjpa jetseti queñajque'tpa. ");
INSERT INTO zosNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Y ñøjayaj Jesusis: ―Mi nømaya'ndamba yøṉ masandøc, pero viyuṉse mi nøjandya'mbøjtzi ni tum tza' ji'n ma chø'y ne'csca'mupø tyøvøcøsi, mumu maṉba ju'mbø'yaje. ");
INSERT INTO zosNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Entonces maṉyaj Olivo cotzøjcøsi y jen po'cs Jesús. Cyønu'cyaj Jesús ñøtuṉdøvø'is va'cø ñu'm o'nøyajø, 'yocva'cyaju: ―Tø tzajmay ndøvø jujchøc maṉba tuc jetse mi ndzambase. Cuando maṉba mi mini, y cuando maṉba yajnømi, ¿a ver tiyø seña maṉba iti? ");
INSERT INTO zosNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Y 'yaṉdzoṉ Jesusis ñøjmayaju: ―Tzøctam cuenda ni i'is jana mi 'yaṉgøma'cøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porque ø nøyiṉgøs maṉba miñaj vøti aṉgøma'cø'oyajpapø, maṉba nømyaje: “Øjchøṉ Cristo”. Y maṉba 'yaṉgøma'cøyaj vøti pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Maṉba mi mustame que nø quipnømu, y maṉba chamyaje que it quipcuy emøc. Pero u mi ña'tztamu, porque jetse tiene que va'cø tyucø; pero ji'ndøc ma yajnømi. ");
INSERT INTO zosNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Porque gobierno'is maṉba ñøquipyaj emøcpø gobiernoji'ṉ; y aṉgui'mba'is maṉba ñøquipyaj emøcpø aṉgui'mbaji'ṉ. Maṉba it møja'ṉ yu', maṉba it yatzica'cuy, maṉba it nasamicscø aunque juti. ");
INSERT INTO zosNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jetse maṉba toya'ischo'tznømi. ");
INSERT INTO zosNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","”Entonces maṉba mi ñuctandøji, maṉba mi nchi'ocuyajtandøji va'cø mi yacsutzøctandøji, y maṉba mi yaj ca'tandøji. Y porque mi ndø va'ṉjamdamba aṉcø, por eso jetse maṉba mi ṉgui'satyam aunque i'is. ");
INSERT INTO zosNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Entonces sone maṉba nømyaje: “Mejor ji'n ma va'ṉjame”. Y maṉba na chi'ocu'yajyajtøji y maṉba na qui'sayajtøji. ");
INSERT INTO zosNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Maṉba ityaj vøti cha'maṉvacyajpapø'is sutzcuy y vøti pøn maṉba 'yaṉgøma'cøyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Y como vøti maṉba ñøcøpoyaje yatzi'ajcuy, por eso vøti pøn ji'n ma na syuñajtøji. ");
INSERT INTO zosNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero o'ca mi ndyonba hasta que cøtpa toya, maṉba mi ṉgyotzoque. ");
INSERT INTO zosNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Y mumu nasindumø maṉba tzambucstøji yøṉ vøjpø ote jujche tø aṉgui'mbase y tø coquenbase Diosis, va'cø myusyaj mumu pø'nis aunque jutipø cumgu'yomo. Y jicsye'c maṉba yajnømi. ");
INSERT INTO zosNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","”Tza'maṉvajcopapø Daniejlis jyayu que maṉba it na'nchaṉbø ma's yac tocoyu tzacyaj cumguy. Cuando mi ispa jic na'nchaṉbø tiyø masanbø lugajromo nø tye'nu ―mi ndu'nbapø'is yøṉø, ay que va'cø mi nøctøyøy ti ndzamba―, ");
INSERT INTO zosNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","entonces cuando jen te'nba, Judea nasom ityajupø ay que va'cø pyoyajø, va'cø myaṉyaj cotzojcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tøjcøcopajcøsi ijtupø, tiene que va'cø myø'nø y tumønajcøsi va'cø pyoya, ji'n ma it lugar va'cø tyøjcøy tyøjcomo va'cø ñøput aunque tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tza'ma'omo ijtupø tiene que va'cø pyotyucø, jana vitu' tyøcmø va'cø mye'tz tyucu. ");
INSERT INTO zosNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Y jic jama más maṉba isyaj toya yomo ji'ndyet tyumbø, y ijtu'is 'yune yac tzu'tzpapø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pero va'ctam Dioscøsi va'cø jana mi mbyotyam pacac aṉsø'ṉomo o sapøjcuy jama'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porque jic jama maṉba it myøja'ṉombø toya'iscuy. Desde que tzo'tz nasacopac nunca ja istøj jetsepø, hasta jicsye'c ma istøji, y jøsi'cam nuṉca ji'n ma istøjque't jetsepø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","O'ca Diosis ji'na'ṉ yaj toya'iscuy, ni i ji'na'ṉ cyotzoque; pero Diosis maṉba yaj toya'iscuy va'cø cyotzocyaj pøn lo que jutipø cyøpiṉyaj ñe'cø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","”Entonces jicsye'c o'ca aunque i'is mi ñøjandyamba: “Mi a'mø, yø'c it Cristo”; u mi va'ṉjamdamu. O'ca mi ñøjandyamba: “Jendi ijtu”; u mi va'ṉjamdamu. ");
INSERT INTO zosNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porque maṉba miñaj aṉgøma'cø'oyajpapø; maṉba chøcyaj vyin como si fuera Cristo; maṉba nømyaj je pønda'm: “Øjchønø tza'maṉvajcopyapø”. Maṉba chøcyaj ji'n ndø isipø tiyø y milagro'ajcuy va'cø 'yaṉgøma'cøyaj Diosis cyøpiṉyaju pøn; o'ca pya'tyajpana'ṉ jujche va'cø 'yaṉgøma'cøyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mi ndzajmatyamu'am va'cø mi ndzøjcatyam cuenda ti maṉba iti. ");
INSERT INTO zosNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Por eso o'ca mi ñøjandyandøjpa: “Jendi it Cristo jya'ijnømømø”; aunque jetse mi ñøjandyandøjpa, u mi va'ṉjamdamu, u mi myaṉdamu. Y o'ca mi ñøjandyamba: “Jendi ijtu tøjcomo”, u mi va'ṉjamdamu o'ca jendi ijtu. ");
INSERT INTO zosNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porque como rayo'is ñe'mgø'is syø'ṉoctaspa tzap va'cø quej desde jama qui'mgucyøsi aunque juti hasta jama tø'pcucyøsi, jetse ma mingue't øjtzi; øtz mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Porque jut ijtumø ca'upø, jen tu'myajpa ju'qui. ");
INSERT INTO zosNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","”Entonces cuando cøjtu'cam jic toya'iscuy, misma hora maṉba tu'yi jama, y poya ji'ndi ma syø'ṉgue'te; tzapcøspø matza maṉba quecyaje, y tzajpom ityajupø pømi'øyupø tiyø maṉba micsyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jicsye'c maṉba quej tzajpomo cotzambapø'stzi que nø'mø minu, øtz mumu Pø'nis chøṉ Tyøvø. Entonces mumu nascøsta'mbø pøn maṉba vo'yaje toyapøcyaje. Porque maṉba isyaj øjtzi nø minupø tzapcøspø o'na'omo pømi'øcyo'nupø, y møja'ṉ sø'ṉbapø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma'ṉbø ṉgø'vejyaj ø aṉgeles va'cø ñømu'tu'mbøyaj cøpiṉyajupø pøn. Pømi maṉba mu'yaje. Maṉba mye'tzaṉdø'pyaje yømøc teymøc ityajupø, maṉba tzu'ṉyaje mumu nasindumø cøyaju'cse'ṉom tzap. ");
INSERT INTO zosNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","”Pero ay que va'cø mi ṉgønøctøyøtyamø jujche higo cuy vo'mbase, jetseti it aṉma'yocuy. Cuando yava'ajpa tzu'ṉba 'yaṉmaṉ y cøvo'mba 'yaji'ṉ, mi mustamba que maṉba tøjcøy ja'maṉsøṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jetsetique't cuando mi ispa nø tyucnøm mumu øtz mi ndzajmayuse, entonces mi mustamba que ya mero maṉba min øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Viyuṉse mi ndzajmatyamba que mumu øtz ndzamuse maṉba tucnømi antes que ca'pø'yajpa yøti ityajupø pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maṉba yajyaj tzap y nas, pero ø onde ji'n ma cøyaj nunca. ");
INSERT INTO zosNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","”Pero jujchøc y tiyø jama øtz maṉba mini, ni i'is ji'n myusi. Ni aṉgelesis tzajpom ityajupø'is ji'n myusyaje; ni øtz Diosis chøṉ 'Yune ji'n ø musi, na más ndø Janda Diosis myuspa. ");
INSERT INTO zosNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","”Como tucnømuse vi'na jic jama cuando ijtu'cna'ṉ Noé, jetse maṉbati tucnøṉgue'te cuando minba'c øjtzi, øtz mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Porque jic jama antes que oy jøt ca'nømi, nømna'ṉ cyu'tyaju; nømna'ṉ 'yucyaju; ijtuna'ṉ co'tøjcajcuy; syajyaj 'yune va'cø cyo'tøjcajyajø, hasta je jama cuando tøjcøy Noé møjapø barco'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Y ji'na'ṉ myusyaje o'ca maṉba it jø'tø y de repente put jø'tø y mumu pøn jø'tpø'nømu; jetseti ma tucnøṉgue'te cuando mingue'tpøjtzi; jana møyiti ma mini cuando ni i's ji'n nø myusu'øc o'ca maṉba mini øjtzi mumu Pø'nis chøn Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jicsye'c maṉba ityaj metz pøn nø yosyajupø tza'momo, tum maṉba nømandøji, tum maṉba tzactøj jeni. ");
INSERT INTO zosNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Maṉba ityaj metzcuy yomo nømna'ṉ myetzvayaju tumbø vacucha'cøsi. Tum maṉba ñømaṉdøji; tum maṉba tzactøj jeni. ");
INSERT INTO zosNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","”Por eso comeque'ajtamø va'cø aṉjo'nga, porque ji'n mi mustam tiyø ora øtz ma'ṉba mini, øjchøṉ mi ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pero qui'psminø que o'ca myuspana'ṉ vø'tøjquis tiyø ora minba nu'mbapø, cyoquenbana'ṉ tyøc va'cø jana cyønu'mdøjø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jetseti mitz jajmecøs ijtaṉgue'ta va'cø mi ndø ⁿaṉjo'ctamø. Porque cuando ji'n mi ṉgui'pstame'øc o'ca ma'ṉba mini, entonces jicsye'c ma'ṉbø mini, øtz mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","”Jujche ijtu coyospapø vøjpø y qui'psocu'yøyupø, jetseti sunba va'cø mi ijtaṉgue't mijtzi. Jetsepø pøn maṉba chac vø'tøjquis va'cø 'yaṉgui'myaj coyosyajpapø, va'cø pyø'nøyajø cuando nu'cpa hora. ");
INSERT INTO zosNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Entonces cuando minba vø'tøc, o'ca nømdi chøjcu como 'yaṉgui'mu tzajcuse, contento tzø'pya jic coyospapø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Viyuṉse mi nøjandya'mbøjtzi que vø'tøjquis chamdzajcapya jetsepø coyospapø va'cø cuendatzøcø mumu ti ñø'ijtupø. ");
INSERT INTO zosNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero o'ca je coyospapø yatzipøte, nømba chocø'yomo: “Ø ṉgomi maṉbatøc ya'e va' minø”. ");
INSERT INTO zosNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Entonces yacsutzøctzo'chajpa coyosyajpapø tyøvø y cyu'tpa y 'yucpa no'tpa tyøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pero cuando ji'n nø ñi'aṉjajmu o'ca ma mini, je jama nu'cpa je coyospapø'is cyomi, y nu'cpa je ora ji'n nø myusu'c o'ca ma nu'qui. ");
INSERT INTO zosNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Entonces vø'tøjquis maṉba yaj ca' je coyospapø y maṉba tyumøcot aṉgøma'cø'yoyajpapøji'ṉ. Jiṉ maṉba vo'yaje y maṉba cyø'syaj tyøtz toyapit. Jetse maṉba mi nductaṉgue'te o'ca jetseti mi ndzøjque'tpa cuando mi'nbøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","”Maṉba ndza'maṉvaque jujche tzajpomopø Diosis 'yaṉgui'mguy. Es como majcay papiñomo maṉba'is 'ya'myaj co'tøjcajcuy. Ño'aji'ṉ maṉyaju va'cø ño'a tzoṉyaj pøn maṉbapø co'tøjcaje. ");
INSERT INTO zosNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pero ityaj mosay qui'psocu'yøyajupø, y mosay ja ñø'itø'is qui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jovita'mbø'is ñømaṉyaj quinque, pero ja ñømaṉyaj gas sobra; ");
INSERT INTO zosNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","mientras ityaju'is qui'psocuy sobra ñømaṉyaj gas quinqueji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pero como ya'yu va'cø min pøn maṉbapø cotøjcaje, pe'ṉguy nayaju papiñomo y øṉbacyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Entonces como paṉguctzu vejnømu: “Jicø nø min pøn maṉbapø cøtojcaje. Tzu'ṉdamø va'cø mi ndzoṉdamø”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Entonces papiñomo sa'yaj mumu y vyøjøtzøcyaj quinque. ");
INSERT INTO zosNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Y jovita'mbø'is ñøjayaj qui'psocu'yøyajupø: “Tø ve'ndzi'tam mi ṉgas, nø tu'yu ø no'a”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero qui'psocu'yøyajupø'is 'yaṉdzoṉyaju: “Ji'nø mus mi ve'ndzi'tamø porque ji'n ma cyopa'te mumu pøngøtoya. Mejor ma ⁿjutyam mi ne'c ma'atyøjpamø”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Entonces mientras maṉ jyuyaj gas, entonces min je maṉbapø co'tøjcaj pøn. Ityaju'is gas tøjcøyaj je pønji'ṉ co'tøjcajcu'yomo y 'yaṉga'myaj aṉdyun. ");
INSERT INTO zosNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Después usyaṉ oracøsi miñaj maṉupø'is jyuyaj gas, y tøc aṉga'mdøjumna'ṉ. Y ñøjayaju: “¡Señor, Señor; tø aṉvajcatya aṉdyuṉ!” ");
INSERT INTO zosNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero 'yaṉdzoṉba je'is ñøjapya: “Viyuṉse nø mi ndzajmatyamu, ji'nø mi ṉgo'ispøctame i'nda'me mijtzi”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Y entonces Jesusis ñøjmayaju: ―Jetsetique't mijtzi como qui'psocu'yøyajupø papiñomo, jetse jana co'øṉguy ijtamø mientras mi ndø ⁿjo'ctamba øjtzi; porque ji'n mi mustame tiyø jama tiyø ora ma'ṉbø mini, øjtzi mumu Pø'nis chøṉ Tyøvø. Jesús aṉma'yo'ya'ṉøyu, nømu: ");
INSERT INTO zosNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","―Como tum pøn oyu paschøc ya'i eyaco cumgu'yomo, jetseti Diosis 'yaṉgui'mgucye't. Antes que maṉba, pø'nis vyejtu'myaj coyosyajpapø va'cø chi'yaj tumin va'cø ñøyosyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","”Y tumbøn chi' mosay mil, eyapø chi' metza mil, eyapø tumø mil chi'u. Tumdum pøn chi'u jujche'ṉom 'yaṉjam muspa ñøyosa. ");
INSERT INTO zosNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Y pyøcøchoṉu'is mosay mil maṉ ñøyose, y chøjcaṉvajcu y ta'n majcay mil. ");
INSERT INTO zosNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Y pyøcøchoṉu'is metza mil chøjcaṉvajque'tu, y ta'n macsycuy mil. ");
INSERT INTO zosNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero pyøjcøchoṉu'is tumø mil maṉ ñipcøvø'nay cyomi'is tyumin nasacø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","”Y cøjtu'cam vøti jama pyøcyajumø tumin, min cyoyosyajpa'is cyomi y 'ya'myaju jujche yaj cøpucsyaj tumin. ");
INSERT INTO zosNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Entonces nu'cu pyøjcøchonu'is mosay mil; y otro mosay mil ñømi'naṉøyu y nømu: “Señor, mosay mil tumin mi ndø tzajcayu. Yø'c it mbøjcu mosay mil y mosay mijlam it 'yune”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Y ñøjay cyomi'is: “Vøj mi ndzøjcu; mus mi ⁿnøyosa. Mi ndzøc øtz sunbase. Cuando mi ndzi'ø usyi y mi ⁿnøyos øtz sunbase, por eso maṉba mi ⁿyac aṉgui'm vøti ticøsi. Tøjcøyø y tø casøtyam parejo”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Y min pyøjcu'is metza mil y nømu: “Señor, metza mil mi ndø tzajcayu. Yøc it mbøjcu metza mil, y metza mijlam it 'yune”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Y ñøjay cyomi'is: “Vøj mi ndzøjcu; mus mi ⁿnøyosa. Mi ndzøc øtz sunbase. Cuando mi ndzi'ø usyi, mi ⁿnøyos øtz sunbase. Por eso maṉba mi yac aṉgui'm vøti ticøsi. Tøjcøyø y tø casøtyam parejo”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Y mingue'tu pyøcøchoṉu'is tumø mil y nømu: “Musøjtzi que paqui chocopya mi mbyøn mijtzi. Eyapø mi yac yosyajpa vøti va' mi nø'itø yosaṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Por eso ṉgona'tzøjtzi y nipcøvø'nøjtzi mi ndumin nasacø'mø. Yøti yø'c it mi ndumin mi ndø tzi'use”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Entonces cyomi'is ñøjayu: “Mitz mi ⁿyandzipøte, mi ⁿjyarganbøte. Mi muspati que øtz ⁿyac yosyajpa eyapø vøti va' it ø ⁿyosaṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jetcøtoya masna'ṉ vøjø va'cø mi ngot tumin coyojtøjpamø tumin une, y entonces cuando vitu'ca'mtzi, mbøjcøchoṉbana'ṉ ø ndumin 'yuneji'ṉbøti'am”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Y cyomi'is ñøjay eyapø coyospapø: “Ñø'ijtupø'is tumø mil, yac jøcøjayø y tzi'tam ñø'ijtu'is majcay. ");
INSERT INTO zosNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porque ñø'ijtu'sam vøti, jet maṉba tzi'a'ṉøtyøji, y maṉba it más de la cuenta. Pero ñø'ijtu'is usyi, jet maṉba yac jøcøjatyøj usy ñø'ijtupø; ");
INSERT INTO zosNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","y ji'n vyøjpø coyospapø patzpø'tøjø a'ṉgomo pi'tzø'ajcu'yomo. Jin maṉba vo'e, y toyapit maṉba cyø's tyøtz”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","”Cuando mi'nbøjtzi mumu Pø'nis chøṉ Tyøvø, ma'ṉbø møja'ṉ aṉgui'mi, maṉba miñaj øtzji'ṉ masanbø aṉgeles, y ma'ṉbø po'cs møja'ṉ aṉgui'mba'is pyo'cscu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Y ma'ṉbø vejtu'myaj mumu aunque jutpø nascøsta'mbø pøn va'cø tu'myaj ø vi'naṉdøjqui. Y ma'ṉbø mbi'ṉaṉdø'p vøjpø. Ne'ti ma'ṉbø ngot vøjpø y ne'ti ji'n vyøjpø, como cyoquenbapø'is pyi'ṉaṉdøjpa pyø'nøcuy; aparte cyotpa borrego, aparte cyotpa chivu. ");
INSERT INTO zosNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Cyotpa borrego chø'na'ṉomo, y chivu cyotpa 'yaṉna'yomo. Jetse øtz ma'ṉbø ṉgøpiṉ pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Como øjchøṉ møja'ṉ aṉgui'mbapø, ma'ṉbø ⁿnøjayaj ø ndzøna'ṉom ityajupø: “Mindamø va'cø mi ⁿyaj contento'ajtamø ndø Janda Diosis. Como erejencha cuenta mi ndzi'pa vøjpø itcuy 'yaṉgui'mbamø Dios. Porque it jetsepø itcuy vyøjøtzøjcupø para mitzcøtoya desde que Diosis jyomec nasacopac. ");
INSERT INTO zosNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Porque nømna'ṉø osu, y mi ndø tzi'tam cu'tcuy; nømna'ṉø yo'ctøjtzu, y mi ndø tzi'tam nø'; nømna'ṉø vijtu ji'n comusimø lugar, y mi ndø nu'cschi' jejcuy. ");
INSERT INTO zosNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ja itøna'ṉ ø nducu, y mitz mi ndø tzi'tamu; ca'ena'ṉtzi y mi ndø tu'ndamu; somdøjuna'ṉtzi preso'omo, y mi ndø o'nøndyamu”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Entonces vøjta'mbø pø'nis maṉba nøjayaj øjtzi: “Pero øjtzø mi Ṉgomi, ¿jutznømø jetze va' mi ñømø? Øtz nunca ja mi istam nø mi ⁿ'yosupø, y mi ndzi'tam cu'tcuy; øtz nunca ja mi istam nø mi ⁿyo'ctøjtzupø; y o mi ndzi'tam nø'. ");
INSERT INTO zosNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ni øtz nunca ja mi istam nø mi ⁿvyijtupø ji'n mi ṉgomusimø lugar y mi nu'cschi'tam jejcuy. Ni ja mi ndzi'tam tucu cuando ja itøna'ṉ mi nducu porque ja mi ista'møjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ni nunca ja mi istam ṉgya'epø o syomdøjupø preso'omo va'cø mi o'nøndyamø”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Entonces øjchøṉ møja'ṉ aṉgui'mbapø ma'ṉbø ⁿnøjayaje: “Viyuṉse mi ndzajmatya'mbøjtzi; cuando mi ndoya'nøtyam aunque jutipø ø ndøvø aunque ja itø'is 'yaṉgui'mguy, es como øjtzi mi ndø ndoya'ṉøtyamu”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","”Entonces øtz ma'ṉbø ⁿnøjayaj ø aṉna'yom ityajupø: “Mi ñchu'ṉdam øtzcø'mø, mi ndyocotyamupøte. Maṉba mi ṉgojtandøji nunca ji'n tu'yipø juctyøjcomo lo que jutipø juctyøc Diosis vyøjøtzøjcu diablocøtoya y je'is 'yaṉgelescøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Porque nømna'ṉø osu, y ja mi ndø tzi'tam cu'tcuy; nømna'ṉø yo'ctøjtzu, y ja mi ndø tzi'tam nø'. ");
INSERT INTO zosNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nømna'ṉø vit ji'n ø ṉgomusimø, y ja mi ndø tzi'tam jejcuy; ja itøna'ṉ ø nducu, y ja mi ndø tzi'tam tucu; ca'ena'ṉtzi y ja mi ndø tu'ndamø; somdøjuna'ṉtzi preso'omo, ja mi ndø o'nøtyamø”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Entonces 'yaṉña'yomda'mbø'is maṉba 'yaṉdzoṉyaje: “Pero øjtzø mi Ṉgomi, ¿jutznøm jetse mi ñømba? Øtz nuṉca ja mi istam nø mi ⁿ'yosupø, nunca ja mi istam nø mi ⁿvyijtupø ji'n mi ṉgomusimø; ni ja mi istam jana tucu nø mi ⁿvyijtu'c, ni ja mi istam ṉgya'epø, ni ja mi istam preso'omo; porque o'ca jetse mi istamuna'ṉ nø mi ndyoya'isupø, mi ndoya'ṉøtyamuna'ṉtzi”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Entonces øtz ma'ṉbø 'yandzoṉyaje: “Viyuṉsye mi ndzajmatya'mbøjtzi; cuando ja mi ndoya'ṉøytamø aunque jutipø pøn aunque ja itø'is 'yaṉgui'mguy; jetse ndøvø ja mi ndø toya'ṉøtyaṉgue'ta”. ");
INSERT INTO zosNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Y jic pøn maṉba maṉyaj ji'n yajepø castigo'omo. Pero vøjpø pøn maṉba maṉyaj tø quenbamø mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Entonces cuando yaj jetsepø aṉmacuy, Jesusis ñøjayaj ñøtuṉdøvø: ");
INSERT INTO zosNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Mi mustambati que metza jamacøs maṉba sø'ṉajyaj pascua søṉ. Y jicsye'c øjtzi mumu Pø'nis chøṉ Tyøvø maṉba tzi'ocuyajtøji va'cø yaj ca'tøj ma'møtyøjupø cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Entonces tu'mbø'yaj pane covi'najø, y aṉgui'mguji'ṉ aṉma'yoyajpapø, y Israel tzambøn. Tu'mbøyaju más myøja'ṉombø pane covi'najø'is 'yaṉgui'mguy tøjcomo; más myøja'ṉombø pane covi'najø ñøyipø'is Caifás. ");
INSERT INTO zosNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jeni qui'pscøpoyaju jujche va'cø ñu'mnucyaj Jesús va'cø yaj ca'yajø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero nømyaju: ―Mejor uy ndø nucta'i søṉ jama'omo utim cyoquipyaj vøti pø'nis, uytim so'natejyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Entonces cuando ijtuna'ṉ Jesús Betania cumgu'yomo, o covit Simo'nis tyøjcomo. Simón yachputzi'øyuna'ṉ vi'na. ");
INSERT INTO zosNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mientras que jendi ijtu, cyømin Jesús tum yomo'is. Je yomo'is ñø'min tum alabastro tza'pø cojtocuy ijtupø'om suñi viquicpapø perfume vøti coyojapø. Y mientras que Jesús po'csuna'ṉ mesacø'mø, yomo'is cyøtijtøjay cyopac perfumeji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pero cuando Jesusis ñøtuṉdøvø'is isyaju ti chøjcay Jesús, qui'syca'yaju, nømyaju: ―¿Ticøtoya titpø'tochøc perfume? ");
INSERT INTO zosNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","O'cana'ṉ ja titpø'ø, muspana'ṉ ndø ma'ajø vøti tumingøsi, y ndø tzi'tambana'ṉ tumin pobre. ");
INSERT INTO zosNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Cuando Jesusis myusu ti nø chamyaju, ñøjayaju: ―¿Ticøtoya mi 'yojnandyamba je yomo? Vøjpø ti chøjcu øtzcøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Porque pobre mumu jama mitzji'ṉ ityajpa, pero øtz ji'nø ma it mumu jama mitzji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Porque cuando cøtijtøjay øjtzi perfumeji'ṉ, jetse chøjcu va'cø vyøjøtzøc ø ngoṉña va'cø niptøjø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Viyuṉse mi ndzajmatya'mbøjtzi, aunque juti tzamgøpucstøjpa yøṉ vøjpø ote aunque nasindumø, jetseti maṉba tzambotyøjque't ti chøc yøṉ yomo'is va'cø jyajmøtzøctøjø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Entonces tum macvøstøjcapyø nøtuṉdøvø ñøyi'ajupø'is Judas Iscariote maṉ 'yo'nøyaje pane covi'najø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Y ñøjayaju: ―O'ca mi ndzi'ocuyajpa Jesús, ¿y jujche mi ndø tzi'pa? Y vyø'møyaju va'cø cyoyojyaj Judas treinta platapø tumin o'ca chi'ocuyajpa Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Y desde jicse'c Judasis jyajme'tzu jujche va'cø chi'ocuyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Entonces je jama cuando tzo'tz sø'ṉajcuy cuando cyø'syajpa ja pyoṉoṉapø pan, ñøtuṉdøvø'is cyønu'cyaj Jesús y 'yocva'cyaju ñøjayaju: ―¿Jut maṉba ndø comeque'ajtamø va'cø ndø vi'c pascua søṉ gu'tcuy? ");
INSERT INTO zosNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Y Jesusis ñøjayaju: ―Maṉdyam cumgu'yomo, jic pø'nis tyøjcom maṉdyamø, y nøjatyamø: “Ø Ṉgovi'najø'is mi ṉgyø'vejay ote mi ñøjambya: Ya mero ma nu'c ø ⁿhøra. Mi ndøcmø ma'ṉba ⁿvi'ctam pascua søṉ gutcuy ø nønduṉdøvøji'ṉ”. ");
INSERT INTO zosNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Como jujche chajmayajuse Jesusis, jetse chøcyaj ñøtuṉdøvø'is. Jen cyomeque'ajyaj cu'tcuy pascua sø'ṉgøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Y cuando tzu'i'ajnømu, jendina'ṉ po'csyaj Jesús mesacø'mø macvøstøjcay ñøtuṉdøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mientras nømna'ṉ vi'caṉbacyaju, ñøjayaj Jesusis: ―Viyuṉsye mi ndzajmatya'mbøjtzi, mijtzomda'mdi it ma's ø tzi'ocuyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Entonces maya'co'ñaju y 'yocva'cyaj Jesús tumdum pø'nis: ―Ø mi Ṉgomi, ¿ji'nat ndøvø nø mi ndzamu que øtz maṉba mi ndzi'ocu'yaje? ");
INSERT INTO zosNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Y 'yaṉdzonyaj Jesusis ñøjayaju: ―Tumø ñuṉbapø'is paṉ øtzji'ṉ tumbø pulatu'omo, je'is ma'ṉba ø tzi'ocuyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Viyuṉsye como jujche it jachø'yuse totocøsi, jetse ma'ṉbø ca'e øjtzi mumu Pø'nis chøṉ Tyøvø. Pero lástima jic pøn maṉbapø'is ø tzi'ocuyaje porque maṉba is toya. Mastina'ṉ vøjø jic pøn o'ca ja pyø'najøna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Entonces tzi'ocuyajpapø'is Judasis ñøjay Jesús: ―Maestro, ¿ji'nat øjtzi ma'ṉbø mi ndzi'ocuyaje? Y Jesusis 'yaṉdzonu ñøjayu: ―Jø'ø, mijtzete. ");
INSERT INTO zosNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mientras que nømna'ṉ cyu'tyaju, Jesusis pyøc pan y ñøjay Dios yøscøtoya, y vyendzi'yaj ñøtundøvø. Entonces ñøjmayaju: ―Pøctamø, cu'jtamø; yøṉ øjchøṉ sis. ");
INSERT INTO zosNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Y luego pyøc tasa, y ñøjacye't Dios yøscøtoya. Y entonces chi'yaj ñøtundøvø ñøjayaju: ―To'ṉ ve'ndam mumu pøn parejo. ");
INSERT INTO zosNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Porque yøṉ vino øjchøṉ nø'mbin. Ø nø'mbin señate que Diosis chøc jomepø contrato. Ø nø'mbin maṉba jøtpø vøti pøngøtoya va'cø yaj cøtocojayajtøj cyoja. ");
INSERT INTO zosNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mi nøjandyamba mijtzi que ji'n majtøc ma ndø'ṉe uva tø'mis ñø' hasta jicsye'ctøc ma'ṉbø ndo'ṉvøjøtzøqui jomepø mitzji'nda'm ndø Janda Dios 'yaṉgui'mbamø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Entonces vañaj tum vane y después tzu'ṉyaju maṉyaj Olivo cotzøjcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Y jeni Jesusis ñøjayaju: ―Yøṉ mismo tzu'cøsi maṉba mi ndø pochacpø'tam mumu. Porque jetse it jachø'yupø totocøsi que Dios nømu: “Ma'ṉba ⁿyaj ca' cyoquenbapø'is borrego, y borrego maṉba poytocoyaje”. ");
INSERT INTO zosNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero después cuando visa'pa øjtzi, maṉba vi'na mave Galilea nasomo, y mitz maṉba maṉdyam jøsi'jcam. ");
INSERT INTO zosNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Entonces Pedro'is ñøjay Jesús: ―Aunque mi mbyochacpø'yajpa eyata'mbø'is, øtz ji'nø mi mbochac nunca. ");
INSERT INTO zosNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pero ñøjay Jesusis: ―Viyuṉse nø mi ndzajmayu que antes que vejpa ṉgaylu yøṉ tzu'cøsi, tu'cañac maṉba mi ñømi que ji'ṉ mi ndø co'ispøqui. ");
INSERT INTO zosNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Y ñøjay Pedro'is: ―Aunque yaj ca'yajpøjtzi; ji'nø nømi nunca que ji'nø mi ngo'ispøqui. Y jetse nømyaj mumu ñøtuṉdøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Y jicsye'c nu'cyaj Jesús ñøtuṉdøvøji'ṉ tum lugajromo ñøyi'ajupø'is Getsemaní, y ñøjayaj Jesusis: ―Po'cstam yø'qui mientras que ma'ṉbø øtz mas jojmo; ma'ṉbø o'nøy Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Y ñømaṉyaj Jesusis Pedro y metzcuy Zebedeo'is 'yune; maṉyaj más jojmo y jeni Jesús vøti tzocotocho'tzu maya'cu'is. ");
INSERT INTO zosNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Y ñøjayaj Jesusis: ―Nø maya'co'nu ø ndzocoy como maṉbase ca'e. Yø'c tø jo'ctamø, jana co'øṉguy ijtam øtzcøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Entonces Jesús ma'ṉaṉøcye't usyøc y japneyu'c nascøsi, 'yo'nøy Dios nømu: ―Ø Janda; a ver si o'ca muspa mi ndø yaj cotzoc ndøvø va'cø jana is yøṉ toya, pero mitz mi sunbase tzøcø, u mi ndzøc øtz sunbase. ");
INSERT INTO zosNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Y vitu'u ityajumø ñøtundøvø, y øṉupø pya'tyaju. Y ñøjay Pedro: ―Ja mus mi ndø jo'c ni tumø hora; 'yøṉ mijtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jana co'øṉguy ijtamø y o'nøtyam Dios va'cø jana mi ṉgyojapa'tamø. Viyuṉsye mi ndzoco'yomo sunba mi ndø jo'ctamø, pero mi sis mochita'mbøte. ");
INSERT INTO zosNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Y myenajcøsi vøcomaṉgue'tuti y 'yo'nøy Dios, ñøjayu: ―Ø Janda; o'ca ji'na mus mi ndø yaj cotzoc ndøvø va'cø jana is toya, tzøc mi sunbase mijtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Y vituque'tu, y øṉupøti pyatyajque'tu ñøtuṉdøvø porque cyøpøcyaj øvi'is. ");
INSERT INTO zosNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Y chacyaju, jiṉdi vøcomangue't Jesús jojmo. Y jetseti 'yo'nøcye't Dios tu'cay na'como mismo oteji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jøsi'cam cyømiñajque't Jesusis ñøtuṉdøvø y ñøjayaju: ―Øṉdyama'am y sapøctamø. Yøti nu'cu'am hora va'cø tzi'ocuyajtøj øjtzi mumu Pø'nis chøṉ Tyøvø cojapa'tyajupø pø'nis cyø'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Te'nchu'ṉdama'am va'cø tø maṉdamø. Jicø nøm min maṉbapø'is ø tzi'ocuyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Y jetsetøc nø ñømu'c Jesús, cuando nu'c Judas, Jesusis ñøtuṉdøvøque't. Jesusis ñøtuṉdøvø ta'ñaj doce Judasji'ṉ. Y Judasji'ṉ miñajque't vøtipøn espadaji'ṉ y cuji'ṉ, pane covi'najø'is y Israel tzambø'nis cyøvejyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Chi'ocuyajupø'is oyuna'ṉ chajmayaje jutznøm ma musyaj jutipø ma ñucyaje, nømu: ―Jutipø øtz su'cpøjtzi, jetømete, jet nuctamø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Y cuando nu'c Judas, entonces viyuṉ maṉ Jesuscø'mø, y ñøjayu: ―¿Sya'satija, Maestro? Y syu'cu. ");
INSERT INTO zosNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Y Jesusis ñøjayu: ―Tøvøy, ¿ticøtoya mi minu? Jicsye'c cyønu'cyaj Jesús y ñucyaju va'cø ñømaṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Y misma hora tumø Jesusis ñøtuṉdøvø'is tyusput 'yespada y pane covi'najø'is ñu'cscu'is tyatzøc tyøcspø'jayu. ");
INSERT INTO zosNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Y Jesusis ñøjmay chejtzupø'is: ―Majtzøyø mi espada ñaca'omo; porque mumu quipyajpapø espadaji'ṉ, mismo espadaji'ṉ ma yaj ca'tøjque't ñe'cø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mi mustambati que øtz muspana'ṉ ⁿva'ṉgø ø Jandacøsi vøti mil angeles va'cø cotzo'ṉøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero o'ca jetse, ji'na'ṉ tyuqui jachø'yuse, porque it jachø'yupø yø'cse va'cø tyucø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Y misma hora nøjmay Jesusis vøti pøn minu'is ñucyaje: ―¿Ti'ajcuy mi mindamu espadaji'ṉ y cuji'ṉ siendo øtz ji'ndyet chøṉ nu'mba pøn, va'cø mi ndø nuctamø como ñucyajpase nu'mba pøn? Mumu jamatina'ṉ po'csøjtzi masandøjcomo va'cø aṉma'yoya y ja mi ndø nuctam jicsye'cti. ");
INSERT INTO zosNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero yø'cse nø tyujcu va'cø viyu'ṉaj lo que jyayajuse tza'maṉvajcoyajpapø pø'nis. Entonces mumu Jesusis ñøtuṉdøvø'is pyochacpø'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Entonces ñucyaju'is ñømaṉyaj Jesús más covi'najøpø pane Caifasis tyøjcomo. Jena'ṉ ityaj tu'myajupø aṉma'yoyajpapø aṉgui'mguji'ṉ y Israel pø'nis chambønda'm. ");
INSERT INTO zosNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Y Pedro'is maṉ pya'te, pero ya'i pactzø'yu. Oyuti nu'c hasta pane covi'najø'is tyøjcomo y jen tøjcøyu y po'cs coyosyajpapøji'ṉ. Maṉ a'm a ver jujche ma tuc Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Y pane covi'najø'sta'm y tzambø'nista'm y mumu aṉgui'myajpapø'is mye'tzayajpana'ṉ jujche muspa cyøsujtzøyajø Jesús. Sunbana'ṉ cyojacøtzøjcøyajø va'cø yaj ca'yajø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Aunque nu'cyaj vøti cyøsujtzøyajpapø'is, pero ni jujche ja pya'tayaj cyoja. Al fin nu'cyaj metzcuy cyøsujtzøyajupø'is. ");
INSERT INTO zosNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Y nømyaju. ―Yøṉ jetse nømu: “øtz muspa ⁿju'mbø yøṉ masandøc y tu'ca jamacøsi muspa ndzøcvøjøtzøcø”. ");
INSERT INTO zosNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Entonces te'nchu'ṉu más myøja'ṉombø pane y ñøjay Jesús: ―¿Ti'ajcuy ji'n mi 'yaṉdzo'ṉoye? ¿Jujche mi aṉdzo'ṉopya que jujche mi ṉgyøtza'møyaju? ");
INSERT INTO zosNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero Jesús ni jujche ja 'yoteputø. Entonces myøja'ṉombø pane'is ñøjmayu: ―Yøti mi aṉgui'mbøjtzi quenbapø Diosis ñøyicøsi va'cø mi ndø tzajmayø o'ca viyuṉsye mijtzete Cristo Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesusis 'yaṉdzoṉu: ―Øjchøṉø jic mi ndzamuse. Y también mi ndzajmatya'mbøjtzi que jøsicam maṉba mi ndø istam øjtzi mumu Pø'nis chøṉ Tyøvø po'csupø pømi'øyupø Diosji'ṉ parejo va'cø aṉgui'mdamø, y maṉba mi ndø istaṉgue't tzajpacujqui o'nacøs nø minupø. ");
INSERT INTO zosNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Entonces myøja'ṉombø pane'is chitz tyucu corajepit y nømu: ―Yøṉ pø'nis cyø'o'nøy Dios porque Diose cyomo'pya vyin. ¿Ticøtoya maṉba ndø me'tztam mas cyøtza'møyajpapø'is? Mi ne'c mi mandamu jujche cyø'o'nøy Dios. ");
INSERT INTO zosNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ti mi ndzamdamba? Y 'yaṉdzoṉyaju: ―Vøj va'cø yaj ca'tøjø porque it cyoja. ");
INSERT INTO zosNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Entonces vyi'nøc tzujøyaju y chaṉyaju. Eyapø'is vyi'nøctza'ṉøyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Y ñøjayaju: ―O'ca mijtzete Cristo, tø tzajmay i'is mi nchaṉu. ");
INSERT INTO zosNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mientras jetse tujcu, Pedro po'csuna'ṉ a'ṉgomo solajromo, y cyønu'c Pedro tum coyomo'is y ñøjayu: ―Mitz también Galilea'ombø Jesusji'ṉ nømna'ṉ mi ⁿvyijtu. ");
INSERT INTO zosNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero Pedro'is ja vya'ṉjam o'ca jetji'n nø vyijtu; sone pø'nis vyi'naṉdøjqui nømu: ―Ji'ṉ ø musi ti nø mi ndzamu. ");
INSERT INTO zosNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Y Pedro maṉ aṉdyuṉgø'mø y jeni eyapø coyomo'is isu y ñøjayaj jiṉdi te'ñaj vene: ―Yøṉ pøn también vit Jesusji'ṉ, jic Nazarejtombø pønji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Entonces Pedro'is jetseti mena'com chambøjcay Diosis ñøyi va'cøti ñømø: ―Ji'nø ngo'ispøc je pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Y usyaṉ horacøsi jen ityajupø'is tyo'møyaj Pedro y ñøjayaju: ―Viyuṉsye mitz jicji'ṉbøte, porque mismo jetseti mi ondeque't. ");
INSERT INTO zosNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Entonces Pedro yach onu y chambøjcacye't Diosis ñøyi, nømu: ―Ji'nø ngo'ispøc je pøn. Jicsye'c vej ṉgaylu. ");
INSERT INTO zosNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Y jyajmutzøjcu Pedro'is oyuse chajmay Jesusis; que Jesusis oy ñøjaye: “Antes que vejpa ṉgaylu, maṉba mi ñømi tu'cay nac que ji'n mi ndø ispøc ndøvø”. Entonces put Pedro a'ṉgomo y vo'tzocopajcu. ");
INSERT INTO zosNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Y sø'ṉbø'nømu'cam, mumu pane covi'najø'is y Israel pø'nomda'mbø tzambø'nis qui'pscøpo'yaju jujche va'cø yaj ca'yaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Y myo'csyaju jetse ñømaṉyaju va'cø chi'ocuyaj Poncio Pilatocøsi porque jic gobernadojrete. ");
INSERT INTO zosNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Y cuando myan Judasis, chi'ocuyajupø'is, que maṉba yaj ca'yaj Jesús, qui'psvitu'u, cyømaṉyaj pane covi'najø y tzambønda'm va'cø maṉ chacvitu'i treinta platapø tumin. ");
INSERT INTO zosNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ñøjayaju: ―Cojapa'tøjtzi porque ndzi'ocuyaj øjtzi ja cyojapa'tøpø pøn va'cø cya'ø. Pero je'is ñøjayaj Judas: ―Ni ti cuenta ji'n mba'jtam øjtzi ti mi ndzøjcu. Mitzcøspøti. ");
INSERT INTO zosNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Y Judasis pyatzcajpø'u tzajcu tumin jen masandøjcomo, tzu'ṉ jeni, maṉ jyø'mga' vyin. ");
INSERT INTO zosNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Y pi'ṉaṉdø'pyaj tumin pane covi'najø'is, y nømyaju: ―It ley va'cø jana ndø tumøcot yøṉ tumin masandøc tuminji'ṉ porque pø'nise ñø'pin goyoja. ");
INSERT INTO zosNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Por eso qui'pscøpoyaju va'cø jyujyayaj nas ñøyi'ajupø'is tzica tzøcpapø'is ñas; jiṉ va'cø ñipyaj emøc tzu'ṉbapø viti. ");
INSERT INTO zosNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jetcøtoya cyojtayaj ñøyi jeni Nø'pin Nas, y jetse ñøyi hasta yøti. ");
INSERT INTO zosNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Y jetse tujcu lo que chamuse tza'maṉvajcopyapø Jeremiasis cuando nømu: “Y pyøcyaj treinta platapø tumin, porque vyø'møyaj Israel pø'nis va'cø cyoyojyajø je'nche'ṉomo va'cø cya' je pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Y je tuminji'ṉ jyujyayaj tzica tzøcpapø'is ñas, porque jetse tzajma'yøjtzi ndø Comi'is”. ");
INSERT INTO zosNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Entonces Jesús te'nuna'ṉ gobernadojris vyi'naṉdøjqui. Y je'is 'yaṉgøva'cu: ―¿Mijtzømate Israel pø'nis aṉgui'mbata'm? Y Jesusis 'yaṉdzoṉu: ―Øjchøṉø nømdi mi ndzamuse. ");
INSERT INTO zosNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Y cuando pane covi'najø'is y tzambø'nis cyøtza'møyaju, Jesusis ja 'yaṉdzova, ni ti ja chamø. ");
INSERT INTO zosNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Entonces Pilato'is ñøjayu: ―¿Mi muspatija o'ca mi ṉgyøtza'møyajpa mumu ticøsi? ");
INSERT INTO zosNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jesús ni jujche ja 'yaṉdzo'ṉoya. Jetcøtoya ñømaya'comø'nu gobernadojris ticøtoya ja 'yaṉdzova. ");
INSERT INTO zosNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pero tumdum pascua sø'ṉomo syombø'pana'ṉ tum preso governadojris lo que jutipø syuñajpana'ṉ vøti pø'nis va'cø syombø'tøjø. ");
INSERT INTO zosNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jicsye'c ijtuna'ṉ tum pøn preso'omo ñøyipø'is Barrabás; aunque i'is cyomusu iyete. ");
INSERT INTO zosNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Y cuando jendina'ṉ ityaj tumø'omo, 'yocva'cyaj Pilato'is: ―¿Jutipø sunba mijtzi va' ø sombø'ø, Barrabás, o Jesús ñøjayajpapø Cristo? ");
INSERT INTO zosNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Porque Pilato'is chi' cuenta que chi'ocuyaju'is qui'sayaj Jesús porque más syuñaj Jesús sone pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Y mientras Pilato jendina'ṉ po'cs aṉgui'mgu'yomo, cyø'vejay ote ñe yomo'is, ñøjayu: “U mi ndzøjcay ni ti jic pøn ja itø'is cyøja, porque tzu'yi vøti toya'isøjtzi napasyi'omo porque jic pøn nambasyi'ø'yøjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero pane covi'najø'is y tzambø'nis ñøjayaj vøti pøn va'cø vya'cyajø va'cø syombø'tøj Barrabás y va'cø yaj ca'tøj Jesús. Y al fin vyø'møyaj vøti pø'nis jetse va'cø vya'cyajø. ");
INSERT INTO zosNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Y entonces gobernadojris ñøjayaj vøti pøn: ―Yøṉ metzcuy pøṉø, ¿jutipø sundamba mijtzi va'cø sombø'ø? Y nømyaju: ―Sombø' Barrabás. ");
INSERT INTO zosNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Y Pilato'is ñøjayaju: ―¿Y yøṉ Jesús, ñøjayajpapø Cristo, ti nøndzøcpa yøṉø? Y 'yaṉdzoṉyaj mumu ñøjayaju: ―¡Yac ma'møtyøj cruzcøsi! ");
INSERT INTO zosNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Y gobernadojris ñøjayaju: ―¿Pero tiyø coja chøjcu? Pero pønda'm más vejaṉgøtyaju, nømyaju: ―¡Yac ma'møtyøj cruzcøsi! ");
INSERT INTO zosNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Entonces chi' cuenta Pilato'is que ji'n mus yajayaj vøti pø'nis qui'psocuy, sino que más manba so'natejyaje. Por eso vya'c nø' va'cø ñømijnatyøjø, y cø'che'u vøti pø'nis vyi'naṉdøjqui como seña que ja it cyoja, y nømu: ―Ja it ø ṉgoja o'ca mi yaj ca'tamba yøṉ vøjpø pøn. Jen a'mdam mi ne'ṉgø ti mi ndzøctamba. ");
INSERT INTO zosNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","'Yandzoṉyaj vøti pøn y nømyaju: ―¡Øtz yaj castigatzøctøjø ø uneji'ṉducu o'ca jet yaj ca'pa! ");
INSERT INTO zosNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Entonces Pilato'is syombø'u Barrabás y yac nacstochøctøj Jesús. Y chi'ocuyaju va'cø mya'møyaj cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Entonces gobernadojris syoldado'is ñømaṉyaj Jesús aṉgui'mguy tøjcomo. Jen vyejtu'myaj mumu soldado y cyotyaj cujcomo Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ñe' tyucu yac tzacyaju, tzapas tucu yac mesyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pye'tyaj apit corona y yac mesyaj cyopajcomo y chø'naṉbø cyø'omo cyojtayaj cuy. Entonces cutquecyaju vyi'naṉdøjqui, cyøsijcøyaju va'cø qui'tzcu'ajyajø. Ñøjayajpana'ṉ: ―¡Viva Israel pø'nis 'yaṉgui'mba! ");
INSERT INTO zosNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Y cyøtzujøyajpana'ṉ, y pyøjcayaj cyø'ombø cuy y jetji'ṉ jyo'tznacsnacsvøyajpana'ṉ cyopajcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jetse qui'tzcu'ajyaj Jesús. Y después yac tzacyaj tzapas tucu y yac mesque't ñe'. Entonces ñømaṉyaju va'cø mya'møyaj cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cuando nømna'ṉ myaṉyaj cumgu'acapoya'omo, pya'tyaj Cirene gumgu'yombø pøn ñøyipø'is Simón. Jet pyena tzøcyaju va'cø ñømajṉay Jesusis cruz. ");
INSERT INTO zosNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Y nu'cyaj ñøjayajpamø Gólgota, que sunba ñømø: Cyo'cøpacmø. ");
INSERT INTO zosNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jeni chi'yaj Jesús vinagre mojtupø tzuchniviji'ṉ va'cø tyo'ṉa. Y tyo'ṉisu'cti, ja syun tyo'ṉa. ");
INSERT INTO zosNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Entonces soldado'is mya'møyaj Jesús cruzcøsi, y después cyøsijayaj tyucu va'cø vye'ñayaj ñe'comda'm. Jetse viyuṉaju tza'maṉvajcopyapø'is chamuse, nømu: “Vye'nbø'jayaj ø nducu ñe'comda'm, cyøsijayaj ø nducu”. ");
INSERT INTO zosNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Entonces jen aṉbocsyaju, va'cø cyoqueñajø. ");
INSERT INTO zosNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y mya'møyaj tabla cruzcøsi Jesusis cyopajcomo, tablacøsi it jachø'yupø ti cyoja. Yø'cse nømu: “Yøṉete Jesús, Israel pø'nis myøja'ṉ Aṉgui'mbata'm”. ");
INSERT INTO zosNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Entonces mya'møyajque't eyata'mbø cruzcøsi metcuy nu'mbapø; tum Jesusis chø'na'ṉomo, y tum 'yaṉña'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Y cøtyajpapø'is 'yo'nindze'myaju, cyopacti myi'cu'jayaju. ");
INSERT INTO zosNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nømyaju: ―O'ca muspa mi ⁿju'mbø masandøc y tu'cay jamacøsi muspa mi ndzøcvøjøtzøcø, y mi ⁿvin ji'n mus mi ⁿyaj cotzoca. O'ca mijtzete Diosis mi 'Yune, entonces mø'n cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jetseti 'yonguitzcu'ayajque'tu pane covi'najø'is y aṉgui'mguji'n aṉma'yoyajpapø'is y fariseo'ista'm y tzambø'nista'm. Nømyajpana'ṉ: ");
INSERT INTO zosNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Eyapø yaj cotzocyaju, y vyin ji'n mus yaj cotzoca. O'ca jicø ndø Aṉgui'mbata'm tø øtz Israel pønda'm chøṉø, ¿ti'ajcuy ji'ṉ myø'n cruzcøsi yøti? O'ca mø'nbana'ṉ cruzcøsi, ndø va'ṉjamdambana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nømu que Diosis 'yayudatzøcpa, pero o'ca de veras syunbapøte Diosis, ¿ticøtoya ji'n mini va'cø yaj cotzoca? Porque nømu: “Øtz Diosis chø 'Yune”. ");
INSERT INTO zosNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jetseti 'yongui'tzcuyajyaj Jesús nu'myajpapø'is jetji'ṉ ityajupø ma'møyajtøj cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Entonces paṉguc jamase'ṉomo pi'tzø'ajnømu mumu nasindumø y hasta las tres de la tarde min sø'ṉbø'nøṉgue'te. ");
INSERT INTO zosNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Y como a las tres de la tarde pømi vej Jesús, nømu: ―Elí, Elí, ¿lama sabactani? ―ndø onde'omo va'cø tø nømø, tø nømba: Øjtzø mi Dios, øjtzø mi Dios, ¿ticøtoya mi ndø patzpø'utzajcu? ");
INSERT INTO zosNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Y vene'aṉbø'nis jiṉø te'ñajupø'is myañaju ti cham Jesusis y nømyaju: ―Yø'ṉis nø vyejay Elías. ");
INSERT INTO zosNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jicsye'c pochu'ṉ tumbøn maṉ mye'tz tzoja, ñuṉu vinagre'omo y cyot cape'omo y tyajøjayu capeji'ṉ Jesusis 'yaṉnaca'omo va'cø cyømu'cø. ");
INSERT INTO zosNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero eyapø nømyaju: ―Tzacø; ma ndø a'mda'i o'ca minba Elías va'cø yaj cotzoc jej pøn. ");
INSERT INTO zosNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pero Jesús pømi vejvøjøtzøjcu y yac maṉ 'yespiritu, ca'u. ");
INSERT INTO zosNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Y jicsye'c masandøjcombø tucu vo'te cucpo'tujcu; møji po'tzu'ṉ, hasta nascøsi po'nu'cu. Y mics nas hasta veñaj tza'. ");
INSERT INTO zosNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Y aṉvacyaj tzatøc nijpoñømumø y visayaj vøti va'ṉjajmoyajpapø pø'nis cyoṉna oyupøm ca'yaje. ");
INSERT INTO zosNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Y después que Jesús visa'u, putyaj chatøjcomo y tøjcøyaj masanbø Jerusalén gumgu'yomo, y vøti pø'nis isyaju je ca'yajupø lo que oyu visa'yaje. ");
INSERT INTO zosNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pero cuando ca' Jesús, capita'nis y jetji'ṉna'ṉ nø cyoqueñaju'is, cuando aṉjamyaj nasamicscø y isyaj tiyø tujcu, entonces ca'yajpana'ṉ na'tze'is, nømyaju: ―Viyuṉse yøn pøn Diosise 'yune. ");
INSERT INTO zosNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Y jendina'ṉ ityaj sone yomo ya'itina'ṉ cyøque'nøyajupø'is. Yø'ṉis oyuna'ṉ pya'tyaj Jesús desde que tzu'ṉu Galilea nasomo y o cyotzoṉyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Y je'tom ityajuna'ṉ María Magdalena, y Jacobo'is y José'is myama ñøyipø'sque't María, y jendina'ṉ itque't Zebedeo'is 'yune'is myamata'm. ");
INSERT INTO zosNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Y después min tza'i'cam tum ricupø pøṉ, Arimatea cumgu'yombøna'ṉete; ñøyipø'is José; y mismo Jesusis ñøtuṉdøvøque't. ");
INSERT INTO zosNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Je'is cyønu'c Pilato y vya'cay Jesusis cyoṉna. Entonces Pilato'is chi' aṉgui'mguy va'cø vya'ctzi'ayaj cyoṉña. ");
INSERT INTO zosNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Y Jose'is maṉ pyøc je cyoṉna y myojnayu popo sabana'omo. ");
INSERT INTO zosNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Y cyot ñe jomepø chatøjcomo; tza'cotzøc yac ocnojtøju, cuando ca'pa va'cø jen niptøjø. Pero jen o cyojtatyøj Jesusis cyoṉna. Y entonces piti'aṉga'm je chatøc møjapø tza'ji'ṉ y maṉyaju. ");
INSERT INTO zosNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Y jena'ṉ po'csyaj María Magdalena y eyapø María; jen 'yaṉbocsyaj tzatøc metzcupø yomo'is. ");
INSERT INTO zosNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Entonces jyo'pit cøjtu'cam jama cyomeque'ajyaju'c sapøjcuy jamacøtoya, tu'myaj pane covi'najø y fariseo va'cø maṉ 'yo'nøyaj Pilato. ");
INSERT INTO zosNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Y ñøjayaju: ―Señor, jamda'mbøjtzi jujche chamuse je aṉgøma'copya Jesusis cuando quenba'ctøc, nømu: “Tu'cay jamacøsi ma'ṉbø visa'e”. ");
INSERT INTO zosNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Por eso jetcøtoya tzi' aṉgui'mguy va'cø cyoquendøj tzatøc niptøjumø hasta que ta'nba tu'cay jama, jana maṉ ñu'mnøputyaj tzu'cøsi ñøtuṉdøvø'is. Y jøsi'cam maṉba nømyaje: “Visa'u'am ca'upø”. O'ca jetse aṉgøma'cø'oyajpana'ṉ, más peor jetsena'ṉ tø tucpa que vi'nase. ");
INSERT INTO zosNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Y pilato'is ñøjayaju: ―Jen ityaj soldado va'cø mi nømaṉdamø va'cø cyoqueñajø. Jetse aseguratzøctamø mi muspa'csye'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Entonces maṉyaju y 'yaṉga'myaj mø'chøqui tzatøc. Syello'øyaj tza' aṉga'mupøji'ṉ y jen chacyaj maṉba'is cyoqueñaje. ");
INSERT INTO zosNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Entonces cøjtu'cam sa'pøjcuy jama, cuando maṉba'cam sø'ṉbønømi semana tzo'tzcuy jama, maṉ 'ya'myaj tzatøc María Magdalena'is y eyapø Maríaji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Y joviti mics nas porque mø'n ndø Comi'is 'yaṉgeles tzajpom tzu'ṉupø, y tzatøjcombø tza' piticajpø'jayu aṉgelesis y jet cøpo'csøyu. ");
INSERT INTO zosNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rayu'is ñe'mase, jetse pømi sø'ṉ aṉgeles; y tzojasena'ṉ popo tyucu. ");
INSERT INTO zosNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Y søtøtyaju nø cyoqueñajupø'is ña'tze'is, y como ca'yajuse tzø'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Y aṉgelesis ñøjayaj yomo: ―Uy ña'tztame; porque muspøjtzi que nø mi me'tztam Jesús, yaj ca'tøjupø cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pero ja itam yø'qui, visa'u'am como chamuse. Mindamø mi a'mdamø jut cojtøju ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Maṉdam yøti yøti ma tzajmatyam ñøtuṉdøvø que visa'u'am ca'upø. Y je'is maṉba mi vyi'najandyame Galilea nasomo, jiṉ maṉba mi mba'jtame. Jetse nø mi ndzajmatyamu. ");
INSERT INTO zosNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Entonces popya tzu'ṉyaj tzatøcmø na'tznepya pero casøcomø'ñaju. Poyuc maṉyaju va'cø maṉ chajmayaj ñøtuṉdøvø. ");
INSERT INTO zosNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mientras nømna'ṉ myaṉyaju va'cø chajmayaj ñøtuṉdøvø, joviti choṉyaj ñec Jesusis; y ñøjayaju: ―¿ⁿVyøjta'mdija? Y yomo'is cyujnejayaju, jyotzpøjcayaj cyoso. ");
INSERT INTO zosNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Y Jesusis ñøjayaju: ―Uy ña'tztame. Ma tzajmayaj ø ndøvø va' myaṉyaj Galilea nasomo. Jeṉ ma'ṉbø isyaje. ");
INSERT INTO zosNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pero mientras nømna'ṉ myaṉyaj yomo, maṉyajque't Jerusalén gumgu'yomo metzcuy tu'cay ma's cyoqueñaj tzatøc, maṉ chajmayaj pane covi'najø mumu ti tyujcuse. ");
INSERT INTO zosNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Entonces tu'myaj pane covi'najø tzambønji'ṉda'm y jen qui'pscøpoyaju jujche vøj chøcyajø. Y chi'yaj soldado vøti tumin va'cø syuchajø. ");
INSERT INTO zosNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Y ñøjayaju: ―Yø'cse nømdamø: “Mindamu je'is ñøtuṉdøvø tzu'cøsi y nu'mnømaṉyaj cyoṉña, øṉdamu'cse'ṉomdi'tzi”. ");
INSERT INTO zosNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jetse nømdamø, y o'ca de repente myuspa gobernadojris, ma'ṉbø ndzambasenchaqueque va'ca jana mi ṉgyastigatzøctamø. ");
INSERT INTO zosNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Y jetse soldado'is pyøjcøchoṉyaj tumin; y como chajmayuse, jetse chøcyaju. Nømyaju que ñøtundøvø'is ñu'mnømaṉyaj cyoṉña. Y jetsepø tzame tzamdøjpa Israel pø'nomo hasta como yøtise. ");
INSERT INTO zosNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Y entonces como chajmayajuse Jesusis, jetse ñøtuṉdøvø maṉyaj Galilea nasomo tum cotzøjcøsi. Porque chajmayaju Jesusis que jiṉ maṉba na ñøjo'cyajtøji. ");
INSERT INTO zosNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Y cuando isyaj Jesús; cyujnejayaju; pero veneta'mbø metzaṉdzoco'yajyaju. Vya'ṉjamyajto'pa, jana vya'ṉjamyajto'a. ");
INSERT INTO zosNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Entonces Jesusis cyønu'cyaju y ñøjmayaju: ―Mumu aṉgui'mguy tzi'tøj øjtzi tzajpomo y aunque jutpø cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jetcøtoya maṉdamø, tzajmatyam aunque jutzpø pøn aunque jutpø cumgu'yomo va'cø 'yaṉmayaj øjtzøcø'mø. Yac nø'yøtyamø ndø Janda'is ñøyicøsi, y øjchøṉ 'Yune, ø nøyiṉgøsi: y Masanbø Espiritu Santo'is ñøyi'cøsi. ");
INSERT INTO zosNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Y tzajmatyamø va'cø cyo'aṉjamyajø mumu øtz mi aṉgui'mdambase. Y mustamø que øtz itpa mitzji'ṉdam mumu jama hasta que yajnømba. Øtz ji'nø mi ndzac nunca. Amén.");
INSERT INTO zosNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ma'ṉbø ndzam vøjpø ote. Ma'ṉbø ndzam jujche yoscho'tzuse Jesucristo. Jetete Diosis 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ijtu jachø'yupø tza'maṉvajcopyapø Isaiasis libru'omo; jen chamba que Diosis ñøjay 'Yune: Otz ṉgø'vejpøjtzi nu'cscuy ñøminbapø'is ote antes que mi minba mijtzi. Como si fuera mi nduṉ nø vyøjøtzøjcuse, je'is maṉba chajmayaj pøn va'cø ityaj jajmecøs va'cø mi mbyøjcøchoṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nø vyejnøm tza'momo ni i ja ityømø, nømba: “Como ndø vøjø tzøjcatyambase tuṉ cuando maṉba min møja'ṉ aṉqui'mbapø, jetseti vøjø tzøctaṉgue't mi ndzocoy porque maṉba min ndø Comi”. ");
INSERT INTO zosNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Como jaychø'yuse, jetse min Juan. Jiṉ nø'yø'yoyu ni i ja ityømø. Chajmayaju pøn va'cø ñø'yø'yajø, y va'cø qui'psvitu'yajø, va'cø yaj cøtocojayaj cyoja Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tzu'ṉyaju mumu Judea nasomda'mbø y Jerusalén gumgu'yomda'mbø, nu'cyaju ijtumø Juan. Cuando chamyaj cyoja, Jua'nis ñø'yøyaj Jordán nø'omo. ");
INSERT INTO zosNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jua'nis myes tyucu camello copøn bøcpø y chec vatcuy nacapø; cyø'spana'ṉ aju, y cyu'tpana'ṉ tzinu. ");
INSERT INTO zosNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jua'nis chajmayaj pønda'm ñøjmayaju: ―Jøsi'cam maṉba min eyapø pøn más pømi'øyupø que ji'n øjtzi. Ji'n musi utzquecø va'cø mbucspøjay syapato'is chay; porque va'cø chøc jetsepø nu'csocuy jicø møja'ṉombø pøṉgøtoya, syunba más vøjpø pøn que ji'n øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Øtz nø mi nø'yøndyam nø'ji'ṉ, pero maṉbapø mini, je'is maṉba mi ñø'yøndyam Masanbø Espiritu Santoji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jic jama'omo Jesús tzu'ṉu Nazaret cumgu'yomo. Nazaret cumguy Galilea nasis cyo'aṉjajmba. Jesús nu'c ijtumø Juan. Jua'nis ñø'yøy Jesús ijtumø nø' ñøyipø'is Jordán. ");
INSERT INTO zosNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cuando nømna'ṉ pyut Jesús nø'cø'mø; is tzap aṉvajcupø. Y is Espiritu Santo nø myø'nupø como tum palomase quenbapø y jetcøs nu'cu. ");
INSERT INTO zosNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y myan ote tzajpombø nø ñømupø: ―Mijtzi øjtze mi ⁿUne sunbapø chøṉø; mitzcøtoya casøpyøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jøsi'cam Espiritu Santo'is ñømaṉ Jesús jya'itnømømø. ");
INSERT INTO zosNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Y jiṉ it cuarenta jama, y Satanasis oy 'yaṉgømacø'is Jesús. Y Jesús oy it tza'ma copønji'ṉ y aṉjelesis cyotzonyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jøsi'cam cojtøj Juan preso'omo, y entonces minu Jesús Galilea nasomo. Jesusis maṉ chajmayaj vøjpø ote, maṉ chajmayaje jujche aṉgui'mbase Dios. ");
INSERT INTO zosNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nøm Jesús: ―Nu'cu'am hora. Ya mero maṉba istøji aṉgui'mbase Dios. Qui'psvitu'tamø y va'ṉjamdamø vøjpø ote. ");
INSERT INTO zosNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús nømna'ṉ vyit Galilea laguna acapoya cuando isyaju Simón tyøvø Andresji'ṉ. Nømna'ṉ cyoque nucyaju, porque jeteme yoscuy. ");
INSERT INTO zosNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesusis ñøjayaju: ―Ma tø pa'jtamø. Yøti ji'n ma mi nuctam coque, sino pøn maṉba mi yac mindam øtzcømø. Porque øtz jetse maṉba mi ⁿyac yostame. ");
INSERT INTO zosNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Y pronto chacyaj 'yataraya y maṉ pya'tyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Usya'ṉomdøc vijtu'øc Jesús, pya'tyajque't metzcuy Zebedeo'is 'yune, tum ñøyipø'is Jacobo, tum ñøyipø'is Juan. Barco'omna'ṉ ityaju nømna'ṉ pya'jna'cyaju 'yataraya. ");
INSERT INTO zosNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jicsye'cti Jesusis vyejayaj Jacobo y Juan. Jacobo'is y Jua'nis chacyaju jyata Zebedéo, y maṉ pya'tyaj Jesús. Barco'omo tzø'yaj jyata coyosyajpapøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Y nu'cyaj Capernaum gumgu'yomo y pronto sapøjcuy jama'omo tøjcøy Jesús cyonocsyajpamø y aṉma'yocho'tzu. ");
INSERT INTO zosNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tu'myajupø pø'nis ñømaya'jayaju 'yaṉma'yocuy porque aṉma'yopyana'ṉ como que ñø'ijtuse aṉgui'mguy, y ji'ndyet como ñe'c aṉma'yoyajpase. ");
INSERT INTO zosNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Cyonocsyajpamø ijtuna'ṉ tum pøn ñø'ijtupø yatzipø espiritu'is. Je pøn veju y ñøjayu Jesús: ");
INSERT INTO zosNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Tø tzactam ndøvø. ¿Tiyø cuenta mi ndø pa'jtamba? Mijtzete Jesús Nazaret cumgupyøn. ¿Min mi ndø yajtame? Øtz mi ispøcpøjtzi que mijtzete Diosis Masanbø mi Mbyøn. ");
INSERT INTO zosNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Y Jesusis 'yojnay yatzi'ajcuy y ñøjayu: ―¡Vøṉbø'ø; tzac je pøn! ");
INSERT INTO zosNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yatzi'ajcu'is yac pitivit pøn y vej pømi, y put pø'nomo. ");
INSERT INTO zosNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Y mumu pøn maya'yaju y por eso ña ñø'aṉgøva'cyajtøju ñe'comda'm nømyaju: ―¿Tiyøṉ yøṉø? ¿Tiyø aṉma'yocuy jomepø? ¡Yø'ṉis it 'yangui'mguy va'cø 'yaṉgui'myaj yatzi'ajcuy, y cyøma'nøjayajpa 'yaṉgui'mocuy! ");
INSERT INTO zosNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y pronto mumu ijnømuse Galilea nasomo tzamdøju lo que ti chøjcu Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jicsye'c putyaju jut cyonocsyajpamø, y tøjcøyaj Jesús Simón y Andresis tyøjcomda'm; y Jacobo y Juan tøjcøyajque'tu. ");
INSERT INTO zosNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pero Simo'nis myo'ot mama øṉuna'ṉ, nømna'ṉ ñutzø'øyu. Jicsye'cti chajmayaju Jesús que ca'epøte. ");
INSERT INTO zosNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Y Jesusis cyømaṉ tome, ñujcay cyø', y yac te'nchu'ṉu. Jicsye'cti chac nutzø'is, y ca'epøna'ṉ tzu'ṉu maṉ chøctzo'tz yoscuy. ");
INSERT INTO zosNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tza'i'cam cuando tø'pu'jcam jama, nu'caṉdøpneyaju mumu ca'eta'mbø, y mumu nøc ijtøyajupø yatzi'ajcu'is. ");
INSERT INTO zosNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Y mumu cumgu'yomda'mbø tu'myaju aṉdyuṉgø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Y Jesusis yac tzocyaju sone co'ma ñø'ityajupø'is ca'cuy; y sone pø'nomo lo que yatzipø espiritu'is yac toya'isyajupø, Jesusis yac putyaj yatzi'ajcuy. Yatzi'ajcuy ni ti ja yac tzamyaj Jesusis, porque yatzi'ajcu'is ispøcyaju Jesús que jiquete Diosis cyø'vejupø va'cø 'yaṉgui'mø. ");
INSERT INTO zosNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jyo'pit namdzu' pi'tzøtøcna'ṉ sa' Jesús y tzu'ṉu y maṉu jya'ijnømømø, maṉ 'yo'nøy Dios. ");
INSERT INTO zosNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Entonces Simón tzu'ṉyaj ñøtuṉdøvøji'ṉ maṉ mye'chaj Jesús jut maṉu. ");
INSERT INTO zosNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cuando pya'tyaju, ñøjayaju: ―Mumu pø'nis nø mi mye'chaju. ");
INSERT INTO zosNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Y Jesusis ñøjayaju: ―Tø maṉdya'i eyapø tometa'mbø cumgu'yomo. Mati ndza'maṉvajque'ta jinø, porque jetcøtoya tzu'ṉøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesús vijtu cumguñamaye Galilea nasomo y tza'maṉvajcoyu tu'mnømbamø. Y yac tzu'ṉyaj pø'nomda'm yatzita'mbø espiritu. ");
INSERT INTO zosNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jesús tyo'møy yachputzi'øyupø'is, cutcøne'c Jesusis cyosocø'mø y ñøjayu: ―Mitz it mi musocuy va'cø mi ndø yac tzoca, o'ca sunba mi ndø yac tzoca. ");
INSERT INTO zosNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Y Jesusis tyoya'ṉøyu y pi'quisay cyø'ji'ṉ y ñøjayu: ―Øtz su'nbøjtzi va'cø mi ñchoca. Yøti mi ⁿyac tzocpøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cuando jetse ñøjayu, jicsye'cti chac ca'cu'is. ");
INSERT INTO zosNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Entonces Jesusis 'yo'nøyutzajcu, sone co'ma chajmayu y ñøjayu: ");
INSERT INTO zosNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ni i u mi ndzajmayu, pero mavø panecø'mø y isindzi' mi ⁿvin que mi ñchojcu'am, y tzi' pane tzi'ocuy como jujche aṉgui'muse Moisés va'cø mi ndzi'ø cuando mi nchojcu'am. Jetse maṉba myusyaje que mitz ñchojcu'am. ");
INSERT INTO zosNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero pø'nis maṉ chamdzo'tzayaje aunque iyø jujche oy tzoque. Jetcøtoya Jesús ja musam tyøjcøy ni jutipø cumgu'yomo porque ji'na'ṉ syuni va'cø istøjø, pero oy vit ja ijnømømø. Minbana'ṉ 'ya'myaj Jesús aunque jujta'mbø'is. ");
INSERT INTO zosNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cøjtu'jcam metza tu'cay jama, Jesús tøjcøcye'tu Capernaum gumgu'yomo, y tzamdøju que jen it tøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jicsye'cti tu'myaju sone pøn hasta que tas tøc y ja mus tøjcøyaj más, y aṉdyuṉgø'mø umneyajque'tu. Y Jesusis cha'maṉvac vøjpø ote. ");
INSERT INTO zosNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Y ñømiñaju pøn ji'n musipø vitø porque ca'epøna'ṉete. Macsyaṉbønbø'is cyapnønu'cyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero como vøtina'ṉ ityaj pøn, ja mus ñønu'cyajø mero ijtumø Jesús. Entonces 'yaṉvacyaju møji tøjcøcopac ijtumø Jesús. 'Yaṉvacyaju'cam, jyø'mø'ñaju ca'epø 'yøṉguji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Cuando Jesusis is jujche nø vya'ṉjamyaju, ñøjayu ca'epø: ―Øjchø mi une, mi nchø'pya cøvajcupø mi ṉgojaji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ijtyajuna'ṉ jiṉø aṉma'yoyajpapø aṉgui'mguji'ṉ y je'is ñu'mgui'psyaj choco'yomo: ");
INSERT INTO zosNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ticøtoya jacsque't je pøn jetse nø ñømu? ¿Ti'ajcuy chamba pø'nis vyin como Dios siendo ji'ndyet jicø? Ni i's ji'n mus yaj cøtocojay coja sino que único Diosis myuspa”. ");
INSERT INTO zosNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero Jesusis ñe'c nømdi myusu lo que ti nø qui'psyajupø, y ñøjayaju: ―¿Ti'ajcuy jetse mi nu'mgui'pstamba mi ndzoco'yomda'm? ");
INSERT INTO zosNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿A ver ti más omba nømø; o va'cø ndø nøjay ca'epø: “Mi nchø'pya cøvajcupø mi ṉgojaji'ṉ”, o va'cø ndø nøjayø: “Te'nchu'ṉø, pøc mi øṉguy, y ca'ṉbø'ø”? ");
INSERT INTO zosNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero maṉba mi yac istam que øtz mumu Pø'nis chøṉ Tyøvø, que øtz it ø aṉgui'mguy va'cø ⁿyaj cøtocojay aunque jutipø'is cyoja nascøsi. Entonces Jesusis ñøjayu ca'epø: ");
INSERT INTO zosNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Øtz mi nøja'mbyøjtzi: Te'nchu'ṉø, pøc mi øṉguy y maṉ mi ndøcmø. ");
INSERT INTO zosNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jicsye'cti te'nchu'ṉu, piṉgøtøjcøy 'yøṉguy y tzu'ṉu, maṉu; aunque i'is isu. Cuando isyaj jic tzojcu, maya'tzo'chaju y vyøcotzøcyaju Dios. Nømyaju: ―Nunca ja ndø istam yøcse chøcpapø'is. ");
INSERT INTO zosNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jøsi'cam maṉque't Jesús majraṉvini y mumu pøn miñaj jetcø'mø. Y Jesusis 'yaṉmayaju. ");
INSERT INTO zosNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Entonces Jesús nømna'ṉ cyøjtu y is pøn ñøyipø'is Leví, Alfeo'is 'yune. Jena'ṉ po'csu cobratzøjcoñømbamø. Y Jesusis ñøjayu: ―Mi tø nøtu'ṉajø. Leví te'nchu'ṉu, maṉ pya'te. ");
INSERT INTO zosNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tujcu que Jesús po'csuna'ṉ Levi'is tyøjcomo y nømna'ṉ vyi'cu. Ityajque'tuti vøti cobratzøjcoyajpapø y eyapø cojapønda'm po'csyajupø tumø'omo mesacø'mø Jesusji'ṉ y ñøtuṉdøvøji'ṉ. Porque sone ityaj cojapønda'm maṉba'is pya'tyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Y aṉmasyajyajpapø'is aṉgui'mguy y fariseo 'yaṉma'yocuy ñø'ityajupø'is isyaju que Jesús nø vyi'c cobratzøjcoyajpapøji'ṉ y cojapønji'ṉda'm. Entonces je'tis ñøjayaju Jesusis ñøtuṉdøvø: ―¿Jutzpøṉ yøṉø que mi Maestrota'm cu'tu'myajpa y uctu'myajpa cobratzøjcoyajpapøji'ṉ y eyata'mbø cojapønji'ṉ? ");
INSERT INTO zosNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cuando Jesusis myanu ti nø chamyajupø, ñøjayaju: ―Sa'sata'mbø'is ji'n syuñaj doctor, sino que ca'eta'mbø'is syuñajpa. Jetsetique't ni ja mi'nøjtzi va'cø ⁿvejayajø ja ityajøpø'is cyoja, sino que mi'nøjtzi va'cø ⁿvejayajø cojapøndzøquita'm. (Jujche doctojris yac tzu'ṉapya cya'cuy, jetse øtz yac tzu'ṉapya cyoja). ");
INSERT INTO zosNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jua'nis ñøtuṉdøvø y fariseo'is ñe'ta'm ijtum jyama que ji'n cyu'tyajemø vya'ṉjajmocucyøtoyata'm. Y miñaju pøn va'cø 'yaṉgøva'cyaj Jesús ñøjayaju: ―¿Ti'ajcuy Jua'nis 'yaṉmayajpapø y fariseo'is 'yaṉmayajpapø ijtum jyama que ji'n cyu'tyajemø, y mi ne'nda'm ja ityajø jetsepø costumbre? ");
INSERT INTO zosNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Y Jesusis ñøjmayaju: ―Seguro que vejayajtøjupø co'tøjcajcu'yomo ji'n ma ityaj jeni jana cu'tipø mientras pøn mapø co'tøjcaje ñe'cji'ṉ ijtu. ");
INSERT INTO zosNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero maṉba nu'c jyama cuando pøn mapø co'tøjcaje maṉba yac tzu'ṉatyøji, y jicsye'c ji'n ma cu'tyaj vejyajtøjupø. Maṉba tzø'yaj triste. Jetsetique't mientras øtz ijtøjtzi ø nønduṉdøvøji'ṉ, ji'n mus ityajø jana cu'tipø; pero cuando øtz yac tzu'ṉdøjpøjtzi, jicsye'c maṉba ityaj jana cu'ti. ");
INSERT INTO zosNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jetsetique't chamque't que ji'n mus ndø pa'jna'c pecapø tucu jomepø tucucøtzijtzaṉji'ṉ. Porque cuando i'tzpa jomepø tucu, tzitzque'tpati y más yajpa. ");
INSERT INTO zosNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","También ji'n mus ndø cojtay merotøc nø pyujtupø uva'is ñø' pecapø nacapø cojtocu'yomo. O'ca jetse ndø tzøcpa, cuando fermentatzøcpa uva'is ñø', yac taspa y tzitzpa naca, y parejo tocopya uva'is ñø' cojtocuji'ṉ. Sino jomepø nacapø cojtocu'yomo ndø cojtapya nømdøc pyujtupø uva'is ñø'. (Jetsetique't pecapøji'ṉ ji'n mus ndø mot jomepø aṉma'yocuy.) ");
INSERT INTO zosNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tum sapøjcuy jama'omo nømna'ṉ cyøtyaj trigo cama'omo. Mientras nømna'ṉ tyu'ṉajyaju'øc, ñøtuṉdøvø'is quitpøjcayaj trigo'is tyøm. ");
INSERT INTO zosNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseo'is ñøjmayaj Jesús: ―A'mø, ¿ti'ajcuy nø yosyaj mi nønduṉdøvø? Porque it aṉgui'mguy jana ndø tzøc jetse sapøjcuy jama'omo. ");
INSERT INTO zosNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Y Jesusis ñøjayaju: ―¿Será que nuncatøc ja mi ndu'ndamø jujche chøjcuse Davijdis? ");
INSERT INTO zosNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Cuando ijtuna'ṉ pane covi'najø nøyipø'is Abiatar, tøjcøy David Diosis tyøjcomo cuando ja ityøna'ṉ cyu'tcuy y nømna'ṉ 'yosyaj ñe'cø y ñøtuṉdøvøta'm. Ijtuna'ṉ pan cyømasa'nøyupø y chajcupø masandøjcomo. Davijtis cyø's je pan y chi'yajque'tuti ñe'cji'ṉ ityajupø. Pero namas pane'sna'ṉ muspa cyø's jetsepø pan. ");
INSERT INTO zosNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y Jesusis ñøjayajque'tu: ―Diosis cyot sapøjcuy jama va'cø más vøj ityaj pøn. Ja cyot pøn namas va'cø it i'is cyo'aṉjamba jama. ");
INSERT INTO zosNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Øtz Pø'nista'm chøṉ Tyøvø aṉgui'mbøjtzi ti va'cø ndø tzøcø sapøjcuy jama'omo. ");
INSERT INTO zosNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Entonces Jesús tøjcøcye't conocscuy tøjcomo. Jena'ṉ it pøn tøjtzupø'is cyø'. ");
INSERT INTO zosNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","'Yenemigo'is cyø'isøyajpana'ṉ Jesús a ver o'ca yac tzocpana'ṉ sapøjcuy jama'omo. O'ca ispa yac tzojcu, maṉbana'ṉ cyøtza'møyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Y Jesusis ñøjayu tøjtzupø'is cyø': ―Te'nchu'nø y te'n yø'c cujcomo. ");
INSERT INTO zosNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Y Jesusis 'yaṉgøva'cyaju 'yenemigo ñøjayaju: ―¿Ti vøj ndø tzøc sapøjcuy jama'omo? ¿O vøja va'cø ndø tzøc vøjpø tiyø, o vøja va'cø ndø tzøc ji'n vyøjpø tiyø? ¿O vøja va'cø ndø yaj cotzoca ndø tøvø, o vøja va'cø ndø yaj ca'ø? Pero 'yenemigo vøṉgøpiti tzø'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesusis 'ya'myaj corajepit, maya'u porque ji'na'ṉ sun cyønøctøyøyajø. Entonces Jesusis ñøjayu ca'epø: ―Yø'cte'n mi ṉgø'. Y yø'ctonde'n cyø', tzojcupø tzø'yu como eyapø cyø'se. ");
INSERT INTO zosNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jicsye'c fariseota'm putyaju y tu'myaju Herodesis tyu'mbac tøvøji'nda'm. Qui'pscøpoyaju a ver jujche muspa yaj ca'yaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Y Jesús tzu'nyaj ñøtuṉdøvøji'ṉ maṉyaj majraṉvini, y maṉ pya'tyaj vøti pø'nis Galilea nasomda'mbø'is y Judea nasomda'mbø'is. ");
INSERT INTO zosNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Cuando myañaju ti chøc Jesusis, miñaju vøti pøn tzu'ṉyajupø Jerusalén cumgu'yomo y Idumea nasomo y Jordán nø'aṉvini, y ityajupø tome Tiro cumgu'yomo y Sidón cumgu'yomo. Maṉ cyø'isøyaj Jesús sone pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Y Jesusis ñøjayaj ñøtuṉdøvø va'cø ityaj listo che'pø barco. O'ca tyonga'myajpa Jesús vøti pø'nis, muspana'ṉ tøjcøy Jesús barco'omo y pøn va'cø chø'yaj nø'anvini; jetse va'cø jyana tyonga'myajø Jesús. Y Jesús muspa pyo'cs barco'omo y aṉmayaj sone pøn nascøs ityajupø. ");
INSERT INTO zosNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Porque Jesusis yac tzoc sone pøn y mumu ca'eta'mbø'is myejca'mga'mvøyajpana'ṉ tyøvø va'cø nu'cyajø tome Jesuscø'mø va'cø mus pi'quisyajø Jesús ca'epø'is, a ver o'ca tzocyajpa. ");
INSERT INTO zosNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cuando yatzipø espiritu'is isyaj Jesús, cujneyaju Jesuscø'mø y vejyaju, ñøjmayaju: ―¡Mijtzømete Diosis 'Yune! ");
INSERT INTO zosNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Y Jesusis 'yøjnayaju 'yaṉgui'myaj yatzipø espiritu va'cø jana chamyajø que Diosise 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jicsye'c Jesús qui'm lomacøsi y vyejayaju lo que ñe'c sunu cyøpiṉyajø, y nu'cyaju jetcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Y Jesusis cyøpiṉyaj macvøstøjcay pøn va'cø ityajø ñe'cji'ṉ. Y jicta'm maṉba cyø'vejyaje va'cø maṉ cha'maṉvajcoyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jesusis chi'yaj jic pøn aṉgui'mguy va'cø yac tzocyaj ca'eta'mbø y va'cø mus yac tzacyajø pøn yatzipø espiritu. ");
INSERT INTO zosNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yøṉda'mete macvøstøjcay Jesusis cyøpinyajupø: tum ñøyipø'is Simón, y Jesusis yac nøyi'ajque't Pedro. ");
INSERT INTO zosNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Cyøpiṉyajque't metzcuy Zebedeo'is 'yune: tum ñøyipø'is Juan y tum Jacobo. Jacobo y Juan Jesusis yac nøyi'ajque't Boanerges, lo que ndø nøjandyambapøte ndø onde'omo: rayo a'ṉøcuy. ");
INSERT INTO zosNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Jesusis cyøpiṉyajque'tu Andrés, y Felipe, y Bartolomé, y Mateo, y Tomás, Alfeo'is 'yune Jacobo, Tadeo, y Simón cananista'is ñøtuṉdøvøta'm; ");
INSERT INTO zosNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y cyøpiṉque'tu Judas Iscariote. Yøṉ Judas chi'ocu'yajupø'is Jesús 'yenemigo'is cyø'om. Jøsi'cam Jesús tøjcøyaj tøjcomo ñøtuṉdøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Y cyøtu'myajque'tuti vøti pø'nis. Jesús y ñøtuṉdøvø ji'na'ṉ mus vyi'cyajø porque sone pøn itco'nu aṉcø. ");
INSERT INTO zosNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesusis tyøvø'is myañaju jujche nø tyujcuse y minyaju va'cø ñømaṉyaj Jesús emøc. Nømyajpana'ṉ que jyovi'ajuna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Y aṉma'yoyajpapø aṉgui'mguji'ṉ tzu'ṉyajupø Jerusalén gumgu'yomo nømyaju que covi'najøpø yatzi'ajcuy ñøyipø'is Beelzebú, je'is nø cyotzoṉu Jesús. Satanás nøjmayajque'patina'ṉ Beelzebú. Nømyaju que Jesusis ñu'csayu Beelzebu'is pyømi va'cø yac tzu'ṉyaj eyata'mbø yatzi'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesusis vyejayaju y chamu historia va'cø cha'maṉvacø; ñøjayaju: ―¿Jutznøm maṉba ñøput Satanasis mismo ñe'c vyin? ");
INSERT INTO zosNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","O'ca tumbø cumgupyøn quipyajpa ne'como, tocopya itcuy. ");
INSERT INTO zosNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y o'ca tumbø tøjcomda'mbø quipyajpa ñe'como, tococye'tpati itcutya'm. ");
INSERT INTO zosNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y oca Satanásis ñøquipyajpana'ṉ ñu'cscuy, ji'na'ṉ mus it'i'na, yajpana'ṉ 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","”O'ca ijtu pømi'øyupø pøn tøjcomo, ni i'is ji'n mus pyøjcay lo que ñø'ijtu tyøjcomo. Solamente va'cø vyat pømi'øyupø pøn, entonces muspa yac jøcøjay lo que ijtu tyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Viyuṉsye mi nøjmandya'mbøjtzi, Diosis yaj cøtocojayajpa aunque jujchepø pø'nis cyoja y mumu cyø'o'nøpyapø'is Dios. ");
INSERT INTO zosNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero cyø'o'nøpapø'is Masanbø Espiritu Santo nunca ji'n maṉ cyøtocoy cyojapit, sino que cyojate mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jetse ñøjayaju Jesusis porque 'yenemigo nømyaju que yatzi'ajcu'is ñu'cscotzonu Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Entonces nu'cyaju Jesusis myama y myuqui. Pero tzø'yaju a'ṉgomo, y cyøvejayaju ote va'cø minø. ");
INSERT INTO zosNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Y 'yaṉbocsyajuna'ṉ Jesús sone pø'nis, y ñøjayaju: ―Mi mama y mi muṉgui a'ṉgomo ityaju y nø mi mye'chaju. ");
INSERT INTO zosNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero Jesusis 'yaṉdzoṉu, ñøjayaju: ―Maṉba mi ndzajmatyame ita'mete ø mama y ita'mete ø muṉgui. ");
INSERT INTO zosNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Entonces Jesusis 'ya'myaj sone pøn pyo'cscøvitu'yajupø'is y nømgue'tu: ―Lo que po'csyajupø yø'qui, jejta'mete ø mama y ø muṉgui. ");
INSERT INTO zosNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Porque Diosis syunbase chøcyajpapø'is, jejta'mete ø muṉguita'm y ø mamanda'm. ");
INSERT INTO zosNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Entonces aṉma'yocho'tzque'tu Jesús mar acapoya. Y sone pø'nis cyøtu'myaju Jesús. Porque sone pøn ityaju aṉcø, tøjcøy Jesús barco'omo jana mye'jca'myajø, y jen po'cs barco'omo. Majromo it barco tome ispa nas y sone pøn nascøsi ityaj mar acapoya. ");
INSERT INTO zosNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Y Jesusis cham historiaji'ṉ vøti co'ma aṉgui'mocuy ñøjayaju: ");
INSERT INTO zosNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Mandam yøṉø. Ijtuna'ṉ tum pøn maṉu'is vyic tømbuj nas tajcøpucsi'omo. ");
INSERT INTO zosNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Y cuando nømna'ṉ vyijcu, tum nivoya quec tu'ṉomo, y miñaju paloma y jyu'cyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tum nivoya quec tza'cøsi tzejati ijtupøcøsi nas, y pronto nayu porque nas ji'na'ṉ tiṉdiṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Y cuando put jama, poṉga'u, porque ja tyøjcøy vyatzi jojmo. ");
INSERT INTO zosNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Y tum nivoya quec apijtomo, y apijti tzocyaju y ja yac tzoc nipi, y ja oy tø'maje. ");
INSERT INTO zosNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero tum nivoya quec vøjpø nasomo y nayu y tzojcu y tø'maju vøjø. Vene'csye'ṉomo tum kilo nijpu chi' treinta kilo; vene'csye'ṉomo tum kilo nijpu chi' sesenta kilo. Y vene'csye'ṉomo tum kilo nijpu chi' mosis kilo. ");
INSERT INTO zosNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Entonces Jesusis ñøjayaju: ―Mi nø'ijtamu'is mi ṉgoji va'cø mi manø, cøma'nøyø. ");
INSERT INTO zosNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jøsi'cam cuando Jesús tzø'y tyumgø'y y tzø'yaj jeni macvøstøjcay ñøtuṉdøvø y eyata'mbø pøn, 'yaṉgøva'cyaj Jesús va'cø cha'maṉvac jujchepø ti nø chamu. ");
INSERT INTO zosNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Y Jesusis ñøjayaju: ―Mitzta'm Diosis mi yac mustamba lo que ja myusyajøpø vi'na jujche aṉgui'mbase ñe'cø. Eyata'mbø lo que ji'n vya'ṉjamyajepø'is Dios, pues ndzajmapyøjtzi nascøsipø tiyø va'cø cha'maṉvac Diosis 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jetse ndzajmapyøjtzi va'cø isyajø, pero va'cø tzø'yaj como que ja isyaj ni tiyø; va'cø cyøma'nøyajø sin que va'cø jana cyønøctøyøyajø; ni va'cø jana yaj cøtocojayajtøj cyoja. ");
INSERT INTO zosNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Y Jesusis ñøjmayaju: ―¿O'ca ji'ṉ mi ṉgønøctøyøtyam yøṉ aṉma'yocuy, jujche maṉba mi ṉgyønøctøyøtyam mumu eyata'mbø aṉma'yocuy? ");
INSERT INTO zosNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jujche pø'nis pyuṉba tømbu, jetseti chamboyajque'tpa Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Como vene tømbu quejcu tu'ṉomo y jyu'c paloma'is, jetse vene pø'nis myañajpa Diosis 'yote, y jø'nøti miṉba Satanás y yac jajmbø'yajpa myanajupø tiyø va'cø jana chø'y choco'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Y como vene tømbu quec ijtumø tzeja nas tza'cøsi, jetse vene pø'nis myañajpa ote y yøti pyøjcøchoṉyajpa casøpya. ");
INSERT INTO zosNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Y como tømbu ja vyatzipøcø, y ja tyon nutzcø, jetsetique't ote ji'n nu'qui jojmo pø'nis choco'yomo. Entonces usyomo vyaṉjajmba, pero jøsi'cam ispa toya, y eyata'mbø'is yacsutzacyajpa Diosis 'yotecøtoya, entonces prontoti sunba jyajmbø'tyo'que'ta. ");
INSERT INTO zosNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Y como vene tømbu quec apijtomo, jetsetique't vene pø'nis myañajpa ote. ");
INSERT INTO zosNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero maya'jayajpa jujche ma tucnøm nascøsi, y riquesa'ajcu'is 'yaṉgøma'cøyajpa, y suñajpa auṉque tiyø. Y como tømbu'is 'yune ja vyø'ajø porque yaj ca'u cømø'ṉis, y ja tyø'møyø; jetse pø'nis vøti ti qui'pspa, y jyambø'pa Diosis 'yote, y ji'n chøc ni ti vøjø. ");
INSERT INTO zosNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero como eyapø tømbu quec vøjpø nasomo y tø'maju, jetse ityajpa cyøma'nøyajpapø'is ote y pyøjcøchoṉyajpapø'is y chøcyajpapø'is vøjpø tiyø. Como vene'ṉomo tum kilo nijpu chi' treinta kilo, y vene'ṉomo tum kilo nijpu chi' sesenta; y vene'ṉomo tum kilo chi' mosis; jetse veneta'mbø'is chøcyajpa usyta'm vøjpø tiyø, y eyata'mbø'is mas chøcyajpa vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Y ñøjmayajque't Jesusis: ―Ji'ndø nømindam no'a va'cø ndø cømucsøy tzicaji'ṉ, ni va'cø ndø cot øṉgucyøtøjcø'mø; sino no'a maṉba ndø nømindame va'cø ndø cot tablacøsi, va'cø syø'ṉ suñi. ");
INSERT INTO zosNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jetsetique't ja it ni ti anma'yocuy nu'm dzamdøjupø que ji'n maṉbapø mustøji. ");
INSERT INTO zosNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","O'ca it mi ṉgoji, cøma'nøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Y Jesusis ñøjmayaju: ―Tzøctam cuenda mi mandambapø ticøsi. Jujche'ṉomo mi ndzøjcapya cuenda ti nø chamupø Diosis, je'nche'ṉomo Diosis maṉba mi ñchi'aṉøy qui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","O'ca mitz nø'it algo, Diosis mas maṉba mi ñchi'aṉøyi; y o'ca ja mi nø'it ni tiyø, Diosis maṉba mi yac jøcøjay usy mi nø'ijtupø. ");
INSERT INTO zosNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Y Jesús nømu: ―Ma'ṉbø mi ndzajmatyame jujchepøte Diosis 'yaṉgui'mguy: Jujche pø'nis pyuṉba tømbu nascøsi, jetseti Diosis 'yaṉgui'mgucye't. ");
INSERT INTO zosNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cuando después nijpujcam, pøn øṉba tzu'i, sa'pa jyo'pit, y ya'pya poya cuenta, y tømbu napya y ye'ṉba y pø'nis ji'n myusi jujche Diosis yac ye'ṉba y yac itpa. ");
INSERT INTO zosNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lo que itpa nascøsi ñe'cti chi'pa tøm. Vi'na qui'mba cyuy, y jøsi'jcam po'pa, y jøsi'jcam møja'ajyajpa tyøm. ");
INSERT INTO zosNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Y cuando cøṉba, entonces pøn tzu'ṉyajpa va'cø maṉ tyucyajø porque nu'cu'came jyama. ");
INSERT INTO zosNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Y Jesús nømu: ―Va'cø ndø a'mø jujche tucpase nascøsi, jetse ndø tzi'pa cuenta jujche Diosis 'yaṉgui'mguy. Jetse ma'ṉbø mi ndzajmatyame. ");
INSERT INTO zosNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Como mostaza tømbu ndø nijpa, jetsetique't Diosis 'yaṉgui'mguy. Mostaza tømbu masti nama que ji'n aunque jutipø tømbu ndø nijpapø nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero cuando ndø nijpa, ye'ṉba y mas møja'ajpa que aunque jutipø ta'nø, y itpa møjapø 'yaṉmaṉ. Hasta sititvityajpapø paloma'is muspa chøcyaj ño'sa cyømøṉgø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jetse sone co'ma aṉma'yocyuy cham Jesusis va'cø 'yaṉmayajø Diosis 'yote hasta jujche muspa'csye'ṉomo cyønøctyøyøyajø pø'nista'm. ");
INSERT INTO zosNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Chamu jujche tucpase nascøsi va'cø tø aṉmayø jujche Diosis 'yaṉgui'mgusye. Pero ne'ti ñøtuṉdøvøji'ṉ cha'maṉajcayajpana'ṉ mumu va'cø cyønøctøyøyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mismo jama cuando tza'i'ajnømu'c, Jesusis ñøjayaj ñøtuṉdøvø: ―Ma tø cøjtam mar cøtu'maṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Y ñøtuṉdøvø'is 'yo'nøyu tzacyaj sone pøn, y ñømaṉyaj Jesús barco'om ijtupø'omna'ṉ. Y eyata'mbø barco maṉyajque'tuti. ");
INSERT INTO zosNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Y joviti min poycho'tz pømipø sava, y barco'omo tyapstøjcøy nø' hasta que tas barco. ");
INSERT INTO zosNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús oṉuna'ṉ tøṉgøscøsi barco tu'tzomo. Eyata'mbø'is entonces yac sa'yaj Jesús y ñøjmayaju: ―¡Maestro! ¿Ji'nø mi ndzøjcay cuenta aunque maṉba'am tø ca'tame? ");
INSERT INTO zosNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jicsye'c Jesús sa'u, y 'yojnay sava, y ñøjmay nø': ―¡Vøṉneyø! Y vøṉgajpø sava, y vøṉgønecnømu. ");
INSERT INTO zosNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesusis ñøjmayaj ñøtuṉdøvø: ―¿Ti'ajcuy nø mi ña'tztamu? ¿Ti'ajcuy ji'n mi ⁿvya'ṉjajmondyame? ");
INSERT INTO zosNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jicta'm na'tzco'ñaju, nañøjmayajtøju: ―¿Ipø pø'nacsque'te? Hasta sava'is y nø'is cyøna'tzøyajpa. ");
INSERT INTO zosNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Y nu'cyaj Gadara nasomo, mar cøtu'møṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Put Jesús barco'omo, y jicse'c cyønu'c tum pø'nis lo que yatzi'ajcu'is ñøc'ijtøyupø. Je pøn tzu'ṉ ñijpoñømbamø. ");
INSERT INTO zosNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Porque jiṉ itpapø ñijpoñømbamø, y ni i'is ji'n mus myocs cadenaji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Porque vøti nac oyu myocsayaj cadenaji'ṉ cyø' y cyoso, pero cadena tyucjacjacvøyu tzacpa, y ni i'sna'ṉ ji'n mus ya'inducø. ");
INSERT INTO zosNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Y vitpana'ṉ tumdum jama chu'ji'ṉ jamaji'ṉ. Opyana'ṉ cotzøjcomo y ñijpoñømbamø y vejpana'ṉ y yajpana'ṉ vyin tza'ji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Cuando is Jesús ya'iti, popya cyønu'c pø'nis y cyutcøne'cayu. ");
INSERT INTO zosNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Y pømi veju, ñøjayu: ―¿Ti mi sunba øtzji'ṉ, Jesús tzajpombø Diosis mi 'Yune? Mi va'ṉgapyøjtzi Diosis vyi'naṉdøjqui va'cø jana mi ndø tzøjcay ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jetse ñøjayu porque Jesusis ñøjayumna'ṉ yatzi'ajcuy: ―¡Tzac je pøn! ");
INSERT INTO zosNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Y Jesusis 'yaṉgøva'cu, ñøjayu: ―¿Jujche mi nøyi? Y pø'nis yaṉdzoṉu, ñøjayu: ―Ø nøyi, Legión. Jetse ø nøyi porque soneta'mbø chø'ṉø. ");
INSERT INTO zosNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Entonces je yatzi'ajcu'is vya'cayaj Jesús va'cø jana cyø'vejyaj eyapø nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ijtuna'ṉ vøti yoya nø cyu'tyajupø quetzacøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yatzi'ajcu'is 'yo'nøyaj Jesús ñøjayaju: ―Tø cø'vejtamø yoya'omda'm va'cø mi ndø yac tøjcøtyam je'tomda'm. ");
INSERT INTO zosNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Entonces Jesusis chi'yaj permiso. Yatzi'ajcuy putyaju pø'nomo y tøjcøyaj yoya'omda'm. Y yoya poyaju y pitimø'ñaj quetza'omo nu'cyaju nø'cø'mø y su'csca'yaju. Ijtuna'ṉ sone yoya como dos milsye'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Entonces cyoqueñajpapø'is yoya poye maṉyaj cumgu'yomo y ribera'omo. Maṉ cyotzamyaj ti tujcu. Y myañajupø'is tzu'ṉyaju, y maṉ cyøque'nøyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Y cyømiñaju Jesús y is po'csupø jeni pøn lo que ñøc'ijtøyupøna'ṉ yatzi'ajcu'is. Isyaju pøn tzojcupø tucu mesupø y vø'ajupø qui'psocuy; y na'chaju. ");
INSERT INTO zosNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Y isyajupø'is chamyaju jujche tzoc pøn nøc'ijtøyajupøna'ṉ yatzi'ajcu'is, y chamyajque'tu jujche tucyaj yoya. ");
INSERT INTO zosNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Entonces pø'nista'm vya'cayaj Jesús va'cø chu'ṉø ñe' ñasomda'm. ");
INSERT INTO zosNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cuando nømna'ṉ tøjcøy Jesús barco'omo, min pøn nøc'ijtøyajupøna'ṉ yatzi'ajcu'is vi'na, y ñøjmay Jesús: ―Su'nbø va'c maṉ mi mba'tø. ");
INSERT INTO zosNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jesusis ja syun ñømavø, ñøjmayu: ―Mavø mi ndøcmø. Y ma tzajmayaj mi ndøvø ti chøjcu ndø Comi Diosis mitzcøtoya, y jujche mi ñdyo'ya'ṉøy Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Y maṉ je pøn y maṉ chajmayaj aunque iyø Decápolis cumgu'yomda'm ti chøc Jesusis ñe'jcøsi. Y mumu ñømaya'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Y barco'omo cøtque't Jesús mar cøtu'møṉ y jen cyøtu'myaju sone pø'nis, y Jesús jiṉ tzø'y mar acapoya. ");
INSERT INTO zosNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Y ijtuna'ṉ tum pøn ñøyipø'is Jairo, covi'najøpø tum Israel pø'nis cyonocscuy tøjcomo. Cuando is Jesús, cyønu'cu y cyutcøne'c Jesusis cyosocø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Y cyøpena'øyu, vya'cay pyasencia'ajcuy, ñøjmay algo va'cø myajṉay tyøcmø. Ñøjmayu: ―Ø yom'une nø cya'u. Mavø, cot mi ṉgø' ø ⁿunecøsi va'cø choca, va'cø cyena. ");
INSERT INTO zosNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Y Jesusis maṉ pya't je pøn. Y sone pø'nis maṉ pya'tyajque'te y mye'cyajpana'ṉ Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Y minu tum yomo ca'epø. Macvøstøjcay amemna'ṉ ijtumø yom pyoya ca'cuy, putpana'ṉ vøti ñø'pin. ");
INSERT INTO zosNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Y toya'isuna'ṉ, tantos oy cho'yøjo'yaj vøti doctojris, y yajpø mumu tyumin; y ja choca, sino mas pømi'aj cya'cuy. ");
INSERT INTO zosNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yøṉ yomo'is myan nø chamdøjupø tina'ṉ nø chøc Jesusis. Entonces cyømin Jesús jyøsaṉgø'mø vøti pø'nomo, y jyajsisay Jesusis tyucu. ");
INSERT INTO zosNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Porque nømna'ṉ qui'ps choco'yomo: “O'ca mbi'quisapyati tyucu, tzocpøjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Cuando pi'quisay tyucu, jø'nøti pujtaṉjej ñø'pin, y 'yaṉjam vyin que tzojcu'am, ja itya'am ni ti ca'cuy. ");
INSERT INTO zosNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Entonces Jesusis 'yaṉjajmu que ñe'c milagro vini yac tzoc ca'epø, y quen vitu'u, cyøque'nøy vøti pøn y nømu: ―¿I'is pi'quisay ø nducu? ");
INSERT INTO zosNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Y ñøtuṉdøvø'is ñøjayaj Jesús: ―A'mønde que pø'nis nø mi mye'cyaju. ¿Ti'ajcuy mi ñømba: “¿I'is pi'quis øjtzi?” ");
INSERT INTO zosNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Y Jesusis nømdøc cyen me'tz i'is pyi'quisupø. ");
INSERT INTO zosNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Como yomo'is myuspana'ṉ que pi'quisu'øctøc tzoc cya'cuy, pues na'tzu; søtøtpa maṉ cutcøne'c Jesusis vyi'naṉdøjqui y chajmayu jujche pya't chojcuy. ");
INSERT INTO zosNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Y Jesusis ñøjayu: ―Øjtzø mi une, porque mi ndø va'ṉjajmu, mi ñchojcu, maṉ contento; tzojcu'am mi ṉga'cuy. ");
INSERT INTO zosNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nømdøcna'ṉ 'yo'nøy Jesusis jetse cuando miñaj pøn tzu'ṉyajupø conocscuy tøc covi'najø'is tyøcmø; ñøjayu: ―Ca'u'am mi ⁿune. ¿Ti'ajcuy mi jyorvatzøcpa Maestro? ");
INSERT INTO zosNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesusis myanu ti nø chamyajupø y ñøjmay covi'najø: ―¡Uy ña'tze, namas tø va'ṉjam øjtzi! ");
INSERT INTO zosNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Entonces Jesusis ñømaṉyaj Pedro y Jacobo y Jacobo'is tyøvø Juan. Ni i más ja o yac mave. ");
INSERT INTO zosNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nu'cyaj covi'najøpø'is tyøjcomo, y isyaj jujche nø cyøtasyaj sone pø'nis, y nømna'ṉ cyøvo'yaju y cyøvejyaju vøti porque ca' une. ");
INSERT INTO zosNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús tøjcøyu y ñøjmayaju: ―¿Ti'ajcuy tantos mi ṉgøtastamba y ṉgøvo'tamba yøṉ une? Ja cya'øpøṉø, sino øṉupøtite. ");
INSERT INTO zosNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Y syijcayaj Jesús porque Jesús nømu que øṉupøtite, pero ca'upøna'ṉete. Pero Jesusis myacputyaj mumu pøn a'ṉgomo, y tøjcøy Jesús cuarto'omo ijtumø ca'upø une. Yac tøjcøyajque't une'is jyata y myama y ñe'cji'ṉ nømna'ṉ miñajupø. ");
INSERT INTO zosNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesusis ñujcay une'is cyø' y ñøjayu ñe 'yote'omo: ―Talita, cumi ―pero øtz nømdambase, ñøjayu: Papiñomo, mi nøja'mbyøjtzi, te'ñchu'ṉø. ");
INSERT INTO zosNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jicse'cti te'ñchu'ṉu, y ijtupømete macvøstøjcay 'yame papiñomo'is. Y na'tzpa a'myaju y maya'co'ñaju. ");
INSERT INTO zosNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero Jesusis 'yaṉgui'myaj viyuṉsye va'cø jana chamnøvityaj ti tujcu. Y cyø'aṉgui'møyaju va'cø chi'yaj cu'tcuy yom'une. ");
INSERT INTO zosNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Y Jesús tzu'ṉ jeni, maṉ ñe' cyumgu'yomo y ñøtuṉdøvø'is maṉ pya'tyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Cuando nu'c sapøjcuy jama, Jesús aṉma'yocho'tzu Israel pø'nis cyonocscuy tøjcomo. Sone nømna'ṉ cyøma'nøyajupø'is nømna'ṉ qui'psyaju tiyete, nømyaju: ―¿Jut aṉmatyøj yøṉ pøn yøcsepø musocuji'ṉ, y jujche qui'psocu'yøcyomø'nu? ");
INSERT INTO zosNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yøṉ pøn carpinterote, Maria'is 'yune. Yø'c ityaju tyøvø Jacobo, José, Judas y Simón. Y yø'c ityajque'tu yomota'mbø tyøvø. ¿Jujche muspa chøc jetsepø møja'ṉ maya'cuy? Y ja pyøjcøchoṉyaj Jesús, qui'sayaju. ");
INSERT INTO zosNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pero Jesusis ñøjmayaju: ―Mumu tza'maṉvajcopyapø vøcotzøctøjpa auṉque juti. Unico ñe' cyumgu'yomda'mbø'is y ñe' tyøvø'is y ñe' itcu'yomda'mbø'is ji'n vyøcotzøcyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Y jiṉø Jesusis ja mus chøc mas milagro'ajcuy, unico metzcuy tu'capyø ca'epøcøsi cyot cyø' y yac tzocyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Y Jesús maya'u porque ja vyaṉjamyajø; y 'yoc vijtu che'ta'mbø cumguy va'cø 'yaṉma'yoya. ");
INSERT INTO zosNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesusis vyejtu'myaju macvøstøjcay ñøtuṉdøvø y cyø'vejyaju va'cø vityaj metzcuy metzcuy. Chi'yaj aṉqui'mguy va'cø mus nøpujtayaj yatzi'ajcuy pø'nomda'mbø. ");
INSERT INTO zosNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Y 'yaṉqui'myaju Jesusis va'cøti ñømaṉyaj saṉ cutacusti, va'cø jana ñømaṉ cu'tcuy, ni morral, ni tumin chunu'omo; ");
INSERT INTO zosNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","va'cø myesyaj vacasnaca, y va'cø jana ñømaṉ eyapø tyucu. ");
INSERT INTO zosNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ñøjmayajque'tu: ―Jutipø tøjcom mi ñdyøjcøtyamba, jen tzø'tyamø; u cyacpø'tam cojejcuy hasta que mi ñchu'ṉdamba jeni. ");
INSERT INTO zosNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Y o'ca ji'n mi mbyøjcøchoṉdame, ni ji'n mi ṉgyøma'nøtyame; entonces cuando mi nchu'ṉdamba jeni, cøtijtam po'yoji'ṉ mi ṉgoso como seña que ijtayaj cyoja jic cumgu'yomda'mbø'is. Jic jama cuando Diosis maṉba yaj quejayaj mumu pø'nis cyoja, jic cumgu'yomda'mbø mas maṉba yaj coja'ajyaj Diosis que menos Sodoma y Gomorra cumgu'yomda'mbø. Viyuṉse mi ndzajmatyamba jetse. ");
INSERT INTO zosNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Entonces ñøtuṉdøvø tzu'ṉyaju y chajmayaj mumu pøn va'cø qui'psvitu'yajø y chacyaj yatzitzoco'yajcuy. ");
INSERT INTO zosNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Myacputyaj yatzi'ajcuy pø'nomda'm y jyasyaj sone ca'eta'mbø aceiteji'ṉ va'cø yac tzocyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Møjaṉ aṉgui'mbapø Herodesis myan ti nø chøjcupø Jesusis, porque aunque juti tzamdøju Jesusis nø chøjcuse. Aṉgui'mbapø'is cyomo'yu que Juan nø'yø'opyapø vøcovisa'que'tu, y nømu que por eso muspa chøc auṉque tiyø porque visa'upøte. ");
INSERT INTO zosNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Eyapø nømyajque'tpana'ṉ que Jesús tza'maṉvajcopyapø Eliasete, eyapø nømyajque'tpana'ṉ que Jesús tza'maṉvajcopapøte jujche itpasena'ṉ ya'møc. ");
INSERT INTO zosNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero cuando Herodesis myan ti nø chøc Jesusis, nømu: ―Juanete. Øtz ⁿyac tøcspøjatyøj cyopac, pero visa'que'tuti. ");
INSERT INTO zosNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Porque ñe' Herodesis oyuna'ṉ yac nuctøj Juan y oyu cyot preso'omo. Porque ijtuna'ṉ Herodesis myuqui Felipe, y Felipe'is yomo ñøyipø'is Herodías. Pero Herodesis oyu cyøpøc myuqui yomoji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Entonces Jua'nis ñøjayu Herodes: ―Ji'n mus mi ṉgøpøc mi ndøvø yomoji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Por eso yomo Herodiasis qui'sayu Juan, y yaj cojtøj preso'omo, sunbana'ṉ yaj ca'ø, pero ja mus yaj ca'ø. ");
INSERT INTO zosNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Porque angui'mbapø Herodesis ña'tz Juan, porque myusu que vøpø pønete, y Diosis vyi'naṉdøjqui cøvajcøyupøte. Por eso Herodesis cyoquen Juan va'cø jana yacsutzøc yomo'is. Herodesis cyøma'nøyu Juan con ganas, aunque ja cyønøctøyøpø' ti nø chamupø. ");
INSERT INTO zosNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero entonces yomo'is pya'tay jyama jujchøc va'cø yaj ca' Juan. Herodesis cyosø'ṉaju cyumpliaños y vyejayaju covi'najø tøvø y soldado covi'najøta'm y mas covi'najøtambø Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Cuando mumu ityajuna'ṉ tu'myajupø, Felipe'is yomo'is 'yom'une tøjcøyu y ejtzu aṉgui'mbapø Herodesis vyi'nomo. Y jetji'ṉ pocsyajupø'is syungo'ñaju jujche oyuse etze, por eso aṉgui'mbapø Herodesis ñøjay papiñomo: ―Va'cø lo que ti mi sunba, y mi ndzi'pøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nømu que de veras maṉba vyactzi' lo que nø syunupø, ñøjayu: ―Viyuṉse ma'ṉbø mi ndzi' ti mi ⁿva'cpa, aunque sea cuc vene ø ⁿitcuy; ispa Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Y papiñomo pujtu y ñøjay myama: ―¿Ti ⁿva'cpøjtzi? Y myama'is ñøjayu: Va'c Juan nø'yø'opyapø'is cyopac. ");
INSERT INTO zosNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Y pronto tøjcøque'tu ijtumø aṉgui'mbapø y ñøjayu: ―Su'nbøjtzi va'cø mi ndø tzi' yøti yøti tum pulatocøsi Juan nø'yø'opyapø'is cyopac. ");
INSERT INTO zosNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Entonces aṉgui'mbapø maya'u, pero como oyu cham que de veras maṉba chi', y lo que ityajupø'is jeni myañaju; ja syun ñøjay papiñomo que ji'n ma chi' lo que nø vya'cupø. ");
INSERT INTO zosNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Por eso jicsye'cti cyø'veju tum soldado va'cø maṉ yaj ca' Juan y ñømijnay cyopac. Soldado tzu'ṉu, maṉ preso'omo, y tyøcspøjay Jua'nis cyopac. ");
INSERT INTO zosNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Y ñømin pulato'omo y chi' papiñomo y papiñomo'is chique'tuti myama. ");
INSERT INTO zosNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jua'nis ñøtuṉdøvø'is myañaju ti tujcu, y miñaju va'cø pijṉayaj cyoṉña y maṉ ñijpayaje. ");
INSERT INTO zosNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nøtuṉdøvø lo que Jesusis cyø'vejyajupø vitu'yaju, y nu'cyaju Jesuscø'mø y chajmayaju mumu lo que oyupø chøcyaje, y jujche oyuse aṉma'yoyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Y Jesusis ñøjayaju: ―Tø maṉdya'i emøc ja ijnømømø va'cø tø sapøctam usyøc. Jetse nømu porque nømna'ṉ mingo'ñaj pøn Jesuscø'mø; y Jesús y jetji'n ityajupø ja chi'yaj lugar va'cø cyu'tyajø porque sone'ajyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Entonces Jesús tzu'ṉyaj ñøtuṉdøvøji'ṉ barco'omo va'cø myaṉyaj ja ijnømømø. ");
INSERT INTO zosNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero sone pø'nis isyaju cuando tzu'ṉyaju y ispøcyaj Jesús. Tzu'ṉyaju mumu cumgu'yomo y vi'na nu'cyaj nø myaṉyajumø Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pujtu'cam Jesús barco'omo, isyaj sone pøn; y Jesusis tyoya'ṉøyaju, porque como borrego ja ityajøpø'is i'is cuidatzøcyajpa tocoyajpa, jetse tocoyajpa jicø pøn. Y Jesusis 'yaṉmacho'chaj sone aṉma'yocuji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cuando tza'i'ajnømu'jcam, ñøtuṉdøvø'is cyømiñaj Jesús y ñøjmayaju: ―Tza'i'ajnømu'am, y ni ti ja it yøṉø lugajromo. ");
INSERT INTO zosNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yac maṉyaj mumu pøn va'cø maṉ cyu'tcuy juyaj ñe'cø vyingøtoyata'm tometa'mbø ribera'omo y colonia'omo, porque ja ñø'ityaj ni ti va'cø cyu'tyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesusis ñøjayaju: ―Tzi'tam mitz cu'tcuy. Ñøtuṉdøvø'is ñøjmayaj Jesús: ―¿Jujche muspa ndzi'tamø? Syunbana'ṉ dos mil peso va'cø juñdyam cu'tcuy mumu pøngøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesusis ñøjayaju: ―¿Jujche pan mi ⁿnø'ijtamu? Ma 'a'mistamø. Cuando myusyaju'c, ñøjayaju: ―Mosay pan ijtu, y metzcuy coque. ");
INSERT INTO zosNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Entonces Jesusis 'yaṉgui'myaj mumu pøn va'cø pyo'csquecyaj majcay yøjtay nivoya vøtita'm chuchmu'como. ");
INSERT INTO zosNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Y po'csquecyaju sone nivoya. Vene'ṉomo cincuenta po'csyaj tyumø'omo, y vene'ṉomo cien po'csyaju tyumø'omo. ");
INSERT INTO zosNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Entonces Jesusis pyøc mosay pan y metzcuy coque, y quenqui'm tzajpomo y cyømasa'nøyaju. Entonces Jesusis vyenve'n pan y chi'yaj ñøtuṉdøvø va'cø vye'nbø'pø'vøyaj sone pø'nomo, y jetseti coque metzcuy. Vye'nbø'yaj sone pø'nomo. ");
INSERT INTO zosNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mumu cu'tyaj tasyaju'csye'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nøtuṉdøvø'is piṉdasyaju macvøstøjcay vaca pan y coque aṉchø'yupø. ");
INSERT INTO zosNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ityajuna'ṉ como mosay mil pøn lo que oy cu'tyaje, aparte yomo y une. ");
INSERT INTO zosNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Entonces Jesusis yac tøjcøyaj ñøtuṉdøvø barco'omo va'cø vi'na maṉyaj Betsaida cumgu'yomo marcøtu'møṉ, mientras ñe' Jesusis 'yo'nøyu tzacyaj sone pøn. ");
INSERT INTO zosNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cuando pøn maṉyaju'cam, qui'm Jesús cotzøjcøsi va'cø maṉ 'yo'nøy Dios. ");
INSERT INTO zosNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cuando pi'tzø'ajnømu, barco cucmajromna'ṉ ijtu, y Jesús tyumdina'ṉ it nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Y Jesusis isu que ñøtuṉdøvø'is ji'n mus ñøvit barco porque sava'is ji'n yac mave. Entre las tres y las seis de la mañana Jesús nu'c ñøtuṉdøvøcø'mø. Nømna'ṉ vyit nø' vingøsi, y maṉbana'ṉ cyøjtayaje. ");
INSERT INTO zosNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nøtuṉdøvø'is isyaju Jesús nø' vingøsi nø vyijtupø, y cyomo'yaju o'ca animate, y vejyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Porque mumu isyaju y na'chaju. Pero Jesusis 'yo'nøyaju y ñøjmayaju: ―¡Øjchømøṉø, uy ña'tztame! ");
INSERT INTO zosNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Entonces Jesús tøjcøy barco'omo ityajumø ñøtuṉdøvø, y poyaṉjej sava. Y maya'yaj ñøtuṉdøvø. ");
INSERT INTO zosNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aunque isyaju que Jesusis yac vøti'aj pan, ja cyønøctøyøyajø ti muspa chøcø; porque ñøtuṉdøvø'is ja ityajøna'ṉ vya'ṉjajmocuy vøti. ");
INSERT INTO zosNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nu'cyaj marcøtu'møṉ Genesaret nasomo y jen majracapoya jyø'mu tzacyaj barco. ");
INSERT INTO zosNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cuando Jesús pujtu barco'omo, pø'nis ispøcyaj que Jesusete. ");
INSERT INTO zosNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Y mumu jic lugajromo chamboyaju jut it Jesús. Y cuando myañaj jut ijtu, ñømiñaju ca'eta'mbø patacøsta'm. ");
INSERT INTO zosNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nu'cpamaye Jesús, sea cumgu'yomo, sea colonia'omo, sea rancho'omo, cyotyajpana'ṉ ca'eta'mbø calle'omo, y vya'cayaj Jesusis pyasencia'ajcuy va'cø yac pi'quisyaj aunque sea tyucu coso. Y mumu pi'quisyajupø'is tzocyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nu'cyaj Jesuscømø fariseo'is 'yaṉma'yocuy ñø'ityajupø'is, y metzcuy tu'cay aṉgui'mopyapø aṉgui'mguji'ṉ Jerusalén gumgu'yomo tzu'ṉyajupø. ");
INSERT INTO zosNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Je'tista'm isyaju que vene Jesusis ñøtuṉdøvø cuando cu'tyaju, ja cyø'che'yajø jujche Israel pø'nista'm cyostumbre ijtuse, y por eso cyøtza'møyaj Jesusis ñøtuṉdøvø que ji'n cyo'aṉjamyaj Israel pø'nis cyostumbreta'm. ");
INSERT INTO zosNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Porque fariseo va'ṉjajmocuy ñømaṉyajupø'is y eyata'mbø Israel pønda'm ji'n cu'tyaje hasta que cø'che'yajpa jujche 'yaṉmayajuse vi'nata'mbø'is. ");
INSERT INTO zosNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Y cuando vitu'yajpa plaza'omo ju'yoñømbamø, o'ca ji'n cyø'che'yaje, ji'n cyu'tyaje. Y it vøti eyata'mbø cyostumbre cyo'aṉjamyajpapø vi'nata'mbø'is ñe. Cyøtze'yajpa pozuelo, tzica, y tø'ṉgupyø traste y 'yøṉguyta'm. ");
INSERT INTO zosNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Por eso fariseo'sta'm y aṉqui'mguyji'ṉ aṉma'yoyajpapø'is 'yaṉgøva'cyaj Jesús, ñøjmayaju: ―¿Ti'ajcuy mi nønduṉdøvø'is ji'n cyo'aṉjamyaj costumbre vi'nata'mbø'is chacyajupø? Porque cu'tyajpa ja cyø'che'yajøpø. ");
INSERT INTO zosNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesusis 'yaṉdzoṉu: ―Viyuṉse mitz mi ndzøctamba jujche Isaiasis chamuse. Mitz mi vingøvøjta'mdi pero jojmo mi ṉgui'psocutya'm yatzita'mbøte. Jyay Isaiasis que Dios nømu: Yøṉ pø'nis vøcotzøcyajpøjtzi 'yaṉnacapit, pero choco'yomo ji'n ø va'ṉjamyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Y comeque'cti cøna'tzøyajpøjtzi, porque 'yaṉmayajpa pø'nista'm 'yaṉma'yocuji'ṉ y nømyajpa que Diosis ñe'. ");
INSERT INTO zosNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Y ñøjayajque'tu Jesusis: ―Mitz ndzactamba lo que Diosis chamuse y mi ṉgøna'tzøtyamba pø'nista'm cyostumbre. Mi ṉgøtze'tamba tzica y posuelo, y vøti jetsepø costumbre mi ndzøctamba. ");
INSERT INTO zosNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sa'sa mi ndzøjcocøjtamba Diosis chamupø tiyø va'ca mi ndzøctamø mi ne' mi ṉgostumbre. ");
INSERT INTO zosNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Por ejemplo Moisesis chamu: “Cøna'tzøy mi janda y mi mama”, y también chamgue'tu: “Chamdzi'papø'is jyata o myama va'cø ti chøjcay Diosis, tiene que va'cø yaj ca'tøjø”. ");
INSERT INTO zosNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero mitz ñømdamba que tum pø'nis muspa ñøjmay jyata o myama: “Ji'n mus mi ṉgotzova, porque mumu lo que nø'ijtøjtzi interés ndzamdzi'ø Dios”. Jetse mi nøjandyamba Corbán. ");
INSERT INTO zosNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Y o'ca pøn nømba jetse, mitz ñømdamba que ji'ndyet pyena va'cø cyotzoṉ jyata o myama. ");
INSERT INTO zosNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jen mi ndocojatyamba Diosis 'yaṉgui'mguy va'cø mi ndzøctam mi ṉgostumbre vi'nata'mbø'is chacyajuse. Y mijta'm jetse mi aṉmañdyaṉque'tpa mi ⁿune, y sone yø'cseta'mbø tiyø mi ndzøctamba. ");
INSERT INTO zosNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Entonces Jesusis vyejtu'myajque't sone pøn y ñøjayaju: ―Tø cøma'nøtyam ti nø ndzamupø va'cø mi ṉgøñøctøyøtyamø: ");
INSERT INTO zosNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Aunque ti va'cø ndø cu'tø, ji'n tø yatzi'aje; ji'ndyet ni tiyø coja. Lo que putpa ndø tzoco'yomo, je'tis tø yaj cojapa'tpa. ");
INSERT INTO zosNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","O'ca ijtam mi ngoji, cøma'nøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Cuando Jesusis 'yo'nøyutzacyaj pøn y tøjcøy tøjcomo, entonces ñøtuṉdøvø'is 'yaṉgøva'cyaj yøcsepø ticøsi, syuñaju va'cø cha'maṉvac oyuse chame. ");
INSERT INTO zosNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesusis ñøjayaju: ―Entonces mitzta'm, ¿ti'ajcuy ji'n mi ṉgønøctøyøtyaṉgue'te? ¿Ti'ajcuy ji'n mi ṉgøñøctøyøtyame que lo que tøjcøpya ndø aṉna'ṉgomo, ji'n tø yu'qui ndø tzococøsi? ");
INSERT INTO zosNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Porque ji'n tøjcøy ndø tzoco'yomo, sino ndø tzejcomo, y jøsi'cam putque'tpa. Jetse cha'maṉvajcu Jesusis que aunque jujchepø cu'tcuy muspa ndø cu'tø. ");
INSERT INTO zosNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Y ñøjmayajque'tu: ―Lo que putpapø ndø tzoco'yomo, je'is tø yaj cojapa'tpa. ");
INSERT INTO zosNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porque jojmo pø'nis choco'yomo qui'pspa va'cø chøcø yatzita'mbø tiyø. Qui'pspa va'cø møtzi ñø'it yomo, va'cø cyøtzøjcø'yoya, va'cø yaj ca'oya, ");
INSERT INTO zosNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","va'cø ñu'mø, va'cø 'yaṉsujnayaj aunque tiyø eyapø'is ñe', va'cø chøcto' yatzipø tiyø, va'cø 'yaṉgøma'cø'yoya, va'cø chøc yatzitzoco'yajcuy, va'cø cojajeji'ṉ is tyøvø porque más vøj ijtu, qui'pspa va'cø tyopo'o'nøy tyøvø, y ñe' va'cø myøjatzøc vyin, ji'n it qui'psocuy vøjpø. ");
INSERT INTO zosNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mumu jetseta'mbø tiyø ndø qui'pspa ndø tzoco'yomo, y tø yac tocopya. ");
INSERT INTO zosNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús tzu'ṉu y maṉ vit tome Tiro y Sidón cumgu'yomo. Tøjcøy tum tøjcomo y ji'na'ṉ syuni va'cø myustøjø jut ijtu, pero ja mus 'yaṉgøvø'nø. ");
INSERT INTO zosNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Porque myusu tum yomo'is que jen it Jesús. Yomo'is ñø'ijtu tum yom'une ñøc'ijtøyupø yatzi'ajcu'is. Yomo pronto minu Jesuscø'mø y japcøne'c vyi'naṉdøjqui va'cø vya'cay pyasencia'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yøṉ yomo emøcpø yomote, griego ote chambapø'is, y raza tiyøjquete Sirofenicia. Yøṉ yomo'is vya'c Jesuscøsi va'cø yac tzu'ṉay yatzi'ajcuy 'yune'is choco'yomo. (Pero como yomo eyapø cumgu'yombø y Israel pø'nis tyuyicotzøcyajpana'ṉ eyapø cumgupyøṉ), ");
INSERT INTO zosNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","por eso Jesusis ñøjayu: ―Hay que vi'na va'cø ndø pø'nøy ndø une, y ji'n vyøj va'cø ndø cøpøc une cyu'tcuji'ṉ va'cø ndø pø'nøy tuyi. Jetse ji'n mus mi ṉgotzova, porque mitz ji'ndyet mi Israel pøn como si fuera une. ");
INSERT INTO zosNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero yomo'is 'yaṉdzoṉu: ―Viyuṉse mi ñchamba, Señor, pero aunque mi ṉgumguy tøvø'is tuyicotzøcyajpøjtzi, tø cotzoṉ usyta'm como mesacø'mø tuyi'is piṉyajpa cømu'taṉ lo que une'is tiquipø'yajpa. Jetsetique't mi ndø yac tzojcacye't ø une aunque emøcpø yomo chøṉø. ");
INSERT INTO zosNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Entonces Jesusis ñøjayu: ―Vøjti mi ndø aṉdzoṉu. Muspa mi myaṉ yøti. Yatzipø espiritu pujtu'am mi ⁿune'omo. ");
INSERT INTO zosNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cuando yomo nu'c tyøcmø, pya't 'yune 'yuṉgucyøsi, y yatzipø espiritu'is chajcumna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús tzu'ṉque't Tiro cumgu'is cuenta y cøt Sidón cumgu'yomo y ñøjayajpamø Decápolis, y nu'c Galilea majraṉvini. ");
INSERT INTO zosNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Y ñømiñaj tum pøn cojipø y umapø, y vya'cayaj Jesusis pyasencia'ajcuy va'cø cyot cyø' ca'epø pøngøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesusis ñømaṉu pøn ne'ti jya'itømø ni iyø, y piquisayaj pø'nis cyoji y tzuju y pi'quisay tyotz. ");
INSERT INTO zosNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Entonces quengui'm tzajpomo, je'pyøjcu, y nøjayu ñe' 'yote'omo: ―¡Efata! ―pero øtz nøjayndya'mbøjtzi ndø onde'omo: ¡Aṉvacø! ");
INSERT INTO zosNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jicse'cti aṉvacyaj cyoji, y tyotz tzojcu, y vejvejnecho'tzu suñi. ");
INSERT INTO zosNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Y 'yaṉgui'myaj Jesusis va'cø jana cyotzamyaj jujche yac tzoc ca'epø. Pero entre mas 'yaṉgui'myaj jetse, mas cyotzamyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Y algo maya'yaju y nømyaju: ―Mumu ti chøcpa vøjø. Yac manba ote cojita'mbø, y yac vejvejneyajpa umata'mbø. ");
INSERT INTO zosNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jic tiempo tu'myaj sone pøn y ja itøna'ṉ ni ti va'cø cyu'tyajø. Entonces Jesusis vyejayaj ñøtuṉdøvø y ñøjayaju: ");
INSERT INTO zosNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ndoya'ṉøyajpøjtzi yøṉ pønda'm porque ijtum tu'cay jama nø pa'tyajumø, y yøti ja it ni tiyø va'cø cyu'tyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Y o'ca ⁿyac maṉyajpa tyøcmøta'm jana cu'ti, ji'n maṉ tyoñaj ojse, porque vene tzu'ṉyaju ya'i. ");
INSERT INTO zosNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ñøtuṉdøvø'is ñøjmayaj Jesús: ―¿Jut maṉba ndø mbøctam cu'tcuy va'cø ndø pø'nøtyamø? porque yø'qui ni i ja itø. ");
INSERT INTO zosNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesusis 'yaṉgøva'cyaju: ―¿Jujche mi nø'ijtam pan? Y ñøjayaju: ―It cu'yay. ");
INSERT INTO zosNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Entonces Jesusis 'yaṉgui'myaju vøtita'mbø pøn va'cø pyo'csquecyajø nasomo. Pyøc cu'yapyø pan y ñøjay Dios yoscøtoya. Entonces ñama ven pan y chi'yaj ñøtuṉdøvø va'cø syajyaj sone pø'nomo, y jetse chøcyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Y ityajque'tu metzcuy tu'cay namapø coque. Jesusis cyømasa'nøcye'tuti y ñøjayaju va'cø syajyajque'tati. ");
INSERT INTO zosNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Y mumu cu'jtasyaju y después piṉdasyaj cu'yay vaca lo que tzø'yupøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Y ityaj como macscuy milsye'ṉomo. Entonces Jesusis ñøjayaj pønda'm va'cø myaṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Y Jesús tøjcøy barco'omo ñøtuṉdøvøji'ṉ y maṉ Dalmanuta nasomo. ");
INSERT INTO zosNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Entonces miñaj fariseo aṉma'yocuy ñø'ityajupø'is y ñø'onguipyaju Jesús. Y va'cø 'yaṉgøma'cø'isyajø vya'cayaju va'cø isindzi'yaj milagro'ajcuy como seña que Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús møja je'pyøjcu y nømu: ―¿Ti'ajcuy syuñajpa milagro'ajcuy va'cø isyajø yøtita'mbø pø'nis? Viyuṉsye mi ndzajmatyamba que øtz ji'n ma yac isyaj ni ti seña. ");
INSERT INTO zosNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesús tzu'ṉ sone pø'nomo y tøjcøcye't barco'omo y maṉyaj mar cøtu'maṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Y jyajmbøyaj ñøtuṉdøvø'is va'cø ñømaṉyaj cu'tcuy, nada mas tumdina'ṉ it pan barco'omo. ");
INSERT INTO zosNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Entonces Jesusis 'yaṉgui'myaju ñøjayaju: ―Cøma'nøtyamø; tzøctam cuenda yac poṉoṉbapø'is pan fariseo'is ñe'ta'm y Herodesis ñe'ta'm. ");
INSERT INTO zosNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Y ñøtuṉdøvø tzamdzamnecho'chaju entre ne'comda'm nømyaju: ―Puede ser jetze chamba porque øtz ja ñø'ijtam pan. ");
INSERT INTO zosNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesusis myusu ti nø chamyaj ñe'comda'm y nøjmayaju: ―¿Ti'ajcuy mi ñømdamba que ja it pan? ¿Ti'ajcuy ji'ndøc mi ṉgøñøctøyøtyame, ni ji'ndøc mi mustame ti'ajcuy øtz ndza'mba yac poṉoṉbapø'is pan? Ja it vøjpø mi ṉguipsocutya'm. ");
INSERT INTO zosNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ijtam mi vindøm, pero ji'n mi istame. Ijtam mi ṉgoji, pero ji'n mi mya'nondyame. ¿Ti'ajcuy ji'n mi jamdame? ");
INSERT INTO zosNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cuando øtz ve'nbø'øjtzi mosay pan para mosay mil pøngøtoya, ¿jujche mi ⁿjojøndyastamu vaca tzø'yupøji'ṉ? Y ñøjayaju: ―Doce. ");
INSERT INTO zosNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Entonces Jesusis ñøjayajque'tu: ―Y cuando ve'nbø' øjtzi cu'yay pan para macsycuy mil pøngøtoya, ¿jujche mi ⁿjojøñdyastam vaca tzø'yupøji'ṉ? Y ñøjayaju: ―Cu'yay. ");
INSERT INTO zosNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesusis ñøjayajque'tu: ―¿Y ji'ndøc mi ṉgøñøctøyøtyame? ");
INSERT INTO zosNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nu'cyaj Jesús Betsaida cumgu'yomo y nø ñu'cyaj tum to'tipø pøn y ñu'csayaju Jesús va'cø pi'quisø. ");
INSERT INTO zosNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesusis ñujcay cyø' y jitinømaṉ pøn cumgu'acapoya. Jesusis cyøtzujøy vyitømgøsi y cyojtu cyø' pøngøsi y 'yaṉgøva'cu o'ca isopya'am. ");
INSERT INTO zosNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Pøn quenvijtu y ñøjayu: ―Isyajpa'mtzi pønda'm te'ñaju, como cusye a'myajpøjtzi, pero vityajpa. ");
INSERT INTO zosNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Entonces Jesusis cyotvøjøtzøc cyø' je'is vyitømgøsi, y pø'nis chøjquisu o'ca ispa'am y sø'ṉ vitøm, y isoy vøjø. ");
INSERT INTO zosNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Entonces Jesusis ñøjayu: ―Maṉ mi ndøcmø, uy tyøjcøy cumgu'yomo, y u mi ndzajmay ni iyø jujche mi ñchojcu. ");
INSERT INTO zosNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús tzu'ṉyaj 'yaṉmayajpapøji'ṉ y maṉyaju Cesarea Filipo cumgu'is cyojajmbamø, y nø tyu'ṉayaju'øc Jesusis 'yaṉgøva'cyaju ñøtuṉdøvø ñøjayaju: ―¿Jujche nømyajpa pøn que ipø pøn chøṉ øjtzi? ");
INSERT INTO zosNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ñøtuṉdøvø'is ñøjayaju: ―Ijtu nømyajpapø que mijtzimete Juan mi ñø'yø'ombapø; eyapø nømyajpa que mijtzimete Elías; eyapø nømyajpa que mijtzimete iyø jutipø tza'maṉvajcopapø. ");
INSERT INTO zosNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Entonces Jesusis ñøjayaju: ―Y mijtzi, ¿jujche ñømdamba que ipø pøn chøṉø? Pedro'is ñøjayu: ―Mijtzete Cristo Diosis mi ṉgyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pero Jesusis 'yaṉgui'myaju va'ca jana maṉ chajmay ni iyø que Cristote. ");
INSERT INTO zosNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Entonces Jesusis chajmayaj ñøtuṉdøvø ñøjmayaju: ―Øjtzi Pø'nis chøṉ Tyøvø, tiene que va'cø toya'is øtz algo, porque ji'n ma pøjcøchoṉyaj tzambø'nis y aṉguimyajpapø'is y Moisesis 'yaṉgui'mguyji'ṉ 'yaṉmayajpapø'is; y ji'quista'm ma'ṉbø yaj ca'yaje. Pero ma'ṉbø visa' tyu'ca jamacøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sa'sa yaj cøñøctøyøyaj Jesusis jetse que maṉba yaj ca'tøji. Entonces Pedro'is ne'ti ñømaṉu Jesús y Pedro'is 'yojnayu Jesús, ñøjayu va'cø jana chi'ocuyaj vyin. ");
INSERT INTO zosNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero Jesús cye'najvitu y a'myaj ñøtuṉdøvø y 'yojnacye't Pedro ñøjayu: ―¡Tzu'ṉ ø ⁿvi'nomo mijtzi Satanás! Como pø'nis qui'psyajpase, jetse mi ṉgui'pspa; ji'ndyet como Diosis jujche qui'pspase. ");
INSERT INTO zosNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Entonces Jesusis vyejayaj mumu pøn ñøtuṉdøvøji'ṉ, ñøjmayaju: ―O'ca aunque i'is sunba maṉ pa'tø, tiene que va'cø jana tyoya'ṉøy vyin; y como pø'nis cyajpa cruz va'c maṉ cya' jetcøsi, jetse sunba'is min pa'tø, tiene que va'cø cyapque't cruz y va'cø min pa'tø. ");
INSERT INTO zosNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Porque o'ca ji'n sun cya'ø øtzcøtoya, maṉba tocoye: pero o'ca ca'pa øtzcøtoya y vøjpø otecøtoya, cotzocpa. ");
INSERT INTO zosNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Porque jujche vø'ajpa pøn o'ca gyanatzøcpa mumu tiyø nascøspø y tocopya vyin? ");
INSERT INTO zosNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Jujchecøs pues muspa ⁿjyuvyitu' vyin va'cø visa'ø? ¡Ni tipit! ");
INSERT INTO zosNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pues o'ca aunque i'is cotza'ajpa øjtzi y cotza'ajapya ø ønde yøṉ cojapa'tyajupø y cøtzøjcø'yoyajpapø pø'nomo, entonces también øtz Pø'nis chøṉ Tyøvø, øtz maṉba ṉgotza'ajque't jicø pøn cuando mi'nbøjtzi ø Janda'is syø'ṉgø'omo masanbø angelesji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Y ñøjayajque'tu: ―Viyuṉsye mi ndzajmatyamba, ijtu yø'qui mijtzomda'm vene ji'n mavepø cya'yaje hasta que isyajpa jujche Dios aṉgui'mbase pyømiji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cøjtu'cam tujta jama ñøjmayu'c jetse, Jesusis ñømaṉyaj Pedro y Jacobo y Juan tum ye'ṉupø cotzøjcøsi. Jiṉna'ṉ ityaj myacscucø'yi, y min eyati quene Jesús je'tis vyi'naṉdøjquita'm. ");
INSERT INTO zosNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tyucu o'ca tise popo sø'ṉgomø'nu. Ja it nascøs cøtze'opyapø muspapø'is yac popo'aj jetse. ");
INSERT INTO zosNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jicsye'c quejyaju Elías y Moisés. Jena'ṉ nø chamdzamneyaju Jesusji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Entonces Pedro'is ñøjmay Jesús: ―Maestro, vøjø va'cø tø ijtam yø'qui. Vøjø va'cø ndzøctam tu'cay pe'chtøc, tumø para mitzcøtoya, tumø para Moisescøtoya, y tumø para Eliascøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jetse nømu porque ji'na'ṉ myus ti va'cø chamø; porque na'tzco'ñaju. ");
INSERT INTO zosNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Entonces min o'na y cyømøṉ gøtzøjcøyaju y myañaju Diosis 'yote o'na'omo nø ñømupø: ―Yøṉete ø ⁿUne sunbapø øjtzi. Cøma'nøtyam ti chambase. ");
INSERT INTO zosNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jicsye'cam ñøtuṉdøvø'is cyenme'chaju y ni ja isyajø mas que tumdina'ṉ it Jesús ñe'cji'n. ");
INSERT INTO zosNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cuando nømna'ṉ myø'ñaj cotzøjcøsi, Jesusis 'yaṉgui'myaju ñøjmayaju: ―U mi ndzamdam ti mi istamu hasta que visa'pøjtzi øtz mumu Pønis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Y ja chajmayaj ni iyø ti isyaj cotzøjcøsi, pero na ñø'ocva'cyajtøju tiyacsque't chamba que maṉba visa'e. ");
INSERT INTO zosNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Entonces 'yocva'cyaj Jesús: ―¿Ti'ajcuy nømyajpa aṉgui'mguy myusyajpapø'is que Elías tiene que va'cø min vi'na y después minba Cristo? ");
INSERT INTO zosNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Y Jesusis ñøjayaju: ―Viyuṉete Elías vi'na minba y vyøjøtzøcpa mumu tiyø, y jicsye'c minba Cristo. Y viyuṉsye jyayaju tza'maṉvajcoyajpapø pø'nis que mumu Pø'nis Tyøvø tiene que va'cø toya isø, y ji'n ma pyøjcøchoṉyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero mi ndzajmatya'mbøjtzi que minu'am Elías y pø'nis chøjcayaju lo que syuñajuse, jujche jyayajuse ya'møcpø tza'maṉvajcoyajpapø pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Y entonces Jesús y vityajupøji'ṉ vitu'yaj ityajumø eyata'mbø ñøtuṉdøvø. Y isyaju vøti pøn que nø vyocøvitu'yajupø'is ñøtuṉdøvø. Y ityajque'tutina'ṉ aṉgui'mguy myusyajpapø'is que ñø'onguipyaju Jesusis ñøtuṉdøvø. ");
INSERT INTO zosNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Cuando isyaju Jesús, maya'co'ñaj vøti pøn y popya cyønu'cyaj Jesús y yuschi'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Entonces Jesusis ñøjayaju: ―¿Ti'ajcuy nø mi 'yonguiptam jetji'ṉ? ");
INSERT INTO zosNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jicsye'c onbujtu tum pøn sone pø'nomo, ñøjayu: ―Maestro, mi nømijnay øjtzi ø ⁿjaya une lo que nøc'ijtøyupø yatzipø espiritu'is y je'is yac uma'ajpa. ");
INSERT INTO zosNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aunque jut ñucpa espiritu'is, yac pitivitpa y aṉ'upu'øpya, y cyø'spa tyøtz, y nø tyøtzpø'u. O'yø va'ṉgayaj pyasencia'ajcutya'm mi nønduṉdøvø va'cø yac tzu'ṉyaj yatzipø espiritu, y ja mus yac tzu'ṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesusis ñøjmayaju: ―Mi mbyø'nista'm ji'n mi ⁿvya'ṉjajmondyamepø'is; ṉgo'i'nbøjtzi va'cø it vøti jama mitzji'ṉdam y naji'ndi mi ṉgøñøctøyøtyame. Ṉgo'i'nbøjtzi va'cø mi nømajṉandyam pasencia vøti jama. Nømindam yø'c ṉga'e. ");
INSERT INTO zosNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jicsye'c ñønu'cyaju. Cuando yatzipø espiritu'is isu'c Jesús, ṉga'e yac tu'yu; y quejcu nasomo, pitivijtu y aṉ'uputeju. ");
INSERT INTO zosNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Entonces Jesusis 'yaṉgøva'c ṉga'e'is jyata, ñøjayu: ―¿Jujche jama ijtu que yø'cse tuctzo'tzumø? Y ñøjayu: ―Cuando une'ctøc yø'cse tuctzo'tzu. ");
INSERT INTO zosNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Y vøti nac yatzipø espiritu'is yaj quecpa juctyøjcomo o nø'cø'mø va'cø yaj ca'ø. Pero o'ca muspa mi ndø yac tzojcayø, tø toya'ṉøtyamø y tø cotzoṉdamø. ");
INSERT INTO zosNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Y Jesusis ñøjayu: ―Mitz ndø nøjapya: O'ca mi muspa. ¿Ti'ajcuy mi aṉgøva'cpa o'ca muspa ndzo'yøyø? Va'ṉjambapø'stzi muspø ndzøjcay bien aunque ticøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Entonces ṉga'e'is jyata pømi veju ñøjayu: ―Øtz mi va'ṉjambøjtzi, pero tø cotzoṉø va'cø mi ⁿva'ṉjam más. ");
INSERT INTO zosNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jicsye'c is Jesusis que nø pyoyatu'mdu'mneyaju vøti pøn. Y 'yojnay yatzipø espiritu ñøjayu: ―Mijtzi mi yac uma'ajpapø'is mi 'yespiritu, øtz mi aṉgui'mba: tzac ṉga'e, y nunca u mi ñdyøjcøcye't ṉga'e'is choco'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Y espiritu veju y yac søtøt ṉga'e algo y chajcu. Y ṉga'e tzø'y como ca'upøse. Por eso pøn nømyaju: ―Ca'upømete. ");
INSERT INTO zosNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesusis ñuc cyø'cøsi y jyitite'nu, y ṉga'e te'ndonchu'ṉu. ");
INSERT INTO zosNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Entonces Jesús tøjcøy tøjcomo, y nøtuṉdøvø'is ne'ti 'yaṉgøva'cyaju ñøjayaju Jesús: ―¿Ti'ajcuy øtz ja mus yac tzu'ṉdam yatzi'ajcuy? ");
INSERT INTO zosNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Y ñøjayaj Jesusis: ―Yøcsepø yatzipø espiritu ji'n puti, o'ca ji'n ndø o'natyam Dios y va'cø jana tø cu'tø hasta que ndø o'nøyu'jcam Dios. ");
INSERT INTO zosNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tzu'ṉyaj jeni y cøtyaj Galilea nasomo, y Jesusis ji'na'ṉ syuni va'cø myus ni i'is o'ca jena'ṉ ijtu. ");
INSERT INTO zosNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Porque nømna'ṉ chajmayaj ñøtuṉdøvø, ñøjayaju: ―Øjtzi Pø'nis chøṉ Tyøvø maṉba tzi'ocuyajtøj pø'nis cyø'omo, y maṉba yaj ca'tøji y tu'cay jama ca'u'ctzi ma'ṉbø visa'que'te. ");
INSERT INTO zosNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero ñøtuṉdøvø'is ja cyønøctøyøyaj jujchepø tiyø nø cham Jesusis, y ja 'yocva'cyajø'am Jesús na'tzcupit. ");
INSERT INTO zosNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Y nu'cyaj Jesús Capernaum gumgu'yomo; y cuando tøjcomo ijtu'øc, Jesusis 'yaṉgøva'cyaj ñøtuṉdøvø: ―¿Tina'ṉ nø mi ndzamdam tu'ṉomo? ");
INSERT INTO zosNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero ja 'yaṉdzoṉyajø, porque tu'ṉomo nømna'ṉ 'yonguipyajto'u ñe'comda'm a ver jutipø nøtuṉdøvø mas covi'najø'ajupø. ");
INSERT INTO zosNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Entonces Jesús po'csu y vyejtu'myaj macvøstøjcay ñøtuṉdøvø y ñøjayaju: ―O'ca i sunba cyovi'najø'ajø; tiene que va'cø it como ja itø'is ni ti aṉgui'mguy, como tum chøsi; va'cø chøc nu'csocuy mumu pøngøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Y Jesusis pyøc tum une y cyot cujcomo. Jicsye'c jyotzcøtøjcøy une y ñøjay ñøtuṉdøvø: ");
INSERT INTO zosNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―O'ca mi mbøjcøchoṉba tum une yø'csepø ø nøyiṉgøsi, mi ndø mbøjcøchoṉgue'tpa øjtzi; y o'ca mi ndø pøjcøchoṉba, ji'n saṉ øtz mi ndø pøjcøchove, sino mi mbøjcøchoṉgue'tpati cø'vejupø'stzi. ");
INSERT INTO zosNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Entonces Jua'nis ñøjay Jesús: ―Maestro, ista'møjtzi tum pøn nø yac tzu'ṉupø'is yatzipø espiritu mi nøyiṉgøsi, y ⁿya'inducta'møjtzi, nøjandya'møjtzi: “Mitz ja mi nø'it permiso va'cø yac tzu'ṉ yatzipø espiritu”. Jetse nøjandya'møjtzi porque jicø pøn ji'n vit tyumø'omo tø øtzji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero Jesusis ñøjay Juan: ―U mi ya'inductamu, porque o'ca pø'nis chøcpa milagro'ajcuy ø nøyiṉgøsi, al mismo tiempo ji'n mus cø'o'nøy øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Porque o'ca ji'n tø qui'saye, tø cotzoṉba. ");
INSERT INTO zosNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Viyuṉsye mi nøjandyamba, o'ca aunque i'is mi ñchi'pa usy nø' porque mitz Cristo'is mi ñe'nda'm, viyuṉsye maṉba pyøc cyoyoja. ");
INSERT INTO zosNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","”O'ca tum yøcsepø che'pø une'is va'ṉjamba øjtzi, y tum pø'nis yajapya jic une'is vya'ṉjajmocuy, entonces jic pøn más maṉba castigatzøctøji que menos toya o'ca patztøjcøtyøjuna'ṉ nø'cø'mø vyajtøjatyøjupø møjapø vacucha cyønøcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jetcøtoya o'ca mi ṉgø'is mi ⁿyaj cojapa'tpa, tøcspø'ø. Mas vøjø tu'maṉgø'pø va'cø mi ndyøjcøy ityajumø queñajpapø, que va'cø jana mi ñdyøjcøy mi mejchaṉgø'pø yatzipø'omo, ji'n tu'yipø juctyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Jen ji'n cya'yaj namchan vyi'cyajpapø'is ca'upø, y juctyøc ji'n tu'yi nunca. ");
INSERT INTO zosNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Y o'ca mi ṉgoso'is mi yaj cojapa'tpa, tøcspø'ø. Masti vøj tu'maṉgoso va'cø mi ndyøjcøy ityajumø queñajpapø que va'cø jana mi mbyajtzøtyøj mejchaṉ goso yatzipø'omo, nunca ji'n tu'yipø juctyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Jeni ji'n cya'yaj namchan vyi'cyajpapø'is ca'yajupø, y juctyøc ji'n tu'yi nunca. ");
INSERT INTO zosNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Y o'ca mi vindø'mis mi yaj cojapa'tpa, nøputø. Mas vøjø tu'maṉ vitøm va'cø mi ndyøjcøy Dios aṉgui'mopyamø, que va'cø jana mi mbyajtzøtyøj metzaṉ vitømgø'i yatzipø'omo. ");
INSERT INTO zosNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jeni ji'n cya'yaj namchan vyi'cyajpapø'is ca'upø, y juctyøc ji'n tu'yi nunca. ");
INSERT INTO zosNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","”Porque mumu pøn maṉba vøjøtzøcyajtøj juctyøcji'ṉ, y mumu copøn yaj ca'yajupø para Dioscøtoya cana'øyupøte. ");
INSERT INTO zosNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Pero o'ca cana seque'ajpa, ja it jujche va'cø ndø yaj cana'omvøjøtzøcø. Como cana'is yac omba cu'tcuy, jetse omba ijtam mi ndøvøji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Entonces Jesús tzu'ṉu jeni y maṉ Judea nasomo, y maṉ vit Jordán nø'cøtu'maṉ. Sone pø'nis cyømiñajque'tu, y Jesusis 'yaṉmayaju sone pøn jujche ijtuse cyostumbre. ");
INSERT INTO zosNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Veneta'mbø fariseo aṉma'yocuy ñø'ijtyajupø'is nu'cyaj Jesuscø'mø. Sunbana'ṉ chøjquisyajø jujche muspa yac tocoyaj Jesús. Ñøjayaju: ―Tø tzajmatyam o'ca it aṉgui'mguy que muspa ndø tzac ndø co'tøc yomo. ");
INSERT INTO zosNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Y Jesusis 'yaṉgøva'cyajque'tuti: ―¿Jujche mi 'yaṉgui'muse Moisesis? ");
INSERT INTO zosNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Y aṉdzoṉyaju: ―Moisesis chi' pøn permiso va'cø chac yomo o'ca chi'pa yomo toto jutipøcøs it jachø'yupø que chajcu'am. ");
INSERT INTO zosNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Pero Jesusis ñøjayaju: ―Mi ⁿjyajyay jetsepø aṉgui'mguy Moisesis porque mi ne'cta'm ji'n sun mi ndzøctam vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero cuando ijtzo'tznømu'c, cuando Diosis jyomec nasacopac, Diosis chøc pøn jayapø y yomopø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Por eso pøn tzu'ṉba jyatacø'mø y myamacø'mø va'cø tyumø'om it yomoji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Y myechcø'tya'm tumø'ajyajpa. Entonces ji'ndyet metzcuy, sino tumbøtite”. ");
INSERT INTO zosNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Por eso lo que tyumøtzøjcupø Diosis, uy yac ve'ñaj pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Entonces cuando tøjcøyajque'tu tøjcomo, pø'nis 'yaṉgøva'cyaj Jesús va'cø cha'maṉvajcayajø lo que ti chamupø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesusis ñøjayaju: ―O'ca pø'nis chacpa yomo y pyøcpa eyapø, jetse cyøtzøjcøpya yomo y jetse cojapa'tpa. ");
INSERT INTO zosNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jetsetique't, o'ca yomo'is chacpa jyaya y pyøcpa eyapø pøn, cyøtzøjcøpya jyaya y jetse cojapa'tque'tpati. ");
INSERT INTO zosNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Y ñømiñaj une Jesuscø'mø va'cø pyiquisyajø Jesusis, pero pø'nis ya'inducjo'yaju va'cø jana ñømiñaj une. ");
INSERT INTO zosNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesusis isu que ya'inducyaju une va'cø jana nu'cyaj ñec ijtumø, qui'sca'u y ñøjayaj ñøtuṉdøvø: ―Yac miñaj une øjtzøcø'mø, u'yam ya'inductamu. Porque jetsepø'omo Dios aṉgui'mba. ");
INSERT INTO zosNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Viyunsye mi ndzajmatya'mbøjtzi, que o'ca aunque i'is ji'n pyøjcøchøjṉay Diosis 'yaṉgui'mguy jujche che'pø une'is pyøcøchojṉapyase, entonces ji'n mus tøjcøy je'tomo. ");
INSERT INTO zosNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Entonces Jesusis jyotzpøcyaju tumdumø une, cyot cyø' tumdumbø unecøsi y cyømasa'nøyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús tzu'ṉu, maṉ tu'ṉomo, y tum pøn joviti min poyuc Jesuscø'mø; cutcøne'c Jesusis vyi'nomo y ñøjayu: ―Vøjpø mi myaestro, ¿ti vøjø va'cø ndzøcø va'cø mba't ji'n yajepø quenguy? ");
INSERT INTO zosNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesusis ñøjayu: ―¿Ti'ajcuy mi ndø nøjapya que øtz vøjpø chøṉø? Porque ja it ni i vøjpø sino solo Diosti vøjø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mitz mi muspa jujche ijtuse aṉgui'mguy: “Uy cyøtzøjcø'yoye, uy yaj ca'oye, uy ñumi, uy syutzi, uy 'yaṉgøma'cø'yoye, cøna'tzøy mi janda y mi mama”. ");
INSERT INTO zosNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Pø'nis ñøjay Jesús: ―Myaestro, desde que une'ctzi yaj copujtøjtzi mumu yøcsepø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jicsye'c Jesusis ya'mu pøn, y syunu, y ñøjayu: ―Faltatøc tumna tiyø va'cø mi ndzøcø. Mavø ma ma'ajpø'i mumu tiyø mi nø'ijtupø, y ve'ndzi'yaj pobreta'mbø tumin lo que mi mbøcpapø, y maṉba it mi riṉguesa'ajcuy tzajpomo. Y minø; mi tø pa'tø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cuando pø'nis myan jetse, maya'u; y jetse maya'pa tzu'ṉu, porque ricoco'nipøna'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Entonces Jesús que'najvitu'u y ñøjayaj ñøtuṉdøvø: ―Peñavini maṉba tøjcøyaj ricuta'mbø Diosis cuenta'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Cuando myanyaj ñøtuṉdøvø'is jetsepø ote, maya'co'ñaju, pero Jesusis ñøjayajque'tu: ―Tøvøtya'm, peñavini tøjcøyajpa Diosis cuenta'ṉomo cyomo'papø'is que tuminji'ṉ vyø'om mase putyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Más fácil va'cø cyøt tum camello copøn acusya'is cyoji'omo, que tum rico ji'n maṉ tøjcøy Dios 'yaṉgui'mbamø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ñøtuṉdøvø más maya'yaju y na ñøjayajtøju: ―¿Entonces i muspa cyotzoca? ");
INSERT INTO zosNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesusis 'ya'myaju y ñøjayaju: ―Pø'nis ji'n mus yaj cotzocyaj vyin, pero Diosis muspa yaj cotzocyajø; porque Diosis muspa chøc mumu tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Entonces Pedro'is ñøjay Jesús: ―A'mø, øtz ndzacta'møjtzi mumu tiyø va'cø mi mba'jtamø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesusis 'yandzoṉu: ―Viyuṉsye mi ndzajmatyamba, chacyajpapø'is tyøc, 'yatzi, chøtzø, myuqui, jyata, myama, yomo, 'yuneta'm, nas para øtzcøtoya, y vøjpø otecøtoya, ");
INSERT INTO zosNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","je'is maṉba pyøjcøchoṉyaje mas vøti yøti yøṉ nasacopajcøsi. Maṉba pyøjcøchoṉyaj cien veces más lo que chacyajupø, que sea tøc, 'yatzi, chøtzø, myuqui, myama, 'yune, o nas. Pero también maṉba yacsutzøctøji. Y minbapø tiempo'omo ji'n ma yaj cyenguy nunca. ");
INSERT INTO zosNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero sone yøtita'mbø covi'najø ji'n ma 'yaṉgui'myaje, maṉba tzø'yaj aunque ipø pønse. Y lo que ni ti aṉgui'mguy ja ñø'itøpø'is yøti, jicse'c maṉba covi'najø'ajyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nømna'ṉ tyu'ṉayaj tu'ṉomo, nømna'ṉ qui'myaj Jerusalén gumgu'yomo. Jesús vindu'ṉaju y ñøtuṉdøvø maṉyaj je'taṉgø'mø. Ñøtuṉdøvø'is maṉbana'ṉ pya'tyaj na'tzpa. Y entonces Jesusis ñømaṉvøjøtzøcyaj macvøstøjcay ñøtuṉdøvø ne'ti y chajmayaju jujche maṉba yacsutzøctøj ñe'c Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ñøjayaju: ―Mi mustamba que nø tø qui'mdam Jerusalén gumgu'yomo. Øtz Pø'nis chøṉ Tyøvø, jiṉø ma'ṉbø tzi'ocuyajtøj pane covi'najø'is cyø'omda'm, y aṉgui'mguyji'n aṉmayajpapø'is cyø'omda'm. Je'tis maṉba vyø'møyaje va'cø yaj ca'tøj øjtzi, y maṉba tzi'ocuyaj øjtzi lo que ji'ndyet Israel pø'nis cyø'omda'm. ");
INSERT INTO zosNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Je'tis maṉba cøsijcayaje, y maṉba nacstochøcyaje, y ma'ṉbø cøchujchujvøyaje chujvinji'ṉ, y ma'ṉbø yaj ca'yaje; pero tu'cay jamacøsi ma'ṉbø visa'e. ");
INSERT INTO zosNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Entonces Jacobo'is y Jua'nis cyønu'cyaj Jesús. Jacobo y Juan Zebedeo'is 'yuneta'mete. Ñøjayaj Jesús: ―Maestro, su'nbøjtzi va'cø mi ndzøc øtzcøtoya lo que maṉbapø ⁿva'ctame. ");
INSERT INTO zosNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesusis ñøjayaju: ―¿Ti mi sunba va'cø ndzøc mitzcøtoyata'm? ");
INSERT INTO zosNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ñøjayaju: ―Øtz nø sundamu va'cø mi ndø yac po'cstam tum mi ndzø'ña'ṉomo y tum mi aṉna'yomo va'cø aṉgui'mdam mitzcø'mø cuando mi myøja'ṉ aṉgui'mba. ");
INSERT INTO zosNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesusis ñøjayaju: ―Ji'n mi mustam ti mi ⁿva'ctamba. ¿Muspa mi nøṉgøjtam toya como øtz maṉbase nøṉgøt toya como si fuera ji'n 'yomepø nø' va'cø ndø to'ṉø; o sea como va'cø tø yac tziṉdøj coṉña tø mujpa, jetse conñase va'cø mi ndyotyøjø? ");
INSERT INTO zosNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ñøjmayaju: ―Musta'mbøtzi. Jesusis ñøjayaju: ―Viyuṉse maṉba mi nøṉgøjtam toya como øtz ma'ṉbase nøṉgøti. ");
INSERT INTO zosNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero øtz ji'n mus ndzamø i maṉba po'cs ø ndzø'ña'ṉomo y ni ø aṉna'yomo, pero i vi'na cøpiṉyajtøju, jet maṉba yac po'csyajtøji. ");
INSERT INTO zosNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cuando eyapø majcay ñøtuṉdøvø'is myañaju, cyoraje'ajyaju Jacobo y Juan porque ticøtoya ma vya'cyaj mas aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero Jesusis vyejmiñaju mumu y ñøjayaju: ―Mitz mustamba que lo que ndø nøjatyambapø covi'najø aunque jutipø pø'nomda'm, je'is 'yaṉgui'myajpa pyøndøvø, y myøja'ṉomda'mbø'is yømoc teymøc yac maṉyajpa tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero mijtzi ji'n mus mi ndzøctam jetse. Sino o'ca aunque i'is syunba myøja'ṉomajø mijtzomda'm, tiene que va'cø chøc vyin como coyospase. ");
INSERT INTO zosNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Y o'ca aunque i'is syunba covi'najø'ajcuy, tiene que va'cø chøc nu'csocuy para mumu icøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Porque øjtzi ø ne'ṉgø Pø'nischø Tyøvø, mi'nøjtzi ji'ndyet øtz va'cø nu'csyaj o mbøndøvø, sino ø ne'ṉgø va'cø ndzøc nu'cscocuy; y va'cø ndzi'ocuyaj ø ⁿvin va'cø yaj ca'tøjø va'cø ⁿjumbutyaj vøti pøn. ");
INSERT INTO zosNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Entonces nu'cyaj Jericó cumgu'yomo y Jesús nømna'ṉ pyutyaju cumgu'yomo ñøtuṉdøvøji'ṉ, y vøti pønji'ṉ. Tu'ṉaṉvinina'ṉ po'csu tum to'tipø pøn ñøyipø'is Bartimeo, Timeo'is 'yune, nømna'ṉ tyumin va'cu. ");
INSERT INTO zosNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cuando myan yø'ṉis que Jesús Nazaret cumgupyøn nøm tyome'aju, vejtzo'tz pømi ñøjayu: ―Jesús, Davijdis mi 'yune, tø toya'ṉøyø. ");
INSERT INTO zosNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Y sone pø'nis 'yojnayaju va'cø jana vyeja, pero to'tipø pøn vej mas pømi, ñøjacye'tu: ―Davijdis mi 'yune, tø toya'nøy øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Entonces Jesús te'ndzø'yu y ñøjayaju tome ityajupø pøn: ―Ma vejay je pøn nø vyejupø. Entonces vyejayaj to'tipø pøn ñøjayaju: ―U myaya'e. Te'nchu'ṉø, nø mi ⁿ vyejayu Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","To'tipø'is pyatzpø' vingøspø tucu, tøpte'nu y cyømaṉ Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Entonces Jesusis ñøjayu: ―¿Ti sunba mijtzi va'cø ndzøc mitzcøtoya? To'tipø'is ñøjayu: ―Maestro, su'ṉbøjtzi va'cø mi ndø yac sø'ṉay ø vindøm. ");
INSERT INTO zosNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesusis ñøjayu: ―Mavø. Porque mi ndø va'ṉjajmu, jicpit mi nchojcu. Jicsye'cti sø'ṉ vyitøm, y maṉ pyat Jesús tu'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nu'cyaj tome Jerusalén gumgu'yomo, ityajumø Betfagé y Betania cumguy, tome Olivo lomacø'mø. Jeni cyø'vejyaj Jesusis metzcuy ñøtuṉdøvø va'cø chøcyaj nu'csocuy. ");
INSERT INTO zosNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ñøjayaju: ―Maṉdam che'pø cumgu'yomo tome'cam ijtumø. Cuando mi ñu'ctamba jeni, maṉba mi mba'jtam tum burro jø'mdøjupø nunca ji'n pyo'cstøjipø. Pu'pø'tamø y nømindamø yø'qui. ");
INSERT INTO zosNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Y o'ca aunque i'is mi 'yaṉgøva'ctamba ticøtoya nø mi nømaṉdam burro, nøjayø: “Porque sunba ndø Comi'is, maṉba ñu'csi. Prontoti minba yac tzac vitu'tøjque'te”. ");
INSERT INTO zosNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Maṉyaju y pya'tyaj burro jø'mdøjupø tome tum aṉdyuṉgø'mø calle'omo y pyu'pø'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Y jiṉdambø pø'nis ñøjayaju: ―¿Ti mi ndzøctamba? ¿Ti'cøtoya nø mi mbucstamu burro? ");
INSERT INTO zosNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Y 'yaṉdzoṉyaju jujche Jesusis ñøjayajuse, y jiṉ ityajupø'is chacyaju va'cø ñømaṉyaj burro. ");
INSERT INTO zosNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Y ñømiñaju Jesuscø'mø, y tyo'cøyaj tyucu burrocøsi y Jesusis pyo'csu. ");
INSERT INTO zosNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Y sone pø'nis tyo'cyaj tyucu tu'ṉomo cyøtpamø Jesús, y eyapø pø'nis quitpøcyaj cu'yu' aṉmaṉ cyotyaj tu'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nø vyi'najyajupø y nø minajupø jyøsaṉgø'mø vejtzo'chaju: ―¡Yøscøtoya Dios! Vøjø va'cø ndø vøpøpøngotzøctamø nø minupø Diosis ñøyicøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Vøjø va'cø ndø vøcotzøctam jic maṉbapø mini va'cø 'yaṉgui'mø jujche oyuse 'yaṉgui'm ndø peca jatata'm David. Vøco'nipøte møjipø Dios. ");
INSERT INTO zosNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Así que Jesús tøjcøy Jerusalén gumgu'yomo y tøjcøyque't masandøjcomo. Jen quenvijtu y 'ya'mu mumu tiyø. Y como tza'imna'ṉ, tzu'ṉu; maṉ Betania cumgu'yomo macvøstøjcay ñøtuṉdøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jyo'pit cuando tzu'ṉyaj Betania cumgu'yomo, Jesús nømna'ṉ 'yosu. ");
INSERT INTO zosNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Is ya'i higo cuy a'yøyu. Maṉu cyen me'tzay tyøm, pero ni ti ja itø, saṉ 'yaytite porque ji'ndyet higo'is 'yaṉsø'ṉomo va'cø tyø'majø. ");
INSERT INTO zosNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Entonces jicsye'c Jesusis ñøjay higo cuy: ―Uyam ni i'is mi ngyu'tay mi ndøm nunca, porque ji'n ma mi ndyø'maje. Y ñøtuṉdøvø'is myañaju. ");
INSERT INTO zosNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jicse'c nu'cyaj Jerusalén gumgu'yomo. Jesús maṉ masandøjcomo myacputputvøyaju ma'ayajpapø y ju'yoyajpapø masandøjcomo. Chi'potvitu'yaj myejsyata'm ñø ityajupø cyacpøyajpapø'is tyumin, y pyatzvitu'jayaj po'cscutya'm ñø'ityajupø mya'ajyajpapø'is paloma. ");
INSERT INTO zosNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y ya'inducyaju va'cø jana ñøcøtyaj ni tiyø masandøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Y 'yaṉmayaju: ―Viyuṉbø tiyø lo que jachø'yupøse masanbø ote'omo que it jachø'yupø: “Ø ndøc maṉba nøjayaje tøc juti 'yo'nøyajpamø Dios aunque jujta'mbø pø'nis”. Pero mijtzi nøc'ijtøtyamu masandøc como si fuera aṉgøvø'ñajpamø nu'myajpapø. ");
INSERT INTO zosNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Entonces pane covi'najø'is y aṉgui'mguyji'ṉ 'yaṉma'yoyajpapø'is myañaj tzame jujche oyuse chøqui Jesusis y chøcme'tzjo'yaju velta jujche va'cø yaj ca'yaj Jesús. Pero ña'chaju vøti pøn, porque mumu pø'nis jovise a'myaju Jesús nø 'yaṉma'yoyuse, y syuñaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pero cuando tza'i'ajnømu, Jesús tzu'ṉu cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jyo'pit namdzu cøtyaju y isyaju higo cuy que tøjtzumna'ṉ hasta vyatzi'omsye'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Entonces Pedro'is jyajmu chøjcu ñøjay Jesús: ―Maestro, a'mø higo cuy mitz mi ndzamdzi'u ca'u'am. ");
INSERT INTO zosNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesusis ñøjayaju: ―Va'ṉjamdam Dios. ");
INSERT INTO zosNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Viyuṉse mi nøjmandyamba: o'ca aunque i'is ñøjapya yøṉ cotzøc: “Tzu'ṉ jeni y tøjcøy majromo”, jetse ma tyuqui o'ca ji'n ni ti qui'psi choco'yomo. Tiene que va'cø vya'ṉjam de veras lo que chamuse maṉba tyuqui. ");
INSERT INTO zosNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Por eso mi nøjandyamba øjtzi; cuando mi o'nøndyamba Dios, o'ca mi va'ṉjamdamba que mi mbøjcøchoṉdamu'am lo que mi ⁿva'ctamupø, entonces Diosis maṉba mi ñchi'tame. ");
INSERT INTO zosNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Y cuando mi ndye'ndamba y mi o'nøndyamba Dios, yaj cøtocoyajø mi ndøvø'is aunque ti mi ñchøjcatyamu, va'cø jetsetique't yaj cøtocojay mi ṉgojata'm tzajpomo ijtupø mi Janda'is. ");
INSERT INTO zosNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero o'ca ji'n mi yaj cøtocojay mi ndøvø'is cyoja, entonces ji'n ma yaj cøtocojay mi ṉgojata'm tzajpomo ijtupø mi Janda'is. ");
INSERT INTO zosNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Entonces nu'cvøjøtzøcyajque't Jerusalén gumgu'yomo. Y cuando Jesús nømna'ṉ vyit masandøjcomo, cyømiñaju pane covi'najø'sta'm y aṉgui'mguyji'ṉ aṉma'yoyajpapø'is y tzambø'nista'm. ");
INSERT INTO zosNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","'Yaṉgøva'cyaj Jesús ñøjayaju: ―¿Jujchepø aṉgui'mguyji'ṉ mi ndzøcpa lo que mi ndzøcpase, y i'is mi nchi'u aṉgui'mguy va'cø mi ndzøc jetse? ");
INSERT INTO zosNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Y Jesusis 'yaṉdzoṉyaju; ñøjayaju: ―Øtz ma'ṉbø mi ⁿocva'ctaṉque'te a ver ti mi ndzamdamba. O'ca mi ndø aṉdzoṉdamba, entonces øtz ma'ṉba mi ndzajmatyame i'is tzi'ø aṉgui'mguy va'cø ndzøc yøcsepø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿A ver i'is chi' Juan aṉgui'mguy va'cø nø'yø'yoya? Tø tzajmatyam ndøvø o'ca Diosis chi'u o pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jicse'c nay ñø'aṉgøva'ctzo'chajtøju ñe'comda'm, nømyaju: ―O'ca tø nømdamba que Diosis chi' Juan aṉgui'mguy, je'is maṉba tø nøjatyame: “Entonces, ¿ti'ajcuy ja mi vya'ṉjamdam Juan?” ");
INSERT INTO zosNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","En cambio ji'n mus ndø aṉdzoṉdamø que pø'nisti chi'aṉgui'mguy. Porque ña'chajque't sone pønda'm, porque myusyaju que sone pø'nis vya'ṉjamyaju que Juanete viyuṉse tza'maṉvajcopapø Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Por eso ñøjayaju covi'najø'is Jesús: ―Ji'n ø mustame i'is chi' Juan aṉgui'mguy. Y Jesusis ñøjayaju: ―Pues øjtzi jetsetique't ji'nø mi ndzajmatyam i'is tzi'ø aṉgui'mguy va'cø ndzøc yøcsepø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Entonces Jesusis chamdzo'tz covi'najøta'm historia va'cø 'yaṉma'yoya; ñøjayaju: ―Ijtuna'ṉ tum pøn ñijpupø'is ñasomo tøm ñøyipø'is uva. Vye'jcøvitu' nipi, y ño'tz tza' tzica cuenta jut maṉbamø jyo'c uva'is ñø' cuando nø cyømaṉu'c va'cø pyut ñø'; chøjque't torre ye'ṉupø va'cø cye'naṉguec nipi'omo. ”Entonces chacyaj cuidatzøcyajpapø'is va'cø cyøyosyajø; y vø'nipi maṉ ya'i. ");
INSERT INTO zosNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nu'c tiempo va'cø it uva, vø'nipi'is cyø'vejyaj chøsi va'cø 'yo'nøyaj cuidatzøcyajpapø'is va'cø vye'ndzi'yaj cosecha jujche maṉbase pyøc vø'ne'is. ");
INSERT INTO zosNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Cuidatzøcyajpapø'is ñujcayaj tzøsi lo que cyø'vejyajupø vø'nipi'is, y nacstochøcyaju, y yac vitu'yaju jana ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Entonces vø'nipi'is cyø'vejque't eyapø tzøsi, pero cuidatzøcyajpapø'is pyu'ṉmacyaj tza'ji'ṉ jic menajcøs minupø. Pyu'ṉgøveñaj cyopajcøsi, tyopa'o'nøyaju, y myacnøpoyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Entonces vø'nipi'is cyø'vej vøjøtzøjque'tu tu'cañajcøsi eyapø tzøsi, y jete cuidatzøcyajpapø'is yaj ca'yaju. Y después vø'nipi'is cyø'vejyajque't eyata'mbø. Tumdum viaje vene ñacsyaju, vene yaj ca'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","”Ja itøna'ṉ más chøsi, pero ijtuna'ṉ 'yune syungo'nbapø. Jete cyø'vejque't último vø'nipi'is, nømu: “Maṉba cyøna'tzøyaj ø ⁿune”. ");
INSERT INTO zosNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero cuidatzøcyajpapø'is nañøjayajtøju: “Yøṉete mapø'is pyøjcøchoṉ uva nipi cuando ca'pa jyata como cuenta de erejencha. Tø maṉdya'i, ndø yaj ca'tya'i, y øjtzi maṉba ndø nøtzø'tyam uva nipi”. ");
INSERT INTO zosNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Entonces cuando nu'c vø'nipi'is 'yune, ñucyaju y yaj ca'yaju y pyatzpø'yaj emøc. ");
INSERT INTO zosNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesusis jetse chamu, y entonces ñøjacye'tu: ―¿Pero ti maṉba chøjcayaje vø'nipi'is? Maṉba mini y maṉba yaj ca'yaj jic pøn lo que chajcupø ma's cuidatzøcyaj nipi, y maṉba chacyajque't eyata'mbø va'cø cuidatzøcyajque'ta. ");
INSERT INTO zosNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","”Viyuṉse mi ndu'ndamu'am jachø'yupø totocøsi yø'cse nømbapø: Ijtu tum tza' ja syuñajøpø tøc tzøcyajpapø'is, Pero mismo tza' oy pivi eyapø'is va'cø yac yos tøc aṉgui'nomo, porque jen mas vøjpø tza' syunba. ");
INSERT INTO zosNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ndø Comi'is chøc yø'cse y o'ca jujchese ndø a'mdamba. Jetse cham Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Entonces covi'najø'sta'm oy ñucjo'yaj Jesús, porque cyønøctøyøyaju que Jesusis cham historia va'cø cha'mindzi que como cuidatzøcyajpapø'is yaj ca'yaj vø'nipi'is 'yune, jetse ñe' covi'najø'is ñø'ityaj mismo quipsocuy va'cø yaj ca'yaj Diosis 'yune. Pero ja ñucyaj Jesús, porque ña'chaj sone pøn. Entonces covi'najø tzu'ṉyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Covi'najø'is cyø'vejyaj Jesuscø'mø metzcuy tu'cay fariseo aṉma'yocuy ñø'ityajupø'is y metzcuy tu'cay pøn lo que syuñajpapø'is aṉgui'mbapø Herodes. Cyø'vejayaju va'cø chøjquisyajø o'ca muspa yaj quecyaj Jesús vyejvejnecucyøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Cyønu'cyaj Jesús y ñøjayaju: ―Maestro, musta'mbøjtzi que mitz viyuṉsepø ti mi ndzamba. Mitz ni ti ji'n mi ndzøjcay cuenda o'ca myøja'ṉombø pøn o cø'yipø pøn. Parejo mi nømaṉyajpa mumu pøn. Mitz viyuṉse mi 'yaṉma'yombya Diosis tyu'ṉomo. Tø tzajmatyamø o'ca vøjø o ji'n vyøjø va'cø ndø cøcoyoja lo que ti vya'cpa aṉgui'mbapø Cesajris. A ver o'ca pyena va'cø ndø cøcoyoja, o ji'ndyet pyena. ");
INSERT INTO zosNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero Jesusis myusu que qui'pscøpo'yaju jujche va'cø yaj queca, y ñøjayaju: ―¿Ti'ajcuy mi ndø tzøjquistamba? Ndø nømijnatyam tum popo tumin va'cø ⁿisø. ");
INSERT INTO zosNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ñømijnayaju y Jesusis isu, y 'yaṉgøva'cyaju, ñøjayaju: ―¿Ipø pø'nis cyopac tzøqui it tumingøsi? ¿I'is ñøyi ijtu jachø'yupø tumingøsi? 'Yaṉdzoṉyaju: ―Møja'ṉ aṉgui'mbapø Cesajris ñe'. ");
INSERT INTO zosNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Entonces Jesusis ñøjayaju: ―Por eso tzi'tam César lo que Cesajris ñe', y tzi'tam Dios lo que Diosis ñe'. Y o'ca jujchese a'myaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Entonces maṉ 'yo'nøyaj Jesús metzcuy tu'cay saduceo va'ṉjajmocuy ñø'ijtupø'is. Jet nømyajpa que ca'yajupø ji'n visa'yaje. Ji'quis 'yaṉgøva'cyaj Jesús, ñøjayaju: ");
INSERT INTO zosNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, Moisesis jayutzajcatya'møjtzi que o'ca ca'pa tum pøn y chacpa yomo, pero ja it 'yune, entonces myuqui'is tiene que va'cø ñøco'tøjcaj yomo va'cø ityaj 'yune por cuenta 'yatzi'is ñe'. Jetse jyay Moisesis. ");
INSERT INTO zosNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bueno, cu'yayna'ṉ it tumbø pø'nis 'yune. Vi'na pønbø oy co'tøjcaje y ca'u ja chac une. ");
INSERT INTO zosNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Entonces metzcupyø myuqui'is ñøco'tøjcajacye't 'yatzi'is yomo, y ca'que'tuti ja ñø'une'øcye'tati yomo. Tu'ca'yombø jøsi'cam jetseti tujque'tu. ");
INSERT INTO zosNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jetse cu'yay cø'yitya'm pyøcjo' pyøcjo'yajpana'ṉ mismo yomo, y ni jutipø'is ja chac une. Jøsi'cam ca'que'tuti yomo. ");
INSERT INTO zosNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jetse chamyaju entonces 'yaṉgøva'cyaj Jesús: ―Entonces cuando visa'yajque'tpa ca'yajupø, ¿jutipø pø'nis maṉba ñø'it je yomo? Como cu'yacyø'yita'm oy ñøco'tøjcajyaj mismo tumbø yomo. ");
INSERT INTO zosNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Entonces Jesusis ñøjayaju: ―Mitz ji'n mi ṉgui'pstam vøjø porque ji'n mi ṉgøñøctøyøtyam jachø'yupø Diosis 'yote, ni ji'n mi ṉgøñøctøyøtyame jujche muspa chøc Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Porque cuando visa'nømba, ji'nam ma cyo'tøjcajnømi, ni ji'nam ma nachi'yajtøj 'yune va'cø co'tøjcajyajø. Pero maṉba ityaj jujche tzajpomda'mbø angeles ityajpase. ");
INSERT INTO zosNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero o'ca mi ndø aṉgøva'ctamba o'ca visa'yajpa ca'yajupø, maṉba mi ndza'maṉvajcatyame lo que mi ndu'ndamu'am libru'omo lo que Moisesis jyayupø, juti chambamø que nemde'n che'pø cu'yomo. Nømba jeni que Diosis ñøjay Moisés: “Øjchøṉø Dios. Øtz va'ṉjambøjtzi Abraha'mis y Isaajquis y Jacojbis”. ");
INSERT INTO zosNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","(Entonces queñajpa jicta'm) porque ca'yajupø'is ji'n vya'ṉjamyaj Dios sino queñajpapø'is vya'ṉjamyajpa. Por eso ji'n vyøj mi ṉgui'psotyame. ");
INSERT INTO zosNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ijtuna'ṉ jeni tum aṉgui'mguji'ṉ aṉma'yopyapø. Je'is myanu jujche vejvejneyaju, y qui'psu o'ca Jesusis nø 'yaṉdzo'ṉoy vøjø. Entonces cyøminu Jesús y ñøjayu: ―¿A ver jutipø aṉgui'mocuy lo que chi'upø Diosis más covi'najøpø? ");
INSERT INTO zosNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesusis ñøjayu: ―Yøṉømete mas covi'najøpø aṉgui'mocuy: “Cøma'nøtyam Israel pønda'm: ndø Comi Dios, jicømete tumbøti ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Sunø ndø Comi Dios mi ndumø tzocoy, mi ndumø anima, mi ndumø qui'psocuy, y cøyosøy Dios mumu mi mbømiji'ṉ”. Jic aṉgui'mocuy mas møjapøte. ");
INSERT INTO zosNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","It eyapø aṉgui'mocuy jetseti møjaque't: “Sunø mi ndøvø jujche mi sunbase mi ⁿvin”. Yøṉø aṉgui'mocuy mas møjata'mbø que ji'n eyata'mbø. ");
INSERT INTO zosNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Entonces aṉgui'mguyji'n aṉma'yopyapø pø'nis ñøjay Jesús: ―Vøjti mi aṉdzoṉu, Maestro, viyuṉ mi nchamu que tumdi it Dios, y ja itø eyapø; jejtite. ");
INSERT INTO zosNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Y va'cø ndø sunø Dios ndø ndumø tzocoy, y ndø ndumø qui'psocuy, y va'cø ndø ngøyosøy Dios mumu ndø mbømiji'ṉ, y va'cø ndø sunø ndø tøvø jujche ndø sunbase ndø ⁿvin, jetse mas vøjø que menos mumu copøn va'cø ndø pojṉay para Dioscøtoya, y aunque tiyø va'cø ndø tzi' Dios. ");
INSERT INTO zosNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Entonces cuando is Jesusis que vøj 'yaṉdzoṉu, ñøjayu: ―Mijtzi usyti falta va'cø mi ndyøjcøy Diosis cuenta'ṉomo. Y mumu na'chaju va'cø 'yaṉgøva'ca'ṉøyaj Jesús aunque tiyø va'cø yaj quecyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús nømna'ṉ 'yanma'yoy masandøjcomo y nømu: ―¿Ticøtoya nømyajpa aṉgui'mguji'ṉ aṉma'yoyajpapø que Cristo Davijdis 'yunete? ");
INSERT INTO zosNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Porque ñe'c David chi' qui'psocuy Masanbø Espiritu Santo'is va'cø ñømø: Ndø Janda Diosis ñøjay ø Ṉgomi: “Po'csa yø'qui ø ndzø'ña'ṉomo, ø møja'ṉajcu'yomo. Hasta que øtz maṉba mi yaj cønu'cøjayaj mi enemigota'm”. ");
INSERT INTO zosNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Pero como ñe'c David nømba que ndø Comi je'isti Cyomique't, ¿jujche ndø nøjatyamø que ndø Comi Davijdis 'yunete? Porque o'ca Davijdis Cyomi, ji'n mus tø nømø que Davijdis 'yune porque Cyomite. Y soneta'mbø pø'nis cyøma'nøyaj Jesús y casøyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús aṉma'yoyu y ñøjayaju: ―Ndzøctam cuenda aṉgui'mguyji'ṉ 'yaṉma'yoyajpapø, lo que sunba vityaj pøjipø tucu myesyajupø, y sunba va'cø yuschi'yajtøjø como myøja'ṉombø pønse plaza'omo. ");
INSERT INTO zosNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Y cuando tu'myajpa, sunba pyo'csyaj mas møja'ṉomda'mbø pøn pyo'csyajpamø. Y cuando itpa søṉgu'tcuy, sunba pyo'csyaj mas mø'ja'ṉombø pøn pyo'csyajpamø. ");
INSERT INTO zosNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yac tzu'ṉayajpa yaṉbac yomo'is tyøc; entonces chøcyajpa conocscuy ya'pyapø va'cø ijtyaj como que si fuera va'ṉjajmoyajpase. Por eso mas maṉba cyastigatzøcyajtøji. ");
INSERT INTO zosNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Y Jesús pocs masandøjcomo tome ijtumø cofre cyotyajpamø tumin. Jesusis 'ya'mu nø cyotyaju'is tumin caja'omo y sone ricuta'mbø'is cyotyaj vøti tumin. ");
INSERT INTO zosNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Entonces min tum pobrepø yaṉbac yomo, je'is cyot caja'omo metzcuy namdumin ji'n vyaletzøquipø ni tum quinto. ");
INSERT INTO zosNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesusis vyejtu'myaj ñøtuṉdøvø y ñøjayaju: ―Viyuṉse mi nøjandyamba: lo que yøṉø pobrepø yaṉbajquis cyot caja'omo, más valetzøcpa que ji'n mumu eyata'mbø'is cyotyajuse caja'omo. ");
INSERT INTO zosNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porque mumu eyata'mbø'is cyotyaju lo que sobratzøcyajupø, pero yøṉ yaṉbajquis, pobre'ajcu'yomo cyot mumu lo que ñø'ijtupø, tipi'jna'ṉ maṉba cu'ti. Vøpø ti chøjcu. ");
INSERT INTO zosNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cuando Jesús pujtu masandøjcomo, tum ñøtuṉdøvø'is ñøjayu: ―Maestro, a'mø jujche møjata'mbø y suñita'mbø tza' it yøṉ masandøjquis ñe', y jujche suñi queñajpa yøṉ tøcta'm. ");
INSERT INTO zosNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Pero Jesusis ñøjayu: ―A'm yøṉ møjata'mbø tøc. Mumu maṉba yajyaje; ji'n ma chø'y ni tum tza' ne'csca'mupø cha'tøvøcøsi, maṉba ju'mbø'i nama nama. ");
INSERT INTO zosNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Entonces maṉyaj Olivo lomacøsi y masandøc met quetzacøtu'møṉ ijtuna'ṉ. Y Jesús po'cs jeni. Entonces Pedro'is y Jacobo'is y Jua'nis y Andresis ne'ti ñøjayaj Jesús: ");
INSERT INTO zosNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Tø tzajmatyam ndøvø: ¿jujchøc maṉba tucnøm mi ndzamuse? ¿Ti'is maṉba cyotzame que nøm ñuc ora? ");
INSERT INTO zosNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesusis ñøjayaju: ―Tzøctam cuenda ni i'is jana mi 'yaṉgøma'cøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Porque maṉba miñaj sone pøn por cuenta øjtzi y maṉba nømyaje: “Øjchømøṉ Cristo”. Jetse maṉba 'yaṉgøma'cøyaj sone pøn. ");
INSERT INTO zosNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","”Pero cuando mi manba quipcuy y manba que it quipcuy emøc, uy jujchese mi ndyuctamu. Porque tiene que va'cø tyuc jetse vi'na. Pero ji'ndøc ma yajnømi. ");
INSERT INTO zosNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Porque cumguy pø'nis maṉba ñøquipyaj eyaco cumgu'yom tzu'ṉyajpapø, y gobierno'is maṉba ñøquipyaj eyapø gobierno. Maṉba it nasamicscø, maṉba it yu' aunque juti. Maṉba so'natejyaj pønda'm. Jetse maṉba ischo'chaj toya, pero jøsicam más maṉba isyaj toya. ");
INSERT INTO zosNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","”Pero cuendatzøctam mi ⁿvin porque maṉba mi ñuctandøji, maṉba mi nømaṉdandøji jutø tu'myajpamø aṉgui'myajpapø, y maṉba mi ñacstandøji conocscutyøjcomo. Y maṉba mi ñømaṉdandøji aṉgui'mbapø'is vyi'nomda'm y møja'ṉ aṉgui'mbapø'is vyi'nomda'm mi ndø va'ṉjamdamu aṉcø. Jetse maṉba mi mus ndzamdam ti mi va'ṉjajmoṉgutya'm. ");
INSERT INTO zosNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Y antes que maṉba yajnømi, tiene que va'cø chamsajtøj vi'nati vøjpø ote mumu cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pero cuando mi ñømaṉdandøjpa va'cø mi ñchi'ocuyajtandøj aṉgui'mbapøcø'mø, u maṉ mi maya'ndamu ti maṉba mi ndzamdame. U maṉ mi ṉgui'pstamu ni tiyø; porque misma hora maṉba mi ñchi'tandøji qui'psocuy jujche va'cø mi 'yaṉdzo'ṉotyamø. Y jetse tzamdamø jujche mi nchi'tandøjpase qui'psocuy. Porque ji'ndyet mijtzi nø ndzamdamupø, sino Masanbø Espiritu Santo'is mi ñchi'tamuse qui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Y ji'n vya'ṉjamepø pø'nis maṉba chi'ocuyaj mismo tyøvø sea 'yatzi o myuqui va'cø yaj ca'tøjø. Jetsetique't jata'is maṉba chi'ocuyaj 'yune, y une'sta'm maṉba qui'sayaj mismo jyata y myama, y maṉba chi'ocuyajyaje va'cø yaj ca'yajtøjø. ");
INSERT INTO zosNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Y mumu pø'nis maṉba mi ṉqui'satyame porque mi ndø va'ṉjamdamba aṉcø. Pero o'ca mi ndondamba hasta que mi nøṉgøjtamba toya, maṉba mi ṉgyotzoctame. ");
INSERT INTO zosNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","”Tza'maṉvajcopapø Daniejlis jyayu que maṉba it møsyaṉbø tiyø. Je'is maṉba yajpø'yaj aunque tiyø. Cuando mi istamba jetsepø jut ji'n musimø itø―mi ndu'nbapø'is yønø, ay que va'cø mi ṉgønøctøyøy ti ndzamba―, entonces Judea nasomo ityajupø hay que va'cø pyoyajø, va'cø cotzøjcø'mda'm myaṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","O'ca tøjcøcopajcomo ijtu, cuando mø'nba va'cø pyoya, hay que va'cø pyoy tumnajcøsi, porque ji'n ma it tiempo va'cø tøjcøy tyøjcomo va'cø ñøput aunque tiyø. ");
INSERT INTO zosNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Y tza'momo nø yosupø mas vøjø va'cø pyotyucø, va'cø jana vyitu'ø tyøcmø va'cø mye'tz tyucu. ");
INSERT INTO zosNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pero jic jama vøti maṉba toya'isyaj yomo maṉbapø'is isyaj 'yune y yac tzu'tzpapø'is 'yune. ");
INSERT INTO zosNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Va'ctam Dioscøsi que va'cø jana tuc jetse pacac aṉsø'ṉomo va'cø jana mi mbyotyam pacac aṉsø'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porque jic jama'cøsi maṉba it toya'iscuy lo que nuncatøc ja 'yoyapø desde que cho'tzucsye'ṉomo nasacopac, cuando Diosis jyomec mumu tiyø. Ni ji'nam ma itque't jetsepø toya'iscuy nuṉcacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","O'ca ji'na'ṉ yaj toya'iscuy Diosis, ca'pana'ṉ mumu pøn. Pero Diosis maṉba yaj toya'iscuy porque tyoya'ṉøpya pøn lo que cyøpiṉyajupø. ");
INSERT INTO zosNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","”Y o'ca jicsye'c aunque i'is mi ñøjandyamba: “A'mø: yø'c it Cristo”, o o'ca mi ñøjandyamba: “Jendi ijtu”, Uy mi va'ṉjamdamu. ");
INSERT INTO zosNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Porque maṉba miñaj aṉgøma'cø'oyajpapø, maṉba chøcyaj vyin como si fuera Cristo, maṉba nømyaje: “Øjchøṉø tza'maṉvajcopapø”. Maṉba chøcyaj ji'n ndø isipø tiyø y milagro'ajcuy va'cø 'yaṉgøma'cø'isyajø pøn lo que Diosis cyøpiṉyajupø, a ver o'ca vya'ṉjamyajpa. ");
INSERT INTO zosNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero mitzta'm tzøctam cuenda øtz mi ndzajmatyamuse jujche ma tucnømi. ");
INSERT INTO zosNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","”Pero jicø jama'cøsi, cøjtu'cam møja'ṉ doya'iscuy, jama maṉba tu'i y poya ji'n ma syø'ṉi. ");
INSERT INTO zosNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Matza maṉba quecyaj nasomo y tzajpomo ityaju'is pyømi maṉba micsyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Entonces maṉba isyaj øjtzi Pø'nis chøṉ Tyøvø. Øtz ma'ṉbø min o'na'cøsi pømi'øcyo'nupø y møja'ṉ sø'ṉbapø. ");
INSERT INTO zosNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Entonces øtz ma'ṉbø ṉgø'vejyajø angeles aunque juti va'cø yac tu'mayaj pønda'm øtz ṉgøpiṉyajupø. Maṉba ñømiñaj aunque jut ityajupø nasacopajcøsi, maṉba tzu'ṉyaj más ya'i ispapø nasomo, y hasta más ya'i ispapø tzajpomo. ");
INSERT INTO zosNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","A'mdamø jujche higo cuy tucpase, jetse muspa mi aṉmañdyamø. Cuando yo'ca'ajyajpa 'yaṉmaṉ y a'yøpya, entonces mi mustamba que ya mero maṉba ja'maṉsø'ṉajnømi. ");
INSERT INTO zosNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jetsetique't, cuando mi istamba que nø tyucnømu øtz ndzamuse, jetse maṉba mi mustame que ya mero nu'cu'am ora. ");
INSERT INTO zosNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Viyuṉse ni nøjandyamba, mumu øtz ndzamuse maṉba tucnømi antes que ca'pø'yajpa yøti ityajupø pøn. ");
INSERT INTO zosNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tzap y nas maṉba yaje, pero øtz nø ndzamuse ji'n ma cøyaje nunca. ");
INSERT INTO zosNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","”Pero jujchøc y jutipø ora øtz ma'ṉbø mini, ni i'is ji'n myusi, ni aṉgelesis tzajpomo ityajupø'is, ni øjtzi Diosis 'Yune ji'nø musi, namas ndø Janda'is myuspa. ");
INSERT INTO zosNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","”Por eso cø'aṉjamdamø, u cø'øṉdame, y o'nøtyam Dios; porque ji'n mi mustame jujchøc maṉba nu'c hora. ");
INSERT INTO zosNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Maṉba tuqui como tucpase cuando tum pøn vitpa ya'i. Antes que tzu'ṉba tyøcmø, yaṉgui'mu tzacyajpa chøsita'm tiyø yoscuy maṉba chøcyaj tumdumbø'is. Y 'yaṉgui'mu tzacpa aṉdyuṉ cyoquenbapø'is va'cø cyøquena. ");
INSERT INTO zosNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jetseti mitzta'mque't u mi 'yøṉdamu. Porque como cyoquenbapø'is aṉdyuṉ ji'n mus tiyø hora maṉba nu'qui vø'tøc; jetsetique't ji'n mi mustame tiyø hora maṉba min øjtzi; o'ca tzu'ijcam, o'ca cuctzu, o'ca nø vyeju'c gaylu, o'ca nø syø'ṉbø'nømu'øc. ");
INSERT INTO zosNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Vøj coquendamø, u 'yøṉdame, va'cø jana mi mbya'jtam øṉupø o'ca jovise minba vø'tøc. ");
INSERT INTO zosNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Y jujche mi ndzajmatya'mbø mitzta'm, jetseti ndzajmayajque'tpøjtzi aunque iyø: jo'ctamø, u mi 'yøṉdamu. ");
INSERT INTO zosNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Faltatøcna'ṉ metza jama va'c it søṉ ñøyipø'is pascua cuando cyø'syajpana'ṉ pan ja pyoṉoṉapø. Y pane covi'najø'sta'm y aṉgui'muyji'ṉ aṉma'yoyajpapø pø'nis chøcme'chajpana'ṉ jujche va'cø 'yaṉgøma'cøyaj Jesús va'cø mus ñucyajø y yaj ca'yajø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero nømyajpana'ṉ: ―Uy ndyø nucta'i søṉ jama'omo utim cyoquipyaj vøti pø'nis, uytim so'natejyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús ijtuna'ṉ Betania cumgu'yomo. Jena'ṉ it tum pøn yachputzi'øyupøna'ṉ ñøyipø'is Simón, je'is tyøcmø Jesús nømna'ṉ pyo'csu mesa'omo. Cyønu'cu tum yomo'is ñø'ijtupø'is tum cojtocuy alabastro tza'pø. Cojtocu'yomo ijtunaṉ aceite suñi viquicpapø nøyipø'is nardo, pero mero vøjpø y caro coyojapø. Yomo'is vyen cyojtocuy y cyøtijtøjay Jesusis cyopac aceite perfumepøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Veneta'mbø pøn jiṉ ityajupø qui'syca'yaju, na ñøjayajtøju: ―¿Ti'ajcuy suniti yac tocoy aceite perfumepø? ");
INSERT INTO zosNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Porque muspapøna'ṉ mya'ajø como tres mil pesocøsi va'cø chi'yaj tumin pobreta'mbø. Y 'yojnayaju yomo vene pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero Jesusis ñøjayaju: ―Tzactam yøṉ yomo. ¿Ti'ajcuy mi molestatzøctamba? Vøjpø ti chøc øtzcøtoya. ");
INSERT INTO zosNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pobreta'm mumu jama ityajpa mitzji'ṉdam; y cuando sunba, muspa mi ayudatzøctamø; pero øjtzi ji'ṉ ma it mumu jama mitzji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yøṉ yomo'is chøjcu lo que myuspa'csye'ṉomo. Jajsa'yø ø ṉgoṉña vi'na va'cø vøjøtzøcø va'cø niptøjø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Viyuṉse mi ndzajmatya'mbøjtzi que aunque jut nasindumø chamnøvityajpa vøjpø ote, maṉba chamyajque't ti chøc yøṉ yomo'is va'cø jyajmuchøcyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Entonces tum macvøstøjcapyø nøtuṉdøvø ñøyipø'is Judas Iscariote; je'is cyømaṉyaj pane covi'najøta'm y vyinbøjayaju va'cø chi'ocuyaj Jesús je'is cyø'omda'm. ");
INSERT INTO zosNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cuando myañaj ti nø chamupø Judasis, pane covi'najøta'm casøyaju, y vyinbøjayaj tumin. Y Judasis quipscøpo'u jujche va'cø chi'ocuyaj Jesús jetcøsta'm. ");
INSERT INTO zosNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Søṉdzo'tzcu jyama'omo cuando cyø'syajpa pan ja pyoṉoṉapø y yaj ca'yajpa borrego va'cø cyotzøcyajø, ñøtuṉdøvø'is ñøjayaj Jesús: ―¿Jut sunba mijtzi va'cø maṉ vøjøndzøctam pascua søṉgu'tcuy? ");
INSERT INTO zosNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Entonces Jesusis cyø'vejyaj metzcuy ñøtuṉdøvø, ñøjayaju: ―Maṉdyam cumgu'yomo. Jeni maṉba mi ndzoṉdam tum pøn nø ñømaṉupø'is tum majcuy nø'. Ma pa'jtamø jicø pøn. ");
INSERT INTO zosNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Y jut tøjcøpyamø jicø, jiṉ mi ñøjandyamba vø'tøc: “Yø'c mi ṉgø'vejay Maestro'is ote mi ñøjambya: ¿Jut it cuarto maṉbamø ṉgu't pascua søngu'tcuy ø nønduṉdøvøji'ṉ?” ");
INSERT INTO zosNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Vø'tøjquis maṉba mi isindzi'tam møjapø cuarto møjipø; jiṉ vøjøtzøctamø va'cø tø cu'jtamø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nøtuṉdøvø maṉyaju y nu'cyaju cumgu'yomo y jen pya'tyaju jujche chajmayajuse Jesusis. Y vyøjøtzøcyaju pascua søṉgu'tcuy. ");
INSERT INTO zosNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cuando tzu'i'ajnømu'cam, Jesús nu'cyaju macvøstøjcay ñøtuṉdøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Y cuando nømna'ṉ cyu'tyaju mesa'omo, Jesusis ñøjayaju: ―Viyuṉse mi nøjayndya'mbøjtzi que maṉba put tum pøn mijtzomda'm nø cyu'tupø øtzji'ṉ maṉbapø'is tzi'ocuyaje ø enemigocøsta'm. ");
INSERT INTO zosNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jicsye'c maya'yaju y 'yaṉgøva'cyaj Jesús tumdum pø'nis ñøjayaju: ―¿Será que øjchøṉø? Y eyapø nømgue'tu: ―¿Será que øjchøṉø? Jetse nømyaju mumu. ");
INSERT INTO zosNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesusis ñøjayaju: ―Macvøstøjcay pø'nomo tum maṉba puti cu'tpapø øtzji'ṉ tumbø tzima'omo, je'is maṉbø tzi'ocu'yaje. ");
INSERT INTO zosNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Viyunse øjtzi Pø'nis chøṉ Tyøvø ma'ṉbø ca'e jujche jachø'yuse totocøsi. Pero algo maṉba toya'is jic pøn maṉbapø'is tzi'ocuyaje. Mastina'ṉ vyøjom putpa jic pøn oca ja pyø'najøna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mientras nømna'ṉ cyu'tyaju, Jesusis pyøc pan, ñøjmay yøscøtoya Dios, vye'ndzi'yaju, y ñøjayaju: ―Pøctamø; yøṉømete øjchøṉ sis. ");
INSERT INTO zosNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Entonces pyøc vaso ñøjayu yøscøtoya Dios, y chi'yaju, y tyo'ṉve'ñaju. ");
INSERT INTO zosNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Y Jesusis ñøjayaju: ―Yøṉømete ø nø'mbin. Maṉba jø't put ø nø'mbin vøti pøngøtoya. Ø nø'mbin señate que Diosis chøjcu jomepø contrato. ");
INSERT INTO zosNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Viyuṉse mi nøjandyamba, øtz ji'n ma ndo'ṉque't uva'is ñø' hasta je jama ndo'ṉba Dios 'yaṉgui'mbamø. Jicse'c ma'ṉbø ndo'ṉe jomepø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Vyañaju tum vane y tzu'ṉyaju Olivo cotzøjcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Entonces Jesusis ñøjayaju ñøtuṉdøvø: ―Mumu mitzta'm maṉba jujchese ndyuctame yøṉø tzu'cøsi cuando mi istamba jujche nøtzøcyajuse øjtzi. Porque it jachø'yuse Diosis 'yote que Dios nømu: “Ma'ṉbø ⁿyaj ca' øjtzi jicø pøn lo que cyoquenbapø'is borrego y borrego maṉba potyocoyaje”. Jetse Dios nømu y jetseti mitz maṉba mi mbyotyocotyaṉgue'te. ");
INSERT INTO zosNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero visa'u'cam øjtzi, ma'ṉbø vi'na maṉ Galilea nasomo. Y mitz maṉba myaṉdam jøsi'jcam. ");
INSERT INTO zosNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Entonces Pedro'is ñøjayu: ―Aunque mumu eyata'mbø'is mi mbyochacpø'yajpa, øtz ji'n ø mi mbyochac nunca. ");
INSERT INTO zosNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesusis ñøjayu: ―Viyuṉsye mi nøjambøjtzi: yøṉ mismo tzu'cøsi, antes que menac vejpa ṉgaylu, maṉba mi ñømi tu'cay nac que ji'n mi ndø comusi. ");
INSERT INTO zosNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero Pedro'is ñøjayu vøti nac: ―Aunque ca'pa mitzji'ṉ, nunca ji'n ma nømi que ji'n ø mi ṉgomusi. Jetseti nømyajque't mumu ñøtundøvø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Entonces nu'cyaj tum lugajromo ñøjayajpamø Getsemaní, y Jesusis ñøjayaj ñøtuṉdøvø: ―Po'cstam yø'qui, mientras øtz ma'ṉbø o'nøy Dios. ");
INSERT INTO zosNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jesusis ñømaṉyaj Pedro y Jacobo y Juan usy tu'maṉ. Jesús ñøcøtzo'tzu va'cø ña'tzco'na y va'cø tzocotyocyomø'nu maya'cu'is. ");
INSERT INTO zosNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ñøjayaj tu'capyø ñøtuṉ: ―Nø myaya'co'nu ø ndzocoy como maṉbase ca'e. Tzø'tyam yø'qui, y jana co'øṉguy ijtamø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Entonces Jesús maṉaṉøyu usyi y mucsquec najsomo y 'yo'nøy Dios a ver o'ca muspa yaj cotzoca, va'cø jana ñøcøt toya lo que maṉbana'ṉ ñøcøt jic ora. ");
INSERT INTO zosNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ñøjayu: ―Abba, Jatay; muspa mi ndzøc mitz mumu tiyø. Tø yac tzø'y libre va'cø jana nøṉgøt yøṉø toya. Pero u mi yac tucø øtz sunbase, sino va'cø mi yac tuc mitz sunbase. ");
INSERT INTO zosNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Entonces vitu'u y pya'tyaj tu'capyø ñøtuṉ øṉyajupø y ñøjay Pedro: ―¿Ti'ajcuy nø mi 'yøṉu? ¿Ja mus mi ṉgyena ni tum hora? ");
INSERT INTO zosNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jana co'øṉguy ijtamø y o'nøtyam Dios va'cø jana mi ṉgyojapa'jtamø. Viyuṉsye mi ndzoco'yomo sunba mi ṉgyendamø, pero mi sista'm mochi. ");
INSERT INTO zosNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Entonces Jesús maṉgue'tu y 'yo'nøcye't Dios mismo oteji'ṉ jujche 'yo'nøyuse vi'na. ");
INSERT INTO zosNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Y minu y øṉupø pya'tyajque'tu tu'capyø ñøtuṉdøvø, porque nømna'ṉ 'yøṉgo'ñajto'u. Y ji'na'ṉ myusyaje jujche va'cø 'yaṉdzoṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Cuando Jesús mingue'tu tu'cay najcøsi, ñøjayaju: ―Yøti jø'ø. Øṉdyamø y sapøctamø. Nu'cu'am hora, øtz mumu Pønis chøṉ Tyøvø nø tzi'ocuyajtøju cojapa'tyajupø pø'nis cyø'omda'm. ");
INSERT INTO zosNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Te'ñchu'ṉdamø, tø maṉdya'i. Jicø nø min maṉbapø'is ø tzi'ocuyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nømdøcna'ṉ cham Jesusis cuando nu'c Judas. Jesusis ñøtuṉdøvø tucyaj macvøstøjcay Judasji'n. Judasji'ṉ miñajque't vøti pøn espadaji'ṉ y cuji'ṉ cyø'vejyajupø pane covi'najø'sta'm, y aṉgui'mguji'ṉ aṉma'yoyajpapø pø'nis, y tzambø'nista'm. ");
INSERT INTO zosNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Chi'ocuyajupø'is oyuna'ṉ chajmayaj jujche va'cø myusyajø jutipø va'cø ñucyajø, oyumna'ṉ ñøjayaje: ―Jutipø ma'ṉbø su'qui, jete ma mi nuctame y nømaṉdame. A'mdamø va'cø jana pyoya. Jetse ñøjayaju. ");
INSERT INTO zosNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Y cuando nu'cu, Judasis cyønu'cu tome Jesús y ñøjayu: ―Maestro, Maestro. Y syu'cu. ");
INSERT INTO zosNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jicsye'c pø'nista'm ñucyaju Jesús va'cø ñømaṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero tum pøn jen ijtupø'is ñøput 'yespada, y che'tzcajpøjay pane covi'najø'is ñu'cscu'is tyatzøc. ");
INSERT INTO zosNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Entonces Jesusis ñøjayaju sone pøn: ―¿Ti'ajcuy mi mindamu espadaji'ṉ y cuyji'ṉ va'cø mi ndø nuctamø, como nucyajpase nu'mba pøn? ");
INSERT INTO zosNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tumdum jama itpana'ṉ øtz mitzji'ṉda'm, nømna'ṉ ø aṉma'yoy masandøjcomo, y nunca ja mi ndø nuctamø. Pero yøcse nø mi ndø nuctamu va'cø viyuṉaj lo que ijtuse jachø'yupø Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jicsye'c mumu ñøtuṉdøvø'is pyochacyaju Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tum soca'is nømna'ṉ pya't Jesús. Tum sabanaji'ṉ vyo'tupø vyin, y ñucjo'yaj tyucucøs pø'nista'm. ");
INSERT INTO zosNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero soca'is chac tyucu y poy jana tucu. ");
INSERT INTO zosNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Entonces ñømaṉyaj Jesús pane covi'najøcø'mø. Y mumu pane covi'najøta'm y tzambønda'm y aṉma'yoyajpapø aṉgui'mguyji'ṉ tu'myaju. ");
INSERT INTO zosNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro'is maṉ pya'tjo'y Jesús, pero ya'i ispa. Tøjcøy Pedro pane covi'najø'is tøjøcø'mø solajromo y po'cschø'y soldadoji'ṉ nømna'ṉ syamyaj juctyøjcaṉvini. ");
INSERT INTO zosNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pane covi'ṉajø'sta'm y mumu aṉgui'myajpapø'is cyøme'chaju i'is muspa cham viyuṉsye que it Jesusis cyoja. Sunbana'ṉ chøjcayaj cyoja va'cø yaj ca'yajø. Pero ni tiyø cyoja ja pya'tayajø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Porque soneta'mbø'is cyøsujtzøyaj Jesús, pero ja tumbø ti chamyaj parejo. Eyapø'is eya chamu y eyapø'is eyati chamu. ");
INSERT INTO zosNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jicsye'c te'ṉchuṉyaju metzcuy tu'cay pøn maṉbapø'is cyøsujtzøyaje Jesús, nømyaju: ");
INSERT INTO zosNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Manda'møjtzi yøṉ pøn nø ñømupø: “Ma'ṉbø ⁿyaj yøṉ masandøc pø'nis cyø'ji'ṉ chøcyajupø y tu'cay jamapit maṉba ndzøjque't eyapø ji'n pø'nis cyø'ji'ṉ chøcyajepø”. ");
INSERT INTO zosNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero ni jetse ja pyarejo chamyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Entonces pane covi'najø te'nu pøngujcomo y ñøjayu Jesús: ―¿Ti'ajcuy ji'n mi 'yaṉdzo'ṉoye? ¿Jujche mi 'yaṉdzo'ṉopya que jujche mi ṉgyøtza'møyaju? ");
INSERT INTO zosNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero Jesús ni jujche ja 'yoteputø. Pane covi'najø'is 'yaṉgøva'jque'tu: ―Tø tzajmayø o'ca mijtzete Cristo, o'ca vøjpø Diosis mi 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Y Jesusis ñøjayu: ―Øjchøṉø, y maṉba mi ndø istam øjtzi Pø'nis chøṉ Tyøvø Pømi'øyupø'is chø'na'ṉomo po'cspamø más aṉgui'mbapø. Y maṉba mi ndø istaṉque'te nø minupø tzajpacujqui o'na'cøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Entonces pane covi'najø'is chitz tyucu corajepit y nømu: ―¿Ti'ajcuy maṉba ndø metztam más cyøtza'møyajpapø'is? ");
INSERT INTO zosNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mitzta'm o mi mandame jujche yach onu porque Diose cyomo'pya vyin. ¿Ti mi ndzamdamba? Y mumu chøjcayaj cyoja. Nømyaju que vøjø va'cø yaj ca'tøjø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Entonces vene pø'nis ñøcøtzo'chaju va'cø cyøchujchujvøyaj Jesús chujvinji'ṉ y vyinmoñaju y chaṉyaju, entonces ñøjayaju: ―¡Tzamø i'is nø mi nchaṉu! Y policia'sta'm vyi'nøc chaṉchaṉvøyaju. ");
INSERT INTO zosNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro cø'yi ijtu tøjøcø'mø cuando nu'c tum coyomo pane covi'najøpø'is tyøjcom yospapø. ");
INSERT INTO zosNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Cuando je'is isu Pedro nø syamupø, 'ya'maṉga'u y ñøjayu: ―Mitz también tu'mbac mi ⁿvyitpana'ṉ jic Jesús Nazaret cumgupyønji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero Pedro'is ja vya'ṉjajmø, ñøjayu: ―Ji'nø musi ni ji'n ø ṉgøñøtøyøyi nø mi ndzamupø. Y Pedro pujtu y te'nu tome aṉdyuṉgø'mø; y veju gaylu. ");
INSERT INTO zosNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Y coyomo'is isque'tu y ñøjayaju pøn tome te'ñajupø: ―Yøṉømete jic pø'nis ñøtuṉdøvøque't. ");
INSERT INTO zosNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero Pedro'is ñøjacye'tu que ji'ndyet jicø. Y jøsi'cam jen ityajupø'is ñøjayajque't Pedro: ―Viyuṉete mijtzi jic pø'nis ñøtuṉdøvøque't, porque mitz Galilea nasombøte. Porque mi ondecøsi musta'mbøjtzi que mitz jiṉbøte. ");
INSERT INTO zosNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pero Pedro'is ñøcøtzo'tzu va'cø chambøjcay Dios ñøyi, nømu: ―Aunque castigatzøcpa Diosis, ji'nø vaṉjajme. Ji'nø ṉgomus jic pøn nø mi ndzamdamupø; ispa Diosis. ");
INSERT INTO zosNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Y jicsye'c vej gaylu menajcøsi. Entonces Pedro'is jyajmuchøc lo que Jesusis oyuse chajmaye; porque Jesusis oyuna'ṉ ñøjaye: “Antes que vejpa gaylu menac, maṉba mi ñømi tu'cayñac que ji'n mi ndø ispøc ndøvø”. Cuando Pedro'is jyamuchøjcu jujche oy ñøjay Jesusis, vo'tzo'tzu. ");
INSERT INTO zosNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cuando sø'ṉbønømu'c, tu'myaj pane covi'najøta'm y tzambønda'm y aṉgui'mguyji'ṉ aṉma'yoyajpapø y mumu aṉgui'myajpapø Israel pø'nis ñe'ta'm. Tu'myaju y qui'pscøpo'yaju jujche vøj va'cø chøcyajø. Entonces myocsyaj Jesús y ñømaṉyaju aṉgui'mbapø Pilato'is vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Y Pilato'is 'yaṉgøva'c Jesús: ―¿Mijtzømate Israel pø'nis 'Yaṉgui'mbata'm? Jesusis 'yaṉdzoṉu ñøjayu: ―Øjchøṉø nømdi mi ndzamuse. ");
INSERT INTO zosNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Y pane covi'najø'sta'm cyøtza'møyaj Jesús sone ticøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Entonces Pilato'is 'yaṉgøva'c vøjøtzøjque'tu Jesús, ñøjayu: ―¿Ji'n mi 'yaṉdzo'ṉoy ni jujche? Cøma'nøy jujchepø ticøsi mi ṉgyøtza'møyajpa. ");
INSERT INTO zosNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jesús ja 'yaṉdzo'ṉoy ni jujche. Por eso Pilato maya'u. ");
INSERT INTO zosNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pero cuando itpa'cna'ṉ tumdum Pascua søṉ, ijtuna'ṉ costumbre va'cø syombø' Pilato'is tum preso jutipø sone pø'nis syuñajpa. ");
INSERT INTO zosNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ityajuna'ṉ pøn preso'omo oyupø'is ñøquipyaj gobierno y oyupø yaj ca'oyaje. Je'tomo ijtuna'ṉ tum ñøyipø'is Barrabás. ");
INSERT INTO zosNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Cyømiñaj Pilato sone pø'nis y ñøjayaju: ―Tø tzøjcatyam favor va'cø mi ndzøcøpø' tum preso como mi ndzøcpase tumdum pascua sø'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Y Pilato'is ñøjayaj sone pøn: ―¿A ver o'ca mi sundamba mi Israel pø'nista'm va'cø mi yac tzø'yatyam libre mi Aṉgui'mbata'm? ");
INSERT INTO zosNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jetse ñøjayaju Pilato'is porque chi' cuenta que pane covi'najø'is ña'chaju que Jesús más maṉba aṉgui'mi que menos ñe'cta'm, y por eso qui'sayaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero pane covi'najø'is yac so'natejyaj sone pøn, y chajmayaju va'cø vya'cyaj Pilatocøsi va'cø chøcøpø' Barrabás y ji'ndyet Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Y Pilato'is ñøjayajque'tu: ―¿Entonces ti ma'ṉbø ndzøjcay pøn mitz mi Israel pø'nis mi ñøjandyambapø mi Aṉgui'mbata'm? ");
INSERT INTO zosNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Entonces sone pøn vejyajque'tu, ñøjayaju: ―Yac ma'møytøj cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Y Pilato'is ñøjayaju: ―¿Ti'ajcuy, tiyø coja chøjcu? Pero vejyaju más pømi: ―Yac ma'møtyøj cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Entonces como Pilato'is suṉbana'n chøcø lo que suñajpase sone pø'nis, syombø' Barrabás, y 'yaṉgui'mu va'cø ñacstochøc Jesús, y entonces chi'ocuyaju va'cø mya'møyaj cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Entonces soldado'is ñømaṉyaj Jesús jojmo palacio solajromo y vyejtu'mbø'yaj mumu soldado jen ityajupø. ");
INSERT INTO zosNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Y yac mesyaj Jesús tzapaspø tucu, y pye'tayaju apit corona y yac mesyaj Jesús cyopajcomo. ");
INSERT INTO zosNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","'Yo'nøyaju como aṉgui'mbapø, ñøjayaju: ―¡Viva Israel pø'nis 'Yaṉgui'mbata'm! ");
INSERT INTO zosNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Y ñacsyaj cyopajcøsi cuji'ṉ y cyujnejayaju como si fuera maṉbase cyøna'tzøyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Y qui'tzcu'ajyajujcam, yac tzacyajque't tzapaspø tyucu, y yac mesyajque't ñe' tyucu. Entonces ñømaṉyaj Jesús va'cø maṉ mya'møyaj cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nømna'ṉ cyøt tum pøn ñøyipø'is Simón, Alejandro'is y Rufo'is jyatata'm. Cirene cumgupyønete. Nømna'ṉ min Simón tza'mom oyupø. Soldado'is ñucyaju y yaj cajpayaj Jesusis cruz. ");
INSERT INTO zosNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ñømaṉyaj Jesús nøjayajpamø Gólgota, ndø onde'omo ndø nøjatyambamø Ca'upø'is Cyo'cøpacmø. ");
INSERT INTO zosNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Y chi'jo'yaj Jesús vino mojtupø mirra ta'nøji'ṉ va'cø tyo'ṉa, pero ja tyo'ṉa. ");
INSERT INTO zosNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Y mya'møyaj Jesús cruzcøsi. Entonces soldado'is pyøjcayaj Jesusis tyucu y vye'nayaju tumdum go'ma, cyøsijayaj tyucu a ver jutipø'is maṉba pyøc mas vøjpø tucu. ");
INSERT INTO zosNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A las nueve de la mañana na'ṉete cuando mya'møyaj cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Y cyotyaj tabla letra'øyu chambapø'is tiyø cyoja. Letrera nømbana'ṉ: “Israel pø'nis myøja'ṉ Aṉgui'mbata'm”. ");
INSERT INTO zosNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Y Jesusis syayamaye mya'møyajque't cruzcøsi metzcuy nu'myajpapø, tum chø'na'ṉomo y tum 'yaṉña'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Y jetse viyu'ṉaju masanbø totojaye jut chambamø: “Ndø Comi parejo yacsutzucyaju yatzita'mbø pønji'ṉ”. ");
INSERT INTO zosNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cøtyajpapø'is 'yo'nindzemyaju, cyopacti myi'cu'jayaj Jesús, ñøjayaju: ―O'ca mitz muspa mi ⁿju'mbø' masandøc y tu'cay jamapit ndzøcvøjøtzøcpa, ");
INSERT INTO zosNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","entonces yaj cotzoc mi ⁿvin, y mø'n cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jetsetique't pane covi'najø'is y aṉgui'mguyji'ṉ aṉma'yoyajpapø pø'nis cyøsijcayajque't nañøjayajtøju: ―Eyata'mbø yaj cotzocyaju; pero ji'n mus yaj cotzoc ñe' vyin. ");
INSERT INTO zosNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","O'ca yøti ndø istamba Cristo, ndø Aṉgui'mbata'm tø øtz Israel pønda'm chøṉø, nø myø'nupø cruzcøsi, entonces maṉba ndø va'ṉjamdame que Diosis 'Yunete. Y pøn ma'møyajupø Jesusis syayamaye eyapø cruzcøsi, je'is cyø'o'nøyajque'tu Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Paṉguc jamasye'ṉomo oy pi'tzø'ajnøm mumu nasindumø, hasta las tres de la tarde tøc min sø'ṉnøṉgue'te. ");
INSERT INTO zosNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Y a las tres pømi veju Jesús. Ñe 'yote'omo nømu: ―Eloi, Eloi, ¿lama sabactani? ―nømbapøte ndø ote'omo: Øjchøṉ mi Dios, øjchøṉ mi Dios, ¿ticøtoya mi ndø patzpø'u tzajcu? ");
INSERT INTO zosNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Y vene aṉbø'nis jiṉø te'ñajupø'is myañaju ti nø chamu Jesusis y nømyaju: ―Mandamø, yø'ṉis nø vyejay Elías. ");
INSERT INTO zosNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Y pochu'ṉu tum pøn maṉu yac muj tzoja vinagre'omo y cyot capecøsi va'cø yaj qui'may møji va'cø cyojtay Jesusis 'yaṉna'como va'cø cyømu'c tzoja, y nømu: ―¡Tzactamø! Ma ndø a'mda'i o'ca minba Elías va'cø yac mø'nø. ");
INSERT INTO zosNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Entonces pømi vej Jesús y ca'u. ");
INSERT INTO zosNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jicsye'c cuctzitz tucu jø'mupø masandøjcomo va'cø chøc cuarto. Cuctzitz desde møji hasta cø'yi. ");
INSERT INTO zosNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jenna'ṉ te'nu nø 'ya'mupø Jesús soldado covi'najø'is. Cuando isu jujche ca' Jesús, nømu: ―Viyuṉsye yøṉø pøn Diosisna'ṉe 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ityajque'tutina'ṉ yomo ya'i nø 'ya'myajupø'is. Entre ñe'comda'm ijtuna'ṉ María Magdalena, y ijtuna'ṉ eyapø María ijtu'is 'yune tum ñøyipø'is más muquipø Jacobo, y eyapø ñøyipø'is José. Y itque'tuti jiṉø eyapø yomo ñøyipø'is Salomé. ");
INSERT INTO zosNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Cuando Jesús Galilea nasomna'ṉ ijtu, jicø yomo'is o pya'tyaje y oy cyøyosøyaje. Y también nømna'ṉ 'ya'myajque'tu vøti eyata'mbø yomo'is oyupø'is ñøtu'ṉayaje Jesús cuando minu Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jicø jamamete cuando cyomeque'ajyajpana'ṉ sapøjcuy jamacøtoya porque jyo'pit sapajcuy jamamete. Por jetcøtoya como tza'i'ajnømu, ");
INSERT INTO zosNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","min José Arimatea cumgupyøn. Myøja'ṉombø pønete ijtu'is aṉgui'mguy. Yø'ṉis jyo'cpana'ṉ va'cø min 'yaṉgui'm Dios. José pømi pøjcu va'cø cyønu'c Pilato y vya'cay permiso va'cø pyøjcay Jesusis cyoṉña. ");
INSERT INTO zosNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato'is nømna'ṉ cyomo'yu que ja cya'øtøc Jesús, y vyejay soldado covi'najø y aṉgøva'cu o'ca viyuṉse ca'u'am. ");
INSERT INTO zosNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cuando soldado covi'najø'is ñøjay: “Ca'u'am”; Entonces Pilato'is ñøjmay José va'cø pyøjcaya'am Jesusis cyoṉña. ");
INSERT INTO zosNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Y Jose'is jyuy sábana vøjpø, ñømø'n Jesús cruzcøsi, y myon sabanaji'ṉ. Cyot tzatøjcomo nojtayupø tza'omo y piti'aṉga'm møjapø tza'ji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Y isyaj María Magdalena'is y Jose'is myama Maria'is jut cojtøju. ");
INSERT INTO zosNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cuando cøjtu'cam sapøjcujyam, maṉ jyuyaj suñi viquicpapø perfume María Magdalena'is, y Jacobo'is myama Maria'is y Salome'is. Maṉ jyuyaj perfume va'cø maṉ jyasayaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Y semana tzo'tzcu jyama, namdzuti nu'cyaju tzatøjcaṉvini cuando qui'mu'cam jama. ");
INSERT INTO zosNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Y nañøjayajtøju: ―¿I'is maṉba tø pititzu'ṉatyam tza' 'yaṉga'mbapø'is tzatøc? ");
INSERT INTO zosNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero cuando quendonde'ñaju, isyaj tza' que pitipø'umna'ṉ, y tza' møjapøte. ");
INSERT INTO zosNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tøjcøyaj tzatøjcomo y isyaj uñbøn po'csupø chø'na'ṉomo. Uñbø'nis myejsuna'ṉ pøjipø tucu sujpopopø, y ña'chaj yomo'is. ");
INSERT INTO zosNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero pø'nis nøjayaj yomo: ―Uy ñatztame. Nø mi me'tztam Jesús Nazaret cumgu'pyøn oyupø ma'møtyøj cruzcøsi. Pero visa'u'am, ja itøm yø'qui. Ma a'mistamø jut oyumø cojtøji. ");
INSERT INTO zosNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Maṉdyamø ma tzajmatyam ñøtuṉdøvø Pedrota'm que Jesús maṉba vi'na maṉ Galilea nasomo. Jeni maṉba mi istam Jesús jujche mi ncha'maṉvajcatyamuse. ");
INSERT INTO zosNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Entonces yomota'm pochu'ṉyaj tzatøjcomo porque nømna'ṉ syøtøtyaj na'tze'is. Y ni ja chajmayaj ni tiyø ni iyø, porque ña'chaju. ");
INSERT INTO zosNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Después que Jesús visa'u namdzu semana tzotzcu jama'omo, vinbø yac is vyin María Magdalena. Maria'is chocoyomo oyuna'ṉ yac tzu'ṉay cu'yay yatzipø espiritu. ");
INSERT INTO zosNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria'is maṉ chajmayaj lo que oyupø vityaj Jesusji'ṉ. Jicta'm nømna'ṉ toyapøcyaju y nømna'ṉ vyo'yaju. ");
INSERT INTO zosNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cuando Maria'is chajmayaju que Jesús visa'u y oy isi, ja vya'ṉjamyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mas jøsi'cam Jesusis eyase cyejnayaju vyin metzpøn nø myaṉyajupø tu'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Metzpøn vitu'yaju y oy chajmayaju eyata'mbø, pero eyata'mbø'is ja vya'ṉjamyajque'tati. ");
INSERT INTO zosNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mas jøsi'cam Jesusis yaj quejayaj vyin once ñøtuṉdøvø mientras po'csyajuna'ṉ mejsya'omo y Jesusis 'yojnayaju porque ja vya'ṉjamyajø y ji'n vyøjta'm qui'psocuy. Porque ja vya'ṉjamyajø lo que chajmayajuse eyata'mbø'is o'ca Jesús que visa'upø. ");
INSERT INTO zosNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Y ñøjayaju Jesusis: ―Maṉdam nasvindumø, y ocpoñøvijtam mumu pø'nomo jujche muspa cyotzocyajø. ");
INSERT INTO zosNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","I'is vaṉja'mbøjtzi y nø'yøpya, cotzocpa. Pero i'is ji'nø va'ṉjajme, tocopya. ");
INSERT INTO zosNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Y yøcseta'mbø seña maṉba chøcyaj va'ṉjamyajpa'stzi: ø nøyicøsi maṉba yac tzu'ṉyaj yatzi'pø espiritu pø'nis choco'yomda'm; maṉba oñaj eyata'mbø ote. ");
INSERT INTO zosNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Maṉba ñucyaje cyø'ji'ṉ yatzipø tzan, y aunque venenupø, ji'n ni ti chøjcayaje. Además maṉba cyotyaj cyø' ca'eta'mbøcøsi, y maṉba tzocyaje. ");
INSERT INTO zosNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Y jetse cham Jesusis y entonces nømaṉdøj møji tzajpomo y po'csu Diosis chø'na'ṉomo, mas myøja'ṉ aṉgui'mbapø pyo'cspamø. ");
INSERT INTO zosNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ñøtuṉdøvø tzu'ṉyaju y chamboyaj ote aunque juti, y ñe'c ndø Comi'is cyotzoṉyaju, y yac isyaj milagro'ajcuy va'cø myustøjø que viyuṉsyepø ti nø chamyaju ñøtuṉdøvø'is.");
INSERT INTO zosNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Myøja'ṉombøte mijtzi Teófilo, nø mi ⁿjajyayu carta: Ijtu sonepøn opø'is jyayjo'yaje jujche ose tucnømi tø øjtzomda'm cuando Jesús vitpa'cna'ṉ nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Oy jyayjo'yaje lo que tø aṉmatyamuse isyajupø'is yøcsepø tiyø tuctzo'tzu'csye'ṉom yø'cse. Jic jyayajupø'is cyotzoṉyaju va'cø chajmayaj Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Øtz ndu'nme'tz øjtzi y aṉgøva'cme'tz øjtzi mumu ose tucnømi tø øjtzomda'm. Jetcøtoya mbensatzøc øtz va' mi ⁿjajyayø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Su'nbø mi ⁿjajyayø va'cø mi ṉgønøctøyøtyam mø'chøqui lo que mi nchamdzo'tzatyamu'am eyata'mbø'is. ");
INSERT INTO zosNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Je jama cuando aṉgui'mba'cna'ṉ Herodes Judea nasomo, ijtuna'ṉ tum pane ñøyipø'is Zacarías. Zacariasis chøcpana'ṉ pyane'ajcuy eyata'mbøji'ṉ por turno; je'is tyurno ñøjayajpana'ṉ Abiasis ñe'. Jetse chøcyajpana'ṉ pyane'ajcuy cuando nu'cyaj je'is jyamata'm va'cø yosyajø. Itque'tuna'ṉ Zacariasis yomo ñøyipø'is Elisabet. Elisabejtis pecatzambøn jyata ñøyipø'sna'ṉ Aarón. ");
INSERT INTO zosNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Diosis isu que vøjta'mbøte Zacarías y Elisabet. Y ni pø'nis ji'n mus chøjcayaj cyoja, porque cyøna'tzøyajpana'ṉ mumu lo que jujche 'yaṉgui'myajuse ndø Comi'is. ");
INSERT INTO zosNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero nunca ja 'yoyaj 'yune, porque Elisabet ji'ndyet 'yune'øyipø, y achpøta'mbø'mna'ṉete mye'chcø'i. ");
INSERT INTO zosNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Entonces nu'c jama cuando Zacariasis nømna'ṉ chøc pyane'ajcuy Diosis vyi'naṉdøjqui porque cøpiṉyajupø va' yos masandøjcomo venepøn jete yosyajpapøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ijtuna'ṉ pane'is cyostumbreta'm va'cø chøjquisyaj syuerte va'cø cyøpiṉyajtøjø a ver ti yoscuy maṉba chøc tumdum pø'nis. Jetse cøpiṉdøj Zacarías va'cø maṉ jyo'cøy pomo Diosis tyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jetsemete cuando nu'c hora, Zacariasis nømna'ṉ jyo'cøy pomo jojmo Diosis tyøjcomo mientras mumu vøti pøn ityajuna'ṉ a'ṉgomo nø cyonocsyajupø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Y min cyejay Zacarías tum angelesis ndø Comi'is cyø'vejupø. Yøṉø angeles nømna'ṉ tye'n mesya'is syaya'omo jut jo'cøtyøjpamø pomo. ");
INSERT INTO zosNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Cuando Zacariasis is angeles, mitzitz choco'yomo y na'tzcomø'nu. ");
INSERT INTO zosNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero angelesis ñøjmayu: ―Uy ña'tze, Zacarías. Porque cyøma'nøy Diosis nø mi 'yoratzøjcayuse. Por eso mi yomo Elisabejtis maṉba is une, y maṉba mi ⁿyac nøyi'aj Juan. ");
INSERT INTO zosNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Maṉba mi ṉgyasøyi y maṉba mi ñchi'ṉbø'i, y maṉba cyøcasøyaj vøti pø'nis mi ⁿune. ");
INSERT INTO zosNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Porque ndø Comi maṉba nømi que mi ⁿune myøja'ṉombøte; y ji'n ma tyo'ṉ ni vinu ni tzoy; y maṉba ñø'it mi ⁿune Masanbø Espiritu Santo'is desde antes que maṉba pø'naje. ");
INSERT INTO zosNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y vøtita'mbø Israel pøn maṉba yac vitu'yaj Cyomi Dioscøsi mi ⁿune'is. ");
INSERT INTO zosNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Antes que maṉba min ndø Comi, mi ⁿune maṉba yose Eliasis qui'psocuji'ṉ y pyømiji'ṉ; jata va'cø yac sunvøjøtzøcyaj 'yune, y ji'n cøna'tzø'oyajepø maṉba yac nø'ityaj vøjpø qui'psocuy. Jetse maṉba chøqui va'cø ityaj jajmecøs cumgupyøn va'cø pyøjcøchoṉyaj ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Y Zacariasis ñøjmay angeles: ―¿Jutz nømø ma'ṉbø mus øjtzi o'ca maṉba it ø ⁿune? Porque øjtzi achpø'mtzi, y ø ⁿyomo tzamyomo'am. ");
INSERT INTO zosNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angelesis ñøjmayu: ―Øjchøn Gabriel que øtz it Diosis vyi'naṉdøjqui; y øtz cø'vejøjtzi Diosis va'cø mi o'nøyø, y va'cø mi ndzajmay yøcsepø vøjpø ote. ");
INSERT INTO zosNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero yøti porque ja mi ndø va'ṉjajmay ø onde, por eso maṉba mi ⁿ'yuma'aje, y ji'n mus ma mi ⁿ'yona; hasta que nu'cpa jyama yø'cse tucpa øtz ndzambase. Jicsye'c maṉba mi ⁿ'yongue'te. Porque maṉba nu'c jama va'cø tyucø jujche mi ⁿnøjayuse. ");
INSERT INTO zosNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mientras jetse tujcu, a'ṉgom ityajupø pø'nis nømna'ṉ jyo'cyaj Zacarías, y maya'yajpana'ṉ de que ya'co'n masandøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cuando put Zacarías, ji'na'ṉ mus 'yo'nøyajø, y pø'nis cyønøctøyøyaju que Zacariasis isuna'ṉ ji'n ndø isipø masandøjcomo. Y Zacariasis chøjcay seña cyø'ji'ṉ sonepøn y tzø'y umapø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Y cøjtu'jcam yoscuy masandøjcomo, Zacarías maṉ tyøcmø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Y jøsi'cam min chøjcay cuenda que yomo Elisabet ji'ndyet tyumbø, que maṉba is une. Y Elisabet tzø'y tyøjcomo mosay poya. Nømu: ");
INSERT INTO zosNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Cotzo'ṉøjtzi yøti yøcse ndø Comi'is, yac isø une va'cø jana conocyaj pø'nis”. ");
INSERT INTO zosNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tujtay poyapit Diosis cyø'vey angeles Gabriel tum cumgu'yomo ñøyipø'is Nazaret, Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Cyø'veju va'cø maṉ tyu'n tum papiñomo ñøyipø'is María. Y je papiñomo maṉba'ctø'que pyøc tum pø'nis ñøyipø'is José, vi'na pøn Davijdis 'yune. ");
INSERT INTO zosNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tøjcøy angeles ijtumø María, yuschi'u y ñøjmayu: ―Nø mi ṉgyotzoṉ Diosis, María, y ndø Comi mitzji'ṉbøte. Mitz más vøjpø ti mi mba'tu que ji'n eyata'mbø yomose. ");
INSERT INTO zosNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Cuando isu'jcam angeles, María maya'u por lo que ñøjayuse. Nømna'ṉ jyajme'tz choco'yomo, tyumgøytina'ṉ nø ñømu “¿Tiyø yuschi'ocuy yø'cse?” ");
INSERT INTO zosNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Y ñøjay angelesis: ―Uy ña'tze, María. Diosis mi yac pa't vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Maṉba mi unemba'te, y maṉba mi is jaya'une, y maṉba mi yac nøyi'aj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Y je une maṉba myøja'ṉo'maje; y maṉba ñøjmayaje: “Møjipø Diosis 'Yune”. Y ndø Comi Diosis maṉba chi' aṉgui'mguy jujche pyeca jata tzu'ṉguy Davijdis ñø'ijtusena'ṉ aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Y maṉba aṉgui'm Israel pø'nomo mumu jama, y nunca ji'n maṉ cøyaj 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Entonces Maria'is ñøjmay angeles: ―¿Jutznøm ma'ṉbø is yø'cse? Porque ja it ø ⁿjaya. ");
INSERT INTO zosNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angelesis ñøjmayu: ―Maṉba nu'c mitzcøsi Masanbø Espiritu Santo, y Møjipø'is pyømi'ajcuy maṉba vovitu' mitzcøsi como o'nase. Jetcøtoya je une maṉbapø pø'naje masanbø unete, y maṉba ñøjmayaje Diosise 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y mi ndøvø Elisabet unepa'tque'tuti, aunque tzamyomo'cam, y nø myaṉgue't tujtay poya pya'tumø une; aunque ñøjmayajpana'ṉ nunca ji'n 'yune'øyipø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Porque ja it ni tiyø ji'n musipø chøc Diosis; mumu ti muspa chøcø je'is. ");
INSERT INTO zosNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Entonces nøjmay Maria'is: ―Øjchøṉ ndø Comi'is cyoyomo; vøj va' yac tuc Diosis jujche mi ndzamuse. Y tzu'ṉ angeles ñe'jcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Cøjtu'jcam metz tu'cay jama, tzu'ṉ María y poyemaṉ cotzøjcø'mø y nu'c tum cumgu'yomo Judea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Y tøjcøy Zacariasis tyøjcomo y yuschi' Elisabet. ");
INSERT INTO zosNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cuando Elisabejtis myan Maria'is nø yuschi'upø, pømimics une chejcomo, y Elisabet ñø'it Masanbø Espiritu Santo'is. ");
INSERT INTO zosNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Y Elisabejtis pømi ñøjayu María: ―Diosis mi ñchi'pa vøjpø tiyø más que eyapø yomota'm, y chi'que'tpati vøjpø tiyø une maṉbapøtøc pø'naj mitzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Como mitz ndø Comi'is mi myama, ¿ti'ajcuy min mi ndø tu'n mijtzi? Como øtz ji'n chøṉ ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Porque tan pronto ma'nø mi ⁿyuschi'ocuy, ø ⁿune pømimicsu como casøpyase ø ndzejcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Vøco'ni mi ⁿijtu mijtzi va'ṉjamba'is ndø Comi'is chambase. Porque maṉba tuc mumu tiyø mi ñchajmayuse ndø Comi'is. ");
INSERT INTO zosNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jicsye'cti nøm María: Ø ndumø tzocoy nø'mbøjtzi ndø Comi myøja'ṉombøte. ");
INSERT INTO zosNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ø ndzoco'yomo cøcajsøpyøjtzi Dios ø Yajcotzocpapø'is ");
INSERT INTO zosNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","aunque øtz ji'n chøṉ ni tiyø, pero Diosis cuenda tzøjcø øjtzi. Øjchøṉ je'tis cyoyomo. Desde yøti aunque jutipø pøn maṉba nømyaje øtz vøcomø'ni ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porque chøc øtzcøtoya vøcomø'nipø tiyø Pømi'øyupø'is; y masanbøte je Pømi'øyupø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Diosis tyo'ya'ṉøyajpa mumu jama cyøna'tzøyajpapø'is ñe'cø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Diosis o chøc myøja'ṉo'majcuy. Yac mochquecyaju myøja'ṉomgotzøcyajpa'is vyin. ");
INSERT INTO zosNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yac tzu'ṉapya más myøja'ṉombø'is 'yaṉgui'mguy; y ni ti aṉgui'mguy ja ñø'itøpø'is, jet yac møja'ṉo'majpa. ");
INSERT INTO zosNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yac tasyajpa osyajpapø pønda'm vøjta'mbø tiji'ṉ; yac maṉyajpa rico, ni ji'n chi'yaj ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Diosis cyotzoṉyaj chøsi Israejlis vøti'ajyajupø 'yune; ja jyajmbø'yajø, mumu jama tyoya'ṉøyajpa. ");
INSERT INTO zosNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Porque jyajmutzøjcu lo que chajmayajuse ndø peca jata tzu'ṉguy Abraham 'yuneji'ṉda'm que maṉba tyoya'ṉøyaje mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Elisabetji'ṉ tzø'y María como tu'ca poya. Jicsye'cti vitu'que't tyøcmø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Entonces cuando ta'n jyama, Elisabejtis o is jaya une. ");
INSERT INTO zosNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Y myañaj tyøjcaṉbo'csa'sta'm y tyøvø'sta'm que ndø Comi'is chøjcay Elisabet møjapø to'ya'ṉø'ocuy, y casøyaj Elisabetji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Y cuando une ta'n tucutujta' jama, ñømaṉyaj une va'cø syeña'øyajø como Israel pø'nis cyostubresena'ṉ. Maṉbana'ṉ chi'ayaje jyata'is ñøyi Zacarías. ");
INSERT INTO zosNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero myama nømu: ―Ji'nda, sino maṉba ñøyi'aj Juan. ");
INSERT INTO zosNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Y ñøjmayaju: ―Pero mi ndøvø'omda'm ja it jetse ñøyipø'is. ");
INSERT INTO zosNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Y chøjcayaj seña cyø'ji'ṉ va' 'yocva'cyaj jyata jujche syunbana'ṉ yac nøyi'ajyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Y jyata'is vya'c tum che'pø tabla, y jetcøs jyayu: “Juanete ñøyipø”. Y mumu myaya'yaju ticøtoya jetsena'ṉ yac nøyi'ajyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jicsye'cti muspana'ṉ ona Zacarías, y vejvejneyu, vyøcotzøc Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","O cyøna'chaje jujche tujcuse mumu tøjcanbo'csa'sta'm y o tzamdzamneyaj jetsepø ticøsi mumu møjmøpø cumgu'yomda'mbø Judea nasomda'mbø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Y mumu myañajpapø'is ote jujche tujcuse, jyajme'chajpana'ṉ y na ñø ocva'cyajtøju: ―¿Ti maṉba chøc yøṉ une'is? Y ndø Comi'is vøti cyotzoṉ je une. ");
INSERT INTO zosNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Entonces Masanbø Espiritu Santo'is chi' une'is jyata Zacarías qui'psocuy va'cø cha'maṉvajcoya; nømu: ");
INSERT INTO zosNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ndø vøṉgotzocta'i ndø Comi Dios tø Israel pø'nista'm ndø ne'nda'mete. Porque min tø cotzoṉdame y tø yaj cotzoctame je'is tø cumgupyønda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tø yac mijnatyam tum pømi'øyupø Yajcotzojcopyapø. Min pø'naje Diosis ya'møcpø chøsi Davijdis chacyajupø 'yune'omda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ya'møcti Diosis chi'yaj qui'psocuy tza'maṉvajcoyajpapø tiyø ote va' chamyajø, y lo que chamyajuse vi'na, jetse tuc yøti. ");
INSERT INTO zosNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Chamyaju que maṉba tø yaj cotzoque va' jana tø tzøjcayajø ni tiyø tø qui'sayajpapø'is y ji'n suni'is tø isyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chamgue'tuti que maṉba tyoya'ṉøyaj vi'nata'mbø ndø janda tzu'ṉguy, que ji'n ma jyajmbø' masanbø cyontrato. ");
INSERT INTO zosNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Diosis cyot vyin como testigos que viyuṉsye maṉba chøqui ti chajmay ndø peca jata tzu'ṉguy Abraham. ");
INSERT INTO zosNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Chajmayu que maṉba tø yaj cotzoctamø va' jana tø tzøjcay ni tiyø tø qui'satyambapø'is, jana na'tzcuy va'cø mus ndø ⁿyosatyam Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Como je'is tø ñe'ta'm vøj va'cø ndø ⁿyosatyam ñe'c vyi'naṉdøjqui mumu jama tø quendamba'csye'ṉomo, y que va' is Diosis que vøj ndø tzøctamba. ");
INSERT INTO zosNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Y mijtzi ṉga'e, maṉba nømnømi mitz mi ndza'maṉvacpa Møjipø'is chambase, porque maṉba mi vi'na ndza'maṉvaque que minba ndø Comi, va' jyajmemiñaj cumgupyøn ndø Comicøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Maṉba mi ndø yac mustam je'is tø cumgupyønda'm que Diosis tø yaj cotocojatyamba ndø coja va'cø tø cotzoctamø. ");
INSERT INTO zosNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Porque vøti tø tøya'ṉøtyamba Diosis, jetcøtoya como qui'mbase jama namdzu', jetse tø øtzcø'mø maṉba mini tø Yajcotzoctambapø'is. Møji maṉbapø tzu'ṉi. ");
INSERT INTO zosNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Maṉba tø cøsø'nøjatyam ndø tzocoy pi'tzø'omse tø ijtamupø y como si fuera cømøṉgø'm tø ijtamuse y jetse maṉbana'ṉ tø ca'tame. Je'is tø isindzi'tamba tuṉ va'cø tø ijtam contento. ");
INSERT INTO zosNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y une Juan ye'ṉbana'ṉ y tumdum jama más qui'psocuy minbana'ṉ, y o it jya'ijnømømø hasta que nu'c jyama va'cø yaj quej vyin Israel pø'nomo. ");
INSERT INTO zosNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yøcse tuc jej jama'omo: 'Yaṉgui'm aṉgui'mbapø Augusto'is va'cø cøyin jyapøjcayajtøj mumu nasomda'mbø'is ñøyi. ");
INSERT INTO zosNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Chøcyaj yøṉø vi'napø japyøjcocuy cuando Cirenio aṉgui'mbana'ṉ Siria nasomo. ");
INSERT INTO zosNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mumuna'ṉ nø myaṉyaj ñe cyumgu'yomo va'cø chacyaj jachø'yupø ñøyi. ");
INSERT INTO zosNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José tzu'ṉ Galilea nasombø cumguy Nazarejtomo y maṉ tum cumgu'yomo ñøyipø'is Belén, Judea nasombø cumguyete y Davijdisna'ṉ cyumguy ya'møc. Por eso maṉ jiṉø porque José Davijdis chajcupø fyamilia'ombøte. ");
INSERT INTO zosNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maṉ José Mariaji'n va'cø jyapøjcayajtøj ñøyi, porque chøcyajumna'ṉ trato que maṉbam co'tøjcajyaje; y María ji'namna'ṉe tyumbø. ");
INSERT INTO zosNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Así es que mientras jejta'm jena'ṉ ityaju, nu'c 'yora va'cø is une. ");
INSERT INTO zosNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Y is vinbø jaya une, y myon tucuji'ṉ, y cyu'ṉøy cu'tyajpapø'om copøn; porque ja itøna'ṉ lugar para jetcøtoyata'm jejcuy tøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Cumguy acapoya ityajuna'ṉ pøn tza'momo nø cyoqueñaju'is byorrego tzu'i. ");
INSERT INTO zosNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Y joviti nu'c jetcø'mda'm ndø Comi'is 'yangeles, y cyøsø'ṉøjayaju ndø Comi'is syø'ṉgø'is, sø'ṉgø'om suñi tzø'yaju; y na'tzcomø'ñaju. ");
INSERT INTO zosNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Y angelesis ñøjmayaju: ―Uy ña'tztame, porque øtz nø'mø mi nømijnandyam mijta'm vøjpø ote va'cø mi ṉgyasøcomø'ndam mumu pønji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yøti Davijdis cyumgu'yomo pø'naju'am maṉba'is mi ⁿyaj cotzoctame. Jiquete Cristo y ndø Comite. ");
INSERT INTO zosNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Maṉba mi mba'jtam une monupø tucu'omo, y yac øṉdøju cu'tyajpapø'om copøn. Jet señamete que jiquete nø ndzamupø une. ");
INSERT INTO zosNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Y misma horatique't joviti quejyajque't angelesji'ṉ vøti eyata'mbø angeles tzajpom tzu'ṉyajupø. Nømna'ṉ vyøcotzøcyaj Dios y nømyaju: ");
INSERT INTO zosNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Vøcotzøctøjpa Dios tzajpomo, y nascøs vyøjom maṉba ityaj pøn Diosis syuñajpapø. ");
INSERT INTO zosNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Vañaju'cam jetse, angeles tzu'ṉyaj jetcø'mda'm y maṉyaj tzajpomo. Entonces cyoqueñajpa'is byorrego na ñøjmayajtøju: ―Tø maṉdya'i yøti Belen gumgu'yomo va'cø maṉ ndø a'mistamø tiyø tujcupø, tø yac mustamuse ndø Comi'is. ");
INSERT INTO zosNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Y poyuc maṉyaju y pya'tyaj María y José 'yuneji'ṉ; y yac øṉuna'ṉ 'yune cyutyajpapø'om copøn. ");
INSERT INTO zosNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cuando isyaju, chajmayaju aunque iyø jujche angelesis ose chajmayaje que jujchepøt une pø'naju. ");
INSERT INTO zosNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y mumu myañajupø'is ñømaya'yaju chajmayajuse cyoqueñajpapø'is borrego. ");
INSERT INTO zosNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Y mumu jetsepø ote jyajmbana'ṉ Maria'is como tzajmatyøjuse, piensatzøcpana'ṉ jutznøm jetse nø tyujcu. ");
INSERT INTO zosNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Cyoqueñajpapø'is borrego vitu'yaj tza'momo y vyøcotzøcyaju y vyajnayaju Dios porque mumu jujche chajmayajuse angelesis, jetse myañaju y jetse isyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cuando ta'nujcam tucutujtay jama, syena'øyaj une Israel pø'nis syeñaji'ṉ; y yac nøyi'ajyaj Jesús; como jujche chajmayuse angelesis antes que unepa't myama. ");
INSERT INTO zosNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Cuando ta'nu jyama va'cø cyøvajcøyajtøjø 'yaṉgui'muse Moisesis, y ijtuse jachø'yupø; entonces ñømaṉyaj une Jerusalen gumgu'yomo va'cø presentatzøcyaj ndø Comicø'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jetse chøcyaju porque it ndø Comi'is 'yaṉgui'mguy jachø'yupø: “Mumu vinbø jaya une nøjatyøjupø masanbøte ndø Comicøtoya”. ");
INSERT INTO zosNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","También chi'ocuyaju va'cø yaj ca'yajtøjø vya'ṉjajmocucyøtoya ijtuse ndø comi'is 'yangui'mguy jachø'yupø. It jachø'yupø va'cø yaj ca'yaj metzcuy jo'ma palomo, o si no, metzcuy che'pø paloma. ");
INSERT INTO zosNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ijtuna'ṉ Jerusalén gumgu'yomo tum pøn ñøyipø'is Simeón. Yøṉø pøn vøco'nipø pønete y cyøna'tzøpyana'ṉ Dios, y jyo'cpana'ṉ cyotzoṉbapø'is Israel pønda'm, y Masanbø Espiritu Santoji'ṉbøna'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Y Masanbø Espiritu Santo'is yac musu que ji'n ma cya'e antes que maṉba is Cristo ndø Comi Diosis maṉbapø cyø'veje. ");
INSERT INTO zosNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simeón ñømaṉ Masanbø Espiritu Santo'is Israel pø'nis myasandøjcomo. Y mismo tiempo ñøtøjcøyaj une Jesús jyata'sta'm va'cø presentatzøcyajø jujche jachø'yuse Moisesis 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Entonces Simeo'nis jyotzpøc une y vyøcotzøc Dios y ñøjmayu: ");
INSERT INTO zosNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ojchøn mi Ngomi, o mi ndø yac yose. Yøti tø tzac ndøvø va'cø ca'ø contento como mi ndzamuse. ");
INSERT INTO zosNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Porque ⁿisu'mtzi ø vindømbit mi ṉgø'vejupø va'cø tø yaj cotzoca, ");
INSERT INTO zosNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","jic oyupø mi yac mini mumu pø'nis vyi'nandøjqui. ");
INSERT INTO zosNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Minu como tum sø'ṉgøse va'cø yac musyaj viyuṉbø tiyø eyapø pønda'm lo que ji'ndyet Israel pønda'm, y maṉba vøcotzøcyajtøj mi ngumguy Israel pønda'm porque je'tomo min Yajcotzojcopyapø. ");
INSERT INTO zosNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jetse Simeo'nis o cyotzam une, y José y Jesusis myama nømna'ṉ myaya'yaju jujche nø chamu. ");
INSERT INTO zosNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Y cyomasa'nøyaju Simeo'nis y ñøjay Jesusis myama María: ―Cøma'nøyø; yøṉ une cyø'vej Diosis va'cø yaj quecyajø vøti Israel pønda'm; o si no, va'cø yac te'nchu'nyajø. Y mi une señate pero vøti pø'nis maṉba cyø'o'nøyaje. ");
INSERT INTO zosNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mi uneṉgøtoya maṉba mi ñu'cay toya mi ne' mi ndzoco'yomo maya'cu'is como si fuera cuchillo'is tø ju'tzpase. Mumu yøcse maṉba tuqui va'cø cyeja ti qui'psyajpa vøtita'mbø pø'nis choco'yomda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Itque'tutina'ṉ jeni tza'maṉvajcopyapø ñøyipø'is Ana, Fanuejlis 'yune, Asejris tyøvø'ombø. Tzamyomoco'nina'ṉ. Después que papiñomo, oy it jyayaji'ṉ cu'yay ame. ");
INSERT INTO zosNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Y yaṉbajcaju ochenta y cuatro ame. Ji'na'ṉ pyut masandøjcomo, y yosay Dios tzu'ji'ṉ jamaji'ṉ; y jyana uqui jana cu'ti 'yo'nøpyana'n Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jicsye'cti misma hora nu'c tzamyomo y ñøjmay Dios yøscøtoya, y cha'maṉvajcayaj mumu nø jyo'cyajupø'is Yajcotzocpapø'is Jerusalén gumgupyøn. Cha'maṉvajcayaj je nø jyo'cyaju'is jujche maṉbase it Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jose'is y Maria'is chøcyaju como ijtuse jachø'yupø ndø Comi'is 'yaṉgui'mgu'yomo, y vitu'yaj Galilea nasomo y nu'cyaj Nazaret cumgu'yomo; porque ne'c jej cumguy. ");
INSERT INTO zosNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y une Jesús nømna'ṉ myøja'aju, y masamna'ṉ nø pyømi'øyu, y nømna'ṉ qui'psocu'yøyu, y vøti nømna'ṉ cyotzoṉ Diosis. ");
INSERT INTO zosNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tumdum amepit oyajpana'ṉ Jesusis jyatata'm Jerusalén gumgu'yomo cuando ijtuna'ṉ Israel pø'nista'm syøṉ ñøyipø'is pascua. ");
INSERT INTO zosNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cuando ta'nu'jcam macvøstøjcay Jesusis 'yame, oyaj møjmø Jerusalén gumgu'yomo søṉ jama'omo como ijtusena'ṉ cyostumbre. ");
INSERT INTO zosNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cuando cøyaj søṉ, vitu'yaj ñe'cta'm, y tzø'y une Jesús Jerusalén gumgu'yomo sin quena'ṉ ji'n myusyaj Jose'is y myama'is o'ca jiṉ tzø'yu. ");
INSERT INTO zosNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Como nømna'ṉ cyomo'yaju que jendina'ṉ nø myinuse vøtipø'nomo, tumø jama tu'ṉayaju. Pero cuando min mye'chaje tyøvø'omo y nø ispøcyajtøjpapø'omo, ");
INSERT INTO zosNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ja pya'tyaj Jesús ni juti. Entonces jiṉdi vitu'yajque'tu, maṉ mye'chaje Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Y tu'cay jamapit mye'tzpa'tyaju Jesús masandøjcomo, jenna'ṉ po'csu aṉma'yoyajpapø'is cyujcomo. Jesusis nømna'ṉ cyøma'nøyaju, y nømna'ṉ 'yocva'cyaju anma'yoyajpapø. ");
INSERT INTO zosNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mumu cyøma'nøyaju'is nømna'ṉ ñømaya'jayaj qui'psocuy y 'yandzo'ṉocuy. ");
INSERT INTO zosNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cuando jyata'ista'm isyaju'cam, ñømaya'yaju, y ñøjmay Jesús myama'is: ―Ø mi une, ¿ti'ajcuy jetse mi ndø yac maya'tamu? Øtz nø maya'cøndamu mi jandaji'ṉ; øtz nø mi me'tztamu. ");
INSERT INTO zosNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Y Jesusis ñøjmayu: ―¿Ti'ajcuy nø mi ndø me'tztamu? ¿Ti'ajcuy ji'n mi mustame o'ca øtz ø Janda'is yoscuy tiene que va'cø ndzøjcayø? ");
INSERT INTO zosNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero je'is ja cyønøctøyøyajø ticøtoya jetse chamu. ");
INSERT INTO zosNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pero Jesús maṉyaj Joseji'ṉ y Mariaji'ṉ Nazaret cumgu'yomo, y Jesusis nømna'ṉ cyøna'tzøyaj jyata y myama. Y myama'is jyamdzø'pyana'n choco'yomo mumu jujche tujcuse. ");
INSERT INTO zosNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Y Jesús masna'ṉ nø qui'psocuminu y masna'ṉ nø myøja'aju; y syungomø'ñajpana'ṉ Diosis y pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yøjtay amena'ṉ møja aṉgui'mba Tiberio mumu cumguy, jicsye'cti angui'gue'tpana'ṉ Poncio Pilato Judea nasomo. Herodes aṉgui'mgue'tpana'ṉ Galilea nasomo; y Herodesis tyøvø Felipe aṉgui'mgue'tpatina'ṉ Iturea nasomo y Traconite nasomo. Y Lisanias aṉgui'mbana'ṉ Abilinia nasomo. ");
INSERT INTO zosNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Y Anás y Caifás pane covi'najøna'ṉ. Jicsye'c Diosis 'yo'nøy Zacariasis 'yune Juan cuando jya'ijnømømøna'ṉ ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan maṉ vit ribera'omda'm tome ijtumø Jordán nø', y chajmayaj pønda'm va'cø qui'psvitu'yajø y va' ñø'yøyajø, va'cø yaj cotocojayaj cyoja Diosis. ");
INSERT INTO zosNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tujcu jujche ijtuse jachø'yupø tza'maṉvajcopyapø Isaiasis libru'omo. Libru'omo nømba: Nø vyejnøm ja ijnømømø, nømba: “Como ndø vøjøtzøjcatyambase møjatuṉ va'cø min tum møja'ṉ aṉgui'mbapø, jetse vøjøtzøctaṉque't mi ndzocoy porque maṉba min ndø Comi. Tiene que va' ndø viyuṉdzøc tyuṉ; ");
INSERT INTO zosNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","mumu noṉchøqui va' ndø umbare'ajø; mumu quetza mumu qui'mø va' ndø parejo tzøctamø; tuṉ vo'tita'mbø va' ndø viyuṉdzøctamø; ji'n vyøjpø tuṉ va' ndø vøjøndzøctamø. Jetseti mi sundaṉgue'tpa va' mi vøjøndzøctam mi ndzocoy. ");
INSERT INTO zosNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mumu pø'nis maṉba isyaj tø Yajcotzocpapø'is Diosis maṉbapø cyø'veje”. ");
INSERT INTO zosNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nømna'ṉ ñu'cyaj sonepøn va' ñø'yøyaj Jua'nis. Jua'nis ñøjmayaju: ―Tzanse mi yandzita'm mijta'm. ¿Ti'ajcuy mi ṉgui'pstamba o'ca muspa mi mbyotyamø va' jyana mi ṉgyastigatzøctam Diosis cuando qui'syca'pa ñe'cø? Ji'n mus mi mbojyatyam Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tzøctam vøjpø tiyø jujche syunbase cuando mi ṉgyi'psvitu'tamu'jcam. Y uy mi ṉgui'pstzo'tztam mi ndzoco'yomda'm que ma mi ṉgyotzoctame porque Abraham mijtzi mbeca jata tzu'ṉgutya'm. Porque øjtzø mi nøjmambya que yøṉø tza' muspa Diosis yac pønvitu'yajø va'cø Abrahamis 'yune'ajyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Como tum pøn listo jacha cyø'omo va' tyøṉbø' cuy, y va' pyatzpø' juctyøjcomo o'ca ji'n tø'møyi; jetse Dios listo yøti va'cø cyastigatzøcyaj mumu pøn ji'n chøquipø'is vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Y vøti pø'nis 'yocva'cyaj Juan: ―¿Jujche vøjø va' ndzøctamø? ");
INSERT INTO zosNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y 'yaṉdzoṉ Jua'nis ñøjmayaju: ―Ijtupø'is tyucu metzcuy, vøj va'cø vya'ctzi' ja ityøpø'is ñe'; y ijtupø'is cyu'tcuy, jetseti va' vya'ctzi'que'ta. ");
INSERT INTO zosNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Y nu'cyajque'tuti gobierno'is cyobratzøcyajpapø va'cø ñø'yøyajø, y ñøjmayaj Juan: ―Maestro, ¿jujche vøjø va' ndzøctamø? ");
INSERT INTO zosNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Y Jua'nis ñøjmayaju: ―Lo que myarcatzøcpacsye'ṉomo aṉgui'mba'is, jeñche'ṉomdi va'ctamø. U mi ṉgocøjtamu. ");
INSERT INTO zosNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","'Yocva'cyajque'tuti soldado'is: ―Y øtzta'm, ¿jujche vøjø ndzøctamø? Y ñøjmayaj Jua'nis: ―Uy mi ndzøcna'tztam ni iyø, ni u mi ṉgøsujtzatyam ni iyø va'cø mi ngønu'mdamø. Y conforme'ajtamø mi ṉgyoyojtandøjpase. ");
INSERT INTO zosNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mumu pø'nis nømna'ṉ jyo'cyaju Cristo, y choco'yomo nømna'ṉ qui'psyaju oca Juanamete Cristo. ");
INSERT INTO zosNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero Jua'nis ñøjmayaj mumu pøn: ―Øjtzi viyuṉsye mi nø'yøndyamba nø'ji'ṉ, pero maṉba mini mapø'is mi ñø'yøñdyam Masanbø Espiritu Santoji'ṉ y juctyøcji'ṉ. Jet más pømi'øyupø que ji'n øjtzi. Hasta va'cø chøjcay nu'csocuy jic myøja'ṉombø pøngøtoya, syunba mas vøjpø pøn que ji'n øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Como tum pøn ñø'ijtu'is cyø'om yemguy listo va'cø cyøsujø trigo pyuj va'cø pyuj ñaca, jetse je maṉbapø mini, je'is maṉba cyøpinyaj pøn. Y como vøjpø pyuj ndø tu'mba va'cø ndø aṉne'ṉga, y ñaca ndø pyøṉbø'japya, jetse je'is maṉba yac tu'myaj vøjta'mbø pøn tyøjcomo, y yatzita'mbø maṉba pyonbø'yaj ji'n tu'yipø juctyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jetse y vøti eyapø otejiṉ Jua'nis chajmayaj pønda'm vøjpø ote. ");
INSERT INTO zosNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jicsye'jcam Jua'nis 'yojnay aṉgui'mbapø Herodes porque Herodesis ñø'ijtayuna'ṉ tyøvø Felipe'is yomo. Yomo ñøyipø'is Herodías. Y Jua'nis 'yojnacye't Herodes mumu eyata'mbø yatzi tzøquipit lo que chøjcupø. ");
INSERT INTO zosNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero Herodesis chøjcaṉøy más yatzipø tiyø porque yac somdøj Juan preso'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pero antes que va' yac somdøj Juan, cuando mumu pønda'm nø'yøyaju, también Jesús nø'yøcye'tu. Y mientras que Jesusis nømna'ṉ 'yo'nøy Dios, aṉvac tzap. ");
INSERT INTO zosNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Y mø'n Masaṉbø Espiritu Santo Jesuscøsi como palomase quenbapø. Y mandøj ote tzajpomo nømupø: ―Mijtzi øjtze mi Une; øtz mi sunbapø chøṉø; mitzcøtoya casøpyøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús nømna'ṉ myaṉ como treinta ame cyando yoscho'tzu. Cyo'moyajpana'ṉ que Jesús Jose'ise 'yune, y José Eli'is 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matajtis 'yunena'ṉete, Matat Levi'is 'yunena'ṉete, Leví Melqui'is 'yunena'ṉete. Melqui Jana'is 'yunena'ṉete, Jana Jose'is 'yunena'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatiasis 'yunena'ṉete, Matatías Amosis 'yunena'ṉete, Amós Nahu'mis 'yunena'ṉete, Nahum Esli'is 'yunena'ṉete, Esli Nagai'is 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maajtis 'yunena'ṉete, Maat Matatiasis 'yunena'ṉete, Matatías Semei'is 'yunena'ṉete, Semei Jose'is 'yunena'ṉete, José Juda'is 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joana'is 'yunena'ṉete, Joana Resa'is 'yunena'nete, Resa Zorobabejlis 'yunena'ṉete, Zorobabel Salatiejlis 'yunena'ṉete, Salatiel Neri'is 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui'is 'yunena'ṉete, Melqui Adi'is 'yunena'ṉete, Adi Cosa'mis 'yunena'ṉete, Cosam Elmoda'mis 'yunena'ṉete, Elmodam Ejris 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josue'is 'yunena'ṉete, Josué Eliezejris 'yunena'ṉete, Eliezer Jori'mis 'yunena'ṉete, Jorim Matajtis 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Levi'is 'yunena'ṉete, Leví Simeo'nis 'yunena'ṉete, Simeón Juda'is 'yunena'ṉete, Judá Jose'is 'yunena'ṉete, José Jona'nis 'yunena'ṉete, Jonán Eleaqui'mis 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea'is 'yunena'ṉete, Melea Maina'nis 'yunena'ṉete, Mainán Matata'is 'yunena'ṉete, Matata Nata'nis 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán Davijdis 'yunena'ṉete, David Isai'is 'yunena'ṉete, Isaí Obejdis 'yunena'ṉete, Obed Boozis 'yunena'ṉete, Booz Salmo'nis 'yunena'ṉete, Salmón Naaso'nis 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadajbis 'yunena'ṉete, Aminadab Ara'mis 'yunena'ṉete, Aram Esro'mis 'yunena'ṉete, Esrom Faresis 'yunena'ṉete, Fares Juda'is 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacojbis 'yunena'ṉete, Jacob Isaajquis 'yunena'ṉete, Isaac Abraha'mis 'yunena'ṉete, Abraham Tare'is 'yunena'ṉete, Taré Nacojris 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serujguis 'yunena'ṉete, Serug Ragau'is 'yunena'ṉete, Ragau Pelejguis 'yunena'ṉete, Peleg Hebejris 'yunena'ṉete, Heber Sala'is 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Caina'nis 'yunena'ṉete, Cainán Arfaxajdis 'yunena'ṉete, Arfaxad Se'mis 'yunena'ṉete, Sem Noe'is 'yunena'ṉete, Noé Lamejquis 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec Matusale'nis 'yunena'ṉete, Matusalén Enojquis 'yunena'ṉete, Enoc Jarejdis 'yunena'ṉete, Jared Mahalaleejlis 'yunena'ṉete, Mahalaleel Caina'nis 'yunena'ṉete, ");
INSERT INTO zosNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Enosis 'yunena'ṉete, Enós Sejtis 'yunena'ṉete, Set Ada'nis 'yunena'ṉete, Adán Diosis 'yunena'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús ñø'itpø' Masanbø Espiritu Santo'is, y jetse tzu'ṉ Jordán nø'omo y oy ñømaṉ Espiritu'is ja ijnømømø. ");
INSERT INTO zosNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jen o it cuarenta jama. Yatzi'ajcu'is nømna'ṉ syun chøjquis a ver jujchena'ṉ muspa yac tocoya. Jesusis ja cyu't ni tiyø jic jama. Cøjtu'jcam cuarenta jama, nømna'ṉ 'yosu. ");
INSERT INTO zosNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jicsye'c yatzi'ajcu'is ñøjayu: ―O'ca mijtzete Diosis 'yune, nøjay yøṉø tza' va'cø yac pa'najø. ");
INSERT INTO zosNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesusis 'yaṉdzoṉu ñøjayu: ―Ji'nø maṉ mbandzøqui, porque it Diosis 'yote jachø'yupø, nømba: “Aunque it jyamacøtcuy, saṉ jetji'ṉ ji'n queñaj pøn; sino syunba mumu lo que chambapø ote Diosis, jetji'ṉ va'cø cyeñajø”. ");
INSERT INTO zosNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Y ñømaṉ yatzi'ajcu'is ye'ṉupø cotzøjcøsi y isindzi' usyaṉ oracøsi mumu cumguy ijtuse nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y ñøjay yatzi'ajcu'is: ―Maṉbø mi yac møja'ṉomaje, ma'ṉbø mi yac angui'm hasta vindujcu'csye'ṉom cumguy, porque aṉgui'mguy øjtze ne', y ndzi'pøjtzi i su'nbø ndzi'ø. ");
INSERT INTO zosNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","O'ca mitz ndø cujnejapya y mi ndø cøna'tzøpya, jetse mumu aṉgui'mguy mijtze ne'. ");
INSERT INTO zosNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero Jesusis ñøjayu: ―Tzu'ṉ øtzcø'mø mijtzi Satanás, ji'nø mi ṉgøna'tzøyi porque jachø'yupøte Dios libru'omo; nømba: “Cøna'tzøy mi Ṉgomi Dios y solo jete muspa mi ⁿyosayø”. ");
INSERT INTO zosNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Entonces yatzi'ajcu'is ñømaṉ Jesús Jerusalén gumgu'yomo y ñøqui'm møji Israel pø'nis myasandøc torrecøsi, y ñøjmayu: ―O'ca mijtzete Diosis 'Yune, tøjmø'nø nasomo. ");
INSERT INTO zosNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Porque jachø'yupøte Diosis libru'omo: Diosis ṉgyø'vejayajpa ñu'cscuy va' mi ṉguendatzøcyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Cyø'omo maṉba mi ñømaṉyaje va' jana mi ñejpinduc ni tza'cøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesusis ñøjayu: ―Ji'n ø tøjmø'ni porque chamupøte Diosis libru'omo: “Uy mi ndzøjquis mi Ṉgomi Dios o'ca maṉba chøqui como chambase”. ");
INSERT INTO zosNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Yatzi'ajcu'is mumu jetse nømna'ṉ sun yac toco'is Jesús. Jicsye'c chajcu para eya jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús vitu' Galilea nas co'aṉjajme'omo, más pømitzi' Masanbø Espiritu Santo'is. Mumu nasvindumø tzamdøju lo que ti chøc Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Y Jesús aṉma'yopyana'ṉ conocscuy tøjcomda'm, y mumu pønis vyøpøpøngotzøcyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Y Jesús nu'c Nazaret cumgu'yomo jujna'ṉ chojcumø, y sa'pøjcuy jama'omo, como ijtuse cyostumbre, tøjcøy conocscuy tøjcomo y te'ñchu'ṉu va'cø tyu'nayaj toto. ");
INSERT INTO zosNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Y chi'yaj Jesús tza'maṉvajcopyapø Isaiasis libru, y Jesusis 'yaṉvajcu y pya'tu jujna'ṉ it yøcse jachø'yuse: ");
INSERT INTO zosNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ndø Comi'is Espiritu øtzji'ṉbøte. Porque je'tis cøpi'ṉøjtzi y tzi'ø aṉgui'mguy va'cø ndzajmay pobreta'mbø pøn vøjpø ote; Cø'vejøjtzi va'cø yac tzi'ṉbøyaj maya'yajpapø; va'cø ndzajmayaj preso'omda'mbø que maṉba putyaje; va'cø ndzajmayaj to'tita'mbø que maṉba isoyaje; va'cø maṉ ṉgotzoṉyaj yacsutzøcyajtøjupø. ");
INSERT INTO zosNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Cø'vejøjtzi va'cø ndzamsajø que nøm ñu'c hora va'cø tø toya'ṉøtyam ndø Comi'is. ");
INSERT INTO zosNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jenche'nom tyu'nu. Entonces Jesusis 'yaṉga'm libru y chi'vitu'u cyotzoṉbapø'is y po'csquejcu. Y ityajupø'is conocscuy tøjcomo nømna'ṉ 'ya'myaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Y Jesúsis ñømdzo'tzayaju: ―Yøtipø jama nøm tyujcu lo que yø'c jya'yøyuse, lo que mi mandamuse. ");
INSERT INTO zosNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mumu pø'nis nømn'aṉ vyøpøpøngotzøjcyaj Jesús, y nømna'ṉ ñømaya'comø'nayaj sunita'mbø ote lo que chambana'ṉ Jesusis. Nømyajpana'ṉ: ―Yøṉ Jose'isti 'yune y, ¿jutznøm muspa cham jetsepø ote? ");
INSERT INTO zosNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Y Jesusis ñøjayaju: ―Maṉbocsyo mi ndø nøjay chamdøjpase: “O'ca mi ncho'yø'opyapøte, tzo'yøcye'tati mi ⁿvin”. Y maṉba mi ndø nøjacye'te: “Mumu tiyø mandamupø mi ndzøjcupø Capernaum gumgu'yomo, tzøjque'tati yø'qui mi ne' ṉgumgu'yomo”. ");
INSERT INTO zosNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y ñøjayajque't Jesusis: ―Viyuṉsye mi nøjmambya, que ni jutipø tza'maṉvajcopyapø ji'n pyøjcøchoṉdøj ñe' cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Viyuṉsye mi nøjañdyamba que vøti ityajuna'ṉ yaṉbac yomo Israel nasomo cuando tza'maṉvajcopyapø Elías ijtuna'ṉ, cuando ja oy quec tuj tu'cay ame medio, y oy møja'ṉ yu' tumø nas. ");
INSERT INTO zosNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero Diosis ja cyø'vej Elías ni jutipø yaṉbac yomocøsi Israel nasomo, sino cyø'vej emøc tum yaṉbac yomocøsi Sarepta cumgu'yomo tome Sidón gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Vøtina'ṉ itcomø'ñaj ñø'ijtu'is yachputzi ca'cuy ñøyipø'is lepra Israel nasomo cuando tza'maṉvajcopyapø Eliseo ijtuna'ṉ, pero ni jutipø ñe'comda'm ja yac tzoca, sino tum pøn Siria nasombø, ñøyipø'is Naamán, jet yac tzojcu. ");
INSERT INTO zosNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jicsye'c mumu ityajupø'is conocscuy tøjcomo qui'syca'comø'ñaju myañaju'jcam jetseta'mbø tiyø, (que emøcta'mbø pøn chø'yøyaju). ");
INSERT INTO zosNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Entonces te'nchu'ṉyaju y ñøputyaj Jesús cumgu'acapoya y ñømaṉyaju lomacøsi va'cø pyatzmø'ñaj quetza'omo, porque cyumguy lomacøs ijtuna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero Jesús cujqui cøjtu ijtyajumø ñe'cta'm y maṉu. ");
INSERT INTO zosNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús mø'n Capernaum gumgu'yomo Galilea nas co'aṉjajme'omo, y aṉma'yopyana'ṉ sapøjcuy jama'omda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y ñømaya'yajpana'ṉ jujche aṉma'yopya Jesús, porque chambana'ṉ como más ñø'ijtupø'se aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ijtuna'ṉ tum pøn conocscuy tøjcomo ñø'ijtupø yatzi'ajcu'is. Joviti vejte'n pømi. Ñøjay Jesús: ");
INSERT INTO zosNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Tzactandøvø, ¿tiyø cuenta mi ndø pa'jtamba? Mijtzi Jesús Nazaret cumgupyøn. ¿Mi minu va' mi ndø ⁿyajtamø? Øtz mi ispøcpøjtzi, mijtzete Diosis Masanbø mi Mbyøn. ");
INSERT INTO zosNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Entonces Jesusis 'yojnay yatzi'ajcuy y ñøjayu: ―Vøṉñeyø; tzac je pøn. Jicsye'c yatzi'ajcu'is yaj quec pøn vøti pøngujqui, y chajcu; ni tiyø toya ja chøcø. ");
INSERT INTO zosNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mumuti maya'yaju y na ñøjayajtøjpana'ṉ: ―¿Tiyø ote yøṉø? Ijtu 'yaṉgui'mguy y pyømi'ajcuy va'cø 'yaṉgui'myaj yatzi'ajcuy. Porque yatzi'ajcu'is ñø'ityaj pøn y je'is yac tzacyajpa 'yoteji'n. ");
INSERT INTO zosNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aunque juti tumø cumguy tzamdøju ti chøc Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jicsye'c te'nchu'ṉ Jesús y put conocscuy tøjcomo, y tøjcøy Simo'nis tyøjcomo. Jiṉna'ṉ ijtu Pedro'is myo'ot mama, y na'maṉna'ṉ ñutzø. Y vya'cayaj Jesusis pyasencia'ajcuy va'cø yac tzoca. ");
INSERT INTO zosNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Y Jesús atzcøne'c ca'epøcøsi y 'yoteji'ṉdi yaj cøjtay ñutzø. Jicsye'cti te'nchuṉ ca'epø y mismo ñe'c ca'epø yoscho'tzu, chøc cutcuy eyata'mbøcøtoya. ");
INSERT INTO zosNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jamdyø'pø'omo ñømijnayajpana'ṉ Jesús mumu aunque jujchepø ca'cuy ñø'ijtupø'is. Y Jesusis cyotpana'ṉ cyø' tumdum ca'epøcøsi y yac tzocyajpana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Y chacyajpatina'ṉ yatzi'ajcu'is vøti pøn, y yatzi'ajcuy vejyajpana'ṉ: ―Mijtzete Diosis 'Yune. Y Jesusis 'yojnayajpana'ṉ yatzi'ajcuy, ji'na'ṉ yac oñaje, porque yatzi'ajcu'is myusyajpana'ṉ que jetemete Cristo Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Entonces jyo'pit sø'ṉbønømu'jcam, tzu'ṉ Jesús y maṉ ni i jya'ityømø. Y vøti pø'nis o mye'chaje, y nu'cyaj Jesuscø'mø. Y pø'nista'm ji'na'ṉ syun yac maṉyaj Jesús emøc. ");
INSERT INTO zosNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Jesusis ñøjmayaju: ―Eyata'mbø cumgu'yomo tiene que va'cø ndza'maṉvajque't vøjpø ote jujche aṉgui'mbase y tø coquenbase Diosis. Porque jetcøtoyatze cø'vejtøju. ");
INSERT INTO zosNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jesusis cha'maṉvajcayajpana'ṉ aṉgui'mbase Dios conocscuy tøjcomda'm Galilea nas co'aṉjajme'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tumgojama'omo Jesús te'n Genesaret majraṉvini. Entonces jen cyøtu'mayaj vøti pø'nis va'cø cyøma'nøjayaj Diosis 'yote; hasta tyonavityaj jeni Jesusis vyi'nomo. ");
INSERT INTO zosNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesusis is metzcuy barco tome nø'aṉvini. Ataraya pønda'm putyaju'jcam y nømna'ṉ cyøtze'yaj 'yataraya. ");
INSERT INTO zosNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tøjcøy Jesús Simo'nis byarco'omo, y ñøjay Simón va' cyot barco usta'm más jyøṉumø. Jesús po'cs barco'omo y nømna'ṉ 'yaṉmayaj vøti pøn nascøs ityajupø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cha'maṉjeju'jcam, ñøjmay Simón: ―Cojtam barco más jyøṉumø y pajtzøtyam mi ataraya va' mi nuctam coque. ");
INSERT INTO zosNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","'Yaṉdzoṉ Simo'ṉis: ―Øjchøṉ mi Maestro, cøtitzu'am yosta'møjtzi y ni tiyø ja ñucta'møjtzi. Pero mbyajtzøpyøjtzi ataraya o'ca mi ndø nøjambya. ");
INSERT INTO zosNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Chøcyaj jujche chajmayajuse Jesusis, y ñucyaj vøti coque hasta jacto'pacsye'ṉomo 'yataraya. ");
INSERT INTO zosNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chøjcayaj seña eyata'mbø tyøvø ityajupø eyapø barco'omo va' min cyotzoṉyajø. Y miñaju y piṉdasyaj mye'chcøy barco, hasta que cøvøṉyajto'pacse'ṉomda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Cuando Simón Pedro'is isu'øc jujche tujcuse, cutcøne'c Jesuscø'mø; y Pedro'is ñøjmay Jesús: ―Tzu'ṉ øtzcø'mø, ø mi Ṉgomi, porque øtz cojapa'tupø pøn chøṉø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Porque Pedro y mumu ñe'cji'ṉna'ṉ ityajupø nømna'ṉ ñømaya'comø'ñaju vøtipø coque ñucyajupø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jetseti nømna'ṉ ñømaya'yajque't Jacobo'is y Jua'nis. Jacobo y Juan Zebedeo'is 'yune, y Simo'nis ñøtuṉ. Y Jesusis ñøjay Simón: ―Uy mi ña'ndzu; desde yøti maṉba mi ṉgacpø' mi ⁿyoscuy. Antes que va' mi ṉgyoquenuqui, maṉba mi ñømiñaj pøn øtzcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Entonces ñøputyaj barco playa'omo, cøyindzacpø'yaj mumu tiyø, y maṉ pya'tyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tum cumgu'yomo ijtu'øc Jesús, nu'c tum pøn ñø'ijtupø'is yachputzi ca'cuy ñøyipø'is lepra. Cuando is Jesús, japcøne'c nascøsi va'cø cyøna'tzøyø, y ñøjayu: ―Øjchøṉ mi Ṉgomi, mitz it mi musocuy va'cø mi ndø yac tzoca, o'ca suṉba mi ndø yac tzoca. ");
INSERT INTO zosNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Entonces Jesusis yac mø'n cyø' y pi'quisu, ñøjmayu: ―Su'nbøjtzi va'c mi ñchoca; yøti mi ⁿyac tzocpøjtzi. Jicsye'cti tzoc je putzi'øyupø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pero Jesusis ñøjayu va' jyana tzajmay ni 'iyø, y ñøjmayu: ―Pero mavø ma isindzi' pane que mi ñchojcu'am, y tzi'ø lo que chamuse Moisesis va'cø mi ndzi'ø cuando mi ⁿvyø'aju'jcam. Jetse tzøcø va'cø myusyaj pø'nis que mi ñchojcu'am. ");
INSERT INTO zosNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero jicsye'c aunque jujna'ṉ más tzajmayajtøju lo que nømna'ṉ chøc Jesusis. Y cyøtu'myajpana'ṉ vøti pø'nis va'cø cyøma'nøyajø y cya'cuy va' yac tzojcayajø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero Jesús opyana'ṉ jya'ijnømømø va'cø 'yo'nøy Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Y tujcu tumgojama que Jesús nømna'ṉ 'yaṉma'yoy tøjcomo. Y Israel pø'nomo ityajuna'ṉ veneta'mbø ñøyipø'is fariseo. Fariseota'm y anma'yoyajpapø aṉgui'mgupit jena'ṉ po'csyaju, y ityajuna'ṉ aunque jujta'mbø cumgu'yomo tzu'ṉyajupø. Tzu'ṉyaju Galilea nasomo, y Judea nasomo, Jerusalén gumgu'yomo. Y Jesusis ñø'it ndø Comi Diosis milagro'ajcuy va'cø yac tzojcoya. ");
INSERT INTO zosNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y tum pøn ji'n musipø vitø tyøvø'is nømna'ṉ ñømiñaj tze'schøquicøsi. Mye'chajpana'ṉ va' ñøtøjcøyaj tøjcomo va' cyojtayaj Jesusis vyi'nomo. ");
INSERT INTO zosNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero ja pya'tyaj jut va'cø ñøtøjcøyaj tøjcomo, porque tas tøc vøti pø'nis. Entonces qui'myaj møji tøjcøsi y piṉbø'yaj teja, y jen jyø'mø'ñaj tze'scøsi pøn ca'epø va'cø ñu'c cujcomo ijtumø Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Cuando is Jesusis que nømna'ṉ vya'ṉjamyaju, ñøjmay ca'epø: ―Tzambøn, mi nchø'pya cøvajcupø mi ṉgojaji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jicsye'omo aṉma'yoyajpapø aṉgui'mgupit y fariseota'm na ñøjayajtøju: “¿Ipø pøn acsque't? ¿Ti'ajcuy chamba vyin como Dios siendo ji'ndyet jicø? Jetse nø cyø'o'nø'oyu porque ni i's ji'n mus yaj cøtocojay coja sino sólo Diosis myuspa”. ");
INSERT INTO zosNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesusis myusu lo que jujche qui'psyajupø ñe'cta'm, y 'yaṉdzoṉyaju: ―¿Ti'ajcuy jetse mi ṉgui'pstamba que øtz nø topo'onu? ");
INSERT INTO zosNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jutipø más fácil, va' tø ṉomø: “Mi nchø'pya cøvajcupø mi ṉgojaji'ṉ”, o va'cø tø nømø: “Te'nchu'nø y ca'ṉbø'ø”? ");
INSERT INTO zosNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pero ma'ṉbø mi isindzi'tame que øjtzi mumu Pø'nis chøṉ Tyøvø nø'ijtøjtzi aṉgui'mguy yøṉø nascøsi va'cø ⁿyaj cøtocojayaj pø'nis cyoja. Jicsye'c Jesusis ñøjmay ji'n musipø vitø: ―Mitzø mi nøjmambyøjtzi: te'nchu'nø, piṉ mi øṉguy, y mavø mi ndøcmø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Misma hora te'nchu'ṉ mumu pø'nis vyi'naṉdøjquita'm, y pyin 'yøṉupøcøsna'ṉ, y vyøcotzøcpa Dios maṉ tyøcmø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Maya'yaj mumu y vyøcotzøcyaj Dios, y mumuna'ṉ na'chaj vøti, nømyaju: ―Ndø istamu yøti maya'cuy ji'n ndø istamepø nunca. ");
INSERT INTO zosNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jisye'omo Jesús a'ṉgomo pujtu y is tum pøn gobierno'is yaj cobratzøjcopyapø ñøyipø'is Leví. Mesacø'mna'ṉ po'csu cyoyojoñømbamø, y ñøjmay Jesusis: ―Mi tø nøtu'ṉajø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Y cøyindzacpø' mumu, te'nchu'ṉu, y maṉ pya'te. ");
INSERT INTO zosNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Entonces Levi'is chøjcay møjasøṉ Jesuscøtoya tyøjcomo. Y itcomø'ñajuna'ṉ cobratzøjcoyajpyapø y eyata'mbø ñe'cji'ṉ po'csyajupø mesacø'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Y fariseo'sta'm y aṉma'yoyajpapø'is aṉgui'mgupit 'yojnayaj Jesusis ñøtundøvø, ñøjmayaju: ―¿Ticotoya mi ṉgyu'jtu'mdamba y mi ⁿ'yuctu'mdamba cobratzøjcoyajpapøji'n y cojapa'tyajupøji'ṉ? ");
INSERT INTO zosNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pero Jesusis ñøjmayaju: ―Como sa'sapø pø'nis ji'n syun doctor va'cø cho'yøtyøjø, sino ca'epø'is syunba médico; jetse ji'ndyet pyena va'cø ndø tzajmayaj vøjta'mbø pøn va'cø qui'psvitu'yajø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Por eso ja myi'nøjtzi va'cø ndzajmayajø vøjta'mbø pøn ja ityøpø'is cyoja va'cø qui'psvitu'yajø, sino mi'nøjtzi va'cø ndzajmayaj cojapa'tyajupø va'cø qui'psvitu'yajø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jicsyomo ñøjmayaj Jesús: ―¿Ticøtoya Jua'nis ñøtuṉdøvø ji'n cu'tyaje, ji'n ucyaje, mientras que cyonocsyajpa'csye'ṉomo; y jetsetique't fariseo'is ñe'ta'mdi chøcyajque'tpa; mientras mi ne'nda'm mi nønduṉdøvø cu'tyajpa ucyajpa mumu jamasye? ");
INSERT INTO zosNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesusis ñøjmayaju: ―Como nø cyo'tøjcajupø pø'nis 'yamigota'm tiene que va' cyu'tyajø y va' 'yucyajø mientras pøn mapø co'tøjcaje jen it jetji'ṉda'm, jetsetique't ø nønduṉdøvø cu'tyajpa ucyajpa mientras øtzji'ṉ ityaju. ");
INSERT INTO zosNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero o'ca minba jyama cuando pøn mapø co'tøjcaje yac tzu'ṉdøjpa, jic jama 'yamigota'm ji'n ma cu'tyaje ji'n ma ucyaje. Jetsetique't øtzque't; cuando øchac tzu'ṉdøjque'tpøjtzi, ø nønduṉda'm ji'n ma cu'tyaj ucyajque't jic jama. ");
INSERT INTO zosNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Entonces Jesusis 'yaṉmayaj historiaji'ṉ; nømu: ―Ni i'is ji'n jyacput jome tucu va' pya'jna'c peca tucucøsi. Jetse jomepø tucu tocopya y jome pa'jna'c ji'n chø'y vøjø pecapø tucuji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni i'is ji'n titpø' jomepø uvanø' pecapø naca cojtocu'yomo. Va' chøc jetse, uvanø' fermentatzøcpa y tzitzpa naca cojtocuy y uvanø' tecpø'pa y cojtocuy tocopya. ");
INSERT INTO zosNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero jomepø uvanø' jome cojtocu'yomo ndø cotpa, y ji'n tocoy ni jutipø. ");
INSERT INTO zosNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Después que tyo'ṉisu'cam peca vinu, ni i'sam ji'n maṉ sun tyo'ṉ jome vinu, porque maṉba nømi: “Pecapø más omba”. ");
INSERT INTO zosNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tum sapøjcuy jama'omo Jesús nømna'ṉ cyøtyaj trigo cama'omo. Nøtuṉdøvø'is nømna'ṉ tyucyaj tumgø'acu, y chicyaj cyø'ji'ṉ, y cyu'tayaj pyuj. ");
INSERT INTO zosNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pero veneta'mbø fariseo va'ṉjajmocuy ñø'ityaju'is ñøjayaj Jesusis ñøtuṉdøvø: ―¿Ti'ajcuy mi ndzøctamba jetse sapøjcuy jama'omo? Porque it aṉgui'mguy jana ndø tzøc jetse sapøjcuy jama'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Entonces Jesusis 'yaṉdzoṉyaju fariseo va'ṉjajmocuy ñø'ityajupø'is; ñøjmayaju: ―¿Nunca ja mi ndu'ndamøtija ti o chøc Davijdis cuando nømna'ṉ 'yosyaj ñøtuṉdøvøji'ṉ? ");
INSERT INTO zosNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Porque David oy tøjcøy Diosis tyøjcomo, pyøc cømasa'nøyupø pan, y cyø'su; y chi'yaj ñe'cji'n ityajupø. Pero jej pan pane'istina'ṉ muspa cyø'sø. ");
INSERT INTO zosNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesusis ñøjayajque'tu: ―Øtz mumu Pø'nis chøṉ Tyøvø aṉgui'mbøjtzi ti muspa ndø tzøc sapøjcuy jama'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Eyapø sa'pøjcuy jamacøsi Jesús tøjcøy conocscuy tøjcomo, y jen nømna'n 'yaṉma'yoyu. Jeni ijtuna'ṉ tum pøn tøjtzupø'is chø'naṉgø'. ");
INSERT INTO zosNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Y aṉgui'mguji'ṉ aṉma'yoyajpapø pø'nis y fariseo'ista'm 'ya'myajpana'ṉ a ver o'ca yac tzocpana'ṉ Jesusis sapøjcuy jama'omo, Sunbana'ṉ pya'tayaj cyoja va'cø cyøva'cøyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesusis myusuna'ṉ que ti nø qui'psyaju choco'yomo, y ñøjay pøn tøjtzupø'is cyø': ―Te'nchu'ṉø, y tzø'y te'nupø cujcomo. Y je pøn te'ndontzu'ṉu y jen te'nu. ");
INSERT INTO zosNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jicsyomo ñøjmay eyata'mbø: ―Tø tzajmay ndøvø o'ca vøj sapøjcuy jamacøsi va' ndø tzøc vøjpø tiyø o ji'n vyøjpø; o'ca vøj ndø yaj cotzoca; o'ca vøj ndø yaj ca'ø. ");
INSERT INTO zosNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Entonces Jesusis cyøque'nøyaj mumu ityajupø jeni y ñøjay pøn tøjtzupø'is cyø': ―Yø'cmin mi ṉgø'. Ñe'c jetse chøjcu y cyø' tzojcu. ");
INSERT INTO zosNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Y aṉma'yoyajpapø angui'mgupit y fariseota'm qui'syca'comø'ñaju, y 'yaṉdzamdzo'chaj ñe'comda'm lo que jujche chøjcayaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tumgojama Jesús lomacøsi maṉu va' 'yo'nøy Dios. Y cøti tzu' 'yo'nøy Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Jyo'pit jama'omo Jesusis vyejmiñaj ñøtuṉdøvø y cyøpiṉyaj macvøstøjcapyø ñe'comda'm, y yac nøyi'aj yøṉ macvøstøjcapyø pøn apostoles. ");
INSERT INTO zosNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tum cyøpiṉyajupø ñøyipø'is Simón; mismo je pøn Jesusis yac nøyi'ajque't Pedro. Y Jesusis cyøpiṉyajque't Pedro'is tyøvø Andrés, tumbø jatacøsti tzu'ṉyajupø. Y cyøpiṉyajque't Jesusis Jacobo y Juan; Felipe y Bartolomé; ");
INSERT INTO zosNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo y Tomás, Alfeo'is 'yune Jacobo, Simón nøyipø'is Zelote; ");
INSERT INTO zosNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacobo'is tyøvø Judas, y Judas Iscariote. Judas Iscariote'is jøsi'jcam chi'ocuyaj Jesús 'yenemigocøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Y Jesús lomacøs mø'ñaj jic ñøtuṉdøvøji'ṉ, y te'ndzø'yaj cøjø'ṉomo. Y jena'n ityajque't vøti eyata'mbø ñøtuṉdøvø; y vøti pøn tzu'nyajupø mumu Judea nasis cyo'aṉjajme'omo, y ityajuna'ṉ Jerusalén gumgu'yomo tzunyajupø. Ityajque't Tiro cumgu'yomo y Sidón gumgu'yomo tome majraṉvini tzu'ṉyajupø. Nu'cyaju va'cø cyøma'nøyaj Jesús, y va'cø yac tzocyajtøj ca'eta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hasta yatzi'ajcu'is nø yac toya'isyajupø tzø'yaj tzocyajupø. ");
INSERT INTO zosNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mumu jena'ṉ ityaju pø'nis sunbana'ṉ jyasisyaj Jesús, porque Jesusis yac tzocyajpana'ṉ myusocuvinipit. ");
INSERT INTO zosNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Y Jesusis cyøque'nøyaj ñøtuṉdøvø y ñøjmayaju: ―Vøjti mi ijtam mijta'm mbyobre'sta'm, porque Diosis mi 'yaṉgui'mdamba y mi ṉgyoquendamba. ");
INSERT INTO zosNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Vøjti mi ijtam mi mijta'm lo que nø mi ⁿ'yostambapø'is yøti, porque maṉba mi ñdyastame. Vøjti mi ijtam mi mijta'm que yøti mi ⁿvyo'ndambapø'is, porque maṉba mi syictame. ");
INSERT INTO zosNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Vøjti mi ijtamu cuando pø'nista'm mi ṉgui'satyamba, y cuando mi yac ne'pujtamba como si fuera yatzita'mbø pønse; cuando mi ñdyopa'o'nøtyamba; y cuando mi yandzicotzøctamba porque mi ndø va'ṉjamdamba ancø ndøvø øtz mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Cuando jetse mi ñchøjcatyamba, casøtyamø y alegre'ajtamø; porque Diosis más maṉba mi ñchi'tam vøti mi ṉgoyoja tzajpomo. Porque jetse yacsutzøcyajque't pyeca jata'sta'm tza'maṉvajcoyajpapø. ");
INSERT INTO zosNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","”Pero lástima mijta'm mi riṉgu'sta'm, porque mi mbøjcøchoṉdamu'am mi alegre'ajcuy; pero maṉba mi ñdyoya'istam jøsi'jcam. ");
INSERT INTO zosNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Lástima mijta'm yøti mi ṉgyu'jtambapø'is mi ñdyastamba'csye'ṉomda'm, porque jøsi'jcam maṉba mi ⁿ'yostame. Lástima mijta'm yøti mi syictambapø'is, porque maṉba mi vyø'ndame, maṉba mi ⁿvyejtame jøsi'jcam. ");
INSERT INTO zosNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Lástima mi mijta'm cuando mumu pø'nis mi vyømbøpøngotzøctamba, porque jetseti ya'møc ijtuna'ṉ sutzcuy cha'maṉvacyajpapø'is y vyøpøpøngotzøcyajpana'ṉ pyeca jata'sta'm. ");
INSERT INTO zosNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","”Pero mijta'm mi ndø cøma'nøtyambapø'is nøjmandya'mbøjtzi: Sundamø mi enemigota'm. Tzøjcatyam bien mi ṉgui'satyambapø'is. ");
INSERT INTO zosNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Vøjcotzøctam mi yandzicotzøctambapø'is; o'nøjatyam Dios va'cø cyotzoṉyaj mi ṉgyø'o'nøtyambapø'is. ");
INSERT INTO zosNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","O'ca mi ñchaṉdøjpa mi aṉgacøsi, yac tzaṉgue'tati mi ⁿvin tu'møṉ. O'ca mi yac tzu'ṉatyøjpa vingøspø mi nducu, yac pøjque'tati jojmopø. ");
INSERT INTO zosNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Auṉqueti mi vya'ṉgatyøjpa, vactzi'ø. Y o'ca mi mbyøjcatyøjpa mijtzene, uyam mi ⁿva'cvitu'u. ");
INSERT INTO zosNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tzøjcatyam bien aunque jutipø en la misma forma como mi sundamba va' mi ñchøjcatyandøj bien. ");
INSERT INTO zosNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","”Na's jejti va'cø mi sundamø mi syundambapø'is ¿ticøtoya maṉba mi ṉgyoyojtandøji? Porque hasta yatzita'mbø pøn jetseti na syuñajtøjque'tpa na syuñajtøjpapøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Y na's jejti va'cø mi ndzøjcatyam bien mi nchøjcatyambapø'is bien, ¿ticøtoya maṉba mi ngyoyojtandøji? Porque asta yatzita'mbø pøn jetse na chøjcayajtøjpa bien. ");
INSERT INTO zosNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","O'ca mi nu'cschi'tamba na's maṉbapø'is mi ñchi'vitu'tame, ¿ticotoya maṉba mi ngyoyojtam Diosis? Porque hasta yatzita'mbø pø'nis ñu'cschi'yajpa tyøvøcøsi va'cø pyøjcøchoṉyaj ju'nche'nom ñu'cschi'yajuse. ");
INSERT INTO zosNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero mijtzi sundamø mi enemigo, y tzøjcatyam bien, y nu'cschi'tamø sin que mi aṉjo'ctamø va'cø mi ñchi'vitu'tamø; y Diosis maṉba mi ñchi'vitu'tam más vøjpø tiyø. Y jetse Møjipø'is mi 'yune'ajtamba. Porque Diosis tyoya'ṉøyajpa mumu pøn aunque yatzita'mbø y ji'n chøjcayaje'is cuendø o'ca Diosis nø tyoya'ṉøyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","To'ya'ṉø'otyamø jujche ndø Janda Dios to'ya'ṉø'opya. ");
INSERT INTO zosNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","”U mi ṉgøme'tztam ni iyø cyojapit, y jetse ji'n mi ṉgyøme'tzque't Diosis mi ṉgojapit. U mi yaj coja'ajtam mi mbøndøvø ni ticøsi, y ni mitz ji'n ma mi ⁿyaj coja'ajtam Diosis. Lo que eyapø'is ti mi ñchøjcatyamba, yac tzø'y jetse; y jetseti maṉba mi ⁿyaj ṉgotocojatyaṉgue't Diosis mi ṉgoja. ");
INSERT INTO zosNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tzi'tamø ti syuñajpa, y mitz ma mi ñchi'taṉgue't Diosis; Diosis ma mi ñchi'tam vøti aunque tiyø. Como si fuera ndø tzi'tambase ndø tøvø chunu'omo tum muqui titpø'pacsye'ṉomo; jetse Diosis maṉba mi ñchi'tam vøti aunque ti vøjpø. Porque jujche'ṉom mi ndzi'pa, jetse maṉba mi ñchi'vitu'tøji. ");
INSERT INTO zosNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jetse cham Jesusis, y entonces historiaji'ṉ 'yaṉma'yaṉøyu, nømu: ―Como to'tipø'is ji'n mus isindzi' tuṉ to'ti tøvø, porque mye'chcø'i maṉba quecyaj tzatøjcomo; jetsetique't ni i ji'n mus 'yanmayø o'ca ñe'c ji'n myusi. ");
INSERT INTO zosNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aṉma'yopyapø más musopya, y nø 'yaṉmayupø ji'n más musoye. Lo que myuspa'cse'ṉomo aṉma'yopyapø'is, jenche'ṉomdi ma myusque't nø 'yaṉmayupø'is cuando aṉmacota'nba. ");
INSERT INTO zosNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","”¿Ti'ajcuy mi ndzøjcapya cuenda mi ndøvø'is cyoja y ji'n mi ndzøjcay cuenda vøti mi ne' mi ṉgoja? Como si fuera ijtuna'ṉ mi ndøvø'is vyitø'momo putzi puchtøjcøyu, y ne' mi vindø'momo ijtuna'ṉ møjacuy; jetse mi ṉgoja vøti ijtu y mi ndøvø'is ñe' usyti ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ji'n mus mi nøjay mi ndøvø: “Tøvøy, tzacø tø nø mbut putzi puchtøjcøy mi ⁿvindø'momo”, porque ji'n mi ndzøjcay cuenda que it mi ne' mi vindø'momo møjacuy. 'Yaṉgøma'cø'otyambapøte mijtzi, nøput vi'nac mi vindø'momo møjacuy ijtupø. Jicsye'cti ma mi is vøjø va' mi nømbujtay putzi mi ndøvø'is vyitø'momo. Jetse tiene que va'cø mi ⁿyaj vøti mi ṉgoja mi ne', antes que va'cø mi ndzajmay mi ndøvø ti cyoja. ");
INSERT INTO zosNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","”Como jujche itpa vøjpø cuy, jetse itque'tpati vøjpø pøn. Vøjpø cuy tø'møpya y vøjti tyøm. Pero ji'n vyøjpø cuy tø'møpya y ji'n vyøj tyøm. ");
INSERT INTO zosNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","O'ca vøj tyøm ndø cøcye'nøjapya cuy o'ca vøjpø cuyete. Jetseti pøn o'ca vøjpø ti chøcpa, ndø cøque'nøpya pøn o'ca vøjpø pønete. Porque higo cu'is tyøm ji'n it apitcucyøsi, y uvatza'is tyøm ji'n it ta'nacøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jetsetique't o'ca vøjpø pønete, vøjpø qui'psocuy ñø'it chococyøsi. Y ñømaṉba vøjø aunque iyø. Y yatzipø pø'nis ñø'it chococyøsi yatzipø qui'psocuy, y yatzipø aunque ti chøcpa; porque como aṉjambase chococyøsi, jetse 'yaṉnaca'omo chamgue'tpa. ");
INSERT INTO zosNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","”¿Ti'ajcuy mi ndø nøjañdyamba, “Øjtzø mi Ṉgomi, øjtzø mi Ṉgomi”, y ji'n mi ndzøctam øtz ndzambase? ");
INSERT INTO zosNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Maṉba mi ndzajmatyam isemete aunque jutipø pøn que minba øtzcø'mø, y myanba ø onde, y chøcpa øtz ndzajmapyase. ");
INSERT INTO zosNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jetsepø pø'nis ñø'it vøjpø qui'psocuy como tum pøn chøjcupø'is tyøc ñø'it qui'psocuy. Porque vi'na tyajay jojmo y tza'cøs ñøtzo'tzu. Y jicsye'cam min jojmo'aj nø', y nø'is ñucjo'y pømi tøc, pero ni ja yac micsø, porque tza'cøs no'jtzu'ṉu. ");
INSERT INTO zosNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero o'ca aunque jutipø pø'nis myanba ø onde y ji'n chøc lo que ndzajmayupø; jetsepø pø'nis ja ñø'it vøjpø qui'psocuy como tum pøn chøjcupø'is tyøc, pero nascøs ñøtzu'ṉu, ni ja ñipø. Nø'is ñuc jicø tøc pømi, y tumø hora yaj quejcu, y oy yajpø' jej tøc. ");
INSERT INTO zosNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jetse Jesusis 'yø'nøyaj vøtipøn mumu jetsepø oteji'ṉ, y cuandø 'yo'nø'yaṉdzacyaju, tøjcøy capernaum gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jena'n it tum capita'nis myuchacho ca'epøna'ṉete, y cya'cuvinina'ṉ ijtu. Capita'nis syungomø'nbana'ṉ myuchacho. ");
INSERT INTO zosNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Y cuando capita'nis myanu nø chamyajupø Jesús, capita'nis cyø'vejyaj Israel tzambøn Jesuscø'mø. Cyø'vejyaju va' 'yo'nøyaj Jesús va' min cho'yøjay myuchacho. ");
INSERT INTO zosNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Y tzambøn nu'cyaj Jesuscø'mø, 'yo'nøyaj Jesús va' myavø, y ñøjayaju: ―Vøjø va'cø maṉ mi ndzo'yøjay capita'nis myuchacho, porque vøjpø pønete. ");
INSERT INTO zosNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Aunque emøcpø pøndite, pero syunba ndø cumgupyønda'm, y yac tzøctøju ndø conocsuy tøcta'm. ");
INSERT INTO zosNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Y Jesús maṉ tzambønji'ṉda'm. Nømna'ṉ ñu'cyaj tome tyøcmø cuando capita'nis cyø'vej 'yamigo Jesuscø'mø va'cø ñøjayø: ―Ø mi Ṉgomi, ji'nø sun mi ⁿjorvatzøcø; porque mitz ⁿvyøjpø mbyønete, y øtz ji'nchøṉ vøjpø pøn. Y por eso ji'n sun mi yac tøjcøy ø ndøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","También øjtzi ja 'yaṉjajmø vøjø ø ⁿvin va' maṉ mitzcø'mø. O'ca mitz mi ndø tzo'yøjapya ø munchacho mi ondepit, entonces tzocpati. ");
INSERT INTO zosNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porque it más aṉgui'mbapø que menos øjtzi, y ityaj ø soldado ø aṉgui'mgu'yomo, y nøja'mbyøjtzi tumø. “Mavø”, y maṉba. Y eyapø nøja'mbyøjtzi: “Minø”, y minba. Y nøja'mbyøjtzi ø ndzøsi: “Tzøc yøṉø”, y chøcpa. (Jetse øtz aṉgui'mba, pero mitz masti mi 'yaṉgui'mba.) ");
INSERT INTO zosNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Y myanu'øcti Jesusis yøṉø, maya'u jetcøtoya. Y quenvitu'u y ñøjayaj pønda'm myaṉu'is pya'tyaje: ―Viyuṉsye mi nøja'mbyøjtzi; yøṉ pøn emøcpø pøndite, pero ja mbya'tøjtzi va'ṉjajmopyapø Israel pø'nomo como yøn pøn va'ṉjajmopyase. ");
INSERT INTO zosNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Y vitu'yaju'cam tyøjcomo pøn capita'nis cyø'vejyajupø, pya'tyaj tzojcupø myuchacho. ");
INSERT INTO zosNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Y tujcu que jicsye'c Jesús nømna'ṉ myaṉ tum cumgu'yomo ñøyipø'is Naín, y nømna'ṉ myaṉgo'ñaj Jesusji'ṉ ñøtuṉdøvø y vøtipøn. ");
INSERT INTO zosNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Cuando nømna'n tyome isayaj cumgu'is tyøjcøñømbamø, nømna'ṉ ñøputyaj tum ca'upø anima va'cø maṉ niptøjø. Tumbø unetina'ṉete, y myama yaṉbac yomona'ṉete. Y nømna'ṉ myaṉgo'ñaj myamaji'ṉ vøti cyumguy tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cuando ndø Comi'is isay ca'upø'is myama, tyoya'nøjayu y ñøjmayu: ―U vyo'e. ");
INSERT INTO zosNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ndø Comi'is cyønu'c tome y cyot cyø' tapescucyøsi. Y nø ñømaṉyajupø'is ñøte'ndzøyaju. Jesusis ñøjmay ca'upø: ―Soca'une, øjtzø mi nøjambya, te'ñchu'ṉø. ");
INSERT INTO zosNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jicsye'cti po'cschu'ṉu y ondzo'tz une ca'upøna'ṉ, y chi' myama Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Y mumu na'tzco'ñaju y vyøcotzøcyajpana'ṉ Dios, y nømyaju: ―Myøja'ṉombø tza'maṉvajcopyapø min tø øtzcø'mda'm. Nømyajque'tu: ―Diosis min cyotzon ñe cyumgupyønda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y mumu Judea nasomo y mumu nasvindumø nømna'ṉ chamdøj Jesús o'ca yac visa' ca'upø. ");
INSERT INTO zosNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Y Jua'nis ñøtuṉdøvø'is chajmayaj ñe'c Juan mumu yøcseta'mbø tiyø chøjcupø Jesusis. Entonces Jua'nis vyejayaj metzcuy ñøtuṉdøvø ");
INSERT INTO zosNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","va'cø myaṉ Jesuscø'mø va'cø maṉ 'yangøva'c Jesús y va' ñøjayajø: ―¿Mijtzimete Diosmø mi nø minumbø nømditzø ⁿjo'ctambapø? Si no, maṉba ndø jo'ctam eyapø. ");
INSERT INTO zosNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Y ñu'cscuy Jua'nis cyø'vejyajupø nu'cyaj Jesuscø'mø, y ñøjmayaju que nø'yø'opyapø Jua'nis cyø'vejyaju va'cø 'yocva'cø o'ca Jesusete Diosis cyø'vejupø; y si no, o'ca ji'ndyet jete, va'cø jyo'cyaj eyapø. ");
INSERT INTO zosNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Antes que va 'yaṉdzova, Jesusis yac tzojcomø'ñaj ca'eta'mbø, y yac tzoc vøti toya'omda'mbø; y nøc'ijtøyajupø yatzi'ajcu'ista'm yac tzojque'tuti; y vøti to'tita'mbø yac sø'ṉayaj vyitøm. ");
INSERT INTO zosNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yø'cse chøc Jesusis y jicsye'c ñøjmayaj Jua'nis ñu'cscuy: ―Maṉdyamø, tzajmatyam Juan ti mi mandamu y ti mi ṉgøque'nøtyamu. Mi ṉgøque'nøtyamu que to'tita'mbø isoyajpa'am, yu'quita'mbø vityajpa'am vøjø, putzi'øyajupø tzø'yajpa tzocyajupø, y cojita'mbø'is myañajpa'am ote. Ca'yajupø øchacvisa'pøjtzi; y pobreta'mbø ø ndzajmayajpø vøjta'mbø ote. ");
INSERT INTO zosNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Vøjti mi ijtamu o'ca mi ndø va'ṉjamdamba. ");
INSERT INTO zosNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Maṉyaju'jcam Jua'nis ñu'cscuy, Jesusis 'yo'nøcho'chaj pøn, nømna'ṉ cham Juan que jujchepø pønete. Jesús nømu: ―¿Ti'ajcuy o mi myaṉdam ni i ja ityømø? ¿Ti o mi a'mdam jiṉø? ¿Será que mi 'yondyamu va' mi a'mdam ta'nø yac micsupø sava'is? Seguro que ji'ndyet jetcøtoya mi ⁿ'yondyamupø. ");
INSERT INTO zosNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Entonces ¿ti o maṉ mi a'mdame? ¿Será que mi ⁿ'yoñdyamu va' mi a'mdam pøn vøjpø tucu'ombøte? Ji'ndyet jete, porque myespapø'is vøjpø tyucu, y ityajpapø vøjø, møja'ṉom aṉgui'mbapø'is tyøjcomo ityajpa. Ji'n ityaj ta'nø'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Entonces ¿ti o mi a'mdame? ¿No será que tza'maṉvajcopyapø o mi a'mdame? Jø'ø, viyuṉete, o mi a'mdam Juan y Juan más myøja'ṉombø que ji'n aunque jutipø tza'maṉvajcopyapø. ");
INSERT INTO zosNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan minu y yosu como jachø'yupøse Diosis libru'omo que ñøjay Cristo Diosis: Øtz ṉgø'vejpøjtzi nu'cscuy nøminbapø'is ote antes que minba mijtzi. Como si fuera mi nduṉ nø vyøjøtzøjcuse, je'is maṉba chajmayaj pøn va'cø ityaj jajmecøsi va'cø mi mbyøjcøchoṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Porque øtz mi nøjmandyamba que pø'ṉajupø yomocøsi, ja it más myøja'ṉombø tza'maṉvajcopyapø que ji'n Juan. Pero más pobre y más ji'n aṉgui'mipø pøn Dios 'yangui'mbamø, más myøja'ṉombøte que ji'n Juan. ");
INSERT INTO zosNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Cuando myañaj jetsepø ote cumgupyø'nis y cobratzøjcoyajpapø'is gobiernocøtoya, entonces vyøcotzøcyajpana'ṉ Dios. Porque oy ñø'yøyaj Jua'nis. ");
INSERT INTO zosNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero fariseo'ista'm y aṉma'yoyajpapø'is peca aṉgui'mguji'ṉ ja pyøjcøchoṉjayaj Diosis 'yaṉgui'mguy, porque ja ñø'yøyaj Juangøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Y ndø Comi nømu: ―Ma'ṉbø mi ndzajmatyam o'ca ise chøcyajpa yøti ityajupø pø'nista'm. ");
INSERT INTO zosNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Supongamos que une nø myøjtzøyaj plaza'omo. Y tumbø'is ñøjayajpa 'yuñdyøvø: “Mi yac vejatyam suscuy, pero ja sun mi ⁿ'yetztamø. Mi vajnandyam nijpocuy vane, y ja mi ⁿvyo'ndamø”. ");
INSERT INTO zosNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Como une ji'n sun myøjtzøyaj ni etzcuy, ni ji'n sun myøjtzøyaj como ca'nømuse; jetse mijta'm ji'n sundam ni Juan, ni ji'n mi ndø sundam ndøvø. Porque min Juan nø'yø'opyapø ni ji'na'ṉ cyø's paṉ, y ni ji'na'ṉ tyø'ṉ vinu; y mitz ni ja syundamø, y mi ñømdamba: “Yatzi'ajcu'is ñøtzøc Juan”. ");
INSERT INTO zosNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y mi'nøjtzi mumu Pø'nis chøṉ Tyøvø, øtz cu'tpa y ucpa, y mitz mi ndø ṉgui'sacye'tpati y mi ñømdamba: “Yøṉø pøn cu'tco'nba y tyo'ṉgo'nba vinu, y amigopøcyajpa cobratzøjcopyapø y coja'øyajupø”. ");
INSERT INTO zosNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero mumu qui'psocu'yøyupø'is yaj quejpa que vøjø va' tø qui'psocu'yøyø. ");
INSERT INTO zosNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Y tum fariseo'is vyejay Jesús va'cø tyumø cu'tyajø. Jicsye'cti Jesús tøjcøy fariseo'is tyøjcomo y po'cscøne'c mesacø'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ijtuna'ṉ cumgu'yomo tum yomo cojapa'tupø. Cuando yøṉ yomo'is myusu'jcam que Jesús mesacø'mø ijtu fariseo'is tyøjcomo, ñømin tum frasco perfume y cyøtøjcøyu. ");
INSERT INTO zosNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Te'ngøne'c Jesusis jyøsaṉgø'mø cyosocø'mø y vo'tzo'tzu, y yac mujay cyoso vyitømnø'ji'ṉ. Cyømojcay Jesusis cyoso vyayji'n, y syu'cay cyoso, y jyasay cyoso perfumeji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Cuando min is fariseo'is vyejayupø'is Jesús, nøm choco'yomo: “O'cana'ṉ tza'maṉvajcopyapøna'ṉete, ispøcpana'ṉ yøṉø iyete y jujchepø yomo'is nø pi'quisupø, que cojapa'tupøte”. ");
INSERT INTO zosNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Entonces Jesusis ñøjmay fariseo: ―Simón, ij ti va'cø mi ndzajmayø. Y je'tis ñøjmay Jesús: ―Tø tzajmay ndøvø, Maestro. ");
INSERT INTO zosNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús nømu: ―Tum pø'nis nu'cschi' tumin y it jya'tzpapø'is metzcuy. Tumbø'is jya'tzpana'ṉ mil pesos, y eyapø'is jya'tzpana'ṉ cien. ");
INSERT INTO zosNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Y como ja ñø'ityajøna'ṉ je'tista'm tiji'ṉ va'cø yac vitu'yajø, vø'tumi'nis chac jetse va' jyana yac vitu'yaj cyoyoja myechcø'y. Tø tzajmay ndøvø: ¿Jutipø'is más maṉba syuni vø'tumin? ");
INSERT INTO zosNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simo'nis ñøjayu: ―Ngomo'pya øjtzi que jya'tzpapø'is más vøti y vøtumi'nis tyo'ya'ṉøyu, je'tis más maṉba syuni vø'tumin. Y Jesusis ñøjmayu: ―Viyuṉete vøj mi ṉgui'psu. ");
INSERT INTO zosNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Entonces Jesusis cyøque'nøy yomo y ñøjmay Simón: ―A'm yøn yomo. Cuando tøjcø'yøjtzi mi ndøjcomo, ja mi ndø tzi' nø' va' ṉgøtze' ø ṉgoso, pero yøṉø yomo'is yac muj ø ṉgoso vyitømnø'ji'ṉ, y cyømoc vyayji'n. ");
INSERT INTO zosNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ja mi ndø su'cø, pero yøṉ yomo'is ja syu'ctzajcayøti ø ṉgoso desde que tøjcø'yøjtzi mi ndøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ja mi ndø jasay ø ṉgopac aceiteji'ṉ, pero yøṉø yomo'is jyasay ø ṉgoso perfumeji'n. ");
INSERT INTO zosNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Por eso mi nøjmambyøjtzi, vøtina'ṉ it cyoja yomo'is y øtz yaj cøtocoja'yøjtzi, porque je yomo'is vøti su'nbøjtzi. Pero usy ijtupø'is cyoja o'ca yaj cøtocojatyøjpa, usyti syunba opø'is tyo'ya'ṉøyi. ");
INSERT INTO zosNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Entonces Jesusis ñøjmay yomo: ―Mi ṉgoja øtz ⁿyaj cøtocojayu'mtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ityajupø po'csyaju Jesusji'ṉ mesacø'mø qui'pscho'chaj choco'yomdam: ―¿Ti'ajcuy nømba yøṉø pøn que yaj cøtocojapya cyoja? porque pøndite. ");
INSERT INTO zosNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Y Jesusis ñøjay yomo: ―Porque mi ndø va'ṉjajmu, por eso mi ngyotzojcu. Jenø maṉgue't Diosji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jicsye'c tujcu que nømna'ṉ tu'ṉaj Jesús cumguñamaye, y cøt che'ta'mbø cumgu'yomo y cøt møjapø cumgu'yomda'm. Y Jesusis chajmayajpana'ṉ vøjpø ote jujche maṉba aṉgui'm Dios, jujche maṉba tø coquendam Diosis. Y macvøstøjcapyø apostolesis nømna'ṉ pya'tyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nømna'ṉ maṉ pya'tyajque't Jesús yomo'sta'm Jesusis oyupø cho'yøyaje cuando ñøc'ijtøyajupøna'ṉ yatzi'ajcu'is, y eyata'mbø ca'cuy ñø'ityajupø'isna'ṉ. Ijtuna'ṉ tum ñøyipø'is María; y mismo je yomo yac nøyi'ajyajque'tpana'ṉ Magdalena. Je'is choco'yomo Jesusis o yac jøcøjay cu'yay yatzipø espiritu. ");
INSERT INTO zosNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Y Herodesis chøsi ñøyipø'is Chusa, je Chusa'is yomo'is maṉ pya'tque't Jesús. Y man pya'tque't tum yomo'is ñøyipø'is Susana. Y vøti eyata'mbø yomo'is maṉ pya'tyajque'te. Yøṉ yomo'is ñøve'ñajpana'ṉ Jesús ti ñø'ityajupø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Entonces cyøtu'myaj Jesús vøti pø'nis aunque jutpø cumgu'yomda'mbø'is. Y Jesusis chajmayaju historia va'cø 'yaṉmayajø. Ñøjmayaju: ");
INSERT INTO zosNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―O's vyicpø' tømbu pujtu va' maṉ vyicø. Y cuando vijcu, tum nivoya quec tu'ṉomo y myaṉga'jayajtøj tømbuj, y jyu'cyaj paloma'is. ");
INSERT INTO zosNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Eyaco nivoya quec tza'cøtøjcomo, y nayuti; pero poṉga' 'yune porque ji'na'ṉ choco nas. ");
INSERT INTO zosNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Vene quec apit paque'omo, y parejo nay apitji'ṉ; pero 'yune yaj ca' apit cømø'ṉis. ");
INSERT INTO zosNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Y vene quec vøjpø nasomo, y nayu, y tø'maju, y tum dum kilo nijpu chi' mosis kilo. Cuando o'nøyu'jcam yøcsepø ticøsi, Jesús pømi vyejayaju ñøjayaju: ―Ijtam mi ṉgoji, cøma'nøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Entonces ñøtuṉdøvø'is 'yaṉgøva'cyaj Jesús ti aṉmacuy sunba cham jetsepø historiaji'n. ");
INSERT INTO zosNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesusis ñøjmayaju: ―Mitzta'm Diosis mi ñchi'tamba qui'psocuy va' mi ngyøñøctyøyøtyam cøvø'nupø ote jujche aṉgui'mbase Dios, pero eyata'mbø o'nøyajøjtzi historiaji'n; jetse aunque isyajø, va'cø jana myusyajø ti nø isyaju; aunque myañajø, va'cø jana cyønøctøyøyaj tiyø aṉma'yocuyete. ");
INSERT INTO zosNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","”Yø'cse ndø tza'maṉvacpa historia: Como tømbu victøjpase, jetse Diosis 'yote cha'maṉva'ctøjpa. ");
INSERT INTO zosNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Como vene tømbu quec tu'ṉomo y ja choca, jetse vene pønbø'is myañajpa Diosis 'yote, y jø'nøti minba yatzipø y yac tzu'ṉapya choco'yombø 'yote va' jyana vya'ṉjamyajø, y va'cø jyana cotzocyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Y como vene quec tza'cøtøjcomo y ja choca; jetse venepønbø'is myanajpa Diosis 'yote, y casøpya pyøjcøchoṉjayajpa. Pero como tømbu'is 'yune ja vyatzinucø, jetse pøn ji'n syeguitzøcyaje. Vya'ṉjamyajpa usyaṉ hora, y cuando yacsutzøcyajtøjpa, chacyajpa. ");
INSERT INTO zosNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","”Y como vene tømbu quec apijtomo y ja choca, jetsetique't ityaj pøn cyøma'nøjayajpapø'is 'yote; pero porque it vøti ti va'cø chøcyajø, y syuñajpa va' ricu'ajyajø, y yac tzi'ṉyajpa nascøspø itcuy, y ja ityaj gyusto va' jyamchø'yaj ote; jetse ji'n yac ta'ñaje. ");
INSERT INTO zosNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero como vene tømbu quec vøjpø nasomo y tø'maju, jetsetique't ityaj cyøma'nøyajpapø'is ote y yaj cøchø'yajpa viyuṉbø y vøjpø tzocoji'ṉ, y chøcyajpa vøjø hasta cyota'ñajpacsye'nomo ote. ");
INSERT INTO zosNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","”No'a va'cø ndø yac sø'ṉø, ji'n ndø cømucsøy tzicapit, ni ji'n ndø cot tze'scøtøjcø'mø. Pero ndø cotpa no'a cojtocucyøsi va'cø isoyaj tøjcøyajpapø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Porque mumu tiyø nu'mdzamdøjupø, aunque i'is maṉba myus jøsi'cam; aunque cøvø'nupø, pero mumu maṉba mustøj aunque juti. ");
INSERT INTO zosNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Por eso cøma'nøtyam mø'chøqui ti tzamdøjpa. Porque ñø'ijtupø'is vøti, Diosis maṉba chi'aṉøy mas vøti. Pero ja itøpø'is ni tiyø, Diosis maṉba yac tzu'ṉaye lo que cyomo'pya o'ca ñø'ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Y min nu'cjo'yaj Jesuscø'mø myama y myuquita'm, y ji'na'ṉ mus nu'cyajø jetcø'mø porque vøtipøn ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Entonces chajmayaj Jesús ñøjmayaju: ―Mi mama y mi muṉgi a'ṉgomo ityaju y nø mi syun isyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero Jesusis ñøjayu: ―Cyøma'nøjapyapø'is Diosis 'yote y cyøna'tzøyajpapø'is, jicta'mete o mama y ø muṉgui. ");
INSERT INTO zosNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Y tuc tum jama'omo Jesús tøjcøy tum barco'omo ñøtuṉdøvøji'ṉ, y ñøjmayaj ñøtuṉdøvø: ―Tø cøjta'me marcøtu'møṉ. Y tzu'ṉyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mientras nømna'ṉ tyu'ṉajyaj majromo, øṉuna'ṉ Jesús. Entonces pocho'tz pømipø sava, y nømna'ṉ tyapstøjcøy nø' barco'omo, y na'tzcu'yomna'ṉ ityaju. ");
INSERT INTO zosNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Y to'møyaj Jesús y yac sa'yaju y ñøjmayaju: ―¡Maestro, Maestro, maṉba tø ca'tame! Pero Jesús sa'u y 'yojnay sava y nø'tapscø'; jetse poyaṉjeju, y vøṉbønømu. ");
INSERT INTO zosNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Entonces Jesusis ñøjmayaju: ―¿Ticøtoya øtz ji'n mi ndø va'ṉjamdame? Y na'tzco'ñaju y maya'yaju y nañøjayajtøju: ―¿Ipø pønøṉ yøṉø? Porque hasta sava y nø' 'yaṉgui'mba je'is, y cyøma'nøyajpa. ");
INSERT INTO zosNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jetse seguitzøcyaj barco'omo hasta que nu'cyaj Gadara nasomo, Galilea nasis cyøtu'møn ijtupø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jiṉ put Jesús barco'omo, y nascøsi choṉ tum pøn pujtupø cumgu'yomo. Jic pøn ñøc'ijtøyajuna'ṉ yatzi'ajcu'ista'm desde ya'møc. Ji'n myes tucu, y ji'na'ṉ tøjcomo iti, sino nijpoñømbamøna'ṉ ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pø'nis is Jesús y veju y cyutcøne'cay Jesusis vi'naṉdøjqui y pømi ñøjmay Jesús: ―¿Ti mi sunba øtzji'n; Jesús møjipø Diosis mi 'Yune? Mi va'ṉgapyøjtzi jana mi ndø yac toya'isø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jetse nømu porque Jesusis nømna'ṉ yojnay yatzi'ajcuy, ñøjayu va pyut pø'nomo. Porque jana tumnac dominatzøcpana'ṉ pøn yatzi'ajcu'is. Syomyajpana'ṉ pøn vyajtayupø cadenaji'ṉ cyø' y cyoso, pero jyacpana'ṉ cadena, y yatzi'ajcu'is myacmaṉ pøn jya'ijnømømø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Y 'yocva'c Jesusis ñømayu: ―¿I mi nøyi? Y nømu: ―Legión ø nøyi. Jetse nømu porque vøtina'ṉ tøjcøyajuna'ṉ yatzi'ajcutya'm je'tomo. ");
INSERT INTO zosNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y yatzi'ajcu'is vya'cayaj Jesús va jyana cyø'vejyaj jojmopø tzatøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ijtuna'ṉ jiṉ vøti yoya nømna'ṉ cyu'tyaj quetzacopajcøsi. Yatzi'ajcu'ista'm vya'cyaj licencia Jesuscøsi va' tyøjcøyaj yoya'omda'm. Y Jesusis yac tøjcøyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Y putyaj yatzi'ajcuy pø'nomo y tøjcøyaj yoya'omda'm y vøti yoya poye mø'ñaj quetza'omo. Pyatztøjcøyaj nø'cø'm vyin, y sucsca'yaju. ");
INSERT INTO zosNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cuando isyaju'cam yoya cyoqueñajpapø'is tina'ṉ tujcu, poyaju y cha'maṉgejyaj cumgu'yomo y ribera'omda'm ti tujcu. ");
INSERT INTO zosNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Por eso maṉgomø'nømuna'ṉ a'myaje ti tujcu. Cuando nu'cyaj Jesuscø'mø, pya'tyaj pø'csupø cyosocø'mø pøn putyajupø'omo yatzi'ajcutya'm. Tucu mesumna'ṉ y ñø'ijtuna'ṉ vøjpø qui'psocuy. Y pøn cuando nu'cyaju y isyaju, entonces na'chaju. ");
INSERT INTO zosNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Opø'is ya'myaje chajmayaju jujche cotzoc pøn yatzi'ajcu'ista'm ñøc'ijtøyajupø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Entonces Gadara nasombø'is 'yo'nøyaj Jesús va'cø chu'n jetcø'mda'm, porque na'tzcomø'ñaju ancø. Y Jesús tøjcøy barco'omo y vitu'que'tuti. ");
INSERT INTO zosNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Y pøn pujtupø'om yatzi'ajcuy, je'is maṉ 'yo'nøy Jesús va'cø maṉ pya'tø. Pero Jesusis 'yo'nøyu tzajcu y ñøjmayu: ");
INSERT INTO zosNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Vitu'ø mi ndøcmø y tzajmayajø jujchepø myøja'ṉombø tiyø chøc Diosis mitzcøtoya. Y jetse maṉu y cha'maṉgej mumu cumgu'yomo tiyø musocuy chøc Jesusis va'cø yac tzoca. ");
INSERT INTO zosNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Cuando vitu' Jesús marcøtu'møṉ, pyøjcøchoṉyaj cajsøpya vøti pø'nis, porque mumuna'ṉ nø jyo'cyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Y min tum pøn ñøyipø'is Jairo, conocscuy tøjcombø covi'najø. Je'is cyutcøne'c Jesusis cyosocø'mø, y ñøjayu va'cø myavøm tyøcmø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Porque ñø'ijtuna'ṉ tø'cstumø 'yune papiñomopø nømna'ṉ myaṉ macvøstøjcay 'yame. Je papiñomo ca'cuvinina'ṉ ijtu. Mientras nømna'ṉ myaṉ Jesús, vøti pø'nis cyujcom ijtuna'ṉ y vøti pøn te'tzøyaj jetcøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Y nu'c Jesusis jyøsaṉgø'mø tum yomo ca'cu'yøyu, yach ca'cuy ñø'ijtu, putpana'ṉ ñø'pin. Macvøstøjcay amemna'ṉ ñø'it jetsepø ca'cuy, y cøyajøyuna'ṉ doctojromo mumu lo que ñø'ijtupøna'ṉ. Pero ni i'sna'ṉ ja mus yac tzoca. ");
INSERT INTO zosNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yøṉ nu'cu Jesusis jyøsaṉgø'mø y pi'quisay tyucu coso, y jicsye'cti pujtaṉjej ñø'pin. ");
INSERT INTO zosNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Y Jesús nømu: ―¿I'is chøṉ øtz pi'quisupø? Mumu nømyaju que ja pyi'quisø, y nøm Pedro y jetji'ṉ ityajupø: ―Maestro, vøti pø'nis vøndzø nø mi yaj ca'mdzø'yaju, y nø mi ndyona vityaju. ¿Ti'ajcuy mitz ñømba: “¿I'is ø pi'quisupø?” Porque vøti pø'nis nø mi ṉgyøte'tzøyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús nømu: ―Ijtu i'is ø pi'quisay ø nducu. Øtz aṉjajmøjtzi que put ø musocuy ø ⁿvinomo va'cø yac tzojcoya. ");
INSERT INTO zosNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Y myusu'jcam yomo'is que ja mus cyøvø'nø, minu si'tipa y cutcøne'cøy Jesusis vyi'na'ṉdøjqui y cha'maṉvajcay vøti pø'nis vyi'naṉdøjqui ticøtoya pi'quisu y jujche tumø hora tzojcu cuando pi'quisu. ");
INSERT INTO zosNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Y Jesusis ñøjmayu: ―Øjtzø mi une, porque mi ndø va'ṉjajmu ancø, mi ñchojcu; mavø y it contento. ");
INSERT INTO zosNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mientras jetsena'n nø vyejvejneyu, miñaj ñømiñajpa'is ote tzu'ṉyajupø conocscuy tøjcombø'is tyøjcomo. Ñøjmayaju: ―Ca'u'am mi une. Uyam mas jorvatzøc Maestro. ");
INSERT INTO zosNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero myan Jesusis, y ñøjmayu: ―Uy ña'tze, tø va'ṉjamøti y maṉba tzoc mi une. ");
INSERT INTO zosNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Cuando Jesús nu'c tyøjcomo, ni ja yac tøjcøy ni iyø jetji'n, sino que ñøtøjcøyaj Pedro y Jacobo y Juan y papiñomo'is jyata y myama. ");
INSERT INTO zosNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mumuna'ṉ nø cyøvo'yaju y nø cyøvejyaju yom une porque ca'u. Y Jesusis ñøjmayaju: ―U vyo'tame. Ja cya'øpøte, sino øṉupøtite. ");
INSERT INTO zosNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Eyapø'is syijcayajque'tuti, porque myusyaju que ca'upøte. ");
INSERT INTO zosNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero Jesusis ñujcay une'is cyø' y pømi ñøjayu: ―Cya'e, te'nchu'ṉø. ");
INSERT INTO zosNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jicsye'cti visa'u y te'ndonchu'ṉ une. Y Jesusis ñøjmayaju va'cø chi'yaj cu'tcuy. ");
INSERT INTO zosNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Y jyata y myama nømyaju: “¿Jutznøm yø'ṉis jetse yac visa'u?” Pero Jesusis ñøjayaju que ni i va' jyana tzajmayaj jujche visa'u. ");
INSERT INTO zosNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Entonces Jesusis vyejtu'myaj macvøstøjcay ñøtuṉdøvø y chi'yaj aṉqui'mguy y milagro'ajcuy va'cø myacputyaj mumu yatzita'mbø espiritu, y va'cø yac tzocyaj ca'eta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Y Jesusis cyø'vejyaju je ñøtuṉdøvø va' chajmayajø jujche tø aṉgui'mbase y tø coquenbase Diosis, y va' yac tzocyaj ca'eta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y Jesusis ñøjayaju: ―Uy ñømaṉdam ni tiyø para tuṉgøtoya; ni tacus, ni morral, ni mi ṉgu'tcuy, ni tumin, y va'cø jana mi nø'ijtam eyapø mi nducu. ");
INSERT INTO zosNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Y aunque jutipø tøjcomo mi ñdyøjcøtyamba, tzø'tyam jeni. Y jenam tzu'ṉdamø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","O'ca ji'n mi mbyøjcøchoṉdame, cuando mi nchu'ṉdamba je'is cyumgu'yomda'm, cøyøjtam po'yoji'ṉ mi ṉgoso como seña que cojapa'tyaj je cumgu'yomda'mbø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jetse tzu'ṉyaj jeni cyø'vejyajupø, y maṉ 'yocvityaj che' cumguy. Chajmayajpana'ṉ vøjpø ote, y yac tzojcoyajpana'ṉ aunque juti. ");
INSERT INTO zosNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Y myan aṉgui'mbapø Herodesis mumu nømna'ṉ chøjcuse Jesusis. Qui'psmin qui'psmaṉbana'ṉ Herodesis porque veneta'mbø nømyajpana'ṉ que Juane visa'upø ca'yajupø'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Eyapø nømyajpana'ṉ que Elías queju, y eyapø nømyajpana'ṉ que tum ya'møcpø tza'maṉvajcopyapø visa'u. ");
INSERT INTO zosNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero Herodes nømu: ―Øtz yaj copac cøjactøj Juan ¿Iyøṉ yøṉ nø chøjcupø'is yøcseta'mbø tiyø jetse nø manu? Y Herodesis sunbana'ṉ va' ma 'ya'misto' Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Cuando jiṉ vitu'yaj cyø'vejyajupø, chajmayaj mumu tiyø lo que chøcyajupø. Entonces Jesusis ñømaṉyaj ne'ti mismo jic vitu'yajupø. Ñømaṉyaj ni i jya'itømø tum cumgu'is cyo'aṉjajme'omo ñøyipø'is Betsaida. ");
INSERT INTO zosNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero cuando myusyaju'cam vøti pø'nis, maṉ mye'chaje jut ityaju. Y cuando nu'cyaju, Jesusis pyøjcøchoṉyaju, y 'yo'nøyajpana'ṉ jujche aṉgui'mbase Dios. Y yac tzocyajpana'ṉ nømna'ṉ syunupø'is va'cø cho'yøyajtøjø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pero cuando tza'i'ajnømu'jcam, nu'cyaj Jesuscø'mø macvøstøjcapyø ñøtuṉdøvø y ñøjmayaj Jesús: ―Yac maṉyaj pønda'm che'ta'mbø cumgu'yomo y ribera'omo yøqui jeni ityajumø, va'cø mye'chaj jejcuy y cu'tcuy. Porque yø'c tø ijtamumø, ni i ja ityø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero Jesusis ñøjmayaju: ―Mitz tzi'tam cu'tcuy. Y je'tis ñøjmayaj Jesús: ―Ja ñø'ijndam más pan sino mosayti ijtu, y metzcuy coque ¿O sunbaja mijtzi va' maṉ ⁿjujyayaj cu'tcuy mumu yøn pønda'm? ");
INSERT INTO zosNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ityajuna'ṉ como mosay mil pøn. Jicsye'c Jesusis ñøjmayaju ñøtuṉdøvø: ―Yac po'csquecyaj mumu pøn. Tumdum nivoya cincuenta cincuenta yac po'csquecyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Y jetse chøcyaju. Y yac po'csquecyaj mumu pøn. ");
INSERT INTO zosNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Entonces pyøc Jesusis mosapyø pan y metzcupyø coque y quengui'm møji y cyømasa'nøyaj je pan y je coque. Y entonces vyende'n pan y vyende'n coque; y chi'yaj ñøtuṉdøvø va'cø syajyaj sonepønomo. ");
INSERT INTO zosNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Y cu'tyaj mumu pøn tasyaju'csye'nomo. Y después piṉyaj doce cøvaca pangømu'taṉ y coque cømu'taṉ aṉchø'yupø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Y tuc eyaco jama que Jesusis nømna'ṉ 'yo'nøy Dios tyumgø'y, y ñøtuṉdøvø jena'ṉ ityaju. Y Jesusis ñøjmayaj ñøtuṉdøvø: ―¿Ti nø chamyaj pø'nis que i'chøṉø? ");
INSERT INTO zosNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Y ñøtundøvø'is 'yaṉdzoṉyaj Jesús: ―Vene nømyajpa que mijtzimete nø'yø'opyapø Juan; y eyapø nømyajpa que mijtzimete Elías. Y eyata'mbø nømyajpa que ya'møcpø tza'maṉvajcopyapø visa'u. ");
INSERT INTO zosNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Y entonces Jesusis ñøjmayaj ñøtuṉdøvø: ―¿Y mitz ti mi ndzamdamba mijtzi que i'chøṉø? Y 'yaṉdzoṉ Simón Pedro'is: ―Mijtzete Cristo Diosis mi ṉgyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesusis ñømgomø'nayaj ñøtuṉdøvø y 'yaṉgui'myaju va' jyana tzajmayaj ni iyø que jetemete Cristo. ");
INSERT INTO zosNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Y Jesusis ñøjmayaju: ―Pyenate øtz va' nøngøt vøti toya, øtz mumu Pø'nis chøn Tyøvø. Øtz ji'nø man pyøjcøchoṉyaje tzambøndøcva'is y pane covi'najø'is, y aṉma'yoyajpapø'is aṉgui'mgupit. Pyenate va'cø yaj ca'tøjø, y mapø chøn visa' tu'cay jama cøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Entonces Jesusis ñøjmayaj mumu pøn: ―O'ca su'nbø man pa't aunque i'is; tiene que va'cø jana tzøjcay cuenda vyin, y tiene que va' it dispuesto tumdum jama va'cø is toya jujche øtz maṉbase is toya cruzcøsi; y jetse hay que va'cø min pa'tø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","O'ca ji'n sun mi ṉgya' øtzcøtoya, mi ndyocopya; pero o'ca mi ṉgya'pa øtzcøtoya, mi ṉgyotzocpa. ");
INSERT INTO zosNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","O'ca mi ṉganatzøcpø'pa mumu tiyø nascøsi, y mi yac tocopya mi ⁿvin y mi ndyocopya, ¿ti mi ṉganatzøcpa? Ni ti ji'n mi ṉganatzøqui. ");
INSERT INTO zosNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","O'ca mi ndø cotza'apya va'cø mi ndø tzajmay ø onde, entonces jetseti øtz ma'ṉbø mi ṉgotza'ajque'te cuando mi'nbøjtzi ø sø'ṉgø'omo, y ø Janda Diosis syø'ṉgø'omo, y masanbø angelesis syø'ṉgø'omda'm, øtz mumu Pø'nis chøn Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Viyuṉsye mi nøjmambya que ityaj pøn yø'qui que ji'ndøc ma cya'yaje hasta que ji'n isyaje jujche 'yaṉgui'mbase Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Y como tucutujtay jama después que cham jetsepø tiyø, Jesusis ñømaṉyaj Pedro y Jacobo y Juaṉ y qui'myaj lomacøsi va ma 'yo'nøy Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mientras Jesusis nø 'yo'nøy Dios, eya quenena'ṉ chøc vyinaca, y tyucu popo sø'ṉu. ");
INSERT INTO zosNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y jovisyeti isyaj metzpøn nø chamdzamneyaj Jesusji'ṉ, y yøṉda'mna'ṉete Moisés y Elías. ");
INSERT INTO zosNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sø'ṉbapø quejyaju, y nømna'ṉ chamyaju jujche maṉba tuc Jerusalén gumgu'yom va' cya' Jesús y jetse va'cø chu'ṉ nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nømna'ṉ 'yøṉgomø'ñajto' Pedro y ityajupøji'n. Y cuando sa'yaju, isayaj Jesusis syø'ṉgø y isyaj metzpøn Jesusji'ṉ te'ñajupø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Entonces cuando Moisés y Eliás nømna'ṉ chu'ṉyaju, chacyaj Jesús jeni. Y ñøjmay Pedro'is Jesús: ―Maestro, vøj va'cø tø ijtam yø'qui. Vøj va'cø ndzøctam tu'cay pe'chtøc; tumø para mitzcøtoya, tumø para Moisescøtoya, y tumø para Eliascøtoya. Pero ñe'c Pedro'is ja myusø ti nø chamu. ");
INSERT INTO zosNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Y mientras que nømna'ṉ chamdzamney Pedro, nu'c o'na jiṉ ityajupøcøsi, y na'chaju cuando o'na'is vyoyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Y myañaj ote o'na'omo nømbapø: ―Yøṉø øjchøṉ ⁿUne ø sunbapø øjtzi. Cøma'nøtyam ti chamba. ");
INSERT INTO zosNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Y cuando cøjtu'cam ote, jen tzø'y Jesús tyumgø'y. Y ñøtundøvø vøngøne'cyaju; hasta que cøt tiempo, ni i ja chajmayaj ti isyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Y jyo'pit mø'ñaj lomacøsi, y vøti pø'nis choṉyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jicsye'cti tum pøn vøti pø'nomo veju y nømu: ―Maestro, nø'mø sungo'nu va ma a'mis ø ⁿune porque tø'cstumbøtite. ");
INSERT INTO zosNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Porque yatzi'ajcu'is ñucpa y yac vejpa y yac tzi'potvitpa y yac aṉ'upu'øpya, y penapit chacpa y tzø'pya ø ⁿune toyapø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Y ⁿo'najo'yajøjndzi mi nønduṉdøvø va' myacputyaj yatzi'ajcuy, pero ja mus myacputyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Y Jesusis ñøjmayaju: ―Mitzta'm ji'n mi vya'ṉjajmondyamepø'is, y yatzipøt mi ṉgui'psocutya'm. ¿Jujche tiempo tiene que øtz va'cø mi nømaṉjandyam pasencia hasta que mi ṉgui'psvitu'tamba? Nømin mi ⁿune yø'qui. ");
INSERT INTO zosNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Cuando une nømna'ṉ tyome'aju'øc, yatzi'ajcu'is yaj quejcu y yac tzi'potvijtu. Pero Jesusis 'yojnay yatzi'ajcuy y yac tzoc jaya'une, y chi'vitu' jyata. ");
INSERT INTO zosNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mumu maya'yaju porque Diosis chøc myøja'ṉombø musocuy. Mientras nømna'ṉ ñømaya'yaj pø'nis mumu tina'ṉ chøc Jesusis, entonces Jesusis ñøjmayaj ñøtuṉdøvø: ");
INSERT INTO zosNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Jamgøchø'y mø'chøqui mi ndzoco'yomo yøṉø ote maṉbase mi ndzajmatyame; øtz mumu Pø'nis chøṉ Tyøvø, øtz ma'ṉbø tzi'ocuyajtøj pø'nis cyø'omo va'cø yaj ca'tøjø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero Jesusis ñøtundøvø'is ji'na'ṉ cyønøctøyøyaje ti nø chamu, porque Diosis ja yac mijnayaj qui'psocuy va'cø cyønøctøyøyajø. Y na'chaju va'cø 'yocva'cyaj Jesús va'cø cha'maṉvacyajøna'n. ");
INSERT INTO zosNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Y ñøtuṉdøvø'is nømna'ṉ chamdzamneyaju jutipø ñe'comda'm más maṉba myøja'ṉo'maje. ");
INSERT INTO zosNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero Jesusis myujsayaju ti nø qui'psyaj choco'yomda'm, y pyøc tum une y cyot vyingøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Y ñøjmayaju: ―O'ca mi mbøjcøchoṉba yøn une ø nøyiṉgøsi, jetse mi ndø pøjcøchoṉgue'tpa øjtzi. Y o'ca mi ndø pøjcøchoṉba, mi mbøjcøchoṉgue'tpa cø'vejupø'is øjtzi. Porque ni ticøs ji'n aṉgui'mipø pøn mumu mijtzomda'm, jet más myøja'ṉombøte. ");
INSERT INTO zosNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Y jicsye'cam Jua'nis ñøjmayu: ―Maestro, ista'møjtzi tum pøn nø myacpujtu'is yatzi'ajcuy mi nøyiṉgøsi. Pero øtz nøjandyam je pøn va'cø jana myacputø, porque ji'n tumø'om vit tø øtzji'n. ");
INSERT INTO zosNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero ñøjmay Jesusis: ―Uy mi nøjañdyamu va jyana myacputø, porque o'ca ji'n tø qui'saye, tø cotzoṉba. ");
INSERT INTO zosNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nømna'ṉ tya'n jyama Jesusis va' pyøjcøchoṉ Møjipø'is. Y paqui chocopit cyoqui'psu va'cø myaṉ Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Entonces Jesusis cyø'vejyaj nu'cscuy va'cø vi'na maṉyajø; y jetse ñu'cscuy maṉyaju y tøjcøyaj tum cumgu'yomo Samaria cumgu'is cyo'anjajme'omo; jen maṉbana'ṉ ñu'csyaj jejcuy Jesuscøtoya. ");
INSERT INTO zosNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ja pyøjcøchoṉyaj Jesús, porque nømna'ṉ myaṉ Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jesusis ñøtundøvø'is Jacobo'is y Jua'nis isyaju que ja pyøjcøchonyaj Jesús, y ñøjayaj Jesús: ―Øjchøṉ mi Ngomi, ¿sunbaja mijtzi va'cø ndø va'ctam juctyøc tzajpomo va'cø pyoṉbø'yaj je yatzita'mbø pøn, como Eliasis chøjcuse? ");
INSERT INTO zosNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Entonces Jesús quenvitu'u y 'yojnayaj Jacobo y Juan, ñøjmayaju: ―Ji'n mi ṉgyønøctøyøtyame jujchepø qui'psocuy vøjø va' mi nø'ijtamø. ");
INSERT INTO zosNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Porque øjtzi mumu Pønis chøn Tyøvø ja mi'nøjtzí va'cø yajyaj pøn, sino mi'nøjtzi va'cø yaj cotzocyajø. Y maṉyaj eyapø che' cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Como nømna'ṉ myaṉyaj jejta'm tu'nomo, ñøjmay Jesús pø'nis: ―Øtz ma mi mba'te jute nø myaṉu. ");
INSERT INTO zosNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Y Jesusis ñøjmayu: ―Tziji'is ityaj chatøc, y møji vityajpapø paloma'is ityaj ñø'sa; pero øjtzi mumu Pø'nis chøṉ Tyøvø ja it ni jut itpa'møjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Y Jesusis ñøjmay eyapø: ―Ma tø pa'tø. Y pø'nis ñøjmay Jesús: ―Øjtzø mi Ṉgomi, tzac ndøvø va' ma nip ø janda vi'na'c. ");
INSERT INTO zosNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero ñøjmay Jesusis: ―Tzacø va' ma ñipyaj ca'upø ñe' ca'upø tøvø'is. Y mijtzi mavø y ma tzajmayaj yempe juti jujche 'yaṉgui'mbase Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jicsye'cti ñøjacye't eyapø'is: ―Ma mi mba'te, øjtzø mi Ṉgomi. Pero tzac ndøvø va' ma o'nøndzacyaj ø ndøjcomda'mbø vi'na. ");
INSERT INTO zosNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero ñøjmay Jesusis: ―O'ca aunque iyø yoscho'tzpa y chacpa yoscuy, ji'n vyø'aj yosaṉ. Jetsetique't o'ca aunque iyø maṉdzo'tzpa øtzji'ṉ y jyajmba lo que chajcupø, ji'n vyøj jetsepø va' it Diosis 'yaṉgui'mgucyø'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cøjtu'cam jetse, cyøpin ndø Comi'is eyapø setenta ñøtuṉdøvø y cyø'vejyaj metzcuy metzcuy va'cø vi'na maṉyajø mumu cumgu'yomda'm y eyata'mbø itcu'yomo jut maṉbamø nu'c ñe'cø. ");
INSERT INTO zosNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Y Jesusis ñøjmayaju: ―Como tum cosecha o'ca it vøti cosecha y usyco'ni pøn yosyajpapø; jetse viyuṉsye Diosis yoscuy vøti ijtu y ja it yosyajpapø. Como tiene que va'cø ndø o'nøtyam vø'cosecha va'cø mye'tz más coyosyajpapø; jetse syunba va'cø mi o'nøndyam Dios va'cø cyø'vejyaj más pøn ñe' yoscucøtoya. ");
INSERT INTO zosNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Maṉdamø; øjtzø mi ṉgø'vejtamba ijtumø na'tzcuy. Como peligro va'cø maṉ borrego ijtumø yach copøn; jetseti itque't peligro va'cø mi myaṉdam jutø øtz mi yac maṉdamba. ");
INSERT INTO zosNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Y uy ñømaṉdam ni morral, ni tumingotcuy, ni vaṉgasnaca. Y tu'ṉomo u mi ngøtzø'tyam vøti hora va' mi ⁿyuschi'tam aunque iyø. ");
INSERT INTO zosNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yempe jutipø tøcmø mi ñdyøjcøtyamba, vi'na'c yuschi'tam yøcse: “Vøj ijtam yøṉø tøjcomo”. ");
INSERT INTO zosNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Y o'ca it pøn jiṉø sunbapø it vøjø, maṉba it vøjø mitzji'nda'm. Pero o'ca ja it vøjpø pøn, mi yuschi'ocuy maṉba vitu' mitzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tzø'tyam jete mismo tøjcomo, jen cu'jtamø, jen uctamø lo que mi ñchi'tandøjpacsye'ṉomo. Porque yospapø pøn tiene que va'cø cyoyojtøjø. Uy mi ṉgyøjtam tøcmaye. ");
INSERT INTO zosNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aunque jutipø cumgu'yomo mi ñdyøjcøtyamba y mi mbyøjcøchoṉdandøjpa, cu'jtam tiyøti mi ñchi'tandøjpapø. ");
INSERT INTO zosNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","O'ca ityajpa ca'eta'mbø jeni, yac tzoctamø, y nøjmatyamø: “Ya mero maṉba aṉgui'm Dios mijtzomda'm”. ");
INSERT INTO zosNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero aunque jutipø cumgu'yomo mi ñdyøjcøtyamba, o'ca ji'n mi mbyøjcøchoṉdandøji, pujtam calle'omo, y nømdamø: ");
INSERT INTO zosNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mi ṉgumgupyo'yo ne'cschø'yupø ø ṉgosocøsta'm, ṉgøjastamba ø ṉgoso pyo'yopit. Jete señamete que it mi ṉgojata'm. Pero mustamø que maṉbana'ṉ aṉgui'm Dios mijtzomda'm”. ");
INSERT INTO zosNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Y mitz mi nøjandya'mbøjtzi; cuando Diosis maṉba yaj coja'ajyaje ijtu'is cyoja; jic jama maṉba ñøcøtyaj toya Sodoma cumgu'yomda'mbø'is. Pero jic ja mi mbyøjcøchoṉyajøpø'is más maṉba ñøcøtyaj toya. ");
INSERT INTO zosNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","”¡Lástima mijta'm Corazín gumgu'yomda'mbø! ¡Lástima mijta'm Betsaida cumgu'yomda'mbø! O'ca Tiro cumgu'yomo y Sidón gumgu'yomo tzøcyajtøjuna'ṉ milagro'ajcuy como tzøctøjuse mijtzomda'm, desde ya'møcti qui'psvitu'yajumna'ṉ jic cumgu'yomda'mbø'is; y como seña myesyajuna'ṉ tucu tzøcyajupø costal y cyøjajsøyajpana'ṉ vyin cujyamji'n. ");
INSERT INTO zosNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Por tanto Tiro y Sidon cumgu'yomda'mbø'is menos maṉba ñøcøtyaj toya que ji'n mitzta'm jic jama cuando Diosis maṉba cyøme'chaj mumu pøn cyojaji'n. ");
INSERT INTO zosNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y mijtzi Capernaum gumgu'yomda'mbø'is; mi ṉgomo'tyamba que vøj mi ijtamu como tzajpomse, pero hasta yatzi'ajcu'yomo maṉba mi yac mø'ndandøj cø'yi. ");
INSERT INTO zosNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Entonces Jesusis ñøjmayajque't ñøtundøvø: ―Mi ṉgyøma'nøtyambapø'is mijtzi, øtz cøma'nøque'tpati'tzi. Ji'n mi syundamepø'is mijtzi, ji'ndi sunque't øjtzi. Y ji'n sunipø'is øjtzi, ji'n syungue't cø'vejupø'is øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Después cuando vitu'yaj je setentata'mbø, casøyaju, ñøjmayaj Jesús: ―Øjchøn mi Ṉgomi, hasta yatzi'ajcu'is cøma'nøyajpøjtzi mi nøyiṉgøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Y Jesusis ñøjmayaju: ―ⁿIsøjtzi Satanás quejcupø tzajpomo jujchem tum rayu quecpase. ");
INSERT INTO zosNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Øjchøṉ mi ndzi'tamba aṉgui'mguy va'cø mi nde'ngøpajcøtyam tzan y cacve, y va'cø mi yajandyam mumu mi enemigo'is pyømi, y ni ti'is ji'n mus mi nchøjcatyam ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero uy mi ṉgyøcajsøtyamø o'ca yatzi'ajcu'ista'm mi ṉgyøma'nøndyamba mijtzi, sino cøcajsøtyamø o'ca mi nøyinda'm jachø'yupøte tzajpomo. ");
INSERT INTO zosNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jicø misma hora Masanbø Espiritu Santo'is yaj casøcomø'n Jesús; Jesús nømu: ―Øjtze mi vøṉgotzøcpa, Jatay, mijtzi Cyomipø tzajpis y nasis. Porque ṉgøvø'n mijtzi yøcseta'mbø tiyø va'cø jana cyønøctøyøyaj musoyajpapø'is y cyønøctøyøyajpapø'is; y che'tambø unese ji'n myusoyajepø, jet mi ⁿyaj cønøctøyøyaju. Vøj jetse, Jatay, porque jetse mi syunu. ");
INSERT INTO zosNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","”Ø ṉgø'omo cyot ø Janda'is mumu tiyø. Ni i'is ji'n comus øjtzi øtz Diosis chøṉ 'Yune, sino ø Janda'is comuspøjtzi. Y ni i'is ji'n cyomus ø Janda sino øtz je'is 'Yune chøṉø, øtz ṉgomuspøjtzi. Solamente i su'nbø ⁿyaj comusø, je'is cyømusque'tpati ø Janda. ");
INSERT INTO zosNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Entonces Jesús que'naj vitu'u va'cø 'ya'myaj ñøtuṉdøvø, y jejti ñøjmayaju jana myan eyata'mbø'is: ―Contentoco'nipøte ispapø'is ti ndzøcpøjtzi como mi istambase mijtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Porque mi nøjandya'mbøjtzi; vøti tza'maṉvajcoyajpapø'is y møja'ṉ aṉgui'myajpapø'is sununa'n isyajø lo que nø mi istamupø mijtzi, pero ja isyajø. Y nømna'ṉ sun myañajø mitz nø mi mandamupø, pero ja myañajø. ");
INSERT INTO zosNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tum aṉma'yopyapø Moisesis 'yaṉgui'mgupit te'nchu'ṉu va' 'yaṉgøva'quis Jesús y ñøjmayu: ―Maestro, ¿ti vøjø va' ndzøcø va'cø nø'it øjtzi ji'n yajepø quenguy? ");
INSERT INTO zosNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesusis ñøjmayu: ―¿Tiyø jachø'yupø Moisesis 'yaṉgui'mgu'yomo? ¿Jujche mi ndu'nba? ");
INSERT INTO zosNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Je'tis 'yaṉdzoṉu Jesús ñøjmayu: ―Sunø mi Ṉgomi Dios mi ndumø tzocoy, y mi ndumø anima, y mumu mi mbømipit, y mumu mi ṉgui'psocupit; y sunø mi ndøvø como mi sunbase mi ⁿvin. ");
INSERT INTO zosNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesusis ñøjmayu: ―Vøj mi 'yaṉdzo'ṉoyu. Jetse tzøcø, y mi ṉgyenba. ");
INSERT INTO zosNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero pø'nis nømna'ṉ sun cyot vyin vøjø y ñøjmay Jesús: ―¿Iyø ø ndøvø? ");
INSERT INTO zosNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesusis 'yaṉdzoṉu ñøjmayu: ―Tum pøn tzu'ṉ Jerusalén gumgu'yomo y nømna'ṉ myaṉ tu'ṉomo va' myø'n Jericó cumgu'yomo. Ñucyaj nu'myajpapø'is, yac tzacyaj tyucu, y chaṉjetjetvøyaju y maṉyaju, tzaṉdu'yupø chacyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","De repente nømna'ṉ myø'n tum Israel pane jicø tu'ṉomo, y jen pya't tzaṉdu'tyøjupø, pero tu'ṉu saya'om cyøjtayu. ");
INSERT INTO zosNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jetsetique't tum levita pøn yospapø masandøjcomo nu'que't tome jicø lugar y isu, y jendi cyøjtacye'tu tu'ṉu saya'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero tum Samaria cumgupyøn jendina'ṉ nø vyitque'tu mismo tu'ṉomo, y nu'c tome yajupø pøngø'mø, y isu, y tyoya'nøyu. ");
INSERT INTO zosNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Y nu'c je'tecø'mø y vyajtay yaje, y cho'yøjay yaje aceiteji'ṉ y vinuji'ṉ, y yac po'cs ñe' cyopøn y ñømaṉ cojejcu'yomo y jen cuendatzøjcu. ");
INSERT INTO zosNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jyo'pit nømna'ṉ chu'ṉu'øc, ñøput metzcuy tumin nøjayajpapø denario y chi' vø'tøc y ñøjmayu: “Tø cuidatzøjcay yajupø, y mumu lo que tiyø gasto jujche putpa, cuando vitu'que'tpøjtzi, jeni mi ṉgoyojpøjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Entonces Jesusis ñøjay aṉma'yopapø Moisesis 'yaṉgi'mgupit: ―¿Mitz ti mi ndzamba? ¿Jutipø yøṉø tu'caṉbøn ñø'oy como yajupø pø'nis tyøvøse cuando oy yacsutzøcyaj nu'mba pø'nis? ");
INSERT INTO zosNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Y aṉma'yopa pø'nis ñøjmayu: ―Jicø tyo'ya'ṉøyupø'is ñø'oy como tyøvøse. Entonces Jesusis ñøjmayu: ―Mavø, y jetseti mitz ma tzøjque'ta. ");
INSERT INTO zosNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Entonces cuando nømna'ṉ vyityaj Jesús, tøjcøyaj tum che'pø cumgu'yomo. Y tum yomo ñøyipø'is Marta, je'is tyøjcom yac tøjcøy Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Y jena'ṉ itque'tu Marta'is tyøvø ñøyipø'is María; y jet po'csu Jesusis cyosocø'mø y cyøma'nøjapyana'ṉ 'yote. ");
INSERT INTO zosNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero Marta nømna'ṉ yosu afligido, y por eso tyo'møy Jesús y ñøjmayu: ―¿Ji'nde nø mi ndzøjcayupø cuenda que ø ndøvø'is tzajcøjtzi y ø ndumgø'y nø yac yosu? Nøjmayø va'cø cotzova. ");
INSERT INTO zosNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero Jesusis ñøjmay: ―Marta, Marta; mitz afligido mi ⁿijtu, y je'csetejpa mi ndzøcpa vøtipø yoscuy. ");
INSERT INTO zosNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero tumbø titi vøj ndø tzøcø. Y Maria'is más vøjpø ti syunu; y ji'n ma yac jøcøjatyøji tiyø nø syunu. ");
INSERT INTO zosNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Entonces jicsye'øc Jesusis nømna'ṉ 'yo'nøy Dios tum lugajromo, y cuando 'yo'nø'aṉjeju, tum ñøtuṉdøvø'is ñøjmayu: ―Øjtzø mi Ṉgomi, tø aṉmatyam va' o'nøtyam Dios, jujche Jua'nis 'yaṉmayuse ñe' ñøtuṉdøvø va'cø 'yo'nøyaj Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Entonces Jesusis ñøjmayaju: ―Cuando mi o'nøndyamba Dios, nømø: Øjtzø mi Janda tzajpom mi ⁿijtupø'is, Yaj cønatzøjatyøj mi nøyi. Minø y mi aṉgui'moya. Yac tzøctøj mi sunbase nascøsi, como tzøctøjpase tzajpomo. ");
INSERT INTO zosNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tø tzi'tam ndøvø ø jamaṉgøtcuy tumdum jama. ");
INSERT INTO zosNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Y tø yaj cotocojatyam ø ṉgojata'm, porque øtz yaj cøtocojatyaṉque'tpati'tzi ti tzøjcatya'mbøjtzi aunque i'is. Uy tø yaj quectam cojapa'tcu'yomo cuando tzøjquistandøjpøjtzi, pero tø cotzoṉdamø va'cø jana ndzøctam lo que ji'n vyøjpø. ");
INSERT INTO zosNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Y Jesusis ñøjayajque'tuti: ―Supongamos it mi amigo, y mi ñu'cpa je'is tyøcmø cuc tzu'omo y nøjambya mijtzi: “Amigo, tø cactzi' ndøvø tu'cay pan. ");
INSERT INTO zosNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Porque nu'c ø ndøcmø tum amigo nø cyøjtupø, y ja it ni tiyø va' ø ndzi'ø”. ");
INSERT INTO zosNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Y tøjcom ijtupø'is 'yaṉdzoṉba y nømba: “Uy tø jorvatzøqui, porque aṉdyuṉ aṉgoju'am, y ø une'nda'm øṉyaju'am øtzji'ṉ. Ji'n ø mus te'ñchu'ṉ va' mi ndzi'ø”. ");
INSERT INTO zosNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jicsye'c Jesús nømu: ―Pero mi nøjambyøjtzi; aunque por ser amigo ancø ji'ṉ te'nchu'ṉi va'cø mi nchi'ø; pero por tanto mi ⁿjorvatzocpa ancø, por eso maṉba ṉgyøte'nchuṉ tøjcom ijtupø pø'nis va'cø mi nchi' mumu lo que ti nø mi sunu. ");
INSERT INTO zosNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Por eso mi nøjandyaṉque'tpøjtzi: Va'ctamø; y mi nchi'tandøjpa. Me'tztamø, y mi mba'jtambati. Cocstamø; y mi 'yaṉdzoṉdandøjpa. ");
INSERT INTO zosNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porque mumu vya'cpapø'is pyøjcøchoṉba ti nø vya'cu; y mye'tzpapø'is pya'tpa ti nø mye'tzu y cyocspapø'is andyuṉ, aṉdzoṉyajtøjpa. ");
INSERT INTO zosNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Seguro que ja it ni jutipø pøn mijtzomda'm chi'papø'is 'yune tza' o'ca vya'cpa pan. Ni i ja it chi'papø'is 'yune tzan o'ca vya'cpa coque. ");
INSERT INTO zosNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Y ni i ja it chi'papø'is 'yune cacve o'ca vya'cpa poca. ");
INSERT INTO zosNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aunque mitzta'm mi yaṉdzita'mbøte, pero mi ndzi'tamba mi ⁿune vøjpø tiyø. Entonces más seguro tzajpombø ndø Janda'is maṉba mi ñchi'tam Masanbø Espiritu Santo o'ca mi ⁿva'ctamba ñe'jcøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesusis nømna'ṉ myacput yatzi'ajcuy yac uma'ajpa'is pøn. Cuando put yatzi'ajcuy, umapø pøn onu, y ñømaya'yaj pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero veneta'mbø nømyaju: ―Covi'najøpø yatzi'ajcuy ñøyipø'is Beelzebú, je'is cyotzoṉba Jesús va'cø myacput yatzi'ajcuy tøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Eyata'mbø'is sununa'ṉ yaj quecyaj Jesús 'yotecøsi, y por eso ñøjmayaju va'cø yaj quej cotza'mocuy tzajpombø. ");
INSERT INTO zosNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Jesusis myusu jujche nø qui'psyaju y ñøjmayaju: ―O'ca aṉgui'mbapø'is pyøn quipyajpa ñe'comda'm, tocopya 'yaṉgui'mguy, y o'ca familia quiptocoyajpa ñe'comda'm, yajpa fyamilia'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jetseti o'ca Satanasis ñøquijpa vyin, maṉba yaj 'yaṉgui'mguy. Jetse mi nøjandya'mbøjtzi porque mitz ñømdamba que Beelzebu'is ñøyicøsi nø'mø nømbut yatzi'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pero o'ca øtz macputyajpa yatzi'ajcutya'm Beelzebuji'ṉ, ¿será que jetji'ṉ mi ndøvø'is myacputyajque'tpa? Por eso ji'n mus mi ndø queyaṉ ṉgøtza'møyø, porque mismo mi nønduṉdøvø'is jetseti chøcyajque'tpa. ");
INSERT INTO zosNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero o'ca Diosis cyø'ji'ṉ nømbutyajpa øtz yatzi'ajcuy, entonces viyuṉsye Diosis mi yac istamba 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","”Cuando pømi'øyupø y tø'ṉgu'yøyupø pø'nis cuidatzøcpa tyøc, vøj ñø'itpa ti ñø'ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero cuando minba más pømi'øyupø pøn que ji'n ñe'cø, minbapø'is cyønu'capya vø'tøc y yac tzu'ṉapya mumu tø'ṉguy maṉbapøpi'jna'ṉ cyoquip vyin, y vye'nbø'japya ti pya'tay tyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","”Aunque jujchepø pøn o'ca ji'ndyet øtzji'ṉbø, qui'sapyøjtzi. Y ji'n yosepø øtzji'ṉ va'cø yac tu'myaj pøn øtzcø'mø, je'is yø'qui jeni yac potyocoyajpa. ");
INSERT INTO zosNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","”Cuando yatzi'ajcuy putpa pø'nomo, vitpa tøtzø nasomo, mye'tzpa jut ma sapøqui, y o'ca ji'n pya'te, nømba: “Maṉba vitu' mismo pø'nomo ju'tø pujtumø como si fuera ø ndøjcomo”. ");
INSERT INTO zosNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cuando nu'cpa, pya'tpa tøc cøpejtupø y vøjøtzøjcupø. ");
INSERT INTO zosNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jicsye'jcam yatzi'ajcuy maṉba y mye'tzpa eyapø cu'yay yatzi'ajcuy más yatzita'mbø que ji'n ñe'cø y ityajpa mismo je pø'nomdique't; y jetse je pøn más peor tucpa que ji'n vi'nase. ");
INSERT INTO zosNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Cuando Jesusis nømna'ṉ cham yøcseta'mbø tiyø, vej tum yomo vøti pø'nomo, nømu: ―¡Contento mi ⁿyac pø'najupø'is y mi ñchi'upø'is tzu'tzi! ");
INSERT INTO zosNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero Jesusis ñøjmayu: ―¡Viyuṉete, pero más contento myañajpapø'is Diosis 'yote y cyøjamyajpapø'is ti nø chamu! ");
INSERT INTO zosNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Y tu'mgomø'ñaj vøti pøn, y Jesusis ñømdzo'tzayaju: ―Yøti ityajupø pøn yatzico'nita'm; vya'cyajpa seña va'cø isyajø. Pero ji'n ma yac isyajtøji ni jutipø seña, sino lo que jujche tza'maṉvajcopyapø Jonás tujcuse, jet señamete. ");
INSERT INTO zosNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Como jujche Jonás oyuse tyuqui, jet señamete Nínive cumguy pøngøtoyata'm. Jetsetique't øjtzi mumu Pø'nis chøṉ Tyøvø, otz ma'ṉbø sena'aje yøti ityajupø pøngøtoya. ");
INSERT INTO zosNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jic jama cuando Diosis maṉba cyøme'chaj mumu pøn cyojapit, jic aṉgui'mbapø yomo minupø sujromo va'cø tyu'n ya'møcpø aṉgui'mba Salomón, je yomo maṉba te'ñaj yøti ityajupø pønji'ṉ Diosis vyi'naṉdøjqui, y je yomo'is maṉba yaj queje que más ityaj cyoja yøti ityajupø pø'nis ñe' que menos je'is ñe'. Porque je yomo más ya'ipø nasom tzu'ṉu y minu va'cø cyøma'nøjay Salomo'nis qui'psocuy; y yø'c it øjtzi más qui'psocu'yøyupø que menos Salomón, y ji'n ø cøma'nøyajøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Y jetsetique't jic cøme'tzocuy jama'omo, Nínive cumgu'yomda'mbø pøn maṉba te'ñaj yøti ityajupø pønji'ṉ Diosis vyi'naṉdøjqui. Y Nínive cumgu'yomda'mbø'is maṉba yaj quejyaje que más ityaj yøti ityajupø pø'nis cyoja que menos je Nínive cumgu'yomda'mbø'is ñe'. Porque Nínive cumgupyø'nis qui'psvitu'yaju cuando Jonasis cha'maṉvajcayaj Diosis 'yote, y yø'c it øjtzi más myøja'ṉombø tza'maṉvajcopyapø chøṉø que ji'n Jonás; y yøti ityajupø pø'nis ji'nø cøma'nøyajøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","”Nø'a va'cø ndø ja'mbøyi, ji'n ndø cøvø'ni, ni jin ndø cømucsøy tzicapit; sino ndø cotpa candedero'omo va'cø syø'ṉø, va'cø isyaj sø'ngø tøjcøyajpapø'is. ");
INSERT INTO zosNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ndø vindøm por cuenta ndø coṉña'is ño'a. Cuando mi vindøm sø'ṉba vøjø, muspa mi vindø, pero cuando ji'n syø'ṉ mi vindøm, también mi ṉgoṉña pi'tzø'om ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tzøjcay cuenda mi ⁿvin mi ndzocoy va'c mi nø'it vøjpø qui'psocuy jujchem sø'ṉgø'om tø ijtuse, que va' jyana mi it pi'tzø'ajcu'yomse. ");
INSERT INTO zosNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Y jetsemete o'ca mumu mi ṉgoṉña sø'ṉgø'omo ijtu, ji'n it pi'tzø'ajcu'yomo, mumu sø'ṉba jujche tum no'ase suñi mi syø'ṉapya. ");
INSERT INTO zosNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cuando Jesús o'naṉjeju, tum fariseo pø'nis ñøjay Jesús va' cyu't jetji'ṉ. Y Jesús tøjcøy tyøjcomo y po'cs myesyacø'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Y fariseo'is ñømaya'yaju va' is que Jesús ja cyø'che' va'ṉjamocuycøtoya antes que va'cø ma cyu'tø. ");
INSERT INTO zosNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Entonces ndø Comi'is ñøjayu: ―Mitzta'm fariseo'is mitz mi ngøtze'tamba mi mbaso y mi mblato vingøsi, pero jojmo mi ndzoco'yomo tas nu'mguy, tas yatzitzoco'yajcuy. ");
INSERT INTO zosNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Mi ⁿjyovinda'mbøte! Tzøctam cuenda que chøjcupø'is vingøspø, mismo je'is chøc jojmopø. ");
INSERT INTO zosNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pero sajtzi'tam pobre vene mi nø'ijtu'cse'ṉomo, y jetse mumu tiyø maṉba it cøvajcupø mitzcøtoya. ");
INSERT INTO zosNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","”Pero lástima mijtzi fariseo'ista'm; maṉba mi ndyoya'istame. Porque o'ca mi nø'ijtam majcay mi'tzi yerba buena, tum mi'tzi mi ndzi'tamba pane por cuenda como si fuera Dios nø mi ndzi'upø. Jetseti mi ndzi'tamba vene mi nø'ijtupø ruta y mumu ta'nø. Aunque mi ndzøctamba jetse, ji'n mi ndzøctam cuenda lo que mi ndzøcpa o'ca vøjø, ji'n vyøjø; y ji'n mi sundam Dios. Vøjø va'cø mi ndzi'tam pane vene vene mi nø'ijtupø, pero va'cø jana jajmbø' eyata'mbø tiyø va'cø mi ndzøctamø. ");
INSERT INTO zosNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","”¡Lástima mijta'm fariseo'ista'm; maṉba mi istam toya! Porque sundamba mijtzi va'cø mi mbyo'cstam covi'najø po'cscu'yomo conocscuy tøjcomo, y va'cø mi ñchi'tandøj dyus plaza'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","”¡Lástima mijta'm mi 'yaṉma'yoñdyambapø'is aṉgui'mgupit, y fariseo'is, mi aṉgøma'cøtyambapø'is; maṉba mi istam toya! Porque como tum nijpoñømbamø ji'n quejepø, y jen vijnømba vingøsi, y ji'n myusyaje o'ca ñijpoñøm jojmo; jetseti mijta'm ji'n quejtaṉgue'te o'ca yandzita'm mi ndzoco'yomda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Entonces 'yaṉdzoṉ tum aṉma'yopapø'is aṉgui'mgupit ñøjmay Jesús: ―Maestro, cuando mi ñømba jetse, mi ndø qui'satyaṉque'tpa øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Y Jesusis ñøjmayu: ―¡Lástima mijta'm 'yaṉma'yoñdyambapø'is aṉgui'mgupit; maṉba mi istaṉgue't toya! Jujche pø'nis o'ca cyotyajpa pyøndøvøcøsi tzømi ji'n tø jø'nipø y ñe' ji'n sunipø cyøpi'cøyajø, jetse mitz ngojtamba vøti aṉgui'mguy eyapøcøsi, pero ni mitz ji'n mi ⁿyaj copujtam lo que jujche mi aṉgui'mdambase. ");
INSERT INTO zosNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","”¡Lástima mijta'm; manba mi istam toya! Mi ṉgøyostamba oyumø nipyajtøji tza'maṉvajcoyajpapø pøn, oyupø yaj ca'yaj mi janda tzu'ṉgu'ista'm. ");
INSERT INTO zosNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Viyuṉsye jetse mi yaj quejtamba que mi vø'møndyamba ti chøcyaju mi janda tzuṉgu'is, porque je'is yaj ca'yaju tza'maṉvajcoyajpapø, y mitz mi ṉgøyostamba oyumø nipyajtøji. ");
INSERT INTO zosNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","”Ne'camete nøm Dios qui'psocupit: “Ngø'vejyajpøjtzi tza'maṉvajcopyapø y apostoles. Vene maṉba yaj ca'yaje y vene maṉba yacsutzøcyaje”. ");
INSERT INTO zosNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Por eso yøti ityajupø pøn maṉba toya'isyaje yaj ca'yaju aṉcø mumu tza'maṉvajcoyajpapø yaj ca'yajtøjupø desde que tzo'tz nasacopac. ");
INSERT INTO zosNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Vi'na yaj ca'tøj Abel, y último yaj ca'tøj Zacarías masandøc aṉdyuṉgø'mø tome altarcø'mø, y vøti eyata'mbø yaj ca'yajtøju. Jetcøtoya Diosis maṉba yaj coja'ajyaj yøti ityajupø pøn porque jø'tu desde ya'møcsye'ṉomo je'is ñø'pin. ");
INSERT INTO zosNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","”¡Lástima mijta'm mi 'yaṉma'yoñdyambapø'is aṉgui'mguji'ṉ! Maṉba mi istam toya. Porque muspana'ṉ mi aṉmandyam vøjpø aṉma'yocuy, pero ni mi ne'c ji'n mi aṉmandyame, ni ji'n mi yac aṉmandyam sunbapø aṉmayajø. ");
INSERT INTO zosNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Cuando tzu'ṉ Jesús jicø tøjcomo, 'yaṉma'yoyajpapø'is aṉgui'mguji'ṉ y fariseo'sta'm pømina'ṉ ñø'onguiptzo'chaj Jesús, y nømna'ṉ 'yocva'cyaju va' cham mumu tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Velta mye'chajpana'ṉ a ver jujche muspa yac ondocoyajø 'yoteji'ṉ va'cø mus cyøtza'møyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mientras jetse tujcu, oy tu'myaj vøti pøn ji'n musicsye'ṉom ndø mayø, hasta que na cøte'nøyajtøju. Y Jesusis vi'na ñømdzo'tzayaj ñøtuṉdøvø: ―Tzøctam cuenda fariseo'sta'm 'yaṉma'yocuy; porque como yac poṉoṉbapø'is pan ji'n cyeje, jetse ji'n queje 'yaṉma'yocuy que aṉgøma'cø'oyajpapøtite. ");
INSERT INTO zosNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Porque como mumu tiyø cøvø'nupø eya jama maṉba mustøji; jetse maṉba musayajtøj qui'psocuy jujche yatzita'm. ");
INSERT INTO zosNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Así es que mumu ti mi nu'mdzamba pi'tzø'omo, sø'ṉgø'om maṉba mandøji. Lo que mi nu'mgø'o'nøyupø cyojicø'mø tøjcomo, maṉba vejpøtøj tøjcøsi va'cø myandøj aunque juti ya'isye'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","”Pero øtz mi nøjandya'mbøjtzi, øjtzø mi ndøvøta'm: uy ña'tztam yaj ca'papø'is ndø coṉña; y tø yaj ca'tøju'cam, ni ti más ji'n mus tø tzøjcatyamø. ");
INSERT INTO zosNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero ma'ṉbø mi ndzajmatyame i va'cø mi na'tztamø: Na'tztam muspapø'is mi ṉgyojtam yatzi'ajcu'yomo mi ⁿyaj ca'ujcam. Jet mi ndzamvøjøtzøjcatya'mbøjtzi, jet vøj va'cø mi na'tztamø. ");
INSERT INTO zosNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","”Ndø ⁿma'ajpa mosay che'pø paloma metza pesocøsi. Pero aunque ji'n vyaletzøc más, ni tumø je paloma ji'n jyajmbø' Diosis. ");
INSERT INTO zosNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Y mijtzi hasta mi vañdya'm mi ṉgopajcøsta'mbø mumu mayecøspøte. Por eso uy mi ña'tztamu, porque más mi yamdamba que ji'n vøti che'pø paloma. ");
INSERT INTO zosNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","”Øtz mi ⁿnøjandyambøjtzi: o'ca aunque i'is chamba pø'nis vyi'naṉdøjquita'm que va'ṉjamba øjtzi mumu Pø'nis chøṉ Tyøvø; entonces øtz ma'nbø ndzamgue't Diosis 'yaṉgelesis vyi'naṉdøjquita'm que jic pøn øjtzene. ");
INSERT INTO zosNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero o'ca aunque i'is chamba pø'nis vyi'nandøjquita'm que ji'nø va'ṉjam øjtzi, entonces øtz ma'ṉbø ndzamgue't Diosis 'yangelesis vyi'naṉdøjquita'm que jic pøn ji'ndyet ø ne'. ");
INSERT INTO zosNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","”O'ca aunque i'is tze'mba øjtzi mumu Pø'nis chøṉ Tyøvø, Diosis manba yaj cotocoye. Pero oca aunque i'is cyø'o'nøpya Masanbø Espiritu Santo, ji'nam ma yaj cotocoy Diosis. ");
INSERT INTO zosNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","”Cuando mi ñømaṉdandøjpa pø'nista'm cyonocscuy tøjcomo, o sea aunque jutipø aṉgui'mba'is vyi'nomo va'cø mi ṉgyøtza'møtyandøjø; uy 'yuṉgui'ajtame jujche maṉba mi aṉdzo'ṉotyame o ti maṉba mi ndzamdame. ");
INSERT INTO zosNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Porque je misma hora Masanbø Espiritu Santo'is maṉba mi ⁿyac mustame jujche vøj va'cø mi ndzamdamø. ");
INSERT INTO zosNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Entonces tum pøn vøti pø'nomo nømu: ―Maestro, nøjmay ø ndøvø va'cø ve'ndzi'ø ø erejenciata'm. ");
INSERT INTO zosNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Y Jesusis 'yaṉdzoṉu: ―Tzambøn, ja ni i'is tzi' øjtzi a'ṉgui'mguy va'cø ve'nbø' jetsepø mijtzomo. ");
INSERT INTO zosNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Y Jesusis ñøjmayaj mumu pøn: ―A'mdamø y tzøjcatyam cuenda jana mi aṉsundam aunque tiyø va'cø mi nø'indø. Porque va'cø ndø nø'it aunque tiyø vøti, ji'ndyet jej ndø quenguy. ");
INSERT INTO zosNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Entonces Jesús aṉma'yoyu historiaji'ṉ, nømu: ―Ijtuna'ṉ tum ricupø pøn, y tumgo ame más vøti tø'maju yosaṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Y pø'nis qui'pspana'ṉ choco'yomo y nømu: “¿Tiyø ø ndzøcpa? Ja it jut ngotpa ø ṉgosecha”. ");
INSERT INTO zosNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Entonces nømu: “Yøcse ma'ṉbø ndzøqui. Ma'ṉbø yaj ø ndroja y ma'ṉbø más møja ndzøqui. Y jen ma'ṉbø ṉgojtaṉne'c mumu ø ṉgosecha y mumu lo que nø'ijtupø øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yøcse ma'ṉba ṉgui'ps ø ndzocø'yomo: Yøti nø'it øtz vøti mumu tiyø aṉne'cupø para vøti amecøtoya. Ma'ṉbø sapøqui, ma'ṉbø cu'ti, ma'nbø uqui, ma'ṉbø casøyi”. ");
INSERT INTO zosNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero ñøjay Diosis: “ⁿJyovi mijtzi. Yøṉ tzu'cøsi maṉba mi ⁿyajandyøj mi ṉguenguy, y mi aṉne'ṉgupø aunque tiyø, eyapøcøtoya maṉba tzø'y”. ");
INSERT INTO zosNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jetse tucpa pøn aṉne'cupø'is aunque tiyø para vyingøtoya, y ja it ricu'ajcuy Diosis vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Y Jesusis ñøjmay ñøtuṉdøvø: ―Jetcøtoya mi nøjañdya'mbøjtzi: U mi nømaya'tam ti maṉba mi ṉgu'jtame, jujche maṉba mi ijtame; ni u mi nømaya'tam jujche maṉba mi nducu'øtyam mi ⁿvin. ");
INSERT INTO zosNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Porque ndø quenguy valetzøcpa mas que ndø cu'tcuy; y ndø coṉña mas valetzøcpa que ndø tucu. ");
INSERT INTO zosNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tzøjcatyam cuenda palomata'm, que ji'n ñipyaje ni ji'n piṉyaje, ni ti ja ñø'it 'yaṉne'cupø; ni troja ja ñø'ityajø; y Diosis pyø'nøyajpa. Pero mijtzi más vøti mi ⁿyac yamdamba que ji'n palomata'm. ");
INSERT INTO zosNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Será que it mijtzomda'm muspapø ye'ṉaṉøy medio metro maya'pa aṉcø? Pues ji'n mus ndø tzøc jetse. ");
INSERT INTO zosNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Entonces o'ca ni ti ji'n mus mi yac tzøctam maya'cu'is, ¿ti'ajcuy mi myaya'ndamba aunque ticøsi? ");
INSERT INTO zosNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","”Tzøctam cuenda jøyø, jujche tzocyajpa. Ji'n yosyaje, ni ji'n pi'tyaje, pero mi nøjandya'mbøjtzi que ni møja'ṉ aṉgui'mba Salomón vøjpø itcu'yomo ja o mescøyoje va'cø chi'ṉø como tum jøyø chi'ṉbase. ");
INSERT INTO zosNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jetse Diosis suñi yaj quenba ta'nø tza'ma'omo, aunque ta'nø yøti ijtu y jomi ndø cotpa juctyøjcomo. Pero más seguro Diosis maṉba mi yac mescøyojtam mijta'm; mijtzi mi mbyønda'm usypøtite mi va'ṉjajmoṉgutya'm. ");
INSERT INTO zosNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Por eso u mi ñømdamu: ¿Ti maṉba ndø cu'jtame, ti manba ndø ⁿuctame? U mi uṉgui'ajtamu jetse. ");
INSERT INTO zosNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Porque mumu jetseta'mbø tiyø qui'psme'chajpa mumu nascøsta'mbø pø'nis. Pero ndø Janda Diosis nømdi myusu que jetseta'mbø tiyø mi sundamba. ");
INSERT INTO zosNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mejor me'tztamø va'cø 'yaṉgui'm Dios mi ndzoco'yomda'm, entonces Diosis maṉba mi ñchi'aṉøtyam aunque ti'is mi nchøjcatyamba falta. ");
INSERT INTO zosNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","”U mi ña'tztamu, usy mi ndu'mdambapø'is, como borregose ø mi ṉgoquengutya'm. Porque it mi Janda Diosis gyusto va'cø mi 'yaṉgui'mdamø y va'cø mi ṉgyoquendamø. ");
INSERT INTO zosNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Por eso ma'ajtam mi nø'ijtamupø y sajtzi'tam pobreta'mbø. Jetse maṉba mi nø'ijtam como si fuera tumingotcuy ji'n pyeca'ajepø, maṉba mi nø'ijtam vøjta'mbø tiyø aṉne'cupø tzajpomo, ji'n myaṉba yajepø, ji'n ñu'quimø nu'mbapø; ni pønbø'nis ji'n yac yø'imø ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Porque jut ijtumø mi riṉgu'ajcuy, jen sunba mi indø. ");
INSERT INTO zosNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","”Como tum pøn vajtupø cintura, no'a ja'pøyupø it listo, jetse mitz ijtaṉgue't listo. ");
INSERT INTO zosNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ijtam mijtzi como jujche muchacho nø jyo'cyaju'is cyomi, o'ca oy cyomi co'tøjcajcu'yomo y maṉba vitu'i. Y mientras muchacho tzø'yaj cyomi'is tyøjcomo y tiene que va'cø jyo'cyaj cyomi hasta ti hora nu'cpa, va'cø jø'nø jø'nøti aṉvajcay aṉdyuṉ cyomicøtoya cuando minba y yuschi'pa. ");
INSERT INTO zosNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Contento maṉba ityaj jic muchacho o'ca tzu'queñaju nø jyo'cyaju cuando minba cyomi, y jetse pya'tyajpa cyomi'is nø jyo'cyajupø. Viyunsye mi nøjambya que mismo vø'tøjquis maṉba chøc cu'tcuy y maṉba yac po'csyaj muchacho mesyacø'mø, y maṉba chi'yaj cu'tcuy. ");
INSERT INTO zosNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","O'ca nu'cpa paṉguctzu, sino a las tres, ti hora nu'cpa; o'ca pya'tpa muchacho nø jyo'cyajupø, entonces contento maṉba ityaj jicø muchacho. ");
INSERT INTO zosNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yøṉø mustamø: o'ca myuspana'ṉ vøtøjquis tiyø ora minbana'ṉ nu'mbapø, viyuṉsye jyo'cpana'ṉ, y ji'na'ṉ chaque va' yac tøjcøy tyøjcomo va' ñu'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jetseti mitzta'mgue't ijtamø jajmecøsi. Porque je hora mi ṉgomo'pya que ji'n ma nu'qui, jicsye'c ma'ṉbø nu'c øjtzi mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Entonces ñøjay Pedro'is Jesús: ―Øjtzø mi Ṉgomi, ¿para icøtoya nø mi ndzam yøn aṉma'yocuy; para na's øtzcøtoyata'm, o si no para numu pøngøtoya? ");
INSERT INTO zosNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ñøjmay Pedro ndø Comi'is: ―Mi ne'c mi muspa jutipøt vøjpø y jutipøt qui'psocu'yøyupø chøsi lo que jutipø cyomi'is maṉba cyot va'cø 'yaṉgui'myaj eyapø coyosyajpapø, y va'cø myujcayaj jyamacøtcuy cuando nu'cpa hora. ");
INSERT INTO zosNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Contento maṉba it je chøsi o'ca minba cyomi y pyatpa nø chøjcupø jujche aṉgui'muse. ");
INSERT INTO zosNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Viyuṉsye mi nøjmambya: jicø chøsi cyotpa cyomi'is va' yaṉgui'moy mumu ticøsi lo que ñø'ijtupø. ");
INSERT INTO zosNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero supongamos jicø chøsi nømba choco'yomo: “Maṉbatøc ya'e ø ṉgomi, ji'ndøc ma mini”, y chaṉdzo'chajpa cyoyospa tøvø, y chaṉdzo'chajpa coyomo, y cu'tpa y ucpa y no'tpa. ");
INSERT INTO zosNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pero je jama ji'n nø ni'aṉjajmu'øc o'ca ma mini, y nu'cpa je jama je chøsi'is cyomi, y nu'cpa je hora ji'n nø myusu'øc o'ca ma nu'qui. Y vøti maṉba cyastigatzøc cyomi'is y maṉba tumø cot ji'n vyøjpø chøsiji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","”Y o'ca chøsi'is myusu jujche nø syun cyomi'is y ja 'yalistatzøcø, y ja chøc cyomi'is syunuse, jic maṉba nacstøj vøtinac. ");
INSERT INTO zosNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero o'ca chøsi'is ja myusø ti nø syun cyomi'is, aunque chøcø ji'n syunise y por eso maṉbana'ṉ nacstøji; jet usyti manba nacstøji, porque ja myusø ti nø syunu. Porque chi'upø vøti, jet maṉba sujnatyøji va'cø chi'vitu' vøti. Y chamdzajcupø pøngøs vøti, jetcøsi maṉba vya'cvitu'yaj más vøti. ");
INSERT INTO zosNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","”Øtz mi'nøjtzi va'cø nøndzo'tz quipcuy nascøsi como si fuera juctyøc ndø ja'mbø'pase. Y vøjna'ṉ o'ca ja'pøtyøju'am; jetse nø sungomø'nu. ");
INSERT INTO zosNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Øtz tiene que va' nøcøj toya vøti, y vøti maya'pøjtzi ø ndzoco'yomo hasta que cøtpa. ");
INSERT INTO zosNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Será que mi ngui'pstamba que mi'nøjtzi va'cø yac vøṉneñøm nascøsi? Nø'mbøjtzi que ji'nda, sino øtz maṉba yac it quipcuy nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Desde yøti o'ca it mosay tumbø tøjcomo, maṉba quipyaje. Tu'capyø'is maṉba ñøquipyaj metzcuy, y metzcupyø'is maṉba ñøquipyaj tu'cay. ");
INSERT INTO zosNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jyata'is maṉba ñøquipyaj 'yune, y 'yune'is maṉba ñøquipyaj jyata. Myama'is maṉba ñøquipyaj yomopø 'yune, y yomopø 'yune'is maṉba nøquipyaj myama. Saque mama'is maṉba ñøquipyaj syaque, y syaque'is maṉba ñøquipyaj syaquemama. ");
INSERT INTO zosNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","También ñøjmayaj vøti pøn: ―Cuando mi istamba o'na nø pyujtupø jama tø'pcucyøsi, mi ñømdamba: “Maṉba min tuj”, y jetseti tucnømba. ");
INSERT INTO zosNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y cuando popya jamsava, mi ñømdamba: “Maṉba nutznømi”, y jetse tucnømba. ");
INSERT INTO zosNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mi aṉgøma'cø'otyambapø'is, muspa mi ṉgøque'nøtyam ti nø cyotzamu tzajpis y nasis o'ca maṉba ij tuj, o'ca maṉba it jama. Entonces ¿ti'ajcuy ji'n mi ṉgøque'nøtyam ti nø tyujcu yøṉ jama'omo? ");
INSERT INTO zosNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","”¿Ti'ajcuy ji'n mi ṉgøpiṉdam mi ne'ṉgø vøjpø tiyø? ");
INSERT INTO zosNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","O'ca it mi ngøva'cøpa'is, mientras je'is mi ñømaṉba aṉgui'mbacøsi, me'tz modo jujche va'cø mi ⁿvyøjøtzøc jetji'ṉ tu'ṉomdi; va'cø jana mi ñømaṉ aṉgui'mbacø'mø. Uytim mi nchi'ocuyaj policiacøsi aṉgui'mba'is; uytim mi syomu policia'is. ");
INSERT INTO zosNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Øjtzø mi nøjmambya que ji'n ma mi mbyuti jeni hasta que ji'n mi ṉgoyojpø' último centavo. ");
INSERT INTO zosNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mismo jic tiempo nu'cyaj jiṉø chajmayajupø'is Jesús lo que jujche chøjcuse Pilato'is. Porque Galilea cumgupyø'nista'm nømna'ṉ yaj ca'yaj pø'nøcuy vya'ṉjajmocuycøtoya, y Pilato'is syoldado'is yaj ca'yaj pøn, y pø'nis ñø'pin tyu'mayaj copøn nø'pinji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Entonces Jesusis ñøjayaju: ―Pueda ser que mitz ṉgomo'tyamba que jicø Galilea cumgu'yomda'mbø jetse toya'isyaju porque más ijtuna'ṉ cyoja que ji'n eyapø Galilea cumgu'yomda'mbø'is ñe'. ");
INSERT INTO zosNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pero mi nøja'mbøjtzi que ji'ndyet o'ca más ityaju ancø cyoja yaj ca'yajtøjupø'is ñe. Pero mijta'm o'ca ji'n mi ṉgui'psvitu'tame, mumu jetseti maṉba mi ndyocotyaṉgue'te. ");
INSERT INTO zosNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Y cuando quec torre ñøyi'ajupø'is Siloé y pyuṉga'yaj torre'is dieciocho pøn, pueda ser que mitz jetse ṉgomo'tyamba que másna'n je'is ityaj cyoja que ji'n mumu Jerusalén gumgu'yomda'mbø'is ityajuse cyoja. ");
INSERT INTO zosNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pero mi nøjambyøjtzi que ji'ndyet porque más ityaju ancø cyoja pyuṉga'yaj torre'is. Pero mijta'm o'ca ji'n mi ñgui'psvitu'tame, mumu jetseti maṉba mi ndyocotyaṉgue'te. ");
INSERT INTO zosNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús aṉma'yoy historiaji'n, nømu: ―Tum pø'nis ñø'ijtuna'ṉ higo cuy nijpupø uva nipi'omo. Maṉ mye'tzay tyøm jetcøsi, ja pya'tayø. ");
INSERT INTO zosNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Entonces vø'nipi'is ñøjmay cuendatzøcpapø'is nipi: “Tu'cay amecøs nø'ø min me'ndzaye yøṉ higo cu'is tyøm, y ja mbya'ta'yøjtzi. Tøṉbø'ø; ¿ti'ajcuy suniti itpa nascøsi?” ");
INSERT INTO zosNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero yospa pø'nis 'yaṉdzoṉu: “Øjtzø mi ṉgomi; tzacø yøṉø ame'omo. Matøc ø ndajcøcu'may nas y ma ṉgojtay tin, a ver o'ca tø'majpa eyapø ame. ");
INSERT INTO zosNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Y o'ca tø'majpa, vøjti; y o'ca ji'n tyø'maje, jicsye'cam mi ndøṉbø'pa”. ");
INSERT INTO zosNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tum sa'pøjcuy jama Jesús aṉma'yopyana'ṉ Israel pø'nis conocscuy tøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ijtuna'ṉ jeni tum yomo nømna'ṉ myaṉ dieciocho amemna'ṉ yaj ca'cupya'tumna'ṉ yach espiritu'is, y por eso jucs vitu'vitu'nepya vitpana'ṉ, y ni jujchena'ṉ ji'n mus viyuṉde'na. ");
INSERT INTO zosNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Isu'jcam yomo Jesusis, vyejayu, ñøjmayu: ―Tzamyomo, mi ⁿyac tzocpøjtzi mi ṉga'cucøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Entonces Jesusis cyot cyø' yomocøsi, y jicsye'cti yomo viyuṉde'nu, y vyøjcotzøcpana'ṉ Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero conocscuy tøc covi'najø qui'syca'u porque Jesusis cho'yøy sa'pøjcuy jamacøsi, y ñøjmayaj pønda'm covi'najø'is: ―Tujtay jama ijtu va' tø yosø. Yoscuy jamacøsi mindamø va' mi yac tzo'yøtyandøjø. U mi yac tzo'yøtyandøj sapøjcuy jamacøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jicsye'cti ndø Comi's 'yaṉdzoṉu ñøjmayu: ―Mitz mi aṉgøma'cø'otyambapøtite, porque aunque jutipø mijtzomda'm mi mbucspø'tamba mi vaṉgas mi mburro jø'mdøjupø va'cø ⁿyac to'ṉdam nø' tumdum jama, aunque sea sapøjcuy jama'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Entonces ¿ti'ajcuy mi ñømdamba que ji'n vyøjø va'cø øtz como si fuera mbucspø' yøṉ yomo sapøjcuy jama'omo? Como Abraham yøṉ yomo'is pyeca jata tzu'ṉguyete, y it dieciocho ame Satanasis yaj ca'e'aj yøṉ yomo como si fuera si'nusena'ṉ itpa. ");
INSERT INTO zosNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cuando Jesusis nømna'ṉ chamu'øc yøcseta'mbø tiyø, cyotza'ayajpana'ṉ mumu qui'sayajpapø'is. Pero mumu vøtipø'nis cyøcasøyaj myøjaṉombø tiyø nømna'ṉ chøjcupø Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Y Jesús nømu: ―Maṉba mi ndzajmatyam jujchepøte Dios aṉgui'mopya pø'nomo. Historiaji'ṉ maṉba mi aṉmañdyame. ");
INSERT INTO zosNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ijtu ta'nø ñøyi'ajupø'is mostaza. Pyøjcay pyuj tum pø'nis y ñip yoscuy nasomo. Y ye'ṉu como cusye, y møji vityajpapø paloma'is chøcyaj ño'sa 'yaṉmaṉgøsi. Como mostaza ta'nø pronto myøja'ajpase, jetseti Diosis 'yaṉgui'mguy vøti'ajpati maṉba pø'nomo. ");
INSERT INTO zosNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Y nømvøjøtzøc Jesús: ―Maṉba mi ndzajmatyaṉgue't jujchepøte Diosis 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tum yomo'is pyøc yac poṉoṉbapø'is pan ñøjayajupø levadura y myot tu'cañac myujcu harina'omo va'cø chøc pan. Jetse chajcu hasta que teṉeṉu. Jujche levadura'is yac teṉeṉba paṉ y ji'n queje, jetseti Diosis 'yaṉgui'mguy ji'n quej jujche vøti'ajpase. ");
INSERT INTO zosNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús cøtpana'ṉ mumupø cumgu'yomo, møjapø cumgu'yomda'm y che' cumgu'yomda'm; y aṉma'yopyana'ṉ mientras que nømana'ṉ tyu'ṉaj Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y ñøjmay tumbø'is: ―Ø Ṉgomi, ¿viyuṉete usyco'niti pøn cotzocyajpa? Y Jesusis 'yaṉdzoṉu: ");
INSERT INTO zosNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Pena tzi' mi ⁿvin va mi ñdyøjcøy Dios 'yaṉgui'mbamø jujche ndø penatzøcpase ndø vin va' tø tøjcøy cayipø aṉdyu'ṉomo. Porque øjtzø nømba que vøti maṉba tøjcøyajto'e, y ji'n ma mus tøjcøyaje. ");
INSERT INTO zosNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","”Después que vø'tøc te'ñchu'ṉba y 'yaṉgojpa aṉdyuṉ, mijta'm ma mi ñchø'tyam a'ṉgomo y ma mi nøjandyame: “Øjtzø mi Ṉgomi, tø aṉvajcatyandøvø yøn aṉdyuṉ”. Y je'tis ma mi 'yaṉdzoṉdame: “Ji'n mi ispøctam ⁿjyujta'mbøt mijtzi”. ");
INSERT INTO zosNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jicsye'jcam mijta'm maṉba ñømdzo'tztame: “Mi vi'naṉdøjqui cu'jta'møjtzi y ucta'møjtzi, y mi ndø anmañdyam ø ṉgalle'omda'm”. ");
INSERT INTO zosNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero je'tis ma ñøjmañdyame: “Ji'ndø mi ispøctam ⁿjyujta'mbøt mijtzi. Tzu'ṉdam mijta'm øtzcø'mø, mi ndzøctambapø'is yatzita'mbø tiyø”. ");
INSERT INTO zosNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jiṉø ma mi vyo'ndame y ma mi ṉgø'stam mi ndøtz maya'cu'is cuando mi istamba Abraham y Isaac y Jacob y mumu tza'maṉvajcopyapø Dios 'yaṉgui'mbamø, y mijta'm mi ñømbujtandøj a'ṉgomo. ");
INSERT INTO zosNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Y tu'møṉ du'møṉ y yø'qui jeni maṉba miñaje y maṉba po'csyaj mesacø'mø Dios 'yaṉgui'mbamø. ");
INSERT INTO zosNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Y tzøctam cuenda vene ji'n vyaletzøquipø pøn yøti, jic jama maṉba covi'najø'ajyaje. Y vene pøn lo que covi'najø pøn yøti, jic jama jin ma vyaletzøcyaje. ");
INSERT INTO zosNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jicø misma hora metz tu'cay pønda'm nu'cyaju y ñøjmayaj Jesús: ―Tzu'ṉ yø'qui y maṉ emøc, porque aṉgui'mbapø Herodesis nø syun mi ⁿyaj ca'ø. ");
INSERT INTO zosNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Y Jesusis ñøjmayaju: ―Mavø y ma nøjmay jic copønse mañapø Herodes que øtz macputpøjtzi yatzi'ajcutya'm, y ⁿyac tzocpøjtzi ca'eta'mbø yøti y jomi, y tu'cay jamapit ⁿyac tucpa ø ⁿyoscuy. ");
INSERT INTO zosNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero tiene que va' tyu'ṉaj yøti, y jomi, y vøstøcmøy, porque ji'n mus cya' tum tza'maṉvajcopyapø emøc o'ca ji'ndyet Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","”¡Jerusalén gumgu'yomda'mbø, Jerusalén gumgu'yomda'mbø, mi ⁿyaj ca'tambapø'is tza'maṉvajcoyajpapø, y mbu'ṉga'tambapø'is mi tza'ji'ṉ pøn lo que cyø'vejyajupø Diosis mitzcøtoya! Vøtinac øtz sunbana'ṉ mbøjcandø'p mitzta'm Jerusalén gumguy unetam mijtzi, jujche casyi mama'is cyøpø'cøpyase 'yune syajøcø'mo; pero ja mi syun mindam øtzcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Cøma'nøtyamø ti mi ndzajmapøjtzi; mi ndøc maṉba tzø'yaj tyumgø'y. Y mi nøjmandya'mbøjtzi: Ji'n ma mi ndø istame hasta que nu'cpa jama cuando maṉba mi ñømdame: “Ndø vøṉgotzøctamba nø minupø ndø Comi'is ñøyicøsi”. ");
INSERT INTO zosNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tujcu que tum sapøjcuy jama tøjcøy Jesús va'cø ma cyu't tum fariseo covi'najø'is tyøjcomo, y fariseo'sta'm nømna'ṉ cyøtu'nøyaj mø'chøqui Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jena'ṉ it Jesusis vi'na'ṉdøjqui tum pøn siṉgø ca'cuy ñø'ijtupø'is. ");
INSERT INTO zosNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Y Jesusis ñøjmayaj aṉma'yoyajpapø aṉgui'mgupit y fariseota'm: ―¿O it aṉgui'mguy, o ja itø sapøjcuy jama va'cø yac tzojcoya? ");
INSERT INTO zosNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero ni ti ja chamyajø. Jicsye'cti Jesusis ñuc nø syiṉupø cyø'cøsi, y yac tzojcu, y yac maṉu. ");
INSERT INTO zosNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jesusis ñøjmayaju: ―Aunque jutipø mijtzomda'm, o'ca quecpa mi mburro o mi vaṉgas tum nø' chatøjcomo, ¿será ji'n ma mi nømbut jø'nøti aunquena'ṉ sapøjcuy jama? ");
INSERT INTO zosNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Y ni jujchena'ṉ ja mus 'yaṉdzo'ṉoyaj Jesusis chamuse. ");
INSERT INTO zosNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Y chi' cuenta Jesusis vejyajtøjupø va'cø maṉ cyu'tyajø, jujche mumu cyøpiṉyajuse po'cscuy tome covi'najøcø'mø va'cø pyo'csyajø. Y Jesús aṉma'yoyu yøṉ historiaji'ṉ, nømu: ");
INSERT INTO zosNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Cuando mi ⁿvyejtøjpa co'tøjcajcu'yomo, u mi mbyo'cs tome covi'najøcø'mø, uytim nu'c eyapø más covi'najøpø vejtøjupø que ji'n mijtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Y mi ⁿvyejandyamupø'is maṉba mi ñøjmaye: “Tø tzajcay yøṉ po'cscuy”. Y jetse mi ñcha'aj tzu'ṉba va' mi mbyo'cs ya'i. ");
INSERT INTO zosNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mejor cuando mi ⁿvyejtandøjpa va' mi ⁿvi'ctamø, po'cstam más ya'i. Entonces cuando minba mi ⁿvyejumbø'is, maṉba mi ñøjaye: “Amigo, muspa mi mbo'cs más tome covi'najøcø'mø”. Entonces maṉba mi vyøṉgotzøcyaje mesacø'm po'csyajupø'is. ");
INSERT INTO zosNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porque aunque jutipø møja'ṉgotzøcpapø'is vyin, maṉba tzø'y como aunque jutzpø pobrese. Pero aunque jutzpø pobrese chøcpapø'is vyin, jet maṉba yac møja'ṉo'majtøji. ");
INSERT INTO zosNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Y Jesusis ñøjacye't vyejupø'is va' vyi'cyajø: ―Jujchøc mitz mi ndzøcpa sø'ṉajcuy o cu'taṉbajcuy, uy vyej mi amigota'm, ni mi ndøvøta'm, ni mi mbarienteta'm, ni ricupø tøjcaṉbo'csata'm. Porque o'ca mi ndzøcpa søṉ y mi aṉjo'cpa va' mi ñchøcvitu'jacye'tati, jetemete mi ṉgoyoja. ");
INSERT INTO zosNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero jujchøc mi ndzøcpa søṉgu'tcuy, vejyaj pobreta'mbø, y yacsuta'mbø, y mø'ṉgaṉyajpapø, y to'tita'mbø. ");
INSERT INTO zosNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jetse más mi ṉgyontento'ajpa, porque je'tis ji'n mus mi ñchøcvitu'jayajø, pero Diosis maṉba mi yac vitu'jay mi ṉgoyoja cuando yac visa'yajpa vøjpø pøn ca'yajupø. ");
INSERT INTO zosNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tum pø'nis po'csupø mesacø'mø Jesusji'ṉ myan chamuse Jesusis, y je pø'nis ñøjay Jesús: ―Contentopøte vi'cpapø Dios 'yaṉgui'mbamø. ");
INSERT INTO zosNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pero Jesusis ñøjmayu: ―Tum pø'nis chøc tum møja søṉgu'tcuy, vyejo'yaj vøti pøn. ");
INSERT INTO zosNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Cuando nu'c hora va'cø myavø'am vyi'cyajø, vyejupø'is cyø'vej chøsi va'cø ñøjayaj vejayajupø: “Mindamø'am, porque listom it mumu tiyø”. ");
INSERT INTO zosNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Y mumu cyø'vejyaj ote que ja ityøna'ṉ lugar va' myaṉyaj sø'ṉomo. Vi'napø nømu: “ⁿJu'yø nas, y tiene que va' ma a'misø. Nøjmambya mijtzi va' mi ndø nømaṉjay pasencia, porque ji'n mus minø, porque ja it ø lugar”. ");
INSERT INTO zosNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Eyapø'is ñøjmayu: “ⁿJu'yøjtzi mosay par vacas yoscucøtoya y ma'ṉbø ndzøjquisi. Nøjmambya mijtzi va' mi ndø nømaṉjay pasencia porque ji'n mus minø”. ");
INSERT INTO zosNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Eyapø'is ñøjmayu: “Merotøc ø co'tøjcaju y por eso ji'nø mus minø”. ");
INSERT INTO zosNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Cuando vitu' chøsi, maṉ chajmay vø'tøc jujche aṉdzoṉdøju. Jetsemete vø'tøc qui'syca'u y ñøjmay chøsi: “Maṉ yøti yøti plaza'omda'm y calle'omda'm cumgu'yomo, y nømin yø'qui pobreta'mbø y yacsuta'mbø, mø'ṉgaṉyajpapø, y to'tita'mbø”. ");
INSERT INTO zosNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jetse chøc chøsi'is, y entonces ñøjmayu: “Øjtzø mi ṉgomi, yøti ndzøjcu'møjtzi jujche mi ndø ndzajmayuse, y ijtutøc más lugar”. ");
INSERT INTO zosNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Y ñøjmay cyomi'is chøsi: “Maṉ mye'tz tu'ṉomda'm y ve'quecø'mda'm, y i mi mba'tyajpa, pyenatzøcyajø va' yac tøjcøyajø, va'cø tas ø ndøc. ");
INSERT INTO zosNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Porque nø'mbøjtzi que pøn lo que vi'na oyupø ø ⁿvejo'yaje, ni jutipø'is ji'n ma cyu'tis ø ṉgu'tcuy”. ");
INSERT INTO zosNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nømna'ṉ myaṉyaj vøti pønji'n Jesús, y Jesús quenvitu'u y ñøjmayaju: ");
INSERT INTO zosNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―O'ca aunque i'is syunba min øtzcø'mø, tiene que øtz más va'cø sunø que ji'n jyata, y myama, y yomo, y 'yuneta'm, y 'yatzita'm, y chøtzøta'm, y myuquita'm, y también ñe' vyin. O'ca jic más syunba, ji'n mus ø nøndu'ṉajø. ");
INSERT INTO zosNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","O'ca aunque i'is ji'n syun is toya jujchem øtz maṉbase is toya va' ṉgap cruz, y va' ca' cruzcøsi, entonces ji'n mus ø nøndu'ṉajø. ");
INSERT INTO zosNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Supongamos que tum pøn mijtzomda'm sunba chøc no'tzetøc torre'øyu. ¿Será que ji'n ma po'cs vi'nac va' cyøque'nøy gasto, a ver o'ca it tumin vøti va'cø yac tucø? ");
INSERT INTO zosNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Utyem ñøtzo'tzu, ji'n mus yac tucø, y mumu lo que nø isyajupø'is maṉba syijca'yaje. ");
INSERT INTO zosNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Y maṉba nømyaje: “Yøṉ pø'nis ñøtzo'tzu va' chøc tøc, y ni ja mus yac tucø”. ");
INSERT INTO zosNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Y o'ca tum aṉgui'mba'is maṉba ñøquip eyapø aṉgui'mba tøvø, vi'nac maṉba po'cse y maṉba piensatzøc a ver o'ca muspa cyønu'cayø, porque ñø'it majcay mil pøn, y eyapø aṉgui'mba'is ñø'it ips mil pøn. ");
INSERT INTO zosNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","O'ca ji'n mus cyønu'cayø, cuando eyapø aṉgui'mba ya'itøc ijtu, maṉba cyø'vej ote a ver jujche muspa 'yarreglatzøcø va' jyana quipyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jetsetique't aunque jutipø mijta'm o'ca ji'n mi ndzac mumu tiyø mi nø'ijtupø, ji'n mus mi ndø nøndu'ṉajø. ");
INSERT INTO zosNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","”Cana vøjpø tiyete. Pero o'ca cana seque'ajpa, ji'nam jutznømø ndø yac pa'ajcaje. ");
INSERT INTO zosNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ni nascøtoya ni tununumø abono ji'n vyøjø. Patzpøtøjpa. O'ca it mi ṉgoji va' mi manø, cøma'nøyø. ");
INSERT INTO zosNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","To'møyaj Jesús mumu cobratzøjcoyajpapø'is y cojapa'tyajupø'is va' cyøma'nøyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Y cyø'o'nøyajpana'ṉ Jesús fariseo'is y aṉma'yoyajpapø'is aṉgui'mgupit; nømna'ṉ na ñøjayajtøju: ―Yø'ṉis pyøjcøchoṉba cojapa'tyajupø y jetji'ṉ cu'tyajpa. ");
INSERT INTO zosNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Entonces Jesusis chajmay historia va'c 'yaṉma'yoya; yøcse nømu: ");
INSERT INTO zosNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Supongamos que tum pø'nis mijtzomda'm ñø'it mosis byorrego y tum tocopya. ¿Ti chøcpa? Pues chacpa noventa y nuevepø jeni tza'momo va'cø maṉ mye'tz tocoyupø hasta que pya'tpa. ");
INSERT INTO zosNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y pya'tu'jcam, cyapcøtøjcøpya ñøminba cajsøpya. ");
INSERT INTO zosNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y cuando nu'cpa tyøcmø, vyejtu'myajpa tyøvø y tøjcaṉbo'csa ñøjmayajpa: “Cajsøtyam øtzji'n, porque mba'tu'møjtzi ø mborrego oyupø tocojo'ye”. ");
INSERT INTO zosNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Øtz mi ⁿnøja'mbyøjtzi que jetse cyøcasøyajpa tzajpomda'mbø'is tum cojapa'tupø pøn o'ca qui'psvitu'pa. Tzajpomda'mbø'is más cyøcasøyajpa qui'psvitu'upø'is que menos noventa y nueve vøjta'mbø que ja it pyena va'cø qui'psvitu'yajø. ");
INSERT INTO zosNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","”Y supongamos que tum yomo'is ñø'it majcay tumin y tyocopya tumø. ¿Ti maṉba chøqui? Pues jya'pø'pya no'a y 'yocpetpa tyøc, y tumin mye'tzpa mø'chøqui hasta que pya'tpa. ");
INSERT INTO zosNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y cuando pya'tpa, vyejtu'myajpa yomdøvø y tyøjcaṉbo'csata'm y ñøjmayajpa: “Nøcasøtyam øjtzi porque mba'tum ø ndumin oyupø tocojo'ye”. ");
INSERT INTO zosNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mi nøjmambyøjtzi que jetsetique't Diosis 'yangeles casøyajpa cuando tum cojapa'tupø pø'nis qui'psvitu'pa. ");
INSERT INTO zosNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Y Jesús nømgue'tu: ―Tum pø'nis ñø'ijtuna'ṉ metzcuy 'yune. ");
INSERT INTO zosNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Y muquipø'is ñøjmay jyata: “Jatay, tzi' ndø ø ṉguenda junche'nomo maṉbacsye'ṉomo nøndzø'y øjtzi aunque tiyø”. Y jyata'is vye'nayaj 'yuneta'm ti ñø'ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Cøjtu'jcam usy jama, je myuqui'is tyu'mbø' mumu ti chi'tøjuse y tzu'ṉu. Maṉ søṉvit ma viti ya'i cumgu'yomo, y jiṉø myalgastatzøcpø' tyumin va' chøc gyusto. ");
INSERT INTO zosNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Cuando yajpø'u'jcam tyumin, oy it na'ñchaṉ yu' jicø nasomo, y ischo'tz toya. ");
INSERT INTO zosNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Y maṉ coyos tumø jic cumgupyønji'ṉ. Y ji'quis cyø'vej tza'momo va' pyø'nøy yoya. ");
INSERT INTO zosNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Je une osco'ṉbana'ṉ, sungo'nbana'ṉ cyu'tas yoya cu'tcuy, pero ni i'is ni ti ja chi'ø. ");
INSERT INTO zosNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Entonces qui'psocuy minu y nømu: “Ñø'it ø janda'is vøti yospapø pøn. Je'tis ñø'ityaj vøti cu'tcuy, y øjtzi yø'qui nø osca'comø'nu. ");
INSERT INTO zosNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ma'ṉbø tzu'ṉi, ma'ṉbø maṉ ø jandacø'mø, ma'ṉbø ⁿnøjaye: Jatay, øtz cojapa'tø Dioscøsi y mi vi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Como øtz ji'ṉ chøṉ vøjpø pøn, ji'n mus mi ndø nøjay: Ø mi ⁿune. Pero tø pøjcøchoṉ ndøvø como tum coyospa pønse”. ");
INSERT INTO zosNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jetse tzu'ṉu je une, maṉ jyatacø'mø. ”Pero cuando ya'itøcna'ṉ ijtu'øc, is jyata'is nø ñu'cupø 'yune; y tyoya'ṉøyu, y popya cyønu'cu, y jyotzcøtøjcøyu, y syu'cu. ");
INSERT INTO zosNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Y 'yune'is ñøjayu: “Jatay, cojapa'tøjtzi Dioscøsi y mi vi'naṉdøjqui. Como øtz ji'n chøṉ vøjpø pøn, ji'n mus mi ndø nøjay: Ø mi ⁿune”. ");
INSERT INTO zosNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero jyata'is ñøjayaj chøsi: “Nøpujtatyam yøti yøti más vøjpø tucu y yac mestamø. Cojtatyam cyø'aṉune'omo cøcumø. Yac mestam sapato cyoso'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Y nømindam tzaṉgapø vacas une y yaj ca'tamø va'cø ndø vi'ctamø, y ma ndø tzøctam søṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Porque yøṉ ø ⁿune como si fuera ca'use o tuqui, pero quenbapøte. Tocoyupøna'ṉete pero quejvøjøtzøjcu'am”. Y cyøcasøcho'chaju. ");
INSERT INTO zosNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","”Y atzipø 'yune yoscuñasomo ijtu, y cuando minu y nu'c tome tyøcmø, myan suñina'ṉ nø vyanømu y nø 'yetznømu. ");
INSERT INTO zosNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Y atzipø 'yune'is vyejay tumø chøsi y 'yocva'c tiyø nø chøctøju. ");
INSERT INTO zosNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Y chøsi'is ñøjmayu: “Mijtzø muṉgui minu, y mi janda'is yaj ca' tzaṉgapø vacas une, porque vitu' sa'sapø”. ");
INSERT INTO zosNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jicsye'cam 'yatzi qui'syca'u y ni ja syun tyøjcøy tyøjcomo. Por eso put jyata y ñømgo'najo'yu 'yune va'cø tyøjcøyø. ");
INSERT INTO zosNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero je'tis 'yaṉdzoṉu ñøjmay jyata: “Vøti amem mi nøyospamøtzi. Mumu jama ndzøjcøjtzi mitz mi ndø tzajmayuse; ja yoschø'y øtz nunca. Pero mitz nunca ja ndø tzi' ni tum chivo une va'cø ndzøc sø'ṉajcuy ø amigoji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero yøṉ mi ⁿune minu oyupø'is mi ⁿyajpø'jay mi ndumin møtzi yomocøsi, y mi ⁿyaj ca' jetcøtoya tzaṉgapø vacas une”. ");
INSERT INTO zosNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Y jyata'is jicye'jcam ñøjmay atzipø 'yune: “'Yune, mitz mumu jama øtzji'ṉ mi ⁿijtu, y mumu ti nø ijtøjtzi, mijtze ne'. ");
INSERT INTO zosNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Vøjø va'cø tø søṉdzøctamø y tø cajsøtyamø, porque yøṉ mi muṉgui como si fuera ca'use o tuqui, pero quenbati; tocoyupøna'ṉete, y queju'am”. ");
INSERT INTO zosNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Y Jesusis ñøjmay también ñøtuṉdøvø: ―Ijtuna'ṉ tum pøn ricupø y ñø'ijtuna'ṉ encargado vacø cuendatzøc ti ñø'ijtupø. Y encargado maṉ cøtza'møtyøji cyomicøsi que nø yajay mumu lo que ti ñø'ijtupø cyomi'is. ");
INSERT INTO zosNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jicsye'cam encargado vyej vø'ne'is y ñøjmayu: “¿Tiyete yøṉø que ṉgøma'nøpyøjtzi ti mi ndzøjcu? Tzajmay ndøvø jujche mi nøndu'ṉaj ø ⁿyoscuy. Porque yøti ji'nam ma mi ndzi' yoscuy”. ");
INSERT INTO zosNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Y jicsye'cam encargado nøm choco'yomo: “¿Tiyø ndzøcpøjtzi, porque ø ṉgomi'is yac tzacpa ø ⁿyoscuy? Ja it ø mbømi va' ndaj nas, y va'cø ⁿvac limosna, ṉgotza'apyøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Øtz muspa ti ma ndzøqui va'cø pøjcøchoṉyajøjtzi tyøjcomda'm, va'cø yac ityaj tyøjcomo, cuando yac tzactøju'am ø ⁿyoscuy”. ");
INSERT INTO zosNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Entonces encargado'is vyejay tumdum cyøja'tzpapø'is cyomi. Y encargado'is ñøjmay tum cyøja'tzpapø'is: “¿Jujche mi ja'ndzapya ø ṉgomi?” ");
INSERT INTO zosNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Y cyøja'tzpapø'is ñøjmayu: “Ja'ndzapyøjtzi mosis lata aceite”. Entonces encargado'is mye'tz vyale y ñøjmay cyøja'tzpapø'is: “Pøc mi mbale, y po'cs jø'nø jø'nø y jajyay cincuenta lata”. ");
INSERT INTO zosNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jicsye'cam encargado'is ñøjmay eyapø cyøja'tzpapø'is: “Y mijtzi, ¿jujche mi ja'ndzapya?” y cyøja'tzpapø'is ñøjmayu: “Mosis costal trigo”. Y encargado'is mye'tz vale y chi' cyøja'tzpapø'is y ñøjmayu: “Pøc mi mbale y ja'yøy ochenta”. ");
INSERT INTO zosNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Y cuando cyomi'is myusu'øc jujche chøc yatzipø encargado'is; mismo cyomi'is chi' cuenta que encargado'is chøc qui'psocuji'ṉ. Porque qui'psyajpapø'is puro nascøspø itcuy más chøcyajpa qui'psocuji'ṉ entre ñe'comda'm que sø'ṉgø'om ityajupø'is ji'n chøcyaj qui'psocuji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","”Y øtz mi ñøjandya'mbø mijtzi: Amigo tzøctam nascøspø mi riṉguesa'ajcuji'ṉ, aunque riquesa'ajcuy ji'ndyet vyøjpø tiyø. Entonces cuando yajpa mi ringuesa'ajcuy, maṉba mi mbyøcøchoṉdandøji ji'n yajepø itcuyomda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","”Chøcpa'is vøjø usypøji'n, chøjque'tpati vøjø vøtipøji'ṉ; y ji'n chøqui'is vøjø usypøji'ṉ, ni vøtipøji'ṉ ji'ndi chøjque't vøjø. ");
INSERT INTO zosNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","O'ca nascøspø tuminji'ṉ ja mi 'yondyam vøjø, ni i'is ji'n ma mi nchi'tam viyuṉbø ricu'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","O'ca eya ne'omo ja mi ⁿ'yoñdyam vøjø, ni i'is ji'n ma mi ñchi'tam mi ne'nda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","”Ni jutipø coyospapø'is misma hora ji'n mus yosay metzcuy cyomi. Porque o eyapø syunba y eyapø ji'n syuni; o eyapø yosapya vøjø y eyapø ji'n yosay vøjø. Ji'n mus mi ⁿyosay Dios oca sunba mi ⁿyos puro tumingøtoya. ");
INSERT INTO zosNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Y cyøma'nøyajpana'ṉ mumu yøcseta'mbø ote fariseo'is, y como syuñajpana'ṉ tyumin, syijcayajpana'ṉ Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Y Jesusis ñøjmayaju: ―Mitzta'm vøjpø pønse mi ndzøctamba mi ⁿvin pø'nis vyi'naṉdøjqui, Pero Diosis mi ṉgyomusatyamba mi ndzocoy. Porque pø'nis vyøcotzøcyajpapø, Diosis yatzicotzøcpa. ");
INSERT INTO zosNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","”Ijtuna'ṉ Moisesis 'yaṉgui'mguy lo que chajcupø jachø'yupø, y ijtuna'ṉ tza'maṉvajcoyajpapø'is chamyajuse hasta que min yos Juan nø'yø'opyapø. Pero desde que min Juan, tzamdzo'tztøju vøjpø ote jujche aṉgui'mbase Dios, y mumu pø'nis pyenatzøcyajpa vyin va'cø tyøjcøyaj Diosis 'yaṉgui'mgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","”Y más fácil va'cø yaj tzap, y nas que va'cø jana viyu'ṉaj tum punto o tum raya aṉgui'mgu'is ñe'. ");
INSERT INTO zosNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","”O'ca aunque i'is chacpa yomo y co'tøjcajpa eyapøji'ṉ, jetse cyøtzøjcø'opya; y o'ca tum pø'nis pyøcpa yomo chajcupø jyaya'is, jetse cyøtzøjcø'ocye'tpa. ");
INSERT INTO zosNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","”Ijtuna'ṉ tum pøn ricupø. Myespana'ṉ vøjpø tucu caro coyajate, y mumu jama chøcpana'ṉ søṉ, cyu'tcøpiṉbana'ṉ cu'tcuy syunbase. ");
INSERT INTO zosNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Itque'tutina'ṉ pobrepø pøn ñøyipø'is Lázaro. Ricu'is 'yanduṉgø'mø tzactøjupøte y putzitasupøte. ");
INSERT INTO zosNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sunbana'ṉ pivø cømu'taṉ quecpapø ricu'is myesyacøtøjcø'mø a ver si o'ca taspana'ṉ cømu'ta'ṉis. Y miñajque'tpana'ṉ tuyi y cyøcajtayajpana'ṉ pyutzi. ");
INSERT INTO zosNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Y tujcu que pobrepø pøn ca'u y aṉgelesis ñømaṉyaj jut ijtumø Abraham vøjpø itcu'yomo. Y ca'que'tuti ricu, y oy niptøji. ");
INSERT INTO zosNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nømna'ṉ toya'is ricu infierno'omo, y quende'nu y ya'iti is Abraham y jena'ṉ isque't Lázaro tu'mbac Abrahamji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Y vyejay ricu'is y ñøjmayu: “Ø mi janda Abraham, tø toya'ṉøy ndøvø. Cø'vej Lázaro va' yac muj cyø'aṉ'une nø'ji'ṉ y cyot usy nø' ø ndotzcøsi va'cø syujcøy ø ndotz. Porque nø'mø toya'is vøti yøṉø juctyøjcomo”. ");
INSERT INTO zosNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Y 'yaṉdzoṉ Abraha'mis: “'Yune, jajmutzøc cuando mi ṉguenba'c mi nø'ijtuna'ṉ vøti riquesa'ajcuy, y Lazaro'is oy is toya. Y yøti Lázaro vøjti it yø'qui nø cyasøyu, y mitz nø mi ñdyoya'is jeni. ");
INSERT INTO zosNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Además de mumu yøṉø itque'tuti jøṉupø noṉsepø cucmø; øtz yø'c ijtu y mitz tu'møṉ ijtu. Y yø'cpø sunbapø cyøtø mitz ijtumø, ji'n mus cyøtø. Ni jenbø ji'n mus min yø'qui”. ");
INSERT INTO zosNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ricu'is nøjmayu: “Jatay, mi nømgo'napyøjtzi que va' mi ṉgø'vej Lázaro ø janda'is tyøcmø. ");
INSERT INTO zosNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Porque it mosay ø ndøvø. Cø'vej Lázaro va' chajmayaj ø ndøvøta'm va' jyana miñaj jejta'm yø'qui yøṉø toya'iscu'yomo”. ");
INSERT INTO zosNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero Abraha'mis ñøjmayu: “Ji'quis ñø'ityaj Moisesis totocøs jyachø'yupø y ñø'ityaj tza'maṉvajcopyapø'is jyachø'yajupø totocøsi. Sunba va' yaj cøma'nøyaj jejta'm”. ");
INSERT INTO zosNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Y jicsye'cti ricu'is 'yaṉdzoṉu ñøjayu: “Pero ø mi janda Abraham, aunque ji'n cyøma'nøyaj jejta'm, pero o'ca tum opø ca'e vitu'que'tpana'ṉ jiṉø ø ndøvø'omo, qui'psvitu'yajpana'ṉ”. ");
INSERT INTO zosNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero Abraha'mis ñøjmayu: “O'ca ji'n cyøma'nøyaj Moisesis jyayuse, y tza'maṉvajcoyajpapø'is jyayajuse, entonces ji'ndina'ṉ ma vya'ṉjamyajque'te o'ca visa'pyana'ṉ opø ca'e”. ");
INSERT INTO zosNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesusis ñøjmay ñøtuṉdøvø: ―Seguro que maṉba it i'is yac tocoyajpa pyøndøvø; pero vøti maṉba toya'is ñøtocopyapø'is pyøndøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mejor que va' vajtøjatyøj vacucha' cyønøcø'mø y va' pyatztøjcøtyøj nø'cømø va'cø syucsca' jeni antes que va'cø jyana ñøtocoy tum yøn che'ta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tzøjcatyam cuenda mi ⁿvin; o'ca mi ndøvø cojapa'tpa mitzcøsi, nøjayø: “Ji'n vøj nø mi ndzøjcu”. Y o'ca qui'psvitu'pa, yac tzø'y jetse. ");
INSERT INTO zosNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Y o'ca cu'yañac tumbø jama'omo cojapa'tpa mitzcøsi y cu'yañac minba mitzcø'mø y mi ñøjmambya: “Ṉgui'psvitu'u'mtzi”; entonces jetse yac tzø'yø, u'yam mi ṉgui'saye. ");
INSERT INTO zosNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostolesis ñøjmayaj ndø Comi: ―Tø tzi'tam ndøvø qui'psocuy más ta'nemø va'cø va'ṉjajmotyamø. ");
INSERT INTO zosNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Y ndø Comi'is ñøjmayaju: ―O'ca mi vya'ṉjajmondyambana'ṉ viyuṉsye, aunquena'ṉ como mostaza tømbuse che'pøte, jetsetina'ṉ mi va'ṉjajmoṉguy aunque sea usyi, entonces muspana'ṉ mi ñøjmay yøn sicómoro cuy: “Visput mi ⁿvin, y ma nip mi ⁿvin majromo”. Y jic cuy mi ṉgyøma'nøpyana'ṉ y maṉuna'ṉ te'n majromo. ");
INSERT INTO zosNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","”Supongamos que tum pø'nis mijtzomda'm ñø'ijtu coyospapø, y yospa tza'momo, o cyoqueñajpa borrego. Cuando vitu'pa tza'momo, ¿será que cyomi'is maṉba nømi: “Min jø'nø y po'csa mesyacø'mø”? Ji'n ma ñøm jetse. ");
INSERT INTO zosNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Cyomi'is maṉba ñøjmay vi'na: “Tø tzøjcay ø ṉgu'tcuy vi'na, y preparatzøc mi ⁿvin va'cø mi ndø yosayø mientras øtz nø cu'tu'csye'ṉomo, nø ujcu'csye'ṉomo. Cu'taṉjejuca'mtzi, muspa mi ṉgyu't mijtzi muspa mi ⁿ'yuc mijtzi”. ");
INSERT INTO zosNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Será que ñøjmapya cyoyospa: “Yøscøtoya mi ndzøjcu øtz mi ndzajmayuse”? Pues ji'n ñøjmay jetse. ");
INSERT INTO zosNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jetse también mijta'm; cuando mi ndzøctamu'jcam mumu lo que mi ñchajmatyandøjuse, nømdamø: “Ø ṉgomi'is ja gyanatzøc ni ti más por lo que øtz ndzøctamuse, porque sólo ndzøcta'møjtzi lo que aṉgui'mdandøjuse”. ");
INSERT INTO zosNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Y tujcu que Jesús nømna'ṉ myaṉ Jerusalén gumgu'yomo, y nømna'ṉ cyøt Samaria nasomo y Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nømna'ṉ tyøjcøy Jesús tum che' cumgu'yomo. Y majcapya pø'nis choṉyaju y te'ndzø'yaj ya'i; ñø'ityajupø'is yach putzi ca'cuy ñøyipø'is lepra. ");
INSERT INTO zosNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Vyejayaju y ñøjmayaj Jesús: ―¡Jesús Maestro, tø to'ya'ṉøtyam ndøvø øtzta'm! ");
INSERT INTO zosNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Y Jesusis isyaju y ñøjmayaj ca'eta'mbø: ―Maṉdamø: ma isindzi'tam mi ⁿvin Israel pane. Y mientras nømna'ṉ myaṉyaj tu'ṉomo, tzø'yaj tzocyajupø majcaṉbøn. ");
INSERT INTO zosNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Cuando is tumbø'is vyin o'ca tzojcu'am, jicsye'cti vitu' Jesuscø'mø tzojcupø, y pømi veju y vyøcotzøc Dios porque yac tzojcu. ");
INSERT INTO zosNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Y japcøne'c hasta nascøsi Jesusis cyosocø'mø, y ñøjmayu: ―Yøscøtoya mi ndø yac tzojcu. Y Samaria cumgu'yombøte. ");
INSERT INTO zosNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Entonces Jesusis ñøjmay pøn tzojcupø: ―Como majcaṉbøn mi ñchø'tyam tzojcupø, ¿y macstujtaṉbønbø juti tzø'yaju? ");
INSERT INTO zosNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ti'ajcuy ni jutipø ja vitu' va'cø vyøcotzøc Dios, na's yøṉ eyaco cumgupyøn vitu'u tyumgø'y? ");
INSERT INTO zosNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Y Jesusis ñøjmay pøn tzojcupø: ―Te'ñchu'ṉø y maṉ mijtzi, porque mi vya'ṉjamombya mi ṉgyotzojcu. ");
INSERT INTO zosNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseo'sta'm 'yocva'cyaj Jesús jujchøc ma mini va' 'yaṉgui'm Dios. Jesusis 'yaṉdzoṉyaju: ―Dios va' min aṉgui'moye, ji'n jutz nøm ndø isi. ");
INSERT INTO zosNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ji'n mus tø nømø: “Yøṉa'm”; ni ji'n mus tø nømø: “Jica'm”. Porque Dios aṉgui'mopya mijtzomda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Entonces Jesusis ñøjmay ñøtuṉdøvø: ―Maṉba nu'c jama cuando maṉba aṉsundam va' mi ndø isatyam ø ⁿitcuy, pero ji'n mus maṉ mi ndø istamø øtz mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Maṉba mi ñøjmandyandøji: “Jic ndø jo'ctambapø, yø'c ijtu”. O maṉba mi ñøjmandyandøji: “Jicømete”. Pero u mi myaṉdamu va'cø maṉ mi mba'jtam jicse nømbapø. ");
INSERT INTO zosNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porque como rayu'is ñe'moctaspase tzap, jetsetique't sø'ṉoctaspa maṉba mini øjtzi mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero vi'na tiene que va'cø toya'is øjtzi y tiene que va'cø jana pøjcøchoṉyaj yøti ityajupø pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jujche oyuse tuqui Noesna'ṉ ijtu'øc, jetset maṉba tujque'te cuando minba'c øjtzi mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noesna'ṉ ijtu'øc, cutyajpana'ṉ, ucyajpana'ṉ co'tøjcajyajpana'ṉ, chi'ocu'yajpana'ṉ 'yune va'cø cyo'tøjcajyajø, hasta que tøjcøy Noes barco'omo y oy møja'ṉ jø'tø; y jen sucsca'pø'yaju. ");
INSERT INTO zosNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Y cuando Lot ijtu'cna'ṉ, jetseti o tucnøṉgue'te. Cu'tyajpana'ṉ, ucyajpana'ṉ, ju'yoyajpana'ṉ, ma'ayajpana'ṉ, nipyajpana'ṉ, tøctzøcyajpana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero mismo jete jama pujtu'jcam Lot Sodoma cumgu'yomo, quec møji juctyøc y azufre y poṉbø'tocoyaj mumu Sodoma cumgu'yomda'mbø. ");
INSERT INTO zosNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jetseti maṉba tujque't jic jama cuando øtz maṉba queje, øjtzi mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","”Jic jama cuando quejpa'c øjtzi, tøjcøsi ijtupø y cyote tøjcomo ijtu, mejor va' pyotyucø, va' jyana tøjcøy tyøjcomo va'cø ñømaṉ cyote. Jetsetique't tza'momo ijtupø va' jyana jyøsvitu' tyøcmø. ");
INSERT INTO zosNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Jajmutzøctam Lojtis yomo jujche tujcuse. ");
INSERT INTO zosNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aunque iyø syunbapø'is quen'i'nø vyingøtoya, tocopya; pero o'ca ca'pa øtzcøtoya, maṉba quen i'ni. ");
INSERT INTO zosNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","”Mi nøjandya'mbøjtzi que jicø tzu'i maṉba ityaj metzcuy tumbø tze'somo. Tum maṉba nømandøji y tum maṉba tzactøj jeni. ");
INSERT INTO zosNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Metzcuy yomo maṉba ityaj nø vyayajupø tumø'omo. Tum maṉba nømaṉdøji y tum maṉba tzactøj jeni. ");
INSERT INTO zosNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Metzcuy maṉba ityaj tza'momo. Tumø maṉba nømaṉdøji y tum maṉba tzactøj jeni. ");
INSERT INTO zosNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Y ñøjmayaj ñøtuṉdøvø'is: ―¿Juti, øjtzø mi Ṉgomi? Y ndø Comi'is ñøjmayaju: ―Jut ijtumø ca'upø, jeni tu'myajpa ju'qui. ");
INSERT INTO zosNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesusis chajmay historia va'cø 'yaṉmayø que pyenati va'cø ndø o'nøy Dios tumdum jama, y va'cø jana tø tzocomochi'ajtamø. ");
INSERT INTO zosNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nømu: ―Tum cumgu'yomo ijtuna'ṉ tum juez. Ni ji'na'ṉ cyøna'tzøy Dios, ni ji'na'ṉ cyøna'tzøy pyøndøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Itque'tutina'ṉ mismo cumgu'yomo tum yaṉbac yomo. Y yaṉbac yomo'is vøti nac cyøminbana'ṉ juez va'cø ñøjmayø: “Tø tzøjcay justicia. It qui'isapyapø'stzi”. ");
INSERT INTO zosNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero ijtuna'ṉ jyama juesis ji'na'ṉ syun chøjcay syunbase yomo'is, pero jicsye'c ñe'cti nømu: “Aunque øtz ji'nø ṉgøna'tzøy Dios y ji'nø ṉgøna'tzøy ø mbøndøvø, ");
INSERT INTO zosNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nada más ma ndzøjcay justicia va' jyana mijnayø jan dum nac, y va'cø jana más molestatzøcø”. ");
INSERT INTO zosNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Entonces nøm ndø Comi: ―Mandamø jujche nømu yatzipø juez. ");
INSERT INTO zosNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Oca yatzipø juesis chøjcay justicia yaṉbac yomo porque vøti nac cyønu'cu; entonces más seguro Diosis maṉba chøjcayaj justicia ñe'c cyøpiṉyajupø o'ca vyejayajpapø'is ñe'cø chu'ji'ṉ jamaji'ṉ. Aunque ya'pa va'cø cyotzoṉyajø, pero maṉba cyotzoṉyaje. ");
INSERT INTO zosNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Øtz nø'mbøjtzi que Diosis maṉba chøjcayaj justicia jø'nø jø'nø. Pero cuando minque'tpøjtzi mumu Pø'nis chøṉ Tyøvø, ¿será que ma'ṉbø mba't va'ṉjamyajpapø'stzi nascøsi? ");
INSERT INTO zosNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesusis chajmay historia va'cø 'yaṉma'yoya, porque ityajuna'ṉ pøn cyomo'yajpapø'is ñe'cø que ñe'c más vøjpø pønda'm, pero eyata'mbø myenos chøcyajpana'ṉ. Jesús nømu: ");
INSERT INTO zosNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Metzpøn qui'myaj masandøjcomo va' 'yo'nøyaj Dios, tumø fariseo y tum cobtratzøjcopyapø. ");
INSERT INTO zosNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Jen te'nupø 'yo'nøy Dios fariseo'is, yøcse nømu: “Dios, yøscøtoya mi vyø'ajcupit øtz ji'n chøṉ eyata'mbø pønsepø. Porque øtz ji'nø ṉgøpøc ø ndøvø ni tipit, ni øtz ji'nø aṉgøma'cøy ni iyø, ni ji'n chøṉ cøtzøjcø'yopyapø; ni øtz ji'nø yatzi como yøṉ cobratzøjcopyapøse. ");
INSERT INTO zosNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Øtz ji'n uqui ji'n cu'ti metza jama tumdum semana'omo ø va'ṉjajmoṉgucyøtoya. Aunque ti mbøcpøjtzi, mi ndzi'pa vene”. Jetse ñøjay Dios fariseo'is. ");
INSERT INTO zosNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero cobratzøjcopyapø ya'ina'ṉ te'nu, y ni ji'na'ṉ quende'n tzapcøsi, sino que cyucpac tzaṉbana'ṉ, y ñøjayu: “Dios, tø toya'ṉøyøjtzi; øtz cojapatupø chøṉø”. Jetse nømu; y ");
INSERT INTO zosNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","nø'mbøjtzi que yøṉ cobratzøjcopyapø maṉ tyøcmø cøvajcøyupø'am cyojapit. Pero fariseo ja cyøvajcøyø. Porque aunque jutipø møja'ṉdzøcpapø'is vyin, jet maṉba tzø'y como aunque juchpø pobrese. Pero aunque juchpø pobrese chøcpapø'is vyin, jet maṉba yac møja'ṉo'majtøji. ");
INSERT INTO zosNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Y ñømiñajpana'ṉ che'ta'mbø une va'cøna'ṉ cyot cyø' jetcøs Jesusis. Pero cuando isyaj ñøtuṉdøvø'is, 'yojnayaj ñømiñaju'is 'yune. ");
INSERT INTO zosNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesusis vyejayaj une va'cø ñu'cyaj jetecø'mø y nøjayaj ñøtuṉdøvø: ―Tzactam uneta'm yac miñaj øtzcø'mø, u mi o'ninductamu. Porque jetsepø'omo Dios aṉgui'mba. ");
INSERT INTO zosNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Viyuṉsye mi nøjmandya'mbøjtzi que o'ca aunque i'is ji'n pyøjcøchojṉay Diosis 'yaṉgui'mguy como che'pø une'is pyøjcøchojṉapyase, entonces ji'n mus tøjcøy je'tomo. ");
INSERT INTO zosNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Y 'yocva'c tum aṉgui'mbapø'is, ñøjmay Jesús: ―ⁿVyøjpøt mijtzi Myaestro, ¿jujche vøj ø ndzøcø va'cø mba't ji'n yajepø quenguy? ");
INSERT INTO zosNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Y Jesusis ñøjmayu: ―¿Ti'ajcuy mi ndø nøjapya: “ⁿVyøjpøt mijtzi”? Porque ni i ja it vøjpø sino sólo Diose vøjpø. ");
INSERT INTO zosNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pero mitz mi muspa jujche it jachø'yupø aṉgui'mguy: “Uy cyøtzøjcø'yoye; uy yaj ca'oye; uy ñu'mi; uy maṉ mi ṉgøsujtzø'yoyu; cøna'tzøy mi janda y mi mama”. ");
INSERT INTO zosNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Y pø'nis ñøjmayu: ―Mumu yøcseta'mbø aṉgui'mguy yaj copujtøjtzi desde que une'cna'ṉtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Cuando myan Jesusis yøṉø, ñøjmayu: ―Faltatøc tumna va'cø mi ndzøcø. Ma'aj mumu ti mi nø'ijtu, y tzi'yaj pobreta'm tumin mi mbøcpapø, jetse maṉba mi nø'it riquesa'ajcuy tzajpomo. ");
INSERT INTO zosNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Y minø; min tø pa'tø. Pero cuando pø'nis myanu'c yøcsepø tiyø, maya'comø'nu; porque ricoco'nina'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Cuando is Jesusis que nø myaya'comø'nu, nømu: ―¡Penapit tøjcøyajpa Dios 'yaṉgui'mbamø ricuta'mbø! ");
INSERT INTO zosNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Más fácil va'cø cyøt tum camello acusya'is cyoji'omo que tum ricu ji'n maṉ tøjcøy Dios 'yaṉgui'mbamø. ");
INSERT INTO zosNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Y cyøma'nøyajpapø'is Jesús nømyaju: ―¿Entonces i muspa cyotzoca? ");
INSERT INTO zosNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesusis ñøjmayaju: ―Ji'n musipø chøc pø'nis, Diosis muspa chøcø. ");
INSERT INTO zosNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Entonces Pedro'is ñøjmay Jesús: ―A'mø, mumu ti nø'ijtamuna'ṉtzi ndzacta'møjtzi y nø maṉ mi mbajtame. ");
INSERT INTO zosNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Y Jesusis ñøjmayu: ―Viyuṉsye øtz mi nøjandya'mba mijtzi; aunque i'is chacpapø'is tyøc, o yomo, o jyata, o tyøvø, o 'yune porque sunba it Diosis 'yaṉgui'mbamø; ");
INSERT INTO zosNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","pues je'is maṉba pyøjcøchoṉ más vøti que ji'nam chajcuse yøṉ jama nascøsi; y jete maṉbapø iti itcu'yomo, maṉba pyøjcøchoṉ ji'n yajepø quenguy. ");
INSERT INTO zosNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Y Jesusis ñømaṉyaj ne'ti doce 'yapostoles y ñøjmayaju: ―Cøma'nøtyamø. Yøti ma tø qui'mdam Jerusalén gumgu'yomo, y maṉba ta'nbø' mumu tiyø tza'maṉvajcopyapø'is jyachø'yajupø lo que jujche maṉbase tuqui øtzcøsi; øtz mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Porque øtz maṉba tzi'ocuyajtøj eyata'mbø pøngøsi lo que ji'ndyet Israel pøn; y ma'ṉbø sijcatyøji, y ma'ṉbø topa'o'nøtyøji y ma'ṉbø cøtzujøtyøji, ");
INSERT INTO zosNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","y vøti nac ma'ṉbø nacstøji, y ma'ṉbø yaj ca'tøji; y tu'cay jamacøsi ma'ṉbø visa'que'te. ");
INSERT INTO zosNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ñøtuṉdøvø'is ja myusyaj tiyø jetse syun cham Jesusis, porque ja ñø'ityajøna'ṉ qui'psocuy va'cø cyønøctøyøyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Cuando Jesús tomena'ṉ nø ñu'cu Jericó cumguy, jen tu'ṉaṉvini pø'cs tum to'tipø, y vya'cpana'ṉ tumin. ");
INSERT INTO zosNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cuando myan totipø'is que nø cyøt vøti pøn, entonces 'yocva'cu i nø cyøjtu. ");
INSERT INTO zosNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Y ñøjmayaju que nømna'ṉ cyøt Jesús Nazaret cumgu'yombø. ");
INSERT INTO zosNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Entonces vyejay Jesús to'tipø'is, ñøjmayu: ―¡Jesús, Davijdis mi 'yune, tø to'ya'ṉøy ndøvø! ");
INSERT INTO zosNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Y ñøvi'najyajupø'is 'yojnayaj to'tipø, ñøjmayaju: ―¡Vøṉneyø! Pero jet más vej pømi, ñøjmayu: ―¡Davijdis mi 'yune, tø to'ya'ṉøy ndøvø! ");
INSERT INTO zosNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Entonces Jesús te'ndzø'yu y ñøveju va'cø ñø nu'catyøjø. Cuando nu'c Jesuscø'mø, Jesusis 'yocva'cu: ");
INSERT INTO zosNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Ti mi sunba va'c ndzøc mitzcøtoya? Y je'tis ñøjmayu: ―Øjtzø mi Ṉgomi, su'nbøjtzi va'cø mi ndø yac sø'ṉay ø vindøm. ");
INSERT INTO zosNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Y Jesusis ñøjmayu: ―¡Yøti nø mi yac sø'ṉay mi vindøm! Porque mi ndø va'ṉjajmu, jicpit mi ñchojcu. ");
INSERT INTO zosNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jicsye'cti sø'ṉ vyitøm y maṉ pya't Jesús, y vyøcotzøcpana'ṉ Dios. Y mumu isyajupø'is lo que jujche tzoc to'tipø vyøcotzøcyajque'tpana'ṉ Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Entonces Jesús tøjcøy Jericó cumgu'yomo y nømna'ṉ cyøjtu. ");
INSERT INTO zosNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ijtuna'ṉ jinø tum pøn ñøyipø'is Zaqueo. Jet más covi'najøpø cobratzøjcopyapø, y ricupø pønete. ");
INSERT INTO zosNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Je'is sunbana'ṉ 'ya'm Jesús iyete; pero como tañipø pønete y itcomø'nømuna'ṉ vøti, jetse ji'nam mus 'ya'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Entonces popya maṉ vi'najpa y qui'm møji sicómoro cucyøsi a ver o'ca ispana'ṉ Jesús, porque jen maṉba cøti. ");
INSERT INTO zosNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Cuando Jesús nu'cu jicø ijtumø, entonces quenqui'm møji y ñøjmayu: ―Zaqueo, yøti mø'nø, porque yøti tiene que øtz va' tzø'y jeni mi ndøcmø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Entonces Zaqueo mø'n yøti yøti, y pyøjcøchoṉ Jesús y casøyu. ");
INSERT INTO zosNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pero cuando isyaj mumu pø'nis que jetse nø chøjcu, entonces cyø'o'nøyaj Jesús; nømyaju: ―¿Ti'ajcuy tøjcøy jic pø'nis tyøjcomo va'cø jen syapøcø, como jic cojapa'tupø pønete? ");
INSERT INTO zosNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pero Zaqueo te'nu y ñøjmay ndø Comi: ―Øjtzø mi Ṉgomi, a'mø; øtz ma'nba ndzi'yaj pobreta'mbø cucve'ne nø'ijtupø øjtz. Y eyata'mbø o'ca ṉgøsujtzøyajøjtzi va'cø ṉgøpøcyajø, viñojayajpøjtzi macscuñac. ");
INSERT INTO zosNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Entonces Jesús nømu: ―Yøti yøṉ tøjcomda'mbø cotzocyaju, porque también yøn pøn Abraha'mis chajcupø 'yune. ");
INSERT INTO zosNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Porque øjtzi mumu Pø'nis chøṉ Tyøvø mi'nøjtzi va'cø min me'chajø tocoyajupø pøn va'cø ø ⁿyaj cotzocyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jetsepø vejvejnecuy cyøma'nøyajpana'ṉ pø'nista'm, y entonces Jesusis chajmayajque't eyapø historia va'cø 'yaṉmayajø. Chajmayaj yøṉ historia porque ya meromna'ṉ ma nu'c Jesús Jerusalén gumgu'yomo, y pø'nis cyomo'yajpana'ṉ que prontona'ṉ ma it Diosis 'yaṉgui'mguy. (Cyomo'yajpana'ṉ que Diosis maṉba cyot Jesús va'cø 'yaṉgui'm Jerusalén gumgu'yomo.) ");
INSERT INTO zosNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yøcse chamu: ―Tum myøja'ṉombø pøn maṉ ya'ipø cumgu'yomo va' maṉ pyøjcøchoṉ aṉgui'mguy, y maṉba vitu'i va'cø min 'yaṉgui'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero antes que maṉba mave, ricu'is vyejay majcay chøsi, y chi'yaj tumdum pøn tumø tumin valetzøcpapø. Y ñøjmayu: “Tzøctam negocio yøṉø tuminji'ṉ hasta que vitu'pa øjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero cumgupyø'nis qui'sayajpana'ṉ je ricu, y por eso cyø'vejyaj pøn cuenta de representante mismo møja'ṉ aṉgui'mbacøsi va'cø ñøjmayajø: “Ji'n ø sundam je pøn va'cø 'yaṉgui'm øjtzomda'm”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero pyøjcøchoṉuti aṉgui'mguy ricu'is, y vitu'u. Y entonces cyø'vejayaju va'cø maṉ vyejayajtøj va'cø min 'yandzoṉyajø je chøsita'm chi'yajupø tumin. Sunba myusø jujche gyanatzøc tumdum pø'nis chi'yajupø tuminji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Entonces min vi'napø y nømu: “Ø Ṉgomi, mi ndum'nis gyanatzøc majcay más”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Y ricu'is ñøjmayu: “Vøjti jetse, ⁿvyøjpø mitz ñchøsi. Porque vøj mi ⁿnøyosu ancø uspø tumin, por eso maṉba mi aṉgui'm majcay cøcumguy”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Y min myetzcu'yombø, y nømu: “Ø Ṉgomi, mi ndumi'nis gyanatzøc mosay más”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Y ñøjmacye't ricu'is: “Mitz maṉba aṉgui'm mosay cøcumguy”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","”Y min eyapø y nømu: “Ø Ṉgomi, yø'c it mi ndumin. Mi vajtaṉne'ca'yøjtzi payu'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Es que mi na'ndzøjtzi porque mi mbyaqui chocopya mbyønete. Mi mbøcpa lo que ja mi ṉgotapø, y mi ṉgosechatzøcpa ja mi nimbøpø”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Y ñøjmay ricu'is: “Mitz yandzipøte mi nchøsi. Mismo mi ne'c mi ondepit mi ⁿyaj quecpa mi ⁿvin. Muspa mijtzi que øtz paqui chocopyø chønø. Øtz mbøcpøjtzi lo que ja ṉgyotapø øjtzi, y ṉgosechatzøcpøjtzi lo que ja ñimbapø øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Entonces ¿ti'ajcuy ja mi ndø cojtay ø ndumin cyoyojyajpamø tumin une, va'cø mbøjcøchovana'ṉ 'yuneji'ṉ cuando mi'nøjtzi?” ");
INSERT INTO zosNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Y ricu'is ñøjmayaj jen ityajupø: “Yac tzu'ṉatyam tyumin, y tzi'tam ñø'ijtupø'is majcay tumin”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Y ñøjayaju: “Ø Ṉgomi, pero je'is nø'ijtuti majcay tyumin”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ricu'is ñøjmayu: “Øtz mi nøjandya'mbøjtzi que mumu ñø'ijtupø'is vøti, maṉba tzi'aṉøtyøji, y ñø'ijtupø'is usyi, hasta usy ñø'ijtupø maṉba yac jøcøjatyøji. ");
INSERT INTO zosNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pero nømindam yø'c jicø qui'sayajpapø'stzi, que ji'n vyø'møyaje va' øtz aṉgui'm je'tomda'm, y yaj ca'tam ø ⁿvi'naṉdøjqui”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jetse Jesusis nømna'ṉ chamu, y cuando cha'maṉjeju, ñe'c Jesús vi'naju, nømna'ṉ myaṉyaj Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Cuando nu'cyaj tome Olivos cotzøjcøsi tomemø ispa Betfagé gumguy y Betania cumguy, jeni Jesusis cyø'vejyaju metzcuy ñøtuṉdøvø va'cø chøjcayaj nu'csocuy. ");
INSERT INTO zosNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Y ñøjmayaju: ―Jic tome mi ispapø che'pø cumguy, maṉdam jiṉø. Cuando mi ndyøjcøtyamba jeni, maṉba mi mba'jtam tum burro une jømdøjupø, ni i'støc ja oy pyo'cse. Pucspø'tamø y jøcø nømindamø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Y o'ca iyø jutipø'is mi ñøjandyamba: “¿Ticøtoya nø mi mbucspø' burro?” ñøjmatyamø: “Porque ndø Comi'is nø syunu que maṉba ñøyose”. ");
INSERT INTO zosNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jetse maṉyaj cyø'vejyajupø y pya'tyaj burro jujche Jesusis ñøjmayajuse. ");
INSERT INTO zosNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cuando nømna'ṉ pyucspø'yaj burro, cyomi'is ñøjmayaju: ―¿Ti'ajcuy nø mi mbucspø' je burro une? ");
INSERT INTO zosNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Y je'tista'm ñøjmayaju: ―Porque ndø Comi'is nø syunu que maṉba yac yose. ");
INSERT INTO zosNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Entonces Jesuscø'mø jøcønømiñaj burro y tyo'cøyaj tyucu burrocøsi, yac po'csyaj jetcøs Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Y jut cyøtpamø Jesús, jen tyo'cøjayaj tyucu tu'ṉomo jetcøs va'cø cyøtø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Y cuando nømna'ṉ myø'ndzo'chaj Olivos cotzøjcøsi, entonces mumu ñøtuṉdøvø'is cyøcasøcho'chaj Jesús. Y pømi vejaṉgøtyaju, vyøcotzøcyaj Dios; porque isyaju ancø maya'cusyeta'mbø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nømyaju: ―¡Vøj va'cø ndø vøṉgotzøctam møja'ṉ Aṉgui'mbapø nø minupø ndø Comi'is ñøyicøsi! ¡Vøj tø nømaṉba Tzajpombø'is! ¡Ndø møja'ṉ vøcøtzøcta'i møjipø Dios! ");
INSERT INTO zosNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Entonces metzcu tu'capyø fariseo'is ityaju'is vøti pø'nomo ñøjmayaj Jesús: ―Maestro, ojnayaj mi nønduṉdøvø va'cø vyøṉneyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero Jesusis 'yaṉdzoṉyaju: ―Ji'n mus ndø yac vøṉneyajø. Mi nøjmambyøjtzi, que o'ca yøṉ pøn vøṉneyajpana'ṉ, hasta tza' vejyajpana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Entonces Jesusis cuando nu'c tome y ischøc cumguy, cyøvo'u. ");
INSERT INTO zosNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nømu: ―¡Vøjømna'ṉete o'ca mi myustambana'ṉ yøṉ jama'omo jujche muspana'ṉ mi ijtam contento! Pero yøti ja it mi ṉgui'psocuy va'cø mi ṉgyønøctøyøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Eya jama maṉba min mi enemigo. Je'is maṉba vye'cøvitu'yaj mi ṉgumguy, jetse maṉba aṉga'mbø'yaje, ji'n ma chacyaj ni jut va'cø mi mbyujtamø, ni jut va'cø mi ndyøjcøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Maṉba yac ju'mbø'yaj mi ṉgumguy y maṉba mi ṉgya'pø'tam mi ijtamuse, y ji'n ma chacyaj ni tum tza' no'tzø'yupø cha'tøvøcøsi. Jetse maṉba tuqui porque oy min mi ṉgyotzoṉdam Diosis, pero ja mi mustamø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Y Jesús tøjcøy masandøc solajromo y myacputputvøyaju mumu jen ma'ajyajpapø y ju'yoyajpapø. ");
INSERT INTO zosNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ñøjmayaju: ―It jachø'yupø: “Ø ndøc Dios o'nøcuy tøjquete”, pero mitz nu'mbapø'is chatøcse mi ndzøctamu. ");
INSERT INTO zosNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Y Jesús aṉma'yopyana'ṉ tumdum jama masandøjcomo, pero pane covi'najø'is y aṉma'yoyajpapø'is aṉgui'mgupit y pø'nista'm cyovi'najø'is nømna'ṉ cyøme'chaj jujche muspa yaj ca'yaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero ji'na'ṉ pya'tyaj jujche muspa ti chøjcayajø, porque mumu pø'nis tum chocoy cyøma'nøyajpana'ṉ Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tum jama'omo Jesusis nømna'ṉ 'yaṉmayaj cumgupyøn masandøjcomo, y nømna'ṉ chajmayaj vøjpø ote. Y nu'cyaj pane covi'najøta'm y aṉma'yoyajpapø aṉgui'mgupit y tzambøndøcvay. ");
INSERT INTO zosNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Y ñøjmayaj Jesús: ―Tzajmay ndøvø; ¿tiyø aṉgui'mgupit yøcse nø mi ndzøjcu, y i'is mi ñchi' yøsepø aṉgui'mguy? ");
INSERT INTO zosNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Y 'yaṉdzoṉ Jesusis y ñøjmayaju: ―Øtz maṉbati mi ⁿocva'ctangue'te; tzajmatyandøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿I'is chi' Juan aṉgui'mguy va'cø ñø'yø'yoya; o tzajpombø Diosis, o nascøspø pø'nis? ");
INSERT INTO zosNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pero antes que va'cø 'yaṉdzoṉyaj Jesús; covi'najø'is jyajme'chaju jujche va'cø 'yaṉdzoṉyajø. Nømna'ṉ na ñøjayajtøju: ―Ji'n mus tø nømdamø que Diosis chi' Juan angui'mguy va'cø ñø'yø'yoyø, porque en ese caso Jesusis maṉba tø nøjatyame: “¿Ti'ajcuy ja mi vya'ṉjamdamø?” ");
INSERT INTO zosNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y ji'n mus tø nømdamø que pø'nis chi' Juan aṉgui'mguy va'cø ñø'yø'yoyø porque en ese caso mumu aṉbø'nista'm maṉba tø pu'ṉdam tza'ji'ṉ, porque pø'nis vya'ṉjamyajpa que Juan tza'maṉvajcopyapøte Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Y covi'najø'is 'yaṉdoṉyaj Jesús: ―Ji'nø mustame i'is chi' Juan aṉgui'mguy va'cø ñø'yø'yoya. ");
INSERT INTO zosNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Y Jesusis ñøjmayaju: ―Ni øtz ji'nø mi ndzajmatyam i'is 'yaṉgui'mgupit ndzøcpøjtzi yøcseta'mbø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Y Jesusis chamdzo'tzayaj vøti pøn yøcsepø historiapit va' yaṉma'yoya. Nømu: ―Chøc tum pø'nis uva cama, y chacyaj encargado, y ñe'c maṉi'n ya'i. ");
INSERT INTO zosNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cuando nu'c cosecha jama, cyomi'is cyø'vej tum chøsi va' ma 'ya'misyaj encargado a ver o'ca piṉyaju'am cosecha, y va'cø ñømaṉjay vø'ne'is cuenda. Pero encargado'is chaṉyaj chøsi y yac vitu'yaj jana ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Entonces vø'ne'is cyø'vejque't eyapø chøsi. Y jetseti chaṉyajque'tu y topa'o'nøyaju y yac vituyajque't jana ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Y vø'cama'is cyø'vejque't tu'ca'yombø chøsi. Yøṉö ñacscøjetyajque'tuti y myacpø'yaj yoscu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","”Al fin nøm vø'cama: “¿Tiyø ndzøcpa yøti? Mejor ṉgø'vejpøjtzi ø ⁿune sunbapø'tzi. Tal vez maṉbati cyøna'tzøyaje”. ");
INSERT INTO zosNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero cuando isayaj 'yune nø ñu'cupø, na ñøjayajtøj encargado: “Yø'ṉis maṉba ñø'tzø'y yøṉ yosaṉ. Ma ndø yaj ca'ta'i, va'cø ndø cøpøctam yosaṉbit”. ");
INSERT INTO zosNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Y ñøputyaj nipi'omo vø'yosa'ṉis 'yune, y yaj ca'yaju. Pero ¿ti manba chøjcayaje vø'nipi'is? ");
INSERT INTO zosNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Maṉba mini y maṉba yaj ca'yaje jic encargado y nipi maṉba chi'yaj eyapø. Jetse Jesús nømu, y cuando vøtipø'nis myañaju, nømyaju: ―¡Uy syun Diosis? ");
INSERT INTO zosNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero Jesusis 'ya'myaj pøn y ñøjmayaju: ―¿Ti'ajcuy jachø'yupø Diosis libru'omo: Ijtu tum tza' ja syuñajøpø tøc tzøcyajpapø'is; pero eyapø'is cyøpiṉ mismo je tza' va'cø yac yos tøc aṉgui'nomo, porque jen más vøjpø tza' syunba? ");
INSERT INTO zosNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aunque iyø quecpa jicø tza'cøsi, pyajcøquitpa vyin. Pero icøs quecpa je tza', ñama pu'ṉgøvenba. ");
INSERT INTO zosNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ji'cø misma hora pane covi'najø'sta'm y aṉma'yoyajpapø'is aṉgui'mgupit cyøme'chajpana'ṉ modo va' ñucyaj Jesús. Pero ña'chaj vøti pøn. Cyønøctøyøyaju que yøṉø historia jetse cham Jesusis va'cø yac mustøjø que ñe'c pane covi'najø'is maṉba chøcyaj como encargado'sta'm chøcyajuse; (como encargado'is yaj ca'yaj vø'ne'is 'yune, jetse je'is maṉba yaj ca'yaj Diosis 'Yune). ");
INSERT INTO zosNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Entonces covi'najø'is chøcme'tzjo'yaju a ver jujche muspa yac ondocoyaj Jesús va'cø mus chi'ocuyaj aṉgui'mbacøsi, va'cø ti chøjcayajø. Por eso cyø'vejyaj cyø'isøpapø'is; como vøjpø amigose maṉba 'yo'nøyaje, pero va'cø 'yaṉgøma'cøyajø a ver o'ca muspa yaj quecyaj tzamdzamnecucyøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Je'is 'yaṉgøva'cyaj Jesús: ―Maestro; musta'mbøjtzi que viyuṉsye mi nchamba y vøj mi 'yaṉma'yombya. Parejo mi suñajpa mumu pøn; y viyuṉsyepø mi isindzi'yajpa Diosis tyuṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tø tzajmatyamø o'ca vøjø o ji'n vyøjø va'cø ndø cøcoyojtam aṉgui'mba Cesarcøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero Jesusis myusayaju myaña'ajcuy y ñøjayaju: ―¿Ticøtoya sunba mi ndø aṉgøma'cøtyamø? ");
INSERT INTO zosNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Mi ndø isindzi'tam tum tumin. ¿I'is cyene ijtu tumingøsi, y i'is ñøyi ij tumingøsi? Y je'is 'yaṉdzoṉyaju y ñøjmayaju: ―Aṉgui'mbapø Cesajris ñe' ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Entonces Jesusis ñøjmayaju: ―Pues entonces tzi'vitu'tamø aṉgui'mbapø César o'ca je'is ñe'; y lo que Diosis señe, tzi'tam ñe'c Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jetse ja mus yac ondocoy Jesús pø'nis vyi'naṉdøjquita'm. Y maya'yaju jujche 'yaṉdzoṉyaju; y vøṉgøne'cyaj qui'sayajpapø'is Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Y nu'cyajque't Israel pønda'm saduceo'is 'yaṉma'yocuy ñø'ijtayajupø'is. Saduceo nømyajpana'ṉ que ji'n visa'yaj ca'yajupø. Je'is ñøjmayaj Jesús: ");
INSERT INTO zosNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, Moisesis tø jajyatyam øjtzi o'ca ca'pa tum pøn ijtupø'is yomo, y ja it 'yune, que myuqui'is va' pyøjcay yomo va'cø it 'yune por cuenta 'yatzi'is 'yune. ");
INSERT INTO zosNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pues oy cu'yay pøn mismo tumbø pø'nis 'yune, y vin atzi'is o pyøc yomo, y ca'u jana une. ");
INSERT INTO zosNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Entonces myuqui'is pyøjcay yomo y ca'que'tuti, ni tumdi une ja chajque'ta. ");
INSERT INTO zosNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Entonces tu'ca'yombø'is mismo yomoti pyøjque'tu; y jetse cu'yacø'yita'm mismo yomo pyøcmin pyøcmaṉyaju. Y mumu ca'yaju; ni jutipo'is ja chac 'yune. ");
INSERT INTO zosNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Y último ca' ñe'c je yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Entonces cuando visa'yajpa ca'yajupø, ¿a ver jutipø'is maṉba pyøc je yomo? Porque cyu'ya'cyø'yi ñø'oyaj mismo je yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Y ñøjmayaj Jesusis: ―Yøtita'mbø pøn co'tøjcajyajpa y chi'ocuyajyajpa 'yune va'cø cyo'tøjcajyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero jutipø pøn Diosis chamba que jic maṉba ityaj jiṉø jicsye'cpø jama'omo, y va'cø visa'yajø ca'yajupø'omo; jic pøn ji'nam maṉ cyotøjcajyaje, ni ji'nam maṉ chi'ocuyajyaj 'yune va'cø cyo'tøjcajyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Porque ji'ndam mus cya'vøjøtzøcyajø, porque aṉgelesetim ityajpa y Diosisam 'yuneta'm porque visa'yajupømete. ");
INSERT INTO zosNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pero o'ca maṉba visa'yaj ca'yajupø, jete mismo Moisesis cha'maṉvac libru'omo nømbamø que ndø Comi'is 'yo'nøy Moisés cuando nembapø che'pø cu'yomo onbujtu. Moisesis jyayu que ndø Comi jiquete Dios nø vya'ṉjamyajupø Abraha'mis, y Isaajquis y Jacojbis. ");
INSERT INTO zosNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","(Jetse ndø tzi'pa cuenta que Abraham, Isaac y Jacob queñajpatøc); porque Dios ji'ndyet ca'yajupø'is vya'ṉjamyajepø, sino queñajpapø'is vya'ṉjamyajpa porque mumuti para Dioscøtoya queñajpa. ");
INSERT INTO zosNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Y vene aṉma'yoyajpapø'is aṉgui'mgupit ñøjmayaj Jesús: ―Maestro, vøjpø mi ndzamu. ");
INSERT INTO zosNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y de jeni ni i ja chi' ganas va' 'yocva'cyaj Jesús ni ti más. ");
INSERT INTO zosNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Y Jesusis ñøjmayaju: ―¿Ti'ajcuy nømyajpa que Cristo lo que Diosis cyø'vejupø Davijdise 'yune? ");
INSERT INTO zosNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Porque Salmos libru'omo it jaychø'yuse que mismo ñe'c David nømu: Ndø Janda Diosis ñøjmay ø Ṉgomi: “Po'cs ø ndzø'na'ṉomo, ");
INSERT INTO zosNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta que øtz mi ṉgønu'ṉgøjayajpa mi enemigota'm”. ");
INSERT INTO zosNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jetse David nømu que Cristo ñe'c Davijdis Cyomite. Pero o'ca Cristo Davijdis Cyomite, entonces ji'n jutz nøm ma tø nømi que Cristo ñe'c Davijdis 'yunete. ");
INSERT INTO zosNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mientras vøti pø'nis cøma'nøyaju, Jesusis ñøjmayaj ñøtuṉdøvø: ");
INSERT INTO zosNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Cuendatzøctamø jana mi 'yaṉgøma'cøtyamø aṉgui'mguji'ṉ aṉma'yoyajpapø'is. Pues sunba vyityaj pøji tucu'omo, y syuñajpa va'cø yuschi'yajtøjø plaza'omo; y sunba maṉ pyo'csyajø myøja'ṉombø'is pyo'cscu'yomo cuando tu'myajpa. Y cuando itpa søṉgu'tcuy, sunba po'csyaj más myøja'ṉombø pøn po'csyajpamø. ");
INSERT INTO zosNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yøṉ aṉma'yoyajpapø'is aṉgui'mgupit cyøpøcyajpa yaṉbac yomo tyøcji'ṉ, y chøcyajpa pøjipø conocscuy va'cø cyomo'yajtøjø que vøjta'mbø pønda'mete. Pero jet más maṉba castigatøcyajtøji. ");
INSERT INTO zosNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesusis 'ya'mu y ischøjcu que ricu'is nømna'ṉ cyotyaj ayudo caja'omo masandøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Isque'tuti que tum pobrepø yaṉbac yomo'is cyotque't jeni metzcuy namdumin. ");
INSERT INTO zosNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Y Jesús nømu: ―Viyuṉsye nø'mbøjtzi que yøṉø pobrepø yaṉbac yomo'is cyot más que ji'n mumu eyata'mbø'is cyotyajuse. ");
INSERT INTO zosNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Porque mumu ji'quista'm sobratzøjcupø tumin cyotyaj caja'omo, pero yø'ṉis cyot mumu ñø'ijtusena'ṉ tumin aunque chøjcapyana'ṉ falta tumi'nis. ");
INSERT INTO zosNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Y veneta'mbø nømyajpana'ṉ que masandøc ijtuna'ṉ ño'chaj suñipø tza'ji'ṉ, y ñø'ijtuna'ṉ suñita'mbø adorno va'ctzi'yajtøjupø. Jesús nømu: ");
INSERT INTO zosNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Yøṉø suñipø masandøc mi ispapø, eyapø jama maṉba ju'mbø'i que ji'n ma chø'y ni tumø tza' ne'csca'mupø cha'tøvøcøsi; maṉba ju'mbø' nama nama. ");
INSERT INTO zosNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Y ñøtuṉdøvø'is cyø'ocva'cyaj Jesús y ñøjayaju: ―Maestro, ¿jujchøc maṉba tuqui mi ndzamuse, y tiyø seña maṉba queje cuando maṉba tuctzo'tz mi ndzambase? ");
INSERT INTO zosNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Y Jesusis ñøjmayaju: ―Tzøjcatyam cuenda ni jutipø'is jana mi 'yaṉgøma'cøtyamø; porque maṉba miñaj vøti pøn ø nøyingøsi y maṉba nømyaje: “Øjchømøṉø Cristo”, y maṉba nømyajque'te: “Yajcuy nø tyome'aju”. Pero u mi maṉ mba'jtam jetsepø pøn. ");
INSERT INTO zosNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cuando mi manba o'ca it quipcuy y vøti pøn so'natejyajpa, u mi ña'tztamu; porque jetse tiene que vi'na va' tyucø. Pero ji'nmajtøc man yajnøm pronto. ");
INSERT INTO zosNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jicsye'cti ñøjmayajque't Jesusis: ―Vø'cumgu'is maṉba qui'sayaj eyata'mbø cumguy, y aṉgui'myajpapø'is maṉba qui'sayaj eyata'mbø 'yaṉgui'mba tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yømøc teymøc maṉba cøt pømipø nasamicscø', y vøtico cumgu'yomo maṉba it yu', maṉba it ca'cuy; maṉba na'tzaṉdocoyaj cumgupyøn. Maṉba neṉe quejyaj møjata'mbø seña tzajpomo, maṉba'is chøcna'tze. ");
INSERT INTO zosNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","”Pero ji'n ma tuc jetse hasta que vi'nati maṉba mi ñuctandøji, y maṉba mi yacsutzøctandøji, y maṉba mi nchi'ocuyajtandøji Israel pø'nis cyonocscuy tøjcomo. Y maṉba mi syomdandøji, maṉba mi ṉgyøtza'møtandøji aṉgui'mbacøsi y gobiernocøsi porque mi ndø vaṉjamdamba ancø. ");
INSERT INTO zosNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Cuando jetse mi ñdyuctamba, maṉba mus mi ndzamdamø jujche mi va'ṉjajmoṉgutya'm. ");
INSERT INTO zosNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pero ni ti u mi ṉgui'pstam mi ndzoco'yomo; ni u mi ṉgoqui'pstam vi'na jujche maṉba mi 'yaṉdzo'ṉotyame. ");
INSERT INTO zosNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porque øtz maṉba mi ndzi'tam vøjpø qui'psocuy jujche va' mi 'yondamø, y por eso ni jutipø mi ṉgui'satyambapø'is ji'n mus ma tyona va' mi 'yonguiptamø. ");
INSERT INTO zosNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pero mitzta'm maṉba mi ñchi'ocuyajtam hasta mi janda'is y mi andzi'is y mi ndøvø'sta'm, y mi amigo'sta'm; y maṉba yaj ca'tandøj iyø jutipø mijtzomda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Y mumu pø'nis maṉba mi ṉgui'satyame porque mi ndø va'ṉjamdamba ancø. ");
INSERT INTO zosNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero ni tum ⁿvay mi ṉgopajcøspø ji'n ma tyocoye. ");
INSERT INTO zosNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","O'ca mi ndondamba, maṉba mi ṉgyendame. ");
INSERT INTO zosNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","”Cuando mi istamba que vøti soldado'is vyoyaju'am Jerusalén gumguy; jicsye'c maṉba mi mustame que pronto maṉba yaj cumguy. ");
INSERT INTO zosNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ityajupø Judea nasomo, yac poyaj cotzøjcøtøjcø'mø; y ityajupø cumgu'yomo, va'cø pyoyajque'tati. Y ityajupø tza'momo, va'cø jana tøjcøyaj cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porque jic jamacøsi Diosis maṉba yac nøco'aṉgøyaje 'yenemigo va'cø tyucpø'ø jachø'yuse Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pero jic jama vøti maṉba isyaj toya yomo'is o'ca ji'ndyet tumbø, y o'ca yac tzu'chajpa'is 'yune. Porque maṉba it møja'ṉ doya nascøsi. Y vøti maṉba cyøqui'syca'yaj Diosis yøṉ cumgu'yomda'mbø. ");
INSERT INTO zosNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Y vene maṉba yaj ca'yajtøj espadaji'ṉ, y vene maṉba ñømaṉyajtøji como presu cuenta aunque jutipø cumgu'yomo. Y lo que ji'ndyet Israel pø'nis maṉba maṉ vitu' vitu' vøyaj Jerusalén gumguy hasta que cøtpacsye'ṉom lo que ji'ndyet Israel pø'nis 'yora. ");
INSERT INTO zosNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","”Jicsye'cti maṉba neṉe quej seña møji jamacøsi y poyacøsi y matzacøsta'm, y nascøsi maṉba tucyaj como jujchese mumu ijtuse pønda'm; y ji'n ma musyaj ti va'cø chøcyajø cuando isyajpa nø tya'mu y nø pyuṉbø' mar. ");
INSERT INTO zosNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pønda'm maṉba mochi'ajpø'yaj na'tzcu'is, y porque maṉba qui'psyaj choco'yomo jujche maṉbase tucnøm nascøsi; y pømi'øyajupø tiyø tzajpomo maṉba micsyaje. ");
INSERT INTO zosNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Y ji'csye'cti maṉba quej øjtzi mumu Pø'nis chøṉ Tyøvø. Ma'ṉbø mini o'na'omo y pømi'øyupø y øtz ma'ṉbø møja'ṉ sø'ṉi. ");
INSERT INTO zosNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cuando yøcsepø tiyø tuctzo'tzpa, quende'ndamø, pømi pøctamø, porque nø tyome'aj va' mi ṉgyotzoctamø. ");
INSERT INTO zosNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Y Jesusis chajmay historia va'cø 'yaṉma'yoya. Nømu: ―A'mdam higo cuy y mumu cutya'm. ");
INSERT INTO zosNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cuando istamba mi ne'ṉgø que cøvo'mu'am, jetse mi ndzi'tamba cuenta que tome'am ja'maṉsøṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jetsetique't cuando mi ispa o'ca nø tyuctzo'tz øtz ndzamuse, jetse maṉba mi mustame que ya mero maṉba aṉgui'moy Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","”Viyuṉsye mi nøjmambya que mumu øtz ndzamuse maṉba tucnømi antes que ca'pø'yajpa yøti ityajupø pøn. ");
INSERT INTO zosNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tzap y nas maṉba yaje, pero ø onde ji'n ma cøyaje. ");
INSERT INTO zosNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","”Tzøjcatyam cuenda mi ṉgui'psocu'yomo jana mi ṉgyu'tcomø'ṉdamø, ni jana mi ño'jtamø, ni jana mi ṉgui'pscocøjtam nascøspø itcuy; utyem jovise nu'c yajcuy mitzcøsta'm. ");
INSERT INTO zosNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Porque como tum trampa'is ñucpase copøn, jetze jovise yajcuy maṉba ñu'c mumu nascøsta'mbø pøngøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Por eso mø'chøqui coquendam mi ⁿvin y o'nøtyam Dios mumu jama va'cø cyoqui'ps ñe'cø que vøjø va'cø mi ṉgyotzoctamø cuando tucpa mumu jetsepø toya'iscuy; y jetse jana na'tzcuy va'cø mus mi ijtam ø vi'ṉaṉdøjqui; mumu Pø'nis chøṉ Tyøvø øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jetse Jesusis 'yaṉmayajpana'ṉ jama'omo masandøjcomo, y tzu'i putpana'ṉ cumgu'yacapoya ijtumø cotzøc ñøjayajpapø Olivos cotzøc. ");
INSERT INTO zosNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tumdum jama mumu pøn nu'cyajpana'ṉ namdzuti masandøjcomo va'cø cyøma'nøyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nømna'ṉ tyome'aj søṉ cuando cyu'tyajpana'ṉ pan ja pyoṉoṉapø; jic søṉ ñøjayajpana'ṉ pascua søṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Y pane covi'najø'ista'm y aṉma'yoyajpapø'is aṉgui'mgupit mye'tzayajpana'ṉ modo jujche muspa yaj ca'yaj Jesús; porque je covi'najø'is ña'chaj vøti pøn. ");
INSERT INTO zosNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Entonces Satanasis ñøtzøc Judas nøyipø'is ñøyi'aṉgopac Iscariote; docepø apostolesete. ");
INSERT INTO zosNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Y Judasis maṉ 'yo'nøyaj pane covi'najøta'm y cyoqueñajpapø'is masandøc a ver jutzna'ṉ muspa chi'ocuyaj Jesús pane covi'najøcøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pane covi'najø casøyaju y vyø'møyaju va' cyoyojyaj Judas. ");
INSERT INTO zosNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judasis ñøjmayaju que maṉba chi'ocuyaje, y cyøme'tzpana'ṉ jujche muspa nu'mdzi'ocuyajø ni i ja ityømø. ");
INSERT INTO zosNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nu'cu'cam jic jama cuando cyu'tyajpana'ṉ pan ja pyoṉoṉapø, cuando tiene quena'ṉ va' yaj ca'yaj borrego pascua sø'ṉis cuenta. ");
INSERT INTO zosNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Y Jesusis cyø'vejyaj Pedro y Juan y ñøjmayaju: ―Maṉdamø, ma alistatzøctam lo que tiyø pascua søṉgøtoya ti maṉba ndø cu'jtame. ");
INSERT INTO zosNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Y je'tis ñøjmayaj Jesús: ―¿Jut mi sunba mijtzi va'cø ndø alistatzøctamø? ");
INSERT INTO zosNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Y Jesusis ñøjmayaju: ―Cuando mi ñdyøjcøtyamba cumgu'yomo, maṉba mi ndzoṉdam tum pøn nø ñømaṉupø'is tum majcuy nø'. Ma pa'jtamø jutipø tøjcom tøjcøpya. ");
INSERT INTO zosNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Y ñøjmatyam vø'tøc: “Maestro'is sunba myusø jut it cuarto muspamø cyu'tyaj ñøtuṉdøvøji'ṉ pascua sø'nis cyu'tcuy”. ");
INSERT INTO zosNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Y je'tis maṉba mi isindzi'tam møjipø cuarto møjapø y vøjøtzøjcupø. Jeni alistatzøctamø. ");
INSERT INTO zosNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jicsye'cti Pedro y Juan maṉyaju y pya'tyaju jujche Jesusis ñøjmayuse. Y 'yalistatzøcyaju pascua søṉ gu'tcuycøtoya. ");
INSERT INTO zosNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nu'cu'jcam 'yora, Jesús po'cs mesyacø'mø apostolesji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Y Jesusis ñøjmayaju: ―Nømna'ṉ ø cu'tcomø'ndo' yøṉø pascua søṉgu'tcuy mitzji'ṉdam antes que nøṉgøtpø toya. ");
INSERT INTO zosNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Porque nøjmañdyambø'mtzi que øtz ji'nam ma ṉgu't eyapø pascua søṉgu'tcuy hasta que cu'tque'tpøjtzi pascua søṉ Dios 'yaṉgui'mbamø. Jicsye'ctøc ma ṉgu'tque'te. ");
INSERT INTO zosNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Y pyøc Jesusis tum vaso uva nø' y ñøjay Dios yøscøtoya, y nømu: ―Pøctam yøṉø y to'ṉve'ndam mijtzomda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Porque mi nøjandya'mbøjtzi que øtz ji'nam ma ndo'ṉ uva nø' hasta jic jama minba aṉguim Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Entonces pyøc Jesusis pan y ñøjay Dios yøscøtoya y vye'nu y cyø'yaj apostoles y ñøjmayaju: ―Yøṉø pan øjchøn sis, y yøṉ ø sis ma'ṉba ndzi'ocuyaj mitzcøtoyata'm. Yø'cse sajtam pan mi ne'ṉgomda'm va'cø mi ndø jajmundzøctamø. ");
INSERT INTO zosNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Y cu'taṉbacyaju'cam, Jesusis pyøjque'tuti mbaso y nømu: ―Yøṉete jomepø contrato ø nø'mbinji'ṉ. Ø nømbin maṉba jø't mitzcøtoyata'm. ");
INSERT INTO zosNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","”Pero yøti yø'c it øtzji'ṉ mesyacøsi maṉbapø'is ø tzi'ocuyaje. ");
INSERT INTO zosNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Y viyuṉsye øtz mumu Pø'nis chøṉ Tyøvø maṉba tuc øjtzi jujche chamuse Diosis vi'na. Pero ¡lástima jicø pøn maṉbapø'is ø tzi'ocuyaje! ");
INSERT INTO zosNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Y apostolesista'm na 'yocva'ctzo'chajtøju jutipø'is maṉba chøc chamuse Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Entonces onguipyaj ñe'comda'm jutipø maṉba cyovi'najø'aje. ");
INSERT INTO zosNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Y Jesusis ñøjmayaju: ―Entre nascøspø pø'nomda'm, aṉgui'mbapø'is dyominatzøcpa eyata'mbø, y nøjayajtøjpa que aṉgui'mbapø vøco'nipø pønete. ");
INSERT INTO zosNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero mitzta'm ji'n mus mi ndzøctam jetze, sino que más cyovi'najøpø entre mijtzomda'm tiene que va'cø it como menospø'is 'yamese; y aṉgui'mbapø tiene que va'cø it como nu'cscusye. ");
INSERT INTO zosNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Porque o'ca tum pøn cuc mesacø'mø pø'cspa y eyapø'is cyojtapya cu'tcuy, ¿ji'nacsque't jete más covi'najøpø cucmesacø'm po'csupø? Pero øtz ijtu mitzji'ṉdam como coyospapøse. ");
INSERT INTO zosNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","”Mitzta'm como siempre øtzji'ṉ mi ijtamu hasta como yøti cuando tzøjquistøjøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Como jujche ø Janda'is yac aṉgui'mbøjtzi como gobiernose, jetse ø mi yac aṉgui'mdaṉgue'tpøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Por eso muspa mi ṉgyu'jtamø y muspa mi ⁿyuctamø ø mesacøsi jut ø aṉgui'mbamø, y maṉba mi mbyo'csta'm aṉgui'mba'is pyo'cscucyøsta'm va'cø mi ṉgøme'tztam cyojapit docepø Israejlis 'yune'is fyamiliata'm. ");
INSERT INTO zosNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","También ñøjmay ndø Comi'is: ―Simón, Simón, cøma'nøyø; Satanasis vya'c licencia va'cø mi nchøjquistamø. Como jujche ndø yø'ṉgøvitu'pa trigo puj va'cø chø'y puro pyuj, jetse Satanasis maṉba mi nchøjquistame a ver o'ca mi ndø va'ṉjamdamba. ");
INSERT INTO zosNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero øtz o'nøyø Dios para mitzcøtoya va'cø jana mi nchøjcay falta mi va'ṉjajmoṉgu'is. Y mijtzi cuando mi ṉgui'psvitu'ujcam va'cø mi vøṉgova'ṉjamque'te, entonces cotzoṉyaj mi ndøvø va'cø vya'ṉjajmoyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pero Pedro'is ñøjmay Jesús: ―Øjtzø mi Ṉgomi, øtz dispuesto ijtøjtzi va'cø maṉ mitzji'ṉ preso'omo y va'cø ca' mitzji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Y Jesusis ñøjmayu: ―Pedro, nøjmambyøjtzi que antes que vejpa ṉgaylu, tu'cay ñac maṉba mi ndzame que ji'n mi ndø co'ispøqui. ");
INSERT INTO zosNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesusis ñøjmayaju: ―Cuando mi ṉgø'vejtam øjtzi jana morral y jana tumingotcuy y jana sapato, ¿ti'is ñchøjcatyam falta? Y je'is ñøjmayaju: ―Ni ti'is. ");
INSERT INTO zosNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Y Jesusis ñøjmayaju: ―Pero yøti o'ca it mi morral, nømavø; y jetsetique't mi ndumingotcuy; y o'ca ja mi nø'it espada, ma'aj mi ṉgamisola va'cø mi ⁿjuy espada. ");
INSERT INTO zosNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porque nøjambya mijtzi que øtz tiene que va'cø tyucø como jujche it Diosis 'yote jachø'yupø; porque jen jachø'yupøte: “Parejo yacsutzøcyaju yatzita'mbø pønji'ṉ”. Porque ya mero maṉba tuqui como ijtuse jachø'yupø. ");
INSERT INTO zosNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Y apostolesista'm ñøjmayaj Jesús: ―Ø Ṉgomi, yø'c it metzcuy espada. Y Jesusis ñøjmayaju: ―Ya sobram jetji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Y Jesús tzu'ṉ jeni, y jujchem cyostumbre ijtu, maṉ Olivos cotzøjcøsi. Y ñøtuṉdøvø'is maṉuti pya'tyajque'te. ");
INSERT INTO zosNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Y cuando nu'cyaj jic lugajromo, Jesusis ñøjmayaju: ―O'nøtyam Dios va'cø jana mi ṉgyectamø o'ca mi nchøjquistandøjpa. ");
INSERT INTO zosNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Y Jesús tzu'ṉ jetcø'mda'm usy ya'i. Jujche'ṉomo muspa ndø mbatzpø' tza', jañche'ṉomo Jesusis cya'ṉdzacyaju. Y jeṉ cujneyu'øc 'yo'nøy Jyata. ");
INSERT INTO zosNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ñøjmayu: ―Øjtzø mi Janda, o'ca jetse mi sunba, tø yaj cotzoc ndøvø va'cø jyana toya'isø; pero va'cø tyucø mitz mi sunbase, ji'ndyet øtz sunbase. ");
INSERT INTO zosNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Y cyejay Jesús tum tzajpombø angelesis y yac pømipøjcu. ");
INSERT INTO zosNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús ijtuna'ṉ møja'ṉ doya'omo, y tyumø chocoy 'yo'nøpyana'ṉ Dios. Y møjata'mbø pyøsø tzu'nmø'nu si fuera como nø'pin chu'nmø'nbase, jetse nømna'ṉ cyecyaj nasomo. ");
INSERT INTO zosNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Entonces 'yo'nøyu'cam Dios, Jesús te'nchu'ṉu y maṉ ityajumø ñøtuṉdøvø, y pya'tyaju øṉyajupø maya'cu'is. ");
INSERT INTO zosNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Y Jesusis ñøjmayaju: ―¿Ti'cøtoya nø mi 'yøṉdamu? Te'ñchu'ṉdamø y o'nøtyam Dios va'cø jana mi ṉgye'ctamø cuando mi ñchøjquistandøjpa. ");
INSERT INTO zosNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mientras que Jesús jetse nømdøcna'ṉ vyejvejneyu, nu'cyaj vøti pøn. Y tum macvøstøjcapyø ñøtuṉdøvø ñøyipø'is Judas, jet vi'naju y cyønu'c Jesús va'cø syu'cø. ");
INSERT INTO zosNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Y Jesusis ñøjmayu: ―Judas, ¿ti'ajcuy jetse mi ndzøcpa? Mi ndø su'cpa va'cø mi ndø tzi'ocuyaj ø enemigocøsi, øtz mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ityajupø'sna'ṉ jeni isyaju ti maṉba tuqui, y ñøjmayaj Jesús: ―Ø mi Ṉgomi, ¿sunbaja mijtzi va'cø mi ṉgoquiptam espadaji'ṉ? ");
INSERT INTO zosNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Y tumbø'is chetzcajpø'jay pane covi'najø'is ñu'cscu'is chø'na'ṉombø tyatzøc. ");
INSERT INTO zosNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero jicsye'cti Jesusis ñøjmayu: ―Uyam más jetse tzøqui. Y pi'quisay tyatzøc y yac tzojcayu. ");
INSERT INTO zosNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesusis ñøjmayaj pane covi'najøta'm y masandøjcom aṉgui'myajpapø y tzambønda'm miñajupø va'cø ñucyajø: ―¿Ti'ajcuy mi ndø cømindamu va'cø mi ndø nuctam mijta'm espadaji'ṉ y cuyji'ṉ jujche ñuctøjpase nu'mbapø? ");
INSERT INTO zosNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Cuando tumdum jama øtz ijtuna'ṉ mitzji'ṉdam masandøjcomo, ja mi ndø nuctamø. Pero nu'cu'am mi oranda'm va' mi ndzøctam mi sundambase, y va'cø mus chøc gyusto pi'tzø'ajcu'yombø aṉgui'mbapø'is. ");
INSERT INTO zosNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Entonces ñucyaj Jesús y ñømaṉyaj pane covi'najø'is tyøjcomo. Y Pedro'is maṉuti pya'tque't Jesús, pero ya'i tzø'yu. ");
INSERT INTO zosNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yac tzocyaj juctyøc cuc solajromo y juctyøjcø'mna'ṉ po'csyaju; y Pedro jendi po'csque't jetji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Y tum coyomo'is is Pedro que juctyøjcaṉvini po'csque'tu; y 'ya'm mø'chøqui Pedro. Entonces nømu: ―Yøṉø jetji'ṉbøtina'ṉetque't. ");
INSERT INTO zosNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero Pedro'is ja vya'ṉjajmø o'ca jetji'ṉbøna'ṉete. Ñøjmay yomo: ―Ji'nø ispøc je pøn. ");
INSERT INTO zosNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ya'yu'jcam usyaṉ hora, isque't Pedro eyapø'is y ñøjmayu: ―Mitz je'isna'ṉe mi ñønduṉ. Pero Pedro'is ñøjmayu: ―Tzambøn, pero øtz ji'n chøṉ jicji'ṉbø. ");
INSERT INTO zosNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Y cøjtu'jcam como tumø horasye'ṉomo, eyapø nømu: ―Viyuṉsye yøṉø jetji'ṉbøtina'ṉetque't, porque Galilea cumgupyønditque't. ");
INSERT INTO zosNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero Pedro'is ñøjmayu: ―Tzambøn, øtz ji'nø musi ti nø mi ndzamu. Y misma hora, mientras que nømdøcna'ṉ vyejvejneyu, vej ṉgaylu. ");
INSERT INTO zosNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ndø Comi que'najvitu'u y cyøque'nøy Pedro. Y Pedro'is jyajmutzøjcay 'yote ñøjmayuse ndø Comi'is: “Antes que vejpa ṉgaylu, tu'cañac maṉba mi ñømi que ji'n mi ndø ispøc ndøvø”. ");
INSERT INTO zosNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Entonces Pedro put a'ṉgomo y vo'tzocopajcu. ");
INSERT INTO zosNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Y ñucyajupø'is Jesús cyøsijcayajpana'ṉ y ñacsyajpana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Vyinjupyaju y jetse vyi'nøc tza'ṉøyajpana'ṉ y ñøjmayajpana'ṉ: ―Tø tzajmayø i'is mi ñchaṉu. ");
INSERT INTO zosNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y tyopo'o'nøyajpana'ṉ vøti eyata'mbø oteji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cuando sø'ṉbønømu'jcam, tu'mbøyaj cumgu'yomda'mbø tzambøn, y pane covi'najøta'm, y aṉma'yoyajpapø aṉgui'mgupit. Y ñømaṉyaj Jesús tu'myajumø aṉgui'myajpapø, y 'yocva'cyaj Jesús: ");
INSERT INTO zosNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―O'ca mijtzømete Cristo, tzajmay ndøvø. Jesusis 'yaṉdzoṉyaju: ");
INSERT INTO zosNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","―O'ca mi ndzajmapyøjtzi, ji'n mi ndø va'ṉjamdame. Y o'ca mi ⁿocva'cta'mbøjtzi, ji'n maṉ mi ndø aṉdzoṉdame, ni ji'n maṉ mi ndø tzøcøpø'tame. ");
INSERT INTO zosNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero desde yøti øtz maṉba po'cse más pømi'øyupø Diosis chø'na'ṉomo, øjchøṉ mumu Pø'nis Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Entonces mumu 'yocva'cyaj Jesús: ―¿Entonces mijtzømete Diosis 'Yune? Y Jesusis ñøjmayaju: ―Øjtzømete mitz mi ndzamdamuse. ");
INSERT INTO zosNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Y jejta'm nømyaju: ―Ji'nam ndø sundam testigos, porque tø øjta'm nømdi ndø majnandyam 'yote ñe'c jujche nø ñømu. ");
INSERT INTO zosNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jicsyec'ti mumu jejta'm tzu'ṉyaju y ñømaṉyaj Jesús aṉgui'mbapø Pilatocø'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y cyøtza'møcho'chaj Jesús y nømyaju: ―Ndø pa'jtam yøṉ pøn que ñøtzotzpapø'is quipcuy ndø cumgu'yomo y ya'inducpapø'is va' jyana coyojyaj pago møja'ṉ aṉgui'mbapøcøsi, y ñe'c nømba que Cristote; que por eso møja'ṉ aṉgui'mba. ");
INSERT INTO zosNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jicye'cti Pilato'is 'yocva'c Jesús: ―¿Mijtzømate Israel pø'nis mi 'Yaṉgui'mba? Jesusis 'yaṉdzoṉu: ―Øj chønø nømdi mi ndzamuse. ");
INSERT INTO zosNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Entonces Pilato'is ñøjmayaj pane covi'najøta'm y eyapø pønda'm: ―Ni tiyø cyoja ja mbya'ta'yøjtzi yøṉø pø'nis ñe. ");
INSERT INTO zosNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero vøti pøn vejaṉgøtyaju va'cø chøjcayaj cyoja; ñømgomø'nayaj Pilato: ―Yøṉ pø'nis yaj quipte'ñajpa pøn 'yaṉma'yocuji'ṉ. Jetse aṉma'yopya mumu Judea nasomo. Galilea nasomo aṉma'yocho'tzu hasta yøṉsye'ṉom minu. ");
INSERT INTO zosNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cuando Pilato'is myanu que nø cham Galilea, 'yocva'cu o'ca Galilea nasombø pønete. ");
INSERT INTO zosNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Y cuando myusu que Jesús Herodesis 'yaṉgui'mgu'yom ijtu, entonces Pilato'is cyø'vej Jesús Herodescø'mø. Porque Herodes Jerusalén gumgu'yomna'ṉ ijtu jic jama. ");
INSERT INTO zosNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodesis cyøcasøcomø'nu cuando isu Jesús, porque ijtumna'ṉ jyama sunbamømna'ṉ isø; porque myanbana'ṉ vøti nø chøjcupø tiyø. Sunbana'ṉ 'ya'may milagro'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Y Herodesis vøti nac 'yaṉgøva'c Jesús, pero Jesusis ni jujche ja 'yaṉdzova. ");
INSERT INTO zosNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Y pane covi'najøta'm y aṉma'yoyajpapø aṉgui'mgupit jena'ṉ te'ñaju, pømi cyøtza'møyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Y Herodesis y syoldado'is ni tise ja chøcyaj Jesús, y 'yaṉgøsijcayaju, y yac mes tum vøjpø tucu suñi sø'ṉbapø. Y jicsye'c Herodesis yac vitu' Jesús Pilatocø'mø. ");
INSERT INTO zosNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Y Herodes y Pilato jej jama amigo'ajyaju, porque enemigona'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Entonces Pilato'is vyejaṉdø'pyaju pane covi'najø y aṉgui'myajpapø y vøti cumgupyøn. ");
INSERT INTO zosNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Y Pilato'is ñøjmayaju: ―Mitzta'm tø nømijnatyam yøṉ pøn mi ñømdamba que yø'nis ñøtzo'tzpa quipcuy cumgu'yomo; pero ṉgøme'tz øjtzi mi vi'nomda'm, y ja mbya'ta'yøjtzi ni jujchepø cyoja como mi ṉgøtza'møtyamuse. ");
INSERT INTO zosNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ni Herodesis ja pya'tacye'tati cyoja; pues øtzcø'mdi cyø'vejvitu'que'tu. Y mi nchi'tamu'am cuenta que ni jujchepø cyoja ja itø va'cøna'ṉ ndø yaj ca'tamø. ");
INSERT INTO zosNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ma'ṉbø yac nacstøji y jetse ma'ṉbø ndzøcøpø'i. ");
INSERT INTO zosNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Porque ji'csye'c søṉnamaye tiene quena'ṉ va'cø syombø' tum preso Pilato'is. ");
INSERT INTO zosNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero mumu vøtipøn tumnajcøs vejyaju, nømyaju: ―¡Yaj ca' yøṉø, tø sombø'jatyam Barrabás! ");
INSERT INTO zosNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás somdøjupøte porque oy tu'mbøyaj pøn va'cø quipyaj cumgu'yomo, y yaj ca'oyu. ");
INSERT INTO zosNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Y Pilato'is 'yo'nøvøjøtzøc vøti pøn porque sunbana'ṉ syombø' Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero vøti pøn vejvøjøtzøcyaju nømyaju: ―¡Yac ma'møtyøj cruzcøsi! ¡Yac ma'møtyøj cruzcøsi! ");
INSERT INTO zosNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Entonces ñøjmayaj Pilato'is tu'canajcøsi: ―¿Ti'ajcuy ma yac ma'møtyøj cruzcøsi? ¿Tiyø coja chøjcu? Porque ni jujchepø cyoja ja mbya'ta'yøjtzi va'cø ø ⁿyaj ca'ø. Ma'ṉbø yac nacstøji y jetse maṉba sombø'i. ");
INSERT INTO zosNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero vejyajpana'ṉ y vya'cayajpana'ṉ va'cø mya'møtyøj cruzcøsi. Y porque jetse vejyaju ancø pønda'm y pane covi'najøta'm, Pilato'is vyø'møyu va'cø chøcø jujche syuñajuse sone pø'nis y pane covi'najø'is. ");
INSERT INTO zosNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Entonces Pilato nømu va'cø chøctøjø je'is vya'cayajuse. ");
INSERT INTO zosNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Y syombø'u pøn je'is syuñajuse lo que ijtupøna'ṉ preso'omo porque ñøtzu'ṉbapø'is quipcuy, y yaj ca'opyapø. Y chi'ocuyaj Jesús je'is syuñajuse. ");
INSERT INTO zosNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Entonces mientras nømna'ṉ ñømaṉyaj Jesús, ñucyaj Simón Cirene cumgu'yombø nømna'ṉ minupø tza'momo. Jet yaj cajpayaj cruz va' ñømaṉ Jesusis jyøsmø. ");
INSERT INTO zosNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y nømna'ṉ pya'tyaj Jesús vøti pø'nis y vøti yomo'is. Je'is cyøvo'yajpana'ṉ Jesús y cyømaya'yajpana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero Jesús que'najvitu'u y ñøjmayaju: ―Jerusalén gumgu'yomda'mbø mi yomo, uy tyø cøvo'tam øjtzi, pero mi ⁿvin cøvo'tamø y mi ⁿune cøvo'tamø. ");
INSERT INTO zosNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porque maṉba nu'c jyama cuando maṉba nømyaje: “Más contento itpa ja 'yune'øyøpø yomo, ja isøpø'is une, y ni jutipø une ja yac tzu'tzøpø'is”. ");
INSERT INTO zosNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Entonces maṉba ñømdzo'tzayaj cotzøc: “Tø cøju'møtyamø”. Y maṉba ñøjmayaj che'pø cotzøc: “Tø ju'mgøpajcøtyamø”. ");
INSERT INTO zosNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","O'ca yøcse tzøjca'yajøjtzi si fuera como tzujtzipø cusye, entonces más peor maṉba chøjcayaj eyata'mbø como tøjtzupø cusye. ");
INSERT INTO zosNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Y nømna'ṉ ñømaṉyaj Jesusji'ṉ eyapø metzcuy pøn, yatzita'mbø, va'cø yaj ca'yaj parejo Jesusji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Cuando nu'cyaj lugajromo ñøjayajpamø Ca'yajupø'is Cyo'cøpacmø, jeni mya'møyaj Jesús cruzcøsi. Y jen ma'møyajque't cruzcøs je metzcuy yatzita'mbø pøn, tum Jesusis chø'naṉ saya'omo, y eyapø Jesusis 'yaṉñay saya'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Y Jesús nømu: ―Jatay, yaj cøtocojayaj cyoja, porque ji'n myusyaj lo que ti nø chøcyajupø. Y soldado'ista'm chøjquisyaj syuerte va'cø vye'nbø'jayaj tyucu ñe'comda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Vøti pø'nista'm nømna'ṉ 'ya'myaj jeni, y aṉgui'myajpapø'is syijcayaj Jesús, nømyaju: ―Como eyapø yaj cotzocyaju, ¿ti'ajcuy ji'n mus yaj cotzoc vyin ñe'cø, o'ca Cristote, Diosis cyøpiṉupø? ");
INSERT INTO zosNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Y soldado'is jetseti syijcayajque'tu; to'møyaju y yac to'ṉyaj catzu nø'. ");
INSERT INTO zosNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Y ñøjmayaju: ―O'ca mijtzete Israel Pø'nis myøja'ṉ Aṉgui'mba, yaj cotzoc mi ⁿvin. ");
INSERT INTO zosNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Itque'tutina'ṉ cruzis cyopajcomo letra jayupø ñømbamø: “Yøṉete Israel pø'nis myøja'ṉ Aṉgui'mbata'm”. Jetse ijtuna'ṉ jayupø griego ote'omo y latín ote'omo y hebreo ote'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Y tum yatzipø pøn jendina'ṉ ma'mgue'tupø, je'is yach'o'nøy Jesús; ñøjmayu: ―O'ca mijtzete Cristo, entonces yaj cotzoc mi ⁿvin y tø yaj cotzoctam øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero tu'maṉ ma'mgue'tupø'is 'yojnay tyøvø, ñøjmayu: ―¿Mitz ti'ajcuy ji'n mi ṉgøna'tzøy Dios? Porque mitz mi itque't mismo toya'omo yøṉø pønji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Viyuṉsye øtz vøj va' tø toya'istamø porque it ndø coja; porque tø øtz tø pøjcøchondøju porque ndø tzøquipit. Pero yø'ṉis ni ti ja chøcø, ja it ni jujchepø cyoja. ");
INSERT INTO zosNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Entonces ñøjmay Jesús: ―Tø jajmutzøc øjtzi cuando minba mi aṉgui'mi. ");
INSERT INTO zosNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y Jesusis ñøjmayu: ―Viyuṉsye mi nøjmambyøjtzi, yøti maṉba mi it øtzji'n vøjpø itcu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Y paṉguc jamana'ṉete, y o pi'tzø'ajnømi mumu nascøsye'ṉomo; hasta las tresye'nomo sø'ṉnøṉgue'tu. ");
INSERT INTO zosNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jama o tu'yi, y masandøjcombø tucu vo'te 'yaṉga'mbapø'is más masanbø cuarto, jet hasta cuc tzijtzu. ");
INSERT INTO zosNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jicsye'c Jesús pømi veju y nømu: ―Jatay, mitzcøs ndza'møpyø ø ⁿespiritu. Cuando nøm jetse, ca'u. ");
INSERT INTO zosNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Y cuando capita'nis isu jujche tujcu, entonces vyøcotzøc Dios, nømu: ―Viyuṉsye yøṉ pøn vøjpø pønna'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Y mumu pøn jenna'ṉ ityajupø cuando isyaju jujche tujcuse, cucpac tzaṉba vitu'yaju maya'yajpa. ");
INSERT INTO zosNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Y mumu cyo'ispøcyajpapø'is Jesús ya'ina'ṉ ityaju y 'ya'myaju jujche nø chøctøju. Jenna'ṉ ityajque't je yomo oyajupø'is pya'tyaj Jesús Galilea nasomo tzu'ṉyajupø. ");
INSERT INTO zosNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ijtuna'ṉ tum pøn ñøyipø'is José, aṉgui'mbapøna'ṉete y vøjpø pønna'ṉete; y cyumplitzøjcupø'is Diosis syunbase. Arimatea cumgupyønete. Arimatea cumguy Judea nas co'aṉjajme'om ijtu. ");
INSERT INTO zosNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yø'ṉis ja ñøtu'mbajcajyaju eyata'mbø aṉgui'mba va'cø jujche chøcyajø. Y je Jose'is nømdina'ṉ jyo'jque'tu va'cø min 'yaṉgui'm Dios. ");
INSERT INTO zosNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Je'is cyønu'c Pilato y vya'cay Jesusis cyoṉña. ");
INSERT INTO zosNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Entonces ñømø'n cruzcøsi, y myon sabanapit y cyøjtayu tzatøjcomo. Ijtuna'ṉ møjapø tza' nojtatyøju va'cø jen cyojtøj ca'upø, pero ni itøcna'ṉ ja cyojtøj jeni, y jen cyojtay Jesusis cyoṉna. ");
INSERT INTO zosNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Je jama nømna'ṉ cyomeque'ajyaj pascua søṉ, y nømna'ṉ ñu'c sapøjcuy jama. ");
INSERT INTO zosNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Y yomota'm Jesusji'ṉna'ṉ miñajupø Galilea nasomo, maṉuti a'myajque'te, y isyaj tzatøc y jut cyojtatyøjumø Jesusis cyoṉña. ");
INSERT INTO zosNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Entonces vitu'yaju y vyøjøtzøcyaj perfume y jajsocuy (Jesusis cyoṉña va'cø jyasyaj jetpit). Y sapøcyaju sapøjcuy jama como ijtuse aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Entonces semana tzo'tzcuy jamacøsi namdzuti maṉyaj yomo tzatøcmø, y ñømaṉyaj perfume vøjøtzøcyajupøti'am, y eyata'mbø yomoji'ṉ oyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Y tza' tzatøc 'yaṉga'mupø'is pitipø'tøjupøm pya'tyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Y tøjcøyaj tzatøjcomo, pero ja pya'tyaj ndø Comi Jesusis cyoṉna. ");
INSERT INTO zosNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Entonces mientras que nømna'ṉ qui'psyaj ti va'cø chøcyajø, isyaj tome jetcø'mda'm te'ñajupø metzpøn popo sø'ṉyajpa'is tyucu. ");
INSERT INTO zosNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Por eso vøti na'chaj yomo, y japcøne'cyaj nascøsi, y pø'nis ñøjmayaj: ―¿Ti'ajcuy mi me'tztamba quenbapø pøn ityajumø ca'yajupø? ");
INSERT INTO zosNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ja itøm yø'qui; visa'u'am. Jajmundzøctam mi ñchajmatyamupø Jesusis cuando jiṉdøcna'ṉ ijtu'øc Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jesusis oy mi ñøjmandyame: “Øtz mumu Pø'nis chøṉ Tyøvø, tiene que va'cø cøt cojapa'tyajupø pø'nis cyø'omo, va'cø ma'møyaj cruzcøsi; pero tu'cay jamacøsi ma'ṉbø visa'e”. ");
INSERT INTO zosNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Entonces yomo'is jyajmutzøcyaju jujche o chame. ");
INSERT INTO zosNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Y tzu'ṉyaj tzatøcmø y maṉ chajmayaj oncepø apostoles y mumu eyata'mbø que ti isyaju y ti tzajmayajtøju. ");
INSERT INTO zosNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Y jetse chajmayaju'is apostoles, María Magdalena'isete, y Juana'is, y Jacobo'is myama Maria'is, y eyata'mbø yomo'is. ");
INSERT INTO zosNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero apostolesis cyomo'yajuna'ṉ que nømdi jyovi tzamyajupø y ja vya'ṉjamyajø. ");
INSERT INTO zosNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Entonces Pedro tzu'ṉu y popya maṉ tzatøcmø. Cuando nu'cu, atzcøne'cu, quendondøjcøy tzatøjcomo: y is sabana ne'ti cojtøjupø. Y tzu'ṉ tzatøcmø, nømna'ṉ qui'ps choco'yomo ti tujcu. ");
INSERT INTO zosNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Je mismo jama metzcuy ñøtuṉdøvø nømna'ṉ myaṉyaj tum che' cumgu'yomo ñøyipø'is Emaús. Ispana'ṉ como tu'cay legua Jerusalén gumgu'is. ");
INSERT INTO zosNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tzamdzamnepya maṉyaju, nømna'ṉ chamyaju jujche tuc Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Y mientras que nømna'ṉ chamdzamneyaju y nømna'ṉ na nø ocva'cyajtøju, mismo Jesusis tyo'møyaju y tu'mbac maṉyaj jetji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero ja yac ispøcyajø o'ca Jesusame nø myaṉu jeni. ");
INSERT INTO zosNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesusis ñøjmayaju: ―¿Ti nø mi ndzamdam mi ne'ṉgomda'm mientras que nømdi mi ⁿvijtamu, y ti'ajcuy nø mi myaya'ndamu? ");
INSERT INTO zosNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Y 'yaṉdzoṉ tumbø'is ñøyipø'is Cleofas, y ñøjmay Jesús: ―¿Será que mitz emøcpø mbyøndite y nø mi vyijtupø Jerusalén gumgu'yomo? ¿Será que unico mitz ji'n mi musi ti tujcupø jeni yøṉ jama'omo? ");
INSERT INTO zosNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Y ñøjmayaj Jesusis: ―¿Y tiyø tujcupø? Y je'is ñøjmayaju: ―¿Ji'na mi musi jujche o tuc Jesús Nazaret cumgu'yombø? Porque jet tza'maṉvajcopapøna'ṉete, y muspana'ṉ chøc milagro'ajcuy, muspana'ṉ 'yaṉma'yoy vøjø Diosis vyi'naṉdøjqui y mumu pø'nis vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero pane covi'najø'is y aṉgui'myajpapø'is øjtzi, je'is chi'ocuyaj Jesús va'cø yaj ca'tøjø, y yaj ca'yaj cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pero øtz contento ṉgui'pstambana'ṉtzi que je'is maṉba yaj cotzoc Israel cumguy. Y ji'n na's jetse, sino ta'nu'am yøti tu'cay jama jetse tujcumø; ");
INSERT INTO zosNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","y veneta'mbø yomo'is tø øjtzomda'mbø'is tø tzam maya'tamu. Porque oyaj tzatøcmø nømna'ṉ syø'ṉbø'nømu'øc, ");
INSERT INTO zosNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pero ja pya'tayaja'm jeni Jesusis cyoṉna. Pero min nømyaje que yac isyajtøj angeles, y je angelesis ñøjmayaju que Jesús quenbati. ");
INSERT INTO zosNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Y maṉyaj eyata'mbø ndø tøvø tzatøcmø, maṉ 'ya'myaje, y jetse pya'tyaju jujche yomo'is chajmayajuse, pero ja isyajque'tati Jesús. ");
INSERT INTO zosNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Entonces Jesusis ñøjmayaj metzpøn: ―ⁿJyovinda'mbø mijtzi y peñapit mi va'ṉjajmdamba mumu lo que ya'møcpø tza'maṉvajcopyapø'is chamyajuse. ");
INSERT INTO zosNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ti'ajcuy ji'n mi ṉchi'tam cuenta que pyenate va'cø toya'is Cristo jetse va'cø tyøjcøy myøja'ṉajcu'yomo? ");
INSERT INTO zosNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Entonces Jesusis cha'maṉvajcayaj mumu Diosis 'yote jachø'yuse jujche maṉba tuc ñe'cø. Cha'maṉvactzo'tz Moisesis jyachø'yuse, entonces mumu tza'maṉvajcoyajpapø'is jyachø'yajuse jetseti cha'maṉvajque'tu. ");
INSERT INTO zosNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Y nu'cyaj che' cumgu'yomo jujna'ṉ nø myaṉyajumø. Y Jesusis chøc vyin como si fuera maṉbana'ṉ syeguitzøc tyuṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero je'is pyenatzøcyaju va'cø chø'yø, ñøjmayaju: ―Yø'c tzø'y øtzji'ṉdam, porque nøm cha'i'ajnøm y cøjtum jama. Jesús jicsye'cti tøjcøyu va' tzø'y jetji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Entonces mientras que jenna'ṉ po'csyaju mesacø'mø jetji'ṉda'm, Jesusis pyøc pan y ñøjay Dios yøscøtoya y vyenu y chi'yaju. ");
INSERT INTO zosNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jicsye'cti tzi'yajtøj qui'psocuy va'cø ispøcyaj Jesús, pero misma hora iscøtocoyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Y na ñøjmayajtøju: ―Viyuṉsye tø tzi'ṉbø'tam ndø tzococ'yomo mientras que tu'ṉomo nømna'ṉ tø o'nøtyamu y tø tza'maṉvajcatyam Diosis 'yote jachø'yuse. ");
INSERT INTO zosNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Misma jic hora tzu'ṉyaju y vitu'yaj Jerusalén gumgu'yomo. Jiṉø pya'tyaj tu'myajupø oncepø apostoles y jenna'ṉ ityajque't eyata'mbø tu'myajupø jetji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Y tu'myajupø'is ñøjmayaju nø ñu'cyajupø: ―Viyuṉsye visa' ndø Comi y yac isu'am vyin Simón. ");
INSERT INTO zosNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Entonces vitu'yajque'tupø'is chajmayaju jujche tucyaj tu'ṉomo, y chajmayaj jujche ispøcyaj Jesús nø vyenu'c pan. ");
INSERT INTO zosNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Y mientras que ñømdøc ñøvejvejneyaju'øc jejta'm yøcsepø ticøsi, mismo ñe'c Jesús te'n cujcomo y ñøjmayaju: ―Contento ijtamø. ");
INSERT INTO zosNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Entonces jejta'm na'chaju y o'ca jujchese tucyaju, cyomo'yaju o'ca anima nø isyaju. ");
INSERT INTO zosNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero Jesusis ñøjmayaju: ―¿Ticøtoya o'ca jujchese mi ñdyuctamba, y ticøtoya it ti mi mbensatzøctam mi ndzoco'yomda'm? ");
INSERT INTO zosNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","A'mistam ø ṉgø' y ø ṉgoso, que øjti chøṉø. Tø pi'quistam ndøvø y tø a'mdamø que øtz it ø sis, it ø mbac, porque anima ja syisøyø, ja pyajcøyø como mi ndø istamuse. ");
INSERT INTO zosNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Y ñøjmayaju'cam jetse, isindzi'yaj cyø' y cyoso. ");
INSERT INTO zosNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Y tanto que casøyaju y qui'psyaju o'ca ji'quete, ji'ndyet jicø; ji'ndøcna'ṉ vya'ṉjamyaj seguro o'ca jiquete. Mientras jetse qui'psyaju, Jesusis ñøjmayaju: ―¿Ijtuja yø'c ti va'cø ndø cu'jtamø? ");
INSERT INTO zosNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Entonces apostolesis chi'yaj Jesús coque ja'se y tum bomna tzinuj. ");
INSERT INTO zosNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesusis pyøjcu y vi'c je'tis vyi'naṉdøjquita'm. ");
INSERT INTO zosNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Y ñøjmayaju: ―Cuando mitzji'ṉna'ṉ ø ijtu'ctzi, yøcse o'yø mi ndzajmatyame: que pyenate va'cø tyuc øtzcøsi mumu tiyø jujche Moisesis jyachø'yuse, y como jujche jyachø'yajuse tza'maṉvajcoyajpapø'is, y como ijtu jachø'yuse Salmos libru'omo. ");
INSERT INTO zosNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Entonces Jesusis yac mijnayaj qui'psocuy va'cø cyønøctøyøyaj jachø'yuse Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Y ñøjmayaju: ―Yø'cse jachø'yupø que pyenate va'cø toya'is Cristo y va'cø cya'ø y va'cø visa' tu'cay jamapit. ");
INSERT INTO zosNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Y va'cø chamgøpucstøj mumu pø'nomo va'cø qui'psvitu'yajø va'cø yaj cotocojayaj cyoja Cristo'is ñøyicøsi; jetse va'cø chamgøpucstzo'tztøjø Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Y mitzta'm mi ṉgotestigosajtamba yø'cseta'mbø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tzøctam cuenda que ø Janda'is prometetzøjcupø tiyø, jet øtz ma'ṉbø ṉgø'vej mitzcøsta'm. Pero mitz jo'ctam Jerusalén gumgu'yomo hasta que mi mbøjcøchoṉdamba musocuy tzajpombø ndø Janda Diosis mi nchi'tambapø. ");
INSERT INTO zosNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Entonces Jesusis ñømaṉyaj apostoles tzu'ṉyaj Jerusalén gumgu'yomo hasta que maṉyaj Betania cumgu'yomo. Y jen yøcte'n cyø' y cyømasa'nøyaju apostoles. ");
INSERT INTO zosNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Y tujcu que nømna'ṉ cyømasa'nøyaju'øc Jesusis apostoles, entonces tzu'ṉ Jesús jetcø'mda'm, y nømaṉdøj tzajpomo. ");
INSERT INTO zosNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Apostolesis cyøna'tzøyaj Jesús y casøcomø'ñaju mientras vitu'yaj Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Y mumu jama tzø'yaj masandøjcomo, nømna'ṉ vyøcotzøcyaj Dios y nømna'ṉ myøja'ṉomgotzøcyaj Dios. Amén.");
INSERT INTO zosNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tzo'tzcu'yomo na ijtutina'ṉ Ote; y je Ote Diosji'ṉbøte, y jic Ote Diostitque't. ");
INSERT INTO zosNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Así es que tzo'tzcu'yomo Diosji'ṉ ijtu je Ote. ");
INSERT INTO zosNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jic Oteji'ṉ tuc aunque tiyø. O'ca ji'na'ṉ jetji'ṉ, ni tina'ṉ ji'n tyuqui. ");
INSERT INTO zosNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ñe'c na quenba de por si, y je'is yac itpa aunque ti quenbapø. Y va'cø tø quena, es como sø'ṉgø pøngøtoya va'cø cyøsø'ṉøjay pø'nis chocoy. ");
INSERT INTO zosNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Como pi'tzø'ajcu'yomo minba tum sø'ṉgø, jetse min ñe'cø va'cø tø tzi' vøjpø qui'psocuy. Y como pi'tzø'ajcu'is ji'n mus yac tu'yi sø'ṉgø, jetsetique't yatzipø'is ji'n mus ya'induc Diosis 'Yote. ");
INSERT INTO zosNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ijtuna'ṉ pøn Diosis cyø'vejupø; pø'nis ñøyi Juan. ");
INSERT INTO zosNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juan minu va'cø cha'maṉvac que maṉba min cøsø'ṉøjapyapø'is ndø tzocoy. Je'is cyøsø'ṉøjayajpa mumu pø'nis chocoy va'cø vya'ṉjamyaj Dios. ");
INSERT INTO zosNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ji'ndyet ñe'c Juan cyøsø'ṉøjapyapø'is chocoy, sino Juan minu va'cø chajmayø que maṉba min eyapø cyøsø'ṉøjayajpa'is pø'nis chocoy. ");
INSERT INTO zosNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jic viyuṉsyepø sø'ṉgøte; je'is cyøsø'ṉøjayajpa aunque i'is chocoy. Jic viyuṉsyepø sø'ṉgø minu nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nascøsna'ṉ ijtu je Ote, y Diosis jyomec nasacopac 'Yoteji'ṉ; pero nascøspø pønis ja cyomusyaj je Ote. ");
INSERT INTO zosNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Minu ñe'c jyomejcupø'omo, pero cyumgutyøvø'is ja pyøjcøchoṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero veneta'mbø'is pyøjcøchoṉyajuti, y vya'ṉjamyaju que jicø Diosis cyø'vejupø; entonces ñø'ijtu aṉgui'mguy va'cø Diosis 'yune'ajø jic pøn vya'ṉjamyajupø'is. ");
INSERT INTO zosNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Y jetse pø'najyajpa Diosis fyamilia'omo, pero ji'ndyet porque ijtu'aṉcø jyata y myama sispø y ñø'pinbø, ni ji'ndyet porque pø'nis jetse sunba aṉcø, sino Diosis jetse yac pø'najyajpa. ");
INSERT INTO zosNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","También Diosis 'Yote sispø pøn tujcu y oy it tø øtzji'ṉda'm, y ista'm øjtzi myøja'ṉo'majcuy jujche ndø Janda Diosis yac møja'ṉo'majpa tumbø 'Yune. Jet viyuṉdzambapøte y vøti syunba aunque iyø. ");
INSERT INTO zosNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jua'nis cha'maṉvac iyete minupø, nømu: ―Yøṉete mi ndzajmatyamu que maṉba mini; o'yø mi nøjandyame: “Más jøsi'cam maṉba min pøn más myøja'ṉombø que ji'n øjtzi; porque de por si na ijtuti antes que øjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ñe'ete aunque tiyø, y tø tzi'u'am aunque tiyø ñe' vyø'ajcupit, y más tø tzi'a'ṉøpya vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Porque Moisés chi' aṉgui'mguy Diosis va'cø ndø yaj coputø, pero Jesucristo cyø'vej Diosis va'cø min tø toya'ṉøyø, y va'cø cha'maṉvac viyuṉsepø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni jujchøc ja is Dios ni i'is. Pero tø'cs tumbø 'Yune vøti syunba Diosis, y jete 'Yune tumø'om ijtu Jyata Diosji'ṉ, y je'is min cha'maṉvac jujchepøt Dios. ");
INSERT INTO zosNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Entonces Israel pø'nis cyø'vejyaj pane y eyata'mbø masandøjcom yosyajpapø va'cø 'yo'nøyaj Juan. Tzu'ṉyaj Jerusalén gumgu'yomo y nu'cyaj Juan ijtumø. 'Yaṉgøva'cyaj Juan ñøjayaju: ―¿ⁿIye mijtzi? ");
INSERT INTO zosNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jua'nis viyuṉdzajmayaju, ñøjayaju: ―Øtz ji'n chøṉ Cristo jicø Diosis maṉbapø cyø'veje. ");
INSERT INTO zosNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Entonces 'yaṉgøva'cyajque'tu: ―O'ca mitz ji'ndyet mi jiṉgø, ¿entonces será que mitzømacsque't Eliaspø? Y Jua'nis ñøjayaju: ―Ni øtz ji'n chøṉ Elías. Y ñøjayajque'tu: ―Bueno, ¿entonces será que mijtzømacsque't jic tza'maṉvajcopapø ndø ⁿjo'ctambapø? Y ñøjayaju: ―Ni øtz ji'n chøṉ jicø. ");
INSERT INTO zosNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Y pø'nis ñøjayaj Juan: ―Pues tø tzajmatyam ndøvø ⁿiye mijtzi, va'cø mus ndzajmayajque'ta øtz cø'vejyajupø'is øjtzi. ¿Ti mi ndzamba? ");
INSERT INTO zosNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jua'nis ñøjayaju: ―Øtz pømi vejpøjtzi jya'ijnømømø, nø'mbøjtzi: “Jujche ndø vøjøndzøctamba tuṉ cuando maṉba min møja'ṉ aṉgui'mbapø, jetse vøjøtzøctam mi ndzocoy porque maṉba min ndø Comi”. Jetse nømu tza'maṉvajcopyapø Isaías, y jetse nømgue'tpa øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Y cyø'vejyajupø oyu'is 'yo'nøy Juan, fariseo'is vya'ṉjajmocuy tyøvø'sta'm cyø'vejyaju. ");
INSERT INTO zosNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Y 'yaṉgøva'cyaju ñøjayaj Juan: ―¿Ti'ajcuy mi ñø'yø'ombya o'ca mitz ni ji'ndyet mi Cristo Diosis maṉbapø cyø'veje, ni ji'ndyet mi Elías, ni ji'ndyet mi jic tza'maṉvajcopyapø? ");
INSERT INTO zosNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jua'nis ñøjayaju: ―Øtz nø'yø'opyøjtzi nø'ji'ṉ, pero ijtu'am tum pøn mijtzomda'm mitz ji'n mi ispøctamepø. ");
INSERT INTO zosNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jicø jøsmøti minu, pero más myøja'ṉombø que øjtzi. Øtz ji'nchø ni tiyø je'is vyi'naṉdøjqui, ni øtz ji'n mus ndzøc nu'csocuy jic pøngøtoya porque myøja'ṉombøte y syunba más vøjpø pøn que øjtzi va'cø chøjcay nu'csocuy. ");
INSERT INTO zosNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jetse tujcu Jordán nø'cøtu'maṉ tum cumgu'yomo ñøyipø'is Betábara, jiṉ oy nø'yø'oy Juan. ");
INSERT INTO zosNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jyo'pit Jua'nis is Jesús nø minupø jetcømø y Juan nømu: ―A'mdamø pøn Diosis cyø'vejupø va'cø cya'ø. Jujche tum borrego yaj ca'tøjpase pø'nis cyojacøtoya, jetse jic maṉba ca'e va'cø yac tzu'ṉayaj mumu nascøsta'mbø pø'nis cyoja. ");
INSERT INTO zosNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yøṉømtzø ndzamupø que maṉba mini, nø'møjtzi: “Øtz vi'na mi'nøjtzi y jøsi'cam minba eyapø lo que más myøja'ṉombø, porque jet na ijtutina'ṉ antes que øjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Y øtz ji'na'ṉø musi iyete Cristo, pero mi'nøjtzi va'cø nø'yø'oy nø'ji'ṉ va'cø ispøcyaj Israel pø'nista'm que jiquete. ");
INSERT INTO zosNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jua'nis chamu jujche isuse. Nømu: ―ⁿIsøjtzi Masanbø Espiritu tzajpom tzu'ṉupø y nø myø'nupø como palomase y jetcøs te'ngøne'cu y jen tzø'yu. ");
INSERT INTO zosNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Y ji'ndøcna'ṉø ṉgomusi iyete, pero oyupø'is ø cø'veje va'cø nø'yø'oya nø'ji'ṉ, je'is nøja'yøjtzi: “Cuando mi ispa Masanbø Espiritu nø myø'nupø pøngøsi y jetcøs nø chø'yupø, entonces maṉba mi musi que jiquete nø'yø'opyapø Masanbø Espirituji'ṉ”. ");
INSERT INTO zosNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Pues jet o'm isi y muspa ndzam viyuṉse que jicømete Diosis 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jyo'pit jendina'ṉ te'nque't Juan y jendi te'ñajque't metzcuy Jua'nis ñøtuṉdøvø. ");
INSERT INTO zosNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Y Jua'nis cyøque'nøy Jesús jen nø vyijtupø, y nømu: ―Jic pønamete Diosis cyø'vejupø va'cø cya' como borrego ca'pase ndø cojacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Y metzcupø ñøtuṉdøvø'is myañaju jujche nø ñøm Juan, y maṉ pya'tyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús que'najtonvitu' jyøsmø y joviti isyaj metzcuy pøn nø myacyajupø'is y Jesusis ñøjayaju: ―¿Ti nø mi ⁿme'tztamu? Pø'nis ñøjayaj Jesús: ―Rabí, ¿jut mi ⁿijtu? ―Je'is 'yote'omo ñøjayajpa Rabí, pero ndø nøjandyamba ndø ote'omo aṉma'yopyapø. ");
INSERT INTO zosNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesusis ñøjayaju: ―Tø maṉdya'i, maṉba mi isindzi'tame ju'tø it øjtzi. Y maṉyaju isyaju jutø ijtumø ndø Comi y jiṉ tzø'yaj tyumø'om ndø Comiji'ṉ jic jamacøsi porque tza'imna'ṉ como las cuatrose'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tum myanupø'is Jua'nis nø chamupø y maṉu'is pya't Jesús ñøyi Andrés, Simón Pedro'is tyøvø, tumbø jatacøs tzu'ṉupø. ");
INSERT INTO zosNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Vi'na Andresis maṉ mye'tz tyøvø Simón y ñøjayu: ―ⁿIsta'møjtzi Mesías ―Mesías ndø nøjandyaṉgue'tpa Cristo. ");
INSERT INTO zosNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andresis ñømin Simón ijtumø Jesús. Jesusis cyøque'nøy Simón y ñøjayu: ―Mijtzete Simón, Jonasis mi 'yune, pero maṉba mi nøyi'aj yøti Cefas ―yøṉ nøyi Cefas putque'tpati ndø onde'omo Pedro. ");
INSERT INTO zosNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jyo'pit Jesús nømna'ṉ myaṉdo'u Galilea nasomo. Y oy mye'tz Felipe y ñøjayu: ―Ma tø pa'tø. ");
INSERT INTO zosNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe Betsaida cumgupyønete y Andrés y Pedro jiṉda'mbøna'ṉetque't. ");
INSERT INTO zosNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe'is oy mye'tz Natanael y ñøjayu: ―ⁿIsta'møjtzi pøn lo que Moisesis oyupø jyaye mapø mini. Aṉgui'mguy libru'omo ijtu jachø'yu, jetseti jyayajque'tuti tza'maṉvajcoyajpapø'is. Jic pøn minu'am, ñøyipø'is Jesús Nazaret cumgupyøn, y jic Jesús Jose'is 'yune. ");
INSERT INTO zosNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Entonces Natanaejlis ñøjayu: ―¿Será vøjpø pønacsque't o'ca minupø Nazaret cumgu'yomo? Porque puro yatzita'mbø ityaj jiṉø. Felipe'is ñøjayu: ―Tø ma'i, ma ndø a'mista'i. ");
INSERT INTO zosNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesusis is Natanael nø minupø y nømu: ―Jic nø minupø jic viyuṉsepø Israel pøn, je'tis ji'n ma chøc aṉgøma'cø'ocuy. ");
INSERT INTO zosNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaejlis ñøjay Jesús: ―¿Jujche mi ndø ispøjcu? Jesusis 'yaṉdzoṉu ñøjayu: ―Antes que oyutøc mi mye'ndze Felipe'is, cuando higo cu'yucø'mø mi ⁿijtu'øc, mi ⁿisøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaejlis ñøjay Jesús: ―Maestro, mijtzete Diosis mi 'Yune. Mijtzete Israel pø'nis 'Yaṉgui'mbata'm. ");
INSERT INTO zosNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Pero Jesusis ñøjay Natanael: ―Mi ndø va'ṉjajmba porque nø'ø mi ⁿnøjayu que mi ⁿispøc øjtzi higo cu'yucø'mø mi ⁿijtu'øc; pero más maya'cuseta'mbø tiyø maṉbatøc mi ⁿisi. ");
INSERT INTO zosNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Y Jesusis ñøjacye'tu: ―Viyuṉsye mi nøjambya øjtzi, jøsi'cam maṉba mi ⁿistam tzap aṉvajcu, y Diosis 'yangeles nø qui'myajupø y nø myø'ñajupø øtzcø'mø, øtz mumu pø'nis chøṉ tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tu'cay jamapit oy co'tøjcajcuy Caná cumgu'yomo Galilea nasomo. Y Jesusis myama jiṉdina'ṉ itque'tu. ");
INSERT INTO zosNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Y Jesús mye'chajtøju ñøtuṉdøvøji'ṉ va'cø myaṉyaj nø cyo'tøjcajnømumø. ");
INSERT INTO zosNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Y cuando jendina'ṉ ityaju, cøyajøyaj vinuji'ṉ. Entonces myama'is ñøjay Jesús: ―Cøyajøyaju'am vinuji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesusis ñøjayu: ―Tzamyomo, ¿ticøtoya mi ndø ñøjambya jetze? Ja ñu'cøtøc ø hora va'cø yoscho'tza. ");
INSERT INTO zosNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesusis myama'is ñøjayaj jen nø yosyaju: ―Tzøctamø lo que mi ñøjandyamba je'is. ");
INSERT INTO zosNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pues ijtuna'ṉ jen tujta'y tza'pø nø'po'cscuy porque jetse ijtuna'ṉ Israel pø'nis cyostumbre va'cø cyøtze'yaj vyin ijtuse vya'ṉjajmocuy. Tøjcøpana'ṉ ochenta o cien litrota'm nø' tumdum nø'po'cscu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesusis ñøjayaj jen yosyajpapø: ―Jojøtyam nø'ji'ṉ nø'po'cscuy. Y jyojøyaju hasta suñi taspacse'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Y Jesusis ñøjayajque'tu: ―Yøti cøtzpujtatyam usyøc y ma tzi' søṉgovi'najø va'cø tyo'ṉisø. Y jetse chøcyaju. ");
INSERT INTO zosNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Entonces søṉgovi'najø'is tyo'ṉis nø', pero vinu'aju'camete nø', y ji'na'ṉ myusi jut ñøtzu'ṉyaju, sólo jen nø yosyajupø'is oyu'is cyøtzputyaj nø', je'is myusyaju jut pyøcyaju. Entonces søṉgovi'najø'is ñøvej pøn maṉbapø co'tøjcaje, ");
INSERT INTO zosNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","y ñøjayu: ―Mumu pønis vi'na syajyajpa vøjpø vinu y después cuando veneta'mbø'is tyo'ṉyaju'am vøti, syajyajpa corrientepø. Pero mitz mi aṉne'ṉgu más vøjpø hasta yøticse'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yøṉ vindzøjcu milagro'ajcuy Jesusis Caná cumgu'yomo Galilea nasomo. Y jetse isindzi'yaju que myøja'ṉombø pønete, y vya'ṉjamyaju ñøtuṉdøvø'is que Cristote. ");
INSERT INTO zosNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jøsi'cam Jesús maṉu Capernaum gumgu'yomo y maṉyajque'tuti Jesusis myama y myuqui y ñøtuṉdøvøta'm, y jiṉ oy tzø'yaje jujche jamatiyø. ");
INSERT INTO zosNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nømna'ṉ tyome'aju Israel pø'nis syø'ṉda'm ñøyipø'is pascua. Y Jesús maṉ Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Y Jesusis is masandøjcomo solajromo nø mya'ayaju'is vacas y borrego y paloma, y jen nømna'ṉ pyo'csyaj cyacpø'yajpa'is tumin. ");
INSERT INTO zosNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Y cayita'mbø tzayji'ṉ Jesusis chøc nacsocuy y nacsputyaj mumu masandøjcomo solajromo. Nacsputputvøyaj borrego y vacas parejo cyomiji'ṉ, y titpø'jayaj tyumin nasomo cyacpø'yajpapø'is ñe, y myatztonguejcayaj myesa. ");
INSERT INTO zosNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Y ñøjayaj nø mya'ayaju'is paloma: ―Nøputyaj yøṉø a'ṉgomo. Uy mi yac yosatyam ø Janda'is tyøc va'cø min mi mya'aṉgojtam yø'qui. ");
INSERT INTO zosNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Entonces ñøtuṉdøvø'is min jyajmemiñaje jachø'yupøte. Nømba: “Hasta topya ø ndzocoy porque sungo'nbøjtzi va'cø it vøjpø tiyø mi ndøjcomo”. ");
INSERT INTO zosNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pero Israel pø'nista'm ñøjayaj Jesús: ―¿Tiyø milagro'ajcuy mi ndø yac istamba va'cø ndø mustamø o'ca it mi aṉgui'mguy va'cø mi ndzøc jujche mi ndzøcpase? ");
INSERT INTO zosNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesusis 'yaṉdzoṉyaju ñøjayaju: ―O'ca mitz ⁿyajtamba yøṉ masandøc, tu'cay jamapit øtz ma'ṉbø ndzøcvøjøtzøqui. ");
INSERT INTO zosNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Entonces Israel pø'nis ñøjayaj Jesús: ―Cuarenta y seis ame ñømaṉu va'cø chøctøj yøṉ masandøc, ¿jutznøm maṉba mi ⁿyac tuc tu'cay jamacøsi? ");
INSERT INTO zosNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Masandøc nø chamu, pero ji'n mero masandøc, sino ñe' syisete como si fuera masandøc. ");
INSERT INTO zosNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Cuando Jesús visa'ujcam después que ca'ujcam, entonces ñøtuṉdøvø'is jyajme miñaju que jetse oyuse ñøjayaje y vya'ṉjamyaju ijtuse jachø'yupø totocøsi y vya'ṉjamyajque'tu jujche chamuse Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Y Jesús Jerusalén gumgu'yomna'ṉ ijtu'øc cuando pascua søṉ nø cyosø'ṉajtøju'øc. Itco'ñajuna'ṉ vya'ṉjamyaju'is Jesús porque isyaju aṉcø milagro'ajcuy nø chøjcupø. ");
INSERT INTO zosNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Jesusis ji'na'ṉ vya'ṉjamyaj pøn o'ca de veras nøme vya'ṉjamyajupø, porque Jesusis cyomusyajpa mumu pøn jujcheta'm qui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ji'ndyet pyena va'cø chajmatyøjø jujche pø'nis qui'psocutya'm porque ñe'c Jesusis myusayajpa mumu pø'nis chocoy. ");
INSERT INTO zosNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ijtuna'ṉ tum pøn ñøyipø'is Nicodemo, fariseo'is vya'ṉjajmocuy ñø'ijtayupø'is, y Israel pøn aṉgui'mbate. ");
INSERT INTO zosNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Je'is cyønu'c Jesús tzu'ijcam y ñøjayu: ―Maestro, musta'mbøjtzi que Diosis mi ṉgyø'veju va'cø min mi 'yaṉma'yoya, porque ni jutipø pø'nis ji'n mus chøc milagro'ajcuy jujche mitz ndzøcpase mientras que ji'n cyotzoṉ Diosis. ");
INSERT INTO zosNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesusis 'yaṉdzoṉu ñøjayu: ―Viyuṉse mi ñøjambyøjtzi; o'ca tum pøn ji'n pyø'najvøjøtzøqui, nunca ji'n mus isay Diosis itcuy. ");
INSERT INTO zosNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo'is ñøjayu Jesús: ―¿Pero jutz nømø muspa pø'najvøjøtzøc pøn cuando tzambønbø'am? Ji'nam jutznøm mus vøco tøjcøcye't myama'omo va'cø vyøco pø'najque'ta. ");
INSERT INTO zosNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Y Jesusis ñøjayu: ―Viyuṉse mi nøja'mbyøjtzi, o'ca tum pøn ji'n pyø'naj nø'ji'ṉ y Espirituji'ṉ, ji'n mus tøjcøy Diosis itcu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lo que yac pø'najupø sispø'is, sispøte, y lo que yac pø'najupø Espiritu'is, espiritupøte. ");
INSERT INTO zosNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","U mi myaya'u porque nø mi nøjayu aṉcø tiene que va'cø mi vyøṉgopø'najø. ");
INSERT INTO zosNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Porque sava yø'qui jeni pominba pomyaṉba y mitz mi manba nø 'ya'ṉøyupø, pero ji'n mi musi juti nø chu'ṉu jut nø mya'ṉøyu. Jetsetique't mumu pøn Masanbø Espiritu Santo'is yac pø'najupø. ");
INSERT INTO zosNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Entonces Nicodemo'is ñøjay Jesús: ―¿Jujche muspa tuc yøṉø? ");
INSERT INTO zosNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Y Jesusis ñøjay Nicodemo: ―Mitz mi aṉmayajpapøte Israel pønda'm. ¿Ti'ajcuy ji'n mi ṉgomusi yøcsepø tiyø? ");
INSERT INTO zosNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Viyuṉse mi nøja'mbyøjtzi, ndzamda'mbøjtzi lo que muspacse'ṉomo, y lo que ista'mbøjtzi, ṉgotestigosajta'mbøjtzi. Pero mitz ji'n mi ndø va'ṉjamdame lo que øtz mi ndzajmatyambase. ");
INSERT INTO zosNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","O'ca øtz mi ndza'maṉvajcatya'mbøjtzi jujche ijtuse nascøsi, y ji'n mi ndø va'ṉjamdame, ¿entonces jujche maṉba mi ndø va'ṉjamdame o'ca mi ndza'maṉvajcatya'mbøjtzi jujche ijtuse tzajpomo? ");
INSERT INTO zosNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","”Ni itøc ja oy qui'm tzajpomo, sino øjtzi. Mø'nøjtzi tzajpom tzu'ṉupø'tzi øtz mumu Pø'nis chøṉ Tyøvø, y tzajpom chøṉ ijtupø. ");
INSERT INTO zosNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jujche Moisesis yaj qui'm tzan cucyøsi tøtzø nasomo, jetse tiene que øtz va'cø yaj nøqui'mdøjque't øjtzi cruzcøsi, øtz mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Jetse o'ca aunque ipø pø'nis va'ṉjajmbøjtzi, ji'n maṉ tocoye, sino maṉba quen mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","”Porque Diosis algo syuñaj nascøsta'mbø pøn, y por eso tzi'ocuyaj øjtzi tumbø 'Yuneti chøṉø, va'cø jana tocoy ni iyø o'ca va'ṉjamba øjtzi, sino maṉba quen mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Porque Diosis cø'vej øjtzi nascøsi ñe'c 'Yune chøṉø va'cø yaj cotzocyaj nascøsta'mbø pøn, ni ji'ntze va'cø maṉ yac tocoyajø. ");
INSERT INTO zosNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","”Va'ṉjambapø'stzi, ni i'is ji'n mus maṉ yaj coja'ajø, pero ji'n vya'ṉjamepø'stzi yaj coja'ajtøju'am, porque ja vya'ṉjajmøjtzi Diosis chøṉ tumbø 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Øtz mi'nøjtzi nascøsi como sø'ṉgø va'cø ṉgøsø'ṉøjay pø'nis chocoy, pero pø'nista'm más syuñaj pi'tzø'ajcuy que ji'n sø'ṉgø va'cø jana cyeja que nø chøcyaj yatzitzoco'yajcuy, y por eso maṉba yaj coja'ajyaj Diosis. ");
INSERT INTO zosNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Porque chøcpapø'is yatzipø tiyø ji'n maṉ syun sø'ṉgø, ni ji'n mini sø'ṉgø'omo va'cø jana istøj yatzipø tiyø lo que chøcyajpapø. ");
INSERT INTO zosNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero chøcpapø'is vøjpø tiyø minba sø'ṉgø'omo va'cø istøjø que nø chøc Diosji'ṉ lo que nø chøjcupø. ");
INSERT INTO zosNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jøsijcam Jesús ñøtuṉdøvøji'ṉ maṉyaj parejo Judea nasomo. Jiṉ Jesús oy it usya'ṉ hora ñøtuṉdøvøji'ṉ y nø'yø'yoyu. ");
INSERT INTO zosNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Y Juan nømna'ṉ nø'yø'yocye'tu Enón gumgu'yomo, tome Salim gumguy, porque jiṉø ijtuna'ṉ yø'qui jeni nø'. Pøn miñajpana'ṉ y Jua'nis ñø'yøyajpana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jetse chøc Jua'nis antes que ja octøc somdøji. ");
INSERT INTO zosNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Y Jua'nis ñøtuṉdøvø'is ñø'onguipyaj Israel pøn que jujche ndø cøtze'pa ndø vin como seña que ndø cøvajcøyu'am Diosis vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Y cyønu'cyaju Juan y ñøjayaju: ―Maestro, jic pøn lo que ijtupøna'ṉ mitzji'ṉ Jordán nø'cøtu'maṉ y mitz oy mi ndzam iyete, jic pøn nø'yø'yopya y nu'cyajpa vøti pøn jijcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jua'nis 'yaṉdzoṉyaj ñøjayaju: ―Ni i'is ji'n mus ñø'it ni ti aṉgui'mguy mientras Diosis ji'n maṉ chi'i. ");
INSERT INTO zosNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mitz mi ne'c mi mandamu lo que øtz nø'møjtzi, øtz ji'n chøṉ Cristo. Pero øtz vi'na cø'vejøjtzi antes que minba Cristo. ");
INSERT INTO zosNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Es como cuando itpa co'tøjcajcuy; it tum pøn maṉba'is pyøc yomo, y itque't je'is 'yamigo tome nø tye'nu y nø myajnay 'yote, y 'yamigo'is cyøcasøpya vøti cuando myanba nø vyejvejneyu pøn maṉbapø co'tøjcaje. Jetse øtz ṉgøcasøcyomø'ngue'tuti'tzi cuando ma'nbøjtzi je'is 'yote. ");
INSERT INTO zosNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jet tiene que va'cø más myøja'ṉomajø, y øtz menosomdi maṉba tzø'yi. ");
INSERT INTO zosNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","It tum minupø møji tzu'ṉupø. Jet mase myøja'ṉombø que ni jutipø pøn. Nascøs tzu'ṉupø pøn nascøspøte y nascøspø tiyø maṉba chame. Pero tzajpom tzu'ṉupø más myøja'ṉombø que ni jutipø pøn. ");
INSERT INTO zosNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Lo que jujche isu, lo que jujche myanupø, jetseti chamgue'tpa. Pero ni i'is ji'n vya'ṉjajmaye lo que ti nø cha'maṉvajcupø. ");
INSERT INTO zosNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","O'ca i'is vya'ṉjajmapya tiyø nø cha'maṉvajcupø, entonces viyuṉgotzøcpa lo que Diosis chamba. ");
INSERT INTO zosNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Lo que Diosis cyø'vejupø, je'is cha'maṉvajcapya Diosis 'yote, porque Diosis chi'pa más vøti 'Yespiritu. ");
INSERT INTO zosNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ndø Janda Diosis syunba 'Yune, por eso chi' aṉgui'mguy mumu ticøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Vya'ṉjambapø'is Diosis 'Yune, pya'tpa vøjpø itcuy mumu jamacøtoya; y ji'n vya'ṉjamepø'is Diosis 'Yune ji'n maṉ quene, sino que Dios maṉba qui'sca'e y maṉba cyastigatzøc tumø najcøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ndø Comi'is myusu que fariseo va'ṉjajmocuy ñø'ijtupø'is myañaju que masti ñe'c ndø Comi cyøtu'myaju va'cø 'yaṉmayajø y va'cø ñø'yøyajø y Juan masti usyaṉ cyøtu'myaju. ");
INSERT INTO zosNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero mismo ñe'c Jesús ja ñø'yø'yoya, sino Jesusis ñøtuṉdøvø nø'yø'yoyaju. Entonces cuando Jesusis myusu que jetse chamyaju fariseo'is que jete más cyøtu'myaju, ");
INSERT INTO zosNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","entonces tzu'ṉ Jesús Judea nasomo va'cø myaṉ Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Y tiene que va'cø cyøjtay Samaria cumgu'is ñasomo. ");
INSERT INTO zosNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Cuando nømna'ṉ cyøtyaj Samaria cumgu'is ñasomo, nu'cyaj tum cumgu'yomo ñøyipø'is Sicar. Sicar cumguy tome ispa nas co'aṉjajme Jacojbis chi'u 'yune José ya'møc. ");
INSERT INTO zosNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jendi ijtu nø'chatøc ñøjmayajpapø Jacojbis ñø'chatøc. Pues como Jesús nitu'yu va'cø tyu'ṉajø, po'cschø'y nø'chatøjcaṉvini tome paṉguc jamase'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mientras jen po'csu, min nø'pøqui tum Samaria nasombø yomo. Jesusis ñøjay yomo: ―Tø va'ctzi' usøc nø'. ");
INSERT INTO zosNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Pero mientras jetse tujcu, Jesusis ñøtuṉdøvøta'm maṉyajumna'ṉ cumgu'yomo maṉ jyuyaj ti va'cø cyu'tyajø. ");
INSERT INTO zosNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Entonces Samaria yomo'is ñøjay Jesús: ―Como mitz Israel pøn, ¿ticøtoya mi ⁿva'cpa øtzcøs nø', como øtz Samaria yomoti chøṉø? Porque Israel pøn y Samaria pøn de por sí na qui'sayajtøjpa. ");
INSERT INTO zosNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesusis 'yaṉdzoṉu ñøjayu: ―O'ca mi muspana'ṉ ti tø tzi'papø Diosis y o'ca mi muspana'ṉ i'is nø mi nøjayumbø: “Tø va'ctzi usyøc nø'”, mijna'ṉ mi ⁿva'cpa nø' øtzcøsi y øjna'ṉ mi ndzi'pa nø' mumu jamacøtoya va'cø mi ⁿyaj quena. ");
INSERT INTO zosNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Y yomo'is ñøjay Jesús: ―Señor, ja mi nø'it ni tiyø majcuy y nø' jojmoti ijtu, ¿jut ma mi mbøc nø' mumu jamacøtoya va'cø quena? ");
INSERT INTO zosNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Será que más mi ⁿmyu'sombya que vi'napø ndø janda Jacobse? Porque je'is tzajcatyam yøṉ nø'chatøc y je'tom ñøput nø' para vyingøtoya y 'yunecøtoya y vyacascøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesusis ñøjay yomo: ―O'ca ndø to'ṉba yøcsepø nø', usyaṉ horacøsi tø vøco yo'ctøtzque'tpati. ");
INSERT INTO zosNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero o'ca mi ndo'ṉba nø' øtz ndzi'papø, nunca ji'nam maṉ mi ⁿyo'ctøtz nunca, pero nø' øtz ndzi'papø maṉba vome mi ndzoco'yomo va'cø mi ṉgyen mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Entonces yomo'is ñøjay Jesús: ―Señor, ndø tzi' nø mi ndzamusepø nø' va'cø jana yo'ctøtza'mtzi y va'cø jana min mbøc nø' yø'qui. ");
INSERT INTO zosNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Entonces Jesusis ñøjayu: ―Mavø, ma vejay mi ⁿjaya y mindam yø'qui. ");
INSERT INTO zosNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yomo'is ñøjayu: ―Ja it ø ⁿjaya. Jesusis ñøjayu: ―Viyuṉsyete nø mi nchamu que ja it mi ⁿjaya. ");
INSERT INTO zosNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porque mosayamete pøn oyu mi nø'indi, y pøn mi nø'ijtupø yøti, ji'ndyet mi ⁿjaya. Por eso viyuṉdit nø mi nchamu. ");
INSERT INTO zosNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yomo'is ñøjay Jesús: ―Señor, ṉgui'pspøjtzi que mitz ñcha'maṉvajcopapøte. ");
INSERT INTO zosNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ø janda tzu'ṉgu'ista'm cyøna'tzøyaj Dios yøṉ lomacøsi, y mitz mi Israel pø'nista'm mi ñømdamba que mumu pøn tiene que va'cø myaṉyaj Jerusalén gumgu'yomo va'cø cyøna'tzøyaj Dios jiṉø. ");
INSERT INTO zosNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Y Jesusis ñøjayu: ―Tzamyomo, tø va'ṉjam ndøvø; maṉba nu'c 'yora cuando ji'n ma mi min yøṉ lomacøsi, ni ji'n ma mi myaṉ Jerusalén gumgu'yomo va'cø mi ṉgøna'tzøy Dios. ");
INSERT INTO zosNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mitz ji'n mi mustam i mi ṉgøna'tzøtyamba, pero øtz musta'mbøjtzi i ṉgøna'tzøtya'mbøjtzi; porque Yajcotzojcopyapø minba Israel pø'nomda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Porque maṉba nu'c hora y nu'cu'am yøti cuando lo que viyuṉbø cyøna'tzø'yajpapø'is maṉba cyøna'tzøyaj ndø Janda Dios vøjpø Espirituji'ṉ y viyuṉbø qui'psocuji'ṉ. Porque ndø Janda Diosis syunba jetseta'mbø pøn va'cø cyøna'tzøyajø. ");
INSERT INTO zosNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios espiritupøte, y cyøna'tzøyajpapø'is tiene que va'cø cyøna'tzøyajø vøjpø Espirituji'ṉ y viyuṉbø qui'psocuji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yomo'is ñøjay Jesús: ―Muspøjtzi que maṉba min Diosis cyø'vejupø ñøjayajque'tpapø Cristo. Cuando minba jicø, je'is maṉba tø tzajmatyam aunque tiyø. ");
INSERT INTO zosNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesusis ñøjayu: ―Øjchømøṉø nø mi ⁿvyejvejneyumbøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jicsye'c vitu'yaj Jesusis ñøtuṉdøvø, y ñømaya'yaju ti'ajcuy yomoji'ṉ nø vyejvejneyu. Pero ni i'is ja ñøjayø: “¿Ti mi sunba?”; y ni jutipø'is ja ñøjayø: “¿Ti'ajcuy nø mi ⁿvyejvejney yomoji'ṉ?” ");
INSERT INTO zosNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pero yomo'is chac myajcuy y maṉ cumgu'yomo. Y ñøjayaj cumgu'yomda'mbø: ");
INSERT INTO zosNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Maṉdya'i, maṉ ndø a'mista'i. Jiṉ it pøn nø tzajmayupø'stzi mumu jujche ndzøjcupøse øjtzi. ¿Ji'nacsque't jicøm Cristo? ");
INSERT INTO zosNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Entonces tzu'ṉyaj cumgu'yomo nu'cyaj jut ijtumø Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mientras jetse nø tyujcupø, ñøtuṉdøvø'is ñøjayaj Jesús: ―Maestro, vi'c yøṉ vi'jcuy. ");
INSERT INTO zosNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero je'is ñøjayaju: ―Lo que mitz ji'n mi mustamepø, ijtuti ti ⁿvi'cpa øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Entonces ñøtuṉdøvø'is na ñønøjayajtøju: ―¿I'sacs ñømijnay vi'jcuy? ");
INSERT INTO zosNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesusis ñøjayaju: ―Va'cø ndzøc lo que syunbase cø'vejupø'stzi, y va'cø yac tujcay je'is yoscuy, jetse itpøjtzi contento como si fuera tas øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mitz mi ñømdamba: “Faltatøc macscuy poya va'cø cyøṉyaj nipi”. Pero øtz mi nøjañdya'mbøjtzi: Quende'ndamø y cøque'nøtyam pøn como nipise. Como cama tøjtzupø listo va'cø ndø piṉdamø, jetse je pøn listo va'cø cyøma'nøjayaj Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yosaṉ Diosise ñe, y it yoscuy va'cø cha'maṉvajcay je'is 'yote. Y yosyajpapø coyojyajtøjpa y piṉyajpa yosaṉ mumu jamapø quengucøtoya. Y como parejo casøyajpa ñipyajpapø'is y piṉyajpapø'is, jetse parejo maṉba casøyaj chamdzo'chajpapø'is Diosis 'yote y lo que isyajpapø'is cuando vøti pø'nis vya'ṉjamyajpa. ");
INSERT INTO zosNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Y jetse viyuṉete lo que nømyajpase: “Eyapø'is ñijpa, eyapø'is piṉba”. ");
INSERT INTO zosNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Øtz maṉu mi yaj cosechatzøctame ja mi yostamømø. Eyata'mbø yosyaju, y mitz ndyøjcøtyamu eyata'mbø'is yosa'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Y vøti jic Samaria cumgu'yomda'mbø'is vya'ṉjamyaj Jesús cuando myañaju jujche chajmayajuse yomo'is. Porque yomo'is ñøjayaju: “Jic pø'nis tzajmay øjtzi todo lo que ti ndzøjcuse øjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Entonces cuando Samaria cumgu'yomda'mbø'is cyønu'cyaj Jesús, cyøpena'ajyaju va'cø chø'y jetji'ṉda'm. Y entonces Jesús tzø'y metza jama jic cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Y vøti eyata'mbø'is vya'ṉjamyajque'tuti porque myañaju lo que ñe'c Jesusis cha'maṉvajcuse. ");
INSERT INTO zosNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Y ñøjayaj yomo: ―Yøti va'ṉjamdamba'mtzi porque mandamu'mtzi jujche ñe'c ndø Comi'is nø cha'maṉvajcuse, ji'n sólo mitz nø mi ndza'maṉvajcuse. Y yøti ndø mustamba'am que viyuṉete yøṉ pøn Cristote tø yaj cotzoctambapø'is tø nascøsta'mbø tø pønda'møṉø. ");
INSERT INTO zosNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Cøjtu'cam metza jama Jesús tzu'ṉ jeni y maṉ Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Porque ñe'c Jesús nømu que tum tza'maṉvajcopyapø ji'n pyøjcøchoṉyaje ñe cyumgutyøvø'is. ");
INSERT INTO zosNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Entonces cuando Jesús nu'cu Galilea nasomo, jiṉda'mbø'is pyøjcøchoṉyaju, porque oy isyaj mumu lo que jujche Jesusis chøjcuse Jerusalén gumgu'yomo sø'ṉomo, porque oyajque'tu Galilea nasomda'mbø sø'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Entonces Jesús mingue'tu Caná cumgu'yomo Galilea nasomo oyumø yac vinu'aj nø' milagrovinipit. Ijtuna'ṉ jen tum gobierno'is pyøn Capernaum gumgu'yomo y ca'ena'ṉ je'is 'yune. ");
INSERT INTO zosNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Cuando je'is myanu que Jesús tzu'ṉu Judea nasomo y minu Galilea nasomo, entonces maṉ 'yo'nøy Jesús va'cø myaṉ tyøcmø va'cø maṉ yac tzojcay 'yune, que 'yune nømøme cya'to'u. ");
INSERT INTO zosNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Entonces Jesusis ñøjayu: ―Mientras ji'n mi ndø isay ø milagro'ajcuy y musocuy, pues ji'ndye ma mi ndø va'ṉjamdame. ");
INSERT INTO zosNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Gobierno'is pyø'nis ñøjay Jesús: ―Señor, min pronto antes que ca'pa ø une. ");
INSERT INTO zosNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesusis ñøjayu: ―Mavø; tzojcu'am mi une. Y pø'nis vya'ṉjajmu jujche Jesusis chajmayuse y maṉgue'tu tyøcmø. ");
INSERT INTO zosNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Y cuando nømna'ṉ myaṉ tyøcmø, chøsi'sta'm choṉyaju y ñøjayaju: ―Yøti mi ⁿune tzojcu'am. ");
INSERT INTO zosNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Entonces 'yaṉgøva'cu tiyø hora vø'ajtzo'tzu. Y ñøjayaju: ―Tø'øc como a la unasye'ṉomo cøt ñutzø. ");
INSERT INTO zosNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jetse jyata'is ñi'aṉjajmu que misma hora que Jesusis ñøjayu'øc: “Yøti mi ⁿune tzojcu'am”; jicse'cti cøt ñutzø. Y ñe'c pø'nis vya'ṉjam Jesús y mumu tyøjcomda'mbø'is vya'ṉjamyajque'tuti. ");
INSERT INTO zosNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yøṉete mena'combø milagro'ajcuy lo que chøjcupø Jesusis cuando tzu'ṉ Judea nasomo y nu'c Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jøsi'cam eyaco jama nømna'ṉ syøṉdzøcyaj Israel pønda'm Jerusalén gumgu'yomo. Y Jesús jiṉdi maṉgue'tu. ");
INSERT INTO zosNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Y Jerusalén gumgu'yomo tome aṉdyuṉ ñøjayajpapø borrego'is 'yaṉdyuṉ ijtuna'ṉ tum taṉque, Israel pø'nis 'yote'omo ñøyipø'is Betesda. Ijtuna'ṉ jen mosay corredor. ");
INSERT INTO zosNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Y øṉyaju je'tom sone ca'eta'mbø, to'tita'mbø, yacsuta'mbø, ja ityajø'is pyømi va'cø vityajø. Nømna'ṉ jyo'cyaju va'cø mics nø'. ");
INSERT INTO zosNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Porque 'yorapit 'yorapit mø'nbana'ṉ angeles taṉque'omo y yac micspa nø'. Cuando micspa nø', vi'na tøjcøpapø nø'cø'mø tzocpa. Aunque jujchepø ca'cuy ñø'ijtupø'is, tzocpa. ");
INSERT INTO zosNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pues ijtuna'ṉ jen tum pøn treinta y ocho año'am cya'emø. ");
INSERT INTO zosNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesusis isu nø 'yøṉumø y ñi'aṉjajmu que ya'møjcam ca'e'ajtzo'tzumø. Y Jesusis ñøjayu: ―¿Sunbaja mi ñchoca? ");
INSERT INTO zosNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ca'epø pø'nis ñøjay Jesús: ―Señor, cuando micspa nø', ja it ni iyø nøtøjcøpa'stzi nø'cø'mø. Pero mientras øtz sunba tøjcøtyo'a, eyapø vi'na tøjcøpya. ");
INSERT INTO zosNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Pero Jesusis ñøjayu: ―Te'nchu'ṉø, pøc mi øṉguy, y vitø'am. ");
INSERT INTO zosNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Y misma hora tzojcu, y pyøc 'yøṉguy y vijtzo'tzu. Y sapøjcuy jamacøsi jetse tujcu. ");
INSERT INTO zosNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Por eso Israel pø'nis ñøjayaj pøn tzojcupø: ―Sapøjcuy jamaṉ yøti. ¿Ti'ajcuy ma mi yac tzu'ṉ mi øṉguy? Ya'inducpa aṉgui'mba'is va'cø jana mi nøvit mi øṉguy. ");
INSERT INTO zosNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pø'nis 'yaṉdzoṉu: ―Oyupø'is yac tzoque, je'is nøja'yøjtzi: “Piṉ mi øṉguy y ma vitø”. ");
INSERT INTO zosNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Entonces 'yaṉgøva'cyaju: ―¿I'is mi ñøjayu: “Piṉ mi øṉguy y ma vitø”? ");
INSERT INTO zosNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tzojcupø pø'nis ja myusø i'se yac tzojcu, porque maṉumna'ṉ y sonena'ṉ ijnøm jiṉø. ");
INSERT INTO zosNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pero jøsijcam Jesusis pya'tu yac tzojcupø'am masandøjcomo mismo je pøn y ñøjayu: ―Coma'nøyø ti maṉba mi ndzajmaye. Yøti ñchojcu'am. U'yam maṉ mi ndzøjca'ṉøy mi ṉgoja, si no más pyor maṉba mi ṉgya'e'ajque'te. ");
INSERT INTO zosNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pøn maṉu y chajmayaj Israel pøn que Jesusise yac tzojcupø. ");
INSERT INTO zosNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Por eso Israel pø'nista'm sunbana'ṉ ti algo chøjcayaj Jesús y jyajme'chajpana'ṉ vuelta jujche muspa yaj ca'yaj Jesús porque jetsepø tiyø chøjcu sapøjcuy jamacøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero Jesusis ñøjayaju: ―Ø Janda yospa hasta como yøticse'ṉomo, y øtz yosque'tpati'tzi. ");
INSERT INTO zosNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Por eso Israel pø'nis más chøcme'chajpana'ṉ vuelta jujche va'cø yaj ca'yajø. Qui'sayajpana'ṉ porque ja cyo'aṉjamø aṉcø sapøjcuy jama, y más qui'sayajpana'ṉ porque nømu que Dios Jyatate y jetse chøc vyin como Diostitque't. ");
INSERT INTO zosNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Entonces Jesusis ñøjayaju: ―Viyuṉse mi nøjañdya'mbøjtzi, øjchøṉ Diosis 'Yune y ji'n mus ndzøc ni tiyø ne'c ø ndumgø'y. Lo que ispøjtzi chøcpapø ø Janda'is, jetse muspa ndzøjque'ta, porque mumu jujche lo que chøcpapø ø Janda'is, jetseti ndzøjque'tpa øjtzi je'is chøṉ 'Yune øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Porque ø Janda'is su'nbøjtzi, y isindzi'pøjtzi mumu lo que ñe'c chøcpase. Y matøc yac isque't más myøja'ṉomda'mbø tiyø va'cø mi nømaya'ndamø. ");
INSERT INTO zosNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Porque como ø Janda'is yac visa'yajpa ca'yajupø'am y yajqueñajpa, jetse øjtzi 'Yune chøṉø y øjtzi yaj quenque'tpati'tzi iyø sunba yaj quena. ");
INSERT INTO zosNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ø Janda'is ji'n cyøme'tz ni iyø cyojaji'ṉ, pero øtz cojtøjtzi ø Janda'is va'cø ṉgøme'tz i'is it cyoja, øjchøn Diosis 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ø Janda'is jetse cojtøjtzi va'cø cyøna'tzøyaj mumu pø'nis. Jujche ø Janda cyøna'tzøyajpase, jetseti øtz va'cø cøna'tzøtyøjque'ta øtz 'Yuneti chøṉø. Ji'n mave'is cøna'tzøyajøjtzi, ji'ndi cyøna'tzøyajque't ø Janda oyupø'is cø'veje. ");
INSERT INTO zosNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","”Viyuṉsye mi nøjayndya'mba øjtzi: Cyøma'nøpyapø'is ø onde y vya'ṉjambapø'is ø Janda lo que cø'vejupø'is øjtzi, mumu jamacøtoya itpa je pøn. Diosis ji'n ma yaj coja'aj ni tiyø, ca'upøsena'ṉ ijtu, pero yøti quenbati. ");
INSERT INTO zosNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Viyuṉse mi nøjandyamba: Minba hora y nu'cu'am hora cuando ca'use ityajupø cyoja'is, maṉba cyøma'nøjayaj ø onde, øtz Diosis chøṉ 'Yune, y cyøma'nøjayajpapø'is maṉba queñaj mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Como ø Janda de por si na ñe'cti ijtu, jetse ø Janda'is aṉgui'm øjtzi je'is chøṉ 'Yune jetseti ø ne'cti va'cø itque'ta. ");
INSERT INTO zosNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ø Janda'is tzi'ø aṉgui'mguy va'cø ndzi'yaj tum dum pøn conforme jujche oyse iti y øjtze Pø'nis chøṉ Tyøvøta'm. ");
INSERT INTO zosNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Uy nømaya'tam yøcseta'mbø tiyø. Porque maṉba nu'c 'yora cuando mumu nipyatøjupø'is tzatøjcomda'mbø'is maṉba myajnayaj ø onde, øtz Diosis chøṉ 'Yune, ");
INSERT INTO zosNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","y maṉba putyaje. Opø'is chøcyaje vøjpø tiyø maṉba visa'yaje va'cø cyeñaj mumu jamacøtoya. Opø'is chøcyaj yatzita'mbø tiyø maṉba visa'yaje va'cø yaj coja'ayajtøjø. ");
INSERT INTO zosNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","”Øtz ji'n mus ndzøc ni tiyø como si fuera ø ne. Jujche ø Janda Diosis tzajmapyase øjtzi, jetse øtz maṉba arreglatzøjcayaj pø'nis cyojata'm. Y øtz aṉgui'mbapø chøṉ vøjø. Øtz ji'n ma aṉgui'mi ø ne ṉgui'psocuji'ṉ, maṉba aṉgui'mi ø Janda'is syunbase. Porque ø Janda'is cø'vejøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","O'ca ø ne' ndza'mbøjtzi i' chøṉø, ji'n mi mustame o'ca viyuṉsye nø mi ndzajmatyamu. ");
INSERT INTO zosNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero it eyapø chamgue'tpapø'is i' chøṉø. Y muspøjtzi que je'is cotza'mbøjtzi viyuṉsye. ");
INSERT INTO zosNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mitz oy mi ṉgø'vejta'm mi nu'cscuy Juangø'mø y Jua'nis mi ñchajmatyamu lo que viyuṉbø tiyete. ");
INSERT INTO zosNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero ji'ndyet pyena pø'nis va'cø cotzam øjtzi; pero øtz ndza'maṉvacpøjtzi yøcsepø tiyø va'cø mi ṉgyotzoctamø. ");
INSERT INTO zosNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanna'ṉete como si fuera tum no'asepø nembapø y sø'ṉbapø, porque tza'maṉvajcopyana'ṉ. Y jetse ñøcsø'ṉøjapyana'ṉ pø'nis chocoy. Y como tø casøtyambase cuando ndø istamba nø syø'ṉu no'a, jetse usyan horati mi ṉgøcasøtyamu lo que mi ñcha'maṉvajcatyamuse Jua'nis. ");
INSERT INTO zosNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero it más myøja'ṉombø cotzambapø'stzi que ji'n Juan. Porque ø Janda'is tzamdzi'ø yoscuy va'cø yac tucø, y jetsepø yoscuy ndzøcpapø øjtzi. Mi istamba lo que ndzøcpapø øjtzi, y jetse muspa mi ndzi'tam cuenta que ø Janda'is cø'vejøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y mismo ñe'c ø Janda'is cø'vejupø'stzi, y je'is cotza'mgue'tpati'tzi. Pero mitz nunca ja mi majnandyam je'is 'yote, ni nuncatøc ja mi isatyam je'is vyin. ");
INSERT INTO zosNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ja mi nø'ijtatyam je'is 'yote mi ndzoco'yomda'm. Porque ø Janda'is cø'vejøjtzi y ji'n mi ndø va'ṉjamductame. ");
INSERT INTO zosNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mitz mi ndu'nme'tztamba Diosis tyotojayecøsi porque mi ṉgomo'tyamba que je'tomo maṉba mi ndu'nba'tame jujche muspa mi ijtam vøjø mumu jamacøtoya. Y mismo totojaye'is cotza'mbøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero ji'n sun mi ndø va'ṉjamdamø; si no, øtz maṉbana'ṉ mi yac ijtam vøjø mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","”O'ca ji'nø vøpøpøngotzøc pø'nis, ji'n ø ndzøjcay cuenda. ");
INSERT INTO zosNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Øtz mi ṉgomusta'mbøjtzi, que ji'n mi sundam viyuṉsye Dios mi ndzoco'yomda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Øtz mi'nøjtzi ø Janda'is ñøyicøsi, pero mitz'ta'm ji'n sun mi ndø pøjcøchoṉdamø. Pero o'ca minba eyapø lo que ñe'c qui'psocuy maṉba'is yac yose, jet jø'ø, maṉba mi mbøjcøchoṉdame. ");
INSERT INTO zosNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ni jujche ji'n mus mi va'ṉjamondyamø porque na mi vyøṉgotzøctandøjpa mi ne'ṉgomda'm. Y ji'n mi ṉgøme'tztam mi ⁿvin va'cø mi vyøṉgotzøctam tumbø Diosis. ");
INSERT INTO zosNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","U mi ṉgui'pstamu que o'ca øtz ma'ṉbø mi ṉgøva'cøtyame ø Jandacøsi. It eyapø mi ṉgyøva'cøtyambapø'is, Moisesisete. Y Moisés mi ñømdamba que mi va'ṉjamdamba mitzta'm. ");
INSERT INTO zosNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pero o'ca mi va'ṉjamdambana'ṉ Moisés, mi ndø va'ṉjamdaṉque'tpatina'ṉ ndøvø. Porque cotza'm øjtzi Moisesis totocøs jachø'yuse. ");
INSERT INTO zosNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero o'ca ji'n mi va'ṉjamdam Moisesis jyachø'yuse, entonces ji'ndi ma mi ndø va'ṉjajmatyaṉquet ø onde. ");
INSERT INTO zosNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jøsijcam Jesús maṉ Galilea majris cyøtu'møṉ. Jic mar ñøyipø'stique't Tiberias. ");
INSERT INTO zosNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Y vøti pø'nis maṉ pya'tyaj Jesús porque isyaju jujche chøcpana'ṉ milagro'ajcuy va'cø yac tzocyaj ca'eta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Y Jesús qui'm loma chøquicøsi y jiṉ po'csyaju ñøtuṉdøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Y nømna'ṉ tyome'aj Israel pø'nis syøṉda'm ñøyipø'is pascua søṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús quende'nu y is vøti pøn nø cyønu'cyajupø'is. Entonces Jesusis ñøjay Felipe: ―¿Jut maṉba ndø juñdyam cu'tcuy va'cø ndø nøcu'tyaj vøti pøn nømiñajupø? ");
INSERT INTO zosNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jetse ñøjayu a ver tina'ṉ chamba Felipe'is, porque ñe'c Jesusis qui'psminu que ti maṉba chøqui. ");
INSERT INTO zosNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe'is 'yaṉdzoṉu ñøjayu: ―Sone mil peso'ombø tuminji'ṉ va'cø ndø ⁿjujyay paṉ ji'n ma cyopa'tyaj pønda'm, usyta'm usytya'm va'cø cyø'syaj tumdum pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pero ijtuna'ṉ jen tum Andrés, Jesusis ñøtuṉdøvøque't y Simóṉ Pedro'is tyøvø. Je'is ñøjay Jesús: ");
INSERT INTO zosNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Yøc ijtu tum ṉga'e ñø'ijtupø'is mosay paṉ cebadapø y metzcuy coque, pero jet ji'ndyet ni tiyø para vøti pøngøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Entonces Jesusis ñøjayu: ―Yac po'csquecyaj vøti pøn. Y ijtuna'ṉ ya'iṉom mu'c jicø lugajromo. Entonces vøti pøn po'csquecyaju. Ijtuna'ṉ como mosay mil pøn. ");
INSERT INTO zosNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Y Jesusis pyøc paṉ y ñøjay Dios yøscøtoya, vye'ndzi'yaj paṉ ñøtuṉdøvø y je'is vye'nayaj todo lo que po'csyajuse, y jetseti vye'ñayajque't coque, chi'yaj tumdum pøn cu'tastasneyajpa'cse'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Cuando cu'tyaj tasemøta'm, Jesusis ñøjayaj ñøtuṉdøvø: ―Piṉdamø mi ṉgu'tzacata'm va'cø jana tocoy ni jujche. ");
INSERT INTO zosNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Por eso piṉaṉdø'pyaju cyu'tzacyajupø y macvøstøjcay cøvaca piṉyaj paṉ cebadapø sobratzøjcupø cuando cu'tyajujcam. ");
INSERT INTO zosNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Entonces cuando pø'nis isaju milago'ajcuy Jesusis chøjcupø, nømyaju: ―Viyuṉsye yøṉete jicø tza'maṉvajcopyapø nøm ndø ⁿjo'ctamupø va'cø min nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero Jesusis cyønøctøyøyu que maṉbana'ṉ miñaje vøti pøn va'cø yac aṉgui'myajø y por eso tzu'ṉ tyumgø'y maṉ cotzøjcøsi va'cø jana yac aṉgui'myajø. ");
INSERT INTO zosNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cuando tza'i'ajnømu, mø'ñaj nø'aṉvini ñøtuṉdøvø. ");
INSERT INTO zosNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Y tøjcøyaj barco'omo tzu'ṉyaju va'cø myaṉyaj nø'cøtumaṉ Capernaum cumgu'yomo. Cuando pi'tzø'ajnømu, Jesús ja ñu'cøtøcna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Entonces pocho'tz pømi sava y syujcølapslapsvøy nø'. ");
INSERT INTO zosNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Como tumø legua mediase'ṉomo nømømna'ṉ myanijatzøcyaj barco cuando isyaj Jesús nø vijtupø nø' vingøsi como si fuera nascøs nø minuse, y nømømna'ṉ ñu'c tome barco'aṉvini, y na'tzemiñaju. ");
INSERT INTO zosNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero je'is ñøjayaju: ―Øjchømøṉø, u mi ña'tztamu. ");
INSERT INTO zosNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Entonces paquichoco'yajyaju pyøjcøchoṉyaj Jesús barco'omo. Y jø'nøti nu'cu barco nø' acapoya nø myaṉyajumø. ");
INSERT INTO zosNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pero jut tzu'ṉyajumø Jesusis ñøtuṉdøvø, jiṉ tzø'yajuna'ṉ vøti pøn. Y je'is chi'yaj cuenta que ñøtuṉdøvø tøjcøyajuna'ṉ barco'como y tzu'ṉyajuna'ṉ, pero Jesús ja tøjcøyaj jetji'ṉ barco'omo, y ja itøna'ṉ eyapø barco jinø. ");
INSERT INTO zosNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero eyata'mbø barco Tiberias cumgu'yomo tzu'ṉyajupø oyuna'ṉ cøtyaj tome jic lugarcøsi oyumø pyaṉgu'tyaje vøti pønda'm después que ndø Comi'is oyuna'ṉ ñøjay yøscøtoya Dios. ");
INSERT INTO zosNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Entonces jyo'pit chi'yaj cuenta pø'nista'm que Jesús ja ityøna'ṉ jeni, ni ja ityajøna'ṉ jeni ñøtuṉdøvø. Entonces vøti pøn tøjcøyajque't barco'omda'm va'cø myaṉyaj Capernaum cumgu'yomo. Y jeni nømna'ṉ mye'chaj Jesús jut ijtu. ");
INSERT INTO zosNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Y cuando pya'tyaj Jesús nø'cøtumaṉ, ñøjayaju: ―Maestro, ¿jujchøc mi jac min yø'qui? ");
INSERT INTO zosNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesusis 'yaṉdzoṉyaju ñøjayaju: ―Viyuṉsye mi nøjandya'mbøjtzi: Nø mi ndø me'tztamu pero ji'ndyet porque mi istamu aṉcø que øtz ndzøjcu milagro'ajcuy. Pero mi ndø me'tztamu porque mi ṉgu'jtam pan mi ndyaspacsye'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","U mi yostam yajpapø cutcucøtoya, sino que yostamø nunca ji'n yajepø cu'tcucøtoya lo que mi nchi'tambapø'is ji'n yajepø quenguy. Jetsepø cu'tcuy øtz ma'ṉbø mi ndzi'tame. Øtz pø'nis chøṉ tyøvøta'm, y ndø Janda Diosis cøpi'ṉøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Entonces ñøjayaju Jesús: ―¿Ti vøj ndzøcta'mø va'cø ndø tzøctam Diosis syunbase? ");
INSERT INTO zosNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesusis 'yaṉdzoyaju ñøjayaju: ―Va'cø mi ndø va'ṉjamdam ndøvø Diosis chøṉ cø'vejupø, jetse mi ndzøctamba Diosis syunbase. ");
INSERT INTO zosNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Entonces Jesús ñøjayajque'tu: ―¿Jujchepø seña maṉba mi ndø yac istame? O'ca mi ndø yac istamba seña, maṉba mi va'ṉjamdame. ¿Ti mi ndzøcpa? ");
INSERT INTO zosNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Porque ndø Janda tzu'ṉgu'ista'm cyu'tyaju cu'tcuy ñøyipø'is maná cuando vityaju'c tøtzønasomo. Como it jaychø'yupø totocøsi: “Tzi'yajtøj cu'tcuy tzajpom mø'nupø va'cø cyu'tyajø”. ");
INSERT INTO zosNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Entonces Jesusis ñøjayaju: ―Viyuṉsye mi nøjañdya'mbøjtzi: Ji'ndyet Moisesis mi ñchi'tamupø cu'tcuy tzajpom mø'nupø. Sino ø Janda'is mi ñchi'tamba viyuṉsepø cu'tcuy tzajpom mø'nupø. ");
INSERT INTO zosNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porque pan lo que Diosis chi'papø, jicømete mø'nupø tzajpomo yaj queñajpapø'is nascøspø pøn. ");
INSERT INTO zosNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Entonces ñøjayaju Jesús: ―Señor, mumu jama tø tzi'tam mi ndzambasepø cu'tcuy. ");
INSERT INTO zosNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Y Jesusis ñøjayaju: ―Øjchøṉø cu'tcuy sajpapø'is quenguy mumu pøngøtoyata'm; minbapø øtzcø'mø, nunca ji'n ma 'yose; y va'ṉjambapø'is øjtzi, nunca ji'n ma yo'ctøtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero como ndzajmayu'mtzi, mitz mi ndø istamu, pero ja mi ndø va'ṉjamda'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mumu pøn lo que ndø Janda'is tziyajupø'stzi, maṉba minyaj øtzcø'mø. Y i minba øtzcø'mo, øtz nunca ji'n ma macpø'i ni jujchøc. ");
INSERT INTO zosNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Øtz mø'nu øjtzi tzajpomo, ji'ndyet va'cø ndzøc ø ne'c sunbapø tiyø, sino que va'cø ndzøcø lo que syunbase cø'vejupø'stzi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Maṉba mi ndzajmatyame lo que syunbapø ø Janda'is lo que cø'vejupø'stzi. Je'is syunba va'cø jana yac tocoyø ni jutipø pøn je'is tzi'upø. Sino syunba øtz va'cø ⁿyac visa'yajø ultimopø jamacøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Maṉba mi ndzajmatyaṉque'te lo que jujche syunba cø'vejupø'stzi. Je'is syunba va'cø queñaj mumu jamacøtoya isyajpapø'stzi y va'ṉjamyajpapø'stzi Diosis chøṉ 'Yune. Y øtz maṉba ⁿyac visa'yaje ultimopø jamacøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Entonces Israel pø'nis cyø'o'nøyaju Jesús porque Jesús nømu: “Øjchønø cu'tcuy mø'nupø tzajpomo”. ");
INSERT INTO zosNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nømyajque'tu: ―Parece yøṉete Jose'is 'yune Jesús, y øtz ṉgomusatya'mba øjtzi jyata y myama: ¿ticøtoya nø ñømu: “Øjchøṉ mø'nupø tzajpomo”? ");
INSERT INTO zosNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Por eso Jesusis 'yaṉdzoṉyaju ñøjayaju: ―Utyø ṉgø'o'nøtyam mi ne'ṉgomda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni i ji'n mus ñu'c øtzcø'mø mientras que ji'n yac mijnay qui'psocuy ø Janda Diosis cø'vejupø'is øjtzi. Y o'ca minba øtzcø'mø, øtz maṉba ⁿyac visa ultimopø jamacøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","It jachø'yupø tza'maṉvajcoyajpapø'is jyachø'yajuse: “Mumu pøn Diosis maṉba 'yaṉmayaje”. Jetcøtoya cyøma'nøjayajpapø'is ø Janda'is 'yote, y aṉmayajpapø pøn Dioscø'mda'm, mumu jejta'm maṉba minbø'yaj øtzcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","”Ni i'is nunca ja is ø Janda Dios, único øtz Diosmø tzu'ṉu, øtz isøjtzi ø Janda Dios. ");
INSERT INTO zosNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Viyuṉse mi nøjayndyambøjtzi: O'ca mi ndø va'ṉjamdamba øjtzi, maṉba mi ṉguendam mumu jama. ");
INSERT INTO zosNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ø jchøṉ cu'tcuy sajpapø'is mumu pøngøtoya quenguy. ");
INSERT INTO zosNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ndø vi'nata'mbø ndø janda'is cyu'tyaju maná tøtzønasomo ityajupø, pero ca'pø'yaju'am. ");
INSERT INTO zosNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero øtz mi ndza'maṉvajcatyamba cu'tcuy mø'nupø tzajpomo que muspa cyu'tyaj pø'nis y ji'n maṉ cya'yaje. ");
INSERT INTO zosNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Øjchøṉø cu'tcuy mø'nupø tzajpomo sajpapø'is quenguy. O'ca aunque jutipø pø'nis cyu'tpa yøṉ cu'tcuy, maṉba quen mumu jamacøtoya. Y cu'tcuy lo que øtz maṉbapø ndzi'i, mismo øjtze sis. Øtz maṉba ndzi'ocuyaj ø sis va'cø yaj ca'tøjø va'cø queñaj nascøsta'mbø pøn. ");
INSERT INTO zosNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Entonces Israel pø'nis cyø'o'nøyaju ñe'comda'm nømyaju: ―¿Jutznømø muspa yøṉ pø'nis tzi'tam ñe'c sis va'cø ndø cu'tatyamø? ");
INSERT INTO zosNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Entonces Jesusis ñøjayaju: ―Viyuṉse mi nøjandya'mbøjtzi: Øjchøṉø Pø'nis Tyøvøta'm; o'ca ji'n mi ndø cu'tay ø sis y ji'n mi ndø ndo'ṉay ø nø'mbin, ji'n mus mi ṉgyena. ");
INSERT INTO zosNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","O'ca mi ⁿvi'capya ø sis y ndo'ṉapya ø nø'mbin, mi ṉgyenba mumu jamacøtoya. Y øtz ma'ṉbø mi yac visa' ultimopø jamacøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porque ø sis viyunsepø cu'tcuyete y ø nø'mbin viyuṉsepø ujcuyete. ");
INSERT INTO zosNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Vi'capyapø'is ø sis y tyo'ṉapyapø'is ø nømbin, ø ndzoco'yom itpa y je'tis choco'yom itpøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ø Janda cø'vejupø'is øjtzi, ñe'c quenba y je'is yaj quenba øjtzi, y jetsetique't cu'tpapø'is øjtzi, ⁿyaj quenque'tpati øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Øjchøṉ cu'tcuy mø'nupø tzajpomo. Vi'nata'mbø ndø Janda'is cyu'tyaj maná, pero ca'pø'yaju'am. Cyu'tpapø'is yøcsepø cu'tcuy øtz ndzambapø maṉba cyen mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yø'csepø ti cham Jesusis Israel pø'nis cyonocscuy tøjcomo mientras que nømna'ṉ 'yaṉma'yoyu Capernaum gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Por eso cuando myañaj vøti ñøtuṉdøvø'is nømyaju: ―Na'nchaṉda'mbø tiyø nø cha'maṉvajcu. ¿I'is cyønøctøyøpya jetsepø ote? ");
INSERT INTO zosNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesusis ñe'cti myusu que nø ñu'mgø'o'nøyaj ñøtuṉdøvø'is y ñøjayaju: ―Lo que øtz nø mi ndzajmatyamupø ticøsi, ¿ti'ajcuy nø mi ṉgui'syca'tamu? ");
INSERT INTO zosNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tiyacs ma mi ṉgui'pstame cuando maṉba mi ndø istame nøm qui'mu'ctzi tzajpomo jut ijtumøna'ṉtzi vi'na? Øjchøṉø mumu Pø'nis Tyøvøta'm. ");
INSERT INTO zosNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espiritu'is tø yaj quenba, ndø sis ni ticøtoya ji'n yose. Øtz ndzambapø tiyø, Espiritute y ø ondeji'ṉ mi ṉgyendamba. ");
INSERT INTO zosNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero vene'aṉbøn mitzta'm ji'n mi ndø va'ṉjamdame. Porque Jesusis na myuspatina'ṉ desde cho'tzcu'yomo i'is ji'n maṉ vya'ṉjamyaje. Y myusque'tuti i'is maṉba chi'ocuyaje 'yenemigocøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y Jesusis ñøjayaju: ―Jetcøtoya øtz mi nøjandyamu'mtzi, que ni iyø ji'n mus min øtzcø'mø o'ca ji'n yac min qui'psocuy ø Janda Diosis. ");
INSERT INTO zosNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Desde jic jamacøsi vøti ñøtuṉdøvø'is chacpø'yaj Jesús, y ja maṉam pya'tyaje. ");
INSERT INTO zosNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Entonces Jesusis 'yaṉgøva'cyaju ñøjayaju macvøstøjcapyø ñøtuṉdøvø: ―¿Será que maṉbatijacs mi ndø tzacpø'taṉgue'te? ");
INSERT INTO zosNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Entonces Simón Pedro'is ñøjayu Jesús: ―Ø Ṉgomi, ¿ti'ajcuy ma'ṉbø mba'jtam eyapø? Pero ni iji'ṉ ji'n mus maṉda'møjtzi porque sólo mitz muspa tø tza'maṉvajcatya'mø jujche muspa tø quendam mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Y mi va'ṉjamda'mbøjtzi y musta'mbøjtzi que mijtzete Cristo, quenbapø mi Diosis 'yune. ");
INSERT INTO zosNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesusis 'yaṉdzoṉu ñøjayaju: ―Øtz mi ṉgøpiṉda'mu øjtzi macvøstøjcay y tumø pujtu mijtzomda'm ñøc'ijtøyupø yatzi'ajcu'is. ");
INSERT INTO zosNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesusis chamuna'ṉ Judas, Simón Iscariote'is 'yune. Porque je'is chi'ocu'yaj Jesús 'yenemigocøsi, y Judas macvøstøjca'yombøna'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jøsijcam Jesús nømna'ṉ vijtu Galilea nasomo, ji'na'ṉ sun vit Judea nasomo, porque Israel pø'nis qui'pscøpoyaju jujche va'cø yaj ca'yajø. ");
INSERT INTO zosNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nømna'ṉ tyome'aj Israel pø'nis syøṉda'm cuando maṉba chøcyaj tøc une va'cø ityaj je'tomo. ");
INSERT INTO zosNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Por eso ñøjayaj Jesús myuqui'sta'm: ―Tzu'ṉ yøqui y maṉ Judea nasomo va'cø isyaj jiṉda'mbø mi nønduṉdøvø'is lo que ti mi ndzøcpapø. ");
INSERT INTO zosNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Porque syunba'is ispøctøjø iyete, entonces ji'n ñu'mdzøc ni tiyø. O'ca mi ndzøcpa yøcseta'mbø tiyø, yaj quej mi ⁿvin mumu pø'nis vyi'na'ṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jetse ñøjayaju myuqui'sta'm porque ni ji'na'ṉ vya'ṉjamyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Entonces Jesusis ñøjayaju: ―Ja ñu'cøtøc ø hora; pero mijta'm aunque ti hora muspa mi ndzøctam mi ⁿyoscuy. ");
INSERT INTO zosNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nascøsta'mbø pø'nis ji'n mus maṉ mi ṉgui'satyam mijtzi, pero øtz ndza'maṉvajcatyamba ancø que ji'n vyøjpø ti nø chøcyajupø, jetcøtoya qui'sayajpøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mitz maṉdamø ijtumø søṉ, øtz ji'ndøc ma maṉ ji'ṉø. Porque øtz ja ñu'cøtøc mero ø hora. ");
INSERT INTO zosNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Después que chajmayaju'cam jetse, tzø'yu Jesús Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero cuando maṉyaju'cam myuquita'm, entonces jøsijcam Jesús maṉque'tuti sø'ṉomo. Pero ja yac istøj vyin cuando myaṉu'øc, como si fuera nu'mnu'cuti. ");
INSERT INTO zosNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Entonces sø'ṉomo Israel pø'nis nømna'ṉ mye'chaj Jesús y nømyaju: ―¿Jutacs ijtu? ");
INSERT INTO zosNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Y vøti pø'nis ñu'mdzamyaju Jesús o'ca jujchepø pønete. Eyata'mbø nømyaju: “Vøjpø pønete”. Eyata'mbø nømyaju: “Ji'nda, pero aṉgøma'cø'oyete”. ");
INSERT INTO zosNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero ni i ji'na'ṉ oñaj pømi va'cø jana myañaj ni i'is o'ca tina'ṉ nø chamyajupø, porque na'chaju ti maṉba chøjcayaj Israel pø'nis cyovi'najø'is. ");
INSERT INTO zosNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Entonces cuc sø'ṉomo Jesús tøjcøy masandøjcomo y nømna'ṉ 'yaṉma'yoyu. ");
INSERT INTO zosNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Y Israel pø'nis nømna'ṉ ñømaya'yaju jujche muspa aṉma'yoya, nømyaju: ―Ja 'yaṉmayø yøṉ pøn, ¿jutznømø musopya? ");
INSERT INTO zosNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesusis ñøjayaju: ―Ø aṉma'yoṉguy ji'ndyet ø ne ṉgui'psocuy, sino cø'vejupø'stzi, je'is tzi'pa qui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Syunba'is chøc jujche syunbase ø Janda'is, pues je'is maṉba myusi jutipøt ø aṉma'yoṉgcuy, o'ca Diosis ñe, o'ca øjtzene. ");
INSERT INTO zosNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","O'ca øtz ndzambana'ṉ ø ne ṉgui'psocuy, entonces sunbana'ṉtzi va'cø vøpøpøngotzøctøjø; pero como øtz su'nbøjtzi va'cø vyøcotzøctøjø ø Janda lo que cø'vejupø'stzi, entonces viyuṉbø ti ndza'mbøjtzi y øtz ji'nø aṉgøma'cø'yoye. ");
INSERT INTO zosNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","”Moisesis mi ⁿjyajyandyamu aṉgui'mguy, pero ni jutipø'is mijtzomda'm ji'n yaj coputi lo que Moisesis mi aṉgui'mdamuse. ¿Ti'ajcuy sunba mi ndø yaj ca'tamø? ");
INSERT INTO zosNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Y pø'nista'm ñøjayaju Jesús: ―Mitz ni i'is ji'n sun mi yaj ca'ø. ¿Será mi nø'it mitz yatzipø espiritu? ");
INSERT INTO zosNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesusis 'yaṉdzoṉyaju ñøjayaju: ―Øtz ndzøjcøjtzi tum milagro'ajcuy y mumu mitzta'm mi ṉgømaya'ndamu. ");
INSERT INTO zosNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisesis mi 'yaṉgui'mdamu va'cø mi seña'øyaj mi unenda'm Israel pø'nis syenaji'ṉ. Ji'ndyet o'ca Moisesis ñøcøtzo'tzu jetsepø costumbre, sino más vi'nata'mbø ndø jandatzu'ṉgu'ista'm jetseti ñøcøtzo'chaju. Y yøti cuando ta'nba jama va'cø sena'øyø, mitz seña'øyajpa une aunque sapøjcuy jamacøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Como mitz seña'øtyamba une sapøjcuy jamacøsi va'cø mi yaj copujtay Moisesis lyey, entonces ¿ti'ajcuy mi ṉgui'satyam ndøvø cuando øtz yac tzoc mø'chøqui tum pøn sapøjcuy jamacøsi? ");
INSERT INTO zosNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Cuando mi ṉgui'pstamba ti vøjø, ti ji'n vyøjø, hay que va'cø mi ṉgui'psmindam mø'chøqui; porque hay veces ji'n queje ti vøjpø ti ji'n vyøjpø. ");
INSERT INTO zosNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Entonces eyata'mbø Jerusalén gumgu'yomda'mbø nømyaju: ―¿Ji'nacsque't yøṉ pønø'am lo que mye'chajupø va'cø yaj ca'yajø? ");
INSERT INTO zosNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pero yøṉ pø'nis nø chamu va'cø myandøj parejo. Y aṉgui'myajpa'is ni ti ji'n chajmayaje. ¿Será que myusyajpa yøṉ pøn o'ca viyuṉete Cristote? ");
INSERT INTO zosNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero øtz mustamu'mtzi yøṉ pøn jut tzu'ṉu. Cuando minba Cristo, ni i'is ji'n ma myusi jut maṉba tzu'ṉi. ");
INSERT INTO zosNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Entonces Jesús veju masandøjcomo mientras nømna'ṉ 'yaṉma'yoyu, nømu: ―Mi ndø ispøctamu'am y mi ndø mustamu'am jut tzu'ṉ øjtzi y øtz ja mi'nøjtzi ø ne'c ṉgustopit. Viyuṉsye it cø'vejupø'stzi, pero mitz ji'n mi ṉgomustam jicø cø'vejupø'stzi iyete. ");
INSERT INTO zosNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero øtz ṉgomuspøjtzi cø'veju'stzi porque øtz tzu'ṉu jet ijtumø y je'is cø'vejøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Entonces covi'najø'sta'm mye'tzayaj vuelta jujche va'cø ñucyaj Jesús, pero ni i'is ja ñucø, porque ja ñu'catøcna'ṉ 'yora va'cø ñuctøja'm. ");
INSERT INTO zosNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Y sone pø'nis vya'ṉjamyaj Jesús y nømyaju: ―Yøṉøm ocsyote Cristo; o'ca ji'na'ṉ Cristo, ji'na'ṉ mus chøc jetsepø milagro'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseo va'ṉjajmocuy ñø'ijtupø'is myañaju que sone pø'nis jetse nø chamyaj Jesús. Entonces fariseo'sta'm y Israel pø'nis pyane covi'najø'sta'm cyø'vejyaj policía va'cø maṉ ñucyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Entonces Jesusis ñøjayaju: ―Usya'ṉomdi'am maṉbatøcø ya'e mitzji'ṉda'm, y entonces ma'ṉbø vitu ijtumø cø'vejupø'stzi. ");
INSERT INTO zosNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ma mi ndø me'tztame, y ji'n ma mi ndø pa'jtame, porque ji'n mus mi myaṉdam jut ijtumø øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Entonces Israel pønda'm na ñøjayajtøj ñe'comda'm: ―¿Jutacs maṉba mave va'cø ndø jana pa'jtamø? ¿Será que maṉba maṉ Israel pøn ityajumø eyata'mbø cumgu'yomo va'cø 'yaṉmayaj eyata'mbø pøn lo que ji'ndyet Israel pønda'm? ");
INSERT INTO zosNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ti'ajcuy jetse nø ñømu: “Ma mi ndø me'tztame, y ji'n ma mi ndø pa'jtame, porque ji'n mus mi myaṉdamø jut ijtumø øjtzi”? ");
INSERT INTO zosNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Entonces søṉgoyajcuy jama'omo lo que más cyo'aṉjamyajpana'ṉ, je jama'omo Jesús te'nchu'ṉu y veju, nømu: ―O'ca aunque i yo'ctøtzpa, hay que va'cø min øjtzøcø'mø va'cø min tyo'ṉ nø'. ");
INSERT INTO zosNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Va'ṉjambapø'stzi, je'is choco'yomo maṉba vombutputney nø' como møja nø'se mumu jamacøtoya va'cø yaj quena. Jetse ijtuse jachø'yupø totocøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Pero Jesusis nømna'ṉ chamu que jetse maṉba pyøjcøchoṉyaj Espiritu Santo vya'ṉjamyajpa'is Jesús, va'cø vyombut choco'yomo Espiritu Santo como møja nø'se. Porque Espiritu Santo ja chi'tøjøtøcna'ṉ porque Jesús ja tyøjcøyøtøcna'ṉ myøja'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Por eso cuando vøti pø'nis myañaju nø chamuse Jesusis, nømyaju: ―Viyuṉse yøṉete tza'maṉvajcopyapø ndø ⁿjo'ctambapø. ");
INSERT INTO zosNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Eyata'mbø nømyaju: ―Yøṉete Cristo Diosis cyø'vejupø. Pero vene nømyaju: ―Pero Cristo ji'n maṉ chu'ṉ Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Porque ndø mustamba que it jachø'yupø que Cristo pø'najpa Davijdis 'yune tzu'ṉgu'yomo y maṉba pø'naj Belén gumgu'yomo jut omø it David. ");
INSERT INTO zosNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jetse por Jesuspit eyata'm eyata'm qui'pscøpo'ayaj tumdumbø pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Y veneta'mbø'is nømna'ṉ sun ñucyaj Jesús, pero ni i'is ja ñucø. ");
INSERT INTO zosNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Entonces policía nu'cyaj pane covi'najøcø'mda'm y fariseocø'mda'm y je'is ñøjayaj policía: ―¿Ticøtoya ja mi nømindam jic pøn? ");
INSERT INTO zosNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Y policia'is ñøjayaju: ―Nunca ja ndyø majnandyamøtøc eyapø pøn que vejvejnepya como jic pøn vejvejnepyase. ");
INSERT INTO zosNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Entonces fariseo'is 'yaṉdzoṉyaju ñøjayaj policía: ―¿Mitzta'm será que mi aṉgøma'cøtyandøjque'tuti? ");
INSERT INTO zosNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mitz mi mustamba que ni jutipø aṉgui'mbapø'is, ni jutipø fariseo'is, ja vya'ṉjajmø jic pøn. ");
INSERT INTO zosNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero jic ji'n cyomusyaje'is Diosis 'yaṉgui'mguy tocoyajupøte. ");
INSERT INTO zosNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jendina'ṉ itque't Nicodemo oyupø'is tyu'n Jesús tzu'yi, y mismo fariseotitque't. Je'is ñøjayaj fariseo tyøvøta'm: ");
INSERT INTO zosNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ijtuse ndø aṉgui'mgutya'm que ji'n mus ndø castigatzøc pøn o'ca ja ndyø aṉgøva'cøtøc ti cyoja. ");
INSERT INTO zosNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Fariseo'is ñøjayaj Nicodemo: ―¿Y mitz a ver o'ca Galilea nasomdi mi ñchu'ṉgue'tupø? Octu'n sa'sa Diosis jyachø'yupø libru'omo, y maṉba mi ñchi' cuenta que ni jutipø tza'maṉvajcopapø ji'n pø'naj Galilea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Y mumu pøn maṉyaj tyøcmø. ");
INSERT INTO zosNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús maṉ Olivo cotzøjcøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jyo'pit namdzu vitu'que'tu y tøjcøy masandøjcomo. Y sone pø'nis cyøtu'myajque't Jesús. Y Jesús po'csu y 'yaṉmayaj sone pøn. ");
INSERT INTO zosNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Y 'yaṉma'yoyajpapø'is aṉgui'mgupit y fariseo'sta'm ñømiñaj tum yomo pya'tyajupø nø cyøtzøjcøyu'is jyaya. Y cyotyaj je yomo pøn gucmø Jesusis vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Y ñøjayaj Jesús: ―Maestro, yøṉ yomo pa'jtøju mero nø cyøtzøjcøyu'c jyaya. ");
INSERT INTO zosNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisesis 'yaṉgui'mguy ijtu que jetsepø ay que va'cø ndø pyu'ṉga'yaj tza'ji'ṉ. ¿Pero mitz ti mi ndzamba? ");
INSERT INTO zosNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pero jetse nømyaju va'cø chøjquisyaj Jesús jujche sunbana'ṉ pya'tayaj ticøsi va'cø mus chøjcayaj Jesusis cyoja. Pero Jesús atzquec nascøsi y cyøja'yøy nas cyø'aṉuneji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pø'nis syeguitzøcyaju va'cø 'yaṉgøva'cyaj Jesús. Entonces Jesús viyuṉbo'csque'tu ñøjayaju: ―Ja itø'is ni jujchepø cyoja, je'tis va'cø vi'na pyu'ṉdzo'tza. ");
INSERT INTO zosNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Entonces Jesús atzquejque'tu y jacye't nas cyø'ji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Cuando myañaj ti cham Jesusis, mumu min jyameminyaje que ityajque't ñe' cyojata'm, y tumdum putyaju. Masam achpøta'mbø vi'na putyaju y jøsi'cam mumu putyaju hasta que tumdim tzø'y Jesús, y yomo jendi tzø'cye't te'nupø. ");
INSERT INTO zosNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Entonces Jesús viyuṉ de'ngue'tu y quenmaṉ quenmaṉu y ni i ja itø, nada más que yomotimna'ṉ tumgø'y ijtu. Jesusis ñøjay yomo: ―Tzamyomo, ¿jut maṉyaj mi mye'ndzayu'is mi ṉgoja? ¿Será que ni i'is ja mus mi ñchøjcay mi ṉgoja? ");
INSERT INTO zosNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yomo'is ñøjayu: ―Señor, ni i'is ja musø tzøjcay ø ṉgoja. Jesusis ñøjayu: ―Ni øtz ji'nam mi ndzøjcay mi ṉgoja. Mavø, y uyam más mi ndzøc mi ṉgoja mi ne'ṉgø. ");
INSERT INTO zosNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Entonces jøsi'jcam Jesusis 'yo'nøvøjøtzøcyajque't sone pøn ñøjayaju: ―Øtz yac sø'ṉapyapø'is nascøta'mbø'is chocoy. Maṉba'is pa'tøjtzi, ji'n ma it como pi'tzø'omse, sino maṉba it como sø'ṉgø'omse va'cø cyena. ");
INSERT INTO zosNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Entonces fariseo'sta'm ñøjayaj Jesús: ―Mi ne'c mi ndzamba mi ⁿvin ⁿiye mijtzi; ji'n vyaletzøqui mi ndzambapø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesusis ñøjayaju: ―Aunque ø ne'c ndza'mbøjtzi ø ⁿvin, pero viyuṉsyeti ndzamba. Y øtz muspøjtzi jut mi'nøjtzi y jut ma'ṉøpyøjtzi; pero mitz ji'n mi mustame jut mi'nøjtzi, ni jut ma'ṉøpyøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pø'nis qui'psocuji'ṉ, jetse mi ṉgyøme'tzotyamba. Øtz ji'n ṉgøme'tz ni iyø cyojaji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","O'ca øtz ṉgøme'chajpøjtzi, øtz ṉgøme'chajpa vøjø. Porque øtz ji'n chøṉ ø ndumgø'y maṉba ṉgøme'tze. Porque øtz ṉgøme'chajpøjtzi ø Jandaji'ṉ; ø Janda'is cø'vej øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","También jachø'yupøte ndø aṉgui'mgu'yomo que o'ca metzcupyø pø'nis tumbø ti chamyajpa, entonces viyuṉbøte. ");
INSERT INTO zosNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pues jetse øtz ndza'mbøjtzi ø ⁿvin, y ø Janda'is cø'vejupø'stzi, je'is tzamgue'tpa i chøṉ øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Entonces pø'nis ñøjayaj Jesús: ―¿Jut it mi Janda? Jesusis ñøjayaju: ―Mitzta'm ji'n mi ndø ispøctame, ni ji'n mi ispøctam ø Janda. Ø'ca mi ndø ispøctambana'ṉ, también ø Janda mi ispøctaṉgue'tpatina'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jetsepø ote cham Jesusis mientras nø tye'n tome tumingotcucyø'mø mientras nømna'ṉ 'yaṉma'yoyu'øc Israel pø'nis myasandøjcomo. Pero ni i'is ja ñucø, porque ja ñu'cøtøcna'ṉ 'yora. ");
INSERT INTO zosNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Entonces Jesusis ñøjayaju: ―Øtz ma'ṉbøjtzi, y maṉba mi ndø me'tztame, pero maṉba mi ṉgya'tam mi ṉgojaji'ṉ. Jut ma'ṉbøjtzi, ji'n mus mi myaṉdamø. ");
INSERT INTO zosNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Entonces Israel pønda'm na ñøjayajtøju: ―¿Será que maṉba yaj ca' vyin? porque nømba: “Jut ma'ṉbøjtzi, ji'n mus mi myaṉdamø”. ");
INSERT INTO zosNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Y Jesusis ñøjayaju: ―Mitz cø'yi nascøs mi ⁿitcutya'm. Øtz møjipø ø ⁿitcuy; mitz ñascøsta'mbøte, øtz ji'n chøṉ nascøspø. ");
INSERT INTO zosNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Por eso øtz mi ⁿnøjandya'møjtzi que maṉba mi ṉgya'tam mi ṉgojaji'ṉ. Porque o'ca ji'n mi va'ṉjamdame que øjchøṉø lo que mi ndzajmatyamuse'tzi, entonces maṉba mi ṉgya'tam mi ṉgojaji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Entonces ñøjayaj Jesús: ―¿ⁿIye mijtzi? Y Jesusis ñøjayaju: ―Lo mismo lo que mi ndzajmatyamuse'tzi desde que ndzamdzo'tzu'csye'ṉo'mtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ijtutøc vøti ti va'cø ndzamgue'ta y va'cø ṉgøme'tza ti mi ndzøctam mijtzi, pero cø'vejupø'is øjtzi, viyuṉbø ti chamba y øtz ndzajmayajpa mumu nascøsta'mbø pøn lo que ti je'is tzajmayuse. ");
INSERT INTO zosNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero jicø pø'nista'm ja cyønøctøyøyajø o'ca Jyata Dios nø chamu Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Entonces Jesusis ñøjayaju: ―Øjchøṉø mumu Pø'nis Tyøvø. Cuando nø mi ndø nøṉgui'mdamu'øc møji cruzcøsi, entonces maṉba mi mustame que øjchøṉø nømna'ṉ mi ndø ⁿjo'ctamupø y que ni ti ji'n ndzøc ø ndumgø'y; jujche ø Janda'is tzajma'yøjtzi, jetse øtz ndzamgue'tpøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cø'vejupø'stzi, øtzji'ṉbøte. Ø Janda'is ja ø ndumgø'y tzacø. Porque øtz mumu jama ndzøcpøjtzi jujche syunbase ø Janda'is. ");
INSERT INTO zosNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nømna'ṉ chamu'øc jetsepø tiyø, sone pø'nis vya'ṉjamyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Entonces Jesusis ñøjayaju Israel pøn vya'ṉjamyajupø'is: ―O'ca mi ndzøctamba mumu jama lo que jujche øtz ndzambase, entonces viyuṉse mijtzi øjchøṉ mi aṉmayndamu. ");
INSERT INTO zosNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Y maṉba mi mustam viyuṉsyepø tiyø, y viyuṉsyepø ti va'cø mi mustamø, maṉba mi libre'ajtame. ");
INSERT INTO zosNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Entonces ñøjayaj Jesús: ―Øtzta'm Abraha'mis chøṉ 'yuneta'm. Øtz nunca ja o mozo'ajtam ni jutipø pøngø'mø. Øtz de por si libreta'mbø chønø. ¿Ti'ajcuy mi ndø nøjandyamba: maṉba mi libre'ajtame? ");
INSERT INTO zosNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesusis ñøjayaju: ―Viyuṉsye mi nøjandya'mbøjtzi, que o'ca mi ndzøcpa mi ṉgoja, entonces yatzipø mi ṉgui'psocu'is mi obligatzøcpa va'cø mi ndzøc yatzitzoco'yajcuy como si fuera mi yac mozo'ajpa. ");
INSERT INTO zosNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Y mozo ji'n it como une ijtuse, porque mozo ji'n it mumu jama tøjcomo, pero une mumu jama itpa tyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Øjchøṉ Diosis 'Yune, y o'ca øtz mi yac libre'ajta'mbøjtzi, entonces viyuṉsye maṉba mi ijtam libre va'cø jana mi nøndzøctam mi yandzita'mbø ṉguipsocu'is. ");
INSERT INTO zosNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Øtz muspøjtzi que mitz Abraha'mis mi 'yuneta'm. Pero mi ṉgui'pscøpo'tamba jujche muspa mi ndø yaj ca'tamø, porque ji'n tøjcøy mi ndzoco'yomda'm ti ndzambase øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Øtz ndza'mbøjtzi lo que ø Janda'is isindzi'upø'tzi. Mitz mi ndzøctamba lo que mi Janda'is mi isindzi'tamuse. ");
INSERT INTO zosNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Entonces 'yaṉdzoṉyaju y ñøjayaj Jesús: ―Abraham ya'møcpø øjtzø jandata'm. Jesusis ñøjayaju: ―O'ca viyuṉsye mijna'ṉ Abraha'mis mi 'yunenda'm, mi ndzøctambana'ṉ vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero yøti sunba mi ndø yaj ca'tamø, aunque øtz mi ndzajmatyamu viyuṉsyepø tiyø Diosis tzajmayupø. Abraha'mis ja chøc jetse. ");
INSERT INTO zosNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jujche mi Janda'is chøcpase, jetseti mi ndzøctaṉgue'tpa. Y ñøjayaj Jesús: ―Øtzta'm ji'n chøṉ ispøqui une. Tumbøti ndø Jandata'm, Diosete. ");
INSERT INTO zosNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesusis ñøjayaju: ―O'ca Diosna'ṉ mi Jandata'm, mi ndø sundambana'ṉ, porque øtz Diosmø tzu'ṉøjtzi, mi'nø yø'qui. Ja mi'nøjtzi ø ne'c ṉgustopit sino que Diosis cø'vejøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ti'ajcuy ji'n mi ṉgønøctøyøtyame ti øtz nø ndzamupø? Ji'n mi ṉgønøctøyøtyame, porque mitz ji'n sun mi ndø majnatyam ti ndza'mbøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mijta'm yatzi'ajcu'is mi 'yunenda'm. Y sunba mi ndzøctando'a lo que jujche chøcpase yatzi'ajcu'is, porque jet mi jandata'm. Yatzi'ajcuy yaj ca'opapø desde cho'tzcu'yomo. Ji'n qui'ps viyuṉsepø tiyø, porque ja it viyuṉsyepø tiyø chocø'yomo. Cuando je yatzipø sutzpa, ñe'cti qui'pscøpo'pa porque sutzpapøte. Y mumu jujchepø sutzcuy je'is ñøcøtzo'tzpa. ");
INSERT INTO zosNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Y porque mitz sutzcuy mi sundamba, por eso ji'n mi ndø va'ṉjamdame cuando mi ndzajmatyamba'c viyuṉsyepø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿A ver o'ca it mijtzomda'm muspapø'is pya'tay ø ṉgoja? Y como øtz ndzamba viyuṉsepø tiyø, ¿ti'ajcuy ji'n mi ndø va'ṉjamdame? ");
INSERT INTO zosNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","O'ca it pøn Diosis ñe, je'is cyøma'nøjapya Diosis 'yote. Y mitzta'm ji'n mi ṉgøma'nøjatyame, porque ji'nde mi Diosis ñe'ta'm. ");
INSERT INTO zosNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Entonces Israel pø'nis 'yaṉdzoṉyaju y ñøjayaj Jesús: ―Parece que mitz Samaria cumgu'yombø mi mbyønete, y mitz mi ñøc'ijtøyu yatzi'ajcu'is. ");
INSERT INTO zosNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesusis 'yaṉdzoṉyaju: ―Øtz ja ñøc'ijtøy yatzi'ajcu'is. Sino que øtz vøṉgotzøcpa ø Janda, pero mitz ji'n mi ndø vøṉgotzøctame. ");
INSERT INTO zosNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Øtz ji'n sun møja'ṉomgotzøc ø ⁿvin, sino eyapø'is møja'ṉomgotzøcpøjtzi. Y je'is maṉba cham o'ca øtz ndzøcpa vøjø, o si no mitz ndzøctamba vøjø. ");
INSERT INTO zosNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Viyuṉsye mi nøjandya'mbøjtzi: yaj coputpapø'is ø onde, nuṉca ji'n ma cya'e. ");
INSERT INTO zosNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Entonces Israel pø'nis ñøjayaj Jesús: ―Yøti musta'mbøjtzi sebro que yatzi'ajcu'is mi ñøc'ijtøyu, porque Abraham ca'u'am, y tza'maṉvajcoyajpapø ca'yaju'am, y mitz ñømba: “Yaj coputpapø'is ø onde nuṉca ji'n ma cya'e”. ");
INSERT INTO zosNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Será que mitz más mi myøja'ṉombøte que ji'n ndø janda tzu'ṉguy Abraham? Abraham ca'u'am y tza'maṉvajcoyajpapø ca'yaju'am. ¿O'ca ise mitz mi ndzøcpa mi ⁿvin? ");
INSERT INTO zosNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesusis ñøjayaju: ―O'ca øtz møja'ṉom ndzøcpa ø ⁿvin, ji'ndyet ni tiyø. Pero ø Janda Diosis møja'ṉomgotzøcpøjtzi. Y mitz mi ñømdamba que mismo Dios mi va'ṉjamdaṉgue'tpa. ");
INSERT INTO zosNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero ji'n mi ṉgomustam ø Janda Dios, øtz ṉgomuspøjtzi ø Janda. O'ca nømbana'ṉtzi ji'n ø ṉgomus Dios, sutzpana'ṉtzi jujche mitz mi sutztambase. Pero øtz ṉgomuspa Dios y ndzøcpøjtzi je'is chambase. ");
INSERT INTO zosNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ndø Janda tzu'ṉguy Abraham casøyu cuando cyønøctyøyøyu que maṉba is øjtzi y o is øjtzi, y casøju. ");
INSERT INTO zosNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Entonces Israel pø'nis ñøjayaj Jesús: ―¿Jutznømø maṉba mi isque't Abraha'mis? Ni mitz ja mi nø'itøtøc ni cincuenta ame y Abraham ya'møjcam ca'u. ");
INSERT INTO zosNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesusis ñøjayaju: ―Viyuṉse mi nøjandya'mbøjtzi; antes que Abraham o iti, øtz na ijtu'ctimtze øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Entonces piṉyaj tza' va'cø pyuṉga'yaj Jesús. Pero Jesús aṉgøvø'nu y tzu'ṉ masandøjcomo, cøt pøngujqui y maṉu. ");
INSERT INTO zosNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Y mientras Jesús cøjtu, is pøn to'tipø desde que pø'naju. ");
INSERT INTO zosNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesusis ñøtuṉdøvø'is 'yaṉgøva'cyaj Jesús, ñøjayaju: ―¿Maestro, a ver ticøtoya pø'naj tø'tipø jic pøn, a ver o'ca jyata'is cyojapit, o ñe' cyojapit? ");
INSERT INTO zosNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesusis 'yaṉdzoṉyaju: ―Ji'ṉdyet porque cojapa't ñe'cø ni jyata ni myama, sino que va'cø tø yac is Diosis lo que muspa chøc ñe'cø. ");
INSERT INTO zosNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Como por ejemplo jama'omo muspa tø yosø, jetseti øtzque't. Tiene que va'cø ndzøc yoscuy lo que syunbase cø'vejupø'is øjtzi mientras que ijtutøc lugar. Y como tzu'i'ajnømba'c ji'n mus tø yosa, jetseti maṉba nu'c hora cuando øtz ji'ndi mus maṉ yosque't øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mientras que ijtu'c øtz nascøsi, itpa como tum sø'ṉgø para nascøsta'mbø pøngøtoyata'm. ");
INSERT INTO zosNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jetse nømu Jesús, y entonces tzuju nascøsi y chøc mote chujvinji'ṉ y jyajsay to'tipø'is vyitøm moteji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Y Jesusis ñøjay pøn: ―Ma vinche'a Siloé taṉque'omo ―Siloé ndø nøjayndyamba ndø ote'omo cø'vejupø. Entonces pøn maṉu y vinche'u y cuando vitu', sø'ṉba'am vyitøm. ");
INSERT INTO zosNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Entonces tøjcaṉbo'csa'sta'm y isyajpa'sna'ṉ to'tipø pøn vi'na nømyaju: ―¿Será que ji'ndyet ji'cø po'cspapø vya'cpapø'sna'ṉ tumin? ");
INSERT INTO zosNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Eyata'mbø nømyaju: ―Jicømete. Eyata'mbø nømyaju: ―Jicse quenba. Pero mismo ñe'c nømu: ―Øjchømøṉø. ");
INSERT INTO zosNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Entonces ñøjayaju: ―¿Jutz nøm yøti sø'ṉba mi vindøm? ");
INSERT INTO zosNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Y 'yaṉdzoṉyaju ñøjayaju: ―Tum pøn ñøyipø'is Jesús, je'is chøc mote chujvinji'ṉ y jetpit jajsay ø vindøm y nøja'yøjtzi: “Mavø Siloé tanque'omo y vinche'a”; y ma'ṉøjtzi y vinche'øjtzi y sø'ṉ ø vindøm. ");
INSERT INTO zosNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Y ñøjayaju: ―¿Jut it je mi ñcho'yøjayu'is mi vindøm? Y ñøjayaju: ―Ji'nø musi jut ijtu. ");
INSERT INTO zosNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Entonces ñømaṉyaj fariseo'is vyi'naṉdøjquita'm pøn to'tipøna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Y sapøjcuy jamacøsna'ṉ cuando Jesús motetzøjcu y cho'yøjay to'tipø'is vitøm. ");
INSERT INTO zosNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Por eso fariseo pø'nis ñøjayaju: ―¿Jutznøm mi ncho'yøjay mi vindøm? Y ñøjayaju: ―Tum pø'nis jyajsay ø vindøm motepit, y vinche'øjtzi, yøti sø'ṉba ø vindøm. ");
INSERT INTO zosNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Entonces veneta'm fariseo pønda'm nømyaju: ―Entonces je cho'yøyupø'is ji'ndyet Diosis cyø'vejupø; porque ji'n cyo'aṉjam sapøjcuy jama. Eyapø nømyaju: ―O'ca coja'øyu pønete, ¿jutznømø muspa chøc jetsepø milagro'ajcuy? Jetse eyapø'is eya qui'pspa, eyapø'is eya qui'pspa. ");
INSERT INTO zosNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Entonces ñøjayajque't pøn to'tipøna'ṉ: ―¿Mitz ti mi ndzamba? ¿Ipø pønete mi ncho'yøjayupø'is mi vindøm? Y ñøjayaju: ―Tza'maṉvajcopapø pønete. ");
INSERT INTO zosNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero Israel pø'nista'm ja vya'ṉjamyajø que to'tina'ṉ y yac sø'ṉatyøj vyitøm, y por eso vyejayaj je pø'nis jyata y myama. ");
INSERT INTO zosNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Y fariseo pø'nista'm 'yaṉgøva'cayaj jyata y myama ñøjayaju: ―¿Yøṉ mijtzate une? ¿Viyuṉete to'ti pø'naju? ¿Entonces jutznøm isopya yøti? ");
INSERT INTO zosNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jyata'is y myama'is 'yaṉdzoṉyaju, ñøjayaju: ―Musta'mbøjtzi que yøṉ øjtzø unenda'm, y musta'mbøjtzi que to'tipøt oyu pø'naje. ");
INSERT INTO zosNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero jutznøm yøti isopya, ji'nø mustame, ni ji'nø mustam i'is yac tzojcay vyitøm. Ø une tzambønbømete; ocva'ctam ñe'cø. Ñe'c muspa chamø jujche yac sø'ṉatyøj vyitøm. ");
INSERT INTO zosNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jetse nømyaj jyatata'm porque na'chaju uytem ti maṉ chøjcayaj Israel pø'nista'm. Porque Israel pøn parejo'ayaju'am va'cø jana yac tøjcøyaj conocscutyøjcomo aunque jutipø pøn o'ca nømba que Jesús Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Por eso jyata'sta'm ñøjayaju: “Tzambønbømete, ocva'ctam ñe'cø i'is yac tzojcay vyitøm”. ");
INSERT INTO zosNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Entonces vyejayaj pøn to'tipøna'ṉ y ñøjayaju: ―Vøcotzøc Dios; u jic pøn vøcotzøqui. Porque ndø mustamba que jic pøn cojapa'tupø pønete. ");
INSERT INTO zosNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Y ñøjayaju: ―Ji'nø musi o'ca cojapa'tupø pønete. Nada más que muspøjtzi que to'tipøna'ṉ chøṉø y yøti isopa'mtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Entonces ñøjayajque'tu: ―¿Ti mi ñchøjcayu? ¿Jujche ñcho'yøjay mi vindøm? ");
INSERT INTO zosNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Y 'yaṉdzoṉyaju: ―Mi ndzajmatyamu'mtzi y ja mi ndø va'ṉjamdamø. ¿Ti'ajcuy mi sundamba va'cø mi ndzajmatyaṉgue'tatø'ctzi? ¿Será que sunba mi aṉmandyam jetecø'mø? ");
INSERT INTO zosNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Y coraje'o'nøyaju y ñøjayaju: ―Mitz mi va'ṉjamba jic pø'nis 'yaṉma'yocuy; øtz va'ṉjamdamba Moisesis 'yaṉma'yocuy. ");
INSERT INTO zosNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ndø mustamba que Diosis 'yo'nøy Moisés. Pero jic pøn ji'nø mustam jut tzu'ṉu. ");
INSERT INTO zosNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","'Yaṉdzoṉ pø'nis ñøjmayaju: ―Como jic pø'nis yac sø'ṉay ø vindøm, pues ¿ti'ajcuy ji'n mi mustam jut tzu'ṉu? ");
INSERT INTO zosNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pues ndø mustamba que Diosis ji'n cyøma'nøy cojapa'tu pøn, pero o'ca cyøna'tzøpya'is Dios y chøcpa Diosis syunbase, jetsepø pø'nis 'yote Diosis cyøma'nøjapya ti nø vya'cu. ");
INSERT INTO zosNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Desde que cho'tzucse'ṉomo nasacopac, nuncatøc ja myandøjø o'ca i'is yac tzoc pøn to'tipø pø'najupø. ");
INSERT INTO zosNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","O'cana'ṉ Diosis ja cyø'vej jic tzo'yø'opyapø, ji'na'ṉ mus chøc ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Entonces 'yaṉdzoṉyaj fariseo'is ñøjayaju: ―Como mi saṉ gojapa'tupø mi mbyø'naju, ¿jutznøm muspa mi ndø aṉmandyamø? Y myacpø'yaj pøn to'tipøna'ṉ va'cø jana mus tyøjcøy conocscutyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesusis myusu que myacpø'yaju'am, y cuando pya'tu ñøjay to'tipø pøn: ―¿Va'ṉjambaja mijtzi Diosis 'Yune? ");
INSERT INTO zosNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Pø'nis ñøjay Jesús: ―Señor, tø tzajma'yøjtzi iyete Diosis 'yune va'cø va'ṉjam øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Y Jesusis ñøjayu: ―Mi isu'am Diosis 'yune. Jetji'ṉamete nø mi ⁿvejvejneyu. ");
INSERT INTO zosNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Pø'nis ñøjmayu Jesús: ―Señor, mi va'ṉja'mbøjtzi. Y cutcøne'cu Jesusis vi'naṉdøqui. ");
INSERT INTO zosNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Y Jesús nømu: ―Mi'nø nascøsi va'cø ṉgøme'chaj pønda'm i va'ṉjamopya i ji'n vya'ṉjajmoye. O'ca ijtu pøn ja itø'is qui'psocuy vøjpø, itpa como si fuera to'tipø y øtz ma'ṉbø yac mijnay qui'psocuy. Jetse maṉba iti como si fuera sø'ṉbase vyitøm. Pero cyomo'pyapø que it qui'psocuy vøjpø, pero ja itø; jet maṉba yac musyaje que to'tise ityajpa porque ji'n vya'ṉjajmoyaje. ");
INSERT INTO zosNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Entonces Jesusji'ṉ ityaj fariseo pønda'm y je'is myañaju jujche nø chamuse Jesusis. Y veneta'mbø'is ñøjayaj Jesús. ―Y øtzta'm, ¿será que øtz to'tita'mbøja'csque't chøṉø? ");
INSERT INTO zosNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Y Jesusis ñøjayaju: ―O'ca mitz to'tita'mna'ṉ, ja itamna'ṉ mi ṉgoja. Pero mitz yøti mi ñømda'mba: “Isotya'mbøjtzi”; por eso ijtam mi ṉgoja. ");
INSERT INTO zosNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","”Viyuṉse mi nøjandya'mbøjtzi, o'ca pøn tøjcøpya borrego ve'que'omo, pero ji'n tøjcøy aṉdyu'ṉomo, sino que emøc qui'mgøtpa, entonces jic pøn nu'mbapø pønete, tøjcøpya va'cø ñu'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero o'ca aṉdyu'ṉomo tøjcøpya, borrego coquenbapøte; ");
INSERT INTO zosNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","y aṉdyuṉ cuidatzøcpapø'is 'yaṉvacpa aṉdyuṉ. Y cuando cyoquenbapø'is vyejapya, borrego'is cyønøctyøjayajpa 'yote, y cuidatzøcpapø'is vyejayajpa ñe byorrego ñøyicøsta'm y vi'najayajpa byorrego cuando ñøputyajpa a'ṉgomo. ");
INSERT INTO zosNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cuando ñøputyajpa ñe'c byorrego a'ṉgomo, vi'najayajpa. Y byorrego cyomi'is jyøsmø maṉyajpa porque cyønøctyøjayajpa 'yote. ");
INSERT INTO zosNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero ji'n ispøcyajepø pøn, ji'n maṉ pya'tyaje, sino poyajpa. Porque ji'n cyønøctyøyøjayaj 'yote. ");
INSERT INTO zosNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jetsepø oteji'ṉ Jesusis 'yo'nøyaj pøn, pero ja cyønøctøyøjayajø ti nø chajmayaju. ");
INSERT INTO zosNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Entonces Jesusis ñøjayaju: ―Viyuṉse mi nøjayñdyamba: øjchøṉ como aṉdyuṉ borregocøtoya. Como borrego tøjcøyajpa aṉdyu'ṉomo, jetse pøn tøjcøyajpa øtzji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mumu lo que miñaju antes que mi'nøjtzi, suchajpapøtite y nu'myajpapøte. Pero borrego va'ṉjajmoyajpapø pønete, y va'ṉjajmoyajpapø pø'nis ja cyøma'ṉøjayaj suchajpa'is 'yote. ");
INSERT INTO zosNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Øjchøṉ aṉdyuṉ. O'ca aunque i tøjcøpya øtzpit, cotzocpa. Y como borrego tøjcøyajpya y putyapa y pya'tyajpa vøjpø cu'tcuy, jetse øtzpit tøjcøpyajpapø pø'nis maṉba pya'tyaj vøjpø itcuy. ");
INSERT INTO zosNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","”Nu'mbapø minba va'cø ñu'mø y va'cø yaj ca'oya y va'cø yac tocoya. Øtz mi'nøjtzi va'cø min ndzi'yaj quenguy y va'cø yac omba ityajø mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Øtz itpøjtzi como vøjpø borrego coque'nopase. Vøjpø coque'nopapø dispuesto va'cø cyoca' byorrego. ");
INSERT INTO zosNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Coyospapø pø'nis ispa nø minu copøn yaj ca'papø'is borrego y pochacpa borrego y popya, porque ji'nde ñe byorrego. Entonces copø'nis ñucyajpa borrego y poyti'ṉdi'ṉneyajpa. Jetseti ityaj aṉma'yoyajpapø que ji'n cuidatzøcyaj aṉmayajpapø. ");
INSERT INTO zosNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Coyospapø popya porque coyospapøte y ji'n cyømaya'yaj borrego, pero øtz ji'nø jetse. ");
INSERT INTO zosNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","”Øjchøṉø vøjpø coque'nopyapø. Jetse øtz ispøcyajpa ø ṉgoquenguy, y ø ṉgoquengu'is ispøcyajpa øjtzi, ");
INSERT INTO zosNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","como ø Janda'is comuspøjtzi y øtz ṉgomusque'tpa ø Janda. Øtz dispuesto va'cø ca'ø va'cø ṉgoquip ø ṉgoquenguy. ");
INSERT INTO zosNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Y itque'tuti emø eyata'mbø ø ṉgoquenguy ji'ndyet yøṉ ve'que'omda'mbø. Y jic tiene que va'cø nømingue'ta y maṉba cøma'nøjayaj ø onde. Y mumu ø ne' tumbø lugajromo maṉba ityaje y øndumgø'y ma'ṉbø ṉgoqueñaje. ");
INSERT INTO zosNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","”Øtz su'nbøjtzi ø Janda'is porque øtz i'nbø øjtzi ø ⁿvin va'cø ca'ø y va'cø visaque'ta. ");
INSERT INTO zosNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni'is ji'n mus yaj ca'øjtzi, sino que ø ne'c i'nbø'pa ø ⁿvin ø ṉgustopit. Øtz muspa i'nbø ø ⁿvin va'cø ca'ø, y muspa visaque'ta. Jetse ø Janda'is aṉgui'møjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Cuando myañaju jujche nø chamuse Jesusis, ja pyarejo vyø'møyaj Israel pø'nista'm. Eyapø'is eya qui'psocuy, eyapø'is eya qui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Y vøti nømyaju: ―Yatzipø espiritu'is nø ñøtzøjcu, y jovipøte. ¿Ti'ajcuy mi ṉgøma'nøndyamba? ");
INSERT INTO zosNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Eyata'mbø'is ñøjayaju: ―O'ca yatzipø espiritu'is ñøtzøcpana'ṉ, ji'na'ṉ cham yøcsepø ti nø chamuse. ¿Será que 'yatzi'ajcu'is ñøtzøcpa y jutznøm muspa yacsø'ṉay to'tipø pø'nis vyitøm? ");
INSERT INTO zosNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ijtuna'ṉ pacac aṉsøṉ, y Jerusale'nomo nø cyosø'ṉayaj tiyø jama tuc masandøc. ");
INSERT INTO zosNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Y Jesús nømna'ṉ vijtu Salomo'nis cyoredojromo tome masandøjcaṉvini. ");
INSERT INTO zosNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Entonces Israel pø'nis vyo'cøvitu'yaj Jesús y ñøjayaju: ―¿Jujche'øc maṉba mi ndø yac mustam sebro ⁿiye mijtzi? O'ca mijtzete Cristo Diosis mi ṉgyø'vejupø, ndø tzajmatyam viyuṉsye. ");
INSERT INTO zosNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesusis ñøjayaju: ―O mi ndzajmaytyame, y ja mi ndø va'ṉjamdamø. Mi istamba lo que øtz ndzøcpa ø Janda'is ñøyicøsi, y jetze muspa mi ndzi'tam cuenta que i'chøṉ øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero ji'ndyet ø mi ṉgoquengutya'm, por eso mitzta'm ji'n mi ndø va'ṉjamdame, como jujche o'yø mi ndzajmatyam vi'na. ");
INSERT INTO zosNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ø ṉgoquengu'ista'm cyøma'nøjayajpa ø onde. Y øtz ⁿispøcyajpøjtzi y miñajpa øtzcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Y øtz yaj queñajpa para mumu jamacøtoya. Y ji'n maṉ tocoyaj nuṉca, y ni i'is ji'n maṉ yac tzu'ṉayaj ø ṉgø'ombø. ");
INSERT INTO zosNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ø Janda'is tzi'yajøjtzi ø ṉgoquenguy y ø Janda más myøja'ṉombø que ni iyø. Y ni i'is ji'n mus yac tzu'ṉayaj ø Janda'is cyø'ombø. ");
INSERT INTO zosNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Y jujche ø Janda, jetseti øtzque't. ");
INSERT INTO zosNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Entonces Israel pø'nista'm piṉyajque't tza' va'cø pyu'ṉga'yaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Y Jesusis ñøjayaju: ―Sone vøjta'mbø tiyø oy ø ndzøqui mi vi'naṉdøjquita'm ø Janda'is tzi'use qui'psocuy. ¿Tiyø cuentapit sunba mi ndø mbu'ṉga'ta'mø? ");
INSERT INTO zosNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Entonces Israel pø'nis 'yaṉdzoṉyaju ñøjayaju: ―Ji'ndø porque mi ndzøcpa aṉcø vøjpø yoscuy sunba mi mbu'ṉga'tamø, sino porque Dios mi ṉgø'o'nøpya. Mitz mbyøndite y mi ⁿDioscotzøcpa mi ⁿvin. ");
INSERT INTO zosNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesusis 'yaṉdzoṉyaju: ―Ijtu jachø'yupø ndø aṉgui'mgu'yomo que Dios nømu: “Mitz mi ⁿdiosta'mete”. ");
INSERT INTO zosNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Pues entonces o'ca Dios nømu que pyøjcøchoṉu'is 'yote diosta'mete y Diosis tyotojaye viyuṉsepø tiyete; ");
INSERT INTO zosNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","entonces ¿ti'ajcuy mi ñømdamba que øtz Dios ṉgø'o'nøpya cuando nø'møjtzi que øtz Diosis chøṉ 'yune? Porque ø Janda'is cømasa'nøyøjtzi y cø'vejøjtzi nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","O'ca øtz ji'n ndzøc ø Janda'is yoscuy, uy mi ndø va'ṉjamdamø. ");
INSERT INTO zosNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero o'ca ndzøcpøjtzi ø Janda'is yoscuy, aunque ji'n mi ndø va'ṉjamdam ndøvø, lo que øtz ndzøcpapø øjtzi, jet va'ṉjamdamø. Jetse va'cø mi mustamø y va'ṉjamdamø que ø Janda'is ñø'ijtay ø ndzocoy, y øtz nø'ijtay ø Janda'is chocoy. ");
INSERT INTO zosNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Entonces sunbana'ṉ ñucyajque't Jesús pero cøtocoyu, ja mus ñucyajø. ");
INSERT INTO zosNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Y maṉque't Jesús Jordán nø'cøtu'møṉ jut vi'na nø'yø'oyumø Juan y jen tzø'yu. ");
INSERT INTO zosNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Y sone pø'nis maṉ 'ya'myaje, pøn nømyaju: ―Ni ja chøc Jua'nis ni jujchepø milagro'ajcuy. Pero mumu lo que Jua'nis chamuse Jesuscøsi, viyuṉbø tiyete. Porque Jua'nis chamu jujche maṉba chøc yøṉ pø'nis y ji'cajuti mumu lo que chamuse. ");
INSERT INTO zosNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y vøti pø'nis vya'ṉjamyaj Jesús jiṉø. ");
INSERT INTO zosNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ijtuna'ṉ tum pøn ñøyipø'is Lázaro. Oyu ca'e'aje, Betania cumgu'yomna'ṉ ijtu. Mismo cumgu'yom ityajuna'ṉ je'is tyøvø María y Marta. ");
INSERT INTO zosNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jic Maria'is jøsiti oyu jyajsay ndø Comi'is cyoso perfumeji'ṉ y cyømojcay vyayji'ṉ. Maria'is tyøvø Lázaro oy ca'e'aje. ");
INSERT INTO zosNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Entonces tyøvø'is cyø'vejayaj ote Jesús va'cø ñøjayø: ―Ø Ṉgomi, mi sunbapø mi ndøvø ca'cupya'tu. ");
INSERT INTO zosNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesusis myanu jetsepø ote, y nømu: ―Yøṉ ca'e'aju pero ji'ndyet va'cø cya'octucø, sino va'cø myøja'ṉomgotzøctøj Dios, y jetsetique't øtz va'cø møja'ṉomgotzøctøjque'ta, øtz Diosis chøṉ 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesusis syuñajpana'ṉ María y Maria'is tyøvø Marta y Lázaro. ");
INSERT INTO zosNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero cuando myanu que ca'e'aju, ya'que'tutøc metza jamana mismo ijtumøna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jøsijcam ñøjayaj ñøtuṉdøvø: ―Tø vøco maṉdaṉgue'ti Judea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ñøtuṉdøvø'is ñøjayaj Jesús: ―Maestro, ja itøtøc vøti jama que oyu mi mbyu'ṉga'jo'yaje tza'ji'ṉ Israel pø'nista'm. ¿Y ticøtoya jiṉdi mati mi myaṉgue'te? ");
INSERT INTO zosNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Y Jesusis 'yaṉdzoṉyaju: ―Macvøstøjcay hora ñø'it tumdum jama'is. O'ca tø vitpa jama'omo, ji'n tø quejca'ṉaje, porque jama sø'ṉgø'omo ndø ispa tuṉ. Jetseti ijtutøc usyna ø hora. ");
INSERT INTO zosNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero o'ca tø vitpa tzu'yi tø quejca'ṉajpa, porque ji'n syø'ṉnømi. ");
INSERT INTO zosNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jøsijcam ñøjayaj Jesusis: ―Ndø amigo Lázaro øṉbajcu. Pero ma'ṉbø mave va'cø ⁿyac sa'ø. ");
INSERT INTO zosNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Entonces ñøjayaj Jesús ñøtuṉdøvø'is: ―Øjtzø mi Ṉgomi, o'ca øṉu, mati vø'aje. ");
INSERT INTO zosNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pues Jesús jetse nømu: “Øṉbajcu” pero ca'upøte. Y pø'nis cyomo'yaju que nømu que viyuṉse øṉupøte, que nø syapøjcu. ");
INSERT INTO zosNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Entonces Jesusis chamdujcayaju ñøjayaju: ―Ca'upøte Lázaro. ");
INSERT INTO zosNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Y cajsøpyøjtzi aunque jay tø ijtamøna'ṉ jiṉø porque jetse masti vøj para mitzcøtoyata'm va'cø mi va'ṉjamdamø. De toda manera tø maṉdya'i jiṉø ijtumø Lázaro. ");
INSERT INTO zosNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Entonces Tomás, nøyi'ajque'tpapø mechipø, je'tis ñøjayaju ñøtuṉdøvø: ―Tø maṉdyaṉgue'te parejo va'cø tø ca'tam Jesusji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Entonces maṉyaj Jesús jiṉø ijtumø Lázaro. Y cuando nu'cyaju, nøjayajtøju que ijtumna'ṉ macscuy jama niptøjumø. ");
INSERT INTO zosNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Como Betania cumgu'is tyome'ispa Jerusalén gumguy, como media leguasye'ṉomodi ispa, ");
INSERT INTO zosNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","por eso vøti Israel pøn miñaju va'cø tyu'ñaj Marta y María va'cø jana más maya'yajø porque ca'u aṉcø tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Y cuando Marta'is myusu que nø minu Jesús, maṉ chove. Pero María tzø'y tyøjcomo po'csupø. ");
INSERT INTO zosNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Entonces Marta'is ñøjay Jesús: ―Ø Ṉgomi, o'ca mitz yø'cna'ṉ ijtu, ja cya'øna'ṉ ø andzi. ");
INSERT INTO zosNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero aunque ca'u'am, muspøjtzi que aunque ti mi ⁿvacpa Dioscøsi, Diosis mi ñchi'pa. ");
INSERT INTO zosNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesusis ñøjayu: ―Mi andzi maṉba visa'e. ");
INSERT INTO zosNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta'is ñøjayu: ―Muspøjtzi que maṉba visa ultimopø jama cuando visa'nømba. ");
INSERT INTO zosNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Pero Jesusis ñøjayu: ―Øjchøṉø yac visa'yajpapø'is ca'yajupø'am y øjchoṉø ndzi'ocuyajpapø'is quenguy. Va'ṉjambapø'is øjtzi, aunque ca'upø, maṉbatøc visa'que'te. ");
INSERT INTO zosNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Y aunque iyø quenbapøtøc y va'ṉjamba'is øjtzi, ji'n maṉ cya'e nuṉca. ¿Mitz mi vya'ṉjajmombaja jetse? ");
INSERT INTO zosNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Y Marta'is ñøjayu: ―Jø'ø, øjtzø mi Ṉgomi, va'ṉjambøjtzi que mijtzimete Cristo, Diosis mi 'Yune, na mapøtina'ṉ min nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jetse nømu Marta y entonces maṉ ñu'mvejay tyøvø María, ñu'mdzajmayu ñøjayu: ―Minu'am Maestro y nø mi ⁿñøveju. ");
INSERT INTO zosNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Prontocøtoya cuando myan yøcse, María te'ndontzu'ṉu maṉu Jesuscø'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Y Jesús ja tyøjcøyøtøcna'ṉ cumgu'yomo, pero jiṉdøcna'ṉ ijtu jut choṉumø Marta'is. ");
INSERT INTO zosNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jiṉna'ṉ ityaj Mariaji'ṉ tyøjcomo Israel pønda'm miñaju'is tyu'ñaje. Cuando isyaj María que pronto te'ndontzu'ṉu y pujtu, maṉ pya'tyaje. Nømyaju: ―Maṉ tzatøjcaṉvini va'cø cyøvo' tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pero ja jiṉ myavø sino Jesús maṉ chove. Y cuando nu'cu ijtumø Jesús, y isu Jesús, entonces María cutcøne'c Jesusis cyosocø'mø y ñøjayu: ―Ø Ṉgomi, o'ca mitz yø'cna'ṉ mi ijtu, ja cya'øna'ṉ ø andzi. ");
INSERT INTO zosNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Entonces Jesusis isu que María nø vyo'u, y Israel pø'nista'm maṉupø'is pya'tyaje, nømdina'ṉ vyo'yajque'tu. Y Jesús maya'u y nu'c choco'yomsye'ṉom toya. ");
INSERT INTO zosNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Y ñøjayaju: ―¿Jut mi ṉgojtam ca'upø? Ñøjayaju: ―Ma ndø a'mda'i. ");
INSERT INTO zosNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Vo'que'tuti Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Entonces Israel pøn nømyaju: ―A'mdamø jujche tyoya'ṉøpya Lázaro. ");
INSERT INTO zosNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Y vene nømyaju: ―Yøṉ pø'nis yac sø'ṉay to'tipø pø'nis vyitøm. ¿Ji'nacs na musina'ṉ yac tzoc Lázaro va'cø jana cya'ø? ");
INSERT INTO zosNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Entonces Jesús maya'que'tu, nu'que't hasta choco'yomsye'ṉom toya y nu'c ijtumø ca'upø tzatøjcø'mø. Quetza'ombø chatøcna'ṉete y pajtzaṉga'mupø tza'ji'n. ");
INSERT INTO zosNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús nømu: ―Yac tzu'ṉdam je tza'. Ca'upø'is tyøvø Marta'is ñøjayu: ―Øjchø mi Ṉgomi, nømocso vyøju porque yøti ijtu macscu jama cya'umø. ");
INSERT INTO zosNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesusis ñøjayu: ―¿Ji'nacs viyuṉse lo que jujche øtz mi nøjayuse øjtzi que o'ca mi ndø va'ṉjamba, maṉba mi isay jujche muspa chøc milagro'ajcuy Diosis? ");
INSERT INTO zosNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Entonces yac tzu'ṉyaj tza' pyajtzaṉga'myajupøji'ṉ tzatøc ijtumø ca'upø. Y Jesús quengui'm møji y nømu: ―Jatay, mi nøja'mbøjtzi yøscøtoya'm porque mi ndø majnayu'am ø onde. ");
INSERT INTO zosNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Y muspøjtzi que mumu jama mi ndø majnapya ø onde. Pero jetse nøja'mbøjtzi va'cø vya'ṉjamyaj tome te'ñajupø'is que mitz mi ndø cø'veju. ");
INSERT INTO zosNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jetse nø 'yo'nøyu'øc, Jesusis pømi vyejayu: ―Lázaro, puta'm. ");
INSERT INTO zosNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Y pøn ca'upøna'ṉ ca'ṉdonbujtu. Jujche mondøjuse ca'u'c, jetse pujtu, cyø' y cyoso monupø jujche myoñajuse ca'u'c y vyinaca monupø tucuji'ṉ. Jesusis ñøjayu: ―Mo'naṉvacø va'cø mus vyitø. ");
INSERT INTO zosNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Entonces sone Israel pø'nis oyupø'is pya'tyaj María, isyaj lo que jujche Jesusis chøjcuse y vya'ṉjamyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero vene maṉyaju va'cø maṉ chajmayaj fariseota'm lo que ti chøc Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Entonces pane covi'najøta'm y fariseota'm tu'myaju y nømyaju: ―¿Ti maṉba ndø tzøctame? Porque yøṉ pø'nis chøcpa sone milagro'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","O'ca ndø tzactamba y ji'n ndø ya'inductame, jic maṉba cøyin va'ṉjambø'tøji y Roma cumgu'yombø covi'najø'is maṉba cyø'vejyaj soldado va'cø yac tzu'ṉatyam ndø masandøc y ndø aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero ijtuna'ṉ tum pøn je'tomo ñøyipø'is Caifás, ñe'cø más myøja'ṉom aṉgui'mbapø pane jic ame'omo. Je'is ñøjayaj mumu cyovi'najø tøvø: ―Mitzta'm ni ti ji'n mi mustame. ");
INSERT INTO zosNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ni ji'n mi ndzøctam cuenda que vale más tø øtzcøtoyata'm va'cø cya' tum pøn ndø cumgucøtoya va'cø jana tocoy ndø Israel cumgutya'm. ");
INSERT INTO zosNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jetse cham Caifasis, pero Caifasis ja cham jetse ñe'c qui'psocupit. Sino como pane más myøja'ṉom aṉgui'mbapø jic ame, Diosis yac jajmeminu jujche va'cø chamø. Jetse chamu que Jesús maṉba ca'e mumu Israel pøngøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y ji'n sólo Israel pøngøtoya, sino también tumøpø va'ṉjajmocuy va'cø yac ñø'ityajø mumu lo que Diosis cyøpiṉyajupø va'cø 'yune'ajyajø aunque jut ityajupø. ");
INSERT INTO zosNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Entonces desde jic jama Israel covi'najø'sta'm qui'pscøpoyaju jujche va'cø yaj ca'yaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jetcøtoya Jesús ja vyit istøjpamø Judea nasomo, sino maṉ ijtumø tum cumguy ñøyipø'is Efraín tome ispamø ja ijnømømø, y jiṉ tzø'yu ñøtuṉdøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Y nømna'n tyome'aj Israel pø'nis syøṉ ñøyipø'is pascua. Y vøti pøn emøc ityajupø miñaj Jerusalén gumgu'yomo antes que nu'cpa søṉ. Miñaju va'cø cyøtze'yaj vyin como seña que cøvajcøyaju'am Diosis vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Entonces mye'chaj Jesús. Y mientras te'ñajuna'ṉ masandøjcomo, na ñøjayajtøju: ―¿Ti mi ṉgui'pstamba? ¿Será que minba o ji'n mini sø'ṉomo? ");
INSERT INTO zosNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Y pane covi'najø'ista'm y fariseo'sta'm cyotyaj aṉgui'mguy i'is ispa Jesús va'cø cyøtza'møyaj jut ijtu va'cø mus ñucyajø. ");
INSERT INTO zosNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Cuando faltatøcna'ṉ tujtay jama va'cø cho'tz pascua sø'ṉajcuy, entonces Jesús min Betania cumgu'yomo. Betania cumgu'yomo ijtuna'ṉ Lázaro lo que oyupø yac visa' Jesusis cuando ca'u'c. ");
INSERT INTO zosNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Y jiṉø chøjcayaj Jesús cu'taṉbajcuy y cu'tcuchøjcu Marta, y Lázaro po'cs mesacø'mø Jesusji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Y Maria'is ñømin como medio litro jasocuy suñi viquicpapø nardopø perfume caro coyojapø, jetji'ṉ Maria'is jyajsay Jesusis cyoso, y cyømojcay cyoso vyayji'ṉ. Y vyiquijcoctas tøc perfume'is. ");
INSERT INTO zosNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jendina'ṉ it Judas Iscariote, Simo'ṉis 'yune, Jesusis ñøtuṉdøvøte. Más jøsijcam Judasis chi'ocuyaj Jesús 'yenemigo'is cyø'omo. Y Judas nømu: ");
INSERT INTO zosNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Ti'ajcuy ja mya'ay yøṉ jasocuy, tumin va'cø chi'yaj pobreta'mbø pøn? Porque valetzøcpa vøti pesu. ");
INSERT INTO zosNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas ja ñøm jetse porque sunbana'ṉ cyotzoṉyaj pobre, sino porque nu'mbapøte y je'sna'ṉ ñø'ijtu tumingotcuy y ñu'mba Jesusis ñøtuṉdøvø'is tyumin. ");
INSERT INTO zosNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Entonces Jesusis ñøjay Judas: ―U 'yojnayø yomo. Je'is 'yaṉne'cuna'ṉ yøṉ jasocuy va'cø jyasay ø ⁿvin antes que ma'ṉbø niptøji. ");
INSERT INTO zosNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Porque pobreta'mbø mumu jama ityajpa mitzji'ṉ, pero øtz ji'n ma it mitzji'ṉ mumu jama. ");
INSERT INTO zosNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Entonces vøti Israel pø'nista'm myusyaju que jen ijtu Jesús Betania cumgu'yomo y jiṉ maṉyaju. Pero ji'n sólo maṉyaj Jesús va'cø isyajø, sino maṉaju va'cø a'myajque't Lázaro lo que opøm ca'e y visa'u. ");
INSERT INTO zosNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pero pane covi'najøta'm tzamdu'mbajcayaju va'cø yaj ca'yajque'tati Lázaro. ");
INSERT INTO zosNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Porque Lázaro visa'u aṉcø, sone Israel pø'nis nømna'ṉ chacpø'yaj pane covi'najø va'cø maṉ vya'ṉjamyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jyo'pit ityajuna'ṉ sone pøn miñajupø søṉgøtoya, y myañaju que Jesús nø myinu Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Y tucyaj palma ay y maṉ choṉyaj Jesús, y vejyaju: ―Yøṉete tø yaj cotzocpapø'is. Tø vøcotzøcta'i Israel pø'nis 'Yaṉgui'mbata'm nø minupø ndø Comi Diosis ñøyicøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Y Jesusis pya'tu tum burro unepøtøc y jetcøs po'csu, porque jetseti jachø'yupø Diosis libru'omo. Jen chamba: ");
INSERT INTO zosNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","U ña'tztamu mi Sión cumgu'yomda'mbø'is. A'mø: nø minu mi Aṉgui'mbata'm, pocsupø unepø burrocøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pero a la hora tujcu jetse, Jesusis ñøtundøvø'is ja cyønøctøyøyaja'm que nøm tyuc como jachø'yuse. Pero después que Jesús visa'u y maṉ tzajpomo, entonces jyajmu chøcyaju que jetseti it jachø'yupø jujche maṉba tuc Jesús, y jetse tujcu. ");
INSERT INTO zosNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jiṉ ityajupø'is isyajupø'is jujche vyejtzu'ṉu tzatøjcomo Lázaro ndø Comi'is y yac visa'u, je'is chamyaj lo que isyajuse jujche yac visa' Lázaro ndø Comi'is. ");
INSERT INTO zosNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Y porque myañaju que chøc jetsepø milagro'ajcuy, por jetcøtoya pø'nista'm maṉ choṉyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseo pønda'm nay ñøjayajtøju: ―A'mdamø; ndø istamu'am que ni ti ji'n mus ndø tzøctamø. A'mdamø jujche mumu pø'nis maṉ pya'tyaje. ");
INSERT INTO zosNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ityajque'tu griego pønda'm oyajupø va'cø cyøna'tzøyaj Dios sø'ṉomo Israel pønji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jic griego pø'nis cyønu'cyaj Felipe, Betsaida cumgu'yombø, Galilea nasombø y ñøjayaju: ―Nø sun a'mdam Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Entonces Felipe'is maṉ chajmay Andrés, y Andres'is y Felipe'is maṉ chajmayajque't Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Y Jesusis 'yaṉdzoṉyaju nøjmayaju: ―Yøti nu'cu'am hora va'cø møja'ṉo'majøjtzi mumu Pø'nis chøṉ Tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Viyuṉsye mi nøjandya'mbøjtzi: Tømbu o'ca ji'n ndø nipi nascøsi, itpa tyumgø'y, pero o'ca quecpa nascøsi, napya y más vøti'ajpa tyøm. Jetse øtz tiene que va'cø ca'que'tati va'cø niptøjø y va'cø vi'sa'que'ta va'cø vøti'ajyaj va'ṉjambapø'stzi. ");
INSERT INTO zosNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Por eso tyoya'ṉøpya'is vyin yø'qui y ji'n sun cya'ø, tocopya. Pero chi'ocuyajpa'is vyin yø'c nascøsi, pya'tpa quenguy mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Y sunbapø yos øjtzøcø'mø, tiene que va'cø min pa'tø. Y jut it øjtzi, jendi maṉba itque'te y lo que yospapø øjtzøcø'mø; jet maṉba vyingot ø Janda'is. ");
INSERT INTO zosNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","”Yøti nø maya'u y ji'n mus ti ndzamø. ¿Será que maṉba nømi: “Jatay, tø yaj cotzoca va'cø jana nøṉgøt toya”? Pues ji'n ma nøm jetse porque jetcøtoyam chø minu. ");
INSERT INTO zosNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mejor ma'ṉbø nømi: “Jatay, yac møja'ṉomaj mi nøyi”. Entonces maṉdøj ote tzajpom tzu'ṉupø nømu: ―Møja'ṉgotzøjcu'mtzi ø nøyi, y ma'ṉbatøc vøco møja'ṉo'majque'te. ");
INSERT INTO zosNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jiṉ ityajupø'is myañaju ote y vene nømyaju que a'ṉøy rayu. Vene nømyaju que angelesis 'yo'nøyu. ");
INSERT INTO zosNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesusis ñøjayaju: ―Ja chamdøj yøṉ ote para øtzcøtoya, sino para mitzcøtoyata'm tzamdøju. ");
INSERT INTO zosNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yøti maṉba yaj co'aṉgøyaj Diosis yøṉ nascøsta'mbø. Yøti maṉba pyatzpø Diosis yatzi'ajcuy porque je'is yach aṉgui'mba nascøsta'mbø pøn. ");
INSERT INTO zosNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Cuando øtz yaj qui'myajpa cruzcøsi, jetse øtz ma'ṉbø yac minbø'yaj mumu pøn øtzcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jetze cham Jesusis va'cø yac musyaj mumu pøn jujche maṉba ca'e. ");
INSERT INTO zosNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Y pø'nis ñøjayaj Jesús: ―Manda'møjtzi que Diosis 'yaṉgui'mgu'yomo it jachø'yupø que Cristo itpa yø'c nascøsi para mumu jamacøtoya. ¿Entonces ti'ajcuy mi ñømba: “Øtz mumu Pø'nis chøṉ Tyøvø, tiene que øtz va'cø yaj qui'mdøj cruscøsi va'cø cya'ø”? Entonces o'ca mitz maṉba mi ṉgya'e, entonces mitz ji'ndocsyo mi Ṉgristo. ");
INSERT INTO zosNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Y Jesusis ñøjayaju: ―Usyomdim maṉba it øjtzi mitzji'ṉdam como sø'ṉgøse, va'cø mi yac mustam viyuṉsyepø tiyø. Vijtamø mientras que sø'ṉnømba, no sea que mitz ṉgyøpi'tzø'øtyamba; porque o'ca tø vitpa pi'tzø'omo, ji'n tø mus jut nø tø ma'ṉøyu. ");
INSERT INTO zosNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mientras que øtz itpa mitzji'ṉda'm como sø'ṉgøse, tø va'ṉjamdam ndøvø va'cø mi ijtam como sø'ṉgø'ombø pønseti. Jetsetøc nø chamu'c Jesusis, maṉu, y cyøvø'n vyin. ");
INSERT INTO zosNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Aunque Jesusis chøc sone milagro'ajcuy je'tis vyi'nomda'm, pero ja vya'ṉjamyajø. ");
INSERT INTO zosNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jetse viyuṉaju jujche chamuse tza'maṉvajcopapø Isaiasis. Isaiasis chamu: Øjtzø mi Ṉgomi, ni i'is ja vya'ṉjajmø øtz ndza'maṉvajcuse mi onde; Ni i'is ja cyønøctøyøy que mitz ndzøjcu milagro'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Por eso ja mus vya'ṉjamyajø, porque Isaías nømgue'tu: ");
INSERT INTO zosNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Je'tis yac to'ti'ajyaju y yac nu'yu'ajyaj chocoy va'cø jana isoyaj vyitømji'ṉ, ni va'cø jana cyønøctøyøyaj choco'yomda'm, ni va'cø jana qui'psvitu'yajø, va'cø jana øtz yac tzocyajøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jetsepø tiyø cham Isaiasis cuando omna'ṉ isay Jesusis myøja'ṉo'majcuy y oyu chame jujche ma chøqui. ");
INSERT INTO zosNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Aunquena'ṉ jetse, sone covi'najø'is oyuti vya'ṉjamyaj Jesús. Pero ja chamyajø o'ca vya'ṉjamyaju porque ña'chaj fariseo pønda'm. O'ca chamyajøna'ṉ que vya'ṉjamyaj Jesús, fariseo'is ji'na'ṉ ma yac tøjcøyaj conocscutyøjcomo. Por eso ja syun chamyajø que vya'ṉjamyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Así es que jetse syuñajpana'ṉ va'cø vya'ṉjamyaj pø'nis que vøjpø ti nø chøcyaju ñe'cø. Pero ji'na'ṉ chi'yaj cuenta o'ca Diosis vya'ṉjamba que vøjpø ti nø chøcyaju. ");
INSERT INTO zosNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Entonces pømi vejvejney Jesús, nømu: ―El que va'ṉjambapø'is øjtzi, ji'n sólo øtz va'ṉjajme, sino que vya'ṉjajmgue'tpati cø'vejupø'is øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ispa'is øjtzi, isque'tpa cø'vejupø'is øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mi'nøjtzi como tum sø'ṉgøse nascøsi va'cø yac musyaj viyuṉsepø tiyø, va'cø jana it como pi'tzø'ajcu'yomse va'ṉjambapø'is øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","O'ca aunque i'is myanba øtz ndzambase, y ji'n vya'ṉjajme, øtz ji'n ma yaj coja'aje. Porque ja mi'nøjtzi nascøsi va'cø yaj coja'ajyaj nascøsta'mbø pøn, sino mi'nøjtzi va'cø min yaj cotzocyajø. ");
INSERT INTO zosNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","O'ca pø'nis ji'nø pøjcøchove, y ji'n vya'ṉjam øtz ndzambase, it i'is yaj coja'ajpa. Ø ondecøtoya maṉba yaj coja'ajtøji ultimopø jama o'ca ja vya'ṉjajmay ø onde. ");
INSERT INTO zosNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Porque øtz ja ñcha'mø ø ne'ṉgø, sino ø Janda'is cø'vejupø'stzi, je'is aṉgui'm øjtzi jujche va'cø ndzamø. ");
INSERT INTO zosNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Y muspøjtzi que vya'ṉjamyajpapø'is Diosis 'yaṉgui'mguy, queñajpa mumu jamacøtoya. Lo que øtz ndzambapø tiyø, jujche ø Janda'is tzajmay øjtzi, jetse ndzamgue'tpøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nømna'ṉ tyome'aj pascua søṉ. Jesusis myusu que nømna'ṉ ñu'c 'yora va'cø chu'ṉ nascøsi va'cø myaṉ Jyata ijtumø. Jesusis syungo'ñaj ñe' pyønda'm lo que ityajupø nascøsi. Nømna'ṉ syungo'ñaj de veras mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Cu'taṉjeju'cam, yatzi'ajcu'is yac mijnay qui'psocuy Judas va'cø chi'ocuyaj Jesús 'yenemigo'is cyø'omo. Yøṉ Judas Simón Iscariote'is 'yunete. ");
INSERT INTO zosNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesusis myusu que Jyata'is chi' aṉgui'mguy mumu ticøsi. Y myusque'tu que tzu'ṉ Diosmø, y jiṉdi nø myaṉgue't chu'ṉumø. ");
INSERT INTO zosNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Cu'taṉjeju'cam, te'nchu'ṉu, chac vingøspø tyucu, pyøc tovaya, y vyajtøy chejcøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jøsi'cam Jesusis tyejcøy nø' punchera'omo y nøcøtzo'tzu va'cø cyosche'yaj ñøtuṉdøvø y va'cø cyømojcayaj cyoso tovayaji'ṉ lo que vajtupøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Entonces nu'cu Pedrocø'mø, y Pedro'is ñøjay ndø Comi: ―Øjtzø mi Ṉgomi, ¿será mitz maṉba mi ndø cøtze'ay ø ṉgoso? ");
INSERT INTO zosNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesusis 'yaṉdzoṉu ñøjayu: ―Ji'n mi mus yøti lo que ti nø ndzøjcu. Pero maṉba mi mus jøsijcam. ");
INSERT INTO zosNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pero Pedro'is ñøjayu: ―Øjtzi nunca ji'n ma mi ndø cøtze'ay ø ṉgoso. Jesusis 'yaṉdzoṉu: ―O'ca ji'n mi ṉgøtze'aye, ji'n ma mi it øtzji'n. ");
INSERT INTO zosNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro'is ñøjayu: ―Øjtzø mi Ṉgomi, u na's saṉ ø ṉgoso tø cøtze'aye, sino también tø cøtze'ay ø ṉgø' y ø ṉgopac. ");
INSERT INTO zosNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Y Jesusis ñøjayu: ―O'ca i tziṉu'am, ji'ndyet pyena va'cø yac tziṉvøjøtzøcø mena'como. Namas que cyoso va'cø yac tze'a y tzø'pya cøvajcupø tyumø coṉña. Y mitzta'm ṉgyøvajcøtyamu'am, pero ja mumu mi ṉgyøvactamø. ");
INSERT INTO zosNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jetse nømu porque Jesusis myusu i'is maṉba chi'ocuyaje, y por eso nømu: “Ja mumu mi ṉgyøvajcøpø'tamø”. ");
INSERT INTO zosNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Entonces cyøtze'ayaju'cam cyosota'm, jøsijcam myesque't tyucu, po'csque'tu, y ñøjayaju: ―¿A ver o'ca mi mustamba ti ndzøjcøjtzi? ");
INSERT INTO zosNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mi ndø nøjatyamba: “Ø mi Maestrota'm, ø mi Ṉgomita'm”. Y vøjti jetse mi ndø nøjandyamba. Porque øjche viyuṉse mi ndø Maestrota'm y mi ndø Ṉgomita'm. ");
INSERT INTO zosNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Como øjchøṉ mi ndø Comita'm y Maestrota'm, y øtz ṉgøtze'atyam mi ṉgosota'm, entonces vøjø jetseti igualti va'cø mi ndzøctaṉgue'ta va'cø na ñø ṉgøtze'atyandøj mi ṉgoso. ");
INSERT INTO zosNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jetse mi isindzi'tamu va'cø mi ndzøctamø jujche øtz mi ndzøjcatyamuse. ");
INSERT INTO zosNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Viyuṉse mi nøjandya'mbøjtzi: tum coyospapø ji'n más myøja'ṉombø que cyomi. Y tum nu'cscuy ji'n myøja'ṉombø como cyø'vejupø'is. ");
INSERT INTO zosNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Como mi mustamba lo que øtz mi ndzajmatyambapø, mi 'yomba ijtamba o'ca mi ndzøctamba jetse. ");
INSERT INTO zosNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","”Lo que jujche øtz ndzambase, ji'n mumu mi jendzeta'm. Muspøjtzi i ṉgøpi'ṉøjtzi. Pero tiene que va'cø tyucø jujche ijtuse jachø'yupø Diosis libru'omo. Jen chamba: “Cu'tpapø øtzji'n yachvitu' øtzcøsi”. ");
INSERT INTO zosNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yøti nø mi ndzajmatyam vi'nati jujche ma tuqui, entonces cuando jujchøc jetse tucpa, maṉba mi va'ṉjamdame que øj chøṉø Diosis cø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Viyuṉse mi nøjandya'mbøjtzi, o'ca mi mbøjcøchoṉba øtz ṉgø'vejupø, entonces misma hora mi ndø pøjcøchoṉgue'tpa ndøvø. Y o'ca mi ndø pøjcøchoṉba, misma hora mi mbøjcøchoṉgue'tpa cø'vejupø'is øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesusis chamu jetse y después maya'co'nu y nu'c choco'yomsye'ṉom toya. Y ñøjmayaju: ―Viyuṉse mi nøjandya'mbøjtzi; it mijtzomda'm tum maṉbapø'is tzi'ocuyaje. ");
INSERT INTO zosNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Y ñøtuṉdøvø na ñø a'myajtøju, nømdina'ṉ qui'psyaju: “¿I'se ma chi'ocu'yaje?” ");
INSERT INTO zosNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Y ijtuna'ṉ tum ñøtuṉdøvø Jesusis syungomø'nupø. Tome po'csu Jesuscø'mø y jetcøs te'tzu. ");
INSERT INTO zosNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Por eso Simón Pedro'is chøjcay seña je nøtuṉdøvø va'cø 'yaṉgøva'c Jesús a ver iye nø chamupø. ");
INSERT INTO zosNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Y Jesuscøs cyøte'tzupø'is ñøjayu: ―Ø mi Ṉgomi, ¿i'is maṉba mi ñchi'ocuyaje? ");
INSERT INTO zosNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesusis 'yaṉdzoṉu ñøjayu: ―I ndzi'pøjtzi pan matzcønuṉupø, ji'quisete. Entonces Jesusis myatzcønuṉ pan y chi' Judas Iscariote, Simo'nis 'yune. ");
INSERT INTO zosNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Cuando cyu'tujcam pan, Satanás tøjcøy Judasis choco'yomo. Entonces Jesusis ñøjay Judas: ―Tzøc jø'nøti lo que maṉbapø mi ndzøqui. ");
INSERT INTO zosNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mesacø'mø po'csyajupø, ni i'is ja cyønøctøyøy ticøtoya jetse ñøjay Judas. ");
INSERT INTO zosNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Como Judasis 'yaṉnecpana'ṉ tumin, vene'ṉomo cyomo'yaju que Jesusis ñøjayu: “Ma juy lo que ndø sundambapø para søṉgøtoya”, o va'cø chi'yaj tumin pobre. ");
INSERT INTO zosNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasis cyu't pan y put a'ṉgomo; y tzu'imna'ṉ ");
INSERT INTO zosNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Entonces maṉu'jcam Judas, Jesús nømu: ―Øjchøṉ mumu Pø'nis Tyøvø, yøti maṉba istøj ø møja'ṉo'majcuy aunque ma'ṉbø ca'e. Y por øtzpit maṉba istøj Diosis myøja'ṉo'majcuy. ");
INSERT INTO zosNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Como Diosis myøja'ṉo'majcuy nø istøj øtzpit, jetse Diosis nø yac istøj ø møja'ṉo'majcuy y prontoti maṉba istøje. ");
INSERT INTO zosNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ø mi unenda'm, usyaṉ hora na matøc it mitzji'ṉda'm. Maṉba mi ndø me'tztame, pero jut ma'ṉbøjtzi, ji'n mus mi mya'ṉøtyamø. Jetse ⁿnøjayajøjtzi Israel pønda'm, y jetse mi nøjandyaṉgue'tpa mijtzi yøti. ");
INSERT INTO zosNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mi ndzajmatyaṉgue'tpøjtzi jomepø aṉgui'mguy; hay que va'cø mi na syundandøj mi ne'ṉgomda'm. Jujche mi sundamba øjtzi, jetse va'cø mi na syundandøjque'ta mi ne'ṉgomda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","O'ca mi na syundandøjpa, jetse aunque i'is maṉba myusyaje que viyuṉsye mitz ø mi nønduṉdøvøta'm porque na mi ñø sundandøjpa aṉcø. ");
INSERT INTO zosNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Entonces Simón Pedro'is ñøjayu: ―Ø mi Ṉgomi, ¿jut nø mi myaṉu? Jesusis 'yaṉdzoṉu ñøjayu: ―Jut ma'ṉbøjtzi, ji'n mus maṉ mi ndø pa't yøti, pero maṉba mi ndø pa't jøsijcam. ");
INSERT INTO zosNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro'is ñøjayu: ―Ø mi Ṉgomi, ¿ti'ajcuy ji'n mus maṉ mi mba't yøti? Øtz dispuesto va'cø ca'ø mitzcøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesusis 'yaṉdzoṉu: ―¿Viyuṉsyejacsque't mi ñchamba que mitz dispuesto va'cø mi ṉgya'ø para øtzcøtoya? Viyuṉse mi nøja'mbøjtzi que antes que vejpa ṉgaylu, tu'cañac maṉba mi ndø cøsutzi. ");
INSERT INTO zosNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","U mi myaya'ndamu, va'ṉjamdam Dios y ndø va'ṉjamdam øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ø Janda'is tyøcmø it vøti lugar jut muspamø tø itø. Mi ndzajmatyamumna'ṉtzi o'ca ji'na'ṉ jetse, ma'ṉbø vindu'ṉaje va'cø mi vøjøtzøjcatyam itcuy. ");
INSERT INTO zosNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Como øtz ma'ṉbø mave y ma'ṉbø mi vøjøtzøjcatyam itcuy, ma'ṉbø miṉguete, y øtz ma'ṉbø mi nømaṉdam øjtzi. Y jendi maṉba mi ijtaṉge'te jut maṉbamø it øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mitz mi mustamba jut ma'ṉøpøjtzi y mi istamba tuṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasis ñøjay Jesús: ―Ø mi Ṉgomi, ¿qué tal øtz ji'n ma isatyam mi nduṉ jut mi mya'ṉøyu? Ja it jujche istamba tuṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ñøjay Jesusis: ―Øjchøṉ mi isiṉdzi'tambapø'is tuṉ. Øjchøṉ mi ndzajmatyambapø'stzi viyuṉsebø tiyø. Øjchøṉ mi yaj quendambapø'is. Mientras que o'ca øtz ji'n nømave, ni i ji'n mus maṉ ndø Jandamø. ");
INSERT INTO zosNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","O'ca mi ndø comuspana'ṉ ndøvø, mi ṉgomusque'tpatina'ṉ ø Janda. Hasta yøti nø mi ṉgomuscho'tztam ø Janda y mi istamu'am. ");
INSERT INTO zosNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Entonces Felipe'is ñøjayu: ―Øjchø mi Ṉgomi, tø isiñdzi ndø Janda, jetse contento'ajta'mbøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesusis ñøjayu: ―Felipe, ya'møjcam ijtzo'tzøjtzi mitzji'nda'm y ¿ti'ajcuy ji'ndøc mi ndø comusi? Ispa'is øjtzi, hasta ispa ndø Janda. ¿Entonces ticøtoya mi ndø nøjapya va'cø mi isindzi ndø Janda? ");
INSERT INTO zosNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ticøtoya ji'n mi va'ṉjajme que øtz ijtu ndø Janda'is choco'yomo y ndø Janda ijtu ø ndzoco'yomo? Lo que øtz ndzambapø, ji'nø ndzam ø ñe'c ø ṉgui'psocuji'ṉ. Ndø Janda ø ndzoco'yom ijtupø, je'is chøcpa ñe' yoscuy. ");
INSERT INTO zosNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tø va'ṉjamda'mø ndøvø que øtz nø'ijtay ndø Janda'is chocoy y ndø Janda'is ñø'ijtay ø ndzocoy. Pero o'ca ji'n sun mi ndø va'ṉjamdam jetse, si quiera tø va'ṉjamdamø porque øtz ndzøjcapya ndø Janda'is yoscuy. ");
INSERT INTO zosNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Viyuṉsye mi nøjandya'mbøjtzi: va'ṉjajmba'is øjtzi chøjque'tpati jujche øtz ndzøcpase. Y matøc chøjque't va'ṉjamba'is øjtzi más myøja'ṉomda'mbø tiyø porque øtz ma'ṉbø maṉ jut ijtumø ndø Janda. ");
INSERT INTO zosNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Y aunque ti mi ⁿva'ctamba ø nøyiṉgøsi, øtz ndzøcpøjtzi. Y como øtz ndzøjcapya ndø Janda'is yoscuy, jetse maṉba isatyøj ndø Janda'is myøja'ṉo'majcuy porque øjchøṉ 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Øtz ndzøcpa aunque ti mi ⁿva'ctamba ø nøyiṉgøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","”O'ca mi ndø sundamba, tzøctam jujche øtz mi aṉgui'mdambase. ");
INSERT INTO zosNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Y øtz maṉba ⁿva'c ndø Jandacøsi y je'is maṉba mi ṉgyø'vejatyam eyapø Cotzo'ṉopyapø va'cø it mumu jama mitzji'ṉda'm. Jic Cotzo'ṉopyapø Masanbø Espiritu Santote viyuṉsepø ti mi ⁿyaj cønøctøyøtyambapø'is. ");
INSERT INTO zosNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ji'n vya'ṉja'moyajepø pø'nis ji'n mus pyøjcøchoṉyaj Masanbø Espiritu. Porque ji'n chøjcayaj cuenda Espiritu masanbø ni ji'n cyomusyaje. Pero mitzta'm mi ṉgomustamba'm, porque Masanbø Espiritu Santo it mitzji'ṉda'm y maṉba it mi ndzoco'yomda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Øtz ji'n ma mi ndzajcoctuctame, mati vitu'que'te, mati it mitzji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Usaṉ oracøsi ji'n va'ṉjamyajepø'stzi ji'nam maṉ isyaje nunca, pero mitz maṉba mi ndø istame como siempre. Porque øtz it ø ṉguenguy, por eso jetseti mitz maṉba itque't mi ṉguenguy. ");
INSERT INTO zosNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jic jama maṉba mi mustame que øtz ijtu ø Janda'is choco'yomo y mitz mi ijtamba ø ndzoco'yomo, y øtz ijtøjtzi mi ndzoco'yomda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Comusapyapø'is ø aṉgui'mguy y tzøjcapapø'is ø aṉgui'mguy, je'is su'nbøjtzi y ø Janda'is syunba en que sunba'is øjtzi, y øtz tambien mati sunque'te y ma'ṉba yaj comus ø ⁿvin i chøṉø. ");
INSERT INTO zosNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ñøjayu Judasis, pero ji'ndyet Judas Iscariote: ―Ø mi Ṉgomi, ¿ticøtoya maṉba mi ndø yaj comusatyam mi ⁿvin, y ji'n ma mi yaj comusayaj mi ⁿvin ji'n mi vya'ṉjamyajembø'is? ");
INSERT INTO zosNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesusis 'yaṉdzoṉu: ―I'is su'nbøjtzi, cyøna'tzøpya lo que øtz ndzambase. Y ø Janda'is maṉba suni jicø pøn sunbapø'is øjtzi. Y øtz ma'ṉbø mindam ø Jandaji'ṉ va'ṉjajmopapø pønji'ṉ va'cø ijtamø. ");
INSERT INTO zosNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ji'n ø sunipø'is, ji'n chøjcay cuenda lo que ti ndza'mbøjtzi. Lo que ti mi ndzajmatyamba øjtzi, ji'ndyet ø ne'. Ø Janda'is cø'vejupø'stzi, je'is tzajmapyøjtzi ti ndza'mbøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","”Nø'mø mi ndzajmatyam yøcseta'mbø tiyø mientras que yø'c ijtøjtzi mitzji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero ndø Janda'is maṉba cyø'vej Espiritu Santo ø nøyiṉgøsi va'cø mi ṉgyotzoṉdamø. Je'is maṉba mi 'yaṉmandyam mumu ticøsi. Y je'is maṉba mi yac jamemindame lo que ti øtz oyupø mi ndzajmatyame. ");
INSERT INTO zosNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","”Mi o'nøyundzacta'mba y ø ne'ṉgø mi yaj contento'ajta'mbøjtzi, aunque como ijnømbase nascøsi ji'n mi ijtam contento. Pero øtz mi yaj contento'ajtamba viyuṉsye. U mi myaya'ndamu ni u mi ña'tztamu. ");
INSERT INTO zosNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mi ndø mandamu'am que nø nømu nø'ø maṉu, y matøc vitu'que'te va'cø min it mitzji'ṉda'm. O'ca viyuṉsye mi ndø sundambana'ṉ, mi ṉgyasøtyamuna'ṉ cuando øtz nø mi nøjandyamu que nø maṉ ndø Jandamø. Porque ndø Janda más myøja'ṉombø que øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nø mi ndzajmatyamu yøṉ vi'na. Entonces cuando jetse tucpa, maṉba mi ndø va'ṉjamdame. ");
INSERT INTO zosNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","”Ji'nam ma vejvejney más mitzji'ṉda'm. Porque nø min nascøsi yachaṉgui'mbapø, pero je'is ji'n mus aṉgui'm øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero jetse ndzøcpøjtzi lo que aṉgui'mbase ndø Janda'is va'cø myusyaj nascøsta'mbø'is que øtz su'nbøjtzi ndø Janda. Te'ṉchu'ṉdamø, tø maṉdya'i emøc. ");
INSERT INTO zosNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","”Øjchøṉ como viyuṉsepø uva tzasyepø, y ø Janda como cuidatzøcpapø'is uva nipi. ");
INSERT INTO zosNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Cuando aṉmaṉ ji'n tyø'møyi, tyøcspø'yajpa; jetse mumu pøn øtzji'ṉ ijtupø o'ca ji'n it vøjø, Diosis maṉba pyatzpø'i. Mumu aṉmaṉ ji'n tø'majepø øtzji'ṉ maṉba tyøcspø ø Janda Diosis. Y mumu aṉmaṉ lo que tø'majpapø, cyøyosyajpa va'cø cøvajcupø tzø'yø y va'cø más tyø'majø; jetsetique't mumu pøn vøj itpapø, Diosis cyøyosapya chocoy va'cø más vøj itø. ");
INSERT INTO zosNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mitzta'm ṉgyøvajcøtyamu'am porque mi ṉgøma'nøtyam lo que øtz ndzamuse. ");
INSERT INTO zosNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mumu jamase øtzji'ṉ ijtamø, y øtz itpøjtzi mitzji'ṉda'm. Como aṉmaṉ o'ca ji'n it pyo'jcøsi, ji'n tyø'maje, y jetze mitzta'm o'ca ji'n mi ijtam øtzji'ṉ, ji'n mus mi ijtam vøjø. ");
INSERT INTO zosNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","”Øjchøṉø como po'c y mitz como aṉmaṉseta'm. O'ca øtzji'ṉ mi ijtamba mumu jamase, y øtz itpa mitzji'ṉda'm, entonces muspa mi ijtam vøjø como aṉmaṉ tø'møpyase. O'ca ji'n mi ijtam øtzji'ṉ, ni tiyø ji'n mus mi ndzøctamø. ");
INSERT INTO zosNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","O'ca aṉmaṉ ji'n tø'maje, tø'cspø'tøjpa, yu'co'tzcøne'cpa, y tøtzpa, y pyiṉyajpa y pyatzca'mbø'yajpa juctyøjcomo y pyoṉbø'yajpa. Y jetsetique't tucpa pøn o'ca ji'n it øtzji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","”O'ca mi ijtamba øtzji'ṉ y o'ca ø onde tzø'pya mi ndzoco'yomo, entonces muspa mi ⁿva'c ti mi sundamba, y maṉba mi nchi'tandøji. ");
INSERT INTO zosNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","O'ca mi ijtamba vøjø es como tum cuy vøj tø'møpyapø, y entonces maṉba isaytøji que ndø Janda myøja'ṉombøte. Porque mitz 'yuneta'm y mi ndzøctamba vøjpø tiyø, y mitzta'm maṉba mi ijtam øtzcø'mø va'cø mi aṉmandyamø. ");
INSERT INTO zosNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jujche ndø Janda'is ø sunbase øjtzi, jetse øtz mi sundaṉgue'tpøjtzi. Jetse hay que va'cø mi seguitzøctamø va'cø mi su'notyamø jujche øtz mi sundambase. ");
INSERT INTO zosNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","O'ca mi ndzøctamba jujche øtz mi aṉgui'mdamuse, jetse maṉba mi seguitzoctam va'cø mi su'notyamø como øtz mi sundambase; como øtz ndzøjque'tpøjtzi jujche ø Janda'is aṉgui'muse, y jetse seguitzøcpøjtzi va'cø su'noya jujche ø Janda'is sungue'tpøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","”Jetse o'yø mi ndzajmatyame va'cø mi ṉgyasøtyamø jujche øjtzi mi yaj casøtyambase, y va'cø mi ṉgyasøtyam viyuṉsye. ");
INSERT INTO zosNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nø mi aṉgui'mdamu va'cø na mi nø sundandøj parejo, jujche øtz mi sundamuse. ");
INSERT INTO zosNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Chi'ocuyajpapø'is vyin va'cø cyoca' tyøvø, jetsepø pø'nis más syunba tyøvø. Ni i'is ji'n más syun tyøvø que ji'quis. ");
INSERT INTO zosNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mitzta'm øjchøṉ amigota'm o'ca mi ndzøctamba lo que jujche øtz mi aṉgui'mdambase. ");
INSERT INTO zosNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yøti ji'nø nømi que mitzta'm ø mi ndzøsita'm, porque chøsi'is ji'n musi ti nø chøc cyomi'is, pero mitzta'm øjchø ndøvøda'm porque mi ndzajmatya'mbøjtzi mumu lo que ø Janda'is tzajmayupø. ");
INSERT INTO zosNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mitzta'm ja mi ndø cøpiṉdam øjtzi, øtz mi ṉgøpiṉdam mijtzi. Y mi ndzamdzi'tamu va'cø mi myaṉdamø y va'cø mi ndzøctam vøjpø tiyø, y va'cø jana yaj vøjpø ti mi ndzøctambase. Entonces ø Janda'is maṉba mi ñchi'tam mumu lo que mi ⁿva'ctamba ø nøyiṉgøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nø'mø mi aṉgui'mdamu va'cø mi na ñøsundandøj mi ne'cta'm. ");
INSERT INTO zosNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","”O'ca ji'n vya'ṉjajmoyajepø pø'nis mi ṉgui'satyamba, cønøctyøyøtyamø que jetsepø pø'nis o qui'sayaj øtz vi'na, y jøsijcam mijta'm o mi ṉgui'satyaṉgue'te. ");
INSERT INTO zosNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","O'ca mitz jetsena'ṉ mi ijtamba como ji'n vya'ṉjajmoyajepø pønse, entonces jetsepø pø'nis mi syundamuna'ṉ como syuñajpase tyøvø. Pero øtz mi ṉgøpiṉda'møjtzi va'cø jana jetse mi ijtamø aunque jujchepø pønse. Por eso mi ṉgui'satyamba ji'n vya'ṉjajmoyajepø pø'nis. ");
INSERT INTO zosNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Jamdamø jujche mi ndzajmatyamuse. O'yø mi nøjandyame: “Tum coyospapø ji'n más møja'ṉ aṉgui'mi que cyomi”. Por eso o'ca yacsutzøcyajpøjtzi, como øjtzø mi ndø Comi, entonces mati mi ⁿyacsutzøctaṉgue'te mijtzi como mitz ø mi ṉgoyospapø. O'ca pø'nis chøcyajpa lo que jujche øtz ndzajmayajuse, entonces maṉba chøcyajque'te jujche mitz ndzajmayajpase. ");
INSERT INTO zosNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero mumu jetse maṉba mi ñchøjcatyame porque mi ndø va'ṉjamdamba ndøvø, porque jic mi ṉgui'sayajpapø'is ji'ṉ cyomusaj ndø Janda lo que cø'vejupø'stzi. ");
INSERT INTO zosNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","”O'ca ja minøna'ṉ øtz va'cø ndzajmayajø, ja ityajøna'ṉ cyoja. Pero yøti ji'n mus cyøvø'ñaj cyoja. ");
INSERT INTO zosNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Lo que qui'sapyapø'is øjtzi, qui'sacye'tpati ø Janda. ");
INSERT INTO zosNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","O'ca øtz ja nchøcøna'ṉ milagro'ajcuy lo que ni i'is ja chøcøpøtøc, entonces ja itøna'ṉ cyoja. Pero yøti isyaju lo que øtz ndzøjcupø øjtzi y qui'sayajøjtzi y qui'sayajque'tpa ø Janda Dios. ");
INSERT INTO zosNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","De toda manera jetse tiene que va'cø tyucø va'cø viyuṉajø lo que jujche ijtuse jachø'yupø: “Qui'sayajøjtzi aunque jana cojacøsi”. Jetse ijtuse jachø'yupø je'ista'm 'yaṉgui'mocuy libru'omo. ");
INSERT INTO zosNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","”Pero it viyuṉdzambapø Espiritu ndø Jandamø y jet cotzo'ṉopa y maṉba mini, porque øtz maṉba ṉgø'veje; ndø Jandamø tzu'ṉba. Je'is maṉba viyuṉgotzøc øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mitz maṉba mi ndø viyuṉgotzøctaṉgue'te porque mitz oy mi vijtam øtzji'ṉ desde que yoscho'tz øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","”Oy mi ndzajmatyam yøcse va'cø mi jana ndzactam mi vaṉjajmocuy. ");
INSERT INTO zosNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Maṉba mi myajquinductandøji Israel pø'nis cyonocscutyøjcomo. Viyuṉse maṉba nu'c hora cuando maṉba mi yaj ca'tame y maṉba cyomo'yaje que vøjpø ti nø chøcyajuse para Dioscøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jetse maṉba mi ñchøjcatyame porque ni ndø Janda nuṉca ja cyomusyajø ni øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pero yøcse mi ndzajmatyamba yøti, y después cuando nu'cpa hora mi yacsutzøctandøjpa'c, maṉba mi jajmundzøctame que mi ndzajmatyamu mitzi que jetse maṉba tuqui. ”Cuando ndzøctzo'tz øjtzi vi'na, ja mi ndzajmatya'møjtzi que maṉba mi yacsutzøctandøji porque mitzji'ṉa'ṉø ijtøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero yøti ma'ṉbøjtzi ijtumø ndø Janda cø'vejupø'stzi y ni jutipø'is mijtzomdam ji'nø ocva'que jut ma'ṉbø mave. ");
INSERT INTO zosNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pero por lo que jujche mi ndzajmatyamuse øjtzi, por eso nø mi myaya'ṉgo'ndamu. ");
INSERT INTO zosNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero viyuṉbø ti mi ndzajmatya'mbøjtzi que masti vøjø mitzcøtoya va'cø ma'ṉøjtzi. Porque o'ca ji'nø mave, Cotzo'ṉopapø Espiritu Santo ji'n ma min mitzcø'mda'm. Pero o'ca ma'ṉbøjtzi, ma'ṉbø ṉgø'vej Cotzo'ṉopapø mitzcø'mda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cuando minba, maṉba yac jamemiñaje ji'n vya'ṉjamoyajepø pøn ti cyojata'm, y jujche va'cø ityajø, y que Diosis maṉba cyastigatzøcyaje cojapa'tyajupø. ");
INSERT INTO zosNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Maṉba yac musyaje que ityaj cyoja, porque ji'n va'ṉjamyaj øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Maṉba yac musyaj ti vøjø va'cø ndø tzøctamø, porque øtz ma'ṉbø ndø Jandamø y ji'n ma mi ndø istame. ");
INSERT INTO zosNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Maṉba yac musyaje que Diosis cyastigatzøcyajpa cojapa'tyajupø, porque Diosis yaj coja'aju'am Satanás nascøspø yachcovi'najø. ");
INSERT INTO zosNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","”Ijtutøc vøti va'cø mi ndzajmatyamø, pero mitzta'm ji'n mus mi ṉgønøctøyøtyam yøti. ");
INSERT INTO zosNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero cuando minba viyuṉdzambapø Espiritu, je'tis maṉba mi nchajmatyame mumu viyuṉseta'mbø tiyø. Je'tis ji'n ma cham ñe'c qui'psocuy, sino lo que myanba, jet maṉba chame. Je Espiritu Santo'is maṉba mi ñcha'manvajcatyame lo que ti maṉba tuqui jøsijcam. ");
INSERT INTO zosNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Maṉba yaj queje que møja'ṉombø chøṉø. Porque lo que pyøjcøchoṉba øtzcøsi, jet maṉba mi ncha'maṉvajcatyame. ");
INSERT INTO zosNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mumu lo que ndø Janda'is ñe, también øjtine'ṉgue't. Por eso nø'møjtzi que Espiritu'is maṉba pyøc lo que ø ne y maṉba mi ñchamaṉvajcatyame. ");
INSERT INTO zosNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","”Usy horacøsi, ji'n ma mi ndø istame. Y masam jøsijcam maṉba mi ndø istaṉgue'te, porque ma'ṉbø maṉ ndø Jandamø. ");
INSERT INTO zosNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Entonces vene ñøtuṉdøvø na ñøjayajtøju: ―¿Ti'ajcuy jetse nø ñømu: “Usy horacøsi ji'n ma mi ndø istame, y masam jøsijcam maṉba mi ndø istaṉgue'te”? ¿Y ti'ajcuy nø ñømu: “Porque maṉ'bø maṉ ndø Jandamø”? ");
INSERT INTO zosNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Por eso na ñøjayajtøju: ―¿Ti'ajcuy nø ñømu: “Usy horacøsi”? Ji'nø ṉgønøctøyøtyame ti nø chamupø. ");
INSERT INTO zosNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Pues Jesusis myusu que sunbana'ṉ 'yocva'cyaj tiyø nø chamupø y por eso ñøjayaju: ―Øtz nø'møjtzi usy horacøsi ji'n ma mi ndø istame, y masam jøsijcam maṉba mi ndø istaṉgue'te y mi ne'ṉgomda'm na mi ñøjandyandøjpa ticøtoyacsque'te jetse nø'møjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Pues viyuṉse mi nøjandya'mbøjtzi: maṉba mi vyo'ndame, maṉba mi maya'ṉgo'ndame, pero ji'nø va'ṉjamyajepø'is maṉba casøyaje. Aunque mi ndyoyapøctamba, jøsijcam maṉba yaj mi maya'ṉguy y maṉba mi ṉgyasøtyame. ");
INSERT INTO zosNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cuando yomo'is maṉba is 'yune, toya'ispa porque nu'c 'yora va'cø is une. Pero pø'najujcam une, jyamgajpø'pa toya. Casøpya porque pø'naju'am jaya une nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jetsetique't mitzta'm yøti nø mi myaya'ṉgo'ndamu, pero eyaco jama maṉba mi ndø istaṉgue'te, y maṉba alegre'aj mi ndzocotya'm. Y mi ṉgajsøjcuy ni i'is ji'n mus ma mi yajandyamø. ");
INSERT INTO zosNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","”Jic jama ji'n ma mi ⁿva'ctam ni ti øtzcøsi. Viyuṉse mi nøjandya'mbøjtzi, aunque ti mi ⁿva'ctamba ndø Jandacøsi, o'ca mi ⁿva'ctamba ø nøyiṉgøsi, maṉba mi ñchitam ndø Janda'is ti nø mi sundamu. ");
INSERT INTO zosNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta yøti ni ti ja mi ⁿva'ctam ø nøyiṉgøsi. Va'ctamø, y maṉba mi mbøjcøchoṉdame, jetse maṉba mi ṉgyasøco'ndame viyuṉse. ");
INSERT INTO zosNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","”O'yø mi ndzajmatyam yøcseta'mbø tiyø va'cø ṉgomparatzøc nascøspø tiji'ṉ, pero maṉba nu'c hora cuando maṉba mi ndzajmatyame va'cø mi ṉgønøctøyøtya'mø, ma'ṉbø mi ndza'maṉvajcatyame viyuṉse jujche ijtuse ndø Janda. ");
INSERT INTO zosNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jic jama ndø Jandacøsi maṉba mi ⁿva'ctam aunque tiyø ø nøyiṉgøsi. Ji'ndyet pyena øtz va'cø mi va'ṉgatyam Dioscøsi; muspa mi ⁿva'ctam mi ne'ṉgø ti mi sundamba. ");
INSERT INTO zosNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Porque ñe'c ndø Janda'is mi sundamba. Mi sundamba porque mi ndø sundamba ndøvø, y mi va'ṉjamdamu'am que øtz mi'nø Diosmø. ");
INSERT INTO zosNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Øtz tzu'ṉu ndø Jandamø, mi'nø nascøsi, y tzu'ṉgue'tpøjtzi, maṉgue'tpa ndø Jandamø. ");
INSERT INTO zosNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Entonces ñøtuṉdøvø'is ñøjayaj Jesús: ―Yøti mi ndø ndza'maṉvajcatyamba viyuṉsye, ji'n mi ndø tza'maṉvajcatyame lo que ji'n ø ṉgønøctøyøtyamepø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yøti ṉgønøctøyøtya'mbøjtzi que mitz muspa mumu tiyø, y ji'ndyet pyena ni i'is va'cø mi ⁿ'yocva'c ni tiyø. Por eso mi va'ṉjamda'mbøjtzi que mitz mi ñchu'ṉ Diosmø. ");
INSERT INTO zosNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesusis 'yaṉdzoṉyaju, ñøjayaju: ―¿Será que viyuṉsye mi ndø va'ṉjamdamba yøti? ");
INSERT INTO zosNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ya mero maṉba nu'c hora cuando mijtzi maṉba mi ve'nbø'pø'netyame, tumdum pøn maṉba maṉ ñe' tyøcmø. Maṉba mi ndø tzacpø'tame, pero ji'n ø ndumgø'y ma tzø'yi, ndø Jandaji'ṉ chøṉ ijtu. ");
INSERT INTO zosNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yøcseta'mbø tiyø mi ndzajmatyamu va'cø mi ijtam contento. Maṉba mi istam toya nascøsi, pero u mi myaya'ndamu, paquichoco'yajtamø, porque ndo'nøjtzi cuando nascøspø enemigo'is nøquijpøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jetse cham Jesusis y entonces quengui'm møji tzajpomo y ñøjayu: ―Ø mi Janda, nu'cu'am hora. Yaj quejay ø møja'ṉo'majcuy mijchø ndø Une. Jetse øtz va'cø yaj quejacye't mi møja'ṉo'majcuy mi ne'. ");
INSERT INTO zosNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mitz ndø tzi' aṉgui'mguy va'cø aṉgui'myaj mumu pøn. Jetse pøn lo que mitz ndø tzi'yajupø, øtz va'cø ndzi'yaj quenguy mumu jamacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Va'cø queñaj mumu jamacøtoya, tiene que va'cø mi ṉgyomusyaj mijtzi. Nada más mijtzete viyuṉsepø Dios, ja it más eyapø. Y también øtz tiene que va'cø comusyajø que øjchøṉ Jesucristo, mitz ndø ṉgø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","”Øtz yac isyaj pønda'm mi møja'ṉo'majcuy, øtz yac tujcu'mtzi yoscuy mitz ndø tzi'use va'cø ndzøcø. ");
INSERT INTO zosNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Y yøti, ø mi Janda, tø yac møja'ṉomajø parejo mijtzji'ṉ. Como tø ijtamuse møja'ṉo'majcu'yomo vi'na antes que tzo'tz nasacopac, mismo igualpø itcuy, jetseti tø tzi'que'ta. ");
INSERT INTO zosNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","”Mitz ndø cøpijṉayaj vene nascøsta'mbø pøn ne'ti va'cø mi ndø tzi'yajø. Øtz ⁿyac musyaj jic pønda'm ⁿiye mijtzi. Jicø pønda'm mijna'ṉe ne'nda'm, y mi ndø tzi'yaju y jic mi ndø cøpiṉyajupø pø'nis chøcyaju jujche mi aṉgui'myajuse. ");
INSERT INTO zosNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yøti myusyaju'am que mumu tiyø lo que mitz ndø tzi'upø, mitzcø'm tzu'ṉu. ");
INSERT INTO zosNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Porque mitz ndø tzajmayu'am mi onde, y øtz ndzajmayajque'tu'am yøṉ pønda'm y je'tista'm pyøjcøchoṉjayaj mi onde y myusyaju'am viyuṉsye que øtz tzu'ṉu mitzcø'mø. Y vya'ṉjamyaju'am que mitz mi ndø cø'veju. ");
INSERT INTO zosNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","”Øtz mi o'nømbya para yøṉ pøngøtoyata'm. Ji'na mi o'nøy para ji'n vya'ṉjajmoyajepø pøngøtoya. Mi o'nøpyøjtzi pøngøtoya lo que mitz ndø tzi'yajupø porque mijtze ne'nda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Aunque ti ø ne', mijtzene'ṉgue't y todo lo que mijtzene, øjtitne'ṉgue't; y ji'quista'm yaj quejpø'jayajpa ø møja'ṉo'majcuy. ");
INSERT INTO zosNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Y yøti øtz ji'n ma tzø'y nascøsi, pero yøṉ pøn maṉba tzø'yaj nascøsi, y øtz ma'ṉbø min mitzcø'mø. ”Ø mi Janda, mitz ⁿvyøjpøte, ja it mi ṉgoja, cuendatzøjcay mi mbømiji'ṉ yøṉ pøn mi ndø tzi'yajupø va'cø ñø'ityaj tumbø qui'psocuy jujche øtz tumbø qui'psocuy ndø nø'ijamuse. ");
INSERT INTO zosNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mientras øtzna'ṉ jetji'ṉda'm ijtu'øc nascøsi, ṉgoqueñajøjtzi mi mbømiji'ṉ. Cøyin ṉgoqueñajøjtzi pøn lo que mitz mi ndø tzi'yajupø. Ni jujche más ja tocoya sino que tumdi tocoyu. Y jic na tyocoyupøtimna'ṉete. Y tocoyu va'c tyucø jujche ijtuse jachøyupø mi onde. ");
INSERT INTO zosNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","”Y yøti øtz maṉba maṉ mitzcø'mø, y yøcsepø tiyø ndzajmayajpøjtzi mientras ijtu'ctzi nascøsi. Tzajmayajpøjtzi yøcsepø ote va'cø casøjyajø viyuṉsye jujche øtz casøpyase. ");
INSERT INTO zosNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Øtz ndzajmayaju yøṉ ø mbønda'm mi onde. Y ji'n vya'ṉjajmoyajepø pø'nis qui'sayaju porque ø ne'nda'm ji'n qui'psyaj parejo como ji'n vya'ṉjajmoyajepø pø'nis qui'psyajpase. Igual ni øtz ji'n ṉgui'psi como ji'n vya'ṉjajmoyajepø pønse. ");
INSERT INTO zosNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ji'n mi va'ṉgay va'cø mi yac tzu'ṉyaj ø mbønda'm nascøsi. Sino que va'cø mi ndø coquijpayaj yatzi'ajcuji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Como ø ṉgui'psocuy ji'ndyet parejo ji'ṉ vya'ṉjajmoyajepø pønji'ṉ, jetsetique't ø mbønda'mgue't ji'ndyet parejo qui'psocuy jetji'ṉgue't. ");
INSERT INTO zosNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Su'ṉbøjtzi va'cø mi ṉgyømasa'nøyajø viyuṉsyepø tiji'ṉ. Mi onde viyuṉsyepø tiyete. ");
INSERT INTO zosNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mitz ndø cø'veju va'cø it nascøsi ji'n vya'ṉjajmoyajepø pønji'ṉ y jetseti øtz nascøsi nø ṉgø'vejyajque't ø mbønda'm va'cø ityaj nascøsi ji'n vya'ṉjamoyajepø pønji'ṉdique't. ");
INSERT INTO zosNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ø nønduṉdøvøcøtoya mi ndzi'pa ø ⁿvin, ø nønduṉdøvø va'cø mi ṉgømasa'nøyajø mijtzi o'ca vya'ṉjamyajpa viyuṉsepø tiyø. Øtz ndzi'ocu'yajpa ø ⁿvin mitzcøsi para ø nønduṉdøvøcøtoya jet va'cø mi ṉgømasa'nøyajø. ");
INSERT INTO zosNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","”Ji'n na's yøṉ ø nønduṉdøvøcøtoya mi o'nøjambya, sino también eyapøcøtoya lo que maṉbapø'støc mi ⁿvya'ṉjamyaje cuando myajnayajpa lo que ø nønduṉdøvø'is maṉbapø cha'maṉvacyaje. ");
INSERT INTO zosNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mi o'nøjapya que va'cø tumbø qui'psocuy ñø'ityajø mumu va'ṉjamyajpapø'is øjtzi; jujche mijtzi, Jatay, øtz ndzoco'yom ijtu, y øtz mi ndzoco'yomo ijtu, jetse va'cø ñø'ityaj tumbø qui'psocuy parejo øtzji'ṉ, va'cø vya'ṉjamyaj nascøsta'mbø'is que mitz mi ndø cø'veju. ");
INSERT INTO zosNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jujche mitz mi ndø yac møja'ṉo'maju, jetse øtz yac møja'ṉo'majyajque'tu va'ṉjamyajpapø'is øjtzi va'cø ñø'ityaj tumbø qui'psocuy, jujche tø øjtzi tumbø qui'psocuy tø nø'ijtu. ");
INSERT INTO zosNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Øjtzi va'cø it je'is choco'yomda'm y mitz va'cø it ø ndzoco'yomo va'cø tumbø qui'psocuy ñø'ityajø viyuṉsye. Jetse va'cø chi'yaj cuenta nascøsta'mbø'is que mitz mi ndø cø'veju. Y mitz mi suñaj va'ṉjamyajpapø'is øjtzi, jujche mi ndø sunba. ");
INSERT INTO zosNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","”Jatay, su'nbøjtzi va'cø ityaj øtzji'ṉ pøn lo que mi ndø tzi'yajupø. Jut itpa øjtzi, jiṉø va'cø ityajque'ta ø mbønda'm, va'cø mus isayaj ø møja'ṉo'majcuy, jujche mitz mi ndø yac møja'ṉo'majuse. Porque mitz mi ndø sunu antes que nasacopac mi ⁿjomejcu. ");
INSERT INTO zosNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ø mi Janda, vøj mi aṉgui'mbapø'is, ji'n vya'ṉjajmoyajepø pø'nis ja mi ṉgyomusyajø. Pero øtz mi ṉgomuspøjtzi y yø'ṉista'm cyønøctøyøyaju que mitz ndø cø'veju. ");
INSERT INTO zosNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Y ndzamndzo'tzayaju'mtzi jujchepøt mijtzi, y matøc ndza'ma'ṉøjayajque'te va'cø syu'noyajø jujche mitz mi ndø sunbase, y øtz maṉba it je'is choco'yomoda'm. ");
INSERT INTO zosNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jetse Jesusis 'yo'nøy Jyata, y entonces tzu'ṉyaju ñøtuṉdøvøji'ṉ y jyacyaju tum che' nø' ñøyipø'is Cedrón, jen ijtuna'ṉ nipi suñi quenbapø. Jen maṉyaju Jesús ñøtuṉdøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Y Judasete maṉbapø'is chi'ocuyaje, je'is cyomusque't jic lugar porque Jesús na 'yoyajpatina'ṉ jiṉø mumu jama ñøtuṉdøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judasis maṉ 'yo'nøyaj pane covi'najøta'm y fariseota'm, y je'tis cyø'vejyaj sone soldado y policía va'cø myaṉyaj Judasji'ṉ. Y nu'cyaj ijtumø Jesús y ñømaṉyaj cuy nembapø y yaj ca'otyøc. ");
INSERT INTO zosNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Entonces Jesusis myusu mumu lo que jujche maṉba tyuqui y maṉ choṉyaje y ñøjayaju: ―¿I nø mi me'tztamu? ");
INSERT INTO zosNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Y 'yaṉdzoṉyaju: ―Nø'mø me'tztam Jesús Nazaret cumgupyøn. Jesusis ñøjayaju: ―Øj chøṉø. Y Judas maṉba'is chi'ocuyaje jendi itque'tu. ");
INSERT INTO zosNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Y cuando nøjayaju'cam: “Øj chøṉø”, entonces jøsna vitu'yaju y quecyaj nasomo. ");
INSERT INTO zosNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Y 'yaṉgøva'cvøjøtzøcyajque'tu Jesusis: ―¿I nø mi me'tztamu? Y nøjayaju: ―Nø'mø me'tztam Jesús Nazaret cumgupyøn. ");
INSERT INTO zosNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesusis 'yaṉdzoṉyaju: ―Mi ndzajmatyamu'mtzi que øj chøṉø. O'ca nø mi ndø me'tztamu, yac tzacyaj yøṉ ø nønduṉ va'cø myaṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jetse nøm Jesús va'cø viyu'ṉajø lo que chamuse: “Mumu lo que mi ndø tzi'yajupø, ni tumø ja yac tocoyajøjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Entonces Simón Pedro'is ñø'it espada, y ijtuna'ṉ pane covi'na'is chøsi nøyipø'is Malco. Y Pedro'is ñøput espada y chetzcajpøjay Malco'is chø'na'ṉ datzøc. ");
INSERT INTO zosNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Entonces Jesusis ñøjay Pedro: ―Majtzøy mi espada ñaca'omo. Ø Janda'is tzamdzi'use øjtzi va'cø toya'isø, jetse tiene que va'cø toya'isø. ");
INSERT INTO zosNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Entonces vøti soldado'is y cyovi'najø'is y Israel pø'nis pyolicia'is ñucyaj Jesús y myocsyaju. ");
INSERT INTO zosNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Y vi'na ñømaṉyaju Jesús Anasis vyi'naṉdøjqui, porque Anás Caifasis myo'ot jatate, y Caifás møja'aṉombø pane covi'najøte jic ame'omo. ");
INSERT INTO zosNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yøṉ Caifasis oyupø'is ñøjayaj Israel pøn que masna'ṉ vøjø para jetcøtoya que va'cø cya'ø tum pøn para mumu pøngøtoya. ");
INSERT INTO zosNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Y Simón Pedro'is oy maṉ pya't Jesús y oy maṉ pya'tque't eyapø ñøtuṉdøvø'is lo que ispøjcupø myøja'ṉombø pane covi'najø'is y jicø eyapø nøtuṉdøvø tøjcøy Jesusji'ṉ møja'ṉombø pane covi'najø'is tyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero callecøspø aṉdu'ṉom tzø'y Pedro. Entonces eyapø ñøtuṉdøvø lo que ispøjcupø møjaṉombø pane covi'najø'is, jet pujtu a'ṉgomo y ñøjayu yomo cyuendatzøcpapø'is aṉdyuṉ va'cø yac tøjcøy Pedro, y jetse tøjcøy Pedro. ");
INSERT INTO zosNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Entonces aṉdyuṉ cuendatzøcpapø yomo'is ñøjay Pedro: ―Parece que mijtzete jic pø'nis ñøtuṉdøvø. Y Pedro'is ñøjay yomo: ―Ji'nchøṉ øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Y pane covi'najø'is chøsi'is y soldado'is yac tzocyajumna'ṉ juctyøc y te'numø samyajpa porque pacacna'ṉ; y tumø'omo te'nu Pedro jetji'ṉdam y nømdina'ṉ syamgue'tu. ");
INSERT INTO zosNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Møja'ṉombø pane covi'najø'is 'yaṉgøva'cu Jesús ita'mete ñøtuṉdøvø y tiyete 'yaṉma'yocuy. ");
INSERT INTO zosNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Y Jesusis 'yaṉdzoṉu: ―Øtz oy 'yaṉma'yoye mumu pø'nis vyi'nomo aunque juti. O'yø aṉma'yoye Israel pø'nis myasandøjcomo y eyapø tøjcomo tu'myajpamø Israel pønda'm. Siempre jen oyajpa mumu Israel pøn. Ni ti ja ñu'mdza'møjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ti'ajcuy mi ndø aṉgøva'cpa øjtzi? Aṉgøva'cyajø cøma'nøyajupø'stzi lo que ti ndza'møjtzi, je'is myusajpa lo que ti ndza'møjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jetse chamu'c Jesus'is, tum soldado'is jendi te'nupø'is chaṉ Jesús cyø'occhaji'ṉ y ñøjayu: ―¿Ti'ajcuy jetse mi aṉdzoṉba myøja'ṉombø pane covi'najø? ");
INSERT INTO zosNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Y Jesusis 'yandzoṉu: ―O'ca ndza'møjtzi ji'n vyøjpø tiyø, tø tzajmayø tiyete. Pero o'ca ndzamupø'tzi vøjpø tiyø, ¿ticøtoya nø mi ndø tzaṉu? ");
INSERT INTO zosNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Entonces Anasis mo'csupø cyø'vej Jesús møja'ṉombø pane Caifascø'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro jendina'ṉ nø tye'nu y nømna'ṉ syamu, y eyata'mbø'is ñøjayaju: ―¿Ji'nat mijtzi jic pø'nis ñøtuṉdøvø? Pedro'is ja vya'ṉjamø, ñøjayaju: ―Ji'n chøṉ øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jendina'ṉ it pøn tyachcøjajcupø'is tyøvø, møja'ṉombø pane covi'najø'is ñucscucyet, je'is ñøjay Pedro: ―¿Ji'natze mitz mi ⁿisu jic nipi'omo jic pønji'ṉ? ");
INSERT INTO zosNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Entonces jetseti Pedro'is ja vya'ṉjamgue'tati y jicse'cti vej ṉgalyu. ");
INSERT INTO zosNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Entonces ñøtzu'ṉyaj Jesús Caifasis tyøjcomo y ñømaṉyaj gobierno'is pyalacio'omo y nømna'ṉ syø'ṉbønømu. Israel pønda'm ja tyøjcøyajø palacio'omo porque ijtuna'ṉ ñe 'yaṉgui'mgutya'm que o'ca tøjcøyajpana'ṉ palacio'omo y myotyajpana'ṉ aunque jujchepø pønji'ṉ lo que ji'ndyet Israel pøn, entonces yu'cøyajpana'ṉ vyin y ji'na'ṉ musi vyi'cyaj borrego sis pascua sø'ṉis cuenta. ");
INSERT INTO zosNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Por eso gobernador ñøyipø'is Pilato pujtu va'cø 'yo'nøyajø y 'yaṉgøva'cyaju: ―¿Ticøtoya mi ṉgøva'cøtyamba yøṉ pøn? ");
INSERT INTO zosNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Y je'ista'm 'yaṉdzoṉyaju: ―O'ca ja ityøna'ṉ cyoja, ji'na'ṉø nømindam yø'qui va'cø ṉgøtza'møtyamø. ");
INSERT INTO zosNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Entonces Pilato'is ñøjayu: ―Nømaṉdam mi ne'ṉgø y tzøctam mi justicia'ajcuy mi ne'c ijtamuse mi aṉgui'mgutya'm. Pero Israel pø'nista'm 'yaṉdzoṉyaju: ―Pero øtzta'm Israel pø'nista'm ja ñø'ijtam øjtzi aṉgui'mguy va'cø yaj ca'otya'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jetse tujcu lo que Jesusis oyuse chame, porque Jesusis oy chame jujchena'ṉ maṉba ca'e y jujche chamuse Jesusis, jetse tujcu. ");
INSERT INTO zosNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato vøcø tøjcøcye'tu palacio'omo, y vyejay Jesús y 'yaṉgøva'cu: ―¿Mijtzete Israel pø'nis mi Aṉgui'mbata'm? ");
INSERT INTO zosNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesusis ñøjayu: ―¿Jetse mi aṉgøva'cpa mi ṉguentacøsi, o será que eyapø'is mi ñchajmayu que øjtzi aṉgui'mba chøṉø? ");
INSERT INTO zosNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato'is 'yaṉdzoṉu: ―¿Acaso øjchøṉ Israel pøn? Mi gumguy tyøvø'is y mi mbane covi'najø'is mi nchi'ocuyajyaj øtzcøsi. ¿Ti mi ndzøjcu? ");
INSERT INTO zosNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Entonces Jesusis 'yaṉdzoṉu: ―Ø aṉgui'mguy ji'ndyet yøn nascøspø. O'cana'ṉ nascøspø, entonces ø nøndu'ṉdøvø'is coquipyajpana'ṉtzi va'cø jana nucyaj øjtzi Israel pø'nis, pero ø aṉgui'mguy ji'ndyet yø'cpø. ");
INSERT INTO zosNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Entonces Pilato'is ñøjayu: ―¿Entonces mitz mi aṉgui'mbate? Jesusis 'yaṉdzoṉu: ―Øtz aṉgui'mba chøṉø, como mi ndzamuse. Øtz pø'najøjtzi y mi'nø nascøsi va'cø ndza'maṉva'c viyuṉsyepø tiyø. Mumu vya'ṉjamyajpapø'is viyuṉsyepø tiyø, je'is cyøma'nøjayajpa lo que øtz nø ndzamupø. ");
INSERT INTO zosNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato'is ñøjayu: ―¿Quién sabe tiyete viyuṉsyepø tiyø? Jetse 'yaṉgøva'cu'jcam, Pilato vøcø putque'tu va'cø 'yo'nøyaj Israel pønda'm y ñøjayaju: ―Øtz ji'nø mba'tay ni jujchepø coja yøṉ pø'nis ñe. ");
INSERT INTO zosNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mitzta'm mi ñø'ijtam costumbre øtz va'cø ndzøcøpø'ø jutipø preso mitz sundamba va'cø ndzøcøpø'ø pascua søṉ ancø. ¿Sundamba ja mijtzi mi Israel mbyø'nista'm va'cø ndzøcøpø'ø mi Aṉgui'mbata'm? ");
INSERT INTO zosNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Entonces mumu vøco vejyajque'tu: ―¡Jet u'yi chøcøpø'i! ¡Tzøcøpø Barrabás! Y yøṉ Barrabás nu'mbapø pøna'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Entonces Pilato'is yac nacstochøctøj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Y soldado'is vi'na chøjcayaj corona tzøqui apitpø y cyojtayaj Jesús cyopajcomo, y cya'møyaj tum yøc tzapaspø tucuji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jøsijcam cyønu'cyaju Jesús y nømyaju: ―¡Viva Israel pø'nis Aṉgui'mbata'm! Y tyacscøvøyaj 'yacacøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Entonces Pilato putvøjøtzøjque'tu y ñøjayaju: ―A'mdamø, øjtzi nømbutpøjtzi yø'qui yøṉø va'cø mi nchi'tam cuenta que ji'nø mba'tay ni jujchepø cyoja. ");
INSERT INTO zosNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Y put Jesús apit corona'øyupø cyopajcøsi, y yøc tzapaspø tucu mesupø. Entonces Pilato'is ñøjayaju: ―¡A'mdam yøṉ pøn! ");
INSERT INTO zosNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cuando isyaju pane covi'najø'sta'm y soldado'sta'm, vejtzo'chaju: ―¡Ma'møy cruzcøsi! ¡Ma'møy cruzcøsi! Pilato'is ñøjayaju: ―Pues mitz nømaṉdamø y ma'møtyam cruzcøsi mi ne'cta'm, porque øtz ni jujche ja mbya'tay cyoja. ");
INSERT INTO zosNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero Israel pø'nista'm 'yaṉdzoṉyaju: ―Øtz nø'ijtam ley y según ø leyta'm tiene que va'cø cya'ø, porque Diosise 'Yune chøc vyin. ");
INSERT INTO zosNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cuando Pilato'is myan jetse, más na'tzco'nu. ");
INSERT INTO zosNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Vøco tøjcøtye't aṉgui'mguy tøjcomo y 'yaṉgøva'c Jesús ñøjayu: ―¿Jutpøt mijtzi? Pero Jesusis ja 'yaṉdzoṉ ni jujche. ");
INSERT INTO zosNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Entonces Pilato'is ñøjayu: ―¿Ticøtoya øtz ji'n mi ndø aṉdzove? ¿Ji'n mi musi que øtz nø'ijtø aṉgui'mguy va'cø mi yac ma'møtyøj cruzcøsi y nø'itque'tuti aṉgui'mguy va'cø mi ndzøcøpø? ");
INSERT INTO zosNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Entonces Jesusis 'yaṉdzoṉu: ―Ni jujchepø aṉgui'mguy ji'na'ṉ mi nø'it øtzcøsi, o'ca ja mi nchi'øna'ṉ aṉgui'mguy Diosis; por eso tzi'ocuyaju'is øjtzi mitzcøsi, más jet cojapa'tu que ji'n mijtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Desde jicsye'c Pilato'is chøcme'tzjo'pana'ṉ jujche muspa chøcøpø' Jesús; pero Israel pø'nista'm vyejaṉgøjtayaju: ―¡O'ca mi nchøcøpø'pa je pøn, ji'ndyet mi møja'ṉ aṉgui'mbapø Cesajris mi 'yamigo mijtzi! ¡Aunque iyø como aṉgui'mbase chøcpapø'is vyin qui'sapya møja'ṉ aṉgui'mbapø César! ");
INSERT INTO zosNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Cuando Pilato'is myan jetse, cyø'vej tum soldado va'cø ñøpujtøj Jesús. Pilato po'cs po'cspamø aṉgui'mba. Jic lugar ñøjayajpamø hebreo ote'omo Gabata. Ndø nøjatyamba ndø onde'omda'm tza' necse. ");
INSERT INTO zosNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Paṉguc jamasye'ṉomna'ṉete, y jyo'pit maṉba it pascua søṉ. Entonces Pilato'is ñøjayaj Israel pønda'm: ―¡A'mdam mi angui'mba! ");
INSERT INTO zosNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero jicta'm vejaṉgøtyaju: ―¡Yaj ca'ø! ¡Yaj ca'ø! ¡Yac ma'møtyøj cruzcøsi! Pilato'is ñøjayaju: ―¿Ti'ajcuy ma'ṉbø yac ma'møtyøj cruzcøs mi aṉgui'mbata'm? Pero pane covi'najø'sta'm 'yaṉdzoṉyaju: ―César ndø aṉgui'mbata'm; ja ñø'ijta'møjtzi más aṉgui'mba. ");
INSERT INTO zosNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Entonces Pilato'is chi'ocuyaju Jesús jetcøsta'm va'cø mya'møtyøj cruzcøsi, y ji'quis ñømaṉyaju. ");
INSERT INTO zosNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús cruz cajpupø put va'cø maṉ tum lugajromo ñøyimø ca'upø'is cyo'cøpacmø. Hebreo ote'omo ñøyipø'is Gólgota. ");
INSERT INTO zosNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jen ma'møtyøj Jesús cruzcøsi, y tumø'omo ma'møyajtøjque't cruzcøsi eyapø metzpøn tumdum sayamaye y Jesús cujqui tzø'yu. ");
INSERT INTO zosNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato'is 'yaṉgui'myaju va'cø jyayaj letra tablacøsi ti cyoja y va'cø cyotyajø cruzis cyopajcomo. Lo que jyayajupø nømbana'ṉ: “Jesús Nazaret cumgupyøn, Israel pø'nis 'Yaṉgui'mbata'm”. ");
INSERT INTO zosNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Y sone Israel pø'nis tyu'ñaju letrero, porque ma'møtyøjumø Jesús cruzcøsi tome ispa cumguy, y jatyøjuna'ṉ tu'cay co'mapø ote'omo; tum ñøyipø'is hebreo ote, tum nøyipø'sque't griego ote, eyapø'is ñøyique't latín ote. ");
INSERT INTO zosNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Por eso Israel pø'nis pyane covi'najø'sta'm ñøjayaju Pilato: ―U jyaye que Israel pø'nis 'Yaṉgui'mbata'm, más vøj jayø que ne'c nømu que Israel pø'nis 'Yaṉgui'mbata'm. ");
INSERT INTO zosNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero Pilato'is 'yaṉdzoṉu: ―Jujche lo que ⁿjayumbø'tzi, jetse ma tzø'y. ");
INSERT INTO zosNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mya'møyaju'cam Jesús cruzcøsi soldado'is, entonces pijṉayaj tyucu y tumdumø vye'nbø'yaj macsyaṉbø'nomo, tumdum soldado'is pyøjcayaj tumdumø tyucu. Pero cyamisya ja ña'cøpøna'ṉete, entero tajcupø. ");
INSERT INTO zosNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Por eso soldado na ñøjayajtøj tumdumø: ―Uy ndø tzitzta'i; mejor ndø chøjquista'i syuerte a ver i'is ñe'ajpa. Jetse tuc viyuṉsye lo que ijtuse jachø'yupø masanbø totojaye'omo, jiṉ nømba: “Vye'nbø'yaj ø nducu ñe'comda'm, ø nducucøsi chøjquisyaj syuerte”. Jetse chøcyaju soldado'is. ");
INSERT INTO zosNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Y tyumø'omna'ṉ ityaj cruzcø'mø macsycuy yomo; tumø Jesusis myama, y tumø Jesusis 'yeme, tum Cleofasis yomo ñøyipø'is María, y tumø María Magdalena. ");
INSERT INTO zosNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesusis isyaj myama y jicji'n te'nupø tyumø'omo jic ñøtuṉdøvø ñe'c Jesusis syuṉgø'nbapø. Entonces Jesusis ñøjay myama: ―Mamay, yøṉ ma tzø'y como mi unese. ");
INSERT INTO zosNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jøsi'cam ñøjayu ñøtuṉdøvø: ―Tø pøjcøchojṉay ø mama como mi mamase. Desde entonces jic ñøtuṉdøvø'is pyøjcøchoṉ tyøjcomo como myamase. ");
INSERT INTO zosNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tujcu'cam jetse, cyønøctøyøy Jesusis que tucpø'u'cam yoscuy nascøsi, y entonces nømu: ―Nø yo'ctøjtzu. Jetse nømu va'cø tyucø jujche ijtuse jachø'yupø masanbø totojaye'omo. ");
INSERT INTO zosNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pero ijtuna'ṉ jiṉø tum syalu tasupø catzu vinuji'ṉ. Entonces yac ñuṉyaj tzojasepø je vinu'omo, cyotyaj cape cucyøsi y yaj qui'mayaj hasta Jesusis 'yaṉna'como va'cø myu'cø. ");
INSERT INTO zosNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesusis cyømu'c catzu vinu y jøsijcam nømu: ―Mumu ta'ṉbø'u'am. Entonces 'yatzquec cyopac y chi'ocuyaj 'yespiritu Dioscøsi, y ca'u. ");
INSERT INTO zosNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jo'pitøc sapøjcuy jamate y Israel pø'nis ji'na'ṉ syuñaj va'cø yac tzø'yaj cruzcøs ca'yajupø sapøjcuy jama'omo, porque jic sapøjcuy jama møja søṉdzøjcuyete. Por eso vya'cayaj Pilato va'cø maṉ yaj quijtayaj tyajapac cruzcøsi ityajupø'is ñe, y va'cø yac tzu'ṉayajtøj cruzcøsi ca'yajupø. ");
INSERT INTO zosNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Entonces soldado maṉyaju y quijtayaj tyajapac vinba'tupø'is ñe y también eyapø pø'nis ñe' Jesusis syaya'om ma'møtyøjupø cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero cuando cyømaṉyaj tome Jesús, cyøque'nøyaju que ca'umna'ṉ y por eso ja quijtayajø'am tyaja. ");
INSERT INTO zosNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero tum soldado'is vyotz Jesús syepsa'omo lanzaji'ṉ, y jicsye'cti puj nø'pin y puj nø'. ");
INSERT INTO zosNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Chamba'is yøcsepø tiyø isupø'sete jujche chøjcu y chamba viyuṉsyepø tiyø. Pues ñe'c myuspa que chamba viyuṉsyepø tiyø, pero jetse chamba para que mitzta'm va'cø mi va'ṉjamdaṉgue'tati. ");
INSERT INTO zosNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Porque yøcse tujcu va'cø viyuṉajø jujche ijtuse jachø'yupø masanbø totojaya'omo; jen nømba: “Ji'n ma quijtayaj pyac ni tumø”. ");
INSERT INTO zosNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Emø itque'tuti jachø'yupø que nømba: “Maṉba isyaje jutipø oyu vyochaje”. ");
INSERT INTO zosNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jøsi'cam tujcu'cam jetse, ijtuna'ṉ tum pøn ñøyipø'is José, Arimatea cumgupyøn. Vya'ṉjambapø'sque't Jesús, pero ñu'mva'ṉjamba, porque ña'chajpana'ṉ Israel pøn. Je'is vya'c permiso Pilatocøsi va'cø ñømajṉay Jesusis cyoṉña. Pilato'is chi' permiso, y José maṉu y ñømajṉay cyoṉña. ");
INSERT INTO zosNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","También nu'c Nicodemo vi'na oyupø'is 'yo'nøy Jesús tzu'yi. Je'is ñømin como treinta kilos perfume vøjøtzøjcupø mirra mojtupø aloesji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Así es que Jose'is y Nicodemo'is pyøjcayaj Jesusis cyoṉña y perfumeji'ṉ myoñaju pøjipø tucuji'ṉ, jujche Israel pø'nis cyostumbreta'm va'cø ñipyaj ca'yajupø. ");
INSERT INTO zosNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tome ma'møtyøjumø Jesús cruzcøsi ijtuna'ṉ nipi, y nipi'omo ijtuna'ṉ jomepø cønijpu'aṉ ja 'yoyapø'omdøc cyotyaj ni iyø. ");
INSERT INTO zosNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jen chacyaj Jesusis cyoṉña, porque je tzatøc tome ijtu y nømna'ṉ cyomeque'ajyaju Israel pø'nis syapøjcuy jamacøtoya y ja itøna'ṉ tiempo va'cø ñømaṉyaj más ya'i. ");
INSERT INTO zosNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Semana tzo'tzcuy jama'omo namdzuti María Magdalena oy cyotyajumø Jesús. Cuando pi'tzøctøc oyu. Y isu que ja itøna'ṉ jen tzatøc aṉdyuṉgøsi tza' aṉga'mupøji'ṉ tzatøc. ");
INSERT INTO zosNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Entonces maṉ poyu'c jut ityajumø Simón Pedro y jic eyapø Jesusis ñøtuṉdøvø lo que syungo'nbapø Jesusis, y María'is ñøjayaju: ―Ñøputyaju'am tzatøjcomo ndø Comi y ji'n ndø mustame jut cyotyaju. ");
INSERT INTO zosNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Entonces Pedro y eyapø ñøtuṉdøvøji'ṉ tzu'ṉyaju y maṉyaj ijtumø tzatøc. ");
INSERT INTO zosNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mye'chcø'y nømna'ṉ myaṉyaj parejo poyu'øc, pero eyapø más poya'ṉøyu que Pedro, y vi'na nu'c tzatøjcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Y jucsycøne'cu y quendøjcøy jojmo tzatøjcomo y is jen tucu monupøji'ṉ, pero ja tyøjcøyø. ");
INSERT INTO zosNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Jøsijcam je'is jyøsaṉgø'mø nu'c Simón Pedro, y tøjcøy tzatøjcomo. Je'is isque'tuti jeni tucu monupøji'ṉna'ṉ Jesús. ");
INSERT INTO zosNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Isque'tuti eyapø tucu myojnatyøjupøji'ṉ Jesusis cyopac que ja itøna'ṉ tyumø'omo eyapø tucuji'ṉ, sino quete'upø aparte ijtu. ");
INSERT INTO zosNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Entonces tøjcøcye't eyapø ñøtuṉdøvø oyupø vi'na nu'qui tzatøcmø y cuando isu, vya'ṉjajmu. ");
INSERT INTO zosNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Porque todavía ja cyønøctyøyøyajøtø'cna'ṉ jujche jachø'yuse que Jesús tiene que va'cø visa' ca'ujcam. ");
INSERT INTO zosNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Entonces vitu'yaju tyøcmø jic ñøtuṉdøvø. ");
INSERT INTO zosNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero vo'pa tzø'y María tzatøjcaṉvini. Mientras nø vyo'u'øc, jucsycøne'cu va'cø quendøjcøy tzatøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Y is metzcuy angeles popotucuta'mbø po'csyaju jut ijtumøna'ṉ Jesusis cyoṉña: tumø cyopajcø'mø y tumø cyosocø'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Y angelesista'm 'yocva'cyaju ṉøjmayaju: ―Tzamyomo, ¿ticøtoya nø mi ⁿvyo'u? Yomo'is ñøjayaj angeles: ―Porque ñømajṉayaju ø Ṉgomi y ji'nø musi jut cyotyaju. ");
INSERT INTO zosNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Apenas nøm jetse cuando que'najvitu'u jyøsmø y is Jesús que jen ijtu, pero ji'na'ṉ myusi o'ca Jesusete. ");
INSERT INTO zosNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Entonces Jesusis 'yaṉgøva'cu: ―Tzamyomo, ¿ticøtoya nø mi ⁿvyo'u? ¿I nø mi me'ndzu? Maria'is cyomo'yu que nipi cuidatzøcpa'is y por eso ñøjayu: ―Señor, o'ca mitz nømaṉu, tzajmay jut mi ndzajcu, va'cø øtz nømavø. ");
INSERT INTO zosNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Entonces Jesusis ñøjayu: ―¡María! Jet que'najtonvitu'u y ispøjcu o'ca Jesusete y ñøjmay hebreo ote'omo: ―¡Raboni! ―ndø onde'omo ndø nøjandyamba Maestro. ");
INSERT INTO zosNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesusis ñøjayu: ―U mi ndø pi'quisu, porque ja qui'møtø'ctzi jut ijtumø ndø Janda. Pero mavø y nøjayaj ndø tøvøta'm que ma'ṉbø qui'mi jut ijtumø ø Janda y mi Jandata'm, jut ijtumø ø ⁿDios y mi ⁿDiosta'm. ");
INSERT INTO zosNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Entonces María Magdalena maṉ chajmayaj nøtuṉdøvø que is ndø Comi y lo que chajmayuse ndø Comi'is. ");
INSERT INTO zosNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Je mismo jama semana tzocuy jamana'ṉete tzu'cøsi Jesusis ñøtuṉdøvø tyumø'omna'ṉ ityaju. Aṉga'myajuna'ṉ tyøc porque ña'chajpana'ṉ Israel pønda'm. Pero cujqui tøjcøyu Jesús y yuschi'yaju ñøjayaju: ―Contentoti ijtamø. ");
INSERT INTO zosNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ñøjmayaju'cam jetse, isindzi'yaj cyø' y syepsa, y ñøtuṉdøvø casøyaju porque 'ya'myaj ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jicsye'cti ñømvøjøtzøjcayaju Jesusis: ―Contento ijtamø mijtzi. Jujche ndø Janda'is cø'vej øjtzi, jetseti mi ṉgø'vejtaṉque'tpa mijtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Entonces Jesusis syujcajpø'yaju jejta'm y ñøjmayaju: ―Pøjcøchoṉdam Masanbø Espiritu Santo. ");
INSERT INTO zosNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","O'ca mi ⁿyaj cøtocojatyamba aunque i'is cyoja, jetseti cøtocopya jic pøn; y o'ca ji'n mi ⁿyaj cøtocojatyam cyoja, jetse ji'n cyøtocoye. ");
INSERT INTO zosNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero cuando minu Jesús, ja itøna'ṉ tyumø'omo jetji'ṉda'm Tomás. Tomás macvøstøjca'yombø ñøtuṉdøvø. Jic Tomás ñøjayajpana'ṉ mechipø. ");
INSERT INTO zosNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jøsijcam eyata'mbø nøtuṉdøvø'is ñøjayaj Tomás: ―O'yø istam ndø Comi. Pero Tomasis ñøjmayaju: ―Ji'nø va'ṉjajme. Mientras que o'ca ji'nø isay lavusy cø'o'yaṉ cyø'occha'omo, y o'ca ni ji'n tøjcøy ø ṉgø'aṉune lavusy cø'o'ya'ṉomo, y o'ca ni ji'n tøjcøy ø ngø' oyumø vyochaj syepsacø'mø, ji'nø va'ṉjajme. ");
INSERT INTO zosNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Entonces tucutujtay jamapit tøjcomo vøco tu'myajque'tu nøtundøvø, y jicsye'c jetji'ṉda'mna'ṉ ijtu Tomás, y tøc aṉgoji'omodina'ṉ ñø'ityajque'tu. Pero Jesús cujqui tøjcøyu je'tomda'm, y yuschi'yaju, ñøjmayaju: ―Contento ijtamø. ");
INSERT INTO zosNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Entonces Jesusis ñøjmayu Tomás: ―Yac min mi ṉgø'aṉune y tø pi'cay ø ngø', y yøc yac miṉ mi ṉgø' y yac tøjcøy ø sepsa'omo, y u más ni ti mi ṉgui'psu pero tø va'ṉjamø. ");
INSERT INTO zosNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Entonces Tomasis 'yaṉdzoṉu ñøjmayu: ―¡Øjchoṉ mi Ṉgomi y øjchøṉ mi Dios! ");
INSERT INTO zosNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesusis nøjayu: ―Tomás, yøti mitz va'ṉjajmba porque mi ndø isu'am. Pero contento ityajpa va'ṉjamyajpapø'is øjtzi, aunque nunca ja isyajø'stzi. ");
INSERT INTO zosNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesusis hasta más chøjca'ṉøy milagro'ajcuy ñøtuṉdøvø'is vyi'nomo aunque jana it jachø'yupø yøṉ libro'omo. ");
INSERT INTO zosNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero yøṉø jachø'yupøte va'cø mitz mi va'ṉjamdamø que Jesús Cristote lo que Diosis cyø'vejupø y Diosise 'Yune; y va'cø mi va'ṉjamdam jetse, mi mba'jtamba quenguy Jesuspit. ");
INSERT INTO zosNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Cuando tujcu'cam jetse, Jesusis yac vøco isvøjøtzøcyaj vyin ñøtuṉdøvø majraṉvini. Mar nøyipø'is Tiberias. Yø'cse tujcu. ");
INSERT INTO zosNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tyumø'omna'ṉ ityaj Simón Pedro, Tomás nøjayajpapø mechipø, Natanael Caná cumgu'yombøte Galilea nasis cyojajmbamø; jendi ityajque't Zebedeo'is 'yuneta'm, y eyapø metzcuy Jesusis ñøtuṉdøvø. ");
INSERT INTO zosNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro'is ñøjayaju: ―Ma'ṉbø ataraya nøviti. Eyata'mbø'is ñøjayaju: ―Øjtzi mati mi mba'jtaṉgue'te. Maṉyaju y tøjcøyaj barco'omo, pero ni ti ja ñu'cyaj jicø tzu'cøsi. ");
INSERT INTO zosNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cuando min sø'ṉbø'tzo'tznømi, Jesús queju nø' acapoya, pero ñøtuṉdøvø'is ji'ṉna'ṉ myusyaje o'ca jetete. ");
INSERT INTO zosNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Entonces Jesusis ñøjayaju: ―Ø mi unenda'm, ¿nuctamutija? Y je'is 'yandzoṉyaju: ―Ji'nda, ni ti ja nucta'møjtzi. ");
INSERT INTO zosNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Entonces Jesusis ñøjmayaju: ―Cojtam mi ataraya mi barco tzø'na'ṉomo, y jetse maṉba nuctame. Jetse chøcyaju, y entonces jøsijcam ji'namna'ṉ jyø'ñaje vacø mus jyuṉbutyaj ataraya porque tasumna'ṉ sone coque'is. ");
INSERT INTO zosNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Entonces jicø nøtuṉdøvø más syunbapø Jesusis, je'is ñøjay Pedro: ―¡Jicø ndø Comite! Apena myan Simón Pedro'is que ndøjtze Ṉgomi, myes tyucu vingøspø porque chajcupøna'ṉete, y tøjcøy nø'cø'mø. ");
INSERT INTO zosNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Eyata'mbø ñøtuṉdøvø nu'cyaj nø' acapoya barcoji'ṉ. Nømna'ṉ jyøcøyaju ataraya tasu coqueji'ṉ, como cien metrosye'ṉomo jojmona'ṉ ityaju. ");
INSERT INTO zosNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cuando putyaj nascøsi, isyaj juctyøc ju'yi y tum coque ju'yicøsi y isyajque'tuti pan. ");
INSERT INTO zosNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesusis ñøjmayaju: ―Nømindam mye'chtiyø coque nømdøc mi nømbujtamupø. ");
INSERT INTO zosNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro qui'm barco'omo y jøcønøput ataraya acapoya, tasupø møjapø coqueji'ṉ. Ijtuna'ṉ ciento cincuenta y tres coque. Aunque vøti ijtu, ja chitz ataraya. ");
INSERT INTO zosNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Entonces Jesusis ñøjmayaju: ―Mindamø, mi ucaṉsa'tamø. Y ni jutipø nøtuṉdøvø'is ja ityajøna'ṉ valor va'cø 'aṉgøva'cyaj iyete. Porque myusyajpana'ṉ que ndø Comimete. ");
INSERT INTO zosNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jicsye'c Jesús nu'cu, pyøc cyø'ji'ṉ pan, vye'nayaj ñøtuṉdøvø, y jetseti vye'nayajque't coque. ");
INSERT INTO zosNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jetse ta'n tu'cay nac que Jesusis yaj cyejayaj vyin ñøtuṉdøvø visa'u'jcam oyu'cam ca'e. ");
INSERT INTO zosNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ucaṉsa'yaju'cam, Jesusis 'yaṉgøva'c Simón Pedro: ―Simón, Jonasis mi 'yune, ¿mijtzi más ndø sunbaja que yø'ṉista'm? Pedro'is 'yandzoṉu ñøjayu: ―Jø'ø, ø mi Ngomi, mitz mi muspa que øtz mi su'nbøjtzi. Jesusis ñøjayu: ―Entonces como cyoquenbapø'is pyø'nøpya byorrego une, jetse mitz coquejnayaj va'ṉjamyajpapø'stzi. ");
INSERT INTO zosNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesusis 'yaṉgøva'cvøjøtzøjcu metzana'jcøsi ñøjayu: ―Simón, Jonasis mi 'yune, ¿mi ndø sunbaja? Pedro'is 'yaṉdzoṉu: ―Jø'ø, ø mi Ṉgomi, mitz mi muspa que øjtzi mi su'nbøjtzi. Jesusis ñøjayu: ―Entonces tø coquejnay va'ṉjamyajpa'is øjtzi como si fuera ø mborregose. ");
INSERT INTO zosNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tu'cañajcøsi 'yaṉgøva'jque'tu ñøjayu: ―Simón, Jonasis mi 'yune, ¿mi ndø sunbaja? Pedro maya'u porque 'yaṉgøva'c tu'cañajcøsi o'ca syunba, y Pedro'is ñøjayu: ―Ø Ṉgomi, mitz mi muspa mumu tiyø, mitz mi muspa que øtz mi su'nbøjtzi. Jesusis ñøjayu: ―Entonces coquejnayaj va'ṉjamyajpapø'stzi como si fuera ø mborregose. ");
INSERT INTO zosNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Viyuṉsye mi ndzajmapyøjtzi, cuando mastøcna'ṉ mi syoca'øc mi ṉgya'møpyana'ṉ mi ⁿvin, y myaṉbana'ṉ jut syunbana'ṉ mi myavø; pero cuando mi ⁿ'yachpø'aju'jcam, sajpe'yu maṉba mi ndzaṉaṉvac mi ṉgø', y eyapø'is maṉba mi ⁿyac tucumese. Y maṉba mi ñømaṉyaje jut ji'n sunimø mi ⁿmyavø. ");
INSERT INTO zosNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesusis chajmayu jetse va'cø cha'maṉvajcay Pedro jujche maṉba ca'e va'cø yaj quejay Diosis myøja'ṉo'majcuy. Jøsi'cam Jesusis ñøjay Pedro: ―¡Mi tø pa'tø! ");
INSERT INTO zosNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Cuando que'najvitu'u, Pedro'is isu que nømna'ṉ myaṉ pya't jic nøtuṉdøvø'is lo que jutipø más syungo'nba Jesusis, y mismo nøtuṉdøvø cuando nø cu'taṉbacyaju'c Jesusis syaya'om ijtu, y oyuna'ṉ 'yaṉgøva'que: “Ø Ṉgomi, ¿is manba mi ñchi'ocuyaj mi enemigocøsi?” ");
INSERT INTO zosNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cuando Pedro'is isu jic nøtuṉdøvø, 'yaṉgøva'c Jesús Pedro'is: ―Ø Ṉgomi, ¿y jic pø'nis ti maṉba chøqui? ");
INSERT INTO zosNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesusis ñøjayu: ―O'ca øtz su'nbøjtzi jic pøn va'cø quena hasta que øtz vitu'pacsye'ṉomo, ¿tiyø cuenta mi mba'tpa mijtzi? Mitz mi tø pa'tø. ");
INSERT INTO zosNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Por eso nø chamyajtøju que jic nøtuṉdøvø ji'na'ṉ ma cya'e. Pero Jesusis ja ñøjayø que ji'na'ṉ ma cya'e, na más que nømu: “O'ca øtz su'nbøjtzi va'cø cyena øtz vitu'pacsye'ṉomo, ¿ti cuenta mi mba'tpa?” ");
INSERT INTO zosNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yøṉete mismo nøtuṉdøvø cyotestigosajpapø'is yøcsepø tiyø y jyachø'yupø'is, y ndø mustamba que cyotestigosajpa viyuṉsyepø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Itque'tuti sone eyata'mbø tiyø chøjcupø Jesusis. O'ca jachø'yuna'ṉ muma'ṉgø'i lo que Jesusis chøjcuse, ji'ṉa'ṉ ma tøjcøpø'i libro nascøsi, tascocøjtumna'ṉ nasacopac libruji'ṉ jyayupø'omo ti chøc Jesusis. Amén.");
INSERT INTO zosNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, nø'mø mi ⁿjajyay mijtzi. Øtz o'yø ⁿjay vi'na mumu tiyø lo que Jesusis chøctzo'tzuse y 'yaṉma'yocho'tzuse ");
INSERT INTO zosNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta je jama nømaṉdøj møji. Antes que maṉba mave, Jesusis 'yaṉgui'myaj apostoles ñe'c cyøpiṉyajupø. Masanbø Espíritu Santo'is chi'use qui'psocuy, jetse 'yangui'myaju. ");
INSERT INTO zosNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Y oyu'cam is toya, Jesusis ni ji'n tumnac yac isyaj vyin apostoles va'cø myusyajø que viyuṉsye quenbati. Jesusis yaj quejayaj vyin cuarenta jamapit y chajmayaju jujche 'yaṉgui'mbase Dios. ");
INSERT INTO zosNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Entonces apostoles tu'mbøyaju y Jesusis angui'myaju va'cø jana chu'ṉyaj Jerusalén gumgu'yomo, ñøjayaju: ―Jo'ctamø lo que ti chamuse ndø Janda'is que maṉba mi ñchi'tame, jujche oyuse mi ndzajmatyam øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Porque Juan viyuṉsye nø'ji'ṉ nø'yø'yoyu; pero usyaṉ horacøsi øtz ma'ṉbø mi nø'yøndyame Masanbø Espiritu Santoji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Entonces cuando tu'mbø'yajque'tu, apostolesis 'yaṉgøva'cyaj Jesús: ―¿Yøti maṉbaja mi yac vøco'aṉgui'mgue't vø'cumguy Israel cumgu'yomo? ");
INSERT INTO zosNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesusis 'yandzoṉyaju: ―Diosis ji'n syuni va'cø mi mustam mitzta'm tiyø jama, jutipø hora maṉba tucnømi lo que ndø Janda Diosis maṉba yac tucnømi ñe'c 'yaṉgui'mguji'n. ");
INSERT INTO zosNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero maṉba nu'c mitzcøsta'm Masanbø Espiritu Santo, y je'is maṉba mi nchi'tam musocuy va'cø mi ndø cotzamdamø. Maṉba mi ndø cotzamdame Jerusalén gumgu'yomo, y entero Judea nasomo, y Samaria nasomo, y hasta más ya'ipø lugar mumu nas vindumø. ");
INSERT INTO zosNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Cuando cha'maṉjeju'cam Jesusis yøcsepø tiyø, entonces mientras nø 'ya'myaj apostolesis, Jesús nøqui'mdøj møji, y ñuc o'na'is, iscøtocoyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Y mientras que Jesús nøqui'mu'øc, apostolesis nømna'ṉ 'ya'mgøqui'myaj mø'chøqui. Y jovisyeti te'ñaj jetcø'mda'm metzpøn popo tucuta'mbø; ");
INSERT INTO zosNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Y ñøjayaju: ―Galilea nasom mi ⁿijtamupø'is, ¿ti'ajcuy yø'c nø mi ndye'ndamu nø mi ṉgyengui'mdam tzajpomo? Mismo Jesús jujche mi istam maṉuse møji, jetseti maṉba vitu'que'te. ");
INSERT INTO zosNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jicsye'c tzu'ṉyaj ñøjayajpamø Olivos cotzøjcøsi, y vitu'yaj Jerusalén gumgu'yomo. Olivos cotzøc ispa Jerusalén gumgu'is jujche'ṉom muspa'csye'ṉom vityaj sapøjcuy jama'omo. ");
INSERT INTO zosNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nu'cyaj cumgu'yomo y tøjcøyaj tyøjcomo y qui'myaj møjipø cuarto'omo. Jiṉ ityajuna'ṉ Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolome, Mateo, Alfeo'ise 'yune Jacobo, Simón Zelote, y Jacobo'ise tyøvø Judas. ");
INSERT INTO zosNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mumu yøṉda'm tumbø qui'psocuji'ṉ 'yo'nøyajpana'ṉ Dios. Jetji'ṉ ityajuna'ṉ yomota'm, y Jesusis myama María y Jesusis myuquita'm. ");
INSERT INTO zosNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ityajuna'ṉ como ciento veinte tumyajupø. Jic jama Pedro te'ndonchu'ṉu va'ṉjajmocuy tøvø'is cyucmø y nømu: ");
INSERT INTO zosNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Øjtzø mi ndøvøta'm, tiene que va'cø tyucø jachø'yuse Diosis 'yote. Masanbø Espiritu Santo'is chi' David qui'psocuy va'cø jyayø jujche ma tuc Judas, isindzi'ocuyajupø'is jut it Jesús va'cø ñucyaj 'yenemigo'is. ");
INSERT INTO zosNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas tø øtzji'ṉbøna'ṉete, y oti chi'jo'y yøṉ yoscuy Jesusis va'cøna'ṉ tyumøyos tø øtzji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Je'is pyøc tumin yatzipø chøquipit, y jetji'ṉ jyuy nas. Jen japna quec nasomo y pyac jet chec y cutzu putpø'u pyu'u. ");
INSERT INTO zosNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Y myusyaju mumu Jerusalén gumgu'yomdambø'is, y por eso yac nøyji'ajyaj jicø nas quejcumø Judas ñe' 'yote'omda'm Acéldama. Pero ndø onde'omo putpa Nø'pin nas. ");
INSERT INTO zosNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Porque jachø'yupøṉø Salmos libro'omo: Tumdi yac tzø'y itcuy. Uy ñøc'ijtøy ni i'is. Y nømgue'tpa: Yac pøjcøchoṉ eyapø'is je'is yoscuy. ");
INSERT INTO zosNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","”Yø'c ityaj pønda'm oyupø vityaj tø øtzji'ṉda'm jujche tiempo oyuse viti tø øtzji'ṉda'm ndø Comi Jesús, ");
INSERT INTO zosNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","desde que Jua'nis ñø'yøyu'csye'ṉomo, hasta que Jesús yac tzu'ṉdøj tø øjtzøcø'mda'm y nømaṉdøj møji. Tum je pøn tu'mbac ndø nøvijtamupø tiene va'cø ndø cøpiṉdamø va'cø cyotzam tø øtzji'n que visa' ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Entonces cyøpiṉyaj metzpøn; tum José ñøyipø'istique't Barsabás, y ñøyi'aṉgopac Justo. Y cyøpiṉyajque't Matías. ");
INSERT INTO zosNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Y 'yo'nøyaj Dios ñøjayaju: ―Ø mi Ngomi, mitz mi musapya mumu pø'nis chocoy. Yø'c it metzcuy pøn. Isindzi'ø jutipø mi ṉgøpiṉu ");
INSERT INTO zosNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","va'cø pyøc aṉgui'mguy y apostolesajcuy Judasis tyocojayupø, porque yatzitzoco'yaju, y maṉu jut syunumø Diosis va'cø cyota cyojacøtoya. ");
INSERT INTO zosNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Entonces syijputyaj syuerte, y Matiasis gyanatzøjcu. Y jetji'n ta'n doce apostoles. ");
INSERT INTO zosNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cuando ta'nbø' jyama va'cø chøc søṉ ñøyipø'is Pentecostés, ityajuna'ṉ mumu tu'myajupø tyumø'omo. ");
INSERT INTO zosNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Y joviti oy ajṉøyñøm tzajpomo jujche ajṉøpyase sava pyopyapø pømi, y ajṉoctas tøc jujna'ṉ po'csyajumø. ");
INSERT INTO zosNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Entonces isyaj como si fuera juctyøc metz ve'nuse, y je juctyøc nema vi'na eyapø pøngøs nu'cu. ");
INSERT INTO zosNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Y Masanbø Espiritu Santo'is cyøtøjcøyaj mumu tasyajpa'csye'ṉomo, y ondzo'chaj eyata'mbø ote'omo jujche Espiritu'is chi'yajuse musocuy va'cø 'yoñajø. ");
INSERT INTO zosNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jic jama ityajuna'ṉ Jerusalén gumgu'yomo Israel pøn cøna'tzø'oyajpapø tzu'ṉyajupø aunque jujta'mbø cumgu'yom jujche'ṉom ijnømuse mumu nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Cuando jetse a'ṉøñømu'øc, tu'myaj vøti pøn, y nømna'ṉ qui'psyaj ti nø tyujcu; porque tumdum pø'nis myanu nø 'yoñaju mismo ñe'c oñajque'tpase. ");
INSERT INTO zosNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Y mumu maya'yaju y qui'psyaju jutznøm jetse nø 'yoñaju, y nømyaju: ―Como Galilea nasomda'mbø mumu yøṉ nø 'yoñajupø ");
INSERT INTO zosNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿jujche nø ndø mandamu como tø ne'c tø ondambase como tø pø'najtamumø? ");
INSERT INTO zosNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Porque tø øtz tø tzu'ṉdam vøti cumgu'yomo. Vene tzuṉyaj Partia nasomo, eyata'mbø tzu'ṉyaj Media nasomo, it tzu'ṉyajupø Elam nasomo, Mesopotamia nasomo, Judea nasomo, Capadocia nasomo, Ponto nasomo, Asia nasomo, ");
INSERT INTO zosNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia nasomo, Panfilia nasomo; Egipto nasomo; it tzu'ṉyajupø Africa nasomo Cirene cumgucyøtumøṉ. Ityaj Roma cumgu'yom tzu'ṉyajupø nø vyityajupø yø'qui. Ityaj tø øjtzomda'm Israel pøn y Israel pø'nis vya'ṉjajmocuy pyøjcøchojṉayajupø'is. ");
INSERT INTO zosNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ityajque't Creta nasom tzu'ṉyajupø y Arabia nasom tzu'ṉyajupø; pero mumu ndø mandamu nø 'yoñajupø ndø ne'c ndø onde'omda'mdique't. Nø chamyaj je'is jujchepø chøcpase Diosis myøja'ṉomda'mbø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Y mumu ñømaya'yaju y ja pyensatzøcyaj ti nø tyujcu, ti nø chøcyaju; y na ñøjayajtøju: ―¿Ti'ajcuy jetse nø tyucnømu? ");
INSERT INTO zosNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero eyata'mbø'is syijca'yaju nømyaju: ―Tyo'ṉyaj vøti vinu. ");
INSERT INTO zosNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Entonces Pedro te'nchu'ṉ oncepø apostolesji'n y pømi 'yo'nøyaju; ñøjmayaju: ―Mi Judea nasomda'mbø'is, y mumu mi ijtamupø'is Jerusalén gumgu'yomo; cøma'nøtyam ø onde va'cø mi mustam ti ma'ṉbø mi ndzajmatyame. ");
INSERT INTO zosNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Porque yøṉda'm ja ño'tyajøpøṉø como mitz nø mi ṉgomo'tyamuse que no'tyajupøṉø; porque nømdøc myaṉ a las nueve de la mañana. ");
INSERT INTO zosNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pero jujche vi'na oyuse cha'maṉvac tza'manvajcopapø Joejlis, jetse nø tyucnøm yøti. Joejlis jyayu que Dios nømu: ");
INSERT INTO zosNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Cuando ya mero maṉba'c yajnømi, øtz ma'ṉbø ṉgø'vej ø Espiritu mumu pøngøsi. Maṉba tza'maṉvajcoyaj mi ⁿjaya unenda'm y mi ⁿyom 'unenda'm. Mi soca'sta'm maṉba isyaj ji'n ndø istamepø tiyø; mijtzomda'mbø tzambøn maṉba napasyi'øyaje. ");
INSERT INTO zosNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Viyuṉsye mumu lo que yosyajpapø para øtzcøtoya, sea pøn, sea yomo; jetcøsta'm vøti ma'ṉbø yac nu'c ø Espiritu je jama'omo, y maṉba tza'maṉvajcoyaje. ");
INSERT INTO zosNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Y ma'ṉbø yac istøj milagro'ajcuy møji tzapcøsi; y ma'ṉbø yac istøj seña cø'yi nascøsi; nø'pinse y juctyøcse y jocoseta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sø'ṉbapø jama maṉba pi'tzø'aje, y poya maṉba tzapasaje como nø'pinse. Jetse maṉba tucnømi cuando maṉba'jcam nu'c ndø Comi'is myøja'ṉombø jyama, ji'n ndø isipø mumu jama jetsepø. ");
INSERT INTO zosNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Y mumu 'yo'nøyajpapø'is ndø Comi va'cø cyotzoṉyajø, jet maṉba cotzocyaje. ");
INSERT INTO zosNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","”Israel pø'nista'm, tø cøma'nøjatyam ø onde lo que maṉbapø mi ndzajmatyame. Diosis chi' Jesús Nazaret cumgupyøn musocuy va'cø chøc milagro'ajcuy y ji'ndø isipø tiyø y seña mijtzomda'm va'cø mi mustamø que Diosise cyø'vejupø. Sa'sa mi mustambati que jetse tujcu. ");
INSERT INTO zosNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero yøṉ Jesús tzi'ocuyajtøju mitzcøsta'm conforme Diosis vi'nati cyoqui'psuse y myususe y syunuse va'cø jetse tucø. Mitz mbøtam Jesús y mi ndzi'ocuyajtam yatzita'mbø pø'nis cyø'omo va'cø mya'møyaj cruzcøsi va'cø yaj ca'yajø ");
INSERT INTO zosNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero ca'u'jcam, Diosis yac visa'u, porque ja mus chø'y ca'upø. ");
INSERT INTO zosNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Porque peca pøn Davijdis jyachø'yu vi'na jujche maṉbase nøm Jesús; nømu: Mumu jama ispana'ṉtzi ndø Comi Dios ø vinaṉdøjqui; tome it øtzcø'mø va'cø cotzoṉø, va'cø jana tzocomochi'aj øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Por eso ø ndzocoy alegre'aju y casøpya vejvejne'yøjtzi. Aunque niptøj ⁿø sis, muspøjtzi que vyøjom ma'ṉba puti. ");
INSERT INTO zosNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Porque ji'n ma mi ndø tzajcay ø espiritu ityajumø ca'yajupø. Ni ji'n ma mi ndø tzajcay ⁿø sis va'cø pyutzø; øjchøṉø mi ndø sunbapø. ");
INSERT INTO zosNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mi ndø isindzi' ndøvø tuṉ va'cø nu'c pøjipø quengu'yomo, mi ndø yaj casøy vøti mi vi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Y Pedro nømgue'tu: ―Øjtzø mi ndøvøta'm, jana na'tzcuy muspa mi ndzajmatya'mø que ø jandatzu'ṉguy David ca'u y niptøju y quejpa jut niptøjumø hasta como yøti. ");
INSERT INTO zosNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero Davijdis chamu jujche maṉba tucnøm jøsi'cam. Myusu que Diosis chambøjcay ñe'c ñøyi cuando chajmay que ñe'c Davijdis fyamilia'omo maṉba pø'naj Cristo va'cø 'yaṉgui'mø como ñe'c David aṉgui'muse. ");
INSERT INTO zosNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davijdis vi'nati myusu jujche maṉba tucnøm más jøsijcam. Así es que chamu que maṉba visa' Cristo, que Diosis ji'n ma chajcay 'yespiritu ityajumø ca'yajupø y syis ji'n ma pyutzi. ");
INSERT INTO zosNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yøṉ Jesús yac visa' Diosis y øtz muspa ngotzamdamø que visa'u. ");
INSERT INTO zosNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Así es que yøti Diosis yac møja'ṉo'maj Jesús ñe'c chø'na'ṉomo, y Jesusis pyøjcøchoṉu'am Masanbø Espiritu Santo Diosis vi'na chajmayu que maṉba chi'i. Y yøti Jesusis nømdi yac mø'n Espiritu Santo, y por eso mi istamba y mi mandamba lo que nø chøjcupø Espiritu Santo'is. ");
INSERT INTO zosNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Porque David ja qui'm tzajpomo, pero ñe'c nømu: Ndø Janda Diosis ñøjay ø Ṉgomi: “Po'cs ø ndzø'na'ṉomo, maṉba mi yac aṉgui'mi, ");
INSERT INTO zosNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta que øjtzi maṉba mi ṉgønu'cøjayaj mi enemigota'm”. ");
INSERT INTO zosNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","”Por eso, hay que va'cø mi ñchi'tam cuenta viyuṉsye mumu eyata'mbø Israel pønji'ṉ que Diosis yaj comi'aju y yac Cristo'aju mismo je Jesús mi yaj ca'tamupø cruzcøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Myañajujcam chamuse Pedro'is, toyaj choco'yomo, y ñøjayaj Pedro eyata'mbø apostolesji'ṉ: ―Tøvøy, ¿ti vøjø va'cø ndø tzøctamø? ");
INSERT INTO zosNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro'is ñøjayaju: ―Qui'psvitu'tamø, nø'yøtamø tumdum pøn mitzta'm Jesucristo'is ñøyicøsi va'cø cyøtocotyam mi ṉgoja, y maṉba mi mbøjcøchondam Masanbø Espiritu Santo Diosis tø sunchi'papø. ");
INSERT INTO zosNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Diosis chamu que maṉba mi nchi'tam je Masanbø Espiritu Santo mijtzi mi uneji'ṉda'm, y mumu pøn ya'icse'ṉom ityajupø maṉbati chi'yajque'te. Mumu pøn vyejayajupo ndø Comi Diosis, je'is maṉba pyøjcøchoṉyaje ti chamdzi'ocuyajuse Diosis. ");
INSERT INTO zosNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Y vøti eyapø ote chajmayaj Pedro'is y chi'yaj qui'psocuy; ñøjmayaju: ―Yaj cøtocotyam mi ⁿvin va'cø jana mi ndyocotyam parejo yøṉ yatzita'mbø pønji'ṉ yøti ityajupø. ");
INSERT INTO zosNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Entonces casøpya pyøjcøchoṉjayaju'is 'yote nø'yøyaju. Y mismo je jama tu'cay mil ijtaṉøyaju vya'ṉjamyajpapø'is Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Seguitzøcyaju va'cø vya'ṉjajmayaj mø'chøqui apostolesis 'yaṉma'yocuy, y tumøpø quipsocu'yomo ityajpana'ṉ. Vyenve'ñaj pan tyumø'om ityajumø va'cø jyajmutzøc ndø Comi, y 'yo'nøyajpana'ṉ Dios. ");
INSERT INTO zosNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Y mumu pø'nis ña'chaju cuando isyaj ti chøcyaj apostolesis, y apostolesis chøcyaj vøti milagro'ajcuy y seña. ");
INSERT INTO zosNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mumu vya'ṉjamyajpapø'is tyumø'om ityaju y na ñøtzi'yajtøjpana'ṉ aunque ti ñø'ityajupø. ");
INSERT INTO zosNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mya'ayajpana'ṉ ti nø ityajupø y vye'nayajpana'ṉ cyoyoja; chøjcayajpapøna'ṉ falta aunque ti'is, jet vye'ndzi'yajpana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tumdum jama ityajpana'ṉ masandøjcomo, tumbø qui'psocuy ñø'ityajpana'ṉ. Tøcmayena'ṉ cøtyajpa va'cø vye'ngutyaj pan. Jetse alegre vi'cyaju y tumchocoy su'noyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Vyøcotzøcyajpana'ṉ Dios; y vya'ṉjamyajpapø'is Jesús, jet vyøcotzøcyajpana'ṉ mumu pø'nis, y tumdum jama yac ijtaṉøyajpana'ṉ tu'myajpapø. Ndø Comi'is yac tøjcøyajpana'ṉ nømna'ṉ cyotzocyajupø. ");
INSERT INTO zosNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedro y Juan nømna'ṉ qui'myaj tyu'mbac masandøjcomo, nu'cu'jcam hora va'cø 'yo'nøyaj Dios, como a las tres de la tarde. ");
INSERT INTO zosNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Y ijtuna'ṉ tum pøn yu'quipø'is cyoso; jetse pyø'najuse. Tumdum jama ñømaṉyajpana'ṉ va'cø ma cyot masandøc aṉdyuṉgø'mø. Je aṉdyuṉ ñøjayajpana'ṉ Suñipø Aṉdyuṉ. Jena'ṉ vya'cpa tumin tøjcøyajpapøcøsi masandøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yø'ṉis is Pedro y Juan que maṉbana'ṉ tøjcøyaj masandøjcomo y vya'cayajque'tuti tumin. ");
INSERT INTO zosNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro'is y Jua'nis 'ya'maṉga'yaj yu'quipø'is cyoso y Pedro'is ñøjayu: ―Tø a'mdamdøvø. ");
INSERT INTO zosNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Entonces yacsupø'is cyoso 'ya'myaj mø'chøqui Pedro y Juan, nømna'ṉ jyo'cu algo ti maṉba chi'yaje. ");
INSERT INTO zosNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero Pedro'is ñøjayu: ―Ja ñø'ijtøjtzi ni jujchepø tumin, ni platapø, ni oropø; pero lo que nø'ijtupø øjtzi maṉba mi ndzi'. Nazaret cumgupyøn Jesucristo'is ñøyicøsi te'nchuṉø y vitø. ");
INSERT INTO zosNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Y ñuc chø'naṉgø'cøsi jitite'nu. Jicsye'cti oy pømi pøc cyoso y tyoṉgo u'tzø. ");
INSERT INTO zosNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Y tøptonde'nu y caṉdondzu'ṉu y parejo tøjcøyaj Pedroji'ṉ y Juanji'ṉ masandøjcomo vitpa y tøjvitpa y vyøcotzøcpa Dios. ");
INSERT INTO zosNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Y isyaju aunque i'is nø vyijtupø y nø vyøcotzøc Dios. ");
INSERT INTO zosNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Y ispøcyaju que jetemete po'cspapø y vya'cpapø'is tumin masandøc aṉdyuṉgø'mø ñøjayajpapø Suñipø Aṉdyuṉgø'mø. Nømyaju: “¿Jutznøm nø vyijtu, y ji'na'ṉ vitipø?” Jetse ñømaya'comø'ñaju porque tzojcu. ");
INSERT INTO zosNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Cho'ṉnøvityaj Pedro y Juan yacsupø'sna'ṉ cyoso. Y vøti pø'nis popya cyønu'cyaj jejta'm ñøjayajpamø Salomo'nis cyoredojromo, y o'ca jujchese tucyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Cuando isu que nømna'ṉ tyu'myaj vøti pøn, Pedro'is ñøjayaju: ―Mi Israel pønda'm, ¿ti'ajcuy mi ndø a'maṉga'tamba? Ji'ndyet ø ne'c ø mbømipit, ji'ndyet ø ne'c ø ⁿvø'ajcupit nø ⁿyac vijtam yøṉø. ");
INSERT INTO zosNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dios lo que vya'ṉjamyajupø Abraha'mis y Isaajquis y Jacojpis y eyata'mbø ndø Janda tzu'ṉgu'is, mismo ne'c je Diosis vyøcotzøc 'Yune Jesús. Pero mitz mi ndzi'ocuyajtam Jesús aṉgui'mbapø Pilatocøsi, y cuando Pilato'is maṉbana'ṉ syombø'i, ja mi sundamø va'cø sømbø'tøjø. ");
INSERT INTO zosNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mijtzi ja mi sundamø va'cø syombø'tøj masanbø y vøjpø pøn; en cambio yaj ca'opyapø mi sundamu va'cø mi yac sombøjatyandøjø. ");
INSERT INTO zosNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Y mi yaj ca'tam tø tzi'tamba'is quenguy; pero Diosis yac visa'u ca'yajupø'omo. Y øtz ista'møjtzi visa'upø, y muspa ndzamdamø que viyuṉete visa'u. ");
INSERT INTO zosNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mitz mi istambana'ṉ y mi ispøctamba yøṉ pøn que yacsyupøna'ṉete, pero yøti Jesusis milagro'ajcupit pømipøjcu, porque vya'ṉjajmu aṉcø Jesús. Jesusis tø tzi'pa va'ṉjajmocuy, y yøṉ pø'nis vya'ṉjajmu y por jicpit yac tzoc mø'chøqui mumu mi vi'naṉdøjquita'm. ");
INSERT INTO zosNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","”Pero yøti, ø mi ndøvøta'm, muspøjtzi que ja mi mustam mijtzi tiyø mi ndzøctamupø cuando mi yaj ca'tam Jesús, ni mi ṉgovi'najø'is ja myusyajque'tati. ");
INSERT INTO zosNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero Diosis yac tuc yøcse ñe'c Diosis oyuse chame ya'møc que maṉba toya'is Cristo ñe'c Diosis cyø'vejupø. Jetse o chamboyaje mumu tza'maṉvajcoyajpapø'is Diosis chi'yajuse qui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Por eso qui'psvitu'tamø y vitu'tam Dioscøsi va'cø jyacya'use tuc mi ṉgojata'm. Jetse maṉba min je jama va'cø mi yaj cøsujcøjatyam ndø Comi'is. ");
INSERT INTO zosNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Y maṉba cyø'vej Jesús Diosis cyø'vejupø como oyuse mi ncha'maṉvajcatyandøji. ");
INSERT INTO zosNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jetse Jesús tiene que jiṉ va'cø it tzajpomo hasta que nu'cpa tiempo cuando Diosis maṉba jyomecotzøcpø' mumu tiyø, como chamuse desde ya'møcpø hora'omo. Diosis chi'yaj qui'psocuy masanbø tza'maṉvajcoyajpapø lo que ñe'c cyø'vejyajupø jetse va'cø chamboyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Por que Moisesis ñøjayaj ndø jandatzu'ṉgutya'm: “Ndø Comi Diosis maṉba cyøpiṉ tum pøn mi ndøvø'omda'm va'cø cha'maṉvajcoya como øtz ndza'maṉvajcopyase. Cøma'nøtyamø mumu ticøsi maṉbase mi nchajmatyam ji'quis. ");
INSERT INTO zosNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Porque maṉba tocoy aunque ipø pøn ji'n cyøma'nøyipø'is jic tza'maṉvajcopyapø; maṉba tocoy va'cø jana it je pø'nomo”. ");
INSERT INTO zosNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","”Viyuṉete Samuejlis chamaṉvactzo'tz como jujche maṉbase tuc yøti, y jetseti cha'maṉvacyajque'tu mumu tza'maṉvajcoyajpapø'is jøsijcam miñajupø'is. ");
INSERT INTO zosNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Y mitzcøtoyata'mete vøjpø tiyø cha'maṉvacyajuse je'is; y je contrato chøjcupø Diosis ndø janda tzu'ṉguji'ṉ, mitzcøtoyata'mdique't. Cuando Diosis chøc contrato ndø janda tzu'ṉguy Abrahamji'n, yøcse nømu: “Ma'ṉbø ⁿyac yos mi ndzacyajupø uneta'm va'cø ngømasa'nøyaj mumu nascøsta'mbø pøn”. ");
INSERT INTO zosNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yac visa Diosis ñe' 'Yune Jesús para mitzcøtoyata'm vi'na va'cø mi yac tzactam tumdum pøn mi yandzitzoco'yajcuy, y jetse va'cø mi ṉgyømasa'nøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nømna'ṉ 'yo'nøyaj Pedro'is y Jua'nis pønda'm, cuando cyønu'cyaj Pedro y Juan Israel pane'sta'm y masandøjcombø aṉgui'mba'is y saduceo va'ṉjajmocuy ñø'ityajupø'is. ");
INSERT INTO zosNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Qui'syca'yaju porque Pedro'is y Jua'nis nømna'ṉ 'yaṉmayaj pønda'm, y qui'syca'yaju porque chamyaju que ca'yajupø maṉba visa'yaje porque Jesús visa'u ancø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Por eso ñucyaj Pedro y Juan; y porque tza'imna'ṉ, syomyaju; jyo'pitøc va'cø 'ya'myaj tiyø cyoja. ");
INSERT INTO zosNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero vøti cyøma'nøjayajupø'is Diosis 'yote vya'ṉjamyaju, y ta'ñaj como mosay mil pøn va'ṉjajmoyajpapø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Entonces jyo'pit tu'myaj Jerusalén gumgu'yomo cumgu'is cyovi'najøta'm y tzambøndam y aṉma'yoyajpapø aṉgui'mgupit. ");
INSERT INTO zosNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tu'myajque'tuti panecovi'najø Anás; y jendi ityajque't Caifás y Juan y Alejandro y mumu pane covi'najø'is tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Y cyotyaj Pedro y Juan cyujcomo y 'yocva'cyaju: ―¿I'is 'yaṉgui'mguji'ṉ y i'is ñøyicøsi mi ndzøctamba como mi ndzøctamuse? ");
INSERT INTO zosNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Entonces Pedro cyøtøjcøy Masanbø Espiritu Santo'is tasu'csye'ṉomo, y Pedro'is ñøjayaj pøn: ―Mi ṉgyumguy covi'najø'sta'm y mi Israel tzambø'nista'm: ");
INSERT INTO zosNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Pues yøti nø mi ndø aṉgøva'ctamu jujche ndzøcta'møjtzi vøjpø tiyø yacsyupø pøngøsi, jujche tzojcu. ");
INSERT INTO zosNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Maṉba mi ndzajmatyam mijtzi y mumu Israel pøn: Nazaret cumgupyøn Jesucristo'is milago'ajcupit tzoc yøṉ pøn mi istambapø mi vi'naṉdøjquita'm. Jesús oy mi ma'møndyam cruzcøsi; pero después que ca'u'jcam, ñe'c Diosis yac visa'u. ");
INSERT INTO zosNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Como tum tza' tøc tzøcyajpapø'is ja syuñajø, jetse mitz ja mi sundam Jesús. Pero como si fuera eyapø'is pyiṉ je tza' va'cø cyot tøc angui'nomo más vøjpø tza' syunbamø; jetse Diosis yac møja'ṉo'maj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Y único je Jesús tø Yajcotzocpapø'is, ja it eyapø. Porque ja it eyapø pøn nascøsi Diosis cyojtupø mumu pø'nomo muspapø'is tø yaj cotzoctamø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Entonces covi'najø'sta'm isyaj Pedro y Juan que ja ña'chajø, y cønøctyøyøyaju que ja más myusoyaj Pedro y Juan y i jana ita'mdite, y por eso qui'psyaju jutznøm muspa yac tzoc pøn Pedro'is y Jua'nis. Entonces chi'yaj cuenta que Pedro y Juan o vityaj Jesusji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Como isyaj covi'najø'is pøn tzojcupø Pedro y Juanji'ṉ te'nupø, ni jujchena'ṉ ji'n mus 'yaṉdzoṉdyaj Pedro. ");
INSERT INTO zosNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Por eso 'yaṉgui'myaju ne'ti va'cø yac maṉyaj Pedro y Juan va'cø jana ityaj covi'najøta'mbø'is cyujcomo; y entonces na ñøjayajtøju: ");
INSERT INTO zosNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","―¿Ti muspa ndø nøndzøctam yøṉ pøn? Porque viyuṉse mumu ityajupø'is Jerusalén gumgu'yomo myusyajpa que je'tista'm chøcyaj møja'aṉ milagro'ajcuy, y ji'n mus tø nømdamø que ja chøcyaj milagro'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero ma ndø tzøcna'tzta'i va'cø jana chajmayaj eyata'mbø pøn Jesusis 'yaṉma'yocuy; va'cø jana myusyaj más eyata'mbø'is. ");
INSERT INTO zosNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Entonces ñøvejyaj Pedro y Juan y 'yangui'myaju que ni jutipø va'cø jyana tzajmayajø Jesusis ñøyi, ni va'cø jyana aṉma'yoyajø Jesusis 'yaṉma'yocucyøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Entonces Pedro'is y Jua'nis ñøjmayaj cyovi'najøta'm: ―Qui'pstam mi ne'ṉgø o'ca mitzta'm más vøjø Diosis vi'naṉdøjqui va'cø mi ṉgøna'tzøtyamø que ji'n Dios. ");
INSERT INTO zosNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Porque øtz ji'nø mus jana ndzamdamø lo que øtz istamupø y øtz mandamupø, tiene que va'cø ndzamdamø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Entonces aṉgui'mba'sta'm chamna'chajque'tu y syombø'yaj Pedro y Juan. Ja mus ni jutz nøm cyastigatzøcyajø porque ña'chaj vøti pøn, porque mumutina'ṉ vyøcotzøcyajpa Dios porque tzoc ca'epø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Porque pøn milagrovinipit yac tzoctøjupø, cuarenta añoco'nipømna'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Chøcøpø'yajumna'ṉ Pedro y Juan, maṉyaj tyøvø'omda'm. Y chajmayaj tyøvø mumu jujche ñøjayajuse pane covi'najø'sta'm y tzambø'nista'm. ");
INSERT INTO zosNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Y cuando myañaju tyøvø'is ti chamyaju, mismo tumbø qui'psocuji'ṉ pømi o'nøyajpana'ṉ Dios; ñøjayaju: ―Øjtzø mi Ngomi: mijtzete Dios. Mitz mi jyomejcupø'is tzap y nas y na'nchaṉbø nø' y mumu lo que ti ijtupø je'tomo yempe juti. ");
INSERT INTO zosNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mitz oy mi ndzi' mi ndzøsi David qui'psocuy va'cø ñømø: ¿Ti'ajcuy nø ño'ti'ajyaj pønda'm, y ti'ajcuy pø'nista'm nø qui'psyaj suniti? ");
INSERT INTO zosNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tu'myaj nascøspø aṉqui'myajpapø y covi'najøta'mbø va'cø qui'sayaj ndø Comi Dios y Cristo je'is cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","”Porque viyuṉse yøṉ cumgu'yomo tu'myaj Herodes y Poncio Pilato y Israel pønda'm y eyapø pønda'm lo que ji'ndyet Israel pønda'm. Tu'myaju va'cø qui'sayaj masanbø mi ⁿUne Jesús mitz mi ṉgøpiṉupø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tu'myaju va'cø chøcyajø mitz ṉgui'psøpo'use va'cø tyucø, y mi ndzi'yajuse licencia va'cø chøcyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Y yøti, øjtzø mi Ṉgomi, a'mø jujche je'is tzamna'tztamuse. Y como mijchøṉ ndø tzøsita'm, tø tzi'tam ndøvø qui'psocuy va'cø mus ndza'maṉvactam mi onde jana na'tzcuy. ");
INSERT INTO zosNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Y cot mi ṉgø' ca'eta'mbøcøsi va'cø chocyajø, va'cø tyuc milagro'ajcuy y maya'ṉda'mbø tiyø masanbø mi ⁿUne Jesusis ñøyicøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Y 'yo'nø'aṉjeju'cam Dios, mics tøc tu'myajumø. Y Masanbø Espiritu Santo'is cyøtøjcøyaj mumu tasyajpa'csye'ṉomo, y chajmayaj Diosis 'yote jana na'tzcuy. ");
INSERT INTO zosNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Y mumu vya'ṉjamyajpapø'is Jesús ñø'ityajuna'ṉ tumbø tzøcoy y tumbø qui'psocuy. Y ni jutipø ja ñømø: “Øjtzene”, ni jujchepø ticøsi, a'mbø'ne'ete mumu tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Y vøti pømiji'ṉ cyotzamyaj apostolesis que visa' ndø Comi, y Diosis cyotzoṉyaj mumu ñe'c vyø'ajcupit. ");
INSERT INTO zosNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Y ni jutipø je'tomda'm ja chøjcayaj falta ni ti'is, porque mumu ñø'ityajupø'is nas o tøc mya'ayajpana'ṉ y ñømaṉyaj tumin jujchecøs mya'ayajuse ");
INSERT INTO zosNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","y chi'yajpana'ṉ tumin apostoles. Y apostolesis ñøve'ñajpana'ṉ. Chøjcayajupø'is falta aunque ti'is, jet vya'ctzi'yajpana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ijtuna'ṉ tum pøn ñøyipø'is José. Apostolesis yac nøyi'ajque't Bernabé. Va'cø ndø tza'maṉvac ñøyi ndø onde'omo, nømba, Yajcontento'ajpapø'is. Chipre nasombøte y Levi'is chajcupø 'yunete. ");
INSERT INTO zosNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Je'is ñø'ijtuna'ṉ nas y mya'ayu y ñønu'cay cyoyaja y chi'yaj apostoles. ");
INSERT INTO zosNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Y ijtuna'ṉ tum pøn ñøyipø'is Ananías y yomo'is ñøyina'ṉ Safira. Je'is mya'ayajque't nas. ");
INSERT INTO zosNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Veneti cyoyoja yaj quejayu y vene 'yaṉgøvø'nayu va'cø ñe'c ñøyosa, y nømdina'ṉ myusque't yomo'is. Veneti ñønu'cay cyoyoja y chi'yaj apostoles. ");
INSERT INTO zosNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pero nøjay Pedro'is: ―Ananías, ¿ti'ajcuy mi ndzi' lugar Satanás va'cø mi ñøtzøcø, va'cø mi sujtzay Masanbø Espiritu Santo? Porque mi aṉgøvø'nay vene nasis cyoyoja. ");
INSERT INTO zosNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Antes mi ⁿma'aj nas, muspana'n mi nøc yosøyø mi sunbase mi ne'ṉgø. Y cuando mi ⁿma'aju, muspana'ṉ mi yac yosay cyoyoja mi ne'c mi sunbase. ¿Ti'ajcuy mi ṉgui'ps mi ndzoco'yomo va'cø mi angøvø'nay vene cyoyoja? Dios mi sujtzayu, que ji'ndyet pøn. ");
INSERT INTO zosNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Y myanu'cti Ananiasis jetse, quec nasomo y ca'u. Y møja'n na'tzco'ñaj mumu lo que myañajupø'is jujche tujcuse. ");
INSERT INTO zosNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Entonces miñaj soca, cyeteyaj tucuji'ṉ, ñømaṉyaju, maṉ ñipyaje. ");
INSERT INTO zosNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Cøjtumna'ṉ como tu'cay hora, tøcøy Ananiasis yomo. Ji'na'ṉ nø myusu tina'ṉ tujcu. ");
INSERT INTO zosNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro'is ñøjay yomo: ―Tzajmay ndøvø o'ca jetsecøsam mi ⁿma'ajtam nas. Y yomo'is ñøjayu: ―Jø'ø, je'ñche'ṉomgøsamtzø ma'andyam nas. ");
INSERT INTO zosNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro'is ñøjayu: ―¿Ti'ajcuy mi ñdyu'mbajcajtamu va'cø mi ndzøjquistam ndø Comi's 'Yespiritu? Opø'is ñipyaj mi ⁿjaya nøm tyome'isyaj aṉdyuṉ, y maṉba mi ñømaṉyajque'te. ");
INSERT INTO zosNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jicsye'cti quejque'tuti yomo Pedro'is cyosocø'mda'm y ca'que'tuti. Tøjcøyaj soca y pya'tyaj ca'upø y ñøputyajque'tu maṉ nipyajque'te tu'mbac jyayaji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Y mumu vya'ṉjamyajpapø'is Jesús møja'ṉ na'chaju y mumu myañajupø'is jujche oy tuqui na'chajque'tu. ");
INSERT INTO zosNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Diosis chi'yaj apostoles musocuy va'cø chøcyaj vøti milagro'ajcuy y ji'ndø isyajepø tiyø sone pø'nomo. Y mumu tu'myaju Salomo'nis cyoredojromo tumbø qui'psocuji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pero ni jutipø eyapø pø'nis ja ñø'itøna'ṉ pyaqui choco'yajcuy va'cø tyu'myaj jetji'ṉ. Pero cumgupyø'nis myøja'ṉomgotzøcyajpana'ṉ apostoles. ");
INSERT INTO zosNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Más vøti'ajyajpana'ṉ vya'njamyajpapø'is ndø Comi; vøti tøjcøyajpana'ṉ ndø Comicø'mø, tanto pøn, tanto yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Y cyotyajpana'ṉ ca'eta'mbø calle'omda'm øṉgucyøsi y patacøsi maṉbamø cøt Pedro, va'cø cyøcøjtay ca'eta'mbø aunque sea Pedro'is cyømø'ṉis. ");
INSERT INTO zosNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Y tzu'ṉyajque'tu vøti pøn eyata'mbø cumgu'yomda'm tome isyajpapø'is Jerusalén gumguy, y nu'cyaj Jerusalén gumgu'yomo. Ṉømiñajpana'ṉ ca'eta'mbø y yatzipø espiritu'is yacsutzøcyajupø; y cøyin dzocyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Entonces møja'aṉ pane covi'najø y mumu lo que jetji'ṉna'ṉ ityajupø vøti qui'syca'yaju. Yø'ṉista'm saduceo'is va'ṉjajmocuy ñø'ityajuna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Por eso ñucyaj apostolesta'm y syomyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ndø Comi'is yangelesis oy 'yaṉvajcay tzu'i preso aṉdyun y ñøputyaj apostoles y ñøjayaju: ");
INSERT INTO zosNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Maṉdamø, y te'ndzø'tyam masandøjcomo y tzajmayaj mumu pøn yøn aṉma'yocuy tø yaj quendambapø'is. ");
INSERT INTO zosNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Myañaju'cam jetse, tøjcøyaju y aṉma'yoyaju. Emøc tu'myaj pane covi'najø y mumu jetji'ṉna'ṉ ityajupø. Ñøvejyaj aṉgui'myajpapø y mumu Israel tzambønda'm va'cø tu'myajø. Entonces cyø'vejyaj policía va'cø maṉ mye'chaj apostoles preso'omo. ");
INSERT INTO zosNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero nu'cyaj policía y ja pya'tyaj jeni. Vitu'yaju maṉ chamyaje que ja ityaja'am jeni preso'omo. ");
INSERT INTO zosNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ñøjayaju: ―Mba'jtam øjtzi mø'chøqui aṉga'mupø preso y cyoqueñajpapø'is jendi te'ñaj aṉdyuṉgø'mø. Pero cuando aṉva'cta'møjtzi, ni iyø ja mbya'jtam jojmo. ");
INSERT INTO zosNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Myañaj yøcsepø ote møja'aṉ pane covi'najø'is y masandøjcomo aṉgui'mbapø'is y pane covi'najø'sta'm; y maya'yaju; ji'na'ṉ myusyaje ti más maṉba tuqui. ");
INSERT INTO zosNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Entonces oy nu'c tum pøn oyu'is cyotzame y ñøjayaju: ―Pøn oyupø mi ṉgojtam preso'omo, masandøjcomo ityaju y nø 'yaṉma'yoyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Entonces maṉyaj aṉgui'mba y policía y maṉ mye'chaj apostoles. Ja ñømiñaj obligado, porque na'chaj aṉgui'mbata'm que maṉbana'ṉ pyu'ṉyaj tza'pit vøti pø'nistam. ");
INSERT INTO zosNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ñønu'cyaj apostoles, y presentatzøcyaj tu'myajupø aṉgui'mbapø'is vyi'naṉdøjqui. Y møja'aṉombø pane covi'najø'is cyø'ocva'cyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Nøjayaju: ―O'yø mi aṉgui'mdam vøti va'cø mi jana aṉma'yotyam jic pø'nis 'yaṉma'yocucyøsi, y nø mi aṉma'yoñdyamu hasta que mumu Jerusalén gumgu'yomda'mbø'is nø myañaju. Y sunba mi ndø cojacøtzøjcatyamø o'ca øtz yaj ca'tam Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Entonces 'yandzoṉyaj Pedro'is y eyata'mbø apostolesis, ñøjayaju: ―Más sunba va'cø ndø cøma'nøtyam Dios vi'na que ji'n pønda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mismo Dios lo que ndø jandatzu'ṉgu'ista'm oyupø vya'ṉjamyaje, je'is yac visa' Jesús cuando mitz oyu'cam mi ma'mga'tam cucyøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Y mismo yøṉ Jesús Diosis yac møja'ṉo'maju ñe'c chø'na'nomo va'cø møja'ṉ aṉgui'mø, y va'cø yaj cotzojcoya; va'cø chi' qui'psocuy Israel pønda'm va'cø mus qui'psvitu'yajø; va'cø yac tzu'ṉayaj cyoja Diosis. ");
INSERT INTO zosNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jetseta'mbø tiyø øtz ndzamda'mbøjtzi, y Masanbø Espiritu Santo jetseti chamgue'tpa. Y yøṉ Espiritu Santo chi'pa Diosis cyøma'nøjapyapø'is 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Aṉqui'myajpapø'is myañaju jetsepø ote nø chamupø Pedro'is, y vøti qui'syca'yaju. Sunbana'ṉ yaj ca'yaj apostoles. ");
INSERT INTO zosNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero tum pøn te'nchu'ṉ angui'myajpapø'omo, ñøyipø'is Gamaliel, fariseo va'ṉjajmocuy ñø'ijtupø'is. Jet 'yaṉma'yopyana'ṉ Moisesis 'yaṉgui'mgucyøsi y cumgupyø'nis vyøcotzøcjajpana'ṉ. Je'is 'yangui'myaj policía va'cø ñømaṉyaj apostoles a'ṉgomo usyaṉ hora. ");
INSERT INTO zosNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Entonces ñøjmay Gamaliejlis aṉgui'mbata'm: ―Mi Israel pønda'm, tzøctam cuenda mijtzi ti ma mi ndzøjcatyam yøṉ pønda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Porque vi'na ijtuna'ṉ pøn ñøyina'ṉ Teudas, y nøm ñe'cø que møjapønete. Tu'myaj jetji'ṉ como cuatrocientos pønsye'ṉomo. Pero yaj ca'tøj Teudas y mumu lo que opø'is pya'tyaje maṉyaj emøc yø'qui jeni; ni ti jay chøcyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Y más jøsi'jcam ijtuna'ṉ tum pøn ñøyipø'is Judas, Galilea nasomo tzu'ṉupø, cuando oy japøjcoñømi. Vøti pø'nis o pya'tyaje. Pero ca'que'tuti jicø, y mumu lo que opø'sti pya'tyaje maṉbø'yaju yø'qui jeni. ");
INSERT INTO zosNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Y yøti mi ndzajmatyamba øjtzi va'cø ni ti jana mi ndzøjcatyam yøṉ pønda'm. Tzactamø va'cø myaṉyajø. Porque o'ca yøṉø aṉma'yocuy y yoscuy pø'nis señe, maṉba cøyaje. ");
INSERT INTO zosNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Y o'ca Diosis señe, ji'n mus mi ⁿyaj cøyajtamø u'tyem Dios mi nøṉguiptamu. ");
INSERT INTO zosNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Y vyø'møyajuti'am jetji'ṉ y ñøvejyaj apostoles, y yac nacstochøcyajtøju y 'yaṉgui'myaju va'cø jyana tzajmayaj ni iyø Jesusis 'yaṉma'yocuy. Y jetse chøcøpø'yaj apostoles. ");
INSERT INTO zosNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jejta'm casøyaju porque Diosis myusu que vøjta'mbø pønete y por eso Diosis syunu va'cø ñøcøtyaj toya Jesuscøtoya. ");
INSERT INTO zosNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pero mumu jama masandøjcomo y tyøcnamaye ji'na'ṉ nitu'yaje va'cø 'yaṉma'yoyajø y va'cø cyotzamyaj Jesucristo. ");
INSERT INTO zosNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jic jama cuando masna'ṉ nø vyøti'ajyaj vya'ṉjamyajpapø'is Jesús, tyuptupneyaj griego ote'om oñajpapø, nømyaju que ji'ndyet vøjpø nø chøcyaj hebreo ote'om oñajpapø'is. Ñømyaju que cuando syajyajpana'ṉ cu'tcuy tumdum jama, myenos chi'yaj griego ote'om oñajpapø yaṉbac yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Entonces docepø apostolesis vyejaṉdø'pyaju va'cø tu'myaj mumu vya'ṉjamyajpapø'is Jesús. Nømyaju: ―Ji'n vyøjø va'cø ndza'maṉjejtam øjtzi Diosis 'yote va'cø sajtam cu'tcuy. ");
INSERT INTO zosNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Por eso, ø mi ndøvøta'm, cøpiṉdam cu'yay pøn mijtzomda'm vøcotzøcyajtøjpapø, ityaju'is qui'psocuy, Masanbø Espiritu Santo'is cyøtøjcøyajupø tasyaju'csye'ṉomo. Jet tzi'tam yøṉ yoscuy va'cø syajyaj cu'tcuy. ");
INSERT INTO zosNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mientras øtz maṉba seguitzøctam tum dum jama va'cø o'nøtyam Dios y va'cø ndza'maṉvajcatyam Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Vyø'møyaj vøti pø'nis va'cø chøcyaj jetse, y cyøpiṉyaj Esteban, pøn mø'chøqui va'ṉjajmopapø y Masanbø Espiritu Santo'is cyøtøjcøyupø taspa'csye'ṉomo. Cyøpiṉyajque'tuti Felipe y Prócoro y Nicanor y Timón y Parmenas y Nicolás Antioquía cumgupyøn, oyupø'is pyøjcøchoṉjay Israel pø'nis vya'ṉjajmocuy. ");
INSERT INTO zosNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yøṉda'm yac nu'cyaj apostolesis vyi'nomo y apostolesis cyotyaj cyø' cu'yapø pøngøsi como seña que nø byendisatzøcyaju jic yoscuycøtoya; y 'yo'nøyaj Dios. ");
INSERT INTO zosNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nømna'ṉ chamdøj Diosis 'yote aunque juti, y vøti'ajco'ñaj vya'ṉjamyajpapø'is Jesús Jerusalén gumgu'yomo, y vøtita'mbø Israel pane'is pyøjcøchojṉayaj vya'ṉjajmocuy va'cø cyøna'tzøyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban cyotzoṉ Diosis vøti ñe'c vyø'ajcupit y chi' vøti musocuy. Chøcpana'ṉ møja'ṉomda'mbø milagro'ajcuy y maya'ṉda'mbø tiyø vøti pø'nomo. ");
INSERT INTO zosNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Entonces ityajunaṉ Israel pøn ne'ti tu'myajpapø ñøjmayajpapø tzøcøpø'yajtøjupø; ityajque'tuti Cirene cumgu'yomdambø y Alejandría cumgu'yomdombø, y Asia nasomda'mbø, y Cilicia nasomda'mbø. Yø'ṉis ñøcøtzo'chaju va'cø ñø'onguipyaj Esteban. ");
INSERT INTO zosNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Y ji'na'ṉ 'yongotejyaj Esteban porque Espiritu Santo'is chi' Esteban qui'psocuy va'cø chamø. ");
INSERT INTO zosNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Entonces cyoyojyaj pøn va'cø cyøsujtzøyaj Esteban; va'cø ñømyajø: ―Øtz manda'møjtzi nømna'ṉ cyø'o'nøy Esteba'nis Moisés y Dios. ");
INSERT INTO zosNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jetse Esteba'nis 'yenemigo'is 'yo'nøyaj vøti pøn y tzambønda'm y aṉma'yoyajpapø aṉgui'mgupit va'cø qui'sayaj Esteban. Cyønu'cyaj Esteban y ñucyaju y ñømaṉyaj tu'myajpamø aṉgui'mbata'm. ");
INSERT INTO zosNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Cyotyaj suchajpapø testigos va'cø cy'øsujtzøyaj Esteban. Nømyaju: ―Yøṉ pøn ji'n nitu'yi va'cø cyø'o'nøy yøṉ masandøc y Moisesis 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Porque manda'møjtzi nø ñømupø que yøṉ Nazaret cumgupyøn Jesusis maṉba yaj yøṉ masandøc y manba cyacpø'yaj costumbre opø tø tzi'tam Moisesis. ");
INSERT INTO zosNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Entonces mumu po'cstu'myajupø'is 'ya'maṉga'yaj Esteban y isyaj vyinaca que jujche quenbase angelesis vyi'naca, jetseti quenque'tu Esteba'nis vyinaca. ");
INSERT INTO zosNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Myøja'ṉombø panecovi'najø'is ñøjay Esteban: ―¿Será viyuṉete jujche mi ṉgyøtza'møyajuse? ");
INSERT INTO zosNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban nømu: ―Ø mi ndøvøta'm y ø mi ṉgumguy jatata'm: cøma'nøtyam ndøvø. Myøja'ṉombø Diosis o yac is vyin ndø janda tzuṉguy Abraham cuando ijtu'øctøcna'ṉ Mesopotamia nasomo antes que va'cø myaṉ Harán gumgu'yomo va'cø maṉ itø. ");
INSERT INTO zosNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Diosis ñøjay Abraham: “Tzu'ṉ mi ṉgumgu'yomo y tzacyaj mi ndøvøta'm y maṉ eyaco cumgu'yomo mapøchøṉ mi isindzi'i”. ");
INSERT INTO zosNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Entonces Abraham tzu'ṉ Caldea nasomo y itcupya't Harán gumgu'yomo. Ca'u'jcam jyata, Diosis yac tzu'ṉ Abraham itcu'yomo, yac min yøqui yøn lugajromo mi ijtamumø yøti. ");
INSERT INTO zosNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero mismo jama ja chi'øtøc erejencha yøn lugajromo ni jujche, pero ñøjay Abraham Diosis que maṉbatøc chi' mismo lugar como erejencha y chacyajupø 'yunecøtoyata'm. Pero ja itøtø'cña'ṉ Abraha'mis 'yune. ");
INSERT INTO zosNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Y yøcse nømgue't Dios: “Abraha'mis chacyajupø 'yune vitise maṉba ityaj eyaco nasomo y maṉba cyøyosøyaje eyata'mbø jana coyoja, y maṉba yacsutzøcyajtøji cuatrocientos ame”. ");
INSERT INTO zosNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero nøm Dios: “Øtz ma'ṉbø ṉgastigatzøcyaj pøn yac yosyajpapø'is Abraha'mis chacyajupø 'yune, y jøsi'cam maṉba putyaj jic lugajromo y maṉba cøna'tzøyaj øjtzi yøṉ itcu'yomo”. ");
INSERT INTO zosNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Diosis chøc contrato Abrahamji'ṉ, y chijmay Abraham va'cø syeña'øyaj 'yune como seña que vyø'møjay contrato. Por eso cuando oy Abraha'mis 'yune Isaac, syeña'øyu tucutujtay jamapit. Y oti pø'najque't Isaajquis 'yune Jacob, y Jacojbis 'yune o pø'najyaj doce, y jiquete ndø janda tzu'ṉgutya'm. ");
INSERT INTO zosNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","”Jacojbis 'yune'is qui'sayaj mismo myuquita'm José, y mya'ayaju mismo myuqui; y jet nømaṉdøj Egipto nasomo. Pero Dios jetji'ṉbøte. ");
INSERT INTO zosNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Y Diosis yaj cotzoc José mumu jut toya'isumø y chi' qui'psocuy; y José vøj pujtu Egipto nasom møja'ṉ aṉgui'mbapø Fara'o'nis vyi'nomo. Y je'is cyot José va'co 'yaṉgui'm Egipto nasomo, y mismo ñe'c aṉgui'mba'is tyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","”Y oy yu'ajnøm mumu Egipto y Canaán nasomo, y oy møja'aṉ doya'isyaje, y ndø jandatzu'ṉgu'ista'm ja pya'tyaj ni jut cu'tcuy. ");
INSERT INTO zosNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Entonces myan Jacojbis que ijtuna'ṉ cu'tcuy Egipto nasomo, y por eso cyø'vejyaj 'yune Egipto nasomo va'cø mye'chaj cu'tcuy; je Jacojbis 'yune ndø janda tzu'ṉgutya'mete. Y jetse vinbø maṉyaj, Egipto nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Y cuando myena'como maṉyaju, Jose'is chajmayaj 'yatzi que iyete; y aṉgui'mbapø Fara'o'nis cyomusyajque't Jose'is tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Cyø'vejay ote Jose'is va'cø ñu'cyaj jyata Jacob y mumu fyamiliaji'ṉducu. Ityajuna'ṉ setenta y cinco personas. ");
INSERT INTO zosNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jetse maṉ Jacob Egipto nasomo y jiṉ ca'u y jiṉ ca'yajque'tuti ndø jandatzu'ṉgutya'm. ");
INSERT INTO zosNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Y ca'upø ñømaṉyajtøju Siquem gumgu'yomo. Jiṉ nipyajtøju jut jyuyumø Abraha'mis nas Hamojris 'yunecøsta'm Siquem cumgu'yomo; jujche tzajmatyøju, jetse cyoyoju. ");
INSERT INTO zosNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","”Cuando nømna'ṉ tyome'aj tiempo cuando Diosis manba chøqui jujche chajmayuse Abraham, entonces Israel pønda'm vøti'ajyaju Egipto nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Al fin tøjcøy eyapø aṉgui'mbapø Egipto nasomo. Jic aṉgui'mbapø'is ji'na'ṉ myus iyete José. ");
INSERT INTO zosNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Je'is 'yaṉgøma'cøyaju y yacsutzøcyaju ndø janda tzu'ṉguy jutipøcøs tø tzu'ṉdamupø. 'Yaṉgui'myaju va'cø pyatzpø'u tzacyaj jayata'mbø ya'une va'cø yaj ca'yajø. ");
INSERT INTO zosNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mismo jic tiempø pø'naj Moisés, y Moisés tum une Diosis syunbapø. Tu'cay poya jyata'is yac tzocyaj tyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Cuando oyu'cam patzpø'tøji va'cø cya'ø, Fara'o'nis yom'une'is pyiṉu, y yac tzojcu jujche ñe 'yunese. ");
INSERT INTO zosNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Por eso oy aṉmay Moisés mumu Egipto nasombø musocuji'ṉ. Muspana'ṉ cham vøjø y muspana'ṉ chøc møja'ṉomda'mbø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","”Cuando Moisés ta'n cuarenta ame, qui'psminu va'cø tyu'ñaj Israel pøndøvø. ");
INSERT INTO zosNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jen is tum Israel pøndøvø nømna'ṉ yacsutzøc Egipto pø'nis; y Moisesis cyoquip tyøvø y ñacsca'u Egipto pøn va'cø tyu'mbajcajø. ");
INSERT INTO zosNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisesis nømna'ṉ cyomo'yu que tyøvø'is maṉbase cyønøctøyøyaje que Diosis cyø'vej ñe'c Moisés va'cø yaj cotzocyaj Israel pønda'm. Pero Israel pø'nis ja cyønøctøyøyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Y jyo'pit oque'tuti, y is metzcuy Israel pøn nø quipyajupø. Nømna'ṉ syunu va'cø yac vøṉneyajø, ñøjmayaju: “Mi mbyønda'm, mi ndyøvøta'mete mi ne'ṉgomda'mete, ¿ti'ajcuy mi nø nayacsutzøctandøj mi ne'ṉgomda'm?” ");
INSERT INTO zosNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Entonces nø yacsutzøjcu'is tyøvø myatzcajpø' Moisés y ñøjayu: “¿Ti mitz mi aṉgui'mguy va'cø min mi ndø aṉgui'mdamø? ");
INSERT INTO zosNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Mitz maṉbaja mi ndø yaj ca' jujche mi yaj ca'use tø'øc Egipto pøn?” ");
INSERT INTO zosNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Yøcsepø ote myanu'øc, Moisés poyu y maṉ vit Madián nasomo. Jiṉ oy metzcuy 'yune. ");
INSERT INTO zosNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","”Cøjtu'jcam cuarenta ame va'cø it Madián nasomo, angelesis cyejay Moisés ja ijnømømø tome Sinaí cotzøjcøsi. Nømna'ṉ ñemde'n che'pø cucyøs juctyøc y juctyøjcomo cyejay angelesis. ");
INSERT INTO zosNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisesis isu y jyovi a'mu, tome'isu va'cø 'ya'm tina'ṉete y myajnay ndø Comi Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Diosis ñøjayu: “Øjchøṉø Dios nø va'ṉjamyajupø mi jandatzu'ṉguy Abraha'mis y Isaajquis y Jacojbis”. Entonces Moisés søtøjtu y na'tzu va'cø 'ya'mø. ");
INSERT INTO zosNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Y ñøjay ndø Comi'is: “Tzac mi vaṉgasnaca mi mesupø, porque mi nø ñdye'numø cømasa'nøyu nasete. ");
INSERT INTO zosNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Viyuṉsye ⁿisøjtzi jujche nø toya'isyaj ø unenda'm Egipto nasomo. Ma'nøjtzi nø vyo'comø'ñajupø y mø'nøjtzi va'cø yaj cotzocyajø. Y yøti øtz ma'ṉbø mi ṉgø'vej Egipto nasomo”. ");
INSERT INTO zosNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","”Yøṉ Moisés ja syuñaj tyøvø'sta'm, ñøjayaju: “¿Ti mitz mi aṉgui'mguy va'cø min mi ndø aṉgui'mdamø?” Pero yøṉ Moisés cyø'vej Diosis va'cø min cyovi'najø'ajø, y va'cø min yaj cotzocyaj tyøvøta'm. Cyø'vejque't angeles oyupø'is cyejay che'pø cu'yomo va'cø cyotzoṉ Moisés. ");
INSERT INTO zosNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Por eso Moisesis ñøputyaj Egipto nasomo Israel pønda'm; y chøc milagro'ajcuy y ji'n ndø isyajepø tiyø jiṉø, y Tzapas Majromo, y tøtzø nasomo cuarenta ame. ");
INSERT INTO zosNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yøṉete Moisés ñøjmayajupø'is Israel pønda'm: “Ndø Comi Diosis maṉba cyøpiṉ tum pøn mi ndøvø'omda'm va'cø cha'maṉvajcoya como øtz ndza'maṉvajcopase. Cøma'nøtyam maṉbase mi ñchajmatyam ji'quis”. ");
INSERT INTO zosNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yøṉ Moisés ijtuna'ṉ tu'myajumø tøtzø nasomo. Yøṉ Moisés ijtuna'ṉ angelesji'ṉ cuando 'yo'nøy angelesis Sinaí cotzøjcøsi, y jiṉdina'ṉ itque't ndø janda tzu'ṉguji'ṉda'm. Je'is pyøjcøchoṉ ote tø tzi'papø'is quenguy va'cø tø tzamgøjtacye'ta. ");
INSERT INTO zosNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","”Jetse ndø janda tzu'ṉgu'ista'm ja syun cøna'tzøyaj Moisés, sino myatzcajpø'yaju, y nømna'ṉ qui'psyaj choco'yomo va'cø vitu'yaj Egipto nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ñøjayaj Aarón: “Tø tzøjcatyam ndøvø comi chøquita'm va'cø tø vi'najatyamø. Porque yøṉ Moisés oyupø'is tø nøpujtam Egipto nasomo, ni ji'n ndø mustam jut maṉu”. ");
INSERT INTO zosNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Y jic jamati chøcyaj tum vacas une tzøqui y yaj ca'yaj pø'nøcuy va'cø cyøna'tzøyaj vacas une chøqui. Y cyøcasøyaj lo que chøcyajupø ñe'c cyø'ji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Por eso Diosis chacyaju, chi'ocuyaju va'cø cyøna'tzøyaj tzapcøspø matza, como jyachø'yuse tza'maṉvajcopapø'is. Je'is chamu que Dios nømu: Mi Israel mbyønda'm, cuando mi yaj ca'tam pø'nøcuy mi ṉgøna'tzø'ocu'ista'm cuenta, mientras cuarenta ame mi ijta'mu'øc tøtzønasomo; ¿será que øtz mi ndø cøna'tzøtyamu? ");
INSERT INTO zosNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pero ji'ndyet øjtzi mi ndø cøna'tzøtyame, sino mi nømaṉdamu mi ṉgomi chøqui Moloc nacapø myasandøcji'n. Y mi ṉgomi chøqui Renfa'nis myatza mi nømajṉatyaṉgue'tuti. Jetsepø comi chøqui mi ndzøctamu va'cø mi ṉgøna'tzøtyamø. Por eso øtz ma'ṉbø mi nømaṉdam ya'i Babilonia cumgucyøtu'møṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","”Tøtzønasomo ndø janda tzu'ngu'is ñø'ityajuna'ṉ nacapø masandøc y ijtuna'ṉ Diosis 'yaṉgui'mguy jachø'yupø. Chøcyaj jetsepø oyuse 'yaṉgui'myaj Diosis cuando ñøjay Moisés: “Tzøc nacapø masandøc jujche øtz mi isindzi'use”. ");
INSERT INTO zosNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Y jøsita'mbø ndø janda tzu'ṉgu'is pyøjcøchoṉyajque't mismo masandøc y ñømiñaj yøṉ nasomo Josueji'ṉ. Y eyapø pønda'm lo que ityajuna'ṉ yø'qui, Diosis myacputyaju va'cø mus pyøcyaj nas ndø janda tzu'ṉgu'ista'm; y hasta que ijtu'csye'ṉomo David, jena'ṉ it masandøc. ");
INSERT INTO zosNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David vøj tzø'y Diosis vyi'nomo y vya'c permiso va'cø chøjcay Diosis tyøc; mismo Dios lo que vya'njajmupø Jacojbis más ya'møc, je'is tyøc va'cø chøjcayø. ");
INSERT INTO zosNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero Salomo'nis chøjcay Diosis tyøc. ");
INSERT INTO zosNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Aunque pø'nis chøcyajupø cyø'ji'n tøc ji'n ñøc'ijtøy Møjipø'is; como tza'maṉvajcopyapø jujche chamuse que ndø Comi nømu: ");
INSERT INTO zosNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Øtz aṉgui'mba tzajpomo, y aṉgui'mgue'tpøjtzi mumu nasvindumø. ¿Jujchepø tøc maṉba mi ndø tzøjcatyame? ¿o jutipø lugajromo ma'ṉbø sapøqui? ");
INSERT INTO zosNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Será que ji'ndyet øtz ndzøjcupø mumu yøcseta'mbø tiyø? ");
INSERT INTO zosNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Entonces mismo Esteba'nis syeguitzøjcu va'cø ñøjayajø: ―Mitz yatzipø ṉgui'psocuy mi nø'ijtamu. Ji'n sun mi ṉgømanøtyam vøjpø tiyø. Como ji'n vya'ṉjajmoyajepø pønse, jetse mi ndzøctamba. Jetse mi ṉgui'satyamba Masanbø Espiritu Santo mumu jama. Jujche chøcyajuse mi janda tzu'ṉgu'is, jetse mi ndzøctaṉgue'tpa. ");
INSERT INTO zosNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mumu tza'maṉvajcoyajpapø mi janda tzu'ṉgu'is qui'sayaju y yacsutzøcyaju; y yaj ca'yaj pøn opø'is cha'maṉvacyaje que maṉba min más vøjpø pøn. Y yøti mitz ndzi'ocuyajtam aṉgui'mbacøsi y mi yaj ca'tam mismo je vøjpø pøn cuando minu. ");
INSERT INTO zosNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Diosis cyø'vejyaj anjeles va'cø mi ñchi'tam aṉgui'mguy, pero ja mi yaj copujtamø que jujche mi 'yaṉgui'mdamuse. ");
INSERT INTO zosNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Myañaju'c yøcsepø ote, yac toyaju, qui'syca'comø'ñaju; cyø'syaj tyøtz corajepit, qui'sayaj Esteban. ");
INSERT INTO zosNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero Masanbø Espiritu Santo'is cyøtøjcøy Esteban tasu'csye'ṉomo. Y Esteban quenqui'm møji y isay Diosis myøja'ṉo'majcuy y is Jesús te'nupø Diosis chø'na'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Y nøm Esteban: ―Jic nø'mø is aṉvajcupø tzap, y mumu Pø'nis Tyøvø Jesús te'nupø Diosis chø'na'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Entonces pømi vejaṉgøtyaj vøti pøn, y aṉga'myaj cyoji, y poñu'cyaj Estebangø'mø tumbø qui'psocuji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ñømaṉyaj Esteban cumguy acapoya, y jin pyu'ṉyaj tza'ji'ṉ. Testigo'ista'm maṉba'is pyu'ṉyaje, cyø'aṉgui'møy tzacyaj tyucu tum uñbøngøsi ñøyipø'is Saulo. ");
INSERT INTO zosNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Y nømdina'ṉ pyu'ṉyaj Esteban tza'ji'ṉ. Esteba'nis 'yo'nøy ndø Comi y ñøjayu: ―Øjchø mi Ṉgomi Jesús, tø pøjcøchoṉjay ø ⁿespiritu. ");
INSERT INTO zosNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Entonces cutcøne'cu y pømi veju ñøjayu: ―Ø mi Ṉgomi, uy mi yaj coja'ajyaju o'ca ti nø tzøjca'yajø. Cuando nøm jetse, entonces ca'u. ");
INSERT INTO zosNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Y Saulo'is jetseti syungue'tu va'cø yaj ca'yaj Esteban. Jic tiempo vøti yacsutzøcyajtøj vya'ṉjamyajupø'is Jesús ityajupø Jerusalén gumgu'yomo. Y mumu oy ve'nbø'pø'neyaje, yømøc teymøc maṉyaju Judea nasomo y Samaria nasomo. Apostolestim tzø'yaj Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tumø tzocoy cyøna'tzøyajpapø'is Dios ñømaṉyaj Esteban va'cø maṉ ñipyaje y vøti cyøvo'yaju cyøvejyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo'is yacsutzøcyajpana'ṉ vya'ṉjamyajpapø'is Jesús, tøcmaye tøjcøyajpana'ṉ ñøputyajpana'ṉ jut pya'tyaju; myocsupø ñømaṉyajpana'ṉ pøn y yomo va'cø syomyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pero ve'nbø'pøneyajupø maṉyaj cumguñamaye maṉ cha'maṉgejyaj vøjpø ote. ");
INSERT INTO zosNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe mø'n Samaria cumgu'yomo y nømna'ṉ cha'maṉvajcayu que Jesús Cristote Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Y tumchocoy cyøma'nøyajpana'ṉ vøti pø'nis tina'ṉ chamba Felipe'is, porque myañaju y isyaju milagro'ajcuy nø chøjcupø. ");
INSERT INTO zosNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Porque ijtuna'ṉ vøti ityaju'is yatzi'ajcuy choco'yomo, y Felipe'is ñøpujtayajpana'ṉ yatzi'ajcuy choco'yomo. Yatzi'ajcuy vejpa putyajpana'ṉ. Y tzocyaj vøti ja ityajø'is pyømi va'cø vityajø, y cømø'ṉgaṉyajpapø. ");
INSERT INTO zosNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Y casøcomø'ñaj vøti jic cumgupyøn. ");
INSERT INTO zosNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Itque'tutina'ṉ tum pøn ñøyipø'is Simón. Más vi'na myus majiquero'ajcuy y 'yangøma'cøyaj Samaria cumgu'yomda'mbø. Ñe'c más myøja'ṉdzambana'ṉ vyin. ");
INSERT INTO zosNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Y mumu cyøma'nøyajpana'ṉ aunque sea che'ta'mbø'is, y møjata'mbø'is; sea ja itø'is aṉgui'mguy, sea møja'aṉ aṉgui'mba'is; nømyajpana'ṉ: ―Yøn pøn yospa Diosis myøja'nombø pyømiji'n. ");
INSERT INTO zosNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Vøti pø'nis chøjcayajpana'n cuenda jic Simón porque ya'i jama 'yaṉgøma'cøyaju brujo'ajcupit. ");
INSERT INTO zosNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Entonces Felipe'is nømna'ṉ chamboy vøjpø ote jujche Diosis 'yangui'mguy, y chamboyu va'cø ndø va'ṉjam Jesucristo. Y vøti pø'nis vya'njamyaju y nø'yøyaju; tanto pønis, tanto yomo'is. ");
INSERT INTO zosNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Y ñe' Simonis vya'ṉjamgue'tuti, y nø'yøcye'tuti y o pya't Felipe. Simo'nis isu ji'n ndø isipø tiyø y myøja'ṉ milagro'ajcuy nø chøjcupø Felipe'is, y joviseti isu y ñømaya'u. ");
INSERT INTO zosNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Entonces Jerusalén gumgu'yom ityajupø apostolesis myañaju que Samaria cumgu'yomda'mbø'is pyøjcøchoṉjayaj Diosis 'yote, y apostolesis cyø'vejyaj Pedro y Juan va'cø myaṉyaj Samaria cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cuando nu'cyaju, Pedro'is y Jua'nis o'nøyajpana'ṉ Dios para jic cumgupyøngøtoyata'm va'cø pyøjcøchoṉyaj Masanbø Espiritu Santo. ");
INSERT INTO zosNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porque ni icøsna'ṉ ja otøc mø'ni Masanbø Espiritu, na más que oyumna'n nø'yøyaje ndø Comi Jesusis ñøyicøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Entonces Pedro'is y Jua'nis cyotyaj cyø' jetcøsta'm, y pyøjcøchoṉyaj Masanb'ø Espiritu Santo. ");
INSERT INTO zosNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Y is Simo'nis nø cyojtupø cyø' eyata'mbøcøsi apostolesis y pyøjcøchonyaj Masanbø Espiritu Santo, y Simo'nis vyinbø'jayaj tumin. ");
INSERT INTO zosNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ñøjmayaju: ―Tø tzi'que'tati øjtzi yøṉ musocuy, o'ca aunque icøsi ngotpa ø ngø', pyøjcøchoṉba Masanbø Espiritu Santo. ");
INSERT INTO zosNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Entonces Pedro'is ñøjmay Simón: ―Mi nduminji'ṉ maṉba mi ñdyocoye, porque ṉgomo'pya mijtzi que tumingøsi ndø jumbya Diosis tø va'ctzi'papø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ji'n mus mi ⁿyosay yøcsepø yoscuy, ja it mi ṉguenda yøcsepø yoscuyomo, porque mi ndzocoy ji'ndyet vyøjpø Diosis vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Por eso qui'psvitu'ø va'cø mi ndzac yøcsepø yatzitzoco'yajcuy, o'nøy Dios o'ca jovisyeti sunba mi ⁿyaj cotocojaye yatzipø mi ṉgui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porque ndzi'pa cuenta que yatzi'ajcu'is mi ñøtzøcpa, y como tacapyø tiyø ji'n ndø suni, jetse Diosis ji'n mi syujnay mi ṉgui'psocuy. ");
INSERT INTO zosNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Entonces 'yaṉdzoṉ Simo'nis ñøjayu: ―Va'cay mitz ndø Comicøsi øtzcøtoya va'cø jana tuc øjtzi lo que mi ndzamuse. ");
INSERT INTO zosNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Y Pedro'is y Jua'nis chamyaju que ndø Comi'is 'yote viyuṉete y jet chambucsyaju. Entonces vitu'yaj Jerusalén gumgu'yomo. Y Samaria nasomo cumguñamaye nømna'ṉ chamboyaj vøjpø ote mientras cøtyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ndø Comi'is 'yangelesis 'yo'nøy Felipe ñøjayu: ―Tzu'ṉø y mavø tu'ṉomo surcøsi. Pøc jic tuṉ Jerusale'nomo tzu'ṉupø y maṉupø Gaza cumbu'yomo. Jic tuṉ cøjtu ja ijnømømø. ");
INSERT INTO zosNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Entonces Felipe tzu'ṉu y maṉu. Ijtuna'ṉ tum Etiopía nasombø eunuco, gobierno'is pyøn aṉgui'mbapø pønete, tesorerona'ṉete, cuando tum yomo ñøyipø'is Candace møja'ṉ aṉgui'mbana'ṉ Etiopía nasomo. Oy Jerusalén gumgu'yomo va'cø cyøna'tzø'yoya. ");
INSERT INTO zosNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nømna'ṉ vitu' pocsupø cyarreta'omo y nømna'ṉ tyu'nay tza'maṉvajcopapø Isaiasis libro. ");
INSERT INTO zosNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Y Masanbø Espiritu Santo'is ñøjay Felipe: ―Mavø jic carretacø'mø. ");
INSERT INTO zosNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Entonces popya maṉ Felipe y cyønu'c tome carreta. Carreta'ombø pø'nis nømna'ṉ tyu'n tza'maṉvajcopapø Isaiasis libro, y Felipe'is ñøjmayu: ―¿Nømdija mi ṉgyønøctøyøyu nø mi ndu'nupø? ");
INSERT INTO zosNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Y ñøjayu: ―¿Jujche pues ma'ṉbø ṉgønøctøyøyi o'ca ni i'is ji'nø tza'maṉvajcaye? Entonces po'nis ñøjay Felipe: ―Qui'm yø'c va'cø tø po'csa. ");
INSERT INTO zosNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nømna'ṉ tyu'numø Diosis 'yote jachø'yupø nømbamø: Jujche borrego ñømaṉyajpase va'cø yaj ca'yajø, jetse ñømaṉyajque't tum pøn. Y como borrego ji'n vyeje cuando jyu'syajpa'c, jetse pø'nis ni ti ja chamø. ");
INSERT INTO zosNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Porque probrepø pønete, ja chøcayaj justicia. Y ni i'is ji'n mus chajmay 'yune porque ja itø, porque yaj ca'yaju va'cø jana it nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Y gobierno'is pyø'nis ñøjay Felipe: ―Øjtzø mi va'ṉgapya va'cø mi ndø tzajmay jutipø pøn nø cham libro'omo tza'maṉvajcopapø'is. ¿Será que mismo vyin nø chamu que jetse maṉba tuqui, o eyapø nø chamu que jetse manba tuqui? ");
INSERT INTO zosNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Entonces Felipe'is cha'maṉvactzo'tz totojaye nø tyu'nupø que Jesuse nø chamu jujche o tuqui, y jetse Felipe'is cha'maṉvajca'ṉøyu jujche Jesusis tø yaj cotzocpa ");
INSERT INTO zosNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Y nømna'ṉ myaṉyaj tu'ṉomo y nu'cyaj ijtumø nø', y gobierno'is pyø'nis ñøjayu: ―Jicø it nø', ¿ti'ajcuy ji'n mi ndø nø'yøy yø'qui? ");
INSERT INTO zosNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe'is ñøjayu: ―O'ca mi va'ṉjajmba mi ndumø tzocoy, muspa mi nø'yøyø. Y 'yaṉdzoṉu ñøjayu: ―Va'ṉjajmbøjtzi que Jesucristo Diosise 'yune. ");
INSERT INTO zosNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Entonces pø'nis yac te'ndzø'y carreta y mø'ñaj myechcø'i nø'omo, Felipe y gobierno'is pyøn; y Felipe'is ñø'yøy pøn. ");
INSERT INTO zosNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Y qui'myajujcam nø'omo, ndø Comi'is 'Yespiritu Santo'is ñuc Felipe y ñømaṉu; y gobierno'is pyø'nis ja isø'am jut maṉu. Pero je gobierno'is pyø'nis syeguitzøc tu'ṉajcuy, casøpya maṉu. ");
INSERT INTO zosNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pero Felipe istøju Azoto cumgu'yomo. Nømna'ṉ cyøjtu y cha'mingøt vøjpø ote mumupø cumgu'yomo hasta que nu'c Cesarea cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo nømdøcna'ṉ jyayatzamu va'cø chøcna'chaj vya'ṉjajmyajpapø'is ndø Comi. Nømu que maṉba yaj ca'yaje. Por eso nu'c pane covi'najøcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Y vya'cay pane va'cø chøjcay carta Damasco cumgu'yom aṉgui'myajpapø Israel pøn tu'myajpamø. Saulo'is syunu va'cø chi'tøj permiso va'cø mus ñucyaj Jesusis vya'ṉjajmocuy ñø'ityajupø'is o'ca i pya'tpa, que sea pøn, que sea yomo; y va'cø ñønu'cyaj mo'csupø Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Jetse Saulo nømna'ṉ myaṉ tu'ṉomo, nømna'ṉ ñu'cto' tome Damasco cumgu'yomo cuando joviti sø'ṉguec tzajpombø sø'ṉgø, y Saulo sø'ngø cucmø tzø'yu. ");
INSERT INTO zosNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Y Saulo quec nasomo y myan ote ñøjayupø: ―Saulo, Saulo, ¿ti'ajcuy mi ndø macpa y mi ndø yacsutzøcpa? ");
INSERT INTO zosNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Y Saulo'is ñøjayu: ―Señor, ¿ⁿiyø mijtzi? Y ñe'c ñøjay Saulo: ―Øjchøṉ Jesús, mi ndø mac nøvitpapø. Mismo mi ne'c mi yacsutzøcpa mi ⁿvin como copøn nejpinducpase vi'napø ticøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo na'tzu y søtøjtu y ñøjmayu: ―Øjtzø mi Ṉgomi, ¿ti sunba mijtzi va'cø ø ndzøcø? Ndø Comi'is ñøjayu: ―Te'nchu'ṉø y maṉ cumgu'yomo y jen ma mi ñchajmatyøji lo que ti su'nbøjtzi va'co mi ndzøcø. ");
INSERT INTO zosNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mientras jetse tujcu, pøn nø myaṉyajupø Sauloji'ṉ te'ndzø'yaju, ja mus oñaj na'tzcu'is. Myañajpana'ṉ ote pero ja isyaj ni iyø. ");
INSERT INTO zosNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Te'nchu'ṉ nasomo Saulo. Pero cuando que'naṉvajcu, ni ti ja isø. Por eso jitinømaṉyaj cyø'cøsi ñøtu'ṉis; jetse nu'cyaj Damasco cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Jen tu'cay jama ja oy isoye, y ji'na'ṉ cyu'ti ni ji'na'ṉ 'yuqui ni ji'na'ṉ tyo'ṉ ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco cumgu'yomo ijtuna'ṉ tum pøn nø 'yaṉmayupø'is Diosis 'yote ñøyipø'is Ananías. Oy quejay Ananías ndø Comi'is como ñapasyi'omse y ñøjayu: ―Ananías. Ananiasis 'yaṉdzoṉu ñøjayu: ―Øjtzø mi Ṉgomi, yø'cti ijtøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Y nøjay ndø Comi'is: ―Te'nchu'ṉø, maṉ calle'omo ñøyipø'is Viyuṉ galle, y jen me'tz Judasis tyøcmø tum Tarso cumgupyøn ñøyipø'is Saulo. Porque je Saulo'is nømdi o'nøyu øjtzi. ");
INSERT INTO zosNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Y oy quejay Saulo ñapasyi'omse tum pø'nis ñøyipø'is Ananías. Y napasyi'omse Saulo'is is Ananías nø tyøjcøyupø y nø cyojtupø cyø' ñe Saulo'is vyingøsi va'cø yac tzojcay vyitøm. ");
INSERT INTO zosNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jetse ndø Comi'is chajmay Ananías, pero Ananiasis 'yaṉdzoṉu ñøjayu: ―Øjtzø mi Ṉgomi, na'tzpøjtzi va'cø mavø, porque ma'nøjtzi lo que vøti pø'nis chamyajpapø que jic Saulo'is yacsutzøcyajpa vya'ṉjajmyajpapø'is mijtzi lo que ityajupø Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Y yøti min yø'qui je Saulo, y pane covi'najø'is chi'yaj aṉgui'mguy va'cø cøyin ñucyaj mi ⁿ'yo'nøyajpapø'is ");
INSERT INTO zosNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Entonces ñøjay ndø Comi'is Ananías: ―Mavø, porque jic Saulo øtz ṉgøpiṉupø va'cø yosa øtzcøtoya, va'cø chamgøpucs ø onde mumu pø'nomo, jana saṉ Israel pø'nomdi; y va'cø chajmayajque'tati aṉgui'mba. ");
INSERT INTO zosNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Porque øjti maṉba isindzi' Saulo jujche tiene que va'cø toya'isø maṉba aṉcø chamboy ø onde. ");
INSERT INTO zosNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Entonces Ananías maṉu y tøjcøy tøjcomo y cyot cyø' Saulo'is vyingøsi y ñøjayu: ―Ø mi ndøvø Saulo, ndø Comi Jesusis oyupø'is mi ṉgyejay tu'ṉmo jujna'ṉ nø mi minumø, je'is cø'vej øjtzi va'cø mi yac tzojcay mi vindøm, y va'cø mi ñøndøjcøyø Masanbø Espiritu Santo'is mi ndyasu'csye'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Jicsye'cti quecyaj vyitø'momo jujche quejsiseta'mbø, y sø'ṉ vyitøm, y te'ñchu'ṉu, y maṉ nø'yøtyøji. ");
INSERT INTO zosNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Entonces Saulo cu'tu y pømipøjcu y oy ya'e usyaṉ hora Damasco cumgu'yomo vya'ṉjajmocuy tyøvøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Y entonces Israel pøn tu'myajpamø Saulo'is chambopyana'ṉ Cristo que jiquete Diosis 'Yune. ");
INSERT INTO zosNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mumu myañajupø'is qui'psyaju ti'ajcuy jetse nø chøjcu y nømyaju: ―Parece que jiquete oyupø'is yacsutzøcyaj Jerusalén gumgu'yomo 'yo'nøyajpapø'is Jesús, y jetcøtoya min yø'qui va'cø ñu'cyaj vya'ṉjamyajpapø'is, va'cø ñømaṉyaj mocsupø pane covi'najøcø'mø. ¿Jutznøm yøti mismo Jesús nø chamboyu? ");
INSERT INTO zosNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero Saulo más pømipøjcu y vøjpø qui'psocuji'ṉ chambana'ṉ, y ja mus 'yaṉdzoṉyajø Israel pø'nis Damasco cumgu'yom ityajupø'is. Saulo'is isindzi'yaju myusocuji'ṉ que viyuṉsye Jesús Cristote Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Y cøjtujcam vøti jama, Israel pø'nis tyu'mbajcayaju va'cø yaj ca'yaj Saulo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero Saulo'is myusu lo que jujchena'ṉ nø cyømejcøyaju. Ijtuna'ṉ no'tze cumgu'acapoya entero vocøvitu'is cumguy, y je'tis jyo'cyajpana'ṉ tzu'ji'ṉ jamaji'ṉ ityajumø putcuy va'cø yaj ca'yaj Saulo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Por eso vya'ṉjamyajpapø'is Jesús ñømaṉyaj Saulo tzu'yi no'tzecø'mø, qui'myaj møji, y møjapø vaca'omo yac votzomø'ñaj a'ṉgomo. Jetse yac poyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Y Saulo nu'c Jerusalén gumgu'yomo y nømna'ṉ syunu va'cø cyøtu'myaj vya'ṉjajmyajpapø'is Jesús. Pero mumu nømna'ṉ ña'chaju va'cø tu'myaj Sauloji'n. Ji'na'ṉ vyaṉjamyaje o'ca de veras vya'ṉjamba Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Entonces Bernabe'is pyøc Saulo y ñømaṉ apostolescø'mø y Bernabe'is chajmayaj apostoles jujche Saulo'is oy is ndø Comi tu'ṉomo y ndø Comi'is 'yo'nøy Saulo. Chajmayajque'tu jujche Damasco cumgu'yomo Saulo'is cha'maṉvajcay Jesusis 'yote jana na'tzcuy. ");
INSERT INTO zosNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Entonces Saulo o tzø'y Jerusalén gumgu'yomo, y parejona'ṉ vityajpa jetji'n. ");
INSERT INTO zosNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Y Saulo'is jana na'tzcuy cha'maṉvajcapyana'ṉ ndø Comi's 'yote, y 'yo'nøyajpana'ṉ griego ote'omo oñajpapø Israel pønda'm. Jetji'ṉna'ṉ onguipyajpa. Pero je's chøcme'chajpana'ṉ jujche muspa yaj ca'yaj Saulo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Cuando va'ṉjajmocuy tyøvø'is myusaju que maṉbana'ṉ yaj ca'yaj Saulo, maṉ chacpø'yaje hasta Cesarea cumgu'yomo, y jeni cyø'vejyaj Tarso cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mumu vya'ṉjamyajpapø'is Jesús mumu Judea nasomo y Galilea nasomo y Samaria nasomo vøj ityaju; ni i'samna'ṉ ji'n yacsutzøcyaje, va'ṉjajmoyajpa'm mø'chøqui. Cyøna'tzøyajpana'ṉ ndø Comi, y por eso jujche syunbase ndø Comi'is, jetsena'ṉ chøcyajpa. Y Masanbø Espiritu Santo'is yajayaj myaya'cuy va'cø contento ityajø, y masamna'ṉ nø vyøti'ajyaju vya'ṉjamyajpapø'is Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Y Pedro'is nømna'ṉ 'yocvijtu va'cø tyu'ñaj vya'ṉjajmyajpapø'is Jesús, y jetse o tyu'ñaj va'ṉjajmoyajpapø ityajupø Lida cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Y pya't jiṉ tum pøn ñøyipø'is Eneas que tucutujtay amemna'ṉ ijtupø øṉgu'yomo ca'epø ji'na'ṉ mus vitø. ");
INSERT INTO zosNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Y ñøjay Pedro'is: ―Eneas, Jesucristo'is mi yac tzocpa. Te'nchu'ṉø, piṉ mi nu'scuy. Y te'ndonchu'ṉu jicsye'cti. ");
INSERT INTO zosNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Isyaj pøn yac tzojcupø mumu Lida cumgu'yomda'mbø'is y Sarón gumgu'yomda'mbø'is. Y qui'psvitu'yaj ndø Comicøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Y ijtuna'ṉ Jope cumgu'yomo tum yomo vya'ṉjajmbapø'is Jesús ñøyipø'is Tabita. Griego ote'omo ñøjayajpa Dorcas. Yø'ṉis chøcpana'ṉ vøjpø tiyø, vøti cyotzoṉyajpana'ṉ pobreta'mbø. ");
INSERT INTO zosNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Cuando Pedro ijtu'øc Lida cumgu'yomo, je yomo Tabita ca'cupya'tu y ca'u. Yac tziṉyaju y cyotyaj møjipø cuarto'omo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Como Lida cumgu'is tyome'ispa Jope cumguy, cuando vya'ṉjamyajpapø'is Jesús myusyaju que Pedro jena'ṉ it Lida cumgu'yomo, entonces cyø'vejyaj metzpøn va'cø maṉ mye'chaj Pedro. Je'is ñøjayaj Pedro: ―Yøti yøti tø maṉdya'i Jope cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro tzu'ṉu y maṉ jetji'ṉda'm. Cuando nu'cyaj Jope cumgu'yomo, ñømaṉyaj Pedro møjipø cuarto'omo ijtumø ca'upø. Jen cyønu'cyaj Pedro yaṉbajquista'm, vo'yajpana'n y isindzi'ayajpana'ṉ eya cuentata'mbø tucu Dorcasis ña'cupø cuando jetji'ṉdøcna'n ijtu'øc. ");
INSERT INTO zosNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pero Pedro'is yac putpø'yaju cuarto'om ityajupø. Entonces cutquejcu y 'yo'nøy Dios. Y cyøque'nøy ca'upø y ñøjmayu: ―Tabita, te'nchu'ṉø. Y je ca'upø que'naṉvajcu y is Pedro y po'cschu'ṉu. ");
INSERT INTO zosNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro'is ñuc cyø'cøsi y jyøcøtonde'nu. Ñøvejyaj va'ṉjajmoyajpapø y yaṉbacta'm y yac isyaj yomo visa'upø'am. ");
INSERT INTO zosNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Min myusyaj mumu Jope cumgu'yomda'mbø'is jujche tujcu, y vya'ṉjamyaj vøti pø'nis ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Vøti jama oy tzø'y Pedro Jope cumgu'yomo tum pø'nis tyøjcomo ñøyipø'is Simón, vyøjøtzøcpapø'is naca. ");
INSERT INTO zosNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ijtuna'ṉ tum pøn Cesarea cumgu'yomo ñøyipø'is Cornelio, soldado covi'najøna'ṉete, y pyartido lo que je'is 'yaṉgui'myajpa ñøjayajpana'ṉ Italiano. ");
INSERT INTO zosNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yøṉ Cornelio'is jyajmba vya'ṉjajmocuy y cyøna'tzøpana'ṉ Dios mumu fyamiliaji'ṉducu. Chi'yajpana'ṉ vøti tumin pobreta'mbø pøn y siempre 'yo'nøpyana'n Dios. ");
INSERT INTO zosNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nømna'ṉ ñu'c como las tres de la tarde cuando como napasyi'omse Diosis 'yangelesis 'yac is vyin y Cornelio'is is vøjø. Angeles tøjcøy jetcø'mø y ñøjayu: ―Cornelio. ");
INSERT INTO zosNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio'is 'ya'm angeles y na'tzu, y ñøjayu: ―¿Ti'sque'te, øjtzø mi Ṉgomi? Y ñøjay angelesis: ―Myan Diosis como nø mi ⁿo'nøyuse, y isu'am lo que ti nø mi sajtzi'yaj pobreta'm. ");
INSERT INTO zosNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Y yøti cø'vejyaj pøn Jope cumgu'yomo va'cø maṉ mye'chaj Simón ñøyipø'sque't Pedro. ");
INSERT INTO zosNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yøṉ Pedro tøjcojejpa eyapø pønji'ṉ ñøyipø'sque't Simón, vyøjøtzøcpapø'is naca. Majranvini it tyøc. Pedro'is maṉba mi ñcha'maṉvajcaye jujche vøjø va'cø mi ndzøcø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Entonces tzu'ṉ angeles oyupø'is 'yo'nøy Cornelio y Cornelio'is ñøveju va'cø miñaj metzcuy mozo y tum soldado cøna'tzø'yopyapø Cornelioji'ṉ yospapø mumu jama. ");
INSERT INTO zosNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Cornelio'is chajmayaj mumu jujche oyuse is angeles, y cyø'vejyaj mozo y soldado va'cø myaṉyaj Jope cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Jyo'pit mientras que nømdøc myaṉyaj ñu'cscuy tu'ṉomo y nømna'ṉ ñu'cyaj tome cumgu'yomo, Pedro qui'm møji tøjcøsi cøjø'ṉbø tøjcø copajcomo va'cø ma 'yo'nøy Dios. Nømna'ṉ pyaṉguc jama'ajnømu. ");
INSERT INTO zosNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Osenayu, y nømna'ṉ cyu'to'u. Mientras nømdøcna'ṉ tyuc cu'tcuy, napasyi'omse tujcu. ");
INSERT INTO zosNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Is tzap aṉvajcupø, y nømna'ṉ myø'n como tum cojtocusyepø jujche møjapø sabanasepø macsyaṉguin si'nupø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Je'tomo ijtuna'ṉ yempe jujchepø copøn macsycuy cosota'mbø, y tza'mø copøn, y jyøcøyajpa'is vyin, y sava'om sititvityajpapø paloma. ");
INSERT INTO zosNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Y Pedro'is myan ote ñøjayupø: ―Te'nchu'ṉø, Pedro, yaj ca'ø y vi'cø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pero Pedro'is ñøjayu: ―Ji'nø mus vi'ṉgø, øjtzø mi Ṉgomi, porque ni ja vi'ṉguisøtø'ctzi jetseta'mbø copøn o sea ji'n vyøjta'mbø tiyø lo que ya'inducpa aṉgui'mgu'is. ");
INSERT INTO zosNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Y menajcomo myangue't ote ñøjayupø: ―Lo que Diosis cyotque'tuse aṉgui'mguy va'cø ndø vi'cø, u mi ñømu que ji'ndyet vyøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jetseti o tujque't tu'cañajcøsi; y jicsye'cti vøcoqui'mgue'tu tucusepø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mientras Pedro'is nømna'ṉ qui'ps choco'yomo tina'ṉ oyupø is napasyi'omse, entonces pøn oyupø cyø'vej Cornelio'is nu'cyaj andyuṉgø'mø, nømna'ṉ 'yocva'cayaju Simo'nis tyøc, jute ijtu. ");
INSERT INTO zosNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Vyejyaju, 'yaṉgøva'cyaju o'ca jen jej Simón, tum ñøyipø'sque't Pedro. ");
INSERT INTO zosNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mientras jetse tujcu, Pedro'is nømna'ṉ qui'psu que tiyø isupø napasyi'omse, y ñøjay Pedro Masanbø Espiritu Santo'is: ―Tu'caṉbønbø'is nø mi mye'ndzu. ");
INSERT INTO zosNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tzu'ṉø y mø'nø; u mi ṉgui'psu que ji'n vyøjø va'cø mi myaṉ jetji'ṉda'm, porque øjtze ṉgø'vejyajupø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Entonces Pedro mø'nu y nu'cu ityajumø pøn lo que cyø'vejyajupø Cornelio'is, y ñøjayaju: ―Øjchøṉ nø mi me'tztamupø. ¿Ticøtoya nø mi ndø me'tztamu? ");
INSERT INTO zosNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Je'is ñøjayaju: ―Cornelio'is cø'vejta'møjtzi. Cornelio soldado covi'najøte, vøjpø pønete, cyøna'tzøpyapø'is Dios, vyøcotzøcyajpa mumu Israel pø'nista'm. Masanbø angelesis 'yaṉgui'm Cornelio va'cø mi ñøvejø, va'cø mi myaṉ tyøcmø, y va'cø mi ṉgyøma'nøjay Cornelio'is mi onde mitz mapø mi ndzamsaje. ");
INSERT INTO zosNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Entonces Pedro'is yac tøjcøyaj tyøjcomo y chi'yaj jejcuy. Jyo'pit tzu'ṉyaju, y Pedro maṉyaj jetji'ṉda'm. Y veneta'mbø'is Jope cumgu'yomda'mbø va'ṉjajmocuy tyøvø'is maṉ pya'tyajque'te. ");
INSERT INTO zosNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jyo'pit nu'cyaj Cesarea cumgu'yomo. Y Cornelio'is nømna'ṉ jyo'cyaj jiṉø. Cornelio'is vyejaṉdø'pyajumna'ṉ tyøvøta'm y más syuñajpapø 'yamigota'm, parejo nø jyo'cyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Cuando tøjcøy Pedro, Cornelio'is min pyøjcøchove. Cornelio'is myucsquejcay Pedro'is cyosocø'mø va'cø cyøna'tzøy Pedro. ");
INSERT INTO zosNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero Pedro'is yac te'ñchu'ṉu y ñøjmayu: ―Te'ñchu'ṉø, øtz pøndi chøṉgue't como mijtze. ");
INSERT INTO zosNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Entonces Pedro Cornelioji'ṉ vejvejneyu, y tøjcøyaju, y Pedro'is isu que it vøti pøn tu'myajupø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Y Pedro'is ñøjmayaju: ―Mitz mi mustamba que Israel pø'nis 'yaṉgui'mgu'is ya'inducpa Israel pøn va'cø jyana motyajø eyata'mbø pønji'ṉ lo que ji'ndyet Israel pøn; ni va'cø jyana tøjcøy tyøjcomo. (Y øtz Israel pøn chøṉø, y mitz ji'ndyet jicø. Y por eso ji'na'ṉ mus tøjcøy mi ndøjcomo.) Pero isindzi'ø Diosis que ni jutipø pøn ji'nø mus nømø que ja cyøvajcøyøpøte va'cø jyana mot jetji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jetcøtoya cuando mi ndø nøveju, mi'nøjtzi, ja jye'ṉøjtzi va'cø minø. Jetse nø'ø aṉgøva'cu ticøtoya mi ndø nøveju. ");
INSERT INTO zosNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Y Cornelio'is ñøjay Pedro: ―Cøjtu'came macsycuy jama ijtuna'ṉ øjtzi ø ndøjcomo yøcse hora como las tres de la tarde. Nømna'n ø o'nøy Dios jana uquipø, jana cu'tipø. Y joviseti ⁿisøjtzi tum pøn sø'ṉbapø'is tyucu te'nupø ø ⁿvi'nomo. ");
INSERT INTO zosNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Y nøjma'yøjtzi je'is: “Cornelio, myan Diosis nø mi ⁿo'nøyuse, y Diosis jyajmba ti mi sajtzi'yaj pobre. ");
INSERT INTO zosNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yøti cø'vejyaj pøn Jope cumgu'yomo va'cø maṉ mye'chaj tum ñøyipø'is Simón; y mismo pøn ñøyipø'istique't Pedro. Jic Pedro cojeju eyapø Simo'nis tyøcmø, vyøjøtzøcpapø'is ñaca, tome majranvini. Cuando minba, je'is maṉba mi yo'nøyi”. ");
INSERT INTO zosNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jetcøtoya prontoti mi yac me'tztøjøjtzi, y ndzøjcuti mi vøjø, mi minundi. Pues yøti mumu øjta'm yø'c ijta'møjtzi Diosis vyi'naṉdøjqui va'cø ngøma'nøtyamø mumu lo que Diosis mi nchajmayuse va'cø mi ndø tzajmatyamø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Entonces Pedro ondzo'tzu ñøjmayaju: ―Viyuṉse yøti muspa'mtzi que Diosis parejo syuñajpa mumu pøn. ");
INSERT INTO zosNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Diosis pyøjcøchoṉba mumu cyøna'tzøyajpapø'is y chøcpapø'is vøjpø tiyø, aunque jutpø cumgu'yombø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diosis cyø'vejayaj ote Israel pønda'm chajmayaj vøjpø ote que Jesucristo'is tø yac vø'ajtamba. Jesús mumu i'is y mumu ti'se Cyomi. ");
INSERT INTO zosNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mijta'm mustamba ote lo que tzambotyøjupø mumu Judea nasomo. Tzambotyøju lo que jujche tuctzo'tz Galilea nasomo después que Jua'nis chajmayaj pønda'm va'cø ñø'yøyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tzambotyøju que Nazaret cumgu'yombø Jesús chi' Diosis Masanbø Espiritu Santo y musocuy. Jetse Jesús vitpana'ṉ, y chøcpana'ṉ vøpø tiyø, y yac tzocyajpana'ṉ mumu nø yac toya'isyajupø yatzi'ajcu'is; porque ñe'c Jesús Diosji'ṉbøna'ṉete. ");
INSERT INTO zosNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Y øtz ista'møjtzi mumu lo que chøjcupø Jesusis Judea nasomo y Jerusalén gumgu'yomo. Pero Jesús mya'mga'yaj cucyøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Y yøṉ Jesús Diosis yac visa' tu'cay jamapit, y yaj quejatya'møjtzi. ");
INSERT INTO zosNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Diosis ja yac isyaj Jesús mumu pøn. Na más cøpindamupø'stzi vi'na va'cø istamø, øtz istamøjtzi. Y øtz cu'jta'møjtzi ucta'møjtzi Jesusji'n después que visa'u ca'yajupø'omo. ");
INSERT INTO zosNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Por eso Diosis angui'mda'møjtzi va'cø ndzambotyam pø'nomo, y va'cø ndzajmayajø que Diosis cyot Jesús va'cø cyøme'chaj cyojapit mumu pøn, sea queñajpapø, sea ca'yajupø. ");
INSERT INTO zosNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mismo jetsetique't oy chamsajyajque't mumu tza'maṉvajcopapø'is que mumu vya'ṉjamyajpapø'is Jesús maṉba cøtocoyaj cyojapit por lo que Jesusis chøjcupøpit. ");
INSERT INTO zosNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nømdøcna'ṉ cham Pedro'is yøcspø ote, y nu'c Masanbø Espiritu Santo mumu pøngøsi ityajusecø'yi mientras nømna'ṉ cyøma'nøyaj Pedro. ");
INSERT INTO zosNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Israel pønda'm vya'ṉjajmyajpapø'is Jesús lo que miñajupø Pedroji'n nømna'ṉ ñømaya'yaju porque tujcu nunca ji'n tuquise. Porque va'ctzi'tøj Masanbø Espiritu Santo eyapø pøn lo que ji'ndyet Israel pøn. ");
INSERT INTO zosNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Porque myañaju que jic pø'nis aunque ji'ndyet Israel pø'nis, cyacpø'yaj ote, eyapø ote'omda'm oñaju, y vyøcotzøcyajpana'ṉ Dios. ");
INSERT INTO zosNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Entonces Pedro'is ñøjayaju: ―Como yøṉ pø'nista'm pyøjcøchoṉyaj Masanbø Espiritu Santo jujche tø øtz ndø pøjcøchondamuse, øtz nø'mbøjtzi que ji'n mus ndø ya'inductamø va'cø jyana nø'yøyajø. Y mitz ¿ti mi ndzamdamba? ");
INSERT INTO zosNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Entonces Pedro'is 'yaṉgui'myaju va'cø yac nø'yøyajtøj Jesucristo'is nøyicøsi. Después vya'cayaj Pedro va'cø chø'y siguiera tumø metza jamase'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Myañaj apostolesis y va'ṉjajmocuy tyøvø'sta'm Judea nasomda'mbø'is que jetsemete también eyapø pø'nis lo que ji'ndyet Israel pø'nista'm pyøjcøchoṉyajque'tumna'ṉ Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cuando Pedro nu'c Jerusalén gumgu'yomo, va'ṉjajmoyajpapø Israel pøn nømyaju que Pedro'is ja chøc vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Nøjayaju: ―¿Ti'ajcuy mi ñdyøjcøy pø'nis tyøjcomo lo que ji'ndyet Israel pøn, y jetji'ṉ oy mi ñgyu'ti? ");
INSERT INTO zosNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jetsemete ñøcøtzo'tz Pedro'is va'cø cha'maṉvajcay jujche oyse tuqui. Nøjayaju: ");
INSERT INTO zosNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Øtz ijtuna'ṉ Jope cumgu'yomo nømna'ṉ o'nøy Dios. Ji'na'ṉø mus ju'tzø ijtupø, isøjtzi napasyi'omse tum cojtocuy jujche møjapø sabanasepø. Nømna'ṉ myø'n tzajpomo, macsyaṉguin sinupø nø jyø'mø'ndøjupø nu'c øtzcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Cuando ngøque'nøyøjtzi mø'chøqui, ⁿisøjtzi nascøs vityajpapø copøn macsycuy cosota'mbø, y tza'ma copøn y jyøcøyajpapø'is vyin, y sava'om sititvityajpapø paloma. ");
INSERT INTO zosNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ma'nø tum ote nø nøjayupø'is: “Te'nchu'ṉø, Pedro, yaj ca'ø y vi'cø”. ");
INSERT INTO zosNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ⁿNøja'yøjtzi: “Øjtzø mi Ṉgomi, ji'nda, porque nunca ja o vi'ṉguisøtø'ctzi jetseta'mbø copøn o sea ji'n vyøjta'mbø tiyø lo que ya'inducpa angui'mgu'is”. ");
INSERT INTO zosNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jetse mena'como andzoṉ tzajpombø ote'is: “Lo que Diosis cyotque'tuse aṉgui'mguy va'cø ndø vi'cø, u mi ñømu que ji'ndyet vyøjpø tiyø”. ");
INSERT INTO zosNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jetse o tuc tu'cañac, y jiṉdi jiti qui'mvøjøtzoctøjque't mumu møji tzajpomo. ");
INSERT INTO zosNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Y misma horacøsi nu'cyaj tu'caṉbøn tøcmø jut øtz ijtumø, cø'vejyajtøjupø va'cø min me'chajø; y Cesarea cumgu'yom tzu'ṉyajupø. ");
INSERT INTO zosNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nøja'yøjtzi Espiritu Santo'is va'cø maṉ jetji'ṉda'm va'cø jana ṉgui'ps ni tiyø ø ndzoco'yomo. Tujtay ø va'ṉjajmoṉguy tyøvø maṉyajque'tu y tøjcøtya'møjtzi pø'nis tyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Y je'is tzajmatya'møjtzi lo que jujche oy is angeles te'nupø tyøjcomo. Angelesis oy chajmaye: “Cø'vejyaj pøn Jope cumgu'yomo va'cø mye'chaj tum ñøyipø'is Simón, mismo ñøyipø'isti Pedroque't. ");
INSERT INTO zosNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Je'tis maṉba mi ñchajmay ote jujche muspa mi ṉgyotzoctam mijtzi y mumu mi mbamiliaji'ṉducu”. ");
INSERT INTO zosNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Entonces cuando o'nøyincho'tz øjtzi, nu'c Masanbø Espiritu Santo jetcøsta'm. Igual jujche nu'cuse tø øtzcøsta'm vi'na, jetseti nujque'tu. ");
INSERT INTO zosNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Y jajmba'tøjtzi chamuse ndø Comi'is jujche ñøjayuse: “Viyuṉse Juan nø'yø'yoyu nø'ji'ṉ, pero øtz ma'ṉbø mi nø'yøndyam Masanbø Espiritu Santoji'ṉ”. ");
INSERT INTO zosNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Entonces como Diosis chi'yaj jejta'm Espiritu Santo igual como tø tzi'tamuse øjta'm cuando oy tø va'ṉjajmdam ndø Comi Jesucristo, ¿entonces i chøṉ øjtzi va'cø maṉ ya'induc Dios? ");
INSERT INTO zosNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Cuando myañaju'cti chamuse Pedro'is, vøṉgøne'cyaj nø cyøma'nøyajupø'is, y vyøcotzøcyajpana'ṉ Dios, nømyaju: ―De manera jetsetique't lo que ji'ndyet Israel pønda'm Diosis chi'yaj qui'psocuy va'cø qui'psvitu'yajø va'cø cyeñaj mumu jama. ");
INSERT INTO zosNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Cuando yaj ca'tøju'c Esteban, oy yacsutzøcyaj vya'ṉjamyajpapø'is Jesús y por eso puṉbø'pø'neyaju. Vene maṉyaj hasta Fenicia nasomo y Chipre cucnasomo, y Antioquía cumgu'yomo. Ni ja chajmayaj ni iyø vøjpø ote sino sólo Israel pønda'm chajmayaju. ");
INSERT INTO zosNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero veneta'mbø puṉbø'pø'neyajupø Chipre nasomda'mbøte y Cirene cumgu'yomda'mbøte. Jejta'm oy nu'cyaje Antioquía cumgu'yomo. Jiṉø 'yo'nayaj eyapø pøn lo que ji'ndyet Israel pønda'm, cha'maṉvajcayaj ndø Comi Jesusis vøjpø 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ndø Comi'is cyotzoṉyaju y vøti pø'nis vya'ṉjajmyaju y qui'psvitu'yaj ndø Comicøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Cuando Jerusalén gumgu'yomda'mbø'is vya'ṉjamyajpapø'is Jesús myañaju jujche oyse tuc jiṉø, entonces cyø'vejyaj Bernabé va'cø myaṉ hasta Antioquía cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Cuando Bernabé nu'cu, isu lo que Diosis chøjcupø vyø'ajcupit, y casøyu. Bernabe'is pyømitzi'yaj 'yotepit mumu va'cø syeguitzøcyaj vøjø ndø Comiji'ṉ y va'cø vya'ṉjajmyaj mø'chøqui tyumø chocoy. ");
INSERT INTO zosNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Porque Bernabé vøjpø pønete y cyøtøjcøy Masanbø Espiritu Santo'is tasu'csye'ṉomo, y Bernabé va'ṉjajmopyana'ṉ mø'chøqui; y mastina'ṉ nø vyøti'ajyaj vya'ṉjamyajpapø'is ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Jicsye'jcam maṉ Bernabé Tarso cumgu'yomo va'cø mye'tz Saulo. Bernabe'is pya't Saulo y ñømin Antoquía cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Opyana'ṉ tu'myaj tu'myajpapøji'ṉ tumø ame'am y 'yaṉmayajpana'ṉ vøti pøn. Y Antioquía cumgu'yomo vi'na yac nøyi'ajyajtøj Cristo'is ñe'ta'm vya'ṉjamyajpapø'is ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jic jama tzu'ṉyaj Jerusalén gumgu'yomo tza'manvajcoyajpapø y maṉyaj Antioquía cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Te'nchu'ṉ tumø ñe'comda'm ñøyipø'is Agabo. Cha'maṉvajcu que Espiritu Santo'is yaj cønøctøyøyu que maṉba it møja'aṉ yu' mumu ijnømu'csye'ṉomo. Y jetse oy tucnømi cuando Claudio møja aṉgui'mba'cna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Por eso qui'psyaju va'cø yu'mayaj tumin vya'ṉjamyajpapø'is ndø Comi, tum dum bø'nis va'cø cyota jujche muspase cyota; y entonces tumin va'cø cyø'vejayaj va'njajmocuy tøvø ityajupø Judea nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Y jetse chøcyaju. Cyø'vejyaj Bernabé y Saulo va'cø ñømaṉyaj tumin va'cø chi'yaj aṉgui'myajpapø tzambønda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mismo jic tiempo aṉgui'mbapø Herodesis nujcu y yacsutzøcyaj metzcuy tu'cay pøn tu'myajpapø Jesusis ñøyicøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Y yaj ca' espadapit Jacobo Jua'nise tyøvø. ");
INSERT INTO zosNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Y myusajcam Herodesis que Israel pø'nista'm vyø'møyaju va'cø jetse chøcø, entonces Herodesis yac nuctøjque'tuti Pedro. Jicø jama ijtuna'ṉ søṉ cuando cyø'syajpana'ṉ pan ja pyoṉoṉapø. ");
INSERT INTO zosNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herodesis ñuc Pedro y syomu. Y macsycuy macsycuy tumdumna'como cyoqueñaj Pedro dieciséis soldado'is. Herodesis syunbana'ṉ ñøput Pedro va'cø presentatzøc cumgupyøngøsi cøjtujcam pascua søṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Y mientras Pedro nømna'ṉ cyoquendøj preso'omo, vya'ṉjamyajpapø'is Jesús tu'myajpana'ṉ nømna'ṉ vya'cayaj Dioscøsi va'cø cyotzoc Pedro. Tumø tzocoy 'yo'nayajpana'ṉ Dios, ja ñitu'yajø, ja chacyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Cuando jyo'pit Herodesis mana'ṉ ñøputi, jete mismo tzu'cøsi Pedro ijtuna'ṉ øṉupø metzcupyø soldado cujqui vajtupø metzcupø cadenaji'ṉ, y ityajuna'ṉ cyoqueñajpapø'is aṉdyu'ṉaṉvini va'cø cyoqueñaj preso. ");
INSERT INTO zosNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Entonces joviti nu'c tum ndø Comi'is 'yangeles y syø'ṉocpac preso. Y angelesis chaṉaṉsa' syepsacøsi Pedro y ñøjayu: ―Te'nchu'ṉ jø'nø jø'nø. Entonces pucsanvacyaj cyø'cøspø cadena y quecyaj nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nøjayu anjelesis: ―Si'n mi nducu y vatca'm mi vaṉgasnaca. Jetse chøjcu. Y ñøjmaque'tuti: ―Metz mes mi nducu y mi tø pa'tø. ");
INSERT INTO zosNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Y Pedro pujtu y angelesis jyøsaṉgø'm maṉu, y ji'naṉ myusi o'ca viyuṉbø tina'ṉ nø chøc angelesis, pero nømna'ṉ cyomo'yuse que napasyi'omseti tujcu. ");
INSERT INTO zosNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pero cyøjtayaj vi'napø y metzcupyø cyoqueñajpapø'is y nu'cyaj tø'ṉgupyø aṉdyuṉgø'mø putyajpamø calle'omo. Yøṉø aṉvac ñe'cti. Putyaju cøtyaj tum calle'omo. Jicsye'cti tzu'ṉ jetcø'mø angeles. ");
INSERT INTO zosNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Y Pedro'is min cuendatzøqui y nømu: ―Yøti viyuṉete musu'mtzi que ndø Comi'is oy cyø'vej 'yangeles y yaj cotzojcøjtzi Herodesis cyø'omo, va'cø jana tzøjcayaj øjtzi lo que suñajpase Israel pø'nista'm. ");
INSERT INTO zosNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Quipsme'tzujcam jujche va'cø chøcø, maṉ Jua'nis myama Maria'is tyøcmø. Jua'nis ñøyi'aṉgopac Marcos. Maria'is tyøcmø ityajuna'ṉ vøti pøn tu'myajupø va'cø 'yo'nøyaj Dios tu'mbac. ");
INSERT INTO zosNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Cuando nu'c jeni, nømna'ṉ cyocscocsvøy a'ṉgombø aṉdyuṉ Pedro'is, y cyønu'cu va'cø min 'yaṉdzoṉ tum papiñomo'is ñøyipø'is Rode. ");
INSERT INTO zosNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Cuando cyønøctøyøjay Pedro'is 'yote, cajsøyu, ni ja 'yaṉvac aṉdyuṉ, pero popya tøjcøy jojmo va'cø maṉ chajmayaj lo demas que aṉdyuṉgø'm te'n Pedro. ");
INSERT INTO zosNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pero je'tsita'm ñøjayaju: ―ⁿJyovimbøt mijtzi, jindyet jicø. Pero Rode'is ñøjayu que viyuṉse jendi te'n Pedro. Ñøjayajque'tu: ―Je's 'yangelestimete. ");
INSERT INTO zosNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pero Pedro'is syeguitzøjcu va'cø cyocscocsvøy aṉdyuṉ. Y cuando 'yanvacyaj aṉdyun y isyaj Pedro, ñømaya'yaju. ");
INSERT INTO zosNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Je'is chøc seña cyø'ji'ṉ va'cø vyøṉneyajø, y cha'maṉvajcayaju jujche ndø Comi'is oy ñøput preso'omo y ñøjayaju: ―Tzajmatyam Jacobo y eyata'mbø ndø tøvøta'm jujche oyse tyuqui. Y tzu'ṉu y maṉ eyaco lugajromo. ");
INSERT INTO zosNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cuando sø'nbønømu, nømna'ṉ pyoyevityaj soldado, nømaṉ 'yocva'cyaju jutznøm poy Pedro. ");
INSERT INTO zosNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Y cuando Herodesis o mye'tzjo'y Pedro y ja pya'tø, entonces 'yocva'cyaj oyu'is cyoqueñaje ticøtoya ja it jeni. Y 'yaṉgui'myaju va'cø yaj ca'yaj soldado porque ja cyoqueñaj vøjø. Después Herodes tzu'n Judea nasomo maṉ Cesarea cumgu'yomo, y jiṉ tzø'yu. ");
INSERT INTO zosNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodesis nømna'ṉ qui'sayaj Tiro y Sidón cumgu'yomda'mbø. Pero Tiro y Sidón cumgu'yomda'mbø'is chøcyaj acuerdo va'cø man 'yo'nøyaj Herodes. Amigo'ajyaj Herodesis tyøjcom aṉgui'mbapø ñøyijø'is Blasto va'cø cyø'oñajø Herodescøsi, va'cø vya'cayajø va'cø jana quipyaja'am, porque yøṉø cumgupyø'nista'm opyana'ṉ pyøcyaj cu'tcuy aṉgui'mbapø'is ñasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodesis chajmayaj tijø jama va'cø tu'myajø. Entonces je jama Herodes po'cs aṉgui'mba'is pyo'cscucyøsi; myes suñipø tucu myespasepø angui'mba'is. Y jetse chajmayaju vøti pøn tu'myajupø ti nø syun chajmayajø. ");
INSERT INTO zosNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Y sone pøn vejyajpana'ṉ nømyaju: ―Jic nø vyejvejneyupø ji'ndyet pøn, sino que diosete. ");
INSERT INTO zosNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Y misma hora chi' ca'cuy Herodes ndø Comi'is 'yangelesis, porque ja vyøcotzøc Dios, y namcha'nis cyø'sca'yaju. ");
INSERT INTO zosNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pero vøti pø'nis nømna'ṉ pyøjcøchojṉayaj ndø Comi'is 'yote, y aunque jut chambotyøj je ote. ");
INSERT INTO zosNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé y Saulo tzu'ṉyaj Jerusalén gumgu'yomo vitu'yaju ta'nujcam ñucstøjumø. Y ñømaṉyaj Juan ñøyipø'stique't Marcos. ");
INSERT INTO zosNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquía cumgu'yomo ityajuna'ṉ tu'myajpapø ndø Comi'is ñøyicøsi, y je'tomo ityajuna'ṉ tza'maṉvajcoyajpapø y aṉma'yoyajpapø. Ityajuna'ṉ Bernabé, y Simón ñøjmayajpapø Yøcpø. Itque'tutina'ṉ Lucio, Cirene cumgupyøn; y Manaén oyupø tzoc parejo aṉgui'mbapø Herodesji'ṉ; y jendi itquetutina'ṉ Saulo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mientras que jana cu'ti nømna'ṉ chøjcayaj ndø Comi'is yoscuy, ñøjayaju Masanbø Espiritu Santo'is: ―Cøpijṉatya'møjtzi Bernabé y Saulo va'cø chøjcayaj ø ⁿyoscuy para jutipøcøtoya ⁿvejayajøjtzi. ");
INSERT INTO zosNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jetse jana uquipø jana cu'tipø va'ṉjajmocuy tøvø'is cyotyaj cyø' Bernabecøsta'm y Saulocøsta'm, y jetse 'yo'nøyu tzacyaju va'cø myaṉyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jejta'm pues cyø'vejyajupø Masanbø Espiritu Santo'is, maṉyaj Seleucia cumgu'yomo. Y de jiṉø tøjcøyaj barco'omo maṉyaj Chipre cucnasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nu'cyajujcam Salamina cumgu'yomo, nømna'ṉ chamyaj Diosis 'yote Israel pøn tu'myajpamø, y Jua'nis nømna'ṉ cyotzoṉyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Vijtocøtpø'yaju cucnas hasta nu'c Pafos cumgu'yomo. Jen pya'tyaj tum brujo Israel pønete tza'maṉvajcopapø pero sutzcuji'ṉ, ñøyina'ṉ Barjesús. ");
INSERT INTO zosNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yøṉ brujo jena'ṉ it aṉgui'mbapøji'ṉ. Angui'mbapø'is ñøyi Sergio Paulo. Sergio Paulo'is algo ijtuti qui'psocuy, y vyejayaj Bernabé y Saulo syunbana'ṉ cyøma'nøjay Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero je brujo, ñøyipø'stique't Elimas, je'is nømna'n syun 'yangøma'cøy aṉgui'mbapø va'cø jyana va'njam ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Entonces Saulo, ñøyipø'stique't Pablo; como Masanbø Espiritu'is ñøc'ijtøyu hasta tasu'csye'ṉomo, je Pablo'is 'ya'maṉga' brujo ");
INSERT INTO zosNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","y ñøjayu: ―Mijtzi vøti mi ñø'it mumu aṉgøma'cø'ocu'is y mumu yatzi'ajcu'is. Yatzi'ajcu'is mi 'yune. Ji'n mi vø'møy ni jutipø vøjpø tiyø. ¿Ti'ajcuy mumu jama mi yac vo'ti'ajapya ndø comi'is viyuṉbø tyuṉ? ");
INSERT INTO zosNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yøti, pues, ndø Comi'is maṉba mi ṉgyastigatzøqui; manba mi ñdyo'ti'aje, ji'n ma mi is jama sø'ṉgø, ji'n ndø mus jutzø jama maṉba mi nchø'y ndyo'tipø. Jicsye'cti misma hora nu'c jetcøs como jocosepø, y pi'tzø'ajcu'yomse o tzø'y, y nømna'ṉ myø'ṉvitjo'yu i'is jyøcønøvitpa cyø'cøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Cuando aṉgui'mbapø'is isu jujche o to'ti'aj pøn, entonces vya'ṉjam ndø Comi, porque ñømaya'jay ndø Comi'is 'yaṉma'yøcuy. ");
INSERT INTO zosNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Entonces Pafos cumgu'yomo tzu'ṉyaj barco'omo Pablo y jetji'ṉda'm vityajpapø, y nu'cyaju Perge cumgu'yomo Panfilia nas co'aṉjajme'omo. Pero Juan tzu'ṉ jetcø'mø y vitu' Jerusalén gumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Y jejta'm tzu'ṉyaj Perge cumgu'yomo vityaju nu'cyaj Antioquía cumgu'yomo Pisidia nas co'aṉjajme'omo. Jen tøjcøyaj Israel pøn tu'myajpamø tum sapøjcuy jama'omo y po'csyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jic libro tyu'ñaju ijtupø'om Moisesis 'yaṉgui'mguy, y tyu'ñajque't jujche oyuse jyayaj tza'maṉvajcoyajpapø'is. Entonces tu'myajpamø covi'najø'is cyø'vej ote Pablocøsta'm, ñøjayaju: ―Tøvøyta'm, o'ca mijta'm sunba mi ndzi'yaj qui'psocuy vøti pøn, tza'maṉvajcayajø. ");
INSERT INTO zosNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Entonces te'ñchu'ṉ Pablo, chøc seña cyø'ji'ṉ va'cø vyøṉneyajø, y ñøjmayaju: ―Israel pønda'm y mi ṉgøna'tzøtyambapø'is Dios, cøma'nøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dios lo que ndø va'ṉjajmdambapø tø Israel pø'nista'm, je'is cyøpiṉyaj ndø jandatzu'ṉgutya'm y más yac vøti'aj yaju y más yac pømicøpøcyaju mientras nømna'ṉ vityaj Egipto nasomo. Después mismo ñe'c Diosis ñøputyaj ñe' pyømiji'ṉ Israel pønda'm Egipto nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Como cuarenta ame ñømaṉjayaj pasencia jejta'm tøtzønasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Y Diosis yajyaj cu'ya cøcumgupyø Canaán nasomo, y vye'ndzi'yaj nas Israel pønda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Jiṉ ityajuna'ṉ como cuatrocientos cincuenta ame. Después de yøṉø, Diosis cyotyaj cøme'tzoyajpapø va'cø 'yangui'myajø hasta que oyu tza'maṉvajcopyapø Samuel. ");
INSERT INTO zosNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Entonces cumgu'is vya'cyaj angui'mba, y Diosis cyot Saul va'cø 'yaṉgui'mø. Ijtuna'ṉ pøn ñøyipø'is Cis y Saul je'tis 'yunete, y Benjami'nis chajcupø 'yune. Por cuarenta ame oy yaṉgui'myaj je'is. ");
INSERT INTO zosNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Después Diosis ñøput Saul, y cyot David va'cø 'yaṉgui'mø. Diosis chamu jujchepø pønete David, nømu: “Ngomuspøjtzi Isai'is 'yune David yac tzocopyacpapø'is ø ndzocoy. Je'tis maṉba chøc mumu tiyø øtz sunbase”. ");
INSERT INTO zosNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Después que cøjtujcam vøti ame, Davijdis chacyajupø 'yune'omo Diosis cyot Jesús va'cø yaj cotzocyaj Israel pønda'm. Según lo que vi'na chamuse maṉba chøc jøsijcam, jetse chøjcu. ");
INSERT INTO zosNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pero antes que min Jesús, Jua'nis chajmayaj mumu Israel pønda'm va'cø ñø'yøyajø, y va'cø qui'psvitu'yajø. ");
INSERT INTO zosNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ta'nbø'ujcam Jua'nis yoscuy, nømu Juan: “Øtz ji'nchøṉ jicø lo que mitz ṉgomo'tyambase. Øtz vi'na mi'nøjtzi, jøsi'cam minba eyapø. Jet myøja'nombø viyuṉsye. Hasta va'cø chøjay nu'csocuy jic myøja'ṉombø pøngøtoya, syunba más vøjpø pøn que ji'n øjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pablo'is ñøjayajque'tu: ―Tøvøyta'm, mi o'nøndyamba mijtzi Abraha'mis mi 'yuneta'm, y también mi ṉgøna'tzøtyambapø'is Dios aunque ji'ndye Abraha'mis mi 'yuenta'm. Mijta'm ṉgyø'vejatyam Diosis yøṉø 'yote va'cø mi ṉgyotzoctamø. ");
INSERT INTO zosNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Porque Jerusalén gumgu'yomo ityajupø'is y jiṉbø aṉgui'myajpapø'is ja myusyaj iyete Jesús. Y ja cyønøctyøyøyaj nunca lo que chamuse tza'maṉvajcopapø'is, aunque tyu'ñajpa jachø'yuse aṉgui'mguy tumdum sapøjcuy jama. Jejta'm tu'mbajcajyaju que vøjø va'cø yaj ca'yaj Jesús, y jetse yac viyuṉaju lo que tza'maṉvajcopapø'is oyse chame que maṉba tuqui. ");
INSERT INTO zosNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Aunque Jesusis cyoja ja pya'tayajø, pero vya'cayaj Pilatocøs va'cø yaj ca'tøjø. ");
INSERT INTO zosNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Cuando chøcyajuna'ṉ mumu lo que jachø'yupø que maṉba chøcyaje, entonces ñømø'ñaj Jesús cruzcøsi y cyotyaj tzatøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero Diosis yac visa'u ca'yajupø'omo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jesusis yaj quejayaj vyin sone jamapit eyata'mbø lugajromo. Jujche'aṉbøn oyupø'is pya'tyaj Jesús cuando tzu'ṉ Galilea nasomo va'cø myaṉ Jerusalén gumgu'yomo, oyupø'is pya'tyaje, je'is isyaj Jesús después que visa'u. Y yøti je'is muspa chajmayaj mumu pøn lo que isyajupø. ");
INSERT INTO zosNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","”Y øjta'm nø mi ndzajmatyam mijta'm vøjpø ote, que Diosis vi'na chajmayaj ndø jandatzu'ṉgutya'm que maṉba chøjcayaj vøjpø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Cuando Diosis yac visa' Jesús, jetse viyuṉgotzøjcay 'yote para tø øtzcøtoyata'm, ndø jandatzu'ṉgu'is tø 'yuneta'm. Yac viyuṉaju porque yac visa' Jesús jujche ijtuse jaychø'yupø Salmos libro'omo metzcupyø capitulo'omo. Nømba jeni: “Øjchøṉ mi ⁿUne; yøtipø jama ⁿyac mustøj øjtzi que øjchøṉ mi ⁿUne”. ");
INSERT INTO zosNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios nømu ijtuse libro'omo jachø'yupø: “Ma'ṉbø mi ndyoya'ṉøtyam viyuṉsye como ndzamdzi'øjtzi David”. Jetse chajmayuse que maṉba yac visa' Jesús ca'yajupø'omo, va'cø jyana pyutzpø' syis. ");
INSERT INTO zosNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Salmos libro'omo nømgue'tpa eyapø capitulo'omo: “Ji'n ma mi ndzac masanbø mi ⁿUne tzatøjcomo va'cø jyana putzpø'ø”. ");
INSERT INTO zosNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Porque viyuṉse Davijdis oy yosayaj pønda'm lo que ityajupøna'ṉ jicsye'c jujche sunbase Diosis. Pero David ca'u, y oy niptøji niptøjumø jyatata'm, y jen pyutzpø' syis. ");
INSERT INTO zosNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero Jesús Diosis yac visa'u aṉcø ja pyutzpø' syis. ");
INSERT INTO zosNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mustam mijtzi, tøvøyta'm, que nømdi tzamdøju que Diosis tø yac tzu'ṉapya ndø coja por lo que chøjcuse aṉcø Jesusis. ");
INSERT INTO zosNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Aunque sunba ndzøctando' mumu tiyø lo que Moisesis 'yaṉgui'mgu'yomo it jachø'yupø, ja mus mi mbyujtam vyøjomo, porque ja yajtam mi ṉgoja; pero o'ca mi va'ṉjamba Jesús, je'is mi yajambya mi ngoja va'cø mi mbyujtam vyøjomo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Coquendamø mi ⁿvin uy tuc mitzcøsi lo que chamyajupø tza'maṉvajcopapø'is. Yøcse nømyaju: ");
INSERT INTO zosNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","A'mdamø, mi ṉgonojcatyambapø'is ø onde; manba mi ndyocotyam maya'aṉsye. Porque nø'mø ndzøc tum maya'aṉbø yoscuy mi jama'omda'm. Aunque mi nchajmatyandøjø ti ndzøjcøjtzi, ni jujche ji'n ma mi va'ṉjamdame. Je'nche'ṉom cham Pedro'is. ");
INSERT INTO zosNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Entonces cuando nømna'ṉ pyutyaju'øc Israel pønda'm tu'myajpamø, lo que ji'ndyet Israel pø'nista'm ñømgø'nayaj Pablo va'cø mingue'tatøc eyapo sapøjcuy jama va'cø chajmayajque't yøcsepø ote. ");
INSERT INTO zosNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Cuando putyaju'øc tu'myajpamø, maṉ pya'tyaj Pablo y Bernabé vøti Israel pø'nis, y vøtipø pyøjcøchoṉu'is Israel pø'nis vya'ṉjajmocuy, y cyøna'tzøyajpapø'is Dios. Pablo'is y Bernabé'is 'yo'nøyaju y ñømgo'nayaju va'cø vya'ṉjajmoyaj mø'chøqui Diosis cyotzoṉyajpase ñe' vyø'ajcupit, va'cø jyana jajmbø'yaj nunca. ");
INSERT INTO zosNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Y eyaco sapøjcuy jama tu'myaj casi mumu cumgupyøn va'cø cyøma'nøjayaj Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero cuando isyaj Israel pø'nis vøti pøn tu'myajupø, qui'sayaj Pablo porque jet más cyøtu'myaju ancø; vi'nøc'on'onvøyaju, cyø'o'nøyaju lo que Pablo'sna'ṉ nø cha'maṉvajcupø. ");
INSERT INTO zosNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pero Pablo'is y Bernabe'is jana na'tzcuy ñøjayaju: ―Sunbana'ṉ va'cø mi vi'na nchajmatyandøj Diosis 'yote mijta'm mi Israel pø'nista'm. Pero como mi ya'indujcatyamba mijtzi 'yote, mi ne'c mi yaj quejtamba que ji'n mi ⁿvyøjta'm; y ne'c it mi ṉgoja que ji'n mus mi mbøjcøchoṉdam ji'n yajepø quenguy. Øtz ma'ṉbø maṉdyam emøc, ma'ṉbø ndzajmatyam ote eyata'mbø pønda'm lo que ji'ndyet Israel pønda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Porque øtzta'm ø aṉgui'mda'møjtzi ndø Comi'is, yøcse nøja'yøjtzi: Øjtzø mi ṉgojtam mijtzi para va'cø mi ndzajmatyam ote mumu pøn lo que ji'ndyet Israel pøn, va'cø ityaj como sø'ṉgø'omse; va'cø mi ndzajmay ote va'cø cyotzocyaj hasta más ya'i nasomda'mbø pønda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Myañaj yøcseta'mbø tiyø eyata'mbø pø'nis lo que ji'ndyet Israel pø'nista'm, y casøyaju y vyøcotzøcyaj ndø Comi'is 'yote. Y mumu cyøpiṉyajuse Diosis va'cø queñaj mumu jamacøtoya, je'is vya'ṉjamyaj Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Y ndø Comi's 'yote tzambotyøjpana'ṉ mumu jiṉda'mbø cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero Israel pø'nis pyømi tzi'yaj cyøna'tzø'yoyajpapø y vøcotzøcyajtøjupø yomo va'cø qui'sayaj Pablo y Bernabé. Y pyømi tzi'yajque't cumgu'is cyovi'najøta'mbø pøn parejo je yomoji'ṉ va'cø yacsutzøcyaj Pablo y Bernabé, y jetse myacpø'yaju cyo'aṉjajme'omo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pablo'is y Bernabe'is cyøvijcøjayaj pyoyoji'ṉ cyoso como seña que ityajuna'ṉ cyoja cumgupyø'nis ñe'ta'm. Y maṉyaj Iconio cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero vya'ṉjamyajpapø'is Jesús casøcomø'ñaju y Masanbø Espiritu Santo'is ñøc'ijtøyaju tasyaju'csye'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Yøcse tuc Iconio cumgu'yomo: Pablo y Bernabé tu'mbac tøjcøyaj Israel pøn tu'myajpamø y chajmayaj ndø comi'is 'yote musocuji'ṉ. Y jetse vya'ṉjamyaj Jesús vøti Israel pø'nis, y lo que ji'ndyet Israel pø'nis jetseti vya'ṉjamyajque'tu. ");
INSERT INTO zosNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero Israel pø'nista'm ji'n vya'ṉjajmyajepø'is chamgui'sycayaju y jujcheseti'am yac tyujcayaj eyata'mbø'is qui'psocuy va'cø qui'sayaj vya'ṉjajmyajpapø'is Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pues oy tzø'yaj jeni ya'i jama. Jana na'tzcuy chajmayaj ndø Comi's 'yote, y ndø Comi's yaj quejpana'ṉ que mismo ñe 'yote lo que cha'maṉvajcupø, que ndø Comi's tø cotzoṉdamba ñe' vyø'ajcupit. Porque Diosis chi'yaj apostoles musocuy va'cø chøcyaj milagro'ajcuy y seña. ");
INSERT INTO zosNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pero cumgu'yomda'mbø'is eyati eyata'm qui'psyajpana'ṉ; porque vene'ta'mbø'is vyø'møyaj Israel pønji'ṉ, y veneta'mbø'is vyø'møyaj apostolesji'n. ");
INSERT INTO zosNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Entonces Israel pø'nista'm, y lo que ji'ndyet Israel pø'nista'm, y je'tista'm cyovi'najø'is nømna'ṉ qui'psyaju va'cø cha'ajcuy chi'yajø, y va'cø pyu'ṉga'yaj tza'ji'ṉ apostoles. ");
INSERT INTO zosNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero myusyaj apostolesis ti maṉba tzøjcayajtøji, y poyaju y maṉyaj Listra cumgu'yomo y Derbe cumgu'yomo, Licaonia nasomda'mbø cumguy, y mumu ribera'omda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Y jiṉ chamyajpana'ṉ vøjpø ote. ");
INSERT INTO zosNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Y ijtuna'ṉ tum pøn Listra cumgu'yomo yu'quipø'is cyoso, jetse pø'naj yacsupø, y nunca ja mus vitø. ");
INSERT INTO zosNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Yø'ṉis cyøma'nøpyana'ṉ Pablo'is chamupø. Y Pablo'is 'ya'maṉga' ñe'cø y isu que yacsupø'is cyoso vya'njajmu que muspa yac tzoca. ");
INSERT INTO zosNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Por eso Pablo'is ñøjay pømi: ―Viyuṉde'n mi ṉgosoji'ṉ. Y tøpte'nu y vitpana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Y cuando isyaj vøti pø'nis lo que ti chøjcu Pablo'is, entonces vejtonde'ñaj Licaonia ote'omo, nømyaju: ―Pønseta'mbø diosis tø cømø'ndamu. ");
INSERT INTO zosNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Cyomo'yajpana'ṉ que Pablo y Bernabé diosta'mete. Yac nøyi'ajyajuna'ṉ Bernabé Júpiter, y Pablo yac nøyi'ajyajuna'ṉ Mercurio, porque Pablo'is masna'ṉ chamba ote. Ñe' cyomi'sta'm ñøyi jetseta'm. ");
INSERT INTO zosNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jupitejris myasandøc ijtuna'ṉ cumguy tyøjcøcu'yomo. Y Jupitejris pyane'is ñønu'cyaj toro yac mesyajupø jøyø corona tzøquipø. Y vøti pø'nis syunbana'ṉ va'cø yaj ca'yaj toro va'cø cyøna'tzøyaj Pablo y Bernabé como ñe' cyomi cyøna'tzøyajpasena'n. ");
INSERT INTO zosNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero cuando myañaju'øc apostolesis Bernabe'is y Pablo'is que jetse maṉba chøcyaje, entonces jyundzichaj tyucu como seña que nømyaya'yaju, y vejaṉgøtpa poyetøjcøyaj vøti pø'nomo. ");
INSERT INTO zosNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ñøjmayaju: ―Mi mbyønda'm ¿ticøtoya jetse mi ndzøctamba? Porque øjta'm yempe jujchepø pønda'mdi chøṉgue't como mijcheta'm. Øjtzi nø mi ndzajmatyam vøjpø ote va'cø mi ndzactam yøṉ comequecta'mbø tiyø, y va'cø mi ṉgui'psvitu'tam quenbapø Dioscøsi, chøjcupø'is tzap y nas y nachcupø nø' y mumu lo que ijtupø je'tomo. ");
INSERT INTO zosNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Vi'na cøtyajupø ame'omo Diosis chi'yaj licencia mumu pønda'm va'cø chøcyaj ñe'c sunbase chøcyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero Diosis siempre yac isyaj aunque iyø que ti chøjcu va'cø myusyaj jujchepøte ñe'c Dios; porque tø tzi'tamba vøjpø tiyø. Para tø øtzcøtoya yaj quecpa tuj, vøti yac itpa vøjpø cosecha, y aunque ti cu'tcuy tø cojtatyamba va'cø casøtyam ndø tzocoy. ");
INSERT INTO zosNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Y chamyajupø yøcsepø tiyø, penapit ya'inducyaj vøti pøn va'cø jyana yaj ca'yaj copøn ñe'jcøtoya cøna'tzø'yocu'is cuenta. ");
INSERT INTO zosNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Entonces miñaj Israel pønda'm Antioquía cumgu'yomda'mbø y Iconio cumgu'yomda'mbø y chamgui'syca'yaj vøti pøn va'cø pyu'ṉga'yaj Pablo tza'pit. Jetse pyu'ṉyaju y ñøputyaj cumguy'acapo'yomo, y jiṉ chacyaju; cyomo'yaju que ca'umna'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero mientras vyo'cøtøjcøyaj Pablo vya'ṉjamyajpapø'is Jesús, te'nchu'ṉ Pablo y tøjcøcye't cumgu'yomo. Jyo'pita'mete tzu'ṉyaj Bernabeji'ṉ va'cø myaṉyaj Derbe cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Chajmayajpana'ṉ vøjpø ote jic cumgu'yomda'mbø, y vøti'ajyaj vya'ṉjamyajpapø'is Jesús. Entonces Pablo y Bernabé vitu'yaj Listra cumgu'yomo y Iconio cumguyomo y Antioquía cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pablo'is nømna'ṉ qui'psocuy chi'yaju vya'ṉjamyajpapø'is Jesús va'cø más vøj vya'ṉjajmoyajø. Chi'yaj consejo va'cø jyana jajmbø'yaj vya'ṉjajmocuy. Y nømu que tiene que va'cø ndø nøcøj toya vøti va'cø tø tøjcøy Diosis cuenta'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pablo'is y Bernabe'is cyotyajuna'ṉ tzambønda'mbø va'cø 'yaṉgui'myaj tumdumø tu'mgu'yomo tu'myajpamø vya'ṉjajmyajpapø'is Jesús. 'Yo'nøyaj Dios jana cu'tipø, y después chamdzacyaju va'cø cuendatzøcyaj ndø Comi'is. 'Yo'nøyaj ndø Comi oyupø vya'ṉjajmyaje, je'is va'cø cuendatzøcyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Y cøtyajumna'ṉ Pisidia nasomo, maṉyaj Panfilia nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Y oyajujcam chamboyaj ote Perge cumgu'yomo, mø'ñaj Atalia cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Y de jeni maṉyaj barco'omo nu'cyaj Antioquía cumgu'yomo jujna'ṉ oyumø chamdzacyajtøj Diosis vyø'ajcupit va'cø chøcyaj yoscuy lo que tujcupø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nu'cyajujcam, vyejtu'myaj vya'ṉjajmyajpapø'is Jesús, y apostolesis chajmayaj maya'ṉda'mbø tiyø Diosis chøjcuse ñe'c apostolesji'ṉ. Y chajmayajque'tu que Diosis yac tøjcøyaj va'ṉjajmocu'yomo eyata'mbø pøn lo que ji'ndyet Israel pønda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jiṉ oy ya'yaj vøti jama ityajumø vya'ṉjajmyajpapø'is Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Y tzu'ṉyaj pøn Judea nasomo vya'ṉjajmyajpapø'is Jesús y nu'cyaj Antioquía cumgu'yomo y 'yaṉmayaj vya'ṉjajmocuy tyøvøta'm ñøjmayaju: ―O'ca ji'n mi syeña'øtyam Israel pø'nis syeñaji'ṉ como 'yaṉmayusena'ṉ Moisesis, ji'n mi ṉgyotzoctame. ");
INSERT INTO zosNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Je'tis ñø'onguipyaj vøti Pablo y Bernabé y vejvejneyaju. Vyø'møyaju que vøjø va'cø myaṉyaj Jerusalén gumgu'yomo Pablo y Bernabé y eyata'mbø ñe'comda'm va'cø cyønu'cjayaj apostoles y tzambønda'm va'cø ñøtzamyaj yøcsepø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Entonces vya'ṉjajmyajpapø'is Jesús 'yo'nøyu tzacyaj Pablo y Bernabé y eyata'mbø va'cø myaṉyaj Jerusalén gumgu'yomo. Y cøtyaj Fenicia nasomo y Samaria nasomo, chajmayaj jujche oy qui'psvitu'yaj pø'nista'm lo que ji'ndyet Israel pø'nista'm, y por eso cajsøyaj mumu vya'ṉjajmocuy tøvøta'm. ");
INSERT INTO zosNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Cuando nu'cyaj Jerusalén gumgu'yomo Pablo y Bernabé, pyøjcøchoṉyaj vya'ṉjajmyajpapø'is Jesús y apostolesis y va'ṉjajmocuy tyøvø tzambønda'mbø'is. Pablo'is y Bernabe'is chajmayaj mumu tiyø lo que jujche Diosis chøjcuse chi'use qui'psocuy ne'c Pablo y Bernabé jujche va'cø chøcyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero teñchu'ṉyaj metzcuy tu'cay fariseo'is vya'ṉjajmocuy ñø'ijtupø'is oyupø'is vya'ṉjajmyaj ndø Comi. Nømyaju que syunba va'cø syeña'øyaj lo que ji'ndyet Israel pønda'm y va'cø 'yaṉgui'myajø va'cø cyo'aṉjamyaj Moisesis 'yaṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Entonces tu'myaj apostoles y tzambønda'm va'cø qui'psyajø ti maṉba chøcyaje. ");
INSERT INTO zosNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Vøti hora vejvejneyaju, y entonces te'ñchu'ṉ Pedro, ñøjayaju: ―Tøvøyta'm, mitz mustamba que ijtu'am 'yame Diosis ø cøpiṉ mijtzomda'm va'cø ndzajmayaj vøjpø ote pønda'm lo que ji'ndyet Israel pønda'm, va'cø vya'ṉjamyaj ndø Comi. ");
INSERT INTO zosNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Y Diosis myusapyapø'is mumu pø'nis chocoy, je'is yac isu que ñe'c pyøjcøchoṉyaju vya'ṉjamyajpapø'is Jesús lo que ji'ndyet Israel pøn, porque chi'yaj jejtam Masanbø Espiritu Santo jujche tø tzi'tamuse tø øtzta'm vi'na. ");
INSERT INTO zosNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Diosis parejo chøcyaj jetji'ṉ y tø øtzji'ṉ, porque yaj cøvajcøyaj chocoy vya'njajmocupit. ");
INSERT INTO zosNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Y yøti ti'ajcuy ma mi aṉgui'ma'ṉøtyame más que ji'n Dios? Como tzømi tzøctøjpase ji'n ndø jø'nipø, jetse eyapø aṉgui'mguy mi sunba ndzøjca'ṉøtyam vya'ṉjamyajpapø'is Jesús, eyapø aṉgui'mguy lo que ni ndø jandatzu'ṉgu'ista'm ja musipø chøcyajø, ni tø øjta'm ji'n mus ndø tzøctamø. ");
INSERT INTO zosNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pero ndø va'ṉjajmdamba que ndø Comi Jesusis vyø'ajcupit tø cotzoctamba, y eyata'mbø pøn jetseti cotzocyajque'tpa. ");
INSERT INTO zosNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Chamu'c Pedro'is jetse, vøṉgøne'cyaj mumu vøti pøn, y cyøma'nøyaj Bernabé y Pablo nø cha'maṉvacyajumø maya'aṉbø tiyø y milagro'ajcuy chi'yajuse Diosis qui'psocuy va'cø chøcyaj pø'nomo lo que ji'ndyet Israel pø'nomo. ");
INSERT INTO zosNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Cuando cha'manjeju'cam jetse Bernabe'is y Pablo'is, entonces Jacobo'is 'yaṉdzoṉu, ñøjayaju: ―Tøvøyta'm, tø cøma'nøytyam ndøvø: ");
INSERT INTO zosNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro'is tø tzajmatyamu jujche Diosis vinbøcøsi chøjcayaj vøpø tiyø lo que ji'ndyet Israel pønda'm cuando cyøpiṉyaj entre je'tomda'm pønda'm va'cø ñøjmayajtøj Diosis ñe'ta'm. ");
INSERT INTO zosNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Igual chamba lo que jujche it tza'maṉvajcopyapø'is 'yote jachø'yupø: ");
INSERT INTO zosNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Jøsi'jcam ma'ṉbø vitu'i y ma'ṉbø yac aṉgui'myajque'te Davijdis chacyajupø 'yuneta'm lo que oyupø cøyajyaje; jujche ndø tzøcvøjøtzøcpa tøc lo que quejcupø, jetse ma'ṉbø vøjøndzøcyajque'te va'cø 'yaṉgui'myajque'ta. ");
INSERT INTO zosNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Jetse ma'ṉbø ndzøqui va'cø mye'chajque't ndø Comi mumu pø'nis, va'cø jana saṉ Israel pø'nisti mye'chajø. Y yøṉ eyate'mbø pøn øjchø ne'nda'mgue't. ");
INSERT INTO zosNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Jetse nømba ndø Comi tø yac mustambapø'is mumu yøcsepø tiyø desde ya'møc. ");
INSERT INTO zosNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","”Por eso ngui'pspøjtzi que vøjø va'cø jana ndø yac maya'yaj nø vya'njamyaju'is Dios entre eyata'mbø pø'nomo lo que ji'ndyet Israel pø'nomo. ");
INSERT INTO zosNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Pero va'cø ndø ⁿjajyayaj cartacøsi va'cø jyana cyø's ni tiyø yac yostøjupø comi chøqui cøna'tzø'ocu'yomo, va'cø jyana møtzi ñø'it yomo; va'co jyana vi'c mo'jca'upø'is syis; y va'ca jyana vi'c nø'pin. ");
INSERT INTO zosNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Porque desde ya'møc ijtu aunque jutpø cumgu'yomo cha'maṉvacyajpapø'is Moisesis 'yaṉma'yocuy tumdum sapøjcuy jama. Tu'mnømbamø tyu'nayajpa Moisesis tyotojaye. ");
INSERT INTO zosNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Entonces vyø'møyaj apostolesista'm y tzambø'nista'm y mumu tu'myajpapøji'ṉ que vøjø va'cø cyøpiṉyaj pøn ñe'comda'm va'cø cyø'vejyaj Antioquía cumgu'yomo Pabloji'n y Bernabeji'ṉ. Y cyøpiṉyaj metzcuy pøn, tum Judas ñøyipø'isque't Barsabás, y eyapø ñøyipø'is Silas. Jet más covi'najøta'mbø pøn entre tøvø'omda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Y chøjcayaj carta va'cø nø myajṉayaj Pablo'is y Bernabe'is. Yøcse jyajyayaju: “Øjta'm apostolesta'm y tzambønda'm y tøvøta'm ⁿyuschi'ta'mbøjtzi tøvøta'm lo que ji'ndyet Israel pønda'm ityajupø Antioquía cumgu'yomo y Siria nasomo y Cilicia nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mandamba øjta'm que eyata'mbø tzu'ṉyajupø'is øjtzomda'm jujchese mi ⁿyac tuctamba mi ndzocoy eyapø anma'yocuji'n; pero ja øtz ngø'vejtam je pøn. Je nømyajpa que tiene que va'cø mi yac seña'øtyandøj mi ⁿvin Israel pø'nis syeñaji'ṉ, y va'cø mi ngo'aṉjamdam Moisesis 'yangui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Por eso cuando mumu tzø'tyam tumbø quipsocuji'ṉ, vø'møtyam øjtzi va'cø ṉgøpiṉdam pøn, y va'cø ṉgø'vejayaj mitzcøsi je pøn Bernabé y Pabloji'ṉ. Bernabé y Pablo ndø sundambapø. ");
INSERT INTO zosNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ja tyoya'ṉøyaj vyin maṉyaj tø na'tzpamø ijtumø sunbapø'is yaj ca'yajø ndø Comi Jesucristocøtoya. ");
INSERT INTO zosNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jetji'n ṉgø'vejta'mbøjtzi Judas y Silas va'cø mi nchajmatyam ijtuse cartacøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Porque vyø'møy Masanbø Espiritu Santo'is y øtz vø'møndyaṉgue'tuti'tzi que va'cø jana mi ndzi'tam eyapø aṉgui'mguy va'cø mi ngø'aṉjamdamø. Namas que yøcse va'cø mi ndzøctamø: ");
INSERT INTO zosNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","va'cø jana mi ngø'stam ni tiyø yac yostøjupø comi chøqui cøna'tzø'ocu'yomo, va'cø jana mi vi'ctam nø'pin, y va'cø jana mi vi'catyam mo'jca'tøjupø'is syis, y va'ca jana mi møtzi nø'it yomo. O'ca yøcsepø tiyø mi ṉgo'aṉjamdambati, vøjti mi mbyujtamba. Mi ṉgø'vejatya'møjtzi dyus”. ");
INSERT INTO zosNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Asi es que je cø'vejyajtøjupø maṉyaj Antioquía cumgu'yomo. Yac tu'myaj vøtipø vya'ṉjajmyajpapø'is Jesús va'cø chi'ocuyaj carta. ");
INSERT INTO zosNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Cuando tyu'ñaju'jcam carta, cajsøyaju porque carta'is chambase yac tzø'yaj contento. ");
INSERT INTO zosNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas y Silas musque'tpatina'ṉ tza'maṉvajcoyajø. Vøtipø oteji'ṉ chi'yaj consejo va'cø vya'ṉjajmoyaj vøjø. ");
INSERT INTO zosNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ya'yujcam some jama jiṉø, va'ṉjajmocuy tøvø'is 'yo'nøyu tzacyaju va'cø vitu'yaj contento apostolescø'mø. ");
INSERT INTO zosNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero Silasis qui'psu que vøjø va'cø chø'y jiṉø Antioquía cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo y Bernabé o'i'ñaj Antioquía cumgu'yomo, aṉma'yoyajpana'ṉ y chajmayajpana'ṉ ndø Comi's vøjpø 'yote, y vøti eyata'mbø'is chajmayajque'tuti 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ijtu'cam vøti jama Pablo'is ñøjay Bernabé: ―Tø maṉdyaṉgue'ti va'cø ndø tu'nistam ndø tøvøta'm mumu cumguñamaye jutita'mbø'omo oy ndø tza'maṉvajcatyam ndø Comi's 'yote. Tø maṉdya'i va'cø ndø a'mistam jujche ityaju. ");
INSERT INTO zosNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabe'is syunbana'ṉ ñømaṉ también Juan ñøyipø'isque't Marcos. ");
INSERT INTO zosNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pero Pablo'is ja vyø'møyø va'cø ñømaṉ Marcos, porque Marcos oyumna'ṉ tzu'ṉ jetecø'mda'm cuando Panfilia nasomo ityaju. Jicsye'øc Marcosis ja syunø'am maṉ pya'tyaj Pablo y Bernabé va'cø seguitzøc yoscuy. ");
INSERT INTO zosNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tanto onguipyaj ñe'comda'm Pablo y Bernabé, y al fin ne' ne'ti maṉyaju. Bernabé'is pyøc Marcos y maṉyaj barco'omo va'cø ñu'cyaj Chipre cucnasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pero Pablo'is cyøpiṉ Silas y tzu'ṉyaju va'cø myaṉyajø. Tyøvø'sta'm 'yo'nøyu tzacyaju va'cø myaṉyaj Diosji'ṉ, va'cø cyotzoṉyaj Diosis ñe'c vyø'ajcupit. ");
INSERT INTO zosNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Jetse maṉyaju y vijtocøtpøyaj Siria nasomo y Cilicia nasomo, chajmayajpana'ṉ tu'myajpapø ndø Comi's ñøyicøsi va'cø vya'ṉjajmoyaj vøjø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo nu'c Derbe cumgu'yomo y Listra cumgu'yomo. Ijtuna'ṉ jeni tum pøn 'yaṉmayu'is Diosis 'yote ñøyi Timoteo, va'ṉjajmopyapø Israel yomo'is 'yune. Y jyata ji'ndyet Israel pøn. ");
INSERT INTO zosNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Vyøcotzøcyajpana'ṉ Timoteo vya'ṉjajmocuy tyøvø'sta'm ityajupø Listra y Iconio cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo'is nømna'ṉ syun ñømaṉ Timoteo, y yac sena'øtyøj Timoteo Israel pø'nis syeñaji'ṉ; porque ityaj Israel pønda'm jicø lugajromo y mumu myusayaj jyata que ji'ndyet Israel pøn. ");
INSERT INTO zosNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Y mientras cøtyajpana'ṉ cumguñamaye, Pablo'is y Silasis chajmayajpana'ṉ va'cø cyo'aṉjamayaj ti chamyajuse apostolesis y tzambø'nis Jerusalén gumgu'yomo ityajupø'is, como vyø'møyajuse cuando oy tu'myaje. ");
INSERT INTO zosNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jetsemete tu'myajpapø pømipøcyaj vya'ṉjajmocu'yomo, más vøti'ajyaj tumdum jama vya'ṉjajmyajpapø'is Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Entonces cøtyaj Frigia y Galacia nasomo, y ya'inducyaj Masanbø Espiritu'is va'cø jyana tzamyaj ote Asia nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Y cuando nu'cyaj Misia nasomo, qui'psyaju va'cø myaṉyaj Bitinia nasomo, pero Jesusis 'Yespiritu'is ja yac maṉyaj jiṉø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Entonces cøtyaj Misia nasomo y mø'ñaj Troas cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Y jeni tzu'i Pablo'is is pøn como si fuera napasyi'omuse. Jenna'ṉ te'n Macedonia cumgupyøn je'is vyi'naṉdøjqui. Je pø'nis ñøjay Pablo: “Min Macedonia nasomo y mi tø cotzoṉdam øjtzi”. ");
INSERT INTO zosNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Cuando is jetse, entonces nøjcoje'csøtya'møjtzi va'cø maṉdam Macedonia nasomo. Porque ṉgoqui'psta'møjtzi viyuṉsye que vejatya'møjtzi Diosis va'cø maṉ ndza'maṉvajcatyam vøjpø ote jiṉda'mbø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Entonces tzu'ṉda'møjtzi Troas cumgu'yomo y maṉdyam barco'omo nu'ctam viyuṉdi Samotracia cucnasomo, y jyo'pitpø jama nu'ctam Neápolis cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Y desde jiṉø o'yø maṉdyam Filipos cumgu'yomo. Jete más covi'najøpø cumguy jiṉø Macedonia nasomo. Ityaj Roma cumgu'yomda'mbø viti jiṉø y como Roma cumgusye it aṉgui'mguy. Jen o'yø ya'tam usaṉ hora. ");
INSERT INTO zosNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Y sapøjcuy jama'omo øtz pujtam øjtzi cumguy acapoya nø'aṉvini jujna'ṉ ṉgomo'tyam øjtzi o'ca tu'mnømuse va'cø 'yo'nøyaj Dios. Jenna'ṉ ityaj yomo tu'myajupø y po'csta'møjtzi vejvejnetya'møjtzi jetji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ijtuna'ṉ tum yomo ñøyipø'is Lidia, mya'ajpapø'is tzapaspø tucu finopø, Tiatira cumgu'yombø, cyøna'tzøpya'is Dios. Yø'nis nømna'ṉ myanu y ndø Comi'is chi' qui'psocuy va'cø cyøma'nøjay mø'chøqui lo que nø cha'maṉvajcuse Pablo'is. ");
INSERT INTO zosNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jet o nø'yøy fyamiliaji'ṉducu, y entonces nømgomø'natya'møjtzi va'cø tøjcøtyam tyøjcomo. Nøjatya'møjtzi: ―O'ca mi ṉgui'pstamba que øtz viyunsye va'ṉjambapø chøn ndø Comi, entonces tøjcøtyam ø ndøjcomo jen va'cø mi ⁿjyejtamø. Y penatzøcta'møjtzi va'cø tøjcøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Y tujcu que nømna'ṉ maṉdam øjtzi 'yo'nøyajpamø Dios, y ndzoṉda'mø papiñomo ñøc ijtøyupø yatzi'ajcu'is, muspapø'is chamø jujche maṉba tucnømi. Yø'nis vøti yac tøjcøpyana'ṉ tumin cyomicøtoya cuando chamba ti maṉba tuqui. ");
INSERT INTO zosNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Øtz nømna'ṉ maṉdam Pabloji'n y min je yomo ø ⁿjøsmøta'm y veju, nømu: ―Yøṉ pønda'm møjipø Diosis chøsita'm. Yø'ṉis tø tzajmatyamba jujche muspa tø cotzoctamø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Jetsena'n chøcpa vøti jama. Tantosna'n jyorvatzøcpa Pablo y al fin cyøque'naj vitu'u y ñøjay yatzi'ajcuy: ―Øtz angui'mba Jesusis ñøyicøsi, put je papiñomo'is choco'yomo. Y misma horacøs pujtu y chac je papiñomo. ");
INSERT INTO zosNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero cuando isyaj papiñomo'is cyomi'is que ji'n mus ñøput tumin, entonces ñucyaj Pablo y Silas y ñømaṉyaj plaza'omo aṉgui'mbapøcø'mø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Cuando nu'cyaj aṉgui'mbacø'mø, ñøjayaju: ―Yøṉ Israel pø'nis nø yac so'natejyaj ndø cumguy tøvø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Je'is chamboyajpa eyata'mbø costumbre lo que tø øtz ji'n mus ndø pøjcøchoṉdamø, ni ji'n mus ndø tzøctam tø øjtzi, siendo que tø øtz tø romano pønda'møṉø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Y vøti pø'nis qui'sayaj apostolesta'm y aṉgui'mbapø'is aṉgui'myaju va'cø yac tzacyajtøj tyucu y va'cø ñacsyajtøj cupit. ");
INSERT INTO zosNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nacscøtzictzicvøyaju y cyotyaj preso'omo. Aṉgui'myaj aṉbocsupø'is preso va'cø mø'chøqui cyoqueñajø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Cyoquenbapø'is preso pyøjcøchoṉ aṉgui'mdøjuse, y cyotyaj más jojmopo preso cuarto'omo, y tabla sutø'omo myatztøjcøyaj cyoso va'cø jyana putyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pero paṉguctzu'sye'ṉomo nømna'ṉ 'yo'nøyaj Dios Pablo'is y Silasis y nømna'ṉ vyajnayaj Dios, y eyata'mbø preso'omo ityajupø'is myañaju. ");
INSERT INTO zosNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Y joviti cøt pømipø nasamicscø. Pømise mics so'mocuy hasta jojmocsye'ṉomo. Y jicsye'cti mumu aṉdyuṉ aṉvacpø'yaju y pucsaṉvacyaj mumu cadena vatyajupøji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Cuando min mø'ndonsa' nø cyoquenupø'is preso, entonces isu que aṉvacyaj so'mocu'is 'yandyuṉ. Por eso ñøput 'yespada maṉbana'ṉ yaj ca' vyin, como'yu o'ca preso poyajuse. ");
INSERT INTO zosNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero Pablo'is vyejay pømi ñøjayu: ―Ni ti u mi ndzøjcay mi ⁿvin; yø'c tø ijta' øjtzi mumu. ");
INSERT INTO zosNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Y nø cyoquenu'is preso vya'c no'a; y poyu'c tøjcøy jojmo søtøtpa na'tze'is, cyønu'cyaj Pablo y Silas atzatzcøne'c je'tis cyosocø'mø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Entonces ñøputyaj Pablo y Silas a'ṉgomo y ñøjmayaju: ―Señores, ¿jujche vøj ndzøcø va'cø cotzoc ø ṉgojapit? ");
INSERT INTO zosNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Y je'tista'm ñøjayaju: ―Va'ṉjamdam ndø Comi Jesucristo y jetse maṉba mi ṉgyotzoctam ijtamuse mi ndøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Y chajmayaj Diosis 'yote cyoquenbapø'is preso y mumu ityajuse tyøjcomo. ");
INSERT INTO zosNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Y nø cyoquenu'is preso ñømaṉyaj Pablo y Silas misma hora tzu'cøsi y cyøtze'ayaj yaje. Y jicsye'cti nøyøy ñe'cø y mumu fyamiliaji'ṉducu. ");
INSERT INTO zosNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Jøsi'cam ñømanyaj møjmø tyøjcomo y chi'yaj cu'tcuy. Y casøyaj mumu fyamiliaji'n porque vya'ṉjamyaj Dios. ");
INSERT INTO zosNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Cuando min sønbø'nømi, cyø'vejyaj aṉqui'myajpa'is policía va'cø ñøjayajø: ―Sømbø'yaj jic preso. ");
INSERT INTO zosNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Y chajmayaj nø cyoquenu'is preso yøcsepø ote Pablo, ñøjayaju: ―Aṉgui'myajpapø'is cyø'vejyaj ote va'cø sombø'tamø. Yøti pues muspa mi myaṉdam contento. ");
INSERT INTO zosNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero Pablo'is ñøjayaj policía: ―Jovisyeti nacsta'møjtzi aunque i'is vyi'naṉdøjqui ja cyøme'tzta'møjtzi o'ca ijtam ø ṉgoja, y øtz romano pønda'm chøṉø. Por eso ji'n vyøj yøcse va'cø mi ndø nu'm nømbujtamø. Más vøjø va'cø miñaj ñe'c aṉgui'myajpapø va'cø nøpujtamø. ");
INSERT INTO zosNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Policia'is maṉ chajmayaj yøṉ ote aṉgui'mbata'm. Myañajujcam que Pablo y Silas romano pønda'mete, na'chajque'tuti aṉgui'mbata'm. ");
INSERT INTO zosNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Y mismo aṉgui'mbata'm nu'cyaj presocø'mø y vya'cayaj va'cø cyøtocoyajtøjø, y ñøjmayaju va'cø chacyaj cyumguy. ");
INSERT INTO zosNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Y putyaj preso'omo, maṉyaj Lidia'is tyøjcomo. Y jen 'yo'nøyaju va'ṉjajmocuy tyøvø y chajmayaju va'cø vya'njamyaj vøjø. Jetse tzu'ṉyaj Pablo y Silas. ");
INSERT INTO zosNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Cøtyajumna'ṉ Anfípolis cumgu'yomo y Apolonia cumgu'yomo, nu'cyaj Tesalónica cumgu'yomo. Jena'ṉ it Israel pøn tu'myajpamø. ");
INSERT INTO zosNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Chøcpaseti Pablo'is, tøjcøy jetji'ṉda'm. Y tu'cay sapøjcuy jama'omo cha'maṉvajcayaju jachø'yuse Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Cha'maṉvajcayaju y isindzi'yaju que jachø'yuse que Cristo tiene que va'cø toya'isø y va'cø visa'ø cuando ca'ujcam. Nøm Pablo: ―Yøn Jesús iyø otz nø ndzamgøpucsu, yøṉømete Cristo lo que Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Vene'ṉomo je'tista'm vya'ṉjajmyaju y tu'myaj Pablo y Silasji'ṉ. Ityajuna'ṉ vøti pøn lo que ji'ndyet Israel pøn pero cyøna'tzøyajpapø'is Dios y vya'ṉjajmyaju. Vøti covi'najøta'mbø yomo'is vya'ṉjajmyajque'tuti. ");
INSERT INTO zosNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pero ji'n vya'njajmoyajepø Israel pøn qui'syca'yaju, y yac tu'myaj yatzita'mbø pøn calle'om jargan vityajpapø, y jetji'ṉ tu'myaj vøti pøn y so'natejyaj cumguy. Nu'cyaj Jaso'nis tyøcmø y maṉbana'ṉ pyu'ṉaṉvac tyøc. Sunbana'n ñøputyaj Pablo y Silas cumgupyø'nis vyi'naṉdøjqui. ");
INSERT INTO zosNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pero como ja pya'tyaj jen Pablo y Silas, entonces jyøcøcøtøjcøyaj Jasón eyata'mbø va'njajmocuy tøvøji'ṉ y ñønu'cyaj cumgu'yombø aṉgui'mbacø'mø y vejaṉgøtyaju, cyøsujtzøyaju y nømyaju: ―Yøn yac tocojayajpapø'is vøjpø itcuy nasindumø'is ñe miñajque't yø'qui. ");
INSERT INTO zosNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Y Jaso'nis yac tøjcøyaj tyøjcomo. Pero mumu yøṉ pø'nis qui'sayajpa møja'aṉ aṉgui'mbapø Cesajris 'yaṉgui'mguy. Nømyajpa que it eyapø møja'aṉ aṉgui'mbapø ñøyipø'is Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Jetse yac so'natejyaj vøti pøn y aṉgui'mbata'm cuando cyøsujtzøyaju que ji'n cyøna'tzøyaj møjaṉ angui'mbapø César. ");
INSERT INTO zosNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pero chi'yaj tumin Jaso'nis y eyata'mbø'is, y jetse chøcøpø'yaju. ");
INSERT INTO zosNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jicsye'cti va'ṉjajmocuy tyøvø'sta'm tzu'cøsi yac maṉyaj Pablo y Silas va'cø myaṉyaj Berea cumgu'yomo. Cuando nu'cyaj jiṉø, tøjcøyaj Israel pøn tu'myajpamø. ");
INSERT INTO zosNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yøṉø tu'myajpapø'is ñø'oyaj más vøjpø chocoy que ji'n Tesalónica cumgu'yomda'mbø'is, porque pyøjcøchoṉjayaj ote vøjpø qui'psocuji'ṉ. Tumdum jama tyu'nme'chajpana'ṉ jachø'yupø Diosis 'yote, va'cø 'ya'myaj yøcsepø tiyø a ver o'ca viyuṉsepø tiyete. ");
INSERT INTO zosNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jetsemete vøti pø'nis vya'ṉjajmyaju. Vya'ṉjajmyaj vøti yomo'is lo que ji'ndyet Israel yomo'is lo que mumu cumgupyø'nis vyøcotzøcyajpapøna'ṉ, y vøti pø'nis lo que ji'ndyet Israel pø'nis vya'njamyajque'tu. ");
INSERT INTO zosNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Y myusyaj Tesalónica cumgu'yomda'mbø Israel pø'nis que jetsena'ṉgue't Berea cumgu'yomo chamgøpucsyaj Dios 'yote Pablo'is. Entonces Tesalónica cumgu'yomda'mbø maṉyaj jiṉø Berea cumgu'yomo y yac so'natejyaj cumgupyønda'm, qui'sayaj Pablo. ");
INSERT INTO zosNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Por eso yøti yøti vya'ṉjamyajpapø'is Jesús yac maṉyaj Pablo hasta ijtumø mar. Pero Silas y Timoteo tzø'yaj Berea cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Opø'is ñømaṉyaje oy chacpø'yaj Pablo hasta Atenas cumgu'yomo, y Pablo'is cyø'vejayaj ote Silas y Timoteo jiṉ va'cø myaṉyajque'tati pronto. Y jetse opø'is chacpø'yaj Pablo vitu'yajque'tu. ");
INSERT INTO zosNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mientras nømna'ṉ jyo'cyaj Pablo'is Atenas cumgu'yomo, 'ya'mu que tas cumguy comi chøquiji'ṉ, y maya'u y qui'syca'u choco'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jetsemete Pablo'is 'yo'nøyaj Israel pønda'm tu'myajpamø y 'yo'nøyajque't eyata'mbø cyøna'tzøyajpapø'is Dios. Y tumdum jama 'yo'nøyajpa jutipø pøn pyatpa plaza'omo. ");
INSERT INTO zosNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ityajuna'ṉ jeni pøn qui'psocu'yoyuse chøcpa'is vyin, veneta'mbø 'yaṉmayajpapø'is epicúreo aṉma'yocuy; y veneta'mbø 'yaṉmayajpapø'is estoico aṉma'yocuy. Je'tis 'yo'nøyaj Pablo. Tum nømbana'ṉ: ―¿Ti sunba cham yø'nis y ongomø'nba? Eyapø nømbana'ṉ: ―Parece que nø chamboy eyata'mbø Dios ji'n ndø mañajepø nunca. Jetse nømyaju porque Pablo'is chambana'ṉ Jesusis 'yote, y chambana'n que it visa'cuy. ");
INSERT INTO zosNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Entonces ñømaṉyaj Pablo lugajromo ñøyipø'is Areópago opamøna'n tu'mnømi. Y ñøjayaj Pablo: ―Tø tzajmatyam ndøvø, ¿tiyø'ṉ yøṉ jomepø aṉma'yocuy lo que mitz nø mi ndzamupø? ");
INSERT INTO zosNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Porque øjta'm manda'møjtzi ji'n ndø ṉgøñøctøyøyitamepø tiyø mitz ndzambase. Su'nba mustam tiyøṉ yøṉø. ");
INSERT INTO zosNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Jetse nømyaju porque Atenas cumgu'yomda'mbø'is, y eyata'mbø cumgu'yomda'mbø'is jejyajpapø'is jiṉø, más que ni jutipø tiyø sunbana'ṉ chamyajø y cyøma'nøyajø lo que ja myañajøpøtøc tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Entonces Pablo te'nu Areópago cujcomo y nømu: ―Mi Atenas cumgupyø'nista'm; øtz tzi'pa cuenta que mitz vøti mi jamdamba mi va'ṉjajmoṉgutya'm. ");
INSERT INTO zosNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Porque cuando nømna'ṉø cøt calle'omo, ⁿisø mitz ṉgonocstambamø, y mba't tum altar ijtupøcøs jachø'yupø: “Yøṉete altar ji'n ndø comusipø Diosis señe”. Pues øtz nø mi ndza'maṉvajcatyam yøti jic Dios mi ṉgøna'tzøtyamba sin que ji'n mi ṉgomustamepø. ");
INSERT INTO zosNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","”Jiquete Dios lo que chøjcupø'is tzap y nasacopac y mumu tiyø lo que ti ijtupø tzajpomo y nascøsi. Como nas y tzap Diosis señe, Diosis ni ji'n ñøc'ijtøy masandøc pø'nis chøjcupø cyø'ji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ni jujche ji'n mus ndø cotzoṉ Dios ndø cø'ji'ṉ, porque ni ti'is ji'n chøjcay falta. En cambio ñe'c tø tzi'pa ndø quenguy y tø yac je'pøcpa. Mumu ti tø tzi'pa Diosis. ");
INSERT INTO zosNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","”Y Diosis chøc mumu pøn tumbø nø'pin døvø va'cø ñøc ijtøpø'yaj mumu nasacopac. Ñe'c vi'nati qui'psminu jujchøcpø tiempo'omo y jutipø lugajromo maṉba tø ijtam nascøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Jetse chøc Diosis va'cø ndø quipsme'tztam ñe'cø, y va'cø ndø qui'psisø a ver o'ca ndø mba'tpa Dios. Porque viyuṉse Dios ji'n ya'i, tome it tumdum pø'nis vyi'nomo. ");
INSERT INTO zosNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Porque je'tis tø yaj quendamba, tø yac micstamba, y tø yac ijtamba. También veneta'm mijtzom jayajpapø'is nømyajque'tuti jetse. Nømyaju: “Porque también tø øjtzi Diosis tø 'yuneta'm”. Jache'ṉomo jyayaju; y øtz nømgue'tpøjtzi: ");
INSERT INTO zosNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Siendo que Diosis tø 'yuneta'm, ji'n mus tø qui'pstamø que Dios oropøte o platapøte o tza'pøte. Porque jetseta'mbø, pø'nis chøcyajpa segun lo que jujche ñe' qui'psyajpase. ");
INSERT INTO zosNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Pero cøjtupø tiemp'omo cuando ji'na'ṉ myusyaje'øc jujchepøt Dios, Diosis jetse yac tzø'yaju. Pero yøti Diosis nø 'yaṉgui'myaj mumu pøn mumu nasvindumø va'cø qui'psvitu'yajø. ");
INSERT INTO zosNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Porque Diosis cyoqui'psu'am jujchøcpø jama ñe'c maṉba cyøme'chaj vøjø mumu pøn cyojapit. Y Diosis cyojtu'am jic pøn jutipøji'n manba cøme'tzoye; y yac musyaj viyuṉsye mumu pøn iyete, porque yac visa'u cuando ca'u. ");
INSERT INTO zosNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Cuando mañaju que oy visa' ca'upø pøn, vene'aṉbø'nis syijcayaju: eyata'mbø nømyajque'tu: ―Sunba ṉgøma'nøvøjøtzøctaṉgue'tati yøcsepø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Entonces Pablo tzu'ṉ je'tomda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pero veneta'mbø'is maṉ pya'tyaj Pablo y vya'ṉjamyaju. Entre ñe'comda'm ijtuna'ṉ Dionisio, aṉgui'mbapø pønete Areopago'omo; tum yomo ñøyipø'is Dámaris; y jetseti eyata'mbø maṉ pyatyaj Pablo. ");
INSERT INTO zosNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Cøjtujcam yøcsepø tiyø, Pablo tzu'ṉ Atenas cumgu'yomo y maṉ Corinto cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Y pya't tum Israel pøn ñøyipø'is Aquila, pø'najupø Ponto cumgu'yomo, nu'cupøtøquete Corinto cumgu'yomo. Oy tzu'ṉ Italia nasomo. Jetji'ṉna'ṉ it yomo Priscila. Tzu'ṉyaj Italia nasomo porque møja'aṉ aṉgui'mbapø Claudio'is 'yaṉgui'myaj mumu Israel pøn va'cø chu'ṉyaj Roma cumgu'yomo. Pablo'is cyønu'cyaj Aquila y Priscila. ");
INSERT INTO zosNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Como mismo yoscuy myuspana'ṉ chøcyaj mye'chcøy Pablo'is y Aquila'is, Pablo tzø'y jetji'ṉ y yosyaj tu'mbac, porque jet yosyajpana'ṉ va'cø chøcyaj lonapø tøc. ");
INSERT INTO zosNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Y Pablo'is cha'maṉvacpana'ṉ ote tu'myajpamø Israel pøn tumdum sapøjcuy jama'omo, chajmayaj vøjpø ote hasta que yac pøjcøchoṉyaju, yac tøjcøyaju vya'ṉjajmocu'yomo, aunque sea Israel pøn, aunque sea ji'ndyet Israel pøn. ");
INSERT INTO zosNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Cuando nu'cyajujcam Silas y Timoteo tzu'ṉyajupø Macedonia nasomo, Pablo nømna'ṉ yosco'n oteji'n, nømna'ṉ chajmayaj Israel pønda'm que Jesusete Cristo Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Cuando Israel pø'nis qui'sayaj Pablo y Jesuscøsi topo'o'nøyajpana'ṉ, Pablo'is cyøtit tyucu como seña que ñe'c ja it cyoja, y ñøjmayaju: ―O'ca mi ndyocotyamba, mismo mi ne'cta'mdi ijtam mi ṉgoja; øtz limpioti'tzi. Desde yøti ma'ṉbø eyapø pøngø'mda'm lo que ji'ndyet Israel pøngø'mda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Y tzu'ṉ jeni maṉ ñøyipø'is Justo'is tyøjcomo cyøna'tzøpapø'is Dios ijtumna'ṉ tyøc tome tu'myajpamø Israel pøn. ");
INSERT INTO zosNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Tu'myajpamø ijtuna'ṉ aṉgui'mbapø ñøyipø'is Crispø. Je'is vya'ṉjam ndø Comi mumu fyamiliaji'ṉ, y vøtipø Corinto cumgu'yomda'mbø'is myañajpana'ṉ ote, vya'ṉjajmyaju y nø'yøyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Y napasyi'omse ndø Comi'is ñøjay tzu'cøsi Pablo: ―Uy ña'tze, más tza'maṉvajcaṉøjayaj ø onde. U mi vyøṉbø'u. ");
INSERT INTO zosNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Porque øtz yø'cø it mitzji'n. Ni i'is ni ti ji'n ma mi ñchøjcayaje, ni i'is ji'n maṉ mi ⁿyacsutzøqui, porque øtz nø'ijtøjtzi vøti pøn yøṉ cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Oy ya'e jiṉø tumø ame medio; 'yaṉma'yopyana'ṉ Diosis 'yoteji'ṉ je'tomo. ");
INSERT INTO zosNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Cuando Galión aṉgui'mbana'ṉ Acaya nasomo, Israel pø'nista'm tumbø qui'psocuji'ṉ ondu'mbajcajyaju va'cø ñucyaj Pablo y ñømaṉyaj aṉgui'mbapø'is vyi'nomo. ");
INSERT INTO zosNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Nømyaju: ―Yø'nis 'yaṉmayajpa pønda'm, ñøjayajpa va'cø vya'ṉjajmyaj Dios pero ji'ndyet como ijtuse jachø'yupø aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Cuando Pablo'is maṉbana'ṉ chamdzo'tze, Galio'nis ñøjayaj Israel pønda'm: ―Mi Israel pø'nista'm, o'ca chøcpana'ṉ yø'ṉis ji'n vyøjpø tiyø, o sea yatzitzoco'yajcuy, vøjna'ṉ va'cø øtz mi ngøma'nøtyamø. ");
INSERT INTO zosNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pero como mitz ṉgøtza'møtyamba yøṉ pøn que eyapø ote y eyata'mbø nøyi nø chamu, y mi ne aṉgui'mgutya'm nø cyacpø'u; a'mdam mi ne'cta'm ti mi ndzøctamba. Porque øtz jin sun vøjøndzøc jetsepø asunto. ");
INSERT INTO zosNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Y myacpø'yaj mumu ityajupø jeni 'yaṉgui'mgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Jicsye'cti mumu griego pø'nis ñucyaj Sóstenes, aṉgui'mbapø Israel pø'nis tu'mguy tøjcomo, y ñacsyaju tome aṉgui'mbacø'mø, pero Galio'nis ni ja chøjcay cuenda lo que ti nø chøcyajupø. ");
INSERT INTO zosNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Y Pablo tzø'y ya'i jama jiṉø, y jicsyejcam 'yo'nøyu tzacyaj Pablo va'ṉjajmocuy tyøvø'sta'm, y Pablo maṉ barco'omo nu'c Siria nasomo. Priscila'is y Aquila'is maṉ pya'tyaj Pablo. Oy Pablo co'tzima ju's Cencrea cumgu'yomo, porque ijtuna'ṉ tiyø oyupø chamdzi' Dios, por eso o co'potz ju'si. ");
INSERT INTO zosNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Jetse nu'cyaj Efeso cumgu'yomo, y Pablo'is chacyaj Priscila y Aquila jiṉø. Y Pablo tøjcøy Israel pøn tu'myajpamø y vejvejneyaju jetji'ṉda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Jiṉda'mbø'is ñøjajo'yaju va'cø ya'yø jitji'ṉda'm, pero Pablo ja syun chø'yø. ");
INSERT INTO zosNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Yuschi'u tzacyaj jejta'm y ñøjmayaju: ―De toda manera tiene que va'cø øtz it Jerusalén gumgu'yomo nø minupø søṉgøtoya. Pero matøc vitu'que't mijtzomda'm o'ca Diosis syunba. Y barco'omo tzu'ṉ Pablo Efeso cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Y nu'c Cesarea cumgu'yomo. Y de jeni maṉ Jerusalén gumgu'yomo y yuschi'yaj vya'ṉjajmocuy tyøvøta'm, y después mø'n Antioquía cumgu'yomo. ");
INSERT INTO zosNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Oy ya'e usy jama jiṉø, y tzu'ṉgue'tu. Y cyøjtocpacpø'u ijtnømu'csye'ṉomo Galacia nasomo y Frigia nasomo. Chajmayaj mumu vya'ṉjamyajpapø'is Jesús va'cø vya'ṉjamyaj más mø'chøqui. ");
INSERT INTO zosNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nu'c Efeso cumgu'yomo tum Israel pøn ñøyipø'is Apolos. Apolos tzojcupø Alejandría cumgu'yomo, muspana'ṉ cha'maṉvajcoy vøjø, y suñina'ṉ cønøctøyøjayu jachø'yuse Diosis 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Yø'nis o 'yaṉmay ndø Comi'is 'yaṉma'yocuy. Y como tum chocoy va'ṉjajmopyana'ṉ, jetse chambana'n y 'yanma'yopyana'ṉ mø'chøqui ndø Comi'is 'yaṉma'yocuji'ṉ. Pero na myusuti Jua'nis nø'yø'ocuy. ");
INSERT INTO zosNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yøn Apolosis ñøcøtzo'tzu va'cø cham jana na'tzcuy tu'myajpamø Israel pøn. Jen cyøma'nøyaj Priscila'is y Aquila'is jujche nø cham Apolosis. Y después Aquila'is y Priscila'is ñømaṉyaj ne'ti Apolos y cha'maṉvajcayaj ta'nupø mø'chøqui Diosis tyuṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Y cuando Apolos nømna'ṉ sun myaṉ Acaya nasomo, entonces Efeso cumgu'yombø va'ṉjajmocuy tøvø'is chøjcayaj carta Acaya nasombø tyøvøta'm. Ñøjayaju va'cø pyøjcøchoṉyaj Apolos cuando nu'cpa jeni. Apolos nu'c Acaya nasomo y cyotzoṉyaj vøti jiṉda'mbø oyupø'is vya'njamyaj ndø Comi Jesús. Porque ityajuna'ṉ jeni oyupø'is vya'ṉjamyaj ndø Comi; Diosis vyø'ajcupit o vya'ṉjamyaje. ");
INSERT INTO zosNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolosis cha'maṉvajcayaj møja'aṉ qui'psocupit, y yac musyaju mumu pø'nis vi'nomo que Israel pø'nis vya'ṉjajmocuy ji'ndyet vyøjpø. Jachø'yupø Diosis 'yoteji'ṉ yac musyaju que Jesusete Cristo Diosis cyø'vejupø. ");
INSERT INTO zosNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mientras que ijtuna'ṉ Apolos Corinto cumgu'yomo, Pablo emøc o cøt ijnømumø møjmø y nu'c Efeso cumgu'yomo y pya'tyaj jiṉ 'yaṉmayajpapø'is ndø Comi'is 'yote. ");
INSERT INTO zosNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pablo'is 'yaṉgøva'cyaju ñøjayaju: ―¿Oy mi mbøjcøchoṉdam Masanbø Espiritu Santo cuando mi va'ṉjajmdamu'øc? Pero je'tis ñøjmayaju: ―Pues ji'nø nø mandamu o'ca it Masanbø Espiritu Santo. ");
INSERT INTO zosNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Entonces Pablo'is ñøjayaju: ―Cuando mi ñø'yøndyamu, ¿jujchepø nø'yø'ocuy mi mbøjcøchoṉdamu? Y je'tis ñøjayaju: ―Jua'nis ñø'yø'ocuy. ");
INSERT INTO zosNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Y ñøjayaj Pablo'is: ―Viyuṉsye Jua'nis ñø'yøyaju como seña que qui'psvitu'yaju. Pero también chajmayaj pøn va'cø vya'ṉjamyaj maṉbapø mini jøsi'cam, jetemete Cristo Jesús. ");
INSERT INTO zosNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Cuando myañajujcam chamuse Pablo'is, oy ñø'yøyaje ndø Comi Jesusis ñøyicøsi. ");
INSERT INTO zosNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Entonces Pablo'is cyot cyø' jetcøsta'm y nu'c jetcøsta'm Masanbø Espiritu Santo. Y oñajpana'ṉ eyapø ote'omo nuṉcatøc ja 'yoñajøse, y tza'maṉvajcoyajpana'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ityajuna'ṉ como macvøstøjcaṉbønsye'ṉomo myumaṉgø'tya'm lo que nø'yøyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Entonces tøjcøy Pablo tu'myajpamø Israel pøn, y tu'cay poya oyu, o cha'maṉvajcayaj Diosis 'yote jana na'tzcuy, cha'mindzi'yaju jujche aṉgui'mbase Dios, va'cø vyø'møyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pero veneta'mbø'is ja syuñajø y ja vya'ṉjamyajø, y topa'o'nøyaj Diosis 'yaṉma'yocuy vøti pø'nis vyi'naṉdøjqui. Entonces Pablo tzu'n jetcø'mda'm nø 'yaṉmayajupø'ji'ṉ y tøjcøyaj Tirano'is tyøjcomo porque jen anmayoñømbana'ṉ. Y jen oy cha'mindzi'yaj ndø Comi'is 'yote tumdum jama. ");
INSERT INTO zosNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Metza ame o aṉma'yoy jetse. Por esomete mumu ityajupø'isna'ṉ Asia nasomo myajnayaj ndø Comi'is 'yote. Tanto Israel pø'nista'm, tanto ji'ndyet Israel pø'nista'm cyøma'nøjayaju. ");
INSERT INTO zosNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Y Diosis chi' Pablo musocuy va'cø chøc milagro'ajcuy y ji'n ndø isipø tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Hasta payu y tucu oyupø Pablo'is vyingøsi ñømaṉyaju y cyotyaj ca'epøcøsi. Entonces tzocyaj ca'eta'mbø, y yatzi'ajcuy putyajpana'ṉ je'tomda'm. ");
INSERT INTO zosNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Y ityajuna'n vityajpapø Israel pøn ñøputyajpapø'is yatzi'ajcuy. Y veneta'mbø je'is chøjquisjo'yaju va'cø chajmay Jesusis ñøyi pøngø'mø ijtupø'omo yatzi'ajcuy va'cø pyutø, ñøjmayaju: ―Mi aṉgui'mba Jesusis ñøyicøsi lo que Pablo'is chambo'papø va'cø mi mbyutø. ");
INSERT INTO zosNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ijtuna'ṉ tum Israel pøn pane covi'najø ñøyipø'is Esceva. Cu'yayna'ṉ it Esceva'is 'yune. Y je cu'yapyø Esceva'is 'yune'is chøjquisjo'yaju jetse va'cø ñøputyaj yatzi'ajcuy. ");
INSERT INTO zosNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pero 'yaṉdzoṉ yatzi'ajcu'is ñøjayaju: ―Jesús ispøcpøjtzi. Y muspøjtzi iyete Pablo. Pero mijta'm, ¿inda'mete? ");
INSERT INTO zosNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Y pøn yatzi'ajcu'is ñøc ijtøyupø, je'is ñøquipyaj pøn nø syunupø'isna'ṉ nøputyajø, y tøpnu'cyaj jetcøsta'm y cyønu'cayaju y yac poyeputyaj tøjcomo nicotacsyita'mbø y yacsutzøcyajtøjupø. ");
INSERT INTO zosNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Y mumu ityajupø'is Efeso cumgu'yomo, tanto Israel pø'nis, tanto ji'ndyet Israel pø'nis, oy myusyaj ti ose tuqui, y o na'chaje mumu jejta'm y vyøcotzøcyajpana'ṉ ndø Comi Jesusis ñøyi. ");
INSERT INTO zosNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Y vøti pøn vya'njamyajpapø'is Jesús tu'myaju y chamyaju lo que tiyø yatzitzoco'yajcuy chøcyajpana'ṉ vi'na. ");
INSERT INTO zosNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Y vøti chøcyajpapø'isna'ṉ brujo'ajcuy ñønucyaj brujo libro; pyoṉbø'yaj mumu pø'nis vyi'naṉdøjqui. Nøputyaj cuenta jujchena'ṉ valetzøcpana'ṉ libro, y put cincuenta mil platapø tumin valetzøcyajpa. ");
INSERT INTO zosNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Jetse vøti pø'nis cyøma'nøjayaju y pyøjcøchojṉayaj ndø Comi's 'yote; y jetse pømi o yos ndø Comi 'yoteji'ṉ. ");
INSERT INTO zosNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Cøjtu'cam yøcsepø tiyø, qui'psmin Pablo'is choco'yomo va'cø myaṉ Jerusalén gumgu'yomo. Pero vi'na sunbana'ṉ vijtocøtpø' Macedonia nas y Acaya nas. Nømu: ―Después oyu'ca'mtzi Jerusalén gumgu'yomo, Roma cumguy nø'ø sun a'misto'que'ta. ");
INSERT INTO zosNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Entonces oy cyø'vejyaj Macedonia nasomo metzcuy oyupø'is cyotzoṉyaje, tum ñøyipø'is Timoteo y tum ñøyipø'is Erasto. Mismo Pablo oyutøc ya'ye Asia nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Jic jama'omo oy maya'aṉ so'natejcuy, o qui'sayaj jetsepø aṉma'yocuy ñøtu'ṉajyajpa'is. ");
INSERT INTO zosNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Porque ijtuna'ṉ tum pøn ñøyipø'is Demetrio, plataji'ṉ yospapø. Yospa tyøvøji'ṉ je'is chøcyajpana'ṉ che'pø masandøc tzøqui, chøjcaṉgøpujtøjayajpana'ṉ Diana'is myasandøc. (Diana yomopø cyomi tzøquite.) Je masandøc tzøqui mya'ayajpana'ṉ y gyanatzøcyajpana'n vøti tumin. ");
INSERT INTO zosNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrio'is vyejtu'myaj ñe'cji'n yosyajpapø, y ne'ti yosyajpapø pero mismo yoscu'yomo. Ñøjayaju: ―Mbyønda'm, mustamba mijtzi que yø'csepø yoscuy va'cø ndø tzøcø, ndø ganatzøcpa vøti tumin. ");
INSERT INTO zosNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nø mi istamuse y mandamuse jujche chøcpase yøṉ pø'nis ñøyipø'is Pablo; que ji'n solo Efeso cumgu'yomo, pero casi mumu Asia nasomo, yøṉ Pablo'is yac tzacyajpa va'ṉjajmocuy vøti pøn. Nømba que ji'ndyet ndø comi lo que ndø tzøctambapø ndø cø'ji'n. ");
INSERT INTO zosNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Por eso it peligro'ajcuy maṉba ocyaj yøṉ ø ⁿyoscutya'm, y tø na'tztamba que maṉba myenos chøcyajque'tati møja'aṉ yomopø ndø comi Diana'is myasandøc; aunque cyøna'tzøyajpa Diana mumu Asia nasomda'mbø'is y mumu nasvindumøta'mbø'is. Pero jetse maṉba yaj je'is myøja'ṉo'majcuy. ");
INSERT INTO zosNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Jetse myañaj chamuse Demetrio'is y vøti qui'syca'yaj plata yosyajpapøji'ṉ, vejyaju nømyaju: ―Myøja'ṉombøte Diana Efeso cumgu'yombø'is ñe'ta'm. ");
INSERT INTO zosNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Jetse tumø cumguy so'natejyaju, ñucyaj Caiyo y Aristarco, Macedonia nasomda'mbø, Pablo'is ñøtuṉda'm, y ñømaṉyaju. Tumøpø qui'psocuji'ṉ poyetøjcøyaju opamø tu'mnømi. ");
INSERT INTO zosNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo'is sunbana'n tyøjcøy vøti pø'nomo, pero vya'ṉjajmocuy tøvø'is ja yac tøjcøyajø. ");
INSERT INTO zosNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ityajuna'ṉ Pablo'is 'yamigota'm Asia nasomda'mbø covi'najø. Je'is cyø'vejay ote va'cø jyana tøjcøy Pablo vøti pø'nomo. ");
INSERT INTO zosNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Eyata'mbø vejyaju que yø'cse chøc ji'quis, eyata'mbø vejyaju que ji'ndyet jetse; jetse suniti vejaṉgøtyaju, casi mumu ji'na'n myusyaj ticøtoya nø tyu'mnømu. ");
INSERT INTO zosNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Entonces Israel pø'nis myatz tøjcøyaj Alejandro va'cø te'n vøti pø'nis vyi'nomo, va'cø chamø ti nø syun man chamø. Alejandro'is chøc seña cyø'ji'ṉ va'cø yac vøṉneyajø, ");
INSERT INTO zosNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pero cuando myusyaj Alejandro que Israel pønete, (como Israel pø'nis ji'n vya'ṉjamyaj Diana, por eso) mumu vejaṉgøtyaj tome metza hora, tu'mbac vejyaju nømyaju: ―Myøja'ṉombøte Diana Efeso cumgu'yombø'is ñe'ta'm. ");
INSERT INTO zosNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Al fin secretario'is yac vøṉneyaj vøti pøn y nømu: ―Efeso pø'nista'm, mumu pø'nis myusyajpa que mi Efeso cumgu'yomda'mbø'is mi ṉgüendatzøctamba myøja'ṉombø Diana'is myasandøc, y je'is chøqui lo que quejcupø nasomo tzajpom tzu'ṉupø. ");
INSERT INTO zosNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Como ni i ji'n mus nømø que ji'ndyet jetse, sunba va'cø mi vyøṉnendyamø, va'cø jana mi ⁿjyovindzøctam ni tiyø. ");
INSERT INTO zosNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Porque nø mi nømindam yøn pøn que ji'n ñu'myaje'is tumin masandøjcomo, y ni ji'n cyø'o'nøyajepø'is yomopø mi ⁿdios. ");
INSERT INTO zosNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","O'ca Demetrio'is y jetsepø yoscuy chøcyajpapø'is sunba cyøva'cøyaj aunque iyø, pues jetcøtoya it jut va'cø mi ṉgøvacøtyamø. Ityaj atcani jen va'cø ndø cøtza'møtyamø. ");
INSERT INTO zosNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","O'ca it eyapø asunto, entonces sunba va'cø mi ñdyu'mdamø jujche ijtuse aṉgui'mguy. ");
INSERT INTO zosNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Porque muspa tø cøtza'møtyandøjø omø syo'natejnøm yøti; porque ji'n mus tø andzo'ṉoya ticøtoya o tø tu'mdam jetse. ");
INSERT INTO zosNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Cuando jetse nømujcam, nømu que cøjtum tu'mguy. ");
INSERT INTO zosNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Cuando vøṉgajpø'yaj nøsyo'natejyajupø, Pablo'is vyejayaj vya'ṉjajmyajpapø'is Jesús y pyømitzi'yaj 'yotepit. Jyotzpøjcu tzacyaju y tzu'ṉu va'cø myaṉ Macedonia nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ocvitpø' jic lugar, y vøti chajmayaju jujche va'cø vya'ṉjajmoyajø. Y entonces maṉ Grecia nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Y oy it jiṉø tu'cay poya. Maṉbana'ṉ maṉ barco'omo Siria nasomo, pero myusu que nø jyo'cyaj Israel pø'nista'm va'cø ñucyajø. Por eso qui'psminu que más vøjø va'cø vitu'que'tati va'cø cyøt Macedonia nasomo. ");
INSERT INTO zosNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Y maṉ pya'tyaj Pablo hasta Asia nasomo Berea cumgu'yombø Sopatejris, y Tesalónica cumgu'yomda'mbø'is Aristarco'is y Segundo'is; Derbe cumgu'yombø Gayo'is, y Timoteo'is; y Asia nasamda'mbø'is Tiquico'is y Trofimo'is. ");
INSERT INTO zosNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yøṉda'm vi'na nu'cyaj Troas cumgu'yomo y jo'cta'møjtzi jiṉø hasta que nu'cta'møjtzi. ");
INSERT INTO zosNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Cøjtujcam søṉ cuando cyø'støjpamø pan ja pyoṉoṉapø, øjta'm tzu'ṉdam Felipos cumgu'yomo va'cø maṉdam barco'omo. Mosay jamapit nu'ctam Troas cumgu'yomo ø jo'ctamumø ø ndøvø'is, y jiṉ o ya'tame cu'yay jama. ");
INSERT INTO zosNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Y semana tzo'tzcuy jama'omo oy tu'myaj va'njajmocuy tøvø va'cø vyenve'ñaj pan, y Pablo'is nømna'ṉ 'yaṉmayaju, maṉba tzu'ṉ jyo'pitpø jama. Nømna'ṉ chamu Diosis 'yote hasta panguctzu'sye'ṉomo. ");
INSERT INTO zosNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ijtuna'ṉ vøti no'a møjipø cuarto'omo jujna'ṉ oyumø tu'myaje, ");
INSERT INTO zosNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","y tum soca ñøyipø'is Eutico po'csuna'ṉ ventanacøsi, nømna'ṉ 'yøṉu. Y como Pablo ya'u va'cø vyejvejneya, je soca uṉgusyunu, y pe'ṉu, y tzipotmø'nu tu'cay pisopø ventanacøsi; y ca'upøti'am piṉyaju. ");
INSERT INTO zosNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Entonces mø'n Pablo y mucscøne'c jetcøsi y jyotzcøtøjcøyu ñøjayaju: ―Uy 'yuqui'ajtame, quenbati. ");
INSERT INTO zosNT_vpl VA