﻿USE sofia;
DROP TABLE IF EXISTS sofia.zlmKSZI_vpl;
CREATE TABLE zlmKSZI_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zlmKSZI_vpl WRITE;
INSERT INTO zlmKSZI_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Inilah salasilah Isa al-Masih, keturunan Daud, keturunan Ibrahim. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim beroleh anak yang dinamai Ishak, Ishak beroleh Yakub, dan Yakub beroleh Yudah serta saudara-saudaranya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudah beroleh Peres dan Zerah daripada isterinya Tamar, Peres beroleh Hezron, dan Hezron beroleh Ram. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram beroleh Aminadab, Aminadab beroleh Nahason, dan Nahason beroleh Salmon. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon beroleh Boas daripada isterinya Rahab, Boas beroleh Obed daripada isterinya Rut, dan Obed beroleh Isai, ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","dan Isai beroleh Raja Daud. Raja Daud beroleh Sulaiman daripada isteri Uria. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulaiman beroleh Rehabeam, Rehabeam beroleh Abia, dan Abia beroleh Asa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa beroleh Yosafat, Yosafat beroleh Yoram, dan Yoram beroleh Uzia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia beroleh Yotam, Yotam beroleh Ahaz, dan Ahaz beroleh Hizkia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizkia beroleh Manasye, Manasye beroleh Amon, dan Amon beroleh Yosia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia beroleh Yoyakhin dan saudara-saudaranya sekitar masa mereka dibawa sebagai tawanan di Babel. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Seterusnya, Yoyakhin beroleh Sealtiel, dan Sealtiel beroleh Zerubabel. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel beroleh Abihud, Abihud beroleh Elyakim, dan Elyakim beroleh Azur. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azur beroleh Zadok, Zadok beroleh Akhim, dan Akhim beroleh Eliud. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud beroleh Eleazar, Eleazar beroleh Matan, dan Matan beroleh Yakub. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Maka Yakub beroleh Yusuf, suami Maryam, Maryamlah yang melahirkan Isa yang dipanggil al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dengan demikian, ada empat belas keturunan dari Ibrahim hingga ke Daud; empat belas keturunan dari Daud hingga ke masa pembuangan di Babel; dan empat belas keturunan dari masa itu hingga kelahiran al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Inilah kisah kelahiran Isa al-Masih: Ibu-Nya, Maryam bertunang dengan Yusuf, tetapi sebelum perkahwinan mereka dilangsungkan, Maryam mengandung melalui kuasa Roh Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusuf, seorang yang takwa dan berakhlak, tidak mahu memalukan Maryam di mata masyarakat. Dia berniat memutuskan pertunangan mereka secara diam-diam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dia memikirkan hal itu sehalus-halusnya. Suatu malam dia bermimpi malaikat Tuhan memperlihatkan diri kepadanya lalu berkata, ‘Hai Yusuf keturunan Daud! Janganlah takut mengambil Maryam sebagai isterimu. Dia mengandung melalui kuasa Roh Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maryam akan melahirkan seorang anak lelaki. Namakanlah anak itu Isa. Dia akan menyelamatkan umat-Nya daripada dosa mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Segala ini terjadi supaya berlakulah firman Tuhan melalui nabi-Nya: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Seorang anak dara akan mengandung, dan melahirkan seorang anak lelaki, maka Anak itu akan dipanggil Immanuel’ bererti, ‘Allah menyertai kita’ dalam bahasa Ibrani. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Apabila Yusuf terjaga, dia pun mematuhi apa yang disampaikan oleh malaikat Tuhan itu lalu berkahwin dengan Maryam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tetapi Yusuf tidak menyentuh Maryam sebagai isterinya hinggalah Maryam melahirkan Anak itu. Yusuf menamai Anak itu Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Isa dilahirkan di Baitlahim, Yudea, semasa pemerintahan Raja Herodes. Tidak lama kemudian datanglah beberapa orang ahli ilmu bintang dari Timur ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mereka bertanya, ‘Di manakah Anak yang baru lahir, yang akan menjadi Raja orang Yahudi? Kami melihat bintang-Nya muncul di Timur, dan kami datang hendak menyembah-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Apabila mendengar perkara itu, Raja Herodes berasa risau, begitu juga semua penduduk Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Raja Herodes memanggil semua ketua imam dan guru Taurat berhimpun lalu bertanya, ‘Raja yang dijanjikan oleh Allah itu, di manakah tempat lahirnya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mereka menjawab, ‘Di Baitlahim, Yudea. Seorang nabi telah bernubuat tentangnya: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Hai Baitlahim di Yudea, Kau bukanlah yang terkecil antara kota utama Yudea, kerana daripadamu akan muncul seorang Pemimpin yang akan memimpin umat-Ku Israel.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Setelah itu Raja Herodes berjumpa secara rahsia dengan ahli-ahli ilmu bintang itu dan mendapat tahu daripada mereka dengan tepat bila bintang itu terbit. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Raja Herodes menyuruh ahli-ahli ilmu bintang pergi ke Baitlahim dengan perintah demikian: ‘Pergilah dan carilah Anak itu sedaya upaya. Apabila kamu menjumpai-Nya beritahulah aku, supaya aku juga dapat pergi menyembah-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mereka pun pergi. Di pertengahan jalan, mereka melihat bintang yang telah muncul di Timur dahulu kini mendahului mereka dan berhenti di atas tempat Anak itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Sungguh gembira mereka apabila melihat bintang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mereka masuk ke situ dan melihat Anak itu dengan ibu-Nya Maryam. Mereka pun sujud menyembah Anak itu, lalu mempersembahkan emas, dupa dan mur kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Allah memberikan peringatan kepada mereka melalui mimpi supaya jangan kembali kepada Herodes. Oleh itu mereka pun pulang ke negeri mereka mengikut jalan lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Selepas itu malaikat Tuhan menampakkan diri dalam mimpi kepada Yusuf lalu berkata, ‘Herodes akan mengeluarkan perintah supaya mencari dan membunuh Anak itu. Bangunlah. Bawalah Anak itu dan ibu-Nya ke Mesir. Tinggallah di situ hingga Aku berfirman kepadamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusuf pun bangun. Pada malam itu juga dia membawa Anak itu dan ibu-Nya ke Mesir. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mereka tinggal di situ hingga kematian Raja Herodes. Maka berlakulah firman Tuhan menerusi nabi-Nya: ‘Aku memanggil Putera-Ku keluar dari Mesir.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Setelah Raja Herodes sedar dirinya ditipu oleh ahli-ahli ilmu bintang dari Timur itu, dia pun marah lalu mengeluarkan perintah untuk membunuh semua anak lelaki yang berusia dua tahun ke bawah di Baitlahim dan kawasan yang berdekatan. Usia itu berdasarkan maklumat yang diberikan oleh ahli-ahli ilmu bintang tentang masa bintang itu mula-mula muncul. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Oleh yang demikian berlakulah apa yang dinubuatkan oleh Yeremia: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Satu suara terdengar di Ramah, rintih ratap dan perkabungan. Rahel meratapi anak-anaknya, tidak mungkin dilipur hatinya, kerana mereka tiada lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Selepas kematian Herodes, malaikat Tuhan menampakkan diri dalam mimpi kepada Yusuf di Mesir. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kata malaikat itu, ‘Bangunlah. Bawalah Anak itu dan ibu-Nya ke tanah Israel, kerana orang yang hendak meragut nyawa Anak itu telah mati.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusuf pun bangun lalu membawa Anak itu dan ibu-Nya ke tanah Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tetapi apabila mendengar bahawa Arkelaus telah naik takhta menggantikan bapanya Herodes di Yudea, Yusuf pun takut pergi ke sana. Setelah mendapat peringatan daripada Allah dalam mimpi, dia pun pergi ke Galilea. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Dia menetap di kota yang bernama Nasaret. Dengan demikian berlakulah apa yang dikatakan oleh para nabi: ‘Dia akan dipanggil Orang Nasaret.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pada masa itu Yahya Pengimad menyampaikan berita ini di gurun di Yudea. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Dia berseru, ‘Bertaubatlah, kerana kerajaan syurga hampir tiba!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yahyalah yang dimaksudkan dalam nubuat Nabi Yasyaya: ‘Suara seorang berseru di gurun: “Sediakanlah jalan untuk Tuhan, luruskan jalan untuk-Nya.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pakaian Yahya diperbuat daripada bulu unta dan tali pinggangnya daripada kulit. Makanannya belalang dan madu gurun. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Orang dari Baitulmaqdis, seluruh Yudea dan segenap kawasan sekitar Sungai Yordan datang mendapatkan Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mereka mengaku dosa lalu diimadkan oleh Yahya di Sungai Yordan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ramai orang Farisi dan Saduki datang untuk diimadkan. Apabila melihat mereka, Yahya berkata, ‘Hai orang durjana! Siapakah yang memberitahumu bahawa kamu dapat melepaskan diri daripada hukuman Allah kelak? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Buktikanlah dengan perbuatan bahawa kamu telah bertaubat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jangan sangka kamu dapat melepaskan diri daripada hukuman dengan berkata, “Ibrahim moyang kami.” Ketahuilah, Allah berkuasa menjadikan batu-batu ini anak cucu Ibrahim! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kapak sudah tersedia untuk menebang pokok hingga ke akar umbinya. Setiap pokok yang tidak menghasilkan buah yang baik akan ditebang dan dihumbankan ke dalam api. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","‘Aku mengimadkanmu dengan air untuk menunjukkan bahawa kamu telah bertaubat. Tetapi Dia yang datang selepasku akan mengimadkanmu dengan Roh Suci dan api; Dia lebih berkuasa daripadaku; membawakan kasut-Nya pun aku tidak layak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tangan-Nya memegang nyiru untuk menampi. Dia akan mengumpulkan gandum yang bersih di dalam jelapang dan membakar sekam di dalam api yang tidak mungkin padam.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ketika itu Isa meninggalkan Galilea lalu pergi ke Sungai Yordan. Di situ Dia berjumpa dengan Yahya dan meminta diimadkan olehnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yahya cuba menolak dengan berkata, ‘Sepatutnya Engkau yang mengimadkanku. Ini Engkau pula datang kepadaku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tetapi Isa menjawab, ‘Biarkanlah demikian untuk sekarang, kerana dengannya kita akan menunaikan segala kebenaran.’ Yahya pun patuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Setelah diimadkan, Isa keluar dari air dengan segera. Lalu terbukalah langit dan dia melihat Roh Allah turun seperti burung merpati ke atas-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kemudian kedengaran suara Allah berfirman, ‘Inilah Putera-Ku yang Kukasihi dan dengan-Nya Aku berkenan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Setelah itu Isa dibawa oleh Roh ke gurun untuk digoda Iblis. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Isa berpuasa empat puluh hari empat puluh malam. Dia menanggung kelaparan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iblis datang kepada-Nya lalu berkata, ‘Jika Engkau Putera Allah, perintahkanlah batu-batu ini menjadi roti.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Isa menjawab, ‘Telah tersurat: “Manusia hidup bukan dengan roti saja tetapi dengan setiap firman Allah.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Selepas itu Iblis membawa Isa ke kota suci Baitulmaqdis dan meletakkan-Nya di puncak rumah ibadat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Iblis berkata kepada Isa, ‘Jika Engkau Putera Allah, terjunlah, kerana telah tersurat: “Allah akan memerintahkan malaikat-malaikat-Nya menjaga-Mu dan mereka akan menatang-Mu supaya kaki-Mu tidak terhantuk batu.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Isa menjawab, ‘Tetapi telah tersurat: “Janganlah engkau menduga Allah, Tuhanmu.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iblis membawa pula Isa ke atas gunung yang amat tinggi lalu menunjukkan semua kerajaan di dunia dan kekayaannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kata Iblis kepada Isa, ‘Semua ini akan kuberikan kepada-Mu jika Engkau sujud menyembahku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jawab Isa, ‘Nyah engkau, Iblis. Telah tersurat: “Hendaklah engkau menyembah Allah, Tuhanmu dan kepada-Nya saja engkau beribadat.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iblis pun meninggalkan Isa dan para malaikat datang melayani-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Apabila mendengar bahawa Yahya telah dipenjarakan, Isa pun pergi ke Galilea. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Dia tidak tinggal di Nasaret tetapi di Kapernaum, sebuah kota di pinggir laut Galilea di kawasan Zebulon dan Naftali. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dengan demikian berlakulah nubuat Nabi Yasyaya: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Tanah Zebulon, tanah Naftali, di pinggir laut, seberang Sungai Yordan, Galilea, tanah bangsa-bangsa asing. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bangsa yang hidup dalam kegelapan telah melihat cahaya gemilang. Bagi mereka yang di bawah bayangan maut, Cahaya telah bersinar!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Isa pun mula menyampaikan perkhabaran-Nya, ‘Bertaubatlah, kerana kerajaan syurga hampir tiba!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sedang Isa berjalan di pinggir laut Galilea, Dia terpandang dua orang nelayan iaitu Simon, yang juga dipanggil Petrus, dan adiknya Andreas, sedang menjala ikan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Isa berkata kepada mereka, ‘Ikutlah Aku. Aku akan mengajarmu menjala manusia menjadi pengikut-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dengan serta-merta mereka dua beradik meninggalkan jala mereka lalu mengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Isa meneruskan perjalanan. Dia ternampak dua beradik lagi, Yakobus dan Yahya bersama bapa mereka Zebedeus, sedang mengemaskan jala di dalam perahu. Isa memanggil dua beradik itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Seketika itu juga mereka meninggalkan perahu dan bapa mereka lalu mengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Isa menjelajahi seluruh wilayah Galilea. Dia mengajar di saumaah dan menyampaikan berita baik bahawa kerajaan Allah hampir tiba. Dia menyembuhkan semua jenis penyakit dan kesakitan di antara mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Berita tentang Isa tersebar di seluruh Siria. Maka, ramailah orang yang menanggung pelbagai penyakit dan penderitaan, orang yang dirasuk roh iblis, yang mengidap penyakit gila babi, dan yang lumpuh, dibawa kepada-Nya dan disembuhkan oleh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ramai sekali orang mengikut-Nya: dari Dekapolis (bermaksud Sepuluh Kota), dari Baitulmaqdis, dari Yudea, dan dari kawasan di seberang Yordan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ketika Isa melihat orang ramai itu, Dia pun mendaki ke atas sebuah bukit lalu duduk. Kemudian datanglah para pengikut-Nya kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Dia pun mula mengajar mereka: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","‘Diberkatilah mereka yang terasa kelemahan rohani, kerana kerajaan syurga untuk mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Diberkatilah mereka yang bersedih, kerana mereka akan terhibur. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Diberkatilah mereka yang lemah lembut, kerana mereka akan mewarisi bumi ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Diberkatilah mereka yang dahagakan kebenaran, kerana mereka akan dipuaskan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Diberkatilah mereka yang berpengasihan, kerana mereka akan dikasihani juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Diberkatilah mereka yang suci hati, kerana mereka akan melihat Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Diberkatilah mereka yang mendamaikan manusia, kerana mereka akan dipanggil anak-anak Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Diberkatilah mereka yang dianiaya kerana menegakkan kebenaran, kerana kerajaan syurga untuk mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‘Diberkatilah kamu apabila orang menghina, menganiaya dan memfitnahmu kerana mengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bersukacita dan bergembiralah, kerana ganjaran besar telah disediakan untukmu di syurga. Begitu jugalah para nabi zaman dahulu dianiaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","‘Kamu ialah garam bumi ini. Jika garam menjadi tawar, tidak mungkinlah masin semula. Tidaklah berguna lagi, hanya layak dibuang dan dipijak orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‘Kamu ialah cahaya dunia ini. Kota di atas bukit tidak mungkin tersembunyi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tiada siapa memasang pelita lalu menyorokkannya di bawah bekas; tentu dia meletakkannya di atas kaki pelita untuk menerangi seisi rumah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Biarlah cahayamu juga bersinar di hadapan orang ramai, supaya mereka melihat perbuatanmu yang baik lalu memuji Bapamu yang di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘Jangan sangka Aku datang untuk menghapuskan Taurat dan ajaran nabi-nabi. Aku datang bukan untuk menghapuskan tetapi untuk menunaikan segala-galanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ingatlah: Selagi ada langit dan bumi, satu titik atau huruf yang terkecil pun tidak akan hapus daripada Taurat sebelum semuanya ternyata berlaku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dengan demikian, jika seseorang melanggar hukum yang terkecil pun dan mengajar orang lain melanggarnya, dia akan tergolong antara mereka yang paling rendah dalam kerajaan syurga. Sebaliknya, jika seseorang mematuhi Taurat dan mengajar orang lain turut patuh, dia akan menjadi orang yang mulia dalam kerajaan syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Oleh itu ingatlah: Untuk memasuki kerajaan syurga, kamu mestilah melaksanakan kehendak Allah lebih daripada guru Taurat dan orang Farisi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘Kamu telah mendengar ajaran daripada nenek moyang kita: “Jangan membunuh. Sesiapa yang membunuh orang akan dihakimi.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tetapi sekarang Aku berkata kepadamu: Sesiapa yang marah terhadap saudaranya akan dihakimi. Sesiapa yang mencaci saudaranya akan dibawa ke hadapan Majlis Agama. Dan sesiapa yang memanggil saudaranya “bodoh” akan dihumbankan ke dalam api neraka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‘Oleh itu, jika kamu sedang meletakkan persembahan kepada Allah di atas mazbah lalu teringat bahawa saudaramu bersanggit hati denganmu, ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tinggalkanlah persembahanmu, berdamai dahulu dengan saudaramu, kemudian barulah buat persembahanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‘Berdamailah dengan orang yang hendak mendakwamu di mahkamah sewaktu kamu masih dalam perjalanan ke situ. Jika tidak, dia akan menyerahkanmu kepada hakim, kemudian hakim menyerahkanmu kepada pegawai berkenaan, yang akan memenjarakanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sudah pasti kamu akan meringkuk di dalam penjara hingga kamu menjelaskan semua bayaran. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Kamu telah mendengar ajaran ini: “Jangan berzina.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tetapi sekarang Aku berkata kepadamu: Sesiapa yang memandang seorang wanita dengan berahi, telah berzina dengannya dalam hati. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jika mata kananmu menyebabkan kamu berdosa, cungkil dan buangkan mata itu. Lebih baik kamu kehilangan satu bahagian tubuhmu daripada seluruh tubuhmu terhumban ke dalam neraka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jika tangan kananmu menyebabkan kamu berdosa, potong dan buangkan tangan itu. Lebih baik kamu kehilangan sebelah tanganmu daripada seluruh tubuhmu masuk ke dalam neraka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘Ada ajaran demikian: “Sesiapa menceraikan isterinya hendaklah memberinya surat cerai.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tetapi sekarang Aku berkata kepadamu: Sesiapa menceraikan isterinya kecuali kerana zina, orang itu menyebabkan wanita tersebut berzina jika berkahwin lagi; dan sesiapa yang berkahwin dengan wanita yang diceraikan itu berzina juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘Kamu telah mendengar ajaran kepada nenek moyang kita: “Jangan melanggar sumpah. Tunaikan sumpahmu kepada Tuhan.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tetapi sekarang Aku berkata kepadamu: Janganlah bersumpah demi langit, kerana langit itu takhta Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Jangan bersumpah demi bumi, kerana bumi ini alas kaki-Nya. Atau demi Baitulmaqdis, kerana itu kota Raja Agung iaitu Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Demi kepalamu pun jangan, kerana kamu tidak berkuasa memutihkan atau menghitamkan rambutmu walau sehelai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Katakan saja “Ya” atau “Tidak” dan kotakan kata itu. Yang lebih daripada itu datang daripada si durjana. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Kamu telah mendengar ajaran begini: “Mata diganti dengan mata, gigi diganti dengan gigi.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tetapi sekarang Aku berkata kepadamu: Janganlah membalas dendam terhadap orang yang berbuat jahat kepadamu. Malah jika seseorang menampar pipi kananmu, palinglah pipi kirimu juga terhadapnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jika seseorang hendak mendakwamu untuk mendapatkan bajumu, berikanlah jubahmu juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jika sesiapa memaksamu berjalan sebatu dengannya, pergilah dua batu bersamanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jika seseorang meminta sesuatu daripadamu, berikanlah. Jika seseorang hendak meminjam sesuatu daripadamu, usahlah berpaling daripadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Kamu telah mendengar ajaran berikut: “Kasihilah sahabatmu dan bencilah musuhmu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tetapi sekarang Aku berkata kepadamu: Kasihilah musuhmu dan doakan orang yang menganiayamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dengan demikian kamu menjadi anak-anak Bapamu yang di syurga; kerana Allah menerbitkan matahari yang dicipta-Nya untuk orang yang benar dan orang yang mungkar. Dia menurunkan hujan untuk orang yang taat mahupun yang ingkar akan kehendak-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jika kamu hanya mengasihi orang yang mengasihimu, layakkah kamu mendapat ganjaran daripada Allah? Bukankah pemungut cukai pun berbuat demikian? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jika kamu hanya beramah mesra dengan saudara-saudara selingkungan, apakah kelebihanmu daripada orang lain? Orang yang tidak mengenal Allah pun melakukannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hendaklah engkau sempurna seperti Bapamu di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","‘Ingatlah: Jangan buat kerja amal di muka umum supaya dilihat orang; kamu tidak akan mendapat ganjaran daripada Bapamu yang di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","‘Oleh itu, ketika kamu bersedekah kepada orang miskin, jangan heboh-hebohkan seperti orang munafik di saumaah dan di jalan raya, supaya dipuji orang. Orang begitu sudahpun mendapat ganjaran mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Apabila kamu bersedekah kepada orang miskin, jangan sampai tangan kirimu tahu apa yang dilakukan oleh tangan kananmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jangan siapapun mengetahuinya. Bapamu yang melihat amalmu yang tersembunyi itu akan memberikan ganjaran kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘Apabila kamu berdoa, janganlah seperti orang munafik. Mereka berdoa sambil berdiri di saumaah dan di simpang jalan supaya dilihat orang. Mereka itu sudahpun mendapatkan ganjaran mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tetapi kamu, masuklah ke dalam bilik, tutup pintu dan berdoalah kepada Bapamu yang tidak dapat dilihat dengan mata. Dia mengetahui apa yang kamu lakukan secara tersembunyi dan akan memberikan ganjaran kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ketika berdoa, jangan curah-curahkan kata-kata yang tidak bermakna, seperti orang yang tidak mengenal Allah. Mereka menyangka Allah akan mengabulkan permintaan mereka kerana doa mereka itu panjang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jangan berbuat seperti mereka. Bapamu tahu apa yang kamu perlukan sebelum kamu memohonnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","‘Berdoalah demikian: “Ya Bapa kami yang di syurga, Sucilah Nama-Mu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Datanglah kerajaan-Mu. Terlaksanalah kehendak-Mu di bumi sebagaimana di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Berilah makanan kami untuk hari ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ampunkanlah kesalahan kami sebagaimana kami mengampuni mereka yang bersalah terhadap kami. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Janganlah biarkan kami tergoda, Selamatkanlah kami daripada si durjana. Engkaulah yang memiliki kerajaan, kekuasaan dan kemuliaan selama-lamanya. Amin.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‘Jika kamu mengampuni orang yang bersalah kepadamu, Bapamu yang di syurga akan mengampunkan kesalahanmu juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tetapi jika kamu tidak mengampunkan kesalahan orang, Bapamu yang di syurga juga tidak akan mengampunkan kesalahanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","‘Apabila kamu berpuasa, jangan tunjukkan muka lesu seperti orang munafik. Mereka memperlihatkan wajah menderita supaya semua orang tahu mereka berpuasa. Mereka ini sudahpun mendapat ganjaran mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ketika berpuasa, basuhlah muka dan sikatlah rambutmu ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","supaya orang tidak tahu kamu berpuasa. Biarlah puasamu hanya diketahui oleh Bapamu yang tidak dapat dilihat dengan mata. Bapamu melihat perbuatanmu yang tersembunyi itu dan memberikan ganjaran kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‘Jangan kumpulkan harta di dunia, kerana di sini gegat dan karat merosakkannya serta pencuri memecah masuk untuk mencurinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kumpulkan harta di syurga, kerana di situ gegat dan karat tidak dapat merosakkannya serta pencuri tidak memecah masuk untuk mencurinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kerana di mana hartamu terkumpul, di situlah hatimu tertumpu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘Mata ialah pelita tubuh. Jika matamu terang, seluruh tubuhmu dipenuhi cahaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tetapi jika matamu kabur, seluruh tubuhmu gelap. Jika cahaya di dalam tubuhmu menjadi gelap, maka gelap-gelitalah keadaannya! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘Seorang hamba tidak mungkin mengabdi diri kepada dua orang tuan. Dia akan membenci yang seorang dan mengasihi yang lain; atau akan setia kepada yang seorang dan mencela yang lain. Demikianlah, kamu tidak dapat menjadi hamba Allah dan juga hamba kekayaan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‘Oleh itu, janganlah runsing tentang hidupmu, tentang apa yang kamu makan atau minum, atau tentang tubuhmu, dan tentang apa yang akan kamu pakai untuk menutupnya. Bukankah hidup lebih daripada makanan, dan tubuh lebih daripada pakaian? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lihatlah burung di udara, yang tidak menyemai, menuai atau menyimpan hasil di jelapang; namun Bapamu yang di syurga memberinya makan. Bukankah kamu lebih bernilai daripada burung? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Siapakah di kalanganmu yang dapat melanjutkan usianya sedikit pun dengan bersikap runsing? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‘Jadi, mengapakah kamu runsing tentang pakaian? Lihatlah bunga bakung di padang, yang tidak bekerja atau bertenun. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tetapi Raja Sulaiman dengan segala kehebatannya pun tidak berpakaian seindah bunga itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jika Allah menghiasi rumput di padang, yang wujud hari ini dan esoknya dibakar di dapur, tidakkah Allah akan memberimu pakaian? Sungguh tipis kepercayaanmu kepada-Nya! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jangan runsing tentang makanan, minuman atau pakaianmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kerunsingan ini dialami oleh orang yang tidak mengenal Allah. Bapamu yang di syurga tahu bahawa kamu memerlukan semua itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Utamakanlah kerajaan Allah dan laksanakan kebenaran-Nya; Allah akan memberikan semua itu kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Oleh itu, jangan runsing tentang hari esok, kerana hari esok akan runsing tentang hal-halnya sendiri. Setiap hari sudah cukup dengan kesusahan sehari. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","‘Jangan hakimi orang lain, supaya kamu tidak dihakimi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kerana sebagaimana kamu menghakimi orang, demikian jugalah kamu akan dihakimi. Ukuran yang kamu gunakan untuk menghakimi orang lain akan digunakan Allah untuk menghakimi kamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","‘Mengapakah kamu perhatikan selumbar di mata saudaramu, sedangkan kayu balak di matamu sendiri tidak kamu sedari? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bagaimanakah kamu dapat berkata kepada saudaramu, ‘Biarlah aku keluarkan selumbar dari mata saudara,’ sedangkan kayu balak terpampang di matamu sendiri? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hai munafik! Keluarkanlah dahulu kayu balak dari matamu, barulah penglihatanmu terang untuk mengeluarkan selumbar dari mata saudaramu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘Jangan berikan sesuatu yang suci kepada anjing, atau mutiara kepada babi, nanti dipijak-pijaknya lalu berpaling menyerangmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","‘Mintalah, dan kamu akan menerimanya; carilah, dan kamu akan mendapatnya; ketuklah pintu, dan pintu akan dibuka untukmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Setiap orang yang meminta akan menerima, setiap orang yang mencari akan mendapat; dan setiap orang yang mengetuk, pintu akan dibuka untuknya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‘Bapa manakah akan memberikan batu kepada anaknya yang meminta roti? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bapa manakah akan memberikan ular kepada anaknya yang meminta ikan? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kamu yang berdosa pun tahu memberikan sesuatu yang baik kepada anakmu. Lebih-lebih lagi Bapamu yang di syurga: Dia akan memberikan sesuatu yang baik kepada mereka yang meminta daripada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Apa yang kamu mahu orang lakukan kepadamu, lakukan kepada mereka, kerana inilah ajaran Taurat dan nabi-nabi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","‘Masuklah melalui pintu yang sempit, kerana pintu gerbang dan jalan ke neraka itu lebar dan luas, maka ramai orang yang memilihnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sebaliknya pintu dan jalan ke hidup kekal itu sempit dan sukar. Hanya segelintir orang yang menjumpainya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‘Berjaga-jagalah tentang nabi palsu yang datang kepadamu dengan pakaian domba tetapi sebenarnya serigala ganas. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kamu akan mengenal mereka daripada hasil perbuatan mereka. Pernahkah orang memetik buah anggur dari rimbunan berduri? Atau pernahkah buah ara dipetik dari semak berduri? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pokok yang subur menghasilkan buah yang baik manakala pokok yang tidak subur menghasilkan buah yang tidak baik. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pokok yang subur tidak mungkin menghasilkan buah yang tidak baik dan pokok yang tidak subur tidak mungkin menghasilkan buah yang baik. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Setiap pokok yang tidak menghasilkan buah yang baik akan ditebang dan dibakar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Demikianlah kamu akan mengenal orang daripada hasil perbuatan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Tidak semua orang yang memanggil-Ku, “Junjungan kami, Junjungan kami,” akan memasuki kerajaan syurga, tetapi hanya mereka yang melaksanakan kehendak Bapa-Ku yang di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pada hari itu ramai orang akan berkata kepada-Ku, “Junjungan kami, Junjungan kami, bukankah kami telah menyampaikan perkhabaran Allah dengan nama-Mu? Bukankah kami telah menghalau roh-roh iblis serta banyak melakukan mukjizat dengan nama-Mu?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tetapi aku akan menjawab, “Aku tidak mengenalmu. Pergilah dari sini, hai kamu yang mungkar.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‘Sesiapa yang mendengar dan menurut kata-kata-Ku ini ibarat orang bijak yang membina rumah di atas batu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Hujan mencurah, banjir melimpah dan angin kencang melanda, tetapi rumah itu tidak runtuh kerana berasaskan batu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Sesiapa yang mendengar tetapi tidak menurut kata-kata-Ku ini ibarat orang bodoh yang membina rumah di atas pasir. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hujan mencurah, banjir melimpah dan angin kencang melanda, lalu runtuhlah rumah itu, punah ranap!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Setelah selesai Isa menyampaikan kata-kata itu, orang ramai itu kagum akan cara Dia mengajar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Isa mengajar secara berwibawa, tidak seperti guru Taurat mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Isa turun dari bukit itu dan ramai orang mengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Seorang yang mengidap penyakit kusta datang bersujud di hadapan-Nya sambil berkata, ‘Tuan, sekiranya Tuan mahu, Tuan dapat menyembuhkanku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Isa menghulurkan tangan-Nya dan menyentuh orang itu sambil berkata, ‘Aku rela. Sembuhlah!’ Pada saat itu juga penyakitnya hilang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lalu Isa berkata kepadanya, ‘Dengarlah, jangan beritahu sesiapa tentang perkara ini. Pergilah dan tunjukkan dirimu kepada seorang imam. Selepas itu persembahkan korban sebagaimana diperintahkan oleh Musa, sebagai kesaksian kepada mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ketika Isa sampai di Kapernaum, seorang ketua tentera Rom menjumpai-Nya dan merayu kepada-Nya: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","‘Junjungan, hambaku sakit di rumah, terlantar di katil tidak dapat bergerak, dan amat derita.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Isa menjawab, ‘Baiklah, Aku akan pergi menyembuhkannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tetapi ketua tentera itu berkata, ‘Usahlah Junjungan datang ke rumahku. Aku tidak layak menyambut Junjungan sebagai tamu. Perintahkanlah sahaja, tentu dia akan sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aku juga di bawah perintah pegawai atasan tentera, dan ada askar di bawah tanganku. Apabila aku menyuruh seorang askar, “Pergi!” dia pun pergi. Apabila aku menyuruh askar lain, “Mari!” dia pun datang. Apabila aku menyuruh hambaku, “Buat ini!” dia melakukannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Isa terkagum mendengarnya lalu berkata kepada orang ramai yang mengikut-Nya, ‘Belum pernah Kutemui orang yang demikian teguh imannya, walau di Israel pun. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ketahuilah! Ramai orang akan datang dari timur dan barat lalu duduk menikmati jamuan bersama Ibrahim, Ishak dan Yakub dalam kerajaan syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sebaliknya anak-anak kerajaan itu akan dihumbankan ke dalam kegelapan di luar; di sana akan terdapat ratapan dan kertakan gigi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lalu Isa berkata kepada ketua tentera itu, ‘Pulanglah! Apa yang kamu percayai itu akan terjadi.’ Pada ketika itu juga sembuhlah hamba ketua tentera itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Isa pergi ke rumah Petrus. Dia melihat ibu mertua Petrus terbaring di katil kerana demam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Apabila Isa menyentuh tangannya, serta-merta demamnya hilang. Dia pun bangun, dan melayan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Setelah hari petang, ramai orang yang dirasuk roh iblis dibawakan kepada Isa. Isa menghalau roh-roh iblis itu dengan sepatah kata sahaja. Dia juga menyembuhkan semua yang sakit. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Isa melakukan semua itu supaya terjadilah apa yang dikatakan oleh Nabi Yasyaya: ‘Dialah yang membawa kelemahan kita dan menanggung penyakit kita.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Apabila Isa melihat orang ramai di sekeliling-Nya, dia pun menyuruh para pengikut-Nya pergi ke seberang laut itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Seorang guru Taurat mendapatkan Isa lalu berkata, ‘Tuan Guru, aku sanggup mengikut-Mu ke mana-mana saja.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Isa menjawab, ‘Musang ada lubangnya dan burung ada sarangnya, tetapi Putera Insan tidak ada tempat untuk berehat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Seorang pengikut lain berkata, ‘Junjungan, izinkanlah aku pulang dahulu untuk menguburkan jenazah bapaku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tetapi Isa menjawab, ‘Ikutlah Aku. Biarlah orang mati menguburkan orang mati mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Isa menaiki sebuah perahu, dan diikut oleh pengikut-pengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tiba-tiba badai melanda dan ombak mengganas sehingga perahu dipenuhi air. Ketika itu Isa sedang tidur. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Para pengikut Isa datang membangunkan-Nya. Mereka berkata, ‘Ya Junjungan, selamatkan nyawa kami semua daripada maut!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Isa menjawab, ‘Mengapakah kamu takut? Begitu tipis kepercayaanmu kepada-Ku!’ Dia pun bangun memarahi angin dan ombak itu. Serta-merta semuanya tenang sekali. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Para pengikut Isa tercengang lalu berkata, ‘Angin dan ombak pun mengikut perintah-Nya. Siapakah sebenarnya Dia ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Setelah tiba di seberang, di daerah Gadara, Isa didekati oleh dua orang yang dirasuk roh iblis. Mereka keluar dari gua kubur. Kedua-duanya begitu ganas sehingga orang tidak berani lalu di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Apabila mereka melihat Isa, mereka berseru, ‘Apakah yang akan Kaulakukan kepada kami, hai Putera Allah? Adakah Engkau hendak menghukum kami sebelum sampai masanya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ada sekawan babi sedang makan agak jauh dari situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Roh-roh iblis itu merayu kepada Isa, ‘Jika Engkau hendak menyuruh kami keluar, suruhlah kami masuk ke dalam tubuh babi sekawan itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dan Isa memerintah roh-roh itu, ‘Pergilah’. Maka roh-roh itu pun keluar lalu memasuki babi-babi itu. Seluruh kawanan babi itu pun lari ke pinggir jurang laut lalu terjun dan mati lemas. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Penjaga-penjaga babi itu lari ke bandar lalu menceritakan hal itu serta apa yang telah terjadi kepada kedua-dua orang yang dirasuk roh iblis itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Seluruh penduduk bandar itu pun datang berjumpa dengan Isa dan memohon-Nya pergi dari situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Isa menaiki sebuah perahu lalu ke seberang, dan sampai di bandar tempat Dia tinggal. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Beberapa orang membawa kepada-Nya seorang lumpuh yang terbaring di atas tikar. Ketika Isa menyedari betapa teguhnya iman mereka, Dia berkata kepada orang lumpuh itu, ‘Tegapkan hatimu, anak-Ku! Dosamu telah diampunkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sebilangan guru Taurat di situ berfikir dalam hati, ‘Orang ini mengkufuri Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Isa tahu apa yang difikirkan oleh mereka itu lalu Dia berkata, ‘Mengapa kamu fikirkan perkara sejahat itu? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Manakah yang lebih mudah dikatakan, “Dosamu telah diampunkan,” atau “Bangun dan berjalan?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aku akan membuktikan kepadamu bahawa di bumi ini Putera Insan berkuasa mengampunkan dosa.’ Kemudian Isa berkata kepada orang lumpuh itu, ‘Bangun, angkat tikarmu dan pulanglah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Orang lumpuh itu pun bangun lalu pulang ke rumahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Melihat kejadian itu, orang di situ ketakutan dan memuji Allah yang memberikan kuasa yang sedemikian besarnya kepada manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Isa meninggalkan tempat itu. Dalam perjalanan Dia melihat seorang pemungut cukai bernama Matius sedang duduk di tempat memungut cukai. Isa berkata, ‘Ikutlah Aku’. Lalu Matius berdiri dan mengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ketika Isa sedang makan di rumah Matius, ramai pemungut cukai dan orang berdosa makan bersama Isa dan para pengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Beberapa orang Farisi yang melihat perkara itu bertanya kepada para pengikut Isa, ‘Mengapa gurumu makan bersama pemungut cukai dan orang yang berdosa?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Isa terdengar pertanyaan mereka lalu menjawab, ‘Orang sihat tidak memerlukan tabib; hanya orang sakit yang memerlukannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kajilah erti ayat ini: “Aku menghendaki belas kasihan, bukan binatang korban.” Itulah maka Aku datang bukan untuk memanggil orang benar tetapi orang berdosa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Selepas itu para pengikut Yahya Pengimad mendapatkan Isa lalu bertanya, ‘Mengapakah kami dan orang Farisi sering berpuasa tetapi para pengikut-Mu tidak berpuasa?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Isa menjawab, ‘Pada hematmu, patutkah tetamu di jamuan perkahwinan bersedih semasa pengantin lelaki masih bersama mereka? Tentu tidak. Namun akan tiba masanya pengantin lelaki itu diambil daripada mereka. Ketika itulah mereka akan berpuasa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‘Tiada siapa akan menampal pakaian lama dengan perca kain baru, kerana tampalan itu akan mengecut dan menyebabkan koyak yang lebih besar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Begitu juga, tiada siapa akan menuangkan air anggur yang baru ke dalam bekas kulit yang lama, kerana bekas itu akan pecah dan air anggur itu akan terbuang. Air anggur yang baru patut dituangkan ke dalam bekas kulit yang baru juga supaya kedua-duanya selamat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sedang Isa berkata-kata dengan para pengikut Yahya Pengimad, seorang ketua saumaah bersujud di hadapan-Nya lalu berkata, ‘Anak perempuanku baru meninggal dunia. Datanglah, letakkan tangan-Mu di atasnya supaya dia hidup kembali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Isa pun bangun lalu pergi bersamanya, diiringi oleh para pengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ketika itu, ada seorang wanita yang telah mengidap penyakit pendarahan selama dua belas tahun. Dia mendekati Isa dari belakang lalu menyentuh hujung jubah-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Fikir wanita itu dalam hatinya, ‘Apabila kusentuh jubah-Nya, pasti aku akan sembuh.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Isa menoleh dan melihatnya lalu berkata kepadanya, ‘Tetapkanlah hatimu, anak-Ku! Kerana imanmu kamu sembuh.’ Serta-merta wanita itu sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Apabila Isa sampai di rumah ketua itu, Dia nampak para pemain seruling dan semua orang di situ kelam-kabut. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Dia berkata, ‘Keluarlah kamu semua! Anak ini bukan mati, cuma tidur.’ Mereka mula mentertawakan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tetapi setelah mereka keluar, Isa masuk ke bilik anak perempuan itu dan memegang tangannya lalu anak itu bangun. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Khabar ini tersebar ke seluruh daerah itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ketika Isa meninggalkan tempat itu, dua orang buta mengikut-Nya sambil berseru, ‘Hai Anak Daud, kasihanilah kami!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ketika Isa masuk ke rumah, kedua-dua orang buta itu mendekati-Nya. Isa bertanya, ‘Percayakah kamu bahawa Aku dapat menyembuhkanmu?’ ‘Percaya, Junjungan!’ jawab mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Isa pun menyentuh mata mereka sambil berkata, ‘Kerana imanmu, terjadilah seperti apa yang kamu inginkan!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pada ketika itu juga mereka menjadi celik. Isa berpesan kepada mereka bersungguh-sungguh, ‘Jangan ceritakan hal ini kepada siapapun.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tetapi mereka pergi menyebarkan khabar tentang Isa ke seluruh daerah itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Selepas itu, seorang yang bisu kerana dirasuk roh iblis dibawa kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Isa menghalau roh iblis itu dan serta-merta orang itu mula berkata-kata. Semua yang melihatnya tercengang lalu berkata, ‘Belum pernah kami lihat hal begini di Israel!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tetapi orang Farisi berkata, ‘Ketua roh iblis telah memberi Isa kuasa untuk menghalau roh-roh iblis.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Demikianlah Isa berjalan, dari bandar ke bandar, dari pekan ke pekan. Dia mengajar di saumaah dan menyampaikan berita baik tentang kerajaan Allah. Dia menyembuhkan orang daripada pelbagai penyakit. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Apabila melihat orang yang ramai itu, Isa berasa kasihan kerana mereka bimbang dan tidak berdaya, ibarat sekawan domba tanpa gembala. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kata Isa kepada para pengikut-Nya, ‘Tuaian banyak sekali tetapi penuai hanya segelintir. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Berdoalah kepada Tuan punya tuaian itu supaya menghantar pekerja untuk menuai.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Isa memanggil dua belas orang pengikut-Nya lalu memberi mereka kuasa untuk menghalau roh-roh durjana dan menyembuhkan pelbagai penyakit dan kesakitan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Dua belas orang itu ialah: Simon yang dipanggil Petrus, dan saudaranya Andreas; Yakobus dan saudaranya Yahya, iaitu anak-anak Zebedeus; ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipus dan Bartolomeus; Tomas, dan Matius yang dahulunya pemungut cukai; Yakobus anak Alfeus, dan Tadius; ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon orang Patriot, dan Yudas Iskariot yang mengkhianati Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Isa mengutus dua belas orang rasul itu dengan petunjuk demikian: ‘Janganlah pergi ke daerah bangsa-bangsa asing atau ke kota orang Samaria. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pergilah kepada domba-domba sesat antara bani Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pergilah dan khabarkanlah bahawa kerajaan syurga sudah dekat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sembuhkanlah orang yang sakit, hidupkan orang yang mati; ubati orang yang berpenyakit kusta dan halaukan roh-roh iblis. Sebagaimana pemberian dilimpahkan kepadamu, limpahkanlah pemberian. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Janganlah bawa wang emas, perak mahupun tembaga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jangan bawa bekas untuk menerima sedekah, atau ganti pakaian, atau kasut, atau tongkat dalam perjalananmu. Seorang pekerja layak menerima apa yang diperlukannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘Apabila kamu sampai di suatu bandar atau pekan, carilah seorang yang rela menyambutmu. Menetaplah di rumahnya hingga kamu beredar dari tempat itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ketika kamu masuk ke rumah itu, berilah salam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jika penghuni di rumah itu layak, biarlah salam sejahteramu merestui mereka. Jika tidak, biarlah salammu itu kembali kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Sekiranya sesuatu rumah atau bandar enggan menyambutmu atau mendengar kata-katamu, tinggalkanlah tempat itu dan kebaskanlah debunya daripada tapak kakimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sesungguhnya, Aku berkata kepadamu: pada hari penghakiman itu, hukuman atas Sodom dan Gomora lebih ringan daripada atas bandar itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Dengarlah: Aku mengutusmu seperti domba ke tengah-tengah sekawan serigala. Hendaklah kamu bijak seperti ular dan tulus seperti merpati. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","‘Berhati-hatilah, kerana kamu akan ditangkap lalu diseret ke mahkamah, dan akan disebat di saumaah mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kerana-Ku, kamu akan dibawa ke hadapan penguasa dan raja sebagai saksi kepada mereka dan kepada bangsa yang tidak mengenal Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ketika dihakimi, janganlah runsing tentang apa yang harus kamu katakan atau bagaimana kamu harus mengatakannya. Apabila sampai saatnya, kamu akan diberitahu apa yang harus kamu katakan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bukanlah kata-katamu sendiri yang akan kamu ucapkan, tetapi kata-kata Roh Bapamu yang dituturkan melaluimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘Saudara akan berlaku khianat terhadap saudara, bapa terhadap anak, dan anak terhadap bapa, lalu menyerahkannya untuk dibunuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Setiap orang akan membencimu kerana nama-Ku. Tetapi sesiapa yang bertahan hingga akhir akan diselamatkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Apabila kamu dianiaya di sesuatu bandar, larilah ke bandar lain. Ketahuilah, Putera Insan akan datang semula sebelum kamu sempat menyampaikan ajaran-Ku di semua bandar di tanah Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‘Tiada murid yang melebihi gurunya; tiada hamba yang melebihi tuannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Murid haruslah berpuas hati menjadi seperti gurunya; hamba haruslah berpuas hati menjadi seperti tuannya. Jika ketua keluarga dipanggil Beelzebul, betapa lagi ahli-ahli keluarganya! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‘Jangan takut akan manusia. Segala yang tersembunyi akan dinyatakan; setiap rahsia akan didedahkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Apa yang Kukatakan kepadamu secara sulit, sampaikanlah kepada orang ramai. Apa yang dibisikkan di telingamu, umumkanlah merata-rata. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jangan takut akan mereka yang hanya dapat membunuh jasad tetapi tidak berkuasa memusnahkan jiwa. Takutilah Allah yang berkuasa memusnahkan jasad dan jiwa di dalam neraka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bukankah dua ekor burung pipit dibeli dengan harga satu sen? Namun tidak seekor pun jatuh ke tanah tanpa izin Bapamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Setiap helai rambut di kepalamu pun dihitung. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Oleh itu, usahlah takut. Di sisi Allah, kamu lebih berharga daripada burung pipit! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Sesiapa mengakui-Ku di hadapan orang ramai, akan Kuakui di hadirat Bapa-Ku di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sebaliknya, sesiapa yang menyangkal-Ku di hadapan orang ramai, akan Kusangkal di hadirat Bapa-Ku di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘Jangan sangka Aku datang untuk membawa damai ke dunia. Aku datang bukan untuk membawa damai ke dunia melainkan pedang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Dengan kedatangan-Ku, “anak lelaki melawan bapanya, anak perempuan melawan ibunya, dan menantu perempuan melawan ibu mertuanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ahli keluarganya sendiri akan menjadi musuhnya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘Sesiapa yang lebih mengasihi bapa atau ibunya daripada-Ku, tidak layak menjadi pengikut-Ku. Begitu juga, sesiapa yang lebih mengasihi anaknya daripada-Ku, tidak layak menjadi pengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sesiapa yang enggan memikul salibnya dan mengikut-Ku, tidak layak menjadi pengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sesiapa yang mempertahankan hidupnya akan kehilangannya, dan sesiapa yang kehilangan hidupnya kerana menjadi pengikut-Ku akan mendapat hidup kekal. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‘Sesiapa yang menyambutmu, menyambut-Ku juga, dan sesiapa yang menyambut-Ku menyambut Dia yang mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sesiapa yang menyambut seorang pesuruh Allah kerana dia pesuruh Allah, akan menerima ganjaran seorang pesuruh Allah. Sesiapa yang menyambut seorang yang benar kerana dia seorang yang benar, akan menerima ganjaran seorang yang benar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ingatlah: Sesiapa yang memberi minum walau hanya air sejuk kepada seorang pengikut-Ku yang paling rendah pun kerana dia pengikut-Ku, akan menerima ganjaran.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Setelah Isa memberi petunjuk kepada dua belas orang pengikut-Nya itu, Dia meninggalkan tempat itu lalu pergi mengajar dan menyampaikan perkhabaran daripada Allah di bandar-bandar berhampiran. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yahya Pengimad yang meringkuk di penjara mendengar tentang apa yang dilakukan oleh al-Masih. Yahya pun menyuruh beberapa orang pengikutnya untuk pergi berjumpa Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mereka bertanya, ‘Adakah Tuan ini orang yang dijanjikan Allah akan datang, atau perlukah kami menunggu orang lain?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Isa menjawab, ‘Pulanglah, beritahu Yahya segala yang kamu dengar dan lihat: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Orang buta melihat, orang lumpuh berjalan, orang berpenyakit kusta sembuh, orang tuli mendengar, orang mati dihidupkan semula, dan berita baik daripada Allah disampaikan kepada orang miskin. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Berbahagialah orang yang tidak meragui-Ku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ketika pengikut-pengikut Yahya beredar dari situ, Isa berkata kepada orang ramai tentang Yahya: ‘Apabila kamu mendapatkan Yahya di gurun, apakah yang ingin kamu lihat? Sehelai rumput mensiang yang ditiup angin? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kamu ke sana hendak melihat apa? Seorang yang berpakaian mewah? Orang yang berpakaian demikian tinggal di istana. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Katakanlah, kamu ke situ untuk melihat apa? Seorang nabi? Benar, malah lebih daripada nabi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tentang orang itulah telah tersurat dalam ayat Kitab Suci: “Aku akan menghantar utusan-Ku untuk mendahului-Mu, dialah yang akan menyediakan jalan bagi-Mu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","‘Sesungguhnya Aku berkata kepadamu bahawa di antara mereka yang dilahirkan oleh perempuan, belum pernah muncul seorang pun yang lebih besar daripada Yahya. Ketahuilah: Yahya Pengimad lebih utama daripada semua orang yang pernah hidup di dunia. Namun begitu, orang yang paling rendah antara yang menikmati kerajaan syurga lebih utama daripadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sejak kedatangan Yahya Pengimad hinggalah ke hari ini, kerajaan syurga telah diserang oleh orang yang ingin menguasainya melalui kekerasan dan keganasan, dan orang yang ganas berusaha menguasainya dengan kekerasan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kerana semua nabi termasuk Musa dengan Taurat bernubuat hingga datangnya Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sekiranya kamu mahu percaya akan perkhabaran mereka, Yahya itulah Ilyas yang telah dinubuatkan kedatangannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jika kamu ada telinga, dengarlah! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘Dengan apakah dapat Kubandingkan manusia zaman ini? Mereka ibarat anak-anak yang duduk di pasar, satu kumpulan berseru kepada yang lain: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Kami memainkan seruling lagu perkahwinan untukmu, tetapi kamu enggan menari; kami menyanyi lagu ratap, tetapi kamu enggan menangis.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","‘Ketika Yahya datang, dia berpuasa dan tidak minum air anggur, lalu semua orang berkata, “Dia dirasuk roh iblis!” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ketika Putera Insan datang, Dia makan dan minum, lalu semua orang berkata, “Lihatlah dia ini: gelojoh, pemabuk, kawan kepada pemungut cukai dan orang berdosa!” Namun demikian, kebijaksanaan terbukti benar dengan perbuatannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Isa mengecam bandar-bandar tempat Dia paling banyak melakukan mukjizat, kerana penduduknya enggan bertaubat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","‘Malangnya kamu, hai Korazin! Malangnya kamu, hai Baitsaida! Sekiranya mukjizat-mukjizat yang Kulakukan di kalanganmu itu Kulakukan di Tirus dan Sidon, tentu sudah lama orang di situ bertaubat, dengan memakai kain guni dan membubuh abu di kepala. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ketahuilah: Pada hari penghakiman itu kelak, Allah akan lebih mengasihani penduduk Tirus dan Sidon daripada kamu! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kamu juga, hai Kapernaum! Ingin kamu tinggikan diri sampai ke syurga? Kamu akan dihumbankan ke neraka! Kalaulah mukjizat-mukjizat yang Kulakukan di kalanganmu itu Kulakukan di Sodom, tentu Sodom masih ada hingga kini! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aku berkata kepadamu: Ketahuilah, pada hari itu kelak, hukuman ke atas Sodom lebih ringan daripada hukuman yang akan kamu terima!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Selepas itu Isa mengucap syukur, ‘Ya Bapa, Tuhan langit dan bumi! Aku bersyukur kepada-Mu, kerana apa yang Kaurahsiakan daripada cerdik pandai, Kautunjukkan kepada kanak-kanak kecil, orang yang tidak terpelajar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ya Bapa, memang inilah kehendak-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","‘Bapa-Ku telah menyerahkan segala-galanya kepada-Ku. Tiada yang mengenal Putera kecuali Bapa, dan tiada yang mengenal Bapa kecuali Putera dan orang yang diberitahu oleh Putera tentang Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","‘Marilah ke sisi-Ku, wahai kamu yang lelah memikul beban berat; Aku akan membebaskanmu daripada bebanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ikutlah perintah-Ku dan terima ajaran-Ku, kerana Aku ini lemah lembut dan rendah hati, maka jiwamu akan sejahtera. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Perintah yang Kuberi kepadamu mudah diturut, dan beban yang Kuberi mudah dipikul.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pada suatu hari Sabat, Isa berjalan melalui ladang gandum. Para pengikut-Nya lapar lalu memetik dan memakan gandum. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Apabila orang Farisi melihat perkara ini, mereka berkata kepada Isa, ‘Lihatlah, pengikut-Mu melakukan sesuatu yang dilarang pada hari Sabat!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Isa menjawab, ‘Tidakkah kamu membaca apa yang dilakukan oleh Daud apabila dia dan anak buahnya lapar? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Daud masuk ke dalam khemah Allah, lalu dia dan anak buahnya makan roti persembahan, meskipun perbuatan itu dilarang iaitu hanya imam dibenarkan makan roti itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tidakkah kamu baca dalam Taurat Musa betapa setiap hari Sabat imam di rumah ibadat melanggar hukum hari Sabat? Namun, mereka tidak disalahkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aku berkata kepadamu: Di sini ada yang lebih besar daripada rumah ibadat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ada tersurat: “Aku menghendaki belas kasihan, bukan korban binatang.” Jika kamu benar-benar memahami ayat itu, tentulah tidak kamu salahkan orang yang tidak bersalah; ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","kerana Putera Insan adalah Junjungan atas hari Sabat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Isa beredar dari situ lalu pergi ke sebuah saumaah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Di situ ada seorang yang lumpuh sebelah tangannya. Beberapa orang di sana cuba mencari salah Isa supaya dapat mendakwa-Nya. Mereka bertanya kepada-Nya, ‘Tidakkah menyembuhkan orang pada hari Sabat melanggar hukum?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Isa menjawab, ‘Apakah yang akan kamu lakukan jika seorang daripadamu mempunyai seekor domba, dan pada hari Sabat domba itu terjatuh ke dalam lubang yang dalam? Tentulah kamu berusaha menyelamatkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Betapa lebih berharganya manusia daripada domba? Oleh itu, berbuat baik pada hari Sabat tidak melanggar hukum.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Setelah itu, Isa berkata kepada orang yang lumpuh sebelah tangannya itu, ‘Hulurkanlah tanganmu.’ Orang itu pun menghulurkan tangannya yang lumpuh lalu pulih sama seperti tangan yang sebelahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ketika itu orang Farisi beredar dari situ lalu berpakat hendak membunuh Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Apabila Isa mengetahui pakatan itu, Dia pun meninggalkan tempat itu. Ramai orang mengikut-Nya dan ramai yang disembuhkan-Nya daripada pelbagai penyakit. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Dia berpesan kepada mereka supaya jangan memberitahu sesiapa tentang-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Dengan demikian terjadilah firman Allah melalui Nabi Yasyaya: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Inilah hamba-Ku yang telah Kupilih, Yang Kukasihi dan Kuredai Roh-Ku akan Kuanugerahkan kepada-Nya, dan keadilan-Ku akan diisytiharkan-Nya kepada semua bangsa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dia tidak akan bertengkar atau membentak, ataupun bersuara lantang di jalan raya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Buluh yang halus terkulai tidak akan dipatahkan-Nya, Pelita yang malap tidak akan dipadamkan-Nya, Dia akan berjuang sehingga tercapai keadilan, ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bangsa-bangsa asing akan bersandar harap kepada-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Setelah itu seorang yang buta dan bisu kerana dirasuk roh iblis dibawa kepada Isa lalu disembuhkan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Orang ramai di situ ketakjuban lalu bertanya sama sendiri, ‘Mungkinkah dia ini Anak Daud?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Apabila orang Farisi mendengar tentang itu, mereka menjawab, ‘Dia dapat menghalau roh-roh iblis kerana diberi kuasa oleh Beelzebul, ketua roh iblis.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Isa mengetahui isi hati orang Farisi itu lalu berkata kepada mereka, ‘Negeri yang berpecah kepada beberapa bahagian yang bermusuhan tidak akan wujud lama. Bandar atau keluarga yang berpecah dan berlawan sesama sendiri akan hancur lebur. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Begitu juga, andainya Iblis mengusir Iblis, dia akan berpecah belah, dan bagaimanakah kerajaannya dapat bertahan? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kamu berkata Aku menghalau roh-roh iblis kerana diberi kuasa oleh Beelzebul. Kalau begitu, siapa yang memberikan kuasa menghalau roh-roh iblis kepada pengikut-pengikutmu? Oleh itu merekalah yang akan menjadi hakimmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tetapi jika Aku menghalau roh-roh iblis dengan Roh Allah, maka sesungguhnya kerajaan Allah sudah mula bertapak di kalanganmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‘Atau bagaimanakah orang dapat memasuki rumah seorang yang gagah dan merampas harta bendanya sekiranya orang yang gagah itu tidak diikat terlebih dahulu? Selepas itu, barulah dia dapat merompak rumahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‘Jika seseorang tidak berpihak kepada-Ku, ini bererti dia menentang-Ku. Jika seseorang tidak mengumpulkan bersama-Ku, ini bererti dia mencerai-beraikan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ketahuilah: Orang yang berbuat dosa atau mengucapkan kata-kata kufur akan diampuni, tetapi mereka yang mengkufuri Roh Suci tidak akan diampuni. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Orang yang menentang Putera Insan dengan kata-katanya dapat diampuni, tetapi mereka yang menghina Roh Suci tidak dapat diampuni, baik di dunia mahupun di akhirat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","‘Jika kamu ingin mendapat buah yang baik, kamu harus mempunyai pokok yang baik. Jika pokok tidak baik, buahnya pun tidak baik. Baik tidaknya pokok diketahui daripada buahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hai kamu yang seperti ular berbisa, bagaimana dapat kamu tuturkan perkara yang baik sedangkan dirimu jahat? Orang mengucapkan apa yang terkandung dalam hatinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Seorang yang baik menuturkan hal-hal baik kerana hatinya penuh kebaikan. Seorang yang jahat menuturkan hal-hal jahat kerana hatinya penuh kejahatan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aku berkata kepadamu: Pada hari penghakiman, setiap orang harus mempertanggungjawabkan setiap katanya yang tidak sewajarnya dituturkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kata-katamu sendiri akan dijadikan ukuran sama ada kamu bersalah atau tidak.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Selepas itu beberapa orang guru Taurat dan orang Farisi berkata kepada Isa, ‘Tuan Guru, kami ingin melihat suatu alamat mukjizat daripada-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tetapi Isa menjawab, ‘Manusia zaman durjana dan tidak setia ini ingin melihat alamat mukjizat. Tetapi satu alamat pun tidak akan ditunjukkan kepadanya kecuali alamat Nabi Yunus. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sebagaimana Yunus tinggal tiga hari tiga malam di dalam perut ikan besar, begitu jugalah Putera Insan akan tinggal tiga hari tiga malam di dalam perut bumi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pada hari akhir, penduduk Niniwe akan bangkit bersama kamu, orang zaman ini. Mereka akan menuduhmu, kerana apabila mereka mendengar perkhabaran yang disampaikan oleh Yunus, mereka telah bertaubat; sedangkan kamu tidak, pada hal di hadapanmu sekarang ada yang lebih besar daripada Yunus. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pada hari akhir, Ratu Syeba dari Selatan akan bangkit bersama kamu, orang zaman ini. Ratu itu akan menuduhmu, kerana dia telah datang dari hujung bumi untuk mendengar ajaran Raja Sulaiman yang bijaksana; sedangkan kamu tidak mendengar ajaran daripada yang ada di hadapanmu sekarang dan yang lebih besar daripada Raja Sulaiman. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‘Apabila roh durjana keluar daripada tubuh seseorang, roh itu akan menjelajahi kawasan yang tandus untuk mencari tempat tinggal. Sekiranya tempat tinggal tidak ditemuinya, ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","roh itu akan berkata, “Aku akan pulang ke rumah yang telah kutinggalkan.” Roh itu pun pulang dan mendapati rumah itu kosong, bersih dan kemas. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Roh itu lalu pergi memanggil tujuh roh lain yang lebih durjana daripadanya. Semuanya memasuki tubuh orang itu dan menetap di situ. Akhirnya keadaan orang itu lebih teruk daripada dahulu. Inilah yang akan terjadi kepada manusia durjana zaman ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sedang Isa berbicara dengan orang ramai, ibu dan saudara-saudara-Nya datang berdiri di luar kerana hendak bercakap dengan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Seorang daripada orang ramai itu memberitahu Isa, ‘Ibu dan saudara-saudara lelaki-Mu hendak bercakap dengan-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tetapi Isa menjawab, ‘Siapakah ibu-Ku? Siapakah saudara-saudara lelaki-Ku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dia menunjuk kepada para pengikut-Nya lalu berkata, ‘Inilah ibu-Ku dan saudara-saudara lelaki-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sesiapa yang melakukan kehendak Bapa-Ku yang di syurga, merekalah saudara lelaki, saudara perempuan dan ibu-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pada hari itu juga, Isa keluar dari rumah lalu duduk di tepi laut. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Sungguh ramai orang datang berhimpun mendapatkan-Nya. Isa pun masuk ke dalam sebuah perahu dan duduk di situ manakala orang ramai itu berdiri di pantai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Isa berbicara kepada mereka melalui ibarat: ‘Seorang penyemai benih telah pergi menabur. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sebahagian benih yang ditaburnya jatuh di tepi jalan lalu dimakan burung. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sesetengahnya jatuh di tempat-tempat berbatu yang tidak banyak tanahnya. Benih itu segera bercambah kerana tanahnya tidak dalam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tetapi apabila matahari naik, tunas-tunas itu kering kepanasan, lantas layu kerana tidak berakar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ada pula yang jatuh di semak duri, lalu tewas ditindas tumbuhan duri. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Namun, ada yang jatuh di tanah yang subur dan memberikan hasil: seratus kali ganda, enam puluh kali ganda, atau tiga puluh kali ganda. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sesiapa yang ada telinga, dengarlah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Para pengikut Isa datang bertanya kepada-Nya, ‘Mengapa Junjungan bercakap kepada mereka melalui ibarat?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Isa menjawab, ‘Kamu telah diberi anugerah untuk mengetahui rahsia kerajaan syurga, tetapi mereka tidak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sesiapa yang mempunyai sesuatu akan diberi lebih banyak lagi, sehingga melimpah-limpah. Sebaliknya, sesiapa yang tidak mempunyai sesuatu, sedikit yang ada padanya pun akan diambil. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aku bercakap kepada mereka melalui ibarat: ‘ “Kerana mereka melihat tetapi tidak nampak, mereka mendengar tetapi tidak mengerti.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","‘Keadaan mereka ini tepat seperti terdapat dalam nubuat Nabi Yasyaya: ‘ “Kamu terus mendengar tetapi tidak mengerti; kamu akan terus melihat tetapi tidak mengetahui. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kerana hati umat ini telah buntu, mereka pekakkan telinga, dan pejamkan mata. Kalau tidak demikian, mereka tentu melihat dengan mata, mendengar dengan telinga, dan mengerti dengan hati, lalu berpaling kepada-Ku dan Aku menyembuhkan mereka.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‘Tetapi berbahagialah matamu kerana melihat, dan telingamu kerana mendengar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sesungguhnya, Kukatakan kepadamu, ramai nabi dan orang yang benar berhasrat melihat apa yang kamu lihat dan mendengar apa yang kamu dengar, tetapi hasrat mereka tidak tercapai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‘Oleh itu dengarlah maksud ibarat penyemai benih: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Apabila seseorang mendengar perkhabaran kerajaan Allah dan tidak memahaminya, akan datanglah si durjana menyambar apa yang telah ditabur dalam hatinya. Orang inilah yang menerima benih di tepi jalan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Orang yang menerima benih di tempat-tempat berbatu pula bermaksud orang yang mendengar perkhabaran itu dan terus menerimanya dengan sukacita. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tetapi perkhabaran itu tidak berakar dalam dirinya, maka hanya tahan seketika. Sebaik-baik dia menghadapi kesusahan atau penganiayaan kerana perkhabaran itu, imannya pun luntur. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Orang yang menerima benih di semak duri ialah orang yang mendengar perkhabaran itu, tetapi kerunsingan tentang hal-hal duniawi dan godaan harta kekayaan mengasyikkannya lalu dia tidak dapat menghasilkan apa-apa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tetapi orang yang menerima benih di tanah subur ialah orang yang mendengar perkhabaran itu dan memahaminya lalu menghasilkan seratus kali, enam puluh kali atau tiga puluh kali ganda.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Isa menceritakan satu ibarat lagi: ‘Kerajaan syurga ibarat orang menabur benih yang baik di ladangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pada waktu malam apabila semua orang sedang tidur, musuhnya datang menanam lalang di antara gandum itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Setelah gandum itu membesar, lalang pun tumbuh juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","‘Hamba peladang berkata, “Tuan menabur benih yang baik, dari mana pula datangnya lalang itu?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Jawab peladang itu, “Ini perbuatan musuh.” ‘Hamba itu bertanya, “Adakah tuan hendak kami mencabut lalang itu?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘ “Tidak,” jawab peladang itu, “takut tercabut gandum juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Biarkanlah lalang tumbuh di antara gandum hingga sampai musim menuai. Ketika itu aku akan menyuruh orang yang menuai nanti mencabut lalang dahulu, mengikat dan membakarnya. Selepas itu barulah gandum dituai dan disimpan di dalam jelapang.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Seterusnya Isa mengisahkan ibarat demikian: ‘Kerajaan syurga seperti sebutir biji sesawi yang dibawa oleh seseorang untuk ditanam di ladangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Biji sesawi itu paling kecil di antara semua benih, tetapi apabila tumbuh, menjadi tumbuhan yang lebih besar daripada semua tumbuhan lain sehingga menjadi sebatang pokok tempat burung membuat sarang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kemudian Isa menceritakan suatu ibarat lagi, ‘Kerajaan syurga seperti ini: Seorang wanita mencampurkan sedikit ragi dengan tiga sukat tepung sehingga adunan itu naik.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Demikianlah Isa mengajar orang ramai melalui ibarat. Tidak ada satu ajaran yang disampaikan-Nya kepada mereka tanpa ibarat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Maka terjadilah apa yang dikatakan oleh Nabi: ‘Aku akan bertutur kepada mereka melalui ibarat, Aku akan menyampaikan kepada mereka hal-hal yang dirahsiakan sejak dunia dicipta.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Selepas itu Isa meninggalkan orang ramai lalu masuk ke rumah. Pengikut-pengikut-Nya datang kepada-Nya lalu berkata, ‘Terangkanlah kepada kami maksud ibarat lalang di antara gandum itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Isa berkata, ‘Orang yang menabur benih baik itu Putera Insan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ladang itu dunia; benih yang baik itu orang yang menjadi umat Allah manakala lalang ialah orang yang menyebelahi si durjana. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Musuh yang menanam lalang itu Iblis. Masa menuai ialah hari akhir dan para penuai itu malaikat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","‘Sebagaimana lalang dikumpulkan dan dibakar, demikianlah halnya akan terjadi pada hari akhir. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Putera Insan akan memerintahkan malaikat-Nya mengumpulkan semua di kalangan umat-Nya yang melakukan kejahatan dan yang menyebabkan orang berdosa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mereka akan dihumbankan ke dalam relau yang berapi-api, tempat ratapan dan kertakan gigi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Orang yang benar akan bersinar laksana matahari dalam kerajaan Allah, Bapa mereka. Jika kamu mempunyai telinga, dengarlah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","‘Kerajaan syurga ibarat harta yang tersembunyi di dalam sebidang tanah. Seseorang telah menjumpainya lalu menyembunyikannya semula. Setelah itu dengan penuh sukacita dia menjual segala yang dimilikinya lalu membeli tanah itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","‘Kerajaan syurga juga umpama seorang saudagar yang mencari mutiara yang paling tinggi nilainya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Apabila dia menjumpai mutiara yang paling bernilai, dia pun menjual semua yang dimilikinya lalu membeli mutiara itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","‘Kerajaan syurga juga seperti pukat yang dilabuhkan ke dalam laut lalu mendapat aneka jenis ikan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Setelah sarat dan ditarik ke darat, para nelayan memeriksanya, lalu menyimpan yang baik dan membuang yang tidak baik. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Demikianlah yang akan terjadi pada akhir zaman. Malaikat akan datang mengasingkan orang durjana daripada orang yang benar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Orang durjana itu akan dihumbankan ke dalam relau yang berapi-api, tempat ratapan dan kertakan gigi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","‘Fahamkah kamu hal-hal ini?’ Isa bertanya kepada para pengikut-Nya. ‘Kami faham,’ jawab mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Isa berkata, ‘Oleh itu setiap guru Taurat yang telah menerima ajaran tentang kerajaan syurga adalah seperti ketua rumah yang mengeluarkan barang baru dan barang lama simpanannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Setelah itu, Isa pun beredar dari situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Lalu dia pulang ke kampung halamannya. Di situ Dia mengajar di saumaah. Orang yang mendengar-Nya hairan lalu bertanya, ‘Dari manakah dia mendapat kebijaksanaan begini? Dari manakah dia mendapat kuasa melakukan mukjizat? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bukankah dia anak tukang kayu? Bukankah Maryam itu ibunya, dan Yakobus, Yusuf, Simon serta Yudas itu saudaranya? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bukankah saudara-saudara perempuannya ada bersama kita? Dari manakah dia mendapat semua ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Dengan demikian mereka marah dengan-Nya. Isa berkata kepada mereka, ‘Seorang Nabi dihormati kecuali di kampung halamannya dan di kalangan kaum keluarganya sendiri.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Isa tidak banyak melakukan mukjizat di situ kerana mereka tidak percaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pada masa itu Herodes, raja wilayah, mendengar tentang Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes berkata kepada orang di bawahnya, ‘Ini tentu Yahya Pengimad. Dia telah bangkit daripada kematian! Sebab itulah dia ada kuasa melakukan mukjizat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Sebelum itu Herodes telah memerintahkan supaya Yahya ditangkap, diikat dan dipenjarakan, disebabkan Herodias, isteri saudaranya Filipus. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yahya telah memberitahu Herodes, ‘Tuan bersalah mengahwini Herodias’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes hendak membunuh Yahya tetapi takut kerana rakyat menganggapnya seorang nabi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pada hari jadi Herodes, anak perempuan Herodias menari di hadapan majlis. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Oleh sebab terlalu menikmati tarian itu, Herodes bersumpah akan memberikan apa saja yang diminta oleh gadis itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Disuruh oleh ibunya, gadis itu memohon kepala Yahya Pengimad di atas talam pada waktu itu juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Walaupun dengan berat hati, Herodes terpaksa menunaikan permintaan itu kerana telah bersumpah di hadapan majlisnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Herodes pun memerintahkan orang pergi memancung kepala Yahya di penjara. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kepala Yahya diletakkan di atas talam dan diberikan kepada gadis itu. Gadis itu menyerahkan kepala Yahya kepada ibunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Selepas itu pengikut Yahya datang mengambil jenazahnya dan mengebumikannya. Kemudian mereka pergi memberitahu Isa tentangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sebaik-baik mendengar tentang Yahya, Isa menaiki perahu dan pergi seorang diri ke suatu tempat sunyi. Namun, orang ramai mendapat tahu lalu mengikut Isa melalui jalan darat dari kota. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Setelah Isa turun dari perahu dan melihat mereka, hati-Nya berasa kasihan lalu Dia menyembuhkan orang yang sakit di kalangan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Apabila menjelang petang, para pengikut Isa mendapatkan-Nya lalu berkata, ‘Hari sudah hampir malam dan kawasan ini terpencil. Suruhlah orang yang ramai ini pergi, supaya dapat membeli makanan di pekan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tetapi Isa menjawab, ‘Mereka tidak usah pergi. Berilah mereka makan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kata para pengikut Isa, ‘Kita hanya ada lima buku roti dan dua ekor ikan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Isa berkata, ‘Bawalah makanan itu kepada-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dia menyuruh orang ramai itu duduk di atas rumput. Dia mengambil makanan itu dan menengadah ke langit mengucap syukur kepada Allah. Kemudian Dia memecah-mecahkan roti itu dan menghulurkannya kepada para pengikut-Nya supaya diberikan kepada orang ramai itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Setiap orang makan sehingga kenyang dan lebihan yang dikumpulkan oleh para pengikut Isa sebanyak dua belas bakul. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jumlah yang makan kira-kira lima ribu orang lelaki, belum dihitung wanita dan kanak-kanak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Setelah itu Isa menyuruh para pengikut-Nya menaiki perahu dan pergi ke seberang dahulu sementara Dia menyuruh orang ramai itu pulang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Setelah menyuruh mereka pulang, Isa naik ke bukit seorang diri lalu berdoa. Apabila hari sudah lewat petang, Isa berada di situ seorang diri. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ketika itu perahu yang dinaiki oleh para pengikut-Nya sudah jauh ke tengah, terumbang-ambing kerana angin berhembus dari arah bertentangan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Antara dinihari dan pagi, Isa berjalan di atas air menghampiri mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Apabila mereka melihat-Nya berjalan di atas air, mereka ketakutan lalu menjerit, ‘Hantu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Isa segera berkata kepada mereka, ‘Tenanglah. Aku Isa. Jangan takut.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrus berkata, ‘Junjungan, jika benar Engkau, suruhlah aku berjalan di atas air mendapatkan-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","‘Marilah,’ sahut Isa. Petrus turun dari perahu dan mula berjalan di atas air ke arah Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tetapi apabila menyedari betapa kencangnya angin, Petrus berasa takut lalu mula tenggelam. ‘Junjungan! Selamatkan aku!’ serunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Isa segera menghulurkan tangan memegangnya lalu berkata, ‘Engkau yang kurang percaya, mengapa engkau ragu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kedua-dua mereka menaiki perahu dan angin pun tiada. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Selepas itu para pengikut Isa yang di dalam perahu menyembah-Nya sambil berkata, ‘Sesungguhnya Engkaulah Putera Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mereka menyeberang ke Genesaret. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Orang di situ mengenal Isa lalu menyebarkan berita kedatangan-Nya ke serata daerah itu. Ramailah dibawa orang sakit kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mereka merayu Isa supaya mengizinkan orang sakit menyentuh hujung jubah-Nya. Dengan sentuhan itu sahaja pun mereka sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Setelah itu beberapa orang Farisi dan guru Taurat dari Baitulmaqdis datang mendapatkan Isa lalu bertanya, ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","‘Mengapa pengikut-Mu melanggar adat nenek moyang kita? Mereka tidak membasuh tangan sebelum makan!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Isa menjawab, ‘Mengapa kamu membelakangi perintah Allah demi mematuhi adat istiadatmu? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Allah berfirman, “Hormatilah ibu bapamu” dan “Orang yang mencaci ibu bapanya mesti dihukum mati.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sebaliknya kamu mengajar, “Jika seseorang berkata kepada ibu bapanya, ‘Apa yang patut kugunakan untuk menolong ayah dan ibu, telah kupersembahkan kepada Allah,’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","maka tidak perlulah orang itu menghormati ibu bapanya. Demikianlah kamu menyatakan Firman Allah tidak berlaku atas sebab adat istiadatmu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kamu munafik! Benarlah nubuat Nabi Yasyaya tentangmu: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Allah berfirman: Bangsa ini menghormati-Ku dengan kata-kata tetapi hati mereka jauh daripada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Sia-sialah mereka menyembah-Ku, sedangkan ajaran yang mereka ajarkan ialah peraturan manusia.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kemudian Isa memanggil orang ramai itu lalu berkata kepada mereka, ‘Dengar dan fahamlah! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Apa yang masuk ke mulut seseorang tidak menajiskannya, tetapi apa yang keluar dari mulutnya, itulah yang menajiskannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Selepas itu para pengikut Isa mendapatkan-Nya dan berkata, ‘Junjungan, tahukah Engkau bahawa orang Farisi tersinggung dengan kata-kata-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Isa menjawab, ‘Segala tanaman selain yang ditanam oleh Bapa-Ku di syurga akan dicabut. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jangan hiraukan orang Farisi. Mereka itu orang buta yang memimpin orang buta. Apabila orang buta memimpin orang buta, kedua-duanya masuk ke dalam parit.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrus berkata, ‘Terangkanlah maksud ibarat tadi kepada kami.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Isa berkata kepada para pengikut-Nya, ‘Kamu masih tidak faham. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tidakkah kamu mengerti? Apa yang masuk ke dalam mulut seseorang turun ke perut lalu keluar semula. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sebaliknya, apa yang keluar dari mulut datang dari hati, dan inilah yang menajiskan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dari hati timbul fikiran jahat yang mendorong seseorang membunuh, berzina, berbuat cabul, mencuri, memberikan kesaksian palsu, dan memfitnah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Segala itulah yang menajiskan, bukan makan dengan tidak membasuh tangan mengikut adat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Isa beredar dari situ, dan pergi ke kawasan berhampiran bandar Tirus dan Sidon. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Seorang wanita Kanaan yang tinggal di situ datang mendapatkan Isa sambil berseru, ‘Wahai Tuan, Anak Daud! Kasihanilah aku! Anak perempuanku dirasuk roh iblis, dan menderita!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Isa diam tidak menjawab. Para pengikut-Nya memohon kepada-Nya, ‘Suruhlah wanita itu pergi. Dia mengikut kita meraung-raung.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Isa berkata kepada wanita itu, ‘Aku diutus khusus kepada orang Israel yang seperti domba sesat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wanita itu mendekati Isa dan menyembah-Nya sambil berkata, ‘Tuan, tolonglah aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Isa menjawab, ‘Tidaklah wajar mengambil makanan anak-anak dan mencampakkannya kepada anak-anak anjing.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","‘Benar, Tuan,’ balas wanita itu, ‘tetapi anak-anak anjing pun makan sisa yang jatuh dari meja tuannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Oleh yang demikian Isa berkata kepadanya, ‘Kamu seorang wanita yang teguh iman. Apa yang kamu inginkan itu akan berlaku.’ Serta-merta anak wanita itu pulih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Isa beredar dari situ lalu berjalan menyusur pesisiran Laut Galilea. Setelah itu Dia mendaki sebuah bukit dan duduk di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ramailah yang datang mendapatkan-Nya, membawa orang yang tempang, buta, lumpuh, bisu dan yang mengidap pelbagai penyakit. Isa menyembuhkan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Orang ramai tercengang melihat yang bisu bercakap, yang cacat dipulihkan, yang tempang berjalan, dan yang buta melihat, lalu mereka memuji Tuhan orang Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Isa memanggil para pengikut-Nya lalu berkata, ‘Aku kasihan kepada orang ramai ini. Sudah tiga hari mereka bersama-Ku; sekarang mereka kehabisan makanan. Aku tidak mahu menyuruh mereka pulang dengan perut kosong, kalau-kalau pengsan nanti di tengah jalan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Para pengikut-Nya berkata, ‘Di manakah dapat kami cari makanan yang cukup untuk orang seramai itu sedangkan kawasan ini terpencil?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Isa bertanya, ‘Berapa banyak roti yang ada padamu?’ ‘Tujuh buku,’ sahut mereka, ‘dan beberapa ekor ikan kecil.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Isa menyuruh orang ramai itu duduk di atas tanah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Dia mengambil tujuh buku roti dan ikan itu, mengucap syukur kepada Allah lalu membahagikan makanan itu dan menghulurkannya kepada para pengikut-Nya untuk diberikan kepada orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Setiap orang makan sehingga kenyang, malah lebihan makanan yang dikumpulkan oleh para pengikut-Nya tujuh bakul. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jumlah yang makan empat ribu orang lelaki; belum dikira wanita dan kanak-kanak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Setelah itu Isa menyuruh orang ramai itu pulang, lalu Dia berperahu ke daerah Magadan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Beberapa orang Farisi dan Saduki datang kepada Isa. Untuk menduga Isa, mereka meminta-Nya melakukan mukjizat sebagai bukti Dia datang daripada Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Isa menjawab, ‘Ketika matahari masuk, kamu berkata, “Cuaca baik, kerana langit merah.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pada waktu pagi, kamu berkata, “Cuaca buruk nanti, kerana langit merah mengancam.” Munafik! Kamu dapat meramalkan cuaca dengan melihat alamat-alamat di langit, tetapi kamu tidak dapat memahami alamat-alamat zaman ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Manusia zaman yang durjana dan derhaka ini ingin melihat alamat mukjizat. Tetapi satu alamat pun tidak akan ditunjukkannya kecuali alamat Nabi Yunus.’ Setelah berkata demikian, Isa pun pergi dari situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ketika para pengikut Isa berperahu ke seberang, mereka terlupa membawa roti. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Isa berkata kepada mereka, ‘Berhati-hatilah dengan ragi orang Farisi dan Saduki.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mereka mula berkata-kata sesama sendiri, ‘Dia berkata begitu kerana kita tidak membawa roti.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Isa tahu apa yang dikatakan oleh mereka. Dia berkata, ‘Mengapa kamu persoalkan hal tidak membawa roti? Tipis benar kepercayaanmu! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Belum fahamkah kamu? Tidakkah kamu ingat bagaimana Aku membahagikan lima buku roti antara lima ribu orang? Berapa bakul lebihan makanan yang kamu kumpulkan? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bagaimana pula dengan tujuh buku roti yang Kubahagikan antara empat ribu orang? Berapa bakul lebihan makanan yang kamu kumpulkan? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mengapa kamu tidak mengerti bahawa Aku tidak bercakap tentang roti. Berhati-hatilah dengan ragi orang Farisi dan Saduki.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Barulah mereka faham bahawa maksud Isa bukannya ragi penaik roti tetapi ajaran orang Farisi dan Saduki. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Isa pergi ke daerah berhampiran kota Kaisarea Filipi. Dia bertanya kepada para pengikut-Nya, ‘Menurut kata orang, siapakah Putera Insan ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mereka menjawab, ‘Ada yang berkata Yahya Pengimad; ada yang berkata Ilyas; ada pula yang berkata Yeremia atau nabi lain.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Isa bertanya, ‘Menurut kamu, siapakah Aku ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus menjawab, ‘Junjungan, Engkau ialah al-Masih, Putera Allah Yang Hidup.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Isa berkata, ‘Berbahagialah engkau, Simon anak Yunus! Yang memberitahumu bukannya manusia tetapi Bapa-Ku di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Oleh itu ketahuilah engkau Petrus, batu yang kukuh, dengan asas batu inilah akan Kubina jemaah-Ku. Maut pun tidak dapat merobohkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aku akan memberikan kunci kerajaan syurga kepadamu. Apa yang kauikat di dunia akan diikat juga di syurga. Apa yang kauuraikan di dunia akan diuraikan juga di syurga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Selepas itu Isa berpesan kepada para pengikut-Nya supaya jangan memberitahu sesiapa bahawa Dia al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sejak itu, Isa mula berkata terus-terang kepada para pengikut-Nya bahawa Dia harus pergi ke Baitulmaqdis dan menanggung banyak penderitaan yang disebabkan oleh pemimpin masyarakat, ketua imam, dan guru Taurat. Dia akan dibunuh, tetapi pada hari ketiga akan dibangkitkan semula. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petrus menarik Isa ke tepi lalu menegur-Nya, ‘Junjungan, semoga Allah jauhi semua itu daripada-Mu! Semua itu tidak boleh berlaku kepada-Mu, Junjungan!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Isa berpaling sambil berkata kepada Petrus, ‘Pergilah dari sini, Iblis! Engkau menyakitkan hati-Ku kerana fikiranmu itu fikiran manusia, bukan fikiran Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kemudian Isa berkata kepada para pengikut-Nya, ‘Jika sesiapa ingin mengikut-Ku, lupakan kepentingan diri, pikul salib dan ikut Aku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sesiapa yang mempertahankan hidupnya akan kehilangan hidup, dan sesiapa yang mengorbankan hidupnya kerana-Ku akan memperoleh hidup. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Apalah gunanya jika seseorang memperolehi seluruh dunia tetapi kehilangan hidupnya? Apakah yang dapat diberinya sebagai ganti untuk hidup itu? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sudah hampir waktunya Putera Insan datang bersama para malaikat-Nya dengan kemuliaan Bapa-Nya. Pada masa itu Dia akan memberi balasan kepada setiap orang menurut perbuatannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sesungguhnya Aku berkata kepadamu, beberapa orang di sini tidak akan menemui maut sebelum melihat Putera Insan datang sebagai Raja.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Enam hari selepas itu, Isa membawa Petrus, Yakobus dan Yahya, saudara Yakobus, pergi bersunyi di atas sebuah gunung yang tinggi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Apabila mereka memandang Isa, mereka mendapati-Nya berubah: Wajah-Nya bersinar seperti matahari dan pakaian-Nya putih berkilau-kilauan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mereka melihat pula Ilyas dan Musa berkata-kata dengan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petrus berkata kepada Isa, ‘Junjungan, sungguh baik bagi kita berada di sini. Kalau Junjungan mahu, biar kudirikan tiga buah khemah suci; satu untuk Junjungan, satu untuk Musa, dan satu lagi untuk Ilyas.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sedang Petrus berkata-kata, segumpal awan yang bersinar-sinar meliputi mereka. Dari awan itu kedengaran suara berkata, ‘Inilah Putera-Ku yang Kukasihi dan dengan-Nya Aku berkenan. Dengarlah kata-Nya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mendengar suara itu, para pengikut Isa ketakutan lalu meniarap di tanah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Isa datang menyentuh mereka sambil berkata, ‘Bangunlah. Jangan takut.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Apabila mereka memandang keliling, tiada siapapun kelihatan kecuali Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mereka turun dari atas gunung itu. Isa mengeluarkan perintah, ‘Jangan beritahu sesiapapun apa yang telah kamu lihat, selagi Putera Insan belum dibangkitkan daripada kematian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Para pengikut Isa bertanya kepada-Nya, ‘Mengapakah guru Taurat berkata Ilyas mesti datang dulu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Isa menjawab, ‘Memang benar Ilyas mesti datang dulu untuk menyediakan semuanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tetapi sesungguhnya Aku berkata kepadamu, Ilyas sudahpun datang tetapi orang tidak mengenalnya. Mereka berbuat sesuka hati kepadanya. Begitulah mereka akan lakukan kepada Putera Insan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ketika itu barulah para pengikut Isa faham bahawa yang dimaksudkan-Nya ialah Yahya Pengimad. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Setelah Isa dan ketiga-tiga orang pengikut-Nya itu kembali kepada orang ramai, seorang lelaki datang berlutut di hadapan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Lelaki itu berkata, ‘Tuan, kasihanilah anakku! Dia mengidap sakit gila babi dan penyakitnya sungguh teruk. Seringkali dia terjatuh ke dalam air atau api. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aku sudahpun membawanya kepada pengikut-pengikut-Mu, tetapi mereka tidak dapat menyembuhkannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Isa menjawab, ‘Hai angkatan yang tidak percaya dan sesat ini. Berapa lama lagikah Aku mesti ada bersamamu? Berapa lama lagikah Aku mesti bersabar denganmu? Bawa anak itu ke sini!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Isa mengherdik roh iblis itu. Roh iblis itu pun keluar dari anak itu lalu dia sembuh serta-merta. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Para pengikut Isa mendapatkan-Nya dan bertanya ketika tiada orang lain di situ, ‘Mengapakah kami tidak dapat menghalau roh iblis itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Isa menjawab, ‘Kerana kamu tidak beriman. Sekiranya kamu mempunyai iman sebesar biji sawi, kamu dapat berkata kepada bukit, “Beralihlah ke situ!” maka bukit itu akan beralih. Kamu dapat melakukan apa saja. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jenis ini hanya dapat dihalau dengan berdoa dan berpuasa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ketika semua pengikut Isa berhimpun di Galilea, Isa berkata kepada mereka, ‘Putera Insan akan diserahkan kepada manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mereka akan membunuh-Nya, tetapi Dia akan dibangkitkan semula pada hari ketiga.’ Mendengar kata-kata itu, para pengikut Isa berdukacita. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Apabila Isa dan para pengikut-Nya sampai di Kapernaum, pemungut-pemungut cukai rumah ibadat datang kepada Petrus lalu bertanya, ‘Adakah gurumu membayar cukai rumah ibadat?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus menjawab, ‘Tentu sekali.’ Sebaik-baik Petrus masuk ke rumah, sebelum dia dapat berkata apa-apa, Isa bertanya, ‘Simon, bagaimana pandanganmu, daripada siapakah raja-raja dunia ini memungut cukai, daripada anak-anak mereka atau orang lain?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","‘Orang lain,’ jawab Petrus. ‘Kalau begitu,’ kata Isa, ‘anak-anak tidak perlu membayar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tetapi usahlah kita singgung perasaan orang. Pergilah memancing di laut. Ambillah ikan pertama yang kautangkap, dan bukalah mulutnya. Engkau akan mendapati sekeping duit syiling sebesar empat dirham. Ambillah duit itu dan berikan kepada mereka, untuk-Ku dan untukmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pada ketika itu para pengikut Isa datang bertanya kepada-Nya, ‘Siapakah yang dianggap terbesar antara orang di dalam kerajaan syurga nanti?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Isa memanggil seorang kanak-kanak, disuruh-Nya berdiri di hadapan mereka semua. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Isa pun berkata: ‘Ketahuilah! Kecuali kamu bersikap seperti kanak-kanak, kamu tidak akan memasuki kerajaan syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Oleh itu, orang yang dianggap terbesar dalam kerajaan syurga ialah yang merendah diri dan bersikap seperti kanak-kanak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","‘Sesiapa yang meraikan kanak-kanak begini kerana Aku, ertinya dia meraikan Aku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Sesiapa yang menyebabkan seorang pengikut-Ku yang kecil ini melakukan dosa, lebih baiklah jika batu kisaran diikatkan ke lehernya dan dia ditenggelamkan dalam laut yang dalam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","‘Malanglah dunia yang penuh dengan perkara-perkara yang menyebabkan orang berdosa! Memang dosa tetap berlaku, tetapi malanglah orang yang menyebabkannya! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Sekiranya tangan atau kakimu menyebabkan kamu berdosa, potong dan buanglah tangan atau kaki itu. Lebih baik kamu kehilangan sebelah tangan atau kaki tetapi menikmati hidup kekal, daripada kamu mempunyai dua tangan dan dua kaki tetapi dihumbankan ke dalam api neraka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Sekiranya matamu menyebabkan kamu berdosa, cungkil dan buanglah mata itu. Lebih baik kamu kehilangan sebelah mata tetapi menikmati hidup kekal, daripada kamu memiliki dua mata tetapi dilontarkan ke dalam api neraka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘Hati-hatilah, jangan hinakan seorang daripada pengikut-Ku yang kecil ini. Ketahuilah, malaikat-malaikat mereka sentiasa berada di hadirat Bapa-Ku di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Putera Insan datang untuk menyelamatkan orang yang sesat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‘Bagaimana pandanganmu? Jika seseorang mempunyai seratus ekor domba dan seekor daripadanya sesat, apa yang akan dilakukannya? Tentulah dia meninggalkan sembilan puluh sembilan ekor domba yang sedang merumput di bukit dan pergi mencari domba yang sesat itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sesungguhnya, apabila dia menjumpainya, domba yang seekor itu lebih menggembirakannya daripada sembilan puluh sembilan ekor yang lain itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Demikianlah juga Bapamu yang di syurga, tidak mahu seorang pun pengikut-Ku yang kecil ini sesat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‘Jika saudaramu berdosa terhadapmu, pergilah mendapatkannya dan tunjukkan kesalahannya. Lakukan diam-diam, antara kamu berdua sahaja. Sekiranya dia mahu mendengar katamu, ertinya kamu berjaya mendapat kembali saudaramu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jika tidak, bawalah seorang dua bersamamu; kerana telah tersurat, “Setiap tuduhan harus disokong dengan kesaksian dua atau tiga orang saksi.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sekiranya dia enggan menerima nasihat mereka, maklumkan hal itu kepada jemaah. Jika nasihat jemaah pun tidak diterimanya, anggaplah dia seperti orang yang tidak mengenal Allah atau pemungut cukai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘Sesungguhnya, apa yang kamu ikat di dunia akan diikat di syurga, dan apa yang kamu uraikan di dunia akan diuraikan juga di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‘Ketahuilah juga, setiap kali dua orang daripadamu di dunia ini bersetuju untuk memohon sesuatu daripada-Ku, permohonan itu akan dikabulkan oleh Bapa-Ku di syurga; ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","kerana apabila dua atau tiga orang berhimpun kerana-Ku, Aku ada di situ bersama mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petrus datang mendapatkan Isa lalu bertanya, ‘Junjungan, jika saudaraku berdosa terhadapku, berapa kalikah harus kuampuni dia? Sehingga tujuh kali?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Isa menjawab, ‘Bukan tujuh kali. Tujuh puluh kali tujuh kali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","‘Kerana kerajaan syurga seperti berikut: Seorang raja hendak menyelesaikan kira-kira dengan para hambanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Salah seorang hambanya yang berhutang sebanyak lima puluh juta keping wang perak dibawa mengadapnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hamba itu tidak dapat menjelaskan hutangnya. Oleh itu, raja memerintahkan supaya hamba itu dijual bersama anak isteri dan harta bendanya untuk membayar hutang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","‘Hamba itu menyembah dan merayu, “Bersabarlah denganku. Aku akan menjelaskan hutang itu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Raja itu berasa kasihan kepadanya lalu menghapuskan segala hutangnya dan membebaskannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","‘Tetapi ketika hamba itu keluar, dia menemui seorang hamba lain yang berhutang seratus keping wang perak kepadanya. Dia menangkap dan hendak mencekik rakannya itu sambil berkata, “Bayar semua hutangmu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","‘Rakannya itu menyembah dan merayu, “Bersabarlah denganku. Aku akan menjelaskan hutangku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","‘Tetapi hamba itu tidak mempedulikan rayuan rakannya. Malah dia memerintahkan supaya rakannya dipenjarakan sehingga menjelaskan hutangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hamba-hamba lain dukacita melihatnya lalu mengadukan hal itu kepada raja. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","‘Raja pun memanggil hamba yang tidak berhati perut itu lalu berkata, “Sungguh kejam perbuatanmu! Aku telah menghapuskan segala hutangmu kerana kamu merayu supaya aku mengampunimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bukankah sepatutnya kamu mengasihani rakanmu sebagaimana aku mengasihanimu?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dengan murkanya raja menitahkan supaya hamba yang tidak berperikemanusiaan itu dipenjarakan dan dihukum sehingga semua hutangnya dibayar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","‘Begitulah Bapa-Ku yang di syurga akan memperlakukan setiap orang daripadamu yang tidak mengampuni saudaranya dengan ikhlas.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Selepas Isa selesai berkata tentang hal-hal itu, Dia beredar dari Galilea pergi ke Yudea di seberang Sungai Yordan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ramai orang mengikut-Nya dan Dia menyembuhkan orang sakit di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Beberapa orang Farisi datang untuk menduga Isa. Mereka bertanya, ‘Adakah Taurat kita membenarkan seorang lelaki menceraikan isterinya dengan apa sebab jua?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Isa menjawab, ‘Tidakkah kamu baca ayat Kitab Suci yang menyatakan betapa pada mulanya Allah menjadikan lelaki dan perempuan? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Setelah itu Allah berfirman, “Itulah maka seorang lelaki meninggalkan ibu bapanya dan bersatu dengan isterinya lalu mereka berdua menjadi satu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Maka mereka bukan lagi dua tetapi satu. Apa yang telah disatukan oleh Allah janganlah manusia pisahkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kata orang Farisi itu, ‘Kalau begitu, mengapakah Musa memberikan hukum membenarkan seseorang lelaki menceraikan isterinya dengan menulis surat cerai?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Isa menjawab, ‘Musa membenarkan kamu menceraikan isteri kerana kamu terlalu sukar diajar. Tetapi pada mulanya bukanlah begitu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Sesungguhnya jika seseorang lelaki menceraikan isterinya, kecuali kerana isterinya melakukan pencabulan, dan lelaki itu berkahwin pula dengan perempuan lain, dia berzina.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Para pengikut Isa berkata, ‘Kalau begitulah hidup suami isteri, lebih baiklah tidak berkahwin langsung.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Isa menjawab, ‘Tidak semua orang dapat menerima ajaran ini, hanya mereka yang dikurniai keupayaan untuk menerimanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ada beberapa sebabnya seseorang itu tidak berkahwin. Ada yang dilahirkan begitu, ada yang dibuat orang begitu, dan ada pula yang membuat dirinya begitu untuk mengabdikan diri kepada Allah. Biarlah ajaran ini diterima oleh yang mampu menerimanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Beberapa orang membawa kanak-kanak supaya diberkati oleh Isa dengan meletakkan tangan-Nya ke atas mereka serta mendoakan mereka. Tetapi para pengikut Isa memarahi orang yang membawa kanak-kanak itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Isa berkata kepada para pengikut-Nya, ‘Biarlah kanak-kanak itu datang kepada-Ku, jangan larang mereka, kerana orang seperti inilah yang masuk ke dalam kerajaan syurga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Isa meletakkan tangan-Nya ke atas kanak-kanak itu dan memberkati mereka. Kemudian Dia beredar dari situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pada suatu hari seorang pemuda datang berjumpa Isa lalu bertanya, ‘Tuan Guru, apakah perbuatan baik yang harus aku lakukan untuk mendapat kehidupan kekal?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Isa menjawab, ‘Mengapa kamu bertanya kepada-Ku apa yang baik? Hanya ada Satu yang baik. Sekiranya kamu ingin masuk ke dalam hidup, patuhilah hukum-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Pemuda itu bertanya, ‘Hukum yang mana?’ Isa menjawab, ‘ “Jangan membunuh; jangan berzina; jangan mencuri; jangan berikan kesaksian palsu; ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","hormati ibu bapamu; kasihi sesama manusia sebagaimana kamu mengasihi diri sendiri.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","‘Semua hukum ini telah kupatuhi,’ kata pemuda itu. ‘Adakah lagi yang harus kulakukan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Isa menjawab, ‘Jika kamu ingin menjadi sempurna, jualkanlah segala harta bendamu dan sedekahkan wang itu kepada orang miskin. Kamu akan mendapat harta di syurga. Setelah itu, ikutlah Aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Apabila mendengar jawapan Isa, pemuda itu beredar dari situ dengan dukacita, kerana dia seorang yang kaya-raya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Isa pun berkata kepada para pengikut-Nya, ‘Sesungguhnya, sukar sekali bagi orang kaya memasuki kerajaan syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aku berkata kepadamu, lebih mudah bagi seekor unta memasuki lubang jarum daripada seorang kaya memasuki kerajaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Para pengikut Isa hairan mendengar kata-kata itu lalu bertanya, ‘Kalau begitu, siapakah yang dapat diselamatkan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sambil memandang mereka Isa menjawab, ‘Hal itu mustahil bagi manusia, tetapi bagi Allah tidak ada satu pun yang mustahil.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petrus berkata, ‘Kami telah meninggalkan segala-galanya dan mengikut-Mu. Apakah yang akan kami terima?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Isa berkata kepada mereka, ‘Sesungguhnya Aku berkata kepadamu, ketika Putera Insan duduk di atas takhta-Nya yang mulia dalam kerajaan Allah, kamu pengikut-Ku juga akan bertakhta menghakimi dua belas suku Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Setiap orang yang telah meninggalkan rumah, atau saudara lelaki, saudara perempuan, ibu bapa, anak-anak, atau ladang kerana Aku, akan menerima seratus kali ganda apa yang ditinggalkannya dan akan memperoleh hidup kekal. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tetapi ramai orang yang sekarang terdahulu akan menjadi terakhir, dan yang sekarang terakhir akan menjadi yang terdahulu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","‘Kerajaan syurga seperti ibarat ini. Seorang tuan punya ladang anggur keluar pada awal pagi untuk mengupah orang bekerja di ladangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dia bersetuju membayar upah yang biasa dibayar untuk bekerja sehari iaitu sekeping wang perak. Dia pun menyuruh mereka pergi ke ladang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","‘Pada pukul sembilan pagi, tuan punya ladang itu keluar lagi lalu melihat beberapa orang lain berdiri-diri tanpa berbuat apa-apa di pasar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Dia berkata kepada mereka, “Pergilah bekerja di ladang anggurku. Aku akan memberimu upah yang berpatutan.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mereka pun pergi. ‘Pada pukul dua belas tengah hari dan pada pukul tiga petang, begitu jugalah yang terjadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pada kira-kira pukul lima petang dia pergi lagi ke pasar dan melihat beberapa orang berdiri-diri tidak berbuat apa-apa. Dia menanya mereka, “Mengapa kamu membuang masa tidak membuat apa-apa kerja?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Mereka menjawab, “Tiada siapa mengupah kami bekerja.” ‘Kalau begitu, pergilah bekerja di ladang anggurku,’ kata tuan punya ladang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","‘Setelah hari petang, tuan punya ladang anggur itu berkata kepada ketua pekerja, “Panggillah pekerja-pekerja itu dan bayarlah upah masing-masing, mulai daripada pekerja yang datang terakhir hingga kepada pekerja yang datang awal sekali.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","‘Mereka yang bekerja dari pukul lima petang menerima sekeping wang perak seorang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Oleh itu mereka yang bekerja sejak pagi menjangka akan menerima bayaran yang lebih, tetapi mereka pun mendapat sekeping wang perak seorang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mereka pun mulalah bersungut kepada tuan punya ladang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mereka berkata, “Pekerja-pekerja yang bermula pada pukul lima itu cuma bekerja sejam sedangkan kami sehari suntuk dalam panas matahari. Tetapi tuan membayar kami dan mereka sama saja!” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","‘Tuan punya ladang itu menjawab kepada seorang daripada mereka, “Dengarlah, kawan, aku tidak menipumu. Bukankah kamu telah bersetuju bekerja dengan upah sekeping wang perak sehari? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ambillah upahmu dan pulanglah. Aku memang hendak memberi pekerja yang datang terakhir itu upah yang sama. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bukankah hakku berbuat sesuka hati dengan wangku sendiri? Mengapakah kamu busuk hati kerana aku bermurah hati?” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Isa berkata lagi, ‘Begitulah, orang yang terakhir akan menjadi yang terdahulu, dan orang terdahulu akan menjadi yang terakhir.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ketika Isa sedang dalam perjalanan ke Baitulmaqdis, Dia mengajak kedua belas orang pengikut-Nya ke tepi dan berkata hanya kepada mereka: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","‘Dengarlah, kita sekarang ke Baitulmaqdis. Di sana Putera Insan akan dikhianati dan diserahkan kepada ketua imam dan guru Taurat. Mereka akan menjatuhkan hukuman mati kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kemudian mereka akan menyerahkan-Nya kepada bangsa yang tidak mengenal Allah. Dia akan diejek, disebat dan disalib oleh mereka. Tetapi pada hari ketiga Dia akan dibangkitkan semula.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Setelah itu, isteri Zebedeus datang mendapatkan Isa dengan kedua-dua orang anaknya. Dia bersujud di hadapan Isa dan memohon sesuatu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","‘Apakah permintaanmu?’ tanya Isa. Ibu itu menjawab, ‘Junjungan berjanjilah bahawa apabila Engkau menjadi raja, kedua-dua orang anakku itu akan duduk di kiri kanan-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Isa berkata kepada kedua-dua orang anak lelaki ibu itu, ‘Kamu tidak tahu apa yang kamu minta itu. Sanggupkah kamu minum dari cawan penderitaan yang akan Kuminum?’ ‘Sanggup,’ jawab mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Isa berkata kepada mereka, ‘Memang kamu akan minum dari cawan-Ku dan diimadkan secara Aku diimadkan. Tetapi Aku tidak berhak menentukan siapa yang akan duduk di kiri kanan-Ku kerana tempat itu milik mereka yang telah ditentukan oleh Bapa-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Apabila sepuluh pengikut Isa yang lain mendengar perkara itu, mereka marah kepada dua saudara itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Oleh yang demikian, Isa memanggil mereka semua lalu berkata, ‘Kamu tahu bahawa di kalangan bangsa yang tidak mengenal Allah, orang yang berkuasa menindas rakyat, dan pegawai besar mereka mempunyai kuasa terhadap mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tetapi di kalanganmu bukan begitu. Sebaliknya, jika seorang daripadamu ingin menjadi orang besar, dia mestilah melayan yang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Sekiranya seorang daripadamu hendak menjadi orang yang pertama, dia haruslah menjadi hamba kepada orang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Demikianlah Putera Insan: Dia datang bukan untuk dilayan, tetapi untuk melayan, serta menyerahkan nyawa-Nya untuk menjadi tebusan bagi umat manusia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Isa meninggalkan Yerikho bersama para pengikut-Nya. Ramai orang mengikut mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dua orang buta yang duduk di tepi jalan mendengar bahawa Isa lalu di situ lalu berseru, ‘Wahai Junjungan, Anak Daud, kasihanilah kami!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Orang ramai memarahi mereka dan menyuruh mereka diam. Tetapi mereka berseru lebih lantang lagi, ‘Wahai Junjungan, Anak Daud, kasihanilah kami!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Isa berhenti lalu memanggil mereka dan bertanya, ‘Apakah yang kamu mahu Kulakukan untukmu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mereka menjawab, ‘Junjungan, kami ingin melihat!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Isa mengasihani mereka. Dia menyentuh mereka, dan dengan serta-merta mereka dapat melihat, lalu mereka pun mengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ketika hampir mendekati Baitulmaqdis, Isa dan para pengikut-Nya sampai di Baitfagi, sebuah pekan di Bukit Zaitun. Kemudian Isa menyuruh dua orang pengikut-Nya pergi ke situ terlebih dahulu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Dia berkata, ‘Pergilah ke pekan yang di hadapan itu. Apabila kamu memasukinya, kamu akan melihat seekor keldai tertambat, serta anaknya. Lepaskan keldai itu dan bawa kedua-duanya kepada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sekiranya ada orang berkata apa-apa, katakan kepadanya, “Junjungan memerlukannya.” Dia akan terus membenarkan kedua-dua keldai itu dibawa pergi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dengan demikian berlakulah apa yang dikatakan oleh nabi: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Katakanlah kepada puteri Sion, “Rajamu datang kepadamu dengan rendah hati, menunggang seekor keldai, seekor anak keldai yang muda.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kedua-dua orang pengikut Isa itu pun pergi menjalankan segala yang disuruh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mereka membawa kedua-dua ekor keldai itu. Setelah mengalas belakang keldai itu dengan jubah mereka, mereka mendudukkan Isa ke atasnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ramai orang membentangkan jubah di atas jalan manakala yang lain memotong ranting-ranting pokok dan menyelerakkannya di jalan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Orang ramai yang berjalan di hadapan dan di belakang Isa berseru-seru, ‘Hosana bagi Anak Daud!’ ‘Diberkatilah Dia yang datang dengan nama Tuhan!’ ‘Hosana di tempat yang maha tinggi!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Apabila Dia masuk ke Baitulmaqdis, seisi kota itu kagum lalu bertanya, ‘Siapakah ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Orang ramai itu berkata, ‘Inilah Isa, nabi dari Nasaret di Galilea.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Setelah itu Isa masuk ke rumah ibadat dan mengusir semua orang yang berjual-beli di situ. Dia menterbalikkan meja pengurup wang dan tempat duduk orang yang menjual merpati. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Dia berkata kepada mereka, ‘Telah tersurat, “Rumah-Ku akan dipanggil rumah doa, tetapi kamu telah menjadikannya sarang pencuri.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Selepas itu orang yang buta dan yang tempang datang mendapatkan Isa di rumah ibadat, lalu Dia menyembuhkan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tetapi apabila ketua imam dan guru Taurat melihat segala mukjizat yang dilakukan-Nya, dan kanak-kanak berseru di dalam rumah ibadat, ‘Hosana bagi Anak Daud!’ mereka berasa marah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mereka berkata kepada Isa, ‘Kamu dengarkah apa yang mereka katakan?’ Isa menjawab, ‘Ya, belum pernahkah kamu baca, “Dari mulut kanak-kanak dan bayi yang sedang menyusu, Engkau telah menyediakan puji-pujian.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kemudian Dia meninggalkan mereka dan keluar dari kota itu lalu pergi ke Baitani. Dia menginap di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pada pagi esoknya, ketika Dia pergi semula ke kota Baitulmaqdis, Dia berasa lapar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dia melihat sebatang pokok ara di tepi jalan. Apabila Dia mendekatinya dan mendapati pokok itu hanya berdaun tidak berbuah, Dia berkata kepadanya, ‘Janganlah berbuah lagi selama-lamanya.’ Serta-merta pokok itu layu dan mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Apabila dilihat oleh para pengikut-Nya, mereka hairan dan bertanya, ‘Bagaimana pokok ara itu boleh layu dan mati serta-merta?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Isa menjawab, ‘Sesungguhnya, aku berkata kepadamu, jika kamu beriman tanpa ragu, kamu dapat melakukan begitu juga kepada pokok ara itu, malah kamu boleh berkata kepada gunung ini, “Beralihlah dan terhumbanlah ke dalam laut,” lalu hal itu akan terjadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Apa sahaja yang kamu minta dalam doa dengan iman, akan kamu terima.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Apabila Isa masuk ke rumah ibadat, ketua imam dan tua-tua datang kepada-Nya ketika Dia sedang mengajar, ‘Dengan kuasa apakah kamu melakukan semua ini? Dan siapakah yang memberimu kuasa itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Isa menjawab, ‘Aku juga akan bertanya sesuatu kepadamu. Jika kamu memberitahu-Ku, Aku akan menyatakan kepadamu dengan kuasa apa Aku melakukan segala ini: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pengimadan Yahya dari manakah asalnya? Daripada Allah atau daripada manusia?’ Mereka pun berbincang sama sendiri, ‘Kalau kita kata, “Daripada Allah,” dia akan berkata, “Kalau begitu, mengapa kamu tidak mempercayainya?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tetapi kalau kita kata, “Daripada manusia,” takut orang ramai marah, kerana mereka menganggap Yahya seorang nabi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Oleh itu mereka menjawab, ‘Kami tidak tahu.’ Isa berkata kepada mereka, ‘Aku pun tidak akan memberitahumu dengan kuasa apa Aku lakukan semua ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","‘Tetapi bagaimana pandanganmu? Seorang ada dua orang anak lelaki. Dia mendapatkan yang sulung dan berkata, “Anakku, pergilah bekerja hari ini di ladang anggurku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Anak itu menjawab, “Aku tidak mahu,” tetapi kemudian dia menyesal lalu pergi bekerja di ladang bapanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","‘Ayah itu pergi pula mendapatkan anaknya yang kedua dengan kata-kata yang sama. Anak itu menjawab, “Baiklah, aku pergi, ayah,” tetapi dia tidak pergi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","‘Antara dua itu, yang mana melakukan kehendak bapanya?’ Mereka menjawab, ‘Yang sulung.’ Isa berkata kepada mereka, ‘Sesungguhnya, aku berkata kepadamu, pemungut cukai dan pelacur akan memasuki kerajaan Allah terlebih dahulu daripadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yahya datang kepadamu untuk menunjukkan jalan yang benar tetapi kamu tidak percaya kepadanya; manakala pemungut cukai dan pelacur percaya kepadanya. Setelah kamu melihat hal ini pun, hatimu tidak menjadi lembut dan percaya kepadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","‘Dengarlah satu ibarat lagi: Seorang tuan punya tanah memiliki ladang anggur. Dia memagar ladang itu, menggali lubang tempat memeras anggur, dan mendirikan menara tempat berkawal. Kemudian dia menyewakan ladang anggur itu kepada beberapa orang, lalu pergi ke luar negeri. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Apabila sampai masanya untuk mengumpulkan buah anggur, tuan punya ladang itu menghantar hamba-hambanya kepada penyewa-penyewa tersebut meminta bahagiannya daripada hasil ladang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","‘Tetapi para penyewa menangkap hamba-hamba itu. Ada yang dipukul, ada yang dibunuh, dan ada yang direjam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tuan punya ladang itu menghantar hamba-hamba yang lain pula, lebih banyak lagi bilangannya. Tetapi hamba-hamba itu pun diperlakukan begitu juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Akhirnya tuan punya ladang itu menghantar puteranya sambil berfikir, “Tentu mereka akan menghormati puteraku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","‘Tetapi apabila mereka melihat putera tuan punya ladang itu, mereka berkata sama sendiri, “Marilah kita bunuh waris tuan punya ladang ini, supaya dapat kita rampas harta pusakanya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mereka pun menangkapnya, menghumbankannya ke luar ladang dan membunuhnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Selepas itu Isa bertanya, ‘Apabila tuan punya ladang itu pulang, apakah yang akan dilakukannya kepada penyewa-penyewa itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mereka menjawab, ‘Tentu dia akan membunuh semua orang yang jahat itu dan menyewakan ladang anggurnya kepada orang lain yang sanggup memberikan bahagiannya daripada hasil ladang itu pada musim memetik anggur.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Isa berkata kepada mereka, ‘Tidakkah kamu baca apa yang tersurat di dalam Kitab Suci: ‘ “Batu yang dibuang oleh pembina telah menjadi batu penjuru. Demikianlah perbuatan Tuhan; Sungguh hebat di mata kami!”? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","‘Sesungguhnya, hak untuk memasuki kerajaan Allah akan diambil daripadamu dan diberikan kepada bangsa yang memberikan hasil yang dikehendaki Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sesiapa yang jatuh ke atas batu itu akan hancur; dan sesiapa yang ditimpa batu itu akan digilis menjadi debu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Apabila ketua imam dan orang Farisi mendengar ibarat-ibarat Isa, fahamlah mereka bahawa Dia bercakap tentang mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Oleh itu mereka cuba menangkap Isa. Tetapi mereka takut akan orang ramai yang menganggap Isa sebagai seorang nabi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Isa bercakap lagi kepada orang ramai melalui ibarat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Dia berkata, ‘Kerajaan syurga seperti ibarat ini. Seorang raja mengadakan majlis perkahwinan untuk anak lelakinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Raja menitahkan hamba-hambanya menjemput orang ke majlis jamuan itu tetapi mereka enggan hadir. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","‘Kemudian raja itu menghantar lagi hamba-hambanya yang lain. Titah raja itu, “Katakan kepada mereka, lembu yang terbaik telah disembelih, semuanya sudah siap, datanglah ke majlis perkahwinan.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","‘Tetapi orang yang diundang tidak ambil peduli, masing-masing sibuk dengan kerjanya. Ada yang ke ladang, ada yang ke kedai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Manakala yang lain menangkap hamba-hamba itu lalu mendera dan membunuh mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Raja pun teramat murka lalu menitahkan tenteranya menghapuskan semua pembunuh itu dan membakar kota mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","‘Setelah itu raja memanggil hamba-hambanya dan berkata, “Majlis perkahwinan sudah siap tetapi orang yang diundang tidak layak menghadirinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Sekarang pergilah ke jalan raya dan jemput seramai mungkin orang yang kamu temui ke majlis perkahwinan ini.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hamba-hamba raja itu pun pergi ke jalan raya lalu mengumpulkan semua orang yang ditemui, tidak kira baik atau pun jahat, maka penuh sesaklah balai majlis jamuan itu dengan tetamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‘Raja itu masuk melihat para tetamunya. Dilihatnya seorang yang tidak memakai pakaian untuk majlis perkahwinan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Raja berkata kepadanya, “Bagaimana engkau dapat masuk ke sini dengan tidak memakai pakaian untuk majlis perkahwinan?” Orang itu terdiam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","‘Raja itu pun berkata kepada hamba-hambanya, “Ikat kaki dan tangan orang ini, buangkan dia ke kegelapan di luar. Di sanalah akan terdapat ratapan dan kertakan gigi.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","‘Ramai yang dipanggil, tetapi cuma sedikit yang dipilih.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Beberapa orang Farisi pergi dan berpakat bagaimana hendak memerangkap Isa dengan menyoal kata-kata yang digunakan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mereka menghantar para pengikut mereka dan sebilangan orang Herodes mendapatkan Isa dan berkata, ‘Tuan Guru, kami tahu Engkau ikhlas, dan terus-terang mengajarkan kehendak Allah berdasarkan yang benar kepada manusia. Engkau tidak takut kepada sesiapapun kerana Engkau tidak pilih kasih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jadi, katakanlah pendapat-Mu kepada kami. Haruskah kita membayar cukai kepada Kaisar atau tidak?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Isa mengetahui niat jahat mereka lalu berkata, ‘Hai munafik! Mengapa kamu cuba memerangkap-Ku? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tunjukkan mata wang yang kamu gunakan untuk membayar cukai.’ Mereka memberikan mata wang itu kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Isa bertanya kepada mereka, ‘Gambar dan nama siapakah ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","‘Kaisar,’ jawab mereka. Lalu Isa berkata kepada mereka, ‘Kalau begitu, berikan milik Kaisar kepada Kaisar, dan berikan milik Allah kepada Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mereka tercengang mendengar kata-kata Isa, lalu pergi dari situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pada hari itu juga, beberapa orang Saduki datang mendapatkan Isa. Menurut kepercayaan golongan ini, orang mati tidak akan bangkit semula. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mereka berkata, ‘Tuan Guru, ajaran Musa begini: Jika seseorang lelaki meninggal dunia tanpa anak, maka saudara lelakinya harus berkahwin dengan balunya untuk mendapatkan zuriat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dahulu ada tujuh orang adik-beradik tinggal di sini. Yang sulung berkahwin, kemudian meninggal dunia tanpa anak. Jadi, saudara yang kedua pun berkahwin dengan balunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Saudara yang kedua itu pula meninggal dunia tanpa anak. Demikianlah terjadi seorang demi seorang hingga saudara yang ketujuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Akhirnya wanita itu meninggal dunia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pada hari kebangkitkan orang mati, isteri siapakah wanita itu? Ketujuh-tujuh saudara itu telah berkahwin dengannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Isa menjawab, ‘Tanggapanmu salah sama sekali. Kamu tidak memahami Kitab Suci dan kuasa Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Apabila orang mati dibangkitkan semula, mereka akan menjadi seperti malaikat di syurga. Mereka tidak berkahwin. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tentang soal orang mati dibangkitkan semula, tidakkah kamu baca firman Allah: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Akulah Tuhan yang disembah oleh Ibrahim, Ishak dan Yakub.” Oleh itu, Dia Allah Tuhan orang hidup, bukan Allah Tuhan orang mati.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Orang ramai kagum mendengar ajaran Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Apabila orang Farisi mendengar betapa Isa menyebabkan orang Saduki terdiam, mereka pun datang berkumpul. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Seorang guru Taurat antara mereka cuba memerangkap Isa dengan suatu soalan: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","‘Tuan Guru, perintah manakah yang terutama dalam Taurat?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Isa menjawab, ‘ “Kasihilah Allah, Tuhanmu dengan sepenuh hati, dengan sepenuh jiwa dan dengan sepenuh fikiranmu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inilah perintah yang terutama dan terpenting. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Perintah kedua sama pentingnya: “Kasihilah sesama manusia sebagaimana kamu mengasihi dirimu sendiri.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Seluruh Taurat Musa dan ajaran nabi-nabi berasaskan dua perintah ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Isa bertanya kepada orang Farisi yang berkumpul itu: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","‘Apa pendapatmu tentang al-Masih? Anak siapakah Dia?’ ‘Anak Daud,’ jawab mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","‘Kalau begitu, mengapakah Daud, ketika diilhami Roh Suci, menyebut-Nya “Junjungan”? Daud berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Tuhan telah berfirman kepada Junjunganku: ‘Duduklah di kanan-Ku, sehingga Kujadikan musuh-Mu alas kaki-Mu.’” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","‘Jika Daud menyebut Dia yang diutus oleh Allah itu “Junjungan,” bagaimana mungkin Dia itu anak Daud?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tidak seorang pun terjawab soalan Isa. Sejak hari itu, tiada siapa berani menanya Isa apa-apa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Isa berkata kepada orang ramai dan para pengikut-Nya: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","‘Guru Taurat dan orang Farisi menduduki kerusi Musa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Oleh itu, patuhilah dan turutilah perintah yang diajarkan oleh mereka. Tetapi jangan contohi perbuatan mereka, kerana tidak selaras dengan ajaran mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mereka meletakkan beban yang berat dan sukar dipikul ke atas bahu orang, tetapi mereka langsung tidak mahu menolong orang memikul beban itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","‘Mereka melakukan sesuatu hanya untuk dilihat orang. Lihatlah betapa besarnya bekas ayat Kitab Suci yang diikatkan pada dahi dan lengan mereka, serta betapa panjangnya rumbai jubah mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mereka suka duduk di tempat terbaik di majlis jamuan dan kerusi khas di saumaah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mereka suka dihormati orang di pasar, dan suka dipanggil “Tuan Guru.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‘Janganlah suruh orang memanggilmu “Tuan Guru,” kerana kamu semua bersaudara dan Gurumu hanya satu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Janganlah panggil sesiapapun di dunia ini “Bapa,” kerana kamu hanya mempunyai satu Bapa yang di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Janganlah suruh orang memanggilmu “Pemimpin,” kerana pemimpinmu hanya satu, iaitu al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Orang yang terbesar antaramu haruslah menjadi pelayanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Orang yang meninggikan diri akan direndahkan, dan orang yang merendahkan diri akan ditinggikan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‘Malanglah kamu, guru Taurat dan orang Farisi! Kamu munafik! Kamu menghalang orang memasuki kerajaan syurga. Kamu bukan sahaja enggan memasuki kerajaan syurga; kamu halang pula orang lain yang berusaha untuk memasukinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Malanglah kamu, guru Taurat dan orang Farisi! Kamu munafik! Kamu menipu balu dan merampas rumahnya, kemudian pura-pura berdoa panjang. Oleh itu, kamu akan menerima hukuman yang lebih berat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‘Malanglah kamu, guru Taurat dan orang Farisi! Kamu munafik! Kamu merentas lautan dan daratan untuk menarik seseorang menganut agamamu. Namun, setelah berjaya, kamu menjadikannya isi neraka yang dua kali lebih buruk daripadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘Malanglah kamu, pemimpin yang buta! Kamu mengajar orang demikian, “Jika seorang bersumpah demi rumah ibadat, dia tidak terikat pada sumpahnya. Tetapi jika dia bersumpah demi emas di dalam rumah ibadat, dia terikat pada sumpahnya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hai orang bodoh dan buta! Yang mana lebih penting, emas atau rumah ibadat Allah yang menjadikan emas itu suci? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kamu juga mengajar orang begini, “Jika seseorang bersumpah demi mazbah, dia tidak terikat pada sumpahnya; tetapi jika dia bersumpah demi persembahan di atas mazbah, dia terikat pada sumpahnya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hai orang yang buta hati! Yang manakah lebih penting, persembahan atau mazbah yang menjadikan persembahan itu suci? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ketahuilah apabila seseorang bersumpah demi mazbah, dia bersumpah demi mazbah dan demi segala persembahan di atasnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Apabila seseorang bersumpah demi rumah ibadat, dia bersumpah demi rumah ibadat itu dan demi Dia yang tinggal di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Apabila seseorang bersumpah demi syurga, dia bersumpah demi takhta Allah dan demi Dia yang duduk di atas takhta itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘Malanglah kamu, guru Taurat dan orang Farisi! Kamu munafik! Kamu memberikan sepersepuluh daripada pelbagai jenis rempah seperti selasih, adas manis dan jintan kepada Allah. Tetapi kamu tidak mematuhi ajaran Taurat yang benar-benar penting seperti keadilan, belas kasihan dan kesetiaan. Kamu harus mengerjakan semua ini tanpa melalaikan ajaran yang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hai pemimpin yang buta! Agas kamu tapis, tetapi unta kamu telan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘Malanglah kamu, guru Taurat dan orang Farisi! Kamu munafik! Kamu membersihkan bahagian luar cawan dan pinggan, sedangkan bahagian dalamnya penuh dengan hasil kekerasan dan kerakusanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hai orang Farisi yang buta hati! Bersihkan bahagian dalam cawan itu, bahagian luarnya akan bersih juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‘Malanglah kamu, guru Taurat dan orang Farisi! Kamu munafik! Kamu seperti kubur yang bercat putih: cantik di luar tetapi di dalamnya penuh dengan tulang dan mayat yang busuk. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Begitulah kamu! Pada lahirnya kamu orang yang benar, tetapi sebenarnya kamu durjana dan munafik. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‘Malanglah kamu, guru Taurat dan orang Farisi! Kamu munafik! Kamu membina makam yang indah untuk nabi-nabi dan menghiasi kubur orang yang benar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kamu berkata, “Kalaulah kami hidup pada zaman nenek moyang kami dulu, tentu kami tidak akan mengikut perbuatan mereka yang menumpahkan darah para nabi.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jadi, kamu sendiri memberikan kesaksian bahawa kamu keturunan pembunuh nabi! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kalau begitu, teruskan dan sempurnakanlah apa yang dimulakan oleh nenek moyangmu! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‘Hai kamu seperti ular, bahkan kamu seperti ular berbisa! Bagaimana kamu dapat melepaskan diri daripada azab neraka? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sesungguhnya Aku akan mengutus nabi, orang bijaksana dan guru kepadamu. Kamu akan membunuh dan menyalib mereka. Yang lain pula kamu sebat di dalam saumaah, dan buru dari kota ke kota. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dengan demikian darah semua orang benar yang tertumpah di bumi akan ditanggungkan kepadamu: mulai daripada darah Habil yang tidak bersalah itu hingga kepada darah Zekaria anak Berekia, yang kamu bunuh di antara rumah ibadat dan mazbah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sesungguhnya, Aku berkata kepadamu, semuanya itu akan ditanggungkan kepada keturunan zaman ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","‘Baitulmaqdis, Baitulmaqdis! Engkau membunuh nabi dan merejam utusan Allah! Sudah berapa kali aku ingin mendakap semua pendudukmu seperti ibu ayam menaungi anak-anaknya di bawah sayapnya, tetapi kamu tidak mahu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Rumahmu akan ditinggalkan dan terbiar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sesungguhnya, Aku berkata kepadamu, mulai sekarang engkau tidak akan melihat-Ku lagi sehingga engkau berkata, “Diberkatilah Dia yang datang dengan nama Tuhan.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Apabila Isa melangkah keluar dari rumah ibadat, para pengikut-Nya datang mendapatkannya lalu menunjukkan bangunan-bangunan rumah ibadat itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Isa berkata kepada mereka, ‘Lihatlah semuanya ini! Sesungguhnya, Aku berkata kepadamu, satu batu pun tidak akan tinggal di tempatnya; semuanya akan dirobohkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ketika Isa duduk di atas Bukit Zaitun, para pengikut-Nya datang mendapatkan-Nya. Pada masa itu tiada orang lain di situ. Mereka bertanya, ‘Junjungan, beritahulah kami bila semuanya akan terjadi? Apakah tanda-tanda kedatangan-Mu dan akhir zaman?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Isa menjawab, ‘Waspadalah, jangan terpedaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ramai orang akan datang dengan nama-Ku dan berkata, “Akulah al-Masih!” Mereka akan menipu orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kamu akan mendengar tentang peperangan dan desas-desus peperangan, tetapi jangan gentar. Itu semua mesti terjadi, tetapi bukanlah bererti akhir zaman sudah tiba. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bangsa akan bertarung dengan bangsa, kerajaan dengan kerajaan. Kebuluran dan gempa bumi akan berlaku di merata-rata. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Segala ini cuma permulaan, ibarat sakit sebelum bersalin. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‘Setelah itu kamu akan ditangkap dan diserahkan untuk diseksa dan dibunuh. Semua orang akan membencimu kerana kamu pengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pada masa itu ramai pengikut-Ku yang tidak lagi beriman kepada-Ku. Mereka akan saling mengkhianati dan membenci. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ramai nabi palsu akan tampil memperdaya orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kejahatan semakin merebak sehingga kasih sayang hampir luput dari hati manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Namun, sesiapa yang bertahan ke saat akhir akan diselamatkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Injil tentang kerajaan Allah akan disebarkan ke seluruh pelosok bumi sebagai suatu kesaksian kepada semua bangsa. Selepas itu barulah tiba akhir zaman. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‘Oleh itu, apabila kamu melihat “Kekejian yang membawa kebinasaan” yang disebut oleh Nabi Daniel di tempat suci (biarlah para pembaca memperhatikanya), ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ketika itu orang yang di Yudea mesti lari ke pergunungan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Orang yang di atas bumbung ketika itu usahlah masuk ke rumah mengambil apa-apa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Orang yang di ladang janganlah pulang mengambil jubah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sungguh dahsyat bagi ibu yang mengandung dan menyusui anak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Berdoalah semoga kamu tidak terpaksa melarikan diri pada musim dingin atau hari Sabat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ketika itu akan berlaku kesengsaraan yang belum pernah berlaku sejak dunia dicipta sampai sekarang, dan yang tidak akan pernah berlaku lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kalaulah Allah tidak menyingkatkan masa itu, tiada seorang pun akan selamat. Namun, untuk umat pilihan-Nya, Allah menyingkatkan masa itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pada masa itu, jika orang berkata kepadamu, “Lihat, al-Masih ada di sini!” atau “Dia ada di situ!” janganlah percaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kerana beberapa al-masih palsu dan nabi palsu akan datang dengan pelbagai mukjizat serta keajaiban untuk menipu orang. Sebilangan umat pilihan Allah pun mungkin turut terpedaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dengarlah! Aku memberitahumu semua ini sebelum terjadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","‘Jika orang berkata kepadamu, “Lihat! Dia ada di gurun!” janganlah kamu ke sana. Dan jika mereka berkata, “Dia ada di dalam bilik!” usahlah kamu percaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sesungguhnya, Putera Insan akan datang seperti kilat yang memancar di seluruh langit, dari timur hingga ke barat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Di mana ada mayat, di situlah berkerumunnya burung pemakan bangkai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Tidak lama selepas kesengsaraan masa itu, “matahari akan gelap dan bulan tidak bersinar lagi; Bintang-bintang akan berguguran dari langit, dan kuasa-kuasa angkasa akan digoncang.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","‘Tanda Putera Insan akan kelihatan di langit. Semua suku bangsa di bumi akan menangis melihat Putera Insan di awan dengan kekuasaan dan kemuliaan yang agung. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sangkakala akan dibunyikan dengan kuatnya, dan Putera Insan akan menghantar malaikat-malaikat-Nya ke seluruh pelosok bumi untuk menghimpunkan umat pilihan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","‘Ambillah iktibar daripada pokok ara. Apabila dahannya hijau, lembut dan mula bertunas, kamu tahu musim panas hampir tiba. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Demikianlah apabila kamu melihat perkara-perkara ini, tahulah kamu bahawa waktunya sudah dekat, sudah di ambang pintu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sesungguhnya, Aku berkata kepadamu, segala ini akan terjadi sebelum orang yang hidup hari ini mati semuanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Langit dan bumi akan lenyap, tetapi firman-Ku kekal selama-lamanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‘Namun demikian, tiada siapa yang mengetahui hari atau waktunya, baik para malaikat di syurga mahupun Putera. Hanya Bapa yang tahu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Apabila Putera Insan datang, samalah nanti seperti zaman Nuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sebelum banjir melanda, orang makan minum dan berkahwin, hinggalah waktu Nuh masuk ke bahtera. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mereka tidak sedar apa yang berlaku hingga banjir memusnahkan mereka. Demikianlah kelak apabila Putera Insan datang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pada masa itu, antara dua orang yang sedang bekerja di ladang, seorang dibawa pergi dan seorang ditinggalkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Antara dua orang wanita yang sedang menggiling gandum, seorang akan dibawa manakala yang seorang lagi ditinggalkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‘Berjaga-jagalah, kerana kamu tidak mengetahui waktunya Junjunganmu akan datang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ingatlah: Sekiranya tuan rumah mengetahui bila masanya pencuri akan datang, dia tidak akan tidur. Dia tidak akan membiarkan pencuri masuk ke rumahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kamu juga hendaklah sentiasa bersedia. Putera Insan akan datang pada saat yang tidak kamu sangka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘Siapakah hamba yang setia dan bijaksana? Dialah yang diamanahkan oleh tuannya menjadi pengurus rumahnya dan memberi makan kepada hamba yang lain pada waktu tertentu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bahagialah hamba itu jika dia didapati menjalankan tugas pada waktu tuannya kembali. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Sesungguhnya, Aku berkata kepadamu, tuan itu akan mengamanahkan segala harta bendanya kepada hamba itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tetapi jika hamba itu durjana, dia akan berkata dalam hatinya, “Masih lama lagi masanya tuanku akan pulang.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Dia pun memukul hamba-hamba yang lain, dan makan minum dengan kaki botol. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tuan hamba itu akan kembali pada hari yang tidak disangkanya, dan pada waktu yang tidak diketahuinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dia akan membunuh hamba itu dan membuangnya ke tempat orang munafik. Di sanalah akan terdapat ratapan dan kertakan gigi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","‘Kerajaan syurga ibarat sepuluh orang anak dara yang membawa lampu dan berjalan keluar untuk menyambut pengantin lelaki. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lima orang daripada mereka itu bijak manakala yang lima lagi kurang berakal. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yang kurang berakal membawa lampu sahaja tanpa bekalan minyak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yang bijak membawa bekalan minyak bersama lampu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Apabila pengantin lelaki lewat tiba, mereka semuanya mengantuk lalu tertidur. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","‘Pada waktu tengah malam terdengar seruan, “Pengantin lelaki sudah dekat; pergilah menyambutnya!” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","‘Kesemua anak dara itu pun membetul-betulkan lampu mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yang kurang berakal berkata kepada yang bijak, “Berilah kami minyakmu itu sedikit, kerana lampu kami hampir padam.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Tetapi yang bijak menjawab, “Kami tidak dapat memberimu, nanti tidak cukup minyak ini; pergilah beli minyak daripada penjual.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","‘Sementara yang kurang berakal pergi membeli minyak, pengantin lelaki pun sampai. Semua mereka yang sudah sedia terus mengiringinya ke majlis perkahwinan, maka pintu pun ditutup. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","‘Kemudian barulah anak dara yang berlima lagi itu tiba lalu berseru, “Tuan, tuan, bukalah pintu untuk kami!” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Tetapi pengantin lelaki berkata, “Sesungguhnya aku tidak mengenalmu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","‘Oleh itu berjaga-jagalah, kerana kamu tidak tahu hari dan waktunya Putera Insan datang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‘Kerajaan syurga boleh juga diibaratkan demikian: Seorang lelaki hendak pergi ke tanah asing yang jauh, lalu memanggil hamba-hambanya untuk berpesan menjaga hartanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kepada yang seorang dia memberi lima keping wang emas, kepada seorang lagi dua keping, kepada yang seorang lagi sekeping, masing-masing menurut kebolehannya. Setelah itu dia pun bertolak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hamba yang menerima lima keping emas itu memperniagakannya, lalu mendapat untung lima keping emas lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Demikian juga yang menerima dua keping emas, dia mendapat laba dua keping lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tetapi yang menerima sekeping itu menggali lubang dan menyembunyikan wang tuannya di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘Selepas beberapa lama, tuan kepada hamba-hamba itu pulang lalu menyelesaikan kira-kira dengan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hamba yang menerima lima keping wang emas dahulu membawakan lima keping lagi sambil berkata, “Tuan, tuan telah memberiku lima keping wang emas. Lihatlah, aku telah mendapatkan lima keping lagi dengannya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Tuannya berkata kepadanya, “Syabas, wahai hamba yang baik dan setia. Kamu setia mengurus yang sedikit, maka aku akan memberimu kuasa mengendalikan yang banyak. Nikmatilah kebahagiaan kurnia tuanmu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","‘Yang telah menerima dua keping wang emas pula datang lalu berkata, “Tuan, tuan telah memberiku dua keping wang emas. Lihatlah, aku telah mendapatkan dua keping lagi dengannya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Tuannya berkata kepadanya, “Syabas, wahai hamba yang baik dan setia. Kamu setia mengurus yang sedikit. Aku akan memberimu kuasa mengendalikan yang banyak. Nikmatilah kebahagiaan kurnia tuanmu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","‘Kemudian hamba yang menerima sekeping wang emas itu datang lalu berkata, “Tuan, aku tahu tuan berhati batu. Tuan menuai tanpa menyemai, memungut hasil tanpa menabur benih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jadi aku takut, lalu kusorokkan wang emas tuan itu di dalam tanah. Lihat, itulah hak milik tuan.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Tetapi tuannya menjawab, “Hai hamba yang jahat dan pemalas, kamu tahu aku menuai tanpa menyemai, memungut hasil tanpa menabur benih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Oleh itu sepatutnya kamu simpan wang itu di dalam bank, supaya ketika aku pulang, aku menerima wang itu dengan faedahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘ “Sekarang, wang sekeping itu kusuruh ambil daripadamu dan berikan kepada yang mempunyai sepuluh keping wang emas. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Demikianlah, kepada setiap orang yang ada, akan diberi lebih lagi, menjadikan dia penuh dengan kelimpahan; sebaliknya orang yang tidak ada, apa yang ada padanya pun akan diambil. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Buangkan hamba yang tidak berguna ini ke dalam kegelapan di luar. Di sana akan terdapat ratapan dan kertakan gigi.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‘Apabila Putera Insan datang dengan segala kemuliaan-Nya, diiringi sekalian malaikat suci, Dia akan duduk di atas takhta kemuliaan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Semua bangsa akan berhimpun di hadapan-Nya, dan Dia akan mengasing-asingkan mereka, sebagaimana gembala mengasing-asingkan domba daripada kambing. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dia akan meletakkan domba di sebelah kanan-Nya dan kambing di sebelah kiri-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","‘Kemudian Raja itu akan berkata kepada mereka yang di sebelah kanan-Nya, “Marilah, kamu yang diberkati oleh Bapa-Ku! Warisilah kerajaan yang telah disediakan untukmu sejak dunia dicipta. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kerana Aku lapar dan kamu memberi-Ku makanan; Aku dahaga dan kamu memberi-Ku minuman; Aku orang asing dan kamu menerima-Ku masuk ke rumahmu; ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Aku tidak berpakaian dan kamu memberi-Ku pakaian; Aku sakit dan kamu melawat-Ku; Aku di dalam penjara dan kamu datang kepada-Ku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","‘Orang yang benar itu pun bertanya, “Junjungan, bilakah kami melihat-Mu lapar dan memberi-Mu makanan, melihat-Mu dahaga dan memberi-Mu minuman? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bilakah kami melihat-Mu orang asing dan menerima-Mu masuk ke rumah, melihat-Mu tidak berpakaian dan memberi-Mu pakaian? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bila pula kami melihat-Mu sakit, atau di dalam penjara, dan datang kepada-Mu?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‘Raja akan menjawab, “Sesungguhnya, Aku berkata kepadamu, apabila kamu melakukannya kepada yang paling kecil antara saudara-saudara-Ku ini, ertinya kamu melakukannya kepada-Ku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‘Selepas itu Dia akan berkata kepada mereka yang di sebelah kiri-Nya, “Nyahlah dari sisiku, kamu yang terlaknat, ke dalam api abadi yang telah disediakan untuk Iblis dan para penyokongnya; ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","kerana Aku lapar dan kamu tidak memberi-Ku makanan; Aku dahaga dan kamu tidak memberi-Ku minuman. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aku orang asing dan kamu tidak menerima-Ku masuk ke rumahmu; Aku tidak berpakaian dan kamu tidak memberi-Ku pakaian; Aku sakit, Aku di dalam penjara, dan kamu tidak melawat-Ku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‘Mereka akan berkata, “Junjungan kami, bilakah kami melihat-Mu lapar, atau dahaga, orang asing, atau tidak berpakaian, atau sakit, atau di dalam penjara, dan tidak mengambil berat tentang-Mu?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‘Dia akan menjawab, “Sesungguhnya, Aku berkata kepadamu, apabila kamu tidak melakukannya kepada yang paling kecil antara saudara-saudara-Ku ini, ertinya kamu tidak melakukannya kepada-Ku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","‘Mereka itu akan menanggung azab hukuman selama-lamanya, manakala mereka yang benar akan menikmati hidup kekal.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Setelah selesai Isa menyampaikan semua ini, Dia pun berkata kepada pengikut-pengikut-Nya, ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","‘Kamu tahu bahawa dua hari lagi perayaan Paska menjelang, dan Putera Insan akan diserahkan untuk disalib.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ketua-ketua imam, guru-guru Taurat dan tua-tua berhimpun di rumah Imam Besar yang bernama Kayafas. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mereka berpakat untuk memperdaya Isa dan membunuh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tetapi mereka berkata, ‘Janganlah dilakukan pada masa perayaan, takut orang ramai merusuh.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Apabila Isa berada di Betani di rumah Simon, yang menghidap penyakit kusta, ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","seorang wanita mendekati-Nya dengan sebuah bekas alabaster berisi minyak wangi yang amat mahal, lalu menuangkan minyak itu ke atas kepala-Nya ketika Dia sedang bertelekan di meja. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Apabila pengikut-pengikut-Nya melihat perbuatan wanita itu, mereka marah lalu berkata, ‘Mengapa membazir begini? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Minyak wangi ini boleh dijual dengan harga yang tinggi dan wangnya boleh diberikan kepada orang miskin.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tetapi apabila Isa mengetahui kemarahan mereka, Dia berkata, ‘Mengapakah kamu menyusahkan wanita ini? Dia telah melakukan sesuatu yang baik untuk-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Orang miskin akan sentiasa ada di sekelilingmu, tetapi Aku tidaklah sentiasa bersamamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dengan menuangkan minyak wangi ini ke atas tubuh-Ku, dia melakukannya untuk pengebumian-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sesungguhnya, Aku berkata kepadamu, di mana-mana pun kelak Injil ini disampaikan di serata dunia, apa yang telah dilakukan oleh wanita ini akan dikisahkan juga sebagai kenangan kepadanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Selepas itu, seorang daripada dua belas orang pengikut Isa, bernama Yudas Iskariot, pergi berjumpa dengan ketua-ketua imam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Dia berkata kepada mereka, ‘Apakah yang sanggup kamu berikan kepadaku kalau kuserahkan Dia kepadamu?’ Mereka memberinya tiga puluh keping wang perak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sejak itu dia pun mencari peluang untuk mengkhianati Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pada hari pertama Perayaan Roti Tidak Beragi, pengikut-pengikut Isa mendapatkan-Nya lalu berkata, ‘Di manakah Junjungan mahu kami sediakan jamuan Paska untuk-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Isa menyuruh mereka ke bandar, mencari seorang tertentu dan mengatakan kepadanya, ‘Guru berkata, “Masa-Ku sudah hampir; Aku akan menyambut perayaan Paska di rumahmu bersama para pengikut-Ku.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pengikut-pengikut Isa menjalankan arahan-Nya lalu menyediakan jamuan perayaan Paska. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Menjelang malam, Dia pun bertelekan di meja bersama pengikutnya yang dua belas itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sambil makan itu Dia berkata, ‘Sesungguhnya, Aku berkata kepadamu, seorang daripadamu akan mengkhianati-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mereka sungguh berdukacita, dan setiap orang daripada mereka berkata kepada-Nya, ‘Junjungan, tentunya aku bukan orang itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Isa menjawab, ‘Orang yang mencecahkan tangannya bersama-Ku ke dalam bekas akan mengkhianati-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Putera Insan memanglah harus pergi sebagaimana telah tersurat, tetapi malanglah orang yang mengkhianati-Nya! Lebih baik lagi bagi orang itu jika tidak dilahirkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ketika itu Yudas yang akan mengkhianati-Nya bertanya, ‘Tuan Guru, akukah orangnya?’ Isa berkata kepadanya, ‘Kamu telah mengatakannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ketika mereka sedang makan, Isa mengambil roti, mengucap syukur lalu memecah-mecahkan dan membahagikannya kepada pengikut-pengikut-Nya sambil berkata, ‘Ambil dan makanlah, ini tubuh-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kemudian Dia mengambil cawan air anggur dan mengucap syukur kepada Allah lalu memberikannya kepada mereka sambil berkata, ‘Minumlah darinya, kamu semua. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kerana ini darah-Ku bagi perjanjian baru, ditumpahkan untuk umat manusia supaya hapus dosa mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tetapi, Aku berkata kepadamu, Aku tidak akan minum air anggur dari saat ini hinggalah hari Aku minum air anggur bersamamu dalam kerajaan Bapa-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Setelah menyanyikan sebuah lagu suci mereka pun beredar ke Bukit Zaitun. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kemudian Isa berkata kepada mereka, ‘Kamu semua akan goyah kerana-Ku malam ini, sebagaimana telah tersurat: “Aku akan merebahkan Gembala, dan kawanan domba akan bertempiaran.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","‘Tetapi setelah Aku dibangkitkan semula, Aku akan mendahului kamu ke Galilea.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrus menjawab, ‘Kalaupun semua yang lain goyah kerana-Mu, Junjungan, aku tidak akan goyah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Isa berkata kepadanya, ‘Sesungguhnya, Aku berkata kepadamu, pada malam ini juga, sebelum ayam berkokok, engkau akan menyangkal-Ku tiga kali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrus berkata kepada Isa, ‘Kalaupun aku terpaksa mati bersama-Mu, aku tidak akan menyangkal-Mu, Junjungan!’ Demikian jugalah kata pengikut-pengikut-Nya yang sebelas orang lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Selepas itu Isa pergi bersama mereka ke sebuah tempat bernama Getsemani, lalu Dia berkata kepada mereka, ‘Duduklah di sini sementara Aku berdoa di sana.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Isa membawa bersama-Nya Petrus dan kedua-dua anak Zebedeus. Dia mula berdukacita dan amat berpilu hati. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dia berkata kepada mereka, ‘Jiwa-Ku sungguh dukacita, bagaikan mati. Duduklah di sini berjaga bersama-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Isa pergi jauh sedikit dari situ lalu sujud menyembamkan muka ke tanah dan berdoa, ‘Ya Bapa-Ku, kalaulah dapat, edarkanlah cawan ini daripada-Ku; namun, biarlah kehendak-Mu berlaku, bukan kehendak-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kemudian Dia pergi kepada pengikut-pengikut-Nya dan mendapati mereka telah tertidur; lalu Dia berkata kepada Petrus, ‘Apa? Satu jam pun kamu tidak dapat berjaga bersama-Ku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Berjaga dan berdoalah, takut nanti kamu tergoda. Memang rohani rela, tetapi jasmani lemah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bagi kali kedua, Dia pergi dan berdoa, ‘Ya Bapa-Ku, jika cawan ini tidak mungkin beredar daripada-Ku melainkan Kuminum, biarlah kehendak-Mu berlaku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Selepas itu Dia mendapati mereka tidur lagi, kerana mata mereka sungguh mengantuk. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dia pun meninggalkan mereka dan pergi berdoa lagi, bagi kali ketiga. Dia mengucapkan kata-kata yang sama. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Setelah itu Dia mendapatkan pengikut-pengikut-Nya lalu berkata, ‘Adakah kamu masih tidur dan berehat? Lihatlah, masanya telah menjelang, dan Putera Insan sedang dikhianati untuk diserahkan ke tangan orang berdosa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bangunlah, ayuh kita pergi. Lihat, pengkhianat-Ku sudah tiba.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ketika Dia sedang berkata-kata itu, seorang daripada pengikut-Nya yang dua belas, Yudas, datang diiringi orang yang sangat ramai dan bersenjatakan pedang serta belantan. Mereka datang daripada ketua-ketua imam dan tua-tua. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Pengkhianat Isa telah menyatakan isyarat kepada mereka, ‘Yang kucium nanti, itulah orangnya; tangkaplah Dia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dengan segera dia menghampiri Isa sambil berkata, ‘Selamat sejahtera, Tuan Guru!’ lalu mencium-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Isa berkata kepadanya, ‘Kawan, mengapakah kamu datang?’ Orang ramai itu pun menangkap Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tiba-tiba seorang pengikut Isa menghunus pedangnya lalu menetak hamba Imam Besar, sehingga telinganya putus. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tetapi Isa berkata kepada pengikut-Nya itu, ‘Simpan semula pedangmu di tempatnya yang wajar, kerana semua yang menggunakan pedang akan musnah dimakan pedang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Adakah kamu sangka Aku tidak boleh berdoa supaya Bapa-Ku menghantar lebih daripada dua belas tentera malaikat untuk menolong-Ku? ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bukankah kejadian ini mesti berlaku supaya yang tersurat di dalam Kitab Suci ternyata benar?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kemudian Isa berkata kepada orang ramai itu, ‘Patutkah kamu datang, bagaikan hendak menangkap perompak, dengan pedang dan belantan, untuk membawa-Ku pergi? Hari demi hari Aku duduk bersamamu, mengajar di rumah ibadat, dan kamu tidak menangkap-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tetapi segala ini dilakukan untuk menunaikan apa yang tersurat di dalam kitab nabi-nabi.’ Setelah itu semua pengikut Isa meninggalkan-Nya, masing-masing melarikan diri. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Orang yang menangkap Isa membawa-Nya kepada Kayafas, Imam Besar. Di situ guru-guru Taurat dan tua-tua telah berhimpun. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus mengikut dari jauh ke bahagian laman dalam rumah Imam Besar, lalu masuk dan duduk di kalangan hamba-hamba di situ untuk melihat kesudahan perkara itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ketua-ketua imam dan seluruh Majlis Agama telah mencari kesaksian palsu terhadap Isa supaya dapat membunuh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tetapi mereka tidak berjaya. Sungguhpun ramai saksi palsu yang tampil, tidak didapati kesaksian yang dikehendaki itu. Akhirnya dua orang saksi tampil ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","dengan kesaksian: ‘Orang ini telah berkata, “Aku dapat memusnahkan rumah Allah dan membinanya semula dalam tiga hari.”’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Imam Besar berdiri lalu berkata kepada Isa, ‘Tidakkah kamu menjawab apa-apa? Apakah yang didakwakan oleh dua orang ini terhadap-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tetapi Isa berdiam diri. Imam Besar berkata kepada-Nya, ‘Demi Allah yang hidup, katakan kepada kami, adakah kamu ini al-Masih, Putera Allah?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Isa berkata kepadanya, ‘Benarlah seperti katamu. Namun, Aku berkata kepadamu, kemudian hari kelak kamu akan melihat Putera Insan duduk di sebelah kanan Yang Maha Kuasa, dan datang dalam awan di atas langit.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kemudian Imam Besar mengoyak-ngoyakkan pakaiannya sambil berkata, ‘Dia telah melafazkan kata-kata kufur! Apa perlunya saksi lagi? Sekarang kamu telah mendengar kata-kata kufur-Nya! ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bagaimana pendapatmu?’ Mereka menjawab, ‘Dia patut dibunuh.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Setelah itu mereka meludah muka-Nya dan memukul-Nya. Ada yang menampar-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Mereka berkata, ‘Bernubuatlah pada kami, hai al-Masih! Siapa yang memukul-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sedang Petrus duduk di laman dalam rumah itu, seorang hamba perempuan datang dan berkata kepadanya, ‘Kamu pun bersama Isa dari Galilea.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tetapi Petrus menyangkal di hadapan mereka semua, ‘Aku tak tahu apa yang kaukatakan itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Setelah Petrus pergi ke luar ke pintu gerbang, seorang perempuan lagi melihatnya dan berkata kepada orang di situ, ‘Orang ini pun bersama Isa orang Nasaret.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petrus menyangkal lagi sambil bersumpah, ‘Aku tak kenal orang itu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tidak lama kemudian orang yang berdiri-diri di situ menghampiri Petrus dan berkata kepadanya, ‘Sudah tentu kamu juga seorang daripada mereka; ini jelas daripada loghatmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petrus pun mengucapkan kutuk dan sumpah, ‘Aku tak kenal orang itu!’ Serta-merta ayam berkokok. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Lalu Petrus teringat kata-kata Isa kepadanya, ‘Sebelum ayam berkokok, engkau akan menyangkal-Ku tiga kali.’ Petrus pun keluar dari situ lalu menangis dengan amat kesalnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Setelah siang, semua ketua imam dan tua-tua berpakat untuk membunuh Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mereka menyuruh orang mengikat-Nya. Kemudian mereka membawa-Nya lalu menyerahkan-Nya kepada gabenor, Pontius Pilatus. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Apabila Yudas yang mengkhianati-Nya melihat bahawa Isa telah dijatuhi hukum mati, dia menyesali perbuatannya lalu mengembalikan tiga puluh keping wang perak ke hadapan ketua-ketua imam dan tua-tua. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yudas berkata, ‘Aku berdosa menyebabkan tumpahnya darah orang yang tidak bersalah.’ Kata mereka, ‘Apa kami peduli? Tanganilah sendiri!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas pun mencampakkan keping-keping wang perak itu ke dalam rumah ibadat lalu pergi menggantung dirinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ketua-ketua imam memungut wang perak itu lalu berkata, ‘Menurut hukum, kita tidak boleh memasukkan wang ini ke dalam perbendaharaan rumah ibadat, kerana wang ini harga darah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mereka bermesyuarat lalu menggunakan wang itu untuk membeli ladang tukang tembikar bagi dijadikan tempat perkuburan orang asing. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Oleh itu padang tersebut dipanggil Padang Darah hingga hari ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Dengan demikian berlakulah kata-kata Nabi Yeremia: ‘Maka mereka pun mengambil tiga puluh keping wang perak itu, harga Dia yang telah dinilai oleh anak-anak Israel, ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","lalu membeli padang untuk pengebumian orang asing, demikian firman Tuhan kepadaku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gabenor bertanya kepada Isa yang berdiri di hadapannya, ‘Adakah Kamu Raja orang Yahudi?’ Isa berkata, ‘Begitulah seperti katamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ketika Dia dituduh oleh ketua-ketua imam dan tua-tua, Dia tidak berkata suatu apa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kemudian Pilatus berkata kepada-Nya, ‘Tidakkah kamu dengar betapa banyaknya tuduhan terhadapmu dalam kesaksian mereka?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tetapi Isa tidak berkata sepatah pun, sehingga amat hairan gabenor melihat-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pada perayaan Paska, lazimnya gabenor membebaskan dari penjara seorang yang dikehendaki oleh orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pada masa itu ada seorang banduan yang terkenal jahatnya, bernama Barabas. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Setelah mereka berhimpun, Pilatus bertanya, ‘Yang mana kamu mahu aku bebaskan dan serahkan ke tanganmu, Barabas atau Isa yang dipanggil al-Masih?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Gabenor mengetahui bahawa mereka telah menyerahkan Isa kepadanya kerana iri hati. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sedang gabenor duduk di atas kerusi penghakiman, isterinya berkirim pesan kepadanya, ‘Jangan apa-apakan orang yang tidak bersalah; hari ini aku banyak menanggung azab dalam mimpi kerana-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tetapi ketua-ketua hakim dan tua-tua dapat meyakinkan orang ramai supaya meminta Barabas dibebaskan dan Isa dibunuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gabenor berkata kepada mereka, ‘Yang mana antara dua orang ini kamu mahu aku bebaskan dan serahkan ke tanganmu?’ Mereka menjawab, ‘Barabas!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus bertanya kepada mereka, ‘Jadi, apa yang harus kubuat dengan Isa yang dipanggil al-Masih?’ Kesemua mereka berkata kepadanya, ‘Salibkan Dia!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Gabenor berkata, ‘Mengapa, apakah kejahatan yang telah dilakukan-Nya?’ Tetapi mereka berseru semakin lantang, ‘Salibkan Dia!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Apabila Pilatus melihat bahawa dia tidak dapat mempengaruhi mereka malah mereka mula hendak merusuh, dia mengambil air lalu membasuh tangannya di hadapan orang ramai itu sambil berkata, ‘Aku bebas daripada kesalahan menumpahkan darah orang yang baik ini. Kamu tanganilah sendiri.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kesemua mereka menjawab, ‘Biarlah darah-Nya tertanggung di atas kami dan zuriat kami.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilatus pun membebaskan Barabas kepada mereka; dan setelah menyesah Isa, dia menyerahkan-Nya untuk disalib. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kemudian askar-askar gabenor membawa Isa ke balai istananya dan menghimpunkan seluruh pasukan tentera di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mereka melucutkan pakaian-Nya dan menyarungkan jubah ungu ke tubuh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mereka membuat mahkota daripada duri lalu meletakkannya di atas kepala Isa dan menggenggamkan mensiang di tangan kanan-Nya. Kemudian mereka berlutut kepada-Nya sambil mengejek-Nya, ‘Hai Raja orang Yahudi!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Selepas itu mereka meludahi-Nya dan memukul kepala-Nya dengan mensiang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Setelah selesai mereka mempermainkan-Nya, mereka melucutkan jubah ungu itu dan mengenakan semula pakaian-Nya lalu membawa-Nya untuk disalib. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dalam perjalanan, mereka bertemu dengan seorang lelaki dari Kirene bernama Simon. Mereka memaksanya mengangkat kayu salib Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mereka pun sampai di suatu tempat dipanggil Golgota, bermakna Tempat Tengkorak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Di situ mereka memberi-Nya air anggur masam bercampur hempedu dan menyuruh-Nya minum. Tetapi setelah merasanya, Dia enggan minum. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Selepas itu mereka menyalib-Nya, dan membahagikan pakaiannya dengan membuang undi, maka berlakulah seperti yang di nubuatkan: ‘Mereka bahagikan pakaian-Ku antara mereka, untuk mendapat pakaian-Ku mereka membuang undi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kemudian mereka duduk berjaga di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Di atas kayu salib Isa mereka memaparkan tuduhan terhadap-Nya: INILAH ISA RAJA ORANG YAHUDI. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dua orang perompak disalib bersama-Nya, seorang di kanan dan seorang di sebelah kiri-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Orang yang lalu di situ melemparkan kata-kata kufur kepada-Nya. Sambil menggeleng-gelengkan kepala ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mereka berkata, ‘Engkau dapat memusnahkan rumah ibadat dan membinanya semula dalam tiga hari; selamatkanlah diri-Mu! Kalau Engkau Putera Allah, turunlah dari kayu salib itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Begitu jugalah ketua-ketua imam, guru-guru Taurat dan tua-tua, turut mengejek Isa: ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","‘Dia telah menyelamatkan orang lain; diri-Nya sendiri tidak dapat diselamatkan-Nya. Kalau benar dia Raja Israel, turunlah dari kayu salib itu sekarang, baru kami percaya kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dia percayakan Allah. Biar Allah menyelamatkan-Nya sekarang, kalau Allah mahu mengakui-Nya; kerana Dia berkata, “Aku Putera Allah.”’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Perompak yang disalib bersama Isa pun menghina-Nya dengan kata-kata demikian. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dari tengah hari hingga tiga petang, seluruh negeri itu diselubungi kegelapan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kira-kira pukul tiga petang, Isa berseru dengan suara yang lantang, ‘Eloi, Eloi, lama sabakhtani?’ maksudnya ‘Ya Allah, Ya Tuhan-Ku, mengapa Kautinggalkan Aku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sesetengah orang yang berdiri di situ berkata, apabila mendengar seruan-Nya itu, ‘Orang ini memanggil Ilyas.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Serta-merta seorang daripada mereka mengambil span, memenuhinya dengan air anggur masam dan meletakkannya pada mensiang lalu menawarkannya kepada Isa sebagai minuman. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yang lain berkata, ‘Jangan hiraukan Dia; mari kita lihat kalau Ilyas datang menyelamatkan-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Isa berseru lantang sekali lagi, lalu menyerahkan roh-Nya dengan nafas terakhir. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sejurus itu tirai rumah ibadat koyak dari atas ke bawah, bumi digegar gempa dan batu-batu pejal terbelah; ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","kubur-kubur terbuka; dan banyak jenazah orang yang taat akan Allah dibangkitkan semula; ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","mereka keluar dari kubur dan selepas Isa dibangkitkan semula, mereka masuk ke kota suci itu dan menampakkan diri kepada sebilangan besar orang di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Apabila ketua tentera dan orangnya yang mengawal Isa melihat gempa bumi serta kejadian-kejadian lain, mereka pun ketakutan lalu berkata, ‘Benarlah Dia Putera Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ramai wanita yang telah mengikut Isa dari Galilea dan melayani-Nya ada di situ, melihat dari jauh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Antara mereka ialah Maryam Magdalena dan Maryam ibu kepada Yakobus dan Yusuf serta ibu kepada anak-anak Zebedeus. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Apabila malam menjelang, datang seorang hartawan dari Arimatea, bernama Yusuf, yang telah menjadi pengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dia pergi menghadap Pilatus dan memohon jenazah Isa. Pilatus pun memerintahkan orang menyerahkan jenazah itu kepadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusuf mengambil jenazah itu dan mengkafankannya dengan kain linen yang bersih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Dia membaringkan jenazah itu di dalam sebuah makam miliknya yang baru digalinya daripada batu pejal. Kemudian dia menggulingkan sebuah batu besar menutup pintu makam itu, lalu pergi dari situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ketika itu Maryam Magdalena ada di situ, begitu juga Maryam yang seorang lagi. Mereka sedang duduk berhadapan makam itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pada keesokannya, iaitu sehari selepas Hari Persediaan, ketua-ketua imam dan orang Farisi datang beramai-ramai menghadap Pilatus. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Mereka berkata, ‘Tuan, kami teringat, sewaktu Dia masih hidup si penipu itu ada berkata, “Selepas tiga hari Aku akan bangkit.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Oleh itu, silalah tuan perintahkan supaya dipastikan makam-Nya tidak dapat dibuka hingga tamat hari ketiga. Kami takut kalau-kalau para pengikut-Nya datang pada waktu malam dan mencuri mayat-Nya dibawa pergi, lalu berkata kepada orang ramai, “Dia telah bangkit daripada kematian.” Penipuan ini pasti lebih dahsyat daripada penipuan pertama.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus berkata kepada mereka, ‘Bawalah beberapa pengawal. Pergilah sendiri, buat apa yang kamu fikirkan perlu untuk menjaga makam itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mereka pun pergi melakukannya. Mereka memperkukuh makam itu supaya tidak dapat dibuka langsung, dan mereka menugaskan pengawal berjaga di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Selepas hari Sabat, ketika fajar menyingsing pada hari pertama minggu itu, Maryam Magdalena dan Maryam yang seorang lagi pergi melihat makam Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tiba-tiba terjadi gempa bumi yang hebat, kerana seorang malaikat Tuhan turun dari syurga lalu menggulingkan batu yang menutup makam itu dan duduk di atasnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wajahnya laksana kilat dan pakaiannya seputih salji. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Para pengawal menggeletar ketakutan apabila melihatnya, lalu menjadi seperti orang mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tetapi malaikat itu berkata kepada perempuan-perempuan itu, ‘Jangan takut, aku tahu kamu mencari Isa yang telah disalib. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Dia tidak ada di sini, kerana Dia telah bangkit semula, seperti yang dikatakan-Nya. Marilah lihat tempat Dia dibaringkan dulu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kemudian, segeralah pergi dan katakan kepada para pengikut-Nya bahawa Dia telah bangkit daripada kematian, dan Dia mendahului kamu ke Galilea. Di sana kamu akan melihat-Nya. Lihatlah, aku telah memberitahumu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mereka pun keluar dari makam itu dengan takut dan amat gembira, lalu berlari untuk membawa berita itu kepada para pengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Dalam perjalanan, tiba-tiba Isa menemui mereka sambil berkata, ‘Salam sejahtera!’ Lalu mereka pun mendekati Isa dan memegang kaki-Nya serta menyembah-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kemudian Isa berkata kepada mereka, ‘Jangan takut. Pergilah dan suruh saudara-saudara-Ku ke Galilea. Di sana mereka akan melihat-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sementara perempuan itu sedang dalam perjalanan, beberapa orang pengawal tersebut masuk ke kota dan melaporkan kepada ketua-ketua imam apa yang telah terjadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Setelah bermesyuarat dengan tua-tua, mereka memberikan sejumlah wang yang besar kepada askar-askar yang berkawal itu ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","serta berpesan, ‘Beritahu orang, “Para pengikut-Nya datang pada waktu malam dan mencuri mayat-Nya lalu dibawa pergi sewaktu kami sedang tidur.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kalau hal ini sampai ke telinga gabenor, kami akan melembutkan hatinya dan kamu tidak akan diapa-apakan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mereka menerima wang itu dan melakukan apa yang diarahkan. Cerita ini biasa disebarkan di kalangan orang Yahudi hingga sekarang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kemudian, pengikut Isa yang sebelas itu pergi ke Galilea, ke gunung yang telah ditetapkan oleh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Di sana mereka melihat-Nya lalu menyembah-Nya. Namun demikian, ada antara mereka yang ragu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Isa berkata kepada mereka, ‘Segala kekuasaan telah diserahkan kepada-Ku, baik di syurga mahupun di bumi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Oleh itu pergilah, jadikan semua bangsa pengikut-Ku. Imadkan mereka dengan nama Bapa, Putera dan Roh Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ajar mereka supaya taat akan segala perkara yang telah Kuperintahkan kepadamu. Aku akan sentiasa bersamamu, hingga ke akhir zaman.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Inilah permulaan Injil tentang Isa al-Masih, Putera Allah, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Seperti yang tersurat dalam nubuat Nabi Yasyaya: ‘Lihatlah, Aku akan menghantar utusan-Ku untuk mendahului-Mu, dialah yang akan menyediakan jalan bagi-Mu’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘satu suara berseru di gurun, “Sediakanlah jalan bagi Tuhan, luruskanlah jalan bagi-Nya.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Demikianlah Yahya muncul di gurun, mengimadkan orang dan mengkhabarkan firman – bertaubatlah dan datanglah untuk diimadkan, supaya Allah mengampunkan dosamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ramailah orang yang datang dari Yudea dan Baitulmaqdis untuk mendengar kata-kata Yahya. Mereka mengakui dosa mereka lalu Yahya mengimadkan mereka di Sungai Yordan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahya berpakaian yang dibuat daripada bulu unta dengan tali pinggang daripada kulit. Makanannya belalang dan madu gurun. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Inilah beritanya: ‘Seorang yang lebih besar daripadaku akan datang selepasku. Tali kasut-Nya pun tidak layak kuurai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aku mengimadkanmu dengan air, tetapi Dia akan mengimadkanmu dengan Roh Suci.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kemudian Isa datang dari Nasaret di Galilea, lalu diimadkan oleh Yahya di Sungai Yordan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ketika Isa keluar dari sungai itu, Dia melihat langit terbuka dan Roh Suci seperti burung merpati turun hinggap ke atas-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lalu kedengaran suara dari syurga: ‘Engkaulah Putera-Ku yang Kukasihi dan dengan-Mu Aku berkenan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lantas, Roh Suci memimpin Isa ke gurun. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Isa di situ selama empat puluh hari dan digoda oleh Iblis serta dikelilingi binatang liar. Para malaikat datang melayani-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Setelah Yahya dipenjarakan, Isa pergi ke Galilea lalu mengkhabarkan Injil daripada Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Isa berkata, ‘Sudah genap masanya dan kerajaan Allah hampir tiba. Bertaubatlah dan percayalah akan Injil ini!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ketika Isa sedang berjalan di pinggir Laut Galilea, Dia terpandang dua orang nelayan, Simon dan saudaranya Andreas, sedang menjala ikan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Isa berkata kepada mereka, ‘Ikutlah Aku. Aku akan menjadikan kamu penjala insan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mereka terus meninggalkan jala mereka dan mengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sejurus berjalan, Isa melihat dua orang lagi adik-beradik, bernama Yakobus dan Yahya, anak Zebedeus. Mereka sedang duduk mengemaskan jala di dalam perahu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Isa terus memanggil mereka. Kedua-dua beradik itu meninggalkan bapa mereka dengan orang gajinya di dalam perahu, lalu mengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Isa dan pengikut-pengikut-Nya tiba di Kapernaum. Pada hari Sabat berikutnya, Isa masuk ke saumaah lalu mengajar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Semua yang mendengar-Nya kagum kerana Dia mengajar dengan penuh kewibawaan, berbeza dari guru-guru Taurat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ketika itu seorang yang dirasuk roh durjana berada di saumaah. Dia berseru: ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","‘Apa yang hendak Kaubuat kepada kami, hai Isa orang Nasaret? Adakah Engkau hendak membinasakan kami? Aku tahu siapa Engkau. Engkau Yang Suci daripada Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Isa membentak roh itu, ‘Diam! Keluar daripada orang ini!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Roh durjana itu menggoncang-goncang tubuh orang yang dirasuknya lalu keluar sambil menjerit. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hal ini menyebabkan semua orang tercengang lalu berbisik sesama sendiri, ‘Adakah ini suatu ajaran baru? Dia memerintah roh-roh durjana dengan penuh kuasa dan mereka menurut kata-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dengan demikian, khabar tentang Isa segera tersebar ke seluruh Galilea. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Isa dan pengikut-Nya, termasuk Yakobus dan Yahya, keluar dari saumaah itu lalu ke tempat kediaman Simon dan Andreas. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ibu mertua Simon sedang demam terbaring di tempat tidur. Setibanya Isa di situ, Dia diberitahu tentang hal itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Isa menghampiri ibu mertua Simon, memegang tangannya dan menolongnya bangun. Demam wanita itu hilang lalu dia melayani mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Apabila malam menjelang, semua orang sakit dan orang yang dirasuk roh iblis dibawa kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Semua penduduk kota berhimpun di hadapan rumah itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Isa menyembuhkan ramai orang daripada pelbagai penyakit. Dia juga menghalau roh-roh iblis sambil memerintahkan mereka diam kerana mereka tahu siapa Dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Keesokannya, pada waktu subuh, Isa bangun lalu pergi ke luar kota ke suatu tempat yang sunyi untuk berdoa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon dan rakan-rakannya pergi mencari Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Setelah menjumpai-Nya, mereka berkata: ‘Semua orang sedang mencari-Mu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Isa berkata, ‘Kita mesti ke kota-kota lain di negeri ini supaya Aku dapat menyebarkan Injil di sana. Kerana tujuan inilah, maka Aku datang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Lalu Isa menjelajah ke serata Galilea, mengajar di saumaah dan menghalau roh-roh iblis. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Seorang yang menghidap penyakit kusta datang kepada Isa lalu berlutut meminta pertolongan-Nya. Katanya, ‘Jika Engkau mahu, Engkau dapat mentahirkanku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Isa berbelas kasihan lalu menghulurkan tangan-Nya menyentuh orang itu sambil berkata, ‘Aku mahu. Tahirlah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pada saat itu juga orang itu ditahirkan daripada penyakit kusta. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Isa menyuruhnya pergi dengan memberi suatu peringatan keras: ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","‘Dengar baik-baik. Jangan beritahu sesiapapun hal ini. Tetapi pergi kepada imam, kemudian persembahkan korban sebagaimana diperintahkan oleh Musa, sebagai bukti kepada mereka bahawa kamu benar-benar sudah ditahirkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tetapi orang itu menyebarkan hal itu merata-rata dan terus-menerus, sehingga Isa tidak dapat masuk ke bandar terang-terangan. Isa tinggal di luar kota di tempat-tempat yang lengang, namun orang dari pelbagai kawasan datang kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Beberapa hari kemudian, Isa pulang ke Kapernaum dan tersebarlah khabar itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ramailah orang datang berhimpun di rumah tempat Dia tinggal itu, sehingga penuh sesak sampai ke pintu. Isa pun menyampaikan firman kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Datanglah empat orang mengusung seorang yang lumpuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Oleh sebab kesasakan itu, mereka tidak dapat membawanya kepada Isa. Oleh itu mereka membuka bumbung rumah betul-betul di atas tempat Isa berada lalu menurunkan orang lumpuh yang terbaring di atas tikar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Melihat iman mereka yang begitu teguh, Isa berkata kepada orang lumpuh itu, ‘Anak-Ku, dosamu telah diampunkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Guru-guru Taurat yang duduk di situ berkata dalam hati, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","‘Lancangnya dia mengkufuri Allah! Tiada siapa boleh mengampunkan dosa kecuali Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tetapi Isa segera mengetahui dalam roh-Nya bahawa mereka berfikir demikian lalu berkata, ‘Mengapa kamu berfikir begitu? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Manakah yang lebih mudah dikatakan: “Dosamu telah diampunkan,” atau, “Bangun, angkat tikarmu dan berjalanlah”? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tetapi supaya kamu tahu bahawa di bumi ini Putera Insan berkuasa mengampunkan dosa...’ Berkatalah Dia kepada orang lumpuh itu, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‘Aku berkata kepadamu, bangun, angkat tikarmu, dan pulanglah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Di hadapan mata mereka semua, orang lumpuh itu bangun, mengangkat tikarnya lalu segera berjalan ke luar. Semua orang di situ kehairanan lalu memuji Allah. Mereka berkata, ‘Belum pernah kami lihat kejadian begini!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Isa pergi lagi ke pinggir laut. Ramai orang datang kepada-Nya lalu Dia mengajar mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ketika Isa berjalan di situ, Dia terpandang seorang pemungut cukai bernama Lewi anak Alfeus sedang duduk di tempat kerjanya. Isa berkata kepadanya, ‘Ikutlah Aku,’ lalu Lewi bangun mengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Selepas itu Isa makan di rumah Lewi. Ramai pemungut cukai dan ‘orang berdosa’ mengikut Isa dan ramai antara mereka turut makan bersama Isa serta para pengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Apabila hal ini dilihat oleh sebilangan guru Taurat daripada golongan Farisi, mereka bertanya kepada para pengikut Isa: ‘Mengapa dia makan bersama pemungut cukai dan “orang berdosa”?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Isa mendengar pertanyaan itu lalu menjawab, ‘Orang sakitlah yang memerlukan tabib, bukannya orang sihat. Aku datang bukan untuk memanggil orang yang benar, tetapi orang berdosa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pada suatu masa ketika para pengikut Yahya Pengimad dan pengikut orang Farisi berpuasa, beberapa orang datang kepada Isa lalu bertanya, ‘Pengikut Yahya Pengimad dan pengikut orang Farisi sedang berpuasa, mengapa pengikut-Mu tidak?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Isa menjawab, ‘Adakah tetamu di majlis jamuan kahwin berpuasa? Tentu tidak, selagi pengantin lelaki masih bersama mereka, tidaklah mereka berpuasa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tetapi akan tiba saatnya pengantin lelaki dibawa pergi meninggalkan mereka. Ketika itulah mereka berpuasa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","‘Tiada siapa menggunakan kain baru untuk menampal pakaian lama, kerana kain baru itu akan mengecut dan semakin koyaklah pakaian lama. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Begitu juga, tiada siapa menuangkan air anggur yang baru ke dalam bekas kulit yang lama. Kalau dilakukan, air anggur baru akan memecahkan bekas lama, dan kedua-duanya terbuang. Air anggur baru mesti dituangkan ke dalam bekas yang baru.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pada suatu hari Sabat, Isa dan para pengikut-Nya berjalan melalui ladang gandum. Para pengikut-Nya mula memetik beberapa tangkai bijirin gandum. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sebilangan orang Farisi berkata kepada Isa, ‘Lihatlah, para pengikutmu melanggar hukum Taurat pada hari Sabat!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Isa menjawab, ‘Tidakkah kamu membaca apa yang dilakukan oleh Daud semasa dia dan anak buahnya kekurangan dan kelaparan? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dia masuk ke khemah Allah sewaktu Abiatar berjawat sebagai Imam Besar lalu makan roti persembahan, meskipun perbuatan itu dilarang kerana hanya imam dibenarkan makan roti itu. Daud juga memberikan roti itu kepada mereka yang ada bersamanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Isa menambah, ‘Hari Sabat diwujudkan untuk manusia, bukannya manusia diwujudkan untuk hari Sabat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jadi Putera Insan juga Junjungan atas hari Sabat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kemudian Isa kembali ke saumaah. Di situ ada seorang yang lumpuh sebelah tangannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ada beberapa orang yang ingin mencari alasan untuk membuat tuduhan terhadap Isa. Mereka memerhatikan dengan teliti sama ada Dia akan menyembuhkan orang itu pada hari Sabat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Isa berkata kepada orang yang lumpuh sebelah tangannya itu, ‘Berdiri, marilah ke depan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kemudian Dia menyoal orang di situ, ‘Manakah yang boleh kita lakukan pada hari Sabat: berbuat baik atau jahat? Menyelamatkan atau membinasakan orang?’ Tetapi semuanya berdiam diri. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Isa memandang orang di sekeliling-Nya dengan rasa marah dan amat dukacita dengan mereka yang begitu keras kepala. Lalu Dia berkata kepada orang yang lumpuh sebelah tangannya itu, ‘Hulurkan tanganmu.’ Orang itu pun menghulurkan tangannya yang lumpuh, tangan itu terus sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Orang Farisi keluar dari situ lalu segera berpakat dengan beberapa anggota golongan Herodes untuk membunuh Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Isa beredar ke laut bersama pengikut-pengikut-Nya. Ramai orang Galilea datang kepada-Nya. Ada yang dari Yudea, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Baitulmaqdis, Idumea, seberang Sungai Yordan, dan sekitar Tirus dan Sidon. Mereka datang berduyun-duyun kerana mendengar segala yang telah dilakukan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Begitu ramainya orang sehingga Isa menyuruh pengikut-Nya menyediakan perahu untuk-Nya supaya Dia tidak terhimpit. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ramai orang telah disembuhkan-Nya. Oleh itu, orang sakit berebut-rebut hendak menyentuh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Apabila orang yang dirasuk roh-roh durjana melihat-Nya, mereka sujud di hadapan-Nya lalu berseru, ‘Engkau Putera Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Isa melarang keras mereka mengatakan siapa Dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kemudian Isa naik ke bukit. Dia memanggil semua orang yang dikehendaki-Nya lalu mereka datang kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Isa memilih dua belas orang antara pengikut-Nya itu untuk menyertai-Nya dan untuk diutus-Nya memberitakan Injil ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","serta dikurniai kuasa untuk menghalau roh-roh iblis. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Dua belas orang yang dipilih-Nya itu ialah: Simon (yang juga dipanggil-Nya Petrus); ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobus dan saudaranya Yahya iaitu anak-anak Zebedeus (dua orang adik-beradik ini digelar-Nya Boanerges, yang bermakna Anak Petir); ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Filipus, Bartolomeus, Matius, Tomas, Yakobus anak Alfeus, Tadeus, Simon orang Patriot ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","dan juga Yudas Iskariot yang kelak mengkhianati-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Selepas itu Isa masuk ke sebuah rumah, tetapi begitu ramainya orang yang datang berkumpul semula sehingga Isa dan pengikut-pengikut-Nya tidak sempat makan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Apabila keluarga Isa mendengar perkara ini, mereka juga datang untuk mengambil-Nya apabila mendengar orang berkata, ‘Dia tidak siuman.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sebilangan guru Taurat dari Baitulmaqdis berkata, ‘Dia dirasuk Beelzebul! Dengan kuasa penghulu roh iblis Dia menghalau roh-roh iblis.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Oleh itu Isa memanggil semua orang itu lalu bercakap melalui beberapa ibarat: ‘Bagaimana Iblis dapat menghalau Iblis? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kalau satu kerajaan berpecah belah, kerajaan itu tidak dapat bertahan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dan jika keluarga berpecah belah, keluarga itu akan hancur. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Dan jika Iblis berontak melawan dirinya sendiri dan berpecah belah, dia tidak dapat bertahan; sudah sampailah saat kemusnahannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tiada siapa dapat memasuki rumah seorang yang gagah dan merampas hartanya, kecuali orang gagah itu dapat diikatnya dahulu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ingatlah: Segala dosa dan kata kufur manusia dapat diampunkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tetapi sesiapa yang mengkufuri Roh Suci tidak akan diampunkan; dia bersalah kerana berbuat dosa kekal.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Isa berkata demikian kerana ada orang berkata, ‘Dia dirasuk roh durjana.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Apabila ibu dan saudara-saudara Isa tiba, mereka menanti di luar dan menyuruh orang memanggil-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pada waktu itu, orang ramai duduk di sekeliling Isa berkata kepada-Nya, ‘Lihatlah! Ibu dan saudara-saudara-Mu ada di luar. Mereka memanggil Engkau.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Isa menjawab, ‘Siapakah ibu-Ku? Siapakah saudara-saudara-Ku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dia memandang semua orang yang duduk di sekeliling-Nya lalu berkata, ‘Lihat, inilah ibu dan saudara-saudara-Ku! ");
INSERT INTO zlmKSZI_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sesiapa yang melakukan kehendak Allah, dialah saudara lelaki, saudara perempuan, dan ibu-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Isa mula mengajar lagi di pinggir laut. Begitu ramainya orang datang berasak-asak di sekeliling-Nya sehingga Dia terpaksa duduk di dalam sebuah perahu di laut itu manakala orang ramai berdiri di pantai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Isa mengajar mereka banyak perkara melalui ibarat. Dalam ajaran-Nya itu, Dia berkata: ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","‘Dengarlah! Seorang peladang pergi menabur benih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Semasa dia menabur benih, ada yang jatuh di jalan, lalu habis dimakan burung. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ada yang jatuh di tempat yang berbatu dan kurang tanahnya. Benih itu cepat tumbuh kerana tanahnya tidak dalam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tetapi ketika matahari naik, tunas-tunas itu layu lalu kering kerana tidak mempunyai akar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ada pula yang jatuh di tengah semak berduri, lalu semak membesar dan membantutkannya sehingga tidak berbuah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tetapi ada benih yang jatuh di tanah subur lalu bertunas, membesar dan berbuah, hasilnya tiga puluh, enam puluh atau seratus kali ganda.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lalu kata-Nya, ‘Jika kamu bertelinga, dengarlah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ketika Isa bersendirian, dua belas pengikut-Nya dan beberapa orang yang ada bersama-Nya menanya Dia erti ibarat itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Isa berkata kepada mereka, ‘Kamu telah diberi anugerah untuk mengetahui rahsia kerajaan Allah. Tetapi orang luar akan mendengarnya melalui ibarat, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","supaya ‘ “Mereka terus melihat tetapi tidak nampak, mereka terus mendengar tetapi tidak faham; kerana sekiranya mereka mengerti, mereka akan bertaubat dan diampuni!” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kemudian Isa bertanya kepada mereka, ‘Jika kamu tidak memahami ibarat itu, bagaimanakah kamu dapat mengerti ibarat yang lain? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Peladang itu menabur firman. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ada orang seperti benih di jalan, tempat firman itu ditabur. Sebaik-baik mereka mendengar firman, datanglah Iblis untuk mengambil firman yang sudah ditabur di dalam hati mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ada orang lain seperti benih yang ditabur di tempat berbatu. Mereka mendengar firman itu dan segera menerimanya dengan sukacita, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","tetapi akarnya tidak dalam di hati, maka tidak tahan lama. Apabila orang itu menanggung kesusahan atau penganiayaan kerana firman itu, mereka segera berpaling. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ada yang lain seperti benih yang ditabur di tengah semak berduri. Mereka mendengar firman itu, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tetapi kerunsingan tentang hidup, tarikan palsu harta benda dan aneka kemahuan lain membantutkan firman itu sehingga tidak berbuah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dan yang lain seperti benih yang ditabur di tanah subur. Mereka mendengar dan menyambut firman itu lalu mendatangkan hasil: tiga puluh, enam puluh atau seratus kali ganda.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Isa berkata pula, ‘Pernahkah orang memasang pelita lalu meletakkannya di bawah pasu atau katil? Tentu diletakkannya di atas kaki pelita. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yang tersembunyi akan dinyatakan, yang dirahsiakan akan didedahkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jika kamu bertelinga, dengarlah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Selepas itu Isa berkata, ‘Perhatikan apa yang kamu dengar. Ukuran yang kamu gunakan untuk mengukur akan digunakan terhadapmu, malah lebih berat lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sesiapa yang ada sesuatu akan diberi lebih banyak lagi; tetapi sesiapa yang tidak ada, sedikit yang ada padanya pun akan diambil daripadanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Isa berkata seterusnya, ‘Kerajaan Allah ibarat seorang yang menabur benih di ladangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Malam dia tidur, siang dia bekerja. Benih itu terus-menerus tumbuh dan membesar. Dia tidak faham bagaimana hal itu terjadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tanahlah yang menumbuhkan tanaman hingga berbuah – mula-mula pucuk, kemudian bulir, akhirnya buah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Setelah masak, buahnya dituai oleh orang itu kerana musim menuai telah tiba.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","‘Bagaimanakah kerajaan Allah?’ kata Isa lagi. ‘Apakah ibarat yang dapat digunakan untuk menjelaskannya? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Keadaannya seperti biji sesawi yang ditabur di tanah, iaitu benih terkecil di dunia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tetapi apabila ditabur, benih itu tumbuh dan menjadi tumbuhan yang terbesar. Dahannya begitu rimbun sehingga burung membuat sarang di bawah keteduhannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Dengan banyak ibarat yang semacam itu Isa mengajar tentang firman kepada mereka, setakat yang dapat mereka faham. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dia tidak berkata-kata kepada mereka tanpa ibarat. Tetapi apabila Dia sendirian dengan para pengikut-Nya, Dia menerangkan segala-galanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pada petang itu juga, Isa berkata kepada para pengikut-Nya, ‘Marilah kita pergi ke seberang sana.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ketika itu Isa di dalam perahu. Para pengikut-Nya meninggalkan orang ramai itu di pantai lalu belayar bersama-Nya. Ada beberapa perahu lain yang belayar bersama-sama. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lalu angin bertiup kencang dan ombak melanda perahu sehingga hampir dipenuhi air. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ketika itu Isa sedang tidur di bahagian belakang perahu, kepala-Nya beralaskan bantal. Para pengikut-Nya mengejutkan Dia lalu berkata, ‘Tuan Guru, tidakkah Engkau peduli? Kita hampir karam!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Isa bangun lalu memarahi angin dan berkata kepada ombak, ‘Diam! Tenanglah!’ Angin pun reda dan laut menjadi tenang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kemudian Isa berkata kepada para pengikut-Nya, ‘Mengapa kamu begitu takut? Mengapa kamu masih tidak percaya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mereka berasa gerun lalu berkata sesama sendiri, ‘Siapakah Dia ini? Angin dan ombak pun taat kepadanya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lalu sampailah mereka di seberang laut, di daerah Gerasa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sebaik-baik Isa turun dari perahu, seorang lelaki yang kerasukan roh durjana keluar dari perkuburan lalu menemui-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Orang itu tinggal di kawasan perkuburan. Tiada siapa terdaya mengikatnya lagi, meskipun dengan rantai. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Berkali-kali dia dirantai dan dibelenggu, tetapi dapat diputuskannya rantai itu dan dipatahkannya belenggu itu. Tiada seorang pun dapat menguasainya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Siang malam dia merayau di perkuburan dan di bukit, sambil menjerit-jerit dan mencederakan badannya dengan batu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dari jauh dia melihat Isa lalu lari mendekati-Nya dan sujud di hadapan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Orang itu berseru dengan suara keras, ‘Hai Isa, Putera Allah Yang Maha Tinggi, apa urusan-Mu dengan aku? Demi Allah, jangan seksa aku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kerana sebelumnya Isa berkata kepadanya, ‘Roh durjana, keluarlah kamu daripada orang ini!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kemudian Isa bertanya kepadanya, ‘Siapa namamu?’ Orang itu menjawab, ‘Legion, kerana kami ini ramai sekali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dia memohon sungguh-sungguh kepada Isa supaya tidak menghalau mereka keluar dari kawasan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Berdekatan tempat itu ada kawanan babi yang sedang mencari makan di lereng bukit. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Roh-roh iblis itu memohon kepada Isa, ‘Suruhlah kami pindah ke babi itu, biarlah kami masuk ke dalam tubuh babi itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Isa bersetuju, lalu roh-roh durjana itu keluar dan masuk ke dalam tubuh kawanan babi itu. Kesemua babi itu, kira-kira dua ribu ekor, terjun dari tepi cenuram ke dalam laut lalu mati lemas. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Penjaga-penjaga babi itu lari lalu menyebarkan berita itu di bandar dan di desa. Para penduduk pun keluar hendak melihat apa yang telah terjadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mereka menghampiri Isa lalu melihat orang yang tadinya dirasuk roh iblis yang banyak itu, kini duduk diam, sudah berpakaian dan ternyata siuman. Mereka semua pun ketakutan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Semua yang telah menyaksikan kejadian itu menceritakan segala-galanya tentang orang yang kerasukan roh iblis dan kawanan babi itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Oleh itu mereka meminta Isa meninggalkan daerah itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ketika Isa menaiki perahu, orang yang tadinya dirasuk roh iblis itu memohon kepada-Nya, supaya dia dibenarkan menyertai-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tetapi Isa tidak membenarkan, sebaliknya berkata, ‘Pulanglah kepada keluargamu, kepada orang sekampungmu. Beritahu mereka betapa besarnya pertolongan Tuhan bagimu dan bagaimana Dia telah berbelas kasihan pada kamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Orang itu pun mula menjelajahi daerah sepuluh kota dan menceritakan segala yang telah dilakukan oleh Isa untuknya. Mereka semua kehairanan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Setelah itu, Isa kembali menyeberang laut dengan perahu. Setiba-Nya di pantai sebelah sana, Dia dikerumuni orang yang ramai sekali. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Datanglah Yairus, seorang ketua saumaah di situ. Ketika dia melihat Isa, dia sujud di hadapan-Nya ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","dan merayu, ‘Anak perempuanku sakit tenat, hampir mati. Tolonglah datang, letakkan tangan-Mu padanya, supaya dia sembuh dan dapat terus hidup.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Isa pun pergi bersama Yairus. Begitu ramainya orang yang mengikut Isa sehingga Dia diasak dari semua pihak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Di situ ada seorang wanita yang sudah dua belas tahun menghidap penyakit pendarahan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dia telah menghabiskan segala hartanya untuk dirawat oleh ramai tabib tetapi tidak sembuh, semakin parah keadaannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Wanita itu telah banyak mendengar tentang Isa. Oleh itu, dia masuk ke tengah-tengah orang ramai itu dan mendekati Isa dari belakang lalu menyentuh jubah-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","‘Kiranya dapat kusentuh jubah-Nya,’ kata wanita itu, ‘tentu aku akan sembuh.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Dengan serta-merta pendarahannya berhenti. Dia merasakan dirinya sudah sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pada saat itu Isa sedar ada kuasa yang telah keluar daripada-Nya lalu Dia bertanya, ‘Siapa yang menyentuh jubah-Ku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Para pengikut-Nya berkata, ‘Lihatlah orang berasak-asak di sekeliling Engkau. Bagaimana Engkau boleh bertanya siapa yang menyentuh-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tetapi Isa memandang sekeliling-Nya, mencari orang yang telah menyentuh-Nya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wanita itu mengetahui apa yang telah terjadi kepada dirinya. Dia gementar ketakutan, lalu tampil dan sujud kepada Isa serta menceritakan segala-galanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Isa berkata kepadanya, ‘Hai anak-Ku, imanmu telah menyembuhkan kamu. Pergilah dengan sejahtera dan sembuhlah daripada penyakitmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sedang Isa berkata-kata itu, beberapa orang pesuruh datang daripada keluarga ketua saumaah dan memberitahu Yairus, ‘Anak perempuan tuan sudah meninggal. Usahlah tuan susahkan Tuan Guru lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Isa tidak menghiraukan kata-kata itu. Dia berkata kepada Yairus, ‘Jangan takut, percaya saja.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Lalu Isa tidak membenarkan siapapun mengikut-Nya kecuali Petrus, Yakobus dan Yahya, saudara Yakobus. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Apabila tiba di rumah Yairus, Isa melihat keadaan yang kelam-kabut dan mendengar ratap tangis yang kuat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Isa masuk lalu berkata kepada mereka, ‘Mengapa kelam-kabut dan menangis? Anak itu tidak mati, cuma tidur.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tetapi mereka mentertawakan Isa. Setelah menyuruh mereka semua keluar, Isa mengajak ibu bapa anak itu dan pengikut-pengikut-Nya masuk ke bilik tempat anak itu terbaring. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Isa memegang tangan anak itu lalu berkata kepadanya, ‘Talitha kum!’ (maksudnya, ‘Anak perempuan, Aku berkata kepadamu, bangunlah!’). ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Anak perempuan yang berusia dua belas tahun itu segera bangkit lalu berjalan. Mereka semua sungguh kagum. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tetapi dengan tegas Isa melarang mereka memberitahu sesiapa tentang perkara itu, lalu menyuruh mereka memberi anak itu makan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Isa beredar dari situ lalu pulang bersama para pengikut-Nya ke kampung halaman-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pada hari Sabat Dia mula mengajar di saumaah. Jemaah di situ hairan mendengar ajaran Isa. ‘Dari manakah Dia memperoleh semua ini?’ tanya mereka. ‘Apakah kebijaksanaan yang ada pada-Nya? Bagaimanakah Dia dapat melakukan mukjizat? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bukankah Dia ini tukang kayu, anak kepada Maryam, saudara kepada Yakobus, Yoses, Yudas dan Simon? Bukankah saudara-saudara perempuan-Nya tinggal di sini?’ Oleh itu mereka enggan menerima-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Isa berkata kepada mereka, ‘Seorang nabi dihormati di mana-mana kecuali di kampung halamannya, di antara sanak-saudaranya dan di dalam keluarganya sendiri.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dia tidak dapat melakukan satu mukjizat pun di situ. Dia hanya menyembuhkan beberapa orang sakit dengan meletakkan tangan-Nya pada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Dia sungguh hairan bahawa mereka tidak percaya. Selepas itu, Isa pergi ke kampung-kampung di sekitar itu dan mengajar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dia memanggil pengikut-Nya yang dua belas itu, lalu mengutus mereka berdua-dua, serta memberi mereka kuasa atas roh-roh durjana. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Perintah-Nya kepada mereka demikian: ‘Jangan bawa apa-apa dalam perjalanan, kecuali sebatang tongkat – roti pun jangan, beg pun jangan, wang dalam ikat pinggang pun jangan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pakailah capal, tetapi sehelai baju sahaja.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Isa berkata lagi, ‘Apabila kamu disambut di sesebuah rumah, tinggallah di situ hingga kamu beredar dari kota itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sebaliknya, jika penduduk sesuatu kota enggan menerimamu atau mendengar kata-katamu, pergilah dari situ dan kebaskan debu daripada tapak kakimu sebagai kesaksian terhadap mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pengikut Isa yang dua belas itu pun pergi menyampaikan berita bahawa manusia harus bertaubat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mereka menghalau banyak roh iblis, dan menyapukan minyak pada ramai orang sakit serta menyembuhkan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Raja Herodes mendengar tentang kejadian itu, kerana nama Isa sudah terkenal di mana-mana. Ada orang berkata, ‘Yahya Pengimad sudah hidup semula! Itulah sebabnya dia ini berkuasa melakukan mukjizat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yang lain berkata, ‘Dia ini Ilyas.’ Ada pula yang berkata, ‘Dia ini nabi, seperti nabi zaman dahulu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ketika mendengar hal demikian, Herodes berkata, ‘Dia itu Yahya yang kepalanya telah kupancung, tetapi dia hidup semula!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ini kerana memang Herodes telah memberikan perintah supaya Yahya ditangkap, diikat dan dipenjarakan. Herodes berbuat demikian kerana Herodias, isteri kepada saudaranya Filipus, yang telah dikahwininya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yahya pernah menegur perbuatan Herodes itu, ‘Tuanku bersalah mengahwini isteri saudara sendiri.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Akibatnya Herodias menaruh dendam terhadap Yahya dan ingin membunuhnya, tetapi hasratnya terhalang, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","sebab Herodes takut akan Yahya. Herodes tahu Yahya seorang yang benar dan suci, oleh itu dia melindungi Yahya. Herodes juga suka mendengar kata-kata Yahya, meskipun kata-kata itu membuatnya sangat gelisah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Akhirnya Herodias mendapat peluang apabila Raja Herodes mengadakan jamuan hari jadinya untuk semua pegawai tinggi kerajaan, panglima dan tokoh masyarakat Galilea. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Anak gadis Herodias menari dan menghiburkan Herodes serta tetamunya. Oleh itu raja berkata kepada gadis itu, ‘Mintalah daripadaku apa saja yang kamu ingini dan akan kuberikan kepadamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dia menyambung dengan sumpah, ‘Apa sahaja yang kamu minta akan kuberi kepadamu, walau separuh kerajaanku sekalipun.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Gadis itu pergi bertanya kepada ibunya, ‘Apakah yang patut kuminta?’ Jawabnya, ‘Kepala Yahya Pengimad.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Gadis itu segera kembali kepada raja dan berkata, ‘Aku mahu kamu beri kepadaku kepala Yahya Pengimad di atas talam sekarang juga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Lalu raja amat berdukacita, tetapi apakan daya, dia telah bersumpah di hadapan semua tetamunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dia pun memberikan perintah kepada askar supaya membawakan kepala Yahya. Askar itu pergi ke penjara lalu memancung kepala Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Dia membawa kepala itu di atas talam dan menyerahkannya kepada gadis itu. Lalu gadis itu menyerahkan kepala Yahya kepada ibunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Apabila para pengikut Yahya mendengar perkara itu, mereka datang dan mengambil jenazah Yahya lalu mengebumikannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kemudian rasul-rasul kembali berkumpul dengan Isa dan melaporkan segala yang telah mereka lakukan serta ajarkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Orang yang datang dan pergi di situ begitu ramainya sehingga Isa dan para pengikut-Nya tidak sempat makan. Oleh itu, Isa berkata kepada para pengikut-Nya, ‘Marilah ke tempat yang sunyi supaya kita dapat bersendirian, dan berehat sebentar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mereka pun bertolak dengan perahu ke tempat yang sunyi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tetapi pada waktu mereka bertolak ramai orang melihat dan mengenal mereka. Orang dari semua kota berlari ikut jalan darat supaya sampai di tempat yang dituju itu sebelum Isa dan para pengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Apabila Isa turun dari perahu dan melihat orang ramai di situ, hati-Nya penuh belas kasih kerana mereka seperti domba tanpa gembala. Dia pun mula mengajarkan banyak perkara kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ketika hari sudah petang, para pengikut Isa datang kepada-Nya dan berkata, ‘Hari sudah hampir malam dan tempat ini terpencil. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Suruhlah semua orang ini pergi supaya mereka ke pekan atau ke kampung yang berdekatan untuk membeli makanan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tetapi Isa menjawab, ‘Kamu berilah mereka makan.’ Para pengikut-Nya bertanya, ‘Haruskah kami pergi membeli roti berharga dua ratus dinar untuk memberi mereka makan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Isa bertanya, ‘Pergilah lihat berapa banyak roti yang ada pada kamu.’ Setelah mereka memeriksanya, mereka berkata, ‘Lima buku roti dan dua ekor ikan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Isa mengarahkan mereka supaya menyuruh semua orang di situ duduk berkelompok-kelompok di atas rumput. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mereka pun duduk dalam kelompok; ada yang seratus orang sekelompok dan ada yang lima puluh orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Setelah Isa mengambil lima buku roti dan dua ekor ikan itu, Dia menengadah ke langit dan mengucap syukur. Lalu Dia memecah-mecahkan roti itu dan menyerahkannya kepada para pengikut-Nya untuk diberikan kepada orang ramai itu. Dia membahagikan juga dua ekor ikan itu kepada mereka semua. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Setiap orang makan sehingga kenyang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Selepas itu para pengikut-Nya mengumpulkan lebihan makanan roti dan ikan sebanyak dua belas bakul. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jumlah orang lelaki yang makan itu kira-kira lima ribu orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Isa segera mengarahkan para pengikut-Nya pergi dahulu dengan perahu ke Betsaida di seberang laut sementara Dia menyuruh orang ramai itu pulang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Setelah mereka pergi, Isa naik ke bukit untuk berdoa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Apabila hari sudah malam, perahu para pengikut Isa sudah sampai ke tengah laut sedangkan Isa seorang diri di darat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Isa melihat para pengikut-Nya bersusah payah mendayung perahu kerana angin bertiup dari arah bertentangan. Kira-kira menjelang subuh, Isa berjalan di atas air menghampiri mereka. Dia hendak mendahului mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tetapi ketika mereka terpandang Dia berjalan di atas air, mereka menyangka-Nya hantu lalu mereka berteriak-teriak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mereka ketakutan melihat Isa. Tetapi Dia segera berkata kepada mereka, ‘Tabahkan hatimu! Aku Isa. Jangan takut.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dia naik ke perahu mereka, lalu angin pun teduh. Para pengikut-Nya hairan tercengang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mereka masih belum mengerti apa sebenar yang berlaku dengan roti itu, kerana hati mereka masih keras. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mereka menyeberang hingga tiba di Genesaret. Di situ mereka menambat perahu itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sebaik-baik mereka turun dari perahu, orang mengenal Isa ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","lalu berlari ke serata kawasan dan membawakan orang sakit yang terbaring di atas tikar kepada-Nya di mana-mana sahaja Dia berada. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Di setiap tempat yang dikunjungi-Nya – baik di kota, di pekan atau di kampung – penduduk di situ membawa orang yang sakit ke pasar-pasar. Mereka memohon agar sekurang-kurangnya Isa membenarkan orang sakit itu menyentuh jubah-Nya. Semua yang menyentuhnya terus sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Orang Farisi dan beberapa guru Taurat yang datang dari Baitulmaqdis berkumpul di keliling Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mereka melihat beberapa pengikut Isa makan dengan tangan yang ‘tidak suci’, iaitu tangan yang tidak dibasuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Orang Farisi malah semua orang Yahudi taat mengikut adat istiadat nenek moyang mereka. Mereka tidak akan makan sebelum membasuh tangan menurut cara-cara yang ditentukan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Apabila pulang dari pasar, mereka juga tidak akan makan sebelum membersihkan diri. Banyak lagi peraturan yang diamalkan oleh mereka, seperti hal membasuh cawan, kendi, dan bekas tembaga.) ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Oleh itu, orang Farisi dan guru Taurat di situ bertanya kepada Isa, ‘Mengapakah pengikutmu tidak menurut adat istiadat nenek moyang kita? Mengapakah mereka makan dengan tangan yang “tidak suci”?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Isa menjawab, ‘Tepat sekali kata-kata Nabi Yasyaya dalam nubuatnya tentangmu, hai orang munafik; seperti yang tersurat: ‘ “Bangsa ini menghormati-Ku dengan kata-kata, tetapi hati mereka jauh daripada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sia-sialah mereka menyembah-Ku; sedangkan ajaran yang mereka ajarkan ialah peraturan manusia.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","‘Kamu mengetepikan perintah Allah untuk menurut adat istiadat manusia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Isa berkata lagi: ‘Kamu sungguh pandai menyingkirkan perintah Allah untuk menegakkan adat istiadatmu sendiri! ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa menyampaikan perintah ini, “Hormatilah ibu bapamu” dan “Orang yang mencaci ibu bapa sendiri mesti dihukum mati.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tetapi kamu memberikan ajaran berikut: Jika seseorang berkata kepada ibu bapanya, “Segala apa yang harus kugunakan untuk membantu ayah dan emak, sudah kujadikan korban” (iaitu telah dipersembahkan kepada Allah), ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","maka orang itu tidak perlu menolong ibu bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jadi, adat istiadat yang kamu sampaikan membatalkan firman Allah. Banyak lagi perkara sedemikian yang kamu lakukan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Isa memanggil orang ramai itu dan berkata kepada mereka, ‘Kamu semua, dengarlah supaya kamu faham. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Apa yang masuk dari luar ke dalam seseorang tidak dapat menajiskannya. Apa yang keluar daripada seseorang itulah yang menajiskannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jika kamu bertelinga, dengarlah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Setelah Isa meninggalkan orang ramai itu dan masuk ke rumah, para pengikut-Nya bertanya kepada-Nya tentang maksud ibarat itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Isa berkata kepada mereka, ‘Kamu ini sama dengan mereka. Tidakkah kamu faham bahawa apa yang masuk dari luar ke dalam seseorang tidak dapat menajiskannya? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kerana sesuatu itu tidak masuk ke hatinya tetapi ke dalam perutnya, kemudian keluar semula.’ (Dengan demikian Dia menyatakan semua makanan halal.) ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kata-Nya lagi: ‘Apa yang keluar daripada seseorang itu menajiskannya ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","kerana dari dalam, dari hati manusialah timbul fikiran jahat yang mendorong seseorang berfikiran durjana, berbuat cabul, mencuri, membunuh, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","berzina, tamak, berdendam, menipu, mengeluarkan kata-kata lucah, bermata jahat, dengki, mengkufuri Allah, berlagak sombong, dan bersikap bodoh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Semua perkara jahat ini timbul dari dalam hati dan itulah yang menajiskan seseorang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kemudian Isa pergi dari situ ke kawasan berdekatan kota Tirus, lalu masuk ke sebuah rumah. Dia tidak mahu orang tahu Dia ada di situ tetapi Dia tidak dapat menyembunyikan diri. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ibu kepada seorang anak perempuan yang dirasuk roh durjana telah mendengar tentang Isa lalu segera datang kepada-Nya dan sujud di hadapan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Wanita itu seorang Yunani, dia berasal dari daerah Fenisia di Siria. Dia memohon Isa menghalau roh iblis yang merasuk anaknya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Isa menjawab, ‘Anak-anak harus diberi makan dahulu. Tidak patut makanannya diambil untuk dilemparkan kepada anjing.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","‘Benar, Tuan,’ jawab wanita itu, ‘tetapi anjing di bawah meja pun makan sisa yang dijatuhkan oleh anak-anak.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Maka Isa berkata kepadanya, ‘Kerana jawapanmu itu, pulanglah. Roh iblis sudah keluar daripada tubuh anakmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Apabila ibu itu pulang ke rumah, dia mendapati anaknya sedang berbaring di katil dan tidak lagi dirasuk roh iblis. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Selepas itu Isa meninggalkan daerah Tirus, meneruskan perjalanan ke Laut Galilea melalui Sidon, ke tengah-tengah daerah Sepuluh Kota. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Di sana seorang bisu tuli dibawa kepada-Nya dengan permohonan agar Isa meletakkan tangan padanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Isa membawanya ke samping, jauh daripada orang ramai itu, lalu memasukkan jari-Nya ke dalam kedua-dua belah telinga orang itu. Kemudian Dia meludah dan menyentuh lidah orang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Selepas itu Dia menengadah ke langit lalu menarik nafas panjang dan berkata kepada orang itu, ‘Effata!’ (ertinya ‘Terbukalah!’). ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Serta-merta telinga orang itu terbuka dan lidahnya pulih, lalu dia bertutur dengan baik. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Isa melarang semua yang hadir menceritakan hal itu kepada sesiapapun. Tetapi semakin Isa melarang, semakin mereka menceritakannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mereka sungguh hairan dan berkata, ‘Dia melakukan segala-galanya dengan baik sekali. Dia membolehkan orang tuli mendengar dan orang bisu berkata-kata.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pada suatu hari, ketika orang tersangat ramai berhimpun dan kehabisan makanan, Isa memanggil para pengikut-Nya lalu berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","‘Aku kasihan kepada orang ramai ini, sudah tiga hari mereka bersama-Ku, dan sekarang mereka kehabisan makanan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kalau Kusuruh mereka pulang dengan perut kosong, mereka akan pengsan di tengah jalan kerana ada yang datang dari jauh.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Para pengikut Isa menjawab, ‘Di tempat terpencil ini, di mana hendak dicari makanan yang cukup untuk semua orang ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Isa bertanya kepada mereka, ‘Berapa banyakkah roti yang ada padamu?’ ‘Tujuh buku,’ jawab mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Isa menyuruh orang ramai itu duduk di atas tanah. Dia mengambil tujuh buku roti itu dan mengucap syukur. Setelah itu Dia memecah-mecahkan roti itu dan menyerahkannya kepada para pengikut-Nya untuk dihidangkan, dan mereka pun memberikannya kepada orang yang banyak itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mereka juga ada beberapa ekor ikan kecil. Setelah mengucap syukur atasnya, Isa menyuruh supaya ikan itu dibahagi-bahagikan juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kesemua orang pun makan sehingga kenyang. Sisa lebihan makanan yang dikumpulkan sebanyak tujuh bakul penuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bilangan mereka itu kira-kira empat ribu orang. Isa pun menyuruh mereka pulang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Selepas itu Isa terus menaiki perahu bersama para pengikut-Nya pergi ke daerah Dalmanuta. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Beberapa orang Farisi datang kepada Isa dan mula bersoal jawab dengan-Nya untuk memerangkap-Nya. Untuk menduga-Nya, mereka meminta daripada-Nya suatu tanda ajaib dari syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Isa mengeluh lalu menjawab, ‘Mengapakah orang zaman ini mencari suatu tanda ajaib? Sesungguhnya Aku berkata kepadamu, tidak akan diberikan tanda apapun kepada orang zaman ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Isa meninggalkan mereka dan kembali ke perahu lalu ke seberang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Para pengikut Isa terlupa membawa roti yang mencukupi. Di dalam perahu itu cuma ada sebuku roti. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Isa mengingatkan mereka, ‘Berhati-hatilah dengan ragi orang Farisi dan ragi Herodes.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kemudian mereka membincangkannya satu sama lain dan berkata, ‘Dia berkata begitu kerana kita tidak membawa roti.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Isa mengetahui apa yang mereka bincangkan lalu Dia bertanya, ‘Mengapa kamu memperbincangkan hal tidak membawa roti? Tidakkah kamu tahu dan faham lagi? Begitu tumpulkah fikiranmu? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kamu ada mata, tidakkah kamu melihat? Kamu ada telinga, tidakkah kamu mendengar? Tidakkah kamu ingat ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","bagaimana Aku memecah-mecahkan lima buku roti untuk lima ribu orang? Berapa bakul lebihan makanan yang kamu kumpulkan?’ ‘Dua belas,’ jawab mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","‘Dan apabila Aku memecah-mecahkan tujuh buku roti untuk empat ribu orang, berapa bakul lebihan makanan yang kamu kumpulkan?’ ‘Tujuh,’ jawab mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Lalu Isa berkata kepada mereka, ‘Kamu masih belum faham lagi?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Isa dan para pengikut-Nya tiba di Betsaida. Beberapa orang membawa seorang buta kepada Isa dan memohon agar Dia menyentuhnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Isa memegang tangan orang buta itu lalu memimpinnya ke luar dari pekan itu. Isa meludahi mata orang buta itu. Kemudian Dia meletakkan tangan-Nya pada orang itu lalu bertanya, ‘Adakah kamu melihat apa-apa?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Orang itu memandang ke hadapan lalu berkata, ‘Aku nampak orang, rupa mereka seperti pokok berjalan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sekali lagi Isa meletakkan tangan-Nya pada mata orang itu. Setelah orang itu berusaha untuk melihat, kali ini penglihatannya cukup terang dan matanya telah sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Isa pun menyuruhnya pulang sambil berkata, ‘Jangan masuk lagi ke pekan itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Setelah itu Isa dan para pengikut-Nya pergi ke pekan-pekan di sekitar Kaisarea Filipi. Di tengah jalan Isa bertanya kepada mereka, ‘Menurut orang, Aku ini siapa?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mereka menjawab, ‘Ada yang berkata, Yahya Pengimad; yang lain berkata, Ilyas; ada pula yang berkata, seorang daripada nabi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","‘Tetapi menurut kamu, Aku ini siapa?’ tanya Isa. Petrus menjawab, ‘Engkau ialah al-Masih.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Lalu Isa mengingatkan mereka supaya jangan memberitahu sesiapapun tentang diri-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kemudian Isa mula mengajar mereka bahawa Putera Insan harus banyak menanggung kesengsaraan serta ditolak oleh para pemimpin masyarakat, ketua imam dan guru Taurat. Dia akan dibunuh, tetapi tiga hari kemudian, Dia akan bangkit semula. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Isa mengatakan perkara ini dengan terus-terang. Oleh itu, Petrus menarik Isa ke tepi dan menegur Dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Isa berpaling memandang para pengikut-Nya lalu menegur Petrus, ‘Pergilah dari sini, hai Iblis! Kamu tidak berfikir secara Allah, tetapi secara manusia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Setelah itu Isa memanggil para pengikut-Nya dan orang ramai di situ lalu berkata kepada mereka, ‘Jika seseorang hendak mengikut-Ku, dia harus melupakan kepentingan dirinya, memikul salib, dan mengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sesiapa yang mempertahankan hidupnya, akan kehilangan hidupnya. Tetapi sesiapa yang mengorbankan hidup untuk-Ku dan untuk Injil, akan menyelamatkan hidupnya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Apa gunanya jika seseorang memiliki seluruh dunia tetapi kehilangan hidupnya? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dapatkah hidup itu ditukar dengan apapun? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jika seseorang malu mengakui Aku dan perkataan-Ku di kalangan angkatan yang cabul dan berdosa ini, Putera Insan juga akan malu mengakuinya ketika Dia datang dalam kemuliaan Bapa-Nya diiringi para malaikat suci.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Isa berkata lagi, ‘Sesungguhnya, ada beberapa orang di sini yang tidak akan mati sebelum melihat kerajaan Allah datang dengan kuasa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Enam hari kemudian, Isa membawa Petrus, Yakobus, dan Yahya, pergi ke sebuah gunung yang tinggi di mana mereka bersendirian. Di situ Isa berubah rupa di depan mata mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pakaian-Nya menjadi putih berkilau-kilauan laksana salji, tiada siapa di bumi ini dapat memutihkan kain sehingga seputih itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ilyas dan Musa muncul di hadapan mereka lalu berkata-kata dengan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Lalu Petrus berkata kepada Isa, ‘Tuan Guru, baik sekali kami ada di sini. Biarlah kami dirikan tiga buah khemah – satu untuk-Mu, satu untuk Musa, dan satu untuk Ilyas.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Sebenarnya Petrus tidak tahu apa yang hendak dikatakannya, kerana ketiga-tiganya ketakutan.) ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Segumpal awan datang menaungi mereka. Suatu suara terdengar dari dalam awan itu, ‘Inilah Putera-Ku yang Kukasihi. Dengarlah kata-kata-Nya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tiba-tiba, ketika mereka memandang sekeliling, mereka tidak lagi melihat sesiapa di situ bersama mereka, selain Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sewaktu berjalan turun dari gunung itu, Isa memperingatkan mereka supaya tidak memberitahu sesiapa segala yang telah mereka lihat, sehingga Putera Insan bangkit daripada kematian. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mereka mentaati pesan itu, sambil tertanya-tanya apa maksud ‘bangkit daripada kematian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mereka bertanya kepada Isa, ‘Mengapa guru-guru Taurat berkata Ilyas mesti datang dulu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Isa menjawab, ‘Benar, Ilyas akan datang dulu dan memulihkan segala-galanya. Tetapi bagaimana dengan apa yang tersurat tentang Putera Insan, bahawa Dia akan banyak menanggung penderitaan dan penghinaan? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aku berkata kepadamu, Ilyas sudahpun datang dan orang memperlakukannya sesuka hati, tepat seperti yang tersurat tentang dirinya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Apabila mereka pulang mendapatkan para pengikut yang lain, mereka melihat ramai orang di situ. Beberapa orang guru Taurat sedang bersoal jawab dengan para pengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sebaik-baik orang ramai itu melihat Isa, mereka amat kagum lalu berlari menyambut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Isa bertanya kepada para pengikut-Nya, ‘Tentang apa kamu bersoal jawab dengan mereka?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Seorang daripada orang ramai itu menjawab, ‘Tuan Guru, aku membawa anakku kepada pengikut-pengikut-Mu. Anakku dirasuk oleh roh yang membuatnya bisu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Apabila roh itu menyerangnya, dia menghempas-hempas tubuhnya ke tanah, mulutnya berbuih, giginya mengertak dan badannya menjadi kaku. Aku memohon pengikut-pengikut-Mu menghalau roh itu tetapi mereka tidak dapat melakukannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Isa berkata kepada mereka, ‘Hai angkatan yang tidak percaya! Berapa lamakah aku mesti tinggal bersamamu? Berapa lamakah aku harus bersabar denganmu? Bawa anak itu ke mari.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mereka pun membawa anak itu kepada Isa. Sebaik-baik roh itu melihat Isa, ia pun membuat anak itu sawan, lalu jatuh berguling-guling ke tanah, mulutnya berbuih. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Isa bertanya kepada bapa anak itu, ‘Sejak bila dia begini?’ Bapa anak itu menjawab, ‘Sejak dia kecil lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sudah berkali-kali roh itu cuba membunuhnya dengan membuangnya ke dalam api atau air. Kasihanlah kami dan tolonglah kami, kalau Engkau dapat menolong.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Isa berkata kepadanya, ‘Apa katamu? Kalau Engkau dapat? Segala sesuatu mungkin bagi orang yang percaya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bapa itu segera berseru, ‘Aku percaya; tolonglah agar aku lebih percaya lagi!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ketika Isa melihat orang ramai datang berkerumun, Dia memerintah roh durjana itu, ‘Hai roh bisu tuli, Aku perintahkan kamu keluar daripada anak ini dan jangan memasukinya lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Roh itu menjerit dan membuat tubuh anak itu terkejang-kejang, lalu keluar daripada anak itu. Anak itu kelihatan seperti mayat lalu semua orang berkata, ‘Dia sudah mati.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tetapi Isa memegang tangannya dan menolongnya bangun. Anak itu pun berdiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Selepas itu Isa masuk ke rumah. Ketika tiada lagi orang lain di situ, para pengikut-Nya bertanya kepada-Nya, ‘Mengapa kami tidak dapat menghalau roh itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Isa menjawab, ‘Jenis ini tidak dapat dihalau dengan cara apapun, kecuali dengan doa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Setelah itu Isa dan para pengikut-Nya beredar dari situ dan meneruskan perjalanan melalui Galilea. Dia tidak mahu orang tahu Dia di mana ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kerana Dia sedang mengajar para pengikut-Nya. Dia berkata kepada mereka, ‘Putera Insan akan diserahkan ke dalam tangan manusia dan akan dibunuh, tetapi selepas tiga hari Dia akan bangkit semula.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mereka tidak faham erti kata-kata itu tetapi takut hendak bertanya kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mereka tiba di Kapernaum. Setelah tiba di rumah, Isa bertanya kepada para pengikut-Nya, ‘Apa yang kamu persoalkan di jalan tadi?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mereka tidak menjawab, kerana dalam perjalanan mereka telah mempersoalkan siapa yang terbesar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Isa duduk lalu memanggil pengikut-Nya yang dua belas itu. Dia berkata kepada mereka, ‘Kalau sesiapa ingin menjadi yang pertama, dia mestilah menjadi yang terakhir dan hamba kepada semua orang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Selepas itu Dia memanggil seorang kanak-kanak dan menyuruhnya berdiri di hadapan mereka semua. Dia mendakap kanak-kanak itu sambil berkata kepada mereka, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","‘Sesiapa yang menerima kanak-kanak seperti ini kerana-Ku, menerima-Ku. Sesiapa yang menerima-Ku, menerima Allah yang mengutus-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yahya berkata kepada Isa, ‘Tuan Guru, kami melihat seorang lelaki menghalau roh-roh iblis dengan nama-Mu, lalu kami larang dia, kerana dia bukan dalam kumpulan kita.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tetapi Isa berkata, ‘Jangan larang dia, kerana seseorang yang melakukan mukjizat dengan nama-Ku tidak mungkin mencela-Ku sejurus selepas itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Orang yang tidak menentang kita, memihak kepada kita. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sesiapa yang memberimu secawan air dalam nama-Ku, kerana kamu pengikut al-Masih, sesungguhnya, Aku berkata kepadamu, dia pasti akan mendapat ganjarannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","‘Tetapi sesiapa yang menyebabkan seorang daripada kanak-kanak yang percaya kepada-Ku ini berdosa, maka lebih baiklah baginya jika batu kisar diikatkan ke lehernya dan dia dicampakkan ke dalam laut. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jika tanganmu menyebabkan kamu berdosa, potonglah tangan itu! Lebih baik kamu memasuki hidup dalam keadaan kudung sebelah tangan, daripada mempunyai dua tangan tetapi terhumban ke neraka, ke dalam api yang tidak terpadam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Di sana cacingnya tidak akan mati dan apinya tidak akan padam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jika kakimu menyebabkan kamu berdosa, potonglah kaki itu. Lebih baik kamu memasuki hidup dalam keadaan pincang, daripada memiliki dua kaki tetapi terhumban ke neraka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Di sana cacingnya tidak akan mati dan apinya tidak akan padam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","‘Jika matamu menyebabkan kamu berdosa, cungkillah mata itu keluar. Lebih baik kamu memasuki kerajaan Allah dengan sebelah mata sahaja, daripada memiliki dua mata tetapi terhumban ke neraka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Di sana ‘ “cacingnya tidak akan mati, dan apinya tidak akan padam.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‘Setiap orang akan disaluti api. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","‘Garam itu baik, tetapi jika hilang rasanya, bagaimana kamu dapat mengembalikan rasanya? Adakanlah garam pengukuh dalam dirimu, dan hiduplah rukun damai sesamamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Setelah itu Isa beredar dari situ lalu pergi ke daerah Yudea dan daerah di seberang Sungai Yordan. Ramai sekali orang yang datang kepada-Nya maka, seperti biasa, Dia pun mengajar mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Orang Farisi datang kepada-Nya untuk menduga-Nya. Mereka bertanya, ‘Menurut hukum, bolehkah seseorang menceraikan isterinya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dia menjawab, ‘Apa yang diperintahkan oleh Musa kepadamu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mereka berkata, ‘Musa membenarkan seseorang lelaki menulis surat cerai dan menyingkirkan isterinya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Isa berkata, ‘Disebabkan hati batu kamu, Musa menuliskan peraturan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tetapi sejak alam dicipta, Allah “telah menjadikan lelaki dan perempuan.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Oleh itu seseorang lelaki harus meninggalkan ibu bapanya dan bersatu dengan isterinya, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","dan mereka berdua akan menjadi satu,” bukan lagi dua, tetapi satu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Maka, apa yang telah disatukan oleh Allah, janganlah manusia memisahkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Di dalam rumah, para pengikut-Nya bertanya lagi kepada-Nya tentang hal ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Dia menjawab, ‘Sesiapa yang menceraikan isterinya dan berkahwin dengan perempuan lain, melakukan zina. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Begitu juga, jika seseorang wanita menceraikan suaminya dan berkahwin dengan lelaki lain, dia melakukan zina.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Selepas itu, orang membawa kanak-kanak kecil kepada-Nya supaya Dia menyentuh mereka, tetapi para pengikut-Nya memarahi mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tetapi apabila Isa melihat hal itu, Dia sungguh tidak menyenanginya, lalu berkata, ‘Biarkan kanak-kanak kecil itu datang kepada-Ku, jangan larang mereka, kerana daripada yang seperti merekalah terdirinya kerajaan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sesungguhnya, Aku berkata kepadamu, sesiapa yang tidak menerima kerajaan Allah seperti seorang anak kecil, pasti tidak akan memasukinya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Isa mendukung dan mendakap kanak-kanak kecil itu, meletakkan tangan-Nya pada mereka, dan memberkati mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ketika Dia sedang melangkah ke jalan, seorang datang berlari-lari, berlutut kepada-Nya dan bertanya, ‘Wahai Guru yang baik, apakah yang harus kulakukan untuk mewarisi hidup kekal?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Isa berkata kepadanya, ‘Mengapa kamu memanggil-Ku baik? Tiada siapa yang baik kecuali satu, iaitu Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kamu tahu perintah-perintah Allah: “Jangan berzina, jangan membunuh, jangan mencuri, jangan memberi kesaksian palsu, jangan menipu, hormati ibu bapamu.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Orang itu menjawab, ‘Tuan Guru, semua ini telah aku taati dari usia muda lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Isa memandangnya dengan penuh kasih lalu berkata, ‘Ada satu kekuranganmu. Pergilah, jual segala yang ada padamu, berikan hasil penjualannya kepada orang miskin, maka kamu akan mendapat harta di syurga. Sesudah itu datanglah dan ikut Aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tetapi orang itu sedih mendengar kata-kata ini lalu pergi dengan dukacita, kerana dia mempunyai banyak harta. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kemudian Isa memandang sekeliling dan berkata kepada para pengikut-Nya, ‘Betapa susahnya bagi orang kaya untuk masuk ke dalam kerajaan Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Para pengikut-Nya kehairanan mendengar kata-kata-Nya. Tetapi Isa berkata lagi, ‘Anak-anakku, betapa susahnya untuk masuk ke dalam kerajaan Allah! ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lebih mudah bagi seekor unta memasuki lubang jarum daripada seorang kaya memasuki kerajaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Para pengikut-Nya merasa sungguh hairan, lalu berkata sama sendiri, ‘Kalau begitu, siapa yang dapat diselamatkan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tetapi Isa memandang mereka lalu berkata, ‘Bagi manusia hal itu mustahil, tetapi tidak bagi Allah, kerana bagi Allah segala-galanya dapat dilakukan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kemudian Petrus berkata kepada-Nya, ‘Lihatlah, kami telah meninggalkan segala-galanya dan mengikut-Mu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Isa menjawab, ‘Sesungguhnya, Aku berkata kepadamu, setiap orang yang telah meninggalkan rumah, adik-beradik, ibu bapa, anak isteri, atau tanah untuk-Ku dan untuk Injil ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","pasti akan menerima seratus kali ganda dalam dunia ini (rumah, adik beradik, ibu, anak-anak dan tanah – serta penganiayaan) dan pada kemudian hari, hidup kekal. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tetapi ramai yang pertama akan menjadi terakhir, dan yang terakhir akan menjadi yang pertama.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ketika mereka di perjalanan, menuju ke Baitulmaqdis, dan Isa mendahului mereka, maka mereka sungguh takjub. Sambil mengikut-Nya, mereka berasa takut. Kemudian Dia membawa pengikut-Nya yang dua belas itu ke samping lalu memberitahu mereka apa yang akan terjadi kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kata-Nya, ‘Kita sekarang pergi ke Baitulmaqdis. Putera Insan akan dikhianati dan diserahkan ke tangan ketua-ketua imam dan guru-guru Taurat. Mereka akan menjatuhkan hukuman mati kepada-Nya dan menyerahkan-Nya kepada orang bukan bani Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mereka akan mengejek-Nya, menyebat-Nya, meludahi-Nya, dan membunuh-Nya. Pada hari ketiga Dia akan bangkit semula.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kemudian Yakobus dan Yahya, anak-anak Zebedeus, datang kepada-Nya lalu berkata, ‘Tuan Guru, kami mahu Engkau membuat apa-apa yang kami minta untuk diri kami.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Isa bertanya kepada mereka, ‘Apa yang kamu mahu Aku buat untukmu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mereka berkata kepada-Nya, ‘Kurniailah kami duduk di kiri dan kanan-Mu dalam kemuliaan-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tetapi Isa berkata kepada mereka, ‘Kamu tidak tahu apa yang kamu minta. Sanggupkah kamu minum daripada cawan yang Kuminum, dan diimadkan dengan pengimadan yang Kuterima?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mereka menjawab, ‘Sanggup.’ Lalu Isa berkata kepada mereka, ‘Memang kamu akan minum daripada cawan yang Kuminum dan diimadkan dengan pengimadan yang Kuterima. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tetapi untuk duduk di kiri dan kanan-Ku bukanlah Aku memberikannya, tetapi bagi mereka yang tempat itu disediakan untuknya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Apabila pengikut yang sepuluh orang lagi itu mendengar hal itu, mereka marah akan Yakobus dan Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tetapi Isa memanggil mereka kepada-Nya lalu berkata, ‘Kamu tahu bahawa di kalangan orang bukan bani Israel, orang yang dianggap pemerintah memerintah rakyat dengan kuku besi, dan orang besar melaksanakan kekuasaan ke atas mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ini tidak harus berlaku di kalanganmu. Sesiapa yang ingin menjadi orang besar di antaramu hendaklah melayani yang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sesiapa yang ingin menduduki tempat pertama hendaklah menjadi hamba kepada semua, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","kerana Putera Insan juga datang bukan untuk dilayani tetapi untuk melayani, dan untuk menyerahkan nyawa-Nya sebagai tebusan bagi ramai orang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Setelah itu mereka tiba di Yerikho. Kemudian, ketika Dia keluar dari situ dengan para pengikut-Nya dan orang ramai itu, seorang buta bernama Bartimeus (anak Timeus), sedang duduk mengemis di tepi jalan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ketika dia mendengar bahawa yang lalu itu Isa orang Nasaret, dia berteriak, ‘Isa, Anak Daud, kasihanilah aku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ramai orang menyuruhnya diam, tetapi dia semakin berteriak, ‘Anak Daud, kasihanilah aku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Oleh itu Isa berhenti dan memberi perintah supaya dia dipanggil. Mereka pun memanggil orang buta itu sambil berkata, ‘Bergembiralah! Dan bangkitlah! Dia memanggilmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Orang buta itu mencampakkan jubahnya ke tepi lalu bangkit dan pergi kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Isa berkata kepadanya, ‘Apa yang kamu mahu Kubuat untukmu?’ Orang itu menjawab, ‘Tuan Guru, aku ingin melihat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Isa menjawab, ‘Pergilah, imanmu telah menyembuhkanmu.’ Serta-merta orang itu dapat melihat, lalu mengikut Isa dalam perjalanan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Apabila mereka sudah berhampiran Baitulmaqdis, di Baitfagi dan Baitani, di Bukit Zaitun, Isa mengutus dua orang pengikut-Nya, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kata-Nya, ‘Pergilah ke kampung yang setentang denganmu. Sebaik-baik kamu masuk, kamu akan mendapati seekor anak keldai yang belum pernah ditunggang, tertambat di situ. Lepaskannya dan bawa ke mari. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jika sesiapa bertanya kepadamu, “Mengapa kau berbuat demikian?” katakan, “Junjungan memerlukannya, dan Dia akan segera memulangkannya.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mereka pun pergi dan mendapati anak keldai itu tertambat di pintu di tepi jalan, lalu mereka melepaskannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Beberapa orang yang berdiri di situ bertanya kepada mereka, ‘Apa yang kamu buat, melepaskan anak keldai itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mereka menjawab seperti yang diperintahkan oleh Isa, lalu mereka dibenarkan pergi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mereka membawa anak keldai itu kepada Isa dan meletakkan jubah mereka di atas belakangnya. Isa pun duduk di atas belakang anak keldai itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ramai orang membentangkan jubah mereka di atas jalan. Yang lain memotong dahan-dahan rimbun daripada pokok-pokok di situ dan meletakkannya sepanjang jalan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Setelah itu mereka yang berjalan di hadapan dan yang mengikut dari belakang berseru, ‘Hosana!’ ‘Diberkatilah Dia yang datang dengan nama Tuhan!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","‘Diberkatilah kerajaan bapa kita Daud! Yang datang dengan nama Allah!’ ‘Hosana di tempat yang maha tinggi!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Isa masuk ke Baitulmaqdis dan terus masuk ke dalam rumah ibadat. Setelah Dia melihat semuanya, kerana hari sudah lewat petang, Dia pun pergi ke Baitani dengan pengikut-Nya yang dua belas itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Esoknya, setelah mereka keluar dari Baitani, Isa berasa lapar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dari jauh Dia melihat sebatang pokok ara yang berdaun. Dia mendekatinya untuk melihat kiranya pokok itu berbuah. Tetapi Dia mendapati daun sahaja di pokok itu, kerana pada masa itu bukan musim buah ara. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Oleh itu Isa berkata kepada pokok itu, ‘Tiada siapa akan makan buahmu lagi selama-lamanya.’ Para pengikut-Nya mendengar kata-kata itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Apabila sampai di Baitulmaqdis, Isa masuk ke rumah ibadat. Dia menghalau keluar orang yang berjual beli di dalam rumah ibadat, dan menterbalikkan meja para pengurup wang serta tempat duduk penjual burung merpati. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Dia tidak membenarkan siapapun mengangkat barangan melalui rumah ibadat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kemudian Dia mengajar mereka, kata-Nya, ‘Tidakkah tersurat: ‘ “Rumah-Ku akan dipanggil rumah doa bagi semua bangsa.”? ‘Tetapi kamu telah menjadikannya “sarang pencuri.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Guru-guru Taurat dan ketua-ketua imam mendengarnya lalu mencari jalan hendak membinasakan Isa, kerana mereka takut kepada-Nya, memandangkan semua orang mengagumi ajaran-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Setelah lewat petang, Isa keluar dari kota itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pada pagi esoknya, ketika mereka lalu di situ, mereka melihat pokok ara itu telah layu kering daripada akarnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus teringat lalu berseru, ‘Tuan Guru, lihat! Pokok ara yang Engkau sumpah itu telah mati.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Isa berkata kepada para pengikut-Nya, ‘Berimanlah kepada Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sesungguhnya, Aku berkata kepadamu, jika sesiapa berkata kepada gunung, “Beralihlah dan terhumbanlah ke laut,” tanpa ragu dalam hatinya dan dengan sepenuh kepercayaan bahawa apa yang dikatakannya akan berlaku, maka akan terjadilah seperti kata-katanya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Oleh itu Aku berkata kepadamu, apa sahaja yang kamu minta ketika berdoa, percayalah kamu akan menerimanya, maka kamu akan mendapatnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Setiap kali kamu berdoa, jika ada sesiapa yang bersalah terhadapmu, ampunilah dia, supaya Bapamu di syurga juga akan mengampunkan kesalahanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tetapi jika kamu tidak mengampuni, Bapamu di syurga juga tidak akan mengampunkan kesalahanmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Selepas itu mereka masuk semula ke Baitulmaqdis. Sedang Dia berjalan di dalam rumah ibadat, ketua-ketua imam, guru-guru Taurat dan tua-tua datang kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mereka berkata kepada-Nya, ‘Dengan kekuasaan apakah Kamu melakukan perkara-perkara ini? Siapa yang memberi-Mu kekuasaan untuk melakukannya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tetapi Isa menjawab, ‘Aku juga akan bertanya satu soalan kepadamu. Jawablah soalan-Ku, maka Aku akan memberitahumu dengan kekuasaan apa Aku melakukan perkara-perkara ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Pengimadan Yahya – adakah daripada syurga atau daripada manusia? Jawablah soalan-Ku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mereka berbincang sesama sendiri, ‘Kalau kita berkata, “Daripada syurga”, nanti kata-Nya, “Kalau begitu, mengapa kamu tidak percaya kepadanya?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tetapi, kalau kita berkata, “Daripada manusia”...’ (Mereka takut akan orang ramai itu yang semuanya menganggap Yahya seorang nabi.) ");
INSERT INTO zlmKSZI_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Oleh itu mereka menjawab, ‘Kami tidak tahu.’ Lalu Isa berkata, ‘Aku pun tidak akan memberitahumu dengan kekuasaan apa Aku melakukan perkara-perkara ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Setelah itu Dia mula berkata-kata kepada mereka melalui ibarat: ‘Seorang peladang menanam anggur, memasang pagar sekeliling ladangnya, menggali lubang untuk tempat memeras anggur, dan membina menara tempat berkawal. Kemudian dia menyewakan ladang anggurnya kepada beberapa orang lalu pergi ke sebuah negeri yang jauh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Apabila tiba musim mengumpulkan hasil tanaman anggur, tuan punya ladang itu menghantar seorang hambanya untuk meminta bahagiannya daripada hasil itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Para penyewa ladang menangkap dan memukul hamba itu lalu menyuruhnya pergi dengan tangan kosong. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tuan punya ladang menghantar seorang lagi hambanya. Mereka memukulnya, menyebabkannya luka di kepala dan menyuruhnya pergi setelah diperlakukan sebegitu kejinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Selepas itu tuan punya ladang menghantar seorang lagi hambanya, dan mereka membunuh hamba itu. Ramai lagi dihantar, ada yang dibunuh dan ada yang dipukul. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","‘Oleh yang demikian, kerana dia masih ada seorang putera yang amat dikasihinya, dia menghantarnya sebagai utusan terakhir, sambil berkata dalam hatinya, “Mereka akan menghormati puteraku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","‘Tetapi para penyewa ladang berkata sesama sendiri, “Ini warisnya. Mari kita bunuh dia, supaya harta warisannya menjadi milik kita.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mereka pun menangkap dan membunuhnya lalu mencampakkannya ke luar ladang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","‘Jadi, apa yang akan dilakukan oleh tuan punya ladang anggur itu? Dia akan datang dan membinasakan para penyewa itu, lalu menyerahkan ladang anggur itu kepada orang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Belum pernahkah kamu baca di dalam Kitab Suci: ‘ “Batu yang dibuang oleh pembina telah menjadi batu penjuru; ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Inilah perbuatan Allah, sungguh hebat di mata kami.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mereka ingin menangkap Isa tetapi takut akan orang ramai. Mereka tahu ibarat itu menyindir mereka. Mereka meninggalkan-Nya dan pergi dari situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kemudian mereka menghantar kepada-Nya beberapa orang Farisi dan golongan Herodes, untuk memerangkap-Nya melalui kata-kata-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Orang yang dihantar itu berkata kepada-Nya, ‘Tuan Guru, kami tahu bahawa Engkau jujur, tidak peduli akan pendapat orang. Engkau tidak pilih kasih, hanya mengajar jalan Allah dengan mengatakan apa yang benar. Wajarkah kita membayar cukai kepada Kaisar Rom, atau tidak? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Patutkah kami bayar, ataupun tidak?’ Tetapi Isa tahu bahawa mereka itu munafik lalu berkata, ‘Mengapa kamu menduga-Ku? Bawakan sekeping wang perak untuk Kulihat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mereka pun membawakannya kepada Isa. Dia berkata kepada mereka, ‘Gambar dan nama siapakah ini?’ Mereka berkata kepada-Nya, ‘Kaisar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Isa memberikan jawapan, ‘Berikan milik Kaisar kepada Kaisar, dan milik Allah kepada Allah.’ Mereka kagum mendengar kata-kata-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Selepas itu beberapa orang Saduki, suatu golongan yang tidak mempercayai kebangkitan manusia daripada kematian, datang kepada Isa lalu bertanya, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","‘Tuan Guru, Musa menulis untuk kami bahawa jika seseorang lelaki meninggal dunia tanpa anak, saudara lelakinya patutlah mengahwini balunya dan memanjangkan zuriatnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kesemuanya ada tujuh lelaki adik-beradik. Yang sulung beristeri, kemudian meninggal dunia tanpa anak. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yang kedua berkahwin dengan balu saudaranya, kemudian meninggal dunia tanpa anak. Begitu juga yang ketiga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ketujuh-tujuhnya mengahwini wanita itu dan meninggal dunia tanpa mendapat anak. Akhirnya wanita itu juga meninggal dunia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jadi, pada masa manusia bangkit daripada kematian, isteri siapakah wanita itu? Ketujuh-tujuhnya pernah mengahwininya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Isa menjawab, ‘Tidakkah kamu tersilap, kerana kamu tidak memahami Kitab Suci mahupun kuasa Allah? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Apabila manusia bangkit daripada kematian, mereka tidak berkahwin atau dikahwinkan; mereka seperti malaikat di syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tetapi tentang kebangkitan orang mati, tidakkah kamu baca dalam kitab Musa, bahagian tentang belukar yang bernyala, betapa Allah berfirman kepadanya, “Akulah Allah Tuhan Ibrahim, Ishak dan Yakub.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dia bukanlah Allah Tuhan orang mati. Dia Allah Tuhan orang hidup. Oleh itu kamu tersilap sama sekali!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Seorang guru Taurat datang mendengar mereka bersoal jawab. Dia sedar bahawa Isa telah menjawab dengan baik. Dia pun bertanya kepada-Nya, ‘Perintah manakah yang terutama?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Isa menjawab, ‘Yang terutama antara semua perintah ialah: “Dengarlah, wahai umat Israel, Allah Tuhan kita, Tuhan kita adalah Esa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kamu hendaklah mengasihi Allah Tuhanmu dengan sepenuh hatimu, dengan sepenuh jiwamu, dengan sepenuh fikiranmu, dan dengan sepenuh kekuatanmu.” Inilah perintah yang terutama. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Perintah yang kedua ialah: “Kamu hendaklah mengasihi sesama manusia seperti kamu mengasihi dirimu sendiri.” Tiada perintah lain yang lebih utama daripada dua perintah ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Guru Taurat itu berkata kepada Isa, ‘Sungguh baik jawapan Tuan Guru. Kata-kata Engkau itu benar, kerana Allah itu Esa, tiada yang lain daripada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mengasihi-Nya dengan sepenuh hati, dengan sepenuh fikiran, dengan sepenuh jiwa, dan dengan sepenuh kekuatan, serta mengasihi sesama manusia seperti diri sendiri, adalah lebih utama daripada segala persembahan dan korban.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Isa sedar bahawa jawapan itu bijaksana, lalu berkata kepada guru Taurat itu, ‘Kamu tidak jauh daripada kerajaan Allah.’ Selepas itu tiada siapa yang berani menyoal-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kemudian, ketika mengajar di rumah ibadat, Isa berkata, ‘Bagaimanakah guru-guru Taurat dapat mengatakan bahawa al-Masih itu anak Daud? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kerana Daud sendiri berkata dengan panduan Roh Suci: ‘ “Tuhan berfirman kepada Junjunganku: ‘Duduklah di kanan-Ku sehingga Kujadikan segala musuh-Mu alas kaki-Mu.’” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","‘Jadi, Daud sendiri memanggil-Nya “Junjungan.” Bagaimana Dia boleh dianggap anak Daud?’ Orang ramai mendengar kata-kata Isa dengan sukacita. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Dia mengajar mereka lagi, ‘Awas guru-guru Taurat, yang suka ke sana sini berjubah labuh, gembira diberi salam hormat di pasar-pasar, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","tempat duduk terbaik di saumaah dan di majlis jamuan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mereka merampas rumah balu, kemudian pura-pura berdoa berjela-jela. Mereka ini akan menerima hukuman yang amat berat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Isa duduk berhadapan dengan peti wang persembahan dan melihat betapa orang memasukkan wang ke dalamnya. Ramai orang kaya memasukkan sumbangan yang besar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kemudian seorang balu yang miskin memasukkan dua keping wang tembaga, yang sangat kecil nilainya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Isa memanggil para pengikut-Nya lalu berkata kepada mereka, ‘Sesungguhnya, Aku berkata kepadamu, balu yang miskin itu telah memberi lebih daripada semua orang yang telah memasukkan wang ke dalam peti persembahan; ");
INSERT INTO zlmKSZI_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","kerana mereka memberi daripada kekayaan mereka yang melimpah, tetapi dia daripada kemiskinannya dan telah memasukkan semua yang ada padanya, seluruh rezekinya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ketika Isa sedang melangkah keluar dari rumah ibadat, seorang pengikut-Nya berkata, ‘Tuan Guru, lihatlah batu dan bangunan yang luar biasa di sini!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Isa menjawab, ‘Adakah kamu melihat bangunan yang hebat-hebat ini? Tiada sekeping pun batunya akan tinggal tersusun, semuanya akan diruntuhkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ketika Dia duduk di atas Bukit Zaitun setentang dengan rumah ibadat, pengikut-Nya Petrus, Yakobus, Yahya dan Andreas bertanya kepada-Nya secara peribadi, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","‘Katakanlah kepada kami, bilakah hal-hal itu akan berlaku? Apakah tanda-tandanya semua ini akan terjadi seperti yang telah dikatakan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Isa menjawab, ‘Awas, jangan tertipu oleh sesiapapun. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ramai yang akan datang dengan nama-Ku dan berkata, “Akulah Dia”, maka ramai yang akan terpedaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Apabila kamu mendengar berita atau khabar angin tentang peperangan, janganlah bimbang; kerana hal-hal begitu harus terjadi, tetapi belum sampai waktunya dunia berakhir. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bangsa akan bangkit melawan bangsa, kerajaan melawan kerajaan. Gempa bumi akan berlaku di sana sini, dan juga kebuluran. Ini permulaan kesengsaraan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‘Berhati-hatilah tentang dirimu, kerana mereka akan mengheretmu ke hadapan majlis dan memukulmu di dalam rumah ibadat. Kamu akan dibawa kepada para pemerintah dan raja kerana-Ku, untuk memberikan kesaksian kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Injil mesti disebarkan terlebih dahulu kepada semua bangsa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Apabila mereka menangkapmu dan menyerahkanmu kepada pihak berkuasa, janganlah runsing atau fikirkan apa yang akan kamu katakan. Tetapi apa yang diilhamkan kepadamu pada waktunya tuturkanlah, kerana yang bertutur itu Roh Suci, bukannya kamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","‘Saudara akan mengkhianati saudara untuk dibunuh, demikian juga bapa akan anaknya. Anak-anak akan bangkit menentang ibu bapa dan menyebabkan mereka dihukum mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kamu akan dibenci oleh semua orang kerana nama-Ku. Tetapi sesiapa yang bertahan hingga ke akhir akan diselamatkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‘Apabila kamu melihat “kekejian yang membawa kebinasaan” yang disebutkan oleh Nabi Daniel berdiri di tempat terlarang baginya – hendaklah para pembaca memperhatikan ertinya – semua yang ada di Yudea larilah ke pergunungan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yang di atas bumbung ketika itu janganlah turun dan masuk ke rumah untuk mengambil apa-apa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yang di ladang usahlah pulang mengambil pakaian. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Malanglah ibu yang mengandung dan yang menyusui anak pada masa itu! ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Berdoalah semoga hal-hal itu tidak terjadi pada musim dingin. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Pada masa itu akan berlaku pancaroba yang belum pernah wujud sejak dunia dicipta Allah hingga waktu itu dan tidak akan muncul lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kalaulah Tuhan tidak menyingkatkan masa itu, tiada satu makhluk pun yang dapat diselamatkan. Namun, demi kesejahteraan mereka yang telah dipilih-Nya, masa itu disingkatkan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ketika itu jika sesiapa berkata kepadamu, “Lihat, al-Masih di sini!” atau “Lihat, Dia di sana!” janganlah kamu percaya; ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","kerana beberapa almasih palsu dan nabi palsu akan bangkit dan menunjukkan pelbagai tanda serta keajaiban untuk memperdaya orang, kalau boleh termasuk mereka yang telah dipilih Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Berhati-hatilah. Lihat, Aku telah memberitahu semuanya kepadamu terlebih dahulu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‘Pada masa itu, selepas pancaroba, ‘ “Matahari akan dikelamkan, dan bulan tidak akan bersinar; ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","bintang-bintang di langit akan gugur, dan kuasa-kuasa angkasa akan digoncang.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","‘Kemudian mereka akan melihat Putera Insan datang dalam awan penuh dengan kekuasaan dan kemuliaan yang besar. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Setelah itu Dia akan menghantar para malaikat-Nya dan menghimpunkan orang pilihan-Nya dari empat mata angin, dari hujung bumi yang paling jauh ke hujung syurga yang paling jauh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‘Sekarang, kajilah ibarat daripada pokok ara: Apabila dahan-dahannya sudah lembut dan mengeluarkan daun, itulah tanda musim panas sudah dekat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Begitulah juga kamu. Apabila kamu melihat kejadian-kejadian ini, ketahuilah bahawa waktunya sudah dekat – sudah di ambang pintu! ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sesungguhnya, Aku berkata kepadamu, angkatan ini tidak akan luput sebelum semua kejadian itu berlaku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Langit dan bumi akan lenyap, tetapi kata-kata-Ku tidak akan lenyap. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","‘Tetapi tentang hari dan waktunya tiada siapa yang tahu. Malaikat di syurga tidak tahu, malah Putera juga tidak tahu, hanya Bapa yang mengetahui. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Berhati-hatilah! Berjaga dan berdoa! Kerana kamu tidak tahu bila saatnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Umpama seorang yang pergi ke negeri yang jauh: Dia meninggalkan rumahnya dan memberikan kekuasaan kepada hamba-hambanya, setiap seorang dengan tugasnya serta memerintahkan penjaga pintu supaya berjaga-jaga. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","‘Oleh itu berjagalah, kerana kamu tidak tahu bila tuan rumah akan pulang – pada waktu petang, atau tengah malam, ketika ayam berkokok, atau pada waktu pagi – ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","takut kalau-kalau dia datang tiba-tiba dan mendapatimu sedang tidur. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Apa yang Kukatakan kepadamu, Kukatakan kepada semua: “Berjagalah!” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dua hari lagi akan tibalah perayaan Paska dan Jamuan Roti Tidak Beragi, ketua-ketua imam dan guru-guru Taurat mencari jalan untuk memerangkap Isa secara tipu daya dan menjatuhkan hukuman mati kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tetapi mereka berkata, ‘Janganlah pada waktu perayaan, takut orang akan merusuh.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ketika itu Isa berada di Baitani di rumah Simon yang menghidap penyakit kusta. Sedang Isa duduk di meja, seorang wanita datang membawa bejana pualam berisi minyak narwastu murni yang amat mahal. Dia memecahkan bejana itu lalu menuangkan minyak itu ke atas kepala Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Beberapa orang berkata-kata sesama sendiri dengan marah, ‘Mengapa dibazirkan minyak wangi ini? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Minyak itu dapat dijual dengan harga lebih tiga ratus keping wang perak dan wangnya diberikan kepada orang miskin.’ Mereka mengecam wanita itu dengan kata-kata yang tajam. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tetapi Isa berkata, ‘Biarkan dia. Mengapa kamu memarahinya? Dia telah melakukan sesuatu yang baik untuk-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Orang miskin akan sentiasa ada di kalanganmu, dan bila-bila sahaja kamu mahu, kamu dapat berbuat kebajikan kepada mereka. Tetapi Aku tidak akan sentiasa ada bersamamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dia telah melakukan apa yang terdaya olehnya. Dia telah datang terlebih dahulu untuk menyediakan tubuhku bagi pengebumian. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sesungguhnya, Aku berkata kepadamu, di mana-mana sahaja Injil ini disebarkan di serata dunia, apa yang telah dilakukan oleh wanita ini akan diceritakan juga sebagai kenangan kepadanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Selepas itu Yudas Iskariot, seorang daripada pengikut Isa yang dua belas itu, pergi kepada ketua-ketua imam untuk mengkhianati-Nya dan menyerahkan-Nya kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ketika mendengar kata-katanya mereka pun sukacita dan berjanji akan memberinya wang. Sejak itu Yudas mencari jalan yang terbaik untuk mengkhianati Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pada hari pertama Perayaan Roti Tidak Beragi, ketika mereka menyembelih anak domba Paska, para pengikut Isa berkata kepada-Nya, ‘Di manakah Engkau mahu kami pergi menyediakan jamuan Paska untuk-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dia menghantar dua orang pengikut-Nya dan berkata kepada mereka, ‘Pergilah ke dalam kota. Seorang lelaki yang membawa sekendi air akan menemui kamu. Ikutlah dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Di mana dia masuk, katakan kepada tuan rumah, “Tuan Guru berkata: Di manakah ruang tamu untuk Aku makan jamuan Paska dengan para pengikut-Ku?” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dia akan menunjukkan kepadamu sebuah ruang besar di tingkat atas, lengkap dengan perabot dan telah siap disediakan. Di situlah kamu membuat persiapan untuk kita.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kedua-dua pengikut-Nya itu keluar, pergi ke dalam kota, dan mendapati segala-galanya tepat seperti yang telah dikatakan-Nya kepada mereka. Mereka pun menyediakan jamuan Paska. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pada waktu lewat petang, Dia datang bersama para pengikut-Nya yang dua belas itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sedang mereka duduk menikmati jamuan, Isa berkata, ‘Sesungguhnya, Aku berkata kepadamu, seorang daripada kamu yang makan bersama-Ku akan mengkhianati-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mereka mula berdukacita. Seorang demi seorang berkata kepada-Nya, ‘Akukah orang itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Isa menjawab, ‘Dia seorang daripada yang dua belas yang mencecah roti bersama ke dalam bekas. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Putera Insan memang mesti pergi, seperti yang tersurat tentang-Nya. Tetapi malanglah orang yang mengkhianati Putera Insan! Lebih baiklah baginya jika dia tidak dilahirkan ke dunia ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sedang mereka makan, Isa mengambil roti lalu memberkatinya dan kemudian membahagikannya kepada mereka dan berkata, ‘Ambil, makanlah, ini tubuh-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kemudian dia mengambil cawan air anggur, dan selepas mengucap syukur, Dia memberikannya kepada mereka, lalu mereka semua minum darinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Dia berkata kepada mereka, ‘Ini darah-Ku bagi perjanjian baru, ditumpahkan untuk beberapa ramai manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sesungguhnya, Aku berkata kepadamu, Aku tidak akan minum air anggur lagi hingga Aku minum yang baru dalam kerajaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Setelah menyanyikan sebuah lagu suci, mereka keluar ke Bukit Zaitun. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Isa berkata kepada mereka, ‘Malam ini, iman kamu semua akan goyah kerana-Ku, seperti yang tersurat: ‘ “Aku akan merebahkan Gembala, dan kawanan domba akan bertempiaran.” ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","‘Tetapi setelah Aku dibangkitkan semula, Aku akan mendahuluimu pergi ke Galilea.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus berkata kepadanya, ‘Kalaupun semua yang lain goyah imannya, aku tidak akan goyah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Isa berkata kepadanya, ‘Sesungguhnya, Aku berkata kepadamu, pada malam ini sebelum ayam berkokok dua kali, kamu akan menyangkal-Ku tiga kali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tetapi Petrus berkata dengan lebih tegas lagi, ‘Kalaupun aku terpaksa mati bersama-Mu, aku tidak akan menyangkal-Mu.’ Semua yang lain pun berkata demikian. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mereka sampai di suatu tempat yang dinamakan Getsemani. Isa berkata kepada para pengikut-Nya, ‘Duduklah di sini sementara Aku berdoa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dia membawa Petrus, Yakobus dan Yahya bersama-Nya, dan Dia mula berasa gundah dan amat terseksa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Dia berkata kepada mereka, ‘Jiwa-Ku sungguh dukacita, bagaikan mati. Duduklah di sini, dan berjagalah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dia pergi jauh sedikit lagi, lalu sujud di tanah, dan berdoa kiranya dapat semoga saat itu diedarkan daripada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kata-Nya, ‘Abba, Bapa, segala-galanya dapat Kaulakukan. Edarkanlah cawan ini daripada-Ku. Namun, berlakulah kehendak-Mu, bukan kehendak-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kemudian dia kembali kepada pengikut-pengikut-Nya dan mendapati mereka sedang tidur, lalu Dia berkata kepada Petrus, ‘Simon, kamu tidur? Satu jam pun kamu tidak dapat berjaga? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Berjaga dan berdoalah, takut nanti kamu tergoda. Memang rohani rela, tetapi jasmani lemah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dia pergi berdoa lagi, dengan kata-kata yang sama. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Apabila Dia kembali, didapati-Nya mereka telah tertidur lagi, kerana mata mereka amat mengantuk. Mereka tidak tahu apa yang hendak dijawab kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Setelah Dia datang kepada mereka bagi kali ketiga, Dia berkata, ‘Adakah kamu masih tidur dan berehat? Cukuplah! Waktunya sudah tiba. Lihat, Putera Insan sedang dikhianati dan diserahkan ke tangan orang berdosa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bangunlah! Mari kita pergi! Lihat, pengkhianat-Ku sudah tiba!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sesaat kemudian, ketika Dia masih berkata-kata, seorang daripada pengikut-Nya yang dua belas itu iaitu Yudas datang dengan orang yang sangat ramai dan bersenjatakan pedang serta belantan. Mereka datang daripada ketua-ketua imam, guru-guru Taurat dan tua-tua. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Pengkhianat Isa telah menetapkan satu isyarat dengan mereka: ‘Sesiapa yang kucium, itulah Dia. Tangkap Dia dan bawalah Dia pergi dengan selamat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sebaik-baik Yudas tiba, dia pergi kepada Isa sambil berkata, ‘Tuan Guru!’ lalu mencium-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mereka pun menangkap-Nya dan membawa-Nya pergi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Seorang daripada yang berdiri di situ menghunus pedangnya lalu menetak hamba Imam Besar, sehingga terputus telinganya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Isa berkata kepada mereka, ‘Patutkah kamu datang bagaikan hendak menangkap perompak, dengan pedang dan belantan, untuk membawa-Ku pergi? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Setiap hari Aku di kalanganmu, mengajar di rumah ibadat, tidak kamu tangkap. Tetapi yang tersurat di dalam Kitab Suci mesti berlaku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Setelah itu semua pengikut Isa meninggalkan-Nya dan melarikan diri masing-masing. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Seorang pemuda mengikut-Nya, dengan hanya sehelai kain linen membalut tubuhnya. Pemuda-pemuda lain menangkapnya, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","lalu dia melucutkan kain linen itu dan melarikan diri daripada mereka dalam keadaan telanjang. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Isa dibawa kepada Imam Besar. Bersamanya berhimpun semua ketua imam, tua-tua, dan guru-guru Taurat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus mengikut Isa dari jauh, turut masuk ke laman dalam rumah Imam Besar, dan duduk di kalangan hamba-hamba, berdiang di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ketua-ketua imam dan semua ahli Majlis Agama berusaha mencari kesaksian untuk mendakwa Isa, tetapi tidak berjaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ramai yang memberi kesaksian palsu terhadap-Nya, tetapi kesaksian mereka semua bercanggah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kemudian beberapa orang bangkit memberi kesaksian palsu terhadap-Nya dengan berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","‘Kami telah mendengar Dia berkata, “Aku akan membinasakan rumah ibadat yang diperbuat dengan tangan ini, dan dalam tiga hari Aku akan membina rumah ibadat yang diperbuat tanpa tangan.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tetapi kesaksian mereka masih bercanggah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Imam Besar bangkit berdiri di tengah-tengah kesaksian itu lalu bertanya kepada Isa, ‘Tidakkah Kamu mahu menjawab apa-apa? Apakah yang disaksikan oleh mereka ini terhadap-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tetapi Isa berdiam diri, tidak menjawab sepatah pun. Imam Besar itu bertanya lagi kepada-Nya, ‘Adakah Kamu al-Masih, Putera Allah Maha Suci?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Isa menjawab, ‘Ya, Akulah Dia. Kamu akan melihat Putera Insan duduk di kanan Allah Maha Kuasa, dan datang dengan awan syurga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Imam Besar lalu mengoyak-ngoyakkan pakaiannya sambil berkata, ‘Adakah kita perlukan saksi lagi? ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kamu telah mendengar kata-kata kufur-Nya sendiri! Apakah pendapatmu?’ Lalu mereka semua menjatuhkan hukum ke atas-Nya, bahawa Dia patut dibunuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kemudian sesetengah mereka mulai meludahi-Nya, membalut mata-Nya lalu memukul-Nya dan berkata kepada-Nya, ‘Bernubuatlah!’ Pengawal-pengawal pula menampar-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petrus ada di bawah, di laman dalam. Seorang hamba perempuan Imam Besar datang ke situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Apabila dia melihat Petrus sedang berdiang memanaskan tubuhnya, dia memandang Petrus dan berkata, ‘Kamu juga bersama Isa orang Nasaret.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Petrus menyangkal, katanya, ‘Aku tidak tahu dan tidak faham apa yang kaukatakan.’ Dia keluar ke serambi depan, lalu ayam berkokok. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hamba perempuan itu melihatnya lagi, lalu mula berkata kepada orang yang berdiri di situ, ‘Ini seorang daripada mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petrus menyangkalnya lagi. Sejurus kemudian, mereka yang berdiri di situ berkata pula kepada Petrus, ‘Tentu sekali kamu seorang daripada mereka, kerana kamu orang Galilea. Ini nyata daripada cara percakapanmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petrus mengucapkan kutuk dan sumpah, ‘Aku tidak kenal orang yang kaukatakan itu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ayam pun berkokok bagi kali kedua. Lalu Petrus teringat kata-kata Isa kepadanya: ‘Sebelum ayam berkokok dua kali, kamu akan menyangkal-Ku tiga kali.’ Memikirkan perkara itu, Petrus menangis. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Awal-awal pagi lagi ketua-ketua imam segera bermesyuarat dengan para tua-tua, guru Taurat dan seluruh Majlis Agama. Kemudian mereka mengikat Isa, membawa-Nya pergi dan menyerahkan-Nya kepada Pilatus. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus bertanya kepada-Nya, ‘Adakah Kamu Raja orang Yahudi?’ Isa menjawab, ‘Begitulah seperti katamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kemudian ketua-ketua imam melemparkan pelbagai tuduhan terhadap-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatus bertanya lagi kepada-Nya, ‘Tidakkah Engkau mahu menjawab apa-apa? Lihat betapa banyaknya tuduhan mereka terhadap-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tetapi Isa masih tidak menjawab sepatah pun, sehingga Pilatus kehairanan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pada waktu perayaan, lazimnya Pilatus membebaskan seorang banduan dari penjara, iaitu sesiapa yang diminta oleh mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ada seorang bernama Barabas yang dirantaikan bersama beberapa orang pemberontak lain. Mereka telah melakukan pembunuhan dalam pemberontakan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Orang ramai mula berseru lantang meminta Pilatus membebaskan seorang daripada penjara seperti yang biasa dilakukannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatus bertanya, ‘Adakah kamu mahu aku membebaskan kepadamu Raja orang Yahudi?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","kerana dia tahu bahawa ketua-ketua imam telah menyerahkan Isa kepadanya kerana iri hati. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tetapi ketua-ketua imam menghasut orang ramai supaya meminta Barabas dibebaskan kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatus berkata kepada mereka, ‘Kalau begitu, apa yang kamu mahu kulakukan kepada Dia yang kamu panggil Raja orang Yahudi?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mereka berseru lagi dengan kuatnya, ‘Salibkan Dia!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kata Pilatus kepada mereka, ‘Mengapa? Apakah kejahatan yang telah dilakukan-Nya?’ Tetapi mereka semakin kuat berseru, ‘Salibkan Dia!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Oleh itu, untuk memuaskan hati orang ramai itu, Pilatus membebaskan Barabas kepada mereka. Setelah menyebat Isa, dia menyerahkan-Nya untuk disalib. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kemudian para askar membawa-Nya ke dewan yang dipanggil Praetorium, lalu menghimpunkan seluruh pasukan tentera yang ada di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mereka mengenakan pakaian berwarna ungu pada tubuh-Nya, dan membuat mahkota daripada duri lalu meletakkannya di atas kepala-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kemudian mereka menyindir-Nya, ‘Daulat Tuanku, Raja orang Yahudi!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mereka memukul kepala-Nya dengan mensiang, meludahi-Nya, kemudian tunduk menyembah-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Setelah mempermain-mainkan-Nya, mereka melucutkan pakaian ungu itu dan mengenakan semula pakaian-Nya. Lalu mereka membawa-Nya untuk disalib. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ketika itu seorang yang bernama Simon, orang Kirene, bapa kepada Iskandar dan Rufus sedang lalu di situ. Dia baru sahaja datang dari luar bandar. Kemudian mereka memaksanya mengangkat salib Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mereka membawa-Nya ke tempat yang dipanggil Golgota (bermaksud Tempat Tengkorak). ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kemudian mereka memberi-Nya air anggur bercampur mur tetapi Dia enggan meminumnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Setelah mereka menyalib-Nya, mereka membahagikan pakaian-Nya antara mereka dengan membuang undi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mereka menyalib-Nya pada pukul sembilan pagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tuduhan terhadap-Nya tertulis di atas: RAJA ORANG YAHUDI. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mereka menyalib dua orang perompak bersama Isa, seorang di kanan dan seorang lagi di kiri-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dengan demikian berlakulah apa yang tersurat di dalam Kitab Suci: ‘Dan Dia digolongkan dengan penjahat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Semua orang yang lalu di situ menggeleng-gelengkan kepala sambil mengejek Isa. Mereka berkata, ‘Kamu mahu memusnahkan rumah ibadat dan membinanya semula dalam tiga hari! ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sekarang turunlah dari salib itu dan selamatkanlah diri-Mu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ketua-ketua imam dan guru-guru Taurat juga mempermainkan Isa. Mereka berkata sesama sendiri, ‘Dia menyelamatkan orang, tetapi tidak dapat menyelamatkan diri-Nya sendiri! ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kiranya Dia Raja orang Yahudi dan al-Masih, turunlah dari salib, supaya kami melihat dan percaya kepada-Nya!’ Orang yang disalib bersama Isa pun mencela-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pada tengah hari, selama tiga jam, seluruh negeri itu gelap-gelita. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pada pukul tiga petang, Isa berseru dengan suara lantang, ‘Eloi, Eloi, lama sabakhtani?’ Ertinya, ‘Ya Allah, Ya Tuhan-Ku, mengapa Kautinggalkan Aku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Beberapa orang di situ mendengar seruan itu dan berkata, ‘Dengarlah, Dia memanggil Ilyas.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Seorang daripada mereka berlari mengambil span lalu mencelupnya ke dalam air anggur murah. Kemudian dia mencucukkan span itu di hujung sebatang mensiang dan menawarkannya kepada Isa untuk minum, sambil berkata, ‘Kita menunggu, kalau-kalau Ilyas datang menurunkan-Nya dari salib.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Isa berteriak dengan kuat lalu menghembuskan nafas terakhir. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sejurus kemudian, tirai di dalam rumah ibadat terbelah dua, dari atas hingga ke bawah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ketua tentera yang berdiri di hadapan salib itu melihat semua ini lalu berkata, ‘Benarlah Dia Putera Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Beberapa orang wanita menyaksikan segala-galanya dari jauh. Antara mereka ialah Salome, Maryam Magdalena, serta Maryam ibu Yakobus Muda dan Yoses. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mereka wanita-wanita yang mengikut dan menolong Isa ketika Dia di Galilea. Ada ramai juga wanita yang datang dengan Isa ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hari sudah lewat petang. Hari itu Hari Persediaan, iaitu sehari sebelum hari Sabat. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yusuf dari Arimatea, seorang ahli terkemuka Majlis Agama yang sedang menunggu kerajaan Allah, datang lalu memberanikan hatinya menghadap Pilatus dan memohon untuk mengambil jenazah Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus hairan mendengar Isa sudahpun meninggal dunia, lalu memanggil ketua tentera dan bertanya sama ada Isa sudah meninggal. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Setelah mendengar laporan ketua tentera itu, dia pun menyerahkan jenazah Isa kepada Yusuf. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusuf membeli kain linen yang baik, menurunkan jenazah Isa dan mengkafankannya dengan kain itu. Dia membaringkan jenazah itu di dalam sebuah makam yang telah digali di permukaan batu pejal, lalu menggulingkan sebuah batu besar menutup pintu makam itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maryam Magdalena dan Maryam ibu Yoses memerhatikan tempat makam itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Setelah tamat hari Sabat, Maryam Magdalena, Maryam ibu Yakobus, dan Salome membeli ramuan rempah untuk melumuri jenazah Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pada awal pagi hari pertama minggu itu, mereka sampai di makam itu ketika matahari terbit. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mereka berkata-kata sesama sendiri, ‘Siapa yang akan menggulingkan batu daripada pintu makam untuk kita?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Apabila mereka memandang makam itu, mereka mendapati batu yang sangat besar itu telahpun digulingkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mereka masuk ke dalam makam itu dan melihat seorang pemuda berjubah putih sedang duduk di sebelah kanan; mereka sungguh terkejut dan ketakutan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tetapi dia berkata kepada mereka, ‘Jangan takut. Kamu mencari Isa orang Nasaret, yang telah disalib. Dia telah bangkit semula! Dia tidak ada di sini. Lihatlah tempat mereka baringkan jenazah-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tetapi, pergilah, beritahu para pengikut-Nya, termasuk Petrus, bahawa Dia mendahuluimu ke Galilea. Di sana kamu akan melihat-Nya, seperti yang telah dikatakan-Nya kepada kamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mereka pun segera keluar dan berlari meninggalkan makam itu, kerana mereka gementar dan kehairanan. Mereka tidak berkata apa-apa kepada sesiapa, kerana mereka takut. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Setelah Isa bangkit semula pada awal pagi hari pertama minggu itu, pertama sekali Dia menampakkan diri-Nya kepada Maryam Magdalena yang telah disembuhkan-Nya daripada dirasuk tujuh roh iblis dahulu. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maryam pun pergi memberitahu para pengikut-Nya yang sedang berkabung dan menangis. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ketika mendengar bahawa Isa hidup dan telah dilihat oleh Maryam, mereka tidak percaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Selepas itu, Dia menampakkan diri dengan cara lain kepada dua orang daripada mereka ketika mereka sedang berjalan ke desa. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kedua-dua orang pengikut Isa itu segera pergi memberitahu yang lain, tetapi mereka juga tidak percaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kemudian Dia menampakkan diri kepada kesemua pengikut-Nya yang sebelas itu ketika mereka sedang makan. Dia menegur sikap mereka yang tidak percaya dan keras hati, kerana mereka tidak mempercayai orang yang telah melihat-Nya setelah Dia bangkit semula. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dia berkata kepada mereka, ‘Pergilah ke serata dunia dan sebarkan Injil kepada setiap insan. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sesiapa yang percaya dan diimadkan akan diselamatkan, tetapi sesiapa yang tidak percaya akan dihukum. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tanda-tanda ini akan menyertai mereka yang percaya: Dengan nama-Ku mereka akan menghalau roh-roh iblis, dan mereka akan bertutur dengan bahasa-bahasa baru. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mereka akan memegang ular tanpa mudarat. Kiranya mereka terminum racun, mereka tetap selamat. Mereka akan meletakkan tangan pada orang sakit dan orang itu akan sembuh.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Setelah Junjungan Isa berkata-kata dengan mereka, Dia disambut naik ke syurga lalu duduk di kanan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Para pengikut-Nya pergi mengajar di serata dunia. Tuhan bekerja bersama mereka, mengesahkan firman dengan iringan tanda-tanda ajaib. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kepada yang dihormati Teofilus, Ramai orang telah berusaha bersungguh-sungguh untuk mencatat peristiwa-peristiwa yang telah berlaku di kalangan kita ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","sebagaimana yang diberitahu kepada kita oleh saksi-saksi pertama peristiwa ini yang juga merupakan pemberita Firman. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Oleh sebab aku telah mengkaji perkara-perkara ini dari mulanya, aku berfikir eloklah aku mengarang cerita-Nya dengan teratur untuk tuan Teofilus. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aku berbuat demikian supaya tuan akan mengetahui kebenaran yang sepenuhnya tentang perkara-perkara yang telah diajarkan kepada tuan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pada zaman Herodes, raja negeri Yudea, ada seorang imam yang bernama Zakaria. Dia terdiri daripada golongan Abia. Isterinya, Ashba, juga daripada keturunan Harun. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kedua-duanya orang yang lurus di hadapan Allah, dan mengikut segala perintah serta hukum Tuhan dengan sepenuhnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tetapi mereka tidak mempunyai anak kerana Ashba mandul, dan kedua-duanya pun telah lanjut usia. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pada suatu hari Zakaria melaksanakan tugasnya sebagai imam di hadapan Allah menurut gilirannya bertugas. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mengikut peraturan keimaman, dia diundi masuk ke dalam rumah ibadat Tuhan untuk membakar kemenyan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Orang ramai berhimpun di luar untuk beribadat sewaktu kemenyan dibakar. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kelihatanlah kepada Zakaria, malaikat Tuhan berdiri di sebelah kanan tempat pembakar kemenyan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Hati Zakaria berdebar apabila melihatnya dan dia berasa amat takut. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tetapi malaikat itu berkata kepadanya, ‘Janganlah takut, hai Zakaria, kerana permohonanmu telah dikabulkan. Isterimu Ashba akan melahirkan seorang anak lelaki bagimu. Kamu hendaklah menamainya Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kamu akan bergembira dan bersukacita apabila dia dilahirkan. Begitu juga ramai orang lain ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kerana dia akan menjadi mulia di sisi Tuhan. Dia tidak akan minum air anggur atau minuman keras kerana dia akan dipenuhi dengan Roh Suci sejak dari rahim ibunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dia akan mengembalikan ramai orang Israel kepada Allah, Tuhan mereka, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","dan dia akan melangkah di hadapan Tuhan dengan roh dan kuasa Ilyas untuk mendamaikan bapa dengan anak dan mengembalikan orang ingkar ke jalan orang benar, supaya menyediakan suatu kaum yang bersiap sedia bagi Tuhan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria berkata kepada malaikat itu, ‘Bagaimanakah aku dapat mengetahui perkara ini akan berlaku? Aku telah tua dan isteriku pun telah lanjut usianya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaikat itu menjawab lagi, ‘Akulah Jibrail yang berdiri di hadirat Allah. Aku telah diutuskan untuk menyampaikan perkhabaran yang baik ini kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ingatlah: oleh sebab engkau tidak mempercayai kata-kataku ini yang akan berlaku pada masanya, engkau akan menjadi bisu dan tidak dapat bertutur hingga pada hari semua perkara ini berlaku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sementara itu, orang yang berhimpun itu ternanti-nanti akan Zakaria; mereka sangat hairan kerana dia begitu lama di dalam rumah ibadat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Apabila dia keluar, dia tidak dapat bertutur kepada mereka. Lalu mereka menyedari Zakaria telah nampak sesuatu di dalam rumah ibadat. Oleh sebab dia tidak dapat bertutur, dia menggunakan isyarat dengan tangannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Setelah tamat masa perkhidmatannya, Zakaria kembali ke rumahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kemudian, Ashba, isterinya pun hamil lalu dia tidak meninggalkan rumahnya selama lima bulan. Dia berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","‘Akhirnya, Tuhan telah menolongku. Dia menghapuskan aibku di kalangan masyarakat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Dalam bulan yang keenam, malaikat Jibrail diutus Allah ke Nasaret, sebuah kota di jajahan Galilea, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kepada seorang anak dara yang telah bertunang dengan seorang lelaki yang bernama Yusuf daripada keturunan Raja Daud. Nama anak dara itu ialah Maryam. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaikat itu datang kepadanya lalu berkata, ‘Salam kepadamu yang amat diredai Allah! Tuhan bersamamu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Hati Maryam runsing mendengar kata-kata itu dan dia tertanya-tanya akan maksud salam tersebut. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Seterusnya, malaikat itu berkata kepadanya, ‘Janganlah takut, hai Maryam, kerana engkau telah diredai Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Engkau akan hamil dan melahirkan seorang anak lelaki. Engkau hendaklah menamai-Nya Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dia akan menjadi mulia dan Dia akan digelar Putera Allah Yang Maha Tinggi. Allah, Tuhan kita akan mengurniakan takhta Daud, nenek moyang-Nya itu kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Dia akan merajai keturunan Yakub selama-lamanya; dan kerajaannya berkekalan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Lalu Maryam berkata kepada malaikat itu, ‘Bagaimanakah perkara ini dapat berlaku, sedangkan aku masih dara?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaikat itu menjawab, “Roh Suci akan turun ke atasmu, dan kuasa Allah Yang Maha Tinggi akan menaungimu. Oleh itu, anak suci yang akan dilahirkan akan digelar Putera Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tambahan pula, saudaramu Ashba yang dahulu dikatakan mandul pun telah hamil enam bulan walaupun dia sudah tua. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sebab bagi Allah tidak ada yang mustahil. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryam berkata, ‘Aku ini hamba Tuhan. Jadilah kepada aku mengikut kata-katamu itu.’ Lalu malaikat pun meninggalkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Setelah itu, Maryam bersiap-siap dan bergegas pergi ke sebuah kota di kawasan pergunungan Yudea. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Dia masuk ke dalam rumah Zakaria dan memberi salam kepada Ashba. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Apabila Ashba mendengar salam Maryam, anak dalam kandungannya bergerak-gerak dan Ashba dipenuhi Roh Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dia berseru, ‘Diberkati engkau antara kaum perempuan, dan diberkatilah juga kandunganmu itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Siapakah aku ini sehingga ibu Junjunganku datang kepadaku? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Apabila kudengar salammu, anak dalam kandunganku bergerak-gerak dengan kesukaan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Diberkatilah kamu kerana mempercayai apa yang dikatakan kepadamu daripada Tuhan akan berlaku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maryam berkata, ‘Jiwaku meninggikan Tuhan; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","rohku bergembira kerana Allah, Penyelamatku, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kerana Dia mengingati hamba-Nya yang hina ini. Dari sekarang hingga selama-lamanya, orang akan berkata aku diberkati, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kerana Yang Maha Kuasa telah melakukan perkara yang besar untuk aku. Sucilah Nama-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dia memberkati mereka yang takut akan Dia, daripada satu keturunan kepada satu keturunan yang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dia telah menunjukkan kekuatan tangan-Nya; Dia telah mencerai-beraikan mereka yang berhati bongkak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Dia telah menurunkan raja-raja daripada takhta mereka dan mengangkat tinggi orang yang hina; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dia telah memuaskan orang yang lapar dengan segala yang baik, tetapi orang kaya dihalau pergi dengan tangan kosong. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dia menolong bangsa Israel, hamba-Nya kerana Dia ingat akan belas kasihan-Nya ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","yang dijanjikan kepada nenek moyang kita Ibrahim dan semua keturunannya untuk selama-lamanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryam tinggal bersama Ashba selama tiga bulan. Selepas itu, dia pulang ke rumahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tibalah masanya untuk Ashba bersalin dan dia melahirkan seorang anak lelaki. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Apabila jiran tetangga dan saudara-maranya mendengar bahawa Tuhan telah melimpahkan berkat kepadanya, mereka turut bergembira bersamanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pada hari yang kelapan, mereka datang untuk menyunatkan bayi itu. Mereka mahu menamainya Zakaria seperti nama bapanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tetapi ibunya berkata, ‘Tidak! Namanya ialah Yahya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mereka berkata kepada Ashba, ‘Tiada seorang pun daripada kaum keluargamu yang bernama sedemikian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lalu mereka bertanya kepada bapanya dengan menggunakan isyarat nama yang hendak diberikan kepada anaknya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dia meminta papan tulis lalu menulis demikian, ‘Namanya Yahya.’ Semuanya kehairanan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pada seketika itu, mulut Zakaria terbuka dan lidahnya tidak terikat lalu dia bercakap dan memuji Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Semua jirannya sangat takut dan segala perkara ini tersebar ke seluruh jajahan Yudea. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Semua orang yang mendengarnya berkata dalam hati masing-masing, ‘Bagaimanakah gerangan halnya anak ini kelak?’ Jelaslah bahawa tangan Tuhan memimpinnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Bapanya, Zakaria, dipenuhi dengan Roh Suci lalu berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","‘Segala puji bagi Allah, Tuhan bangsa Israel! Kerana Dia telah datang dan menebus umat-Nya; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dia telah mengurniai kita seorang Penyelamat yang berkuasa, seorang daripada keturunan hamba-Nya, Daud. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Demikianlah firman-Nya dengan perantaraan nabi-nabi-Nya yang suci dari zaman dahulu kala, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Dia berjanji menyelamatkan kita daripada musuh-musuh kita, dan daripada tangan semua orang yang membenci kita; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dia mengasihani nenek moyang kita, dan mengingati perjanjian-Nya yang suci, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Dia berjanji kepada nenek moyang kita, Ibrahim, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","untuk menyelamatkan kita daripada musuh-musuh kita supaya tanpa rasa takut kita beribadat kepada-Nya ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","dalam kesucian dan kebenaran sepanjang hidup kita. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Engkau, anakku, akan digelar nabi Allah Yang Maha Tinggi kerana engkau mendahului Tuhan demi menyediakan jalan-Nya, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","dan memberitahu umat-Nya bahawa mereka diselamatkan apabila dosa mereka diampunkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Oleh sebab Allah, Tuhan kita mengasihani kita, cahaya matahari akan terbit ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","untuk menerangi orang yang tinggal dalam kegelapan dan bayang maut, serta memimpin kita ke jalan damai.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anak itu membesar dan bertambah kuat dari segi kerohaniannya. Dia tinggal di gurun sehinggalah dia muncul di khalayak bangsa Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pada masa itu Kaisar Augustus menitahkan penduduk di seluruh kerajaan Rom dibanci. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ketika pembancian pertama dilaksanakan, Kurenius menjadi gabenor di Siria. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Dalam pembancian tersebut, setiap orang perlu kembali ke tempat lahir masing-masing untuk mendaftarkan diri. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Oleh itu, Yusuf terpaksa berangkat dari bandar Nasaret di Galilea ke kota Daud yang bernama Baitlahim di Yudea kerana dia daripada keturunan Daud. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Dia pergi untuk mendaftarkan diri bersama Maryam, tunangnya yang sedang hamil. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sewaktu mereka di sana, tibalah masanya untuk dia bersalin. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Dia melahirkan seorang anak lelaki, iaitu anak sulungnya. Dia membedung anak itu lalu membaringkan-Nya di dalam sebuah palung kerana tidak ada tempat bagi mereka di rumah tumpangan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Di daerah itu ada beberapa orang gembala yang bermalam di padang kerana menjaga domba mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tiba-tiba malaikat Tuhan muncul di hadapan mereka dan kemuliaan Tuhan menerangi mereka, lalu mereka ketakutan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tetapi malaikat itu berkata kepada mereka, ‘Jangan takut! Aku membawa kepadamu berita baik yang akan memberikan sukacita besar kepada seluruh umat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Pada malam ini di kota Daud telah lahir seorang Penyelamat bagimu, iaitu al-Masih, Junjungan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Inilah tandanya bagimu: Kamu akan menjumpai seorang anak yang dibedung dan dibaringkan di dalam sebuah palung.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tiba-tiba malaikat itu disertai oleh satu angkatan besar dari syurga yang memuji-muji Allah: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","‘Kemuliaan bagi Allah di tempat yang maha tinggi dan damai sejahtera di bumi bagi orang yang berkenan pada hati-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Setelah malaikat-malaikat itu meninggalkan mereka untuk kembali ke syurga, gembala-gembala itu berkata sesama sendiri, ‘Marilah kita pergi ke Baitlahim untuk melihat kejadian yang telah berlaku itu seperti yang diberitahu Tuhan kepada kita.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mereka pergi dengan segera lalu menjumpai Maryam dan Yusuf serta bayi itu yang sedang terbaring di dalam palung. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Setelah melihat bayi itu, mereka pun memberitahu segala yang telah dikatakan kepada mereka tentang anak itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Semua yang mendengar berasa kagum tentang apa yang dikatakan oleh gembala-gembala itu kepada mereka; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","tetapi Maryam mengingati segala perkara ini dan merenunginya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kemudian gembala-gembala itu pulang sambil memuji-muji Allah atas segala yang didengar dan dilihat mereka. Segalanya seperti yang dikatakan kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lapan hari kemudian, tibalah masanya untuk menyunatkan bayi itu, lalu Dia diberikan nama Isa, seperti yang dikatakan oleh malaikat sebelum Dia dikandung oleh Maryam. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Setelah tamat masa penyucian mengikut hukum Taurat Musa, mereka pun membawa Isa ke Baitulmaqdis untuk mempersembahkan-Nya kepada Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tersurat dalam Hukum Tuhan bahawa setiap anak lelaki sulung akan diserahkan kepada Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mereka juga mempersembahkan korban mengikut apa yang ditetapkan dalam Hukum Tuhan, iaitu sepasang burung tekukur atau dua ekor anak merpati. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pada masa itu ada seorang di Baitulmaqdis yang bernama Simeon. Seorang yang salih dan bertakwa kepada Allah, Simeon menantikan masa terhiburnya Israel. Dan dia diasertai Roh Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Roh Suci telah memberitahunya bahawa dia tidak akan meninggal dunia sebelum dia melihat al-Masih yang dijanjikan oleh Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Atas pimpinan Roh dia masuk ke dalam rumah ibadat. Ketika Isa, anak itu, dibawa masuk oleh ibu bapa-Nya untuk menunaikan hukum Taurat itu, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon mendukung Dia dan bersyukur kepada Allah lalu berkata: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","‘Ya Tuhan, sekarang biarlah hamba-Mu pergi dengan sejahtera, menurut firman-Mu: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kerana mataku telah melihat penyelamatan-Mu ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yang telah Kausediakan di hadapan segala bangsa, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","satu cahaya yang akan menunjukkan jalan kepada bangsa-bangsa asing dan menjadi kemuliaan bagi umat-Mu Israel.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ibu bapa-Nya kagum mendengar apa yang dikatakan tentang anak itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon memberkati mereka dan berkata kepada Maryam, ibu anak itu, ‘Anak ini telah dipilih oleh Tuhan untuk menjatuhkan dan membangunkan ramai orang Israel kelak; Dia menjadi tanda daripada Allah yang akan dibantahi orang ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","supaya fikiran dalam hati mereka didedahkan. Dan jiwamu sendiri akan ditusuk oleh pedang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ada pula seorang nabiah yang bernama Hana binti Fanuel, daripada suku Asyer. Dia telah lanjut usianya. Dia berkahwin selama tujuh tahun ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","dan menjadi balu selama lapan puluh empat tahun. Dia tidak pernah meninggalkan rumah ibadat, malahan dia beribadat kepada Allah dengan berpuasa dan berdoa siang malam. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pada ketika itu juga, dia datang dan mengucapkan syukur kepada Allah lalu berkata tentang anak itu kepada semua orang yang menantikan pembebasan bagi Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Setelah ibu bapa-Nya menunaikan segala yang wajib menurut Hukum Tuhan, mereka pulang ke kota Nasaret, kota tempat tinggal mereka di Galilea. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Anak itu semakin membesar dan bertambah kuat serta penuh dengan kebijaksanaan. Kasih kurnia Tuhan ada pada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tiap-tiap tahun ibu bapa-Nya pergi ke Baitulmaqdis untuk menyambut perayaan Paska. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ketika Isa berusia dua belas tahun, mereka pergi menghadiri perayaan itu seperti biasa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Setelah tamat perayaan itu, mereka pun berangkat pulang; tetapi Isa, anak mereka itu tertinggal di Baitulmaqdis dan ibu bapa-Nya tidak menyedari hal itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mereka menyangka Dia ada bersama teman-teman seperjalanan. Oleh itu mereka berjalan sepanjang hari sebelum mereka mencari-cari Isa di kalangan kaum keluarga dan kenalan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Apabila mereka tidak menjumpai-Nya, mereka kembali ke Baitulmaqdis untuk mencari-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Selepas tiga hari, mereka akhirnya menemui Isa di dalam rumah ibadat. Dia duduk dikelilingi oleh guru-guru Taurat sambil mendengar pengajaran mereka dan menanya soalan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Semua orang yang mendengar Isa kagum akan pengertian dan jawapan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ketika ibu bapa-Nya melihat-Nya, mereka juga kagum lalu ibu-Nya berkata, ‘Anakku, mengapakah Engkau berbuat demikian terhadap kami? Ibu dan ayah begitu bimbang mencari-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Lalu Isa menjawab, ‘Mengapakah ibu dan ayah mencari Aku? Tidakkah ibu dan ayah mengetahui Aku harus melakukan kerja Bapa-Ku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tetapi mereka tidak memahami apa yang dikatakan-Nya kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kemudian Dia pulang bersama mereka ke Nasaret. Dia taat kepada mereka. Ibu-Nya menyimpan segala perkara ini dalam hatinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Isa semakin membesar dan bijaksana. Dia diredai oleh Allah dan manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pada tahun yang kelima belas pemerintahan Kaisar Tiberius, Pontius Pilatus menjadi gabenor negeri Yudea, Herodes menjadi raja negeri Galilea dan saudaranya Filipus menjadi raja di wilayah Iturea dan Trakhonitis, Lisanias menjadi raja Abilene ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","dan Hanas serta Kayafas menjadi imam agung. Pada masa ini, firman Allah disampaikan kepada Yahya anak Zakaria di gurun. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Lalu Yahya pergi ke seluruh daerah Sungai Yordan mengkhabarkan suatu pengimadan sebagai tanda pertaubatan yang membawa pengampunan dosa, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","seperti yang tersurat dalam kitab Nabi Yasyaya: ‘Suara seorang yang berseru di gurun, “Sediakanlah jalan untuk Tuhan, luruskanlah jalan untuk-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Setiap lembah akan ditambak dan setiap gunung serta bukit akan diratakan. Tempat bengkang-bengkok akan diluruskan dan jalan lekak-lekuk akan dilicinkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Semua manusia akan melihat penyelamatan yang dikurniakan oleh Allah.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yahya berkata kepada orang ramai yang berkerumun untuk diimadkannya, ‘Hai, kamu seperti ular berbisa, siapakah yang telah memberimu amaran supaya melarikan diri daripada kemurkaan Allah yang akan datang? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kamu hendaklah membuktikan pertaubatanmu dengan perbuatan yang baik, dan jangan mula berkata sesama sendiri, ‘Ibrahim bapa kita’, kerana aku berkata kepadamu bahawa Allah berkuasa menjadikan anak-anak bagi Ibrahim daripada batu-batu ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kapak telah sedia terletak pada akar pokok kayu. Jadi, setiap pokok kayu yang tidak mengeluarkan buah yang baik akan ditebang dan dibuangkan ke dalam api.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Orang ramai itu bertanya kepada Yahya, ‘Jadi, apa yang harus kami buat?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dia menjawab, ‘Sesiapa yang mempunyai dua helai baju hendaklah memberi kepada orang yang tidak mempunyai baju, dan sesiapa yang mempunyai makanan hendaklah berkongsi dengan orang yang memerlukannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ada pemungut cukai datang untuk diimadkan lalu bertanya kepada Yahya, ‘Tuan Guru, apa yang harus kami buat?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yahya berkata kepada mereka, ‘Jangan suruh orang membayar lebih daripada apa yang ditetapkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ada askar bertanya kepadanya, ‘Bagaimanakah dengan kami? Apa yang harus kami buat?’ Yahya berkata kepada mereka, ‘Jangan aniayai orang dan jangan rampas harta benda atau ajukan tuduhan palsu. Berpuas hatilah dengan gajimu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Orang ramai menanti-nanti dengan penuh harapan dan mereka tertanya-tanya dalam hati tentang Yahya kalau-kalau dialah al-Masih itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yahya berkata kepada mereka, ‘Aku ini mengimadkan kamu dengan air tetapi seorang yang lebih berkuasa daripadaku akan datang. Aku ini tidak layak walaupun untuk mengurai tali kasut-Nya. Dialah yang akan mengimadkan kamu dengan Roh Suci dan api. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nyiru ada di dalam tangan-Nya untuk menampi bijirin dan mengumpulkannya di dalam rengkiang tetapi sekam akan dibakar-Nya dalam api yang tidak dapat dipadamkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yahya menasihati orang dengan pelbagai cara serta memberitakan Injil kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Dia telah menegur Raja Herodes tentang perkahwinannya dengan Herodias, isteri saudaranya, dan tentang segala kejahatan yang dilakukannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kemudian, Raja Herodes melakukan dosa yang lebih dahsyat dengan memenjarakan Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ketika semua orang diimadkan, Isa pula diimadkan. Ketika Dia berdoa, langit terbuka, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Roh Suci bagai burung merpati turun ke atas-Nya. Kedengaran satu suara dari langit yang berkata, ‘Engkaulah Putera-Ku yang Kukasihi dan dengan-Mu Aku berkenan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Isa berusia lebih kurang tiga puluh tahun pada masa Dia memulakan pelayanan-Nya. Pada sangkaan orang, Dia anak kepada Yusuf, anak Eli, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","anak Matat, anak Lewi, anak Malkhi, anak Yanai, anak Yusuf, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","anak Matica, anak Amush, anak Nahum, anak Hesli, anak Nagai, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","anak Maat, anak Matica, anak Simei, anak Yosekh, anak Yoda, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","anak Yohanan, anak Resa, anak Zerubabel, anak Sealtiel, anak Neri, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","anak Malkhi, anak Adi, anak Kosam, anak Elmadam, anak Er, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","anak Yesua, anak Eliezer, anak Yorim, anak Matat, anak Lewi, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","anak Simeon, anak Yuda, anak Yusuf, anak Yonam, anak Elyakim, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","anak Melea, anak Mina, anak Matata, anak Natan, anak Daud, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","anak Isai, anak Obed, anak Boas, anak Salmon, anak Nahason, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","anak Aminadab, anak Admin, anak Arni, anak Hezron, anak Peres, anak Yuda, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","anak Yakub, anak Ishak, anak Ibrahim, anak Terah, anak Nahor, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","anak Serug, anak Rehu, anak Peleg, anak Eber, anak Selah, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","anak Kenan, anak Arpakhsad, anak Sem, anak Nuh, anak Lemekh, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","anak Metuselah, anak Henokh (juga disebut Idris), anak Yared, anak Mahalaleel, anak Kenan, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","anak Enos, anak Set, anak Adam, anak Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Isa penuh dengan Roh Suci, kembali dari daerah Yordan dan dipimpin oleh Roh ke padang gurun. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Selama empat puluh hari, Dia digoda oleh Iblis. Sepanjang masa itu, Dia tidak makan apa-apa. Akhirnya, Dia berasa lapar. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Lalu Iblis berkata kepada-Nya, ‘Jikalau Engkau Putera Allah, perintahkan batu ini supaya menjadi roti.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Isa menjawab, ‘Dalam Kitab Suci tersurat, “Manusia hidup bukan hanya dengan roti sahaja.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Iblis membawa Isa ke satu tempat yang tinggi lalu dalam sekelip mata, Iblis memperlihatkan kepada Isa segala kerajaan di dunia. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Iblis berkata, ‘Aku akan memberikan segala kekuasaan ini dengan kemuliaannya kepada-Mu kerana semuanya itu telah diserahkan kepadaku dan aku boleh memberikannya kepada sesiapa jua yang aku suka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jadi, jikalau Engkau menyembah aku, keseluruhannya akan menjadi kepunyaan-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tetapi Isa menjawab, ‘Dalam Kitab Suci tersurat, “Hendaklah engkau menyembah Allah, Tuhanmu dan kepada-Nya sahaja engkau beribadat.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kemudian, Iblis membawa Isa ke Baitulmaqdis lalu menempatkan-Nya di atas mercu rumah ibadat dan berkata kepada-Nya, ‘Jikalau Engkau Putera Allah, terjunlah ke bawah, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kerana dalam Kitab Suci ada tersurat, ‘ “Allah akan memerintahkan malaikat-malaikat-Nya untuk melindungi-Mu ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","dan mereka akan menatang-Mu dengan tangan mereka supaya kaki-Mu tidak terantuk pada batu.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tetapi Isa menjawab, ‘Kitab Suci juga mengatakan, “Janganlah engkau menduga Allah, Tuhanmu.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setelah Iblis selesai menggoda Isa, dia meninggalkan-Nya untuk sementara waktu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Isa kembali ke Galilea dan kuasa Roh menyertai-Nya. Perkhabaran tentang-Nya tersebar ke seluruh daerah itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dia mengajar di saumaah-saumaah mereka dan semua orang memuji-muji-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kemudian, Isa kembali ke Nasaret, tempat Dia dibesarkan. Pada hari Sabat Dia pergi ke saumaah seperti kebiasaan-Nya. Lalu Dia berdiri untuk membaca Kitab Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kitab Nabi Yasyaya diberikan kepada Isa dan Dia membuka kitab itu untuk membaca ayat yang tersurat: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘Roh Tuhan ada pada-Ku kerana Dia telah memilih Aku untuk memberitakan perkhabaran yang baik kepada orang miskin; Dia telah mengutus Aku untuk mengumumkan pelepasan kepada orang tawanan, penyembuhan kepada orang buta, pembebasan orang yang tertindas, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","dan mengisytiharkan tibanya masa yang Tuhan berkenan!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Isa menutup kitab itu dan memulangkannya kepada petugas lalu duduk. Mata semua orang di dalam saumaah itu tertumpu kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Isa mula berucap kepada mereka, ‘Pada hari ini ayat Kitab Suci ini telah ditepati ketika kamu mendengarnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Semua orang memperkatakan-Nya dan kagum akan kata-kata indah yang diucapkan-Nya. Mereka berkata, ‘Bukankah Dia anak Yusuf?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Isa berkata kepada mereka, ‘Sudah tentunya kamu akan menyebut bidalan ini kepada-Ku, “Tuan tabib, ubati dirimu! Buatlah di kota-Mu sendiri apa yang kami dengar Kaubuat di Kapernaum.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Isa menambah, ‘Sesungguhnya Aku berkata kepadamu, tiada seorang nabi pun yang diterima di kotanya sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dengarlah, sesungguhnya terdapat ramai balu di negeri Israel pada zaman Nabi Ilyas tatkala langit tertutup tidak menurunkan hujan selama tiga tahun enam bulan, menyebabkan bencana kebuluran di seluruh negeri itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tetapi Nabi Ilyas tidak diutus kepada seorang jua pun kecuali seorang balu di bandar Sarafat di Sidon. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Demikian juga, ada ramai orang yang berpenyakit kusta di Israel pada zaman Nabi Ilyasa tetapi tiada seorang pun antara mereka yang disembuhkan melainkan Naaman, orang Siria.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Semua orang di dalam saumaah yang mendengar kata-kata ini naik berang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mereka bangun lalu mengusir Isa dari kota itu. Dia dibawa ke puncak gunung tempat kota itu dibina kerana mereka mahu menghumbankan-Nya ke bawah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tetapi Isa berjalan di tengah-tengah mereka dan beredar dari situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kemudian Isa pergi ke kota Kapernaum di jajahan Galilea dan di situlah Dia mengajar orang pada hari Sabat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mereka kagum mendengar ajaran-Nya kerana kata-kata-Nya berwibawa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Di dalam saumaah itu ada seorang yang dirasuk oleh roh iblis yang durjana. Dia menjerit dengan nyaring, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","‘Ah, mengapakah Engkau mengganggu kami, Isa, orang Nasaret? Engkau datang untuk membinasakan kamikah? Aku mengetahui siapa Engkau ini – Engkaulah Yang Suci daripada Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Isa memarahi roh iblis itu, ‘Diam! Keluar daripada dia!’ Roh iblis itu menghempaskan orang itu di hadapan mereka lalu keluar daripadanya tanpa mencederakannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mereka semua kehairanan dan berkata sesama sendiri, ‘Betapa hebat kata-kata-Nya! Dengan penuh kewibawaan dan kuasa Dia memerintah roh-roh durjana itu, mereka terus keluar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Maka perkhabaran tentang Isa tersebar ke seluruh daerah itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Isa keluar dari saumaah itu lalu pergi ke rumah Simon. Ibu mertua Simon sedang demam panas dan mereka memberitahu Isa tentangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Isa pergi berdiri di tepi katilnya dan mengusir demam itu. Ibu mertua Simon pulih dengan serta-merta lalu bangun dan melayani mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pada waktu senja semua orang yang mengidap berbagai-bagai penyakit dibawa kepada Isa. Dia meletakkan tangan-Nya pada setiap orang dan menyembuhkan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Roh-roh iblis juga keluar daripada ramai orang dan berteriak, ‘Engkaulah Putera Allah.’ Isa memarahi roh-roh iblis itu dan tidak mengizinkan mereka bercakap kerana mereka mengetahui Dialah al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ketika fajar menyingsing, Isa meninggalkan kota itu dan pergi ke tempat yang sunyi. Orang ramai mula mencari Dia, dan apabila mereka menemui-Nya, mereka cuba menahan-Nya daripada meninggalkan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tetapi Isa berkata kepada mereka, ‘Aku harus memberitakan perkhabaran yang baik tentang kerajaan Allah di kota-kota lain juga. Itulah sebabnya Aku diutuskan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jadi, Dia mengkhabarkan Injil di saumaah-saumaah di Yudea. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pada suatu hari semasa Isa berdiri di tepi pantai tasik Genesaret, ramai orang berasak-asak mengerumuni-Nya untuk mendengar firman Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Dia melihat dua buah perahu di situ. Para nelayan yang menangkap ikan telah turun dari perahu itu untuk membasuh jala mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Isa naik ke dalam salah sebuah perahu, iaitu perahu Simon dan memintanya menolak perahu itu jauh sedikit dari pantai. Isa duduk dan mengajar orang ramai dari perahu itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Setelah Dia habis mengajar, Dia berkata kepada Simon, ‘Tolaklah perahu ke air yang dalam dan tebarkan jalamu untuk menangkap ikan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon menjawab, ‘Tuan, semalaman kami cuba sedaya upaya tetapi tidak dapat menangkap apa-apapun. Tetapi, kerana Engkau menyuruh, aku akan menebarkan jala.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Setelah menebarkan jala, mereka menangkap begitu banyak ikan sehingga jala hampir terkoyak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mereka memanggil rakan-rakan dari perahu lain supaya datang menolong. Mereka datang lalu memenuhi kedua-dua buah perahu itu dengan ikan sehingga perahu-perahu itu hampir tenggelam. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Apabila Simon Petrus melihat apa yang telah berlaku, dia berlutut di hadapan Isa dan berkata, ‘Tinggalkan hamba, Ya Junjungan kerana hamba seorang yang berdosa!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon dan semua orang yang bersamanya takjub melihat begitu banyak ikan yang dapat ditangkap mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Begitu juga Yakobus dan Yahya, anak-anak Zebedeus, rakan-rakan Simon. Isa berkata kepada Simon, ‘Jangan takut! Mulai sekarang, engkau akan menjala manusia!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Setelah mereka menyadaikan perahu-perahu itu, mereka meninggalkan semuanya lalu mengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pada suatu hari Isa berada di sebuah bandar. Terdapat seorang yang berpenyakit kusta. Apabila dia melihat Isa, dia meniarap lalu memohon kepada-Nya, ‘Tuan, jikalau Tuan mahu, Tuan berkuasa untuk mentahirkan aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Lalu Isa pun menghulurkan tangan dan menyentuhnya sambil berkata, ‘Aku mahu. Tahirlah engkau!’ Seketika itu juga, penyakit kustanya hilang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Isa berpesan kepadanya, ‘Jangan beritahu hal ini kepada sesiapapun tetapi pergi tunjukkan dirimu kepada imam dan persembahkan suatu korban kerana pentahiranmu, seperti yang ditetapkan oleh Musa untuk membuktikan kepada semua orang bahawa engkau kini sudah tahir.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Akan tetapi, berita tentang Isa tersebar lebih meluas dan ramai orang datang untuk mendengar ajaran-Nya serta memohon-Nya menyembuhkan penyakit mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tetapi Isa kerapkali mengasingkan diri ke tempat yang sunyi untuk berdoa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pada suatu hari ketika Isa mengajar orang, ada beberapa orang Farisi dan ahli Taurat duduk di situ. Mereka telah datang dari setiap bandar di Galilea dan Yudea dan juga dari Baitulmaqdis. Kuasa Allah ada pada Isa untuk menyembuhkan orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Beberapa orang mengusung seorang yang lumpuh dan mereka mencari jalan untuk membawanya ke dalam rumah untuk meletakkannya di hadapan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Oleh sebab mereka tidak dapat membawanya masuk kerana orang bersesak-sesak, mereka naik ke atas bumbung rumah lalu membuka genting supaya dapat menurunkan orang itu dengan tikarnya di tengah-tengah orang ramai di hadapan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Apabila Isa melihat iman mereka, Dia berkata kepada orang lumpuh itu, ‘Saudara, dosa-dosamu diampunkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Guru-guru Taurat dan orang Farisi mula berkata sesama diri, ‘Siapakah orang ini yang mengkufuri Allah? Siapakah yang dapat mengampunkan dosa kecuali Allah sahaja?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tetapi Isa mengetahui fikiran mereka, lalu berkata kepada mereka, ‘Mengapakah kamu memikirkan perkara sedemikian? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yang manakah lebih mudah: mengatakan, “Dosa-dosamu diampunkan,” atau “Bangunlah dan berjalan”? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tetapi, supaya kamu ketahui bahawa Putera Insan berkuasa di bumi ini untuk mengampunkan dosa...’ Lalu Dia berkata kepada orang lumpuh itu, ‘Aku berkata kepadamu, bangunlah, angkat tikarmu dan berjalan pulang ke rumah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Seketika itu juga, dia bangun di hadapan mereka sekalian. Dia mengangkat tikar tempat dia berbaring tadi lalu pulang sambil memuji Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Semua orang tercengang-cengang dan memuji Allah. Mereka dipenuhi dengan perasaan takjub sambil berkata, ‘Pada hari ini kami telah menyaksikan hal yang ajaib!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kemudian Isa keluar dan nampak seorang pemungut cukai yang bernama Lewi sedang duduk di tempat kutipan cukai. Isa berkata kepadanya, ‘Ikutlah Aku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi bangun, meninggalkan semuanya dan mengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi menyediakan satu jamuan besar untuk Isa di rumahnya. Ada ramai pemungut cukai dan orang lain yang turut duduk bersama mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Orang Farisi dan guru-guru Taurat yang semazhab bersungut-sungut kepada pengikut-pengikut Isa, ‘Mengapakah kamu makan dan minum bersama pemungut-pemungut cukai dan orang berdosa?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Isa menjawab, ‘Orang sakitlah yang memerlukan tabib, bukannya orang sihat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aku datang bukannya untuk memanggil orang benar, tetapi orang berdosa, supaya mereka bertaubat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mereka berkata kepada Isa, ‘Pengikut-pengikut Yahya kerapkali berpuasa dan berdoa. Demikian juga pengikut-pengikut orang Farisi. Tetapi pengikut-pengikut-Mu ini makan dan minum sahaja.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Isa menjawab, ‘Dapatkah tetamu-tetamu pengantin lelaki diminta berpuasa selagi pengantin lelaki itu ada bersama-sama? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tetapi selepas pengantin lelaki itu diambil daripada mereka, barulah mereka akan berpuasa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Isa memberitahu juga suatu ibarat kepada mereka: ‘Tiada sesiapapun yang mengoyak secarik kain daripada pakaian yang baru untuk menampalkannya ke atas pakaian lama. Jika demikian, pakaian yang baru itu koyak dan secarik kain yang baru itu tidak sepadan dengan yang lama. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tiada sesiapa juga yang akan menuang air anggur yang baru ke dalam kirbat kulit yang lama. Jikalau demikian, air anggur yang baru itu akan mengoyakkan kirbat kulit itu, lalu air anggur di dalamnya akan tumpah dan kirbat kulit itu pun rosak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tetapi air anggur yang baru harus dituang ke dalam kirbat kulit yang baru. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Dan tiada sesiapapun gemar minum air anggur yang baru selepas dia minum air anggur yang lama kerana katanya, “Yang lama itu lebih baik.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pada hari Sabat Isa berjalan melalui ladang-ladang gandum dan pengikut-pengikut-Nya memetik bulir gandum, menggosoknya dengan tangan lalu memakannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Beberapa orang Farisi berkata kepada mereka, ‘Mengapakah kamu membuat sesuatu yang dilarang pada hari Sabat?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Isa menjawab, ‘Belumkah kamu membaca tentang apa yang dilakukan oleh Daud tatkala dia dan pasukannya berasa lapar? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dia masuk ke dalam rumah ibadat Tuhan lalu mengambil dan memakan Roti Persembahan lalu memberikannya kepada mereka yang ada bersamanya. Roti Persembahan itu dilarang dimakan kecuali oleh imam-imam sahaja.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Isa menambah, ‘Putera Insan berkuasa atas hari Sabat.’ Orang yang tangannya lumpuh sebelah ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pada suatu hari Sabat yang lain, Isa masuk ke dalam saumaah lalu mengajar orang. Terdapat di situ seorang yang lumpuh tangan kanannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Guru-guru Taurat dan orang Farisi mengawasi Isa untuk melihat sama ada Dia akan menyembuhkan orang itu pada hari Sabat kerana mereka hendak mencari alasan untuk menuduh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Isa mengetahui fikiran mereka lalu berkata kepada orang yang lumpuh tangan kanannya, ‘Bangunlah dan berdiri di sini.’ Orang itu pun bangun dan berdiri di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Isa berkata kepada mereka, ‘Aku bertanya kepadamu apa yang dibenarkan oleh hukum kita untuk dilakukan pada hari Sabat: berbuat baik atau berbuat jahat, menyelamatkan nyawa orang atau membinasakannya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Isa memandang sekeliling mereka lalu berkata kepada orang itu, ‘Hulurkanlah tanganmu.’ Orang itu berbuat demikian dan tangannya pun sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tetapi mereka naik berang lalu berbincang sesama diri tentang apa yang harus dibuat terhadap Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pada masa itu Isa naik ke sebuah bukit untuk berdoa. Semalam-malaman Dia berdoa kepada Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Setelah hari siang, Isa memanggil pengikut-pengikut-Nya dan daripada mereka itu, Dia memilih dua belas orang yang digelar-Nya rasul: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon yang dinamakan-Nya Petrus, dan Andreas adiknya, Yakobus dan Yahya, Filipus dan Bartolomeus, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius dan Tomas, Yakobus anak Alfeus, Simon yang disebut orang Patriot, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas anak Yakobus, dan Yudas Iskariot yang menjadi pembelot. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Isa turun bersama mereka lalu berdiri di suatu tempat yang rata dengan ramai pengikut-Nya. Ramai orang dari seluruh jajahan Yudea, dari Baitulmaqdis dan dari wilayah-wilayah Tirus serta Sidon ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","telah datang untuk mendengar Isa dan untuk disembuhkan daripada penyakit mereka. Orang yang dirasuk roh-roh durjana turut datang dan mereka juga disembuhkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Semua orang cuba menyentuh Isa kerana kuasa sedang keluar daripada-Nya untuk menyembuhkan mereka semua. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Isa berpaling kepada pengikut-pengikut-Nya lalu berkata: ‘Diberkatilah kamu yang miskin, kerana kamulah yang empunya kerajaan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Diberkatilah kamu yang lapar sekarang, kerana kamu akan dikenyangkan. Diberkatilah kamu yang menangis sekarang, kerana kamu akan bersuka ria. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Diberkatilah kamu apabila orang membenci kamu, menyingkiri kamu, menghina kamu dan mengutuk kamu kerana Putera Insan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","‘Bersuka rialah apabila perkara itu berlaku dan melonjak keriangan, kerana besar ganjaranmu di syurga kelak. Demikian juga perbuatan nenek moyang mereka terhadap nabi-nabi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‘Tetapi malangnya kamu yang kaya, kerana kamu telah beroleh hidup yang senang-lenang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Malangnya kamu yang sekarang kenyang, kerana kamu akan lapar kelak. Malangnya kamu yang sekarang tertawa, kerana kamu akan menangis dan meratap kelak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Malangnya kamu apabila kamu dipuji semua orang, kerana demikian juga perbuatan nenek moyang mereka kepada nabi-nabi palsu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‘Tetapi kepada kamu yang mendengar, Aku berkata demikian: Kasihilah seterumu, berbuat baik kepada orang yang membenci kamu; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","berkatilah orang yang mengutuk kamu dan doakan orang yang menganiayai kamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jika orang menampar sebelah pipimu, biarlah dia menampar sebelah lagi; jika ada orang mengambil jubah kamu, biarkan dia ambil bajumu juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Berilah setiap orang yang meminta sesuatu daripadamu dan jika sesiapa mengambil barangmu, jangan tuntut balik barang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Berbuatlah kepada orang lain seperti yang kamu ingin mereka berbuat kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‘Jikalau kamu mengasihi orang yang mengasihi kamu, apakah kelebihanmu? Malah, orang berdosa pun mengasihi orang yang mengasihi mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Dan jikalau kamu membalas baik kepada orang yang berbuat baik kepadamu, apakah kelebihanmu? Orang berdosa pun berbuat begitu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jikalau kamu meminjami orang yang kamu harap akan memulangkannya, apakah kelebihanmu? Orang berdosa pun meminjami orang berdosa untuk mendapatkan kembali sama banyaknya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tetapi kamu hendaklah mengasihi seterumu; kamu hendaklah berbuat baik kepadanya dan kamu hendaklah meminjami orang dengan tidak mengharapkan apa-apa. Besarlah ganjaranmu kelak dan kamu akan menjadi anak-anak Allah Yang Maha Tinggi kerana Dia berbuat baik kepada orang yang tidak mengenang jasa dan kepada orang yang zalim. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kamu hendaklah berbelas kasihan seperti Bapamu yang berbelas kasihan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‘Janganlah kamu hakimi orang supaya kamu tidak akan dihakimi. Janganlah kamu hukum orang supaya kamu tidak dihukum. Ampunilah orang dan kamu akan diampuni. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Berilah kepada orang dan kamu akan diberi. Suatu takaran yang baik, dipadatkan dan digoncang sehingga melimpah keluar akan dicurahkan ke atas pangkuanmu. Sukatan yang kamu gunakan itu akan digunakan terhadap kamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kemudian Isa memberitahu suatu ibarat lagi. ‘Bolehkah orang buta memimpin orang buta? Tidakkah kedua-duanya akan jatuh ke dalam longkang? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Seorang murid tidak melebihi gurunya; tetapi setiap murid yang terlatih dengan sempurna akan menyerupai gurunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‘Mengapakah engkau memandang selumbar yang ada di dalam mata saudaramu, tetapi engkau tidak menyedari sebatang kayu yang ada di dalam matamu sendiri? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bagaimanakah engkau dapat berkata kepada saudaramu, “Saudara, biarlah aku keluarkan selumbar itu daripada matamu” sedangkan engkau tidak nampak sebatang kayu yang ada di dalam matamu sendiri? Munafik! Buangkan kayu itu daripada matamu sendiri dahulu, barulah engkau dapat melihat dengan terang untuk mengeluarkan selumbar yang ada di dalam mata saudaramu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‘Pokok yang subur tidak menghasilkan buah yang buruk. Demikian juga pokok yang tidak subur tidak akan menghasilkan buah yang baik. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tiap-tiap pokok dikenal daripada buahnya. Orang tidak memetik buah ara daripada pokok duri atau buah anggur daripada semak duri. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Orang yang baik mengeluarkan perkara yang baik daripada hati yang berlimpah-limpah dengan kebaikan; orang yang jahat mengeluarkan perkara yang jahat daripada hati yang penuh dengan kejahatan. Seseorang akan meluahkan apa yang terkandung di dalam hatinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‘Mengapakah kamu memanggil Aku, “Ya Junjungan, ya Junjungan,” tetapi tidak mematuhi perintah-Ku? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aku akan menunjukkan kepadamu keadaan orang yang datang kepada-Ku dan mendengar serta mentaati kata-kata-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Dia umpama seorang yang membina rumah. Dia menggali lubang dalam-dalam lalu meletakkan asas rumah itu di atas batu. Apabila banjir berlaku, arus dari sungai akan melanda rumah itu tetapi tidak dapat menggoncangkannya kerana rumah itu didirikan dengan kukuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Akan tetapi, orang yang mendengar kata-kata-Ku dan tidak mahu mematuhinya umpama seorang yang membina rumah di atas tanah tanpa asas. Apabila dilanda arus sungai, rumah itu akan roboh dan kerosakannya besar sekali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Setelah Isa habis mengatakan semua perkara ini kepada orang ramai, Dia pergi ke Kapernaum. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Terdapat seorang hamba ketua tentera yang amat disayangi oleh tuannya; hamba itu sedang sakit tenat dan hampir mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Apabila ketua tentera itu mendengar tentang Isa, dia menyuruh beberapa tua-tua Yahudi mendapatkan Isa untuk meminta-Nya datang menyembuhkan hambanya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ketika mendapatkan Isa, mereka memohon-Nya bersungguh-sungguh, ‘Tolonglah kabulkan permintaannya kerana dia patut ditolong. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Dia mengasihi bangsa kita dan dia telah mendirikan sebuah saumaah untuk kita.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lalu Isa pun pergi bersama mereka. Tatkala Dia tidak berapa jauh dari rumah, ketua tentera itu menyuruh beberapa orang sahabat memberitahu Isa, ‘Tuan, tak usah Tuan menyusahkan diri ke rumah aku kerana aku tidak layak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aku juga tidak layak datang untuk menemui Tuan. Memadailah Tuan memberikan perintah sahaja dan hambaku itu akan sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aku juga di bawah perintah orang atasan dan aku ada askar di bawah perintahku. Aku memerintah seseorang, “Pergilah!” dan dia akan pergi; aku memerintah seorang lagi, “Mari!” dan dia akan datang. Aku memerintah seorang hamba, “Buat kerja ini!” dan dia akan melakukannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Isa kagum mendengar ini lalu Dia berpaling kepada orang ramai yang mengikut-Nya sambil berkata, ‘Aku berkata kepadamu bahawa antara bangsa Israel sekalipun belum pernah Aku jumpa orang yang beriman seteguh ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Apabila mereka yang disuruh itu kembali ke rumah ketua tentera Rom itu, mereka mendapati hamba itu telah sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tidak lama kemudian, Isa pergi ke sebuah bandar yang bernama Nain; pengikut-pengikut-Nya dan orang ramai pergi bersama-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ketika Dia mendekati pintu gerbang bandar itu, mayat anak lelaki tunggal seorang balu sedang diusung keluar dan sekumpulan besar orang dari bandar itu bersama dengan wanita itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Apabila Isa melihat balu itu, Dia berasa kasihan terhadapnya lalu berkata kepadanya, ‘Janganlah menangis.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dia berjalan ke hadapan dan menyentuh keranda itu. Orang yang mengusung keranda itu pun berhenti. Lalu Isa berkata, ‘Hai pemuda, Aku berkata kepadamu – bangun!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Orang yang sudah mati itu pun bangun dan mula bercakap; lalu Isa mengembalikannya kepada ibunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Setiap orang ketakutan lalu memuji Allah: ‘Seorang nabi yang agung telah muncul di kalangan kita!’ dan ‘Allah telah mendatangi umat-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Khabar tentang Isa ini tersebar ke seluruh jajahan Yudea dan daerah di sekelilingnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Pengikut-pengikut Yahya memaklumkan segala perkara ini kepada Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yahya memanggil dua orang pengikutnya lalu menyuruh mereka pergi kepada Junjungan untuk bertanya, ‘Adakah Tuan yang dikatakan akan datang itu, atau haruskah kami menantikan seorang yang lain?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Apabila mereka datang kepada Isa, mereka berkata, ‘Yahya yang mengimadkan itu menyuruh kami datang kepada Tuan untuk bertanya, “Adakah Tuan yang akan datang itu, atau haruskah kami menantikan seorang yang lain?” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pada masa itu, Isa sedang menyembuhkan ramai orang yang menderitai penyakit dan kerasukan roh iblis serta mencelikkan mata ramai orang buta. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lalu Isa menjawab kepada mereka, ‘Pergilah dan maklumkan kepada Yahya apa yang telah kamu lihat dan dengar: orang buta dapat melihat, orang tempang dapat berjalan, orang kusta disembuhkan, orang tuli dapat mendengar, orang mati dihidupkan kembali serta perkhabaran yang baik diberitakan kepada orang miskin. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Diberkatilah orang yang tidak berpaling daripada Aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Setelah utusan-utusan Yahya pulang, Isa mula berkata kepada orang ramai itu tentang Yahya, ‘Semasa kamu pergi berjumpa dengan Yahya di gurun, apakah yang hendak kamu lihat? Sebatang buluh yang digoyang oleh angin? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kamu pergi untuk melihat apa? Seorang yang mengenakan pakaian bergaya? Sebenarnya, orang yang mengenakan pakaian bergaya dan hidup dalam kemewahan didapati di istana-istana raja. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Oleh itu, kamu pergi untuk melihat apa? Seorang nabi? Ya, dan Aku berkata kepadamu, kamu melihat lebih daripada seorang nabi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Dialah yang dikatakan dalam Kitab Suci: ‘ “Aku akan menghantar utusan-Ku untuk mendahului-Mu, dialah yang akan menyediakan jalan bagi-Mu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aku berkata kepadamu bahawa Yahya itu lebih besar daripada semua orang yang pernah dilahirkan. Akan tetapi, orang yang terkecil dalam kerajaan Allah lebih besar daripadanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Orang ramai itu, termasuk pemungut-pemungut cukai, mendengar Isa. Mereka mengakui kebenaran Allah kerana mereka telah menerima pengimadan Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tetapi orang Farisi dan guru-guru Taurat enggan menerima pengimadan Yahya, maka mereka menolak kehendak Allah untuk mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","‘Dengan apakah dapat Aku umpamakan orang pada zaman ini? Bagaimanakah keadaan mereka? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mereka umpama budak-budak yang duduk di pasar dan berseru-seru sesama sendiri: ‘ “Kami telah memainkan serunai untukmu, tetapi kamu tidak mahu menari; kami telah menyanyikan lagu-lagu sedih untukmu, tetapi kamu tidak mahu menangis.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kerana Yahya Pengimad telah datang dengan berpuasa dan tidak minum air anggur, lalu kamu berkata, “Dia dirasuk roh iblis” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Putera Insan datang dengan makan dan minum lalu kamu berkata, “Tengoklah, orang gelojoh dan peminum, sahabat kepada pemungut-pemungut cukai dan orang berdosa.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tetapi kebijaksanaan dibuktikan benar oleh semua orang yang menerimanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Salah seorang Farisi menjemput Isa makan di rumahnya. Isa masuk ke rumah orang Farisi itu lalu bertelekan pada meja. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Di dalam kota itu ada seorang perempuan yang hidup dalam dosa. Setelah dia mendengar bahawa Isa sedang makan di rumah orang Farisi itu, dia membawa sebuah botol berisi minyak wangi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Dia berdiri di belakang Isa dekat dengan kaki-Nya dan menangis lalu membasahi kaki Isa dengan air matanya. Dia mengeringkan kaki Isa dengan menggunakan rambutnya, mencium kaki-Nya lalu menuang minyak wangi itu pada kaki-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Apabila melihat perkara ini, orang Farisi yang menjemput Isa berkata-kata dalam hatinya, ‘Jika orang ini seorang nabi, tentulah dia mengetahui perempuan yang menyentuh-Nya seorang yang hidup berdosa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Isa menjawabnya, ‘Simon, ada sesuatu yang hendak Aku katakan kepadamu.’ Simon berkata, ‘Ya Guru, katakanlah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","‘Ada dua orang berhutang kepada seorang pemiutang wang. Seorang berhutang lima ratus dinar dan seorang lagi lima puluh dinar. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Oleh sebab mereka tidak dapat membayar hutang itu, dia pun menghapuskan hutang kedua-dua penghutang wang itu. Antara mereka, yang manakah akan lebih mengasihinya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon menjawab, ‘Aku rasa orang yang dihapuskan hutangnya yang lebih besar itu.’ Isa berkata kepadanya, ‘Betullah jawapanmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Lalu Isa berpaling kepada perempuan itu dan berkata kepada Simon, ‘Engkau melihat perempuan ini? Aku masuk ke rumahmu dan engkau tidak memberikan air membasuh kaki-Ku tetapi perempuan ini telah membasahi kaki-Ku dengan air matanya lalu mengeringkannya dengan rambutnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Engkau tidak menyambut Aku dengan ciuman, tetapi semenjak Aku masuk, perempuan ini tidak berhenti-henti mencium kaki-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Engkau tidak menuang minyak pada kepala-Ku, tetapi perempuan ini telah menuang minyak wangi pada kaki-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Oleh sebab itu, Aku berkata kepadamu bahawa kerana kasihnya yang besar, dosanya yang banyak itu telah diampunkan, tetapi orang yang telah diampuni sedikit sahaja, mengasihi sedikit juga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Isa berkata kepada perempuan itu, ‘Dosa-dosamu telah diampunkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mereka yang makan bersama Isa berkata sesama sendiri, ‘Siapakah orang ini yang mengampunkan dosa pula?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Isa berkata kepada perempuan itu, ‘Imanmu telah menyelamatkanmu. Pergilah dengan sejahtera.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tidak lama kemudian, Isa pergi dari bandar ke bandar dan dari kampung ke kampung untuk memberitakan perkhabaran yang baik tentang kerajaan Allah. Dua belas pengikut itu pergi bersama-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Begitu juga beberapa orang perempuan yang telah disembuhkan daripada kerasukan roh iblis dan daripada berbagai-bagai penyakit, iaitu Maryam (yang disebut orang Magdala) yang daripadanya telah diusir tujuh roh iblis; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana, isteri Khuza, pegawai istana Raja Herodes; Susana dan ramai perempuan lain yang menggunakan harta benda mereka untuk membantu Isa serta pengikut-pengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ketika orang ramai sedang berkumpul, dan orang dari beberapa buah bandar terus-menerus datang kepada-Nya, Dia menceritakan suatu ibarat: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","‘Seorang penabur pergi menabur benihnya. Ketika dia menabur, ada yang jatuh di tepi jalan lalu dipijak orang dan dimakan burung. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ada yang jatuh di tempat berbatu, dan setelah tumbuh, tanaman itu menjadi layu kerana tanah kekurangan air. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ada pula jatuh di tengah-tengah semak duri lalu duri yang tumbuh bersama-sama membantutkan pertumbuhannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tetapi ada benih yang jatuh di tanah yang baik lalu tumbuh dan mengeluarkan hasil seratus ganda banyaknya.’ Kemudian Isa berseru, ‘Orang yang bertelinga, baiklah dia mendengar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pengikut-pengikut Isa bertanya kepada-Nya, ‘Apakah erti ibarat ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Isa berkata, ‘Pengetahuan rahsia kerajaan Allah telah diberikan kepadamu, tetapi orang lain harus diberitahu dengan menggunakan ibarat supaya, ‘ “mereka terus melihat tetapi tidak nampak, mereka terus mendengar tetapi tidak mengerti.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","‘Inilah maksud ibarat tadi: Benih itu ialah firman Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Benih yang jatuh di tepi jalan itu menggambarkan mereka yang mendengar firman itu tetapi kemudian Iblis datang dan mengambil firman itu daripada hati mereka supaya mereka tidak percaya dan diselamatkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Benih yang jatuh di tempat berbatu itu menggambarkan mereka yang mendengar dan menyambut firman itu dengan gembira tetapi firman itu tidak berakar dalam hati mereka. Mereka itu hanya percaya untuk sementara waktu dan apabila waktu dicubai mereka akan meninggalkan kepercayaan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Benih yang jatuh di tengah-tengah semak duri itu menggambarkan mereka yang telah mendengarnya, tetapi dalam hidup mereka sehari-hari mereka terhimpit oleh kekhuatiran dan kekayaan serta kesenangan hidup lalu mereka tidak mengeluarkan buah dengan sempurna. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Benih yang jatuh di tanah yang baik menggambarkan mereka yang mendengar firman itu dan menyimpannya dalam hati yang tulus ikhlas lalu dengan ketekunan mereka terus mengeluarkan buah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","‘Tiada seorang pun memasang pelita lalu menudungnya dengan sebuah pasu atau meletakkannya di bawah katil. Tetapi dia meletakkannya di atas kaki pelita supaya cahayanya kelihatan kepada orang yang masuk ke ruang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tiada sesuatu pun yang tersembunyi yang tidak didedahkan kelak; tiada sesuatu rahsia pun yang tidak diketahui kelak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Oleh sebab itu, berhati-hatilah bagaimana kamu mendengar. Sesiapa yang ada sesuatu akan diberi lebih banyak lagi; tetapi sesiapa yang tidak ada, sedikit yang disangka ada padanya pun akan diambil daripadanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ibu Isa dan adik-beradik-Nya datang kepada-Nya tetapi mereka tidak dapat bertemu dengan-Nya kerana kesesakan orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Isa diberitahu, ‘Ibu dan adik-beradik-Mu berada di luar dan hendak bertemu dengan-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Isa menjawab kepada mereka, ‘Ibu-Ku dan adik-beradik-Ku ialah mereka yang mendengar firman Allah dan melaksanakannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pada suatu hari Isa bersama pengikut-pengikut-Nya menaiki sebuah perahu. Isa berkata kepada mereka, ‘Marilah kita pergi ke seberang tasik.’ Lalu mereka bertolak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ketika mereka sedang belayar, Isa tertidur. Angin ribut bertiup ke tasik itu dan perahu itu pun dimasuki air sehingga mereka cemas. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mereka pergi kepada Isa dan mengejutkan-Nya. Mereka berkata, ‘Tuan, Tuan, kita hampir tenggelam!’ Isa bangun lalu memarahi angin dan ombak yang bergelora itu. Ribut itu pun berhenti dan segalanya tenang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Isa berkata kepada mereka, ‘Di manakah imanmu?’ Mereka pun takut dan hairan serta berkata sesama sendiri, ‘Siapakah orang ini sehingga angin dan ombak pun menurut perintah-Nya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mereka belayar ke wilayah Gerasa yang di seberang Galilea. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Setelah Isa mendarat, seorang lelaki dari bandar itu datang menemui-Nya. Orang itu telah dirasuk roh-roh iblis dan sudah lama dia tidak berpakaian. Dia tidak tinggal di rumahnya lagi tetapi di gua kubur. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ketika dia melihat Isa, dia berteriak lalu sujud di hadapan-Nya dan berkata dengan suara yang lantang, ‘Mengapakah Engkau mengganggu aku, ya Isa, Putera Allah Yang Maha Tinggi? Aku minta janganlah seksa aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Dia berkata demikian kerana Isa telah memerintah roh durjana itu keluar daripadanya. Dia seringkali dikuasai oleh roh durjana itu. Oleh sebab itu, dia dikawal ketat dan tangan serta kakinya dirantai orang. Tetapi dia dapat memutuskan rantai itu dan dibawa oleh roh durjana ke padang gurun. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Isa bertanya kepadanya, ‘Siapakah namamu?’ Dia menjawab, ‘Legion’ kerana dia telah dirasuk oleh ramai roh iblis. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Roh-roh iblis itu memohon kepada Isa supaya tidak menghalau mereka ke neraka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kebetulannya, di bukit itu ada sekawan babi sedang makan. Roh-roh iblis itu memohon kepada Isa supaya Dia membenarkan mereka masuk ke dalam babi-babi itu dan Isa membenarkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Roh-roh iblis itu keluar daripada orang tadi dan masuk ke dalam babi. Kemudian kawanan babi itu menyerbu ke tempat curam dan terjun ke dalam tasik lalu mati lemas. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Setelah penjaga-penjaga babi itu menyaksikan apa yang telah terjadi, mereka berlari untuk menyebarkan hal itu di bandar dan di kampung-kampung sekitarnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Orang ramai pun keluar untuk melihat apa yang telah terjadi. Mereka datang kepada Isa dan mendapati orang yang telah dibebaskan daripada roh-roh iblis itu duduk di kaki Isa. Orang itu berpakaian dan sudah siuman. Oleh itu, mereka pun ketakutan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Orang yang telah menyaksikan kejadian itu menceritakan kepada mereka bagaimana orang yang kerasukan roh iblis itu telah disembuhkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lalu semua penduduk wilayah Gerasa meminta Isa supaya meninggalkan mereka kerana mereka ketakutan. Isa pun menaiki perahu untuk pulang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Orang yang telah dibebaskan daripada roh-roh iblis itu meminta Isa membenarkan dia mengikut bersama-Nya tetapi Isa menyuruh dia pulang ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","dan berkata, ‘Pulanglah ke rumahmu dan khabarkanlah segala yang dilakukan Allah untukmu.’ Orang itu pergi menyebarkan segala yang dilakukan Isa untuknya di seluruh bandar itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sekembalinya Isa ke seberang tasik, orang ramai pun menyambut-Nya kerana mereka menanti-nantikan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Seorang lelaki yang bernama Yairus, iaitu ketua saumaah datang kepada-Nya. Dia sujud pada kaki Isa dan memohon kepada-Nya supaya datang ke rumahnya ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kerana anak perempuan tunggalnya yang berumur dua belas tahun hampir mati. Semasa Isa berjalan, orang ramai itu mengasak-Nya dari semua sudut. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Terdapat seorang perempuan yang mengidap penyakit pendarahan selama dua belas tahun dan walaupun dia telah menghabiskan segala harta bendanya untuk mendapatkan rawatan daripada beberapa orang tabib, dia tidak dapat disembuhkan oleh sesiapapun. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Perempuan itu datang dari belakang Isa dan menyentuh kaki jubah-Nya. Seketika itu juga, penyakit pendarahannya sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Isa berkata, ‘Siapakah yang menyentuh Aku?’ Apabila semua orang menafikannya, Petrus berkata, ‘Tuan, orang ramai ini menghimpit dan mengasak Tuan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tetapi Isa berkata, ‘Ada orang menyentuh Aku kerana Aku tahu bahawa kuasa telah keluar daripada-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Apabila perempuan itu mengetahui perbuatannya tidak dapat disembunyikan, dia datang dengan gementar lalu sujud di hadapan Isa dan menceritakan kepada-Nya di hadapan orang ramai itu sebabnya dia menyentuh Isa serta bagaimana dia sembuh seketika itu juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Isa berkata kepadanya, ‘Anak-Ku, imanmu telah menyembuhkanmu. Pergilah dengan sejahtera.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sementara Isa masih berkata-kata, seorang utusan datang dari rumah ketua saumaah dan berkata kepada ketua itu, ‘Anak perempuan tuan telah mati. Tidak usah menyusahkan Guru lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Isa mendengar ini dan berkata kepada ketua itu, ‘Janganlah takut, percaya sahaja dan anakmu akan dipulihkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Apabila sampai ke rumah itu, Isa tidak membenarkan sesiapapun masuk bersama-sama selain Petrus, Yahya dan Yakobus serta ibu bapa budak itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Semua orang menangis dan meratapi kematian budak itu. Isa berkata, ‘Janganlah menangis. Dia bukan mati, dia cuma tidur.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mereka mengetawakan Isa kerana mereka mengetahui anak itu telah mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tetapi Isa memegang tangan budak itu dan berseru, ‘Anak-Ku, bangunlah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nyawa budak itu kembali dan dia bangun seketika itu juga. Lalu Isa menyuruh mereka memberi budak itu makanan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ibu bapanya kagum tetapi Isa melarang mereka mengatakan apa-apa tentang kejadian itu kepada sesiapapun. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Isa memanggil dua belas pengikut-Nya itu lalu memberi mereka kuasa dan perintah untuk mengusir segala roh iblis dan menyembuhkan berbagai-bagai penyakit. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dia menyuruh mereka pergi mengkhabarkan kerajaan Allah dan menyembuhkan orang sakit. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Isa berkata kepada mereka, ‘Jangan kamu bawa apa jua pun dalam perjalananmu, baik tongkat, baik beg sedekah, baik makanan, baik wang atau lebih daripada sehelai pakaian. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Di rumah mana-mana pun kamu disambut, tinggallah di situ sehingga kamu meninggalkan bandar tersebut. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Di mana-mana kamu tidak disambut, tinggalkan bandar itu dan kebaskanlah debu daripada kakimu sebagai kesaksian terhadap mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mereka pun berangkat lalu pergi dari kampung ke kampung untuk memberitakan perkhabaran yang baik dan menyembuhkan orang di mana-mana sahaja. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes, raja wilayah, mendengar segala perkara yang berlaku. Dia keliru kerana ada yang mengatakan bahawa Yahya telah hidup semula, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ada yang berkata bahawa Ilyas telah muncul; ada juga yang berkata bahawa salah seorang nabi pada zaman dahulu telah hidup kembali. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes berkata, ‘Yahya itu telah kupancung kepalanya tetapi siapakah orang ini? Banyak perkara tentangnya telah aku dengar.’ Oleh yang demikian, dia mencari jalan untuk menemui Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Setelah rasul-rasul itu kembali, mereka menceritakan kepada Isa segala perkara yang telah dilakukan mereka. Isa membawa mereka ke sebuah bandar yang bernama Betsaida. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tetapi orang ramai mendapat tahu akan hal itu lalu mengikut-Nya. Isa menyambut mereka dan mengkhabarkan kerajaan Allah kepada mereka serta menyembuhkan orang yang memerlukan penyembuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Menjelang senja, dua belas pengikut itu datang kepada Isa. Mereka berkata, ‘Suruhlah orang ramai ini pulang supaya mereka dapat pergi ke desa dan daerah di sekitar untuk mencari makanan dan penginapan kerana tempat ini terpencil.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Isa berkata kepada mereka, ‘Kamulah memberi mereka makanan.’ Pengikut-pengikut itu berkata lagi, ‘Kami hanya ada lima buku roti dan dua ekor ikan, melainkan kami pergi membeli makanan untuk orang ramai ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Terdapat kira-kira lima ribu orang lelaki di situ. Isa berkata kepada pengikut-pengikut-Nya, ‘Suruh mereka duduk berkelompok-kelompok, kira-kira lima puluh orang sekelompok.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pengikut-pengikut itu melakukan suruhan Isa dan semua orang pun duduk. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Isa mengambil lima buku roti dan dua ekor ikan itu. Lalu Dia menengadah ke langit sambil mengucap syukur atas makanan itu dan membahagi-bahagikannya. Dia memberikan makanan itu kepada pengikut-pengikut-Nya untuk dihidangkan kepada orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Semua orang makan hingga kenyang dan dua belas bakul lebihan makanan dipungut oleh pengikut-pengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pada suatu hari semasa Isa berdoa bersendirian, pengikut-pengikut-Nya datang kepada-Nya. Isa bertanya kepada mereka, ‘Mengikut orang ramai, siapakah Aku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mereka menjawab, ‘Ada yang mengatakan Yahya Pengimad; ada yang mengatakan Ilyas; dan ada pula yang berkata bahawa salah seorang daripada nabi telah hidup semula.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Isa berkata kepada mereka, ‘Apa kata kamu: Siapakah Aku pula?’ Petrus menjawab, ‘Al-Masih daripada Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dengan tegasnya Isa melarang mereka memaklumkan hal ini kepada sesiapapun; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","dan menambah, ‘Putera Insan mesti menderita banyak sengsara dan ditentang oleh tua-tua, ketua-ketua imam serta guru-guru Taurat. Dia akan dibunuh, dan bangkit semula pada hari yang ketiga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Isa berkata kepada semua, ‘Jikalau seseorang mahu mengikut-Ku, dia hendaklah melupakan kepentingan diri, memikul salibnya setiap hari dan mengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sesiapa yang mahu memelihara nyawanya akan kehilangannya. Tetapi sesiapa yang mengorbankan nyawanya kerana Aku akan memeliharanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Apakah untungnya kepada seseorang jikalau dia memiliki seluruh dunia tetapi dirinya sendiri kehilangan atau kerugian? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jika sesiapa malu mengakui Aku dan ajaran-Ku, Putera Insan juga malu mengakui dia tatkala Dia datang kelak dengan kemuliaan-Nya sendiri, dan dengan kemuliaan Bapa-Nya serta segala malaikat suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sesungguhnya, Aku berkata kepadamu bahawa ada beberapa orang yang berdiri di sini yang tidak akan mengalami maut sebelum mereka melihat kerajaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kira-kira lapan hari setelah Isa mengatakan perkara-perkara tersebut, Dia membawa Petrus, Yahya dan Yakobus menaiki bukit untuk berdoa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Semasa Isa berdoa, wajah-Nya berubah dan pakaian-Nya menjadi putih berkilau-kilauan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tiba-tiba dua orang muncul dan bercakap dengan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mereka ialah Musa dan Ilyas yang kelihatan bersinar-sinar dengan kemuliaan dan mereka bercakap dengan Isa tentang kewafatan-Nya yang akan ditunaikan di Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus dan teman-temannya tidur lena tetapi setelah terjaga, mereka melihat kemuliaan Isa serta kedua-dua orang yang berdiri bersama-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Apabila kedua-dua orang itu hendak meninggalkan Isa, Petrus berkata kepada-Nya, ‘Tuan, betapa bahagianya kami berada di sini. Biarlah kami membuat tiga buah khemah: sebuah untuk Tuan, sebuah untuk Musa dan sebuah lagi untuk Ilyas.’ Sebenarnya, dia tidak mengetahui apa yang dikatakannya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ketika Petrus berkata demikian, suatu awan meliputi mereka dan mereka ketakutan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lalu kedengaran suara dari dalam awan itu mengatakan, ‘Inilah Putera-Ku yang Aku pilih. Dengarlah kata-kata-Nya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Setelah suara itu berhenti, Isa kelihatan seorang sahaja. Pengikut-pengikut itu berdiam diri dan tidak menceritakan kepada sesiapa jua apa yang telah disaksikan oleh mereka itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pada keesokan harinya, mereka turun dari bukit itu dan orang ramai bertemu dengan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Seorang antaranya berseru, ‘Tuan Guru, tolonglah anakku kerana dia anak tunggalku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dia dirasuk sesuatu roh lalu tiba-tiba dia berteriak dan tersentak-sentak sehingga mulutnya berbuih-buih. Roh itu mencederakannya dan tidak mahu melepaskannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aku telah memohon pengikut-pengikut Tuan supaya mengusir roh itu, tetapi mereka tidak dapat melakukannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Isa menjawab, ‘Hai angkatan yang tidak percaya dan sesat ini! Berapa lamakah harus Aku bersama kamu dan bersabar terhadap kamu? Bawalah anakmu itu ke mari.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Semasa dia datang, roh durjana itu mencampakkannya ke tanah lalu membuatnya tersentak-sentak. Tetapi Isa memarahi roh durjana itu, lalu menyembuhkan budak itu dan menyerahkannya kepada bapanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Semua orang tercengang menyaksikan keagungan Allah. Sementara semua orang masih hairan akan segala yang dibuat oleh Isa, Dia berkata kepada pengikut-pengikut-Nya, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","‘Jangan lupa akan apa yang Aku katakan kepadamu ini: Putera Insan akan diserahkan ke tangan orang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mereka tidak mengetahui maksudnya kerana tersembunyi daripada mereka supaya mereka tidak memahaminya. Mereka takut pula bertanya kepada Isa tentang perkara itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mereka bertengkar sesama sendiri tentang siapa antara mereka yang terbesar. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Isa mengetahui apa yang difikirkan mereka. Dia memanggil seorang kanak-kanak dan menyuruhnya berdiri di sisi-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Isa berkata, ‘Sesiapa yang menerima kanak-kanak ini kerana Nama-Ku menerima Aku; dan sesiapa yang menerima Aku menerima Dia yang mengutus Aku. Sesiapa yang rendah sekali hatinya antara kamu semua – dialah yang terbesar!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yahya berkata, ‘Tuan, kami telah melihat seorang yang mengusir roh-roh iblis dengan menggunakan Nama-Mu, dan kami melarang dia kerana dia tidak termasuk dalam golongan kami.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Isa berkata kepadanya, ‘Janganlah kamu larang dia. Orang yang tidak melawan kamu berpihak kepada kamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tatkala waktunya sudah dekat untuk Isa diangkat ke syurga, Dia menetapkan hati-Nya untuk menuju ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dia menyuruh beberapa utusan mendahului-Nya. Mereka pun masuk ke sebuah kampung orang Samaria untuk menyediakan tempat persinggahan bagi Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tetapi orang Samaria tidak menerima Isa kerana Dia sedang menuju ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ketika Yakobus dan Yahya, pengikut-pengikut Isa melihat perkara ini, mereka berkata, ‘Tuan, adakah Tuan mahu kami menyuruhkan api turun dari langit untuk membinasakan orang Samaria ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Isa berpaling dan memarahi mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Lalu mereka pergi ke sebuah kampung yang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ketika mereka dalam perjalanan, seorang berkata kepada Isa, ‘Aku hendak mengikut Engkau ke mana sahaja Engkau pergi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Isa berkata kepadanya, ‘Musang ada lubangnya dan burung ada sarangnya tetapi Putera Insan tiada tempat untuk meletakkan kepalanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Isa berkata kepada seorang yang lain, ‘Ikutlah Aku.’ Tetapi dia menjawab, ‘Biarlah aku pergi mengebumikan jenazah bapaku dahulu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Isa berkata kepadanya, ‘Biarlah orang mati mengebumikan orang mati mereka; tetapi engkau pergilah menyampaikan perkhabaran tentang kerajaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Seorang lain pula berkata, ‘Aku hendak mengikut Tuan, tetapi biarlah aku pergi mengucapkan selamat tinggal kepada kaum keluargaku terlebih dahulu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Isa berkata kepadanya, ‘Tiada seorang pun yang mula membajak dan asyik menoleh ke belakang layak bagi kerajaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Setelah itu Junjungan memilih tujuh puluh orang pengikut lain dan menyuruh mereka pergi berdua-dua mendahului-Nya ke setiap bandar dan tempat yang akan dikunjungi-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Dia berkata kepada mereka, ‘Hasil tuaian sungguh banyak tetapi penuai sedikit sahaja. Oleh itu, mintalah Tuan punya tuaian menyuruh lebih ramai penuai ke tempat tuaiannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pergilah kamu! Aku mengutus kamu pergi seperti anak domba ke tengah-tengah serigala. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Janganlah bawa dompet atau beg sedekah atau kasut dan jangan berhenti di jalan untuk bersalam dengan sesiapapun. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","‘Apabila kamu memasuki sesebuah rumah, kamu hendaklah terlebih dahulu mengucapkan “Sejahteralah seisi rumah ini.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jikalau orang yang tinggal di rumah itu layak menerima sejahtera, sejahteramu akan tetap padanya. Jika tidak, sejahteramu itu akan kembali kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tinggallah di rumah yang sama, dan makan serta minum apa sahaja yang dihidangkan kerana orang yang bekerja itu layak mendapat upah. Jangan berpindah dari rumah ke rumah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","‘Apabila kamu pergi ke sesebuah bandar dan kamu disambut, makanlah apa sahaja yang dihidangkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sembuhkan orang sakit yang ada di situ dan berkata kepada mereka, “Kerajaan Allah telah mendekati kamu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Apabila kamu pergi ke sesebuah bandar dan kamu tidak disambut, kamu hendaklah keluar ke jalan dan berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Debu bandarmu yang terlekat di kaki kami pun kami kebaskan sebagai bantahan terhadapmu. Tetapi ketahuilah bahawa kerajaan Allah telah mendekati kamu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aku berkata kepadamu bahawa pada hari pengadilan nanti, penduduk Sodom akan kurang sengsaranya daripada penduduk bandar itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","‘Malangnya kamu, penduduk Korazin! Malangnya kamu, penduduk Baitsaida! Jikalau mukjizat yang dilakukan di kalangan kamu dilakukan di Tirus dan Sidon, sudah lama penduduk di situ bertaubat daripada dosa mereka dengan memakai baju kabung dan menaruh abu pada kepala. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Penduduk Tirus dan Sidon akan kurang sengsaranya daripada kamu pada hari pengadilan nanti. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hai penduduk Kapernaum, adakah kamu akan ditinggikan sampai ke langit? Tidak, kamu akan dicampakkan ke dalam neraka!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","‘Sesiapa yang mendengar kata-katamu mendengar kata-kata Aku; sesiapa yang menentangmu menentang Aku; dan sesiapa yang menentang Aku juga menentang Dia yang mengutus Aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tujuh puluh orang pengikut itu kembali dengan sukacitanya dan berkata, ‘Ya Junjungan, demi nama-Mu segala roh iblis pun menurut perintah kami.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Isa berkata kepada mereka, ‘Aku melihat Iblis jatuh dari langit seperti kilat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aku telah memberimu kuasa untuk memijak ular dan kala jengking serta kuasa atas segala kekuatan musuh. Tiada apa-apa yang dapat mencederakan kamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tetapi jangan kamu bersukacita kerana segala roh iblis menurut perintahmu tetapi bersukacitalah kerana namamu tercatat di syurga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pada ketika itu, Isa bersukacita kerana dipenuhi dengan Roh Suci lalu berkata, ‘Ya Bapa yang memerintah langit dan bumi, Aku bersyukur kerana Engkau telah menunjukkan kepada orang yang seperti kanak-kanak apa yang Engkau sembunyikan daripada orang yang terpelajar dan pandai. Ya Bapa, ini dilakukan kerana sedemikianlah yang Engkau berkenan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","‘Bapa-Ku telah menyerahkan segala sesuatu kepada-Ku. Tiada sesiapa mengenal siapa Putera kecuali Bapa; dan tiada sesiapa mengenal Bapa kecuali Putera serta mereka yang dipilih oleh Putera untuk menyatakan Bapa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Isa berpaling kepada pengikut-pengikut-Nya lalu berkata secara sulit, ‘Diberkatilah mata yang melihat segala perkara yang kamu lihat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aku memberitahumu bahawa ramai nabi dan raja dahulu yang ingin melihat apa yang kamu lihat, tetapi tidak dapat melihatnya serta ingin mendengar apa yang kamu dengar, tetapi tidak dapat mendengarnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Seorang ahli Taurat datang dan cuba memerangkap Isa. Dia bertanya, ‘Tuan Guru, apakah yang patut aku buat supaya memperoleh hidup yang kekal?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Isa berkata, ‘Apakah yang tercatat dalam Taurat? Bagaimanakah kamu mentafsirnya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ahli Taurat itu menjawab, ‘ “Engkau hendaklah mengasihi Allah, Tuhanmu dengan sepenuh hatimu, dengan sepenuh jiwamu, dengan sepenuh kekuatanmu dan dengan sepenuh fikiranmu serta engkau hendaklah mengasihi sesama manusia seperti dirimu sendiri.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Isa berkata kepadanya, ‘Betullah jawapanmu. Berbuatlah demikian dan kamu akan hidup.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tetapi dia hendak membela dirinya lalu dia berkata kepada Isa, ‘Siapakah sesama manusia itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Isa menjawab, ‘Ada seorang dalam perjalanan dari Baitulmaqdis ke Yerikho. Dia diserang oleh penyamun yang merompaknya dan membelasahnya sehingga setengah mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kebetulannya, seorang imam melalui jalan itu. Apabila dia melihat si malang itu, dia menyeberangi jalan dan meneruskan perjalanannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Begitu juga seorang suku bangsa Lewi melalui tempat itu dan melihat si malang itu. Dia juga menyeberangi jalan dan meneruskan perjalanannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Akan tetapi, seorang bangsa Samaria juga lalu di tempat itu dalam perjalanannya. Dia melihat si malang itu dan hatinya dipenuhi dengan belas kasihan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dia menghampiri si malang itu lalu membersihkan luka-lukanya dengan air anggur dan minyak serta membalut luka itu. Kemudian, dia menaikkan si malang itu ke atas keldai tunggangannya dan membawanya ke rumah tumpangan untuk terus merawatinya di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pada keesokan harinya orang Samaria itu memberikan dua keping wang perak kepada tuan rumah tumpangan untuk perbelanjaan si malang itu sambil berkata, “Jagalah dia dan sekiranya wang ini tidak cukup untuknya, aku akan membayarnya apabila aku datang kembali.”’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Isa berkata, ‘Antara tiga orang itu, siapakah pada pandangan kamu menjadi sesama manusia kepada orang yang dirompak oleh penyamun?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ahli Taurat itu menjawab, ‘Orang yang menunjukkan belas kasihan kepadanya.’ Isa berkata, ‘Pergi dan berbuatlah sedemikian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Isa dan pengikut-pengikut-Nya meneruskan perjalanan dan sampai di sebuah kampung. Seorang perempuan yang bernama Marta menyambut Dia ke rumahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maryam, adik Marta, duduk sahaja untuk mendengar pengajaran Junjungan ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","tetapi Marta pula sibuk melayani mereka. Marta menghampiri Isa dan berkata, ‘Junjungan, tidakkah Junjungan peduli bahawa adikku membiarkan aku membuat semua kerja ini seorang diri? Suruhlah dia menolong aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Junjungan menjawab, ‘Marta, Marta, engkau khuatir dan bersusah payah tentang banyak perkara. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tetapi satu perkara sahaja yang diperlukan. Maryam telah memilih perkara baik itu yang tidak akan diambil daripadanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Isa berdoa di suatu tempat dan setelah Dia berhenti, salah seorang daripada pengikut-Nya berkata, ‘Junjungan, ajarlah kami berdoa seperti Yahya mengajar pengikut-pengikutnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Isa berkata kepada mereka, ‘Apabila kamu berdoa, katakanlah: ‘ “Ya Bapa, sucilah Namu-Mu; Datanglah kerajaan-Mu; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Berilah kami makanan yang secukupnya setiap hari; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ampunkanlah dosa-dosa kami, sebagaimana kami mengampuni setiap orang yang bersalah terhadap kami; janganlah biarkan kami tergoda.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Isa meneruskan kata-Nya, ‘Siapakah antara kamu yang akan pergi kepada sahabatnya pada lewat malam lalu berkata kepadanya, “Hai sahabat, pinjamilah aku tiga buku roti ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kerana seorang sahabatku telah singgah di rumahku dalam perjalanannya dan aku tiada makanan apa-apa untuk dihidangkan.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‘Sahabat itu menjawab dari dalam rumahnya, “Janganlah ganggu aku kerana pintu sudah dikunci dan kami semua telah pun masuk tidur. Aku tidak dapat bangun dan memberikan apa-apa.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Isa berkata, ‘Aku berkata kepadamu bahawa sungguhpun, dia tidak mahu bangun memberikan pinjaman itu kepadamu kerana kamu sahabatnya, tetapi dia akan bangun juga dan memberikan pinjaman seberapa banyak yang kamu perlukan kalau kamu tidak segan untuk terus meminta daripadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","‘Oleh itu, Aku berkata kepadamu: Mintalah supaya kamu akan diberi; carilah supaya kamu akan mendapat; ketuklah pintu supaya pintu akan dibuka untukmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kerana setiap orang yang meminta akan menerima; yang mencari akan mendapat; dan pintu akan dibuka kepada orang yang mengetuknya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","‘Bapa yang manakah di antara kamu akan memberikan ular kepada anaknya yang meminta ikan, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","atau memberikan kala jengking kalau dipintanya telur? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jika kamu yang jahat tahu memberikan barang yang baik kepada anak-anakmu, apatah lagi Bapamu yang di syurga akan memberikan Roh Suci kepada orang yang meminta-Nya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Isa mengusir roh iblis daripada seorang yang bisu. Setelah roh itu keluar, orang bisu itu pun mula bercakap. Orang ramai pun hairan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tetapi ada orang yang berkata, ‘Dia mengusir roh-roh iblis dengan kuasa Beelzebul, ketua semua roh iblis.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Orang lain cuba memerangkap Isa dengan meminta-Nya melakukan suatu mukjizat untuk menunjukkan Allah berkenan dengan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Isa mengetahui fikiran mereka lalu berkata kepada mereka, ‘Setiap negara yang berbelah bahagi dan bermusuhan sesama rakyatnya tidak akan tahan lama dan setiap keluarga yang bersengketa sesama sendiri akan hancur. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jikalau kerajaan Iblis berlawan-lawanan sesama sendiri, bagaimanakah kerajaannya dapat bertahan? Kamu berkata bahawa Aku mengusir roh-roh iblis dengan kuasa Beelzebul. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tetapi jikalau Aku mengusir roh-roh iblis dengan kuasa Beelzebul, maka dengan kuasa siapakah pula pengikut-pengikutmu mengusir roh-roh iblis? Maka pengikut-pengikutmu sendiri akan menghakimi kamu! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tetapi jika Aku mengusir roh-roh iblis dengan kuasa Allah, maka ini menunjukkan bahawa kerajaan Allah telah datang kepada kamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","‘Apabila seorang yang gagah dan bersenjata lengkap mengawal rumahnya, harta bendanya selamat; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","tetapi apabila seorang yang lebih gagah menyerang dan mengalahkannya, yang lebih gagah itu akan merampas segala senjata yang diperlukan oleh tuan rumah itu lalu membahagikan harta yang dirampasnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‘Orang yang tidak berpihak kepada Aku menentang Aku; dan orang yang tidak bersama Aku bercerai-berai. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","‘Apabila roh durjana keluar daripada seseorang, roh itu mengembara di tempat yang kering untuk mencari tempat berehat. Jika tempat itu tidak dapat dicari, roh itu berkata, “Aku akan pulang ke tempat kediamanku yang lama.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Roh itu kembali dan mendapati tempat kediamannya itu bersih dan kemas. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kemudian dia pergi membawa tujuh roh lain yang lebih durjana daripadanya lalu mereka tinggal di situ. Keadaan orang itu pada akhirnya lebih teruk daripada dahulu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Setelah Isa berkata demikian, seorang perempuan antara orang ramai itu berkata, ‘Diberkatilah perempuan yang melahirkan dan menyusui Engkau.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tetapi Isa berkata, ‘Bahkan lebih diberkati lagi orang yang mendengar firman Allah dan mematuhinya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Semasa orang ramai mengerumuni Isa, Dia berkata, ‘Betapa durjananya orang zaman ini! Mereka meminta mukjizat dilakukan sebagai alamat daripada Allah tetapi alamat tidak akan diberi kecuali alamat Nabi Yunus ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","kerana seperti Yunus telah menjadi alamat kepada orang Niniwe, demikian juga Putera Insan menjadi alamat kepada orang zaman ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pada hari pengadilan ratu negeri Selatan akan bangkit dan mencela mereka kerana ratu itu telah datang dari hujung bumi untuk mendengar pengajaran Sulaiman yang bijak, dan di sini ada seorang yang lebih besar daripada Sulaiman. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Orang Niniwe akan bangkit pada hari pengadilan dan mencela orang zaman ini kerana orang Niniwe itu telah bertaubat daripada dosa mereka apabila mendengar khutbah Yunus; dan di sini ada seorang yang lebih besar daripada Yunus. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","‘Tiada seorang pun yang memasang pelita lalu meletakkannya di tempat yang tersembunyi atau di bawah pasu. Sebaliknya, dia meletakkannya di atas kaki pelita supaya orang yang masuk dapat melihat cahayanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matamu ialah pelita bagi tubuhmu. Jikalau matamu terang, seluruh tubuhmu penuh dengan cahaya. Tetapi jika matamu kabur, seluruh tubuhmu pun menjadi gelap. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Oleh itu, berjaga-jagalah supaya cahaya dalammu itu tidak menjadi gelap. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jikalau seluruh tubuhmu itu terang tanpa sebarang bahagian yang gelap, seluruh tubuhmu akan terang-benderang seperti sebuah pelita menerangi kamu dengan cahayanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Setelah Isa habis bercakap, seorang Farisi menjemput Dia makan di rumahnya. Isa pun pergi lalu bertelekan di meja. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Orang Farisi itu kehairanan apabila melihat Isa tidak membasuh tangan-Nya sebelum makan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Oleh itu Junjungan berkata kepadanya, ‘Kamu orang Farisi mencuci bahagian luar pinggan mangkuk, tetapi kamu penuh dengan ketamakan dan kezaliman dalam hatimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hai orang yang bodoh! Bukankah Dia yang menjadikan bahagian luar juga menjadikan bahagian dalam? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Berikanlah makanan yang ada di dalam pinggan mangkuk itu kepada orang miskin dan segala-galanya akan menjadi bersih bagimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","‘Malangnya kamu, orang Farisi! Kamu membayar sepersepuluh daripada selasih, inggu dan herba lain kepada Allah, tetapi kamu mengabaikan keadilan dan kasih kepada Allah. Kamu haruslah membayar sepersepuluh itu tanpa mengabaikan perkara-perkara yang lebih penting. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘Malangnya kamu orang Farisi! Kamu suka duduk di kerusi khas di saumaah-saumaah dan diberi salam dengan hormatnya di pasar-pasar. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘Malangnya kamu! Kamu umpama kubur-kubur yang tidak bernisan, yang dipijak-pijak tanpa disedari oleh orang yang berjalan di atasnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Seorang daripada guru Taurat berkata kepada Isa, ‘Guru menghina kami juga apabila Guru berkata sedemikian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Isa berkata, ‘Malangnya kamu guru-guru Taurat, kerana kamu meletakkan beban yang berat ke atas bahu orang lain, tetapi kamu sendiri tidak menghulurkan satu jari pun untuk menolong mereka memikul beban itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","‘Malangnya kamu! Kamu membina makam untuk nabi-nabi yang telah dibunuh oleh nenek moyangmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Oleh itu, kamu menyetujui perbuatan nenek moyangmu itu; kerana mereka telah membunuh nabi-nabi itu tetapi kamu membina makam mereka pula. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Dengan itu, kebijaksanaan Allah telah mengatakan, “Aku mengutus nabi-nabi dan rasul-rasul kepada mereka, yang sesetengahnya akan dibunuh atau dianiayai oleh mereka.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jadi, orang zaman ini akan dihukum atas pembunuhan semua nabi sejak dunia dicipta, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","iaitu, dari pembunuhan Habil hingga pembunuhan Zekaria di antara tempat persembahan korban dengan rumah ibadat. Ya, Aku berkata kepadamu bahawa orang zaman ini akan dihukum atas pembunuhan semua nabi itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‘Malangnya kamu, ahli-ahli Taurat! Kunci ilmu telah kamu ambil; kamu sendiri tidak mahu masuk tetapi kamu menghalang orang yang cuba hendak masuk.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Setelah Isa keluar dari rumah itu, guru-guru Taurat dan orang Farisi mula mengecam Dia. Mereka menanya-Nya tentang banyak perkara, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","dan cuba memerangkap Dia dengan mencari kesalahan dalam sesuatu yang dikatakan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Oleh sebab tidak terkira ramainya orang berkerumun, mereka pijak-memijak sesama sendiri. Isa pun berkata, terutamanya kepada pengikut-pengikut-Nya, ‘Jagalah dirimu daripada ragi orang Farisi, iaitu sifat munafik. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tiada sesuatu pun yang tersembunyi yang tidak akan dinyatakan, dan tiada sesuatu rahsia pun yang tidak akan didedahkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Apa sahaja yang kamu katakan secara rahsia akan didengar secara terang-terang, dan apa sahaja yang kamu bisikkan di dalam bilik tertutup akan diumumkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","‘Aku berkata kepadamu, hai sahabat-sahabat-Ku, janganlah kamu takut akan orang yang dapat membunuh tubuh sahaja dan kemudian tidak berkuasa lagi terhadapmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aku menyatakan siapa yang harus kamu takuti: Takutlah akan Dia yang setelah mengambil nyawamu, berkuasa pula membuangmu ke dalam neraka. Aku berkata kepadamu supaya takut akan Dia! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bukankah lima ekor burung pipit dijual orang dengan harga dua syiling sahaja? Namun tiada seekor pun dilupakan oleh Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Malahan segala rambut di kepalamu telah dihitung. Janganlah kamu takut; kamu lebih bernilai daripada banyak burung pipit itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‘Aku berkata kepadamu bahawa tiap-tiap orang yang mengakui Aku di hadapan manusia akan diakui oleh Putera Insan di hadapan malaikat-malaikat Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Sesiapa yang tidak mengakui Aku di hadapan manusia tidak akan diakui oleh Putera Insan di hadapan malaikat-malaikat Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sesiapa yang mengeluarkan kata-kata menentang Putera Insan akan diampuni. Tetapi sesiapa yang mengkufuri Roh Suci tidak akan diampuni. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‘Apabila orang membawa kamu untuk didakwa di majlis saumaah atau di hadapan gabenor atau pihak berkuasa, janganlah kamu khuatir bagaimana kamu harus membela diri atau apa yang harus kamu katakan, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kerana pada waktu itu Roh Suci akan mengajar kamu apa yang harus kamu katakan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Seorang daripada orang ramai itu berkata, ‘Tuan Guru, suruh abang aku membahagikan warisan denganku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Isa menjawab, ‘Saudara, siapakah yang menjadikan Aku hakim atau pembahagi warisan kepada kamu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Isa terus menambah, ‘Ingatlah baik-baik supaya menjaga diri daripada segala ketamakan kerana kehidupan manusia tidak bergantung pada harta kekayaan yang dimiliki.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Lalu Dia pun menceritakan kepada mereka satu ibarat: ‘Seorang kaya mempunyai tanah yang mengeluarkan hasil yang banyak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Dia berfikir dalam hatinya, “Apakah harus aku buat? Tiada lagi tempat untuk menyimpan hasil tanahku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘Dia berkata, “Baiklah aku berbuat begini. Aku akan meruntuhkan gudang-gudangku dan membina yang lebih besar. Di situlah aku akan menyimpan segala hasil dan harta bendaku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aku akan berkata kepada diriku, engkau mempunyai harta yang banyak untuk keperluanmu selama bertahun-tahun. Nikmatilah hidup. Makan minum dan bersuka rialah.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","‘Tetapi Allah berfirman kepadanya, “Engkau bodoh! Pada malam ini juga, nyawamu akan dituntut kembali daripadamu. Lalu harta benda yang telah kaukumpulkan itu akan menjadi hak siapa?” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","‘Demikianlah halnya orang yang menyimpan harta benda untuk dirinya tetapi tidak kaya pada pandangan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Isa berkata kepada pengikut-pengikut-Nya: ‘Sebab itulah Aku berkata kepadamu supaya jangan khuatir tentang makanan untuk hidupmu dan pakaian untuk tubuhmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hidupmu tidak hanya bergantung pada makanan, dan tubuhmu tidak hanya bergantung pada pakaian. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Perhatikanlah burung gagak yang tidak menabur atau menuai, tidak mempunyai gudang atau rengkiang, tetapi Allah memberikan makanan kepadanya. Kamu lebih bernilai daripada burung-burung itu! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Dapatkah sesiapa antaramu memanjangkan umur sedikit pun dengan menaruh khuatir? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jikalau kamu tidak dapat membuat perkara yang sekecil ini, mengapakah kamu khuatir tentang hal-hal yang lain? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‘Perhatikanlah bunga bakung. Bunga ini tidak menenun. Tetapi Aku berkata kepadamu bahawa Sulaiman dengan segala kemuliaannya pun tidak berpakaian seindah bunga-bunga ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jikalau Allah menghiasi sedemikian rumput yang hari ini ada di padang tetapi esoknya dibakar, bukankah Dia apatah lagi akan memberikan pakaian kepada kamu! Alangkah lemahnya imanmu! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jadi, janganlah kamu utamakan makanan dan minuman serta janganlah bimbang hati. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Orang yang tidak mengenal Allah mengutamakan perkara-perkara ini, tetapi Bapamu mengetahui kamu memerlukan semua ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sebaliknya, utamakanlah kerajaan Allah dan segala perkara ini akan diberikan-Nya kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‘Janganlah takut, hai golongan kecil sahabat Aku, kerana Bapamu berkenan hendak memberikan kerajaan-Nya kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Juallah hartamu dan berikanlah wang itu kepada orang miskin. Sediakanlah bagi dirimu dompet yang tidak akan usang dan simpanlah kekayaanmu di syurga yang tidak dapat dimasuki oleh pencuri atau dirosakkan oleh gegat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kerana di mana hartamu terkumpul, di situlah hatimu tertumpu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","‘Kamu hendaklah bersiap sedia dengan pelitamu terpasang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kamu hendaklah seperti orang yang menantikan kepulangan tuan mereka dari jamuan perkahwinan. Apabila tuan mereka pulang dan mengetuk pintu, mereka akan membuka pintu itu dengan serta-merta. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Diberkatilah hamba-hamba yang didapati berjaga-jaga oleh tuan mereka ketika dia pulang. Sesungguhnya, Aku berkata kepadamu bahawa tuan itu akan menyuruh mereka bertelekan di meja dan dia sendiri akan melayani mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Diberkatilah hamba-hamba itu jikalau tuan itu pulang baik pada tengah malam ataupun sebelum fajar menyingsing dan mendapati mereka bersiap sedia. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tetapi ketahuilah kamu bahawa sekiranya tuan rumah mengetahui masa pencuri akan datang, dia tidak akan membiarkan rumahnya dipecah masuk. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Oleh itu, kamu hendaklah bersedia kerana Putera Insan akan datang pada suatu masa yang tidak kamu sangka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrus bertanya, ‘Junjungan, adakah Engkau beritahu ibarat ini kepada kami atau kepada semua orang?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Junjungan menjawab, ‘Siapakah hamba yang setia dan bijak? Dialah yang dipertanggungjawabkan oleh tuannya untuk mengurus rumahtangganya dan memberikan makanan kepada hamba-hamba yang lain pada waktunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Diberkatilah hamba yang didapati oleh tuannya sedang berbuat demikian apabila tuannya pulang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sesungguhnya, Aku berkata kepadamu bahawa tuan itu akan mempertanggungjawabkan hamba tersebut sebagai pengurus segala hartanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tetapi jikalau hamba itu berfikir dalam hatinya, “Tuan aku pulang lewat,” lalu dia mula memukul hamba-hamba yang lain baik lelaki ataupun perempuan dan makan minum sehingga mabuk, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","maka tuannya akan pulang pada hari yang tidak disangka-sangkanya serta pada waktu yang tidak diketahuinya. Tuan itu akan membuangnya dan menempatkannya bersama orang yang tidak percaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‘Seorang hamba yang mengetahui kehendak tuannya tetapi tidak bersedia serta tidak melakukannya, akan disebat dengan teruk. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tetapi hamba yang tidak mengetahui kehendak tuannya, sekalipun melakukan perkara yang patut dihukum sebat, akan dihukum dengan ringan sahaja. Kerana sesiapa yang diberikan banyak, banyak pula akan dituntut daripadanya. Semakin banyak yang diamanahkan kepada seseorang, semakin banyak pula yang akan dituntut daripadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","‘Aku datang untuk melontarkan api ke bumi dan betapa inginnya Aku api itu telah menyala! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Aku harus mengalami suatu pengimadan dan betapa resahnya hati-Ku selagi perkara itu belum selesai. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Adakah pada sangkaanmu, Aku datang untuk membawa kedamaian di dunia? Aku berkata kepadamu, bukan kedamaian melainkan perpecahan! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mulai sekarang, lima orang dalam sebuah keluarga akan berpecah, tiga melawan dua dan dua melawan tiga. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bapa melawan anak lelakinya dan anak lelaki melawan bapanya, ibu melawan anak perempuannya dan anak perempuan melawan ibunya, ibu mertua melawan menantu perempuannya serta menantu perempuan melawan ibu mertuanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Isa berkata kepada orang ramai itu, ‘Apabila kamu melihat awan naik dari barat, kamu akan berkata, “Hari mahu hujan,” dan begitulah berlakunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Apabila kamu melihat adanya angin selatan bertiup, kamu berkata, “Hari akan panas terik,” dan begitulah berlakunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hai munafik! Kamu tahu mentafsir cuaca dengan melihat alamat di langit dan bumi, tetapi mengapakah kamu tidak memahami alamat-alamat zaman ini? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‘Mengapakah kamu sendiri tidak dapat menentukan apa yang benar? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Apabila engkau berjalan menuju ke mahkamah bersama orang yang mendakwamu, berusahalah untuk menyelesaikan perkara itu dalam perjalanan agar dia tidak mengheretmu ke hadapan hakim dan hakim akan menyerahkanmu kepada pegawai polis yang akan memasukkanmu ke dalam penjara. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aku berkata kepadamu bahawa engkau tidak dapat keluar dari situ sehingga engkau membayar seluruh dendamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pada masa itu beberapa orang datang memberitahu Isa tentang orang Galilea yang dibunuh oleh Pilatus semasa mereka sedang mempersembahkan korban kepada Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Isa berkata, ‘Adakah kamu menganggap orang Galilea itu lebih berdosa daripada semua penduduk Galilea yang lain kerana mereka menderita sengsara yang sedemikian? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aku berkata kepadamu bukan begitu; tetapi jikalau kamu tidak bertaubat daripada dosamu, kamu akan binasa sedemikian juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bagaimanakah pula dengan lapan belas orang yang mati ditimpa oleh menara di Siloam? Adakah mereka lebih bersalah daripada semua penduduk lain di kota Baitulmaqdis? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aku berkata kepadamu bukan begitu; tetapi jikalau kamu tidak bertaubat, kamu semua akan binasa sedemikian juga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Isa menceritakan suatu ibarat. ‘Seorang telah menanam pokok ara di kebun buah-buahannya. Dia datang mencari buahnya, tetapi tidak dijumpai. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Dia berkata kepada tukang kebun, “Tengoklah, sudah tiga tahun aku datang mencari buah daripada pokok ara ini, tetapi tidak juga didapati. Tebangkanlah pokok ini! Apa gunanya terus menghabiskan kesuburan tanah?” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","‘Tukang kebun menjawab, “Tuan, biarkan pokok ini tumbuh setahun lagi. Aku akan mencangkul tanah di sekelilingnya dan membubuh baja. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kalau pokok ini berbuah, baiklah! Kalau tidak, tuan boleh menebangnya.”’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pada hari Sabat Isa mengajar di salah sebuah saumaah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Di situ ada seorang perempuan yang dirasuk oleh sesuatu roh yang melemahkannya selama lapan belas tahun. Belakangnya bongkok lipat dua dan dia tidak dapat berdiri tegak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Apabila Isa nampak perempuan itu, Dia memanggilnya dan berkata, ‘Sembuhlah daripada penyakitmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Lalu Isa meletakkan tangan-Nya pada perempuan itu. Seketika itu juga, dia berdiri tegak dan memuji Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tetapi ketua saumaah itu marah kerana Isa telah menyembuhkan orang pada hari Sabat. Lalu dia berkata kepada orang ramai, ‘Dalam seminggu ada enam hari yang dibenarkan untuk bekerja. Jadi, datanglah untuk disembuhkan pada salah satu hari itu dan bukannya pada hari Sabat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Junjungan menjawab, ‘Kamu munafik! Bukankah kamu masing-masing melepaskan lembu atau keldaimu dari kandang untuk dibawa pergi minum pada hari Sabat? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sekarang perempuan daripada keturunan Ibrahim ini telah dibelenggu oleh Iblis selama lapan belas tahun, tidak haruskah dia dibebaskan daripada belenggunya pada hari Sabat?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jawapan Isa memalukan semua musuh-Nya tetapi orang ramai bersukacita kerana segala perkara menakjubkan yang dilakukan oleh Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Isa berkata, ‘Bagaimanakah keadaan kerajaan Allah dan dengan apakah dapat Aku bandingkannya? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Keadaannya umpama biji sesawi yang ditanam orang di dalam kebunnya. Benih itu tumbuh dan menjadi pokok lalu burung di udara membuat sarang pada cabang-cabangnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Isa berkata lagi, ‘Dengan apakah dapat Aku bandingkan kerajaan Allah? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Keadaannya umpama ragi dicampur oleh seorang perempuan dengan tiga gantang tepung sampai seluruh adunannya naik.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Dalam perjalanan ke Baitulmaqdis, Isa melalui beberapa buah kota dan kampung sambil mengajar. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Seorang bertanya kepada-Nya, ‘Tuan, adakah segelintir sahaja yang akan diselamatkan?’ Isa menjawab, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","‘Berusahalah untuk memasuki pintu yang sempit. Aku berkata kepadamu bahawa ramai orang akan mencari jalan masuk, tetapi mereka tidak mendapatinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tuan rumah akan bangun dan menguncikan pintu ketika kamu berdiri di luar mengetuk pintu sambil berkata, “Tuan, tuan, bukalah pintu.” ‘Tetapi dia akan menjawab, “Aku tidak tahu dari mana kamu datang.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","‘Kemudian kamu akan berkata, “Kami telah makan dan minum bersama tuan, dan tuan mengajar di kota kami.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","‘Tetapi tuan itu akan berkata, “Aku tidak tahu dari mana kamu datang. Nyahlah, kamu semua yang melakukan kejahatan!” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","‘Di tempat itu akan terdapat ratapan dan kertakan gigi apabila kamu melihat Ibrahim, Ishak dan Yakub bersama semua nabi di dalam kerajaan Allah, tetapi kamu diusir keluar. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Orang akan datang dari timur dan barat, dari utara serta selatan untuk menikmati jamuan di dalam kerajaan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sesungguhnya, orang yang terakhir akan menjadi yang terdahulu, dan orang yang terdahulu akan menjadi yang terakhir.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pada masa itu beberapa orang Farisi datang kepada Isa dan berkata, ‘Pergilah dari sini ke tempat yang lain. Herodes hendak membunuh-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Isa menjawab, ‘Pergilah beritahu si musang, “Pada hari ini dan esok Aku mengusir roh-roh iblis serta menyembuhkan orang tetapi pada hari ketiga Aku akan menyelesaikan tugas-Ku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Namun, Aku harus meneruskan perjalanan pada hari ini, esok dan lusa. Seorang nabi tidak dibunuh di tempat lain kecuali di Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","‘Baitulmaqdis, Baitulmaqdis! Engkau membunuh nabi-nabi dan merejam utusan-utusan Allah. Sudah beberapa kali Aku ingin menaungi semua pendudukmu seperti seekor ibu ayam melindungi anak-anaknya di bawah kepaknya, tetapi engkau tidak mahu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sekarang rumahmu akan ditinggalkan sama sekali. Aku berkata kepadamu bahawa kamu tidak akan melihat Aku sehingga tiba masanya kamu berkata, “Diberkatilah Dia yang datang dengan nama Tuhan!” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pada hari Sabat Isa pergi makan di rumah seorang Farisi yang terkemuka. Orang terus memerhatikan Isa dengan teliti. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dan di situ seorang lelaki yang sakit busung berada di hadapan Isa ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kemudian Isa bertanya kepada ahli-ahli Taurat dan orang Farisi, ‘Adakah Taurat membenarkan orang disembuhkan pada hari Sabat atau tidak?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tetapi mereka diam sahaja. Lalu Isa memanggil orang itu dan menyembuhkannya serta menyuruhnya pulang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kemudian Isa berkata kepada mereka, ‘Jikalau lembu atau keldaimu jatuh ke dalam perigi pada hari Sabat, siapakah antara kamu yang tidak menariknya keluar dengan serta-merta pada hari Sabat itu juga?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mereka tidak dapat memberikan jawapan tentang perkara itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ketika Isa melihat bagaimana tetamu memilih tempat duduk yang terbaik di jamuan itu, Dia mengatakan suatu ibarat kepada mereka: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","‘Apabila kamu dijemput orang ke majlis perkahwinan, janganlah duduk di tempat yang terbaik. Mungkin seorang yang lebih penting daripada kamu telah dijemput, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","dan tuan rumah akan datang dan berkata kepadamu, “Berikanlah tempatmu kepada orang ini.” Lalu dengan malu sahaja kamu berpindah ke tempat yang paling belakang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Oleh itu, apabila kamu dijemput orang, pergilah duduk di tempat yang paling belakang supaya tuan rumah datang dan berkata kepadamu, “Saudara, silakanlah ke tempat yang lebih baik.” Dengan itu, kamu mendapat penghormatan di hadapan semua orang jemputan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sesiapa yang memuliakan dirinya akan direndahkan dan yang merendahkan dirinya akan dimuliakan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kemudian Isa berkata kepada tuan rumah, ‘Apabila mengadakan suatu majlis makan tengah hari atau malam, janganlah jemput sahabat-sahabatmu atau adik-beradikmu atau sanak-saudaramu atau jiran tetanggamu yang kaya kerana mereka akan menjemputmu pula dan itulah sahaja balasan atas perbuatanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Apabila mengadakan suatu jamuan, jemputlah orang miskin, orang kudung, orang tempang dan orang buta. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Diberkatilah kamu kelak kerana mereka tidak dapat membalas jemputanmu, tetapi kamu akan dianugerahi Allah pada hari kebangkitan orang yang benar daripada kematian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Salah seorang jemputan itu mendengar kata-kata Isa lalu berkata, ‘Diberkatilah orang yang akan dijamu di dalam kerajaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Isa berkata kepadanya: ‘Ada seorang yang mengadakan jamuan besar dan dia menjemput ramai orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Apabila tiba masanya, dia menyuruh hambanya pergi memberitahu para jemputannya, “Silakanlah, kerana semuanya siap sedia.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","‘Tetapi masing-masing mula berdalih. Yang pertama berkata, “Aku telah membeli sebuah ladang dan aku harus pergi ke sana. Aku minta maaf.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","‘Seorang yang lain berkata, “Aku telah membeli lima pasang lembu dan harus pergi mencuba lembu-lembu itu. Aku minta maaf.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","‘Seorang yang lain lagi berkata, “Aku baru berkahwin. Oleh itu, aku tidak dapat datang.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","‘Hamba itu pulang dan memberitahu tuannya hal ini. Tuan rumah itu sangat marah dan menyuruh hambanya, “Pergilah dengan segera ke jalan-jalan dan lorong-lorong kota dan bawalah orang miskin, orang kudung, orang buta dan orang tempang ke mari.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","‘Hamba itu berkata, “Tuan, apa yang tuan suruh telah dilakukan tetapi masih ada tempat lagi.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","‘Tuan rumah berkata kepada hambanya, “Pergilah ke jalan-jalan raya dan lorong-lorong di luar kota serta suruh orang datang supaya rumahku penuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aku berkata kepadamu bahawa tiada seorang pun antara mereka yang telah dijemput itu, akan menikmati jamuanku ini.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Orang ramai sedang mengiringi Isa apabila Dia berpaling dan berkata kepada mereka: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","‘Jikalau seseorang datang kepada-Ku dan dia lebih mengasihi ibu bapanya, isterinya, anak-anaknya, adik-beradiknya dan dirinya, dia tidak boleh menjadi pengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sesiapa yang tidak memikul salibnya dan mengikut-Ku tidak boleh menjadi pengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","‘Jikalau seseorang antara kamu ingin membina sebuah menara, dia akan terlebih dahulu duduk dan menganggarkan perbelanjaannya untuk memastikan sama ada dia mempunyai wang yang cukup untuk menyiapkan pembinaan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jikalau dia sudah meletakkan asas menara itu, tetapi tidak dapat menyiapkan pembinaannya, semua orang yang melihat hal itu akan mengejeknya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Orang ini telah memulakan pembinaan itu, tetapi tidak dapat pula menyiapkannya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","‘Jikalau seorang raja yang mempunyai sepuluh ribu orang askar hendak keluar berperang dengan raja lain yang membawa dua puluh ribu orang askar untuk menyerangnya, dia akan mempertimbangkan dahulu sama ada dia cukup kuat untuk menentang raja tersebut. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kalau dia tidak dapat berbuat demikian, dia akan memerintah utusan-utusannya untuk bertanyakan syarat-syarat perdamaian semasa musuhnya masih jauh lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Begitu juga sesiapa antara kamu yang tidak meninggalkan segala miliknya, tidak boleh menjadi pengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‘Garam itu baik tetapi jikalau menjadi tawar, bagaimanakah garam itu dapat dimasinkan semula? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Garam itu tidak berguna untuk menyuburkan tanah atau dijadikan baja kecuali dibuang sahaja. Orang yang bertelinga, dengarlah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pada suatu hari semua pemungut cukai dan orang yang berdosa datang mendengar Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Orang Farisi dan guru-guru Taurat bersungut-sungut, ‘Orang ini menyambut orang berdosa dan makan bersama mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Isa pun mengatakan ibarat ini kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","‘Jikalau seorang antara kamu mempunyai seratus ekor domba lalu kehilangan seekor, apakah yang akan dilakukannya? Dia akan meninggalkan sembilan puluh sembilan ekor domba di padang lalu pergi mencari domba yang hilang itu sehingga ditemukannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Setelah dia menemukannya, dia memikul domba itu di atas bahunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Setibanya di rumah, dia memanggil sahabat-sahabat dan jiran tetangganya lalu berkata, “Bergembiralah dengan aku kerana aku telah menemukan domba aku yang hilang itu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aku berkata kepadamu bahawa begitu jugalah kegembiraan di syurga kerana seorang yang berdosa bertaubat lebih daripada kegembiraan ke atas sembilan puluh sembilan orang yang benar yang tidak perlu bertaubat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","‘Atau seandainya seorang perempuan yang mempunyai sepuluh keping wang perak kehilangan sekeping, apakah yang akan dilakukannya? Dia akan memasang pelita lalu menyapu rumah dan mencari dengan cermat sehingga dia menemukannya kembali. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Setelah itu, dia memanggil sahabat-sahabat dan jiran tetangganya dan berkata, “Bergembiralah dengan aku kerana aku telah menemukan sekeping wang yang hilang itu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Aku berkata kepadamu bahawa malaikat-malaikat Allah bergembira kerana seorang yang berdosa bertaubat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Isa berkata seterusnya: ‘Ada seorang yang mempunyai dua orang anak lelaki. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Anak bongsu berkata kepada bapanya, “Ayah, berilah aku sekarang bahagian harta yang akan menjadi pusakaku.” Lalu bapa itu membahagikan hartanya kepada kedua-dua anaknya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","‘Tidak lama kemudian, yang bongsu itu menjual hartanya dan merantau ke negeri yang jauh. Di situ dia memboroskan wangnya dengan hidup berfoya-foya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Setelah dia menghabiskan kesemua wangnya, suatu kebuluran yang teruk berlaku di negeri itu dan dia dalam keadaan serba kekurangan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dia pergi bekerja dengan seorang penduduk negeri itu dan disuruh menjaga babi di ladangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Dia ingin mengisi perutnya dengan sekam kacang yang dimakan oleh babi tetapi tiada seorang pun yang memberikan apa-apa kepadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","‘Akhirnya, dia sedar dan berkata, “Semua orang gaji bapaku dapat makan sehingga kenyang, tetapi aku ini hampir mati kelaparan! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aku hendak kembali kepada bapaku, dan aku akan berkata kepadanya: Ayah, aku telah berbuat dosa kepada Allah dan kepada ayah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aku tidak layak disebut sebagai anak ayah. Jadikanlah aku ini sebagai salah seorang gaji ayah.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Dia pun kembali kepada bapanya. ‘Semasa dia masih jauh lagi, bapanya nampak dia. Hatinya penuh dengan belas kasihan dan dia berlari menemuinya. Bapanya memeluk dan menciumnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Anak itu berkata kepada bapanya, “Ayah, aku telah berbuat dosa kepada Allah dan kepada ayah. Aku tidak layak disebut anak ayah.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","‘Bapa itu menyuruh hamba-hambanya, “Segeralah ambil pakaian yang terbaik dan pakaikanlah kepada anakku. Sarungkan sebentuk cincin di jarinya dan pakaikan kasut pada kakinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pilihlah dan sembelilah anak lembu yang tambun, dan marilah kita mengadakan jamuan dan bersuka ria; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kerana anakku ini telah mati dan hidup kembali; dia telah sesat dan ditemui kembali.” Lalu mereka mula bersuka ria. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‘Pada masa itu anak sulung bekerja di ladang. Apabila dia pulang ke rumah, dia terdengar bunyi muzik dan orang menari-nari. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dia memanggil seorang hamba lalu bertanya, “Apakah yang sedang berlaku ini?” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hamba itu menjawab, “Adik tuan telah pulang dan bapa tuan telah menyembelih anak lembu yang tambun kerana adik tuan pulang dengan selamatnya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","‘Anak sulung itu sangat marah sehingga dia tidak mahu masuk ke dalam rumah. Ayahnya keluar lalu memujuk dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Anak sulung itu berkata, “Tengoklah, bertahun-tahun aku bekerja untuk ayah. Aku tidak pernah melanggar perintah ayah. Tetapi ayah tidak pernah memberikan seekor anak kambing pun kepada aku supaya aku dapat bersuka ria dengan sahabat-sahabatku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Namun sepulangnya anak ayah ini yang telah memboroskan harta ayah dengan perempuan-perempuan sundal, ayah menyembelih anak lembu yang tambun untuknya!” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Bapa itu berkata kepadanya, “Anakku, engkau ini sentiasa bersama ayah, dan segala milik ayah ialah milikmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kita patut bersuka ria kerana adikmu ini telah mati dan hidup kembali; dia telah sesat dan ditemui kembali.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Isa berkata kepada pengikut-pengikut-Nya: ‘Seorang kaya mempunyai seorang pengurus untuk harta bendanya. Dia diberitahu bahawa pengurus itu memboroskan wang tuannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tuan itu memanggil pengurus itu lalu berkata, “Apakah yang telah kudengar tentangmu? Serahkanlah kira-kira yang lengkap bagi semua hartaku kerana kamu tidak boleh menjadi pengurus lagi.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","‘Pengurus itu berkata kepada dirinya, “Apakah harus aku buat? Aku tidak kuat untuk mencangkul dan aku malu meminta sedekah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aku tahu apa yang harus aku buat supaya apabila aku dipecat nanti daripada jawatan pengurus itu, aku ada ramai sahabat yang akan menerimaku ke rumah mereka.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","‘Dia pun memanggil semua orang yang berhutang kepada tuannya. Dia berkata kepada orang yang pertama, “Berapakah hutangmu kepada tuan aku?” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Orang itu menjawab, “Seratus tong minyak zaitun.” Pengurus itu berkata, “Inilah kira-kiramu. Duduk dan tulislah lima puluh.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","‘Dia berkata kepada seorang yang lain, “Berapakah hutangmu pula?” ‘Orang itu menjawab, “Seratus pikul gandum.” ‘Pengurus itu berkata, “Inilah kira-kiramu. Tulislah lapan puluh.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","‘Tuan itu memuji pengurus yang tidak jujur itu kerana perbuatannya yang cerdik. Orang duniawi lebih cerdik menguruskan pekerjaan mereka daripada orang yang hidup dalam nur. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aku berkata kepadamu supaya menggunakan kekayaan dunia untuk mendapat sahabat bagi dirimu. Apabila kekayaanmu lenyap, kamu akan disambut ke tempat kediaman yang kekal. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","‘Orang yang setia dalam perkara yang kecil akan setia juga dalam perkara yang besar; dan orang yang tidak setia dalam perkara yang kecil tidak akan setia dalam perkara yang besar. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Oleh itu, jikalau kamu tidak setia dalam kekayaan dunia ini, siapakah yang akan mengamanahkan kekayaan yang sejati kepadamu? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Dan jikalau kamu tidak setia dengan milik orang lain, siapakah pula yang akan memberimu apa yang menjadi milik kamu sendiri? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‘Tiada seorang hamba yang dapat menghambakan diri kepada dua orang tuan. Dia akan membenci seorang dan mengasihi seorang lagi ataupun dia akan taat kepada seorang dan menghina seorang lagi. Kamu tidak dapat bekerja untuk Allah dan untuk kekayaan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Orang Farisi yang mendengar kata-kata Isa mengejek-Nya kerana mereka loba akan wang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Isa berkata kepada mereka, ‘Kamulah orang yang berpura-pura bertakwa di hadapan khalayak ramai, tetapi Allah mengetahui isi hatimu. Apa yang dianggap berharga oleh manusia tidak ada nilainya di sisi Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","‘Sebenarnya, hukum Taurat dan kitab segala nabi berkuatkuasa sehingga zaman Yahya. Semenjak itu, perkhabaran baik tentang kerajaan Allah diberitakan, dan orang berasak-asak hendak memasukinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tetapi lebih mudah lenyapnya langit dan bumi daripada hilangnya sepatah kata pun hukum Taurat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","‘Sesiapa yang menceraikan isterinya dan berkahwin dengan perempuan lain, berzina. Begitu juga dengan lelaki yang berkahwin dengan seorang perempuan yang telah diceraikan oleh suaminya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","‘Ada seorang kaya yang berpakaian mahal-mahal dan hidup dalam kemewahan setiap hari. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ada pula seorang peminta sedekah bernama Lazarus yang penuh dengan pekung. Dia selalu dibawa ke muka pintu rumah orang kaya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Dia ingin mendapat sisa-sisa makanan yang dibuang dari meja orang kaya itu. Anjing pula datang menjilat pekung-pekungnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","‘Peminta sedekah itu mati dan malaikat-malaikat membawanya ke sisi Ibrahim di syurga. Orang kaya itu pun mati lalu dikebumikan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Dia menderita di alam maut. Apabila dia memandang ke atas, dia nampak Ibrahim jauh di sana dan Lazarus di sisinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Dia berseru, “Bapa Ibrahim, kasihanilah aku dan suruh Lazarus datang mencelupkan jarinya di dalam air untuk menyejukkan lidahku kerana aku sengsara di dalam nyala api ini.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‘Tetapi Ibrahim berkata, “Anakku, ingatlah bahawa engkau telah menikmati kesenangan pada masa hidupmu, tetapi Lazarus mengalami kesengsaraan. Sekarang Lazarus senang di sini tetapi engkau menderita. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Selain itu, terdapat satu jurang yang dalam di antara kami dengan kamu supaya orang yang hendak menyeberang dari sini kepada kamu tidak dapat berbuat demikian, dan orang dari sana tidak dapat menyeberang kepada kami.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","‘Orang kaya itu berkata, “Jikalau begitu, aku memohon, ya bapa, suruh Lazarus ke rumah ayahku ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kerana aku mempunyai lima adik-beradik lelaki. Biarlah Lazarus pergi memberikan amaran kepada mereka supaya mereka tidak datang ke tempat sengsara ini.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","‘Ibrahim berkata, “Mereka ada kitab Musa dan nabi-nabi. Biarlah mereka mendengar pengajaran itu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Orang kaya itu berkata, “Itu tidak cukup, Bapa Ibrahim. Jikalau seorang antara orang mati pergi kepada mereka, tentu mereka akan bertaubat daripada dosa-dosa mereka.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‘Tetapi Ibrahim berkata, “Jikalau mereka tidak mahu mendengar pengajaran kitab Musa dan nabi-nabi, mereka tidak akan percaya sekalipun seorang bangkit daripada kematian.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Isa berkata kepada pengikut-pengikut-Nya: ‘Hal yang membuat orang melakukan dosa memang ada, tetapi malangnya bagi orang yang menyebabkan hal-hal itu berlaku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Lebih baik bagi dia jikalau sebuah batu kisar diikat pada lehernya dan dia dibuang ke dalam laut, daripada dia menyebabkan salah seorang yang lemah melakukan dosa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Berwaspadalah! ‘Jikalau saudaramu telah berbuat salah terhadapmu, tegurlah dia dan jikalau dia bertaubat, ampunilah dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Jikalau dia bersalah sebanyak tujuh kali terhadapmu dalam sehari dan setiap kali dia datang kepadamu serta berkata, “Aku bertaubat,” kamu hendaklah mengampuninya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Rasul-rasul itu berkata kepada Junjungan, ‘Kuatkanlah iman kami.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Junjungan menjawab, ‘Jikalau kamu mempunyai iman sebesar biji sawi, kamu akan dapat berkata kepada pokok ara ini, “Tercabutlah akar-akarmu dan tertanamlah kamu di laut,” dan pokok ara akan menurut perintahmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","‘Jikalau salah seorang kamu mempunyai hamba yang membajak atau menggembalakan domba, siapakah antara kamu akan berkata kepadanya sewaktu dia pulang dari ladang, “Mari, lekas duduk makan?” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bukankah kamu akan berkata kepadanya, “Hidangkan makanan dan bersedia untuk melayaniku semasa aku makan. Selepas itu, barulah kamu makan”? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Adakah kamu mengucapkan terima kasih kepada hamba itu kerana dia menurut perintah? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Begitu juga dengan kamu. Apabila kamu telah berbuat segala yang diperintahkan kepadamu, kamu hendaklah berkata, “Kami ini hamba yang tidak layak menerima apa-apa; kami cuma menjalankan kewajipan kami.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dalam perjalanan Isa ke Baitulmaqdis, Dia melalui sempadan Samaria dan Galilea. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Apabila Dia memasuki sebuah kampung, sepuluh orang berpenyakit kusta datang bertemu dengan-Nya. Mereka berdiri jauh sedikit daripada Isa ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dan berseru kepada-Nya, ‘Ya Isa, ya Junjungan, kasihanilah kami!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Apabila Isa melihat mereka, Dia berkata kepada mereka, ‘Pergilah dan tunjukkan dirimu kepada imam-imam.’ Dalam perjalanan, mereka pun sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Salah seorang daripada mereka ketika melihat dirinya sembuh, kembali dan memuji Allah dengan suara yang kuat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Dia sujud pada kaki Isa dan mengucapkan terima kasih. Dia seorang Samaria. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Isa bertanya, ‘Sepuluh orang disembuhkan. Di manakah sembilan orang lagi? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tiadakah seorang pun didapati kembali untuk bersyukur kepada Allah kecuali orang bangsa asing ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Isa pun berkata kepadanya, ‘Bangunlah dan pergi. Imanmu telah menyembuhkan kamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Terdapat beberapa orang Farisi bertanya kepada Isa bila kerajaan Allah akan datang dan Isa menjawab, ‘Kerajaan Allah tidak datang dengan alamat-alamat yang dapat dilihat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tiada orang akan berkata, “Lihatlah di sini!” atau “Lihatlah di sana!” kerana kerajaan Allah sebenarnya ada di dalam kamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kemudian Isa berkata kepada pengikut-pengikut-Nya: ‘Masanya akan datang apabila kamu ingin melihat salah satu hari Putera Insan, tetapi kamu tidak dapat melihatnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Orang akan berkata kepadamu, “Lihat di situ!” atau “Lihat di sini!” Tetapi janganlah kamu pergi atau mengikutnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Seperti kilat memancar dari sebelah kaki langit ke sebelah yang lain, demikianlah juga halnya Putera Insan pada hari-Nya kelak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tetapi terlebih dahulu Dia akan mengalami banyak penderitaan dan Dia tidak akan diterima oleh orang zaman ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","‘Sebagaimana yang berlaku pada zaman Nuh, demikian juga akan berlaku pada zaman Putera Insan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mereka makan dan minum. Lelaki dan perempuan berkahwin sampai ke hari Nuh masuk ke dalam bahtera. Lalu air bah melanda dan membinasakan mereka semua. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","‘Demikian juga yang berlaku pada zaman Lut. Mereka makan dan minum, berjual beli, bercucuk tanam dan mendirikan rumah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pada hari Lut keluar dari Sodom, api dan belerang turun dari langit dan membinasakan mereka semua. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","‘Begitulah keadaannya kelak pada hari Putera Insan menunjukkan diri-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pada hari itu jikalau seseorang ada di atas bumbung rumah, janganlah dia turun untuk mengambil barang di dalam rumah. Demikian juga janganlah orang yang ada di ladang kembali ke rumahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ingatlah akan isteri Lut! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sesiapa yang cuba memelihara nyawanya akan kehilangannya, tetapi sesiapa yang sanggup mengorbankan nyawanya akan menyelamatkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Aku berkata kepadamu bahawa pada malam itu dua orang berbaring di atas sebuah katil. Seorang akan dibawa dan seorang lagi akan ditinggalkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dua orang perempuan bersama-sama mengisar gandum. Seorang akan dibawa dan seorang lagi ditinggalkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dua orang lelaki bekerja di ladang. Seorang akan dibawa dan seorang lagi ditinggalkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mereka bertanya kepada Isa, ‘Di manakah, ya Junjungan?’ Isa menjawab, ‘Di mana ada bangkai, di situ juga ada burung nasar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kemudian Isa menceritakan ibarat ini untuk mengajar mereka bahawa mereka harus sentiasa berdoa dan tidak putus asa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Isa berkata, ‘Di dalam sebuah kota ada seorang hakim yang tidak takut akan Allah atau mempedulikan sesiapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Di kota itu juga ada seorang balu yang kerapkali datang kepada hakim itu untuk menuntut keadilan terhadap lawannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","‘Sekian lama hakim itu menolak tuntutannya, tetapi akhirnya dia berkata dalam hatinya, ‘Walaupun aku tidak takut akan Allah dan tidak pedulikan sesiapapun, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tetapi disebabkan balu ini terus mengganggu aku, biarlah aku mengadili tuntutannya. Jika tidak, dia akan terus-menerus datang dan mengganggu aku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Junjungan menambah, ‘Dengarlah apa yang dikatakan oleh hakim yang tidak adil itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tidakkah Allah akan membela umat-Nya yang berseru kepada-Nya siang dan malam? Adakah Dia akan bertangguh untuk melaksanakan keadilan bagi mereka? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aku berkata kepadamu bahawa Allah akan melaksanakan keadilan bagi mereka dengan segera. Tetapi, apabila Putera Insan datang, adakah Dia akan menjumpai iman di bumi ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Isa juga menceritakan ibarat ini kepada orang yang menganggap diri mereka sebagai orang yang benar dan menghina orang lain: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","‘Dua orang masuk ke dalam rumah ibadat untuk berdoa. Seorang daripadanya orang Farisi dan seorang lagi pemungut cukai. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Orang Farisi itu berdiri dan berdoa dalam hatinya: “Ya Allah, aku mengucap syukur kepada-Mu kerana aku tidak tamak, menipu atau tidak bermoral seperti orang lain. Aku bersyukur kepada-Mu kerana aku tidak seperti pemungut cukai ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aku berpuasa dua kali seminggu dan mempersembahkan sepersepuluh daripada semua pendapatanku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","‘Akan tetapi, pemungut cukai itu berdiri jauh sedikit, tidak berani menengadah ke langit melainkan menebah dada sambil berkata, “Ya Allah, kasihanilah hamba, orang berdosa ini.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","‘Aku berkata kepadamu bahawa pemungut cukai ini pulang ke rumahnya dengan diperkenankan Allah tetapi orang Farisi itu tidak. Sesiapa yang meninggikan dirinya akan direndahkan, dan sesiapa yang merendahkan dirinya akan ditinggikan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Orang membawa anak mereka kepada Isa supaya Dia memberkati mereka. Tetapi apabila pengikut-pengikut Isa melihat hal ini, mereka menegur orang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Namun Isa memanggil anak-anak itu datang kepada-Nya lalu Dia berkata, ‘Biarlah anak-anak ini datang kepada-Ku. Janganlah melarang mereka kerana kerajaan Allah menjadi milik orang yang sedemikian. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sesungguhnya, Aku berkata kepadamu bahawa sesiapa yang tidak menyambut kerajaan Allah seperti seorang anak menerimanya, tidak dapat masuk ke dalam kerajaan itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Seorang pemimpin bangsa Yahudi bertanya kepada Isa, ‘Ya Guru yang baik, apakah harus aku buat untuk beroleh hidup yang kekal?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Isa menjawab, ‘Mengapakah engkau mengatakan Aku ini baik? Tiada sesiapapun yang baik kecuali Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Engkau mengetahui hukum-hukum Allah, iaitu: “Jangan berzina, jangan membunuh, jangan mencuri, jangan berdusta, hormati bapa dan ibumu.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Pemimpin itu berkata, ‘Semua ini telah kuturuti sejak kecil.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Apabila Isa mendengar ini, Dia berkata kepadanya, ‘Satu perkara sahaja yang perlu kaulakukan. Juallah segala hartamu dan dermakan wangnya kepada orang miskin. Engkau akan beroleh harta di syurga. Kemudian, ikutlah Aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tetapi apabila pemimpin itu mendengar demikian, dia menjadi sangat sedih kerana dia seorang yang amat kaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Isa nampak kesedihannya lalu berkata, ‘Alangkah sukar bagi orang kaya masuk ke dalam kerajaan Allah! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Lebih mudah seekor unta masuk ke lubang jarum daripada seorang kaya masuk ke dalam kerajaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Orang yang mendengar-Nya berkata, ‘Kalau begitu, siapakah yang dapat diselamatkan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Isa menjawab, ‘Apa yang mustahil bagi manusia itu tidak mustahil bagi Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petrus berkata, ‘Kami telah meninggalkan rumah untuk mengikut-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Isa berkata kepada mereka, ‘Sesungguhnya, Aku berkata kepadamu bahawa sesiapa sahaja yang telah meninggalkan rumah, atau isteri, atau adik-beradik, atau ibu bapa, atau anak-anak demi kerajaan Allah ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","akan menerima ganjaran berkali-kali gandanya pada masa ini dan hidup yang kekal di akhirat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Isa membawa dua belas pengikut-Nya ke suatu tempat dan berkata kepada mereka, ‘Kita akan pergi ke Baitulmaqdis dan segala yang tersurat dalam kitab-kitab nabi tentang Putera Insan akan berlaku di sana. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dia akan diserahkan ke tangan bangsa asing. Dia akan dicela dan dimaki serta diludahi orang. Mereka akan menyebat Dia dan membunuh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pada hari yang ketiga Dia akan bangkit semula.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tetapi pengikut-pengikut-Nya tidak mengerti sepatah kata pun. Maksud kata-kata ini dirahsiakan daripada mereka. Mereka tidak memahami apa yang dikatakan oleh Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ketika Isa menghampiri kota Yerikho, ada seorang buta yang duduk di tepi jalan meminta sedekah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Apabila dia mendengar bunyi orang ramai lalu, dia bertanya, ‘Apakah yang sedang berlaku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Orang memberitahu dia bahawa Isa, orang Nasaret, sedang lalu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dia pun berseru, ‘Isa, Anak Daud, kasihanilah aku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Orang yang di hadapannya memarahinya dan menyuruh dia diam, tetapi dia berseru dengan lebih kuat, ‘Ya Anak Daud, kasihanilah aku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Isa berhenti dan menyuruh orang membawa dia kepada-Nya. Apabila dia mendekati Isa, Isa bertanya, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","‘Apakah yang engkau hendak Aku buat bagimu?’ Dia berkata, ‘Junjungan, aku mahu melihat kembali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Isa berkata kepadanya, ‘Terimalah penglihatanmu kembali, imanmu telah menyembuhkanmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Seketika itu juga, dia dapat melihat lalu dia mengikut Isa sambil memuji Allah. Semua orang yang menyaksikan kejadian ini memuji Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isa meneruskan perjalanan ke Yerikho dan melalui kota itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Di situ ada seorang yang bernama Zakheus. Dia ketua pemungut cukai dan sangat kaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Dia cuba hendak melihat siapa Isa itu, tetapi tidak dapat berbuat demikian kerana orang terlalu ramai dan dia pendek orangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Dia pun berlari mendahului mereka lalu memanjat pokok ara untuk melihat Isa yang akan melalui jalan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Apabila Isa sampai ke tempat itu, Dia mendongak ke atas lalu berkata kepadanya, ‘Zakheus, turunlah dengan segera kerana pada hari ini Aku harus menumpang di rumahmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakheus turun dengan segera dan menyambut Isa dengan sukacitanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Semua orang yang melihat hal ini bersungut-sungut, ‘Dia hendak menumpang di rumah orang yang berdosa pula!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tetapi Zakheus berdiri dan berkata kepada Junjungan, ‘Tuan, sekarang ini juga aku hendak memberikan separuh hartaku kepada orang miskin, dan jikalau aku telah menipu sesiapa, aku akan membayarnya kembali empat kali ganda.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Isa berkata kepadanya, ‘Pada hari ini juga penyelamatan telah datang kepada seluruh keluarga kamu kerana kamu juga seorang keturunan Ibrahim. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Putera Insan datang untuk mencari dan menyelamatkan orang yang sesat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Isa menceritakan sebuah ibarat kepada mereka yang mendengar-Nya. Dia kini telah hampir tiba ke Baitulmaqdis dan mereka menyangka bahawa kerajaan Allah akan menjadi nyata tidak lama lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jadi, Isa berkata: ‘Seorang bangsawan telah berangkat ke negeri jauh untuk dilantik menjadi raja dan akan kembali. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Terlebih dahulu dia memanggil sepuluh orang hambanya, lalu memberi masing-masing sekeping wang emas dan berkata kepada mereka, “Uruskanlah wang ini sehingga aku pulang.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","‘Tetapi rakyat negeri itu membencinya dan menyuruh utusan-utusan untuk memberitahunya, “Kami tidak mahu orang ini menjadi raja kami.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","‘Setelah dia menjadi raja, dia kembali dan memerintah hamba-hamba yang telah diberi wang emas datang menghadapnya dengan segera. Dia ingin mengetahui jumlah keuntungan dalam perniagaan masing-masing. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","‘Yang pertama menghadap dan berkata, “Tuan, sekeping wang emas tuan itu telah menjadi sepuluh kali lebih banyak.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Tuan itu berkata kepadanya, “Bagus sekali, hamba yang baik. Oleh sebab engkau telah setia dalam perkara kecil ini, aku akan menjadikan engkau penguasa sepuluh buah kota.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","‘Yang kedua menghadap dan berkata, “Tuan, sekeping wang emas tuan itu telah menjadi lima kali lebih banyak.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Tuan itu berkata kepadanya, “Engkau akan menjadi penguasa lima buah kota.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","‘Seorang hamba lagi menghadap dan berkata, “Tuan inilah wang emas tuan yang telah aku simpan di dalam sehelai kain. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aku takut akan tuan kerana tuan seorang yang keras hati. Tuan mengambil apa yang bukan milik tuan, dan menuai apa yang tidak tuan taburkan.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Tuan itu berkata, “Hamba yang tidak berguna! Aku akan menghukum engkau mengikut kata-katamu sendiri. Engkau mengetahui aku ini seorang yang keras hati, mengambil barang yang bukan milikku dan menuai apa yang tidak aku taburkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Jadi, mengapakah engkau tidak memasukkan wang itu ke dalam tabung? Kemudian, setelah aku kembali, dapatlah aku ambil wang itu dengan faedahnya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","‘Lalu tuan itu berkata kepada orang yang berdiri di situ, “Ambillah keping wang itu daripadanya dan berikannya kepada orang yang ada sepuluh keping wang emas itu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Mereka pun berkata kepadanya, “Tuan, dia sudah ada sepuluh keping.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Tuan itu berkata, “Orang yang sedia ada akan diberi lebih banyak, dan orang yang tidak mempunyai sesuatu akan diambil barang yang ada padanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Sekarang, bawalah ke mari seteru-seteruku yang tidak mahu aku menjadi raja mereka. Bunuhlah mereka di hadapanku.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Setelah Isa berkata demikian, Dia pun berjalan mendahului mereka menuju ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Apabila Dia mendekati Baitfagi dan Baitani di Bukit Zaitun, Dia menyuruh dua orang pengikut-Nya dengan berkata kepada mereka, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","‘Pergilah ke kampung di hadapan itu. Apabila kamu masuk ke kampung itu, kamu akan mendapati seekor anak keldai yang tertambat. Anak keldai itu belum pernah ditunggangi orang. Lepaskan keldai itu dan bawa ke mari. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jikalau ada orang bertanya kepadamu, “Mengapakah kamu melepaskan keldai?” kamu hendaklah berkata kepadanya, “Junjungan memerlukannya.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kedua-dua pengikut itu pun pergi dan mendapati sebagaimana yang telah dikatakan Isa kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ketika mereka melepaskan anak keldai itu, tuan anak keldai itu berkata kepada mereka, ‘Mengapakah kamu melepaskan anak keldai ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pengikut-pengikut itu menjawab, ‘Junjungan memerlukannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lalu mereka membawanya kepada Isa. Kemudian, mereka menghamparkan jubah mereka di atas anak keldai itu dan menolong Isa naik ke atasnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ketika Isa menunggang keldai itu, orang ramai pun membentangkan jubah mereka di jalan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Apabila Dia menghampiri jalan yang turun dari Bukit Zaitun, semua pengikut-Nya mula bersukacita dan memuji Allah dengan suara yang kuat kerana semua mukjizat yang telah disaksikan oleh mereka: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","‘Diberkatilah Raja yang datang dengan nama Tuhan!’ ‘Kesejahteraan di syurga dan kemuliaan di tempat yang maha tinggi!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Antara orang ramai itu ada beberapa orang Farisi yang berkata kepada Isa, ‘Tuan Guru, suruh pengikut-pengikut-Mu diam.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Isa menjawab, ‘Aku berkata kepadamu bahawa jikalau mereka diam, batu-batu pula akan bersorak.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ketika Isa menghampiri Baitulmaqdis dan melihat kota itu, Dia pun menangisinya, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","lalu berkata, ‘Kalaulah kiranya pada hari ini engkau mengetahui perkara-perkara yang dapat membawa sejahtera kepadamu! Tetapi sekarang semuanya dirahsiakan daripadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Masanya akan datang apabila musuh-musuhmu akan mengelilingimu dengan sekatan, mengepung dan mengasakmu dari semua arah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mereka akan membinasakanmu dan semua pendudukmu. Mereka tidak akan meninggalkan seketul batu pun di tempatnya kerana kamu tidak mengetahui masanya Allah datang kepadamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Isa masuk ke dalam rumah ibadat lalu mengusir semua pedagang di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Dia berkata kepada mereka, ‘Telah tersurat, “Rumah-Ku akan dipanggil rumah doa”; tetapi kamu telah menjadikannya “sarang pencuri.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Setiap hari Isa mengajar di dalam rumah ibadat. Ketua-ketua imam, guru-guru Taurat dan para pemimpin mereka mencari jalan untuk membunuh-Nya ");
INSERT INTO zlmKSZI_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","tetapi mereka tidak dapat berbuat demikian kerana orang ramai terus-menerus datang mendengar Isa dan mereka tidak mahu terlepas sepatah kata Isa pun. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pada suatu hari ketika Isa mengajar orang ramai di dalam rumah ibadat dan memberitakan perkhabaran yang baik, ketua-ketua imam, guru-guru Taurat dan para tua-tua datang kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mereka berkata kepada-Nya, ‘Katakanlah kepada kami atas kuasa siapakah Engkau laksanakan segala perkara ini. Siapakah yang memberikan kuasa ini kepada-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Isa menjawab, ‘Aku juga hendak bertanya kepadamu suatu perkara. Katakanlah kepada-Ku ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","pengimadan Yahya itu datang daripada siapa, syurga atau manusia?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mereka berbincang sesama sendiri, ‘Jikalau kita katakan, “Daripada syurga,” Dia akan berkata, “Jikalau begitu, mengapakah kamu tidak percaya kepadanya?” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sebaliknya, jikalau kita katakan, “Daripada manusia,” orang ramai sudah tentu akan merejam kita kerana mereka yakin bahawa Yahya itu seorang nabi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mereka pun menjawab kepada Isa bahawa mereka tidak mengetahui dari mana asalnya pengimadan Yahya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Oleh itu, Isa pun berkata kepada mereka, ‘Aku juga tidak akan memberitahu kamu atas kuasa siapa Aku melakukan segala perkara ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kemudian Isa menceritakan ibarat ini kepada orang ramai: ‘Seorang menanami ladang anggur. Dia menyewakan ladang itu kepada beberapa orang petani lalu berangkat ke negeri lain dan tinggal beberapa lama di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pada musim buah-buahan dia menyuruh seorang hamba pergi kepada petani-petani itu untuk menerima hasil buah-buahan bahagiannya daripada mereka tetapi petani-petani itu memukul hamba tersebut lalu mengusirnya balik dengan tangan kosong. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pemilik ladang itu menyuruh seorang hamba yang lain pula. Tetapi petani-petani itu memukulnya, mencercanya dan mengusirnya dengan tangan kosong juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pemilik ladang itu menyuruh hamba yang ketiga. Tetapi petani-petani itu mencederakannya lalu mengusirnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Pemilik ladang itu berkata, “Apakah yang hendak kubuat? Baik kusuruh puteraku yang kukasihi. Tentu petani-petani itu akan menghormatinya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","‘Tetapi apabila petani-petani itu melihatnya, mereka berbincang sesama sendiri, “Inilah warisnya. Marilah kita bunuh dia supaya ladang ini menjadi hak kita.” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mereka pun mengusirnya keluar dari ladang lalu membunuhnya.’ Isa bertanya, ‘Apakah yang akan dilakukan oleh pemilik ladang terhadap petani-petani tersebut? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sudah tentu dia akan datang dan membunuh petani-petani itu lalu menyewakan ladang anggur itu kepada orang lain pula.’ Setelah orang ramai itu mendengar ibarat ini, mereka berkata, ‘Semoga tidak begitu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tetapi Isa memandang mereka dan bertanya, ‘Kalau begitu, apakah maksud ayat yang tersurat ini: ‘ “Batu yang dibuang oleh pembina telah menjadi batu penjuru?” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","‘Sesiapa yang jatuh pada batu itu akan hancur luluh, dan sesiapa yang ditimpa batu itu akan remuk-redam.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Guru-guru Taurat dan ketua-ketua imam mencari jalan hendak menangkap Isa ketika itu juga kerana mereka mengetahui Isa telah menujukan ibarat itu terhadap mereka. Tetapi mereka takut akan orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mereka menunggu peluang. Lalu mereka mengutus beberapa orang supaya berpura-pura ikhlas untuk memerangkap Isa dengan mengemukakan pertanyaan tertentu supaya mereka dapat menyerahkan Isa ke dalam kawalan dan bidang penghakiman gabenor. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mereka bertanya kepada Isa, ‘Tuan Guru, kami mengetahui apa yang Tuan Guru katakan dan ajarkan itu betul. Kami juga mengetahui Tuan Guru tidak pilih kasih kepada seseorang tetapi dengan ikhlas mengajarkan jalan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Beritahulah kami, mengikut Taurat patutkah kami membayar cukai kepada Kaisar?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Isa mengetahui niat muslihat mereka lalu berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","‘Tunjukkanlah Aku sekeping mata wang. Gambar dan nama siapakah ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mereka menjawab, ‘Gambar dan nama Kaisar.’ Isa berkata kepada mereka, ‘Kalau begitu, berikan milik Kaisar kepada Kaisar, dan milik Allah kepada Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Oleh yang demikian, mereka tidak dapat memerangkap Isa di hadapan orang ramai itu. Mereka diam sahaja kerana kagum akan jawapan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Beberapa orang Saduki, iaitu orang yang menafikan hal kebangkitan orang mati, datang bertanya kepada Isa, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","‘Tuan Guru, Musa telah memberi kita hukum berikut. Jikalau seseorang lelaki meninggal tanpa mempunyai anak, adik lelakinya harus beristerikan balu itu untuk mendapatkan anak bagi si abang yang telah meninggal itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ada tujuh orang adik-beradik lelaki. Yang pertama mati tanpa mempunyai anak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yang kedua beristerikan balunya, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","kemudian yang ketiga dan seterusnya kepada semua yang lain – mereka semua meninggal tanpa mempunyai anak. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Akhirnya, perempuan itu pun meninggal. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pada hari kebangkitan orang mati kelak, perempuan itu menjadi isteri siapa kerana ketujuh-tujuh adik-beradik itu telah beristerikannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Isa menjawab, ‘Lelaki dan perempuan yang hidup sekarang ini berkahwin ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","tetapi mereka yang layak dibangkitkan daripada kematian dan hidup pada zaman yang akan datang tidak berkahwin. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mereka itu seperti malaikat dan tidak boleh mati lagi. Mereka menjadi anak Allah kerana mereka telah dibangkitkan daripada kematian. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musa telah menjelaskan bahawa orang mati akan dibangkitkan. Dalam kisah belukar yang bernyala, Allah disebut sebagai Tuhan yang disembah oleh Ibrahim, Ishak dan Yakub. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Allah bukannya Tuhan bagi orang mati tetapi bagi orang yang hidup. Mereka itu semua hidup pada Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Beberapa orang ahli Taurat berkata, ‘Tuan Guru, betul jawapan-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mereka tidak berani bertanya kepada Isa apa-apa lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Isa berkata kepada mereka, ‘Bagaimana dikatakan bahawa al-Masih itu anak Daud ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","sedangkan Daud sendiri berkata dalam kitab Zabur: ‘ “Tuhan berfirman kepada Junjunganku: ‘Duduklah di sebelah kanan-Ku ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sehingga Aku menjadikan musuh-Mu alas kaki-Mu.’” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","‘Jikalau Daud menyebut Dia “Junjungan,” bagaimanakah pula Dia anak Daud?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Di hadapan orang ramai itu Isa berkata kepada pengikut-pengikut-Nya, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","‘Berhati-hatilah dengan guru-guru Taurat yang suka berjalan-jalan berjubah labuh, suka dihormati di tempat orang ramai, suka mendapatkan tempat terbaik di saumaah dan terhormat di majlis makan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mereka memperdaya balu dan merampas harta mereka tetapi kemudian berpura-pura berdoa dengan panjangnya! Mereka akan menerima hukuman yang paling berat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Isa memandang di sekeliling lalu nampak orang kaya memasukkan wang persembahan mereka ke dalam peti persembahan di rumah ibadat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dia nampak juga seorang balu yang sangat miskin memasukkan dua keping wang tembaga. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Lalu Isa berkata, ‘Sesungguhnya, Aku berkata kepadamu bahawa balu yang miskin ini telah memasukkan lebih banyak daripada semua yang lain, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","kerana yang lain memasukkan persembahan daripada kemewahan masing-masing tetapi perempuan ini walaupun sangat miskin, telah memasukkan seluruh nafkahnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Beberapa orang berkata-kata tentang rumah ibadat yang dihiasi dengan batu-batu permata yang indah serta barang-barang yang dipersembahkan kepada Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Isa pun berkata, ‘Akan tiba masanya apabila semua yang kamu lihat ini akan dirobohkan dan tiada satu batu pun akan tinggal tersusun pada tempatnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mereka bertanya kepada Isa, ‘Tuan Guru, bilakah semua perkara ini akan terjadi? Apakah alamat-alamatnya bahawa masanya sudah tiba?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Isa berkata, ‘Berjaga-jagalah supaya kamu tidak terpedaya oleh orang. Ramai orang akan datang dengan nama-Ku dan berkata, “Akulah dia,” dan “Masanya sudah tiba.” Janganlah kamu ikut mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Apabila kamu mendengar tentang peperangan dan pemberontakan, janganlah kamu ketakutan. Peristiwa-peristiwa ini akan berlaku terlebih dahulu tetapi ini tidaklah bererti bahawa akhir zaman telah sampai.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kemudian Isa berkata kepada mereka, ‘Bangsa akan berperang dengan bangsa dan kerajaan dengan kerajaan; ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","gempa bumi dan kebuluran serta wabak yang dahsyat akan terjadi di beberapa tempat. Perkara-perkara dahsyat dan alamat-alamat yang hebat akan kelihatan di langit. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","‘Tetapi sebelum segala perkara yang disebut ini berlaku, kamu akan ditawan dan dianiayai. Kamu akan didakwa di majlis saumaah-saumaah dan dipenjarakan. Kamu akan didakwa di hadapan raja-raja dan gabenor-gabenor kerana nama-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Inilah peluang bagimu untuk memberitakan perkhabaran baik. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jadi, teguhkanlah hatimu supaya tidak bimbang bagaimana hendak membela diri ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kerana Aku akan memberimu kata-kata dan kebijaksanaan yang tidak dapat dinafikan oleh seorang pun daripada musuh-musuhmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kamu akan dikhianati oleh ibu bapamu, adik-beradikmu, sanak saudaramu dan sahabat handaimu. Mereka akan membunuh beberapa orang di antara kamu ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","dan kamu akan dibenci oleh semua kerana-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tetapi sehelai rambutmu pun tidak akan hilang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bertahanlah, keteguhan hatimu akan menyelamatkan kamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","‘Apabila kamu melihat kota Baitulmaqdis terkepung oleh tentera-tentera, ketahuilah kamu bahawa kebinasaannya telah hampir. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pada masa itu mereka yang berada di jajahan Yudea hendaklah melarikan diri ke gunung; mereka yang ada di dalam kota hendaklah meninggalkannya dan mereka yang ada di luar kota janganlah masuk ke kota itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Inilah hari-hari hukuman apabila segala perkara yang tersurat dalam Kitab Suci akan terjadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Malangnya bagi perempuan yang mengandung atau ibu yang menyusui anak pada masa itu! Kesengsaraan yang teruk akan melanda bumi dan kemurkaan akan menimpa bangsa ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mereka akan dibunuh dengan pedang dan ada pula yang akan dibawa ke negeri lain sebagai orang tawanan. Kota Baitulmaqdis akan diinjak-injak oleh bangsa-bangsa asing sehingga tamat tempoh yang ditetapkan untuk mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","‘Alamat akan kelihatan pada matahari, bulan dan bintang-bintang. Di muka bumi ini semua bangsa kelak sengsara dan bingung akan deru serta gelora lautan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sementara menantikan apa yang akan datang ke muka bumi, manusia akan jatuh pengsan kerana takut dan bimbang terhadap apa yang akan terjadi di dunia. Cakerawala di angkasa lepas akan terpesong daripada peredarannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lalu mereka akan melihat Putera Insan datang dikelilingi awan dengan kekuasaan dan kemuliaan yang besar. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Apabila segala perkara ini mula terjadi, teguhkanlah hatimu dan angkat kepalamu kerana masa penyelamatanmu telah hampir tiba.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Isa menceritakan suatu ibarat kepada mereka: ‘Tengoklah pokok ara dan segala pokok kayu yang lain! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Apabila pokok itu penuh menguntum, kamu tahu bahawa musim panas hampir tiba. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Demikian juga apabila kamu melihat segala perkara ini terjadi, ketahuilah bahawa kerajaan Allah hampir tiba. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","‘Sesungguhnya, Aku berkata kepadamu bahawa sebelum orang zaman ini mati, segala perkara itu akan terjadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langit dan bumi akan lenyap, tetapi firman-Ku berkekalan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‘Berjaga-jagalah! Janganlah leka dengan kesia-siaan dan kemabukan serta kekhuatiran terhadap kehidupan duniawi sehingga kamu tidak bersedia menghadapi hari itu yang datang dengan tidak disangka-sangka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hari itu akan datang seperti perangkap bagi semua manusia di seluruh muka bumi ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kamu hendaklah sentiasa berjaga-jaga dan berdoa supaya kamu diteguhkan untuk menghadapi segala perkara yang akan terjadi itu lalu dapat berdiri di hadirat Putera Insan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pada siang hari Isa mengajar di dalam rumah ibadat. Pada waktu malam Dia keluar dari kota itu dan bermalam di udara lapang di Bukit Zaitun. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pada pagi-pagi lagi orang ramai pergi ke rumah ibadat untuk mendengar Dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Perayaan Roti Tidak Beragi, iaitu perayaan Paska telah menjelang. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ketua-ketua imam dan guru-guru Taurat sedang mencari jalan untuk membunuh Isa secara diam-diam kerana mereka takut akan orang ramai itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kemudian, Iblis memasuki Yudas Iskariot, salah seorang daripada dua belas pengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Lalu Yudas pergi kepada ketua-ketua imam dan pengawal rumah ibadat untuk membincangkan bagaimana dia dapat menyerahkan Isa kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mereka gembira lalu berjanji memberikan wang kepadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas pun bersetuju lalu dia mencari peluang yang baik untuk menyerahkan Isa kepada mereka tanpa diketahui orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tibalah Perayaan Roti Tidak Beragi. Pada hari itu domba korban harus disembelih untuk jamuan Paska. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Isa menyuruh Petrus dan Yahya, ‘Pergilah sediakan jamuan Paska untuk kita.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mereka bertanya kepada Isa, ‘Di manakah Engkau hendak kami sediakan jamuan itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Isa menjawab, ‘Setibanya kamu ke dalam kota itu, seorang lelaki yang menjunjung sebuah buyung air akan bertemu dengan kamu. Ikutlah dia ke rumah yang dimasukinya ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","lalu berkatalah kepada tuan rumah itu, “Guru menyuruh kami bertanya: Di manakah bilik tempat Aku hendak makan jamuan Paska bersama pengikut-pengikut-Ku?” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tuan rumah itu akan menunjukkan kepadamu sebuah bilik besar yang lengkap dengan perabot di tingkat atas. Di situlah kamu sediakan jamuan Paska.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mereka pergi ke kota dan mendapati semua seperti yang telah dikatakan oleh Isa, lalu mereka menyediakan jamuan Paska. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Apabila tiba masanya, Isa pun duduk bersama pengikut-pengikut yang dua belas itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Lalu Isa berkata kepada mereka, ‘Sebenarnya, Aku telah lama ingin sekali makan jamuan Paska ini bersama kamu sebelum Aku menderita. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aku berkata kepadamu bahawa Aku tidak akan makan jamuan ini lagi sehingga maksud sebenar Paska dinyatakan di dalam kerajaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Setelah itu, Isa mengambil sebiji cawan minuman. Dia mengucap syukur lalu berkata, ‘Ambillah cawan ini dan bahagikan minumannya antara kamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aku berkata kepadamu bahawa mulai sekarang, Aku tidak akan minum air buah anggur lagi sehingga kerajaan Allah datang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Lalu Isa mengambil roti kemudian mengucap syukur kepada Allah. Setelah itu Dia memecah-mecahkan roti itu lalu memberikannya kepada pengikut-pengikut-Nya, sambil berkata, ‘Inilah tubuh-Ku yang diberikan untukmu. Berbuatlah sedemikian demi mengingati-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Begitu juga setelah makan, Dia mengambil cawan minuman dan berkata, ‘Cawan ini ialah perjanjian baru yang dimateraikan dengan darah-Ku yang dicurahkan untukmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tengoklah! Orang yang mengkhianati Aku ada bersama-sama di meja ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Putera Insan akan mati seperti yang ditetapkan, tetapi malangnya orang yang mengkhianati-Nya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mereka mula bertanya-tanya sesama sendiri siapakah di antara mereka yang akan berbuat demikian. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Satu perselisihan timbul di kalangan pengikut itu tentang siapa antara mereka yang dianggap terbesar. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Isa berkata kepada mereka, ‘Di dunia raja-raja berkuasa atas rakyat mereka, dan golongan pemerintah digelar pembawa kebajikan kepada rakyat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tetapi kamu tidak sama seperti mereka. Orang yang terbesar antara kamu hendaklah menjadi seperti yang terkecil, dan ketua harus menjadi seperti hamba. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Siapakah yang lebih besar – orang yang duduk makan atau hamba yang melayan? Bukankah orang yang duduk makan itu? Tetapi Aku ini antara kamu sebagai yang melayan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kamu bersama Aku dalam segala penderitaan-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Aku memberikan hak kepadamu untuk memerintah sebagaimana Bapa-Ku telah memberikan hak itu kepada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kamu akan makan dan minum di meja-Ku dalam kerajaan-Ku dan kamu akan duduk di atas takhta untuk menghakimi dua belas suku Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","‘Simon, Simon, dengarlah! Iblis telah meminta izin untuk menguji kamu semua seperti petani memisahkan gandum daripada sekam. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tetapi Aku telah berdoa untukmu supaya imanmu tidak goyah. Apabila kamu kembali kepada-Ku, kuatkanlah saudara-saudaramu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus berkata kepada Isa, ‘Junjungan, hamba sedia ke penjara dengan-Mu dan mati bersama-sama.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Isa menjawab, ‘Aku berkata kepadamu, Petrus, ayam tidak akan berkokok pada hari ini sehingga kamu berkata bahawa kamu tidak mengenal-Ku sebanyak tiga kali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Isa berkata kepada mereka, ‘Ketika Aku mengutus kamu keluar tanpa dompet atau beg atau kasut, adakah kamu kekurangan apa-apa?’ Mereka menjawab, ‘Satu pun tidak.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Isa berkata lagi, ‘Tetapi sekarang, orang yang mempunyai dompet atau beg hendaklah membawa barang-barang tersebut. Orang yang tidak berpedang hendaklah menjual bajunya untuk membeli sebilah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aku berkata kepadamu bahawa apa yang tersurat ini akan berlaku pada diri-Ku: “Dia tergolong bersama dengan penjahat.” Ini kerana apa yang tersurat tentang Aku akan berlaku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pengikut-pengikut itu berkata, ‘Tengoklah Junjungan, di sini ada dua bilah pedang!’ Isa berkata, ‘Cukuplah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Isa meninggalkan tempat itu lalu pergi ke Bukit Zaitun seperti kebiasaan-Nya. Pengikut-pengikut-Nya pergi bersama Dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sesampainya ke tempat itu, Dia berkata kepada mereka, ‘Berdoalah kamu supaya kamu tidak tergoda.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Isa pergi jauh sedikit daripada mereka, iaitu sepelempar batu jauhnya lalu berlutut untuk berdoa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","‘Ya Bapa, jikalau berkenan kepada-Mu, jauhkanlah kiranya cawan penderitaan ini daripada-Ku. Tetapi bukannya kehendak-Ku melainkan kehendak-Mu yang dilaksanakan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Malaikat dari syurga datang dan menguatkan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Dalam kesengsaraan Dia berdoa, peluh-Nya seperti darah menitik ke tanah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Isa bangun daripada berdoa, dan balik kepada pengikut-pengikut-Nya. Didapati-Nya mereka tertidur kerana sangat sedih. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dia berkata kepada mereka, ‘Mengapakah kamu tidur? Bangunlah dan berdoa supaya kamu tidak tergoda.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ketika Isa masih berkata-kata, sekumpulan orang datang. Yudas, salah seorang daripada dua belas pengikut-Nya memimpin mereka. Dia menghampiri Isa untuk mencium-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Isa berkata kepadanya, ‘Yudas, adakah dengan ciuman engkau mengkhianati Putera Insan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Apabila pengikut-pengikut Isa melihat apa yang akan terjadi, mereka bertanya kepada Isa, ‘Junjungan, haruskah kami serang mereka dengan pedang kami?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Salah seorang daripada mereka menyerang hamba imam agung dan memutuskan telinga kanannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tetapi Isa berkata, ‘Biarkanlah mereka.’ Lalu Isa menyentuh telinga orang itu dan menyembuhkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kemudian Isa berkata kepada ketua-ketua imam, ketua-ketua pengawal rumah ibadat dan tua-tua yang telah datang untuk menangkap-Nya, ‘Perlukah kamu datang dengan pedang dan belantan untuk menangkap Aku seolah-olah Aku ini seorang penyamun? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Semasa Aku bersama kamu setiap hari di dalam rumah ibadat, kamu tidak berani pula menangkap Aku. Tetapi inilah masa kamu dan masa kuasa kegelapan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Setelah menangkap Isa, mereka membawa Dia ke rumah imam agung. Petrus pun mengikut dari jauh. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mereka memasang api unggun di tengah-tengah halaman rumah itu lalu duduk di sekeliling. Petrus juga duduk antara mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Apabila seorang hamba perempuan melihat Petrus duduk berdekatan dengan api unggun, dia memandang kepadanya dan berkata, ‘Orang ini juga bersama Dia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tetapi Petrus menyangkal katanya, ‘Perempuan, aku tidak mengenal Dia!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sejurus selepas itu, seorang lain pula melihat Petrus lalu berkata, ‘Ya, engkau salah seorang daripada mereka itu.’ Tetapi Petrus menjawab, ‘Bukan, aku bukan!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kira-kira sejam kemudian, seorang lain pula berkeras mengatakan, ‘Tentulah orang ini juga bersama Dia kerana dia juga seorang Galilea.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tetapi Petrus berkata, ‘Aku tidak memahami apa yang kaukatakan.’ Pada ketika itu juga, sedang Petrus berkata-kata, ayam berkokok. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Junjungan berpaling dan memandang kepada Petrus lalu Petrus pun teringat akan apa yang dikatakan Junjungan kepadanya bahawa, ‘Sebelum ayam berkokok pada hari ini, engkau akan menyangkal Aku sebanyak tiga kali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petrus pun keluar lalu menangis dengan sangat kesalnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Orang yang mengawal Isa mengejek-ngejek dan memukul Dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mereka menutupi mata Isa dan bertanya, ‘Siapakah yang memukul Engkau? Buatlah nubuat!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mereka mengatakan banyak lagi perkara yang menghina kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pada pagi hari, tua-tua masyarakat, ketua-ketua imam dan guru-guru Taurat bermesyuarat, dan Isa dibawa ke hadapan Majlis Agama. Mereka berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","‘Jikalau Engkau al-Masih, katakanlah kepada kami.’ Isa berkata kepada mereka, ‘Jikalau Aku mengatakan kepadamu, kamu tidak percaya juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Dan jikalau Aku bertanya kepadamu, kamu juga tidak menjawab. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tetapi mulai sekarang, Putera Insan akan duduk di sebelah kanan Allah Yang Maha Kuasa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mereka semua bertanya, ‘Kalau begitu, Engkaulah Putera Allah?’ Isa berkata kepada mereka, ‘Benarlah katamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mereka berkata, ‘Apa perlunya saksi lagi? Kita sendiri telah mendengar apa yang dikatakan-Nya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Semua anggota Majlis Agama bangun lalu membawa Isa menghadap Pilatus. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mereka mula menuduh Dia, ‘Kami telah mendapati orang ini menyesatkan bangsa kami, menghasut orang supaya tidak membayar cukai kepada Kaisar dan mengaku diri-Nya al-Masih, seorang raja!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatus bertanya kepada Isa, ‘Engkaukah raja orang Yahudi?’ Isa menjawab, ‘Begitulah seperti katamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatus berkata kepada ketua-ketua imam dan orang ramai itu, ‘Aku tidak mendapati-Nya bersalah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tetapi mereka semakin mendesak, ‘Dia menghasut orang di seluruh Yudea supaya memberontak dengan ajaran-Nya. Dia memulakannya di Galilea dan sekarang telah sampai ke tempat ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Setelah Pilatus mendengar hal ini, dia bertanya sama ada Isa seorang Galilea. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ketika Pilatus mengetahui Isa berasal dari jajahan pemerintahan Herodes, dia menyuruh supaya Isa dibawa kepada Herodes kerana pada masa itu Herodes ada di kota Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Apabila Isa dibawa kepada Herodes, dia sangat sukacita. Sudah lama dia hendak bertemu dengan Isa kerana dia telah mendengar banyak hal tentang Isa. Lagi pun, dia berharap dapat menyaksikan Isa melakukan mukjizat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jadi, Herodes mengemukakan banyak soalan kepada Isa tetapi Isa tidak menjawab sepatah kata pun. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ketua-ketua imam dan guru-guru Taurat tampil ke hadapan dan melemparkan tuduhan terhadap Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes dan askar-askarnya menghina Isa dan sebagai ejekan mengenakan pakaian indah pada-Nya lalu menghantar-Nya kembali kepada Pilatus. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Semenjak hari itu, Herodes dan Pilatus bersahabat; mereka bermusuhan sebelum itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus memanggil ketua-ketua imam, para pemimpin masyarakat dan orang ramai ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","lalu berkata kepada mereka, ‘Kamu telah membawa orang ini kepadaku dan mengatakan Dia menyesatkan rakyat. Aku telah menyoal-Nya di hadapanmu dan aku tidak mendapati Dia bersalah atas satu pun tuduhanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes pun tidak mendapati Dia bersalah, kerana Dia dihantar kembali kepada kami. Tiada apa-apa yang dilakukan-Nya sehingga Dia patut dijatuhi hukuman mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Oleh itu, aku akan menyebat-Nya, kemudian membebaskan-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pada setiap perayaan Paska Pilatus akan membebaskan salah seorang tahanan bagi mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tetapi semua orang berteriak, ‘Bunuh Dia! Bebaskan Barabas bagi kami.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas telah dipenjarakan kerana terlibat dalam satu rusuhan yang berlaku di kota dan kerana pembunuhan.) ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus hendak membebaskan Isa. Oleh itu, dia berseru kepada orang ramai sekali lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tetapi orang ramai itu berteriak-teriak lagi, ‘Salibkan Dia! Salibkan Dia!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pada kali ketiga Pilatus berkata kepada mereka: ‘Apakah kesalahan-Nya? Aku tidak mendapati Dia bersalah sehingga patut dikenakan hukuman mati. Oleh sebab itu, aku akan menyebat-Nya dan kemudian membebaskan-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tetapi orang ramai itu terus-menerus berteriak dengan kuat supaya Isa disalib. Akhirnya, mereka berjaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatus memutuskan supaya tuntutan orang ramai itu dilaksanakan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dia membebaskan orang yang dikehendaki mereka, orang yang dipenjarakan kerana terlibat dalam rusuhan dan pembunuhan, tetapi Isa diserahkannya untuk diperlakukan menurut kehendak mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ketika askar-askar membawa Isa ke tempat orang disalib, mereka berjumpa dengan seorang lelaki yang bernama Simon. Dia berasal dari Kirene dan sedang dalam perjalanan ke kota. Askar-askar menangkapnya, memaksanya memikul salib Isa dan berjalan di belakang-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ramai orang mengikut Isa; antara mereka beberapa orang perempuan yang menangisi dan meratapi-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Isa berpaling kepada mereka lalu berkata, ‘Kaum perempuan Baitulmaqdis, janganlah tangisi Aku melainkan tangisilah dirimu dan anak-anakmu sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Masanya akan datang kelak apabila orang akan berkata, “Diberkatilah perempuan yang tidak pernah mengandung, melahirkan dan menyusui anak!” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pada masa itulah ’ “mereka akan berkata kepada gunung-gunung, ‘Timpalah kami!’ dan kepada bukit-bukit, ‘Timbusi kami!’” ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","‘Jikalau perbuatan begini dilakukan mereka terhadap pokok kayu yang masih hijau, apatah lagi terhadap pokok yang kering?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ada dua orang lain, iaitu kedua-duanya penjahat, yang akan dibunuh bersama Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Setelah mereka sampai ke tempat yang bernama, ‘Tengkorak,’ mereka pun menyalib Isa dan kedua-dua orang penjahat itu, seorang di sebelah kanan dan seorang di sebelah kiri-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Isa berkata, ‘Ya Bapa, ampunilah mereka kerana mereka tidak tahu apa yang mereka lakukan.’ Mereka membahagi-bahagikan pakaian-Nya dengan membuang undi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Orang ramai yang berdiri di situ memandang sahaja sementara para pemimpin masyarakat mengejek-ngejek-Nya, ‘Orang lain diselamatkan-Nya; biarlah Dia menyelamatkan diri-Nya sekarang jikalau Dia sesungguhnya al-Masih yang dipilih oleh Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Askar-askar juga mengejek-ngejek Isa. Mereka mendekati-Nya dan membawa air anggur masam kepada-Nya ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","lalu berkata, ‘Jika Engkau Raja orang Yahudi, selamatkanlah Diri-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pada sebelah atas kayu salib Isa tertulis kata-kata: ‘INILAH RAJA ORANG YAHUDI.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Seorang daripada penjahat yang disalib di situ mula menghina Isa. Dia berkata, ‘Bukankah Engkau al-Masih? Selamatkanlah Diri-Mu dan kami!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tetapi seorang penjahat lagi menegurnya, ‘Tidakkah kamu takut akan Allah? Kita sama-sama dihukum mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Bagi kita, hukuman ini adil kerana kita menerima balasan yang setimpal; tetapi orang ini tidak melakukan kesalahan apa-apa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dia berkata kepada Isa, ‘Ya Isa, ingatilah aku ketika Engkau menaiki takhta kerajaan-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Isa menjawab, ‘Sesungguhnya, Aku berkata kepadamu bahawa pada hari ini juga engkau akan bersama-Ku dalam Firdaus.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ketika itu kira-kira pukul dua belas tengah hari, kegelapan menyelubungi seluruh negeri itu sehingga pukul tiga petang kerana matahari gerhana. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tirai yang tergantung di dalam rumah ibadat pun koyak terbelah dua. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Isa berseru dengan suara yang kuat, ‘Ya Bapa, Aku menyerahkan roh-Ku ke dalam tangan-Mu!’ Setelah Isa berkata demikian, Dia pun wafat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ketua tentera yang menyaksikan apa yang telah terjadi memuji Allah, ‘Sesungguhnya, orang ini orang yang benar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Orang ramai yang telah berkumpul untuk menyaksikan peristiwa itu, pulang menebah dada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Semua sahabat Isa, termasuk perempuan-perempuan yang telah mengikut Dia dari Galilea, berdiri dari jauh untuk menyaksikan segala perkara ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Terdapat seorang yang bernama Yusuf. Dia berasal dari kota Arimatea di negeri Yudea. Dia seorang yang baik dan berakhlak tinggi. Dia juga sedang menantikan kerajaan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Walaupun seorang anggota Majlis Agama, dia tidak bersetuju dengan keputusan dan tindakan majlis itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dia pergi menghadap Pilatus untuk meminta jenazah Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kemudian, Yusuf menurunkan jenazah itu daripada salib, mengkafankannya lalu membaringkannya di dalam sebuah makam yang dipahat pada bukit batu. Makam itu belum pernah digunakan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hari itu ialah hari Jumaat, dan hari Sabat hampir bermula. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Perempuan-perempuan yang telah mengikut Isa dari Galilea pergi bersama Yusuf untuk melihat makam itu dan bagaimana jenazah Isa diletakkan di dalamnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kemudian, mereka pulang lalu menyediakan rempah-rempah yang harum dan minyak wangi-wangian untuk jenazah Isa. Pada hari Sabat mereka berehat mengikut hukum Taurat. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Awal-awal lagi pada hari Ahad, perempuan-perempuan itu pun pergi ke makam dengan membawa rempah-rempah harum yang telah disediakan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mereka mendapati batu penutup makam itu telah digulingkan dari makam. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Apabila mereka masuk ke dalam, jenazah Isa tiada lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mereka berdiri di situ dan berasa kebingungan tentang perkara ini. Tiba-tiba ada dua orang yang berpakaian berkilau-kilauan, berdiri di sisi mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Perempuan-perempuan itu sangat takut lalu sujud. Kedua-dua orang itu berkata kepada mereka, ‘Mengapakah kamu mencari Dia yang hidup di antara orang mati? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Dia tiada di sini. Dia sudah bangkit! Ingatlah apa yang telah dikatakan oleh-Nya kepadamu ketika Dia di Galilea: ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Putera Insan harus diserahkan kepada orang berdosa. Dia akan disalib dan bangkit pada hari yang ketiga.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mereka pun teringatlah akan kata-kata Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sekembali mereka dari makam itu, mereka memberitahu segala perkara ini kepada sebelas orang rasul dan semua pengikut yang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mereka, iaitu Maryam orang Magdala, Yohanah, Maryam, ibu Yakobus dan perempuan-perempuan yang lain mengatakan segala perkara itu kepada rasul-rasul itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tetapi mereka itu menganggap apa yang dikatakan oleh perempuan-perempuan itu sebagai karut lalu tidak mempercayai mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tetapi Petrus bangun dan berlari ke makam itu. Dia membongkok ke dalam lalu nampak kain kafan sahaja di situ. Dia pulang dengan hairan sambil memikirkan apa yang telah berlaku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pada hari itu juga dua orang antara pengikut Isa sedang dalam perjalanan ke sebuah kampung yang bernama Emaus, kira-kira tujuh batu jauhnya dari Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kedua-duanya berbual-bual tentang segala yang telah berlaku itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ketika mereka berbual-bual dan berbincang, Isa sendiri menghampiri mereka lalu berjalan bersama-sama. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mereka nampak Isa tetapi mereka tidak mengenali Dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Isa berkata kepada mereka, ‘Apakah perkara-perkara yang sedang kamu bincangkan dalam perjalanan kamu ini?’ Mereka pun berhenti di situ dengan berwajah murung. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Seorang daripadanya yang bernama Kleopas bertanya kepada Isa, ‘Engkaukah satu-satunya orang di Baitulmaqdis yang belum mengetahui peristiwa-peristiwa yang telah berlaku dalam beberapa hari ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Isa berkata, ‘Apakah yang telah berlaku?’ Mereka menjawab, ‘Segala perkara yang berlaku kepada Isa, orang Nasaret. Dia seorang nabi. Di sisi Allah dan pada pandangan orang, Dia berkuasa dalam apa yang dikatakan dan dilakukan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ketua-ketua imam dan para pemimpin kita telah menyerahkan-Nya untuk dijatuhi hukuman mati lalu mereka menyalib-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kami telah berharap bahawa Dialah yang akan membebaskan Israel. Tambahan lagi, hari ini ialah hari yang ketiga semenjak perkara-perkara itu telah berlaku. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Beberapa orang perempuan daripada golongan kami telah menakjubkan kami. Mereka telah siang-siang ke makam pada pagi tadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Akan tetapi, mereka tidak mendapati jenazah-Nya. Mereka pulang menceritakan bahawa mereka nampak malaikat-malaikat yang memberitahu mereka bahawa Dia hidup. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Beberapa orang daripada kumpulan kami telah pergi ke makam itu dan mendapati sebagaimana yang dikatakan oleh perempuan-perempuan itu, tetapi mereka tidak nampak Dia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kemudian, Isa berkata kepada mereka, ‘Betapa bodohnya kamu! Betapa lambatnya kamu percaya akan segala kata nabi-nabi! ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bukankah al-Masih harus menderita sedemikian untuk mencapai kemuliaan-Nya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Lalu Isa menerangkan kepada mereka apa yang tersurat tentang-Nya dalam semua kitab mulai dari kitab-kitab Musa sehingga semua kitab para nabi yang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Apabila mereka menghampiri kampung yang dituju mereka itu, Isa kelihatan seolah-olah Dia hendak meneruskan perjalanan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tetapi kedua-dua orang itu menjemput-Nya dengan berkata, ‘Bermalamlah dengan kami kerana hari hampir senja dan mulai gelap.’ Dia pun masuk ke rumah dan bermalam dengan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ketika Dia duduk untuk makan bersama mereka, Dia mengambil roti dan mengucap syukur. Dia membahagikan roti itu lalu memberikannya kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pada ketika itu juga mata mereka dicelikkan dan mereka pun mengenali Dia. Lalu Dia lenyap daripada pandangan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mereka berkata satu sama lain, ‘Bukankah hati kita meluap-luap ketika Dia berkata-kata kepada kita dalam perjalanan tadi dan semasa Dia menerangkan Kitab Suci kepada kita?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mereka terus bangun dan kembali ke Baitulmaqdis. Mereka mendapati sebelas pengikut itu berkumpul dengan pengikut yang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mereka berkata, ‘Sesungguhnya, Junjungan telah bangkit. Dia menampakkan diri-Nya kepada Simon!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lalu kedua-dua orang itu menceritakan apa yang telah berlaku dalam perjalanan mereka dan bagaimana mereka telah mengenali Isa semasa Dia membahagikan roti. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Semasa mereka berkata-kata tentang segala perkara ini, Isa sendiri berdiri di tengah-tengah mereka dan berkata kepada mereka, ‘Sejahteralah kamu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mereka terkejut dan berasa sangat takut kerana menyangka mereka melihat hantu. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tetapi Isa berkata kepada mereka, ‘Apakah sebabnya kamu takut? Mengapakah hatimu ragu-ragu? ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tengoklah tangan dan kaki-Ku. Inilah Aku. Sentuhlah Aku dan tengok. Hantu tidak berdaging dan bertulang sebagaimana yang kamu lihat ada pada-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Setelah Dia berkata demikian, Dia menunjukkan tangan dan kaki-Nya kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mereka masih tidak dapat percaya kerana terlalu gembira dan takjub. Isa pun bertanya kepada mereka, ‘Adakah kamu mempunyai makanan di sini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mereka memberi Dia sepotong ikan yang telah dimasak, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","lalu Dia mengambilnya dan makan di hadapan mereka semua. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kemudian, Dia berkata kepada mereka, ‘Inilah perkara-perkara yang telah Aku katakan kepadamu semasa Aku masih bersamamu dahulu: Segala perkara yang tersurat tentang Aku dalam Taurat Musa, kitab-kitab nabi dan Kitab Zabur pasti akan berlaku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Lalu Dia membuka pintu pemahaman mereka supaya mereka mengerti maksud Kitab Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Dia berkata lagi, ‘Demikianlah yang tersurat: Bahawa al-Masih harus menderita lalu bangkit semula daripada maut pada hari yang ketiga, ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","dan perkhabaran tentang pertaubatan dan pengampunan dosa akan diisytiharkan demi nama-Nya kepada semua bangsa, mulai di Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kamulah saksi segala perkara ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Dan Aku akan mengurniakan pemberian yang dijanjikan oleh Bapa-Ku kepadamu. Tetapi, tunggulah di kota ini sehingga kamu diperlengkapi dengan kuasa daripada Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kemudian Isa membawa pengikut-pengikut-Nya ke luar kota sehingga Baitani. Di situ Dia mengangkat tangan-Nya lalu memberkati mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ketika Dia memberkati mereka, Dia diangkat ke syurga lalu meninggalkan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pengikut-pengikut-Nya menyembah-Nya dan kembali ke Baitulmaqdis dengan penuh kegembiraan. ");
INSERT INTO zlmKSZI_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mereka menumpukan masa di rumah ibadat untuk memuji Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pada permulaan sudah wujud Firman, dan Firman itu bersama Allah dan Firman itu adalah Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dia bersama Allah pada permulaan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Segala-galanya diciptakan melalui Dia. Dari segala yang wujud, tiada suatu pun yang dicipta tanpa-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hidup ada di dalam-Nya, dan hidup itu cahaya manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Dan Cahaya itu bersinar dalam kegelapan, dan kegelapan tidak menguasainya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Allah mengutus seorang bernama Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dia datang untuk memberi kesaksian tentang Cahaya itu, supaya semua orang akan percaya melalui Dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dia sendiri bukanlah Cahaya itu, dia datang untuk memberi kesaksian tentang-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Itulah Cahaya yang benar, Cahaya yang menerangi setiap manusia di dunia. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dia berada di dunia, dan dunia telah dicipta melalui-Nya, namun manusia di dunia tidak mengenal-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Dia datang kepada milik-Nya sendiri, tetapi milik-Nya tidak menerima-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Namun demikian, Dia memberi hak menjadi anak Allah kepada mereka yang menerima-Nya dan percaya dalam nama-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kelahiran mereka bukan melalui darah keturunan, atau kehendak tabii manusia, atau kemahuan seorang lelaki, tetapi kerana perbuatan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Firman itu menjadi manusia dan hidup di kalangan kita. Kita melihat kemuliaan-Nya sebagai Putera tunggal yang datang daripada Allah Bapa, penuh dengan kasih kurnia dan kebenaran. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yahya memberi kesaksian tentang-Nya. Dia berseru, ‘Inilah Dia yang kukatakan akan datang selepasku, tetapi Dia lebih besar daripadaku, kerana Dia sudah ada sebelum aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Daripada limpah kesempurnaan-Nya kita semua telah menerima kasih kurnia dan berkat. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ini kerana hukum Taurat disampaikan melalui Musa, tetapi kasih kurnia dan kebenaran dinyatakan melalui Isa al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tiada siapa pernah melihat Allah, melainkan Yang Esa dan Ilahi yang ada di pangkuan Bapa, telah menyerlahkan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Inilah kesaksian Yahya, apabila orang Yahudi di Baitulmaqdis mengutus para imam dan orang Lewi untuk bertanya kepadanya, ‘Siapakah kamu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yahya mengaku, ‘Aku bukanlah al-Masih’. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mereka bertanya, ‘Jadi, kamu ini siapa? Ilyas?’ ‘Bukan,’ jawabnya. ‘Adakah kamu nabi?’ Dia menjawab, ‘Bukan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kemudian mereka berkata, ‘Siapakah kamu? Katakanlah, supaya kami dapat menyampaikan jawapan kepada orang yang mengutus kami. Menurut katamu sendiri, kau ini siapa?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yahya menjawab, ‘Aku ini satu suara yang berseru di gurun, “Luruskanlah jalan untuk Tuhan,” sebagaimana kata Nabi Yasyaya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Di antara orang yang diutus itu ada beberapa orang Farisi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Mereka terus menyoal, ‘Mengapakah kamu mengimadkan orang, kiranya kamu bukan al-Masih, bukan Ilyas dan bukan pula nabi?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yahya menjawab, ‘Aku mengimadkan dengan air, tetapi di kalanganmu ada seorang yang tidak kamu kenali, ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","iaitu Dia yang datang selepasku. Aku tidak layak mengurai tali kasut-Nya pun.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Semua ini terjadi di Baitani, di seberang Sungai Yordan; di situlah Yahya mengimadkan orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pada keesokan harinya, Yahya melihat Isa berjalan ke arahnya lalu berseru, ‘Lihatlah Anak Domba Allah yang menghapuskan dosa umat manusia! ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Dialah yang kukatakan akan datang selepasku tetapi lebih besar daripadaku kerana Dia telah ada sebelumku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Dahulu aku tidak mengenal Dia. Tetapi untuk itulah aku datang dan mengimadkan orang dengan air, supaya Dia dinyatakan kepada Israel.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yahya memberi kesaksian: ‘Aku melihat Roh seperti burung merpati turun dari langit lalu hinggap di atas-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dahulu aku sendiri pun tidak mengenal-Nya, tetapi Dia yang mengutusku untuk mengimadkan orang dengan air telah berfirman kepadaku, “Engkau akan melihat Roh turun lalu hinggap di atas seorang. Dialah yang akan mengimadkan orang dengan Roh Suci.” ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Hal itu telah kulihat sendiri, maka aku berkata kepadamu, Dialah Putera Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pada hari yang berikut, Yahya berada di situ lagi bersama dua orang pengikutnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dia melihat lagi Isa lalu di tempat itu dan dia berseru, ‘Lihatlah Anak Domba Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Apabila dua orang pengikut Yahya itu mendengar kata-kata demikian, mereka pun mengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Isa menoleh dan melihat mereka mengikut-Nya lalu bertanya, ‘Apa hajatmu?’ Mereka menjawab, ‘Rabbi (ertinya Guru), di manakah Engkau tinggal?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","‘Marilah lihat,’ kata Isa. Mereka terus mengikut-Nya dan melihat tempat tinggal-Nya. Waktu itu kira-kira pukul empat. Mereka pun tinggal bersama Isa pada hari itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Seorang daripada mereka ialah Andreas, saudara Simon Petrus. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andreas segera mencari Simon dan berkata, ‘Kami telah bertemu dengan al-Masih!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Selepas itu, Andreas membawa Simon berjumpa dengan Isa. Isa memandang Simon lalu berkata, ‘Kamu Simon anak Yahya, tetapi kamu akan digelar Kefas.’ (Kefas sama ertinya dengan Petrus, yakni batu pejal.) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pada keesokan harinya, Isa membuat keputusan hendak pergi ke Galilea. Dia berjumpa dengan Filipus dan berkata, ‘Ikutlah Aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Seperti Andreas dan Petrus, Filipus juga warga kota Baitsaida. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipus pula mendapatkan Natanael dan berkata, ‘Kami telah bertemu dengan orang yang disebut oleh Musa dalam kitab Taurat dan oleh nabi-nabi. Orang itu ialah Isa anak Yusuf dari Nasaret.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tetapi Natanael berkata, ‘Mungkinkah sesuatu yang baik datang dari Nasaret?’ ‘Marilah lihat,’ balas Filipus. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ketika Isa melihat Natanael berjalan ke arah-Nya, Dia berkata, ‘Ini orang Israel tulen, tiada yang palsu pada dirinya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael bertanya, ‘Bagaimana Engkau mengenal aku?’ Isa menjawab, ‘Sebelum Filipus memanggilmu, Aku telah melihatmu di bawah pokok ara itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael berseru, ‘Tuan Guru, Engkau Putera Allah! Engkau Raja bangsa Israel!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Isa berkata, ‘Adakah kamu beriman kepada-Ku kerana Aku berkata Aku nampak kamu di bawah pokok ara itu? Kamu akan melihat hal-hal yang jauh lebih hebat daripada ini!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Isa berkata kepada mereka semua, ‘Percayalah, kamu akan melihat langit terbuka dan malaikat-malaikat Allah turun naik menemui Putera Insan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pada hari yang ketiga, suatu majlis perkahwinan diadakan di kota Kana di negeri Galilea. Ibu Isa turut hadir. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Isa dan pengikut-pengikut-Nya juga dijemput ke majlis itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Apabila air anggur yang ada habis diminum, ibu Isa berkata kepada-Nya, ‘Mereka kehabisan air anggur.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Isa menjawab, ‘Puan, usahlah suruh Aku. Saat-Ku belum tiba.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Namun, ibu Isa berkata kepada pelayan-pelayan di majlis itu, ‘Buatlah apa saja yang disuruh-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Di situ ada enam buah tempayan yang digunakan untuk istiadat penyucian orang Yahudi. Tiap-tiap tempayan dapat memuat kira-kira seratus liter air. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Isa berkata kepada pelayan-pelayan, ‘Isilah tempayan-tempayan ini dengan air.’ Mereka pun mengisi penuh keenam-enam tempayan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Setelah itu Isa berkata pula, ‘Sekarang ambillah sedikit air itu, bawakan kepada ketua majlis.’ Mereka pun menghidangkan air itu kepada ketua majlis. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Setelah ketua majlis merasa air yang telah menjadi air anggur itu, dia pun memanggil pengantin lelaki. Dia tidak tahu dari mana datangnya air anggur itu, tetapi para pelayan yang mengambil dan membawa air itu mengetahuinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Dia berkata kepada pengantin lelaki, ‘Selalunya orang menghidangkan air anggur yang terbaik di awal majlis. Setelah tetamu banyak minum, dihidangkan pula air anggur yang biasa saja. Tetapi kamu menyimpan dulu air anggur yang terbaik, sekarang baru dihidangkan!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Itulah mukjizat Isa yang pertama, dilakukan di Kana, Galilea. Dia menyatakan kemuliaan-Nya, maka para pengikut-Nya percaya kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Setelah itu Isa bersama ibu-Nya, saudara-saudara-Nya dan pengikut-pengikut-Nya pergi ke Kapernaum lalu tinggal di situ beberapa hari. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ketika perayaan Paska orang Yahudi hampir tiba, Isa pergi ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Di dalam rumah ibadat Dia mendapati orang berjual-beli lembu, domba dan burung merpati, serta pengurup-pengurup wang duduk di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Isa membuat cemeti daripada tali lalu mengusir kesemua orang, domba dan lembu dari rumah ibadat. Dia juga menghamburkan wang para pengurup wang itu dan menterbalikkan meja mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dia berkata kepada penjual burung merpati, ‘Bawa keluar semuanya. Jangan jadikan Rumah Bapa-Ku tempat berniaga!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Para pengikut-Nya teringat bahawa telah tersurat: ‘Kasih-Ku terhadap Rumah-Mu membakar hati-Ku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Orang Yahudi menyoal Isa, ‘Apakah mukjizat yang dapat Kamu lakukan sebagai bukti bahawa Kamu berhak bertindak begini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Isa menjawab, ‘Robohkanlah rumah ibadat ini, akan Kubina semula dalam tiga hari.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","‘Pembinaannya mengambil masa empat puluh enam tahun! Akan Kaubina semula dalam tiga hari?’ tanya mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sebenarnya, rumah ibadat yang dimaksudkan oleh Isa itu ialah tubuh-Nya sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Apabila Isa bangkit daripada kematian, para pengikut-Nya teringat kata-kata-Nya itu. Dengan demikian percayalah mereka akan Kitab Suci dan kata-kata Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sewaktu Isa di Baitulmaqdis pada masa perayaan Paska, ramai orang yang percaya kepada-Nya disebabkan mukjizat-mukjizat yang dilakukan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Namun demikian, Isa tidaklah mempercayakan diri-Nya kepada mereka, kerana Dia mengetahui isi hati manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dia tidak memerlukan kesaksian sesiapa tentang manusia kerana Dia mengetahui niat dan perasaan setiap orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pada masa itu ada seorang pemimpin Yahudi dari golongan Farisi bernama Nikodemus. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dia mengunjungi Isa pada suatu malam lalu berkata, ‘Tuan Guru, kami tahu bahawa Engkau guru yang datang daripada Allah. Tidak mungkin seseorang melakukan mukjizat seperti yang Kaulakukan kecuali Allah menyertai-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Isa menjawab, ‘Sesungguhnya, Aku berkata kepadamu, kecuali seseorang dilahirkan semula, dia tidak dapat melihat kerajaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus bertanya, ‘Bagaimana seorang dewasa mungkin dilahirkan semula? Tidak mungkin dia masuk semula ke rahim ibunya lalu dilahirkan sekali lagi!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Isa menjawab, ‘Apa yang Kukatakan ini benar. Tidak mungkin seseorang masuk ke dalam kerajaan Allah kecuali dia dilahirkan daripada air dan Roh Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yang dilahirkan manusia adalah manusia, dan yang dilahirkan Roh adalah roh. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Janganlah hairan akan kata-kata-Ku bahawa kamu semua perlu dilahirkan semula. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Angin bertiup semahunya. Kita mendengar bunyinya, tetapi tidak tahu dari mana datangnya dan ke mana perginya. Demikianlah juga dengan orang yang dilahirkan oleh Roh Suci.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus bertanya, ‘Bagaimana hal itu boleh berlaku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Isa menjawab, ‘Kamu pengajar bangsa Israel dan kamu tidak mengetahui hal ini? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sesungguhnya Aku berkata kepadamu, apa yang kami ketahui, itulah yang kami katakan, dan apa yang telah kami lihat, itulah yang kami saksikan, tetapi kamu tidak mahu menerimanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jika kamu tidak percaya ketika Aku bercakap tentang hal-hal dunia, bagaimana mungkin kamu percaya sekiranya Aku bercakap tentang hal-hal syurga? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tiada seorang pun pernah naik ke syurga, kecuali Putera Insan yang turun dari syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sebagaimana ular diangkat oleh Musa di gurun, begitulah Putera Insan akan diangkat ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","supaya semua yang percaya kepada-Nya mendapat hidup yang kekal. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","‘Allah begitu mengasihi umat manusia sehingga menganugerahkan Putera-Nya yang tunggal supaya orang yang percaya kepada Putera itu tidak binasa tetapi mendapat hidup kekal. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Allah mengutus Putera-Nya ke dunia bukan untuk menghakimi dunia tetapi supaya melalui Dia, dunia ini diselamatkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Sesiapa yang percaya kepada-Nya tidak dijatuhi hukuman. Sebaliknya, sesiapa yang tidak percaya sudahpun dijatuhi hukuman, kerana dia tidak percaya dalam nama Putera Allah yang tunggal. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Penghakiman berdasarkan hal ini: Cahaya sudah datang ke dunia, tetapi manusia lebih suka akan kegelapan kerana mereka berbuat jahat. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Orang yang berbuat jahat benci akan cahaya dan tidak mahu mendekatinya kerana takut perbuatan jahatnya terdedah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tetapi orang yang berbuat benar merapati cahaya, supaya jelas bahawa perbuatannya dilakukan melalui Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Selepas itu, Isa dan para pengikut-Nya pergi ke wilayah Yudea. Isa tinggal bersama mereka di sana dan mengimadkan orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yahya pula mengimadkan di Ainon, tidak berapa jauh dari Salim, kerana di situ ada banyak air. Orang datang kepadanya dan dia mengimadkan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Pada masa itu, Yahya belum lagi dimasukkan ke dalam penjara. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pada suatu hari tercetus pertengkaran antara sebilangan pengikut Yahya dan seorang Yahudi tentang istiadat penyucian. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mereka pergi kepada Yahya dan berkata, ‘Tuan Guru, seorang yang bersama Tuan Guru di seberang Sungai Yordan dulu, orang yang Tuan Guru tunjukkan kepada kami, Dia mengimadkan orang dan semua orang pergi kepada-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yahya menjawab, ‘Seseorang tidak mungkin menerima sesuatu kecuali diberi kepadanya dari syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamu semua menjadi saksiku bahawa aku telah berkata, “Aku bukanlah al-Masih, tetapi aku diutus sebelum-Nya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yang mendapatkan pengantin perempuan adalah pengantin lelaki. Sahabat pengantin lelaki yang cuma menanti dan mendengarkan ketibaan pengantin lelaki, berasa bahagia ketika mendengar suara pengantin lelaki. Demikian juga aku. Sekarang sempurnalah kebahagiaanku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Memang sewajarnya Dia semakin utama dan aku semakin kecil. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","‘Dia yang datang dari atas adalah di atas segala-galanya. Orang yang berasal dari dunia datang dari dunia dan bercakap tentang hal-hal dunia. Tetapi Dia yang datang dari syurga adalah di atas segala-galanya, ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Dia menyampaikan apa yang dilihat dan didengar-Nya, tetapi tidak ada seorang pun yang menerima kesaksian-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Namun begitu, mereka yang menerima kesaksian-Nya mengaku bahawa Allah itu benar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dia yang diutus oleh Allah menyampaikan firman Allah, kerana Allah mengurniakan-Nya Roh Suci sepenuhnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bapa kasih akan Putera-Nya dan telah meletakkan segala-galanya di bawah kuasa Putera-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Sesiapa yang percaya kepada Putera itu mendapat hidup yang kekal. Sesiapa yang tidak taat kepada-Nya tidak akan mendapat hidup yang kekal itu dan kemurkaan Allah kekal ke atasnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ketika Isa mengetahui orang Farisi telah mendengar berita bahawa Dia mendapat dan mengimadkan lebih ramai pengikut berbanding Yahya, ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(sebenarnya para pengikut Isa yang mengimadkan, bukan Isa), ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dia pun meninggalkan Yudea lalu pulang ke Galilea semula. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Dalam perjalanan-Nya itu, Isa semestinya melalui Samaria. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Di Samaria, Isa sampai di bandar Sikhar, berdekatan dengan sebidang tanah yang dahulu diberikan oleh Yakub kepada anaknya Yusuf. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Di situ ada sebuah perigi Yakub. Oleh sebab berasa letih setelah berjalan jauh, Isa duduk berehat di tepi perigi itu. Waktu itu kira-kira jam yang keenam. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kemudian datanglah seorang perempuan Samaria untuk menimba air. Lalu Isa berkata kepadanya, ‘Berilah Aku minum.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Pengikut-pengikut Isa telah pergi ke bandar untuk membeli makanan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Perempuan Samaria itu menjawab, ‘Bagaimana Tuan seorang Yahudi meminta minum daripadaku, seorang perempuan Samaria?’ (Orang Yahudi tidak berurusan dengan orang Samaria.) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Isa menjawab, ‘Kalaulah kamu mengetahui pemberian Allah, dan siapakah Dia yang berkata kepadamu, “Berilah Aku minum,” tentulah kamu pula akan meminta daripada-Nya dan Dia akan mengurniaimu air hidup.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Perempuan itu berkata, ‘Tuan tidak ada timba. Perigi ini sangat dalam. Bagaimana mungkin Tuan mendapatkan air hidup itu? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Adakah Tuan lebih besar daripada moyang kami, Yakub, yang mewariskan perigi ini kepada kami? Dia, anak-anaknya dan binatang ternakannya minum air dari perigi ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Isa berkata, ‘Sesiapa yang minum air dari perigi ini akan dahaga semula; ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","tetapi sesiapa minum air yang Kuberikan kepadanya nanti tidak akan dahaga lagi selama-lamanya. Air yang akan Kuberikan itu akan menjadi mata air di dalam dirinya dan memberinya hidup yang kekal.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Perempuan itu berkata, ‘Tuan, berikanlah air itu kepadaku, supaya aku tidak dahaga lagi dan tidak perlu lagi datang ke perigi ini mengambil air.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Isa menjawab, ‘Pergilah dulu, bawa suamimu ke mari.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Perempuan itu berkata, ‘Aku tidak ada suami.’ Isa pun berkata, ‘Memang benar engkau tidak ada suami sekarang. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kamu telah berkahwin lima kali. Lelaki yang tinggal denganmu sekarang bukan suamimu. Benarlah katamu itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Perempuan itu berkata, ‘Tahulah aku sekarang, Tuan ini seorang nabi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nenek moyang kami menyembah Allah di gunung ini, tetapi bangsa tuan berkata tempat orang menyembah Allah hanya di Baitulmaqdis.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Isa berkata, ‘Hai perempuan, percayalah, akan sampai saatnya kamu menyembah Bapa bukan lagi di gunung ini atau di Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kamu menyembah apa yang tidak kamu kenal; sebaliknya, kami menyembah apa yang kami kenal kerana penyelamatan datang daripada orang Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Akan sampai saatnya, malah sudahpun sampai, penyembah sejati akan menyembah Bapa dalam roh dan kebenaran; kerana Bapa menghendaki penyembah yang sedemikian. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Allah itu Roh, maka orang yang menyembah Dia harus menyembah-Nya dalam roh dan kebenaran.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Perempuan itu berkata, ‘Aku tahu Mesias yang disebut al-Masih akan datang. Apabila Dia datang, Dia akan memberitahu kami segala-galanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Isa berkata kepada perempuan itu, ‘Akulah Dia yang sekarang bercakap denganmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pada ketika itu para pengikut Isa pulang ke situ. Mereka hairan melihat Isa bercakap dengan seorang perempuan tetapi seorang pun tidak bertanya kepada perempuan itu, ‘Apa hajatmu?’ atau kepada Isa, ‘Mengapa Engkau bercakap dengan perempuan ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Perempuan itu pun meninggalkan bekas airnya di situ lalu pergi ke bandar memberitahu orang di sana apa yang telah berlaku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Perempuan itu berkata, ‘Marilah lihat seorang yang menyebutkan kepadaku segala yang telah kulakukan. Mungkinkah orang itu al-Masih?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dengan demikian, orang di bandar pun pergi mendapatkan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sementara itu, para pengikut Isa berkata kepada-Nya, ‘Tuan Guru, silalah makan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Isa menjawab, ‘Aku ada makanan yang tidak kamu ketahui.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Lalu para pengikut Isa tertanya-tanya sesama sendiri, ‘Adakah sesiapa datang membawakan-Nya makanan tadi?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Isa berkata, ‘Makanan-Ku itu melaksanakan kehendak Dia yang mengutus-Ku dan menyelesaikan pekerjaan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Bukankah kamu berkata, “Empat bulan lagi barulah tiba musim menuai?” Tetapi Aku berkata kepadamu, lihatlah ladang yang sudah menguning, sedia untuk dituai. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Orang yang menuai akan menerima upah dan mendapat hasil untuk hidup kekal. Dengan demikian, penyemai benih dan penuai akan bergembira bersama-sama. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Dalam hal ini benarlah pepatah, “Ada yang menyemai, ada pula yang menuai.” ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aku menyuruhmu menuai ladang yang bukan hasil usahamu. Orang lain yang mengerjakannya, kamu yang mendapat hasilnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Pada masa itu ramai orang Samaria percaya kepada Isa setelah mendengar perempuan itu berkata, ‘Dia menyebutkan kepadaku segala yang telah kulakukan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Oleh yang demikian, ketika mereka datang menemui Isa, mereka mengajak-Nya tinggal bersama mereka. Isa pun tinggal di situ selama dua hari. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Lebih ramai lagi orang yang percaya kepada Isa kerana kata-kata-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mereka berkata kepada perempuan itu, ‘Sekarang kami percaya bukanlah kerana kata-katamu tetapi kerana kami telah mendengar kata-kata-Nya sendiri dan kami tahu Dialah al-Masih, Penyelamat umat manusia di dunia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Selepas tinggal dua hari di Samaria, Isa ke Galilea pula, ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","kerana Isa sendiri bersaksi bahawa seorang nabi tidak mendapat penghormatan di negerinya sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Setiba-Nya di Galilea, orang di situ menyambut-Nya. Mereka telah melihat segala yang dilakukan-Nya di Baitulmaqdis pada masa perayaan Paska dahulu. Pada ketika itu, mereka juga berada di sana. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Selepas itu Isa pulang ke Kana di Galilea, iaitu tempat Dia mengubah air menjadi air anggur. Seorang pegawai kerajaan di situ mempunyai anak lelaki yang sedang sakit di Kapernaum. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Apabila pegawai itu mendengar tentang kedatangan Isa ke Galilea dari Yudea, dia pun pergi berjumpa Isa. Dia meminta Isa datang ke Kapernaum untuk menyembuhkan anaknya yang sakit tenat dan hampir maut. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tetapi Isa berkata, ‘Kalau kamu semua tidak melihat mukjizat dan hal-hal luar biasa, tidaklah kamu percaya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pegawai itu merayu, ‘Tuan, datanglah segera sebelum anakku mati.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Isa pun berkata, ‘Pergilah, anakmu akan sembuh.’ Pegawai itu percaya akan kata-kata Isa lalu pergi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dalam perjalanannya ke rumah, hambanya datang memberitahu bahawa anaknya itu telah sembuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Apabila pegawai itu bertanya bila anaknya mula pulih, mereka menjawab, ‘Kelmarin, pada jam yang ketujuh, dia tidak demam lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bapa anak itu teringat bahawa pada waktu itulah Isa telah berkata, ‘Anakmu akan sembuh.’ Dengan demikian, pegawai itu dan seluruh keluarganya percaya kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Itulah mukjizat Isa yang kedua dilakukan-Nya di Galilea setelah tiba di situ dari Yudea. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Setelah itu Isa pergi ke Baitulmaqdis pada masa suatu perayaan Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Di sana, berdekatan Pintu Domba, ada sebuah kolam yang dipanggil Baithasda dalam bahasa Ibrani. Kolam ini dikelilingi lima buah serambi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Di setiap serambi itu ramai orang sakit dan cacat berbaring – ada yang buta, ada yang tempang dan ada yang lumpuh – menunggu air kolam itu berkocak. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Sekali-sekala malaikat Tuhan akan turun mengocak air kolam itu. Sesiapa yang pertama masuk ke dalam kolam itu ketika airnya berkocak akan sembuh daripada penyakitnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Di kalangan mereka ada seorang lelaki yang telah sakit selama tiga puluh lapan tahun. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Isa melihatnya terbaring di situ dan mengetahui bahawa dia telah sakit demikian lamanya. Isa bertanya kepadanya, ‘Inginkah kamu sembuh?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Orang sakit itu menjawab, ‘Tuan, tiada siapapun di sini yang dapat memasukkan aku ke dalam kolam itu ketika airnya berkocak. Setiap kali aku cuba masuk, orang lain telah masuk dulu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Isa berkata kepadanya, ‘Bangun, angkat tikarmu, dan berjalanlah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Serta-merta orang itu sembuh lalu mengangkat tikarnya dan berjalan. Perkara itu terjadi pada hari Sabat. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Oleh yang demikian, orang Yahudi berkata kepada orang itu, ‘Ini hari Sabat. Kamu melanggar hukum kerana mengangkat tikar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Orang itu menjawab, ‘Orang yang menyembuhkanku tadi menyuruh aku mengangkat tikar dan berjalan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mereka pun bertanya, ‘Siapakah Dia yang menyuruhmu mengangkat tikar dan berjalan itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Akan tetapi orang yang baru disembuhkan itu tidak dapat menunjukkan yang mana orangnya, kerana Isa telah menghilang di antara orang ramai di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tidak lama selepas itu, Isa bertemu dengan orang itu di dalam rumah ibadat dan berkata kepadanya, ‘Sekarang kamu sudah sembuh. Jangan berbuat dosa lagi, supaya kamu tidak menerima padah yang lebih teruk.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Orang itu kemudiannya memberitahu orang Yahudi bahawa Isalah yang telah menyembuhkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Dengan demikian, mereka mula memusuhi Isa kerana menyembuhkan orang pada hari Sabat. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Namun, Isa berkata kepada mereka, ‘Bapa-Ku masih bekerja hingga sekarang, maka begitulah juga Aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kata-kata-Nya ini mengukuhkan lagi niat orang Yahudi hendak membunuh-Nya. Bukan sahaja Dia melanggar hukum hari Sabat, malah juga mengatakan Allah itu Bapa-Nya, iaitu menyamakan diri-Nya dengan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Isa menjawab kata-kata mereka, ‘Sesungguhnya, aku berkata kepadamu, Putera tidak dapat melakukan sesuatu oleh diri-Nya sendiri. Dia hanya melakukan apa yang dilihat-Nya dilakukan oleh Bapa-Nya. Apa yang dilakukan oleh Bapa, itulah yang dilakukan oleh Putera, ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","kerana Bapa kasih akan Putera dan menunjukkan segala yang dilakukan-Nya kepada Putera-Nya. Bapa akan menyatakan hal-hal yang lebih besar lagi kepada Putera, sehingga kamu semua menjadi hairan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bapa membangkitkan manusia daripada kematian dan memberi hidup, maka demikian jugalah Putera-Nya memberi hidup kepada mereka yang dikehendaki-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bapa tidak menghakimi sesiapa. Dia telah menyerahkan kuasa menghakimi kepada Putera-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Dengan demikian, semua orang menghormati Putera sebagaimana mereka menghormati Bapa. Jika sesiapa tidak menghormati Putera, ertinya dia tidak menghormati Bapa yang mengutus-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‘Sesungguhnya aku berkata kepadamu, sesiapa yang mendengar kata-kata-Ku dan percaya kepada Dia yang mengutus-Ku akan mendapat hidup yang kekal dan tidak akan dihukum. Dia telah terlepas daripada kematian dan mendapat hidup sebenar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","‘Sesungguhnya Aku berkata kepadamu, akan tiba saatnya, malah sudahpun sampai, ketika orang mati mendengar suara Putera Allah, dan orang yang mendengar suara-Nya akan hidup. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bapa sumber hidup, maka Dia menjadikan Putera-Nya juga sumber hidup. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Bapa telah memberikan kuasa menghakimi kepada Putera-Nya, kerana Dia itu Putera Insan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","‘Janganlah hairan mendengar hal ini kerana akan sampai saatnya bagi semua orang mati mendengar suara-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mereka akan terus bangkit dari kubur. Orang yang berbuat baik akan bangkit untuk mendapat hidup kekal dan orang yang berbuat jahat akan bangkit untuk dihukum. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Aku tidak dapat melakukan sesuatu pun atas usaha-Ku sendiri. Aku menghakimi manusia menurut perintah Allah. Penghakiman-Ku adil, kerana Aku tidak mengikut kehendak-Ku sendiri tetapi kehendak Dia yang mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","‘Jika Aku memberi kesaksian tentang diri-Ku sendiri, itu tidaklah wajar diterima sebagai bukti yang sah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ada lain yang memberi kesaksian tentang diri-Ku, dan Aku tahu kesaksian yang disampaikan-Nya tentang-Ku itu benar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","‘Kamu telah mengutus orang untuk berjumpa dengan Yahya, dan dia telah memberikan kesaksian yang benar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sebenarnya Aku tidak memerlukan kesaksian manusia. Aku menyebutnya supaya kamu percaya dan dapat diselamatkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahya ibarat pelita yang menyala dan bercahaya. Bagi seketika lamanya, kamu memilih untuk menikmati cahayanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","‘Tetapi kesaksian-Ku lebih besar daripada kesaksian Yahya. Aku melakukan apa yang ditugaskan oleh Bapa-Ku, dan hal ini membuktikan bahawa Bapa telah mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bapa yang mengutus-Ku dan memberikan kesakian tentang diri-Ku ini belum pernah kamu dengar suara-Nya atau lihat wajah-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Firman Tuhan tidak menetap dalam dirimu kerana kamu tidak percaya kepada Dia yang diutus Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","‘Kamu mengkaji Kitab Suci dengan tekun kerana kamu percaya dalamnya kamu mendapat hidup kekal. Sebenarnya Kitab Suci memberikan kesaksian tentang diri-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tetapi kamu tidak mahu datang kepada-Ku untuk mendapatkan hidup kekal. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‘Aku tidak mengharapkan pujian daripada manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Aku mengenalmu. Aku tahu kamu sebenarnya tidak mengasihi Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aku datang atas nama Bapa-Ku, tetapi kamu tidak menyambut-Ku. Namun, ketika orang lain datang atas namanya sendiri, kamu menyambutnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bagaimana kamu mungkin percaya kepada-Ku, sedangkan kamu mencari pujian sesama sendiri? Kamu tidak berusaha mendapatkan pujian daripada Allah Yang Esa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","‘Jangan sangka Aku akan menuduhmu di hadapan Bapa. Musa yang kamu harapkan itulah yang akan menuduhmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sekiranya benar kamu percaya kepada Musa, tentulah kamu percaya kepada-Ku, kerana Musa telah menulis tentang diri-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kamu tidak percaya akan apa yang ditulis oleh Musa, maka bagaimana kamu mungkin percaya akan apa yang Kukatakan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Setelah itu Isa pergi ke seberang Laut Galilea yang juga dipanggil Tiberias. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ramai orang mengikut-Nya setelah melihat mukjizat-Nya menyembuhkan orang sakit. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Isa mendaki sebuah bukit lalu duduk di situ bersama para pengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pada masa itu perayaan Paska orang Yahudi hampir tiba. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Apabila Isa memandang sekeliling dan melihat ramai orang datang ke arah-Nya, Dia berkata kepada Filipus, ‘Dari manakah dapat kita beli makanan untuk semua mereka ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Sebenarnya Isa bertanya itu untuk menduga Filipus sahaja kerana Dia tahu apa yang akan dilakukan-Nya.) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipus menjawab, ‘Roti yang berharga dua ratus keping wang perak pun tidak cukup, meskipun jika dibahagi secebis seorang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Seorang lagi pengikut Isa bernama Andreas, saudara Simon Petrus, berkata kepada-Nya, ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","‘Ada seorang budak di sini yang mempunyai lima buku roti barli dan dua ekor ikan. Tetapi tidak mungkin akan cukup untuk orang seramai ini!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Isa berkata kepada para pengikut-Nya, ‘Ajaklah mereka duduk.’ (Di situ ada banyak rumput.) Mereka itu pun duduk, kira-kira lima ribu orang lelaki semuanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Isa mengambil roti itu lalu mengucap syukur kepada Allah. Selepas itu Dia memecah-mecahkan roti itu antara orang ramai itu. Kemudian Dia membahagi-bahagikan ikan itu pula. Semuanya makan sepuas-puasnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Setelah kenyang semuanya, Isa berkata kepada para pengikut-Nya, ‘Kumpulkanlah baki makanan, jangan ada yang terbuang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Lalu mereka mengumpulkannya dan mengisi dua belas bakul baki makanan daripada lima buku roti barli yang dimakan oleh orang ramai itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Apabila mereka melihat mukjizat yang dilakukan oleh Isa itu, mereka pun berkata, ‘Memang Dialah Nabi yang dinanti-nantikan datang ke dunia!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Isa tahu bahawa mereka hendak datang dan memaksa-Nya menjadi raja. Oleh itu Dia beredar sekali lagi ke bukit seorang diri. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Setelah senja hari, para pengikut Isa turun ke tasik. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mereka menaiki perahu menyeberangi tasik itu ke Kapernaum. Hari sudah gelap namun Isa belum pulang mendapatkan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ketika itu tasik mulai bergelombang kerana angin bertiup kencang. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Setelah para pengikut Isa berkayuh tiga atau tiga setengah batu, mereka terpandang Dia berjalan di atas air ke arah perahu mereka, lalu mereka pun ketakutan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tetapi Isa berkata kepada mereka, ‘Jangan takut, Aku Isa!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Barulah mereka mahu menyambut-Nya naik ke perahu. Pada saat itu juga tibalah perahu itu ke tempat yang dituju. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pada keesokan harinya, orang ramai yang berada di seberang tasik sedar bahawa di situ hanya ada sebuah perahu dan Isa tidak menaiki perahu itu. Mereka tahu bahawa para pengikut Isa telah bertolak menaiki perahu itu tanpa-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kemudian, beberapa buah perahu dari Tiberias berlabuh dekat tempat orang ramai makan roti selepas Junjungan mengucap syukur. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Apabila mereka tidak melihat Isa atau para pengikut-Nya, mereka pun menaiki perahu-perahu itu menuju ke Kapernaum untuk mencari Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ketika mereka bertemu dengan Isa di seberang tasik, mereka bertanya kepada-Nya, ‘Tuan Guru, bilakah Engkau sampai ke mari?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Isa menjawab, ‘Sesungguhnya, Aku berkata kepadamu, kamu mencari-Ku bukan kerana kamu telah melihat tanda-tanda mukjizat, tetapi kerana kamu telah dapat makan sehingga kenyang. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Janganlah berusaha mendapatkan makanan yang boleh basi. Berusahalah mendapatkan makanan yang dapat bertahan sampai hidup kekal. Itulah makanan yang akan diberikan kepada-Mu oleh Putera Insan, kerana Allah Bapa telah melantik-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mereka bertanya kepada-Nya, ‘Apakah yang mesti kami buat untuk melaksanakan pekerjaan yang dikehendaki Allah?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Isa berkata, ‘Inilah pekerjaan yang dikehendaki Allah iaitu supaya kamu percaya kepada Dia yang diutus-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mereka bertanya kepada-Nya, ‘Apakah tanda ajaib yang dapat Kautunjukkan supaya kami melihatnya lalu percaya kepada-Mu? Apakah yang dapat Kaulakukan? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nenek moyang kami makan manna di gurun, sebagaimana tersurat di dalam Kitab Suci: “Dia memberikan roti dari syurga untuk dimakan oleh mereka.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Lalu Isa berkata, ‘Sesungguhnya Aku berkata kepadamu, bukanlah Musa yang memberimu roti dari syurga tetapi Bapa-Ku yang memberimu roti sebenar dari syurga. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Roti yang diberikan oleh Allah ialah Dia yang turun dari syurga dan memberi hidup kepada manusia di dunia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kemudian mereka berkata, ‘Junjungan, berilah kami roti itu selalu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Isa berkata kepada mereka, ‘Akulah Roti Hidup itu. Sesiapa yang datang kepada-Ku tidak akan lapar lagi, dan sesiapa yang percaya kepada-Ku tidak akan dahaga lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Telah Kukatakan kepadamu, bahawa kamu telah melihat-Ku, namun tidak percaya kepada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Semua yang diberikan kepada-Ku oleh Bapa akan datang kepada-Ku. Aku tidak akan menolak seorang pun yang datang kepada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aku turun dari syurga bukanlah untuk melakukan kehendak-Ku sendiri tetapi kehendak Dia yang mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Inilah kehendak Dia yang mengutus-Ku: Daripada semua yang diberi kepada-Ku, tiada seorang pun yang keciciran tetapi akan Kubangkitkan kesemuanya pada hari akhir. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Demikianlah kehendak Bapa-Ku iaitu setiap orang yang melihat Putera-Nya dan percaya kepada-Nya akan mendapat hidup yang kekal, dan Aku akan membangkitkannya pada hari akhir.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Orang Yahudi di situ mula merungut sesama sendiri menentang Isa kerana kata-katanya, ‘Akulah roti yang turun dari syurga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mereka berkata, ‘Bukankah Dia Isa, anak Yusuf, dan ibu bapa-Nya kita kenal? Bagaimana Dia boleh mengaku, “Aku turun dari syurga”?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Lalu Isa berkata kepada mereka, ‘Janganlah merungut sesama sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tiada seorang pun yang dapat datang kepada-Ku kecuali didorongkan oleh Bapa yang mengutus-Ku dan Aku akan membangkitkannya pada hari akhir. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ada tersurat di dalam tulisan para nabi: “Semua manusia akan diajar oleh Allah.” Dengan demikian, seorang yang mendengar dan belajar daripada Bapa akan datang kepada-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tidak seorang pun pernah melihat Bapa. Hanya Dia yang datang daripada Allah telah melihat Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sesungguhnya Aku berkata kepadamu, orang yang percaya mendapat hidup yang kekal. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Akulah roti hidup. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nenek moyangmu makan manna di gurun, tetapi mereka mati juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Inilah roti yang turun dari syurga. Orang yang makan roti ini tidak akan mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Akulah Roti Hidup yang turun dari syurga. Orang yang makan roti ini akan hidup kekal. Roti yang akan Kuberikan untuk hidup manusia di dunia ini adalah tubuh-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Orang Yahudi yang mendengar kata-kata ini mula bertengkar sesama sendiri ‘Bagaimanakah mungkin orang ini memberikan tubuh-Nya untuk kita makan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Isa berkata kepada mereka, ‘Sesungguhnya Aku berkata kepadamu, jika kamu tidak makan tubuh Putera Insan dan minum darah-Nya, kamu tidak mempunyai hidup dalam dirimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sesiapa yang makan tubuh-Ku dan minum darah-Ku mendapat hidup yang kekal, maka Aku akan membangkitkannya pada hari akhir. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tubuh-Ku inilah makanan yang sebenar. Darah-Ku inilah minuman yang sebenar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Apabila seorang makan tubuh-Ku dan minum darah-Ku, maka dia tetap di dalam-Ku dan Aku di dalamnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Seperti Bapa yang hidup mengutus Aku, dan Aku hidup kerana Bapa hidup. Demikianlah juga, orang yang makan tubuh-Ku akan hidup kerana Aku hidup. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Inilah roti yang turun dari syurga, bukan seperti roti yang dimakan oleh nenek moyangmu, yang kemudiannya mati juga walaupun telah memakannya. Sebaliknya, sesiapa yang makan roti ini akan hidup kekal.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Demikianlah kata-kata Isa ketika mengajar di saumaah di Kapernaum. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Antara para pengikut yang mendengar kata-kata-Nya itu, ramai yang berkata, ‘Ajaran ini terlalu susah difahami. Siapakah yang dapat menerimanya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Isa tahu tanpa diberitahu akan rungutan para pengikut-Nya. Lalu Dia berkata kepada mereka, ‘Adakah perkara ini menyebabkan kamu enggan percaya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bagaimana nanti kalau kamu melihat Putera Insan naik semula ke tempat asal-Nya? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hanya Roh Suci memberi hidup. Tubuh tidak ada faedahnya. Apa yang Kukatakan kepadamu ini datang daripada Roh Suci dan memberi hidup. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sungguhpun begitu, sebilangan daripadamu tidak percaya.’ (Isa mengetahui dari mulanya siapa yang enggan percaya dan siapa yang akan mengkhianati-Nya.) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Isa berkata lagi, ‘Maka itulah sebabnya Aku berkata kepadamu, tiada seorang pun dapat datang kepada-Ku kecuali dengan keredaan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Selepas itu, ramai pengikut Isa menjauhkan diri dan tidak lagi mengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Oleh yang demikian, Isa bertanya kepada pengikut-Nya yang dua belas itu, ‘Adakah kamu juga akan meninggalkan-Ku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petrus berkata kepada Isa, ‘Junjungan, kepada siapa lagi akan kami pergi? Engkaulah yang memiliki kata-kata hidup yang kekal. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kami percaya sepenuh hati bahawa Engkaulah Yang Suci daripada Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Isa berkata, ‘Tidakkah kamu dua belas orang ini Kupilih, tetapi seorang daripadamu adalah iblis?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yang dimaksudkan oleh Isa ialah Yudas anak Simon Iskariot. Meskipun Yudas salah seorang pengikut Isa yang dua belas itu, dia akan mengkhianati-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Selepas itu, Isa pergi berjalan di Galilea. Dia tidak pergi ke daerah Yudea kerana orang Yahudi di situ berniat hendak membunuh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ketika itu Perayaan Tabernakel orang Yahudi hampir tiba. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Oleh itu, saudara-saudara Isa berkata kepada-Nya, ‘Beredarlah dari sini ke Yudea, supaya pengikut-pengikut-Mu dapat melihat perbuatan-Mu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Orang tidak menyembunyikan perbuatannya kalau ingin menjadi ternama. Kerana Kamu sudah melakukan perkara-perkara ini, biarlah diri-Mu dikenal orang di dunia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Saudara-saudara Isa sendiri tidak percaya kepada-Nya.) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Lalu Isa berkata kepada mereka, ‘Saat-Ku belum sampai lagi. Saatmu bila-bila sahaja. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dunia ini tiada sebab untuk membencimu. Tetapi dunia membenci-Ku, kerana Aku memberikan kesaksian tentangnya bahawa kerjanya durjana. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pergilah menyambut perayaan itu. Aku tidak pergi kerana saat-Ku belum sampai sepenuhnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Setelah berkata demikian, Isa tetap tinggal di Galilea. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Apabila saudara-saudara-Nya telah bertolak untuk menghadiri perayaan itu, Isa pun pergi juga secara diam-diam. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pada masa perayaan itu orang Yahudi mencari Isa. Mereka bertanya, ‘Di manakah Dia?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Orang ramai berbisik-bisik tentang-Nya. Ada yang berkata, ‘Dia seorang yang baik.’ Ada pula yang berkata, ‘Tidak! Dia membawa ajaran sesat!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tetapi semuanya tidak berani bercakap secara terbuka tentang Isa, kerana takut akan orang Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pada pertengahan masa perayaan itu, Isa masuk ke rumah ibadat lalu mengajar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Orang Yahudi tercengang mendengar kata-kata-Nya lalu berkata, ‘Bagaimanakah orang ini begitu berpengetahuan walaupun tidak dididik?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Lalu Isa menjawab, ‘Apa Kuajarkan bukanlah ajaran-Ku, tetapi ajaran Dia yang mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Orang yang mahu melaksanakan kehendak Allah akan tahu sama ada ajaran ini datang daripada diri-Ku atau daripada Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Seseorang yang bercakap atas namanya sendiri mencari kemuliaan bagi dirinya. Sebaliknya, seseorang yang mencari kemuliaan bagi Dia yang mengutusnya, adalah jujur dan bersih daripada sebarang kepalsuan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Tidakkah Musa menyampaikan hukum Taurat kepadamu? Tetapi tidak seorang pun di antara kamu yang melaksanakan hukum Taurat itu. Mengapakah kamu hendak membunuh-Ku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Orang ramai menjawab, ‘Kamu dirasuk roh iblis! Siapa pula yang hendak membunuh-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Isa berkata kepada mereka, ‘Aku melakukan satu mukjizat, lalu kamu semua berasa takjub. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa telah memberimu peraturan bersunat. Oleh itu, pada hari Sabat pun kamu hendak menyunatkan anak lelakimu. (Sebenarnya peraturan bersunat itu bukanlah bermula daripada Musa, tetapi daripada nenek moyangmu sebelumnya.) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kiranya seorang anak lelaki boleh disunatkan pada hari Sabat kerana tidak mahu melanggar hukum Musa, mengapakah kamu marah kepada-Ku kerana menyembuhkan seluruh tubuh seseorang pada hari Sabat? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Janganlah hakimi seseorang berdasarkan apa yang dilihat. Hakimilah dengan adil.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sebilangan penduduk Baitulmaqdis berkata, ‘Bukankah orang ini yang dicari oleh mereka untuk dibunuh?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lihatlah, Dia bercakap di hadapan orang ramai, tetapi mereka diam sahaja. Adakah para pemerintah itu benar-benar tahu bahawa Dia al-Masih? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Orang ini, kita tahu tempat asal-Nya.’ Tetapi, apabila al-Masih datang, tiada siapa yang tahu akan tempat asal-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ketika Isa mengajar di rumah ibadat, Dia berseru dengan suara lantang, ‘Kamu tentu mengenal siapa Aku dan di mana tempat asal-Ku. Aku datang bukanlah dengan kehendak-Ku sendiri. Dia yang mengutus-Ku dapat dipercayai, tetapi kamu tidak mengenal-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Aku mengenal-Nya kerana Dialah yang mengutus-Ku dan Aku datang daripada-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Selepas itu, mereka cuba menangkap Isa. Tetapi tiada seorang pun memegang-Nya kerana saat-Nya belum sampai. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sebilangan besar orang ramai itu percaya kepada Isa. Mereka berkata, ‘Apabila al-Masih datang, adakah dia akan melakukan lebih banyak mukjizat daripada orang ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Apabila bisikan orang ramai didengar oleh orang Farisi, mereka dan para ketua imam pun menyuruh beberapa orang pengawal rumah ibadat menangkap Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Namun, Isa berkata, ‘Aku akan bersamamu sebentar sahaja. Selepas itu Aku akan pulang kepada Dia yang mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kamu akan mencari-Ku, tetapi tidak dapat menemui-Ku, kerana kamu tidak boleh datang ke tempat Aku berada.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Orang Yahudi berkata sesama sendiri, ‘Ke manakah Dia hendak pergi sehingga kita tidak dapat menemui-Nya? Adakah Dia hendak pergi kepada orang Yahudi yang tinggal di perantauan di kalangan orang Yunani untuk mengajar orang Yunani?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Apakah maksud kata-kata-Nya, “Kita akan mencari-Nya tetapi tidak dapat menemui-Nya kerana kita tidak boleh pergi ke tempat Dia berada”?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pada hari terakhir perayaan itu, iaitu hari yang terutama, Isa berdiri lalu berkata dengan suara lantang, ‘Sesiapa yang dahaga, datanglah kepada-Ku untuk minum.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Sebagaimana tersurat di dalam Kitab Suci, “Sesiapa yang percaya kepada-Ku, dalam hatinya akan terpancar mata air yang memberi hidup.”’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Yang dimaksudkan oleh Isa ialah Roh Suci yang akan diterima kelak oleh orang yang percaya kepada-Nya. Pada masa itu Roh Suci belum dikurniakan, kerana Isa belum dimuliakan.) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sebilangan orang yang mendengar kata-kata Isa berkata, ‘Sudah tentu orang inilah Nabi itu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ada pula yang berkata, ‘Dialah al-Masih yang diutus oleh Allah.’ Sebaliknya, ada yang berkata, ‘Al-Masih yang diutus oleh Allah bukan dari Galilea. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Menurut Kitab Suci, al-Masih yang diutus Allah itu keturunan Raja Daud dan akan dilahirkan di kota Baitlahim, tempat asal Raja Daud.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Demikianlah mereka berbalah lalu berpihak-pihak kerana Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Beberapa orang ingin menangkap-Nya, namun tiada siapapun menyentuh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kemudian para pengawal rumah ibadat datang kepada para ketua imam dan orang Farisi. Lalu mereka bertanya kepada para pengawal rumah ibadat itu, ‘Mengapakah kamu tidak membawa Dia ke sini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Para pengawal itu menjawab, ‘Belum pernah seseorang bercakap seperti-Nya!” ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Orang Farisi berkata, ‘Adakah kamu disesatkan juga? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Adakah mana-mana pemerintah atau orang Farisi percaya kepada-Nya? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tetapi hanya orang ramai ini tidak mengenal hukum Taurat – terlaknatlah mereka ini!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus, seorang Farisi yang pernah pergi menemui Isa, berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","‘Bukankah mengikut hukum Taurat, kita tidak boleh menghukum seseorang tanpa perbicaraan dan penyiasatan terlebih dahulu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mereka berkata, ‘Adakah kamu juga berasal dari Galilea? Kajilah, dan kamu akan tahu tiada nabi yang datang dari Galilea.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Selepas itu semua orang pulang ke rumah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Akan tetapi Isa pergi ke Bukit Zaitun. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pada keesokan harinya, pagi-pagi lagi Dia masuk ke rumah ibadat. Semua orang di situ datang kepada-Nya. Dia duduk lalu mengajar mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Guru Taurat dan orang Farisi membawa kepada Isa seorang perempuan yang didapati berzina. Mereka membuat perempuan itu berdiri di hadapan semua orang di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mereka berkata kepada Isa, ‘Tuan Guru, perempuan ini ditangkap ketika berzina.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Di dalam hukum Taurat, Musa memberi perintah supaya perempuan demikian direjam sampai mati. Bagaimanakah pendapat-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mereka bertanya demikian untuk menduga Isa supaya mempunyai alasan untuk menuduh-Nya. Tetapi Isa tunduk menulis di tanah dengan jari-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mereka tetap mengulangi pertanyaan itu. Oleh yang demikian, Isa meluruskan badan-Nya lalu berkata kepada mereka, ‘Sesiapa di antaramu yang tidak berdosa, hendaklah dia yang pertama merejam batu kepadanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kemudian Isa tunduk menulis semula di tanah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Setelah mendengar kata-kata Isa, seorang demi seorang, bermula dengan yang tertua, beredar dari situ. Akhirnya hanya Isa dan perempuan itu yang tinggal. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Isa meluruskan badan-Nya lalu berkata kepada perempuan itu, ‘Di manakah mereka? Tidak adakah orang yang mengutukmu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Perempuan itu menjawab, ‘Tidak ada, Junjungan.’ Isa berkata, ‘Aku pun tidak menghukummu. Pergilah, jangan berbuat dosa lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Isa berkata lagi kepada mereka, ‘Akulah cahaya dunia. Orang yang mengikut-Ku tidak akan berjalan dalam kegelapan tetapi akan mempunyai cahaya hidup.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lalu orang Farisi yang hadir berkata kepada Isa, ‘Kamu memberikan kesaksian tentang diri-Mu sendiri. Kesaksian-Mu tidak sah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Isa menjawab, ‘Walaupun Aku memberi kesaksian tentang diri-Ku sendiri, kesaksian-Ku benar, kerana Aku tahu dari mana Aku datang dan ke mana Aku pergi, sedangkan kamu tidak tahu dari mana Aku datang dan ke mana Aku pergi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kamu menghakimi orang mengikut ukuran manusia. Aku tidak menghakimi sesiapapun. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tetapi sekiranya Aku menghakimi, penghakiman-Ku adil, kerana Aku tidak menghakimi sendirian. Bapa yang mengutus-Ku menghakimi bersama-sama-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ada tersurat di dalam hukum Taurat kamu: Kesaksian dua orang adalah sah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aku memberi kesaksian tentang diri-Ku. Bapa yang mengutus-Ku juga memberi kesaksian tentang diri-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Oleh itu mereka bertanya, ‘Di manakah Bapa-Mu itu?’ Isa menjawab, ‘Kamu tidak mengenal-Ku atau Bapa-Ku. Kalaulah kamu mengenal-Ku, tentu kamu mengenal Bapa-Ku juga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Isa mengatakan segala ini di perbendaharaan ketika mengajar di rumah ibadat. Tetapi tiada seorang pun menangkap-Nya, kerana saat-Nya belum sampai. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Isa berkata lagi kepada mereka, ‘Aku akan pergi dan kamu akan mencari-Ku, tetapi kamu akan mati dalam dosamu. Kamu tidak boleh pergi ke tempat Aku pergi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Lalu orang Yahudi berkata, ‘Adakah Dia hendak membunuh diri?’ Kerana Dia berkata, ‘Kamu tidak boleh pergi ke tempat Aku pergi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Isa berkata, ‘Kamu datang dari bawah; Aku datang dari atas. Kamu berasal dari dunia; Aku tidak berasal dari dunia. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Itulah maka Kukatakan kepadamu, kamu akan mati dalam dosamu. Memanglah kamu akan mati dalam dosamu jika kamu tidak percaya bahawa Akulah Dia yang Kukatakan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","‘Siapa Kamu ini?’ tanya mereka. Isa menjawab, ‘Akulah Dia yang telah Kukatakan kepadamu dari mula lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ada banyak lagi yang perlu Kukatakan dan Kuadili tentangmu. Tetapi Dia yang mengutus-Ku dapat dipercayai. Aku menyampaikan kepada dunia apa yang Kudengar daripada-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mereka tidak faham bahawa selama ini Isa bercakap tentang Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Lalu Isa berkata kepada mereka, ‘Apabila kamu meninggikan Putera Insan, barulah kamu tahu bahawa Akulah Dia yang Kukatakan, dan Aku tidak pernah melakukan sesuatu menurut kehendak-Ku. Aku hanya mengatakan apa yang diajarkan oleh Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Dia yang mengutus-Ku ada di sisi-Ku. Dia tidak pernah membiarkan Aku keseorangan, kerana Aku sentiasa melakukan apa yang diredai-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Setelah mendengar kata-kata Isa, ramai orang percaya kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Isa berkata kepada orang Yahudi yang percaya kepada-Nya, ‘Kalau kamu mengikut ajaran-Ku, kamu pengikut-Ku yang sejati. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Maka kamu akan mengenal kebenaran dan kebenaran akan membebaskanmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mereka berkata, ‘Kami keturunan Ibrahim. Kami belum pernah diperhambakan. Apakah maksud kata-kata-Mu, “Kamu akan dibebaskan”?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Isa berkata kepada mereka, ‘Sesungguhnya, Aku berkata kepadamu, sesiapa yang melakukan dosa menjadi hamba kepada dosa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Seorang hamba tidak mempunyai kedudukan kekal dalam sebuah keluarga, tidak seperti seorang anak yang selama-lamanya anggota keluarga itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dengan demikian, jika Putera membebaskanmu, kamu akan bebas sepenuhnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Aku tahu kamu keturunan Ibrahim, tetapi kamu ingin membunuh-Ku kerana kata-kata-Ku tidak mendapat tempat dalam dirimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aku menyampaikan apa yang dinyatakan oleh Bapa-Ku. Demikian juga kamu melakukan apa yang disampaikan oleh bapamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mereka menjawab, ‘Bapa kami Ibrahim.’ Tetapi Isa berkata, ‘Sekiranya kamu benar-benar anak Ibrahim, tentu kamu lakukan apa yang telah dilakukan oleh Ibrahim. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Aku hanya memberitahumu apa yang difirmankan Allah kepada-Ku, tetapi kamu hendak membunuh-Ku. Ini bukanlah perlakuan Ibrahim! ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kamu melakukan apa yang dilakukan oleh bapamu.’ Mereka menjawab, ‘Kami bukan anak luar nikah. Bapa kami satu, iaitu Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Isa berkata kepada mereka, ‘Kalaulah benar Allah Bapamu, tentu kamu mengasihi-Ku, kerana Aku datang daripada-Nya, bukan dengan kehendak-Ku sendiri, tetapi diutus-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mengapa kamu tidak mengerti kata-kata-Ku? Kerana kamu enggan mendengar kata-kata-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bapamu Iblis dan kamu anak-anaknya. Kamu lebih cenderung menurut kehendak bapamu. Dari mulanya lagi, Iblis pembunuh. Dia tidak menyokong kebenaran, kerana dalam dirinya tidak ada kebenaran. Apabila dia berdusta, dia bercakap dari sifat tabiinya sendiri, kerana dia pendusta dan bapa segala dusta. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Sebaliknya aku menyampaikan kebenaran, maka itulah kamu tidak mahu percaya kepada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","‘Siapakah antaramu yang dapat membuktikan Aku berdosa? Jika Aku berkata benar, mengapa kamu tidak mempercayai-Ku? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Orang yang daripada Allah mendengar firman Allah. Kamu tidak mendengarnya, kerana kamu bukan daripada Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Orang Yahudi berkata, ‘Tidakkah benar kami katakan, Kamu ini orang Samaria dan dirasuk roh iblis?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Isa menjawab, ‘Aku tidak dirasuk roh iblis. Aku memuliakan Bapa-Ku, tetapi kamu menghina-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aku tidak mencari kemuliaan untuk diri-Ku, tetapi Dia yang mencarinya untuk-Ku, dan Dia akan menghakimi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sesungguhnya Aku berkata kepadamu, sesiapa yang menurut kata-Ku tidak akan mati.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Orang Yahudi berkata kepada-Nya, ‘Sekarang tahulah kami bahawa Kamu dirasuk roh iblis! Ibrahim sudah mati, begitu juga nabi-nabi. Tetapi Kamu berkata, “Sesiapa yang menurut kata-Ku tidak akan mati.” ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Adakah Kamu lebih besar daripada bapa kami Ibrahim yang sudah mati? Nabi-nabi juga sudah mati. Kamu sangka Kamu ini siapa?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Isa menjawab, ‘Sekiranya Aku memuliakan diri-Ku, kemuliaan itu tidak bererti. Bapa-Ku yang memuliakan Aku. Kamu mengatakan Dia itu Tuhanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Namun, kamu tidak mengenal-Nya, tetapi Aku mengenal-Nya. Sekiranya Kukatakan Aku tidak mengenal-Nya, jadilah Aku pendusta sepertimu. Aku mengenal-Nya dan taat akan firman-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bapamu Ibrahim bersukacita melihat hari-Ku. Dia melihatnya dan bergembira.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Orang Yahudi berkata kepada-Nya, ‘Usia-Mu belum sampai lima puluh tahun. Bagaimana Kamu mungkin berjumpa dengan Ibrahim?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Isa berkata kepada mereka, ‘Apa yang Kukatakan ini benar, sebelum Ibrahim dilahirkan Aku sudah ada.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Setelah itu mereka memungut batu untuk merejam Isa, tetapi Isa menyembunyikan diri-Nya lalu meninggalkan rumah ibadat. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ketika Isa sedang lalu di suatu tempat, Dia terpandang seorang lelaki yang buta sejak lahir. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Para pengikut-Nya bertanya, ‘Tuan Guru, siapakah yang berdosa, orang itu atau ibu bapanya, maka dia dilahirkan buta?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Isa menjawab, ‘Bukan dia dan bukan juga ibu bapanya. Dia begitu supaya kuasa Allah dapat dinyatakan melaluinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Selagi siang, kita mesti melakukan tugas Dia yang telah mengutus-Ku. Malam akan tiba apabila seorang tidak dapat melakukan apa-apa lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Selama Aku di dunia, Akulah cahaya dunia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Selepas itu, Isa berludah ke tanah untuk membuat tanah liat lalu menyapukannya pada mata orang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Isa berkata kepadanya, ‘Pergilah basuh mukamu di Kolam Siloam’ (Siloam bererti ‘diutus’ dalam bahasa Ibrani). Orang itu pun pergi membasuh muka. Apabila dia kembali, dia sudah dapat melihat. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jiran tetangga dan semua orang yang tahu dia buta bertanya, ‘Bukankah orang ini yang selalu duduk meminta sedekah?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ada yang berkata, ‘Ya, dialah.’ Ada pula yang berkata, ‘Bukan, hanya serupa dengannya.’ Tetapi orang itu sendiri mengaku, ‘Akulah orang itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mereka bertanya kepadanya, ‘Bagaimanakah sekarang kamu dapat melihat?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Dia menjawab, ‘Orang yang bernama Isa telah membuat secebis tanah liat, disapukan-Nya ke mataku lalu berkata, “Pergilah basuh mukamu di Kolam Siloam.” Sebaik-baik sahaja aku membasuh muka di kolam itu, aku pun dapat melihat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mereka bertanya, ‘Di manakah orang itu?’ Dia menjawab, ‘Aku tidak tahu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Orang yang dahulunya buta itu dibawa mereka kepada orang Farisi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Isa telah membuat tanah liat dan menyembuhkan mata orang itu pada hari Sabat. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Orang Farisi menanya orang itu bagaimana dia dapat melihat. Jawabnya, ‘Dia menyapukan tanah liat pada mataku, lalu aku membasuh muka, dan kemudian aku dapat melihat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sebilangan orang Farisi itu berkata, ‘Dia bukan daripada Allah, kerana Dia melanggar peraturan hari Sabat.’ Tetapi ada pula yang berkata, ‘Kalau Dia orang berdosa, bagaimana Dia dapat melakukan mukjizat begini?’ Dengan demikian timbullah perselisihan pendapat di kalangan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Orang Farisi bertanya lagi kepada orang yang dahulunya buta itu, ‘Kamu berkata Dia menyembuhkan matamu. Bagaimana pendapatmu tentang Dia?’ Orang itu menjawab, ‘Dia seorang nabi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Orang Yahudi enggan percaya bahawa orang itu dahulu buta matanya. Oleh itu mereka memanggil ibu bapanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mereka bertanya, ‘Benarkah dia anak kamu yang buta sejak lahir? Bagaimana pula dia boleh celik?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ibu bapa orang itu menjawab, ‘Ya, benar dia anak kami yang buta sejak lahir. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tetapi kami tidak tahu bagaimana dia dapat melihat sekarang dan siapa yang menyembuhkan matanya. Dia sudah dewasa, tanyalah dia. Dia dapat menjawab sendiri.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ibu bapa orang itu berkata demikian kerana takut akan orang Yahudi itu yang telah bersetuju bahawa sesiapa yang mengakui Isa itu al-Masih akan disingkirkan dari saumaah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Maka itulah ibu bapanya berkata, ‘Dia sudah dewasa, tanyalah dia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mereka pun memanggil orang itu lagi dan berkata, ‘Akuilah kemuliaan Allah! Kamu tahu Dia itu orang berdosa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dia menjawab, ‘Sama ada Dia orang berdosa atau tidak, aku tidak tahu. Yang kutahu, dulu aku buta, sekarang aku dapat melihat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mereka bertanya lagi, ‘Apa yang dibuat-Nya kepadamu? Bagaimana Dia mencelikkan matamu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Dia menjawab, ‘Aku telah pun memberitahumu, tetapi kamu tidak mendengar. Mengapakah kamu hendak mendengarnya lagi? Adakah kamu ingin menjadi pengikut-Nya juga?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mereka mencacinya dan berkata, ‘Kamulah pengikut-Nya. Kami pengikut Musa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kami tahu Allah berfirman kepada Musa. Orang itu, tiada siapa yang tahu dari mana Dia datang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","‘Hairan sekali,’ kata orang yang dahulunya buta itu. ‘Kamu tidak tahu dari mana Dia datang, tetapi Dia telah mencelikkan mataku! ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kita tahu bahawa Allah tidak mendengar permintaan orang berdosa. Tetapi jika seseorang takut akan Allah dan melakukan kehendak-Nya, Allah akan mendengar permintaan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sejak permulaan dunia, belum pernah kedengaran kisah orang yang dapat mencelikkan mata orang yang buta sejak lahir. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Jika orang itu bukan daripada Allah, tidaklah dapat Dia melakukannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mereka berkata kepadanya, ‘Kamu orang berdosa sejak lahir. Kamu hendak cuba mengajar kami?’ Mereka pun menghalaunya keluar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Isa mendengar bahawa mereka telah menghalaunya keluar, dan selepas menemuinya, Dia bertanya, ‘Adakah kamu percaya kepada Putera Insan? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Orang itu menjawab, ‘Siapakah Dia, Junjungan? Katakanlah kepadaku, supaya aku dapat percaya kepada-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Isa berkata, ‘Kamu sudahpun melihat-Nya. Dialah yang sedang bercakap denganmu sekarang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Orang itu berkata, ‘Ya Junjungan, aku percaya.’ Dia pun sujud kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Isa berkata, ‘Aku datang ke dunia ini untuk menghakimi manusia; supaya orang buta dapat melihat, manakala orang yang dapat melihat pula buta.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ketika orang Farisi di situ mendengar kata-kata Isa, mereka bertanya kepada-Nya, ‘Adakah Kaumaksudkan kami juga buta?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Isa menjawab, ‘Kalaulah kamu buta, tidaklah kamu berdosa. Tetapi kamu berkata kamu dapat melihat, maka kamu tetap berdosa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","‘Sesungguhnya Aku berkata kepadamu, jika seseorang memasuki kandang domba dengan cara lain, bukan melalui pintu, orang itu pencuri dan perompak. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Orang yang masuk melalui pintu ialah gembala domba. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Penjaga kandang membuka pintu untuknya, dan kawanan domba itu mendengar suaranya. Dia memanggil nama setiap dombanya. Gembala itu pun memimpin domba-domba itu keluar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Setelah semua domba keluar, gembala itu berjalan di hadapan dan domba-domba mengikutnya kerana mengenal suaranya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kawanan domba itu tidak akan mengikut orang lain, malah akan lari daripadanya, kerana tidak mengenal suaranya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Isa bercerita secara kiasan, tetapi mereka tidak faham akan maksud-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Oleh yang demikian, Isa berkata, ‘Sesungguhnya, Aku berkata kepadamu, Akulah pintu bagi kawanan domba itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Orang yang datang sebelumku adalah pencuri dan perompak, tetapi kawanan domba tidak mengikut suara mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Akulah pintu. Sesiapa yang masuk melalui-Ku akan diselamatkan. Dia boleh keluar masuk, dan dia akan dapat mencari padang rumput. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Pencuri datang untuk mencuri, membunuh dan membinasakan. Tetapi Aku datang supaya manusia mempunyai hidup yang berlimpah-limpah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","‘Akulah gembala yang baik, yang mengorbankan nyawa untuk kawanan dombanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Orang upahan yang bukan gembala atau pemilik kawanan domba itu akan lari apabila melihat serigala datang. Maka serigala menerkam domba itu dan menyebabkannya lari bertempiaran. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Orang upahan itu lari kerana dia bekerja semata-mata untuk mendapat upah. Dia tidak peduli akan kawanan domba itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","‘Akulah gembala yang baik. Aku mengenal domba-domba-Ku dan domba-domba-Ku mengenal-Ku, ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","sebagaimana Bapa mengenal-Ku, dan Aku mengenal-Nya. Aku mengorbankan nyawa-Ku untuk domba-domba-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ada domba-domba lain diluar kawanan ini yang Kumiliki. Mereka juga mesti Kupimpin, dan mereka akan mengikut suara-Ku. Kesemuanya akan menjadi satu kawanan dengan satu gembala. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bapa mengasihi-Ku kerana Aku sanggup menyerahkan nyawa-Ku agar dapat mengambilnya semula nanti. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Sesiapapun tidak dapat meragut nyawa-Ku. Aku menyerahkannya dengan rela. Aku berkuasa menyerahkan nyawa-Ku dan berkuasa mengambilnya semula. Inilah tugas yang Kuterima daripada Bapa-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Setelah mendengar kata-kata Isa, orang Yahudi berselisih pendapat lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sebilangan besar berkata, ‘Dia dirasuk roh iblis! Dia tidak siuman! Mengapa kamu mendengar katanya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Namun, ada yang berkata, ‘Orang yang dirasuk roh iblis tidak akan dapat bercakap begini. Dan bagaimanakah roh iblis dapat mencelikkan orang buta?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Di Baitulmaqdis, Perayaan Pentahbisan sedang disambut. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ketika itu musim sejuk, dan Isa sedang berjalan di serambi Sulaiman di dalam rumah ibadat. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Orang Yahudi pun berkumpul di sekeliling-Nya lalu berkata, ‘Sampai bilakah Engkau membiarkan kami bertanya-tanya? Katakanlah dengan jelas: Adakah Engkau ini al-Masih?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Isa menjawab, ‘Aku sudahpun mengatakannya kepada kamu, tetapi kamu tidak mahu percaya. Segala yang Kulakukan dengan kuasa Bapa-Ku memberi kesaksian tentang diri-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kamu tidak percaya kerana kamu bukan kawanan domba-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Domba-domba-Ku mendengar suara-Ku. Aku mengenal mereka dan mereka mengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aku memberi mereka hidup yang kekal. Mereka tidak akan binasa. Tiada siapa dapat merampas mereka daripada tangan-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bapa-Ku yang mengurniakan mereka kepada-Ku lebih besar daripada siapapun. Tiada siapa dapat merampas mereka daripada Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bapa dan Aku adalah satu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Selepas itu orang Yahudi yang hadir pun memungut batu sekali lagi untuk merejam Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tetapi Isa berkata kepada mereka, ‘Aku telah banyak melakukan perbuatan baik yang diserahkan Bapa kepada-Ku. Perbuatan manakah yang mendorong kamu merejam-Ku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Orang Yahudi itu menjawab, ‘Kami hendak merejam Kamu bukan kerana perbuatan-Mu yang baik, tetapi kerana Kamu mengkufuri Allah. Kamu hanyalah seorang manusia, tetapi Kamu menganggap diri-Mu Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Isa berkata kepada mereka, ‘Tidakkah tersurat di dalam hukum Taurat kamu: Allah berfirman, “Kamu ilahi”? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jika Allah menyebut orang sebagai “ilahi” kerana firman Allah ditujukan kepada mereka, (apa yang tersurat di dalam kitab itu tidak dapat dibatalkan) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","bagaimana dengan Dia yang telah disucikan dan diutus ke dunia oleh Bapa? Wajarkah kamu katakan Aku mengkufuri Allah kerana Aku berkata, “Aku Putera Allah”? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Andainya Aku tidak melakukan kehendak Bapa, janganlah percaya kepada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tetapi jika Aku melakukannya, percayalah kepada apa yang Kulakukan, kalaupun kamu tidak percaya kepada-Ku. Dengan demikian akan fahamlah kamu bahawa Bapa di dalam Aku dan Aku di dalam Bapa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mereka mencuba lagi menangkap Isa, tetapi Isa dapat melepaskan diri dari tangan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Isa kembali ke seberang Sungai Yordan lalu tinggal di tempat Yahya mengimadkan orang dahulu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ramai orang datang kepada Isa. Mereka berkata, ‘Yahya tidak melakukan mukjizat, namun kata-katanya tentang orang ini semuanya benar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ramai orang di kawasan itu percaya kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pada suatu ketika, seorang lelaki bernama Lazarus jatuh sakit. Dia tinggal di Baitani bersama dua orang saudara perempuannya bernama Maryam dan Marta. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maryamlah, yang saudaranya Lazarus sedang sakit, merupakan seorang perempuan yang dahulu pernah menuangkan minyak wangi ke kaki Junjungan dan menyapunya dengan rambutnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kedua-dua beradik perempuan itu mengirim khabar kepada Isa, ‘Junjungan, dia yang Kaukasihi itu sakit.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Apabila menerima berita itu, Isa berkata, ‘Sakit Lazarus tidak akan membawa maut. Hal ini berlaku untuk memuliakan Allah. Disebabkan kejadian ini Putera Allah akan dimuliakan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Isa mengasihi Marta, Maryam dan Lazarus. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tetapi apabila Dia mendapat berita Lazarus sakit, Dia sengaja tinggal di tempat itu dua hari lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kemudian Dia berkata kepada para pengikut-Nya, ‘Marilah kita pulang ke Yudea.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Para pengikut-Nya menjawab, ‘Tuan Guru, bukankah orang Yahudi di situ baru saja hendak merejam-Mu? Sekarang Engkau hendak pulang ke situ?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Isa berkata, ‘Bukankah waktu siang dua belas jam lamanya? Orang yang berjalan pada waktu siang tidak akan tersandung kakinya, kerana masih ada cahaya di dunia ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tetapi jika dia berjalan pada waktu malam, kakinya akan tersandung kerana sudah tiada cahaya lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kemudian Isa menambah, ‘Sahabat kita Lazarus sedang tidur. Aku akan pergi membangunkannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Para pengikut Isa berkata, ‘Junjungan, sekiranya Lazarus tidur, dia akan sembuh.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yang dimaksudkan oleh Isa ialah Lazarus sudah meninggal dunia, tetapi para pengikut-Nya mengambil erti tidur yang biasa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Oleh itu, Isa berkata kepada mereka dengan jelas, ‘Lazarus sudah meninggal. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tetapi, untuk kebaikanmu, Aku bersyukur Aku tidak bersamanya ketika itu. Dengan demikian kamu akan percaya kepada-Ku. Marilah kita pergi kepadanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas yang disebut Didimus berkata kepada pengikut Isa yang lain. ‘Ya, marilah kita pergi juga supaya kita mati bersama-Nya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ketika Isa sampai, Dia mendapati Lazarus sudah empat hari di dalam makam. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Baitani terletak kira-kira dua batu daripada Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Oleh itu ramai orang Yahudi datang melawat Maryam dan Marta untuk melipurkan hati mereka yang duka kerana kematian Lazarus. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Apabila Marta mendengar Isa datang, dia terus pergi untuk menyambut-Nya, manakala Maryam tinggal di rumah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta berkata kepada Isa, ‘Ya Junjungan, kalaulah Junjungan ada di sini pada waktu itu, tentu saudaraku masih hidup! ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Aku tahu, sekarang pun apa saja permintaan Junjungan akan dikabulkan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Isa berkata kepada Marta, ‘Saudaramu akan hidup kembali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta menjawab, ‘Aku tahu Lazarus akan hidup kembali pada hari akhir.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Isa berkata kepada Marta, ‘Akulah kebangkitan dan hidup. Sesiapa yang percaya kepada-Ku akan hidup, meskipun dia sudah mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Orang hidup yang percaya kepada-Ku tidak akan mati selama-lamanya. Percayakah kamu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta menjawab, ‘Ya Junjungan, aku percaya bahawa Junjungan adalah al-Masih, Putera Allah, yang diutus oleh Allah, dan yang akan datang ke dunia ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Setelah itu, Marta pergi memanggil saudaranya Maryam dan berbisik kepadanya, ‘Guru ada di sini. Dia memanggilmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maryam pun segera bangun lalu pergi untuk berjumpa Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Pada waktu itu Isa belum sampai di kampung mereka. Dia masih di tempat Marta menyambut-Nya.) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Apabila orang Yahudi yang ada di rumah Maryam untuk melipurkan hatinya itu melihat dia segera bangun lalu keluar, mereka pun mengikutnya kerana menyangka dia hendak ke makam Lazarus untuk menangisinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Setelah Maryam melihat Isa, dia berlutut di kaki-Nya lalu berkata, ‘Junjungan, kalaulah Engkau ada di sini pada waktu itu, tentu saudaraku masih hidup!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ketika melihat Maryam menangis dan semua orang Yahudi yang bersamanya, turut mengalirkan air mata, Isa sungguh hiba dan terharu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dia bertanya kepada mereka, ‘Di manakah kamu letakkan dia?’ Mereka menjawab, ‘Marilah lihat, Ya Junjungan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Isa menangis. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Semua orang Yahudi yang hadir berkata, ‘Lihatlah! Dia sungguh kasih akan Lazarus.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Namun, ada yang berkata, ‘Dia dapat mencelikkan orang buta. Tidakkah Dia dapat mengelakkan kematian Lazarus?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Isa yang masih terharu pergi ke makam Lazarus, iaitu sebuah gua yang ditutup dengan batu besar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Isa berkata, ‘Alihkan batu itu.’ Tetapi Marta berkata, ‘Junjungan, sudah empat hari dia dimakamkan, tentu berbau.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Isa berkata kepada Marta, ‘Bukankah sudah Kukatakan kepadamu, kalau kamu percaya, kamu dapat melihat kemuliaan Allah?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mereka mengalihkan batu itu. Isa menengadah ke langit lalu berkata, ‘Ya Bapa, Aku bersyukur kepada-Mu kerana Engkau mendengar permintaan-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aku tahu Engkau memang sentiasa mendengar permintaan-Ku. Aku menyebutnya untuk kebaikan semua orang di sini, supaya mereka percaya Engkau mengutus-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Selepas itu, Isa berseru lantang, ‘Lazarus, keluar!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazarus pun keluar. Tangan dan kakinya masih berbalut kain kafan, mukanya masih dilitupi kain penutup muka. Isa berkata kepada orang ramai di situ, ‘Lucutkan kain kafannya dan lepaskan dia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sebilangan besar orang yang datang melawat Maryam dan melihat apa yang dilakukan oleh Isa terus percaya kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Namun, ada yang pulang mendapatkan orang Farisi dan melaporkan hal itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Oleh yang demikian, orang Farisi dan ketua imam mengadakan mesyuarat Majlis Agama. Mereka berkata, ‘Apakah yang patut kita buat? Lihatlah, orang itu banyak melakukan mukjizat! ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jika kita biarkan Dia terus melakukannya, semua orang akan percaya kepada-Nya. Nanti orang Rom akan datang memusnahkan kedudukan dan bangsa kita!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Salah seorang daripada mereka bernama Kayafas, seorang imam besar pada tahun itu, berkata pula, ‘Kamu semua tidak tahu suatu apapun. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kamu tidak faham bahawa lebih baik satu orang mati untuk bangsa kita, daripada seluruh bangsa kita dimusnahkan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafas bukanlah melahirkan pendapatnya sendiri. Sebagai imam besar tahun itu, dia bernubuat bahawa Isa akan mati untuk bangsa Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Sebenarnya Isa mati bukan untuk bangsa Yahudi sahaja, tetapi untuk menyatukan seluruh anak Allah yang berselerak di merata-rata tempat. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sejak hari itu, orang Yahudi berpakat hendak membunuh Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Isa tidak lagi pergi ke sana ke mari secara terbuka di antara orang Yahudi. Dia pergi ke bandar bernama Efraim dekat gurun, dan menetap di sana bersama para pengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Menjelang perayaan Paska, ramai orang Yahudi dari kampung pergi ke Baitulmaqdis untuk menjalani upacara bersuci sebelum perayaan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mereka mencari Isa. Ketika di rumah ibadat, mereka bertanya sesama sendiri, ‘Bagaimana fikiranmu? Datangkah Dia ke perayaan ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ketua imam dan orang Farisi telah mengeluarkan perintah bahawa sesiapa yang tahu di mana Isa berada mesti melaporkannya supaya Dia dapat ditangkap. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Enam hari sebelum perayaan Paska, Isa pergi ke Baitani, tempat tinggal Lazarus yang telah dibangkitkan-Nya daripada kematian. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Di situ Dia diperjamu. Marta menghidangkan makanan, dan Lazarus serta tetamu lain bertelekan di meja bersama Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kemudian Maria membawa sepaun minyak narwastu murni yang mahal, dan menuangkannya ke kaki Isa, lalu menyapu kaki Isa dengan rambutnya. Semerbaklah keharuman minyak itu di seluruh rumah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yudas Iskariot, salah seorang pengikut Isa yang mengkhianati-Nya kelak berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","‘Mengapakah minyak wangi ini tidak dijual dengan harga tiga ratus keping wang perak, supaya wangnya dapat disedekahkan kepada orang miskin?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudas berkata demikian bukanlah kerana dia prihatin terhadap orang miskin, tetapi kerana dia yang diamanahkan menyimpan wang bagi mereka sering mencuri sedikit untuk keperluannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Isa berkata, ‘Jangan bantah perbuatan perempuan ini. Apa yang dilakukannya dimaksudkan untuk hari penguburan-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Orang miskin sentiasa ada di sekitarmu, tetapi Aku tidaklah sentiasa bersamamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Apabila orang Yahudi mendengar Isa ada di Baitani, ramai yang ke situ bukan hanya untuk melihat-Nya tetapi juga Lazarus yang telah dibangkitkan-Nya daripada kematian. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ketua imam merancang hendak membunuh Lazarus juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ini disebabkan ramai orang Yahudi telah berpaling daripada mereka dan percaya kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pada keesokan harinya, orang ramai yang datang menyambut perayaan Paska mendengar bahawa Isa sedang dalam perjalanan ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mereka mengambil dahan-dahan pohon palma lalu pergi mengalu-alukan Isa sambil berseru, ‘Hosana!’ ‘Diberkatilah Dia yang datang dengan nama Tuhan, Raja Israel!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Isa mendapatkan seekor keldai muda lalu menunggangnya. Maka berlakulah apa yang tersurat di dalam Kitab Suci, ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","‘Janganlah takut. Wahai puteri Sion; lihatlah Rajamu datang menunggang seekor keldai muda!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sewaktu itu para pengikut Isa tidak memahami erti segala ini. Setelah Isa dimuliakan melalui kematian dan kebangkitan-Nya, barulah mereka sedar bahawa segala yang dilakukan oleh orang ramai terhadap-Nya telah tersurat di dalam Kitab Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Orang yang mendengar Isa memanggil Lazarus keluar dari makam dan melihat Dia membangkitkannya daripada kematian terus memberi kesaksian tentang kejadian itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Dengan demikian, ramai orang datang berjumpa Isa kerana mendengar tentang mukjizat-Nya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Orang Farisi berkata sesama sendiri, ‘Lihatlah, sia-sia segala usaha kita. Seluruh dunia telah mengikut-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Di antara orang ramai yang pergi ke Baitulmaqdis untuk beribadat pada waktu perayaan itu ada sebilangan orang Yunani. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mereka mendapatkan Filipus, yang berasal dari Betsaida di Galilea, lalu berkata, ‘Tuan, kami ingin bertemu dengan Isa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipus pun memberitahu Andreas lalu mereka berdua pergi menyampaikan hal itu kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Isa berkata kepada mereka, ‘Sudah sampai masanya Putera Insan dimuliakan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sesungguhnya Aku berkata kepadamu: Jika benih gandum tidak jatuh di tanah lalu mati, benih gandum itu hanyalah benih. Tetapi sekiranya benih itu mati, benih itu akan banyak menghasilkan buah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Orang yang sayangkan hidupnya akan kehilangan hidup itu. Tetapi orang yang tidak sayangkan hidupnya di dunia ini akan mendapat hidup yang kekal. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sesiapa yang ingin mengabdi kepada-Ku mesti mengikut-Ku, dan di mana Aku berada, di situlah juga abdi-Ku. Orang yang mengabdi kepada-Ku akan dihormati oleh Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","‘Hati-Ku resah. Apa yang akan Kukatakan? Patutkah Aku berkata, “Bapa, jauhkanlah aku daripada saat penderitaan ini?” Namun, sebab itulah Aku datang menghadap saat ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bapa, tunjukkanlah kemuliaan-Mu!’ Ketika itu kedengaran suara dari langit berkata, ‘Aku sudah menunjukkan kemuliaan-Ku dan Aku akan menunjukkannya lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Antara orang ramai yang mendengar suara itu, ada yang berkata, ‘Guruh.’ Tetapi ada pula yang berkata, ‘Bukan. Malaikat bercakap kepada-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Isa berkata kepada mereka, ‘Suara itu kedengaran bukan demi kepentingan-Ku tetapi demi kepentinganmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sudah sampailah masanya dunia ini dihakimi. Kini pemerintah dunia ini akan digulingkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Apabila Aku diangkat tinggi di atas bumi, Aku akan menarik semua manusia kepada-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kata-kata Isa ini membayangkan cara kematian-Nya kelak. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Orang ramai berkata kepada Isa, ‘Di dalam hukum Taurat ada tersurat bahawa al-Masih yang diutus Allah akan hidup selama-lamanya. Bagaimana kamu pula mengatakan bahawa Putera Insan akan diangkat tinggi di atas bumi? Siapakah Putera Insan itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Isa menjawab, ‘Cahaya itu akan menyertaimu sebentar sahaja lagi. Teruslah berjalan selagi ada cahaya itu sebelum kegelapan menyelubungimu. Seseorang yang berjalan dalam kegelapan tidak tahu ke mana arah tujuannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Selagi ada cahaya itu menyertaimu, percayalah kepadanya, supaya kamu menjadi anak-anak cahaya.’ Setelah berkata-kata demikian, Isa meninggalkan tempat itu lalu bersembunyi daripada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mereka tetap tidak percaya kepada-Nya walaupun telah banyak melihat mukjizat-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dengan demikian berlakulah nubuat Nabi Yasyaya: ‘Ya Tuhan, siapakah yang percaya akan perkhabaran kami? Kepada siapakah tangan Tuhan ditunjukkan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Itulah maka mereka tidak percaya, sebagaimana kata Yasyaya lagi: ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‘Dia telah membutakan mata mereka dan menjadikan mereka keras hati, supaya mata mereka tidak dapat melihat, dan hati mereka tidak dapat mengerti, lalu mereka tidak berpaling kepada-Ku untuk Kusembuhkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yasyaya berkata demikian kerana dia telah melihat kemuliaan-Nya serta berkata-kata tentang-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sebenarnya banyak juga pemerintah yang percaya kepada Isa. Namun, disebabkan orang Farisi itu, mereka tidak berani mengakui-Nya secara terbuka kerana takut disingkirkan daripada saumaah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mereka lebih mencintai pujian manusia daripada pujian Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Isa berseru, ‘Sesiapa yang percaya kepada-Ku, juga percaya kepada Dia yang mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Sesiapa yang melihat-Ku, juga melihat Dia yang mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Aku datang ke dunia ini sebagai cahaya, supaya manusia yang percaya kepada-Ku tidak akan terus tinggal dalam kegelapan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","‘Sekiranya seseorang mendengar kata-kata-Ku tetapi tidak mematuhinya, Aku tidak akan menghukumnya. Aku datang bukan untuk menghukum dunia ini tetapi untuk menyelamatkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ada hakim bagi sesiapa yang tidak menerima-Ku dan kata-kata-Ku. Kata-kata yang Kusampaikan itulah yang akan menghakiminya pada hari akhir. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Aku bercakap bukan mengikut kehendak-Ku sendiri. Bapa yang mengutus-Ku memerintahkan Aku tentang apa yang harus Kukatakan dan bagaimana menyampaikannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aku tahu bahawa perintah-Nya itu membawa hidup kekal. Oleh itu apa yang Kukatakan, Kusampaikan sebagaimana disuruh oleh Bapa-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sebelum perayaan Paska, Isa tahu bahawa telah sampai masanya Dia meninggalkan dunia ini dan pulang kepada Bapa. Setelah mengasihi sekalian orang yang menjadi milik-Nya di dunia ini, Isa mengasihi mereka hingga ke saat akhir. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Semasa Isa dan pengikut-pengikut-Nya sedang makan malam, Iblis sudahpun menimbulkan niat di hati Yudas anak Simon Iskariot untuk mengkhianati Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Isa tahu bahawa Bapa telah menyerahkan segala perkara kepada-Nya; bahawa Dia datang daripada Allah dan akan pulang kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Dengan demikian, Isa berdiri lalu melucutkan jubah-Nya dan mengikat sehelai tuala di pinggang-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kemudian Dia menuang air ke dalam sebuah besen lalu membasuh kaki para pengikut-Nya dan mengeringkannya dengan tuala di pinggang-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ketika Dia sampai kepada Simon Petrus, bertanyalah Simon kepada-Nya, ‘Junjungan, wajarkah Junjungan membasuh kakiku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Isa menjawab, ‘Sekarang kamu tidak mengerti perbuatan-Ku ini tetapi pada kemudian hari kamu akan mengerti.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus berkata kepada Isa, ‘Tidak! Junjungan sekali-kali tidak boleh membasuh kakiku!’ Namun, Isa menjawab, ‘Jika Aku tidak membasuhmu, kamu tidaklah lagi mempunyai bahagian dalam apa yang Kulakukan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Petrus berkata, ‘Junjungan, kalau begitu janganlah basuh kakiku sahaja, basuhlah tangan dan kepalaku juga!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Isa berkata kepadanya, ‘Orang yang sudah mandi telah bersih seluruh tubuhnya, cuma kakinya yang perlu dibasuh. Kamu memang bersih tetapi bukan semua kamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Isa tahu siapa yang akan mengkhianati-Nya. Itulah sebabnya Dia berkata, ‘Bukan semua yang bersih.’) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Setelah membasuh kaki para pengikut-Nya, Isa memakai semula jubah-Nya lalu bertelekan di meja dan berkata kepada mereka, ‘Fahamkah kamu apa yang Kulakukan untukmu? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kamu memanggil-Ku Guru dan Junjungan. Tepatlah panggilanmu itu, kerana Aku memang Guru dan Junjungan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jika Aku sebagai Junjungan dan Gurumu sanggup membasuh kaki kamu, maka haruslah kamu saling membasuh kaki sesama sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aku telah memberi teladan kepada kamu semua. Lakukanlah apa yang telah Kulakukan untukmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sesungguhnya Aku berkata kepadamu, seorang hamba tidak mungkin lebih besar daripada tuannya. Begitu jugalah, seorang yang diutus tidak mungkin lebih besar daripada orang yang mengutusnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sekiranya kamu mengerti hal ini dan melakukannya, diberkatilah kamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‘Apa yang Kukatakan itu bukanlah tentang kesemua kamu. Aku mengenal setiap orang yang telah Kupilih. Tetapi apa yang tersurat di dalam Kitab Suci pasti terjadi, “Orang yang makan bersama-Ku akan berpaling menentang-Ku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","‘Aku memberitahumu hal ini sebelum berlaku supaya setelah terjadi nanti, kamu akan percaya bahawa Akulah Dia. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sesungguhnya Aku berkata kepadamu, sesiapa yang menyambut orang yang Kuutus, menyambut Aku. Sesiapa yang menyambut-Ku, menyambut Dia yang mengutus-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Setelah melafazkan kata-kata itu, Isa berasa gundah. Dia pun berkata dengan terus-terang, ‘Sesungguhnya Aku berkata kepadamu, salah seorang daripadamu akan mengkhianati-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Para pengikut Isa berpandangan, tertanya-tanya dalam hati siapa agaknya yang dimaksudkan oleh Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Salah seorang pengikut yang dikasihi oleh Isa bertelekan di sisi-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Petrus pun memberi isyarat kepadanya, ‘Tanyalah, siapa yang dimaksudkan-Nya itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pengikut itu melayah dekat kepada Isa lalu bertanya, ‘Siapakah dia, ya Junjungan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isa menjawab, ‘Orang yang Kuberi roti yang telah Kucelupkan ke dalam mangkuk, dialah orangnya.’ Isa pun mengambil secebis roti, dicelupkannya lalu diberikannya kepada Yudas anak Simon Iskariot. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sebaik-baik Yudas menerima roti itu, masuklah Iblis ke dalam hatinya. Isa pun berkata kepadanya, ‘Apa yang hendak kaulakukan, segeralah lakukan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tidak seorang pun yang makan di situ tahu apa maksudnya Isa berkata demikian kepada Yudas. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Beberapa orang pengikut Isa menyangka Isa menyuruh Yudas membeli bekalan yang diperlukan untuk perayaan Paska, atau memberi sedekah kepada orang miskin kerana Yudas yang bertanggungjawab atas wang mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas menyambut roti yang dihulurkan oleh Isa lalu segera pergi. Ketika itu hari sudah malam. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Setelah Yudas pergi, Isa berkata, ‘Sekarang Putera Insan dimuliakan, dan Allah dimuliakan melalui-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jika Allah dimuliakan melalui Dia, Allah pun akan memuliakan Dia di dalam diri-Nya segera. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","‘Anak-anak-Ku, Aku tidak akan lama lagi bersamamu. Kamu akan mencari-Ku, tetapi apa yang telah Kukatakan kepada orang Yahudi kini Kukatakan kepadamu juga, “Ke mana Aku pergi, kamu tidak dapat ikut.” ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","‘Inilah perintah baru yang Kuberikan kepadamu: Kasihilah satu sama lain. Sebagaimana Aku telah mengasihimu, kasihilah sesama sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Daripada sikapmu yang saling mengasihi itu, semua orang akan tahu bahawa kamu pengikut-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrus bertanya kepada Isa, ‘Ke mana Junjungan hendak pergi?’ Isa menjawab, ‘Ke mana Aku pergi, kamu tidak dapat mengikut-Ku sekarang, tetapi satu hari nanti kamu akan mengikut-Ku ke situ.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus bertanya lagi, ‘Junjungan, mengapa aku tidak dapat mengikut Engkau sekarang? Aku rela mati untuk-Mu, Junjungan!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Isa menjawab, ‘Benarkah kamu rela mati untuk-Ku? Sesungguhnya Aku berkata kepadamu, sebelum ayam berkokok, kamu akan menyangkal Aku tiga kali. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","‘Janganlah kamu bimbang. Percayalah kepada Allah dan percayalah juga kepada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Di dalam rumah Bapa-Ku ada banyak tempat tinggal. Jika hal ini tidak benar, tidaklah Kukatakan kepadamu. Aku akan pergi menyediakan tempat untukmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jika Aku pergi dan menyediakan tempat untukmu, Aku akan pulang dan membawamu ke tempat-Ku, supaya di tempat Aku berada di situ juga kamu berada. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kamu tahu jalan ke tempat Aku pergi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas berkata kepada Isa, ‘Junjungan, kami tidak tahu ke mana Engkau pergi, bagaimana kami mungkin tahu jalan ke sana?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Isa menjawab, ‘Akulah jalan, kebenaran dan hidup. Tidak seorang pun datang kepada Bapa kecuali melalui-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Dengan mengenal-Ku, kamu mengenal Bapa-Ku juga. Mulai sekarang kamu mengenal-Nya, malah sudahpun melihat-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipus berkata kepada Isa, ‘Junjungan, tunjukkanlah Bapa kepada kami, supaya puaslah hati kami.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Isa menjawab, ‘Sekian lama aku bersama kamu semua, belum lagi kau kenal Aku, Filipus? Sesiapa yang telah melihat-Ku, telah melihat Bapa. Mengapa kamu berkata, “Tunjukkanlah Bapa kepada kami?” ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filipus, tidakkah kamu percaya bahawa Aku di dalam Bapa, dan Bapa di dalam-Ku? Segala yang Kukatakan kepadamu bukanlah daripada-Ku, tetapi daripada Bapa yang tinggal di dalam-Ku yang melakukan semua pekerjaan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Percayalah kepada-Ku, bahawa Aku di dalam Bapa, dan Bapa di dalam-Ku. Kalaupun kamu tidak percaya akan apa yang Kukatakan, percayalah kepada-Ku kerana apa yang telah Kulakukan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sesungguhnya Aku berkata kepadamu, sesiapa yang percaya kepada-Ku akan melakukan apa yang Kulakukan, malah pekerjaan lebih besar lagi, kerana Aku pergi kepada Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Apa sahaja yang kamu minta dengan nama-Ku, Aku akan melakukannya supaya kemuliaan Bapa ternyata melalui Putera-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Apa sahaja yang kamu minta daripada-Ku dengan nama-Ku akan Kulakukan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‘Jika kamu mengasihi-Ku, kamu akan mematuhi perintah-perintah-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aku akan memohon kepada Bapa dan Bapa akan mengurniaimu Penolong yang akan menyertaimu selama-lamanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Penolong itu Roh Kebenaran. Dunia tidak dapat menerima-Nya kerana tidak dapat melihat atau mengenal-Nya. Tetapi kamu mengenal-Nya kerana Dia tetap dalammu dan akan ada dalam dirimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aku tidak akan meninggalkanmu seperti anak yatim piatu. Aku akan datang lagi mendapatkanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tidak lama lagi, dunia tidak akan melihat-Ku lagi, tetapi kamu akan melihat-Ku. Oleh sebab aku hidup, kamu juga akan hidup. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Setelah tiba hari itu, kamu akan tahu bahawa Aku di dalam Bapa, kamu di dalam-Ku, dan Aku juga di dalammu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Sesiapa yang menerima dan mematuhi perintah-perintah-Ku, mengasihi-Ku. Sesiapa yang mengasihi-Ku akan dikasihi oleh Bapa-Ku, dan Aku juga akan mengasihinya serta memperlihatkan diri-Ku kepadanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudas (bukan Yudas Iskariot) berkata kepada Isa, ‘Junjungan, mengapa Engkau memperlihatkan diri kepada kami tetapi tidak kepada dunia?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Isa menjawab, ‘Sesiapa yang mengasihi-Ku akan menurut ajaran-Ku. Bapa-Ku akan mengasihinya. Dan Kami akan datang kepadanya serta tinggal bersamanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Orang yang tidak mengasihi-Ku tidak menurut ajaran-Ku, pada hal ajaran itu bukan daripada-Ku, tetapi daripada Bapa yang mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‘Aku memberitahumu semua ini ketika Aku masih tinggal bersamamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Namun, Penolong, iaitu Roh Suci yang akan diutus Allah dalam nama-Ku, akan mengajarmu segala-galanya dan mengingatkanmu tentang apa yang telah Kukatakan kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Sejahtera Kutinggalkan bagimu. Sejahtera-Ku sendiri Kuberikan kepadamu. Apa yang Kuberikan kepadamu bukan seperti yang disogokkan oleh dunia. Usah risau dan janganlah takut. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Kamu telah mendengar Aku berkata, “Aku akan pergi, tetapi Aku akan datang lagi mendapatkanmu.” Sekiranya kamu mengasihi-Ku, kamu akan gembira bahawa Aku pergi kepada Bapa kerana Bapa lebih besar daripada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Semua ini Kukatakan kepadamu sebelum terjadi, supaya ketika berlaku nanti, kamu akan percaya kepada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aku tidak dapat bercakap lama lagi denganmu, kerana sudah tiba waktunya pemerintah dunia ini datang. Sebenarnya dia tidak berkuasa ke atas diri-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Namun, Aku menjalankan semua perintah Bapa, supaya dunia tahu bahawa Aku mengasihi Bapa. ‘Bangkitlah, marilah kita beredar dari sini. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","‘Aku ini pokok anggur yang benar, dan Bapa-Ku peladang anggur. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Dia mengerat setiap ranting-Ku yang tidak berbuah, dan mencantas setiap ranting-Ku yang berbuah supaya bersih dan berbuah lebih lebat lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kamu sudah dibersihkan dengan ajaran yang Kusampaikan kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tetaplah dalam-Ku seperti Aku dalammu. Ranting tidak dapat berbuah jika terpisah dari pokok. Demikian jugalah kamu: Kamu dapat berbuah hanya jika kamu tetap dalam-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‘Aku pokok anggur dan kamu ranting-rantingnya. Jika kamu tetap dalam-Ku dan Aku dalam-Mu, kamu akan berbuah lebat. Tanpa-Ku, kamu tidak dapat menghasilkan apa-apa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sesiapa yang tidak tetap dalam-Ku adalah seperti ranting yang dikerat lalu dibiarkan kering, kemudian dikumpulkan, dan dibuang ke dalam api lalu dibakar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Sekiranya kamu tetap dalam-Ku, dan kata-kata-Ku tetap dalammu, mintalah apa sahaja yang kamu kehendaki, permohonan itu akan dikabulkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kemuliaan Bapa ternyata apabila kamu berbuah lebat. Itulah tanda kamu benar-benar pengikut-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","‘Sebagaimana Bapa mengasihi-Ku, demikianlah juga Aku mengasihimu. Tetaplah dalam kasih-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jika kamu menurut perintah-Ku, kamu akan tetap dalam kasih-Ku; sebagaimana Aku menurut perintah Bapa dan tetap dalam kasih-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Aku berkata demikian kepadamu supaya kebahagiaan-Ku ada dalam dirimu dan sempurnalah kebahagiaanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Inilah perintah-Ku: Kasihilah sesama sendiri, seperti Aku mengasihimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tiada kasih yang lebih besar daripada kasih seorang yang mengorbankan nyawanya untuk sahabatnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kamu sahabat-sahabat-Ku jika kamu melaksanakan perintah yang telah Kuberikan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aku tidak lagi memanggilmu hamba, kerana hamba tidak tahu apa yang dilakukan oleh tuannya. Aku memanggilmu sahabat-sahabat-Ku, kerana segala perkara yang Kudengar daripada Bapa-Ku telah Kuberitahu kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bukan kamu yang memilih-Ku tetapi Aku yang memilihmu dan menyuruhmu berbuah lebat, dan buahmu itu haruslah kekal, maka Bapa akan mengabulkan apa sahaja permohonanmu dalam nama-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Inilah perintah-Ku kepadamu: Kasihilah sesama sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","‘Jika dunia membencimu, ketahuilah, dunia telah membenci-Ku terlebih dahulu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Andainya kamu milik dunia, dunia akan mengasihimu seperti anak-anaknya sendiri. Tetapi aku telah memilihmu dan kamu bukan lagi milik dunia. Maka itulah dunia membencimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ingatlah apa yang telah Kukatakan kepadamu, “Seorang hamba tidaklah lebih besar daripada tuannya.” Jika mereka menganiaya-Ku, mereka akan menganiayamu juga. Jika mereka menurut kata-kata-Ku, mereka akan menurut kata-katamu juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Semua itu akan dilakukan mereka terhadapmu, kerana nama-Ku, dan mereka tidak mengenal Dia yang mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kalaulah Aku tidak datang dan bercakap kepada mereka, tidaklah mereka berdosa. Tetapi sekarang mereka tidak mempunyai alasan bagi dosa mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sesiapa yang membenci-Ku, membenci Bapa-Ku juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sekiranya Aku tidak melakukan perkara-perkara yang belum pernah dilakukan orang di hadapan mata mereka, mereka tidaklah berdosa. Tetapi mereka telah melihat sendiri apa yang Kulakukan dan mereka tetap membenci-Ku dan Bapa-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hal ini semestinya begitu, supaya berlaku apa yang tersurat di dalam Taurat mereka: “Mereka membenci-Ku tanpa alasan.” ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","‘Apabila Penolong, Roh Kebenaran daripada Bapa, yang Kuutus kepadamu datang, Dia akan bersaksi tentang-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kamu juga akan bersaksi tentang-Ku, kerana kamu semua bersama-Ku dari mula lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","‘Semua ini Kukatakan kepadamu supaya kamu tidak sesat. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mereka akan menyingkirkanmu daripada saumaah. Masanya akan tiba ketika semua orang yang membunuhmu menganggap bahawa dengan berbuat demikian dia mengabdi kepada Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Perkara ini akan dilakukan oleh mereka, kerana mereka belum mengenal Bapa mahupun Aku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Semua ini Kukatakan kepadamu supaya ketika berlaku nanti, kamu akan ingat bahawa Aku sudahpun memberitahumu. Aku tidak memberitahumu dari mulanya lagi kerana Aku masih bersamamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","‘Tetapi sekarang Aku akan pergi kepada Dia yang mengutus-Ku. Tidak seorang pun antaramu bertanya, “Ke mana Aku hendak pergi?” ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sekarang kamu bersedih, kerana Aku telah memberitahu perkara ini kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Apa yang Kukatakan kepadamu ini benar; untuk kepentinganmu, baiklah Aku pergi. Selagi Aku tidak pergi, Penolong itu tidak akan datang kepadamu. Jika Aku pergi, Aku akan mengutus-Nya kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Setelah Dia datang nanti, Dia akan menginsafkan dunia tentang dosa, kebenaran, dan penghakiman; ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","tentang dosa kerana mereka tidak percaya kepada-Ku; ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","tentang kebenaran kerana Aku akan pergi kepada Bapa dan kamu tidak akan melihat-Ku lagi; ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","dan tentang penghakiman kerana pemerintah dunia ini telah dihakimi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‘Ada banyak lagi yang ingin Kukatakan kepadamu, tetapi kamu belum berupaya menerimanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tetapi apabila Dia, iaitu Roh Kebenaran, datang Dia akan membimbingmu ke arah segala kebenaran. Roh itu tidak akan mengatakan sesuatu menurut kehendak-Nya sendiri. Dia akan menyampaikan apa yang didengar-Nya dan memberitahumu apa yang akan terjadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Roh itu akan memuliakan-Ku, kerana Dia akan menerima apa yang berasal daripada-Ku dan menyatakannya kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Segala milik Bapa-Ku milik-Ku juga. Maka itulah Kukatakan bahawa Dia akan menerima apa yang berasal daripada-Ku dan menyatakannya kepadamu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Isa berkata, ‘Tidak lama lagi, kamu tidak akan melihat-Ku dan tidak lama kemudian, kamu akan melihat-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Sebilangan pengikut Isa tertanya-tanya sesama sendiri, ‘Apakah maksud kata-Nya, “Tidak lama lagi kamu tidak akan melihat-Ku, dan tidak lama kemudian kamu akan melihat-Ku”? Dia juga berkata, “Aku akan pergi kepada Bapa.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mereka berkata, ‘Apakah maksud “tidak lama lagi”? Kami tidak faham erti kata-kata-Nya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isa tahu bahawa mereka ingin bertanya kepada-Nya. Lalu kata-Nya kepada mereka, ‘Tadi Aku berkata, “Tidak lama lagi kamu tidak akan melihat-Ku, dan tidak lama kemudian kamu akan melihat-Ku.” Adakah kamu mempersoalkan kata-Ku itu? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sesungguhnya Aku berkata kepadamu, kamu akan menangis dan meratap, tetapi dunia akan bersuka ria. Kamu akan bersedih, namun kesedihanmu akan berubah menjadi kegembiraan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Apabila seorang perempuan hendak melahirkan anak, dia menderita kesakitan kerana masanya sudah tiba. Tetapi sebaik sahaja anak itu lahir, dia lupa akan penderitaannya. Dia bersukacita kerana seorang anak telah lahir ke dunia. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Begitulah juga kamu bersedih sekarang, tetapi Aku akan menemui kamu lagi. Hatimu akan dipenuhi kegembiraan, yang tidak dapat diragut oleh sesiapapun. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Pada ketika itu, kamu tidak akan bertanya apa-apa lagi kepada-Ku. Sesungguhnya Aku berkata kepadamu, apa sahaja yang kamu minta dalam nama-Ku, Bapa akan mengurniakannya kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hingga saat ini belum pernah kamu minta sesuatu dalam nama-Ku. Mintalah, kamu akan menerimanya dan sempurnalah kegembiraanmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","‘Aku telah mengatakan semua ini kepadamu secara kiasan. Tetapi akan sampai ketikanya Aku tidak lagi menggunakan kiasan; Aku akan berterus-terang kepadamu tentang Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pada hari itu, kamu akan meminta dalam nama-Ku. Aku tidak berkata Aku akan meminta kepada Bapa bagi pihakmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bapa sendiri mengasihimu, kerana kamu mengasihi-Ku dan percaya Aku datang daripada Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Aku memang berasal daripada Bapa dan datang ke dunia. Tetapi sekarang Aku meninggalkan dunia ini dan pulang semula kepada Bapa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Para pengikut-Nya berkata, ‘Sekarang barulah Junjungan bercakap terus-terang, tanpa menggunakan kiasan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sekarang kami faham bahawa Junjungan mengetahui segala-galanya dan sesiapapun tidak perlu lagi bertanya apa-apa kepada-Mu. Oleh itu kami percaya bahawa Junjungan datang daripada Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Isa berkata kepada mereka, ‘Percayakah kamu sekarang? ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Saatnya akan datang, malah sudahpun sampai, ketika kamu akan bertempiaran. Kamu akan menjaga diri masing-masing, dan meninggalkan Aku keseorangan. Tetapi sebenarnya Aku tidaklah keseorangan, kerana Bapa bersama-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","‘Segala ini Kukatakan kepadamu supaya kamu beroleh sejahtera di dalam Aku. Di dalam dunia kamu akan menghadapi pancaroba; tetapi tabahkanlah hatimu, kerana Aku telah menewaskan dunia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Setelah itu, Isa menengadah ke langit lalu berkata, ‘Bapa, sudah sampailah saatnya. Muliakanlah Putera-Mu, supaya Putera-Mu dapat memuliakan Bapa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Engkau telah memberi Putera-Mu kekuasaan ke atas umat manusia, supaya Dia pun memberikan hidup kekal kepada setiap orang yang telah Kauserahkan kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Inilah hidup kekal, iaitu mereka mengenal-Mu sebagai satu-satunya Tuhan Yang Benar, dan mengenal Isa al-Masih yang Kauutus. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Aku telah memuliakan-Mu di bumi ini dengan menyempurnakan kerja yang Kauamanahkan kepada-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bapa, muliakanlah Aku sekarang dengan kemuliaan yang Kumiliki bersamamu sebelum dunia ini diwujudkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‘Aku telah menyatakan nama-Mu kepada semua orang di dunia ini yang telah Kauserahkan kepada-Ku. Mereka semua milik-Mu. Engkau telah mengamanahkan mereka kepada-Ku. Kini mereka taat akan firman-Mu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sekarang mereka tahu bahawa segala yang Kauberikan kepada-Ku itu sebenarnya berasal daripada-Mu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Firman yang Kauberikan kepada-Ku telah Kusampaikan kepada mereka dan mereka menerimanya. Mereka benar-benar tahu bahawa Aku sesungguhnya berasal daripada-Mu, dan percaya bahawa Engkau telah mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Aku berdoa untuk mereka. Aku tidak berdoa untuk dunia. Aku berdoa untuk orang yang telah Kauserahkan kepada-Ku, kerana mereka milik-Mu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Semua milik-Ku, milik-Mu juga. Semua milik-Mu, milik-Ku juga. Aku dimuliakan melalui mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Aku tidak lagi tinggal di dunia, sedangkan mereka masih di dunia. Aku datang kepada-Mu. Bapa Yang Maha Suci, peliharalah mereka dengan nama-Mu, nama yang telah Kauberikan kepada-Ku, supaya mereka menjadi satu sebagaimana Engkau dan Aku adalah satu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sepanjang waktu Aku bersama mereka, Aku memelihara mereka dengan nama-Mu, nama yang Kauberikan kepada-Ku. Aku melindungi mereka dan tiada seorang pun binasa, kecuali anak kebinasaan itu supaya berlaku apa yang tersurat di dalam Kitab Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","‘Sekarang Aku akan datang kepada-Mu. Semua ini Kukatakan ketika Aku masih di dunia, supaya kebahagiaan-Ku dapat dialami mereka sepenuhnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Setelah Kusampaikan firman-Mu kepada mereka, dunia membenci mereka kerana mereka bukan dari dunia ini, seperti Aku juga bukan daripada dunia ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Aku tidak memohon-Mu untuk mengeluarkan mereka dari dunia ini. Aku memohon semoga Engkau melindungi mereka daripada Si Durjana. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Sebagaimana Aku bukan dari dunia ini, begitu jugalah mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sucikanlah mereka dengan kebenaran-Mu; firman-Mu adalah kebenaran. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Aku mengutus mereka ke dunia sebagaimana Engkau mengutus-Ku ke dunia. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Demi kebaikan mereka Aku menyucikan diri-Ku supaya mereka juga disucikan dalam kebenaran. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‘Aku bukan berdoa untuk mereka saja tetapi juga untuk semua orang yang percaya kepada-Ku melalui kata-kata mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bapa, Aku berdoa supaya mereka semua menjadi satu sebagaimana Engkau di dalam-Ku dan Aku di dalam-Mu dan supaya mereka juga ada di dalam Kita. Dengan demikian dunia dapat percaya bahawa Engkaulah yang telah mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Aku memberi mereka kemuliaan yang Kauberikan kepada-Ku, supaya mereka menjadi satu sebagaimana Kita adalah satu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Aku di dalam mereka dan Engkau di dalam-Ku, supaya mereka bersatu sepenuhnya. Dengan demikian dunia akan tahu bahawa Engkau sebenarnya telah mengutus-Ku, dan Engkau mengasihi mereka sebagaimana Engkau mengasihi-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‘Bapa, Aku menghendaki mereka yang Kauserahkan kepada-Ku ada bersama-Ku di mana Aku berada, supaya mereka dapat melihat kemuliaan yang Kauberikan kepada-Ku, kerana Engkau mengasihi-Ku ketika dunia ini belum diwujudkan lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","‘Bapa Yang Maha Benar! Dunia tidak mengenal-Mu, namun Aku mengenal-Mu, dan kesemua mereka ini tahu bahawa Engkaulah yang telah mengutus-Ku. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aku telah menyatakan nama-Mu kepada mereka. Aku akan terus berbuat demikian, supaya kasih-Mu kepada-Ku bertapak kukuh di hati mereka dan supaya Aku di dalam mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Setelah berdoa demikian, Isa pergi diiringi para pengikut-Nya ke seberang Sungai Kidron. Di sana ada sebuah taman. Isa dan para pengikut-Nya masuk ke taman itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas, yang mengkhianati Isa, mengetahui tempat itu juga kerana Isa kerap ke situ dengan para pengikut-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Dengan demikian, Yudas pergi ke situ membawa sepasukan askar dan sebilangan pegawai, ketua imam serta orang Farisi. Mereka membawa senjata, lentera, dan suluh. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Isa mengetahui segala yang akan terjadi ke atas-Nya. Dia pun mendekati mereka lalu bertanya, ‘Siapakah yang kamu cari?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mereka menjawab, ‘Isa orang Nasaret.’ Isa berkata kepada mereka, ‘Akulah Dia.’ Yudas, yang mengkhianati Isa, berdiri bersama mereka di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Apabila Isa berkata kepada mereka, ‘Akulah Dia,’ mereka semua undur lalu rebah ke tanah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Isa bertanya lagi kepada mereka, ‘Siapakah yang kamu cari?’ Mereka menjawab, ‘Isa orang Nasaret.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Isa berkata, ‘Aku sudah berkata bahawa Akulah Dia. Kalau Aku yang kamu cari, biarkanlah mereka ini pergi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Dengan demikian berlakulah apa yang pernah dikatakan-Nya, ‘Tidak seorang pun yang Kauserahkan pada-Ku sesat.’) ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Petrus yang memiliki sebilah pedang menghunusnya lalu menetak telinga kanan hamba imam besar itu sehingga putus. Nama hamba itu Malkus. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Isa berkata kepada Petrus, ‘Sarungkan semula pedangmu! Bukankah Aku mesti minum dari cawan penderitaan yang diberikan kepada-Ku oleh Bapa?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Setelah itu, askar-askar dengan ketua mereka dan pegawai-pegawai Yahudi menangkap dan mengikat Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Mula-mula mereka membawa-Nya ke hadapan Hanas, bapa mertua Kayafas, Imam Besar pada tahun itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafaslah yang dahulunya berkata kepada orang Yahudi bahawa lebih baik satu orang mati demi seluruh bangsa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petrus dan seorang pengikut lain ikut serta apabila Isa dibawa pergi. Oleh sebab pengikut lain ini dikenali oleh imam besar, dia masuk bersama Isa ke halaman rumah imam besar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petrus menanti di luar, di hadapan pintu. Sejurus kemudian, pengikut lain itu keluar semula, bercakap dengan hamba perempuan yang menjaga pintu, lalu membawa Petrus masuk. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kemudian hamba perempuan itu berkata kepada Petrus, ‘Bukankah kamu seorang daripada pengikut orang itu?’ Petrus menjawab, ‘Bukan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hamba dan pegawai berdiri di situ setelah menyalakan api kerana pada masa itu hawa sejuk. Mereka sedang berdiang di situ. Petrus pun berdiri disitu dan berdiang bersama mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Imam besar menyoal Isa tentang pengikut-pengikut-Nya dan ajaran-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Isa menjawab, ‘Aku sentiasa bercakap terang-terangan di hadapan orang ramai. Aku sering mengajar di saumaah dan di rumah ibadat, tempat semua orang Yahudi berhimpun. Tidak pernah Kukatakan apa-apa secara rahsia. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mengapakah kamu menyoal-Ku? Tanyalah mereka yang pernah mendengar apa yang Kukatakan kepada mereka. Mereka tahu apa yang Kukatakan itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Seorang pegawai di situ menampar Isa sambil berkata, ‘Begitukah kamu bercakap kepada seorang imam besar?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Isa berkata kepadanya, ‘Sekiranya yang Kukatakan itu salah, tunjukkanlah kepada semua orang di sini apa kesalahan itu. Tetapi kalau kata-kata-Ku benar, mengapa kamu menampar-Ku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Selepas itu Hanas menyuruh orang membawa Isa yang masih dalam keadaan terikat ke hadapan Imam Besar Kayafas. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petrus masih berdiri berdiang. Maka orang di situ bertanya kepadanya, ‘Bukankah kamu seorang daripada pengikut orang itu?’ Petrus menjawab, ‘Bukan!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Seorang daripada hamba imam besar ada di situ. Dia saudara kepada hamba yang ditetak putus telinganya oleh Petrus. Dia berkata kepada Petrus, ‘Bukankah kamu yang kulihat di taman itu bersama-Nya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petrus menyangkal-Nya lagi, dan sejurus selepas itu ayam berkokok. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kemudian mereka membawa Isa dari rumah Kayafas ke istana pemerintah Rom. Tetapi orang Yahudi tidak turut masuk ke dalam istana itu kerana pagi masih awal. Mereka tidak mahu terkena najis, kerana mereka hendak menyertai jamuan Paska. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Oleh yang demikian, Pilatus keluar menemui mereka. Dia bertanya, ‘Apakah tuduhanmu terhadap orang ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mereka menjawab, ‘Jika orang ini tidak melakukan perbuatan jahat, sudah tentu kami tidak akan membawa-Nya ke hadapanmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kemudian Pilatus berkata kepada mereka, ‘Ambillah Dia, adili mengikut undang-undangmu.’ Orang Yahudi menjawab, ‘Kami tidak mempunyai kuasa undang-undang untuk menjatuhkan hukum mati ke atas seseorang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Dengan demikian akan terjadilah apa yang telah dikatakan oleh Isa tentang cara kematian-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Selepas itu Pilatus masuk semula ke istana dan memanggil Isa lalu bertanya, ‘Adakah kamu Raja orang Yahudi?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Isa menjawab, ‘Adakah kata-kata ini daripada dirimu sendiri, atau adakah orang lain mengatakannya kepadamu tentang diri-Ku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus menjawab, ‘Adakah aku seorang Yahudi? Bangsa-Mu sendiri dan ketua-ketua imam telah membawa-Mu kepadaku. Apakah yang telah Kaulakukan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Isa menjawab, ‘Kerajaan-Ku bukanlah daripada dunia ini. Kiranya kerajaan-Ku dari dunia ini, tentulah para pengikut-Ku berjuang mempertahan-Ku daripada diserahkan kepada orang Yahudi. Tetapi kerajaan-Ku bukanlah dari sini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dengan demikian Pilatus pun berkata kepada-Nya, ‘Jadi, adakah kamu seorang raja?’ Isa menjawab, ‘Betul katamu. Aku seorang raja. Aku dilahirkan ke dunia untuk memberi kesaksian tentang kebenaran. Setiap orang yang memihak kepada kebenaran mendengar suara-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus berkata kepada-Nya, ‘Apakah itu kebenaran?’ Kemudian dia keluar mendapatkan orang Yahudi lalu berkata, ‘Aku mendapatinya tidak bersalah sama sekali. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tetapi kamu ada satu adat, iaitu aku harus membebaskan seorang daripada bangsamu pada perayaan Paska. Mahukah kamu kubebaskan Raja orang Yahudi?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mereka semua berteriak lagi, ‘Jangan bebaskan orang itu. Bebaskan Barabas.’ Barabas itu seorang perompak. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Setelah itu, Pilatus pun membawa Isa dan mengarahkan supaya Isa disesah. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Askar-askar menganyam mahkota daripada duri, dan mengenakannya pada kepala Isa. Kemudian mereka menyarungkan jubah berwarna ungu ke tubuh-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mereka datang kepada-Nya dan berkata, ‘Daulat Raja orang Yahudi!’ lalu menampar-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus keluar lagi dan berkata kepada mereka, ‘Lihat, aku bawakan Dia kepadamu, supaya kamu tahu aku mendapati Dia tidak bersalah sama sekali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Isa pun keluar dengan memakai mahkota duri dan jubah ungu itu. Pilatus berkata kepada mereka, ‘Lihatlah orang ini!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Apabila ketua-ketua imam dan pegawai-pegawai melihat-Nya, mereka berteriak, ‘Salibkan Dia! Salibkan Dia!’ Pilatus berkata kepada mereka, ‘Kamu ambil dan saliblah Dia; kerana aku mendapati-Nya tidak bersalah sama sekali.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Orang Yahudi itu menjawab, ‘Kami ada undang-undang, dan menurut undang-undang itu Dia patut dihukum mati, kerana Dia mengaku diri-Nya Putera Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Apabila mendengar kata-kata itu, Pilatus semakin takut. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dia masuk semula ke istana dan bertanya kepada Isa, ‘Dari manakah Kamu ini?’ Tetapi Isa tidak menjawab. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kemudian Pilatus berkata kepada-Nya, ‘Kamu tidak menjawab soalanku? Tidakkah kamu tahu aku berkuasa untuk menyalib-Mu atau membebaskan-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Isa menjawab, ‘Kamu tidak mungkin mempunyai kuasa langsung ke atas-Ku kecuali diberikan kepadamu dari atas; maka yang menyerahkan-Ku kepadamu itu lebih besar dosanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Selepas itu Pilatus cuba membebaskan-Nya, tetapi orang Yahudi berseru, ‘Jika kamu membebaskan orang ini, kamu bukanlah penyokong Kaisar; kerana sesiapa yang mengaku dirinya raja bercakap menentang Kaisar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ketika Pilatus mendengar kata-kata demikian, dia pun membawa Isa, lalu duduk di kerusi pengadilan di tempat yang disebut ‘Laman Batu’, dalam bahasa Ibrani Gabbatha. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pada waktu itu persediaan sedang dibuat untuk perayaan Paska, kira-kira jam keenam. Pilatus berkata kepada orang Yahudi, ‘Lihatlah Raja kamu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tetapi mereka berseru, ‘Bawa Dia pergi! Bawa Dia pergi! Salibkan Dia!’ Pilatus berkata kepada mereka, ‘Adakah kamu mahu aku salib Rajamu?’ Ketua-ketua imam menjawab, ‘Kami tidak ada raja selain Kaisar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Oleh itu Pilatus pun menyerahkan Isa kepada mereka untuk disalib. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Lalu mereka mengambil-Nya dan membawa-Nya pergi. Isa pun mengangkat salib-Nya dan pergi ke suatu tempat yang dipanggil Tempat Tengkorak, yang dalam bahasa Ibrani disebut Golgota. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Di situ mereka menyalib-Nya, bersama dua orang lain di kiri kanan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus memerintahkan supaya satu catatan ditulis dan diletakkannya di atas salib itu. Tulisan itu berbunyi: ISA ORANG NASARET, RAJA ORANG YAHUDI. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ramai orang Yahudi membaca tulisan itu, kerana tempat Isa disalib itu dekat dengan kota, dan tulisan itu dalam bahasa Ibrani, Yunani dan Latin. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ketua-ketua imam Yahudi pula berkata kepada Pilatus, ‘Janganlah tulis: “Raja Orang Yahudi.” Tetapi, tulislah: “Dia berkata Dia raja orang Yahudi.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatus menjawab, ‘Apa yang sudah kutulis itu sudah kutulis.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Setelah menyalib Isa, askar-askar mengambil pakaian-Nya, dibahagi empat, sebahagian untuk setiap askar. Mereka mengambil jubah-Nya juga. Jubah itu tidak berkelim, seluruhnya dianyam dari atas. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Oleh itu mereka berkata-kata sesama sendiri, ‘Janganlah kita koyakkan. Kita buang undi untuk menentukan siapa yang dapat.’ Dengan demikian berlakulah apa yang tersurat di dalam Kitab Suci: ‘Mereka membahagikan pakaian-Ku antara mereka, dan untuk mendapat jubah-Ku mereka membuang undi.’ Begitulah yang dilakukan oleh askar-askar itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Di tepi salib Isa berdiri ibu-Nya, dan saudara perempuan ibu-Nya, Maryam isteri Klopas, dan Maryam Magdalena. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Apabila Isa melihat ibu-Nya dan pengikut-Nya yang dikasihi berdiri di situ, Dia pun berkata kepada ibu-Nya, ‘Lihat, itulah anakmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kepada pengikut-Nya Dia berkata, ‘Lihatlah ibumu.’ Sejak itu pengikut tersebut mengambil ibu Isa sebagai ibunya dan membawanya tinggal di rumahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Selepas itu, Isa yang mengetahui bahawa segala-galanya telah berlaku sebagaimana tersurat di dalam Kitab Suci, lalu berkata, ‘Aku dahaga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Di situ ada sebuah bekas berisi air anggur masam. Lalu mereka memenuhkan sebuah sepan dengan air anggur masam itu, meletakkannya di atas sebuah batang zufa dan mencecahkannya ke mulut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Setelah Isa menerima air anggur masam itu, Dia berkata, ‘Sudah selesai’. Dia menundukkan kepala lalu menyerahkan nyawa-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Oleh sebab hari itu hari persediaan dan mayat-mayat itu tidak sewajarnya masih ada di atas salib pada hari Sabat (kerana hari Sabat itu hari mulia), orang Yahudi meminta kepada Pilatus agar mayat-mayat itu dipatahkan kakinya dan dibawa pergi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Askar-askar pun datang mematahkan kaki orang yang disalib bersama Isa itu, seorang demi seorang. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tetapi apabila mereka sampai kepada Isa dan melihat Dia sudah tidak bernyawa lagi, mereka pun tidak mematahkan kaki-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tetapi seorang askar itu menikam rusuk-Nya dengan lembing, lalu keluarlah darah dan air. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Maka dia yang melihatnya merakamkan sebagai kesaksian, dan rakamannya itu benar. Dia tahu bahawa dia bercakap benar, supaya kamu percaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Semua ini dilakukan supaya berlakulah yang tersurat di dalam Kitab Suci, ‘Tidak satu pun tulang-Nya akan dipatahkan’. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Juga tersurat di dalam Kitab Suci, ‘Mereka akan memandang Dia yang telah ditikam oleh mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Selepas itu, Yusuf yang berasal dari Arimatea meminta izin daripada Pilatus untuk mengambil jenazah Isa. Yusuf ialah seorang pengikut Isa secara diam-diam kerana takut akan ketua orang Yahudi. Dengan izin Pilatus, maka dia datang dan mengambil jenazah Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, yang pernah mendapatkan Isa pada suatu malam dahulu, pergi bersama Yusuf membawa ramuan mur dan gaharu sebanyak kira-kira seratus paun. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mereka mengambil jenazah Isa lalu mengkafankannya dengan kain kafan dan ramuan mengikut adat pengebumian orang Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Di sebuah taman di tempat Isa disalib terdapat sebuah makam yang belum pernah digunakan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Oleh sebab makam itu dekat dan hari itu hari persediaan orang Yahudi, mereka pun memasukkan jenazah Isa ke dalamnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pada awal pagi hari pertama minggu itu, ketika masih gelap lagi, Maryam Magdalena pergi ke makam itu. Dia mendapati batu penutup telah digulingkan dari lubang makam itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Dia pun berlari mencari Simon Petrus dan pengikut lain yang dikasihi oleh Isa lalu berkata, ‘Jenazah Junjungan telah diambil dari makam, entah ke mana dialihkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petrus dan pengikut lain itu pun pergi ke makam. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kedua-duanya berlari, tetapi pengikut lain itu berlari mendahului Petrus dan tiba di makam itu lebih dahulu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dia menjenguk ke dalam dan melihat kain linen di situ tetapi tidak masuk ke makam itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Apabila Simon Petrus yang menyusul pengikut lain itu tiba, dia terus masuk ke dalam makam itu dan nampak kain linen terletak di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Dia juga melihat kain yang diikatkan pada kepala Isa, terlipat berasingan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kemudian, pengikut lain yang sampai dahulu itu pun masuk. Dia melihat segala-galanya lalu percaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Setakat itu mereka belum memahami apa yang tersurat di dalam Kitab Suci, iaitu Dia harus bangkit daripada kematian. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Selepas itu, pengikut-pengikut Isa itu pun pulang ke rumah mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tetapi Maryam berdiri di hadapan makam itu sambil menangis. Kemudian sambil menangis dia menjenguk ke dalam. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Dia melihat dua malaikat berpakaian putih duduk di tempat jenazah Isa dibaringkan dahulu, satu malaikat di sebelah kepala dan satu di sebelah kaki. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Malaikat-malaikat itu bertanya kepada Maryam, ‘Puan, mengapa menangis?’ Maryam menyahut, ‘Jenazah Junjunganku telah diambil, entah ke mana dialihkan!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kemudian Maryam menoleh lalu melihat Isa berdiri di situ, tetapi Maryam tidak mengenal-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Isa berkata kepada Maryam, ‘Puan, mengapa menangis? Siapakah yang kamu cari?’ Pada sangkaan Maryam, Dia tukang kebun di taman itu. Dengan demikian Maryam berkata, ‘Tuan, jika kamu telah mengalihkan jenazah Isa, beritahulah aku di mana kamu letakkan-Nya, supaya dapat kuambil jenazah-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Isa berkata kepadanya, ‘Maryam!’ Maryam berpaling kepada Isa lalu berseru dalam bahasa Ibrani, ‘Rabboni!’ (ertinya ‘Guru’). ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Isa berkata kepadanya, ‘Jangan berpaut pada-Ku, kerana Aku belum lagi kembali kepada Bapa. Pergilah kepada pengikut-pengikut-Ku, katakan kepada mereka bahawa sekarang Aku akan kembali kepada Bapa-Ku dan Bapamu, Allah Tuhan-Ku dan Allah Tuhanmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maryam pun pergi mendapatkan para pengikut Isa lalu memberitahu bahawa Dia telah melihat Junjungan dan Dia telah menuturkan kata-kata itu kepadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pada hari minggu itu, setelah petang, para pengikut Isa berhimpun di sebuah rumah dengan pintu terkunci kerana takut akan orang Yahudi. Isa muncul di kalangan mereka lalu berkata, ‘Sejahtera ke atas kamu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Selepas itu Dia menunjukkan tangan dan rusuk-Nya kepada mereka, maka mereka pun bersukacita melihat Junjungan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Isa berkata lagi kepada mereka, ‘Salam sejahtera kepadamu! Sebagaimana Bapa mengutus-Ku, begitulah Aku mengutusmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kemudian Dia menghembuskan nafas-Nya ke atas mereka lalu berkata, ‘Terimalah Roh Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sesiapa yang kamu ampunkan dosanya, dosanya diampunkan. Sesiapa yang tidak kamu ampunkan dosanya, dosanya tidak akan diampunkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas yang digelar Didimus, seorang daripada pengikut Isa yang dua belas itu, tidak ada bersama mereka apabila Isa datang. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Oleh itu, pengikut-pengikut lain memberitahu Tomas, ‘Kami telah melihat Junjungan!’ Tetapi Tomas berkata, ‘Selagi aku tidak melihat sendiri bekas paku di tangan-Nya, dan memasukkan jariku ke dalam bekas luka itu, juga memasukkan tanganku ke dalam rusuk-Nya, aku tidak mahu percaya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Seminggu selepas itu, para pengikut Isa termasuk Tomas berhimpun lagi di situ. Sungguhpun pintu terkunci seperti dahulu, Isa muncul di kalangan mereka lalu berkata, ‘Salam sejahtera kepadamu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Setelah itu Dia berkata kepada Tomas, ‘Hulurkan jarimu di sini, dan lihatlah tangan-Ku. Hulurkan tanganmu dan masukkannya ke dalam rusuk-Ku. Jangan ragu-ragu lagi. Percayalah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas pun berkata kepada Isa, ‘Ya Junjunganku! Ya Tuhanku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Isa berkata kepadanya, ‘Tomas, oleh sebab kamu telah melihat-Ku maka kamu percaya. Diberkatilah orang yang percaya walaupun tidak melihat-Ku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Isa telah melakukan banyak lagi mukjizat di hadapan para pengikut-Nya, tetapi tidak dituliskan di dalam kitab ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tetapi segala yang telah dituliskan di sini bertujuan supaya kamu percaya bahawa Isa adalah al-Masih, Putera Allah, dan kerana kamu percaya kepada-Nya, kamu akan memperoleh hidup dalam nama-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Setelah itu, Isa menampakkan diri sekali lagi kepada para pengikut-Nya, di Tasik Tiberias. Demikianlah kejadian itu berlaku: ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petrus, Tomas yang disebut Didimus, Natanael (yang berasal dari Kana di Galilea), anak-anak Zebedeus, dan dua orang pengikut Isa yang lain, sedang berhimpun di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petrus berkata kepada mereka, ‘Aku hendak pergi menangkap ikan.’ Mereka berkata kepadanya, ‘Kami hendak pergi bersama-sama.’ Mereka pun pergi menaiki perahu. Tetapi semalaman tiada seekor ikan pun dapat ditangkap oleh mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ketika matahari terbit, Isa berdiri di pantai, tetapi mereka tidak mengenal-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Isa bertanya kepada mereka, ‘Anak-anak, kamu ada ikan?’ ‘Tidak, kami tidak mendapat seekor ikan pun,’ jawab mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Isa berkata kepada mereka ‘Tebarkanlah jalamu di sebelah kanan perahu, kamu akan mendapat ikan.’ Mereka pun berbuat demikian, maka begitu sarat jala mereka dengan ikan sehingga tidak terdaya mereka menariknya kembali. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Oleh itu pengikut yang dikasihi oleh Isa berkata kepada Petrus, ‘Itu Junjungan!’ Setelah mendengar bahawa Junjungan yang berdiri di situ, Petrus terus memakai baju luarnya (yang telah ditanggalkannya untuk bekerja) lalu terjun ke dalam air. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Para pengikut lain menuju ke pantai dengan perahu sambil menarik jala yang sarat dengan ikan. Mereka tidak berapa jauh dari darat, hanya kira-kira seratus meter (dua ratus ‘cubits’). ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Setelah sampai di pantai, mereka melihat ikan dibakar di atas bara api, dan roti pun ada. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Isa berkata kepada mereka, ‘Bawalah sedikit ikan yang baru kamu tangkap itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petrus pergi ke perahu lalu menyeret jala ke darat. Walaupun sarat dengan ikan yang besar-besar, 153 ekor semuanya, namun jala itu tidak koyak. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Isa berkata kepada mereka, ‘Marilah bersarapan.’ Tiada seorang pun yang berani bertanya, ‘Siapakah Tuan?’ kerana mereka tahu bahawa Dia ialah Junjungan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Isa pun merapati mereka, mengambil roti lalu memberikannya kepada mereka. Begitu juga dilakukan-Nya dengan ikan. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Itulah kali ketiga Isa menampakkan diri kepada para pengikut-Nya setelah Dia dibangkitkan daripada kematian. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Selepas sarapan bersama-sama, Isa bertanya kepada Simon Petrus, ‘Simon anak Yahya, adakah kamu benar-benar mengasihi-Ku lebih daripada mereka ini?’ Petrus menjawab, ‘Ya Junjungan, Engkau tahu bahawa aku mengasihi-Mu.’ Isa berkata kepadanya, ‘Berilah anak-anak domba-Ku makan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Bagi kali kedua Isa bertanya, ‘Simon anak Yahya, adakah kamu benar-benar mengasihi-Ku?’ Petrus menjawab, ‘Ya Junjungan, Engkau tahu bahawa aku mengasihi-Mu.’ Isa berkata kepadanya, ‘Peliharalah domba-domba-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Bagi kali ketiga Isa bertanya kepadanya, ‘Simon anak Yahya, adakah kamu mengasihi-Ku?’ Petrus sedih kerana Isa bertanya kepadanya bagi kali ketiga, ‘Adakah kamu mengasihi-Ku?’ Lalu dia menjawab, ‘Junjungan, Engkau mengetahui segala-galanya. Engkau tahu bahawa aku mengasihi-Mu!’ Isa berkata kepadanya, ‘Berilah domba-domba-Ku makan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sesungguhnya, Aku berkata kepadamu, sewaktu muda kamu mengikat tali pinggangmu lalu pergi ke mana-mana yang kamu mahu. Tetapi semasa tua nanti, kamu akan menghulurkan tangan dan orang akan mengikat lalu membawamu ke tempat yang kamu tidak mahu pergi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kata-kata Isa ini membayangkan bagaimana Petrus akan mati untuk memuliakan Allah. Isa pun berkata kepada Petrus, ‘Ikutlah Aku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus menoleh lalu melihat pengikut yang dikasihi oleh Isa sedang mengikut mereka. Pengikut itulah yang duduk dekat dengan Isa ketika makan malam dahulu dan bertanya kepada-Nya, ‘Junjungan, siapakah yang akan mengkhianati-Mu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ketika melihatnya, Petrus bertanya kepada Isa, ‘Junjungan, bagaimana dengan orang ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Isa menjawab, ‘Sekiranya Aku mahu dia tetap ada hingga Aku datang kembali, apa kena-mengenanya denganmu? Kamu ikutlah Aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Oleh itu tersebarlah di kalangan pengikut Isa bahawa pengikut tersebut tidak akan mati. Tetapi Isa tidak berkata bahawa pengikut itu tidak akan mati. Isa berkata, ‘Sekiranya Aku mahu dia tetap ada hingga Aku datang kembali, apa kena-mengenanya denganmu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Pengikut itulah yang memberikan kesaksian tentang hal-hal ini. Dialah yang menuliskan semua ini dan kita tahu kesaksiannya itu benar. ");
INSERT INTO zlmKSZI_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ada banyak lagi perkara lain yang dilakukan oleh Isa. Andainya dituliskan segala-galanya, aku rasa seluruh dunia ini pun tidak cukup untuk memuatkan semua kitab itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kepada Teofilus, dahulu di dalam kitabku yang pertama aku telah menceritakan segala yang dilakukan dan diajarkan oleh Isa, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","dari awal pelayanan-Nya hingga ke hari Dia diangkat ke syurga. Sebelumnya, Dia telah memberikan perintah melalui Roh Suci kepada para rasul yang telah dipilih-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Dia telah menampakkan diri-Nya dalam keadaan hidup kepada mereka selepas kesengsaraan-Nya dengan banyak keterangan sahih. Mereka melihat-Nya selama empat puluh hari dan dalam berbagai-bagai cara dan Dia bercakap tentang perkara-perkara yang berkaitan dengan kerajaan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pada suatu hari ketika Isa bersama mereka, Dia berpesan supaya mereka jangan meninggalkan Baitulmaqdis. Kata-Nya, ‘Haruslah kamu menantikan apa yang dijanjikan Bapa, dan yang telah kamu dengar daripada-Ku; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","kerana Yahya telah mengimadkan orang dengan air, tetapi kamu akan diimadkan dengan Roh Suci tidak berapa lama lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Oleh itu, ketika mereka berhimpun, mereka pun bertanya kepada Isa, ‘Ya Junjungan, pada masa inikah Junjungan mengembalikan kerajaan ini kepada bangsa Israel?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Dia berkata kepada mereka, ‘Tidaklah diberi bagi kamu mengetahui waktu atau saat yang sudah ditetapkan oleh Bapa dalam kekuasaan-Nya sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tetapi kamu akan menerima kuasa apabila Roh Suci datang ke atasmu; dan kamu akan menjadi saksi-Ku di Baitulmaqdis, di seluruh Yudea dan Samaria, bahkan sampai ke hujung bumi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Setelah Dia berkata demikian, di hadapan mata mereka Dia diangkat lalu disambut awan dan lenyap daripada pandangan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sedang mereka merenung ke langit ketika Dia diangkat, tiba-tiba dua orang yang berpakaian putih berdiri dekat mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Orang itu berkata, ‘Wahai orang Galilea, mengapa kamu berdiri memandang ke langit? Sebagaimana Isa telah diangkat ke syurga dari kalanganmu, begitu jugalah Dia datang kelak.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Setelah itu para rasul pun kembali ke Baitulmaqdis dari bukit bernama Zaitun yang dekat dengan kota itu, jaraknya sehari Sabat perjalanan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Setibanya mereka di Baitulmaqdis, mereka naik ke bilik atas tempat mereka menumpang. Mereka ialah Petrus, Yahya, Yakobus, Andreas; Filipus dan Tomas, Bartolomeus, Matius, Yakobus anak Alfeus, dan Simon, orang Patriot; serta Yudas anak Yakobus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mereka semuanya dengan sehati terus-menerus berdoa, bersama orang perempuan dan Maryam ibu Isa, serta saudara-saudara-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pada masa itu Petrus berdiri di kalangan para pengikut Isa (kesemuanya yang berhimpun kira-kira seratus dua puluh orang) lalu berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","‘Saudara-saudara, pastilah berlaku firman yang dahulu disampaikan oleh Roh Suci melalui lidah Daud tentang Yudas, yang menjadi pandu kepada orang yang menangkap Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Dia telah dianggap sebahagian daripada kita dan diberi jawatan dalam pekerjaan kita ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Dia memperoleh sekeping tanah dengan upah durjananya; dia jatuh terjerumus, bahagian pertengahan tubuhnya pecah dan segala isi perutnya terburai. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Seluruh penduduk Baitulmaqdis mendapat tahu hal itu lalu menamakan tanah itu Hakal Dama dalam bahasa mereka, iaitu Tanah Darah.) ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","‘Sudah tersurat dalam kitab Zabur, ‘ “Biarlah tempat kediamannya menjadi sepi; Dan jangan sesiapapun tinggal di situ,” dan, ‘ “Biarlah orang lain mengambil jawatannya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Oleh itu, di antara orang yang telah berserta dengan kita sepanjang masa Junjungan Isa, keluar masuk bersama kita, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","dari masa Isa diimadkan oleh Yahya sampailah ke hari Dia diangkat naik dari kalangan kita, seorang daripada mereka haruslah menjadi saksi di samping kita tentang kebangkitan-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mereka mencadangkan dua orang: Yusuf yang juga dipanggil Barsabas (juga dikenali sebagai Yustus), dan Matias. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mereka pun berdoa, ‘Ya Tuhan yang mengetahui hati sekalian manusia, tunjukkanlah yang mana antara dua orang ini Engkau pilih ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","untuk memegang jawatan ini serta menjalankan kerja kerasulan bagi menggantikan Yudas. Ini kerana Yudas telah meninggalkan jawatan dan pekerjaan ini untuk pergi ke tempat yang wajar baginya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mereka membuang undi lalu terkena kepada Matias. Dia pun diambil menyertai sebelas rasul itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Apabila tiba Hari Pentakosta, mereka semuanya bersama-sama di suatu tempat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tiba-tiba kedengaran bunyi dari langit seperti angin kencang menderu, memenuhi seluruh rumah tempat mereka sedang duduk. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kemudian kelihatan lidah-lidah yang berbelah-belah, seperti api rupanya, dan setiap satu hinggap di atas setiap orang daripada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mereka semuanya dipenuhi Roh Suci lalu mulai bertutur dalam pelbagai bahasa asing, seperti yang diberi oleh Roh itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pada waktu itu terdapat orang Yahudi yang salih daripada segala bangsa di dunia tinggal di Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Apabila mendengar bunyi itu, mereka datang beramai-ramai lalu tercengang kerana masing-masing mendengar orang bertutur dalam bahasanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mereka hairan dan takjub lalu berkata sesama sendiri, ‘Bukankah semuanya yang berkata-kata ini orang Galilea? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bagaimanakah mungkin masing-masing kita mendengar bahasa ibunda sendiri? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Orang Partia, Media, dan Elam, orang yang tinggal di Mesopotamia, Yudea dan Kapadokia, Pontus dan Asia Kecil. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia dan Pamfilia, Mesir dan kawasan-kawasan Libya yang bersempadan dengan Kirene, pengunjung dari Rom, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","baik berbangsa Yahudi mahupun mualaf, orang Kreta dan orang Arab, kita mendengar mereka bercakap dalam bahasa kita masing-masing tentang perbuatan Allah yang menakjubkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Oleh itu mereka hairan dan bingung lalu bertanya sesama sendiri, ‘Apakah ertinya semua ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ada pula yang mengejek, ‘Semua orang ini mabuk air anggur manis.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petrus berdiri bersama sebelas rasul lagi lalu berkata dengan suara yang lantang, ‘Saudara-saudara orang Yahudi dan semua penduduk di Baitulmaqdis, ketahuilah hal ini serta dengarlah baik-baik kata-kataku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mereka ini bukanlah mabuk seperti saudara-saudara sangka, kerana hari baru pukul sembilan pagi sekarang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tetapi inilah yang dikatakan oleh Nabi Yoel: ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘ “Bahawa akan berlaku pada akhir zaman, firman Allah, Aku akan mencurahkan Roh-Ku ke atas semua manusia. Anakmu lelaki perempuan akan bernubuat, Orang mudamu akan melihat penglihatan, Orang tuamu akan bermimpi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Dan ke atas hamba-Ku lelaki perempuan, Aku akan mencurahkan Roh-Ku ketika itu, lalu mereka bernubuat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Aku akan menunjukkan keajaiban di langit dan alamat di bumi, darah dan api serta kepulan-kepulan asap. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Matahari akan menjadi gelap, dan bulan menjadi seperti darah, sebelum tiba hari Tuhan yang besar dan syahdu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dan berlakulah kelak, bahawa sesiapa yang menyeru nama Tuhan akan diselamatkan.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","‘Saudara-saudara orang Israel, dengarlah kata-kata ini: Isa orang Nasaret itu seorang Manusia yang dipersaksikan oleh Allah kepadamu dengan mukjizat, keajaiban dan alamat yang dilakukan Allah melalui-Nya di kalangan kamu. Kamu sendiri tahu tentang hal itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dia, yang diserahkan kepadamu seperti yang telah dirancangkan dan ditentukan oleh Allah, telah kamu salib dan bunuh dengan bantuan orang durjana. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Allah telah membangkitkan-Nya, setelah membebaskan-Nya daripada kesengsaraan maut, kerana tidak mungkin maut dapat menahan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kerana Daud telah berkata tentang-Nya: ‘ “Bahawa aku telah melihat Tuhan sentiasa di hadapanku. Dia ada di sisi kananku, aku tidak akan goyah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Maka hatiku bersukacita, dan lidahku bergembira; dan jasadku juga akan bersandar pada harapan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kerana Kau tidak akan meninggalkan rohku di alam maut, serta Kau tidak akan membiarkan jasad Orang Suci-Mu reput. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kau telah memberitahuku jalan hidup, dan Engkau akan memenuhiku dengan kebahagiaan di hadirat-Mu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","‘Saudara-saudaraku, aku akan bercakap terus terang kepadamu tentang moyang kita Daud, bahawa dia telah wafat dan dimakamkan, dan makamnya ada di tanah kita sampai hari ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Oleh sebab dia seorang nabi dan sedar bahawa Allah telah berjanji kepadanya dengan bersumpah bahawa Dia akan mengangkat daripada benih keturunan jasadnya dan mendudukkannya di atas takhta kerajaan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dia telah melihat terdahulu hal ini, maka dia bercakap tentang kebangkitan al-Masih, bahawa roh-Nya tidak akan ditinggalkan di alam maut, dan jasad-Nya tidak akan reput. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Allah telah membangkitkan Isa ini dan kami semua menyaksikannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dia telah dinaikkan ke syurga ke sebelah kanan Allah, dan daripada Allah Bapa dia telah menerima Roh Suci yang telah dijanjikan-Nya. Lalu Dia mencurahkan Roh itu seperti yang kamu lihat dan dengar sekarang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daud tidak naik ke syurga, tetapi dia sendiri berkata demikian, ‘ “Tuhan berfirman kepada Junjunganku: ‘Duduklah di sebelah kanan-Ku, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sehingga Kujadikan musuh-musuh-Mu alas kaki-Mu.’” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","‘Oleh itu, hendaklah seluruh orang Israel tahu dengan pastinya, bahawa Allah telah menjadikan Isa, yang kamu salib itu, Junjungan dan al-Masih.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Apabila mereka mendengar ini, hati mereka pun berasa tertusuk, lalu mereka berkata kepada Petrus dan para rasul yang lain, ‘Saudara-saudara, apakah yang patut kami perbuat?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrus pun berkata kepada mereka, ‘Bertaubatlah, dan hendaklah setiap orang daripada kamu diimadkan atas nama Isa al-Masih supaya dosa-dosamu diampunkan; dan kamu akan menerima pemberian Roh Suci daripada Allah; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","kerana janji itu telah dibuat kepada kamu dan anak-anakmu, dan kepada semua yang jauh-jauh, seberapa ramai yang akan dipanggil oleh Allah Tuhan kita.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petrus bersaksi dengan banyak perkataan lain lagi, dan menyeru mereka, ‘Selamatkanlah dirimu daripada angkatan yang ingkar ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kemudian semua orang yang menerima kata-katanya dengan rela hati diimadkan; pada hari itu bilangan mereka bertambah kira-kira tiga ribu orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mereka berpegang teguh kepada pengajaran para rasul, dan kepada perpaduan, pembahagian roti dan doa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Rasa takut memenuhi setiap hati dan banyak keajaiban serta alamat dilakukan melalui para rasul itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ketika itu semua yang beriman tetap bersatu dan berkongsi segala yang ada pada mereka, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","serta menjual semua harta benda mereka lalu membahagikan antara mereka menurut keperluan seseorang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Demikianlah setiap hari mereka di rumah ibadat dengan satu hati, dan membahagi roti dari rumah ke rumah, lalu memakan rezeki mereka dengan sukacita dan tulus hati, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","sambil memuji Allah dan menerima rasa muhibah daripada semua orang. Setiap hari Tuhan menambah bilangan jemaah mereka itu dengan orang yang diselamatkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Petrus dan Yahya naik ke rumah ibadat bersama-sama pada waktu sembahyang, iaitu pukul tiga petang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ada seorang lumpuh sejak dari rahim ibunya. Setiap hari dia diangkat orang dan diletakkan di pintu rumah ibadat itu yang dinamakan Pintu Indah, untuk meminta sedekah daripada orang yang masuk ke rumah ibadat itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Apabila dia melihat Petrus dan Yahya sedang hendak masuk ke rumah ibadat itu, dia pun meminta sedekah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petrus merenungnya, bersama Yahya, lalu berkata, ‘Pandanglah kami.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Orang itu pun menatap mereka, dengan harapan mendapat sesuatu daripada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kemudian Petrus berkata, ‘Emas perak tiada padaku, tetapi apa yang ada padaku kuberikan kepadamu: Dalam nama Isa al-Masih, orang Nasaret, bangkit dan berjalanlah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petrus memegang tangan kanannya dan menolongnya berdiri, lalu serta-merta tulang kaki dan buku lalinya mendapat kekuatan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Orang itu melompat bangun, berdiri lalu berjalan. Kemudian dia masuk ke rumah ibadat itu mengikut Petrus dan Yahya sambil berjalan, melompat dan memuji Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Semua orang melihatnya berjalan sambil memuji Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ketika itu mereka pun mengetahui dia itu orang yang duduk meminta sedekah di Pintu Indah rumah ibadat itu. Mereka pun dipenuhi rasa hairan dan ajaib akan apa yang telah berlaku kepadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sementara orang lumpuh yang telah disembuhkan itu berpegang kepada Petrus dan Yahya, semua orang yang tersangat hairan itu berlari mengerumuni mereka di serambi yang dinamakan Serambi Sulaiman. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Apabila Petrus melihat keadaan ini, dia terus berkata kepada orang yang berhimpun itu, ‘Saudara-saudara orang Israel, mengapa kamu takjub melihat kejadian ini? Mengapa pula kamu merenung kami, seolah-olah dengan kuasa atau kewarakan kami sendiri kami telah membolehkan orang ini berjalan? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tuhan Ibrahim, Ishak dan Yakub, Tuhan nenek moyang kita, telah memuliakan Hamba-Nya Isa yang telah kamu serahkan dan sangkal di hadapan Pilatus walaupun dia membuat keputusan hendak melepaskan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kamu menyangkal Yang Suci dan Benar itu, serta meminta seorang pembunuh diserahkan kepadamu, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","lalu kamu membunuh sumber hayat itu; Allah membangkitkan-Nya daripada kematian, dan kami ini menjadi saksinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iman pada nama Isa telah menguatkan orang ini, yang kamu lihat dan kenali. Ya, iman yang datang daripada-Nya telah memberi orang ini kesihatan yang sempurna di hadapan kamu sekalian. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‘Namun, saudara-saudara, aku tahu bahawa kamu berbuat demikian dalam kejahilan, begitu juga para pemimpinmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tetapi dengan cara demikianlah segala yang dinyatakan Allah melalui lidah nabi-nabi-Nya, bahawa al-Masih akan menderita, telah ditunaikan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Oleh itu bertaubatlah dan berpalinglah kepada Allah, supaya dosa-dosamu dihapuskan, dan supaya masa yang memberikan kesegaran datang kelak daripada Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Dan juga supaya Dia menghantar Isa al-Masih yang telah ditentukan-Nya menjadi al-Masih bagimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Al-Masih mesti tetap di syurga hingga sampai masa Allah memulihkan segala-galanya, seperti yang difirmankan-Nya dahulu kala melalui lidah nabi-nabi-Nya yang suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa sesungguhnya telah berkata kepada nenek moyang kita, “Allah Tuhanmu akan membangkitkan untukmu seorang Nabi sepertiku dari kalangan saudara-saudaramu. Dengarlah segala kata-Nya kepadamu dalam semua hal. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Setiap jiwa yang tidak mendengar kata Nabi itu akan dibinasakan sama sekali dari kalangan kaumnya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","‘Ya, semua nabi, dari Samuel dan selepasnya, semua yang telah bersuara, juga telah bernubuat tentang zaman ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kamu adalah anak cucu nabi-nabi itu, dan waris perjanjian yang dibuat Allah dengan nenek moyang kita melalui firman-Nya kepada Ibrahim, “Melalui benihmu semua kaum di dunia akan diberkati.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pertama sekali kepada kamu, Allah telah membangkitkan Hamba-Nya Isa dan menghantar-Nya untuk memberkatimu dengan memalingkan kamu sekalian daripada kejahatanmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sementara Petrus dan Yahya itu bercakap kepada orang ramai, para imam dan ketua pengawal rumah ibadat serta orang Saduki datang kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mereka sangat gelisah bahawa rasul itu mengajar orang ramai dan memberitakan kebangkitan daripada kematian melalui Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mereka menangkap Petrus dan Yahya lalu memasukkan mereka ke dalam penjara sampai esok kerana hari sudah malam. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Namun demikian, ramai orang yang telah mendengar apa yang diajarkan itu percaya, dan jumlah laki-laki telah bertambah kira-kira lima ribu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pada esoknya, para pemimpin masyarakat Yahudi, tua-tua dan guru-guru Taurat berhimpun di Baitulmaqdis, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","dan juga imam besar Hanas, Kayafas, Yahya, Iskandar dan seluruh keluarga imam besar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mereka membawa Petrus dan Yahya untuk dihadapkan kepada mereka. Kemudian mereka pun bertanya, ‘Dengan kuasa apa dan dengan nama siapakah kamu telah melakukan perkara itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petrus yang dipenuhi Roh Suci berkata kepada mereka, ‘Para pemimpin masyarakat Israel! ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Sekiranya hari ini kami dihakimi atas perbuatan baik kepada seorang yang lumpuh, sehingga dia dipulihkan, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","maka ketahuilah kamu sekalian dan seluruh bangsa Israel, bahawa dengan nama Isa al-Masih dari Nasaret, yang telah kamu salib dan telah dibangkitkan Allah daripada kematian, dengan nama Dialah orang ini berdiri di sini di hadapanmu dalam keadaan sihat sempurna. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Inilah ‘ “batu yang dibuang oleh kamu sebagai pembina, kini telah menjadi batu penjuru.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tiadalah penyelamatan melalui sesiapa yang lain, kerana tiada nama lain di bawah langit ini diberikan di kalangan manusia, yang dapat menyelamatkan kita.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Apabila mereka melihat keberanian Petrus dan Yahya sedangkan kedua-duanya ternyata orang yang tidak berpelajaran serta tidak terlatih, mereka pun hairan. Mereka sedar bahawa kedua-duanya telah bersama dengan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Apabila mereka melihat orang yang sudah disembuhkan itu berdiri di sisi kedua-duanya, mereka tidaklah dapat menyangkal lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tetapi setelah mereka menyuruh kedua-duanya keluar dari majlis itu, mereka pun bermesyuarat sesama sendiri, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","‘Apakah yang akan kita lakukan kepada mereka itu? Sesungguhnya sudah nyata kepada semua orang Baitulmaqdis bahawa satu mukjizat yang mengagumkan telah dilakukan melalui mereka, dan kita tidak dapat menafikannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tetapi supaya berita ini tidak tersebar lebih luas di kalangan bangsa kita, eloklah kita melarang mereka berkata-kata lagi kepada sesiapapun dengan menggunakan nama itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dengan demikian mereka pun memanggil kedua-duanya itu dan mengeluarkan perintah jangan sekali-kali bercakap atau mengajar dengan nama Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tetapi Petrus dan Yahya menjawab, ‘Wajarkah pada pandangan Allah jika kami mendengar katamu lebih daripada mendengar kata Allah? Timbangkanlah, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","kerana kami mesti bercakap tentang segala yang telah kami lihat dan dengar itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Setelah membuat beberapa ugutan lagi, mereka melepaskan kedua-dua rasul itu kerana tidak tahu bagaimana hendak menghukum mereka, memandangkan seluruh masyarakat memuji Allah atas apa yang telah dilakukan itu; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","padahal orang yang disembuhkan melalui mukjizat itu sudah berumur lebih daripada empat puluh tahun. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Setelah dilepaskan, Petrus dan Yahya segera pergi mendapatkan rakan-rakannya lalu menceritakan segala yang dikatakan oleh imam-imam besar dan para pemimpin masyarakat itu kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Apabila mendengar segalanya, mereka semua berseru dengan satu hati, ‘Ya Allah, Engkaulah Tuhan yang menjadikan langit dan bumi serta laut dengan segala isinya, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","yang melalui lidah hamba-Mu Daud telah berfirman: ‘ “Mengapa bangsa-bangsa asing naik berang dan kaum-kaum berkomplot dengan sia-sia? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Raja-raja bumi ini menegakkan pendirian, dan para pemimpin bermuafakat untuk melawan Tuhan dan melawan Dia yang diurapi-Nya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sesungguhnya Herodes dan Pontius Pilatus, bersama orang asing dan bangsa Israel telah berhimpun dalam negeri ini melawan Hamba Suci-Mu Isa yang telah Kauurapi, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","untuk melakukan segala yang sudah ditentukan oleh kuasa dan tujuan-Mu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ya Tuhan, lihatlah ugutan mereka dan kurniakanlah kepada hamba-hamba-Mu ini, sepenuh keberanian untuk menyampaikan firman-Mu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Hulurkan tangan-Mu untuk menyembuhkan, dan melakukan tanda-tanda ajaib serta mukjizat dengan nama Hamba Suci-Mu Isa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Setelah mereka berdoa, tempat mereka berhimpun itu bergoncang. Mereka semua dipenuhi dengan Roh Suci dan mengucap firman Allah dengan berani. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Semua orang yang sudah percaya itu sehati sejiwa. Tiada seorang pun yang mengatakan sesuatu itu miliknya; mereka berkongsi segalanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Dengan kuasa yang hebat rasul-rasul itu bersaksi tentang kebangkitan Junjungan Isa. Kasih kurnia besar melimpahi mereka sekalian. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tiada seorang pun di antara mereka yang kekurangan; kerana semua yang memiliki harta atau rumah telah menjualnya, membawa wang jualan itu ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","dan meletakkannya di kaki para rasul; lalu dibahagikanlah di antara mereka menurut keperluan masing-masing. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusuf yang digelar para rasul Barnabas (yang diterjemahkan sebagai Anak Pendorong), orang Lewi dari Kuprus, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ada mempunyai tanah. Dia menjualnya lalu membawa wang jualan itu, dan meletakkannya di kaki para rasul. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Seorang yang bernama Ananias, serta isterinya Safira, telah menjual sebidang tanah milik mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Dia menyimpan sebahagian wang jualan itu dengan pengetahuan isterinya dan membawa sebahagian lagi untuk diletakkan di kaki para rasul. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petrus berkata, ‘Ananias, mengapakah Iblis memenuhi hatimu sehingga kau berdusta kepada Roh Suci dengan menyimpan sebahagian wang jualan tanah itu untuk dirimu? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ketika tanah itu masih ada, bukankah tanah itu milikmu? Setelah dijual, bukankah wangnya dalam kawalanmu juga? Mengapakah kamu membentuk niat ini dalam hatimu? Kamu bukan berdusta kepada manusia tetapi kepada Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Apabila Ananias mendengar kata-kata itu, dia pun rebah lalu meninggal dunia. Oleh yang demikian semua orang yang mendengar hal itu amat ketakutan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Orang muda-muda bangun lalu mengkafankannya, mengangkatnya keluar dan menguburkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kira-kira tiga jam kemudian, isterinya masuk tanpa mengetahui apa yang telah terjadi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petrus berkata kepadanya, ‘Katakanlah kepadaku, adakah kamu menjual tanah itu dengan harga sekian?’ Perempuan itu menjawab, ‘Ya, dengan harga sekian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petrus berkata kepadanya, ‘Bagaimana pula kamu berdua telah bermuafakat untuk mencubai Roh Tuhan? Lihatlah, kaki orang yang telah menguburkan suamimu ada di muka pintu, dan mereka akan mengangkatmu pula keluar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Perempuan itu serta-merta rebah di kakinya lalu meninggal dunia. Orang muda-muda itu masuk dan mendapati perempuan itu sudah mati lalu mengangkatnya keluar dan menguburkannya di sisi suaminya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Oleh yang demikian, seluruh masyarakat yang beriman amat ketakutan, begitu juga semua yang mendengar hal itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Melalui rasul-rasul itu banyak alamat ajaib dan mukjizat dilakukan di kalangan masyarakat itu. Semuanya berhimpun dengan sehati di Serambi Sulaiman. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Walaupun orang lain tidak berani menyertai mereka, namun orang ramai sangat menghormati mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Semakin lama semakinlah bertambah bilangan orang yang mempercayai Tuhan, baik lelaki mahupun perempuan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Orang membawa orang sakit keluar ke tengah jalan, membaringkan mereka di atas katil dan kaus, dengan harapan sekurang-kurangnya bayang-bayang Petrus akan menyentuh sesetengahnya apabila dia lalu kelak. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ramai pula orang dari kota-kota sekeliling Baitulmaqdis datang berhimpun, membawa orang yang sakit dan yang dirasuk roh-roh durjana, lalu semuanya disembuhkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Imam besar dan semua yang bersamanya (iaitu dari mazhab orang Saduki) amat iri hati ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","lalu menangkap rasul-rasul itu dan memasukkan mereka ke penjara umum. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tetapi pada malam itu malaikat Tuhan membuka pintu penjara lalu membawa rasul-rasul itu keluar sambil berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","‘Pergilah berdiri di rumah ibadat dan nyatakan segalanya tentang hidup baru ini kepada orang ramai.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Setelah mendengar kata-kata itu, ketika fajar menyingsing, mereka pergi ke rumah ibadat dan mula mengajar. Kemudian tibalah imam besar dan pengikut-pengikutnya. Mereka memanggil para tua-tua bani Israel berkumpul untuk mengadakan mesyuarat Majlis Agama, lalu memerintahkan rasul-rasul itu dibawa dari penjara untuk dihadapkan kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Apabila pegawai-pegawai itu sampai di penjara dan mendapati rasul-rasul itu tidak ada di situ, mereka pun pulang melaporkan hal itu, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","‘Kami dapati pintu penjara tetap berkunci dan pengawal-pengawal berjaga di situ, tetapi apabila kami membuka pintu, kami dapati tiada seorang pun di dalam penjara itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Apabila ketua rumah ibadat dan ketua-ketua imam mendengar laporan itu, mereka kebingungan tentang apa yang mungkin terjadi kelak. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kemudian seorang lelaki masuk dan berkata kepada mereka, ‘Orang yang tuan-tuan penjarakan itu sedang mengajar orang ramai di dalam rumah ibadat!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dengan demikian, ketua rumah ibadat pergi diiringi pegawai-pegawai lalu membawa rasul-rasul itu beredar dari situ tanpa menggunakan kekerasan, kerana takut direjam oleh orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mereka membawa para rasul ke hadapan Majlis Agama. Imam besar berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","‘Bukankah kami telah melarang keras kamu mengajar atas nama itu? Tetapi lihatlah, kamu telah menyebarkan ajaran itu ke serata Baitulmaqdis dan berniat mempertanggungjawabkan kami atas kematian-Nya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petrus dan rasul yang lain menjawab, ‘Kami harus taat akan Allah, bukan manusia! ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Allah Tuhan yang disembah oleh nenek moyang kita telah membangkitkan Isa yang telah kamu bunuh dengan menyalib-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Allah mengangkat Isa kepada kedudukan mulia di sebelah kanan-Nya, sebagai Anak Raja dan Penyelamat, supaya umat Israel dapat bertaubat dan dosa-dosa mereka diampuni. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kami menjadi saksi dalam semua hal ini, begitu juga Roh Suci yang dikurniai Allah kepada semua yang taat akan perintah-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Apabila anggota-anggota Majlis Agama mendengar kata-kata itu, mereka sangat marah sehingga berura-ura hendak membunuh para rasul. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Akan tetapi di kalangan anggota Majlis Agama itu ada seorang Farisi bernama Gamaliel, seorang guru Taurat yang sangat disegani. Dia bangkit lalu mengarahkan orang membawa para rasul keluar sejurus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kemudian dia berkata kepada Majlis Agama, ‘Saudara-saudara orang Israel! Timbangkan halus-halus apa yang hendak saudara semua lakukan terhadap orang itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Suatu masa dulu, Teudas telah bangkit dan mengaku dirinya pemimpin besar. Kira-kira empat ratus orang menjadi pengikutnya. Tetapi dia dibunuh, lalu semua pengikutnya kucar-kacir dan pergerakannya hilang begitu saja. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Selepas itu muncul pula Yudas, orang Galilea, pada masa pembancian. Dia mempengaruhi ramai orang untuk memberontak, namun dia juga dibunuh, lantas semua pengikutnya kucar-kacir. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Dengan demikian, dalam hal ini, aku cadangkan jangan ambil apa-apa tindakan terhadap orang itu. Bebaskan mereka. Kalau rancangan atau usaha ini daripada manusia, segalanya akan hilang begitu saja. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Sebaliknya, kalau segalanya itu datang daripada Allah, saudara-saudara tidak mungkin menumpaskannya, malah mungkin akan ternyata bahawa saudara-saudara melawan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Majlis Agama menerima nasihat Gamaliel. Para rasul dipanggil, dipukul, dilarang lagi bercakap dengan nama Isa, lalu dibebaskan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ketika beredar pergi dari Majlis Agama, para rasul bersukacita kerana dianggap layak menanggung aib atas nama Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Setiap hari, di rumah ibadat dan di setiap rumah orang, mereka terus-menerus mengajarkan dan menyebarkan bahawa Isa itulah al-Masih, Penyelamat yang diutus Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tidak berapa lama selepas itu, ketika pengikut Isa kian meningkat bilangannya, timbullah aduan daripada orang Yahudi peranakan Yunani terhadap orang Yahudi Ibrani. Orang Yahudi peranakan Yunani berkata bahawa balu di kalangan mereka diabaikan dalam pengagihan bantuan harian. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dengan demikian, dua belas rasul itu menghimpunkan semua pengikut Isa lalu berkata, ‘Kami ini tidaklah wajar mengetepikan kewajipan menyebarkan firman Allah untuk melayan di meja makan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Oleh itu, pilihlah tujuh orang di kalangan saudara-saudara yang mempunyai nama baik dan dipenuhi Roh Suci serta kebijaksanaan, supaya kami tugaskan mereka mengendalikan hal itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kami akan memenuhi masa kami dengan berdoa dan menyampaikan firman Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Semua bersetuju dengan cadangan para rasul. Mereka memilih Stefanus, seorang yang sangat teguh imannya serta dikuasai oleh Roh Suci. Di samping itu mereka memilih Filipus, Prokhorus, Nikanor, Timon, Parmenas, dan Nikolaus dari Antiokhia, seorang penganut agama Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tujuh orang itu dibawa ke hadapan para rasul. Para rasul pun berdoa dan meletakkan tangan ke atas mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Dengan demikian firman Allah semakin tersebar dan bilangan pengikut Isa di Baitulmaqdis kian meningkat, dan ramai imam menjadi orang beriman. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanus, yang dipenuhi iman dan kuasa rohani, banyak melakukan keajaiban dan alamat di kalangan orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tetapi ada beberapa orang yang bangkit menentangnya, iaitu anggota saumaah yang disebut Saumaah Orang Yang Dibebaskan (terdiri daripada orang Yahudi dari Kirene, Iskandaria, Kilikia dan Asia). Mereka mulai berbahas dengan Stefanus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Namun, mereka tidak dapat menewaskan kebijaksanaan dan Roh Suci yang mengilhamkan kata-katanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Setelah itu mereka senyap-senyap mendorong beberapa orang berkata, ‘Kami telah mendengar dia melafazkan kata-kata kufur terhadap Musa dan Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mereka menghasut orang ramai, tua-tua dan guru-guru Taurat sehingga Stefanus ditangkap dan dihadapkan ke Majlis Agama. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mereka membawa saksi-saksi palsu yang berkata tentang Stefanus, ‘Orang ini tidak putus-putus meluahkan kata-kata kufur tentang tempat suci ini dan hukum agama kita. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kami mendengar dia berkata bahawa Isa orang Nasaret itu akan membinasakan tempat ini dan mengubah segala adat yang telah disampaikan kepada kita oleh Musa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ketika itu semua orang yang duduk di Majlis Agama merenung Stefanus dan melihat mukanya seperti wajah malaikat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kemudian imam besar bertanya kepada Stefanus, ‘Benarkah segala tuduhan ini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefanus menjawab, ‘Bapa-bapa dan saudara-saudara! Dengarlah: Sebelum moyang kita Ibrahim berpindah ke Haran, Allah Yang Maha Tinggi telah menampakkan diri kepadanya di Mesopotamia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Allah berfirman kepadanya, “Tinggalkanlah negerimu dan keluargamu. Pergilah ke negeri yang akan Kutunjukkan kepadamu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","‘Ibrahim pun terus meninggalkan negeri Kasdim dan tinggal di Haran. Setelah bapa Ibrahim meninggal dunia, Allah memindahkan pula Ibrahim ke negeri tempat saudara-saudara dan bapa-bapa tinggal sekarang ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ketika itu Allah tidak memberikan warisan apapun kepada Ibrahim sebagai miliknya, secebis tanah pun tidak. Namun begitu, Allah berjanji akan mengurniakan tanah ini kepada Ibrahim sebagai miliknya dan milik keturunannya, walaupun pada masa itu Ibrahim tidak mempunyai anak. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Namun Allah berfirman kepadanya bahawa keturunannya akan tinggal di negeri orang, dan akan diperhamba serta ditindas selama empat ratus tahun. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Aku akan menghukum bangsa yang memperhamba mereka,” Allah berfirman. “Kemudian mereka akan keluar dari negeri itu dan menyembah-Ku di sini.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kemudian Allah membuat perjanjian sunat dengan Ibrahim; maka Ibrahim mendapat anak lelaki bernama Ishak dan menyunatkannya pada hari kelapan; Ishak mendapat Yakub dan Yakub mendapat dua belas orang anak lelaki yang menjadi nenek moyang bangsa kita. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‘Nenek moyang bangsa kita itu menaruh hasad dengki terhadap Yusuf lalu menjualnya sebagai hamba di Mesir. Tetapi Allah menyertainya ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","dan menyelamatkannya daripada segala kesusahannya. Apabila Yusuf mengadap Firaun raja Mesir, Allah mengurniainya budi dan kebijaksanaan, sehingga raja Mesir melantiknya menjadi gabenor yang berkuasa ke atas seluruh negeri itu dan istananya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","‘Kemudian seluruh Mesir dan Kanaan dilanda kebuluran, dan nenek moyang kita tidak dapat mencari makanan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Apabila Yakub mendengar bahawa di Mesir ada gandum, dia menyuruh anak-anaknya, nenek moyang kita, pergi ke situ bagi kali pertama. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ketika mereka ke sana bagi kali kedua, Yusuf diperkenalkan kepada saudara-saudaranya itu dan keluarga Yusuf diketahui oleh Firaun. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Lalu Yusuf mengirim khabar dan meminta bapanya, Yakub, serta seluruh keluarganya berpindah ke Mesir; tujuh puluh lima orang semuanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakub sekeluarga pun berpindah ke Mesir. Di situlah dia dan nenek moyang kita meninggal dunia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jenazah mereka dibawa ke Sikhem dan dikebumikan di kuburan yang telah dibeli oleh Ibrahim dengan sejumlah wang daripada suku Hamor, bapa Sikhem. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‘Apabila masa bagi Allah menunaikan janji-Nya kepada Ibrahim semakin hampir, bilangan bangsa kita di Mesir telah meningkat banyak sekali. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kemudian seorang raja lain yang tidak kenal akan Yusuf naik takhta kerajaan Mesir. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Raja itu memperdaya bangsa kita dan menindas nenek moyang kita, dengan memaksa mereka membuang bayi yang baru lahir dan membiarkannya mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","‘Pada masa itulah Musa dilahirkan, seorang bayi yang elok di mata Allah. Dia dipelihara di rumah bapanya selama tiga bulan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Apabila dia terpaksa dibuang, puteri Raja Mesir mengambilnya dan memeliharanya sebagai anak sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa menjadi arif dalam segala ilmu pengetahuan serta kebijaksanaan orang Mesir dan menjadi seorang yang sangat handal, baik dari segi perkataan mahupun perbuatan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","‘Sewaktu Musa berusia empat puluh tahun, hatinya tergerak hendak mengunjungi saudara-saudaranya bani Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dia terpandang salah seorang daripada mereka sedang dianiaya oleh seorang Mesir. Dia pun membela orang yang dianiaya itu dan membunuh orang Mesir itu; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","kerana Musa menyangka saudara-saudara sebangsanya mengerti bahawa Allah akan membebaskan mereka melaluinya, tetapi mereka tidak mengerti. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Esoknya, dia terlihat pula dua orang Israel sedang bergaduh lalu cuba mendamaikan mereka, katanya, “Kamu bersaudara. Mengapa kamu saling menganiaya?” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","‘Tetapi orang yang menganiaya saudara sebangsanya itu menolak Musa ke tepi sambil bertanya, “Siapa yang menjadikan kamu pemerintah dan hakim kami? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Adakah kamu ingin membunuhku seperti kamu membunuh orang Mesir itu kelmarin?” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ketika Musa mendengar kata-kata itu, dia lari dari Mesir lalu menetap di negeri Midian. Di situ dia mendapat dua orang anak lelaki. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","‘Empat puluh tahun kemudian, malaikat menampakkan diri kepada Musa di dalam api belukar yang bernyala, di tanah gurun dekat Gunung Sinai. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa kehairanan melihatnya lalu menghampirinya. Dia mendengar suara Tuhan berfirman, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Akulah Tuhan nenek moyangmu; Tuhan Ibrahim, Ishak dan Yakub.” Musa gementar ketakutan dan tidak berani memandang lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","‘Tuhan berfirman seterusnya, “Tanggalkan kasutmu, kerana tempat kamu berdiri itu tanah suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aku telah melihat penindasan umat-Ku di Mesir. Aku telah mendengar rintihan mereka, dan telah turun untuk membebaskan mereka. Sekarang marilah, Aku akan mengutusmu ke Mesir.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‘Musa inilah yang telah ditolak oleh umat Israel dengan kata-kata, “Siapa yang menjadikan kamu pemerintah dan hakim kami?” Justeru dialah yang diutus Allah sebagai pemerintah dan pembebas, melalui malaikat yang menampakkan diri kepadanya di belukar itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa memimpin orang Israel keluar dari Mesir setelah melakukan pelbagai mukjizat dan keajaiban di Mesir, di Laut Merah dan kemudian di tanah gurun selama empat puluh tahun. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","‘Musa inilah yang berkata kepada bangsa Israel, “Allah akan mengutus seorang Nabi kepadamu, sebagaimana Dia telah mengutusku dari kalangan bangsamu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa inilah yang bersama bangsa Israel berhimpun di tanah gurun. Dia di sana berserta nenek moyang kita dan malaikat yang berkata-kata kepadanya di Gunung Sinai. Dialah yang menerima firman hidup, untuk disampaikan kepada kita. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‘Tetapi nenek moyang kita enggan taat kepadanya. Mereka menolaknya dan dalam hati mereka berpaling semula ke Mesir. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mereka berkata kepada Harun, “Buatkan kami patung pujaan yang dapat memimpin kami, kerana kami tidak tahu apa yang telah terjadi kepada Musa yang membawa kami keluar dari Mesir.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Setelah itu mereka membuat berhala berbentuk anak lembu dan mempersembahkan korban kepada berhala itu. Mereka bersuka ria meraikan buatan tangan mereka sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Oleh itu Allah berpaling daripada mereka dan membiarkan mereka menyembah segala yang di langit. Demikianlah yang tersurat di dalam kitab nabi-nabi: ‘ “Adakah kamu mempersembahkan kepada-Ku binatang sembelihan dan korban selama empat puluh tahun di tanah gurun, hai orang Israel? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Malah kamu mengusung khemah Molokh dan bintang berhalamu Refan, patung-patung yang kamu buat untuk kamu sembah; maka Aku akan membuangmu jauh ke seberang Babel.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","‘Nenek moyang kita mempunyai Khemah Kesaksian di tanah gurun. Khemah ini dibuat sebagaimana yang diperintahkan kepada Musa menurut contoh yang telah dilihatnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nenek moyang kita, setelah menerimanya, bersama Yusak telah membawanya masuk ke negeri kita yang dikuasai oleh bangsa-bangsa asing. Allah telah mengusir bangsa-bangsa asing itu di hadapan mereka, dan khemah itu tetap di tanah tersebut hingga zaman Daud. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daud mendapat keredaan Allah dan memohon izin-Nya untuk membina sebuah rumah untuk Tuhan yang disembah oleh Yakub. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tetapi Sulaiman yang membina rumah untuk-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","‘Namun, Tuhan Yang Maha Tinggi tidak tinggal di dalam rumah buatan tangan manusia, seperti kata nabi: ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘ “Syurga arasy-Ku, dan bumi alas kaki-Ku. Rumah apakah yang hendak kamu bina untuk-Ku, dan dimanakah tempat rehat-Ku?” firman Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","‘ “Bukankah Aku sendiri yang telah mencipta semuanya?” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","‘Hai yang keras kepala dan tidak bersunat hati dan telingamu! Kamu sentiasa melawan Roh Suci sebagaimana yang dilakukan oleh nenek moyangmu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nabi manakah yang tidak dianiaya oleh nenek moyangmu? Mereka membunuh nabi-nabi yang telah menubuatkan kedatangan Yang Benar itu, yang kamu khianati dan bunuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kamu telah menerima Taurat Allah yang disampaikan oleh malaikat, tetapi kamu tidak mematuhinya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Apabila mendengar kata-kata ini, mereka tersangat sakit hati dan berang terhadap Stefanus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Akan tetapi dia dipenuhi Roh Suci lalu merenung ke langit dan melihat kemuliaan Allah serta Isa berdiri di sebelah kanan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dia berkata, ‘Lihatlah! Aku nampak syurga terbuka dan Putera Insan berdiri di sebelah kanan Allah!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mereka pun bertempik sambil menutup telinga lalu menyerang Stefanus serentak. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Mereka menyeret dia ke luar kota lalu merejamnya. Orang yang menyaksikan segalanya itu meletakkan jubah mereka di kaki seorang muda bernama Saul. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ketika mereka merejam Stefanus, dia berseru, ‘Junjungan Isa, terimalah rohku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kemudian dia berlutut dan berteriak dengan suara yang kuat, ‘Junjungan, jangan tanggungkan dosa ini atas mereka.’ Setelah berkata demikian, dia pun meninggal dunia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul menyetujui kematian Stefanus. Pada masa itu penganiayaan yang dahsyat dilakukan terhadap jemaah di Baitulmaqdis; dan mereka pun bercerai-berai di serata Yudea dan Samaria, kecuali para rasul. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Beberapa orang yang salih mengebumikan Stefanus dan amat meratapi kematiannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saul berusaha untuk menghapuskan jemaah; dia memasuki setiap rumah dan menyeret keluar lelaki perempuan lalu memasukkan mereka ke dalam penjara. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mereka yang bercerai-berai pergi merata-rata mengajarkan firman Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Kemudian Filipus pergi ke sebuah kota di Samaria dan memberitakan al-Masih kepada orang di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Apabila orang ramai mendengar apa yang dikatakan Filipus dan melihat segala keajaiban yang dilakukannya, mereka semua memperhatikan dengan sepenuh hati apa yang dikatakannya; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","kerana roh-roh durjana keluar sambil melolong daripada ramai orang yang kerasukan, manakala sebilangan besar yang lumpuh dan tempang telah disembuhkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Seluruh kota itu amat bersukacita. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Akan tetapi ada seorang lelaki bernama Simon, yang dahulunya mengamalkan sihir di situ dan mengagumkan orang Samaria serta mengaku dirinya seorang yang hebat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mereka semua, daripada yang paling rendah tarafnya hinggalah kepada yang tertinggi, mendengar katanya. Mereka berkata, ‘Orang ini dikenal sebagai Kuasa Besar Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Mereka mendengar katanya kerana dia telah lama mengagumkan mereka dengan sihirnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Namun apabila mereka mempercayai Filipus ketika dia bercakap tentang hal-hal berkaitan dengan kerajaan Allah dan nama Isa al-Masih, mereka pun diimadkan, baik lelaki mahupun perempuan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Kemudian Simon sendiri percaya; dan setelah diimadkan dia terus menyertai Filipus dan amat kagum melihat keajaiban serta alamat yang dilakukan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apabila para rasul di Baitulmaqdis mendengar bahawa orang Samaria telah menerima firman Allah, mereka mengutus Petrus dan Yahya ke sana. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Setelah sampai di situ, kedua-duanya berdoa semoga mereka menerima Roh Suci, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kerana mereka belum lagi dipenuhi oleh-Nya. Mereka baru diimadkan sahaja dengan nama Junjungan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kemudian Petrus dan Yahya meletakkan tangan atas mereka lalu mereka menerima Roh Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Setelah Simon melihat betapa Roh Suci diberi ketika para rasul meletakkan tangan, dia menawarkan wang kepada mereka ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","sambil berkata, ‘Berilah aku kuasa itu juga, supaya sesiapa yang kuletakkan tangan atasnya akan menerima Roh Suci.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tetapi Petrus berkata kepadanya, ‘Punahlah wangmu bersamamu, kerana kamu menyangka kurnia Allah dapat dibeli dengan wang! ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kamu tidak ada bahagian dalam pekerjaan kami, kerana hatimu tidak ikhlas di sisi Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Oleh itu bertaubatlah daripada kejahatanmu itu, dan berdoalah kepada Tuhan semoga kamu dapat diampuni kerana niat di hatimu itu; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","kerana kulihat kamu diracuni perasaan kepahitan dan dibelenggu dosa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon menjawab, ‘Berdoalah kepada Tuhan untukku, supaya apa yang kamu sebutkan tadi tidak menimpaku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Setelah mereka memberi kesaksian dan menyampaikan firman Tuhan, mereka pun pulang ke Baitulmaqdis, sambil menyebarkan perkhabaran baik tentang Isa di banyak kampung orang Samaria. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malaikat Tuhan berkata kepada Filipus, ‘Bangkit dan pergilah ke arah selatan di jalan antara Baitulmaqdis dengan Gaza. Sekarang tempat itu lengang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Dia pun bangkit lalu pergi. Ada seorang Habsyi, seorang sida-sida yang besar pangkatnya di bawah perintah Kandake, ratu negeri Habsyah, dan ditugaskan menjaga seluruh perbendaharaannya. Dia telah pergi ke Baitulmaqdis untuk sembahyang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ketika dia sedang dalam perjalanan pulang dan sambil duduk di dalam kereta kudanya, dia membaca kitab Nabi Yasyaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Roh Suci berkata kepada Filipus, ‘Pergi dekati kereta kuda itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipus pun berlari mendapatkannya lalu mendengarnya membaca kitab Nabi Yasyaya. Filipus berkata, ‘Fahamkah apa yang kamu baca itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jawabnya, ‘Bagaimana aku dapat memahaminya, kecuali ada orang yang membimbingku?’ Dia pun mengajak Filipus naik duduk di sisinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bahagian Kitab Suci yang dibacanya ialah: ‘Dia dibawa seperti domba untuk disembelih seperti anak domba yang senyap ketika bulunya digunting. Demikianlah Dia tidak membuka mulut. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dia dihina dan keadilan direntap daripada-Nya, maka siapa akan mengisahkan keturunan-Nya? Nyawa-Nya direnggut dari muka bumi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Sida-sida itu berkata, ‘Aku bertanya kepadamu, tentang siapakah nabi itu bercakap, tentang dirinya atau seseorang lain?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipus pun membuka mulutnya: bermula dari bahagian Kitab Suci itu, dia mengajar berita baik tentang Isa kepada sida-sida itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Sedang mereka meneruskan perjalanan, mereka sampai ke suatu tempat yang berair. Sida-sida itu berkata, ‘Lihat, di sini ada air. Apa yang menghalang aku daripada diimadkan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipus berkata, ‘Jika kamu percaya sepenuh hati, kamu boleh diimadkan.’ Sida-sida itu menjawab, ‘Aku percaya bahawa Isa al-Masih itu Putera Allah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Lalu dia mengarahkan kereta kuda itu dihentikan. Dia bersama Filipus turun ke dalam air, lalu Filipus mengimadkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Setelah mereka keluar dari air, Roh Suci mengambil Filipus dari situ. Sida-sida itu tidak melihatnya lagi, lalu meneruskan perjalanan dengan sukacita. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipus mendapati dirinya di Asdod. Dia meneruskan perjalanan sambil mengkhabarkan Injil di segala kota hingga sampai di Kaisarea. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul, yang terus-menerus mengancam hendak membunuh pengikut-pengikut Junjungan Isa, pergi mendapatkan imam besar ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","dan meminta surat untuk ditunjukkan kepada saumaah di Damsyik, supaya sekiranya dia menjumpai sesiapa yang mengikut Jalan Isa, baik lelaki mahupun perempuan, dia boleh memberkas dan membawa mereka ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Dalam perjalanannya, apabila dia hampir sampai di Damsyik, tiba-tiba cahaya dari langit bersinar sekelilingnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Dia rebah ke bumi lalu mendengar suara berkata, ‘Saul, Saul, mengapa kauaniaya Aku?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul bertanya, ‘Siapakah Engkau, Tuan?’ Suara itu menjawab, ‘Akulah Isa yang kauaniaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bangkitlah, masuklah ke kota. Di sana engkau akan diberitahu apa yang harus kaubuat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Orang seperjalanan Saul terpegun kerana mendengar suara itu tanpa melihat sesiapapun. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul bangkit sambil membuka mata tetapi tidak dapat melihat suatu apa. Oleh demikian mereka memegang tangannya dan memimpinnya masuk ke Damsyik. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Selama tiga hari dia tidak dapat melihat dan tidak makan atau minum. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ada seorang pengikut Isa yang bernama Ananias tinggal di Damsyik. Dalam suatu penglihatan dia mendengar Junjungan berkata, ‘Ananias!’ ‘Ya, Junjungan,’ sahut Ananias. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Junjungan berkata kepadanya, ‘Bersiaplah dan pergilah ke rumah Yudas di Jalan Lurus. Tanyakanlah seorang yang bernama Saul dari kota Tarsus. Dia sedang berdoa, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","dan melihat seorang bernama Ananias meletakkan tangan di atasnya supaya dia dapat melihat semula.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias menjawab, ‘Ya Junjunganku, aku telah mendengar ramai orang mengatakan hal orang itu. Dia telah banyak menganiaya umat-Mu yang salih di Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Sekarang dia datang ke Damsyik membawa kuasa daripada ketua-ketua imam untuk menangkap semua orang yang menyebut nama-Mu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Namun, Junjungan berkata, ‘Pergilah, kerana Aku telah memilihnya sebagai alat pilihan-Ku untuk mengkhabarkan nama-Ku kepada bangsa-bangsa asing, raja-raja, dan umat Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aku akan menunjukkan kepadanya segala kesengsaraan yang akan ditanggungnya kerana-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dengan demikian Ananias pun pergi lalu masuk ke rumah itu dan meletakkan tangannya ke atas Saul sambil berkata, ‘Saudaraku Saul, Junjungan telah mengutusku. Isa yang menampakkan diri-Nya kepadamu dalam perjalanan ke sini telah mengutusku supaya engkau dapat melihat semula dan dipenuhi Roh Suci.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Serta-merta sesuatu seperti sisik gugur daripada mata Saul dan dia dapat melihat semula. Dia pun bangun lalu diimadkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kemudian dia makan dan kekuatannya pun pulih. Saul tinggal beberapa hari di Damsyik bersama para pengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dia terus mengkhabarkan di saumaah-saumaah tentang Isa, bahawa Dia Putera Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Semua yang mendengarnya tercengang lalu berkata, ‘Bukankah dia ini yang menganiaya semua yang menyebut nama itu di Baitulmaqdis? Malah dia datang ke mari untuk menangkap semua orang yang demikian di sini dan menyeret mereka ke hadapan ketua-ketua imam.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Makin sehari makin bertambah kuasa yang diberi Allah kepada Saul. Semua orang Yahudi di Damsyik tercengang apabila dia menyatakan bahawa Isa itu al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Selepas beberapa hari, orang Yahudi berpakat hendak membunuh Saul ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","tetapi dia mendapat tahu tentang pakatan itu. Orang yang hendak membunuhnya itu menunggu di pintu gerbang siang malam; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","tetapi pengikut-pengikut Saul mengambilnya pada waktu malam dan menurunkannya melalui tingkap ke kaki tembok di dalam sebuah keranjang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Apabila Saul sampai di Baitulmaqdis, dia cuba menghubungi para pengikut Isa tetapi mereka takut dan tidak percaya bahawa dia benar-benar pengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas membawa Saul ke hadapan para rasul dan menceritakan bagaimana dia telah melihat Junjungan ketika dalam perjalanan, kata-kata Junjungan kepadanya dan keberanian Saul menyebarkan nama Isa di Damsyik. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Selepas itu Saul keluar masuk di Baitulmaqdis bersama para rasul ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","serta menyebarkan nama Junjungan dengan berani. Dia bercakap dan berhujah dengan orang Yahudi peranakan Yunani; mereka pun hendak membunuhnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Apabila para pengikut Isa yang lain mengetahui hal itu, mereka membawa Saul ke Kaisarea dan menghantarnya ke Tarsus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dengan demikian sejahteralah jemaah di seluruh tanah Yudea, Galilea dan Samaria. Jemaah itu diberi kekuatan dan hidup bertakwa kepada Allah. Dengan pertolongan Roh Suci bilangan mereka semakin besar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ketika Petrus melawat daerah-daerah, dia mengunjungi orang salih yang tinggal di Lida. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Di situ dia menemui seorang bernama Eneas yang sudah lapan tahun lumpuh terlantar di tempat tidur. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus berkata kepadanya, ‘Eneas, Isa al-Masih menyembuhkanmu. Bangunlah, kemaskan tempat tidurmu.’ Pada saat itu juga Eneas bangun. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Semua penduduk Lida dan Saron melihatnya lalu beriman kepada Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Di Yope ada seorang perempuan pengikut Isa bernama Tabita (dalam bahasa Yahudi disebut Dorkas); dia sentiasa membuat kebajikan dan memberi sedekah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pada masa itu dia jatuh sakit lalu meninggal dunia. Setelah dimandikan, jenazahnya dibaringkan di dalam bilik di tingkat atas. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Oleh sebab Lida berdekatan dengan Yope, para pengikut Isa di Yope mendapat tahu Petrus ada di Lida lalu menghantar dua orang berjumpa dengannya dan memintanya datang secepat mungkin. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petrus segera pergi bersama mereka. Setibanya di situ, dia dibawa naik ke bilik di tingkat atas itu. Semua balu di situ berdiri di sisinya sambil menangis dan menunjukkan pelbagai pakaian yang telah dijahit oleh Dorkas untuk mereka sewaktu hidupnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrus menyuruh semuanya keluar; kemudian dia bertelut dan berdoa. Selepas itu dia berpaling kepada jenazah itu lalu berkata, ‘Hai Tabita, bangunlah.’ Tabita membuka matanya dan apabila dia melihat Petrus, dia pun duduk. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petrus memegang tangannya dan membantunya berdiri. Seterusnya Petrus memanggil semua pengikut Isa termasuk balu-balu itu dan menunjukkan kepada mereka perempuan yang sudah hidup itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Berita itu tersebar di seluruh Yope dan ramai orang beriman kepada Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petrus tinggal beberapa hari di Yope di rumah Simon, seorang penyamak kulit. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Di Kaisarea ada seorang bernama Kornelius, ketua tentera yang disebut pasukan Itali. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Dia seorang yang bertakwa dan takut akan Allah, begitu juga seisi rumahnya. Dia banyak bersedekah kepada orang yang miskin dan sentiasa berdoa kepada Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pada suatu hari kira-kira pukul tiga petang, dalam suatu penglihatan dia melihat dengan nyata malaikat Allah mendapatkannya dan berkata kepadanya, ‘Hai Kornelius!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Dia merenung dengan ketakutan sambil bertanya, ‘Ya tuan, ada apa tuan?’ Malaikat itu berkata, ‘Segala doa dan sedekahmu telah diredai Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Suruhlah orang pergi ke Yope memanggil seorang bernama Simon bergelar Petrus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Dia menumpang di rumah Simon penyamak kulit, di tepi laut.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Setelah malaikat itu pergi, Kornelius memanggil dua orang hambanya dan seorang askar yang takut akan Allah dari kalangan orang yang bertugas melayaninya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Dia menceritakan segala yang berlaku itu kepada mereka dan menyuruh mereka pergi ke Yope. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Esoknya, ketika mereka dalam perjalanan dan hampir sampai ke Yope, Petrus naik ke atas bumbung rumah untuk berdoa, kira-kira pukul dua belas tengah hari. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kemudian dia berasa lapar dan hendak makan, tetapi sementara makanan sedang disediakan, dia diliputi kuasa ilahi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Dia melihat langit terbuka dan sesuatu seperti kain yang amat lebar, terikat keempat-empat penjurunya, diturunkan ke arahnya lalu ke bumi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Di dalamnya ada segala jenis binatang, yang berkaki empat dan yang melata, juga burung-burung. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dia terdengar suara berkata, ‘Hai Petrus, bangunlah, sembelih dan makanlah.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petrus berkata, ‘Ya Tuhan, jangan demikian, aku belum pernah makan barang yang haram atau najis.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Suara itu berkata pula kepadanya, ‘Barang yang dihalalkan oleh Allah, jangan kauharamkan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ini berulang tiga kali, kemudian kain itu terangkat naik ke langit. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Sedang Petrus bertanya-tanya apa agaknya erti penglihatan itu, orang yang disuruhkan oleh Kornelius itu telah bertanyakan rumah Simon. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mereka berdiri di muka pintu sambil berseru bertanya sama ada Simon bergelar Petrus ada menumpang di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petrus masih lagi memikirkan penglihatannya itu. Roh Suci berkata kepadanya, ‘Ada tiga orang mencarimu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bangunlah, turun dan pergi bersama mereka tanpa ragu-ragu, kerana Aku yang menyuruh mereka datang.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petrus pun turun mendapatkan orang itu lalu berkata, ‘Aku inilah orang yang kamu cari itu; apa hajatmu datang ke mari?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mereka berkata, ‘Kornelius, seorang ketua tentera yang benar dan takut akan Allah serta disegani oleh seluruh bangsa Yahudi, telah menerima pesan Allah melalui malaikat yang suci bahawa dia hendaklah menjemput tuan datang ke rumahnya untuk mendengar apa yang akan tuan katakan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petrus mengajak ketiga-tiga orang itu masuk dan menumpang bermalam di rumah itu. Esoknya dia bangun lalu pergi bersama mereka; beberapa orang saudara seiman di Yope turut serta. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Keesokan harinya mereka sampai di Kaisarea. Kornelius sedang menantikan kedatangan mereka, bersama semua kaum keluarga dan sahabat handai yang diajaknya berhimpun di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Apabila Petrus masuk, Kornelius mendapatkannya lalu sujud menyembah di kakinya; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","tetapi Petrus menariknya bangkit berdiri sambil berkata, ‘Bangkitlah; aku in pun seorang manusia juga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Sambil bercakap dengan Kornelius, Petrus masuk ke dalam rumah itu dan melihat betapa ramainya orang yang berhimpun di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petrus berkata kepada mereka, ‘Saudara-saudara sedia maklum bahawa orang Yahudi dilarang berhubung dengan orang bangsa lain atau mengunjungi mereka; tetapi Allah telah menyatakan kepadaku supaya jangan memandang sesiapapun sebagai haram atau najis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Oleh itu apabila aku dipanggil, aku terus datang tanpa teragak-agak. Sekarang aku bertanya kepadamu, apakah sebabnya aku dipanggil datang ke sini?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelius berkata, ‘Empat hari lalu, kira-kira pukul tiga petang, aku sedang berdoa di rumah; tiba-tiba seorang berdiri di hadapanku, pakaiannya bersinar-sinar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Dia berkata, “Hai Kornelius! Segala doa dan sedekahmu telah diredai Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Suruhlah orang pergi ke Yope memanggil seorang bernama Simon bergelar Petrus. Dia menumpang di rumah Simon penyamak kulit, di tepi laut.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aku terus menyuruhkan orang mendapatkanmu; kamu sungguh baik hati datang ke mari. Sekarang kami semua hadir di sini di hadapan Allah untuk mendengar segala perkara yang diperintahkan Tuhan kepadamu untuk disampaikan kepada kami.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petrus pun berkata, ‘Sesungguhnya aku mengerti sekarang bahawa Allah tidak memilih kasih. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sesiapa yang takut akan Allah dan mengerjakan yang benar, tidak kira apa bangsanya, dialah yang diredai-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Firman yang disampaikan Allah kepada bangsa Israel adalah firman yang mengkhabarkan kesejahteraan melalui Isa al-Masih, Junjungan semua manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Saudara-saudara tahu akan apa yang berlaku di seluruh tanah Yudea mulai dari Galilea, selepas pengimadan yang dikhabarkan oleh Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Perkhabaran itu tentang Isa orang Nasaret, betapa Allah telah memilih-Nya sebagai al-Masih dan memberi-Nya Roh Suci serta kuasa. Dia telah pergi merata-rata membuat kebajikan dan menyembuhkan orang yang diseksa oleh Iblis, kerana Allah menyertai Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","‘Kami ini menjadi saksi akan segala yang dilakukan-Nya di tanah orang Yahudi malah juga di Baitulmaqdis. Dia telah dibunuh dengan disalib; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","tetapi Allah membangkitkan-Nya pada hari yang ketiga serta memperlihatkan Dia; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","bukan kepada semua orang tetapi kepada kami yang telah dipilih oleh Allah sebagai saksi, kami yang semakan seminum dengan-Nya setelah Dia bangkit dari kalangan orang mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dia memerintah kami mengkhabarkan kepada semua orang dan memberikan kesaksian bahawa Dialah yang dijadikan Allah hakim ke atas orang hidup dan orang mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Semua nabi bersaksi tentang-Nya bahawa setiap orang yang percaya kepada Isa akan diampunkan dosanya dengan nama-Nya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ketika Petrus sedang bercakap, Roh Suci turun dan memenuhi semua yang mendengar perkhabaran itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Beberapa orang Yahudi yang percaya kepada Isa dan datang bersama Petrus dari Yope berasa hairan melihat Allah mencurahkan Roh Suci kepada orang bukan bani Israel juga. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mereka mendengar orang itu bertutur dalam aneka bahasa memuji Allah. Kemudian Petrus berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","‘Lihatlah, mereka telah menerima Roh Suci seperti kita. Dapatkah sesiapa menghalang mereka diimadkan dengan air?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Petrus pun menyuruh mereka diimadkan dengan nama Isa al-Masih. Selepas itu mereka meminta Petrus tinggal dengan mereka beberapa hari. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Para rasul dan saudara-saudara di seluruh Yudea mendengar khabar bahawa orang bukan bani Israel juga telah menerima firman Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Apabila Petrus pergi ke Baitulmaqdis, orang Yahudi yang percaya kepada Isa dan masih berpegang kepada upacara sunat, membantah perbuatannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Mereka berkata, ‘Kamu telah menumpang di rumah orang bangsa asing yang tidak bersunat; malah kamu telah makan bersama mereka!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Oleh yang demikian, Petrus menerangkan segala yang telah berlaku, satu persatu: ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","‘Ketika aku sedang berdoa di Yope, aku telah melihat satu penglihatan. Aku melihat sesuatu seperti kain yang amat lebar, terikat keempat-empat penjurunya, diturunkan dari langit lalu terletak dekat denganku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Aku memerhatikannya lalu melihat binatang yang berkaki empat, yang liar dan yang melata, juga burung-burung. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Aku mendengar suara berkata, “Hai Petrus, bangunlah, sembelih dan makanlah.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","‘Aku berkata, “Ya Tuhan, jangan demikian, aku belum pernah makan barang yang haram atau najis.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","‘Suara itu berkata pula kepadaku, “Barang yang dihalalkan oleh Allah, jangan kau haramkan.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ini berulang tiga kali, kemudian semuanya terangkat naik semula ke langit. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","‘Pada ketika itu tiga orang yang diutus dari Kaisarea kepadaku berdiri di hadapan rumah yang kami tumpang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Roh Suci menyuruh aku pergi bersama mereka tanpa ragu-ragu. Enam orang saudara seiman di Yope menyertaiku ke Kaisarea lalu kami masuk ke rumah Kornelius. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kornelius bercerita kepada kami bahawa dia telah melihat malaikat berdiri di hadapannya di rumahnya dan berkata kepadanya, “Suruhlah orang pergi ke Yope memanggil seorang bernama Simon bergelar Petrus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Dia akan menyampaikan perkhabaran yang menyelamatkan kamu sekeluarga.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","‘Apabila aku mula bercakap, Roh Suci memenuhi mereka, seperti yang terjadi kepada kita dahulu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ketika itu aku teringat kata-kata Junjungan: “Yahya mengimadkan dengan air, tetapi kamu akan diimadkan dengan Roh Suci.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jelaslah bahawa Allah telah memberi orang asing itu kurnia yang sama seperti yang kita terima ketika kita beriman kepada Junjungan Isa al-Masih. Siapakah aku untuk cuba menghalang kuasa Allah?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Setelah mendengar penjelasan Petrus, mereka tidak membantah perbuatannya lagi, lantas mereka memuji Allah dan berkata, ‘Kalau begitu, Allah memberikan peluang kepada orang bukan bani Israel juga untuk bertaubat dan mendapat hidup.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Setelah Stefanus dibunuh, orang yang tercerai-berai kerana dianiaya sampai ke Finisia, Siprus dan Antiokhia. Mereka menyampaikan firman hanya kepada orang Yahudi; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","tetapi sesetengah daripada mereka dari Siprus dan Kirene datang ke Antiokhia lalu menyampaikan berita baik tentang Junjungan Isa kepada orang bukan bani Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Melalui kuasa Tuhan yang menyertai mereka, ramai orang percaya dan berpaling kepada-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jemaah di Baitulmaqdis mendengar hal itu lalu menyuruh Barnabas pergi ke Antiokhia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Setelah dia sampai dan melihat kasih kurnia Allah itu, dia amat sukacita dan menggalakkan mereka semua supaya meneguhkan azam untuk tetap setia kepada Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas orang baik, penuh dengan Roh Suci dan iman. Semakin bertambahlah bilangan orang yang percaya akan Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kemudian Barnabas pergi ke Tarsus mencari Saul; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","setelah menemuinya, dibawanya ke Antiokhia. Selama setahun kedua-duanya berserta dengan jemaah dan mengajar ramai orang. Di Antiokhialah para pengikut mula-mula disebut Masihi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Pada masa itu beberapa orang nabi turun dari Baitulmaqdis ke Antiokhia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Seorang yang bernama Agabus bernubuat dengan ilham Roh Suci bahawa bencana kebuluran akan melanda seluruh dunia; ini sesungguhnya terjadi pada zaman Klaudius. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Para pengikut Isa membuat keputusan hendak menghantar bantuan, menurut kemampuan masing-masing, kepada saudara-saudara di Yudea. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mereka mengirimkannya kepada tua-tua melalui Barnabas dan Saul. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Pada masa itu Raja Herodes pula turut menganiaya beberapa orang daripada jemaah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yakobus saudara Yahya dibunuhnya dengan pedang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Apabila dilihatnya orang Yahudi sukacita dengan tindakannya, dia menangkap Petrus pula, pada Perayaan Roti Tidak Beragi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Dia memasukkan Petrus ke dalam penjara dan menyerahkannya kepada enam belas orang askar yang bertugas menjaganya bergilir-gilir, empat orang segiliran. Niatnya hendak membawa Petrus ke hadapan orang Yahudi selepas perayaan Paska. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Sementara itu Petrus dikawal rapi di dalam penjara; tetapi jemaah berdoa dengan sungguh-sungguh kepada Allah untuknya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pada malam sebelum hari perbicaraan yang ditetapkan oleh Herodes itu, Petrus tidur antara dua orang askar, terikat dengan dua rantai; di samping itu para pengawal berjaga di hadapan pintu penjara itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tiba-tiba malaikat Tuhan terdiri di situ dan cahaya menyinari bilik itu. Malaikat itu menepuk Petrus dan membangunkannya lalu berkata, ‘Cepat bangun.’ Dalam sekelip mata gugurlah rantai dari tangan Petrus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malaikat itu berkata lagi, ‘Ikatlah tali pinggang dan pakailah kasutmu.’ Setelah Petrus berbuat demikian, malaikat itu berkata lagi, ‘Pakailah jubahmu dan ikutlah aku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petrus mengikut malaikat itu keluar dari penjara tanpa mengetahui sama ada segalanya itu benar-benar terjadi atau hanya suatu penglihatan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mereka melalui tempat pengawal berjaga yang pertama dan yang kedua. Akhirnya mereka sampai di pintu besi yang menghala ke kota lalu pintu itu terbuka dengan sendirinya dan mereka pun keluar. Ketika mereka berjalan di suatu lorong, malaikat itu pun tiba-tiba meninggalkan Petrus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pada saat itu barulah Petrus sedar apa yang telah terjadi. Dia berkata, ‘Sekarang tahulah aku bahawa segalanya benar-benar berlaku. Tuhan telah mengutus malaikat-Nya untuk menyelamatkan aku daripada Raja Herodes dan segala yang hendak dilakukan oleh orang Yahudi kepadaku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Setelah itu, Petrus pergi ke rumah Maryam, ibu kepada Yahya yang bergelar Markus. Di situ ramai orang berhimpun dan sedang berdoa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Apabila Petrus mengetuk pintu, seorang perempuan bernama Rode datang ke pintu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Dia mengenali suara Petrus. Akan tetapi dia begitu sukacita hinggakan terus masuk semula tanpa membukakan pintu. Dia memberitahu bahawa Petrus ada di luar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","‘Kamu gila!’ seru mereka, namun Rode beria-ia mengatakan orang yang di luar itu Petrus. Mereka berkata, ‘Tentu itu rohnya!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petrus mengetuk pintu lagi berulang-ulang. Akhirnya mereka membukakan pintu dan tercengang apabila melihat Petrus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrus memberikan isyarat meminta mereka bertenang lalu mengisahkan betapa Tuhan telah mengeluarkannya dari penjara. Selepas itu Petrus berkata, ‘Khabarkanlah hal ini kepada Yakobus dan saudara-saudara lain.’ Kemudian dia pun pergi ke tempat lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Setelah hari siang, askar-askar yang berkawal itu gempar, tertanya-tanya apakah yang telah terjadi kepada Petrus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Raja Herodes menyuruh orang mencari Petrus tetapi tidak berjaya. Lantas Raja Herodes mengeluarkan perintah supaya askar-askar yang berkawal itu disoal siasat dan kemudiannya dihukum bunuh. Selepas itu Raja Herodes berpindah dari Yudea ke Kaisarea lalu tinggal di sana. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Raja Herodes amat murka terhadap orang Tirus dan Sidon. Oleh yang demikian, mereka datang bersama-sama untuk menghadap Raja Herodes. Pertama sekali mereka mendapatkan sokongan Blastus, ketua istana Raja Herodes. Selepas itu mereka menghadap Raja Herodes dan meminta berdamai, kerana bekalan makanan negeri mereka bergantung kepada negeri Raja Herodes. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pada hari yang telah ditetapkan, Raja Herodes mengenakan pakaian kebesaran diraja, duduk di atas singgahsana lalu berkata kepada rakyat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mereka berseru, ‘Itu suara seorang dewa, bukan manusia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pada saat itu malaikat Tuhan memukul Raja Herodes kerana tidak menghormati Allah. Raja Herodes pun mati dimakan ulat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Firman Allah semakin luas tersebar dan kian ramai orang percaya kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Setelah Barnabas dan Saul menjalankan tugas mereka pulang dari Baitulmaqdis dan membawa Yahya yang bergelar Markus itu bersama mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Di antara jemaah di Antiokhia ada beberapa orang nabi dan guru: Barnabas, Simeon yang bergelar Niger, Lukius dari Kirene, Menahem, yang dibesarkan bersama raja Herodes, dan Saul. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sedang mereka beribadat dan berpuasa, Roh Suci berkata kepada mereka, ‘Khaskan Barnabas dan Saul untuk-Ku, bagi melaksanakan tugas yang telah Kutetapkan untuk mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Setelah berpuasa dan berdoa, mereka meletakkan tangan ke atas Barnabas dan Saul lalu melepaskan mereka pergi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas dan Saul diutus ke Seleukia oleh Roh Suci. Dari situ mereka belayar ke pulau Siprus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Apabila sampai di Salamis, mereka menyampaikan firman Allah di saumaah-saumaah, dibantu oleh Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Mereka pergi ke serata pulau itu hingga sampai di Pafos. Di situ mereka bertemu dengan seorang ahli sihir bernama Bar-Yusha, seorang nabi palsu Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Dia berkawan baik dengan Sergius Paulus, pemerintah pulau itu, seorang yang bijaksana. Sergius Paulus memanggil Barnabas dan Saul kerana ingin mendengar firman Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Akan tetapi Elimas ahli sihir itu (ini namanya dalam bahasa Yunani) cuba menghalang pemerintah itu daripada percaya kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saul, yang juga disebut Paulus, dipenuhi oleh Roh Suci lalu merenung ahli sihir itu dan ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","berkata, ‘Hai kamu anak Iblis, seteru segala yang benar, kamu yang penuh dengan tipu daya! Tiadakah kamu mahu berhenti memesongkan jalan Tuhan yang betul? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tuhan akan menghukum kamu pada saat ini juga. Kamu akan buta, tidak dapat melihat cahaya matahari buat beberapa waktu.’ Dalam sekelip mata Elimas merasa kabus gelap menyelaputi matanya. Dia pun berjalan teraba-raba mencari orang yang dapat memimpinnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Apabila pemerintah itu melihat apa yang terjadi, dia pun mempercayai Isa dan amat kagum akan pengajaran Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulus dan rakan-rakannya belayar dari Pafos ke kota Perga di tanah Pamfilia. Dari situ Yahya meninggalkan mereka lalu pulang ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Yang lain meneruskan perjalanan dari Perga ke kota Antiokhia di Pisidia. Pada hari Sabat mereka masuk ke rumah ibadat lalu duduk di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Selepas pembacaan Taurat Musa dan Surah Nabi-nabi, ketua-ketua saumaah itu menghantar orang berkata kepada kedua-dua rasul itu, ‘Saudara-saudara, sekiranya ada sesuatu nasihat untuk menggalakkan orang di sini, silalah sampaikan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulus bangkit, memberikan isyarat lalu berkata, ‘Saudara-saudara orang Israel dan sekalian yang taat kepada Allah, dengarlah! ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Allah, Tuhan umat Israel, telah memilih nenek moyang kita untuk dijadikan bangsa besar, ketika mereka tinggal menumpang di Mesir. Allah membawa mereka keluar dari Mesir dengan kuasa-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Selama empat puluh tahun di gurun, Dia bersabar dengan kelakuan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Dia membinasakan tujuh bangsa di tanah Kanaan dan menjadikan kawasan itu kepunyaan umat-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Segala ini berlaku selama 450 tahun. ‘Selepas itu Allah mengurniai mereka hakim-hakim sampai ke zaman Nabi Samuel. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kemudian mereka memohonkan seorang Raja lalu Allah memberi mereka Saul anak Kis daripada suku Benyamin sebagai raja mereka selama empat puluh tahun. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Setelah Allah memecatnya daripada takhtanya, Allah memberi mereka Daud pula sebagai raja. Allah berfirman tentang Daud, “Aku mendapati Daud, anak Isai, seorang yang menyenangkan hati-Ku; dia akan melakukan segala yang Kuingini.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","‘Dari keturunan Daud inilah Allah membangkitkan Isa, seorang Penyelamat bagi umat Israel sebagaimana telah dijanjikan-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sebelum Isa memulakan tugas-Nya, Yahya menyeru supaya semua orang Israel bertaubat daripada dosa dan diimadkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ketika tugas Yahya hampir selesai, dia berkata kepada orang ramai, “Siapakah aku ini pada sangkaanmu? Aku bukanlah Dia yang kamu nanti-nantikan itu. Dia akan datang kemudian, dan aku ini tidak layak membuka kasut-Nya pun.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","‘Hai saudara-saudara keturunan Ibrahim, dan semua yang takut akan Allah! Kepada kitalah Allah telah menyampaikan berita penyelamatan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Penduduk Baitulmaqdis dan ketua-ketua mereka tidak sedar bahawa Penyelamat itu ialah Isa. Mereka tidak memahami ajaran nabi-nabi yang dibacakan setiap hari Sabat, maka mereka menghukum Isa. Dengan tindakan mereka itu, segala yang telah dinubuatkan oleh nabi-nabi menjadi kenyataan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Walaupun mereka tidak ada apa-apa asas untuk menjatuhkan hukuman bunuh kepada Isa, mereka mendesak Pilatus menjatuhkan hukuman itu ke atas-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Setelah mereka melakukan segala yang tersurat di dalam Kitab Suci tentang-Nya, mereka menurunkan jenazah-Nya dari salib dan meletakkannya di dalam makam. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Akan tetapi Allah membangkitkan-Nya daripada kematian. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Selepas itu selama beberapa hari Dia menampakkan diri-Nya kepada mereka yang dahulu mengiringi-Nya dalam perjalanan dari Galilea ke Baitulmaqdis. Kini mereka itu menjadi saksi bagi-Nya kepada umat Israel. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","‘Dengan demikian kami datang ke sini untuk menyampaikan berita baik ini kepada kamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Allah telah melaksanakan untuk kita apa yang dijanjikan-Nya kepada nenek moyang kita, dengan membangkitkan Isa daripada kematian, sebagaimana yang tersurat di dalam Zabur bab dua: ‘ “Engkaulah Putera-Ku; pada hari ini Aku menjadi Bapa-Mu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Allah telah membangkitkan-Nya daripada kematian. Dia tidak akan mati lagi. Tentang ini Allah berfirman: ‘ “Aku akan memberkati-Mu dengan berkat yang suci, sebagaimana telah Kujanjikan kepada Daud.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Dalam suatu ayat lagi firman-Nya: ‘ “Engkau tidak akan membiarkan Hamba-Mu yang setia itu reput di dalam kubur.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","‘Daud melakukan suruhan Allah ketika dia hidup. Apabila dia wafat dia dimakamkan di sisi nenek moyangnya dan jasadnya reput. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Namun, ini tidak terjadi kepada Dia yang dibangkitkan Allah daripada kematian. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","‘Oleh itu, ketahuilah saudara-saudara, melalui Isa berita pengampunan dosa disampaikan kepada saudara sekalian. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Setiap orang yang percaya kepada-Nya diampunkan segala dosanya yang tidak dapat diampunkan melalui Taurat Musa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Berhati-hatilah, supaya apa yang telah disebutkan oleh nabi-nabi tidak menimpa saudara sekalian: ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘ “Dengarlah hai orang yang menghina Allah! Kamu akan terkejut dan punah! Apa yang Kulakukan kini tidak akan kamu percayai, walaupun diterangkan kepadamu!” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Apabila Paulus dan Barnabas hendak meninggalkan rumah ibadat itu, orang Yahudi meminta mereka datang lagi pada hari Sabat berikutnya untuk meneruskan penerangan mereka tentang hal-hal tersebut. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Setelah bersurai perhimpunan di rumah ibadat itu, ramai orang Yahudi mahupun orang bangsa lain yang telah memeluk agama Yahudi mengikut Paulus dan Barnabas. Kedua-dua rasul itu menasihati mereka supaya sentiasa hidup berpegang teguh kepada kasih kurnia Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pada hari Sabat berikutnya, hampir seluruh penduduk kota itu berhimpun mendengar firman Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Setelah dilihat oleh orang Yahudi betapa ramainya orang datang itu, timbullah hasad dengki dalam hati mereka lalu mereka membangkang kata-kata Paulus serta mencelanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Namun demikian, Paulus dan Barnabas bercakap dengan berani. Mereka berkata, ‘Memang seharusnya firman Allah disampaikan kepada kamu terlebih dahulu. Akan tetapi disebabkan kamu menolak firman-Nya dan menganggap dirimu tidak layak menerima hidup kekal, kami berpaling daripadamu dan pergi kepada bangsa asing. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Inilah perintah Tuhan kepada kami: ‘ “Aku telah menetapkan bahawa kamu menjadi cahaya kepada semua bangsa asing, dan melalui-Mu Allah akan menyelamatkan seluruh dunia.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Orang bangsa asing bersukacita dan memuji firman Allah setelah mendengar kata-kata itu. Mereka yang dipilih Allah untuk menerima hidup kekal pun percayalah kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Firman Tuhan tersebar di serata daerah itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Orang Yahudi menghasut orang yang berkuasa di kota itu dan wanita-wanita terkemuka bangsa asing yang takut akan Allah. Mereka mula menganiaya Paulus dan Barnabas lalu mengusir kedua-duanya dari daerah tersebut. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Rasul-rasul itu pun mengebaskan debu dari kaki mereka sebagai bantahan terhadap orang di situ lalu pergi ke Ikonium. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bagaimanapun, para pengikut Isa amat bergembira dan dipenuhi Roh Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Di Ikonium, Paulus dan Barnabas juga masuk ke saumaah dan kata-kata mereka begitu berkesan sehingga ramai orang Yahudi dan orang Yunani percaya kepada Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Akan tetapi orang Yahudi yang tidak mahu percaya kepada Isa menghasut orang bangsa lain sehingga mereka marah dan menentang pengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Rasul-rasul itu tinggal lama di situ dan berkata-kata dengan berani tentang Tuhan. Tuhan pun menunjukkan kebenaran kata-kata mereka tentang kasih kurnia-Nya dengan memberi mereka kuasa melakukan pelbagai alamat dan mukjizat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Penduduk bandar itu terbahagi dua: sebahagian memihak kepada orang Yahudi dan yang sebahagian lagi kepada rasul-rasul itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kemudian orang Yahudi dan bangsa lain serta ketua-ketua mereka berpakat untuk menganiaya dan merejam rasul-rasul itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Apabila rasul-rasul itu mendapat tahu tentang hal itu, mereka lari ke Listra dan Derbe, kota-kota di Likaonia, serta daerah sekitarnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Di situ mereka menyampaikan berita baik. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Di Listra ada seorang lelaki yang lumpuh kakinya sejak lahir dan tidak pernah berjalan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Dia duduk mendengar kata-kata Paulus. Pada pandangan Paulus orang itu dapat disembuhkan kerana dia mempunyai iman. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Oleh yang demikian Paulus merenungnya sambil bersuara lantang, ‘Bangunlah berdiri tegak!’ Lalu orang itu melompat berdiri dan mula berjalan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Orang ramai melihat apa yang dilakukan oleh Paulus itu lalu berseru dalam bahasa Likaonia, ‘Lihatlah, dewa-dewa telah menjelma sebagai manusia dan turun ke dunia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Dengan demikian Barnabas dipanggil mereka ‘Zeus’ dan Paulus disebut ‘Hermes’ kerana dia yang terutama bercakap. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Imam Dewa Zeus, yang rumah berhalanya di luar kota, datang membawa lembu jantan dan kalungan bunga ke pintu gerbang untuk dijadikan korban persembahannya dan orang ramai kepada rasul-rasul itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Apabila Barnabas dan Paulus mendengar apa yang hendak dilakukan oleh orang di situ, mereka mengoyak-ngoyakkan pakaian dan berlari ke tengah-tengah orang ramai sambil berseru, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","‘Mengapa kamu berbuat begini? Kami manusia biasa seperti kamu sekalian! Kami datang membawa berita baik supaya kamu berhenti daripada pemujaan yang sia-sia ini dan datang kepada Allah yang hidup, yang menjadikan langit, bumi dan laut serta segala yang di dalamnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pada zaman silam, Allah membiarkan manusia mengikut jalan masing-masing. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Namun, Allah sentiasa memberikan kesaksian tentang diri-Nya dengan kebaikan yang dilakukan-Nya. Dia mengurniaimu hujan dari langit dan hasil dari bumi menurut musimnya. Dia mengurniaimu makanan dan kegembiraan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Sungguhpun rasul-rasul itu berkata begitu, sukar juga mereka menghalang orang ramai mempersembahkan korban kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Setelah itu beberapa orang Yahudi dari Antiokhia dan Ikonium mempengaruhi orang ramai sehingga berpihak kepada mereka. Mereka merejam Paulus, kemudian menyeretnya ke luar kota, dengan sangkaan dia sudah mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Akan tetapi apabila pengikut Isa mengelilinginya, dia bangun lalu masuk semula ke dalam kota. Esoknya dia keluar pergi ke Derbe bersama Barnabas. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Setelah menyebarkan berita baik kepada semua penduduk dan membawa beberapa orang menjadi pengikut Isa, kedua-duanya kembali ke Listra, ke Ikonium dan Antiokhia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Di sana mereka menguatkan hati para pengikut Isa dan mengingatkan mereka supaya berpegang teguh kepada kepercayaan mereka, katanya, ‘Memang tidak dapat dielakkan bahawa kita masuk ke dalam kerajaan Allah dengan menanggung banyak kesusahan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Setelah menetapkan para tua-tua bagi setiap jemaah dan berdoa serta berpuasa, mereka menyerahkan mereka kepada Tuhan yang sudahpun dipercayai oleh mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Setelah melalui tanah Pisidia, rasul-rasul itu sampai ke tanah Pamfilia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Mereka menyampaikan firman Allah di Perga, kemudian pergi ke Atalia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Dari sana mereka belayar ke Antiokhia, tempat mereka dahulunya menyerahkan tugas yang baru mereka selesaikan kepada kasih kurnia Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Setelah sampai di sana, mereka menghimpunkan jemaah lalu menceritakan segala yang telah dilakukan Allah melalui mereka dan bagaimana Allah telah membukakan pintu kepercayaan bagi orang bangsa asing. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mereka tinggal di situ beberapa lama bersama pengikut Isa yang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kemudian, beberapa orang datang dari Yudea dan mengajar pengikut Isa di Antiokhia, ‘Jika kamu tidak disunat menurut adat Musa, kamu tidak akan mendapat penyelamatan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ini menyebabkan Paulus dan Barnabas banyak berbahas dan berbantah dengan orang dari Yudea itu. Akhirnya diputuskan bahawa Paulus dan Barnabas serta beberapa orang lain pergi ke Baitulmaqdis berjumpa dengan para rasul dan tua-tua untuk bertanyakan persoalan tersebut. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jemaah menghantar mereka sampai ke luar kota. Semasa mereka meneruskan perjalanan melalui Fenisia dan Samaria, mereka memberitahu bagaimana orang bangsa asing telah percaya kepada Isa. Pengikut-pengikut Isa di situ amat sukacita mendengarnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Setelah sampai ke Baitulmaqdis, jemaah dan para rasul serta tua-tua menyambut mereka. Mereka pun menceritakan segala perkara yang telah dilakukan Allah melalui mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Akan tetapi beberapa orang daripada mazhab Farisi yang telah mempercayai Isa bangkit lalu berkata, ‘Orang bangsa asing itu haruslah disunat dan wajib menurut Taurat Musa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Para rasul dan tua-tua berkumpul untuk menyelidik serta membincangkan perkara itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Setelah perkara itu banyak dibincangkan, Petrus berdiri lalu berkata, ‘Saudara-saudara semuanya tahu bahawa Allah telah memilihku sejak dahulu kala dari kalangan kita semua untuk menyampaikan firman-Nya tentang berita baik kepada bangsa asing, lalu mereka percaya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Allah yang mengetahui hati manusia telah bersaksi akan mereka itu dan memberi mereka Roh Suci sebagaimana diberi-Nya kepada kita. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Allah tidak membezakan mereka dengan kita sedikit pun. Dia menyucikan hati mereka kerana iman mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Sekarang ini mengapa saudara-saudara menduga Allah dengan meletakkan ke atas mereka suatu beban yang tidak dapat ditanggung oleh nenek moyang kita, malah oleh kita ini juga? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kami percaya hanya dengan kasih kurnia Junjungan Isa dapat kita berharap untuk diselamatkan, samalah seperti orang bangsa asing itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Orang ramai pun diam lalu mendengar Barnabas dan Paulus menceritakan segala alamat dan mukjizat yang dilakukan Allah di kalangan bangsa asing melalui mereka berdua. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Setelah mereka habis bercerita, Yakobus pula berkata, ‘Saudara-saudara, dengarlah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon telah menceritakan bagaimana Allah pada mulanya menunjukkan kasih-Nya kepada orang bangsa asing dan memilih dari kalangan mereka suatu kaum untuk menjadi umat-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Hal ini selaras dengan nubuat nabi-nabi yang tersurat: ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘ “Setelah itu Aku akan kembali dan membina semula khemah Daud yang roboh; dan segala keruntuhannya akan Kubangunkan, lalu Kutegakkan semula, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","supaya semua bangsa yang lain akan mencari Tuhan, bangsa asing yang Kupanggil menjadi umat-Ku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Demikianlah firman Tuhan yang telah melakukan semua ini dan yang telah menyatakannya sejak dahulu kala. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","‘Oleh itu pada fikiranku janganlah kita menyusahkan orang bangsa asing yang telah mempercayai Allah; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","tetapi hendaklah kita berkirim surat kepada mereka dan menasihati mereka supaya menjauhkan diri daripada memakan makanan yang telah dipersembahkan kepada berhala, binatang yang mati dicekik, dan darah; dan daripada melakukan zina. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Sejak dahulu kala dalam setiap negara ada orang yang menyebarkan berita tentang Musa dan membaca Tauratnya di saumaah-saumaah pada hari Sabat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Selepas itu, para rasul dan tua-tua serta seluruh jemaah bersetuju memilih beberapa orang di antara mereka untuk ke Antiokhia bersama Paulus dan Barnabas. Orang yang dipilih itu ialah Yudas yang bergelar Barsabas, dan juga Silas, yang mengetuai saudara-saudara itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Mereka diamanahkan membawa sepucuk surat yang berbunyi: ‘Salam daripada para rasul, tua-tua jemaah dan saudara-saudaramu kepada saudara-saudara bukan Yahudi yang tinggal di Antiokhia, Siria dan Kilikia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kami telah mendengar khabar bahawa ada beberapa orang daripada bangsa kami telah mengganggu saudara-saudara dengan kata-kata yang bukan daripada kami. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Oleh itu kami bermuafakat hendak memilih orang untuk pergi bertemu dengan saudara-saudara bersama Barnabas dan Paulus yang kami kasihi, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","iaitu orang yang telah mempertaruhkan nyawa kerana nama Junjungan kita Isa al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kami telah memilih Yudas dan Silas untuk pergi menyampaikan kepada saudara-saudara ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","pesan daripada Roh Suci dan daripada kami: iaitu janganlah diletakkan ke atas saudara-saudara beban yang lebih berat daripada yang perlu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Cuma, jauhkanlah diri daripada memakan makanan yang telah dipersembahkan kepada berhala, binatang yang mati dicekik, dan darah; dan daripada melakukan zina. Jika saudara-saudara memeliharakan diri daripada segala ini, saudara-saudara melakukan hal yang betul. Sekian, selamat sejahtera.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mereka yang diutus itu bertolak ke Antiokhia. Di sana mereka menghimpunkan jemaah dan menyampaikan surat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Apabila jemaah membaca surat itu, mereka bersukacita kerana surat itu memberi perangsang kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudas dan Silas itu kedua-duanya nabi. Mereka menasihati dan menetapkan hati saudara-saudara seiman di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Setelah Yudas dan Silas tinggal di situ, jemaah melepaskan mereka untuk pulang dengan sejahtera kepada orang yang mengutus mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Akan tetapi Silas memutuskan untuk tetap tinggal di Antiokhia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus dan Barnabas tinggal di situ beberapa lama sambil mengajar dan menyampaikan firman Tuhan bersama ramai orang lain. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kemudian, Paulus berkata kepada Barnabas, ‘Sekarang baiklah kita melawat semula saudara-saudara yang percaya kepada Isa di semua kota yang telah kita sampaikan firman Tuhan, untuk melihat bagaimana hal mereka.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas hendak membawa Yahya yang juga bergelar Markus ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","tetapi Paulus tidak bersetuju kerana Markus telah meninggalkan mereka di Pamfilia dan tidak ikut serta menjalankan tugas. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Oleh itu timbul perselisihan sengit dan mereka berpisah: Barnabas membawa Markus belayar ke Siprus ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","manakala Paulus memilih Silas sebagai teman seperjalanannya. Setelah jemaah menyerahkan mereka kepada kasih kurnia Tuhan, mereka pun berangkat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mereka menjelajahi Siria dan Kilikia sambil menetapkan hati jemaah di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus meneruskan perjalanan ke Derbe dan dari situ ke Listra. Di situ ada seorang pengikut Isa bernama Timotius, ibunya orang Yahudi yang percaya kepada Isa tetapi bapanya orang Yunani. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timotius dipandang tinggi oleh para pengikut Isa di Listra dan di Ikonium. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus hendak membawa Timotius bersamanya. Dia pun menyunatkan Timotius kerana semua orang Yahudi di daerah itu tahu bapanya orang Yunani. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Di setiap kota yang dikunjungi, mereka menyampaikan peraturan yang telah ditetapkan oleh para rasul dan ketua-ketua di Baitulmaqdis kepada jemaah di situ untuk dipatuhi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Dengan demikian setiap jemaah semakin teguh imannya dan setiap hari bilangan mereka meningkat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Mereka menjelajahi pula Frigia dan Galatia, kerana Roh Suci melarang mereka menyampaikan firman Allah di Asia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Setelah sampai di sempadan Misia, mereka mencuba masuk ke Bitinia, tetapi dilarang oleh Roh Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Oleh itu mereka terus ke Troas melalui Misia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pada malam itu Paulus mendapat suatu penglihatan: seorang Makedonia berdiri di hadapannya sambil memohon, ‘Marilah ke Makedonia menolong kami.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Setelah Paulus melihat penglihatan itu, kami pun hendak segera bertolak ke Makedonia, kerana pada hemat kami Allah memerintahkan kami menyampaikan berita baik kepada orang di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Oleh yang demikian, kami belayar dari Troas terus ke Samotrake dan esoknya ke Neapolis; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","dan dari situ ke Filipi, sebuah kota di Makedonia, yang termasuk jajahan Empayar Rom; kami tinggal beberapa hari di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pada hari Sabat kami pergi ke luar pintu gerbang kota ke tepi sungai, kerana di situ kami jangka ada tempat orang berdoa. Kami duduk bercakap dengan perempuan yang berhimpun di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Salah seorang yang mendengar kami bercakap ialah seorang perempuan bernama Lidia, yang berjual kain ungu dan berasal dari Tiatira. Dia penyembah Allah. Tuhan membukakan hatinya lalu dia menerima segala yang dikatakan oleh Paulus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Setelah dia dan seisi rumahnya diimadkan, dia berkata, ‘Jika pada hemat kamu, aku ini benar-benar percaya akan Junjungan, marilah tinggal di rumahku.’ Demikian dia bersungguh-sungguh mengajak kami ke rumahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Di tempat orang berdoa itu juga ada seorang hamba perempuan yang dirasuk roh penilik; dia membawa keuntungan yang besar kepada tuan-tuannya dengan tilikannya itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hamba perempuan itu mengikut Paulus dan kami sambil berseru-seru, ‘Orang ini hamba Allah Yang Maha Tinggi; mereka memberitahu kamu bagaimana Allah dapat menyelamatkan kamu!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Demikianlah dilakukannya selama beberapa hari. Akhirnya Paulus gusar dan berpaling sambil berkata kepada roh itu, ‘Dengan nama Isa al-Masih aku perintahkan kamu keluar daripadanya!’ Roh itu pun keluar serta-merta. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Apabila tuan-tuan budak perempuan itu sedar bahawa sumber keuntungan mereka telah dihapuskan, mereka menangkap Paulus dan Silas lalu menyeret mereka ke hadapan pihak berkuasa di medan kota. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Mereka menghadapkan Paulus dan Silas kepada pegawai-pegawai kerajaan Rom dan berkata, ‘Mereka berdua ini membuat kacau di kota kita. Mereka orang Yahudi ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","dan mereka menyebarkan ajaran yang tidak patut kita terima atau ikut kerana kita ini orang Rom.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Orang ramai pun bangkit menentang Paulus dan Silas. Pegawai-pegawai melucutkan pakaian kedua-duanya dan mengarahkan supaya mereka disebat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Setelah disebat beberapa kali, kedua-duanya dimasukkan ke dalam penjara; ketua penjara itu diberi arahan mengawal mereka dengan ketat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Oleh itu, ketua penjara memasukkan Paulus dan Silas ke bahagian penjara yang di dalam sekali serta membelenggu kaki mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Namun demikian, pada waktu tengah malam Paulus dan Silas berdoa dan memuji Allah. Sekalian yang terpenjara itu mendengar doa dan pujian mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tiba-tiba berlaku gempa bumi yang besar, sehingga bergoncang asas penjara itu. Serta-merta semua pintu penjara terbuka dan belenggu semua orang yang terpenjara itu terlucut. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Apabila ketua penjara terjaga daripada tidur dan melihat semua pintu penjara itu terbuka, dia menghunus pedang hendak membunuh diri, kerana sangkanya semua orang yang terpenjara telah lepas lari. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Akan tetapi Paulus berseru dengan lantang, ‘Jangan apa-apakan dirimu, kami semua ada di sini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ketua penjara meminta pelita lalu berlari masuk serta sujud dengan gementar di hadapan Paulus dan Silas. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kemudian dia membawa mereka keluar lalu berkata, ‘Tuan-tuan, apakah yang patut aku lakukan supaya diselamatkan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Mereka menjawab, ‘Percayalah kepada Junjungan Isa, dan kamu akan diselamatkan, kamu dan seisi rumahmu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mereka pun menyampaikan firman Tuhan kepadanya dan seisi rumahnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Pada malam itu juga ketua penjara membasuhkan luka-luka Paulus dan Silas. Dia dan seisi rumahnya diimadkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Selepas itu dia membawa Paulus dan Silas naik ke rumahnya serta menghidangkan makanan untuk mereka dengan amat sukacita kerana dia sekeluarga telah percaya kepada Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Setelah hari siang, pegawai-pegawai kerajaan Rom menghantar anggota polis untuk menyampaikan perintah membebaskan Paulus dan Silas. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ketua penjara memberitahu mereka tentang perintah itu, ‘Pegawai-pegawai menyuruh tuan-tuan dibebaskan. Oleh itu keluarlah dan pergilah dengan sejahtera.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Akan tetapi Paulus berkata, ‘Mereka telah menyebat kami di hadapan orang ramai tanpa menyiasat, sungguhpun kami orang Rom. Mereka telah memasukkan kami ke dalam penjara. Sekarang mereka hendak membebaskan kami senyap-senyap? Tidak boleh begitu! Hendaklah mereka sendiri datang membawa kami keluar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kata-kata Paulus itu disampaikan oleh anggota polis kepada pegawai-pegawai itu. Apabila mendengar bahawa Paulus dan Silas orang Rom, pegawai-pegawai itu pun takut ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","lalu datang memujuk mereka, membawa mereka keluar dan meminta mereka meninggalkan kota itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulus dan Silas keluar dari penjara lalu pergi ke rumah Lidia. Setelah bertemu dengan pengikut-pengikut Isa di situ dan menetapkan hati mereka, Paulus dan Silas pun meneruskan perjalanan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulus dan Silas melalui Amfipolis dan Apolonia lalu sampai di Tesalonika. Di situ ada saumaah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Seperti biasa, Paulus masuk dan berbincang dengan orang di situ tiga hari Sabat berturut-turut tentang ayat-ayat Kitab Suci. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Dia menyatakan dan menunjukkan bahawa al-Masih mengalami kematian dan kemudian bangkit daripada kematian; juga katanya, ‘Isa yang kusebutkan kepadamu inilah al-Masih.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Beberapa orang di situ percaya lalu bersahabat dengan Paulus dan Silas; antara mereka terdapat sebilangan besar orang Yunani yang taat akan Allah serta cukup ramai wanita yang terkemuka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tetapi orang Yahudi berasa dengki lalu mengumpulkan orang jahat dan memulakan huru-hara di kota itu; mereka menyerang rumah Yason untuk membawa keluar rasul-rasul itu menghadap orang ramai. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Apabila mereka tidak menemui Paulus dan Silas, mereka menyeret Yason dan beberapa orang lagi pengikut Isa ke hadapan pegawai-pegawai yang berkuasa sambil berseru, ‘Orang ini telah menimbulkan kekacauan di merata-rata dan sekarang mereka datang pula ke sini ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","lalu dialu-alukan oleh Yason ke rumahnya. Mereka ini melanggar undang-undang Kaisar Rom dengan mengatakan ada orang lain yang menjadi raja, bernama Isa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Apabila orang ramai dan pegawai kerajaan mendengar kata-kata itu, mereka pun gempar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mereka menerima ikat jamin untuk Yason dan yang lain lalu membenarkan mereka pergi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Para pengikut Isa itu segera menyuruh Paulus dan Silas bertolak ke Beria pada waktu malam. Setelah sampai di sana, mereka masuk ke saumaah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Orang Yahudi di situ lebih mulia rohaninya daripada yang di Tesalonika kerana mereka menerima firman Allah dengan amat sukacita dan menyelidik Kitab Suci untuk memastikan setiap kebenaran yang dikatakan Paulus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Oleh yang demikian ramailah di antara mereka yang percaya, baik wanita-wanita Yunani yang berkedudukan tinggi mahupun kaum lelaki. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Akan tetapi apabila orang Yahudi di Tesalonika mendapat tahu bahawa Paulus menyebarkan firman Allah di Beria juga, mereka pergi menghasut dan mengapi-apikan orang di situ supaya merusuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Para pengikut Isa di Beria segera menyuruh hantar Paulus ke pantai manakala Silas dan Timotius masih di Beria. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Orang yang menghantar Paulus itu membawanya hingga ke Atena; setelah menerima pesan Paulus menyuruh Silas dan Timotius segera menyertainya, orang itu pun pulang ke Beria. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Sementara Paulus menantikan kedua-duanya di Atena, dia berasa amat sedih melihat kota itu penuh dengan berhala. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Oleh itu, dia berhujah di saumaah dengan orang Yahudi dan orang Yunani yang taat akan Allah; dan di medan kota juga dia berbincang dengan siapa sahaja yang ditemuinya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Beberapa orang yang berpegang kepada ajaran Epikuros dan Stoa berhujah dengannya. Ada yang berkata, ‘Apa yang dibebelkannya itu?’ Yang lain berkata, ‘Nampaknya orang ini menyebarkan berita tentang dewa-dewa orang bangsa asing.’ Demikianlah kata mereka kerana Paulus menyebarkan berita baik tentang Isa dan kebangkitan daripada kematian. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mereka membawanya ke Areopagus sambil berkata, ‘Bolehkah kami mengetahui apakah ajaran baru yang kamu katakan ini? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kamu menyampaikan ke telinga kami perkara-perkara yang aneh; oleh itu kami hendak mengetahui ertinya segala perkara ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Semua orang Atena dan orang asing di situ asyik sekali membincangkan atau mendengar tentang perkara-perkara terbaru). ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulus berdiri di tengah Areopagus itu lalu berkata, ‘Saudara-saudara orang Atena, aku lihat dalam semua hal saudara-saudara sentiasa ingat menyembah tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Sedang aku berjalan-jalan sambil memerhatikan apa yang saudara-saudara sembah, di suatu tempat aku dapati suatu tempat korban yang ditulis begini: “Kepada Tuhan yang tidak diketahui.” Tuhan yang saudara-saudara sembah tanpa mengetahui-Nya itulah yang hendak aku nyatakan kepada saudara-saudara. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","‘Allah yang menjadikan dunia dengan segala isinya serta memerintah langit dan bumi tidak tinggal di tempat sembahyang buatan manusia, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","dan tidak dilayani oleh manusia kerana Dia tidak kekurangan apa-apa. Malah Dialah yang memberi manusia hidup dan nafas serta segala-galanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Daripada seorang manusia Dia menjadikan semua bangsa manusia yang menduduki seluruh muka bumi; Dia juga menetapkan masa dan tempat mereka hidup. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Masing-masing diharap mencari Tuhan, mudah-mudahan mereka menemui-Nya. Dia tidaklah jauh daripada kita. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","“Kerana-Nya kita bergerak serta ada di dunia ini.” Sebagaimana kata penyair bangsamu, “Kita adalah anak-Nya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","‘Oleh sebab kita anak-Nya, tidak patut kita sangka Dia serupa dengan emas, perak atau batu yang diukir dengan kepandaian dan akal manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Allah membiarkan manusia melalui zaman kejahilan itu; tetapi sekarang Dia menyuruh manusia di seluruh dunia ini bertaubat; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","kerana Dia telah menetapkan bahawa pada suatu hari seisi dunia ini akan dihakimkan dengan adil oleh seorang yang ditentukan-Nya. Allah bersaksi akan hal ini kepada semua manusia dengan membangkitkan-Nya daripada kematian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Apabila mendengar ‘membangkitkan-Nya daripada kematian’, ada yang mengejek-ejek; tetapi ada yang berkata, ‘Kami mahu mendengar lagi kamu bercakap tentang perkara itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Selepas itu Paulus keluar daripada perhimpunan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Namun, ada beberapa orang yang menjadi pengikut Paulus dan percaya akan kata-katanya; di antaranya ialah Dionisius anggota Areopagus, dan seorang wanita bernama Damaris, serta beberapa orang lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Seterusnya, Paulus berangkat dari Atena ke Korintus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Apabila tiba di situ, dia bertemu dengan seorang Yahudi bernama Akwila, yang lahir di kota Pontus. Dia baru datang dari Itali dengan isterinya Priskila, kerana Klaudius telah menitahkan semua orang Yahudi keluar dari Rom. Paulus pergi menemui mereka ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","lalu tinggal dan bekerja bersama mereka kerana mata pencarian mereka sama iaitu sebagai tukang khemah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pada setiap hari Sabat, Paulus berhujah di saumaah untuk meyakinkan orang Yahudi dan juga orang Yunani menjadi pengikut Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Setelah Silas dan Timotius sampai di situ dari Makedonia, Paulus menumpukan masa kepada usaha menyampaikan firman Allah serta memberikan kesaksian kepada orang Yahudi bahawa Isa itulah al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Akan tetapi mereka menentang dan mencelanya; maka Paulus mengebaskan debu daripada pakaiannya lalu berkata, ‘Jika kamu musnah, kamu sendirilah yang bertanggungjawab, aku tidak salah, aku bersih. Dari sekarang aku hendak pergi kepada orang bangsa asing.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Paulus pun berpindah ke rumah Titus Yustus, seorang yang menyembah Allah; rumahnya bersebelahan dengan saumaah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, ketua saumaah itu, serta seisi rumahnya, percaya kepada Junjungan Isa; ramai lagi orang Korintus turut mendengar dan percaya lalu diimadkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pada suatu malam Tuhan berfirman kepada Paulus dalam satu penglihatan, ‘Jangan takut, berkata-katalah terus dan jangan berhenti, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kerana Aku menyertaimu. Tiada seorang pun akan dapat mencederakanmu, kerana ramai orang di kota ini umat-Ku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paulus tinggal di situ setahun setengah sambil menyebarkan firman Allah kepada orang di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Semasa Galio menjadi pemerintah negeri Akhaya, orang Yahudi bangkit dengan sehati melawan Paulus lalu membawanya ke muka keadilan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Mereka berkata, ‘Orang ini cuba mempengaruhi orang ramai supaya menyembah Allah dengan cara yang bercanggah dengan hukum Taurat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Apabila Paulus hendak menjawab, Galio berkata, ‘Hai orang Yahudi, jikalau perkara ini tentang kesalahan atau jenayah, patutlah aku bersabar mendengarnya; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","tetapi jikalau pertikaianmu tentang perkataan, nama dan hukummu hendaklah kamu menyelesaikannya sendiri; aku tidak mahu mengadili perkara yang demikian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Lalu Galio mengusir mereka keluar dari tempat pengadilan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kemudian mereka menangkap Sostenes, ketua saumaah, lalu memukulnya di hadapan tempat pengadilan itu, tetapi Galio tidak menghiraukannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus tinggal dengan para pengikut Isa di Korintus beberapa hari lagi. Selepas itu dia meninggalkan mereka lalu belayar bersama Priskila dan Akwila ke Siria. Sebelum bertolak, Paulus mencukur rambutnya di Kengkrea sebagai menunaikan nazarnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Apabila mereka sampai di Efesus, Paulus meninggalkan Priskila dan Akwila di situ. Dia masuk seorang ke saumaah lalu berbincang dengan orang Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ketika mereka memintanya tinggal lebih lama lagi di sana, dia menolak permintaan itu ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","lalu bermohon diri sambil berkata, ‘Insya-Allah, aku akan kembali bertemu denganmu.’ Selepas itu dia belayar meninggalkan Efesus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Setelah sampai di Kaisarea, dia naik memberi salam kepada jemaah, lalu turun ke Antiokhia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Di sana dia tinggal beberapa lama, kemudian berangkat melawat seluruh daerah Galatia dan Frigia serta mengukuhkan iman para pengikut Isa di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Pada masa itu seorang Yahudi bernama Apolos, yang lahir di Iskandaria, pandai berpidato dan amat memahami Kitab Suci, datang ke Efesus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Dia telah diajar tentang jalan Tuhan, dan dengan bersungguh-sungguh dia berkata-kata dan mengajarkan ajaran Isa dengan betul, walaupun dia hanya mengetahui pengimadan Yahya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Dia mula bercakap dengan berani di saumaah. Priskila dan Akwila mendengar dia bercakap lalu membawanya ke tempat tinggal mereka dan menerangkan jalan Allah kepadanya dengan lebih betul lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apabila dia hendak menyeberang ke Akhaya, para pengikut Isa di Efesus membantunya dengan menulis surat kepada saudara-saudara seiman di Akhaya, supaya mereka menyambut Apolos. Setibanya di Akhaya, dia banyak menolong orang yang dengan kasih kurnia Allah telah beriman. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Dengan wibawa yang penuh Apolos mengalahkan orang Yahudi dalam perbahasan di hadapan orang ramai. Dengan memetik ayat-ayat Kitab Suci, dia membuktikan bahawa Isa itu al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sementara Apolos berada di Korintus, Paulus menjelajahi kawasan pedalaman lalu sampai di Efesus. Di situ dia bertemu dengan beberapa orang pengikut Isa ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","lalu berkata, ‘Adakah kamu menerima Roh Suci pada waktu kamu percaya kepada Isa?’ Mereka menjawab, ‘Kami belum pernah mendengar pun tentang adanya Roh Suci.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulus bertanya, ‘Kalau begitu, dalam pengimadan apakah kamu diimadkan?’ Kata mereka, ‘Dalam pengimadan Yahya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulus berkata, ‘Yahya telah mengimadkan orang dengan pengimadan taubat dan berkata kepada mereka bahawa mereka hendaklah mempercayai Dia yang akan datang selepasnya, iaitu Isa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Setelah mereka mendengar penerangan itu, mereka diimadkan dengan nama Junjungan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulus meletakkan tangan di atas mereka lalu datanglah Roh Suci menguasai mereka dan mereka semuanya bercakap dalam berbagai-bagai bahasa serta bernubuat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Semuanya ada kira-kira dua belas orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulus masuk ke saumaah dan bercakap di situ dengan beraninya selama tiga bulan. Dia berbincang dengan orang di situ dan berusaha meyakinkan mereka tentang kerajaan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Akan tetapi beberapa orang berkeras hati dan tidak mahu percaya malah memburuk-burukkan Jalan Tuhan di hadapan orang ramai. Oleh itu Paulus meninggalkan mereka lalu membawa pengikut-pengikut Isa bersamanya ke dewan syarahan Tiranus dan di situlah dia mengadakan perbincangan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Hal itu berlaku selama dua tahun, hingga semua penduduk Asia, baik orang Yahudi mahupun orang Yunani, telah mendengar firman Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Allah melakukan mukjizat yang luar biasa melalui Paulus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Sesetengah mereka membawa pulang sapu tangan atau kain yang pernah dipakai Paulus kepada orang yang sakit lalu mereka sembuh dan roh-roh iblis yang merasuk mereka keluar dari tubuh mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Beberapa orang Yahudi yang mengamalkan ilmu sihir turut serta menyebut nama Junjungan Isa untuk mengubat orang yang dirasuk roh-roh iblis, dengan berkata, ‘Aku menyumpahi kamu demi Isa yang dikhabarkan oleh Paulus.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ada tujuh orang anak Skewa, imam besar orang Yahudi, yang berbuat demikian. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Akan tetapi roh durjana itu menjawab, ‘Aku kenal akan Isa, dan tahu akan Paulus, tetapi kamu ini siapa?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Lalu orang yang dirasuk roh durjana itu menerkam dan mengerjakan mereka. Mereka pun lari dari dalam rumah itu dalam keadaan telanjang dan luka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Berita itu tersebar di kalangan orang Yahudi mahupun Yunani di Efesus; mereka ketakutan lalu nama Junjungan Isa semakin dimuliakan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ramai orang yang mempercayai Isa datang sambil mengakui segala perbuatan jahat mereka yang lalu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Beberapa orang yang mengamalkan ilmu sihir mengumpulkan semua buku sihirnya dan membakarnya di hadapan orang ramai. Semua buku sihir itu dianggar nilainya kira-kira lima puluh ribu keping wang perak. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Demikianlah, firman Tuhan tersebar luas dan semakin berkuasa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Setelah selesai peristiwa itu, Paulus berniat dalam hatinya hendak menjelajahi Makedonia dan Akhaya dan kemudian ke Baitulmaqdis. Dia berkata, ‘Selepas itu, aku mesti pergi ke Rom pula.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Dia pun menyuruh Timotius dan Erastus, dua orang daripada pembantu-pembantunya, pergi dahulu ke Makedonia, manakala dia tinggal lebih lama di Asia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Pada masa itu berlaku huru-hara di Efesus kerana ajaran tentang Jalan Tuhan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Seorang tukang perak bernama Demetrius membuat balai-balai berhala Dewi Artemis daripada perak. Pekerjaan ini membawa hasil lumayan kepada pekerja-pekerjanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dia menghimpunkan para pekerja serta tukang-tukang yang sama mata pencariannya lalu berkata, ‘Saudara-saudara sekalian tahu bahawa daripada pekerjaan inilah kita mendapat keuntungan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Saudara-saudara juga melihat dan mendengar bahawa di Efesus ini malah hampir di seluruh Asia, Paulus itu telah mempengaruhi ramai orang dengan berkata bahawa barang yang diperbuat oleh manusia bukannya dewa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Dengan demikian, apa yang dikhuatiri bukan saja mata pencarian kita ini dihina, bahkan rumah Artemis, dewi yang besar itu pun tidak akan diindahkan lagi, lalu hilanglah kebesaran dewi yang disembah orang di seluruh Asia malah di serata dunia.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Setelah mendengar kata-kata itu, semua yang hadir naik berang dan berseru, ‘Maha besar Artemis, dewi orang Efesus!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Dengan demikian orang ramai merusuh di kota itu. Mereka menangkap Gayus dan Aristarkhus, orang Makedonia yang menemani Paulus dalam perjalanannya, lalu menyeret mereka ke stadium kota itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulus hendak pergi bercakap kepada orang ramai tetapi para pengikut Isa tidak membenarkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Beberapa orang pegawai kerajaan yang bersahabat dengan Paulus berpesan kepadanya supaya jangan masuk ke stadium itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Orang yang berkumpul di situ berseru-seru, sesetengah berkata begini dan sesetengah begitu; kerana semuanya dalam keadaan kelam-kabut dan sebilangan besar daripada mereka tidak tahu mengapa mereka berhimpun. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Orang Yahudi menolak Iskandar ke hadapan untuk menghadapi orang ramai. Iskandar memberikan isyarat dengan tangannya kerana dia hendak menjelaskan segalanya kepada mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Akan tetapi apabila mereka mengenalinya sebagai orang Yahudi, semuanya berseru serentak selama kira-kira dua jam, ‘Maha besar Artemis, dewi orang Efesus!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ketika itu setiausaha kota menyuruh mereka diam lalu berkata, ‘Hai orang Efesus, siapa yang tidak tahu bahawa orang kota Efesuslah yang memelihara kuil dewi besar Artemis dan patung sucinya yang turun dari langit? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ini tidak dapat dinafikan. Oleh itu kamu patut bertenang dan jangan bertindak gopoh-gapah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kedua-dua orang ini tidak merampas harta tempat berhala dan tidak pula menghina dewi kita, tetapi kamu membawa mereka ke mari. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Jika Demetrius dan tukang-tukang yang menyertainya itu ada sesuatu yang hendak diadukan tentang sesiapa, kita mempunyai mahkamah perbicaraan dan hakim; hendaklah mereka mendakwa orang berkenaan di mahkamah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Jika kamu menuntut perkara lain, hendaklah diselesaikan dalam majlis yang berpatutan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Oleh sebab apa yang berlaku hari ini, kita akan didakwa menimbulkan huru-hara tanpa sebab; dan kita tidak dapat memberikan alasan yang wajar untuk membenarkan perhimpunan ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Selepas itu, setiausaha kota menyuruh perhimpunan itu bersurai. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Setelah kota itu aman semula, Paulus memanggil para pengikut Isa dan menasihatkan mereka, kemudian memohon diri lalu bertolak ke Makedonia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Dia menjelajahi seluruh Makedonia sambil memberi nasihat kepada orang di situ. Kemudian dia tiba di Yunani dan ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","tinggal di sana selama tiga bulan. Apabila dia hendak belayar ke Siria, dia mendengar bahawa orang Yahudi berpakat hendak membunuhnya. Oleh itu dia membuat keputusan hendak berangkat melalui Makedonia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Dia diiringi hingga ke Asia oleh Sopater anak Purrus orang Beria, oleh Aristarkhus dan Sekundus orang Tesalonika, oleh Gayus orang Derbe, Timotius, dan dua orang dari Asia, Tikhikus dan Trofimus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mereka berjalan dahulu, menantikan kami di Troas. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kami belayar dari Filipi selepas Perayaan Roti Tidak Beragi, lalu menemui mereka di Troas lima hari kemudian. Kami tinggal di situ selama tujuh hari. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Pada hari pertama minggu itu, kami berkumpul untuk memecah-mecahkan roti. Paulus yang akan belayar esoknya bercakap dengan orang di situ sampai tengah malam. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Di dalam bilik atas, tempat kami berhimpun itu, ada beberapa pelita. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Seorang pemuda bernama Eutikhus duduk di jendela. Dia tertidur sementara Paulus masih bercakap. Oleh sebab lena tidurnya, pemuda itu jatuh dari tingkat ketiga itu sampai ke bawah. Orang mengangkatnya dan mendapatinya sudah mati. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulus turun lalu merebahkan diri ke atas pemuda itu serta memeluknya sambil berkata, ‘Jangan bimbang, kerana ada lagi nyawanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Selepas itu dia naik, membahagikan roti, makan lalu bertutur sampai dinihari. Kemudian dia pun berangkat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Pemuda itu didapati hidup dan dibawa pulang ke rumahnya. Mereka semua amat terhibur. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kami berjalan dulu naik ke kapal lalu belayar ke Asos untuk menyambut Paulus di sana; demikianlah yang telah dirancangnya, kerana dia sendiri hendak berjalan kaki. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Setelah menyambutnya di Asos, kami mengiringinya ke Metilene. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kami belayar dari sana: Esoknya kami bertentangan dengan pulau Khios; lusanya kami singgah di Samos; dan tulatnya kami sampai di Miletus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulus telah membuat keputusan untuk belayar melalui Efesus, supaya jangan berlarutan di Asia; dia hendak cepat, dengan harapan sampai di Baitulmaqdis pada Perayaan Pentakosta. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Dari Miletus Paulus menyuruh orang pergi ke Efesus memanggil tua-tua jemaah di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Apabila mereka datang menemuinya, Paulus berkata, ‘Kamu semua tahu cara hidupku sejak aku bersamamu, dari hari pertama aku datang ke Asia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Aku telah memperhambakan diri kepada Tuhan dengan sehabis-habis rendah hati dan dengan air mata. Sudah beberapa cubaan menimpa diriku akibat pakatan orang Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Aku tidak pernah menyembunyikan daripadamu sesuatu yang berfaedah kepadamu. Aku menyatakan segalanya kepadamu dan mengajarmu di khalayak ramai mahupun di rumah masing-masing, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","sambil memberikan kesaksian kepada orang Yahudi dan orang Yunani tentang pertaubatan kepada Allah dan iman akan Junjungan Isa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","‘Sekarang aku pergi ke Baitulmaqdis mentaati perintah Roh Suci sedangkan aku tidak tahu apa yang akan berlaku kepadaku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Yang kuketahui hanyalah ini: Dari kota ke kota Roh Suci telah memberikan kesaksian kepadaku dan berkata bahawa penjara dan penderitaan ada lagi menantikan aku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tetapi sekali-kali aku tidak mengindahkan soal nyawaku, asalkan aku dapat menyempurnakan tanggungjawab dan tugas yang kuterima daripada Junjungan Isa iaitu memberikan kesaksian akan berita baik tentang kasih kurnia Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","‘Sekarang ingatlah. Aku tahu bahawa kamu tidak akan memandang mukaku lagi, setelah sekian lama aku bersamamu dan mengajarmu tentang kerajaan Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Oleh itu pada hari ini aku bersaksi bahawa aku tidak bersalah terhadap penumpahan darah manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Aku telah menyatakan kepadamu seluruh kehendak Allah dengan sepenuh kerelaan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Jagalah dirimu dan semua orang yang telah diamanahkan oleh Roh Suci kepada kamu untuk memeliharanya seperti gembala memelihara domba, iaitu jemaah Tuhan yang telah ditebus-Nya dengan darah-Nya sendiri. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Aku tahu bahawa sepeninggalanku nanti, beberapa serigala garang akan masuk menyerang jemaah ini; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","malah dari antara kamu sendiri akan bangkit beberapa orang yang memesongkan ajaran yang benar dan berusaha menarik ahli-ahli jemaah mengikut mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Oleh itu berjaga-jagalah, serta ingatlah bagaimana selama tiga tahun aku tidak berhenti-henti siang malam menasihatkan setiap orang dengan air mataku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","‘Sekarang aku menyerahkan kamu kepada Allah dan kepada perkhabaran tentang kasih kurnia Allah, yang berkuasa meneguhkan imanmu dan memberimu warisan yang diperuntukkan bagi seluruh umat Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Aku tidak pernah ingin memiliki emas perak atau pakaian orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kamu tahu bahawa kedua belah tanganku ini telah bekerja untuk mencukupkan sara hidupku dan orang yang bersamaku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Dalam semua perkara aku telah menunjukkan teladan kepadamu iaitu bagaimana kamu juga patut bekerja demikian untuk menolong orang yang lemah; dan ingatlah firman Junjungan Isa, “Memberi itu lebih berkatnya daripada menerima.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Setelah berkata demikian, Paulus berlutut dan berdoa-doa bersama semua yang hadir. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Semuanya menangis seraya memeluk dan mencium Paulus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Mereka berdukacita terutamanya kerana dia berkata bahawa mereka tidak akan memandang mukanya lagi. Kemudian mereka menghantarkannya ke kapal. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Setelah berpisah dengan mereka, kami belayar ke Kos, dan esoknya ke Rodos, dan dari sana ke Patara. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kami mendapati ada sebuah kapal yang hendak menyeberang ke Fenesia. Kami menaikinya lalu belayar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Setelah kelihatan Kiprus di sebelah kiri, kami terus belayar ke Siria lalu turun di kota Tirus kerana kapal itu hendak memunggah muatannya di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kami menemui para pengikut Isa lalu tinggal di kota itu selama tujuh hari. Melalui pimpinan Roh Suci mereka menggesa Paulus supaya jangan pergi ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Setelah sampai waktu yang dirancang, kami bertolak dari situ. Semua pengikut Isa bersama anak isteri menghantarkan kami sampai ke luar kota. Kami semua berlutut di pantai lalu berdoa dan bersalam-salaman. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Selepas itu kami naik ke kapal dan mereka pulang ke rumah masing-masing. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Dari Tirus kami meneruskan pelayaran ke Ptolemais. Di situ kami memberi salam kepada saudara-saudara seiman lalu tinggal dengan mereka selama sehari. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Esoknya kami pergi ke Kaisarea lalu masuk ke rumah Filipus, pemberita Injil yang menjadi salah seorang daripada tujuh pembantu para rasul, lalu kami tinggal dengannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Dia mempunyai empat orang anak gadis yang belum berkahwin dan mereka bernubuat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Setelah kami tinggal di situ beberapa hari, seorang nabi bernama Agabus datang dari Yudea. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Dia mendapatkan kami lalu mengambil tali pinggang Paulus dan mengikat kaki tangannya sendiri sambil berkata, ‘Demikianlah kata Roh Suci, bahawa orang yang mempunyai tali pinggang ini akan diikat demikian di Baitulmaqdis oleh orang Yahudi dan diserahkan ke tangan orang bangsa asing.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Apabila mendengar kata-kata itu, kami dan penduduk kota itu meminta Paulus supaya jangan pergi ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Paulus menjawab, ‘Mengapa kamu menangis dan menyedihkan hatiku? Aku bersedia bukan sahaja untuk diikat, malah untuk mati di Baitulmaqdis demi Junjungan Isa.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Oleh sebab dia tidak mahu mendengar kata kami, kami pun berhenti memujuknya lalu berkata, ‘Berlakulah kehendak Tuhan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Selepas itu kami berkemas lalu pergi ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Beberapa orang pengikut Isa dari Kaisarea menyertai kami lalu membawa kami berjumpa Menason, orang Siprus, yang sudah lama percaya akan Isa; di rumahnyalah kami menumpang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Setelah sampai di Baitulmaqdis, kami disambut oleh saudara-saudara seiman dengan sukacita. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Pada esoknya Paulus bersama kami masuk berjumpa dengan Yakobus; ketua-ketua yang lain pun ada di situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Setelah memberi salam kepada mereka, Paulus menceritakan segala yang telah dilakukannya secara terperinci di kalangan bangsa asing dengan kehendak Allah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Apabila mendengar kisah itu mereka memuji Allah dan berkata kepada Paulus, ‘Saudara, sebagaimana kamu lihat, ada berpuluh ribu orang Yahudi yang sudah percaya akan Isa dan mereka itu berpegang teguh kepada Taurat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ada orang memberitahu mereka bahawa kamu mengajar orang Yahudi yang tinggal di kalangan orang bangsa asing supaya berpaling daripada Musa, jangan menyunatkan anak-anak dan jangan menurut adat orang Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Sekarang bagaimana? Mereka tentu mendengar berita kedatanganmu ke sini. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Oleh itu, ikutlah seperti kata kami. Di antara kami ada empat orang yang telah bernazar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bawalah mereka bersamamu dan sucikan dirimu bersama mereka serta tanggung belanja mencukur kepala mereka. Dengan demikian semua orang akan tahu bahawa apa yang dikatakan tentangmu itu tidak benar, sebaliknya kamu mengikut Taurat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Namun, tentang orang bangsa asing yang percaya akan Isa, kami telah berkirim surat memberikan hukum bahawa mereka hendaklah memeliharakan diri daripada makanan yang dipersembahkan kepada berhala, daripada darah dan binatang yang mati dicekik, dan daripada zina.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Paulus pun membawa empat orang itu bersamanya dan pada esoknya dia menyucikan diri bersama mereka. Kemudian dia masuk ke rumah ibadat dan memberitahu orang di situ bilangan harinya upacara penyucian itu akan selesai dan korban akan dipersembahkan bagi setiap mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Apabila hampir genap tujuh hari, beberapa orang Yahudi dari Asia terpandang Paulus di dalam rumah ibadat. Mereka menghasut orang ramai lalu menangkap Paulus ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","sambil berseru, ‘Hai orang Israel, marilah tolong kami! Inilah dia orang yang menyebarkan merata-rata ajaran yang menghina kaum kita, Taurat dan rumah ibadat. Dia juga telah membawa orang Yunani ke dalam rumah ibadat, menajiskan tempat suci ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mereka berkata begitu kerana pernah melihat Trofimus orang Efesus bersama Paulus di kota itu lalu mereka menyangka bahawa Paulus telah membawanya ke dalam rumah ibadat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ini menggemparkan semua orang Yahudi di kota itu lalu mereka berlari dan berhimpun mengerumuni Paulus. Mereka menangkapnya dan menyeretnya ke luar rumah ibadat. Semua pintu rumah ibadat pun segera ditutup. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ketika mereka hendak membunuhnya, ketua pasukan tentera Rom mendengar bahawa seisi kota Baitulmaqdis sedang merusuh. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Dia segera membawa beberapa orang ketua tentera dan askar-askar untuk mendapatkan perusuh-perusuh itu. Apabila melihat mereka datang, perusuh-perusuh itu berhenti memukul Paulus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ketua pasukan tentera itu datang menangkap Paulus, disuruhnya ikat dengan dua rantai. Dia bertanya siapakah itu dan apakah yang telah dilakukannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Di antara orang ramai itu sesetengah menjawab begini dan sesetengahnya begitu. Oleh sebab ketua pasukan tentera itu tidak dapat memastikan punca huru-hara itu, dia menyuruh orangnya membawa Paulus ke dalam kubu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Setelah sampai ke tangga, askar-askar mengangkat Paulus kerana orang ramai mengganas. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Mereka mengikut sambil berseru-seru, ‘Hapuskan dia!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ketika Paulus hendak dibawa masuk ke dalam kubu, dia berkata kepada ketua pasukan tentera itu, ‘Bolehkah aku menyatakan sesuatu kepadamu?’ Ketua pasukan tentera itu berkata, ‘Kamu tahu bahasa Yunani? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Bukankah kamu ini orang Mesir yang dulu mencetuskan pemberontakan dan memimpin empat ribu orang pengganas ke gurun?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulus berkata, ‘Aku ini orang Yahudi dari kota Tarsus di tanah Kilikia iaitu kota yang agak terkenal, dan aku meminta kamu benarkan aku bercakap kepada orang ramai itu.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Setelah mendapat kebenaran daripada ketua pasukan tentera, Paulus berdiri di atas tangga dan memberikan isyarat dengan tangannya supaya mereka diam. Setelah orang ramai itu senyap, Paulus berucap dalam bahasa Ibrani, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","‘Bapa-bapa dan saudara-saudara sekalian. Dengarlah peneranganku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Setelah mereka mendengar Paulus bertutur dalam bahasa Ibrani, mereka terus senyap. Paulus berkata, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","‘Aku ini orang Yahudi, dilahirkan di Tarsus di tanah Kilikia, tetapi dibesarkan di kota ini, berguru kepada Gamaliel. Aku diajar hukum nenek moyang kita dengan betul, dan aku pula tekun beribadat kepada Allah, sama seperti saudara-saudara sekalian pada hari ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Aku pernah menganiaya pengikut Jalan Tuhan malah membunuh mereka di samping mengikat dan memenjarakan mereka, baik lelaki mahupun perempuan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Imam besar dan seluruh anggota Majlis Agama boleh bersaksi akan perbuatanku itu. Aku telah mendapatkan beberapa surat daripada mereka lalu pergi ke Damsyik untuk menangkap dan mengikat para pengikut Isa di sana dan membawa mereka ke Baitulmaqdis ini untuk diseksa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","‘Dalam perjalanan, ketika hampir sampai di Damsyik, sekitar tengah hari, tiba-tiba suatu cahaya yang besar bersinar dari langit mengelilingiku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Aku rebah ke tanah lalu mendengar suara berkata kepadaku, “Saul, Saul, mengapa engkau aniayakan Aku?” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‘Aku berkata, “Siapakah Engkau, Tuan?” ‘Jawab-Nya, “Akulah Isa orang Nasaret yang kauaniayakan.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Semua orang yang bersamaku turut melihat cahaya itu tetapi tidak mendengar suara yang berkata-kata denganku itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","‘Aku berkata, “Tuan, apakah yang harus kulakukan?” ‘Dia menjawab, “Bangunlah, pergi ke Damsyik. Di sana engkau akan diberitahu segala yang sudah ditetapkan untukmu melakukannya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Aku tidak dapat melihat langsung akibat cahaya yang terang itu. Teman seperjalananku memimpin tanganku masuk ke Damsyik. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","‘Ada seorang bernama Ananias yang kuat beribadat menurut hukum Taurat. Dia dipandang tinggi oleh orang Yahudi di Damsyik. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Dia datang berdiri di sisiku lalu berkata, “Saudaraku Saul, kamu dapat melihat semula!” Pada saat itu juga aku dapat melihat semula lalu memandangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","‘Dia berkata, “Allah, Tuhan nenek moyang kita, telah menetapkan bahawa kamu akan mengetahui kehendak-Nya, dan melihat Isa serta mendengar suara-Nya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kamu akan menjadi saksi tentang-Nya kepada semua manusia, termasuk segala yang telah kamu lihat dan dengar itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Sekarang mengapa kamu berlengah-lengah lagi? Bangunlah untuk diimadkan dan minta dihapuskan segala dosamu sambil menyeru nama-Nya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","‘Setelah aku pulang ke Baitulmaqdis, sedang aku berdoa di rumah ibadat, aku terlalai ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","lalu melihat Dia dan mendengar kata-kata-Nya kepadaku, “Segeralah keluar dari Baitulmaqdis, kerana mereka tidak akan menerima kesaksian daripadamu tentang-Ku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","‘Aku berkata, “Ya Junjungan, mereka tahu bahawa aku pernah memenjarakan dan memukul orang yang mempercayai-Mu dalam semua saumaah; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","dan apabila darah Stefanus saksi-Mu itu ditumpahkan, aku turut berdiri berdekatan dan menyetujui pembunuhan itu, serta menjaga pakaian orang yang membunuhnya.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","‘Kata-Nya kepadaku, “Keluarlah dari sini, kerana Aku hendak mengutusmu jauh-jauh kepada orang bangsa asing.”’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Orang ramai mendengar ucapan Paulus setakat itu, kemudian berseru lantang, ‘Hapuskan orang begini dari muka bumi, tidak patut dia dibiarkan hidup!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Mereka berteriak-teriak sambil mengebas-ngebas pakaian sehingga debu berterbangan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ketua pasukan tentera itu menyuruh orangnya membawa Paulus ke dalam kubu. Dia mengarahkan mereka menyebat dan menyoalnya untuk mengetahui mengapa orang ramai berseru-seru demikian tentangnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Paulus diikat dengan tali kulit lalu dia berkata kepada ketua tentera yang berdiri di situ, ‘Jikalau seorang warganegara Rom belum diadili dan didapati bersalah, berkuasakah kamu menyebatnya?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Apabila ketua tentera itu mendengar kata-kata Paulus, dia pergi memberitahu ketuanya tentang perkara itu. Katanya, ‘Apa kamu hendak buat? Orang ini warganegara Rom.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ketua pasukan tentera itu mendapatkan Paulus lalu berkata, ‘Katakanlah kepadaku, adakah engkau ini warganegara Rom?’ Paulus menjawab, ‘Ya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ketua pasukan tentera itu berkata, ‘Aku dapat menjadi warganegara dengan bayaran yang tinggi.’ Paulus menjawab, ‘Tetapi aku dilahirkan sebagai warganegara Rom.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Semua orang yang hendak menyoalnya itu berundur, dan ketua pasukan tentera itu ketakutan kerana telah mengikat warganegara Rom. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Esoknya, untuk mengetahui dengan pasti apa sebabnya Paulus dituduh oleh orang Yahudi, ketua tentera itu meminta imam besar dan semua ahli Majlis Agama berhimpun. Kemudian dia melepaskan Paulus daripada ikatan dan menghadapkannya kepada perhimpunan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulus merenung perhimpunan itu lalu berkata, ‘Saudara-saudara, dengan setulus hati aku telah melakukan segalanya di sisi Allah sampai hari ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananias, imam besar, menyuruh orang yang berdiri di sisi Paulus menampar mulutnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulus berkata kepadanya, ‘Allah akan menampar mulutmu nanti. Kamu seperti tembok yang dicat putih! Kamu sekarang duduk untuk mengadiliku menurut hukum tetapi kamu sendiri melanggar hukum itu dengan menyuruh orang menamparku!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Orang yang berdiri di sisi Paulus berkata, ‘Beranikah kamu mencela imam besar Tuhan?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulus menjawab, ‘Saudara-saudara, aku tidak tahu dia itu imam besar. Memang tersurat di dalam Kitab Suci, “Jangan hinakan pemimpin bangsamu.”’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulus mengetahui bahawa dalam perhimpunan itu separuhnya orang Saduki dan separuhnya orang Farisi. Dia pun berkata, ‘Saudara-saudara, aku ini orang Farisi dan anak orang Farisi. Aku didakwa kerana percaya akan kebangkitan daripada kematian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Dengan demikian orang Farisi dan orang Saduki mula berbahas. Seluruh perhimpunan berpecah kepada dua pihak. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Orang Saduki mengatakan bahawa tiada kebangkitan daripada kematian, tiada malaikat dan tiada roh; tetapi orang Farisi percaya akan semuanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Pertengkaran besar tercetus. Beberapa orang guru Taurat dari pihak orang Farisi bangkit dan menegaskan dengan penuh kesungguhan, ‘Kami dapati orang ini tidak bersalah langsung. Mungkin sekali roh atau malaikat telah bercakap dengannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Perkelahian menjadi begitu sengit sehingga ketua pasukan tentera itu takut kalau-kalau Paulus diserang. Dia menyuruh askar-askar segera mengambil Paulus dengan paksaan dari tengah-tengah orang itu dan membawanya ke dalam kubu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Pada malam berikut itu Tuhan berdiri di sisinya dan berkata, ‘Tetapkanlah hatimu; kerana sebagaimana kamu telah bersaksi tentang-Ku dengan sungguh-sungguh di Baitulmaqdis ini, begitulah kamu akan bersaksi di Rom pula.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Setelah hari siang, orang Yahudi membuat pakatan. Mereka bersumpah tidak akan makan dan minum hingga mereka membunuh Paulus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Lebih empat puluh orang sepakat mengangkat sumpah itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Mereka semua menghadap ketua-ketua imam dan para pemimpin masyarakat mereka lalu berkata, ‘Kami telah bersumpah tidak akan makan dan minum hingga kami membunuh Paulus itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kamu dan ahli-ahli Majlis Agama tolonglah minta ketua pasukan tentera itu hadapkan Paulus kepada kamu esok, seolah-olah kerana kamu hendak meneliti perkara itu dengan lebih halus lagi. Kami akan bersedia untuk membunuhnya sebelum dia sampai ke sini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Anak saudara Paulus mendengar tentang pakatan itu lalu masuk ke kubu memberitahunya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulus memanggil dan berkata kepada seorang ketua tentera, ‘Bawalah pemuda ini kepada ketua pasukan tentera kerana ada suatu perkara yang hendak dikatakan kepadanya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Pegawai itu membawa pemuda itu berjumpa ketuanya lalu berkata, ‘Paulus, orang yang terpenjara itu, memanggilku dan meminta pemuda ini dibawa berjumpa tuan kerana ada suatu perkara yang hendak dikatakannya kepada tuan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ketua pasukan tentera memegang tangan pemuda itu dan membawanya ke tempat yang sunyi lalu bertanya, ‘Apa hal yang hendak kaukatakan kepadaku itu?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Pemuda itu berkata, ‘Orang Yahudi telah berpakat hendak meminta tuan membawa Paulus menghadap Majlis Agama esok, seolah-olah hendak meneliti halnya lebih halus lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Janganlah tuan terpedaya oleh kata-kata mereka, kerana lebih empat puluh orang daripada mereka telah bersumpah tidak akan makan dan minum hingga mereka membunuh Paulus. Mereka akan membunuhnya sebelum dia sampai ke hadapan Majlis Agama itu. Sekarang pun mereka semua sudah sedia menantikan tuan berjanji demikian.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ketua pasukan tentera itu menyuruh pemuda itu pulang setelah berpesan, ‘Jangan beritahu sesiapapun bahawa kamu telah menyatakan hal ini kepadaku.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kemudian dia memanggil dua orang ketua tentera lalu berkata, ‘Lengkapkan dua ratus orang askar untuk pergi ke Kaisarea; askar bertombak dua ratus orang dan askar berkuda tujuh puluh. Mereka mesti bertolak pada pukul sembilan malam ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ketua tentera itu juga menyuruh melengkapkan kenderaan dan menaikkan Paulus ke atasnya untuk dibawa kepada Feliks, pemerintah negeri, dengan selamat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ketua tentera itu menulis surat seperti berikut: ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","‘Salam daripadaku, Klaudius Lisias, kepada Feliks, pemerintah yang amat mulia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","‘Orang ini telah ditangkap oleh orang Yahudi. Mereka hendak membunuhnya, lalu aku datang dengan askar-askar dan menyelamatkannya. Aku mendapat tahu dia warganegara Rom. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Aku ingin mengetahui apa sebabnya dia dituduh oleh bangsanya. Oleh itu aku membawanya untuk menghadap Majlis Agama mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Aku mendapati dia tertuduh atas beberapa pertikaian tentang hukum agama; tetapi tiada suatu tuduhan pun yang patut dihukum bunuh atau penjara. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Apabila aku diberitahu tentang suatu pakatan hendak membunuh orang ini, aku segera menghantarkannya kepada tuan. Aku berpesan kepada mereka yang menuduhnya supaya mendakwanya di hadapan tuan.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Askar-askar mengambil Paulus sebagaimana diarahkan lalu membawanya pada waktu malam ke Antipatris. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Esoknya askar berkuda sahaja meneruskan perjalanan bersama Paulus manakala askar yang lain pulang ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Setelah sampai ke Kaisarea, surat itu dipersembahkan kepada pemerintah dan Paulus pun dihadapkan kepadanya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Selepas membaca surat itu, pemerintah itu bertanya kepada Paulus di mana negeri asalnya. Apabila dia mendengar bahawa Paulus orang Kilikia, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","dia berkata, ‘Aku akan mengadili perkara ini setelah pendakwa-pendakwa kamu sampai.’ Kemudian dia mengarahkan supaya Paulus ditahan di dalam istana yang dulu dibina oleh Herodes. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Selepas lima hari, Ananias imam besar datang ke Kaisarea dengan beberapa orang pemimpin masyarakat Yahudi dan seorang peguam bernama Tertulus. Mereka menuduh Paulus di hadapan pemerintah itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Setelah Paulus dipanggil hadir, Tertulus memulakan dakwaannya: ‘Feliks yang mulia, dengan limpah kurnia dan kebijaksanaanmu, kami hidup sejahtera dan menikmati perubahan yang baik di negeri ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kami amat berterima kasih atas segala yang telah kamu lakukan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kerana tidak ingin mengambil terlalu banyak masamu, aku memohon kamu mendengar dakwaanku yang ringkas ini. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","‘Kami telah mendapati orang ini pengacau dan menimbulkan huru-hara di kalangan orang Yahudi di serata dunia. Dialah pemimpin mazhab ajaran orang Nasaret itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Malah dia cuba menajiskan rumah ibadat tetapi kami menangkapnya dan hendak mengadilinya menurut hukum kami. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Akan tetapi ketua pasukan tentera Lisias datang lalu merampasnya daripada kami. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Dia mengarahkan kami, pendakwa-pendakwa orang ini, supaya menghadapmu. Jika kamu menyoal orang ini, kamu akan mendapati bahawa segala tuduhan kami ini benar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Orang Yahudi turut serta menuduh Paulus, dan mengatakan bahawa segala yang dikatakan itu benar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Setelah menerima isyarat daripada pemerintah itu menyuruhnya bercakap, Paulus menjawab dakwaan itu demikian: ‘Aku tahu kamu telah lama menjadi hakim di negeri ini. Oleh itu aku dengan senang hati mengadukan hal kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Hanya dua belas hari yang lalu aku telah pergi ke Baitulmaqdis untuk beribadat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Aku tidak didapati berbincang dengan sesiapa atau menghimpunkan orang ramai itu untuk menimbulkan huru-hara, baik di rumah ibadat, saumaah, atau di mana-mana di kota itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Para pendakwa juga tidak dapat membuktikan kepadamu segala tuduhan mereka terhadapku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Aku mengaku di hadapanmu bahawa aku menyembah Allah, Tuhan nenek moyangku, menurut Jalan Tuhan yang dianggap salah oleh mereka. Aku juga percaya dan berpegang kepada hukum Taurat, dan segala yang tersurat di dalam kitab nabi-nabi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Seperti mereka juga, aku berharap kepada Allah bahawa semua orang akan dibangkitkan daripada kematian kelak, sama ada orang benar ataupun orang jahat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Oleh itu aku sentiasa berusaha supaya hatiku bersih daripada kesalahan kepada Allah dan kepada manusia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","‘Selepas beberapa tahun di tempat-tempat lain, aku ke Baitulmaqdis membawa derma untuk bangsaku, dan mempersembahkan korban. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mereka mendapati aku di dalam rumah ibadat setelah aku menyucikan diri; aku tidak membawa kumpulan yang besar dan tidak mencetuskan huru-hara. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ketika itu ada beberapa orang Yahudi dari Asia. Merekalah yang patut menghadap kamu di sini untuk mendakwa, kalaulah ada sesuatu yang patut didakwa tentang aku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ataupun biarlah orang ini menyatakan apa kesalahan yang didapatinya pada diriku ketika aku berdiri di hadapan majlis mereka itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Pada waktu itu aku hanya melafazkan kata-kata yang sama, iaitu, “Tentang kebangkitan daripada kematianlah aku didakwa di hadapanmu pada hari ini.” ’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks menangguhkan perbicaraan walaupun dia memahami selok-belok agama berkenaan. Dia berkata, ‘Apabila Lisias, ketua pasukan tentera itu, datang nanti, aku akan menyelesaikan perkara ini.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Dia mengarahkan ketua tentera menahan Paulus tetapi secara longgar, dan membenarkan sahabat-sahabatnya membawa apa-apa untuknya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Beberapa hari kemudian, Feliks datang bersama isterinya Drusila, seorang Yahudi. Dia menyuruh orang memanggil Paulus lalu mendengar penerangannya tentang iman terhadap Isa al-Masih. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Apabila Paulus bercakap tentang kebenaran, tentang penguasaan diri, dan tentang hukuman yang akan datang pada hari kemudian, Feliks ketakutan lalu berkata, ‘Pergilah sekarang. Apabila ada kesempatan nanti, aku akan memanggilmu lagi.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Dalam pada itu dia berharap Paulus akan memberikan wang kepadanya. Oleh itu dia kerapkali menyuruh orang memanggil Paulus lalu bercakap dengannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Dua tahun kemudian, Feliks digantikan oleh Perkius Festus. Feliks membiarkan Paulus terpenjara kerana hendak mengambil hati orang Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tiga hari selepas Festus menjadi pemerintah negeri itu, dia berangkat dari Kaisarea ke Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ketua-ketua imam dan para pemimpin masyarakat Yahudi menuduh Paulus di hadapan Festus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Mereka memohon jasa baik Festus menghantar Paulus ke Baitulmaqdis kerana mereka telah berpakat hendak membunuhnya di pertengahan jalan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Akan tetapi Festus menjawab bahawa Paulus terpenjara di Kaisarea dan dia sendiri pun hendak segera ke sana. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Dia berkata, ‘Oleh itu hendaklah orang yang berkuasa di antara kamu berangkat ke sana bersamaku dan mendakwa orang itu, jika dia telah melakukannya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Setelah tinggal di Baitulmaqdis kira-kira lapan atau sepuluh hari lagi, Festus pun berangkat ke Kaisarea. Pada esoknya dia duduk sebagai hakim di mahkamah lalu menyuruh orang membawa Paulus menghadapnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Setelah Paulus masuk, semua orang Yahudi yang datang dari Baitulmaqdis itu berdiri mengelilinginya serta menuduhnya atas beberapa kesalahan yang berat, yang tidak dapat dibuktikan oleh mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Kemudian Paulus membela dirinya sendiri dan berkata ‘Satu pun tiada kesalahanku, terhadap hukum orang Yahudi, atau terhadap rumah ibadat, atau terhadap Kaisar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Akan tetapi Festus hendak mengambil hati orang Yahudi lalu bertanya kepada Paulus, ‘Mahukah kamu pergi ke Baitulmaqdis supaya aku mengadili perkaramu ini di sana?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulus menjawab, ‘Aku sekarang berdiri di mahkamah Kaisar, dan di sinilah aku patut dibicarakan. Aku tidak pernah melakukan sesuatu yang buruk terhadap orang Yahudi, sebagaimana kamu terlebih maklum. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kalaulah aku bersalah, atau telah melakukan sesuatu yang patut aku dibunuh, aku tidaklah enggan mati; tetapi jika segala tuduhan mereka ke atas aku itu tidak benar, tiada seorang pun yang boleh menyerahkanku kepada mereka. Aku hendak mengadu kepada Kaisar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Setelah berbincang dengan semua penasihatnya, Festus menjawab, ‘Kamu hendak mengadu kepada Kaisar; pergilah menghadap Kaisar!’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Beberapa hari kemudian, Raja Agripa berangkat bersama Bernike ke Kaisarea untuk meraikan kedatangan Festus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Dalam beberapa hari raja itu tinggal di sana, Festus menceritakan hal Paulus kepadanya, ‘Di sini ada seorang yang ditinggalkan oleh Feliks di dalam penjara. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ketika aku di Baitulmaqdis, ketua-ketua imam dan para pemimpin masyarakat Yahudi menuduh orang itu dan meminta supaya dia dihukum. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","‘Tetapi aku menjawab bahawa menurut adat orang Rom, seseorang itu tidak boleh diserahkan sebelum berhadapan dengan pendakwanya dan diberi peluang membela diri. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Apabila mereka datang ke sini, esoknya tanpa berlengah-lengah aku duduk sebagai hakim dan mengarahkan supaya orang itu dibawa masuk ke mahkamah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Para pendakwanya mengemukakan tuduhan tetapi tiada satu pun merupakan perbuatan jahat sebagaimana aku jangkakan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Semua tuduhan itu berlegar sekitar perselisihan tentang agama, tentang seorang bernama Isa yang sudah mati dan dikatakan hidup semula oleh Paulus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Aku pun tidak tahu bagaimana hendak mengadili hal itu, lalu bertanya kalau dia mahu ke Baitulmaqdis supaya dibicarakan di sana. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Tetapi Paulus meminta tangguh, hendak mengadukan halnya supaya dibicarakan di hadapan yang maha mulia Kaisar; lalu aku menyuruh dia dipenjarakan hingga aku menghantarnya kepada Kaisar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa berkata, ‘Aku pun ingin mendengar orang itu.’ Festus menjawab, ‘Esok dapatlah kamu mendengarnya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Pada esoknya Agripa dan Bernike berangkat dengan selengkap kebesarannya, masuk ke dalam balai mahkamah bersama para panglima dan orang yang terkemuka di kota itu. Dengan perintah Festus, Paulus dibawa masuk. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus berkata, ‘Tuanku Raja Agripa dan sidang hadirin. Orang ini didakwa oleh semua orang Yahudi, baik yang di Baitulmaqdis mahupun yang di sini. Mereka berteriak-teriak bahawa dia tidak patut dibiarkan hidup lagi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Tetapi pada pandangan aku, dia tidak melakukan apa-apa kesalahan yang patut dijatuhkan hukuman mati. Oleh sebab dia sendiri hendak mengadukan halnya kepada yang maha mulia Kaisar, aku telah memutuskan akan menghantarnya kepada Kaisar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Namun, tiada suatu pun yang pasti untuk aku tuliskan tentangnya kepada Kaisar. Itulah sebabnya aku membawanya menghadapmu, dan terutamanya Raja Agripa. Setelah dia disoal nanti, bolehlah didapati sesuatu untuk aku tuliskan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Pada pandanganku, tidaklah wajar menghantarkan seseorang untuk diadili tanpa menyatakan tuduhan ke atasnya dengan jelas.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Setelah itu Agripa berkata kepada Paulus, ‘Sekarang kamu diberi izin untuk membela dirimu.’ Paulus pun memberikan isyarat dengan tangannya lalu membela dirinya demikian, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","‘Tuanku Raja Agripa, aku berasa bahagia kerana dapat menjawab tuduhan orang Yahudi ke atasku di hadapan kamu pada hari ini; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","lebih-lebih lagi kerana kamu memahami adat dan perselisihan yang berlaku di kalangan orang Yahudi. Oleh itu aku memohon kamu mendengarku dengan sabar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","‘Semua orang Yahudi telah maklum tentang diriku dari muda lagi, ketika di negeriku dan kemudiannya di Baitulmaqdis. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Dari mulanya mereka telah mengenaliku, kalaulah mereka mahu bersaksi. Mereka tahu bahawa aku menurut ajaran yang paling keras dalam agama kami kerana aku orang Farisi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Sekarang pun aku berdiri di sini dan didakwa kerana aku berharap akan janji Allah kepada nenek moyang kami. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dua belas suku bangsa kami tekun menyembah Allah siang malam dan berharap akan janji itu juga. Oleh sebab harapan inilah, aku dituduh oleh orang Yahudi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Jika benar Allah membangkitkan orang daripada kematian, mengapakah pada hematmu hal itu tidak dapat dipercayai orang? ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","‘Satu masa dulu, pada perasaan hatiku, wajar sekali aku mengambil pelbagai tindakan terhadap pengikut Isa orang Nasaret itu; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","dan aku sudahpun berbuat demikian di Baitulmaqdis. Setelah mendapatkan kuasa daripada ketua-ketua imam, aku telah memenjarakan ramai orang yang salih; dan apabila mereka dibunuh, aku menyetujui pembunuhan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Kerapkali di saumaah-saumaah aku menyeksa mereka dalam usaha memaksa mereka berpaling daripada Isa; dan oleh sebab terlalu berang terhadap mereka, aku memburu mereka hingga ke negeri asing. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","‘Pada suatu hari sedang aku dalam perjalanan ke Damsyik, dengan membawa surat kuasa daripada ketua-ketua imam, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","pada waktu tengah hari, aku melihat di tengah jalan suatu cahaya datang dari langit, lebih terang daripada sinar matahari, bersinar mengelilingiku dan semua orang yang berjalan bersamaku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Aku rebah ke bumi, lalu aku mendengar suatu suara berkata dalam bahasa Ibrani kepadaku, “Saul, Saul, mengapakah engkau menganiaya Aku? Sukarlah bagimu, seperti menendang sesuatu yang tajam.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","‘Aku bertanya, “Siapakah Engkau, Tuan?” ‘Dia menjawab, “Akulah Isa yang kauaniayakan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Tetapi bangunlah, berdirilah. Aku menampakkan diri kepadamu untuk memberitahumu bahawa engkau akan membuat kerja-Ku, dan bersaksi tentang engkau melihat-Ku ini, dan tentang apa yang akan Kutunjukkan lagi kepadamu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Aku akan menyelamatkanmu daripada orang Yahudi dan bangsa lain juga. Aku akan mengutusmu kepada mereka, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","untuk mencelikkan mata mereka dan membawa mereka daripada kegelapan kepada cahaya, daripada kuasa Iblis kepada kuasa Allah. Dengan demikian dosa mereka akan diampunkan dan mereka akan menjadi umat yang dipilih oleh Allah kerana mereka percaya akan Aku.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","‘Oleh itu, Tuanku Raja Agripa, aku dengan sepenuh rela menurut perintah dari penglihatan yang datang dari syurga itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Aku telah menyampaikan kepada semua orang Damsyik, Baitulmaqdis dan seluruh tanah Yudea, juga kepada orang bangsa asing, bahawa mereka hendaklah bertaubat dan berpaling kepada Allah serta berkelakuan selaras dengan pertaubatan itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Itulah sebabnya orang Yahudi menangkapku di dalam rumah ibadat, serta mencari jalan hendak membunuhku. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Tetapi hingga saat ini Allah telah menolongku dan aku berdiri di sini sambil bersaksi kepada orang besar dan orang biasa, dengan mengatakan perkara yang telah dinubuatkan oleh nabi-nabi dan oleh Musa: ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","iaitu al-Masih pasti mengalami kematian dan menjadi orang yang pertama bangkit daripada kematian. Dengan demikian Dia mengisytiharkan penyelamatan kepada orang Yahudi dan bangsa lain, penyelamatan yang seperti cahaya bagi semua.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Sedang Paulus menegakkan pembelaannya demikian, Festus berkata dengan suara nyaring, ‘Kamu gila, Paulus; ilmu yang terlalu banyak menjadikan kamu gila.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paulus menjawab, ‘Aku bukannya gila, Festus yang mulia. Aku mengatakan perkara yang benar dan bijaksana. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Tuanku Raja Agripa, aku berani berkata-kata di hadapanmu dengan bebas kerana aku tahu di dalam hati bahawa kamu faham akan perkara-perkara ini, memandangkan segalanya tidaklah berlaku di tempat yang tersembunyi. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Tuanku Raja Agripa, percayakah kamu akan kata nabi-nabi itu? Aku tahu bahawa kamu percaya.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa berkata kepada Paulus, ‘Dengan sepatah dua katamu, kausangka dapat menjadikanku orang Masihi?’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulus menjawab, ‘Sepatah dua atau banyak, aku berdoa kepada Allah, mudah-mudahan kamu dan sekalian yang mendengar kata-kataku hari ini akan menjadi sama sepertiku, cuma tidak diikat dengan rantai.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Raja Agripa, Festus pemerintah Kaisarea, Bernike dan semua yang bersama mereka, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","berangkat keluar dari mahkamah sambil berbincang. Seorang daripada mereka berkata, ‘Orang itu tidak melakukan apa-apa yang menyebabkan dia patut dibunuh atau dipenjara.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa berkata kepada Festus, ‘Orang ini boleh dibebaskan, kalau tidak kerana dia hendak mengadukan halnya kepada Kaisar.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Setelah diputuskan bahawa kami akan belayar ke Itali, Paulus dan beberapa orang tahanan diserahkan kepada seorang ketua tentera dari Rejimen Kaisar, bernama Yulius. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Kami menaiki sebuah kapal yang datang dari Adramitium dan hendak menyusur teluk rantau tanah Asia. Aristarkhus, orang Makedonia dari Tesalonika, menyertai kami. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Esoknya kami singgah di Sidon. Yulius berasa kasihan dan melayani Paulus dengan baik serta membenarkannya bertemu dengan sahabat-sahabatnya untuk mendapatkan apa-apa yang diperlukannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kemudian kami belayar menyusur Siprus di sebelah bawah angin, kerana ketika itu angin bertiup ke arah yang bertentangan dengan hala tujuan kami. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Setelah menyeberang laut Kilikia dan Pamfilia, kami sampai ke Mira di tanah Likia. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Di sana ketua tentera Kaisar itu mendapati sebuah kapal dari Iskandaria yang hendak belayar ke Itali, lalu dia menumpangkan kami dalam kapal itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kami belayar dengan lambat dan susah payah kerana melawan arah tiupan angin. Selepas beberapa hari, kami tiba di kota Knidus. Oleh sebab masalah angin itu, kami belayar ke selatan pulau Kreta, melalui Salmone. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Dengan susah payah juga kami menyusur pulau itu, lalu sampai ke tempat yang bernama Lindungan Indah, berdekatan Lasea. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Beberapa hari kemudian, keadaan kian berbahaya untuk meneruskan pelayaran. Hari Raya Puasa orang Yahudi pun sudah berlalu. Paulus mengingatkan ketua tentera itu, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","‘Saudara-saudara, pada pandanganku, jika kita belayar, banyak bencana dan kerugian akan menimpa, bukan sahaja kapal ini dan muatannya malah nyawa kita juga.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Tetapi ketua tentera itu lebih mempercayai kata kapten dan tuan punya kapal itu daripada kata Paulus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Pelabuhan itu memang tidak selesa untuk tinggal sepanjang musim dingin. Oleh itu kebanyakan mereka hendak meneruskan pelayaran dengan harapan akan sampai ke Feniks lalu tinggal di situ, di pelabuhan di pulau Kreta yang menghadap barat daya dan barat laut. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Apabila bertiup angin selatan sepoi-sepoi bahasa, sangka mereka telah tercapailah hasrat mereka. Mereka pun membongkar sauh lalu menyusur pulau Kreta. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Tidak berapa lama kemudian, angin ribut yang bergelar Timur Laut membadai dari arah pulau itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kapal kami dipukul ribut dan tidak terdaya belayar melawan arah angin. Kami pun membiarkannya berhanyut, ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","sampai ke selatan sebuah pulau kecil bernama Kauda. Dengan susah payah kami menyelamatkan sekoci kapal itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Setelah dinaikkan sekoci itu ke kapal, diusahakan memperkukuh kapal itu dengan ikatan tali. Oleh sebab takut terdampar ke tebing Sirtis, layar diturunkan dan kapal itu dibiarkan mengikut angin. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kami begitu teruk dipukul ribut sehingga esoknya muatan kapal mula dibuang ke laut; ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","dan lusanya sebahagian alat kapal itu pula dibuangkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Beberapa hari kami tidak melihat matahari dan bintang serta dipukul ribut yang dahsyat; akhirnya putuslah harapan kami diselamatkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Sekian lama orang di dalam kapal itu tidak makan, lalu Paulus berdiri dan berkata, ‘Saudara-saudara, sepatutnya dulu saudara-saudara menurut kataku, jangan belayar meninggalkan Kreta, nanti ditimpa bencana dan kerugian demikian. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Sekarang aku berkata kepada saudara-saudara, tetapkan hati masing-masing, kerana seorang pun tidak akan kehilangan hidup, hanya kapal ini tidak dapat diselamatkan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Malam tadi, di sisi aku terdiri malaikat daripada Allah, Tuhan yang memiliki seluruh diriku dan yang aku sembah. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Malaikat itu berkata, “Paulus, jangan takut. Kau pasti akan berdiri di hadapan Kaisar. Semua yang belayar bersamamu akan diselamatkan juga sebagai kurnia Allah kepadamu.” ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Oleh itu, saudara-saudara, tetapkanlah hati masing-masing. Aku percaya akan Allah dan janji-Nya yang disampaikan kepadaku itu. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Tetapi tidak dapat dielakkan, kita akan terdampar di sebuah pulau.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Sampai ke malam yang keempat belas kami masih berhanyut dalam Laut Adria. Kira-kira tengah malam, anak kapal merasakan kami sudah hampir ke darat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Mereka membuang batu duga untuk mengukur dalamnya laut, didapatinya dua puluh depa; kemudian, apabila diduga lagi, didapatinya lima belas depa dalamnya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Mereka takut kalau-kalau terdampar pada batu karang, lalu mereka menurunkan empat sauh dari buritan kapal serta menanti hari siang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ketika itu anak kapal hendak menyelamatkan diri sendiri. Mereka menurunkan sekoci ke laut dengan berpura-pura hendak menurunkan sauh di haluan kapal. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paulus pun berkata kepada ketua tentera dan askar-askar, ‘Jika mereka itu meninggalkan kapal, saudara-saudara tidak akan selamat.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Oleh itu askar mengerat tali sekoci dan membiarkannya hanyut. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Sementara menunggu hari siang, Paulus meminta semua orang makan. Dia berkata, ‘Sekarang sudah empat belas hari saudara-saudara berlapar. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Aku meminta kepada sekalian, makanlah sesuatu, kerana itulah yang akan membuat saudara-saudara selamat. Tiada seorang pun di antara kita yang akan binasa sehelai rambutnya pun.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Setelah berkata demikian, Paulus mengambil roti lalu mengucapkan syukur kepada Allah di hadapan semua. Kemudian dia membahagi roti itu lalu makan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Masing-masing pun berasa bersemangat lagi lalu makan bersama-sama. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Bilangan kami yang di dalam kapal itu dua ratus tujuh puluh enam orang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Setelah kenyang sekaliannya, kapal itu diringankan lagi dengan membuang gandum ke laut. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Apabila hari siang, mereka melihat daratan yang tidak dikenali; di situ ada teluk yang berpantai rata lalu mereka bercadang hendak mengandaskan kapal itu ke situ. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mereka memotong tali sauh dan membiarkannya tenggelam di laut. Selepas itu mereka melucutkan tali kemudi lalu menaikkan layar di haluan supaya angin meniup kapal itu menuju ke pantai. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kapal itu terlanggar busung pasir lalu terkandas haluannya, dan tidak dapat bergerak manakala buritannya pecah dipukul gelombang. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Askar-askar mula berura-ura hendak membunuh semua orang tahanan supaya tidak seorang pun berenang melarikan diri. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Tetapi ketua tentera itu hendak menyelamatkan Paulus lalu melarang askar-askarnya berbuat demikian. Dia menyuruh mereka yang tahu berenang terjun dahulu dan berenang ke darat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Yang lain berpegang pada papan atau pecahan-pecahan kapal. Dengan demikian semuanya selamat naik ke darat. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Setelah selesai segalanya, barulah kami mendapat tahu bahawa pulau itu bernama Malta. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Penduduk pulau itu bersikap ramah mesra kepada kami. Mereka menyalakan api dan menyambut kami sekalian masuk berlindung daripada hujan dan kesejukan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulus memungut ranting dan apabila dia meletakkannya di atas api, seekor ular keluar melarikan diri dari kepanasan lalu memagut tangan Paulus. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Apabila penduduk pulau itu melihat ular tersebut pada tangan Paulus, mereka berkata sama sendiri, ‘Tentu dia ini seorang pembunuh; sungguhpun dia selamat daripada bahaya laut, tetapi Dewi Keadilan tidak membiarkan dia hidup.’ ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Paulus mengebaskan ular itu ke dalam api tanpa mengalami sebarang kecederaan. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Semuanya menantikan kalau-kalau dia naik bengkak atau rebah mati; tetapi lama mereka menanti-nanti, tidak juga mereka melihat apa-apa bencana menimpanya. Sangkaan mereka pun berubah, mengatakan Paulus itu seorang dewa. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Di daerah itu ada tanah yang dipunyai oleh Publius, pemerintah pulau itu. Dia menyambut kami dan melayani kami selama tiga hari dengan budi bahasa yang baik. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ketika itu bapa Publius terlantar mengidap demam dan mengalami cirit-birit. Paulus masuk menghampirinya lalu berdoa sambil meletakkan tangan ke atasnya dan menyembuhkannya. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Selepas itu, beberapa orang yang mengidap penyakit di pulau itu datang berjumpa Paulus, lalu dia menyembuhkan mereka. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Mereka menunjukkan penghargaan yang tinggi kepada kami; dan apabila kami hendak belayar, mereka membawa pelbagai barang yang berguna ke dalam kapal sebagai bekalan untuk kami. ");
INSERT INTO zlmKSZI_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tiga bulan kemudian, kami belayar dalam seb