﻿USE sofia;
DROP TABLE IF EXISTS sofia.ziw_vpl;
CREATE TABLE ziw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ziw_vpl WRITE;
INSERT INTO ziw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Luno ni ludongo lwa lukolo lwa Yesu Kulisito, lukolo lwa Daudi, endaga mlukolo ywa Bulahimu. ");
INSERT INTO ziw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Bulahimu amwelekaga Isaka, Isaka amweleka Yakobo, Yakobo amweleka Yuda na walukolo wakwe. ");
INSERT INTO ziw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda amwelekaga Pelesi na Zela mami yawo ni Tamali, Pelesi amweleka Hesiloni, Hesiloni amwelekaga Alamu. ");
INSERT INTO ziw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamu amwelekaga Aminadabu, Aminadabu amweleka Nashoni, Nashoni amweleka Salimoni. ");
INSERT INTO ziw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni amwelekaga Boazi, nine nani Lahabu, Boazi amweleka Obedi mami yakwe nani Lutu, Obedi amwelekaga Yese. ");
INSERT INTO ziw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese awelekaga Seuta Daudi, Daudi amweleka Sulemani, nine nani mkaza Uliya. ");
INSERT INTO ziw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemani amwelekaga Lehoboamu, Lehoboamu amweleka Abiya, Abiya amweleka Asa. ");
INSERT INTO ziw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa amwelekaga Yehoshafati, Yehoshafati amweleka Yolamu, Yolamu amweleka Uziya. ");
INSERT INTO ziw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya amwelekaga Yosamu, Yosamu amweleka Ahazi, Ahazi amweleka Hezekiya. ");
INSERT INTO ziw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya amwelekaga Manase, Manase amweleka Amoni, Amoni amweleka Yosiya. ");
INSERT INTO ziw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya amwelekaga Yekoniya na walukolo weyawe. Chipindi chiya Wayahudi wasamizizagwa Babeli. ");
INSERT INTO ziw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Umo weze waguhigwe mateka uko Babeli, Yekoniya amwelekaga Shealitieli, Shealitieli amweleka Zelubabeli. ");
INSERT INTO ziw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli amwelekaga Abihudi, Abihudi amweleka Eliakimu, Eliakimu amweleka Azoli. ");
INSERT INTO ziw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli amwelekaga Sadoki, Sadoki amweleka Akimu, Akimu amweleka Eliudi. ");
INSERT INTO ziw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi amwelekaga Eleazali, Eleazali amweleka Matani, Matani amweleka Yakobo. ");
INSERT INTO ziw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo amwelekaga Yusufu, Yusufu nani mgosi ywa Maliyamu nine dya Yesu akwitangwa Kulisito. ");
INSERT INTO ziw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ivyo nakuna vyeleko mlongo na mine, kukongela Bulahimu kubula Daudi, na vyeleko mlongo na mine, kukongela Daudi kubula mo usami kwita Babeli, na vyeleko mlongo na mine, ni kukongela hadya waguhigwe utumwa kubula mwe chipindi cha Kulisito Mkombola. ");
INSERT INTO ziw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Vino nivyo elekagwa Yesu Kulisito, Maliyamu nine dya Yesu nakalombwa ni Yusufu. Mna umo hawenati kusolana, Maliyamu nakawoneka ana nda kwa udahi wa Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kwaviya Yusufu nakaoneka ywedi haungile kumjela soni Maliyamu mwa wantu, elo nakaunga amwase chinyele. ");
INSERT INTO ziw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Umo achei akafanyanya imbuli iyo, mndima ywa kwembingu ywa Zumbe amlaila mwe sozi amgamba, “Yusufu mwana Daudi, usekogoha kumguha Maliyamu atende mkaziwo, kwaviya kenula nda kwa udahi wa Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nefungule mwana ywa chilume, nawe naumwitange Yesu, kwaviya uyo nuyo akunga awakombole wantu wakwe mwa masa yawo.” ");
INSERT INTO ziw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ivyo yano yose nayalaila chani uchinte udya ulosi Zumbe alongaga kujinkila kwa muwoni. ");
INSERT INTO ziw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Chigoli nenule nda nakutenda na mwana chilume, naye netangwe Imanueli” nuko kugamba, “Chohile ehamwenga na suwe.” ");
INSERT INTO ziw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ivyo Yusufu eze asetuke mwe zintongo, adamanya saviya agambilwe ni mndima ywa kwembingu ywa Zumbe amguha Maliyamu mkaziwe. ");
INSERT INTO ziw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mna hagonile naye, kubula Maliyamu efungula mwana chilume, Yusufu amwinka zina dya Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu elekagwa mo mzi wa Beselehemu uko Yudeya, mwe chipindi umo Helode endaga Seuta. Vikaheza, wantu wamanyi wa ntondo weza wakalaila ntendele yo ulailo wa zuwa wa Yelusalemu, ");
INSERT INTO ziw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","niyo wauza, “Ekuhi umwana elekwe, akunga atende Seuta ywa Wayahudi? Chiwona ntondo yakwe umo ikalaila ko ulailo we dizuwa, ivyo chiza kumvikila.” ");
INSERT INTO ziw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Seuta Helode eze eve ayo, engilwa ni chinyulu, hamwenga na chila yumwenga wo mzi wa Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Awetanga wakulu wa walavyantambiko wose hamwenga na wahinyi wa Sigilizi na kuwauza, “Kulisito Mkombola nelekwe kuhi?” ");
INSERT INTO ziw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wahitula, Nelekwe mo mzi wa Beselehemu, uko Yudeya. Vino nivyo alongile, muwoni ");
INSERT INTO ziw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Beselehemu mwe isi ya Yuda, Weye hwi wa udumo mgati mo ulongozi wa Yuda, kwaviya nalawe chilongozi mwako naalongoze wantu wangu wa Izulaeli. ");
INSERT INTO ziw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Vikaheza Helode awetanga wamanyi wa ntondo wajeni walaile ko ulailo we dizuwa ko mdugano wa chinyele nakubunkula chipindi cha chindedi chilaile intondo. ");
INSERT INTO ziw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Niyo awasigila waite Beselehemu kwa sigilizi zino, “Hitani mkalonde vyedi mwana alekwe, aho namumwone, mwize mnigambile, chani nami hamvikile.” ");
INSERT INTO ziw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Weze waheze kumwiva Seuta, watoza sila waita, ntondo nayo waiwonaga ko ulailo we dizuwa yawalongoza hadya eli umwana. ");
INSERT INTO ziw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Weze waiwone intondo, niyo weleleswa. ");
INSERT INTO ziw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Wengila mwe nyumba, weze wamwone umwana hamwenga na mamiyakwe Maliyamu, wafika madi kumvikila. Walavya majeleko yawo na kumwinka, zahabu, mavuta ya yombe kulu yakwitangwa manemane na uvumba. ");
INSERT INTO ziw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Niyo wauya kwe kaya yawo kwa sila ntuhu, kwaviya Chohile awafundaga mwe sozi wasekuya kwa Helode. ");
INSERT INTO ziw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Weze wahalawe mndima ywa kwembingu ywa Zumbe amlaila Yusufu mwe sozi nakumgamba, “Helode namlonde umwana chani amkome. Ivyo halaweni, mguhe umwana hamwenga na mamiyakwe mnyilikile Misili, mwikale uko kubula hadya hunga hugambile uhalawe.” ");
INSERT INTO ziw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ivyo ahalawa, amguha umwana hamwenga na mamiyakwe nechilo na kwita Misili, ");
INSERT INTO ziw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","hantu ekalaga kubula mo kubanika kwa Helode. Vino vyadamanyikaga saviya Zumbe alongaga kujinkila muwoni vilaila chindedi, “Simwitanga Mwanangu kulaila Misili.” ");
INSERT INTO ziw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode eze abunkule kugamba wajeni walaile ko ulailo we dizuwa wamzunguluka, kengilwa ni maya. Alavya sigilizi za kukoma wana chilume mwe Beselehemu hamwenga na we mjihi wata mihilimo midi na wadodo wawo. Vino vyadamanyikaga kutimilana na viya amanyaga kwa awajeni mwe chipindi che ntondo yalailaga. ");
INSERT INTO ziw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Naho uwoni wa muwoni Yelemiya wachintaga saviya alongaga, ");
INSERT INTO ziw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Izwi diivika kulaila uko Lama, ndilo ya usungu na malombolezo, Laheli akuwaila wanawe, haungile kuhembelezwa, kwaviya nendile wabanika.” ");
INSERT INTO ziw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helode eze abanike mndima ywa kwembingu ywa Zumbe amwizila Yusufu mwe sozi uko Misili, ");
INSERT INTO ziw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","na kumgamba, “Halawe, mguhe umwana hamwenga na mamiyakwe mfose muye mwe isi ya Izulaeli, kwaviya wadya nawakaunga wamkome umwana wabanika.” ");
INSERT INTO ziw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Elo Yusufu ahalawa, amguha umwana hamwenga na mamiyakwe, wafosa wauya Izulaeli. ");
INSERT INTO ziw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mna Yusufu eze eve kugamba Alikelayo nendile akalongoza hantu ha tatiyakwe Helode saviya zumbe ywa Yudeya, nakogoha kwita uko. Enkagwa sigilizi mwe sozi, ivyo aita mwe si ya Galilaya. ");
INSERT INTO ziw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kaita kwikala mwe mzi ukwitangwa Nazaleti. Ivyo viya wawoni walongaga vilaila, “Netangwe Mntu ywa Nazaleti.” ");
INSERT INTO ziw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mazuwa ayo Yohana Mta kubatiza alaila kwe nyika ya Yudeya na kukonga kulonga. ");
INSERT INTO ziw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Agamba, “Kweileni masa yenyu, kwaviya Useuta wa kwembingu wi hajihi!” ");
INSERT INTO ziw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohana nuyo mntu alongagwa ni muwoni Isaya akagamba, “Izwi dya mntu aguta kwe nyika, ‘Malanyani sila ya Zumbe, chulusani sila zose akunga ajinkile!’ ” ");
INSERT INTO ziw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Suche za Yohana zadamanyagwa kwa mazoya ya ngamiya, mwe chigudi chakwe avalaga msipi udamanywe kwa nchingo. Nkande yakwe nani sije na uchi. ");
INSERT INTO ziw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Elo wantu kulaila ntendele zose za Yudeya wambasaga Yohana kulaila Yelusalemu na kolongo dyose dyo mto Yolodani. ");
INSERT INTO ziw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Weze weile amasa yawo, niyo awabatiza mo mto Yolodani. ");
INSERT INTO ziw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohana eze awone Mafalisayo na Masadukayo walozize wakeza chani awabatize, awagamba, “Nyuwe welekwa wa nyoka! Ni yuhi awagambileni mwadaha mwenege nkanto ya Chohile akunga aigale kwenyu? ");
INSERT INTO ziw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Elo lagisani kwa ntendwa zedi kugamba mweila masa yenyu. ");
INSERT INTO ziw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Naho msekufanyanya kugamba mwadaha mwegombele mkagamba Bulahimu ni tati yetu. Nawagambilani kugamba Chohile adaha kuguha mayuwe yano nakuyatenda welekwa wa Bulahimu! ");
INSERT INTO ziw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hoya imalanywa kale kukanta masina ye miti, chila mti haukweleka matunda yedi naukantwe na kudulwa mo moto. ");
INSERT INTO ziw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Miye nawabatizani kwa mazi kulagisa kugamba mweila masa, yudya neze umo haheza miye nawabatizeni kwa Muye Ukukile na kwa moto. Ni mkulu kujinka miye, naho sikuwagila kwinula vilatu vyakwe. ");
INSERT INTO ziw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ana lungo mo mkono wakwe kuhetela nkande zoseni. Ngano yakwe naike mwe digulu, mna mahofya nayoke mo moto haukusila.” ");
INSERT INTO ziw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chipindi icho Yesu niyo eza kulaila Galilaya kubula mo mto wa Yolodani chani abatizwe ni Yohana. ");
INSERT INTO ziw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mna Yohana nakonga amchinde akamgamba, “Miye nuyo hungwa nibatize niweye,” “mna kwiza kwangu!” ");
INSERT INTO ziw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mna Yesu amhitula, “Leka vitende ivyo haluse. Mwe isila ino nachidamanye vyoseni viwoneke vyedi kwa Chohile.” Ivyo Yohana azumila. ");
INSERT INTO ziw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aho Yesu eze abatizwe, afosa mwa mazi. Niyo imbingu yagubuka, na kuwona Muye wa Chohile ukasela saviya suwamanga nakumlangaza. ");
INSERT INTO ziw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Niyo izwi dyalonga kulaila kwe imbingu, “Yuno nuyo mwanangu akuniwagila hungisa.” ");
INSERT INTO ziw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yesu niyo alongozwa ni Muye Ukukile kwe nyika chani ajezwe ni Mwavu. ");
INSERT INTO ziw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eze afunge kudya kwa mazuwa milongo mine chilo na msi, Yesu niyo alumwa nisala. ");
INSERT INTO ziw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Niyo Mwavu ambasa nakumgamba, “Uneva wi mwana Chohile, yahitwile mayuwe yano yatende migate.” ");
INSERT INTO ziw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mna Yesu ahitula, “Mawandiko Yakukile yagamba, ‘Wantu hawakudaha kwikala kwa migate iyodu, mna kwa chila ulosi Chohile akulonga.’ ” ");
INSERT INTO ziw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Niyo Mwavu amwigala Yesu Yelusalemu, Mzi Ukukile, amwika kulanga ko lunenengwe lwe Nyumba nkulu ya Chohile, ");
INSERT INTO ziw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nakumgamba, “Uneva chindedi wi Mwana Chohile, kwedule hasi, kwaviya mawandiko yagamba. ‘Chohile nawasigile wandima wa kwembingu wakwe, nawakutoze na mikono yawo, chani usekwekobadisa mwe yuwe iviga vyako.’ ” ");
INSERT INTO ziw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu ahitula, “Mna mawandiko Yakukile naho yagamba, ‘Usekumjeza Zumbe Chohile ywako.’ ” ");
INSERT INTO ziw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Niyo Mwavu amguha Yesu, amwigala mwe lugulu lutali vidala nakumlagisa useuta wose we isi na ukulu wakwe. ");
INSERT INTO ziw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mwavu agamba, “Vino vyoseni nahwinke uneva unafika madi univikile.” ");
INSERT INTO ziw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu niyo ahitula, Shetani halawe! Mawandiko Yakukile yagamba, Mvikile Zumbe Chohile ywako naho msankanile uyodu! ");
INSERT INTO ziw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Niyo Mwavu amleka Yesu, wandima wa kwembingu niyo weza kumwambiza. ");
INSERT INTO ziw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu eze eve kugamba Yohana Mta kubatiza kajelwa mndani, aita Galilaya. ");
INSERT INTO ziw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hekale Nazaleti, mna kaita Kapelinaumu, mzi wi hankanda he diziwa dya Galilaya, mwe si ya Zabuloni na Nafutali. ");
INSERT INTO ziw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Uwoni wa muwoni Isaya alongaga uchinta. ");
INSERT INTO ziw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Isi ya Zabuloni hamwenga ne isi ya Nafutali, mwe isila ikwita kwe bahali, kwe ntendele ntuhu yo mto Yolodani, Galilaya, si ya sawo Wayahudi! ");
INSERT INTO ziw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wantu wakwikala mwe chiza nawawone ulangazi mkulu. Mwe wadya wakwikala mwe isi ya chiza ya file ulangazi naulangaze.” ");
INSERT INTO ziw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kukongela aho Yesu kakonga kulonga ulosi wakwe, “Kweileni masa yenyu, kwaviya Useuta wa kwembingu wi hajihi!” ");
INSERT INTO ziw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Umo Yesu akajinka mnkanda mwe diziwa dya Galilaya, awona walukolo waidi walowa samaki, Simoni akwitangwa Petulo na mlukolo ywakwe akwitangwa Anduleya, wakalowa samaki mwe diziwa na lwavu. ");
INSERT INTO ziw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu awagamba, “Nitimilani, naniwahinye mtende walowa wantu.” ");
INSERT INTO ziw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aho waleka izinyavu zawo wamtimila. ");
INSERT INTO ziw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eze ajende jende awawona walukolo watuhu waidi, Yakobo na Yohana, wana wa Zebedayo. Nawe mwe ngalawa na tati yawo Zebedayo, wakasuma nyavu zawo vyedi. Yesu awetanga, ");
INSERT INTO ziw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","aho wayasa ingalawa hamwenga na tati yawo, wamtimila. ");
INSERT INTO ziw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu aita mwe isi yose ya Galilaya, akahinya mwe nyumba ya Chiyahudi ya kuvikila, akalonga Mbuli Yedi yo Useuta wa Chohile, na kuhonya wantu wata manyonje yesimile. ");
INSERT INTO ziw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mbuli zakwe zizagala mwe isi yose ya Siliya, ivyo wantu wamwigaila wadya woseni na wakahuma, wa kuhuma manyonje yesimile na masulumizo, wantu wata mpepo, na wata chifutu hamwenga na wantu waholomale. Yesu naye kawahonya woseni. ");
INSERT INTO ziw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Fyo kulu dimtimila kulaila Galilaya na Dekapoli si ina mizi mlongo, kulaila Yelusalemu, Yudeya hamwenga ne isi mwe ntendele ntuhu yo mto wa Yolodani. ");
INSERT INTO ziw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu eze awone fyo dya wantu niyo akwela kwe lugulu, uko niyo ekala hasi. Wanampina wakwe wambasa, ");
INSERT INTO ziw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","niyo akonga kuwahinya. ");
INSERT INTO ziw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nawajimbikwe wadya wachiwa wa chimuye wakumsinya Chohile, Useuta wa kwembingu ni wawo! ");
INSERT INTO ziw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nawajimbikwe wadya wata chinyulu, kwaviya Chohile nawafile mbazi! ");
INSERT INTO ziw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wajimbikwe ni wahoile, kwaviya nawalisi isi! ");
INSERT INTO ziw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Chinyemi ni kwa wadya wakungisa kudamanya yawoneke yedi kwa Chohile, Chohile naweguse! ");
INSERT INTO ziw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Chinyemi ni kwa wadya wakufila mbazi watuhu, Chohile nawajimbike! ");
INSERT INTO ziw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Chinyemi ni kwa wadya wata moyo ulenguke, nawamwone Chohile! ");
INSERT INTO ziw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Chinyemi china waivanyi, kwaviya nawetangwe wana wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ujimbiko ni kwa wadya wakwihizwa kwachausa cha kuwoneka wedi, kwaviya useuta kwembingu ni wawo. ");
INSERT INTO ziw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mjimbikwa nyuwe chipindi wantu wakawahulutani na kuwasulumizani na kuwalongani vihiye kwa chausa changu. ");
INSERT INTO ziw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mtende na chinyemi na kubweda, kwaviya mwikiwa ntunyo nkulu kwembingu. Vino nivyo wawoni wekalaga umo nyuwe hamwinati kusulumizwa. ");
INSERT INTO ziw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nyuwe saviya munyu mwe isi. Mna uneva munyu ukaza ulumunyu lwakwe, naudamanywe vivihi munyu vituhu? Haikuwagila kwa chochose, mna udulwe hasi nakujatwa ni wantu. ");
INSERT INTO ziw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nyuwe mwi ulangazi mwe isi. Mzi mwe lugulu haukwefisa. ");
INSERT INTO ziw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Naho wantu hawakuwasha taa niyo wazika kwedivungu. Mna wazika mlanga mwe chiya cha kwikiya taa, niyo zalangaza kwa chila yumwenga mwe nyumba. ");
INSERT INTO ziw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mwe ivyo, ulangazi wenyu na naulangaze mwa meso ya wantu, chani wawone ntendwa zenyu zedi na kumtunya Tati yenyu ywa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Msekufanyanya siza kuhigana na Sigilizi ya Musa na mahinyo ya wawoni. Sizile kuhigana nayo, mna kutenda mahinyo yawo yachinte. ");
INSERT INTO ziw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nawagambilani chindedi, kubula uhelo we mbingu ne isi, hachihali chidodo hegu hadodo vitendese ha sigilizi nahauswe kubula chila chintu chichinte. ");
INSERT INTO ziw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Elo, yoyose hekutimila hata umwenga mwe miko ikigwe hata hegu ni mdodo na kuhinya watuhu kudamanya ivyo, natende mdodo mo Useuta wa kwembingu. Vituhu, yoyose akutimila Sigilizi nakuhinya watuhu kudamanya saivyo, natende mkulu mo Uzumbe wa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ivyo, nawagambilani kugamba, namdahe kwingila mo Useuta wa kwembingu uneva du hegu mna kuwoneka wedi kuwajinka wahinyi wa Sigilizi na Mafalisayo mwe kudamanya viya Chohile akunga. ");
INSERT INTO ziw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mwiva kugamba aho kale wantu wagambilagwa, ‘Usekukoma, mntu yoyose akudamanya ivyo na akantilwe.’ ");
INSERT INTO ziw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mna miye nawagambilani kugamba yoyose akumwihiwa mlukolo ywakwe aungwa akantilwe. Naho, yoyose akumgamba mlukolo ywakwe ‘Weye wi ywa bule!’ Negalwe kwe chitala, naho akumgamba mlukolo ywakwe kugamba wi mchilalu nehose kwigalwa kwe bome hedina uhelo. ");
INSERT INTO ziw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ivyo uneva waunga kumlaviza jeleko Chohile mwe nchanja yo kulaviza ntambiko niyo wakumbuka kugamba kulemana na mlukolo ywako, ");
INSERT INTO ziw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","asa idilavyo dyako kulongozi kwe nchanja yo kulaviza ntambiko, hita mkevane na mlukolo ywako, ukaheza uya ukalavywe idilavyo dyako kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Uneva mntu akulaha ivanani hemwinati kabula kwechitala, chani mlahi ywako anasekukwinkiza kwa mkanta, akunga akwinkize kwa mndima mnkondo, nawe naujelwe mndani. ");
INSERT INTO ziw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Chindedi nakugambila, uko nawikale kubula aho nobinde kuliha maliho ya nkomelezo. ");
INSERT INTO ziw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mwiva kugamba navilongwa, ‘Msekugonya.’ ");
INSERT INTO ziw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mna nawagambilani yoyose akumsinya mvyele na kummeila mate kamgonya kale naye mo moyo wakwe. ");
INSERT INTO ziw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Elo uneva ziso dyako dya kulume dyakuhosa ukole masa, ding'ole udidule! Ni vitana vidala waze hantu ho umwili wako kuleka umwili wako mjima kudulwe kwe dibome hedina uhelo. ");
INSERT INTO ziw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Uneva mkono wako wakulume wakuhosa ukole masa, ukante uudule! Ni vitana vidala waze hantu he vitago vyako kuleka umwili wako mjima kudulwa mwe dibome hedina uhelo. ");
INSERT INTO ziw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Naho vilongwa, ‘Yoyose akumwasa mkaziwe amwinke mawandiko ya kumwasa.’ ");
INSERT INTO ziw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mna nawagambilani kugamba yoyose akumwasa mkaziwe, mna siyo kwachausa cha chilanga, amtenda mkaziwe yudya agonywa uneva ana solwa vituhu. Naho akumsola uyo asigwe naye ni mgonyi. ");
INSERT INTO ziw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Naho mwiva kugamba aho kale navilongwa, ‘Msekwelisa udanti, mna mdamanye viya mungile mumdamanyize Zumbe.’ ");
INSERT INTO ziw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mna miye nagamba, msekwelisa ng'o, hata kwembingu, kwaviya nicho chigoda cho uzumbe mazuwa yose cha Chohile, ");
INSERT INTO ziw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","hegu mwe isi, kwaviya ni hantu hakwikiya viga vyakwe, hegu mwe Yelusalemu, kwaviya nuwo mzi wa Seuta mkulu. ");
INSERT INTO ziw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naho usekwelisa kwa mtwi wako, kwaviya hukudaha kudamanya hata luvili lumwenga lutende lung'aile hegu lutitu. ");
INSERT INTO ziw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mna ‘Nivyo’ itende ‘Nivyo’ hegu ‘Bule’ itende ‘Bule.’ Vituhu vikujinka aho vyalawa kwa Mwavu. ");
INSERT INTO ziw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mwiva kugamba vilongwa, ‘Ziso kwa ziso, naho zino kwa zino.’ ");
INSERT INTO ziw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mna miye nawagambilani, msekuhigana na mntu mwavu, uneva mntu akakuhuta mwe funda ya kulume, mhitwile intuhu nayo. ");
INSERT INTO ziw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Naho mntu akakwigala kwe chitala kukulaha kwa nkazu yako, mlekeile ne dijoho nadyo. ");
INSERT INTO ziw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Naho mntu anakunga ujende maili imwenga, jenda naye mbili. ");
INSERT INTO ziw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mwinke akukulombeza, naho usekumlemeila akukulombeza. ");
INSERT INTO ziw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mwiva kugamba navilongwa, ‘Waunge wambuyazo, wehiwe wankondo wako.’ ");
INSERT INTO ziw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mna miye nawagambilani, waungeni wankondo wenyu naho walombezezeni wadya wakuwasulumizani, ");
INSERT INTO ziw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","chani mkatende wana wa Tate ywa kwembingu. Kwaviya alangaziza zuwa dyakwe kwa wantu wavu na wantu wedi, naho anyesa fula kwa wadya wakuwoneka wedi na hewekuwagila. ");
INSERT INTO ziw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Namwinkigwe jeleko dyani kulaila kwa Chohile uneva mkawaunga wadya wakuwaungani? Hata wachisanya kodi wadamanya saivyo! ");
INSERT INTO ziw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Naho uneva mwasimwila na walukolo wenyu du, mdamanya vihi vitendese? Hata hewemzumile Chohile wadamanya saivyo! ");
INSERT INTO ziw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mwaungwa mchinte, saviya Tati yenyu wa kwembingu achintile! ");
INSERT INTO ziw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Msinyise msekudamanya wedi mwa meso ya wantu, chani wawasinyeni, kwaviya mnadamanya ayo hamkuhokela ntunyo kwa Tati yenyu ywa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ivyo umo ukenkiza malavyo, usekuvila gunda kwa mntu yoyose saviya wasongaganyi wakulombeza mwe nyumba zo kuvikila na mwe sila, chani watunywe ni wantu. Nawagambilani ichindedi, wahokela kale ntunyo yawo. ");
INSERT INTO ziw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mna nyuwe mkalavya malavyo damanyani kwa chinyele, usekuleka mkono wako wa kumoso umanye chiya chikudamanywa ni wa kulume, ");
INSERT INTO ziw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chani lavyo dyako ditende dya chinyele. Tati yako, akuwona vikudamanywa chinyele, nakutunye. ");
INSERT INTO ziw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Umo mkamlombeza Chohile, msekutenda saviya wasongaganyi! Waunga kuchimala wakamlombeza Chohile mwe nyumba zo kuvikila na mwe zikaya, chani wawonwe ni chila mntu. Nawagambilani chindedi wahokela kale ntunyo yawo. ");
INSERT INTO ziw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mna ukamlombeza Chohile, ingila mwe chumba chako vugala ulwivi, niyo walombeza kwa Tati yako, hekuwoneka. Tati yako naye, akuwona vya chinyele, nakutunye. ");
INSERT INTO ziw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Mkamlombeza Chohile, msekulonga mbuli heziligane, saviya wantu hewemzumile Chohile wakutenda, wakufanyanya chohile wawo naweve kwaviya walombezesa. ");
INSERT INTO ziw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Msekwikala sa awo. Tati yenyu kavimanya kale viya mkunga umo nyuwe hemnati kumlombeza. ");
INSERT INTO ziw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Elo msinyise ivyo mkungwa mlonge mkalombeza kwa Chohile, ‘Tati yetu ywa kwembingu, zina dyako Dikukile ditogolwe, ");
INSERT INTO ziw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Useuta wako na wize, hano he isi saviya vi kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Chinke mdyo wetu chikunga dyelo. ");
INSERT INTO ziw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Chilekeile masa yetu, saviya chikulekeila masa chidamanyizwe ni watuhu. ");
INSERT INTO ziw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Usekuchijela mwe majezo, mna uchambule na yudya Mwavu. Kwaviya uzumbe ni wako na udahi na ukulu mazuwa yoseni. Navitende ivyo.’ ");
INSERT INTO ziw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Uneva mkawalekeila wantu watuhu masa yawo wawadamanyize, Tati yenyu ywa kwembingu nawalekeileni seivyo. ");
INSERT INTO ziw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mna uneva hamuwalekeile watuhu, Tati yenyu naye hawalekeileni masa yenyu mdamanye. ");
INSERT INTO ziw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Umo mkafunga, msekusinyala izi nyuso zenyu saviya wasongaganyi wakutenda. Waleka viya weli chani wamanyike kugamba wafunga. Nawagambilani, wahokela kale maliho yawo yachintile. ");
INSERT INTO ziw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mna weye ukafunga hwi kudya, kuluguta mavuta mo uso naho uchane izi fili zako, ");
INSERT INTO ziw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","chani watuhu wasekumanya kugamba kufunga, Tati yako uyodu, hekuwoneka, namanye. Tati yako, akuwona ukudamanya chinyele, nakutunye. ");
INSERT INTO ziw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Msekwikiya ugoli hano he isi, ukubalangwa ni sondo na nkanga, wabavi nawo wavuna na kubawa. ");
INSERT INTO ziw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mna, ikani ugoli wenyu kwembingu, sondo na nkanga havikudaha kubalanga na wabavi nawo hawakudaha kuvuna na kubawa. ");
INSERT INTO ziw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwaviya moyo wako nawikale hadya ugoli wako wili. ");
INSERT INTO ziw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Meso yekala enga taa yo umwili. Uneva meso yako yawona vyedi, umwili wako mjima naulangazwe, ");
INSERT INTO ziw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","mna uneva ameso yako yaiha, umwili wako nawikale mwe chiza. Elo uneva ulangazi wi mwako ni chiza, nakutende na chiza chivivihi! ");
INSERT INTO ziw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Hahali akudaha kutenda mtumwa ywa mazumbe waidi, namwihiwe yumwenga nakumunga umtuhu, namtunye yumwenga nakubela umtuhu. Hamkudaha kusankanila woseni Chohile hamwenga na ugoli. ");
INSERT INTO ziw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Vino nivyo vikuleka huwagambilani kugamba msekwogoha mwe mbuli za nkande na vya kunywa vikunga vikaleka mkatenda wajima, hegu mwe suche za mili yenyu. Vino, ujima suwo wedi kujinka nkande? Naho mwili suwo wedi kujinka suche? ");
INSERT INTO ziw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kaulani wadege, hawakuhanda mbeyu, kuchisanya nkande nakuika mwe magulu. Mna Tati yenyu ywa kwembingu awasinya! Nyuwe hamwi wedi kujinka wadege? ");
INSERT INTO ziw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Vino hana yumwenga mgati mwenyu akudaha kujenyeza ujima wakwe hadodo, hegu utali wakwe hadodo? ");
INSERT INTO ziw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Naho ni mbwani kwevinya mwe suche? Kaulani viya maluwa ya kumbago yakukula, hayakudamanya ndima hegu kwesumila suche. ");
INSERT INTO ziw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mna nawagambilani kugamba hata Zumbe Sulemani na ukulu wakwe woseni nahana suche ntana sa luwa dimwenga mwe yano. ");
INSERT INTO ziw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ni Chohile akuvisa zani dya kumbago, diya dyelo diyaho naluvi, dyokwa. Hana uchindedi utendese wa kuwavisa nyuwe? Nyuwe wata uzumizi mjeche! ");
INSERT INTO ziw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ivyo msekwogoha, mkagamba, ‘Nachidye mbwani? Nachinywe mbwani? Hegu nachivike mbwani?’ ");
INSERT INTO ziw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vino nivyo ivintu hewekuzumila wakufanyanya. Tati yenyu ywa kwembingu kavimanya kugamba mwaunga vino vintu vyoseni. ");
INSERT INTO ziw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mna kujinka yoseni, mfanyanye Useuta wa Chohile na wedi wakwe, naye nawenkeni vyoseni vituhu. ");
INSERT INTO ziw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Elo msekusankanila mbuli za luvi, neyevinye yenye. Chila zuwa dina mbuli zakwe. ");
INSERT INTO ziw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mse kukantila watuhu, chani Chohile naye asekuwakantilani, ");
INSERT INTO ziw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kwaviya sila na mjeseze kukantila watuhu, nizo na mkantilwe. ");
INSERT INTO ziw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ni mbwani ukusinya kabasi ke mwe ziso dya mlukolo ywako, hwikusinya msomo wi mwe ziso dyako? ");
INSERT INTO ziw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wadaha vivihi kulonga kwa mlukolo ywako, ‘Goja nuse kabasi ke mwe ziso dyako,’ weye mwenye una msomo mwe idiziso dyako? ");
INSERT INTO ziw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Weye msongaganyi! Konga kulavya msomo mwe diziso dyako, naho naudahe kuwona vyedi kulavya kabasi ke mwe ziso dya mlukolo ywako. ");
INSERT INTO ziw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Msekwinka makuli vintu vikukile, naho mnase kuzidwila nguluwe salu zenyu za yombe kulu zinase kujatwajatwa. ");
INSERT INTO ziw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Lombezani, naywi namhokele, londani, naywi namuwone, towani hodi, naywi namvugwilwe. ");
INSERT INTO ziw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mna chila akulombeza nahokele, naho chila yumwenga akulonda nawone, akutowa hodi navugwilwe. ");
INSERT INTO ziw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hana yumwenga ywenyu tati ywa mntu akumwinka mwanawe yuwe akamlombeza mgate? ");
INSERT INTO ziw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hegu namwike nyoka akamlombeza samaki? ");
INSERT INTO ziw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Elo uneva nyuwe wavu mmanya kwinka wana wenyu vintu vyedi. Tati yenyu ywa kwembingu hawenkise vintu vyedi kwa wadya wakumlombeza! ");
INSERT INTO ziw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Damanyizani watuhu viya mkunga wawadamanyizeni, nyuwe nanywi mwa wadamanyizagwa seivyo, vino nivyo ili Sigilizi ya Musa na mahinyo ya wawoni. ");
INSERT INTO ziw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ingilani mwe sila sisili, kwaviya sila ya kwe bome hedina uhelo ni zangalamu naho ni mpufu, walozize wagwila isila iyo. ");
INSERT INTO ziw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mna sila ikwiza ko ujima ni sisili, naho ni ndala, ni wajeche wakwiigwila. ");
INSERT INTO ziw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mkaulise wawoni wadanti, wamwizilani wekale kwa kuse saviya wavaile suche za ngoto, mna mndani mwawo wekala saviya mauzi. ");
INSERT INTO ziw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Namuwamanye kwa yadya wakudamanya. Miwa haikudaha kweleka zabibu, naho mibaluti haikulavya tini. ");
INSERT INTO ziw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mti wedi weleka matunda yedi, mti wihiye nawo haukudaha kweleka matunda yedi. ");
INSERT INTO ziw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mti wedi haukudaha kweleka matunda yehiye, mti wihiye nawo haukudaha kweleka matunda yedi. ");
INSERT INTO ziw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Chila mti hawikweleka tunda dyedi nausengwe niyo wadulwa ko moto. ");
INSERT INTO ziw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ivyo, wawoni wadanti namuwamanye kwa yadya wakudamanya. ");
INSERT INTO ziw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Suyo chila yumwenga akunitanga ‘Zumbe, Zumbe’ akunga engile mo Useuta wa kwembingu, mna wadya du wakudamanya viya Tati yangu ywa kwembingu akuwaunga wadamanye. ");
INSERT INTO ziw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Umo zuwa dya Ukanti dikabula, walozize nawanigambe, ‘Zumbe, Zumbe! Hachilongile ulosi wa Chohile kwa zina dyako, kwa zina dyako chigulusa mpepo na kudamanya mpituko zilozize!’ ");
INSERT INTO ziw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aho naniwagambe, ‘Siwamanyizeni. Halaweni hangu, wantu wabanasi nyuwe!’ ");
INSERT INTO ziw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ivyo, yoyose akwiva ulosi wangu uno nakuutimila kekala savya mntu mbala akuzenga nyumba yakwe mwe luwe. ");
INSERT INTO ziw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fula inya, mito imela na kubohola, nkung'unto isingisa. Mna nyumba haigwele, kwaviya msingi wakwe uzengwa mwe luwe. ");
INSERT INTO ziw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Mna yudya akwiva ulosi wangu niyo hakuutimila kekala saviya mntu mhezi azengile nyumba yakwe mwe msanga. ");
INSERT INTO ziw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Fula inya, mito imela na kubohola, nkung'unto isingisa inyumba, niyo yagwa. Ukugwa kwakwe ni msindo!” ");
INSERT INTO ziw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu eze aheze kulonga vintu vino, idifyo niyo dyehelwa mwe viya ahinyize. ");
INSERT INTO ziw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Hekale saviya wahinyi wa Sigilizi, mna, kahinya kwa udahi. ");
INSERT INTO ziw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Umo Yesu eze asele kwa kagulu, fyo kulu dimtimila. ");
INSERT INTO ziw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Niyo eza mntu yumwenga mta matana amfikila madi amgamba, “Zumbe, ukaunga wadaha kunitenda nilenguswe.” ");
INSERT INTO ziw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu achumiza umkono wakwe amdonta. Amgamba, “Naunga lenguswa!” Ahadya mtu uyo ahona matana yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Niyo Yesu amgamba, “Tegeleza! Usekumgambila mntu, mna hita ukelagise kwa mlavyantambiko, chani chila mntu akuwone kugamba kuhona, lavya lavyo diya alagize Musa.” ");
INSERT INTO ziw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu eze engile Kapelinaumu, mkulu yumwenga ywa Chilumi ambasa na kumlombeza amwabize. ");
INSERT INTO ziw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Amgamba, “Zumbe, mndima ywangu ni mnyonje kukaya, hakudaha kujenda naho alumiswa.” ");
INSERT INTO ziw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu amgamba, “Nanite hamhonye.” ");
INSERT INTO ziw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yudya mkulu ahitula, “Zumbe, bule,” “Miye sikuwagila weye wingile mwe nyumba yangu. Mna lavya ulosi du, mndima ywangu nahone. ");
INSERT INTO ziw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Miye nami ni mntu nihasi he udahi wa wakulu, naho nina wankondo watuhu wehasi hangu. Nami hamgamba yumwenga, ‘So!’ Eza, naho hamgamba mtuhu, ‘Hita!’ Aita, naho hamgamba mndima ywangu, ‘Damanya vino!’ Adamanya.” ");
INSERT INTO ziw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu eze eve ayo, kehelwa nakulonga kwa wantu wakumtimila, “Chindedi nawagambilani, sinati kuwona yoyose mwe Izulaeli mta uzumizi sa uno. ");
INSERT INTO ziw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nawagambilani kugamba, walozize naweze kulaila ko ulailo wa zuwa na mwingilo wa zuwa nakwikala hamwenga na Bulahimu, Isaka na Yakobo mwe Useuta wa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mna wadya wakunga watende mo Useuta na wadulwe kuse kwe chiza, uko nawaile na kusiginta meno.” ");
INSERT INTO ziw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Niyo Yesu amgamba yudya mkulu ywa nkondo, “Hita kaya, navitendeke saviya uzumile kwachausa chako.” Ahadya yudya mndima niyo ahona. ");
INSERT INTO ziw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu niyo aita kukaya kwa Petulo, uko ambwila nine vyala dya petulo, kagona mo lusazi hakudaha homa. ");
INSERT INTO ziw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Adonta umkono wakwe, ihoma yamlekela, achimala na kumsankanila. ");
INSERT INTO ziw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chisingi chize chingile, wantu wamwigaila Yesu wantu walozize na wata mpepo. Yesu agulusa mpepo zihiye kwa ulosi nakuhonya woseni nawakalumwa. ");
INSERT INTO ziw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Adamanyaga ivyo kutenda viya alongaga muwoni Isaya vilaile, “Yeye mwenye kaguha ubovu wetu nakuguha manyonje yetu.” ");
INSERT INTO ziw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu eze asinye fyo dya wantu dimzunguluka, awaunga wanampina wakwe womboke ntendele ya kaidi ye diziwa. ");
INSERT INTO ziw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mhinyi ywa Sigilizi yumwenga ambasa amgamba, “Mhinyi, miye na hutimile uko nawite.” ");
INSERT INTO ziw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu amhitula amgamba, “Mauzi yana malundu na wadege wana masasa mlanga mwe miti, mna Mwana ywa Mntu hana heugono na kuhumula.” ");
INSERT INTO ziw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yumwenga mwa wanampina wakwe amgamba, “Zumbe, ndakunileka nuye hamhambe tate.” ");
INSERT INTO ziw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu amhitula amgamba, “Nitimila, waleke wabanike wahambe weyawe wabanike.” ");
INSERT INTO ziw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu akwela mwe ngalawa, wanampina wakwe nawo waita naye. ");
INSERT INTO ziw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aho wimbi kulu dyatowa idiziwa, ngalawa neimwe nkondo ya kudidimila. Mna Yesu na kagona. ");
INSERT INTO ziw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wanampina wambasa wamwinula. Wamgamba, “Zumbe! Chikombole. Chafa!” ");
INSERT INTO ziw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu ahitula, “Ni mbwani mkogohesa? Chindedi uzumizi wenyu nimdodo!” Niyo enuka na kukwahila inkung'unto namawimbi vinyamale, niyo kwatenda kwa ziziwalisa. ");
INSERT INTO ziw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chila yumwenga kehelwa. Wagamba, “Yuno ni mntu ywani? Hata nkungunto na mawimbi vyamwiva!” ");
INSERT INTO ziw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Umo Yesu eze abule mo mzi wa Gadala mwe ntendele ntuhu ye diziwa, adugana na wantu waidi wakulaila kwe zimbila. Wantu wadya wendaga na mpepo nkali zitendese naho nendile hahana mntu ukudaha kugwila isila iyo. ");
INSERT INTO ziw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aho waguta, “Wachunga mbwani, weye Mwana Chohile? Kwiza kuchinka nkuto chipindi hachinati kubula?” ");
INSERT INTO ziw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nakuna fyo dya nguluwe dikudya hajihi aho. ");
INSERT INTO ziw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ivyo mpepo zamlombeza Yesu, “Uneva waunga uchiguluse, chigale mwe diya idifyo dye zinguluwe.” ");
INSERT INTO ziw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu awagamba, “Hitani.” Ivyo zafosa nakwingila mwe zinguluwe. Fyo jima dye zinguluwe dyagulukila kwe diziwa nakufila mwa mazi. ");
INSERT INTO ziw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wadimi nawakadima izinguluwe niyo waguluka kwita komzi, uko wakusimwila imbuli injima naviya vilaile kwa wadya wantu wata zimpepo. ");
INSERT INTO ziw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ivyo chila yumwenga kulaila komzi kaita kumsingila Yesu, weze wamwone, wamlombeza amlawe mo umzi wawo. ");
INSERT INTO ziw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu engila mwe ngalawa, alaila ntendele ya kaidi ye diziwa nakwingila komzi wakwe nakekala. ");
INSERT INTO ziw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wantu wamwenga wamwigaila mntu aholomale, agonile mwe lusazi. Yesu eze awone uzumizi wakwe, amgamba yudya aholomale, “Mwanangu kwenke moyo, masa yako yalekeilwa.” ");
INSERT INTO ziw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Niyo wahinya Sigilizi wamwenga wawagamba, “Yuno mntu amhuluta Chohile!” ");
INSERT INTO ziw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu kuno akamanya viya wakufanyanya mwe myoyo yawo, awagamba, “Ni mbwani mkufanyanya mbuli zihiye sa zino? ");
INSERT INTO ziw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Vihufu ni vihi, kugamba, ‘Masa yako yalekeilwa,’ hegu kugamba, ‘Chimala ujende’? ");
INSERT INTO ziw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ivyo naunga mnamanye kugamba Mwana ywa Mntu ana udahi mwe isi wa kulekeila masa.” Elo amgamba yudya mntu aholomale, “Chimala, guha lusazi lwako wite kaya!” ");
INSERT INTO ziw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Uyo mntu achimala nakwita kaya. ");
INSERT INTO ziw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Umo wantu weze waviwone viya vilaile wogoha, na kumtunya Chohile kwa kumwinka udahi kwa wantu. ");
INSERT INTO ziw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu ahalawa aho hantu, niyo ajenda jenda, awona mchisanya kodi, akwitangwa Matayo, kekala he ndima yakwe. Amgamba, “Nitimila.” Matayo enuka na kumtimila. ");
INSERT INTO ziw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Umo Yesu akadya nkande kukaya kwa Matayo, wachisanya kodi walozize na wata masa watuhu weza nakulungana na Yesu hamwenga na wanampina wakwe he ndala. ");
INSERT INTO ziw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo wamwenga waviwona vino nakuwauza wanampina wakwe, “Ni mbwani mhinyi wenyu akudya na wachisanya kodi na wantu wata masa?” ");
INSERT INTO ziw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu kaweva nakuwahitula, “Wantu wajima hawakunga mlaguzi, mna wadya wanyonje awodu. ");
INSERT INTO ziw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hitani mkalonde Vikulongwa mwa mawandiko Chohile alongaga. ‘Naunga mbazi, siyo ntambiko ya nyama.’ Miye mwenye sizile kunga wadya wakwefanyanya wawoneka wedi, mna wata masa.” ");
INSERT INTO ziw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Niyo wanampina wa Yohana Mta kubatiza wambasa Yesu, wakauza, “Ni mbwani suwe chafunga, Mafalisayo nawo wafunga, mna wanampina wako hawakufunga ng'o?” ");
INSERT INTO ziw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu ahitula, “Vino wajeni wagonekwe mwe nyinka wadaha kwikala na usungu umo umwali nauswe? Havikudahika! Mna zuwa dyeza umo nyinka yo umwali nayuswe kwenyu, nawo nawafunge. ");
INSERT INTO ziw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Hahali akusuma chilaka cha suche mpya mwe suche isakale, kwaviya chihya nachitatule suche isakale na kujela sakaza mwe isuche. ");
INSERT INTO ziw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hahali akujela divai mpya mwe vyampa vya mikota visakale, kwaviya mikwiji naitulike, divai naitike, mikwiji naibanike. Mna divai mpya yaikwa mwe vyampa vya mikota vihya, vyoseni navikale mwe hali yedi.” ");
INSERT INTO ziw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Umo Yesu akalonga vino, mkulu yumwenga wa Chiyahudi ambasa, amfikila madi na kugamba, “Mwanangu wa chiche kabanika. Mna so ujeleke mikono yako mwakwe, natende mjima.” ");
INSERT INTO ziw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ivyo Yesu afosa nakumtimila, wanampina wakwe nawo waita hamwenga naye. ");
INSERT INTO ziw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mvyele nakahuma unyonje wa kulawa sakame kwa mihilimo mlongo na midi kamtimila Yesu hanyuma niyo adonta lepe dye suche ya Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Egamba mwenye, “Uneva du ninadonta isuche yakwe, na nihone.” ");
INSERT INTO ziw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu ahitukila kunyuma niyo amwona yudya mvyele, amgamba, “Kwenke moyo, mwanangu ywa chiche! Uzumizi wako ukuhonya.” Aho yudya mvyele atenda kahona. ");
INSERT INTO ziw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Niyo Yesu aita kukaya kwa yudya mkulu. Eze awone wantu wakachema nchemo za ndilo kuno fyo dya wantu wakatula lwasu, ");
INSERT INTO ziw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","agamba, “Chila yumwenga afose! Yuno mwana chiche habanike, kata kugona du!” Niyo wose wamseka. ");
INSERT INTO ziw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mna wantu weze wafose, Yesu niyo engila mwe chumba nachina umwana uyo, amtoza mkono, umwana naye achimala. ");
INSERT INTO ziw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mbuli zo ulosi uno zijenyela mwe isi idya yose. ");
INSERT INTO ziw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ahalawa hadya hantu, umo akajenda, mantuntu waidi wakonga kumtimila. Waguta, “Mwana ywa Daudi, chifile mbazi!” ");
INSERT INTO ziw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu eze abule kukaya, wadya mantuntu waidi wambasa, niyo awauza, “Mwavizumila kugamba nadaha kuwahonya?” Wahitula, “Zumbe, nivyo!” ");
INSERT INTO ziw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Niyo Yesu adonta ameso yawo na kugamba, “Navilaile, saviya mzumile!” ");
INSERT INTO ziw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Niyo meso yawo yagubuka. Yesu awasigila kwa nguvu, “Msekwiilonga imbuli ino kwa yoyose!” ");
INSERT INTO ziw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mna wahalawa nakulonga mbuli za Yesu mwe isi idya yose. ");
INSERT INTO ziw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Umo wantu wakahalawa, wantu wamwenga wamwigaila Yesu chimumu kwaviya nendile ana mpepo. ");
INSERT INTO ziw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mna aho mpepo ize iguluswe, uyo mntu akonga kulonga, chila yumwenga kehelwa. Wagamba, “Hachinati kuwona chintu sa chino mwe Izulaeli!” ");
INSERT INTO ziw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mna Mafalisayo wagamba, “Mkulu ywa mpepo nuyo akumwinka Yesu udahi wa kugulusa mpepo.” ");
INSERT INTO ziw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu azunguluka kutalamkila mizi na kaya zoseni. Kahinya mwe nyumba zo kuvikila, akalonga Mbuli Yedi yo Useuta, nakuhonya wantu wata manyonje na maine yesimane. ");
INSERT INTO ziw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Eze awone fyo dya wantu, umoyo wakwe niyo wawafila mbazi, kwaviya wekala wata woga kuno wasokele, saviya ngoto hezina mdimi. ");
INSERT INTO ziw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ivyo awagamba wanampina wakwe, “Ulozo uloza, mna wavuni ni wajeche. ");
INSERT INTO ziw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mlombezeni Zumbe mta ywa uvuni, egale wandima kuchisanya ulozo wakwe.” ");
INSERT INTO ziw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu kawetanga wanampina wakwe mlongo na waidi, awenka udahi wakugulusa mpepo nchafu na kuhonya chila unyonje. ");
INSERT INTO ziw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mazina yawo wasigilwa mlongo na waidi ni yano, ywa nkongo ni Simoni akwitangwa Petulo, na mlukolo ywa Anduleya, Yakobo mwana ywa Zebedayo, hamwenga na mlukolo ywakwe Yohana, ");
INSERT INTO ziw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo na Batolomayo, Tomaso na Matayo mchisanya kodi, Yakobo mwana Alifayo, na Tadeyo, ");
INSERT INTO ziw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni Zelote, na Yuda Isikaliyote yudya amhituke Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu kawasigila wasigilwa mlongo na waidi na kuwenka malagizo yano, “Msekwita kwa wantu sawo Wayahudi naho msekwingila mwe mizi ya Wasamaliya. ");
INSERT INTO ziw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mna hitani kwe ngoto zagile za nyumba ya Izulaeli. ");
INSERT INTO ziw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mo kwita kwenyu mkalonge kugamba. ‘Useuta wa kwembingu wi haguhi!’ ");
INSERT INTO ziw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Honyani wanyonje, uyusani wabanike, lengusani wata matana, gulusani mpepo. Hamlihile udahi uwo, nyuwe nanywi msekunga chochose. ");
INSERT INTO ziw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mwe mikwiji yenyu msekuguha zahabu, hela, hegu matundu ya shaba. ");
INSERT INTO ziw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Msekuguha mkwiji wa kulombezeza mwe sila, suche ntuhu, vilatu, hegu nkome. Kwaviya mdamanya ndima aungwa ahokele maliho yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mkengila mwe mzi wowose hegu kaya, londani mntu akunga awahokele, ikalani mwakwe kubula aho mkunga mhalaile. ");
INSERT INTO ziw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mnengila mwe nyumba walamseni wakaya wa mwe nyumba iyo. ");
INSERT INTO ziw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Uneva wantu we nyumba idya wakawahokela, watende na utondowazi udya muwaungile, mna wanawalemela, utondowazi wenyu uwawiyeni. ");
INSERT INTO ziw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Uneva mntu yeyose na alemele kuwahokela, hegu kuwetegeleza, ilaweni nyumba iyo hegu umzi uwo, naho mkungunte iditifili mwe viga vyenyu. ");
INSERT INTO ziw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nawagambilani chindedi, mwe dizuwa dyo kukantilwa, Chohile na awafile mbazi wantu wa Sodoma na Gomola kujinka wantu wo umzi udya! ");
INSERT INTO ziw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kwetegelezeni! Nawasigila saviya ngoto mgati mwe mauzi. Msinyise saviya nyoka, naho mhole saviya suwamanga. ");
INSERT INTO ziw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mkaulise! Kwaviya nawawegaleni mwe vitala naho nawahute nkome mwe zinyumba zo kuvikila. ");
INSERT INTO ziw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Namwigalwe kulongozi kwa wakulu na maseuta kwa chausa changu, chani mlavye ukuzi wa Mbuli Yedi ya Chohile kulongozi kwawo na kulongozi kwa wantu sawo Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Umo wanawegalani mwe vitala, msekogoha kugamba namgaze hegu namhitule vivihi, mkabula namwinkigwe yokulonga. ");
INSERT INTO ziw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwaviya sawo nyuwe mkunga mlonge, mna Muye wa Chohile nuwo naulonge kujinkila nyuwe. ");
INSERT INTO ziw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mlukolo namhose mlukolo mnyawe akomwe, tati ya mntu na amhose mwanawe, wana nawawahitukile welesi wawo na kuwakoma. ");
INSERT INTO ziw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wantu wose nawawehiweni kwa chausa che dizina dyangu. Mna akunga ajijimize kubula koudumo, nuyo akunga akombolwe. ");
INSERT INTO ziw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Umo wakawasulumiza mwe mzi umwenga, gulukilani mwe mzi mtuhu. Nawagambilani chindedi hambinde kujenda mwe mizi yose ya Izulaeli Mwana ywa Mntu hanati kwiza. ");
INSERT INTO ziw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mwanampina suyo mkulu kumjinka mhinyi ywakwe, hegu mndima hakumjinka mkulu ywakwe. ");
INSERT INTO ziw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vyachinta mwanampina kutenda saviya mhinyi ywakwe, na mndima kutenda saviya mkulu ywakwe. Uneva wamwitanga mta ikaya Belizebuli, ivyo hawawetange awakaya mazina yehiyise! ");
INSERT INTO ziw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ivyo, mse kuwogoha wantu awo. Chila chigubikwe nachigubulwe, naho chila chifisigwe nachimanyike. ");
INSERT INTO ziw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Huwagambilani nyuwe mwe chiza, ilongeni kung'aile, naho mbuli mkuiva ikatakaliswa, ilongeni mwa wantu mlanga mwe nyumba. ");
INSERT INTO ziw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mse kuwogoha wadya wakukoma umwili, mna hawakudaha kukoma imyuye. Ywa kogoha ni yudya akudaha kuukoma mwili hamwenga no muye mo umoto we bome hedina uhelo. ");
INSERT INTO ziw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Wadege waidi watagwa tundu dimwenga. Mna hahali yumwenga mgati mwawo akunga agwe hasi Tati ywawo hevimwagile. ");
INSERT INTO ziw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mna kwenyu, hata fili zose mwe mitwi yenyu ziwazwa. ");
INSERT INTO ziw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ivyo mse kogoha, nyuwe mwi wedi kujinka wadege walozize! ");
INSERT INTO ziw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Chila akunizumila mwa meso ya wantu, miye nami nanimzumile mwa meso ya Tati yangu kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mna akunilemela mwa wantu, nami nanimlemele mwa meso ya Tati ywangu kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mse kufanyanya kugamba siza kwigala utondowazi mwe isi. Sizile kwigala utondowazi mna sime. ");
INSERT INTO ziw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Siza kulemanya wana na tati ywawo, mwana chiche na nine, mkwelima na mkwewe, ");
INSERT INTO ziw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","mnkondo ywako ni mwelekwa ywako mwenye. ");
INSERT INTO ziw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Akumuungisa tati yakwe hegu mami yakwe kujinka miye, hakuniwagila. Akumuungisa mwana chilume hegu mwana chiche kujinka miye hakuniwagila, ");
INSERT INTO ziw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","naho hekwinula msalaba wakwe na kunitimila hakuniwagila. ");
INSERT INTO ziw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mta kuwona ujima wakwe nawaze, naho yudya akuwaza ujima wakwe kwa chausa changu, nauwone. ");
INSERT INTO ziw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Akuwahokelani nyuwe, anihokela miye, yudya naye akunihokela miye, amhokela yudya anisigile. ");
INSERT INTO ziw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Akumhokela muwoni kwaviya ni muwoni, na ahokele ntunyo ya muwoni. Akumhokela mta kuwagila kwaviya wawoneka ni wedi, na ahokele ntunyo ya mata kuwagila. ");
INSERT INTO ziw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Naho uneva yoyose amwinka hata champa cha mazi ye mpeho kwa yumwenga mwe wano wadodo kwaviya ni mwanampina ywangu, nawagambilani chindedi, na ahokele jeleko.” ");
INSERT INTO ziw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Umo Yesu eze abinde kuwasingila wanampina wakwe mlongo na waidi, niyo ahalawa, aita kuhinya na kulonga mwe mizi ihaguhi na hadya. ");
INSERT INTO ziw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohana Mta kubatiza umo achei kwe dijeleza eze eve mbuli zose zikudamanywa ni Kulisito, awasigila wanampina wakwe, ");
INSERT INTO ziw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","wakamuze, “Weye ni yudya ukungwa eze, hegu chimgoje mtuhu?” ");
INSERT INTO ziw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu ahitula awagamba, “Hitani mkamgambile Yohana yadya yose mkwiva na kuwona. ");
INSERT INTO ziw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Matuntu wadaha kuwona, waholomale wajenda, wata matana walenguswa, hewe kwiva weva, wabanike wauyuswa naho Mbuli Yedi ya Chohile ya longwa kwa wachiwa. ");
INSERT INTO ziw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ni chinyemi kwa yudya hena nkama namiye.” ");
INSERT INTO ziw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Niyo wadya weze wahalawe, Yesu akonga kuwagambila wantu mbuli zakwe Yohana, “Mwita kwe nyika kukaula mbwani? Lunyasi lukusingiswa ni mpeho? ");
INSERT INTO ziw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mna namfosa kukaula mbwani? Mntu availe suche ntana? Kaula, wantu wakuvala suche ntana we mwe nyumba za maseuta. ");
INSERT INTO ziw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mna mwita kusinya mbwani? Muwoni? Ni chindedi, mna yuno nikajinka ya muwoni. ");
INSERT INTO ziw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yuno nuyo awandike yano, ‘Kaula, miye namsigila mndima ywangu ho uso wako. Naidamanye isila yako yo kukulongwela.’ ");
INSERT INTO ziw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nawagambilani chindedi, mwenyu hanati kwelekwa mwana akutenda mkulu kujinka Yohana Mta kubatiza. Ivyo vili, yudya akutenda mdodo mo Useuta wa kwembingu, ni mkulu kujinka uyo. ");
INSERT INTO ziw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kukongela zuwa dya Yohana Mta kubatiza kubula vino haluse Useuta wa kwembingu welavyanya wenye, wantu wakuungisa wauhokela. ");
INSERT INTO ziw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwaviya uwoni uwo walongagwa ni wawoni wose ne Sigilizi ya Musa kubula mwe chipindi cha Yohana, ");
INSERT INTO ziw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","naho uneva mwaunga mzumile ulosi wawo, Yohana nuyo Eliya, ukwiza kwakwe kwawonagwa. ");
INSERT INTO ziw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mta magutwi eve! ");
INSERT INTO ziw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Haluse nani waliganye na mbwani wantu wa chino cheleko? Waligana na wana wakwikala kwedigwilo, wakuwetanga weyawe, wakagamba, ");
INSERT INTO ziw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Chiwachemelani wila wa nyinka, mna hamvinile! Chichema za ndilo, mna vyose hamwiile!’ ");
INSERT INTO ziw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Umo Yohana ezile, kafunga kuno hekunywa divai, chila yumwenga kagamba, ‘Ana mpepo!’ ");
INSERT INTO ziw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Umo Mwana ywa Mntu ezile, adya na kunywa, chila yumwenga agamba, ‘Mkauleni yuno mntu! Nimbafu naho ni mkozi, ni mbuya ywa wachisanya kodi na wata masa!’ Umanyi wa Chohile walagiswa kwa kuwoneka ywedi kwa ntendwa zakwe.” ");
INSERT INTO ziw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Wantu wa mwe mizi Yesu adamanyaga mpituko na vilagiso vilozize haweile masa yawo, ivyo Yesu kawakwahila wantu we mizi iyo. ");
INSERT INTO ziw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Nauluwone, weye mzi wa Kolazoni! Nauvimanye mwenye, Betisaida! Kwaviya mpituko zidamanywe mndani mwenyu zadamanywe uko Tilo na mo mzi wa Sidoni, wekazi wa uko nawavika majuniya na kwekuluguta maivu chikale, kulagisa kugamba weila masa yawo! ");
INSERT INTO ziw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nawagambilani chindedi, Chohile nawafilise mbazi wantu wa Tilo na Sidoni kujinka nyuwe mwe dizuwa dyo kukantilwa. ");
INSERT INTO ziw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Weye nawe Kapelinaumu, Togola! Naukaunga wekweze mwenye kwembingu? Naudulwe hasi kwe bome hedina uhelo! Hegu mpituko zidamanywe kwako zadamanywe uko Sodoma, umzi uwo naucheyaho kubula dyelo. ");
INSERT INTO ziw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Elo nawagambilani kugamba mwe dizuwa dyo kukantilwa weye naukantilwe kujinka wantu we Isi ya Sodoma!” ");
INSERT INTO ziw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mwe chipindi icho Yesu ahitula agamba, “Tate, Zumbe ywa kwembingu ne isi! Nakutogola kwaviya mbuli zino kuwafisa wata umanyi na fanyanyi, niyo wawagubwila wana hewena fanyanyi. ");
INSERT INTO ziw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Heye, Tate, kwaviya nivyo ungile navitendeke. ");
INSERT INTO ziw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tate kaninka vintu vyose. Hahali ammanyize Mwana, mna ni Tate uyodu, naho hahali ammanyize Tate, mna Mwana uyodu hamwenga na yoyose Mwana akumunga kumgubwila. ");
INSERT INTO ziw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Soni kwangu, nyuwe nyose msokele kwa kwinula mizigo izamile, naniwahumuzeni. ");
INSERT INTO ziw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kwenkeni moyo, mhine kwangu, kwaviya miye sihola, naho nimjijimizi wa moyo, nanywi na mbwede mwe myoyo yenyu. ");
INSERT INTO ziw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwaviya moyo wangu uhuha, na mzigo wangu hunga niwatwiseni uhuha.” ");
INSERT INTO ziw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Havikalise umo Yesu akajinka mwe zikonde zuwa dya kuhumula. Wanampina wakwe walumwa ni sala, wakonga kuhulula maiso ya ngano wadya. ");
INSERT INTO ziw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo weze wawone, wamgamba Yesu, “Kaula, wanampina wako wadamanya mbuli hezikungwa mwe zuwa dya Kuhumula!” ");
INSERT INTO ziw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu ahitula, “Hamsomile viya Daudi adamanye, umo endaga hamwenga na weyawe walumwagwa ni sala? ");
INSERT INTO ziw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Engilaga mwe nyumba nkulu ya Chohile, yeye hamwenga na weyawe niyo wadya imigate aikiwe Chohile, hata hegu havikungwa wowo kuidya, walavyantambiko awodu nawo wakungigwa wadye. ");
INSERT INTO ziw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Hegu hamsomile mwe Sigilizi Chohile amwinkile Musa, kugamba chila mwe Zuwa dya kuhumula walavyantambiko mwe Nyumba nkulu ya Chohile hawakudamanya viya vikungwa mwe Zuwa dya kuhumula, hawana masa? ");
INSERT INTO ziw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nawagambilani, kugamba hano hana chintu chikungiswa kujinka Nyumba nkulu ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Uneva hegu mwamanyize ulosi uno, ‘Naunga mbazi, siwo ntambiko,’ hamwawetange wadya hewena masa kugamba wana masa. ");
INSERT INTO ziw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwaviya Mwana Mntu nuyo Zumbe ywa Zuwa dya Kuhumula.” ");
INSERT INTO ziw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ahalawa hadya, niyo aita mwe nyumba yo kuvikila, ");
INSERT INTO ziw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","hendaga na mntu aholomale umkono. Nahana wantu wamwenga weyaho wakunga kumlaha Yesu kwa kudamanya vihiye, ivyo wamuza, “Mwe sigilizi yetu ni vyedi kumhonya mntu mwe Zuwa dya Kuhumula?” ");
INSERT INTO ziw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu ahitula, “Uneva yumwenga ywenyu ana ngoto ingile mwe bome Zuwa dya Kuhumula, hailavye mwe dibome? ");
INSERT INTO ziw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Togolani! Mntu ni ywedi kujinka ngoto! Nuko kugamba Sigilizi haikuchunga suwe kumwambiza mntu yoyose mwe zuwa dya kuhumula.” ");
INSERT INTO ziw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Niyo amgamba yudya mntu, “Chumiza umkono wako.” Auchumiza, watenda mjima naho saudya umtuhu. ");
INSERT INTO ziw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mna Mafalisayo niyo wafosa wakufunga njama wamkome Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Umo Yesu eze eve injama akufungilwa, akulawa uko, fyo kulu dya wantu dyamtimila. Awahonya woseni nendile ni wanyonje ");
INSERT INTO ziw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kawalemeza wase kumgambila mntu yoyose izimbuli zakwe. ");
INSERT INTO ziw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Katenda ivyo chani yadya Chohile alongaga kujinkila kwa muwoni Isaya yachinte. ");
INSERT INTO ziw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kaula mndima ywangu nimsagule, humungisa, naho nibwedile. Nanijele Muye wangu mwakwe, naho nalonge na wantu wose we isi kanto dyangu. ");
INSERT INTO ziw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Halafye hegu kuguta, naho hahali akunga eve izwi dyakwe mwe isila. ");
INSERT INTO ziw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Havune mwanzi uhindile, naho hakome taa ikufifiya. Naho abuze vikuwagila vilongoze, ");
INSERT INTO ziw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","naho wantu wose we isi nawamwikiye msuhi uyo.” ");
INSERT INTO ziw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Niyo wantu wamwenga wamwigaila Yesu mntu mta mpepo, tuntu, naho ni chimumu. Yesu kamhonya, ivyo yudya mntu niyo alonga na kusinya. ");
INSERT INTO ziw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wantu woseni wehelwa nakugamba, “Yuno suyo Mwana Daudi?” ");
INSERT INTO ziw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mna Mafalisayo weze weve, wagamba, “Yuno hakulavya mpepo, mna kwa nguvu zikulawana na Belizebuli, mkulu ywa mpepo!” ");
INSERT INTO ziw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu nakamanya viya wakufanyanya, awagamba, “Useuta wowose ukatowana wenye kwa wenye naugwe. Naho wekazi wa mzi wowose hegu wantu wa lukolo lwesimile wakatowana wenye lukolo ulo halwikalise. ");
INSERT INTO ziw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ivyo uneva fyo dimwenga dyatowana na tuhu mwe uzumbe wa Shetani, vino ni kugamaba wemalanya kale mwe mafyo naho haukawe kugwa! ");
INSERT INTO ziw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nyuwe mwagamba miye nalavya mpepo kwa udahi wa Belizebuli. Ni vyedi, haluse, wadya wakuwatimila nyuwe walavya mpepo kwa udahi wa yuhi? Kwaivyo, nawatende wakanti wenyu. ");
INSERT INTO ziw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mna uneva hegu miye nalavya mpepo kwa udahi wa Muye wa Chohile, ivyo Uzumbe wa Chohile uwezilani kale. ");
INSERT INTO ziw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Hahali akudaha kwingila mwe nyumba ya mntu mta nguvu nakumhoka vintu vyakwe, henati kumtaliza yudya mta izi nguvu, naho na adahe kwinula vintu vya uyo mntu. ");
INSERT INTO ziw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Yoyose hehamwenga na miye anihiga, yoyose hekunambiza kuchisanya, ichindedi amwaganisa. ");
INSERT INTO ziw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ivyo nawagambilani, wantu nawalekeilwe masa yoyose na wihi wowose wakunga wamlongele Chohile. Mna mntu akunga amhulute Muye wa Chohile halekeilwe masa yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yoyose akulonga dyodyose dya kuhiga Mwana Mntu adaha kulekeilwa masa, mna yoyose akulonga dikumhiga Muye Ukukile halekeilwe masa vino haluse na mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Chani utende na mti una matunda yedi, utende na mti wedi, mti wedi weleka matunda yedi, mti wamanyika kwa matunda yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nyuwe nyoka, mwadaha vivihi kulonga mbuli zedi, kuno mwiha? Kwaviya mnomo wa mntu walonga yadya yamemile mo moyo wakwe. ");
INSERT INTO ziw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mntu ywedi alavya mbuli zedi zikulawa mwe mpamba ya vintu vyedi, mntu aihiye alavya mbuli zihiye zikulawa mwe hazina ya mbuli zihiye. ");
INSERT INTO ziw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nawagambilani, mwe dizuwa dyo kukantilwa chila yumwenga naungwe alonge chila ulosi wihiye alongile. ");
INSERT INTO ziw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ulosi wako naukukantile kugamba wi wedi hegu kwiha.” ");
INSERT INTO ziw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Niyo wahinya Sigilizi wamwenga na Mafalisayo wamwenga walonga. Wagamba, “Mhinyi, chaunga chiwone mpituko ukudamanya.” ");
INSERT INTO ziw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu ahitula, Wantu wa mazuwa yano wana wihi wi vivihi naho hawammanyize Chohile! Mwanunga mpituko miye? Mpituko iyodu mkunga mlagiswe ni mpituko ya muwoni Yona. ");
INSERT INTO ziw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Saviya Yona endile mndani mwe inda ya samaki nkulu vidala ekale mazuwa matatu, ivyo nivyo Mwana Mntu nekale mo umoyo we isi mazuwa matatu. ");
INSERT INTO ziw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mwe dizuwa dya kukantilwa wantu wa mzi wa Ninawi nawachimale nakuwalaha, kwaviya weila masa yawo umo Yona alongaga, naho nawagambilani hano mna mntu mkulu kumjinka Yona! ");
INSERT INTO ziw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mwe dizuwa dya kukantilwa Malikiya ywa Sheba naachimale kuwalahani, kwaviya atambaga ntendele zoseni ze isi yakwe kwetegeleza mahinyo ya umanyi ya Zumbe Sulemani, naho nawagambilani kugamba hano hana chintu chikulu kumjinka Sulemani! ");
INSERT INTO ziw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Umo mpepo nchafu ikamlawa mntu, yatamba mwe si nkavu ikazungula hantu hakuhemela, uneva haina wone, ");
INSERT INTO ziw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yegamba yenye, ‘Nanuye kwe nyumba yangu nilaile.’ Akabula ibwila inyumba ibule, ihagilwa, naho ikwa untanda. ");
INSERT INTO ziw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Niyo yaita kwe kuguha mpepo weyawe watuhu mfungate wadya weihise kuijinka yoyo, zengila na kwikala umo, mntu uyo ivyo neli vyatenda vihise kujinka hadya nkongo. Nivyo navilaile mwe wantu wehiye wa dyelo.” ");
INSERT INTO ziw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu na achei akalonga neidifyo umo mami yakwe na walukolo wakwe nendile wachimala kuse, wakaunga watamwile naye. ");
INSERT INTO ziw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mntu yumwenga amgamba, “Kaula, mami yako na walukolo wako wachimala kuse, waunga walonge na weye.” ");
INSERT INTO ziw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu ahitula, “Mnala ni yuhi? Na walukolo wangu ni wahi?” ");
INSERT INTO ziw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Adosa kwa wanampina wakwe, agamba, “Kaulani, wano nawo mnala na walukolo wangu! ");
INSERT INTO ziw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yoyose natende saviya Tate kwembingu akunga, uyo nuyo mlukolo ywangu, na lumbu dyangu, na mnala.” ");
INSERT INTO ziw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mwe dizuwa idyo, Yesu niyo alaila kuse kwe idya nyumba, aita akwikala hankanda hediziwa niyo akonga kuhinya. ");
INSERT INTO ziw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wantu niyo wamemelana vidala mo mdugano, akwela mwe ngalawa, ekala, fyo dyachimala mnkanda mwe diziwa. ");
INSERT INTO ziw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu alonga mbuli zilozize kwa miliganyo. “Tegelezani, mhandi kaita kwe kuhanda mbeyu. ");
INSERT INTO ziw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ahadya akahanda, mbeyu ntuhu niyo zagwela mwe sila, niyo zadigwa ni wadege. ");
INSERT INTO ziw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ntuhu niyo zagwela mwa mayuwe hana ulongo mjeche, aho niyo zahota, kwaviya ulongo nani mjeche, ");
INSERT INTO ziw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mna ahadya zuwa dize dyake niyo zahya, kwaviya hazina maizi zinyuluka. ");
INSERT INTO ziw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ntuhu niyo zagwela mwe miwa, niyo zahota mna zifintwa ni miwa zinyuluka. ");
INSERT INTO ziw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ntuhu zigwela mwe ulongo wedi, zeleka, zimwenga gana, zimwenga milongo mtandatu zimwenga milongo mitatu.” ");
INSERT INTO ziw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu akomeleza, “Mta magutwi neeve!” ");
INSERT INTO ziw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Weza wanampina kwa Yesu, wamuza, “Nimbwani ukulonga kwa miliganyo?” ");
INSERT INTO ziw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu ahitula, Nyuwe mgubwilwa kumanya chinyele cho Useuta wa kwembingu, mna wowo hawavimanyize. ");
INSERT INTO ziw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kwaviya mntu mta chintu nongezezwe, mna mntu hena chintu nahokwe hata chiya ananacho. ");
INSERT INTO ziw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nivyo vikuleka nalonga kwa miliganyo kwaviya wasinya, mna hawakwiva hegu kumanya. ");
INSERT INTO ziw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ulosi uchinta kwawo ulongigwe ni muwoni Isaya ukugamba, kwiva namwive, mna hammanye, kusinya na msinye, mna hamwone, ");
INSERT INTO ziw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","kwaviya fanyanyi zawo sizo zedi, na magutwi yawo haya kwiva vyedi, wafinya ngohe meso yawo, wanase kusinya na meso yawo, wakeva na magutwi yawo, wakamanya mwe myoyo yawo, waka kombolwa, niyo Chohile agamba, nani wahonye. ");
INSERT INTO ziw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Mna nyuwe mjimbikwa! Meso yenyu yawona, na magutwi yenyu yeva. ");
INSERT INTO ziw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nawagambilani chindedi, wawoni walozize na wantu wawoneke wedi kulongozi kwa Chohile nawaungisa wawone yano mkuwona nyuwe, mna hawawone, na kwiva mbuli mkwiva, mna hawevile.” ");
INSERT INTO ziw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nyuwe tegelezani naho mhine mliganyo wo mhandi. ");
INSERT INTO ziw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wadya wakwiva mbuli yo Useuta wa Chohile mna hawakukombaganya vikaheza yudya Mwavu eza na kuzipempula izimbeyu zihandigwe mwe myoyo yawo. ");
INSERT INTO ziw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbeyu zigwele mwe miwa, uyo ni yudya akwetegeleza mbuli, aihokela kwa chinyemi. ");
INSERT INTO ziw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mna haikwika maizi mndani mwakwe, ivyo chipindi chijeche, hadya akulailwa ni masulumizo fanyanyi za mhituka kwa idya imbuli, aho agwa. ");
INSERT INTO ziw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Idya ihandigwe mwe miwa, uyo ni yudya akwiva mbuli, na mbuli za mwe isi zamfinta, kunga ugoli kwa ifinta idya imbuli, nayo yatenda haikweleka. ");
INSERT INTO ziw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mbeyu ihandigwe mwe ulongo wedi, uyo ni yudya akwetegeleza idya imbuli, nakumanya ivyo vikungwa, uyo nuyo akweleka, yuno gana, na yuno milongo mtandatu yuno naye milongo mitatu.” ");
INSERT INTO ziw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu awagambila mliganyo mtuhu, “Useuta wa kwembingu wi savino. Mntu ahandile mbeyu yedi mwe nkonde yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mna nechilo wantu wagonile, eza mnkondo, ahanda ndago mgati mwe ngano niyo ahalawa. ");
INSERT INTO ziw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Umo indago ne ngano ize ibule haguhi na kweleka, mwa woneka mna ndago. ");
INSERT INTO ziw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Wandima wakwe wambasa, wamgamba, ‘Zumbe, huhandile mbeyu yedi mwe nkonde yako? Yalawa nahi idya indago?’ ");
INSERT INTO ziw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Awahitula, ‘Mnkondo nuyo atendile ivyo,’ wandima wamuza, ‘Waunga chite chikaing'ole?’ ");
INSERT INTO ziw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Awagamba, ‘Bule,’ Mnase kwing'ola indago kwaviya mwadaha mng'ole hamwenga ne ngano. ");
INSERT INTO ziw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lekani vikule hamwenga kubula mo kuvuna. Aho naniwagambile wata kuvuna, ‘Kongani kuchisanya indago, mwike machisa mkayoke. Mna ingano ichisanyeni mkaike kwe digulu dyangu.’ ” ");
INSERT INTO ziw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Awagambila mliganyo mtuhu. Useuta wa kwembingu wisavino. Mntu yumwenga kaguha mpuluzi ya kabeyu kadodo kakwitangwa haladali niyo akuhanda mwe nkonde yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ni kadodo kujinka mbeyu zose, mna aho kakukwila katenda mti mkulu kujinka miti yose hata wadege wa koulanga weza wazenga masasa mwa matambi yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu alonga mliganyo mtuhu, “Useuta wa kwembingu wikala saviya hamila akuguha mvyele, aijela mwe vibaba vitatu vya unga, niyo wagwaduka wose.” ");
INSERT INTO ziw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu kawagambila kwa miliganyo, halongile dyodyose akaleka kujela mliganyo. ");
INSERT INTO ziw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Katenda ivyo chani ichinte mbuli ilongigwe ni muwoni, akagamba, “Nanilonge kwa kujela miliganyo, nani wagambile yadya yefisigwe kukongela kuumbwa kwe isi.” ");
INSERT INTO ziw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Niyo Yesu alaga idifyo, engila mwe nyumba. Wanampina wakwe wamtimila, wamgamba, “Chevilikize umliganyo wo lugugu lwi kwe nkonde.” ");
INSERT INTO ziw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu awahitula, agamba, “Mhandi wa ziya izimbeyu zedi ni Mwana ywa Mntu, ");
INSERT INTO ziw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","nkonde ni isi, mbeyu zedi ni wana wa Useuta, idya indago ni wana wa yudya Mwavu, ");
INSERT INTO ziw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","yudya mnkondo ahandile ni Mwavu, ulozo ni udumo we isi na wadya wakuvuna ni wandima wa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Saviya ndago ikuchisanywa na kokwa mo moto, nivyo na vilaile mwe dizuwa dyo udumo we isi. ");
INSERT INTO ziw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana ywa Mntu nawegale wandima wa kwembingu wakwe, nawo nawachisanye kulaila mo Useuta wakwe wantu woseni wakuwakoza masa, na wadya woseni wakudamanya ubanasi. ");
INSERT INTO ziw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kuwadula mwe tanuli dyo moto, nuko nakutende na ndilo nakusiginta meno. ");
INSERT INTO ziw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Naho wadya na wawoneke wedi kulongozi kwa Chohile nawang'ale saviya zuwa mo Useuta wa Tati ywawo. Mta magutwi neeve! ");
INSERT INTO ziw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Useuta wa kwembingu uligana na ugoli ufisigwe mwe nkonde imwenga. Mntu yumwenga eze aubunkule, kaufisa vituhu, kwa chinyemi chikulu niyo aita kutaga vintu vyakwe vyose, na kugula inkonde idya. ");
INSERT INTO ziw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Naho Useuta wa kwembingu uligana mta yombe, akulonda lulu ntana. ");
INSERT INTO ziw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hadya akupatila lulu ntana inayombe kulu, aita akutaga vyose ananavyo, na kuigula. ");
INSERT INTO ziw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Naho Useuta wa kwembingu uligana na lwavu, luduligwe mwe bahali, lwa chisanya samaki zesimile. ");
INSERT INTO ziw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hadya lukumemela lwakweswa kuse, wekalahasi, wachisanya ziya izedi wazijela mwe viya, mna ziya zihiye wazidula. ");
INSERT INTO ziw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nivyo navitende mo udumo we isi, wandima wa kwembingu nawalaile nawawapagule waihiye hale na wata kuwoneka wedi, ");
INSERT INTO ziw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kuwadula mwe tanuli dyo moto. Nuko nakutende na ndilo na kusiginta meno.” ");
INSERT INTO ziw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu niyo awauza, “Myamanya yose ayo?” Wamgamba. “Heye,” ");
INSERT INTO ziw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Akaheza awagamba, “Elo, chila mhinya wa Sigilizi ahinyigwe mo Useuta wa kwembingu, aligana na mntu mta nyumba akulavya vintu vihya na vyakale hamwenga kulaila mwe mpamba yakwe.” ");
INSERT INTO ziw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu eze abinde kulonga miliganyo iyo, niyo ahalawa hadya, ");
INSERT INTO ziw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","auya kwe kaya yakwe. Ahinya mwe nyumba yo kuvikila, wantu wose wehelwa niyo wauza, “Yuno kaupatahi umanyi uno na mpituko zino? ");
INSERT INTO ziw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yuno suyo yudya mwana ywa msongola? Mami yakwe suyo yudya akwitangwa Maliyamu? Naho walukolo wakwe sawo Yakobo na Yusufu na Simoni na Yuda? ");
INSERT INTO ziw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Naho walumbu zakwe wose hawahali hano hetu?” ");
INSERT INTO ziw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ivyo wamlemela. Yesu awagamba, “Muwoni atunywa chila hantu, mna siyo mwe isi yakwe, na kukaya kwakwe mwenye.” ");
INSERT INTO ziw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kwaviya hawamzumile, hadamanye mpituko zilozize uko. ");
INSERT INTO ziw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mazuwa ayo, Helode Zumbe ywa Galilaya evaga mbuli za Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Awagamba wandima wakwe “Yuno nuyo Yohana Mta kubatiza, kauyuka! Nivyo vikuleka ana udahi uno wa kudamanya mpituko.” ");
INSERT INTO ziw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Helode nakaunga Yohana agwilwe, amtaliza minyolo nakumjela mwe dijeleza. Adamanyaga ivyo kwachausa cha Helodiya, mkaza Filipo mlukolo ywakwe. ");
INSERT INTO ziw_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwaviya Yohana Mta kubatiza amgambaga Helode, “Haviwagile weye umsole Helodiya.” ");
INSERT INTO ziw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode nakaunga amkome Yohana, mna na kawogoha Wayahudi, kwaviya nawamwona kugamba ni muwoni. ");
INSERT INTO ziw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mwe ngasu ya kukumbuka zuwa elekwe Helode, mwana chindele ywa Helodiya avinaga mwa meso ye difyo jima dya wantu. Helode vimwelelesa ");
INSERT INTO ziw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","vilekile alagane kugamba, “Nahwinke chochose naulombeze!” ");
INSERT INTO ziw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Akalongozwa ni mami yakwe mwe viya akunga amlombeze akagamba, “Ninka vino haluse mtwi wa Yohana Mta kubatiza mwe chihungu!” ");
INSERT INTO ziw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Seuta niyo atozwa ni chinyulu, mna kwaviya naka lagana mwa meso ya wajeni wakwe woseni, alagisa viya umndele alombeze enkigwe. ");
INSERT INTO ziw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ivyo asigila Yohana amdumulwe umtwi umo emwe dijeleza. ");
INSERT INTO ziw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mtwi wegalwa mwe chihungu, enkigwa yudya mndele, amwigaila nine. ");
INSERT INTO ziw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wanampina wa Yohana wabula niyo waguha umwili wa Yohana nakuuhamba. Weze wajike waita kumgambila Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu eze eve imbuli iyo, kakulawa uko mwe ngalawa, aita hantu hechedu hehena wantu. Fyo dya wantu weze weve, wamtimila lwaviga kulaila mwe mizi. ");
INSERT INTO ziw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu eze asele mwe ngalawa, awona fyo kulu dya wantu awafila mbazi na kuwahonya wanyonje wawo. ");
INSERT INTO ziw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Chisingi chize chingile, wanampina wakwe wambasa, wagamba, “Hano ni holuwala, na saa nayo ijinkisa. Laga idifyo waite kwe zikaya zawo, wakegwile nkande zawo.” ");
INSERT INTO ziw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu ahitula, “Wasekwita, wenkeni nyuwe nkande.” ");
INSERT INTO ziw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wamhitula, “China migate mishano na samaki mbili.” ");
INSERT INTO ziw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu agamba, “Nigailani hano.” ");
INSERT INTO ziw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Adyunga idifyo dikale mwa mani, aguha idya imigate mishano na ziya izisamaki izimbili. Asinya kulanga kwembingu, ajimbika, aibesula idya migate, awenka wanampina, wanampina wawenka awantu. ");
INSERT INTO ziw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Chila yumwenga kadya niyo eguta. Niyo walogota vibesu vya migate vigwele hasi, wamemeza ntangulu mlongo na mbili. ");
INSERT INTO ziw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wadya wadile na ni wagosi wakubula magana milongo mishano, ukaleka wavyele na wana. ");
INSERT INTO ziw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu niyo awagamba wanampina wakwe wakwele mwe ngalawa wamlongwele waite ntendele ya kaidi yediziwa, kuno akalaga idifyo. ");
INSERT INTO ziw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Eze abinde kulaga idifyo, akwela kolugulu ichedu, akamlombeze Chohile. Umo chisingi chibwile, Yesu neeyuko ichedu, ");
INSERT INTO ziw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","mwe chipindi chino ingalawa neibula hale mwe isi nkavu, yajubwaniswa na mazi kwaviya nakuna nkungunto nkulu. ");
INSERT INTO ziw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mgati mwe saa chenda na saa mlongo na midi chilochilo Yesu awabasa wanampina akajenda mlanga mwa mazi. ");
INSERT INTO ziw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wanampina weze wamwone akajenda mlanga mwa mazi, wengilwa ni nkama, wakagamba, “Ni chizuli!” Niyo waguta kwa nkama. ");
INSERT INTO ziw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mna aho Yesu awagamba, “Kwenkeni moyo, ni miye. Msekogoha!” ");
INSERT INTO ziw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petulo ahitula. “Zumbe, uneva chidedi ni weye, nigamba nize kwako hajenda mlanga mwa mazi.” ");
INSERT INTO ziw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu amhitula, “So!” Petulo niyo asela mwe ngalawa, akonga kujenda mlanga mwa mazi ambasa Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mna eze awone idya inkung'unto, ogoha, akonga kudidimila. Aguta akagamba, “Zumbe, nikombola!” ");
INSERT INTO ziw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aho Yesu achumiza umkono wakwe, amtoza akamgamba, “Weye mta uzumizi mjeche! Nimbwani una nkama?” ");
INSERT INTO ziw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Weze wakwele mwe ngalawa, nkungunto niyo yatondowala. ");
INSERT INTO ziw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wadya wendile mwe ngalawa wamfikila madi Yesu, wakagamba, “Chindedi weye wi mwana Chohile.” ");
INSERT INTO ziw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Weze wabule ntendele ya kaidi yediziwa, wabula mwe isi ya Genesaleti. ");
INSERT INTO ziw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wantu wahadya weze wambunkule kugamba ni Yesu niyo wasigila ulosi kwa wantu we izisi zose zimnkanda. Wantu wamwigaila wanyonje wawo wose, ");
INSERT INTO ziw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","wamwila wadonte hata idilepe dye suche yakwe du, woseni wadontile wahonywa. ");
INSERT INTO ziw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mafalisayo na wahinyi wa Sigilizi walaile Yelusalemu wambasa Yesu nakumuza, ");
INSERT INTO ziw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nimbwani wanampina wako wakubalanga miko ya wadalahala? Hawa kuhaka imikono yawo viya vikungwa hewenati kudya!” ");
INSERT INTO ziw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu ahitula, “Nimbwani mkuleka sigilizi ya Chohile mkutimila mahinyo yenyu wenye? ");
INSERT INTO ziw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwaviya Chohile agambaga, ‘Mtunye tati yako na mami yako, mntu akunga amligite tati yakwe hegu mami yakwe na akomwe.’ ");
INSERT INTO ziw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mna mwahinya kugamba uneva mntu ana chintu chikudaha kumwambiza tati yakwe hegu mami yakwe, mna mwagamba achilavye, ‘Chino ni cha Chohile,’ ");
INSERT INTO ziw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","vyaleka asekumtunya tati yakwe. Mwe vino mwabela sigilizi ya Chohile, vileka mtimile mahinyo yenyu. ");
INSERT INTO ziw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nyuwe wasongaganyi! Isaya nani mchindedi umo awonaga yedi mwenyu! ");
INSERT INTO ziw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Chohile agamba, wantu wano wanitunya kwa milomo yawo, mna myoyo yawo ihale na miye. ");
INSERT INTO ziw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wanivikila vya bule, kwaviya wahinya mahinyo ya malagiso ya chimntu mntu saviya ni sigilizi zangu!’ ” ");
INSERT INTO ziw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu niyo aditanga idifyo, awagamba, “Tegelezani naho mkombaganye! ");
INSERT INTO ziw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chikwingila mwe mnomo wamntu hachikumtenda mzavu, mna chikumlawa nicho chikumtenda mzavu.” ");
INSERT INTO ziw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Niyo wanampina wakwe wambasa, wakagamba, “Kuvimanya kugamba Mafalisayo wehiwa mwe viya ulongile?” ");
INSERT INTO ziw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu ahitula, “Chila mti hewihandigwe ni Tati yangu wa kwembingu naung'olwe,” ");
INSERT INTO ziw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Walekeni! Awo ni vilongozi mantuntu, tuntu akamlongwela tuntu mnyawe, woseni waidi nawapolomele mwe bome.” ");
INSERT INTO ziw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petulo amgamba, “Chilavyanyize umliganyo uwo.” ");
INSERT INTO ziw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu awagamba, “Vino nanywi mwichei hamkuvimanya kujinka watuhu. ");
INSERT INTO ziw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Hamvimanyize? Chikwingila ko mnomo chajinkila kweinda, chafoseza kuse kulaila mo mwili kwita kwe choo. ");
INSERT INTO ziw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mna vikulaila mo mnomo vyalaila ko moyo, navyo nivyo vikumtenda mzavu. ");
INSERT INTO ziw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwaviya ko moyo kwalaila fanyanyi zihiye, ukomi na ugonyi na chilanga na ubavi, mbuli za lulimi, na mahuluto. ");
INSERT INTO ziw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yano nayo yakumtenda mntu helenguke. Mna kudya hwihakile mikono yako saviya wakulonga mdamanye ivyo, havikumtenda mntu atende mzavu.” ");
INSERT INTO ziw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu akulawa uko, aita kwe mkowa hajihi na mizi ya Tilo na Sidoni. ");
INSERT INTO ziw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mvyele yumwenga Mkanani na akekala mwe ntendele iyo kambasa. Akang'ung'uzika akagamba, “Zumbe, Mwana ywa Daudi! Nifila mbazi! Mndele ywangu ana mpepo naho ivyo eli sivyo vyedi.” ");
INSERT INTO ziw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mna Yesu hamhitule dyodyose. Wanampina wakwe wambasa, wamlombeza, wakagamba, “Mleke aite! Achitimila naho achitwila lwasu!” ");
INSERT INTO ziw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu ahitula, “Sisigilwa kwe ngoto zagile za wantu wa nyumba ya Izulaeli iyodu.” ");
INSERT INTO ziw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mvyele uyo ambwila niyo amfikila madi. Agamba, “Zumbe nambiza.” ");
INSERT INTO ziw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu ahitula, “Sivyo vyedi kuguha nkande ya wana niyo waduila mbwa.” ");
INSERT INTO ziw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yudya mvyele ahitula, “Icho ni chindedi Zumbe, mna hata mbwa nazo zadya masigalo yagwele mwe zimeza za maseuta yawo.” ");
INSERT INTO ziw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ivyo Yesu amhitula, “Wi mvyele mta uzumizi mkulu! Viya ukunga navidamanyike kwako.” Aho mndele ywakwe niyo ahona. ");
INSERT INTO ziw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu niyo akulawa uko, abula mnkanda mwe diziwa dya Galilaya. Akwela ko lugulu na kwikala uko. ");
INSERT INTO ziw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Fyo kulu dya wantu dyambasa, dyamwigaila waholomale, mantuntu, vimumu, na watuhu walozize, wawaika heviga vya Yesu, niyo awahonya. ");
INSERT INTO ziw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wantu wehelwa weze wawone vimumu walonga, waholomale wajenda, mantuntu wawona. Naho wamtunya Chohile ywa Izulaeli. ");
INSERT INTO ziw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu niyo awetanga wanampina wakwe, nakuwagamba, “Nawafila mbazi wantu wano, kwaviya watenda na miye kwa mazuwa matatu naho haluse hawana cha kudya. Sikuvyunga waite siwalisize, sima wanagwe mteho mwe sila.” ");
INSERT INTO ziw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wanampina wamuza, “Nachilavye kuhi nkande ikuchinta kulisa idifyo dino mo uluwala luno?” ");
INSERT INTO ziw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu auza, “Mna migate mingahi?” Wahitula, “Mfungate na samaki njeche.” ");
INSERT INTO ziw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ivyo Yesu adyunga idifyo wekale hasi. ");
INSERT INTO ziw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Niyo aguha idya migate mfungate na ziya zisamaki, amhongeza Chohile, abesula, niyo awenka wanampina, wanampina nawo wawenka awantu. ");
INSERT INTO ziw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Woseni wadya niyo weguta. Niyo wanampina walogota vibesulo vya migate vigwele hasi wamemeza ngahu mfungate. ");
INSERT INTO ziw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wantu wadile wabula magana mlongo milongo mine ya wagosi, ukaleka wavyele na wana. ");
INSERT INTO ziw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Niyo Yesu alaga idifyo, akwela ingalawa, aita ko mkowa wa Magadani. ");
INSERT INTO ziw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo na Masadukayo wambasa Yesu waunga wamtoze, nivyo wamlombeza awalagise chilagiso kulanga kugamba kazumilwa ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mna Yesu ahitula, “Dikaswa, mwagamba, ‘Nakutende kwedi kwaviya ulanga winkundu.’ ");
INSERT INTO ziw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nomtondo, mwagamba, ‘Dyelo nakutende na fula kwaviya ulanga winkundu naho nimtitu.’ Mwadaha kulongwela viya nakutende kwa kusinya ulanga, mna hamkudaha kubunkula vilagiso vikujenda ne vipindi vino! ");
INSERT INTO ziw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wantu wehiye naho hewemmanyize Chohile we vivihi! Mwaunga chilagiso? Chilagiso ichodu mkungwa mwinkwe ukaleka chiya cha Yona.” Ivyo awasa niyo aita. ");
INSERT INTO ziw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Umo wanampina weze wadeluke ntendele ya kaidi yediziwa, nawajala kuguha nkande yoyose. ");
INSERT INTO ziw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu awagamba, “Kaulani, mwedime na ugwadu wa Mafalisayo na Masadukayo.” ");
INSERT INTO ziw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Niyo wakonga kulafya wenye kwa wenye, “Alonga vino kwaviya hachigale mgate wowose.” ");
INSERT INTO ziw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu niyo abunkula viya nawakalafya, ivyo awauza, “Nimbwani mkulafya wenye kwa wenye mwe mbuli ya kuswesa mgate wowose? Uzumizi mjeche wi vivihi mnanawo! ");
INSERT INTO ziw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mchei kumanya? Hamkukumbuka viya nabesulaga imigate imishano kwa wantu magana milongo mishano? Nammemeza ntangulu nyingahi mlogote? ");
INSERT INTO ziw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Naho idya imigate mfungate kwa wantu magana milongomine? Ni ngahu nyingahi mmemeze? ");
INSERT INTO ziw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nimbwani hamkukombaganya kugamba siwagambilani kwa chausa cha migate? Mwedime na ugwadu wa Mafalisayo na Masadukayo.” ");
INSERT INTO ziw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Naho wabunkwile kugamba hawagambile wedime na ugwadu wa kudamanyiza migate, mna mahinyo ya Mafalisayo na Masadukayo. ");
INSERT INTO ziw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu aitaga kwe mkowa wi hajihi na mzi wa Kaisaliya Filipi, uko awauzize wanampina wakwe akagamba, “Wantu wamtamwila vivihi Mwana ywa Mntu?” ");
INSERT INTO ziw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wagamba, “Watuhu wamgamba ni Yohana Mta kubatiza, watuhu Eliya, watuhu Yelemiya hegu yumwenga ywa wawoni.” ");
INSERT INTO ziw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Auza, “Nyuwe mwanigamba ni yuhi?” ");
INSERT INTO ziw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petulo ahitula, “Weye wi Kulisito, Mwana ywa Chohile mta ujima.” ");
INSERT INTO ziw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu ahitula, “Chinyemi chako weye Simoni mwana ywa Yona, kwaviya ichindedi chino hachizile kwako kulaila kwa mntu yoyose, mna kuchinkwa ni Tate ywa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ivyo nakugambila, Petulo, wi luwe, naho mlanga mo luwe luno nanizenge nyumba ya kuvikila, hata bome hedina uhelo hadidahe. ");
INSERT INTO ziw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nahwinke nkomwelo yo Useuta wa kwembingu, icho nauvugale mwe isi nachivugalwe kwe mbingu, icho nouvugule mwe isi nachivugulwe kwembingu.” ");
INSERT INTO ziw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Niyo Yesu awalemeza wanampina wakwe wase kumgambila mntu yoyose kugamba nuyo Kulisito Mkombola. ");
INSERT INTO ziw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kukongela aho na kujendeleza Yesu kakonga kulonga pwilili kwa wanampina wakwe, akagamba “Naungwa nite Yelusalemu hasulumizizwe ni wadalahala, wakulu wa walavyantambiko, na wahinya Sigilizi. Nanikomwe, mna mazuwa matatu yakutimila naniuyuke.” ");
INSERT INTO ziw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petulo amguha hankanda, akonga kumkwahila. Agamba “Bule, Zumbe, ivyo havikulaile!” ");
INSERT INTO ziw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu ahituka na kumgamba Petulo, “Uya kunyuma kwangu, Shetani! Wi chifingo kwangu, kwaviya hukufanyanya ya Chohile, mna ya wantu.” ");
INSERT INTO ziw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Niyo Yesu awagamba wanampina wakwe, “Mntu yoyose akunga anitimile, ne elemele mwenye, etwike msalaba wakwe, anitimile. ");
INSERT INTO ziw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwaviya mntu akunga kwambula untu wakwe, na awaze, na mntu akunga aze ujima wakwe kwa chausa changu, nauwone. ");
INSERT INTO ziw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mntu na ahokele chibwani akapata isi yose, na kwaza ujima wakwe? Hegu mntu nalavye mbwani akaleka ujima wakwe? ");
INSERT INTO ziw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwaviya Mwana ywa Mntu neze no ukulu wa Tati yakwe hamwenga na wandima wa kwembingu wakwe naho namlihe chila mntu kulawana na viya atendile. ");
INSERT INTO ziw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nawagambilani chindedi, hana wantu mgati mwa wano wachimale hano, hawabanike, kubula wamwone Mwana ywa Mntu akeza no Uzumbe.” ");
INSERT INTO ziw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yeze yomboke mazuwa mtandatu, Yesu awaguhaga Petulo na Yakobo na Yohana mlukolo ywa Yakobo aita nawo kolugulu lutali hantu nawechedu. ");
INSERT INTO ziw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Uko kahitukila isula yakwe mwa meso yawo, uso wakwe ung'ala saviya zuwa, suche zakwe zing'ala saviya ulangazi. ");
INSERT INTO ziw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Niyo wanampina watatu wamwona Musa na Eliya wakatamwila na Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petulo amgamba Yesu, “Zumbe, ni vitana suwe chikatenda hano. Ukaunga, nanizenge mahema matatu, dyako, dya Musa, na idimwenga dya Eliya.” ");
INSERT INTO ziw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Umo achei akalonga, ingu ding'aile dyawagubika, izwi dyalawa mdya mwe diya idingu, dyagamba, “Yuno nuyo Mwanangu akuniwagia hungisa. Mwetegelezeni!” ");
INSERT INTO ziw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wanampina weze weve diya idizwi, niyo wagwa chifudifudi, wogohesa. ");
INSERT INTO ziw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu eza, awadonta, awagamba, “Inukani, msekogoha.” ");
INSERT INTO ziw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Weze wagubule ameso yawo, hawawone mntu mna Yesu ichedu. ");
INSERT INTO ziw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Umo wakasela kulaila kolugulu, Yesu awasigila, agamba, “Msekumgambila mntu yoyose imbuli muwone, kubula aho akwizila Mwana ywa Mntu, hadya nauyukile.” ");
INSERT INTO ziw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wanampina wamuza, wagamba, “Nimbwani wahinya Sigilizi walonga kugamba, Eliya nuyo wa nkongo kwiza?” ");
INSERT INTO ziw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu ahitula, “Chindedi Eliya nuyo wa nkongo kwiza, uyo naike vyedi chila chintu. ");
INSERT INTO ziw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mna nawagambilani kugamba, Eliya keza kale, hawambunkule, wamdamanya yadya yoseni waungile. Mwe ivyo Mwana ywa Mntu nawamdamanya vihiye.” ");
INSERT INTO ziw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Niyo wanampina wabunkula kugamba nakalonga nawo mbuli za Yohana Mta kubatiza. ");
INSERT INTO ziw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Weze wabule he idifyo, mntu yumwenga amsogeila Yesu nakumfikila madi. ");
INSERT INTO ziw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Agamba “Zumbe, mfile mbazi mwanangu wa chilume! Agwa msango naho asulumizwa vihiye vikuleka nkanana zilozize agwela mwe moto hegu mwe mazi. ");
INSERT INTO ziw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Namwigalaga kwa wanampina wako, mna wadunduga kumhonya.” ");
INSERT INTO ziw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu ahitula, “Nyuwe cheleko hemkuzumila naho hemwimanyize! Nanikale na nyuwe vibule ini? Nigailani umbwanga uyo.” ");
INSERT INTO ziw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu aikwahila idya impepo, nayo yamlawa yudya mbwanga, kukongela aho kahona. ");
INSERT INTO ziw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Niyo wanampina wambasa Yesu kwa hankanda echedu, wamuza, “Nimbwani suwe chidunduga kuilavya idya impepo?” ");
INSERT INTO ziw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu ahitula, “Kwaviya mhungukilwa nu uzumizi. Nawagambilani chindedi, uneva mnatenda na uzumizi mdodo saviya mpuluzi ikwitangwa haladali, mwadaha kulugamba ulugulu luno, ‘Halawe hano wite kudya!’ Nalo na luhalawe. Hakutendeke na mbuli haikudahika mwenyu.” ");
INSERT INTO ziw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mna kwa malombezo na kufunga nuko kukudaha kudamanya vino, hachihali chituhu chikuvidaha. ");
INSERT INTO ziw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Umo wanampina weze wadugane wose uko Galilaya, Yesu awagamba, “Mwana ywa Mntu ehajihi nakwinkizwa mwe mikono ya wantu. ");
INSERT INTO ziw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nawamkome, mna mazuwa matatu yakutimila na uyuke.” Wanampina wengilwa ni chinyulu vidala. ");
INSERT INTO ziw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Umo Yesu na wanampina wakwe weze wabule Kapelinaumu, wachisanya kodi ya nyumba nkulu ya Chohile wambasa Petulo nakumuza, “Togola! Mhinyi ywenyu alavya kodi ya Nyumba ya Chohile?” ");
INSERT INTO ziw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petulo ahitula, “Chindedi, alavya.” Petulo eze engile kwe nyumba, Yesu akonga kulonga, agamba, “Wagaze, Simoni? Ni yuhi akuliha makanto hegu kodi kwa maseuta we isi ino? Wakaya we isi hegu wajeni?” ");
INSERT INTO ziw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petulo ahitula, “Wajeni.” Yesu ahitula, ni vyedi, “Nikugamba wakaya hawakuliha kodi. ");
INSERT INTO ziw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mna sivyo vyedi kuwaihiza wantu wano. Elo hitani kwe diziwa mkadule ndwano mwa mazi. Samaki ya nkongo no gwize, ugubule mlomo wakwe, na ubwile tundu dya hela dikuchinta kulihila kodi yetu suwe waidi.” ");
INSERT INTO ziw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chipindi icho wanampina wambasa Yesu wamuza, “Niyuhi mkulu atendese mo Useuta wa kwembingu?” ");
INSERT INTO ziw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ivyo Yesu etanga mwana, amchimalisa mwameso yao, ");
INSERT INTO ziw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nakugamba, “Nawagambilani chindedi, uneva hamnahituke na kutenda saviya wana, hamwingile mo Useuta wa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Akulise mo Useuta wa kwembingu ni yudya akweseleza niyo ekala saviya yuno mwana. ");
INSERT INTO ziw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Naho mntu yoyose akumhokela mwana yumwenga sa yuno kwa zina dyangu, anihokela miye. ");
INSERT INTO ziw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Wantu waidi wakusaga mpuluzi na yuwe kulu dya kusagila, uneva yoyose namhose yumwenga mwa wana wadodo wano aleke kunizumila, navitende vitana mntu uyo atalizwe mwe singo yuwe kulu dya kusagila, niyo adidimizwa hasi mwe bahali. ");
INSERT INTO ziw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nawaluwone wantu we isi ino vifingo vikuwatenda wantu waleke uzumizi wawo! Vintu saivyo navilaile, mna namanye mwenye akuyatenda yalaile! ");
INSERT INTO ziw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Uneva umkono wako hegu chiga chako vyakuhosa udamanye masa, vikante ukavidule hale na weye. Ni vitana kwingila mo ujima wa mazuwa yose hwina mkono hegu chiga, ukaleka kutenda una mikono midi hegu viga vidi udulwe mo moto wa mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Naho uneva ziso dyako dyakuhosa udamanye masa ding'ole ukadidule hale na weye. Ni vitana kwingila mo ujima hwina ziso, ukaleka kutenda na meso maidi udulwe mwe dibome hedina uhelo. ");
INSERT INTO ziw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Msinyise mnase kubela yumwenga mwa wadodo wano. Nawagambilani kugamba wandima wa kwembingu wawo wa uko kwe mbingu mazuwa yose wausinya uso wa Tati yangu ekwe mbingu. ");
INSERT INTO ziw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwaviya Mwana ywa Mntu ezaga kuhonya wagile. ");
INSERT INTO ziw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mwafanyanya vihi? Mntu mta ngoto gana, niyo imwenga yaga nazase izintuhu milongo chenda na chenda zikadya holugulu niyo aita akalonde idya yagile. ");
INSERT INTO ziw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nawagambilani taile, umo anaizungula naeleleswe mwe ngoto ino kuleka ziya milongo chenda na chenda hezagile. ");
INSERT INTO ziw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Seivyo Tati yenyu ekwembingu hakuvyunga yumwenga yoyose mwe wadodo wage. ");
INSERT INTO ziw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Uneva mlukolo ywako kakudamanyiza masa, mwitile ukamlagise uwihi wakwe. Mna idamanye chinyele, nyuwe wenye waidi du. Uneva anakwiva, kumhonya mlukolo ywako. ");
INSERT INTO ziw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mna uneva hakwivile, guha mntu yumenga hegu waidi mwitanye, chani chila ulosi uukulwe kwa kuwona ni waukuzi waidi hegu watatu saviya Mawandiko Yakukile yakulonga. ");
INSERT INTO ziw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hana wevile awo, ilongeni imbuli injima kwa wantu wa nyumba yo kuvikila. Kukomelekela, uneva hanevile wantu wa nyumba yo kuvikila, mtendeni saviya mntu hemzumile Chohile hegu mchisanya kodi. ");
INSERT INTO ziw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nawagambilani ichindedi, icho mkunga mchilemele mwe isi nachilemelwe kwembingu, naho mkunga mchizumile mwe isi nachizumilwe kwe mbingu. ");
INSERT INTO ziw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Naho nawagambilani taile, waidi wenyu mwe isi mnaivana mwe chochose mkulombeza, namdamanyizwe ni Tati yangu ywa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwaviya waidi hegu watatu wakadugana kwa zina dyangu, miye nami nanitende hamwenga nawo.” ");
INSERT INTO ziw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petulo niyo ambasa Yesu amuza, “Zumbe, uneva mlukolo ywangu ajendeleza kunijela mwe masa, nimlekeile nkanana nyingahi? Nkanana mfungate?” ");
INSERT INTO ziw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu ahitula, “Bule, siyo nkanana mfugate,” “mna nkanana milongo mfugate na mfungate. ");
INSERT INTO ziw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwaviya Useuta wa kwembingu uligana sa vino. Hendaga na seuta aungile kuwaza wandima wakwe. ");
INSERT INTO ziw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iviya akakonga kuwaza, egailwa mntu yumwenga mta deni dya hela zakwe milongo magana mlongo. ");
INSERT INTO ziw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mndima uyo nahana chakuvuza kuligana na viya aguhile, ivyo zumbe uyo amunga atagwe saiya mtumwa, mkaziwe hamwenga na wanawe na vyoseni ananavyo, vikaleka akavuza viya aguhile. ");
INSERT INTO ziw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yudya mndima amfikila madi zumbe. Alombeza, ‘Ni jijimiza, nahuvuzize chila chintu!’ ");
INSERT INTO ziw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Zumbe amfilambazi yudya mtumwa, ivyo amlekeila asekuvuza viya aguhile naho amleka aite. ");
INSERT INTO ziw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Niyo yudya mndima ahalawa, adugana na mndima mnyawe mta deni dya wahela wakwe. Amkagatila nakukonga kumvinya. Agamba, ‘Vuza chiya hwinkile!’ ");
INSERT INTO ziw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mndima mnyawe amgwela na kumlombeza, ‘Nijijimiza, nahuvuzize viya uninkile!’ ");
INSERT INTO ziw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mna kalemela, amjela mndani vibule aho akunga avuze kadya katigizo. ");
INSERT INTO ziw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wandima weyawe watuhu weze wawone ivyo vilaile, wengilwa ni chinyulu vitendese, waita wakumgambila zumbe yoseni yalaile. ");
INSERT INTO ziw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ivyo zumbe amwitangila yudya mndima kunyumba. Agamba, ‘Weye mndima wihiye, na sikulekeila deni hwinkile, kwaviya du kunilombeza hufile mbazi. ");
INSERT INTO ziw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Navyungwa umfile mbazi mndima mnyawo, saviya miye hufile mbazi.’ ");
INSERT INTO ziw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Zumbe kengilwa ni maya vidala, niyo amjela umndima uyo kundani asulumizwe vibule kuvuza kadya katigizo aguhile.” ");
INSERT INTO ziw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu akomeleza, “Ivyo nivyo Tate ywa kwembingu nakutendele, huna walekeile walukolo wako kulaila mo moyo wako.” ");
INSERT INTO ziw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu eze abinde ulosi uwo, kakulawa Galilaya na kubula mwe mihaka ya Yudeya, ntendele ya kaidi yo mto Yolodani. ");
INSERT INTO ziw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Fyo kulu dya wantu dimtimila Yesu, awahonya uko. ");
INSERT INTO ziw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisayo wamwenga wambasa Yesu wakamjeza kwa kumuza, “Togola, Sigilizi yagaze ni vitana mntu kumwasa mkaziwe kwa lema dyodyose?” ");
INSERT INTO ziw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu ahitula, “Hamwasomaga Mawandiko yakugamba uyo Awaumbaga aho nkongo, aumbaga mntu mgosi na mntu mvyele? ");
INSERT INTO ziw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Elo agamba, ‘Kwe chausa icho mntu namwase tati yakwe na mami yakwe, na kulungana na mkaziwe, naho awo waidi na watende mwili umwenga.’ ");
INSERT INTO ziw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ivyo watenda sawo waidi naho, mna mwili umwenga. Elo mntu asekuchipagula chiya chilunganywe ni Chohile.” ");
INSERT INTO ziw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mafalisayo wamuza, “Ni kwa chasa chani vilekile Musa kasigila kuwandika talaka ya kumwasa mvyele?” ");
INSERT INTO ziw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu awahitula, “Kwachausa cho udala we myoyo yenyu, Musa asigilaga muwase wavyele wenyu. Mna havyatendagwa kukongela aho nkongo yo kumbwa kwe isi. ");
INSERT INTO ziw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ivyo nawagambilani, chila mntu namwase mkaziwe, uneva siyo kwa chausa cha chilanga, anasola mtuhu, mntu uyo ni mgonyi, naho mntu mtuhu namsole yudya mvyele asigwe, naye ni mgonyi.” ");
INSERT INTO ziw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wanampina wakwe wamgamba, “Uneva ivyo nivyo viwagile mntu mwa mkaziwe, havi kuwagila kusola.” ");
INSERT INTO ziw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu ahitula, “Sawo wose nawahokele imbuli ino mkulonga, mna wadya du wawagilwe kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kuna wagosi awamwenga hawakusola kwaviya nivyo welekwe wagwa, wamwenga watendwa ivyo ni wantu, watuhu wetenda wenye wagwa kwa chausa cha kusankanila Useuta wa kwembingu. Akuhokela mahinyo yano nazumile!” ");
INSERT INTO ziw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wantu watuhu wamwigaila Yesu wana wadodo awaikiye mikono mlanga na awalombezeze, wanampina wawakwahila wadya wantu. ");
INSERT INTO ziw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mna Yesu agamba, “Walekeni wana wadodo weze kwangu, naho msekuwalemeza, kwaviya Useuta wa kwembingu ni wawantu waligane na wowo.” ");
INSERT INTO ziw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Awaikiya mikono yakwe mlanga mwawo, niyo akulawa uko. ");
INSERT INTO ziw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mntu yumwenga mgoli amwizilaga Yesu, amuza, “Mhinyi, nidamanye mbuli yani yedi chani nihokele ujima wa mazuwa yose?” ");
INSERT INTO ziw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu amhitula, “Nimbwani ukunuza mwe mbuli yedi? Eyuko yumwenga uyodu ywedi. Mna ukaunga kwingila mo ujima, toza malagizo.” ");
INSERT INTO ziw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yudya mntu auza, “Sigilizi zihi hungigwa ni toze?” Yesu amhitula, “Use kukoma, use kugonya, use kubawa, use kulonga lulimi, ");
INSERT INTO ziw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","weve tati yako na mami yako, na munge mbwiyayo saviya ukweunga.” ");
INSERT INTO ziw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yudya mntu ahitula, “Sizitoza kale zose, sisigaza chimbwani naho?” ");
INSERT INTO ziw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu amgamba, “Ukaunga utende utogile, hita ukatage vyose unanavyo, uwenke wachiwa ugoli uwo, nawe nautende na mpamba kwembingu. Ukaheza wize unitimile.” ");
INSERT INTO ziw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yudya mbwanga eze eve imbuli idya, kaita ulo na ulo kwaviya nani mgoli vitendese. ");
INSERT INTO ziw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu awagamba wanampina wakwe, “Nawagambilani chindedi, navitende vidala mgoli kwingila mo Useuta wa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nawagambilani vituhu, nivihufu vitendese ngamiya kwingila mwe langa dya singano, ukaleka mgoli kwingila mo Useuta wa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wanampina weze weve ivyo, niyo weheleswa, wakagamba, “Niyuhi elo akudaha kwambulwa?” ");
INSERT INTO ziw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu awang'oila meso, awagamba, “Kwa wantu idyo hadikudahika, mna kwa Chohile yose yadahika.” ");
INSERT INTO ziw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Akaheza Petulo amgamba, “Kaula, suwe chileka vyose chikutimila weye, ivyo nachihokele chibwani?” ");
INSERT INTO ziw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu awagamba, “Nawagambilani chindedi, mwe isi mpya, Mwana ywa Mntu aho nekale mwe chigoda chakwe cho Useuta china ukulu, nyuwe mlongo na waidi mnitimile nanywi namwikale mwe vigoda mlongo na vidi, mkawakantila makabila mlongo na maidi ya Izulaeli. ");
INSERT INTO ziw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Naho chila mntu asize nyumba, hegu mlukolo ywa chilume hegu ywa chiche, hegu tati yakwe, hegu mami yakwe, wana hegu nkonde kwa chausa changu, naahokele nkanana zilozize kujinka naho neenkigwe ujima wa mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mna wendile wa nkongo nawatende wo dumo, na wadya wazigile nawatende wa nkongo. ");
INSERT INTO ziw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Useuta wa kwembingu wikala saviya mntu mta nkonde yakwe ya mizabibu elauke chilochilo kulonda wantu wandima mwe nkonde yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Evana na wandima wasiku kuwaliha maliho ya mazwela ya zuwa dimwenga, niyo awasigila kwe nkonde yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ize ibule saa ntatu ya mtondo, niyo afosa vituhu na kubwila watuhu wamile kwechimaila hedigwilo, hewena cha kudamanya. ");
INSERT INTO ziw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Awagamba, ‘Nyuwe nanywi mwite kwe nkonde yangu, naniwaliheni saviya vikuwoneka vyedi.’ ");
INSERT INTO ziw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ivyo waita. Ize ibule saa mtandatu na saa chenda afosa naho, niyo adamanya saiviya adamanye. ");
INSERT INTO ziw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Haguhi na saa mlongo na imwenga niyo afosa vituhu naho, abwila wantu watuhu wamile kwechimaila hantu ahadya. Awauza, ‘Ni mbwani mwechimaila msi mjima hemwikudamanya ndima?’ ");
INSERT INTO ziw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wahitula, ‘Hahana achinkinkile ndima.’ Awagamba, ‘Ni vyedi, nyuwe nanywi mwite mkadamanye ndima kwe nkonde yangu ye mizabibu.’ ");
INSERT INTO ziw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Chisingi chize chibule, mwenye nkonde amgamba Zumbe wakwe, ‘Itanga awandima wose uwalihe amaliho yawo, akonga yudya azigile kwiza nakukomeleza kwa wadya wankongo.’ ");
INSERT INTO ziw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wandima wakongile ndima sa mlongo na imwenga walihwa chila yumwenga maliho ya zuwa dimwenga. ");
INSERT INTO ziw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na wadya walongole kukonga indima weza, nawakafanyanya kugamba nawalihwe kujinka watuhu, mna nawo walihwa maliho ya zuwa dimwenga chila yumwenga. ");
INSERT INTO ziw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Waguha hela zawo nakukonga kumng'ung'uzikila mwenye inkonde. ");
INSERT INTO ziw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wagamba, ‘Wandima wano wazigile wadamanya ndima kwa saa dimwenga du, suwe chidamanya kwa msi mjima naho kwa kujijimiza mwe dizuwa. Kuwaliha viligane na suwe!’ ");
INSERT INTO ziw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mwenye inkonde amhitula yumwenga ywawo, ‘Mbuyangu, kwetegeleze, sikupunjize. Hachivane kugamba nahulihe ndima ya zuwa kwa maliho ya zuwa dimwenga? ");
INSERT INTO ziw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Elo hokela amaliho yako wite kaya. Sunga ni mwinke yuno azigile kuligana na viya hulihile weye. ");
INSERT INTO ziw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Togola, viha miye kudamanya viya hunga mwe zihela zangu? Hegu wengilwa ni finju kwaviya miye ni ywedi?’ ” ");
INSERT INTO ziw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Niyo Yesu abindiliza, “Ivyo wadya wa kuzigila haluse na watende wa nkongo na wa nkongo vino haluse na watende waudumo.” ");
INSERT INTO ziw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Umo Yesu akakwela kubula Yelusalemu, awaguhaga wadya wanampina mlongo na waidi hankanda he sila nakutamwila nawo chinyele, awagamba, ");
INSERT INTO ziw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kaulani,” “Chaita Yelusalemu, kudya Mwana ywa Mntu nalavigwe kwa wakulu wa walavyantambiko na kwa wahinya Sigilizi. Nawamkantile file, ");
INSERT INTO ziw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","niyo wamwinkiza kwa wantu sawo Wayahudi, wakunga wambele, wamtowe, na kumsulumiza mo msalaba, mna mazuwa matatu yakutimila nauyuke.” ");
INSERT INTO ziw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Niyo mkaza Zebedayo hamwenga na wanawe wambasa Yesu, wamfikila madi nakumlombeza mbuli. ");
INSERT INTO ziw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu amuza, “Waunga mbwani?” Amhitula, “Mwo Useuta wako uwazumile wano wanangu waidi wekale yumwenga kulume kwako no mtuhu mo mkono wako wa kumoso.” ");
INSERT INTO ziw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu awahitula awo wana, “Hamvimanyize ivyo mkulombeza, vino mwadaha kunywela chikombe cha masulumizo hunga ninywele?” Wahitula, “Chavidaha.” ");
INSERT INTO ziw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu awagamba, “Nichindedi namnywe mwe chikombe changu, mna sina udahi wa kusagula wa kwikala kulume kwangu hegu kumoso kwangu. Mna hantu hano ni kwa wadya wasagulwe kale ni Tate awaikiye.” ");
INSERT INTO ziw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wadya wanampina watuhu mlongo weze weve ivyo, niyo wawehiwa awo walukolo waidi. ");
INSERT INTO ziw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ivyo Yesu niyo awetanga akawagamba, “Mvimanya kugamba vilongozi hewemzumile Chohile wana udahi mwawo, vilongozi nawo wana udahi uchintile. ");
INSERT INTO ziw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Vino havikungwa vidamanywe mgati mwenyu. Uneva yumwenga aunga atende mkulu, atende mndima ywa wasigale, ");
INSERT INTO ziw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","naho akunga atende wa nkongo atende mndima ywenyu, ");
INSERT INTO ziw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","seivyo Mwana ywa Mntu, hezile kusankanilwa, mna kusankanila na kulavya ujima wakwe utende maliho ya wantu walozize.” ");
INSERT INTO ziw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Umo Yesu hamwenga na wanampina wakwe wakahalawa mo mzi wa Yeliko, fyo kulu dya wantu nadikatimila. ");
INSERT INTO ziw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wantu waidi matuntu nawekala mnkanda mweisila weva kugamba Yesu naakajinka, ivyo wakonga kuguta, “Mwana ywa Daudi! Chifile mbazi Zumbe!” ");
INSERT INTO ziw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Idifyo dyawakwamila nakuwagamba wanyamale. Mna wagutisa, “Zumbe Mwana ywa Daudi! Chifile mbazi!” ");
INSERT INTO ziw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu achimala nakuwetanga. Awauza, “Mwaunga niwadamanyize mbwani?” ");
INSERT INTO ziw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wahitula, “Zumbe, chakunga uchitende chiwone!” ");
INSERT INTO ziw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu awafila mbazi na kudonta meso yawo, aho wadaha kuwona, niyo wamtimila. ");
INSERT INTO ziw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Umo Yesu na wanampina wakwe weze waisogeile Yelusalemu, wabula Betifage mo Lugulu lwa Mizeituni. Uko Yesu kawasigila wanampina wakwe waidi walongole, ");
INSERT INTO ziw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","awagamba, “Hitani hekaya ikulongozi kwenyu, aho nambwile mpunda italizwe na mwana mpunda ywakwe. Zifunguleni mnigaile. ");
INSERT INTO ziw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Uneva mntu anawauzani chochose, mgambeni, ‘Zumbe awaunga,’ naye nawalekele aho.” ");
INSERT INTO ziw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mbuli ino ilaila chani yadya yalongigwe ni muwoni yachinte. ");
INSERT INTO ziw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ugambileni umzi wa Sayuni. Kaula seuta ywako akwizila! Ni mnyanyahala naho kakwela mpunda na mwana mpunda.” ");
INSERT INTO ziw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ivyo, wadya wanampina waita niyo wadamanya saviya Yesu awasigile wadamanye. ");
INSERT INTO ziw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wegala mpunda na mwana mpunda, watandika izi suche zawo mlanga mwe zimpunda, Yesu naye niyo ekala mlanga. ");
INSERT INTO ziw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Fyo kulu dya wantu ditandika izisuche zawo mwe isila, watuhu wafyola matambi ya miti na kuyatandaza mwe isila. ");
INSERT INTO ziw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mafyo ya wantu ya mlongwela Yesu, wadya nawo wakumtimila hanyuma wagutila, “Jimbiko kwa mwana ywa Daudi! Ajimbikwe uyo akwiza kwa zina dya Zumbe! Jimbiko kwa Chohile!” ");
INSERT INTO ziw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Umo Yesu akengila Yelusalemu, wantu wo umzi umjima wabwikana moto. Wantu wauza, “Yuno ni yuhi?” ");
INSERT INTO ziw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Amafyo yahitula, “Yuno ni muwoni Yesu, kalawa Nazaleti si ya Galilaya.” ");
INSERT INTO ziw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu engila mwe Nyumba nkulu ya Chohile, awabalaziza kuse wantu wendile wakataga na kugula vintu mndani umo. Kahitula izimeza za wadya wendile wakavunjizana hela na vigoda vya wadya wendile wakataga wasuwamanga. ");
INSERT INTO ziw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Awagamba, “Iwandikwa mwa Mawandiko Yakukile kugamba Chohile kalonga, ‘Nyumba ya Chohile naitangwe nyumba ya kumlombeza Chohile.’ Mna nyuwe mwitenda ‘Nyumba ya kwefisiza wabavi.’ ” ");
INSERT INTO ziw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Matuntu na waholomale wambasaga uko kwe Nyumba nkulu ya Chohile, niyo awahonya. ");
INSERT INTO ziw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wakulu wa walavyantambiko na wahinya Sigilizi wehiwa weze wawone izimpituko adamanye Yesu, hamwenga na wana wakuguta mwe Nyumba nkulu ya Chohile, “Ntunyo kwa Mwana ywa Daudi!” ");
INSERT INTO ziw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ivyo wamuza Yesu, “Togola, weva icho wakulonga?” Yesu ahitula, “Heye, neva! Hamsomile mawandiko yano? ‘Kuhinya wana na wazana wachembe kutogola viya vikuwagila,’ ” ");
INSERT INTO ziw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu awasa nakubula kuse ko mzi wa Besaniya, agona uko. ");
INSERT INTO ziw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Umo Yesu emwesila akauya komzi nomtondo nakalumwa nisala. ");
INSERT INTO ziw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Awona mtini umwenga mnkanda mwe isila, niyo aubasa mna kaubwila hewina tunda dyodyose, na mani ayodu. Ivyo augamba, “Haweleke naho matunda mazuwa yose!” Aho udya umtini unyala. ");
INSERT INTO ziw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wanampina weze wawone niyo wehelwa, wauza, “Umtini uno usunguza kunyala vivihi?” ");
INSERT INTO ziw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu ahitula, “Nawagambilani chindedi, uneva mnazumila hemwina nkama, namdahe kudamanya vino nidamanye mo mtini uno. Naho sivyo vino du, mna namdahe hata kulonga ko lugulu luno, ‘Ng'oka ukedule mwe bahali,’ naho navitende ivyo. ");
INSERT INTO ziw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Uneva mwazumila, namhokele chochose mkulombeza mo kumlombeza Chohile.” ");
INSERT INTO ziw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu engilaga mwe Nyumba nkulu ya Chohile, umo akahinya, wakulu wa walavyantambiko na wadalahala wa wantu wambasa wamuza, “Wadamanya mbuli zino kwa udahi wa yuhi? Naho ni yuhi akwinkile udahi uno?” ");
INSERT INTO ziw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu awahitula, “Naniwauzeni swali dimwenga, mnanihitula, naniwagambileni nadamanya mbuli zino kwa udahi wa yuhi. ");
INSERT INTO ziw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nigambilani, udahi wa Yohana wo kubatiza walawaga kuhi? Walawaga kwa Chohile hegu walawaga kwa wantu?” Wakonga kulosana wowo wenye kwa wenye, “Chigambe mbwani? Uneva chinahitula, ‘Ulaila kwembingu,’ naachigambe, Ni mbwani naho hamwamzumilaga Yohana?” ");
INSERT INTO ziw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mna chinagamba, “kulaila kwa wantu, chogoha wantu viya nawatende, kwaviya wantu wose wamzumila Yohana kugamba ni muwoni.” ");
INSERT INTO ziw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ivyo wamhitula Yesu, “Hachivimanyize.” Niyo awagamba, Miye nami saniwagambileni nadamanya mbuli zino kwa udahi wa yuhi. ");
INSERT INTO ziw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Haluse, mwafanyanya vihi kwa dino? Kwendaga na mntu yumwenga endaga na wanawe waidi. Uyo niyo amgamba mwanawe ywa nkongo kugamba, ‘Mwanagu, dyelo hita ukadamanye ndima kwe nkonde ye mizabibu.’ ");
INSERT INTO ziw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Niyo ahitula, ‘Sikunga,’ Mna nyumani niyo ahitwila fanyanyi zakwe niyo aita. ");
INSERT INTO ziw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yudya tati ya mntu niyo ambasa mwanawe ywa kaidi amgambila seiviya amgambile yudya ywe nkongo. Uyo niyo amhitula, ‘Heye Zumbe,’ mna haitile. ");
INSERT INTO ziw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Togolani, niyuhi mgati mwa wano waidi adamanye viungile tati yakwe?” “Ywa nkongo,” Wahitula. Ivyo Yesu awagamba, “Nawagambilani chindedi, wachisanya kodi na wachilanga na wawalongweleni kwingila mo Useuta wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwaviya Yohana ezaga kwenyu kuwalagisa sila ya kuwoneka wedi, nyuwe hamumzumile, mna wachisanya kodi na wachilanga wamzumilaga. Hata umo mwawonaga yano, hamweile fanyanyi zenyu na kumzumila.” ");
INSERT INTO ziw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu agamba, “Tegelezani mliganyo mtuhu, kwendaga na mntu mta nkonde ahandaga mizabibu, niyo aizungulusiza mnulu, asimba bome dya kufumbwila zabibu nakuzenga mnala. Niyo alekeila walimi inkonde iyo nakutamba. ");
INSERT INTO ziw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chipindi cho uvuni chize chibule, asigila wandima wakwe kwa wadya walimi, wakachisanye ulozo wakwe. ");
INSERT INTO ziw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wadya walimi niyo wawagwila wandima wakwe, wamtowa uyumwenga, mtuhu wamkoma, mtuhu naye wamtowa mayuwe. ");
INSERT INTO ziw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yudya mntu naho egala wandima watuhu walozize, kujinka wadya we nkongo, wadya walimi wawausa chisimo saichiya. ");
INSERT INTO ziw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kokukomeleza amwigala mwanawe kwawo, akagamba, ‘Ichindedi nawamtunye mwanangu.’ ");
INSERT INTO ziw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mna wadya walimi weze wamwone yudya mwana, wegamba, ‘Yuno nuyo mlisi we nkonde. Chimkomeni chiguhe ulisi wakwe!’ ");
INSERT INTO ziw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ivyo wamgwila, wamdula kuse kwe nkonde ye mizabibu niyo wamkoma.” ");
INSERT INTO ziw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu auza, “Haluse, aho akwizila Zumbe mwenye nkonde ye mizabibu nawadamanye chibwani wadya walimi?” ");
INSERT INTO ziw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wahitula, “Ichindedi nawakome wadya wantu wehi, niyo enka inkonde ye mizabibu walimi watuhu, wakunga wamwinke ulozo wakwe mwe chipindi chikungwa.” ");
INSERT INTO ziw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu awagamba, Hamwasomaga viya Mawandiko Yakukile yakulonga? Yuwe dilemelwe ni wazesi dihitukila dikungisiswa mwa yoseni. Ulosi uno ulaila kwa Zumbe, nawo ni maula mwa meso yetu? ");
INSERT INTO ziw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Yesu ajeleka, Ivyo nawagambilani, namhokwe Useuta wa Chohile niyo wenkwa wantu watuhu sawo Wayahudi weleke matunda yawagile. ");
INSERT INTO ziw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Akunga agwe mwe diyuwe naavunike vunike, na uyo dikunga dimfunte nadimtiginte tiginte.” Mawandiko matuhu hayana uno msitali. ");
INSERT INTO ziw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wakulu wa walavyantambiko na Mafalisayo, weva miliganyo ya Yesu, wabunkula kugamba awalonga wowo. ");
INSERT INTO ziw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ivyo wazungula ubala wakumgwila. Mna nawakogoha amafyo ya wantu wakumwona Yesu sa muwoni. ");
INSERT INTO ziw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu alonga nawo kwa miliganyo, akagamba. ");
INSERT INTO ziw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Useuta wa kwembingu uligana sa vino. Kwendaga na seuta amdamanyize mwanawe wa chilume nyinka. ");
INSERT INTO ziw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kasigila wandima wakwe wawetange wadya wagonekwe kwe nyika, nawo niyo walemela kwiza. ");
INSERT INTO ziw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ivyo asigila wandima watuhu akagamba, ‘Ngasu yangu yajika, ng'ombe zangu na vinonile vichinjwa kale, na vyose viheza kale. Soni kwe ngasu ye nyinka!’ ");
INSERT INTO ziw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mna awajeni wagonekwe hawaitolotoze niyo wadamanya zawo, yumwenga kaita kwe nkonde yakwe, mtuhu kwediyombe dyakwe, ");
INSERT INTO ziw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","wasigale niyo wawagwila wadya wandima wakwe, wawahuta na kuwakoma. ");
INSERT INTO ziw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yudya seuta niyo ehiwa vidala, egala wankondo wakwe wakomile wadya wakomi na kuutimpa moto umzi wawo. ");
INSERT INTO ziw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Akaheza awagamba wandima wakwe, ‘Inyinka yemalanya kale, mna sawo wadya wagonekwe nawo wawagile kudya. ");
INSERT INTO ziw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hitani kwe zisila mpanda muwetange wose mkunga muwabwile weze kwe nyinka.’ ");
INSERT INTO ziw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ivyo wandima waita kwezisila wawachisanya wantu wose wawawone, wehiye na wedi, nyinka niyo yamema wajeni. ");
INSERT INTO ziw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mna seuta eze engile kukaula wajeni, niyo abunkula mntu hevikile suche ye nyinka. ");
INSERT INTO ziw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Amuza, ‘Mbuyangu, kwingila vivihi hano hwivikile suche ye nyinka?’ Mna uyo mntu halongile dyodyose. ");
INSERT INTO ziw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Niyo seuta awagamba wandima wakwe, ‘Mtalizeni mwe mikono na mweviga, mumdule kuse kwe chiza. Uko naile na kusiginta meno yakwe.’ ” ");
INSERT INTO ziw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu akomeleza, “Kwaviya wagonekwe ni waloza, mna wasagulwe ni wajeche.” ");
INSERT INTO ziw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mafalisayo niyo waita wakaike ubala wa kumgwila Yesu mo ulosi wakwe. ");
INSERT INTO ziw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wasigila wanampina wakwe hamwenga na wantu wa Helode. Wagamba, “Mhinyi, chimanya kugamba weye walonga chindedi. Wahinya ichindedi mwe viya akunga Chohile kwa chausa cha wantu, kuno hwikogoha viya watuhu wakufanyanya, kwaviya hukusinya viya mntu eli. ");
INSERT INTO ziw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chigambile, wafanyanya vihi? Ni vyedi mwe sigilizi yetu kuliha kodi kwa mkulu ywa Chilumi hegu bule?” ");
INSERT INTO ziw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mna Yesu, niyo amanya ubala wawo wihiye, agamba, “Nyuwe wasongaganyi! Ni mbwani mkunijeza? ");
INSERT INTO ziw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nilagisani hela yo kulihila kodi!” Niyo wamwigaila hela, ");
INSERT INTO ziw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","awauza, “Sula ne dizina ni vya yuhi?” ");
INSERT INTO ziw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wahitula, “Ni vya Mkulu ywa Chilumi,” Ivyo Yesu awagamba, “Ni vyedi, mwinkeni Mkulu ywa Chilumi viya vimuwagile, na Chohile vikumuwagila Chohile.” ");
INSERT INTO ziw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Weze weve ivyo, niyo wehelwa, wamleka wahalawa. ");
INSERT INTO ziw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mwe dizuwa idyo Masadukayo wamwenga wamwitila Yesu wakalonga kugamba wantu hawauyuke. ");
INSERT INTO ziw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wagamba, “Mhinyi, Musa alongaga kugamba mntu hena mwana akabanika, mlukolo ywakwe ampale mnamuwe, chani amwelekele wana. ");
INSERT INTO ziw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Haluse, kwendaga na walukolo mfungate. Ywankongo asolaga, niyo abanika. Kwaviya na hena cheleko, niyo amwasiza mlukolo ywakwe mkaziwe. ");
INSERT INTO ziw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chintu icho kimlaila ywa kaidi na ywa katatu, vita ivyo kubula ywa mfungate. ");
INSERT INTO ziw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ko uhelo yudya mvyele niyo abanika. ");
INSERT INTO ziw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Haluse chigambe mwe dizuwa dyo uyuso, mvyele yudya na atende wa yuhi? Woseni nawamsola.” ");
INSERT INTO ziw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu awahitula, “Mwagilisa! Nikwaviya hamyamanize mawandiko hegu nguvu za Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwaviya mwe zuwa dya uyuso wantu, hawasole hegu kusolwa, nawekale saviya wandima wa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mna mwe wabanike uyuso, hamsomile viya Chohile awagambilaga?, ");
INSERT INTO ziw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Miye nuyo Chohile ywa Bulahimu, nuyo ywa Isaka, naho nuyo ywa Yakobo.’ Ni Chohile ywa wajima, suyo ywa wabanike.” ");
INSERT INTO ziw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Idifyo dya awantu dize dive vino, wehelwa amahinyo yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafalisayo weze weve kugamba Yesu kawatenda Masadukayo wanyamale waswese dya kulonga, Mafalisayo niyo wekala hamwenga, ");
INSERT INTO ziw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","yumwenga mwawo, mhinya Sigilizi, amjeza Yesu kwa kumuza. ");
INSERT INTO ziw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Amuza, “Mhinyi, Isigilizi nkulu ni ihi?” ");
INSERT INTO ziw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu ahitula, “ ‘Munge Zumbe Chohile ywako kwa moyo wako wose, kwa ujima wako wose, na kwa umanyi wako woseni.’ ");
INSERT INTO ziw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ino niyo Isigilizi inkulu naho niyo yankongo. ");
INSERT INTO ziw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Sigilizi ya kaidi ya kusinyisa sa iyo, ‘Munge mtuhu saviya ukweunga mwenye.’ ");
INSERT INTO ziw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sigilizi yose ya Musa na mawandiko ya wawoni ikala mwe zisigilizi mbili zino.” ");
INSERT INTO ziw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Umo Mafalisayo wamwenga weze wadugane, Yesu niyo awauza, ");
INSERT INTO ziw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mwafanyanya vihi mwa Kulisito Mkombola? Kalaila mo ulukolo lwa yuhi?” Wahitula, “Ni mlukolo ywa Daudi,” ");
INSERT INTO ziw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu auza, “Ni mbwani naho, Muye wa Chohile ukamwingila Daudi kumwitanga ‘Zumbe’? Daudi agambaga, ");
INSERT INTO ziw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Zumbe alongaga kwa Zumbe ywangu. Ikala hano kulume kwangu kubula niwaike wehi wako mwe viga vyako.’ ");
INSERT INTO ziw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Uneva haluse Daudi kamwitanga ‘Zumbe’, Kulisito Mkombozi atenda vivihi mlukolo ywa Daudi?” ");
INSERT INTO ziw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hahalaile adahile kumhitula Yesu, kulaila mwe dizuwa idyo, hahali ajezize kumuza naho. ");
INSERT INTO ziw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu niyo alonga na kwa amafyo na kwa wanampina wakwe. ");
INSERT INTO ziw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Awagamba, “Wahinya Sigilizi na Mafalisayo wenkwa udahi wa kulavyanya Sigilizi ya Musa. ");
INSERT INTO ziw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ivyo tozani na kutimila chila wakuwagambilani mdamanye, mna msekwiga ntendwa zawo, kwaviya hawakudamanya viya wakulonga. ");
INSERT INTO ziw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wafunga mizigo na kuwatwisa wantu mwamayega yawo mna wowo wenye hawakunga hata kuidonta na kadole. ");
INSERT INTO ziw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wadamanya ntendwa zawo zose chani welagise kulongozi kwa wantu. Kaulani wavika wakota wawo wana Mawandiko Yakukile. Naho wavala nkazu na mahembe matali! ");
INSERT INTO ziw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Waunga kwikala mwe vigoda vi kulongozi mwe ngasu, na vikigwe na kuwandwa mwe nyumba zo kuvikila. ");
INSERT INTO ziw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Waunga kulamswa kwa kutunywa mwa magwilo na kunga kwitangwa ‘Mhinyi’. ");
INSERT INTO ziw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mna nyuwe msekuzumila kwitangwa ‘Wahinyi’, kwaviya nyuwe wose mwi walukolo, nanywi mna Mhinyi yumwenga du. ");
INSERT INTO ziw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Naho msekumwitanga mntu yoyose ‘Tate’, hano he isi kwaviya Tati yenyu ni yumwenga kwembingu. ");
INSERT INTO ziw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Naho msekwitangwa ‘Chilongozi’, kwaviya mwi wamwenga naho chilongozi uyodu ni Kulisito Mkombola. ");
INSERT INTO ziw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mkulu mgati mwenyu aungwa atende mndima ywenyu. ");
INSERT INTO ziw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yoyose nekweze na aselezwe, akweseleza na akwezwe ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Namvimanye wenye, wahinya Sigilizi na Mafalisayo! Nyuwe wasongaganyi! Mwawavugaila wantu watuhu sila ya kwingila mo Useuta wa kwembingu nyuwe wenye hamkuwingila, naho hamkulekela wadya wakujeza kuwingila! ");
INSERT INTO ziw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Namluwone, nyuwe wahinyi wa Sigilizi na Mafalisayo! Nyuwe wasongaganyi! Mwapolaganya ugoli wa wavyele wabanikilwe ni wagosi na kulombeza malombezo matali kwa kwelagisa. Kwa chausa icho kanto dyenyu naditende kulu ditendese! ");
INSERT INTO ziw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Namvimanye wenye, wahinya Sigilizi na Mafalisayo! Nyuwe wasongaganyi! Mwazunguluka mwe bahali na mwe isi chani mhokele mntu yumwenga atimile isila yenyu. Anazumila, mwamtenda mwana wa kwedibome hedina uhelo nkanana mbili kujinka nyuwe wenye! ");
INSERT INTO ziw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Namluone, vilongozi matuntu! Mwagamba, ‘Uneva mntu elisa kwa Nyumba nkulu ya Chohile, sicho chintu. Mna uneva mntu elisa kwa zahabu ya Nyumba ya Chohile, kegwiza.’ ");
INSERT INTO ziw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nyuwe wahezi na matuntu! Chikulu ni chihi, zahabu hegu Nyumba nkulu ya Chohile ikutenda zahabu itende ikukile? ");
INSERT INTO ziw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Naho mwahinya, ‘Uneva mntu elisa kwa nchanja yo kulaviza ntambiko, sicho chintu, mna uneva mntu elisa kwa ntunyo imlanga mwe shanduku ya kulaviza jeleko mwakwe, kegwiza.’ ");
INSERT INTO ziw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nyuwe matuntu! Chikulu ni chihi, shanduku ya kulaviza jeleko hegu nchanja yo kulaviza ntambiko ikutenda jeleko dikukile? ");
INSERT INTO ziw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ivyo mntu akwelisa kwa nchanja yo kulaviza ntambiko, elisa kwa iyo, na vintu vyose viyumo. ");
INSERT INTO ziw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Akwelisa ne Nyumba nkulu ya Chohile, elisa kwa iyo, na kwa uyo Chohile akwikala mndani mwakwe. ");
INSERT INTO ziw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Uyo akwelisa kwa zina dya kwembingu, elisa kwe chigoda cho uzumbe wa Chohile mazuwa yose na kwauyo akwikala umo. ");
INSERT INTO ziw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Namluwone wenye, wahinya Sigilizi na Mafalisayo! Nyuwe wasongaganyi! Mwamwinka Chohile hantu hamwenga mwe mlongo ha uvuni wa mhilimo, enga vitago na bizali na jila, mna mwaleka kutimila mahinyo yakungwa ya Sigilizi, saviya wedi wa Chohile na mbazi na ukanuni na uzumizi. Mwaungwa mvijese ivyo hemwi kuleka vituhu. ");
INSERT INTO ziw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Vilongozi matuntu! Mwafilihiza wadudu wadodo enga saviya mbu mwe mazi, mna mwamela ngamiya! ");
INSERT INTO ziw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Namluwone, wahinya Sigilizi na Mafalisayo! Nyuwe wasongaganyi! Mwalengusa viya vyenyu na vihungu kwa kuse na chano, mndani mmema uhoki na kwevutila. ");
INSERT INTO ziw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Weye Falisayo tuntu! Konga kulengusa mndani mwe chiya kuse nako nakutende kulenguka! ");
INSERT INTO ziw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Namluone, wahinya Sigilizi na Mafalisayo! Nyuwe wasongaganyi! Mligana na mbila zihakigwe chwakaa, kwa kuse ni ntana, mna mndani mmema mavuha ya wabanike na uzavu. ");
INSERT INTO ziw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Seivyo, kuse mwasinyika wantu wedi kwa chilayumwenga, mna mndani mmema usongaganyi na masa. ");
INSERT INTO ziw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Namluone, wahinya Sigilizi na Mafalisayo! Nyuwe wasongaganyi! Mwazengela wawoni mbila ntana nakuzika untanda mbila za wantu wawoneke wedi kulongozi kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Naho mwagamba, hegu suwe chendaga hamwenga mwe chikale cha wadalahala wetu, hachehangile nawo mo kuwakoma wawoni. ");
INSERT INTO ziw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Elo mweukuila wenye, kugamba nyuwe mwiwana wawadya wawakomile wawoni! ");
INSERT INTO ziw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Haya komelezani ndima waikongile wadalahala wenyu! ");
INSERT INTO ziw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nyuwe fyo dya nyoka! Namwenege vivihi nkanto dya kwe bome hedina uhelo? ");
INSERT INTO ziw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kwaivyo, nawegailani wawoni na wata ubala na wahinya Sigilizi. Wamwenga wenyu namuwakome na kuwasulumiza, watuhu namuwatowe mwe nyumba yo kuvikila na kuwagulusa mzi kubula mzi. ");
INSERT INTO ziw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mwe ivyo, namlihizwe sakame itike mwe isi ino hewena masa, kukongela ukomi wa Habili awoneke ywedi kwa Chohile kubula ukomi wa Zakaliya mwana Balakiya, mwamkomaga mgati mwe Nyumba nkulu ya Chohile na mwe nchanja yo kulaviza ntambiko. ");
INSERT INTO ziw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nawagambilani chindedi, ukomi uno woseni naugwele mwe wantu we icheleko chino. ");
INSERT INTO ziw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalemu, Yelusalemu! Ukuwakoma wawoni, na kuwatowa wasigilwe kwako ni Chohile! Ninkanana nyingahi sunga niwachisanye hamwenga wanawo, saviya nguku ikufuwatila wanawe hasi ha mawawa yakwe, mna hamvyungile! ");
INSERT INTO ziw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ivyo, Nyumba ya Chohile naibomolwe ikale isamigwe. ");
INSERT INTO ziw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nawagambilani kukongela vino haluse, hamniwone naho kubula mgambe, ‘Chohile mjimbike akwiza kwa zina dya Zumbe.’ ” ");
INSERT INTO ziw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu nakafosa mwe Nyumba nkulu ya Chohile naho na akahalawa umo wanampina wakwe wambasize chani wamlagise mazengo ye mwe Nyumba ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Auza, “Mwayawona yano yose? Nawagambilani chindedi, hano hadisigale yuwe mlanga mwe mnyawe, chila dimwenga nadidulwe hasi.” ");
INSERT INTO ziw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Umo Yesu endaga ahumule ko Lugulu lwa Mizeituni, wanampina wakwe wambasaga kwa chinyele, wauza, “Chigambile, mbuli zino nazilaile ini? Ni chilagiso chani chokwiza kwako, na udumo we isi?” ");
INSERT INTO ziw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu ahitula, “Msinyise, mntu ase kuwadanta. ");
INSERT INTO ziw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwaviya wantu walozize nawalaile waketanga kwa zina dyangu, wakagamba, ‘Miye nuyo Kulisito Mkombola!’ Nawo na wadante walozize. ");
INSERT INTO ziw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Namwive mbuli za nkondo na hambwe hambwe dya nkondo, kaulani, msekutiswa, kwaviya ayo yaungwa yalaile, mna udya udumo haunati. ");
INSERT INTO ziw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Si naitowane na si ntuhu, useuta nautowane na useuta. Nakutende na gumbo, na visingisa chila hantu. ");
INSERT INTO ziw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yose ayo nayekale saviya usungu wa nkongo wa kwefungula mwana. ");
INSERT INTO ziw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Vikajika namlavigwe chani msulumizwe, nakukomwa, nanywi namwihiwe ni wantu wa si ntuhu zose kwa chausa changu. ");
INSERT INTO ziw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mwe ichipindi icho walozize nawahige uzumizi wawo naho nawaihiwane na kulemana. ");
INSERT INTO ziw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nawalaile wawoni wadanti walozize, wakunga wawadante wantu walozize. ");
INSERT INTO ziw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kwa chausa cha kujenyela kwa wihi, uungi wa wantu walozize nauhunguke. ");
INSERT INTO ziw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mna mntu akunga ajijimize kubula kodumo nuyo akunga akombolwe. ");
INSERT INTO ziw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Naho Mbuli Yedi ya Useuta nailongwe mwe isi yose, utende ukuzi kwa wantu we si ntuhu yose, aho naho udya udumo naubule. ");
INSERT INTO ziw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Namumwone uyo akwitangwa ‘Ihizo dya ubanasi’ chilongingwe ni muwoni Danieli. Nachichimale hantu hakukile.” Akusoma na abunkule! ");
INSERT INTO ziw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Niyo wose we mwe isi ya Yudeya, nawasumkile ko lugulu. ");
INSERT INTO ziw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yudya ekulanga kwedigulu asekusela kuviguha vintu vimwenyumba yakwe, ");
INSERT INTO ziw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Naho ekwenkonde, asekuya kunyuma kuguha suche yakwe. ");
INSERT INTO ziw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nawamanye wenye watanda na wakonkeza mwa mazuwa ayo! ");
INSERT INTO ziw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mlombezeni Chohile, chani kuguluka kwenyu kusekutenda mwempeho, hegu mwe zuwa dya kuhumula. ");
INSERT INTO ziw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwaviya nakutende na nkunto nkulu, idya heinati kulaila kukongela isi heinati kumbwa kubula vino haluse, naho hazize zilaile vituhu. ");
INSERT INTO ziw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Hegu Chohile hahunguze mazuwa ayo ye zinkunto hahendile na mntu hata yumwenga ahonile mwe file. Mna kwa chausa cha wantu wakwe asagule, Chohile nayahunguze mazuwa ayo. ");
INSERT INTO ziw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Naho, mntu akawagambani, ‘Kaula, Kulisito ehano!’ Hegu ‘Ekudya!’ Msekumzumila. ");
INSERT INTO ziw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwaviya nawalaile makulisito wadanti, na wawoni wadanti, nawo nawadamanye mpituko nkulu na vilagiso, chani, vikadahika, wawadante hata wantu wasagulwe ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kaulani, silongola kuwagambilani yakwiza. ");
INSERT INTO ziw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ivyo, uneva wantu wakawagambani, ‘Kaulani, ekwenyika!’ Mse kwita uko, hegu wakawagambani, ‘Kaulani, kefisa kuno!’ Msekuzumila. ");
INSERT INTO ziw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwaviya ni saviya lumwemwe lukumulika ulailo wa zuwa lukawoneka uswelo wa zuwa, ivyo nivyo na kutende kwiza kwakwe Mwana ywa Mntu. ");
INSERT INTO ziw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kwaviya hohose hana chimba, naho nayadugane magushu. ");
INSERT INTO ziw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mna Aho, vikajinka ukukunta mwa mazuwa ayo, zuwa nadijelwe chiza, mnenge haulangaze, ntondo nazigwe kulaila kwembingu, nguvu za kwembingu nazisingisike, ");
INSERT INTO ziw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Naho nachiwoneke chilagiso cha Mwana ywa Mntu kwembingu, naho wantu wose we isi nawaile, nawo nawaile Mwana ywa Mntu akeza mlanga mwa maingu hamwenga na nguvu za ukulu ulozize. ");
INSERT INTO ziw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naawasigile wandima wa kwembingu wakwe hamwenga na izwi kulu dya gunda, nawo nawawachisanye wasagulwa wakwe kulaila ntendele nne, kulaila ko udumo uno kwita ko udumo uno. ");
INSERT INTO ziw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ivyo ko mti ukwitangwa mtini mhine mliganyo, tambi dyakwe dikasuka mani na kubwalika mwamanya kugamba chipindi cha fula chihajihi, ");
INSERT INTO ziw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Seivyo nanywi, mkayawona ayo yose, bunkulani kugamba Mwana ywa Mntu ehaguhi na kwiza. ");
INSERT INTO ziw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nawagambilani chindedi, vintu vyose vino navilaile umo wantu wa haluse hawanati kubanika. ");
INSERT INTO ziw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mbingu ne isi na vijinke, mna mbuli zangu hazomboke ng'o. ");
INSERT INTO ziw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Hahali mntu yoyose amanyize idizuwa idyo na chipindi, hata wandima wa kwembingu hata Mwana, mna Tate ichedu nuyo amanyize. ");
INSERT INTO ziw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Saviya vyendaga mwa mazuwa ya Nuhu, nivyo navitendeke kwiza kwakwe Mwana ywa Mntu. ");
INSERT INTO ziw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Saviya mwa mazuwa hevinati kulaila galika wantu wendaga wakadya, na kunywa, wakasola na kusolwa, vikabula zuwa diya Nuhu engilaga mwe ngalawa nkulu, ");
INSERT INTO ziw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","wasekumanya, niyo galika yeza, yawaguha wose, nivyo na kutendeke kwiza kwakwe Mwana ywa Mntu. ");
INSERT INTO ziw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wantu waidi nawatende kwenkonde, yumwenga na aguhigwe yumwenga asigwa. ");
INSERT INTO ziw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wavyele waidi na watende wabunda, yumwenga aguhigwa, yumwenga asigwa. ");
INSERT INTO ziw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ivyo chelezani, kwaviya hammanyize aho neezile Zumbe dyenyu. ");
INSERT INTO ziw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mna mmanye mbuli ino, uneva mta nyumba amanyize hadya nezile mbavi, nakacheleza, naho halekile inyumba yakwe ivunwe. ");
INSERT INTO ziw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kwe chausa icho nyuwe nanywi mwikale mhezize, kwaviya mwe saa hemwimanyize Mwana ywa Mntu eza. ");
INSERT INTO ziw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Elo ni yuhi mndima mkanuni mta fanyanyi, yudya zumbe dyakwe nakamwika mwe nyumba yakwe, awenke wantu nkande mwe chipindi chikuwagila? ");
INSERT INTO ziw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chinyemi china yudya mndima yudya hadya zumbe dyakwe akwizila na ambwile adamanya ivyo. ");
INSERT INTO ziw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nawagambilani chindedi naamwike atende mdimi mkulu mo wakwe wose. ");
INSERT INTO ziw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mna mndima yudya aihiye akagamba mo moyo wakwe, ‘Zumbe dyangu akawa ukwiza,’ ");
INSERT INTO ziw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Naho niyo akonga kuwatowa wandima weyawe na kudya na kunywa hamwenga na wakozi. ");
INSERT INTO ziw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Zumbe dyakwe umndima uyo neeze zuwa hedimanyize, na chipindi hemanyize. ");
INSERT INTO ziw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Namtowe vitendese na kumsulumiza seiviya na wantu wasongaganyi, akamwika hantu hendilo na kusiginta meno. ");
INSERT INTO ziw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Naho, Useuta wa kwembingu nauligane na wandele mlongo, waguhile taa zawo, niyo waita kumgoja msola. ");
INSERT INTO ziw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Washano mwe wadya nendile ni wahezi, washano wendaga ni wabala. ");
INSERT INTO ziw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Wadya wahezi waguha taa zawo, mna hawaguhile na mavuta ya kongezeza. ");
INSERT INTO ziw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mna wadya wabala waguha mavuta mwe supa hamwenga ne zita zawo. ");
INSERT INTO ziw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kwaviya msola kakawa ukwiza, woseni niyo wahitilwa ni ntongo. ");
INSERT INTO ziw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Mna chilo gati, niyo kwatenda na lwasu, Sunguzani, sunguzani, msozi eza, hitani mkamhokele! ");
INSERT INTO ziw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wandele woseni mlongo niyo wenuka wamalanya taa zawo. ");
INSERT INTO ziw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wadya wahezi wawagamba wadya wabala, ‘Chihunguzizeni wavuta wadodo kwaviya taa zetu zafifiya.’ ");
INSERT INTO ziw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mna wadya wabala wawahitula, ‘Bule’ ‘hayachinte kwa suwe na nyuwe. Mkadaha hitani kwamaduka, mkagule.’ ");
INSERT INTO ziw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ivyo weze waite kokugula, msola niyo eza, wadya wendile ahadya wengila hamwenga no msola kwe nyinka, ulwivi niyo lwavugalwa. ");
INSERT INTO ziw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Vikaheza weza wadya wandele awatuhu, wagamba, ‘Zumbe, zumbe! Chivugwile!’ ");
INSERT INTO ziw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ahitula agamba, ‘Nawagambilani chindedi, nyuwe siwamanyize.’ ” ");
INSERT INTO ziw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu akomeleza, “Elo chelezani, kwaviya hammanyize zuwa hegu saa. ");
INSERT INTO ziw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Mwe chipindi icho Useuta wa kwembingu nawikale sa vino. Kwendaga na mntu akunga atambe, awetanga wandima wakwe, aika ugoli wakwe kwawo wamsinyize. ");
INSERT INTO ziw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Amwinka hela shano, mtuhu hela mbili, mtuhu hela imwenga, chila mntu saviya nguvu ananazo. Niyo atamba. ");
INSERT INTO ziw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Aho Yudya enkigwe hela shano ahalawa, niyo azidamanyiza mayombe, zamwingiziza ntuhu shano. ");
INSERT INTO ziw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Seivyo yudya ahokele hela mbili, zamwingiziza ntuhu mbili. ");
INSERT INTO ziw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mna yudya enkigwe hela imwenga niyo aita aisimbila hasi, aifisa ihela ya zumbe dyakwe. ");
INSERT INTO ziw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Yeze yomboke mazuwa yalozize zumbe dya wadya wandima niyo auya, awauza ivyo wazidamanyize ndima. ");
INSERT INTO ziw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Eza yudya mndima enkigwe hela shano, enkiza hela shano ntuhu, akagamba, ‘Zumbe, waikaga kwangu hela shano.’ ‘Kaula! Hela shano zongezekele.’ ");
INSERT INTO ziw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Zumbe dyakwe dya mgamba, ‘N ivyedi, weye mndima ywedi na mchindedi, kutenda mkanuni kwa vijeche, nahutende msinyi ywa vilozize, utende na chinyemi na zumbe dyako!’ ” ");
INSERT INTO ziw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Yudya mndima enkigwe hela mbili niyo eza, agamba, ‘Zumbe, nakwika hela mbili kwangu. Kaula! Hela mbili zongezekela.’ ");
INSERT INTO ziw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Zumbe ywakwe amgamba, N ivyedi, mndima ywedi na mchindedi. ‘Kutenda mkanuni kwa vijeche, nahutende msinyi ywa vilozize, ingila utende na chinyemi hamwenga na zumbe dyako!’ ” ");
INSERT INTO ziw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Niyo eza yudya enkagwa hela imwenga, agamba, ‘Zumbe, nasibunkula kugamba weye wi mdala, weye walozola hwi handile, na kuchisanya hadya hwi mwaganise. ");
INSERT INTO ziw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ivyo sogoha, niyo naifisa ihela yako hasi ho msanga. Kaula! Guha ivyako.’ ” ");
INSERT INTO ziw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Niyo Zumbe dyakwe amhitula, “ ‘Weye wi mndima wihiye naho mbwa! Kuvimanya kugamba miye nalozola hantu sihandile nakuchisanya hadya simwaganise mbeyu? ");
INSERT INTO ziw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ivyo, naukaungwa wigale hela yangu kwa wadya wakuliha liba, nasiza kuguha ihela yangu na vijenyelekele. ");
INSERT INTO ziw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ivyo, hela iyo, mwinkeni yudya mta hela mlongo. ");
INSERT INTO ziw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwaviya chila mta chintu nenkigwe, na kongezezwa vitendese, mna hena, chiya ananacho nacho na ahokwe. ");
INSERT INTO ziw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na mndima yudya hekuwagila, mduleni hale kuse kwe chiza, uko nakutenda na ndilo na kusiginta meno.’ ");
INSERT INTO ziw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Aho Mwana ywa Mntu neze no ukulu wakwe, hamwenga na wandima wa kwembingu wose wakukile nawatende naye, nekale mwe chigoda chakwe cho useuta. ");
INSERT INTO ziw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wantu wose mwe zisi zose, na wadugane houso wakwe, naye na awapagule wantu saviya mdimi akupagula ngoto na mbuzi. ");
INSERT INTO ziw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Naike ngoto ntendele yakwe ya kulume, na mbuzi ntendele ya kumoso. ");
INSERT INTO ziw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Akaheza Seuta na awagambe wadya wekulume kwakwe, ‘Soni, nyuwe mjimbikwe ni Tate! Hokelani useuta mwikiwe kukongela nkongo mo kuumbwa kwe isi. ");
INSERT INTO ziw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nendaga na sala, mninka nkande, nendaga na nchilu mwaninkaga mazi, nendaga mjeni, mwanihokelaga, ");
INSERT INTO ziw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nani mwazi niyo mwanivisa, nendaga mnyonje, mwezaga kunikaula, nendaga mwedijeleza, mwezaga kunitalamkila.’ ");
INSERT INTO ziw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Wantu wawoneke wedi nawamhitule, Zumbe, ni chipindi chihi chakuwonaga una sala niyo chakwinka nkande, hegu nauna nchilu niyo chakuywesa? ");
INSERT INTO ziw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ni ini naho chakuonaga wi mjeni, niyo chakuhokela, hegu wi mwazi niyo chakuvika? ");
INSERT INTO ziw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ni ini chakuwonaga wi mnyonje, hegu mwechifungo, niyo cheza kukukaula? ");
INSERT INTO ziw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Seuta nawahitule, ‘Nawagambilani chindedi, ivyo muwadamanyize wamwe mwa awo walukolo wangu wadodo, mnitendela miye!’ ");
INSERT INTO ziw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Akajika nawagambe wadya we komkono wakwe wa kumoso, ‘Halaweni ho uso wangu, nyuwe mligitwe! Hitani ko moto wa mazuwa yose, ekiwe Mwavu na wandima wakwe! ");
INSERT INTO ziw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nendaga nasala, hamninkile nkande, nendaga na nchilu, hamninkile mazi, ");
INSERT INTO ziw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nendaga mjeni, hamnihokele, nendaga mwazi, hamnivisize, nendaga mnyonje na mwechifungo, mna hamwizile kunikaula.’ ");
INSERT INTO ziw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Nawamhitule, ‘Zumbe, ni ini chakuonaga una sala hegu nchilu, hegu mjeni, hegu wi mwazi, hegu wi mnyonje, hegu mwechifungo, hachikusankanile?’ ");
INSERT INTO ziw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Seuta na awahitule, ‘Nawagambilani chindedi, ivyo hemkumtendela yumwenga mwa wano wakuwazwa wadodo, hamnitendele miye.’ ");
INSERT INTO ziw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wano nawegalwe kwe kanto dya mazuwa yose, mna wadya wawoneke wedi kulongozi kwa Chohile nawengile mo ujima wa mazuwa yose.” ");
INSERT INTO ziw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu eze abinde kulonga yoseni ayo, awagamba wanampina wakwe, ");
INSERT INTO ziw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mvimanya kugamba, mazuwa maidi yakwiza nakutendeke na Pasaka, na Mwana ywa Mntu nalavigwe chani asulumizwe.” ");
INSERT INTO ziw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Niyo wakulu wa walavyantambiko na wadalahala wa wantu wadugana mndani mwe nyumba ya Mlavyantambiko Mkulu, akwitangwa Kayafa, ");
INSERT INTO ziw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","waika ubala, chani wamgwile Yesu chinyele chani wamkome. ");
INSERT INTO ziw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mna wagamba, “Vinasekutenda mwe ngasu ye Pasaka, sima kunalaile nkumbizi.” ");
INSERT INTO ziw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Umo Yesu endaga Besaniya mwe nyumba ya Simoni, akwitangwa mta matana, ");
INSERT INTO ziw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mvyele mta kasupa ka mavuta yakupwepweleka yakutagwa kwa hela zilozize kamwizila, amjidila mo mtwi wakwe hadya ekale mo kudya he meza. ");
INSERT INTO ziw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wanampina wakwe weze wawone, niyo wehiwa, wagamba, “Kwaza kuno ni kwambwani? ");
INSERT INTO ziw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mavuta yano nayakadaha kutagwa kwa hela zilozize, niyo wenkigwa wachiwa!” ");
INSERT INTO ziw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu niyo abunkula, awagamba, “Nimbwani mwamsunka sunka yuno mvyele? Kanidamanyiza ndima yedi. ");
INSERT INTO ziw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wachiwa mnanawo mazuwa yose, mna miye hachitende hamwenga mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mvyele uyo kanijidila mavuta yakupwepweleka mo mwili wangu chani anike vyedi mo kuhambwa kwangu. ");
INSERT INTO ziw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nawagambilani chindedi, kwa chausa cha kumkumbuka yuno mvyele, ntendwa idya adamanye naijendeleze hose Mbuli Yedi nailongwe mwe isi yose.” ");
INSERT INTO ziw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mwe chipindi icho yumwenga mwa wadya wanampina mlongo na waidi, zina dyakwe Yuda Isikaliyote, awabasa wakulu wa walavyantambiko, ");
INSERT INTO ziw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","awauza, “Namninke chibwani uneva hamwinkiza Yesu kwenyu?” Niyo wamwinka matundu milongo mitatu ya hela. ");
INSERT INTO ziw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kukongela aho Yuda naakalonda luhenyo lwa kumwinkiza Yesu kwawo. ");
INSERT INTO ziw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Zuwa dya nkongo dye Pasaka dye migate heijeligwe Hamila, wanampina wambasa Yesu na kumuza, “Waunga chikutendele hahi Inkande ye pasaka?” ");
INSERT INTO ziw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu niyo awagamba waite ko mzi na kumgambila mntu yumwenga kugamba, “Mhinyi agamba, ‘Zuwa dyangu dihaguhi, miye hamwenga na wanampina wangu nachidye nkande ya Pasaka kwako.’” ");
INSERT INTO ziw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wanampina niyo wadamanya enga viya wasigilwe ni Yesu, waikaga nkande ya Pasaka. ");
INSERT INTO ziw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ivyo eze ibule chisingi kekala he nkande hamwenga na wadya mlongo na waidi. ");
INSERT INTO ziw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Umo nawakadya, Yesu agamba, “Nawagambilani chindedi, yumwenga ywenyu nanilavye.” ");
INSERT INTO ziw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Niyo wengilwa ni chinyulu vitendese, wakonga kumuza yumwe yumwe, “Zumbe, ni miye?” ");
INSERT INTO ziw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ahitula agamba, “Natweze tonge dyakwe hamwenga na miye mwe bakuli nuyo akunga anilavye. ");
INSERT INTO ziw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana ywa Mntu aita zakwe enga ivyo awandikilwe mwa Mawandiko ya Kukile. Mna hangi mwenye yudya mntu akunga amlavye! Nani vyedi mntu yudya hegu helekagwa.” ");
INSERT INTO ziw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, yudya mta kumlavya, amhitula, agamba, “Mhinyi, ni miye?” Yesu amhitula, “Weye kulonga.” ");
INSERT INTO ziw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Umo wendile wakadya, Yesu niyo aguha mgate, aujimbika, niyo aubesula, awenka wanampina wakwe akagamba, “Guhani mdye. Uno nuwo mwili wangu.” ");
INSERT INTO ziw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Akaheza aguha chikombe, amtogola Chohile, na kuwenka. Akagamba, “Nywani nyoseni,” ");
INSERT INTO ziw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Ino niyo sakame yangu ya lagano, ikwitika kwachausa cha walozize chani walekeilwe masa yawo. ");
INSERT INTO ziw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mna nawagambilani, saninywe naho kukongela haluse lweleko luno lwo mzabibu, kubula hadya nanizile kunywa impya hamwenga na nyuwe mo Useuta wa Tate.” ");
INSERT INTO ziw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Weze wabinde ukuchema, walawa kolwazo kwita ko Lugulu lwa Mizeituni. ");
INSERT INTO ziw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Naho Yesu akuwagamba, “Chilo cha dyelo, nyuwe nyose namwihizwe kwa chausa changu. Kwaviya viwandikwa, Chohile agamba, ‘Nanimtowe umdimi, ne idifyo dye zingoto nadimwagikane.’ ");
INSERT INTO ziw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mna heza kuuyuka, naniwalongweleni kwita Galilaya.” ");
INSERT INTO ziw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petulo ahitula, amgamba, “Wose wanakwasa, miye sahwase!” ");
INSERT INTO ziw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu amgamba, “Chindedi nakugambila, weye chilo chino umo zogolo hadinati kwila, naunilemele nkanana ntatu.” ");
INSERT INTO ziw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petulo amgamba, “Uneva vyaungwa nibanike hamwenga naweye navihaya mna sahulemele ng'o.” Niyo wanampina wose walonga seivyo. ");
INSERT INTO ziw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Akaheza, Yesu aita hamwenga na wanampina wakwe hantu hakwitangwa Gesemane, awagamba wanampina wakwe, “Ikalani hano, nite halombeze.” ");
INSERT INTO ziw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Amguha Petulo na wadya wana waidi wa Zebedayo, akonga kwingilwa ni usungu na tumbwaziko. ");
INSERT INTO ziw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Naho awagambila, “Nina usungu vidala mo moyo haguhi na kubanika. Ikalani hano, mcheleze hamwenga na miye.” ");
INSERT INTO ziw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ajendeleza kulongozi hadodo, agwa chifudifudi, alombeza, agamba, “Tati yangu, vikadahika, champa chino chikombe, mna visekutenda enga viya hunga miye, mna saviya ukunga weye.” ");
INSERT INTO ziw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Awezila wadya wanampina, awabwila wagona. Amgamba Petulo, “Togola! Hamdahile kucheleza na miye kubula saa dimwenga? ");
INSERT INTO ziw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chelezani, mlombeze, msekwiza kwingila mwe majezo, Muye wa mntu waunga kudamanya vyedi mna mwili uhwa.” ");
INSERT INTO ziw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aita nkanana ya kaidi, alombeza, agamba, “Tati yangu, uneva havikudahika ichikombe chino cha masulumizo chinenege uneva sinywele, mna ivyo ukunga vitendeke.” ");
INSERT INTO ziw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eza vituhu, awabwila wagona, kwaviya meso yawo yazamilwa ni ntongo. ");
INSERT INTO ziw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Awasa vituhu, aita, alombeza nkanana ya katatu, alonga mbuli iziya. ");
INSERT INTO ziw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Akaheza awezila wanampina wakwe, awagamba, “Mchei gonile? Kaulani, chipindi chibula Mwana ywa Mntu nalavywe mwe mikono ya wantu wata masa. ");
INSERT INTO ziw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Inukani, chiteni zetu! Kaulani, yudya akunga anihituke ehaguhi.” ");
INSERT INTO ziw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Umo achei kulonga, Yuda, yumwe wa wadya wanampina mlongo na waidi niyo eza hamwenga na fyo kulu dya wata mabamba na malungu. Nawasigilwa ni wakulu wa walavyantambiko na wadalahala wa wantu. ");
INSERT INTO ziw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda, yudya akumhituka nakawenka chilagiso, akagamba, “Mntu uyo hunga kumsesa, uyo nuyo. Mgwileni.” ");
INSERT INTO ziw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aho amsogeila Yesu, amlamsa, “Ndamsa Mhinyi!” Niyo amsesa. ");
INSERT INTO ziw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu amgamba, “Mbwiyangu, damanya idyo ubasize.” Waita, wamgwila Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yumwenga mwe wadya na we hamwenga na Yesu achumiza umkono wakwe, asomola idibamba dyakwe, amtowa mndima ywa mlavyantambiko mkulu, amsenga idigutwi. ");
INSERT INTO ziw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aho Yesu amgamba, “Vuza idibamba dyako mwe yala yakwe. Wose nawatoze bamba, nawakomwe kwa bamba. ");
INSERT INTO ziw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hegu hamanyize kugamba nadaha kumlombeza tate, naye adaha kunigaila wankondo wa bunga dya kwembingu kujinka mlongo na maidi ya wandima wa kwembingu? ");
INSERT INTO ziw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ivyo nayachinte vivihi Mawandiko Yakukile yakugamba nivyo vikungwa vitendeke?” ");
INSERT INTO ziw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ichipindi icho Yesu niyo alugambila ludya ulukudidi lwa wantu wezile kumgwila, “Togolani, mlawa enga kwiza kumgwila mpolaganyi wata mabamba na malungu chani mnitoze? Chila zuwa nani mwe nyumba nkulu ya Chohile hahinya, mna hamnigwile. ");
INSERT INTO ziw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mna yano yose yalaila, chani mawandiko ya wawoni yachinte.” Niyo wanampina wose wamwasa, wanyilika. ");
INSERT INTO ziw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wadya wamgwile Yesu niyo wamwigala kwa Mlavyantambiko Mkulu akwitangwa Kayafa, hantu wahinya Sigilizi na wadalahala wendile wadugana. ");
INSERT INTO ziw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petulo nakamtimila kwa luhalehale kubula kungwelo kwa Mlavyantambiko Mkulu, engila kunyumba hamwenga na wambizi chani adahe kuziwona mbuli zose zikunga zilaile. ");
INSERT INTO ziw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ivyo wakulu wa walavyantambiko na wadya wose we chitala walonda mbuli za udanti kulawana na Yesu, chani wamkome. ");
INSERT INTO ziw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mna hawabunkule ulosi wowose, hamwenga na ivyo wantu walozize naweza wamlongeile udanti. Nkomelezo weza waukuzi waidi, ");
INSERT INTO ziw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","wagamba, “Yuno nakagamba, ‘Nadaha kuivuna Nyumba nkulu ya Chohile, na kuizenga naho kwa mazuwa matatu.’ ” ");
INSERT INTO ziw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mlavyantambiko Mkulu achimala amgamba Yesu, “Nimbwani hukuhitula mbuli? Wano walonga vikukulanga weye?” ");
INSERT INTO ziw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mna, Yesu kanyamala dwi. Mlavyantambiko Mkulu amgamba, “Kwelise kwa zina dya Chohile mta ujima, chigambile hegu weye nuyo Kulisito Mkombola, Mwana ywa Chohile!” ");
INSERT INTO ziw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu amhitula, “Heye, ni saivyo ukulonga. Mna nawagambilani, kukongela haluse nammuwone Mwana ywa Mntu kekala ntendele ya kulume kwa Chohile mta nguvu zose, akeza kulanga kwa maingu ya kwembingu!” ");
INSERT INTO ziw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Niyo Mlavyantambiko Mkulu atatula izisuche zakwe na kugamba, “Mntu yuno kahuluta! Chaungilani vituhu ukuzi mwakwe? Kaulani, mwiva ivyo ahulute. ");
INSERT INTO ziw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nyuwe mwafanyanya vihi?” Wahitula, “Ana masa aungwa akomwe!” ");
INSERT INTO ziw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Niyo wamtwela mate mo uso, wamtowa. Watuhu wamtowa maihi, ");
INSERT INTO ziw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","wakagamba, “Elo, Kulisito Mkombola, lavya uwoni, ni yuhi akutoile!” ");
INSERT INTO ziw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petulo nakekala kweise kouwa. Mndima yumwenga wa chivyele ambasa, agamba, “Weye nawe na wihamwenga na Yesu ywa Galilaya.” ");
INSERT INTO ziw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mna kalemela mwa meso ya wose, akahitula, “Simanyize idyo ukulonga.” ");
INSERT INTO ziw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Umo akafosa ko lwivi, mndima mtuhu ywa chivyele kamwona, niyo awagambila wadya wantu nawehadya, “Mntu yuno nehamwenga na Yesu ywa Nazaleti.” ");
INSERT INTO ziw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petulo alemela vituhu kwa kwelisa, “Simmanyize mntu yuno!” ");
INSERT INTO ziw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Weze wekale hadodo, wantu na wehadya niyo wambasa Petulo, wamgamba, “Chindedi, weye nawe na wi yumwenga wawo, kwaviya milongele yako yalagisa kulaila Galilaya.” ");
INSERT INTO ziw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Niyo Petulo agamba, “Chohile kamanya nalonga chindedi, neligita na kwelisa uneva nalonga udanti, simmanyize uyo mntu!” Ahadya zogolo niyo dyaila. ");
INSERT INTO ziw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petulo akumbuka mbuli idya agambilwe ni Yesu, “Umo zogolo hadinati kwila, naunilemele nkanana ntatu,” Ivyo afosa kweise, niyo aila vidala. ");
INSERT INTO ziw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kwize kuche, wakulu wa walavyantambiko wakulu wose na wadalahala wa wantu wadamanya ulosi kulanga Yesu chani wamkome. ");
INSERT INTO ziw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wamtaliza minyolo, wamguha na kumwigala kwa Pilato, asagulwe ni Mkulu ywa Lumi. ");
INSERT INTO ziw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Umo Yuda, yudya amhituke, eze awone kugamba wamkantila kale Yesu, niyo awona usungu mo moyo, avuza yadya amatundu milongo mitatu, kwa wakulu wa walavyantambiko na wadalahala. ");
INSERT INTO ziw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Agamba, “Sidamanya wavu kumlavya mntu hena masa akomwe!” Mna wowo wagamba, “Idyo suwe hadimwetu idyo naumanye mweye!” ");
INSERT INTO ziw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Niyo azidula ziya izihela Kwenyumba nkulu ya Chohile, ahalawa aita akwenyulika, ");
INSERT INTO ziw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wakulu wa walavyantambiko waziguha ziya izihela, wagamba, “Sivyo vyedi mwe sigilizi yetu kuzijela izihela zino mwe shanduku dye Nyumba nkulu ya Chohile, kwaviya ni hela ya sakame.” ");
INSERT INTO ziw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Niyo walosana wevana wagule nkonde ya mufi watenda hantu hakuzikila wajeni. ");
INSERT INTO ziw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ivyo nivyo vikuleka kubula dyelo nkonde iyo yetangwa Nkonde ya Sakame. ");
INSERT INTO ziw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nivyo ichintile mbuli ya ulosi ulongigwe ni muwoni Yelemiya, akagamba, “Nawaguha vihande milongo mitatu ya hela, nayo maliho ya wantu wa Izulaeli wazumilaga kumliha, ");
INSERT INTO ziw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na wazigwila nkonde ya mufi, enga viya Zumbe anisigilaga.” ");
INSERT INTO ziw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu nakachimaliswa houso wa Pilato, mkulu ywa mkowa, ivyo mkulu wa mkowa amuza, “Weye nuyo seuta ywa Wayahudi?” Yesu amhitula, “Walonga weye,” ");
INSERT INTO ziw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mna wakulu wa walavyantambiko na wadalahala weze wamlongele hahitule mbuli yoyose. ");
INSERT INTO ziw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ivyo Pilato amuza, “Vino hukwiva izimbuli izo zose wakukulongela?” ");
INSERT INTO ziw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mna Yesu hahitule hata mbuli imwenga, itenda mkulu ywa mkowa ehelwe vidala. ");
INSERT INTO ziw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nawazwela mwe Ngasu ya Pasaka Mkulu ywa Chilumi awalekeila Wayahudi mfugwa yumwenga wakumunga. ");
INSERT INTO ziw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mwe ichipindi icho nakuna mfungwa amanyike vidala, zina dyakwe nuyo Balaba. ");
INSERT INTO ziw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ivyo wantu weze wadugane hamwenga, Pilato niyo awauza, “Mwaunga ni walekeile yuhi mwa wano waidi, Balaba hegu Yesu akwitangwa Kulisito Mkombola?” ");
INSERT INTO ziw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kwaviya na kamanya kugamba na wamlavya Yesu kwa chausa cha finju. ");
INSERT INTO ziw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Umo Pilato ekale mwe chigoda che nkanto, mkaziwe amwigailaga ulosi kugamba, “Usekutenda na mbuli na yuno awoneke ni ywedi, kwaviya dyelo siwonesa vidala mwe sozi, kwachausa chakwe.” ");
INSERT INTO ziw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mna wakulu wa walavyantambiko na wadalahala waluvya idifyo dya wantu waunge alekelwe Balaba, Yesu akomwe. ");
INSERT INTO ziw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mna Pilato auza idifyo, “Ni yuhi mwa wano waidi mkunga ni walekeile?” Wahitula, “Balaba!” ");
INSERT INTO ziw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato awauza, “Haluse nimtende mbwani Yesu akwitangwa Kulisito Mkombola?” Wose wagamba, “Asulumizwe mo msalaba.” ");
INSERT INTO ziw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mna Pilato auza, “Ni mbwani?” Kakola masa yani? Waguta vidala, “Asulumizwe mo msalaba!” ");
INSERT INTO ziw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Umo Pilato eze amanye hamna dyodyose, dikujenda naho nkumbizi nazikakonga, niyo aguha mazi, ahaka mwe mikono yakwe mwa meso ye idifyo dya wantu, agamba, “Miye simuli mwe file ya yuno mntu, nammanye wenye.” ");
INSERT INTO ziw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wantu wose wahitula wagamba, “Sakame yakwe itende mlanga mwetu hamwenga na wenetu!” ");
INSERT INTO ziw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Niyo Pilato awalekeila Balaba. Eze aheze kumunga Yesu ahutwe nkome, amlavya chani asulumizwe mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Niyo wankondo wa Pilato wamwingiza Yesu mwe nkambi ya wankondo wa Chilumi, niyo woseni wamzunguluka. ");
INSERT INTO ziw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wamvula izisuche zakwe, wamvisa suche ya Chiseuta. ");
INSERT INTO ziw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Niyo waluka chilemba cha miwa, wamvisa mo mtwi, ko mkono wakwe wakulume, wamwikiya tete. Wamfikila madi ho uso wakwe, wamtila wakagamba, “Ndamsa Seuta ywa Wayahudi!” ");
INSERT INTO ziw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wamtwela mate, waguha diya iditete, wamhuta huta nadyo ko mtwi. ");
INSERT INTO ziw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Weze wabinde kumtila, niyo wamvula idya isuche ye Chiseuta, wamvika suche zakwe, wamwigala ko kumsulumiza mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Umo wakaita, wabwila mntu yumwenga Mkilene zina dyakwe nuyo Simoni, mwikazi ywa Kilene, wamhimbiliza enule msalaba wa Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Niyo wabula hantu hakwitangwa Goligota, nuko kugamba, “Hantu ha Ngobela ya mtwi.” ");
INSERT INTO ziw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wamnywesa divai ihangaywe na chintu chisungu, mna Yesu eze alume, alemela kuinywa. ");
INSERT INTO ziw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Weze waheze kumsulumiza, niyo wasangilana suche za Yesu kwa kuzitoila tegatega. ");
INSERT INTO ziw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Niyo wekala wamdima. ");
INSERT INTO ziw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Halanga ho mtwi wakwe mo msalaba waika wandiko kukantilwa kwakwe, viwandikwa, “Yuno nuyo Yesu, Seuta ywa Wayahudi.” ");
INSERT INTO ziw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wapolaganyi waidi niyo wasulumizwa hajihi na Yesu mwe misalaba yawo, yumwenga ntendele ya kumoso mtuhu kulume. ");
INSERT INTO ziw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wantu wendile wakajinka hantu aho wamhuluta, wakasingisa singisa imitwi yawo, wakagamba, ");
INSERT INTO ziw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Weye ukudaha kutula Nyumba nkulu ya Chohile na kuizenga kwa mazuwa matatu, haluse kwehonye mwenye. Hegu weye wi Mwana ywa Chohile, sela mo msalaba.” ");
INSERT INTO ziw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Seivyo na wakulu wa walavyantambiko hamwenga na wahinya Sigilizi na wadalahala na wamtila wakagamba, ");
INSERT INTO ziw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kahonya watuhu, mna hakudaha kwehonya mwenye, hambwe yeye ni seuta ywa Waizulaeli, hegu ni chindedi na asele haluse mo msalaba naswi nachimzumile. ");
INSERT INTO ziw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nakamwegamila Chohile na kugamba hambwe ni Mwana ywa Chohile, haluse Chohile na mwambule hegu amunga.” ");
INSERT INTO ziw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Seivyo wadya wapolaganyi wasulumizwe mo msalaba hamwenga nauyo wamhuluta. ");
INSERT INTO ziw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kukongela sa mtandatu nomsi, chiza nachigubika isi yose vibindile ma sa matatu. ");
INSERT INTO ziw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ize ibule mwe sa chenda ya chisingi, Yesu niyo aila kwa izwi kulu, “Eloi, Eloi, lama sabakisani?” Nuko kugamba, “Chohile, Chohile, nimbwani kunasa?” ");
INSERT INTO ziw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Umo wadya wachimale hadya weze weve ivyo niyo wagamba, “Amwitanga Eliya!” ");
INSERT INTO ziw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yumwenga ywawo aguluka aguha lendele, aditweza mwe siki, aika mlanga mwe tete niyo amwinka anywe. ");
INSERT INTO ziw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Watuhu wagamba, “Leka, chikaule hegu Eliya neze amwambule!” ");
INSERT INTO ziw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu naho agututisa na kuhema muye wa nkomelezo. ");
INSERT INTO ziw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aho paziya dye Nyumba nkulu ya Chohile dyatatuka hagati, kukongela kulanga kubula hasi. Si niyo yengilwa nichisingisa, mayuwe makulu yatulika. ");
INSERT INTO ziw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mbila zagubuka, na wantu wa Chohile walozize wabanikaga chikale wauyuswa. ");
INSERT INTO ziw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Weze wauyuke mwe zimbila zawo, naho Yesu eze auyuke niyo wengila Yelusalemu mo mzi Ukukile, wantu walozize wawawona. ");
INSERT INTO ziw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ivyo yudya mkulu ywa wankondo, na wadya wendile wehamwenga nauyo wakamdima Yesu, weze wawone ichisingisa cheisi na mbuli zilaile, wogoha vidala, wagamba, “Chindedi mntu yuno nani Mwana Chohile.” ");
INSERT INTO ziw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hantu aho hendaga na wavyele walozize wakasinya luhale hale, awo niwadya wamtimile Yesu kukongela Galilaya, wakamsankanila. ");
INSERT INTO ziw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mgati mwawo endaga Maliyamu Magidalena, Maliyamu mami yawo dya Yakobo na Yusufu, hamwenga na mami yawo wana wa Zebedayo. ");
INSERT INTO ziw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ize ibule chisingi, eza mgoli yumwenga mntu ywa Alimataya, zina dyakwe nuyo Yusufu, endaga mwanampina ywa Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Amwitila Pilato akalombeza enkigwe umwili wa Yesu. Ivyo Pilato azumila enkigwe. ");
INSERT INTO ziw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu aguha udya umwili wa Yesu, auvisa sanda ikukile, ");
INSERT INTO ziw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","awika mndani mwe mbila yakwe asongolaga mwe luwe. Niyo afingilisa yuwe kulu divugala ulwivi lwe mbila, niyo ahalawa. ");
INSERT INTO ziw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliyamu Magidalena, na yudya Maliyamu mtuhu nawekala wakakaula kwe mbila. ");
INSERT INTO ziw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Zuwa dikutimila nani zuwa dya Kuhumula, wakulu wa walavyantambiko na Mafalisayo nawambasa Pilato, ");
INSERT INTO ziw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","wagamba, “Zumbe, chakumbuka kugamba yudya mdanti nakagamba umo endaga mjima, ‘Yanabula mazuwa matatu naniuyuke.’ ");
INSERT INTO ziw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ivyo sigila imbila idimwe dibule zuwa dya katatu chani wanampina wakwe wanase kumbawa na kuwagamba wantu kugamba kauyuka. Udanti uno we nkomelezo nautende wiha vidala kujinka udya wankongo.” ");
INSERT INTO ziw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato awagamba, “Hayani, mkamile imbila sevyo na mmanye.” ");
INSERT INTO ziw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ivyo niyo waita, wayamila imbila, wakanda hula mwe diya idiyuwe hamwenga na wadya wankondo waidi. ");
INSERT INTO ziw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dize dijinke zuwa dya Kuhumula, luvi dyakwe zuwa dya nkongo dya juma, Maliyamu Magidalena na yudya Maliyamu mtuhu waita wakukaula imbila. ");
INSERT INTO ziw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chipumpa kulaila chisingisa chikulu mwe isi, kwaviya mndima ywa kwembingu ywa Zumbe kasela kulaila kwembingu, kafingilisa diya diyuwe digubike imbila kunkanda nakudikaila. ");
INSERT INTO ziw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nakekala enga lumwemwe na suche zakwe na zikang'ala chwee. ");
INSERT INTO ziw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Vikaheza wadya wamizi we mbila wogohesa na kuzingiza, wekala saviya wabanike. ");
INSERT INTO ziw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yudya mndima ywa kwembingu ahitula, awagamba wadya wavyele, “Msekogoha, kwaviya sivimanya kugamba mwamlonda Yesu, yudya atungikwe. ");
INSERT INTO ziw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hahali hano, kauyuka, saviya alongaga. Soni mkaule hantu hadya wamwikaga. ");
INSERT INTO ziw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sunguzani mwite haluse, mka wagambile wanampina wakwe, ‘Kauyuka mwe wabanike, naho awalongwela kwita Galilaya, nuko na mumuwone!’ Elo siwagambilani kale.” ");
INSERT INTO ziw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wanyaguliza kuhalawa he mbila, wakogohesa naho wengilwa ni chinyemi chikulu. Waguluka kuwagambila wanampina wakwe mbuli idya. ");
INSERT INTO ziw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aho Yesu adugana na wadya wavyele na kuwalamsa, awagamba, “Ahoni.” Wamsogeila wamfikila madi, wamvikila. ");
INSERT INTO ziw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu niyo awagamba, “Msekogoha, hitani mkawagambile walukolo wangu waite Galilaya, nauko nuko wakunga waniwone.” ");
INSERT INTO ziw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wadya nawo umo wakaita, wankondo watuhu niyo wengila mo mzi, wawagambila wakulu wa walavyantambiko zimbuli zose zilaile. ");
INSERT INTO ziw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wadugana hamwenga na wadalahala, walosana, wawenka wankondo hela zilozize, ");
INSERT INTO ziw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wakagamba, “Gambani, kugamba wanampina wakwe weza neichilo niyo wabawa umwili wakwe umo suwe chigonile. ");
INSERT INTO ziw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Uneva liwali aneva imbuli ino, suwe nachilosane naye chani mnase kwingila mwe nkumbizi.” ");
INSERT INTO ziw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ivyo waziguha ziya zihela, wadamanya saviya wagambilwe. Imbuli iyo ijendeleza mwa Wayahudi kubula vino dyelo. ");
INSERT INTO ziw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wadya wanampina mlongo na imwenga niyo waita Galilaya kubula ko lugulu ludya wasigilwe ni Yesu. ");
INSERT INTO ziw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Weze wamwone, wamfikila madi, mna watuhu mgati mwawo na wana nkama. ");
INSERT INTO ziw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Akaheza Yesu niyo awasogeila, na awagamba, “Sinkigwa udahi wose wa kwembingu na mwe isi. ");
INSERT INTO ziw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Elo, hitani, mkawatende wantu wose we isi watende wanampina wangu, mkawabatiza kwa zina dya Tate, na Mwana na Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Muwahinye kutoza amalagiso yose niwenkileni. Naho mmanye kugamba miye nihamwenga nanyuwe mazuwa yose kubula ko udumo we isi.”");
INSERT INTO ziw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ino ni nkongelo ya Mbuli Yedi ya Yesu Kulisito, Mwana ywa Chohile. ");
INSERT INTO ziw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Iwandikwa vino mwe chitabu cha muwoni Isaya. “Chohile kagamba, ‘Namsigila msigilwa ywangu akulongwele, chani akudamanyize sila.’ ");
INSERT INTO ziw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Izwi dya mntu akuguta kwe nyika dyetanga, ‘Damanyani sila ya Zumbe, mchumize wombokelo wakwe!’” ");
INSERT INTO ziw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana alailaga kwenyika, akabatiza wantu na kuwagamba kweile masa yenyu, mbatizwe “Chohile nawalekeile masa yenyu.” ");
INSERT INTO ziw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wantu wose we isi ya Yudeya na wadya wo mzi wa Yelusalemu wambasa Yohana, wamweila masa yawo, niyo awabatiza mo mto wa Yolodani. ");
INSERT INTO ziw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana nakavala suche zisumigwe na mazoya ya ngamiya na msipi wa mkota mwe chigudi chakwe, naho nkande yakwe na ni sije na uchi wa kumbago. ");
INSERT INTO ziw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Niyo alonga akagamba, “Eza mntu kunyuma kwangu mta udahi kunijinka miye. Naho miye sikujeza hata kwinama na kufungula sigi ze vilatu vyakwe. ");
INSERT INTO ziw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Miye siwabatizani kwa mazi, mna uyo akwiza naawabatizeni kwa Muye Ukukile.” ");
INSERT INTO ziw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mazuwa ayo, Yesu niyo eza kulaila Nazaleti ya Galilaya, chani abatizwe ni Yohana mo umto wa Yolodani. ");
INSERT INTO ziw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ahadya Yesu eze afose kulaila mwa mazi, niyo awona kwembingu kwagubuka, na Muye Ukukile asela mnanga mwakwe saviya suwamanga. ");
INSERT INTO ziw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Niyo izwi dyevika kulaila kwembingu dikagamba, “Weye nuyo mwanangu huungisa, selelwa vidala na weye.” ");
INSERT INTO ziw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Akaheza Muye Ukukile amlongoza na kumwigala kwe nyika. ");
INSERT INTO ziw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kekala uko kwe nyika chipindi cha mazuwa milongo mine, kuno Shetani akamjeza. Kekala uko hamwenga na makala ya kumbago, mna wandima wa kwembingu na wakamsankanila. ");
INSERT INTO ziw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana eze ajelwe mndani mwe digeleza, Yesu niyo aita mwe isi ya Galilaya, alonga Mbuli Yedi ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Akagamba, “Chipindi chibula,” na “Useuta wa Chohile wi haguhi! Mweile masa yenyu na mzumile Mbuli Yedi!” ");
INSERT INTO ziw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Umo Yesu akajinka mnkanda mwe bahali ya Galilaya, niyo awawona walowa samaki waidi, Simoni na mlukolo ywakwe Anduleya, wakalowa samaki na lwavu mwe bahali. ");
INSERT INTO ziw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu niyo awagamba, “Nitimilani, nami naniwatende walowa wa wantu.” ");
INSERT INTO ziw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aho niyo wazasa izi nyavu zawo, niyo wamtimila. ");
INSERT INTO ziw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Eze awalongwela hadodo, awawona walukolo waidi Yakobo na Yohana, wanawe dya Zebedayo. Nendile we mwe ngalawa yawo, wakadamanya izi nyavu zawo. ");
INSERT INTO ziw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aho Yesu eze awawone, niyo awetanga, elo wamwasa tati yawe Zebedayo mwe ngalawa hamwenga na wandima wakwe na kumtimila Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na wanampina wakwe niyo waita mwe mzi wa Kapelinaumu. Dize dibule Zuwa dya Kuhumula, Yesu engilaga mwe nyumba yo kuvikila naho yakuhinyiza wantu akonga kuhinya. ");
INSERT INTO ziw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wantu wose wamwivile weheleswa na mahinyo yakwe, kwaviya hahinyize saviya wahinya Sigilizi wawo, mna enga mntu mta udahi. ");
INSERT INTO ziw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aho mntu yumwenga mta mpepo nchafu endile mndani mwe nyumba yo kuvikila akaguta, ");
INSERT INTO ziw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Kuna ulosi wani mgati mwako na suwe, Yesu ywa Nazaleti? Kwiza uchikome? Sikumanya weye wi Mkuka ywa Chohile!” ");
INSERT INTO ziw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu niyo aikwahila idya impepo, “Nyamala, naho mlawe mntu yuno!” ");
INSERT INTO ziw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mpepo idya nchafu yamsingisa na kumjela msango, aho aguta niyo yamlawa. ");
INSERT INTO ziw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Woseni niyo wehelwa, wauzana wakagamba, “Vino nimbwani? Mahinyo yano ni mahya? Mntu yuno ana udahi wa kukwamila mpepo nchafu, nazo zamwiva!” ");
INSERT INTO ziw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Elo Mbuli za Yesu niyo zajendesa kose mwe isi yose ya Galilaya. ");
INSERT INTO ziw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ahadya weze wafose mwe nyumba yo kuvikila, niyo Yesu hamwenga na Yakobo na Yohana waita kukaya kwa Simoni na Anduleya. ");
INSERT INTO ziw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mkwewe ywe chivyele ywa Simoni ne mo lusazi hakudaha. Ahadya Yesu eze abule, niyo wamgambila mbuli zakwe. ");
INSERT INTO ziw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu ambasa, amtoza mkono na kumwambiza kwinuka. Unyonje wamlekela, niyo akonga kuwasankanila. ");
INSERT INTO ziw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ize ibule chisingi zuwa dize dingile, wamwigaila Yesu wantu wose wendile wanyonje na wata mpepo. ");
INSERT INTO ziw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wantu wose wo umzi udya na wechisanya ho lwivi lwe nyumba. ");
INSERT INTO ziw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu kahonya wanyonje walozize wata manyonje yesimile na kugulusa mpepo zilozize. Halekile mpepo yoyose ilonge dyodyose, kwa viya nazimmanya ni yuhi. ");
INSERT INTO ziw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Luvi dyakwe chilochilo zuwa hedinati kutontomoka, Yesu niyo enuka na kuhalawa mwe kaya. Kaita kuse hantu hehana wantu hachinyele, na kukonga kulombeza. ");
INSERT INTO ziw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Elo Simoni na weyawe niyo wamzungula, ");
INSERT INTO ziw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","weze wamuwone, wamgamba, “Chila mntu akuzungula.” ");
INSERT INTO ziw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mna Yesu niyo awahitula, “Chiteni hantu hatuhu mwe zikaya zihaguhi. Halonge na wantu seivyo, kwaviya nivyo vilekile heza.” ");
INSERT INTO ziw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Elo, niyo aita chila hantu uko Galilaya, akalonga mwe nyumba zo kuvikila na kugulusa mpepo. ");
INSERT INTO ziw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mntu yumwenga endaga na matana na keza kwa Yesu, na kumfikila madi akamlombeza amwambize. Amgamba, “Ukaunga, wadaha kunilengusa.” ");
INSERT INTO ziw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu niyo amfila mbazi, achumiza imikono yakwe na kumdonta. Niyo amgamba, “Naunga,” “Ulenguswe!” ");
INSERT INTO ziw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ahadya matana yamlawa yudya mntu, niyo alenguswa. ");
INSERT INTO ziw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu niyo asunguza kumgamba ahalawe, ");
INSERT INTO ziw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","amgamba, “Tegeleza, usekumgambila mntu imbuli ino. Mna hita kwa mlavyantambiko akukaule, hegu kuhona chindedi, ukaheza lavya jeleko diya Musa alagise kutenda ukuzi kwa wose wawone kugamba kulenguswa.” ");
INSERT INTO ziw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mna mntu yudya niyo aita akalonga imbuli iyo chila hantu, niyo Yesu adunduga kwingila mo mzi kwa pwilili. Mna, niyo ekekala kuse hantu hechedu, wantu niyo wambasa aho kulaila chila hantu. ");
INSERT INTO ziw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yeze yajinke mazuwa majeche, Yesu niyo engila Kapelinaumu vituhu, wantu weva kugamba eyumo mwe kaya. ");
INSERT INTO ziw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Niyo wantu wamema niyo hahasigale hantu he kwikala kuse ko lwivi, kubula kolwazo. Yesu niyo alonga mbuli. ");
INSERT INTO ziw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wantu wamwenga niyo wamwigaila mntu aholomale enulwe mwe lusazi ni wantu wane. ");
INSERT INTO ziw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwaviya wantu nawamema, hawadahile kubula hajihi na Yesu. Niyo waponkola kulanga kwedigulu dye nyumba kwa hadya achimaile Yesu, niyo wamseleza no ulusazi lwakwe. ");
INSERT INTO ziw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu eze akaule uzumizi wananawo, niyo amgamba yudya mnyonje, “Mwanangu, kusizwa masa yako.” ");
INSERT INTO ziw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wahinya Sigilizi watuhu nawehadya wekala wafanyanya mwe myoyo yawo, ");
INSERT INTO ziw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nimbwani yuno mntu kalonga vino? Amhuluta Chohile! Chohile ichedu nuyo akudaha kusa masa!” ");
INSERT INTO ziw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ahadya Yesu niyo amanya mo muye wakwe viya wakufanyanya mwe myoyo yawo. Niyo awagamba, “Nimbwani mkufanyanya ivyo? ");
INSERT INTO ziw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ivyedi ni vihi, kumgamba mta kuholomala, ‘Kusizwa masa yako’, hegu kumgamba, ‘Chimala, kwetwike ulusazi lwako wite’? ");
INSERT INTO ziw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Elo naunga mmanye kugamba, Mwana ywa Mntu ana udahi wakulekela masa hano he isi.” Ivyo amgambila yudya aholomale, ");
INSERT INTO ziw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nakugambila, chimala, kwetwike ulusazi lwako wite kwe kaya yako!” ");
INSERT INTO ziw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ahadya mntu yudya niyo achimala, etwika ulusazi lwakwe, ahalawa wantu wose wakamsinya. Wose wehelwa na kumtunya Chohile, wakagamba, “Mbuli ino hachinati chiiwone!” ");
INSERT INTO ziw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu afosa, aita mnkanda mwe ibahali ya Galilaya, wantu wose wambasa, niyo akonga kuwahinya. ");
INSERT INTO ziw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Umo akajinka, amwona Lawi mwana Alifayo kekala mwe kazumba ka kulihila kodi. Yesu amgamba, “Nitimila.” Lawi niyo enuka na kumtimila. ");
INSERT INTO ziw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Umo Yesu akadya mwe nyumba ya Lawi, fyo dya wachisanya kodi na wadya nawakagambigwa wata masa nawakadya naye hamwenga na wanampina wakwe, kwaviya wantu walozize nawambasa. ");
INSERT INTO ziw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wahinya Sigilizi awamwenga wendile wa bunga dikwitangwa Mafalisayo, wamwona Yesu adya na wadya wakugambigwa wata masa hamwenga na wachisanya kodi. Niyo wawauza wanampina wakwe, “Nimbwani adya na wata masa na wachisanya kodi?” ");
INSERT INTO ziw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu eze eve imbuli iyo, awagamba, “Wantu hewekulumwa hawakunga mgangana, mna wanyonje wamunga. Sizile kuwetanga wantu wakwefanyanya kugamba wawoneka wedi kulongozi kwa Chohile, mna siza kuwetanga wata masa.” ");
INSERT INTO ziw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wanampina wa Yohana Mta kubatiza na wanampina wa Mafalisayo nawakafunga. Niyo weza wantu wamuza Yesu, “Nimbwani wanampina wa Yohana na wanampina wa Mafalisayo wafunga, mna awako hawakufunga?” ");
INSERT INTO ziw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu awahitula, “Wagonekwe kwe nyinka nawafunge vivihi na msozi wananaye? Havikudahika. ");
INSERT INTO ziw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mna mazuwa yeza msozi nauswe kwawo, naho nawafunge. ");
INSERT INTO ziw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Hahana mntu akusuma chilaka cha suche mpya mwe suche ya kale. Anadamanya ivyo, chiya chilaka ichihya chadaha kwibalanga idya suche ya kale, na kutenda hadya hantu hatatuke hatatukise. ");
INSERT INTO ziw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Naho hahana mntu akujela divai mpya mwe mikwiji ya mkota usakale. Anajela, idya divai mpya naitule idya imikwiji, niyo divai neitike na mikwiji navyo naitatuke. Divai mpya yajelwa mwe mikwiji mihya!” ");
INSERT INTO ziw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Zuwa dya Kuhumula dimwenga, Yesu na wanampina wake nawakajinka mwe zinkonde za uhemba. Umo wakajinka mwe zinkonde izo, wanampina wakwe nawakahasula maiso ya uhemba. ");
INSERT INTO ziw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafalisayo wamgamba Yesu, “Nimbwani wanampina wako wakudamanya mbuli hezikungwa mwe zuwa dya Kuhumula?” ");
INSERT INTO ziw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu awahitula, “Hamsomile hohose viya adamanyaga Daudi hamwenga na weyawe hadya wendaga na sala na hewena chintu cha kudya? ");
INSERT INTO ziw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mwe mazuwa ya Mlavyantambiko Mkulu akwitangwa Abiatali, Daudi niyo engila mwe Nyumba ya Chohile, adya migate ipagulwe kwa mbuli ya Chohile. Migate iyo na ni sigilizi idigwe ni walavyantambiko awodu wakungwa kudya imigate idya, mna Daudi kaidya na kuwapangila weyawe.” ");
INSERT INTO ziw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Niyo Yesu awagamba, “Zuwa dyo Kuhumula dikwa kwa chausa cha wantu siyo wantu kwa chausa cha zuwa dya Kuhumula. ");
INSERT INTO ziw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mvimanye Mwana ywa Mntu nuyo Zumbe ywa zuwa dya Kuhumula.” ");
INSERT INTO ziw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu niyo engila naho mwe nyumba yo kuvikila. Umo namna mntu mta mkono uholomale. ");
INSERT INTO ziw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wantu watuhu nawakalonda mbuli chani wamgwile Yesu. Ivo nawakamsinya wakaule hegu namhonye mntu yudya mwe Zuwa dya Kuhumula. ");
INSERT INTO ziw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu amgamba yudya mta umkono uholomale, “Chimala hagati.” ");
INSERT INTO ziw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Niyo awauza, “Sigilizi zachunga chidamanye vihi mwe Zuwa dya Kuhumula, kudamanya mbuli yedi hegu ihile? Kuhonya ujima wa mntu hegu kuukoma?” Mna wowo niyo wanyamala dwi! ");
INSERT INTO ziw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu ahituka kuno na kuno na kuwasinya kwa maya. Awafila mbazi kwo udala we myoyo yawo. Niyo amgamba yudya mta kuholomala, “Chumiza umkono wako.” Naye adamanya ivyo, umkono wakwe wata mjima naho. ");
INSERT INTO ziw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wadya Mafalisayo niyo wafosa heise he nyumba nkulu ya Chohile, ahadya wadugana na wantu wa Helode, wakonga kulonda sila ya kumkoma Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu hamwenga na wanampina wakwe niyo waita Galilaya. Fyo dya wantu dyamtimila Yesu kulaila mwe si za Galilaya na Yudeya, ");
INSERT INTO ziw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","na Yelusalemu na Idumeya na ng'ambo yo mto wa Yolodani na ntendele zose za Tilo na Sidoni. Wantu wose awa nawambasa Yesu kwaviya naweva mbuli adamanye. ");
INSERT INTO ziw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kwa viya wantu nawatendesa, Yesu niyo awagamba wanampina wakwe wamwikiye ngalawa chani wantu wanase kumvigaviga. ");
INSERT INTO ziw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kahonya wantu walozese, ivyo wadya wose wendile wanyonje nawakafintana chani wamdonte. ");
INSERT INTO ziw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na chila mta mpepo nchafu eze amwone Yesu, kagwa hasi na kuguta, “Weye wi Mwana Chohile.” ");
INSERT INTO ziw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mnalo Yesu niyo azikwamila mpepo nchafu zisekulonga kugamba yeye na ni yuhi. ");
INSERT INTO ziw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu niyo akwela holugulu, awetanga wadya awaungile, nawo wamtimila. ");
INSERT INTO ziw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Niyo awasagula mlongo na waidi mgati mwawo watende wasigilwa, awagamba, “Siwasagula chani mkalonge kwa wantu,” ");
INSERT INTO ziw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","nanywi namtende na udahi wa kuwalavya wantu mpepo. ");
INSERT INTO ziw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wano nawo awasagule. Simoni Yesu kamwinka zina dya Petulo; ");
INSERT INTO ziw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo na mlukolo ywakwe Yohana wana Zebedayo Yesu kawenka zina dya Boanege, nikugamba “Wantu wa Mlulumo”. ");
INSERT INTO ziw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anduleya, Filipo, Batolomayo, Matayo, Tomaso, Yakobo mwana Alifayo, Tadeyo, Simoni wa Zelote, ");
INSERT INTO ziw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Isikaliyote, amhituke Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu niyo auya kaya. Naho atimilwa ni fyo dya wantu vitendile yeye hamwenga na wanampina wakwe wasekudaha kudya nkande. ");
INSERT INTO ziw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Walukolo wakwe weze weve imbuli iyo, niyo waita wakamgwile kwaviya wantu walozize nawakagamba, “Ni mchilalu!” ");
INSERT INTO ziw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wahinya Sigilizi wamwenga walaile Yelusalemu nawakagamba, “Ana Belizebuli! Uyo ni mkulu ywa mpepo amwinkile udahi wa kulavya mpepo.” ");
INSERT INTO ziw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu niyo awetanga na kusimwila nawo kwa mliganyo, “Vino Shetani adaha kumgulusa Shetani mnyawe? ");
INSERT INTO ziw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wantu wa useuta umwenga wakatowana wenye useuta uwo naugwe. ");
INSERT INTO ziw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hegu nyumba inekala mwe mafyo na kuhigana, nayo yagwa. ");
INSERT INTO ziw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ivyo uzumbe wa Shetani hegu unesenta wenye kwa wenye, naugwe na kubindilikila. ");
INSERT INTO ziw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Hahana mntu akudaha kwingila mwe nyumba ya mta nguvu na kuguha vintu vyakwe henati kumnyinya mntu uyo. Niyo adaha kuguha vintu vyakwe. ");
INSERT INTO ziw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nawagambilani chindedi, wantu wadaha kusizwa masa na kufulu zawo zose na mahuluto yose kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mna akunga ahuluta Muye Ukukile, halekeilwe masa yakwe, kwaviya kadamanya wihi wa mazuwa yose.” ");
INSERT INTO ziw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu nakalonga ivyo kwaviya wantu watuhu nawagamba, “Ana mpepo nchafu.” ");
INSERT INTO ziw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nine na walukolo wakwe Yesu niyo weza. Wachimala heise na kusigila Yesu etangwe. ");
INSERT INTO ziw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yesu nakazungulukwa ni fyo dya wantu. Wamgamba, “Nyokwe na walukolo wako we heise, wakulonda.” ");
INSERT INTO ziw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu awahitula, “Mnala ni yuhi? Naho niwahi walukolo wangu?” ");
INSERT INTO ziw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Niyo asinya wantu wamzunguluke na kugamba, “Wano nawo wamnala na walukolo wangu! ");
INSERT INTO ziw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mntu yoyose akudamanya viya akunga Chohile, nuyo mlukolo ywangu na lumbu dyangu na mnala.” ");
INSERT INTO ziw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu niyo naho akonga kuhinya mnkanda mwe diziwa dya Galilaya. Fyo dya wantu nadimzunguluke naditendesa, vikatenda akwele mwe ngalawa. Wantu nawachimala mnkanda mwe isi. ");
INSERT INTO ziw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kawahinya mbuli zilozize kwa miliganyo. Mwa mahinyo yakwe niyo awagamba. ");
INSERT INTO ziw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tegelezani; Handaga na mntu kakumyaga mbeyu. ");
INSERT INTO ziw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Umo akamyaga izimbeyu, izimwenga zigwela mwe sila, wadege weza na kuzidya. ");
INSERT INTO ziw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Izimwenga zigwela mweluwe hene ulongo mjeche. Aho niyo zasunguza kuhota kwaviya nahana ulongo mjeche. ");
INSERT INTO ziw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mna zuwa dize dilawe, izimpotela zatoigwa ni zuwa, zinyuluka kwaviya maizi hayengile hasi. ");
INSERT INTO ziw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeyu ntuhu zagwelaga mgati mwe miwa, idya imiwa niyo yasuka na kuzifinta niyo hazeleke. ");
INSERT INTO ziw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mna mbeyu ntuhu zigwela mwe ulongo wedi. Niyo zahota na kukula na kulavya ulozo, izimwenga zilavya mbeyu nkanana milongo mitatu, nkanana milongo mtandatu izimwenga nkanana gana.” ");
INSERT INTO ziw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu awagamba, “Tegelezani, mta magutwi neve.” ");
INSERT INTO ziw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu umo neichedu, wantu watuhu wamwivile hamwenga na wanampina wakwe mlongo na waidi niyo wamgamba awatambalisize imiliganyo iyo. ");
INSERT INTO ziw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu awahitula, “Nyuwe mwinkigwa kubunkula mbuli zifisigwe zo Useuta wa Chohile. Mna wadya we kweise weva kwa miliganyo. ");
INSERT INTO ziw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chani, ‘Wakaule, mna wasekuwona, weve, mna wasekumanya. Uneva wanamanya wadaha kumhitukila Chohile, niyo awalekeila masa yawo.’ ” ");
INSERT INTO ziw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu niyo awauza, “Hammanyize mliganyo uno? Haluse namdahe zeze kumanya miliganyo mituhu?” ");
INSERT INTO ziw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mbeyu ihandigwe nu mhandi ni mbuli ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wantu wamwenga wekala saviya vilaile mwe izimbeyu zigwele mwe sila, weva mbuli yedi ya Chohile, aho Shetani awezila na kwiilavya mwe myoyo yawo. ");
INSERT INTO ziw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wantu watuhu waligana saviya mbeyu zigwele mwe luwe. Waneva imbuli, waihokela kwa chinyemi. ");
INSERT INTO ziw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mna kwa viya hawana maizi, wajijimiza chidogo. Kunalaila nkunto na masulumizo kwachausa che imbuli iyo, ahadya wauya kunyuma. ");
INSERT INTO ziw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wantu watuhu waligana saviya vilaile mwe mbeyu zigwele mwe miwa. Wano ni wadya wakwiva imbuli, ");
INSERT INTO ziw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mna nkunto za mwe isi ino na udanti wa ugoli, na tama zesimile zinawengila, vyafinta udya ulosi wi mndani mwawo na kuchinda kweleka matunda. ");
INSERT INTO ziw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mna watuhu waligana saviya vilaile mwe mbeyu zigwele mwe ulongo wedi. Weva imbuli, waihokela na kweleka, wamwenga nkanana milongo mitatu, wamwenga nkanana milongo mtandatu na wamwenga nkanana gana. ");
INSERT INTO ziw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ajendeleza kulonga, “Togolani, kuna akudaha kwingiza taa kunyumba na kuigubika na ntangulu hegu kuika kwedivungu? Togola hakuika halanga he chiya cha kwikiya taa? ");
INSERT INTO ziw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chochose chifisigwe nachilondolwe, na chiya chigubikwe nacho nachigubulwe. ");
INSERT INTO ziw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tegelezani, mta magutwi neve!” ");
INSERT INTO ziw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Awagamba naho, “Tegelezani vyedi viya mkwiva! Viya mkuwadamanyiza wenyu, nivyo nanywi mkunga mdamanyizwe ni Chohile, naho vitendese. ");
INSERT INTO ziw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kwaviya mntu mta chintu nongezezwe, mna yudya hena chintu, nahokwe hata chiya chidodo ananacho.” ");
INSERT INTO ziw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ajendeleza kugamba, “Useuta wa Chohile uligana saviya mntu ahandile mbeyu mwe nkonde. ");
INSERT INTO ziw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nechilo agona, nomsi emeso. Mbeyu zahota na kukula, mna hamanyize vilaila vivihi. ");
INSERT INTO ziw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ulongo wenye wazitenda mbeyu zikule na kweleka, nkongo zalavya mani mateke, vikajika zabwalika maiso, vikajika zeleka ngano. ");
INSERT INTO ziw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Izimbeyu zinatoga, mntu uyo aguha nyengo yakwe na kwita kuvuna kwaviya ulozo ubula.” ");
INSERT INTO ziw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu auza, “Useuta wa Chohile chonga chiugambe wikala saviya mbwani? Ni mliganyo uhi ukudaha kuutambalisa ichindedi? ");
INSERT INTO ziw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Waligana na mbeyu ndodo ya haladali, mbeyu ndodo kujinka zose zikuhandwa mwe isi. ");
INSERT INTO ziw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mnalo ikahandwa, yahota, niyo yakula, yatenda ziti kulu. Dyatenda na matambi makulu vikuleka wadege wo ulanga wadaha kuzenga masasa mwa matambi yakwe.” ");
INSERT INTO ziw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu asimwila na wantu mbuli yakwe kwa miliganyo ilozize saino, kawagambila viya wakudaha wamwive. ");
INSERT INTO ziw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Halongile nawo mbuli yoyose hejeile miliganyo. Mna hadya endile na wanampina wakwe du, kawagambila chila chintu. ");
INSERT INTO ziw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mwe dizuwa idyo nechisingi, Yesu awagamba wanampina wakwe, “Chitambuke ntendele ya kaidi ye idiziwa.” ");
INSERT INTO ziw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wadyasa idifyo dya awantu, wanampina wengila mwe ngalawa umo neli Yesu. Na hana ngalawa ntuhu naziyaho. ");
INSERT INTO ziw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kulaila nkung'unto, mawimbi ya mazi yajubwanisa ingalawa, nayo yakonga kumema mazi. ");
INSERT INTO ziw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu na ekunyuma kwe ngalawa, kagona mtwi wakwe wigama mwe mto. Wanampina wakwe wamwinula na kumgamba, “Mhinya, vino hukuwona chasila?” ");
INSERT INTO ziw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu niyo achimala, akwahila idya inkung'unto na kuyagamba mawimbi, “Tongomalani dwi!” Elo inkung'unto niyo yanyamala, niyo kwaziziwala. ");
INSERT INTO ziw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu awauza wanampina wakwe, “Nimbwani mkogoha? Hamnati kutenda na uzumizi?” ");
INSERT INTO ziw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mna wengila woga utendese, walosana wenye, “Yuno ni mntu ywani? Hata mpeho na mawimbi vyamwiva!” ");
INSERT INTO ziw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na wanampina wakwe wabula ntendele ya kaidi ye idiziwa dya Galilaya kwe isi ya Wagelasi. ");
INSERT INTO ziw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu eze asele mwe ngalawa, adugana na mntu mta mpepo nchafu akulaila kwe zimbila. ");
INSERT INTO ziw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mntu uyo naakekala kwe zimbila, hahalaile mntu adahile kumtaliza naho hata kwa minyolo. ");
INSERT INTO ziw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nkanana zilozize viga vyakwe ne mikono navinyinywa na minyolo ya chuma, mna kadumula iminyolo idya na kuvuna viya ivifungo vye chuma nendile hahana mntu mta nguvu za kumgwila. ");
INSERT INTO ziw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chilo na msi nakekala kwe izimbila izo na mwa magulu, akaguta kuno akesenga na mayuwe. ");
INSERT INTO ziw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Eze amwone Yesu kwa hale, amgulukila na kumfikila madi. ");
INSERT INTO ziw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Agutila kwa izwi kulu, “Yesu Mwana Chohile ekulanga, waunga mbwani kwangu? Kwelise kwa zina dya Chohile kugamba honisulumize!” ");
INSERT INTO ziw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nakalonga ivyo kwa viya Yesu nakamgamba, “We mpepo nchafu, mlawe mntu uyu!” ");
INSERT INTO ziw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu amuza, “Zina dyako nuyo yuhi?” Amhitula, “Zina dyangu ni Fyo, kwa viya chiloza.” ");
INSERT INTO ziw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Niyo amlombezesa asekuzigala ziya mpepo zihiye kuse mwe isi idya. ");
INSERT INTO ziw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ho luwala lwo lugulu na hana fyo kulu dya nguluwe dikudimwa. ");
INSERT INTO ziw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mpepo ziya zamlombeza Yesu zikagamba, “Chigale mwe difyo dye zinguluwe, uchilekele chikengile mwe izo.” ");
INSERT INTO ziw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu niyo azumila ziya mpepo nchafu zingile mwe zinguluwe izo. Fyo jima dye zinguluwe milongo magana maidi dyasela kwa nguluko mwe diziwa na kudidimila mwa mazi. ");
INSERT INTO ziw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wadimi we zinguluwe izo waguluka na kuisimwila imbuli iyo mwe imizi na mwe zinkonde. Wantu waita wakaule icho chilaile. ");
INSERT INTO ziw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Weze wabule kwa Yesu, wamwona yudya mntu endaga na fyo dya mpepo kekala, kavala suche zakwe vitana na nyanyi zakwe zimuwiya. Wantu wose niyo wogoha. ");
INSERT INTO ziw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wadya wawone diya dilaile, niyo wawagambila wantu chintu chimlaile yudya namta mpepo ne imbuli ye zinguluwe. ");
INSERT INTO ziw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wantu niyo wamlombeza Yesu ahalawe mwe isi yawo. ");
INSERT INTO ziw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu hadya akakwela mwe ngalawa, yudya nendile mta mpepo amlombeza waitanye. ");
INSERT INTO ziw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mna Yesu niyo alemela, amgamba, “Hita kwenyu kaya, kawagambile visimo udamanyizwe ni Zumbe na viya akufile mbazi.” ");
INSERT INTO ziw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ivyo mntu yudya ahalawa, aita mwe si ikwitangwa Dekapoli kugamba Mizi Mlongo na kuwagambila wantu viya Yesu amtendele. Na wose wevile wehelwa. ");
INSERT INTO ziw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu eze aite vituhu ntendele ya kaidi ye diziwa kwa ngalawa, fyo kulu dya wantu niyo dyammemela mnkanda mwe diziwa. ");
INSERT INTO ziw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Alaila mntu yumwenga akwitangwa Yailo, yumwe mwe wakulu we nyumba yo kuvikila Chohile. Eze amwone Yesu, amfikila madi, ");
INSERT INTO ziw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","amlombezesa akamgamba, “Mwanangu ywa chiche ehaguhi na kubanika. Nakulombeza chite, ukamjelekele mikono ahone atende mjima.” ");
INSERT INTO ziw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu aitanya na Yailo. Fyo dya wantu niyo dyamtimila Yesu na kumfintafinta. ");
INSERT INTO ziw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ahadya nahana mvyele yumwenga endile na unyonje wa kulawa sakame mihilimo mlongo na midi. ");
INSERT INTO ziw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mvyele yudya nakatumbwazika vidala kwa wagangana walozize. Kazisa hela zakwe zose, mna hawone vyedi kalumiswa chipindi chose. ");
INSERT INTO ziw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yudya mvyele eze eve mbuli za Yesu, niyo omboka mgati mwe difyo dya wantu. Amwitila Yesu kunyuma na kukufya isuche yakwe ");
INSERT INTO ziw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","akelongela mo moyo wakwe, “Ninakufya du isuche yakwe, nahona.” ");
INSERT INTO ziw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Eze akufye isuche ya Yesu, aho sakame niyo yaleka kumlawa, awona kugamba kahona unyonje wakwe. ");
INSERT INTO ziw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ahadya Yesu abunkula kugamba nguvu zimlawa. Awahitukila wantu na kuwauza, “Ni yuhi akufize isuche yangu?” ");
INSERT INTO ziw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wanampina wakwe wamhitula, “Waona wantu ivyo wakukufintafinta, nawe wauza ni yuhi akukufize?” ");
INSERT INTO ziw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mna Yesu niyo ajendeleza kupagasa kuno na kuno amuwone mntu atendile viya. ");
INSERT INTO ziw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yudya mvyele niyo abunkula dimbwile. Ivyo niyo ambasa Yesu akazingiza kwa kogoha, amfikila madi na kumgambila ichindedi chose. ");
INSERT INTO ziw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu amgamba, “Mwanangu, uzumizi wako ukuhonya. Jenda mpeho naho utende mjima.” ");
INSERT INTO ziw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Umo Yesu henati kukomeleza kulonga ulosi uwo, weza wantu kulaila kwa yudya mkulu ywe nyumba yo kuvikila na kumgamba, “Mndele ywako kabanika. Nimbwani naho ukumtubwanisa Mhinya?” ");
INSERT INTO ziw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu eze eve yadya walongile, niyo abela amgamba yudya mkulu we nyumba yo kuvikila, “Usekogoha, weye zumila du.” ");
INSERT INTO ziw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu haungile atimilwe ni mntu yoyose, mna Petulo na Yakobo na Yohana mlukolo ywa Yakobo. ");
INSERT INTO ziw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Weze wabule kwa yudya mkulu ywe nyumba yo kuvikila, Yesu awona wantu hewekwivana, naho eva wakwila na kulomboleza. ");
INSERT INTO ziw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu engila mnyumba, awagamba, “Nimbwani hamkwivana naho mwaila? Umwana habanike, kata kugona du!” ");
INSERT INTO ziw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mnalo wamseka, niyo awalavya wose kuse, awaguha tati ya mntu na mami yakwe na wadya wanampina watatu. Wengila kwe chumba wamwikiye yudya umwana. ");
INSERT INTO ziw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Amtoza mkono amgamba, “Talita koumi!” Nukokugamba, “Mndele, nakugamba inuka!” ");
INSERT INTO ziw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ahadya mndele yudya niyo achimala na kukonga kujenda. Mndele yudya nana mihilimo mlongo na midi. Ize ilaile ivyo, chila yumwenga niyo ehelwa vidala. ");
INSERT INTO ziw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mna Yesu niyo awaunga wasekuwagambila wantu imbuli idya. Niyo awagamba, “Mwinkeni nkande mndele uyu adye.” ");
INSERT INTO ziw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu niyo ahalawa hadya, aita ko mzi wakwe na wanampina wakwe niyo wambasa. ");
INSERT INTO ziw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mwe Zuwa dya Kuhumula, akonga kuhinya mwe nyumba yo kuvikila. Wantu walozize wamwivile, niyo wamwehelwa, wauzana, “Yose yano kayalavya hi? Ni nguvu zani enkigwe kubula kudamanya mpituko zino? ");
INSERT INTO ziw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Vino yuno suyo yudya msongola, mwana Maliyamu na lumbu dya Yakobo na Yusufu na Yuda na Simoni? Walumbuze hawehano hamwenga na suwe?” Niyo wamlemela. ");
INSERT INTO ziw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu awagamba, “Muwoni atunywa chila hantu, mnalo kwawe na walukolo wakwe na kwe nyumba yakwe hakutunywa.” ");
INSERT INTO ziw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu hadamanye mpituko yo yose hadya, mna kajelekela wanyonje wajeche mikono na kuwahonya. ");
INSERT INTO ziw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kehelwa vidala, kwa viya wantu hawazumile. Aho Yesu niyo aita mwe zikaya zi mjihi, akahinya wantu. ");
INSERT INTO ziw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Awetanga wadya wanampina mlongo na waidi, awasigila waidi idi. Awenka udahi mwe mpepo nchafu. ");
INSERT INTO ziw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Naho nakawagamba, “Msekuguha shanduku hegu chochose mwe ntambo yenyu mna nkome du. Msekuguha nkande hegu mkwiji hegu hela mwe misipi yenyu. ");
INSERT INTO ziw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Valani vilatu, mna mse kuguha suche ntuhu. ");
INSERT INTO ziw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nyumba yoyose mkunga mhokelwe, ikalani aho kubula hadya mkuhalaila mo mzi uwo. ");
INSERT INTO ziw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Naho mnengila mwe mzi niyo hamhokelwe hegu hamtegelezwe, halaweni, naho mkung'unte tifili mwe viga vyenu. Idyo nadite ukuzi mwawo.” ");
INSERT INTO ziw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Niyo waita na kuwagambila wantu weile masa yawo. ");
INSERT INTO ziw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wawalavya wantu mpepo zilozize na kuwakuluguta mavuta wanyonje walozize na kuwahonya. ");
INSERT INTO ziw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Helode keva izimbuli izo kwa chausa cha zina dya Yesu nadimanyika chila hantu. Wantu watuhu nawakagamba, “Ni Yohana Mta kubatiza kauyuka. Nivyo vikuleka ana nguvu za kudamanya mpituko.” ");
INSERT INTO ziw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Watuhu wagamba, “Yuno ni Eliya.” Mnalo watuhu wagamba, “Ni muwoni saviya wadya wawoni we ichikale.” ");
INSERT INTO ziw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helode eze eve, agamba, “Yuno ni Yohana Mta kubatiza nimkantile umtwi kauyuka!” ");
INSERT INTO ziw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Helode mwenye nakasigila Yohana agwilwe ajelwa mndani. Kadamanya ivyo kwa chausa cha Helodiya mkaziwe. Mvyele uyo na ni mkaza Filipo, mlukolo ywa Helode. ");
INSERT INTO ziw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana Mta kubatiza nakamlonga Helode ulo na ulo, “Sigilizi zagamba, havikungigwa weye kuguha mkaza mlukolo ywako.” ");
INSERT INTO ziw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ivyo Helodiya nana maya mo moyo kwa chausa cha Yohana, nakalonda amkome. Mnalo niyo adunduga kwa chausa cha Helode. ");
INSERT INTO ziw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode nakamogoha Yohana kwa viya nakamanya Yohana ni mntu mta kuwoneka ywedi kulongozi kwa Chohile naho ni mkuka, ivyo nakamwamila. Nakaungisa kumtegeleza, hatahegu nakakangawala chila nkanana akamwetegeleza. ");
INSERT INTO ziw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Helodiya ketukila niyo apata luhenyo lwa kumkoma, yendaga zuwa dya kwelekwa kwa Helode, chipindi adamanyaga ngasu ya nkande kwa wachimaila wo ulongozi wakwe na wakulu wawa nkondo na wakulu wa Galilaya. ");
INSERT INTO ziw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwana ywa Helodiya kengila, niyo aseziga vyedi, kawelesesa Helode na wajeni wakwe. Seuta amgamba uyo mndele, “Nilombeza chochose ukunga, nami nahwinke.” ");
INSERT INTO ziw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Helode elisa, “Nahwinke chochose ukunga, hata ukaunga inusu yo useuta wangu!” ");
INSERT INTO ziw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yudya mndele niyo afosa akamuuze nine, “Nunge chibwani?” Nine amhitula, “Lombeza mtwi wa Yohana Mta kubatiza.” ");
INSERT INTO ziw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yudya mndele ahadya akumpuka kubula kwa seuta na kumgamba, “Naunga uninke ivino haluse umtwi wa Yohana Mta kubatiza mwe sahani.” ");
INSERT INTO ziw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Seuta niyo engilwa ni usungu vidala, mna kadunduga kulemela kwa viya nakelisa, na wose wendile wehadya nawamwiva. ");
INSERT INTO ziw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ahadya niyo seuta asigila mnkondo amwigaile umtwi wa Yohana Mta kubatiza. Niyo mnkondo uyo aita kwe chifungo na kumkanta Yohana umtwi. ");
INSERT INTO ziw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Awigala umtwi mwe sahani na kumwinka yudya mndele. Naye niyo amwinka nine. ");
INSERT INTO ziw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wanampina wa Yohana weze weve imbuli iyo, waita kuguha umwili wakwe na kuuhamba. ");
INSERT INTO ziw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wasigilwa wachintana kwa Yesu na kumgambila vyose wadamanye na kuhinya. ");
INSERT INTO ziw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nakuna wantu walozize wendile wakengila na kufosa, ivyo vimtenda Yesu na wanampina wakwe waswese luhenyo lwa kudya. Yesu awagamba, “Chiteni hantu hechedu chitende wenye, chani mhumule hadodo.” ");
INSERT INTO ziw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Niyo wakwela mwe ngalawa wowo wenye, waita hantu hechedu. ");
INSERT INTO ziw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mnalo wantu wenji wawawona wakahalawa nakuwamanya. Niyo wantu kulaila mwe mizi yose waguluka, wawalongwela kubula. ");
INSERT INTO ziw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu eze asele mwe ingalawa, awona fyo dya wantu. Niyo awafila mbazi kwa viya wekala saviya ngoto hezina mdimi. Niyo akonga kuwahinya mbuli zilozize. ");
INSERT INTO ziw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Umo dikahunga, wadya wanampina wambasa na kumgamba, “Hano chili chi he nyika, zuwa nadyo dyaswa. ");
INSERT INTO ziw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Walage wantu waite mwe zinkonde ne zikaya zimjihi wakagule chochose cha kudya.” ");
INSERT INTO ziw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu awahitula, “Wenkeni nyuwe nkande wadye.” Wamuza, “Wonga chikagule migate ya hela zilozize zikulihwa mndima kwa miezi mnane hela miezi mnane hegu hela ya dinali magana maidi, chiwenke wadye?” ");
INSERT INTO ziw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu awauza, “Mna migate mingahi? Hitani mkakaule.” Weze wamanye, wamgamba, “Kuna migate mishano na samaki mbili.” ");
INSERT INTO ziw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu niyo awagamba wanampina wakwe wawagambile wantu wekale mabungabunga mwa mani maisi. ");
INSERT INTO ziw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wantu niyo wekala hasi mwe mabungabunga hano maganagana, hano mwe milongo mishanoshano. ");
INSERT INTO ziw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Niyo Yesu aguha idya migate mishano na ziya samaki mbili, asinya kulanga kwembingu na kumjimbika Chohile. Aibesula idya migate na kuwenka wanampina wakwe wawenke wantu. Awapangila wantu wose na wadya wasamaki waidi. ");
INSERT INTO ziw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Chila yumwe kadya na kwiguta. ");
INSERT INTO ziw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wanampina walogota mabesu ye migate na samaki yasigale ntangulu mlongo na mbili. ");
INSERT INTO ziw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wagosi awodu wadile nendile ni magana milongo mishano. ");
INSERT INTO ziw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ahadya Yesu awaunga wanampina wakwele mwe ngalawa wamlongwele Betisaida, ntendele ya kaidi ye diziwa. Yeye nendile akawalaga wantu waite. ");
INSERT INTO ziw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Eze awalage wadya wantu, niyo aita he kagulu akalombeze. ");
INSERT INTO ziw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Zuwa dize diswe, ngalawa ne imgati mwe diziwa, mna Yesu ne ichedu mo mjingu. ");
INSERT INTO ziw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Awawona wadya wanampina wakwe wakavumba mwe ngalawa, kwa viya nawakahigana na nkung'unto. Mavukuvuku, awalaila kuno akajenda mlanga mwa mazi. Nakaunga awajinke, ");
INSERT INTO ziw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","mna weze wamwone ajenda mlanga mwa mazi, waguta, wakafanyanya ni chizuli. ");
INSERT INTO ziw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wose niyo wengila woga weze wamwone. Ahadya Yesu alonga nawo, awagamba, “Msekogoha! Ni miye! Kwenkeni moyo!” ");
INSERT INTO ziw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aho eingila mwe ingalawa umo naweli, na inkung'unto niyo yaleka. Wanampina wose wehelwa vitendese ");
INSERT INTO ziw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kwaviya nahawanati kumanya vyedi imana yakwe yo kuwalisa wadya magana milongo mishano, myoyo yawo na ni midala kumanya. ");
INSERT INTO ziw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Watambuka idiziwa na kubula ntendele ya kaidi ye isi ya Genesaleti. Aho niyo wajela nanga ingalawa. ");
INSERT INTO ziw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Weze walawe mwe ingalawa, ahadya niyo wantu wambunkula Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Niyo wagulukila mwe mizi, kose wevile Yesu kawoneka. Wamwigaila wanyonje wawo mwe zisazi. ");
INSERT INTO ziw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Chila hantu Yesu abwile mwe zikaya hegu mizi hegu mwe zinkonde wantu wegala wose wendile wakalumwa mwa magwilo. Wamlombeza vikadahika wakufye idiheto dyakwe. Wose wakuvize wahona. ");
INSERT INTO ziw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayo na wahinya sigilizi wamwe walaile Yelusalemu wadugana kulongozi kwa Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Niyo wawawona wanampina wamwenga wa Yesu nawakadya nkande na mikono haikukile kugamba hawahakile mikono yawo saviya mazwela ya Mafalisayo waungile wantu wahake. ");
INSERT INTO ziw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mafalisayo na Wayahudi nawatongela mahinyo ya wadalahala wawo, hawakudya nkande kubula wahake mikono yawo kubula mwe vinko. ");
INSERT INTO ziw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Naho hawakudya chochose chikulawa kwe digwilo kubula chinde kusuntwa. Nawakatimila mahinyo yalozize matuhu wahokele, saviya kusunta vyedi bakuli, sazi, nyungu na viya. ");
INSERT INTO ziw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Elo Mafalisayo na wahinyi wa sigilizi wamuza Yesu, “Nimbwani wanampina wako hawakutimila mahinyo chasizwe ni wadalahala wetu? Mna wadya na mikono mizavu?” ");
INSERT INTO ziw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu awahitula, “Isaya nakalonga uwoni wedi kwenyu! Wasongaganyi nyuwe, saviya awandike, ‘Chohile agamba, wantu wano wanitunya mwe milomo yawo, mna myoyo yawo ihale na miye. ");
INSERT INTO ziw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wanivikila vyabule, kwaviya wahinya malagizo ya wantu, wakazitenda saviya Sigilizi za Chohile!’ ");
INSERT INTO ziw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Nyuwe mwasenta sigilizi za Chohile, mwatoza mahinyo ya wantu.” ");
INSERT INTO ziw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu niyo ajendeleza kulonga, “Mmanya pwilili ivyo mlemele Sigilizi za Chohile chani mtoze mahinyo yenyu wenye. ");
INSERT INTO ziw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa alagizaga, ‘Wategelezeni tati zenyu na mami zenyu,’ naho, ‘Mntu yoyose akunga amligite tati yakwe hegu mami yakwe akomwe.’ ");
INSERT INTO ziw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mna nyuwe mwahinya kugamba mntu mta chochose cha kumwambiza tati yakwe hegu mami yakwe, mna agamba, ‘Chintu chino Kolobani’ kugamba, ni malavyo kwa Chohile, ");
INSERT INTO ziw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","niyo mwagamba mntu uyu aleke kumwambiza tati yakwe hegu mami yakwe. ");
INSERT INTO ziw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kwe isila ino, mahinyo yenyu mkuhinyana yabela Mbuli ya Chohile. Naho kuna matuhu yalozize mkuhokelezana mkudamanya saayo.” ");
INSERT INTO ziw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu niyo etanga fyo dya wantu vituhu na kuwagamba, “Nitegelezani wose, naho mnive. ");
INSERT INTO ziw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hakuna chintu chikumwingila mntu chikudaha kumtenda atende mzavu. Mna chikumtenda ivyo ni chiya chikulawa mndani mwakwe. ");
INSERT INTO ziw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mta magutwi, neve!” ");
INSERT INTO ziw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eze ase idifyo dya wantu na kwingila mwe nyumba, wanampina wakwe wamuza awatambalise mliganyo wo lusimo ludya. ");
INSERT INTO ziw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu awagamba, “Vino hata nyuwe nanywi hamna fanyanyi? Hamvimanyize kugamba hachihali chintu chikulawa kuse chikumwingila mntu chikudaha kumtenda mzavu, ");
INSERT INTO ziw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kwaviya hachikwingila mo moyo wakwe mna mwe nda yakwe niyo chafosa mo mwili kwa sila ya kwe choo.” Kwa kulonga ivyo, Yesu kalagisa kugamba nkande zose zilenguswa zidigwe. ");
INSERT INTO ziw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Niyo ajendeleza kulonga, “Chikumtenda mntu mzavu ni chiya chikumlawa mndani mwakwe. ");
INSERT INTO ziw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwaviya mwe moyo wa mntu kwalaila fanyanyi zihiye na chilanga na ubavi na kukoma, ");
INSERT INTO ziw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","na uchilanga na tama zihiye na ukankalu na uvambi na finju na kuhuluta na kweduvya na uhezi, ");
INSERT INTO ziw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Vyose vino nivyo vikumtenda mntu atende mwihi.” ");
INSERT INTO ziw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu niyo afosa, aita mwe isi ihajihi na mzi wa Tilo. Kengila mwe nyumba, na haungile mntu yoyose amanye vino ehadya, mna havidahike. ");
INSERT INTO ziw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mvyele yumwenga endaga na mwanakwe ywa chiche mta mpepo nchafu, keva mbuli za Yesu niyo ambasa ahadya na kumgwela mwe viga. ");
INSERT INTO ziw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mvyele uyo endaga Mgiliki, mwelekwa ywa mkowa wa Silofoinike si ya Siliya. Amwila Yesu aguluse mpepo zi mwa mwanawe. ");
INSERT INTO ziw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mna Yesu amhitula, “Ndakuwaleka wana wa mnyumba wegute. Kwaviya sivyo vyedi kuguha nkande ya wana na kudwila makuli.” ");
INSERT INTO ziw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mvyele uyo niyo amhitula, “Zumbe,” Walonga chindedi, “Hata makuli yazwela kudya nkombelezo ziya zihasi mwe meza.” ");
INSERT INTO ziw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu amgamba, “Kwa ivyo uhitule, uya kaya, nokabwile mpepo imlawa mwanawo!” ");
INSERT INTO ziw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yudya mvyele kauya kukaya na kumbwila mwanawe kagona mo lusazi, idya mpepo nananayo imlawa kale. ");
INSERT INTO ziw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu ahalawa ho mzi wi haguhi na Tilo, na kujinkila Sidoni kwe diziwa dya Galilaya kujinkila isi ya Dekapoli, na kubula mwe si ya Mizi Mlongo. ");
INSERT INTO ziw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wantu wamwigaila Yesu mntu hekwiva na hekudaha kulonga vyedi, wamwila amwikiye mikono mlanga mntu uyo. ");
INSERT INTO ziw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Elo Yesu niyo amusa he difyo dya wantu amwigala hankanda, ajela madole yakwe mwa magutwi ya yudya mntu, niyo atwa mate na kumdonta mo lulimi lwakwe. ");
INSERT INTO ziw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Akaheza Yesu niyo asinya kwembingu, atoa nkwilu, na kumgamba yudya mntu, “Efata,” Kugamba, “Vuguka!” ");
INSERT INTO ziw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ahadya uyo umntu akonga kwiva na ululimi lwakwe lwalegela na kukonga kulonga vyedi. ");
INSERT INTO ziw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu niyo awalemeza wantu wasekulonga dyodyose kwa mntu, mna ivyo akuwalemeza, nivyo wakujendeleza kulonga. ");
INSERT INTO ziw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wose wevile weheleswa. Wagamba, “Kadamanya chila chintu vyedi!” “Kawatenda hewekwiva weve na vimumu walonga!” ");
INSERT INTO ziw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mwa mazuwa ayo fyo tuhu dya wantu dyechisanya vituhu. Weze wantu watende hawana nkande, Yesu awetanga wanampina wakwe, awagamba, ");
INSERT INTO ziw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nawafila mbazi wano wantu kwa viya wekala na miye mazuwa matatu, naho vino haluse hawana nkande. ");
INSERT INTO ziw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Uneva ninawalaga wauye kaya hewedile, nawagwe mteho mwe sila, kwaviya watuhu walawa hale.” ");
INSERT INTO ziw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wanampina wakwe wamuza, “Hano he nyika mntu akudaha kuchinka nkande ya kuchinta kulisa wantu woseni wano?” ");
INSERT INTO ziw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu awauza, “Mna migate mingahi?” Wamhitula, “Mfungate,” ");
INSERT INTO ziw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Awagamba wantu wekale hasi. Aguha idya migate mfungate, amjimbika Chohile, niyo aibesula besula, na kuwenka wadya wanampina wakwe wawapangile wantu, niyo watenda ivyo. ");
INSERT INTO ziw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Naho nawana samaki njeche. Yesu azijimbika na kuwagamba wanampina wawapangile seiviya. ");
INSERT INTO ziw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wose wadya niyo weguta. Vikaheza wanampina walogota vibesulo vigwele, wamemeza ntangulu mfungate. ");
INSERT INTO ziw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wantu wadile wendaga magana milongo mine. Akaheza awalaga, ");
INSERT INTO ziw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","aho Yesu niyo engila mwe ngalawa hamwenga na wanampina wakwe na kwita mo mzi wa Dalumanuta. ");
INSERT INTO ziw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafalisayo awamwenga wambasa Yesu na kukonga kuhigana naye. Wakamjeza, wakumunga awadamanyize mpituko ikulagisa kugamba udahi wakwe ulaila kwembingu kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu niyo engila chinyulu mo moyo niyo agamba, “Nimbwani wantu we cheleko chino waungisa mpituko? Chindedi nawagambilani! Hahana chilagiso chochose namwinkigwe!” ");
INSERT INTO ziw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Akaheza niyo awasa, engila mwe ngalawa, na kukonga kwita ng'ambu ye diziwa. ");
INSERT INTO ziw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wanampina wakwe wajalaga kuguha migate ikuwachinta. Nawana mgate umwenga du mwe ngalawa. ");
INSERT INTO ziw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu awafunda, “Msinyisise,” na “Mwenege ne hamila ya Mafalisayo na ya Helode!” ");
INSERT INTO ziw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wanampina niyo wakonga kulosana, “Alonga vino kwa viya hachina migate.” ");
INSERT INTO ziw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu niyo amanya viya nawakalosana, elo awauza, “Nimbwani mkulosana mbuli ya kuswesa migate? Hamvimanyize hegu kukombaganya? Myoyo yenyu ichei midala? ");
INSERT INTO ziw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mna meso mna hamkuwona? Mna magutwi, mna hamkwiva? Hamkukumbuka, ");
INSERT INTO ziw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","umo habesula imigate mishano na kuwenka wantu magana milongo mishano? Mwalogotaga ntangulu nyingahi zimemile vibesulo?” Wamhitula, “Ntangulu mlongo na mbili.” ");
INSERT INTO ziw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Eze nibesule migate mfungate na kuwenka wantu magana milongo mine, ni ntangulu nyingahi zimemile vibesulo mlogote?” Wamhitula, “Mfungate,” ");
INSERT INTO ziw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Awauza, “Hamnati kumanya?” ");
INSERT INTO ziw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wabula mwe mzi ukwitangwa Betisaida. Uko wantu wamwigaila Yesu tuntu na kumwila amdonte. ");
INSERT INTO ziw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu amtoza umkono yudya tuntu na kumlavya mwe kaya. Eze amtwele mate mwa meso, amwikiya mikono mlanga na kumuza, “Wadaha kuwona chochose?” ");
INSERT INTO ziw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yudya mntu asinya kulanga na kugamba, “Heye, nawona wantu wakujenda, mna wekala enga miti.” ");
INSERT INTO ziw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu niyo naho aika mikono yakwe mwa meso ya yudya tuntu, niyo agubula ameso yakwe akonga kuwona vyedi, niyo awona vintu vyose pwilili. ");
INSERT INTO ziw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu amgamba aite kaya, mna amlemeza, “Asekuya ko mzi udya.” ");
INSERT INTO ziw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu na wanampina wakwe waita ko mzi hajihi na Kaisaliya Filipi. Mwe sila, Yesu awauza, “Nigambilani, wantu wanitanga miye ni yuhi?” ");
INSERT INTO ziw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wamhitula, “Watuhu wakugamba ni weye Yohana Mta kubatiza, watuhu wagamba wi Eliya na watuhu nawo wakugamba wi yumwenga wa wawoni.” ");
INSERT INTO ziw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Awauza, “Nyuwe nanywi mwanigaze?” Petulo amhitula, “Ni weye Kulisito.” ");
INSERT INTO ziw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu niyo awafunda wasekumgambila mntu yoyose imbuli idya. ");
INSERT INTO ziw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu akonga kuhinya wanampina wakwe. “Mwana Mntu aungwa asulumizwe vidala na kulemelwa ni wadalahala na wakulu wa walavyantambiko na wahinyi wa sigilizi. Nakomwe, mna yakajinka mazuwa matatu kulawa ukubanika kwakwe nauyuke.” ");
INSERT INTO ziw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu kawagambila pwipwipwi. Petulo niyo amsenta hankanda na kumkwahila. ");
INSERT INTO ziw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mna Yesu niyo ahituka, awasinya wanampina wakwe na kumkwahila Petulo amgamba, “Halawe hano, Shetani! Hukufanyanya mbuli za Chohile, mna za wantu.” ");
INSERT INTO ziw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Niyo Yesu etanga fyo dya wantu hamwenga na wanampina wakwe, awagamba, “Mntu akunga anitimile, elemele mwenye, enule Msalaba wakwe anitimile. ");
INSERT INTO ziw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mntu yoyose akunga akombole ujima wakwe, nawaze, mna yoyose akuwaza ujima wakwe kwa chausa cha miye na chausa cha Mbuli Yedi yo Useuta wa Chohile, naukombole. ");
INSERT INTO ziw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Togola kuna loso dyani Mntu anapata isi yoseni mna aze ujima wakwe? ");
INSERT INTO ziw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Hahana chintu wakudaha kulavya chani wavuzizwe ujima wawo. ");
INSERT INTO ziw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mntu akuniwonela soni miye na mahinyo yangu mwe cheleko chino china masa na wachilanga kulongozi kwa Chohile, Mwana ywa Mntu namwonele soni aho akwizila mo ukulu wa Tati yakwe hamwenga na wandima wa kwembingu wakukile.” ");
INSERT INTO ziw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu kalonga naho, “Chindedi kuna wantu watuhu hano hawabanike kubula wawone Useuta wa Chohile ukeza na nguvu nkulu.” ");
INSERT INTO ziw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yeze yajinke mazuwa mtandatu, Yesu awaguha Petulo na Yakobo na Yohana, waitanya kulanga ko lugulu, hantu nawechedu. Hadya mwili wa Yesu wahitukila mwa meso yawo. ");
INSERT INTO ziw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Suche zakwe nazikang'alisa, ukung'ala uko hahana mntu yoyose mwe isi akudaha kunyukula suche zing'ale se ivyo. ");
INSERT INTO ziw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Niyo wanampina wadya watatu wawawona Eliya na Musa wakasimwila na Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petulo amgamba Yesu, “Mhinyi, vitenda vyedi suwe chikale hano. Chizenge mahema matatu, dimwenga dyako, dimwenga dya Musa na dimwenga dya Eliya.” ");
INSERT INTO ziw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petulo na weyawe nawogoha vidala vilekile asekumanya dyo kulonga. ");
INSERT INTO ziw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Niyo kwalaila ingu dyawagubika, na izwi dyevika mwe diya idiingu kugamba, “Yuno nuyo mwanangu huungisa, mwetegelezeni!” ");
INSERT INTO ziw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ahadya weze wapagase, hawamwone mntu mna Yesu ichedu hamwenga na wowo. ");
INSERT INTO ziw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Umo wakasela kulawa ko ulugulu, Yesu awagamba, “Msekumgambila mntu yoyose icho muwone aho Mwana Mntu hadya akunga auyuke.” ");
INSERT INTO ziw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wazumila viya awagambile, mna mgati mwawo wauzana, “Kuno ‘Kuuyuka’ ni mbwani?” ");
INSERT INTO ziw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Niyo wamuza Yesu, “Kwa mbwani wahinyi wa sigilizi wagamba Eliya aungigwa akonge kwiza?” ");
INSERT INTO ziw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Awahitula, “Chindedi Eliya nakonge kwiza kwika mbuli zose vyedi, mna ni mbwani Mawandiko Yakukile yakugamba seivyo kugamba Mwana ywa Mntu nasulumiziswe naho nabelwe? ");
INSERT INTO ziw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mna nawagamba, Eliya keza kale na wantu wamtendela viya waungile, saviya viwandikwe mwa Mawandiko.” ");
INSERT INTO ziw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Weze wadugane na wadya wanampina watuhu wasigale, wawona fyo dya wantu diwazunguluke na wahinyi wa sigilizi wahigana nawo. ");
INSERT INTO ziw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wantu weze wamwone Yesu, weheleswa, wamgulukila kumlamsa. ");
INSERT INTO ziw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu awauza wanampina wakwe, “Mwahigana mbwani na wowo?” ");
INSERT INTO ziw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mntu yumwe mwe difyo amhitula, “Mhinyi, sikwigaila mwanangu kwa viya ana mpepo ikumleka atende chimumu. ");
INSERT INTO ziw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chila mpepo ikemuka, yamgwisa hasi, alawigwa ni fulo mo mnomo, agwegwenya ameno naho atoga umwili wose. Siwagamba wano wanampina wako wailavye impepo iyo, mna wadunduga.” ");
INSERT INTO ziw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu awagamba, “Nyuwe wantu hemkuzumila! Nikale na nyuwe kubula ini? Niwajijimizeni vivihi? Nigailani uyo mbwanga!” ");
INSERT INTO ziw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wamwigala kwa Yesu. Ahadya mpepo ize imwone Yesu, yamgwisa chifutu yudya mbwanga na kugalagala hasi, naho kalawigwa ni chifulo ko mnomo. ");
INSERT INTO ziw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu amuza ise dya yudya mbwanga, “Vino vimkonga ini?” Amhitula, “Vimkonga achei mdodo.” ");
INSERT INTO ziw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Nkanana zilozize mpepo neikamdula mwe moto na mndani mwa mazi. Chifile mbazi naho chambize hegu ukadaha!” ");
INSERT INTO ziw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu niyo agamba, “Heye kwambwani wagamba,” “Hegu wadaha! Yose yadahika kwa yudya akuzumila.” ");
INSERT INTO ziw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aho tati yakwe yudya mwana niyo alonga kwa izwi kulu, “Nazumila mna uzumizi wangu ni mjeche, nambiza nitende na uzumizi mkulu!” ");
INSERT INTO ziw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu eze awone fyo dya wantu dyawasogeila hajihi, niyo akwahila mpepo idya nchafu, “Weye mpepo chimumu na hwikwiva, nakugamba mlawe mwana uyo, usekumuwiya vituhu!” ");
INSERT INTO ziw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mpepo yaguta, yamgwisa chifutu na kumlawa. Yudya mbwanga kekala enga chimba, ivyo wantu wamwenga nawakagamba, “Kabanika!” ");
INSERT INTO ziw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mna Yesu amtoza yudya mwana mkono na kumwambiza kuchimala, naye achimala. ");
INSERT INTO ziw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu eze engile mwe nyumba, wanampina wakwe wamuza kwa chinyele, “Nimbwani hachidahile kulavya impepo idya?” ");
INSERT INTO ziw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu awahitula, “Ni kulombeza kwa Chohile du kukudaha kulavya mpepo saiyo, hakuna chituhu.” ");
INSERT INTO ziw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na wanampina wakwe wahalawa hadya kujinkila si ya Galilaya. Yesu nahaungile yoyose amanye aho eli, ");
INSERT INTO ziw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwa viya nakahinya wanampina wakwe. Awagamba, “Mwana ywa Mntu nenkizwe mwe mikono ya wadya nawamkome. Mna yanajinka mazuwa matatu kulaila ukubanika kwakwe, na auyuke.” ");
INSERT INTO ziw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wanampina hawadahile kumanya mahinyo, mna nawakogoha kumuza. ");
INSERT INTO ziw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Weze wabule Kapelinaumu, wengila mnyumba. Yesu awauza wanampina wakwe, “Namkahigana mbwani mwe sila?” ");
INSERT INTO ziw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mna hawamhitule kwa viya mwe sila nawakahigana kugamba mkulu ni yuhi mgati mwawo. ");
INSERT INTO ziw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu ekala hasi, awetanga wanampina wakwe mlongo na waidi na kuwagamba, “Akunga kutenda ywa nkongo, etende mndima ywa kuwasankanila wose.” ");
INSERT INTO ziw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Niyo amguha mwana mdodo, amchimalisa mwa meso yawo, amkumbatila na kuwagamba, ");
INSERT INTO ziw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yoyose akumhokela yumwe mwa wawana sawano kwa zina dyangu, anihokela miye. Na akunihokela miye, hakunihokela miye ichedu, mna na yudya anisigile.” ");
INSERT INTO ziw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana amgamba Yesu, “Mhinyi, chiwona mntu akulavya mpepo kwa zina dyako. Chimlemeza kwa viya he hamwenga na suwe.” ");
INSERT INTO ziw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu awagamba, “Msekumlemeza,” Kwaviya hahana mntu akudaha kudamanya mpituko kwa zina dyangu niyo nyumani alonga yehiye mwangu. ");
INSERT INTO ziw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kwa viya hekulemana na suwe ehamwenga na suwe. ");
INSERT INTO ziw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nawagambilani chindedi, mntu yoyose akunga awenke mazi ya kunywa, kwa viya mwi wantu wa Kulisito, chindedi nahokele ntunyo. ");
INSERT INTO ziw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mntu yoyose akunga amsweseze yumwenga mgati mwa wadodo wano wakunizumila, atende wavu naviwagila mntu uyo atalizwe yuwe kulu mwe isingo yakwe niyo adulwa mwe ibahali. ");
INSERT INTO ziw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Uneva mkono wako ukakuhosa udamanye wavu, ukante. Naviwagila kwingila ko ujima wa mazuwa yose na mkono umwenga, kujinka kwingila kwedibome hedina uhelo na mikono midi. ");
INSERT INTO ziw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Umo mna wadudu hewe kubanika na moto heukufa. ");
INSERT INTO ziw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Uneva chiga chako chikakuhosa udamanye wavu, chikante. Naviwagila wingile ko ujima una chiga chimwenga, ukaleka ukatenda na viga vidi na kudulwa kwe bome hedina uhelo. ");
INSERT INTO ziw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Uko mafuza yakuwadya hayakubanika, na moto ukuwoka haukufa. ");
INSERT INTO ziw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Saiviya ziso dyako hegu dyonga dikutende udamanye wavu, ding'ole. Naviwagila kwingila mo Useuta wa Chohile na ziso dimwe, kujinka kutenda na meso maidi na kudulwa kwedibome hedina uhelo. ");
INSERT INTO ziw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Uko mafuza yakuwadya hayakubanika, na umoto ukuwoka haukufa. ");
INSERT INTO ziw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Chila yumwenga nalenguswe kwa moto saviya nyama ijeligwe munyu. ");
INSERT INTO ziw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Munyu ni wedi, mna unaza ulumunyumunyu lwakwe, naujelwe mbwani utende wedi? Tendani na munyu wa umbuya mgati mwenyu, naho mwikale kwa utondowazi.” ");
INSERT INTO ziw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu niyo aita Yudeya kugwila mto wa Yolodani. Mafyo ya wantu yamwizila naho, niyo akonga kuwahinya saviya adamanyaga. ");
INSERT INTO ziw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mafalisayo watuhu wambasa na kumjeza kwa kumuza, “Chigambile, vino sigilizi zetu zamunga mgosi amwase mkaziwe?” ");
INSERT INTO ziw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu awahitula na kuwauza, “Musa nakawasigila mbwani?” ");
INSERT INTO ziw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Niyo wamhitula, “Musa nakazumila mgosi kuwandika talaka na amwase mkaziwe.” ");
INSERT INTO ziw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu awagamba, “Musa awawandikilaga mwiko uno ko udala we myoyo yawo. ");
INSERT INTO ziw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mna chipindi Chohile akaumba wantu aumbaga mgosi na mvyele. ");
INSERT INTO ziw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ivyo mgosi namwase tati yakwe na mami yakwe, na kuhangana hamwenga na mkaziwe. ");
INSERT INTO ziw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nawo nawatende mwili umwenga. Ivyo hawatende waidi naho, mna yumwe. ");
INSERT INTO ziw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kwa ivyo chilunganywe ni Chohile, mntu hakungigwa kuchisenta.” ");
INSERT INTO ziw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Weze wauye kunyumba, wanampina wamuza Yesu imbuli iyo. ");
INSERT INTO ziw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Naye awagamba, “Mgosi yoyose na mwase mkaziwe ywa nkongo na kuguha mtuhu, adamanya chilanga kwa mkaziwe wa nkongo. ");
INSERT INTO ziw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Iviya naho, mvyele akumwasa mgosiwe ywa nkongo na kuguhigwa ni mtuhu, naye adamanya chilanga kwa mgosiwe wa nkongo.” ");
INSERT INTO ziw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wantu wamwenga nawamwigaila Yesu wana wadodo awajelekele mikono, mna wanampina nawakawakwahila wantu wadya. ");
INSERT INTO ziw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu eze awone ivyo, niyo ehiwa na kuwagamba wanampina wakwe, “Walekeni wana wadodo weze kwangu, msekuwachinda kwaviya Useuta wa Chohile wimwe wantu sa wana wano. ");
INSERT INTO ziw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nawagambilani ichindedi, mntu yoyose hekuhokela Useuta wa Chohile sa wana wadodo, hawingile ng'o.” ");
INSERT INTO ziw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Awakumbatila awo wana na kuwajeleka mikono na kuwajimbika. ");
INSERT INTO ziw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Umo Yesu akahalawa, mntu yumwenga amgulukila, kamfikila madi na kumuza, “Mhinyi ywedi, nitende mbwani niuhokele ujima wa mazuwa yose?” ");
INSERT INTO ziw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu amuza, “Nimbwani ukunitanga ywedi? Hahana mntu ywedi mna ni Chohile ichedu. ");
INSERT INTO ziw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kumanya ivyo mwiko ukulonga, usekukoma, usekugonya, usekubawa, usekumzigiliza mnyawo, usekutenda mdanti, watunye tati yako na mami yako.” ");
INSERT INTO ziw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yudya mntu amgamba, “Mhinyi, natozaga sigilizi zino kukongela udodo wangu.” ");
INSERT INTO ziw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu niyo amkaula na kumunga. Niyo amgamba, “Kuna chimwenga chisigale, katage vyose unanavyo, niyo wawenka wachiwa izihela, nawe nautende na ugoli kwembingu. Ukaheza aho, wize unitimile.” ");
INSERT INTO ziw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yudya mntu eze eve ivyo, niyo ehiwa, niyo ahalawa kwa chinyulu kwa viya nani mgoli vidala. ");
INSERT INTO ziw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu apagasa na kuwagamba wanampina wakwe, “Navitende vidala mgoli kwingila mo Useuta wa Chohile!” ");
INSERT INTO ziw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wanampina wakwe wehelwa imbuli idya. Mna Yesu ajendeleza kuwagamba, “Wanangu, ni vidala kwingila mo Useuta wa Chohile! ");
INSERT INTO ziw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ni vihufu ngamiya kujinka mwe langa dya singano, ukaleka wagoli kwingila mo Useuta wa Chohile” ");
INSERT INTO ziw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wanampina niyo weheleswa na kuzana, “Uneva nivyo, nakombolwe ni yuhi?” ");
INSERT INTO ziw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu awasinya na kuwahitula, “Vino havikudahika kwa mntu, mna siyo kwa Chohile. Kwa Chohile, chila chintu chadahika.” ");
INSERT INTO ziw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petulo amgamba, “Kaula, suwe chileka chila chintu na kukutimila weye!” ");
INSERT INTO ziw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu niyo awagamba, “Nawagambilani chindedi, mntu yoyose akunga ase nyumba yakwe hegu walukolo wakwe hegu walumbu zakwe hegu tati yakwe hegu mami yakwe hegu wana wakwe hegu nkonde zakwe kwa chausa changu na Mbuli Yedi, ");
INSERT INTO ziw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nahokelese mwa mazuwa aya. Nahokele nkanana gana, nyumba na walukolo na walumbu na mame na wana na nkonde hamwenga na nkuto. Mwa mazuwa yakwiza nahokele ujima wa mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mna wadya wa wakutunywa nawatende wakubelwa, na wadya wa wakubelwa nawatende wa wakutunywa.” ");
INSERT INTO ziw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu na wanampina wakwe nawemweisila kwita Yelusalemu. Yesu nakawalongwela, niyo wanampina wehelwa, na wantu nawakamtimila nawo wengilwa ni woga. Aho Yesu awasenta naho wanampina wakwe mlongo na waidi hankanda na kuwagambila mbuli zikunga zimlaile. ");
INSERT INTO ziw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Awagamba, “Tegelezani, chaita Yelusalemu. Uko Mwana Mntu nenkizwe kwa walavyantambiko wakulu na wahinya Sigilizi. Wowo nawo nawamkantile akomwe na kwinkizwa kwa Wantu sawo Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nawambele na kumtwela mate na kumhuta nakumkoma. Mna mazuwa matatu yakutimila kubanika, kwakwe nauyuke.” ");
INSERT INTO ziw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobo na Yohana wana wa Zebedayo niyo wambasa Yesu nakumgamba, “Mhinya, chaunga uchidamanyize chintu.” ");
INSERT INTO ziw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu awauza, “mwonga ni wadamanyize mbwani?” ");
INSERT INTO ziw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wamhitula, “Umo ukekala mwe ichiti chako cho Useuta mo ukuka wako, chaunga chikale hamwenga na weye, yumwenga kulume kwako na mtuhu naye kumoso kwako.” ");
INSERT INTO ziw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu awagamba, “Hammanyize icho mkulombeza. Vino mwadaha kunywela chiya cha masulumizo naninywele hegu kubatizwa ubatizo hunga nibatizwe?” ");
INSERT INTO ziw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wamhitula, “Chavidaha.” Yesu awagamba, “Heye, namnywele chiya cha masulumizo hungigwa ninywele na kubatizwa ubatizo hungigwa nibatizizwe. ");
INSERT INTO ziw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mna sikudaha kusagula ni yuhi akunga ekale kulume hegu kumoso kwangu. Ni Chohile akunga awenke hantu aho kwa wadya awasagule.” ");
INSERT INTO ziw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wadya wanampina watuhu mlongo weze weve chiya Yakobo na Yohana wendile wakalombeza, niyo wawehiwa. ");
INSERT INTO ziw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu niyo awetanga hamwenga nakuwagamba, “Mvimanya wadya wakugambigwa ni vilongozi wa Wantu sawo Wayahudi wakulongoza kwa kukundagiza wantu, wana udahi mkulu kwa wantu. ");
INSERT INTO ziw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mna sivyo ivyo kwenyu. Mntu yoyose mgati mwenyu akunga atende mkulu kwenyu aungigwa atende mndima ywenyu, ");
INSERT INTO ziw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","na mntu yoyose akunga atende wa nkongo, aungigwa atende mndima wa wose. ");
INSERT INTO ziw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwaviya Mwana ywa Mntu hezile kusankanilwa, mna keza kuwasankanila wantu, na kulavya ujima wakwe chani kuwakombola wantu walozize.” ");
INSERT INTO ziw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Niyo wabula Yeliko. Yesu na wanampina wakwe hamwenga na fyo dya wantu umo wakahalawa mo mzi, tuntu yumwenga akwitangwa Batimayo mwana Timayo nakekala hankanda he isila akalombeza. ");
INSERT INTO ziw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Eze eve Yesu wa Nazaleti akujinka, niyo akonga kuguta, “Yesu! Ywa Daudi! Nifila mbazi.” ");
INSERT INTO ziw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wantu walozize wamkwahila na kumgamba, “Nyamala, mna agutisa akagamba, mwa ywa Daudi, nifila mbazi!” ");
INSERT INTO ziw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu niyo achimala nakugamba, “Mwitangeni!” Wamwitanga yudya mntu na kumgamba, “Kwenke moyo! Inuka akwitanga.” ");
INSERT INTO ziw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Adula mcheka wakwe, apilika na kumbasa Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu amuza, “Waunga hutendele mbwani?” Yudya ntuntu ahitula, “Mhinya, naunga nione naho.” ");
INSERT INTO ziw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu amgamba, “Hita, uzumizi wako ukuhonya.” Ahadya akonga kuwona, niyo amtimila Yesu mweisila. ");
INSERT INTO ziw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Weze wabule hajihi na Yelusalemu, hajihi ne mizi ya Betifage na Besaniya, wabula mo lugulu lwa Mizeituni. Yesu awasigila wanampina wakwe waidi wawalongwele. ");
INSERT INTO ziw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Awagamba, “Hitani he kaya ihajihi. Mkabula uko, nambwile mwana mpunda afungigwe, henati kukwelwa ni mntu. Mchohweleni mnigaile hano. ");
INSERT INTO ziw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Naho hegu mntu akawauza, nimbwani mwadamanya vino mgambeni, Zumbe amunga amjeseze namvuze ivino haluse.” ");
INSERT INTO ziw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wanampina wadya waita, wambwila mwana mpunda atalizwe ho lwivi hankanda he sila haguhi na nyumba. Umo wakamchohwela, ");
INSERT INTO ziw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","wantu watuhu wachimale hadya wawauza, “Nimbwani mwamchohola mpunda uyo?” ");
INSERT INTO ziw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wahitula enga viya wagambilwe ni Yesu, na awantu awo niyo wawaleka waite naye. ");
INSERT INTO ziw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wamwigala mwana mpunda uyo kwa Yesu na kutandika suche zawo mwe yudya mwana mpunda, Yesu niyo ekala mnanga mwakwe. ");
INSERT INTO ziw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wantu walozize watandaza izisuche zawo mweisila, watuhu nawo wasenga matambi ya miti na kuyatandaza mweisila wakamsingila. ");
INSERT INTO ziw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wantu walongole na wadya wekunyuma wagutila, “Chohile atogolwe! Ajimbikwe akwiza mwe idizina dya Zumbe! ");
INSERT INTO ziw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Chohile ujimbike Useuta ukwiza wa zumbe Daudi, tati yetu! Chohile ekulanga atogolwe!” ");
INSERT INTO ziw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu engila Yelusalemu, aita kwe Nyumba nkulu ya Chohile na kukaula chila chintu. Mna kwaviya nadiswa, niyo aita ko mzi wa Besaniya na wanampina wakwe mlongo na waidi. ");
INSERT INTO ziw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Zuwa ditimile umo wakauya kulawa Besaniya, Yesu nakalumwa ni sala. ");
INSERT INTO ziw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kwa hale awona mti ukwitangwa mtini utimile mani, aubasa hegu napate tini. Mna eze abule haguhi, abwila mani ayodu kwaviya nasicho chipindi chakwe cha kweleka. ");
INSERT INTO ziw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu augamba umtini uwo, “Kukongela vino dyelo kubula mazuwa yose hahana nadye tini kulaila kwako naho!.” Wanampina wakwe niyo wamwiva viya alongile. ");
INSERT INTO ziw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Weze wabule Yelusalemu, Yesu engila mwe Nyumba nkulu ya Chohile na kukonga kuwagulusa woseni nawakataga na kugula vintu. Niyo agwisa izimeza za wadya nawakasakanya hela, na kugwisa vigoda vya wadya nawakataga wasuwa manga, ");
INSERT INTO ziw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","naho haungile yoyose afose na chintu mwe nchili ye Nyumba nkulu ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Akaheza niyo awahinya wantu, “Iwandikwa mwa mawandiko kugamba, Chohile agamba, ‘Nyumba yangu naitangwe nyumba nkulu ya Chohile ya kulombezeza wantu wa si zose.’ Mna nyuwe mwihitula itende lundu dya wabavi!” ");
INSERT INTO ziw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Walavyantambiko wakulu na wahinyi sigilizi weva imbuli iyo, niyo wakonga kulonda sila ya kumkoma Yesu. Nawakamwogoha kwaviya fyo dyose dya awantu nawekehelwa amahinyo yakwe. ");
INSERT INTO ziw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ize ibule chisingi, Yesu na wanampina wakwe niyo walawa mo mzi udya. ");
INSERT INTO ziw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Zuwa ditimile nomtondo, umo wakajenda mweisila, wawona udya mtini uligitwe ni Yesu unyala woseni kukongela kwa amaizi. ");
INSERT INTO ziw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petulo akumbuka chilaile na kumgamba Yesu, “Mhinyi, kaula umtini udya uligite unyala!” ");
INSERT INTO ziw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu awahitula, “Mzumileni Chohile. ");
INSERT INTO ziw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nawagambilani chindedi, mntu yoyose analugamba lugulu luno, ‘Hita ukedule mwe bahali,’ naye hena nkama mo moyo wakwe, mna zumilani kugamba chiya alongile nachilaile, navitendeke kwakwe. ");
INSERT INTO ziw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kwa chausa icho nawagambilani, mkavika na kulombeza chintu chochose, zumilani kugamba mchihokela, nanywi namwinkigwe chiya mkunga. ");
INSERT INTO ziw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nanywi mkalombeza, hegu kuna mntu awatendeleni wihi, musizeni wihi wakwe, chani Tati yenyu wa kwembingu naye awausizeni wihi wenyu. ");
INSERT INTO ziw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mna uneva hamnawausize amasa watuhu, Tati yenyu wa kwembingu naye hawausizeni wavu wenyu.” ");
INSERT INTO ziw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wengila naho Yelusalemu. Umo Yesu akajenda mwe Nyumba nkulu ya Chohile, walavyantambiko wakulu, wahinya Sigilizi na wadalahala niyo wambasa. ");
INSERT INTO ziw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Niyo wamuza, “Ni kwa udahi wa yuhi ukudamanya mbuli zino? Naho niyuhi akwinkile udahi wa kudamanya yano?” ");
INSERT INTO ziw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu awahitula, “Nami naniwauzeni mbuli imwenga, mnanihitula, na miye naniwagambileni udahi uwo ulawahi. ");
INSERT INTO ziw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nigambilani, ni yuhi amwinkile Yohana udahi wo kubatiza? Ulaila kwe mbingu hegu kwa wantu?” ");
INSERT INTO ziw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wakonga kuzana wenye kwa wenye, “Chigambe mbwani? Chinamhitula kugamba, ‘Ulaila kwe mbingu’ nachuze! ‘Kwa mbwani naho hamumzumile Yohana?’ ");
INSERT INTO ziw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Naho hachikudaha kugamba! ‘Ni wantu.’ ” Nawakogoha wantu, kwaviya chila mntu nakamanya kugamba Yohana nani muwoni. ");
INSERT INTO ziw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Niyo wamhitula Yesu, “Hachivimanyize” Yesu naye awagamba, “Nami saniwagambileni udahi uno wo kudamanya vino ulawahi” ");
INSERT INTO ziw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Akaheza Yesu niyo akonga kulonga milosi ino kwa wadya wakulu kwa sila ya miliganyo, “Hendaga na mntu ahandaga nkonde ya mizabibu, niyo aizungulusiza gwegwe inkonde, asimba bome dya kufumbwila zabibu, niyo azenga mnala kwa chausa cha wachimaila inkonde. Niyo aikodisha inkonde kwa walimi niyo atamba kwe si ntuhu. ");
INSERT INTO ziw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mazuwa ya kuvuna izizabibu yeze yabule, amsigila mndima akaguhe izizabibu kwa wadya walimi. ");
INSERT INTO ziw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wadya walimi wamgwila umndima yudya, wamhuta na kumgamba aogole hena chochose. ");
INSERT INTO ziw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mta inkonde amsigila mndima mtuhu. Wadya walimi wamhuta mo mtwi na kumjela soni. ");
INSERT INTO ziw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Amsigila naho mtuhu, uyo niyo wamkoma. Mta inkonde niyo ajendeleza kuwasigila wandima watuhu walozize, mna wadya wandima niyo wawadamanyiza seivyo, watuhu wawatowa, watuhu nawo wawakoma. ");
INSERT INTO ziw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Asigale wo kumsigila nani mwanawe mwenye akumungisisa. Niyo amsigila kwa viya nakalonga, yuno nawamwive, kwaviya ni mwanangu. ");
INSERT INTO ziw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mna wadya awalimi wagambilana, ‘Yuno nuyo mlisi we inkonde. Chisunguzeni kumkoma chani chilisi.’ ");
INSERT INTO ziw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ivyo wamgwila, wamkoma na kudula ichimba chakwe kuse kwe inkonde ye mizabibu.” ");
INSERT INTO ziw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu awauza, “Mkulu ywe nkonde ye mizabibu natende mbwani naho? Neze awakome wadya awalimi wose na kuwenka wantu watuhu inkonde iyo. ");
INSERT INTO ziw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Togolani hamsomile mawandiko yano. ‘Yuwe dilemelwe ni wazesi, dihitukila nakutenda yuwe kulu dyedi kujinka yose. ");
INSERT INTO ziw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Vintu vino navitendwa ni Zumbe, navyo ni chilozo mwa meso yetu!’ ” ");
INSERT INTO ziw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wakulu wa Wayahudi nawakalonda sila wamgwile Yesu kwa viya nawamanya umliganyo uwo wawalonga wowo. Mna nawakogoha idifyo dya wantu, niyo wahalawa. ");
INSERT INTO ziw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mafalisayo watuhu na wantu wa bunga dya zumbe Helode nawasigilwa kwa Yesu chani wakamtege mwe milosi yakwe. ");
INSERT INTO ziw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wambasa nakumgamba, “Mhinyi, chikumanya weye wi mlonga chindedi, hukusinya ukulu wa mntu mna wahinya ichindedi cha Chohile kwa wantu. Chigambile, ni vyedi suwe mwe sigilizi yetu kuliha kodi kwa Kaisali? Chilihe hegu chisekuliha?” ");
INSERT INTO ziw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mna Yesu niyo abunkula ubala wawo. Awahitula, “Ni mbwani mkunijeza? Nigailani hela niikaule.” ");
INSERT INTO ziw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wamwigaila imwenga. Niyo awauza, “Sula na chinengo na idizina vimuno ni vya yuhi?” Wamhitula, “Ni vya Zumbe wa Lumi.” ");
INSERT INTO ziw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu awagamba, “Ni vyedi. Mwinkeni Zumbe wa Lumi yakwe, na Chohile naye mwinkeni yakwe.” Niyo wamwehelwa Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wantu wamwenga mwe bunga dya Masadukayo, wakugamba hakuhali kuuyuka kulaila mwe file, wambasa Yesu na kumgamba, ");
INSERT INTO ziw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mhinyi, Musa kachigambila sigilizi ino kugamba, ‘Mntu anabanika niyo asa mvyele mna hana wana, mlukolo ywo umntu uyo aungigwa ampale uyo asigwe, watende na wana wakunga wagambigwe ni wa yudya abanikaga.’ ");
INSERT INTO ziw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hendaga na walukolo mfungate. Awalongwele nakasola, niyo abanika hena mwana. ");
INSERT INTO ziw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wa kaidi niyo ampala umvyele uyo, mna naye niyo abanika hena mwana. Niyo yalaila ivyo kwa wa katatu. ");
INSERT INTO ziw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na wose wasigale, wose niyo wampala umvyele uyo, mna haweleke wana. Mwe nkomelezo, umvyele uyo naye niyo abanika. ");
INSERT INTO ziw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Haluse, awo wose wakeza kuuyuka mwe dizuwa dyo kuyuka, mvyele uyo natende ni wa yuhi? Kwaviya woseni mfungate nawamsola.” ");
INSERT INTO ziw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu awahitula, “Vino mwaga! Mmanya nikwambwani? Ni kwa viya hammanyize Mawandiko naho nguvu za Chohile. ");
INSERT INTO ziw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kwa viya wantu wabanike nawauyuke, nawekale saviya wandima wa kwembingu wakwikala naho hawasole hegu kusolwa. ");
INSERT INTO ziw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kwa mbuli yo kuuyuka kwa wantu wabanike, vino hamsomile mwe chitabu cha Sigilizi ya Musa mbuli ya kasaka kakwaka moto? Viwandikwa kugamba, Chohile amkamgamba Musa. Miye ni Chohile ywa Bulahimu na Chohile ywa Isaka na Chohile ywa Yakobo. ");
INSERT INTO ziw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yeye ni Chohile wa wantu wajima, suyo Chohile ywa wadya wabanike. Ivyo mwaga vidala!” ");
INSERT INTO ziw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mhinyi yumwenga ywa sigilizi nehadya akategeleza. Eze awone Yesu kamhitula yudya Sadukayo vyedi, amwitila na kumuza, “Mwe miko yose, ni mwiko uhi mkulu?” ");
INSERT INTO ziw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu amhitula, “Sigilizi inkulu ni ino, ‘Tegelezani nyuwe wantu wa Izulaeli! Zumbe Chohile ywetu ni Zumbe yumwe ichedu. ");
INSERT INTO ziw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Munge Zumbe Chohile ywako kwa moyo wako wose na kwa muye wako wose na kwa fanyanyi zako zose na kwa nguvu zako zose.’ ");
INSERT INTO ziw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na mwiko wa kaidi mkulu ni uno, ‘Munge mnyawo saviya ukweunga we mwenye.’ Hahana mwiko mkulu utendese ikwinga ino imidi.” ");
INSERT INTO ziw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yudya mhinyi we zisigilizi amgamba Yesu, “Mhinyi, ni vyedi ivyo ukulonga. Ni chindedi kugamba yuno Zumbe nuyo Chohile du, naho hahana mtuhu. ");
INSERT INTO ziw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Naho kumunga Zumbe Chohile ywako kwo moyo wako wose na kwa Muye wako wose na kwa fanyanyi zako zose na kwa nguvu zako zose, na kumunga mnyawo saviya ukweunga we mwenye ni vyedi kujinka kumlaviza Chohile ntambiko.” ");
INSERT INTO ziw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu amanya viya amhitule vyedi na kumgamba, “Hwi hale no Useuta wa Chohile.” Eze aheze hahana mntu mtuhu amuzize Yesu mbuli yoyose. ");
INSERT INTO ziw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iviya Yesu akahinya mwe Nyumba nkulu ya Chohile, awauza, “Navitende vivihi wahinyi wa sigilizi wakagamba Kulisito nalawe mo ulukolo lwa Daudi? ");
INSERT INTO ziw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Muye Ukukile nakamlongoza Daudi, naye kagamba! ‘Zumbe kamgambila Zumbe ywangu, Ikala kulume kwangu kubula niwaike wankondo wako hasi he iviga vyako’ ");
INSERT INTO ziw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Daudi mwenye nakamwitanga ‘Zumbe.’ Vitenda vivihi Kulisito naho alawe mo lukolo lwa Daudi?” Wantu walozize nawakamtegeleza Yesu kwa chinyemi. ");
INSERT INTO ziw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Niyo awahinya awagamba, “Muwasinyise wahinya sigilizi. Wakunga kuvala nkazu ntali na kulamswa kwa kutunywa mwa magwilo. ");
INSERT INTO ziw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Wakunga kusagula vigoda vya watunywa mwe nyumba yo kuvikila na mwe zingasu. ");
INSERT INTO ziw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wabunyanya ugoli wa wafilwe ni wagosi, naho walombezesa chani wawonwe kugamba ni wantu wa Chohile. Awo kanto dyawo nadi tendese!” ");
INSERT INTO ziw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu na kekala mndani mwe Nyumba yo kuvikila haguhi ne dishanduku dye mpamba, nakasinya wantu ivyo wakujela izi hela. Wagoli walozize nawakajela hela zilozize. ");
INSERT INTO ziw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kwalaila mvyele mchiwa abanikilwe ni mgosiwe, naye ajela watundu wakwe waidi wa wahela. ");
INSERT INTO ziw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu awetanga wadya wanampina wakwe hamwenga na kuwagamba, “Nawagambilani ichindedi, yuno mvyele abanikilwe ni mgosiwe kajela vilozize mwe dishanduku dye mpamba kuwajinkani wose. ");
INSERT INTO ziw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Watuhu wajela viya vitendese mo ugoli wawo, mna yuno mvyele mchiwa, kajela vyose ananavyo, kajela vyose nakasinya kubula chiya asigaze mo wikazi wakwe.” ");
INSERT INTO ziw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Umo Yesu akafosa kulaila mwe Nyumba nkulu ya Chohile, mwanampina ywakwe yumwenga amgamba, “Mhinyi, kaula amayuwe na mazengo yano ivyo yekale vyedi!” ");
INSERT INTO ziw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu amhitula, “Wawona mazengo yano makulu? Hahasigale hata yuwe dimwenga nadisigale mlanga mwe mnyawe, chila dimwenga nadidulwe hasi.” ");
INSERT INTO ziw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu nakekala ho lugulu lwa Mizeituni akasinya Nyumba nkulu ya Chohile, Petulo na Yakobo na Yohana na Anduleya wambasa iche du. ");
INSERT INTO ziw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Wamuza, “Chigambile yano yose umo nayalaile naho ni chilagiso chani nachilaile chani chimanye kugamba chipindi icho chibula?” ");
INSERT INTO ziw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu akonga kuwagamba, “Mkaulise, naho mntu anase kuwadanta. ");
INSERT INTO ziw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wantu walozize naweze na kwetanga wenye kwa zina dyangu, wakagamba, ‘Miye nuyo Kulisito!’ Nawo nawawadante walozize. ");
INSERT INTO ziw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mneva mbuli za nkondo na mbuli za visimo vya nkondo. Ayo yaungwa yalaile, mna siyo kugamba udumo ubula. ");
INSERT INTO ziw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kwaviya si imwenga naitowane na si ntuhu, naho seuta nautowane na useuta mtuhu. Nakulaile visingisa chila hantu, naho nakutende nagumbo. Vino vyose navitende enga nkongelo ya usungu wa kwefungula mwana. ");
INSERT INTO ziw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mwikale meso vyedi. Kwaviya namwigalwe kwe vitala. Namtoigwe mwe zi nyumba zo kuvikila, namchimaliswe kulongozi kwe vilongozi na maseuta kwa chausa changu chani mlavye ukuzi wa Mbuli Yedi. ");
INSERT INTO ziw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Vyaungwa Mbuli Yedi ya Chohile ilongwe nkongo kwa wantu wa si zose. ");
INSERT INTO ziw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mnagwilwa niyo mwegalwa mwe vitala, msekogoha na milosi iyo na ivyo na mkalonge, mna longani ayo namwinkigwe mwe chipindi icho, kwaviya ayo mkunga mlonge sayo yenyu, mna nayalawe kwa Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mntu na amlavye mlukolo ywakwe akomwe, na tati ya mntu na amlavye mwanawe. Wana nawo nawawahitukile welesi wawo na kuwakoma. ");
INSERT INTO ziw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wantu wose nawaweihiweni kwa chausa changu. Mna akunga ajijimize kubula ko udumo nakombolwe. ");
INSERT INTO ziw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mna namumwone yudya akwitangwa, ‘Ihizo dikwigala ubanasi’ dichimala hantu hehekungwa.” Mntu akusoma naamanye, naho amanye ivyo vili! Elo Yudeya wasumkile kuchenya kwa magulu. ");
INSERT INTO ziw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mntu yoyose kwedigulu asekusela hasi naho asekwingila kunyumba kuguha chintu chochose. ");
INSERT INTO ziw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yudya ekwenkonde asekuya kukaya kuguha suche yakwe. ");
INSERT INTO ziw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mwa mazuwa ayo, wavyele wasoka na wakonkeza nawasulumile vidala mwa mazuwa ayo. ");
INSERT INTO ziw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mlombezeseni Chohile mazuwa ayo yasekulaila mwe mpeho. ");
INSERT INTO ziw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mazuwa ayo nayatendese na nkunto nkulu heinati kulaila kukongela Chohile akaumba isi kubula vino dyelo, naho haize ilaile vituhu! ");
INSERT INTO ziw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Uneva Zumbe nendile hahunguze amazuwa ayo, nendile hahana mntu nakadaha kukombolwa. Mna kwa chausa cha wadya wasagulwe kayahunguza. ");
INSERT INTO ziw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Mwa mazuwa ayo, mntu yoyose akunga awagambe, ‘Kaulani Kulisito ekuno!’ Hegu ‘Yudya ekudya!’ Msekuzumila. ");
INSERT INTO ziw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwaviya nawalaile makulisito wadanti na wawoni wadanti. Nawadamanye mpituko na vilagiso chani wawadante hata wadya wasagulwe ni Chohile, vikadahika. ");
INSERT INTO ziw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Msinyise! Siwagambilani kale chila chintu chikunga chilaile. ");
INSERT INTO ziw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mna mwama zuwa yadya yakaheza kujinka masulumizo yadya, zuwa nadijelwe chiza, mnenge nawo haumulike, ");
INSERT INTO ziw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ntondo nazigwe kulaila kwembingu, na nguvu zo ulanga nazisingisike. ");
INSERT INTO ziw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Akajika, Mwana ywa Mntu nalaile akeza mwa maingu kwa nguvu nkulu no Ukuka. ");
INSERT INTO ziw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Naye nasigile wandima wa kwembingu ntendele zose kuwachisanya wantu wose wasagulwe ni Chohile, kulaila ntendele imwenga ye isi kubula ntuhu. ");
INSERT INTO ziw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kaulani mligano wa mti wa mtini. Umo matambi yakwe yakasuka na kulavya mani mateke, mmanye kugamba fula zi haguhi. ");
INSERT INTO ziw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nivyo naho, umo namuwonele ayo yalaila, mmanye kugamba Mwana ywa Mntu ehajihi vitendese kwiza eho lwivi. ");
INSERT INTO ziw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mmanye chindedi kugamba cheleko chino hachinjinke kubula ayo yose yalaile. ");
INSERT INTO ziw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mbingu na isi navijinke, mna ulosi wangu haujinke. ");
INSERT INTO ziw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Hahana mntu amanyize zuwa hegu sa. Hata wandima wa kwembingu hegu Mwana hamanyize, mna ni Tate du nuyo amanyize. ");
INSERT INTO ziw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Chelezani, mwikale vyedi, kwa viya hammanyize isa iyo umo naizile. ");
INSERT INTO ziw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Navikale saviya mntu atambile hale ne kaya na kuwasiza udahi wandima wakwe, chila yumwenga kamwinka ndima ya kudamanya. Niyo amsigila mwamizi naye asinyise. ");
INSERT INTO ziw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chelezani, kwaviya hammanyize mkulu ywe nyumba nauye ini, vyadahika vikatenda umo diswele hegu chilogati au chilochilo hegu naho nomtondo. ");
INSERT INTO ziw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Anauya kwa kwitukiza, anasekuwabwila mgonile. ");
INSERT INTO ziw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Icho huwagambilani nyuwe, nawagambila wantu woseni, ‘Chelezani!’ ” ");
INSERT INTO ziw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nayasigala mazuwa maidi hainati kubula Pasaka na yemigate heijeligwe hamila. Walavyantambiko wakulu na wahinyi wa sigilizi nawakalonda sila wamgwile Yesu chinyele chani wamkome. ");
INSERT INTO ziw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wagamba, “Chisekumgwila mwe Pasaka kwaviya nawatende nkumbizi.” ");
INSERT INTO ziw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu nemwe mzi ukwitangwa Besaniya, mwe nyumba ya Simoni, mntu ahumaga matana. Umo Yesu akadya, niyo engila mvyele atozize kasupa kamemile mavuta yakupwepweleka vidala, naho yedi ya yombe kulu. Kasupa kadya nakadamanywa na yuwe dikwitangwa alabasita. Niyo akagubula kadya kasupa ka malashi na kumwitila Yesu mavuta ayo mo mtwi wakwe. ");
INSERT INTO ziw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wantu wamwenga nawehadya wehizwa ni mbuli idya, niyo wauzana, “Chiya chikuleka akabalanga mavuta yakupwepweleka saviya ni chihi? ");
INSERT INTO ziw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mavuta ayo nayakadaha kutagwa kwa hela ikudaha kumliha mndima kwa mhilimo umwenga hela mhilimo umwenga hegu hela ya dinali magana matatu na ihela iyo niyo wenkigwa wachiwa.” Niyo wamfuzumila vidala umvyele uyo. ");
INSERT INTO ziw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mna Yesu agamba, “Mlekeni. Ni mbwani mkumjela sungusungu? Kanitendela chintu chedi vidala. ");
INSERT INTO ziw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wachiwa namtende nawo chila zuwa, mwadaha kuwambiza chipindi chochose mkunga. Mna hamtende na miye mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mvyele yuno kadamanya viya adahile. Kanijela mavuta mo mwili wangu nyumani ko kuhambwa kwangu. ");
INSERT INTO ziw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nawagambilani ichindedi, hohose Mbuli Yedi ikunga ilongwe mwe isi yose, chino adamanye nachilongwe, niyo chatenda lukumbusa lwakwe.” ");
INSERT INTO ziw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Niyo Yuda Isikaliyote, yumwenga mwe wadya wanampina mlongo na waidi aita kwa walavyantambiko wakulu akamhituke Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Welelwa vidala kwiva viya alongile, niyo walagana kugamba nawamwinke hela. Niyo Yuda akonga kulonda luhenyo lwa kumhituka Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mwe idizuwa dya nkongo dye Pasaka heyajeligwe hamila, zuwa dyo kuchinja mwana ngoto ywe Pasaka, wanampina wa Yesu niyo wamuza, “Waunga chite kuhi chikaike hantu ho kudila nkande ye Pasaka?” ");
INSERT INTO ziw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Niyo Yesu awasigila wanampina wakwe waidi, awagamba, “Hitani ko mzi, namdugane na mgosi etwikile biga dya mazi. Mtimileni, ");
INSERT INTO ziw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","kubula kaya akunga engile, niyo mgambileni mta ikaya iyo kugamba, mhinya auza, chikuhi ichumba cha wajeni chani nidye nkande ya Pasaka na wanampina wangu?, ");
INSERT INTO ziw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naye nawalagiseni chumba chikulu chikulanga chikigwe vitana, chiikiyeni aho.” ");
INSERT INTO ziw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wanampina niyo waita, wabwila chila chintu saviya Yesu awagambile. Niyo waika inkande ye Pasaka. ");
INSERT INTO ziw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mwe ichisingi, Yesu niyo abula na wanampina wakwe mlongo na waidi. ");
INSERT INTO ziw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Umo we mwe ndala wakadya, Yesu awagamba, “Nawagambila chindedi, yumwe ywenyu chikudyanya, nanihituke.” ");
INSERT INTO ziw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wadya wanampina niyo wengilwa ni chinyulu, niyo wamuuza Yesu yumwe yumwe, “Hegu ni miye?” ");
INSERT INTO ziw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu awahitula, “Ni yumwenga mgati mwenyu nyuwe wose mlongo na waidi, yudya natweze mgate wakwe mwe bakuli hamwenga na miye. ");
INSERT INTO ziw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwana Mntu naabanike saviya Mawandiko yakulonga. Mna nkondo yakwe mntu uyo akunga amhituke. Naviwagila mntu uyo asekwelekwa!” ");
INSERT INTO ziw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Umo wakadya, Yesu niyo aguha mgate, aujimbika, aubesula na kuwenka wanampina wakwe, awagamba, “Guhani, uno nu umwili wangu.” ");
INSERT INTO ziw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Niyo aguha chikombe cha divai, amhongeza Chohile na kuwenka, niyo wose wachinywela hamwenga. ");
INSERT INTO ziw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Awagamba, “Ino ni sakame yangu ikwitika kwa wantu walozize, itende ni lagano dya wantu na Chohile. ");
INSERT INTO ziw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nawagambila chindedi, saninywe naho divai ino yo mzabibu kubula zuwa heza kunywa divai mpya mo Useuta wa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Weze waheze kuchema nchemo, niyo waita ko lugulu lwa Mizeituni. ");
INSERT INTO ziw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu awagamba, “Nyuwe wose namnisumke, saviya viwandikwe mwa Mawandiko Yakukile, nanimkome umdimi, ne zingoto nazo nazimwaganikane. ");
INSERT INTO ziw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mna heza kuuyuka, naniwalongwele kwita Galilaya.” ");
INSERT INTO ziw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulo amhitula, “Sahwase, hata hegu wose nawakwase!” ");
INSERT INTO ziw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mna Yesu amgamba Petulo, “Nakugambila chindedi, zogolo hadinati kwila kaidi chilo chino, naunilemele nkanana ntatu kugamba hunimanyize.” ");
INSERT INTO ziw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mna Petulo amhitula naho kwa nguvu, “Hata haungigwa chibanikanye, sahwase!” Wanampina wose wasigale walonga ivyo. ");
INSERT INTO ziw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wabula hantu hakwitangwa Gesemane, Yesu awagamba wanampina wakwe, “Ikalani hano, miye halombeze.” ");
INSERT INTO ziw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Awaguha Petulo na Yakobo na Yohana. Akonga kwingilwa ni chinyulu na tumbwaziko. ");
INSERT INTO ziw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Niyo awagamba, “Moyo wangu una usungu vidala na tumbwaziko. Ikalani hano, naho mcheleze.” ");
INSERT INTO ziw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ajendajenda hadodo, edula hasi na kulombeza kugamba vikadahika asekwingila mwe chipindi cha masulumizo. ");
INSERT INTO ziw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Agamba, “Aba, kugamba Tate, yose yadahika kwako. Nusiza ichikombe chino cha masulumizo. Mna vitende sikunga miye, mna viya ukunga weye.” ");
INSERT INTO ziw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Auya na kuwabwila wadya wanampina watatu wagona. Amgamba Petulo, “Simoni, kugona? Kudunduga kwikala na miye kubula saa dimwenga du?” ");
INSERT INTO ziw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Niyo awagamba wanampina wose, “Mcheleze naho mlombezese mnasekwingila mwe majezo. Muye waunga, mna umwili uhwa.” ");
INSERT INTO ziw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aita naho na kulombeza saiviya. ");
INSERT INTO ziw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Auya naho na kuwabwila wanampina wakwe wagona, wadunduga kufinyula, Hawamanyize wamgeze. ");
INSERT INTO ziw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Eze auye katatu, awagamba, “Mchegonile na mhumula? Ivyo! Chipindi chibula, haluse Mwana Mntu enkizwa mwe mikono ya wata masa. ");
INSERT INTO ziw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Chimalani! Chiteni! Kaulani, yudya mntu akunihituka nuyo.” ");
INSERT INTO ziw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu nachei akasimwila, Yuda, yumwe ywa wadya wanampina mlongo na waidi niyo abula. Keza na fyo dya wantu wata mabamba na malungu, wasigilwe ni walavyantambiko wakulu na wahinya Sigilizi hamwenga na wadalahala. ");
INSERT INTO ziw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda alavya chilagiso kwe idifyo nakugamba, “Hunga nimlamse kwa kumsesa, nuyo mkunga. Mgwileni naho mwigaleni kwa kusinyisa anase kuwasumka.” ");
INSERT INTO ziw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ahadya Yuda eze abule, kaita kwa Yesu na kumgamba, “Mhinyi!” Niyo amsesa. ");
INSERT INTO ziw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wadya wantu niyo wamgwila Yesu na kumtaliza. ");
INSERT INTO ziw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mna yumwenga mgati mwa wadya wachimale aguha bamba dyakwe, amtoa mtumwa wa mlavyantambiko mkulu na kumsenga idigutwi dyakwe. ");
INSERT INTO ziw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu niyo awagamba, “Nimbwani mwiza na mabamba hamwenga na malungu kunigwila saviya miye ni mbavi? ");
INSERT INTO ziw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Chila zuwa nanihamwenga na nyuwe hawahinyani mwe Nyumba nkulu ya Chohile, hamnigwile. Mna leka Mawandiko yachinte.” ");
INSERT INTO ziw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Niyo wanampina wose wamwasa, wanyilika. ");
INSERT INTO ziw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mbwanga yumwenga egubike mgolole nakamtimila Yesu. Weze waunge kumgwila, ");
INSERT INTO ziw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","niyo asa mgolole wakwe na kuguluka mwazi. ");
INSERT INTO ziw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesu niyo egalwa mwe inyumba ya mlavyantambiko mkulu, aho nawadugana na walavya ntambiko wakulu, wadalahala na wahinya sigilizi. ");
INSERT INTO ziw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petulo nakamtimila Yesu kwa hale, niyo engila kouwa we nyumba ya mlavyantambiko mkulu. Ekala hasi hamwenga na wamizi we nyumba, akotela moto. ");
INSERT INTO ziw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Walavyantambiko wakulu na wantu wose hechitala cha Wayahudi nawakaunga ukuzi ukudaha kumtenda Yesu akomwe, mna hawaubunkule. ");
INSERT INTO ziw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wantu walozize na waka mukwila Yesu mbuli za udanti, mna ukuzi wawo hauligane. ");
INSERT INTO ziw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mna niyo kwachimala wantu wamwenga wakaukula udanti ukumlanga Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Chimwiva akagamba, ‘Nanitule Nyumba nkulu ya Chohile izengigwe ni wantu, niyo yakajinka mazuwa matatu nanizenge ntuhu heizengigwe ni wantu.’ ” ");
INSERT INTO ziw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hamwenga na ivyo, ukuzi wawo hauligane. ");
INSERT INTO ziw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mlavyantambiko mkulu achimala kulongozi kwa wadya wantu, amuza Yesu, “Hukuhitula chino wakukulonga?” ");
INSERT INTO ziw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mna Yesu niyo anyamala dwi, halongile dyodyose. Mlavyantambiko mkulu amuza naho, “Togola weye wi Kulisito, Mwana ywa Chohile Ajimbikwe?” ");
INSERT INTO ziw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu amhitula, “Heye, ni miye! Naho wose namumuwone, Mwana ywa Mntu kekala kulume kwa Chohile mta nguvu, naho asela kulaila kwembingu.” ");
INSERT INTO ziw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mlavyantambiko mkulu atatula suche zakwe na kugamba, “Vino chaunga ukuzi wani naho? ");
INSERT INTO ziw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwiva ivyo akumhuluta Chohile! Chimtende mbwani?” Wose wamkantila akomwe. ");
INSERT INTO ziw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wantu wamwenga wakonga kumtwela mate, wamgubika uso na kumtowa maihi na kumgamba, “Bunkula, akutoile ni yuhi!” Wamizi nawo wamguha na kumtowa maihi. ");
INSERT INTO ziw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Umo Petulo nachei kouwa, mvyele yumwenga endile mndima ywa Mlavyantambiko mkulu niyo eza. ");
INSERT INTO ziw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Eze amwone Petulo akotela moto, amsinya na kumgamba, “Weye nawe na wi hamwenga na Yesu Mnazaleti.” ");
INSERT INTO ziw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mna Petulo niyo alemela na kugamba, “Simanyize, naho sikumanya idyo ukulonga.” Niyo afosa, kubula he chifigwe, zogolo dyaila. ");
INSERT INTO ziw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yudya mtumwa eze amwona naho, niyo akonga kuwagambila wadya wachimale aho, “Yuno ne hamwenga nawo!” ");
INSERT INTO ziw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mna Petulo alemela naho. Aho, wadya wachimale wambasa naho na kumgamba, “Chindedi hukudaha kudanta kugamba weye hwi yumwe ywawo kwa viya weye nawe wi Mgalilaya.” ");
INSERT INTO ziw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Niyo Petulo akonga kwelisa, “Nalonga chindedi, Chohile nanidamanye vihiye uneva sikulonga chindedi! Simmanyize uyo mntu mkulonga izimbuli zakwe!” ");
INSERT INTO ziw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ahadya naho, zogolo dyaila nkanana ya kaidi, Petulo naye akumbuka Yesu viya amgambilaga, “Zogolo hadinati kwila kaidi chilo chino, naunihituke nkanana ntatu kugamba hunimanyize.” Agwa hasi na kutula ndilo. ");
INSERT INTO ziw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Iviya mtondotondo, walavyantambiko wakulu wadugana na wadalahala na wahinya sigilizi na chitala chijima, waika ubala kumjela Yesu minyolo na kumwigala kwa Pilato. ");
INSERT INTO ziw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato amuza Yesu, “Weye wi Seuta ywa Wayahudi?” Yesu amhitula, “Heye, ni sa ivyo ukulonga.” ");
INSERT INTO ziw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Walavyantambiko wakulu wamlongeleza Yesu kwa mbuli zilozize, ");
INSERT INTO ziw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ivyo Pilato amuza naho, “Hukunihitula? Tegeleza yose wakukulongeleza!” ");
INSERT INTO ziw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu naho alemela kulonga dyodyose, Pilato naye niyo ehelwa. ");
INSERT INTO ziw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Chila chipindi cha Sikunkulu ya Pasaka, Pilato na ana mazwela ya kulekela mfungwa yumwenga wantu waungile alekelwe. ");
INSERT INTO ziw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mwa mazuwa ayo, nahana mntu yumwenga akwitangwa Balaba ne mwe chifungo. Uyo hamwenga na weyawe, nawakoma wantu mwe nkumbizi umo kwatendaga mhigano. ");
INSERT INTO ziw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Idifyo dya wantu weze wadugane hamwenga, niyo wakonga kumlombeza Pilato amchohwele mfungwa yumwenga saviya akutendaga. ");
INSERT INTO ziw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato awauza, “Mwaunga ni walekeile Seuta ywa Wayahudi?” ");
INSERT INTO ziw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nakamanya vyedi kugamba walavyantambiko wakulu nawamlavya Yesu kwa kumuwonela finju. ");
INSERT INTO ziw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mna walavyantambiko wakulu walafya na idifyo chani dimgambe Pilato amlekeile Balaba. ");
INSERT INTO ziw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato alonga vituhu na idifyo, “Mwaunga nimtende mbwani yuno mkwitanga Seuta ywa Wayahudi?” ");
INSERT INTO ziw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Niyo idifyo diya dyagutila, “Msulumize mo msalaba!” ");
INSERT INTO ziw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato auza, “Mna katenda mbwani?” Wose hamwenga wagutisa, “Msulumize mo msalaba!” ");
INSERT INTO ziw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato nakaunga adibwedeze idifyo dya wantu, ivyo awalekeila Balaba. Akaheza, amlavya Yesu atoigwe milugwa akajika wamsulumize mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wankondo wamwingiza Yesu kouwa we nyumba ya Pilato, mkulu we isi. Hadya wachintana hamwenga ne chitala chijima. ");
INSERT INTO ziw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wamvika suche izambalau, wamdamanyiza chilemba cho useuta chidamanywe kwa miwa na kumvika mo mtwi wakwe. ");
INSERT INTO ziw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wakalawa aho, wakonga kumlamsa, “Waacha, Seuta ywa Wayahudi!” ");
INSERT INTO ziw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wamtowa na tete mo mtwi na kumtwela mate, niyo wamfikila madi na kumfunamila. ");
INSERT INTO ziw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Weze waheze kumtila, wamvula isuche izambalau, na kumvika suche yakwe mwenye. Niyo wamlongoza kokumsulumiza mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mwe sila, wadugana na mntu akwitangwa Simoni, uyo nakengila mo mzi akalaila kwe nkonde. Wankondo wamkunduganya enule msalaba wa Yesu. Simoni na nimntu wa si ya Kilene, naho endaga tati yawo Alekizanda na Lufo. ");
INSERT INTO ziw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Niyo wamwigala Yesu hantu hakwitangwa Goligota, kugamba, “Hantu ha Ngobela.” ");
INSERT INTO ziw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wajeza kumwinka divai ihanganywe na mti wa kunywa ukwitangwa manemane, mna Yesu kalemela kuinywa. ");
INSERT INTO ziw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Niyo wamsulumiza mo msalaba, vikaheza wazitoila tegatega izisuche zakwe, kugamba suche ihi aguhe yuhi. ");
INSERT INTO ziw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yendaga saa ntatu ya mtondo umo wakamsulumiza mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Halanga ho msalaba hawandikwa malema yakwe, “Seuta ywa Wayahudi.” ");
INSERT INTO ziw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Seivyo wasulumizagwa wapolaganyi waidi hamwenga na Yesu, yumwenga kulume kwa Yesu na mtuhu naye kumoso kwakwe. ");
INSERT INTO ziw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mawandiko Yakukile yakugamba vino nayachinte, “Nakatungikwa hamwenga na wata wavu.” ");
INSERT INTO ziw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wantu nawakajinka mwe sila, nawakamhuluta kuno wakasingisa imitwi yawo, wakagamba, “Ha! Weye mta kuvuna Nyumba nkulu ya Chohile na kuizenga kwa mazuwa matatu! ");
INSERT INTO ziw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kwehonye we mwenye, usele kulaila mo msalaba!” ");
INSERT INTO ziw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ivyo walavyantambiko wakulu hamwenga na wahinya sigilizi niyo nawo wamtila, wakagamba, “Nakahonya watuhu, mna hakudaha kwehonya mwenye! ");
INSERT INTO ziw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Goja chikaule Kulisito, Seuta ywa Waizulaeli asele mo msalaba, suwe nachimzumile!” Wadya wantu waidi wasulumizwe hamwenga na Yesu nawo niyo wamhuluta. ");
INSERT INTO ziw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ize ibule sa mtandatu nomsi, isi yose igubikwa ni chiza chibwile kubula saa chenda nomsi. ");
INSERT INTO ziw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa chenda nomsi, niyo Yesu aila kwa izwi kulu, “Eloi, Eloi, lama sabakitani?” Nivyo kugamba, “Chohile ywangu, Chohile ywangu, nimbwani ukunileka?” ");
INSERT INTO ziw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wantu wamwenga wamwivile wagamba, “Mwetegelezeni, amwitanga Eliya!” ");
INSERT INTO ziw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yumwenga aguluka na lendele dijeligwe mwe siki igwaduke nakwitundika mwe tete. Niyo ainula kubula komlomo wa Yesu na kugamba, “Gojani, chikaule hegu Eliya neze amseleze kulaila ko msalaba.” ");
INSERT INTO ziw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu alavya izwi kulu na kubanika. ");
INSERT INTO ziw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Paziya dye Nyumba nkulu ya Chohile dyatatuka vihande vidi, kulaila kulanga kubula hasi. ");
INSERT INTO ziw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mnkondo mkulu achimale ho msalaba niyo amwona viya Yesu abanike. Agamba, “Mntu yuno ni chindedi ni Mwana Chohile.” ");
INSERT INTO ziw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kuna wavyele nawehadya wakasinya kulawa hale. Hamwenga nawo na ni Maliyamu Magidalena, Maliyamu nine dya Yakobo mdodo na Yusufu hamwenga na Salome. ");
INSERT INTO ziw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nawakamtimila Yesu umo E galilaya na kumwambiza. Wavyele watuhu walozize wezile Yelusalemu hamwenga naye nawo naweyaho. ");
INSERT INTO ziw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Umo chipindi chize chibule. Na ni zuwa dya kwe malanya, kugamba zuwa dikulongwela Zuwa dya kuhumula. ");
INSERT INTO ziw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Niyo eza Yusufu mkaya ywa Alimataya, ni mntu akutunyiswa mwe Chitala Chikulu, uyo naye nakagoja kwiza kwa Useuta wa Chohile. Elo, kambasa Pilato hena woga, niyo amlombeza enkigwe umwili wa Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato nakehelwa kugambilwa kugamba Yesu kabanika kale. Amwitanga mkulu ywa wankondo na kumuza hegu Yesu kabanika chikale. ");
INSERT INTO ziw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Eze amwive uyo mkulu kugamba ni chindedi Yesu kabanika kale, amgamba Yusufu auguhe umwili wa Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu agula sanda, auseleza umwili wa Yesu hasi, auzinga mwe sanda na kuuhamba mwe mbila isongolwe mwe luwe. Niyo afingilisa yuwe kulu kugubika ulwivi lwe mbila idya. ");
INSERT INTO ziw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliyamu Magidalena na Maliyamu nine dya Yusufu nawakasinya na kuwona aho umwili wa Yesu wikigwe. ");
INSERT INTO ziw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Zuwa dya Kuhumula dize dijinke, Maliyamu Magidalena, Maliyamu nine dya Yakobo hamwenga na Salome wagula mavuta yakupwepweleka wakaukulugute umwili wa Yesu. ");
INSERT INTO ziw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mtondotondo zuwa dya kuhumula mwe Chigiliki ni zuwa dya nkongo dya mazuwa mfungate. Kwize kutandazuke, waita kwe mbila. ");
INSERT INTO ziw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mwe sila wauzana, “Ni yuhi akunga achifingilisize diya idiyuwe dimo lwivi lwe mbila?” ");
INSERT INTO ziw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mna eze wasinye wawona kugamba yuwe diya dyuswa kale yuwe idyo dyendaga dikulisa. ");
INSERT INTO ziw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Niyo wengila mndani mwe mbila, wambwila mbwanga availe nkazu ing'aile kekala kulume, niyo wehelwa. ");
INSERT INTO ziw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mna mbwanga yudya niyo awagamba, “Msekwehelwa,” Simanya mwamzungula Yesu ywa Nazaleti asulumizwe mo msalaba. Hahali hano, kauyuka! Kaulani, ahantu wamwikaga. ");
INSERT INTO ziw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Haluse hitani mkawagambile wanampina wakwe hamwenga na Petulo kugamba, kawalongwelani kwita Galilaya, uko nammuone saviya awagambilagani,. ");
INSERT INTO ziw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Elo wavyele wadya niyo waguluka kulaila kwe mbila, kuno wazingiza naho wakangawala. Hawamgambile mntu yoyose mbuli idya kwa viya nawakogoha. ");
INSERT INTO ziw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu eze auyuke chilochilo zuwa dya kuhumula, kamlaila Maliyamu Magidalena, yudya abalazagwa mpepo mfungate mndani mwakwe. ");
INSERT INTO ziw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yudya mvyele niyo aita kuwagambila wambuyaze wendile hamwenga na Yesu. Nawo wendile wache kuomboleza na kwila. ");
INSERT INTO ziw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Weze weve kugamba Yesu kauyuka ni mjima naho mvyele uyo kamwona, hawazumile. ");
INSERT INTO ziw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Vikaheza, Yesu niyo awalaila wanampina wakwe waidi akatenda na mwili mtuhu umo wendile mwe sila wakaita mwe zikaya. ");
INSERT INTO ziw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nawo wauya na kuwagambila wamtimile Yesu watuhu, mna nawo hawazumile. ");
INSERT INTO ziw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Vikajika, Yesu niyo awalaila wanampina wakwe mlongo na yumwe umo wendile wakadya. Awakwahila kwa viya hawazumile, naho kwa viya nawana myoyo midala kuwazumila wadya wamwonile. ");
INSERT INTO ziw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Akaheza awagamba, “Hitani kwe isi yose, mkalonge Mbuli Yedi kwa chila mntu. ");
INSERT INTO ziw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mntu yoyose akunga azumile na kubatizwa nakombolwe, mna mntu yoyose hekuzumila nakantilwe. ");
INSERT INTO ziw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na vilagiso vino na vitimilane na wadya wazumile, kwa zina dyangu na waguluse mpepo, nawalonge kwa semo mpya, ");
INSERT INTO ziw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","nawatoze nyoka hegu wanadya chintu chikukoma hachiwakome, nawajeleke mikono yawo mwe wanyonje, nawo nawahone.” ");
INSERT INTO ziw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Elo Zumbe Yesu eze ajike kulonga ayo, niyo enulwa kulanga kwita kwembingu uko kekala kulume kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wanampina waita chila hantu na kulonga Mbuli Yedi, Zumbe naye asankanila hamwenga nawo na kulagisa kugamba kulonga kwawo nichindedi kwa sila ye vilagiso wadamanye.");
INSERT INTO ziw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mkulu Teofilo, Wantu walozize wajezaga kuwandika mbuli ziya zadamanyagwa mgati mwetu. ");
INSERT INTO ziw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wawandikaga saviya chigambilwe ni wadya waukuzi naho wavionaga, na wandima wa udya ulosi kukongela nkongo, ");
INSERT INTO ziw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ivyo mkulu Teofilo siwona vyawagila nikaule uchindedi we zimbuli izo zose kukongela nkongo, siwona ni vyedi niwandike kwa untanda mbuli izo ivyo zilaile. ");
INSERT INTO ziw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Sidamanya ivyo chani nawe umanye uchindedi we izimbuli ziya uhinyigwe. ");
INSERT INTO ziw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mwe dizuwa hadya Helode endaga seuta ywa Yudeya, hendaga na mlavyantambiko yumwenga akwitangwa Zakaliya, endaga ywa bunga dya walavyantambiko wa lukolo lwa Abiya. Na mkaziwe naketangwa Elizabeti naye endaga wo lukolo lwa mlavyantambiko mkulu akwitangwa Haluni. ");
INSERT INTO ziw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wose waidi wendaga wawoneka wedi kulongozi kwa Chohile, nawatoza kwa ukanuni miko na malagizo yose ya Zumbe. ");
INSERT INTO ziw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mna wendaga hawena mwana, kwaviya Elizabeti nendile hana cheleko, naho wose waidi wendaga wadalahala. ");
INSERT INTO ziw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zuwa dimwenga, Zakaliya endaga akamsankanila Chohile, akadamanya ndima yakwe ya ulavyantambiko kwaviya yendaga zamu ye dibunga dyakwe. ");
INSERT INTO ziw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kulawana na mazwela ya walavyantambiko, uyo asagulagwa kwa sila ya kumtoila tegatega kwa kwingila mndani mwe nyumba yo kuvikila ya Zumbe, chani akafunkize ubani. ");
INSERT INTO ziw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Fyo kulu dya wantu nendile dikuse dikalombeza mwe saa idya Zakaliya awoka ubani. ");
INSERT INTO ziw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Niyo mndima ywa kwembingu ywa Zumbe amlaila Zakaliya, kachimala ntendele ya kulume ye nchanja yo kufunkiziza ubani. ");
INSERT INTO ziw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaliya eze amwone, niyo ehelwa na kwingilwa ni woga. ");
INSERT INTO ziw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mna yudya mndima ywa kwembingu niyo amgamba, Zakaliya, “Use kogoha! Kwaviya Chohile keva malombeza yako, na mkaziwo Elizabeti nakwelekele mwana ywa chilume. Wenawe naumwitange Yohana. ");
INSERT INTO ziw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wenawe na utende na mbwedo na chinyemi, na wantu walozize nawabwede mo kwelekwa kwakwe. ");
INSERT INTO ziw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kwaviya nauwazwe kutenda mntu mkulu kulongozi kwa Zumbe. Hanywe divai hegu mpombe, naho namemezwe Muye Ukukile kukongela mwe nda ya nine. ");
INSERT INTO ziw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nawahitule Waizulaeli walozize kwa kumuwiya Zumbe Chohile ywawe. ");
INSERT INTO ziw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Namlongweile Zumbe, naho na atende na nguvu na udahi wa Muye saviya muwoni Eliya. Na wevanye vituhu watati zamntu na wana wawo, na kuwahitula wehi watendwe na umanyi saviya wakuwoneka wedi, naho na watende wantu wemalanye kale kumhokela Zumbe.” ");
INSERT INTO ziw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaliya amuza yudya mndima ywa kwembingu, “Nanimanye vivihi ichindedi che imbuli ino? Miye sidalahala, mkazangu naye kadalahala.” ");
INSERT INTO ziw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mndima ywa kwembingu amgamba, “Miye ni Gabulieli, akwikala haguhi na Chohile, anisigile nize kulonga na weye na kukugambila mbuli yedi ino. ");
INSERT INTO ziw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mna kwaviya huzumile ulosi wangu, ukunga uchinte mwe chipindi chikigwe. Kwaviya huzumile, haudahe kulonga, naho naunyamale kubula mwe dizuwa diya dye ndagano nadichinte.” ");
INSERT INTO ziw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wantu wendile wakamgoja Zakaliya wehelwa kwaviya kekalisa mwe nyumba yo kuvikila. ");
INSERT INTO ziw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Eze afose, hakudaha kulonga nawo, wantu niyo wamanya kugamba kawona uwoni mndani mwe nyumba yo kuvikila. Niyo alonga nawo kwa vilagiso mwe mikono yakwe. ");
INSERT INTO ziw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Eze abinde ndima yakwe, Zakaliya auya kwe kaya yakwe. ");
INSERT INTO ziw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yeze yomboke mazuwa majeche, mkaziwe Elizabeti niyo atenda msoka ekala hekaya yakwe miezi mishano. ");
INSERT INTO ziw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elongela, “Vino nivyo anitendele Zumbe,” akagamba. “Kanusiza soni zangu za kuleka kweleka!” ");
INSERT INTO ziw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mwezi wa mtandatu we inda ya Elizabeti Chohile amsigilaga mndima ywa kwembingu Gabulieli aite kwe isi ya Galilaya ikwitangwa Nazaleti. ");
INSERT INTO ziw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nakasigilwa kwa mwana chiche akwitangwa Maliyamu henati kudugana na mgosi. Mwana chiche uyo nakalombwa ni mgosi akwitangwa Yusufu, akulaila mo lukolo lwa Daudi. ");
INSERT INTO ziw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mndima ywa kwembingu niyo amlaila Maliyamu na kumlamsa, “Utondowazi utende naweye! Zumbe ehamwenga na weye naye kakujimbika vidala!” ");
INSERT INTO ziw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliyamu niyo engilwa ni chinyulu eze eve ulosi uwo, niyo ehelwa mbuli idya yagaze. ");
INSERT INTO ziw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Akaheza mndima ywa kwembingu amgamba, “Maliyamu, usekogoha, kwaviya Chohile kakufila mbazi. ");
INSERT INTO ziw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nawinule nda, naho naweleke mwana chilume, namwitange zina dyakwe Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Uyo natende mkulu naho netangwe Mwana Chohile Mkulu. Zumbe Chohile namwinke chigoda chakwe cho useuta, saviya endaga mwelesi ywakwe Daudi, ");
INSERT INTO ziw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","naho natende seuta ywa lukolo lwa Yakobo mazuwa yose, useuta wakwe hauna udumo!” ");
INSERT INTO ziw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliyamu niyo amuza mndima ywa kwembingu, “Navidahike, vivihi, mbuli ino?” Miye simmanyize mgosi. ");
INSERT INTO ziw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mndima ywa kwembingu amhitula, “Muye Ukukile nakwizile, na nguvu za Chohile nazikugubike. Kwa chausa icho mwana uyo nomwitange Mwana ywa Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Naho umanye mlukolo ywako Elizabeti, yudya wantu wamanyize hakweleka, mna haluse ana nda ya myezi mtandatu, hatahegu kadalahala. ");
INSERT INTO ziw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwaviya hamna hedikudahika kwa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliyamu niyo agamba, “Kaula, miye ni mtumwa ywa Zumbe,” “navitende saivyo ulongile.” Niyo mndima ywa kwembingu ahalawa. ");
INSERT INTO ziw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mwa mazuwa yadya Maliyamu kahalawa aita kwa kuchinyinta kwita ko mzi wendile kwa magulu ye mwe si ya Yudeya. ");
INSERT INTO ziw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Niyo engila mwe nyumba ya Zakaliya na kumlamsa Elizabeti. ");
INSERT INTO ziw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti eze eve indamsa yakwe Maliyamu, kazana mwe inda yakwe katugusa. Elizabeti niyo amemezwa Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Niyo alonga kwa izwi kulu, “Kujimbikwa weye kujinka wavyele wose, na umwana ukunga weleke kajimbikwa! ");
INSERT INTO ziw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ilaila vivihi mbuli ino, vikaleka mame ywa Zumbe ywangu anitalamkile? ");
INSERT INTO ziw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nize nive indamsa yako, kazana mwe nda yangu niyo katugusa kwa chinyemi. ");
INSERT INTO ziw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Chinyemi kwa weye uzumile longa mbuli ziya ugambilwe kulaila kwa Zumbe nazichinte!” ");
INSERT INTO ziw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maliyamu niyo alonga, “Umoyo wangu wamtogola Zumbe, ");
INSERT INTO ziw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","no muye wangu wamwelelwa Chohile Mwambula ywangu, ");
INSERT INTO ziw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kwaviya kanikumbuka, mtumwa wakwe mnyanyahala! Kukongela vino haluse na kujendeleza, vyeleko vyose navinitange mjimbikwa, ");
INSERT INTO ziw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kwaviya Chohile mta Udahi anidamanyiza vintu vikulu. Zina dyakwe ni ukuka. ");
INSERT INTO ziw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mbazi zakwe zekala vyeleko na vyeleko kwa wadya wakumwogoha. ");
INSERT INTO ziw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kadamanya vintu vikulu kwa mkono wakwe. Kawasambalagasa wata kweduvya fanyanyi zawo mwe myoyo yawo. ");
INSERT INTO ziw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kawaseleza maseuta wata nguvu kulaila mwe vigoda vyawo vyo useuta, na kuwakweza wachiwa. ");
INSERT INTO ziw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kawegusa wata sala kwa vintu vyedi, na kuwabalaza wagoli mikono ibule. ");
INSERT INTO ziw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kamwambiza Izulaeli, mndima ywakwe, naho kawafila mbazi wantu wakwe mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Saviya alongile kwa wababa zetu Bulahimu na lweleko lwakwe lose mazuwa yose!” ");
INSERT INTO ziw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliyamu niyo ekala na Elizabeti myezi mitatu, niyo auya kaya. ");
INSERT INTO ziw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mazuwa ya Elizabeti yo kwefungula yeze yabule, niyo efungula mwana chilume. ");
INSERT INTO ziw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wantu we haguhi hakwe hamwenga na walukolo wakwe weze weve ivyo Zumbe amfilise mbazi, niyo wose weleleswa hamwenga naye. ");
INSERT INTO ziw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mwana eze abule mazuwa mnane, weza kumjela ngasu. Niyo waunga wamwinke zina dya tati yakwe, etangwe Zakaliya. ");
INSERT INTO ziw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mna nine niyo agamba, “Bule! Zina dyakwe netangwe Yohana.” ");
INSERT INTO ziw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wamhitula, “Mna hahana mntu mo lukolo lwenyu akwitangwa zina idyo!” ");
INSERT INTO ziw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Niyo walonga na Zakaliya kwa vilagiso chani wamanye ivyo akunga amwitange mwanawe. ");
INSERT INTO ziw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaliya niyo alombeza wamwinke chibawo awandike, niyo awandika vino, “Zina dyakwe netangwe Yohana.” Wose niyo wehelwa vidala! ");
INSERT INTO ziw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ahadya Zakaliya niyo adaha kulonga naho, niyo akonga kumjimbika Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wantu we haguhi hakwe niyo wogoha, na mbuli za vintu ivyo niyo zalongwa kose kwa wagulu wose we isi ya Yudeya. ");
INSERT INTO ziw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chila evile mbuli izo, afanyanya mo moyo wakwe na kweuza, “Ivyo mwana uyo natende mntu ywani? Kwaviya udahi wa Zumbe wi hamwenga naye.” ");
INSERT INTO ziw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakaliya, ise dya Yohana, amemezwa Muye Ukukile, naye kalonga mbuli ino kwa uwoni kulaila kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ajimbikwe Zumbe, Chohile ywa Izulaeli! Kwaviya keza kuwambiza wantu wakwe na kuwambula. ");
INSERT INTO ziw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kachinka suwe Mwambula mta nguvu, kulaila mo lukolo lwa Daudi, mtumwa ywakwe. ");
INSERT INTO ziw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Saviya alongaga kukongela nkongo, kujinkila kwa wawoni wakwe wakukile, ");
INSERT INTO ziw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kugamba na chambulwe kulaila mwe wankondo wetu, na kulaila mwe mikono ya wadya wose wakuchihiwa. ");
INSERT INTO ziw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Alongaga nawawonele mbazi wadalahala wetu, na kudikumbuka lagano dyakwe dikukile. ");
INSERT INTO ziw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Elisaga kwa Bulahimu mkale ywetu, ");
INSERT INTO ziw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kugamba nachambule kulaila mwa wankondo wetu. Naho nachitende chidahe kumsankanila Chohile hehena kogoha, ");
INSERT INTO ziw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kwa ukuka na kwa kuwoneka wedi kwakwe, mazuwa yose yo ujima wetu. ");
INSERT INTO ziw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Nawe mwanangu, nawitangwe muwoni ywa Chohile Mkulu. Kwaviya naulongole kubula kulongozi kwa Zumbe, chani umdamanyize sila. ");
INSERT INTO ziw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kuwagambila wantu wakwe kugamba nawambulwe kwa kulekeilwa masa yawo. ");
INSERT INTO ziw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kwaviya Chohile ywetu ni mta mbazi. Nachigaile mmweko wa wambulwa kulaila kulanga, ");
INSERT INTO ziw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na kuwalangaziza wadya wose wakwikala mwe chiza, na chizuli cha file, na kuvilongoza iviga vyetu mwe isila ya utondowazi.” ");
INSERT INTO ziw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yudya mwana niyo akula umwili no muye. Ekalaga mwe nyika kubula zuwa diya eze awalaile wantu wa Izulaeli. ");
INSERT INTO ziw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mazuwa yadya, Augusito, seuta ywa Lumi kalavya sigilizi kugamba wantu wose wo uzumbe wa isi ya Lumi waungigwa wawazwe. ");
INSERT INTO ziw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iyo nani nkanana ya nkongo kwa wantu kuwazwa umo Kileniyo endile mkulu ywe isi ya Siliya. ");
INSERT INTO ziw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wantu wose niyo waita wawazwe, chila mntu ko mzi wakwe elekwe. ");
INSERT INTO ziw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu naye ahalawaga heisi ya Galilaya mo mzi wa Nazaleti, niyo aita kwe isi ya Yudeya, mo mzi wa Beselehemu, hantu elekagwa zumbe Daudi. Yusufu nakaita uko kwaviya nani mntu akulaila mo lukolo lwa Daudi. ");
INSERT INTO ziw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Niyo aita wawazwe hamwenga na Maliyamu mchumbakwe, endile ni msoka. ");
INSERT INTO ziw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Umo wecheyuko Betilehemu, zuwa dya Maliyamu dyo kwefungula niyo dyabula. ");
INSERT INTO ziw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Niyo efungula mwanawe ywa nkongo, mwana chilume. Amvisa vibwende, amgoneza mwe hondo, kwaviya nahehena he kwikala mwe nyumba za kufikila wajeni. ");
INSERT INTO ziw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mwe isi idya, kwendaga na wadimi wa ngoto mwe zinkonde, wakadima fyo dyawo dya ngoto kwa kuhokelezana neichilo. ");
INSERT INTO ziw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mndima ywa kwembingu ywa Zumbe awalaila, Ukulu wa Zumbe wawang'aziza kosekose, niyo wogoha vidala. ");
INSERT INTO ziw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mna mndima ywa kwembingu awagamba, “Msekogoha! Siwegailani mbuli yedi ya chinyemi vidala, ikunga iwatamile wantu wose. ");
INSERT INTO ziw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dyelo ko mzi wa Daudi, kelekwa Mwambula ywenyu, nuyo Kulisito, Zumbe! ");
INSERT INTO ziw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Chino ni chilagiso chikunga chileke mkammanya, namumbwile mwana mteke, kaviswa vibwende, kagonezwa mwe hondo.” ");
INSERT INTO ziw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ahadya, bunga kulu dya wandima wa kwembingu dyadugana na yudya mndima ywa kwembingu, wakamtogola Chohile na kugamba. ");
INSERT INTO ziw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ukulu una Chohile eyuko kulanga kwembingu, na utondowazi kwa wantu mwe isi awaungile.” ");
INSERT INTO ziw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wandima wa kwembingu wadya weze wauye kulanga, wadya wadimi wagambilana, “Haya, chiteni uko Beselehemu chikakaule idyo dilaile, Zumbe achigambile.” ");
INSERT INTO ziw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ivyo waita kwa kunyaguliza, wambwila Maliyamu na Yusufu hamwenga na yudya mwana umteke kagonezwa mwe hondo. ");
INSERT INTO ziw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Weze wamwone yudya mwana, niyo wawagambila mbuli wagambilwe ni mndima ywa kwembingu zikumlanga umwana. ");
INSERT INTO ziw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wadya wose wevile, wehelwa kwa yadya wagambilwe ni wadya wadimi. ");
INSERT INTO ziw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mna Maliyamu niyo ayaika yose mo moyo wakwe, akayafanyanya vitendese. ");
INSERT INTO ziw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Vikaheza wadya wadimi niyo wauya waka mtunya Chohile na kumtogola kwa chausa cha yose wevile na kuyawona, kwaviya yose yadamanyagwa saviya mndima ywa kwembingu endaga awagambilaga. ");
INSERT INTO ziw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mwe zuwa dya mnane, zuwa dyo kumjela ngasu umwana, niyo umwana etangwa Yesu saviya mndima ywa kwembingu alongaga umo nine nahenati kwinula nda. ");
INSERT INTO ziw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yabula mazuwa ya Maliyamu na Yusufu kulenguswa saviya mazwela ye Sigilizi ya Musa ikulagiza, niyo wamwigala umwana Yelusalemu uleke wamlavye kwa Zumbe, ");
INSERT INTO ziw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","saviya iwandikwe mwe Sigilizi ya Zumbe, “Chila mwana ywa nkongo wa chilume aungwa aikwe kwa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Niyo waita chani wakalavye majeleko saviya viungigwe mwe Sigilizi ya Zumbe ikulonga, “Suwa waidi hegu machinda maidi ya wasuwamanga.” ");
INSERT INTO ziw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mazuwa ayo, hadya Yelusalemu nahana mntu akwitagwa Simoni. Mntu uyo nendile kawoneka ywedi kulongozi kwa Chohile. Naho nakagoja vidala wambulwa wa Izulaeli, na Muye Ukukile ne hamwenga naye. ");
INSERT INTO ziw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Naye nakagambigwa ni Muye Ukukile kugamba habanike kubula eze amwone Kulisito asagulwe ni Zumbe. ");
INSERT INTO ziw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Welesi wa Yesu weze wamwigale Yesu mwe Nyumba nkulu ya Chohile chani wamdamanyize saviya vikungwa ni Sigilizi ya Musa, niyo Muye Ukukile amlongoza Simoni kubula mwe Nyumba iyo. ");
INSERT INTO ziw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoni amhokela umwana mwe mikono yakwe, amjimbika Chohile agamba, ");
INSERT INTO ziw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Haluse Zumbe, mlekeile mtumwa ywako, aite kwa utondowazi saviya ulongile. ");
INSERT INTO ziw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwaviya kwa meso yangu suuwona wambulwa wako, ");
INSERT INTO ziw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","uutendile uwoneke mwa wantu wose. ");
INSERT INTO ziw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Langailo dikunga diwagubwile wantu sawo Wayahudi yadya ukuunga weye, naho nadigale ukulu kwa wantu wako wa Izulaeli.” ");
INSERT INTO ziw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Welesi wa Yesu wehelwa ni izimbuli zilongigwe ni Simoni zo umwana. ");
INSERT INTO ziw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Niyo Simoni awajimbika na kumgambila Maliyamu, nine dya Yesu, “Mwana yuno kasagulwa ni Chohile kutenda luhosa lwa kugwa na kuuyuka kwa wantu walozize mwe isi ya Izulaeli. Naho natende chilagiso kulaila kwa Chohile, na wantu walozize nawamlemele. ");
INSERT INTO ziw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Naho fanyanyi za mwe myoyo ya wantu walozize nazigubulwe pwilili. Nawe mwenye, usungu saviya bamba dikutwa naukusenge mo umoyo wako.” ");
INSERT INTO ziw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hendaga na muwoni yumwenga mvyele akwitangwa Ana, mwana Fanueli, ywa kabila dya Asheli. Mvyele uyo ekalaga na mgosiwe kwa mihilimo mfungate kukongela kusolwa kwakwe. ");
INSERT INTO ziw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Niyo afilwa ni mgosiwe. Naho nana mihilimo milongo mnane na mine. Chipindi chose icho nakekala mwe nyumba nkulu ya Chohile, akalombeza kwa kufunga na kulombeza chilo na msi. ");
INSERT INTO ziw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yuno nakalaila mwe sila idya, akamtogola Chohile, na kawagambila mbuli ya yudya mwana wantu wose nawakagoja wambulwa wa Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusufu na Maliyamu weze wabinde yose saviya waungigwe ni Sigilizi ya Zumbe, wauya Nazaleti, mo mzi wa Galilaya. ");
INSERT INTO ziw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yudya mwana niyo akula na kutenda na nguvu, niyo atenda na umanyi, na wedi wa Chohile navihamwenga naye. ");
INSERT INTO ziw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Welesi wa Yesu nawa mazwela ya kwita Yelusalemu chila mhilimo mwe Pasaka. ");
INSERT INTO ziw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu eze abuze mihilimo mlongo na midi, niyo waita naye mwe sikunkulu iyo saviya nawakaungigwa ni mazwela. ");
INSERT INTO ziw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sikunkulu ize isile, wakonga kuya kaya. Mna yudya mwana Yesu niyo asigala ko mzi wa Yelusalemu, mna welesi wakwe hawavimanyize. ");
INSERT INTO ziw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nawakamanya emgati mwe difyo dya wantu, wajenda kubula zuwa diswa. Niyo wakonga kumlonda kwa walukolo wawo na wambuya wawo. ");
INSERT INTO ziw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Weze wamswese, wauya Yelusalemu kumlonda. ");
INSERT INTO ziw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yeze yabule mazuwa matatu, wambwila mwe Nyumba nkulu ya Chohile, kekala mgati mwa wahinya wa Chiyahudi, awategeleza na kuwauza milosi. ");
INSERT INTO ziw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wose wamwetegeleze wehelwa ni zifanyanyi zakwe no umanyi ananawo. ");
INSERT INTO ziw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Welesi wakwe weze wamwone wehelwa. Mami yakwe amgamba, “Mwanangu, ni mbwani ukuchitenda vino? Kaula, miye na iso nachikakulonda kwa chinyulu.” ");
INSERT INTO ziw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu awagamba, “Kwa mbwani mwanilonda? Hammanyize kugamba naungwa nikale mwe inyumba ya Tate?” ");
INSERT INTO ziw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mna wowo hawaimanyize imbuli idya awagambile. ");
INSERT INTO ziw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu niyo auyanya na welesi wakwe kubula Nazaleti, naye nakawevisa ise na nine. Nine azika izimbuli zose mo moyo wakwe. ");
INSERT INTO ziw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Naye Yesu niyo akula na kongezeka chimo na kutenda na umanyi, na kujendeleza kumuwagila Chohile na wantu. ");
INSERT INTO ziw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mhilimo wa mlongo na mishano wo uzumbe wa zumbe Tibeliyo zumbe ywa Lumi, Pontiyo Pilato endaga mkulu ywa isi ya Yudeya, na Helode endaga chilongozi ywa Galilaya, na mlukolo ywakwe Filipo endaga chilongozi ywa si ya Ituleya hamwenga na Tilakoniti, Lisaniya naye endaga chilongozi ywa Abilene, ");
INSERT INTO ziw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa wendaga walavyantambiko wakulu. Chipindi icho mbuli ya Chohile yambwila Yohana mwana ywa Zakaliya kwedijangwa. ");
INSERT INTO ziw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohana niyo abula chila hantu mwe si zose zihakane no mto Yolodani, akalonga, “Kweileni masa yenyu, mbatizwe, Chohile nawalekeileni masa yenyu.” ");
INSERT INTO ziw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Saviya iwandikwe mwe chitabu cha muwoni Isaya “Izwi dya mntu akwila kwe nyika, ‘Idamanyeni sila ya Zumbe, mchumize hadya akunga ajinkile! ");
INSERT INTO ziw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Chila kolongo nadigubikwe, chila gulu na kagulu visalahazwe. Sila zigonjize zichumizwe, na sila zibanike zidamanywe vyedi. ");
INSERT INTO ziw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Chila mntu nawone ivyo Chohile nachambule!’ ” ");
INSERT INTO ziw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohana nakawagambila wadya wose wezile chani wabatizwe, “Nyuwe welekwa wa nyoka! Ni yuhi awagambileni mwadaha kusumka kanto dya Chohile dikwiza? ");
INSERT INTO ziw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Elo lagisani kwa ntendwa kugamba mweila masa yenyu. Msekwelongela mwe myoyo yenyu, ‘Bulahimu ni tati yetu!’ Nawagambilani kugamba, Chohile adaha kuyahitula mayuwe yano kutende wana Bulahimu! ");
INSERT INTO ziw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mna haluse hoya imalanywa kale kukanta masina ye miti, chila mti haukweleka matunda yedi naukantwe na kudulwa mo moto.” ");
INSERT INTO ziw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Wantu niyo wamuza, “Haluse chitende mbwani?” ");
INSERT INTO ziw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Niyo awahitula, “Mta nkazu mbili amwinkage imwenga yudya hena, mta nkande atende saivyo.” ");
INSERT INTO ziw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wachisanya kodi nawo niyo weza chani wabatizwe, wamuza, “Mhinyi, suwe naswi chitende mbwani?” ");
INSERT INTO ziw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Niyo awahitula, “Msekuguha vintu kujinka viya mpangilwe.” ");
INSERT INTO ziw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wankondo nawo niyo wamuza, wamgamba, “Suwe naswi chitende mbwani?” Awagamba, “Msekuhoka vintu vya wantu, msekumlongela mntu kwa udanti, naho mzumile maliho mkulihwa.” ");
INSERT INTO ziw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mna kwaviya wantu nawakagoja kwiza kwa Kulisito, ivyo wakonga kufanyanya mwe myoyo yawo kugamba Yohana nuyo Kulisito. ");
INSERT INTO ziw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohana niyo awahitula, “Miye nawabatizani kwa mazi, mna eza mntu mta udahi kujinka miye. Uyo akwiza miye sikuwagila hata kufungula izisigi ze vilatu vyakwe, uyo nawabatizeni kwa Muye Ukukile na kwa moto. ");
INSERT INTO ziw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ana lungo mo mkono wakwe, naye aheta ingano yakwe. Akajika naike ngano kwedigulu, mna makanka nayoke ko moto houkufa.” ");
INSERT INTO ziw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ivyo kwa mbuli ntuhu zilozize Yohana niyo awagambila wantu Mbuli Yedi na kuwagamba waleke wavu wawo. ");
INSERT INTO ziw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Naho Yohana nakamkwahila Helode, mkulu ywa Galilaya kwaviya nakamsola Helodiya, mkaza mlukolo ywa Filipo mwe mbuli ntuhu zihiye zilozize. ");
INSERT INTO ziw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Vikajika Helode nakongezeza wavu wakwe hadya eze amjele Yohana mwe digeleza. ");
INSERT INTO ziw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Niyo wantu wose weze wabatizwe, Yesu naye niyo abatizwa. Umo akalombeza, kulanga kwembingu niyo kwagubuka, ");
INSERT INTO ziw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Muye Ukukile niyo asela mnanga mwakwe mwe mligano uge suwa manga. Niyo izwi kulaila kwembingu dyevika, “Weye nuyo mwanangu, hungisa. Weye waniwagila.” ");
INSERT INTO ziw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu eze akonge ndima yakwe, nakabula mihilimo milongo mitatu. Wantu nawakammanya kugamba ni mwana Yusufu, mwana Eli. ");
INSERT INTO ziw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli nani mwana Matati, endaga mwana Lawi, mwana Meliki, mwana Yana, mwana Yusufu, ");
INSERT INTO ziw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","endaga mwana Matatiya, mwana Amosi, mwana Nahumu, mwana Hesili, mwana Nagayi, ");
INSERT INTO ziw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","endaga mwana Mati, mwana Matatiya, mwana ywa Semeni, mwana ywa Yusufu, mwana ywa Yuda, ");
INSERT INTO ziw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","endaga mwana Yohanani, mwana Lesa, mwana Zelubabeli, mwana Shealitieli, mwana Neli, ");
INSERT INTO ziw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana Meliki, mwana Adi, mwana Kosamu, mwana Elimadamu, mwana Eli, ");
INSERT INTO ziw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","endaga mwana Yoshuwa, mwana Eliezeli, mwana Yolimu, mwana Matati, mwana Lawi, ");
INSERT INTO ziw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","endaga mwana Simoni, mwana Yuda, mwana Yusufu, mwana Yonamu, mwana Eliakimu, ");
INSERT INTO ziw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","endaga mwana Meleya, mwana Mena, mwana Matati, mwana Natani, mwana Daudi, ");
INSERT INTO ziw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","endaga mwana Yese, mwana Obedi, mwana Boazi, mwana Salimoni, mwana Nashoni, ");
INSERT INTO ziw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","endaga mwana Aminadabu, mwana Adimini mwana Hesiloni, mwana Pelesi, mwana Yuda, mwana wa Alini, ");
INSERT INTO ziw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","endaga mwana Yakobo, mwana Isaka, mwana Bulahimu, mwana Tela, mwana Naholi, ");
INSERT INTO ziw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","endaga mwana Selugi, mwana Leyu, mwana Pelegi, mwana Ebeli, mwana Sala, ");
INSERT INTO ziw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","endaga mwana Kenani, mwana Alifakisadi, mwana Shemu, mwana Nuhu, mwana Lameki, ");
INSERT INTO ziw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","endaga mwana Mesusela, mwana Henoko, mwana Yaledi, mwana Mahalaleli, mwana Kenani, ");
INSERT INTO ziw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","endaga mwana Enoshi, mwana Seti, mwana Adamu, endile mwana Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu kauya kulaila ko mto Yolodani kamema Muye Ukukile niyo alongozwa ni Muye uyo kwita kwe nyika. ");
INSERT INTO ziw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uko niyo ajezwa ni Mwavu kwa mazuwa milongo mine. Mwe chipindi icho chose hadile chochose, ivyo eze yajinke mazuwa ayo niyo alumwa nisala. ");
INSERT INTO ziw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mwavu amgamba, “Hegu weye wi Mwana ywa Chohile, digambe diyuwe dino dihituke mgate.” ");
INSERT INTO ziw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu amhitula, “Iwandikwa mwa Mawandiko Yakukile, ‘Mntu hakwikala kwa kudya mgate uwodu.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Akaheza Mwavu amkweza hantu henukile kulanga na kumlagisa useuta wi mwe isi yose. ");
INSERT INTO ziw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Niyo Mwavu amgamba, “Nahwike useuta wose uwo una udahi wose na Ukuka na ugoli wose,” “Kwaviya vyose sinkigwa miye, nidahe kumwinka yoyose saviya hunga. ");
INSERT INTO ziw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Elo una nifikila madi kwa kunivikila miye, vyoseni vino navitende vyako.” ");
INSERT INTO ziw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu niyo amhitula, “Iwandikwa vino mwa Mawandiko Yakukile, ‘Mvikile Zumbe Chohile ywako na kumsankanila uyo du!’” ");
INSERT INTO ziw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Akaheza Mwavu amwigala Yelusalemu na kumkweza halanga ho lunenengwe he Nyumba nkulu ya Chohile, niyo amgamba, “Hegu weye wi Mwana ywa Chohile, kwedule hasi kulaila hano. ");
INSERT INTO ziw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kwaviya iwandikwa mwa Mawandiko Yakukile kugamba, ‘Chohile nawasigile wandima wa kwembingu wakwe wakudime.’ ");
INSERT INTO ziw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Naho viwandikwa kugamba, ‘Nawakutoze mwe mikono yawo, chani unasekwebaja chiga chako mwe diyuwe.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mna Yesu niyo amhitula, “Viwandikwa kugamba, ‘Usekumjeza Zumbe Chohile ywako.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mwavu eze abinde kumjeza Yesu kwa chila sila, niyo amwasa kwa chipindi. ");
INSERT INTO ziw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu niyo auya Galilaya, atenda kamema nguvu za Muye Ukukile. Mbuli zakwe niyo zajendeleza mwe zi si zose zi mjihi. ");
INSERT INTO ziw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nakahinya mwe zi nyumba zo kuvikila zawo naho nakatunyiswa ni wantu wose. ");
INSERT INTO ziw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu niyo aita Nazaleti, hantu akwile, mwe zuwa dya kuhumula, engila mwe nyumba yo kuvikila saviya azwele. Niyo achimala chani asome Mawandiko Yakukile, ");
INSERT INTO ziw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","niyo enkigwa chitabu cha muwoni Isaya. Kachigubula na kusoma hantu hawandikwe, ");
INSERT INTO ziw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Muye wa Zumbe wi hamwenga na miye, kwaviya kanisagula niwagambile wachiwa Mbuli Yedi. Kanisigila niwagambile wadya wafungigwe kugamba nawalekeilwe, na wadya hawekuwona nawawone naho, kanisigila kuwalekeila wadya wakusulumizwa, ");
INSERT INTO ziw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na kulonga kugamba chipindi chibula, Zumbe hadya nakombole wantu wakwe.” ");
INSERT INTO ziw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Akaheza Yesu niyo agubika chiya chitabu, amvuziza mndima, na kwikala hasi. Wantu wose nawe mwe nyumba yo kuvikila wamng'oila meso, ");
INSERT INTO ziw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","niyo akonga kuwagambila, “Mawandiko yano dyelo yachinta, saviya mwivile yakasomwa.” ");
INSERT INTO ziw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wose niyo watamilwa na kwehelwa ni milosi yedi ya mbuli asimwile. Wagamba, “Yuno suyo mwana ywa Yusufu?” ");
INSERT INTO ziw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu awagamba, “Sivimanya kugamba namnigambile mliganyo, ‘Mganga, kwehonye mwenye.’ Naho namnigambe kugamba chiva mbuli zose udamanye uko ko mzi wa Kapelinaumu vidamanye hano he kaya yako. ");
INSERT INTO ziw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu ongezeza, chindedi nawagambilani vino,” kugamba, “Hahana muwoni natunywe kwe isi yakwe mwenye. ");
INSERT INTO ziw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Tegelezani chindedi, kwendaga na wavyele walozize mwe isi ya Izulaeli mwa mazuwa ya Eliya. Mwe chipindi chiya kwendaga hakuna fula kwembingu kwa mihilimo mitatu na myezi mtandatu naho niyo kwatenda na gumbo ditendese mwe si yose. ");
INSERT INTO ziw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hata ivyo Eliya hasigilwe kwe mntu mgati mwawo, ukaleka du kwa yudya mvyele abanikilwe ni mgosi Saleputa mwe si ya Sidoni. ");
INSERT INTO ziw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Naho kwendaga na wantu walozize wata matana wakekala mwe isi ya Izulaeli mwa mazuwa ya muwoni Elisha, mna na hahana hata mtu yumwenga mgati mwawo alenguswe, mna Naamani uyodu we isi ya Siliya.” ");
INSERT INTO ziw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wantu wose nawe mwe idya nyumba yo kuvikila weze weve ivyo, niyo wengilwa ni maya. ");
INSERT INTO ziw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Niyo wachimala, wamlavya Yesu kuse ko mzi, na kumwigala halanga ho lugulu hadya mzi wawo uzengigwe. Nawakaunga wamdule hasi kulaila mnkanda mo lugulu, ");
INSERT INTO ziw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","mna Yesu niyo ajinka mgati mwawo na kwita zakwe. ");
INSERT INTO ziw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Akaheza Yesu niyo aita Kapelinaumu, mwe mzi wa Galilaya. Na akahinya wantu we Zuwa dya Kuhumula. ");
INSERT INTO ziw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Woseni niyo weheleswa eze wawone ivyo endile akawahinya, kwaviya nakahinya kwa udahi. ");
INSERT INTO ziw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mwe nyumba yo kuvikila kwendaga na mntu mta mpepo nchafu, niyo aguta kwa izwi kulu, ");
INSERT INTO ziw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Haa! Yesu ywa Nazaleti, waunga mbwani kwetu? Kwiza uchikome? Sikumanya weye wi yuhi, wi Msigilwa Mkuka ywa Chohile!” ");
INSERT INTO ziw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu niyo aikwahila idya mpepo, “Nyamala naho mlawe yuno mntu!” Mpepo idya yamgwisa hasi yudya mntu kulongozi kwawo, yamlawa hemlumize. ");
INSERT INTO ziw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wantu wose weheleswa na kugambilana, “Yano ni mahinyo yani? Mntu yuno ana udahi na nguvu za kukwahila mpepo nchafu, nazo zamwiva!” ");
INSERT INTO ziw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Elo mbuli za Yesu niyo zazagala chila hantu mwe isi idya. ");
INSERT INTO ziw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu niyo afosa mwe nyumba yo kuvikila aita kwe nyumba ya Simoni. Mkwewe Simoni ywe chivyele endaga akalumiswa homa, wamlombeza Yesu amhonye. ");
INSERT INTO ziw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu aita na kuchimala hajihi na yudya mvyele aikwamila idya ihoma imlawe. Ihoma nayo niyo yamlawa, aho akonga kuwasankanila. ");
INSERT INTO ziw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Zuwa dize diswe, wamwigaila Yesu wantu wose wendile wakalumwa ni manyonje yesimile, niyo awajelekela mikono chila yumwenga na kuwahonya woseni. ");
INSERT INTO ziw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mpepo niyo zawafosa wantu walozize, wakaguta kugamba, “Weye wi Mwana ywa Chohile!” Mna Yesu kazikwahila naho haungile zilonge, kwaviya nawammanya kugamba uyo nuyo Kulisito. ");
INSERT INTO ziw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mtondo wakwe eze kuche, Yesu afosa mo mzi na kwita hantu hechedu. Fyo kulu dya Wantu wakonga kumbasa, weze wamuwone, niyo waunga wamchinde asekuhalawa aho hawo. ");
INSERT INTO ziw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mna awagamba, “Naungigwa nilonge Mbuli Yedi ya Useuta wa Chohile mwe mizi mituhu nayo, kwaviya icho nicho nisigilwe ni Chohile kudamanya.” ");
INSERT INTO ziw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Elo Yesu ajendeleza kulonga mwe isi ya Yudeya mndani mwe zi nyumba zo kuvikila ya Galilaya. ");
INSERT INTO ziw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Zuwa dimwenga Yesu achimalaga hankanda hedi ziwa dya Genesaleti. Wantu walozize nawammemela na kufintana kwita kwakwe kwetegeleza ulosi wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Awona ngalawa mbili zijeile nanga mpwani, walowa wazasa nawakasunta izinyavu zawo. ");
INSERT INTO ziw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu engila mwe ngalawa imwenga yendaga ya Simoni niyo amgamba aigale hale hadodo na mpwani. Akajika ekala mwe ingalawa iyo na kuhinya fyo dya wantu. ");
INSERT INTO ziw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eze abinde ukuhinya, amgamba Simoni, “Igale halehale ingalawa kwa mazi amatali, niyo weye hamwenga na mbuyazo mziseleze izinyavu zenyu mlowe samaki.” ");
INSERT INTO ziw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni amhitula, “Zumbe,” “chilowa chilo chijima mna hachipatile chochose. Mna hegu weye walonga seivyo, naniziseleze izinyavu.” ");
INSERT INTO ziw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Weze waseleze izinyavu niyo walowa samaki zilozise naho izinyavu niyo zakonga kukantika. ");
INSERT INTO ziw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ivyo wawatagusa weyawe wadya nawe mwe ingalawa intuhu weza wawambize. Weza na kumemeza samaki mwe zingalawa zoseni mbili na zimeme niyo zakonga kudidimila. ");
INSERT INTO ziw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petulo eze awone ayo yalaile, amfikila madi Yesu na kumgamba, Zumbe! “Halawe hangu, miye ni mta masa!” ");
INSERT INTO ziw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni na wose wendile wehamwenga naye niyo weheleswa kwa chausa che zisamaki walowile. ");
INSERT INTO ziw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Seiviya weyawe dya Simoni, Yakobo na Yohana, wana Zebedayo nawo wehelewa. Yesu amgamba Simoni, “Usekogoha, kukongela vino haluse nautende mlowa wantu.” ");
INSERT INTO ziw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Elo walavya izingalawa zawo mwa mazi na kuzibuza mpwani. Waleka chila chintu na kumtimila Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu hadya endaga kwemzi umwenga mgati mwe mizi idya kwalailaga mntu endaga akuhuma matana. Eze amwone Yesu, edula hasi na kumlombeza, “Zumbe, ukaunga, wadaha kunilengusa!” ");
INSERT INTO ziw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu achumiza mkono wakwe na kumdonta. Niyo amgamba, “Lenguka!” Aho unyonje wamlawa mntu uyo. ");
INSERT INTO ziw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu amgamba, “Usekumgambila mntu yoyose, mna hita kwa mlavyantambiko akuwone, naho ukalavye jeleko kwa chausa cho kulenguka kwako saviya Musa asigile, chani wantu waukule kugamba kuhona.” ");
INSERT INTO ziw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mna mbuli za Yesu niyo zajendesa vidala, na mafyo ya wantu nayo niyo yaita kumwetegeleza na kuhonywa manyonje yawo. ");
INSERT INTO ziw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mna Yesu nakaita hantu hechedu na kumlombeza Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Zuwa dimwenga Yesu nakahinya. Mafalisayo wamwenga na wahinya Sigilizi walaile mwe chila mzi wa Galilaya na Yudeya na Yelusalemu hadya ekale akahinya. Nguvu za Zumbe nazimwingila ahonye wanyonje. ");
INSERT INTO ziw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wantu wamwenga naweza wamwinula mntu mwe lusazi aholomale. Niyo wajeza kumwingiza kunyumba wamwike kulongozi kwa Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mna kwachausa che difyo dya wantu, wadunduga kumwingiza mndani. Ivyo wamwinula no lusazi na kumjisiza kulanga kwe digulu, waponkola langa, na kumseleza no lusazi lwakwe mgati mwe difyo kulongozi kwa Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu eze awone uzumizi wananawo, niyo amgamba, “Mbuyangu, kulekeilwa masa yako.” ");
INSERT INTO ziw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wahinya Sigilizi hamwenga na Mafalisayo wakonga kulonga wenye, “Yuno ni mntu ywani akumhuluta Chohile? Chohile nuyo ichedu akudaha kulekeila masa!” ");
INSERT INTO ziw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu kabunkula zifanyanyi zawo na kuwagamba, “Ni mbwani mkufanyanya vino mwe myoyo yenyu? ");
INSERT INTO ziw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Vihufu ni vihi kugamba, ‘Masa yako yalekeilwa,’ hegu kugamba, ‘Chimala ujende?’ ");
INSERT INTO ziw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mna naunga mmanye kugamba, Mwana ywa Mntu ana udahi wa kulekeila masa mwe isi yose.” Akajika amgamba yudya mntu aholomale, “Nakugamba, chimala, guha ulusazi lwako wite kukaya!” ");
INSERT INTO ziw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ahadya mntu yudya achimala kulongozi kwawo wose, etwika ulusazi lwakwe endile akagonela, aita kaya, kuno akamtunya Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wantu wose niyo wehelweswa! Wengilwa ni woga, wamtunya Chohile, wakagamba, “Dyelo chiwona maula!” ");
INSERT INTO ziw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Aho vize viheze, Yesu akafosa niyo amwona mchisanya kodi yumwenga akwitangwa Lawi, ekale mwe kazumba ka kuchisanyiza kodi. Yesu amgamba, “Nitimila.” ");
INSERT INTO ziw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi achimala, asa chila chintu na kumtimila. ");
INSERT INTO ziw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Akaheza Lawi niyo amdamanyiza Yesu ngasu nkulu mwe nyumba yakwe, bunga kulu dya wachisanya kodi na wantu watuhu wendaga wakadya hamwenga nawo. ");
INSERT INTO ziw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafalisayo wamwenga na wahinya sigilizi wamwenga wa bunga dya Mafalisayo wawagamba wanampina wa Yesu. “Ni mbwani mkudya na kunywa na wachisanya kodi hamwenga na wata masa?” ");
INSERT INTO ziw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu awahitula, “Wantu hewekulumwa hawakunga mgangana, mna wadya wakulumwa. ");
INSERT INTO ziw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sizile kuwetanga wakuwoneka wedi weile, mna wadya wata masa wadahe kweila masa yawo.” ");
INSERT INTO ziw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wantu watuhu wamgamba Yesu, “Wanampina wa Yohana wafunga kudya nkanana zilozize na kumlombeza Chohile, na wanampina wa Mafalisayo nawo wadamanya seivyo, mna wanampina wako wadya na kunywa.” ");
INSERT INTO ziw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu awahitula, “Mwafanyanya kugamba mwadaha kuwachinda wajeni wagonekwe kwe nyinka wafunge wasekudya aho msozi achei hamwenga nawo? Havikudahika! ");
INSERT INTO ziw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mna mazuwa yeza umo msozi aneza kusigwa mgati mwawo, aho naho nawafunge.” ");
INSERT INTO ziw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu naho awagambila mligano uno, “Hahana mntu akutatula chilaka cha suche mpya na kuchisuma mwe suche isakale. Anadamanya ivyo, nabalange isuche impya, na chiya chilaka che suche impya hachiivane neidya isuche isakale. ");
INSERT INTO ziw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Seivyo hahana mntu akujela divai mpya mwe mikwiji ya kale, kwaviya anadamanya ivyo, divai impya naitule idya mikwiji, divai naitikile hasi, mikwiji nayo naiwole vyabule. ");
INSERT INTO ziw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mna divai mpya yawagila ijelwe mwe mikwiji mihya! ");
INSERT INTO ziw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Naho hahana mntu naunge anywe divai mpya anaheza kunywa divai ya kale. Agamba, ‘Idya divai ya kale ni yedi,’ vitendese.” ");
INSERT INTO ziw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Zuwa dimwe dya Kuhumula Yesu na wanampina wakwe nawakajinka mwe nkonde zo uhemba. Wanampina wakwe niyo wakonga kuhasula maiso, wayahugusa ne mikono yawo, na kudya uhemba. ");
INSERT INTO ziw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafalisayo wamwenga wauza, “Ni mbwani mkudamanya mbuli ilemezwe mwe sigilizi yetu kudamanywa mwe zuwa dya Kuhumula?” ");
INSERT INTO ziw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu awahitula, “Vino hamsomile viya adamanyaga Daudi hamwenga na weyawe umo nawana sala? ");
INSERT INTO ziw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yeye nakengila mwe nyumba nkulu ya Chohile, niyo aguha migate ilavigwe kwa chausa cha Chohile na kuidya, niyo awapangila weyawe. Naho Sigilizi zilemeza mntu yoyose kudya migate iyo, mna walavyantambiko du.” ");
INSERT INTO ziw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Akajika Yesu awagamba, “Mwana ywa Mntu nuyo Zumbe ywa Zuwa dya Kuhumula.” ");
INSERT INTO ziw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mwe Zuwa tuhu dya Kuhumula Yesu aitaga kwe kuhinya mwe nyumba yo kuvikila. Mwe nyumba iyo mwendaga na mntu aholomale mkono wakwe wa kulume. ");
INSERT INTO ziw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wahinya Sigilizi wamwenga na Mafalisayo wamwenga nawakazungula chintu chikunga chimhose Yesu, elo wamsinyisa hegu namhonye mntu yudya mwe Zuwa dya Kuhumula. ");
INSERT INTO ziw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mna kwaviya Yesu nakamanya izifanyanyi zawo niyo amgamba yudya mntu mta mkono uholomale, “Souchimale hano.” Yudya mntu enuka niyo achimala hadya. ");
INSERT INTO ziw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Akaheza Yesu niyo awagamba, “Nawauzani, Sigilizi yetu yachunga chidamanye yedi hegu yehiye mwe Zuwa dya kuhumula? Kuhonya ujima wa mntu hegu kukoma?” ");
INSERT INTO ziw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Niyo ahituka na kuwakaula wantu woseni wendile hadya, niyo amgamba yudya mntu, “Chumiza umkono wako.” Naye niyo adamanya seivyo, mkono wakwe niyo wahona. ");
INSERT INTO ziw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mna wadya wantu niyo wengilwa niyo wehiwa wafanyanya wamtende chisimo chani Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mwa amazuwa ayo Yesu akwelaga ko lugulu akucheleza chilo chijima akamlombeza Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Eze kuche, niyo etanga wanampina wakwe, na kusagula mlongo na waidi mgati mwawo, na kuwetanga wasigilwa, ");
INSERT INTO ziw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni yudya amwinkile zina dya Petulo na mlukolo ywakwe Anduleya, Yakobo na Yohana, Filipo na Batolomayo, ");
INSERT INTO ziw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo na Tomaso, Yakobo mwana ywa Alifayo, na Simoni akwitangwa Zelote, ");
INSERT INTO ziw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana ywa Yakobo na Yuda Isikaliyote amhosize Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu eze asele kulaila ko lugulu hamwenga na wanampina wakwe, wachimala hantu hachumile. Wanampina wakwe walozize. Fyo kulu dya wantu walaile ntendele zose za Yudeya na wantu walaile Yelusalemu na mpwani ya Tilo na Sidoni, ");
INSERT INTO ziw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wantu awo naweza kumwetegeleza Yesu na kuhonywa manyonje yawo. Wadya wendile wakasulumizwa ni mpepo nchafu nawahonywa. ");
INSERT INTO ziw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wantu wose nawakajeza kumkufya, kwa idya nguvu nendile ikalaila mndani mwakwe na kuwahonya wose. ");
INSERT INTO ziw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kawasinya wanampina wakwe agamba, “Chinyemi china nyuwe wachiwa, kwaviya Useuta wa Chohile ni wenyu! ");
INSERT INTO ziw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Chinyemi china nyuwe mkulumwa nisala vino haluse, kwaviya namwigute! Chinyemi china nyuwe mkwila vino haluse, kwa viya namseke!” ");
INSERT INTO ziw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Chinyemi china nyuwe chipindi wantu wakawaihiwani, na kuwalemela, na kuwahulutani, na kugambigwa mwiha, kwa chausa cha Mwana ywa Mntu! ");
INSERT INTO ziw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mbwedani aho mbuli izo nazilaile, kwaviya mwikiwa ntunyo nkulu uko kwembingu. Kwaviya wadalahala wawo wawadamanyizaga saivyo wawoni.” ");
INSERT INTO ziw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Mna na mvimanye nyuwe mwi wagoli vino haluse, kwaviya mhokela kale chinyemi chenyu! ");
INSERT INTO ziw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Namvimanye nyuwe mwigute vino haluse, kwaviya namtende na sala! Namvimanye nyuwe mkuseka vino haluse, kwaviya namwomboleze na kwila! ");
INSERT INTO ziw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Namvimanye nyuwe uneva wantu wakawatogolani, kwaviya wadalahala wawo watendaga saivyo wawoni wadanti. ");
INSERT INTO ziw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mna nawagambilani nyuwe mkunitegeleza, waungeni wankondo wenyu, wadamanyizeni vyedi wadya wakuwehiwani. ");
INSERT INTO ziw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wajimbikeni wadya wakuwaligita, naho walombezezeni kwa Chohile wadya wakuwadamanyiza yehiye. ");
INSERT INTO ziw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Uneva mntu anakutowa mwe funda imwe, mleke akutowe mwe funda ya kaidi nayo, naho uneva mntu anaguha inkazu yako, mwinke ne shati nayo. ");
INSERT INTO ziw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mntu yoyose akukulombeza chintu, naho mntu yoyose akukuhoka chintu chako, usekumgamba akuvuzize. ");
INSERT INTO ziw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Saviya mkunga wantu wawadamanyizeni nyuwe nanywi muwadamanyize seivyo. ");
INSERT INTO ziw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Uneva mwa waunga wadya wakuwaungani awodu, ni mbwani mkunga mhokele ntogozi? Kwaviya hata wata masa wawaunga wadya wakuwaunga! ");
INSERT INTO ziw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Naho uneva mkawadamanyiza yedi wadya wakuwadamanyizani yedi, na mhokele ntunyo yani? Kwaviya hata wata masa wadamanya seivyo! ");
INSERT INTO ziw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Naho uneva mwawakopesha wadya mmanyize kugamba nawawaliheni, ni mbwani mkunga mhokele ntogozi? Hata wata masa wawakopesha wata masa, wakatenda na msuhi wakulihwa chiyasi ichiya! ");
INSERT INTO ziw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mna nyuwe waungeni wankondo wenyu naho wadamanyizeni yedi, wakopesheni naho msekwika fanyanyi za kuvuzizwa. Mkaheza namwinkigwe jeleko kulu, na mtende chindedi wana wa Chohile Mkulu ywa kwembingu Kwaviya uyo ni ywedi kwa wantu wehiye hewena ntogozi. ");
INSERT INTO ziw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mtende wata mbazi saviya Tati yenyu ana mbazi. ");
INSERT INTO ziw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mse kukantila watuhu, na Chohile naye hawakantile nyuwe, mse kuwalaha watuhu, na Chohile naye hawalaheni, walekeileni watuhu, na Chohile naye nawalekeile nyuwe. ");
INSERT INTO ziw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wenkeni watuhu, na Chohile nawenkeni nyuwe. Kwaviya na mhimilwe chihimo chimemile na kusintwa mwe mikono yenyu. Naho chihimo mkunga muwahimile watuhu nicho Chohile naajeseze kuwahimila nyuwe.” ");
INSERT INTO ziw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu naye niyo awagambila mligano uno akawauza, “Tuntu hakudaha kumlongoza ntutu mnyawe, anadamanya ivyo, wose waidi nawagwele mwe bome. ");
INSERT INTO ziw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hahana mwanampina akumjinka mhinya wakwe, mna chila mwanampina umo akakomeleza mahinyo yakwe, natende saviya mhinya ywakwe. ");
INSERT INTO ziw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ni mbwani ukusinya kabasi kemwe ziso dya mlukolo ywako, mna hukuwona msomo wi mwe diziso dyako? ");
INSERT INTO ziw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hegu naudahe vivihi kumgamba mlukolo ywako, ‘Hake, mlukolo ywangu, goja huuse kabasi mwe diziso dyako,’ mna hukuwona msomo wi mwe diziso dyako mwenye? Msongaganyi weye! Konga kuusa msomo wi mwe diziso dyako mwenye, nivyo naudahe kuwona pwilili na kudaha kuusa msomo wi mwe diziso dya mlukolo mnyawo. ");
INSERT INTO ziw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mti wedi haukweleka matunda yaihiye, naho mti wihiye haukweleka matunda yedi. ");
INSERT INTO ziw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kwaviya chila mti umanyika kulawana na matunda yakwe ukweleka, wantu hawakwaha tini mwe saka dya miwa hegu kutunda zabibu mwe misongoma. ");
INSERT INTO ziw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mntu ywedi alavya yedi kulaila mwe mpamba imwakwe, na mntu ehiye alavya yehiye kulaila mwe mpamba yakwe ya mbuli zihiye. Kwaviya mntu alonga chiya chimemile mo moyo wakwe. ");
INSERT INTO ziw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ni mbwani mkunitanga, ‘Zumbe, Zumbe,’ mna hamkudamanya yadya huwagambilani? ");
INSERT INTO ziw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chila mntu akwiza kwangu na kwiva mbuli zangu na kuzitimila, nani walagise ivyo eli. ");
INSERT INTO ziw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Uyo kekela enga mntu, mo kuzenga nyumba yakwe, asimbisa na kwika msingi wakwe mwe luwe. Fula nkulu ize inye yabohola mo mto yaisingisa inyumba iyo mna haisingisike, kwaviya izengwa vyedi. ");
INSERT INTO ziw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mna mntu yoyose akwiva izimbuli zangu akaleka kuzitoza aliganywa na mntu azengile nyumba mlanga mwe msanga hesimbile msingi, mazi ya bohole mwe mto yakeisingisa inyumba iyo yagwa hasi, naho yabogozoka!” ");
INSERT INTO ziw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu eze abinde kulonga yoseni yano kwa wantu, niyo aita Kapelinaumu. ");
INSERT INTO ziw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mkulu yumwenga ywa wankondo gana wa Chilumi nana mtumwa amungise, mtumwa uyo nani mnyonje gaja. ");
INSERT INTO ziw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yudya mkulu eze eve mbuli za Yesu, niyo awasigila wadalahala wamwenga wa Chiyahudi waite wakamlombeze akamhonye umtumwa ywakwe. ");
INSERT INTO ziw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Weze wambwile Yesu, niyo wamlombezesa, “Ichindedi mntu yuno aungigwa umwambize ");
INSERT INTO ziw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kwaviya awaunga wantu wose, naho kachizengela nyumba yo kuvikila.” ");
INSERT INTO ziw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Akaheza Yesu niyo ajesanya nawo. Eze abule haguhi ne nyumba ya yudya mkulu ywa wankondo, niyo yudya mkulu awasigilaga wambuyaze kumgamba Yesu, “Zumbe, usekwehosa kwiza kuno, kwaviya miye sikuwagila kukuhokela mwe nyumbangu. ");
INSERT INTO ziw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Naho miye nami sikuwagila kwiza kwako. Mna longa ulosi du, na mtumwa ywangu nahone. ");
INSERT INTO ziw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kwaviya miye mwenye nami ni mntu mta udahi, naho nina wankondo we hasi yangu. Ninamgamba yumwenga, ‘Hita!’ Naye aita, na ninamgamba mtuhu, ‘So!’ Naye eza, na ninamgamba mtumwa ywangu, ‘Damanya vino!’ Naye adamanya.” ");
INSERT INTO ziw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu eze eve ivyo niyo ehelwa, niyo ahitukila idifyo dya wantu dikumtimila na kugamba, “Nawagambilani, sinati kuwona uzumizi sauno mwe isi yose ya Izulaeli!” ");
INSERT INTO ziw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wadya wantu wasigilwe wauya kukaya kwa yudya mkulu na kumbwila mtumwa ywakwe kahona. ");
INSERT INTO ziw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Zuwa dikutimila, Yesu hamwenga na wanampina wakwe waita he mzi ukwitangwa Nayani. Fyo kulu dya wantu niyo dyawabasa. ");
INSERT INTO ziw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Umo wehaguhi ne nchili yo umzi, niyo kwa laila wantu wenule chimba cha mbwanga yumwenga endile ni mwana ichedu ywa mvyele afilwe ni mgosiwe, na fyo kulu dyo mzi udya nendile dikamsindikiza yudya mvyele kokuhamba. ");
INSERT INTO ziw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Zumbe eze amwone uyo umvyele, niyo amfila mbazi, na kumgamba, “Usekwila.” ");
INSERT INTO ziw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Niyo asogela na kuditoza idijeneza, wadya wagosi nawadinule niyo wachimala. Yesu agamba, “Mbwanga! Nakugamba, inuka!” ");
INSERT INTO ziw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yudya mbwanga abanike enuka, ekala na kukonga kulonga. Yesu amwigala kwa mami yakwe. ");
INSERT INTO ziw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wantu wose niyo wengila woga na kumtunya Chohile. Niyo wagamba, “Muwoni mkulu kachilaila mgati mwetu! Chohile keza kwambiza wantu wakwe!” ");
INSERT INTO ziw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mbuli zino za Yesu zijenda mwe si yoseni ya Yudeya na si zoseni zi mguhi. ");
INSERT INTO ziw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wanampina wa Yohana niyo wamgambila Yohana izimbuli zino zose. Naye niyo etanga waidi mgati mwawo ");
INSERT INTO ziw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na kuwasigila kwa Zumbe wakamuze, “Vino weye nuyo alongigwe ni Yohana kugamba neze, hegu chimgoje mtuhu?” ");
INSERT INTO ziw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Weze wabule kwa Yesu, wamgamba, “Yohana Mta kubatiza kachisigila chize chikuze kugamba ni weye nawize, hegu chimgoje mtuhu.” ");
INSERT INTO ziw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chipindi ichiya Yesu nendile akawahonya wantu walozize wendile wanyonje na wata mpepo nchafu na kuwatenda mantuntu walozize wawone. ");
INSERT INTO ziw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ivyo Yesu awahitula wanampina, “Hitani mkamgambile Yohana yadya muwone na kwiva, mantuntu wawona, viwete wajenda, wadya wakuhuma matana walenguka, hewekwiva weva, wabanike wauyuswa, na Mbuli Yedi ya Chohile yalongwa kwa wachiwa. ");
INSERT INTO ziw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Chinyemi china wadya hewena nkama na miye!” ");
INSERT INTO ziw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wanampina wa Yohana weze wahalawe, Yesu niyo akonga kuwasimwila wantu mbuli za Yohana, “Umo mwitile kwenyika, namwita kusinya mbwani? Vino namwita kusinya nyasi ikusingiswa ni mpeho? ");
INSERT INTO ziw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Vino mlaila kuse mkasinye mbwani? Mntu avikile suche zedi? Bule! Wantu wakuvika suche za chiseuta naho wekala wikazi wa chigoli we mwe nyumba za chiseuta! ");
INSERT INTO ziw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nigambilani, mwakusinya mbwani kuse? Muwoni? Chindedi, mna muwona akujinka muwoni. ");
INSERT INTO ziw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kwaviya Yohana nuyo alongigwe mwa Mawandiko kugamba, ‘Chohile kagamba, nanisigile msigilwa ywangu akulongwele kukudamanyiza sila.’ ");
INSERT INTO ziw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu ajendeleza kulonga,” Nawagambilani, “Yohana ni mkulu kujinka mntu yoyose elekwe ni mvyele. Mna mntu mdodo kujinka wose mo Useuta wa Chohile ni mkulu kujinka Yohana.” ");
INSERT INTO ziw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wantu wose weze weve ayo, na hata wachisanya kodi, niyo nawazumila wedi wa Chohile kwaviya na wakabatizwa ni Yohana. ");
INSERT INTO ziw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mna Mafalisayo hamwenga na wahinya Sigilizi walemela kumwiva Chohile naho nawalemela kubatizwa ni Yohana. ");
INSERT INTO ziw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu niyo ajendeleza kulonga, “Vino wantu wa dyelo nadaha kuwaliganya na mbwani? Waligana na mbwani? ");
INSERT INTO ziw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Waligana na wana wekale he gwilo. Bunga dimwenga dyagutila kwa tuhu, ‘Chawachemelaga wila wa nyinka, mna hamwavinaga! Chachemaga wila wa ndilo, mna hamwiile!’ ");
INSERT INTO ziw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohana Mta kubatiza nakeza hekudya naho hakunywa divai, mwagambaga, ‘Ana mpepo!’ ");
INSERT INTO ziw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana Mntu ezaga, naakadya na kunywa, niyo mwagamba, ‘Mkauleni yuno mntu! Aungisa kudya, naho ni mkozi, mbuya ywa wachisanya kodi na wata masa!’ ");
INSERT INTO ziw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mna ubala wa Chohile uwoneka wedi naho wachindedi kwa wadya woseni wakuuzumila.” ");
INSERT INTO ziw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mntu yumwenga Mfalisayo amgoneke Yesu mwe nkande ya chisingi. Niyo Yesu aita kwe kaya ya Mfalisayo uyo, ekala na kudya. ");
INSERT INTO ziw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mwo umzi udya, nakuna mvyele mta masa. Keva kugamba Yesu naakadya mwe kaya ya Mfalisayo uyo, ivyo aguha kasupa kamemile mavuta ya kupwepweleka vitana. ");
INSERT INTO ziw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Achimala haguhi na Yesu kuno akaila, akachabaza iviga vya Yesu na mesozi yakwe. Niyo avifuta kwa fili zakwe, vikajika asesa na kuvikuluguta mavuta. ");
INSERT INTO ziw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yudya Mfalisayo eze awone ivyo, afanyanya mo moyo wakwe, “Uneva chindedi mntu yuno nani muwoni, nakabunkula kugamba mvyele yuno akumtoza evivihi, nakamanya kugamba ni mta masa!” ");
INSERT INTO ziw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu amgamba Mfalisayo uyo, “Simoni, nonga hugambile chintu.” Simoni niyo agamba, “Haya Mhinyi, nigambila.” ");
INSERT INTO ziw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu niyo akonga kulonga, “Nahana wantu waidi wakopaga hela kulaila kwa mntu akukopesha. Yumwenga nakakopa matundu magana mashano na mtuhu naye akopaga matundu milongo mishano. ");
INSERT INTO ziw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hahana adahile kuliha matundu ayo, ivyo yudya mntu awakopeshaga niyo awalekeila awagamba wose wasekumliha. Haluse ni yuhi namungise mgati mwa wadya waidi?” ");
INSERT INTO ziw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni ahitula, “Nafanyanya kugamba ni yudya alekeilwe mta deni dya matundu yalozize.” Yesu amgamba, “Ni chindedi.” ");
INSERT INTO ziw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Niyo amhitukila yudya mvyele na kumgamba Simoni, “Wamwona mvyele yuno? Siza mwe kaya yako, huninkile mazi ya kuhaka iviga vyangu, mna mvyele yuno kanihaka iviga vyangu kwa mesozi yakwe na kuvifuta kwa fili zakwe. ");
INSERT INTO ziw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hunihokele kwa kunisesa, mna yuno kukongela hadya nizile halekile kunisesa mwe viga vyangu. ");
INSERT INTO ziw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Huukulugute mavuta mtwi wangu, mna mvyele uyu kakuluguta mavuta matana iviga vyangu. ");
INSERT INTO ziw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nakugambila, kwaviya kausizwa masa yakwe yalozize, ivyo naye aungisa. Mna mntu yeyose alekeilwe masa majeche naye aunga kidodo.” ");
INSERT INTO ziw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Niyo Yesu amgamba yudya mvyele, “Kulekeilwa amasa yako.” ");
INSERT INTO ziw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wantu watuhu wekale mwe meza wakonga kulonga wenye, “Yuno ni yuhi akudaha kulekeila masa?” ");
INSERT INTO ziw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mna Yesu amgamba yudya mvyele, “Uzumizi wako ukuhonya. Jenda kwa utondowazi.” ");
INSERT INTO ziw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Akajika, Yesu katamba kwe mizi na kaya kulonga Mbuli Yedi yo Useuta wa Chohile. Wanampina mlongo na waidi niyo waita naye, ");
INSERT INTO ziw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","wavyele wamwenga wahonyigwe manyonje na kulavigwa mpepo ni Yesu nawo wawabasa. Wavyele awo wendaga ni Maliyamu akwitangwa Magidalena, yudya alavigwe mpepo nchafu mfungate, ");
INSERT INTO ziw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yona, mkaza Kuza endaga mkulu mwe chitala cha Helode, Suzana, wavyele watuhu walozize. Wavyele awo wajesezaga ugoli wawo kumsankanila Yesu hamwenga na wanampina wakwe. ");
INSERT INTO ziw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wantu wajendeleza kwiza kwa Yesu kulaila chila mzi. Umo fyo kulu dya wantu dize didugane, Yesu nakasimwila mliganyo uno. ");
INSERT INTO ziw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hendaga na mntu aitile kuhanda mbeyu. Umo akamyaga izimbeyu mwe nkonde, zimwenga zigwela mwe sila. Aho zijatwa, wadege wa kulanga nawo wazidya. ");
INSERT INTO ziw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Izimwenga zigwela mwe luwe. Zize zikonge kuhota, zinyala kwaviya ulongo uswesa mazi. ");
INSERT INTO ziw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Izimwenga zigwela mwe miwa, zikula hamwenga ne miwa, miwa niyo yazifintafinta. ");
INSERT INTO ziw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mbeyu ntuhu zigwela mwe ulongo wedi. Zakula na kweleka, chila imwenga nkanana gana.” Yesu naye abindiliza, “Mta magutwi neve!” ");
INSERT INTO ziw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wanampina wakwe wamuza Yesu mliganyo uno ni mbwani, ");
INSERT INTO ziw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Niyo ahitula, “Nyuwe ugubwilwa kumanya chinyele cho Useuta wa Chohile, mna kwa wantu watuhu vyalongwa kwa miliganyo, chani wanasinya wasekuona, wanategeleza wasekukombaganya. ");
INSERT INTO ziw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Mliganyo uno nikugamba, mbeyu ni Mbuli ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Izimbeyu zigwele mwe sila zaligana na wantu wakwiva Mbuli ya Chohile, mna Mwavu eza na kuiguha Mbuli iyo mwe myoyo yawo chani wasekuzumila na kukombolwa. ");
INSERT INTO ziw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Izimbeyu zigwele mwe luwe zaligana na wantu wakwiva Mbuli ya Chohile na kuihokela kwa chinyemi, mna haikwingila mwe myoyo yawo. Waizumila hadodo, mna wanajezwa waileka. ");
INSERT INTO ziw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Izimbeyu zigwele mwe miwa ni mliganyo wa wantu wakwiva Mbuli ya Chohile, mna wafintwa ni nkunto na ugoli na mbwedo wa mwe isi vyaleka wadunduga kweleka matunda. ");
INSERT INTO ziw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Izimbeyu zigwele mwe ulongo wedi zaligana na wantu wakwiva Mbuli ya Chohile, waizumila na kuika mwe myoyo yawo, naho waitoza kubula kweleka matunda. ");
INSERT INTO ziw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Wantu hawakuwasha taa na kuigubika na nyungu hegu kuika kwe divungu. Mna waika mnanga mwe chiya cha kwikiya taa, chani wantu walangazwe umo wakengila mnyumba. ");
INSERT INTO ziw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Chochose chifisigwe nachilavyanywe kung'aile, naho chochose chigubikwe nachigubulwe na kwikwa kung'aile. ");
INSERT INTO ziw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Elo msinyise, saviya mkwiva, kwaviya mta chintu nongezezwe, mna yudya hena chintu nahokwe chiya ichidodo akufanyanya ananacho.” ");
INSERT INTO ziw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nine na walukolo wa Yesu wambasaga, mna hawadahile kumbwila kwa chausa che idifyo kulu dya wantu. ");
INSERT INTO ziw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mntu yumwenga amgamba Yesu, “Mamiyako na walukolo wako wachimala heise waunga wakuwone.” ");
INSERT INTO ziw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu awagamba wantu wose, “Mnala na walukolo wangu ni wadya wakwiva Mbuli ya Chohile na kuitimila.” ");
INSERT INTO ziw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Zuwa dimwenga Yesu nakakwela mwe ngalawa hamwenga na wanampina wakwe. Niyo awagamba, “Chiteni ntendele ntuhu ye idiziwa.” Ivyo wakonga kwita. ");
INSERT INTO ziw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Umo wendile mwe ngalawa wakaita, Yesu niyo agona ntongo. Aho nkung'unto nkulu yavumila mwe diziwa, niyo ingalawa yakonga kumema mazi, woseni nawe mwe chilozo chikulu. ");
INSERT INTO ziw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Elo wanampina wakwe niyo wamwinula wakamgamba, “Zumbe, Zumbe! Chafa!” Yesu eze enuke, niyo akwahila idya inkung'unto na amawimbi ya mazi, niyo vya nyamala. ");
INSERT INTO ziw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Niyo awagamba wanampina wakwe, “Uzumizi wenyu nuhi?” Mna wehelwa na kogoha kuno wakagambilana, “Yuno ni mntu ywani? Alonga na nkung'unto namawimbi navyo vyamwiva!” ");
INSERT INTO ziw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu hamwenga na wanampina wakwe wajendeleza ne ntambo. Niyo wabula kwe isi ya Gelasi imwe ntendele ntuhu ye diziwa dya Galilaya. ");
INSERT INTO ziw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu eze alawe mwe ingalawa, niyo adugana na mntu kudya ko mzi yudya endaga na mpepo. Mntu yudya nendile hakuvika suche kwa chipindi chitali, naho nendile hakwikala mwe nyumba, mna nakekala kwe zimbila. ");
INSERT INTO ziw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Eze amwone Yesu, kaguta kwa izwi kulu, kedula hasi mwe viga vya Yesu, na kugamba, “Yesu, Mwana Chohile ekulanga! Waunga mbwani kwangu? Nakulombeza, usekusulumiza!” ");
INSERT INTO ziw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mntu uyo nakalonga ivyo kwaviya Yesu kamlagiza mpepo nchafu imlawe. Nkanana zilozize mpepo uyo nakamwizila uyo, hatahegu wantu nawakamvugaila mntu yudya, nakanyinywa mikono yakwe ne viga vyakwe kwa minyolo, mna nakaikanta minyolo iyo, na mpepo nakamwigala kwe nyika. ");
INSERT INTO ziw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu amuza, “Zina dyako niweye yuhi?” Amhitula, “Zina dyangu nuyo ‘Nimiye Fyo’,” nakahitula ivyo kwaviya nendile na mpepo zilozize. ");
INSERT INTO ziw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mpepo zamlombeza Yesu asekuzigala kwe dibome hedina uhelo. ");
INSERT INTO ziw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nahana fyo dya nguluwe hajihi, dikadya hankanda he kagulu. Ivyo izimpepo zamlombeza Yesu azigale zikengile mwe izinguluwe, naye azumila. ");
INSERT INTO ziw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ivyo mpepo zamlawa yudya mntu, niyo zengila mwe izinguluwe. Idifyo dyose dye zinguluwe digulukila ntendele ya kagulu kwe diziwa na kudidimila mwa mazi. ");
INSERT INTO ziw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wantu nawakadima izinguluwe weze wawone chilaile, niyo waguluka na kulonga izimbuli izo mo mzi na mwe zinkonde. ");
INSERT INTO ziw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wantu niyo waita wakakaule ni chibwani chilaile. Weze wabule kwa Yesu, wambwila yudya mntu alavigwe mpepo kekala he viga vya Yesu, kavika suche, na ana fanyanyi zakwe zedi. Niyo woseni wengila ni woga. ");
INSERT INTO ziw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wadya wawone imbuli idya, wawagambila wantu yudya mntu mta mpepo viya ahonyigwe. ");
INSERT INTO ziw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Niyo wantu woseni wa si ya Gelasi wamwunga Yesu aite kwaviya nawakogoha vidala. Ivyo Yesu engila mwe ngalawa na kuhalawa. ");
INSERT INTO ziw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yudya mntu alavigwe izimpepo amlombeza Yesu waitanye. Mna Yesu amgamba, ");
INSERT INTO ziw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uya kukaya naho ukawagambile wantu chiya udamanyizwe ni Chohile.” Yudya mntu niyo aita ko umzi wose, awagambila wantu viya adamanyizwe ni Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu eze auye kwe ntendele ntuhu ye diziwa, wantu wamhokela, kwaviya woseni nawakamgoja. ");
INSERT INTO ziw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Akaheza niyo eza mntu yumwenga akwitangwa Yailo, nani mntu mkulu mwe nyumba yo kuvikila. Kedula hasi mwe viga vya Yesu na kumlombeza aite kwakwe, ");
INSERT INTO ziw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwaviya mwanawe ywa chiche ywe ichedu mta mihilimo mlongo na midi, na akabanika. Umo Yesu akaita uko, fyo dya wantu na dikamfinta. ");
INSERT INTO ziw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mgati mwawo nakuna mvyele akulawigwa sakame kwa mihilimo mlongo na midi, alavyaga vyoseni ananavyo kwa wagangana, mna hahana hata yumwenga adahile kumhonya. ");
INSERT INTO ziw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mvyele uyo kalaila mwe difyo hanyuma ha Yesu nakukufya lepe dye suche yakwe, aho sakame niyo ileka kumlawa. ");
INSERT INTO ziw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu auza, “Sikufywa ni yani?” Chila yumwenga kalemela, niyo Petulo agamba, “Zumbe, wantu woseni wakuzunguluka nakukufintafinta.” ");
INSERT INTO ziw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mna Yesu agamba, “Kuna mntu yumwenga anikufize, sibunkula kwaviya nguvu zinilawa.” ");
INSERT INTO ziw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yudya mvyele kawona kugamba kabunkulwa, Elo eza akazingiza nakwedula hasi he viga vya Yesu. Mwa meso ya chila mntu, akamgambila ivyo vilekile akamkufya na vilekile kahonywa aho. ");
INSERT INTO ziw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu niyo amgamba, “Mwanangu, uzumizi wako ukuhonya. Jenda na utondowazi.” ");
INSERT INTO ziw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Umo Yesu achei akulonga mbili izo, msigilwa yumwenga eza kulaila kwa yudya mkulu akwitagwa Yailo we nyumba yo kuvikila. Amgamba Yailo, “Mwanawo kabanika,” “usekumjela kivuzovuzo mhinya naho.” ");
INSERT INTO ziw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mna Yesu eze eve ivyo, amgamba Yailo, “Usekogoha, zumila du, nahone.” ");
INSERT INTO ziw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu eze abule kwe nyumba ya Yailo, haungile engile kunyumba na mntu mna Petulo, Yohana, na Yakobo, na tati ya mtu na mami ywa mwana. ");
INSERT INTO ziw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wantu wose nendile wakaila nakulomboleza kwa chausa cho mwana. Yesu agamba, “Usekwila, mwana habanike katakutongomala du!” ");
INSERT INTO ziw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wose niyo wamseka, kwaviya nawamanya kugamba kabanika. ");
INSERT INTO ziw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mna Yesu niyo amtoza umkono na kumwitanga kwa izwi, “Chimala, mwanangu!” ");
INSERT INTO ziw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Muye wakwe umuwiya, niyo achimala ahadya, Yesu niyo awaunga wamwinke chintu cha kudya. ");
INSERT INTO ziw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Welesi wakwe weheleswa, mna Yesu kawalagisa wasekugambila mntu yeyose chilaile. ");
INSERT INTO ziw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu awetanga hamwenga wanampina mlongo na waidi niyo awenka nguvu za kugulusa mpepo na udahi wa kuhonya manyonje. ");
INSERT INTO ziw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Niyo awasigila kulonga Useuta wa Chohile na kuhonya wanyonje, ");
INSERT INTO ziw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","akawagamba, “Msekuguha chochose mwe ntambo yenyu, msekuguha nkome, hegu mkwiji hegu nkande hegu hela, naho hata suche mbili. ");
INSERT INTO ziw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hohose mkuhokelwa, ikalani umo mnyumba kubula mumlawe mo mzi uwo, ");
INSERT INTO ziw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","hohose hemkuhokelwa, halaweni houmzi uwo, mpugute tifili mwe viga vyenyu vitende ukuzi kwawo.” ");
INSERT INTO ziw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wanampina niyo wajinka mwe vijiji wakalonga Mbuli yedi nakuhonya wantu chila hantu. ");
INSERT INTO ziw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Helode, chilongozi wa Galilaya eze eve mbuli zoseni nazikalaila, kazaganywa vidala, kwaviya wantu wamwenga nawakagamba kugamba Yohana Mta kubatiza kauyuka. ");
INSERT INTO ziw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Watuhu nawakagamba Eliya kalaila, watuhu nawakagamba yumwenga mwa wawoni wa chikale kauyuka. ");
INSERT INTO ziw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helode agamba, “Sikanta umtwi wa Yohana, mna yuno mntu ni yuhi hwiva izimbuli zino?” Niyo ajendeleza kujeza kumwona Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wasigilwa weze wauye niyo wamgambila Yesu chila chintu wadamanye. Niyo ahalawa nawo, waita wenye kwe mzi ukwitangwa Betisaida. ");
INSERT INTO ziw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Idifyo dya wantu dize dive imbuli iyo, niyo wamtimila. Kawahokela, alonga nawo mbuli za Useuta wa Chohile, nakuhonya wadya waungile kuhonywa. ");
INSERT INTO ziw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Umo zuwa dikakonga kuswa, wadya wanampina wakwe mlongo na waidi wambasa nakugamba, “Lagana na wano wantu chani waite, kwe imizi na kwezinkonde zimjihi wakalonde nkande na hantu ha kugona kwa viya hano chili hechedu.” ");
INSERT INTO ziw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mna awagamba “Wenkeni nyuwe wenye chintu cha kudya.” Wahitula, “Chinanayo ni migate mishano na wasamaki waidi. Waunga chikagule nkande ya fyo jima?” ");
INSERT INTO ziw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nahana wantu wakubula magana milongo mishano Yesu awagamba wanampina wakwe, “Wagambeni wantu wekale mwe mabunga ya wantu milongo mishano shano.” ");
INSERT INTO ziw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wanampina weze wabinde kudamanya niyo wantu wekale hasi, ");
INSERT INTO ziw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu niyo aiguha idya imigate mishano na wadya wasamaki waidi, asinya kulanga, amjimbika Chohile, aibesula, awenka wanampina wawasangile wantu. ");
INSERT INTO ziw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Woseni wadya niyo weguta, wanampina walogota ntangulu mlongo na mbili za viya visigazwe. ");
INSERT INTO ziw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Zuwa dimwenga umo Yesu akamlombeza Chohile echedu, wanampina wambasa. Awauza, “Idifyo dyanigamba miye ni yuhi?” ");
INSERT INTO ziw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wamhitula “Wamwenga wagamba wi Yohana Mta kubatiza, watuhu wagamba wi Eliya, watuhu nawo wagamba wiyumwenga ywa wawoni wa chikale kauyuka.” ");
INSERT INTO ziw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Awauza, “Nanywi mwagaze?, Mwanigamba miye ni yuhi?” Petulo ahitula, “Wi Kulisito ywa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu niyo awalemeza wasekumgambila mntu yoyose imbuli iyo. ");
INSERT INTO ziw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Alonga naho kwawo, “Mwana ywa Mntu aungigwa asulumizwe na kulemelwa ni vilongozi wadalahala na mlavyantambiko mkulu na wahinya Sigilizi. Nakomwe, mna mazuwa matatu yakutimila nauyuke.” ");
INSERT INTO ziw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Niyo alonga kwa woseni, “Yoyose akunga anitimile aungigwa elemele, aguhe msalaba wakwe chila zuwa, nakunitimila. ");
INSERT INTO ziw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kwaviya yoyose akunga ahonye ujima wakwe nawaze, mna yoyose akunga awaze ujima wakwe nauhonye. ");
INSERT INTO ziw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kuna wedi wani kwa mntu kuhokela isi njima, mna aho aza ujima wakwe? ");
INSERT INTO ziw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mntu ananiwonela soni na amahinyo yangu, Mwana ywa mntu naye namwone soni umo akeza mo ukuka wakwe na Ukulu wa Tate na wandima wa kwembingu wakukile. ");
INSERT INTO ziw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nawagambilani chindedi, watuhu hano hawabanike kubula wauwone Useuta wa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mazuwa mfungate eze alonge mbuli izo, Yesu awaguha Petulo na Yohana na Yakobo niyo waita he kagulu kumlombeza Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Umo akalombeza, uso wakwe uhitukila, suche zakwe nazo niyo zang'alisa. ");
INSERT INTO ziw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aho wantu waidi nawehadya wakasimwila naye. Nani Musa na Eliya, ");
INSERT INTO ziw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","wantu waidi Musa na Eliya walaila wakaoneka mgati mo langazi wo ukuka ukulaila kwembingu. Nendile wakalonga na Yesu mwa yadya nayamlaile kudya Yelusalemu. Chani achintize yawandikwe mwakwe. ");
INSERT INTO ziw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petulo na weyawe nawadotwa ni ntongo, mna niyo wenuka nakuwona ukulu wa Yesu na wantu waidi wachimale naye. ");
INSERT INTO ziw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wadya wantu weze wamwase Yesu, Petulo amgamba, “Zumbe, utana wani uno wihano! Nachizenge mahema matatu, dimwenga dyako, dimwenga dya Musa na dimwenga dya Eliya.” Hamanyaga vitendese chiya akutamwila. ");
INSERT INTO ziw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Iviya akajendeleza kutamwila, ingu dyalaila na kuwagubika kwa chizuli chakwe, wanampina wogoha umo idingu dikawezila. ");
INSERT INTO ziw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Izwi dyevika kulaila mwe dingu, “Yuno nuyo Mwanangu, nisagule mwetegelezeni!” ");
INSERT INTO ziw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Idizwi dize dinyamale, wamwona Yesu ichedu. Wanampina wanyamala kusimwila imbuli ino, chipindi chiya hawamgambile yoyose chochose wawone. ");
INSERT INTO ziw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Zuwa ditimile Yesu na wadya wanampina watatu wasela kulaila kwa kagulu, fyo kulu dyadugana na Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mntu yumwenga aguta kulaila mwe difyo, “Mhinya! Nakulombeza, msinye mwanangu echedu! ");
INSERT INTO ziw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mpepo nchafu inamwingila aho atula lwasu, kuno yamgwisa chifutu, malovu nayo yalawa mo mlomo, ijendeleza kumlumiza naho haikunga kumlekela aite! ");
INSERT INTO ziw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nawalombezaga wanampina wako waiguluse, mna waidunduga.” ");
INSERT INTO ziw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu ahitula, “Nyuwe lweleko helwikumzumila Chohile naho lwagile! Nanikale nanyuwe kubula ini? Nanikale na nyuwe kubula ini?” Niwajijimizeni kubula ini? Niyo amgamba yudya mntu, “Mlete mwawo hano.” ");
INSERT INTO ziw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Umo yudya mbwanga akeza, mpepo nchafu imgwisa hasi nakumjela chifutu. Yesu aikwamila impepo iyo, amhonya umbwanga, nakumvuza kwa tatiyakwe. ");
INSERT INTO ziw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wantu woseni wehelwa mo udahi mkulu wa Chohile. Wantu nawechei wehelwa kwa chila chintu naakadamanya Yesu, umo alongaga kwa wanampina wakwe, ");
INSERT INTO ziw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mnasekujala chino hunga nilonge nanywi! Mwana ywa Mntu nenkizwe mo udahi wa wantu.” ");
INSERT INTO ziw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mna wanampina hawakombaganye mbuli iyo manakwe ni mbwani. Naifiswa kwawo chani wasekuikombaganya, naho nawakogoha kumwuza mwe mbuli iyo. ");
INSERT INTO ziw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Malosano yakonga mgati mwe wanampina wakauzana ni yuhi mkulu kujinka woseni. ");
INSERT INTO ziw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu niyo abunkula viya nawakafanyanya mwe myoyo yawo, ivyo aguha mwana, amchimalisa hankanda hakwe, ");
INSERT INTO ziw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nakuwagamba, “Yoyose akunga amhokele mwana yuno mwe zina dyangu, anihokela miye, naho akunihokela, iviya amhokela yudya anisigile. Kwaviya yoyose wa hasi mwenyu wose nuyo mkulu kujinka woseni.” ");
INSERT INTO ziw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana alonga, “Zumbe, chiwona mntu akugulusa mpepo kwa zina dyako, niyo chamgamba aleke, kwaviya hemwe dibunga dyetu.” ");
INSERT INTO ziw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu niyo awagamba, “Msekumlemeza, kwaviya yoyose ehamwenga na nyuwe ni mnyenyu.” ");
INSERT INTO ziw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chipindi chikasogela umo Yesu naguhigwe kwigalwa kwembingu, kaviwona akonge ntambo kubula Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kasigila wantu wamlongweile, waitile kwe kaya ya Samaliya kumdamanyiza chila chintu kwa chausa chakwe. ");
INSERT INTO ziw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mna wantu wo mzi udya hawamhokele, kwaviya ni pwilili kugamba emwe ntambo kwita Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Umo wanampina Yohana na Yakobo weze wawone vino, wagamba, “Zumbe waunga chisigile moto kulaila kwembingu uwabalange?” ");
INSERT INTO ziw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mna Yesu niyo awahitukila na kuwakwahila. ");
INSERT INTO ziw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wakaheza waita kwe mzi mtuhu. ");
INSERT INTO ziw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Umo wakajenda mwe isila, mntu yumwenga amgamba Yesu, “Nahutimile hohose ukunga wite.” ");
INSERT INTO ziw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu amgamba, “Mauzi yana mabome, wadege nawo wana masasa, mna Mwana ywa Mntu hana hantu hekugona.” ");
INSERT INTO ziw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Amgamba mntu mtuhu, “Nitimila.” Mna yudya mntu agamba “Zumbe, ndakunileka nuye hamhambe tate.” ");
INSERT INTO ziw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu ahitula, “Waleke wabanike wahambe wabanike wawo. Wite ukalonge Useuta wa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mtuhu naho agamba, “Zumbe, nahutimile, mna ndakunileka nite halage kukaya kwangu.” ");
INSERT INTO ziw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu amgamba, “Yoyose akukonga kutoza jembe niyo ajendeleza kusinya kunyuma hakuwagila ko Useuta wa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Eze yajike ayo, Zumbe niyo asagula wantu watuhu milongo mfungate na waidi. Awasigila waididi wamlongwele kujinkila chila mzi na chila hantu endile uyo mwenye nakaunga aite. ");
INSERT INTO ziw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Awagamba, “Ulozo utendesa, mna wata kuvuna ni wajeche. Mlombezeni Zumbe ywenkonde egale wavuni mwe nkonde yakwe. ");
INSERT INTO ziw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hitani! Mkaulise nawasigilani saviya ngoto mgatigati mwe mauzi. ");
INSERT INTO ziw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Msekwinula hela hegu mkwiji hegu vilatu, naho msekumlamsa mntu yoyose mwe sila. ");
INSERT INTO ziw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mkengila mwe nyumba, kongani kugamba, ‘Utondowazi utendeke mwe nyumba ino.’ ");
INSERT INTO ziw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Uneva akwikala umo ni mntu akunga utondowazi, utondowazi wenyu neikale hamwenga nauyo, hegu bule, ndamsa yenyu yo utondowazi ne iwawiyeni wenye. ");
INSERT INTO ziw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ikalani mwe nyumba iyo, mkadya na kunywa vyo vyose wakuwenkani, kwaviya wandima waugwa wenkigwe maliho yawo. Msekujenda jenda kulaila nyumba imwenga kwita ntuhu. ");
INSERT INTO ziw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mkengile mwe mzi wowose niyo wantu wawahokeleni, dyani viya wakuwenkani, ");
INSERT INTO ziw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","honyani wanyonje we mo mzi uwo, naho wagambeni wantu wa uko, ‘Useuta wa Chohile wiza haguhi henyu.’ ");
INSERT INTO ziw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mna mkengila mwe mzi niyo hamhokelwe, fosani mo lwazo kuno mkagamba, ");
INSERT INTO ziw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hata tifili dikulaila mo mzi wenyu dimamatile mwe viga vyetu chadikung'untila mwenyu. Mna mkumbuke kugamba Useuta wa Chohile wiza haguhi henyu!’ ");
INSERT INTO ziw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nawagambilani chindedi kugamba mwe dizuwa dyo kukantilwa ni Chohile mzi uwo nawafile mbazi kujinka mzi wa Sodoma! ");
INSERT INTO ziw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Nauluwone weye, Kolazoni! Nauluwone weye mzi wa Betisaida! Uneva mpituko zidamanywe kwenyu zadamanywe uko Tilo na Sidoni, wantu wa uko na weila chikale, wavala suche za majuniya, na kwehaka maivu, kulagisa kugamba waleka masa yawo! ");
INSERT INTO ziw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Chohile nawafile mbazi Tilo na Sidoni mwe dizuwa dyo kukantilwa kujinka kwenyu. ");
INSERT INTO ziw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na kwachausa chako weye Kapelinaumu! Waunga wekweze wenye kwembingu? Naudulwe hasi kwe bome hedina uhelo!” ");
INSERT INTO ziw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu alonga kwa wanampina wakwe, “Akuwategelezani nyuwe anitegeleza miye, na akuwalemelani nyuwe anilemela miye, na akunilemela miye amlemela yudya anisigile.” ");
INSERT INTO ziw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wadya wantu milongo mfungate na waidi wauya weleleswa vidala. Wagamba, “Zumbe,” “hata mpepo zichiva hadya chize chizikwahile kwe dizina dyako!” ");
INSERT INTO ziw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu niyo awahitula, “Simuwona Shetani akagwa kulaila kwembingu saviya lumwemwe. ");
INSERT INTO ziw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tegelezani! Siwenkani udahi, chani mdahe kujata nyoka na visuse na nguvu zose za kumhuda yudya mwihi, naho hahana chikunga chiwalumize. ");
INSERT INTO ziw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hata ivyo msekwelelwa kwaviya mpepo zawevani, mna mwelelwe kwaviya mazina yenyu yawandikwa kwembingu.” ");
INSERT INTO ziw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mwe chipindi ichiya Yesu niyo amemezwa chinyemi kwa udahi wa Muye Ukukile, niyo agamba, “Tate, Zumbe dya kwembingu ne isi! Nakuhongeza kwaviya mbuli ufisize kwa wantu wata ubala na umanyi. Kuzivugula kwa wadodo. Heye Tate, zose izo ni kulawana neivyo vikuwagile. ");
INSERT INTO ziw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tate kaninka vintu vyoseni. Hahana akumanya Mwana ukaleka Tate, naho hahana amanyize Tate ukaleka Mwana na yoyose yudya Umwana akunga amlagise kwakwe.” ");
INSERT INTO ziw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Akaheza Yesu niyo awahitukila wanampina wakatenda wechedu, awagamba, “Watogolwe ni wantu wakuwona mbuli ziya mkuziwona! ");
INSERT INTO ziw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nawagambilani kugamba wawoni na maseuta walozize nawakaungisa wayawone yadya mkuyawona nyuwe, mna hawayawone, nakuyeva yadya mkwiva, mna hawayevile.” ");
INSERT INTO ziw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Akaheza mhinya yumwenga ywa Sigilizi niyo achimala amuza Yesu kwa kumjeza. Akamuza, “Mhinya,” “naungwa nitende mbwani chani nihokele ujima wa mazuwa yose?” ");
INSERT INTO ziw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu amhitula, “Iwandikwa mbwani mwe Sigilizi? Wamanya mbwani ukaisoma?” ");
INSERT INTO ziw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yudya mntu ahitula, “ ‘Munge Zumbe Chohile ywako kwa moyo wako wose, kwa muye wako wose, hamwenaga na nguvu zako, na kwa fanyanyi zako zose,’ ” naho “ ‘Munge mnyawo saviya ukweunga we mwenye.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ahitula, “Kuhitula vikungwa,” “damanya ivyo nawe nawikale.” ");
INSERT INTO ziw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mna yudya mhinya Sigilizi nakaunga awoneke ywedi, niyo amuza Yesu, “Mnyangu ni yuhi?” ");
INSERT INTO ziw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu ahitula, “Handaga na mntu yumwenga akulaila ko mzi wa Yelusalemu akasela kwita Yeliko mwesila adugana na wapolaganyi wamhuta, niyo wamwasa ehaguhi na kubanika. ");
INSERT INTO ziw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Niyo kwalaila mlavyantambiko yumwenga nakajinka mwe sila idya, mna eze amwone yudya mntu, niyo ajinkila mnkanda. ");
INSERT INTO ziw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Seivyo Mlawi yumwenga naye kabula aho, kajinka nakumsinya yudya mntu, niyo ajinkila mnkanda. ");
INSERT INTO ziw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mna Mfambazi yumwenga endile akatamba mwe sila iyo kabula hayudya mntu, naye eze amwone, moyo wakwe wingilwa ni mbazi. ");
INSERT INTO ziw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Amsogeila, amwitila mavuta na divai mwe zinkwenje zakwe na kumzingiliza katambala, niyo amkweza mnanga mwe mpunda yakwe amwigala mwe nyumba ya kufikila wajeni, na kumuuguza. ");
INSERT INTO ziw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Zuwa ditimile alavya matundu maidi ya hela nakumwinka yudya msinya idya inyumba. Amgamba yudya msinya inyumba, ‘Msinye,’ umo haogola nanuye ne sila ino, ‘nahulihe chochose ukunga ujeseze mo kumsinya,’ ” ");
INSERT INTO ziw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu niyo amuza yudya mhinya Sigilizi, “Mwezifanyanyanyi zako, niyuhi mwa wano watatu amwonele mbazi yudya mntu atoigwe na wapolaganyi?” ");
INSERT INTO ziw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yudya mhinya sigilizi amhitula, “Ni yudya afile mbazi.” Yesu ahitula, “Jenda, naho, na ukadamanye saivyo.” ");
INSERT INTO ziw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Umo Yesu na wanampina wakwe we mwe ntambo, kengila mwe mzi umwenga kudya na kuna mvyele yumwenga akwitagwa Matha kamhokela mwe nyumba yakwe. ");
INSERT INTO ziw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Masa na ana lumbudye akwitagwa Maliyamu ekale hasi mwe viga vya Zumbe na kwetegeleza mahinyo yakwe. ");
INSERT INTO ziw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Matha endaga na ndima zilozize mnyumba, ivyo kambasa Yesu na kumgamba, “Zumbe, hukuviwona vino lumbu dyangu anasize nisankane ichedu? Mgambe eze anambize!” ");
INSERT INTO ziw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Zumbe amhitula, “Matha, Matha! Wangadika na kwevinya mwe mbuli zilozize, ");
INSERT INTO ziw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","mna kuna chintu chimwenga du chikungwa. Maliyamu kasagula chintu chikungiswa, na chiya hahana mntu namhoke.” ");
INSERT INTO ziw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Zuwa dimwenga Yesu nakalombeza hantu hamwenga. Eze abinde, yumwenga mwe wanampina wakwe amgamba, “Zumbe, chihinye kumlombeza Chohile, saviya Yohana awahinyaga wanampina wakwe.” ");
INSERT INTO ziw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu awagamba, “Mkalombeza, gambani vino, ‘Tate, Zina dyako ditunywe, Useuta wako wize. ");
INSERT INTO ziw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Chinke nkande yetu ya chila zuwa. ");
INSERT INTO ziw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Chilekeile masa yetu, kwaviya suwe chawalekeila wadya wachidamanyize vihihe. Naho usekuchijela mwe majezo.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Niyo Yesu awagamba wanampina wakwe, “Fanyanyani yumwenga mgati mwenu aite kukaya kwa mbuyaye chilogati nakugamba, ‘Mbuyangu, nikopesha migate mitatu. ");
INSERT INTO ziw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kwaviya sizilwa ni mbuyangu emwentambo mna sina nkande yoyose ya kumwinka!’ ");
INSERT INTO ziw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Fanyanya mbuyayo akuhitula kulaila kunyumba, ‘Use kunilonda ulosi! Lwivi luvugalwa kale, miye hamwenga na wanangu chimwe zisazi. Sikudaha kwinuka hwinke chochose.’ ");
INSERT INTO ziw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ni vyedi, chikutimila ni chihi? Nawagambilani kugamba hata hegu henuke nakukwinka umgate kwaviya wi mbuyaye, mna nenuke na kukwinka vyoseni ukunga kwaviya huna soni kujendeleza kulombeza. ");
INSERT INTO ziw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Na ivyo nalonga kwenyu, lombeza, nauhokele, londa, namwinkwe, towani hodi, na uvugwilwe ulwivi. ");
INSERT INTO ziw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwaviya woseni wakulombeza nawahokele, wadya wakulonda nawenkwe, lwivi nalwo naluvugulwe kwa yoyose akutowa hodi. ");
INSERT INTO ziw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mwana anamlombeza tatiyakwe samaki, togola namwinke nyoka siyo samaki? ");
INSERT INTO ziw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Hegu wamwinka chisuse uneva kalombeza tagi? ");
INSERT INTO ziw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Wihi wenyu mnanawo, mvimanya kuwenka wana wenyu vintu vyedi. Haluse chihimo chani Tati yenyu ywa kwembingu na wenke Muye Ukukile kwa wadya wakumlombeza!” ");
INSERT INTO ziw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu nakagulusa mpepo heikulonga, mpepo ize ite, yudya mntu niyo akonga kulonga. Idifyo dyehelwa, ");
INSERT INTO ziw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","mna wantu wamwenga wagamba, “Ni Belizebuli, mkulu ywa mpepo, amwinkile udahi wa kuzigulusa.” ");
INSERT INTO ziw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Watuhu nawakaunga wamhime Yesu, ivyo wamlombeza awadamanyize vilagiso kulagisa kugamba udahi wakwe ulaila kwembingu kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mna Yesu nakamanya viya nawakafanyanya, ivyo awagamba, “Wantu wa useuta wowose wakalemana wowo wenye useuta uwo naugwe. Naho wantu wa lukolo lumwenga wakalema wowo wenye, lukolo ulo lwagwa. ");
INSERT INTO ziw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ivyo uneva useuta wa Shetani wepanga wenye mwe mafyo yakutowana, nawikale vivihi? Mwagamba Nagulusa mpepo kwaviya Belizebuli aninka udahi wa kudamanya ivyo. ");
INSERT INTO ziw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Uneva nagulusa mpepo kwa udahi wa Belizebuli, ivyo wantu we difyo dyenyu wazigulusa kwa udahi wayuhi? Wantu awo nawawone kwa sila ya ntendwa zawo kugamba nyuwe mkantilwa! ");
INSERT INTO ziw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sivyo, nagulusa mpepo kwa udahi wa Chohile, vino vyalagisa kugamba Useuta wa Chohile wiza kale kwenyu. ");
INSERT INTO ziw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mntu mta nguvu, akadima ikaya yakwe kwa viziha, ugoli wakwe wose wikala mpeho. ");
INSERT INTO ziw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mna mta nguvu kumjinka aneza nakumtowa, ataha viziha vyakwe na ananavyo nakuvilavya viya abaile. ");
INSERT INTO ziw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yoyose hehamwenga namiye ahigana namiye, yoyose hekunambiza kuchisanya amwaganisa. ");
INSERT INTO ziw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Mpepo nchafu ikamlawa mntu, yatamba mwe si nkavu ikalonda hantu hakuhumula. Uneva inalonda haiwone, yelongela, ‘Nanuye kwe nyumba yangu.’ ");
INSERT INTO ziw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ivyo yauya nakubwila inyumba ihagilwa na kuhambwa. ");
INSERT INTO ziw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Akaheza yahalawa yakuguha mpepo ntuhu zihise mfungate kujinka yoyo yenye, niyo zeza nakwikala aho. Vyoseni vikaheza, yudya mntu nalumiswe kujinka ivyo neli aho nkongo.” ");
INSERT INTO ziw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu eze alonge vino, mvyele yumwenga alaila kulonga mwe diya idifyo nakumgamba, “Chinyemi chivivihi cha mvyele akweleke nakonkeza!” ");
INSERT INTO ziw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mna Yesu ahitula, “Iviya, chinyemi chivivihi kwa wadya wakwiva mbuli ya Chohile nakuitimila!” ");
INSERT INTO ziw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Umo wantu wamemile wamzunguluke Yesu, kajendeleza kulonga, “Wantu wa dyelo wana wihi wi vivihi! Waunga vilagiso, hawenkigwe yoyose mna mpituko ya Yona. ");
INSERT INTO ziw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mwe ivyo kugamba muwoni Yona nani chilagiso kwa wantu wa Ninawi, ivyo Mwana ywa Mntu natende chilagiso kwa wantu wa dyelo. ");
INSERT INTO ziw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mwe dizuwa dyo kukantila Seuta ywa chivyele ywa Sheba nachimale nakuwalaha wantu wa dyelo, kwaviya atambaga kulaila kwe isi yakwe kwita kwetegeleza milosi ya chimanyi ya Seuta Sulemani, naho nawagambilani hano hana mkulu kumjinka Solomoni. ");
INSERT INTO ziw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mwe dizuwa dyo kukantilwa wantu wa Ninawi nawachimale hamwenga na wantu wa dyelo na kuwalahani, kwaviya weilaga masa yawo weze wamwive Yona akalonga, naho nawagambilani chindedi hano hana yudya mkulu kumjinka Yona! ");
INSERT INTO ziw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Hahana akuwasha taa niyo aifisa he ntangulu hegu kuika hasi hedivungu, Mawandiko matuhu hayana hegu kuika hasi hedivungu. Mna aika he chiya cha kwikiya taa, chani wantu wawone ulangazi umo wakengila. ");
INSERT INTO ziw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Meso yako yekala saviya taa kwachausa cho mwili. Uneva meso yako ni yedi, umwili mjima niwedi, mna hegu meso yako sayo yedi, umwili wako mjima nautende nachiza. ");
INSERT INTO ziw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Haluse, kaulisa kugamba ulangazi wi mwako unase kutenda chiza. ");
INSERT INTO ziw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ivyo uneva umwili wako mjima niwedi, naung'aile mazuwa yoseni, saviya taa ikulangaza na ulangazi wakwe.” ");
INSERT INTO ziw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu eze akomeleze kulonga, Falisayo yumwenga amgonekaga akadye hamwenga naye, ivyo kengila nakwikala hasi kudya. ");
INSERT INTO ziw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Falisayo uyo nakehelwa eze awone kugamba Yesu hahakile henati kudya. ");
INSERT INTO ziw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ivyo Zumbe amgamba, “Kaula, nyuwe Mafalisayo mwelengusa kuse mwe vyampa na sahani, mna mndani mwenyu mmema wihi na finju. ");
INSERT INTO ziw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wahezi nyuwe! Suyo Chohile adamanye kuse naho nuyo adamanye mndani? ");
INSERT INTO ziw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mna lavyani viya vimwevyampa vyenyu na sahani kwa wachiwa, chila chintu nachitende chilenguka kwachausa chenyu. ");
INSERT INTO ziw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Namluwone nyuwe Mafalisayo! Mwamlaviza Chohile fungu dya mlongo dya wabwanga vintu saviya nkande na chila mboga zesimile, mna mwabela wedi wa Chohile. Mbuli saizo nizo nendile mkaungwa mzitozese mkaleka kujala ntuhu. ");
INSERT INTO ziw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Namluwone nyuwe Mafalisayo! Mwaunga vigoda vikigwe koso mwe nyumba zo kuvikila nakulamswa kwa ntunyo mwa magwilo. ");
INSERT INTO ziw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Namluwone! Mwi saviya mbila hezikuwoneka na zikujendelwa ni wantu hewekuvimanya.” ");
INSERT INTO ziw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yumwenga mgati mwa wahinya Sigilizi amgamba, “Mhinyi, kwa kulonga ivyo, wachihuluta suwe naswi!” ");
INSERT INTO ziw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu ahitula, “Naho namluwone nyuwe wahinya Sigilizi! Mwaika mizigo mwe migongo ya wantu heikwinulika, mna nyuwe wenye hamchuluse kadole kuwambiza kwinula imizigo iyo. ");
INSERT INTO ziw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Namluwone! Mwadamanyiza wawoni mbila zedi wadya wawoni wakomigwe ni wadalahala wenyu. ");
INSERT INTO ziw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nyuwe wenye mwaukula kugamba, kuzumila wababa zenyu, kwaviya wowo wawakomaga wadya wawoni, niyo mwazenga izimbila zawo. ");
INSERT INTO ziw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kwachausa chino Umanyi wa Chohile wagamba, ‘Nanisigile kwenyu wawoni na wasigilwa, nawakome wamwenga mgati mwenyu nawawasulumize watuhu.’ ");
INSERT INTO ziw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ivyo wantu wa chipindi chino nawakantilwe kwa ukomi wa wawoni woseni wakomagwa kukongela uumbi we isi, ");
INSERT INTO ziw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kukongela ukomi wa Habili kubula ukomi wa Zakaliya, akomigwe hagati he Nyumba ya Chohile mwe nchanja yo kulaviza ntambiko na Hantu Hakukile. Chindedi nawagambilani, wantu wa chipindi chino nawakantilwe kwachausa cha woseni! ");
INSERT INTO ziw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Namluwone wahinya Sigilizi! Mtoza dikomwelo dikuvugula ulwivi lwe nyumba yo umanyi, nyuwe wenye hamwingile mndani, naho mwahiga wadya wakujeza kwingila mndani!” ");
INSERT INTO ziw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Umo Yesu akahasa hadya hantu, wahinya Sigilizi na Mafalisayo wakonga kumvinya kwa usungu nakumuza mbuli zilozize, ");
INSERT INTO ziw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","wakajeza kumtegela wamgwile akalonga chintu chihiye. ");
INSERT INTO ziw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Umo milongo mlongo ya wantu wamemile hamwenga kubula wajatana, Yesu niyo akonga kulonga na wanampina wakwe, “Msinyise mahinyo ya Mafalisayo kugamba ni wasongaganyi.” ");
INSERT INTO ziw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hahana chintu chochose chifisigwe nachiswese kubunkulwa, naho hahana chinyele nachiswese kumanywa. ");
INSERT INTO ziw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kwaivyo, chila mchilongile mwe chiza nachivike nomsi, naho mbuli zozose na mtakalisane mwi wenye mwe chumba nazimpwinkulwe namlonge kulaila kwedigulu. ");
INSERT INTO ziw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nawagambilani, wambuya zangu, msekuwogoha wadya wakudaha kukoma umwili mna hawakudaha kudamanya chochose chihise.” ");
INSERT INTO ziw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Naniwalagiseni yudya mkungwa mumogohe, mwogoheni Chohile, yudya, akaheza kukoma, nuyo mta udahi wa kumdula mntu kwe bome hedina uhelo. Chindedi nawagambilani, nuyo mkungwa mumogohe! ");
INSERT INTO ziw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Togolani! Wadege washano hawakutagwa kwa matundu maidi? Naho hahana yumwenga akujalwa ni Chohile.” ");
INSERT INTO ziw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mna hata fili zimwe mitwi yenyu ziwazwa. Elo msekogoha, nyuwe mna yombe kujinka wadege walozize! ");
INSERT INTO ziw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nawagambilani kugamba kwa wadya wakulonga mwa wantu kugamba we kwangu, Mwana ywa Mntu nawadamanyize ivyo mwa meso ya wandima wa kwembingu wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mna wadya wakunilemela mwa wantu, Mwana ywa Mntu nawalemele mwa meso ya wandima wa kwembingu wa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mntu yoyose akusimwila vihiye mwa Mwana ywa Mntu adaha kulekeilwa, mna chila mntu akuhuluta Muye Ukukile halekeilwe.” ");
INSERT INTO ziw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Umo wakawegala mkalahwe mwe nyumba zo kuvikila hegu mwa meso ya wakulu we vilongozi, msekwogoha chiya mkunga mhitule hegu mkunga mlonge. ");
INSERT INTO ziw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwaviya Muye Ukukile nawahinye aho chiya mkunga mlonge.” ");
INSERT INTO ziw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mntu mwe difyo amgamba Yesu, “Mhinya, mgambile mlukolo ywangu chipangane ulisi chasizwe ni tatiyetu.” ");
INSERT INTO ziw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu amhitula, “Mbuyangu, niyani aninkile kulamula hegu kwinkiza ugoli mgati mwenyu nyuwe waidi?” ");
INSERT INTO ziw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Naho ajendeleza kuwagambila wose, “Mkaulise naho mwesinye wenye mwe chila tama ya ugoli, kwaviya wikazi wa chindedi wa mntu haukulawana na vintu ananavyo, hata akatenda na ugoli wi vivihi.” ");
INSERT INTO ziw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Niyo Yesu awagambila mliganyo uno, “Hendaga na mntu yumwenga mgoli endaga na mgunda una ulozo utendese. ");
INSERT INTO ziw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akonga kwefanyanya mwenye, ‘Sina hohose hakwika ulozo wangu wose. Nitende mbwani?’ ");
INSERT INTO ziw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Egamba mwenye, ‘vino nivyo nanidamanye,’ ‘Nanitule magulu yangu niyo nazenga matuhu makulu yatendese, umo nanike nkande yangu na vintu vituhu vyose. ");
INSERT INTO ziw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Niyo elongela mwenye, Mntu atendile mbafu! Una chila vintu vyedi vyose ukunga kwa mihilimo ilozize. Ikala wikazi wedi, dya, nywa, naho ubwede mwenye!’ ");
INSERT INTO ziw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mna Chohile niyo amgamba, ‘Mhezi weye! Dyelo dino nechilo walavya ujima wako, haluse ni yuhi akunga aguhe vintu vino vyoseni weikiye?’ ” ");
INSERT INTO ziw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu niyo akomeleza kugamba, “Vino nivyo vili kwa wose wakweikiya ugoli utendese mna sawo wagoli mwa meso ya Chohile.” ");
INSERT INTO ziw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Akaheza Yesu awagamba wanampina wakwe, “Nivyo vilekile huwagambani msekwehelwa mwe nkande mkunga iwenkeni ujima hegu mwe suche mkunga kwachausa che mili yenyu. ");
INSERT INTO ziw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ujima ni wedi kujinka nkande, na mwili nawo waungiswa kujinka suche. ");
INSERT INTO ziw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kaulani wadege hawakuhanda hegu hawakuvuna, hawana magulu hegu vihenge, Chohile awalisa! Nyuwe mwawagila vidala kujinka wadege! ");
INSERT INTO ziw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Niyuhi mgati mwenyu akudaha kweongezeza hata zuwa dimwenga kujinka chipindi cho wikazi wakwe? ");
INSERT INTO ziw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Uneva hamkudaha kudamanya chintu chidodo enga chino, ni mbwani una nkama na vintu vituhu? ");
INSERT INTO ziw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kaula maluwa ya kumbago ivyo yakusuka, hayakudamanya ndima hegu kwesumila suche. Mna nawagambilani kugamba hata Zumbe Sulemani na ugoli wakwe woseni hendaga na suche ntana saviya yano maluwa. ");
INSERT INTO ziw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ni Chohile akuvisa mani ya kumbago mani yakutenda hano dyelo nakwaga luvi, yakokwa mwe moto. Hatendese na ukanuni wakuwavisa? Ujeche wani wa uzumizi mnanawo! ");
INSERT INTO ziw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Elo msekwehanganya, chila nkanana mfanyanye chiya namdye na kunywa. ");
INSERT INTO ziw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwaviya wantu sawo Wayahudi mno mwe isi nawo wakulonda vintu vyoseni ivyo. Tati yenyu kavimanya kugamba mwavyunga vintu ivyo.” ");
INSERT INTO ziw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mna, mwevinye no Useuta wakwe, naye nawenkeni vino vintu. ");
INSERT INTO ziw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Msekogoha, nyuwe bunga dodo, kwaviya Tati yenyu kelelwa kuwenka Useuta.” ");
INSERT INTO ziw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tagani vintu vyenyu vyose na muwenke wachiwa izihela. Kweikiyeni hela hezikusakala, naho mweikiye ugoli wenyu kwembingu, kudya hekudaha kuhunguka, kwaviya hakuna mbavi akudaha kuubwila, na matele hayakudaha kuubalanga. ");
INSERT INTO ziw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kwaviya myoyo yenyu chila nkanana naitende kudya ugoli wenyu wili. ");
INSERT INTO ziw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mwikale enga wandima wakumgoja mkulu ywawo kwa ntendwa hamwenga na taa zenyu zikaka, ");
INSERT INTO ziw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mtende saviya wandima wakumgoja mkulu ywawo auye kulaila kwembwedo wa nyinka. Umo akeza nakugong'onda ulwivi, nawamvugwile aho.” ");
INSERT INTO ziw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Chinyemi chivivihi kwa wadya wandima wakunga wabwilwe ni mkulu ywawo wakacheleza chipindi akuwiya! Nawagambilani chindedi, nahambule suche yakwe, awaunge wekale hasi wadye nkande, na kuwasankanila. ");
INSERT INTO ziw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nawatende na chinyemi wandima wadya nawabwile wakacheleza kubula nechilogati hegu nyumani mwe saa idya! ");
INSERT INTO ziw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Naho mvimanya kugamba hegu mta nyumba anamanya muda akwizila mbavi, hamlekele avune nakwingila mnyumba. ");
INSERT INTO ziw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","“Nyuwe, nanywi, mwaungwa mwemalanye, kwaviya Mwana ywa Mntu neze mwe chipindi hemwikuifanyanya.” ");
INSERT INTO ziw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petulo agamba, “Zumbe, mliganyo uno ni wetu suwe, hegu ni kwa chila yumwenga?” ");
INSERT INTO ziw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Zumbe ahitula, “Ni yuhi, naho, mzumizi na mmanyi na msankani? Ni yudya aikigwe ni mkulu ywakwe achimaile weyawe, na kumlagiza awenke nkande mwe chipindi chikigwe.” ");
INSERT INTO ziw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mndima uyo natende na chinyemi chivivihi hegu zumbe dyakwe anambwila akadamanya vino umo akauya kukaya! ");
INSERT INTO ziw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Chindedi, nawagambilani, mkulu namtende mndima uyo achimaile vintu vyakwe vyose. ");
INSERT INTO ziw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mna hegu mndima uyo akelongela mo moyo kugamba mkulu ywakwe akawa kuya niyo akonga kuwatowa wandima watuhu, wagosi na wavyele, na kudya na kunywa nakukolwa, ");
INSERT INTO ziw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ivyo mkulu ywo mndima uyo neze mwe zuwa hemanyize na saa heimanyize. Naho namtowe enga wantu sawo wazumizi. ");
INSERT INTO ziw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mndima akumanya chiya mkulu ywakwe akunga adamanyizwe, mna hakwemalanya kuchidamanya, na asulumizwe kwa kutoigiswa. ");
INSERT INTO ziw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mna yudya mndima hemanyize mbuli hekunga mkulu ywakwe, na akudamanya mbuli zikuwagila nkanto, natoigwe nkome njeche. Kwaviya chila mntu enkigwe vilozise, naho enkigwe ukulu utendese nauzwe vitendese.” ");
INSERT INTO ziw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Siza kuchulika moto isi, nasivyungisa vyatendile uchuikwa kale! ");
INSERT INTO ziw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nina ubatizo wa kuhokela, nkunto yani ninanayo kubula uchinte! ");
INSERT INTO ziw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mwafanyanya kugamba nasiza kwigala utondowazi mwe si? Sivyo ivyo, siyo utondowazi, mna mwenegano. ");
INSERT INTO ziw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kukongela haluse wantu washano wa lukolo lumwenga nawenegane, watatu nawahigane na waidi na wahigane na watatu. ");
INSERT INTO ziw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Watate nawahigane na wanawawo, wana nawo na watati zawo, wavyele nawahigane na wanachiche wawo, na wanachiche mwe mamizawo, wakwe wa chivyele nawahigane na wakaza wana wawo, wakaza wana nawo mwe wakwe zawo wa chivyele.” ");
INSERT INTO ziw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu alonga naho kwa wantu, “Umo mkawona ingu kulaila ntendele za mwingilo wa zuwa, aho mwalonga kugamba fula yaunga inye naho yavitenda. ");
INSERT INTO ziw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Naho umo mkeva mpeho ikavumila, mwalonga kugamba kwatenda na chivuguto naho chalaila. ");
INSERT INTO ziw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nyuwe wasongaganyi! Mmanya kubunkula ivyo isi ili no ulanga, nimbwani hamkudaha kubunkula chipindi cha haluse? ");
INSERT INTO ziw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nimbwani nyuwe wenye hamkwelamwila wedi? ");
INSERT INTO ziw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Uneva ukaita kwe chitala na mlahi ywako, mwivane mwe isila hemnati kubula kwechitala. Hegu sivyo nakwigale kwe chitala mkanti, akunga awenke wankondo, naho namjelwe mndani. ");
INSERT INTO ziw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Uko nawikale, nawagambilani, mkabula kuliha hela ya udumo kwa maliho yenyu ya malaho.” ");
INSERT INTO ziw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chipindi icho wantu wamwenga nawehadya wamgambilaga Yesu mbuli za Wagalilaya wakomagwa ni Pilato umo nawakachinja wanyama chani walavye ntambiko zawo kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu niyo awagamba, “Mwafanyanya kugamba Wagalilaya awo wendaga na masa yatendese kujinka watuhu, hambwe kwaviya wasulumizwa saivyo? ");
INSERT INTO ziw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ichindedi sivyo ivyo! Naho nawagambilani kugamba hegu hamnaeile masa yenyu, nyoseni nambanike saviya wabanike. ");
INSERT INTO ziw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hegu mwafanyanya kugamba wadya wantu mlongo na mnane wagwelagwa nu mnala kudya ko mzi wa Silowamu niyo wabanika wana masa kujinka wekazi wose nawakekala Yelusalemu? ");
INSERT INTO ziw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ichindedi sivyo ivyo! Naho nawagambilani kugamba hamneile masa yenyu, nyose nambanike saviya wabanike.” ");
INSERT INTO ziw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu niyo awasimwila mliganyo uno, “Hendaga na mntu yumwenga mta mti wa mtini mwe nkonde yakwe. Mntu uyo aitaga chani akazungule tini mo mtini uwo, mna niyo aubwila mti uwo haweleke hata ntunda dimwenga. ");
INSERT INTO ziw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Niyo amgamba yudya msinya inkonde, ‘Kaula! Ni mihilimo mitatu neza hano kuzungula tini mo mtini uno, mna silondole chochose. Ukante! Nimbwani ukujendeleza kujeseza isanga vya bule?’ ");
INSERT INTO ziw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mna yudya msinyi wo mgunda ahitula, ‘Zumbe, ndakuuleka, ujinke mhilimo umwenga, naniuhaile nakuujeila mboleya. ");
INSERT INTO ziw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Hegu uneva uneleka mhilimo ukutimila, navitende vyedi vidala, hegu sivyo ivyo, wadaha kuukanta.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Zuwa dimwenga dya kuhumula Yesu na kahinya mwe nyumba yo kuvikila. ");
INSERT INTO ziw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mvyele yumwenga endaga mnyonje, engilagwa ni mpepo zihiye kwa chipindi cha mihilimo mlongo na mnane, mgongo wakwe wendaga uhinda hakudaha kuchuluka. ");
INSERT INTO ziw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu eze amwone niyo amwitanga, “Mnala, kuhonywa unyonje wako!” ");
INSERT INTO ziw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Amwikiya mikono yakwe, ahadya echulusa mwenye na kumtunya Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mkulu ywe nyumba yo kuvikila kehiwa kwaviya Yesu kahonya mwe Zuwa dya kuhumula, ivyo alonga kwa wantu, “Kuna mazuwa mtandatu yakudamanya ndima, ivyo wize mwe mazuwa ayo chani uhonywe, siyo mwe Zuwa dya kuhumula!” ");
INSERT INTO ziw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Zumbe amhitula, “Nyuwe wasongaganyi! Chila yumwenga ywenyu mwe Zuwa dya kuhumula hakukomweila njeku yakwe au mpunda kulaila mwe didewa na kuigala ko kuinywesa mazi? ");
INSERT INTO ziw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Haluse mwelekwa yuno ywa Bulahimu nuyo avugailagwa ni Shetani kwa mihilimo mlongo na mine, hakungigwa alekeilwe chifungo chakwe mwe Zuwa dya kuhumula?” ");
INSERT INTO ziw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hitulo dyakwe ditenda wahigani wakwe wahuze, mna wantu watuhu niyo welelwa mwe mbuli zose zikwehela adamanye. ");
INSERT INTO ziw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu kauza, “Useuta wa Chohile wi savihi? Nadaha kuuliganya na mbwani? ");
INSERT INTO ziw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wikala savino. Mntu aguha mbeyu nddo ikwitangwa haladali nakuihanda mwe nkonde yakwe. Yakula na kutenda mti, na wadege wo ulanga wazenga masasa mwa matambi yakwe.” ");
INSERT INTO ziw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu kauza naho, “Useuta wa Chohile naniuliganye na mbwani? ");
INSERT INTO ziw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wekala savino. Mvyele aguha hamila njeche na kuihanganya na madebe maidi na nusu ukajika unga wose niyo wagwaduka.” ");
INSERT INTO ziw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu niyo ajendeleza na ntambo yakwe kwita Yelusalemu, kajinkila kwe mizi na kaya, akahinya wantu Mbuli Yedi. ");
INSERT INTO ziw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yumwenga kamwuza, “Zumbe, nawahonywe wantu wajeche du?” Yesu kawahitula, ");
INSERT INTO ziw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Damanyani viya mkudaha kwingila mwe lwivi lufinyu, kwaviya wantu walozize nawajeze kwingila mna hawadahe. ");
INSERT INTO ziw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mkulu ywa nyumba nenuke nakuvugala ulwivi, niyo umo mkachimala kuse nakukonga kulonga mo ulwivi nakugamba, ‘Zumbe chivugwile ulwivi!’ Nawahituleni, ‘Sivimanyize mwalawahi!’ ");
INSERT INTO ziw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Niyo mwahitula, ‘Chidya na kunywa hamwenga na nyuwe kuhinya mo mzi wetu!’ ");
INSERT INTO ziw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mna nagambe naho, ‘Simanyize uko mkulaila. Halaweni hangu, nyuwe wose mkudamanya yehiye!’ ");
INSERT INTO ziw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Namwile vivihi nakusigina meno yenyu umo mkamwona Bulahimu, Isaka na Yakobo na wawoni woseni mo Useuta wa Chohile, umo nyuwe mduligwe kuse! ");
INSERT INTO ziw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wantu na weze kulaila ulailo wa zuwa na uswelo wa zuwa, na kulaila kwa mwenye mzi na chibula, nakwikala he ngasu mo Useuta wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Niyo wadya we waudumo haluse nawatende wankongo, na wadya wankongo haluse nawatende wa udumo.” ");
INSERT INTO ziw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mwe chipindi icho Mafalisayo wamwenga weza kwa Yesu na kumgamba, “Waungwa uhalawe hano wite hantu hatuhu, kwaviya Helode aunga akukome.” ");
INSERT INTO ziw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu awahitula, “Hitani mkadigambe diya uzi, ‘Nagulusa mpepo nakuhonya dyelo na luvi, mwe dizuwa dya katatu nanibindilize ndima yangu.’ ");
INSERT INTO ziw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Havinati naungwa nitende mwe sila dyelo, luvi, nachisindo siyo vyedi kwa muwoni kukomwa hatuhu mna Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yelusalemu, Yelusalemu! Weye ukuwakoma wawoni na wasigilwe ni Chohile kwenyu kwa kuwaduila mayuwe! Nkanana zilozize nasunga niwachisanye wekazi wako saviya nguku akufugasila wanawe hasi mwa mawawa yakwe, mna nyuwe hamnungile! ");
INSERT INTO ziw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na kwaivyo Nyumba yenyu nkulu ya kuvikila nailekwe. Nawagambilani kugamba hamniwone naho kubula umo namgambe, ‘Kajimbikwa uyo akwiza kwa zina dya Zumbe.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Zuwa dimwenga dya kuhumula Yesu nakaita kudya nkande mwe nyumba ya chilongozi yumwenga ywa Mafalisayo, wantu nawo nawakamsinya Yesu kwa hajihi. ");
INSERT INTO ziw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mntu yumwenga mta viga na mikono ivimbile kamwizila Yesu, ");
INSERT INTO ziw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu naye awauza wahinya Sigilizi na Mafalisayo, “Sigilizi yaunga kuhonya mwe Zuwa dya kuhumula hegu bule?” ");
INSERT INTO ziw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mna wowo niyo wanyamala. Yesu niyo amtoza uyo umnyonje na kumhonya, amleka aite zakwe. ");
INSERT INTO ziw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Niyo awagamba, “Uneva yoyose yumwenga ywenyu mta mwana hegu njeku igwele mwe bome mwe Zuwa dya kuhumula, hamvilavye aho mwe Zuwa dya kuhumula?” ");
INSERT INTO ziw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mna hawadahile kumhitula mwe vino. ");
INSERT INTO ziw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu nakabunkula viya wajeni wamwenga nawakasagula hantu hedi, ivyo kawagambila woseni umliganyo uno. ");
INSERT INTO ziw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Umo yumwenga anakugoneke kwe nyinka, usekwikala hantu hedi. Vyadahika kagonekwa yumwenga wa awagile kujinka weye, ");
INSERT INTO ziw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","mkaya wako, awagoneke woseni waidi, neze nakulonga kwenyu, ‘Mlekeni ekale hano.’ Niyo nawingile soni nakwikala hantu hasi. ");
INSERT INTO ziw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mna, ukagonekwa, jenda ukekale hantu hasi, chani mkaya ywako akeza kulonga kwako, ‘Mbuyangu, so hantu hedi,’ Ino naikwinke ntunyo mwa wajeni woseni. ");
INSERT INTO ziw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwa wadya woseni wakwetenda wakulu nawaselezwe, na wadya wakweseleza nawatendwe wakulu.” ");
INSERT INTO ziw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Niyo Yesu amgamba mkaya ywakwe, “Ukalavya nkande ya msi hegu ya chisingi, usekugoneka mbuyazo hegu walukolo wako wakwelekwa hegu wehaguhi wagoli kwaviya nawakugoneke, usekunga kulihwa kwa chiya udamanye. ");
INSERT INTO ziw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ukadamanya ngasu, wagoneke wachiwa, vilema na waholomale na mantuntu, ");
INSERT INTO ziw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","naujimbikwe, kwaviya hawadahe kukuliha. Chohile nawalihe mwe zuwa dya uyuso kwa wantu wedi.” ");
INSERT INTO ziw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yumwenga mwa wadya wekale mwe meza eze eve vino, amgamba Yesu, “Chinyemi chivivihi kwa wekale he ngasu mo Useuta wa Chohile!” ");
INSERT INTO ziw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu amgamba, “Kwendaga na mntu yumwenga nana ngasu nkulu niyo agonekaga wantu walozize. ");
INSERT INTO ziw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chipindi che ngasu chizechibule, kasigila wandima wakwe kugambila wajeni wakwe, ‘Soni, chila chintu chajika!’ ");
INSERT INTO ziw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mna woseni wakonga kulavya uzulu yumwenga kutimila mtuhu. Wankongo kamgamba uyo mndima, ‘Sigula mgunda naungwa nite haukaule, hake netegeleza.’ ");
INSERT INTO ziw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mtuhu agamba, ‘Sigula jozi shano za njeku ivyo nimwesila kwita hazijeze, hake netegeleza.’ ");
INSERT INTO ziw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mtuhu agamba, ‘Nivyo silawa mwe kusola, kwa ivyo sikudaha kwiza.’ ");
INSERT INTO ziw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Yudya mndima niyo auya nakumgambila zumbe dyakwe yoseni yano. Zumbe kehiwa nakumgamba mndima ywakwe, ‘Guluka wite kwe zisila nkulu na ndodo zo umzi, walete wachiwa na vilema na mantuntu na waholomale.’ ");
INSERT INTO ziw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Aho mndima agamba, ‘Zumbe, viya ungile vidamanyika kale, mna hechei na hantu ha kwikala.’ ");
INSERT INTO ziw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ivyo zumbe amgamba mndima, ‘Jenda wite kwe zisila nkulu na ndodo ze isi uwalete wantu, chani nyumba yangu imeme. ");
INSERT INTO ziw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nawagambilani kugamba hamna hata yumwenga mwe wadya wagonekwe nalume nkande yangu ya chisingi!’ ” ");
INSERT INTO ziw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Aho mafyo makulu ya wantu nayakatimilizana na Yesu, kahituka nakuwagamba, ");
INSERT INTO ziw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Wadya wakwiza kwangu hawakudaha kutenda wanampina wangu hegu wakanungisa miye kujinka tati zawo na mami zawo, mvyele na wanawe, walukolo wawo na walumbu zawo, na kujinka ujima wawo wenye. ");
INSERT INTO ziw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wadya hewekwinula misalaba yawo wenye na kunitimila hawakudaha kutenda wanampina wangu. ");
INSERT INTO ziw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Uneva yumwenga ywenyu afanyanya kuzenga mnala, wakonga kwikala hasi nakukaula kugamba wonga uzengwe kwa yombe dyani, kukaula hegu una hela ya kuchinta kubindiliza indima iyo. ");
INSERT INTO ziw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Huna vitendile ivyo, haudahe kukomeleza umnala uwo ukaheza kuzenga msingi, woseni wakuwona chilaile nawakuseke. ");
INSERT INTO ziw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nawagambe, ‘Yuno mntu kakonga kuzenga mna hakudaha kubindiliza indima!’ ");
INSERT INTO ziw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Uneva Seuta yumwenga anafosa na wantu mlongo magana mlongo kutowana na seuta mtuhu akwiza na wantu milongo midi magana mlongo, nandekwikala hasi nakukaula hegu ana udahi wa kudaha kuhigana na zumbe mtuhu uyo. ");
INSERT INTO ziw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Hegu hakudaha, nasigile wantu kudugana na zumbe uyo, kulombeza utondowazi umo yeye achei hale. ");
INSERT INTO ziw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mwe ivyo,” Yesu akomeleza, “Hahana yumwenga mwenyu akudaha kutenda mwanampina ywangu uneva hana lekile chila chintu ananacho. ");
INSERT INTO ziw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Munyu ni wedi, mna hegu unaza umunyu wakwe, hakuna sila yakuvuza umunyu wakwe naho. ");
INSERT INTO ziw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Suwo wedi kwa ulongo hegu zala, wadulwa. Tegelezani, hegu mna magutwi!” ");
INSERT INTO ziw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Zuwa dimwenga umo wachisanya kodi na wata masa watuhu weza kumwetegeleza Yesu, ");
INSERT INTO ziw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafalisayo na wahinya Sigilizi wakonga kung'ung'uzika, “Yuno mntu ahokela wata masa naho adya hamwenga nawo!” ");
INSERT INTO ziw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ivyo Yesu awagambila mliganyo uno. ");
INSERT INTO ziw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Fanyanya yumwenga mwenyu ana ngoto gana niyo imwenga mwe izo yaga natende mbwani? Wasa ntuhu mlongo chenda na chenda zikadya nakwita ukalonde iyo imwenga yagile kubula aho nailondole. ");
INSERT INTO ziw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Unailondola, watenda na chinyemi nakwihagata mayega yako, ");
INSERT INTO ziw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","nakuivuza kukaya. Niyo wetanga wambwiyazo na wajihi wako hamwenga na kuwagamba, ‘Nina chinyemi vidala silondola ngoto yangu yagaga. Nachivineni!’ ");
INSERT INTO ziw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mwe ivyo, nawagambilani, nakutende na chinyemi vidala kwembingu mwe mta masa yumwenga akweila masa kujinka wantu milongo chenda na chenda wakuwoneka wedi kulongozi kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Hegu fanyanya mvyele mta matundu mlongo ya hela aza dimwenga mwe ayo natende mbwani? Awasha taa, ahagila nyumba yakwe, nakusinyisa chila hantu kubula aho nadilondole. ");
INSERT INTO ziw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Anadilondola, etanga wambuya zakwe na wajihi wakwe hamwenga, nakuwagamba, ‘Nina chinyemi vidala silondola tundu dyangu dyagaga. Nachivineni!’ ");
INSERT INTO ziw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mwe ivyo, nawagambilani, wandima wa kwembingu wa Chohile watenda na chinyemi mwe yumwenga akweila masa yakwe.” ");
INSERT INTO ziw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu ajendeleza kulonga, “Kwendaga na mntu mta wana waidi. ");
INSERT INTO ziw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Umdodo amgamba, ‘Tate, ninka hantu ho ugoli wangu haluse.’ Ivyo yudya mntu enkiza vintu vyakwe mwa wanawe waidi. ");
INSERT INTO ziw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mazuwa majeche yeze yakajinke mwana umdodo niyo ataga ntendele ya ugoli wakwe nakuhalawa hanyumba na hela. Kaita kwe si ya hale, uko kajeseza hela zakwe mwe wikazi wihiye. ");
INSERT INTO ziw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kajeseza chila chintu nananacho. Niyo kwengila gumbo kulu mwe si yose, naye kasigwa hena chintu. ");
INSERT INTO ziw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ivyo aita kwa mkaya yumwenga mwe isi iyo kwe kudamanya ndima, amwigale kwe nkonde yakwe akalise nguluwe. ");
INSERT INTO ziw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nakaunga hegu nakadaha kudya mwe zae dye zinguluwe, mna hahana amwinkile chochose cha kudya. ");
INSERT INTO ziw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ko udumo ezilwa ni fanyanyi na kugamba, ‘Wandima woseni wa tate wana chimemile cha kudya, miye hano nonga kukomwa nisala! ");
INSERT INTO ziw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nanihalawe na kwita kwa tate nakumgamba, Tate, sidamanya masa kwembingu na kwa Chohile hamwenga na weye. ");
INSERT INTO ziw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sikuwagila kwitangwa mwanawo, nitenda saviya yumwenga ywa wandima wako.’ ");
INSERT INTO ziw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ivyo achimala nakukonga ntambo kuya kwa tati yakwe. “Nachei hale kulaila kukaya umo tati yakwe amwone, moyo wakwe naumema mbazi, niyo aguluka, edula mwe mikono yakwe kumzunguluka mwanawe nakumsesa. ");
INSERT INTO ziw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yudya mwana agamba, ‘Tate,’ ‘Sidamanya masa kwa Chohile hamwenga na weye na kwembingu. Sikuwagila kwitangwa mwanawo.’ ");
INSERT INTO ziw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mna tati yamntu ketanga wandima wakwe. Agamba, ‘Sunguzani!’. ‘Igalani suche yedi vidala mumvise. Mviseni mpete mwa kadole kakwe na vilatu mwe viga vyakwe. ");
INSERT INTO ziw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mkaheza mwite mkaguhe ndama idamane mchinje, chivineni ngasu! ");
INSERT INTO ziw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwaviya yuno mwanangu nakabanika, mna haluse ni mjima, nakaga, mna haluse kalondoka.’ Aho ngasu yakonga. ");
INSERT INTO ziw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mwe chipindi icho mwana ywa yudya mdalahala nekwenkonde. Umo emwe sila akauya, eze abule hajihi na hakaya, eva nchelejele na ngoma. ");
INSERT INTO ziw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ivyo etanga yumwenga mwa wandima nakumuza, ‘Ni chibwani chikujendeleza?’ ");
INSERT INTO ziw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yudya mndima ahitula, ‘Mlukolo ywako kauya kukaya, tati yako naye kachinja ndama idamane, kwaviya kamhokela emjima.’ ");
INSERT INTO ziw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Yudya mwana umkulu nakehelwa vidala vilekile hengile kunyumba, ivyo tati yakwe afosa na kumlombeza engile. ");
INSERT INTO ziw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mna kamhitula tati yakwe, ‘Kaula, mihilimo ino yoseni sikusankanila enga mtumwa, naho salemelaga lagizo dyako. Kuninka mbwani? Hata mbuzi hadamanye ngasu na wambuya zangu! ");
INSERT INTO ziw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mna mwanawo yuno kaza ugoli wako kwa uchilanga, naho eze auye kaya, wamchinjiza ndama idamane!’ ");
INSERT INTO ziw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tati yamntu ahitula, ‘Mwanangu, wi hano mazuwa yose hamwenga na miye, chila chintu ninanacho ni chako. ");
INSERT INTO ziw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mna chaungwa chidamanye ngasu naho chitende na chinyemi, kwaviya mlukolo ywako nakabanika, mna haluse ni mjima nakaga, mna haluse kalondoka.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu niyo awagamba wanampina wakwe mliganyo uno, “Kwendaga na mgoli yumwenga endaga akachimaila ugoli wakwe. Yudya mchimaila niyo alongelezwa kwa mkulu ywakwe kugamba abalanga ugoli wa mkulu ywakwe, ");
INSERT INTO ziw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Akaheza mkulu ywakwe amwitanga niyo amgamba, ‘Ni mbuli zani nizivile kulawana na weye? Lavya mahokelo yose yo ugoli wangu kulawana na viya wingize na viya vifosize, naho hukudaha kutenda mchimaila ywangu naho.’ ");
INSERT INTO ziw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yudya mchimaila niyo elongela mwenye kugamba, ‘Zumbe dyangu aunga anilavye mo chimaila ugoli. Na nitende mbwani? Kulima sikudaha, naho kwita kwe kulombeza enga mchiwa nawona soni. ");
INSERT INTO ziw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Haluse simanya dyo kudamanya, chani umwo habalazwa mo uchimaila wantu wadahe kunihokela kwe zikaya zawo.’ ");
INSERT INTO ziw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Niyo awetanga wadya wose wakutigizwa ni mkulu ywakwe. Kamuza ywa nkongo, ‘Watigizwa chiyasi chani ni mkulu ywangu?’ ");
INSERT INTO ziw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Niyo amhitula, ‘Mavuta ya nyonyo mapila gana,’ yudya mchimaila ugoli niyo amgamba. ‘Guha ibaluwa yako ye ntigizo,’ mkulu amgamba, ‘ikala hasi uwandike watigizwa mapila milongo mishano.’ ");
INSERT INTO ziw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Akaheza amwuza mtigizwa mtuhu, ‘Weye watigizwa chiyasi chani?’ Niyo amhitula, ‘Majuniya gana ya ngano,’ yudya mchimaila niyo amgamba. ‘Guha ibaluwa yako ya ivyo mwivane,’ ‘Uwandike milongo mnane.’ ");
INSERT INTO ziw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Mna mkulu ywakwe niyo amtogola yudya mchimaila ugoli kwaviya adamanye kwa umanyi, kwa viya wantu wa mwe isi ino ni wabala vitendese kujinka wantu wakunga kwikala mo ng'azi.” ");
INSERT INTO ziw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu niyo ongezeza kugamba, “Nami nawagambilani, jesezani ugoli we isi ino kwa kutenda na wambuya, chani ugoli uwo ukasila, mhokelwe mo wikazi wa ujima wa mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mntu yeyose akunga atende mzumizi mwe mbuli ndodo naatende mzumizi mwe mbuli nkulu, na mntu yoyose yudya hatende mzumizi mwe mbuli ndodo, hakudaha kutenda mzumizi mwe mbuli nkulu. ");
INSERT INTO ziw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hegu nyuwe sawo wazumizi mwe ugoli we isi ni yuhi akunga awenkeni ukanuni na kuwatunyani mwe ugoli wa chindedi? ");
INSERT INTO ziw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hegu hwimkanuni na ugoli wa mntu mtuhu kwa uzumizi, ni yuhi akunga awenkeni ugoli wenyu we ichedu? ");
INSERT INTO ziw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Hahana mndima akudaha kusankanila wakulu waidi, kwa viya na mwihiwe yumwenga na kumungisa mtuhu. Hamkudaha kumsankanila Chohile no ugoli.” ");
INSERT INTO ziw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mna mafalisayo weze weve ayo yose, kwa viya wowo na wakaungisa hela niyo wamona Yesu hakuwagila chintu. ");
INSERT INTO ziw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu niyo awagamba, “Nyuwe mwi wantu mkwetenda kugamba mwawoneka wedi kulongozi kwa wantu, mna Chohile kamanya ye mwe myoyo yenyu. Kwaviya yakutogolwa ni wantu ni maihizo kulongozi kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sigilizi ya Musa na mawandiko ya wawoni yalongwa kubula kwiza kwa Yohana, kukongela chipindi icho Mbuli Yedi ya Useuta wa Chohile yalongwa, naho chila mntu engiza kwa nguvu mo useuta uwo.” ");
INSERT INTO ziw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mna ni vihufu vitendese imbingu ne isi kujinka, ukaleka kubula helufi imwenga ya Sigilizi yuswe. ");
INSERT INTO ziw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mntu yoyose akumwasa mkaziwe niyo asola mntu agonya, yoyose nasole mvyele asigwe agonya.” ");
INSERT INTO ziw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Hendaga na mntu yumwenga mgoli vidala, na akavala suche zina langi ya zambalau na chitani zina yombe kulu na kudamanya ngasu chila zuwa.” ");
INSERT INTO ziw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Naho nahana mchiwa yumwenga akwitangwa Lazalo, mchiwa uyo naana nkwenje mwili mjima wantu na wakamgoneza ho lwivi lwe nyumba ya yudya mgoli. ");
INSERT INTO ziw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yudya mchiwa na akaungisa adye nkande ikulagala mnanga mwe imeza hadya akudila yudya mgoli, naho makuli na yakeza yakamlambita mwezi nkwenje ahadya agonile. ");
INSERT INTO ziw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Yudya mchiwa niyo abanika, wandima wa kwembingu niyo wamguha wakwikala naye haguhi na Bulahimu.” Yudya mgoli naye niyo abanika, niyo ahambwa, ");
INSERT INTO ziw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Elo, kudya kwedibome hedina uhelo akasulumizwa niyo asinya kulanga niyo amwona Bulahimu, kwa luhale, na Lazalo akatenda ehankanda hakwe. ");
INSERT INTO ziw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Elo niyo etanga kwa izwi nkulu, Tate Bulahimu! Nifila mbazi, naho mgambe Lazalo atweze akadole kakwe mwa mazi anitwekeze hata twentwe dimwenga mo lulimi lwangu, kwaviya nasulumila vidala mo umoto uno! ");
INSERT INTO ziw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Mna Bulahimu niyo amhitula, ‘Kumbuka, mwanangu, kugamba mo wikazi wako mwe isi wenkagwa yedi, Lazalo niyo ahokela yehiye.’ Haluse Lazalo atondowazwa, weye wasulumizwa.” ");
INSERT INTO ziw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ukaleka ayo, mgati mwenyu na suwe hana bome kulu, chani wakunga kwiza kwenyu kulaila kuno wasekudaha, na wauko wasekudaha kwiza kuno. ");
INSERT INTO ziw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yudya mgoli agamba, Elo, nakulombeza weye, tate Bulahimu, msigile Lazalo aite kwe nyumba ya tate, ");
INSERT INTO ziw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kwaviya nina walukolo washano. Chani awagambe wanase kwiza kuno kwa masulumizo. ");
INSERT INTO ziw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Bulahimu niyo amgamba, ‘Walukolo wako wana mawandiko ya Musa na ya wawoni ya kuwafunda, waleke wayategeleze.’ ");
INSERT INTO ziw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mna yudya mgoli niyo agamba, ‘siyo ivyo, tate Bulahimu! Mna uneva mntu yumwenga anauyuka nakuwabasa, naweile kulaila mwa masa yawo.’ ");
INSERT INTO ziw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mna Bulahimu niyo amhitula, ‘Uneva hawanawevile Musa na wawoni, hata anauyuka mntu anawabasa hawamwive.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu niyo awagamba wanampina wakwe, “Vintu naviwahose wantu vyaungwa vilaile, mna namanye mwenye mntu yudya akunga avitende vilaile! ");
INSERT INTO ziw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Na vita vyedi mntu uyo atalizwe yuwe kulu dya kusigintila mwe singo akadulwe mwe bahali ukaleka akahosa yumwenga ywa wadodo wano wakole masa.” ");
INSERT INTO ziw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kwaivyo mwedime vyedi! Uneva mlukolo ywako anakola masa, mkwahile, na uneva aneila, mlekeile. ");
INSERT INTO ziw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“Uneva ana kola masa nkanana mfungate kwa zuwa, na chila nkanana auya kwako akagamba ‘neila kwako,’ mlekeile.” ");
INSERT INTO ziw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Wasigilwa niyo wamgamba Zumbe, “Chongezeze uzumizi wetu.” ");
INSERT INTO ziw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Zumbe niyo ahitula, “Uneva mna uzumizi saviya kapuluzi ka mbeyu ikwitangwa haladali, na mkadaha kuugamba umti uno wo mkuyu, ‘Ng'oka na ukehande mwe bahali!’ Nawo na uweveni.” ");
INSERT INTO ziw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Chigambe kwa mliganyo yumwenga ywenyu ana mndima ywakwe akulima kwe nkonde hegu akudima ngoto, togolani akauya kulaila kwe nkonde, namumgambe uyo mndima sunguza so udye nkande? ");
INSERT INTO ziw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bule! Mna, namgambe, ‘nikiya nkande, naho wikale ahano kubula nibinde ukudya na kunywa, vikaheza wenawe nivyo na udye.’ ");
INSERT INTO ziw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Togola, haumtogole uyo mndima kwa viya kadamanya yadya malagizo, bule? ");
INSERT INTO ziw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nivyo vili kwenyu nyuwe, uneva mdamanya yadya yose mgambigwe mdamanye, gambani, ‘Suwe chiwandima du, chibinda yadya chungigwe chidamanye.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Umo Yesu nemwe ntambo ya kwita Yelusalemu, nakajinka mwe mihaka ya Samaliya na Galilaya. ");
INSERT INTO ziw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Umo akengila mwe kaya imwenga niyo adugana na wantu mlongo wata matana. Wachimala kwa luhale, ");
INSERT INTO ziw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","waguta wakagamba, “Yesu! Zumbe! Chifile mbazi!” ");
INSERT INTO ziw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu eze awawone niyo awagamba, “Hitani kwa walavyantambiko mkelagise chani wawakauleni.” Mwesila wakajenda niyo walenguswa. ");
INSERT INTO ziw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yumwenga ywawo eze awone kahonywa, niyo auya, kuno akamtunya Chohile kwa izwi kulu. ");
INSERT INTO ziw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Niyo amfikila madi Yesu kuno akamtunya. Uyo mntu nani Mfambazi. ");
INSERT INTO ziw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aho Yesu agamba, “wantu walenguswe hawendile mlongo, awatuhu wekuhi? ");
INSERT INTO ziw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hawoneke mtuhu awiye kumtogola Chohile mna yuno mjeni uyodu?” ");
INSERT INTO ziw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Akaheza Yesu amgamba yudya mntu, “Chimala wite zako, uzumizi wako ukuhonya.” ");
INSERT INTO ziw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mafalisayo weza wamuze Yesu useuta wa Chohile nawize ini. Awahitula, “Useuta wa Chohile hawize kwa kuwoneka pwilili. ");
INSERT INTO ziw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Naho hahana yumwenga nagambe, ‘Kaula, wihano!’ Hegu, ‘Wihadya!,’ Kwaviya useuta wa Chohile wi mgati mwenyu.” ");
INSERT INTO ziw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Niyo awagamba wanampina wakwe, “Mazuwa yeza ayo mkunga munge muwone zuwa dimwe dya Mwana ywa Mntu, mna hamdiwone. ");
INSERT INTO ziw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wantu nawawagambeni, ‘Kaulani, ekudya!’ Mna nyuwe msekufosa naho mkawabasa. ");
INSERT INTO ziw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kwaviya enga lumwemwe viya lukwaka kwembingu na kumulika uko na uko, nivyo Mwana ywa Mntu akunga eze mwe dizuwa dyakwe. ");
INSERT INTO ziw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mna aungwa nkongo asulumiziswe na kulemelwa ni wantu wa dyelo. ");
INSERT INTO ziw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Saviya mwe dizuwa dya Nuhu nivyo vikunga vitende mwe chipindi cha Mwana ywa Mntu. ");
INSERT INTO ziw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mwa mazuwa yadya wantu na wakadya na kunywa, naho kusola na kusolwa, kubula zuwa diya Nuhu eze engile mwe safina na fula nkulu niyo yanya na kuwakoma wose. ");
INSERT INTO ziw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nivyo vyendaga mwa mazuwa ya Lutu. Wantu na wakadya na kunywa, kugula na kutaga, kuhanda na kuzenga. ");
INSERT INTO ziw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mna zuwa diya Lutu eze akulawe Sodoma, niyo kwalaila moto wa chibiliti usela kulaila kwembingu na kuwakoma woseni. ");
INSERT INTO ziw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ivyo nivyo vikunga vitende zuwa diya akwizila Mwana ywa Mntu. ");
INSERT INTO ziw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mwe dizuwa idyo mntu yudya aungagwa aselezwe hasi kulaila mnanga mwe nyumba asekusela kwita kwe nyumba yakwe akaguhe vintu vyakwe, seivyo mntu ekwenkonde asekuya kaya. ");
INSERT INTO ziw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kumbukani yadya yamlaile mkaza Lutu! ");
INSERT INTO ziw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yoyose nadime ujima wakwe nawaze, mna yudya nalavye ujima wakwe na audime. ");
INSERT INTO ziw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nawagambilani nyuwe, mwe dizuwa idyo, wantu waidi nawatende wagona mwe lusazi lumwenga, yumwenga aguhigwa, yumwenga asigwa. ");
INSERT INTO ziw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wavyele waidi nawatende wabunda hamwenga, yumwenga naguhigwe, yumwenga nasigwe.” ");
INSERT INTO ziw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wantu waidi nawatende mwenkonde imwenga, yumwenga naguhigwe, yumwenga asigwa. ");
INSERT INTO ziw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wanampina niyo wamuza, “Zumbe, mbuli zino nazidamanyike kuhi?” Yesu niyo awahitula, “Hadya hana chimba chiwoile, naho hakuchima magushu.” ");
INSERT INTO ziw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Akaheza Yesu awagambila wanampina wakwe mliganyo uno kwa kuwalagisa kugamba mazuwa yose waungigwa wamlombeze Chohile naho wasekufa chevu. ");
INSERT INTO ziw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Agamba, “Mwe mzi msiku kwendaga na mkanta yumwenga hekumogoha Chohile hegu hekumtunya mntu yoyose. ");
INSERT INTO ziw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Seivyo kwendaga na mvyele abanikilwe ni mgosi mo umzi uwo nakajendeleza kumbasa akalombeza enkigwe vintu vyakwe vikumuwagila, akagamba, ‘Nambiza mwe vikuniwagila mwa mhiga ywangu!’ ");
INSERT INTO ziw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa chipindi chitali yudya mkanta kalemela kudamanya, mna keuza mwenye akagamba, ‘Hata hegu sikumwogoha Chohile hegu sikutunya mntu yoyose, ");
INSERT INTO ziw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mna kwaviya yudya mvyele abanikilwe ni mgosiwe mwe chivuzovuzo akuninka, nani kaule kugamba ahokela vikumuwagila. Hegu sanivitende, najendeleze kwiza kunijela maya!’ ” ");
INSERT INTO ziw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Akaheza Zumbe agamba, “Tegelezani ivyo mkanta uyo aihiye ivyo alongile.” ");
INSERT INTO ziw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Elo, Chohile hawenke wadya wedi kulongozi kwa Chohile wantu wakumwila chilo na msi wambizwe? Nakawe kuwambiza? ");
INSERT INTO ziw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nawagambilani nyuwe, hakawe kuwenkani vikuwoneka vyedi kulongozi kwa Chohile. Mna Mwana ywa Mntu aho akwizila nabwile wazumile mwe isi? ");
INSERT INTO ziw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu awagambila naho mliganyo uno kwa wantu wewone kutenda wedi na kubela chila mntu mtuhu. ");
INSERT INTO ziw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nakuna wantu waidi wakweile kwita kwe kulombeza mwe Nyumba nkulu ya Chohile, yumwenga nani Falisayo, mtuhu ni mchisanya kodi.” ");
INSERT INTO ziw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Yudya Falisayo kachimala hankanda mwenye akalombeza zavino, weye Chohile, ‘Nakuhongeza weye, Chohile, kugamba miye suyo mbafu, naho nimchindedi naho si mgonyi hegu mbunyanyi, sayuno mchisanya kodi ehadya hankanda hekwiva. ");
INSERT INTO ziw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nafunga mazuwa maidi chila juma, naho nalavya fungu dyangu dya mlongo dya vintu vyose ni nanavyo.’ ");
INSERT INTO ziw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mna yudya mchisanya kodi kachimala kwa luhale naho haungile hata kwinula uso wakwe kwembingu, mna kutowa mwe chifuwa chakwe nakugamba, ‘Chohile, nifila mbazi, miye ni mkola masa!’ ");
INSERT INTO ziw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu niyo agamba, Nawagambilani,” “mchisanya kodi, kauya kaya akatenda kalekeilwa masa yakwe mna suyo Falisayo, akuoneka ywedi kulongozi kwa Chohile. Kwaviya woseni wakwekweza nawaselezwe, woseni nawo wakunyanyahala nawatendwe wakulu.” ");
INSERT INTO ziw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wantu wamwenga nawamwila Yesu chani awajelekele mikono yakwe. Wanampina weze wawone niyo wawakwahila kwa kudamanya ivyo, ");
INSERT INTO ziw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","mna Yesu kawetanga wadya wana kwakwe nakugamba, “Walekeni wana weze kwangu msekuwachinda, kwaviya Useuta wa Chohile wikwa wadodo sawano. ");
INSERT INTO ziw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Chindedi nawagambila vino! Yoyose hekuhokela Useuta wa Chohile enga mwana hawingile.” ");
INSERT INTO ziw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chilongozi yumwenga ywa Chiyahudi amuza Yesu, “Mhinya Ywedi, nidamanye mbwani nihokele ujima wa mazuwa yose?” ");
INSERT INTO ziw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu amuza, “Ni mbwani ukunitanga ywedi?” “Hakuna mntu ywedi ukaleka Chohile du. ");
INSERT INTO ziw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kuyamanya malagizo, ‘Usekugonya, usekukoma, usekubawa, usekulonga udanti, watunye iso na nyokwe.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yudya mntu ahitula, “kukongela ni mdodo, sitimila malagizo yano yoseni.” ");
INSERT INTO ziw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu eze eve vino, amgamba, “Kuchei nachintu chimwenga ukungigwa udamanye. Taga vyoseni unanavyo uwenke wachiwa izihela, nawe nautende na ugoli kwembingu, ukaheza wize unitimile.” ");
INSERT INTO ziw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mna yudya mntu eze eve vino, kengilwa ni chinyulu vidala, kwaviya nanimgoli vitendese. ");
INSERT INTO ziw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu kawona kugamba nana chinyulu vitendese, “Udala wi vivihi kwa mntu mgoli kwingila mo Useuta wa Chohile! ");
INSERT INTO ziw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ni vidala vitendese kwa mntu mgoli kwingila mo Useuta wa Chohile kujinka ngamiya kujinka mwe ntundu ya singano.” ");
INSERT INTO ziw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wantu wamwivaga wamuza, “Ni yuhi, naho, akudaha kukombolwa?” ");
INSERT INTO ziw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu ahitula, “Hechikudahika kwa mntu chadahika kwa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Niyo Petulo agamba, “Kaula! Suwe chileka kaya zetu nakukutimila weye.” ");
INSERT INTO ziw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu awagamba, “Chindedi,” naho nawagambilani kugamba yoyose akwasa nyumba hegu mvyele hegu mlukolo hegu welesi hegu wana kwachausa cha Useuta wa Chohile, ");
INSERT INTO ziw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nahokele vilozese mwe chipindi chino na wikazi wa ujima wa mazuwa yose mwe mihilimo ikwiza. ");
INSERT INTO ziw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu awaguha hankanda wadya wanampina mlongo na waidi nakuwagamba, “Tegelezani! Chaita Yelusalemu kudya chila chintu chiwandikwe ni wawoni mwe Mwana ywa Mntu nachitende chindedi. ");
INSERT INTO ziw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kwaviya nalavigwe mwe mikono ya wantu sawo Wayahudi, wadya wakunga wamtile, wamhulute na kumtwela mate. ");
INSERT INTO ziw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nawamhute na kumkoma, mna mazuwa matatu yakutimila nauyuke.” ");
INSERT INTO ziw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mna wadya wanampina hawakombaganye chochose mwe vino vintu, nikugamba ulosi ufisizwa wowo, naho hawamanyaga nichibwani Yesu nakakisimwila mwe mbwani. ");
INSERT INTO ziw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hadya Yesu eze atende haguhi no mzi wa Yeliko, kwendaga na mntu yumwenga tuntu ekale hankanda he sila, akalombeza. ");
INSERT INTO ziw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eze eve fyo dya wantu wakajinka, auza, “Kuna mbwani?” ");
INSERT INTO ziw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wamgamba, “Yesu wa Nazaleti ajinkila hano.” ");
INSERT INTO ziw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aguta, “Yesu! Mwana ywa Daudi! Nifila mbazi!” ");
INSERT INTO ziw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wantu walongole wamkwahila nakumgamba anyamale. Mna niyo agutisa, “Mwana ywa Daudi! Nifila mbazi!” ");
INSERT INTO ziw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Elo Yesu niyo achimala nakuwalagiza wamwigale yudya tuntu kwakwe. Eze abule hajihi, Yesu amuza, ");
INSERT INTO ziw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Waunga hudamanyize mbwani?” Ahitula, “Zumbe,” “Naunga niwone naho.” ");
INSERT INTO ziw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu amgamba, “Kwaivyo wana! Uzumizi wako ukuhonya.” ");
INSERT INTO ziw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ahadya yudya tuntu niyo adaha kuwona, niyo amtimila Yesu, kuno akamhongeza Chohile. Fyo dize diwone ivyo, wose wamtunya Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu kajendeleza kwingila Yeliko naho nakajinkanya. ");
INSERT INTO ziw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nakuna mchisanya kodi mkulu kudya akwitangwa Zakayo, endaga mgoli. ");
INSERT INTO ziw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nakajeza kusinya Yesu nani yuhi, mna nani mntu mjihi naho hadahile kumwona Yesu kwachausa che difyo. ");
INSERT INTO ziw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ivyo kalongola kulongozi kwe difyo nakukwela kulanga kwe mkuyu amwone Yesu, kwaviya Yesu nakaunga ajinkile mwe sila iyo. ");
INSERT INTO ziw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Umo Yesu eze abule hadya hantu, kasinya kulanga nakumgamba Zakayo, “Zakayo sunguza usele, kwaviya naungwa dyelo nikale mwe nyumba yako.” ");
INSERT INTO ziw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayo kasunguza kusela na kumhokela kwa chinyemi. ");
INSERT INTO ziw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wantu wose wawone ivyo wakonga kung'ung'uzika wakagamba, “Mntu yuno kaita na kwikala na mntu mta masa!” ");
INSERT INTO ziw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mna Zakayo niyo achimala nakumgamba Zumbe, “Zumbe! Tegeleza, naniwenke wachiwa nusu yo ugoli wangu, naho hegu namhokaga mntu yoyose chakwe, nanilihe nkanana nne kujinka.” ");
INSERT INTO ziw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu amgamba, “Dyelo wambulwa wingila mwe nyumba ino, kwaviya mntu yuno, naye, ni mwelekwa ywa Bulahimu. ");
INSERT INTO ziw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwaviya Mwana ywa Mntu keza kuzungula na kwambula wagile.” ");
INSERT INTO ziw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Umo wantu waketegeleza yano, Yesu kajendeleza na kuwagambila mliganyo. Kwaviya nehaguhi no mzi wa Yelusalemu, nawo nawakafanyanya kugamba mazuwa yo Useuta wa Chohile nawihajihi na kulaila. ");
INSERT INTO ziw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ivyo agamba, “Kwendaga na mntu yumwenga mkulu atambaga kwita mwe si ya hale vidala chani akatendwe seuta, akaheza auye kukaya. ");
INSERT INTO ziw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Umo henati kuhalawa, kawetanga wandima wakwe mlongo nakuwenka chila yumwenga tundu dya zahabu nakuwagamba, ‘Kaulani mwadaha kudamanya mbwani mwe chino chani mwingize umo miye sihali.’ ");
INSERT INTO ziw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mna, wantu wa kwawo niyo wamwihiwa, ivyo wasigila wantu kwakwe kugamba, ‘Hachikunga mntu atende seuta ywetu.’ ");
INSERT INTO ziw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Yudya mntu niyo atendwa seuta nakuya. Akaheza alagiza wadya wandima wakwe enkile yadya matundu weze, chani akaule chila yumwenga icho engize. ");
INSERT INTO ziw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ywa nkongo keza nakulonga, ‘Zumbe, miye singiza matundu ya zahabu mlongo mwe imwenga waninkaga.’ ");
INSERT INTO ziw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Agamba, ‘Kudamanya vyedi,’ ‘wimndima ywedi! Kwaviya na wi mkanuni kwa vintu vidodo, nahutende mchimaila ywa mizi mlongo.’ ");
INSERT INTO ziw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mndima ywa kaidi keza nakugamba, ‘Zumbe, miye singiza matundu mashano ya zahabu mwe imwenga waninkaga.’ ");
INSERT INTO ziw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Uyo naye amgamba, ‘Nahutende mkulu mwe mizi mishano.’” ");
INSERT INTO ziw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mndima mtuhu keza nakugamba, ‘Zumbe, tundu dyako dya zahabu dino dihano, nasidifisa mwe katambala ka mo mkono. ");
INSERT INTO ziw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nahakogoha, kwaviya wi mntu mdala. Waguha sicho chako naho wavuna hwihandile.’ ");
INSERT INTO ziw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Amgamba, ‘Wimndima ehiye! Nahukantile kwa ulosi wako mwenye! Kuvimanya kugamba ni mdala, kuguha sicho changu nakuvuna sihandile. ");
INSERT INTO ziw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nivyedi, elo, nimbwani hwikiye hela zangu kwa wakulavya vyongezekele? Niyo nahokela chongezekele umo ukanivuziza.’ ");
INSERT INTO ziw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Niyo alonga kwa wadya nawachimale hadya, ‘Guhani idyo iditundu dye zahabu kulaila kwakwe mmwinke mndima yudya mta matundu mlongo.’ ");
INSERT INTO ziw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mna wamgamba, ‘Zumbe, ana matundu mlongo kale!’ ");
INSERT INTO ziw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Awahitula, ‘Nawagambilani,’ ‘kugamba mtu mta chintu, nongezezwe, mna wadya hewena chintu, hata chiya chidodo wananacho nawahokwe. ");
INSERT INTO ziw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Haluse, kwa wadya wankondo wangu hawaungile miye nitende seuta ywawo, waleteni hano muwakome mwa meso yangu!’ ” ");
INSERT INTO ziw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu eze alonge vino, kawalongweila kwita Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Umo akabula hajihi na Betifage na Besaniya ho lugulu lwa Mizeituni, kasigila wanampina waidi walongole, ");
INSERT INTO ziw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","awasigila vino, “Hitani kudya ko mzi wikulongozi kwenyu, umo mkengila, namlondole mwana mpunda atalizwe henati kukwelwa. Mchohweleni mumwigala hano. ");
INSERT INTO ziw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Uneva mntu anawauzani ni mbwani mwamchohola, mgambeni kugamba Zumbe amunga.” ");
INSERT INTO ziw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Waita intambo yawo nakubwila chilachintu saviya Yesu awagambile. ");
INSERT INTO ziw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Umo wakamchohola yudya mwana mpunda, umwenye awauza, “Ni mbwani mkumchohola?” ");
INSERT INTO ziw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wahitula, “Zumbe, amunga,” ");
INSERT INTO ziw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","niyo wamwigala mwana mpunda uyo kwa Yesu. Wadula suche zawo mwe mpunda iyo nakumwambiza Yesu kukwela. ");
INSERT INTO ziw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Umo akajendeleza, wantu watandaza suche zawo mwe sila. ");
INSERT INTO ziw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Eze abule haguhi na Yelusalemu, hantu hana seleza kwita kolugulu lwe Mizeituni, fyo kulu dya wanampina wakwe welelwa na kukonga kumhongeza Chohile na kumtogola kwa izwi kulu kwa mpituko zose wawone. ");
INSERT INTO ziw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wakagamba, “Ajimbikwe seuta akwiza kwa zina dya Zumbe! Utondowazi kwembingu na ukuka kwa Chohile!” ");
INSERT INTO ziw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Niyo Mafalisayo wamwenga mwe difyo walonga wamgamba Yesu. Wagamba, “Mhinya,” “wakwahile wanampina wako wanyamale!” ");
INSERT INTO ziw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu awahitula, “Nawagambilani kugamba uneva wananyamala, mayuwe nayagute.” ");
INSERT INTO ziw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu eze abule haguhi no umzi, na eze auwone, kawila, ");
INSERT INTO ziw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","akagamba, “Hegu du wamanyize dyelo dino chintu chikudaha kukwigaila utondowazi! Mna haluse hukudaha kuchiwona! ");
INSERT INTO ziw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kwaviya mazuwa yeza umo wankondo wenyu nawawazunguluke kwa nkondo, aho nawazenge chiwambaza cha kuwachinda nakuwavugaila ntendele zose. ");
INSERT INTO ziw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nawawakomeni vitendese na wantu we mwe viwambaza vyenyu, hahana yuwe dikunga disigazwe hantu hakwe, kwaviya hawakombaganye chipindi umo Chohile akunga eze awambuleni!” ");
INSERT INTO ziw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu niyo engila mwe Nyumba nkulu ya Chohile nakukonga kugulusa wakutaga mayombe, ");
INSERT INTO ziw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","akawagamba, “Iwandikwa mwa mawandiko kugamba Chohile kagamba, ‘Nyumba nkulu ya Chohile ya Kuvikila naitende nyumba ya kulombezeza.’ Mna nyuwe mwihitula hantu hakwefisiza wabavi!” ");
INSERT INTO ziw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu na kahinya chila zuwa mwe Nyumba nkulu ya Chohile. Walavyantambiko wakulu, wahinya Sigilizi, na vilongozi wa wantu nawakaunga wamkome, ");
INSERT INTO ziw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","mna hawabunkule sila yakumkoma, kwaviya wantu wose nawakamwetegeleza, wasekuleka kwiva ulosi wowose. ");
INSERT INTO ziw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Zuwa dimwenga umo Yesu nakahinya wantu mwe Nyumba nkulu ya Chohile na kulonga Mbuli Yedi, walavyantambiko wakulu na wahinya Sigilizi, hamwenga na wadalahala, weza ");
INSERT INTO ziw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nakumgamba, “Chigambile, Wadamanya mbuli zino kwa udahi wa yuhi? Ni yuhi akwinkile udahi uno?” ");
INSERT INTO ziw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu awahitula, “Gojani niwauze mbuli. Nigambilani, ");
INSERT INTO ziw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Udahi wa Yohana wo kubatiza ulaila kwembingu hegu kwa mntu?” ");
INSERT INTO ziw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Niyo wafanyanya chalumwe, “Chigeze? Uneva chinagamba, ‘Ulaila kwembingu,’ nagambe, ‘Nimbwani, hamumzumile Yohana?’ ");
INSERT INTO ziw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mna uneva chinagamba ‘Ulaila kwa wantu,’ dino difyo dyose nadichitowe mayuwe, kwaviya wabunkula kugamba Yohana endaga muwoni.” ");
INSERT INTO ziw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ivyo wahitula, “Hachivimanyize uko ulaile.” ");
INSERT INTO ziw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu awagamba, “Saniwagambileni, ni kwa udahi wani nadamanya mbuli zino.” ");
INSERT INTO ziw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu niyo ajendeleza kuwagambila mligano uno, “Kwendaga na mntu yumwenga nakalima nkonde yakwe ya mizabibu, niyo aikodisha kwa walimizi, niyo atamba kwita si ya hale kakwikala uko kwa chipindi chitali. ");
INSERT INTO ziw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Umo chipindi cho uvuni we zabibu chize chibule, niyo amsigila mndima ywakwe yumwenga kwa wadya walimizi chani wamwinke ntendele yakwe yo ulozo. Mna wadya walimizi niyo wamtowa yudya mndima na kumvuza mikono bule. ");
INSERT INTO ziw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yudya mntu niyo amsigila mndima mtuhu, mna naye niyo wamtowa saiviya na kumtendela vihiye na kumvuza mikono bule. ");
INSERT INTO ziw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Niyo asigila mtuhu ywa katatu, yuno naye weze wamtowe na kumlumiza niyo wambalaza. ");
INSERT INTO ziw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Vikaheza yudya zumbe mta inkonde ye mizabibu niyo agamba, ‘Nitende zeze? Nani msigile mwanangu hungisa, wadaha wakamwiva.’ ");
INSERT INTO ziw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wadya walimizi weze wamuwone yudya mwana niyo wagambilana, ‘Yuno nuyo mlisi, haluse chimkome chani uno ulisi utende wetu.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Niyo wamlavya mweidya inkonde ye mizabibu, wamkoma. Yesu niyo auza, “Yuno zumbe mta inkonde nawatende mbwani wadya walimizi?” ");
INSERT INTO ziw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Neze awakome wadya walimizi na kuwenka walimizi watuhu idya inkonde ye mizabibu.” Wantu weze weve ziya izimbuli, niyo wamhiga wagamba “Havikudahika!” ");
INSERT INTO ziw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mna Yesu niyo awasinya, awagamba, “Mawandiko yano Yakukile manakwe ni mbwani? ‘Yuwe dilemelwe ni wazesi, haluse ditenda yuwe kulu dya msingi.’ ");
INSERT INTO ziw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Mntu yoyose anagwa mnanga mwe diya diyuwe nakantike vihandehande, naho dinamgwela mntu yoyose nadimtiginte enga unga.” ");
INSERT INTO ziw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wahinyi wa Sigilizi na walavyantambiko wakulu na wamanya kugamba mligano uwo wawalanga wowo, ivyo na wakaunga wamgwile ahadya, mna nawakawogoha wantu. ");
INSERT INTO ziw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ivyo niyo wakonga kumhanga Yesu, niyo wasigila wazuza waketenda ni wantu wedi chani wamgwile mo ulosi wakwe, na mwe sila iyo wadahe kumlavya mwe mikono ye vilongozi we isi. ");
INSERT INTO ziw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Awo wazuza niyo wamgamba, “Mhinyi, chimanya kugamba walonga na kuhinya mbuli za chindedi, chimanya weye hukupagula, weye wahinya ichindedi chenye che sila ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Elo chigambile hegu ni vyedi hegu sivyo vyedi mwe sigilizi yetu kuliha kodi kwa mkulu ywa Chilumi!” ");
INSERT INTO ziw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu niyo amanya viya wamtegile, niyo awagamba, ");
INSERT INTO ziw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nilagisani ivyo hela iyo ili, nauza iyo isula ne chapa ni yayuhi?” Niyo wamhitula, “Niya Mkulu ywa Chilumi” ");
INSERT INTO ziw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu niyo awagamba, “Elo mwinkeni mkulu ywa Chilumi ivyakwe na Chohile ivyakwe.” ");
INSERT INTO ziw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Elo wadya wantu niyo wadunduga kumgwiza mwe mbuli yoyose, niyo wehelwa hawahitule, niyo wanyamala dwii. ");
INSERT INTO ziw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mna Masadukayo wadya wakugamba wabanike hawakudaha kuyuka, niyo wamhitula Yesu wagamba, ");
INSERT INTO ziw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mhinyi, Musa kachiwandikila vino hegu mntu anabanika kuno kasa mkaziwe heleke wana, vyongigwa mlukolo ywakwe amsole yudya mvyele, chani amwelekele wana yudya mlukolo abanike. ");
INSERT INTO ziw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mna na kuna walukolo mfungate. Ywankongo asolaga mvyele niyo abanika heleke mwana, ");
INSERT INTO ziw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","mlukolo ywa kaidi niyo ampala yudya mvyele naye niyo abanika, ");
INSERT INTO ziw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ywakatatu seivyo vilaile kwa wose mfungate, wose na wabanika heweleke wana. ");
INSERT INTO ziw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Weze wabanike wose yudya mvyele naye niyo abanika. ");
INSERT INTO ziw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nauza mwe dizuwa idyo dyo kuuyuka, mvyele uyo natende mkaza yuhi? Kwaviya na kasolwa ni wose mfungate.” ");
INSERT INTO ziw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu niyo awagamba, “Wantu we mihilimo ino wasola na kusolwa, ");
INSERT INTO ziw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","mna wadya nawafanyanywe kugamba wawagila kuyuswa na kwikala mwe mihilimo ikwiza hawasole hegu kusolwa. ");
INSERT INTO ziw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Naho hawabanike vituhu, kwa viya na watende saviya wandima wa kwembingu, na watende wana Chohile. Kwa viya wauyuka. ");
INSERT INTO ziw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mna mbuli yo kuyuka ni chindedi, hata Musa ailongaga mwa Mawandiko yakwe Yakukile, hadya awandikaga mbuli ya saka dikwaka moto niyo amtaja Zumbe saviya Chohile ywa Bulahimu na Isaka na Yakobo. ");
INSERT INTO ziw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Uyo suyo Chohile ywa wabanike, mna ni Chohile ywa wajima, kwaviya kwa uyo woseni wekala.” ");
INSERT INTO ziw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wahinyi Sigilizi watuhu wagamba, “Mhinyi, kuhitula vyedi vidala!” ");
INSERT INTO ziw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Niyo hawamuzize vituhu. ");
INSERT INTO ziw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu niyo awauza, “Kwa mbwani wantu wagamba Kulisito ni mwana ywa Daudi? ");
INSERT INTO ziw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kwa viya Daudi mwenye nakalonga mwe chitabu chakwe cha zabuli, ‘Zumbe na kamgamba zumbe ywangu. Ikala kwe ntendele ya kulume kwangu. ");
INSERT INTO ziw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kubula aho naniwaike wadya wakukwihiwa enga fumbi dya kwikiya viga vyako.’ ");
INSERT INTO ziw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Elo ni vivihi Daudi akumwitanga Yesu ‘Zumbe’, nivivihi naho, Kulisito adaha kutenda mwelekwa ywa Daudi?” ");
INSERT INTO ziw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesu niyo awagambila wanampina wakwe ahadya ha wantu wose. ");
INSERT INTO ziw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mwedime na wahinya Sigilizi, wakunga kujinka jinka wavika nkazu, wakungisa kulamswa ni wantu kwa kutunywa kwa magwilo, wongisa kwikala hantu na hedi mwe midugano mwa nyumba yo kuvikila na kuguha hantu hedi mwe zingasu, ");
INSERT INTO ziw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wawahoka ugoli wadya wafilwe ni wagosi zawo mwe zi nyumba zawo, na kulombeza malombezo matali chani wawoneke kulongozi kwa wantu. Kwaviya nawakantilwe vitendese!” ");
INSERT INTO ziw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu eze enule meso awawona wagoli waidi wakajela malavyo mwe shanduku mndani mwe nyumba nkulu ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Niyo amona mvyele yumwenga afilwe ni mgosiwe, ajeleka wahela waidi mndani mwe chiya ichiya. ");
INSERT INTO ziw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu niyo agamba, “Nawagambilani chindedi, mvyele yuno afilwe ni mgosiwe kajeleka majeleko makulu mwe ino mpamba kujinka wose. ");
INSERT INTO ziw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwa viya wantu wose walavya malavyo yawo mwe hela ziya zisigale mwe zimbuli zawo. Mna yuno mvyele na uchiwa ananawo kalavya chiya chikunga chimwambize mo wikazi wakwe.” ");
INSERT INTO ziw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mna wanampina watuhu na wakalonga mwe mbuli ze Nyumba nkulu ya Chohile, ivyo ihambigwe kwa mayuwe ya zahabu, hamwenga na majeleko yalavigwe kwa chausa cha Chohile. Mna Yesu niyo agamba, ");
INSERT INTO ziw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Yose mkuyawona sicho chintu, nayeze mazuwa hamuwone hata yuwe dimwenga, mnanga mo mnyawe, chila chintu nachibanangwe.” ");
INSERT INTO ziw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mna niyo wamwuza, “Mhinyi, mbuli izo na zilaile ini? Naho ni chilagiso chani chikunga chilagise mbuli izo zihaguhi kulaila,”? ");
INSERT INTO ziw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu niyo awahitula, “Kaulani, sima mnadantwe. Wantu walozize naweze waketanga zina dyangu, wakagamba, ‘Miye nuyo Kulisito!’ ‘Chipindi chibula!’ Mna nyuwe msekuwatimila. ");
INSERT INTO ziw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mna mkeva mbuli za nkondo na nkunto ze isi msekogoha, ayo yaungwa yakonge kulaila, mna udumo wa yose haunati.” ");
INSERT INTO ziw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Akaheza Yesu niyo ajendeleza kulonga agamba, “Si naitowane na si ntuhu, naho useuta nautowane na useuta. ");
INSERT INTO ziw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Chila hantu na kulaile chisingisa chikulu mwe isi, nakutende na sala na manyonje ya kwinkilizana, na kutenda na mbuli za kutisa na vilagiso vikulu kulaila kwembingu. ");
INSERT INTO ziw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mna nyumani mbuli izo hezinati kulaila, namgwilwe na kusulumizwa, na mwigalwe kwe kukantilwa mwe nyumba zo kuvikila na kuwagwilani, naho namwigalwe kulongozi kwa maseuta na wakulu kwa chausa che dizina dyangu. ");
INSERT INTO ziw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ivyo namlavye ukuzi wangu kulongozi kwawo. ");
INSERT INTO ziw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mna mwekambe mndani mwe myoyo kugamba ivyo mkunga mweile hemnati kulahwa. ");
INSERT INTO ziw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kwa viya naniwenke mbuli zedi zo kulonga zikunga zileke wakuweihiwa hawadahe kulemela hegu kuhigana na nyuwe. ");
INSERT INTO ziw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Welesi wenyu, walukolo wenyu na wambuya zenyu nawawalemele, na watuhu na mkomwe. ");
INSERT INTO ziw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wantu wose nawawaihiwe kwa chausa cha zina dyangu. ");
INSERT INTO ziw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mna hata luvili lumwenga mwe mitwi yenyu halwage. ");
INSERT INTO ziw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwa viya yo uijimizi mnanawo, wikazi wenyu hawage. ");
INSERT INTO ziw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Chipindi namuwone umzi wa Yelusalemu uzungulukwa ni wankondo, aho manyani kugamba kubalangwa kwakwe kwihaguhi. ");
INSERT INTO ziw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aho wadya nawatende Yudeya wagulukile kwe milima, wadya we komzi wafose, na wadya wekwe zinkonde wasekuya komzi wa Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwa viya mazuwa ayo ‘Na yatende ya nkunto’, chani yadya yose yawandikwe mwa Mawandiko Yakukile yachinte. ");
INSERT INTO ziw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wavyele wasoka na wakonkeza nawaluwone mwa mazuwa ayo! Kwa viya nakutende na nkunto nkulu mwe isi na maya ya Chohile nayawagwele wantu wano. ");
INSERT INTO ziw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Watuhu nawakomwe kwa mabamba, watuhu na waguhigwe mateka kulaila mwe chila si na mzi wa Yelusalemu na uguhigwe ni wantu wa si ntuhu kubula chipindi chawo chize chisile. ");
INSERT INTO ziw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nakutende na vilagiso mwedizuwa na mo mnenge na mwezintondo. Mwe zisi zose nazitende na nkunto wantu na welelwe kulawana na mawimbi makulu kwe bahali. ");
INSERT INTO ziw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wantu na wafe kififimbazi kwa chausa cha woga wakagoja mbuli zikunga zilaile mwe isi yose, kwaviya vyose vina nguvu kwembingu navisingiswe. ");
INSERT INTO ziw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nawamwone mwana ywa Adamu akasela mwa maingu kulaila kwa Chohile, kamema nguvu na ukuka. ");
INSERT INTO ziw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Umo izimbuli izo zikakonga kulaila, chimalani niyo mwenule mitwi yenyu kulanga kwa viya ukombolwa wenyu wihaguhi.” ");
INSERT INTO ziw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu niyo awagambila mligano ukugamba, kaulani ivyo wili mtini na miti mituhu yose. ");
INSERT INTO ziw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mkawona kugamba mani yo mtini yakonga kusuka bunkulani wenye kugamba chipindi cha zuwa kali chihaguhi. ");
INSERT INTO ziw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Saivyo, mneza kuwona mbuli izo zikalaila mmanye kugamba Useuta wa Chohile wihaguhi. ");
INSERT INTO ziw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nawagambilani chindedi, cheleko chino cha haluse hachijinke, izimbuli izo zose hazinati kulaila. ");
INSERT INTO ziw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mbingu ne isi vyose na vijinke, mna ulosi wangu haujinke. ");
INSERT INTO ziw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mkaulise myoyo yenyu inase kuzamilwa ni mbuli zimwe isi ino, saviya ukozi na kutumbwazikila wikazi, mkaulise kwa viya zuwa idyo nadiwezile kwa kuwetukizani. ");
INSERT INTO ziw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwaviya zuwa idyo na diwezile saviya mtego ukufyuka kwa wose wakwikala mwe isi. ");
INSERT INTO ziw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Elo, nagamba mcheleze mkalombeza chila zuwa chani mwinkwe nguvu za kwenega mbuli zose izo nazilaile nanywi mchimale kulongozi kwa Mwana ywa Mntu.” ");
INSERT INTO ziw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu nomsi nakekala mwe Nyumba nkulu ya Chohile akahinya, nechilo nakaita kugona ko lugulu lwe Mizeituni. ");
INSERT INTO ziw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mtondo wantu wose nawakaita kwe Nyumba nkulu ya Chohile chani wakamwetegeleze. ");
INSERT INTO ziw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Zuwa kulu dye migate heijeligwe hamila, ikwitagwa Pasaka nadisogela. ");
INSERT INTO ziw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Walavyantambiko wakulu na wahinya sigilizi nawakalonda mbuli ya kumkoma Yesu mna nawakogoha wantu. ");
INSERT INTO ziw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Shetani amwingila Yuda akwitangwa Isikaliyote, yumwenga mgati mwa wadya wasigilwa mlongo na waidi wa Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda aita akulonga na Walavyantambiko wakulu na wadya wadimi we nyumba nkulu yo kuvikila, ivyo akunga amhituke Yesu chani wamgwile. ");
INSERT INTO ziw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Niyo welelwa wamgamba nawamwinke hela anadamanya ivyo. ");
INSERT INTO ziw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda azumila, niyo akonga kulonda hantu hedi hakumhituka Yesu chani wamgwile, mna wantu wasekumanya. ");
INSERT INTO ziw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Niyo dyabula zuwa dya migate heijeligwe hamila, zuwa idyo nidyo idizuwa dyo ukuchinjwa mwanangoto we Pasaka. ");
INSERT INTO ziw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ivyo Yesu awasigila Petulo na Yohana awagamba, Hitani mkachikiye vintu vye ngasu chani chidahe kudya Pasaka. ");
INSERT INTO ziw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mna niyo wamuza, “Waunga chikaikiye kuhi?” ");
INSERT INTO ziw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu awahitula, Tegelezani umo mkaita ko mzi namdugane na mgosi ketwika biga dya mazi, mtimileni kubula aho he nyumba akunga engile. ");
INSERT INTO ziw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mgambileni mta inyumba iyo mhinyi akuza chikuhi icho ichumba hunga nidile Pasaka hamwenga na wanampina wangu? ");
INSERT INTO ziw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naye nawenkeni chumba chikulu cha kulanga chihambigwe vyedi, ikani umo ivintu. ");
INSERT INTO ziw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Niyo waita wabwila saviya wagambilwe ni Yesu, niyo waika ivintu vye ingasu ye dizuwa dye Pasaka. ");
INSERT INTO ziw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ichipindi chize chibule Yesu niyo ekala adye inkande hamwenga na wasigilwa wakwe. ");
INSERT INTO ziw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesu niyo awagamba, siungisa chidye hamwenga mwe ingasu ino ye dizuwa dye Pasaka umo sinati kusulumizwa. ");
INSERT INTO ziw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nawagambilani ichindedi sanidye vituhu kubula ize idamanyike mwe idizuwa idyo dyo useuta wa Chohile hadinati kubula. ");
INSERT INTO ziw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Niyo achiguha ichikombe amtogola Chohile agamba, “Guhani chino ichikombe mhokelezane kunywa. ");
INSERT INTO ziw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nawagambilani chindedi kukongela haluse saninywe naho divai ino ikudamanywa na zabibu, kubula Useuta wa Chohile nawizile.” ");
INSERT INTO ziw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Niyo aguha umgate, amtogola Chohile niyo aubesula, awenka, awagamba, uno nuwo umwili wangu, ukulavigwa kwa chausa cha nyuwe, mdamanye savino chani mnikumbuke chila mkadamanya. ");
INSERT INTO ziw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Niyo adamanya saivyo ne ichikombe nacho, weze wabinde ukudya, niyo agamba, chikombe chino ni lagano hya dya Chohile dikuukulwa kwa sila ya sakame yangu, ikwitika kwachausa cha nyuwe. ");
INSERT INTO ziw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mna kaulani yudya akunga anihituke ehano he meza. ");
INSERT INTO ziw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chindedi Mwana ywa mntu aita akukomwa saviya vikigwe, mna hangi mwenye yudya mntu akunga amhituke. ");
INSERT INTO ziw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ahadya niyo wakonga kuuzana wo wenye ni yuhi akunga amhituke Zumbe ywawo. ");
INSERT INTO ziw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wadya wasigilwa niyo wakonga kuhigana wo wenye ni yuhi mgati mwetu akunga atende chilongozi mwa weyawe. ");
INSERT INTO ziw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu niyo awagamba, “Maseuta wa si ntuhu wawalongoza wantu wawo kwa nguvu, na wadya wakulongoza ‘Wakwetanga wambuya wachila mntu’. ");
INSERT INTO ziw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mna visekutenda ivyo mwenyu mna yudya akunga atende mkulu mwenyu aungwa atende mdodo kujinka wose akunga atende chilongozi aungwa atende mndima. ");
INSERT INTO ziw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nauza mkulu ni yuhi ni yudya akwikala mwe meza akagoja nkande hegu ni yudya akumwigaila? Nafanyanya ni yudya ekale he meza akagoja inkande hegu miye sikala hano enga mndima ywenyu. ");
INSERT INTO ziw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nyuwe namwihamwenga na miye umo hasulumila. ");
INSERT INTO ziw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Saviya Tate aninkile Useuta saivyo miye nami naniwenkeni nyuwe Useuta. ");
INSERT INTO ziw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nidye na kunywa he meza yangu mwe useuta wangu naho namwikale mwe vigoda vyenyu vyo useuta mkayakantila makabila mlongo na maidi ya izulaeli. ");
INSERT INTO ziw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoni, Simoni! Tegeleza! Shetani kalekelwa chipindi cha kuwajezani nyuwe, saviya mntu akuheta ngano. ");
INSERT INTO ziw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mna miye sikulombezeza kwa Chohile chani uzumizi unanawo usekuhunguka naunihituke mna unauya uwajele moyo walukolo wako.” ");
INSERT INTO ziw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petulo niyo amhitula amgamba, “Zumbe, miye semalanya kale nite na weye kwedigeleza hata habanika sina mbuli.” ");
INSERT INTO ziw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu amhitula, “Nakugambila, Petulo,” “Zogolo hadinati kwila neichilo naunilemele nkanana ntatu kugamba hunimanyize.” ");
INSERT INTO ziw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu niyo awauza wanampina wakwe “Umo nawasigilagani msekutoza hela hegu mkwiji hegu vilatu mwahungukilagwa ni chibwani?” Niyo wamhitula. “Bule,” ");
INSERT INTO ziw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu awagamba mna yudya mta mkwiji wa hela naguhe, mta mkwiji we vintu naye naguhe. Seivyo hene bamba natage isuche yakwe chani agule. ");
INSERT INTO ziw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nawagambila imbuli ino ya mawandiko yano Yakukile yekigwa hamwenga na wata ubanasi yongigwa yadamanywe. Yadya hungigwa nidamanye yehaguhi kubula ");
INSERT INTO ziw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wanampina wakwe niyo wamgamba, “Zumbe, kaula hano!” Yesu niyo awahitula, “Vichinta!”. ");
INSERT INTO ziw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu niyo ahalawa enga viya nakadamanya niyo aita ko lugulu we imizaituni mna wanampina wakwe niyo wambasa. ");
INSERT INTO ziw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Eze abule uko niyo awagamba mkalombeza sima mwingile mwe majezo. ");
INSERT INTO ziw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Niyo awasa aita hale hadodo utali wa mntu akudula yuwe hadya dikugwela. Niyo afika madi alombeza. ");
INSERT INTO ziw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tate,” uneva hegu ukaunga, unusize chikombe cha masulumizo. Mna visekutenda viya hunga miye, mna “Ivyo ukunga navitendeke.” ");
INSERT INTO ziw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aho mndima ywa kwembingu kulaila kwa Chohile niyo eza amjela moyo. ");
INSERT INTO ziw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Umo emwe masulumizo makulu niyo ajendeleza kulombeza niyo alawa chiluke saviya madwentwe ya sakame niyo yajuluzika kubula hasi. ");
INSERT INTO ziw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Eze abinde ukulombeza niyo auya hadya hantu awasize wanampina wakwe niyo awambwila wagona, kwaviya nawana chinyulu. ");
INSERT INTO ziw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Niyo awagamba kwambwani mgona? Inukani mlombeze chani msekwingila mwe majezo. ");
INSERT INTO ziw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Umo hanati kubinda ukulonga fyo dya wantu niyo dyeza dikalongozwa ni Yuda yumwenga mwe wadya wasigilwa mlongo na waidi, Yuda niyo ambasa Yesu chani amlamse kwa kumsesa. ");
INSERT INTO ziw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mna Yesu niyo amgamba vino Yuda, wamhituka Mwana ywa mntu kwa kumsesa? ");
INSERT INTO ziw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wadya wanampina wakwe weze wawone izimbuli zikudamanywa, niyo wagamba Zumbe chiwasenge mabamba? ");
INSERT INTO ziw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yumwenga mwe wadya wanampina niyo amsenga bamba mndima ywa Mlavyantambiko Mkulu, niyo amsenga idigutwi dyakwe dya kulume ");
INSERT INTO ziw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aho Yesu niyo amgamba, leka, “Vyachinta!” Niyo adonta idigutwi dya yudya mntu na kumhonya. ");
INSERT INTO ziw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu niyo awagamba wadya Walavyantambiko wakulu, wadalahala wa wadimi we nyumba nkulu ya Chohile na wantu wakulu wose wezile kumgwila vino mwiza mtoza mabamba na makome mwiza kunigwila enga miye ni mbavi? ");
INSERT INTO ziw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Umo nanihamwenga na nyuwe mwe nyumba nkulu ya Chohile kwa chila zuwa hamnigwile mna chindedi chino nicho ichipindi chenyu, chino nicho chipindi cho udahi wa shetani. ");
INSERT INTO ziw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Niyo wamgwila wamguha wamwigala kubula kwe inyumba ya Mlavyantambiko mkulu mna Petulo nakamtimila Yesu kwa kunyuma luhalehale. ");
INSERT INTO ziw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Moto naujimbwa hagati ho uwa wo mdugano wose nawekala hamwenga, Petulo naye nehadya. ");
INSERT INTO ziw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mndima yumwenga mvyele eze amwone Petulo kekala haguhi ho moto, niyo amng'oila meso amgamba, Yuno mntu nehamwenga na Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mna Petulo niyo alemela agamba, We mvyele miye simmanyize. ");
INSERT INTO ziw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Chize chijinke chipindi chidodo mntu mtuhu niyo amwona Petulo amgamba, Weye wiyumo mwe wano wagwiligwe, Mna Petulo niyo amhitula amgamba we mbwawe suyo miye. ");
INSERT INTO ziw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Enga saa dimwinga dijinkile mntu yumwenga niyo eza kumvilikiza chindedi yuno ne ehamwenga na Yesu, hambwe kalaila Galilaya. ");
INSERT INTO ziw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mna Petulo niyo amgamba, we mbwawe simanyize icho ukulonga, Ahadya umo achekulonga zogolo niyo dyaila. ");
INSERT INTO ziw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Zumbe Yesu niyo ahituka na kumsinya Petulo, ahadya Petulo niyo akumbuka yadya agambilwe ni Zumbe, dyelo zogolo hadinati kwila naunihituke nkanana ntatu. ");
INSERT INTO ziw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aho Petulo niyo afosa kweise, na kwila vidala. ");
INSERT INTO ziw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wadya wantu nawakamdima Yesu niyo wamtila nakumtowa. ");
INSERT INTO ziw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wamgubiga ameso niyo wamuza, “Akutoile ni yuhi? Hebu bunkula chikaule?” ");
INSERT INTO ziw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Niyo wamhuluta vidala. ");
INSERT INTO ziw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kwize kuche, wakulu wo mzi na wantu niyo wekala chitala, Wahinya Sigilizi na walavyantambiko wakulu naweyumo mwe icho chitala, Yesu niyo egalwa he chitala. ");
INSERT INTO ziw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Niyo wamuza, “Chigambile,” “Weye nuyo masiya?” Kulisito niyo awagamba, “Uneva nina wagambilani, nyuwe hamnizumile, ");
INSERT INTO ziw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","naho hegu ninawauzani hamnihitule. ");
INSERT INTO ziw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mna kukongela vino haluse Mwana ywa Mntu nekale haguhi na Chohile Mta nguvu.” ");
INSERT INTO ziw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wose niyo wamuza, “Elo, chigambile weye nuyo Mwana ywa Chohile?” Yesu niyo awagamba, “Nyuwe mlonga mwagamba miye nuyo.” ");
INSERT INTO ziw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Niyo wagamba, “Hachikunga ukuzi mtuhu mwakwe! Suwe wenye chimwiva ivyo alongile!” ");
INSERT INTO ziw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Akaheza wantu wose niyo wachimala, wamwigala Yesu kulongozi kwa Pilato, ");
INSERT INTO ziw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wakonga kumlongeleza wakagamba, “Yuno mntu nachimbwila akawadanta wantu wose, walemele kuliha kodi kwa Seuta ywa Lumi na kwetanga hambwe nuyo Kulisito, Seuta.” ");
INSERT INTO ziw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato amuza Yesu, “Weye wi seuta ywa Wayahudi?” Yesu amhitula. “Niweye ukulonga,” ");
INSERT INTO ziw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Akaheza Pilato awagamba walavyantambiko wakulu hamwenga ne difyo dya wantu, “miye sikuwona wavu wowose wakumkantila yuno mntu.” ");
INSERT INTO ziw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mna wowo walahiliza wakagamba, “Kwa sila ya mahinyo yakwe awaluvya wantu wadamanye wavu mwe isi yose ya Yudeya. Kakongela Galilaya haluse kubula hano.” ");
INSERT INTO ziw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato eze eve ayo, niyo auza, “Vino mntu yuno ni mkaya wa Galilaya?” ");
INSERT INTO ziw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Eze amanye kugamba Yesu ne mo mkowa ukulongozwa ni Helode, niyo amwigala kwa Helode, kwaviya Helode naye nendile eyuko Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode eze amwone Yesu niyo eleleswa, kwaviya nakeva kale izimbuli zakwe, ivyo nakamgoja kwa chipindi chitali. Nana msuhi amwone Yesu akadamanya vilagiso. ");
INSERT INTO ziw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ivyo niyo amuzisa, mna Yesu hahitule dyodyose. ");
INSERT INTO ziw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Walavyantambiko wakulu na wahinya Sigilizi wendaga aho walavyaga malaho makulu mwa Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ivyo Helode hamwenga na wankondo wakwe wambasa Yesu na kumjela soni, niyo wamvisa suche zikale za chiseuta na kumvuza kwa Pilato. ");
INSERT INTO ziw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mwe dizuwa diya Helode na Pilato wendaga hawekwivana, mna kukongela dizuwa idyo niyo watenda wambuya. ");
INSERT INTO ziw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ivyo Pilato niyo etanga chitala cha wakulu wa walavyantambiko, vilongozi, na wantu wawo, ");
INSERT INTO ziw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","awagamba, mnigaila mntu yuno mwagamba nakawadanta wantu. Haluse tegelezani, nize nimuze imbuli iyo mwa meso yenyu simuwone na lema dyodyose mwa ayo mkumlaha. ");
INSERT INTO ziw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Naho Helode hamwone lema dyodyose, nivyo vilekile kamvuza kwetu. Mntu yuno hadamanye dyodyose dikuleka ankantilwe kukomwa. ");
INSERT INTO ziw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","“Ivyo nanilagize atoigwe nkome niyo namlekela.” ");
INSERT INTO ziw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Chila zuwa dya Pasaka Pilato na kaungwa alekele mfungwa yumwenga. ");
INSERT INTO ziw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mna wose hamwenga watula lwasu, “Muse yuno mntu! Chifungwile Balaba!” ");
INSERT INTO ziw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba nakajelwa mndani kwa wavu wa nkumbizi mwe kaya, naho nakakoma wantu. ");
INSERT INTO ziw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato nakaunga amlekele Yesu, ivyo niyo alonga nawo vituhu. ");
INSERT INTO ziw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mna wowo niyo watula lwasu vituhu, “Mtungike! Mtungike!” ");
INSERT INTO ziw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato awagamba nkanana ya katatu, “Kabalangani? Sikuwona ubanasi wowose mwakwe vikuleka akomwe! Nanilagize atoigwe nkome vikaheza nimlekele.” ");
INSERT INTO ziw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mna wowo wajendeleza kutula lwasu vidala kugamba Yesu aunngwa atungikwe mo msalaba, na mo udumo wo lwasu lwawo niyo wahudwa. ");
INSERT INTO ziw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ivyo Pilato kamkantila Yesu saviya nendile wakaunga. ");
INSERT INTO ziw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Amvugwila kulaila kwedijeleza yudya waungile, yudya ajeligwe kwedijeleza kwa wavu wa nkumbizi na kukoma wantu, amwinkiza Yesu kwawo wamdamanye ivyo wakunga. ");
INSERT INTO ziw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Umo wakamwigala ko kumtungika mwe sila, wadugana na mntu yumwenga akwitagwa Simoni wa si ya Kilene endaga akalaila kwe kaya zihaguhi. Wamchimalisa, wamkankalisa etwike msalaba wa Yesu, na kumtimila mnyuma. ");
INSERT INTO ziw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Fyo kulu dya wantu dimtimila, mgati mwawo namna wavyele nawakalomboleza na kwila. ");
INSERT INTO ziw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu awahitukila awagamba, “Nyuwe wavyele wa Yelusalemu! Msekuniila miye, mna kweileni nyuwe wenye na wana wenyu. ");
INSERT INTO ziw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwaviya mazuwa nayeze aho wantu wakunga walonge, ‘Chinyemi china wadya hewakweleka, wadya hawajezaga kweleka hegu konkeza!’ ");
INSERT INTO ziw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chipindi icho wantu nawakonge kuyagamba magulu, ‘Chigweleni!’ Na wagulu, ‘Chigubikeni!’ ");
INSERT INTO ziw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwaviya uneva wantu wautendela mti mbisi seivyo, naitende zeze kwa mti unyaile?” ");
INSERT INTO ziw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kwendaga na wantu watuhu waidi, wendaga weihiye, wegalagwa hamwenga na Yesu ko kutundikwa. ");
INSERT INTO ziw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Weze wabule hantu hakwitangwa, “Gobela dya mtwi”, niyo wamtungika Yesu mo msalaba, na hamwenga na wadya wabanasi waidi, yumwenga ntendelo ya kulume yumwenga kumoso kwakwe. ");
INSERT INTO ziw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Akaheza Yesu agamba, “Walekeile, Tate kwaviya hawamanyize diya wakudamanya.” Niyo wapangana izisuche za Yesu kwa kuzitoila tegatega. ");
INSERT INTO ziw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wantu nawachimala hadya wakakaula kuno vilongozi wa Wayahudi wakamtila wakagamba, “Ambulaga wantu watuhu, haluse neambule mwenye hegu nuyo Kulisito yudya asagulwe ni Chohile!” ");
INSERT INTO ziw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wankondo nawo niyo wamtila, wamwigaila divai igwaduke, ");
INSERT INTO ziw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na kumgamba, “Kweambule mwenye hegu weye wi seuta ywa Wayahudi!” ");
INSERT INTO ziw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ulahi na uwandikwa savino kulanga kwakwe, “Yuno nuyo Seuta ywa Wayahudi.” ");
INSERT INTO ziw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yumwenga mwa wadya wabanasi atundikwe mo msalaba amhuluta, akamgamba, “Weye hwi Kulisito? Elo kweambule mwenye ukaheza uchambule naswi!” ");
INSERT INTO ziw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mna yudya mnyawe niyo amkwahila, amgamba, “Weye hukumogoha Chohile? Hata hegu waungwa uhokele kanto seiyo. ");
INSERT INTO ziw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Suwe, ivyovili, vyachiwagila, kwaviya chongigwa chinkigwe kanto kwa yadya chidamanye, mna yuno mntu hana icho abalange.” ");
INSERT INTO ziw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Niyo amgamba Yesu, “Unikumbuke, Yesu, mo Useuta wako!” ");
INSERT INTO ziw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu niyo amhitula amgamba, “Chindedi dyelo dino nautende hamwenga nami hantu hahoile.” ");
INSERT INTO ziw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yendaga saa mtandatu vino no msi, umo zuwa dilekile kulangaza isi, niyo kwatenda na chiza kubula saa chenda. ");
INSERT INTO ziw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Paziya dyendile ditungikwa mwe Nyumba ya Chohile ditatuka vihande vidi. ");
INSERT INTO ziw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu niyo aguta kwa izwi kulu, “Tate! Mwe mikono yako naika muye wangu!” Kalonga vino nakubanika. ");
INSERT INTO ziw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yudya mnkondo kawona chiya chilaile, niyo amtunya Chohile, akagamba, “Chindedi nani mntu ywedi!” ");
INSERT INTO ziw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Umo fyo dya wantu nawadugane hadya kukaula yose yalaile, wose niyo wauya kukaya, waketowa mwe vifuwa vyawo kwa chinyulu. ");
INSERT INTO ziw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wadya wantu woseni wammanyaga Yesu, hamwenga na wadya wavyele wamtimilaga kulaila Galilaya, wachimala kwa hale wakakaula. ");
INSERT INTO ziw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kwendaga na mntu yumwenga akwitangwa Yusufu, mwelekwa ywa mzi umwenga wa Wayahudi ukwitangwa Alimataya. Endaga mntu ywedi akutunyiswa. ");
INSERT INTO ziw_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nendile akagoja kwiza kwa useuta wa Chohile. Hata hegu endaga yumwenga mwe Chitala Chikulu cha Wayahudi, endaga hevanaga nawo mwe ntendwa yawe. ");
INSERT INTO ziw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yusufu aitaga kwa Pilato nakulombeza mwili wa Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Niyo auseleza umwili hasi, auvisa sanda, nakuwika mwe mbila yadamanyagwa mwe luwe naho hayadamanyaga ndima. ");
INSERT INTO ziw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dyendaga zuwa dya kuhumula nadyo dihajihi nakukonga. ");
INSERT INTO ziw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wadya wavyele wezaga na Yesu kulaila Galilaya wamtimila Yusufu nakuwona imbila na ivyo mwili wa Yesu nauhambwe umo. ");
INSERT INTO ziw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Niyo wauya kukaya kudamanya malihamu na mavuta yakupwepweleka wauhake umwili. Wahumula mwe Zuwa dya kuhumula, saviya Sigilizi ikunga. ");
INSERT INTO ziw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Zuwa dya kuhumula dya nkongo dya juma chilo chilo wadya wavyele niyo waita kwembila, nawenula yadya mavuta wadamanye. ");
INSERT INTO ziw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wadya wavyele mo kulomboleza wabwila diya diyuwe difingiliswa hale ne mbila. ");
INSERT INTO ziw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mna weze wengile mndani mwe mbila hawauwone umwili wa Zumbe Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Umo wachei kwehelwa mwe mbuli iyo, niyo walaila wantu waidi wavaile suche zing'alise wachimala haguhi na wowo. ");
INSERT INTO ziw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wadya wavyele niyo wengilwa ni woga na kwinama chifudifudi kubula hasi. Wadya wantu wawagamba, “Kwambwani mwamlonda mntu mjima mwe wantu wabanike? ");
INSERT INTO ziw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hahali hano kauyuka, kumbukani ivyo awagambilagani viya achei Galilaya. ");
INSERT INTO ziw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Yongigwa mwana ywa mntu alavigwe mwe wantu wata masa na kusulumizwa na kuyuka zuwa dya katatu.’ ” ");
INSERT INTO ziw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aho wadya wavyele niyo wakumbuka ulosi wakwe. ");
INSERT INTO ziw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Weze wauye kulaila kwe mbila, niyo wawagambila mbuli zose wadya wasigilwa mlongo na yumwe na wadya nawakamtimila Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Awo walongile izimbuli kwa wasigilwa ni Maliyamu Magidalena, Yona, na Maliyamu nine dya Yakobo, hamwenga na wadya wavyele wendile wehamwenga. ");
INSERT INTO ziw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Awo nawo niyo wawagambile wasigilwa mbuli izo. Wasigilwa hawatolotoze imbuli iyo, niyo hawaizumile. ");
INSERT INTO ziw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mna Petulo niyo afosa aguluka kubula kwembila, eze afuname nakusungila mndani mwakwe aona sanda iyodu. Niyo auya kukaya kuno kehelwa ni mbuli izo zilaile. ");
INSERT INTO ziw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mwe diziwa idyo, wantu waidi mgati mwa wanampina wakwe na wakaita mwe kaya imwenga ikwitagwa Emau, kaya iyo ihale no mzi wa Yelusalemu enga lujendo lwa masa maidi. ");
INSERT INTO ziw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nawakatamwila wenye mwe mbuli zose zilaile. ");
INSERT INTO ziw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Umo nawakatamwila na kuzana wowo wenye, Yesu mwenye niyo alaila alongozana nawo. ");
INSERT INTO ziw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nawamona kwa meso mna hawammanyize kugamba ni Yesu. ");
INSERT INTO ziw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu awauza, “Mwatamwila mbuli zani hano he sila?” Wowo niyo wachimala, kuno wana chihovu. ");
INSERT INTO ziw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yumwenga akwitangwa Kilopa, amhitula agamba, “Weye ichedu wi mjeni mo mzi uno wa Yelusalemu, vitende humanjize mbuli zilaila mwa mazuwa yano?” ");
INSERT INTO ziw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu awauza, kulaila mbwani? Wamhitula, mbuli za Yesu ywa Nazaleti, yudya nani muwoni, mta udahi wa kudamanya na kulonga ko uso wa Chohile na wantu wose. ");
INSERT INTO ziw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wakulu wa walavyantambiko hamwenga na vilongozi wetu wamlavya chani akantilwe file, niyo wamsulumiza mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mna suwe nachina msuhi kugamba uyo nuyo akunga aikombole Izulaeli, elo dyelo ni zuwa dya katatu kukongela hadya izimbuli izo zilaile. ");
INSERT INTO ziw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ukaleka ayo wavyele watuhu mwe bunga dyetu wachitusa, nawaita chilochilo kwembila. ");
INSERT INTO ziw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Hawaubwile umwili wakwe, wauya na kugamba walailwa ni wandima wa kwembingu niyo wawagambila kugamba ni mjima. ");
INSERT INTO ziw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wetu watuhu nawaita kwe mbila wawona ivyo walongile wadya wavyele, mna yeye hawamuwone. ");
INSERT INTO ziw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Niyo Yesu awagamba, “Nyuwe wahezi na wata myoyo midala ya kuzumila mbuli zose za wawoni walongile! ");
INSERT INTO ziw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Elo havyungigwe Kulisito asulumizwe akaheza engile mwe ukuka wakwe?” ");
INSERT INTO ziw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Niyo awagambila mbuli zose ziwandikwe mwa Mawandiko Yakukile, kukongela muwoni Musa kubula wose. ");
INSERT INTO ziw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Weze wabule hajihi ne idya ikaya nawakaita, Yesu enga ajendeleza ne ntambo awasa. ");
INSERT INTO ziw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mna wowo wamlombeza wamgamba, usekwita kwaviya zuwa diswa chilo chengila. Ivyo engila he ikaya na kwikala nawo. ");
INSERT INTO ziw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Eze ekale na kudya nkande hamwenga nawo, aguha mgate aujimbika, aubesula awenka. ");
INSERT INTO ziw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ahadya meso yawo niyo yagubulwa, wambunkula kugamba ni Yesu, mna ahadya niyo ahalawa kuno wakasinya. ");
INSERT INTO ziw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Niyo wagambilana togolani “Myoyo yetu haisangale vidala umo akatamwila na suwe mwe sila na kuchigambila Mawandiko Yakukile?” ");
INSERT INTO ziw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Niyo wahalawa isa idya, niyo wabula Yelusalemu niyo wawabwila wadya mlongo na yumwe wadugana hamwenga na wantu watuhu we dibunga dyawo. ");
INSERT INTO ziw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Wakalonga, Zumbe kauyuka chindedi, naye kamlaila Simoni. ");
INSERT INTO ziw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niyo wawagambila mbuli zose mbuli zose zilaile mwe sila neivyo wambunkule Yesu umo akabesula umgate. ");
INSERT INTO ziw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Umo nawakawagambila ayo, Yesu mwenye alaila achimala hagati hawo, awagamba, Mtende na utondowazi. ");
INSERT INTO ziw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wasetuka na kwingilwa ni woga, nawamanya wawona mpepo. ");
INSERT INTO ziw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mna yeye awagamba, kwambwani mnankama? Kwambwani mwatenda na nkama mwe myoyo yenyu? ");
INSERT INTO ziw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kaulani imikono ne viga vyangu, chani mmanye ni miye, nitozanitozani muwone, kwa viya mpepo haina mwili na mavuha enga vino mkuniwona. ");
INSERT INTO ziw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eze alonge iyo, awalagisa imikono yakwe ne viga vyakwe. ");
INSERT INTO ziw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Umo hawenati kuzumila kwa chinyemi wananacho kuno wakehelwa, awauza, hano mna nkande yoyose? ");
INSERT INTO ziw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Niyo wamwinka chihande cha samaki yokigwe. ");
INSERT INTO ziw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aiguha, aidya kuno wose wakamsinya. ");
INSERT INTO ziw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Niyo awagamba, “Uno nuwo ulosi nahawagambilani umo nendaga nichei hamwenga na nyuwe, kugamba vyaungwa nichintize mbuli zose niwandikilwe mwe Sigilizi ya Musa, na mwamawandiko ya wawoni na Zabuli.” ");
INSERT INTO ziw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Niyo agubula fanyanyi zawo chani wamanye Mawandiko Yakukile, ");
INSERT INTO ziw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","awagamba, “Ivyo nivyo viwandikwe kugamba Kulisito nasulumizwe zuwa dya katatu nauyuke. ");
INSERT INTO ziw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Naho kugamba kwa zina dyakwe wantu wose kukongela Yelusalemu nawagambilwe Mbuli Yedi weile chani walekeilwe masa yawo. ");
INSERT INTO ziw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nyuwe namtende waukuzi wangu mwe mbuli zino. ");
INSERT INTO ziw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Miye mwenye naniwegaileni yudya Tate ekiye ndagano kugamba namsigile kwenyu, mna ikalani muno mo mzi kubula mwinkigwe idya nguvu ikulaila kulanga.” ");
INSERT INTO ziw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Niyo awalongoza kubula Besaniya, enula imikono yakwe awajimbika. ");
INSERT INTO ziw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Umo akawajimbika, awasa, aguhigwa kulanga kwembingu. ");
INSERT INTO ziw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wamvikila, niyo wauya Yelusalemu kuno wana chinyemi vidala. ");
INSERT INTO ziw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nawo nawakekala kwe nyumba nkulu ya Chohile chila zuwa, wakamjimbika Chohile.");
INSERT INTO ziw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aho nkongo hendaga na mntu akwitangwa Ulosi, Ulosi uyo endaga na Chohile, naye endaga Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kukongela nkongo Ulosi endaga hamwenga na Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Chila chintu chaumbwaga kombokela uyo, hendile uyo, Chohile haumbile chintu chochose. ");
INSERT INTO ziw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Uyo endaga nkongelo ya ujima, na ujima uwo wendaga ulangazi wa wantu. ");
INSERT INTO ziw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ulangazi uwo walangaza mwe chiza, mna ichiza nacho chidunduga kuudaha. ");
INSERT INTO ziw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Chohile amsigilaga msigilwa yumwenga zina dyakwe Yohana, ");
INSERT INTO ziw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","yudya ezaga kuwagambila wantu watimile ulangazi uwo. Ezaga chani wantu wose weve na kuzumila ulosi wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana hendaga uwo ulangazi, mna ezaga du kuwaukuila wantu mbuli yo ulangazi uwo. ");
INSERT INTO ziw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Uno nuwo ulangazi we chindedi, ulangazi ukwiza mwe isi na kuwamulikila wantu wose. ");
INSERT INTO ziw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ivyo Ulosi uyo endaga uko kwe isi. Hata kugamba Chohile aumbaga isi kombokela uyo wantu woseni we isi hawamzumile. ");
INSERT INTO ziw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ezaga mwe isi yakwe mwenye, mna wendile wakwe hawamhokele. ");
INSERT INTO ziw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mna wantu wamwenga wamhokela na kumzumila, ivyo awenka udahi wa kuwoneka wedi kulongozi kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hawatendile wana wa Chohile kwa fanyanyi za chimntu mna nguvu za chimwili, mna kwa udahi wa Chohile mwenye. ");
INSERT INTO ziw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Naye Ulosi niyo etenda mntu, ekala kwetu, suwe naswi chiuwona ukuka wakwe, ukuka wakwe uyo endile Mwana ichedu ywa Tate, kamema mbazi na chindedi. ");
INSERT INTO ziw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana awaukwilaga wantu mbuli zakwe, akaguta, “Uyo nuyo nilongile hadya nalongaga, ‘Eza mntu yumwenga anomboke miye, uyo ni mkulu kujinka miye, kwaviya endaga uko sinati kwelekwa.’ ” ");
INSERT INTO ziw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mo ujejeje we izimbazi zakwe zose, suwe chose chihokela mazi kujinka mbazi. ");
INSERT INTO ziw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kwaviya Chohile kalavya Sigilizi kwombokela Musa, mna Yesu Kulisito kegala mbazi na chindedi. ");
INSERT INTO ziw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hahali mntu amuwone Chohile chipindi chochose mna Mwana ichedu, aligane na Chohile, yudya alungane na Tate, nuyo amtendile chimmanye Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Uno nuwo ukuzi Yohana aukule mwe Vilongozi wa Chiyahudi uko Yelusalemu wawasigila walavyantambiko na Walawi wamuze, “Weye wiyuhi?” ");
INSERT INTO ziw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana halemele kuwahitula, niyo alonga pwipwipwi, “Miye suyo Kulisito Mkombola.” ");
INSERT INTO ziw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aho niyo wamuza, “Haluse weye wi yuhi? Togola, weye ni Eliya?” Yohana niyo ahitula, “Bule! Miye suyo.” Wamuza, “Togola, weye ni yudya muwoni?” Yohana awahitula, “Bule!” ");
INSERT INTO ziw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wowo wamuza, “Haluse weye niweye yuhi? Wegaze we mwenye? Chigambile chani chikawagambile wadya wachisigile.” ");
INSERT INTO ziw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana awahitula, “Miye ni yudya muwoni Isaya alongaga izimbuli zakwe kugamba, ‘Izwi dya mntu dikwivika kwe nyika, chumizani sila ya Zumbe.’ ” ");
INSERT INTO ziw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Awo wantu nawasigilwa ni bunga dikwitangwa Mafalisayo. ");
INSERT INTO ziw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Niyo wamuza Yohana, “Uneva weye suyo Kulisito hegu Eliya hegu yudya muwoni, kwa mbwani wabatiza wantu?” ");
INSERT INTO ziw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana niyo awahitula, “Miye nabatiza kwa mazi, mna eyuko yumwenga mgati mwenyu hamummanyize. ");
INSERT INTO ziw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Uyo neze umo hajika komboka, mna miye sikuwagilwa hata kufungula luzigi lwe vilatu vyakwe.” ");
INSERT INTO ziw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mbuli zino zoseni zitamwilwa uko Besaniya, ng'ambo yo mto wa Yolodani uko Yohana endaga akabatiza. ");
INSERT INTO ziw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Zuwa dikutimila, Yohana amwona Yesu akamwizila. Niyo agamba, “Yuno nuyo Mwanangoto ywa Chohile ikusa masa ya wantu we isi! ");
INSERT INTO ziw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yuno nuyo nilongile umo hagamba, ‘Homboka miye neze mntu yumwe mkulu kujinka miye, kwaviya endaga uko miye sinati kwelekwa!’ ");
INSERT INTO ziw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Miye mwenye sammanyize, mna siza kubatiza wantu kwa mazi chani wantu wa Izulaeli wammanye.” ");
INSERT INTO ziw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohana nakaukula kugamba, “Simwona Muye Ukukile akasela kulaila kulanga enga suwa manga na kuchima mlanga mwakwe. ");
INSERT INTO ziw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Miye sammanyize, mna Chohile anisigile ukubatiza wantu kwa mazi na kanigambila, ‘Mntu yudya noumuwone Muye Ukukile akamseila kulaila kulanga na kwikala mnanga mwakwe, uyo nuyo akubatiza kwa Muye Ukukile.’ ");
INSERT INTO ziw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohana agamba, miye siwona,” “naho siukula kugamba yuno nuyo Mwana Chohile.” ");
INSERT INTO ziw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Zuwa dikutimila Yohana nendile naho ehadya hantu aho hamwenga na wanampina wakwe waidi. ");
INSERT INTO ziw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Eze amwone Yesu akajinka, agamba, “Kaulani! Yuno nuyo Mwanangoto ywa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Awo wanampina wamwiva Yohana akalonga izimbuli izo, niyo wamtimila Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu ahituka eze awawone awo wanampina wamtimila, awauza, “Mwaunga mbwani?” Wamgamba, “Labi, wekala kuhi?” Labi nuko kugamba mhinyi. ");
INSERT INTO ziw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu awagamba, “Soni, nanywi namwone.” Awo wanampina wamtimila, wawona hantu endaga akekala. Wasinda naye zuwa idyo. Nayo neikabula saa mlongo nechisingi. ");
INSERT INTO ziw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Anduleya mlukolo ywakwe Simoni Petulo nendile ni yumwenga mgati mwa awo awaidi wendile wamwivile Yohana aho akalonga ivyo. Niyo wamtimila Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anduleya ambwila Simoni nkongo, mlukolo ywakwe. Amgamba, “Chimwona Masiya.” Masiya nu nukokugamba Kulisito Mkombola. ");
INSERT INTO ziw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Niyo amwigala Simoni kwa Yesu. Yesu amsinya nakumgamba, “Zina dyako nuyo Simoni mwana ywa Yohana, mna nawitangwe Kefa.” Zina dino diligana na Petulo nadyo nu nukokugamba Luwe. ");
INSERT INTO ziw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Zuwa dikutimila Yesu akonga kwita Galilaya. Uko ambwila Filipo na kumgamba, “Nitimila!” ");
INSERT INTO ziw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo nani mkaya ywa Betisaida, mzi nawakekala Anduleya na Petulo. ");
INSERT INTO ziw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo ambwila Nasanieli nakumgamba, “Chimwona yudya alongagwa ni Musa mwe chitabu che zisigilizi, naho alongagwa ni wawoni. Nuyo Yesu mwana Yusufu, mntu ywa Nazaleti.” ");
INSERT INTO ziw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nasanieli auza, “Vino vyadahika chintu chedi chilaile Nazaleti?” Filipo ahitula, “Soo ukaule.” ");
INSERT INTO ziw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu eze amuwone Nasanieli akamwizila, amlongela, “Uyo ni Muizulaeli toti, hena lema!” ");
INSERT INTO ziw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nasanieli amuza, “Kunimanya vivihi?” Yesu ahitula, “Nakuwonaga umo nawihasi ho mtini, umo Filipo hanati kukwitanga.” ");
INSERT INTO ziw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nasanieli ahitula, “Mhinyi, weye wi Mwana Chohile! Weye wi Seuta ywa Izulaeli!” ");
INSERT INTO ziw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu agamba, “Wazumila kwaviya du nakugambilaga kugamba na sikuwona hasi ho mtini? Nauwone mbuli nkulu kujinka zino!” ");
INSERT INTO ziw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Awagamba, “Nawagambilani chindedi, namwone mbingu zikagubuka na wandima wa kwembingu wa Chohile wakakwela na kusela mlanga mwe Mwana ywa Mntu.” ");
INSERT INTO ziw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Zuwa dya katatu nakuna nyinka mo mzi wa Kana uko Galilaya. Mamiyakwe Yesu endaga aho, ");
INSERT INTO ziw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu hamwenga na wanampina wakwe nawo wagonekagwa mwe inyinka iyo. ");
INSERT INTO ziw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Divai eze isile, nine Yesu amgamba, “Divai iwasila!” ");
INSERT INTO ziw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu ahitula, “Mnala, usekunigambila dya kudamanya, chipindi changu hachinati.” ");
INSERT INTO ziw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aho mamiyakwe awagambila wandima, “Damanyani dyodyose nawagambileni.” ");
INSERT INTO ziw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aho na hana mabiga mtandatu yadamanywe kwa mayuwe, chila dimwe nadikaguha madebe mashano vino, mazwela yakutimilwa ni Wayahudi mwe kwelengusa. ");
INSERT INTO ziw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu awagamba wandima, “Memezani mazi amabiga yano.” Wayamemeza, ");
INSERT INTO ziw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","niyo awagamba, “Tekani mazi mmwigaile mkulu ywe ngasu”. Wamwigaila mazi, ");
INSERT INTO ziw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","mkulu ywe ngasu eze ayalume yahitukila kutenda divai. Havimanyaga mazi yano uko yalaile, kwaviya wandima watekile amazi nawavimanya, ivyo niyo amwitanga umwali, ");
INSERT INTO ziw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","amgamba, “Chila mntu alavya divai yedi nkongo, hadya wagonekwe wakatenda wanywelesa, alavya idya isokele. Mna weye kuika idivai iyedi kubula vino haluse!” ");
INSERT INTO ziw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu kadamanya chilagiso icho cha nkongo uko Kana, mzi wa Galilaya, uko kalagisa ukuka wakwe, wanampina wakwe niyo wamzumila. ");
INSERT INTO ziw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Vize viheze, Yesu na mamiyakwe, walukolo wakwe na wanampina wakwe wasela kwita Kapelinaumu nakwikala uko kwa mazuwa majeche. ");
INSERT INTO ziw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pasaka ya Wayahudi neihaguhi, ivyo Yesu niyo aita Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Umo mwe Nyumba nkulu ya Chohile awabwila wantu watamayombe wakulu wakataga ng'ombe, ngoto na wasuwa manga, wavunja hela wekala mwe izimeza zawo. ");
INSERT INTO ziw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Elo niyo apilika luzigi saviya msipi na kugulusa ng'ombe hamwenga na ngoto zawo kumlawa mwe Nyumba nkulu ya Chohile, akaheza ahitula meza za wadya wata yombe dya hela na kwitila matundu yawo hasi. ");
INSERT INTO ziw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Niyo awagamba nawakataga suwamanga, “Usani vintu vino hano! Mleke kuitenda Nyumba ya Chohile Tate gwilo!” ");
INSERT INTO ziw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wanampina wakwe wakumbuka kugamba Mawandiko Yakukile yagamba, “Chohile, kuyungisa kwangu Nyumba ya Chohile kwanoka saviya moto.” ");
INSERT INTO ziw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Vilongozi wa Wayahudi wahitula, “Wadaha kudamanya mpituko yani kulagisa kugamba una uwagila wa kudamanya vino?” ");
INSERT INTO ziw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu ahitula “Vunani Nyumba nkulu ya Chohile, nami naniizenge naho kwa mazuwa matatu.” ");
INSERT INTO ziw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aho wayahudi wamuza, “Waunga wiizenge kwa mazuwa matatu? Iguha mihilimo milongo mine na mtandatu kuzenga Nyumba nkulu ya Chohile!” ");
INSERT INTO ziw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mna Nyumba nkulu ya Chohile naikalongwa ni Yesu nuumwili wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ivyo umo eze auyuke, wanampina wakwe wakumbuka kugamba alongaga ayo, niyo wazumila Mawandiko Yakukile viya alongaga Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu umo endaga Yelusalemu kwe zuwa Pasaka wantu walozize wamzumila weze wawone vilagiso adamanyaga. ");
INSERT INTO ziw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mna Yesu nendile hana uzumizi nawo, kwaviya nakawamanya wose. ");
INSERT INTO ziw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Havyungigwe yoyose amukuile mbuli zawo, kwaviya uyo mwenye nakavimanya vimwe myoyo yawo. ");
INSERT INTO ziw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kwendaga kuna chilongozi yumwenga Myahudi akwitangwa Nikodemo, wa bunga dya Mafalisayo. ");
INSERT INTO ziw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chilo chimwenga ambasaga Yesu nakumgamba, “Labi, chimanya kugamba weye wi mhinya usigilwe ni Chohile. Hahali akudaha kudamanya vilagiso ukudamanya uneva Chohile he hamwenga naye.” ");
INSERT INTO ziw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu ahitula, “Nakugambila chindedi, hahali akudaha kuuwona Useuta wa Chohile henati kwelekwa nkanana ya kaidi.” ");
INSERT INTO ziw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo auza. “Mntu mjima adaha vivihi kwelekwa vituhu?” “Havikudahika kwingila vituhu mweinda ya mami yakwe na kwelekwa vituhu!” ");
INSERT INTO ziw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu ahitula. “Nakugambila chindedi,” “Hahana akudaha kwingila mo Useuta wa Chohile henati kwelekwa kwa mazi na kwa Muye. ");
INSERT INTO ziw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Chikwelekwa ni mntu ni cha chimwili ni tati yakwe na mami yakwe, mna chikwelekwa ni Muye ni muye. ");
INSERT INTO ziw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Usekwehelwa kwaviya sikugambila kugamba nyuwe mwaungwa mwelekwe uhya. ");
INSERT INTO ziw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mpeho yavumila kuhinga kudya ikunga, waiva idizwi dyakwe, mna hukuvimanya uko ikulaila hegu uko ikwita. Ni saivyo kwa chila mntu akwelekwa kwa Muye.” ");
INSERT INTO ziw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo auza. “Vino vyadahika vivihi?” ");
INSERT INTO ziw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu ahitula, “Wi mhinya mkulu mwe Izulaeli, naho huvimanyize vino? ");
INSERT INTO ziw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nakugambila chindedi, suwe chalonga yadya chimanyize na kuukula milosi chiwone, mna nyuwe hamkunga kuhokela ukuzi wetu. ");
INSERT INTO ziw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Uneva hamkuzumila umo hawagambilani mbuli ze isi, namdahe vivihi kunizumila, naho. Umo hawagambilani mbuli za kwembingu? ");
INSERT INTO ziw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Na kujinka idi hahali mntu akweile kwembingu ukaleka Mwana ywa Mntu, aseile hasi kulaila kwembingu.” ");
INSERT INTO ziw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Saviya Musa enule kulanga nyoka idamanywe kwa shaba uko kwenyika, saivyo Mwana ywa Mntu nenulwe kulanga, ");
INSERT INTO ziw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","chani chila mntu akumzumila enkigwe ujima wa mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwaviya Chohile kaungisa isi vilekile amlavye Mwanawe ywe ichedu, chani chila mntu namzumile asekwaga mna enkwe ujima mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chohile hamsigile Mwanawe mwe isi chani akantile wantu, mna atende mkombola ywawo. ");
INSERT INTO ziw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mntu yoyose akumzumila Mwana hakantilwe, mna yudya hekumzumila kakantilwa kale, kwaviya hamzumile Mwana ywa ichedu ywa Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kanto dyalawana savino, ung'azi wiza mwe isi, mna wantu waunga chiza waleka ung'azi, kwaviya ntendwa zawo ziha. ");
INSERT INTO ziw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chila yumwe akudamanya wavu ehiwa ung'azi naho haunge kwiza ko ung'azi, kwaviya hakunga wavu wakwe ulangazwe. ");
INSERT INTO ziw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mna akudamanya chindedi eza ko ung'azi chani ntendwa zakwe ziwoneke kugamba zadamanywa saviya Chohile alagize. ");
INSERT INTO ziw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Vikaheza, Yesu na wanampina wakwe waita kwe isi ya Yudeya, uko kekala nawo hamwenga kuno akabatiza wantu. ");
INSERT INTO ziw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana naye naakabatiza uko Ainoni, haguhi na Salimu, kwaviya uko kwendaga na mazi yalozize. Wantu nawakaita kwakwe naye kawabatiza. ");
INSERT INTO ziw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yano yalaila umo Yohana henati kujelwa mndani. ");
INSERT INTO ziw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kulaila mahigano mgati mwa wanampina wa Yohana na Myahudi yumwenga mwe mbuli ya mazwela yawo ya kwelengusa. ");
INSERT INTO ziw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ivyo waita kwa Yohana nakugamba, “Mhinya, wakumbuka yudya mntu endaga hamwenga na weye ng'ambo yo mto Yolodani, yudya waukulaga mbuli zakwe? Kaula, haluse abatiza, naho chila mntu amwitila!” ");
INSERT INTO ziw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana ahitula, “Hahali akudaha kutenda na chintu hanenkigwe ni Chohile ywa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nyuwe wenye mwi waukuzi wangu wa yadya nalongaga, ‘Miye suyo Kulisito, mna sisigilwa chani nimlongweile.’ ");
INSERT INTO ziw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mta mwali wa chiche nuyo mwali we chilume, mna mmbuya wo mwali we chiche, yudya akumchimala haguhi na uyo na kumwetegeleza, eleleswa umo akeva izwi dyo umwali we chivyele. Vino nivyo mbwedo wangu uchinta. ");
INSERT INTO ziw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aungwa amanyikise miye nami nisinywe hadodo.” ");
INSERT INTO ziw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Akwiza kulaila kwembingu ni mkulu kujinka wose. Akulaila kwe isi ni ywa mwe isi naho alonga mbuli za chiisi, mna akwiza kulaila kwembingu ni mkulu kujinka wose. ");
INSERT INTO ziw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Asimwila yadya awone na kuyeva, mna hahana mntu akuzumila ukuzi wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mna yoyose akuzumila ulosi wakwe atogola kugamba ukuzi wa Chohile wabunkula chindedi. ");
INSERT INTO ziw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yudya asigilwe ni Chohile alonga mbuli za Chohile, kwaviya Chohile amwinka umemo wa Muye wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tati ywa mntu amunga Mwanawe naho kamwinka vintu vyose vitende mwe mikono yakwe. ");
INSERT INTO ziw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Akumzumila Mwana ana ujima wa mazuwa yose, hekumwiva Mwana hatende na ujima wa mazuwa yose, mna naasigale mwe maya ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayo naweva kugamba Yesu nakahokela nakubatiza wanampina walozize kujinka Yohana. ");
INSERT INTO ziw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mna ichindedi, ni kugamba Yesu habatizaga mntu yoyose, nawakadamanya ivyo ni wanampina wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ivyo umo Yesu eze eve ayo nayakalongwa, akulawa Yudeya na kuya Galilaya. ");
INSERT INTO ziw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mwe ntambo iyo imtenda ajinkile Samaliya. ");
INSERT INTO ziw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Uko Samaliya abula kwe mzi ukwitangwa Sikali, wendaga wihaguhi ne nkonde idya ya Yakobo amwinkaga mwanawe Yusufu. ");
INSERT INTO ziw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hantu aho hendaga na sima dya Yakobo, na Yesu, nakasokezwa ni ntambo, ekala hasi haguhi ne disima. Nani saa chenda vino za nomsi. ");
INSERT INTO ziw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mvyele yumwenga Mfambazi keza kuteka mazi, niyo Yesu amgamba, “Ninka mazi ninywe.” ");
INSERT INTO ziw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Chipindi icho wanampina wakwe nawaita komzi kwe kugula nkande. ");
INSERT INTO ziw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Uyo mvyele Mfambazi amgamba, “Weye wi Myahudi, miye nami ni Mfambazi ivyo wadaha vivihi kunilombeza mazi?” Wayahudi hawakudaha kudya ndala na Wafambazi. ");
INSERT INTO ziw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu amhitula, “Uneva hegu wamanyize ntunyo ya Chohile akukwinka naho ni yuhi akukulombeza mazi anywe, nakumlombeza, naye nakakwinka mazi yakukwinka ujima.” ");
INSERT INTO ziw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Uyo mvyele agamba, “Zumbe, huna chiya cha kutekela mazi, disima dyenye ni tali. Naupatehi mazi ya ujima? ");
INSERT INTO ziw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ni mkale ywetu Yakobo achinkile idisima dino, wanawe na wanyama wakwe wose wanywela idisima dino. Haluse weye wi mkulu kumjinka Yakobo?” ");
INSERT INTO ziw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu ahitula, “Wose wakunywa mazi ye idisima dino nawatende na nchilu naho, ");
INSERT INTO ziw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","mna nanywe mazi nanimwinke miye hatende na nchilu naho. Mazi hunga nimwinke nayatende mndani mwakwe mfajo ukunga umwinke mazi yakumwinka ujima. Naho nayamwinke ujima wa mazuwa yose.” ");
INSERT INTO ziw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Uyo mvyele amgamba, “Zumbe, ninka amazi ayo! Chani nise kuwona nchilu vituhu, naho ninasekwiza vituhu hano kuteka mazi.” ");
INSERT INTO ziw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu amgamba, “Hita ukamwitange mgosiwo mwizanye.” ");
INSERT INTO ziw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Uyo mvyele ahitula, “Sina mgosi.” Yesu ahitula, “Kulonga chindeni, ukagamba huna mgosi. ");
INSERT INTO ziw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nauna wagosi washano, yuno naye ukwikala naye vino haluse suyo mgosiwo. Kulonga chindedi.” ");
INSERT INTO ziw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Uyo mvyele agamba, “Zumbe, nawona kugamba weye wi muwoni.” ");
INSERT INTO ziw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Wakale wetu wa Chisamaliya nawamvikila Chohile mo lugulu luno, mna nyuwe Wayahudi mwagamba kugamba Yelusalemu ni hantu chikungwa chimvikile Chohile.” ");
INSERT INTO ziw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu amgamba, “Wemvyele nizumila, chipindi nachibule wantu hawamvikile Tate mo lugulu luno hegu kudya Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nyuwe Wasamaliya mwamvikila hemwimmanyize, mna suwe Wayahudi chimmanya uyo chikumvikila, kwaviya wambulwa walaila kwa Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mna chipindi cheza, naho chibula kale, umo wakumvikila Tate nawalongozwe ni Muye mwe chindedi mo kumvikila Tate. Kwaviya Tate awaunga wakumvikila saivyo. ");
INSERT INTO ziw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Chohile ni Muye, wantu wakumvikila waungwa wamvikile kwa kulongozwa ni Muye na chindedi.” ");
INSERT INTO ziw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Uyo mvyele amgamba, “Sivimanya kugamba Masiya akwitangwa Kulisito neze. Umo akeza nachigambile chila chintu.” ");
INSERT INTO ziw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu ahitula, “Miye hulonga na weye nuyo.” ");
INSERT INTO ziw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aho wanampina wa Yesu wauya, niyo wehelwa vidala kumwona asimwila na mvyele. Mna hahana amuzize mvyele uyo kugamba, “Waunga mbwani?” Hegu kumuza Yesu, “Nimbwani wasimwila na mvyele yuno?” ");
INSERT INTO ziw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Uyo mvyele niyo asa idibiga dyakwe hadya, aita komzi na kuwagambila wantu, ");
INSERT INTO ziw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Soni mkamwone mntu anigambile mbuli zose nidamanye. Vyadahika kutenda nuyo Kulisito?” ");
INSERT INTO ziw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ivyo wantu walawa umzi na kwita kwa Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ichipindi icho wanampina wakwe nawakamhembeleza Yesu, “Mhinyi, udye chochose!” ");
INSERT INTO ziw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mna Yesu awahitula, “Nina nkande nyuwe hemwimanyize.” ");
INSERT INTO ziw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ivyo wanampina wakwe wauzana, “Vyadahika kuna mntu amwigaile nkande?” ");
INSERT INTO ziw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu awagamba, “Nkande yangu ni kudamanya yadya akunga yudya anisigile, na kubindiliza ndima yakwe anisigile. ");
INSERT INTO ziw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mna lusimo lukugamba, ‘Isigala myezi mine, chikutimila nu uvuni.’ Mna nawagambilani, kaulani izinkonde zaungwa zivunwe! ");
INSERT INTO ziw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mvuni alihwa naho achisanya nkande kwa ujima wa mazuwa yose, ivyo mtuhu akuhanda na yudya akuvuna nawelelwe hamwenga. ");
INSERT INTO ziw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Lusimo ulo ni chindedi, ‘Yumwenga ahanda mtuhu avuna.’ ");
INSERT INTO ziw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Siwasigilani mkavune mwe nkonde hamwidamanyize ndima, watuhu na wadamanya ndima hano, nyuwe mwahokela mwe ndima yawo.” ");
INSERT INTO ziw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wasamaliya walozize we kaya idya wamzumila Yesu kwaviya yudya mvyele amukwilaga, “Kanigambila zose nidamanye.” ");
INSERT INTO ziw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ivyo umo Wasamaliya wambwile Yesu wamlombeza ekala nawo. Yesu niyo ekala aho mazuwa maidi. ");
INSERT INTO ziw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Wantu walozize niyo wazumila kwa ulosi wa Yesu, ");
INSERT INTO ziw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","wamgamba yudya mvyele, “Haluse hachizumile, siyo kwaviya walongaga, mna kwaviya chimwiva wenye, naho chivimanya kugamba nuyo chindedi Mwambula ywa wantu we isi.” ");
INSERT INTO ziw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu eze abinde mazuwa maidi, niyo aita Galilaya, ");
INSERT INTO ziw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","kwaviya Yesu mwenye aukulaga, “Muwoni hakutunywa kwe isi yakwe.” ");
INSERT INTO ziw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Eze abule Galilaya, wantu walozize wa uko wamhokela kwaviya wawonaga yose adamanyaga umo waitile Yelusalemu kwe nkande ye Pasaka. ");
INSERT INTO ziw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu niyo auya mo mzi wa Kana uko Galilaya, uko ahitule mazi yakatenda divai. Kwendaga na mkulu yumwenga ywa selikali endaga na mwanawe mnyonje uko Kapelinaumu. ");
INSERT INTO ziw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Eze eve kugamba Yesu kakulawa Yudeya kabula Galilaya, kamwitila na kumlombeza aite akamhonye mwanawe wa chilume endaga mnyonje wa kubanika. ");
INSERT INTO ziw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu amgamba, “Nyuwe hamnawone mpituko na vilagiso hamzumile.” ");
INSERT INTO ziw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mkulu uyo ahitula, “Zumbe, chitanye mwanangu hanati abanike.” ");
INSERT INTO ziw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu amgamba, “Jenda, mwanawo natende na ujima!” Uyo mntu niyo azumila ulosi wa Yesu, niyo ahalawa. ");
INSERT INTO ziw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Achei mwe sila wandima wakwe wadugana naye, wamgamba, “Mwanawo kahona!” ");
INSERT INTO ziw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Awauza isa umwana ahonile, nawo wamhitula, “Gulo saa mfungate nomsi, unyonje umlekela.” ");
INSERT INTO ziw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Niyo akumbuka nendile nidya isa Yesu amgambile, “Mwanawo nahone.” Ivyo yeye hamwenga na wantu mwe nyumba yakwe wose niyo wazumila. ");
INSERT INTO ziw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chino ni chilagiso cha kaidi adamanyaga Yesu eze auye kulaila Galilaya kubula Yudeya. ");
INSERT INTO ziw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Vikaheza Yesu niyo aita Yelusalemu kwe ngasu ya Chiyahudi. ");
INSERT INTO ziw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kudya Yelusalemu hajihi ne nchili yo mzi uwo ikwitangwa lwivi lwa ngoto, nakuna ndiwa ya mazi ikwitangwa kwa Chiebulaniya Betisaza, naina balaza shano zina mizeze. ");
INSERT INTO ziw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Wanyonje walozize nawalambala mwe zibalaza, matuntu na viwete na waholomale nawakagoja mazi yatibulwe, ");
INSERT INTO ziw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kwaviya mndima ywa kwembingu nakasela chila nkanana mndani mwe ndiwa atibule amazi. Mnyonje ywa nkongo kwingila mndani mwa mazi umo yatibulwe, nakahonywa unyonje wose nendile ananawo. ");
INSERT INTO ziw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nahana mntu mnyonje kwa mihilimo milongo mitatu na mnane. ");
INSERT INTO ziw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu eze amwone kagona nakumanya kugamba katenda mnyonje kwa mazuwa yalozize, niyo amuza, “Waunga uhone?” ");
INSERT INTO ziw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mnyonje ahitula, “Zumbe, sina mntu ywa kuningiza mwe ndiwa ya mazi umo yakatibulwa, chila hajeza kwingila, mntu mtuhu anilongwela.” ");
INSERT INTO ziw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu amgamba, “Chimala, guha umcheka wako wite.” ");
INSERT INTO ziw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aho mntu uyo niyo ahona, niyo aguha mcheka wakwe, akonga kujenda. Mbuli iyo idamanyika mwe Zuwa dya kuhumula, ");
INSERT INTO ziw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ivyo vilongozi wa Wayahudi wamgamba yudya mntu ahonyigwe, “Dyelo ni Zuwa dya kuhumula, kwa Sigilizi zetu havikungwa wetwike mcheka wako dyelo.” ");
INSERT INTO ziw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ahitula, “Yudya mntu anihonyize nuyo anigambile, guha umcheka wako ujende.” ");
INSERT INTO ziw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wamuza, “Uyo mntu akugambile ivyo ni yuhi?” ");
INSERT INTO ziw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mna yudya mntu ahonyigwe hammanyaga Yesu ni yuhi, kwaviya nahana wantu walozize, Yesu naye kahalawa kale. ");
INSERT INTO ziw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Vize vyajike, Yesu ambwila yudya amhonyize mwe Nyumba nkulu ya Chohile na kumgamba, “Tegeleza, haluse kuhona. Ivyo usekudamanya masa vituhu unase kubwilwa ni mbuli ihise.” ");
INSERT INTO ziw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yudya mntu niyo ahalawa na kuwagambila vilongozi wa Wayahudi kugamba Yesu nuyo amhonyize. ");
INSERT INTO ziw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ivyo Wayahudi niyo wakonga kumsunkasunka Yesu kwaviya nakadamanya ivyo mwe zuwa dya Kuhumula. ");
INSERT INTO ziw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu awahitula, “Tate adamanya ndima chipindi chose, miye nami nadamanya ndima.” ");
INSERT INTO ziw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ulosi uno uwatenda vilongozi wa Wayahudi waungise kumkoma. Siyo kwaviya nakabalanga Sigilizi ya zuwa dya kuhumula du, mna kwaviya kagamba Chohile ni Ise, ivyo ketenda kaligana na Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ivyo Yesu awahitula, “Nawagambilani ichindedi, mwana hakudaha kudamanya chintu ichedu, adaha kudamanya chiya akumwona Ise adamanya. Chiya akudamanya Tati ya mntu, Mwana naye achidamanya. ");
INSERT INTO ziw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwaviya Tati ya mntu amunga Mwanawe amlagisa chila chintu akudamanya mwenye. Namlagise mbuli nkulu zikujinka zino, nanywi namwehelwe. ");
INSERT INTO ziw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Saviya Tate akuuyusa wabanike na kuwenka ujima, mwe ivyo Mwana naye awenka ujima wadya akunga. ");
INSERT INTO ziw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tate hakukantila yoyose. Kamwinka Mwanawe udahi wose wa kukantila, ");
INSERT INTO ziw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","chani wose wamwive Mwana saviya wakumwiva Tati yamntu. Hekumwiva Mwana hakumwiva Tati ya mntu yudya amsigile. ");
INSERT INTO ziw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nawagambilani ichindedi, akwiva ulosi wangu, na kumzumila yudya anisigile, ana ujima wa mazuwa yose. Hakantilwe, mna kajinka kale kulaila mo kubanika na kwingila mo ujima. ");
INSERT INTO ziw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nawagambilani chindedi, chipindi cheza, naho chibula kale, umo wabanike na weve izwi dya Mwana ywa Chohile, na wadya wakudiva nawatende na ujima. ");
INSERT INTO ziw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Saviya Tate mwenye nuyo nkongelo yo ujima, nivyo amtendile Mwanawe nkongelo yo ujima. ");
INSERT INTO ziw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Naho kamwinka Mwanawe udahi wa kukantila, kwaviya ni Mwana ywa Mntu. ");
INSERT INTO ziw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Msekwehelwa mwe vino. Chipindi cheza umo wabanike wemwezimbila naweve izwi dyakwe, ");
INSERT INTO ziw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na kulaila mwe zimbila zawo. Wadya wadamanye yedi nawauyuke na kutenda na ujima, mna wadya wadamanye yehiye nawauyuke na kukantilwa. ");
INSERT INTO ziw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Sikudaha kudamanya chintu kwa udahi wangu mwenye. Nakantila saviya hugambilwa ni Chohile kugamba kanto dyangu dyawagila, kwaviya sikudamanya viya hunga, mna viya du yudya anisigile. ");
INSERT INTO ziw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Uneva heukuila mwenye, hunga nilonge hachihokelwe saiya chindedi. ");
INSERT INTO ziw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mna hana mtuhu akunukuila, naho simanya kugamba yose akunilongela ni chindedi. ");
INSERT INTO ziw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nyuwe msigila wantu kwa Yohana, naye kaukula ichindedi. ");
INSERT INTO ziw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Suko kugamba miye naunga ukuzi wa mntu; Nalonga vino chani mdahe kwambulwa. ");
INSERT INTO ziw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana endaga saviya taa ikwaka na kupulika, naho namkaunga mbwede hadodo ulangazi wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mna miye nina ukuzi ukulise kujinka udya alavyaga Yohana. Yadya hudamanya, nizo ndima aninkile Tate nizidamanye, zino zanilongela na kulagisa kugamba Tate kanisigila. ");
INSERT INTO ziw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Naye Tate anisigile nuyo aniukuile kale, nyuwe hamnati kwiva idizwi dyakwe na kumwona, ");
INSERT INTO ziw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","naho ulosi wakwe haukwikala mndani mwenyu kwaviya hamkumzumila yudya amsigile. ");
INSERT INTO ziw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nyuwe nanywi mwakaula Mawandiko Yakukile, kwaviya mwafanyanya kugamba mndani mwakwe namwinkwe ujima wa mazuwa yose. Mawandiko ayo nayo yakunukwila! ");
INSERT INTO ziw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hata ivyo nyuwe hamkunga kwiza kwangu chani mhokele ujima. ");
INSERT INTO ziw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Sikulonda ntogozi kulaila kwa mntu. ");
INSERT INTO ziw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mna siwamanya nyuwe kugamba mwi wantu hemkumunga Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Miye siza kwa udahi wa Tate, mna hamkunihokela, mna mntu mtuhu akeza kwa udahi wakwe mwenye, namumhokele. ");
INSERT INTO ziw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mwadaha vivihi kuzumila kuno nyuwe mwaunga kuhokela ntogozi kulaila kwenyu nyuwe wenye, mna hamkunga ntogozi zikulawa kwa Chohile uyodu. ");
INSERT INTO ziw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Msekufanyanya kugamba miye naniwalahe nyuwe kwa Tate. Sigilizi za Musa mkwikiya msuhi. ");
INSERT INTO ziw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Uneva chindedi mwamzumila Musa mnizumile nami kwaviya awandikaga mbuli zangu. ");
INSERT INTO ziw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mna hegu hamyazumile yadya Musa awawandikileni, namdahe vivihi kuzumila mbuli hulonga?” ");
INSERT INTO ziw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yeze yajinke ayo, Yesu aita ntendele ya kaidi ye diziwa dya Galilaya hegu ziwa dya Tibeliya seivyo nendile hamwenga diketangwa. ");
INSERT INTO ziw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lukudidi lwa wantu lwamtimila kwaviya wantu awo nawawona vilagiso nakadamanya kwa kuwahonya wanyonje. ");
INSERT INTO ziw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu niyo akwela kolugulu, ekala hamwenga na wanampina wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ngasu ya Pasaka ya Wayahudi yendaga ihaguhi. ");
INSERT INTO ziw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu eze akaule na kuwona lukudidi lwa wantu lukeza kwakwe, amgamba Filipo, “Chikagulehi nkande chani wantu wano wadye?” ");
INSERT INTO ziw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kalonga ivyo chani amjeze Filipo, kwaviya nakavimanya mwenye ivyo nadamanye. ");
INSERT INTO ziw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo amhitula, “Hata chendile na matundu yakwitangwa dinali yakubula magana maidi, hayakudaha kugula migate chila yumwenga adye egute.” ");
INSERT INTO ziw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yumwenga mwa wanampina wakwe, akwitangwa Anduleya, yudya endaga mlukolo ywa Simoni Petulo, amgamba, ");
INSERT INTO ziw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Hano hana mbwanga yumwenga mta migate mishano ya shaili na samaki waidi, mna vino navichinte mbwani wantu walozize savino?” ");
INSERT INTO ziw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu amgamba. “Wekazeni wantu hasi,” Hendaga na mani yalozize ahantu aho. Ivyo wantu niyo wekala hasi, wagosi awodu nawakabula magana milongo mishano. ");
INSERT INTO ziw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu niyo aiguha idya migate, amtogola Chohile, awapangila wantu wadya wekale. Atenda saivyo mwe ziya samaki, na chila mntu kapata saviya aungile. ");
INSERT INTO ziw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wantu weze wegute, Yesu awagamba wanampina wakwe, “Logotani vibesulo visigale visekwaga.” ");
INSERT INTO ziw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wowo nawo walogota vibesulo vya migate mishano ye shaili wasigaze wadya wantu wadile niyo wamemeza ntangulu mlongo na mbili. ");
INSERT INTO ziw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wantu weze wawone chilagiso icho Yesu adamanye, wagamba, “Chindedi yuno nuyo Muwoni akwiza mwe isi.” ");
INSERT INTO ziw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu niyo amanya kugamba wantu na wakaunga wamguhe wamtende seuta kwa nguvu, niyo aita vituhu kolugulu ichedu. ");
INSERT INTO ziw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ize ibule chisingi, wanampina wakwe Yesu wasela kubula kwediziwa, ");
INSERT INTO ziw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","niyo wakwela mwe ngalawa, wakonga kudeluka idiziwa wahinge Kapelinaumu. Chiza nachingila, Yesu nendile hanati kuwabwila. ");
INSERT INTO ziw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chipindi icho ziwa niyo dyakonga kutibukila kwa chausa cha luzimu lukulu. ");
INSERT INTO ziw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wanampina kudya waitile utali wa chilometa shano hegu mtandatu wamwona Yesu akajenda mlanga mwa mazi, akeisogeila ingalawa, niyo wogoha vidala. ");
INSERT INTO ziw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu awagamba, “Ni miye!” “Msekogoha,” ");
INSERT INTO ziw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nawakaunga wamguhe Yesu mwe ngalawa, aho ingalawa niyo yabula kwe isi nawakaita. ");
INSERT INTO ziw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mtondo wakwe fyo dya wadya wasigale nkanana ya kaidi ye diziwa. Niyo wabunkula kugamba nakuna ngalawa imwenga du hadya, naho Yesu hengile mwe ngalawa hamwenga na wanampina wakwe, mna wanampina awo nawaita wowo wenye. ");
INSERT INTO ziw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ngalawa ntuhu, zikulaila Tibeliya, niyo zabula aho wantu wadile imigate Zumbe amtogolaga Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Umo awo wantu weze wabunkule kugamba Yesu na wanampina wakwe hawahali aho, niyo wakwela ngalawa waita Kapelinaumu, wakamlonda. ");
INSERT INTO ziw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wadya wantu weze wambwile Yesu ntendele ya kaidi ye diziwa, wamuza, “Mhinyi, kubula ini hano?” ");
INSERT INTO ziw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu awahitula, “Nawagambilani chindedi, mwanilonda siyo kwaviya muwona vilagiso, mna kwaviya mdile idya imigate niyo mweguta. ");
INSERT INTO ziw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Msekwevinya kwa nkande ikubanika, mna, kwevinyeni kwa nkande ya ujima wa mazuwa yose. Ino niyo natende Mwana ywa Mntu nawenkeni, kwaviya Chohile, Tate, kajela hula kugamba kamsagula na kumzumila.” ");
INSERT INTO ziw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wowo niyo wamwuza, “Chitende mbwani chani chisankanile ndima ya Chohile?” ");
INSERT INTO ziw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu awahitula, “Ino niyo ndima ya Chohile mumzumile yudya amsigile.” ");
INSERT INTO ziw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aho wamgamba, “Naudamanye chilagiso chani chiwone chani chikuzumile? Nautende chibwani? ");
INSERT INTO ziw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wakale wetu wadyaga mana kudya kwedijangwa, saviya viwandikwe mwa mawandiko Yakukile, ‘Kawalisa nkande ilaile kwembingu.’ ” ");
INSERT INTO ziw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu awagamba. “Nawagambilani chindedi,” “Musa hawenkileni nkande ilaile kwembingu, mna Tate nuyo akuwenkani nyuwe nkande ya chindedi ikulaila kwembingu. ");
INSERT INTO ziw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwaviya nkande ya Chohile ni yudya akusela kulaila kwembingu na akwinkiza ujima kwa wantu we isi.” ");
INSERT INTO ziw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Niyo wamgamba, “Zumbe, chinke mgate uwo kalenakale.” ");
INSERT INTO ziw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu awagamba, “Miye nuwo mgate ukujela ujima. Mntu akwiza kwangu halumwe ni sala, yoyose akunizumila halumwe ni nchilu naho. ");
INSERT INTO ziw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nasiwagambilani kugamba mniwona mna hamkunizumila. ");
INSERT INTO ziw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wose akuninka Tate naweze kwangu, mntu yoyose akwiza kwangu, sanimdule kuse, ");
INSERT INTO ziw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","kwaviya sisela kulaila kwembingu siyo kwaviya hweungila miye, mna kwaviya vikungwa ni yudya anisigile vino. ");
INSERT INTO ziw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Vino nivyo akunga yudya anisigile, nisekumwaza hata yumwenga mgati mwa wadya aninkile, mna niwauyuse wose zuwa dya udumo. ");
INSERT INTO ziw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwaviya akunga Tate nicho chino, chila namwone Mwana na kumzumila atende na ujima wa mazuwa yose, nami nanimuuyuse zuwa dya uhelo.” ");
INSERT INTO ziw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Wayahudi wakonga kumng'ung'uzikila Yesu kwaviya nakagamba, “Miye ni mgate useile kulaila kwembingu.” ");
INSERT INTO ziw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wagamba, “Togola, yuno suyo Yesu mwana ywa Yusufu? Ise na nine Chiwamanya! Ivyo adaha vivihi kulonga kugamba kasela kulaila kwembingu?” ");
INSERT INTO ziw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu awagamba, “Lekani kung'ung'uzikilana. ");
INSERT INTO ziw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hahana mntu akudaha kwiza kwangu, ukaleka wadya wakwesigwe kwangu ni Tate anisigile hana mkwesize kwangu, nami nanimuyuse mwedizuwa dyo udumo. ");
INSERT INTO ziw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mwa mawandiko ya wawoni muwandikwa vino, wantu wose nawatende wahinywa ni Chohile, chila mntu akumwiva Tate na kuhina kwakwe eza kwangu. ");
INSERT INTO ziw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ivyo hulonga ni vino, hahana mntu amwone Tate, yudya alaile kwa Chohile nuyo du amwone Tate. ");
INSERT INTO ziw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nawagambilani chindedi, mntu akuzumila ana ujima wa mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Miye nuyo mgate ukujela ujima. ");
INSERT INTO ziw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wakale wenyu wadyaga nkande ikwitangwa mana kudya kwedijangwa, mna niyo wabanika. ");
INSERT INTO ziw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mna ino ni nkande ikusela kulaila kwembingu chani yoyose naidye asekubanika. ");
INSERT INTO ziw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Miye nuyo mgate ukujela ujima useile kulaila kwembingu. Mntu yoyose na adye nkande ino nekale mazuwa yose. Nkande nanimwinke nu mwili wangu huulavya kwa chausa cha ujima wa wantu we isi.” ");
INSERT INTO ziw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Naho wayahudi wakonga kuhigana mgati mwawo; “Yuno adaha vivihi kuchinka umwili wakwe chiudye?” ");
INSERT INTO ziw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu awagamba, “Nawagambilani chindedi, hamnadile mwili wa Mwana ywa Mntu na kunywa isakame yakwe, hamtende na ujima mndani mwenyu. ");
INSERT INTO ziw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nadye umwili wangu na kunywa sakame yangu ana ujima wa mazuwa yose, nami nanimuuyuse mwe zuwa dya uhelo. ");
INSERT INTO ziw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwaviya mwili wangu ni nkande ya chindedi, na sakame yangu ni chikunywegwa cha chindedi. ");
INSERT INTO ziw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nadye umwili wangu na kunywa isakame yangu, ekala mndani mwangu, nami nekala mndani mwakwe. ");
INSERT INTO ziw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Saviya Tate anisigile eli mjima, nami nekala kwa chausa cha nguvu zakwe; Seivyo akudya umwili nekale kwa chausa cha nguvu zangu. ");
INSERT INTO ziw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Uno ni mgate useile kulaila kwembingu, siyo saviya mana wadile wadalahala wenyu, niyo wabanika. Akudya umgate uno natende mjima mazuwa yose.” ");
INSERT INTO ziw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu alongaga ayo umo endile akahinya mwe nyumba yo kumvikila Chohile kudya Kapelinaumu. ");
INSERT INTO ziw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ivyo, wanampina walozize weze weve ivyo, wagamba “Yano ni mahinyo madala! Ni yuhi akudaha kuyategeleza?” ");
INSERT INTO ziw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu nakamanya hegambilwe ni mntu kugamba wanampina wakwe na wakang'ung'uzika mwe mbuli iyo, niyo awauza, “Togolani mbuli ino ni ndala? ");
INSERT INTO ziw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Navitende vivihi hegu hadya namumwone Mwana ywa Mntu akakwela kwita kudya endaga nkongo? ");
INSERT INTO ziw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Muye wa Chohile nuyo ukuleta ujima, mna nguvu za mntu hazikutenda chintu. Mbuli zino niwagambileni ni za Muye Ukukile zikuleta ujima. ");
INSERT INTO ziw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mna weyaho mgati mwenyu hewekuzumila.” Yesu nakalonga ivyo kwaviya nakamanya kukongela nkongo ni wahi hawamzumile, naho ni yuhi namhituke. ");
INSERT INTO ziw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Akaheza agamba, “Nivyo vikuleka nasiwagambilani kugamba hahana akudaha kwiza kwangu hanadahizwe ni Tate.” ");
INSERT INTO ziw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kulawana na ayo, watendile wanampina wakwe walozize wauya kunyuma, wasekutimilizana naye vituhu. ");
INSERT INTO ziw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ivyo, Yesu niyo awauza wadya mlongo na waidi, “Togolani nanywi mwaunga mwite kwenyu?” ");
INSERT INTO ziw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petulo amhitula, “Zumbe, chite kwa yuhi? Weye una ulosi ukujela ujima wa mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Suwe chazumila, naho chimanya kugamba weye nuyo Mkuka ywa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu niyo awagamba, “Togolani siwasagulani nyuwe mlongo na waidi? Mna yumwe ywenyu ni Mwavu!” ");
INSERT INTO ziw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu nakalonga ayo kwachausa cha Yuda Isikaliote, mwana Simoni Isikaliyote kwaviya nuyo akunga amhituke, hata uneva nendile yumwe ywa wadya wanampina mlongo na waidi. ");
INSERT INTO ziw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Eze viheze, Yesu na akatalamka uko Galilaya. Haungile kutalamka ko mkoa wa Yudeya kwaviya Wayahudi nawakaunga wamkome. ");
INSERT INTO ziw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ngasu ya Wayahudi ikwitangwa ngasu ya makumbi naihaguhi. ");
INSERT INTO ziw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Walukolo wa Yesu niyo wamgamba, “Halawe hano wite Yudeya chani wanampina wako waziwone ndima ukudamanya. ");
INSERT INTO ziw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Hahana mntu akudamanya mbuli kwa chefiso kuno aunga amanyike mwa wantu. Elo Kwaviya wadamanya mbuli sazino, kwelagise mwa wantu we isi yose.” ");
INSERT INTO ziw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hata walukolo wakwe welekanywe hawamzumile. ");
INSERT INTO ziw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu awagamba, “Chipindi changu chiligane hachinati kubula. Mna kwenyu nyuwe chila chipindi chaligana. ");
INSERT INTO ziw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wantu wa mwe isi ino hawakudaha kuwaihiwa mna wanihiwa miye kwaviya naukuila mbuli zakwe kugamba ziha. ");
INSERT INTO ziw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nyuwe hitani kwe ngasu iyo, miye sikwita, kwaviya saa yangu iligane hainati kubula.” ");
INSERT INTO ziw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kalonga ayo akaheza asigala uko Galilaya. ");
INSERT INTO ziw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Walukolo wa Yesu weze waite kwe ngasu, Yesu naye niyo aita, mna haitile mo lumpe mna kwa kwefisa. ");
INSERT INTO ziw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Vilongozi wa Wayahudi nawakamlonda kwe ngasu iyo wauza, “Ekuhi?” ");
INSERT INTO ziw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nakuna ntakalisi zilozize mwedifyo dya wantu. Wamwe wawo wagamba, “Ni mntu ywedi.” Watuhu wagamba, “Bule! Awaza wantu.” ");
INSERT INTO ziw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mna hahana mntu ajezize kulonga mbuli zakwe mwolumpe kwa kogoha vilongozi wa Chiyahudi. ");
INSERT INTO ziw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ngasu iyo ize ibule mgati, Yesu naye niyo aita mwe nyumba nkulu ya Chohile, akonga kuhinya. ");
INSERT INTO ziw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wayahudi wehelwa nakugamba, “Mntu yuno kamanya vivihi naye hasomile mwe shule?” ");
INSERT INTO ziw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aho Yesu awahitula, “Mahinyo huhinya sayo yangu, mna ni yayudya anisigile. ");
INSERT INTO ziw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mntu akunga adamanye yadya akunga Chohile, namanye kugamba mahinyo yangu yalaila kwa Chohile, hegu yalaila kwangu mwenye. ");
INSERT INTO ziw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mntu akulonga kwa udahi wakwe mwenye elondela ntogozi yakwe mwenye. Mna yudya akulonda ntogozi ya yudya amsigile ni mkanuni, naho mndani mwakwe hamna wihi wowose. ");
INSERT INTO ziw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Togolani, Musa hawenkile Sigilizi? Hata ivyo hahana hata yumwenga ywenu akuitoza. Ni mbwani mkunga mnikome?” ");
INSERT INTO ziw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aho fyo dya wantu wamhitula, “Una mpepo weye! Ni yuhi akunga akukome?” ");
INSERT INTO ziw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu awahitula, “Kuna mbuli imwenga nidamanye, nanywi mwayehelwa. ");
INSERT INTO ziw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa awenkagani sigilizi ya kujela ngasu mwe zuwa dya kuhumula, Kwa chindedi sigilizi iyo hailaile kwa Musa mna kwa wababa zenyu. ");
INSERT INTO ziw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mna hegu mntu ajelwa ngasu hata mwe zuwa dyo Kuhumula chani msekubalanga Sigilizi ya Musa, ni mbwani mwanihiwa kwa chausa cha kumhonya mntu mwe zuwa dya Kuhumula? ");
INSERT INTO ziw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Msekukantila kwa kukaula mbuli za kuse du. Lavyani kanto dikuwagila.” ");
INSERT INTO ziw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wantu wamwenga wa Yelusalemu walongaga, “Togola yudya mntu wakumlonda wamkome suyo yuno? ");
INSERT INTO ziw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kaulani haluse! Awafunda mo lumpe, hahali mntu wa kumgambila ulosi. Vyadahika vilongozi wabunkula chindedi kugamba yuno nuyo Kulisito? ");
INSERT INTO ziw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kulisito aho akwizila hahana mntu na amanye hantu alaile, mna suwe chimanya uko alaile mntu yuno!” ");
INSERT INTO ziw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Umo Yesu nakahinya mdya mwe nyumba nkulu ya Chohile, niyo alonga kwa kuguta, agamba, “Hambwe mnimanya naho uko nilaile mkumanya? Sizile kwa udahi wangu mwenye, uyo anisigile miye ni ywa chindedi! ");
INSERT INTO ziw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mna miye simmanya kwaviya silaila kwakwe, uyo nuyo anisigile.” ");
INSERT INTO ziw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wantu nawakaunga wamgwile, mna hahana mntu ajezize kumgwila kwaviya saa yakwe nahainati kubula. ");
INSERT INTO ziw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wantu walozize mwe idifyo wamzumila, niyo wagamba, “Togola, Kulisito akeza nadamanye chilagiso chikulu chitendese chikujinka adamanye yuno?” ");
INSERT INTO ziw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafalisayo nawaweva wantu wa katakalisana mbuli zawo zikumlanga Yesu. Wowo hamwenga na walavyantambiko wakulu niyo wawasigila wankondo wamgwile. ");
INSERT INTO ziw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu agamba, “Nichei na nyuwe kwa chipindi chidodo, haheza nanite kwa yudya anisigile. ");
INSERT INTO ziw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Namnilonde mna hamniwone, na hadya hwita nyuwe hamdahe kubula.” ");
INSERT INTO ziw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Vilongozi wa Wayahudi walonga wowo wenye, “Mntu yuno naite kuhi kudya hachikudaha kumwona? Naite kwa Wagiliki wazagale mgati mwa Wayunani, na kuwahinya Wayunani? ");
INSERT INTO ziw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Uyo alonga kugamba, nachimlonde mna hachimuwone, naho kugamba hachidahe kwita kudya natendeke. Alonga vivihi?” ");
INSERT INTO ziw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mwe zuwa dya uhelo naho zuwa kulu dya ngasu Yesu nakachimala, akaguta, “Mntu yoyose mta nchilu neze kwangu anywe. ");
INSERT INTO ziw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Saviya Mawandiko Yakukile yawandikwe, akunizumila miye, mito ya mazi yakwinkiza ujima naijuluzike kulaila mo moyo wakwe!” ");
INSERT INTO ziw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nakalonga ayo kwa Muye Ukukile yudya nahokelwe ni wadya nawamzumile Yesu. Mwe chipindi icho Muye Akukile nendile hanati kusigilwa, kwaviya nendile hanati kutogolwa. ");
INSERT INTO ziw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wantu wamwenga mgati mwe difyo weze weva izimbuli izo, niyo wagamba, “Chindedi mntu yuno ni muwoni aungigwe eze!” ");
INSERT INTO ziw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wantu watuhu wagamba, “Yuno nuyo Kulisito Mwambula!” Mna watuhu wagamba, “Togola, naidahike vivihi Mkombozi alawe Galilaya? ");
INSERT INTO ziw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mawandiko Yakukile hayagambile kugamba Kulisito nelekwe Beselehemu, mzi wa Daudi!” ");
INSERT INTO ziw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Niyo kwalaila maswesano mwe idifyo kwa mbuli ya Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wantu wamwenga nawakaunga wamgwile, mna hahana ajezize kumgwila. ");
INSERT INTO ziw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wakaheza wadya wamizi niyo wauya kwa walavyantambiko wakulu na Mafalisayo. Niyo wawauza, “Nimbwani hammwigale?” ");
INSERT INTO ziw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wamizi wawahitula, “Hahana mntu ajezaga kulonga savino akulonga mntu yuno!” ");
INSERT INTO ziw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafalisayo wawauza, “Togolani, nanywi mdantika? ");
INSERT INTO ziw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Togolani, mumwona kale yumwenga mwe vilongozi wa wantu hegu yumwenga mwa Mafalisayo amzumile? ");
INSERT INTO ziw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mna wantu hewemanyize Sigilizi ya Musa, waligitwa!” ");
INSERT INTO ziw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yumwenga ywa Mafalisayo endaga aketangwa Nikodemo, yudya aho nkongo amwitilaga Yesu. Niyo awagamba, ");
INSERT INTO ziw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Togolani, Sigilizi zenyu zamkantila mntu henati kumwiva na kumanya adamanya mbwani?” ");
INSERT INTO ziw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wowo wamhitula, “Togola, weye nawe kulaila Galilaya? Haya, kayakaule Mawandiko Yakukile weye nawe nauwone kugamba Galilaya hakukulawa muwoni!” ");
INSERT INTO ziw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Niyo chila yumwenga aita kwe kaya yakwe. ");
INSERT INTO ziw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu niyo aita ko lugulu lwa Mizeituni. ");
INSERT INTO ziw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mtondo wakwe niyo aita vituhu kwe Nyumba nkulu ya Chohile, wantu wose niyo wambasa, naye niyo ekala awahinya. ");
INSERT INTO ziw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wahinya sigilizi na Mafalisayo wamwigaila mvyele yumwenga afingigwe mwe ugonyi, wamchimalisa hagatigati hawo. ");
INSERT INTO ziw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Wamgamba Yesu, “Mhinya! Mvyele yuno kafingwa akagonywa. ");
INSERT INTO ziw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mwe Sigilizi yetu Musa achilagizaga mvyele esavino atoigwe mayuwe. Haluse weye wagaze?” ");
INSERT INTO ziw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Walonga ivyo chani wamtegele, chani wamlahe. Mna Yesu enama hasi, awandika hasi nedidole dyakwe. ");
INSERT INTO ziw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Umo wachimale aho wakamuza, Yesu enuka, awagamba, “Mntu hena masa mgati mwenyu namtowe yuwe dya nkongo.” ");
INSERT INTO ziw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Akaheza enama vituhu, awandika hasi. ");
INSERT INTO ziw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Weze weve ivyo, niyo wakonga kuhalawa yumwe yumwe, wakalongola wadalahala. Yesu niyo asigala ichedu, na yudya mvyele, kachimala ahadya. ");
INSERT INTO ziw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu eze enuke, amuza yudya mvyele, “Wadya wantu wekuhi? Togola, hahali hata yumwenga akukantile?” ");
INSERT INTO ziw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Uyo mvyele niyo amhitula, “Zumbe, hahali hata yumwenga!” Yesu naye amgamba, “Miye nami sahukantile. Hita kwako, na kukongela vino haluse usekudamanya masa vituhu.” ");
INSERT INTO ziw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu eze alonge nawo vituhu, awagamba, “Miye nuyo ulangazi we isi. Mntu yoyose akunitimila miye hajende mwechiza, mna natende na ulangazi wa ujima.” ");
INSERT INTO ziw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mafalisayo wamgamba, “Weye weukwila mwenye, kwaivyo kwelongela kwako siyo chindedi.” ");
INSERT INTO ziw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu awahitula, “Hata hegu nelongela mwenye, ulongelo wangu ni wachindedi kwaviya miye simanya kudya nilaile na kudya hwita. Mna nyuwe hammanyize uko hulawa hegu kudya hwita. ");
INSERT INTO ziw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyuwe mwakanta kwa fanyanyi za chimtu, mna miye sikumkantila mntu. ");
INSERT INTO ziw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Hata hakanta, nkanto dyangu ni dya chindedi kwaviya miye sichedu, Tate, anisigile ehamwenga na miye. ");
INSERT INTO ziw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Iwandikwa mwe Isigilizi yenyu kugamba ukuzi wa wantu waidi ni wachindedi. ");
INSERT INTO ziw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Miye neukwila mwenye, Tate naye anisigile, anukwila ivyo.” ");
INSERT INTO ziw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aho niyo wamwuza, “Tati yako ekuhi?” Yesu awahitula, “Uneva nyuwe hamnimanyize miye iviya hamummanyize Tate.” ");
INSERT INTO ziw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu alongaga milosi iyo mwe chumba che hazina endaga akahinya mwe Nyumba nkulu ya Chohile. Naho hahali mntu amgwile, kwaviya chipindi chakwe chendaga hachinati kubula. ");
INSERT INTO ziw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu niyo awagamba vituhu, “Naita, nanywi namnilonde, mna nambanike mwe masa yenyu. Uko hwita miye nyuwe hamkudaha kubula.” ");
INSERT INTO ziw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Vilongozi wa Wayahudi niyo wagamba, “Togola, nekome mwenye? Ni mbwani agamba, ‘Uko hwita nyuwe hamkudaha kubula?’ ” ");
INSERT INTO ziw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu niyo awagamba, “Nyuwe mlawa ahano hasi, miye silaila kulanga, nyuwe ni we isi ino, miye suyo we isi ino. ");
INSERT INTO ziw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nivyo vikuleka siwagambilani nambanike mwe masa yenyu. Uneva hamnazumile kugamba ‘Miye Nuyo’, nambanike mwa masa yenyu.” ");
INSERT INTO ziw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wowo niyo wamwuza, “Weye ni yuhi?” Yesu ahitula, “Siwagambilani kukongela nkongo! ");
INSERT INTO ziw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nina yalozize ya kulonga, na kuwakantila. Yudya anisigile ni chindedi, miye nami nawagambila wantu wose we isi mbuli ziya du nivile kulaila kwakwe.” ");
INSERT INTO ziw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hawavimanyaga kugamba Yesu endaga akalonga nawo ya Tati yakwe. ");
INSERT INTO ziw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu awagamba, “Umo namheze kumwinula Mwana ywa Mntu, aho naho nammanye kugamba, ‘Miye Nuyo’, naho kugamba sikudamanya chochose kwa udahi wangu, mna nalonga du yadya Tate anihinyize. ");
INSERT INTO ziw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yudya anisigile ehamwenga na miye, uyo hanilekile ichedu kwaviya mazuwa yose nadamanya yadya yakumwelela.” ");
INSERT INTO ziw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Eze alonge ayo wantu walozize niyo wamzumila. ");
INSERT INTO ziw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu niyo awagamba wadya Wayahudi wamzumile, “Uneva mnayatoza mahinyo yangu, namtende wanampina wangu chindedindedi. ");
INSERT INTO ziw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ivyo nammanye chindedi, naho chindedi nachiwalekeileni.” ");
INSERT INTO ziw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wowo wamhitula, “Suwe ni welekwa wa Bulahimu, naho hachinati chitende watumwa wa mntu yoyose yudya. Ni mbwani ukugamba namlekeilwe?” ");
INSERT INTO ziw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu awahitula, “Nawagambilani chindedi, chila mntu yoyose akudamanya masa ni mtumwa ywa masa. ");
INSERT INTO ziw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mtumwa hana wikazi wa mnyumba mazuwa yose, mna Mwana ana wikazi wa mazuwa yoseni. ");
INSERT INTO ziw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Uneva Mwana awalekeileni namtende mlekeilwa chindedi. ");
INSERT INTO ziw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Simanya kugamba nyuwe mwi lukolo lwa Bulahimu. Mna mwaunga mnikome kwaviya hamnati kuzumila mahinyo yangu. ");
INSERT INTO ziw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Miye nalonga yadya anisigile Tate, mna nyuwe mwadamanya yadya mgambilwe ni tati yenyu.” ");
INSERT INTO ziw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wowo wamhitula, “Suwe chi wana wa Bulahimu!” Yesu awagamba, “Uneva nyuwe mwendile wana wa Bulahimu namdamanya saviya adamanye Bulahimu. ");
INSERT INTO ziw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Miye siwagambilani ichindedi nivile kwa Chohile, mna nyuwe mwaunga mnikome. Bulahimu hatendile ivyo! ");
INSERT INTO ziw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nyuwe mwadamanya mbuli iziya adamanye tati yenyu.” Wowo niyo wamgamba, “Suwe hachi wana wa halamu! China Tati yetu yumwenga du nuyo Chohile.” ");
INSERT INTO ziw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu awagamba, “Uneva Chohile endile Tati yenyu chindedi, namkanunga miye, kwaviya miye nasilawa kwa Chohile haluse ni hano. Sizile kwa udahi wangu miye mwenye, mna kwa uyo anisigile. ");
INSERT INTO ziw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ni mbwani hammanyize ayo hulonga? Ni kwaviya hamkudaha kwetegeleza ulosi wangu. ");
INSERT INTO ziw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nyuwe mwi wana wa tati yenyu Mwavu naho mwonga du kudamanya tama za tati yenyu. Uyo endaga mkomi kukongela nkongo, hana uchimailo mwe chindedi, kwaviya chindedi hachimuli mndani mwakwe. Chila aho akulongela lulimi, alonga kulawana na ihali yakwe yo kumbigwa, kwaviya mwenye ni mlulimi naho tati yamntu ywa udanti wose. ");
INSERT INTO ziw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mna kwaviya miye nalonga chindedi, nivyo vikuleka nyuwe hamkunizumila. ");
INSERT INTO ziw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni yuhi mgati mwenyu akudaha kulagisa kugamba miye sidamanya masa? Uneva nalonga chindedi, ni mbwani hamkunizumila? ");
INSERT INTO ziw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mntu ywa Chohile ategeleza mbuli za Chohile, mna nyuwe hamkutegeleza kwaviya nyuwe hamwi wantu wa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wayahudi wamhuluta Yesu wamgamba, “Togola, hachilongile chindedi kugamba weye wi Msamaliya, naho una mpepo?” ");
INSERT INTO ziw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu ahitula, “Miye sina mpepo. Miye namtunya Tate, mna nyuwe hamkunitunya. ");
INSERT INTO ziw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Miye sikwelondela ntunyo yangu mwenye, eyuko yumwenga mta kuilonda ntunyo iyo, uyo ni mkanti. ");
INSERT INTO ziw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nawagambilani chindedi, mntu yoyose akutozesa mahinyo yangu habanike mazuwa yose.” ");
INSERT INTO ziw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wayahudi wagamba, “Weye una mpepo! Bulahimu abanikaga, na wawoni nawo wabanikaga. Nawe wagamba, akutozesa mahinyo yangu habanike mazuwa yose! ");
INSERT INTO ziw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Togola, wetenda mkulu kujinka tati yetu Bulahimu yudya abanikaga, hata wawoni wabanikaga. Weye wetenda wi yuhi?” ");
INSERT INTO ziw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu awahitula, “Hegu nasetunya miye mwenye, ntunyo yangu siyo chintu. Tate yudya nyuwe mkugamba ni tati ywenyu, Chohile nuyo akunitunya. ");
INSERT INTO ziw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nyuwe hamwammanyaga, mna miye simmanya. Mna ninagamba simmanyize, nanitende mlulimi saviya nyuwe. Miye simmanya naho natoza ulosi wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bulahimu, tati yenyu endaga na chinyemi awone idizuwa dyangu dyokwizila, adionaga, niyo elelwa.” ");
INSERT INTO ziw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wayahudi wamgamba, “Weye hunati kubuza mihilimo milongo mishano, weye nawe kumwona Bulahimu?” ");
INSERT INTO ziw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu awagamba, “Nawagambilani chindeni, Bulahimu hanati kwelekwa, ‘Miye Niyaho’ ” ");
INSERT INTO ziw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aho niyo walogota mayuwe chani wamtowe, mna Yesu niyo agila, alawa mwe Nyumba nkulu ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu umo akajinka, niyo amwona mntu yumwenga, tuntu ivyo elekwa. ");
INSERT INTO ziw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wanampina wamuza, “Mhinyi, ni yuhi adamanye masa, mntu yuno, hegu welesi wakwe vilekile elekwe tuntu?” ");
INSERT INTO ziw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu ahitula, “Mbuli ino hailaile kwa chausa cha masa yakwe uyo, hegu masa ya welesi wakwe. Mna elekagwa tuntu chani ndima za Chohile ziwoneke zikadamanya ndima mndani mwakwe. ");
INSERT INTO ziw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kuche nomsi chongigwa chijendeleze kudamanya ndima ya yudya anisigile. Kwaviya chilo cheza hadya mntu hadahe kudamanya ndima. ");
INSERT INTO ziw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Chipindi nichei mwe isi, miye ni ulangazi we isi.” ");
INSERT INTO ziw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Eze alonge ayo, niyo atwa mate hasi, adamanya ntagata, amhaka yudya tuntu mwa meso. ");
INSERT INTO ziw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Amgamba, “Hita ukahake mwe ndiwa ya Silowamu.” Silowamu kugamba ni asigilwe. Aho uyo tuntu niyo aita, akuhaka, akaheza auya akawona. ");
INSERT INTO ziw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wantu we haguhi naye na wadya wammanyize kugamba aho nkongo nanimchiwa akulombeza, wagamba, “Togola, yuno suyo yudya mchiwa nakekala na kulombeza?” ");
INSERT INTO ziw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wamwenga wawo wagamba, “Nuyo.” Mna wamwenga wagamba, “Suyo uyo, mna wata kufanana du.” Yudya endile tuntu agamba, “Ni miye!” ");
INSERT INTO ziw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wamuza, “Haluse meso yako yafungulwa vivihi?” ");
INSERT INTO ziw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Uyo naye awahitula, “Yudya mntu akwitangwa Yesu kadamanya ntagata, anihaka mwa meso, niyo anigamba nite nikahake mwe ndiwa ya Silowamu. Aho miye naita, nahaka, niyo nawona.” ");
INSERT INTO ziw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wamuza, “Uyo ekuhi?” Awahitula, “Miye simanyize!” ");
INSERT INTO ziw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Akaheza wamwigala uyo mntu endaga tuntu kwa Mafalisayo. ");
INSERT INTO ziw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Zuwa idyo Yesu adamanye ntagata na kumfumbula ameso mntu uyo nendile ni zuwa dya Kuhumula. ");
INSERT INTO ziw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mafalisayo niyo wamuza mntu uyo, “Kutenda vivihi niyo wawona?” Mntu uyo awagamba, “Kanihaka ntagata mwa meso, miye nami niyo nahaka haluse nawona.” ");
INSERT INTO ziw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafalisayo watuhu wagamba, “Mntu yuno adamanye ivyo halaile kwa Chohile, kwaviya hakutoza sigilizi ya zuwa dya Kuhumula.” Mna watuhu wagamba, “Mntu mta masa adaha vivihi kudamanya vilagiso savino?” Niyo kwatenda na mahigano mgati mwawo. ");
INSERT INTO ziw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mafalisayo wamuza vituhu uyo mntu endaga tuntu, “Weye wamgaze mntu uyo akufumbule ameso yako?” Mntu uyo awagamba, “Mntu uyo ni muwoni!” ");
INSERT INTO ziw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Vilongozi wa Wayahudi hawakuzumila kugamba mntu uyo endaga tuntu aho nkongo vino haluse awona, kubula hadya weze wawetange welesi wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ivyo wawauza awo welesi, “Togolani, yuno nuyo mwana wenyu mkugamba nakelekwa tuntu? Haluse katenda vivihi awona?” ");
INSERT INTO ziw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Welesi wakwe wahitula, “Suwe chimanya ni mwanetu, naho nakelekwa tuntu. ");
INSERT INTO ziw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mna hachimanyize kawona vivihi, naho hachimmanyize yudya amfumbule ameso. Muzeni mwenye, uyo ni mntu mjima, adaha kwelongela mwenye.” ");
INSERT INTO ziw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Welesi wakwe walonga ivyo kwaviya nawakawogoha vilongozi wa Wayahudi kwaviya vilongozi awo nawevana kugamba mntu yoyose nazumile Yesu ni Kulisito nabalazwe kuse kwe nyumba yo kumvikila Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nivyo vilekile welesi wakwe walongaga kugamba, “Uyo ni mntu mjima, muzeni mwenye.” ");
INSERT INTO ziw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Niyo wamwitanga vituhu yudya endaga tuntu, wamgamba, “Mtogole Chohile! Suwe chimanya kugamba mntu yuno ni mta masa.” ");
INSERT INTO ziw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mntu uyo niyo ahitula, “Uneva ni mta masa, miye simanyize. Mna chintu chimwenga nimanyize, nendaga tuntu, haluse nawona!” ");
INSERT INTO ziw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wamuza, “Kakudamanya chibwani? Kakufumbula vivihi ameso yako?” ");
INSERT INTO ziw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Uyo mntu awahitula, “Siwagambilani kale, nyuwe nanywi hamkwiva. Ni mbwani hamkunga kwiva vituhu? Togolani nyuwe nanywi mwaunga mtende wanampina wakwe?” ");
INSERT INTO ziw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mna wowo niyo wamhitula wakagamba, “Weye wi mwanampina ywakwe, suwe chi wanampina wa Musa. ");
INSERT INTO ziw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Suwe chimanya kugamba Chohile alongaga na Musa, mna mntu yuno hachimmanyize kalawahi!” ");
INSERT INTO ziw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mntu yudya awahitula, “chino ni chilozo! Nyuwe hammanyize uko alaile, mna kanifumbula ameso yangu! ");
INSERT INTO ziw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Chivimanya kugamba Chohile hakuwetegeleza wantu wata masa, mna amwetegeleza yoyose mta kumzumila na kudamanya viya akunga. ");
INSERT INTO ziw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kukongela kumbwa kwe isi hainati kwivika kugamba mntu kamhonya meso mntu elekwa tuntu. ");
INSERT INTO ziw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Uneva mntu uyo halaile kwa Chohile, nahekudaha kudamanya chochose!” ");
INSERT INTO ziw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wowo wamhitula, “Weye kwelekwa na kukwila mwe masa. Vino wadaha vivihi kuchihinya suwe?” Niyo wambalaza mwe nyumba yo kumvikila Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu eva kugamba wambalaza mwe nyumba yo kuvikila yudya mntu amhonyize. Eze amwone, amuza, “Togola, weye wamzumila Mwana ywa Mntu?” ");
INSERT INTO ziw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Uyo mntu ahitula, “Zumbe, nigambila ni yuhi chani nimzumile!” ");
INSERT INTO ziw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu amgamba, “Kuheza kumwona, uyo akulonga na weye haluse nuyo.” ");
INSERT INTO ziw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Uyo mntu agamba, “Zumbe, nazumila!” Niyo amvikila Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu agamba, “Miye siza mwe isi kuwakantila wantu, chani matuntu wawone, na wadya wakufanyanya wawona watende matuntu.” ");
INSERT INTO ziw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafalisayo wamwenga wendaga hamwenga weze weve izimbuli izo, wamuza, “Togola, wachigamba suwe naswi chi matuntu?” ");
INSERT INTO ziw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu awahitula, “Uneva mwendile matuntu, hamwatendile na masa. Mna haluse nyuwe mwagamba, ‘Suwe chawona!’ Ivyo yalagisa kugamba mche na masa.” ");
INSERT INTO ziw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu awagamba, “Nawagambilani chindedi, mntu yoyose hekwingila mwe didewa dye zingoto kwa kujinkila ko lwivi, mna afifinya na kwingila kwa sila ntuhu, uyo ni mbavi, naho ni mpolaganyi. ");
INSERT INTO ziw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mna mntu akwingila kujinkila ko lwivi, uyo nuyo mdimi we zingoto. ");
INSERT INTO ziw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mdima lwivi lwa dewa amvugwila, na ngoto zeva mluzi wa mdimi, naye azitanga izingoto zakwe chila imwenga kwa zina dyakwe na kuzilongoza kuse. ");
INSERT INTO ziw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Akaheza kuzilavya kuse, azilongwela, izingoto nazo zamtimila, kwaviya zimanya umluzi wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ngoto izo hazikudaha kumtimila mjeni, mna zamsumka kwaviya hazimanyize umluzi wakwe.” ");
INSERT INTO ziw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu nakawagambila umliganyo uwo, mna wowo hawamanyize viya nakaunga awagambile. ");
INSERT INTO ziw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu niyo awagamba vituhu, “Nawagambilani chindedi, miye ni lwivi lwa dewa dya ngoto. ");
INSERT INTO ziw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wantu wose wezile sinati kwiza ni wabavi na wapolaganyi, mna izingoto haziwategeleze. ");
INSERT INTO ziw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Miye ni lwivi. Mntu yoyose akwingila kwa kujinkila kwangu nambulwe, nengile na kufosa naho nenkigwe nkande. ");
INSERT INTO ziw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mbavi eza kwa chausa cha kubawa, kukoma na kubalanga. Miye siza mtende na ujima, ujima uchintile. ");
INSERT INTO ziw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Miye ni mdimi ywedi. Mdimi ywedi alavya ujima wakwe kwa chausa cha ngoto zakwe. ");
INSERT INTO ziw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mntu wa kulihwa uyo suyo mdimi, naho ngoto siyo zakwe. Hadya akudiwona ngugwa dyeza, azasa izingoto na kuguluka, akaheza ngugwa dyazigwila na kuzimwagalisa. ");
INSERT INTO ziw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mdimi uyo hasinye izingoto, nanyilike kwaviya ni mta kulihwa du. ");
INSERT INTO ziw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Miye ni mdimi ywedi we izingoto. Sizimanya ngoto zangu, nazo zanimanya. ");
INSERT INTO ziw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Saviya Tate animanyize, nami nivyo nimmanyize. Miye nalavya ujima wangu kwa chausa che zingoto. ");
INSERT INTO ziw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Naho nina ngoto ntuhu hazimuli mwe didewa dino. Vyanunga nizilete izo nazo, nazo nazive umluzi wangu, naho nakutendeke fyo dimwe dya mdimi yumwenga. ");
INSERT INTO ziw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tate anunga kwaviya nalavya ujima wangu chani niuhokele vituhu. ");
INSERT INTO ziw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hahali mntu akunihoka ujima wangu, miye naulavya kwa kunga mwenye. Nina udahi wa kulavya na udahi wa kuuguha vituhu. Ivyo nivyo Tate anisigile nitende.” ");
INSERT INTO ziw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Naho kwatenda na mihigano mgati mwa Wayahudi kwa chausa cha milosi ino Yesu alongile. ");
INSERT INTO ziw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wantu walozize wagamba, “Ana mpepo, naho ni mchilalu! Ni mbwani mkumwetegeleza?” ");
INSERT INTO ziw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mna wantu watuhu wagamba, “Ino siyo milosi ya mta mpepo. Togolani, vino mpepo zadaha kufumbula meso ya matuntu?” ");
INSERT INTO ziw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Uko Yelusalemu kwendaga na ngasu ya kukumbuka usuntwa wa Nyumba nkulu ya Chohile. Chipindi icho ni chipindi cha mpeho. ");
INSERT INTO ziw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu naye nakatalamka mwe nyumba nkulu ya Chohile mwe balaza ya Sulemani. ");
INSERT INTO ziw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wayahudi wamzunguluka, wamuza, “Nauchase na nkama kubula ini? Uneva weye ni weye Kulisito Mkombola, chigambile pwipwipwi.” ");
INSERT INTO ziw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu awahitula, “Siwagambilani, mna hamzumile. Ndima hudamanya kwa zina dya Tate nizo zikunukwila. ");
INSERT INTO ziw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mna nyuwe hamkunga kuzumila kwaviya nyuwe hamwi ngoto zangu. ");
INSERT INTO ziw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ngoto zangu zategeleza izwi dyangu, miye sizimanya, nazo zanitimila. ");
INSERT INTO ziw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Miye nawenke ujima wa mazuwa yose, nawo hawage mazuwa yose, naho hahali mntu nadahe kuwausa mwe mikono yangu. ");
INSERT INTO ziw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tate aninkile awo ni mkulu kujinka wose, naho hahali mntu akudaha kuwalavya mwe mikono yakwe. ");
INSERT INTO ziw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Miye na Tate chiyumwe.” ");
INSERT INTO ziw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wayahudi niyo waguha mayuwe chani wamtowe. ");
INSERT INTO ziw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu awagamba, “Siwalagisani ndima zilozize kulaila kwa Tate. Ni ihi mgati mwe izo ikuwatendani mnitowe mayuwe?” ");
INSERT INTO ziw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wayahudi wamhitula, “Hachikukutowa mayuwe kwa chausa cha ndima zedi udamanye, mna kwa chausa cha kumhuluta Chohile. Weye mwenye wi mntu du mna wetenda Chohile.” ");
INSERT INTO ziw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu awahitula, “Togolani, haiwandikwe mwe chitabu cha Sigilizi zenyu kugamba, ‘Miye silonga nyuwe ni milungu?’ ");
INSERT INTO ziw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chohile kawetanga ‘milungu’ wantu wadya wenkigwe ulosi wakwe, na suwe naswi chimanya kugamba Mawandiko Yakukile yalonga chindedi mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Saviya Tate kanisagula miye, naho kanisigila kwe isi. Nimbwani, mkugamba namhuluta Chohile kwaviya sigamba miye ni Mwana ywa Chohile? ");
INSERT INTO ziw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Uneva sikudamanya ndima ziya Tate akununga nidamanye, msekunizumila. ");
INSERT INTO ziw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mna uneva nazidamanya, hata uneva hamkunizumila miye, zumilani izo izindima, chani mmanye na kukombaganya kugamba Tate ekala mndani mwangu, nami nekala mndani mwa Tate.” ");
INSERT INTO ziw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wajeza kumgwila naho, mna acholopoka mwe mikono yawo. ");
INSERT INTO ziw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu niyo aita vituhu ntendele ya kaidi yo umto wa Yolodani, hadya hantu Yohana endaga akabatiza wantu. Niyo ekala uko. ");
INSERT INTO ziw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Wantu walozize wamwitila wakagamba, “Yohana hadamanye vilagiso vyovyose. Mna yadya yose alongile ya mntu yuno ni chindedi vitendese.” ");
INSERT INTO ziw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wantu walozize aho niyo wamzumila Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mntu yumwenga akwitangwa Lazalo, mkaya wa Besaniya endaga mnyonje. Besaniya wendaga mzi ekale Maliyamu na lumbudye Matha. ");
INSERT INTO ziw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maliyamu nani lumbudye dya Lazalo. Naho nuyo amkulugute Zumbe mavuta ya kupwepweleka mwe viga na kumhangusa ne zifili zakwe. Nani mlukolo ywawo Lazalo endaga mnyonje. ");
INSERT INTO ziw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ivyo awo walumbuze dya Lazalo wasigila ulosi kwa Yesu kugamba, “Zumbe, mbuyaye ukumunga ni mnyonje.” ");
INSERT INTO ziw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu eze eve ivyo, agamba, “Unyonje uwo suwo wa file, mna ulaila chani Chohile atogolwe, kalumwa chani kwa sila iyo Mwana Mntu atogolwe.” ");
INSERT INTO ziw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu nakamunga Matha, lumbudye Maliyamu, hamwenga na Lazalo. ");
INSERT INTO ziw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Eze eve imbuli kugamba Lazalo ni mnyonje, Yesu ajendeleza kwikala hantu aho endaga kwa mazuwa maidi yongezekele. ");
INSERT INTO ziw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Akaheza awagamba wanampina wakwe, “Chiteni vituhu Yudeya!” ");
INSERT INTO ziw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wanampina wamgamba, “Mhinyi, chipindi chijihi du chijinkile Wayahudi nawaunga wakukome kwa mayuwe, weye nawe waunga wite uko vituhu?” ");
INSERT INTO ziw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu ahitula, “Togola, saa za msi sizo mlongo na mbili? Mntu akajenda nomsi hakudaha kukowadika, kwaviya awona ulangazi we isi ino. ");
INSERT INTO ziw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mna mntu akajenda nechilo nakowadike, kwaviya ulangazi haumuli mndani mwakwe.” ");
INSERT INTO ziw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu eze abinde kulonga milosi iyo, awagamba, “Mbuyangu Lazalo kagona, mna miye nanite hamwinule.” ");
INSERT INTO ziw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wanampina wakwe wamgamba, “Zumbe, uneva kagona, nahone.” ");
INSERT INTO ziw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu nakalonga kugamba Lazalo kabanika, mna wanampina wakwe nawakagamba nakalonga mwe kugona ntongo. ");
INSERT INTO ziw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu niyo awagambila pwipwipwi, “Lazalo kabanika. ");
INSERT INTO ziw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mna selelwa kwa chausa chenyu kugamba sendile uko, chani mzumile. Haluse chiteni kwakwe.” ");
INSERT INTO ziw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomaso, yudya akwitangwa pacha awagamba wanampina weyawe, “Chiteni naswi chikabanike hamwenga naye!” ");
INSERT INTO ziw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu eze abule uko, kabwila umwili wa Lazalo wikwa mwe mbila kwa mazuwa mane. ");
INSERT INTO ziw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ikaya ya Besaniya neihaguhi na Yelusalemu, uhale ukubula maili ntatu vino. ");
INSERT INTO ziw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Wayahudi walozize nawabula kwa Matha na Maliyamu wawahongeze kwa kubanika mlukolo ywawo. ");
INSERT INTO ziw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Matha eze eve kugamba Yesu eza, niyo aita akumsingila, mna Maliyamu kasigala kukaya. ");
INSERT INTO ziw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matha amgamba Yesu, “Zumbe, hegu wendile wihano, mlukolo ywangu habanike! ");
INSERT INTO ziw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mna simanya kugamba hata vino haluse chochose noumlombeze Chohile nakwinke.” ");
INSERT INTO ziw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu amgamba, “Mlukolo ywako nauyuke.” ");
INSERT INTO ziw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Matha niyo amhitula, “Simanya,” “kugamba nauyuke mwe zuwa dya udumo.” ");
INSERT INTO ziw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu amgamba, “Miye nuyo uyuso na ujima. Akunizumila miye nekale, hata hegu kabanika, ");
INSERT INTO ziw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","naho chila akwikala na kunizumila habanike mazuwa yose, Togola wayazumila ayo?” ");
INSERT INTO ziw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Matha amgamba, “Heye Zumbe!” Ahitula “Nazumila kugamba weye nuyo Kulisito, Mwana ywa Chohile, yudya akwiza mwe isi.” ");
INSERT INTO ziw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matha eze alonge ayo, niyo aita akumwitanga lumbudye Maliyamu kwa chinyele, na kumgamba, “Mhinyi ehano,” “naho akwitanga.” ");
INSERT INTO ziw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maliyamu eze eve ivyo, niyo asunguza kwinuka ambasa Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu nahanati kwingila mwe kaya, mna nachei ahadya hantu Matha ambwile. ");
INSERT INTO ziw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wayahudi nawemndani hamwenga na Maliyamu wakamhongeza, weze wamwone kenuka akumpukila kuse. Wamtimila wakagamba akwila kwe mbila. ");
INSERT INTO ziw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maliyamu eze abule hantu hadya Yesu endile, eze amwone, amgwela heviga. Amgamba, “Zumbe,” “hegu wandile wihano, mlukolo ywangu habanike!” ");
INSERT INTO ziw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu eze amwone aila, naho eze awawone wadya Wayahudi wendile hamwenga naye nawo waila, niyo engilwa ni mbazi na chinyulu, niyo engilwa ni tumbwaziko mo moyo. ");
INSERT INTO ziw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Niyo awauza. “Mumhamba hahi?” Wamgamba. “Soo uwone, Zumbe,” ");
INSERT INTO ziw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu niyo aila. ");
INSERT INTO ziw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wayahudi wagamba. “Kaulani ivyo amungile!” ");
INSERT INTO ziw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mna wantu watuhu wagamba, “Togola yuno amfumbule ameso yudya tuntu, vino hakudaha Kumtenda Lazalo asekubanika?” ");
INSERT INTO ziw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ivyo Yesu engilwa ni tumbwaziko vituhu mo moyo, abula kwe mbila, mbila yenye neimwe bome naho naigubikwa na yuwe mwe nchili. ");
INSERT INTO ziw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu agamba. “Usani idiyuwe!” Matha, lumbudye dya yudya abanike, amgamba, “Zumbe, akonga kulavya mpofa, kekala mwe mbila mazuwa mane!” ");
INSERT INTO ziw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu amgamba, “Togola sikugambile kugamba ukazumila nauwone ukulu wa Chohile?” ");
INSERT INTO ziw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Niyo wadyusa diya idiyuwe. Yesu niyo asinya kulanga kwembingu na kugamba, “Nakutogola weye, Tate, kwaviya weye waniva. ");
INSERT INTO ziw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Simanya kugamba waniva mazuwa yose, mna silonga ivyo kwaviya wantu wano we hano, chani wazumile kugamba weye ni weye unisigile.” ");
INSERT INTO ziw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eze alonge ivyo, niyo etanga kwa izwi kulu, “Lazalo, fosa kuse!” ");
INSERT INTO ziw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Niyo afosa kuse, kuno katalizwa sanda mwe viga na mwe mikono, naho uso wakwe ugubikwa na kasuche. Yesu awagamba, “Mfunguleni,” “Mumlekeni aite.” ");
INSERT INTO ziw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ivyo Wayahudi walozize wendile wamtalamkile Maliyamu weze wawone mbuli iyo adamanye Yesu, niyo wamzumila. ");
INSERT INTO ziw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mna wamwenga wawo waita kwa Mafalisayo na kuwagambila mbuli Yesu adamanye. ");
INSERT INTO ziw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kwa ivyo Mlavyantambiko mkulu na Mafalisayo waika chitala na kugamba, “Chitende vivihi? Mntu yuno adamanya vilagiso vilozese! ");
INSERT INTO ziw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Chinamleka du ajendeleze, wantu wose nawamzumile, naho vilongozi wa Walumi nawo naweze kuibalanga inyumba yetu ya Chohile na wantu wetu wose!” ");
INSERT INTO ziw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Aho yumwenga ywawo, akwitangwa Kayafa, endaga Mkulu ywa walavyantambiko mo mhilimo uwo, awagamba, “Nyuwe hammanyize chintu! ");
INSERT INTO ziw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Hammanyize kugamba ni vyedi kwenyu mntu yumwenga abanike kwa chausa cha wantu, ukuleka wantu we isi njima wakomwe?” ");
INSERT INTO ziw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Uyo halongile ivyo kwaviya akunga mwenye, mna kwaviya endile Mkulu wa walavyantambiko mo mhilimo uwo, ivyo nakabunkula kugamba Yesu nabanike kwachausa cha hewemzumile Chohile, ");
INSERT INTO ziw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","naho ukubanika kwakwe siyo kwa chausa cha wantu we isi ino du, mna seiviya kwa chausa cha wana wa Chohile wazagale chani waikwe mwe umwe. ");
INSERT INTO ziw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kulaila zuwa idyo vilongozi wa Chiyahudi walonda sila ya kumkoma Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yesu niyo hajendile vituhu mo lumpe mwe isi ya Yudeya, mna kahalawa aho na kwita hantu haguhi na jangwa, mwe mzi ukwitangwa Efulaimu, ekala uko hamwenga na wanampina wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ngasu ye Pasaka ya Wayahudi naihaguhi, ivyo wantu walozize kulaila mwe kaya waita Yelusalemu chani wakelenguse Pasaka hainati. ");
INSERT INTO ziw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nawakamlonda Yesu, weze wadugane hamwenga mwe nyumba nkulu ya Chohile, wauzana, “Mwafanyanya vihi? Heze mwe ingasu?” ");
INSERT INTO ziw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wakulu wa walavyantambiko na Mafalisayo nawasigila kugamba mntu namanye hantu eli Yesu, awagambile chani wamgwile. ");
INSERT INTO ziw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mazuwa mtandatu ye dizuwa dye Pasaka, Yesu niyo abula Besaniya, endaga akekala Lazalo, yudya mntu Yesu amuyusaga. ");
INSERT INTO ziw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Uko na wamwikiya nkande ya chisingi, uyo Matha nendile akawasankanila, Lazalo nendile ni yumwe wa wadya wendaga hamwenga na Yesu hemeza. ");
INSERT INTO ziw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maliyamu niyo aguha nusu lita ya mavuta matana ya yombe kulu, amkuluguta Yesu mwe viga, na kumhangusa kwa fili zakwe. Nyumba yose niyo yamema malashi yedi. ");
INSERT INTO ziw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yuda Isikaliyote, yumwenga mwe wadya wanampina mlongo na waidi yudya akunga amtage Yesu, agamba, ");
INSERT INTO ziw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ni mbwani malashi ayo yasekutagwa kwa hela zilozize na kuwapangila wachiwa?” ");
INSERT INTO ziw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kalonga ivyo, siyo kwaviya naakawaungisisa wachiwa, mna kwaviya na ni mbavi. Nkanana zilozize nakabawa kulaila mndani mwe mpamba iyo. ");
INSERT INTO ziw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mna Yesu agamba, “Mlekeni! Mlekeni ayaike kwa chausa che dizuwa dyo kuhambwa kwangu. ");
INSERT INTO ziw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wachiwa na mtende nawo mazuwa yose, mna hamtende na miye mazuwa yose.” ");
INSERT INTO ziw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wayahudi walozize naweva kugamba Yesu nendile Besaniya, wabula uko, siyo kwa chausa cha kumuwona Yesu mna seivyo nawakaunga kumkaula Lazalo, yudya Yesu amuuyuse. ");
INSERT INTO ziw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ivyo walavyantambiko wakulu wadamanya mzungu wamkome Lazalo naye, ");
INSERT INTO ziw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kwaviya kwa chausa cha Lazalo wayahudi walozize wawahituka vilongozi wawo, niyo wamzumila Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Zuwa dya kaidi, fyo kulu dya wantu wezile kwe zuwa kulu dye Pasaka weva kugamba Yesu nendile mwe sila kwiza Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Waguha matambi ya mitende wafosa wakamsingile, waguta wakagamba, “Chohile ajimbikwe! Ajimbikwe yuno akwiza kwa zina dya Zumbe! Ajimbikwe Seuta ywa Izulaeli!” ");
INSERT INTO ziw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu niyo akwela mwana mwe mpunda, saviya mawandiko yakulonga, ");
INSERT INTO ziw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Msekogoha, wantu wa mzi wa Sayuni! Kaula Seuta ywenyu eza, kakwela mwana mpunda.” ");
INSERT INTO ziw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wanampina wakwe hawabunkule izi mbuli izo nkongo, mna chipindi Yesu eze aheze kutunywa, niyo wakumbuka kugamba mbuli ziya ziwandikwa mwa uyo na viya wamtendile. ");
INSERT INTO ziw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Fyo dya wantu wadya wendile hamwenga na Yesu umo amwitangaga Lazalo kulaila mwe mbila niyo amuuyusa waukula mbuli zilaile. ");
INSERT INTO ziw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ivyo nivyo vilekile fyo dya wantu wamsingila, kwaviya wose weva kugamba Yesu nendile kadamanya chilagiso icho. ");
INSERT INTO ziw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mafalisayo niyo wagambilana, “Mwawona, Hachikudaha ng'o! Kaulani, isi yose wamtimila!” ");
INSERT INTO ziw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hendaga na Wagiliki wamwenga mgati mwa wantu waitile Yelusalemu kuvika mwe ngasu iyo. ");
INSERT INTO ziw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Awo niyo wamwitila Filipo mkaya ywa Betisaida mwe isi ya Galilaya, wagamba, “Mkulu, chaunga chimwone Yesu.” ");
INSERT INTO ziw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo aita, amgambila Anduleya, wowo nawo waidi waita wamgambila Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu awagamba, “Saa ya kutunywa kwa Mwana ywa Mntu ibula. ");
INSERT INTO ziw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nawagambilani chindedi, mpuluzi ya ngano yasigala mpuluzi du mna hadya ikugwela mo ulongo nakubanika. Uneva inabanika, yeleka matunda yalozize. ");
INSERT INTO ziw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Akunga wikazi wakwe nawaze, akwihiwa wikazi wakwe mwe isi ino nawike kwa chausa cho ujima wa mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Akunga anisankanile aungwa anitimile, ivyo nuko kugamba hohose hadya na nitendeke miye naho no mndima ywangu natende. Na Tate namtunye mntu yoyose akunisankanila. ");
INSERT INTO ziw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Haluse muye wangu wehelwa, nanigambe mbwani? Nigambe, ‘Tate, nambula mwe mbuli na zinizile mwe saa ino’? Mna nivyo vikuleka siza chani nijinke mwe isaa ino. ");
INSERT INTO ziw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tate, ditunye idizina dyako!” Aho izwi dyevika kulaila kwembingu, “Situnya, naho naniditunye vituhu.” ");
INSERT INTO ziw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Fyo dya wantu wendile wachimala aho weva izwi idyo, wamwenga wawo wagamba ni mlulumo, wamwenga wagamba, “Mndima ywa kwembingu kalonga naye!” ");
INSERT INTO ziw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mna Yesu niyo awagamba, “Izwi idyo hadivike kwa chausa changu miye, mna kwa chausa chenyu. ");
INSERT INTO ziw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Haluse nicho chipindi che isi ino kukantilwa, haluse Ibilisi, zumbe ywe isi ino naalagazwe. ");
INSERT INTO ziw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Miye nami naninulwe kulanga kulaila hasi he isi nanimkwese chila yumwenga kwangu.” ");
INSERT INTO ziw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kwa kulonga ivyo kalagisa nabanike vivihi. ");
INSERT INTO ziw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Fyo idyo niyo dyamhitula, “Suwe chagambilwa ni sigilizi yetu kugamba Kulisito nekale mazuwa yose, haluse wadaha vivihi kugamba Mwana Mntu aungwa enulwe? Uyo Mwana Mntu ni yuhi?” ");
INSERT INTO ziw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu awagamba, “Ung'azi uchei na nyuwe kwa chipindi chiguhi, talamkani mche mnanawo uwo ung'azi chani chilo chise kuwabwila, kwaviya akutalamka mwe chiza hamanyize uko akwita. ");
INSERT INTO ziw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Umo mnanawo uwo ung'azi uzumileni chani mtende wantu wa ung'azi.” Eze alonge imilosi iyo, Yesu niyo ahalawa hekumanya aita hekukumanyika. ");
INSERT INTO ziw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hatahegu Yesu na kadamanya mpituko ino yose mwa meso yawo, wowo hawamzumile. ");
INSERT INTO ziw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ivyo milosi alongile muwoni Isaya niyo yalaila; “Zumbe ni yuhi auzumile ulosi wetu? Naho udahi wa Zumbe ugubulwa kwa yuhi?” ");
INSERT INTO ziw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ivyo hawadahile kuzumila kwaviya Isaya nakalonga vituhu, ");
INSERT INTO ziw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Chohile kajela utuntu ameso yawo, kazibalanga izifanyanyi zawo, wasekuwona kwa meso yawo, wasekumanya kwa fanyanyi zawo, naho wasekunihitukila, alonga Zumbe, chani niwahonye.” ");
INSERT INTO ziw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya kalonga imilosi ino kwaviya kauwona ukulu wa Yesu, niyo alonga mbuli zakwe. ");
INSERT INTO ziw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mna vilongozi walozize Wayahudi niyo wamzumila Yesu, mna kwachausa cha Mafalisayo, hawalongile holumpe kwa kogoha kugamba na wasentwe ne nyumba yo kuvikila. ");
INSERT INTO ziw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nawaungisa kutogolwa ni wantu kujinka kutogolwa ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Aho Yesu aguta, “Mntu akunizumila miye, hakunizumila miye du, mna amzumila yudya anisigile. ");
INSERT INTO ziw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Akuniwona miye amwona na uyo anisigile. ");
INSERT INTO ziw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Miye ni ung'azi nami siza mwe isi chani wose wakunizumila wasekusigala mwe ichiza. ");
INSERT INTO ziw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Akwiva ulosi wangu mna hakuutoza, miye sanimkantile kwaviya sizile nikantile wantu we isi mna kwikombola. ");
INSERT INTO ziw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Hekutoza ulosi wangu ananaye wakumkantila, ulosi udya nilongile ni mkanti ywakwe zuwa dyo udumo. ");
INSERT INTO ziw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Miye silongile kwa udahi wangu mwenye, mna Tate nuyo anisigile nilonge mbwani naho nilonge vivihi. ");
INSERT INTO ziw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Miye nami simanya kugamba sigilizi yakwe yegala ujima wa mazuwa yose. Miye nalonga du yadya Tate anisigile niyalonge.” ");
INSERT INTO ziw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nendile ni zuwa heinati kubula ngasu ya Pasaka. Yesu nakamanya kugamba chipindi chakwe cho kuhalawa he isi kwita kwa Ise chibula, nakawaungisa mazuwa yose wantu wakwe we mwe isi, chindedi na nakawaungisa. ");
INSERT INTO ziw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu na wanampina wakwe nawekala wakadya nkande ya chisingi. Mwavu nakamjela kale Yuda mo moyo wakwe, mwana Simoni Isikaliyote nkwina ya kumtaga Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu nakamanya kugamba Tati ywakwe nendile kamwinka udahi woseni, nakugamba uyo mwenye alailaga kwa Chohile naho auya kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Niyo ahalawa hemeza, avula isuche yakwe ya kuse, efunga mkumbulu mwe chigudi. ");
INSERT INTO ziw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Akaheza ajela mazi mwe lwiga akonga kuwahaka wanampina wakwe iviga na kuwahangusa kwa udya mkumbulu efungile mwe chigudi. ");
INSERT INTO ziw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ambwila Simoni Petulo, uyo amgamba, “Zumbe, weye wanihaka iviga vyangu miye?” ");
INSERT INTO ziw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu amhitula, “Hukumanya haluse chino hudamanya, mna nauvimanye aho nyumani.” ");
INSERT INTO ziw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petulo amgamba, “Weye honihake iviga ng'o!” Yesu amhitula, “Sinakuhakile iviga vyako.” “Hotende na umbuya na miye.” ");
INSERT INTO ziw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petulo amhitula, “Zumbe, use kunihaka iviga ivyodu, naho! Nihaka imikono yangu no mtwi, nawo!” ");
INSERT INTO ziw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu amgamba, “Ahakile kale hakungwa ahake, mna mwe viga du. Kwaviya mwili wakwe mjima ulenguka, nyuwe mlenguka mna sawo nyoseni.” ");
INSERT INTO ziw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu nakammanya yudya akunga amtage, nivyo vikuleka akagamba, “Nyuwe woseni, ukaleke yumwenga, Mlenguka.” ");
INSERT INTO ziw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu eze aheze kuwahaka iviga, niyo avala vituhu isuche yakwe ekala mwe meza, awauza, “Togolani, mbunkula yano niwatendileni?” ");
INSERT INTO ziw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Nyuwe mwanitanga Mhinyi na Zumbe, nanywi mwalonga vyedi, kwaviya nivyo nili. ");
INSERT INTO ziw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Iviya miye ni Zumbe na Mhinyi wenyu, siwahakani nyuwe iviga. Nyuwe mwaungwa mhakane wenye iviga. ");
INSERT INTO ziw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Siwenkani mliganyo, chani nyuwe nanywi mdamanye savino niwadamanyizeni. ");
INSERT INTO ziw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nawagambilani chindedi, mtumwa suyo mkulu kujinka mkulu wakwe, naho msigilwa suyo mkulu kujinka yudya amsigile. ");
INSERT INTO ziw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Haluse mmanya imbuli ino, mnaidamanya namjimbikwe. ");
INSERT INTO ziw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Sikulonga mwa nyuwe woseni, siwamanya wadya nisagule. Mna yaungwa yano yakulongwa mwa Mawandiko Yakukile yachinte, ‘Yudya endile hadya hamwenga naye kanihituka.’ ");
INSERT INTO ziw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nawagambilani nyuwe vino haluse mbuli zino hazinati kulaila, chani umo zikeza kulaila, mzumile kugamba ‘Miye Nuyo.’ ");
INSERT INTO ziw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nawagambilani chindedi, akumhokela yudya humsigila anihokela miye, naho akunihokela miye amhokela yudya anisigile.” ");
INSERT INTO ziw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu eze aheze kulonga ivyo, niyo engilwa ni tumbwaziko ditendese mo moyo, alonga ho lumpe, “Nawagambilani chindedi, yumwe ywenyu nanihituke!” ");
INSERT INTO ziw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wanampina niyo wasinyana, kwaviya hawamanyize amlonga yuhi. ");
INSERT INTO ziw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mwanampina yumwenga, yudya Yesu nendile akamungisa, nendile kamwegamila Yesu hadya he nkande. ");
INSERT INTO ziw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Petulo amdakula na kumgamba, “Muze, amlonga yuhi.” ");
INSERT INTO ziw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mwanampina uyo asogela haguhi vitendese na Yesu amuza, “Zumbe, ni yuhi?” ");
INSERT INTO ziw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu amhitula, “Yudya nanimwinke kabesu ka mgate nitwezize mwe chiya, nuyo.” Ivyo aguha kabesu ka mgate, akatweza mwe chiya, amwinka Yuda, mwana ywa Simoni Isikaliyote. ");
INSERT INTO ziw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda Isikalioti eze ahokele akabesu ako ko mgate, Shetani niyo amwingila. Yesu amgamba, “Chiya ukunga udamanye sunguza uchidamanye!” ");
INSERT INTO ziw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mna hahali hata yumwenga mwe wadya wekale hadya hemeza amanyize ni mbwani Yesu kamlonga ivyo. ");
INSERT INTO ziw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwaviya Yuda nuyo endile akaika mkwiji we mpamba, wamwe wawo nawakafanyanya kugamba Yesu nakamgamba agule vikungwa mwe dizuwa idyo, hegu kugamba nakamgamba akalavye chochose kwa wachiwa. ");
INSERT INTO ziw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda Isikalioti eze aguhe kadya akabesu ko mgate niyo afosa kuse aho. Nendile ni nechilo. ");
INSERT INTO ziw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda Isikalioti eze ahalawe, Yesu agamba, “Haluse ukulu wa Mwana ywa Mntu ulagiswa, haluse ukulu wa Chohile nawo ulagiswa kwa sila yakwe. ");
INSERT INTO ziw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Naho uneva ukulu wa Chohile ugubulwa kwa sila yakwe, ivyo Chohile naugubule ukulu wa Mwana ywa Mntu mndani mwakwe mwenye, na adamanye ivyo aho. ");
INSERT INTO ziw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wanangu, nichei na nyuwe kwa chipindi chijihi du. Na mnilonde, mna haluse nawagambilani yadya nihezize kuwagambila vilongozi wa Wayahudi, ‘Nyuwe hamdahe kwita uko hwita miye.’ ");
INSERT INTO ziw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nawenkani sigilizi mpya, unganani. Saviya miye niwaungileni nyuwe, chani mungane wenye. ");
INSERT INTO ziw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wantu wose nawamanye kugamba nyuwe mwi wanampina wangu, uneva mkaungana wenye.” ");
INSERT INTO ziw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petulo amuza, “Zumbe, waita nahi?” Yesu amhitula. “Hukudaha kunitimila uko hwita,” “Mna na unitimile nyumani.” ");
INSERT INTO ziw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petulo amgamba, “Zumbe, ni mbwani sikudaha kukutimila haluse?” “Miye semalanya kale nilavye ujima wangu kwa chausa chako!” ");
INSERT INTO ziw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu amhitula, “Togola, wadaha chindedi ulavye ujima wako kwa chausa changu? Nakugambila chindedi, zogolo hadinati kwila nonihituke nkanana ntatu!” ");
INSERT INTO ziw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu niyo awagambila wanampina wakwe. “Msekwehelwa mwe myoyo yenyu,” “Mwamzumila Chohile ni zumilani miye. ");
INSERT INTO ziw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mwe nyumba ya Tate mna wikazi ulozize, hegu havyatendile ivyo sawagambileni seivyo. Nakuwaikiani hantu. ");
INSERT INTO ziw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Miye haheza kwita kuwaikiyani hantu, nanuye niwaguhani, chani nanywi mtende hadya nili. ");
INSERT INTO ziw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Sila ikwita uko hwita muimanya.” ");
INSERT INTO ziw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaso amgamba, “Zumbe, hachimanyize uko ukwita, Nachimanye vivihi isila yo kwitila uko?” ");
INSERT INTO ziw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu amhitula, “Miye niyo isila, chindedi, na ujima, hahana akudaha kwita kwa Tate hanajinkile kwangu. ");
INSERT INTO ziw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Awagamba, Uneva mwanimanyize miye,” “namummanya Tate naye, kukongela haluse mummanya naho mumwona kale.” ");
INSERT INTO ziw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo amgamba, “Zumbe, chilagise Tate, icho nicho chikunga.” ");
INSERT INTO ziw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu amgamba, “Sikala na nyuwe chipindi chitali chose, nawe Filipo hunati kunimanya, Filipo? Mntu yoyose aniwone miye kamwona Tate. Haluse ni mbwani, naho, ukugamba, ‘Chilagise Tate’? ");
INSERT INTO ziw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Togola, hukuzumila, Filipo, kugamba miye ni mndani mwa Tate naye Tate emndani mwangu? Yesu awagamba, Milosi huwagambilani,” “sikuilonga kwa udahi wangu. Tate, emndani mwangu, adamanya ndima yakwe. ");
INSERT INTO ziw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mwaungwa mnizumile halonga kugamba miye nimndani mwa Tate naye Tate emndani mwangu. Uneva sivyo ivyo, zumilani kwa ndima hudamanya. ");
INSERT INTO ziw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nawagambilani chindedi, akunizumila nadamanye mbuli hudamanya miye heye, nadamanye hata nkulu kujinka, kwaviya naita kwa Tate. ");
INSERT INTO ziw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Chochose namlombeze kwa zina dyangu, nanidamanye chani Tate atunywe kujinkila ko Mwana. ");
INSERT INTO ziw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mkanilombeza chochose kwa zina dyangu, nanidamanye. ");
INSERT INTO ziw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Uneva mkanunga, namtoze malagizo yangu. ");
INSERT INTO ziw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Miye nami nanimlombeze Tate, ivyo naye nawenkeni mwambizi mtuhu, yudya nekale nanyuwe mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Uyo ni Muye Ukukile akugubula chindedi cha Chohile. Wantu we isi hawakudaha kumhokela, kwaviya hawakudaha kumwona hegu kummanya. Mna nyuwe mummanya, kwaviya ekala na nyuwe naho emndani mwenyu. ");
INSERT INTO ziw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Saniwaseni ichedu, naniwawiyeni. ");
INSERT INTO ziw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hasigala hadodo wantu we isi ino hawaniwone vituhu, mna nyuwe namniwone, na kwaviya miye ni mjima, nyuwe nanywi namtende wajima. ");
INSERT INTO ziw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Zuwa diya dikabula, nammanye kugamba miye ni mndani mwa Tate nanyuwe nanywi mwi mndani mwangu, na miye nimndani mwenyu. ");
INSERT INTO ziw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Wantu wakuhokela malagizo yangu na kuyatoza awo nawo wakununga miye. Tate nawamunge wadya wakununga, miye nami naniwaunge na kwegubula kwawo.” ");
INSERT INTO ziw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda nuyo Yuda Isikaliyote awagamba, “Zumbe, neidahike vivihi weye kwelavyanya kwetu siyo kwa wantu we isi?” ");
INSERT INTO ziw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu amhitula, “Mntu akununga natoze mahinyo yangu. Tate namunge, naho Tate na miye nachize kwakwe kwikala naye. ");
INSERT INTO ziw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mntu he kununga hakutoza mahinyo yangu. Naho mahinyo mwivile sayo yangu, mna ni ya Tate, anisigile. ");
INSERT INTO ziw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Siwagambilani mbuli zino nichei hamwenga na nyuwe. ");
INSERT INTO ziw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mwambizi, Muye Ukukile, yudya Tate namsigilaga kwa zina dyangu, nawahinyeni chila chintu na kuwakumbusani yadya niwagambileni. ");
INSERT INTO ziw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nawasizani utondowazi, nawenkani utondowazi wangu mwenye. Sikuwenkani nyuwe saviya wantu we isi wakutenda. Msekutumbwazika mwe myoyo yenyu, naho msekogoha. ");
INSERT INTO ziw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mniva hawagambani, ‘Naita zangu, mna nani wawiyeni vituhu.’ Uneva mwanungile, namwelelwa kugamba naita kwa Tate, kwaviya Tate ni mkulu kujinka miye. ");
INSERT INTO ziw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Siwagambilani imbuli ino haluse hainati kulaila, chani umo ikalaila, mzumile. ");
INSERT INTO ziw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sanilonge nanywi vituhu mbuli zilozize, kwaviya mkulu ywe isi eza. Hana udahi mwangu, ");
INSERT INTO ziw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","mna wantu we isi ino waungwa wamanye kugamba namunga Tate, nivyo vikuleka nadamanya chila chintu saviya anisigile. “Chimalani, chihauke hano. ");
INSERT INTO ziw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Miye ni mzabibu wa chindedi, Tate nuyo mlimi. ");
INSERT INTO ziw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Chila tambi mndani mwangu hedikweleka matunda uyo adyusa, chila tambi dikweleka, adisaswila dikale hatana chani dyelekese. ");
INSERT INTO ziw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nyuwe mlenguka kale kwa chausa cha yadya mahinyo niwagambileni. ");
INSERT INTO ziw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ikalani mndani mwangu, miye nami nikale mndani mwenyu. Tambi hadikudaha kweleka matunda hadinasigale mo mzabibu. Seivyo nyuwe nanywi hamkudaha kweleka matunda hamnekale mndani mwangu. ");
INSERT INTO ziw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Miye ni mzabibu, na nyuwe mwi matambi. Akwikala mndani mwangu, nami hekala mndani mwakwe, eleka matunda yalozize, kwaviya hamkudaha kudamanya chochose hamnatendile na miye. ");
INSERT INTO ziw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mntu yeyose hanekale mndani mwangu adulwa kuse saviya tambi dikudulwa kuse niyo dyanyala, tambi saidyo wadilogota na kudidula mo moto, chani dihye. ");
INSERT INTO ziw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mnekala mndani mwangu, na milosi yangu inekala mndani mwenyu, lombezani chochose mkunga, nanywi namwingwe. ");
INSERT INTO ziw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tate atunywa uneva mkeleka matunda yalozize, na kutenda wanampina wangu. ");
INSERT INTO ziw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Saviya Tate akununga, miye nawaungani saivyo, ikalani mwe ungi wangu. ");
INSERT INTO ziw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Uneva mkatoza malagizo yangu, namwikale mwe ungi wangu, saviya miye hutoza malagizo ya Tate na kwikala mwe ungi wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Siwagambilani izimbuli izo chani chinyemi changu chikale mndani mwenyu na chinyemi chenyu nacho chichinte. ");
INSERT INTO ziw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ino niyo sigilizi yangu, mungane, saviya niwaungileni nyuwe. ");
INSERT INTO ziw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hahana mta ungi mkulu ukujinka ungi wa mntu akulavya ujima wakwe kwa chausa cha wambuya zakwe. ");
INSERT INTO ziw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na nyuwe mwi wambuya zangu uneva mkadamanya yadya niwasigileni. ");
INSERT INTO ziw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nyuwe sikuwetangani wandima vituhu, kwaviya mndima hamanyize chikudamanywa ni zumbe dyakwe. Mna, miye siwetangani nyuwe wambuya, kwaviya siwagambilani yose yadya nimwivile Tate. ");
INSERT INTO ziw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nyuwe hamnisagule miye, mna miye siwasagulani nyuwe na kuwasigila mwite mkeleke matunda, matunda yadya yakwikala. Tate naye nawenkeni chochose namlombeze kwa zina dyangu. ");
INSERT INTO ziw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Dino, nidyo, lagizo dyangu huwenkani, Mungane. ");
INSERT INTO ziw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Uneva wantu we isi ino wanawaihiwani nyuwe, mmanye kugamba nawakonga kunihiwa miye. ");
INSERT INTO ziw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Hegu mwendile ni wantu we isi, isi naiwawaungani nyuwe sa wantu wakwe. Mna miye siwasagulani mgati mwe isi, nivyo vikuleka wantu we isi wakuwaihiwani. ");
INSERT INTO ziw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kumbukani yadya niwagambileni, ‘Mtumwa suyo mkulu kujinka zumbe dyakwe.’ Uneva wantu wanisulumiza miye, nawawasulumize nyuwe nanywi, naho uneva watoza mahinyo yangu, nawatoze mahinyo yenyu. ");
INSERT INTO ziw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mna nawawadamanyizeni nyuwe kwaviya mwi wangu, kwaviya hawammanyize yudya anisigile. ");
INSERT INTO ziw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Uneva sezile na kulonga nawo nahewana masa, mna haluse hawakudaha kwegombela kugamba hawana masa. ");
INSERT INTO ziw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mntu akunihiwa miye amwihiwa na Tate. ");
INSERT INTO ziw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Uneva sadamanye kwawo mbuli ziya hehali mntu mtuhu azidamanye nkongo, nahawena masa, mna haluse wayawona yadya nidamanye, niyo wanihiwa miye hamwenga na Tate. ");
INSERT INTO ziw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yano, yalaila chani yadya yawandikwe mwe Sigilizi yawo yachinte, ‘Wanihiwa vya bule.’ ");
INSERT INTO ziw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Aho akwizila Mwambizi Muye, nikunga nimsigile kwenyu kulaila kwa Tate. Muye Ukukile wa chindedi akulaila kwa Tate, naukule chindedi chikununga miye. ");
INSERT INTO ziw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nyuwe nanywi, ivyo namukule chindedi chikununga miye kwaviya namna miye kukongela nkongo. ");
INSERT INTO ziw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Siwagambilani ayo, chani msekuleka uzumizi wenyu. ");
INSERT INTO ziw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wantu nawawabalazeni mwe zinyumba zawo za kumvikila Chohile, naho chipindi cheza hadya chila akuwakomani nyuwe nagambe amsankanila Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nawawadamanyizeni mbuli zino kwaviya hawammanyize Tate hegu hawanimanyize miye. ");
INSERT INTO ziw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mna siwagambilani mbuli zino, chani umo wakakonga kudamanya ayo, mkumbuke kugamba nawagambilagani. “Siwagambileni mbuli zino kukongela nkongo, kwaviya nanihamwenga na nyuwe. ");
INSERT INTO ziw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mna haluse naita kwa yudya anisigile, naho hahali yumwe ywenyu akunuza, waitahi? ");
INSERT INTO ziw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kwaviya siwagambilani mbuli zino, myoyo yenyu imema chinyulu. ");
INSERT INTO ziw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mna nawagambilani chindedi, nanivyedi miye nite, kwaviya sinaitile, Mwambizi heze kwenyu. Mna uneva ninaita nanimwigale kwenyu. ");
INSERT INTO ziw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Uyo aho akwizila, nawalavyanyize wantu we mwe isi kugamba fanyanyi zawo sizo za chindedi mwa masa yawo na kanto dya Chohile akunga akantile wantu. ");
INSERT INTO ziw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Waga mwe mbuli ya masa, kwaviya hawanizumile, ");
INSERT INTO ziw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","waga mwe mbuli iwoneke yedi kulongozi kwa Chohile, kwaviya naita kwa Tate na nyuwe hamniwone vituhu, ");
INSERT INTO ziw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","waga mwe mbuli ya kanto, kwaviya mkulu ywe isi ino kaheza kale kukantilwa. ");
INSERT INTO ziw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nina yalozize yakuwagambilani, mna kwa haluse hamkudaha kuyajijimiza. ");
INSERT INTO ziw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mna seivyo, aho, akwizila uyo Muye Ukukile, akugubula chindedi cha Chohile, nawalongoze mmanye chindedi chose. Uyo halonge kwa udahi wakwe mwenye, mna nalonge ayo neve na kuwagambilani yadya nayeze. ");
INSERT INTO ziw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Uyo nanitunye miye, kwaviya nawagambileni yadya nahokele kulaila kwangu. ");
INSERT INTO ziw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Vyose ananavyo Tate ni vyangu, nivyo vikuleka silonga kugamba uyo Muye Ukukile nawagambileni yadya yakulaila kwangu. ");
INSERT INTO ziw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Chipindi chidodo hamniwone, na vikajinka chipindi chidodo namniwone.” ");
INSERT INTO ziw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wamwenga wa wanampina wakwe wauzana, “Agaze? Akachigamba chipindi chidodo hachimwone, na vikajinka chipindi chidodo nachimwone, naho agamba, ‘Kwaviya naita kwa Tate.’ ");
INSERT INTO ziw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ivyo wauzana, agaze? ‘Chipindi chidodo’? Hachikumanya alonga mbwani!” ");
INSERT INTO ziw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu nakamanya kugamba nawakaunga wamuze, ivyo awagamba, “Mwauzana mbuli ya ziya nilongile, ‘Chipindi chidodo hamniwone, na chipindi chidodo na mniwone.’ Vino nivyo mkuzana mgati mwenyu? ");
INSERT INTO ziw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nawagambilani chindedi, nyuwe namwile na kulomboleza, mna wantu we isi nawelelwe, namwone chinyulu, mna chinyulu chenyu nachihituke chinyemi. ");
INSERT INTO ziw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hadya mvyele akunga efungule, eva usungu kwaviya chipindi chakwe cho kwefungula chibula. Mna akaheza kwefungula, hakukumbuka usungu wakwe, kwaviya ana chinyemi kugamba katiti kelekwa mwe isi. ");
INSERT INTO ziw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nyuwe nanywi mna usungu haluse, mna naniwezileni vituhu, nanywi nammeme chinyemi mwe myoyo yenyu, na chinyemi icho hahali mntu nadahe kuchusa kwenyu. ");
INSERT INTO ziw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Zuwa idyo dikabula, hamnilombeze chochose. Nawagambilani chindedi, chochose namumlombeze Tate kwa zina dyangu nawenkeni. ");
INSERT INTO ziw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hata vino haluse hamnati kulombeza chochose kwa zina dyangu, lombezani nanywi namhokele, chani chinyemi chenyu chichinte. ");
INSERT INTO ziw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Siwagambilani mbuli izo kwa miliganyo. Mna chipindi nachize umo sanilonge nanyuwe vituhu kwa miliganyo, mna naniwagambileni pwipwipwi mbuli ya Tate. ");
INSERT INTO ziw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Zuwa idyo aho dikwizila, namumlombeze Tate kwa zina dyangu, miye sikulonga kugamba naniwalombezeze kwa Tate, ");
INSERT INTO ziw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kwaviya Tate mwenye awaungani nyuwe. Awaunga kwaviya nyuwe mnunga miye naho mzumilani kugamba silawa kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Miye nalawaga kwa Tate, niyo neza mwe isi, haluse nayasa isi nauya kwa Tate.” ");
INSERT INTO ziw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Elo wanampina wakwe wamgamba, “Haluse walonga pwipwipwi vitendese, hwikujela mliganyo. ");
INSERT INTO ziw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Haluse chimanya kugamba weye kumanya chila chintu, hachunge mntu akuze mbuli yoyose. Vino vyachitenda chizumile kugamba walawaga kwa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu awahitula, “Haluse mwazumila? ");
INSERT INTO ziw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Chipindi cheza, naho chibula kale, hadya nyuwe nyose namwaganikane, chila mntu kwakwe, miye nami nanasigwe ichedu. Mna miye sichedu, kwaviya Tate ehamwenga na miye. ");
INSERT INTO ziw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Siwagambilani mbuli zino chani mtende na utondowazi mo kulungana na miye. Wantu we isi nawawatende mkunte. Mna kwenkeni moyo! Miye isi siihuma!” ");
INSERT INTO ziw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu eze alonge ivyo, kenula ameso kulanga kwembingu, na kugamba, “Tate, chipindi chibula! Mtunye Mwanawo, chani naye akutunye. ");
INSERT INTO ziw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kwaviya nakumwinka udahi mwa wantu wose, chani awenke ujima wa mazuwa yose wadya wose umwinkile. ");
INSERT INTO ziw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ujima wa mazuwa yose ni kukumanya weye, Chohile ywa chindedi, naho wammanye Yesu Kulisito umsigile. ");
INSERT INTO ziw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Miye sikutunya muno mwe isi, sibinda indima uninkile niidamanye. ");
INSERT INTO ziw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Haluse Tate, nitunya kulongozi kwako, ntunyo seidya nendile ninanayo hadya isi heinati kumbwa. ");
INSERT INTO ziw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Sikutenda umanyike kwa wantu wadya uninkile mwe isi. Nendile ni wako, niyo waninka watende wangu. Nawo watoza ulosi wako, ");
INSERT INTO ziw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","haluse wavimanya kugamba chila uninkile chilaila kwako. ");
INSERT INTO ziw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Miye siwenka udya ulosi uninkile, nawo wauzumila, wamanya kugamba chindedi silawa kwako, naho wazumila kugamba weye nakunisigila. ");
INSERT INTO ziw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nawalombezeza wowo. Sikulombezeza isi mna wadya wantu uninkile, kwaviya ni wako. ");
INSERT INTO ziw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yose ninanayo ni yako, na yose unanayo ni yangu, naho ntunyo yangu iwoneka mwa awo uninkile. ");
INSERT INTO ziw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Haluse miye neza kwako, simuli muno mwe isi, mna wowo wachei mwe isi. Tate Mkuka! Wadime kwa udahi wa zina dyako, diya zina uninkile, chani watende umwe saviya suwe chi umwe. ");
INSERT INTO ziw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Hadya nendile ni hamwenga nawo, miye nasiwadima kwa udahi wa zina dyako, zina uninkile. Miye siwadima, naho hahali hata yumwenga ywawo agile, mna yudya mntu asagulwe chani age chani Yakukile yachinte. ");
INSERT INTO ziw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Haluse neza kwako, nasilonga mbuli zino nichei mwe isi chani chinyemi changu chichinte mwe myoyo yawo. ");
INSERT INTO ziw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Miye siwenka ulosi wako, nawo wantu we isi wawehiwani, kwaviya sawo wantu we isi, saviya miye suyo ywe isi. ");
INSERT INTO ziw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Sikulombeza uwause mwe isi, mna nalombeza uwadime na yudya Mwavu Shetani. ");
INSERT INTO ziw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wowo sawo we isi, saviya miye nami suyo ywe isi. ");
INSERT INTO ziw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uwalenguse mwe chindedi, ulosi wako ni chindedi. ");
INSERT INTO ziw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Saviya unisigile mwe isi, miye nami siwasigila wowo mwe isi. ");
INSERT INTO ziw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nelengusa mwenye chindedi kwako kwachausa chawo, chani wowo, nawo, welavye kwako. ");
INSERT INTO ziw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Sikuwalombezeza awo du, mna nawalombezeza wose nawanizumile kwa ulosi wawo. ");
INSERT INTO ziw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nalombeza chani wose watende wamwenga. Tate! Nalombeza wekale mndani mwetu, saviya weye ukwikala mndani mwangu miye nami nekala mndani mwako. Nalombeza watende wamwenga, chani wantu we isi wazumile kugamba ni weye unisigile. ");
INSERT INTO ziw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Miye siwenka ntunyo idya uninkile miye, chani watende wamwenga, saviya suwe chi wamwenga. ");
INSERT INTO ziw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Miye mndani mwawo na weye mndani mwangu, chani umwenga wawo uchintise, wantu we isi wamanye kugamba weye nakunisigila naho kugamba wawaunga saviya ukununga miye. ");
INSERT INTO ziw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tate! Naunga awo uninkile, naho naunga watende hamwenga namiye hantu hadya nili, chani wawone ntunyo yangu, ntunyo idya uninkile, kwaviya nakununga kukongela isi hainati kumbwa. ");
INSERT INTO ziw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tate Ywedi, wantu we isi hawakumanyize, mna miye sikumanya, naho wamanya kugamba ni weye unisigile. ");
INSERT INTO ziw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Sikutenda wakumanye, naho nanijendeleze kutenda ivyo, chani ungi udya ukununga utende mndani mwawo, nami nikale mndani mwawo.” ");
INSERT INTO ziw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu eze alonge ivyo, niyo ahalawa na wanampina wakwe na kudeluka mto wa Kediloni. Naho wose wengila mwe chibuta cha miti, Yesu niyo engila umo hamwenga na wanampina wakwe. ");
INSERT INTO ziw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, yudya amhituke Yesu, nakamanya ahantu aho, kwaviya nkanana zilozize Yesu nakadugana na wanampina wakwe aho. ");
INSERT INTO ziw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yuda niyo engila hechibuta, aguha fyo dya wankondo wa Chilumi, hamwenga na wamizi wasigilwe ni walavyantambiko wakulu na Mafalisayo, weza wenula taa na magala na viziha. ");
INSERT INTO ziw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu nendile kavimanya vyose navimlaile, awalaila kulongozi kwawo na kuwauza, “Mwamlonda yuhi?” ");
INSERT INTO ziw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nawo wamhitula. “Yesu ywa Nazaleti,” Yesu awagamba, “Ni miye,” Yuda, amhituke Yesu, nendile kachimala aho hamwenga na awo. ");
INSERT INTO ziw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu eze awagambe, “Ni miye” wauya kunyuma niyo wafika madi. ");
INSERT INTO ziw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu awauza vituhu, “Mwamlonda yuhi?” Wamhitula. “Yesu ywa Nazaleti,” ");
INSERT INTO ziw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu awagamba. “Siwagambilani kugamba ni miye,” “Uneva mwanilonda miye, walekeni wano watuhu waite.” ");
INSERT INTO ziw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kalonga ivyo chani yadya alongile yachinte, “Tate, wadya uninkile sazize hata yumwenga.” ");
INSERT INTO ziw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petulo, endaga na bamba, niyo adisomola amsenga idigutwi dya kulume mndima ywa Mlavyantambiko Mkulu,. Mndima uyo naketangwa Maliko. ");
INSERT INTO ziw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu amgamba Petulo, “Bamba dyako divuze mwe yala yakwe! Togola, nisekujinkila sila ya masulumizo ninkigwe ni Tate?” ");
INSERT INTO ziw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Fyo dya wankondo wa Chilumi hamwenga na mkulu ywawo ywa wamizi wa Chiyahudi niyo wamgwila Yesu, wamtaliza, ");
INSERT INTO ziw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","niyo wamwigala kwa Anasi. Anasi endaga ni mkwewe dya Kayafa, yudya endaga Mlavyantambiko Mkulu mo umhilimo uwo. ");
INSERT INTO ziw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Uyo Kayafa nuyo awagambilaga Wayahudi kugamba ni vyedi mntu yumwe abanike kwa chausa cha wantu wose. ");
INSERT INTO ziw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petulo hamwenga na mwanampina mtuhu niyo wamtimila Yesu. Kwaviya yudya mwanampina nendile kamanyika kwa Mlavyantambiko Mkulu, ivyo kengila hamwenga na Yesu mwebalaza ye nyumba ya Mlavya ntambiko Mkulu, ");
INSERT INTO ziw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","mna Petulo nendile kachimala kuse kwe nchili. Naho yudya mwanampina mtuhu endaga amanyike kwa Mlavyantambiko Mkulu niyo afosa kuse, alonga na mndima yumwenga ywa chiche mwamizi ywo lwivi, niyo ambasa Petulo mnyumba. ");
INSERT INTO ziw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mndima uyo mwamizi ywo lwivi amuza Petulo, “Togola, weye nawe hwi mwanampina ywa mntu yuno?” Petulo amgamba. “Bule, Suyo miye,” ");
INSERT INTO ziw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wandima na wamizi wajimbaga moto kwaviya nakuna mpeho, nawakotela moto. Ivyo Petulo naye nakachimala hamwenga nawo akotela moto. ");
INSERT INTO ziw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mlavyantambiko Mkulu amuza Yesu mbuli za wanampina wakwe hamwenga na mbuli za mahinyo yakwe. ");
INSERT INTO ziw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu amhitula, “Silonga na wantu wose mazuwa yose mo lumpe mwe isi, naho sihinya mahinyo yangu mwe nyumba zo kuvikila na mwe nyumba nkulu ya Chohile, hantu Wayahudi wose wakudugana. Silongile chintu chochose kwa chinyele. ");
INSERT INTO ziw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ni mbwani, naho, ukunuza miye? Wauze wadya wanivile. Wauzeni kugamba wamanya icho niwagambile.” ");
INSERT INTO ziw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu eze alonge ivyo, yumwenga ywa wamizi achimale aho niyo amhuta ihi akagamba, “Togola, nivyo ukumhitula Mlavyantambiko Mkulu!” ");
INSERT INTO ziw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu amhitula, “Uneva silonga vihiye, mgambile chila mntu wihi wangu. Mna uneva silonga vyedi wanitoilani?” ");
INSERT INTO ziw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anasi niyo amwigala Yesu, kwa Kayafa Mlavyantambiko Mkulu achei atalizwe. ");
INSERT INTO ziw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoni Petulo nachei achimale akotela moto. Wantu watuhu niyo wamuza, “Togola, weye nawe hwi mwanampina ywa yuno mntu?” Mna Petulo niyo alemela. Agamba. “Bule, suyo miye,” ");
INSERT INTO ziw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mndima yumwenga ywa Mlavyantambiko Mkulu, mlukolo ywa yudya akantigwe digutwi ni Petulo, amuza Petulo. “Togola, miye sikuwone kwechibuta hamwenga na yuno mntu?” ");
INSERT INTO ziw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petulo alemela vituhu. “Bule” Aho zogolo dyaila. ");
INSERT INTO ziw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chilo chilo vilongozi wa Wayahudi wamguha Yesu kulaila mwe nyumba ya Kayafa na kumwigala kwe nyumba ya mkulu ywe isi. Mna vilongozi wa Wayahudi hawengile mwe nyumba yo mkulu ywa Yudeya, kwaviya wanase kujelwa uzavu, chani wadahe kudya inyinka ye Pasaka. ");
INSERT INTO ziw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Elo, Pilato niyo awabasa kuse awagamba, “Mwamlaha mbwani mntu yuno?” ");
INSERT INTO ziw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Niyo wamhitula, “Hachamletile kwako uneva hakoile masa.” ");
INSERT INTO ziw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato awagamba, “Hayani, mguheni nyuwe wenye mkamkantile vikuligana ne sigilizi zenyu.” Wayahudi wamhitula, “Suwe hachikungwa kumkantila mntu yoyose file.” ");
INSERT INTO ziw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ivyo vitendeka chani ulosi alongile Yesu uchinte, kugamba nabanike vivihi. ");
INSERT INTO ziw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato niyo engila vituhu mwe nyumba yo Mkulu ywa Yudeya amwitanga Yesu. Amuza. “Weye nuyo Seuta ywa Wayahudi?” ");
INSERT INTO ziw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu amhitula, “Vino zimbuli ukunuza ni fanyanyi zako mwenye hegu ni mbuli utile kugambilwa ni wantu watuhu?” ");
INSERT INTO ziw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato amhitula, “Togola, vino miye ni Myahudi? Ni wantu wako mwenye na Walavyantambiko Wakulu wakwinkize kwangu. Kudamanya mbwani?” ");
INSERT INTO ziw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu amhitula, “Useuta wangu suwo we isi ino, uneva useuta wangu wendile we isi ino, wandima wangu nawanigombela nisekwinkizwa kwa vilongozi wa Wayahudi. Bule, useuta wangu suwo wa hano!” ");
INSERT INTO ziw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Elo Pilato amuza, “Haluse weye wi seuta?” Yesu amhitula, “Ni weye ukulonga kugamba miye ni seuta. Miye nelekagwa na kwiza mwe isi kwa chausa chimwe, kulonga chindedi. Chila mntu akuzumila chindedi aniva.” ");
INSERT INTO ziw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato amuza. “Chindedi ni mbwani?” Pilato niyo awabasa vituhu Wayahudi kuse, awagamba, “Miye siwone masa yoyose kwa yuno mntu.” ");
INSERT INTO ziw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Mna mazwela yenyu kugamba vyaungwa niwalekeile mfungwa yumwenga mwe Pasaka. Haluse mwaunga niwalekeileni Seuta ywa Wayahudi?” ");
INSERT INTO ziw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aho waguta, “Bule, suyo uyo! Chaunga uchilekeile Balaba!” Uyo Balaba endaga mpolaganyi. ");
INSERT INTO ziw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato niyo asigila Yesu aguhigwe, atoigwe nkome. ");
INSERT INTO ziw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wankondo waluka chilemba cha miwa, wamvika komtwi, niyo wamvika nkazu ya chiseuta. ");
INSERT INTO ziw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Niyo wamwizila kulongozi kwakwe na kugamba, “Ndamsa, Seuta ywa Wayahudi!” Niyo wamhuta maihi. ");
INSERT INTO ziw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato niyo afosa kuse vituhu, awagamba, “Kaulani, nanimwigale hano heise, chani mmanye kugamba miye sina wihi niwone mwakwe.” ");
INSERT INTO ziw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu afosa kuse, kavika chilemba cha miwa na nkazu ya chiseuta. Pilato awagamba, “Kaulani, mntu mwenye ni nuyo.” ");
INSERT INTO ziw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Walavyantambiko wakulu na wamizi we nyumba nkulu ya Chohile weze wamwone niyo waguta, “Mtundike mo msalaba! Mtundike mo msalaba!” Pilato awagamba, “Elo mguheni, nyuwe wenye mkamtungike mo msalaba, kwaviya miye sina wihi niwone mwakwe.” ");
INSERT INTO ziw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wayahudi wa mhitula, “Suwe china sigilizi, na kwakutimila isigilizi iyo aungwa abanike, kwaviya ketenda ni Mwana ywa Chohile.” ");
INSERT INTO ziw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato eze eve imilosi iyo engilwa ni woga vidala. ");
INSERT INTO ziw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Niyo engila mwe nyumba ya mkulu we isi ya Yudeya vituhu, amuza Yesu, “Walaila kuhi?” Mna Yesu hamhitule dyo dyose. ");
INSERT INTO ziw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato amgamba, “Hukulonga na miye? Togola, humanyize kugamba miye nina udahi wa kukufungula na udahi wa kukusulumiza mo msalaba?” ");
INSERT INTO ziw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu amhitula, “Hwendile na udahi wowose mwangu hegu hwenkigwe ni Chohile. Kwachausa icho, yudya aninkize kwakwo ana masa yatendese.” ");
INSERT INTO ziw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kukongela aho Pilato alonda sila ya kumlekela, mna Wayahudi watula lwasu, “Unamlekela mntu uyo, weye hwi mbuyaye dya Zumbe ywa Lumi. Chila mntu akwetenda zumbe amhiga Zumbe ywa Lumi!” ");
INSERT INTO ziw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato eze eve imilosi iyo amleta Yesu kuse, niyo ekala mwe chigoda cho mkanti, hantu hakwitangwa, “Lwazo lwa mayuwe.” Kwa Chiebulaniya, Gabata. ");
INSERT INTO ziw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na ni saa mtandatu nomsi, zuwa dye kweika mwe ngasu ye Pasaka. Pilato awagamba Wayahudi, “Kaulani Zumbe ywenyu!” ");
INSERT INTO ziw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wowo waguta, “Mkome! Mkome! Mtungike mo msalaba!” Pilato awauza, “Togolani, nimtundike mo msalaba Zumbe dyenyu?” Walavyantambiko wakulu wamhitula, “Suwe hachina seuta mtuhu mna Kaisali!” ");
INSERT INTO ziw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aho Pilato amjela Yesu mwe mikono yawo chani atungikwe. Ivyo wamguha Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Niyo alawa kuno kenula Msalaba wakwe kwita hantu hakwitangwa Gobela dya Mtwi. Mwe Chiebulaniya ni Goligota. ");
INSERT INTO ziw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aho niyo wamtungika mo msalaba, hamwenga nahawambwa wantu watuhu waidi. Yumwenga kulume kwakwe yumwenga kumoso kwakwe. Yesu ne hagati. ");
INSERT INTO ziw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato nakawandika mwe chibao lagiso niyo aika halanga ho msalaba, “Yesu Mnazaleti, Seuta ywa Wayahudi.” ");
INSERT INTO ziw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wantu walozize wasomaga, kwaviya hantu aho Yesu atungikagwa mo msalaba hendaga haguhi no mzi. Ivyo Wayahudi walozize wasomaga idiwandiko idyo dyawandikagwa kwa Chiebulaniya na Chilatini na Chigiliki. ");
INSERT INTO ziw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Niyo walavyantambiko wa Wayahudi wamgamba Pilato, “Usekuwandika, ‘Seuta ywa Wayahudi,’ mna wandika vino mntu yuno nakagamba, ‘Miye ni Seuta ywa Wayahudi.’ ” ");
INSERT INTO ziw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato ahitula, “Yadya niwandike, siwandika kale.” ");
INSERT INTO ziw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wankondo weze wamtungika Yesu, niyo waguha izisuche zakwe, wazika machisa mane, kwa chila yumwenga chisa dyakwe. Naho niyo waguha suche yakwe ntuhu, suche iyo nahaina msumo. ");
INSERT INTO ziw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wadya wankondo niyo wagambilana, “Chisekuitatula, mna chiitoile tegatega naimgwele yuhi.” Mbuli ino naidamanyika chani yachinte Mawandiko ya Kukile ivyo yakulanga, “Wapangana izisuche zangu, na isuche yangu waitoila tegatega.” Ivyo nivyo wadamanye wankondo awo. ");
INSERT INTO ziw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Haguhi no msalaba wakwe Yesu wendaga wachimala mamiyakwe na lumbudye dya mamiyakwe na Maliyamu mkaza Kilopa na Maliyamu Magidalena. ");
INSERT INTO ziw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu eze amwone mamiyakwe, ne haguhi hakwe kachimala yudya mwanampina amungile, amgamba mamiyakwe, “Mnala, kaula, yuno nuyo mwanawo.” ");
INSERT INTO ziw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Vikaheza amgamba yudya mwanampina, “Haluse yuno nuyo mamiyako.” Kukongela aho yudya mwanampina niyo amguha ekale naye kukaya kwakwe. ");
INSERT INTO ziw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu niyo amanya kugamba yose yachinta, chani Mawandiko Yakukile yachinte, agamba, “Nina nchilu.” ");
INSERT INTO ziw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aho na hana chiya chimemile siki. Niyo watweza lendele mwe divai igwaduke, waika mlanga mwe tete, niyo wamwinkiliza mo mnomo. ");
INSERT INTO ziw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu eze afyose iyo idivai, agamba, “Yachinta.” Akaheza enamiza umtwi abanika. ");
INSERT INTO ziw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yendaga zuwa dya kwemalanya, chani mili isekwikala mo msalaba mwe zuwa dyo kuhumula, kwaviya Zuwa idyo dya Kuhumula dyendaga zuwa kulu, Wayahudi wamlombeza Pilato viga vya wadya watundikwe mo msalaba vivunwe, mili yawo yuswe mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ivyo wankondo waita, wavivuna iviga vya yudya mntu wa nkongo na yudya wa kaidi wadya wendile watungikwe mo msalaba hamwenga na Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mna weze wamwitile Yesu wabwila kabanika kale, ivyo hawamvunile iviga. ");
INSERT INTO ziw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mnkondo yumwenga niyo amtunga mo lubavu na guha, aho niyo yalaila sakame na mazi. ");
INSERT INTO ziw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yudya awone imbuli iyo, kawona chani naywi mzumile yadya alongile ni chindedi, naho uyo kamanya kugamba alonga chindedi. ");
INSERT INTO ziw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mbuli iyo idamanywa chani Mawandiko Yakukile yachinte, “Hahana hata vuha dyakwe dimwenga nadivunwe.” ");
INSERT INTO ziw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Mawandiko naho yagamba, “Nawamsinye yudya wamtungile.” ");
INSERT INTO ziw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yeze yajike, nahana mntu yumwenga akwitangwa Yusufu, nakekala ko mzi wa Alimataya, niyo aita kwa Pilato na kumlombeza umwili wa Yesu. Mntu uyo endaga mwanampina ywa Yesu kwa chinyele kwaviya nakawogoha vilongozi wa Wayahudi. Pilato niyo amzumila chani auguhe umwili wa Yesu, Yusufu niyo aita na kuguha umwili wa Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo aho nkongo ambasaga Yesu nechilo, niyo aita hamwenga na Yusufu, naho nakaguha manemane hamwenga na udi ukubula madebe maidi. ");
INSERT INTO ziw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Waidi awo wauguha umwili wa Yesu, wautaliza sanda hamwenga na manukato kutimilana na viya wazwele wayahudi mo kuhambwa. ");
INSERT INTO ziw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Hantu aho atungikagwa Yesu hendaga na chibuta, naho mwe chibuta icho mwendaga na mbila mpya heinati kuhambwa mntu yoyose mndani mwakwe. ");
INSERT INTO ziw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kwaviya yendaga mwe kwemalanya vyedi mwe Zuwa dya Kuhumula, niyo wawika umwili wa Yesu mwe imbila idya. ");
INSERT INTO ziw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Chilo chilo kuchei mavukuvuku mwe zuwa dya kuhumula, Maliyamu Magidalena nakaita kwe mbila, niyo awona diya idiyuwe dyusigwa holwivi lwe mbila. ");
INSERT INTO ziw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Niyo aguluka kwa Simoni Petulo na yudya mwanampina mtuhu aungagwa ni Yesu, akuwagambila, “Wamusa Zumbe mwe mbila, naho hachimanyize uko wamwikiye.” ");
INSERT INTO ziw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ivyo Petulo hamwenga na yudya mwanampina mtuhu niyo waita kwembila. ");
INSERT INTO ziw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wose waidi waguluka mna yudya mwanampina mtuhu kagulukisa kumjinka Petulo, kalongola kubula kwembila. ");
INSERT INTO ziw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Eze ename, asungila mndani niyo awona isanda, mna hengile mndani. ");
INSERT INTO ziw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petulo naye eze amtimile, engila mwe mbila, umo kawona isanda, ");
INSERT INTO ziw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na isuche azingigwe Yesu mo mtwi. Iyo isuche nandile haihamwenga ne sanda, mna naizingwa saviya naili mo mtwi, ikwa hantu hakwe. ");
INSERT INTO ziw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Vikaheza yudya mwanampina mtuhu alongole kubula kwe mbila, niyo engila mndani. Awona niyo azumila. ");
INSERT INTO ziw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nahawenati kumanya Mawandiko Yakukile yawandikwe kugamba vyaungwa auyuke. ");
INSERT INTO ziw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Niyo wanampina wauya kaya. ");
INSERT INTO ziw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliyamu nakachimala kuse kwembila. Kuno achei kwila, kafunama asungila kwe mbila. ");
INSERT INTO ziw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Niyo awona wandima wa kwembingu waidi wavikile suche zing'aile, wekala hadya umwili wa Yesu wagonezagwa, yumwenga ko mtwi ywa kaidi kweviga. ");
INSERT INTO ziw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Awo wandima wa kwembingu wamwuza, “Mnala, ni mbwani ukwila?” Naye awagamba, “Wamusa Zumbe dyangu, naho simanyize uko wamwikiye!” ");
INSERT INTO ziw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Eze alonge ivyo, niyo ahituka kunyuma, amwona Yesu kachimala ahadya, mna asekumanya kugamba ni Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu amuza, “Mnala ni mbwani ukwila? Wamlonda yuhi?” Maliyamu nakafanyanya kugamba uyo ni mwamizi ywe chibuta, amgamba, “Mkulu, uneva ni weye umusize, nigambila uko umwikiye miye nimguhe.” ");
INSERT INTO ziw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu amgamba, “Maliyamu!” Naye Maliyamu ahituka, amgamba kwa Chiebulaniya, “Laboni.” Nuko kugamba “Mhinyi.” ");
INSERT INTO ziw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu amgamba, “Usekunikufya kwaviya sinati kwita kulanga kwa Tate. Mna hita kwa walukolo wangu uwagambile, naita, kulanga kwa Tate nanywi nuyo Tati yenyu, Chohile ywangu nanywi nuyo Chohile ywenyu.” ");
INSERT INTO ziw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ivyo Maliyamu Magidalena niyo aita akuwagambila wadya wanampina, awagamba, “Simwona Zumbe”. Nakugamba nakamgambila ivyo. ");
INSERT INTO ziw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yendaga chisingi cha zuwa dya kuhumula wanampina nawadugana hamwenga mndani mwe nyumba, nyivi nazivugalwa kwaviya nawakawogoha vilongozi wa Chiyahudi. Yesu niyo eza, achimala hagati hawo, awagamba, “Utondowazi utende kwenyu!” ");
INSERT INTO ziw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Eze alonge ivyo, niyo awalagisa imikono yakwe no lubavu lwakwe. Awo wanampina weleleswa kumwona Zumbe. ");
INSERT INTO ziw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu awagamba vituhu, “Utondowazi utende kwenyu! Saviya Tate anisigile miye nami nawasigilani nyuwe.” ");
INSERT INTO ziw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Eze alonge ivyo niyo awavila awagamba, “Hokelani Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Hegu mnawalekeila wantu masa yawo, masa yawo nayalekeilwe. Mna hamnawalekeile, hawalekeilwe masa yawo.” ");
INSERT INTO ziw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mna Tomaso zina tuhu naketangwa pacha nendile hahali umo Yesu akeza. ");
INSERT INTO ziw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ivyo wadya wanampina watuhu wamgamba, “Chimwona Zumbe.” Tomaso awagamba, “Sinawone nkwasulo ze mitunga mwe mikono yakwe, na kupampasa umkono wangu mo lubavu lwakwe, sanizumile.” ");
INSERT INTO ziw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yeze yajinke mazuwa mnane awo wanampina nawehamwenga mudya mnyumba, Tomaso naye nehamwenga nawo, nyivi nazivugalwa, mna Yesu niyo eza, achimala hagati hawo, akalonga, “Utondowazi utende kwenyu!” ");
INSERT INTO ziw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Niyo amgamba Tomaso, “Ika ididole dyako hano, ukaule mikono yangu, ninka umkono wako ukaule ulubavu lwangu. Usekutenda na nkama, mna zumila.” ");
INSERT INTO ziw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaso amhitula, “Weye wi Zumbe dyangu!, Weye wi Chohile ywangu!” ");
INSERT INTO ziw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu amgamba, “Togola, wazumila kwaviya kuniwona? Ujimbiko wimwe wadya wakuzumila mna hawaniwone.” ");
INSERT INTO ziw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu kadamanya vilagiso wituhu vilozize kulongozi kwa wanampina wakwe mna havinati kuwandikwa mwe chitabu chino. ");
INSERT INTO ziw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mna zino ziwandikwa chani mzumile kugamba Yesu ni Kulisito Mwambula, Mwana ywa Chohile, mzumile mtende na ujima kwa udahi wa zina dyakwe. ");
INSERT INTO ziw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ivyo vize viheze, Yesu niyo awalaila naho wanampina wakwe mpezo mwe diziwa dya Tibeliya. Kawalaila vino; ");
INSERT INTO ziw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petulo na Tomaso akwitangwa pacha na Nasanieli mkaya ywa mzi wa Kana mwe isi ya Galilaya, wana waidi wa Zebedayo hamwenga na wanampina watuhu waidi wa Yesu wendile wose wehamwenga. ");
INSERT INTO ziw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petulo awagamba, “Nakulowa samaki.” Nawo wamgamba, “Suwe naswi chaitanya na weye.” Niyo waita, wakukwela ngalawa, mna nechilo icho hawapatile chochose. ");
INSERT INTO ziw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kwize kukonge kucha, Yesu nakachimala mpezo mwe diziwa, mna wanampina hawamanyize kugamba ni Yesu. ");
INSERT INTO ziw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu awauza, “Wabwanga, hamnati mpate samaki?” Wowo wamhitula, “Bule! Hachinati kupata chintu.” ");
INSERT INTO ziw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu awagamba, “Dulani ulwavu ntendele ya kulume ye ngalawa, nanywi namlowe samaki.” Wadula ulwavu, mna hawadahile kuluvuta vituhu kwaviya samaki nazilozesa. ");
INSERT INTO ziw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aho yudya mwanampina aungiswe ni Yesu amgamba Petulo, “Ni Zumbe!” Simoni Petulo eze eve kugamba mntu yudya ni Zumbe, ahadya evika suche yakwe, kwaviya nahavikile niyo apilikila mwa mazi. ");
INSERT INTO ziw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wadya wanampina watuhu naweza na ngalawa kuno wakalukwesa ulwavu lumemile izisamaki. Naho nendile hawehale na kwe isi kunyaile, nazikabula nkacho gana kulaila kudya kunyaile. ");
INSERT INTO ziw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Weze wabule kunyaile, wawona nkala za moto ujimbigwe, mlanga mwakwe mwikwa samaki na mgate. ");
INSERT INTO ziw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu awagamba, “Zileteni hano izisamaki izimwenga mlowile.” ");
INSERT INTO ziw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Petulo akwela mwe ngalawa, akweseza kunyaile ludya ulwavu lumemile izisamaki nkulu gana na milongo mishano na ntatu. Samaki nazilozesa, mna ulwavu halukantike. ");
INSERT INTO ziw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu awagamba, “Soni mdye.” Hahana hata mwanampina ajezize kumuza, “Weye wi yuhi?” Kwaviya nawavimanya ni Zumbe. ");
INSERT INTO ziw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu eza, aguha mgate awenka akajika aguha samaki naho awenka. ");
INSERT INTO ziw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iyo yendaga nkanana ya katatu Yesu kuwalaila wanampina wakwe eze auyuke. ");
INSERT INTO ziw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Weze wajike ukudya, Yesu amuza Simoni Petulo, “Simoni mwana ywa Yohana! Togola, wanunga miye kujinka wano?” Naye amhitula, “Heye Zumbe, weye kuvimanya kugamba miye nakunga.” Yesu amgamba, “Lisa ngoto zangu.” ");
INSERT INTO ziw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Akaheza amgamba nkanana ya kaidi, “Simoni mwana ywa Yohana! Togola, wanunga?” Petulo amhitula, “Heye Zumbe, kuvimanya nakunga.” Yesu amgamba, “Dima izingoto zangu.” ");
INSERT INTO ziw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu amuza nkanana ya katatu, “Simoni mwana ywa Yohana! Togola, wanunga?” Aho Petulo kengilwa ni chinyulu kwaviya kamuza nkanana ntatu, “Wanunga?” Niyo amgamba, “Zumbe, weye kumanya yose. Weye kuvimanya kugamba miye nakunga.” Yesu amgamba, “Lisa izingoto zangu! ");
INSERT INTO ziw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nakugambila chindedi, hadya wendaga wi mbwanga nakuzwela kwevisa mwenye na kwita kokose ukunga. Mna aho ukunga udalahaile, nochumize mikono yako na mntu mtuhu nakuvike na kukwigala hwikunga.” ");
INSERT INTO ziw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kwa kulonga ivyo, Yesu nakalagisa viya Petulo akunga abanike nakwigala ntunyo kwa Chohile. Akaheza amgamba, “Nitimila.” ");
INSERT INTO ziw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Aho Petulo eze ahituke, amwona yudya mwanampina nakaungiswa ni Yesu atimila. Yuno ni yudya mwanampina ekalaga hajihi na Yesu mwe nkande ye Pasaka na kumuza, “Zumbe ni yuhi nakuhituke?” ");
INSERT INTO ziw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petulo eze amuwone uyo, amuza Yesu, “Zumbe, togola yuno naye?” ");
INSERT INTO ziw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu amhitula, “Uneva haunga asigale kubula aho hwizila, wavyungilani? Weye nitimila miye.” ");
INSERT INTO ziw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ivyo imbuli iyo niyo yazagala mgati mwa wadya walukolo kugamba mwanampina uyo haabanike. Mna Yesu hamgambile kugamba mwanampina uyo habanike, mna nakagamba, “Uneva haunga asigale kubula aho hwizila, wavyungilani?” ");
INSERT INTO ziw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Uyo mwanampina nuyo aukule izimbuli zino na kuziwandika. Naswi chimanya kugamba alongile ni chindedi. ");
INSERT INTO ziw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kuna mbuli ntuhu zilozize adamanye Yesu, hegu uneva zawandikwe zose, chindedi isi yose hayachintile kwika ivitabu vyawandikwe.");
INSERT INTO ziw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kwa mkulu Teofilo, Mwe chitabu changu cha nkongo nawandikaga mbuli zose Yesu adamanyaga na kuhinya kukongela akongile indima yakwe, ");
INSERT INTO ziw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kubula idizuwa aguhigwe kwigalwa kulanga. Umo henati kwinulwa, kalavya sigilizi kwa udahi wa Muye Ukukile kwa wantu asagule watende wasigilwa. ");
INSERT INTO ziw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mazuwa milongo mine file yakwe ize ijinke kawalaila nkanana zilozize wadya asagule vyatenda wazumile kugamba kauyuka. Wamwona niyo wasimwila naye mbuli za Uzumbe wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Umo wendaga hamwenga awenka sigilizi ino, “Msekuhalawa Yelusalemu, mna mgoje jeleko, Tate agambaga nawenke, jeleko mwanivaga halonga. ");
INSERT INTO ziw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana abatizaga kwa mazi mna nyuwe mazuwa majeche yakwiza nambatizwe kwa Muye Ukukile.” ");
INSERT INTO ziw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Umo wasigilwa weze wadugane na Yesu, wamuza, “Zumbe togola, nauvuze uzumbe kwa wantu wa Izulaeli chipindi chino?” ");
INSERT INTO ziw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu awagamba, “Chipindi na ntendwa izo vikwa ni udahi wakwe Tate mwenye, siyo mbuli yenyu kumanya navilaile ini. ");
INSERT INTO ziw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mna umo Muye Ukukile akunga awezile, namhokele nguvu naho namtende waukuzi wangu mo mzi wa Yelusalemu, na mo mkowa wa Yudeya woseni hamwenga na Samaliya na ntendele ze isi.” ");
INSERT INTO ziw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eze alonge ivyo aguhigwa kulanga kwembingu kuno wakamsinya niyo ingu dyamgubika wadunduga kumwona. ");
INSERT INTO ziw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nawechei wakasinya kulanga kwa maingu umo Yesu akaita, aho walaila wagosi waidi wachimala mnkanda mwawo wavaile suche zing'aile chwee. ");
INSERT INTO ziw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Wagamba “wantu wa Galilaya, nimbwani mchimale aho kuno mkasinya kulanga kwa maingu? Yuno Yesu aguhigwe mwenyu kwita kwembingu nauye mwesila ino mumwone akaita kwembingu.” ");
INSERT INTO ziw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wasigilwa niyo wauya komzi wa Yelusalemu wakalaila Lugulu lwa Mizeituni uhale wa chilomita imwenga vino kulaila komzi uwo. ");
INSERT INTO ziw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Niyo wengila mo umzi na kwita hanyumba nawakekala wakina Petulo na Yohana na Jemsi na Anduleya na Filipo na Tomaso na Batolomayo na Matayo na Yakobo mwana ywa Alifayo, Simoni Mgombela si yakwe na Yuda mwana ywa Yakobo. ");
INSERT INTO ziw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Chila nkanana nawakadugana hamwenga mwe fyo wakalombeza kwa Chohile, kwa moyo umwenga umo namna wavyele na Maliyamu mamiyakwe dya Yesu hamwenga nawalukolo wakwe. ");
INSERT INTO ziw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mazuwa majeche halaila mdugano wa wazumile wakubula gana na milongo midi, Petulo achimala na kulonga, ");
INSERT INTO ziw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","agamba, “Wazumile weyangu, Mawandiko yachinta, Muye Ukukile nakayasimwila kwa Daudi, kulotela mbuli za Yuda, atendile chilongozi ywa wadya wamgwile Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda nehamwenga na suwe, asagulagwa atende mnyetu mwe ndima yetu.” ");
INSERT INTO ziw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kagula nkonde kwe hela idya ahokele mokudamanya ntendwa zihiye niyo abanikila umo mwe nkonde, katulika izinda, utumbo wose ulaila kuse. ");
INSERT INTO ziw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wantu woseni wakwikala Yelusalemu weva imbuli iyo, niyo mwe semo yawo waitanga “Akelidama” nuko kugamba “Nkonde ya sakame.” ");
INSERT INTO ziw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Iwandikwa mwe chitabu che zabuli kugamba, ‘Nyumba yakwe itende heina chintu, yoyose asekuikala.’ Naho iwandikwa, ‘Mntu yoyose mtuhu atoze hantu he ndima yakwe.’ ");
INSERT INTO ziw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Elo, mntu yumwenga mgati mwa wadya chajesanyaga mwe chipindi china Zumbe asagulwe atende mlongi ywa uyuko wa Zumbe Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Mntu uyo aungwa atende nachiwose hamwenga umo Yesu nakatamba naswi kukongela viya Yohana ambatizaga kubula kuuyuka kwa Yesu akaguhigwe kwigalwa kwembingu.” ");
INSERT INTO ziw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ivyo waika wantu waidi, Yusufu naketangwa Balisaba naho Yusito ywa kaidi ni Matiya. ");
INSERT INTO ziw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Niyo walombeza kwa Chohile, “Zumbe, kumanya fanyanyi za chila yumwenga, chilagise wantu waidi wano ni yuhi usagule ");
INSERT INTO ziw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kutenda msigilwa hantu ha ndima ya Yuda, alaile kwita hantu hakumwagila.” ");
INSERT INTO ziw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Niyo wadamanya tegatega kumsagula yumwenga mwa wadya awaidi, asagulwa Matiya kwingila mwe idifyo dya wasigilwa mlongo na yumwenga. ");
INSERT INTO ziw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dize dibule zuwa dya Pentekosite, nuko kugamba zuwa dya milongo mishano Yesu eze enulwe kwita kwembingu wazumile woseni wadugana hantu hamwenga. ");
INSERT INTO ziw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aho, halaila izwi kulaila kulanga dikuvumila saviya nkung'unto, niyo yamema mwe nyumba yose umo nawekale. ");
INSERT INTO ziw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Niyo wawona chintu chikale savia myale ya moto izagale nakumdonta chila neyaho. ");
INSERT INTO ziw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Woseni niyo wamemezwa ni Muye Ukukile nakukonga kutamwila lugha ntuhu viya Muye Ukukile awadahize kulonga. ");
INSERT INTO ziw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nahana wantu walozize wa chiyahudi wakumvikila Chohile walaile kwe si zose nawekala Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Weze weve lwasu ulo, fyo kulu dyadugana. Wose wehelwa kwaviya chila yumwenga kaweva wadya wazumile wakalonga mwe zisemo zawo wenye. ");
INSERT INTO ziw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mokwehelwa kwawo, wagambana, “Togola wantu wano wakusimwila vino sawo Wagalilaya! ");
INSERT INTO ziw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Vyatenda vivihi naho chose chaweva wakasimwila mwe semo zetu? ");
INSERT INTO ziw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Chalawa Patiya na Mediya na Elamu, kulaila Mesopotaniya na Yudeya na Kapadokiya, kulaila Ponto na Asiya, ");
INSERT INTO ziw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Kulaila Filigiya na Pamfiliya, kulaila Misili na mizi ya Libiya hajihi na Kilene. Watuhu chiwajeni chilaila Lumi, ");
INSERT INTO ziw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","woseni Wayahudi hamwenga na sawo Wayahudi watimile sila ya Chiyahudi ya kumlonda Chohile, watuhu chilaila Kilete na Uwalabuni, suwe choseni chaweva wakalonga mwe ntendwa zetu wenye mbuli nkulu Chohile adamanye.” ");
INSERT INTO ziw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wehelwa na kususuhala, wauzana chila yumwenga, Vino nivyo mbwani? ");
INSERT INTO ziw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mna watuhu nawakawabela kuwagamba, “Wantu wano wakolwa mpombe pya.” ");
INSERT INTO ziw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petulo niyo achimala hamwenga nawasigilwa mlongo na yumwenga kwa izwi kulu, akonga kugutila idifyo dya wantu. Wayahudi weyangu na wose mkwikala Yelusalemu netegelezani niwagambile imbuli ino yagaze. ");
INSERT INTO ziw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wantu wano hawakoligwe, mwawafanyanya vihiye, mtondo wa sa ntatu ino. ");
INSERT INTO ziw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Vino nivyo muwoni ywa Chohile Yoweli alongaga ");
INSERT INTO ziw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Chohile agamba vino nivyo hunga nitende mwa mazuwa yo uhelo, Nanilavye Muye wangu kwa chila yumwenga. Wana wenyu wa chilume na wachiche nawalonge ulosi wangu, wana wenyu wa chilume nawawone uwoni, wadalahala nawo nawalote sozi. ");
INSERT INTO ziw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hata mwa watumwa wangu wose wachigosi na wachivyele, naniwenke Muye Ukukile mwa mazuwa ayo, nawo nawalonge ulosi wangu. ");
INSERT INTO ziw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nanidamanye vilagiso kulanga na mpituko hasi heisi. Nakutende na sakame, moto na mosi uzamile, ");
INSERT INTO ziw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","zuwa nadijelwe chiza, mnenge nawo nauhitukile winkundu saviya sakame, umo zuwa dikulise naho zuwa dyo kwizila Zumbe hadinati kwiza. ");
INSERT INTO ziw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Akajika, wantu wose nawalombeze kwa zina dya Zumbe nawakombolwe. ");
INSERT INTO ziw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nyuwe wagosi wa Waizulaeli tegelezani, Yesu ywa Nazaleti nani mntu udahi wakwe kulaila kwa Chohile wikwa holumpe mwenyu kwa vilagiso na mpituko Chohile adamanye mwakwe. Nyuwe wenye muimanya imbuli iyo kwaviya ilaila mwenyu. ");
INSERT INTO ziw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Chohile amanyaga mzungu wakwe mwenye, kugamba Yesu kenkizwa mwe imikono yenyu, mumkoma kwa kuwalekela wantu wavu wamkome kwa kumtundika mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mna Chohile kamuyusa, kamtenda udahi wa file usekumdaha, kwaviya kalekeilwa mwa masulumizo ya file. ");
INSERT INTO ziw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Daudi kamlongela vino, “ ‘Namwonaga Zumbe nkanana zose mwa meso yangu, ehajihi na miye naho sanisingisike. ");
INSERT INTO ziw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ivyo selelwa vidala, ulosi wangu umema chinyemi. Miye hata uneva umwili naubanike, nanikale na msuhi, ");
INSERT INTO ziw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kwaviya weye Chohile honase mwe si ya wabanike. Homwase mtumwa ywako mkuka awoile kuzimu. ");
INSERT INTO ziw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kunilagisa sila ikunigala ko ujima, uwiyaho wako wanibwedeza.’ ");
INSERT INTO ziw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Walukolo weyangu, naungwa niwagambile pwilili ichindedi mwa tate mkulu Daudi. Kabanika na kuhambwa, mbila yakwe chinanayo hano mwa mazuwa yano. ");
INSERT INTO ziw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nani muwoni naho nakavimanya Chohile alongaga namwinke mbwani, Chohile elisaga kugamba nanimwinke yumwenga mo lukolo lwa Daudi chigoda cho useuta saviya Daudi neli. ");
INSERT INTO ziw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi nakawona viya Chohile akunga atende, ivyo alonga mbuli za kuyuka kwa Zumbe Yesu Kulisito umo akagamba, ‘Hasigwe kuzimu, mwili wakwe hauwoile mwe mbila.’ ");
INSERT INTO ziw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Chohile kamuyusa yuno Yesu, suwe chose chaukula ichindedi chino. ");
INSERT INTO ziw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kenulwa koudahi wa Chohile, Tati yakwe, naho kahokela Muye Ukukile kwakwe saviya Chohile alongaga. Vino mkuwona na kwiva haluse nivyo Muye Ukukile awajuluzize. ");
INSERT INTO ziw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Suyo Daudi aitile kwembingu, mna nuyo agambaga, ‘Zumbe alongaga kwa Zumbe dyangu, Ikala halume hangu ");
INSERT INTO ziw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kubula niwatende wehi wako wekale hasi he viga vyako.’ ");
INSERT INTO ziw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Niyo wantu wose we nyumba ya Izulaeli wamanya kugamba yuno Yesu wamtungikaga mo msalaba nuyo atendigwe Zumbe naho Kulisito Mkombola asagulwe ni Chohile.” ");
INSERT INTO ziw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Umo wantu weze weve imbuli ino niyo wengilwa ni chinyulu mwe myoyo yawo na kulonga kwa Petulo na wasigilwa watuhu, “Walukolo wetu chitende mbwani?” ");
INSERT INTO ziw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petulo awagamba, “Chila yumwenga ywenyu eile masa yakwe naho abatizwe kwa zina dya Yesu Kulisito, naho mkunga mlekeilwe masa yenyu niyo mwahokela Muye Ukukile uyo ntunyo. ");
INSERT INTO ziw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Chiya Chohile alongaga nawenke nyuwe hamwenga na wana wenyu, na kwa wose wehale, wose Zumbe Chohile ywetu awetange kwakwe mwenye.” ");
INSERT INTO ziw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petulo kawalombezesa naho kwa milosi ilozese akawafunda, “Kwehonyeni mwa maya ya Chohile yakwiza mwa wantu wano wata masa!” ");
INSERT INTO ziw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wazumile ulosi walozize wakwe niyo wabatizwa, wantu wakubula magana milongo mitatu wongezwa mwe idifyo dya wazumile. ");
INSERT INTO ziw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wekala welavize kwa wasigilwa, wekala kwa kulungana, naho wakadya ndala na kumlombeza Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Vilagiso vilozize na mpituko nazikadamanywa ni wasigilwa, chila yumwenga niyo amema woga. ");
INSERT INTO ziw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Wazumile wose nawekala hamwenga wakajesa mbuli zawo chimwe mwe chila chintu nawananacho. ");
INSERT INTO ziw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wakataga vintu na ugoli wawo nakuwenka wantu hela viya chila yumwenga akunga. ");
INSERT INTO ziw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Zuwa hata zuwa wadugana mwe bunga hamwenga kwe Nyumba nkulu ya Chohile, naho wakadya ndala mwe zinyumba zawo, wakadya kwa mwile na myoyo ihoile, ");
INSERT INTO ziw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","wakamhongeza Chohile na kubweda untu wedi wa wantu wose. Chila zuwa Zumbe nakajenyeza wakuhonywa mwe idifyo dyawo. ");
INSERT INTO ziw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Zuwa dimwenga Petulo na Yohana waita kwe Nyumba nkulu ya Chohile sachenda nomsi chipindi cha kumlombeza Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hadya he nchili Ikwitangwa Nchili ntana, nahana aholomale kukongele kwelekwa. Chila zuwa nakegalwa aho akalombeze hela kwa wantu wakwingila mwe Nyumba nkulu ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Eze awawone Petulo na Yohana wakengila mwe nyumba nkulu ya Chohile niyo alombeza wamwinke chochose. ");
INSERT INTO ziw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wamtowa ziso, Petulo amgamba, “Chisinye”. ");
INSERT INTO ziw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Awasinya, akagoja kwinkigwa chintu. ");
INSERT INTO ziw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mna Petulo amgamba, “Sina hata tundu, mna nahwinke ninanacho, kwa zina dya Yesu Kulisito ywa Nazaleti chimala ujende!” ");
INSERT INTO ziw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Amwinula nomkono wakwe wa kulume kumwambiza enuke. Ahadya nyayo na nkungu zakwe zatoga, ");
INSERT INTO ziw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","enuka niyo apilika nakukonga kujenda jenda. Niyo engila mwe Nyumba nkulu ya Chohile hamwenga nawo, akajenda na kupilika kumtogola Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wantu naweyumo wamwona akajenda na kumtogola Chohile, ");
INSERT INTO ziw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","weze wabunkule kugamba ni yudya nakalombeza, ekale hadya he Nchili ye nyumba nkulu ya Chohile, wose wehelwa na kuwona ni mpituko ni chibwani chimlaile. ");
INSERT INTO ziw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Umo uyo mlombezi akatenda na Petulo na Yohana mwe tao dikwitangwa tawo dya Sulemani, wantu wehelwa nakuwagulukila. ");
INSERT INTO ziw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petulo eze awawone awantu, awagamba, “Waizulaeli weyangu, nimbwani mkwehelwa vino, naho nimbwani mkuchisinya? Mwafanyanya ni nguvu zetu wenye hegu wedi china nawo nuwo ulekile mntu yuno ajende? ");
INSERT INTO ziw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Chohile ywa Bulahimu, Isaka na Yakobo, Chohile ywa wadalahala wetu, kamtunya mtumwa ywakwe Yesu. Mna mumwinkiza mwe mikono ya maseuta, naho mumlemela mwa meso ya Pilato, hata Pilato eze ajise kanto dyakwe dya kufungulwa. ");
INSERT INTO ziw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Uyo endaga mkuka na ywedi kulongozi kwa Chohile, mna mumlemela, niyo mwamgamba Pilato awalekeileni mkomi. ");
INSERT INTO ziw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mumkoma yudya akuwalongoza ko ujima, mna Chohile kamuyusa, suwe chiwaukuzi mwe mbuli ino. ");
INSERT INTO ziw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ni udahi we idizina dyakwe dimwinkile aholomale yuno kudaha kujenda. Icho muwone na kumanya vitendeka kwa uzumizi ye idizina dyakwe, uzumizi mwa Yesu nuwo umtendile mjima, vino mkuwona wose. ");
INSERT INTO ziw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Haluse, Waizulaeli weyangu, sivimanya kugamba nyuwe hamwenga na vilongozi wenyu mumdamanya Yesu ivyo kwaviya mwendaga hamvimanyize. ");
INSERT INTO ziw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Chohile nakalonga chikale mwe wawoni kugamba Kulisito Mkombola ywakwe na asulumizwe, kadamanya vino chani vitendeke mwe sila ino. ");
INSERT INTO ziw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kweileni masa yenyu, naho mumhitukile Chohile, awausize masa yenyu. Tendani ivyo, ");
INSERT INTO ziw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","mnatenda ivyo chipindi nachize aho Chohile nawenkeni udahi mhya. Kulaila kwa Zumbe, naye namsigile Yesu Kulisito Mkombola asagulwe. ");
INSERT INTO ziw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nekale kwembingu kubula chipindi chiya chila chintu chadamanywa uhya, viya Chohile alongaga kwa wawoni wakukile chikale. ");
INSERT INTO ziw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa kagamba, ‘Zumbe Chohile ywenyu nawegaileni muwoni saviya anisigile miye, nalaile mwenyu. Mwivise yose akunga awagambile mdamanye. ");
INSERT INTO ziw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Chila hemwive muwoni uyo nenegwe ni wantu wa Chohile nakukomwa.’ ");
INSERT INTO ziw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wawoni wose kukongela Samwilu na wose wakumtimila, walongaga izimbuli zino yakulaila mwa mazuwa yano. ");
INSERT INTO ziw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Viya Chohile alongaga nawenke kwa wawoni wakwe ni yenyu, naho mwahangana mwe idilagano Chohile aikiye na wadalahala wenyu. Saviya alongile kwa Bulahimu, ‘Mo lweleko lwako naniwajimbike wantu wose mwe isi.’ ");
INSERT INTO ziw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ivyo Chohile kasagula mtumwa ywakwe nakumsigila kwenyu nkongo kuwajimbika kwa kuwatenda wose mleke masa yenyu.” ");
INSERT INTO ziw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petulo na Yohana nawachei wakalonga na wantu walavya ntambiko wamwenga na mkulu ywa wamizi wa nyumba nkulu ya Chohile na masadukayo wamwenga wengile. ");
INSERT INTO ziw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nawehiwa vitedese kwaviya wasigilwa waidi wadya nawakahinya wantu kugamba Yesu kauyuka, chilagiso kugamba wabanike nawauyuke. ");
INSERT INTO ziw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ivyo wawagwila na kuwajela mndani kubula zuwa ditimile kwaviya nadiswa kale. ");
INSERT INTO ziw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mna walozize wevile ulosi uwo niyo wazumila, mligano wawo uloza kubula magana milongo mishano. ");
INSERT INTO ziw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Zuwa ditimile vilongozi wa Chiyahudi, wadalahala na wahinya Sigilizi za Musa wadugana Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Wadugana na Anasi mkulu ywa Walavya ntambiko na Kayafa, Yohana, Alekizanda na watuhu we mo lukolo lwa Mlavyantambiko mkulu. ");
INSERT INTO ziw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wawachimalisa wasigilwa nakuwauza, “Mtenda vino kwa nguvu zani na kwa zina dya?” ");
INSERT INTO ziw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petulo, akatenda kamema Muye Ukukile awahitula, “Vilongozi wa wantu na wadalahala, ");
INSERT INTO ziw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","uneva dyelo mwachuza mwe mbuli zedi adamanyizwe yudya chiwete na viya ahonyigwe, ");
INSERT INTO ziw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ivyo wose mvimanye, naho wantu wose wa Izulaeli wavimanya kugamba mntu yuno kachimala mwa meso yenyu vyedi vidala kujinkila udahi wa Zina dya Yesu Kulisito ywa Nazaleti, yudya mumtungike mo msalaba, Chohile naye niyo amuyusa. ");
INSERT INTO ziw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu nuyo alongigwe mwa Mawandiko kugamba, ‘Yuwe dilemelwe ni wazesi, dihituka dikungwa vidala mwa yose.’ ");
INSERT INTO ziw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wambulwa walondwa kwakwe du, hahali mntu mwe isi yose alavigwe ni Chohile kuchihonya.” ");
INSERT INTO ziw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wantu wa chitala wehelwa kuwawona Petulo na Yohana wamemile ukankalu, wantu hewena ukulu na umanyi. Wabunkula kugamba nawehamwenga na Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mna weze wamwone yudya mntu ahonyigwe kachimala hamwenga na Petulo na Yohana hawalongile chochose. ");
INSERT INTO ziw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ivyo wawagamba wafose mwe chitala niyo wakonga kuwalafya wenye kwa wenye. ");
INSERT INTO ziw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wauza, “Wantu wano chiwatende mbwani? Chila yumwenga mwe Yelusalemu kaimanya mpituko ino nkulu idamanywe niwowo, hachikudaha kuvilemela. ");
INSERT INTO ziw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mna chani ulosi uno usekujendesa mwa wantu, chiwafunde wantu wano wasekulonga kwa mntu yoyose kwa Zina dya Yesu.” ");
INSERT INTO ziw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ivyo wawetanga naho nakuwagamba wasekulonga hegu kuhinya naho mwe Zina dya Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mna Petulo na Yohana wawahitula, “Lamulani wenye ni chihi chedi mwa meso ya Chohile. Kuweva nyuwe hegu kumwiva Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwaviya hachikudaha kuleka kulonga chintu chiwone wenye na kwiva.” ");
INSERT INTO ziw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ivyo Ichitala chawafundisa na kuwalekela. Waviwona kugamba havikudahika kuwakantila kwaviya wantu nawakamtogola Chohile kwa yudya aholomale kuhona. ");
INSERT INTO ziw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yudya mntu ahonyigwe endaga na mihilimo milongo mine. ");
INSERT INTO ziw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petulo na Yohana weze walekelwe niyo wauya kwedifyo dyawo kuwagambila chilongigwe ni walavyantambiko wakulu hamwenga na wadalahala. ");
INSERT INTO ziw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wazumile weze weve wahangana na kumlombeza Chohile, “Mkulu na Mumbi ywe mbingu, si na bahali na vyose viyumo. ");
INSERT INTO ziw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kwa sila ya Muye Ukukile kulonga kwa tati yetu Daudi mtumwa ywako, umo ukagamba, ‘Nimbwani sawo Wayahudi mwingila maya, ni mbwani wantu nawadamanya vya bule? ");
INSERT INTO ziw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mazumbe we isi wemalanya, vilongozi nawo wadugana kwa kumhiga Zumbe na Kulisito Mkombola ywakwe.’ ");
INSERT INTO ziw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ichindedi Helode na Pontiyo Pilato wadugana hamwenga na sawo Wayahudi mo mzi uno wakatenda na wantu wa Izulaeli kumhiga Yesu, mtumwa ywako akukile, umtendile Kulisito Mkombola. ");
INSERT INTO ziw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Wadugana chani wadamanye chila chintu chiya weye kwa udahi wako na kunga kwako, kugamba na vilaile. ");
INSERT INTO ziw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Haluse, Zumbe, kaula wachitisa, chidahize watumwa wako chilonge ulosi wako kwa ukankalu wose. ");
INSERT INTO ziw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Chulusa umkono wako chani uhonye wantu, damanya mpituko na vilagiso kwa Zina dya Yesu mtumwa ywako akukile.” ");
INSERT INTO ziw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Weze wabinde ukulombeza kwa Chohile, hantu naweli hasingisika. Wose niyo wamemezwa Muye Ukukile nakukonga kulonga ulosi wa Chohile kwa ukankalu. ");
INSERT INTO ziw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Fyo dya wazumile nawekevana mwe zifanyanyi na mwe myoyo. Hahali hata yumwenga mwawo agambile chintu ananacho ni chakwe mwenye, mna wahanganila vintu vyawo wananavyo. ");
INSERT INTO ziw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kwa nguvu nkulu wasigilwa waukula kuyuka kwa Zumbe Yesu, Chohile naye kawajimbika wose. ");
INSERT INTO ziw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mwedifyo dyawo nahehena mntu akaunga chintu. Wadya wata nkonde hegu nyumba wazitaga, hela wahokele wegala kwedifyo, ");
INSERT INTO ziw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nakuwenka wasigilwa, izihela izo zipangilwa kwa chila yumwenga viya akunga. ");
INSERT INTO ziw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ivyo Yusufu, mlawi elekwe Sipulasi etangwe ni wasigilwa Banaba, nuko kugamba “Akujela moyo”, ");
INSERT INTO ziw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","kataga nkonde yakwe niyo awenka wasigilwa izihela. ");
INSERT INTO ziw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mntu yumwenga akwitagwa Ananiya, hamwenga na mkaziwe Safila wataga nkonde yawo. ");
INSERT INTO ziw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Mna nawevana na mkaziwe wekiye hamwenga hela niyo wenkiza zisigale kwa wasigilwa. ");
INSERT INTO ziw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petulo amgamba, “Ananiya nimbwani ukamwinka Shetani luhenyo na kumdanta Muye Ukukile kwa kusigaza hela uhokele mo kutaga inkonde yenyu? ");
INSERT INTO ziw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nkonde naniyako umo hunati kuitaga, izihela izo nanizako umo utagile kale. Nimbwani naho ukudamanya imbuli ino? Humdantile mntu, kumdanta Chohile.” ");
INSERT INTO ziw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aho, Ananiya eze eve imbuli iyo, agwa hasi na kubanika, woseni wevile imbuli iyo niyo wengilwa ni woga. ");
INSERT INTO ziw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wabwanga weza na kuuvisa sanda umwili wakwe na kuuhamba. ");
INSERT INTO ziw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Yeze yabule masaa matatu vino, mkaziwe akatenda haimanyize imbuli ilaile, engila. ");
INSERT INTO ziw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petulo amuza, “Nigambila, vino chino nichihimo chose mhokele weye na mgosiwo kwa kutaga inkonde yenyu?” Safila ahitula, “Nichindedi, ni chihimo chijima.” ");
INSERT INTO ziw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petulo amgamba, “Nimbwani weye na mgosiwo mwaujeza Muye wa Chohile? Wantu wamhamba mgosiwo we ho lwivi, nawakuguhe weye nawe” ");
INSERT INTO ziw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aho naye agwa nakubanika. Wadya wabwanga wengila na kumbwila kabanika, wamlavya wakumhamba hankanda he mbila ya mgosiwe. ");
INSERT INTO ziw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wantu wose we nyumba yo kuvikila na wantu watuhu wevile imbuli iyo niyo wengilwa ni woga. ");
INSERT INTO ziw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Wasigilwa wadamanya mpituko na vilagiso vilozize mwa wantu. Wazumile wose niyo waduganaga hamwenga holwazo lwa Sulemani. ");
INSERT INTO ziw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mntu suyo kanuni hajezize kulungana nawo, wantu watuhu sawo wo uzumizi umwe wawatogola. ");
INSERT INTO ziw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wantu walozize niyo wakonga kwingila mweidifyo, fyo dya wagosi na wavyele wamzumila Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Wantu nawakegala wanyonje mwezisila na kuwagoneza mwezisazi na micheka chani chizuli cha Petulo chiwagubike wamwe wawo umo akajinka. ");
INSERT INTO ziw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mafyo ya wantu kulaila mwemizi ikuzunguluka Yelusalemu wegala wanyonje na wata mpepo nchafu, nawo wose niyo wahonywa. ");
INSERT INTO ziw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Niyo Mlavyantambiko mkulu naweyawe wose, wantu wa bunga dya Masadukayo, wengila finju. ");
INSERT INTO ziw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wawagwila wasigilwa na kuwajela mndani. ");
INSERT INTO ziw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mna ichilo icho mndima ywa kwembingu ywa Zumbe niyo awavugwila ulwivi wafose, nakuwagamba, ");
INSERT INTO ziw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kachimaleni kwe Nyumba nkulu ya Chohile nakuwagambila wantu mbuli za ujima uno mhya”. ");
INSERT INTO ziw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Dikaswa wasigilwa wengila mwe Nyumba nkulu ya Chohile nakukonga kuhinya. Mlavyantambiko mkulu na weyawe wawetanga hamwenga wantu wakulu wose Wayahudi mwe mdugano we Chitala, niyo wasigila wasigilwa wadya wegalwe kulongozi kwawo. ");
INSERT INTO ziw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mna wamizi wasigilwe weze wabule kwedijeleza, hawawabwile wasigilwa, ivyo wauya kwe chitala kuilonga imbuli iyo, ");
INSERT INTO ziw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Chize chibule kwedijeleza chibwila ulwivi luvugalwa, naho wamizi nawo wemwendima yawo, mna chize chivugule ulwivi, hachibwile mntu mndani”. ");
INSERT INTO ziw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Walavyantambiko wakulu na vilongozi we Nyumba nkulu ya Chohile weze weve imbuli iyo, wehelwa, ni chibwani chiwalaile wasigilwa. ");
INSERT INTO ziw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Niyo alaila mntu, engila kuwagamba, “Tegelezani, wadya wantu mjeile mndani mwe nyumba nkulu ya Chohile wahinya wantu.” ");
INSERT INTO ziw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ivyo yudya mkulu na wantu wakwe waita wakuwavuza wamizi awo. Hawawagwile kwa nguvu kwaviya nawakogoha wanasekutoigwa mayuwe. ");
INSERT INTO ziw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wawachimalisa wasigilwa mwe chitala chikulu, Mlavyantambiko Mkulu niyo awauza. ");
INSERT INTO ziw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Chiwaunga msekuhinya kwa zina dya yuno mntu, mna kaulani icho mdamanye, mahinyo yenyu yazagala Yelusalemu yose, naho mwaunga mchitende suwe chimkoma yuno mntu.” ");
INSERT INTO ziw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petulo na wasigilwa weyawe wahitula, “Chaungwa chimwive Chohile, mna sawo wantu. ");
INSERT INTO ziw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Chohile ywa watati zetu kamuuyusa Yesu mwize mumkome kwa kutundikwa mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Chohile kamwinula komkono wakwe wa kulume atende chilongozi na mhonyi kuwenka wantu wa Izulaeli chipindi cha kulombeza kulekeilwa masa yawo, naho masa yawo nayauswe. ");
INSERT INTO ziw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Suwe chiwaukuzi we zimbuli zino, Chohile kawenka Muye Ukukile wadya wakumwiva naye aukula imbuli iyo.” ");
INSERT INTO ziw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wantu chitala weze weve niyo wehiwa kubula waunge wasigilwa wadya wakomwe. ");
INSERT INTO ziw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mna yumwenga mwawo, Falisayo akwitangwa Gamalieli, mhinyi ywa Sigilizi akutunyiswa ni wantu wose, niyo achimala. Awaunga wasigilwa watendegezwe hadodo, ");
INSERT INTO ziw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","niyo alonga kwechitala, “Waizulaeli weyangu, msinyise chino mkunga muwadamanyize wano wantu. ");
INSERT INTO ziw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mwakumbuka kugamba Teuda aho chikale alailaga akagamba yeye ni mntu mkulu, wantu wakubula magana milongo mine niyo wahangana naye. Mna niyo akomwa, wadya wose nawakamtimila watimkana, imbuli yakwe nayo ifila aho. ");
INSERT INTO ziw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yuda wa Galilaya naye niyo alaila chipindi cha kuwazwa, naye atimilwa ni fyo, mna naye kakomwa, wose nawakumtimila niyo watimkana. ");
INSERT INTO ziw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Haluse mwe imbuli ino, nawagambila msekuwatenda chintu wantu wano. Walekeni wenye, hegu chino wakutenda ni chamntu, nachagile, ");
INSERT INTO ziw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","mna hegu uneva chalaila kwa Chohile hamkudaha kuchihinga. Mwadaha kutenda mwamhiga Chohile.” Ichitala niyo chatimila yadya alongile Gamalieli. ");
INSERT INTO ziw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wawetanga wasigilwa nakuwahuta hamwenga nakuwaunga wasekuhinya naho kulonga kwa zina dya Yesu niyo wawalekela. ");
INSERT INTO ziw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wasigilwa weze walawe mwechitala weleleswa kwaviya Chohile kawawona wawagilwa wakunte kwachausa cha Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Chila zuwa mwe Nyumba nkulu ya Chohile na mwe izikaya za wantu nawakahinya na kulonga mbuli zedi za Yesu Kulisito Mkombola. ");
INSERT INTO ziw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mazuwa ayo, umo wanampina wakajenyela, kwendaga na mang'ung'uziko mgati mwa wadya Wayahudi wakulonga chigiliki na wadya wakulonga Chiebulaniya. Wadya wendaga akalonga Chigiliki na wakang'ung'uzika kugamba wavyele wabanikilwe ni wagosi zawo nawakajalwa mo kuwapangila mwe viya wakunga chila zuwa. ");
INSERT INTO ziw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ivyo wadya wasigilwa mlongo na waidi niyo wetanga hamwenga na wanampina na wazumile nakuwagamba, “Siyo vyedi suwe chileke kulonga mbuli yedi ya Chohile chisinye mbuli za hela. ");
INSERT INTO ziw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ivyo, walukolo, sagulani wantu mfungate mgati mwenyu mkumanya wamema Muye Ukukile na umanyi chiwatende wakunga watimile imbuli ino. ");
INSERT INTO ziw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Suwe wenye chitende na chipindi chitali cha kulombeza kwa Chohile na kulonga mbuli zedi za Chohile.” ");
INSERT INTO ziw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Idifyo jima dya wazumile dibweda viya waungile awasigilwa, elo wamsagula Sitefano, mntu amemile uzumizi na Muye Ukukile, watuhu ni Filipo, Plokolo, Timoni, Pamena na Nikolawo mhituki wa Antiyokiya ahitukile kutimila dini ya Chiyahudi. ");
INSERT INTO ziw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Idifyo diwegala kwa wasigilwa, wawalombezeze kwa Chohile nakuwajelekela mikono. ");
INSERT INTO ziw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mbuli ya Chohile niyo yajendeleza kuzagala. Wanampina wajenyela vitendese, walavya ntambiko walozise wahokela uzumizi. ");
INSERT INTO ziw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitefano, ajimbikiswe ni Chohile, naho amemile nguvu, kadamanya mpituko na vilagiso vilozize mwa wantu. ");
INSERT INTO ziw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mna wantu wasiku walaila chani wahigane na Sitefano. Mgati mwa wantu awo wendaga ni wantu wanyumba ya kuvikila ikwitangwa Mahulu, naina Wayahudi wakulaila Kilene na Wasikandaliya. Wawo hamwenga na watuhu wakulaila Silisiya na Asiya nawakamlaha Sitefano. ");
INSERT INTO ziw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mna wadunduga kumhuma kwachausa cha umanyi wakwe na kwachausa cha Muye Ukukile amlongoze Sitefano kulonga, hawamlemele. ");
INSERT INTO ziw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ivyo wawafumbasa wantu wamwenga wagambe, “Chimwiva akamhiga Musa na Chohile.” ");
INSERT INTO ziw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Elo niyo wawasongaganya wantu na wadalahala, na wahinya Sigilizi. Wamgwila Sitefano nakumwigala kwechitala. ");
INSERT INTO ziw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Niyo wegala wantu waukule udanti kugamba, “Mntu yuno chila nkanana nakahuluta Nyumba ya Chohile, na Sigilizi ya Musa.” ");
INSERT INTO ziw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Chimwiva akagamba, Yesu ywa Nazaleti nagwise Nyumba ya Chohile nakuhitula mazwela yatendigwe ni Musa. ");
INSERT INTO ziw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wose wekalaga mwe Chitala wamsinya Sitefano nakumwona uso wakwe wikala saviya mndima ywa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mlavyantambiko mkulu amuza Sitefano, “Vino ni chindedi?” ");
INSERT INTO ziw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitefano ahitula, “Walukolo na watate, netegelazani, umo mkale ywetu Bulahimu henati kwita kwikala Halani, Chohile atakate kamlaila Bulahimu uko Mesopotaniya ");
INSERT INTO ziw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","nakumgamba, ‘Yase ikaya yako na isi wite kwe si hunga hulagise.’ ");
INSERT INTO ziw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Niyo ayasa isi yakwe niyo aita Halani. Tati yakwe Bulahimu eze abanike, Chohile kamsamiza amwigala kwe isi mkwikala vino haluse. ");
INSERT INTO ziw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Chohile hamwinkile Bulahimu hantu hohose hatende ulisi wakwe mwenye, henkigwe hata ntendele, mna Chohile amgambilaga namwinke itende yakwe hamwenga na lukolo lwakwe. Chohile akadamanya ivyo Bulahimu nahena mwana. ");
INSERT INTO ziw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Vino nivyo Chohile amgambaga, ‘Cheleko chako nachikale kwe si ya wenye, uko nawatende watumwa nakudamanywa vihiye kwa mihilimo magana mnane. ");
INSERT INTO ziw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mna naniwakantile wadya wantu wose wakunga wawatendeni watumwa. Akajika naniwalavye mwe isi iyo chani weze wanisankanile hantu hano.’ ");
INSERT INTO ziw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Niyo Chohile amwinka lagano dya ngasu. Bulahimu niyo amjela ngasu Isaka mazuwa mnane eze elekwe. Isaka naye amjela ngasu mwanawe Yakobo, Yakobo naye awajela wanawe mlongo na waidi, tati yetu chizwele we ichipindi chino chinanacho.” ");
INSERT INTO ziw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Wana Yakobo wengila finju kwa mlukolo ywawo Yusufu na kumtaga atende mtumwa uko Misili. Mna Chohile endaga hamwenga na Yusufu, ");
INSERT INTO ziw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nakamusiza nkunto zose adugane nazo. Yusufu eze alaile mwa meso ya Falao zumbe ywa Misili, Chohile amjimbika na kumwinka umanyi, zumbe naye amwinka Yusufu uzumbe we isi na ukulu wo ugoli wose. ");
INSERT INTO ziw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Niyo kwagwa gumbo mwe isi yose ya Misili na Kanani, itendile watati zetu wanyale vidala kwa kuswesa nkande, ");
INSERT INTO ziw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobo eze eve kugamba Misili kuna nkande niyo awasigila wanawe, watati zetu, mo kutalamka kwawo nkanana ya nkongo. ");
INSERT INTO ziw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mwe ntambo ya kaidi, Yusufu niyo etambalisa kwa walukolo wakwe, Seuta ywa Misili naye amanya ulukolo lwa Yusufu. ");
INSERT INTO ziw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu niyo amsigila tati yakwe Yakobo, kugamba, ulukolo lose lukubula wantu milongo mfungate na washano vino, wabule Misili. ");
INSERT INTO ziw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakobo niyo aita Misili, uko yeye hamwenga na wanawe wabanikila uko. ");
INSERT INTO ziw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Wakuzikilwa Shekemu mwe mbila agwile Bulahimu kulawa mwe lukolo lwa Hana kwa chiyasi cha hela. ");
INSERT INTO ziw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Wantu nendile wongezeka kudya Misili umo Chohile akadamanya ndagano amgambilaga Bulahimu. ");
INSERT INTO ziw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Niyo kwalaila zumbe hemmanyize Yusufu akongile kuilongoza Misili. ");
INSERT INTO ziw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Awadamanyiza chijilajila watati zetu na kuwadamanya vihiye, kuwaunga wawaike kuse watiti wawo wabanike.” ");
INSERT INTO ziw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Musa, mwana mtana vidala, elekagwa mwe chipindi chino, kasinywa vyedi kwawo kwa myezi mitatu, ");
INSERT INTO ziw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","eze alavigwe kuse niyo mwana chivyele ywa Seuta Falao amlogota na kumlela akule. ");
INSERT INTO ziw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa niyo ahinywa umanyi wose wa Chimisili, naye niyo atenda mntu mkulu mwe milosi na ntendwa.” ");
INSERT INTO ziw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Musa eze abule mihilimo milongo mine awona akaule ntendwa wakudamanywa Waizulaeli weyawe. ");
INSERT INTO ziw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Awona yumwenga akadamanywa vihiye ni Mmisili, niyo akumwambiza na kumvuziza Mmisili uyo kwa kumkoma. ");
INSERT INTO ziw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nakamanya wantu wakwe nawamanye kugamba Chohile namjeseze awatende walekeilwe mna hawabunkule. ");
INSERT INTO ziw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Zuwa ditimile awona Waizulaeli waidi watowana, niyo ajeza kuwalamwila na kuwagamba, ‘Wagosi tegelezani, nyuwe mwi wamwe, ni mbwani mkudamanyizana yehiye?’ ");
INSERT INTO ziw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mna yudya na kamtowa mnyawe niyo amsindika Musa hankanda, na kumuza, ni yuhi akutendile mkanti ywetu uchilamwile? ");
INSERT INTO ziw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wonga unikome saviya umkomile yudya Mmisili gulo? ");
INSERT INTO ziw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa eze eve ivyo, aisumka isi ya Misili na kwita si ikwitangwa Midiyani, uko keleka wana waidi. ");
INSERT INTO ziw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Mihilimo milongo mine ize ijinke mndima ywa kwembingu ywa Zumbe amlaila Musa heluwala mwe moto wa kasaka kakuhya hajihi na lugulu lwa Sinai. ");
INSERT INTO ziw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa kehelwa chiya awone niyo akasogeila akasaka ako asinye vyedi chikulaila. Mna niyo eva izwi dya Zumbe, ");
INSERT INTO ziw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Miye ni Chohile ywa watati zenyu, Chohile ywa Bulahimu na Isaka na Yakobo’. Musa azingiza kwa woga naho haungile kuhasinya. ");
INSERT INTO ziw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Zumbe amgamba, vula ivilatu vyako, hano uchimale hakukile. ");
INSERT INTO ziw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Siwona viya wantu wangu wadamanyizwe vihiye uko Misili, siva viya wakung'ung'uzika, ivyo siza husigile wite Misili, nonga walekeilwe. ");
INSERT INTO ziw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa nakalemelwa ni wantu wa Izulaeli, wakamuza, ni yuhi akutendile chilongozi na mlamuzi? Nuyo asigilwe ni Chohile kulongoza wantu na kuwatenda walekeilwe kwa kwambizwa ni mndima ywa kwembingu ywa Zumbe amlaile mwa kasaka kakuhya. ");
INSERT INTO ziw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kawalongoza wafose mwe isi ya Misili, kadamanya vilagiso na mpituko uko Misili na bahali inkundu na kwa mihilimo mine koluwala. ");
INSERT INTO ziw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa nuyo agambile wantu wa Izulaeli kugamba, Chohile nasigile muwoni saviya miye, naho natende yumwenga mwenyu. ");
INSERT INTO ziw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Umo Waizulaeli wadugane ho luwala, Musa neyuko saviya msigilwa hamwenga na watati zetu, mndima ywa kwembingu naye alongaga naye ho ulugulu lwa Sinai nakuhokela ulosi wa Chohile achigaile. ");
INSERT INTO ziw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mna watati zetu walemela kumwiva, wamsenta hankanda waunga wauye Misili. ");
INSERT INTO ziw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Wamgamba Haluni, chidamanyize mlungu akunga achilongoze, hachikumanya chimlaile Musa achilongoze kulaila Misili ni chibwani. ");
INSERT INTO ziw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Niyo wadamanya tukulu dya njeku, nakuivikila wakabweda chiya wadamanye. ");
INSERT INTO ziw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ivyo Chohile awahituka na kuwatenda wavikile ntondo za kwembingu saviya iwandikwe mwe vitabu vya wawoni, Wantu wa Izulaeli, nasuyo miye mnichinjize na kunilaviza nyama zenyu kwa mviko kwa mihilimo milongo mine kwenyika. ");
INSERT INTO ziw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nadyo idihema dya Nuwe namwinula kumbi dwa mlungu Moleki hamwenga na tukulu dya ntondo mlungu ywenyu Lefani yumwe, matukulu mdamanye nayo ifile. Naniwegale hale na Babeli. ");
INSERT INTO ziw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Watati zetu nawadamanya hema dya ukuzi wa Chohile uko koluwala. Nadidamanywa viya Chohile aungile, viya Musa alagiswe. ");
INSERT INTO ziw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aho kale watati zetu wahokelega idihema kulaila kwa watati zawo wadigale kwa Yoshuwa nakuguha si mwemikono ya wanasi naweyumo waguluswe ni Chohile mo lujendo. Niyo dyekala uko kubula mwe chipindi cha Daudi. ");
INSERT INTO ziw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi ankagwa kuhingizwa ni Chohile, niyo amlombeza amzengele hantu hakwikala uyo Chohile ywa Yakobo. ");
INSERT INTO ziw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mna nani Sulemani amzengele nyumba. ");
INSERT INTO ziw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Chohile ywa kulanga hakudaha kwikala mwe nyumba izengigwe ni mikono ya wantu, saviya muwoni akulonga, ");
INSERT INTO ziw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mbingu ni chigoda changu cho uzumbe, alonga Zumbe, isi nayo naika iviga vyangu. Ni nyumba ihi ukunga unizengele? Nihahi hunga nikale? ");
INSERT INTO ziw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Vintu vino vyose sividamanya mwenye?’ ” ");
INSERT INTO ziw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitefano ajendeleza kulonga, “Nyuwe hemkwiva, myoyo yenyu ivivihi! Nimbwani hemkwiva ulosi wa Chohile, mwikala saviya wadalahala wenyu, nyuwe nanywi mwamlemela Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Togolani! Kuna muwoni yoyose wawadalahala wenyu hawamsulumize? Wakoma wasigilwe ulosi ni Chohile, walongaga chikale wizilo wa mtumwa wakwe wa chindedi. Nyuwe nanywi mumhituka na kumkoma. ");
INSERT INTO ziw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ninyuwe mwahokelaga sigilizi ya Chohile mwinkigwe kwa sila ya wandima wa kwembingu, mna hamkuzitimila.” ");
INSERT INTO ziw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wadya wemweichitala weze wamwetegeleze Sitefano, niyo wengila maya vidala. ");
INSERT INTO ziw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mna Sitefano amemile Muye Ukukile, asinya kulanga nakuwona ukuka wa Chohile, Yesu naye kachimala halume ha Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Awagamba, “Kaulani, nawona mbingu igubuka naho Mwana ywa Adamu ehalume ha Chohile.” ");
INSERT INTO ziw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Woseni mwe chitala waguta wagubika magutwi nemikono yawo wakamgulukila. ");
INSERT INTO ziw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Wamlavya mo mzi niyo wamtowa mayuwe. Waukuzi niyo wasa suche zawo kwe mbwanga akwitangwa Sauli. ");
INSERT INTO ziw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wajendeleza kumhuta mayuwe Sitefano umo akamwitanga Zumbe, “Zumbe Yesu, hokela umuye wangu” ");
INSERT INTO ziw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Afika madi akamgutila, “Zumbe, usekufanyanya masa yano wakudamanya, naye niyo abanika.” ");
INSERT INTO ziw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauli mwa amazuwa ayo wantu we mwe Nyumba yo kuvikila wakonga kusulumizwa. Wazumile wose, ukaleka wasigilwa wamwaganikana mwe mizi ya Yudeya na Samaliya. ");
INSERT INTO ziw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Wantu welavize kwa Chohile wamhamba Sitefano wamwombolezeza kwa ndilo nkulu. ");
INSERT INTO ziw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mna Sauli nakonga abinde wantu wose wa bunga dya wamzumile Kulisito, kaya kwa kaya kuwabuluza wazumile wagosi kwa wavyele kuse na kuwajela mwedijeleza. ");
INSERT INTO ziw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Wazumile wazagale wabula chila hantu wakulonga mbuli ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo kaita komzi mkulu wa Samaliya na kulonga mbuli za Kulisito Mkombola kwa wantu wauko. ");
INSERT INTO ziw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mafyo ya wantu wamwetegelezesa Filipo nakukaula mpituko nakadamanya. ");
INSERT INTO ziw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mpepo nchafu ziwalawa wantu walozize kwa kugutisa, viwete nawaholomale walozize wahonywa. ");
INSERT INTO ziw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ivyo nakuna chinyemi chikulise mo mzi uwo. ");
INSERT INTO ziw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nahana mgosi yumwenga akwitangwa Simoni akwikala mo mzi uwo, Wasamaliya nawakamwehelwa kwausai wakwe. Nakegamba ni mntu mkulu, ");
INSERT INTO ziw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","chila yumenga mo mzi nawakamsinyisa mgosi uyo wagamba “Ni mntu mta udahi wa Chohile ukwitangwa ‘Nguvu nkulu.’ ” ");
INSERT INTO ziw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nawakamwona ivyo kwaviya nawakamwehelwa tangu chikale kwausai wakwe. ");
INSERT INTO ziw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mna weze wazumile Filipo mwe mbuli yedi ya Uzumbe wa Chohile ya Yesu Kulisito niyo wagosi kwa wavyele wabatizwa. ");
INSERT INTO ziw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoni naye kazumila, eze abatizwe ekala hajihi na Filipo, niyo ehelwa mpituko nkulu na vilagiso vikudamanywa ni Filipo. ");
INSERT INTO ziw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Uko Yelusalemu wasigilwa weva kugamba wantu wa Samaliya wahokela ulosi wa Chohile, ivyo wawasigila Petulo na Yohana wawabwile. ");
INSERT INTO ziw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Weze wengile wamlombeza Chohile awengize Muye Ukukile wazumile. ");
INSERT INTO ziw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kwaviya nahahana hata yumwenga engilwe ni Muye Ukukile, nawabatizwa du kwa Zina dya Zumbe Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Petulo na Yohana niyo wawajelekela mikono wahokele Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni niyo alavya hela kwa wasigilwa eze awone wazumile wahokela Muye Ukukile weze wajelekelwe mikono ni Petulo na Yohana, ");
INSERT INTO ziw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","nakuwagamba, “Ninkani udahi uno chani nami hajelekela mntu mikono ahokele Muye Ukukile.” ");
INSERT INTO ziw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mna Petulo amhitula, “Weye hamwenga neizihela zako mkadulwe kwe bome hedina uhelo kwaviya wafanyanya kugamba jeleko dya Chohile dyagulwa kwa hela. ");
INSERT INTO ziw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Weye huna ntendele yoyose naho wedi mwe mbuli ino, kwaviya moyo wako hauchumile kulongozi kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Leka ubala wako wihiye, naho mlombeze Chohile nakulekeile kwa fanyanyi zako za chintu sachino. ");
INSERT INTO ziw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kumema finju naho wimfungwa ywa masa.” ");
INSERT INTO ziw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni awagamba Petulo na Yohana, “Nilombezezani kwa Zumbe, chani mbuli zino zose mlongile zisekunilaila.” ");
INSERT INTO ziw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Weze wajike kuukula na kulonga mbuli ya Zumbe, Petulo na Yohana waogola kuya Yelusalemu. Mweisila wakauya walonga mbuli zedi za Chohile mwekaya zilozize za Samaliya. ");
INSERT INTO ziw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mndima ywa kwembingu ywa Zumbe kalonga na Filipo akamgamba, “Kwemalanye wite kwamwenye mzi, kwesila ikwita Gaza kulaila Yelusalemu.” ");
INSERT INTO ziw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipo emalanya, akonga ntambo. Chipindi icho mntu Mwisiopiya towashi mdamanya ndima mwa zumbe mkulu ywa Kushi nakatamba kuya kaya kwakwe. Nakalaila Yelusalemu kwekumvikila Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Umo akatamba nemwelingisha dyakwe. Nakasoma chitabu cha muwoni Isaya. ");
INSERT INTO ziw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Muye Ukukile alonga na Filipo, “Sogela hajihi nedilingisha utende hajihi nadyo.” ");
INSERT INTO ziw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo adigulukila nakumwiva akasoma chitabu cha muwoni Isaya. Amuza, “Kuchimanya icho ukusoma?” ");
INSERT INTO ziw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mntu uyo amhitula, “Nanimanye vivihi hehena mntu wakunivilikiza?” Niyo amunga Filipo akwele mwedilingisha wekalanye. ");
INSERT INTO ziw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mawandiko nakasoma nayakagamba, “Saviya ngoto ikunga ichinjwe, saviya mwanangoto anyamale akumonywa mazoya, hasimwile ulosi. ");
INSERT INTO ziw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Wamtila na kunyimwa wedi. Hahali nadahe kulongela mwe cheleko chakwe, kwaviya ujima wakwe usigwa mwe isi.” ");
INSERT INTO ziw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mkulu uyo amuza Filipo, “Nigambila, muwoni yuno alonga kumlanga yuhi? Elongela mwenye hegu mntu mtuhu?” ");
INSERT INTO ziw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo niyo akonga kulonga, kukongela hantu hano hamawandiko, amgambila mbuli yedi ya Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Umo wakatamba mwesila wabwila hantu hana mazi, mkulu uyo agamba, “Hano hana mazi, nichibwani chikunichinda nisekubatizwa?” ");
INSERT INTO ziw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo amgamba, “Wadaha kubatizwa uneva wazumila kwa moyo wako wose.” Ahitula, “Nazumila, nazumila kugamba Yesu Kulisito ni Mwana ywa Chohile” ");
INSERT INTO ziw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mkulu uyo achimalisa idilingisa, niyo Filipo hamwenga naye waita kwa mazi, Filipo ambatiza. ");
INSERT INTO ziw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Weze walawe mwa mazi Muye wa Zumbe amguha Filipo. Mkulu uyo hamwone naho, mna niyo ajendeleza noutafi wakwe kuno amemile mbwedo. ");
INSERT INTO ziw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo awonekana Azota, aita Kaisaliya mwesila chila mzi asimwila na wantu Mbuli Yedi ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sauli nakajendeleza kuwatisa kunga kuwakoma wanampina wa Zumbe. Niyo aita kwa Mlavyantambiko mkulu ");
INSERT INTO ziw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nakulombeza baluwa abule Damesiki engile mwe nyumba zo kuvikila akalonde Wayahudi nawakamtimila Zumbe awagwile wagosi kwa wavyele awavuze Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sauli akabula hajihi nomzi wa Damesiki, aho atoigwa nilumwemwe kulaila kulanga kwembingu. ");
INSERT INTO ziw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Niyo agwa hasi nakwiva izwi dikumgamba, “Sauli, Sauli nimbwani ukunijela maya?” ");
INSERT INTO ziw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Amuza, “Zumbe weye wiyuhi?” Idizwi dyagamba, “Nimiye Yesu ukunijela maya.” ");
INSERT INTO ziw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Mna chimala ubule komzi, naugambilwe ivyo ukungwa udamanye.” ");
INSERT INTO ziw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wantu nawakatamba na Sauli nawachimala, hawalongile dyodyose, weva idizwi mna hawawone yoyose. ");
INSERT INTO ziw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli achimala nakugubula meso, mna nahakuwona. Wamtoza mkono nakumwigala Damesiki. ");
INSERT INTO ziw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kwa mazuwa matatu hawone, hadile naho hanywele chintu. ");
INSERT INTO ziw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nakuna mwanampina uko Damesiki akwitangwa Ananiya, nakalota nomsi Zumbe asimwila naye, “Ananiya” Ahitula, “Zumbe nihano.” ");
INSERT INTO ziw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Zumbe amgamba, “Hita hesila ikwitangwa ichumile, mwe nyumba ya Yuda uza mntu akulaila Taso akwitangwa Sauli vino haluse amlombeza Chohile, ");
INSERT INTO ziw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","mo uwoni kawona mntu akwitangwa Ananiya akengila na kumjelekela mikono chani awone naho.” ");
INSERT INTO ziw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya ahitula, “Zumbe wantu walozize wanigambila mbuli za mntu yuno, naho mweviya awadamanyize vihiye wantu wako wa Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Naho keza Damesiki asigilwe ni walavyantambiko wakulu kuwagwila wose wakukuvikila.” ");
INSERT INTO ziw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Zumbe amgamba, “Hita, kwaviya simsagula mtu uyo anisankanile, chani Zina dyangu dimanyike mwa sawo Wayahudi na maseuta na wantu wa Izulaeli. ");
INSERT INTO ziw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Naho nanimlagise vyose akunga asulumizwe kwa chausa che dizina dyangu.” ");
INSERT INTO ziw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ivyo Ananiya aita, engila mwekaya neli Sauli nakumjelekela mikono. Agamba, “Sauli, Zumbe Yesu, akulaile mwesila ukeza kuno kanisigila. Kanisigila uwone naho nakumemezwa Muye Ukukile.” ");
INSERT INTO ziw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aho, vintu vikale saviya magome ya samaki yalagala kulaila mwameso ya Sauli, niyo awona naho. Achimala nakubatizwa, ");
INSERT INTO ziw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","eze adye, niyo apata nguvu vituhu. Sauli niyo ekala kwa mazuwa majeche hamwenga na wanampina wendile uko Damesiki. ");
INSERT INTO ziw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kaita kwenyumba zo kumvikila Chohile nakukonga kumlonga Yesu kugamba ni mwana ywa Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Woseni wamwivile wehelwa wakauza, “Suyo yudya nakawakoma wadya wakumvikila Yesu uko Yelusalemu? Naho habasize kugwila nakuwavuza wantu awo kwa walavyantambiko wakulu?” ");
INSERT INTO ziw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mna Sauli kajendeleza kutende na nguvu, naviya alongile pwilili kugamba Yesu ni Kulisito kutenda Wayahudi nawakekala Damesiki wasekumhitula. ");
INSERT INTO ziw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mazuwa yalozize yeze yajinke, Wayahudi wekala hamwenga nakudamanya ubala wa kumkoma Sauli, ");
INSERT INTO ziw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","mna Sauli agambilagwa ubala wawo. Chilo na msi nawakadima izinyivi chani wamkome. ");
INSERT INTO ziw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mna zuwa dimwenga nechilo wanampina wa Sauli wamguha na kumsumsa kwa kumjisiza mwe lupwapwazi lwa chiwambaza, na kumseleza mwe gahu na luzigi kuse kwe chiwambaza. ");
INSERT INTO ziw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli nakaita akahangane na wanampina. Mna nawakamwogoha, hawamzumile kugamba naye ni mwanampina. ");
INSERT INTO ziw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Niyo Banaba niyo eza amguha Sauli amwigala kwa wasigilwa Awagambila viya Sauli amwone Zumbe mwesila, na viya asimwile naye. Naho awagambila viya Sauli asimwile mbuli zedi za Chohile kwa ukankalu uko Damesiki mwe Zina dya Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ivyo Sauli ekala hamwenga nawo niyo aita mwe Yelusalemu yoseni wakalonga ulosi wa Zumbe kwa ukankalu. ");
INSERT INTO ziw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Naho kalonga na kuhigana na Wayahudi wakusimwila Chigiliki, mna nawakonga wamkome. ");
INSERT INTO ziw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wazumile weze weve imbuli iyo, wamwigala Sauli Kaisaliya wamleka aite Taso. ");
INSERT INTO ziw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Chipindi icho bunga dya wamzumile Kulisito dya Yudeya na Galilaya na Samaliya nadizengwa na kukula mwe kumvikila Zumbe, nakujenyela dikajelwa moyo ni Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petulo katamba chila hantu, niyo awatalamkila wantu wa Chohile wakwikala Lida. ");
INSERT INTO ziw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Uko abwila mntu yumwenga aholomale akwitangwa Aineya, hedahile kwinuka mo lusazi kwa mihilimo mnane. ");
INSERT INTO ziw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petulo amgamba, “Aineya,.” “Yesu Kulisito akutende mjima. Inuka utandike ulusazi lwako.” Aho Aineya enuka. ");
INSERT INTO ziw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wantu woseni nawekala Lida na Shaloni wamwona nakumhitukila Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Uko Yafa nakuna mvyele akwitangwa Tabita, nanimzumizi. Zina dyakwe Chiyunani ni Dokasi nuko kugamba “mpala”. Kajeseza chipindi chakwe choseni kudamanya yedi na kwambiza wachiwa. ");
INSERT INTO ziw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ichipindi icho katenda mnyonje niyo abanika. Umwili wakwe uhakwa mazi niyo wagonezwa kwegolofa. ");
INSERT INTO ziw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yafa nasiyo hale kulaila Lida, wanampina uko Yafa weva kugamba Petulo eyuko Lida, niyo wasigila wantu waidi wakamgambe abule kwawo. ");
INSERT INTO ziw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ivyo Petulo niyo aita, eze abule egalwa kwegolofa, uko wavyele woseni wabanikilwe ni wagosi wamlagisa suche adamanyaga Dokasi umo emjima. ");
INSERT INTO ziw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petulo awalavya woseni kuse, afika madi nakulombeza kwa Chohile, niyo auhitula umwili nakugamba, “Tabita, chimala” Agubula ameso yakwe, eze amwone Petulo niyo ekala. ");
INSERT INTO ziw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petulo amsogeila nakumwambiza enuke. Niyo awetanga wazumile woseni hamwenga na woseni wabanikilwaga ni wagosi, wamwone ni mjima. ");
INSERT INTO ziw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mbuli izo zizagala Yafa yose, niyo wantu walozize wamzumila Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petulo kekala uko Yafa mazuwa yalozize mwekaya ya mntu akwitangwa Simoni, msuma mikota. ");
INSERT INTO ziw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nakuna mntu yumwenga akwitangwa Koneliyo, nakekala Kaisaliya, nanimkulu ywa bunga dya wankondo wa Chilumi chikwitangwa “Bunga dya Italiya”. ");
INSERT INTO ziw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nanimtu ywa dini, uyo hamwenga nekaya yakwe nawakamvikila Chohile. Naho nakawambizisa Wayahudi wachiwa nakumlombeza Chohile chipindi choseni. ");
INSERT INTO ziw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yendaga sachenda yamsi, umo awonaga uwoni nomsi, amwona mndima ywa kwembingu ywa Chohile pwilili akamgamba, “Koneliyo!” ");
INSERT INTO ziw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Amsinya uyo mndima ywa kwembingu kwa woga na kumuza, “Zumbe, kunambwani?” Mndima ywa kwembingu ahitula, “Chohile kahokela malombezi yako na malavyo yako kuwambiza wachiwa, havijale. ");
INSERT INTO ziw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Haluse sigila wantu waite Yafa wakamwitange mntu yumwenga akwitangwa Simoni zina dyakwe tuhu etangwa Petulo. ");
INSERT INTO ziw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Uyo emwenyumba ya msuma mikota akwitangwa Simoni, akwikala hajihi ne bahali.” ");
INSERT INTO ziw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mndima ywa kwembingu niyo ahalawa, Koneliyo ewetanga wandima wakwe waidi wa kukaya na mnkondo, mntu akutoza sila ya kumvikila Chohile yumwenga mwa wandima wakwe mwenye. ");
INSERT INTO ziw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kawagambila chilaile nakuwasigila uko Yafa. ");
INSERT INTO ziw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Zuwa ditimile, umo wemwe sila wakasogeila Yafa, Petulo akwela kulanga kwedigulu mwesa mtandatu nomsi akamlombeze Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nakalumwa ni sala, nakonga adye nkande, umo nkande ikadamanywa, niyo engilwa ni uwoni. ");
INSERT INTO ziw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Awona mbingu ikagubuka nakuwona chintu saviya suche nkulu ikuselezwa kulaila kulanga kuno itozwa mwe ntendele nne. ");
INSERT INTO ziw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Umo namna chila namna ya nyama na vikutambala na wadege wo ulanga. ");
INSERT INTO ziw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Izwi dyamgamba, “Petulo chimala, chinja udye.” ");
INSERT INTO ziw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mna Petulo agamba, “Zumbe havikudahika, sinati kudya chintu hachikuwagila kudigwa hegu chizavu.” ");
INSERT INTO ziw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Izwi dyamgamba naho, “Usekulonga chochose hachikuwagilwa kudigwa icho Chohile aungile chidigwe.” ");
INSERT INTO ziw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Vino vilaila nkanana ntatu, chintu icho niyo chavuzwa kwembingu. ");
INSERT INTO ziw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Umo Petulo akatenda kehelwa kuno akazungula amawono yagaze, wadya wantu wasigilwe ni Koneliyo wabunkula ikaya akwikala Simoni, niyo wachimala holwivi. ");
INSERT INTO ziw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wetanga nakuza, “Hano hana mjeni akwitangwa Simoni Petulo?” ");
INSERT INTO ziw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petulo nachei akajeza kukombaganya amawono ayo nayakagaze, aho Muye amgamba, “Tegeleza, hana wantu watatu wakukuzungula. ");
INSERT INTO ziw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sunguza sela usekutenda na nkama kwita nawo kwaviya nimiye niwasigile.” ");
INSERT INTO ziw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ivyo Petulo niyo asela akulonga nawo, “Nimiye mkuzungula. Mbasani?” ");
INSERT INTO ziw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wahitula, “Mnkondo mkulu Koneliyo kachisigila. Ni mntu ywedi akumvikila Chohile naho atunyiswa ni Uyahudi wose. Mndima ywa kwembingu ywa Chohile kamgamba akugoneke mwe kaya yakwe, etegeleze chochose ukunga ulonge.” ");
INSERT INTO ziw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petulo niyo awahokela wantu awenka hantu hakugona ichilo chiya. Zuwa ditimile enukila nawo, hamwenga nawazumile wamwenga kulaila Yafa. ");
INSERT INTO ziw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Zuwa ditimile engila Kaisaliya mzi nakagojwa ni Koneliyo, hamwenga nawandugu nawambuya wahajihi agoneke. ");
INSERT INTO ziw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Umo Petulo akengila, Koneliyo amhokela, afika madi kulonozi kwakwe. ");
INSERT INTO ziw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mna Petulo niyo amwinula. Amgamba, “Chimala, miye ni mntu du saviya weye.” ");
INSERT INTO ziw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petulo ajendeleza kulonga na Koneliyo umo wakengila mnyumba abwila wantu walozize wechisanya hamwenga. ");
INSERT INTO ziw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petulo awagamba, “Nyuwe wenye mvimanyisa vyedi kugamba Myahudi mwe sila yakwe yo kumlonda Chohile hakungwa kutalamkila hegu kuhangana na mntu suyo Myahudi. Mna Chohile kanilagisa kugamba nisekumwitana mntu yoyose mzavu hegu mta masa. ");
INSERT INTO ziw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Elo wize unisigile silemele. Haluse, nakuza kunitangilani?” ");
INSERT INTO ziw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koneliyo agamba, “Mazuwa matatu yajinkile chipindi sachino, sachenda nomsi nendile hamlombeza Chohile mwe nyumba yangu. Aho mntu avikile suche ikung'ala achimala halongozi hangu ");
INSERT INTO ziw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","anigamba, ‘Koneliyo, Chohile keva amalombezo yako naho kawona untu wako wedi. ");
INSERT INTO ziw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Sigila mntu aite Yafa ambase mntu akwitangwa Simoni Petulo. Nimjeni mwekaya ya Simoni mdamanya mikota akwikala mnkanda mwebahali.’ ");
INSERT INTO ziw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Elo ahadya niyo nasigila wantu, wenawe kutenda ywedi, kwiza. Haluse wose chihano halongozi ha Chohile, chagoja chitegeleze dyodyose Zumbe akusigile uchigambile.” ");
INSERT INTO ziw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petulo akonga kulonga, “Haluse nabunkula kugamba, nichindedi Chohile hakupagula amdamanyiza chila yumwenga saviya akudamanya kwa mtuhu. ");
INSERT INTO ziw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wadya wakumvikila nakudamanya yedi hakukaula walaila mwe si yani. ");
INSERT INTO ziw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mwimanya mbuli asigile kwa wantu wa Izulaeli, ikulonga Mbuli Yedi ikwigala utondowazi mwa Yesu Kulisito Mkombola Zumbe ywa wose. ");
INSERT INTO ziw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Myamanya mabuli makulu yalaile mwe si yose ya Izulaeli kukongela Galilaya, Yohana eze alonge ulosi wa ubatizo. ");
INSERT INTO ziw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mmanya viya Yesu ywa Nazaleti, naviya Chohile amwitile Muye Ukukile na nguvu. Kabula chila hantu akadamanya yedi na kuhonya wose nawakazilwa ni yudya mwavu, kwaviya Chohile nehamwenga naye. ");
INSERT INTO ziw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Suwe chiwaukuzi mwe chila chilaile mwe si ya Izulaeli na Yelusalemu. Wamkoma kwa kumtungikwa mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mna Chohile kamuuyusa mazuwa matatu yatimile nakumtenda alaile, ");
INSERT INTO ziw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","siyo kwa chila yumwenga, mna kwa waukuzi wa Chohile asagulaga, adyaga na kunywa nawo hamwenga eze auyuke. ");
INSERT INTO ziw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nakuchunga chilonge mbuli yedi za Chohile kwa wantu na kuwagambila chindedi kugamba uyo nuyo asagulwe ni Chohile kuwakantila wajima na wabanike. ");
INSERT INTO ziw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Wawoni wose waukula mbuli zakwe wakagamba, wose wakuzumila nawalekeilwe masa yawo kwa udahi wa Zina dyakwe.” ");
INSERT INTO ziw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Umo Petulo echei akalonga, Muye Ukukile awaseila wose nawaketegeleza ulosi wakwe. ");
INSERT INTO ziw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wayahudi wazumile walaile Yafa hamwenga na Petulo wehelwa kwaviya Chohile ketila ntunyo yakwe ya Muye Ukukile hata kwa sawo Wayahudi nawo. ");
INSERT INTO ziw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kwaviya waweva wakatamwila lugha heikumanyika wakatogola ukulu wa Chohile. Petulo niyo alonga, ");
INSERT INTO ziw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Wantu wano wahokela Muye Ukukile saviya vyatendaga kwetu. Niyuhi akudaha kuwachinda wasekubatizwa kwa mazi?” ");
INSERT INTO ziw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Niyo awaunga wabatizwe kwa Zina dya Yesu Kulisito. Wantu awo wawaunga wekale hamwenga nawo kwa mazuwa majeche. ");
INSERT INTO ziw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Wasigilwa na wazumile watuhu wakudya Yudeya yose weva kugamba sawo Wayahudi nawo waihokela mbuli ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Umo Petulo aitile Yelusalemu, wadya nawakaunga wantu wajelwe ngasu wahingana naye wakamgamba, ");
INSERT INTO ziw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Nawimjeni mwe si ya hawajeligwe ngasu naho kudya nawo.” ");
INSERT INTO ziw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petulo niyo awagambila vyose vilaile kukongela nkongo. ");
INSERT INTO ziw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Umo hamlombeza Chohile mo umzi wa Yafa nasiwona uwoni. Siwona chintu chikusela hasi chikale saviya suche nkulu ikuselezwa mwe ntendele nne kulaila kwembingu, niyo chachimala hajihi namiye. ");
INSERT INTO ziw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Sisungila mndani kwa hajihi nakuwona nyama zikufugwa na nyama za kumbago nawakutambala na wadege wo ulanga. ");
INSERT INTO ziw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Niyo neva izwi dikunigamba, ‘Petulo chimala, chinja udye!’ ");
INSERT INTO ziw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mna sigamba, ‘Sikuvidaha Zumbe, hachihali hechilenguke hegu nkande nchafu ingile mo mlomo wangu.’ ");
INSERT INTO ziw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Izwi idyo dyalonga naho kulaila kwembingu dikagamba, ‘Vintu vilenguswe ni Chohile, usekuitenda ni vizavu.’ ");
INSERT INTO ziw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Imbuli ino ilaila nkanana ntatu, ko uhelo ichintu icho chavuzwa naho kwembingu. ");
INSERT INTO ziw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ichipindi icho, wantu watatu wasigilwe kwangu wakulaila Kaisaliya wengila hekaya nahekala. ");
INSERT INTO ziw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Naho Muye Ukukile kanigambila kugamba nite hamwenga nawo haleka nkama. Wano walukolo mfungate mkuwona wakunisindikiza, choseni niyo chaita chengila mwe nyumba ya Koneliyo. ");
INSERT INTO ziw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kachigambila viya amwone mndima ywa kwembingu achimale mwekaya yakwe nakumgamba asigile mntu aite Yafa akamwitange mntu akwitangwa Simoni Petulo. ");
INSERT INTO ziw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nalonga na weye vikunga vileka weye hamwenga nekaya yako mhonywe. ");
INSERT INTO ziw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nize nikonge kulonga, Muye Ukukile awaseila saviya aselaga kwetu nkongo. ");
INSERT INTO ziw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Niyo nakumbuka Zumbe alongaga mbwani, akagamba, ‘Yohana kabatiza kwa mazi, mna nyuwe nambatize kwa Muye Ukukile.’ ");
INSERT INTO ziw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ni pwilili kugamba Chohile kawenka sawo Wayahudi ntunyo idya achinkaga chize chizumile kwa Zumbe Yesu Kulisito, miye ni yuhi hunga nimchinde Chohile!” ");
INSERT INTO ziw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Weze weve imbuli iyo, waleka uhigani wawo nakumtogola Chohile wakagamba, “Chohile kawenka sawo Wayahudi nawo luhenyo lwa kweila masa yawo watende naujima.” ");
INSERT INTO ziw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Wazumile wamwenga wazagalaga kwa masulumizo wayawonaga umo Sitefano akakomwa wabula hale uko Foinike na Sipulasi na Antiyokiya kulonga mbuli iyo kwa Wayahudi awodu. ");
INSERT INTO ziw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mna wazumile watuhu walailaga Sipulasi na Kilene waita Antiyokiya nakuilonga mbuli yedi kwa swo Wayahudi wakawagambila mbuli yedi ya Zumbe Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nawana nguvu ya Chohile, wantu walozize wazumila na kumhitukila Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mbuli iyo iwabwila wantu wa bunga dya wamzimile Kulisito uko Yelusalemu, niyo wamsigila Banaba aite Antiyokiya. ");
INSERT INTO ziw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Eze abule na kuwona viya Chohile awajimbike wantu, kelelwa nakuwaunga wose wekale mwe ukanuni wawo kwa Zumbe mwe myoyo yawo yose. ");
INSERT INTO ziw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba nanimntu mtana amemile Muye Ukukile na uzumizi na wantu walozize wamhokela Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Niyo Banaba ahalawa kubula Taso kumzungula Sauli. ");
INSERT INTO ziw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Eze amlondole aita naye Antiyokiya, uko kwa mhilimo mjima wantu waidi awo wadugana na wantu wa Nyumba yo kuvikila nakuhinya fyo kulu dya wantu. Nani uko Antiyokiya wanampina walozize wetangwe Wakulisito kwa nkanana ya nkongo. ");
INSERT INTO ziw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mweichipindi icho wawoni wamwenga wabula kulaila Yelusalemu kwita Antiyokiya. ");
INSERT INTO ziw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yumwenga mwawo akwitangwa Agabo kachimala naho kwa udahi wa Muye Ukukile kulotela kugamba nakulaile gumbo ditendese mweisi yose. Naho nailaile mo ulongozi wa Useuta wa Kilaudiyo. ");
INSERT INTO ziw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Wanampina wawona kugamba chila yumwenga egale chiya akudaha kuwambiza wazumile weyawe wakwikala uko Yudeya. ");
INSERT INTO ziw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Wadamanya ivyo, naho wawasigila Banaba na Sauli wegale hela kwa wadalahala we nyumba yo kuvikila. ");
INSERT INTO ziw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mwa mazuwa yadya, Zumbe Helode akonga kuwasulumiza wantu Wazumile. ");
INSERT INTO ziw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kamkoma Yakobo mlukolo ywa Yohana kwa bamba. ");
INSERT INTO ziw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Eze awone mbuli iyo iwelela Wayahudi niyo ajendeleza kumgwila Petulo. Mbuli ino ilaila chipindi cha zuwa kulu dya migate haijeligwe ugwadu. ");
INSERT INTO ziw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Eze agwilwe niyo Petulo ajelwa kundani kuno akasinywa ni mafyo mane ya wankondo wane chila dimwenga. Helode nakaika ubala wa kumchimalisa mwe chitala mwa meso ya wantu Pasaka ikajika. ");
INSERT INTO ziw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ivyo Petulo niyo ajelwa mndani, mna wantu wa Nyumba yo kuvikila nawakamlombezesa Chohile kwa chausa chakwe. ");
INSERT INTO ziw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Chilo chimwenga Helode henati kumwigala kwechitala, Petulo nakagona mgati mwa wankondo waidi. Kanyinywa na minyololo midi, wamizi nawakamila ulwivi lwe dijeleza. ");
INSERT INTO ziw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Aho mndima ywa kwembingu ywa Zumbe achimala, ulangazi niyo walangaza mwakachumba. Mndima ywa kwembingu amsingisa Petulo mweidiyega, amwinula nakumgamba, “Sunguza chimala wite!” Aho, minyolo naimwemikono yakwe yamlagala. ");
INSERT INTO ziw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Niyo mndima ywa kwembingu agamba, “Nyinya umsipi wako niyo wavika ivilatu vyako.” Petulo adamanya ivyo, mndima ywa kwembingu agamba, “Vika isuche yako unitimile.” ");
INSERT INTO ziw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petulo amtimila na kufosa mwe idijeleza, hemanyize kugamba chikudamanywa nuyo mndima ywa kwembingu ni cha chindedi hegu ni uwoni. ");
INSERT INTO ziw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wajinka lindo dya nkongo na dya kaidi, niyo walaila mwe lwivi lwa chuma lukwingila koumzi. Ulwivi lwevugula lwenye niyo wafosa. Wajenda mwesila, aho mndima ywa kwembingu amwasa Petulo. ");
INSERT INTO ziw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petulo abunkula chimlaile agamba, “Haluse sivimanya chilaile nichindedi, Zumbe kasigila mndima ywa kwembingu ywakwe eze anambule kulaila mo udahi wa Helode na chintu wantu wa Uyahudi waungile chilaile.” ");
INSERT INTO ziw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Eze amanye mbuli ziya zilaile, aita kwekaya ya Maliyamu nine dya Yohana Mako, uko wantu walozize wadugana wakamlombeza Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petulo atunta ulwivi kwa kuse, mtumwa akwitangwa Loda aita akumwitika. ");
INSERT INTO ziw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Niyo abunkula kugamba izwi idyo nidya Petulo niyo elelwa vidala vyaleka aguluka auya havugulwe ulwivi na kuwagambila weyawe kugamba Petulo kachimala heise. ");
INSERT INTO ziw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wamgamba, “Wimchilalu!” Mna alahila kugamba ni chindedi. Wamhitula, “Uyo ni mndima ywa kwembingu ywakwe.” ");
INSERT INTO ziw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mwechipindi icho, Petulo nakajendeleza kutunta ulwivi. Niyo wavugula ulwivi, weze wamwone wehelwa. ");
INSERT INTO ziw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Awalagisa kwa mkono wakwe wanyamale, awagambila viya Zumbe amlavize kulaila kwechifungo. Awagamba, “Wagambileni Yakobo na wazumile wasigale,” Niyo ahalawa aita hantu hatuhu. ");
INSERT INTO ziw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kwize kuche, nakuna mkanganyiko mkulu kwa wadimi wedijeleza wehelwa ni chibwani chilaile kwa Petulo? ");
INSERT INTO ziw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helode alagiza Petulo azungulwe, mna hawamlondole. Niyo awaunga awamizi wakomwe. Vize viheze, Helode niyo ahalawa Yudeya akwikala Kaisaliya. ");
INSERT INTO ziw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helode nakehizwa vitendese ni wantu wa Tilo na Sidoni, ivyo wambasa kwa fyo wakamwone. Wakonga kumkola umbuya Bilasito, mkulu ywa aho hantu, awambize. Niyo waita kwa Helode wakamlombeze wevane, kwaviya isi yawo naikahokela nkande kulaila kwe isi ya zumbe Helode. ");
INSERT INTO ziw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mwe zuwa disagulwe Helode nakavika suche zakwe zo uzumbe, kekala mwe chigoda chakwe cho uzumbe, nakusimwila nawantu. ");
INSERT INTO ziw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Waguta, “Suyo mntu akutamwila, mna ni yumwenga mwa milungu.” ");
INSERT INTO ziw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Aho, mndima ywa kwembingu ywa Zumbe amhuta Helode, kwaviya kalemele kumwinka ntogozi Chohile, niyo engilwa ni sango abanika. ");
INSERT INTO ziw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Chipindi icho, ulosi wa Chohile ujendeleza kuzagala nakukula. ");
INSERT INTO ziw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba na Sauli wakomeleza indima yawo nakuogola kulaila Yelusalemu wakatenda hamwenga na Yohana Mako. ");
INSERT INTO ziw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kwedibunga dya wazumile uko Antiyokiya na kuna wawoni na wahinyi. Banaba na Simoni akwitangwa mtitu na Lukiyo mkilene na Sauli na Manaeni akuzigwe hamwenga na Helode. ");
INSERT INTO ziw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Umo wakamsankanila Zumbe na kufunga, Muye Ukukile awagamba, “Nisentelani Banaba na Sauli wadamanye ndima niwetangile.” ");
INSERT INTO ziw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wafunga nakulombeza, nakuwajelekela mikono nakuwasigila waite. ");
INSERT INTO ziw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banaba na Sauli wakatenda wasigilwa ni Muye Ukukile waita Seleukiya, watamba mwebahali kulaila uko kubula chisiwa cha Sipulasi. ");
INSERT INTO ziw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Weze wabule Salami, walonga ulosi wa Chohile mwe nyumba zo kuvikila za Chohile. Nawehamwenga na Yohana Mako kuwambiza indima. ");
INSERT INTO ziw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wajenda mwechisiwa chose kubula Pafo, uko wabwila msai akwitangwa Bali Yesu, Myahudi akwegamba ni muwoni mdanti. ");
INSERT INTO ziw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nani mbuya ywa zumbe ywa chisiwa chikwitangwa Segiyo Paolo, mgosi mta akili zilozize, kawetanga Banaba na Sauli kwaviya nakaunga etegeleze ulosi wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mna nawakahigwa ni yudya msai akwitangwa Elima idyo ni zina dyakwe Chiyunani chani wanase kumhitula zumbe ahitukile uzumizi wa chikulisito. ");
INSERT INTO ziw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Niyo Sauli zina tuhu naketangwa Paolo, nakamema Muye Ukukile, amsinya yudya msai, ");
INSERT INTO ziw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nakumgamba, “Weye mwana Mwavu, mnkondo ywa chila chintu chedi. Kumema chila ubala wa wihi naho chila nkanana wajeza kuhitula ichindedi cha Zumbe kuchitenda ni lulimi. ");
INSERT INTO ziw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mkono wa Zumbe naukukantile vino haluse, nautende tuntu usekuwona ulangazi wa zuwa kwa chipindi.” Aho Elima awona chiza chikatanda mwa meso yakwe, ajeza kuzungula mntu ywa kumlongoza kwa mkono. ");
INSERT INTO ziw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Zumbe eze awone chiya chilaile, niyo azumila, kwaviya kehelwa vidala amahinyo ya Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paolo na weyawe watamba mwe bahali kulaila Pafo nakubula Peliga, mzi wa Pamfiliya, uko Yohana Mako kawasa nakuya Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wajenda kulaila Peliga nakwingila Antiyokiya uko Pisidiya, mwe zuwa dya kuhumula wengila mwe nyumba yo kuvikila nakwikala umo. ");
INSERT INTO ziw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Yeze yasomwe masomo yakulaila mwe Sigilizi ya Musa na mawandiko ya wawoni, wakulu we nyumba yo kuvikila wasigila mntu akawagambe, “Walukolo, uneva mna ulosi wa kuwajela moyo wantu mlonge.” ");
INSERT INTO ziw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paolo achimala akonga kulonga, “Waizulaeli weyangu na sawo Wayahudi wose mwihano mkumvikila Chohile, netegelazani! ");
INSERT INTO ziw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Chohile ywa wantu wa Izulaeli kasagula watati zetu nakuwatenda si nkulu umo wakekala saviya wajeni uko Misili. Chohile kawalavya Misili kwa udahi wakwe mkulu, ");
INSERT INTO ziw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","naho kwa mihilimo milongo mine kawajijimiza wakatenda kwejangwa. ");
INSERT INTO ziw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kabalanga wantu wa si mfungate we isi ya Kanani nakuwatenda wantu wakwe watahe isi iyo. ");
INSERT INTO ziw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yose yano yaguha kubula mihilimo magana mane na milongo mishano. “Vikaheza vino kawenka walamuzi kubula chipindi cha muwoni Samwilu. ");
INSERT INTO ziw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Weze walombeze, Chohile niyo awenka Sauli mwana Kisi akulaila mwe kabila dya Benjamini kutenda mlamuzi kwa mihilimo milongo mine. ");
INSERT INTO ziw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Eze amuse, Chohile amtenda Daudi Zumbe ywawo. Vino nivyo Chohile amlongele, ‘Sibunkula kugamba Daudi mwana ywa Yese nuyo hunga, mntu akunga adamanye yose hunga adamanye.’ ");
INSERT INTO ziw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kulaila mo lukolo lwa Daudi, Chohile saviya alongaga kawegaila Yesu mwambula ywa wantu wa Izulaeli. ");
INSERT INTO ziw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Umo Yesu henati kukonga ndima yakwe, Yohana kawagambila wantu wose wa Izulaeli weile masa wawo naho wabatizwe. ");
INSERT INTO ziw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Umo Yohana akakomeleza ndima yakwe, kauza wantu, ‘Mwanifanyanya miye ni yuhi? Miye suyo yudya mkugoja. Mna tegelezani, Anitimila, naho sikuwaila kuchohola sigi ze vilatu vyakwe mwe viga.’ ");
INSERT INTO ziw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Waizulaeli weyangu, walukolo wa Bulahimu na sawo Wayahudi wose mwihano mkumvikila Chohile, ulosi uno wa uhonyi uchizila suwe! ");
INSERT INTO ziw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kwaviya wantu wakwikala Yelusalemu na vilongozi wawo hawammanyaga kugamba ni mkombola naho hawakombanyaga ulosi wa wawoni ukusomwaga mwe zuwa dya kuhumula. Wachei wautenda ulosi wa wawoni utende chindedi kwa kumkantila Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hamwenga neivyo hawalondole mbuli yakumkantila abanike, wamunga Pilato amkome. ");
INSERT INTO ziw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Weze waheze kudamanya chila chiya chimwamawandiko chikumlonga wamseleza kulaila mo msalaba na kumwika mwembila. ");
INSERT INTO ziw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mna Chohile kamuyusa, ");
INSERT INTO ziw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","kwa mazuwa yalozize kalaila kwa wadya nakatamba nawo kulaila Galilaya kubula Yelusalemu. Vino haluse ni waukuzi wakwe kwa wantu wa Izulaeli. ");
INSERT INTO ziw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Naswi chihano chiwegailani mbuli zedi za Chohile, mbuli idya Chohile alongaga kwa watati zetu kugamba naidamanye, ");
INSERT INTO ziw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","kaidamanya vino haluse, walukolo wawo kwa kumtenda Yesu auyuke saviya iwandikwe mwe zabuli ya kaidi, ‘Wi mwanangu ywa chilume, dyelo sitenda Tati yako.’ ");
INSERT INTO ziw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Vino navyo nivyo Chohile alongaga kulawana no kuyuka kwa Yesu kugamba, hawoile mwembila. ‘Naniwenkeni yakukile nayajimbikwe chindedi, yadya nayalongaga kwa Daudi.’ ");
INSERT INTO ziw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Hatuhu hagamba chindedi, ‘Homleke mndima ywako awoile mwe mbila.’ ");
INSERT INTO ziw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kwaviya Daudi kamsankanila Chohile mwamazuwa yakwe, niyo abanika, kahambwa hamwenga nawatati zakwe, mwili wakwe uwoila mwembila. ");
INSERT INTO ziw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mna yano hayalaile kwa yudya Chohile amuyuse. ");
INSERT INTO ziw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Wambuya zangu Waizulaeli, chaunga mmanye kugamba, kujinkila Yesu, ulosi wa kulekeilwa masa walongwa kwenyu. ");
INSERT INTO ziw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Chila akunga amzumile nalekeilwe masa yakwe, mbuli heijesigwe ni sigilizi ya Musa. ");
INSERT INTO ziw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Msinyise, yalongigwe ni wawoni yasekulaila kwenyu kugamba. ");
INSERT INTO ziw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kaulani, nyuwe mkubela! Mwehelwe na kubanika! Kwaviya chiya hudamanya dyelo ni chintu hamwizumile, hata hegu mntu akawagambilani!’ ” ");
INSERT INTO ziw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Umo Paolo na Banaba wakafosa kulaila kwe nyumba yo kumvikila Chohile, wantu wawagoneka wauye naho mwe zuwa tuhu dya kuhumula dikutimila wawagambile mbuli izo. ");
INSERT INTO ziw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wantu weze wahalawe homdugano, Paolo na Banaba watimilwa ni Wayahudi walozize na sawo Wayahudi walozize wahitulwe kutimila sila ya kumlonda Chohile ya Chiyahudi. Wasigilwa wasimwila nawo nakuwajela moyo wajendeleze kwikala kwa wedi wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Zuwa dya kuhumula ditimile chila yumwenga mo mzi kabula kwetegeleza ulosi wa Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Wayahudi weze wawone fyo dya wantu niyo wamema maya nakuhigana na yose yalongigwe ni Paolo na kumhuluta. ");
INSERT INTO ziw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mna Paolo na Banaba nawakalonga kwa ukankalu mkulu, nanivyedi ulosi wa Chohile ukonge usimwilwe kwenyu. Mna kwaviya muulemela naho hamkuutenda wa wakusinywa kwa kwikala kwenyu mazuwa yose, nachiwaleke nakuwaitila sawo Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ino niyo sigilizi chinkigwe ni Zumbe, “Siwatenda ulangazi kwa wantu sawo Wayahudi, chani wigale wambulwe mwe isi yose.” ");
INSERT INTO ziw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Sawo Wayahudi weze weve imbuli iyo, welelwa na kuutogola ulosi wa Zumbe, wadya nawo wasagulwe kwa wikazi wa mazuwa yose wazumila. ");
INSERT INTO ziw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ulosi wa Zumbe niyo wazagala chila hantu mo mzi. ");
INSERT INTO ziw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mna Wayahudi nawawatibilinkanya vilongozi wa chilume womzi na wavyele sawo Uyahudi wakweika kulanga nawakamvikila Chohile. Wakonga kuwasulumiza Paolo na Banaba nakuwadula kuse nomzi wawo. ");
INSERT INTO ziw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Wasigilwa niyo wapuguta tifili mweviga vyawo kwa chausa cha mahigano ayo ditende kanyo kwawo, nakwita Ikoniya. ");
INSERT INTO ziw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wanampina wa Antiyokiya welelwa vidala naho wamema Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Chintu saicho chilaila uko Ikoniya. Paolo na Banaba waita kwe nyumba yo kuvikila kulonga kwa ukankalu vya watenda wantu walozize Wayahudi na sawo Wayahudi wazumile. ");
INSERT INTO ziw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mna Wayahudi hewezumile wawasongaganya sawo Wayahudi kuwahitula kuhigana na wazumile. ");
INSERT INTO ziw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Wasigilwa wekala uko chipindi chitali, wakasimwila kwa ukankalu mbuli za Zumbe, awaukuile chindedi kugamba ulosi wawo ni wachindedi kwa kuwenka udahi wa kudamanya mpituko na vilagiso. ");
INSERT INTO ziw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Wantu womzi nawepagula mabunga maidi, wamwenga nawentendele ya Wayahudi watuhu nawo kwa wasigilwa. ");
INSERT INTO ziw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Wantu wamwenga sawo Wayahudi na Wayahudi, hamwenga na vilongozi wawo, wawona wawadamanye vihiye wasigilwa na kuwatowa mayuwe. ");
INSERT INTO ziw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Wasigilwa weze wamanye imbuli iyo, niyo wasumkila kwemizi ya Lisitila na Debe uko Likoniya na mwe izisi zihajihi. ");
INSERT INTO ziw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Uko walonga mbuli zedi za Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Uko Lisitila nakuna mntu chiwete ivyo elekagwa, hadahaga kujenda. ");
INSERT INTO ziw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kekala nakwetegeleza ulosi akulonga Paolo. Paolo amwona kazumila naho kahonywa, niyo amsinya, ");
INSERT INTO ziw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","niyo aguta, “Chimala mwenye”. Mntu uyo achimala nakukonga kujendajenda. ");
INSERT INTO ziw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Fyo dya wantu dize diwone chiya adamanye Paolo, wakonga kuguta kwa ulosi milongi ya Kilikoniya, “Milungu itenda saviya wantu na kuchiseila!” ");
INSERT INTO ziw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Wamwinka Banaba zina dya Zeu, na Paolo zina dya Heme, kwaviya nanimsimwila mkulu. ");
INSERT INTO ziw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mlavyantambiko ywa mlungu Zeu, nyumba yakwe ya mlungu nemnkanda mo mzi, kegala njeku ihambigwe na maluwa kwenchili, kwaviya yeye hamwenga nedifyo nawakonga walavye majeleko kwa wasigilwa. ");
INSERT INTO ziw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Banaba na Paolo weze weve chiya nawakaunga wadamanye, watatula izisuche zawo kulagisa kugamba hawevane na viya vyendaga vikatendwa mgati mwe difyo wakaguta, ");
INSERT INTO ziw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nimbwani mkudamanya vino? Suwe naswi chiwantu sevyo nyuwe mwili! Chihano kulonga mbuli za Chohile, kuwatenda mhituke msekudamanya mbuli zino heziligane kwa Chohile mta ujima, aumbile imbingu, ne isi, bahali na vyose vikwikala umo. ");
INSERT INTO ziw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Aho kale kaunga wantu woseni kudamanya mbuli zawo. ");
INSERT INTO ziw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Hata hegu halekile kwelagisa kwa sila ya kudamanya yedi, awegailani fula kulaila kwembingu naho awenkani ulozo kwa chipindi chakwe chedi, awenkani nkande na kuwamemeza mbwedo.” ");
INSERT INTO ziw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hata koulosi uwo, wasigilwa wadunduga kuhiga idifyo wasekulavya majeleko kwawo. ");
INSERT INTO ziw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Wamwe wa Wayahudi walaila Antiyokiya na Ikoniya uko Pisidiya na kulaila Ikoniyo, waluvya idifyo nakumtowa mayuwe Paolo niyo wambuluza kunkanda komzi wakafanyanya kugamba kabanika. ");
INSERT INTO ziw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mna umo wanampina weze wamzunguluke, achimala nakuya komzi. Zuwa ditimile uyo hamwenga na Banaba waita Debe. ");
INSERT INTO ziw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paolo na Banaba walonga mbuli zedi za Chohile uko Debe na kuwatenda wanampina walozize. Niyo wauya Lisitila na Ikoniya na Antiyokiya uko Pisidiya. ");
INSERT INTO ziw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Wawajela nguvu wanampina na kuwajela moyo wekale mo uzumizi. Wahinya, “Chaungwa chisulumile kwingila mo Uzumbe wa Chohile”. ");
INSERT INTO ziw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mwe chila nyumba yo kuvikila wasagula vilongozi wadalahala, nakuwenkiza kwa Zumbe kwa malombezi na kufunga, wawaika mwe wamizi wa wadya wazumile. ");
INSERT INTO ziw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Weze wabinde si yose ya Pisidiya, wabula Pamfiliya. ");
INSERT INTO ziw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Uko walonga ulosi Peliga nakwita Ataliya, ");
INSERT INTO ziw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","kulaila uko waogola na meli wauya Antiyokiya, hantu aho nkongo walombeze wadimwe ni Chohile kwa chausa cha ndima wakudamanya haluse. ");
INSERT INTO ziw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Weze wengile Antiyokiya, wachisanya wantu we nyumba yo kuvikila hamwenga nakuwagambila yose Chohile adamanye nawo naviya avugule sila kwa sawo Wayahudi kuzumila. ");
INSERT INTO ziw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Niyo wekala na wanampina chipindi chitali. ");
INSERT INTO ziw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wantu wamwenga kulaila Yudeya wabula Antiyokiya nakuhinya wazumile, “Hamkudaha kuhonywa kubula mjelwe ngasu saviya sigilizi ya Musa ikunga.” ");
INSERT INTO ziw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paolo na Banaba wahigana nawo vidala, niyo vyaungwa Paolo na Banaba hamwenga na watuhu uko Antiyokiya waite Yelusalemu wakawawone wasigilwa na wadalahala mwe mbuli iyo. ");
INSERT INTO ziw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Niyo wegalwa ni wazumile, umo wakajinka Foinike na Samaliya, wagambila wantu viya sawo Wayahudi wamhitukile Chohile, mbuli ino iwatenda wazumile weleleswe vidala. ");
INSERT INTO ziw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Umo wakengila Yelusalemu wahokelwa ni wantu wazumile, wasigilwa na wadalahale nakuwagambila adamanye Chohile kujinkila mwawo. ");
INSERT INTO ziw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mna wamwe wa wazumile wa bunga dya Mafalisayo wachimala na kugamba, “sawo Wayahudi waungwa wajelwe ngasu na kuhinywa watimile sigilizi za Musa.” ");
INSERT INTO ziw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Wasigilwa na wadalahale wadugana hamwenga kufanyanya imbuli iyo. ");
INSERT INTO ziw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Weze wajike ntamulizi ntali Petulo achimala na kugamba, “Walukolo weyangu, mvimanya kugamba chikale chijinkile Chohile anisagulaga mwenyu kulonga Mbuli yedi ya Chohile kwa sawo Wayahudi chani weve niyo wazumila. ");
INSERT INTO ziw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Chohile amanyize fanyanyi za chila yumwenga kalagisa kuwetikila sawo Wayahudi kwa kuwenka Muye Ukukile saviya achitendile suwe. ");
INSERT INTO ziw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Haungile chesimane nawo, kawausiza masa yawo kwaviya wazumila. ");
INSERT INTO ziw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ivyo haluse, ni mbwani mkunga mumjeze Chohile kwa kuwajelekela wanampina mizigo mwe migongo haikudahika kwinulwa ni wadalahala wetu na suwe wenye? ");
INSERT INTO ziw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Sivyo ivyo! Chizumila naho chihona kwa mbazi za Zumbe Yesu, saviya weli wowo.” ");
INSERT INTO ziw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Fyo jima nadinyamala umo wakawetegeleza Banaba na Paolo wakasimwila mpituko na vilagiso adamanye Chohile kujinkila mwawo mwa sawo Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Weze wabinde kulonga, Yakobo awagamba, “Walukolo weyangu netegelazani! ");
INSERT INTO ziw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni kalavyanya viya Chohile akongile kulagisa kuwaunga sawo Wayahudi kwa kumsagula mntu kulaila mwawo watenda wakwe. ");
INSERT INTO ziw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ulosi uno waligana na ulosi wa wawoni na mawandiko yakukile yakugamba, ");
INSERT INTO ziw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Mbuli izo zikajika nanuye, Zumbe alonga, nanizenge uhya hema dya Daudi. Nanizenge naho hema dyangu dichakuke nakuyatenda mahame yatoge naho. ");
INSERT INTO ziw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ivyo wantu wose wasigale weze kwangu, na wantu wa sizose ntuhu woseni awo siwetanga watende wangu. ");
INSERT INTO ziw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ivyo alonga Zumbe, atendile vino vimanyike chikale chijinkile.’ ");
INSERT INTO ziw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Ni fanyanyi zangu,” Yakobo ajendeleza, “kulonga chisekuwavinya sawo Wayahudi wakumhitukila Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mna, chiwawandikila kuwagambila wasekudya nkande yoyose heilenguke kwaviya ilavigwa kwe matukulu, wagosi wasekugonya wavyele wawenye wavyele nawo wasekugonywa ni wagosi wa wenye, naho wasekudya nyama ihogotolwe, hegu sakame yoyose. ");
INSERT INTO ziw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwaviya Sigilizi za Musa zisomwa kwa chipindi chitali mwe nyumba zo kuvikila za Chohile chila mwe Zuwa dya kuhumula na mbuli zakwe zilongwa chila mzi.” ");
INSERT INTO ziw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Niyo wasigilwa na wadalahala hamwenga na wantu wazumile, wawona wagule wantu kulaila mwedifyo na kuwasigila waite Antiyokiya hamwenga na Paolo na Banaba. Wasagula wantu waidi nawaketegelezeswa ni wazumile, Yuda akwitangwa Basaba na Sila, ");
INSERT INTO ziw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","niyo wegala mawandiko yano, “Suwe, wasigilwa na wadalahala, walukolo wenyu wasigila ndamsa kwa walukolo wose welekwe sawo Wayahudi wakwikala Antiyokiya, Siliya na Silisiya. ");
INSERT INTO ziw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Chiva kugamba wamwenga walaile mwe idifyo dyetu wawavinya kwa ulosi wawo, mna hachiwasigile. ");
INSERT INTO ziw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kwaivyo chidugana hamwenga nakwivana chisagule wantu wakuwasigila kwenyu. Nawaite hamwenga na walukolo wetu Banaba na Paolo, ");
INSERT INTO ziw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","welavize ujima wawo kumsankanila Zumbe dyetu Yesu Kulisito. ");
INSERT INTO ziw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Chawasigila kwenyu Yuda na Sila, wakunga wawagambileni wowo wenye milosi iyo kwa milomo yawo idya chikuwawandikilani. ");
INSERT INTO ziw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Muye Ukukile na suwe chizumila chisekuwenkani mzigo mtuhu wowose kujinka vino vikungwa, ");
INSERT INTO ziw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","msekudya nkande ilavigwe kwe matukulu, msekudya sakame, msekudya nyama ihogotolwe, naho wagosi msekugonya wavyele wa wenye wavyele nawo msekugonywa ni wagosi wa wenye. Namdamanye vitana hegu mnenega ivintu ivyo. Mpeho yedi.” ");
INSERT INTO ziw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wenkigwe izisigilizi wahalawa na kwita Antiyokiya, uko waduganya nedifyo dya wazumile nakuwenka idya ibaluwa. ");
INSERT INTO ziw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wantu weze waisome weleleswa ni mbuli ikuwajela moyo. ");
INSERT INTO ziw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila wendaga wawoni wasimwila nawo chipindi chitali kuwajela moyo na nguvu. ");
INSERT INTO ziw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Weze wekale kwa chipindi chisiku, wawalaga na kuwalombezeza utondowazi ikaheza wauya kwa wadya wawasigile. ");
INSERT INTO ziw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Mna Sila kawona ekale hadya. ");
INSERT INTO ziw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paolo na Banaba wahumula hadodo uko Antiyokiya, hamwenga na watuhu walozize wahinya nakulonga mbuli ya Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Hadodo Paolo amgamba Banaba, “Chuye chiwatalamkile walukolo wetu mwe chila mzi chawagambila mbuli ya Zumbe, naho chikaule wajenda vivihi.” ");
INSERT INTO ziw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba nakaunga waitanye na Yohana Mako, ");
INSERT INTO ziw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","mna Paolo hafanyanye kugamba nanivyedi wamguhe kwaviya hekalaga nawo kubula udumo we ndima yawo, mna ahitukaga na kuwasa uko Pamfiliya. ");
INSERT INTO ziw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nahalaila mahigano makulu, Banaba amguha Mako niyo aita naye Sipulasi, ");
INSERT INTO ziw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paolo kamsagula Sila nakuhalawa, akalombezezwa ni wazumile ahokele mbazi za Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kajinka Siliya na Silisiya, akatogeza nyumba za kuvikila. ");
INSERT INTO ziw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paolo katamba kubula Debe na Lisitila, uko mwanampina yumwenga endaga akekala uko akwitangwa Timoseo. Mamiyakwe nani Myahudi mkanuni mna tatiyakwe nani Myunani. ");
INSERT INTO ziw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Wazumile woseni uko Lisitila na Ikoniya waukula vyedi vya Timoseo. ");
INSERT INTO ziw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paolo nakonga amguhe waitanye mwe ntambo, niyo amjela ngasu kwaviya Wayahudi nawakela hantu aho, nawamanya tatiyakwe ni Myunani. ");
INSERT INTO ziw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Umo wakatamba kujinka mwemizi, wawagambila wazumile sigilizi zisigilwe ni wasigilwa na wadalahala uko Yelusalemu nakuwagamba watoze isigilizi. ");
INSERT INTO ziw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ivyo wazumile niyo wajelwa moyo mo uzumizi nakujenyela chila zuwa. ");
INSERT INTO ziw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Watamba kujinka si ya Filigiya na Galatiya kwaviya Muye Ukukile hawaungile walonge mbuli mwe isi ya Asiya. ");
INSERT INTO ziw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Weze wabule mo mhaka wa Misiya, wajeza kwita kwe si ya Besaniya mna Muye Ukukile wa Yesu hawaungile waite. ");
INSERT INTO ziw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Niyo wajinka Misiya kubula Tilowa. ");
INSERT INTO ziw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Chilo icho Paolo nana uwoni nomsi nakumwona mntu ywa Makedoniya kachimala akamlombeza, “So Makedoniya uchambize!” ");
INSERT INTO ziw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Aho Paolo eze awone uwoni uwo, nachemalanya vyedi chite Makedoniya, kwaviya nachiwona kugamba Chohile kachitanga chikalonge mbuli zedi za Chohile kwa wantu wa kudya. ");
INSERT INTO ziw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Chihalawa Tilowa kwa meli kubula Samtilaki na zuwa ditimile chengile Nekapoli. ");
INSERT INTO ziw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kulaila uko chitamba kubula Filipi, mzi wa wilaya ya nkongo ya Makedoniya, naho ni koloni dya Lumi. Chikala mazuwa yalozize kudya. ");
INSERT INTO ziw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mwe zuwa dya kuhumula chifosa mo umzi kubula hankanda ho mto, hantu nachikafanyanya Wayahudi waduganaga kulombeza. Chikala hasi na kulonga na wavyele wadugane hadya. ");
INSERT INTO ziw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Yumwenga mwe wadya wachivile endaga Lidiya kulaila Tiyatila, mtaga suche za langi ya zambalau. Nani mvyele akumvikila Chohile, Zumbe naye kamgubuila umanyi wakwe kusinya viya Paolo nakalonga. ");
INSERT INTO ziw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Yeye hamwenga na wantu wa kaya weze wabatizwe, kachigoneka, “Soni mwikale mkaya mwangu hegu mviwona kugamba miye ni mkanuni kwa Zumbe.” Kachitintisa chite. ");
INSERT INTO ziw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Zuwa dimwenga umo chikaita hantu hokulombezeza, chihokelwa ni mndima mdodo ywa chivyele mta mpepo yamtendaga adahe kuwona yakwiza. Nakawapatila hela zilozize wagoli wakwe kwa kuwawonela yakwiza kuwalagula wantu. ");
INSERT INTO ziw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Kamtimila Paolo na suwe akaguta, “Wantu wano niwandima wa Chohile akulise! Wakugambila viya mkudaha kuhonywa!” ");
INSERT INTO ziw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kadamanya ivyo kwa mazuwa yalozize, vimlekile Paolo aihiwe niyo aihutukila impepo kuigamba, “Kwa zina dya Yesu Kulisito nakunga umlawe!” Aho mpepo iyo niyo yamlawa. ");
INSERT INTO ziw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Wagoli wakwe weze wabunkule kugamba isila yawo yo kwingiza hela ita, wawagwila Paolo na Sila na kuwegala kwevilongozi mo lumpe. ");
INSERT INTO ziw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wawegala kwa wakulu wa Chilumi na kugamba, “Wantu wano ni Wayahudi, naho wachigaila nkondo mo mzi. ");
INSERT INTO ziw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wahinya mazwela yakuhigana na sigilizi zetu, chiwakaya wa Lumi, naho hachikudaha kuzihokela na kuzitimila.” ");
INSERT INTO ziw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Idifyo nadyo dyengila mo kuwahuta Paolo na Sila. Niyo wakulu wawaunga Paolo na Sila wahambulwe izisuche nakuhutwa. ");
INSERT INTO ziw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Weze wahutishwe, wadulwa kwedijeleza, msinyi ywe idijeleza naye aungwa avugalise ulwivi. ");
INSERT INTO ziw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Eze ahokele isigilizi iyo, mchimaila uyo awadula kundani hale nakuwanyinya iviga vyawo mwe magoda yazamile. ");
INSERT INTO ziw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Chilogati Paolo na Sila nawakalombeza nakumchemela Chohile, wavugailwe watuhu nawakawategeleza. ");
INSERT INTO ziw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ahadya kwalaila chisingisa chikulu chisingise umsingi we idijeleza. Aho nyivi zose zakomoka, minyololo nayo iwalawa wavugailwa woseni. ");
INSERT INTO ziw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Msinyi wedijeleza enuka, eze akaule nyivi zedijeleza zikomoka, niyo afanyanya kugamba wavugailwa wasumka, niyo aguha bamba dyakwe chani ekome. ");
INSERT INTO ziw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Mna Paolo kagutisa, “Usekwekoma! Woseni chihano!” ");
INSERT INTO ziw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Msinyi asigila taa zigalwe, engila kundani, agwa kuno akazingiza mwe viga vya Paolo na Sila. ");
INSERT INTO ziw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Niyo awalongoza kuse na kuwauza, “Mazumbe, nidamanye chibwani nihonywe?” ");
INSERT INTO ziw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wahitula, “Mzumile Zumbe Yesu, nawe nauhonywe, weye hamwenga nekaya yako.” ");
INSERT INTO ziw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Niyo walonga mbuli yedi ya Zumbe na kwa watuhu wemwekaya yakwe. ");
INSERT INTO ziw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mwechilo chiya msinyi kawaguha nakuwasunta nkwenje zawo, yeye hamwenga ne nyumba yakwe yose niyo wabatizwa. ");
INSERT INTO ziw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Niyo awegala Paolo na Sila kwekaya yakwe na kuwenka nkande wadye. Uyo hamwenga nekaya yakwe yose weleleswa kwa viya wamzumila Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mtondo wakwe wakulu wa Lumi wasigila wankondo, wakagamba “Walekeni wantu awo waite.” ");
INSERT INTO ziw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ivyo msinyi amgamba Paolo, “Wakulu wasigila weye na Sila mlekelwe. Mwadaha kuhalawa, naho mjende mpeho.” ");
INSERT INTO ziw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mna Paolo awagamba wadya wankondo, “Hachawonekaga wabanasi, mna chihutwa mwa meso ya wantu, naho chiwakaya wa Lumi! Niyo wachijela mwedijeleza. Vino haluse wachunga chihalawe chinyele. Sivyo ivyo! Wakulu wa Lumi wenye weze hano wachilekele.” ");
INSERT INTO ziw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Wakulu wa wankondo wegala imbuli iyo kwa wakulu wa Lumi, weze weve kugamba Paolo na Sila ni wakaya wa Lumi, wogohesa. ");
INSERT INTO ziw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ivyo waita wakawafikile madi, niyo wawalongoza kulaila kuse kwedijeleza na kuwalombeza wahalawe homzi. ");
INSERT INTO ziw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paolo na Sila wahalawa hedijeleza na kwita kwe kaya ya Lidiya. Uko wadugana na wazumile, wasimwila nawo mbuli za kuwajela moyo na kuhalawa. ");
INSERT INTO ziw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paolo na Sila watamba kujinka Amfipoli na Apoloniya na kubula Sesalonike, uko nakuna nyumba yo kuvikila. ");
INSERT INTO ziw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kulawana na viya azwele Paolo kaita kwe nyumba yo kuvikila. Uko mwe mazuwa matatu ya kuhumula katamwila na wantu kwa milosi ya mawandiko, ");
INSERT INTO ziw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","kulonga mawandiko nakuwagambila kugamba Kulisito Mkombola aungwa asulumizwe nakuuyuka. “Yuno Yesu huwagambileni,” Paolo agamba, “nuyo Kulisito Mkombola.” ");
INSERT INTO ziw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wamwenga wahokela na kutenda hamwenga na Paolo na Sila, nivyo navyo watendile wavyele vilongozi na fyo kulu dya Wayahudi wakuvika kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mna Wayahudi wamwenga wengila finju, wachisanya wantu wehiye mwamagwilo, wadamanya bunga nakukonga nkumbizi mo mzi. Waguluka kwe kaya ya mntu yumwenga akwitangwa Yasoni mokuwazungula Paolo na Sila wawegale kwedibunga. ");
INSERT INTO ziw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mna weze wadunduge kuwalondola, wambuluza Yasoni na wazumile wamwenga nakuwegeila wakulu wa mzi kuno wakaguta, “Wantu wano wegala nkondo chilahantu! Haluse wengila homzi wetu, ");
INSERT INTO ziw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","naye Yasoni nakawaika mwe kaya yakwe. Woseni wahigana naizisigilizi za mkulu ywa Lumi, wakagamba kuna zumbe mtuhu, zina dyakwe nuyo Yesu.” ");
INSERT INTO ziw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kwa ulosi uno wajela nkama idifyo na wakulu womzi. ");
INSERT INTO ziw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Wakulu wawaunga Yasoni na watuhu walihe hela zikungwa walekelwe waite. ");
INSERT INTO ziw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Chilo chize chingile, wazumile wawegala Paolo na Sila Beloya. Weze wengile niyo waita kwe nyumba yo kuvikila. ");
INSERT INTO ziw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Wantu kudya nawakeva kujinka wa Sesalonike. Wetegeleza ulosi kwa kuungisa, naho chila zuwa nawakasoma mawandiko kukaula hegu viya Paolo nakalonga nichindedi. ");
INSERT INTO ziw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Wazumile walozize, na wavyele wakulu walozize wa Chiyunani na wagosi walozize wa Chiyunani wazumila. ");
INSERT INTO ziw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mna umo Wayahudi uko Sesalonike weze weve kugamba Paolo nakalonga mbuli ya Chohile uko Beloya, wengila kudya nakukonga kutisa na kutibilinkanya idibunga. ");
INSERT INTO ziw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Aho wazumile wamwigala Paolo mpwani, mna Sila na Timoseo wekala Beloya. ");
INSERT INTO ziw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Wantu wamwigalaga Paolo wabula Aseni niyo wawogola kuya Beloya wakatenda nasigilizi kulaila kwa Paolo kugamba Sila na Timoseo wasunguze kumtimila. ");
INSERT INTO ziw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Umo Paolo akawagoja Sila na Timoseo uko Aseni, vimwihiya vidala eze awone umzi umema matukulu. ");
INSERT INTO ziw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ivyo niyo alafya na Wayahudi mwe zinyumba zo kuvikila na sawo Wayahudi wakuvika kwa Chohile, namwo lumpe chila zuwa mwa wantu woseni wakujinka mjihi. ");
INSERT INTO ziw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Wamwenga mwa Waepikulo na Wasitoiko wahinyi wahigana naye. Wamwenga wauza, “Yuno mhezi aunga achigeze?” Watuhu wahitula, “Awoneka akalonga mbuli za milungu mijeni.” Walonga ivyo kwaviya Paolo nakalonga mbuli za Yesu na uyuso. ");
INSERT INTO ziw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ivyo niyo wamguha Paolo, wamwigala kwechitala cho umzi chikwitangwa Aleopago, akagamba, “Chaunga chimanye mahinyo yano mahya ukulonga. ");
INSERT INTO ziw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Vimwenga chikukwiva ukulonga nivijeni kwetu, chaunga chimanye yagaze.” ");
INSERT INTO ziw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kwa wekazi woseni wa Aseni nawajeni nawakekala hadya waguha chipindi chawo choseni wakalonga nakwetegeleza chintu chihya. ");
INSERT INTO ziw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paolo achimala mwe chitala chomzi nakulonga, “Nawawona kwa chila sila nyuwe wantu wa uko Aseni mwatoza dini. ");
INSERT INTO ziw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kwaviya umo hajinka mo mzi wenyu siwona nchanja yo mkuvikila, siwona vikilo diwandikwe, ‘Kwa mlungu hekumanyika’. Mwamvikila, mna hamummanyize, uyo nuyo huwagambilani. ");
INSERT INTO ziw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Chohile, aumbile isi navyoseni vimndani mwakwe, nuyo Zumbe ywa kwembingu neisi naye hakwikala mwe nyumba za mlungu zidamanywe ni mikono ya wantu. ");
INSERT INTO ziw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Naho hakunga chochose chikudaha kumwinka kwa kumdamanyiza, kwaviya uyo mwenye nuyo akulavya wikazi na nkande na chila chintu kwa chila yumwenga. ");
INSERT INTO ziw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kulaila kwa mntu yumwenga kaumba wantu wa si zose mwe isi nakuwatenda wekale mwe isi yoseni. Uyo mwenye kawaikiya chipindi na hantu wakunga wekale. ");
INSERT INTO ziw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kadamanya ivyo chani wamtiile, vikadahika wamlonde kwa kupampasa. Mna Chohile he hale na hata yumwenga mwetu, ");
INSERT INTO ziw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","saviya yumwenga alongaga, ‘Mndani mwakwe chekala nakujenda nakuhumula.’ Ni saviya mashaili yenyu yamwenga yakugamba, ‘Suwe naswi chiwanawe.’ ");
INSERT INTO ziw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kwaviya chiwana wa Chohile, chisekufanyanya kugamba kekala saviya umbo dya zahabu hegu dya hela hegu dya yuwe, vidamanywe kwa umanyi wa mntu. ");
INSERT INTO ziw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Chohile umo chikale nakatenda saviya hakuwona uhezi naukadamanywa kwaviya wantu na hawammanyize, mna vino haluse awaunga chila yumwenga chila hantu weile masa yawo. ");
INSERT INTO ziw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kaika zuwa dyakukantila isi njima kwa wedi kujinkila mntu asagule. Kailavyanya imbuli ino kwa chila yumwenga kwa kumuuyusa umntu uyo!” ");
INSERT INTO ziw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Umo wakamwiva Paolo akalonga mbuli za kuuyuka, wamwenga wamseka kwa kumbela, mna watuhu wagamba, “Chakunga usimwile imbuli ino naho.” ");
INSERT INTO ziw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Paolo naye ahalawa homdugano. ");
INSERT INTO ziw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wantu wamwenga wamwitikila nakuzumila, mgati mwawo nani Diyonisiyo, mntu ywa chitala, naho nakuna mvyele akwitangwa Damali, na wantu watuhu. ");
INSERT INTO ziw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Eze ajike aho, Paolo ahalawa Aseni kwita Kolinto. ");
INSERT INTO ziw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Uko kadugana na Myahudi akwitangwa Akila, elekwe Ponto, alaile Italiya mazuwa majeche yajinkile hamwenga na mkaziwe Pilisiliya, kwaviya Kilaudiyo kawaunga Wayahudi wakulawe Lumi. Paolo kaita akawakaule, ");
INSERT INTO ziw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","nakuhumula kudamanya ndima nawo, kwaviya nakekala kwa kudamanya mahema, saviya nawakadamanya. ");
INSERT INTO ziw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Alafyaga nawo mwe nyumba zo kuvikila chila mwe mazuwa dya kuhumula, kujeza kuwakwesa Wayahudi na Wayunani. ");
INSERT INTO ziw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timoseo weze wengile kulaila Makedoniya, Paolo kaguha chipindi chakwe choseni kulonga imbuli idya, kuwagambila Wayahudi kugamba Yesu nuyo Kulisito Mkombola. ");
INSERT INTO ziw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Weze wamhige na kumhuluta, kakupuguta iditifili mwe suche yakwe saviya kanyo nakuwagamba, “Uneva mkaga, ni lwenyu wenye! Miye simuli. Kukongela vino haluse naita kwa sawo Wayahudi.” ");
INSERT INTO ziw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ivyo niyo ahalawa kwita kwikala mwe kaya ya Hemkaya ywa Uyahudi akwitangwa Tito Yusito, nakamvikila Chohile, kaya yakwe na ihakana na nyumba yo kuvikila. ");
INSERT INTO ziw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo, chilongozi ywa nyumba yo kuvikila, kamzumila Zumbe, hamwenga nekaya yakwe yoseni, wantu walozize watuhu wa Kolinto weva imbuli iyo, wazumila niyo wabatizwa. ");
INSERT INTO ziw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Chilo chimwenga Paolo kezilwa ni uwoni wa Zumbe kumgamba, “Usekogoha, mna longa, naho usekuleka, ");
INSERT INTO ziw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kwaviya nihamwenga naweye. Hahali akudaha kukulumiza, kwaviya walozize we mwomzi uno ni wantu wangu.” ");
INSERT INTO ziw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ivyo Paolo ekala uko kwa mhilimo umwenga na nusu akahinya wantu mbuli za Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Umo Galiyo eze atendwe mkulu ywa Chilumi ywa Akaya, Wayahudi wa kudya wadugana hamwenga, wamgwila Paolo nakumwigala kwe chitala. ");
INSERT INTO ziw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Wagamba “Mntu yuno ajeza kuwakwesa wantu wamvikile Chohile mwe sila ikuhigana na sigilizi!” ");
INSERT INTO ziw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paolo nakaunga alonge umo Galiyo akalonga kwa Wayahudi, “Uneva ino nani mbuli ihiye hegu ubanasi udamanywe, navitende vyedi kwa miye kuwaguhila nyuwe Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mna kwaviya ni mahigano ya ulosi na mazina na sigilizi zenyu wenye, nyuwe wenye mwaungwa msinyise. Sanitende mkanta wa vintu saivyo!” ");
INSERT INTO ziw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Niyo awausa mwechitala. ");
INSERT INTO ziw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Woseni niyo wamgwila Sosiseni, chilongozi ywa nyumba yo kuvikila, niyo wamtowa mwechitala. Mna Galiyo hawone ni mbuli. ");
INSERT INTO ziw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paolo kekala hamwenga nawazumile uko Kolinto kwa mazuwa alozize, niyo awasa nakwita kwa meli Pilisiliya na Akila kwita Siliya. Umo hewenati kulawa Kenikileya kamoga umtwi wakwe kwaviya nakaika nazili. ");
INSERT INTO ziw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Wengila Efeso, uko Paolo kakulawa Pilisila na Akila. Kaita kwe nyumba yo kuvikila kulafya na Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wantu wamlombeza ekalekale, mna havyungile. ");
INSERT INTO ziw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mna kawagambila umo akahalawa, “Uneva Chohile akaunga nanuye kwenyu.” Ivyo niyo ahalawa Efeso. ");
INSERT INTO ziw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Eze engile Kaisaliya, aita Yelusalemu nakulamsa wantu wa nyumba yo kuvikila, niyo aita Antiyokiya. ");
INSERT INTO ziw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Eze ekalekale uko, ahalawa nakujinka mzi wa Galatiya na Filigiya, akawajela moyo wanampina wose. ");
INSERT INTO ziw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mwechipindi icho Myahudi akwitangwa Apolo, elekagwa Isikandaliya, abulaga Efeso. Nani mntu asomile naho amanyize mawandiko. ");
INSERT INTO ziw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nakahinywa sila ya Zumbe, kwa kungisa kwakwe kahinya kulonga vyedi ichindedi cha Yesu. Mna nakamanya mbuli za ubatizo wa Yohana uwodu. ");
INSERT INTO ziw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Kakonga kulonga kwa ukankalu mwe nyumba zo kuvikila. Pilisiliya na Akila weze wamwive, waita naye kukaya nakumhinya vyedi sila ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo niyo awona aite Akaya, ivyo wanampina wa Efeso wamwambiza kwa kuwagambila wanampina uko Akaya, kuwaunga wamhokele. Eze engile katenda mwambizi mkulu kwa wadya wazumile kwa wedi wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kwaviya kwa mahigano makulu kawahuma Wayahudi mwe lafyo holumpe lwa wantu kwa kuwalavyanyiza mwa mawandiko kugamba Yesu nuyo Kulisito Mkombola. ");
INSERT INTO ziw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Umo Apolo ne Kolinto, Paolo katamba kujinka mndani mwe si kwingila Efeso. Uko kabwila wanampina wamwenga ");
INSERT INTO ziw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","wawauza, “Namhokela Muye Ukukile umo mwazumilaga?” Wahitula, “Hachinati hata kwiva kuna Muye Ukukile.” ");
INSERT INTO ziw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paolo auza, “Nivyedi, mhokela ubatizo wi vivihi?” Wahitula, “Ubatizo wa Yohana.” ");
INSERT INTO ziw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paolo agamba, “Ubatizo wa Yohana nawiyaho kwa wadya weile masa yawo, naho kawagambila wantu wa Izulaeli kumzumila yudya akunga amtimile, nuko kugamba, Yesu.” ");
INSERT INTO ziw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Weze weve ivyo, wabatizwa kwa zina dya Zumbe Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paolo kawajelekela mikono yakwe, Muye Ukukile awenjila, wasimwila kwa milosi mijeni na kulongela mbuli ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nawakabula wagosi mlongo na waidi. ");
INSERT INTO ziw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paolo enjila mwe nyumba zo kuvikila na mwe myezi mitatu kalonga na wantu kwa ukankalu, akalafya hamwenga nawo kuno akajeza kuwalagisa ichindedi mo Uzumbe wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mna wamwenga wawo wawona ni uhezi naho hawazumile, na mwe idifyo dyoseni walonga vihiye mwe sila ya Zumbe. Ivyo Paolo awasa nakuwaguha wadya wanampina, naho chila zuwa nakalafya nawo mwe chumba chikulu cha mntu akwitangwa Tilanosi. ");
INSERT INTO ziw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Vino vijendeleza kwa mihilimo midi, vitendile wantu woseni nawakekala mo umzi wa Asiya, woseni Wayahudi na sawo Wayahudi, waiva mbuli ya Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Chohile nakadamanya mpituko hezizweleke kujinkila mwa Paolo. ");
INSERT INTO ziw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Hata vitambala vya mwe mikono na suche nakavika nazikenkigwa wanyonje, manyonje yawalawa, mpepo nchafu nazo ziwalawa. ");
INSERT INTO ziw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wayahudi wamwenga nawakatamba nakugulusa mpepo nawo wajeza kwa zina dya Zumbe Yesu kudamanya vino. Walonga mwe mpepo nchafu, “Nakunga kwa zina dya Yesu, dilongwe ni Paolo.” ");
INSERT INTO ziw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Wana mfungate wa Sikewa, Mlavyantambiko mkulu ywa Chiyahudi wendaga mgati mwa awo wendile wakadamanya ivyo. ");
INSERT INTO ziw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mna mpepo nchafu yawagamba, “Simmanya Yesu, naho simmanya Paolo, mna nyuwe, mwiwahi?” ");
INSERT INTO ziw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Uyo mntu mta mpepo nchafu kawapilikila niyo awahuma nguvu. Wasumka kulaila kweikaya yakwe, walumile na suche zawo zitatulwe, wemwazi. ");
INSERT INTO ziw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Wayahudi na Wagiliki woseni na sawo Wayahudi nawakekala Efeso weva imbuli iyo, wengilwa ni woga, zina dya Zumbe Yesu niyo dyatunyiswa. ");
INSERT INTO ziw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Wazumile walozize weza, wakazumila mo lumpe lwa wantu walekeilwe masa wadamanyaga. ");
INSERT INTO ziw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Waozize na wakaloga wegala vitabu vyawo vikokwe moto mwa meso. Samani yakwe ibula matundu yakulihwa mntu zuwa dimwenga, magana mlongo milongo mishano. ");
INSERT INTO ziw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mweisila ino ulosi wa Chohile uzagala na kutenda na nguvu. ");
INSERT INTO ziw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Yano yeze yaheze kulaila, Paolo awona aite Yelusalemu kugwila Makedoniya na Akaya. Agamba, “Hajika kwita uko, nitalamkile Lumi nako.” ");
INSERT INTO ziw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kasigila wambizi wakwe waidi, Timoseo na Elasito waite Makedoniya, yeye kahumula mazuwa majeche mo mkowa wa Asiya. ");
INSERT INTO ziw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nani mwe ichipindi chino nakulaila nkunto nkulu uko Efeso kwa chausa cha sila ya Zumbe. ");
INSERT INTO ziw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Msana heza yumwenga akwitangwa Demetiliyo kadamanya miliganyo ya wazumba wa heza wa kuvikila mlungu Atemi, ndima yakwe iyo naikawenka wandima wakwe vilozize. ");
INSERT INTO ziw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ivyo awetanga woseni hamwenga na watuhu nawakadamanya ndima saiyo nakuwagamba, “Wagosi, Mvimanya kugamba ugoli wetu walaila mwendima ino. ");
INSERT INTO ziw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Haluse, mwaviwona nakwiva nyuwe wenye vino yuno Paolo akudamanya. Agamba milungu ikudamanywa kwa mikono ya wantu siyo milungu, naho kadaha kukwesa walozize, woseni wa hano Efeso namjihi mo mkowa mjima wa Asiya. ");
INSERT INTO ziw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kuna nkondo ino, kugamba, ndima yetu ino naibelwe. Sivyo ivyo du, naho kuna nkondo kugamba nyumba ya mlungu Atemi naitende siyo chintu naho ukulu wakwe naubalangwe. Ulungu kuvikilwa ni chila yumwenga mwe Asiya na isi njima!” ");
INSERT INTO ziw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Idifyo dize dive ulosi uwo, wehiwa nakukonga kuguta, “Atemi ywa Efeso ni mkulu!” ");
INSERT INTO ziw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mzi mjima umema ngavungavu. Bunga dimgwila Gayo na Alisitaliko, Wamakedoniya waidi nawakatamba na Paolo, niyo wakuguluka nawo he nyumba ya misezigo. ");
INSERT INTO ziw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paolo nakaunga engile mwe difyo, mna wanampina wamlemeza. ");
INSERT INTO ziw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wakulu wamwenga wa Asiya, wambuyaze, nawo nawasigila wakamlombezesa asekwelagisa kwe nyumba yemisezigo. ");
INSERT INTO ziw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Chipindi icho fyo jima nadimwe ngavungavu, wantu wamwenga nawakagutila chintu chimwenga, watuhu nawakagutila chituhu, kwaviya walozize nahawavimanyize chiwaduganye. ");
INSERT INTO ziw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wantu watuhu waviwona kugamba Isikanda naana chakusimwila, kwaviya Wayahudi wamwika moso. Niyo Alekizanda ahungila wantu mikono wanyamale, niyo ajeza kwehonya. ");
INSERT INTO ziw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mna weze wabunkule kugamba ni Myahudi, woseni wagutila hamwenga mwe chimwe kwa masa maidi, “Atemi ywa Efeso ni mkulu!” ");
INSERT INTO ziw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kubindilikila, kalani wo umzi anyamaza idifyo. Agamba, “Waefeso weyangu, chila yumwenga kavimanya kugamba mzi wa Efeso ni mwika nyumba ya mlungu Atemi na ya yuwe dikuvikilwa digwele kulaila kwembingu. ");
INSERT INTO ziw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hahali akudaha kulemela yano. Kwaivyo, mnyamale dyii naho msekudamanya chochose kwa nguvu. ");
INSERT INTO ziw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Muwaleta wano wantu hano hewebaile chintu kulaila mwe nyumba ya mlungu hegu kumhuluta mlungu ywetu. ");
INSERT INTO ziw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Uneva Demetiliyo na wandima wakwe wana dyodyose mwa mntu yoyose, china udahi na mazuwa ya chitala, masa yadaha kulahwa uko. ");
INSERT INTO ziw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mna hegu mna chochose chikujinka viya mkunga, chilamulwe mwe midugano dya wekazi. ");
INSERT INTO ziw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwaviya chino chize chilaile dyelo, kuna nkondo nakulaile ngavungavu. Havikanike kwetu kwe ingavungavu iyo, naho hachidahe kwegombela vyedi.” ");
INSERT INTO ziw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Eze alonge ivyo, avugala umdugano. ");
INSERT INTO ziw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ingavungavu idya ya Efeso ize inyamale, Paolo kawetanga hamwenga wanampina na kuwafunda kwa kuwenka moyo. Niyo ahalawa aita Makedoniya. ");
INSERT INTO ziw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ajinka imizi idya nakuwenka moyo wantu kwa losi ulozize. Niyo abula Ugiliki, ");
INSERT INTO ziw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","kekala uko kwa myezi mitatu. Nakemalanya vyedi kwita Siliya eze abunkule nakuna Wayahudi wakumtegela, awona auye kugwila Makedoniya. ");
INSERT INTO ziw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopatilo mwana Pilo kulaila Beloya, kaita naye, ivyo naho Alisitaliko na Sekundo, kulaila Sesalonike, Gayo kulaila Debe, Tikiko na Tilofimo, kulaila mkowa wa Asiya na Timoseo. ");
INSERT INTO ziw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Walongolaga nakuchigoja Tilowa. ");
INSERT INTO ziw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Chitamba mwe meli kulaila Filipi ize iheze ingasu ye migate heijeligwe hamila, mazuwa mashano yatimile chihangana nawo uko Tilowa, uko chikala mazuwa mfungate. ");
INSERT INTO ziw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mwe zuwa dya nkongo dya mazuwa mfungate chisingi chidugana kudya ndala. Paolo asimwila na wantu, kwaviya nakaunga ahalawe zuwa dikutimila, kajendeleza kusimwila kubula chilo gati. ");
INSERT INTO ziw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Taa zilozize nazikalangaza kulanga mwe chumba kwe golofa chadugane. ");
INSERT INTO ziw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mbwanga yumwenga akwitangwa Eutiko nakekala hedidilisha, Paolo nakajendeleza kusimwila, Eutiko nakasinka vidala, vimlekile akatowa mgono niyo alagala kulaila kwegolofa ya katatu kubula hasi. Weze wamwinule kabanika kale. ");
INSERT INTO ziw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Mna Paolo kasela niyo edula mlanga mwakwe akamkumbatila. Agamba, “Msekogoha, achei mjima!” ");
INSERT INTO ziw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Niyo auya kulanga, abesula mgate, nakudya. Eze asimwile nawo kwa chipindi chitali, kubula chisingi, Paolo niyo ahalawa. ");
INSERT INTO ziw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wamwigala yudya mbwanga kukaya emjima kuno welelwa. ");
INSERT INTO ziw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Suwe nachilongola na meli kwita Aso, uko nachimguha Paolo. Kachigamba kudamanya ivyo, kwaviya nakaita uko kwa kujinkila si inyaile. ");
INSERT INTO ziw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Umo achibwile Aso, chimkweza mwe meli kwita Mitilene. ");
INSERT INTO ziw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Chilawa kudya kwingila Chiyo zuwa ditimile. Zuwa dimwenga ditimile chingila Samo, zuwa ditimile chingila Mileto. ");
INSERT INTO ziw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paolo kawona aite kujinka Efeso, chani asekwaza chipindi chochose mo mkowa wa Asiya. Nakaunga asunguze kwingila Yelusalemu mwe zuwa dya Pentekoste uneva vikadahika. ");
INSERT INTO ziw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Paolo kasigila ulosi kulaila Mileto kwita Efeso, akawaunga vilongozi wadalahale wa nyumba yo kuvikila wamhokele. ");
INSERT INTO ziw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Weze wengile, awagamba, Mvimanya viya nidamanye chipindi choseni nihamwenga nanywi, kukongela zuwa dya nkongo ningile mwe mkowa wa Asiya. ");
INSERT INTO ziw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nadamanyaga saviya mndima ywa Zumbe kwa untu woseni na mesozi yalozize chipindi chidala chezaga kwa chausa cha ubala wa Wayahudi wamwenga. ");
INSERT INTO ziw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mvimanya kugamba silekile kuwalonga chochose chakuwambiza mna siwahinya mo lumpe na mwe izikaya zenyu. ");
INSERT INTO ziw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Silonga kwa woseni Wayahudi na sawo Wayahudi kugamba wamhitukile Chohile kwa kweila masa yawo wamzumila Zumbe ywetu Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Vino haluse, kwa kumwiva Muye Ukukile naita Yelusalemu, simanyize chikunga chinilaile kudya. ");
INSERT INTO ziw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Sivimanya du kugamba mwe chila mzi Muye Ukukile kanilonga kugamba chifungo na nkunto vyanigoja. ");
INSERT INTO ziw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mna sikufanyanya ujima wangu ni chintu cha kusinya kwangu, saviya kubindiliza ndima nihokele kulaila kwa Zumbe Yesu, ndima ya kulonga mbuli yedi ya wedi wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Sijinkila mwa nyuwe woseni, halonga Uzumbe wa Chohile. Haluse sivimanya kugamba hahali mwenyu naniwone naho. ");
INSERT INTO ziw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kwaivyo nawaukwilani vino dyelo, yumwenga mwenyu anaga, miye simuli. ");
INSERT INTO ziw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwaviya silekile kuwagambilani viya vyoseni akunga Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ivyo mwesinyise mwedifyo dyoseni Muye Ukukile awaikiye nyuwe mtende wasinya wakwe. Tendani wadimi wa wantu wa nyumba yo kuvikila Chohile, adamanye mwenye kwa sakame ya Mwanawe. ");
INSERT INTO ziw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Sivimanya kugamba hajika kuhalawa, mauzi nayeze kwenyu, nayo hayasigaze mntu mwedifyo. ");
INSERT INTO ziw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Chipindi cheza wantu wamwenga mwe difyo dyenyu nawadante na kuwagulusa wanampina wawatimile. ");
INSERT INTO ziw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Msinyise, naho mkumbuke kugamba kwa mesozi yalozize, chilo na msi, sihinya chila yumwenga wenyu kwa mihilimo mitatu. ");
INSERT INTO ziw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Haluse nawaika mwe ludimo lwa Chohile na wa ulosi wakwe wa mbazi, ukudaha kuwazenga mwe uzumizi nakuwenkani ujimbiko Chohile akuwenka wantu wakwe woseni. ");
INSERT INTO ziw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Saungaga hela zenyu hegu zahabu hegu suche. ");
INSERT INTO ziw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nyuwe mvimanya kugamba nadamanyaga ndima kwa mikono yangu kuhokela chochose miye na mbuya zangu chaungaga. ");
INSERT INTO ziw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Siwalagisani mwe vintu vyoseni kugamba kwa kudamanyisa ndima savino chiwambize hewekwedaha, kukumbuka ulosi alongaga Yesu mwenye akagamba, ‘Kuna mwile utendese mwe kulavya kujinka kuhokela.’ ” ");
INSERT INTO ziw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paolo eze akomeleze, afika madi nawo nakulombeza. ");
INSERT INTO ziw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Woseni nawakaila wakamkumbatila wamlage. ");
INSERT INTO ziw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Wengila chinyulu vidala kwaviya alongaga kugamba hawamwone naho. Niyo waita naye kwe meli. ");
INSERT INTO ziw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Chiwalaga wekale mpeho niyo chahalawa. Chize chajike kutamba mwa mazi chibula Kosi, zuwa ditimile chingila Lodo, kulaila hadya chijendeleza kubula Patala. ");
INSERT INTO ziw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Uko chibwila meli ikwita Foinike, chingila nakutamba nayo. ");
INSERT INTO ziw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Chingila hantu hakudaha kuiwona Sipulasi, niyo naho chatamba kwamwenye mzi mwa Siliya. Chibula Tilo, imeli naikaseleza mizigo yakwe. ");
INSERT INTO ziw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kudya chibwila wanampina wamwenga na kwikala nawo kwa mazuwa mfungate. Kwa udahi wa Muye wamgamba Paolo asekwita Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mna chipindi chetu cho kwikala nawo chize chibule, chihalawa kujendeleza ne ntambo yetu. Woseni hamwenga na wavyele wawo na wana wawo, chitanya kuse komzi mnkanda mwe bahali, uko woseni chifika madi kumlombeza Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Niyo chalagana woseni, chengila mwemeli wowo nawo wauya kukaya. ");
INSERT INTO ziw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Chijendeleza ne ntambo yetu, kulaila Tilo kubula Tolemayi, uko chiwalamsa wazumile niyo chekala nawo hamwenga kwa zuwa dimwenga. ");
INSERT INTO ziw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Zuwa ditimile chihalawa kwingila Kaisaliya. Kudya chikala mwe kaya ya mlonga wa ulosi wa Chohile akwitangwa Filipo, yumwenga mwa wantu mfungate wasagulagwa wambizi uko Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Mntu uyo nana wana wane wa chivyele hewenati kusolwa wakulonga ulosi wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nachikudya kwa mazuwa yalozize umo muwoni akwitangwa Agabo engilaga akalaila Yudeya. ");
INSERT INTO ziw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kachibasa, aguha msipi wa Paolo, enyinya mweviga vyakwe nemikono, akagamba, “Vino nivyo Muye Ukukile akulonga, Mta umsipi uno nanyinywe savino ni Wayahudi wa Yelusalemu, naho nawamlekele kwa Sawo Wayahudi.” ");
INSERT INTO ziw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Chize chive vino, suwe hamwenga nawatuhu chimlombezesa Paolo asekwita Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mna kahitula, “Mwadamanya mbwani, kwila savino nakunusa tama? Sikala vyedi siyo kwa kunyinywa du uko Yelusalemu mna hata kubanika kwa chausa cha Zumbe Yesu.” ");
INSERT INTO ziw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Chidunduga kumgamba usekwita, ivyo chamleka nakugamba, “Viya akunga Zumbe navidamanyike.” ");
INSERT INTO ziw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Chize chiheze kuhumula hadodo, chamalanya vyedi vintu vyetu kwa kwita Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wamwenga wa wanampina kulaila Kaisaliya nawo chijesanya niyo wachigala hekaya ya mntu chikunga chikale naye. Mnasoni, nanimntu akulaila Sipulasi, azumile mwe mazuwa ya nkongo. ");
INSERT INTO ziw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Chize chingile Yelusalemu, wazumile wachihokela welelwa. ");
INSERT INTO ziw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Zuwa ditimile chijesanya na Paolo kwa kumkaula Yakobo, vilongozi wadalahale woseni wa nyumba yo kuvikila naweyaho. ");
INSERT INTO ziw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paolo kawalamsa nakuwenka ulosi uchintile wa chilachintu Chohile adamanye mwa sawo Wayahudi kwa ndima yakwe. ");
INSERT INTO ziw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Weze wamwive, woseni wamtogola Chohile. Niyo wagamba, “Mlukolo ywetu Paolo, waviwona viya magana milongo ya Wayahudi wazumile, na viya wakutongela izisigilizi. ");
INSERT INTO ziw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Wagambilwa kugamba naukahinya Wayahudi woseni nawekekala kwe si za sawo Wayahudi kuleka sigilizi za Musa, kuwagamba wasekujela ngasu wana wawo hegu kutimila viya vikungwa ni Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Weva chindedi kugamba kwingila. Togola, chidamanye mbwani naho? ");
INSERT INTO ziw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Vino nivyo chikunga chidamanye. Hana wantu wane hano waikiye nazili. ");
INSERT INTO ziw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Jesanya nawo utende nawo hamwenga mwe ngasu yo kulenguswa nakuwalihila, wamogwe fili zawo. Mwe isila ino chila yumwenga namanye kugamba hahana chindedi mwe ayo wagambilwe mwako, mna weye mwenye wekala kutimila sigilizi za Musa. ");
INSERT INTO ziw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mna kwa sawo Wayahudi wazumile, chiwegaila mawandiko kuwagambila chiviwona wasekudya nkande yoyose ilavigwe majeleko kwe matukulu, hegu sakame yoyose, hegu nyama yoyose ihogotolwe, naho wasekudamanya uchilanga.” ");
INSERT INTO ziw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Zuwa ditimile Paolo kaguha wadya wantu niyo elengusa hamwenga nawo. Niyo aita kwe Nyumba nkulu ya Chohile kuwagambila yaungwa mazuwa mengahi kubula ukomelezo wa ulenguswa, umo majeleko nayalavigwe kwa chila yumwenga. ");
INSERT INTO ziw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mna iviya mazuwa mfungate yakonga kusila, Wayahudi wamwenga kulaila mkowa wa Asiya wamwona Paolo mwe Nyumba nkulu ya Chohile. Wadijela maya idifyo jima niyo wamgwila Paolo. ");
INSERT INTO ziw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Wagutila, “Wantu wa Izulaeli! Chambizeni! Yuno nuyo mntu akwita chila hantu akahinya chila yumwenga kuhigana na wantu wa Izulaeli, sigilizi za Musa na Nyumba nkulu ya Chohile. Vino haluse kaleta sawo Wayahudi mwe Nyumba ya Chohile na kuhajela uzavu hantu hano hakukile!” ");
INSERT INTO ziw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Walonga vino kwaviya wamwona Tilofimo kulaila Efeso na Paolo mwomzi, nawo wafanyanya kugamba Paolo kamwingiza mwe Nyumba nkulu ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mzi mjima wingilwa ningavungavu, wantu nawo waguluka hamwenga, wamgwila Paolo niyo wambuluziza kuse kwe Nyumba nkulu ya Chohile. Aho nyivi ze Nyumba ya Chohile zavugalwa. ");
INSERT INTO ziw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Idibunga nadikajeza kumkoma Paolo, umo ulosi ukambwila mkulu ywa wankondo wa Chilumi kugamba wantu woseni wa Yelusalemu wana ngavungavu. ");
INSERT INTO ziw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Aho mkulu ywa wankondo aguha wakulu wamwenga na wankondo kuguluka kwedifyo. Wantu weze wamwone nawadya wankondo, waleka kumtowa Paolo. ");
INSERT INTO ziw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mkulu ywa wankondo ambasa Paolo, amgwila, nakunga anyinywe na minyolo midi. Niyo auza, “Mntu yuno ni yuhi, naho katenda mbwani?” ");
INSERT INTO ziw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wamwenga wa mwedifyo wagutila chimwenga, watuhu nawo chituhu. Nakuna mtibilinkanyo umtendile mkulu ywa wankondo asekumanya ichindedi chilaile, ivyo niyo awaunga wantu wakwe wamwigale Paolo kundani kwe dijeleza. ");
INSERT INTO ziw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Waita naye kubula hezintantilo, wankondo niyo wamwinula kulawana ne zingavungavu za wantu. ");
INSERT INTO ziw_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Woseni nawakamtimila kuno wakagutila, “Mkome!” ");
INSERT INTO ziw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Iviya wankondo wakonga kumwigala Paolo mndani mwe dijeza, asimwila na mkulu ywa wankondo, “Nadaha kusimwila dyodyose kwenyu?” Mkulu ywa wankondo auza, “Wasimwila Chiyunani?” ");
INSERT INTO ziw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Weye hwi Mmisili yudya alongozaga wantu milongo mlongo mine nakuwasongaganya vino mazuzi mo luwala?” ");
INSERT INTO ziw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paolo ahitula, “Miye ni Myahudi, selekwa Taso uko Silisiya, mkaya ywa mzi umanyike. Nalombeza nilekani nilonge na wantu.” ");
INSERT INTO ziw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mkulu ywa wankondo amzumila, niyo Paolo achimala mwezintantilo akahunga mkono wakwe wantu wanyamale. Weze wanyamale, Paolo alonga nawo kwa Chiebulaniya, ");
INSERT INTO ziw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Wayahudi weyangu, netegelezani hegombela kwenyu!” ");
INSERT INTO ziw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Weze wamwive asimwila Chiebulaniya kwawo, wanyamalisa, Paolo naye ajendeleza, ");
INSERT INTO ziw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Miye ni Myahudi, nelekwe Taso uko Silisiya, mna sikwila hano Yelusalemu saviya mwanampina ywa Gamalieli. Nahokelaga mahinyo makali ya sigilizi za wadalahala wetu naho naselavya kwa Chohile saviya nyuwe woseni mwili dyelo. ");
INSERT INTO ziw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Siwajela maya hata kuwakoma wantu nawakatimila isila ino. Sigwila wagosi kwa wavyele nakuwajela mwedijeleza. ");
INSERT INTO ziw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mlavyantambiko Mkulu hamwenga ne chitala chose cha wachimaila wantu wadaha kuukula kugamba nalonga chindedi. Nahokelaga baluwa kulaila kwawo iwandikwe kwa chausa cha walukolo Wayahudi wa uko Damesiki, ivyo sita kudya hawagwile wakumzumila wendaga wekudya na kuwegala kubula Yelusalemu wakakantilwe. ");
INSERT INTO ziw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Umo hatamba kubula hajihi na Damesiki, mwe saa mtandatu za msi, aho ulangazi mkali kulaila kwembingu wanimulika kunizunguluka. ");
INSERT INTO ziw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Sigwa hasi niyo neva izwi dikunigamba, ‘Sauli, Sauli! Nimbwani ukunijela maya?’ ");
INSERT INTO ziw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nauza, ‘Weye wiyuhi Zumbe?’ Anigamba, ‘Ni miye Yesu ywa Nazaleti, ukunijela maya.’ ");
INSERT INTO ziw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wantu nachihamwenga wawona ulangazi, mna hawevile idizwi dya uyo na halonga naye. ");
INSERT INTO ziw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nauza, ‘Nitende mbwani, Zumbe?’ Zumbe naye anigamba, ‘Chimala wite Damesiki, uko naukagambilwe chilachintu Chohile aungile udamanye.’ ");
INSERT INTO ziw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nasihituka tuntu kwachausa cho ukuka mkulu, ivyo niyo weyangu wanitoza mkono kunilongoza kwita Damesiki. ");
INSERT INTO ziw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Mo mzi udya nakuna mntu akwitangwa Ananiya, mntu akumtimila Chohile kwasila ya Chiyahudi nakatongela sigilizi zetu naho nakevika vidala ni Wayahudi woseni wakwikala kudya. ");
INSERT INTO ziw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Keza kwangu, anichimaila na kugamba, ‘Mlukolo ywangu Sauli, wana naho!’ Ahadya siwona naho niyo namsinya. ");
INSERT INTO ziw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Agamba, ‘Chohile ywa wadalahala wetu kakusagula weye kumanya viya akunga, kusinya mndima mta wedi, nakumwiva akasimwila kwa izwi dyakwe. ");
INSERT INTO ziw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwaivyo nautende mukuzi ywakwe kugambila chila yumwenga chiya uwone nakwiva. ");
INSERT INTO ziw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Elo haluse, wagoja mbwani? Chimala ubatizwe chani masa yako yauswe ukalombeza kwa zina dya Zumbe.’ ");
INSERT INTO ziw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nasuya Yelusalemu, umo halombeza mwe Nyumba nkulu ya Chohile, nasilota sozi ya msi, ");
INSERT INTO ziw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","umo simwona Zumbe, akanigambila, ‘Sunguza uhalawe Yelusalemu, kwaviya wantu wa hano hawauzumile ukuzi wako.’ ");
INSERT INTO ziw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Sihitula, ‘Zumbe, wavimanya vyedi vidala kugamba nasita kwe nyumba zo kuvikila kugwila nakuwatowa wadya nawakakuzumila. ");
INSERT INTO ziw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Naho umo mukuzi wako Sitefano akakomwa, miye mwenye naniyaho, kuwona file yakwe nakusinya suche za wakomi wakwe.’ ");
INSERT INTO ziw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Zumbe anigamba, ‘Hita, na husigile hale vidala kwa sawo Wayahudi.’ ” ");
INSERT INTO ziw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Wantu wamwetegeleza Paolo kubula akalonga vino, mna niyo wakonga kuguta kwa izwi dya kulanga, “Mlavyeni! Mkomeni! Hakungwa ekale!” ");
INSERT INTO ziw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nawakaguta, wakadula suche zawo, nakudula tifili kulanga. ");
INSERT INTO ziw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mkulu ywa wankondo wa Chilumi awaunga wantu wakwe wamwigale Paolo kundani kwe dijeleza, nakuwagambila wamtowe milugwa chani abunkule ni mbwani Wayahudi nawakamgutila saviya. ");
INSERT INTO ziw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mna weze wamnyinye chani atoigwe milugwa, Paolo amgamba mkulu achimale hadya, “Havikungwa weye kumtowa milugwa mkaya ywa Lumi hejezize hata kudamanya masa?” ");
INSERT INTO ziw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Umo yudya mkulu eze eve viya, ambasa mkulu ywa wankondo nakumuza, “Wadamanya chibwani? Yudya ni mkaya ywa Lumi!” ");
INSERT INTO ziw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ivyo mkulu ywa wankondo aita kwa Paolo nakumuza, “Nigambila, weye wi mkaya wa Lumi?” Paolo ahitula, “Heye.” ");
INSERT INTO ziw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mkulu ywa wankondo agamba, “Nahokelaga ukaya kwa hele zilozize.” Paolo ahitula, “Mna miye ni mwelekwa ywa Chilumi.” ");
INSERT INTO ziw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ahadya wantu nawakaunga wamuze Paolo wauya hanyuma, mkulu ywa wankondo naye kogoha eze abunkule kugamba Paolo nani mkaya ywa Lumi naho kamnyinya minyolo. ");
INSERT INTO ziw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mkulu ywa wankondo nakaunga amanye ichindedi cha kutenda Wayahudi wamlahe Paolo, ivyo zuwa ditimile amfungula Paolo iminyolo nakuwaunga mlavyantambiko mkulu ne chitala chijima wadugane. Niyo amguha Paolo nakumchimalisa mwa meso yawo. ");
INSERT INTO ziw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paolo asinya ichitala nakugamba, “Waizulaeli weyangu! Udahi wangu wa kusagula yedi vitendese mwe sila hwikala mwa meso ya Chohile kubula mwe dizuwa dino.” ");
INSERT INTO ziw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mlavyantambiko mkulu Ananiya awaunga wadya wachimale hajihi na Paolo wamtowe mo mlomo. ");
INSERT INTO ziw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paolo amgamba, “Ichindedi Chohile nakutowe, weye chiwambaza chihakigwe chokaa! Kwikala aho kunilaha kwa sigilizi, uchei hukutimila sigilizi kwa kuwaunga wanitowe!” ");
INSERT INTO ziw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Wantu nawehajihi na Paolo wamgamba, “Wamlongela vihiye Mlavyantambiko Mkulu ywa Chohile!” ");
INSERT INTO ziw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paolo ahitula, “Waizulaeli weyangu, savimanyize kugamba nuyo Mlavyantambiko Mkulu. Mawandiko yagamba, ‘Msekulonga yehiye ya vilongozi wa wantu.’ ” ");
INSERT INTO ziw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paolo eze awone kugamba wamwenga mwe difyo ni Masadukayo na watuhu nawo ni Mafalisayo, aguta mwe chitala, “Waizulaeli weyangu! Miye ni Mfalisayo, mwana Falisayo. Nakantilwa hano kwa chausa cha msuhi ninanawo kugamba wabanike nawauyuke!” ");
INSERT INTO ziw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Eze alonge vino, Mafalisayo na Masadukayo wakonga kulemana, idifyo nadyo dyepagula. ");
INSERT INTO ziw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kwaviya Masadukayo wagamba wantu hawauyuke naho hahana wandima wa kwembingu hegu muye, mna Mafalisayo wazumila kwa vyoseni vitatu. ");
INSERT INTO ziw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Lwasu longezekela vitendese, wamwenga wa wahinyi wa sigilizi wa ntendele ya Mafalisayo wachimala kugombela kwa nguvu, “Hachikuwona dihiye mo umntu yuno! Tankani muye hegu mndima ywa kwembingu chindedi kalonga naye!” ");
INSERT INTO ziw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Mahigano yatendesa makali vitendile mkulu ywa wankondo ogohe na kufanyanya kugamba Paolo natatulwe. Ivyo niyo awaunga wankondo wakwe kwita kwe difyo wakamguhe Paolo kulaila kwawo wamwigale kundani kwe dijeleza. ");
INSERT INTO ziw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Chilo chiya Zumbe amchimaila Paolo nakumgamba, “Usekogoha! Kulavya ulongi wako kwa chausa changu hano Yelusalemu, waungwa udamanye naho ivyo uko Lumi.” ");
INSERT INTO ziw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mtondo utimile Wayahudi wamwenga wadugana niyo waika mwalo. Waika nazili kugamba hawadye hegu kunywa chochose kubula wamkome Paolo. ");
INSERT INTO ziw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nawakajinka milongo mine waikiye umwalo uno hamwenga. ");
INSERT INTO ziw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Niyo waita kwa mlavyantambiko mkulu na wadalahale wakagamba, “Chika nazili hamwenga chisekudya chintu kubula chimkome Paolo. ");
INSERT INTO ziw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Haluse, nyuwe hamwenga nechitala sigilani ulosi kwa mkulu ywa wankondo ywa Chilumi kumwigala Paolo kwenyu, mketenda mwonga mbuli zakwe za chindedi. Mna nachemalanye vyedi kumkoma henati kubula hano.” ");
INSERT INTO ziw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mna mwihwawe dye Paolo kawiva umwalo uwo, niyo aita akumgambila Paolo kwedijeleza. ");
INSERT INTO ziw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Niyo Paolo amwitanga yumwenga mwa wakulu awagamba, “Mwigale mbwanga yuno kwa mkulu ywa wankondo, ana chintu cha kumgambila.” ");
INSERT INTO ziw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mkulu amguha nakumlongoza kwa mkulu ywa wankondo, agamba, “Mvugailwa Paolo kanitanga kunilombeza nimbuze mbwanga yuno kwako, kwaviya anachintu chakulonga kwako.” ");
INSERT INTO ziw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mkulu ywa wankondo amtoza mkono, esenta hamwenga naye niyo amuza, “Una chibwani cha kunigambila?” ");
INSERT INTO ziw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Agamba, “Uzumbe wa Uyahudi wivana luvi wakulombeze umwigale Paolo kwe chitala, waketenda kugamba ichitala chaunga ulosi wedi wakwe. ");
INSERT INTO ziw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mna usekuwetegeleza, kwaviya kuna wantu wakujinka milongo mine wefizize wakamgoja. Waika nazili wasekudya na kunywa kubula wamkome. Vino haluse wemalanya vyedi wagoja weye viya ukunga ulonge.” ");
INSERT INTO ziw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mkulu ywa wankondo agamba, “Usekugambila yoyose kunigambila.” Amleka mbwanga yudya ahalawe. ");
INSERT INTO ziw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Niyo mkulu ywa wankondo etanga wakulu waidi akawagamba, “Malanyani wankondo magana maidi waite Kaisaliya, hamwenga na wakwela falasi milongo mfungate na wata maguha magana maidi wemalanye mhalawa saa ntatu ya chilo. ");
INSERT INTO ziw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Lavyani falasi akwele Paolo naho mumbuze mpeho kwa liwali Feliki.” ");
INSERT INTO ziw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Niyo mkulu ywa wankondo awandika mawandiko yakugamba, ");
INSERT INTO ziw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kilaudiyo Lisiya kwa mtunywa, liwali Feliki, Ndamsa. ");
INSERT INTO ziw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Wayahudi wamgwila yuno mntu naho nawehajihi na kumkoma. Sibunkula kugamba ni mkaya ywa Lumi, ivyo nasita na wankondo kwa kumwambula. ");
INSERT INTO ziw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nasunga nimanye nichibwani wakumlaha niyo namwigala kwechitala chawo. ");
INSERT INTO ziw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Sibunkula kugamba hadamanye dyodyose dyakumtenda akomwe hegu kujelwa mwe chifungo, ulahi ukumgwela watongelana na izisigilizi zawo wenye. ");
INSERT INTO ziw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nize nigambilwe kuna mwalo ukujeswa kwa chausa chakwe, aho nawona nimsigile kwako. Siwagambila wakumlaha wavilonge mwa meso yako.” ");
INSERT INTO ziw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Wankondo watimila viya wagambilwe. Wamguha Paolo chilo chiya kubula Antipatili. ");
INSERT INTO ziw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Zuwa ditimile wadya wankondo wakujenda lwa viga waogola kuya kwengome nakuwalekela wakwela falasi waite naye. ");
INSERT INTO ziw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Wambuza Kaisaliya, wamwinka liwali mawandiko na kumlekela Paolo kwakwe. ");
INSERT INTO ziw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mkulu ywa Chilumi kasoma mawandiko niyo amuza Paolo kalaila mzi wani. Eze abunkule kalaila Silisiya, ");
INSERT INTO ziw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","agamba, “Nahwetegeleze umo wakukulaha waneza.” Niyo amunga Paolo asinywe mwe kaya ya liwali. ");
INSERT INTO ziw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Mazuwa mashano yatimile Mlavyantambiko mkulu Ananiya kaita Kaisaliya na wadalahale wamwenga na mchimaila akwitangwa Tetulo. Walaila kwa Feliki nakumwigaila ulahi mwa Paolo. ");
INSERT INTO ziw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Niyo Paolo etangwa, Tetulo akonga kulavya ulahi wakwe savino, “Mtunywa! Ulongozi wako wedi uchigaila chipindi chitali cha utondowazi, mahituko yalozize yadamanyika kwawedi we si yetu. ");
INSERT INTO ziw_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Chihokela vino chila hantu na chipindi choseni, naho chakuhongeza vitendese. ");
INSERT INTO ziw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Sikunga kukwaziza muda ulozize mna nakulombeza chifile mbazi chetegeleze hadodo. ");
INSERT INTO ziw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Chimbunkula mntu yuno niwakusinyisa, kakonga nkumbizi mgati mwa Wayahudi wose mwe isi naho uyo ni mkulu ywa Nazaleti. ");
INSERT INTO ziw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Naho kajeza kujela uzavu mwe Nyumba nkulu ya Chohile niyo chamgwila. ");
INSERT INTO ziw_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Chaviwonaga chimlahe kwa sigilizi yetu wenye, mna Lisiya mkulu ywa wankondo kabula niyo amusa kwetu kwa udahi mkulu. Niyo Lisiya alavya sigilizi kugamba wakumlaha wabule kwako. ");
INSERT INTO ziw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Uneva unamuza yuno mntu weye mwenye nabunkule yadya yoseni chikumlaha.” ");
INSERT INTO ziw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Wayahudi wazumila ulahi nakugamba yano yoseni ni chindedi. ");
INSERT INTO ziw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mkulu ywa Chilumi niyo amsogeila Paolo kulonga naye Paolo agamba, “Sivimanya kugamba kutenda mlamuzi mwe isi ino kwa mihilimo ilozize, kwa ivyo selelwa kwegombela kwako. ");
INSERT INTO ziw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wadaha kuviwona mwenye, hayajinkile mazuwa mlongo na maidi nasita Yelusalemu kwakuvika. ");
INSERT INTO ziw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wayahudi hawaniwone hatamwila na mntu yoyose mwe Nyumba nkulu ya Chohile, hegu kuniwona haluvya wantu, mwe nyumba za kuvikila hegu hatuhu hohose mo umzi. ");
INSERT INTO ziw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Iviya hakudaha kukwinka ichindedi cho ulahi wawo mwangu. ");
INSERT INTO ziw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Chintu huzumila mwako, Miye namvikila Chohile ywa wadalahala wetu kwa kutimila sila wowo wakugamba siyo ya chindedi. Mna nazumila mwe chila chintu chiwandikwe mwe sigilizi za Musa na mawandiko ya wawoni. ");
INSERT INTO ziw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nina msuhi kwa Chohile saviya wowo wenye wananayo, kugamba wantu woseni, watana na wehiye, nawauyuke. ");
INSERT INTO ziw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kwaivyo nadamanya viya hudaha nitende na udahi wa kusagula yedi kwa Chohile na wantu. ");
INSERT INTO ziw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Nize nitende hale na Yelusalemu kwa mihilimo ilozize, sita kudya kuguha hela kwa wantu wangu kulavya majeleko. ");
INSERT INTO ziw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Umo hadamanya vino wanibwila mwe Nyumba nkulu ya Chohile nize niheze ngasu ya ulenguso. Nahekwine fyo dya wantu hegu ngavungavu. ");
INSERT INTO ziw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Mna Wayahudi wamwenga kulaila si ya Asiya nawehadya, wowo wenye waungwa weze mwako kulavya ulahi wawo kwangu. ");
INSERT INTO ziw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Hegu waleke wano wehano walonge masa waniwone nayo miye hadamanya umo nichimale mwechitala, ");
INSERT INTO ziw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","mna nalongaga chintu chimwenga umo nachimalaga mwawo, ‘Mwanilaha dyelo kwa kuzumila kugamba wafile nawauyuke.’ ” ");
INSERT INTO ziw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliki mwenye amanyize vyedi isila iyo, niyo awikiya zuwa tuhu ulahi uwo, awagamba, “Umo mkulu ywa wankondo Lisiya aneza nanilamule ulahi wenyu.” ");
INSERT INTO ziw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Amunga mkulu amsinye Paolo, mna enkigwe luhenyo naho wawalekele wambuyaze wamwinke chiya akunga. ");
INSERT INTO ziw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Yeze yajinke mazuwa majeche Feliki keza hamwenga na mkaziwe Dulusila, yeye nani Myahudi. Asigila Paolo egalwe akamwetegeleze akasimwila mbuli za kumzumila Kulisito Yesu. ");
INSERT INTO ziw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Mna Paolo umo akajendeleza kulonga mwe wedi, kutenda na chihimo, nedizuwa dikwiza dye nkanto, Feliki noyo ogoha agamba, “Wadaha kwita. Nahwitange naho hatenda na luhenyo.” ");
INSERT INTO ziw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Umo nakafanyanya kugamba Paolo namwinke hela, kwaivyo kamsigila chila nkanana nakusimwila naye. ");
INSERT INTO ziw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ize ijinke mihilimo midi, Feliki kahokelwa ni Pokiyo Fesito kutenda liwali. Feliki nakaunga abwedwe ni Wayahudi niyo amjela Paolo mwe chifungo. ");
INSERT INTO ziw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Mazuwa matatu Fesito eze engile mwe isi, kalaila Kaisaliya kwita Yelusalemu, ");
INSERT INTO ziw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","uko mlavyantambiko mkulu na vilongozi wa Chiyahudi wegala ulahi mwa Paolo. Wamlombeza Fesito ");
INSERT INTO ziw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","kuwegaila Paolo Yelusalemu, kwaviya wamdamanyiza mwalo wa kumkoma mwe sila. ");
INSERT INTO ziw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fesito ahitula, “Paolo kajelwa mwechifungo uko Kaisaliya, miye mwenye nanuye uko mazuwa majeche yakwiza. ");
INSERT INTO ziw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Walekeni vilongozi wenu chijesanye Kaisaliya chikamlahe mntu uyo hegu kadamanya dyodyose dihiye.” ");
INSERT INTO ziw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesito kekala mazuwa matuhu mnane hegu mlongo hamwenga nawo niyo aita Kaisaliya. Mwedizuwa ditimile kekala mwe chitala cha ulamuzi akamunga Paolo egalwe. ");
INSERT INTO ziw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Umo Paolo eze engile, Wayahudi walaile Yelusalemu wachimala wamzunguluka na kukonga kumlahisa, ulahi udunduge kulagisa ichindedi. ");
INSERT INTO ziw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mna Paolo egombela mwenye, “Sidamanye dihiye mwe izisigilizi za Wayahudi hegu Nyumba nkulu ya Chohile hegu Uzumbe wa Chilumi.” ");
INSERT INTO ziw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Mna Fesito nakaunga ekombe mwa Wayahudi, ivyo amuza Paolo, “Naunge wite Yelusalemu kulahwa mwa meso yangu uko?” ");
INSERT INTO ziw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paolo agamba, “Sichimala mwa meso ye chitala cha ulamuzi cha Zumbe mwenye, hungwa nilahwe. Siwadamanyize dyodyose dihiye Wayahudi, saviya wenye umanyize vyedi. ");
INSERT INTO ziw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Uneva sihigana ne isigilizi naungwa nikantilwe kubanika, sikuvilemela. Mna uneva sicho chindedi mwe mbuli ino wakunilaha, hahali akudaha kuninkiliza kwawo. Negombela kwa seuta ywa Chilumi.” ");
INSERT INTO ziw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesito eze ajike kulafya na walangilizi wakwe, ahitula, “Wonga ukegombele kwa Mkulu ywa Chilumi, hita kwa Mkulu ywa Chilumi.” ");
INSERT INTO ziw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mazuwa yatimile Zumbe Agilipa na Benike waita Kaisaliya kutalamka wamlamse Fesito. ");
INSERT INTO ziw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Weze watende uko kwa mazuwa yalozize, Fesito asimwila viya Paolo eli kwa Zumbe, “Hana mntu hano afungagwa ni Feliki, ");
INSERT INTO ziw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","umo naitaga Yelusalemu, mlavyantambiko mkulu ywa Chiyahudi na wadalahale wanigaila ulahi mwakwe nakunilombeza nimkantile. ");
INSERT INTO ziw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mna siwagamba kugamba suwe Walumi hachina mazwela kumlavya yoyose akulahwa hewenati wadya wakumlaha kudugana naye akegombela mwenye mwe yadya wakumlaha. ");
INSERT INTO ziw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Umo wengile hano, sazize muda, mna mwe zuwa ditimile sikala mwe chitala kumunga uyo mntu egalwe. ");
INSERT INTO ziw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Wakuhigana nawo wachimala, mna hawamlahile yehiye nahafanyanya nawamlahe. ");
INSERT INTO ziw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Wananavyo ni mahigano majeche mwe sila ya chiyahudi ya kumlonda Chohile na mwe mntu yumwenga akwitangwa Yesu abanikaga, mna Paolo agamba echei mjima. ");
INSERT INTO ziw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nasina ulamuzi wa viya hunga nihokele chindedi cheimbuli ino, ivyo namlombeza Paolo hegu akaunga aite Yelusalemu akalahwe uko mo ulahi uwo. ");
INSERT INTO ziw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Mna Paolo konga egombele, kalombeza asinywe nakumlekeila Mkulu ywa Chilumi kulamula imbuli yakwe. Ivyo nalavya sigilizi asinywe kubula umo nanidahe kumsigila kwa Mkulu ywa Chilumi.” ");
INSERT INTO ziw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agilipa amgamba Fesito, “Naunga nimwive mntu yuno mwenye.” Fesito ahitula, “Naumwive luvi.” ");
INSERT INTO ziw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Zuwa ditimile Agilipa na Benike wengila kwa chinyemi mwe ngasu kuno wakengila mwe nyumba ye ngasu ya mkulu ywa chinkondo na vilongozi wo mzi. Fesito amunga Paolo egalwe. ");
INSERT INTO ziw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesito agamba, “Zumbe Agilipa na woseni mwihano naswi, Mwamwona mntu yuno akuhigana na wantu wose wa Uyahudi, woseni wa hano na wa Yelusalemu, wanigaila ulahi. Wagutila kugamba akomwe asekutenda mjima naho. ");
INSERT INTO ziw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mna sibunkule chikumtenda akantilwe kukomwa. Kwaviya yeye mwenye konga ekegombele kwa Mkulu ywa Chilumi, siviwona nimsigile. ");
INSERT INTO ziw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mna sina chakindedi cha kumwandikila Mkulu ywa Chilumi. Ivyo simwigala kulongozi kwenyu na kwako zumbe Agilipa! Chani ukaheza uzuza wako mwe mbuli yakwe nadaha kutenda nachintu cha kuwandika. ");
INSERT INTO ziw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwaviya sivyo vyedi kwangu kusigila mfungwa hehena icho chikumlaha.” ");
INSERT INTO ziw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agilipa amgamba Paolo, “Wadaha kwegombela mwenye.” Paolo achulusa mikono yakwe egombela savino, ");
INSERT INTO ziw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Zumbe Agilipa! Nefanyanya sitenda mpafu dyelo negombela mwa yoseni yano hulahwa ni Wayahudi, ");
INSERT INTO ziw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","vitendese kwaviya weye kumanya vyedi mazwela ya Wayahudi. Haluse, nakulombeza unetegeleze ukanijijimiza. ");
INSERT INTO ziw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Wayahudi woseni wavimanya viya nahekala kukongela ni mwana. Wamanya viya nikale vyoseni, nkongo mwe isi yangu vikaheza Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wavimanya mazuwa yoseni, uneva wakaunga waukule kugamba kulaila nkongo sikala saviya mntu ywa bunga dya sila ya Chiyahudi ya kumlonda Chohile, kugamba bunga dya Mafalisayo. ");
INSERT INTO ziw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Vino haluse sichimala hano halahwa kwa chausa cha msuhi ninanawo mwe viya alongile Chohile kwa wadalahala wetu, ");
INSERT INTO ziw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","chintu ichiya makabila mlongo na maidi ya wantu wetu yakusinya kuhokela, umo wakavika kwa Chohile chilo na msi. Zumbe, ni kwachausa cho msuhi uwo, nalahwa ni Wayahudi wano! ");
INSERT INTO ziw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nimbwani nyuwe mwihano mwawona havikudahika kuzumila kugamba Chohile auyusa wabanike? ");
INSERT INTO ziw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Miye mwenye nafanyanya kugamba naungwa kudamanya chila hudaha kwa yadya yakuhigana na Yesu ywa Nazaleti. ");
INSERT INTO ziw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Icho nicho nidamanye uko Yelusalemu. Sihokela udahi kwa mlavyantambiko mkulu nakujela wantu wa Chohile mwechifungo, naho umo wakakantilwa file nahazumila. ");
INSERT INTO ziw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nkanana zilozize ziwakantila mwe nyumba zo kuvikila nakujeza kuwatenda waleke kuzumila kwawo. Nawakanijela maya vidala nahaita kuwalonda kwemizi ya wajeni kuwajela maya. ");
INSERT INTO ziw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Elo mwembuli ino sita Damesiki na udahi na malagizo kwa walavyantambiko wakulu. ");
INSERT INTO ziw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mtunywa umo nimwesila msi, saa mtandatu, siwona ung'azi ukung'alisa ujinkile idizuwa, ukulaila kwembingu ung'ala kunizunguluka na wantu chikutambanya. ");
INSERT INTO ziw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Woseni chigwa hasi, niyo neva izwi dikulonga kwangu kwa Chiebulaniya, ‘Sauli, Sauli! Nimbwani ukunijela maya? Welumiza mwenye kwa kwetowa, saviya njeku ikutowa mateke nkome ya mdimi ywakwe.’ ");
INSERT INTO ziw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Namuza, ‘Zumbe weye ni yuhi?’ Zumbe naye ahitula, ‘Ni miye Yesu, ukunijela maya. ");
INSERT INTO ziw_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mna chimala. Sikulaila hutende mndima ywangu. Uwagambile watuhu chino uwone kwangu dyelo na icho hunga hulagise mazuwa yakutimila. ");
INSERT INTO ziw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nahwambule na wantu wa Izulaeli na sawo Wayahudi hunga husigile kwawo. ");
INSERT INTO ziw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Gubula ameso yawo wahitule kulaila kwechiza na uwengize mo ung'azi wamlawe mo udahi wa Shetani na kumhitukila Chohile, walenguswe kwa sila ya kunizumila wenkigwe kulekeilwa masa yawo nakuhokela hantu hawo mwa wantu wasagulwe ni Chohile.’ ");
INSERT INTO ziw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Kwaivyo, Zumbe Agilipa, sungile nihigane na uwoni wa msi nihokele kulaila kwembingu. ");
INSERT INTO ziw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Kukongela Damesiki na Uyahudi ukajika mwe Yudeya yoseni na mwa sawo Wayahudi, silonga kugamba weile wausizwe masa yawo kumhitukila Chohile kudamanya viya vikunga vilagise kwa ntedwa kugamba wausizwa masa. ");
INSERT INTO ziw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ni kwavino wano Wayahudi wanigwila umo nanimwe Nyumba nkulu ya Chohile, niyo wajeza kunikoma. ");
INSERT INTO ziw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mna vino dyelo sambizwa ni Chohile, ivyo nachimala hano kulavya ukuzi wangu kwa wose, kwa wadodo na wakulu. Chino hulonga nicho ichintu nawakalongaga wawoni na Musa nachilaile, ");
INSERT INTO ziw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","kugamba Kulisito Mkombola aungwa asulumizwe na kutenda ywa nkongo kuuyuka, kulonga ung'azi wa wambulwa kwa Wayahudi na sawo Wayahudi” ");
INSERT INTO ziw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Umo Paolo akegombela mweivyo, Fesito amgutila, “Paolo wi mchilalu! Ukusomesa kwako kwakujela chilalu!” ");
INSERT INTO ziw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paolo ahitula, “Miye suyo mchilalu, Zumbe! Nasimwila ichindedi chitendese. ");
INSERT INTO ziw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Zumbe Agilipa! Nadaha kusimwila naweye kwa ukankalu, kwaviya kuzimanya izimbuli zino. Nina chindedi kugamba kumsinya chila yumwenga, kwaviya chintu chino hachilaile chifisigwe hankanda. ");
INSERT INTO ziw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Zumbe Agilipa, wawazumila wawoni? Sivimanya wawazumila!” ");
INSERT INTO ziw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agilipa amgamba Paolo, “Wafanyanya mwe chipindi chino chijihi wadaha kunitenda Mkulisito?” ");
INSERT INTO ziw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paolo ahitula, “Chitende chipindi chitali hegu chijihi, malombezi yangu kwa Chohile ni kugamba weye na woseni msigale mkunetegeleza dyelo mwadaha kutenda savino miye nili, mna ukausa iminyolo ino!” ");
INSERT INTO ziw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Niyo zumbe mkulu Benike na watuhu woseni wachimala, ");
INSERT INTO ziw_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","weze wahalawe wagambilana, “Mntu yuno hadamanye dyodyose dikumtenda akomwe hegu kufungwa.” ");
INSERT INTO ziw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agilipa amgamba Fesito, “Mntu yuno nakaungwa alekelwe hegu hakunga kwegombela kwa Mkulu ywa Chilumi.” ");
INSERT INTO ziw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ize ilamulwe kugamba chite Italiya, wamlekela Paolo na watumwa watuhu kwa Yuliyo, mndima mwe bunga dya chilumi dikwitangwa “Bunga dya Mkulu ywa Chilumi”. ");
INSERT INTO ziw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Chikwela meli kulaila Adilamitiyo, yemalanye kuhalawa kubula mizi ya mpwani ya Asiya, niyo chahalawa. Alisitaliko Mmakedoniya kulaila Sesalonike nehamwenga na suwe. ");
INSERT INTO ziw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Zuwa ditimile chingila Sidoni. Yuliyo endaga mntu ywedi kwa Paolo kamlekela aite akawakaule wambuyaze, enkigwe chochose akunga. ");
INSERT INTO ziw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Chijendeleza kulaila aho, kwaviya mpeho naikahigana na suwe, chita ntendele ye chisiwa cha Sipulasi. ");
INSERT INTO ziw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Chikanta bahali ya Silisiya na Pamfiliya kubula Mila uko Likiya. ");
INSERT INTO ziw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kudya yudya mndima kawona meli ikulaila Isikandaliya, naikaita Italiya, ivyo niyo achikweza. ");
INSERT INTO ziw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Chijenda mpalahole kwa mazuwa yalozize, kwa udala mkulu uhelo chingila mo mzi wa Chido. Nkun'ginto haichitendile chijendese mwe ntendele iyo, ivyo niyo chajenda kubula mpwani ye chisiwa cha Kilete, kujinkila Salimone. ");
INSERT INTO ziw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Chijinkila mnkanda mwe mpwani kwaudala mkulu chingila hantu hakwitangwa Bandali yedi, saho hale kulaila mo mzi wa Laseya. ");
INSERT INTO ziw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Chihumula chipindi chitali aho, vihosize kutisa kujendeleza netambo, kwa viya zuwa dya kufunga nadijinka kale. Ivyo Paolo awagamba vino, ");
INSERT INTO ziw_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Wagosi, naviwona kugamba ntambo yetu kulaila hano nakujendeleza naitende yatisa, chadaha kwaza mizigo nemeli, naho wantu kwaza ujima nawo.” ");
INSERT INTO ziw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mna mndima ywa wankondo nakevana na mkulu ywe meli na mta imeli mweviya walongile, sivyo viya Paolo alongile. ");
INSERT INTO ziw_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ibandali nasiyo yedi mwe nyota, ivyo wantu walozize nawakaunga kutamba kujeza kubula Foinike, uneva vikadahika, chani wahumule uko mwe nyota. Foinike ni bandali iyuko Kilete ikusinya kwamwenye mzi. Uswelo we dizuwa na chibula, Uswelo we dizuwa. ");
INSERT INTO ziw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mpeho ikuvumila chidogo kulaila kwamwenye mzi ukonga kuvumila, wantu wadya nawo wafanyanya kugamba wadaha kukonga ntambo, ivyo niyo wausa inanga na kujenda mnkanda vikudahika mwe mpwani ya Kilete. ");
INSERT INTO ziw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Mna aho nkung'unto nkulu, ikwitangwa “Kwa mwenye mzi chibula” Uvumila ukasela kulaila kwe chisiwa. ");
INSERT INTO ziw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ijubwanisa imeli, naho kwaviya chidunduga kuhigana nayo niyo chaileka imeli igalwe ni mpeho. ");
INSERT INTO ziw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Chipata hantu ha kuhumula umo chikajinka ntendele ya kwamwenyemzi mwe chisiwa chidodo cha Kauda. Uko kwa udala chidogo, chidaha kuitenda ingalawa yendaga mwe meli ikale vyedi. ");
INSERT INTO ziw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Wantu wendaga mwa mazi waikwesa ingalawa mndani na kuinyinya sigi mwe imeli. Nawakogoha wanasekutoga mwe vigulu vya msanga vya mpwani ya Libiya, ivyo waichimalisa nakuilekela imeli iguhigwe ni kung'unto. ");
INSERT INTO ziw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nkung'unto ijendeleza, ivyo niyo mwe zuwa ditimile wakonga kudula kuse mizigo naimwe imeli, ");
INSERT INTO ziw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","niyo mwe zuwa ditimile wadula viya vimwenga vye meli kuse. ");
INSERT INTO ziw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kwa mazuwa yalozize hachiwone zuwa hegu ntondo, mpeho nayo ijendeleza kuhutisa. Kokukomeleza chikanta tama ya kuhonywa. ");
INSERT INTO ziw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Wadya nawe mwe meli weze watambe kwa chipindi chitali hewakudya nkande, Paolo achimaila akagamba, “Wagosi, mwanetegeleze hachalaile Kilete, hachazize chochose. ");
INSERT INTO ziw_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mnalo haluse nawalombezani, tozani myoyo! Hahali mwenyu akunga age, ni meli iyodu ikunga yage. ");
INSERT INTO ziw_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kwaviya chilo chijinkile mndima ywa kwembingu ywa Chohile humsankanila kanizila ");
INSERT INTO ziw_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","anigamba, ‘Paolo! Usekogoha, waungwa uchimale mwa meso ya Mkulu ywa Chilumi. Chohile mo utana wakwe kwako kawahonya woseni mkutambanya.’ ");
INSERT INTO ziw_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kwa ivyo wagosi, tozani myoyo! Kwaviya namzumila Chohile kugamba navitende saviya anigambile. ");
INSERT INTO ziw_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mna nachigalwe mpwani mwe chisiwa chimwenga.” ");
INSERT INTO ziw_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nani chilo cha mlongo na mine, nachikajubwaniswa uko na uko mwe bahali ya Meditelaniya ni mawimbi. Mwe chilogati vino wandima we meli nawakafanyanya nachikabula hajihi na si nkavu. ");
INSERT INTO ziw_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ivyo niyo waseleza sigi inyinyigwe uzami niyo wabunkula kugamba amazi kwita hasi yabula vinko milongo mine, hadodo chidogo naho wadamanya ivyo wabwila yabula vinko milongo mitatu. ");
INSERT INTO ziw_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nawakogoha kugamba meli naite mwe luwe, ivyo waseleza nanga nne kulaila kunyuma kwe meli nakulombeza kwa Chohile ulangazi wa msi. ");
INSERT INTO ziw_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Niyo awandima wajeza kusumka kulaila mwe meli, waseleza ngalawa mwa mazi waketenda kugamba wakujela nanga ko uso we meli. ");
INSERT INTO ziw_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Mna Paolo amgamba mkulu ywa wankondo na wankondo, “Uneva wandima we imeli hawekale mndani mwe meli, hautende na msuhi wa kuhonywa.” ");
INSERT INTO ziw_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ivyo wankondo wakanta sigi yatozize ingalawa kuileka ite. ");
INSERT INTO ziw_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Iviya hakunati kukunguzuka Paolo awalombeza woseni wadye nkande, “Namkagoja kwa mazuwa mlongo na mane haluse, chipindi choseni icho hamdile chochose. ");
INSERT INTO ziw_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nawalombezani mdye chochose, mwaungwa mdye mhone. Hahana nachage hata luvili lumwenga lwe imitwi yenyu.” ");
INSERT INTO ziw_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Eze alonge ivyo, Paolo aguha mgate, amhongeza Chohile mwa woseni, aubesula nakukonga kudya. ");
INSERT INTO ziw_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Watoza imyoyo, chila yumwenga adya nkande. ");
INSERT INTO ziw_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nachibula wantu magana maidi milongo mfungate na mtandatu mwe imeli. ");
INSERT INTO ziw_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Chila yumwenga eze atende keguta, waihunguza uzami imeli kwa kudula ngano yoseni mwe bahali. ");
INSERT INTO ziw_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kwize kukunguzuke, wandima we imeli hawabunkule ipwani, mna wabunkula chisiwa niyo waviwona kugamba, uneva vikadahika, waigale imeli ikachimale aho. ");
INSERT INTO ziw_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ivyo niyo wazitohola izinanga kuzilekeila zitotohele mwa mazi, umo wakazitohola izisigi zitozize usukani. Niyo wenula tanga kulongozi kwe meli chani mpeho ivumile kulongozi kwe meli, niyo chahinga mpwani. ");
INSERT INTO ziw_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mna meli niyo yakwama mwe dunda dya msanga niyo yatubwilisa ikatenda haikusingisika, mna ntendele ya kunyuma niyo yavunika kwa kutweigwa ni ng'ung'unto kwa nguvu. ");
INSERT INTO ziw_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Wankondo wevana wawakome wafungwa woseni, chani hata mntu yumwenga mgati mwawo asekusumka kwa kogela. ");
INSERT INTO ziw_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mna mndima mkulu ywa wankondo nakaunga amhonye Paolo, ivyo niyo awachinda wasekudamanya viya wakunga. Niyo alagiza wadya wamanyize kogela wedule nkongo mwa mazi watambuke wabule mpwani, ");
INSERT INTO ziw_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","wasigale watimile, watoza mbao hegu vihande vye meli vitulike. Nivyo wose chibwile vyedi mpwani. ");
INSERT INTO ziw_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Chize chingile vyedi mpwani, chabunkula kugamba chisiwa chiya nachiketangwa Malita. ");
INSERT INTO ziw_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Wakaya wa hadya nawachidamanyiza vyedi vidala. Fula naikonga kunya naho nakuna mpeho, ivyo niyo wachijimbila moto nakuchihokela suwe woseni. ");
INSERT INTO ziw_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paolo nakachisanya chisa dya nkuni akadika mo moto umo nyoka ilaile ikatimila joto niyo yezingiliza mo mkono wakwe. ");
INSERT INTO ziw_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wakaya weze wawona inyoka ikanemanema mo mkono wa Paolo, niyo wagambana, “Mntu yuno ni mkomi, mna udahi wa kusagula yedi umtenda mjima, hata uneva kahonywa kubanika kwe bahali.” ");
INSERT INTO ziw_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Mna Paolo kaisingisa inyoka igwele mo moto helumigwe. ");
INSERT INTO ziw_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Nawakamgoja avimbe hegu agwe hasi abanike. Mna weze wagoje kwa chipindi chitali hawawone chochose chimlaile, wahitula fanyanyi zawo wakagamba, “Yuno ni mlungu!” ");
INSERT INTO ziw_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Hajihi na hadya hantu nahana nkonde za Pubuliyo, mkulu ywe chisiwa. Kachihokela vyedi niyo kwa mazuwa matatu chitenda wajeni wakwe. ");
INSERT INTO ziw_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tati yakwe Pubuliyo nemolusazi, mnyonje ywa homa na misango. Paolo aita kwechumba chakwe, alombeza kwa Chohile, amjelekela mikono naye ahonywa. ");
INSERT INTO ziw_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Vize vilaile ivyo, wanyonje watuhu woseni mwe chisiwa weza nakuhonywa. ");
INSERT INTO ziw_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Wachinka majeleko yalozize, umo chikahalawa wachijeila mwe meli vyoseni nachunge mwe ntambo. ");
INSERT INTO ziw_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ize ijinke myezi mitatu chijenda mwe meli kulaila Isikandaliya, ikwitangwa “Vyohile Vidi”, chipindi che nyota chahumulaga mwe chisiwa icho. ");
INSERT INTO ziw_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Chingila mzi wa Silakusa nakuhumula aho kwa mazuwa matatu. ");
INSERT INTO ziw_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kulaila hadya chijenda kwingila mzi wa Legiyo. Zuwa ditimile mpeho ikonga kuvumila kulaila kwamwenyemzi kwa mazuwa maidi chingila mzi wa Puteyoli. ");
INSERT INTO ziw_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Chibwila wazumile hadya wachungile chihumule nawo hamwenga kwa mazuwa mfungate. Nivyo chengila Lumi. ");
INSERT INTO ziw_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Wazumile wa Lumi wachiva na kwiza kuchisingila hajihi na mizi ya Gwilo dya Apiyo na migahawa mitatu. Paolo eze awawone, amhongeza Chohile kuno engile moyo vidala. ");
INSERT INTO ziw_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Chize chingile Lumi, Paolo kazumilwa kwikala mwenye kuno akasinywa ni mnkondo. ");
INSERT INTO ziw_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Yeze yajinke mazuwa matatu Paolo awetanga vilongozi wakaya wa Chiyahudi komdugano. Weze wadugane, awagamba, “Waizulaeli weyangu, hamwenga sidamanye dyodyose dikuhigana na wantu wetu hegu yadya chizwele chihokele kwa watatizetu, sitendwa mfungwa uko Yelusalemu nakwinkizwa kwa Walumi. ");
INSERT INTO ziw_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Weze waheze kunilaha, Walumi nawaunga wanilekele, kwaviya hawawone chikunitenda nikomwe. ");
INSERT INTO ziw_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Mna Wayahudi weze walemele imbuli ino, nasungwa kwa nguvu hegombele kwa Mkulu ywa Chilumi, hata hegu nasina dyakuwalongela wantu wangu. ");
INSERT INTO ziw_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nivyo vilekile sunga ni wawone nakulonga na nyuwe. Ichindedi, nasinyinywa minyolo savino kwa chausa cho msuhi wakwe uyo wantu wa Izulaeli wakumsinya.” ");
INSERT INTO ziw_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Wamgamba, “Hachihokele mawandiko yoyose kulaila Yudeya ukunga weye, naho hahali mntu ywetu yoyose kulaila uko, mbuli hegu chochose chihiye mwako. ");
INSERT INTO ziw_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Mna chonga chive fanyanyi zako, kwaviya chimanya chila hantu wantu wasimwila vihiye mwe idifyo wili.” ");
INSERT INTO ziw_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ivyo waika zuwa dya kudugana na Paolo, wantu walozize mwe idizuwa idyo wabula hadya nakekala. Kukongela mtondo kubula nechilo nakawagambila ulosi wakwe wa Uzumbe wa Chohile, naho kajeza kuwaunga wamanye mbuli za Yesu kwa kulonga viya zilongile Sigilizi za Musa na mawandiko ya wawoni. ");
INSERT INTO ziw_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Wamwenga wazumila kwa ulosi wakwe, mna watuhu hawazumile. ");
INSERT INTO ziw_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ivyo niyo wahalawa, hawevane mgati mwawo, Paolo eze alonge mbuli ino, “Muye Ukukile kalonga vyedi kujinkila muwoni Isaya kwa wadalahala wenyu! ");
INSERT INTO ziw_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Kwaviya nakagamba, ‘Jenda kalonge kwa wantu wano, Namwetegeleze na kwetegeleza, mna hamkombaganye, namsinye na kusinya, mna hamwone, ");
INSERT INTO ziw_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","kwaviya fanyanyi za wantu wano zaganika, magutwi yawo hayakwiva naho wafinya ngohe ameso yawo. Wanasekusinya kwa meso yawo, nakwiva kwa magutwi yawo, mitwi yawo naikombaganye, nakunihitukila, Chohile alonga, nami naniwahonye.’ ” ");
INSERT INTO ziw_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Paolo akomeleza, “Mvimanye kugamba, ulosi wa uhonyi wa Chohile wigalwa kwa sawo wakaya wa Uyahudi. Naweve!” ");
INSERT INTO ziw_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paolo eze alonge vino, Wayahudi wahalawa, wakahigana wenye. ");
INSERT INTO ziw_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kwa mihilimo midi Paolo nehantu apangile mwenye, aho nakahokela woseni nawakeza kumtalamkila. ");
INSERT INTO ziw_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kalonga mwe Uzumbe wa Chohile nakuhinya mbuli za Zumbe Yesu Kulisito, akasimwila kwa ukankalu hehena kuchindwa.");
INSERT INTO ziw_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Miye Paolo, mtumwa ywa Yesu Kulisito, Chohile kanisagula nitende msigilwa naho kanitanga nilonge Mbuli yakwe Yedi. ");
INSERT INTO ziw_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Mbuli Yedi ino ni idya Chohile alaganaga hadya kale kwa kujinkila sila ya wawoni wakwe mwa Mawandiko Yakukile. ");
INSERT INTO ziw_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Mbuli ino Yedi yamlanga Mwana ywa Chohile, Zumbe dyetu Yesu Kulisito, uyo mo untu wakwe, endaga mwelekwa ywa lukolo lwa Daudi. ");
INSERT INTO ziw_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Mna Muye Ukukile, ulagisa kugamba Zumbe dyetu Yesu Kulisito ni Mwana ywa Chohile mta nguvu hadya amuuyuse. ");
INSERT INTO ziw_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kujinkila uyo chihokela mbazi za kutenda wasigilwa, chani chiwagambile wantu wa si zose wazumile na kutimila kujinkila zina dyakwe. ");
INSERT INTO ziw_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nyuwe mwi mgati mwitangwe mtende wantu wakwe Yesu Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Elo nawawandikilani nyuwe nyose mkwikala Lumi, wadya Chohile akuwaungani, niyo awasagula mtende wantu wakwe. Nawalombezezani mbazi na utondowazi kulaila kwa Chohile Tati yetu na Zumbe dyetu Yesu Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nakonga kumhongeza Chohile ywangu kombokela Yesu Kulisito, kwachausa chenyu nyose, kwaviya uzumizi wenyu wevika mwe si yose. ");
INSERT INTO ziw_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Chohile, humsankanila kwa moyo wangu wose kwa sila ya kulonga Mbuli Zedi za Mwanawe ni mukuzi ywangu kugamba chila nkanana nawakumbukani mwa malombezo yangu, ");
INSERT INTO ziw_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","mazuwa yose hamlombeza Chohile, nalombeza kugamba aninke luhenyo lwedi lwa kwiza kwenyu uneva nivyo vikumwagila. ");
INSERT INTO ziw_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kwaviya najelejezesa niwawone chani niwapangileni jeleko dya udahi wa chimuye chani mtoge. ");
INSERT INTO ziw_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Icho hulonga ni chino, miye niwajele moyo kwa uzumizi wangu miye nami nijelwe moyo kwa uzumizi wenyu. ");
INSERT INTO ziw_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Walukolo weyangu, naunga mvimanye kugamba chila nkanana nasunga niwatalamkileni mna kubula haluse kuna vintu vikunichinda. Nahaunga kulaila mwenyu niwatende wantu wamtimile Yesu Kulisito saviya niwatendile wantu wa si ntuhu. ");
INSERT INTO ziw_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Miye natigizwa niwagambile wantu wose, Wayahudi hamwenga na sawo wayahudi, wamanyi hamwenga na sawo wamanyi. ");
INSERT INTO ziw_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nivyo vikuleka, naungisa kulonga Mbuli Yedi kwenyu nyuwe mkwikala Lumi. ");
INSERT INTO ziw_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Sikuona soni kulonga Mbuli Yedi ya Kulisito, iyo ni nguvu ya Chohile ikuwambula wose wazumile. Nkongo Wayahudi, na sawo Wayahudi nawo. ");
INSERT INTO ziw_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kwaviya Mbuli Yedi ya Kulisito yalagisa viya Chohile akuwatenda wantu wedi kulongozi kwakwe. Mbuli ino yadamanywa kwa uzumizi kubula uzumizi, wakongele nawo wadumile nawo, saviya iwandikwe. “Mntu akuwoneka ywedi kulongozi kwa Chohile nekale kwa uzumizi.” ");
INSERT INTO ziw_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Maya ya Chohile yalagiswa kulaila kwembingu yawagwela wata masa na ubanasi wose wa wantu wadya kwa sila zawo zihiye wachinda ichindedi chisekumanyika. ");
INSERT INTO ziw_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kwaviya, yose yakudaha kumanyika kwa Chohile ye pwilili kwawo, kwaviya Chohile mwenye kawagubwila. ");
INSERT INTO ziw_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kukongele kumbwa kwe isi, udahi wakwe wa mazuwa yose no Uchohile wakwe, hata hegu haukuoneka kwa meso, vimanyika pwilili. Wantu wadaha kuvimanya ivyo kwe vintu ivyo adamanye Chohile. Ivyo hawana sila yoyose ya kwegombela! ");
INSERT INTO ziw_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Wammanya Chohile mna hawakumntunya saviya vikuligana, naho hawakumhongeza. Mna fanyanyi zawo zitenda uhezi naho umanyi we myoyo yawo we chihezi ugubikwa ni chiza. ");
INSERT INTO ziw_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Wetenda ni wamanyi, mna ni wahezi, ");
INSERT INTO ziw_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","waleka kumvikila Chohile akwikala mazuwa yose, wavikila matukulu yakwinga wantu nawabanike hegu wanyama hegu wadege hegu vikutambala. ");
INSERT INTO ziw_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Kwachausa icho Chohile kawaleka wantu wadya wadamanye vihiye saviya myoyo yawo ikunga, na kudamanyizana mbuli zikuwajela uzavu mwe mili yawo wowo wenye. ");
INSERT INTO ziw_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Wahitula ichindedi kumlanga Chohile chitende udanti, wavikila na kutunya adamanye Chohile wamleka Muumbi mwenye, yudya akuligana na ntogozi mazuwa yose! Taile. ");
INSERT INTO ziw_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Kwaivyo, Chohile kawaleka watimile viya mili yawo ikunga. Hata wavyele waleka kujenda na wagosi wajenda na wavyele weyawe. ");
INSERT INTO ziw_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Seivyo wagosi waleka kujenda na wavyele wakonga kumeila mate wagosi weyawe. Wagosi wadamanyizina mbuli za soni, ivyo wegaila wenye maliho yakuligana na ntendwa zawo zihiye wadamanye. ");
INSERT INTO ziw_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kwaviya wantu wadya walemela kumbunkula Chohile, Chohile kawaleka mwe fanyanyi zawo zihiye, wadamanya yadya heyeligane wayadamanye. ");
INSERT INTO ziw_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Nendile wamema chila masa, upolaganyi na ubafu na fanyanyi zihiye. Wamema wihi na ukomi na nkumbizi na udantilizi na makambo yaihiye na kulongelana yehiye, ");
INSERT INTO ziw_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","wantu kutwilana lulimi, wakumwihiza Chohile, wakuhulutana, wata kweduvya, wakungisa kudamanya yehiye, naho hewekuweva welesi wawo, ");
INSERT INTO ziw_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ni wahezi naho hawana uzumizi hegu mbazi hegu wedi kwa watuhu. ");
INSERT INTO ziw_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Wavimanya kugamba sigilizi ya Chohile yagamba wantu wakwikala seivyo, waligana na file. Ukaleka ayo, sukodu kugamba wadamanya mbuli izo wowo wenye, mna wawatogola wadya wakudamanya mbuli saizo. ");
INSERT INTO ziw_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Elo mbuyangu, uneva walaha watuhu, hukudaha kwegombela, hata hegu weye wi yuhi. Kwaviya kwa kuwalaha watuhu, wekantila wemwenye kwaviya wadamanya vintu iviya ukulaha. ");
INSERT INTO ziw_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Chimanya kugamba Chohile kachuma mo kukantila wadya wakudamanya vintu saivyo. ");
INSERT INTO ziw_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Mna weye mbuyangu ukulaha wadya wakudamanya vintu seivyo kuno wenawe wavidamanya, togola nawenege kanto dya Chohile? ");
INSERT INTO ziw_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Hegu wabela wedi wakwe mkulu, na ujijimizi wakwe na ugoji wakwe, togola humanyize kugamba wedi wa Chohile nuwo ukulongoza chani weile? ");
INSERT INTO ziw_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Mna una moyo mdala hewina kuleka masa, ivyo watenda maliho yako yatendese makulu mwe dizuwa Chohile akunga alagise nkanto dyakwe dya chindedi. ");
INSERT INTO ziw_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Chohile namlihe chila mntu kuligana na viya adamanye. ");
INSERT INTO ziw_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Wadya wakujendeleza kudamanya ntendwa zedi kulonda ukulu na ntunyo na wikazi wa mazuwa yose Chohile nawenke ujima wa mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Mna wadya watuhu wabafu na wakulemela yadya ye chindedi ya Chohile na kutimila yehiye, Chohile nawafile maya na kuweihiwa. ");
INSERT INTO ziw_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Wadya wantu wose wakudamanya masa, nawakunte na kusulumila, nkongo Wayahudi vikaheza wantu sawo Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Mna Chohile nawenke ukulu na ntogozi na utondowazi wadya wakudamanya mbuli zedi, nkongo Wayahudi ukajika wantu sawo Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kwaviya mwa meso ya Chohile hakupagula wantu wose ni wamwe. ");
INSERT INTO ziw_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Wadya wakudamanya masa hehena Sigilizi Chohile amwinkile Musa, nawage hehena Sigilizi. Wadya wakudamanya masa kuno walongozwa ni Sigilizi ya Chohile amwinkile Musa nawakantilwe ni Sigilizi. ");
INSERT INTO ziw_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kwaviya siyo kugamba wakwetegeleza isigilizi nawo nawawoneke wedi kulongozi kwa Chohile, mna wakutoza isigilizi nawo nawatende wedi. ");
INSERT INTO ziw_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Uneva wantu sawo Wayahudi hewena Sigilizi Chohile amwinkile Musa, mna wakadamanya vikulongozwa ni myoyo yawo ni sigilizi kwawo hata hegu hahana Sigilizi. ");
INSERT INTO ziw_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Kwaviya walagisa kugamba malagiso ya Sigilizi yawandikwa mwe myoyo yawo. Fanyanyi zawo zawalaha hegu zawagombela. ");
INSERT INTO ziw_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ivyo nivyo navilaile mwe dizuwa diya Chohile akunga akante mbuli za wantu zefisize mwe myoyo, kwa sila ya Yesu Kulisito, saviya Mbuli Yedi ya Kulisito nilongile. ");
INSERT INTO ziw_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Elo togola weye? Wemwenye wegamba wi Myahudi, naho kwikiya msuhi Sigilizi, na kweduvya kugamba wi ywa Chohile, ");
INSERT INTO ziw_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kuvimanya viya Chohile akunga kwa sila ya Sigilizi naho wadaha kusagula vintu vyedi, ");
INSERT INTO ziw_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","weye wewona kugamba chindedi wi chilongozi ywa matuntu na ulangazi kwa wadya we mwe chiza, ");
INSERT INTO ziw_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","wewona mhinyi ywa wahezi na mhinyi ywa wachei kutoga. Kuvimanya kugamba mwe Sigilizi mna umanyi uchintile na chindedi. ");
INSERT INTO ziw_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Elo, weye wahinya watuhu, ni mbwani hukwehinya mwenye? Walonga watuhu wasekubawa, mna weye mwenye wabawa. ");
INSERT INTO ziw_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Wagamba, “Usekugonya mvyele ywa mwenye” Mna weye mwenye wagonya mvyele ywa mwenye? Wehiwa matukulu mna weye mwenye watenda mgoli kwa kubawa mwe nyumba za matukulu? ");
INSERT INTO ziw_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Wetunya kugamba kutoza sigilizi ya Chohile, mna hukuviwona kugamba wamjela soni Chohile kwa kuhigana na sigilizi yakwe? ");
INSERT INTO ziw_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Saviya viwandikwe mwa Mawandiko Yakukile, “Wantu wa si ntuhu wahuluta zina dya Chohile kwachausa cha nyuwe Wayahudi.” ");
INSERT INTO ziw_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kujelwa ngasu kwako nakutende kwedi uneva watoza Sigilizi. Mna hegu hukuitoza Sigilizi, kujelwa ngasu kwako hakukukwambiza ng'o. ");
INSERT INTO ziw_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Uneva mntu hejeligwe ngasu atimila viya sigilizi zikunga, Chohile hamfanyanye saviya kajelwa ngasu? ");
INSERT INTO ziw_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Elo nyuwe Wayahudi namkantilwe ni sawo Wayahudi kwaviya hamtimile Sigilizi, hata hegu mnanayo mawandiko ya Sigilizi naho mjelwa ngasu, kuno wowo watimila Sigilizi, hata hegu hawajeligwe ngasu. ");
INSERT INTO ziw_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nuko kugamba, suyo chila akwelagisa Myahudi kwa kuse ni Myahudi toti, naho mntu hakutenda Myahudi toti hambwe kwa kujelwa ngasu chimwili du. ");
INSERT INTO ziw_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Mna, Myahudi toti ni yudya mntu Myahudi kwa kundani, ajeligwe ngasu ko moyo ni Muye Ukukile, siyo mbuli ya mawandiko ya sigilizi. Mntu sauyo ahokela utogozi ulaile kwa Chohile, siyo ulaile kwe wantu. ");
INSERT INTO ziw_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Elo Myahudi ana chihi chitendese kujinka wantu sawo Wayahudi? Hegu kujelwa ngasu kuna utana wani? ");
INSERT INTO ziw_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Kwawagila vidala kwa chila sila. Nkongo, Chohile kawenka Wayahudi ulosi wakwe. ");
INSERT INTO ziw_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Mna navitende vivihi uneva wamwenga wawo hawazumile? Kuleka kuzumila kwawo nakuhunguze ukanuni wa Chohile? ");
INSERT INTO ziw_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Bule! Chohile nasigaile kutenda mchindedi mazuwa yose, hata hegu chila mntu ni mdanti, saviya viwandikwe mwa Mawandiko Yakukile, “Weye, umanyike kugamba wi mta wedi mwe milosi yako. Ukakantilwa weye we wi mhumi.” ");
INSERT INTO ziw_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Mna, uneva wihi wetu walagisa pwilili kugamba Chohile adamanya wedi, nachigeze? Togola, nachigambe kugamba hana wedi akachilaha? Hano nalonga chimntu. ");
INSERT INTO ziw_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Bule! Hegu Chohile hendile mchindedi nakadaha vivihi kukantila wantu we isi? ");
INSERT INTO ziw_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Mna “Uneva udanti wangu walagisa pwilili uchindedi wa Chohile, elo ni mbwani naho miye nikantilwe saviya mta masa?” ");
INSERT INTO ziw_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Chigeze! “Chidamanye vihiye chani kulaile vyedi”? Chindedi kuna wantu wamwenga wakunihuluta vihiye kugamba silonga ivyo. Wantu awo nawakantilwe saviya vikuwawagila. ");
INSERT INTO ziw_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Chigeze? Suwe Chiwayahudi wedi kujinka wantu wa si ntuhu? Bule! Siwalagisa kale kugamba Wayahudi na sawo Wayahudi wose walongozwa ni masa. ");
INSERT INTO ziw_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Saviya viwandikwe kugamba. “Hahali awoneke ywedi kulongozi kwa Chohile, ");
INSERT INTO ziw_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Hahali mntu mta umanyi, hegu mntu akumlonda Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Wose wamhituka Chohile, wose watenda wavu, hahali akudamanya vyedi, hahali hata yumwenga. ");
INSERT INTO ziw_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Milosi yawo imema wihi, limi zawo zimema udanti, walonga mbuli zikutisa saviya usungu wa nyoka, ");
INSERT INTO ziw_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","milomo yawo imema maligito na ukali. ");
INSERT INTO ziw_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Viga vyawo vyagulukila kukoma wantu, ");
INSERT INTO ziw_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","aho nawaite wahosa ndilo na masulumizo. ");
INSERT INTO ziw_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Sila ya utondowazi hawaimanyize, ");
INSERT INTO ziw_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Hawakumogoha Chohile.” ");
INSERT INTO ziw_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Chivimanya kugamba Sigilizi ni ya wadya wakulongozwa ni Sigilizi iyo, hahana hata yumwenga natende nachakwegombela isi yose naikantilwe ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kwaviya hahali mntu yeyose akuwoneka ywedi kulongozi kwa Chohile kwa kudamanya viya Sigilizi zakwe zikunga. Ndima ya Sigilizi ni kumlagisa du mntu kugamba kadamanya masa. ");
INSERT INTO ziw_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Mna haluse, sila ya Chohile ya kuwazumila wantu kutenda wedi igubulwa kale, naho siyo kwa sila ya sigilizi, hata ivyo mawandiko ya Sigilizi na ya wawoni yaukula mwe mbuli ino. ");
INSERT INTO ziw_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Chohile awatenda wantu wawoneke wedi kwa sila ya uzumizi mwa Yesu Kulisito. Chohile adamanya vino kwa woseni wakumzumila Kulisito, kwaviya hahana vyesimile mgati mwawo, ");
INSERT INTO ziw_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","kwaviya wose wadamanya masa naho wehale na ukulu wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Mna kwa mbazi za Chohile ziya ni majeleko du, wantu woseni watendwa wawoneke wedi kulongozi kwa Chohile kwa sila ya Yesu Kulisito, akuwakombola. ");
INSERT INTO ziw_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Chohile kamlavya lavyo Yesu, chani kujinkila uzumizi wa sakame yakwe atende sila ya kuwausiza wantu masa kwa uzumizi wawo kwakwe. Chikale icho Chohile nanimjijimizi nakulekela masa ya wantu, mna haluse asinya masa yawo, chani alagise wedi wakwe. ");
INSERT INTO ziw_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Chohile kadamanya vino chani alagise kugamba kawoneka ywedi. Mwe isila ino Chohile mwenye elagisa kugamba ni ywedi naho amtenda mntu yoyose kutenda ywedi chila akumzumila Yesu. ");
INSERT INTO ziw_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Elo, chadaha kwefenyeza mbwani? Hahana! Vino viletwa nini? Kwaviya chatimila Sigilizi? Bule. Mna kwa uzumizi. ");
INSERT INTO ziw_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kwaviya chawoneka wedi kulongozi kwa Chohile kwa sila ya uzumizi, siyo kwa kutimila vikulagizwa ni Sigilizi. ");
INSERT INTO ziw_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Hegu, Chohile ni Chohile ywa Wayahudi awodu? Suyo Chohile ywa sawo Wayahudi? Heye, ichindedi ni ywawo nawo. ");
INSERT INTO ziw_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Chohile ni yumwenga du, naho nuyo nawatendile Wayahudi na wantu sawo Wayahudi kuwoneka wedi kulongozi kwakwe kwa sila ya uzumizi wa chila yumwenga. ");
INSERT INTO ziw_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Elo nuko kugamba kwa uzumizi uno chaleka kutongela Sigilizi? Bule, mna chaitunya Sigilizi vichintile. ");
INSERT INTO ziw_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Chigeze naho, mwa Bulahimu, tati yetu chilukolo? ");
INSERT INTO ziw_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Uneva Bulahimu atendagwa ywedi mwa Chohile kwa sila za tendwa zakwe, nendile ana chintu cha kwefenyeza mna siyo kulongozi kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Mawandiko yagamba, “Bulahimu amzumilaga Chohile na kwachausa cho uzumizi Chohile amtendaga ywedi.” ");
INSERT INTO ziw_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Mntu akudamanya ndima maliho yakwe hayakuwazwa saviya majeleko mna alihwa viya vimuwagile. ");
INSERT INTO ziw_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Mna kwa mntu hanegamile ntendwa zakwe mwenye, mna amzumila Chohile akuwalekeila wantu wavu na kuwatenda wedi, Chohile asinya uzumizi wa mntu uyo, na kumtenda ywedi. ");
INSERT INTO ziw_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Vino nivyo Daudi alongaga mwe mntu mta chinyemi azumilwe ni Chohile kutenda ywedi, ukaleka kusinya ntendwa za mntu uyo. ");
INSERT INTO ziw_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Wata chinyemi ni wadya walekeilwa masa yawo, wadya masa yawo yausigwa! ");
INSERT INTO ziw_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Mta chinyemi ni yudya amasa yakwe hayakukumbukwa ni Zumbe!” ");
INSERT INTO ziw_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Togola, chinyemi icho chikulongwa ni Daudi ni kwa wadya du wajeligwe ngasu hegu na wadya hewejeligwe ngasu? Kwaviya chitimila Mawandiko, “Bulahimu kamzumila Chohile, naho kwachausa cho uzumizi wakwe Chohile kamwona ni ywedi.” ");
INSERT INTO ziw_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Togola! Bulahimu nakazumilwa umo henati kujelwa ngasu, hegu eze ajelwe ngasu? Umo henati kujelwa ngasu, sivyo eze aheze kujelwa ngasu. ");
INSERT INTO ziw_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Bulahimu ajelagwa ngasu enga chilagiso cha wedi kulongozi kwa Chohile ahokelaga kujinkila uzumizi chipindi henati kujelwa ngasu chani kumtenda uyo atende tate ywa wose wadya nawazumile hehena kujelwa ngasu. Elo, yose yadamanyika chani Bulahimu atende tati ywa wose wakumzumila Chohile awo wawoneke wedi kulongozi kwa Chohile hata hegu hawajeligwe ngasu. ");
INSERT INTO ziw_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Naho ni tati ywa wadya wajeligwe ngasu, mna siyo kwaviya wajelwa ngasu, mna kwaviya watongela sila idya ya uzumizi tati ywetu Bulahimu azumilaga umo henati kujelwa ngasu. ");
INSERT INTO ziw_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Chohile aikaga ndagano na Bulahimu na welekwa wakwe kugamba isi yose naitende yakwe. Kadamanya ivyo, siyo kwaviya Bulahimu nakatimila Sigilizi, mna kwa uzumizi niyo atendwa ywedi ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Uneva wakunga walisi yadya Chohile alaganaga na wadya watimilaga Sigilizi, ivyo uzumizi ni wa bule naho viya Chohile alaganaga ni vya bule. ");
INSERT INTO ziw_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Sigilizi yegala maya ya Chohile, mna uneva hahana sigilizi, kubalanga sigilizi hakuhali. ");
INSERT INTO ziw_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Elo, mbuli ino yegamila uzumizi, ivyo ndagano iyo yegalwa kwa mbazi za Chohile naho ni chindedi kugamba ndagano iyo ni kwa wantu wose siyo kwa wadya du wakutimila Sigilizi, mna seivyo kwa wadya wakwikala kwa uzumizi saviya Bulahimu, kwaviya Bulahimu ni tati yetu suwe chose, ");
INSERT INTO ziw_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","saviya Mawandiko Yakukile yakulonga, “Sikutenda tati ywa si zilozize.” Bulahimu nuyo tati ywetu kulongozi kwa Chohile yudya amzumile. Chohile akuwenka wantu wabanike ujima, na kuvitenda vintu hevihali vitende viyaho. ");
INSERT INTO ziw_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Bulahimu azumilaga na kutenda na msuhi, hata hegu nahehena chikumtenda atende na msuhi, kwaivyo katenda “tati ywa si zilozize.” Saviya Mawandiko Yakukile yakulonga, “Cheleko chako nachitende chiloza.” ");
INSERT INTO ziw_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Mna uzumizi wakwe hauhunguke hata hegu endaga na mihilimo gana vino nakamanya kugamba mwili wakwe nendile usokela enga ubanika, naho mkaziwe Sala hakudaha kutenda na wana. ");
INSERT INTO ziw_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Halekile uzumizi wakwe, naho hajeile nkama kugamba Chohile nachintize chiya alagane, mna uzumizi wakwe umjela nguvu, niyo amtogola Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Nakavimanya kugamba Chohile adaha kuchintiza idya indagano. ");
INSERT INTO ziw_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Nivyo vilekile Chohile kamwona Bulahimu ni ywedi. ");
INSERT INTO ziw_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ikalongwa “Awoneke ywedi” haiwandikwe kwachausa chakwe du. ");
INSERT INTO ziw_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Naho yawandikagwa kwachausa chetu suwe chiwoneke wedi kulongozi kwa Chohile, yudya amuuyusa Yesu Zumbe dyetu. ");
INSERT INTO ziw_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Uyo alavyagwa akomwe kwachausa cha masa yetu, niyo auyuka chani chitendwe wachumile kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Haluse kwaviya chitendwa wedi kwa Chohile kombokela uzumizi, china utondowazi na Chohile kombokela Zumbe dyetu Yesu Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Uyo kwa sila ya uzumizi kachigala mwe mbazi za Chohile, umo chikwikala vino haluse. Elo chefenyeza msuhi chinanawo wa kwehanga na ukulu wa Chohile! ");
INSERT INTO ziw_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Sivyo ivyodu chefenyeza kusulumila kwetu, kwaviya chimanya kugamba kusulumila kwegala ujijimizi, ");
INSERT INTO ziw_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ujijimizi wegala lujendo lukumwagila Chohile, lujendo lukumwagila Chohile lwegala msuhi. ");
INSERT INTO ziw_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Msuhi uno suwo waudanti, kwaviya Chohile kajida ungi wakwe mndani mwe myoyo yetu kwa Muye Ukukile, udya achinkile. ");
INSERT INTO ziw_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Umo chendaga hachikwedaha, Kulisito abanikaga kwachausa chetu suwe wata masa. ");
INSERT INTO ziw_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ni vidala mntu kubanika kwachausa cha mntu mta wedi. Hata hegu mntu adaha kubanika kwachausa cha mntu ywedi. ");
INSERT INTO ziw_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Mna Chohile kalagisa pwilili kwetu ungi wakwe, hadya chendaga china masa niyo Kulisito abanikaga kwachausa chetu! ");
INSERT INTO ziw_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kwaviya haluse chitendwa wedi kwa Chohile kwa sakame ya Kulisito, ni chindedi pwilili kugamba na chambulwe na maya ya Chohile! ");
INSERT INTO ziw_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Hegu hadya chendaga wankondo wa Chohile, Chohile kachitenda chivane kwa file ya mwanawe. Vyatenda zeze haluse chiwambuya wa Chohile, nachambulwe kwa ujima wa Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Mna sayo ayodu, china chinyemi kwachiya Chohile achivanye kombokela Zumbe ywetu Yesu Kulisito, achitendile wambuya wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Masa yengila mwe isi kombokela mntu yumwenga, nayo yegala file. Ivyo file izagala mwa wantu woseni kwaviya woseni wana masa. ");
INSERT INTO ziw_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Umo Sigilizi hezihali, masa nayendile mwe isi, mna masa hayakufanyanywa hekwina sigilizi. ");
INSERT INTO ziw_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Mna kukongela mwa Adamu kubula kwa Musa file iwatimila hata hewedamanye masa yakuligana na masa adamanye Adamu umo hatimilaga sigilizi ya Chohile. Adamu ni mliganyo wa yudya akutimila kwiza. ");
INSERT INTO ziw_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Mna jeleko hadikuligana na masa, ni chindedi kugamba yawegala wantu walozize wabanike kombokela masa ya mntu yumwenga. Mna mbazi za Chohile ni jeleko diya dikwinkiza ujima kwa wantu walozize, kujinkila mbazi za mntu yumwenga, Yesu Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Naho, kuna kwesima mgati mwe jeleko dya Chohile na mbuli zilaile kwachausa cha masa ya yudya mntu yumwenga eze adamanye masa. Chohile niyo alavya nkanto, mna kwa masa ya wantu walozize, Chohile kawenka jeleko dya kuwalekeila! ");
INSERT INTO ziw_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ni chindedi kugamba file ikonga kwikala kwa sila ya mntu yumwenga, kwachausa cha masa ya mntu uyo yumwenga. Mna yalagisisa kugamba yawegala wadya wa kuwonelwa mbazi za Chohile vilozize na jeleko dya wedi wakwe, na wikazi na kulongoza kwa sila ya mntu yumwenga, Yesu Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Elo, ni saviya masa ya mntu yumwenga yawegaila wantu wose nkanto, seivyo ntendwa ya wedi wa mntu yumwenga iwalekeila na kuwenka ujima. ");
INSERT INTO ziw_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Saviya wantu walozize watendigwe wadamanya masa kwa kuleka kwiva kwa mntu yumwenga, seivyo wantu walozize na watendwa wedi kwa Chohile kwa mntu yumwenga kumwiva Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Sigilizi iza na kwigala kongezekela kwa masa, mna masa yeze yongezekele, mbazi za Chohile zongezekelesa. ");
INSERT INTO ziw_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Saviya masa yalongoze na kwigala file, ivyo mbazi za Chohile zalongoza kwa wedi na kwigala ujima wa mazuwa yose kombokela Yesu Kulisito Zumbe dyetu. ");
INSERT INTO ziw_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Chigeze naho? Chijendeleze kudamanya masa chani mbazi Chohile zijenyele? ");
INSERT INTO ziw_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Bule! Suwe chibanika mwe masa, nachijendeleze vivihi naho kwikala mwe kudamanya masa? ");
INSERT INTO ziw_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Togola hamvimanyize kugamba chabatizwaga mwe file ya Yesu Kulisito? ");
INSERT INTO ziw_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Chize chibatizwe chihambwa hamwenga na uyo mwe file yakwe, chani saviya Kulisito auyuke kwa ukulu wa Tate, suwe naswi chikale mwe ujima mhya. ");
INSERT INTO ziw_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Uneva suwe chilungana naye mwe file, seivyo nachilungane naye mo kuuyuswa saviya auyukaga. ");
INSERT INTO ziw_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Naho chivimanya kugamba wikazi wetu we chikale utungikwa hamwenga na Yesu mo msalaba, chani udahi wa mwili wa masa ubalangwe, chisekutenda naho watumwa wa masa. ");
INSERT INTO ziw_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kwaviya mntu abanike kambulwa mwe nguvu za masa. ");
INSERT INTO ziw_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ivyo uneva chibanika hamwenga na Kulisito, chazumila kugamba nachikale hamwenga naye. ");
INSERT INTO ziw_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kwaviya chivimanya kugamba Kulisito kauyuka, habanike naho, file haimdahe naho. ");
INSERT INTO ziw_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Kabanika lumwenga du kwachausa cha masa. Habanike naho ekala kwa kumwagila Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Mweivyo, mwefanyanye saviya wabanike mwe masa, mna mwekala kumsankanila Chohile kombokela Kulisito Yesu. ");
INSERT INTO ziw_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ivyo masa yasekulongoza naho mili yenyu ikubanika, vikatenda mtimile tama zakwe. ");
INSERT INTO ziw_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Naho msekujeza kulavya vitago vyenyu vidamanye mbuli za wihi na masa. Mna vilavyeni kwa Chohile saviya wantu wata ujima, kwelavyeni kwa wedi. ");
INSERT INTO ziw_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Masa yasekuwatenda watumwa naho, kwaviya hamkulongozwa ni sigilizi mna kwa mbazi mlagiswe ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Haluse chigeze? Chidamanye masa, kwaviya hachikulongozwa ni sigilizi mna chadimwa ni mbazi ya Chohile? Bule! ");
INSERT INTO ziw_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ichindedi mvimanya kugamba mnelavya kumwiva mntu msiku saviya watumwa wakwe, ichindedi mwi watumwa kwa yudya mkumwiva, hegu watumwa wa masa, chikutimila ni file, hegu kumwiva Chohile, chikutimila ni kutendwa wedi wa myoyo. ");
INSERT INTO ziw_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Mna Chohile atogolwe! Namwi watumwa wa masa aho kale, mtimila chindedi mbunkule mwa mahinyo mhokele kwa myoyo yenyu yose. ");
INSERT INTO ziw_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mwakombolagwa mwe masa na kutenda watumwa wa wedi wa moyo kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Nalonga milongele ya chiuntu ya wantu wahwele mo utumwa. Aho kale mwelavyaga kutenda watumwa wakudamanya uzavu na wihi kwa kwikala mwe nkumbizi, seivyo kwelavyeni wenye mdamanye yedi kwa Chohile kwachausa cha ulenguswa. ");
INSERT INTO ziw_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Umo mwendaga watumwa wa masa mwendaga mwihale kutenda yadya yakumwagila Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Elo, mhokela chibwani kwa kudamanya viya mkuviwonela soni haluse? Usilo wa mbuli saizo ni file! ");
INSERT INTO ziw_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Mna haluse mkombolwa kale kulaila mwe masa naho mhitukila watumwa wa Chohile. Uvuni wenyu ni kwikala mwe ulenguso mo udumo kwinkigwa ujima wa mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kwaviya maliho ya masa ni file, mna jeleko dya Chohile ni ujima wa mazuwa yose mwe Kulisito Yesu Zumbe dyetu. ");
INSERT INTO ziw_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Walukolo weyangu, sina nkama mmanye yano hunga nilonge, kwaviya nyuwe nyoseni mmanya mbuli za sigilizi. Sigilizi yamlongoza mntu achei mjima. ");
INSERT INTO ziw_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Chigambe, mvyele asoligwe atozwa ni sigilizi kwa mgosiwe umo mgosi uyo akatenda ni mjima, mna hegu akabanika, mvyele uyo kakombolwa mwe sigilizi imtozize. ");
INSERT INTO ziw_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ivyo, uneva mvyele uyo akekala na mgosi mtuhu kuno mgosiwe ni mjima, nagambigwe mjenda na mntu ywa mweye, mna hegu mgosiwe kabanika, nachoholwe mwe sigilizi, akaguhigwa ni mgosi mtuhu hagambigwe mjenda na mtu ywa mwenye naho. ");
INSERT INTO ziw_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Walukolo weyangu, ivyo nivyo vili kwenyu. Nyuwe nanywi mwe sigilizi mbanika kujinkila mwili wa Kulisito, haluse mtenda wakwe auyuke chani mumdamanyize yedi Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Kwaviya umo nachikekala chimwili, tama zihiye zikasindikwa ni sigilizi, zidamanya ndima mwe mili yetu, vitendile chihele mwe file. ");
INSERT INTO ziw_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Mna haluse, chichohwelwa mwe sigilizi, kwaviya chibanika mwe mbuli idya ichitendile watumwa. Haluse chasankanila kulawana na wikazi mhya wa Muye, mna siyo kutimilana na mbuli idya ya chikale ya sigilizi iwandikwe. ");
INSERT INTO ziw_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Togola, chigambe mbwani? Sigilizi ni masa? Bule! Mna Sigilizi initenda miye nimanye masa ni mbwani. Hegu Sigilizi hayalongaga, “Usekutenda na tama na chamnyawo,” Savimanyize kutenda na tama ihiye ni mbwani. ");
INSERT INTO ziw_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Komwiko uwo, masa yapata luhenyo lwa kwimula chila tama ihiye mndani mwangu. Hekwina sigilizi masa ni chintu chibanike. ");
INSERT INTO ziw_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Aho nkongo miye nani mjima umo samanyaga sigilizi naikanigamba usekudamanya vintu vihiye savino, mna umwiko wize wingile, masa yauyuka, ");
INSERT INTO ziw_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","nami niyo nabanika. Umwiko wasinyagwa kunigaila ujima, unigaila file. ");
INSERT INTO ziw_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Masa yapata luhenyo kombokela umwiko uwo, niyo yanidanta nakunikoma. ");
INSERT INTO ziw_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ivyo, Sigilizi yenye ikuka, no mwiko nawo utondowala, uchuma kwa Chohile naho ni wedi. ");
INSERT INTO ziw_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Mna vino nikugamba wedi unigaila file yangu? Bule! Ivyo vili nikugamba, masa chani yatende chindedi ni masa, yajesa chiya ichedi kuhosa file yangu. Ivyo masa, kombokela mwiko, yalagisa vichintile viya yaihise. ");
INSERT INTO ziw_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Chivimanya kugamba Sigilizi ni ya chimuye, mna miye ni ywa chimwili, sitagwa enga mtumwa ywa masa. ");
INSERT INTO ziw_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Sivimanyize nadamanya mbwani, kwaviya sikudamanya chiya hunga, mna nadamanya chiya sikunga. ");
INSERT INTO ziw_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Kwaviya hudamanya sicho hunga, vino nikugamba nazumila kugamba sigilizi ni yedi. ");
INSERT INTO ziw_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ivyo suyo miye hudamanya vino, mna ni udahi wa masa ye mndani mwangu. ");
INSERT INTO ziw_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Sivimanya kugamba hadihali dyedi dyodyose mndani mwangu, kuligana no untu wangu. Kwaviya hata hegu naunga kudamanya dyedi, sikudaha kudidamanya. ");
INSERT INTO ziw_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Sikudamanya dyedi hunga nidamanye, mna nadamanya dihiye sikunga kudidamanya. ");
INSERT INTO ziw_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Elo, uneva nadamanya sikunga kudidamanya, ni kugamba suyo miye hudamanya, mna na amasa ye mndani mwangu. ");
INSERT INTO ziw_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ivyo naviwona kugamba sigilizi yadamanya ndima. Haunga kudamanya dyedi, dihiye nidyo hudamanya. ");
INSERT INTO ziw_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Moyo wangu waibweda sigilizi ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Mna nawona kugamba kuna sigilizi ntuhu ikudamanya ndima mo mwili wangu, sigilizi iyo yahigana naidya ikuzumilwa numanyi wangu. Iyo yanitenda mtumwa ywa sigilizi ya masa ikudamanya ndima mo mwili wangu. ");
INSERT INTO ziw_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Mchiwa miye! Ni yuhi akunga anikombole no umwili uno ukunigala kwe file? ");
INSERT INTO ziw_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Chohile atogolwe, adamanye vino kombokela Zumbe Yesu Kulisito! Elo, miye umanyi wangu watimila sigilizi ya Chohile, mna umwili wangu watimila sigilizi ya masa. ");
INSERT INTO ziw_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ivyo, kwa wadya wose wakwikala kwa kulungana na Kulisito Yesu hawakantilwe. ");
INSERT INTO ziw_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kwaviya, Sigilizi ya Muye ukuchinka ujima kwa kulungana na Kulisito Yesu, inichohola kulaila mwe Sigilizi ya masa na file. ");
INSERT INTO ziw_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mbuli idya Sigilizi ya Musa enkigwe ni Chohile idunduge kuidamanya kwachausa cha usokezi wa chimntu, Chohile kaidamanya, Kwa kumsigila mwanawe mwenye akatenda na mwili wa masa kwachausa cha masa, chani akantile masa mo mwili. ");
INSERT INTO ziw_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Chohile kadamanya ivyo chani viya Sigilizi ikunga viwagile vitimilwe vichinte mndani mwetu suwe chikwikala kuligana na Muye Ukukile, mna suko kuligana na mwili una masa. ");
INSERT INTO ziw_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Wadya wakwikala saviya mwili ukunga, walongozwa ni fanyanyi za mwili. Mna wadya wakwikala saviya Muye Ukukile ukunga, walongozwa ni fanyanyi za Muye. ");
INSERT INTO ziw_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kwaviya fanyanyi zikulongozwa ni mwili una masa zegala file, mna fanyanyi zikulongozwa ni Muye zegala ujima na utondowazi. ");
INSERT INTO ziw_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Elo fanyanyi zikulongozwa ni mwili zahosa wantu wamwihiwe Chohile, kwaviya hawakutimila sigilizi ya Chohile, ichindedi hawakudaha kuitimila. ");
INSERT INTO ziw_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Wadya wakulongozwa numwili hawakudaha kumuwagila Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Nyuwe mna Muye wa Chohile unekala mndani mwenyu hamkulongozwa ni mwili, mna mwalongozwa ni Muye Ukukile. Uneva yoyose hana Muye wa Kulisito suyo mntu ywa Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Mna uneva Kulisito emndani mwenyu, Muye awenkani ujima kwaviya nyuwe mtendwa wedi kulongozi kwa Chohile, hata hegu mili yenyu ibanika kwachausa cha masa. ");
INSERT INTO ziw_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Uneva Muye ywa Chohile amuyuse Yesu ekala mndani mwenyu, ivyo uyo amuyuse Kulisito naijele ujima imili yenyu ikubanika. Nadamanye ivyo kwa Muye wakwe emndani mwenyu. ");
INSERT INTO ziw_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Elo, walukolo weyangu, china ndima, mna suko kwa kwikala saviya mwili ukunga. ");
INSERT INTO ziw_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kwaviya, uneva mkekala saviya mili ikunga, chindedi na mbanike. Mna kwa sila ya Muye mwakoma ntendwa zenyu zihiye, namtende na ujima. ");
INSERT INTO ziw_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Elo wadya wakulongozwa ni Muye wa Chohile ni wana wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kwaviya Muye mwinkigwe ni Chohile haukuwatenda watumwa na kuwatenda mwogohe naho, mna mhokela Muye ukuwatenda wana wa Chohile kwa Muye uwo chetanga, “Aba!” Nuko kugamba “Tate!” ");
INSERT INTO ziw_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Muye wa Chohile aukula nemyuye yetu kugamba suwe chi wana wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Elo, kwaviya suwe chiwanawe, chiwalisi wa Chohile, wa kulisi hamwenga na Kulisito, kwaviya hegu chinatenda hamwenga mwe masulumizo ya Kulisito, nachitende hamwenga mo ukulu wakwe. ");
INSERT INTO ziw_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nafanyanya kugamba masulumizo ya vino haluse sicho chintu yakaliganywa na ukulu udya ukunga ugubulwe kwetu. ");
INSERT INTO ziw_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Elo vyumbe vyoseni vyagoja wana Chohile wagubulwe. ");
INSERT INTO ziw_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kwaviya vyumbe vyoseni vitendwa viwoneke kugamba sicho chintu, siyo kwa kunga vyenye, navitendwa ivyo mwe viya Chohile aungile, akatenda na msuhi, ");
INSERT INTO ziw_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kugamba vyumbe vyenye navyo navichohoilwe kulaila mo utumwa wa kuwola, na kwingila mo ulekeilwa wo ukulu wa wana wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kwaviya chivimanya kugamba kubula vino haluse vyumbe vyoseni vyaugula kwa usungu wa kwefungula. ");
INSERT INTO ziw_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Mna sivyo vyumbe ivyodu vikuugula, suwe naswi china malimbulo ya muye chaugula mndani mwetu, kuno chikagoja Chohile achitende wanawe kukombolwa kwe mili yetu. ");
INSERT INTO ziw_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kwa msuhi uwo suwe chikombolwa, mna msuhi hauhali uneva chachiwona chiya china msuhi nacho. Kwaviya ni yuhi akwikiya msuhi chiya akuwona? ");
INSERT INTO ziw_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Mna uneva china msuhi na chiya hechikuchiwona, nachikigoje kwa kujijimiza. ");
INSERT INTO ziw_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Mweivyo Muye naye achambiza mwe usokezi wetu. Kwaviya hachidahile kulombeza seivyo vikungwa, Muye mwenye achilombezeza kwa Chohile kwa kuugula hekukulongeka. ");
INSERT INTO ziw_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Chohile akuwona mndani mwe myoyo, kazimanya fanyanyi za uyo Muye, kwaviya uyo Muye alombezeza wantu wa Chohile mwe mzungu wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Chivimanya kugamba vintu vyose vyadamanya ndima kwa mbuli zedi kwa wadya wakumunga Chohile, wadya etange wadamanye viya akunga. ");
INSERT INTO ziw_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Wadya Chohile awamanyaga kukongela nkongo, nawo awasentaga watende enga Mwanawe, chani Mwana atende mwelekwa ywa nkongo mwa walukolo walozize. ");
INSERT INTO ziw_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Elo, wadya Chohile asagule iviya nawo etange, wadya etange iviya nawo awatendile wedi kulongozi kwakwe, kawatenda wedi kulongozi kwakwe naho kehanga nawo mo ukulu wakwe. ");
INSERT INTO ziw_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Mwe yano yoseni, chigeze? Uneva Chohile ekwe ntendele yetu, ni yuhi akudaha kuchihiga? Hahali hata yumwenga. ");
INSERT INTO ziw_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Chohile hamng'ang'anile Mwanawe we ichedu, mna kamlavya kwachausa chetu woseni. Uneva kadamanya ivyo, togola, mwafanyanya hachinke vyose bule? ");
INSERT INTO ziw_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ni yuhi akunga awalongeleze wantu asagule Chohile? Hahali Chohile mwenye kawausiza masa! ");
INSERT INTO ziw_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ni yuhi naho akunga awakantile? Hahali, Kulisito Yesu abanikaga na kuyuka naho kekala ko mkono wa kulume wa Chohile achilombezeza! ");
INSERT INTO ziw_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ni yuhi akudaha kuchisente na ungi wa Kulisito? Togola ni nkunto hegu ni chinyulu hegu ni masulumizo hegu ni sala hegu ni sakaza hegu ni nkondo hegu file,? ");
INSERT INTO ziw_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Saviya Mawandiko Yakukile yakugamba, “Kwachausa chako chi mwe nkondo ya file chilo na msi, chatendwa saviya ngoto ikwakuchinjwa.” ");
INSERT INTO ziw_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Mna, mwezimbuli zino zose chijinka wahuda kwa wambizi wa uyo akuchunga! ");
INSERT INTO ziw_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Simanyisa kugamba siyo file hegu ujima, hegu wandima wa kwembingu hegu udahi mtuhu wa kwembingu hegu mbuli za haluse hegu mbuli zikwiza, hegu nguvu, ");
INSERT INTO ziw_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","hegu ye kulanga hegu ye hasi hegu chumbe chituhu chochose, havikudaha kuchisenta na ungi wa Chohile alagise kwetu kwa sila ya Kulisito Yesu Zumbe dyetu. ");
INSERT INTO ziw_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Miye silungana na Kulisito sikudaha kulonga udanti, nalonga ichindedi ichodu. Moyo wangu na Muye Ukukile vyanukwila, ");
INSERT INTO ziw_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","kugamba nina chinyulu chikulu na ulumi heukusila mo moyo wangu, ");
INSERT INTO ziw_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","kwaviya nahajelejeza kugamba niligitwe naho nisentwe na Kulisito kwa ulozo wangu wantu wa kabila dyangu! ");
INSERT INTO ziw_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Awo ni Waizulaeli wantu wadya Chohile kawatenda wanawe, niyo awalagisa ukulu na ndagano, kawenka Sigilizi, wamvikila Chohile viya vikungwa naho wamanya viya alagane nawo. ");
INSERT INTO ziw_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Walaila mwe wadalahala wa Chiyahudi wamanyikise, Kulisito kwa untu wakwe, kalaila mo lukolo lwawo. Chohile akulongoza vyose, atogolwe mazuwa yose! Taile. ");
INSERT INTO ziw_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Sikulonga kugamba viya Chohile alongaga nalavye havidamanyike, kwaviya sawo wantu wose wa Izulaeli ni wantu wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Naho siyo kwaviya ni welekwa wa Bulahimu ni wana wa Chohile. Chohile amgambaga Bulahimu, “Welekwa wako nawalawane na Isaka.” ");
INSERT INTO ziw_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ino ni kugamba wana welekwe chimntu sawo wana wa Chohile, mna wana welekwe kuligana na viya Chohile alongaga nawo wakunga wetangwe wana wakwe. ");
INSERT INTO ziw_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kwaviya Chohile agambaga vino. “Mwe chipindi chiwagile nanuye, Sala naye natende na mwana.” ");
INSERT INTO ziw_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Naho sivyo ivyo du. Lebeka naye apataga wana chilume waidi wata tati yawo yumwenga, mkale ywetu Isaka. ");
INSERT INTO ziw_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Chohile kachintiza lusagulo lwakwe helukwegamila ntendwa mna lwegamila mwitango, kalagisa ayo kwaviya hata hegu hawanati kwelekwa awana awo, na kudaha kusagula yedi hegu yehiye, ");
INSERT INTO ziw_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Chohile amgambilaga Lebeka kugamba, “Mwana ywa nkongo namsankanile mvunawe.” ");
INSERT INTO ziw_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Saviya Mawandiko yakugamba, “Nasimunga Yakobo, mna nasimwihiwa Esau.” ");
INSERT INTO ziw_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Elo, chigambe mbwani, Chohile apagula? Bule. ");
INSERT INTO ziw_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Kwaviya amgambaga Musa, “Nanimfile mbazi mntu yoyose nungile nimfile mbazi, nanimwonele usungu yoyose hunga nimwonele usungu.” ");
INSERT INTO ziw_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ivyo, chila chintu chegamila mbazi za Chohile, siyo kwa viya mntu akunga hegu kudamanya. ");
INSERT INTO ziw_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Kwaviya Mawandiko Yakukile yalonga mwa Falao ywa Misili yagamba, “Sikutenda seuta chani nguvu zangu zimanyike na zina dyangu dizagale mwe isi njima.” ");
INSERT INTO ziw_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ivyo, Chohile afila mbazi mntu akunga na kumtenda mdala ywa moyo mntu akunga. ");
INSERT INTO ziw_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Mna yumwenga mwenyu adaha anuze, “Uneva mbuli nivyo zili, ni mbwani Chohile achei kuchiwona china wihi? Ni yuhi akudaha kuchinda viya Chohile akunga?” ");
INSERT INTO ziw_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Weye wi yuhi? Weye wi mntu du, wadaha vivihi kumhitula Chohile? Nyungu haikudaha kumuza ayumbile, “Ni mbwani ukanumba vino?” ");
INSERT INTO ziw_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mufi ana udahi wa kuudamanya ulongo viya akunga kwa longo dimwenga dya ulongo adaha kumba chiya, chimwenga chitende chantunywa chituhu kwa mbuli za mazwela. ");
INSERT INTO ziw_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Mna uneva kugamba Chohile nakaunga alagise maya yakwe na kutenda udahi wakwe umanyike. Kajijimizisa viya viwagile kugwelwa ni maya vidamanywe kwachausa cha kubalangwa. ");
INSERT INTO ziw_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Naho kaunga agubule ukuka wakwe mkulu, achinkile suwe chikunga mbazi zakwe, achimalanye kale kuhokela ukuka wakwe. ");
INSERT INTO ziw_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Suwe chi wantu chitangwe siyo kulaila kwa Wayahudi awodu mna hata mwe sawo Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Saviya Zumbe alongaga mwe chitabu cha muwoni Hoseya. “Wantu sawo wangu, naniwetange ‘Wantu wangu.’ Si sayungaga, naniitange ‘Hunga.’ ");
INSERT INTO ziw_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Hadya wagambilagwa, ‘Nyuwe hamwi wantu wangu,’ aho nawetangwe wana wa Chohile emjima.” ");
INSERT INTO ziw_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isaya aweilaga Waizulaeli na kugamba. “Hata hegu wantu wa Izulaeli waloza saviya msanga wa mpwani, mna ni wajeche du wakunga wambulwe, ");
INSERT INTO ziw_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","kwaviya Zumbe nasunguze kukantila vichintile mwa wantu wa si yose.” ");
INSERT INTO ziw_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ni saviya Isaya alongaga aho nkongo, “Hegu Zumbe mta udahi hasaga welekwa, nachitenda enga Sodoma, nachitenda enga Gomola.” ");
INSERT INTO ziw_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Elo chigeze, wantu sawo Wayahudi, hawalondile kutendwa wedi kwa Chohile wenye, watendwa wachumile moyo kwa Chohile kwa kuzumila kwawo, ");
INSERT INTO ziw_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Mna Waizulaeli, wendaga wakalonda sigilizi ikunga iwenke wedi wa moyo kwa Chohile, mna hawailondole. ");
INSERT INTO ziw_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ni kwa mbwani hawailondole? Kwaviya nawakasinya ntendwa zawo hawegamile uzumizi. Ivyo nawekobadika mwe yuwe dikukobadisa, ");
INSERT INTO ziw_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","saviya Mawandiko yakulonga. “Kaula, naika yuwe Sayuni dikunga dikobadise wantu, luwe lukunga luwagwise. Mna yoyose akumzumila hajelwe soni.” ");
INSERT INTO ziw_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Walukolo weyangu, naungisa kwa moyo wangu wose chani wantu wangu wambulwe! Naho nawalombezeza kwa Chohile! ");
INSERT INTO ziw_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Nadaha kuukula kugamba wahikiliza kumsankanila Chohile, mna umanyi wawo mwe kumsankanila Chohile hauna chindedi. ");
INSERT INTO ziw_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Hawamanyize viya Chohile akuwatenda wantu watende wedi, mna wajeza kwika sila yawo wenye, ivyo hawatimile sila ya Chohile ya kuwatenda wantu wachume myoyo kulongozi kwakwe. ");
INSERT INTO ziw_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kwaviya Kulisito nuyo udumo we Sigilizi, chani chila na wazumile watendwe wachumile myoyo kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Musa awandikaga vino mwe kutendwa achumile moyo kwa Chohile kwa kutimila Sigilizi. “Yoyose akutimila lagiso dya Sigilizi nekale.” ");
INSERT INTO ziw_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Mna mwe kutendwa achumile moyo kwa Chohile kwa kuzumila Mawandiko yagamba vino, “Usekweuza mo moyo wako, Ni yuhi akunga akwele kwembingu?” Uko ni kumseleza hasi Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Naho usekuza, Ni yuhi akunga asele kwe isi ya wabanike?” Uko ni kumuyusa Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Mawandiko Yakukile yagamba vino. “Ulosi wa Chohile wi hajihi na weye, wi mo mlomo wako na mo moyo wako” Nuwo ulosi wa uzumizi chikulonga. ");
INSERT INTO ziw_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Hegu unalonga kugamba Yesu ni Zumbe na kuzumila kwa moyo kugamba Chohile kamuyusa, nawambulwe. ");
INSERT INTO ziw_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kwaviya kwa moyo mntu azumila na kutenda achume myoyo kulongozi kwa Chohile, naho kwa mlomo mntu akulonga chindedi mwa Kulisito nambulwe. ");
INSERT INTO ziw_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Mawandiko Yakukile yagamba, “Yoyose akumzumila hajelwe soni.” ");
INSERT INTO ziw_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Hahana kwesimana Wayahudi na sawo Wayahudi, Zumbe yumwenga nuyo Zumbe dya wose naho ajimbikisa wose wakumwitanga. ");
INSERT INTO ziw_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Saviya Mawandiko Yakukile yakugamba, “Yoyose akwitanga zina dya Zumbe nambulwe.” ");
INSERT INTO ziw_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Mna nawetange vivihi zina dya Zumbe uneva hawamzumile? Naho nawazumile vivihi uneva hawanati kumwiva? Naho nawamwive vivihi uneva hahana wantu wawagambile? ");
INSERT INTO ziw_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Naho wantu nawawagambile vivihi uneva hawasigilwe? Saviya Mawandiko Yakukile yakugamba, “Kwiza kwa wadya wakulonga Mbuli Yedi kwawagila vidala!” ");
INSERT INTO ziw_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Mna sawo wose wahokele Mbuli Yedi. Isaya mwenye agamba, “Zumbe, ni yuhi azumile ulosi wetu?” ");
INSERT INTO ziw_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Elo, uzumizi walaila kwa kwiva, kwiva nako kwalaila kwa kugambilwa mbuli za Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Mna nauza, ni chindedi kugamba hawawivile ulosi? Bule wawiva, saviya Mawandiko yakugamba. “Izwi dyawo dizagala mwe isi njima, ne milosi yawo ijendesa kubula kwe zintendele ze isi.” ");
INSERT INTO ziw_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Nauza naho, wantu wa Izulaeli hawakombaganye? Nkongo Musa agambaga, “Kwa wantu hewena si naniwatende muwonele finju, si ya wahezi naniwatende mwihiwe.” ");
INSERT INTO ziw_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Isaya alongaga kwa kwekamba, “Silondolwa ni wadya nendile hewekunilonda, selagisa kwa wadya nendile hawakunitanga.” ");
INSERT INTO ziw_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Mna kulanga wantu wa Izulaeli agamba, “Msi mjima siwachumiziza mikono yangu kuwahokela wantu wasi na hewekwiva.” ");
INSERT INTO ziw_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Elo nauza, Chohile alemelaga Wayahudi, wantu wakwe mwenye? Bule! Miye mwenye ni Muizulaeli, mwelekwa ywa Bulahimu, mntu ywa kabila dya Benjamini. ");
INSERT INTO ziw_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Chohile hawalemele wantu wakwe, awasagulaga kukongela nkongo. Mvimanya viya Mawandiko Yakukile yakulonga umo Eliya akawalongeleza Waizulaeli kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Zumbe kaula, wawakoma wawoni wako na kubalanga nchanja zako, ni miye du nisigale naho wajeza kunikoma.” ");
INSERT INTO ziw_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Mna Chohile amhitulaga mbwani? Agambaga, “Seikiya wagosi watuhu magana gana mfungate hewevikile milungu Baali,.” ");
INSERT INTO ziw_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Nivyo vili hata vino haluse, kuna wantu wajeche wasigale wasagulwe ni Chohile kwachausa cha mbazi zakwe. ");
INSERT INTO ziw_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Usaguzi wakwe wigamila mwe mbazi zakwe, siyo mweviya wantu wadamanye. Kwaviya hegu usaguzi wa Chohile nawigamila mwe viya wantu wakudamanya, mbazi zakwe hazatendile mbazi. ");
INSERT INTO ziw_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Haluse togola? Wantu wa Izulaeli hawalondole chiya nawakazungula. Walondole nani kafyo kadodo du asagulaga Chohile, wasigale watendagwa na myoyo midala. ");
INSERT INTO ziw_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Saviya Mawandiko Yakukile yakulonga, “Chohile kaitenda myoyo yawo midala na fanyanyi zawo zigone, kubula mazuwa yano hawakudaha kuwona hegu kwiva.” ");
INSERT INTO ziw_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Daudi naye agamba. “Ngasu zawo nazitende mtego wa kuwagwiza, wagwe na kulihwa kwa masulumizo! ");
INSERT INTO ziw_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Meso yawo yajelwe chiza chani wasekuwona, migongo yawo iveduke kwa masulumizo mazuwa yose.” ");
INSERT INTO ziw_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Elo nauza, Wayahudi weze wekobadike, wagwa wagwele? Bule! Kwaviya wadamanyaga masa, ukombolwa wingila kwa sawo Wayahudi, kuwajela finju Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Uneva masa ya Wayahudi yegala ujimbiko ulozize mwe isi, kuswesa uzumizi kwawo kwigala ujimbiko ulozize kwa sawo Wayahudi. Elo, ni chindedi chihala kugamba kuchintiza kwawo nakwigale ujimbiko ulozize! ");
INSERT INTO ziw_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Haluse nalonga na nyuwe wantu sawo Wayahudi. Kwaviya nanejendeleza kutenda msigilwa kwa sawo Wayahudi, netunya ne ndima yangu. ");
INSERT INTO ziw_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Mafani nadaha kuwatenda wantu wa kwetu, awo Wayahudi, watende na finju, chani nidahe kuwambula wajeche. ");
INSERT INTO ziw_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Uneva walemelagwa, wantu we isi watenda wevana na Chohile. Elo navitende vivihi umo wahokelwe? Wabanike nawauyuke! ");
INSERT INTO ziw_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Uneva kabesu kankongo ko mgate kenkwa Chohile kalenguswa, ivyo mgate mjima nawo nautende ulenguswa. Naho maizi ya mti yenkigwa Chohile, matambi nayo nayatende yakwe. ");
INSERT INTO ziw_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Matambi yamwenga ya mzaituni uhandigwe yakantwa, na matambi ya mzaituni mbago yahasikizwa mwakwe. Nyuwe sawo Wayahudi mwi saviya mzaituni mbago, haluse mna luhenyo lwa ujima chimuye utogile mwa Wayahudi. ");
INSERT INTO ziw_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Elo, msekuwabela wadya wakantigwe enga matambi. Namwefenye vivihi? Mwi matambi du, hamkutoza maizi, maizi yawatozani nyuwe. ");
INSERT INTO ziw_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Mna namgambe, “Matambi yakantwa chani miye nihasikizwe hantu hakwe.” ");
INSERT INTO ziw_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ni chindedi. Nayakantwa kwaviya yaswesa kuzumila, mna weye wachimala kwa kuzumila kwako. Mna usekwefenya, wogohe. ");
INSERT INTO ziw_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Uneva Chohile hawafile mbazi Wayahudi, wekale saviya matambi ya chikolwa, seivyo hawafileni mbazi? ");
INSERT INTO ziw_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Hano chawona viya Chohile emtana naho mkali. Ni mkali kwa wadya wagwele, mna ni mtana kwako, hegu wajendeleza mo utana wakwe. Mna hegu hukuvitenda, weye nawe naukantwe. ");
INSERT INTO ziw_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Naho uneva Wayahudi hawanajendeleze kuleka kuzumila kwawo, nawahasikizwe hadya naweli, kwaviya Chohile avidaha ivyo. ");
INSERT INTO ziw_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Nyuwe sawo Wayahudi chikolwa mwi saviya matambi ya mzaituni mbago ukantigwe niyo wahasikizwa mwe mzaituni uhailwe. Uneva Wayahudi chikolwa ni saviya mzaituni uhandigwe, navitende vihufu Chohile kuhasikiza naho matambi yakantike mwe mti uwo. ");
INSERT INTO ziw_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Walukolo weyangu, naunga mmanye chindedi chino chefisize, mnasekwefenya kugamba mwi wabala vitendese. Kulemela kuzumila kwa Waizulaeli ni kwa mazuwa majeche du, kubula aho ludongo naluchinte lwa sawo Wayahudi wakunga wambwile Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Vino nivyo Izulaeli yose naikombolwe. Saviya Mawandiko yakulonga. “Mkombola neze kulaila Sayuni nause wavu wose mwa welekwa wa Yakobo. ");
INSERT INTO ziw_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Nanike lagano dino nawo umo hausa masa yawo.” ");
INSERT INTO ziw_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kwaviya Wayahudi walemela Mbuli Zedi za Chohile, Wayahudi ni wehi wa Chohile, kwa upati wenyu nyuwe wantu sawo Wayahudi. Mna kwaviya Wayahudi nawasagulwa wachei wambuya wa Chohile kwachausa cha wababa zawo. ");
INSERT INTO ziw_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Kwaviya majeleko na mwitango wa Chohile hayakuhitukila. ");
INSERT INTO ziw_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Aho nkongo nyuwe nahamkumwiva na Chohile, mna haluse Chohile kawafila mbazi kwaviya Wayahudi walekile kumwiva. ");
INSERT INTO ziw_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Elo, kwaviya muwonelwa mbazi, haluse Wayahudi nawo hawakumwiva Chohile, chani nawo haluse wawonelwe mbazi ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kwaviya Chohile kawatenda wantu wose watende wafungwa mo kuhitukila kwawo chani awawonele mbazi. ");
INSERT INTO ziw_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ugoli na ubala na umanyi wa Chohile ni vikulu vitendese! Malamuzi yakwe hayakulongeka, sila zakwe nazo hahali akudaha kuzikombaganya. ");
INSERT INTO ziw_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Mawandiko yagamba. “Ni yuhi akudaha kumlangiliza Zumbe? Ni yuhi akudaha kulafya naye mwe chakudamanya? ");
INSERT INTO ziw_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ni yuhi amwinkaga Chohile chochose chani amlihe?” ");
INSERT INTO ziw_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kwaviya vintu vyose vilaila kwakwe, vyose viyaho kwa udahi wakwe na kwachausa chakwe. Ukulu kwa Chohile mazuwa yose! Taile. ");
INSERT INTO ziw_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Elo, walukolo weyangu, kwaviya Chohile ni mta mbazi zilozize kwetu, nawalombezesani kwa moyo wose. Lavyani mili yenyu kwa Chohile saviya ntambiko ikomelwe Chohile mna ina ujima, ikukile naho ikuwagila. Uno nuwo mviko wa chindedi mkungwa mdamanye. ");
INSERT INTO ziw_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Msekutimila viya wantu we isi ino wakudamanya, mna mlekeni Chohile ahitule fanyanyi zenyu mndani mwenyu. Aho naho mkunga mmanye viya Chohile akunga, chedi chikumwagila Chohile naho chichintile. ");
INSERT INTO ziw_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kulawana na mbazi ninkigwe ni Chohile nawagambilani nyuwe wose, msekwefanyanya kugamba mwi chintu kujinka viya mkuwagilwa kutenda. Fanyanyi zenyu zitende na chihimo cha uzumizi mwinkigwe ni Chohile chila yumwenga. ");
INSERT INTO ziw_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Mili yetu ina vitago vilozize, naho chila chitago china ndima yakwe. ");
INSERT INTO ziw_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Seivyo suwe naswi hata hegu chiloza, suwe chose chi mwili umwenga mwe kulungana na Kulisito, naho chila yumwenga ni chitago cha mnyawe. ");
INSERT INTO ziw_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Elo, chila yumwenga ana jeleko dyakwe kuligana na mbazi Chohile achinkile. Elo mta jeleko dya uwoni ajeseze kuligana na uzumizi wakwe, ");
INSERT INTO ziw_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","enkigwe jeleko dya kusankanila, asankane. Uneva ni jeleko dya kuhinya, ahinye. ");
INSERT INTO ziw_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Uneva kwenkigwa jeleko dya kufunda watuhu, afunde. Mta kumpangila mnyawe ananacho, apangile kwa moyo umwe. Mchimaila achimaile kwa nguvu zose. Mta kufila mbazi, afile mbazi kwa chinyemi. ");
INSERT INTO ziw_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Ungi wenyu utende hewina udanti. Mwihiwe chochose chihiye, mtozese chiya ichedi. ");
INSERT INTO ziw_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Unganisanani saviya walukolo, chila yumwenga amjinke mnyawe kwa kungisa kutunyana. ");
INSERT INTO ziw_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Damanyisani ndima, msekulegela. Msankanileni Zumbe kwa moyo wose. ");
INSERT INTO ziw_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Bwedani msuhi wenyu, jijimizani mwe nkunto, mlombezeni Chohile mazuwa yose. ");
INSERT INTO ziw_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Sangilani wazumizi wenyu mwe viya wakunga, wahokeleni wajeni kwa chisekwesekwe. ");
INSERT INTO ziw_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Wajimbikeni woseni wakuwasulumizani, wajimbikeni mse kuwaligita. ");
INSERT INTO ziw_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Bwedani hamwenga nawo wakubweda, ilani hamwenga na wakwila. ");
INSERT INTO ziw_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Mwivane mgati mwenyu. Msekwefenya, mna nyanyahalani. Msekwewona wata umanyi ulozize. ");
INSERT INTO ziw_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Uneva mntu kawadamanyizani dihiye, msekumvuziza dihiye. Damanyani viya chila yumwenga akufanyanya ni vyedi. ");
INSERT INTO ziw_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Damanyani chila chikudahika mwenyu kutenda na utondowazi kwa chila mntu. ");
INSERT INTO ziw_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Wambuya zangu, msekuliha wihi, mna mumlekeile Chohile. Kwaviya Mawandiko Yakukile yagamba, “Nanilihe, Nanivuze, Zumbe alonga.” ");
INSERT INTO ziw_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Kujinka ayo, Mawandiko Yakukile yagamba. “Uneva wehi wako wana sala, walise, hegu wana nchilu wenke cha kunywa, kwaviya kwa kudamanya ivyo nowajele soni.” ");
INSERT INTO ziw_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Usekuleka wihi ukuhude, mna uhude wihi kwa wedi. ");
INSERT INTO ziw_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Chila mntu aungwa aweve wata udahi kwaviya udahi wowose walaila kwa Chohile, wadya wata udahi wasagulwa ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Yoyose akuhigana na wata udahi ahigana na viya aungile Chohile, naho yoyose akudamanya ivyo egaila nkanto mwenye. ");
INSERT INTO ziw_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Kwaviya wata kulongoza hawakogohwa ni wadya wakudamanya yedi, mna wogoha ni wadya wakudamanya yehiye. Elo, waunga usekumwogoha chilongozi? Damanya yedi, nawo nawakutogole, ");
INSERT INTO ziw_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","kwaviya ni wandima wa Chohile wa kukudamanyiza weye mwenye yedi. Mna hegu ukadamanya wavu, wogohe, kwaviya ni chindedi wana udahi wa kukantila. Ni wandima wa Chohile wakulagisa maya yakwe yatendese wadya wakudamanya wavu. ");
INSERT INTO ziw_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ivyo weveni wata udahi siyo du kwachausa cha kogoha maya yatendese ya Chohile, mna kwaviya mwe myoyo yenyu mvimanya mwaungwa mdamanye chibwani. ");
INSERT INTO ziw_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Nivyo vikuleka mwaliha kodi, kwaviya vilongozi awo wamdamanyiza Chohile naho wadamanya ndima viya wakungwa wadamanye. ");
INSERT INTO ziw_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Haluse waliheni wajeni wenyu, wakungwa kulihwa kodi waliheni kodi, wakungwa kulihwa ushulu waliheni ushulu, watunyeni wakungwa watunywe naho wogoheni wakungwa kogohigwa. ");
INSERT INTO ziw_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Msekutigizwa chochose ni mntu, mna tigizwani ni kungana. Akumunga mnyawe kaitimila sigilizi. ");
INSERT INTO ziw_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Miko yagamba vino, “Usekugonya mntu ywa mwenye, usekukoma, usekubawa, usekunga cha mnyawo” Vyoseni vino, navituhu, vyahanganywa mwe mwiko umwenga, “Munge mnyawo saviya ukweunga mwenye.” ");
INSERT INTO ziw_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Akumunga mnyawe hakudaha kumdamanyiza wihi, elo Sigilizi yachintizwa ni ungi. ");
INSERT INTO ziw_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Mdamanye vino, kwaviya mvimanya kugamba chipindi chibula kwenyu kwinuka mwe zintongo. Kwaviya haluse chipindi cho kwambulwa chihajihi kujinka aho nkongo chazumilaga. ");
INSERT INTO ziw_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Chilo chihajihi na kusila, msi wi haguhi na kwingila. Chileke kudamanya vintu vya chiza, chiguheni viziha vya ulangazi. ");
INSERT INTO ziw_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Chikale vyedi vikuwagilana na msi, siyo kwa kungisa kudya na kunywa, siyo kukolwa hegu uchilanga hegu nkumbizi hegu finju. ");
INSERT INTO ziw_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Mna Zumbe Yesu Kulisito atende suche yenyu, msekutimila naho viya mili yenyu ikunga. ");
INSERT INTO ziw_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Wahokeleni wata uzumizi uhwele, mna msekuhigana mwe viya wakufanyanya kugamba vyawagila. ");
INSERT INTO ziw_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Uzumizi wa wantu watuhu wawaunga kudya chila chintu, mna mntu mta uzumizi uhwele adya mboga za mani du. ");
INSERT INTO ziw_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Wadya wakudya chila chintu wasekubela hawekudya, wadya nawo wakudya mboga izodu wasekukantila wakudya chila chintu, kwaviya Chohile kawazumila. ");
INSERT INTO ziw_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Weye wi yuhi ukujeza kukantila mndima ywa mtuhu? Akachimala hegu akagwa ni mbuli ya Zumbe dyakwe. Na wachimale watogile kwaviya Zumbe adaha kuwachimalisa. ");
INSERT INTO ziw_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Wantu wamwenga wafanyanya kugamba zuwa dimwenga dyajinka mazuwa matuhu, wantu watuhu wafanyanya kugamba mazuwa yoseni ni yamwenga. Chila yumwenga atende na ukanuni mwe viya akufanyanya. ");
INSERT INTO ziw_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Wadya wakutunya zuwa dimwenga, waditunya kwachausa cha Zumbe, nawo wakudya chila chintu, wadya kwa kumtunya Zumbe, kwaviya wamhongeza Chohile. Wadya hewekudya vintu vituhu, wadamanya ivyo kwachausa cha Zumbe, wowo nawo wamhongeza Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Hahali mntu akwikala kwachausa chakwe naho hahali mntu akubanika kwachausa chakwe. ");
INSERT INTO ziw_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Uneva chekala ni kwachausa cha Zumbe, uneva chikabanika ni kwachausa cha Zumbe. Elo, hegu chekala hegu chikabanika, suwe chi wantu wa Zumbe. ");
INSERT INTO ziw_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kwaviya Kulisito kabanika niyo auyuka chani atende Zumbe ywa wajima hamwenga na wabanike. ");
INSERT INTO ziw_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Ni mbwani wamkantila mlukolo ywako? Naho ni mbwani wabela watuhu? Suwe chose nachikantilwe ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Kwaviya Mawandiko Yakukile yagamba. “Saviya nina ujima, alonga Zumbe, chila vindi nadinifikile madi, naho chila lulimi nalulonge kugamba miye ni Chohile.” ");
INSERT INTO ziw_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Ivyo chila yumwenga mwetu nalavyanye mbuli zakwe mwenye mwa meso ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Elo, chisekukantilana, mna chisekudamanya chochose na chimtende mlukolo akobadike na kugwela mwe masa. ");
INSERT INTO ziw_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Kwaviya silungana na Zumbe Yesu, nina chindedi kugamba hahana chintu chochose chihiye viya chumbigwe, mna mntu akafanyanya kugamba chintu chimwenga chiha, kwakwe chatenda chiha. ");
INSERT INTO ziw_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Uneva wamjela chihovu mlukolo ywako kwachausa cha nkande ukudya, ivyo weye humuli mwe ungi. Usekutenda nkande ukudya kumwaza mntu yudya Kulisito abanikaga kwachausa chakwe! ");
INSERT INTO ziw_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Elo, msekuzumila chintu mkuchiwona ni chedi kwenyu chihulutwe. ");
INSERT INTO ziw_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Kwaviya Useuta wa Chohile siyo mbuli za kudya na kunywa, mna ni kudamanya wedi, utondowazi na mbwedo ukwigalwa ni Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Wantu wakumsankanila Kulisito mwe sila ino, wamwelelesa Chohile naho awagilwa ni watuhu. ");
INSERT INTO ziw_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Ivyo, mazuwa yose chisinyise mbuli zikwigala utondowazi na zikuchambiza kuzengana. ");
INSERT INTO ziw_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Elo, usekubalanga ndima ya Chohile kwachausa cha nkande. Chila chintu chilenguka, mna viha kumtenda mntu yoyose agwe mwe wavu kwachausa cha nkande. ");
INSERT INTO ziw_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ni vyedi kuleka kudya nyama, kunywa divai, hegu kudamanya chochose chikudaha kumkobadisa mlukolo ywako agwe. ");
INSERT INTO ziw_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Tozesa chiya ukuzumila mgati mwako na Chohile. Ajimbikwe ni yudya mo kufanyanya dyo kudamanya hakukantilwa nu moyo wakwe viya ukunga. ");
INSERT INTO ziw_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Mna mta nkama mwe nkande akudya, akantilwa uneva akadya, kwaviya icho akudamanya hakukizumila. Chochose ukudamanya hehena uzumizi ni masa. ");
INSERT INTO ziw_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Suwe chitogile mo uzumizi chaungwa chiwambize mwe zinkunto zawo wadya wahwele mo uzumizi, chisekweunga wenye. ");
INSERT INTO ziw_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Mna chila yumwenga ywetu amunge mnyawe kwa yedi chani amzenge mo uzumizi. ");
INSERT INTO ziw_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kwaviya Kulisito heungile mwenye. Mna, saviya mawandiko yakugamba, “Mahuluto yose wakuhulute weye yanibwila miye.” ");
INSERT INTO ziw_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Kwaviya chila chintu chiwandikwe mwe chikale chawadikagwa chani chichihinye suwe kuligana na ugoji na ujelwa moyo chikwinkwa na Mawandiko Yakukile chitende na msuhi. ");
INSERT INTO ziw_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Chohile akulavya ugoji na ujela moyo, awenkeni muye wa umwe mgati mwenyu umo mkamtimila Kulisito Yesu, ");
INSERT INTO ziw_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","chani wose hamwenga mumtunye Chohile na Ise dya Zumbe dyetu Yesu Kulisito kwa izwi dimwenga. ");
INSERT INTO ziw_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Elo, hokelanani kwachausa cha ukulu wa Chohile saviya Kulisito awahokeleni. ");
INSERT INTO ziw_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Kwaviya nawagambilani Kulisito kawasankanila Wayahudi chani alagise uchindedi wa Chohile na kuchintiza ndagano na wababa zetu, ");
INSERT INTO ziw_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Chani sawo Wayahudi nawo wadahe kumtunya Chohile kwachausa cha mbazi zakwe. Saviya mawandiko yakugamba. “Ivyo nahutogole mwa sawo Wayahudi, nanicheme kutogola zina dyako.” ");
INSERT INTO ziw_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Naho yagamba, “Elelwani nyuwe sawo Wayahudi hamwenga na wantu wa Chohile!” ");
INSERT INTO ziw_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Naho, “Mtogoleni Zumbe, sawo Wayahudi wose, mtogoleni, wantu wose!” ");
INSERT INTO ziw_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Vituhu Isaya agamba, “Nalaile mwelekwa mo lukolo lwa Yese, neze alongoze sawo Wayahudi, uyo natende msuhi wawo.” ");
INSERT INTO ziw_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Elo, Chohile sina dya msuhi, awabwedezese na kuwatondowaza kuligana na kuzumila kwenyu, msuhi wenyu ujenyele kwa nguvu za Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Walukolo weyangu, nina chindedi mwenyu kugamba mwi wedi vitendese, mna umanyi wose, naho mwadaha kuhinyana. ");
INSERT INTO ziw_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Mna mwe baluwa ino siwawandikilani hatenda sina woga, niwakumbuseni mwe mbuli zimwenga. Sidamanya ivyo kwachausa cha mbazi ninkigwe ni Chohile, ");
INSERT INTO ziw_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ya kutenda mndima ywa Kulisito Yesu kwa sawo Wayahudi. Nasankanila ndima ya ulavyantambiko kulonga Mbuli Yedi ya Chohile, chani sawo Wayahudi watende enga lavyo dizumilwe ni Chohile, lavyo dilenguswe ni Muye Ukukile. ");
INSERT INTO ziw_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Elo, kwa kulungana na Kulisito Yesu, nadaha kwefenyeza ndima yangu kwachausa cha Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Sikujeza kulonga chintu chituhu chochose mna chiya du adamanye Kulisito Yesu kugwila mwangu chani sawo Wayahudi wamwive Chohile. Kadamanya vino kwa ulosi na ntendwa, ");
INSERT INTO ziw_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","kwa udahi wa mpituko na vilagiso, na kwa nguvu za Muye wa Chohile. Na kwakutamba sila yose kulaila Yelusalemu kubula Iluliko, silonga vichintile Mbuli Yedi ya Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Mazuwa yose nahaungisa kulonga Mbuli Yedi hohose hadya zina dya Kulisito hedinati kwivika, ninasekuzenga mlanga mwe msingi wa mntu mtuhu. ");
INSERT INTO ziw_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Saviya Mawandiko Yakukile yakulonga. “Wantu wose hawagambilwe mbuli zakwe nawawone, na wadya hewevile nawakombaganye.” ");
INSERT INTO ziw_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Kwaivyo sichindwa kubula kwenyu nkanana zilozize. ");
INSERT INTO ziw_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Mna kwaviya haluse sibinda ndima yangu ntendele zino, naho kwaviya kwa mihilimo ilozize nahaunga kubula kwenyu, ");
INSERT INTO ziw_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","nina msuhi wa kudamanya ivyo haluse. Nahaunga niwawone umo ni mwe sila haita Spaniya, nakwambizwa ni nyuwe kubula uko, umo hajika kubweda kutenda hamwenga hadodo na nyuwe. ");
INSERT INTO ziw_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Mna kwa vino haluse naita Yelusalemu kusankanila wantu wa Chohile uko. ");
INSERT INTO ziw_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Kwaviya mabunga ya wantu wakumzumila Kulisito uko Makedoniya na Akaya waviwona wachisanye hela kuwambiza wantu wa Chohile wachiwa uko Yelusalemu. ");
INSERT INTO ziw_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Wowo wenye waviwona wadamanye ivyo, mna ichindedi waungwa wadamanye iyo ni mbuli yawo. Kwaviya, uneva sawo Wayahudi watenda hamwenga mwe ujimbiko wa chimuye wa Wayahudi, nawo wawasankanile Wayahudi mwe mbuli za chimwili. ");
INSERT INTO ziw_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Umo habinda indima ino na kuwenka hela zose wachisanyizwe, naniwatalamkileni umo ni mwe sila kubula Spaniya. ");
INSERT INTO ziw_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Sivimanya kugamba umo heza kwenyu naniwegaile ujimbiko ulozize wa Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Walukolo wangu, nawalombezesani kwachausa cha Zumbe dyetu Yesu Kulisito na kwachausa cha ungi wa Muye wa Chohile, lunganani na miye kwa kunilombezeza kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Lombezani nilawe mpeho mwa wadya hewezumile we Yudeya. Ndima yangu nayo uko Yelusalemu izumilwe ni wantu wa Chohile weyuko. ");
INSERT INTO ziw_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Ivyo, Chohile akaunga, nanidahe kwiza kwenyu kwa moyo ubwedile, hahumule hamwenga na nyuwe. ");
INSERT INTO ziw_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Chohile, sina dya utondowazi, atende hamwenga na nyuwe nyose. Taile. ");
INSERT INTO ziw_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Naunga nilonge kwenyu kugamba lumbu dyetu Fibi ni mntu ywedi, mndima ywa bunga dya wazumile uko Kenikileya. ");
INSERT INTO ziw_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Mhokeleni kwa zina dya Zumbe saviya wantu wa Chohile wakungwa kutenda. Mwambizeni kwa chochose akunga kwenyu, kwaviya katenda mbuya mtana kwa wantu walozize kwangu. ");
INSERT INTO ziw_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Ndamsa zangu ziwabwile Pisika na Akila, wandima weyangu mwe ndima ya Kulisito Yesu, ");
INSERT INTO ziw_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","wehosa ujima wawo kwachausa changu. Nawahongeza vidala, suyo miye du, mna hata kulaila kwa sawo wayahudi wa mabunga ya wazumile. ");
INSERT INTO ziw_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Ndamsa naho kwa wazumile wakudugana mwe nyumba yawo. Ndamsa kwa mbuyangu vidala Epaineto, wankongo mwe si ya Asiya kumzumila Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Ndamsa kwa Maliyamu, awadamanyanyize ndima vidala. ");
INSERT INTO ziw_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Ndamsa kwa walukolo mwa Kulisito Anduloniko na Yuniya, wambuya wa Chiyahudi wendaga na miye mwe chifungo, wamanyika vyedi mwa wasigilwa, naho watendaga Wakulisito umo miye sinati. ");
INSERT INTO ziw_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Ndamsa zangu kwa Ampliato, mbuyangu vidala mwe kulungana na Zumbe. ");
INSERT INTO ziw_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Ndamsa naho kwa Alubano, mndima mnyangu mwe ndima ya Kulisito, na kwa Sitakisi, mbuyangu vidala. ");
INSERT INTO ziw_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Ndamsa kwa Apele, uchindedi wakwe kwa Kulisito uwagila. Ndamsa kwa walukolo wa Alisitobula. ");
INSERT INTO ziw_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ndamsa kwa Helodioni, mbuya ywa Chiyahudi, na walukolo wa Nalikiso wamzumile Zumbe. ");
INSERT INTO ziw_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ndamsa zangu kwa Tilifaina na Tilifosa, wakudamanya ndima mwe ndima ya Zumbe, na kwa mbuyangu Pefusisi, amdamanyizise ndima Zumbe. ");
INSERT INTO ziw_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Nilamsiza Lufo asagulwe kudamanya ndima ya Zumbe, na kwa mami yakwe, yudya nami humtunya saviya mnala. ");
INSERT INTO ziw_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Ndamsa zangu kwa Asinikilito, Filegoni, Helime, Patiloba, Helima, na walukolo woseni we hamwenga nawo. ");
INSERT INTO ziw_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Ndamsa kwa Filologo na Yuliya, Neleya na lumbudye na Olimpa na wantu woseni wa Chohile wehamwenga nawo. ");
INSERT INTO ziw_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Lamsanani kwa kilagiso cha kungana. Ndamsa kwenyu zikulaila kwa mabunga ya wantu wamzumile Kulisito. ");
INSERT INTO ziw_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Walukolo weyangu nawalombezesani. Wasinyiseni wakubalanga umwenga wenyu na kusa uzumizi wa wantu na kuhiga mahinyo mhinyigwe. Kwenegeni na wantu awo! ");
INSERT INTO ziw_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Kwaviya wantu wakudamanya mbuli saizo hawakumsankanila Kulisito Zumbe dyetu, mna wadamanya zawo wenye. Kwa losi zawo ntana na kwa ulongi wawo wakuwadanta waza myoyo ya wantu wachumile. ");
INSERT INTO ziw_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Chila yumwenga kamanya ivyo mkumwiva Zumbe, ivyo nelelwa kwachausa chenyu. Mna naunga mtende na umanyi mdamanye yedi mwe mbuli zedi, mna hemwina masa mwe mbuli zihiye. ");
INSERT INTO ziw_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Chohile naye sina dyetu dya utondowazi hakawe kumhonda Shetani hasi mwe viga vyenyu. Mbazi za Zumbe dyetu Yesu kulisito zitende na nyuwe. ");
INSERT INTO ziw_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoseo, mndima mnyangu, awalamsani, Lukiyo na Yasoni na Sosipateli weyangu wa Chiyahudi nawo wawalamsani. ");
INSERT INTO ziw_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Miye, Telitilo, mta kuwandika ibaluwa ino, nawalamsa kwa zina dya Zumbe. ");
INSERT INTO ziw_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayo mkaya ywangu, hamwenga na bunga dya wazumizi wose wakudugana kwakwe, wawalamsani, Elasito, mchimaila ywa hela zo mzi mkulu, hamwenga na mlukolo ywetu Kwato wawalamsani. ");
INSERT INTO ziw_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Mbazi za Zumbe dyetu Yesu Kulisito zitende na nyuwe. Taile ");
INSERT INTO ziw_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Elo haluse chimhongeze Chohile! Uyo adaha kuwatogezani mwe idya Mbuli Yedi nawagambilaga mwa Yesu Kulisito, mwe chinyele chiya chigubulwe naho chafisagwa kwa mihilimo ilozize ijinkile. ");
INSERT INTO ziw_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Mna, haluse ichindedi icho chigubulwa kwa sila ya mawandiko ya wawoni, na kwa mwiko wa Chohile mta ujima mazuwa yose umanyika mwe si zose chani wose wazumile na kwiva. ");
INSERT INTO ziw_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Kwakwe Chohile mta umanyi wedi ichedu. Ukulu una uyo kwa sila ya Yesu Kulisito, mazuwa yose! Taile.");
INSERT INTO ziw_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Miye Paolo, msigilwa ywa Kulisito Yesu uyo Chohile aungile kwitanga, na mlukolo ywetu Sositeni, ");
INSERT INTO ziw_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Chawawandikilani nyuwe bunga dikumzumila Chohile mwiyuko komzi wa Kolinto. Nyuwe wadya mlenguswe kwa sila ya kulungana na Kulisito Yesu na mwitangwe ni Chohile mtende wantu wakwe seivyo kwa wose chila hantu hohose wakumvikila Zumbe dyetu Yesu Kulisito uyo Zumbe ywawo na ywetu, ");
INSERT INTO ziw_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Nawaungilani wedi wa Chohile na utondowazi ukulaila kwa Chohile Tati yetu na Zumbe dyetu Yesu Kulisito. ");
INSERT INTO ziw_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Namhongeza Chohile ywangu mazuwa yoseni kwachausa chenyu kwaviya mwinkigwa wedi wa Chohile kwa sila ya Kulisito Yesu. ");
INSERT INTO ziw_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Kwaviya mlungana na Kulisito mhokela vintu vyose vyedi vilozize mwe umanyi wose na udahi wose wa kulonga, ");
INSERT INTO ziw_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","kwaviya ulosi mwa Kulisito ukulwa mndani mwenyu, ");
INSERT INTO ziw_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","naho hamhungukilwe ni ntunyo yoyose ikulaila kwa Muye Ukukile, mkagojesa kwa nkwina kuyuswa kwakwe Zumbe dyetu Yesu Kulisito. ");
INSERT INTO ziw_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Uyo nawatogezeni nyuwe kubula ko uhelo, mtende hamwina lema mwe idizuwa idyo dya Zumbe dyetu Yesu Kulisito. ");
INSERT INTO ziw_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Chohile ni mkanuni, uyo awetangeni nyuwe mwingile mwe ndala hamwenga na Mwanawe, Yesu Kulisito Zumbe dyetu. ");
INSERT INTO ziw_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Walukolo mwa Kulisito, nawailani kwa zina dya Zumbe dyetu Yesu Kulisito, kugamba ivanani nyoseni kwa chila mbuli mkulonga. Msekwepagula, mtende na ulosi umwenga na fanyanyi za chalumwe. ");
INSERT INTO ziw_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Walukolo weyangu, mbuli nigambilwe ni wantu wa kaya ya Kiloye, zalagisa pwilili kugamba mna nkumbizi mgati mwenyu. ");
INSERT INTO ziw_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Icho hulonga ni chino, kwaviya chila yumwenga alonga, “Miye namtimila Paolo” mtuhu, “Miye namtimila Apolo”, mtuhu, “Miye namtimila Petulo”, mtuhu, “Miye namtimila Kulisito.” ");
INSERT INTO ziw_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Togola, Kulisito kepanga? Togolani, Paolo nuyo asulumizwe mo msalaba kwachausa chenyu? Hegu togolani, Nambatizwa mtende wanampina wa Paolo? ");
INSERT INTO ziw_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Namhongeza Chohile kugamba simbatize yoyose mna Kilisipo na Gayo. ");
INSERT INTO ziw_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Elo hahali akudaha kulonga kugamba kabatizwa kwa zina dyangu. ");
INSERT INTO ziw_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Heye, naho nabatizaga wantu we kaya ya Sitefana, mna kujinka awo sikufanyanya hegu nabatizaga mntu mtuhu yoyose. ");
INSERT INTO ziw_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kulisito hanisigile nibatize, mna kuwagambila Mbuli Yedi ya Kulisito, naho siyo kwa milosi ya chimtu, chani nguvu ya file ya Kulisito mo msalaba isekuswa. ");
INSERT INTO ziw_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Kwaviya ulosi wa file ya Kulisito mo msalaba ni uhezi kwa wadya wakwaga, mna kwa suwe chikuhonywa ni nguvu ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Kwaviya iwandikwa, “Nanibalange ubala wawo wata ubala, na umanyi wawo wata umanyi naniulemele.” ");
INSERT INTO ziw_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Uneva nivyo vili, nauza, ekuhi mta ubala? Ekuhi mhinya Sigilizi za Musa? Ekuhi mhiga mbuli ywa mazuwa yano? Togola, Chohile hatendile umanyi wa wantu we isi ni uhezi? ");
INSERT INTO ziw_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Kwaviya mwe umanyi wa Chohile, wantu we isi hawakudaha kummanya Chohile kwa sila ya wowo wenye. Mna Chohile kaunga kuwahonya wadya wakumzumila kwa sila ya chiya wata ubala wakuchiwona ni uhezi, uhezi wa udya ulosi ukulongwa. ");
INSERT INTO ziw_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Wayahudi waunga wawone mpituko, Wagiliki walonda ubala. ");
INSERT INTO ziw_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Mna suwe, chamlonga Kulisito asulumizwe. Kwa Wayahudi mbuli ino ni nkobadiko, kwa wantu wa isi ntuhu ni uhezi, ");
INSERT INTO ziw_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","mna kwa wadya wetangwe, Wayahudi kwa Wagiliki, Kulisito ni nguvu ya Chohile na umanyi wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Kwaviya chikuwoneka ni uhezi wa Chohile, chawagila kujinka ubala wa wantu, naho chikuwoneka chisokele kwa Chohile, china nguvu kujinka nguvu ya wantu. ");
INSERT INTO ziw_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Walukolo weyangu, kumbukani umo mwitangwe, kugamba, walozize wenyu nahewena ubala hata kwa fanyanyi za chiuntu, walozize nahewena nguvu hegu wantu wa chizumbe. ");
INSERT INTO ziw_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Mna Chohile kayasagula yadya isi ikuyawona ni uhezi, chani awajele soni wata ubala, naho kayasagula yadya isi ikuyawona yahwa, chani awajele soni wata nguvu. ");
INSERT INTO ziw_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Chohile kayasagula yadya kwa fanyanyi za isi ni mbuli zihwele naho zikubelwa, mbuli izo nahezikuli, chani kwa izo azuse ziya kwa fanyanyi za wantu wakuwona ni mbuli zedi. ");
INSERT INTO ziw_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Chani hasekutenda na mntu yoyose akudaha kweduvya ha meso ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Mna Chohile kawalunganyani nyuwe na Kulisito Yesu, naho Chohile kamtenda Kulisito atende umanyi. Kwa sila ya Kulisito chiwoneka wedi kulongozi kwa Chohile na kukombolwa. ");
INSERT INTO ziw_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Elo, saviya mawandiko yakukile yakugamba, “Mta kweduvya, eduvye mwe ndima ya Zumbe.” ");
INSERT INTO ziw_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Walukolo weyangu, umo nezaga kwenyu sizile kuwagambila ulosi wa Chohile wefisize kwa milongele ya pwilili, hegu kwa ubala wa chimtu. ");
INSERT INTO ziw_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Umo nendaga kwenyu samanyaga chochose mna kummanya Yesu Kulisito, heye, Kulisito yudya atungikwe mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Umo nendaga kwenyu mwili wangu nauhwa, naho nazingiza vidala kwa luchenyenta. ");
INSERT INTO ziw_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Ulosi wangu na kulonga kwangu sivilavize kwa milosi ya ubala ikutamila, mna kwa ulagiso wa nguvu ikulaila kwa Muye wa Chohile, ");
INSERT INTO ziw_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","chani kuzumila kwenyu kusekwegamila ubala wa mntu mna kwegamile nguvu ya Chohile. ");
INSERT INTO ziw_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Mna suwe chasimwila ubala kwa wadya watogile mwe uzumizi, mna siyo ubala we isi ino, hegu ya vilongozi we isi ino mwe wadya wa kwaga. ");
INSERT INTO ziw_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Mna chalonga umanyi wefisize wa Chohile, ubala wefisize Chohile aikaga mo moyo wakwe kudamanya kukongela isi hainati kumbwa, kwachausa cha ukulu wetu. ");
INSERT INTO ziw_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Hahali chilongozi hata yumwenga mwe isi ino aimanyize. Kwaviya hegu waimanyize, hawamtungike Zumbe ywa ukulu mo msalaba. ");
INSERT INTO ziw_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Mna ni saviya viwandikwe, “Mbuli ziya ziso haziwonaga hegu gutwi kuziva, mbuli ziya mntu hafanyanyaga mo moyo, mbuli Chohile awaikiye wadya wakumunga.” ");
INSERT INTO ziw_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Mna Chohile kachigubwila izimbuli izo kwa Muye wakwe. Kwaviya Muye Ukukile azuza chila chintu hata mbuli zimndani vidala mwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Kwaviya ni yuhi akudaha kumanya mbuli za mndani za mntu uneva siyo Muye wakwe umntu uyo? Mweivyo, hahana amanyize mbuli za Chohile mna Muye wa Chohile. ");
INSERT INTO ziw_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Hachihokele muye wa wantu we isi ino mna chihokela Muye ulaile kwa Chohile, chani chimanye mbuli chinkigwe bule du ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Elo suwe hachikulonga ulosi chihinyigwe kwa umanyi wa chimntu, mna kwa milosi chihinyigwe ni Muye, chahinya chindedi cha chimuye mbuli za chimuye. ");
INSERT INTO ziw_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Mntu suyo ywa chimuye hakuzumila mbuli za Muye wa Chohile. Mbuli izo kwa mntu ywa mazwela ni uhezi, naho hakudaha kuzimanya kwaviya zamanyika kwa wambizi wa Muye. ");
INSERT INTO ziw_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Mna mntu mta Muye wa Chohile amanya yoseni, naho yeye hakumanywa ni mntu. ");
INSERT INTO ziw_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Saviya viwandikwe, “Niyuhi akumanya fanyanyi za Zumbe? Niyuhi akudaha kumtenda amanye?” Mna suwe china fanyanyi za Kulisito. ");
INSERT INTO ziw_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Walukolo weyangu, miye sidahile kulonga na nyuwe saviya na wantu wata Muye wa Chohile, mna nalonga na nyuwe wantu we isi ino, saviya wana wachembe mwe kumzumila Kulisito. ");
INSERT INTO ziw_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Siwanywesani mele, siwalisizeni nkande itogile, kwaviya nahamnati kuidaha. Hata vino haluse hamkuidaha, ");
INSERT INTO ziw_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","kwaviya nyuwe mchei mwekala mwe isi. Uneva wantu mchei na finju na nkumbizi mwenyu, vino havikulagisa kugamba mwi wantu wa chimwili, mkwikala mwe viya isi ikunga? ");
INSERT INTO ziw_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Kwaviya mntu yumwenga akagamba, “Miye namtimila Paolo”, mtuhu agamba, “Miye namtimila Apolo”, togolani, iyo haikulagisa kugamba mwekala saviya wantu we isi ino? ");
INSERT INTO ziw_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Elo, Apolo ni yuhi? Na Paolo ni yuhi? Suwe chiwandima chiwalekileni mzumile. Chila yumwenga ywetu adamanya ndima saviya enkigwe ni Zumbe. ");
INSERT INTO ziw_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Miye nahandaga mbeyu, Apolo kaijeila mazi, mna aitendile ihote niyo yakula ni Chohile. ");
INSERT INTO ziw_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Elo, akuihanda suyo chintu, hegu akuijeila mazi, mna ichintu ni Chohile akuileka ihote na kukula. ");
INSERT INTO ziw_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Yudya ahandile na yudya ajeile mazi wose ni wamwe, Chohile namtunye chila yumwenga kuligana na viya adamanye mwenye. ");
INSERT INTO ziw_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Kwaviya suwe chiwandima wa Chohile, chikudamanya ndima hamwenga, nyuwe mwinkonde yakwe mwizengo dya Chohile. ");
INSERT INTO ziw_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Kwa wedi wa Chohile anihokele, sihuda saviya mzesi mta ubala, nasizenga msingi udya mlanga mwakwe mntu mtuhu azenga. Mna chila mntu asinyise ivyo akuzenga mlanga mwakwe. ");
INSERT INTO ziw_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Kwaviya hahali mntu akudaha kuzenga msingi mtuhu akaleka udya uzengigwe kale, kugamba, Yesu Kulisito. ");
INSERT INTO ziw_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Uneva mntu yoyose mo msingi uwo azenga kwa zahabu, hegu hela hegu mayuwe ya yombe kulu hegu miti hegu mani hegu nyasi, ");
INSERT INTO ziw_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ndima yakwe nailagiswe viya ili, kwaviya Msi naulangaze. Naigubulwe mwe moto, umoto nawo nauhime wedi wa chila ndima ya mntu. ");
INSERT INTO ziw_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Uneva ndima ya mntu yoyose azengile mo msingi uwo niyo yatoga mo moto, umzesi uyo natunywe. ");
INSERT INTO ziw_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Uneva ndima iyo inasila moto, natende kaza ntunyo yakwe, mna uyo mwenye nahonywe, saviya ahonyigwe mwe nkondo yo moto. ");
INSERT INTO ziw_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Togolani, hammanyize kugamba nyuwe mwi nyumba ya kumvikila Chohile, naho kugamba Muye wa Chohile wekala mndani mwenyu? ");
INSERT INTO ziw_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Elo, uneva mntu anabalanga nyumba ya kumvikila Chohile, Chohile nambalange, kwaviya nyumba ya kumvikila Chohile ikuka, naho nyuwe mwi nyumba iyo ya kumvikila Chohile. ");
INSERT INTO ziw_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Msekwedanta! Mntu yoyose mgati mwenyu akwewona ni mta umanyi mwe isi, viwagila atende hezi chani atende na umanyi wa chindedi. ");
INSERT INTO ziw_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Kwaviya, umanyi wa wantu we isi ni uhezi kulongozi kwa Chohile. Saviya viwandikwe, “Chohile awagwiza wata umanyi mo ubala wawo.” ");
INSERT INTO ziw_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Naho, “Zumbe kamanya kugamba fanyanyi za wata umanyi sicho chintu.” ");
INSERT INTO ziw_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Elo, mntu asekweduvila wantu. Kwaviya chila chintu ni chenyu, ");
INSERT INTO ziw_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Paolo hegu Apolo hegu Kefa, isi hegu ujima hegu file, viya viyaho haluse hegu viya navize, vyoseni ni vyenyu. ");
INSERT INTO ziw_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Mna nyuwe mwi wantu wa Kulisito, Kulisito naye ni ywa Chohile. ");
INSERT INTO ziw_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Mntu achiwone suwe kugamba chiwandima wa Kulisito, naho wachimaila wa mbuli zefisize za Chohile. ");
INSERT INTO ziw_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Aho ikungwa mwa wachimaila ni kutenda wakanuni. ");
INSERT INTO ziw_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Mna kwangu miye ni mbuli ndodo vidala kukantilwa ni nyuwe, mna kwa kukantilwa kwa vitala vya wantu, hegu kwekantila mwenye. ");
INSERT INTO ziw_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Moyo wangu haukunilongela kwa mbuli yoyose, mna iyo haikulagisa kugamba sina cha kulahwa. Zumbe nuyo akunikantila. ");
INSERT INTO ziw_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Elo, msekukantila mbuli chipindi chakwe hachinati kubula aho akwizila Zumbe. Uyo na alangazize yefisize mwe chiza, na kulaviza kweise mbuli za myoyo. Aho naho chila mntu akunga ahokele ntogozi yakwe kulaila kwa Chohile. ");
INSERT INTO ziw_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Walukolo, sidamanya mbuli zino kwangu mwenye na Apolo kwachausa chenyu, chani kwa mliganyo wetu mhine ulosi wagaze, “Kaulisani yawandikwe.” Chani mntu yoyose asekwemwefenyeza mntu yumwenga na kumbela mtuhu. ");
INSERT INTO ziw_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Niyuhi akutendile mkulu kujinka mtuhu? Una chihi hwihokele? Mna uneva hegu kuhokela, ni mbwani ukweduvya saviya kugamba huhokele? ");
INSERT INTO ziw_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Mwigutakale! Mtendakale wagoli! Mtenda Mazumbe suwe hechimuli! Nivyedi, mwatendile maseuta, chani suwe naswi chitende maseuta hamwenga na nyuwe. ");
INSERT INTO ziw_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Nafanyanya kugamba Chohile kachitenda suwe wasigilwa wantu wa kuzigila, saviya wantu wakantilwe file, kwaviya chitenda chintu cha kwehelwa mwe isi njima, kwa wandima wa kwembingu na wantu. ");
INSERT INTO ziw_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Suwe chiwahezi kwachausa cha Kulisito, mna nyuwe mna ubala mwa Kulisito! Suwe chiwahwele, mna nyuwe mna nguvu. Nyuwe mwatunywa, mna suwe chabelwa. ");
INSERT INTO ziw_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Hata vino haluse, suwe china sala na nchilu, hachina cha kuvala, chatoigwa maihi, naho hachina hekwikala. ");
INSERT INTO ziw_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Naho changadikisa na kudamanya ndima kwa mikono yetu wenye. Chikahulutwa, chajimbika, chika sulumizwa, chajijimiza, ");
INSERT INTO ziw_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","chikaligitwa, chahitula vyedi. Chitendwa saviya uzavu we isi, kwa chila mntu suwe chi ntaka. ");
INSERT INTO ziw_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Sikuwandika mbuli zino chani niwajeleni soni, mna kuwafunda saviya 