﻿USE sofia;
DROP TABLE IF EXISTS sofia.zin_vpl;
CREATE TABLE zin_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zin_vpl WRITE;
INSERT INTO zin_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aga nigo amazíina go olugaanda lwa Yeézu Kristu. Yeézu Kristu akalugiilila omu luzáalo lwa Daudi óogwo akaba naalugiílila omu lugaanda lwa Ibrahímu. ");
INSERT INTO zin_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahímu akazaala Izáaka, Izáaka yaázáala Yakobo, Yakobo yaázáala Yuda na badugu boómwe. ");
INSERT INTO zin_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda yaázáala Peréesi na Zera hali Tamari, Peréesi yaázáala Hezeróoni, Hezeróoni yaázáala Aramu, ");
INSERT INTO zin_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramu yaázáala Aminadabu, Aminadabu yaázáala Nashoni, Nashoni yaázáala Salmoni, ");
INSERT INTO zin_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmoni yaázáala Boazi hali Rahabu, Boazi yaázáala Obedi hali Ruthu, Obedi yaázáala Yese, ");
INSERT INTO zin_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na Yese yaázáala omukáma Daudi. Daudi yaázáala Selemani kuluga aha mukázi ogwo akaba ali muka Uria, ");
INSERT INTO zin_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani yaázáala Rehoboamu, Rehoboamu yaázáala Abiya, Abiya yaázáala Asa, ");
INSERT INTO zin_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa yaázáala Yehoshafati, Yehoshafati yaázáala Yoramu, Yoramu yaázáala Uzia, ");
INSERT INTO zin_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia yaázáala Yoatamu, Yoatamu yaázáala Ahazi, Ahazi yaázáala Ezekia, ");
INSERT INTO zin_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekia yaázáala Manase, Manase yaázáala Amoni, Amoni yaázáala Yosia, ");
INSERT INTO zin_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","na Yosia yaázáala Yekonia na badugu boómwe, obuchilo óobwo Abaiziraeli bakakwáatwa enkwáate babe abahálila omu nsi ya Babéeli. ");
INSERT INTO zin_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Abaiziraeli kábaabeele baáfulukiile okwo omu nsi ya Babéeli, Yekonia yaázáala Shealitieli, Shealitieli yaázáala Zerubabeli, ");
INSERT INTO zin_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabeli yaázáala Abihudi, Abihudi yaázáala Eliakimu, Eliakimu yaázáala Azora, ");
INSERT INTO zin_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azora yaázáala Zadoki, Zadoki yaázáala Akimu, Akimu yaázáala Eliudi, ");
INSERT INTO zin_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi yaázáala Eleazari, Eleazari yaázáala Matani, Matani yaázáala Yakobo, ");
INSERT INTO zin_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo yaázáala Yozéfu, iíba wa Mariamu, náwe Mariamu yaámuzáala Yeézu óogwo alikwéetwa Masihi. ");
INSERT INTO zin_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mbwéenu, kuluga ahali Ibrahímu kuhika kuzaalwa kwo omukáma Daudi hakaba heena enzaalwa ikúmi ne eéna. Káandi, kuluga ahali Daudi kuhika ha buchilo óobwo Abaiziraeli baáfululiilwe babe abahálila omu nsi ya Babéeli, hakaba heena enzaalwa ezíindi ikúmi ne eéna. Káandi, kuluga omu buchilo óobwo baáfululiilwe okwo kuhika kuzaalwa kwa Masihi, hakaba heena enzaalwa ezíindi ikúmi ne eéna. ");
INSERT INTO zin_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Empola yo kuzaalwa kwa Yeézu Kristu niyo ezi. Mariamu nyina wa Yeézu, akaba asuumbikilwe na Yozéfu. Náho acháali batakalyaámile hamo, Mariamu yaásaangwa ayina éenda, ne éenda ezo akaba ayinayo aha buhicha bwo Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yozéfu ali iíba, akaba ali omuuntu we entúungwa nzima omu méeso ga Múungu. Talayeenzile kumulega Mariamu, ha bwéecho akalamula kumuleka bweeseléke. ");
INSERT INTO zin_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Náho obuchilo naateekuza aátyo, ahonyini maléeka wo Omukáma Múungu amweésuululukiza omu kulóota, yaámugaambila, “Yozéfu, owo luzáalo lwa Daudi otatiina kumutwáala Mariamu, habwo kuba echili omuunda yoómwe achibweene habwo obuhicha bwo Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Alyaázáala omwaana wo obwoózo, neewe olyaámuluka izíina lyoómwe Yeézu, habwo kuba ogwo niwe alichuungúla abaantu boómwe kuluga omu biheno byáabo.” ");
INSERT INTO zin_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ebyo byóona bikabaho bityo, chibone kuhikiilila echigaambo éecho Omukáma Múungu yaágaambile aha muháanda gwo omubáasi woómwe aáti, ");
INSERT INTO zin_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Léeba, omubiíkila alyaátwáala éenda, náwe alyaázáala omutábani. Niho bamuluke izíina lyoómwe Emanueli.” Ensoonga yi izíina eli nikwo kugaamba oóti, “Múungu ayikala hamo neechwe.” ");
INSERT INTO zin_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Obuchilo Yozéfu yaasisimuka omu túlo, yaákola nko óokwo maléeka wo Omukáma Múungu yaámulagila. Yozéfu yaátwáala Mariamu kuba mukazíwe, ");
INSERT INTO zin_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","náho talalyaamile náze kuhika obuchilo Mariamu yaaba yaázáala omutábani. Yozéfu yaámuluka ogwo mwáana izíina, Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yeézu káyaabeele yaázeelwe, akazaalilwa omuli Betlehemu, omu nsi ya Yudea, no obuchilo obwo omukáma Herode akaba ali omutwáale. Léeba, abamagi be enyenyéezi bakaluga obutúluka, baáhika omu chikaali cha Yeruzaléemu. Baábúuza báti, ");
INSERT INTO zin_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ali nkáhi ogwo mukáma wa Abayahudi ayaázaalwa? Tumanyisizwe nka nikwo yaázáalwa, kuba tukabona enyenyéezi yoómwe obutúluka. Ha bwéecho, tweeza kumulámya.” ");
INSERT INTO zin_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Áaho omukáma Herode káyaahuliile amagaambo gáabo, yaázululukilwa bwooli, hamo na abaantu bóona ba Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Niho yaákobya abakúlu bóona ba abagabe ba Múungu na abeégesa be ebilagilo, yaábabúuza aáti, “Masihi naazaálwa nkáhi?” ");
INSERT INTO zin_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nábo baámusubiza, “Naazaálwa omuli Betlehemu, omu nsi ya Yudea. Nitusoomboókelwa echo, habwo kuba omubáasi wa Múungu akaandika amaandiko aáti, ");
INSERT INTO zin_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Íiwe Betlehemu éensi ya Yuda, toli wo kugaywa nakáti omu batégeki be éensi ya Yuda. Aha nsoonga omuli íiwe alaálugamo omutégeki, óogwo alitégeka abaantu baanze ba Iziraeli, nko omulíisa alikuliisa entaama zoómwe.’” ");
INSERT INTO zin_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mála Herode yaáyéta aha bweeseléke abo abamagi be enyenyéezi babone kwiiza bamusoomboolele kuzima obuchilo óobwo babaandize kuzibona ezo nyenyéezi. ");
INSERT INTO zin_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Niho, yaábasiíndika kuza Betlehemu, naabazila, “Mwiilóoko mucheengelele kuluunzi kulemwa musoomboókelwe omwaana ogwo áaho aáli. Mbwéenu, kamulaaba mwaamubwéene, muundeétele empola bwaangu mbone neenye kuzeenda kumulámya.” ");
INSERT INTO zin_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Obuchilo abamagi be enyenyéezi abo kábaamazile kuhuliiliza amagaambo go omukáma, baba baalugáho aho. Léeba ahonyini, enyenyéezi ezo bakaba baabweene olubazu lwo obutúluka baba baázibona káandi, yaábeebeembelela, yaálemwa yaáhika áaho akaba ali omwaana, niho kweémeelela. ");
INSERT INTO zin_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Áaho kábaabweene enyenyéezi ezo, baánulilwa bwooli. ");
INSERT INTO zin_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mbwéenu, kabataahile omu nzu, baábona omwáana omucheche hamo na Mariamu nyina, baátéela ebizwi aha kumulámya omwaana. Baáfuundula ensáho záabo, baáheeleza omwaana engabilano ze ezaháabu, obubáani na amazuta go omugaazu. ");
INSERT INTO zin_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Múungu akaba abahanile omu kulóota nka nikwo, batagaluka káandi ahali Herode. Ha bwéecho, baátaaha owaabo aha kulabila omuháanda ogúundi. ");
INSERT INTO zin_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Áaho abamagi be enyenyéezi abo baabeele nibatáaha, ahonyini maléeka wo Omukáma Múungu amweésuululukiza Yozéfu omu chilóoto. Yaámugaambila, “Imuka! Otwaále omwaana na nyina, mwiilukile omu ihaánga lya Miísiri. Mwiikaleyo okwo kuhicha obuchilo ndéeza kubagaambila kusuba, habwo kuba Herode naayeénda kumuloondela omwaana ogwo abone kumwíita.” ");
INSERT INTO zin_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mbwéenu, omu chilo omwo nyini, Yozéfu yeémuka, yaátwáala mukázi woómwe hamo no omwaana, yaázeenda nábo omu ihaánga lya Miísiri. ");
INSERT INTO zin_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Baáhika Miísiri, beékala okwo kuhicha obuchilo óobwo Herode akafwa. Ebyo bikabaho bityo, chibone kuhikiilila echigaambo éecho Omukáma Múungu akagaambisa omubáasi woómwe aáti, “Nkamwéeta mutábani waanze kuluga Miísiri.” ");
INSERT INTO zin_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Obuchilo Herode yaácheenga nka nikwo abamagi be enyenyéezi abo bamukoóbile, yaánigahala muno. Niho yaásiindika abalwaanila ngoma boómwe Betlehemu hamo na ahaantu hóona he ebyaalo byo obutúuzi, yaábalagila nka nikwo, beéte kati mwáana wo obwoózo óogwo ayaáhikize emyáaka ibili na áabo abatakazihikize. Akakola aátyo kwiingana no obuchilo óobwo akagaambilwa na abamagi be enyenyéezi. ");
INSERT INTO zin_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Niho echigaambo chaáhikile éecho omubáasi Yeremia akagaamba aáti, ");
INSERT INTO zin_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Empámo zikahulilwa kulugilila omuli Rama, empámo no kubolooga kwíinzi. Raáhéeli naachulila abáana boómwe, náwe takwéenda kusuumbililwa, habwo kuba abáana boómwe baáfwíile.” ");
INSERT INTO zin_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Obuchilo Herode akaba yaáfwiile, maléeka wo Omukáma Múungu akamweesuululukiza Yozéfu omu chilóoto okwo Miísiri, ");
INSERT INTO zin_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","yaámugaambila, “Imuka! Otwaále omwaana na nyina, muze omu nsi ya Iziraeli, habwo kuba áabo abaabeele nibaloónda kumwíita omwaana baáfwíile.” ");
INSERT INTO zin_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mbwéenu, Yozéfu yeémuka, yaátwáala omwaana na nyina, yaásuba nábo omu ihaánga lya Iziraeli. ");
INSERT INTO zin_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Náho óobu yaáhuliile nka nikwo Arkelao mutábani wa Herode, akaba naatégeka éensi ya Yudea ha lugazi lwe eése, aba yaátíina kuzeendayo okwo. Múungu yaámuhana omu chilóoto nka nikwo atazeéndayo okwo káandi. Ha bwéecho, baázeenda omu nsi ya Galiláaya, ");
INSERT INTO zin_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","baáhika omuli Nazaréeti, beékala okwo. Niho echigaambo chihikiilizwe éecho echaagaambilwe na ababáasi habwa Yeézu chíti, “Alyaáyétwa Omunyanazaréeti.” ");
INSERT INTO zin_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ebilo kábyaachíile, akabaho omuuntu oómo óogwo akaba naayétwa Yohana Omubatiza. Yohana akaba naayolekeelela omu nsi yo obwoóma omuli Yudea aáti, ");
INSERT INTO zin_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mutamwe no kulekelela ebiheno byáanyu, habwo kuba obukáma bwo omu igulu bweéliliize.” ");
INSERT INTO zin_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohana niwe ogwo ayaagaambilwe no omubáasi Isaya aáti, “Omuuntu alikuhámuka ahi iláka liháango omu nsi yo obwoóma, ‘Muguloonze omuháanda gwo Omukáma, mugolole obulabo óobwo alaahiíngula.’ ” ");
INSERT INTO zin_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Emyéenda za Yohana zikaba zikozilwe na amooya ge entwaangabuleende náwe akaba azwaala omusipi gwe enkoba. Ebyookulya byoómwe bikaba bili empalala na amóochi moochi go omu nsi yo obwoóma. ");
INSERT INTO zin_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abaantu baaba nibamuhululukila kuluga omu chikaali cha Yeruzaléemu, omu chaalo chóona cha Yudea, ne enkási zóona zo omunóna gwa Yorodáani. ");
INSERT INTO zin_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Abaantu abo baaba nibegaámba ebiheno byáabo, náwe yaaba naababatiza omu munóna gwa Yorodáani. ");
INSERT INTO zin_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Náho obuchilo Yohana akaba naabona Abafarisayo na Abasadukayo nibamwiízaho beenzi abone kubabatiza, yaábagaambila, “Íimwe oluzáalo lwe enzóka! Noóha ayaábahana nka nikwo nimuhicha kweéliga echihulumuko cha Múungu éecho echilikwiiza habwo kubatizwa kwoónka? ");
INSERT INTO zin_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mbwéenu, mwooleke ha bikolwa byáanyu nka nikwo mazima mwaálekeliile ebiheno byáanyu na nimumutegeza Múungu. ");
INSERT INTO zin_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mutazila nka nikwo Múungu naabeekiliza kamulaaba nimweebona nka nikwo, ‘Isíichwe enkúlu ni Ibrahímu!’ Niimbagaambila nka nikwo, Múungu yaakaáhicha kuhiindula amabáale aga kuba abáana ba Ibrahímu! ");
INSERT INTO zin_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Óobu omuchwaáziiko gwa Múungu ni nke enséenya eli aha bitako bye emiti! Na buli muti óogwo gutakusohoza emisumo mizima, gunogolwa no kunagwa omu mulilo!” ");
INSERT INTO zin_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Íinye niimbabatiza aha méenzi kwoóleka nka nikwo mwaálekeliile ebiheno byáanyu no kumuhiindukila Múungu. Náho naayiza omuuntu oóndi óogwo alikuunchíla ha buhicha. Buzima tiinkwiílwe no óobu kuba omuzáana woómwe wo kusutula enkeeto zoómwe. Ogwo niwe alibabatiza aha Mwooyo Mutakatíifu na aha mulilo. ");
INSERT INTO zin_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Óobu akwaasile olutemele omu ngalo zoómwe abone kweesula ebititi kuluga omu ngano. Engano ezo, naazisúuga omu bitala byoómwe, náho ameelulo alyaágóocha omu mulilo óogwo ogutalilaala nakáti!” ");
INSERT INTO zin_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mbwéenu, obuchilo óobwo Yeézu yaáluga Galiláaya, yaázeenda aha munóna gwa Yorodáani abone kubatizibwa na Yohana. ");
INSERT INTO zin_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Náho Yohana yaágema kumuzibila, ha kugaamba aáti, “Bita íiwe kwiiza hali íinye? Íinye níinye ndikweendelwa kubatizibwa neewe.” ");
INSERT INTO zin_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yeézu yaámugalulila aáti, “Íiwe okuúnde ombatize óobu, habwo kuba nitweendélwa tuhikiilize amazima góona áago Múungu alikweenda.” Mbwéenu, Yohana yeékiliza, aba yaámubatiza. ");
INSERT INTO zin_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Áaho Yeézu kayabatiziibwe no kusabuka omu méenzi, ahonyini igulu lyaáfuúnduka, yaábona Omwooyo gwa Múungu nigumuhanaántukila nke echiiba no kutuungama hali weényini. ");
INSERT INTO zin_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Léeba! Iláka liluga omu igulu nilizila liti, “Ogu niwe Mutábani waanze engaanzi, óogwo nnyesiimaho náze bwooli!” ");
INSERT INTO zin_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mála, Yeézu yeébeembelelwa no Omwooyo Mutakatíifu kuzeenda omu nsi yo obwoóma abone kuleengeswa ni Isitáani. ");
INSERT INTO zin_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yaámala okwo ebilo makúmi aána, omu chilo na nyemisana naayeyima kulya ebyookulya. Aha muheleeluko, yaálumwa enzala bwooli. ");
INSERT INTO zin_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Niho elyo Isitáani lyaamwiizáho libone kumuleengesa. Lyaámuzila liti, “Koólaaba íiwe oli Mutábani wa Múungu, galagile amabáale aga gahiinduke kuba emikaate.” ");
INSERT INTO zin_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Náho Yeézu yaáligalulila aáti, “Omu Maandiko Amatakatíifu chaandikilwe chíti, ‘Omuuntu tiyaákuhicha kutuungwa ebyookulya byoónka, náho naatuúngwa habwa buli chigaambo éecho echilikuluga omu kanwa ka Múungu.’” ");
INSERT INTO zin_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Niho elyo Isitáani lyaámutwáala Yeézu omu chikaali chitakatíifu cha Yeruzaléemu, lyaámweemeeleza aha luswi olula bwooli oluli aha nzu ya Múungu, ");
INSERT INTO zin_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","lyaámugaambila liti, “Koólaaba íiwe oli Mutábani wa Múungu, yenaguze ahaansi. Tiwaákuhicha kuhutaala, habwo kuba eyaandikilwe omu Maandiko Matakatíifu eéti, ‘Múungu naalagíla bamaléeka boómwe ha bwaáwe,’ na káandi, ‘Nibakusutula, amagulu gaawe oteéza okeékuumpa ahi ibáale.’” ");
INSERT INTO zin_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Náho Yeézu yaáligaambila, “Káandi eyaandikilwe eéti, ‘Otamuleengesa Omukáma Múungu waawe.’” ");
INSERT INTO zin_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Niho, Isitáani kumutwáala Yeézu aha lugulu yi ibaanga lila bwooli. Aho, lyaámwoóleka obukáma bwóona bwe éensi hamo no obugéega bwaámo, ");
INSERT INTO zin_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","lyaámugaambila liti, “Kábilaaba noonteelela ebizwi no kuúndamya, niinkuha byóona ebi.” ");
INSERT INTO zin_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Náho Yeézu yaáligaambila aáti, “Luheendeho aha, Isitáani we! Eyaandikilwe omu Maandiko Matakatíifu eéti, ‘Omulámye Omukáma Múungu waawe, omugomookele weényini weénka.’” ");
INSERT INTO zin_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Niho elyo Isitáani kumuleka Yeézu aho. Ahonyini, bamaléeka ba Múungu beeza kumuheéleza Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Obuchilo Yeézu yaáhuliile nka nikwo Yohana Omubatiza baámuta omu ibóhelo, yaázeenda omu nsi ya Galiláaya, ");
INSERT INTO zin_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","yaáhika okwo omuli Nazaréeti. Niho yaáfuluka Nazaréeti yaáza kutúula Kaperinaumu. Kaperinaumu ekaba eli aha ngeégeelo ye enyaanza ya Galiláaya, olubazu lwo omu mbíbi ze ebyaalo bya Zabuloni na Naftáali. ");
INSERT INTO zin_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chikabaho chítyo, chibone kuhikiilila echigaambo éecho Múungu akagaambisa omubáasi Isaya aáti, ");
INSERT INTO zin_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Éensi ya Zabuloni ne ya Naftáali, omuháanda gwo kwoólekela aha nziba, na buseeli yo omunóna gwa Yorodáani, omuli Galiláaya áaho balikutuula abanyamahaánga, ");
INSERT INTO zin_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","abaantu áabo abatuula omu nsiimbaazi, baábona omwaanga muháango, na áabo abalikutúula omu bibeho byo olufu, baáyakilwa omwaanga gwa amacheelelélwa.” ");
INSERT INTO zin_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kubaandiza obuchilo obwo, Yeézu yaábaanza kwoólekeelela abaantu aáti, “Mutamwe no kulekelela ebiheno byáanyu, habwo kuba obukáma bwo omu igulu bweéliliize.” ");
INSERT INTO zin_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Obuchilo Yeézu akaba naalibata aha ngeégeelo ye enyaanza ya Galiláaya, yaábona abadugu bábili, Simoni ogwo akaba naayétwa Peétero na Andrea, bakaba nibatéga eénfwi bwe emitégo, habwo kuba bakaba bali abategi. ");
INSERT INTO zin_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yaábagaambila aáti, “Mwiíze, muunkulaatile! Íinye niimbahiindula kuba abategi ba abaantu.” ");
INSERT INTO zin_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ahonyini, baáleka emitégo yáabo, baámukulaatíla Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Obuchilo Yeézu yeeliileho kache, yaábona abadugu abáandi bábili, bali Yakobo no omulumuna Yohana, batábani ba Zebedayo. Abo bábili bakaba bali omu bwáato hamo ne isébo, bakaba nibasoboólola emitégo yáabo. Yeézu yaábéeta bamukulaatile. ");
INSERT INTO zin_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ahonyini, basiga aho obwáato ne isébo, bamukulaatíla Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeézu akaba azoongoloka omu chaalo chóona cha Galiláaya. Akaba naatáaha omu masomelo no kweégesamo abaantu. Akaba naayolekeelela abaantu Empola Nzima zo obukáma bwo omu igulu no kuchíza amalwáala gáabo góona. ");
INSERT INTO zin_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Empola za Yeézu zikaba nizikumuúka bwooli kuhika omu nsi yóona ya Siíria. Abaantu baátwáala abalwéele báabo bóona abeena amalwáala ga buli lugaanda. Omuli abo nyini, bakaba balimo abaabeele nibaagalazibwa bwooli, áabo abaabeele batiilwe na amazimu, abagwi be ebisiimbo, na abaabeele bali enséege. Yeézu yaábachiza bóona. ");
INSERT INTO zin_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mbwéenu, embága mpáango ya abaantu yaaba neemukulaatila kuluga omuli Galiláaya, Dekapoolisi, Yeruzaléemu, Yudea na buseeli yo omunóna gwa Yorodáani. ");
INSERT INTO zin_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Léeba, obuchilo Yeézu akabona embága ya abaantu, yaáhanama omu ibaanga, yeékala. Niho abaheémba boómwe baamwiililaho. ");
INSERT INTO zin_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Náwe yaábaanza kubeégesa aáti, ");
INSERT INTO zin_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Beena omugisa bóona abo abali abahabi omu mwooyo, habwo kuba obukáma bwo omu igulu no obwáabo. ");
INSERT INTO zin_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Béena omugisa áabo beena entíimba, habwo kuba Múungu alyaábasemeleza. ");
INSERT INTO zin_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Béena omugisa áabo bali abafula, habwo kuba Múungu naabaha obuhuunguzi bwe éensi yóona. ");
INSERT INTO zin_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Béena omugisa áabo abeena enzala ni iliho lyo kukola amazima áago Múungu alikweenda, habwo kuba Múungu alyaábahaagisa. ");
INSERT INTO zin_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Béena omugisa abalikuganyila abáandi, habwo kuba nábo Múungu alaábaganyila. ");
INSERT INTO zin_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Beena omugisa abeena omuganya gulikwéela, habwo kuba balaámubona Múungu. ");
INSERT INTO zin_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Béena omugisa abakwaátanisi ba abaantu, habwo kuba balaáyétwa abáana ba Múungu. ");
INSERT INTO zin_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Béena omugisa abalikwaágalazibwa habwo kukola amazima áago alikweenda Múungu, habwo kuba obukáma bwo omu igulu no obwáabo. ");
INSERT INTO zin_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Íimwe mwiina omugisa obuchilo abaantu nibabazuma, no kubaágalaza no kubagaamba buli chigaambo cho obuzilwa omu kubabeéheleza habwo kuunkulaatila íinye. ");
INSERT INTO zin_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mwiizuke nka nikwo bityo nikwo óokwo abaantu bakaba nibabaagalaza ababáasi áabo bakaba baliho kala. Mube nimunulilwa no kusaánduuka bwooli, habwo kuba Múungu ababiikiile empeéla mpáango omu igulu.” ");
INSERT INTO zin_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Íimwe ni nko omwóonyo gwe éensi. Omwóonyo ogwiina omuta, náho kigulaaba gwaábiíhile, bita niguhicha kubona omuta gwaáyo káandi? Tigukuhicha kuluungiswa káandi hali choóna chóona, ha bwéecho niguséeswa ahéelu no kulibatilwa na abaantu. ");
INSERT INTO zin_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Íimwe muli nko omwaanga gwe éensi. Iboma elyoombekilwe ahi ibaanga, tiliiseleka. ");
INSERT INTO zin_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Káandi, abaantu tibakwaacha olumuli no kulisweekelela omu chitukulu. Náho nibaluta aha kakóondo lubone kumulikila bóona áabo abali omu nzu. ");
INSERT INTO zin_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bityo nyini neemwe, omwaanga gwáanyu nigweendelwa gumulikile abaantu, babone kubona ebikolwa byáanyu ebizima, niho bamusiíngize Isíimwe óogwo ali omu igulu.” ");
INSERT INTO zin_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mutazila nka nikwo neeza mbone kusúucha ebilagilo bya Musa, nali áago gakagaambwa na ababáasi. Tiindeézile mbone kubisúucha, náho mbone kuhikiiliza amazima gaábyo. ");
INSERT INTO zin_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mazima butúnu niimbagaambila nka nikwo, kuhicha obuchilo óobwo igulu ne éensi bilihwaho, tihaliho echigaambo nali akanyuguta kache ke ebilagilo akalibuza echilali. Ebilagilo ebyo tibililugaho kulemwa byóona bihike. ");
INSERT INTO zin_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Omuuntu weéna wéena óogwo alikoongookela echilagilo chimo nóobu chilaaba chiche cha hali ebi no kweégesa abáandi bakole bátyo, ogwo alyáaba muche muno omu bukáma bwo omu igulu. Náho weéna wéena óogwo alibikwaáta no kubyoólekeelela abáandi nábo bakole bátyo, ogwo alyáaba mukúlu omu bukáma bwo omu igulu. ");
INSERT INTO zin_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mbwéenu, niimbagaambila nka nikwo, obugololoke bwáanyu kábulaaba butasaagile obwa Abafarisayo no obwa abeégesa be ebilagilo, no obuche bwa káti timulitaahamo omu bukáma bwo omu igulu.” ");
INSERT INTO zin_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mwaáhuliize echilagilo éecho baagaambíilwe abaantu ba kala báti, ‘Otaliita! Káandi, omuuntu weéna wéena óogwo alikwiita muzeenzíwe, ni lwaampaka achwaaziikilwe.’ ");
INSERT INTO zin_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Náho íinye niimbagaambila nka nikwo, omuuntu weéna wéena óogwo anigahalila muzeenzíwe, ni lwaampaka ayagalale. Káandi, weéna wéena óogwo alikuzuma muzeenzíwe, náwe ni lwaampaka ayagalazwe omu Itégekelo. Káandi, weéna wéena óogwo alikugaambila muzeenzíwe nka nikwo no omusilu, ni lwaampaka kunagwa omu lyoongoola lyo omulilo gwa kuzimu. ");
INSERT INTO zin_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ha bwéecho, koólikuba noosohoza echigabo ahi itaámbilo, mále okeezuka nka nikwo ohabeene na muzeenzi waawe, ");
INSERT INTO zin_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","síga echigabo chaawe aho ahi itaámbilo, obaánze ozeénde kuloonda obuhóolo hali mweene wáanyu. Niho osube kwiiza kusohoza echigabo chaawe. ");
INSERT INTO zin_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Káandi, kábilaaba omuuntu yaákutwáala aha mulamuzi, oloónde obuhóolo náze bwaangu obuchilo muchili omu muháanda. Koólaaba otakozile oótyo, naakuhicha aha mulamuzi, omulamuzi náwe naakunaga omu ngalo zo omusilikale, náwe naabona kukúta omu ibóhelo. ");
INSERT INTO zin_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mazima butúnu niinkugaambila nka nikwo, nakáti tokuluga omwo kuhicha omazile kuliha ne eséenti yo omuhélo, obutasigaza ibáanza!” ");
INSERT INTO zin_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mwaáhuliize echilagilo éecho abaantu baagaambíilwe báti, ‘Otaákusaambana!’ ");
INSERT INTO zin_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Náho íinye niimbagaambila nka nikwo, omuuntu weéna wéena óogwo aleeba omukázi aha kumulígila, yaámazile kusaambana náze omu muganya gwoómwe. ");
INSERT INTO zin_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mbwéenu, kabyaakuba elíiso lyaawe lyo obúlyo lyaákuleételela okole ebiheno, olikúulemo no kulinaga hala. Ni kuzima kubuza oluziingo lwaawe lúmo, kuchila omubili gwaawe gwóona kuza kusikizwa omu kunagwa omu lyoongoola lyo omulilo gwa kuzimu. ");
INSERT INTO zin_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Káandi, kábilaaba omukóno gwaawe gwo obúlyo nigukuleetelela kuhena, ogunogole no kugunaga hala. Ni kuzima kubuza oluziingo lúmo óobu, kuchila omubili gwaawe gwóona kusiingaalichwa omu lyoongoola lyo omulilo gwa kuzimu.” ");
INSERT INTO zin_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mwaáhuliize echilagilo éecho abaantu baagaambíilwe báti, ‘Kati muuntu óogwo alikumuleka mukazíwe, amuhe olwaandiko lwo kwaángana.’ ");
INSERT INTO zin_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Náho íinye niimbagaambila nka nikwo, buli muuntu alikumuleka mukazíwe, butali bwo obusaambani, naamuleetelela mukázi woómwe kusaambana. Káandi, weéna wéena óogwo alikuumpula omukázi ayaalekéene ne eéba, náwe naába asaambeene náze.” ");
INSERT INTO zin_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mwaáhuliize echilagilo éecho abaantu ba kala baagaambíilwe báti, ‘Olekelage kulahila ebisuba, náho ohikiílize Omukáma Múungu omulahi óogwo waálahiile.’ ");
INSERT INTO zin_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Náho íinye niimbagaambila nka nikwo, otalilahila butúnu no óobu ahi igulu, habwo kuba nicho echitébe cho obutégeki cha Múungu. ");
INSERT INTO zin_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nali otaákulahilila habwe éensi ezi, habwo kuba niho Múungu aáta amagulu goómwe. Nali otaákulahila habwe echikaali cha Yeruzaléemu, habwo kuba echo nicho echikaali cha Múungu, Omukáma mukúlu. ");
INSERT INTO zin_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nali otaákulahila habwo omútwe gwaawe, habwo kuba tiwaákuhicha kuhiindula no óobu akasoke kámo kabe akalikwéela nali akalikwiílagula. ");
INSERT INTO zin_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Náho kamulikuba nimumanyisa mútyo ha kwiikilizana, mugaámbega muti, ‘Éego,’ na kábilaaba nimumanyisa timukwiikilizana, mugaámbega muti, ‘Mmahi.’ Kuba amagaambo agasaaga aho nigaluga ahali elyo Izilwa, Isitáani.” ");
INSERT INTO zin_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mwaáhuliize echilagilo éecho abaantu bakagaambilwa báti, ‘Elíiso aha líiso, ne elíino aha líino.’ ");
INSERT INTO zin_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Náho íinye niimbagaambila nka nikwo, mutaákusiingaangana no omuuntu omuzilwa. Náho kábilaaba omuuntu yaákuteela ahi itama lyo obúlyo, muhiindulile ne lyo obumoso. ");
INSERT INTO zin_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Káandi, kábilaaba omuuntu akulegeeliile abone kutwáala enkaanzu yaawe, mulekele atwaále ne ebebo yaawe. ");
INSERT INTO zin_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Káandi, kábilaaba omuuntu naakuzemeleza oluzeendo lwo kuteelaho eénta echihuumbi chimo, íiwe guma ozeénde náze oluzeendo lwe entáambo ebihuumbi bibili. ");
INSERT INTO zin_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Káandi, kaálaaba omuuntu akusabile echiintu, omuhe. Na kaálaaba ayizile kukwoóhoza, otamuleebayo kuche.” ");
INSERT INTO zin_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mwaáhuliize echilagilo éecho abaantu baagaambíilwe báti, ‘Omweénde muzeenzi waawe,’ na abaantu bakeégeswa báti, ‘Omunobe omubisa waawe.’ ");
INSERT INTO zin_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Náho íinye niimbagaambila nka nikwo, mubeénde ababisa báanyu, na mube nimubasabila bóona áabo abalikubaágalaza. ");
INSERT INTO zin_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mbwéenu, kámulikola mútyo, nimuba abáana be Isíimwe óogwo ali omu igulu. Weényini niwe abaakiza izóoba abaantu abazima na abaantu abaheni. Káandi, abeetilila enzula abaantu abagololoke hamo na abazilwa. ");
INSERT INTO zin_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mbwéenu sii, kábilaaba nimweénda abo boónka abalikubéenda, mulyaábona empeéla chi? Manya, abahaámbya nábo nikwo bazila beenda abo abalikubéenda boónka. ");
INSERT INTO zin_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Káandi, keélaaba nimwaangalucha badugu báanyu boónka, nimuba mwaákola chikolwa chi cho kusaaga abáandi? No óobu abo baantu abali Abanyamahaánga, mubabona batabizila ebilikususa nke ebyo? ");
INSERT INTO zin_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mbwéenu, mube abo obúlyo, nko óokwo Isíichwe óogwo ali omu igulu aba owa akalyo.” ");
INSERT INTO zin_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mulamanya! Ebikolwa byáanyu ebizima mutabizilila omu méeso ga abaantu kuba babaléebe. Ha nsoonga kamulaaba nimukola mútyo, timukwiinaánkula ensiimi yoóna yóona kuluga hali Isíimwe óogwo ali omu igulu. ");
INSERT INTO zin_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Mbwéenu, obuchilo noosuumbuusa abaambazi, leka kweélaangaana óokwo olikukola aha kutéela echikuli. Abagóbya bakola bátyo omu masomelo no omu nsése babone kusiingizwa na abaantu. ");
INSERT INTO zin_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mazima butúnu niimbagaambila nka nikwo, baámazile kwiinaankula ensiimi yáabo yóona. Náho íiwe obuchilo noosuumbuusa aha ngoonzi, engalo yaawe yo obumoso etamanyisibwa áago engalo yo obúlyo yaásohoza, ");
INSERT INTO zin_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","esuumbuuso yaawe ezeénde omu chihwe. Iíso waawe óogwo amanya ebye echihwe, alyaákugalulila.” ");
INSERT INTO zin_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“No obuchilo nimusaba Múungu, mutaákuba nke engóbya. Abo beenda kusaba kunu beémeeliile omu masomelo no omu mbazu ze nsése kuba babone kuleebwa na abaantu. Mazima butúnu niimbagaambila nka nikwo, baámazile kwiinaankula ensiimi yáabo yóona. ");
INSERT INTO zin_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Náho íiwe obuchilo noosába, otaahemo omu chiseenge chaawe mále oteyo olwiizi. Niho osabe Iíso óogwo ali omu chihwe. Náwe Iíso óogwo abona ebili áaho abaantu batakuhwéeza, alyaákugalulila. ");
INSERT INTO zin_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Obuchilo nimusaba, mutaákuba nimutuúmilila ebigaambo nko óokwo bakola abaantu áabo abali abapagáani. Abo nibateekuza nka nikwo nibahulilwa habwo kukanyisa amagaambo gáabo. ");
INSERT INTO zin_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mutaákuba nimusaba nko óokwo basabaho abo, habwo kuba Isíimwe naasoombookelwa éecho mulikweenda, no óobu muba mutakachisabile. ");
INSERT INTO zin_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ha bwéecho, íimwe mubéga nimuleembeleza Múungu ha kuzila muti, ‘Isíichwe oli omu igulu, izíina lyaawe likuzibwe. Obukáma bwaawe bwiíze. ");
INSERT INTO zin_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Engoonzi zaawe zihikiílizwe, omu nsi nko okwo omu igulu. ");
INSERT INTO zin_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Otuhe leélo ebyookulya byéetu bya buli chilo. ");
INSERT INTO zin_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Otuganyile ebiheno byéetu, nko óokwo neechwe tuganyila abalikutuhénela. ");
INSERT INTO zin_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Otatutwáala omu kuleengesibwa, náho otuchuúngule ne elyo Izilwa, Isitáani. Habwo kuba, obukáma, obuzizi ni ikuzo byóona ne ebyaáwe, kuhicha obucha no obuchiile. Amina!’ ” ");
INSERT INTO zin_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yeézu yaázeendelela kugaamba aáti, “Kamulaaba nimubaganyila abaantu ebiheno byáabo, Isíimwe óogwo ali omu igulu náwe alyaábaganyila íimwe ebiheno byáanyu. ");
INSERT INTO zin_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Náho kamulaaba mutakubaganyila abaantu ebiheno byáabo, Isíimwe óogwo ali omu igulu náwe takubaganyila neemwe ebiheno byáanyu.” ");
INSERT INTO zin_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Káandi obuchilo musiibile, mwaáleka kweézila nka abagóbya boónyini bazeenda bahinyile obuso, iíngu abaantu babamanye nka nikwo basiíbile. Amazima butúnu niimbagaambila nka nikwo, abo baámazile kwiinaankula ensiimi yáabo yóona. ");
INSERT INTO zin_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Náho íiwe óobu waásiiba, síiga amazuta omútwe gwaawe, náaba omu buso bwaawe, ");
INSERT INTO zin_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","otamanywa na abaantu nka nikwo oli omu chisiibo, náho omanywe na Iíso weénka ogwo ali omu chihwe. Weényini abibona ebyo omu chihwe, náwe naába endihi yaawe.” ");
INSERT INTO zin_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mulekega kweébiikila ensabo omu nsi ezi, habwo kuba aho na ahaantu áaho zilikusiiswa ne embuungu no kucheleba, na abeebi bahasiísa babone kuzíiba. ");
INSERT INTO zin_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Náho baambo mweébikiile ensabo záanyu omu igulu habwo kuba aho tekusiiswa ne embuungu no kucheleba na abeebi tibakuhasiisagula babone kwíiba. ");
INSERT INTO zin_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Hoóna hóona áaho olikubíika ensabo yaawe, niho no omuganya gwaawe gulaaba guli ahonyini. ");
INSERT INTO zin_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Améeso gaawe ni nko olumuli lwo omubili gwaawe. Améeso gaawe kagaba nigahweéza kuzima, omubili gwaawe gwóona gwiikala omu mwaanga. ");
INSERT INTO zin_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Náho elíiso lyaawe kalilaaba lifwiile, no omubili gwaawe gwóona nigwiikala omu nsiimbaazi. Mbwéenu, kábilaaba omwaanga ogwo oguli omu mubili gwaawe guhiindukile kuba ensiimbaazi, ensiimbaazi ezo neéba mpaango bwooli! ");
INSERT INTO zin_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Táliho omuuntu óogwo yaakuhicha kuheéleza abakáma bábili. Habwo kuba, yaakaátamwa omukáma oómo no kweenda oóndi, nali yaakaákúunda ago omukáma oóli, na ayaanga ago omukáma ogu. Bityo neemwe, timwaákuhicha kugomookela Múungu hamo na amabonwa!” ");
INSERT INTO zin_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ha nsoonga ezo niimbagaambila nka nikwo, mutaákuba no kutahwa tahwa habwo obulami bwéenyu nkokwo nimulya chi, nali nimunywa chi, nali ha mibili yáanyu, nkokwo nimuzwaála chi. Ngási, nimweébwa nka nikwo obulami bwiina obukaani kuchila ebyookulya, no omubili nágwo gwiina obukaani kuchila ebizwáalo? ");
INSERT INTO zin_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Muleebe enyonyi. Tizikubiba, tizikugesa nali kuhunika ebyookulya omu bitala. No óobu bityo, Isíimwe óogwo ali omu igulu, aziliísa. Mbwéenu íimwe, timwiina obukaani buháango kuchila enyonyi ezo? ");
INSERT INTO zin_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Noóha omuli íimwe ayaakuhicha kweéyoongeláho obulami bwoómwe nóobu nko omwáanya gwe esáaha eémo omu kutahwa tahwa kwoómwe? ");
INSERT INTO zin_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ha bwaáchi nimutahwa tahwa habwe ebizwáalo? Muteekuze enyaso zo omu nkaamba óokwo zikuláho. Tizikukola emilimo nali kwóogosa ebizwáalo. ");
INSERT INTO zin_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Náho niimbagaambila nka nikwo, nóobu omukáma Selemani omu ikuzo lyoómwe lyóona, talazweekilwe kuzima nka límo lye enyaso ezo! ");
INSERT INTO zin_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Múungu azweeka enyaso na amababi go omu nkáamba, áago galiho leélo na nyeéncha niganágwa omu mulilo. Ngási, ta amazima nkokwo naabazweéka íimwe? Íimwe abaantu bo okwiikiliza kuche! ");
INSERT INTO zin_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ha bwéecho, muleke nu kusiiba nimweetwaalalika nimuzila muti, ‘Tulaálya chi?’ nali ‘Tulaánywa chi?’ nali ‘Tulaázwáala chi?’ ");
INSERT INTO zin_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ebiintu ebyo byóona, abaantu áabo babyaagalalíla na abatakumumanya Múungu. Isíimwe óogwo ali omu igulu naasoombookelwa kuzima nka nikwo mulikweenda ebyo byóona. ");
INSERT INTO zin_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Óobu íimwe, echa mbele muloondele obukáma bwa Múungu na amazima goómwe. Aho niho alaaboongéla agáandi ago góona. ");
INSERT INTO zin_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mbwéenu, mutaákuba no kweétwaalalika ebilaagwa nyeéncha, habwo kuba echilo cha nyeéncha chiina ebyaácho. Buli chilo chiina olwaágalalo lwaácho oluhikile.” ");
INSERT INTO zin_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mutaákuchwaaziika abáandi, kuba neemwe mutaákwiiza kuchwaáziikilwa. ");
INSERT INTO zin_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nko óokwo mulikuchwaáziika abáandi, nikwo kutyo nyini óokwo Múungu alibachwaaziikáho neemwe. Na habwe echigaambo cho kweéchwaaziika, endeengo éezo mulikubaleengeláho abáandi, niyo éezo nyini Múungu náwe alibaleengelamo neemwe. ");
INSERT INTO zin_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ha bwaáchi nooléeba akatokoozi áako kali omu líiso lya muzeenzi waawe, náho okabula kubona embago éezo eli omu líiso lyaawe? ");
INSERT INTO zin_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nali noohichaho oóta kumugaambila muzeenzi waawe oóti, ‘Nkuúndila nkwiíhilemo akatokoozi omu líiso lyaawe,’ obuchilo íiwe nyini oyine embago etuula omu líiso lyaawe? ");
INSERT INTO zin_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ngóbya we! Obaánze oyihémo embago éezo eli omu líiso lyaawe, niho olaahicha kuleeba kuzima kwiihámo akatokoozi akali omu líiso lya muzeenzi waawe. ");
INSERT INTO zin_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mutáliziha eémbwa ebiintu ebitakatíifu bya Múungu, habwo kuba zilaáhiindukila zibalaansamule ebinogoka nogoka. Káandi, mutálizinagila empunu ebiintu byo obukaani, habwo kuba zilyaábizuungagilila.” ");
INSERT INTO zin_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mumusabe Múungu, náwe naabaha éecho mulikumusaba. Mutaábuuze, mulyaábigwáho. Muchiinguze, mulyaáchiingulilwa. ");
INSERT INTO zin_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Habwo kuba, buli muuntu óogwo alikusaba, aheébwa: na buli muuntu óogwo ataábuuza, abigwaho: na buli muuntu óogwo achiinguza, achiingulilwa. ");
INSERT INTO zin_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ngási, ahali íimwe heena omuuntu weéna wéena, kaalikusabwa omukaate no omutábani, naamuha ibáale? ");
INSERT INTO zin_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nali kaalikusabwa eénfwi, naamuha enzóka? ");
INSERT INTO zin_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ha bwéecho, nóobwo muli abazilwa, nimusoomboókelwa kubaha abáana beenyu egabo ezigasize. Ngási, Isíimwe óogwo ali omu igulu takuhicha kubaha bwooli ebiintu ebizima abo abalikumusaba? ");
INSERT INTO zin_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mbwéenu íimwe, choóna chóona éecho mweénda kuzililwa na abaantu abáandi, neemwe mube nicho echo mubazilile mútyo nyini. Ezo niyo ensoonga ye ebilagilo bya Musa na ameégeso ga ababáasi.” ");
INSERT INTO zin_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Otaahemo ha kulabila aha muháanda gwe echisasi chi iléembo elifuunzile. Kuba iléembo no omuháanda ogutwaala omu kusiingaalichwa guba ne echisasi chi iléembo ligazi káandi liháango, mala na abalilabamo ni béenzi. ");
INSERT INTO zin_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Náho omuháanda gwi iléembo éelyo elilikweebeembeza kuza omu bulami liba lifuunzile. Nábo abaantu abalikulikugula, ni bache.” ");
INSERT INTO zin_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mweécheenge na ababáasi be ebisuba. Mazima abo na abaantu abalikubéezáho, nibeekola kuba abafula nke entaama, náho omu myooyo yáabo bali emisegwe ye enduluhe. ");
INSERT INTO zin_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nimuhicha kubasoombookelwa habwa amagoomba gáabo. Abaantu tibakugesa emisumo ye emizabibu nali emitini kuluga omu miti ya amáhwa. ");
INSERT INTO zin_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Omuti muluunzi guzaala amagoomba mazima, náho omuti mubi guzaala amagoomba mábi. ");
INSERT INTO zin_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Omuti muluunzi tigukuhicha kulábya amagoomba mábi, no omuti mubi tigukuhicha kulábya amagoomba amazima. ");
INSERT INTO zin_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Buli muti óogwo ogutakulabya amagoomba amazima, gunogolwa no kunagwa omu mulilo. ");
INSERT INTO zin_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bityo nyini na ababáasi be ebisuba, mubasoombookelwa habwa amagoomba gáabo.” ");
INSERT INTO zin_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ti buli muuntu óogwo anyetoongelezaho aáti, ‘Íiwe Mukáma, íiwe Mukáma,’ iíngu niwe alitaaha omu bukáma bwo omu igulu. Náho no omuuntu óogwo akola engoonzi za Táata óogwo ali omu igulu, ogwo niwe alibutaahamo. ");
INSERT INTO zin_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Echilo cho omuchwaáziiko nichiíza, na abaantu béenzi balaángaambila báti, ‘Íiwe Mukáma, íiwe Mukáma! Nooyizuka nka nikwo tukasohoza obubáasi habwi izíina lyaawe? Na nka nikwo tukabiinga amazimu habwi izíina lyaawe? Na nka nikwo tukakola amahano méenzi habwi izíina lyaawe?’ ");
INSERT INTO zin_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Niho ndibagaambila butúnu iínti, ‘Tiínkubamanya íimwe nakáti! Muundugého aha, íimwe enkola bíbi!’ ” ");
INSERT INTO zin_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mbwéenu, omuuntu óogwo ahulila ameégeso gaanze no kugahicha, alyaásusaniswa kuba nko omuuntu owa amasala óogwo ayaayoombekile éenzu yoómwe aha luchili. ");
INSERT INTO zin_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chilo chimo, enzula ekagwa, améenzi ge emizela gaákonoka, no omuyaga muháango gwéeha no kusutula éenzu yoómwe. Náho éenzu ezo telagwiile, habwo kuba oluhazo lwaáyo lukaba lwoombekilwe aha lugulu yo oluchili. ");
INSERT INTO zin_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Náho omuuntu óogwo ahulila ameégeso gaanze na tagahicha, ogwo alyaásusaniswa nko omuuntu omusilu óogwo ayaayoombekile éenzu yoómwe aha musényi. ");
INSERT INTO zin_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Obuchilo enzula ekagwa, améenzi ge emizela gakakonoka, no omuyaga muháango gukeeha no kusutula ezo éenzu yoómwe. Áaho éenzu ezo ekabutama, emigweele yaáyo ekachilaho.” ");
INSERT INTO zin_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yeézu kaágwiisa ebyo bigaambo, embága ezo ya abaantu eba yaásobelwa bwooli habwa ameégeso goómwe, ");
INSERT INTO zin_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kuba akaba naayegesa nka ayina obuzizi, na ameégeso goómwe tigalabeele nka aga abeégesa báabo be ebilagilo bya Musa. ");
INSERT INTO zin_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Obuchilo Yeézu yaátuukile kuluga aho ahi ibaanga, ebipípi biháango bya abaantu bikamukulaátila. ");
INSERT INTO zin_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Léeba, yeeza omuuntu oómo ayaabeele ali omubéembe, yaámwiililila, yaáteela ebizwi omu méeso ga Yeézu, yaámugaambila aáti, “Mukáma waanze, koólaayeénda, oyine obuhicha bwo kuunyéza.” ");
INSERT INTO zin_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeézu yaágolola omukóno gwoómwe, yaamukoláho, yaámugaambila aáti, “Niinyeénda ochile, oyele!” Ahonyini, yaayézwa obubéembe bwoómwe. ");
INSERT INTO zin_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Niho, Yeézu yaámugaambila aáti, “Lola, otabigaambila muuntu weéna wéena! Choónka ozeénde oze kweéyoleka ha mugabe, osohoze echitáambo nka nikwo ebilagilo bya Musa bilikulagila, obóne kwoóleka abaantu nka nikwo waáchila.” ");
INSERT INTO zin_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Obuchilo Yeézu akaba naatáaha omuli Kaperinaumu, omwiímeelelezi oómo wa abalwaanila ngoma be Echirúumi yaamwiilukiláho abone kumuzuna. ");
INSERT INTO zin_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Yaámugaambila aáti, “Íiwe Mukáma, nnyina omuhálila omúka ali aha chihalala, yaábeele enséege, ayine obusaasi buháango bwooli.” ");
INSERT INTO zin_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeézu yaámugalulila aáti, “Niinyiza kumuchiza.” ");
INSERT INTO zin_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Niho omwiímeelelezi ogwo yaámugalulila, “Mukáma, mazima tiinkwiílwe otaahemo omwaánze. Náho ogaámbe echigaambo kwoónka, omuhálila waanze náwe naachila. ");
INSERT INTO zin_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Habwo kuba neenye ndi ahaansi yo obutégeki bwa abakúlu baanze, nnyina abalwaanila ngoma abali ahaansi yaanze. Kaándikumulagila oómo, ‘Ozeénde’, ahonyini naazeénda. Kaándikumulagila oóndi, ‘Iíza’, náwe ahonyini naayiza. No omuhálila waanze, kaándikumulagila, ‘Kola oóti’, nikwo alaakola.” ");
INSERT INTO zin_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Obuchilo Yeézu yaáhuliile ago, yaásobelwa bwooli. Yaábagaambila abo abaabeele nibazeénda náze aáti, “Mazima butúnu niimbagaambila nka nikwo, no óobu omu Baiziraeli bóona, tiínkabwéene omuuntu weéna wéena owo kwiikiliza kuháango nko óoku! ");
INSERT INTO zin_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Niimbagaambila nka nikwo, obuchilo bwa amazenyi go kuhika kwo obukáma bwo omu igulu, abaantu béenzi nibeéza kulugiilila obutúluka no obugwa. Baleékala ahaansi babone kulya hamo na baguúku béetu Ibrahímu, Izáaka na Yakobo. ");
INSERT INTO zin_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Náho abaantu bo obukáma obwo, balyaánagwa ahéelu omu nsiimbaazi, aho, halyaábaho okuchula no kusa améeno.” ");
INSERT INTO zin_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mbwéenu, Yeézu yaágaambila omwiímeelelezi ogwo wa abalwaanila ngoma aáti, “Zeénda omúka. Chibe hali íiwe nka nikwo kuli okwiikiliza kwaawe.” Ako kaziingo nyini, omuhálila woómwe aba yaáchila. ");
INSERT INTO zin_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Niho Yeézu kuzeenda omúka ya Peétero. Káyaataahilémo omu nzu, yaámubona nyinazaala wa Peétero alyaamile aha chitabo, atiilwe omuswiiza. ");
INSERT INTO zin_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeézu yaámukola ha mukóno, entúlo eémo omuswiiza guba gwaamulugaho. Nikwo kwiimuka, yaábaanza kubatóna ebyookulya. ");
INSERT INTO zin_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Izóoba kályaagwiilemo, baamuleetela Yeézu abaantu béenzi áabo abaabeele batuungamiilwe amazimu. Náwe yaágabiinga amazimu ago ha kulagila echigaambo. Káandi, yaáchíza abaantu bóona abaabeele bali abalwéele. ");
INSERT INTO zin_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yeézu akakola ago góona, abone kuhikiiliza echigaambo éecho echaabeele chigaambilwe habwa weényini no omubáasi Isaya chíti, “Akeemela ennáku zéetu, akahikiilila amalwáala géetu.” ");
INSERT INTO zin_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Obuchilo Yeézu akabona nka nikwo embága ya abaantu bamuzoongolokile, yaálagila abaheémba boómwe beloónze kwaambuka enyaanza bazeénde ha mulaambo. ");
INSERT INTO zin_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mbwéenu, omweégesa oómo we ebilagilo bya Musa yaamwiililáho Yeézu, yaámugaambila aáti, “Íiwe Mweégesa, niinkúkulaatila hoóna hóona áaho olaáza.” ");
INSERT INTO zin_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeézu yaámugalulila aáti, “Nyamuhaábwa ziba ziina ameena gaázo ne enyonyi zizila ebyaali. Náho íinye Mutábani wo Omuuntu, tiinzila no óobu aho kubyaámika omútwe gwaanze!” ");
INSERT INTO zin_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Omuheémba oóndi womwa Yeézu yaámugaambila aáti, “Íiwe Mukáma, nkuúndila ntaandike nzeénde kumuziika táata.” ");
INSERT INTO zin_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeézu yaámugalulila aáti, “Íiwe onkulaatile, leka abáfwiile babaziíke abáfwiile bazeenzi báabo.” ");
INSERT INTO zin_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mbwéenu, Yeézu yaátaaha omu bwáato, na abaheémba boómwe baámukulaatíla. ");
INSERT INTO zin_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Obuchilo kábaahikile ahagáti ye enyaanza, ahonyini gwéeha omuyaga muháango bwooli na amakóonzo gasweeka obwáato. Náho Yeézu weényini akaba ahuniile. ");
INSERT INTO zin_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abaheémba boómwe baamwiililaho baámusisimula, nibateéla eyoombo báti, “Íiwe Mukáma, otuchize! Twaásiingaalika!” ");
INSERT INTO zin_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yeézu yaábagaambila aáti, “Íimwe banya kwiikiliza kuche, ha bwaáchi nimutiína?” Ahonyini ayemeelela, agukáama omuyaga ne enyaanza. Entúlo eémo, enyaanza chaaba echineembe. ");
INSERT INTO zin_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abo baantu baásobelwa, baágaamba báti, “Omuuntu ogu ni muuntu chi, alikugomookelwa nóobwo omuyaga ne enyaanza?” ");
INSERT INTO zin_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Obuchilo Yeézu akaba yaáyaambukile buseeli ye enyaanza, yaáhika éensi ya Abagadara. Yaábugana aho na abaantu bábili abakwaasilwe amazimu. Bábili abo bakaba nibaluga omu nyaanga zo kuziikilámo abáfwiile. Bóona bakaba bazaazahéele muno na táliho omuuntu óogwo ayaagimile kulabila ogwo muháanda. ");
INSERT INTO zin_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mbwéenu, gaáhamuka nigagaámba gáti, “Íiwe Yeézu Mutábani wa Múungu, tukatuulanwa chi íiwe neechwe ka nootuloónda? Ngási, weeza kunu ezi kutwaágalaza gutakahikile omuhélo gwa akachilo kéetu?” ");
INSERT INTO zin_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Héehi na aho baabeele bali, hakaba haliho obusho bwe empunu nizilya. ");
INSERT INTO zin_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Niho amazimu ago gaámutoózela Yeézu, gaazila gáti, “Kábilaaba nootubiínga aha, otwiikililize tutáahémo omu busho bwe ezo mpunu.” ");
INSERT INTO zin_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Náwe yaágagaambila aáti, “Nimwiilóoko!” Mala, amazimu gabalugamo abaantu abo, gazeénda no kutaahilila omu mpunu ezo. Ahonyini, obwo busho bwóona bwaátuuka bwaangu aha ngolomoko nibweesiindikiliza no kuza kúgwa omu nyaanza, no kufwéela omu méenzi omwo. ");
INSERT INTO zin_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abalíisa kábaabweene ebyo, beéluka baaza omu iboma. Omu iboma omwo, baáteekeelela abaantu byóona ebyeeloongile hamo na ago agáabo abaabeele bakwaasilwe na amazimu. ");
INSERT INTO zin_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Abaantu bóona bo omu iboma baáyata kuza kubugana na Yeézu. Obuchilo bamubweéne, baámutoózela kuluga omu mbíbi záabo. ");
INSERT INTO zin_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Niho Yeézu yaáhanama omu bwáato, yaáyaambuka enyaanza ya Galiláaya káandi, yaásuba omuli Kaperinaumu, omu iboma éelyo yaátwíile omwo. ");
INSERT INTO zin_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Obuchilo yaáhikile óokwo, abaantu abáandi bamuletela omuuntu óogwo akaba ali enséege, alyaamile aha chitwaálilizi. Obuchilo Yeézu káyaabwéene echikolwa cha abaantu abo, yaámanya nka nikwo bakaba beena okwiikiliza, yaámugaambila ogwo mulwéele aáti, “Íiwe mwáana waanze, tiímbya omuganya! Waáganyiilwe ebiheno byaawe.” ");
INSERT INTO zin_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Niho abeégesa abáandi be ebilagilo áabo bakaba baliho aho bateekateeka omu miganya yáabo báti, “Omuuntu ogu naamulogota Múungu!” ");
INSERT INTO zin_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Náho Yeézu akasoombookelwa góona áago bakaba nibateekuza, yaábabúuza aáti, “Ha bwaáchi, nimuteekuza ebíbi omu miganya yáanyu? ");
INSERT INTO zin_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ngási! Ni chiiha echilikuhuhuuka bwooli? Kumugaambila nka nikwo, ‘Waáganyiilwe ebiheno byaawe,’ nali kumugaambila nka nikwo, ‘Yemeelela, olibate?’ ");
INSERT INTO zin_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Náho mubóne kusoomboókelwa kuluunzi nka nikwo, íinye Mutábani wo Omuuntu nheelwe obuzizi bwo kuganyila ebiheno omu nsi ezi.” Niho Yeézu yaámugaambila omuuntu óogwo akaba ali enséege aáti, “Yemeelela! Twaála echitwaálilizi chaawe, ozeénde omúka.” ");
INSERT INTO zin_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ahonyini, yaáyemeelela, yaázeenda omúka. ");
INSERT INTO zin_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Obuchilo abaantu baabweene ago, baákwáatwa obutíini. Bamulamiliza Múungu óogwo akabaha abaantu obuzizi nko obwo. ");
INSERT INTO zin_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Obuchilo Yeézu akaba naazeénda, omu muháanda yaábona omuhaámbya oómo óogwo akaba naayétwa Matayo, ayikéele omu kazu koómwe kokutobesezamo oluhaambwe. Yeézu yaámugaambila aáti, “Onkuláatile.” Matayo yaáyemeelela, yaábaanza kumukulaatila. ");
INSERT INTO zin_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mbwéenu, Yeézu yaázeenda kulya ebyookulya omwa Matayo hamo na abaheémba boómwe. Obuchilo bakaba beékeele omwo, bataahamo abahaámbya na abáandi béenzi áabo baámanyikile kuba abaheni, bakaba nibalya ebyookulya hamo nábo. ");
INSERT INTO zin_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Obuchilo Abafarisayo baabweene echo, baábagaambila abaheémba ba Yeézu báti, “Ha bwaáchi, omweégesa wáanyu naálya hamo na abahaámbya na abaheni abáandi!” ");
INSERT INTO zin_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Obuchilo Yeézu yaáhuliile amagaambo gáabo, yaábagaambila aáti, “Abaantu abeene enziingo nzima, tibakugaswa omulaguzi, náho abalwéele nibo abalikugaswa! ");
INSERT INTO zin_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mbwéenu, muze kweéyega ensoonga ya amagaambo ga Múungu omu Maandiko Matakatíifu naagaámba nka nikwo, ‘Niinyeénda abaantu booleke echiganyizi kuchila kusohoza echitáambo.’ Mbwéenu, íinye tiíndeezile kwéeta abaantu abagololoke, náho abaheni.” ");
INSERT INTO zin_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Niho abaheémba ba Yohana beeza hali Yeézu, baámubúuza báti, “Ha bwaáchi íichwe na Abafarisayo tuza omu chisiibo, náho abaheémba baawe tibaza omu chisiibo?” ");
INSERT INTO zin_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeézu yaábasubiza aáti, “Abasagazi ba chisweéla, nibahicha báta kuzululukilwa obuchilo bali hamo na chisweéla omu bweenga? Náho ebilo biliyo nibiíza niho balaáyakwa chisweéla. Obuchilo obwo, niho baliba ne echisiibo. ");
INSERT INTO zin_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Taliho omuuntu abaziilila echibatulo chisha aha mwéenda ogukokweele. Kaálaabazilila, echibatulo echisha chiguteémula omwéenda ogwo no kwoongela kubatuka bwooli. ");
INSERT INTO zin_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Káandi, taliho omuuntu óogwo alikuchenena evíini eénsha omu nfulebe ze eémpu enkokolo. Kuba kaalikukola aátyo, evíini keelikutuumba, enfulebe niziteemuka, evíini neeseéseka ne enfulebe nizisiisikala. Náho evíini eénsha neeyeendelwa kutéebwa omu nfulebe ze eémpu eénsha. Bityo, enfulebe eénsha ne evíini eénsha biikala bili bizima!” ");
INSERT INTO zin_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Obuchilo Yeézu achaáhooyela ago, omweébeembezi oómo wi isomelo, yéeza, yaáteela ebizwi omu méeso goómwe, yaámugaambila aáti, “Muhala waanze yaáfwa óobu nyini! Náho, tuzeénde oteho engalo yaawe hali weényini, náwe naába omulame káandi.” ");
INSERT INTO zin_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Niho, Yeézu yaázeenda hamo na abaheémba boómwe, bamukulaatíla omweébeembezi ogwo. ");
INSERT INTO zin_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mbwéenu, obuchilo obwo nyini omukázi oómo óogwo akaba naayagalazwa ne endwáala ye emizezi emyáaka ikúmi ne ibili, yéeza kuluga enyuma ya Yeézu, yaamukuumyaho aha lukugilo lwe ebizwaalóbye kwoónka. ");
INSERT INTO zin_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Akakola aátyo, habwo kuba naayeteekateéka aáti, “Kiíndakuumyáho kwoónka ebizwáalo byoómwe, niinchila.” ");
INSERT INTO zin_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Obuchilo yaabikwaasileho, ahonyini Yeézu yeéchebuka. Yaámubona ogwo omukázi, yaámugaambila aáti, “Íiwe muhala waanze, tiímbya omuganya! Okwiikiliza kwaawe nikwo kwaákuchiza!” Omuli áako kaziingo nyini, omukázi ogwo aba yaachila. ");
INSERT INTO zin_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mbwéenu, obuchilo Yeézu yaáhikile omu nzu yo ogwo omweébeembezi wi isomelo, yaábona abaantu abalikutéela emiléela ne embága bakobile nibateéla empámo. ");
INSERT INTO zin_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Weényini yaábagaambila aáti, “Mulugého aha! Omuhalákazi ogu tákafwíile, náho alyaamile kwoónka.” Obuchilo abaantu abo bahuliile bátyo, baámuseka Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Niho Yeézu yaábasohoza bóona ahéelu, yaátaaha omu chiseenge, yaámukwáata engalo omuhalákazi ogwo, náwe yaáyemeelela! ");
INSERT INTO zin_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Empola ezo zaaba nizisuúgaana omu nsi ezo yóona. ");
INSERT INTO zin_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Obuchilo Yeézu yaámazile kuluga aho, abahume bábili baámukulaatíla, kunu nibamuháma no kugaamba báti, “Íiwe Mutábani wa Daudi, otuzilile echiganyizi!” ");
INSERT INTO zin_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Obuchilo Yeézu kayataahile omu nzu, abahume abo baámukulaatila omwo. Mbwéenu, Yeézu yaábabúuza aáti, “Ngási, nimwiikiliza nka nikwo niinhicha kubachíza?” Baámusubiza báti, “Nookasíinge Mukáma!” ");
INSERT INTO zin_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Niho Yeézu yaabakoláho ha méeso gáabo, yaábagaambila aáti, “Chibe hali íimwe nka nikwo kuli okwiikiliza kwáanyu.” ");
INSERT INTO zin_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ahonyini, améeso gáabo gahweeza, baáhicha kubona. Yeézu yaábaneémbelela aha magala aáti, “Mutaákugaambila omuuntu weéna wéena empola ezi!” ");
INSERT INTO zin_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","No óobu bityo baázeenda, balaánga empola zoómwe omu nsi ezo yóona. ");
INSERT INTO zin_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Obuchilo abahume áabo bakaba nibaluga áaho, léeba, abáandi baamuleetela Yeézu omuuntu oómo óogwo akaba akwaásilwe ni izimu elyo elyaaleteliile aábe omutita. ");
INSERT INTO zin_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yeézu yaálibiinga izimu éelyo, na ahonyini omuuntu óogwo yaábaanza kuhooya káandi. Abaantu beenzi áabo bakaba baliho áaho baásobelwa bwooli, baágaamba báti, “Omu nsi yóona ya Iziraeli tibikabagaho buluga nakáti ebigaambo nke éebi!” ");
INSERT INTO zin_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Náho Abafarisayo baágaamba báti, “Naabiínga amazimu habwa amagala go omukúlu wa amazimu!” ");
INSERT INTO zin_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeézu akaba azoongoloka omu maboma ne emigoongo yóona ya Galiláaya. Akaba naatáaha omu masomelo no kweégesamo abaantu. Akaba naayolekeelela abaantu Empola Nzima zo obukáma bwo omu igulu no kuchíza amalwáala góona. ");
INSERT INTO zin_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Obuchilo Yeézu akabona embága za abaantu, yaábazilila echiganyizi, habwo kuba bakaba nibaagalala na tibalabeele no omuuntu wo kubazuna. Bakaba bali nke entaama zitéena omulíisa. ");
INSERT INTO zin_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mbwéenu yaábagaambila abaheémba boómwe aáti, “Emyéezo ni míinzi, náho abakózi ni bache. ");
INSERT INTO zin_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ha bwéecho, mumusabe kanyina wo omusili, abone kusiíndika abakózi omu musili gwoómwe.” ");
INSERT INTO zin_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Niho yaáyéta abaheémba boómwe ikúmi na bábili, yaábaha obuzizi bwo kubiinga amazimu no bwo kuchíza amalwáala góona. ");
INSERT INTO zin_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amazíina ge entumwa abo ikúmi na bábili nigo aga, wo kubaanza ni Simoni óogwo alikwéetwa Peétero, na Andrea mudugu woómwe, Yakobo mutábani wa Zebedayo, na Yohana mudugu woómwe, ");
INSERT INTO zin_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo, Baritolomayo, Tomaso, Matayo omuhaámbya, Yakobo mutábani wa Alfayo, Tadayo, ");
INSERT INTO zin_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni Omuzelóote na Yuda Iskariote óogwo ayaamukoongile Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mbwéenu, Yeézu yaásiindika ezo ntumwa ikúmi na bábili, yaázilagila aáti, “Mutaákuzeenda aha Banyamahaánga, káandi mutaákutaaha omu iboma lyoóna lyóona lya Samaria. ");
INSERT INTO zin_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Náho muzeénde aha Baiziraeli, boónyini ni nke entaama éezo zibuzile. ");
INSERT INTO zin_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Obuchilo nimuzeénda owaabo, mube nimwoolekeelela nka nikwo, ‘Obukáma bwo omu igulu bweéliliize!’ ");
INSERT INTO zin_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Muchize abalwéele, muzóole abáfwiile, mweéze abeena obubéembe na mubiínge amazimu. Mwiinaánkwiile obuhicha obwo busa, neemwe óobu musohoze busa. ");
INSERT INTO zin_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mutaákuzeenda ne ezaháabu, nali empilya nali emiliinga omu nfulebe záanyu. ");
INSERT INTO zin_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Káandi, mutaákuzeenda omu luzeendo ne nfulebe, nali amagwáanda ábili, nali enkeeto, nali enkoni. Habwo kuba omukózi chimugasize kuhaabwa empeéla yoómwe. ");
INSERT INTO zin_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Omu iboma lyoóna lyóona nali omugoongo gwoóna gwóona óogwo mulaáhikámo, muloondele omuuntu óogwo ali buligi ligi kubanyegeza omúka yoómwe. Mbwéenu, mwiikale hali weényini kuhicha obuchilo óobwo muliluga áaho. ");
INSERT INTO zin_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Obuchilo nimutáaha omúka yoómwe, mubaángaluche abaantu boómwe ha kubeéndeza obuhóolo. ");
INSERT INTO zin_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mbwéenu, kábalaaba balimo abaantu áabo abakwíile, enyaángalucha yáanyu neebaha obuhóolo, náho keélaaba batakwíile kwiinaankula obuhóolo obwo, bubasubile íimwe, butaákusigala nábo. ");
INSERT INTO zin_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kábilaaba omúka yoóna yóona nali omu iboma lyoóna lyóona, abaantu baámo nibaánga kubanyegeza no kubahuliiliza ameégeso gáanyu, kamulasoholaho ahaanzu ezo nali ahi iboma éelyo, mweekuunkumule enkuungu kuluga amagulu gáanyu. ");
INSERT INTO zin_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mazima butúnu niimbagaambila nka nikwo, omu chilo cho omuchwaáziiko, Múungu alyaábachwaáziika kúbi bwooli abaantu bo omu iboma éelyo, kuchila abaantu bo omu nsi ya Sodoma na Gomora!” ");
INSERT INTO zin_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Muunhúliilize, niimbasiindika nke entaama éezo ezilikulibata ahagáti ye emisegwe. Ha bwéecho mbwéenu, mube abacheluke nke enzóka, káandi mube abafula nke echiiba. ");
INSERT INTO zin_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mube méeso na abaantu, habwo kuba nibabatwaála omu matégekelo, káandi balaábakona enkoba omu masomelo gáabo. ");
INSERT INTO zin_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nibabatwaála omu méeso ga abaanaángwa na aha abakáma, ha bwaánze íinye. Nimweendelwa kuba baalubona baanze omu méeso gáabo no omu méeso ga abaantu ba amahaánga góona. ");
INSERT INTO zin_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Obuchilo balaábatwáala, mutaákwaagalala nkokwo nitutoóza túta nali nitugaámba chiíha. Múungu naabaha amagaambo go kugaamba aha kaziingo áako. ");
INSERT INTO zin_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ti nka nikwo íimwe nimuhóoya, náho no Omwooyo gwa Múungu Isíimwe nigwo gulaahóoya kulabila hali íimwe. ");
INSERT INTO zin_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Aha buchilo óobwo, nibiba nka nikwo omweene wáabo naamukoónga omulumuna ha babisa abone kwiitwa. Káandi iíse alaámukoonga kóonga omwaana, na abáana balaábazaázaana abazéele báabo babone kwiitwa. ");
INSERT INTO zin_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Abaantu bóona nibabatamwa habwo kuba muli abaheémba baanze. Náho, weéna wéena óogwo aleegumisiliza kuhika ihelezo, niwe alichuungulwa na Múungu. ");
INSERT INTO zin_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kábilaaba nibabaagalaza omu maboma bunaanka, mbwéenu mwiilukile omu iboma elíindi. Mazima butúnu niimbagaambila nka nikwo, timulimala emilimo yáanyu omu maboma góona ga Iziraeli, íinye Mutábani wo Omuuntu niímba naáhikile. ");
INSERT INTO zin_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Omuheémba tachila omweégesa woómwe, no omuhálila tachila omukáma woómwe. ");
INSERT INTO zin_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Omuheémba naayeéndelwa aábe nko omweégesa woómwe, no omuhálila náwe aábe nko omukáma woómwe. Íinye ndi mukúlu wáanyu na nibaanyeta Beelzebuli. Kábilaaba baányéta bátyo, ngási tibakubéeta íimwe amazíina mábi ha kusaágiliza?” ");
INSERT INTO zin_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Mbwéenu, mutabatíina abaantu áabo. Chóona chóona éecho echifuundikiilwe, chilyaáfuundulwa, na káandi, tihaliho echiselekilwe echitalimanywa. ");
INSERT INTO zin_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Góona áago ndikubagaambila íimwe omu nsiimbaazi, mugagaámbe ha mwaanga hali bóona. Káandi, góona áago mulikuhulila kuluga hali íinye bweeseléke, mugoólekeelele aha bwéelu omu baantu. ");
INSERT INTO zin_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mutatiina áabo abalikuhicha kwiita omubili gwéenyu, náho tibakuhicha kwiita omwooyo gwáanyu. Íimwe mutiíne Múungu weénka, habwo kuba weényini niwe yaakaáhicha kusikiza omubili hamo no omwooyo omu lyoongoola lyo omulilo gwa kuzimu. ");
INSERT INTO zin_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Ngási, enfuunzi ibili tizikuguzwa habwo obukaani buche kwoónka? No óobu bityo, tihaliho no obu enyonyi eémo éezo elikugwa ahaansi hataázila bweenzi bwe Isíimwe. ");
INSERT INTO zin_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Náho íimwe, Múungu naamanya olubalo lwi isóke lyóona lye emitwe yáanyu. ");
INSERT INTO zin_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ha bwéecho mbwéenu, mutatiina, habwo kuba mwiina obukaani kusaaga enfuunzi nyíinzi. ");
INSERT INTO zin_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Omuuntu kaálaandaangáana omu méeso ga abaantu nkokwo weényini no omuuntu waanze, neenye ndaámulaangaana nka nikwo no omuuntu waanze omu méeso ga Táata owo omu igulu. ");
INSERT INTO zin_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Náho, weéna wéena óogwo aliinyaanga omu méeso ga abaantu, neenye ndaámwáanga omu méeso ga Táata óogwo ali omu igulu.” ");
INSERT INTO zin_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mutazila muti nnyizile habwo kuléeta obuhóolo omu nsi ezi. Tiíndeezile habwo obuhóolo, náho habwo kuléeta ichúmu. ");
INSERT INTO zin_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Neeza kuléeta obutaániso aha musígazi ne iíse, omuhalákazi na nyina, no mweenga na nyinazaala. ");
INSERT INTO zin_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Enobi yo omuuntu baláaba abaantu be eéka yoómwe. ");
INSERT INTO zin_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Omuuntu weéna wéena óogwo ayeénda iíse nali nyina kuchila íinye, ogwo tichikwiíle kuba omuheémba waanze. Káandi, weéna wéena óogwo alikumweénda omutábani nali omuhala kuchila íinye, ogwo náwe takwiilwe kuba omuheémba waanze. ");
INSERT INTO zin_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Omuuntu óogwo atakweenda kwiimucha omusalaba gwoómwe no kuunkuulaatila, ogwo takwiile kuba omuheémba waanze. ");
INSERT INTO zin_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Omuuntu weena weena óogwo alikweenda kuchígilila obulami bwoómwe, niwe alyaábunaga. Náho omuuntu óogwo alibuza obulami bwoómwe ha bwaánze, ogwo niwe alaabubonesa.” ");
INSERT INTO zin_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Omuuntu weéna wéena óogwo alikubeenaánkula íimwe, áaho naayinaánkula neenye. Káandi, náwe óogwo alikuunyinaánkula íinye, naamwiinaánkula na Múungu óogwo ansiindikile íinye. ");
INSERT INTO zin_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Weéna wéena óogwo alikumwiínaankula omubáasi habwo kuba no omubáasi, Múungu naamuha empeéla nka nikwo alaaha omubáasi. Káandi, weéna wéena ogwo alikumwiínaankula omuuntu omugololoke habwo kuba no omugololoke, Múungu naamuha náwe empeéla nka nikwo alikuhéebwa omugololoke. ");
INSERT INTO zin_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Weéna wéena óogwo alaámuha no óobu echikóombe cha améenzi galikunyilila ahali oómo omu baantu kanaku habwo kuba no omuheémba waanze, mazima butúnu niimbagaambila, ogwo takubuza empeéla yoómwe kuluga hali Múungu.” ");
INSERT INTO zin_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Obuchilo Yeézu káyaamazile kubalagila abaheémba boómwe ikúmi na bábili ebilagilo ebyo, yaalugáho aho, yaázeendelela no oluzeendo lwoómwe lwo kweégesa no kwoólekeelela abaantu omu maboma gáabo. ");
INSERT INTO zin_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Obuchilo obwo, Yohana Omubatiza akaba abohilwe omu ibóhelo. Obuchilo akaba ali omwo, akahuliza áago Masihi akaba naakola. Niho yaásiindika abaheémba boómwe hali weényini, baámubuuze báti, ");
INSERT INTO zin_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ngási, íiwe níiwe Masihi óogwo aleéza, nali tumutegezeyo oóndi?” ");
INSERT INTO zin_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeézu yaábasubiza aáti, “Muzeénde mumugaambile Yohana góona áago mulikuhulila no kubona, ");
INSERT INTO zin_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","nka nikwo, abahume, nibahweéza, abalema, nibalibata, aba mabéembe, nibachizwa, enzibamatwi, nibahulila, abáfwiile, nibazoolwa, na abahabi, nibaatulilwa Empola Nzima. ");
INSERT INTO zin_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ayina omugisa, weéna wéena óogwo atéena kutahwa tahwa hali íinye!” ");
INSERT INTO zin_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Áabo abaheémba ba Yohana kábaabeele baálugileho, Yeézu yaábaanza kubagaambila embága ya abaantu empola za Yohana. Yaábabúuza aáti, “Obuchilo mwaáziile omu nsi yo obwoóma kumuleeba Yohana, ngási, mukazeenda kuleeba chiíha? Akasahuunga akalikuchuúndagulwa chúundagulwa no omuyaga? Mmahi! ");
INSERT INTO zin_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mbwéenu, mukazeenda kuleeba chiíha? Ngási, omuuntu óogwo azweele ebizwáalo biluunzi? Mmahi. Abaantu áabo abazwaala ebizwáalo biluunzi nibatuúla omu maka ge chikáma. ");
INSERT INTO zin_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mbwéenu, mukazeenda kuleeba chiíha? Ngási, mukazeenda kuleeba omubáasi? Éego nyini no omubáasi, náho niimbagaambila nka nikwo, Yohana ni mukúlu kusaagáho omubáasi. ");
INSERT INTO zin_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ogwo niwe alikusoomboolwa omu Maandiko Matakatíifu nka nikwo, ‘Huliiliza, niinsiindika entumwa yaanze omu méeso gaawe, óogwo alaakweébeembelela omu kukugololela omuháanda.’ ");
INSERT INTO zin_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Mazima butúnu niimbagaambila nka nikwo, omu baantu bóona áabo abazeelwe na abakázi, takabahoga omuuntu weéna wéena ali mukúlu kusaaga Yohana Omubatiza. No óobu bityo, omuuntu atéena mugaso omu bukáma bwo omu igulu, niwe mukúlu kumusaaga weényini. ");
INSERT INTO zin_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kulugiilila omu buchilo bwa Yohana Omubatiza kuhicha leélo ezi, obukáma bwo omu igulu buzaazaanwa lwa amagala na abaantu, na abaantu enduluhe babunyagiílila lwa amagala. ");
INSERT INTO zin_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ababáasi bóona hamo na Musa omu bilagilo byoómwe bakasohoza obubáasi habwo obukáma obu kuhika obuchilo bwa Yohana. ");
INSERT INTO zin_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mbwéenu kábilaaba nimwiikiliza obubáasi bwáabo, Yohana niwe Eliya, óogwo ayaagaambilwe nka nikwo, alyéeza. ");
INSERT INTO zin_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Óogwo ayina amatwi, ahuliilize! ");
INSERT INTO zin_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ngási, abaantu bo obuchilo óobu mbasusanise na chiíha? Nibasusana na abáana áabo abekeele omu igulizo nibeehamukila nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tukabateelela emiléela, náho kubona nimunegula mahi! Mala twaábazinila enzina ze entíimba, náho timulachuzile!’ ");
INSERT INTO zin_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bityo nyini obuchilo Yohana akeeza. Akaba atalya nali kunywa evíini, na abaantu baágaamba nka nikwo, ‘Ogu ayina izimu!’ ");
INSERT INTO zin_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mbwéenu, íinye Mutábani wo Omuuntu nnyizile, niíndya ebyookulya no kunywa, na abaantu bo obuchilo obu baágaamba nka nikwo, ‘Léeba! Ogu no owo omuhaánka na káandi no omutamiizi! Na ni munywáani wa abahaámbya na abaheni!’ “Náho no obu bityo, amasala ga Múungu gamanyisibwa kuba ga mazima habwo muháanda gwe ebikolwa bya abaantu boómwe.” ");
INSERT INTO zin_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Niho Yeézu yaábaanza kukaama amaboma áago akakolelamo amahano méenzi, habwo kuba abaantu baámo tibalatamilwe no kulekelela ebiheno byáabo, bakamuhiindukila Múungu. Yaábazila nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Nimwiilóoko íimwe abaantu ba Korazíini! Mulamanya íimwe, abaantu ba Betisaida! Kábilaaba amahano áago nkakola hali íimwe, naakugakozíle omu mizihwa ezo ya Tíilo na Sidóoni, abaantu abo baakaábéele baátamilwe ebiheno byáabo no kumuhiindukila Múungu bwaangu. Baakaáyolekile okuhiinduka kwáabo habwo kuzwáala amagunila no kweésiiga iízu. ");
INSERT INTO zin_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Náho, niimbagaambila nka nikwo, omu chilo cho omuchwaáziiko, Múungu alyaábachwaáziika íimwe kúbi bwooli kuchila abaantu ba Tíilo na Sidóoni. ");
INSERT INTO zin_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Neemwe, abaantu ba Kaperinaumu, mutaákuteekuza nka nikwo nimukuzibwa kuhika omu igulu? Mmahi! Olyaágolomolwa kuhika omu lyoongoola lya kuzimu yo olufu. Keélaaba amahano áago mwaakoliilwe íimwe, gaakukozilwe omuli Sodoma, echo chaalo chaakabeeleho kuhicha leélo. ");
INSERT INTO zin_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Náho niimbagaambila nka nikwo, aha chilo cho omuchwaáziiko, Múungu alyaábachwaáziika íimwe kubi bwooli kuchila abaantu be éensi ya Sodoma.” ");
INSERT INTO zin_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Obuchilo óobwo Yeézu yaágaamba aáti, “Íiwe Táata, Mukáma wi igulu ne éensi, niinkusiima habwo kuba ebigaambo éebi okaseleka abamasala na abamanyi, okabita aha bwéelu aha baantu áabo abeena okwiikiliza nka abayaánda abato. ");
INSERT INTO zin_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Éego Táata, habwo kuba nikwo óokwo wayeenzile.” ");
INSERT INTO zin_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Niho Yeézu yaábagaambila abaantu aáti, “Táata ampeele byóona. Tihaliho omuuntu óogwo alikumusoombookelwa Mutábani wa Múungu nka nikwo aáli, náho Táata weénka. Káandi, taliho muuntu óogwo alikumusoombookelwa Táata nka nikwo aáli, náho Omutábani weénka, na weéna wéena óogwo Omutábani alaalamula kumusuululila. ");
INSERT INTO zin_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mwiíze hali íinye bóona áabo mwaálemilwe no kulemeelelwa ne emigugu, neenye ndaábahuúmuza. ");
INSERT INTO zin_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Íinye ndi omufula, káandi omweécheesha. Ha bwéecho, mweékome omudaala gwaanze, mweéyege kuluga hali íinye, niho mulaabonesa kuba no obuhóolo omu miganya yáanyu. ");
INSERT INTO zin_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Omudaala gwaanze nigwooloba no omugugu gwaanze niguhuhuúka.” ");
INSERT INTO zin_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Echilo chimo che Endaálikizo, Yeézu akaba naalaba omu masaambo ge engano, hamo na abaheémba boómwe, abaheémba boómwe baábaanza kuhéenda amakuumba, baálya. ");
INSERT INTO zin_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Obuchilo Abafarisayo baabweene ago, baámugaambila Yeézu báti, “Léeba, abaheémba baawe nibakola emilimo ezili omuzilo aha chilo che Endaálikizo!” ");
INSERT INTO zin_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yeézu yaábagalulila aáti, “Ngási, timukasomile Amaandiko Matakatíifu nka nikwo Daudi yaákozile obuchilo óobwo weényini na bazeenzíbe bakaba beene enzala? ");
INSERT INTO zin_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Daudi akataaha omu nzu ya Múungu, niho weényini na bazeenzíbe áabo akaba ali hamo nábo baba baázilya ezo mikaate yaámo éezo ekaba yaásohwéezwe hali Múungu. Telakuundiilwe omu bilagilo bya Musa omuuntu kulya emikaate ezo, náho abagabe ba Múungu boónka. ");
INSERT INTO zin_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Káandi, timukasomile éecho echilagilo cha Musa okwo chilikugaamba habwa abagabe áabo abalikuheéleza omu nzu ya Múungu echilo che Endaálikizo? Tibakukuláatila ebilagilo bye Endaálikizo, náho Múungu talababaliile nka nikwo nibamuhena. ");
INSERT INTO zin_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Niimbagaambila butúnu nka nikwo, aliho oómo aha óogwo ali mukúlu kuchila éenzu ya Múungu. ");
INSERT INTO zin_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Múungu naagaámba omu Maandiko Matakatíifu nka nikwo, ‘Niinyeénda abaantu booleke echiganyizi kuchila kusohoza echitáambo.’ Mwaakubeele nimusoomboókelwa ensoonga ya amagaambo ago, timwaákuchwaaziikile abaantu áabo abatéena echiheno choóna chóona. ");
INSERT INTO zin_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Íinye Omutábani wo Omuuntu, níinye Omukáma we echilo che Endaálikizo.” ");
INSERT INTO zin_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeézu yaalugáho aho, yaázeenda omu isomelo lyáabo. ");
INSERT INTO zin_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Omu isomelo omwo, akaba alimo omuuntu oómo óogwo akaba alageele omukóno. Bakaba balimo Abafarisayo abaabeele nibeénda kumuleengesa Yeézu babone omuháanda gwo kumulégelela. Mbwéenu baámubúuza báti, “Ngási, ti muzilo kuchiza omuuntu echilo che Endaálikizo?” ");
INSERT INTO zin_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yeézu yaábagalulila aáti, “Noóha omuli íimwe óogwo, kábilaaba entaama yoómwe yáagwa omu liina echilo che Endaálikizo, tiyaákuhicha kuzikwáata no kuzíihámo omwo? ");
INSERT INTO zin_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mumanye, omuuntu ayina obukaani bwooli kusaaga entaama! Ha bwéecho, kwiingana ne ebilagilo bya Musa eyikiliziibwe kukola ebizima echilo che Endaálikizo.” ");
INSERT INTO zin_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Niho Yeézu yaámugaambila omuuntu óogwo alageele omukóno aáti, “Golola omukóno gwaawe.” Náwe yaágugolola, ahonyini gwaáchila, gwáaba muzima nko ogwo ogúundi. ");
INSERT INTO zin_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mbwéenu, Abafarisayo baásohola ahéelu, baábiteélana óokwo balaámwíita Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeézu akamanya emizeenzo ya Abafarisayo abo, ha bwéecho yaalugáho áaho. Ebipípi biháango byaámukulaatíla, náwe yaáchiza bóona abaabeele nibalwaála. ");
INSERT INTO zin_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Náho yaábaangila nka nikwo bataákuba nibalaánga empola zoómwe ha baantu abáandi. ");
INSERT INTO zin_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yeézu akagaamba aátyo, abone kuhikiiliza echigaambo éecho Múungu akagaambisa omubáasi Isaya nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Léeba, ogu niwe omuzáana waanze óogwo mmutoolize. Ogu ne engaanzi yaanze óogwo alikunuliza omwooyo gwaanze. Niimmuha Omwooyo gwaanze, abone kulaanga omuchwaáziiko gwa abazilwa ha baantu ba amahaánga góona. ");
INSERT INTO zin_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Talihakana na abaantu nali kwoomba nábo, káandi talyaámbaza iláka lyoómwe omu nsése. ");
INSERT INTO zin_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Talimuhéenda weena weena óogwo ali omulemwa nko olubiingo olwaátikile, nali talisiingaálicha weena weena óogwo ali héehi kufwa nke enkaanzi éezo elikusohoza omwíika, kuhicha obuchilo óobwo alileeta obuchuúnguzi kusíinga obuzilwa bwóona. ");
INSERT INTO zin_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na lyoónyini izíina lyoómwe, abaantu ba amahaánga góona balyaálitegeza lyoónyini lyoónka.” ");
INSERT INTO zin_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mbwéenu, abaantu baámuleétela Yeézu omuuntu oómo óogwo akaba akwaásilwe ni izimu limukozile kuba omuhume, káandi kuba omutita. Yeézu yaámuchiza, náwe yaáhicha kuhooya no kuhweeza káandi. ");
INSERT INTO zin_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Embága yóona ya abaantu abaabeele bali áaho baásobelwa bwooli, baágaamba báti, “Ngási, ogu yaakaáhicha kuba Mutábani wa Daudi?” ");
INSERT INTO zin_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Náho obuchilo Abafarisayo bahuliile ago, baágaamba báti, “Omuuntu ogu tiyaákuhicha kubiinga amazimu náho habwa amagala ga Beelzebuli, mukúlu wa amazimu.” ");
INSERT INTO zin_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeézu yaámanya okuteékuza kwáabo, ha bwéecho yaábagaambila aáti, “Buli bukáma obuli kutáana no kulwaana bwoónyini omuli bwoónyini, óobwo bukáma busiingáalika. Káandi, kábilaaba iboma límo nali eéka keéyetaanisa no kulwaana yoónyini omuli yoónyini, teyililwaho. ");
INSERT INTO zin_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Bityo nyini, kábilaaba Isitáani nilibiínga no kulwaana na amazimu mazeenzíge, obukáma bwaályo buba bwaátaana. Obukáma bwaályo nibuhicha kulama buta? ");
INSERT INTO zin_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Íimwe nimugaámba nka nikwo íinye niimbiínga amazimu habwa amagala ga Beelzebuli. Mbwéenu, abaheémba báanyu nábo, nibagabiingila ha magala go oóha? Ha bwéecho, áabo nyini nibo balaabachwaázika íimwe. ");
INSERT INTO zin_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Náho, kábilaaba íinye niimbiínga amazimu habwa Omwooyo gwa Múungu, eyina ensoonga ya nkokwo obukáma bwoómwe bwaáhikile hali íimwe. ");
INSERT INTO zin_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tihaliho omuuntu óogwo yaakuhicha kutaaha omúka ye empaambazi abone kusaakula ebiintu acháali atakamukomile. Mazima kaálaaba yaámukomile kuluunzi, áaho niho yaakaáhicha kumunyagiilila ebiintu éebyo bili omúka yoómwe. ");
INSERT INTO zin_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Omuuntu ogwo atali hamo ne íinye, taanyemela. Káandi, ogwo atasuúmbya hamo ne íinye, anaganaga. ");
INSERT INTO zin_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ha bwéecho niimbagaambila nka nikwo, Múungu yaakaáhicha kuganyila abaantu ebiheno no kulyoogóoza kwáabo kwóona. Náho Múungu tiyaákuhicha kuganyila abaantu kábalaaba bamulogweéte Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Káandi Múungu yaakaáhicha kuganyila abaantu áabo abalikuteéleleza hali íinye Mutábani wo Omuuntu. Náho tiyaákuhicha kuganyila abaantu áabo abalikuteéleleza habwo Omwooyo Mutakatíifu, omu nsi ezi, nali éensi éezo elikwiiza.” ");
INSERT INTO zin_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Omuti muluunzi gulaba amagoomba maluunzi, no omuti mubi gulaba amagoomba mábi. Noohicha kugusoombookelwa omuti nka nikwo guli habwa amagoomba áago gulaba. ");
INSERT INTO zin_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Íimwe oluzáalo lwe enzóka! Bita nimuhicha kugaamba amagaambo amazima obuchilo íimwe na abazilwa? Omuuntu naahoóyela ebiteekuzóbye ebiizwiile omuli weényini. ");
INSERT INTO zin_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Omuuntu omweésigwa agaámba ebizima éebyo ebiizwiile omuli weényini, náho omuuntu omuzilwa agaámba byo obuzilwa éebyo biizwiile omuli weényini. ");
INSERT INTO zin_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mbwéenu, niimbagaambila nka nikwo, ha chilo echo cho omuchwaáziiko, abaantu balyaásoomboola entaahililo ya buli chigaambo kanaku éecho bakagaamba. ");
INSERT INTO zin_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Múungu alaákubala kuba omugololoke habwa amagaambo gaawe, nali alaákuchwaáziika kuba omuzilwa habwa amagaambo gaawe.” ");
INSERT INTO zin_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mbwéenu, omuli áabo Abafarisayo na abeégesa be ebilagilo bya Musa baámugaambila Yeézu báti, “Íiwe Mweégesa, nitweénda oyoleke emanyiso kwoóleka nka nikwo olugile ahali Múungu.” ");
INSERT INTO zin_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeézu yaábagalulila aáti, “Íimwe no oluzáalo lubi lwa abaantu abaheni na timuli abeésigwa omu méeso ga Múungu, niyo nsoonga nimweénda olumanyiso. Tiínkubakolela olumanyiso lwoóna lwóona. Náho olumanyiso lúmo óolwo mulaabona ni nko óokwo Múungu akakola aha mubáasi Yona. ");
INSERT INTO zin_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nko óokwo Yona akeekala omuunda ye enkuungulutále ebilo bísatu echilo na nyemisana, bityo nyini neenye Omutábani wo Omuuntu, ndeékala omuli kuzimu omuunda ye éensi amazóoba asatu echilo na nyemisana. ");
INSERT INTO zin_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Aha chilo cho omuchwaáziiko, abaantu ba Ninawi balaáyemeelela omu méeso ga Múungu hamo na abaantu bo obuchilo óobu, no kubasoholeza buulubona abaantu bo luzáalo óolu nko okwo na abaheni. Habwo kuba, abaantu abo ba Ninawi, obuchilo Yona yaábagaambiile echigaambo cha Múungu, ahonyini baátamwa ebiheno byáabo no kubilekelela. Aha aliho oómo óogwo ali mukúlu kuchila Yona! ");
INSERT INTO zin_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Káandi, omu chilo echo cho omuchwaáziiko ogwo, omugóle we éensi ya Sheba aleémeelela omu méeso ga Múungu hamo na abaantu bo obuchilo obu, no kubasoholeza buulubona abaantu bo luzáalo olu nko okwo na abaheni. Habwo kuba, weényini akazeenda oluzeendo kuluga éensi za hala bwooli, abone kuhulila ebigaambo byo obweétegeeleza bwa Selemani. Kási, aha nyini aliho oómo óogwo ali mukúlu kuchila Selemani!” ");
INSERT INTO zin_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yeézu yaázeendelela kugaamba aáti, “Izimu kaliluga aha muuntu, lizeenda omu nsi yo obwoóma no kweéngeela óokwo lili omu kuloondela obuhuúmulo. Náho bubula, ");
INSERT INTO zin_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","izimu éelyo niligaámba nka nikwo, ‘Kaánsube owaánze áaho naálugile.’ Obuchilo nilisuba hali weényini, nilisaánga hali busa, hakukuumbilwe, no kutónwa kuluunzi. ");
INSERT INTO zin_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Niho lizeénda no kulaálika amazimu agáandi musaanzu áago gali amazilwa bwooli kuchila lyoónyini, góona geéza gamutaáhila ogwo muuntu. Niho obulami bwo omuuntu ogwo bulikuba bubi kusáaga óokwo bukaba buli aha bubaandizo. Nikwo biliiza kuba hali íimwe nyini abaantu bo obuchilo óobu bwo obuzilwa!” ");
INSERT INTO zin_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Obuchilo Yeézu achaáhooya ne embága ya abaantu abo, léeba nyina na badugu boómwe bakaba beémeeliile ahéelu, nibeénda kuhooya náwe. ");
INSERT INTO zin_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mbwéenu, omuuntu oómo yaámugaambila Yeézu aáti, “Léeba, nyoko na badugu baawe beemeeliile ahéelu, nibeénda kuhooya neewe.” ");
INSERT INTO zin_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeézu yaámugalulila aáti, “Máaha na badugu baanze ni baáhi?” ");
INSERT INTO zin_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Niho yaáyolekeza omukóno ha baheémba boómwe, yaábazila aáti, “Léeba, aba nibo máaha na badugu baanze! ");
INSERT INTO zin_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Habwo kuba omuuntu óogwo alikukola engoonzi za Táata ali omu igulu, ogwo niwe aba mulumuna waanze, munyaányeenye na niwe máaha.” ");
INSERT INTO zin_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Echilo éecho nyini, Yeézu akalugamo omu nzu ezo, yaázeenda yeekala aha ngeégeelo ye enyaanza. ");
INSERT INTO zin_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Echipípi chiháango cha abaantu chéeza, chaamukobaho Yeézu áaho akaba ali. Niho, yaáza omu bwáato, yeekala omwo, na abaantu baaba beemeeliile aha chaambo. ");
INSERT INTO zin_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mbwéenu, Yeézu yaábagaambila amagaambo méenzi naafumoolesa emigani, naazila aáti, “Akaba aliho omubíbi oómo óogwo akeemuka kuza omu musili gwoómwe kubiba embibo zoómwe. ");
INSERT INTO zin_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Obuchilo akaba naabiba, embibo ezíindi zikalagala omu muháanda, enyonyi zéeza, zaázilya. ");
INSERT INTO zin_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Embibo ezíindi zikalagala omu itaka liche aha luchili, zaamela bwaangu, habwo kuba itaka likaba lili liche kwoónka. ");
INSERT INTO zin_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Náho obuchilo omusana gwaatíile, gwaáyomesa éelyo itaka, embibo ziba zaáhotoka no okukaánzagala, habwo kuba emizi yaázo telabeele eyiziikile ahaansi bwooli. ");
INSERT INTO zin_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Embibo ezíindi zikalagala omu mahwa. Áaho amáhwa ago kagakuzile hamo ne emimelo, gaázimigisiliza. ");
INSERT INTO zin_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Embibo ezíindi zikalagala omu busi buluunzi. Áaho zaákomeela no kulába, kuluga eémo yaálaba amagoomba igana límo, ezíindi zaálaba eémo makúmi mukáaga ne ezíindi zaálaba eémo makúmi asatu. ");
INSERT INTO zin_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Óogwo ayina amatwi, ahuliilize!” ");
INSERT INTO zin_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abaheémba ba Yeézu beeza hali weényini no kumubúuza báti, “Na habwa chi noogaambisa emigani obuchilo noohóoya na abaantu?” ");
INSERT INTO zin_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yaábagalulila aáti, “Múungu abaheéle íimwe okusoombookelwa amagaambo ge entaahililo zo obukáma bwoómwe, náho boónyini tibakaheelwe okusoombookelwa ago. ");
INSERT INTO zin_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Manya sii, omuuntu óogwo aheelwe ebiintu akabikolesa emilimo, alyaágabilwa akanyise. Náho omuuntu weéna wéena óogwo aheelwe ebiintu náho akaleka kubikolesa emilimo, mazima na áako ayebikiliíze, alyaáyakwa. ");
INSERT INTO zin_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Niimbagaambila ha migani obuchilo niinhóoya nábo, habwo kuba kábalikuleeba áago ndikukola, náho tibakusoombookelwa ensoonga zaágo. Káandi, nibabona kuhulila áago ndikugaamba, náho tibakusoombookelwa ensoonga yaágo. ");
INSERT INTO zin_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ago nigakolwa gabone kuhikiilizwa áago omubáasi Isaya yaágaambile hali boónyini nka nikwo, ‘Kuhulila, muláaba nimuhulila, náho timulisoombookelwa nakáti. Kuleeba, muláaba nimuléeba, náho timulihweeza nakáti. ");
INSERT INTO zin_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bilyáaba bityo, habwo kuba emiganya ya abaantu aba, elemeéliilwe, tekwaanguha omu kusoombookelwa, na amatwi gáabo nigalemeela kuhulila, na baáhuumbiliize améeso gáabo. Byaakubeele bitali bityo, baakaáhweelize habwa améeso gáabo, baakaáhuliile habwa amatwi gáabo, baakaásoombookiilwe ha miganya yáabo, kuhicha baanhiindukile, mbone kubachíza.’ ");
INSERT INTO zin_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Mwiina omugisa habwo kuba améeso géenyu nigaléeba na habwo kuba amatwi gáanyu nigahulila. ");
INSERT INTO zin_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mazima butúnu niimbagaambila nka nikwo, hakaba heena ababáasi na abaantu abagololoke béenzi, bakaba nibabyeefúuza kuleeba ebyo bi mulikuleeba, náho tibalabibwéene. Káandi, éebyo bi mulikuhulila íimwe, bakaba nibabyeefúuza kubihulila, náho tibalabihuliile.” ");
INSERT INTO zin_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mbwéenu íimwe, muhuliilíze ensoonga yo omugani ogwo gwo omubíbi we embibo. ");
INSERT INTO zin_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Buli muuntu óogwo ahuliiliza echigaambo cho obukáma bwo omu igulu, náho takuchisoombookelwa, naasusana ne embibo éezo ezalageele héehi no muháanda. Éelyo Izilwa, Isitáani, niliíza no kusaakula éecho Múungu abibile omu muganya gwoómwe. ");
INSERT INTO zin_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Embibo éezo ezalageele aha luchili áaho ahatéena itaka líinzi, nizisusaniswa no omuuntu óogwo alikuhulila echigaambo cho obukáma bwo omu igulu, na ahonyini akachiínaankula aha manulilwa. ");
INSERT INTO zin_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Náho naakwaáta echigaambo che empola ezo aha mwáanya muche kwoónka, habwo kuba okwiikiliza kwoómwe tikulabeele ne emizi bwooli. Keélaaba ebyaágalalo ne ennáku nibimugwéela habwe echigaambo echo, áaho na áaho nibimukuumpisa naakuleka okwiikilizákwe. ");
INSERT INTO zin_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Embibo éezo ezalageele omu mahwa, nizisusaniswa no omuuntu ogwo alikuhulila echigaambo cho obukáma bwo omu igulu, náho naabeéhwa ne ebitahatahiso bye éensi ezi ne etuúnku za amabonwa méenzi. Ne éebyo nibimiga echigaambo cho obukáma bwo omu igulu na tekuhicha kulaba amagoomba omu bulami bwaáyo. ");
INSERT INTO zin_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Náho embibo éezo ezalageele omu busi buluunzi, nizisusaniswa no omuuntu óogwo alikuhulila echigaambo cho obukáma bwo omu igulu no kucheétegeeleza. Ha bwéecho omuuntu nko ogwo niwe alisohoza amagoomba omu bulami bwoómwe, oómo entúlo igana, oóndi entúlo makúmi mukáaga no oóndi entúlo makúmi asatu.” ");
INSERT INTO zin_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeézu yaábachweela omugani ogúundi aáti, “Obukáma bwo omu igulu nibususana no omuuntu óogwo akabiba embibo nduunzi omu musili gwoómwe. ");
INSERT INTO zin_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Náho obuchilo óobwo abaantu kábaabeele bahuniile, omubisa woómwe yéeza, yaabibamo omwáata omu ngano, yaámala yaázeenda. ");
INSERT INTO zin_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Obuchilo engano ezo ekaba yaámela no kubaanza kusaambulula, niho omwáata nágwo nigubonwa. ");
INSERT INTO zin_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Abazáana ba kanyina wo omusili beeza, baámubúuza nka nikwo, ‘Íiwe mukáma, nitusoomboókelwa nka nikwo okabiba embibo nduunzi omu musili gwaawe. Óobu, omwáata ogu gwaáluga nkáhi?’ ");
INSERT INTO zin_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yaábagalulila aáti, ‘Omubisa niwe ogwo akozile aátyo.’ Abazáana boómwe baámubúuza nka nikwo, ‘Ngási nooyeénda tuzeénde tugubagalemo omwáata ogwo?’ ");
INSERT INTO zin_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Náwe yaágaamba aáti, ‘Mmahi, mutagabagalamo, habwo kuba kamwaakuba nimubagala omwáata, mukaáhuumbilamo ne engano muzinyukula. ");
INSERT INTO zin_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Muleke byóona bikule hamo, kuhicha obuchilo bwi igesa. Obuchilo óobwo, niimbagaambila abagesi nka nikwo ha kubaanza bakobye omwáata no kugukoma ebiba babone kugoocha. Niho bahiche kugesa engano na bazihunike omu chitála chaanze.’ ” ");
INSERT INTO zin_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeézu yaábachweela omugani ogúundi aáti, “Obukáma bwo omu igulu nibususana nko oluzuma luche lwe ehaladáali óolwo omuuntu akatwaala no kulubiba omu nsaambo yoómwe. ");
INSERT INTO zin_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Oluzuma olwo ni luche bwooli kuchila enzuma ezíindi zóona, náho kalulikumela niguba omuti muháango kuchila emiti yóona omu musili. Omu muti ogwo enyonyi ziíza, zeékala omu matábazi gaágwo.” ");
INSERT INTO zin_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeézu yaábachweela omugani ogúundi aáti, “Obukáma bwo omu igulu nibususana ni ituumbyo éelyo omukázi alikutwáala no kutulaaniza ne ensaano ye engano ye embalililo ye ebitukulu bísatu. Ituumbyo éelyo nilileeteelela ensaano ye engano yóona kutuumba.” ");
INSERT INTO zin_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yeézu akaba naagaambila ebipípi bya abaantu ameégeso áago habwo kugaambisa emigani. Talabeégesize choóna chóona atéena kugaambisa emigani. ");
INSERT INTO zin_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Áago gakakolwa gátyo, kubona kuhikiilila echigaambo éecho Múungu akagaambisa omubáasi woómwe aáti, “Ndaáhooya na abaantu habwo omuháanda gwe emigani. Ndaábagaambila amagaambo áago agaselekilwe kulugiilila kuhaangwa kwe éensi.” ");
INSERT INTO zin_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mbwéenu, Yeézu yaálaga ebipípi bya abaantu, yaátaaha omu nzu. Abaheémba boómwe beeza hali weényini, baámugaambila báti, “Tusasaánulile ensoonga yo omugani ogwo gwo omwáata óogwo gukaba guli omu musili.” ");
INSERT INTO zin_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yeézu yaábagalulila aáti, “Omuuntu óogwo akabiba embibo enduunzi, naasusana neenye Omutábani wo Omuuntu. ");
INSERT INTO zin_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Omusili nu niyo éensi, embibo nduunzi nizo abaantu bo obukáma bwo omu igulu, no omwáata nibo abaantu be éelyo Izilwa, Isitáani. ");
INSERT INTO zin_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Omubisa óogwo ekeeza kubiba omwáata nilyo Isitáani. Obuchilo bwi igesa nigwo omuhélo gwe éensi ezi, na abagesi nibo bamaléeka ba Múungu. ");
INSERT INTO zin_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Nikwo abahálila ba kanyina bo omusili balaákumakuma no kwóocha omwáata omu mulilo, nikwo bityo nyini chilyáaba aha muhélo gwe éensi ezi. ");
INSERT INTO zin_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Íinye Omutábani wo Omuuntu, ndyaásiindika bamaléeka baanze, babone kusuumbya kuluga omu bukáma bwaanze bóona abali enkola bíbi hamo na áabo abalikuleételela abáandi bakole ebiheno. ");
INSERT INTO zin_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Maléeka abo balyaábanaga abaheni abo bóona omu lyookezo lyo omulilo. Omwo nimwo baláaba nibachula no kusa améeno. ");
INSERT INTO zin_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Niho abagololoke omu méeso ga Múungu, baláaba nibaáka nki izóoba omu bukáma bwe Isébo. Óogwo ayina amatwi, ahuliilize!” ");
INSERT INTO zin_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Niho Yeézu yaásohoza omugani ogúundi, yaábazila aáti, “Obukáma bwo omu igulu nibususana ne ensabo yo obukaani buháango éezo ekaba eselekilwe omu nsaambo. Chilo chimo, obuchilo omuuntu oómo akaba naasuma yaázikugula, yaáza kuziseleka káandi. Mbwéenu akanulilwa bwooli, yaázeenda kutuunda ebiintu byóona éebyo akaba ayinabyo, yaázigula ensaambo ezo. ");
INSERT INTO zin_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Káandi, obukáma bwo omu igulu bweeleenga nko omuuntu omutuunzi oómo óogwo alikweenda kuloondela enkwaanzi nduunzi. ");
INSERT INTO zin_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kayeezile yaazigwáho enkwaanzi eémo yo obukaani buháango bwooli, yaázeenda kutuunda ebiintúbye byóona éebyo akaba ayinabyo, yaázigula ezo nkwáanzi yo obukaani buháango bwooli.” ");
INSERT INTO zin_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yeézu yaásohoza omugani ogúundi, naagaámba aáti, “Káandi, obukáma bwo omu igulu nibususana no omutego óogwo abategi baázeenda nágwo kutéga omu nyaanza. Omutego óogwo gukafa kuyoola buli nfwi za buli lugaanda. ");
INSERT INTO zin_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Obuchilo omutego óogwo gweézwiile, abategi baákweeseza aha chaambo. Niho, beékala ahaansi, baákobeza eénfwi nzima, nibazita omu bitukulu. Náho éezo nfwi mbi, bakazizugunya. ");
INSERT INTO zin_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bityo nikwo chilyáaba ha muhélo gwe éensi ezi. Bamaléeka nibeéza no kutaáganisa enkola bíbi na áabo abagololoke omu méeso ga Múungu. ");
INSERT INTO zin_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Bamale babanaguze enkola bíbi omu lyookezo lyo omulilo. Omwo nimwo baláaba nibachula no kusa améeno.” ");
INSERT INTO zin_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeézu yaábúuza abaheémba boómwe aáti, “Ngási, mwaásoombookelwa góona áago naábasoomboolela?” Nábo baámusubiza báti, “Éego, twaásoombookelwa.” ");
INSERT INTO zin_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Náwe yaábagaambila aáti, “Omweégesa weéna wéena we ebilagilo óogwo ayaayegesizwe amagaambo go obukáma bwo omu igulu, naasusana nyineéka óogwo asohoza omu nsabo yoómwe ebiintu ebisha ne bya kala.” ");
INSERT INTO zin_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yeézu káyaabeele yaámazile kusohoza emigani ezo, yaalugáho aho, ");
INSERT INTO zin_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","yaázeenda omu muzihwa gwo owaabo. Obuchilo yaáhikile óokwo Nazaréeti, yaábaanza kweégesa abaantu omu isomelo lyáabo. Abaantu baásobelwa bwooli, beébuuza báti, “Omuuntu ogu abwiihile nkáhi obwéenze óobu? Na nkáhi abonesize obuzizi bwo kukola amahano aga? ");
INSERT INTO zin_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ogu ti mutábani wo omusala miti oóli? Ni izíina lya nyina tíwe Mariamu? Na abalumuna boómwe tibo ba Yakobo, Yozéfu, Simoni na Yuda? ");
INSERT INTO zin_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na banyáanya iínti nibo áabo tutuula nábo aha? Mbwéenu, ogu ageehile nkáhi amagaambo góona aga?” ");
INSERT INTO zin_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Abaantu abo baásaaya, chaaletelela baáyaanga kumwiíkiliza. Niho Yeézu yaábagaambila aáti, “Omubáasi akuzibwa hoóna hóona náho ti mu muzihwa gwoómwe nali omukáye.” ");
INSERT INTO zin_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mbwéenu, Yeézu talakozile amahano méenzi okwo, habwo kuba abaantu abo tibalamwiíkiliize. ");
INSERT INTO zin_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Obuchilo obwo, omukáma Herode Antipasi akaba ali omutégeki wa Galiláaya. Obuchilo yaáhuliile ebikolwa éebyo Yeézu akaba naakola, ");
INSERT INTO zin_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yaábagaambila abazáana boómwe aáti, “Omuuntu ogwo ni Yohana Omubatiza! Yaázoolwa kuluga omu bafwiile! Niyo ensoonga ayina amagala go kukola amahano maháango nka ago.” ");
INSERT INTO zin_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herode akahooya aátyo, habwo kuba akaba amukwaasile Yohana, yaámukoma no kumuta omu ibóhelo. Akaba amubohile, habwa amagaambo ga Yohana habwo okusweélana kwo mwa Herode na Herodia. Herodia ogwo, aha bubaandizo akaba ali muka Filipo, ali mweene wáabo na Herode. ");
INSERT INTO zin_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ha bwéecho, Yohana akaba naamusoomboólela Herode aáti, “No omuzilo omu méeso ga Múungu kumuswéela omukázi wa mudugu waawe obuchilo achaali achili omulame.” ");
INSERT INTO zin_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mbwéenu, Herode akaba naaloondela omuháanda gwo kumwíita Yohana, náho akaba naatiína abaantu, habwo kuba bakaba nibamuleeba Yohana nko omubáasi wa Múungu. ");
INSERT INTO zin_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Obuchilo bwa amazenyi go kuzaalwa kwa Herode, enkuuba ali muhala wa Herodia yéeza kunegula omu méeso ga abazenyi. Herode akanulilwa bwooli. ");
INSERT INTO zin_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Niho yaálahila kumúha choóna chóona éecho alaámusaba. ");
INSERT INTO zin_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Omuhalákazi ogwo yahaniililwa na nyina, yaámugaambila Herode aáti, “Oómpe omútwe gwa Yohana Omubatiza aha lutemele.” ");
INSERT INTO zin_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Omukáma Herode yaázuzubalilwa, náho habwo okulahila omu méeso ga abazenyi boómwe, yaálagila nka nikwo omuhala aheébwe. ");
INSERT INTO zin_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mbwéenu, Herode yaásiindika omuuntu azeénde omu ibóhelo, náwe yaámutema omútwe Yohana. ");
INSERT INTO zin_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Niho yaásuba no omútwe gwa Yohana aha lutemele, yaágumuheéleleza omuhala ogwo, náwe yaágumutwaálila nyina. ");
INSERT INTO zin_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Obuchilo abaheémba ba Yohana baáhuliile empola ezo, beeza kusutula omutúumbi, baázeenda kuguziika. Kabamazile, baázeenda kuteékelela Yeézu góona áago agabeele. ");
INSERT INTO zin_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ahonyini, Yeézu káyaahuliize ago, yaalugáyo kuliinya, yaálaba omu bwáato, yaáza bweeseléke omu mwáanya ogutalimo abaantu. Náho obuchilo ebipípi bya abaantu byaahuliize ahaantu áaho akaba naazeénda, baaluga omu maboma gáabo, baábalama lwa amagulu kumukulaatila Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Náwe káyaahikile, yaábona embága mpaango ya abaantu, yaábaganyila, yaáchiza abalwéele. ");
INSERT INTO zin_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Izóoba kalyaaheenzile omukóno, abaheémba boómwe beeza hali weényini nibagaámba báti, “Aha tuli no omu chitúuntu ne ensiimbaazi yeéliliza. Obalage abaantu aba beezeéndele omu mitúulo beégulile ebyookulya.” ");
INSERT INTO zin_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeézu yaábagalulila aáti, “Batwaálweyo chi? Íimwe, nimubahe ebyookulya.” ");
INSERT INTO zin_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nábo baámusubiza báti, “Titwíina chi twiinácho! Náho twiinayo emikaate itaanu ne eénfwi ibili zoónka.” ");
INSERT INTO zin_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yeézu yaábagaambila aáti, “Nimubiindeétele aha.” ");
INSERT INTO zin_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mbwéenu, yaálagila ebipípi ebyo bya abaantu beekale ahaansi, aha mwaalilo gwo obunyaansi. Yaáyanaankula emikaate itaanu ezo ne eénfwi ezo ibili, yaálalamila omu igulu, yaámusiima Múungu. Niho yaázimenyula, yaáziha abaheémba boómwe emikaate hamo ne eénfwi, nábo baábaheéleza ebipípi éebyo bya abaantu. ");
INSERT INTO zin_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Abaantu bóona baálya, baáhaaga. Niho, abaheémba boómwe baátwáala emisige, beezuza ebitukulu ikúmi na bibili. ");
INSERT INTO zin_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Abaantu áabo bakalya ebyookulya ebyo, bakaba bali abaséeza ebihuumbi bitaanu, hatéena kubala abakázi na abáana. ");
INSERT INTO zin_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ahonyini, Yeézu yaázemeleza abaheémba boómwe nka nikwo, bahanáme omu bwáato, beebeembele kuzeenda buseeli bwe enyaanza, obuchilo óobwo weényini akaba achaálagana ne ebipípi bya abaantu. ");
INSERT INTO zin_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Obuchilo Yeézu káyaamazile kulaga ebipípi ebyo bya abaantu, yaáhanama omu ibaanga weénka kusaba Múungu. Obuchilo kiyahikile ensiimbaazi, akaba achiliyo óokwo omu ibaanga weénka. ");
INSERT INTO zin_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Obuchilo obwo, obwáato bwaáhikile obuziba bwaátéelwa omuyaga gwe eéntwe, habwo kuba enyaanza ekaba ebiíhile. ");
INSERT INTO zin_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mbwéenu obuchilo heéliliile amacheelelélwa Yeézu yaabeezáho, naalibata aha nyaanza. ");
INSERT INTO zin_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Obuchilo abaheémba boómwe kábaamubwéene Yeézu naalibata aha lugulu ya améenzi, beétimwa bwooli, no kutéela empámo nibagaámba, “Éechi ne echimunyaamunya!” ");
INSERT INTO zin_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ahonyini, Yeézu yaábagaambila aáti, “Mutiímbye omuganya, mutatiina! Níinye.” ");
INSERT INTO zin_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peétero yaámugalulila aáti, “Íiwe Omukáma, kábilaaba níiwe mazima, ndagila nka nikwo nkwiizého áaho oóli, kunu niindibata aha lugulu ya méenzi.” ");
INSERT INTO zin_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeézu yaámugalulila aáti, “Iíza!” Niho, Peétero yaalugamo omu bwáato, yaábaanza kulibata aha lugulu ya méenzi kuzeenda ahali Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Náho akabona echiihúle chiháango nichiíza, Peétero yaátíina bwooli, yaábaanza kutoontobela omu méenzi. Yaáyaambaza ahi iláka aáti, “Íiwe Mukáma, nchuúngulaa!” ");
INSERT INTO zin_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ahonyini, Yeézu yaágolola omukóno, yaámukwáata, yaámugaambila aáti, “Íiwe owo okwiikiliza kuche, ha bwaáchi obeele oyina okutahwa tahwa?” ");
INSERT INTO zin_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Obuchilo Yeézu na Peétero baáhanamíle omu bwáato, haaba echineembe. ");
INSERT INTO zin_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mbwéenu, abaheémba abaabeele bali omu bwáato baámulamya Yeézu. Baágaamba báti, “Mazima, íiwe oli Mutábani wa Múungu!” ");
INSERT INTO zin_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Obuchilo Yeézu na abaheémba boómwe baayaambukile enyaanza, baáhika omu nsi ya Genezareti. ");
INSERT INTO zin_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Obuchilo abaantu ba ahaantu aho baámumanyile nka nikwo ni Yeézu, baáyatula empola zoómwe omu nsi ezo. Niho, abaantu beeza no kumuleétela Yeézu abalwéele báabo. ");
INSERT INTO zin_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nábo baámuleémbeleza Yeézu abakuúndile abalwéele bakoleho no óobu aha lukugilo lwe ebizwaalóbye kwoónka. Niho abalwéele bóona áabo abaabeele bákolaho, bakachila. ");
INSERT INTO zin_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Niho, Abafarisayo na abeégesa be ebilagilo bya Musa bakaluga Yeruzaléemu beeza hali Yeézu, baámubúuza báti, ");
INSERT INTO zin_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ha bwaáchi abaheémba baawe nibahenela obuteéka óobwo besiichwe enkúlu bakatusigila? Ha bwaáchi nibalya ebyookulya obutanáaba engalo záabo nka nikwo elikweendelwa!” ");
INSERT INTO zin_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeézu yaábagalulila aáti, “Ha bwaáchi neemwe nimuhenela ebilagilo bya Múungu habwo kukulaatila obuteéka bwáanyu? ");
INSERT INTO zin_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Múungu akagaamba, ‘Obakúze iíso na nyoko.’ Káandi akagaamba, ‘Weéna wéena óogwo alikuzuma iíse nali nyina, kufwa na aáfwe.’ ");
INSERT INTO zin_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Náho íimwe omu kweégesa kwáanyu mugaámba nka nikwo, omuuntu naayikililizibwa kumugaambila iíse nali nyina nka nikwo, ‘Ebiintu éebyo ebilikukugasa íinye kukuhweela, naámazile kubisohoza ahali Múungu nke echitáambo.’ ");
INSERT INTO zin_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Bityo nimweegesa nka nikwo omuuntu takweendelwa kumukúza iíse nali nyina. Nikwo musuúcha echigaambo cha Múungu habwo kukulaatila obuteéka bwáanyu. ");
INSERT INTO zin_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Íimwe ngóbya mwe! Múungu akagaamba mazima ha bwéenyu kulabila omubáasi woómwe Isaya nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Abaantu aba nibaankúza aha bigaambo kwoónka, náho emiganya yáabo eli hala neenye. ");
INSERT INTO zin_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nibaanyeseengeleza busa, habwo kuba amagaambo áago balikweégesa ne ebilagilo bya abaantu.’” ");
INSERT INTO zin_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Niho, Yeézu kwéeta embága ya abaantu, yaábagaambila aáti, ");
INSERT INTO zin_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","“Nimuhuliilíze mweétegeeleze, na musoomboókelwe amagaambo áago ndikubagaambila! Echiza omu kanwa ticho chimulofola omuuntu. Náho, amagaambo áago agalikuluga omu kanwa koómwe, nigo agali kumukola omuuntu kuba omulofo.” ");
INSERT INTO zin_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Niho abaheémba ba Yeézu baázeenda hali weényini, baámubúuza báti, “Ngási noomanya Abafarisayo obuchilo bahuliile omulagi gwe echigaambo chaawe, gukabatamisa bwooli?” ");
INSERT INTO zin_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeézu yaábagalulila aáti, “Emimelo yoóna yóona éezo Táata wo omu igulu talazihaambile, naazinyukula. ");
INSERT INTO zin_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Áabo nimubaleke, abahume abalikweébeembelela abahume! Manya, omuhume kayebeembelela omuhume, bóona bábili nibagwa omu liina.” ");
INSERT INTO zin_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mbwéenu, Peétero yaámugaambila Yeézu aáti, “Tugaambile entaahililo yo ogwo mugani.” ");
INSERT INTO zin_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeézu yaágaamba aáti, “Ngási, íimwe muchili abalogwéezi muti? ");
INSERT INTO zin_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Timumanya echiza omu kanwa, kachilabila omuunda chikazeenda kusohola omu mubili? ");
INSERT INTO zin_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Náho ebiluga omu kanwa ko omuuntu, biba bilugile aha muganya gwoómwe. Éebyo nibyo ebilikumukola omuuntu kuba omulofo. ");
INSERT INTO zin_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Omu muganya gwo omuuntu, omwo niho biluga ebiteékuzo bíbi, byo obwíisi, obusaambani, obuseégu, olukóno, buulubona bwo kuteéleleza ebisuba no kulyoogooza. ");
INSERT INTO zin_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Góona áago, nigo gamukola omuuntu kuba omulofo. Náho omuuntu kulya ebyookulya atabaandize kunaaba engalo tikukumukola kuba omulofo.” ");
INSERT INTO zin_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mále, Yeézu yaalugáho aho, yaázeenda obwaátana bwe ebyaalo bya Tíilo na Sidóoni. ");
INSERT INTO zin_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Niho yaábugana no omukázi oómo, óogwo akaba ali Omukanáani wo omu chaalo echo. Yeeza hali Yeézu, yaáyaambaza ahi iláka liháango aáti, “Íiwe Mukáma, Mutábani wa Daudi, onzilile echiganyizi! Muhala waanze atuungamiilwe bwooli ni izimu libi.” ");
INSERT INTO zin_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Náho Yeézu talamugaluliile echigaambo choóna chóona. Niho, abaheémba boómwe baamwiizáho no kumusaba báti, “Omugaambile ogu mukázi azeénde, ha kuba naatukulaatila enyuma kunu naatuhama.” ");
INSERT INTO zin_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yaágalula aáti, “Múungu akaansiíndika habwa Abaiziraeli boónka, habwo kuba bali nke entaama éezo ezaáhabile.” ");
INSERT INTO zin_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Omukázi ogwo yaamwiililáho Yeézu, yaáteela ebizwi omu méeso goómwe, yaámusaba aáti, “Íiwe Mukáma, onzune!” ");
INSERT INTO zin_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yaámugalulila aáti, “Ti kuzima kutwáala ebyookulya bya abayaánda no kubinagila eémbwa.” ");
INSERT INTO zin_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Omukázi ogwo yaámuzila aáti, “Nikwo bili Mukáma, náho no óobu eémbwa názo nizilya amasige áago agalageele ahaansi kuluga aha meéza ya abakáma báabo.” ");
INSERT INTO zin_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yeézu yaámugalulila aáti, “Íiwe mukázi, oyina okwiikiliza kuháango! Chibe hali íiwe nka nikwo olikweenda.” Ahonyini, omuhala yaachila. ");
INSERT INTO zin_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeézu yaáluga aho, yaázeenda kulabila omu ngeégeelo ye enyaanza ya Galiláaya. Yaáhanama omu ibaanga no kwíikala okwo. ");
INSERT INTO zin_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ebipípi biháango bwooli byaázeenda hali Yeézu, bamuletela enziíngami, abahume, abalema, abatita na abalwéele abáandi béenzi. Abaantu abo baábata abalwéele héehi na amagulu ga Yeézu, náwe yaábachiza. ");
INSERT INTO zin_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Abaantu baásobelwa bwooli obuchilo kábaabweene abatita nibagaamba gaamba, abalema bachizile, enziíngami nizilibata na abahume nibahweéza. Baábaanza kumukúza Múungu wa Abaiziraeli. ");
INSERT INTO zin_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Niho Yeézu yaáyéta abaheembábe, yaábagaambila aáti, “Echi ne echilo cha kásatu abaantu aba tweékeele nábo, na tibéena choóna chóona chookulya, nicho chaambonesa mbazilile echiganyizi. Tiínkweenda mbalage bazeénde beena enzala, bateéza bakalába bakagwa omu muháanda.” ");
INSERT INTO zin_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abaheémba boómwe baámugaambila báti, “Tuli omu iluungu, na abaantu ni béenzi bwooli. Ngási, tukaáhicha kubonesa nkáhi emikaate éezo ehikile ha kubahaagisa bóona?” ");
INSERT INTO zin_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeézu yaábabúuza aáti, “Mwiina emikaate engáhi?” Baámusubiza báti, “Twiina emikaate musaanzu no otufwi tufwi tuche kwoónka.” ");
INSERT INTO zin_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mbwéenu, Yeézu yaálagila abaantu bóona nka nikwo beekale ahaansi. ");
INSERT INTO zin_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yeemucha emikaate musaanzu ezo ne eénfwi ezo, yaásiima Múungu. Niho, yaágumenyula, yaábaanza kubaha abaheémba boómwe, nábo abaheémba baáheeleleza embága ya abaantu. ");
INSERT INTO zin_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Abaantu bóona baálya, baáhaaga. Niho, abaheémba baátulaaniza amasaága ge ebyookulya, beezuza ebitukulu musaanzu. ");
INSERT INTO zin_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Abaantu áabo abalíile ebyookulya éebyo bakaba bali abaséeza ebihuumbi bina, batéena kubala abakázi na abáana. ");
INSERT INTO zin_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mbwéenu, Yeézu yaábalaga abaantu áabo, yaátaaha omu bwáato, yaázeenda omuli Magadani. ");
INSERT INTO zin_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Niho Abafarisayo na Abasadukayo beeza hali Yeézu, baámuleengesa ha kumusaba akole olumanyiso kuboóleka boónyini nka nikwo atweekilwe na Múungu. ");
INSERT INTO zin_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yeézu yaábasubiza nka nikwo, “Obuchilo bwo olweébazo, íimwe nimuhicha kugaamba muti, ‘Nyeéncha obwíile nibucháze, habwo kuba igulu lyaátukula.’ ");
INSERT INTO zin_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Káandi obuchilo bwe enchaákala nimuhicha kugaamba muti, ‘Leélo omuyaga nigwiíha, habwo kuba igulu litukwiile no bwíile buhiikile.’ Bityo kási, íimwe nimumanya kusoombookelwa akaleebele ko obwíile, náho nimulémwa kweétegeeleza emanyiso za akachilo! ");
INSERT INTO zin_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Íimwe no oluzáalo lubi lwa abaantu abaheni na timuli abeésigwa omu méeso ga Múungu, niyo nsoonga nimweénda olumanyiso. Tiínkubakolela olumanyiso lwoóna lwóona. Náho olumanyiso lúmo óolwo mulaabona ni nko óokwo Múungu akakola aha mubáasi Yona.” Niho Yeézu yaabalugaho, yaázeenda. ");
INSERT INTO zin_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mbwéenu, abaheémba ba Yeézu baáyaambuka buseeli bwe enyaanza, náho bakeebwa kuzeenda ne emikaate. ");
INSERT INTO zin_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeézu yaábagaambila aáti, “Mube méeso, mweécheenge ni ituumbyo lya Abafarisayo na Abasadukayo.” ");
INSERT INTO zin_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Abaheémba boómwe baábaanza kuteéka téeka báti, “Naagaámba aátyo habwo kuba titwaáleeta emikaate.” ");
INSERT INTO zin_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeézu akamanya ebyo bakaba nibateékateéka, yaágaamba aáti, “Íimwe abaantu bo okwiikiliza kuche! Ha bwaáchi íimwe nimuteékateéka mweénka nka nikwo mutéena emikaate? ");
INSERT INTO zin_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kuhika óobu, mucháali kusoombookelwa? Timukwiizuka nka nikwo abaantu ebihuumbi bitaanu bakahaaga emikaate ezo itaanu? Amasaága mukeezuza ebitukulu biingáhi? ");
INSERT INTO zin_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nali timukwiizukila aha mikaate ezo musaanzu ha baantu ebihuumbi bina? Amasaága mukeezuza ebitukulu biingáhi? ");
INSERT INTO zin_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ha bwaáchi mwaásíingwa kusoombookelwa nka nikwo áago naágaamba ti habwe emikaate? Mbwéenu, éecho ndikugaamba ni nka nikwo, mweécheenge ni ituumbyo lya Abafarisayo na Abasadukayo.” ");
INSERT INTO zin_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Niho, abaheémba boómwe kusoombookelwa nka nikwo akaba atakuhooyela ha kweécheenga ni ituumbyo lyo kutuumbisa emikaate, náho ha kweécheenga na ameégeso ge ebisuba ga Abafarisayo na Abasadukayo. ");
INSERT INTO zin_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Obuchilo Yeézu yaáhikile aha lubazu lwe echaalo ahakaba niheétwa Kaizáaria‑Filipi, yaábabúuza abaheémba boómwe aáti, “Abaantu nibagaámba nka nikwo, íinye Mutábani wo Omuuntu, ndi oóha?” ");
INSERT INTO zin_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Baámusubiza báti, “Abáandi nibagaámba nka nikwo íiwe níiwe Yohana Omubatiza, abáandi nibagaámba nka nikwo íiwe níiwe Eliya na abáandi nibagaámba nka nikwo íiwe níiwe Yeremia nali, oli omubáasi oóndi wa kala wa Múungu.” ");
INSERT INTO zin_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yeézu yaábabúuza aáti, “Ngási, neemwe nimugaámba íinye ndi oóha?” ");
INSERT INTO zin_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Peétero yaámugalulila aáti, “Íiwe níiwe Masihi, Mutábani wa Múungu ogwo ali omulame.” ");
INSERT INTO zin_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeézu yaámugaambila Peétero aáti, “Íiwe Simoni mutábani wa Yona, oyine omugisa, habwo kuba táliho omuuntu weéna wéena ayaákusuululila amazima aga, náho ni Táata owo omu igulu. ");
INSERT INTO zin_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Neenye niinkugaambila nka nikwo íiwe níiwe Peétero, na ahali óolu luchili, niho ndaayoombeka ekelezia yaanze, na amagala go olufu tigakuzisiinga nakáti. ");
INSERT INTO zin_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ndaákuha íiwe hanu enchiínguzo zo obukáma bwo omu igulu, na góona áago olikoma omu nsi ezi, náwe Múungu naába yaágakoma kuluga omu igulu. Káandi, góona áago olikomoolola omu nsi ezi, náwe Múungu naába yaágakomoolola kuluga omu igulu.” ");
INSERT INTO zin_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Niho Yeézu yaábahana abaheémba boómwe nka nikwo, bateéza kumugaambila omuuntu weéna wéena nka nikwo weényini niwe Masihi. ");
INSERT INTO zin_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kulugiilila akachilo áako nyini, Yeézu yaábaanza kubateékelela abaheémba boómwe butúnu aáti, “Ni lwaampaka nzeénde omuli Yeruzaléemu, no kubona ebyaágalalo byo obusaasi bwíinzi. Káandi ni lwaampaka nnyagalazwe na abanyaampala ba Abayahudi, na abakúlu ba abagabe ba Múungu na abeégesa be ebilagilo bya Musa, kuhicha nnyítwe. Náho echilo cha kásatu, mazima Múungu alyaánzoola.” ");
INSERT INTO zin_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Niho, Peétero yaátwáala Yeézu ha lubazu, yaábaanza kumuchaáhukila aáti, “Íiwe Mukáma, Múungu agahigize ago hala! Gataákwiiza gakakusaanga íiwe ago!” ");
INSERT INTO zin_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Náho Yeézu yaámuhiindukila Peétero, yaámugaambila aáti, “Íiwe Isitáani, galuka enyuma yaanze! Nooleengésa kuunyaángila kukola áago Múungu ayeénda, habwo kuba, ebiteékuzo byaawe ne bya abaantu kwoónka náho ti bya Múungu.” ");
INSERT INTO zin_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mbwéenu, Yeézu yaábagaambila abaheémba boómwe aáti, “Kaálaaba omuuntu weéna wéena naaloonda kuba omuheémba waanze, naayeéndelwa aleke kukuláatila ebiteékuzo byoómwe, asutule omusalaba gwoómwe, ankulaatile. ");
INSERT INTO zin_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Omuuntu óogwo alikweenda kuchuúngula obulami bwoómwe, niwe alyaábubuza. Náho omuuntu óogwo alibuza obulami bwoómwe ha bwaánze, ogwo niwe alaabubonesa. ");
INSERT INTO zin_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ngási omuuntu abona mugaso chi kaálaabonesa byóona ebyo omu nsi ezi, náho akabuza obulami bwoómwe? Óobu, omuuntu yaakaáhicha kusohoza chiintu chi cho kubonesa kumusubiza obulami bwoómwe? ");
INSERT INTO zin_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Íinye Mutábani wo Omuuntu, ndéeza hamo na bamaléeka baanze omu ikuzo lya Táata. Niho ndimuheela kati muuntu kwiingana ne ebikolwa byoómwe. ");
INSERT INTO zin_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mazima butúnu niimbagaambila nka nikwo, heena abaantu omuli aba abeémeeliile aha áabo tibalifwa bachaali kubona íinye Mutábani wo Omuuntu niinyiza omu bukáma bwaanze.” ");
INSERT INTO zin_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Obuchilo byaáhiíngwiile ebilo mukáaga, Yeézu yeemucha Peétero, Yakobo na Yohana omulumuna wa Yakobo. Yaáhanama nábo omu ibaanga lila, ahaantu áaho hakaba hatéena baantu. ");
INSERT INTO zin_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Obuchilo bali aho, Yeézu yaábahiinduka kúundi ensuso yoómwe omu méeso gáabo. Obuso bwoómwe bwaáyaka nki izóoba ne ebizwáalo byoómwe byaáyela bwooli nko omwaanga. ");
INSERT INTO zin_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ahonyini, baábona Musa na Eliya nibagaamba gaamba náze. ");
INSERT INTO zin_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Niho Peétero yaámugaambila Yeézu aáti, “Íiwe Mukáma, ni kuluunzi íichwe tuliho aha. Kolaayeenda, nnyoombeke aha otutiindi túsatu. Kámo kabe akaawe, akáandi kabe aka Musa, na akáandi kabe aka Eliya.” ");
INSERT INTO zin_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Obuchilo Peétero atakamazile kuhooya, ahonyini léeba, lyéeza elíile éelyo lilikweengelela lyaábasweekelela. Niho bahulila iláka kuluga omu líile elyo niligaámba liti, “Ogu niwe Mutábani waanze engaanzi, óogwo nnyesiimaho náze. Mumuhuliilíze weényini!” ");
INSERT INTO zin_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Obuchilo abaheémba boómwe bahuliile ago, baátíina bwooli, báagwa ahaansi buzuúma. ");
INSERT INTO zin_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeézu yeelila héehi nábo, yaabakwaataho, yaábagaambila aáti, “Mwiimeelele, mutatiina!” ");
INSERT INTO zin_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Obuchilo baáyinamwiile améeso gáabo, baábona tihachiina muuntu náho yaásigeeleho Yeézu weénka. ");
INSERT INTO zin_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Obuchilo bakaba nibagolomoka omu ibaanga aho, Yeézu yaábalagila aáti, “Mutaákwiiza kumugaambila omuuntu weéna wéena áago mwaábona kuhika obuchilo óobwo íinye, Omutábani wo Omuuntu, ndaázoolwa kuluga omu bafwiile.” ");
INSERT INTO zin_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abaheémba abo baámubúuza báti, “Óobu ha bwaáchi abeégesa be ebilagilo bya Musa bagaámba nka nikwo, ni lwaampaka Eliya amweébeembelele Masihi kwíiza?” ");
INSERT INTO zin_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeézu yaábasubiza aáti, “Nikwo bili, Eliya naayebeembela kwíiza na alyaáloonza kuzima ebiintu byóona. ");
INSERT INTO zin_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Káandi, niimbagaambila nka nikwo Eliya yaámazile kwiiza, náho abaantu tibalamusoombookiliwe, baámukolela góona amábi óokwo baabeele nibeénda. Bityo nyini neenye Mutábani wo Omuuntu, niinyagalazwa omu ngalo záabo.” ");
INSERT INTO zin_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Niho abaheémba boómwe basoombookelwa nka nikwo Yeézu akaba naahoóyela habwa Yohana Omubatiza. ");
INSERT INTO zin_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Obuchilo Yeézu na abaheémba boómwe kabaahikile aha mbága ezo ya abaantu, omuuntu oómo yéeza hali Yeézu, yaátéela ebizwi. Yaágaambila Yeézu aáti, ");
INSERT INTO zin_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Íiwe Mukáma, niinsaba omuzilile echiganyizi omwaana waanze! Agwa ebisiimbo, ne endwáala ezo emukola ayagalale kubi bwooli, kuba entúlo nyíinzi tayosa kweéchekula omu mulilo nali kweénaga omu méenzi. ");
INSERT INTO zin_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ndamuleétiile abaheémba baawe babone kumuchiiza, náho baalemilwe.” ");
INSERT INTO zin_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeézu yaásubya aáti, “Íimwe abaantu be enchilo ezi zo kwáanga kwiikiliza, mwaátumaangile kubi, niinyikala neemwe no kubeémela kuhicha li? Mumuléete omusígazi hali íinye!” ");
INSERT INTO zin_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Obuchilo bakéeza náze, Yeézu yaálagila izimu elyo likaba lili omuli weényini, nályo lyaamulugámo. Ahonyini, omwaana aba yaachila. ");
INSERT INTO zin_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Niho abaheémba ba Yeézu baamwiizáho aha kabazu, baámubúuza báti, “Ha bwaáchi íichwe tukalemwa kulibiinga izimu éelyo?” ");
INSERT INTO zin_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Náwe yaábasubiza aáti, “Na habwo kuba nimucheehelelwa okwiikiliza kwéenyu. Mazima niimbagaambila, kámwaakubele mwiina okwiikiliza okubalilila nko oluzuma luche lwe ehaladáali, mukaáligaambila ibaanga éeli nka nikwo, ‘Lugaho aha, ozeénde okwo,’ nályo lizeenda. Bityo tichiliho echiintu éecho chilaábalema.  ");
INSERT INTO zin_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Hamo na ago, izimu nke éelyo tilikuhicha kubiingwa, náho kwoónka aha muháanda gwo kusaba Múungu ne echisiibo che ebyookulya.” ");
INSERT INTO zin_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Obuchilo Yeézu akaba ali hamo na abaheémba boómwe omuli Galiláaya, yaábagaambila aáti, “Íinye Mutábani wo Omuuntu niinkoóngwa na nibaánta omu ngalo za abaantu, nábo balaányíta. Náho echilo cha kásatu, Múungu naanzóola.” ");
INSERT INTO zin_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Abaheémba boómwe kábaahuliile ago, baázuzubalilwa bwooli. ");
INSERT INTO zin_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Obuchilo Yeézu na abaheémba boómwe kábaahikile omuli Kaperinaumu, abaantu bunaanka abaabeele nibatobesa oluhaambwe habwe éenzu ya Múungu, beeza hali Peétero. Baámubúuza báti, “Ngási, omweégesa wáanyu náwe aliha oluhaambwe lwe éenzu ya Múungu?” ");
INSERT INTO zin_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peétero yaábagalulila aáti, “Nikwo bili, aliha.” Niho yaátaaha omu nzu. Náho acháali Peétero atakagaambile echigaambo choóna chóona, Yeézu yaábaanza kumubúuza aáti, “Íiwe Simoni, íiwe noobona oóta? Abakáma abo omu nsi ezi batobesa oluhaambwe kuluga aha báana báabo nali kuluga aha baantu abáandi?” ");
INSERT INTO zin_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peétero yaámugalulila aáti, “Nibatobesa kuluga aha báandi.” Yeézu yaámugaambila aáti, “Keélaaba nikwo bili, mbwéenu abáana báabo baganyiílwe kuliha oluhaambwe. ");
INSERT INTO zin_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Náho tutaákwiiza kubaleételela kutamwa abaantu aba, íiwe zeénda omu nyaanza, onage ilobo omu méenzi. Niho eénfwi yo kubaanza éezo olaakwáasa, ozaásamule omunwa, noosaángamo omwo eshekéeli. Mále ozitwáale eshekéeli ezo, ozeénde olihe oluhaambwe lwaanze no olwaáwe.” ");
INSERT INTO zin_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Obuchilo obwo, abaheémba ba Yeézu baamwiizáho, baámubúuza báti, ");
INSERT INTO zin_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","“Noóha mukúlu kuchila abáandi bóona omu obukáma bwo omu igulu?” Yeézu yaámweeta omwaana muto, yaámweemeeleza ahagáti yáabo, ");
INSERT INTO zin_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yaábagaambila aáti, “Mazima butúnu niimbagaambila, keélaaba mutaákuhiinduka no kuba nka abáana bato, nakáti timukutaaha omu bukáma bwo omu igulu. ");
INSERT INTO zin_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bityo, omuuntu weéna wéena alikweécheesha nko omwaana omuto ogu, ogwo niwe naába mukúlu omu bukáma bwo omu igulu. ");
INSERT INTO zin_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Káandi, omuuntu weéna wéena óogwo alikumwiínaankula omwaana muto nko ogu aha bwi izíina lyaanze, naanyiinaánkula íinye.” ");
INSERT INTO zin_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Náho kaálaaba aliho omuuntu óogwo akamuleételela akole ebiheno oómo omu bato aba abalikuunyikiliza, ni haáchili hali weényini akomwe olubeengo omu bicha no kutubizwa omu chitubi che enyaanza. ");
INSERT INTO zin_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nimweelóoko yáanyu íimwe abaantu be éensi ezi, habwo kukola amagaambo áago galikuleételela abaantu kukola ebiheno! Nikwo, ebileengeso ebyo nibyeendelwa kubaho, náho neelóoko ha muuntu óogwo alikubileételela ebileengeso ebyo! ");
INSERT INTO zin_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Keélaaba elye engalo yaawe nali no okugulu kwaawe nikwo kulikuleételela kukola ebiheno, okunogole no okukunaga hala. Ni haáchili otaahemo omu bulami bwo obucha no buchiile obuchilo oyina obulema, kuchila kuba ne engalo ibili nali amagulu ábili, náho okanagwa omu mulilo gwo obucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Káandi, kililaaba ne elíiso lyaawe nilyo lilikukuleételela kukola ebiheno, olikúulemo no kulinaga hala! Ni haáchili otaahemo omu obulami bwo bucha no buchiile obuchilo oyina elíiso límo, kuchila kuba na méeso ábili, náho okanagwa omu lyoongoola lyo omulilo gwa kuzimu.” ");
INSERT INTO zin_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yeézu yaázeendelela kubasoomboolela aáti, “Mube méeso, mutaákugaya oómo omu bato aba! Niimbagaambila iíntyo, habwo kuba bamaléeka báabo bo omu igulu okwo, obuchilo bwóona bali omu méeso ga Táata wo omu igulu.  ");
INSERT INTO zin_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Íinye, Mutábani wo Omuuntu, nkeeza omu nsi mbone kubachuúngula abaantu áabo abaáhabile. ");
INSERT INTO zin_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nimubona muta? Kaálaaba omuuntu ayina entaama igana límo, ne eémo omuli ezo ebuzile, naakola aáta? Iínti naazileka ezo makúmi mweenda na mweenda omu ibaanga, no kuzeenda kuloondela ezo eémo ebuzile? ");
INSERT INTO zin_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mazima butúnu niimbagaambila, kaálaazibona, naanulilwa bwooli habwe entaama ezo eémo, kuchila entaama ezo makúmi mweenda na mweenda éezo ezitalabuzile. ");
INSERT INTO zin_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","“Bityo nyini, Isíimwe óogwo ali omu igulu, takweenda nka nikwo no óobu oómo omu abato aba abule.” ");
INSERT INTO zin_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kaálaaba omwiikiliza muzeenzi waawe akuheniile, zeénda omuháne obuchilo muli bábili mweénka. Kaálaakuhulila, mbwéenu noóba wabona káandi omwiikiliza muzeenzi waawe. ");
INSERT INTO zin_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Náho kaálaaba takakuhuliile, zeénda omutwáale omuuntu oóndi oómo nali abaantu bábili babone ‘kubaho baalubona bábili nali básatu bo kwaátula buli chiintu.’ ");
INSERT INTO zin_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na kaálaaba takubahuliliza abo, zeénda kuzigaambila ekelezia. Kaálaabula kuzihulila ne ekelezia, mbwéenu mumuleebe nko óokwo mumuleebaho óogwo atakwiikiliza Múungu nali óogwo ali omuhaámbya. ");
INSERT INTO zin_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Mazima butúnu niimbagaambila, góona áago mulikoma omu nsi ezi, náwe Múungu naába yaágakoma kuluga omu igulu. Káandi, góona áago mulaagakomoolola omu nsi ezi, náwe Múungu naába yaágakomoolola kuluga omu igulu. ");
INSERT INTO zin_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mazima butúnu niimbagaambila káandi nka nikwo, keélaaba bábili omuli íimwe bakakuúndilana omu nsi ezi kusaba echigaambo bunaanka, Táata óogwo ali omu igulu naabakolela echigaambo echo. ");
INSERT INTO zin_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Habwe ensoonga, keélaaba baliho no óobu abaantu bábili nali básatu áabo bakobile habwi izíina lyaanze, neenye niimbaho áaho hamo nábo.” ");
INSERT INTO zin_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Niho Peétero yéeza hali Yeézu, yaámubúuza aáti, “Íiwe Mukáma, kaálaaba omwiikiliza muzeenzi waanze anheniile, niinyeendelwa kumuganyila entúlo ziingahi? No óobu kuguma kumuganyila entúlo musaanzu?” ");
INSERT INTO zin_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeézu yaámugalulila aáti, “Niinkugaambila, te entúlo musaanzu kwoónka, náho omuganyile muzeenzi waawe obuchilo bwóona hatéena kupeeta. ");
INSERT INTO zin_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Niimbagaambila iíntyo, habwo kuba obukáma bwo omu igulu nibususana no omugani ogu. Akaba aliho omukáma oómo ogwo akazeenda kupeeta aha bazáana bo obukáma bwoómwe. ");
INSERT INTO zin_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Obuchilo omukáma yabaandize kupeeta, yaáletelwa omuzáana oómo óogwo akaba naatoóngwa empilya nyíinzi bwooli, nke etalaanta ebihuumbi ikúmi. ");
INSERT INTO zin_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Omuzáana ogwo talahikize kuliha ibáanza éelyo akaba naatoóngwa. Niho omukáma yaábalagila nka nikwo omuuntu ogu aguzwe weényini hamo na mukázi woómwe, abáana boómwe ne ebiintu byóona éebyo akaba ayiinabyo, abone kuliha. ");
INSERT INTO zin_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ogwo omuzáana yaáteela ebizwi omu méeso go omukáma, yaámuneémbelela nka nikwo, ‘Niinsaba onzilile obweéyomeleza, niinkuliha ibáanza lyaanze lyóona!’ ");
INSERT INTO zin_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Niho, omukáma wo ogwo muzáana yaámuzilila echiganyizi, yaámulekula, ni ibáanza, yaálimuganyila. ");
INSERT INTO zin_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Obuchilo omuzáana ogwo yaásohola ahéelu, yaámusaanga omuzáana muzeenzíwe óogwo akaba amutiilize okubalilila kwe edináali igana límo. Ahonyini, yaámukwáata omu maláka, yaámugaambila nka nikwo, ‘Liha ibáanza lyóona éelyo naákutiílize!’ ");
INSERT INTO zin_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Omuzáana muzeenzíwe yaáteela ebizwi omu méeso goómwe, yaámuneémbelela nka nikwo, ‘Niinsaba onzilile obweéyomeleza, niinkuliha ibáanza lyaanze lyóona!’ ");
INSERT INTO zin_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Náho yaáyaanga, yaázeenda kumuboha muzeenzíwe omu ibóhelo, kuhicha obuchilo óobwo aliliha ibáanza lyoómwe. ");
INSERT INTO zin_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Obuchilo abazáana bazeenzíbe kábaabweene ebyáagwa, baázololokwa bwooli omu miganya yáabo. Niho baázeenda ha mukáma wáabo no kuteékelela byóona óokwo byaabeelého. ");
INSERT INTO zin_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Niho omukáma kumwéeta omuzáana óogwo yaámuganyíile ibáanza lyoómwe, yaámugaambila nka nikwo, ‘Íiwe oli omuzáana omuzilwa! Léeba, obuchilo waántooziile nka nikwo nkuganyile ibáanza lyaawe, nkakuganyila lyóona! ");
INSERT INTO zin_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngási, íiwe tokuhatikwa kumuzilila echiganyizi omuzáana muzeenzi waawe, nko óokwo íinye naákuziliile íiwe echiganyizi?’ ");
INSERT INTO zin_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Mbwéenu, omukáma achaáhala bwooli, amuta omu ngalo za ababohi bamuteéyeeche, kuhicha obuchilo óobwo aliliha éelyo ibáanza lyóona.” ");
INSERT INTO zin_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Niho, Yeézu yaámala habwo kugaamba aáti, “Musoomboókelwe nka nikwo no óobu Táata óogwo ali omu igulu, naabakolela neemwe bityo nyini, keélaaba mutakuganyila buli mudugu muzeenzi wáanyu aha miganya yáanyu yóona.” ");
INSERT INTO zin_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Obuchilo Yeézu káyaamazile kuhooya amagaambo ago, yaáluga Galiláaya, kuzeenda omu nsi ya Yudea buseeli yo munóna gwa Yorodáani. ");
INSERT INTO zin_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ebipípi biháango byaaba nibimukulaatila okwo, náwe yaáchiza abalwéele omuli boónyini. ");
INSERT INTO zin_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Niho Abafarisayo bunaanka beeza hali Yeézu kubona kumuleenga. Baágaamba báti, “Ngási, ebilagilo bya Musa nibikuundilana omukwaáta kumuhicha mukázi woómwe aha nsoonga yoóna yóona?” ");
INSERT INTO zin_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeézu yaábagalulila aáti, “Íimwe timukasomile omu Maandiko Matakatíifu nka nikwo kulugiilila aha bubaandizo, ‘Múungu akahaanga omukwaáta no omukázi’? ");
INSERT INTO zin_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Múungu yaámuzila aáti, ‘Habwe ensoonga ezo, omukwaáta alaasiga iíse na nyina, akwaátaangane na mukazíwe, nábo bábili nibaba omubili gúmo.’ ");
INSERT INTO zin_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ha bwéecho mbwéenu, tibaliba bábili káandi, náho omubili gúmo. Nikwo, éecho echaateelanisizwe na Múungu, omuuntu atachitaáganisa.” ");
INSERT INTO zin_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Káandi, Abafarisayo abo baámubúuza báti, “Mbési káandi, na ha nsoonga chi Musa akalagila omukwaáta kumuha mukazíwe olwaandiko lwo kwaángana náze no kumuhicha?” ");
INSERT INTO zin_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeézu yaábagalulila aáti, “Musa akabakuúndila nka nikwo mulekaane na abakázi báanyu habwo kulemeela kwe emiganya yáanyu, náho kulugiilila ha bubaandizo no kuzeendelela tikwo byaabeele bili. ");
INSERT INTO zin_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Niimbagaambila nka nikwo omuuntu weéna wéena óogwo alikulekaana na mukazíwe, butali bwo kusaambana, no kuswéela omukázi oóndi, ogwo naasaambana.” ");
INSERT INTO zin_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Niho abaheémba boómwe baámugaambila báti, “Kábilaaba bili bityo hali iíba no omukázi, mbwéenu ni kuzima omuuntu atakuswéela!” ");
INSERT INTO zin_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeézu yaábagalulila aáti, “Ti baantu bóona abalikuhicha kuchiínaankula echigaambo echo, náho abo boónka áabo abaheelwe na Múungu. ");
INSERT INTO zin_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Manya, niingaámba iíntyo, habwo kuba haliho abaséeza abakonilwe abazeelwe bali bátyo kuluga omuunda ya baanyinábo. Haliho na abakonilwe na abaantu. Haliho abáandi káandi abakonilwe abokweékonela obutasweela habwo obukáma bwo omu igulu. Aláaba naahicha kwiinaankula echigaambo echi achiinaankule!” ");
INSERT INTO zin_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mbwéenu, abaantu bunaanka Baáléeta abáana báabo abato hali Yeézu abone kubáfuuha aha kubataho engalo, no kubasabila. Náho abaheémba boómwe baábachaáhukila abaantu abo. ");
INSERT INTO zin_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Náho Yeézu yaábagaambila aáti, “Mubaleke abáana abato beéze hali íinye, mutabazibila kuunyizaho! Manya obukáma bwo omu igulu no bwa abaantu abo kwiingana na abáana aba.” ");
INSERT INTO zin_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yeézu kaámala kubataho engalo, alugaho. ");
INSERT INTO zin_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mala omuuntu oómo yéeza hali Yeézu, yaámubúuza aáti, “Íiwe Mweégesa, nkole chizima chi neenye mbone obulami bwo obucha no obuchiile?” ");
INSERT INTO zin_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeézu yaámugalulila aáti, “Ha bwaáchi noombuúza íinye echigaambo echili chizima? Léeba, Múungu weénka niwe omuzima! Náho koólaaba nooyeénda kuza omu obulami obwo bucha no buchiile, okoondoókele ebilagilo bya Múungu.” ");
INSERT INTO zin_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Omusígazi ogwo yaámubúuza aáti, “Bilagilo chi?” Yeézu yaámugalulila aáti, “Otaákwiita, otaákuba omusaambani, otaákwiiba, otaákusiinza ebisuba, ");
INSERT INTO zin_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","obakúze iíso na nyoko, no kumwéenda muzeenzi waawe nko óokwo olikweéyeenda íiwe nyini.” ");
INSERT INTO zin_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Omusígazi ogwo yaámuzila aáti, “Ebilagilo byóona ebyo nkabikola. Nkole chiíha echíindi éecho mbuzilwého?” ");
INSERT INTO zin_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeézu yaámugaambila aáti, “Koólaaba nooyeénda kuba ahikile, zeénda oguze ebiintu byóona éebyo oyinabyo, empilya ezo obáhe abahabi. Koólaaba waákozile oótyo, noóba ne ensabo omu igulu. Mále oyize, onkulaatile.” ");
INSERT INTO zin_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Obuchilo omusígazi ogwo yaáhuliile ebyo, yaalugáho habwo buzune, habwo kuba akaba ali omuhíte bwooli. ");
INSERT INTO zin_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Niho Yeézu yaábagaambila abaheémba boómwe aáti, “Mazima butúnu niimbagaambila, chilyáaba chigumile ha omuhíte kuza omu bukáma bwo omu igulu. ");
INSERT INTO zin_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Niimbagaambila káandi nka nikwo, chihuhuukile bwooli ha ntwaangabuleende kuhiíngula omu kahulu ko olusíinge, kusaaga omuhíte kuza omu bukáma bwa Múungu.” ");
INSERT INTO zin_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Obuchilo abaheémba boómwe bahuliile bátyo, baásobelwa bwooli, baámubúuza báti, “Óobu noóha mbwéenu óogwo yaakaáhicha kuchuúngulwa?” ");
INSERT INTO zin_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeézu yaábaleeba omu kubeétegeeleza, yaábagaambila aáti, “Habwa abaantu echo tichikwiíle, náho habwa Múungu góona gakwiíle.” ");
INSERT INTO zin_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ahonyini, Peétero yaámugalulila aáti, “Léeba, íichwe tukasiga byóona, twaákukulaatila íiwe no kuba abaheémba baawe! Mbwéenu, neechwe tulyaábona chi?” ");
INSERT INTO zin_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeézu yaábagalulila aáti, “Obuchilo íinye Mutábani wo Omuuntu, niímba nnyikeele nko omukáma aha chitébe chaanze echiina ikuzo omu nsi eénsha, mazima butúnu niimbagaambila neemwe áabo muunkulaatiíle, nimwiikala aha bitébe byo obuzizi ikúmi na bibili, kunu nimutégeka endími ikúmi ne ibili eza Iziraeli. ");
INSERT INTO zin_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Káandi, kati muuntu óogwo asigile eekáye, nali mweene wáabo, nali banyáanya, nali iíse, nali nyina, nali abáana, nali ensaambo, habwe ensoonga yi izíina lyaanze, alyeénaankula entúlo igana ye ebyo, no kwiinaankula obulami obutahwaho. ");
INSERT INTO zin_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Náho béenzi áabo abalikuleebwa na abo omugaso óobu, tibaliba no omugaso gwoóna gwóona omu buchilo óobwo obulikwiiza. Káandi na béenzi áabo abalikuleebwa ti bo omugaso óobu, baláaba abo omugaso omu buchilo óobwo obulikwiiza.” ");
INSERT INTO zin_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Nikwo ebigaambo biliho, habwo kuba obukáma bwo omu igulu nibususana na kanyina wo omusili óogwo ayaatiimbiile enchaákala kuloonda abahálila kumukolela emilimo omu musili gwoómwe gwe emizabibu. ");
INSERT INTO zin_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Obuchilo yaábasaangile, yaálagana nábo nka nikwo abalihe buli mupagasi empeéla ye emilimo ye echilo chimo. Niho, yaábasiíndika omu musili gwoómwe. ");
INSERT INTO zin_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Obuchilo zaáhikile esáaha isatu enchaákala, yaásohola ahéelu káandi kuzeenda omu igulizo, yaábona abaantu abáandi batéena emilimo. ");
INSERT INTO zin_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yaábagaambila aáti, ‘Neemwe muzeénde kukola emilimo omu musili gwaanze gwe emizabibu. Ne echili amazima géenyu kubaha, neenye niinchibaha.’ ");
INSERT INTO zin_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nábo bazeenda. “Mbwéenu obuchilo bwa nyemisana kibwaahikile, yaásohola ahéelu káandi kutaho abaantu abáandi bazeénde omu musili gwoómwe. Kigaahiíngwiile amasáaha asatu, yaákola aátyo káandi. ");
INSERT INTO zin_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Obuchilo zikaba esáaha ikúmi ne eémo olweébazo, yaásohola ahéelu káandi kuzeenda omu igulizo, yaásaanga abaantu abáandi batéena milimo. Yaábabúuza aáti, ‘Ha bwaáchi mweémeeliile aha echilo chóona mutéena milimo yoóna yóona?’ ");
INSERT INTO zin_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nábo baámusubiza báti, ‘Na habwo kuba táliho omuuntu óogwo ayaatuhéele emilimo.’ Weényini yaábagaambila aáti, ‘Neemwe muzeénde kukola emilimo omu musili gwaanze gwe emizabibu.’ ");
INSERT INTO zin_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Obuchilo bwa aha kaswiílima, kanyina wo omusili yaágaambila endiinza yoómwe aáti, ‘Obéete abapagasi bóona, obáhe empeéla. Obuchilo noobaha, obaánze na abapagasi áabo bakéeza ha muheleeluko no okumaliliza na áabo abeeza olwa mbele.’ ");
INSERT INTO zin_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Niho abahálila áabo bakabaanza emilimo olweébazo, beeza bahaabwa empeéla ye emilimo ye echilo chimo. ");
INSERT INTO zin_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na abo abapagasi áabo babaandize emilimo enchaákala kábeezile, bakateékuza kwiinaankula bwooli kusaagáho bazeenzi báabo áabo ababaandize kulihwa abeezile omu musili ha kuheleeluka. Náho buli muuntu yaáhéebwa empilya ezo nyini ye empeéla ye emilimo ye echilo chimo. ");
INSERT INTO zin_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ha bwéecho, obuchilo beenaánkwiile empeéla yáabo, baábaanza kuteéka téeka hali kanyina wo omusili nibagaámba nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Abaantu abo baákola emilimo ha sáaha eémo kwoónka! Óobu byaaba bita waátuliha bwiinganisa nábo, obuchilo íichwe twaákola emilimo elikuguma bwooli no omusana gwe echilo chóona gwaatuhweelaho?’ ");
INSERT INTO zin_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Kanyina wo omusili yaámugalulila oómo omu bahálila abo aáti, ‘Íiwe munywáani, tinaákubeeha choóna chóona. Ngási, titwaákuundilana nka nikwo nookola emilimo aha mpeéla ye emilimo ye echilo chimo? ");
INSERT INTO zin_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kwaáta empilya yaawe, ozeénde owaáwe. Íinye naálamula kumuliha omuuntu wa ha muheleeluko empeéla éezo elikwiingana ne eyaáwe. ");
INSERT INTO zin_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ngási, niinyaangilwa kukoza empilya zaanze nko óokwo ndikweenda? Nali oyina ichubi habwo kuba íinye ndi omweésigwa aha báandi?’ ” ");
INSERT INTO zin_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yeézu yaámaliliza kwo kugaamba aáti, “Bityo, abaantu abo abali bo omuheleeluko balyáaba nibo abo kubaanza, na abo kubaanza balyáaba abo omuheleeluko.” ");
INSERT INTO zin_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Obuchilo Yeézu akaba ali omu muháanda naahanama kuza omuli Yeruzaléemu, ayihaho abaheémba boómwe ikúmi na bábili, abata ha lubazu, bali omu luzeendo abagaambila aáti, ");
INSERT INTO zin_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Léeba, óobu twaayeleka Yeruzaléemu. Niho okwo, íinye Mutábani wo Omuuntu, nibaánta omu ngalo za abakúlu ba abagabe ba Múungu no omu ngalo za abeégesa be ebilagilo bya Musa. Nábo nibaanchwaaziíka nka nikwo nnyítwe. ");
INSERT INTO zin_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Niho, nibaantwaála omu ngalo za Abanyamahaánga kubona baannegule, baankone ne enkoba no kuúmbaamba aha musalaba. Náho echilo cha kásatu, ndaázoolwa.” ");
INSERT INTO zin_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Niho, nyina wa batábani ba Zebedayo yéeza hali Yeézu ali hamo na abatábani bábili, yaáhika yaáteela ebizwi, yaámusaba amukolele echiintu chimo. ");
INSERT INTO zin_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeézu yaámubúuza aáti, “Nooyeénda nkukolele chiíha?” Náwe yaámugalulila aáti, “Niinsaba obeékililize abáana baanze aba bábili nka nikwo, beekale hamo neewe omu bitébe byo obuzizi omu bukáma bwaawe, oómo olubazu lyo obúlyo no oóndi olubazu lyo bumoso.” ");
INSERT INTO zin_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeézu yaámugalulila aáti, “Timukusoombookelwa éebyo mulikusaba. Ngási, mukaáhicha kunywéela echikóombe chi ndinywéelaho íinye?” Baámugalulila báti, “Nitúhicha.” ");
INSERT INTO zin_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeézu yaábagaambila aáti, “Mazima, nimuchinyweélaho echikóombe éecho íinye ndi kunywéelaho, náho kwíikala olubazu lwaanze lwo obúlyo nali lwo bumoso ti mulimo gwaanze kubakuúndila. Omwáanya ogwo na habwa áabo Táata yaámazile kubaloongeza.” ");
INSERT INTO zin_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Obuchilo abaheémba abáandi ikúmi bahuliile ha bwéecho, baábatámwa omuuntu na mweene wáabo. ");
INSERT INTO zin_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Niho Yeézu yaábéeta bóona hamo, yaábagaambila aáti, “Nimusoomboókelwa nka nikwo abatégeki ba amahaánga agáandi nibategéka abaantu báabo lwa amagala, káandi nibabakoza. ");
INSERT INTO zin_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Náho etaákwiiza bikaba bityo hali íimwe. Omuuntu weéna wéena óogwo naayeénda kuba mukúlu omuli íimwe, naayeéndelwa kuba omuzáana wáanyu. ");
INSERT INTO zin_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Káandi, omuuntu óogwo naayeénda kuba owa mbele omuli íimwe, aábe omuhálila wáanyu. ");
INSERT INTO zin_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ni nkeenye Mutábani wo Omuuntu, tiíndeezile mbone kukolelwa, náho nnyizile kubakolela abaantu no kusohoza obulami bwaanze, mbone kubakomoolola abaantu béenzi.” ");
INSERT INTO zin_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Obuchilo Yeézu na abaheémba boómwe bakaba nibaluga omuli Yeriko, echipípi chiháango cha abaantu chikamukulaatila. ");
INSERT INTO zin_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aha mpiíngulo yo omuháanda óogwo Yeézu akaba naahiingula, bakaba baliho abahume bábili. Mbwéenu, obuchilo bahuliile nka nikwo Yeézu naahiingula aho, baáhámuka muno báti, “Íiwe Mukáma, Mutábani wa Daudi, otuzilile echiganyizi!” ");
INSERT INTO zin_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Embága ya abaantu yaábachaáhukila nka nikwo beésize, náho boónyini baáguma kwéeta aha kuhamuka iláka báti, “Íiwe Mukáma, Mutábani wa Daudi otuzilile echiganyizi!” ");
INSERT INTO zin_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Niho, Yeézu yaáyemeelela, yaábéeta, yaábabúuza aáti, “Nimweénda mbakolele chiíha?” ");
INSERT INTO zin_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Abahume abo bamugalulila báti, “Íiwe Mukáma, nitweénda améeso géetu gachile!” ");
INSERT INTO zin_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Niho Yeézu yaábaganyila, yaabakwaataho améeso gáabo. Ahonyini, améeso gáabo gaáchila, nábo bamukulaatíla Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Obuchilo Yeézu na abaheémba boómwe belilize omuli Yeruzaléemu, baáhika omu mugoongo gwa Betifáage omu ibaanga lye Emizeituni. Niho Yeézu yaábasiíndika abaheémba boómwe bábili, yaábagaambila nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Muzeénde omu mugoongo oguli omu méeso gáanyu. Obuchilo nimutáha omwo, ahonyini nimusaánga ensíkili esibikilwe aho, hamo no omwaana gwaáyo. Niho muzisibule, muundeétele aha. ");
INSERT INTO zin_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kábilaaba omuuntu weéna wéena alaababúuza chóona chóona, mumugalulile muti, ‘Omukáma wéetu naazeénda,’ náwe naabakuundila mwiíze nágwo.” ");
INSERT INTO zin_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ebyo bikabaho bityo, chibone kuhikiilila echigaambo éecho Múungu akagaamba kulabila ha mubáasi woómwe nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bagaambile abaantu ba Sayuni nka nikwo, ‘Léeba, omukáma wáanyu naayiza hali íimwe, no omufula, naayiza naába ahanamile aha nsíkili, no omwaana gwe ensíkili.’ ” ");
INSERT INTO zin_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mbwéenu, abaheémba boómwe baázeenda, baákola nko óokwo Yeézu yabalagíile. ");
INSERT INTO zin_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Obuchilo basubile hali Yeézu ne ensíkili ezo hamo no omwaana gwaáyo, baáyala emyéenda aha lugulu yaágwo, na Yeézu yeékalila emyéenda ezo. ");
INSERT INTO zin_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Echo chipípi chiháango cha abaantu, baáyala emyéenda yáabo omu muháanda. Abáandi baánogola amatábazi ge emiti no kugata omu muháanda habwo kumukúza Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abaantu abo abaabeele beébeembiile na abaabeele nibamukulaatíla Yeézu, bakaba nibahamuka aha maláka maháango báti, “Hosana ha Mutábani wa Daudi! Ayina omugisa ogwo alikwiiza ahi izíina lyo Omukáma Múungu! Hosana hali Múungu óogwo ali omu igulu!” ");
INSERT INTO zin_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Obuchilo Yeézu yaátaahile omuli Yeruzaléemu, echikaali chóona chaásamaala bwooli. Abaantu baábaanza kweébuuza báti, “Ogwo noóha?” ");
INSERT INTO zin_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Echipípi cha abaantu chikaba nichibagalulila chíti, “Ogu niwe Yeézu! Niwe omubáasi ogwo owa Nazaréeti eya Galiláaya!” ");
INSERT INTO zin_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Niho Yeézu yaátaaha omu lubúga lwe éenzu ya Múungu. Obuchilo kayataahile omwo, yaábasaanga béenzi abaabeele nibaguza no kugula ebiintu omwo, yaábabiinga bóona. Yaánaga naga emeéza za abaabeele nibahiínga empilya, no kubinaga naga ebitébe bya abaabeele nibaguza ebiiba. ");
INSERT INTO zin_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yeézu yaábagaambila aáti, “Eyaandikilwe omu Maandiko Matakatíifu eéti, ‘Éenzu yaanze elyáaba éenzu yo kusabilamo.’ Náho íimwe, nimuzihiindula kuba ‘enyaanga ya abasaakuzi.’” ");
INSERT INTO zin_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mbwéenu, obuchilo Yeézu akaba achili omu lubúga lwe éenzu ya Múungu, abahume ne enziíngami beeza hali weényini, náwe yaábachiza. ");
INSERT INTO zin_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Náho abakúlu ba abagabe ba Múungu na abeégesa be ebilagilo bya Musa kábaabweene amahano áago Yeézu akaba naakola, no kubahulila abáana nibahamuka omu lubúga lwe éenzu ya Múungu báti, “Hosana ha Mutábani wa Daudi!” Habwe ensoonga ezo, baásaaya bwooli, ");
INSERT INTO zin_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","baámubúuza Yeézu báti, “Ngási, noohulila óokwo abáana aba ku balikugaamba?” Yeézu yaábagalulila aáti, “Niinhulila. Nikwo, timukasomaga amagaambo áago agaándikilwe omu Maandiko Matakatíifu nka nikwo, ‘Oyeloongiize echikumuuko chaawe, kulabila eminwa ya abáana abato na abacheche’?” ");
INSERT INTO zin_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yeézu yaábaleka aho, yaáluga omu chikaali cha Yeruzaléemu, yaázeenda kulyaama omu mugoongo gwa Betania. ");
INSERT INTO zin_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Enchaákala yaáho, obuchilo Yeézu akaba naasuba omu chikaali cha Yeruzaléemu, yaálumwa enzala. ");
INSERT INTO zin_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Niho yaábona omuti gwo omutini guli aha mpiíngulo yo omuháanda. Yaaguhikáho, yaásaanga gutéena kaantu koóna kóona, náho gwiina ebibabi byoónka. Bityo yaágugaambila omuti ogwo aáti, “Íiwe nakáti, tolizaala káandi amagoomba!” Ahonyini, omuti gwaáyoma. ");
INSERT INTO zin_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Obuchilo abaheémba ba Yeézu baabweene ago, baásobelwa bwooli. Baámubúuza báti, “Bita ogu omutini kagwaayoma bwaangu gúti?” ");
INSERT INTO zin_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeézu yaábagalulila aáti, “Mazima butúnu niimbagaambila, kamulaaba mwiina okwiikiliza óokwo kutéena kutahwa tahwa, neemwe nimuhicha kugakola agáandi nka agakolwa aha muti ogu gwo omutini. Káandi timukukola ago goónka, náho no óobu mulaagaambila ibaanga éeli muti, ‘Kuúka oze kweénaga omu nziba,’ nácho nichibaho. ");
INSERT INTO zin_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kamulaaba mwiina okwiikiliza, choóna chóona éecho mulaasaba hali Múungu, nimwiinaánkula.” ");
INSERT INTO zin_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeézu yaátaaha káandi omu lubúga lwe éenzu ya Múungu. Obuchilo akaba naayegesa, niho abakúlu ba abagabe ba Múungu, na abanyaampala ba Abayahudi beeza kumubúuza báti, “Aga áago olikukola, noogakola aha buzizi chi? Noóha óogwo akuheéle obuzizi obwo?” ");
INSERT INTO zin_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeézu yaábagalulila aáti, “Neenye káandi niimbabuúza echigaambo chimo. Kámulaangalulila echo, ne íinye niimbagaambila na habwa buzizi chi niinkola aga. ");
INSERT INTO zin_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ngási, obuzizi bwa Yohana bwo kubatiza abaantu, bukaluga nkáhi? Bukaluga ahali Múungu nali bukaluga aha baantu?” Niho baábaanza kuteéka téeka báti, “Katulaagaámba nka nikwo bukaluga ahali Múungu, naatubuúza nka nikwo, ‘Mbwéenu, habwa chiíha timulamwiíkiliize?’ ");
INSERT INTO zin_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Káandi, katulaagalula kuba bukaluga aha baantu, nitubeéha embága ya abaantu aba, habwo kuba bóona beena obweétegeeleza nka nikwo Yohana akaba ali omubáasi.” ");
INSERT INTO zin_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ha bwéecho bamugalulila báti, “Titukumanya.” Mbwéenu, Yeézu náwe yaábagaambila aáti, “No óobu íinye tiínkubagaambila niingakola amagaambo aga aha buzizi chi.” ");
INSERT INTO zin_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeézu yaázeendelela kubagaambila abakúlu abo aáti, “Óobu, nimubona muta habwo ogu mugani? Akaba aliho omuuntu oómo óogwo akaba ayina abáana bábili. Yaázeenda aha mutábani wo obuzigeezo, yaámugaambila nka nikwo, ‘Íiwe mwáana waanze, leélo zeénda kukola emilimo omu musili gwaanze gwe emizabibu.’ ");
INSERT INTO zin_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ogwo mutábani yaámugalulila aáti, ‘Táata tiínkuzeenda!’ Náho ahaakulaatiile, yaáhiindula ebiteékuzo byoómwe, yaázeenda yaábikola. ");
INSERT INTO zin_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Niho iíse yaázeenda ha mutábani owa kábili no kumugaambila nko óokwo yaámulagila oóndi ogwo. Náwe yaámugalulila aáti, ‘Táata niinzeénda!’ Náho talazeenzile. ");
INSERT INTO zin_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Óobu ngási, omu bábili abo, noóha óogwo akakola kwiingana ne engoonzi ze eése?” Baámusubiza báti, “No ogwo wo kubaanza.” Niho Yeézu yaábazila aáti, “Mazima butúnu niimbagaambila, abahaámbya na abasiihani balaábeebeembelela kuza omu bukáma bwa Múungu. ");
INSERT INTO zin_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohana akeeza hali íimwe abone kuboóleka omuháanda gwa amazima, neemwe timulamwiíkiliize. Náho abahaámbya na abasiihani nibo bamwiikilize. No óobu bityo íimwe obuchilo mukabona góona ago, mwaáyaanga kuhiindula ebiteékuzo bwéenyu no kumwiíkiliza.” ");
INSERT INTO zin_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Muhuliilíze omugani ogúundi. Akaba aliho omuuntu oómo ogwo akaba ayina omusili. Omuli ogwo musili gwoómwe, akabiba emizabibu, yaáguzoóngolocheza olugo, yaasumamo izuungilo lyo kuzuungilamo ezo zabibu, káandi yaáyoómbeka oluswi luleehi lwa abaleebelezi. Niho, yaáguheélela aha balimi bunaanka, yaázeenda oluzeendo. ");
INSERT INTO zin_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Obuchilo omwáanya gwo kugesa kigwaahikile, ogwo kanyina wo omusili yaásiindika abazáana boómwe aha balimi abo, abone kuhaabwa omugabo gwoómwe gwe ezabibu. ");
INSERT INTO zin_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Náho obuchilo abazáana boómwe kábaahikile, abalimi abo baábakwáata, oómo baámutéela, oóndi baámwíita no oóndi baámuhoónda na amabáale. ");
INSERT INTO zin_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Niho, kanyina wo omusili yaásiindika káandi abazáana abáandi, béenzi kuchila áabo akabasiíndika aha bubaandizo. Abalimi abo baábakolela kubi abahálila abo nko óokwo babakolíle abo kubaanza. ");
INSERT INTO zin_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Niho, yaámusiíndika omwaana woómwe. Yeeteeka téeka nka nikwo, ‘Ogu ni mutábani waanze, weényini nibamukúza.’ ");
INSERT INTO zin_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Náho obuchilo abalimi abo kábamubwéene, beégaambila nka nikwo, ‘Ogu niwe omuhuunguzi wo ogu musili. Kachu, tumwíite tubone íichwe okwiimucha obuhuunguzi bwoómwe.’ ");
INSERT INTO zin_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mbwéenu, baámukwáata, baámunaga ahéelu yo ogwo musili, baámwíita.” ");
INSERT INTO zin_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yeézu yaábabúuza aáti, “Ngási, obuchilo kanyina wo omusili naasuba kuluga omu luzeendo lwoómwe, alaákola chiíha aha balimi abo?” ");
INSERT INTO zin_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Baámusubiza báti, “Naabasikiza kubi abo obwíiko abo, no omu musili gwoómwe naabakoóteseza abalimi abáandi áabo balaámuha egabo yoómwe ye emizabibu ehiisize aha buchilo bwoómwe.” ");
INSERT INTO zin_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Niho Yeézu yaábagaambila aáti, “Ngási, timukasomile ago agaándikilwe omu Maandiko Matakatíifu? Agaándikilwe nka nikwo, ‘Ibáale éelyo baayaángile aboómbeki, nilyo lyaahiindukile kuba ibáale igazi lyo oluhazo. Omukáma Múungu niwe akozile echigaambo echi, nácho ne cho kusobeza omu méeso géetu.’” ");
INSERT INTO zin_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yeézu yaáyoongela aáti, “Ha bwéecho, niimbagaambila nka nikwo, obukáma bwa Múungu bulyaáyakwa kuluga hali íimwe no kuhaabwa abaantu áabo balaákola áago Múungu alikweenda gakolwe omu bukáma bwoómwe. ");
INSERT INTO zin_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mbwéenu, omuuntu óogwo aligwa ahi ibáale elyo, naasekenyuka. Káandi, óogwo ibáale lilaamugwéela, nilimusa butúnu.” ");
INSERT INTO zin_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Obuchilo abakúlu ba abagabe na Abafarisayo bahuliile emigani ya Yeézu, basoombookelwa nka nikwo naabahoóyela boónyini. ");
INSERT INTO zin_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ha bwéecho, baaba nibaloondela omuháanda gwo kumukwáata. Náho bakaba nibatiína embága ya abaantu, habwo kuba bakamuteekuza weényini nka nikwo no omubáasi. ");
INSERT INTO zin_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeézu yaázeendelela kweégesa Abafarisayo na abakúlu ba abagabe habwo omugani ogúundi nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Obukáma bwo omu igulu bususana no omugani ogu. Hakaba heena omukáma óogwo ayaachuumbiile omwaanáwe amazenyi go obweenga. ");
INSERT INTO zin_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Omukáma ogwo yaásiindika abazáana boómwe bazeénde kwéeta áabo abakaba baángisiibwe nka nikwo beéze ha amazenyi, náho bóona bakáanga kwíiza. ");
INSERT INTO zin_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Niho yaásiindika abazáana abáandi, naabazila aáti, ‘Muzeénde mubagaambile áabo abaángisiibwe muti, “Naáchuumbile amazenyi gaanze. Naábaágile ebimasa byaanze hamo ne ebituungaánwa ebíindi bya amasázu. Naáloongize byóona. Ha bwéecho, mwíize mulye amazenyi go obweenga!”’ ");
INSERT INTO zin_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Náho abaantu áabo abalaalikilwe, tibalabyeétiilého. Buli oómo akaba ayina ebyaago byoómwe, ogu yaáza omu musili gwoómwe, no oóndi yaáza ha butuunzíbwe. ");
INSERT INTO zin_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Abáandi baábakwaátilila abazáana bo omukáma ogwo, baábefoolela kubi no kubéeta. ");
INSERT INTO zin_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mbwéenu, omukáma kayeezile yaáhuliza áago agaákolwa aha bazáana boómwe, yaánigahala bwooli. Yaásiindika ensuli zoómwe bazeénde kwiita abéesi abo no kusiingaalicha iboma lyáabo. ");
INSERT INTO zin_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Niho omukáma ogwo yaábagaambila abazáana boómwe aáti, ‘Amazenyi go obweenga naágachuumba, kwoónka abaángisiibwe tibakwiilwe. ");
INSERT INTO zin_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mbwéenu óobu, nimwiilóoko muzeénde aha ntaáganilo ze nsése, mufwe mwaáyaangisa abaantu bóona áabo mulaabugana nábo nka nikwo, beéze aha mazenyi go obweenga.’ ");
INSERT INTO zin_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Abazáana abo baalugáho baázeenda aha ntaáganilo ze nsése, baálaalika abaantu bóona abaabeele nibabugana nábo, babe abaheni nali aba amazima. Niho abazenyi beeza baátaaha omu nzu ya amazenyi, nayo eba yeézula. ");
INSERT INTO zin_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Náho obuchilo omukáma yaataahilemo abone kuleeba abazenyi aha luhelo, yaabonamo omuuntu oómo óogwo akaba atazweéle enkaanzu ye echilo chikúlu cha amazenyi go obweenga. ");
INSERT INTO zin_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yaámubúuza aáti, ‘Íiwe munywáani, waataahamo oóta óomu kunu otakazwéele enkaanzu ye echilo chikúlu cha amazenyi go obweenga?’ Náho omuuntu ogwo aba yeésiza kwoónka. ");
INSERT INTO zin_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mbwéenu, omukáma yaábagaambila abazáana boómwe aáti, ‘Nimumukome emikono na amagulu, mumunáge ahéelu omu nsiimbaazi. Niho haláaba okuchula no kusa améeno.’ ” ");
INSERT INTO zin_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeézu yaámaliliza aha kugaamba aáti, “Abaantu áabo abalikwéetwa ni béenzi, náho abatooziibwe ni báche.” ");
INSERT INTO zin_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ahonyini, Abafarisayo bazeenda, baábugana no kweéhanuuza akazeendele ko kumubása Yeézu ha bigaambo byoómwe. ");
INSERT INTO zin_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Niho baámusiindikila abaheémba báabo baatáho na abaantu abakuúnzile obutégeki bwo omukáma Herode. Baáhika baámubúuza Yeézu báti, “Íiwe Mweégesa, nitusoomboókelwa nka nikwo íiwe oba omuuntu wa amazima na nka nikwo nooyegesa amazima habwa amagaambo ga Múungu. Nitusoomboókelwa nka nikwo íiwe tokutíina omuuntu weéna wéena, ni ikuzo lyo omuuntu ti kaantu hali íiwe. ");
INSERT INTO zin_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Óobu mbwéenu, otugaambile íiwe. Ngási! Kwiingana ne ebilagilo byéetu bye Echiyahudi, na amazima íichwe kuliha oluhaambwe hali Kaizáari, nali mmahi?” ");
INSERT INTO zin_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Náho Yeézu akamanya echihika cháabo chibi, yaábagalulila aáti, “Íimwe abagóbya, habwa chiíha nimweénda kuúndeenga? ");
INSERT INTO zin_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nimuunyoleke empilya éezo mulikuliha oluhaambwe.” Niho baámuheéleleza edináali eémo. ");
INSERT INTO zin_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Niho Yeézu yaábabúuza aáti, “Ensuso yo omuuntu ogu ni izíina elili ahali ezi mpilya ye edináali, ne ebyo oóha?” ");
INSERT INTO zin_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Boónyini baámusubiza báti, “Ne bya Kaizáari.” Yeézu yaábagaambila aáti, “Oótyo! Mbwéenu, ebili bya Kaizáari mumuhe Kaizáari, ne bya Múungu mubimuhe weényini Múungu.” ");
INSERT INTO zin_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Obuchilo bahuliile akasubize ka Yeézu, baásobelwa bwooli. Mbwéenu, baaba baámuleka, baalugáho aho. ");
INSERT INTO zin_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ha chilo echo nyini, Abasadukayo bunaanka beeza hali Yeézu. Abo Basadukayo baágaamba nka nikwo, okuzooka kwa abáfwiile tikulibaho. Niho baámubúuza Yeézu báti, ");
INSERT INTO zin_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Íiwe Mweégesa, Musa akatulagila omu bilagilo byoómwe nka nikwo, kábilaaba omuuntu yaáfwiile no kumusiga entuúmbakazi atamuzeéleho mwáana, omulumuna amuhuungule ogwo ntuúmbakazi, amuzaálile abáana ayaafwíile. ");
INSERT INTO zin_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mbwéenu, omuli íichwe hakaba heena abadugu musaanzu be éenda eémo. Owo kubaanza aba yaásweela omukázi, mala yaákaba atéena kumuzaalaho omwaana mukazíwe. Mbwéenu aba yaámusigila mweene wáabo kumuhuungula mukazíwe. ");
INSERT INTO zin_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mweene wáabo ogwo náwe, yaáfwa atéena kuzáala no ogwo mukázi. Bikaba bityo nyini aha balumuna abáandi bóona musaanzu, bakáfwa batéena kumuzaalaho omwaana. ");
INSERT INTO zin_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Abo bóona ka bafwiile, niho ogwo mukázi náwe aba yaáfwa. ");
INSERT INTO zin_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mbwéenu otugaambiile, ha chilo echo cho kuzoolwa, ogwo mukázi alyáaba ali wo mwoóha omuli abo baséeza musaanzu? Ha kuba bóona abo musaanzu bakaba bamuswiíle!” ");
INSERT INTO zin_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeézu yaábagalulila aáti, “Íimwe mwaáhabile, habwo kuba timukugasoombookelwa Amaandiko Matakatíifu no óobu obuzizi bwa Múungu. ");
INSERT INTO zin_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Habwo kuba abáfwiile kabalizóoka, tibalikuumpula nali kukuúmpulwa. Náho baláaba nka bamaléeka bo omu igulu, boónyini tibakuumpula nali kukuúmpulwa. ");
INSERT INTO zin_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Náho mazima abáfwiile nibazóoka, timukasomile omu Maandiko Matakatíifu óokwo Múungu yaábagaambiile íimwe? Akagaamba aáti, ");
INSERT INTO zin_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Níinye Múungu wa Ibrahímu, Izáaka na Yakobo.’” Yeézu yaázeendelela kugaamba aáti, “Bityo, weényini ti Múungu wa abáfwiile, náho ni Múungu wa áabo abali mwooyo.” ");
INSERT INTO zin_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Obuchilo embága ya abaantu káyaahuliile áago, yaásobelwa bwooli habwa ameégeso goómwe. ");
INSERT INTO zin_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Obuchilo Abafarisayo baáhuliile nkokwo Yeézu yaabahuumbaálize Abasadukayo habwa kagaambile koómwe, baákoba hamo. ");
INSERT INTO zin_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Niho, muzeenzi wáabo óogwo akaba ali omweégesa we ebilagilo bya Musa, yaámubúuza Yeézu amuleengile, nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Íiwe Mweégesa, ni chilagilo chi echili chikúlu omu bilagilo byóona?” ");
INSERT INTO zin_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeézu yaámugalulila aáti, “ ‘Omweénde Omukáma Múungu waawe aha muganya gwaawe gwóona, na aha bwéenze bwaawe bwóona, nikwo kugaamba, hali byoona ebili hali íiwe.’ ");
INSERT INTO zin_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Echilagilo echi nicho chikúlu kuchila ebilagilo ebíindi byóona, káandi nicho chilikugasa kuchila byóona. ");
INSERT INTO zin_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Echilagilo cha kábili nácho ni nke éecho nyini chiina ensoonga elikususana ne ezo, nácho nchichi, ‘Omweénde muzeenzi waawe nko óokwo olikweéyeenda íiwe nyini.’ ");
INSERT INTO zin_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Omuli ebyo bilagilo bibili niho ebilagilo byóona bya Musa na ameégeso ga ababáasi nigabitegeza.” ");
INSERT INTO zin_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Óobu Abafarisayo abo bakobile hamo aho, Yeézu yaábabúuza aáti, ");
INSERT INTO zin_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nimuteekuzaho muta habwa Masihi, ni mutábani wo oóha?” Baámusubiza báti, “Ni mutábani wo omukáma Daudi.” ");
INSERT INTO zin_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yeézu yaábabúuza aáti, “Ngási ni bitaho, obuchilo naayibeembelelwa no Omwooyo Mutakatíifu, omukáma Daudi naamweéta Masihi, ‘Omukáma’? Akagaamba aáti, ");
INSERT INTO zin_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Omukáma Múungu akamugaambila Omukáma waanze aáti, “Yikala olubazu lwaanze lwo obúlyo, kuhika mbate ababisa baawe, iífo ya amagulu gaawe.”’ ");
INSERT INTO zin_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Áaho Daudi naamweéta weényini, ‘Omukáma woómwe,’ ha bwéecho, naahicha aáta kuba omutábani?” ");
INSERT INTO zin_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tihalazizile no omuuntu óogwo ayaahikize kugalula choóna chóona. Káandi kulugiilila echilo echo nyini, tihalabweenwe muuntu ayaaleengesize kumubúuza búuza Yeézu amabúuzo agáandi. ");
INSERT INTO zin_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mbwéenu, Yeézu yaábagaambila embága za abaantu na abaheémba boómwe nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Abeégesa be ebilagilo na Abafarisayo beena obuhicha bwo kweégesa abaantu ebilagilo bya Musa. ");
INSERT INTO zin_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ha bwéecho, mukoondoókele kuluunzi áago balikubeegesa no kugakola góona. Náho mutaákuba nimukulaatila ebikolwa byáabo, habwo kuba boónyini tibakukola éebyo balikubeegesa. ");
INSERT INTO zin_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Boónyini bakoma ebilagilo byóona nke ensáho elikulemeela no kuzitwéeka abaantu aha mabega, náho boónyini tibakweenda kugolola no óobu olukumu lúmo babone kubahweela kuziímucha. ");
INSERT INTO zin_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Góona ago bakola, bakola babone kweéyoleka aha baantu. Óoku balikuzwáala omu buso bwáabo no omu ngalo záabo ebinogóka biháango bye eémpu biina amagaambo ge ebilagilo, no kwoongela olukugilo lwe emyéenda yáabo ye esaala zibe ndeehi kuchila eza abáandi. ");
INSERT INTO zin_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Omu bilo bya amazenyi, baba abalikweenda kwíikala omu bitébe bya abazenyi abeena isima. No óobu omu masomelo gáabo, baba abalikweenda kwíikala omu bitébe bya abakúlu. ");
INSERT INTO zin_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Káandi, beenda baángalúchwe na abaantu habwi isima omu magulizo, na nka nikwo babe nibeétwa, ‘Mweégesa.’ ");
INSERT INTO zin_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Náho íimwe, mutaákuba nimukuúnda kwéetwa, ‘Mweégesa,’ habwo kuba mwiina Omweégesa oómo weénka, íimwe mwéena hamo na abeekiliza bazeenzi beenyu. ");
INSERT INTO zin_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Káandi, mutaákuba nimumwéeta omuuntu weéna wéena, ‘Táata’ omu nsi ezi, habwo kuba mwiina Táata oómo weénka óogwo ali omu igulu. ");
INSERT INTO zin_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Káandi, mutaákuba nimukuúnda kwéetwa, ‘omweébeembezi,’ habwe ensoonga mwiina Omweébeembezi oómo weénka, náwe niwe Masihi. ");
INSERT INTO zin_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ahagáti yáanyu, óogwo ali mukúlu kusaaga abáandi, naayeéndelwa kuba omuzáana wáanyu. ");
INSERT INTO zin_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Omuuntu weéna wéena aleékuza weényini, Múungu alyaámuchéesha. Náho omuuntu weéna wéena óogwo alikweecheesha, Múungu alyaámukuza. ");
INSERT INTO zin_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nimwiilóoko yáanyu, íimwe abeégesa be ebilagilo bya Musa neemwe Abafarisayo! Íimwe ngóbya, habwo kuba nimubachigilila abaantu kuza omu bukáma bwo omu igulu habwa ameégeso gáanyu. Íimwe boónyini timukutaahamo omwo, káandi timukubakuúndila abaantu abáandi áabo balikweénda kutaahámo.  ");
INSERT INTO zin_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Nimwiilóoko yáanyu, íimwe abeégesa be ebilagilo bya Musa neemwe Abafarisayo! Íimwe ngóbya, habwo kuba nimusaba Múungu aha kusaba kuleehi bwooli mubóne kwéeyoleka aha baantu, kunu nimwaáka entuúmbakazi ebiintu byáabo. Mbwéenu, musoomboókelwe nka nikwo omu chilo cho omuchwaáziiko, mazima nimwiinaánkula omuchwaáziiko muháango kuluga hali Múungu. ");
INSERT INTO zin_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nimwiilóoko yáanyu, íimwe abeégesa be bilagilo bya Musa neemwe Abafarisayo! Íimwe ngóbya, habwo kuba nimuzoongoloka omulaambo gwóona no kwaambuka enyaanza, mubóne kumukoonga omuuntu óogwo ti Muyahudi kuba omuheémba we edíini yáanyu. Náho keélaaba yeékiliize omuuntu ogwo, nimumukola kuba omuuntu óogwo chimugasize omu lyoongoola lyo omulilo gwa kuzimu entúlo ibili kuchila íimwe! ");
INSERT INTO zin_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nimwiilóoko yáanyu, íimwe abatégeki abahume, habwo kuba nimweegesa abaantu nka nikwo, ‘Keélaaba omuuntu naalahila habwe éenzu ya Múungu, echilahiloche ti chiintu. Náho keélaaba naalahila habwe ezaháabu éezo elyo omu nzu ya Múungu, omuuntu ogwo naayeéndelwa kukola nko óokwo yaalahíile.’ ");
INSERT INTO zin_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Íimwe basilu, káandi abahume! Ni chiiha éecho echili chikúlu kusaaga echíindi, ne ezo ezaháabu éezo elyo omu nzu ya Múungu, nali ne éenzu ya Múungu éezo ekola ezaháabu ebone kuba entakatíifu habwa Múungu? ");
INSERT INTO zin_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Káandi nimweegesa abaantu nka nikwo, ‘Kaálaaba omuuntu naalahila habwi itaámbilo lyo omu nzu ya Múungu, echilahiloche ti chiintu. Náho keélaaba naalahila habwe echitáambo éecho chili aha lugulu yi itaámbilo, omuuntu ogwo naayeéndelwa kukola nko óokwo yaalahíile.’ ");
INSERT INTO zin_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Íimwe empume! Ni chiiha echiina obukaani buháango kuchila echíindi, ne echitáambo nali itaámbilo éelyo elikola echigabo kuba echitakatíifu? ");
INSERT INTO zin_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mbwéenu, keélaaba omuuntu naalahila habwi itaámbilo, naalahila na habwe ebitáambo éebyo bili aha lugulu yi itaámbilo. ");
INSERT INTO zin_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Káandi, keélaaba omuuntu naalahila habwe éenzu ya Múungu, naalahila habwe éenzu na habwa Múungu ogwo alikutúula omwo. ");
INSERT INTO zin_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Káandi, keélaaba omuuntu naalahila habwi igulu, bityo naalahila omu chitébe cho obutégeki cha Múungu na hali Múungu weényini ogwo ayikala aha lugulu yaácho. ");
INSERT INTO zin_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nimwiilóoko yáanyu, íimwe abeégesa be ebilagilo bya Musa neemwe Abafarisayo! Íimwe ngóbya, habwo kuba nimukwáata ebilagilo byo kusohoza ezáaka no óobu habwe ebiintu byo obukaani buche bwooli, nko otubabi two kuluungisa, ebiinzaali no omu bwóonza. Náho, nimuleka kukola amagaambo ge ensoonga bwooli omu ebilagilo bya Musa, éebyo no kuba ne ntúungwa nzima, kuzila echiganyizi, no kuba omuuntu omweésigwa ha baantu abáandi. Náho nimweendelwa kugakola góona, amaháango na amáche hamo. ");
INSERT INTO zin_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Íimwe muli abatégeki abahume, habwo kuba nimuswiiza ensohela omu kunywa, náho nimumila ntwaangabuleende yóona! ");
INSERT INTO zin_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nimwiilóoko yáanyu, íimwe abeégesa be ebilagilo bya Musa neemwe Abafarisayo. Íimwe na abagóbya, habwo kuba nimwiikola aha baantu nka nikwo muli abaantu musemiile omu méeso ga Múungu. Nimweéza ha kweétegeeleza ahéelu ye echikóombe no olulaangahi, náho timukubyeetaho kwéeza omuli íimwe, omwo bulimo obulofo bwíinzi, bwo obusaakuzi no kubulwa okwiíbalilila. ");
INSERT INTO zin_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Íimwe Abafarisayo abahume! Ha kubaanza mubileke ebiheno éebyo bili omuli íimwe, nko kwéeza obulofo obuli omu chikóombe. Bityo, ebikolwa byáanyu ebili ahéelu nabyo nibiba ebya amazima. ");
INSERT INTO zin_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nimwiilóoko yáanyu, íimwe abeégesa be ebilagilo bya Musa neemwe Abafarisayo! Íimwe ngóbya, habwo kuba muli nke eémbi éezo zitonilwe eswaakala. Ahéelu nizisemela, náho omugati agezwiile amagúfa ga bafwiile no obulofo bwe engaanda bunaanka bunaanka. ");
INSERT INTO zin_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tútyo neemwe, ahéelu nimwooleka ha baantu kuba abagololoke, náho amazima ni nka nikwo aha miganya yáanyu mwiizwiile obugóbya ne ebiheno kwoónka. ");
INSERT INTO zin_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nimwiilóoko yáanyu, íimwe beégesa be ebilagilo bya Musa neemwe Abafarisayo! Íimwe ngóbya, habwo kuba nimwoombeka eémbi za ababáasi ba Múungu no kuzichuma kuluunzi eémbi za abaantu abáandi abaabeele bali abagololoke omu méeso ga Múungu. ");
INSERT INTO zin_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Niho nimugaámba nka nikwo, ‘Íichwe kátwaakubeleho aha obuchilo óobwo baguúku béetu bakaba bali abalame, titwaákuhikize kuteélana nábo kwiita ababáasi ba Múungu.’ ");
INSERT INTO zin_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Óobu, habwo kugaamba mútyo, nimwaatula nka nikwo íimwe muli abáana ba baguúku báanyu áabo abaayisile ababáasi ba Múungu! ");
INSERT INTO zin_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mbwéenu, mwiizulize obuzilwa óobwo ba baguúku báanyu baátaandikile! ");
INSERT INTO zin_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nzóka mwe, íimwe oluzáalo lwe enzóka! Mulyeeliga muta no omuchwaáziiko gwa Múungu gwo kunagwa omu lyoongoola lyo omulilo gwa kuzimu?” ");
INSERT INTO zin_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Habwo kuba bityo, léeba, nibasiindika hali íimwe Abayahudi, ababáasi ba Múungu, abaantu abeena amasala habwa Maandiko Matakatíifu, na abeégesa. Náho omu lyáabo, nimubeéta no kubabaamba aha musalaba. Abáandi nimubakona enkoba omu masomelo gáanyu, na nimubakulaatiila no kubabiinga buli iboma kwi iboma. ");
INSERT INTO zin_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ha bwéecho, Múungu alyaábachwaáziika íimwe habwe enságama eyaaseesekile ahaansi habwo kwiitwa bóona abagololoke. Abo bakéetwa bátyo, kulugiilila obuchilo Kaini akamwíita Hábeeli ogwo akaba atéena ntaambala yoóna yóona, kuhicha kwíitwa Zakaria, omwaana wa Barakia, óogwo mwaáyisile ahagáti ye éenzu ya Múungu ni itaámbilo. ");
INSERT INTO zin_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mazima butúnu niimbagaambila nka nikwo, Múungu alyaáchwaáziika abaantu bo oluzáalo olu habwe ebiheno ebyo byóona.” ");
INSERT INTO zin_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Niho Yeézu yaágaamba, “Íiwe Yeruzaléemu, Yeruzaléemu! Nooyita ababáasi, no kubahoonda na amabáale abaantu áabo Múungu abasiindikile hali íiwe. Entúlo nyíinzi nkaba niinyeénda kubakobya kobya abaantu baawe, nko óokwo enkóko ekobya kobya otuzwíiyo twaáyo omu manana gaáyo, náho buli ntúlo timuleenzile! ");
INSERT INTO zin_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Léeba, Múungu naazileka eéka yáanyu kuba amatoongo. ");
INSERT INTO zin_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mbwéenu, niimbagaambila, timuliimbona káandi, kubaandiza óobu kuhicha obuchilo óobwo mulyaágaamba nka nikwo, ‘Ayina omugisa ogwo alikwiiza ahi izíina lyo Omukáma Múungu!’ ” ");
INSERT INTO zin_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeézu yaáluga aha lubúga lwe éenzu ya Múungu. Obuchilo naaluga omwo, abaheémba boómwe baámwiílililaho babone kumwoóleka emyoombekele ye éenzu ya Múungu. ");
INSERT INTO zin_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Náho Yeézu yaábagaambila aáti, “Mwaábona kuluunzi amazu aga góona? Mazima butúnu niimbagaambila nka nikwo, tililisigalilaho ikúlugusi éelyo lilihuungaho aha lugulu ye eliindi, buli límo lilyaákaambulwa!” ");
INSERT INTO zin_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mbwéenu, Yeézu yaázeenda omu ibaanga lye Emizeituni, yeékala ali weénka. Abaheémba boómwe bamukulaatíla bali boónka, baámubúuza báti, “Tugaambile, amagaambo áago galyáaba iíli? Káandi, ni chiíha éecho chiliba emanyiso yo kusuba kwaawe no omuhélo gwe éensi?” ");
INSERT INTO zin_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeézu yaábagalulila aáti, “Mube méeso, omuuntu weéna wéena ataákwiiza kubabéeha! ");
INSERT INTO zin_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Abaantu béenzi balyéeza ahi izíina lyaanze, nibagaámba nka nikwo, ‘Íinye níinye Masihi!’ Abaantu áabo baláaba abalikubéeha abaantu béenzi. ");
INSERT INTO zin_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Káandi, nimuba nimuhulila empola ne ensumo zi ichúmu. Mulaleeba, mutaákwiiza kutíina, habwo kuba ago ni lwaampaka gabone kubonwa, náho omuhélo gwe éensi niguba gucháali kuhika. ");
INSERT INTO zin_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Éensi eémo elyaálwaana ne eéndi, no obukáma búmo bulaálwaana no obúundi. Enzala no kuteengeta kwe éensi bileésuululukiza ahaantu bunaanka bunaanka. ");
INSERT INTO zin_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ago góona nigaba nko obutaándikilo bwo obusúungu bwo omukázi óogwo alikweenda kweéchuungula. ");
INSERT INTO zin_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Omu buchilo óobwo, abaantu balaabakoongakóonga íimwe, mubóne kwaágalazwa no kwiitwa, na abaantu ba mahaánga góona nibabatamwa habwo kuba muli abaheémba baanze. ");
INSERT INTO zin_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Niho abaantu béenzi balyaáleka kuunkulaatila. Balyáaba nibanobana no kweétamwa boónyini omuli boónyini. ");
INSERT INTO zin_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Omu obuchilo óobwo, baláaba nibeesuúlulukiza ababáasi béenzi be ebisuba, babeéhe abaantu béenzi. ");
INSERT INTO zin_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na habwe ebiheno kukanya, abaantu béenzi balyaábulwa engoonzi. ");
INSERT INTO zin_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Náho, weéna wéena óogwo aleegumisiliza kuhika ihelezo, niwe alichuungulwa na Múungu. ");
INSERT INTO zin_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Empola ezi Nzima habwo obukáma bwo omu igulu zilaáyatulilwa obuchilo bwóona omu nsi yóona. Obuchilo óobwo abaantu ba amahaánga góona baláaba baabweene omwáanya gwo kuhuliiliza okusíinza okwo, niho ihelezo lye éensi libeho.” ");
INSERT INTO zin_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Haláaba no obuchilo óobwo mulaabona ‘echitamiso cho busiisaguzi,’ chimeeliile ahaantu ahatakatíifu he éenzu ya Múungu. Echiintu echo nicho chaagaambilwe no omubáasi Danyéeli. Omuuntu weéna wéena óogwo alikusoma amagaambo aga, amanye kuluunzi ensoonga yaágo. ");
INSERT INTO zin_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Niho abaantu abali Yudea, beéchize aha kwiílukila omu mabaanga! ");
INSERT INTO zin_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Náwe omuuntu óogwo aliba ahanamile aha luswi, atuúke aze kwiíluka bwaangu, atáza omu nzu kwiimucha ebiintu byoómwe. ");
INSERT INTO zin_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bityo nyini, omuuntu weéna wéena óogwo aláaba ali omu musili, ataákusuba enyuma kwiimucha ebebo yoómwe. ");
INSERT INTO zin_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nimwiilóoko, abakázi abeena éenda na áabo baláaba niboóncha abáana báabo omu bilo ebyo! ");
INSERT INTO zin_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bityo mbwéenu, mumuneembelele Múungu nka nikwo kulwaana kwéenyu kutaákwiiza kuba omu buchilo bwe embého mpaango nali omu chilo che Endaálikizo. ");
INSERT INTO zin_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Amazima, omu bilo éebyo, abaantu balaabona ebyaágalalo biháango bwooli. Ebyaágalalo nke ebyo, bichaaliga kubaho kulugiilila obutaándikilo bwe éensi kuhicha leélo ezi, na tibilibonwa nakáti. ");
INSERT INTO zin_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kaálaaba Múungu takanogweele ebyo bilo byo olwaágalalo, mbwéenu tihaákuzizile no omuuntu no oómo óogwo ayaakuchizile. Náho kwoónka habwa abatooziibwe na Múungu, ebyo bilo bilyaánogolwa. ");
INSERT INTO zin_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Mbwéenu, aha buchilo obwo, kaálaaba omuuntu weéna weéna naabagaambila nka nikwo, ‘Léeba, Masihi ali aha!’ nali ‘Ali okwo!’ mutamwiíkililiza. ");
INSERT INTO zin_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nibabaho ababáasi be ebisuba na abaantu áabo baláaba nibeeyeta nkokwo ni Masihi. Baláaba nibooleka emanyiso na amahano go kusobeza. Bityo babone kubahabisa abaantu, na kábilaaba nibikuundilana, no óobu abatooziibwe ba Múungu. ");
INSERT INTO zin_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mube méeso! Naábagaambiile kala góona áago agacháali kweéloonga kubaho. ");
INSERT INTO zin_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kábalaaba abaantu nibabagaambila nka nikwo, ‘Léeba, Masihi ali óokwo omu nsi yo obwoóma!’ mutaákwiiza mukazáyo óokwo. Nali keélaaba nibabagaambila nka nikwo, ‘Léeba, ayeselekile omu nzu ezo,’ mutaákwiiza mukabeékililiza. ");
INSERT INTO zin_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Musoomboókelwe nka nikwo kwiiza kwaanze íinye Mutábani wo Omuuntu, nikuba nko olulábyo lulábya kuluga obutúluka, lukabonelwa ahonyini obugwa. ");
INSERT INTO zin_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Chilyáaba butúnu, nko óokwo hóona aheena enyameéswa efwíile, niho empuungu zikoba.” ");
INSERT INTO zin_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Léeba, obuchilo ebilo ebyo bye ebyaágalalo byaáhiíngwiile, izóoba nilitelwáho ensiimbaazi, okwéezi tikulisohoza káandi omwaanga, ne enyenyéezi názo nizigwa ahaansi kuluga omu igulu. Amagala go omu igulu galaázugumisibwa. ");
INSERT INTO zin_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Niho emanyiso yo Omutábani wo Omuuntu elaábonwa aha bwíile, na abaantu be endími zóona zo omu nsi nibabaanza kubolooga aha kutahwa tahwa. Íinye ndyéeza na abaantu bóona baláaba nibaambona omu bwíile kunu nnyizwiile amagala ni ikuzo likúlu. ");
INSERT INTO zin_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Niho ndyaásiindika bamaléeka baanze. Balaatela bwooli echikuli, babone kukumiinga abatooziibwe bóona ba Múungu kuluga buli hóona, omu nkási zóona ze éensi.” ");
INSERT INTO zin_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yeézu yaázeendelela kugaamba aáti, “Mweéyege kuluga omugani gwo omutini. Obuchilo amatábazi gaágwo gaáyolobile gaátiilého emisebuko na amababi gaáyasize, niho musoombookelwa nka nikwo obuchilo bwe echaanda bweéliliza. ");
INSERT INTO zin_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bityo nyini neemwe, obuchilo nimubona ago góona gaákolwa, musoomboókelwe nka nikwo weényini ali héehi, yaáhikile aha lwiizi. ");
INSERT INTO zin_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mazima butúnu niimbagaambila nka nikwo, abaantu bo obu buchilo tibakuhwáho obuchilo amagaambo ago góona gatakeésuululukiize. ");
INSERT INTO zin_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Igulu ne éensi nibihwa, náho amagaambo gaanze tigalihwa nakáti. ");
INSERT INTO zin_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Náho habwe echilo nali esáaha éezo amagaambo ago nigabáho, táliho omuuntu óogwo alikumanya. No óobu bamaléeka bo omu igulu nali Mutábani wa Múungu tibakusoombookelwa, náho Táata weénka. ");
INSERT INTO zin_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ha bwéecho, nko óokwo ekaba omu bilo bya Núhu, nikwo bilibaho ebilo byo kusuba kwaanze íinye Mutábani wo Omuuntu. ");
INSERT INTO zin_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Omu bilo éebyo obuchilo enzula yo kusiingaalicha ekaba etakeezile, abaantu bakaba nibalya no okunywa, bakaba nibasweéla na kuswéelwa, kuhicha echilo éecho Núhu yaátaahile omuli safína. ");
INSERT INTO zin_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Abaantu abo, tibalamanyile ni chiíha echilaabaho, kuhicha obuchilo améenzi agali méenzi geezile no kubasikiza bóona. Bityo nikwo óokwo chilyáaba obuchilo íinye Mutábani wo Omuuntu niinyíza. ");
INSERT INTO zin_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Habwo obuchilo obwo, keélaaba abaantu bábili bali omu musili, oómo aleéhibwaho no oóndi alaásigwaho. ");
INSERT INTO zin_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Káandi, keélaaba abakázi bábili balyáaba nibasa aha lubeengo, oómo aleéhibwaho no oóndi alaásigwaho. ");
INSERT INTO zin_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mbwéenu, mwiikale nu méeso, habwo kuba timukusoombookelwa ni chilo chi éecho íinye Omukáma wáanyu ndiíza. ");
INSERT INTO zin_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Náho mumanye kuluunzi nka nikwo, nka kanyina we éenzu kiyaakumanyile omwáanya gwi itúumbi óogwo omwíibi alikwiiza, mbwéenu yaakeékeele méeso kuba omwíibi tiyaákutaahilémo omúka yoómwe. ");
INSERT INTO zin_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ha bwéecho mbwéenu, neemwe mube mweéloongize, habwo kuba íinye Mutábani wo Omuuntu ndyéeza omu buchilo óobwo mutakutegeza.” ");
INSERT INTO zin_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yeézu yaábabúuza abaheémba boómwe aáti, “Mbwéenu, noóha omuzáana óogwo ali omweésigwa no owa amasala? No omuzáana óogwo omukáma woómwe amutiile kuba omwiímeelelezi wa abazáana abáandi omúka yoómwe, abone aábe naabaha ebyookulya aha buchilo obulikugasa. ");
INSERT INTO zin_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Naába ayina omugisa weényini omuzáana óogwo omukáma woómwe kaálaasuba kuluga omu luzeendo, no kumusaanga naakola aátyo. ");
INSERT INTO zin_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mazima butúnu niimbagaambila nka nikwo, omukáma woómwe naamutáho aábe omwiímeelelezi we ebiintu byoómwe byóona. ");
INSERT INTO zin_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Náho omuzáana mubi no óogwo ateekuza omu mwooyo gwoómwe nka nikwo, ‘Omukáma waanze yeélililwa kusuba.’ ");
INSERT INTO zin_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Niho abaanza kutéela abazáana bazeenzíbe, no kulya no okunywa amaálwa hamo na abatamiizi. ");
INSERT INTO zin_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mbwéenu, mukáma wo ogwo muzáana alyéeza aha chilo chi atakutégeza na aha buchilo obwo atakumanya. ");
INSERT INTO zin_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Niho omukáma woómwe alaámunogagula ebinogoka bibili no kumunaga áaho abagóbya bali. Okwo niho okwo abaantu nibachula no kusa améeno.” ");
INSERT INTO zin_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Niho Yeézu yaábagaambila abaheémba boómwe omugani ogúundi aáti, “Aha mwáanya ogwo, obukáma bwo omu igulu bulaásusaniswa no omususano ogu. Hakaba heena abahalákazi ikúmi aba biíkila abo bakeemucha emuli záabo no kuzeenda omu meenga kumusuúngaana chisweéla. ");
INSERT INTO zin_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bataanu omuli abo ikúmi, bakaba bali abasilu, náho abo abáandi bataanu bakaba bali abeena amasala. ");
INSERT INTO zin_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Óobu abahalákazi abo abasilu beemuchize emuli záabo, baáleka kutwáala amazuta. ");
INSERT INTO zin_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Náho obuchilo abeena amasala beemuchize emuli záabo, bakeemucha hamo na amazuta omu nyabya záabo. ");
INSERT INTO zin_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Obuchilo chisweéla káyeliilwe kwiiza, abahalákazi abo bóona baátwaalilizibwa otúlo, bahunila. ");
INSERT INTO zin_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Náho ahagáti yi itúumbi, bahulila abaantu nibateéla eyoombo nka nikwo, ‘Boózo boózo, chisweéla yéeza! Nimusohole, muzeénde kumusuúngaana!’ ");
INSERT INTO zin_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ahonyini, abahalákazi abo bóona beémuka, basemeza emuli záabo. ");
INSERT INTO zin_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Baliinya abo abahalákazi bataanu abasilu, baábagaambila abo aba amasala nka nikwo, ‘Nitusaba mutuzuneho otuzuta tuche túti, habwo kuba emuli zéetu nizilaála.’ ");
INSERT INTO zin_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Náho baábagalulila nka nikwo, ‘Mmahi! Titukwiíle kubazuna, habwo kuba amazuta áago twiinágo, nigaléba hali íichwe hamo neemwe. Haáchili muzeénde aha basúluza ba amazuta, muze kweégulila agáanyu.’ ");
INSERT INTO zin_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Mbwéenu, abahalákazi abo abasilu baázeenda kugula amazuta. Obuchilo baabeele nibazeénda, náwe chisweéla aba yaáhika. Abahalákazi abeena obwéenze abaabeele beétégekile, baataáhamo náze chisweéla omu nzu ya amazenyi go obweenga. Mála, olwiizi luba lwaáchíingwa. ");
INSERT INTO zin_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ha muheleeluko, abo bahalákazi abasilu baba baásuba, baábaanza kwéeta chisweéla nka nikwo, ‘Íiwe mukáma! Íiwe mukáma! Otuchiíngulile olwiizi!’ ");
INSERT INTO zin_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Náho weényini yaábagalulila nka nikwo, ‘Mazima butúnu niimbagaambila, íimwe hanu, tiínkubamanya!’ ” ");
INSERT INTO zin_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aho Yeézu yaágwiisiliza ha kugaamba aáti, “Mbwéenu, mwiikale nu méeso, habwo kuba timukusoombookelwa echilo nali akachilo.” ");
INSERT INTO zin_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yeézu yaázeendelela ha kuchwa omugani ogúundi, yaágaamba aáti, “Káandi, obukáma bwo omu igulu bulaásusaniswa nko omuuntu óogwo ayaachuumbiile oluzeendo lwa hala. Obuchilo atakabaandize oluzeendo lwoómwe, yaáyéta abazáana boómwe, yaábabiíkisa ebiintu byoómwe babone kubyeémanya. ");
INSERT INTO zin_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yaámuha buli muzáana kwiingana ne embalililo ya amagala goómwe. Yaaha owo kubaanza etalaanta itaanu, owa kábili etalaanta ibili no oóndi etalaanta eémo. Niho akeemuka yaálibata. ");
INSERT INTO zin_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Ahonyini, omuzáana óogwo yaaheelwe etalaanta itaanu, yaázeenda názo yaázisuluza no kutuunda etalaanta ezíindi itaanu. ");
INSERT INTO zin_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bityo nyini, omuzáana óogwo ayaaheelwe etalaanta ibili, yaázeenda názo omu isúluza no kutuunda etalaanta ezíindi ibili. ");
INSERT INTO zin_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Náho omuzáana óogwo akahaabwa etalaanta eémo, weényini akazeenda yaásuma eliina omu itaka no kuziseleka etalaanta ezo ya mukáma woómwe. ");
INSERT INTO zin_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ebilo bíinzi kábyaachíile, omukáma wa abazáana abo aba yaásuba. Niho yaáyéta abazáana boómwe, abone kubala hamo nábo amabonwa ge empilya zoómwe. ");
INSERT INTO zin_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Oliinya omuzáana ayaaheelwe etalaanta itaanu ayiza, ayihaho etalaanta ezíindi itaanu, agaambila mukáma woómwe nka nikwo, ‘Láma mukáma, íinye okaba ombikisize etalaanta zaawe itaanu mbone kuzeémanya. Léeba, mbonesize etalaanta ezíindi itaanu ezi naátuunzileho.’ ");
INSERT INTO zin_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Omukáma woómwe amuzila aáti, ‘Yéla, muzáana waanze muzima ne enyésigwa! Okaba omweésigwa ha bíche éebyo naákuhéele, ha bwéecho niinkukola kuba omwiímeelelezi we ebiintu bíinzi. Iíza obaánze kunulilwa hamo neenye.’ ");
INSERT INTO zin_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Omuzáana óogwo ayaaheelwe etalaanta ibili, náwe yéeza, yaámugaambila mukáma woómwe nka nikwo, ‘Láma mukáma waanze, okaámpa etalaanta ibili mbone kuzikolela emilimo. Léeba, mbonesize etalaanta ezíindi ibili ezi naátuunzileho.’ ");
INSERT INTO zin_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Mukáma woómwe yaámuzila nka nikwo, ‘Yéla, muzáana waanze muzima ne enyésigwa! Okaba omweésigwa ha bíche éebyo naákuhéele, ha bwéecho, niinkukola kuba omwiímeelelezi we ebiintu bíinzi. Iíza obaánze kunulilwa hamo neenye.’ ");
INSERT INTO zin_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Náho omuzáana óogwo ayaaheelwe etalaanta eémo, yéeza no kumugaambila mukúlu woómwe nka nikwo, ‘Láma mukáma waanze, niinkumanya nka nikwo íiwe oba omuuntu we echáaha bwooli. Habwo kuba íiwe ogesa omwéezo áaho otahaambile, no kusuumbya áaho otasaambaalize. ");
INSERT INTO zin_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mbwéenu íinye nkatíina kuzibuza etalaanta yaawe, ha bwéecho nkazeenda kuziseleka omu itaka. Léeba, okwaáte etalaanta yaawe, niyo ezi.’ ");
INSERT INTO zin_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Omukáma woómwe yaámugalulila nka nikwo, ‘Íiwe muzáana we nzilwa, chileengáwe! Óobu waabele noomanya nka nikwo ngesa áaho ntabibile na káandi nsuumbya áaho ntasaambaalize, ");
INSERT INTO zin_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","mbwéenu ha bwaáchi tolaazisulwiize etalaanta yaanze okazituunda na abatuunzi? Obuchilo bwo kusuba kwaanze, naakaábonesize etalaanta yaanze hamo ne ensaága yaáho.’ ");
INSERT INTO zin_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Niho omukáma woómwe yaálagila abáandi nka nikwo, ‘Nimwiilóoko mumwaáke ogu etalaanta ezo, muzimuhe omuzáana ogwo ayina etalaanta ikúmi. ");
INSERT INTO zin_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Manya sii, omuuntu óogwo aheelwe ebiintu akabikolesa emilimo, alyaágabilwa akanyise. Náho omuuntu óogwo aheelwe ebiintu náho akaleka kubikolesa emilimo, mazima na áako ayebikiliíze, alyaáyakwa. ");
INSERT INTO zin_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","No ogwo muzáana atéena mugaso gwoóna gwóona. Mumunáge ahéelu omu nsiimbaazi, niho haláaba okuchula no kusa améeno.’ ” ");
INSERT INTO zin_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yeézu yaázeendelela kuhooya na abaheémba boómwe, yaábagaambila aáti, “Obuchilo íinye Mutábani wo Omuuntu ndiíza omu ikuzo lyaanze, hamo na bamaléeka bóona, nibwo ndiikala aha chitébe cho obutégeki bwi ikuzo lyaanze. ");
INSERT INTO zin_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Abaantu ba mahaánga góona balaákoba omu méeso gaanze. Neenye ndyaábona kubasoloola hala hala nko óokwo omulíisa asolooláho entaama kuluga omu mbúzi, ");
INSERT INTO zin_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ndyaázita entaama olubazu lwo omukóno gwaanze gwo obúlyo, abo nibo abeena entúungwa nzima, náho embuzi ndyaázita olubazu lwo omukóno gwaanze gwo obumoso, abo nibo abaantu abaheni. ");
INSERT INTO zin_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Niho íinye Omukáma, ndyaábagaambila áabo abali aha lubazu lwaanze lwo obúlyo nka nikwo, ‘Nimunyegele, íimwe áabo abahiliilwe okufúuhwa na Táata, mwiíze mubóne kutúula omu bukáma óobwo Múungu yaábaloongiize kulugiilila obuchilo bwo kuhaangwa kwe éensi. ");
INSERT INTO zin_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Habwo kuba obuchilo naalíilwe enzala, mukaambónecha ebyookulya. Obuchilo naázizile iliho, mukaámpa améenzi go kunywa. Obuchilo naábeele ndi omuzenyi, mukaannyegeza omu maka gáanyu, ");
INSERT INTO zin_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","obuchilo naábeele ndi busa, mukaanzwéeka emyéenda. Obuchilo naálwéele, mukaandwáaza. No obuchilo naábeele ndi omu ibóhelo, mukaanyizáho.’ ");
INSERT INTO zin_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Niho, abo abagololoke balaángalulila nka nikwo, ‘Láma Mukáma wéetu, ni buchilo chi óobwo twaákubwéene olumilwe enzala tukakuha echookulya? Nali oyina iliho tukakuha ago okunywa? ");
INSERT INTO zin_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Káandi, ni buchilo chi óobwo twaákubwéene oli omuzenyi tukakunyegeza omu maka géetu? Nali óobu twaákubwéene oli busa tukakuzwéeka emyéenda? ");
INSERT INTO zin_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Káandi, ni buchilo chi óobwo twaakusaangile oli omulwéele tukeeza kukuleeba, nali óobu waabele oli omu ibóhelo tukakuyeélela?’ ");
INSERT INTO zin_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Niho íinye Omukáma ndyaábagalulila nka nikwo, ‘Mazima butúnu niimbagaambila nkokwo, choóna chóona éecho mwaabele nimumuzilila oómo omuto omuli badugu baanze, mbwéenu mukaba nimuunzilila íinye hanu.’ ");
INSERT INTO zin_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Niho, ndyaábagaambila áabo abali olubazu lwo omukóno gwo obumoso nka nikwo, ‘Muluhéendého aha, íimwe abacheenilwe! Muzeénde omu mulilo ogutalaala óogwo Múungu yaaloongize habwi Isitáani na bamaléeka baályo. ");
INSERT INTO zin_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Muzeénde, habwo kuba obuchilo naalíilwe enzala, mukabula kuúmpa echookulya. Obuchilo nkazila iliho, mukabula kuúmpa echo okunywa. ");
INSERT INTO zin_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Obuchilo nkabataahila ndi omuzenyi, mukabula kuunyegeza omu maka gáanyu. Obuchilo naálibasile busa, mukabula kuunzwéeka emyéenda. Obuchilo naábeele ndi omulwéele, mukabula kwiiza kuúndeeba. No obuchilo naábeele ndi omu ibóhelo, mukabula kuúndeeba.’ ");
INSERT INTO zin_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Mala, niho na abo baantu balaágalula báti, ‘Láma Mukáma wéetu, ni buchilo chi óobwo twaákubwéene oyina enzala, nali oyina iliho, nali oli omuzenyi, nali okaba olibasile busa, nali oli omulwéele, nali oli omu ibóhelo, neechwe tukakunagilana tukabula kukuhweela ebyo byóona?’ ");
INSERT INTO zin_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Niho neenye ndyaábagalulila iínti, ‘Mazima butúnu niimbagaambila nka nikwo, choóna chóona éecho mukabula kumuzilila weéna wéena omuli aba abali abaantu kanaku, neenye nyini mukaba mutakuunzililáze.’ ");
INSERT INTO zin_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Mbwéenu nu, abo abaheni, nibaluhéende bazeénde kwaágalala obucha no obuchiile. Náho abo abagololoke omu meeso ga Múungu, nibabaanza kubunulilwa obulami obutahwaho.” ");
INSERT INTO zin_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Obuchilo Yeézu káyaamazile kugaamba amagaambo ago góona, yaábagaambila abaheémba boómwe nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nko óokwo mulikusoomboókelwa, kábilaaba byaáhiíngwiile ebilo bibili, nihaba na amazenyi ga Paásika. Omu chilo echo, íinye Mutábani wo Omuuntu niinkoóbibwa, mbone kubaambwa aha musalaba.” ");
INSERT INTO zin_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mbwéenu, obuchilo obwo, abakúlu ba abagabe na abanyaampala ba Abayahudi baákoba aha lubuga lwe eéka yo omugabe mukúlu óogwo izíina lyoómwe akaba ayétwa Kayafa. ");
INSERT INTO zin_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Omwo, bakabiteélana nka nikwo óokwo baayeenzileho kumukwáata Yeézu habwe eseleke, babone kumwíita. ");
INSERT INTO zin_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Náho, bakabiteélana báti, “Tutaákwiiza tukakola aga omu mazenyi ga Paásika, abaantu bateéza bakakola omusaambo.” ");
INSERT INTO zin_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Niho Yeézu yaázeenda omuli Betania, yeékala omúka ya Simoni óogwo kala akaba ayina endwáala yo obubéembe. ");
INSERT INTO zin_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Obuchilo Yeézu akaba ali aha luhelo kulya, omukázi oómo yéeza hali weényini ayina olwaaba lwi ibáale eliina omuzeeze gwo obukaani buháango bwooli. Omukázi ogwo yaágamwiítilila Yeézu omu mútwe. ");
INSERT INTO zin_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Obuchilo abaheémba boómwe kábaabweene ago, baátamwa. Baágaamba báti, “Boózo! Ha bwaáchi ogu mukázi naasíisa amazuta aga go obukaani buháango aáti? ");
INSERT INTO zin_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yakabeele kuzima amazuta aga gaguzwe aha mpilya nyíinzi bwooli, zikaázunile abahabi!” ");
INSERT INTO zin_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeézu óobu akeeza yaámanya amagaambo ago, yaábagaambila aáti, “Ha bwaáchi nimumwaagalaza ogu mukázi? Weényini yaánkolela echigaambo chi ikuzo bwooli. ");
INSERT INTO zin_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Abahabi mwiikala hamo nábo buchiile, náho íinye timuliikala hamo neenye buchiile. ");
INSERT INTO zin_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Omukázi ogu yaányitilila amazuta, yaáchikola aha kuúndoongeza omubili gwaanze habwo okuziikwa kwaanze. ");
INSERT INTO zin_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mazima butúnu niimbagaambila nka nikwo, omu nsi zóona, hoóna hóona áaho abaantu baláaba niboolekeelela Empola Nzima ezi, baláaba nibagaámba éecho akakola omukázi ogu, ha kumwiízuka.” ");
INSERT INTO zin_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Niho oómo omu baheémba ba Yeézu ikúmi na bábili, óogwo ayaabeele naayétwa Yuda Iskariote, yaázeenda aha bakúlu ba abagabe, ");
INSERT INTO zin_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yaábabúuza aáti, “Nimuundiha chiíha kiíndaahicha kumubaheéleza Yeézu omu ngalo záanyu?” Niho baámuliha ebinogoka bye empilya makúmi asatu. ");
INSERT INTO zin_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kubaandiza obuchilo obwo, Yuda yaábaanza kuloondela omuháanda gwo kumubaheéleza Yeézu omu ngalo záabo. ");
INSERT INTO zin_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aha chilo cho kubaanza cha amazenyi ge emikaate éezo etatiílwémo ituumbyo, abaheémba ba Yeézu beeza hali weényini, baámubúuza báti, “Nooyeénda tuzeénde kukuloongeza echookulya cha Paásika nkáhi?” ");
INSERT INTO zin_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yeézu yaábazila aáti, “Muzeénde omu chikaali, owo omuuntu bunaanka, mumugaambile muti, ‘Omweégesa yaátusiíndika na naagaámba aáti, Obuchilo bwaanze bweéliliza kuhika. Owaáwe niho ndikulíila amazenyi ga Paásika, íinye hamo na abaheémba baanze.’ ” ");
INSERT INTO zin_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Abaheémba boómwe baázeenda baákola góona nko óokwo Yeézu yabalagiíliile, baáloonza ebyookulya bya Paásika. ");
INSERT INTO zin_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Obuchilo habeele olweébazo, Yeézu na abaheémba boómwe ikúmi na bábili beékala aha luhelo kulya ebyookulya. ");
INSERT INTO zin_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Obuchilo bakaba nibalya, Yeézu yaábagaambila aáti, “Mazima butúnu niimbagaambila nka nikwo, oómo omuli íimwe naayiza kuúnkoonga.” ");
INSERT INTO zin_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Abaheémba boómwe baákamaala bwooli, baábaanza kumubúuza oómo oómo báti, “Láma Mukáma, mazima tíwe íinye?” ");
INSERT INTO zin_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeézu yaábasubiza aáti, “No óogwo alikukoza hamo neenye, niwe alaánkoonga. ");
INSERT INTO zin_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Íinye Omutábani wo Omuuntu, niinyítwa nko óokwo eyaandikilwe omu Maandiko Matakatíifu. Náho neelóoko omuuntu óogwo alaánkoonga. Yakabeele kuzima hali weényini hachili tiyaákuzeelwe!” ");
INSERT INTO zin_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mbwéenu, Yuda ogwo enkoonga wa Yeézu, náwe yaámubúuza aáti, “Láma Mweégesa, mazima tíwe íinye?” Yeézu yaámugalulila aáti, “Níiwe waágaamba.” ");
INSERT INTO zin_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mbwéenu, obuchilo bakaba nibalya, Yeézu yeemucha omukaate, yaámusiima Múungu, yaágumenyula, yaábaha abaheémba boómwe, yaábagaambila aáti, “Mwaanaánkule mulye, ogu nigwo omubili gwaanze.” ");
INSERT INTO zin_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yeemucha ne echikóombe éecho echikaba chiina evíini, yaásiima Múungu, yaábaha, yaábagaambila aáti, “Mwaanaánkule evíini ezi, munyweeleláne íimwe mwéena. ");
INSERT INTO zin_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Evíini ezi niyo enságama yaanze ye endagano. Enságama yaanze elaaseéseka habwa abaantu béenzi, kuba Múungu kubaganyila ebiheno byáabo. ");
INSERT INTO zin_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Niimbagaambila nka nikwo, kulugilila óobu tiínchisubiile kunywa káandi evíini ye emizabibu kuhika ahali echo chilo chi ndizinyweeláho evíini ye ensoonga eénsha hamo neemwe omu bukáma bwa Táata.” ");
INSERT INTO zin_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Niho baázina oluzina lwo kumusiingiza Múungu. Obuchilo baámazile kuzina, baalugáho, baázeenda omu ibaanga lye Emizeituni. ");
INSERT INTO zin_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mbwéenu, Yeézu yaábagaambila abaheémba boómwe aáti, “Leélo omu chilo mwéena nimuunyiluka. Nigaba nka nikwo Múungu agaambile omu Maandiko Matakatíifu nka nikwo, ‘Ndyaátéela omulíisa, no obusho bwe entaama bulaábuungeela.’ ");
INSERT INTO zin_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Náho íinye obuchilo óobwo ndiba naázweelwe, ndyaábeebeembelela kuzeenda Galiláaya.” ");
INSERT INTO zin_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Niho Peétero yaámugaambila Yeézu aáti, “No óobu bilaaba bóona balaákunagilana, íinye tiínkukunagilana nakáti!” ");
INSERT INTO zin_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeézu yaámugalulila aáti, “Mazima butúnu niinkugaambila nka nikwo, obuchilo enkoókolomi etakakoókolomile itúumbi éeli, noóba waányogile entúlo isatu.” ");
INSERT INTO zin_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peétero yaámusubiza aáti, “Nóobwo kufwa, ni lwaampaka iínfwe neewe, tiíndi wa kukwáanga íiwe nakáti!” Abaheémba abáandi bóona baágaamba bátyo nyini. ");
INSERT INTO zin_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mbwéenu, Yeézu yaázeenda na abaheémba boómwe omu musili óogwo ogulikwéetwa Getisemane. Yaábalagila aáti, “Muundiindiilile aha, íinye niinzeénda okwo kusaba Múungu.” ");
INSERT INTO zin_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yeeháho Peétero hamo na abatábani bábili ba Zebedayo. Yeézu yaábaanza kuzuzubalilwa no kuzolelwa bwooli. ");
INSERT INTO zin_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Niho yaábagaambila aáti, “Omwooyo gwaanze gwiina entíimba bwooli kuhicha nóobu kufwa! Muundiindiilile aha, mubuchiíse hamo neenye.” ");
INSERT INTO zin_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yeelilaho nka aho kache, yáagwa ahaansi buzuúma, aleembeleza Múungu aáti, “Íiwe Táata, kábilaaba nibikuundilana, niinkusába onyihileho echikóombe éechi cho olwaágalalo, náho oteéza okakola nko óokwo íinye ndikweendaho, choónka okole nko óokwo íiwe buli obweenzi bwaawe.” ");
INSERT INTO zin_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Niho, Yeézu yaásuba áaho akaleka abaheémba boómwe, yaábasaanga bahuniile otúlo. Yaámubúuza Peétero aáti, “Ngási, mwaálemwa kwiikala méeso hamo neenye no óobu ahi isáaha límo? ");
INSERT INTO zin_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mwiikale nu méeso no kusaba Múungu, mutaákwiiza mukaleengeswa. Omwooyo nigweénda kweégumisiliza ebileengeso, náho omubili tigwíina amagala.” ");
INSERT INTO zin_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yeézu yaábasiga aho káandi, yaázeenda okwo ha ntúlo ya kábili, aleembeleza Múungu aáti, “Íiwe Táata, keélaaba ebyaágalalo ebi bitakuhicha kuluga hali íinye, mbwéenu ozile kwe engoonzi zaawe.” ");
INSERT INTO zin_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mbwéenu, obuchilo yaásubile aha baheémba boómwe, yaábasaanga bali omu túlo káandi, habwo kuba améeso gáabo gakaba galemeeliilwe endoólo. ");
INSERT INTO zin_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yeézu yaábaleka káandi, yaázeenda kuneémbelela Múungu aha ntúlo ya kásatu, yaasubámo ha kugaamba amagaambo ago nyini. ");
INSERT INTO zin_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mbwéenu, obuchilo yaásubile káandi aha baheémba boómwe, yaábagaambila aáti, “Mbwéenu kamuchaali muchihumwiíle no kuhunila? Muleebe! Obuchilo bwe ebileengeso byaanze bweéliliza kuhika, neenye Omutábani wo Omuuntu nze kukobezibwa omu ngalo ze enkola bíbi. ");
INSERT INTO zin_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nimwiimuke, tuzeénde. Léeba! Enkoonga yaanze yeéliliza!” ");
INSERT INTO zin_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Obuchilo óobwo Yeézu akaba acháali naahoóyela amagaambo ago, léeba, Yuda, oómo omu baheémba boómwe ikúmi na bábili, yéeza hamo ne embága mpáango ya abaantu abeena embáadi ne engoligo. Embága ezo ekaba esiindikilwe na bakúlu ba abagabe na abanyaampala ba Abayahudi. ");
INSERT INTO zin_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda óogwo enkoonga koongi wa Yeézu, akaba yaabamanyisize áabo baantu emanyiso. Akaba abagaambiile aáti, “Omuuntu óogwo ndaanyweégela, niwe óogwo nyini, mumukwáate.” ");
INSERT INTO zin_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda kaáhika hali Yeézu, ahonyini, amugaambila aáti, “Kasíinge, Mweégesa!” Niho yaámunyweégela. ");
INSERT INTO zin_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeézu yaámugalulila aáti, “Íiwe munywáani, ozile éecho weeza kukola.” Mbwéenu abaantu abo baamwiililaho, baámuta omuli itaanu Yeézu no kumuboha. ");
INSERT INTO zin_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Niho oómo omuli abaabeele bali hamo na Yeézu, asopoololamo bwaangu olubáadi lwoómwe, alumutéeza omuhálila wo omugabe omukúlu no okutwi kwoómwe kuba kwaachweebwáho. ");
INSERT INTO zin_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Náho Yeézu yaámugaambila aáti, “Subya olubáadi lwaawe omu chiláalo chaálwo, habwo kuba abaantu bóona áabo abakwaáta olubáadi, nábo balyaáyitisibwa olubáadi! ");
INSERT INTO zin_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ngási, tokusoombookelwa nka nikwo niinhicha kusaba ahali Táata, náwe yaakaáhicha kuunsiíndikila óobu nyini bamaléeka boómwe béenzi be ensuli ikúmi ne ibili? ");
INSERT INTO zin_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mala sii, kábyaakubeele nkozile iíntyo, mbwéenu bita byaakaáhikize kubaho éebyo ebyaandikilwe omu Maandiko Matakatíifu nka nikwo, ni lwaampaka bityo nka nikwo Múungu yaáyeenzilého?” ");
INSERT INTO zin_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Niho Yeézu yaábagaambila abaantu be embága ezo aáti, “Óobu sii, ha kwiiza kuunkwáata kunu mukwaasile embáadi ne engoligo, ngási, nimuleeba nka nikwo íinye ndi omunyagiilizi? Kinaabeele ebilo byóona ntakwóosa niimbeekala ahagáti niinyegesa omu lubúga lwe éenzu ya Múungu, náho timulaleengesize kuunkwáata! ");
INSERT INTO zin_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Náho aga góona geéza, kuba bihikiilizwe éebyo ababáasi baáyaandikile omu Maandiko Amatakatíifu.” Niho, abaheémba boómwe bóona beéluka, baámusigaho Yeézu áaho. ");
INSERT INTO zin_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mbwéenu, abaantu abo bamukwáata Yeézu, baázeenda náze, baámutwáala ahali Kayafa, omugabe omukúlu. Omúka yoómwe, bakakobáho abeégesa be ebilagilo bya Musa na abanyaampala ba Abayahudi. ");
INSERT INTO zin_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peétero akaba naamukulaatila Yeézu kuluga hala, kuhika aha lubuga lwo omugabe mukúlu. Niho yaataahamo, yeékala hamo na abaleebelezi abone kuleeba óokwo chilaába. ");
INSERT INTO zin_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Abakúlu ba abagabe ni Itégekelo likúlu lyóona lya Abayahudi, bakaba nibaloónda cho kumuteéleleza ebisuba babone kumuchwaáziika no kumwíita Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bakéeza baalubona be ebisuba béenzi, náho tibalabonesize obubona bwoóna bwóona óobwo obulikubagasa. Haálemwa heezwaho baalubona bábili, ");
INSERT INTO zin_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","baágaamba báti, “Omuuntu ogu akagaamba nka nikwo, ‘Niinhicha kuzikaambula éenzu ya Múungu no kuzoómbeka káandi aha bilo bísatu.’ ” ");
INSERT INTO zin_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Niho omugabe mukúlu yaáyemeelela, yaámubúuza Yeézu aáti, “Ngási, tozila cho kusubya no óobu echigaambo choóna chóona habwa áago gi balikukulegelela?” ");
INSERT INTO zin_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Náho Yeézu ayesiza du. Mbwéenu, omugabe omukúlu ogwo yaámugaambila káandi aáti, “Niinkulahiza omulahi hali Múungu óogwo ali omulame, otusoomboolele koólaaba íiwe níiwe Masihi, Mutábani wa Múungu.” ");
INSERT INTO zin_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeézu yaámugalulila aáti, “Níiwe waágaamba. Náho niimbagaambila mwéena nka nikwo, kuluga óobu mulyaábona íinye Mutábani wo Omuuntu nnyikeele olubazu lwo obúlyo lwa Múungu owo obuzizi, naayiza omu bwíile bwo olugulu.” ");
INSERT INTO zin_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mala, ahonyini omugabe omukúlu káyaahuliile amagaambo ago, yaáteemula ebizwáalo byoómwe, yaágaamba aáti, “Aa! Yaálogota Múungu! Ni buulubona chi káandi óobwo tuchaáyeenda? Mwaáchihulila íimwe nyini nka nikwo óokwo yaálogota Múungu! ");
INSERT INTO zin_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bityo íimwe nimugaámba muta?” Baámusubiza báti, “Chimugasize kwiitwa!” ");
INSERT INTO zin_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nikwo, baábaanza kumuchwéela amachwaánta Yeézu omu buso, baámutéela enfune. Abáandi baámutéela eémpi, ");
INSERT INTO zin_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","no kumugaambila báti, “Íiwe Masihi, gaámba obubáasi, noóha óogwo ayaákuteela?” ");
INSERT INTO zin_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mbwéenu, ha buchilo obwo nyini, Peétero akaba ayikéele ha lubuga lwe eéka. Niho omuzaánakazi oómo yaamwiililáho Peétero, yaámugaambila aáti, “Neewe nyini okaba oli hamo na Yeézu omunya Galiláaya.” ");
INSERT INTO zin_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Áaho, Peétero yaámwáanga omu méeso ga abaantu bóona, yaámuzila aáti, “Tiínkugamanya áago go olikugaamba!” ");
INSERT INTO zin_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Niho yaalugáho aho yaáza ahi iléembo. Omuzaánakazi oóndi yaámubona, yaábagaambila abaantu áabo bakaba baliho aho aáti, “Omuuntu ogu akaba ali hamo na Yeézu Omunyanazaréeti.” ");
INSERT INTO zin_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peétero yaámwáanga káandi aha mulahi, omu kugaamba aáti, “Tiínkumumanya ogwo muuntu!” ");
INSERT INTO zin_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Áaho omwáanya muche gukahiíngula, abaantu abaabeele beemeeliile aho, baámwiililílaho Peétero, baámugaambila báti, “Byaakáaba, mazima íiwe neewe oli oómo omu baantu áabo abali hamo na Yeézu. No óobu engaambo yaawe neekwooleka butúnu nka nikwo noolugiílila Galiláaya!” ");
INSERT INTO zin_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peétero yaábaanza kweécheena bwooli, alahila, omu kugaamba aáti, “Tiínkumumanya ogwo muuntu!” Ahonyini, enkoókolomi ekoókoloma. ");
INSERT INTO zin_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Niho Peétero kwiizuka amagaambo áago Yeézu akaba amugaambiile aáti, “Obuchilo enkoókolomi etakakoókolomile, noóba waányogile entúlo isatu.” Niho, yaásohola ahéelu, yaaba naachula aha ntíimba bwooli. ");
INSERT INTO zin_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Obuchilo kábwaachíile, abakúlu ba abagabe bóona hamo na abanyaampala ba Abayahudi baáteékatéeka no kulamula akazeendele okwo balaákola babone kumusikiza Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Niho baámuboha, baázeenda náze baámuhicha aha mutégeki we Echirúumi óogwo akaba naayétwa Pilato. ");
INSERT INTO zin_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mbwéenu Yuda, óogwo enkoonga koongi wa Yeézu, obuchilo akabona nka nikwo Yeézu yaáchwaaziikilwa kwíitwa, yeehulila kubi bwooli. Yeemucha eféeza ezo makúmi asatu no kuzisubya aha bakúlu ba abagabe na abanyaampala ba Abayahudi. ");
INSERT INTO zin_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yaábagaambila aáti, “Naáhena kumuhikiiliza omu ngalo záanyu ogu muuntu atéena ntaambala mubóne kumusikiza.” Náho boónyini baágaamba, “Áago ti géetu íichwe káandi, no olwaágalalo lwaawe íiwe nyini.” ");
INSERT INTO zin_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Niho Yuda yaáziinaga eféeza ezo omu nzu ya Múungu, yaalugáho, yaázeenda kweéhotola. ");
INSERT INTO zin_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Abakúlu ba abagabe baázikobya eféeza ezo, baágaamba báti, “No muzilo kutulaaniza eféeza ezo ne eféeza ze éenzu ya Múungu, habwo kuba ne zo obuguzi bwe enságama.” ");
INSERT INTO zin_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mbwéenu, baáteékatéeka no kulamula kwiimucha eféeza ezo no kugula ensaambo yi ibúumba habwo kuziika omwo abazenyi. ");
INSERT INTO zin_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Habwe ensoonga ezo, ensaambo ezo neeyeétwa Ensaambo ye Enságama kuhicha leélo. ");
INSERT INTO zin_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bityo echigaambo chaáhikile éecho omubáasi Yeremia akagaamba aáti, “Bakeemucha ebinogoka bye eféeza makúmi asatu, obukaani óobwo bakekililizana Abaiziraeli habwa weényini. ");
INSERT INTO zin_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bagula ensaambo yi ibúumba, nko óokwo Omukáma Múungu yaándagile.” ");
INSERT INTO zin_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Náwe Yeézu yaáyemeelela omu méeso go omutégeki we Echirúumi. Omutégeki ogwo yaámubúuza aáti, “Ngási, íiwe níiwe omukáma wa Abayahudi?” Yeézu yaámugalulila aáti, “Níiwe óogwo olikugaamba.” ");
INSERT INTO zin_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mbwéenu, abakúlu ba abagabe na abanyaampala ba Abayahudi baábaanza kumulégelela Yeézu, náho weényini talabagaluliile choóna chóona. ");
INSERT INTO zin_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Niho Pilato yaámubúuza aáti, “Ngási, tokuhulila áago góona balikukulegelela?” ");
INSERT INTO zin_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Náho Yeézu talagalwiile no óobu aha chilegelelo chimo. Pilato yaásobelwa bwooli. ");
INSERT INTO zin_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Buli mwáaka omu mazenyi ga Paásika, omutégeki we Echirúumi akaba ayina obuteéka bwo kukomoolola embóhe eémo éezo abaantu bakaba nibeénda. ");
INSERT INTO zin_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mbwéenu, habwo obuchilo óobwo, ekaba eliho embóhe eémo óogwo akaba naayétwa Baraba. Embóhe ezo ekamanyiika bwooli habwe ebiheno éebyo akaba naakola. ");
INSERT INTO zin_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ha bwéecho, obuchilo abaantu bakobile áaho, Pilato yaábabúuza aáti, “Noóha óogwo mulikweenda mbakomoololele aha mbóhe ezi ibili? Nimweénda mbakomoololele Baraba, nali Yeézu óogwo abaantu nibamweéta Masihi?” ");
INSERT INTO zin_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato akababúuza aátyo, habwo kuba akamanya nka nikwo abakúlu ba Abayahudi bakéeza na Yeézu baámuheéleza omu ngalo zoómwe habwi ichubi kwoónka. ");
INSERT INTO zin_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mbwéenu, obuchilo Pilato akaba ayikéele aha chitébe echo cho kuchwaáziikila, omukázi woómwe yaámusiíndikila empola aáti, “Otaákwiiza kumukolela chibi choóna chóona omuuntu ogu omugololoke, habwo kuba naáyagalala bwooli omu chilo omu kulóota habwa weényini.” ");
INSERT INTO zin_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Náho abakúlu ba abagabe na abanyaampala abáandi ba Abayahudi baábakooba kooba abaantu nka nikwo bamusabe Pilato abakomoololele Baraba no kumuchwaáziika Yeézu abone kwiitwa. ");
INSERT INTO zin_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato yaábabúuza káandi abaantu, aáti, “Noóha óogwo nimweénda mmukomoolole aha mbóhe ezi ibili?” Bamugalulila báti, “Nitweénda otuchiíngulile Baraba!” ");
INSERT INTO zin_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato yaábabúuza aáti, “Mbwéenu mmukole iínta Yeézu óogwo abaantu balikumwéeta Masihi?” Abaantu bóona batéela eyoombo nibagaámba báti, “Mubaámbe aha musalaba!” ");
INSERT INTO zin_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato yaábabúuza aáti, “Yaákola chiheno chi nka nikwo abaámbwe aha musalaba?” Náho boónyini baáyoongela kuhooyooka báti, “Abaámbwe! Abaámbwe aha musalaba!” ");
INSERT INTO zin_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Obuchilo Pilato yaasoombookiilwe nka nikwo tiyaákuhicha kuhiindula ebiteékuzo bya abaantu abo na nka nikwo baábaanza omusaambo, yeemucha améenzi no kunaaba engalo zoómwe bóona nibabona omu méeso gáabo. Niho, yaábagaambila aáti, “Íinye tiinyina ntaambala yoóna yóona aha lufu lwo omuuntu ogu owe ntúungwa nzima. Amagaambo aga galáaba agáanyu íimwe nyini!” ");
INSERT INTO zin_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Abaantu bóona bamugalulila báti, “Ensagamáye ne ekabe hali íichwe na aha baana béetu!” ");
INSERT INTO zin_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Niho Pilato yaábakomoololela Baraba, na abalwaanila ngoma boómwe kábaabeele baámazile kumutéela enkoba Yeézu, yaámubaha babone kumubáamba aha musalaba. ");
INSERT INTO zin_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Niho abalwaanila ngoma bo omutégeki we Echirúumi baámutwáala Yeézu, baázeenda náwe omu chikaali cho omutégeki. Babakobya omwo abalwaanila ngoma abáandi bóona, baámuzoongoloka Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bamuzuúla Yeézu emyéenda yoómwe, baámuzwéeka enkaanzu elikutukula. ");
INSERT INTO zin_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Baáyogosa omukáko gwa amáhwa, baámuzwéeka omu mútwe no kuluta olusekeyáanda aha ngalo yoómwe yo búlyo abone kubonwa nko omukáma. Batéela ebizwi omu méeso goómwe, niho baaba nibamulogota ahi igayo nibagaámba báti, “Kasíinge, omukáma wa Abayahudi!” ");
INSERT INTO zin_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Niho baámuchweela amachwaánta, baátwáala olusekeyáanda óolwo omu ngalo zoómwe no kumutéeza teeza nálwo omu mútwe. ");
INSERT INTO zin_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Obuchilo abalwaanila ngoma abo baámazile kumulogota bátyo, baámuzúula enkaanzu ezo no kumuzwéeka emyéenda yoómwe káandi. Niho, baázeenda kumubáamba aha musalaba. ");
INSERT INTO zin_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Obuchilo abalwaanila ngoma hamo na Yeézu bakaba nibaluga omu chikaali cha Yeruzaléemu, baábugana no omuuntu oómo óogwo akaba naayétwa Simoni ali omunya Kurene. Niho baámuhatika kusutula omusalaba gwa Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Niho, baáhika ahaantu áaho ahalikwéetwa Goligoota. Izíina éeli liina ensoonga nka nikwo, “Oluhaanga lwo Omútwe.” ");
INSERT INTO zin_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Niho, baámuha Yeézu evíini éezo bakaba batulaniíze ne echiintu chi ituumbyo. Náho obuchilo yaáziboongize, yaáyaanga kuzinywa. ");
INSERT INTO zin_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bamubaámba Yeézu aha musalaba, baábagana ebizwáalo byoómwe aha kubyeéseza olweeso lwi ibaando. Niho echigaambo chikahikilizwa echaagaambilwe no omubáasi, “Bakabagana omuli boónyini ebizwáalo byaanze na aha chizwáalo chaanze bakeesa olweeso.” ");
INSERT INTO zin_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Beékala aho bamweemanye. ");
INSERT INTO zin_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aha lugulu yo omútwe gwoómwe, baatáho echibaáho echiina entaambala yoómwe. Hakaandikwa háti, “ogu ni yeézu, omukáma wa abayahudi.” ");
INSERT INTO zin_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ahaantu áaho, bakaba baliho abaantu bábili abaabeele bali abanyagiilizi. Niho abalwaanila ngoma baábaamba aha misalaba héehi na Yeézu, oómo olubazu lwo obúlyo no oóndi olubazu lwo obumoso. ");
INSERT INTO zin_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Abaantu abaabeele nibalaba aho, bakaba nibamulogota Yeézu, kunu nibazugumisa emitwe yáabo no kugaamba nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Íiwe okagaamba nka nikwo noohicha kuzikaambula éenzu ya Múungu no kuzoómbeka káandi aha bilo bísatu, óobu mbwéenu oyechuungule weénka! Mbwéenu, kábilaaba íiwe níiwe Mutábani wa Múungu, otuúke aha musalaba!” ");
INSERT INTO zin_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bityo nyini, abakúlu ba abagabe na abeégesa be ebilagilo bya Musa hamo na abanyaampala ba Abayahudi baámulogota Yeézu ha kweégaambila báti, “Akaba naachuungúla abáandi, náho tiyaákuhicha kweéchuungula weényini! ");
INSERT INTO zin_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kábilaaba mazima ali Omukáma wa Abaiziraeli, mbwéenu atuúke aha musalaba, niho neechwe tulaamwiíkiliza. ");
INSERT INTO zin_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Weényini naamweetégeza Múungu, na naagaámba nka nikwo, ‘Íinye ndi Mutábani wa Múungu.’ Mbwéenu, Múungu amuchuúngule óobu keélaaba mazima nikwo alikweendaho.” ");
INSERT INTO zin_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Abanyagiilizi áabo bakabaambwa aha misalaba hamo na Yeézu, nábo baámuzuma Yeézu nko óokwo abáandi bakaba nibamuzuma. ");
INSERT INTO zin_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mbwéenu, kubaandiza esáaha mukáaga nyemisana, ensiimbaazi yaátaaha omu nsi yóona kuhika esáaha mweenda. ");
INSERT INTO zin_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Obuchilo bwe esáaha mweenda buti, Yeézu yaáyaambaza ahi iláka liháango aáti, “Eloi, Eloi! Láma sabakithani?” Ensoonga ya amagaambo áago ne eéti, “Múungu waanze, Múungu waanze! Ha bwaáchi waánnagilana?” ");
INSERT INTO zin_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Abaantu bunaanka áabo bakaba beémeeliile aho, obuchilo bahuliile Yeézu naagaámba ago, baágaamba báti, “Ogu naamweéta Eliya.” ");
INSERT INTO zin_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ahonyini, oómo wáabo yeéluka bwaangu, yeemucha ikoobyo, yaáliizuza evíini esaankameele, yaálíta ikoobyo éelyo aha lusekeyáanda, yeeza yaáheéleleza Yeézu abone kunywa. ");
INSERT INTO zin_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Náho abaantu abáandi baágaamba báti, “Leka! Tulole kábilaaba omubáasi Eliya kaáleéza kumuchiza!” ");
INSERT INTO zin_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aho, Yeézu yaáyaambaza káandi ahi iláka liháango, mála omwooyo gwaahwámo. ");
INSERT INTO zin_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ahonyini, ichiíngilizo éelyo likaba lili omu nzu ahatakatíifu he éenzu ya Múungu lyaabalaalukámo enkási ibili kuluga olugulu kuhika ahaansi. Káandi haazila ni iteengeto liháango éelyo elyaaleteliile enchili kwaátika. ");
INSERT INTO zin_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Eémbi zaálaangaala, na abatakatíifu beenzi abáfwiile baázoolwa. ");
INSERT INTO zin_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yeézu káyaazoókile, baásohola kuluga omwo omu mbi, baátaaha omu chikaali chitakatíifu cha Yeruzaléemu, baábonwa na abaantu béenzi. ");
INSERT INTO zin_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Obuchilo omwiímeelelezi wa abalwaanila ngoma hamo na abaabeele nibamweemanya Yeézu kábaabweene iteengeto lye éensi ne ebíindi byóona éebyo ebyáagwa, baátíina bwooli, baágaamba báti, “Amazima, omuuntu ogu akaba ali Mutábani wa Múungu!” ");
INSERT INTO zin_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aho bakaba baliho na abakázi béenzi abaabeele balugile omuli Galiláaya bamukulaatiíle Yeézu kunu nibamuheeleza. Beemeelela hala kunu nibaléeba góona áago gakaba nigakolwa. ");
INSERT INTO zin_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Omu bakázi abo, bakaba balimo Mariamu omunya Magidala, Mariamu nyina wa Yakobo na Yozéfu, na muka Zebedayo ali nyina wa abatábani boómwe. ");
INSERT INTO zin_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Obuchilo habeele olweébazo, yéeza omuheémba oómo wa Yeézu óogwo akaba naayétwa Yozéfu. Yozéfu óogwo akaba ali omuhíte kuluga omuli Arimatea. ");
INSERT INTO zin_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yozéfu yaázeenda ahali Pilato, yaámusaba omutúumbi gwa Yeézu. Niho, Pilato yaálagila abalwaanila ngoma boómwe nka nikwo bazeénde bamuhe omutúumbi ogwo. ");
INSERT INTO zin_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yozéfu yaázeenda nábo, yaátwáala omutúumbi gwa Yeézu, yaáguzíinga omu isáanda. ");
INSERT INTO zin_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yaaguta omutúumbi ogwo omu mbi yoómwe ye enyaanga éezo ekaba etakaziikagwamo omutúumbi gwo omuuntu weéna wéena, enyaanga éezo ekaba esumilwe aha luchili. Niho yaahiliingisizáho ibáale liháango lyaásweeka omulyaango gwe eémbi, yaalugáho. ");
INSERT INTO zin_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ha buchilo obwo, Mariamu omunya Magidala na Mariamu ogwo oóndi, bakaba beékeele aho boolekiíle eémbi. ");
INSERT INTO zin_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Echilo cha kábili, éecho cho kuheleelukila Echilo cho kweéloonza habwe Endaálikizo, abakúlu ba abagabe na Abafarisayo baákoba hali Pilato. ");
INSERT INTO zin_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Baámugaambila Pilato báti, “Íiwe omukáma, nitwiizuka nka nikwo obuchilo omubéehi ogwo akaba achili omulame, akagaamba nka nikwo, ‘Aha chilo cha kásatu, ndaázooka kuluga omu bafwiile.’ ");
INSERT INTO zin_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ha bwéecho, nitusaba obalagile abalwaanila ngoma baawe baliínde eémbi kuhicha echilo cha kásatu. Kábilaaba otatiílého obuleebelezi, abaheémba boómwe baakaáhicha kwiiza kwíiba omutúumbi gwoómwe no kugaambila abaantu nka nikwo yaázoolwa kuluga omu bafwiile. Kábilaaba baákola bátyo, ebisuba byáabo ebya amaheleeluka nibiba bíbi bwooli kusaaga ebisuba ebya mbele.” ");
INSERT INTO zin_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato yaábagalulila aáti, “Mwiinábo abalwaanila ngoma, mwiilóoko aha mbi mubóne kuziliinda habwa amagala géenyu góona.” ");
INSERT INTO zin_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Niho baázeenda aha mbi, baatáho eméenko yo olumanyiso ahi ibáale éelyo, kuba babone okusoombookelwa kábilaaba omuuntu yaálihiliingisa. Niho, baábasíga abalwaanila ngoma aho babone kuliinda eémbi. ");
INSERT INTO zin_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ne echilo che Endaálikizo kichahiíngwiile, omulucheelelélwa echilo cha aha bwooyo, Mariamu omunya Magidala hamo na Mariamu ogwo oóndi, baázeenda kuleeba omu mbi. ");
INSERT INTO zin_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ahonyini, chaaba echiteengeto chiháango che éensi, habwo kuba maléeka wo Omukáma Múungu akahanaantuka kuluga omu igulu, yeélilila aha mbi, yaálihiliingisiza ibáale elyo ha lubazu, yaáliikalila aha lugulu yaályo. ");
INSERT INTO zin_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Akaba naayeengelela nko olulábyo lwe enkuba, ne emyéenda yoómwe ekaba neeyéla pee! ");
INSERT INTO zin_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Obuchilo abalwaanila ngoma abo baabweene ago, baámutíina bwooli ogwo maléeka baázuguma, báagwa baaba nka abáfwiile. ");
INSERT INTO zin_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aho, maléeka ogwo yaábagaambila abakázi abo aáti, “Mutatiina! Niinsoomboókelwa nka nikwo mwéeza kumuloondela Yeézu óogwo ayaabáambilwe aha musalaba. ");
INSERT INTO zin_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Taliho aha! Yaázoolwa, nko óokwo yaágaambile. Mwiíze mulole áaho bakaba bamulyaámikile. ");
INSERT INTO zin_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Óobu, muzeénde bwaangu, mubagaambile abaheémba boómwe nka nikwo, ‘Yaázoolwa kuluga omu bafwiile, naabeebeembelela kuhika omuli Galiláaya. Okwo niho áaho mulaamusaánga!’ Óobu, naágaamba éecho neeza kubasoomboolela!” ");
INSERT INTO zin_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Niho abakázi abo baalugáho bwaangu kuluga aha mbi aho nibeeganya no okuba na manulilwa maháango. Beéluka kuzeenda kubasoomboolela abaheémba ba Yeézu áago maléeka akabagaambila. ");
INSERT INTO zin_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Léeba, Yeézu yaábugana nábo yaábaangalucha, “Niimbasuula!” Abakázi abo, bamwiililaho, baáhika nibamugwa omu magulu, baaba nibagakwaáta, nibamulámya. ");
INSERT INTO zin_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Niho Yeézu yaábagaambila aáti, “Mutatiina. Muzeénde mubagaambile abeekiliza bazeenzi baanze bazeénde okwo Galiláaya, okwo niho baansaánge.” ");
INSERT INTO zin_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mbwéenu, obuchilo abakázi abo kábaabeele nibazeénda omu muháanda, omuli abo abalwaanila ngoma abaabeele nibaliínda eémbi ya Yeézu baalugáho aho no kuzeenda omu chikaali cha Yeruzaléemu. Obuchilo kábaahikile, baáfumoolela abakúlu ba abagabe góona áago agáagwa. ");
INSERT INTO zin_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Niho abakúlu ba abagabe abo beékobya hamo na abanyaampala ba Abayahudi, baábiteélana no kulamula óokwo balaákola. Niho baábaheela abalwaanila ngoma abo empilya nyíinzi. ");
INSERT INTO zin_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Baábagaambila báti, “Kábilaaba omuuntu weéna wéena naababuúza habwa ago agáagwa, mugaámbe nka nikwo, ‘Itúumbi obuchilo íichwe tukaba tuli omu túlo, abaheémba ba Yeézu bakéeza baáyiba omutúumbi gwoómwe.’ ");
INSERT INTO zin_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Buzima, noobwo Pilato alaáhulila ago magaambo, íichwe nituhooya náze mutaákwiiza mukaza omu lwaágalalo.” ");
INSERT INTO zin_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Niho abalwaanila ngoma baáyanaankula empilya na baázeendelela omu mutégeko nko óokwo baayegesizwe na abanyaampala ba Abayahudi. Amagaambo gáabo ge ebisuba gaásaambaala bwooli omu Bayahudi, na gaagumaho kuhicha leélo. ");
INSERT INTO zin_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Abaheémba ba Yeézu ikúmi no oómo baázeenda Galiláaya omu ibaanga elyo Yeézu yaábalagiile. ");
INSERT INTO zin_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Okwo baamusaangayo. Obuchilo kábamubwéene, baámulamya, náho omuli boónyini abáandi baaba no okugomwa gomwa nka nikwo ni Yeézu. ");
INSERT INTO zin_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mbwéenu Yeézu akabeélilila, yaábagaambila aáti, “Múungu ampeele obuzizi bwóona bwo omu igulu no bwo omu nsi. ");
INSERT INTO zin_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ha bwéecho mbwéenu, nimuzeénde omu baantu ba amahaánga góona no kuboólekeelela babe abaheémba baanze. Muzile mútyo aha kubabatiza omu izíina lya Táata, ne lyo Omutábani ne lyo Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nimubeégese kweékomya byóona éebyo naábalagiile íimwe nyini. Mwiizuke, íinye niímba mbaliho neemwe ebilo byóona, kuhicha omuhélo gwe enchilo.”");
INSERT INTO zin_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ezi niyo entabuko ye Empola Nzima ya Yeézu Kristu, Mutábani wa Múungu. ");
INSERT INTO zin_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ni nko óokwo eyaandikilwe habwa weényini omu chitabu cho omubáasi Isaya aáti, “Huliiliza, niinsiindika entumwa yaanze omu méeso gaawe, óogwo alaakweébeembelela omu kukugololela omuháanda. ");
INSERT INTO zin_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Iláka liháango lyo omuuntu ali omu nsi yo obwoóma naayolekeelela omu kwaambaza, ‘Muguloonze omuháanda gwo Omukáma, mugolole obulabo óobwo alaahiíngula!’” ");
INSERT INTO zin_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Entumwa ogwo akaba naayétwa Yohana Omubatiza. Akaba ali omu nsi yo obwoóma naayolekeelela, akaba naayolekeelela abaantu aáti, “Mazima mutamwe ebiheno byáanyu, mubatizwe, Múungu abone kubaganyila!” ");
INSERT INTO zin_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Abaantu béenzi kuluga omu chikaali cha Yeruzaléemu no omu byaalo byóona bya Yudea bakaba nibamwiízaho Yohana. Abaantu abo baaba nibegaámba ebiheno byáabo, náwe yaaba naababatiza omu munóna gwa Yorodáani. ");
INSERT INTO zin_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana akaba azweele ebizwáalo bya amooya ge entwaangabuleende, no omusipi gwe enkoba gumunywa éenda yoómwe. Ebyookulya byoómwe bikaba bili empalala na amóochi moochi go omu nsi yo obwoóma. ");
INSERT INTO zin_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohana akaba naayolekeelela naagaámba aáti, “Ti mwáanya mula naayiza omuuntu oóndi ogwo alikuunchíla ha buhicha. Íinye mazima tiinkwiílwe no nóobu kumuheéleza nko omuzáana no nóobu kwíinama no kumusumuululila enkóba za amakuúbaasi goómwe. ");
INSERT INTO zin_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Íinye niimbabatiza aha améenzi, náho weényini alaábabatiza aha Mwooyo Mutakatíifu.” ");
INSERT INTO zin_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Obuchilo obwo, Yeézu yéeza kuluga Nazaréeti, omuli Galiláaya. Náwe Yohana yaámubatiza omu munóna gwa Yorodáani. ");
INSERT INTO zin_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yeézu nóobu akaba naasabuka omu méenzi, ahonyini abona igulu nilibalaaluka, no Omwooyo Mutakatíifu nigumuhanaántukila nke echiiba no kutuúngama hali weényini. ");
INSERT INTO zin_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iláka kuluga omu igulu lyaágaamba líti, “Íiwe níiwe Mutábani waanze engaanzi, óogwo nnyesiimaho neewe bwooli!” ");
INSERT INTO zin_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ahonyini Omwooyo Mutakatíifu yaámutwáala Yeézu kuzeenda omu nsi yo obwoóma. ");
INSERT INTO zin_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yaálama áaho ebilo makúmi aána, naaleengesibwa ni Isitáani. Akaba ali okwo omu nsi yo obwoóma hamo ne enyameéswa, nábo bamaléeka kuluga ahali Múungu bakaba nibamuheeleza. ");
INSERT INTO zin_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ebilo bunaanka bihiingula, Yohana aba yaábohwa omu ibóhelo. Obuchilo akaba ali omu ibóhelo, Yeézu yaázeenda omu nsi ya Galiláaya, akaba naayolekeelela Empola Nzima za Múungu. ");
INSERT INTO zin_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Obuchilo naayolekeelela, akaba naagaámba aáti, “Obuchilo óobwo obukagaambwa, bwaáhikile. Káandi, obukáma bwa Múungu bweéliliize. Mbwéenu mutamwe no kulekelela ebiheno byáanyu, no kwiikiliza Empola Nzima.” ");
INSERT INTO zin_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Echilo chimo, óobu Yeézu yaabeele naahiingula aha ngeégeelo ye enyaanza ya Galiláaya, yaábona Simoni hamo na Andrea mweene wáabo Simoni, bakaba nibatéga eénfwi bwe emitégo, habwo kuba bakaba bali abategi. ");
INSERT INTO zin_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yaábagaambila aáti, “Mwiíze, muunkulaatile! Íinye niimbahiindula kuba abategi ba abaantu.” ");
INSERT INTO zin_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ahonyini, baáleka emitégo yáabo, baámukulaatíla Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Obuchilo yaabele yeelilaho akazeendo kache hamo na abaheémba boómwe bábili abo, Yeézu yaábona Yakobo no omulumuna Yohana batábani ba Zebedayo, bali omu bwáato, bakaba nibasoboólola emitégo yáabo. ");
INSERT INTO zin_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ahonyini, abéeta nka nikwo bamukulaatile, baámusigaho isébo hamo na abakózi boómwe omu bwáato, bamukulaatíla Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Niho Yeézu na abaheémba boómwe abo bana baázeenda omuli Kaperinaumu. Áaho echilo che Endaálikizo chiba chaáhika, bataahamo omu isomelo, na Yeézu yaábaanza kweégesa. ");
INSERT INTO zin_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Abaantu bóona abaabeele nibahuliiliza ameégeso goómwe gaábasobeza bwooli. Akaba naayegesa nko omuuntu owo obuzizi, akaba atali nka abeégesa be ebilagilo bya Musa óokwo bakaba nibeegesa. ");
INSERT INTO zin_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Omu isomelo omwo, hakaba halimo omuuntu oómo ayaabeele akwaásilwe izimu. Yaáchula ahi iláka, ");
INSERT INTO zin_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","naagaámba aáti, “Íiwe Yeézu Omunyanazaréeti, oyina ntaambala chi íiwe neechwe ka nootuloónda? Weeza kutusiingaalicha? Niinkumanya íiwe, nkokwo íiwe níiwe Omutakatíifu ayaatooziibwe na Múungu.” ");
INSERT INTO zin_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yeézu yaálikaama izimu elyo naagaámba aáti, “Oyésize! Oluheendemo ha muuntu ogu!” ");
INSERT INTO zin_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Izimu lyaamutamo ebisiimbo bwooli ogwo muuntu, lyaátéela empámo no kumulugámo. ");
INSERT INTO zin_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Abaantu bóona baákamaala bwooli, niho beébuuza báti, “Ni chiíha éechi? Ameégeso aga ni masha, geena obuzizi! Káandi, léeba, ayina obuzizi bwo kukaama amazimu, nágo nigamukoondookela.” ");
INSERT INTO zin_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ti mwáanya mula, abaantu kuluga omu chaalo chóona cha Galiláaya baaba baáhuliza empola za Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kabaalugile omu isomelo, Yeézu, Simoni na Andrea, bali hamo na Yakobo na Yohana, baázeenda hamo omúka ya Simoni na Andrea. ");
INSERT INTO zin_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nóobu baáhikile, Yeézu yaásoomboolelwa nka nikwo nyinazaala wa Simoni ali omu nzu alyaamile aha chitabo, atiilwe omuswiiza. ");
INSERT INTO zin_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Niho Yeézu kwiililaho áaho alyaamile, yaámukwáata omukóno, yaámuhweela kwiimuka. Akáanya ako nyini ogwo nyinazaala wa Simoni aba yaáchila ogwo muswíiza, yaábaanza kubatóna ebyookulya. ");
INSERT INTO zin_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Izóoba kályaagwiilemo, obuchilo Endaálikizo yaahwéele, abaantu kuluga omu chaalo echo baamuleétela Yeézu abalwéele béenzi abali aha chihalala, na abaabeele batuungamiilwe amazimu. ");
INSERT INTO zin_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Abaantu béenzi bwooli bo omu iboma elyo beekobeza aha chisasi che éenzu ya Simoni na Andrea. ");
INSERT INTO zin_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Náwe Yeézu aba yaábachiza abaantu beenzi abaabeele beena amalwáala bunaanka bunaanka. Káandi, yaabasohozamo amazimu méenzi, náho talagakuúndiile gabone kugaamba ago amazimu, habwo kuba gakaba nigamumanya Yeézu nkokwo niwe Masihi. ");
INSERT INTO zin_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nyeéncha eémo omulutulutúlu bwooli Yeézu aba yeémuka, yaázeenda ahaantu áaho hakaba hatéena abaantu, yaábaanza kuneémbelela. ");
INSERT INTO zin_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na bazeenzíbe kábasaangile ataliho, baázeenda kumuloondela. ");
INSERT INTO zin_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Obuchilo kábaamubwéene, baámugaambila báti, “Buli muuntu naakuloónda!” ");
INSERT INTO zin_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yeézu yaábagalulila aáti, “Tuzeénde omu migoongo ezíindi eza aha butúuzi, mbone kwoólekeelelayo okwo, kuba nnyizile habwe emilimo ezo.” ");
INSERT INTO zin_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Niho yaázeenda omuli Galiláaya yóona no kwoólekeelela omu masomelo gáabo, no kubeéhamo abaantu amazimu. ");
INSERT INTO zin_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Hakaba heena omuuntu oómo ali omubéembe, yaamwiizáho Yeézu. Yaáteela ebizwi ahaansi, yaámuneémbelela aáti, “Koólaayeénda, oyine obuhicha bwo kuunyéza!” ");
INSERT INTO zin_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeézu yaámuganyila, yaáyeleeza omukóno gwoómwe aha mulwéele no kumukolaho, yaámugaambila aáti, “Niinyeénda ochile, oyele!” ");
INSERT INTO zin_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ahonyini obubéembe bwaamulugaho ogwo muuntu, náwe aba yaáyela. ");
INSERT INTO zin_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mala Yeézu yaámuhana omu kumuchaáhukila no kumwiihaho bwaangu, ");
INSERT INTO zin_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","no kumúlagila aáti, “Lola, otabigaambila muuntu weéna wéena! Choónka, ozeénde oze kweéyoleka ha mugabe. Osohoze echitáambo cho kwéezwa kwaawe nko óokwo ebilagilo bya Musa bilikulagila, obóne kwoóleka abaantu nka nikwo waáyézwa.” ");
INSERT INTO zin_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Náho, omuuntu ogwo yaalugáho aho, yaábaanza kulaanga empola zo kuchizwa kwoómwe. Habwa ago, Yeézu talahikize káandi kutaaha omu muzihwa gwoóna gwóona aha bweélu. Chaamusunika ayikale weénka ahéelu ahaantu ahali bweeseléke, no nóobu bityo abaantu bakaba nibamwiízaho kuluga enkási zóona. ");
INSERT INTO zin_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Obuchilo ebilo bíche byaáhiíngwiile, Yeézu yaázeenda káandi omuli Kaperinaumu, abaantu baáhuliza nka nikwo ali omúka. ");
INSERT INTO zin_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Abaantu béenzi baákoba omu nzu ezo, kuhicha kubulwa aho kulabila aha chisasi. Yeézu akaba naayolekeelela abaantu echigaambo cha Múungu. ");
INSERT INTO zin_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Obuchilo akaba naayolekeelela, beeza abaantu bana, bamumwiimukize aha chitwaálilizi omuuntu óogwo akaba ali enséege. ");
INSERT INTO zin_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Baásiingwa kumutaashamo omwo áaho akaba aáli Yeézu, habwe embága mpáango. Baáhanama olwéego kuza aha luswi lwe éenzu, baáfumula oluswi aha lugulu áaho Yeézu akaba ali, baátúucha echitwaálilizi aho óogwo ayaabeele ali enséege akaba alyaamile. ");
INSERT INTO zin_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Obuchilo Yeézu káyaabwéene echikolwa cha abaantu abo, yaámanya nka nikwo bakaba beena okwiikiliza. Yaámugaambila owe enséege aáti, “Íiwe mwáana waanze, waáganyiilwe ebiheno byaawe.” ");
INSERT INTO zin_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Abeégesa abáandi be ebilagilo bakaba beékeele aho. Boónyini bakaba nibateekuza omu miganya yáabo nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ha bwaáchi omuuntu ogu naagaámba aátyo? Naamulogota Múungu! Táliho omuuntu óogwo yaakuhicha kuganyila ebiheno, náho Múungu weénka!” ");
INSERT INTO zin_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ahonyini Yeézu yaámanya ebiteékuzo byáabo omu muganya gwoómwe, yaábagaambila aáti, “Ha bwaáchi nimuteekuza mútyo omu miganya yáanyu? ");
INSERT INTO zin_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ngási, ni chiíha echilikuhuhuuka bwooli, kumugaambila omuuntu óogwo ali enséege nka nikwo, ‘Waáganyiilwe ebiheno byaawe,’ nali, ‘Yemeelela, twaála echitwaálilizi chaawe, olibate’? ");
INSERT INTO zin_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aha nsoonga nu, mbooleke nka nikwo íinye Mutábani wo Omuuntu nheelwe obuzizi bwo kubaganyila abaantu ebiheno omu nsi.” Niho Yeézu yaámugaambila omuuntu óogwo akaba ali enséege aáti, ");
INSERT INTO zin_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Niinkugaambila nka nikwo, yemeelela, twaála echitwaálilizi chaawe, ozeénde omúka!” ");
INSERT INTO zin_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ahonyini omuuntu ogwo yaáyemeelela, yeemucha echitwaálilizi choómwe, yaásohola ahéelu. Abaantu abo bóona baásobelwa, baámukuza Múungu, baágaamba báti, “Tuchaáliga kubona ihano nke eli elyaakolwa leélo!” ");
INSERT INTO zin_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yeézu yaalugáho, yaázeenda káandi aha ngeégeelo ye enyaanza ya Galiláaya. Abaantu béenzi baámukulaatíla, yaábeegesa. ");
INSERT INTO zin_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Obuchilo Yeézu akaba naazeénda, omu muháanda yaábona Láawi omwaana wa Alfayo, ayikéele omu kazu koómwe kokutobesezamo oluhaambwe. Yeézu yaámugaambila aáti, “Onkuláatile.” Láawi yaáyemeelela, yaábaanza kumukulaatila. ");
INSERT INTO zin_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yeézu na abaheémba boómwe baázeenda kulya ebyookulya ha luhelo omu nzu ya Láawi. Abahaámbya na abáandi béenzi áabo baámanyikile kuba abaheni bakaba nibalya ebyookulya hamo nábo, habwo kuba béenzi be entúungwa ezi bakaba nibamukulaatíla. ");
INSERT INTO zin_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mbwéenu abeégesa be ebilagilo abaabeele bali Abafarisayo, obuchilo kábamubwéene Yeézu naálya na abahaámbya hamo na abaheni abáandi, baábabúuza abaheémba boómwe báti, “Ha bwaáchi naálya hamo na abahaámbya na abaheni abáandi?” ");
INSERT INTO zin_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Obuchilo Yeézu yaáhuliile amagaambo gáabo, yaábagaambila, “Abaantu abeene enziingo nzima, tibakugaswa omulaguzi, náho abalwéele nibo abalikugaswa! Íinye tiíndeezile kwéeta abaantu abagololoke, náho abaheni.” ");
INSERT INTO zin_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Obuchilo bunaanka, abaheémba ba Yohana Omubatiza hamo na Abafarisayo bakaba bali omu chisiibo. Niho abaantu bunaanka baázeenda hali Yeézu, baámubúuza báti, “Ha bwaáchi abaheémba ba Yohana na abaheémba ba Abafarisayo baza omu chisiibo, náho abaheémba baawe tibaza omu chisiibo?” ");
INSERT INTO zin_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeézu yaábagalulila aáti, “Ngási, abasagazi ba chisweéla nibaza omu chisiibo, bali hamo na chisweéla omu bweenga? Obuchilo bwóona óobwo bali hamo na chisweéla, tibakuhicha kuza omu chisiibo! ");
INSERT INTO zin_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Náho ebilo biliyo nibiíza niho balaáyakwa chisweéla. Obuchilo obwo, niho baliba ne echisiibo. ");
INSERT INTO zin_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Taliho omuuntu abaziilila echibatulo chisha aha mwéenda ogukokweele. Kaálaabazilila, echibatulo chisha nichiteémula omwéenda ogukokweele no kwoongela kubatuka bwooli. ");
INSERT INTO zin_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Káandi taliho omuuntu óogwo alikuchenena evíini eénsha omu nfulebe ze eémpu enkokolo. Obuchilo evíini neetuúmba neeziteémula enfulebe éezo ne evíini neeséeseka ne enfulebe nizisiisikala. Evíini eénsha neeyeendelwa kutéebwa omu nfulebe ze eémpu eénsha.” ");
INSERT INTO zin_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Echilo chimo che Endaálikizo, Yeézu akaba naalaba omu masaambo ge engano, hamo na abaheémba boómwe, mala abaheémba boómwe baábaanza kuhulula amakuumba, baálya. ");
INSERT INTO zin_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Niho Abafarisayo baámugaambila Yeézu báti, “Léeba, abaheémba baawe nibakola agali omuzilo aha chilo che Endaálikizo!” ");
INSERT INTO zin_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yeézu yaábagalulila aáti, “Ngási, timukasomaga Amaandiko Matakatíifu nka nikwo Daudi yaákozile obuchilo yaabulabuliilwe, weényini na bazeenzíbe obu baabeele beene enzala? ");
INSERT INTO zin_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Akataaha omu nzu ya Múungu, obuchilo Abiatari akaba ali omugabe mukúlu wa Múungu, yaálya emikaate yaámo éezo ekaba yaásohweezwe hali Múungu. Telakuundiilwe omu bilagilo bya Musa omuuntu kulya emikaate éezo náho abagabe ba Múungu boónka, náho Daudi akazilya, mala yaaha na bazeenzíbe áabo akaba ali hamo nábo, baba baálya ezo mikaate yaámo.” ");
INSERT INTO zin_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Niho Yeézu yaábagaambila aáti, “Abaantu tibalahaangilwe nka nikwo, babigomookele ebilagilo bye Endaálikizo, náho echilo che Endaálikizo chikateebwáho na Múungu nka nikwo, chibahwéele abaantu. ");
INSERT INTO zin_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aha nsoonga ezi, íinye Mutábani wo Omuuntu níinye Omukáma we Endaálikizo.” ");
INSERT INTO zin_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Echilo echíindi che Endaálikizo, Yeézu yaátaaha omu isomelo lya Kaperinaumu, akaba aliho omuuntu óogwo alageele omukóno. ");
INSERT INTO zin_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Abafarisayo bakaba bamuliindiliíle bwooli Yeézu, babone kaálaamuchiza omuuntu ogwo echilo che Endaálikizo. Kaálaamuchiza, babone omuháanda gwo kumulégelela. ");
INSERT INTO zin_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeézu yaámugaambila omuuntu óogwo akaba alageele omukóno, aáti, “Iíza, oyemeelele ahagáti.” ");
INSERT INTO zin_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Niho Yeézu yaábabúuza aáti, “Mbwéenu, kwiingana ne ebilagilo bya Musa, ngási ni chiintu chi echiíkililiziibwe kukolwa ha chilo che Endaálikizo, kukola ebizima nali kukola ebíbi? Echilo echo tubuchíze obulami, nali kwíita?” Boónyini beésiza che! ");
INSERT INTO zin_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yeézu yaábaleeba bóona aha chiniga, yaázuzubalilwa omu muganya gwoómwe habwo kulemeela kwe emiganya yáabo. Niho yaámugaambila omuuntu ogwo aáti, “Golola omukóno gwaawe.” Náwe yaágolola omukóno gwoómwe, ahonyini gwaáchila! ");
INSERT INTO zin_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ahonyini Abafarisayo abo baásohola ahéelu, beékobya no kuteéka téeka na abahweezi bo omukáma Herode Antipasi baábiteélana óokwo balaámwíita Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yeézu yaalugáho aho, yaázeenda aha nyaanza ya Galiláaya hamo na abaheémba boómwe. Embága mpáango ya abaantu kuluga Galiláaya na Yudea yóona emukulaatila, ");
INSERT INTO zin_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","habwo kuba bakaba bahuliile amahano áago akaba akozile. Abaantu áabo bakaba balugile obutúuzi na hala. Bakaluga omu chikaali cha Yeruzaléemu, Yudea na Idumaya, ha mulaambo gwo omunóna gwa Yorodáani na héehi ne emizihwa ya Tíilo na Sidóoni. ");
INSERT INTO zin_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yeézu yaábagaambila abaheémba boómwe baloónze obwáato, kuba abaantu kibalaamweémigisiliza abone kutaaha omu bwáato obwo. ");
INSERT INTO zin_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Abalwéele bakaba nibeemigisiliza babone kumukwáatáho, habwo kuba akaba achilize béenzi. ");
INSERT INTO zin_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na abaantu abeena amazimu obuchilo baamubwéene, gakaba nigagwa omu magulu goómwe no okuchula ahi iláka liháango gáti, “Íiwe oli Mutábani wa Múungu!” ");
INSERT INTO zin_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Náho yaágaangila ha kugachaáhukila nka nikwo, gataákuba nigalaánga empola zoómwe ha baantu abáandi. ");
INSERT INTO zin_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yeézu yaáhanama omu ibaanga. Okwo yaáyéta abaantu áabo yaáyeenzile weényini, baamwiizáho. ");
INSERT INTO zin_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yaátooza abaantu ikúmi na bábili kuba hamo náze na aábe naabasiindika kwoólekeelela. ");
INSERT INTO zin_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Káandi, akabaha amagala go kubiinga amazimu aha baantu. ");
INSERT INTO zin_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aga nigo amazíina ga abaantu ikúmi na bábili áabo yaatoólize, Simoni, óogwo Yeézu akamuluka izíina eliindi, Peétero, ");
INSERT INTO zin_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo no omulumuna Yohana, abo nibo bakaba bali abáana ba Zebedayo, áabo Yeézu akabaluka izíina lya Boanerge, ensoonga yaáho abeene enkuba, ");
INSERT INTO zin_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrea, Filipo, Baritolomayo, Matayo, Tomaso, Yakobo omwaana wa Alfayo, Tadayo, Simoni Omuzelóote, ");
INSERT INTO zin_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Iskariote, ogwo ayaamukoongile Yeézu. Niho Yeézu yaásuba omúka, yaátaaha omu nzu. ");
INSERT INTO zin_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Echipípi cha abaantu chaákoba aho káandi, kuhicha Yeézu na abaheémba boómwe bakalemwa no óobu kulya ebyookulya. ");
INSERT INTO zin_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Obuchilo badugu boómwe bahuliile empola ezo, baázeenda kumukwáata, habwo kuba bakaba nibagaámba nka nikwo ahuúgeene. ");
INSERT INTO zin_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Abeégesa be ebilagilo bya Musa kuluga omuli Yeruzaléemu, bakaba nibagaámba báti, “Ayina Beelzebuli! Ogwo mukúlu wa amazimu, niwe alikumuha obuhicha bwo kubiinga amazimu ha baantu.” ");
INSERT INTO zin_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aho Yeézu yaábéeta, yaábaanza kubasoomboolela aha migani aáti, “Isitáani lyaakaáhicha líta kweéyiháho lyoónyini? ");
INSERT INTO zin_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kábilaaba obukáma búmo nibweetaanisa bwoónyini bwoónka, obukáma obwo tibukulama. ");
INSERT INTO zin_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Káandi, kábilaaba eéka eémo keéyetaanisa yoónka, eéka ezo tékuhicha kulama no obuche bwa akáti. ");
INSERT INTO zin_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kábilaaba Isitáani nilibiínga no kulwaana na amazimu mazeenzíge, obukáma bwaályo buba bwaátaana. Tibwaakuhicha kulama no obuche bwa akáti, mazima ogwo omuhélo gwaágwo gwaáhika. ");
INSERT INTO zin_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Náho, amazima ni nka nikwo, omuuntu takuhicha kutaaha omúka ye empaambazi abone kusaakula ebiintu acháali atakamukomile. Mazima kaálaaba yaámukomile kuluunzi, aho niho yaakaáhicha kumunyagiilila ebiintu omúka yoómwe. ");
INSERT INTO zin_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Mazima butúnu niimbagaambila nka nikwo, abaantu nibaganyilwa ebiheno byáabo byóona, káandi nibaganyilwa ebilogoto byáabo byóona. ");
INSERT INTO zin_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Náho, kábilaaba omuuntu naamulogota Omwooyo Mutakatíifu, tayina kuganyilwa obucha no obuchiile. Náho naába ne entaambala ye ebiheno obucha no obuchiile.” ");
INSERT INTO zin_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeézu akabagaambila aátyo, habwo kuba boónyini bakaba nibagaámba báti, “Ayina izimu.” ");
INSERT INTO zin_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Niho nyina Yeézu na badugu boómwe baáhika, baáyemeelela ahéelu ye éenzu éezo akaba alimo. Baásiindika omuuntu oómo amwéete Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Embága mpáango ya abaantu ekaba ayikéele, emuzoongoolokile. Niho baámugaambila Yeézu báti, “Léeba, nyoko na badugu baawe bali ahéelu, nibakuloónda.” ");
INSERT INTO zin_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yeézu yaábagalulila aáti, “Máaha na badugu baanze ni baáhi?” ");
INSERT INTO zin_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yaábaleeba abaantu áabo beékeele bamuzoongolokile, yaágaamba aáti, “Léeba, aba nibo máaha na badugu baanze. ");
INSERT INTO zin_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Habwo kuba omuuntu óogwo alikukola áago Múungu ayeénda, ogwo niwe aba mulumuna waanze, munyaányeenye na niwe máaha.” ");
INSERT INTO zin_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeézu yaábaanza kweégesa káandi abaantu aha ngeégeelo ye enyaanza. Echipípi cha abaantu chaákoba. Niho yaátaaha omu bwáato, yeékala omu nyaanza kuba batamuzoónga. Echipípi cha abaantu cheekala omu ngeégeelo ye enyaanza. ");
INSERT INTO zin_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Akabeégesa ameégeso méenzi aha migani. Omu meégeso goómwe akoólekeelela aáti, ");
INSERT INTO zin_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Muhuliilíze! Akaba aliho omubíbi oómo óogwo akeemuka kuza omu musili gwoómwe kubiba embibo zoómwe. ");
INSERT INTO zin_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Obuchilo akaba naabiba, embibo ezíindi zikalagala omu muháanda, enyonyi zéeza, zaázilya. ");
INSERT INTO zin_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Embibo ezíindi zikalagala omu itaka liche aha luchili, zaamela bwaangu habwo kuba itaka likaba lili liche kwoónka. ");
INSERT INTO zin_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Náho obuchilo omusana gwaatíile, gwaáyomesa elyo itaka, embibo ziba zaáhotoka no okukaánzagala, habwo kuba emizi yaázo telabeele eyiziikile ahaansi bwooli. ");
INSERT INTO zin_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Embibo ezíindi zikalagala omu máhwa. Áaho amáhwa ago kagakuzile hamo ne emimelo, gaázimigisiliza, zaalemwa kukomeela no kusohoza omwéezo. ");
INSERT INTO zin_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Náho, embibo ezíindi zikalagala omu itaka liluunzi, zaamela, zaákula no okuzáala amagoomba. Eémo yaázáala makúmi asatu, eéndi yaázáala makúmi mukáaga, ne eéndi yaázáala igana límo!” ");
INSERT INTO zin_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Niho Yeézu yaábagaambila aáti, “Óogwo ayina amatwi, ahuliilize!” ");
INSERT INTO zin_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Obuchilo abaantu be embága baálugilého, Yeézu yaásigala na abaheémba boómwe ikúmi na bábili hamo na abaheémba abáandi. Niho baámubúuza ensoonga ye emigani yoómwe. ");
INSERT INTO zin_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yaábagalulila aáti, “Múungu abaheéle íimwe okusoombookelwa amagaambo ge entaahililo zo obukáma bwoómwe, náho boónyini nibagaambilwa aha migani kuba tibakaheelwe okusoombookelwa áago, ");
INSERT INTO zin_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","nko óokwo omubáasi Isaya akaandika, ‘Kuleeba, muláaba nimuleeba, náho timulihweeza nakáti, Kuhulila, muláaba nimuhulila, náho timulisoombookelwa nakáti. Kábyaakubeele bitali bityo, bakalekeliíle ebiheno byáabo, baganyilwe.’” ");
INSERT INTO zin_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Niho Yeézu yaábazila aáti, “Kamulaalemwa kusoombookelwa ogu omugani, elyáaba eéta aha migani eéndi? ");
INSERT INTO zin_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Omubíbi no omuuntu óogwo alikuleétela abáandi echigaambo cho obukáma bwa Múungu. ");
INSERT INTO zin_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Abaantu abáandi basusana ni itaka elili aha mpelo yo omuháanda áaho chilikubibwa echigaambo echo. Náho obuchilo bahulila kwoónka echo chigaambo, Isitáani liíza, no kwiiháho echo chigaambo éecho Múungu abibile omu miganya yáabo. ");
INSERT INTO zin_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Abaantu abáandi basusana ne embibo ezalageele aha luchili. Obuchilo bahulila echigaambo cho obukáma bwa Múungu, bachiínaankula aha manulilwa. ");
INSERT INTO zin_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Náho habwo kuba basusana no omumelo óogwo ogutéena mizi, bakwaáta echigaambo che empola ezo aha mwáanya muche kwoónka, habwo kuba okwiikiliza kwáabo tikulabeele ne emizi bwooli. Keélaaba ebyaágalalo ne ennáku bibagwéela habwe echigaambo echo, aho na aho bibakúumpisa no okuleka okwiikiliza kwáabo. ");
INSERT INTO zin_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Abáandi basusana ne embibo éezo ezalageele omu mahwa. Ogwo ni nko omubeelo gwa abo abalikuhulila echo echigaambo, ");
INSERT INTO zin_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","náho, boónyini babeéhwa ne ebitahatahiso bye éensi ezi. Bataahwamo ne etuúnku za amabonwa méenzi hamo no kuligila kuloondela ebiintu ebiluunzi ebíindi. Ebyo bimigisiliza echigaambo echo, nácho tichihicha kulábya amagoomba omu bulami bwaácho. ");
INSERT INTO zin_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na abáandi basusana ni itaka liluunzi. Aba bahulila echigaambo cha Múungu no kuchiínaankula no kuzáala amagoomba, oómo makúmi asatu, oóndi makúmi mukáaga no oóndi igana límo.” ");
INSERT INTO zin_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeézu yaábagaambila aáti, “Ngási, heena omuuntu óogwo alikwaacha olumuli no kulufuúndiikila omu chitukulu nali akaluta omu buunkululu bwe echitabo? Náho naaluteleka aha lugulu ya akakóondo kaálwo lubone kumulikila hóona. ");
INSERT INTO zin_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bityo nikwo, byóona ebili bweeseléke óobu, bilyaaleebwa aha bwéelu. Na byóona ebichigiliilwe, bilyaátéebwa aha bwéelu bimanyiike. ");
INSERT INTO zin_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Óogwo ayina amatwi, ahuliilize!” ");
INSERT INTO zin_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Niho Yeézu yaázeendelela kubasoomboolela aáti, “Muhuliilíze kuzima! Bityo nyini nka nikwo koólikweésohoza kuchihuliiliza echigaambo, oótyo nikwo Múungu náwe naakuha amasala, na naakwoongela kuchisoombookelwa bwooli. ");
INSERT INTO zin_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Manya sii, omuuntu óogwo aheelwe ebiintu akabikolesa emilimo. Náho omuuntu weéna wéena óogwo aheelwe ebiintu náho akaleka kubikolesa emilimo, mazima na áako ayebikiliíze, alyaáyakwa.” ");
INSERT INTO zin_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeézu yaábagaambila aáti, “Obukáma bwa Múungu, omususaniso gwaáho ni nke empola ezi. Omuuntu abiba embibo omu itaka. ");
INSERT INTO zin_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Omu chilo ahunila na nyemisana aba méeso, embibo ezo zimela no okusebuka, na weényini omulimi takusoombookelwa éecho echilikuzikola zítyo. ");
INSERT INTO zin_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Itaka elyo nyini nilikuza embibo ezo no kuzáala. Aha kubaanza neesohoza amababi, neebaanza kufuluma, ha muheleeluko neesohoza ikuumba éelyo liina embibo. ");
INSERT INTO zin_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Emyéezo ezo kazilikukomeela, no kwóoma, aho niho omulimi atwaála eliihiso lyo kugesa.” ");
INSERT INTO zin_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeézu yaáyoongela kubasoomboolela aáti, “Obukáma bwa Múungu tubususanise na chiíha? Tubususanise na mugani chi? ");
INSERT INTO zin_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bisusana no oluzuma lwe ehaladáali, olwo oluli luche bwooli kuchila enzuma ezíindi zóona. ");
INSERT INTO zin_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kalumela, lukula no kuba omuti muháango kusaaga emiti yóona omu musili. Guzila na amatábazi maháango ne enyonyi názo zoombeka ebyaali olugulu omu matábazi gaágwo.” ");
INSERT INTO zin_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yeézu akagaamba echigaambo cha Múungu aha migani míinzi nke ezi, aha kazeendele áako baáhikize kusoombookelwa. ");
INSERT INTO zin_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Akaba atéena kuhooya nábo atagaambile emigani. Náho, obuchilo akaba ali hamo na abaheémba boómwe bali boónka, akaba abasoomboolela byóona. ");
INSERT INTO zin_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Echilo echo olweébazo, Yeézu yaábagaambila abaheémba boómwe aáti, “Twaambuke enyaanza, tuzeénde aha mulaambo.” ");
INSERT INTO zin_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Baáleka embága ya abaantu, baáhanama omu bwáato óobwo akaba alimo Yeézu, baalugáho hamo náwe. Hakaba heena amáato agáandi áago bakazeendana nágo. ");
INSERT INTO zin_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Echiihúle chaábaanza kuteela omu nyaanza. Amakóonzo gakaba nigateéla obwáato, améenzi gabaanza kutaaha omu bwáato bwaáyeenda kwiízula. ");
INSERT INTO zin_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Obuchilo obwo, Yeézu akaba alyaamile enyuma omu bwáato, asikamiliize omútwe gwoómwe aha musago. Abaheémba boómwe baámwiimucha, baágaamba báti, “Mweégesa, tokusaaswa nka nikwo nitufwa?” ");
INSERT INTO zin_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Niho Yeézu yaáyemeelela no kugukáama ogwo muyaga, yaágaambila enyaanza aáti, “Oyésize! Chuleéla!” Ogwo muyaga gwaáhula kuteela, haaba echineembe butúnu. ");
INSERT INTO zin_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mbwéenu Yeézu yaábabúuza abaheémba boómwe aáti, “Ha bwaáchi nimutiína? Mbwéenu no óobu nyini mucháali timwiina okwiikiliza?” ");
INSERT INTO zin_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Boónyini batiina bwooli, baábaanza kweébuuza báti, “Ngási noóha ogu, nóobwo omuyaga na amakóonzo ge enyaanza nibimugomookela?” ");
INSERT INTO zin_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yeézu na abaheémba boómwe baáhika ha mulaambo gwe enyaanza ya Galiláaya, omu nsi ya Abageráasi. ");
INSERT INTO zin_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Obuchilo Yeézu kiyaatuúkile kuluga omu bwáato, ahonyini abugana no omuuntu óogwo akaba ayina izimu naalugiílila omu nyaanga zo kuziikilámo abáfwiile. ");
INSERT INTO zin_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Omuuntu ogwo akaba naatuúla omu bitúulo. Akaba ayina amagala, akaba ataliho weéna wéena óogwo ayaahikize kumuboha no óobu bwe eminyololyo. ");
INSERT INTO zin_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bakaba nibamuboha ne eminyololyo entúlo nyíinzi omu ngalo no omu magulu, náho akazinogola zóona. Akaba ataliho omuuntu owa amáani óogwo yaakuhicha kumusíinga. ");
INSERT INTO zin_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Buchiile, omu chilo na nyemisana akaba abayo omu bitúulo no omu mabaanga, naachula no kweéhalaatula na amabáale. ");
INSERT INTO zin_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Obuchilo ogwo muuntu káyaamuloliile Yeézu, aba yaámwiílukiilila, yaámugwa omu magulu. ");
INSERT INTO zin_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Mala ogwo omuuntu yaáyaambaza ahi iláka liháango aáti, “Okaatuulanwa chi neenye, ka noondoonda íiwe, Yeézu Mutábani wa Múungu Óogwo Ali Olugulu ya Byóona! Niinkulahiza ahi izíina lya Múungu nka nikwo otaanyagalaza!” ");
INSERT INTO zin_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Akasaba aátyo habwo kuba Yeézu akaba aligaambiile éelyo izimu aáti, “Luheendého hali ogu muuntu!” ");
INSERT INTO zin_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yeézu yaálibúuza aáti, “Izíina lyaawe oli oóha?” Lyaámugalulila niligaámba líti, “Izíina lyaanze ndi Ensuli, habwo kuba íichwe tuli béenzi ha muuntu ogu.” ");
INSERT INTO zin_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Izimu éelyo lyaámusaba entúlo nyíinzi nka nikwo atababiínga omu nsi éezo. ");
INSERT INTO zin_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hakaba heena obusho bwe empunu, omu iliísizo aha ngolomoko yi ibaanga. ");
INSERT INTO zin_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Niho amazimu ago gagaamba gáti, “Nitukusába túti, otukuúndile tutáahe omu mpunu ezo.” ");
INSERT INTO zin_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yeézu yaágakuúndila. Mbwéenu ago amazimu gaamulugáho ogwo muuntu, gaazitaahamo empunu. Obusho bwóona bwe empunu bwaatamo olubilo aha ngolomoko mpáango ye éelyo ibaanga, lyaátaaha omu nyaanza no kufwa. Empunu ezo zikaba nizihika ebihuumbi bibili (2,000). ");
INSERT INTO zin_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Abo balíisa be empunu baba beéluka, baázeenda nibalaánga ezo mpola omu muzihwa no omu mitúulo yo obutúuzi. Abaantu beeza, babone kweébonela boónyini ago agaákolwa. ");
INSERT INTO zin_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Obuchilo kábaahikile hali Yeézu, bamubona omuuntu óogwo akaba ayina embága ya amazimu ayikéele, azweele ebizwáalo, na ayina obwéenze bwóona, baátíina bwooli. ");
INSERT INTO zin_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bali áabo baabweene amagaambo ago baaba nibabagaambila abaantu abáandi agamugwiilemo ogwo owa amazimu hamo ne empunu. ");
INSERT INTO zin_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Niho abaantu abo baábaanza kumuneémbelela Yeézu alugeho omu chaalo cháabo. ");
INSERT INTO zin_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Obuchilo Yeézu akaba naatáaha omu bwáato, omuuntu óogwo akaba ayina amazimu yaámusaba Yeézu nka nikwo amukuúndile azeénde hamo náwe. ");
INSERT INTO zin_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Náho Yeézu talamukuúndiile, yaámugaambila aáti, “Zeénda owáanyu, omu báanyu, obalaangaanile, ni magaambo chi maháango áago Omukáma yaákukolela ne echiganyizi éecho yaákuzilila.” ");
INSERT INTO zin_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aho omuuntu ogwo yaázeenda, yaábaanza kwoólekeelela empola ya amagaambo maháango áago Yeézu yaámukolela omuli Dekapoolisi, abaantu bóona baásobelwa. ");
INSERT INTO zin_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yeézu na abaheémba boómwe baáyaambuka enyaanza káandi kusuba ha mulaambo. Obuchilo kábaahikile, embága mpáango ya abaantu yaamukobáho aha ngeégeelo ye chaambo. ");
INSERT INTO zin_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yéeza omweébeembezi wi isomelo, izíina lyoómwe Yairo. Obuchilo káyaamubwéene Yeézu, yaamuzáho, yáagwa omu magulu goómwe. ");
INSERT INTO zin_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yaámuneémbelela naagaámba aáti, “Muhala waanze no omulwéele, naayeénda kufwa. Niinsaba tuzeénde, omuteho engalo zaawe, abone kuchila no kulama.” ");
INSERT INTO zin_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yeézu yaázeenda náwe owoómwe. Embága ezo mpáango, ekaba neemukulaatíla, neemufuundiliza buli lubazu. ");
INSERT INTO zin_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Omu mbága ezo, hakaba heena omukázi óogwo akaba ayina endwáala ye emizezi aha myáaka ikúmi ne ibili. ");
INSERT INTO zin_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ogwo mukázi akaba yaáyagaleele bwooli kulibata omu bafúmu béenzi. Akaba yaásikiize ebiintu byoómwe byóona naatwaála omu bafúmu, náho endwáala yoómwe telabeele kúundi, nayo ekaguma kwoongela. ");
INSERT INTO zin_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Obuchilo omukázi ogwo káyaahuliize empola za Yeézu, yaákweengela omu mbága ya abaantu kuluga enyuma yoómwe, aba yaamukuumyaho aha lukugilo lwo omwéenda gwa Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Habwo kuba omuganya gwoómwe gukateékatéeka gúti, “Kiíndakuumyáho kwoónka ebizwáalo byoómwe, niinchila.” ");
INSERT INTO zin_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ahonyini enságama yaálekela kuzwa, yeehulila aha mubili nka nikwo yaáchila. ");
INSERT INTO zin_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bwaangu Yeézu yaámanya nka nikwo amagala goómwe gaákola omulimo. Yaábahiindukila, yaábabúuza abaantu be ezo mbága aáti, “Noóha óogwo ayaankuumyáho emyéenda yaanze?” ");
INSERT INTO zin_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abaheémba boómwe baámusubiza, “Mbwéenu nooléeba nka nikwo abaantu béenzi óokwo balikukufuúndiliza! Ha bwaáchi noobuúza, ‘Noóha óogwo ayaánkuumyáho?’ ” ");
INSERT INTO zin_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Náho yaáleeba kunu na kunu, abone kumubona óogwo ayaamukumizeho. ");
INSERT INTO zin_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Niho omukázi ogwo yaátíina bwooli no okuzuguma habwo kuba akaba yaámanyile agaámugwamo, bityo aba yéeza no kumugwa omu magulu, yaámusoomboolela amazima góona. ");
INSERT INTO zin_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeézu yaámugaambila aáti, “Íiwe muhalákazi waanze, okwiikiliza kwaawe nikwo kwaákuchiza. Ozeénde no obuhóolo, obutazila endwáala yaawe káandi.” ");
INSERT INTO zin_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Obuchilo Yeézu akaba achaáhooya, abaantu beeza kuluga omu nzu ya Yairo, omweébeembezi wi isomelo, nibagaámba báti, “Leka kumwaágalaza omweégesa, habwo kuba muhala waawe yaáfwiile.” ");
INSERT INTO zin_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Náho Yeézu talacheétiilého echigaambo cháabo, yaámugaambila Yairo aáti, “Otatiina, yikiliza kwoónka.” ");
INSERT INTO zin_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yeézu talakuunzile omuuntu weéna wéena akwaátaangane náwe. Yaázeenda na Peétero, Yakobo na Yohana ali mulumuna wa Yakobo. ");
INSERT INTO zin_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Obuchilo kábaahikile omu nzu ya Yairo, Yeézu yaásaanga abaantu nibachula no kutéela empámo. ");
INSERT INTO zin_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yaátaaha omu nzu, yaábazila aáti, “Nimuchulila chiíha? Omuhalákazi ogu tákafwíile, náho alyaamile kwoónka.” ");
INSERT INTO zin_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Abaantu abaabeele bali omwo bamuseka ahi igayo, náho Yeézu yaábasohoza bóona ahéelu. Yaátwáala iíse, nyina wo omuhalákazi na abaheémba boómwe básatu, baázeenda omu chiseenge chi balyaamikile omuhalákazi. ");
INSERT INTO zin_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yaámukwáata omuhalákazi ogwo bwe engalo, yaámugaambila aáti, “Talitha, koum!” Ensoonga yaáho, “Muhalákazi, niinkugaambila, yimuka!” ");
INSERT INTO zin_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ahonyini, omuhalákazi ogwo akaba ayina emyáaka ikúmi ne ebili, yaáyemeelela, yaábaanza kulibata. Baásobelwa bwooli. ");
INSERT INTO zin_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yeézu yaábakaama bwooli nka nikwo batabigaambila omuuntu weéna wéena ebyo ebyaákolwa. Mále yaábagaambila abazéele bo ogwo omuhalákazi bamuhe ebyookulya. ");
INSERT INTO zin_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yeézu yaalugáyo okwo, yaásuba omu mugoongo gwo owáabo, na abaheémba boómwe baámukulaatíla. ");
INSERT INTO zin_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Obuchilo echilo che Endaálikizo kichaáhikile, yaábaanza kweégesa omu isomelo. Béenzi áabo abaamuhuliile baásobelwa. Bakaba nibeebuúza báti, “Aa! Ngási ogu abonesize nkáhi aga góona? Káandi, abonesize nkáhi amasala góona nka aga, na amagala go kukola amahano nka ago? ");
INSERT INTO zin_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Óogu tíwe ogwo omusala miti, mutábani wa Mariamu, na abalumuna ni Yakobo, Yose, Yuda na Simoni? Ngási, banyáanya tibatuleéne neechwe aha?” Baásaaya habwa weényini, baáleka kumwiíkiliza. ");
INSERT INTO zin_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeézu yaábagaambila aáti, “Omubáasi akuzibwa hoóna hoóna, náho tayina ikuzo omu muzihwa gwo owáabo, tayina ikuzo hali badugu boómwe no owoómwe.” ");
INSERT INTO zin_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Bityo, Yeézu talahikize kukolayo okwo amahano méenzi, náho akateelaho emikono abalwéele bache no kubachíza. ");
INSERT INTO zin_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yaásobelwa bwooli habwo kuba abaantu abo tibalamwiíkiliize. Niho Yeézu yaázoongoloka omu migoongo yo obutúuzi kubeégesa abaantu. ");
INSERT INTO zin_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yaábéeta abaheémba boómwe ikúmi na bábili. Yaábaha amagala go kusohoza abaantu amazimu, yaábasiíndika bábili bábili. ");
INSERT INTO zin_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yaábalagila aáti, “Mutatwáala chiintu choóna chóona omu luzeendo lwéenyu náho oluhiimbo lwoónka. Mutatwaála ensáho, nali omukaate, nali empilya. ");
INSERT INTO zin_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Muzwaále enkeeto náho mutaakuzwaála ebizwáalo byo kuhiindula.” ");
INSERT INTO zin_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Káandi, yaábagaambila aáti, “Omu nzu yoóna yóona éezo balaabanyegeza, mwiikale omwo nyini, kuhika obuchilo mulaaluga ahaantu aho. ");
INSERT INTO zin_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Káandi, hoóna hóona áaho balaáleka kubanyegeza nali kubahuliiliza, mulugého, mweekuunkumule enkuungu éezo éeli ha magulu gáanyu, neéba emanyiso ye ebiheno byáabo.” ");
INSERT INTO zin_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Abaheémba abo baalugáho, baábaanza kuboólekeelela abaantu nka nikwo batamwe no kubilekelela ebiheno byáabo no kumuhiindukila Múungu. ");
INSERT INTO zin_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Babiinga amazimu méenzi, baábasiiga amazuta abalwéele béenzi, baábachiza. ");
INSERT INTO zin_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Omukáma Herode Antipasi, akahuliza empola za Yeézu, habwo kuba akaba naamanyíika hóona. Abáandi bakaba nibagaámba báti, “Ni Yohana Omubatiza yaázoolwa kuluga omu bafwiile, niyo ensoonga ayina amagala go kukola amahano maháango nka ago.” ");
INSERT INTO zin_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Abáandi bakaba nibagaámba báti, “Yeézu ni Eliya.” Abáandi bakaba nibagaámba báti, “Weényini no omubáasi wa Múungu nka ababáasi abáandi ba kala.” ");
INSERT INTO zin_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Obuchilo Herode Antipasi yaáhuliile empola ezi, yaámuzila aáti, “Ogu ni Yohana, óogwo nkanogola omútwe. Yaázooka kuluga omu bafwiile!” ");
INSERT INTO zin_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Aho aha bubaandizo Herode Antipasi weényini akaba alagiize nka nikwo Yohana akwaátwe, achiingilwe omu ibóhelo. Herode akakola aátyo habwo kuba akaba aswiile Herodia óogwo akaba ali muka mulumunáwe, alikwéetwa, Filipo. ");
INSERT INTO zin_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kuba Yohana akaba naamusoomboólela aáti, “No omuzilo omu méeso ga Múungu kuswéela omukázi wa mudugu waawe obuchilo achaali achili mwooyo.” ");
INSERT INTO zin_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mbwéenu amagaambo ago gakaleetelela Herodia kumutámwa Yohana, no kuloondela omuháanda gwo kumwíita, náho yaábulwa. Mbwéenu habwo kumunuliza Herodia, Herode Antipasi yaálagila Katiíkilo bamukwáate Yohana no kumuboha omu ibóhelo. ");
INSERT INTO zin_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Náho akaba naamweemanya, kuba Herodia ataákwiiza kumwíita, habwo kuba akamutíina Yohana no okusoombookelwa nka nikwo, Yohana no omugololoke no mutakatíifu. Herode Antipasi ayeenda kumuhuliiliza Yohana bwooli, náho obuchilo yaamuhuliliize, azululukilwa. ");
INSERT INTO zin_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ne echilo chimo Herodia akabona omuháanda muluunzi gwo kumwíita Yohana. Echilo cho kulya amazenyi go kuzaalwa kwoómwe Herode Antipasi, akabaángisa baalubago, abakúlu ba abalwaanila ngoma na abatégeki be éensi ya Galiláaya. ");
INSERT INTO zin_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Obuchilo abazenyi kabeekéele, enkuuba ali muhala wa Herodia kayaataahilemo, akanegula, Herode na abazenyi boómwe baba baánulilwa. Omukáma Herode yaámugaambila omuhala ogwo aáti, “Onsabe choóna chóona éecho olikweenda, íinye niinkuha.” ");
INSERT INTO zin_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yaálahila aáti, “Niinkuha choóna chóona éecho olikweenda, no óobu obwaata iheembe bwo obukáma bwaanze.” ");
INSERT INTO zin_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Niho ogwo muhala yaásohola ahéelu, yaámubúuza nyina aáti, “Máaha, nsábe chiíha?” Nyina yaámugalulila aáti, “Sába akuhe mútwe gwa Yohana Omubatiza.” ");
INSERT INTO zin_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Omuhala ogwo yaásuba bwaangu aha mukáma, yaámugaambila aáti, “Niinyeénda oómpe óobu nyini omútwe gwa Yohana Omubatiza aha lutemele lwe embaáhu.” ");
INSERT INTO zin_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Omukáma yaázuzubalilwa bwooli, náho habwe echilahilóche omu méeso ga abazenyi boómwe, talayeenzile kumwaángilila. ");
INSERT INTO zin_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mala Omukáma yaámusiíndika katiíkilo azeénde kumunogola Yohana omútwe. Katiíkilo yaázeenda omu ibóhelo, yaánogola omútwe gwa Yohana. ");
INSERT INTO zin_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Yaáguléeta omútwe gwa Yohana aha lutemele, yaágumuha ogwo muhala wa Herode, náwe yaágumutwaálila nyina. ");
INSERT INTO zin_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Obuchilo abaheémba ba Yohana baáhuliile ago, baázeenda, baátwáala omutúumbi gwoómwe, baáguziika omu mbi. ");
INSERT INTO zin_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Obuchilo entumwa za Yeézu zaasubile, zaákoba omu méeso ga Yeézu, baámugaambila góona áago baákozile na áago baayegesize. ");
INSERT INTO zin_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kwiingana na abaantu béenzi bwooli áabo bakaba baliho, abáandi bakaba nibeéza, abáandi bakaba nibalugaho, Yeézu na abaheémba boómwe baábulwa omwáanya gwo okulya. Yaábagaambila abaheémba boómwe aáti, “Mwiíze, tuzeénde ahaantu ahatéena baantu, tubone kuhuúmula kache.” ");
INSERT INTO zin_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Baalugáho boónyini kwo bwáato, baázeenda ahaantu áaho ahatéena abaantu. ");
INSERT INTO zin_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Náho obuchilo bakalugayo abaantu béenzi baábabona, baábamanya. Abaantu abo hamo na abáandi kuluga omu mizihwa míinzi baábelukiilila lwa amagulu, baábeebeembelela kuhika okwo áaho bakaba nibazeénda. ");
INSERT INTO zin_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Obuchilo yaásooka omu bwáato, yaábona embága mpáango ya abaantu. Yaábazilila echiganyizi, habwo kuba bakaba bali nke entaama zitéena omulíisa. Yaábaanza kubeégesa amagaambo méenzi. ");
INSERT INTO zin_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Obuchilo izóoba kalyaaheénzile omukóno, abaheémba boómwe beeza hali weényini, baámugaambila báti, “Aha tuli no omu chitúuntu, ne ensiimbaazi yeéliliza. ");
INSERT INTO zin_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Obalage abaantu aba, bazeénde omu mitúulo beégulile ebyookulya.” ");
INSERT INTO zin_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Náho Yeézu yaábagalulila aáti, “Íimwe Mubáhe ebyookulya.” Baámubúuza báti, “Nooyeénda íichwe tuzeénde kubagulila emikaate ye edináali magána abili tubone kubaha balye?” ");
INSERT INTO zin_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeézu yaábabúuza aáti, “Ngási, mwiina emikaate engáhi? Nimuzeénde muleebe.” Baázeenda kuleeba, baásuba, baámugaambila báti, “Twiine emikaate itaanu ne eénfwi ibili.” ");
INSERT INTO zin_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yeézu yaábagaambila aáti mubeekáze abaantu bóona empelo bunaanka aha bunyaansi. ");
INSERT INTO zin_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Beékala empelo, abáandi igana, abáandi makúmi ataanu ataanu. ");
INSERT INTO zin_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yeézu yaátwáala emikaate itaanu ezo ne eénfwi ibili, yaálalamila omu igulu, yaámusiima Múungu. Niho yaázimenyula emikaate, yaábaha abaheémba boómwe babone kubagabila abaantu bóona emikaate ne eénfwi. ");
INSERT INTO zin_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Abaantu bóona baálya, baáhaaga. ");
INSERT INTO zin_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Niho, abaheémba boómwe baákobya kobya amasaága ge emikaate ne eénfwi, beezuza ebitukulu ikúmi na bibili. ");
INSERT INTO zin_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Áabo bakalya emikaate aho, abaséeza bakaba bali ebihuumbi bitaanu. ");
INSERT INTO zin_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Niho Yeézu yaálagila abaheémba boómwe nka nikwo, bahanáme omu bwáato, beebeembele kuzeenda buseeli bwe enyaanza, omuli Betisaida, obuchilo weényini aláaba naazilaga embága ya abaantu. ");
INSERT INTO zin_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Káyaabeele yaámazile kulagana ne embága ya abaantu, yaáhanama omu ibaanga kusaba Múungu. ");
INSERT INTO zin_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kahabeele aha kachilo chilo, abaheembábe bakaba bali omu bwáato aha buziba, náwe Yeézu akaba achili weénka aha mulaambo. ");
INSERT INTO zin_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yaábabona óokwo bakaba nibaagalala bwooli kutéela engáhi, habwo kuba omuyaga muháango gwe eéntwe gukaba niguheémba. Mbwéenu obuchilo heéliliile omulucheelelélwa, yaabazeendáho naalibata aha méenzi, yaáyeenda kubahiínguliza. ");
INSERT INTO zin_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Náho, obuchilo bóona kábaamubwéene Yeézu naalibata aha lugulu ye enyaanza, baáteekuza lúundi ne echimunyaamunya, beékaangwa bwooli no kutéela empámo. ");
INSERT INTO zin_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ahonyini, Yeézu yaábagaambila aáti, “Mutiímbye omuganya, mutatiina! Níinye!” ");
INSERT INTO zin_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yeézu yaáhanama omu bwáato omwo, omuyaga gwaáchuleela haaba echineembe. Baásobelwa bwooli, ");
INSERT INTO zin_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","habwo kuba bakaba bachaali batakasoomboókiilwe nóobu elyo ihano lye emikaate. Emiganya yáabo ekaba elemiile. ");
INSERT INTO zin_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Obuchilo Yeézu na abaheémba boómwe baayaambukile enyaanza, baáhika omu nsi ya Genezareti. Baánaga enaanga baágoba aho aha chaambo. ");
INSERT INTO zin_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Obuchilo baatuúkile omu bwáato, ahonyini abaantu bo okwo baámusoombookelwa Yeézu, ");
INSERT INTO zin_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","beéluka nibazoongoloka omu nsi yáabo yóona. Abaantu bakaba nibamuleetela Yeézu abalwéele aha mikeeka kuzeenda hoóna hóona áaho bahuliile nka nikwo Yeézu aliho. ");
INSERT INTO zin_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Hoóna hóona áaho Yeézu akeemuka kuza, eébe omu migoongo, omu maboma nali omu mitúulo, bakaba nibamuleetela abalwéele no kubabyaámika omu magulizo. Nábo baámuleémbeleza Yeézu abakuúndile abalwéele bakoleho no óobu aha lukugilo lwe ebizwaalóbye kwoónka. Niho abalwéele bóona áabo abaabeele bákolaho, bakachila. ");
INSERT INTO zin_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ebilo ebyo, Abafarisayo bóona na abeégesa be ebilagilo bya Musa abáandi abalugile Yeruzaléemu bakoba hali Yeézu, ");
INSERT INTO zin_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","baábona omu baheémba boómwe abáandi nibalya ebyookulya ne engalo eziteezile nko óokwo elikweendelwa. ");
INSERT INTO zin_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Abafarisayo na Abayahudi abáandi tibalabeele nibalya batéena kunaaba kuhicha aha nkokola, bakaba bakulaatila obuteéka bwa beesabo enkúlu nko óokwo bukaba buli. ");
INSERT INTO zin_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Obuchilo nibaluga omu igulizo, tibalya, babaánza ha kunaaba nka nikwo elikweendelwa, niho babone kulya. Káandi, beézuka obuteéka bwáabo obúundi bwíinzi bwa kala, nko kwóoza ebikóombe, ifulila ne ebiseme byóona. ");
INSERT INTO zin_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Niho Abafarisayo na abeégesa be ebilagilo bya Musa baámubúuza Yeézu báti, “Ha bwaáchi abaheémba baawe tibakukuláatila obuteéka bwa besiichwe enkúlu? Nibalya ebyookulya batéena kunaaba engalo kwiingana okwo elikweendelwa!” ");
INSERT INTO zin_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeézu yaábagalulila aáti, “Íimwe ngóbya. Múungu akagaamba mazima ha bwéenyu kulabila omubáasi woómwe Isaya nka nikwo, ‘Abaantu aba nibaankúza aha bigaambo kwoónka, náho emiganya yáabo eli hala neenye. ");
INSERT INTO zin_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nibaanyeseénga busa, habwo kuba amagaambo áago balikweégesa ne ebilagilo bya abaantu.’” ");
INSERT INTO zin_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yeézu yaázeendelela kubasoomboolela aáti, “Íimwe nimuleka ebilagilo bya Múungu, nimukulaatila obuteéka bwa abaantu. ");
INSERT INTO zin_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Nimuzila muti mwiina obwéenze kwáanga ebilagilo byoómwe Múungu, kuba mubóne kukulaatila obuteéka bwáanyu! ");
INSERT INTO zin_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Aha nsoonga Musa akagaamba nka nikwo, ‘Obakúze iíso na nyoko.’ Káandi, yaálagila nka nikwo, ‘Weéna wéena óogwo alikuzuma iíse nali nyina, kufwa na aáfwe.’ ");
INSERT INTO zin_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Náho íimwe, omu kweégesa kwáanyu mugaámba ni kuzima kwoónka kábilaaba omuuntu naamusoomboólela iíse nali nyina nka nikwo, ‘Ebiintu byaanze éebyo naakuhikíze kukuhweela, byaábéele Korbani, ensoonga yaáho naámazile kusohoza nke echitáambo ahali Múungu.’ ");
INSERT INTO zin_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Habwo kweégesa mútyo, nimutwaalilila nka nikwo atamuzuna iíse nali nyina. ");
INSERT INTO zin_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bityo nimusuúcha echigaambo cha Múungu habwo kukulaatila obuteéka bwáanyu. Na nimukola méenzi áago galikususana na aga.” ");
INSERT INTO zin_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yeézu yaáyéta káandi embága ya abaantu, yaábagaambila aáti, “Nimuhuliilíze mweétegeeleze, musoomboókelwe amagaambo áago ndikubagaambila! ");
INSERT INTO zin_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tihaliho chiintu éecho kachilikumutaahamo omuuntu no kuleételela obulofo. Náho, áago agalikuluga omu muganya gwo omuuntu nigo galikumuleételela omuuntu obulofo.  ");
INSERT INTO zin_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Óogwo ayina amatwi go okuhulila, ahuliilize.” ");
INSERT INTO zin_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Káyaamazile kulekaana ne embága ya abaantu no kutaaha omu nzu, abaheémba boómwe baámubúuza habwo omugani ogwo. ");
INSERT INTO zin_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yaábagaambila aáti, “Ngási, neemwe muli abalogwéezi? Timukusoombookelwa nka nikwo, echiintu éecho echilikumutaahamo omuuntu, tichikuhicha kuleételela obulofo? ");
INSERT INTO zin_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ha kuba tichikumutaaha omu muganya, nichiíza omuunda kwoónka no kusohola omu mubili.” Aha kugaamba aátyo, Yeézu akakomeenteleza nka nikwo ebyookulya byóona bibe nibiliíbwa bitaba omuzilo. ");
INSERT INTO zin_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yaázeendelela kugaamba aáti, “Echimulugamo omuuntu, nicho chimuleetelela omuuntu obulofo. ");
INSERT INTO zin_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nikwo kugaamba omu muganya niho biluga ebiteékuzo bíbi, byo obusiihani, ");
INSERT INTO zin_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","olukóno, obwíisi, obusaambani, etuúnku mbi, obufu, enteba, ameelu, obuzilwa, ilyoógo, ihagi no obusilu. ");
INSERT INTO zin_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Obuzilwa bwóona óobwo buluga omu muganya gwo omuuntu nibwo buleetelela omuuntu kuba omulofo.” ");
INSERT INTO zin_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yeézu yaalugáyo okwo Galiláaya, yaázeenda omu byaalo bya Tíilo na Sidóoni. Okwo, yaátaaha omu nzu, talayeenzile omuuntu weéna wéena amanye nka nikwo aliho. Náho talahikize kweéseleka. ");
INSERT INTO zin_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Náho hakaba heena omukázi óogwo omuhala akaba ayina izimu, yaamwiizáho bwaangu, yaáteela ebizwi omu méeso goómwe. ");
INSERT INTO zin_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ogwo mukázi akaba atali Muyahudi akalugiilila Foonike omu nsi ya Siíria. Ogwo mukázi yaámusaba Yeézu alimwiihého omuhala izimu. ");
INSERT INTO zin_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yeézu yaámugaambila aáti, “Ti kuzima kutwáala ebyookulya bya abayaánda no kubinagila eémbwa. Babaánze abayaánda baháage.” ");
INSERT INTO zin_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Náho omukázi ogwo yaámugalulila Yeézu aáti, “Nikwo bili Mukáma, náho no óobu eémbwa ezili aheéfo ye emeéza nizilya ebisige bya abayaánda.” ");
INSERT INTO zin_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeézu yaámugalulila aáti, “Aho waágaamba kuzima. Mbwéenu, zeénda, izimu lyaamulugaho muhala waawe.” ");
INSERT INTO zin_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Omukázi ogwo yaásuba omúka, yaásaanga omuhala alyaamile aha chitabo, izimu lyaámulugilého. ");
INSERT INTO zin_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Niho Yeézu yaáluga omu mbíbi za Tíilo, yaálaba ahagáti ya Sidóoni, kuhika aha nyaanza ya Galiláaya, no kutaaha omuli Dekapoolisi. ");
INSERT INTO zin_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Okwo hakaba heena omuuntu oómo, óogwo akaba ali enzibamatwi káandi naadidibiza. Abaantu baámuléeta ahali Yeézu, baámuneémbelela amuteho engalo, abone kuchila. ");
INSERT INTO zin_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeézu yaamwiihaho kuluga omu mbága ya abaantu, yaázeenda náwe weénka ahatéena baantu. Yaákola enkumu zoómwe omu matwi go omuuntu oóli. Yaáchweela amachwaánta aha lukumúlwe, yaamukoláho aha lulími. ");
INSERT INTO zin_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yaálalamila omu igulu, yéecha, yaámugaambila aáti, “Efata,” ensoonga yaáho, “Komooloka.” ");
INSERT INTO zin_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ahonyini, omuuntu ogwo akomooloka amatwi, okukomwa kwo olulími lwoómwe kwaálekulila, yaábaanza kugaamba gaamba kuzima. ");
INSERT INTO zin_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeézu yaáyaángila embága ya abaantu nka nikwo, batabigaambila muuntu weéna wéena éebyo yaákola. Náho kwiingana óokwo yaázeendeliile kubaángila, nikwo bagumiizeho bwooli kwaátula empola ezo. ");
INSERT INTO zin_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Baásobelwa bwooli, baágaamba báti, “Góona áago alikukola ni maluunzi. Naachíza enzibamatwi nábo nibabona kuhulila, na abatita nábo nibabona kugaamba gaamba!” ");
INSERT INTO zin_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Omu bilo ebyo, káandi embága eéndi mpáango ya abaantu ekakoba, no omwáanya gukahiíngula bahweélwa ebyookulya. Niho Yeézu yaábéeta abaheémba boómwe, yaábagaambila nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Echi ne echilo cha kásatu abaantu aba tweékeele nábo, na tibéena choóna chóona echookulya, nicho chaambonesa mbazilile echiganyizi. ");
INSERT INTO zin_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kinakugaamba mbaleke bazeénde owaabo ne enzala, batakwiiza bakalába, bakagwa omu muháanda, na abáandi nibalugiílila hala.” ");
INSERT INTO zin_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Abaheémba boómwe bamugalulila báti, “Aha omu iluungu, tiheena omuuntu óogwo yaakuhicha kubonesa emikaate yo kubahaagisa abaantu bóona aba.” ");
INSERT INTO zin_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeézu yaábabúuza aáti, “Mwiina emikaate engáhi?” Baámugaambila báti, “Twiina emikaate musaanzu.” ");
INSERT INTO zin_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yeézu yaábalagila abaantu bóona beekale ahaansi. Yeemucha emikaate musaanzu ezo, yaásiima, yaágumenyula. Yaábaha abaheémba boómwe, babagabile abaantu. ");
INSERT INTO zin_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Káandi, bakaba beena otufwi tuche túti. Yeézu yaásiima, mala yaábalagila abaheémba boómwe babáhe abaantu. ");
INSERT INTO zin_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Abaantu baálya, baáhaaga. Niho, abaheémba baátulaaniza amasaága ge ebyookulya, beezuza ebitukulu musaanzu. ");
INSERT INTO zin_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Abaantu áabo bakalya ebyookulya bakaba nibahicha kuba ebihuumbi bina. Niho Yeézu yaábalaga abaantu abo, bazeénde owaabo. ");
INSERT INTO zin_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mala aba yaátaaha omu bwáato na abaheémba boómwe, baázeenda omu nsi ya Dalimanuta. ");
INSERT INTO zin_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Obuchilo Yeézu na abaheémba boómwe kábaahikile Dalimanuta, Abafarisayo beeza hali Yeézu. Baábaanza kuhakana náwe kuba bamuleénge. Bakaba nibamusaba aboóleke emanyiso kwoóleka nka nikwo alugile hali Múungu. ");
INSERT INTO zin_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeézu yaázuzubalilwa omu mwooyo. Yaábagaambila aáti, “Ha bwaáchi íimwe abaantu bo obuchilo óobu nimweénda kubona olumanyiso? Mazima butúnu niimbagaambila, íinye tiínkuboóleka olumanyiso lwoóna lwóona abaantu bo obuchilo óobu.” ");
INSERT INTO zin_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yaábaleka, yaátaaha káandi omu bwáato hamo na abaheémba boómwe. Baábaanza oluzeendo lwo kubuga babone kwaambuka ha mulaambo. ");
INSERT INTO zin_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Abaheémba ba Yeézu bakaba beebilwe kusutula emikaate. Bakaba beena omukaate gúmo gwoónka omu bwáato. ");
INSERT INTO zin_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeézu yaábahana aáti, “Muleémanya mube méeso ni ituumbyo lya Abafarisayo ne elyo omukáma Herode Antipasi.” ");
INSERT INTO zin_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Abaheémba boómwe baábaanza kubiteélana boónyini omuli boónyini báti, “Naagaámba aátyo, habwo kuba titwíina emikaate.” ");
INSERT INTO zin_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeézu akamanya góona áago bakaba nibahoóyela, yaábabúuza aáti, “Ha bwaáchi íimwe nimuteékateéka mweénka nka nikwo, mutéena mikaate? Mucháali kusoombookelwa no kumanya echiintu? Ngási emiganya yáanyu yaálemiile? ");
INSERT INTO zin_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nikwo kugaamba íimwe mwiina améeso, náho timukuhwéeza chiintu? Mwiina amatwi, náho timukuhulila chiintu? Óobu, ha bwaáchi timukwiizuka? ");
INSERT INTO zin_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Obuchilo óobu naámenywiile emikaate ezo itaanu no kubalíisa abaantu obusáago bwe ebihuumbi bitaanu, mukasuumbya ebitukulu biingáhi ebya amasaága?” Baámusubiza baágaamba báti, “Tukasuumbya ebitukulu ikúmi na bibili.” ");
INSERT INTO zin_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“No obuchilo naámenywiile emikaate musaanzu no kubabonesa abaantu ebihuumbi bina, mukasuumbya ebitukulu biingáhi ebya amasaága?” Baámusubiza baágaamba báti, “Ebitukulu musaanzu.” ");
INSERT INTO zin_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Niho yaábabúuza yaábazila aáti, “No óobu timukasoombookiilwe?” ");
INSERT INTO zin_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yeézu na abaheémba boómwe, baáhika aha mugoongo gwa Betisaida. Abaantu bunaanka bamuletela omuhume oómo. Baámusaba Yeézu amukolého no kumuchíza. ");
INSERT INTO zin_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeézu yaámukwáata engalo omuhume ogwo, yaázeenda náwe ahéelu yo ogwo mugoongo. Yaámuchweela amachwaánta omu méeso, yaamutéelaho engalo aha méeso, yaámubúuza aáti, “Óobu, noohweéza choóna chóona?” ");
INSERT INTO zin_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Omuuntu ogwo yaáleeba olugulu, yaágaamba aáti, “Niimbóna abaantu, nibaloleenkana nke emiti, nibalibata libata.” ");
INSERT INTO zin_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yeézu yaamutaho engalo káandi aha méeso, náwe ogwo muuntu yaánoonkola améeso ge. Yaáchila, yaáhicha kuhwéeza ebiintu byóona kuzima. ");
INSERT INTO zin_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeézu yaámugaambila aáti, “Zeénda omúka, otasuba omuli ogu mugoongo.” ");
INSERT INTO zin_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yeézu na abaheémba boómwe baalugáho Betisaida, baázeenda emigoongo ya héehi na Kaizáaria‑Filipi. Obuchilo bakaba nibalibata omu muháanda, Yeézu yaábabúuza aáti, “Abaantu nibagaámba íinye ndi oóha?” ");
INSERT INTO zin_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bamugalulila báti, “Abáandi nibagaámba íiwe ni Yohana Omubatiza, abáandi nibagaámba íiwe no omubáasi Eliya, abáandi nibagaámba no omubáasi oóndi wa kala wa Múungu.” ");
INSERT INTO zin_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yaábabúuza aáti, “Óobu íimwe, nimugaámba íinye ndi oóha?” Peétero yaámugalulila yaámuzila aáti, “Íiwe ni Masihi.” ");
INSERT INTO zin_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeézu yaábahana batagema kumugaambila omuuntu weéna wéena weényini noóha. ");
INSERT INTO zin_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Niho Yeézu yaábaanza kubeégesa abaheémba boómwe, nka nikwo ni lwaampaka hali íinye Mutábani wo Omuuntu, mbone ebyaágalalo biháango, nnyaángwe na abanyaampala ba Abayahudi, na abakúlu ba abagabe, na abeégesa be ebilagilo bya Musa, na nnyitwe. Náho echilo cha kásatu kulugiilila kufwa kwaanze, niinzóolwa. ");
INSERT INTO zin_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yeézu akaba naabagaambila abaheémba boómwe echigaambo echo butúnu. Náho Peétero yaámweeta ha lubazu, yaábaanza kumuchaáhukila. ");
INSERT INTO zin_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yeézu yaáhiinduka, yaábaleeba abaheémba boómwe. Yaámuchaáhukila Peétero aáti, “Íiwe Isitáani, galuka enyuma yaanze! Habwo kuba, ebiteékuzo byaawe ne bya abaantu kwoónka náho ti bya Múungu.” ");
INSERT INTO zin_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yaáyéta embága ya abaantu hamo na abaheémba boómwe, yaábagaambila aáti, “Kaálaaba omuuntu weéna wéena naaloonda kuba omuheémba waanze, naayeéndelwa aleke kukuláatila ebiteékuzo byoómwe asutule omusalaba gwoómwe, ankulaatile. ");
INSERT INTO zin_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Habwo kuba omuuntu óogwo alaayeénda kuchuúngula obulami bwoómwe, alyaábubuza obulami bwoómwe. Mazima óogwo alaásiingaalicha obulami bwoómwe ha bwaanze na habwe Empola Nzima, naába no obulami bwo obucha no buchiile. ");
INSERT INTO zin_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Omuuntu naabona mugaso chi, kaálaabonesa byóona ebyo omu nsi ezi, náho akabuza obulami bwoómwe bwo obucha no obuchiile? ");
INSERT INTO zin_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Óobu, omuuntu yaakaáhicha kusohoza chiintu chi cho kubonesa kumusubiza obulami bwoómwe? ");
INSERT INTO zin_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Óogwo alaánzilila ensóni íinye na amagaambo gaanze aha buchilo óobu bwe ebiheno no obutamweésiga Múungu, íinye Mutábani wo Omuuntu niimmuzilila ensóni omuuntu ogwo obuchilo niintuúka hamo na bamaléeka abatakatíifu ahi ikuzo lya Táata.” ");
INSERT INTO zin_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yeézu yaázeendelela kubasoomboolela aáti, “Mazima butúnu niimbagaambila nka nikwo, heena abaantu omuli aba abeémeeliile aha áabo tibalifwa bachaali kubona obukáma bwa Múungu obulikwiiza na amagala.” ");
INSERT INTO zin_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Obuchilo byaáhiíngwiile ebilo mukáaga, Yeézu yeemucha Peétero, Yakobo na Yohana, yaáhanama nábo omu ibaanga lila, ahaantu áaho hakaba hatéena baantu. Obuchilo bali aho, Yeézu yaábahiinduka kúundi ensuso yoómwe, omu méeso gáabo. ");
INSERT INTO zin_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ebizwáalo byoómwe byaámweeka bwooli. Byaaba byaáyela kusáaga omufuzi weéna wéena wo omu nsi ezi tiyaákuhicha kufula aátyo. ");
INSERT INTO zin_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Abaheémba bwoómwe baábona Musa na Eliya, baaba nibagaamba gaamba na Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Niho Peétero yaámugaambila Yeézu aáti, “Mweégesa, ni kuzima íichwe tuliho aha. Twoombeke aha otutiindi túsatu, kámo kabe akaawe, akáandi kabe aka Musa, na akáandi kabe aka Eliya.” ");
INSERT INTO zin_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Náho talamanyile echo kugaamba, habwo kuba weényini na bazeenzíbe bakakwáatwa obutíini bwooli. ");
INSERT INTO zin_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Niho lyéeza elíile, lyaábasweekelela. Iláka lyaáhulilwa kulugiilila omu líile, lyaágaamba líti, “Ogu niwe Mutábani waanze engaanzi, mumuhuliilíze weényini.” ");
INSERT INTO zin_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Abaheémba abo baba baáleeba kunu na kunu, kwiíchulwa! Tibalamubwéene omuuntu oóndi ayaabeele ali hamo nábo, kwoónka Yeézu weénka. ");
INSERT INTO zin_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Obuchilo bakaba nibagolomoka kuluga ahi ibaanga elyo, Yeézu yaábalagila nka nikwo batabigaambila muuntu weéna wéena éebyo baábona, kuhicha obuchilo Mutábani wo Omuuntu aliba yaázookile kuluga omu bafwiile. ");
INSERT INTO zin_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Abaheémba abo baáchikwáata echigaambo echo, náho baaba nibeebuúza boónyini boónka báti, “Okwo kuzooka kwoómwe kuluga omu bafwiile ensoonga yaáho ni chiíha?” ");
INSERT INTO zin_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Baámubúuza Yeézu báti, “Óobu ha bwaáchi abeégesa be ebilagilo bya Musa bagaámba nka nikwo, ni lwaampaka Eliya amweébeembelele Masihi kwíiza?” ");
INSERT INTO zin_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Náwe yaábagalulila aáti, “Mazima Eliya naayebeembela kwíiza na naaloónza kuzima ebiintu byóona. No óobu bityo, ha bwaáchi chaandikilwe aha Maandiko Matakatíifu nka nikwo, íinye Mutábani wo Omuuntu ndyaáyagalala ebyaágalazo bíinzi no kugaywa? ");
INSERT INTO zin_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Náho niimbagaambila nka nikwo, Eliya yeézile, abaantu bakamukolela góona amábi óokwo baabeele nibeénda, nko óokwo byaabeele byaándikilwe habwa weényini.” ");
INSERT INTO zin_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Obuchilo Yeézu, Peétero, Yohana na Yakobo baáhikile aha baheémba abáandi, baábona embága mpáango ya abaantu ebazoongolokile. Abeégesa be ebilagilo bya Musa bakaba nibahakana na abaheémba. ");
INSERT INTO zin_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Obuchilo embága ezo yaamubwéene Yeézu, yóona yaásobelwa bwooli. Ahonyini baámwiílukiilila, baámwaangalucha. ");
INSERT INTO zin_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yeézu yaábagaambila aáti, “Nimuhakana chiíha nábo?” ");
INSERT INTO zin_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Omuuntu oómo omuli ezo mbága yaábasubiza aáti, “Mweégesa, naámuléeta mutábani waanze hali íiwe. Ayina izimu éelyo lilikumukola aábe omutita. ");
INSERT INTO zin_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Entúlo nyíinzi nilimutuungama, nilimugwíisa ahaansi, naasohoza ifúlo omu kanwa, no kusa améeno no kukaánzagala omubili gwóona. Abaheémba baawe mbasabile nka nikwo balibiínge izimu, náho bakalemwa.” ");
INSERT INTO zin_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeézu yaábasubiza aáti, “Íimwe abaantu be enchilo ezi zo kwáanga kwiikiliza, niinyikala neemwe no kubeémela kuhicha li? Mumuléete omusígazi hali íinye.” ");
INSERT INTO zin_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Baámuléeta omusígazi ogwo ahali Yeézu. Náho obuchilo izimu lyaamubweene Yeézu, ahonyini lyaamutamo ebisiimbo ogwo musígazi. Yáagwa ahaansi, yaágalaagala no kusohoza ifúlo omu kanwa. ");
INSERT INTO zin_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeézu yaámubúuza iíse wo omusígazi aáti, “Ebyaágalazo ebi bibaandize kuluga iíli?” Iíse yaámuzila aáti, “Kulugiilila aha buto bwoómwe. ");
INSERT INTO zin_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Entúlo nyíinzi izimu elyo limugwiísize omu mulilo no omu méenzi libone kumwíita. Óobu koólaaba noohicha kukola choóna chóona, otuzilile echiganyizi, otuzune.” ");
INSERT INTO zin_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeézu yaámugalulila aáti, “Ha bwaáchi noogaámba ‘Koólaaba noohicha’? Góona gakwiíle ha muuntu óogwo alikumwiíkiliza Múungu.” ");
INSERT INTO zin_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Niho iíse wo ogwo musígazi kwaambaza ahi iláka naagaámba aáti, “Niinyikiliza! Náho okwiikiliza kwaanze ni kuche, onzune.” ");
INSERT INTO zin_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Obuchilo Yeézu akabona nka nikwo embága ya abaantu neeyoongela bwaangu kumuzoóngoloka, yaálikaama elyo izimu, naalizila aáti, “Íiwe izimu! Nookola ogu musígazi kuba omutita ne enzibamatwi. Óobu niinkulagila, oluhéendého aha musígazi ogu, mále otalimutaahámo nakáti.” ");
INSERT INTO zin_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Niho izimu elyo kutéela eyoombo mpáango, lyaámugwiisa ogwo musígazi no kumutamo ebisiimbo bwooli, liba lyaamulugaho. Ogwo musígazi aba yáaba nka ayáafwa, béenzi aho bakaba nibagaámba báti, “Yaáfwa!” ");
INSERT INTO zin_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Náho, Yeézu yaámukwáata engalo ogwo musígazi, yaámwiimucha, náwe ayemeelela. ");
INSERT INTO zin_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Niho Yeézu yaátaaha omu nzu, abaheémba boómwe baámubúuza ha bweeseléke báti, “Ha bwaáchi íichwe tukalemwa kulibiinga izimu elyo?” ");
INSERT INTO zin_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yeézu yaábagaambila aáti, “Izimu nke eli tilikuhicha kubiingwa kwoónka náho habwo okusaba.” ");
INSERT INTO zin_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yeézu na abaheémba boómwe baalugáyo okwo, baánogoza ahagáti ye éensi ya Galiláaya. Yeézu talayeenzile abaantu bamanye nka nikwo ali okwo, ");
INSERT INTO zin_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","habwo kuba akaba naabeegésa abaheémba boómwe. Yaábagaambila aáti, “Íinye Mutábani wo Omuuntu niinkoóngwa na nibaánta omu ngalo za abaantu nábo balaányíta, náho echilo cha kásatu, ndaázoolwa.” ");
INSERT INTO zin_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Abaheémba boómwe tibalasoombookiilwe echigaambo éecho akaba naagaámba, no óobu bityo batiina kumubúuza. ");
INSERT INTO zin_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yeézu na abaheémba boómwe baáhika Kaperinaumu. Baátaaha omu nzu eémo, Yeézu yaábabúuza aáti, “Mubele nimweehakanisa chiíha omu muháanda?” ");
INSERT INTO zin_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Náho abaheémba boómwe beésiza, habwo kuba bakaba nibeehakanisa boónyini boónka omu muháanda nka nikwo noóha omuli boónyini óogwo akaba ali mukúlu kusaaga bazeenzíbe bóona. ");
INSERT INTO zin_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yeézu yeekala ahaansi, yaábéeta abo baheémba boómwe ikúmi na bábili. Yaábagaambila aáti, “Omuuntu óogwo alikweenda aábe niwe mukúlu omuli bóona, naayeéndelwa aábe omweécheesha, no kuba omuzáana ahali bóona.” ");
INSERT INTO zin_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mala yeemucha omwaana muto, yaámuta ahagáti yáabo. Yaámufuúmbata, yaábagaambila nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Omuuntu óogwo alikumwiínaankula omwaana nko ogu ahi izíina lyaanze, naába yaányinaankula íinye. Káandi, omuuntu óogwo alaanyinaánkula íinye, takuunyinaánkula íinye nyeénka. Mazima naába yaámwiinaankula na Múungu owo obuzizi óogwo akaansiíndika íinye.” ");
INSERT INTO zin_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana yaámugaambila Yeézu aáti, “Mweégesa, tukamubona omuuntu óogwo akaba naataagucha amazimu ahi izíina lyaawe, twaámwaangila, habwo kuba weényini ti muheémba waawe nkeechwe.” ");
INSERT INTO zin_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Náho Yeézu yaámuzila aáti, “Mutamwaángila omuuntu nko ogwo. Habwo kuba tihaliho omuuntu óogwo alikukola ihano ahi izíina lyaanze, akamala akahicha káandi kuúngaamba kubi. ");
INSERT INTO zin_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Omuuntu óogwo atakwaángilana neechwe, ali hamo neechwe. ");
INSERT INTO zin_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Omuuntu weéna wéena óogwo alaábaha no óobu améenzi mache go okunywa, habwo kuba íimwe muli abaantu ba Masihi, mazima butúnu niimbagaambila nka nikwo, ogwo naayinaánkula empeéla yoómwe.” ");
INSERT INTO zin_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yeézu yaázeendelela kugaamba aáti, “Náho kaálaaba aliho omuuntu ogwo akamuleételela akole ebiheno oómo omu bato aba abalikuunyikiliza, ni haáchili hali weényini akomwe olubeengo omu bicha no kutubizwa omu chitubi che enyaanza. ");
INSERT INTO zin_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Káandi, kábilaaba omukóno gwaawe nigukuleételela kukola ebiheno, ogunogole. Ni haáchili otaahemo omu bulami bwo obucha no buchiile oyina obulema bwe engalo eémo, kuchila kuba ne engalo ibili no kuzeenda omu lyoongoola lyo mulilo gwa kuzimu.  ");
INSERT INTO zin_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Okwo hoónyini amazito gaáyo tigafwa, no omulilo gwaáyo tigulaala. ");
INSERT INTO zin_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Keélaaba okugulu kwaawe nikukuleetelela kukola ebiheno, okunogole. Ni haáchili otaahemo omu bulami bwo obucha no buchiile oli omulema wo okugulu kúmo, kuchila kuba na amagulu abili no okunagwa omu lyoongoola lyo omulilo gwa kuzimu.  ");
INSERT INTO zin_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Okwo hoónyini amazito gaáyo tigafwa, no omulilo gwaáyo tigulaala. ");
INSERT INTO zin_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na kabyaakuba elíiso lyaawe lyaákuleételela kukola ebiheno, olikúulemo. Ni haáchili otaahemo omu bukáma bwa Múungu oyina ensóongo, kuchila kutaahamo oyina améeso abili no kuza kunagwa omu lyoongoola lyo omulilo gwa kuzimu. ");
INSERT INTO zin_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Okwo hoónyini amazito gaáyo tigafwa, no omulilo gwaáyo tigulaala.” ");
INSERT INTO zin_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Múungu naalabya buli muuntu omu lwaágalalo óolwo olulikususana no omulilo, nko óokwo abagabe bakaba basiiga omwóonyo omufwa gwe echitáambo omwáanya bachaali kuchisiingaalicha. ");
INSERT INTO zin_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Omwóonyo ni muluunzi, náho kagulikubuza omuta gwaáyo, niguhicha kutulilwa chiintu chi gubone kukoza káandi? Neemwe mube nko omwóonyo óogwo ogukolize, mube no obuhóolo íimwe omuli íimwe.” ");
INSERT INTO zin_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Niho Yeézu na abaheémba boómwe baalugáho okwo Kaperinaumu, baázeenda omu nsi ya Yudea, baáyaambuka buseeli bwo omunóna gwa Yorodáani. Embága za abaantu béenzi káandi nizimuzoongoloka, mala yaaba naabeegésa nko óokwo bukaba buli obuteéka bwoómwe. ");
INSERT INTO zin_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mala kuluga omu Bafarisayo beeza babone kumuleengesa. Baámubúuza báti, “Ngási, ebilagilo bya Musa nibikuundilana omukwaáta kumuleka mukázi woómwe?” ");
INSERT INTO zin_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yeézu yaábagalulila aáti, “Ngási, Musa akabalagila chilagilo chi?” ");
INSERT INTO zin_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Baámusubiza nibagaámba báti, “Musa akeekiliza nka nikwo, iíba amwaandikile mukázi woómwe olwaandiko lwo kwaángana no kumuhicha.” ");
INSERT INTO zin_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aho Yeézu yaábagaambila aáti, “Musa akabaandikila echilagilo echo habwo kulemeela kwe emiganya yáanyu. ");
INSERT INTO zin_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Náho, kulugiilila aha bubaandizo bwo kuhaangwa éensi, Múungu akahaanga omukwaáta no omukázi, ");
INSERT INTO zin_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Habwe ensoonga ezo, omukwaáta alaasiga iíse na nyina, akwaátaangane na mukazíwe, ");
INSERT INTO zin_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nábo bábili nibaba omubili gúmo.’ Ha bwéecho, tibaliba bábili káandi, náho omubili gúmo. ");
INSERT INTO zin_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nikwo, éecho echaateelanisizwe na Múungu, omuuntu atachitaáganisa.” ");
INSERT INTO zin_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Obuchilo baátaahile káandi omu nzu, abaheémba boómwe baámubúuza habwe echigaambo echi. ");
INSERT INTO zin_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yeézu yaábagaambila aáti, “Omuuntu weéna wéena óogwo alaamuleka mukazíwe no kukuúmpula oóndi, aho naába naamukolela obuseégu ogwo mukazíwe owa mbele. ");
INSERT INTO zin_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","No omukázi óogwo alaáleka iíba no kuswéelwa no omukwaáta oóndi, weényini ogu mukázi naába omusaambani.” ");
INSERT INTO zin_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Abaantu bakaba nibamuleetela Yeézu abáana abato abone kubakoláho no kubáfuuha. Náho abaheémba boómwe baábachaáhukila abaantu abo. ");
INSERT INTO zin_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Obuchilo Yeézu yaábabwéene abaheémba boómwe nibakola bátyo, yaánigahalilwa. Yaábagaambila aáti, “Mubaleke abáana abato beéze hali íinye, mutabazibila kuunyizaho! Manya obukáma bwa Múungu no bwa abaantu abo kwiingana nka abáana abato aba. ");
INSERT INTO zin_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mazima butúnu niimbagaambila nka nikwo, weéna wéena óogwo atakwaánaankula obukáma bwa Múungu nko omwaana omuto, óogwo takuhicha kubutaahamo obukáma bwa Múungu no obuche bwa akáti.” ");
INSERT INTO zin_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aho aba yaábanyweégela abo baana, no kubateelaho engalo zoómwe, yaábafuuha. ");
INSERT INTO zin_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Obuchilo Yeézu na abaheémba boómwe bakabaanza kulugáho, omuuntu oómo yaámwiílukiilila, yaáteela ebizwi ahaansi omu méeso goómwe. Yaámubúuza aáti, “Mweégesa omweésigwa, nkole chiíha mbone kuhuungula obulami bwo obucha no obuchiile?” ");
INSERT INTO zin_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yeézu yaámugalulila aáti, “Ha bwaáchi noogaámba íinye ndi omweésigwa? Tihaliho omuuntu óogwo ali omweésigwa, náho Múungu weénka. ");
INSERT INTO zin_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mbwéenu, noobisoombookelwa ebilagilo bya Múungu éebyo bilikugaamba nka nikwo, ‘Otaákwiita, otaákuba omusaambani, otaákwiiba, otaákusiinza ebisuba, otaákubeeha, obakúze iíso na nyoko.’ ” ");
INSERT INTO zin_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ogwo muuntu aba yaámusúbiza aáti, “Mweégesa, ebyo byóona mbikoondoókiile kulugilila aha buto bwaanze.” ");
INSERT INTO zin_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yeézu yaámuleeba aha kumweétegeeleza, yaámwéenda, yaámugaambila aáti, “Noobulabulilwa echiintu chimo. Zeénda oguze ebiintu byóona éebyo oyinabyo, empilya ezo obáhe abahabi, aho noóba waázila ensabo yaawe omu igulu. Mále oyize, onkulaatile.” ");
INSERT INTO zin_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Náho, obuchilo yaáhuliile aátyo, yaásaaswa aha muganya habwe echigaambo echo. Yaalugáho habwo buzune, habwo kuba akaba ali omuhíte bwooli. ");
INSERT INTO zin_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yeézu yaáleeba kunu na kunu, yaábagaambila abaheémba boómwe aáti, “Chilyáaba chigumile aha bahíte kuzamo omu bukáma bwa Múungu!” ");
INSERT INTO zin_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abaheémba boómwe baásobelwa habwa amagaambo goómwe. Yeézu yaábagaambila káandi aáti, “Baana baanze, muléebe nka nikwo chigumile kuzamo omu bukáma bwa Múungu. ");
INSERT INTO zin_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mala chihuhuukile bwooli ha ntwaangabuleende kuhiíngula omu kahulu ko olusíinge, kusaaga omuhíte kuza omu bukáma bwa Múungu.” ");
INSERT INTO zin_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Abaheémba boómwe baáyoongela kusobelwa muno, habwe echigaambo echo. Baaba nibeebuúza boónyini omuli boónyini báti, “Óobu noóha mbwéenu óogwo yaakaáhicha kuchuúngulwa?” ");
INSERT INTO zin_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeézu yaábaleeba omu kubeétegeeleza, yaábagaambila aáti, “Ha baantu tigakwiíle, náho hali Múungu ti bityo, habwo kuba hali Múungu góona gakwiíle.” ");
INSERT INTO zin_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peétero yaámugaambila aáti, “Léeba, íichwe tukasiga byóona, nitukukulaatila íiwe no kuba abaheémba baawe.” ");
INSERT INTO zin_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Niho Yeézu yaágaamba aáti, “Mazima butúnu niimbagaambila nka nikwo, omuuntu óogwo asigile eekáye, akasiga beene báabo, banyáanya, nyina, iíse, abáana, nali amasaambo, ha bwaánze na habwe Empola Nzima, ");
INSERT INTO zin_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Múungu naamuha bíinzi bwooli kusaaga ebyo. Mbwéenu omu mwáanya ogu naayinaánkula amazu, abalumuna, banyáanya, ba nyina, abáana na amasaambo. Hamo na ago góona, naába ne ebyaágalazo. Na aha buchilo obwo obulikwiiza, aleénaánkula obulami bwo obucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Náho béenzi áabo abalikuleebwa na abo omugaso óobu, tibaliba no omugaso gwoóna gwóona omu buchilo obwo obulikwiiza. Káandi na béenzi áabo abalikuleebwa ti bo omugaso óobu, baláaba abo omugaso omu buchilo obwo obulikwiiza.” ");
INSERT INTO zin_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Obuchilo Yeézu na abaheémba boómwe bakaba bali omu muháanda kuzeenda omu chikaali cha Yeruzaléemu, Yeézu akaba naabeebeembelela omu méeso gáabo. Abaheémba boómwe baásobelwa, na abaantu abáandi abaabeele nibamukulaatíla, bakaba beena obutíini Yeézu yaábéeta káandi ha lubazu abaheémba boómwe ikúmi na bábili, yaábaanza kubasoomboolela áago agalaamusaánga. ");
INSERT INTO zin_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yaágaamba aáti, “Léeba, óobu twaayeleka Yeruzaléemu. Niho óokwo, íinye Mutábani wo Omuuntu, nibaánta omu ngalo za abakúlu ba abagabe ba Múungu no omu ngalo za abeégesa be ebilagilo bya Musa. Nábo nibaanchwaaziíka nka nikwo nnyítwe. Káandi, nibaantwaála omu ngalo za Abanyamahaánga. ");
INSERT INTO zin_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Áabo baantu nibaandogota no kuunchwéela amachwaánta. Nibaankóna enkoba no kuunyíta. Náho, echilo cha kásatu, ndaázooka.” ");
INSERT INTO zin_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Niho Yakobo na Yohana, abáana ba Zebedayo, baámwiilila héehi Yeézu, baámugaambila báti, “Mweégesa, nitusaba otukolele choóna chóona éecho tulaákusaba.” ");
INSERT INTO zin_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yeézu yaábabúuza aáti, “Nimweénda mbakolele chiíha?” ");
INSERT INTO zin_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Baámugaambila báti, “Obuchilo olaabaanza kutégeka omu ikuzo lyaawe, nitukusába twiikale hamo neewe, oómo olubazu lwo omukóno gwo obúlyo, oóndi olubazu lwo omukóno gwo obumoso.” ");
INSERT INTO zin_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yeézu yaábagaambila aáti, “Timukuchisoombookelwa éecho mulikusaba. Ngási, mukaáhicha kunywéela echikóombe éecho ndinyweelaho íinye, nali mukaáhicha kubatizwa obubatizo bwo kufwa óobwo ndaabatizibwa íinye?” ");
INSERT INTO zin_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Baámusubiza báti, “Nitúhicha.” Yeézu yaábagaambila aáti, “Mazima, nimuchinyweélaho echikóombe éecho íinye ndikuchinywéeláho, no kubatizwa obubatizo óobwo ndaabatizibwa íinye. ");
INSERT INTO zin_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Náho, kwíikala olubazu lwaanze lwo obúlyo nali lwo bumoso ti mulimo gwaanze kubakuúndila. Omwáanya ogwo na habwa áabo abaloongiizwe.” ");
INSERT INTO zin_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Obuchilo abaheémba abáandi ikúmi bahuliile ha bwéecho, baábaanza kubatamwa Yakobo na Yohana. ");
INSERT INTO zin_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Niho Yeézu yaábaháma abaheémba bóona, beelile hali weényini. Yaábagaambila aáti, “Nimusoomboókelwa nka nikwo abatégeki ba amahaánga agáandi nibategéka abaantu báabo lwa amagala, káandi nibabakozesa. ");
INSERT INTO zin_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Náho etaákwiiza bikaba bityo hali íimwe. Omuuntu weéna wéena ogwo alikweenda kuba mukúlu omuli íimwe, naayeéndelwa kuba omuzáana wáanyu. ");
INSERT INTO zin_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","No omuuntu ogwo alikweenda kuba owa mbele omuli íimwe, aábe omuhálila wa bóona. ");
INSERT INTO zin_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Habwo kuba neenye Mutábani wo Omuuntu, tiíndeezile mbone kukolelwa, náho nnyizile kubakolela abaantu no kusohoza obulami bwaanze, mbone kubakomoolola abaantu béenzi.” ");
INSERT INTO zin_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Niho, baba baáhika omuli Yeriko. Obuchilo Yeézu na abaheémba boómwe, ne embága mpáango ya abaantu nibaluga omuli Yeriko, bakamusaanga omuuntu oómo óogwo akaba ali omuhume mala káandi ali omusabiliza ni izíina lyoómwe Baritimayo, ali mutábani wa Timayo. Akaba ayikeele aha mpelo yo omuháanda kunu naasabiliza. ");
INSERT INTO zin_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Obuchilo yaáhuliile nka nikwo Yeézu Omunyanazaréeti akaba naahiingula aho, yaábaanza kuhamuka ahi iláka liháango, “Yeézu, Mutábani wa Daudi, onzilile echiganyizi!” ");
INSERT INTO zin_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Abaantu béenzi baaba nibamukáama nka nikwo ayésize. Náho weényini akoongela kwaambaza ahi iláka liháango bwooli, “Mutábani wa Daudi, onzilile echiganyizi!” ");
INSERT INTO zin_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Niho Yeézu kweémeelela yaágaamba aáti, “Mumwéete ayize aha.” Baámwéeta ogwo muhume, baámugaambila báti, “Tiímbya omuganya, yemeelela! Naakweéta.” ");
INSERT INTO zin_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Náwe yaánaga echizwáalo choómwe ahaansi, yaáyemeelela bwaangu, yaázeenda hali Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeézu yaámubúuza aáti, “Nooyeénda nkukolele chiíha?” Omuhume ogwo yaámugalulila aáti, “Mweégesa, niinyeénda kuhwéeza.” ");
INSERT INTO zin_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeézu yaámuzila aáti, “Táaha omúka, okwiikiliza kwaawe nikwo kwaákuchiza.” Ahonyini, ogwo muuntu aba yaábaanza kuhwéeza, yaámukulaatila Yeézu omu muháanda. ");
INSERT INTO zin_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Obuchilo Yeézu na abaheémba boómwe bakaba beélilila omu chikaali cha Yeruzaléemu, héehi ne emigoongo ya Betifáage na Betania, ahi ibaanga lye Emizeituni, Yeézu yaábasiíndika bábili omuli abo. ");
INSERT INTO zin_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yaábagaambila aáti, “Nimuzeénde omu mugoongo óogwo oguli omu méeso gáanyu. Obuchilo nimuhika okwo, ahonyini nimusaánga omwaana gwe ensíkili, óogwo ogutakasutulaga muuntu, gusibikilwe. Mugusibule muguléete aha. ");
INSERT INTO zin_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","No omuuntu weéna wéena kaálaababúuza nka nikwo, ‘Ha bwaáchi nimukola mútyo?’ mumugaambile nka nikwo, ‘Omukáma wéetu naagweénda, naagusubya óobu nyini.’ ” ");
INSERT INTO zin_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mbwéenu baázeenda, baágusaanga omwaana gwe ensíkili gusibikilwe ahéelu yo olwiizi aha muháanda omugazi, baágusibula. ");
INSERT INTO zin_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Abaantu bunaanka omuli áabo abaabeele beémeeliile aho héehi, baábabúuza báti, “Íimwe! Nimukola chiíha aho? Ha bwaáchi nimugusibula ogwo mwáana gwe ensíkili?” ");
INSERT INTO zin_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Abaheémba abo baábagalulila nko óokwo Yeézu akaba abalagiile ku balagaambáho. Mbwéenu abo baantu baábeekililiza. ");
INSERT INTO zin_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Abaheémba abo baágutwáala omwaana gwe ensíkili ahali Yeézu, no kwaala emyéenda yáabo aha lugulu ye ensíkili ezo. Yeézu yaahanamáho, yeékala. ");
INSERT INTO zin_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Abaantu béenzi baáyala emyéenda yáabo omu muháanda, abáandi baánogola amatábazi omu misili no kwaala omu muháanda. ");
INSERT INTO zin_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Abaantu bunaanka bakaba nibamweebeembelela Yeézu, abáandi bakaba nibamukulaatíla enyuma. Bóona bakaba nibahamuka iláka bakaba nibagaámba báti, “Hosana! Ayina omugisa ogwo alikwiiza ahi izíina lyo Omukáma Múungu! ");
INSERT INTO zin_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bwiina omugisa obukáma bwe isíichwe enkúlu Daudi, óobwo obulikwiiza! Hosana Múungu wo omu igulu!” ");
INSERT INTO zin_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeézu yaataahámo omuli Yeruzaléemu, yaázeenda gúmo gwoónka, yaátaaha omu nzu ya Múungu. Yaábileeba aha bweétegeelezi ebiintu byóona éebyo bikaba bilimo omwo. Náho habwo kuba ekaba kali akáanya ko olweébazo, yaalugáho, yaázeenda Betania hamo na abaheémba boómwe ikúmi na bábili. ");
INSERT INTO zin_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nyeéncha eémo Yeézu na abaheémba boómwe obuchilo baabeele nibaluga Betania kusuba Yeruzaléemu, yaáhulila enzala. ");
INSERT INTO zin_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yaáloleela kuluga hala, omuti gwo omutini, ogwo gukaba gwiina amababi méenzi. Aba yaágwiilililaho abone kuleeba kagulaaba gwiina amagoomba. Káyaahikile aho, yaásaanga tigwíina amagoomba, gwiizwíile amababi goónka, habwo kuba obuchilo óobu bukaba butakahikile bwo kulabisa emisumo. ");
INSERT INTO zin_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Niho yaágucheena omuti ogwo aáti, “Kubaandiza leélo éeli kuhicha buchiile, nakáti omuuntu weéna wéena atalilya omusumo kuluga hali íiwe!” Abaheémba boómwe baágahulila amagaambo ago. ");
INSERT INTO zin_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Obuchilo kábaahikile Yeruzaléemu, niho Yeézu yaátaaha omu lubúga lwe éenzu ya Múungu. Kayataahile omwo, yaábasaanga béenzi abaabeele nibaguza no kugula ebiintu omwo, yaábabiinga bóona. Yaábaanza kuziluúndula emeéza za abaabeele nibahiínga empilya, ne ebitébe bya abaabeele nibaguza ebiiba. ");
INSERT INTO zin_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mala, talamukuúndiile omuuntu weéna wéena kwiimucha echiintu choóna chóona kuchilabya omu lubúga lwe éenzu ya Múungu. ");
INSERT INTO zin_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Niho Yeézu yaábeégesa, yaágaamba aáti, “Ngási, tibyaandikilwe omu Maandiko Matakatíifu, nka nikwo Múungu akagaamba aáti, ‘Éenzu yaanze elyáaba éenzu yo kusabilamo ha mahaánga góona?’ Náho íimwe, mwaázihiindwiile kuba ‘enyaanga ya abasaakuzi.’” ");
INSERT INTO zin_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Obuchilo abakúlu ba abagabe na abeégesa be ebilagilo bya Musa baáhuliile ago góona, baábaanza kuloondela omuháanda gwo kumwíita, habwo kuba bakaba nibamutiína, ha kumanya nka nikwo abaantu bóona bakaba nibamuteénga habwa ameégeso goómwe. ");
INSERT INTO zin_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Káhaabeele haaba olweébazo, Yeézu na abaheémba boómwe baalugáho baásohola omuli echo chikaali. ");
INSERT INTO zin_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Buchiile enchaákala, obuchilo baabeele nibasuba omu chikaali cha Yeruzaléemu, baágusaanga omutini ogwo gwaáyomile gwóona kubaandiza emizi yaágwo kuhika ahakaneenge neenge. ");
INSERT INTO zin_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peétero aba yeézuka amagaambo áago Yeézu akagulagila, mala aba yaámugaambila Yeézu aáti, “Mweégesa, léeba! Omutini óogwo waacheénile, gwaáyomile!” ");
INSERT INTO zin_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeézu yaábasubiza aáti, “Mumweésige Múungu. ");
INSERT INTO zin_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mazima butúnu niimbagaambila nka nikwo, omuuntu óogwo alaamweésiga Múungu mala akabulwa okugumwa gumwa aha muganya gwoómwe, mazima éecho alikugaamba nichibaho. Yaakaáhicha kugaambila ibaanga éeli nka nikwo, ‘Kuúka oze kweénaga omu nyaanza,’ na ago nigakolwa. ");
INSERT INTO zin_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ha bwéecho niimbagaambila nka nikwo, obuchilo mulaasaba choóna chóona, mube no obweésige nka nikwo mwaábiinaánkwiile, neemwe nimubiinaánkula. ");
INSERT INTO zin_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Náho obuchilo nimusaba, muganyile omuuntu weéna wéena óogwo abaheniile, kuba náwe Isíimwe owo omu igulu abone kubaganyila neemwe ebiheno byáanyu byóona.  ");
INSERT INTO zin_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Náho kábilaaba íimwe mutakuganyila abáandi, náwe Isíimwe owo omu igulu takubaganyila ebiheno byáanyu.” ");
INSERT INTO zin_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yeézu na abaheémba boómwe baáhika káandi omuli Yeruzaléemu. Obuchilo akaba naalibata omu lubúga lwe éenzu ya Múungu, abakúlu ba abagabe, abeégesa be ebilagilo bya Musa na abanyaampala ba Abayahudi baamukobaho Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Baámubúuza báti, “Ago go olikukola, noogakola aha buzizi chi? Noóha ogwo akuheéle obuzizi obwo?” ");
INSERT INTO zin_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeézu yaábazila aáti, “Neenye niimbabuúza echigaambo chimo. Kámulaahicha kuunsubiza echo, neenye niimbagaambila na habwa buzizi chi niinhicha kugakola aga gi ndikukola. ");
INSERT INTO zin_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ngási, Yohana akeeha nkáhi obuzizi bwo kubatiza abaantu? Bukaluga ahali Múungu nali bukaluga aha baantu? Tuléebe nimuunsubize!” ");
INSERT INTO zin_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Baábaanza kubiteélana boónyini boónka kunu nibagaámba báti, “Katulaagaámba nka nikwo, ‘Bukaluga ahali Múungu,’ naatubuúza nka nikwo, ‘Mbwéenu, habwa chiíha timulamwiíkiliize?’ ");
INSERT INTO zin_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Náho, katulaagaámba nka nikwo, ‘Bukaluga aha baantu,’ abaantu nibatunigahalila.” Bakaba nibabatiína abaantu, habwo kuba abaantu bóona bakamweétegeéleza Yohana nka nikwo, no omubáasi wa mazima. ");
INSERT INTO zin_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Niho, bamugalulila Yeézu báti, “Titukumanya.” Náwe Yeézu yaábasubiza aáti, “No óobu íinye tiínkubagaambila niingakola amagaambo aga habwa buzizi chi.” ");
INSERT INTO zin_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yeézu yaábaanza kufúmoola na abo abatégeki ba Abayahudi omu kubachwéela emigani. Yaábagaambila aáti, “Hakaba heena omuuntu oómo óogwo akalima omusili gwe emizabibu. Yaáguzoóngolocheza olugo, yaasumamo izuungilo lyo kuzuungilamo ezo zabibu. Yaáyoómbeka oluswi luleehi lwa abaleebelezi omuli ogwo musili. Yaáguheélela aha balimi bunaanka, yaázeenda oluzeendo. ");
INSERT INTO zin_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Obuchilo bwo kugesa emizabibu kabwaahikile, yaásiindika omuzáana woómwe ha balimi abo, abone kwiinaankula omugabo gwoómwe gwe ezabibu kuluga omu musili gwoómwe. ");
INSERT INTO zin_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Náho, abo balimi baámukwáata ogwo muzáana, bámutéela no kumusúbya engalo zili busa. ");
INSERT INTO zin_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Owo omusili yaámusiíndika omuzáana woómwe oóndi ahali abo balimi. Náwe baámutéela omu mútwe, no kumugookela bwooli. ");
INSERT INTO zin_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yaásiindika omuzáana woómwe oóndi, ogwo náwe, abo balimi baámwíita. Yaasiindikáyo abazáana boómwe abáandi béenzi. Abo balimi baábatéela abahálila abáandi, na abáandi baábéeta. ");
INSERT INTO zin_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Owo musili yaásigalila no omuuntu oómo weénka wo kumusiíndika, omutábani engaanzi. Aha muheleeluko yaamusiindikáyo ahali abo balimi, naagaámba nka nikwo, ‘Ogu ni mutábani waanze, weényini nibamukúza.’ ");
INSERT INTO zin_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Náho, obuchilo óobwo yaáhikile, abo balimi beégaambila nka nikwo, ‘Ogu niwe omuhuunguzi wo ogu musili. Óobu, tumwíite, obuhuunguzi bwoómwe nibuba obwéetu.’ ");
INSERT INTO zin_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Niho baámukwáata, baámwíita, baánaga omutuumbígwe ahéelu yo ogwo musili gwe emizabibu.” ");
INSERT INTO zin_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yeézu yaábabúuza aáti, “Mbwéenu, ogwo kanyina wo omusili we emizabibu alaákola chiíha? Alyéeza na kubéeta abalimi abo, no omusili ogwo, yaáguheélela abaantu abáandi. ");
INSERT INTO zin_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ngási, timukasomaga Amaandiko Matakatíifu agalikugaamba gáti? ‘Ibáale éelyo baayaángile aboómbeki, nilyo lyaahiindukile kuba ibáale igazi lyo oluhazo. ");
INSERT INTO zin_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Omukáma Múungu niwe akozile echigaambo echi, nácho ne cho kusobeza omu méeso géetu.’” ");
INSERT INTO zin_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Abakúlu ba abagabe, abeégesa be ebilagilo bya Musa na abanyaampala ba Abayahudi baaba baásoombookelwa nka nikwo ogwo mugani nigubagaámba boónyini. Niho baáyeenda bamukwáate, náho habwo kuba bakatíina embága ya abaantu, baba baálekaho, baalugáho, baázeenda. ");
INSERT INTO zin_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Niho abakúlu ba abagabe, abeégesa be ebilagilo bya Musa na abanyaampala ba Abayahudi baábasiíndika Abafarisayo bunaanka na abaantu abakuúnzile obutégeki bwo omukáma Herode, bamucheécheéle Yeézu kwiingana na amagaambo goómwe weényini. ");
INSERT INTO zin_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Baamuzaho Yeézu, baámugaambila báti, “Mweégesa, nitusoomboókelwa nka nikwo íiwe oba omuuntu wa mazima. Íiwe tokutíina omuuntu weéna wéena ni ikuzo lyo omuuntu ti kaantu hali íiwe. Nooyegesa omuháanda gwa Múungu aha mazima. Ngási, kwiingana ne ebilagilo byéetu bye Echiyahudi, nitweendélwa kusohoza oluhaambwe ahali Kaizáari? ");
INSERT INTO zin_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tusohoze nali tutasohoza?” Náho Yeézu akasoombookelwa obugóbya bwáabo, yaábagaambila aáti, “Ha bwaáchi nimuleengesa kuuncheécheela? Nimuziindeétele empilya nzileebe.” ");
INSERT INTO zin_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Niho baázimutwaálila, yaábabúuza aáti, “Ensuso yo omuuntu ogu ni izíina elili ahali ezi mpilya ye edináali, ne ebyo oóha?” Baámusubiza baágaamba báti, “Ne bya Kaizáari.” ");
INSERT INTO zin_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yeézu yaábagaambila aáti, “Ebili ebya Kaizáari mumuhe Kaizáari, ne ebya Múungu mubimuhe weényini Múungu.” Bóona baásobelwa bwooli. ");
INSERT INTO zin_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Abasadukayo bunaanka beeza hali Yeézu. Abo Basadukayo baágaamba nka nikwo, okuzooka kwa abáfwiile tikulibaho. Niho baámubúuza nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Íiwe Mweégesa, Musa akatulagila omu bilagilo byoómwe nka nikwo, kábilaaba omuuntu yaáfwa no kusiga entuúmbakazi atamuzaliile omwaana, omulumuna amuhuungule ogwo ntuúmbakazi, amuzaálile abáana ayaafwíile. ");
INSERT INTO zin_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mbwéenu, bakaba baliho abadugu musaanzu be éenda eémo. Owo kubaanza aba yaákuúmpula omukázi, náho yaáfwa acháali atakazéele náze omwaana. ");
INSERT INTO zin_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Omulumuna owa kábili aba yaámuhuungula ogwo ntuúmbakazi, náho náwe aba yaáfwa atakazéele náze omwaana. Káandi ayaákulaatileho ogwo omulumuna owa kásatu náwe biba byaaba bityo nyini. ");
INSERT INTO zin_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bóona abo abadugu no ogwo owa musaanzu bakáfwa obutasiga mwáana weéna wéena wo kuzáala náze ogwo ntuúmbakazi. Aha muheleeluko gwa byóona, ogwo ntuúmbakazi náwe aba yaáfwa. ");
INSERT INTO zin_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ha bwéecho nitusaba otusoomboolele, obuchilo abáfwiile balaázooka, ogwo mukázi aláaba ali muko oóha? Habwo kuba abaséeza bakaba bali musaanzu, na buli oómo akamukuúmpula!” ");
INSERT INTO zin_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeézu yaábagaambila aáti, “Íimwe mwaáhabile, habwo kuba timukugasoombookelwa Amaandiko Matakatíifu no óobu obuzizi bwa Múungu. ");
INSERT INTO zin_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Habwo kuba abáfwiile kabalizóoka, tibalikuumpula nali kukuúmpulwa. Náho baláaba nka bamaléeka bo omu igulu, boónyini tibakuumpula nali kukuúmpulwa. ");
INSERT INTO zin_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na habwe empola yo okuzooka kwa abo abáfwiile, ngási muchaáliga kusoma omu chitabu cha Musa, óokwo Múungu akagaamba kuluga ahali echo chisaka echikaba nichaáka omulilo? Aho, Múungu akamugaambila Musa aáti ‘Íinye níinye Múungu wa Ibrahímu, Izáaka na Yakobo.’ ");
INSERT INTO zin_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Aha amagaambo ago, Múungu ti Múungu wa abáfwiile, weényini ni Múungu wa abo abali mwooyo. Íimwe mwaáhabile bwooli.” ");
INSERT INTO zin_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Obuchilo Yeézu akaba naateekelelána na Abasadukayo, omweégesa oómo we ebilagilo bya Musa náwe aba yaahikaho, yaábihulila éebyo balikweéteekelela. Obuchilo yaáhuliile nka nikwo Yeézu akabasubiza kuzima, náwe aba yaámubúuza aáti, “Kuluga omu bilagilo byóona, echilagilo echili cha mbele kusaaga byóona ni chiíha?” ");
INSERT INTO zin_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yeézu yaámugalulila aáti, “Echa mbele nicho echi, ‘Muhuliilíze íimwe Abaiziraeli! Omukáma Múungu wéetu, niwe Omukáma nyakámo. ");
INSERT INTO zin_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Omweénde Omukáma Múungu waawe aha muganya gwaawe gwóona, aha bwéenze bwaawe bwóona, aha magala gaawe góona, nikwo kugaamba, hali byoona ebili hali íiwe.’ ");
INSERT INTO zin_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ne echilagilo cha kábili nicho echi, ‘Omweénde muzeenzi waawe, nko óokwo olikweéyeenda íiwe nyini.’ Tihaliho echilagilo echíindi echili chikúlu kusaaga ebyo bibili.” ");
INSERT INTO zin_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ogwo mweégesa we ebilagilo yaámugaambila Yeézu aáti, “Waásemeza Mweégesa! Waágaamba amazima nka nikwo Múungu no oómo weénka, táliho oóndi, náho weényini weénka. ");
INSERT INTO zin_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Káandi niinsoomboókelwa nka nikwo neeyeendelwa kumwéenda Múungu aha muganya gwaawe gwóona, aha bwéenze bwaawe bwóona na aha magala gaawe góona, no kumwéenda muzeenzi waawe nko óokwo olikweéyeenda íiwe nyini. Ebyo nibyo ebilagilo bikulu bwooli. Amagaambo aga ni makúlu kugakola kusaaga kusohoza egabo zoóna zóona zo kusiingaalicha ne ebitáambo byóona ebiindi.” ");
INSERT INTO zin_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Obuchilo Yeézu akabona nkokwo, omuuntu ogwo yaásubya aha bweétegeelezi, yaámugaambila aáti, “Íiwe toli hala no obukáma bwa Múungu.” Kulugiilila obuchilo obwo, talabeeleho no omuuntu no óobu oómo óogwo ayaagimile kumubúuza Yeézu amabúuzo agáandi. ");
INSERT INTO zin_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Obuchilo Yeézu akaba naayegesa abaantu omu lugo lwe éenzu ya Múungu, yaábabúuza aáti, “Ha bwaáchi abeégesa be ebilagilo bya Musa nibagaámba nka nikwo Masihi ni mutábani wa Daudi? ");
INSERT INTO zin_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi weényini naayebeembelelelwa no Omwooyo Mutakatíifu, akagaamba nka nikwo, ‘Omukáma Múungu akamugaambila Omukáma waanze, “Yikala olubazu lwaanze lwo obúlyo, kuhika mbate ababisa baawe, iífo ya amagulu gaawe.”’ ");
INSERT INTO zin_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Áaho Daudi weényini naagaámba Masihi no Omukáma woómwe. Ha bwéecho, Masihi yaakaáhicha aáta kuba mutábani woómwe na kunu no Omukáma woómwe káandi?” Abaantu be embága mpáango éezo bakaba nibamuhuliiliza Yeézu aha manulilwa. ");
INSERT INTO zin_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aha meégeso goómwe agáandi, Yeézu akagaamba aáti, “Mweélige na abeégesa be ebilagilo bya Musa. Aba nibeénda kulibata omu nsése kunu bazweele enkaanzu záabo ndeehi, no kweenda kwaángaluchwa ahi ikuzo omu magulizo. ");
INSERT INTO zin_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Káandi boónyini beenda kwiikala omu bitébe bya abakúlu omu masomelo. Na kabalikuba babaangisize omu mazenyi, beenda kwíikala áaho beékeele abatégeki. ");
INSERT INTO zin_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Baba nibazaáya entuúmbakazi ebiintu byáabo. Káandi, aha bugobya nibeekola kuneémbelela esaala ndeehi. Aha chilo cho omuchwaáziiko, aba nibeenaánkula omuchwaáziiko oguli muháango bwooli.” ");
INSERT INTO zin_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yeézu yeékala héehi ne echíibo cho kusoholezamo echigabo omu lubúga lwe nzu ya Múungu. Akaba naaléeba abaantu nibasohoza echigabo omu chíibo echo. Abahíte béenzi bakaba nibasohoza empilya nyíinzi. ");
INSERT INTO zin_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Yéeza entuúmbakazi omuhabi, náwe yaásohoza ehela nche ibili zoónka. ");
INSERT INTO zin_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Obuchilo Yeézu akabona ago, yaábéeta abaheémba boómwe, yaábagaambila aáti, “Mazima butúnu niimbagaambila nka nikwo, ogu mukázi entuúmbakazi no omuhabi, yaásohoza endeengo mpaango kuchila abáandi bóona. ");
INSERT INTO zin_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Niingaámba iínti, habwo kuba abaantu aba bóona, baásohoza ebigabo ebili echinogóka chiche choónka cha amabonwa gáabo méenzi. Náho ogu entuúmbakazi hamo no kuba omuhabi bwooli, yaatamo byóona éebyo alikweésiga omu bulami bwoómwe.” ");
INSERT INTO zin_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Obuchilo Yeézu akaba naaluga omu nzu ya Múungu hamo na abaheémba boómwe, omuheémba woómwe oómo yaámuzila aáti, “Mweégesa, galéebe amabáale maháango aga na amazu maháango aga óokwo galikusobeza!” ");
INSERT INTO zin_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yeézu yaámusubiza aáti, “Noobona amazu maháango aga? Tililisigalilaho ibáale éelyo lilihuungaho aha lugulu ye eliindi, buli límo lilyaákaambulwa!” ");
INSERT INTO zin_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Obuchilo Yeézu akaba ayikéele ahi ibaanga lye Emizeituni, ayolekiile éenzu ya Múungu, Peétero, Yakobo, Yohana na Andrea beeza hali weényini. Baámubúuza obuchilo bakaba bali boónyini boónka, ");
INSERT INTO zin_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nitukusaba otugaambiile, áago olikugaamba galyaabaho iíli? Ni luméenko chi óolwo lulitwooleka nka nikwo ago geéliliza kweésulukiza?” ");
INSERT INTO zin_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Niho Yeézu yaábaanza kubasoomboolela aáti, “Mube méeso, omuuntu weéna wéena ataákwiiza kubabéeha! ");
INSERT INTO zin_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Abaantu béenzi balyéeza ahi izíina lyaanze, nibagaámba nka nikwo, ‘Íinye níinye Masihi!’ Abaantu abo baláaba abalikubéeha abaantu béenzi. ");
INSERT INTO zin_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Obuchilo íimwe kamulihulila empola ne ensumo zi ichúmu, mutatiina. Ago ni lwaampaka gabone kubonwa, náho omuhélo gwe éensi niguba gucháali kuhika. ");
INSERT INTO zin_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Éensi eémo elyaálwaana ne eéndi, obukáma búmo bulaálwaana no obúundi. Nihabaho na amateengeto ge éensi ahaantu bunaanka bunaanka, na halyáaba ne enzala. Ago nigaba nko obutaándikilo bwo obusúungu bwo omukázi óogwo alikweenda kweéchuungula. ");
INSERT INTO zin_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Náho íimwe, mube méeso bwooli. Abaantu balaábatwáala omu matégekelo balaábakona enkoba omu masomelo. Balaábatwáala aha baanaángwa na aha bakáma, ha bwaánze íinye. Obwo bulyáaba obuchilo bwo kwaátula Empola Nzima hali boónyini. ");
INSERT INTO zin_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Empola Nzima ni lwaampaka kwoólekeelelwa ha kubaanza aha baantu ba amahaánga góona. ");
INSERT INTO zin_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Obuchilo abaantu abo nibabakwaáta no kubatwáala omu magoombolola kuloonda kubachwaáziika, mutaákwaagalala áago mulaagaámba. Mugaámbe áago Múungu alaábaha obuchilo óobwo nyini. Ti íimwe nyini áabo mulaagaámba, mazima no Omwooyo Mutakatíifu óogwo ali omuli íimwe niwe alikugaamba. ");
INSERT INTO zin_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Aha buchilo obwo nibiba nka nikwo, omweene wáabo naamukoónga omulumuna ha babisa abone kwiitwa. Káandi iíse alaámukoonga kóonga omwaana, na abáana balaábazaázaana abazéele báabo babone kwíitwa. ");
INSERT INTO zin_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Abaantu bóona nibabatamwa habwo kuba muli abaheémba baanze. Náho, weéna wéena óogwo aleegumisiliza kuhika ihelezo, niwe alichuungulwa na Múungu.” ");
INSERT INTO zin_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nihaba no obuchilo óobwo mulaabona ‘echitamiso cho obusiisaguzi,’ chiimeliile ahaantu ahatakatíifu he éenzu ya Múungu, ahaantu áaho atakweendelwa kuba. Omuuntu weéna wéena óogwo alikusoma amagaambo aga, amanye kuzima ensoonga yaágo. Niho abaantu abali Yudea, beéchize aha kwiílukila omu mabaanga! ");
INSERT INTO zin_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Náwe omuuntu óogwo aliba ahanamile aha luswi, atuúke aze kwiíluka bwaangu, atáza omu nzu kwiimucha ebiintu byoómwe. ");
INSERT INTO zin_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Omuuntu weéna wéena óogwo aláaba ali omu musili, ataákusuba enyuma kwiimucha ebebo yoómwe. ");
INSERT INTO zin_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Náho nimwiilóoko abakázi áabo abeena éenda na áabo baláaba niboóncha abáana báabo omu bilo ebyo! ");
INSERT INTO zin_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mumuneembelele Múungu nka nikwo, ebilo ebyo bitaba obuchilo bwe embého mpaango. ");
INSERT INTO zin_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Amazima, omu bilo ebyo, abaantu balaabona ebyaágalalo biháango. Ebyaágalalo nke ebyo, bichaaliga kubaho kulugiilila obutaándikilo bwe éensi óobu yaázihaangile Múungu kuhicha leélo ezi, na tibilibonwa nakáti. ");
INSERT INTO zin_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Káandi, kaálaaba Omukáma yaakulekíle kuchéesha ebilo ebyo bibe bíche, mbwéenu tihaákuzizile no omuuntu no oómo óogwo ayaakuchizile. Náho kwoónka habwa abatooziibwe na Múungu ebyo bilo bilyaánogolwa. ");
INSERT INTO zin_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Obuchilo obwo, kaálaaba omuuntu weéna weéna naabagaambila nka nikwo, ‘Léeba, Masihi ali aha!’ nali ‘Ali okwo!’ mutamwiíkililiza. ");
INSERT INTO zin_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nibabaho ababáasi be ebisuba na abaantu áabo baláaba nibeeyeta nkokwo ni Masihi. Baláaba nibooleka emanyiso na amahano go kusobeza, kábilaaba nibikuundilana, babone kubahabisa abatooziibwe ba Múungu. ");
INSERT INTO zin_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mbwéenu íimwe, mweélige! Íinye neébeembela kubahana góona.” ");
INSERT INTO zin_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Léeba, obuchilo ebilo ebyo bye ebyaágalalo byaáhiíngwiile, izóoba nilitelwáho ensiimbaazi, okwéezi tikulisohoza káandi omwaanga, ");
INSERT INTO zin_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ne enyenyéezi názo nizigwa ahaansi kuluga omu igulu. Amagala go omu igulu galaázugumisibwa. ");
INSERT INTO zin_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Niho abaantu bóona balaámbona íinye Mutábani wo Omuuntu niinyíza omu bwíile aha magala méenzi ni ikuzo. ");
INSERT INTO zin_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Niimbasiindika bamaléeka baanze babakumiinge abatoózibwa baanze kulugiilila buli hóona, omu nkási zóona ze éensi.” ");
INSERT INTO zin_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yeézu yaázeendelela kugaamba aáti, “Mweéyege kuluga omugani gwo omutini. Obuchilo amatábazi gaágwo gaáyolobile gaátiilého emisebuko na amababi gaáyasize, niho musoombookelwa nka nikwo obuchilo bwe echaanda bweéliliza. ");
INSERT INTO zin_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bityo nyini neemwe, obuchilo nimubona agaákolwa, musoomboókelwe nka nikwo weényini ali héehi, yaáhikile aha lwiizi. ");
INSERT INTO zin_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mazima butúnu niimbagaambila nka nikwo, abaantu bo obu buchilo tibakuhwaho obuchilo amagaambo ago góona gatakeésuululukiize. ");
INSERT INTO zin_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Igulu ne éensi nibihwa, náho amagaambo gaanze tigalihwa nakáti.” ");
INSERT INTO zin_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Náho habwe echilo nali esáaha éezo amagaambo ago galibáho, táliho omuuntu óogwo alikumanya. No óobu bamaléeka bo omu igulu nali Mutábani wa Múungu tibakusoombookelwa, náho Táata weénka. ");
INSERT INTO zin_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ha bwéecho, mwiikale nu méeso, musabe, habwo kuba timukusoombookelwa nka nikwo, obuchilo obwo nibuhika iíli. ");
INSERT INTO zin_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Kwíiza kwo Mutábani wo Omuuntu nikwiingana no omuuntu óogwo alikuzeenda oluzeendo kuluga omu nzu yoómwe. Akabalagila abazáana boómwe baziléebe éenzu. Yaábagabila buli oómo omulimo gwoómwe gwo kukola. Náwe omuleebelezi wa aha chisasi akamulagila nka nikwo, ayikale méeso.” ");
INSERT INTO zin_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yeézu yaázeendelela kugaamba aáti, “Íimwe káandi, mwiikale nu méeso, habwo kuba timukusoombookelwa nka nikwo nyineéka alaásuba iíli. Timukusoombookelwa nka nikwo alaásuba olweébazo, nali echilo itúumbi, nali omu nkoko, nali enchaákala. ");
INSERT INTO zin_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mwiikale nu méeso, no óobu alaabezuumbukizamo ha kwíiza, ataákubasaanga omu túlo. ");
INSERT INTO zin_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Echi chi ndikubagaambila íimwe, niimbagaambila abaantu bóona, babe méeso.” ");
INSERT INTO zin_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bikasigalila ebilo bibili byoónka, chibe echilo chikúlu cha Paásika na amazenyi ge emikaate éezo etatiílwémo ituumbyo. Abakúlu ba abagabe ba Múungu na abeégesa be ebilagilo bya Musa, bakaba nibaloondela omuháanda gwo kumukwáata Yeézu ha bweeseléke, bamuchwaaziike no kumwíita. ");
INSERT INTO zin_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Náho baágaamba báti, “Echa mbele tuleke echilo cha amazenyi chihiingule, niho tumukwáate, abaantu bateéza kuléeta omusaambo.” ");
INSERT INTO zin_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Obuchilo obwo Yeézu akaba ali Betania, omu nzu ya Simoni óogwo akamuchiza obubéembe. Óobu akaba ali aha luhelo naálya, aba yeeza omukázi oómo ayina olwaaba lwi ibáale eliina omuzeeze gwo obukaani buháango bwooli. Omukázi ogwo yaáchenyula omunwa gwo olwaabya, yaámwiitilila Yeézu omu mútwe. ");
INSERT INTO zin_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Abaantu bunaanka áabo bakaba balimo omu nzu éezo, baba baátamwa. Baábaanza kweéhanuuza boónyini boónka báti, “Boózo! Ha bwaáchi omukázi ogu naasíisa amazuta go obukaani buháango aátyo? ");
INSERT INTO zin_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Amazuta aga gaakaáhikize kuguzwa kwe edináali magana asatu, ne empilya éezo zikaázunile abahabi!” Baámudugulumila bwooli ogwo mukázi. ");
INSERT INTO zin_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Náho, Yeézu yaágaamba, “Mumuleke. Ha bwaáchi nimumwaagalaza? Éecho omukázi ogu yaákola hali íinye ne echigaambo chi ikuzo bwooli. ");
INSERT INTO zin_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Abahabi batuula hamo neemwe ebilo byóona. Nimuhicha kubakolela amazima obuchilo bwoóna bwóona óobwo mulaayeénda. Náho, timukuba hamo neenye ebilo byóona. ");
INSERT INTO zin_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Omukázi ogu akozile éecho alikuhicha. Yaáyebeembela kusiiga omubili gwaanze amazuta aga ha kuúndoongeza okuziikwa kwaanze. ");
INSERT INTO zin_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mazima butúnu niimbagaambila nka nikwo, omu nsi zóona, hoóna hóona áaho abaantu baláaba niboolekeelela Empola Nzima, baláaba nibagaámba éecho akakola omukázi ogu, ha kumwiízuka.” ");
INSERT INTO zin_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Niho Yuda Iskariote, oómo omu baheémba abo ikúmi na bábili ba Yeézu, yaázeenda kumukoonga ha bakúlu ba abagabe ba Múungu, abone kuboóleka omuháanda gwo kumukwáata Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Obuchilo bahuliile empola ezo, baánulilwa bwooli, baálagana náze nka nikwo nibamuha empilya. Niho Yuda yaábaanza kuloondela omwáanya muluunzi gwo kumukoonga. ");
INSERT INTO zin_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ne echilo cho kubaanza cha amazenyi ge emikaate éezo etatiílwémo ituumbyo, echilo éecho abaantu bakaba nibatema omutaámbwa gwa Paásika. Abaheémba ba Yeézu baámubúuza báti, “Óobu nooyeénda tuzeénde tukuloongeze nkáhi ahaantu ho kulíila echookulya cha Paásika?” ");
INSERT INTO zin_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Niho Yeézu yaábasiíndika abaheémba bábili, yaábagaambila aáti, “Nimuzeénde omu chikaali. Nimubugana no omukwaáta oómo óogwo asutwiile ensúha ya améenzi, mumukulaatile áaho alikuzeenda. ");
INSERT INTO zin_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Omu nzu éezo alataahamo, muzeénde mumugaambile nyineéka nka nikwo, ‘Omweégesa naakubuúza, “Echiseenge cha abazenyi chili nkáhi, óomwo ndaalya echookulya cha Paásika hamo na abaheémba baanze?” ’ ");
INSERT INTO zin_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Niho naabatwaála omu golofa, naabooleka echiseenge echiháango, nimusaánga haáliilwe. Mutuloongeze omwo, tulye echookulya cha Paásika.” ");
INSERT INTO zin_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Abaheémba abo baalugáho, baázeenda omu chikaali cha Yeruzaléemu. Baásaanga góona gali nka nikwo Yeézu akabagaambila, baáloonza echookulya cha Paásika. ");
INSERT INTO zin_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Obuchilo káhaabeele olweébazo, Yeézu yaáhika omu nzu ezo hamo na abaheémba boómwe abo ikúmi na bábili. ");
INSERT INTO zin_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Obuchilo bakaba nibalya, Yeézu yaágaamba aáti, “Mazima butúnu niimbagaambila, oómo wáanyu óogwo alikulya hamo neenye aha, alaánkoonga.” ");
INSERT INTO zin_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Abaheémba boómwe baábaanza kuzuzubalilwa. Buli oómo yaámubúuza Yeézu, “Mazima tíwe íinye?” ");
INSERT INTO zin_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yeézu yaábagaambila aáti, “No oómo omuli íimwe ikúmi na bábili, óogwo alikukoza omukaate hamo neenye aha chisaabo. ");
INSERT INTO zin_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Íinye Mutábani wo Omuuntu, niinyítwa nko óokwo eyaandikilwe omu Maandiko Matakatíifu. Náho neelóoko omuuntu óogwo alaánkoonga. Yakabeele kuzima hali weényini hachili tiyaákuzeelwe!” ");
INSERT INTO zin_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Obuchilo bakaba nibalya, Yeézu yeemucha omukaate, yaásiima Múungu. Yaágumenyula, yaábaha abaheémba boómwe, yaágaamba aáti, “Mwaanaánkule, mulye, ogu nigwo omubili gwaanze.” ");
INSERT INTO zin_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Káyaamazile kukola aátyo yeemucha echikóombe che evíini, yaásiima Múungu, yaábaha, baányweelelana bóona kuluga omuli echo chikóombe. ");
INSERT INTO zin_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yaábagaambila aáti, “Ezi niyo enságama yaanze éezo elikusíinza endagano ya Múungu na abaantu boómwe, enságama éezo elikuseeseka habwa abaantu béenzi. ");
INSERT INTO zin_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mazima butúnu niimbagaambila nka nikwo, tiínchisubiile kunywa káandi evíini ye emizabibu kuhika ahali echo chilo chi ndizinyweeláho evíini ye ensoonga eénsha omu bukáma bwa Múungu.” ");
INSERT INTO zin_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Niho baázina oluzina lwo kumusiingiza Múungu. Obuchilo baámazile kuzina, baalugáho, baázeenda omu ibaanga lye Emizeituni. ");
INSERT INTO zin_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Obuchilo bakaba bali omu muháanda, Yeézu yaábagaambila abaheémba boómwe aáti, “Mwéena íimwe nimuunyiluka omu itúumbi lya leélo. Nigaba nka nikwo Múungu agaambile omu Maandiko Matakatíifu nka nikwo, ‘Ndyaátéela omulíisa, názo entaama zilaábuungeela.’ ");
INSERT INTO zin_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Náho íinye obuchilo óobwo ndiba naázweelwe, ndyaábeebeembelela kuzeenda Galiláaya.” ");
INSERT INTO zin_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Niho Peétero yaámugaambila aáti, “No óobu bilaaba bazeenzi baanze bóona balaákunagilana, íinye tiínkukunagilana.” ");
INSERT INTO zin_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeézu yaámugaambila aáti, “Mazima butúnu niinkugaambila, omu chilo echi cha leélo, enkoókolomi echáali kukoókoloma entúlo ibili, noóba waányaangile entúlo isatu.” ");
INSERT INTO zin_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Náho Peétero yaáguma kukomeenteleza aáti, “Nóobwo kufwa, ni lwaampaka iínfwe hamo neewe, tiíndi wa kukwáanga íiwe nakáti!” Nábo abaheémba bóona bazeenzíbe baágaamba bátyo nyini. ");
INSERT INTO zin_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Niho baáhika omu musili óogwo ogulikwéetwa Getisemane. Yeézu yaábagaambila abaheémba boómwe aáti, “Mmuuntegamilile aha, obuchilo íinye kaandikusaba.” ");
INSERT INTO zin_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yeemucha Peétero, Yakobo na Yohana, yaázeenda nábo hala kache, yaábaanza kuzululukilwa no kuzolelwa bwooli. ");
INSERT INTO zin_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yaábagaambila aáti, “Omwooyo gwaanze gwiina entíimba bwooli kuhicha nóobu kufwa! Muundiindiilile aha, mubuchiíse hamo neenye.” ");
INSERT INTO zin_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yeézu yeelilaho nka aho kache, yáagwa ahaansi buzuúma. Yaásaba aáti, “Kábilaaba nibikuundilana, ntahiingula obuchilo bwo lwaágalalo olu.” ");
INSERT INTO zin_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na yaágaamba aáti, “Abba, Táata, hali íiwe góona gakwiíle. Niinkusába onyihileho echikóombe éecho cho olwaágalalo. Bitaba nko óokwo íinye ndikweendaho, náho ohikiílize obweenzi bwaawe.” ");
INSERT INTO zin_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Obuchilo yaásubile aha baheémba boómwe básatu baliinya, yaábasaanga bali omu túlo. Yaámugaambila Peétero, “Simoni, oli omu túlo? Waálemwa kwiikala méeso hamo neenye no óobu ahi isáaha límo?” ");
INSERT INTO zin_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Niho yaábagaambila aáti, “Mwiikale nu méeso no kusaba Múungu, mutaákwiiza mukaleengesibwa. Omwooyo nigweénda kweégumisiliza ebileengeso, náho omubili tigwíina amagala.” ");
INSERT INTO zin_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Káandi Yeézu yaalugáho, yaázeenda kuneémbelela ha lubazu, yaásubiilila kuneémbelela amagaambo ago nyini. ");
INSERT INTO zin_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Obuchilo yaásubile entúlo ya kábili, yaábasaanga abaheémba boómwe bali omu túlo, habwo kuba améeso gáabo gakaba galemeeliilwe endoólo. Káyaabeele yaábapaámpwiile, tibalabeele ne cho kumugalulila. ");
INSERT INTO zin_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yeézu yaáluga káandi kusaba entúlo ya kásatu, yaábagaambila aáti, “Ha bwaáchi mucháali muchihuniile no kuhuúmula? Byaáhika. Omwáanya gwe ebyaágalalo byaanze, gwaáhika. Óobu íinye Mutábani wo Omuuntu nze kukobezibwa omu ngalo ze enkola bíbi. ");
INSERT INTO zin_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mwiimuke, tuzeénde. Léeba! Enkoonga yaanze yeéliliza!” ");
INSERT INTO zin_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Obuchilo óobwo Yeézu akaba acháali naahoóyela amagaambo ago, ahonyini Yuda, oómo omuli abo ikúmi na bábili, yaáhika hamo ne embága mpaango ya abaantu, áabo bakwáasile embáadi ne engoligo. Abaantu abo bakaluga aha bakúlu ba abagabe, abeégesa be ebilagilo bya Musa na abanyaampala ba Abayahudi. ");
INSERT INTO zin_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda ogwo enkoonga wa Yeézu, akaba yaabamanyisize abo baantu emanyiso. Akaba abagaambiile aáti, “Omuuntu óogwo ndaanyweégela, niwe ogwo nyini. Mumutwáale kuzima ha kumweémanya.” ");
INSERT INTO zin_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Obuchilo Yuda yaáhikile aho, yaázeenda gúmo ahali Yeézu, yaágaamba aáti, “Mweégesa!” Niho yaámunyweégela. ");
INSERT INTO zin_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Abaantu abo baámukwáata Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Niho, oómo wa áabo abaabeele bali hamo na Yeézu, asopoololamo olubaadi lwoómwe, alumutéeza no kumuchwa okutwi omuhálila wo omugabe omukúlu. ");
INSERT INTO zin_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yeézu yaábagaambila abaantu abo aáti, “Óobu sii, ha kwiiza kuunkwáata kunu mukwaasile embáadi ne engoligo, ngási, nimuleeba nka nikwo íinye ndi omunyagiilizi? ");
INSERT INTO zin_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Buli chilo nkaba ndi hamo neemwe, niinyegesa omu lubúga lwe éenzu ya Múungu, na timulaleengesize kuunkwáata. Náho aga góona gakozilwe kubona áago gaáyaandikilwe omu Maandiko Matakatíifu, gahikiilizwe.” ");
INSERT INTO zin_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Niho abaheémba boómwe bóona baámusigaho, beéluka. ");
INSERT INTO zin_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hakaba heena omusígazi oómo óogwo atazweéle chiintu náho isuúka lyoónka, akaba naamukulaatila Yeézu. Náwe bamukwáata, ");
INSERT INTO zin_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","náho, weényini yaábepulusuka, yaásiga isuúka lyoómwe, yeeluka ali busa. ");
INSERT INTO zin_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Niho abaantu áabo baámutwáala Yeézu aha mugabe mukúlu wa Múungu. Baákoba áaho bóona abakúlu ba abagabe, abanyaampala ba Abayahudi na abeégesa be ebilagilo bya Musa. ");
INSERT INTO zin_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Náwe Peétero yaaba naamukulaatila Yeézu kulugilila hala. Yaázeenda, yaátaaha omugati omu lubuga lwo omugabe mukúlu. Yeékala omwo hamo na abaleebelezi, yaaba naayota echikoome. ");
INSERT INTO zin_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Abakúlu ba abagabe ni Itégekelo likúlu lyóona baábaanza kuloondela ebyeéteelelekezo byo kumulegelela Yeézu, babone kumuchwaáziika no kumwíita. Náho, tibalabeele nibabonesa ebyeéteelelekezo byoóna byóona éebyo ebilikugasa. ");
INSERT INTO zin_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Abaantu béenzi bakaba nibasohoza ebyeéteelelekezo bye ebisuba kumulégelela Yeézu, náho ebyeéteelelekezo byáabo tibilabeele nibikuundilana. ");
INSERT INTO zin_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Niho, abaantu abáandi bunaanka baáyemeelela, baásohoza buulubona bwe ebisuba nka nikwo, ");
INSERT INTO zin_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Íichwe nyini tukamuhulila omuuntu ogu naagaámba nka nikwo, ‘Íinye niinkaambula éenzu ya Múungu ezi éezo abaantu baáyoombekile ne engalo. Káandi, niinyoombeka eéndi aha bilo bísatu kwoónka. Éenzu éezo etakwoómbekwa ne engalo za abaantu.’ ” ");
INSERT INTO zin_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","No óobu bityo, buulubona bwáabo tibulakuundileene. ");
INSERT INTO zin_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Niho omugabe mukúlu yaáyemeelela ahagáti yáabo, yaámubúuza Yeézu aáti, “Ngási, tozila cho kusubya no óobu echigaambo choóna chóona habwa ago gi balikukulegelela?” ");
INSERT INTO zin_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Náho Yeézu ayisiza chee, talasubize chigaambo choóna chóona. Omugabe mukúlu yaázeendelela kumubúuza aáti, “Ngási, íiwe oli Masihi, Mutábani wa Múungu owi ikuzo?” ");
INSERT INTO zin_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeézu yaásubya aáti, “Íinye níinye. Neemwe mulyaámbona íinye Mutábani wo Omuuntu nnyikeele olubazu lwo obúlyo lwa Múungu owo obuzizi, naayiza omu bwíile bwo olugulu.” ");
INSERT INTO zin_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Niho omugabe mukúlu kuteemula ebizwáalo byoómwe, yaágaamba aáti, “Ni baalubona chi káandi áabo tuchaáyeenda? ");
INSERT INTO zin_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwaáchihulila íimwe nyini nkokwo yaálogota Múungu! Bityo íimwe nimugaámba muta?” Baámusubiza báti, “Chimugasize kwiitwa.” ");
INSERT INTO zin_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Niho abáandi baábaanza kumuchwéela amachwaánta, kumuzibika omu méeso no kumutéela enfune, kunu nibamugaambila báti, “Gaamba obubáasi, noóha óogwo ayaákuteela?” Nábo abaleebelezi áabo bakaba baliho aho, nábo baámutéela. ");
INSERT INTO zin_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Obuchilo obwo bwóona, Peétero akaba ali omu lubuga, aheéfo ye echiseenge áaho Yeézu akaba naabuúzwa. Yéeza omuzaánakazi oómo kuluga omuli áabo abazaánakazi bo omugabe omukúlu. ");
INSERT INTO zin_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yaámubona Peétero naayota omulilo, yaámunoonkolela améeso. Yaámugaambila aáti, “Neewe nyini obeele oli hamo no ogwo Omunyanazaréeti, Yeézu.” ");
INSERT INTO zin_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Náho Peétero yaáyaanga, naasubya aáti, “Ago go olikugaamba, íinye tiínkugasoombookelwa, no obuche bwa akáti!” Yaázeenda aha mulyáango gwo olugo. Akaziingo ako nyini, enkoókolomi ekoókoloma. ");
INSERT INTO zin_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Omuzaánakazi ogwo aba yaámubona káandi Peétero, abaanza kubagaambila abaantu áabo abeémeeliile aho aáti, “Omuuntu ogu náwe ali hamo nábo.” ");
INSERT INTO zin_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Náho, Peétero yaáyaanga káandi. Haalabaho akáanya kache, abaantu áabo beémeeliile aho, baámugaambila Peétero báti, “Mazima íiwe oli hamo nábo, habwo kuba neewe nyini oli omunya Galiláaya.” ");
INSERT INTO zin_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Náho, Peétero akabaanza kweécheena no kulahila aáti, “Omuuntu óogwo mulikugaamba, íinye tiínkumumanya!” ");
INSERT INTO zin_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ahonyini kwoónka, enkoókolomi yaákoókoloma entúlo ya kábili. Obuchilo obwo, Peétero yeézuka echigaambo cha Yeézu éecho akamugaambila aáti, “Enkoókolomi etakakoókolomile entúlo ya kábili, noóba waányogile entúlo isatu.” Obuchilo Peétero akateekuza ago, yaálila. ");
INSERT INTO zin_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Obuchilo kábwaachíile kwoónka, Itégekelo likúlu lyóona, éelyo nilyo likaba lili lya abakúlu ba abagabe, abanyaampala ba Abayahudi, na abeégesa be ebilagilo bya Musa, baátéela omukobo, baákola omweétegeko. Baámuboha Yeézu, baámutwáala aha mwaanaángwa we Echirúumi óogwo akaba naayétwa Pilato. ");
INSERT INTO zin_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato yaámubúuza Yeézu aáti, “Íiwe oli omukáma wa Abayahudi?” Yeézu yaámugalulila aáti, “Níiwe óogwo olikugaamba.” ");
INSERT INTO zin_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Abakúlu ba abagabe bakaba nibamulégelela Yeézu nka nikwo akozile ebikolwa bíinzi. ");
INSERT INTO zin_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato yaámubúuza káandi, yaámuzila aáti, “Tokusubya chigaambo? Léeba óokwo balikukulegelela íiwe ebilegelelo bíinzi.” ");
INSERT INTO zin_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Náho Yeézu talamugaluliile choóna chóona. Niho Pilato yaásobelwa. ");
INSERT INTO zin_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aha mazenyi ga Paásika, Pilato akaba ayina obuteéka bwo kubakomoololela embóhe eémo, éezo baamuseégile abaantu. ");
INSERT INTO zin_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Obuchilo obwo omu ibóhelo akaba alimo omuuntu oómo naayétwa Baraba hamo na abaantu abáandi áabo bakakola obugome no obwíisi aha bugome bwáabo. ");
INSERT INTO zin_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Embága ya abaantu beeza hali Pilato, baábaanza kumusaba abakomoololele embóhe eémo, nko óokwo yaámanyiile kukola. ");
INSERT INTO zin_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato yaábabúuza aáti, “Ngási, nimweénda mbakomoololele omukáma wa Abayahudi?” ");
INSERT INTO zin_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Akagaamba aátyo habwo kuba akamanya nka nikwo abakúlu ba abagabe baámutwáala Yeézu hali weényini habwi ichubi lyáabo kwoónka. ");
INSERT INTO zin_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Náho abakúlu ba abagabe basuunikile embága ya abaantu ezo, nka nikwo bamusabe Pilato abakomoololele Baraba, ataákubakomoololela Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato yaábabúuza káandi aáti, “Mbwéenu, nimweénda mmukoléchi omuuntu ogu óogwo mulikugaamba no omukáma wa Abayahudi?” ");
INSERT INTO zin_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Abaantu bóona baáhámuka aha yoombo káandi, baágaamba báti, “Abaámbwe aha musalaba!” ");
INSERT INTO zin_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato yaábabúuza aáti, “Ngási, yaákola chiheno chi nka nikwo abaámbwe aha musalaba?” Náho boónyini baáyoongela kuhooyooka báti, “Abaámbwe! Abaámbwe aha musalaba!” ");
INSERT INTO zin_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato akaba naayeénda kuzinuliza embága ya abaantu, bityo yaábakomoololela Baraba. Yaálagila abalwaanila ngoma boómwe bamutéele enkoba Yeézu. Niho yaábalagila bamutwáale, bamubaámbe aha musalaba. ");
INSERT INTO zin_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Abalwaanila ngoma abo baámutwáala Yeézu omu chikaali cho omwaanaángwa Pilato no kwéeta abalwaanila ngoma bóona bazeenzi báabo. ");
INSERT INTO zin_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Baámuzwéeka Yeézu enkaanzu yi ibala lye ezaambalau elyo obukáma. Baáyogosa omukáko gwa amáhwa, baámuzwéeka aha mútwe. ");
INSERT INTO zin_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Baábaanza kumulamya ahi igayo báti, “Nookasíinge, mukáma wa Abayahudi!” ");
INSERT INTO zin_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Baámutéela ha mútwe no olusekeyáanda, no kumuchwéela amachwaánta, baámuteélela ebizwi kumulámya aha kumugaya. ");
INSERT INTO zin_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Obuchilo baámazile kumulogota, baámuzúula echo chizwáalo che ezaambalau, no kumuzwéeka káandi emyéenda yoómwe. Baámusohoza ahéelu, baázeenda kumubáamba aha musalaba. ");
INSERT INTO zin_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Omu muháanda, abalwaanila ngoma abo baábugana no omuuntu óogwo akaba naahiingula omu muzihwa kuluga omu musili, izíina lyoómwe Simoni, akaba ali omunya Kurene. Omuuntu ogwo akaba ali iíse wa Alekisanda na Rufoni. Niho baámuhatika kusutula omusalaba gwa Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Baámutwáala Yeézu áaho ahalikwéetwa Goligoota. Izíina éeli liina ensoonga eéti, “Oluhaanga lwo Omútwe.” ");
INSERT INTO zin_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Baámuha Yeézu evíini éezo ekaba etulaniilwe no omubázi, náho weényini yaáyaanga kunywa. ");
INSERT INTO zin_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Niho baámubaamba aha musalaba, no kubagana ebizwáalo byoómwe aha kubyeéseza olweeso lwi ibaando kulamula oóha alaatwáala myéenda chi. ");
INSERT INTO zin_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Obuchilo baámubaambile ha musalaba, ekaba eli esáaha isatu enchaákala. ");
INSERT INTO zin_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aha musalaba bakataho amaandiko ge ntaambala yoómwe, gakaba nigagaámba gáti, “ogu no omukáma wa abayahudi.” ");
INSERT INTO zin_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bakaba baliho abaantu bábili abaabeele bali abanyagiilizi. Niho abalwaanila ngoma baábabaamba aha misalaba héehi na Yeézu, oómo olubazu lwo obúlyo no oóndi olubazu lwo obumoso.  ");
INSERT INTO zin_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Niho Amaandiko Matakatíifu gaáhikilizwe áago galikugaamba gáti, “Akabalwa hamo na abakola biheno.” ");
INSERT INTO zin_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Abaantu abaabeele nibalaba aho, bakaba nibamulogota kunu nibazugumisa emitwe yáabo nibagaámba báti, “Ahaa! Íiwe okagaamba nka nikwo noohicha kuzikaambula éenzu ya Múungu no kuzoómbeka káandi aha bilo bísatu, ");
INSERT INTO zin_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","óobu mbwéenu oyechuungule weénka! Otuúke kuluga aha musalaba aho!” ");
INSERT INTO zin_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na abakúlu ba abagabe na abeégesa be ebilagilo bya Musa bóona hamo, baámulogota ha kweégaambila báti, “Akachuúngula abáandi, náho tiyaákuhicha kweéchuungula weényini! ");
INSERT INTO zin_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ngási weényini tíwe Masihi, Omukáma wa Abaiziraeli? Óobu tuléebe atuúke kuluga aha musalaba, tubone kumwiíkiliza!” No óobu abaantu bali, áabo bakababaamba ha misalaba hamo náwe, nábo baámuzuma. ");
INSERT INTO zin_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","No kubaandiza esáaha mukáaga nyemisana kuhika esáaha mweenda, yaaba nsiimbaazi omu nsi yóona. ");
INSERT INTO zin_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Káyaahikile esáaha mweenda, Yeézu yaáyaambaza iláka liháango yaágaamba aáti, “Eloi, Eloi! Láma sabakithani?” Ensoonga yaáho ne eéti, “Múungu waanze, Múungu waanze! Ha bwaáchi waánnagilana?” ");
INSERT INTO zin_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abaantu bunaanka áabo bakaba beémeeliile aho, obuchilo bahuliile Yeézu naagaámba ago, baágaamba báti, “Boózo muhuliliize, naamweéta Eliya.” ");
INSERT INTO zin_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Omuuntu oómo yeeluka bwaangu, yeeza yeemucha ikoongo, yaáliizuza evíini esaankameele, yaákomela aha lusekeyáanda lula. Yaámuha Yeézu nka nikwo aánywe. Omuuntu ogwo yaámuzila aáti, “Muleke tuléebe kaálaaba Eliya naayiza kumutúucha kuluga aho aha musalaba!” ");
INSERT INTO zin_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yeézu yaáyaambaza iláka liháango, yaáfwa. ");
INSERT INTO zin_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ichiíngilizo éelyo likaba lili omu nzu ahatakatíifu he éenzu ya Múungu lyaabalaalukámo enkási ibili kuluga olugulu kuhika ahaansi. ");
INSERT INTO zin_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mukúlu wa abalwaanila ngoma óogwo akaba ayemeeliile omu méeso ga Yeézu, obuchilo káyaabweene nka nikwo Yeézu naáfwa, yaágaamba aáti, “Amazima omuuntu ogu akaba ali Mutábani wa Múungu!” ");
INSERT INTO zin_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bakaba baliho abakázi abaabeele nibaléeba habwa hala. Omuli abo akaba aliho Mariamu omunya Magidala, Salome na Mariamu nyina wa Yakobo omulumuna na Yose. ");
INSERT INTO zin_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Abakázi abo bakaba bamukulaatiile no kumuheéleza Yeézu obuchilo akaba ali omu nsi ya Galiláaya. Bakaba baliho na abakázi abáandi béenzi áabo bakazeenda hamo náwe omuli Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Obuchilo yaáhikile olweébazo, habwo kuba echilo echo chikaba chili echilo cho kweéloonza habwe Endaálikizo, ");
INSERT INTO zin_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","yéeza omuuntu óogwo akaba ayétwa Yozéfu, omunya Arimatea. Akaba ali owi isima bwooli omu Itégekelo likúlu lya Abayahudi, na akaba naakweetegeza okwíiza kwo obukáma bwa Múungu. Óogwo yaázeenda hali Pilato bwo obugimi kumusaba amukuúndile azeénde kwiimucha omutúumbi gwa Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato yaásobelwa káyaahuliile nka nikwo, Yeézu yaámazile kufwa! Yaámweeta mukúlu wa abalwaanila ngoma abone kumumanyisa, kábilaaba na amazima nka nikwo Yeézu yaáfwiile. ");
INSERT INTO zin_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Obuchilo omukúlu wa abalwaanila ngoma yaásiinzile nka nikwo Yeézu yaáfwa, Pilato yaámukuúndila Yozéfu agutwáale omutúumbi. ");
INSERT INTO zin_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Niho Yozéfu náwe yaágula isáanda lye empilya nyíinzi. Yaázeenda aha musalaba aho, yaágutúucha ahaansi omutúumbi gwa Yeézu, yaáguziingilila ni isáanda. Yaziika omutúumbi ogwo omu mbi éezo ekaba esumile omu luchili, yaáhiliingisa ibáale liháango no kulizibikiliza aha mulyáango gwe eémbi. ");
INSERT INTO zin_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariamu omunya Magidala na Mariamu nyina wa Yose baáhabóna áaho yaáziikilwe. ");
INSERT INTO zin_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Obuchilo echilo che Endaálikizo káchahiíngwiile, Mariamu omunya Magidala, Salome na Mariamu nyina wa Yakobo, baágula amazuta áago agakanuunkilila kuzima, bazeénde bagusiíge omutúumbi gwa Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Echilo cha aha bwooyo enchaákala, omulucheelelélwa, baázeenda aha mbi ya Yeézu. ");
INSERT INTO zin_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Obuchilo bakaba bali omu muháanda, baábaanza kweébuuza báti, “Óobu, noóha óogwo alaatuhiliingisizaho ibáale elyo aha mulyáango gwe eémbi?” ");
INSERT INTO zin_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Náho obuchilo kábaahikile, baábona ibáale elyo lyaáhiliingisiibwe, lili aha lubazu, na likaba lili liháango bwooli. ");
INSERT INTO zin_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bataaha omu mbi, beétimwa kubona omusígazi oómo óogwo akaba azweele enkaanzu ndeehi elikwéela pee. Ayikéele aha lubazu lwo obúlyo lwe eémbi. ");
INSERT INTO zin_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Náwe yaábagaambila aáti, “Mutaákweetimwa. Niinsoomboókelwa nka nikwo nimumuloónda Yeézu Omunyanazaréeti, óogwo ayaabáambilwe aha musalaba. Yaázoolwa, taliho aha! Muléebe áaho bamulyaámikile. ");
INSERT INTO zin_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Óobu nimuzeénde, mubagaambile abaheémba boómwe, muno muno Peétero, nka nikwo Yeézu naabeebeembelela kuzeenda Galiláaya. Okwo nikwo áaho mulaamubona nko óokwo yaábagaambiile.” ");
INSERT INTO zin_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Obuchilo bahuliile bátyo, baábaanza kuzuguma aha butíini no kusobelwa. Baásohola ahéelu, beéluka kuluga omu mbi omwo. Tibalamugaambiile omuuntu weéna wéena, habwo kuba bakatíina.  ");
INSERT INTO zin_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Obuchilo Yeézu yaázookile omulucheelelélwa echilo cha aha bwooyo, owa mbele kumweésuululukiza akaba ali Mariamu omunya Magidala, óogwo akaba amwiihileho amazimu musaanzu. ");
INSERT INTO zin_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariamu omunya Magidala yaázeenda, yaábagaambila abaabeele bali hamo na Yeézu, no obuchilo óobwo bakaba nibalila no kwaalama. ");
INSERT INTO zin_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Náho obuchilo bahuliile nka nikwo yaámubona Yeézu ali mwooyo, tibalekiliize. ");
INSERT INTO zin_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Echilo echo nyini, Yeézu yaábesuululikiza bábili omu baheémba boómwe. Abaheémba abo bakaba bali omu muháanda, bakaba nibazeénda omu nsaambo. Baásiingwa kumumanya, habwo kuba akaba ayina ensuso eéndi. ");
INSERT INTO zin_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Obuchilo bamusoómboókiilwe, baásuba kubasoomboolela bazeenzi báabo, náho abaheémba abo tibalekiliize. ");
INSERT INTO zin_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ha muheleeluko, Yeézu yaábesuululikiza abaheémba boómwe ikúmi no oómo, obuchilo bakaba bali hamo, nibalya. Yaábakaama habwo kulemeela kwe emiganya yáabo, habwo kuba bakáanga kwiikiliza amagaambo ga bazeenzi báabo, áabo abamubwéene Yeézu obuchilo yaázookile omu bafwiile. ");
INSERT INTO zin_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Niho yaábagaambila aáti, “Nimuzeénde omu nsi zóona, muboólekeelele abaantu bóona, Empola zaanze Nzima. ");
INSERT INTO zin_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Omuuntu weéna wéena óogwo aleekiliza no kubatizwa, alaáchuúngulwa. Náho, omuuntu weéna wéena óogwo alaáyaanga kwiikiliza, alaáchwaaziikwa. ");
INSERT INTO zin_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Abaantu áabo abaleekiliza, nibakola emanyiso, kusohoza amazimu aha baantu habwi izíina lyaanze no kugaamba aha lulími lúsha. ");
INSERT INTO zin_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nibakwaáta enzóka kwe emikono, nali kunywa echiintu choóna chóona éecho chilikwiíta, tichilibakola chiintu. Nibaba nibabataho emikono yáabo aha balwéele, nábo nibabona kuchila.” ");
INSERT INTO zin_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Obuchilo Omukáma Yeézu káyaamazile kuhooya nábo, Múungu yaámutwáala, yaálelema kuza omu igulu. Yeékala olubazu lwo obúlyo lwa Múungu. ");
INSERT INTO zin_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Abaheémba boómwe abo baalugáho aho. Baázeenda kwoólekeelela Empola Nzima hoóna hóona. Omukáma Yeézu akaba naabaha amagala go kukola emanyiso. Bityo nikwo akaba naasuúmba amagaambo ago kuba na ga mazima.");
INSERT INTO zin_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Owi isima Teofiilo, abaantu béenzi beégumisiliize kwaandika aha buteéka amagaambo áago gakabaho omuli íichwe. ");
INSERT INTO zin_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Amagaambo ago tukagaambilwa na abaantu áabo yaábeesuululukiize amagaambo ago nyini habwa améeso gáabo kuluga aha bubaandizo bwe emilimo ya Yeézu, na abaantu abo nibo bakaba nibasuúgaanisa empola za Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Neenye káandi, nnyetegeeliíze amagaambo ago góona kulugiilila aha bubaandizo. Naábona kuzima nkwaandikile, kuba ");
INSERT INTO zin_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","íiwe neewe omanye mazima amagaambo áago okeégeswa. ");
INSERT INTO zin_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herode obuchilo akaba ali omukáma we éensi ya Yudea, akaba aliho omugabe oómo, izíina lyoómwe Zakaria, we embága yo obugabe ya Abiya. Mukazíwe náwe akaba ali owo olugaanda lwo omugabe Haruni, izíina lyoómwe Elizabeti. ");
INSERT INTO zin_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bóona bábili bakaba bali abagololoke omu méeso go Omukáma Múungu. Bakaba beekomya ebilagilo byoómwe byóona, omu kubigomookela hatéena amabála goóna góona. ");
INSERT INTO zin_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bakaba batazeéle omwaana, habwo kuba Elizabeti akaba ali omuguumba, na bakaba baákokweele bwooli. ");
INSERT INTO zin_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Chilo chimo, lukaba luli olubo lwe embága ya Zakaria kukola emilimo ya abagabe omu méeso ga Múungu. ");
INSERT INTO zin_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kwiingana no obuteéka bwo obugabe, Zakaria akatoozibwa kuza omu nzu yo Omukáma Múungu, amwoóteze omwo obubáani. ");
INSERT INTO zin_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zakaria obuchilo yaataahilemo kwoóteza obubáani, abaantu béenzi bakaba bakobile ahéelu, abalikusaba Múungu. ");
INSERT INTO zin_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Entúlo eémo, Zakaria yaásuululukilwa na maléeka wo Omukáma Múungu. Maléeka ogwo, yaáyemeelela olubazu lwo obúlyo lwi itaámbilo lyo kwoóteza obubáani. ");
INSERT INTO zin_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria obuchilo káyaamubwéene, yeétimwa. Yaátíina bwooli. ");
INSERT INTO zin_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Náho maléeka ogwo yaámugaambila aáti, “Íiwe Zakaria, otatiina! Aga áago waásaba Múungu, yaágahulila. Mukaawe Elizabeti alaakuzaalila omwaana wo obukwaáta, olyamwéeta Yohana. ");
INSERT INTO zin_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Omwaana ogwo niwe alileetelela mube na amanulilwa bwooli. Abaantu béenzi balaánulilwa kuzaalwa kwoómwe. ");
INSERT INTO zin_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Naába mukúlu omu méeso go Omukáma Múungu. Atanywa evíini nali choóna chóona éecho chilikutamiiza. Aleezuzwa no Omwooyo Mutakatíifu, nóobu achili omuunda ya nyina. ");
INSERT INTO zin_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Alaasubya abaantu béenzi ba Iziraeli aha Mukáma Múungu wáabo. ");
INSERT INTO zin_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Alaámweebeembelela Omukáma, aloónze abaantu kumunyegeza, ayina amagala no Omwooyo gwa Múungu nko óokwo akaba ayinágo Eliya. Alyaábakwaátanisa abazéele na abáana báabo, na abazilwa alyaábakola babe na amasala go kumugomookela Múungu.” ");
INSERT INTO zin_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria yaámubúuza aáti, “Íinye na mukaanze twaákokweele! Ndaachimanyaho iínta echigaambo echo?” ");
INSERT INTO zin_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maléeka yaágaamba aáti, “Níinye Gaburieli, óogwo ndikweémeelela omu méeso ga Múungu. Ansiindikile kunu, nnyize kukugaambila amagaambo ago amazima. ");
INSERT INTO zin_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Náho tokakuunzile amagaambo gaanze, áago mazima galaákolwa. Mbwéenu, kubaandiza óobu noóba omutita. Tolihicha kugaamba kuhicha kuhika obuchilo óobwo amagaambo ago galikolwa.” ");
INSERT INTO zin_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mbwéenu, abaantu abaabeele nibamuliindilila Zakaria, baásobelwa habwo kubona óokwo yeéliilwe omwo omu nzu ya Múungu. ");
INSERT INTO zin_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Káyaalugilémo, talahikize kuhooya nábo. Baámanya abweene ameezaho omu nzu ya Múungu. Akaba naabooleka ne ngalo, náwe yaázeendelela kuba omutita. ");
INSERT INTO zin_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ebilo byoómwe byo kuheéleza omu nzu ya Múungu obuchilo byaáhwéele, yaázeenda omúka. ");
INSERT INTO zin_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aheezile, mukazíwe Elizabeti yeemucha éenda. Yaámala améezi ataanu bweeseléke, yaágaamba nka nikwo, ");
INSERT INTO zin_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Omukáma Múungu niwe yaánkolela aátyo no kuúmpweela. Yaanyiháho ensóni omu baantu.” ");
INSERT INTO zin_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Éenda ezo obuchilo yaáhikize améezi mukáaga, Múungu yaásiindika maléeka Gaburieli omu muzihwa gwi izíina lilikwéetwa Nazaréeti omu nsi ya Galiláaya, ");
INSERT INTO zin_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ahíke aha muhalakazi oómo óogwo akaba atakamumanyile omuséeza, izíina lyoómwe Mariamu. Omuhalákazi ogwo akaba asuumbikilwe no omukwaáta oómo, izíina lyoómwe Yozéfu, wo olugaanda lwo omukáma Daudi. ");
INSERT INTO zin_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maléeka ogwo yaázeenda ahali Mariamu, yaámugaambila aáti, “Niinkusúula, íiwe oyina omugisa bwooli! Omukáma Múungu ali hamo neewe.” ");
INSERT INTO zin_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Náwe yaázululukilwa bwooli habwa amagaambo ago, yaáteekuza omu muganya, “Echi chisuulo chiina nsoonga chi?” ");
INSERT INTO zin_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Náho maléeka ogwo yaámugaambila aáti, “Íiwe Mariamu, otatiina, Múungu yaákubonesa embabazi. ");
INSERT INTO zin_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Léeba, olaatwáala éenda, olaazáala omwaana wo obukwaáta, olyamwéeta Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Alyáaba mukúlu, alyaáyétwa Mutábani wa Múungu Óogwo Ali Olugulu ya Byóona. Omukáma Múungu alaamuha echitébe chi ikuzo lyo obutégeki bwo omukáma Daudi, iíse enkúlu. ");
INSERT INTO zin_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Alyáaba mukúlu we enzáalwa za Yakobo ebilo byóona. Obukáma boómwe tibulihwa nakáti.” ");
INSERT INTO zin_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariamu yaámubúuza maléeka aáti, “Aga galaákolwa gáta kunu íinye ntakumumanya omuséeza?” ");
INSERT INTO zin_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maléeka yaámugalulila “Omwooyo Mutakatíifu alyaákwiizáho, no obuhicha bwa Múungu Óogwo Ali Olugulu ya Byóona bulyaákusweeka. Bityo, omwaana óogwo olizaála aláaba omutakatíifu na alyaáyétwa Mutábani wa Múungu. ");
INSERT INTO zin_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Léeba! Mudugu waawe Elizabeti, óogwo bakaba bamweéta omuguumba, omu bukeékulu bwoómwe atweele éenda yo omwaana wo obukwaáta. Okwéezi oku no kwa mukáaga. ");
INSERT INTO zin_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ensoonga Múungu tichiliho éecho alikulemwa kukola.” ");
INSERT INTO zin_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariamu yaámusubiza, “Íinye ndi omuzaánakazi wo Omukáma Múungu, bibe hali íinye nko óokwo waágaamba.” Ahonyini, maléeka ogwo yaázeenda. ");
INSERT INTO zin_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Omu nchilo ezo nyini, Mariamu yaáloonza oluzeendo, yaázeenda bwaangu omu muzihwa gúmo omu nsi ya amabaanga ga Yuda. ");
INSERT INTO zin_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yaátaaha omu nzu ya Zakaria, yaámwaángalucha Elizabeti. ");
INSERT INTO zin_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti obuchilo yaáhuliile echisuulo cha Mariamu, omwaana óogwo akaba ali omuunda yoómwe yaáguluka. Ahonyini, Elizabeti yeezuzwa no Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Niho yaágaamba ahi iláka liháango aáti, “Omu bakázi bóona, íiwe níiwe ófuuhilwe! No omwaana óogwo olaazáala, náwe ayina omugisa. ");
INSERT INTO zin_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Íinye ndi oóha, nóobu nyina wo Omukáma wéetu yéeza kuunyaangalucha? ");
INSERT INTO zin_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Obuchilo naáhulila echisuulo chaawe, ahonyini omwaana óogwo ali omuunda yaanze yaáguluka habwa amanulilwa. ");
INSERT INTO zin_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Íiwe ófuuhilwe, habwo kuba weékiliza amagaambo áago Omukáma Múungu yaákugaambila galaákolwa!” ");
INSERT INTO zin_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariamu yaágaamba aáti, “Omuganya gwaanze nigumusíima Omukáma Múungu, ");
INSERT INTO zin_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","no omwooyo gwaanze nigumunulilwa Múungu, Omuchuúnguzi waanze. ");
INSERT INTO zin_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Habwo kuba abubweéne obulemwa bwo omuzaánakazi woómwe. Kuluga óobu abaantu be enzaalwa zóona balyaányéta owo omugisa. ");
INSERT INTO zin_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Múungu owo obuhicha bwóona yaánkolela amahano, ni izíina lyoómwe ne elitakatíifu. ");
INSERT INTO zin_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Naazeendelela kubazilila echiganyizi abaantu be enzaalwa ne enzaalwa áabo abalikumukoondookela. ");
INSERT INTO zin_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Akozile amagaambo mahaango habwa amagala goómwe, abanagile abeene ihagi. ");
INSERT INTO zin_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abagwiisize abakúlu kuluga aha bitébe bi ikuzo lyáabo lyo obutégeki, abafula abeenamwiile. ");
INSERT INTO zin_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Abeena enzala abahaagisize kuzima, abahíte ababiingile engalo zili busa. ");
INSERT INTO zin_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Azunile Abaiziraeli abazáana boómwe, habwo kwiizuka kubazilila echiganyizi. ");
INSERT INTO zin_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nko óokwo yaalagéene na Ibrahímu isíichwe enkúlu ne enzaalwa zoómwe zóona, ebilo byóona.” ");
INSERT INTO zin_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Niho Mariamu yeékala owa Elizabeti améezi asatu, yaámala yaásuba owoómwe. ");
INSERT INTO zin_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Echilo cho kweéchuungula kwa Elizabeti káchaahikile, yaázáala omwaana wo obukwaáta. ");
INSERT INTO zin_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Abatúuzi boómwe na abanyalugaanda, obuchilo baáhuliile okwo Omukáma Múungu yaámuziliile echiganyizi, baánulilwa hamo náze. ");
INSERT INTO zin_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ogwo mwáana, káyaahikize echilo cha munáana, beeza kumusála ikóba, baáyeenda bamuluke izíina lya Zakaria, nke iíse. ");
INSERT INTO zin_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Náho, nyina yaáyaanga, yaágaamba, “Mmahi! Naalukwa izíina Yohana.” ");
INSERT INTO zin_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Baásubya, “Kási! Tihaliho mudugu wéenyu óogwo alikwéetwa izíina elyo!” ");
INSERT INTO zin_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Baámubúuza iíse habwo kumwoóleka ne ngalo, kuba abagaambile izíina éelyo alikweenda kumwéeta omutábani. ");
INSERT INTO zin_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yaábasaba echibaáho, yaáchaandika aáti, “Izíina lyoómwe nilyo Yohana.” Bóona baásobelwa. ");
INSERT INTO zin_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ahonyini akanwa kaákomoololwa, olulími lwaágololoka, yaábaanza kuhooya káandi, yaámukúza Múungu. ");
INSERT INTO zin_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Abatúuzi bóona baátíina bwooli. Echigaambo echo chaakumuuka bwooli omu nsi yóona ya mabaanga ga Yudea. ");
INSERT INTO zin_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bóona áabo bahuliile, baaba nibeebuúza báti, “Omwaana ogwo naába omuuntu wa kazeendele chi?” Bakagaamba bátyo habwo kuba mazima, Omukáma Múungu akaba ali hamo náze. ");
INSERT INTO zin_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakaria iíse wo omwaana ogwo, yeezuzwa Omwooyo Mutakatíifu. Yaásohoza obubáasi nka nikwo, ");
INSERT INTO zin_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Omukáma Múungu wéetu wa Iziraeli akuzibwe, habwo kuba ayizile no kubachuúngula abaantu boómwe. ");
INSERT INTO zin_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atuheéle Omuchuúnguzi owo obuhicha kuluga omu lugaanda lwo omuzáana woómwe Daudi, ");
INSERT INTO zin_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nko óokwo yaabeele agaambile aho kala habwo omuháanda gwa ababáasi boómwe abatakatíifu. ");
INSERT INTO zin_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Akatugaambila nka nikwo, alaátuchuúngula kuluga aha babisa béetu, no kuluga omu ngalo za abo abalikututamwa. ");
INSERT INTO zin_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yaágaamba nka nikwo alaábazilila echiganyizi besiichwe enkúlu, no kwiizuka endagano yoómwe entakatíifu éezo yaalagéene nábo. ");
INSERT INTO zin_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Endagano ezo niyo akamulahilila isíimwe enkúlu Ibrahímu, ");
INSERT INTO zin_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nkokwo atubonesa íichwe, atuchuúngule kuluga omu ngalo za ababisa béetu, tube nitumugomookela obutazila butíini, ");
INSERT INTO zin_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tuli omu kukola amazima omu méeso goómwe omu butakatíifu ebilo byéetu byóona. ");
INSERT INTO zin_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Íiwe mwáana waanze, olyáaba nooyétwa omubáasi wa Múungu Óogwo Ali Olugulu ya Byóona, olyaámwiibeembelela Omukáma, kumuloongeza omuháanda. ");
INSERT INTO zin_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mala olyaábamanyisa abaantu boómwe nka nikwo balichuúngulwa, habwo kuganyilwa ebiheno byáabo, ");
INSERT INTO zin_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kwiingana ne chiganyizi chiháango cha Múungu wéetu. Obuchuúnguzi obwo bulyaátwiizila nko omwaanga gwi izóoba lilikusohola, ");
INSERT INTO zin_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na gulyaábamulikila abali omu nsiimbaazi, abali omu lwaágalalo no obutíini bwo olufu. Alaátweebeembelela, tuzeénde omu muháanda gwo obuhóolo.” ");
INSERT INTO zin_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bityo omwaana ogwo Yohana yaákula, yaábonesa amagala aha Mwooyo Mutakatíifu. Yaázeenda kwíikala omu nsi yo obwoóma, kuhicha obuchilo óobwo yeéyolekile aha Baiziraeli. ");
INSERT INTO zin_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Omu bilo éebyo yaazeelwe Yohana, Kaizáari Augusto akasohoza oluhamo nka nikwo abaantu bóona abali ahaansi yo obutégeki bwoómwe, bazeénde kweéyaandikisa. ");
INSERT INTO zin_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Okweéyaandikisa oku kukaba kuli okwa mbele, omu buchilo Kurenio óobu akaba ali omwaanaángwa we éensi ya Siíria. ");
INSERT INTO zin_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nikwo, abaantu bóona baázeenda kweéyaandikisa, buli baantu omu iboma lyáabo. ");
INSERT INTO zin_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yozéfu náwe akaluga omu iboma lya Nazaréeti omu nsi ya Galiláaya, yaáhanama kuzeenda omu nsi ya Yudea omu muzihwa gwa Betlehemu. Habwo kuba Betlehemu nicho echaalo cha Daudi, na Yozéfu akaba ali owo lugaanda lwoómwe. ");
INSERT INTO zin_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Obuchilo óobwo yaázeenzile kweéyaandikisa akaba ali hamo na Mariamu, óogwo akaba amusuumbikile. Na Mariamu akaba ayine éenda. ");
INSERT INTO zin_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","No omu buchilo obwo bakaba bali aho Betlehemu, omwáanya gwo kuzáala kwo ogwo Mariamu gwaáhika, ");
INSERT INTO zin_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","yaázáala omutábani wo obuzigeezo, yaámusweekelela omu myéenda, yaámubyaámika omu káato ko kunyweésezamo ente. Habwo kuba, tibalabonesize echiseenge omu nzu yo kubyáama abazenyi. ");
INSERT INTO zin_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Omu mbúga ya aho, bakaba balimo abalíisa abaabeele nibeekala omwo nibaléeba ebituungaánwa byáabo omu chilo. ");
INSERT INTO zin_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ahonyini, beesulukizwa na maléeka wo Omukáma. Ni ikuzo lyo Omukáma lyaábamulikila enkási zóona, baázila okweétimwa kuháango bwooli. ");
INSERT INTO zin_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Náho maléeka ogwo yaábagaambila, “Mutatiina! Léeba, niimbamanyisa empola nzima bwooli za amanulilwa maháango ha baantu bóona, ");
INSERT INTO zin_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","kuba leélo eli, omu iboma lyo omukáma Daudi, Omuchuúnguzi yaázáalwa ha bwéenyu. No ogwo Muchuúnguzi niwe Masihi, Omukáma. ");
INSERT INTO zin_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne emanyiso yo kubamanyisa ebyo, niyo ezi: nimusaánga omwaana omucheche asweékeliilwe emyéenda za abacheche, abyaamikilwe omu káato ko kunyweésezamo ente.” ");
INSERT INTO zin_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ahonyini, ahali ogwo maléeka, haabonekanáho ebihuumbi bya abalwaanila ngoma bya bamaléeka bazeenzíbe kuluga omu igulu, baaba nibamukúza Múungu báti, ");
INSERT INTO zin_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Múungu ali omu igulu akuzibwe! No omu nsi, obuhóolo bube ha baantu áabo alikweenda!” ");
INSERT INTO zin_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Abo bamaléeka, kábaabeele baásubileyo omu igulu, abalíisa beégaambila, “Tuzeénde Betlehemu, tubone kuleeba ebyo nka nikwo Omukáma yaátugaambila.” ");
INSERT INTO zin_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nikwo baázeenda nibeéluka, baábasaanga Mariamu na Yozéfu, baámubona mwáana omucheche alyaamile omu káato ko kunyweésezamo ente. ");
INSERT INTO zin_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na kábaabeele baámubweene omwaana ogwo, baábamanyisa abaantu empola zóona zo mwáana, éezo yaábagaambiile ogwo maléeka. ");
INSERT INTO zin_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na bóona abaahuliile áago baagaambíilwe na abo balíisa, baásobelwa bwooli. ");
INSERT INTO zin_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Náho, Mariamu yaágabíika ago góona omu muganya gwoómwe, yaázeendelela kugateékuza. ");
INSERT INTO zin_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kábaabalíile, abalíisa abo baásuba, kunu nibamukúza Múungu, hali byóona éebyo baáhuliile no kubona. Nko óokwo baagaambíilwe na maléeka, nikwo bityo byóona byaábéele. ");
INSERT INTO zin_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Omwaana ogwo Yeézu, obuchilo yaáhicha echilo cha munáana, baámusala ikóba, baámuluka izíina, Yeézu. Nilyo izíina éelyo ogwo maléeka akaba yaámuhéele, obuchilo nyina akaba atakatwéele éenda. ");
INSERT INTO zin_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mbwéenu, kwiingana no óokwo byaabeele nibyeendelwa omu bilagilo bya Musa, ebilo byo kweéyeza kwáabo byaaba byaáhika, Yozéfu na Mariamu baátwáala ogwo mwáana Yeézu okwo Yeruzaléemu, babone kumuhikiiliza ha Mukáma. ");
INSERT INTO zin_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Habwo kuba, chaandikilwe omu bilagilo byo Omukáma nkokwo, “Buli mwáana wo obuzigeezo wo obukwaáta, naayeéndelwa atoózwe kuba omutakatíifu ha Mukáma Múungu.” ");
INSERT INTO zin_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hamo ne ebyo, bakaba nibeénda basohoze echo chitáambo cho kweéyeza, echilikugaambwa chíti omu bilagilo byo Omukáma, “Musohoze echitáambo che ebiiba bibili, nali amáana ábili ge ebiiba.” ");
INSERT INTO zin_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na aho Yeruzaléemu, hakaba haliho omuuntu oómo, izíina lyoómwe ali Simeoni. Náwe akaba ali omugololoke omu méeso ga Múungu, na akaba naamukoondoókela, kunu naaliindilila kuleeba okuchuúngulwa kwa Abaiziraeli. Omwooyo Mutakatíifu akaba ali hamo náze, ");
INSERT INTO zin_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","na akaba yaámanyisizwe no Omwooyo Mutakatíifu nkokwo talifwa, obuchilo atakamubwéene Masihi wo Omukáma. ");
INSERT INTO zin_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na abazéele boómwe kábaamutwéele Yeézu omu nzu ya Múungu, babone kukola nko óokwo ebilagilo bilikubalagila, Omwooyo Mutakatíifu yaámweebeembelela Simeoni nko óokwo ataahemo omwo. ");
INSERT INTO zin_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Aho yaámwaanaankula omu mikonóye ogwo mwáana Yeézu, kunu naamusiingiza Múungu aáti, ");
INSERT INTO zin_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Íiwe Omukáma, mukúlu wa byóona, óobu onkuúndile íinye omuzáana waawe, iínfwe omu buhóolo. Nko óokwo waalagéene, waábihicha, ");
INSERT INTO zin_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","habwo kuba neébonela obuchuúnguzi bwaawe, ");
INSERT INTO zin_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","óobwo waáloongize omu méeso ga abaantu bóona. ");
INSERT INTO zin_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Óobwo buchuúnguzi no omwaanga gwo kwoóleka omuháanda gwaawe abo Abanyamahaánga, káandi abaantu baawe Abaiziraeli nábo babone ikuzo.” ");
INSERT INTO zin_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ebigaambo éebyo yaágaambile Simeoni byaábasobeza iíse na nyina. ");
INSERT INTO zin_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aho Simeoni yaábafuuha, yaámugaambila Mariamu, nyina wo omwaana ogwo aáti, “Léeba! Óogu mwáana, atiilwého na Múungu nkokwo naabagwíisa Abaiziraeli béenzi, mala naabakuza Abaiziraeli abáandi béenzi. Káandi alyáaba emanyiso elyaangwa na abaantu, ");
INSERT INTO zin_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kuhicha ebyaabeele byeéselekile omu miganya yáabo bimanyiike kuba aha bwéelu. Neewe omu muganya gwaawe noosáasa bwooli, nko ochumisilwe no olubaadi.” ");
INSERT INTO zin_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na aho hakaba haliho omubáasi oómo, omukeékulu bwooli, izíina lyoómwe ali Ana, muhala wa Fanwéeli, wo olugaanda lwa Ashéeri. Ogwo Ana akahicha emyáaka musaanzu yoónka ali hamo ne eéba, niho iíba kufwa. ");
INSERT INTO zin_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mala yaaba omukázi akaambwiile kuhicha amakamo ge emyáaka makúmi munáana ne eéna. Akaba asigala omwo nyini omu nzu ya Múungu, kunu naamusaba nyemisana no omu chilo ha chisiibo cho obutalya. ");
INSERT INTO zin_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Omu buchilo óobwo Simeoni naahóoya na Mariamu, Ana yaaba yaáhika aho, yaábaanza kumweésiingiza Múungu, no kugaamba empola zo omwaana ogwo ha baantu bóona abamutegiize nkokwo Múungu alyaáchuúngula Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yozéfu na Mariamu, kábaabeele baámazile kukola ebilagilo byóona byo Omukáma okwo bilikulagila, baásuba omúka omu iboma lya Nazaréeti, omu nsi ya Galiláaya. ");
INSERT INTO zin_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ogwo mwáana yaákula, no kuba na amagala, kunu naayizuzwa amasala no kufuuhwa na Múungu. ");
INSERT INTO zin_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Abazéele ba Yeézu bakaba bazeenda Yeruzaléemu buli mwáaka, omu mazenyi ga Paásika. ");
INSERT INTO zin_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","No obuchilo Yeézu óobu akaba ali omwaana we emyáaka ikúmi ne ibili, baázeenda náze okwo omu mazenyi kwiingana no obuteéka bwáabo. ");
INSERT INTO zin_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","No obuchilo bwe ebyo bilo bikulu kábwaahweele, abo bazéele bo ogwo musígazi Yeézu baba baásuba nibatáaha omúka kuluga okwo omu mazenyi, náho weényini omusígazi aba yaasigalilayo okwo omu chikaali cha Yeruzaléemu. Na abazéele boómwe tibalamanyile echo, ");
INSERT INTO zin_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","náho bakateékuza nkokwo ali hamo na bazeenzíbe áabo baabeele nibasuba hamo omúka. No obuchilo kábaabeele baázeenda oluzeendo lwe echilo chimo, bali omu muháanda, baábaanza kumuloondela omu banyalugaánda na abanywáani báabo. ");
INSERT INTO zin_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Na kábaamubuzilwe, baásuba Yeruzaléemu, kunu nibamuloondela. ");
INSERT INTO zin_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Omu chilo cha kásatu, baámusaanga omu nzu ya Múungu, ayikeele ahagáti ya abeégesa. Akaba naabahuliliza, naababuúza amabúuzo. ");
INSERT INTO zin_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Abaantu bóona abaahuliile nko óokwo yaabele naagaámba, baásobelwa bwooli habwo kweétegéeleza kwoómwe, na habwa akasubize koómwe. ");
INSERT INTO zin_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Abo bazéele boómwe, obuchilo kábaamubwéene, nábo baásobelwa bwooli. Nyina yaámugaambila, “Íiwe mwáana waanze, na aha nsoonga chi! Kutukolela oótyo? Léeba iíso neenye, tubeele twiina okutahwa tahwa bwooli omu kukuloondela!” ");
INSERT INTO zin_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Omwaana náwe yaábasubiza, “Ha bwaáchi mubele nimuundoondela? Timukusoombookelwa nkokwo ni lwaampaka íinye kuba omu nzu ya Táata waanze?” ");
INSERT INTO zin_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Okwo kusubya kwa Yeézu, abo bazéele boómwe tibalasoombookiilwe. ");
INSERT INTO zin_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kábyaahwéele ebyo, yaázeenda nábo omúka, owaabo Nazaréeti, náwe yaaba naabakoondoókela. Ago góona agaabeele nigakolwa, nyina woómwe akaba naagabiíka omu muganya gwoómwe. ");
INSERT INTO zin_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeézu akazeendelela kukula, naayoongela omu masala, yaaba naayeéndwa na Múungu na abaantu. ");
INSERT INTO zin_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Gukaba guli omwáaka gwe ikúmi ne itaanu nka nikwo Kaizáari Tiberio akaba naatégeka muzihwa gwe Echirúumi. Pontio Pilato akaba ali omutégeki wa Yudea na Herode Antipasi akaba ali omukáma we éensi ya Galiláaya. Na Filipo, mweene wáabo Herode akaba ali omukáma wa Iturea na Tulakoniiti. Lisania weényini akaba ali omukáma wa Abileene. ");
INSERT INTO zin_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Obuchilo obwo, Anasi na Kayafa nibo baabeele bali abagabe abakúlu. Mbwéenu, omu buchilo obwo, Yohana omwaana wa Zakaria, akaba ali omu nsi yo obwoóma. Obuchilo akaba ali okwo, yaásoomboolelwa empola kuluga ahali Múungu. ");
INSERT INTO zin_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohana, akaba naazeénda kulabila éensi yóona elikuhelelana no omunóna gwa Yorodáani kunu naayatula empola ezo. Akaba naabagaambila abaantu aáti, “Mazima mutamwe ebiheno byáanyu, mubatizwe, Múungu abone kubaganyila.” ");
INSERT INTO zin_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ago gakahikiilila amagaambo go omubáasi Isaya, nko óokwo gaáyaandikilwe omu chitabu choómwe, nkokwo: “Okwo omu nsi yo obwoóma, heena omuuntu óogwo alikwaambaza ahi iláka liháango: ‘Muguloonze omuháanda gwo Omukáma, mugolole obulabo óobwo alaahiíngula. ");
INSERT INTO zin_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Buli iholoola, lifulilwe. Na buli ibaanga no otubaanga, bifufuúlwe. Emiháanda ezizoongile, zigololwe. Na hóona aheena ameena mache máche, hasemézwe. ");
INSERT INTO zin_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Niho abaantu bóona balaábona obuchuúnguzi bwa Múungu.’” ");
INSERT INTO zin_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Abaantu béenzi bakaba nibamwiízaho Yohana, abone kubabatiza. Náho, yaaba naabagaambila aáti, “Íimwe abo luzáalo lwe enzóka noóha ayaábahana nka nikwo nimuhicha kweéliga echihulumuko cha Múungu éecho echilikwiiza habwo kubatizwa kwoónka? ");
INSERT INTO zin_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mbwéenu, mwooleke ha bikolwa byáanyu nka nikwo mazima mwaálekeliile ebiheno byáanyu na nimumutegeza Múungu! Mutabaánza kuzila nka nikwo Múungu naabeekiliza kamulaaba nimweebona nka nikwo, ‘Isíichwe enkúlu ni Ibrahímu!’ Niimbagaambila nka nikwo, Múungu yaakaáhicha kuhiindula amabáale aga kuba abáana ba Ibrahímu! ");
INSERT INTO zin_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Óobu omuchwaáziiko gwa Múungu ni nke enséenya eli aha bitako bye emiti! Na buli muti ogutakusohoza emisumo mizima, nigunogolwa, no kunagwa omu mulilo!” ");
INSERT INTO zin_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Niho abaantu áabo abaabeele balimo omu chipípi echo, baámubúuza Yohana, “Mbwéenu! Tukole chiíha?” ");
INSERT INTO zin_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yaábasubiza, “Buli ayina amagwáanda ábili, asohoze límo hali óogwo atéenalyo. Na buli ayina echookulya, náwe akole aátyo nyini kwoónka.” ");
INSERT INTO zin_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Abahaámbya nábo, baamwiizáho Yohana, abone kubabatiza. Baámubúuza, “Íiwe Mweégesa, neechwe tukolého túta?” ");
INSERT INTO zin_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Náwe yaábasubiza aáti, “Kamulaatobesa oluhaambwe, mutaákutobesa ensaagiliza kuchila endeengo éezo elikweendelwa.” ");
INSERT INTO zin_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Abalwaanila ngoma nábo baámubúuza, “Neechwe, tuzilého túta?” Náwe, yaábasubiza aáti, “Ataákubáho omuuntu óogwo mulaamwáaka ebiintu byoómwe, nali kumusitaaka aha kumubeéheleza! Náho muhikwe empeéla éezo mulikwaanaankula.” ");
INSERT INTO zin_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Abaantu bóona, bakaba nibeebuúza omu miganya yáabo habwa Yohana, habwo kuba bakaba beena echihika nkokwo hamo weényini niwe Masihi. ");
INSERT INTO zin_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Náho, yaábagaambila bóona, “Íinye, niimbabatiza ha méenzi kwoónka. Náho alyéeza omuuntu óogwo alikuunchíla ha buhicha, tiinkwiílwe no óobu kumusumuululila enkóba ze enkeeto zoómwe! Weényini, niwe óogwo alaábabatiza ha Mwooyo Mutakatíifu, na ha mulilo. ");
INSERT INTO zin_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Óobu akwaasile olutemele omu ngalo zoómwe abone kweesula ebititi kuluga omu ngano. Engano ezo naazisúuga omu chitála choómwe, náho ameelulo alyaágóocha omu mulilo ogutalilaala nakáti!” ");
INSERT INTO zin_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ha magaambo méenzi ago na agáandi, Yohana akaba naahána abaantu abo, ha kubamanyisa Empola Nzima za Múungu. ");
INSERT INTO zin_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Káyaabaliile, Yohana yaámwaatulila omukáma Herode, ha kuba Herode akamukuúmpula Herodia, mukázi wa mweene wáabo. Yohana yaámuchaáhukila ha chigaambo echo, na ha bikolwa bíbi ebíindi byóona éebyo akaba naakola. ");
INSERT INTO zin_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Niho Herode yaáyoongela obubi bwoómwe bwóona, yaaba yaámuchiíngila Yohana omu ibóhelo. ");
INSERT INTO zin_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Obuchilo abaantu bóona bakaba baábatiziibwe na Yohana, náwe Yeézu yaábatizwa. No omu buchilo óobwo Yeézu yaaba naasába, ");
INSERT INTO zin_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","igulu lyaáchiinguka, no Omwooyo Mutakatíifu gwaámuhanaantukila aha lugulu yoómwe ensuso nke echiiba. Omu igulu omwo nyini, haalugamo iláka, lyaágaamba, “Íiwe níiwe Mutábani waanze engaanzi, óogwo nnyesiimaho neewe bwooli!” ");
INSERT INTO zin_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Obuchilo Yeézu naabaánza emilimóye, akaba ayina emyáaka nka makúmi asatu. Abaantu bakaba nibateekuza nkokwo akaba ali mutábani wa Yozéfu. No ogwo Yozéfu, akaba ali mutábani wa Héeli. ");
INSERT INTO zin_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Náwe Héeli, akaba ali mutábani wa Matati. Na Matati, akaba ali mutábani wa Láawi. Na Láawi, akaba ali mutábani wa Meliki. Na Meliki, akaba ali mutábani wa Yana. Na Yana, akaba ali mutábani wa Yozéfu. ");
INSERT INTO zin_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Náwe Yozéfu, akaba ali mutábani wa Matatia. Na Matatia, akaba ali mutábani wa Amosi. Na Amosi, akaba ali mutábani wa Nahumu. Na Nahumu, akaba ali mutábani wa Esili. Na Esili, akaba ali mutábani wa Nagai. ");
INSERT INTO zin_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Náwe Nagai, akaba ali mutábani wa Mati. Na Mati, akaba ali mutábani wa Matatia. Na Matatia, akaba ali mutábani wa Semei. Na Semei, akaba ali mutábani wa Yozéfu. Na Yozéfu, akaba ali mutábani wa Yóda. ");
INSERT INTO zin_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Náwe Yóda, akaba ali mutábani wa Yoanani. Na Yoanani, akaba ali mutábani wa Resa. Na Resa, akaba ali mutábani wa Zerubabeli. Na Zerubabeli, akaba ali mutábani wa Shealitieli. Na Shealitieli, akaba ali mutábani wa Neri. ");
INSERT INTO zin_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Náwe Neri, akaba ali mutábani wa Meliki. Na Meliki, akaba ali mutábani wa Adi. Na Adi, akaba ali mutábani wa Kosamu. Na Kosamu, akaba ali mutábani wa Elimadáamu. Na Elimadáamu, akaba ali mutábani wa Eri. ");
INSERT INTO zin_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Náwe Eri, akaba ali mutábani wa Yoshua. Na Yoshua, akaba ali mutábani wa Eliezéeri. Na Eliezéeri, akaba ali mutábani wa Yorimu. Na Yorimu, akaba ali mutábani wa Matati. Na Matati, akaba ali mutábani wa Láawi. ");
INSERT INTO zin_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Náwe Láawi, akaba ali mutábani wa Simeoni. Na Simeoni, akaba ali mutábani wa Yuda. Na Yuda, akaba ali mutábani wa Yozéfu. Na Yozéfu, akaba ali mutábani wa Yonamu. Na Yonamu, akaba ali mutábani wa Eliakimu. ");
INSERT INTO zin_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Náwe Eliakimu, akaba ali mutábani wa Melea. Na Melea, akaba ali mutábani wa Mena. Na Mena, akaba ali mutábani wa Matata. Na Matata, akaba ali mutábani wa Natani. Na Natani, akaba ali mutábani wa Daudi. ");
INSERT INTO zin_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Náwe Daudi, akaba ali mutábani wa Yese. Na Yese, akaba ali mutábani wa Obedi. Na Obedi, akaba ali mutábani wa Boazi. Na Boazi, akaba ali mutábani wa Salumoni. Na Salumoni, akaba ali mutábani wa Nashoni. ");
INSERT INTO zin_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na Nashoni, akaba ali mutábani wa Aminadabu. Na Aminadabu, akaba ali mutábani wa Aramu. Na Aramu, akaba ali mutábani wa Hezeróoni. Na Hezeróoni, akaba ali mutábani wa Peréesi. Na Peréesi, akaba ali mutábani wa Yuda. ");
INSERT INTO zin_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Náwe Yuda, akaba ali mutábani wa Yakobo. Na Yakobo, akaba ali mutábani wa Izáaka. Na Izáaka, akaba ali mutábani wa Ibrahímu. Na Ibrahímu, akaba ali mutábani wa Téera. Na Téera, akaba ali mutábani wa Nahóori. ");
INSERT INTO zin_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Náwe Nahóori, akaba ali mutábani wa Selugi. Na Selugi, akaba ali mutábani wa Rehu. Na Rehu, akaba ali mutábani wa Pelegi. Na Pelegi, akaba ali mutábani wa Ebéeri. Na Ebéeri, akaba ali mutábani wa Shéela. ");
INSERT INTO zin_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Náwe Shéela, akaba ali mutábani wa Kayinani. Na Kayinani, akaba ali mutábani wa Arfakisáadi. Na Arfakisáadi, akaba ali mutábani wa Shéemu. Na Shéemu, akaba ali mutábani wa Núhu. Na Núhu, akaba ali mutábani wa Laámeki. ");
INSERT INTO zin_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Náwe Laámeki, akaba ali mutábani wa Metuséela. Na Metuséela, akaba ali mutábani wa Enoka. Na Enoka, akaba ali mutábani wa Yaréedi. Na Yaréedi, akaba ali mutábani wa Mahalaléeli. Na Mahalaléeli, akaba ali mutábani wa Kayinani. ");
INSERT INTO zin_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Náwe Kayinani, akaba ali mutábani wa Enosi. Na Enosi, akaba ali mutábani wa Séeti. Na Séeti, akaba ali mutábani wa Adamu. Na Adamu, akaba ali mutábani wa Múungu. ");
INSERT INTO zin_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeézu yaáluga aho aha munóna gwa Yorodáani ayizwíile Omwooyo Mutakatíifu. Akeebeembelelwa no Omwooyo kuhika omu nsi yo obwoóma, ");
INSERT INTO zin_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","yaámala ebilo makúmi aána, akaba naaleengesibwa ni Isitáani. No omu buchilo obwo, talaliile echiintu choóna chóona. Obuchilo káyaamazile ebilo ebyo, enzala ekaba neemuluma. ");
INSERT INTO zin_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Niho elyo Isitáani kumugaambila liti, “Koólaaba íiwe oli Mutábani wa Múungu, lilagile ibáale eli lihiinduke kuba omukaate.” ");
INSERT INTO zin_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeézu yaáligalulila aáti, “Omu Maandiko Amatakatíifu chaandikilwe chíti, ‘Omuuntu tiyaákuhicha kutuungwa ebyookulya byoónka.’” ");
INSERT INTO zin_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kalyaabalíile, Isitáani elyo lyaámutwáala Yeézu ahaantu hali olugulu bwooli, lyaámwoóleka obukáma bwóona bwe éensi ni ikuzo lyaámo ha káanya ako nyini. ");
INSERT INTO zin_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Lyaámugaambila elyo Isitáani, “Obutégeki bwa byóona ebi, naakaákuha, hamo no obugéega bwaámo. Ha kuba byóona ebi, níinye óogwo naáhéelwe, na káandi naakaámuha omuuntu weéna wéena óogwo ndikweenda. ");
INSERT INTO zin_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ha bwéecho, koólaandamya, niinkuha byóona ebyo.” ");
INSERT INTO zin_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeézu yaálisubiza, “Chaandikilwe chíti, ‘Omulámye Omukáma Múungu waawe, omugomookele weényini weénka.’” ");
INSERT INTO zin_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kalyaabalíile Isitáani lyaámutwáala Yeézu Yeruzaléemu, lyaámweemeeleza aha luswi olula bwooli oluli aha nzu ya Múungu, lyaámugaambila, “Koólaaba íiwe oli Mutábani wa Múungu, oyenaguze ahaansi kuluga aha, ");
INSERT INTO zin_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","habwo kuba chaandikilwe, ‘Múungu naalagíla bamaléeka boómwe, babone kukweémanya.’ ");
INSERT INTO zin_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na káandi, ‘Nibakusutula, amagulu gaawe oteéza okeékuumpa ahi ibáale.’” ");
INSERT INTO zin_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yeézu yaálisubiza, “Chaandikilwe chíti, ‘Otamuleengesa Omukáma Múungu waawe.’” ");
INSERT INTO zin_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Obuchilo Isitáani kályaabeele lyaámazile kumuleengesa Yeézu, lyaámuleka kuhicha libone omwáanya ogúundi, gwo kumuleengesa. ");
INSERT INTO zin_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Káyaabaliile, Yeézu yaásuba owáabo Galiláaya, akaba ayina obuhicha bwo Omwooyo Mutakatíifu. Ne empoláze, zikasaámbaala bwooli omu nsi ezo yóona. ");
INSERT INTO zin_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yaázeenda naayegesa abaantu omu masomelo gáabo. Na bóona, baaba nibamukúza. ");
INSERT INTO zin_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Káyaabaliile, yaásuba omúka Nazaréeti, omu muzihwa óogwo yaalezilwe. Na aha chilo che Endaálikizo, nka nikwo yaabele amanyiile, akataaha omu isomelo, yeémuka, yaáyemeelela abone kusoma echigaambo cha Múungu. ");
INSERT INTO zin_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Akahaabwa echitabu cho omubáasi Isaya, yaáchifuúndula, yaáloondela ahaándikilwe, ");
INSERT INTO zin_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Omwooyo gwo Omukáma Múungu, guli hamo neenye, habwo kuba, antoólize kubamanyisa abahabi Empola Nzima. Yaánsiíndika mbone kubamanyisa embóhe, kukomoololwa kwáabo, no kubamanyisa abahume, kubona kuhweeza káandi, na áabo abalikwaágalazibwa, mbachuúngule. ");
INSERT INTO zin_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mbone kuboólekeelela abaantu, omwáaka óogwo Omukáma Múungu alaáyoleka engoonzi zoómwe.” ");
INSERT INTO zin_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Káyaamazile kusoma ebigaambo ebyo, Yeézu yaáfuundikila echitabu, yaámusubiza omuheéleza, mále yeékala. Na abaantu bóona áabo abaabeele bali omu isomelo, bakaba nibamutukuliza ha kumukómela améeso. ");
INSERT INTO zin_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Niho yaábaanza kubagaambila, “Echaandiko éecho mwaáhulila, leélo ezi chaáhikiilizwa omu méeso géenyu.” ");
INSERT INTO zin_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Abaantu bóona baásobelwa bwooli ha bigaambo byoómwe bye embabazi ebyaálugile omu kanwa koómwe, nábo baámugaamba kuzima. Baábaanza kweébuuza, “Ngási, ogu tíwe mutábani wa Yozéfu?” ");
INSERT INTO zin_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeézu yaábagaambila, “Tihéena mwaaga nimuungaambile omugani ogu, ‘Íiwe omulaguzi, oyechíze íiwe nyini. Ensoonga, góona áago tuhuliile áago okozile omu muzihwa gwa Kaperinaumu, ogakole na aha omu muzihwa gwéetu!’ ” ");
INSERT INTO zin_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yeézu yaágaamba, “Mazima butúnu niimbagaambila, taliho omubáasi ayikilizwa omu muzihwa gwoómwe. ");
INSERT INTO zin_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Ha buchilo bwa Eliya, telagwiile enzula emyáaka isatu na améezi mukáaga, kuhicha enzala mpaango yaáteela éensi yóona ya Iziraeli. Na mumanye kuzima nkokwo, bakaba baliho abakázi béenzi abakaambwiile omu nsi, omu buchilo óobwo. ");
INSERT INTO zin_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hamo ne ebyo, Eliya talasiindikilwe hali oómo wáabo. Náho akasiíndikwa ha mukázi oómo akaambwiile wo omuli Zarefáati, omu nsi ya Sidóoni, ahéelu ya Iziraeli! ");
INSERT INTO zin_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“No omu buchilo bwo omubáasi Elísha bityo, bakaba baliho ababéembe béenzi omu nsi ya Iziraeli. Hamo ne ebyo, taliho oómo wáabo óogwo yaáyelizwe. Akachiza Naamani weénka, omuuntu kuluga éensi ya Siíria!” ");
INSERT INTO zin_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Abo bóona áabo abaabeele bakobile omu isomelo elyo, obuchilo kábaahuliile ago magaambo ga Yeézu, baázila echihulumuko bwooli. ");
INSERT INTO zin_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ahonyini baáyemeelela bwaangu aha chiniga, baázeenda nibamusiindika. Baámusohoza ahéelu yo omuzihwa kuhika aha ngolomoko ndeehi yi ibaanga elyoombekilwého aha lugulu áaho iboma lyáabo, babone kumunáguza ahaansi. ");
INSERT INTO zin_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Náho, yaáhiingula ahagáti ye echipípi cha abaantu abo, yaázeenda lwoómwe. ");
INSERT INTO zin_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Káyaabaliile, Yeézu yaalugáho yaázeenda omu iboma lya Kaperinaumu, omu nsi ya Galiláaya. Echilo che Endaálikizo, akataaha omu isomelo, yaábaanza kweégesa abaantu. ");
INSERT INTO zin_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ebyeégeso byoómwe, byaábasobela bwooli, habwo kuba bikaba biina obuzizi. ");
INSERT INTO zin_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","No omu isomelo elyo, akaba alimo omuuntu oómo ayaabeele akwaásilwe ni izimu. Izimu elyo lyaáchula no kuhamuka ahi iláka, ha kugaamba, ");
INSERT INTO zin_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Íiwe Yeézu Omunyanazaréeti, tukatuulanwa chi íiwe neechwe ka nootuloónda? Weeza kutusiingaalicha? Niinkumanya íiwe, nkokwo íiwe níiwe Omutakatíifu ayaatooziibwe na Múungu!” ");
INSERT INTO zin_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeézu akalikáama izimu élyo ha kugaamba, “Buúmba akanwa kaawe! Omulugého ogu muuntu!” Ahonyini, izimu elyo lyaámugwiisa ahaansi ogwo muuntu, omu méeso ga abaantu abo bóona. Mále lyaamulugaho obutamuhutáaza. ");
INSERT INTO zin_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Abaantu bóona, baásobelwa bwooli, beébuuza, “Ni magaambo chi aga? Léeba amazimu, omuuntu ogu yaágazema ha buzizi na amagala nkokwo galugeho aha baantu, ahonyini nigalugaho!” ");
INSERT INTO zin_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nikwo, empola za Yeézu ziba zaásaambaala bwooli omu nsi ezo yóona. ");
INSERT INTO zin_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeézu akalugamo omu isomelo elyo, yaátaaha omu nzu ya Simoni. Omwo, nyinazaala wa Simoni akaba ayina omuswiiza muháango. Baámusaba Yeézu nkokwo amuchize. ");
INSERT INTO zin_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Niho kweémeelela héehi náze, yaágukaama omuswiiza. Ahonyini omuswiiza gwaamulugaho. Niho nyinazaala ogwo, yeemuka ahonyini, yaábaanza kubatóna ebyookulya. ");
INSERT INTO zin_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","No obuchilo izóoba kályaagwiilemo, echilo che Endaálikizo nichihwa, abaantu baámuleétela Yeézu abalwéele báabo bóona aba amalwéele gachiléene. Yeézu akateelaho buli oómo emikono yoómwe, yaábachíza. ");
INSERT INTO zin_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hamo ne ebyo, Yeézu yaábiinga amazimu omu baantu béenzi, gaátéela empámo omu kugaamba, “Íiwe oli Mutábani wa Múungu!” Habwo kuba amazimu áago gakaba nigamumanya nkokwo Yeézu niwe Masihi, yaágakaama no kugaángila gatagaámba gaamba káandi. ");
INSERT INTO zin_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nyeéncha eémo yaaho kábwaachíile, Yeézu akalugaho aho, yaázeenda ahaantu áaho hakaba hatéena abaantu. Echipípi cha abaantu, baaba nibamuloondela no obuchilo baamubweéne, baáyeenda kumwaángila, kuba atabaleka. ");
INSERT INTO zin_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Náho, Yeézu yaábagaambila, “Ni lwaampaka nzeénde káandi omu mizihwa ezíindi, mbone kubamanyisa Empola Nzima yo obukáma bwa Múungu. Habwo kuba, nkatumwa habwe ensoonga ezo nyini.” ");
INSERT INTO zin_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Niho, Yeézu yaázeendelela kweégesa abaantu omu masomelo gáabo omu nsi ya Yudea. ");
INSERT INTO zin_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Echilo chimo, Yeézu akaba ayemeeliile aha ngeégeelo ye enyaanza ya Genezareti, kunu naayegesa abaantu echigaambo cha Múungu. Baaba nibamwiililila, babone kumuhuliiliza, kuhicha baámumigisiliza. ");
INSERT INTO zin_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na aho aha ngeégeelo ye enyaanza, Yeézu akabona amáato ábili. Abategi bakaba bagalekile amáato, habwo kuba bakaba niboóza emitégo yáabo. ");
INSERT INTO zin_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yaáhanama omu bwáato búmo bwaáho, óobwo bukaba buli bwo mwa Simoni, yaámusaba Simoni nka nikwo abwiilizeyo káche obwáato obwo obuziba kuluga aha ngeégéelo ye chaambo. Mále, Yeézu yeékala omu bwáato, yaázeendelela kweégesa abaantu. ");
INSERT INTO zin_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","No obuchilo káyaamazile kweégesa, yaámugaambila Simoni, “Búga obwáato muzeénde obuziba, mutége emitégo zéenyu, muzubule eénfwi.” ");
INSERT INTO zin_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni yaámusubiza, “Íiwe mukáma wéetu, léeba obwíile kucha tuleéle nitukola omulimo gwo kutéga ha kweéyomeleza obutabonesa chiintu! Náho habwo kuba níiwe waángaambila oótyo, niinzitega óobu nyini.” ");
INSERT INTO zin_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ha bwéecho Simoni na bazeenzíbe baázitega emitégo yáabo omu méenzi, baázubula eénfwi nyíinzi bwooli, kuhicha emitégo yáabo yaábaanza kuteemuka. ");
INSERT INTO zin_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kuhicha baáyeleeza emikono kwéeta bazeenzi báabo abaabeele bali omu bwáato obúundi, beéze kubahwéela. Obuchilo kábeezile, béezuza eénfwi amáato ábili, kuhicha bakaba beéliliza no kutubila. ");
INSERT INTO zin_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni, káyaabweene amahano ago, yaáteela ebizwi omu méeso ga Yeézu, yaámugaambila, “Íiwe Mukáma, ondugého íinye, habwo kuba íinye ndi omuheni!” ");
INSERT INTO zin_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni akagaamba ebigaambo ebyo, habwo kuba weényini hamo na bazeenzíbe bóona, bakasobelwa bwooli kubonesa eénfwi nyíinzi éezo baázubwíile. ");
INSERT INTO zin_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobo na Yohana, batábani ba Zebedayo, bakaba nibatéga hamo na Simoni. Ebyo byaábasobela nábo. Yeézu yaámugaambila Simoni aáti, “Otaákutiina! Ha kuba kulugiilila leélo ezi, noóba omutegi wa abaantu.” ");
INSERT INTO zin_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Simoni na bazeenzíbe baásubya amáato aha chaambo, baáleka ebiintu byáabo byóona, baámukulaatíla Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Obuchilo Yeézu akaba ali omu muzihwa gúmo, hakeeza omuuntu oómo ayaabeele ayizwíile amabéembe omubili gwóona. Náwe káyaamubwéene Yeézu, yaázumala omu méeso goómwe, yaáhicha obusóbwe ahaansi, yaámusaba, “Íiwe Mukáma, koólaayeénda, oyine obuhicha bwo kuunyéza.” ");
INSERT INTO zin_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeézu yaágolola omukóno, yaamukoláho, yaámugaambila, “Niinyeénda ochile, oyele!” Ahonyini, obubéembe bwoómwe bwaamulugáho. ");
INSERT INTO zin_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeézu yaámulagila aáti, “Otamugaambila omuuntu weéna wéena éebi! Náho, zeénda oyeyoleke ha mugabe, osohoze echitáambo cho kwoóleka nkokwo waáyézwa, nko óokwo Musa yaalagíile.” ");
INSERT INTO zin_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hamo ne ebyo, empola za Yeézu zaaguma kumanyiika bwooli ha baantu. Bakaba nibamwiízaho ebipípi ne ebipípi, babone kuhuliiliza Ameégeso goómwe, no kuchízwa amalwáala gáabo. ");
INSERT INTO zin_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Náho, Yeézu akaba abaleka no kuzeenda ahaantu hatéena baantu amusabe Múungu. ");
INSERT INTO zin_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Echilo chimo, Yeézu akaba naayegesa abaantu. No omuli abo, bakaba balimo Abafarisayo, hamo na abeégesa be ebilagilo. Abo bakaluga buli mugoongo gwa Galiláaya ne ya Yudea, ne ya Yeruzaléemu. Yeézu akaba ayina obuhicha kuluga ha Mukáma Múungu abone kuchiza abaantu. ");
INSERT INTO zin_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Niho, béeza abakwaáta, bakaba beemukize omuuntu ayaabeele ali enséege, akaba alyaamile aha chitwaálilizi. Bakaba nibeénda kumutaasha omu nzu, babone kumuléeta omu méeso ga Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Náho bakalemwa kubonesa ho kumulabya, habwo kuba hakaba heena embága ya abaantu béenzi beemigisiliize. Niho baálamula kuhanama olwéego baáhika aha luswi lwe éenzu, beemukize omuuntu ogwo. Obuchilo baabeele bali aha lugulu, baáfumula oluswi, baámutuucha ne echitwaálilizi choómwe ahagáti ya abaantu áabo bóona, omu méeso ga Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Obuchilo Yeézu káyaabweene nkokwo abaantu abo bakaba beena okwiikiliza, yaámugaambila, “Munywáani waanze, waáganyiilwe ebiheno byaawe!” ");
INSERT INTO zin_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Abeégesa be ebilagilo na Abafarisayo abo, ahonyini baábaanza kudugulima nibeegaambila, “Noóha ogu? Léeba naagaámba ebigaambo byo kumulogota Múungu? Táliho omuuntu óogwo yaakuhicha kuganyila ebiheno, náho Múungu weénka!” ");
INSERT INTO zin_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Áago bakaba nibateekuza, ahonyini Yeézu yaágamanya, yaábabúuza, “Ha bwaáchi nimuteekuza mútyo omu miganya yáanyu? ");
INSERT INTO zin_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ngási! Ni chiiha echilikuhuhuuka bwooli? Kumugaambila omuuntu, ‘Waáganyiilwe ebiheno byaawe,’ nali kumugaambila, ‘Yemeelela, olibate?’ ");
INSERT INTO zin_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Niinyeénda mumanye kuzima nkokwo, íinye Mutábani wo Omuuntu nheelwe obuzizi bwo kuganyila ebiheno omu nsi.” Mále Yeézu yaámugaambila omuuntu ogwo, “Niinkugaambila, yemeelela! Twaála echitwaálilizi chaawe, ozeénde omúka.” ");
INSERT INTO zin_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ahonyini, omuuntu ogwo yaáyemeelela omu méeso ga abaantu, yeemucha omukeeka gwoómwe óogwo akaba abyaámiile, yaázeenda omúka kunu naamweesiingiza Múungu. ");
INSERT INTO zin_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Abaantu bóona abo, baásobelwa bwooli no kuzila kweéganya. Hamo ne ebyo, bakaba nibamweesiingiza Múungu, nibagaámba, “Kási! Leélo, twaábona ebigaambo byo kusobeza!” ");
INSERT INTO zin_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kagahwéele ago, Yeézu yaalugamo omu nzu, yaábona omuhaámbya oómo, izíina lyoómwe naayétwa Láawi. Náwe Láawi, akaba ayikeele omu kazu koómwe kokutobesezamo oluhaambwe. Aho, Yeézu yaámugaambila aáti, “Onkuláatile!” ");
INSERT INTO zin_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ahonyini, Láawi yaáyemeelela, yaleka byóona, yaábaanza kumukulaatila Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Káyaabaliile, Láawi yaámukolela Yeézu obuzenyi buháango omukáye. Omu nzu omwo, bakaba bakobile abahaámbya béenzi, na abaantu abáandi abaabeele nibalya hamo ha luhelo. ");
INSERT INTO zin_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chaaletelela Abafarisayo, na abeégesa báabo be ebilagilo, kuzeenda kubadugulumila abaheémba ba Yeézu, baágaamba, “Ha bwaáchi nimulya no okunywa hamo na abahaámbya na abaheni abáandi?” ");
INSERT INTO zin_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeézu yaábasubiza, “Abaantu abeene enziingo nzima, tibakugaswa omulaguzi, náho abalwéele nibo abalikugaswa! ");
INSERT INTO zin_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Bityo nyini, Íinye tiíndeezile kwéeta abaantu abagololoke, náho abaheni batamwe ebiheno byáabo no kumutegeza Múungu.” ");
INSERT INTO zin_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Abaantu abo baámugaambila Yeézu, “Abaheémba ba Yohana nibazila echisiibo che ebyookulya entúlo nyíinzi, obuchilo nibamusaba Múungu. Bityo na abaheémba ba Abafarisayo, nábo bakola bátyo nyini. Náho abaheémba baawe, nibazeendelela kulya no okunywa!” ");
INSERT INTO zin_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeézu yaábasubiza, “Obuchilo chisweéla achili hamo na abazenyi boómwe omu bweenga, nimuhicha muta kubakola abazenyi abo babe ne echisiibo cho okulya no okunywa? ");
INSERT INTO zin_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Náho, omu bilo éebyo ebiliíza, chisweéla alyaáyihwaho ahagáti yáabo. Omu bilo ebyo, niho baliba ne echisiibo.” ");
INSERT INTO zin_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yeézu yaábagaambila omugani ogúundi, yaágaamba, “Taliho omuuntu abaziilila echibatulo cho omwéenda omusha aha mwéenda ogukokweele. Habwo kuba, kaálaakola aátyo, naába yaásiisa omwéenda gwoómwe omusha. Hamo ne ebyo, echiláka echo cho omwéenda omusha, tichikukuúndilana no omwéenda omukulu kúlu. ");
INSERT INTO zin_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Na taliho omuuntu ahikize kutamo evíini eénsha omu nfulebe enkulu kúlu. Habwo kuba, kaálaakola aátyo, evíini eénsha neebila, neeyáta embíiko ezo, nayo neeseéseka. Ne embíiko ezo, zítyo nyini názo nizibiíha. ");
INSERT INTO zin_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Náho evíini eénsha, neeyeendelwa eteébwe omu mbíiko ze eémpu eénsha! ");
INSERT INTO zin_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","No omuuntu óogwo amanyiile kunywa evíini ya kala, aba atakulígila evíini eénsha. Agaámba nka nikwo, eya kala niyo nzima.” ");
INSERT INTO zin_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Echilo chimo che Endaálikizo, Yeézu akaba naalaba omu misili ye engano, na abaheémba boómwe baábaanza kuhéenda ebikuumba bye engano, beheéhamo enzuma zaázo kwe engalo balya. ");
INSERT INTO zin_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Niho Abafarisayo abáandi baábabúuza, “Ha bwaáchi nimukola éebyo ebilikwaángilwa ne ebilagilo kukolwa aha chilo che Endaálikizo?” ");
INSERT INTO zin_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeézu yaábagalulila, “Ngási, timukasomile Amaandiko Matakatíifu nka nikwo Daudi yaákozile obuchilo óobwo weényini na bazeenzíbe bakaba beene enzala? ");
INSERT INTO zin_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Weényini akataaha omu nzu ya Múungu, yeehámo emikaate éezo ekaba yaásohwéezwe hali Múungu, yaázilya no kubaha bazeenzíbe. Telakuundiilwe omu bilagilo bya Musa omuuntu kulya emikaate ezo náho abagabe ba Múungu boónka.” ");
INSERT INTO zin_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yeézu yaáyoongela ha kugaamba aáti, “Íinye Omutábani wo Omuuntu, níinye Omukáma we echilo che Endaálikizo.” ");
INSERT INTO zin_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ha chilo echíindi che Endaálikizo, Yeézu akataaha omu isomelo, yaábaanza kweégesa abaantu. Omu isomelo omwo, akaba alimo omuuntu oómo, óogwo omukóno gwoómwe gwo obúlyo gukaba gulagéele. ");
INSERT INTO zin_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Abafarisayo na abeégesa be ebilagilo, bakaba nibamuléeba Yeézu, babone nkokwo alaamuchíza omuuntu ogwo aha chilo che Endaálikizo. Bakaba nibaloondela emiháanda yo kumulégelela. ");
INSERT INTO zin_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Náho, Yeézu akamanya ebiteékuzo byáabo bíbi. Ha bwéecho, yaámugaambila omuuntu owo omukóno ogulagéele, “Iíza, oyemeelele aha ahagáti.” Omuuntu ogwo yeemuka, yaázeenda yeémeelela ahagáti yáabo. ");
INSERT INTO zin_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ahonyini, Yeézu yaábagaambila Abafarisayo na abeégesa be ebilagilo, “Ha bwéecho, mbabúuze amabúuzo! Kwiingana ne ebilagilo bya Musa, ngási ni chiintu chi echiíkililiziibwe kukolwa ha chilo che Endaálikizo, kukola ebizima nali kukola ebíbi? Echilo echo tubuchíze obulami, nali tubusiingaáliche?” ");
INSERT INTO zin_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yeézu yaábatukuliza améeso abaantu áabo bóona. Mále yaámugaambila omuuntu ogwo, “Golola omukóno gwaawe.” Náwe, obuchilo naagugolola, ahonyini gwaáchila. ");
INSERT INTO zin_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nábo Abafarisayo hamo na abeégesa be ebilagilo abo, baaba baásaaya bwooli. Baábaanza kweéhanuuza nka nikwo balaámukolela Yeézu amagaambo mábi. ");
INSERT INTO zin_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Omu bilo ebyo, Yeézu akazeenda kumusaba Múungu omu ibaanga, yaásaba obwíile kucha. ");
INSERT INTO zin_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","No obuchilo nihacha, yaábéeta abaheémba boómwe. Omuli abo yaátooza ikúmi na bábili, yaábaluka izíina, “Entumwa.” Ne entumwa ezo, nibo aba: ");
INSERT INTO zin_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni, óogwo akamuluka izíina lya Peétero, Andrea ali mudugu wa Simoni, Yakobo, Yohana, Filipo, Baritolomayo, ");
INSERT INTO zin_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo, Tomaso, Yakobo, mutábani wa Alfayo, Simoni ayaayesilwe Omuzelóote, ");
INSERT INTO zin_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mutábani wa Yakobo, na Yuda Iskariote, óogwo ayaabalíile akamukóonga ha kumuguza Yeézu aha babisa boómwe. ");
INSERT INTO zin_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeézu yaátuuka kuluga omu ibaanga, hamo na abaheémba boómwe. No obuchilo káyaahikile aha mbúga, yaáyemeelela. Aho, bakakóba abaheémba boómwe ne embága ya abaantu béenzi áabo balugile enkási zóona eza Yudea, ne eza Yeruzaléemu, no kuluga olubazu lwe engeégeelo ye enyaanza ya Tíilo ne ya Sidóoni. Abaantu abo bakéeza aho, kumuhuliiliza Yeézu no kuchizwa amalwáala gáabo. ");
INSERT INTO zin_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","No óobu bóona áabo abaabeele nibaagalazwa na amazimu, yaaba naabachíza. ");
INSERT INTO zin_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Abaantu abo bóona, bakaba nibaleengesa kumukolaho Yeézu, habwo kuba obuhicha bukaba nibumulugaho no kubachíza bóona. ");
INSERT INTO zin_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeézu yaáleeba abaheémba boómwe, yaábagaambila, “Mwiina omugisa íimwe áabo muli abahabi! Habwo kuba íimwe níimwe abaantu bo obukáma bwa Múungu. ");
INSERT INTO zin_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mwiina omugisa íimwe áabo mulikuhulila enzala óobu! Habwo kuba ahaleéza nimuhaágiswa. Mwiina omugisa íimwe áabo mulikuchula óobu! Habwo kuba ahaleéza nimuseka. ");
INSERT INTO zin_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mwiina omugisa íimwe, omu buchilo abaantu balaábatámwa, omu buchilo balyaábachiindika, ha kubazúma, no kubaléga íimwe amagaambo mábi habwo kuba nimuunkulaatila íinye Mutábani wo Omuuntu. ");
INSERT INTO zin_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ha chilo echo, muguluke guluke aha manulilwa, habwo kuba Múungu ababiikiile empeéla mpáango omu igulu. Nábo beeseénkulu báabo baantu, bakaba nibabahenela ababáasi bátyo nyini. ");
INSERT INTO zin_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Náho, nimwiilóoko, íimwe áabo muli abahíte! Habwo kuba mwaáhéelwe okunulilwa kwéenyu. ");
INSERT INTO zin_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nimwiilóoko, íimwe áabo mulikuhaaga óobu! Habwo kuba nimuhulila enzala ahaleéza. Nimwiilóoko, íimwe áabo mulikuseka óobu! Habwo kuba nimuchula aha ntíimba no kwaalama ahaleéza. ");
INSERT INTO zin_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nimwiilóoko, obuchilo abaantu bóona nibabeesiingiza! Habwo kuba beesabo enkúlu, bátyo nyini nikwo bakaba nibabakolela ababáasi be ebisuba.” ");
INSERT INTO zin_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Niimbagaambila íimwe áabo mulikuunhuliiliza, mubeénde ababisa báanyu. Na abaantu áabo abalikubatamwa, íimwe mubakolele ebizima. ");
INSERT INTO zin_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Na abaantu áabo abalikubachéena, mubasabile nka nikwo Múungu abafúuhe. Na áabo abalikubaágalaza, mubasabile hali Múungu. ");
INSERT INTO zin_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Omuuntu kaálaakutéela itama ha kukugaya, muhiindulile ne eliindi. Omuuntu kaálaakwáaka ebebo yaawe, mulekele atwaále no óobu enkaanzu. ");
INSERT INTO zin_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Weéna wéena óogwo alaakusaba echiintu, múhe. Omuuntu kaálaatwáala ebiintu byaawe, otamusaba abikusubize. ");
INSERT INTO zin_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mubakolele abáandi nka nikwo íimwe mulikweenda boónyini babakolele íimwe hanu. ");
INSERT INTO zin_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kimwaakweenda abo boónka abalikubéenda íimwe, nimuba mwaákola bizima chi, byo kuhicha kusiimwa? No óobu abe biheno, nibabeénda abaantu áabo abalikubéenda! ");
INSERT INTO zin_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na kamulaabazuna abo kwoónka, áabo abalikubazuna íimwe, nimuba mwaákola bizima chi, byo kuhicha kusiimwa? Nábo abe ebiheno, bakola bátyo nyini! ");
INSERT INTO zin_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na kamulaabatíiza áabo mulikweétegeza nkokwo nibabasubiza, nimuba mwaákola bizima chi, byo kuhicha kusiimwa? Nábo abe ebiheno, nibabatiza bazeenzi báabo. Habwo kuba nibategeza nkokwo, abo nibabasubiza byóona! ");
INSERT INTO zin_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Náho íimwe, mubeénde ababisa báanyu, mubakolele ebizima. Muboohoze, obutategeza nkokwo nimusubizwa. Nikwo bityo mulaábona obuhite buháango, no okuba abáana ba Múungu Óogwo Ali Olugulu ya Byóona. Habwo kuba, Múungu naabahwéela no óobu áabo abatakumusíima, na abalikukola ebiheno. ");
INSERT INTO zin_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Mube ne echiganyizi aha báandi, nke Isíimwe óokwo ayina echiganyizi omu baantu.” ");
INSERT INTO zin_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mutaákuchwaaziika abáandi, neemwe timukuchwaáziikilwa. Mutaákutuuzila abáandi neemwe tibakubeétuuzila. Mubaganyile abaantu áabo abaabahéniile, niho neemwe mulaáganyilwa. ");
INSERT INTO zin_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mubáhe abáandi ebiintu, niho neemwe mulaahéebwa. Ne ebiintu éebyo mulaahéebwa, nibiba nke ndeengo nzima bwooli. Endeengo yo kwiízula no kusiíndagilwa, no kuzugumiswa ebone kwiízula bwooli, kuhicha no kuseeseka. Habwo kuba, endeengo éezo mulaaleengelaho abáandi, niyo neemwe mulyáaba nimuleengélwaho.” ");
INSERT INTO zin_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeézu yaábagaambila omugani ogu, “Ngási omuhume akwiíle kumwoóleka omuháanda omuhume muzeenzíwe? Amazima, bóona bábili nibagwa omu liina! ");
INSERT INTO zin_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Omuheémba takwiíle kuba omumanyi bwooli kuchila omweégesawe. Náho, kaálikuba yaáyegesiibwe no kumanya byóona, niho alaásusana no omweégesáwe. ");
INSERT INTO zin_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ha bwaáchi nooléeba akatokoozi áako kali omu líiso lya muzeenzi waawe, náho okabula kubona embago éezo eli omu líiso lyaawe? ");
INSERT INTO zin_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Noohichaho oóta kumugaambila muzeenzi waawe, ‘Íiwe mudugu waanze, leka nkwiíhilemo akatokoozi omu líiso lyaawe,’ obuchilo íiwe nyini tokubona embago éezo eli omu líiso lyaawe? Ngóbya we! Obaánze oyihémo embago éezo eli omu líiso lyaawe, niho olaahicha kuleeba kuzima akatokoozi akali omu líiso lya muzeenzi waawe okakeehamo.” ");
INSERT INTO zin_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Habwo kuba, tiguliho omuti omuzima, ogulikulaba amagoomba mábi, na káandi tiguliho omuti omubi, ogulikulabya emisumo mizima. ");
INSERT INTO zin_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Abaantu tibakutabula emisumo yo omutini ha miti ya amáhwa, na káandi tibakutabula emisumo ye emizabibu ha miti ye emisoongóma. Náho buli muti, nigumanyíika aha misumo yaágwo. ");
INSERT INTO zin_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Nikwo bili bityo na aha muuntu we ntúungwa nzima, ebigaambo byoómwe bizima bisohola ne ebiteékuzo bizima éebyo bili omu muganya gwoómwe. Káandi bityo nyini, omuuntu omuzilwa, amagaambo goómwe mábi gasohola ne ebiteékuzo bíbi éebyo bili omu muganya gwoómwe. Habwo kuba, amagaambo áago omuuntu alikugaamba, nigalugiílila omu biteékuzobye ebiizwiile omuli weényini.” ");
INSERT INTO zin_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Na ha bwaáchi nimuunyéta, ‘Omukáma! Omukáma!’ Náho amagaambo áago ndikubagaambila, timukugakola? ");
INSERT INTO zin_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Weéna wéena óogwo alikwíiza ahali íinye, akahuliiliza ebigaambo byaanze no kubiíkiliza, akakola nko óokwo bilikulagila, niimbasoomboólela nkokwo naasusana oóha. ");
INSERT INTO zin_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","“Naasusana no omwoómbeki we éenzu ayaasumile ahaansi bwooli, kuhicha kuhika aha luchili, akoombeka oluhazo aha lugulu yaáho. “No omu buchilo bwe enzula, omunóna gukagweelela, améenzi geézula, gaátéela éenzu ezo. No óobu bityo, tigalazichuúndagwiile, habwo kuba ekaba eyoombekilwe kuzima. ");
INSERT INTO zin_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Náho, weéna wéena óogwo alikuhuliiliza ebigaambo byaanze na takubyeékomya, ogwo, naasusana no omuuntu óogwo yaáyoómbekile éenzu yoómwe aha musényi gwoónka, etéena oluhazo. No obuchilo bwo kugweelela kwo omunóna, améenzi gakazitéela éenzu ezo, entúlo eémo yáagwa ahaansi, ekasiisikala yóona pye!” ");
INSERT INTO zin_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Obuchilo Yeézu káyaamazile kugaamba ebigaambo ebyo byóona ha chipípi cha abaantu, yaázeenda yaátaaha omuli Kaperinaumu. ");
INSERT INTO zin_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Omu muzihwa ogwo, hakaba heena omwiímeelelezi wa abalwaanila ngoma be Echirúumi. Omwiímeelelezi ogwo, akaba ayina omuhálila óogwo akaba ayeenda bwooli. Náho omuhálila ogwo akaba naalwaála, yeéliliize no okufwa. ");
INSERT INTO zin_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ha bwéecho, omwiímeelelezi ogwo, obuchilo káyaahuliile empola za Yeézu, yaásiindika abanyaampala abáandi ba Abayahudi hali Yeézu, baze kumusaba ayize kumuchíza omuhálila woómwe. ");
INSERT INTO zin_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Abanyaampala abo obuchilo kábaahikile hali Yeézu, baámuneémbelela bwooli ha kumugaambila, “Omuuntu ogwo, akwiíle omukolele echigaambo echi, ");
INSERT INTO zin_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","habwo kuba naayeénda éensi yéetu, náwe niwe óogwo ayaatwoómbekiile isomelo lyéetu.” ");
INSERT INTO zin_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Niho Yeézu yaalugáho hamo na abanyaampala abo kuzeenda omúka yo omwiímeelelezi ogwo wa abalwaanila ngoma. No obuchilo Kábaabeele beéliliza aho, omwiímeelelezi ogwo akasiindika abanywáani boómwe, baázeenda ne empola zoómwe hali Yeézu, baámugaambila, “Íiwe Mukáma, otaákwiiyagalaza bwooli, habwo kuba tiinkwiílwe otaahemo omwaánze. ");
INSERT INTO zin_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ne ezo niyo ensoonga naábona káandi nkokwo tiinkwiíle kuhika hali íiwe. Náho ogaámbe echigaambo kwoónka, omuhálila waanze náwe naachila. ");
INSERT INTO zin_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Habwo kuba, neenye ndi ahaansi yo obutégeki bwa abakúlu baanze, nnyina abalwaanila ngoma abali ahaansi yaanze. Kaándikumulagila oómo, ‘Ozeénde’, ahonyini naazeénda. Kaándikumulagila oóndi, ‘Iíza’, náwe ahonyini naayiza. No omuzáana waanze, kaándikumulagila, ‘Kola oóti’, nikwo alaakola.” ");
INSERT INTO zin_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Obuchilo Yeézu káyaahuliile ago, yaámusobelwa bwooli. Yaázeechebuka embága ya abaantu áabo abaabeele nibamukulaatíla, yaábagaambila, “Niimbagaambila nka nikwo, no óobu omu Baiziraeli bóona, tiínkabwéene omuuntu weéna wéena owo kwiikiliza kuháango nko óoku!” ");
INSERT INTO zin_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Áaho abaantu abo abaasiíndikilwe kabaasubile omúka yo omwiímeelelezi ogwo, baásaanga omuhálila yaáchizile. ");
INSERT INTO zin_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ha káanya káche, Yeézu akazeenda omu muzihwa ogulikwéetwa Naíni, akaba ali hamo na abaheémba boómwe, na abaantu abáandi béenzi. ");
INSERT INTO zin_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","No obuchilo káyaabeele yeéliliza iléembo lyo omu iboma, yaábugana na abaantu abaabeele beemukize omutúumbi gwo omukwaáta. Omukwaáta ogwo, akaba niwe ali omwaana nyakámo, hali nyina, óogwo ayaabeele ali entuúmbakazi. Omukázi ogwo, akaba akulaatileene na abaantu béenzi bo omu iboma elyo. ");
INSERT INTO zin_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Obuchilo Omukáma Yeézu káyaamubwéene ogwo mukázi, yaámuzilila echiganyizi, yaámugaambila, “Leka kuchula.” ");
INSERT INTO zin_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yeelila héehi ne echitwaálizi echaabeele chiimuchiízweho omutúumbi, yaachikoláho. Na abaantu áabo abaabeele bachiímukize, beemeelela. Yeézu yaágaamba, “Íiwe musígazi, niinkugaambila, imuka!” ");
INSERT INTO zin_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Óogwo afwíile, ahonyini yeémuka. Yeékala, yaábaanza káandi no kugaamba gaamba. Niho, Yeézu yaámuhikiiliza hali nyina. ");
INSERT INTO zin_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Abaantu abo bóona beétimwa bwooli, baábaanza kumukúza Múungu omu kugaamba, “Omubáasi mukúlu, yeésuulukiza omuli íichwe!” Káandi baágaamba, “Múungu yéeza kuhwéela abaantu boómwe!” ");
INSERT INTO zin_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Empola ze ebyo, zaásaambaala bwooli omuli Yudea yóona, no omu nsi ezíindi zo obutúuzi. ");
INSERT INTO zin_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Obuchilo Yeézu akaba naakola byóona ebyo, abaheémba ba Yohana, baamuleétela empola. ");
INSERT INTO zin_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yohana náwe yaáyéta bábili omuli abo, yaábasiíndika nkokwo bazeénde kumubúuza Omukáma Yeézu, nkokwo, “Ngási, íiwe níiwe Masihi óogwo aleéza, nali tumutegezeyo oóndi?” ");
INSERT INTO zin_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nikwo, obuchilo abo bábili bamuhikileho, baámugaambila, “Yohana Omubatiza yaátusiíndika hali íiwe, tukubuúze, ‘Ngási, íiwe níiwe Masihi óogwo aleéza, nali tumutegezeyo oóndi?’ ” ");
INSERT INTO zin_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ha buchilo obwo nyini, Yeézu akaba naachíza abaantu béenzi amalwáala gáabo. Akaba naachíza káandi abalikwaágalazibwa na amazimu. Akabaha aha ngoonzi amagala abahume béenzi baábona kuleeba. ");
INSERT INTO zin_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Niho, Yeézu kubasubiza, “Muzeénde mumugaambile Yohana góona áago mwaábona, na góona áago mwaáhulila, nka nikwo, abahume, nibahweéza, abalema, nibalibata, aba mabéembe, nibachizwa, enzibamatwi, nibahulila, abáfwiile, nibazoolwa, na abahabi, nibaatulilwa Empola Nzima. ");
INSERT INTO zin_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","“Ayina omugisa, weéna wéena óogwo atéena kutahwa tahwa hali íinye!” ");
INSERT INTO zin_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kábaabeele abo bábili baalugáho aho, Yeézu yaábaanza kubagaambila echipípi cha abaantu empola za Yohana, nkokwo, “Obuchilo mwaáziile omu nsi yo obwoóma kumuleeba Yohana, ngási, mukazeenda kuleeba chiíha? Akasahuunga akalikuchuúndagulwa chúundagulwa no omuyaga? Mmahi! ");
INSERT INTO zin_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mbwéenu, mukazeenda kuleeba chiíha? Ngási omuuntu óogwo azweele ebizwáalo biluunzi? Mmahi! Mumanye, abaantu áabo abazwáala ebizwáalo biluunzi, no obweendeza omu biintu bíinzi éebyo beenábyo, abo baba nibeekala omu mazu maháango ge echikáma! ");
INSERT INTO zin_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Mbwéenu, mukazeenda kuleeba chiíha? Ngási, mukazeenda kuleeba omubáasi? Éego nyini no omubáasi, náho niimbagaambila nka nikwo, Yohana ni mukúlu kusaagáho omubáasi. ");
INSERT INTO zin_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Omu Maandiko Amatakatíifu, niwe óogwo ayaayaandikiilwe éebi, ‘Huliiliza, niinsiindika entumwa yaanze omu méeso gaawe, ogwo alaakweébeembelela omu kukugololela omuháanda.’” ");
INSERT INTO zin_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yeézu yaágaamba káandi, “Neenye niimbagaambila nkokwo, omu baantu bóona áabo abazeelwe na abakázi, takabahoga omuuntu weéna wéena ali mukúlu kusaaga Yohana. No óobu bityo, omuuntu atéena mugaso omu bukáma bwa Múungu, niwe mukúlu kumusaaga weényini.” ");
INSERT INTO zin_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Abo baantu bóona, hamo na abahaámbya, obuchilo baáhuliile amagaambo ago ga Yeézu, baásoombookelwa amazima ga Múungu. Ha kuba abaantu abo nibo áabo ababatiziibwe na Yohana. ");
INSERT INTO zin_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Náho Abafarisayo na abeégesa be ebilagilo, boónyini, bakáanga éebyo Múungu yaabeendíize, habwo kuba bakáanga kubatizwa na Yohana.) ");
INSERT INTO zin_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yeézu yaágaamba káandi, “Abaantu bo obuchilo óobu mbasusanise na chiíha? Béena ntúungwa chi? ");
INSERT INTO zin_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nibasusana na abáana abekeele omu igulizo, nibeehamukila báti, ‘Tukabateelela emiléela, náho kubona nimunegula mahi! Mala twaábazinila enzina ze entíimba, náho timulachuzile!’ ");
INSERT INTO zin_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Habwo kuba, obuchilo Yohana Omubatiza yeézile, akaba atéena obuteéka bwo kulya emikaate, no óobu kunywa evíini. Íimwe nimugaámba nkokwo ayina izimu! ");
INSERT INTO zin_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mbwéenu, íinye Mutábani wo Omuuntu nnyizile, niíndya ebyookulya no kunywa, na abaantu baágaamba nka nikwo, ‘Léeba! Óogu no owo muháanka na káandi no omutamiizi! Na ni munywáani wa abahaámbya na abaheni!’ ");
INSERT INTO zin_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“No óobu bityo, amasala ga Múungu gamanyisibwa kuba ga mazima habwo muháanda gwe ebikolwa bya abaantu boómwe.” ");
INSERT INTO zin_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Omufarisayo oómo, akamwaángisa Yeézu ayize kulya owoómwe. Niho, Yeézu kutaaha omu nzu yo ogwo Mufarisayo, yaaba yeekala kulya ebyookulya. ");
INSERT INTO zin_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","No omu iboma elyo, hakaba heena omukázi oómo óogwo akaba naamanyíika kuba atuula ali omuheni. Omukázi ogwo, obuchilo yaáhuliile nkokwo Yeézu naálya owo Mufarisayo ogwo, yaataahámo omu nzu omwo no olwaabya lwi ibáale eliina omuzeeze gwo obukaani buháango bwooli. ");
INSERT INTO zin_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yaáyemeelela enyuma ya Yeézu, héehi na amagulu goómwe. Yaábaanza kuchula, amaziga goómwe nigatoonyekela aha magulu ga Yeézu. Yaaba naagakubula ni isóke lyoómwe, naamunyweegela no omunwa omu magulu ge, no kugasiiga emizeeze. ");
INSERT INTO zin_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Omufarisayo, obuchilo yaabweene ago, yaáteekuza omu muganyágwe aáti, “Omuuntu ogu, yaakubeele ali omubáasi, yaakumanyíle nkokwo, omukázi ogu alikumukólaho, no omuuntu aliho aáta. Yakaámanyile nkokwo, weényini atuula ali omuheni!” ");
INSERT INTO zin_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeézu yaámugaambila, “Íiwe Simoni, nnyine echigaambo niinyeénda kukugaambila.” Náwe yaámusubiza, “Íiwe Mweégesa, ngaambila.” Niho, Yeézu kugaamba, ");
INSERT INTO zin_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Hakaba heena abaantu bábili, abo bábili bakaba nibatoóngwa empilya na ayaabeele aboóhosize. Oómo wáabo, akaba ayohosize edináali magana ataanu. Muzeenzíwe náwe, akoohoza edináali makúmi ataanu. ");
INSERT INTO zin_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Abo bábili obuchilo baábuzilwe empilya zo kumuliha amabáanza gáabo, óogwo ayaabeele aboóhosize yaábaganyila, bataliha. Mbwéenu, omuli abo bábili, noóha alaayeenda bwooli?” ");
INSERT INTO zin_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni yaámusubiza, “Niinzila nkokwo, neéba ogwo ayaabeele aganyiilwe ibáanza liháango.” Yeézu yaámugaambila, “Waásubya kuzima.” ");
INSERT INTO zin_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aho Yeézu yaámweechebuka omukázi ogwo, yaámugaambila Simoni, “Noomuléeba omukázi ogu? Naátaaha omu nzu yaawe íiwe, náho tiwanyegeza ha kuúmpa améenzi go kunaaba amagulu gaanze. Náho weényini, yaáyoza amagulu gaanze na amaziga goómwe, no kugasusula ni isóke lyoómwe. ");
INSERT INTO zin_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","No obuchilo noonyaangalúcha, tiwaányweegela. Náho weényini, kuluga obuchilo bwóona niintáaha óomu, takalemilwe kunyweégela amagulu gaanze. ");
INSERT INTO zin_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tiwáampa isima ha kuúnsiiga omútwe gwaanze amazuta. Náho weényini, yaánsiiga amagulu gaanze emizeeze. ");
INSERT INTO zin_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ha bwéecho niinkugaambila, habwo kuba engoonzi zo ogwo mukázi ni nyíinzi, neeyoleka nkokwo ebiheno byoómwe bíinzi, byaáganywiilwe. Náho weéna wéena óogwo ayaáganyiilwe ebiheno bíche, ogwo, aba ayina engoonzi nche kwoónka.” ");
INSERT INTO zin_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mala, Yeézu yaámugaambila ogwo mukázi, “Waáganyiilwe ebiheno byaawe.” ");
INSERT INTO zin_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Abazenyi abáandi áabo baabeele beékeele hamo náze aha byookulya, baábaanza kweébuuza, nkokwo, “Noóha ogu, alikuhicha no óobu kuganyila ebiheno?” ");
INSERT INTO zin_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aho Yeézu yaágaambila omukázi ogwo, “Okwiikiliza kwaawe nikwo kwaákuchiza! Ozeénde no obuhóolo.” ");
INSERT INTO zin_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kagahwéele ago, Yeézu akaba naazeénda ha kulabila buli muzihwa ne emigoongo. Akaba naalaánga no kwoólekeelela abaantu Empola Nzima zo obukáma bwa Múungu. Na abaheémba boómwe ikúmi na bábili bakaba bali hamo náze. ");
INSERT INTO zin_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mala káandi akaba akulaatileene na abakázi abáandi áabo yaabeele yaábachílize amalwáala gáabo, no kubeéhaho amazimu. Omuli áabo bakázi, hakaba halimo Mariamu omunya Magidala, óogwo Yeézu yaabele yaamwiihileho amazimu musaanzu. ");
INSERT INTO zin_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Káandi hakaba heena Yoana, ali muka Kuza. Kuza, niwe endiinza ye ebiintu byo omukáma Herode. Akaba aliho Suzana, na abakázi abáandi béenzi. Abakázi áabo, bakaba nibasohoza ebiintu byáabo, ha kumuzuna Yeézu na abaheémba boómwe. ");
INSERT INTO zin_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Echilo chimo, abaantu be emizihwa míinzi, bakaba nibamwiízaho Yeézu, baákoba embága mpáango. Aho yaábagaambila ha mugani ogu, ");
INSERT INTO zin_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hakaba heena omubíbi, ayaabeele azeenzíle kubiba embibóze omu musili. No obuchilo akaba naabiba, ezíindi zikalagala omu muháanda, zaálibatilwa. Ne enyonyi zikeeza zaázilya. ");
INSERT INTO zin_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ezíindi, zikalagala omu itaka liche aha luchili. Kizaamezíle, zaabulwa améenzi, zaáyoma. ");
INSERT INTO zin_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ezíindi, zikalagala omu mahwa. No obuchilo kagakuzile hamo ne emimelo, gakazimigisiliza. ");
INSERT INTO zin_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","“Hakaba heena ezíindi, éezo ezagwíile omu busi buluunzi. No obuchilo kizakomiile, zikaba nizigeswa buli mbíbo igana igana.” Obuchilo Yeézu yaámazile kugaamba ebyo, yaáhamuka ahi iláka omu kugaamba, “Ogwo ayina amatwi, ahuliilize!” ");
INSERT INTO zin_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Abaheémba ba Yeézu bakamubúuza, “Óogu mugani, nooyeénda kugaamba chiíha?” ");
INSERT INTO zin_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yaábasubiza, “Múungu abaheéle íimwe okusoombookelwa amagaambo ge entaahililo zo obukáma bwoómwe. Náho abáandi, aba niimbagaambila ha migani, kuba, ‘No óobu balikuleeba, batakuhwéeza. Na no óobu balikuhulila, bataákusoombookelwa.’ ");
INSERT INTO zin_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Mbwéenu ensoonga yo omugani ogwo, niyo ezi: Embíbo, ne echigaambo cha Múungu. ");
INSERT INTO zin_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ezo embíbo ezalageele héehi no omuháanda nizimanyisa abaantu áabo abalikuchihuliiliza echigaambo cha Múungu. Ahonyini, Isitáani lyéeza no kuchiihamo omu myóoyo yáabo, bataákwiiza kwiikiliza no kuchuúnguka. ");
INSERT INTO zin_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Ne embíbo éezo ezalageele omu itaka elyáaho ahaansi aha luchili, nizimanyisa abaantu áabo abalikuhuliiliza echigaambo cho obukáma bwa Múungu, nibachanaánkula aha manulilwa, nibachiikiliza aha mwáanya muche kwoónka, habwo kuba okwiikiliza kwáabo tikulabeele ne emizi bwooli. Náho obuchilo bwo kuleengesibwa, nibachileka, aha nsoonga nibasusana ne emimelo éezo etéena mizi. ");
INSERT INTO zin_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Ne embíbo éezo ezagwíile omugati ya amáhwa, nizimanyisa abaantu áabo abalikuhulila echigaambo echo. Náho ahaleéza, nibamigisilizwa no okutahwa tahwa ne etuúnku za amabonwa méenzi, ne emizeendele yáabo yo oluhagali omu bulami bwáabo. Ago nigaleetelela okwiikiliza kwáabo kuleka kusohoza emisumo mizima. ");
INSERT INTO zin_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Ne embíbo éezo ezagwíile omu busi buluunzi, nizimanyisa abaantu áabo abalikuhulila echigaambo echo. Kabalikumala kuchihulila, nibachiinaánkula aha muganya muzima, nibazeendelela no kweéyomeleza, kuhicha omwáanya gwóona nibasohoza emisumo.” ");
INSERT INTO zin_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Taliho omuuntu óogwo alikwaacha olumuli, akalusweekelela ne echitukulu, nali akaluta omu buunkululu bwe echitabo. Náho, naaluteleka aha lugulu ya akakóondo, kuba abaantu kabalataahamo, babone kuhwéeza habwo omwaanga. ");
INSERT INTO zin_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Bityo nikwo, byóona ebili bweeseléke óobu, bilyaaleebwa aha bwéelu. Na byóona ebichigiliilwe, bilyaátéebwa aha bwéelu bimanyiike. ");
INSERT INTO zin_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nikwo, ago gi mulikuhulila, mugahuliilize kuzima! Habwo kuba, omuuntu óogwo ayina echiintu, niwe óogwo alaayoongezibwa abe ne ebíindi. Náho, omuuntu atéena chiintu, no óobu ako akache akaálikubona nkokwo ayinako, naayaákwa.” ");
INSERT INTO zin_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Niho, nyina na badugu boómwe Yeézu, baamwiizáho. Náho tibalahikize kumwiililila, habwo kuba abaantu béenzi bakaba nibeemigisiliza. ");
INSERT INTO zin_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Abaantu abáandi baámugaambila Yeézu, “Nyoko na badugu baawe beemeeliile ahéelu, nibeénda kukubóna.” ");
INSERT INTO zin_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yeézu yaábasubiza, “Máaha na badugu baanze nibo bóona áabo abalikuhulila echigaambo cha Múungu no kuchikola.” ");
INSERT INTO zin_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Echilo chimo, Yeézu akahanama omu bwáato bwi itaanga, hamo na abaheémba boómwe. Yaábagaambila, “Twaambuke enyaanza tuze buseeli.” Ha bwéecho, baalugáho. ");
INSERT INTO zin_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Obuchilo bakaba nibazeénda, Yeézu akahunila. Omwo omu nyaanza hakabaho omuyaga gwo omusote. Obwáato obwo bwaábaanza kwiízula améenzi, bóona bakaba bali omu ntaambala. ");
INSERT INTO zin_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Abaheémba abo baamuzaho Yeézu baámupaámpula, baámugaambila, “Mukáma wéetu! Mukáma wéetu! Twaásiingaalika!” Yeézu yeémuka. Aho yaágukaama ogwo muyaga muháango, káandi na amakóonzo, nkokwo bichuleéle. Entúlo eémo, byaáchuléela, haaba echineembe. ");
INSERT INTO zin_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aho, Yeézu yaábabúuza abaheémba boómwe, “Kuli nkáhi okwiikiliza kwéenyu?” Abaheémba abo baátíina bwooli. Hamo ne ebyo, baásobelwa, omu kweébuuza, “Ngási noóha ogu, alikuzema nóobwo omuyaga na amakóonzo, entúlo eémo nibimutiína?” ");
INSERT INTO zin_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yeézu na abaheémba boómwe obuchilo óobwo baayaambukile enyaanza ya Galiláaya, baáhika éensi ya Abageráasi, ha musábuko gwa kábili gwe éensi ya Galiláaya. ");
INSERT INTO zin_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","No obuchilo Yeézu naatuúka aha chaambo, yaamwiizáho omuuntu oómo wo omuzihwa ogwo, ayaabeele ayina amazimu ha bilo bíinzi, akaba atakutúula omúka, náho akaba naatuúla omu kufuluka fuluka no kutúula omu bitúulo. Ebilo byóona éebyo akaba ayikala ali busa obutazwaala myéenda. ");
INSERT INTO zin_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Elyo izimu, likaba limutabaálila entúlo nyíinzi. Abaantu bakaba baleéngesa kumuzuna, ha kumukóma ne eminyololyo ne empiingu. Hamo ne ebyo, akaba naazinogola nogola, mále izimu nilimutwaála ahaantu hatéena baantu. Yeézu káyaabugeene no omuuntu ogwo, yaálizema izimu elyo limulugého ogwo muuntu. Omuuntu obuchilo yeélilila héehi na Yeézu, yaáhamuka ahi iláka liháango. Yáagwa buzuúma omu méeso ga Yeézu, yaámugaambila ahi iláka liháango, “Íiwe Yeézu, Mutábani wa Múungu Óogwo Ali Olugulu ya Byóona, okaatuulanwa chi neenye, ka noondoonda íiwe! Niinkusába, otaanyagalaza!” ");
INSERT INTO zin_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeézu yaámubúuza, “Izíina lyaawe oli oóha?” Náwe yaámusubiza, “Izíina lyaanze, ndi Ensuli.” Akagaamba aátyo habwo kuba amazimu méenzi gakaba gamulího. ");
INSERT INTO zin_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Amazimu ago, gakabaanza kumusaba Yeézu nkokwo atagazema gazeénde kutaaha omu liina elila lyo kuzimu. ");
INSERT INTO zin_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na aho aha ngolomoko ya akabaanga ako, hakaba heena idaale liháango lye empunu éezo zaabéele nizilya. Niho, amazimu ago gaámusaba Yeézu, nkokwo agakuúndile gazeénde gatáahe omuunda yaázo. No obuchilo naagakuundíla, ");
INSERT INTO zin_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","amazimu ago gaamulugáho omuuntu ogwo, gaázeenda geetáasha lwa amáani omu mpunu ezo. Empunu zóona, zeelukila omu nyaanza kuluga aha ngolomoko ézo mpaango, zaáfwéela omu méenzi. ");
INSERT INTO zin_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Abalíisa be empunu ezo, bakaleeba ebyo byóona ebyaagwíile. Niho beéluka, baázeenda omu muzihwa no omu masaambo, nibakumuúcha empola ezi ha baantu. ");
INSERT INTO zin_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mále abaantu baalugáho kuzeenda kuleeba ebigaambo ebyo óokwo bili, baamuhikáho Yeézu. Obuchilo bwo kumuhikáho, baámubona omuuntu óoliinya, ayaabeele ayina amazimu gaámulugilého. Akaba ayikeele héehi na amagulu ga Yeézu, azweele omwéenda, ayina obwéenze bwóona. Abaantu abo baákwáatwa no obutíini. ");
INSERT INTO zin_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Abaantu áabo abaabwéene agagwiile góona, bakaba nibabasoomboólela bazeenzi báabo nkokwo omuuntu ogwo atuungamiilwe amazimu ku yaáchilizwe. ");
INSERT INTO zin_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Abaantu bóona bo omu nsi ya Abageráasi, beétimwa bwooli. Baámusaba Yeézu nkokwo alugeho aho hali boónyini. Nikwo, yaáhanama omu bwáato bwi itaanga yaásuba. ");
INSERT INTO zin_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Omuuntu ogwo, ayaabeele amazimu gaámulugilého, yaámusaba Yeézu nkokwo bazeénde hamo náze. Náho Yeézu yaámusubya, yaámugaambila, ");
INSERT INTO zin_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Osube omúka yaawe, ozeénde kubasoomboolela abaantu áago Múungu yaákukolela.” Niho, omuuntu ogwo yaalugáho aho, yaázeenda naabasoomboólela abaantu ba buli hóona omu muzihwa ogwo ago gi Yeézu yaámukolela. ");
INSERT INTO zin_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Obuchilo Yeézu yaásubile okwo Galiláaya, akanyegezwa ne embága ya abaantu áabo abaabeele nibamutegamilila. ");
INSERT INTO zin_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aho, yéeza omuuntu oómo, izíina lyoómwe Yairo, omweébeembezi wi isomelo. Yairo, yaáteela ebizwi omu méeso ga Yeézu, yaámusaba nkokwo ayize omúka yoómwe, ");
INSERT INTO zin_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","habwo kuba muhalawe nyakámo we emyáaka nke ikúmi ne ebili, akaba ali héehi kufwa. Obuchilo Yeézu akaba naazeénda aho, echipípi echo cha abaantu, chikakulaatilana náwe kunu nibamumigisiliza bwooli. ");
INSERT INTO zin_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","No omu baantu abo, hakaba heena omukázi óogwo akaba ayina endwáala ye emizezi aha myáaka ikúmi ne ibili. No óobu yaabeele yaámazile kuhéela ebiintu byoómwe byóona ha kuliha abafúmu, akaba ataliho no óobu oómo óogwo ayaahikize kumuchíza. ");
INSERT INTO zin_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Niho, omukázi ogwo yéeza kuluga enyuma ya Yeézu, yaamukuumyáho aha lukugilo lwo omwéenda gwoómwe. Ahonyini yaáchila. ");
INSERT INTO zin_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeézu yaábúuza, “Óogwo ayaánkuumyáho, noóha?” Abaantu bóona, bakalahila. Peétero náwe yaámugaambila Yeézu, “Íiwe Mukáma wéetu, na abaantu beenzi baákuzoongolokile nibakumigisiliza!” ");
INSERT INTO zin_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Náho, Yeézu yaágaamba, “Niimmanya heena omuuntu óogwo ayaánkuumyáho, habwo kuba niinyehulila nkokwo obuhicha bwo kuchiza bwaandugáho.” ");
INSERT INTO zin_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Omukázi ogwo, obuchilo káyaabweene nkokwo tayina akazeendele ko kweéseleka káandi, yaamwiizáho Yeézu, naazuguma. Yaáteela ebizwi, yaámugaambila omu méeso ga abaantu abo bóona, ensoonga yo kumukuumyáho, na nkokwo yaáchízwa aha ntúlo eémo. ");
INSERT INTO zin_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeézu yaámugaambila, “Íiwe muhalákazi waanze, okwiikiliza kwaawe nikwo kwaákuchiza. Ozeénde no obuhóolo!” ");
INSERT INTO zin_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Obuchilo Yeézu akaba achaágaamba gaamba ebyo, yéeza omuuntu kuluga omúka owa Yairo, omweébeembezi wi isomelo, yaámugaambila, “Leka kumwaágalaza Omweégesa, habwo kuba muhala waawe yaáfwiile.” ");
INSERT INTO zin_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Náho Yeézu kayaabihuliile ebigaambo ebyo, yaámugaambila Yairo, “Otatiina, yikiliza kwoónka, na muhala waawe naachízwa.” ");
INSERT INTO zin_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","No obuchilo Yeézu naahika omúka owa Yairo, yaábaángila abaantu abáandi kutaahamo omu nzu hamo náze, choónka yaákuundila Peétero, Yohana, Yakobo, iíse na nyina wo omuhalákazi ogwo. ");
INSERT INTO zin_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Abaantu bóona aháka ezo, bakaba nibachúla no kwaalama habwo omuhalákazi ogwo. Náho, Yeézu yaábagaambila, “Muleke kuchula! Takafwíile ogu, choónka ahuniile kwoónka!” ");
INSERT INTO zin_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Abaantu abo baábaanza kumusekeelela ahi igayo, habwo kuba bakaba nibamanya nkokwo ogwo akaba yaáfwíile. ");
INSERT INTO zin_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yeézu, yaákwáata omukóno gwo omuhalákazi ogwo, yaámugaambila, “Íiwe mwáana, imuka!” ");
INSERT INTO zin_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ahonyini, omuhalákazi ogwo, omwooyo gwaamusubamo, yaáyemeelela. Yeézu yaábagaambila nka nikwo, bamuhe ebyookulya. ");
INSERT INTO zin_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Abazéele boómwe baásobelwa bwooli. Náho Yeézu yaábaangila nka nikwo, bataákumugaambila omuuntu weéna wéena ago agáagwa. ");
INSERT INTO zin_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Echilo chimo Yeézu akeeta entumwa zoómwe ikúmi ne ebili. Yaábaha obuzizi no obuhicha bwo kubiinga amazimu góona kuluga ha baantu, no obuzizi bwo kuchíza amalwáala. ");
INSERT INTO zin_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yaábasiíndika, bazeénde kubalaanga abaantu empola zo obukáma bwa Múungu, no okuchiza abalwéele. ");
INSERT INTO zin_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yaábagaambila, “Mutaákwiimucha echiintu omu luzeendo lwéenyu, no óobu enkoni, no óobu ensáho, no óobu echookulya, no óobu empilya, no óobu enkaanzu ibili. ");
INSERT INTO zin_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Ne éenzu yoóna yóona éezo mulaataahámo, mwiikale aho, kuhicha echilo éecho mulilugamo omu mutúulo ogwo. ");
INSERT INTO zin_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Náho omuzihwa gwoóna gwóona óogwo abaantu balaáleka kubeénaankula, mulugého aho, mweekuunkumule enkuungu eli ha amagulu gáanyu. Ha kukola mútyo, neéba emanyiso ye ebiheno byáabo.” ");
INSERT INTO zin_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Niho entumwa ezo, baázeenda nibahiingula omu migoongo. Bakaba niboolekeelela abaantu Empola Nzima, no kuchíza abalwéele ba buli haantu. ");
INSERT INTO zin_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Góona ago gi Yeézu akaba naakola, omukáma Herode akaba naahulila empola zoómwe, zaámuha kutahwa tahwa. Habwo kuba, abaantu abáandi bakaba nibagaamba nka nikwo, Yeézu niwe Yohana Omubatiza ayaázoolwa kuluga omu bafwiile. ");
INSERT INTO zin_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Abáandi, bakaba bagaámba nka nikwo, niwe omubáasi Eliya óogwo ayéeza káandi. Hakaba heena abáandi, áabo bakaba nibagaámba nkokwo, oómo wo omuli abo babáasi ba kala niwe yaázooka. ");
INSERT INTO zin_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Náho, Herode akagaamba, “Yohana, nkamunogola omútwe! Mbwéenu, ogwo noóha, wi ndikuhulila empola ze ebikolwa ebyo?” Bityo, Herode akaba naayeénda abonane na Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Entumwa abo ba Yeézu, baásuba hali Yeézu, baámusoomboolela byóona éebyo baákozile. Áaho, yaábatwáala baázeenda boónka omu muzihwa ogulikwéetwa Betisaida. ");
INSERT INTO zin_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Náho embága ya abaantu baámanya empola nkokwo yaázeenda aho, baaba nibamukulaatíla. Yaábanyegeza, yaábaanza kubeégesa ebigaambo byo obukáma bwa Múungu. Na abalwéele omuli abo, akaba naabachíza. ");
INSERT INTO zin_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","No obuchilo heéliliza olweébazo, abaheémba abo ikúmi na bábili béeza baámugaambila, “Áaho tuli, no omu chitúuntu. Ha bwéecho, obakuúndile abaantu aba bazeénde omu mitúulo no omu maka aheena emisili, babone kubonesa ebyookulya na aho kubyáama.” ");
INSERT INTO zin_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yeézu yaábasubiza, “Mubáhe ebyookulya íimwe!” Baámusubiza, “Íichwe titwíina byookulya, náho emikaate itaanu yoónka, ne eénfwi ibili. Ngási, nooyeénda tuzeénde kubagulila abaantu embága yóona ezi ebyookulya?” ");
INSERT INTO zin_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na abakwaáta áabo abaabeele bali aho, bakaba bali ebihuumbi bitaanu no obusáago. Yeézu yaábagaambila abaheémba boómwe, “Mubagaambile abaantu aba beekale empelo bunaanka, buli luhelo abaantu babe makúmi ataanu ataanu báti.” ");
INSERT INTO zin_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Niho, baákola nka nikwo yaabalagíile, abaantu bóona baaba beékala. ");
INSERT INTO zin_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeézu yeeháho emikaate ezo itaanu, ne eénfwi ibili. Yaálaangamila olugulu omu igulu, yaámusiima Múungu. Niho yaázimenyula, yaábaha abaheémba boómwe, babone kubaha abaantu. ");
INSERT INTO zin_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Aba bóona baálya, baáhaaga. Abaantu bakatulaaniza amasaága ge ebyookulya, geézula ebitukulu ikúmi na bibili. ");
INSERT INTO zin_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Echilo chimo, Yeézu na abaheémba boómwe bakaba bali hamo, boónka. Yeézu akaba naamusaba Múungu. Káyaabaliile, yaábabúuza, “Embága za abaantu nibagaámba nka nikwo íinye ndi oóha?” ");
INSERT INTO zin_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Baámusubiza, “Abáandi, nibagaámba nka nikwo íiwe níiwe Yohana Omubatiza. Na abáandi bagaámba nka nikwo, íiwe oli omubáasi Eliya. Nábo abáandi nka nikwo, íiwe oli oómo wo omuli abo babáasi ba kala óogwo ayaázooka.” ");
INSERT INTO zin_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yeézu yaábabúuza káandi, “Náho íimwe sii! Nimugaámba íinye ndi oóha?” Peétero yaámusubiza, “Íiwe níiwe Masihi wo mwa Múungu!” ");
INSERT INTO zin_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeézu yaábaangila omu kubalagila nka nikwo batagaambila omuuntu echigaambo echo. ");
INSERT INTO zin_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yaábagaambila, “Íinye Omutábani wo Omuuntu, ni lwaampaka nnyagalazwe bwooli, nnyaángwe na abanyaampala ba Abayahudi, na bakúlu ba abagabe ba Múungu, na abeégesa be ebilagilo, kuhika nnyitwe. Náho ha chilo cha kásatu, mazima ndyaázoolwa.” ");
INSERT INTO zin_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Niho, Yeézu yaábagaambila bóona aáti, “Kaálaaba omuuntu weéna wéena naaloonda kuba omuheémba waanze, naayeéndelwa aleke kukuláatila ebiteékuzo byoómwe, asutule omusalaba gwoómwe buchiile, ankulaatile. ");
INSERT INTO zin_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Habwo kuba, weéna wéena óogwo alikweenda kweéchuungula omwooyo gwoómwe, niwe alaabuza obulami bwoómwe. Na weéna wéena óogwo alaabuza obulamíbwe ha bwaanze, niwe alaabuchuúngula. ");
INSERT INTO zin_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Omuuntu naabona mugaso chi, kaálaabonesa byóona ebyo omu nsi ezi, náho akabuza obulami bwoómwe? ");
INSERT INTO zin_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Weéna wéena óogwo alikuúnzilila ensoni íinye na amagaambo gaanze, ogwo niwe íinye Mutábani wo Omuuntu neenye ndaámuzilila ensoni, obuchilo ndiíza ahi ikuzo lyaanze, ne elya Táata, ne elya bamaléeka boómwe abatakatíifu. ");
INSERT INTO zin_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Mazima niimbagaambila nka nikwo, heena abaantu omuli aba abeémeeliile aha áabo tibalifwa, bacháali batakabubwéene obukáma bwa Múungu!” ");
INSERT INTO zin_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Káyaamazile kugaamba ebigaambo ebyo, byaáhiingula nke ebilo munáana, Yeézu yaátwáala Peétero, Yohana, na Yakobo, yaáhanama nábo omu ibaanga, abone kusaba hali Múungu okwo. ");
INSERT INTO zin_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Obuchilo yaáhika omu ibaanga, yaábaanza kumusaba Múungu. Mále, yaáhiinduka ensuso yo obusóbwe. Ebizwáalo byoómwe, byaaba bilikweela pee! No kwéengelela bwooli. ");
INSERT INTO zin_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ahonyini, haabonekanáho abakwaáta bábili nibeengelela ahi ikuzo, bali Musa na Eliya, abo abaabeele nibagaamba gaamba na Yeézu habwe empola zo kufwa kwoómwe, nkokwo alaahikiíliza okwo Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ha mwáanya ogwo, Peétero na bazeenzíbe bakaba bahuniile omu túlo tulikulemeela. No obuchilo kíbeemuka, baámubona Yeézu naayeengelela ahi ikuzo lyoómwe. Baababonáho áabo abakwaáta bábili, beemeeliile héehi náze. ");
INSERT INTO zin_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Obuchilo aba bábili nibamuleka Yeézu, Peétero yaámugaambila, “Íiwe Mukáma wéetu, ni kuluunzi íichwe tuliho aha. Twoombeke aha otutiindi túsatu, kámo kabe akaawe, akáandi kabe aka Musa, na akáandi kabe aka Eliya.” Ago Peétero gi yaágaambile, talagamanyile. ");
INSERT INTO zin_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Obuchilo Peétero akaba naagaámba amagaambo ago, aha lugulu yáabo heezaho obwíile, bwaábaswéeka. Abaheémba abo baátíina bwooli. ");
INSERT INTO zin_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kuluga omu bwíile omwo haalugamo iláka, niligaámba, “Ogu niwe Mutábani waanze engaanzi óogwo naátoólize! Mumuhuliilíze weényini!” ");
INSERT INTO zin_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kagahwéele amagaambo ago, abaheémba abo baáleeba Yeézu yaásigala weénka. Nábo beésiza no omu bilo ebyo tibalamugaambiile omuuntu weéna wéena ebyo babweene aho. ");
INSERT INTO zin_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Obuchilo nihacha, Yeézu na abaheémba abo básatu baátúuka okwo omu ibaanga, baábugana ne embága mpaango ya abaantu. ");
INSERT INTO zin_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","No omu baantu abo, hakaba heena omuuntu oómo ayaabeele naahamuka ahi iláka omu kugaamba, “Íiwe Mweégesa, niinkusába, ondeébele omusígazi ogu, kuba weényini niwe mwáana waanze nyakámo. ");
INSERT INTO zin_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Elyo izimu limwaagalaza, limukola ateéle eyoombo. Káandi limuleetela ebisiimbo, kuhicha ifúlo limuluga omu kanwa. Lizeendelela kumuyuuguula no kumusikula sikula bwooli, na limulekula aha kwaágalala. ");
INSERT INTO zin_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Abaheémba baawe mbasabile nka nikwo balibiínge izimu, náho bakalemwa.” ");
INSERT INTO zin_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeézu yaágaamba, “Íimwe abaantu be enchilo ezi zo kwáanga kwiikiliza, mwaátumaangile kubi! Niinyikala neemwe no kubeémela, kuhicha li? Ndeétela mutábani waawe.” ");
INSERT INTO zin_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Omwaana ogwo, obuchilo akaba naayiza, ahonyini, elyo izimu lyaámugwiisa ahaansi, lyaámukola kufuluuta. Náho, Yeézu akalikáama, yaámuchiza omwaana ogwo, yaámusúbiza iíse. ");
INSERT INTO zin_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Abaantu bóona, obuchilo baabweene obuhicha bukúlu bwa Múungu, baásobelwa bwooli. Abaantu abo bóona, bakaba bachaali nibasobelwa ebikolwa byóona bya Yeézu. Obuchilo obwo Yeézu yaábagaambila abaheémba boómwe, yaágaamba, ");
INSERT INTO zin_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ebigaambo ebyo ndaábagaambila óobu, mubihuliilíze kuzima! Íinye Omutábani wo Omuuntu niizeénda kukoongwa na nibaánta omu ngalo za abaantu.” ");
INSERT INTO zin_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Náho, ago gi Yeézu yaábagaambiile, tibalagasoombookiilwe, habwo kuba echigaambo echo chikaba chiselekilwe hali boónyini, bataákusoombookelwa ensoonga yaáho. Mala bakaba nibatiína kumubúuza ensoonga ye ebigaambo byoómwe. ");
INSERT INTO zin_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Omu baheémba ba Yeézu, haabámo ebiteékuzo bíbi, nka nikwo noóha omuli boónyini aláaba mukúlu kuchila bazeenzíbe. ");
INSERT INTO zin_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Náho Yeézu akamanya okuteékuza kwáabo. Ha bwéecho, yaátwáala omwaana muto, yaámweemeeleza héehi na áaho aáli, ");
INSERT INTO zin_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yaábagaambila, “Omuuntu óogwo alaamwiinaánkula omwaana ogu ahi izíina lyaanze, naába yaányinaankula íinye. No omuuntu óogwo alaanyinaánkula íinye, naába yaámwiinaankula no óogwo ayaansiíndikile. Habwo kuba, omuuntu óogwo ali muto omuli íimwe mwéena, ogwo niwe ali mukúlu kuchila bóona.” ");
INSERT INTO zin_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana yaámugaambila Yeézu, “Íiwe Mukáma wéetu, tukamubona omuuntu óogwo akaba naataagucha amazimu ahi izíina lyaawe, twaámwaangila, habwo kuba weényini ti muheémba waawe nkeechwe.” ");
INSERT INTO zin_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeézu yaámusubiza, “Mutamwaángila omuuntu nko ogwo, habwo kuba omuuntu ogwo atakwaángilana neemwe, ali olubazu lwéenyu.” ");
INSERT INTO zin_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Obuchilo bwa Yeézu kutwáalwa omu igulu bukaba bweéliliize, niho yaálamwíile nka nikwo azeénde Yeruzaléemu, yaázeenda. ");
INSERT INTO zin_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Omu luzeendo lwoómwe, akasiindika entumwa abókumweébeembelela. Aba bakataaha omu mugoongo gwa Abasamaria, babone kumuloongeza aho kubyáama. ");
INSERT INTO zin_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Náho, abatwíile okwo baayáanga kumwiínaankula, habwo kuba akaba naazeénda Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Abaheémba boómwe, Yakobo na Yohana, kábaabweene ago, baámubúuza, “Íiwe Mukáma wéetu, nooyeénda tusábe omulilo gutuúke kuluga omu igulu gubasiingaáliche, nka Eliya náwe kwoyaakozile?” ");
INSERT INTO zin_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Náho Yeézu, obuchilo nibagaámba ebyo, yaábechebuka, yaábahana, yaágaamba, “Íimwe timukumanya muli baantu chi. ");
INSERT INTO zin_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Habwo kuba Omutábani wo Omuuntu taleézile kusiingaalicha abaantu, náho kubachuúngula.” Baázeenda omu mugoongo ogúundi. ");
INSERT INTO zin_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Obuchilo Yeézu na abaheémba boómwe bakaba nibalibata omu muháanda, omuuntu oómo yaámugaambila, “Niinkúkulaatila hoóna hóona áaho olaáza!” ");
INSERT INTO zin_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeézu náwe yaámusubiza, “Nyamuhaábwa, ziba ziina ameena gaázo, ne enyonyi, zizila ebyaali. Náho, íinye Mutábani wo Omuuntu, tiinzila no óobu aho kubyaámika omútwe gwaanze.” ");
INSERT INTO zin_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yeézu yaágaambila omuuntu oóndi, “Onkuláatile!” Omuuntu ogwo yaámusubiza, “Íiwe Mukáma, nkuúndila ntaandike nzeénde kumuziika táata.” ");
INSERT INTO zin_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Náho Yeézu yaámusubiza, “Leka abáfwiile babazíike abáfwiile bazeenzi báabo. Náho íiwe, zeénda oze kubamanyisa abaantu empola zo obukáma bwa Múungu.” ");
INSERT INTO zin_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","No óobu omuuntu oóndi, yaámugaambila Yeézu aáti, “Íiwe Mukáma, niinkukulaatila. Náho echa mbele, onkuúndile nzeénde mbalage abaantu bo omúka.” ");
INSERT INTO zin_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeézu yaámugaambila, “Omuuntu weéna wéena óogwo ayaábaandize kulima ne enfuka ye ente, kaálaaba naayechebuka kuleeba enyuma, ogwo, takweendelwa kuba omuhálila wa Múungu omu bukáma bwoómwe.” ");
INSERT INTO zin_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kagahwéele ago, Omukáma Yeézu yaátooza abaheémba abáandi makúmi musaanzu na bábili. Yaábasiíndika bábili bábili, bamweébeembelele buli muzihwa na buli hóona áaho yaabeele alamwíile weényini kuhika. ");
INSERT INTO zin_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yaábagaambila abaheémba boómwe aáti, “Emyéezo ni míinzi, náho abakózi ni bache. Ha bwéecho, mumusabe kanyina wo omusili, abone kusiíndika abakózi omu musili gwoómwe. ");
INSERT INTO zin_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mwiilóoko, muzeénde íimwe. Náho, mumanye nka nikwo niimbatwéeka nka abáana be entaama éezo ezilikulibata ahagáti ye emisegwe! ");
INSERT INTO zin_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mutaákutwáala enfulebe ye empilya, nali ensáho, nali enkeeto. Mala káandi mutaángalucha omuuntu weéna wéena omu muháanda. ");
INSERT INTO zin_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“No obuchilo mulaataahámo omu nzu, mwaangalúche abaantu bo omwo, múti, ‘Íimwe, mube no obuhóolo.’ ");
INSERT INTO zin_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na kahalaaba heena omuuntu wo obuhóolo omwo, obuhóolo óobwo muláaba mwiinabwo, nibusigala náwe. Náho, kihalaaba hatéena omuuntu wo obuhóolo omu nzu omwo, obuhóolo bwéenyu nibubasubila. ");
INSERT INTO zin_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mutaákuba nimuzeénda kubyáama omu nzu ezíindi zíindi. Náho, mwiikale omu nzu éezo mwaazamo, nimulya ebyookulya éebyo balikubaha. Habwo kuba omukózi chimugasize kuhaabwa empeéla yoómwe. ");
INSERT INTO zin_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Obuchilo mulaataahámo omu chaalo choóna chóona, na abatúuzi nibabanyégeza, mulye ebyookulya éebyo baláaba nibabaha. ");
INSERT INTO zin_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Na abalwéele abali omu byaalo ebyo, mubachíze. Mubagaambile abatúuzi nkokwo, obukáma bwa Múungu bwaábeélilila. ");
INSERT INTO zin_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Náho, obuchilo mulaataahámo omu chaalo choóna chóona, na abatúuzi tibakubanyégeza íimwe, mulabile omu miháanda, nimugaámba, ");
INSERT INTO zin_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘No óobu enkuungu ye echaalo chéenyu éezo elamasile aha magulu géetu, nituzikuunkumulaho, neéba emanyiso ye ebiheno byáanyu. Hamo ne ebyo, mumanye mazima nkokwo, obukáma bwa Múungu bweéliliize!’ ");
INSERT INTO zin_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Niimbagaambila nkokwo, echilo éecho Múungu alichwaaziika abaantu be éensi, alyaábachwaáziika kúbi bwooli abaantu bo omu chaalo echo kuchila abaantu ba Sodoma!” ");
INSERT INTO zin_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Nimwiilóoko íimwe, abaantu ba Korazíini! Mulamanya íimwe, abaantu ba Betisaida! Habwo kuba, amahano áago nkakola hali íimwe, naakugakozíle omuli Tíilo na Sidóoni, abaantu ba Tíilo na Sidóoni baakaátamilwe ebiheno byáabo no kumuhiindukila Múungu bwaangu. Baakaáyolekile okuhiindukila kwáabo omu kwiikala bazweele amagunila, no kweésiiga iízu. ");
INSERT INTO zin_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ha bwéecho, echilo éecho Múungu alichwaaziika abaantu, alyaábachwaáziikila neemwe kúbi bwooli kuchila abaantu ababi aba Tíilo na Sidóoni! ");
INSERT INTO zin_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Neemwe, abaantu ba Kaperinaumu, mutaákuteekuza nka nikwo nimukuzibwa kuhika omu igulu? Mmahi, olyaágolomolwa ohike omu lyoongoola lya kuzimu yo olufu.” ");
INSERT INTO zin_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mále, Yeézu yaábagaambila abaheémba boómwe, “Omuuntu óogwo alaabahuliiliza íimwe, naába yaánhuliiliza íinye. No omuuntu óogwo alaábáanga íimwe, naába yaányaangile íinye. No óogwo alikunyáanga, aha kukola aátyo, naába yaámwaangile óogwo ayaansiíndikile.” ");
INSERT INTO zin_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kahaabaliile, abaheémba abo makúmi musaanzu na bábili baásuba, nibanulilwa. Baámugaambila, “Íiwe Mukáma wéetu, no óobu amazimu, obuchilo nitugabiínga ahi izíina lyaawe, nigatukoondoókela!” ");
INSERT INTO zin_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeézu yaábagalulila, “Naaba naálibona Isitáani nilihanaántuka nko olulábyo kuluga omu igulu. ");
INSERT INTO zin_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Léeba mumanye nka nikwo, naábahéele obuzizi bwo kusíinga amagala góona go ogwo omubisa. Ha buhicha obwo, nimulibatila no óobu enzóka na kamiína, na tihaliho echiintu choóna chóona éecho chilaábahutaaza. ");
INSERT INTO zin_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“No óobu bityo, mutaákunulilwa nka nikwo amazimu nigabakoondoókela. Náho, munulilwe echigaambo echi, nka nikwo amazíina géenyu gaáyaandikilwe omu igulu.” ");
INSERT INTO zin_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Obuchilo obwo, Yeézu akasemelelwa bwooli omu Mwooyo Mutakatíifu, yaágaamba, “Íiwe Táata, Mukáma wi igulu ne éensi, niinkusiima habwo kuba, ebigaambo ebi okaseleka abamasala na abamanyi, okabita aha bwéelu aha baantu áabo abeena okwiikiliza nka abayaánda abato. Éego Táata, habwo kuba nikwo óokwo wayeenzile.” ");
INSERT INTO zin_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mále yaábagaambila, “Táata ampeele byóona. Tihaliho omuuntu óogwo alikumusoombookelwa Mutábani wa Múungu nka nikwo aáli, náho Táata weénka. Káandi, taliho muuntu óogwo alikumusoombookelwa Táata nka nikwo aáli, náho Omutábani weénka, na weéna wéena óogwo Omutábani alaalamula kumusuululila.” ");
INSERT INTO zin_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ahonyini, Yeézu yaábaleeba abaheémba boómwe, yaábagaambila boónyini boónka, “Mwiina omugisa íimwe, habwo kuba nimuleeba ebigaambo ebyo ha méeso géenyu! ");
INSERT INTO zin_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Niimbagaambila, hakaba heena ababáasi béenzi, na abakáma béenzi, áabo bakaba nibabyeefúuza kuleeba ebyo bi mulikuleeba, náho tibalabibwéene. Káandi, ebyo bi mulikuhulila íimwe, bakaba nibabyeefúuza kubihulila, náho tibalabihuliile.” ");
INSERT INTO zin_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Echilo chimo, omweégesa oómo we ebilagilo akeémeelela, yaámubúuza Yeézu ibúuzo kumuleengesa, yaámugaambila, “Íiwe Mweégesa, nkole chiíha, mbone kuhuungula obulami bwo obucha no obuchiile?” ");
INSERT INTO zin_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeézu yaámusubiza, “Omu bilagilo haandikilwémo chiíha? Noobimanyáho oóta?” ");
INSERT INTO zin_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yaámusubiza, “Byaandíkilwe biti, ‘Omweénde Omukáma Múungu waawe aha muganya gwaawe gwóona, aha bwéenze bwaawe bwóona, aha magala gaawe góona, nikwo kugaamba, hali byoona ebili hali íiwe.’ Mala ‘Omweénde muzeenzi waawe nko óokwo olikweéyeenda íiwe nyini.’” ");
INSERT INTO zin_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeézu yaámugaambila, “Waásubya kuzima! Kola oótyo, neewe noobona obulami.” ");
INSERT INTO zin_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Náho, omweégesa ogwo we ebilagilo, akaba naayeénda kwoóleka nkokwo no omugololoke, niyo ensoonga yaámubúuza Yeézu, “Mutúuzi waanze, noóha?” ");
INSERT INTO zin_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeézu yaámugalulila aáti, “Hakaba heena omuuntu oómo, ayaabeele naagolomoka kuluga Yeruzaléemu, akaba naalibata kuzeenda Yeriko. No omu muháanda omwo, yáagwa omu ngalo za abanyagiilizi. Bóona baámugulukila, baámutéela bwooli, baámuzúula ebizwáalo, baámusiga ali héehi no okufwa. ");
INSERT INTO zin_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Ahi ibaando lizima, omu muháanda ogwo, hakeeza omugabe oómo wa Múungu. Náho omugabe ogwo, obuchilo yaamubwéene omuuntu ogwo, yaálaba aha mpelo yo omuháanda. ");
INSERT INTO zin_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Omuláawi náwe, yaáhika aho, na akazeendele kaaba kátyo nyini. Obuchilo yaamubwéene omuuntu ogwo, yaálaba aha mpelo yo omuháanda. ");
INSERT INTO zin_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Aha káanya yéeza Omusamaria oómo, óogwo ayaabeele ali omu luzeendo lwoómwe. Obuchilo yaamubwéene omuuntu ogwo, yaámuganyila. ");
INSERT INTO zin_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yaamuzáho, yaámuséemba obuhuta bwoómwe ha kubuteelaho evíini na amazuta, yaábukoma. Mále yaámuhanamika aha lugulu ye ensíkili yoómwe, yaámutwáala omu nzu ya abazenyi, yaaba naamulwaáza. ");
INSERT INTO zin_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Nyeéncha eémo, yaásohoza omu nsaho edináali ibili, yaámuha owe éenzu ya abazenyi. Yaámugaambila, ‘Omulwáaze omuuntu ogu. Na kázilaayeendelwáho empilya ezíindi ha bwoómwe, obuchilo Ndaáhiingula aha, niinkuliha.’ ” ");
INSERT INTO zin_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Niho, Yeézu yaámubúuza omweégesa ogwo we ebilagilo, “Ha bwéecho! Ha kuleeba kwaawe, akaba ali oóha omu baantu abo básatu, ayaabeele ali mutuuzi wo ogwo ayaatabaaliilwe na abanyagiilizi ha kumukolela ebizima?” ");
INSERT INTO zin_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yaámusubiza, “Ogwo ayaamuziliile echiganyizi.” Yeézu yaámugaambila, “Zeénda, oóbe na akazeendele kátyo nyini!” ");
INSERT INTO zin_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yeézu na abaheémba boómwe, obuchilo bali omu muháanda, bataaha omu mugoongo gúmo. No omukázi oómo, izíina lyoómwe Marita, yaábanyegeza omúka yoómwe. ");
INSERT INTO zin_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ogwo Marita, akaba ayina muhala wáabo, izíina lyoómwe Mariamu. Obuchilo obwo, Mariamu akaba ayikeele héehi na amagulu go Omukáma, naahuliilíza amagaambo goómwe. ");
INSERT INTO zin_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Náho Marita akaba naayagalala ni ikola líinzi. Niyo ensoonga yaámwiililila héehi Yeézu, yaámugaambila, “Íiwe Mukáma wéetu, sii, tokusaaswa nkokwo muhala wéetu yaándekela emilimo zóona? Ha bwéecho, omugaambile ampwéele!” ");
INSERT INTO zin_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Omukáma yaámusubiza, “Íiwe Marita, Marita! Oyine okutahwa tahwa no kwaágalala habwa bíinzi. ");
INSERT INTO zin_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Náho heena echigaambo chimo choónka echilikweendelwa, káandi nichigasa kuchila byóona. Mariamu niwe óogwo ayaáchitooza, na taliho omuuntu alaáchimwáaka.” ");
INSERT INTO zin_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Echilo chimo, Yeézu akaba naamusaba Múungu ahaantu bunaanka. No obuchilo yaámazile, oómo wa abaheémba boómwe yaámugaambila, “Íiwe Mukáma, otweégese akazeendele ha kumusaba Múungu, nko óokwo Yohana Omubatiza yaabeégesize abaheémba boómwe.” ");
INSERT INTO zin_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeézu yaábagaambila, “Obuchilo muláaba nimumusaba Múungu, mugaámbe múti, ‘Isíichwe owo omu igulu, izíina lyaawe likuzibwe. Obukáma bwaawe bwiíze. Okweenda kwaawe kuhikiílizwe, omu nsi nko okwo omu igulu. ");
INSERT INTO zin_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Otuhe buli bucha ebyookulya byéetu. ");
INSERT INTO zin_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Otuganyile ebiheno byéetu, nko óokwo neechwe tuganyila abalikutuhénela. Otatutwáala omu kuleengesibwa náho otuchuúngule ne elyo Isitáani.’ ” ");
INSERT INTO zin_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aho Yeézu yaábagaambila, “Tugaámbe oómo omuli íimwe ayina munywáani woómwe, yaamuzáho omu itúumbi, yaámugaambila, ‘Íiwe munywáani! Niinsaba ontíizého emikaate isatu, ");
INSERT INTO zin_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","habwo kuba, munywáani waanze abeele ali omu luzeendo, yaáhikila owéetu, na tiinyina echookulya cho kumúha.’ ");
INSERT INTO zin_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Náho, munywaaniwe ogwo yaámusubiza, ‘Otaákuunyagalaza! Léeba naáchiingile olwíizi! Íinye na abáana baanze twaályaamile aha chitabo na tiínkuhicha kwiimuka no kukúha echiintu choóna chóona.’ ");
INSERT INTO zin_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Niimbagaambila, no óobu biláaba omuuntu ogwo takwiimuka no kumúha muzeenzíwe omukaate habwo kuba weényini ni munywáani woómwe, naayimuka no kumúha buli chiintu éecho alikweenda habwo kuba munywaaniwe talalekile kumusaba. ");
INSERT INTO zin_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Nikwo, neenye niimbagaambila, musábe, na mulyaáhaabwa, mukwáabe mulyaábona, muchiinguze, na mulyaáchiingulilwa. ");
INSERT INTO zin_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Habwo kuba, buli muuntu óogwo alikusaba, aheébwa. Na buli muuntu óogwo ataábuuza, abigwaho. Na buli muuntu óogwo achiinguza, achiingulilwa. ");
INSERT INTO zin_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ngási, heena omuzéele weéna wéena omuli íimwe, óogwo omwaana woómwe kaálikumusaba eénfwi, naamuha enzóka? ");
INSERT INTO zin_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nali omwaana kaálikumusaba ihuli, mazima naamuha kamiína? ");
INSERT INTO zin_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ha bwéecho íimwe, no óobu muli abaheni, nimusoomboókelwa kubaha abáana báanyu egabo ezigasize. Mazima! Isíimwe óogwo ali omu igulu naakola kusáaga aho, naabaha Omwooyo Mutakatíifu áabo abalikumusaba.” ");
INSERT INTO zin_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Echilo chimo, Yeézu akaba naabiínga izimu éelyo elyaamukozile omuuntu oómo kuba omutita. Obuchilo izimu nilimulugáho, yaábaanza kugaamba gaamba káandi. Abaantu áabo abaabeele baliho omuli ezo mbága, baáteenga bwooli. ");
INSERT INTO zin_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Náho, abáandi omuli abo baágaamba, “Naabiínga amazimu habwa amagala ga Beelzebuli, mukúlu wa amazimu!” ");
INSERT INTO zin_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Abáandi bakaba nibeénda kumuleengesa Yeézu, baámusaba aboóleke emanyiso kwoóleka nka nikwo alugile hali Múungu. ");
INSERT INTO zin_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Náho, habwo kuba Yeézu akamanya ebiteékuzo byáabo, yaábagaambila, “Buli bukáma nibweetaanisa no kulwaana bwoónyini omuli bwoónyini, obwo bukáma busiingáalika. Bityo nyini, eéka, keélitaagana, neégwa. ");
INSERT INTO zin_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bityo nyini ni Isitáani, kalilaaba nilibiínga no kulwaana na amazimu mazeenzíge, obukáma bwaályo nibulama buta? “Naábabúuza ibúuzo elyo, habwo kuba nimugaámba nkokwo niimbiínga amazimu ha buhicha bwa Beelzebuli. ");
INSERT INTO zin_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Íimwe nimugaámba nka nikwo íinye niimbiínga amazimu habwa amagala ga Beelzebuli. Mbwéenu, abaheémba báanyu nábo, nibagabiínga ha magala go oóha? Ha bwéecho, abo nyini nibo balaabachwaázika íimwe. ");
INSERT INTO zin_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Náho, kábilaaba íinye niimbiínga amazimu ha buhicha bwa Múungu, eyina ensoonga ya nkokwo obukáma bwoómwe bwaáhikile hali íimwe.” ");
INSERT INTO zin_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yeézu yaázeendelela kugaamba, “Omuuntu owa amagala ne echikwáato, naayekómya ebiintu bye eéka yoómwe, niho ebiintu byoómwe tibikukumibwáho nibiba no obuhóolo. ");
INSERT INTO zin_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Náho, omuuntu oóndi owa amagala bwooli, kaáleéza kumutabaalila, no kumusíinga, naamwaáka ebikwáato byoómwe éebyo alikutegeza, naayiba byóona ebili omúka, no kubigaba ha báandi. ");
INSERT INTO zin_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Omuuntu óogwo atali hamo ne íinye, taanyemela. Káandi, ogwo atasuúmbya hamo neenye, anaganaga.” ");
INSERT INTO zin_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Obuchilo izimu kaliluga aha muuntu, lizeenda omu nsi yo obwoóma no kweéngeela okwo lili omu kuloondela obuhuúmulo. Náho bubula, izimu elyo niligaámba nka nikwo, ‘Kaánsube owaánze áaho naálugile.’ ");
INSERT INTO zin_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Obuchilo nilisuba hali weényini, nilisaánga hali busa, hakukuumbilwe, no kutónwa kuluunzi. ");
INSERT INTO zin_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aho, nilizeénda kuléeta amazimu musaanzu áago gali amazilwa bwooli kuchila lyoónyini, góona geéza gamutaáhila ogwo muuntu. Niho obulami bwo omuuntu ogwo bulikuba bubi kusáaga óokwo bukaba buli aha bubaandizo.” ");
INSERT INTO zin_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Obuchilo Yeézu akaba naagaámba ago, omu mbága ya abaantu, akaba aliho omukázi oómo ayaahamukile ahi iláka liháango, omu kumugaambila aáti, “Eyina omugisa éenda ya máaha waawe eyaakuzéele na amabéele áago waáyoonkile!” ");
INSERT INTO zin_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Náho Yeézu yaásubya omu kugaamba, “Mmahi! Áabo abalikuhulila echigaambo cha Múungu aha kuchikoondookéla, nibo abeena omugisa!” ");
INSERT INTO zin_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Obuchilo embága ya abaantu yaáguma kukoba, Yeézu akagaamba aáti, “Abaantu bo luzáalo óolu na abazilwa bwooli! Nibaansaba emanyiso, náho tibakuháabwa emanyiso choónka emanyiso ezo zo mwa Yona, omubáasi. ");
INSERT INTO zin_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Habwe ensoonga, keélaaba Yona akaba ali emanyiso ha baantu be echikaali cha Ninawi, bityo nikwo íinye Mutábani wo Omuuntu neenye, ndyáaba emanyiso ha baantu bo luzáalo óolu. ");
INSERT INTO zin_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Echilo cho omuchwaáziiko, omugóle wo olubazu lwa nyakaziinzakazi alaáyemeelela, no kubasoholeza buulubona nkokwo abaantu bo obuchilo óobu na abaheni. Habwo kuba, weényini akazeenda oluzeendo kuluga éensi za hala bwooli, abone kuhulila ebigaambo byo obweétegeeleza bwa Selemani. Kási, aha nyini aliho oómo óogwo ali mukúlu kuchila Selemani! ");
INSERT INTO zin_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Káandi, echilo cho omuchwaáziiko abaantu ba Ninawi, balaáyemeelela omu méeso ga Múungu hamo na abaantu bo obuchilo óobu, no kubasoholeza buulubona abaantu bo luzáalo óolu nkokwo na abaheni. Habwo kuba, abaantu abo ba Ninawi, obuchilo Yona yaábagaambiile echigaambo cha Múungu, ahonyini baátamwa ebiheno byáabo no kubilekelela. Aha aliho oómo óogwo ali mukúlu kuchila Yona!” ");
INSERT INTO zin_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Taliho omuuntu óogwo alikwaacha olumuli, akaluta aheéselekile, nali akaluswéekelela ne echitukulu. Náho naaluteleka aha lugulu ya akakóondo, kuba obuchilo abaantu nibazamo muliinya, babone kuleeba ha mwaanga ogwo. ");
INSERT INTO zin_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Na améeso gaawe, ni nko olumuli lyo omubili. Kagalikuba nigahweéza kuzima, omubili gwaawe gwóona gwiikala omu mwaanga. Náho, améeso gaawe kagalikuba gali mábi, omubili gwaawe gwiizwíile ensiimbaazi. ");
INSERT INTO zin_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ha bwéecho, oyékomye nkokwo mazima oyinagwo omwaanga omugati yaawe. Otaákuba ne ensiimbaazi omwo! ");
INSERT INTO zin_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Habwo kuba, nkokwo omubili gwaawe gwóona gwiina echeengéezi chiteena lugazi lwe ensiimbaazi yoóna yóona, gulaámweeka, nko olumuli óokwo lukumulikila.” ");
INSERT INTO zin_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yeézu káyaabeele achaágaamba ebyo, Omufarisayo oómo yaámwaangisa ha byookulya omúka yoómwe. Yeézu yaataahámo, yeékala ha luhelo. ");
INSERT INTO zin_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Omufarisayo ogwo, yaábona nkokwo Yeézu takanaabile yaálya ebyookulya, yaásobelwa bwooli. ");
INSERT INTO zin_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Náho, Omukáma yaámugaambila, “Íimwe Abafarisayo, mwoózo echikóombe no olutemele ahéelu. Náho omuli íimwe, emyóoyo eyizwiile obunyagiilizi no obubi. ");
INSERT INTO zin_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Íimwe basilu! Óogwo ayaahaangile ahéelu, ngási talahaangile omuunda káandi? ");
INSERT INTO zin_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ha bwéecho, mweéyeze omuunda yáanyu ha kusuumbuusa abahabi ebyo kubazuna, niho ebíindi byóona omuli íimwe nibiba byaáyezwa. ");
INSERT INTO zin_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nimwiilóoko íimwe, Abafarisayo! Nimumusoholeza Múungu echinogóka che ikúmi cha buli chinogoka che ebyookulya byo otubabi two kuluungisa, nko omwóonyo, ebituungúlu, ne ebíindi biindi, náho timukusaaswa kuba ne ntúungwa nzima, na timukumwéenda weényini! Ni lwaampaka kuumsoholeza ezáaka ezo, obuteébwa amagaambo ago agáandi. ");
INSERT INTO zin_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nimwiilóoko íimwe, Abafarisayo! Nimweénda kwíikalila ebitébe bya abakúlu omu masomelo ga Múungu, nimweénda kwaángaluchwa ahi isima omu magulizo. ");
INSERT INTO zin_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nimwiilóoko íimwe! Muli nke eémbi éezo zitakubonwa nke ebitúulo éebyo abaantu balikubilibatila aha lugulu batéena kubimanya.” ");
INSERT INTO zin_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ahonyini, omweégesa oómo we ebilagilo yaámugaambila Yeézu, “Mweégesa, obuchilo noogaámba amagaambo ago, nootuzuma neechwe hamo.” ");
INSERT INTO zin_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeézu yaámusubiza, “Neemwe abeégesa be ebilagilo, nimwiilóoko yéenyu! Nimubatweéka abaantu emigugu elikulemeela. Neemwe, timukubahwéela kuziímucha no óobu ha lukumu! ");
INSERT INTO zin_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nimwiilóoko íimwe! Nimwoombeka eémbi za ababáasi, náho abaantu áabo babeésile ababáasi áabo, nibo besíimwe enkúlu! ");
INSERT INTO zin_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ha bwéecho, nimwaatula nkokwo nimwiikiliza áago gi baguúku báanyu baákozile. Habwo kuba boónyini bakabéeta áabo ababáasi, neemwe nimubyoombekela ebitúulo byáabo. ");
INSERT INTO zin_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Ha bwéecho Múungu, ensoonga zo obweétegeeleza bwoómwe akagaamba aáti, ‘Léeba, niimbasiindikila ababáasi ne entumwa. Náho, nibabeéta omuli áabo, na nibabaagalaza abáandi.’ ");
INSERT INTO zin_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ha bwéecho, abaantu bo obuchilo óobu nimuchwaaziíkilwa habwo kuseeswa kwe enságama za ababáasi bóona áabo baayisilwe, kuluga aha bubaandizo bwe éensi. ");
INSERT INTO zin_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kubaandiza enságama yo mwa Hábeeli, kuhika enságama yo mwa Zakaria, óogwo akeetilwa ahagáti yi itaámbilo ne éenzu entakatíifu ya Múungu. Amazima, niimbagaambila nkokwo abaantu bo luzáalo óolu nimuchwaaziíkilwa ago góona. ");
INSERT INTO zin_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nimwiilóoko íimwe, abeégesa be ebilagilo! Mwaáseleka olwo luchiínguzo lwo olwíizi, aho kuhiíngula, abaantu baakaábonesize kumumanya Múungu. Neemwe nyini timwaátaahamo, na áabo bakaba nibeénda kuzamo omugati, mwaábaangila.” ");
INSERT INTO zin_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Obuchilo Yeézu yaálugile aho, abeégesa be ebilagilo, na Abafarisayo, bakabaanza kuba nibamutámwa bwooli weényini. Bakaba nibamubuúza amabúuzo ga amagaambo méenzi, ");
INSERT INTO zin_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kuba babone kumukwáasa aha bigaambo byoómwe. ");
INSERT INTO zin_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Obuchilo obwo, ebihuumbi ne ebihuumbi bya abaantu kábaabeele beékobya kobya, kuhicha baaba nibeelibatila. Yeézu yaábaanza kugaambila abaheémba boómwe, “Mweélige no obugóbya bwa Abafarisayo, habwo kuba obugóbya obwo nibusaambaála nki ituumbyo. ");
INSERT INTO zin_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chóona chóona éecho echifuundikiilwe, chilyaáfuundulwa, na káandi, tihaliho echiselekilwe echitalimanywa. ");
INSERT INTO zin_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Buli chóona éecho mulikuhooya omu nsiimbaazi, nichihulilwa aha mwaanga. Na buli éecho mulikweéhweehweetéla omu matwi omu biseenge byo omugati, nichaatulwa ahi iláka liháango olugulu ye éenzu.” ");
INSERT INTO zin_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Niimbagaambila íimwe banywáani baanze, mutaákubatiina abaantu áabo abalikwíita omubili. Kabalikumala kwíita, tibakuhicha kukola echilikusáaga aho. ");
INSERT INTO zin_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Náho, niimbahana óogwo mulikweendelwa kumutíina, mumutíine Múungu! Kaálikuba yaámazile kumwíita omuuntu, ayina obuzizi bwo kumunáguza omu lyoongoola lyo omulilo gwa kuzimu gwo obucha no obuchiile. Ni Múungu weénka óogwo mulikweendelwa kutíina! ");
INSERT INTO zin_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ngási, enfuunzi itaanu tizikuguzwa habwo obukaani buche kwoónka? No óobu bityo, Múungu takumwéebwa no óobu oómo omuli abo. ");
INSERT INTO zin_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Náho íimwe, mwiina obukaani kuchila enfuunzi nyíinzi! Múungu naamanya no óobu olubalo lwi isóke lyóona lye emitwe yáanyu. Ha bwéecho, mutaákutiina.” ");
INSERT INTO zin_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Niimbagaambila nkokwo, buli muuntu óogwo alikuundaangaana omu méeso ga abaantu nkokwo weényini no omuuntu waanze, íinye Mutábani wo Omuuntu neenye ndaámulaangaana omu méeso ga bamaléeka ba Múungu nkokwo ogwo muuntu no waanze. ");
INSERT INTO zin_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Náho, buli muuntu óogwo alikuunyoga omu méeso ga abaantu, náwe naayógwa omu méeso ga bamaléeka ba Múungu. ");
INSERT INTO zin_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Buli muuntu óogwo alikugaamba amagaambo mábi hali íinye Mutábani wo Omuuntu, naaganyilwa. Náho, buli muuntu óogwo alikugaamba amagaambo mábi go kumulyoogweeza Omwooyo Mutakatíifu, ogwo taliganyilwa. ");
INSERT INTO zin_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Obuchilo nimutwaálwa omu masomelo ga Múungu, omu méeso ga abatégeki, na abeene obuhicha, mutaákwaagalala. Mutaákuba no okutahwa tahwa ha bigaambo éebyo mulaayeénda kugaamba aha kweézuna, ");
INSERT INTO zin_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","habwo kuba, akáanya ako nyini, Omwooyo Mutakatíifu naabeegésa amagaambo áago muhikiilwe kugaamba.” ");
INSERT INTO zin_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Omu mbága ezo ya abaantu, omuuntu oómo yaámugaambila Yeézu, “Mweégesa, omugaambile mudugu waanze, tubagane ebiintu éebi yaátulekíile táata.” ");
INSERT INTO zin_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeézu yaámugaambila, “Noóha ayaantiilého iímbe omulamuzi nali omukwaátanisi wéenyu?” ");
INSERT INTO zin_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mala Yeézu yaábagaambila abaantu abo, “Muléebe! Mweélige na buli chiintu cha ameelu ge ebiintu, habwo kuba, obulami bwo omuuntu, tibukuluga ha bwíinzi bwe ebiintu byoómwe éebyo ayinabyo.” ");
INSERT INTO zin_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Káandi Yeézu yaábachwéela omugani, aha kugaamba, “Hakaba heena omuhíte oómo, ayaayelize ebyookulya bíinzi bwooli omu musili gwoómwe. ");
INSERT INTO zin_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yeébuuza omu muganya gwoómwe, ‘Nzileho iínta óobu? Ebi byookulya byaanze byóona, tiinyina ahaantu áaho ndaábita!’ ");
INSERT INTO zin_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Káandi yeégaambila, ‘Niinziláho iínti. Niinkaambula ebitála byaanze, no kwoómbeka ebíindi biháango bwooli. Omwo niíntamo ebyookulya byaanze byóona, ne ebiintu byaanze ebíindi.’ ");
INSERT INTO zin_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aho káandi niingaambila omu muganya gwaanze, ‘Óobu neeteláho obuhite bwe ebiintu bíinzi bizima. Nibiingása aha myáaka míinzi! Mbwéenu óobu, nhuumule kwoónka. Nndye no okunywa! Nnulilwe!’ ");
INSERT INTO zin_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Náho, Múungu yaámugaambila, ‘Íiwe omusilu! Leélo omu chilo, noófwa! Ne ebiintu byóona éebyo oyesuumbíize, nibiba byo oóha?’ ” ");
INSERT INTO zin_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yeézu, yaámala aha kugaamba, “Bityo nikwo nka nikwo bilaabaho, aha muuntu ogwo alikweésuumbiza ebiintu bíinzi ha bwoómwe weényini, náho omu kazeendele ke ebiintu byoómwe, takumusaaswa Múungu.” ");
INSERT INTO zin_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mala, Yeézu yaábagaambila abaheémba boómwe, “Ha nsoonga ezo, niimbagaambila nka nikwo, mutaákuba no kutahwa tahwa habwo obulami bwéenyu, nkokwo nimulya chi, nali ha mibili yáanyu, nkokwo nimuzwaála chi. ");
INSERT INTO zin_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Habwo kuba obulami bwiina obukaani kuchila ebyookulya, omubili nágwo, gwiina obukaani kuchila ebizwáalo! ");
INSERT INTO zin_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Muléebe amakolokóozi. Tigakubiba nali kugesa, tigazila mbíiko yoóna yóona nali ebitála, náho kwoónka Múungu naagaliísa. Kamwaakwiínganisibwa ne enyonyi, mwiina obukaani bwooli kusáaga aho! ");
INSERT INTO zin_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Noóha omuli íimwe ayaakuhicha kweéyoongeláho obulami bwoómwe nóobu nko omwáanya gwe esáaha eémo omu kutahwa tahwa kwoómwe? ");
INSERT INTO zin_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mbwéenu! Nko óokwo timwaákuhicha kukola nóobwo echigaambo chiche nke echo, ha bwaáchi mwiina okutahwa tahwa hali ebyo ebíindi? ");
INSERT INTO zin_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Muteekuze óokwo enyaso, nka nikwo zilikumela. Tizikukola emilimo nali kwóogosa ebizwáalo. Náho niimbagaambila nka nikwo, nóobu omukáma Selemani omu ikuzo lyoómwe lyóona, talazweekilwe kuzima nka límo lye enyaso ezo! ");
INSERT INTO zin_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bityo nikwo Múungu azweeka enyaso na amababi go omu nkáamba, áago galiho leélo, na nyeéncha niganágwa omu mulilo. Ngási, ta amazima nkokwo naabazweéka íimwe? Íimwe abaantu bo okwiikiliza kuche! ");
INSERT INTO zin_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Bityo, mutaákweeyagalalila nimulya chiíha, nali nimunywa chiíha, mutaákuba no okutahwa tahwa. ");
INSERT INTO zin_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Abaantu ba amahaánga góona áabo abatakumumanya Múungu nibaagalalila ebiintu ebyo. Náho Isíimwe naasoombookelwa kuzima nka nikwo mulikweenda ebyo! ");
INSERT INTO zin_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ha bwéecho, echa mbele muloondele amagaambo go obukáma bwa Múungu, ne ebiintu ebi byóona naaboongéla.” ");
INSERT INTO zin_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mutaákutiina, íimwe embága nche, habwo kuba Isíimwe azizile engoonzi kubaha obukáma bwoómwe. ");
INSERT INTO zin_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Muguze ebiintu byáanyu, musuumbuuse abahabi. Mweékolele enfulebe éezo ezitakukokola, mube ne ensáho okwo omu igulu aheene obuhóolo nayo tekuchéeha. Okwo, taliho omwíibi kwíiba, nali embuungu kuzisiisagula. ");
INSERT INTO zin_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hoóna hóona áaho mulikubíika ensáho yáanyu, niho ne emyóoyo yáanyu elaaba eéli.” ");
INSERT INTO zin_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mube buligi ligi mweébohile omusipi kuheéleza, ne emuli zéenyu, zibe nizaáka. ");
INSERT INTO zin_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mube nka abaantu áabo balikumuliíndilila omukáma wáabo asube kuluga omu mazenyi go obweenga, kuba kaáleéza no kubachiínguza, abasaánge muli buligi ligi ahonyini mumuchiíngulile. ");
INSERT INTO zin_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nibaba no omugisa, abazáana áabo omukáma wáabo alaasaanga bali méeso obuchilo aleéza. Mazima butúnu niimbagaambila, naayeloónza, naabeekaza aha byookulya, no kubaheéleza! ");
INSERT INTO zin_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Niguba omugisa aha bazáana abo keélaaba omukáma wáabo yaásuba no kubasaanga bali buligi ligi noobwo omu itúumbi lye esáaha munáana nali enchaákala omulucheelelélwa! ");
INSERT INTO zin_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mumanye kuzima echigaambo echi: Kanyina we éenzu, yaakumanyíle akáanya áako aleéza omwíibi, yaakeéloongize, no omwíibi tiyaákutaahilémo omúka yoómwe. ");
INSERT INTO zin_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ha bwéecho neemwe, mube mweéloongize, habwo kuba íinye Mutábani wo Omuuntu, ndyéeza omu buchilo óobwo mutakutegeza.” ");
INSERT INTO zin_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Káandi, Peétero akamubúuza Yeézu, “Mukáma, omugani ogwo gu waátugaambila, ngási na hali íichwe kwoónka, nali na aha baantu bóona?” ");
INSERT INTO zin_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Omukáma yaámusubiza, “Noóha sii omwiímeelelezi óogwo ali omweésigwa no owa amasala? Ayina akazeendele ako, ogwo omukáma woómwe alaamuta kuba omwiímeelelezi wa abazáana bazeenzíbe, abone kubaha empeéla ye ebyookulya omu buchilo obulikugasa. ");
INSERT INTO zin_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Naába ayina omugisa weényini omuzáana óogwo omukáma woómwe kaálaasuba kuluga omu luzeendo, no kumusaanga naakola aátyo. ");
INSERT INTO zin_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mazima butúnu niimbagaambila nka nikwo, omukáma woómwe naamutáho aábe omwiímeelelezi we ebiintu byoómwe byóona. ");
INSERT INTO zin_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Náho, nibibaho bita omuzáana ogwo kaáleegaambila omu muganya gwoómwe, ‘Omukáma waanze yeélilwa bwooli kusuba?’ Niho abaanza kubatéela abazáana bazeenzíbe, abaséeza na abakázi, no kulya no okunywa, kuhicha yaátamiila. ");
INSERT INTO zin_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mbwéenu, mukáma wo ogwo muzáana alyéeza aha chilo chi atakutégeza na aha buchilo obwo atakumanya. Niho omukáma woómwe alaámunogagula ebinogoka bibili, no kumuta ahaantu hamo na abaantu áabo batakumwiíkiliza Múungu. ");
INSERT INTO zin_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Omuzáana óogwo alikumanya okwo alikweendaho omukáma woómwe, náho takeeloongize na takakozile okwo alikweendelwa, ogwo naateélwa bwooli. ");
INSERT INTO zin_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Náho, omuhálila óogwo atakusoombookelwa okwo alikweendaho mukáma woómwe, na akakola echigaambo echimugasize kutéelwa, weényini naateélwa kuche. Omuuntu óogwo aheelwe bíinzi, naatoóngwa bíinzi, omuuntu óogwo ategiizwe bíinzi, naatoóngwa bwooli muno kusaagiliza.” ");
INSERT INTO zin_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Íinye, nkeeza omu nsi, mbone kwaacha omulilo. Na naakaáyeenzile bwooli mbone omulilo ogwo gwaayakile! ");
INSERT INTO zin_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nnyina obubatizo bwe ebyaágalalo óobwo ndikweendelwa nnyinaánkule, no kuhicha buhikiílizwe, nnyinalwo olwaágalalo luháango. ");
INSERT INTO zin_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ngási, nimuteekuza nkokwo neeza omu nsi kuléeta obuhóolo? Mmahi! Niimbagaambila nkokwo, neeza kutaáganisa abaantu. ");
INSERT INTO zin_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kubaandiza óobu, omu nzu ya abaantu bataanu, básatu nibataagána na bábili. Bábili nábo, nibataagána na abo básatu. ");
INSERT INTO zin_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Abaantu balyaátaagana, iíse, alaáchokolana no omutábani, no omusígazi náwe, alaáchokolana ne iíse. Nyina, alaáhakana no omuhala, omuhalákazi náwe alaáhakana na nyina. Nyinazaala, alaáchokolana na mweengáwe, ogwo mweenga náwe, alaásiingaangána na nyinazaala.” ");
INSERT INTO zin_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Káandi Yeézu yaázigaambila embága ya abaantu, “Kamulikubona obwíile nibulugiílila olubazu lwo obugwa, ahonyini nimugaámba, ‘Enzula neégwa óobu nyini,’ amazima nayo, eégwa. ");
INSERT INTO zin_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kamulikubona omuyaga niguluga olubazu lwa nyakaziinzakazi, mara mugaámba, ‘Nihabaho ne echifuúnda,’ na nikwo bilikuba. ");
INSERT INTO zin_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Íimwe ngóbya! Nimuhicha kuzima kusoombookelwa akazeendele ko obwíile ne emiyaga ye éensi aha kuzileeba, ngási óobu! Na ha bwaáchi nimulemwa kusoombookelwa ensoonga ya amagaambo ago agalikugwa ebilo éebi?” ");
INSERT INTO zin_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Na ha bwaáchi timukuhicha kweélamulila íimwe nyini kukola amagaambo amazima ago obuteéka agalikweendelwa? ");
INSERT INTO zin_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Obuchilo omulégeelezi waawe naakutwaála omu itégekelo, yakaábeele kuzima oyégumisilize bwooli kukuúndilana náwe mucháali muchili omu muháanda. Echíindi chaáho, naakuhicha omu méeso go omulamuzi. No omulamuzi ogwo, naakuta omu ngalo za abasilikale, nábo nibakutáasha lwa amáani omu ibóhelo. ");
INSERT INTO zin_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Niinkugaambila nkokwo, mazima tokulugamo omwo, kuhicha omazile kuliha ne eséenti yo omuhélo, obutasigaza ibáanza!” ");
INSERT INTO zin_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Obuchilo obwo, abaantu bakéeza baámugaambila Yeézu empola za Abagaliláaya abáandi abo nkokwo Pilato akazitúlaaniza enságama yáabo ne ye ebitáambo byáabo. ");
INSERT INTO zin_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeézu yaábagaambila, “Ngási, nimuteekuza nkokwo Abagaliláaya abo bakáfwa bátyo, habwo kuba bakaba bali abaheni kuchila Abagaliláaya abáandi bóona? ");
INSERT INTO zin_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Niimbagaambila iínti, ti bityo! Kamulaaba mutatamilwe ebiheno byáanyu mukabileka no kumuhiindukila Múungu, bityo nyini neemwe nimusiingaálika mwéena! ");
INSERT INTO zin_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nali, abo baantu bóona ikúmi na munáana áabo abaagweeliilwe no oluswi luleehi bwooli okwo Siloamu bakáfwa, ngási, nimuteekuza nkokwo abo nibo bakaba bali abaheni kuchila abatúuzi abáandi bóona ba Yeruzaléemu? ");
INSERT INTO zin_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Niimbagaambila iínti, ti bityo! Kamulaaba mutatamilwe ebiheno byáanyu mukabilekelela no kumuhiindukila Múungu, bityo nyini neemwe nimusiingaálika mwéena!” ");
INSERT INTO zin_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aho, Yeézu yaábachwéela omugani abaantu abo, ha kubagaambila, “Hakaba heena omuuntu oómo óogwo akaba ayina omuti gwo omutini oguhaambilwe omu musili gwoómwe gwe emizabibu. Káyaabalíile, yéeza kusoloma emisumo kuluga omu mutini, náho talabonesize. ");
INSERT INTO zin_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mbwéenu, yaámugaambila omuhálila woómwe wo omu musili, ‘Léeba! Mba niinyíza kuloondela emisumo omuli ogu muti ogu gwo omutini, aha mwáanya gwe emyáaka isatu. Náho tiínkabonesagamo choóna chóona! Mbwéenu gunogole, gutaákuzeendelela kukula omu itaka busa!’ ");
INSERT INTO zin_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Náho, ogwo muhalila yaámusubiza, ‘Mukáma, guléke omwáaka ogu, mbone kugulimila no kugutéeláho obunula. ");
INSERT INTO zin_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kagulaazáala emisumo omwáaka oguleéza, ni kuzima! Náho kágulaaléka kuzáala, mbwéenu ogunogole.’ ” ");
INSERT INTO zin_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Echilo chimo che Endaálikizo, Yeézu akaba ali omu isomelo límo, naayegesa abaantu. ");
INSERT INTO zin_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Omwo, hakaba heenamo omukázi oómo, óogwo akaba akwaásilwe ni izimu lya amalwáala aha myáaka ikúmi na munáana. Izimu likaba lyaámuhínyile omugoongo, na talahikize kweémeelela bweémi. ");
INSERT INTO zin_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Obuchilo Yeézu yaamubwéene, akamwéeta ayize hali weényini, yaámugaambila, “Máaha, óobu! Oóbe no obuhóolo, waáchila obulwéele bwaawe.” ");
INSERT INTO zin_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yeézu yaamutéelaho engalo, ahonyini yaáyemeelela bweémi, yaaba naamukuza Múungu. ");
INSERT INTO zin_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Habwo kuba echilo echo Yeézu akachiza omuuntu chikaba chili echilo che Endaálikizo, omweébeembezi wi isomelo akasaaya. Yaábagaambila abaantu, “Omuli buli bwooyo, ebilo ebihikiiliilwe byo kukola emilimo nibyo mukáaga. Mbwéenu! Mwiíze muchízwe omu bilo ebyo, náho mutaákwiiza kuchizwa echilo che Endaálikizo!” ");
INSERT INTO zin_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ahonyini Omukáma yaámusubiza, “Íimwe ngóbya! Íimwe mwéena nimukola emilimo echilo che Endaálikizo! Ngási buli oómo wéenyu, tasibula ente yoómwe nali ensíkili yoómwe kuluga omu chibuga, azitwáale kunywa améenzi, no óobu chili echilo che Endaálikizo? ");
INSERT INTO zin_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Léeba ogu mukázi, wo olugaanda lwa Ibrahímu, yaámazile emyáaka ikúmi na munáana abohilwe ni Isitáani. Mbwéenu sii! Ogwo náwe, amazima abeele atali lwaampaka akomoololwe omu chilo che Endaálikizo?” ");
INSERT INTO zin_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Obuchilo Yeézu yaágaambile ago, abagome boómwe bóona, ahonyini baákolwa ensoni. Náho abáandi bóona, bakanulilwa bwooli habwe ebigaambo bizima bya amahano áago Yeézu akaba naakola. ");
INSERT INTO zin_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Káandi Yeézu yaábúuza, “Obukáma bwa Múungu nibususana na chiíha? Mbwiínganise na chiíha? ");
INSERT INTO zin_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nibususana no oluzuma luche lwe ehaladáali éezo omuuntu akabiba omu musili gwoómwe. Embíbo yaámela, yaaba omuti, zéeza enyonyi zaáyoombeka ebyaali byaázo omuli ago matabazi gaágwo.” ");
INSERT INTO zin_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeézu yaábúuza káandi, “Mbususanise obukáma bwa Múungu na chiíha? ");
INSERT INTO zin_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nibususana ni ituumbyo éelyo omukázi naatwaála no kutulaaniza ne ensaano ye engano ye embalililo ye ebitukulu bísatu. Ituumbyo elyo nilileeteelela ensaano ye engano yóona kutuumba.” ");
INSERT INTO zin_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeézu akaba ali omu luzeendo kuzeenda Yeruzaléemu. Omu muháanda áaho akalabila, akaba naayegesa abaantu bo omu mizihwa no omu migoongo. ");
INSERT INTO zin_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chilo chimo, omuuntu akamubúuza, “Mukáma, abaantu áabo balichuúngulwa, balyáaba báche kwoónka?” Yeézu yaágaamba, ");
INSERT INTO zin_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mweéyomeleze mwéena kuzamo aha kulabila omulyaango ogufuunzile. Niimbagaambila nkokwo, béenzi balyaáleengesa kuzamo, náho balyaálemwa. ");
INSERT INTO zin_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Obuchilo owe éenzu yaáchiingile olwíizi, mulyaáyemeelela ahéelu, mulyaábaanza kumuchiínguza na ha kumusaba, ‘Mukáma, otuchiíngulile!’ Náho naabasubiza, ‘Tiínkubamanya! Tiínkumanya mwaaluga nkáhi!’ ");
INSERT INTO zin_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Neemwe mulaámugaambila, ‘Ngási tukalya no okunywa hamo neewe! No omu mitúulo yéetu, niho okatweégesa’ ");
INSERT INTO zin_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Náho naabagaambila, ‘Naábagaambiile, tiínkubamanya na tiínkumanya mwaaluga nkáhi! Mulugého aha, íimwe abapagasi abaheni!’ ");
INSERT INTO zin_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Niho mulaáchúla no kusa améeno, habwo kuba, nimumubona Ibrahímu, Izáaka, na Yakobo, na ababáasi bóona bali omu bukáma bwa Múungu, náho íimwe muláaba mwaánagilwe ahéelu! ");
INSERT INTO zin_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Abaantu nibeéza kuluga obutúluka no obugwa, kuluga chiziba cha ntumwa na nyakaziinzakazi, balaálya ebyookulya omu bukáma bwa Múungu. ");
INSERT INTO zin_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Muhuliilíze! Abaantu áabo abali bo omuheleeluko óobu, balyáaba nibo abo kubaanza, na abo kubaanza óobu, balyáaba abo omuheleeluko.” ");
INSERT INTO zin_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Obuchilo obwo nyini, Abafarisayo bunaanka bakamuzáho Yeézu baámugaambila, “Lugáho aha, ozeénde ahaantu aháandi, habwo kuba Herode naayeénda kukwíita.” ");
INSERT INTO zin_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeézu yaábasubiza, “Muzeénde muzigaambile nyamuhaábwa ezo, ‘Léeba! Leélo na nyeéncha, niimbiínga amazimu kubalugaho abaantu, no kubachíza abalwéele, ne echilo cha kásatu, niinhikiíliza ensoonga yaanze.’ ");
INSERT INTO zin_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hamo ne ebyo, niinyeendelwa nzeendelele no oluzeendo lwaanze lwo kuzeenda Yeruzaléemu leélo na nyeéncha ne ezweéli, kuhicha nhíke okwo, habwo kuba tichikwiíle omubáasi kufwéela ahaantu aháandi, choónka Yeruzaléemu! ");
INSERT INTO zin_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Íiwe Yeruzaléemu, Yeruzaléemu! Nooyita ababáasi, no kubahoonda na amabáale abaantu áabo Múungu abasiindikile hali íiwe. Entúlo nyíinzi nkaba niinyeénda kubakobya kobya abaantu baawe, nko óokwo enkóko okwo ekobya kobya otuzwíiyo twaáyo omu manana gaáyo, náho buli ntúlo timuleenzile! ");
INSERT INTO zin_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Muléebe! Óobu Múungu yaábaleka íimwe ne éenzu yáanyu! Mbwéenu, niimbagaambila, amazima timukuumbona káandi, kuhicha obuchilo mulyaágaamba nka nikwo, ‘Ayina omugisa ogwo alikwiiza ahi izíina lyo Omukáma Múungu!’” ");
INSERT INTO zin_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Echilo chimo che Endaálikizo, Yeézu akazeenda kulya ebyookulya omúka yo omutégeki oómo wa Abafarisayo. No obuchilo akaba ali omwo, Abafarisayo na abáandi bakaba nibamuleébeleza bwooli. ");
INSERT INTO zin_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na aho omu méeso goómwe, hakaba haliho omuuntu oómo, óogwo akaba ayina obulwéele bwo kututuma. ");
INSERT INTO zin_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeézu yaábabúuza Abafarisayo na abeégesa be ebilagilo, “Ngási, nitukuundilwa ne ebilagilo byéetu kuchíza abaantu omu chilo che Endaálikizo, nali no omuzilo?” ");
INSERT INTO zin_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Náho boónyini, beésiza. Yeézu yaamukwaatáho omulwéele ogwo, yaámuchiza, yaámulaga asube omúka. ");
INSERT INTO zin_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Káandi Yeézu yaábabúuza, “Noóha omuli íimwe óogwo, ente nali ensíkili yoómwe káyaakugwa omu iziba echilo che Endaálikizo, tiyaákuziihilémo bwaangu ahonyini, nóobwo chili echilo che Endaálikizo?” ");
INSERT INTO zin_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Abaantu abo, tibalabeele ne cho kusubya habwa amagaambo aga. ");
INSERT INTO zin_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yeézu akaba naaléeba abazenyi abalaálikwa óokwo bakaba nibeesolela ebitébe bya abazenyi bi isima. Niho yaábachwéela omugani, aha kugaamba, ");
INSERT INTO zin_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Obuchilo nooyaangisibwa omu mazenyi go obweenga, otaákwiikala ahaantu ha bazenyi bi isima. Otaákukola oótyo habwo kuba, hamo lúundi ayaangisiíbwe oóndi owi isima bwooli kuchila íiwe. ");
INSERT INTO zin_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","No ogwo abalaálikile íimwe bábili, naayiza kukugaambila, ‘Mulekele ogu olugazi lwaawe.’ Aho, nóokolwa ensoni bwooli, habwo kuba nooyeendelwa kuzeenda kwíikalila olugazi lwa aha muhélo bwooli. ");
INSERT INTO zin_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Náho, obuchilo noolaalikwa omu mazenyi go obweenga, zeénda oyikále aha lugazi lwa aha muhélo bwooli. Ha bwéecho obuchilo óogwo ayaakulaálikile aleéza, akugaambile, ‘Munywáani waanze, iíza súba kunu ahéehi, niho hazima bwooli.’ Bityo nikwo olaahaabwa ikuzo omu méeso ga abazenyi bóona. ");
INSERT INTO zin_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Habwe ensoonga, buli muuntu óogwo alikweékuza, alyaácheéshibwa. Na buli muuntu óogwo alikweecheesha, naakuzibwa.” ");
INSERT INTO zin_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aho, Yeézu yaámugaambila ogwo ayaamwaángisize, “Obuchilo noobaloongeza abaantu amazenyi ge echookulya cha nyemisana nali aha lweébazo, otaákwaangisa banywáani baawe, nali béene báanyu, nali abaantu bali badugu baawe, nali abatúuzi baawe abahíte. Koólaakola oótyo, abo nábo nibakwaangisa owaabo, na bityo nibakusubiza aha kukusubiza nka ago gi waabahéele. ");
INSERT INTO zin_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Náho, obuchilo noobaloongeza abaantu amazenyi, oyaangise abahabi, abalema, enziíngami, na abahume. ");
INSERT INTO zin_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Niho oláaba no omugisa, habwo kuba abo tibéena echiintu chokukusubiza. Náho Múungu niwe óogwo alaakusubiza, obuchilo alizoola abaantu áabo baamusemelíize weényini.” ");
INSERT INTO zin_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Oómo omuli abo abaabeele beékeele hamo na Yeézu aha luhelo, kayaabihuliile ebigaambo ebyo, yaámugaambila, “Ayina omugisa, omuuntu weéna wéena óogwo alaalya amazenyi omu bukáma bwa Múungu!” ");
INSERT INTO zin_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yeézu yaámusubiza aha mugani ha kugaamba aáti, “Hakaba heena omuuntu oómo óogwo akaloonza amazenyi maháango, yaálaalika abaantu beenzi. ");
INSERT INTO zin_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ha kachilo ka amazenyi kaáhika, yaásiindika omuzáana woómwe aha balaálikwa bóona azeénde kubagaambila, ‘Óobu mwiíze! Ebiintu byóona byaákóbile!’ ");
INSERT INTO zin_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Náho, abalaálikwa bóona, oómo oómo baaba nibeebulabuza nibasaba echiganyizi. Owa mbele, yaámugaambila, ‘Nguzile ensaambo, mazima nzeénde kuzileeba. Niinkusába onzilile echiganyizi.’ ");
INSERT INTO zin_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Oóndi akagaamba, ‘Nguzile ente zo kulima, emikomelano itaanu, no óobu, niinzeénda kuzigema. Niinkusába onzilile echiganyizi.’ ");
INSERT INTO zin_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","No oóndi akagaamba, ‘Nswiíle omukázi omu buchilo óobu nyini, ha bwéecho tiínkuhicha kwíiza.’ ");
INSERT INTO zin_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ogwo muhálila yaagalukáyo, yaámumanyisa omukáma woómwe ago góona. Niho omukáma woómwe yaánigahala, yaámugaambila omuzáana woómwe, ‘Zeénda bwaangu omuli ogwo muháanda omugazi no otuhaándagazi two omu muzihwa ogwo, ozeénde kubaléeta abahabi, abalema, abahume, ne enziíngami aha.’ ");
INSERT INTO zin_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Káyaabalíile, omuzáana ogwo yaásuba, yaámugaambila, ‘Mukáma, ago gi waándagila nikwo naázila. No óobu bityo, hacháali hachiliho obwiikalo ha báandi.’ ");
INSERT INTO zin_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Omukáma yaámugaambila omuzáana woómwe aáti, ‘Mbwéenu! Osohole ahéelu ozeénde aha miháanda éezo elikuzeenda omu mitúulo emiche, no omu misili, obakomeenteleze abaantu beéze batáahe omúka yaanze, kuhicha eyizule. ");
INSERT INTO zin_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Náho omuli abo bóona áabo naalaálikile, niimbagaambila nkokwo talimo nóobwo omuuntu oómo óogwo alaaloza amazenyi gaanze!’ ” ");
INSERT INTO zin_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yeézu, akaba naakulaatilana ne embága mpaango ya abaantu. Yaáhiinduka, yaábagaambila, ");
INSERT INTO zin_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Omuuntu weéna wéena óogwo alikuunyizaho, mazima ha kwiingana no kuunyeenda íinye, naayeéndelwa atamwe iíse, nyina, mukázi woómwe, abáana boómwe, badugu boómwe, na banyáanya, nóobwo ayitamwe weényini weénka. Bitali bityo takuhicha kuba omuheémba waanze. ");
INSERT INTO zin_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","No omuuntu weéna wéena óogwo atakeemukize omusalaba gwoómwe akaankulaatila, takuhicha kuba omuheémba waanze. ");
INSERT INTO zin_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Tugaámbe oómo omuli íimwe naayeénda kwoómbeka oluswi lula bwooli. Mazima, takwoombeka atekeéle no kuleeba obuguzi bwa buli chiintu éecho alaakozesa aha kwoómbeka oluswi olwo. Kaálaakola aátyo, niho alaasoomboókelwa nkokwo ayina empilya zo kuhicha kumala obwoómbeki. ");
INSERT INTO zin_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kaálaaba atakozile aátyo, yaakaáhicha kwoómbeka oluhazo, náho ahaleéza naalemwa kulumaliiliza oluswi. Niho buli muhiínguzi, alyáaba naamugaya, ");
INSERT INTO zin_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","aha kugaamba, ‘Omuuntu ogu akabaanza kwoómbeka, náho talahikize kumaliiliza obwoómbeki obu!’ ");
INSERT INTO zin_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nali ni mukáma chi ayaakweenda kuza kulwaana no omukáma oóndi, atabaandize akeekala no kuteékuza nkokwo yakaahicha, aha balwaanila ngoma boómwe ebihuumbi ikúmi (10,000), kugima kulwaana ichúmu no ogwo omukáma ayina abalwaanila ngoma ebihuumbi makúmi ábili (20,000)? ");
INSERT INTO zin_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kaálaabona nkokwo naalemwa, ahonyini naasiindika entumwa boómwe, bazeénde bwaangu aha mukáma oóndi achili hala, babone kukuúndilana kuba no obuhóolo. ");
INSERT INTO zin_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bityo nikwo no omuli íimwe, taliho nóobwo oómo wéenyu óogwo yaakuhicha kuba omuheémba waanze, kaálaaba atakalekile byóona éebi ayinabyo.” ");
INSERT INTO zin_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Omwóonyo ne echiintu chizima. Náho kagulikuba gwaáhwéele omuta, tigwaakuhicha kuba no obunuzi bwo omwóonyo káandi. ");
INSERT INTO zin_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Omwóonyo gwa akazeendele aka, tigukugása chiintu, nali ahi itaka, nali aha bunula, abaantu nibagunaga kwoónka. Óogwo ayina amatwi, ahuliilize!” ");
INSERT INTO zin_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Echilo chimo, abahaámbya na abeene ebiheno abáandi, bóona bakakóba hali Yeézu, bamuhuliílize. ");
INSERT INTO zin_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chaaletelela Abafarisayo na abeégesa be ebilagilo bya Múungu, baádugulima báti, “Omuuntu ogu, léeba naabaangisa abeene ebiheno! Káandi naálya hamo nábo!” ");
INSERT INTO zin_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ha bwéecho, Yeézu yaábachwéela omugani, yaágaamba, ");
INSERT INTO zin_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tugaámbe oómo omuli íimwe ayina entaama igana. Kaálaamanya nkokwo eémo yaázo yaábula, naakola chiíha? Ngási, takuzileka ezo makúmi mweenda na mweenda omu maliísizo, no kuzeenda kuloondela ezo eémo ebuzile, kuhicha azibone? ");
INSERT INTO zin_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Obuchilo naazibona, naazisutula ha mabega aha manulilwa, ");
INSERT INTO zin_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","no kuziléeta omúka. Aho naabeéta banywáani boómwe na abatúuzi, no kubagaambila, ‘Tunulilwe hamo neenye, habwo kuba entaama yaanze, éezo eyaabuzile, naázibona!’ ");
INSERT INTO zin_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Niimbagaambila, bityo nikwo halibaho amanulilwa maháango omu igulu, obuchilo owe ebiheno oómo kaalikubitamwa akabilekelela akalamula kumuhiindukila Múungu, kuchila abo makúmi mweenda na mweenda abagololoke áabo abatakusaaswa kutamwa ebiheno byáabo bakabilekelela no kubula kumuhiindukila Múungu.” ");
INSERT INTO zin_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nali tugaámbe omukázi oómo ayina empilya ikúmi zo obukaani, mala yaábúuza eémo. Ngási takukoóngeza olumuli, no kukukuumba éenzu yóona, omu kuziloondela aha ha bweeyomeleza kuhicha azibone? ");
INSERT INTO zin_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Obuchilo alaazibona, naabeéta abanywáani boómwe na abatúuzi, no kubagaambila, ‘Tunulilwe hamo, habwo kuba empilya éezo eyaabuzile, naázibona!’ ");
INSERT INTO zin_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Niimbagaambila, bityo nyini heena amanulilwa omu méeso ga bamaléeka ba Múungu, obuchilo owe ebiheno oómo kaalikutamwa ebiheno byoómwe akabilekelela akalamula kumuhiindukila Múungu.” ");
INSERT INTO zin_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeézu akazeendelela kugaamba, “Hakaba heenaho omuuntu oómo óogwo akaba ayina abatábani bábili. ");
INSERT INTO zin_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Omuto, yaáza ahali iíse yaámugaambila, ‘Táata, iímpa obuhuunguzi bwaanze.’ Ha bwéecho, isébo yaábagabila amabonwa goómwe. ");
INSERT INTO zin_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Kábyaahiíngwiile ebilo bíche, ogwo omuto yaákobya kobya ebiintu byoómwe byóona, yaazila oluzeendo yaázeenda éensi ya hala. Obuchilo káyaahikile óokwo, yaábaanza kubisiisagula ebiintu byoómwe aha kubilya kúbi. ");
INSERT INTO zin_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Káyaamazile empilya zóona, heeza enzala mpaango omu nsi ezo, náwe yaaba atéena choóna chóona. ");
INSERT INTO zin_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ha bwéecho, yaázeenda yaákwaátaangana no omuuntu oómo wo okwo, yaámusaba nkokwo aábe omuhálila woómwe. Ogwo muuntu yaámusiíndika omu musili kulíisa empunu zoómwe. ");
INSERT INTO zin_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","No obuchilo empunu zikaba nizilya ebisusu, na weényini akalumwa enzala yaáligila kubilya! Náho taliho omuuntu óogwo ayaamuhéele choóna chóona echo kulya. ");
INSERT INTO zin_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ha muheleeluko, akabaanza kwiizilwa amasala, omu kuteékuza aáti, ‘Abazáana ba táata, léeba bóona nibalya, kuhicha nibaháaga no kubisigaza! Náho aha, niínfwa habwe enzala. ");
INSERT INTO zin_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Óobu niinsúba hali táata, no kumugaambila, “Táata, naámuheniile Múungu, na naákuheniile íiwe káandi. ");
INSERT INTO zin_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tiinkwiílwe káandi kwéetwa omwaana waawe. Ha bwéecho, onkole nko oómo wa abazáana baawe.” ’ ");
INSERT INTO zin_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mbwéenu, yaalugáho aho, yaásuba hali iíse. Obuchilo akaba acháali achili hala no omúka, iíse yaámubona, omuganya gwoómwe gwéezulwa ne echiganyizi. Ahonyini yaámwiílukiilila omutábani, yaámubuúmbatila no kumunyweégela. ");
INSERT INTO zin_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ogwo mwáana yaámugaambila iíse, ‘Táata, naámuheniile Múungu, na naákuheniile íiwe káandi. Tiinkwiílwe káandi kwéetwa omwaana waawe.’ ");
INSERT INTO zin_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Náho, iíse yaábagaambila abazáana boómwe, ‘Bwaangu! Muleéte enkaanzu enduunzi mumuzwéeke. Mumuzwéeke empeto omu lukumu lwoómwe, ne ebilaátu omu magulu. ");
INSERT INTO zin_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Muleéte ezo esázwa ye enyána, muzibáage. Tukole amazenyi, tulye ha manulilwa, ");
INSERT INTO zin_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","habwo kuba ogu mwáana waanze, abeele abuzile, náho óobu yaábonwa, abeele ali nka afwíile, óobu káandi ali mwooyo!’ Niho abo bóona baábaanza kukola amazenyi ga amanulilwa. ");
INSERT INTO zin_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Omu buchilo obwo, ogwo omutábani omukúlu, akaba ali omu musili. Obuchilo yaabele naasuba yeélilila omúka, akahulila nkokwo abaantu nibazina no kunegula. ");
INSERT INTO zin_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yaámweeta omuzáana oómo, yaámubúuza, ‘Heena chiíha?’ ");
INSERT INTO zin_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yaámugaambila, ‘Mulumuna waawe yéeza, na iíso yaámutemela esázwa ye enyána, habwo kuba yaámubona omutábani, káandi, achili mwooyo.’ ");
INSERT INTO zin_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ogwo musígazi omukúlu yaásaaya, yaáyaanga kutaahamo omúka. Iíse yaásohola ahéelu, yaaba naamusaba ataahemo. ");
INSERT INTO zin_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Náho weényini yaámusubiza, ‘Táata huliiliza! Emyáaka míinzi mba niinkuheeleza, káandi tiínkalekileho kukoondookela ebilagilo byaawe nóobwo entúlo eémo! Hali íinye, tokaampéele nóobwo omwaana gwe embuzi, mbone kukola amazenyi nnulilwe hamo na banywáani baanze. ");
INSERT INTO zin_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Náho omwaana waawe ogu, óogwo asiísagwiile amabonwa gaawe aha busiihani, obuchilo kwoónka yéeza, weényini waámutemela esázwa ye enyána!’ ");
INSERT INTO zin_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Iíse yaámugaambila, ‘Mwáana waanze, íiwe otuula hamo neenye buchiile, na amabonwa góona gi nnyinágo na agaáwe. ");
INSERT INTO zin_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Náho mulumuna waawe, nituhikiílilwa tumukolele amazenyi no kunulilwa hamo. Habwo kuba ogu mwáana waanze, abeele abuzile, náho óobu yaábonwa, abeele ali nka afwíile, óobu káandi ali mwooyo!’ ” ");
INSERT INTO zin_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Káandi, Yeézu yaábagaambila abaheémba boómwe, “Hakaba heena omuhíte oómo no omwiímeelelezi woómwe. Omwiímeelelezi ogwo, akalegelelwa nkokwo akaba naasíisa ebiintu bya mukamáwe. ");
INSERT INTO zin_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ha bwéecho, omuhíte akamwéeta omwiimeelelezíwe, yaámubúuza, ‘Ni magaambo chi aga gi ndikuhulila hali íiwe? Ntoondela okubala kwe ebiintu byaanze, habwo kuba tokukuúndilwa kuzeendelela kuba omwiímeelelezi!’ ");
INSERT INTO zin_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ogwo mwiímeelelezi yeébuuza, ‘Nzileho nta óobu? Omukáma waanze, naanyiha omu milimo. Tiinyina amagala go kulima, na niinzila ensoni kusabiliza. ");
INSERT INTO zin_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mbwéenu, niimmanya cho kukola, kuba ahaleéza abaantu babone kuunnyegeza omu maka gáabo kaándaalekesibwa emilimo ezi.’ ");
INSERT INTO zin_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ha bwéecho, omwiímeelelezi ogwo yaábéeta buli oómo, bóona, abalikutóongwa na mukamáwe. Yaámubúuza owa mbele, ‘Ibáanza lyaawe ha mukáma waanze ni ndeengo chi?’ ");
INSERT INTO zin_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yaámusubiza, ‘Ibáanza lyaanze, na amapipa igana ga amazuta ge emizeituni.’ Omwiímeelelezi yaámugaambila, ‘Twaála olwaandiko óolu, olwaandikilwe ibáanza lyaawe yikala aha, ozihiindule bwaangu, yaandika makúmi ataanu.’ ");
INSERT INTO zin_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mala káandi yaámubúuza omutoongwa oóndi, ‘Íiwe, ibáanza lyaawe ni ndeengo chi?’ Náwe yaámusubiza, ‘Amagunila igana ge engano.’ Ogwo omwiímeelelezi yaámugaambila, ‘Twaála olwaandiko óolu lwi ibáanza lyaawe, yaandikaho makúmi munáana.’ ");
INSERT INTO zin_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Káyaabaliile, omuhíte yaámusiingiza ogwo omwiímeelelezi atali omweésigwa aha bucheluke bwoómwe. Habwo kuba, abaantu ba kataka ezi béena obucheluke ha bigaambo byáabo na bazeenzi báabo, kuchila abaantu bo omu mwaanga. ");
INSERT INTO zin_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Náwe Yeézu yaázeendelela kubagaambila, muheéle ebiintu byáanyu byo omuli kataka ezi ha báandi mubóne abanywáani, kuba kábilihwa, mwaangiswe omu butúulo bwo obucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Buli muuntu óogwo ali omweésigwa aha magaambo máche, niwe ali omweésigwa nóobwo aha magaambo amaháango. Bityo nyini, buli muuntu óogwo atali omweésigwa aha magaambo máche, niwe atali omweésigwa nóobwo aha magaambo amaháango. ");
INSERT INTO zin_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mbwéenu, kamulaaba íimwe mutabeéle abeésigwa aha kutégeka amabonwa go omuli kataka ezi, noóha alaabeésiga omu kubaha obutégeki bwo obuhite bwa amazima bwo omu igulu? ");
INSERT INTO zin_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kamulaaba íimwe mutabeéle abeésigwa aha mabonwa go oóndi, mbwéenu noóha akwiíle kubaha íimwe amabonwa agali géenyu! ");
INSERT INTO zin_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Taliho omuhálila óogwo yaakuhicha kuheéleza abakáma bábili. Habwo kuba, yaakaátamwa omukáma oómo no kweenda oóndi, nali yaakaákúunda ago omukáma oóli, na ayaanga ago omukáma ogu. Bityo neemwe, timwaákuhicha kugomookela Múungu hamo na amabonwa!” ");
INSERT INTO zin_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Abafarisayo, obuchilo baáhuliile amagaambo ago ga Yeézu, bakabaanza kumuseka aha kumugaya, habwo kuba bakaba nibeénda bwooli empilya. ");
INSERT INTO zin_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yeézu yaábagaambila, “Íimwe, nimweekola abagololoke omu méeso ga abaantu. Náho, Múungu naamanya amagaambo ago agali omu miganya yáanyu. Habwo kuba, amagaambo ago gi balikukuza bwooli abaantu, nigamutamisa bwooli Múungu!” ");
INSERT INTO zin_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ebilagilo bya Musa, na amaandiko ga ababáasi, gakaba nigakulaatilwa na abaantu kuhicha omu buchilo bwa Yohana Omubatiza. Kuluga obuchilo bwoómwe, abaantu bakaba nibamanyiswa Empola Nzima zo obukáma bwa Múungu, na buli muuntu ayetaashámo lwa amagala. ");
INSERT INTO zin_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nóobwo bityo, chihuhuukile bwooli ahi igulu ne éensi kuhwáho, kuchila enyuguta eémo ye ebilagilo kubuza echilali. ");
INSERT INTO zin_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Buli muuntu, kaalikulekaana na mukazíwe no kukuúmpula oóndi, naasaambana. Na alaakuumpula omukázi óogwo ayaalekéene ne eéba, naasaambana.” ");
INSERT INTO zin_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Hakaba heena omuhíte oómo óogwo akaba alya kuzima buli chilo, no kuzwaala ebizwáalo bizima, mále byo obukaani, bye ezaambalau. ");
INSERT INTO zin_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na ahi iléembo lyo ogwo muhíte, akaba ayikalaho omuhabi oómo, izíina lyoómwe Lazáaro. Lazáaro, omubili gwoómwe gwóona gukaba gwiizwíile ebigogo, ");
INSERT INTO zin_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","eémbwa zikaba niziíza kumulaámba láamba ebigogo byoómwe. Lazáaro akaba aligila ahaábwe kulya amasaága ge ebyookulya áago gakaba nigalagala kuluga aha meéza yo ogwo muhíte. ");
INSERT INTO zin_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nikwo yaálemwa, omuhabi Lazáaro yaáfwa. Bamaléeka baámutwáala omu igulu, héehi na Ibrahímu. Ogwo muhíte náwe yaáfwa, yaáziikwa. ");
INSERT INTO zin_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","No obuchilo omuhíte akaba naayagalala bwooli okwo kuzimu, yayeenamula améeso, yaábona Ibrahímu kuluga hala, náwe Lazáaro ali héehi náwe. ");
INSERT INTO zin_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Akamwéeta ahi iláka, ‘Táata Ibrahímu, onganyile! Niinyagalala bwooli omu mulilo ogu! Omusiíndike Lazáaro ayize hali íinye, akole omunwa gwo olukumúlwe omu méenzi, agatoónyeze aha lulími lwaanze lubone kuhóla.’ ");
INSERT INTO zin_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Náho, Ibrahímu yaámusubiza, ‘Mwáana waanze, oyizuke nkokwo okabonesa amagaambo mazima omu bulami bwaawe, na Lazáaro, akabonesa amábi. Náho óobu, weényini naahumuzwa aha, neewe nooyagalala bwooli. ");
INSERT INTO zin_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hamo na ago, hali íichwe neemwe, hatiilwého eliina liháango bwooli. Obubáho bwe eliina ni biti, áabo abalikweenda kuluga kunu kuzeenda hali íimwe, na áabo abalikweenda kuluga óokwo kwíiza hali íichwe, bataákuhicha kwaambukáho.’ ");
INSERT INTO zin_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ogwo muhíte yaágaamba, ‘Guuku, niinkusába omusiíndike azeénde omúka hali táata, ");
INSERT INTO zin_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","habwo kuba nnyinábo badugu baanze bataanu, abone kubahana bataákwiiza bakéeza kunu hali ebi byaágalazo ebisaagiliize.’ ");
INSERT INTO zin_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Náho, Ibrahímu yaámusubiza, ‘Badugu baawe, beenágo amaandiko ga Musa na ababáasi. Baléke bagahuliilize ago!’ ");
INSERT INTO zin_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Náwe yaámusubiza, ‘Mmahi, táata Ibrahímu! Náho, kábilaaba omuuntu kuluga omu bafwíile akabazeendela, niho balaátamwa ebiheno byáabo bakabilekelela no kumuhiindukila Múungu.’ ");
INSERT INTO zin_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ibrahímu yaámusubiza, ‘Abo badugu baawe, kábalaaba batagahuliliíze amaandiko ga Musa na ababáasi, tibaákubyeetaho nóobwo kayaakuba naazóoka omuuntu kuluga omu bafwíile kuzeenda kubakoonza koonza.’ ” ");
INSERT INTO zin_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeézu yaábagaambila abaheémba boómwe, “Ebileengeso ebyo bilikuleételela abaantu bakole ebiheno, nibibaho. Náho, neelóoko ogwo omuuntu alaabileételela! ");
INSERT INTO zin_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yaakuba haáchili hali weényini akomwe olubeengo omu bicha no kutubizwa omu chitubi che enyaanza, kuchila weényini kumuleételela oómo wa abato aba akole ebiheno! ");
INSERT INTO zin_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ha bwéecho, mweékomye muteéza kukola mútyo! “Omweékomye mudugu waawe kaálaakuhenela, omuháne, na kaálaasaba echiganyizi ha chiheno choómwe, omuganyile. ");
INSERT INTO zin_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nóobwo kaálaaba yaákuhenela entúlo musaanzu aha chilo chimo, na buli ntúlo naasuba hali íiwe naakugwa omu magulu aha kugaamba, ‘Onganyile,’ neewe omuganyile!” ");
INSERT INTO zin_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Niho entumwa ezo zaámugaambila Omukáma, “Mbwéenu, otwoóngele okwiikiliza kwéetu!” ");
INSERT INTO zin_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Omukáma yaábasubiza, “Kámwaakubeele no okwiikiliza kuche nóobwo nko oluzuma luche lwe ehaladáali, mwaakaágaambiile omuti ogu gwo omutini nkokwo, ‘Nyukuka ozeénde kumela omu nyaanza,’ nágwo gwaakaábakoondookiile.” ");
INSERT INTO zin_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tugaámbe oómo omuli íimwe ayina omuzáana óogwo alikulima nali naaliísa entaama. Ngási ogu omuzáana kaálikusuba omúka kuluga omu masaambo, ahonyini mukáma woómwe naahicha kumugaambila, ‘Boneka ebyookulya?’ ");
INSERT INTO zin_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mmahi! Naamugaámbila, ‘Ondoongeze ebyookulya, oyeloonze kuuntóna obuchilo ndaaba niíndya no okunywa. Niho neewe olaabona kulya no okunywa.’ ");
INSERT INTO zin_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mbwéenu! Omuzáana kaálaagakola áago omukáma woómwe yaámulagiilila, ngási ogwo mukáma naamusiima aha kugakóla? Mmahi! ");
INSERT INTO zin_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Bityo nikwo neemwe, kamulaamala kukola góona áago mwaálagilwa, mugaámbe, ‘Íichwe na abazáana kwoónka. Twaákola áago tubele nitweendélwa kukola.’ ” ");
INSERT INTO zin_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Obuchilo Yeézu akaba naazeénda Yeruzaléemu, akalabila embibi za Samaria, ne za Galiláaya. ");
INSERT INTO zin_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Echilo chimo, akataahamo omu mugoongo gúmo, yaábugana na abaantu ikúmi abeene amabéembe. Abo abeene amabéembe, baáyemeelela hala na weényini, ");
INSERT INTO zin_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","baáhámuka ahi iláka omu kugaamba, “Yeézu, Mukáma, otuganyile!” ");
INSERT INTO zin_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeézu yaábabona, yaábagaambila, “Muzeénde mweéyoleke aha bagabe ba Múungu.” Baázeenda, no obuchilo bakaba bali omu luzeendo, baáchila. ");
INSERT INTO zin_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Oómo wáabo, obuchilo káyaabweene nkokwo yaámazile kuchila, ahonyini yaásuba hali Yeézu, naamusiingiza Múungu ahi iláka liháango. ");
INSERT INTO zin_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Obuchilo yaáhikile, omu kumusiima, yáagwa buzuúma omu magulu, omu méeso ga Yeézu. No ogwo muuntu, akaba ali Omusamaria. ");
INSERT INTO zin_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeézu yaágaamba, “Léeba abaantu ikúmi bachilizwe! Mbwéenu, abo abáandi mweenda bali nkáhi? ");
INSERT INTO zin_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tihaliho abáandi áabo abaabwéenwe nibasuba kumukúza Múungu, choónka ogu omuzenyi?” ");
INSERT INTO zin_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Káandi Yeézu yaámugaambila, “Yemeelela, ozeénde. Okwiikiliza kwaawe nikwo kwaákuchiza.” ");
INSERT INTO zin_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Echilo chimo, Abafarisayo bakamubúuza Yeézu, “Obukáma bwa Múungu, nibwiíza iíli?” Yeézu yaábasubiza, “Kwíiza kwo obukáma bwa Múungu, ti kwe emanyiso éezo zilikubonwa aha méeso. ");
INSERT INTO zin_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Abaantu tibalihicha kugaamba, ‘Muléebe! Buli aha!’ nali, ‘Muléebe! Buli aho!’ Muhuliilíze, obukáma bwa Múungu buli omuli íimwe.” ");
INSERT INTO zin_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Káandi, Yeézu yaábagaambila abaheémba boómwe, “Omu bilo éebyo ebilikwiiza, mulaáligila kuleeba no óobu chilo chimo che ebilo byaanze íinye Mutábani wo Omuuntu, na timulichibona. ");
INSERT INTO zin_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Abaantu balaábagaambila, ‘Muléebe! Ngugwo aho!’ nali ‘Muléebe! Ngugu aha!’ Náho abaantu abo mutaákubeelukiilila. ");
INSERT INTO zin_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ago naábagaambila habwo kuba, echilo cho okusuba íinye Mutábani wo Omuuntu, ndyéeza nko olulábyo okwo lulabyáho bwaangu no ogwo mwaanga gumulikila enkasi zóona zi igulu. ");
INSERT INTO zin_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Náho echa mbele, ni lwaampaka Mutábani wo Omuuntu mbone ebyaágalalo bíinzi no kwáangwa na abaantu bo obuchilo óobu. ");
INSERT INTO zin_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nko óokwo byaabeelého omu bilo bya Núhu, nikwo bilibaho ebilo byo kusuba kwaanze íinye Mutábani wo Omuuntu. ");
INSERT INTO zin_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ebilo bya Núhu, abaantu bakaba nibalya no okunywa, nibasweéla no kuswéelwa, kuhicha echilo éecho Núhu yaátaahile omuli safína. Aho enzula ne enzwéelo zo kwiikisa éensi zéeza, zaábasiingaalicha abo bóona. ");
INSERT INTO zin_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“No óobu ebilo bya Lúutu, amagaambo gakaba gali gátyo nyini. Abaantu bakaba nibalya, no okunywa, nibagula no kuguza, nibalima, no kubiba embíbo, na bakaba niboombeka. ");
INSERT INTO zin_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Náho, echilo éecho Lúutu yaálugile Sodoma, omulilo muháango gwe echikwaazo gwaáseeseka nke enzula kuluga omu igulu, gwaábasiingaalicha abo bóona. ");
INSERT INTO zin_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Bityo nikwo bilaabaho echilo éecho íinye Mutábani wo Omuuntu kiíndisuúlulwa. ");
INSERT INTO zin_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Echilo echo, omuuntu aliba ali aha lugulu yo oluswi lwe nzu yoómwe, ne ebiintu byoómwe bili omu nzu, atuúke no kwiíluka kwoónka, atáza omu nzu kwiimucha chóona chóona. No omuuntu aliba ali omu musili, bityo nyini, talisuba omúka kutwáala choóna chóona. ");
INSERT INTO zin_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mwiizuke ago agaagwíile hali mukázi wa Lúutu! ");
INSERT INTO zin_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Buli muuntu óogwo alaaleengesa kuchiza obulami bwoómwe, niwe alaabubuza. Na buli muuntu óogwo alaabubuza, niwe alaabuchuúngula. ");
INSERT INTO zin_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Niimbagaambila nkokwo, omu chilo omwo, abaantu bábili balyáaba balyaamile aha chitabo chimo. Oómo aleéhibwaho no oóndi alaásigwaho. ");
INSERT INTO zin_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Echilo echo, abakázi bábili balyáaba nibasa hamo. Oómo aleéhibwaho no oóndi alaásigwaho.  ");
INSERT INTO zin_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Abaantu bábili nibaba bali omu musili, oómo aleéhibwaho no oóndi alaásigwaho.” ");
INSERT INTO zin_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Abaheémba baámubúuza, “Mukáma, ago galyáaba nkáhi?” Yaábasubiza omu mubéelo, “Buli hóona aheena emitúumbi, niho empuungu zikoba.” ");
INSERT INTO zin_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mále Yeézu yaábachwéela omugani, abone kubeéleka nka nikwo, ni lwaampaka kumuneémbelela Múungu buchiile no obutáfwa omuganya. ");
INSERT INTO zin_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yaábagaambila, “Omu muzihwa gúmo, hakaba halimo omulamuzi oómo. Omulamuzi ogwo, akaba atakutíina Múungu, nali kumusaaswa omuuntu. ");
INSERT INTO zin_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Omu muzihwa ogwo, akaba alimo omukázi oómo akaambwiile. Óogu mukázi akaba amuzeendaho ogwo mulamuzi buli ntúlo ha kumuneémbelela, kwo kumugaambila, ‘Niinsaba oómpe obuteéka ha bwaanze no omubisa waanze.’ ");
INSERT INTO zin_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Aha mwáanya mula, ogwo mulamuzi akáanga kumuhweela omukázi akaambwiile. Náho ha muheleeluko, yeégaambila omu muganya gwoómwe, ‘Íinye tiínkumutíina Múungu, nali tiínkubeétaho abaantu. ");
INSERT INTO zin_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Náho, habwo kuba ogu mukázi akaambwiile naanyagalaza yagalaza bwooli, óobu niinkola akolelwe ebimukwiile, kuba ataákuzeendelela kuúndemesa aha kuunyizaho obutóosa!’ ” ");
INSERT INTO zin_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Káandi, Omukáma yaágaamba, “Muhuliilíze kuzima amagaambo go ogwo mulamuzi omuheni! ");
INSERT INTO zin_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ngási, nikwo kugaamba Múungu, talibahweela abo abi yaatoólize, abo abalikumuhamukila nyemisana no omu chilo? Ngási, naayilililwa kubahuliiliza? ");
INSERT INTO zin_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Niimbagaambila naabahwéela bwaangu. Náho, kaándiíza íinye Mutábani wo Omuuntu, ngási, mazima ndaásaanga omu nsi bachiliho abaantu abeene okwiikiliza?” ");
INSERT INTO zin_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Káandi, Yeézu yaábachwéela omugani abaantu abáandi, áabo bakeebona nkokwo nibo abagololoke omu méeso ga Múungu, no kubagaya abáandi. Yaágaamba, ");
INSERT INTO zin_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Hakaba heenaho abaantu bábili, áabo bakahanama kuzeenda omu nzu ya Múungu ha kumusaba. Oómo akaba ali Omufarisayo, no oóndi akaba ali omuhaámbya. ");
INSERT INTO zin_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ogwo Mufarisayo yaáyemeelela, kunu naamusaba omu muganya, ‘Íiwe Múungu, niinkusiima habwo kuba íinye tiíndi nka abaantu abáandi: abanyagiilizi, abatéezi be ebisuba, nali abasiihani. Niinkusiima nkokwo íinye tiíndi nko ogu muhaámbya! ");
INSERT INTO zin_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mba ne echisiibo entúlo ibili omu bwooyo, niinkusoholeza ezáaka, eémo omuli ikúmi kuluga omu mabónwa gaanze góona.’ ");
INSERT INTO zin_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Náho ogwo omuhaámbya, yaásigala haláho, káche. Na taleénzile no óobu kwiinamula améeso goómwe omu igulu, náho yaaba naayeteéla aha kalezi koómwe aha ntíimba, aha kugaamba, ‘Múungu, onganyile íinye owe ebiheno!’ ");
INSERT INTO zin_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Niimbagaambila nkokwo, ogwo omuhaámbya akasuba omúka aganyiilwe na Múungu. Náho ogwo oóndi, mmahi! Habwe ensoonga, buli muuntu óogwo alikweékuza, alyaácheéshibwa. Na buli muuntu óogwo alikweecheesha, naakuzibwa.” ");
INSERT INTO zin_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Obuchilo obúundi, abaantu bakaba nibamuleetela Yeézu nóobu abáana báabo abato, abone kubateelaho engalo no kubáfuuha. Obuchilo abaheémba boómwe baabweene bátyo, baábaanza kubaángila abaantu abo, ha magaambo go kubachaáhukila. ");
INSERT INTO zin_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Náho, Yeézu yaábéeta hali weényini abáana abo, aha kugaamba, “Mubaleke abáana abato beéze hali íinye, mutabazibila kuunyizaho! Manya obukáma bwa Múungu no bwa abaantu abo kwiingana nka abáana aba abato. ");
INSERT INTO zin_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mazima butúnu niimbagaambila, omuuntu weéna wéena óogwo atakwiikiliza obukáma bwa Múungu nko omwaana muto, ogwo alaásíingwa kubutaahamo.” ");
INSERT INTO zin_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Omutégeki oómo, akamubúuza Yeézu, “Mweégesa omweésigwa, nkole chiíha, mbone kuhuungula obulami bwo obucha no obuchiile?” ");
INSERT INTO zin_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeézu yaámugaambila, “Ha bwaáchi noogaámba íinye ndi omweésigwa? Tihaliho omuuntu óogwo ali omweésigwa, náho Múungu weénka! ");
INSERT INTO zin_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Íiwe, noobimanya kuzima ebilagilo bya Múungu: ‘Otaákuba omusaambani, otaákwiita, otaákwiiba, otaákusiinza ebisuba, obakúze iíso na nyoko.’” ");
INSERT INTO zin_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Omutégeki yaámusubiza, “Ebilagilo ebi byóona, mbikoondoókiile kulugilila aha buto bwaanze.” ");
INSERT INTO zin_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Obuchilo Yeézu yaábihuliile ebyo, yaámugaambila, “Noobulabulilwa echigaambo echíindi chimo choónka. Ebiintu byóona éebyo oyinabyo, zeénda oze kubiguza, empilya ezo obáhe abahabi, aho noóba waázila ensabo yaawe omu igulu. Mále oyize, onkulaatile.” ");
INSERT INTO zin_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ogwo mutégeki, obuchilo yaábihuliile ebyo, akazululukilwa bwooli, habwo kuba akaba ali omuhíte bwooli. ");
INSERT INTO zin_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Obuchilo Yeézu yaámubona naazululukilwa aátyo, akagaamba, “Chilyáaba chigumile bwooli aha bahíte kuzamo omu bukáma bwa Múungu! ");
INSERT INTO zin_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Habwo kuba, chihuhuukile bwooli ha ntwaangabuleende kuhiíngula omu kahulu ko olusíinge, kusaaga omuhíte kuza omu bukáma bwa Múungu!” ");
INSERT INTO zin_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Abaantu abo kábaahuliile ago, baágaamba, “Óobu noóha mbwéenu ogwo yaakaáhicha kuchuúngulwa?” ");
INSERT INTO zin_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeézu yaábagaambila, “Amagaambo áago agatakwiíle omu baantu, hali Múungu gakwiíle.” ");
INSERT INTO zin_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Aho, Peétero yaámugaambila Yeézu, “Léeba íichwe, twaálekile ebiintu byéetu byóona, twaákukulaatila íiwe no kuba abaheémba baawe!” ");
INSERT INTO zin_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeézu yaágaamba, “Mazima butúnu niimbagaambila nkokwo, buli muuntu óogwo alekile éenzu yoómwe, nali mukázi woómwe, nali badugu boómwe, nali abazéele boómwe, nali abáana boómwe, habwo obukáma bwa Múungu, ");
INSERT INTO zin_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","amazima naayanaánkula bíinzi bwooli kuchila éebyo yaálekile, kaálikuba acháali achili omu nsi ezi. Káandi, okwo omu igulu, alaábona obulami bwo obucha no obuchiile.” ");
INSERT INTO zin_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Mala Yeézu yaábatwáala abaheémba boómwe ikúmi na bábili aha lubazu, yaábagaambila, “Muhuliilíze! Nituhanama kuzeenda Yeruzaléemu. Na aho, góona áago ababáasi baáyaandikile ha bwaánze íinye Mutábani wo Omuuntu, nigahikiílizwa. ");
INSERT INTO zin_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nibaantwáala omu ngalo za Abanyamahaánga abo nibaankola kúbi no kuundogota, no kuunchwéela amachwaánta. ");
INSERT INTO zin_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Káandi, nibaankóna enkóba no kuunyita, náho echilo cha kásatu, ndyaázooka.” ");
INSERT INTO zin_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amagaambo áago Yeézu yaábagaambiile abaheémba boómwe, tibalagamanyile. Habwo kuba ensoonga ya amagaambo ago ekaba eselekilwe hali boónyini. Tibalamanyile naahoóyela chiíha. ");
INSERT INTO zin_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeézu akaba yeéliliza Yeriko, na aha ngeégeelo yo omuháanda, hakaba heena omuhume oómo. Omuhume ogwo akaba ayikéele, naasabiliza. ");
INSERT INTO zin_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Obuchilo yaáhuliile abaantu béenzi nibahiingula aho, yaábúuza, “Heena chiíha?” ");
INSERT INTO zin_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Baámugaambila, “Yeézu Omunyanazaréeti naahiingula.” ");
INSERT INTO zin_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ahonyini, yaáhamuka ahi iláka, aha kugaamba, “Yeézu, Mutábani wa Daudi, onzilile echiganyizi!” ");
INSERT INTO zin_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Abaantu abo abaabeele beébeembiile, bakaba nibamuchaahukila ayesize. Náho weényini, yaáguma kuhamuka ahi iláka omu kumwéeta, “Mutábani wa Daudi, onzilile echiganyizi!” ");
INSERT INTO zin_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yeézu yaáyemeelela, yaálagila ogwo muhume aleétwe hali weényini. Obuchilo yaámuhika héehi, Yeézu yaámubúuza, ");
INSERT INTO zin_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nooyeénda nkukolele chiíha?” Náwe yaágaamba, “Mukáma, niinsaba mbone kuhwéeza káandi.” ");
INSERT INTO zin_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeézu yaámugaambila, “Hweéza! Okwiikiliza kwaawe nikwo kwaákuchiza.” ");
INSERT INTO zin_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ahonyini, yaáhwéeza, yaámukulaatila Yeézu, naamukuza Múungu. Abaantu bóona, obuchilo baabweene ebyo, nábo baábaanza kumukúza Múungu. ");
INSERT INTO zin_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mala Yeézu yaataahámo omuli Yeriko, ali omu kuhiíngula naazeénda. ");
INSERT INTO zin_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Omu chaalo omwo, hakaba heena omuhíte oómo, izíina lyoómwe Zakayo. Omuhíte ogwo akaba ali mukúlu wa abahaámbya. ");
INSERT INTO zin_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zakayo akaba naayeénda kuleeba Yeézu no omuuntu aliho aáta, náho talahikize kumubona, habwo kuba hakaba heena embága mpaango ya abaantu, náwe akaba ali mugufu. ");
INSERT INTO zin_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ha bwéecho yeeluka bwaangu, yaázeenda omu méeso ge embága, yaáhanama omuti gwo omukunyu, kuba ahiche kumubona Yeézu kaálaaba naahiingula omu muháanda ogwo. ");
INSERT INTO zin_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Obuchilo Yeézu yaáhikile aho, yaáleeba olugulu yo omuti, yaágaamba, “Zakayo, tuúka bwaangu! Ni lwaampaka íinye kuba omuzenyi omúka yaawe leélo.” ");
INSERT INTO zin_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ahonyini Zakayo yaátuuka, yaámwaangisa Yeézu omúka yoómwe aha manulilwa maháango. ");
INSERT INTO zin_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Abaantu bóona, obuchilo baabweene ago, baábaanza kudugulima omu kugaamba, “Léeba yaázeenda kulya no owe ebiheno!” ");
INSERT INTO zin_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Náho, Zakayo yaáyemeelela, yaámugaambila Omukáma, “Huliiliza, Mukáma! Óobu nyini, niimbáha abahabi obwaata iheembe bwe ebiintu byaanze. Na kiindaaba naáyakile omuuntu weéna wéena, niimmusubiza entúlo iína ye endeengo.” ");
INSERT INTO zin_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeézu yaágaamba, “Leélo obuchuúnguzi bwaáhika omu nzu ezi. Habwo kuba ogu náwe, yaáyoleka kuba omwaana wa mazima wa Ibrahímu, ");
INSERT INTO zin_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","habwo kuba íinye Mutábani wo Omuuntu nkeeza kuloonda no kuchuúngula abaantu áabo ababuzile.” ");
INSERT INTO zin_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kábaabeele nibahuliiliza aga, Yeézu yaázeendelela kubagaambila omugani, habwo kuba akaba yeéliliza kuhika Yeruzaléemu, abaantu bakaba nibateekuza nka nikwo obukáma bwa Múungu nibweesuúlukiza ahonyini. ");
INSERT INTO zin_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ha bwéecho, yaábagaambila, “Hakaba heenaho omuuntu oómo wo olugaanda lwo obukáma. Omuuntu ogwo, akazeenda oluzeendo kuzeenda éensi ya hala, abone kwiinaankula obutégeki bwo kuba omukáma, mále asube kutégeka éensi yoómwe. ");
INSERT INTO zin_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Acháali kulugáho, yaáyéta abazáana boómwe ikúmi, yaábaha buli oómo endeengo mpaango ye empilya zilibwiinganisa, yaábagaambila, ‘Mukole isúluza ne empilya ezi kuhika obuchilo óobwo ndaágaluka.’ ");
INSERT INTO zin_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Náho ogwo muuntu, abaantu be éensi yoómwe bakamutamwa bwooli. Baásiindika entumwa bamukulaatile no kubagaambila okwo báti, ‘Omuuntu ogu, titukweenda aábe omukáma wéetu!’ ");
INSERT INTO zin_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","No óobu bityo, akaheebwa amagala go obukáma. Obuchilo káyaasubile, omukáma yaábéeta abazáana áabo yaaheele empilya, abone buli muzáana kumugaambila yaámubonesiize nsaága chi. ");
INSERT INTO zin_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Omuhálila wa mbele yaáhika, yaámugaambila, ‘Mukáma, kwiingana ne ezo empilya éezo waándekiile, mbweene omugaso entúlo ikúmi kusáaga aho.’ ");
INSERT INTO zin_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ogwo mukáma yaámugaambila, ‘Íiwe muzáana waanze owe entúungwa nzima, okozile kuzima! Aha kuba obeele omweésigwa omu kweétegéeleza ha bíche bwooli, naákuha obutégeki aha mizihwa ikúmi.’ ");
INSERT INTO zin_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Omuhálila wa kábili náwe yaáhika, yaámugaambila, ‘Mukáma, kwiingana ne ezo empilya éezo waándekiile, mbweene omugaso entúlo itaanu kusáaga aho.’ ");
INSERT INTO zin_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Omukáma yaámugaambila, ‘Neewe, naákuha amagala ha mizihwa itaanu.’ ");
INSERT INTO zin_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Omuhálila oóndi yaáhika, yaágaamba, ‘Mukáma, empilya zaawe nzizi aha. Nkazikoma omu kasila, kuba zitaákubula. ");
INSERT INTO zin_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nkakutíina, aha nsoonga íiwe oli omuuntu wa amakaála. Nootwaála éebyo otatiílého na noogesa ahaantu hoótalahaambile chiintu.’ ");
INSERT INTO zin_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Omukáma yaámugaambila, ‘Íiwe muzáana omuheni! Óobu niinkuchwaaziíka kwiingana na amagaambo gaawe íiwe nyini. Mbwéenu okagaamba noomanya nkokwo íinye ndi omuuntu wa amakaála bwooli, niintwaála ago gi ntalatiilého, na niingesa áago ntalahaambile. ");
INSERT INTO zin_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kábilaaba nikwo bili bityo, mbwéenu ha bwaáchi tolaazisulwiize empilya zaanze okazituunda na abatuunzi, mbone kuzitwáala hamo ne ensaága yaázo obuchilo bwo kusuba kwaanze?’ ");
INSERT INTO zin_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ahonyini, yaábagaambila abaantu áabo abakaba beémeeliile aho, ‘Mumwáake ogwo empilya ezo, muzeénde kumuha óogwo ayaábonesizeho omugaso entúlo ikúmi.’ ");
INSERT INTO zin_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Náho baámugaambila, ‘Mukáma, ogu yaábonesize omugaso gwe entúlo ikúmi!’ ");
INSERT INTO zin_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Yaábasubiza, ‘Niimbagaambila nkokwo, buli muuntu óogwo alikweékomya kuzima éebyo ayinabyo, naayoongelwa ebíindi. Náho, omuuntu óogwo atakweekomya éebyo ayinabyo, no óobu echiche echa aláaba ayinacho nichitwaálwa. ");
INSERT INTO zin_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","No óobu bityo, abo ababisa baanze áabo abataleenzile íinye kubatégeka, mubaléete aha, mubeétile omu méeso gaanze!’ ” ");
INSERT INTO zin_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yeézu káyaamazile kugaamba ago, akabeébeembelela abaantu be mbága ezo yaázeendelela no oluzeendo lwoómwe lwo kuzeenda Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Obuchilo yeéliliza ebyaalo bya Betifáage na Betania, ahi ibaanga éelyo likaba nilyeétwa Emizeituni, yaábasiíndika abaheémba boómwe bábili, ");
INSERT INTO zin_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yaábagaambila, “Muzeénde omu mugoongo óogwo guli omu méeso gáanyu. No obuchilo mulaazámo omwo, nimusaánga omwaana gwe ensíkili gusibikilwe óogwo ogutakasutulaga muuntu. Mugusibule, muguléete aha. ");
INSERT INTO zin_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","No omuuntu kaálaababúuza, ‘Ha bwaáchi nimugusibula?’ Mumugaambile, ‘Omukáma wéetu naagweénda.’ ” ");
INSERT INTO zin_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mbwéenu, abaheémba abo baázeenda, baásaanga byóona bili nka nikwo Yeézu yaábagaambiile. ");
INSERT INTO zin_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Obuchilo bakaba nibagusibula ogwo mwáana gwe ensíkili, bakáma baágwo baábabúuza, “Ha bwaáchi nimugusibula ogwo mwáana gwe ensíkili?” ");
INSERT INTO zin_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Baábasúbiza, “Omukáma wéetu naagweénda.” ");
INSERT INTO zin_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Baamuleétela Yeézu ogwo mwáana gwe ensíkili, baáyala ebizwáalo byáabo aha lugulu yaágwo, mala baámuhanamika Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Obuchilo Yeézu akaba naazeénda, abaantu baáyala emyéenda yáabo omu muháanda. ");
INSERT INTO zin_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","No obuchilo yeéliliza ahaantu áaho omuháanda nigugolomoka kuluga ahi ibaanga lye Emizeituni, embága yóona ya abaheémba boómwe baábaanza kumukúza Múungu aha manulilwa, habwa amahano góona áago baabweene. Bakahamuka aha maláka gáabo, ");
INSERT INTO zin_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","omu kugaamba, “Ayina omugisa omutégeki ogwo alikwiiza ahi izíina lyo Omukáma Múungu, heena obuhóolo omu igulu, weényini óogwo ali olugulu ya byóona, ayina ikuzo lyóona!” ");
INSERT INTO zin_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Omuli ezo mbága, bakaba balimo Abafarisayo. Aho, baámugaambila Yeézu, “Mweégesa, obaángile abaheémba baawe bataákugaamba ago!” ");
INSERT INTO zin_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeézu yaábasubiza, “Niimbagaambila nka nikwo, aba kibaleésiza, mazima amabáale nigahamuka ahi iláka!” ");
INSERT INTO zin_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Obuchilo káyeeliliize omu chikaali cha Yeruzaléemu no kuchileeba, Yeézu yaábaanza kuchichulila. ");
INSERT INTO zin_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Yaáchigaambila, “Naakaáligiile bwooli leélo ezi nkokwo waakumanyile no óobu íiwe emiháanda yo kubona obuhóolo! Náho óobu eselekilwe omu méeso gaawe. ");
INSERT INTO zin_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Habwo kuba, omu bilo éebyo ebileéza, ababisa baawe balaákukuba, balaákuzoóngolokeza olukúta enkasi zóona no kukwaángila otalugamo omugati. ");
INSERT INTO zin_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nibakusiingaálichiza ahaansi íiwe na abáana baawe omugati ye ensíika zaawe na tibalileka no óobu ibáale límo olugulu ye eliindi. Ebi na habwo kuba toleenzile kumanya obuchilo óobu Múungu yaakuleétiile obuchuúnguzi!” ");
INSERT INTO zin_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mala Yeézu yaataahámo omu lubúga lwe éenzu ya Múungu okwo Yeruzaléemu, yaábaanza kubabiinga abaantu áabo bakaba nibaguza ebiintu omwo. ");
INSERT INTO zin_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yaábagaambila, “Gaandikilwe omu Maandiko Matakatíifu nka nikwo Múungu akagaamba aáti, ‘Éenzu yaanze elyáaba éenzu yo kusabilamo.’ Náho íimwe, mwaázihiindwiile kuba ‘enyaanga ya abasaakuzi.’” ");
INSERT INTO zin_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Buli chilo, Yeézu akaba naayegesa abaantu omu lubúga lwe éenzu ya Múungu. Náho abakúlu ba abagabe ba Múungu, hamo na abeégesa be ebilagilo na abanyaampala ba Abayahudi, bakaba nibaloondela akazeendele ko kumwíita, ");
INSERT INTO zin_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","náho tibalabweene olugazi lwo kukola choóna chóona, habwo kuba abaantu bóona bakaba nibahuliiliza ebigaambo byoómwe aha bweetegeeleza buháango. ");
INSERT INTO zin_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Echilo chimo, Yeézu akaba ali omu lubúga lwe éenzu ya Múungu, ali omu kubeégesa abaantu no kubagaambila Empola Nzima. Abakúlu ba abagabe ba Múungu, na abeégesa be ebilagilo, na abanyaampala ba Abayahudi ahonyini, baamwiizáho, ");
INSERT INTO zin_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","baámugaambila, “Otugaambile, ago go olikukola, noogakola aha buzizi chi? Ngási, noóha alikukuha obuzizi óobu?” ");
INSERT INTO zin_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yaábagaambila, “Neenye niimbabuúza echigaambo chimo. Muungaambile, ");
INSERT INTO zin_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","obuzizi bwa Yohana kubatiza bukaluga ahali Múungu, nali bukaluga aha baantu?” ");
INSERT INTO zin_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Aho, beégaambila, “Katulaagaámba nkokwo Múungu akamusiíndika Yohana kubatiza, naagaámba, ‘Mbwéenu, habwa chiíha timulamwiíkiliize?’ ");
INSERT INTO zin_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na katulaamusubiza nkokwo obuzizi bwoómwe bukaluga aha baantu, aho abaantu bóona nibatuhoónda na amabáale, habwo kuba nibategeza nkokwo Yohana akaba ali omubáasi.” ");
INSERT INTO zin_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Niho baálemwa, bamugalulila báti, “Titukumanya obuzizi bwoómwe bukaluga nkáhi.” ");
INSERT INTO zin_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeézu yaábagaambila, “No óobu íinye, tiínkubagaambila na aha buzizi chi niinkola amagaambo aga.” ");
INSERT INTO zin_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mala káandi, Yeézu yaázeendelela kubachwéela abaantu omugani ogu, “Hakaba heena omuuntu oómo, akabiba emizabibu omu musili gwoómwe, yaáguheélela aha balimi. Káyaabalíile, yaazila oluzeendo omu nsi ya hala, yaamaláyo okwo ebilo bíinzi. ");
INSERT INTO zin_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Obuchilo bwo kugesa kibwaahikile, yaámusiíndika omuzáana woómwe aha balimi abo, babone kumuha omugabo gwoómwe gwe ezabibu. Náho, abalimi abo baámutéela no kumusúbya engalo zili busa. ");
INSERT INTO zin_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Kanyina wo omusili, yaásiindika omuzáana oóndi. Náho náwe baámutéela no kumugóola bwooli, mala baámubíinga engalo zili busa. ");
INSERT INTO zin_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yaámusiíndika omuzáana wa kásatu. Ogwo náwe, baámuhutáaza, baámubíinga. ");
INSERT INTO zin_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ha muheleeluko, kanyina wo omusili akagaamba, ‘Mbwéenu, nzileho iínta? Entúlo ezi, niimmusiindika mutábani waanze engaanzi! Hamo lúundi ogu, nibamukúza.’ ");
INSERT INTO zin_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Náho, abo balimi kábaamubwéene, beégaambila, ‘Óogu niwe omuhuunguzi wo ogu musili. Óobu, tumwíite, obuhuunguzi bwoómwe nibuba obwéetu.’ ");
INSERT INTO zin_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Áaho, baámunaga ahéelu yo ogwo musili, baámwíita.” Niho Yeézu yaábabúuza, “Mbwéenu, ogwo kanyina wo omusili alyaábakoláho aáta abo balimi? ");
INSERT INTO zin_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Alyéeza na kubéeta abalimi abo, no omusili ogwo, yaáguheélela abaantu abáandi!” Obuchilo abaantu baáhuliile amagaambo ago, baágaamba, “Mazima! Ago gataákubáho.” ");
INSERT INTO zin_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yeézu yaábatukuliza améeso, yaábagaambila, “Mbwéenu! Geena nsoonga chi amaandiko aga? ‘Ibáale éelyo baayaángile aboómbeki, nilyo lyaahiindukile kuba ibáale igazi lyo oluhazo.’ ");
INSERT INTO zin_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Omuuntu weéna wéena óogwo aligwa ahi ibáale elyo, naasekenyuka. Káandi, óogwo ibáale lilaamugwéela, nilimusa butúnu.” ");
INSERT INTO zin_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Abo beégesa be ebilagilo na abakúlu ba abagabe ba Múungu, baásoombookelwa nka nikwo omugani ogu nigubagaámba boónyini. Bakaba nibeénda kumukwáata bwaangu ahonyini, náho bakatíina embága ya abaantu. ");
INSERT INTO zin_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ha bwéecho abatégeki ba Abayahudi, baaba nibamubaandila bwooli Yeézu, baánsiíndika abacheéngelezi. Abo bacheéngelezi, bakeekola nkokwo na abaantu abagololoke. Náho, bakaba beena ensoonga yo kumukwáasa Yeézu aha bigaambo byoómwe, babone kumukwáata no kumutwáala kulégelelwa omu butegéki bwo obuhicha bwo omwaanaángwa wa Abarúumi. ");
INSERT INTO zin_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bityo, abacheéngelezi baámubúuza, “Mweégesa, nitumanya nkokwo buli chigaambo éecho olikugaamba no kweégesa nichigasa. Íiwe tokusaaswa obukúlu bwo omuuntu, náho nooyegesa amazima ahali bóona, batuúle nka nikwo Múungu alikweenda. ");
INSERT INTO zin_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ngási! Mbwéenu, kwiingana ne ebilagilo byéetu bye Echiyahudi, nitweendélwa tusohoze oluhaambwe ahali Kaizáari, nali no omuzilo kumusoholeza?” ");
INSERT INTO zin_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ahonyini Yeézu yaámanya obugóbya bwáabo, yaábagaambila, ");
INSERT INTO zin_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nimuziinyoleke empilya ye edináali. Ensuso yo omuuntu ogu ni izíina elili ahali ezi mpilya ye edináali, ne ebyo oóha?” Baámugaambila, “Ne ebya Kaizáari.” ");
INSERT INTO zin_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yeézu yaábagaambila, “Mbwéenu, ebili bya Kaizáari, mumuhe Kaizáari, Ne bya Múungu, mubimuhe Múungu.” ");
INSERT INTO zin_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Akasubize ako ka Yeézu kaábasobela bwooli, beésiza. Bakalemwa kumukwáasa aha magaambo áago akagaamba omu méeso ga abaantu. ");
INSERT INTO zin_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mala Abasadukayo bunaanka baamwiizáho Yeézu. Abasadukayo bakaba nibeegesa nkokwo abáfwiile, mazima tibakuzooka. Baámubúuza Yeézu, ");
INSERT INTO zin_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mweégesa, Musa akatulagila omu bilagilo byoómwe nka nikwo, kábilaaba omuuntu yaáfwa no kusiga entuúmbakazi atamuzaliile omwaana, omulumuna amuhuungule ogwo ntuúmbakazi, amuzaálile abáana ayaafwíile. ");
INSERT INTO zin_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tugaámbe, bakaba baliho abadugu musaanzu be éenda eémo. Owo kubaanza aba yaákuúmpula omukázi, no kufwa atéena kuzáala náze omwaana, ");
INSERT INTO zin_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","no omudugu woómwe owa kábili yaámuhuungula náwe yaáfwa atéena kuzáala náze omwaana. ");
INSERT INTO zin_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kahaabaliile, owa kásatu, náwe yaámuhuungula ogwo mukázi, yaáfwa. Byaaba bityo nyini ahali bóona musaanzu, baámuhuungula mukázi ogwo, baáfwa batéena kusigaho abáana. ");
INSERT INTO zin_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ha muheleeluko, ogwo mukázi náwe yaáfwa. ");
INSERT INTO zin_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mbwéenu, echilo echo cho kuzooka, ogwo mukázi alyáaba muko oóha? Habwo kuba abaséeza bakaba bali musaanzu, na buli oómo akamukuúmpula!” ");
INSERT INTO zin_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeézu yaábagaambila, “Abaantu bo obuchilo óobu nibakuumpula no kukuúmpulwa. ");
INSERT INTO zin_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Náho, áabo Múungu yaábabona bakwíilwe kuzoolwa kuluga omu bafwíile no kutúula omu nsi eénsha, abo káandi tibalikuumpula, nali kukuúmpulwa. ");
INSERT INTO zin_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Na tichikwiíle nkokwo balyaáfwa káandi, habwo kuba balyáaba nka bamaléeka. Balyáaba abáana ba Múungu, aha kuba baázoolwa. ");
INSERT INTO zin_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“No óobu Musa akamanyisa abaantu nkokwo abáfwiile balaázooka. Aha mpola ye echo chisaka echaabeele nichaáka omulilo, Omukáma akagaamba nka nikwo, ‘Niwe Múungu wa Ibrahímu, Izáaka, na Yakobo.’ ");
INSERT INTO zin_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ha bwéecho, weényini ti Múungu wa abáfwiile, náho ni Múungu wa abo abali mwooyo, habwo kuba hali weényini bóona nibalama.” ");
INSERT INTO zin_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aho, abeégesa abáandi be ebilagilo baágaamba, “Mweégesa, waágaamba kuzima!” ");
INSERT INTO zin_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kubaandiza obuchilo obwo, taliho ayaaleengesize kumubúuza Yeézu amabúuzo agáandi. ");
INSERT INTO zin_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mala, Yeézu yaábabúuza abeégesa abo, “Ngási abaantu nibagaámbáho báta nkokwo Masihi ni mutábani wo omukáma Daudi? ");
INSERT INTO zin_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daudi weényini, omu chitabu che Enzina, naagaámba, ‘Omukáma Múungu akamugaambila Omukáma waanze, “Oyikále olubazu lwaanze lwo obúlyo, ");
INSERT INTO zin_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kuhika mbate ababisa baawe, iífo ya amagulu gaawe.” ’ ");
INSERT INTO zin_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Aho, Daudi naamweéta weényini, ‘Omukáma’ woómwe, ha bwéecho, naahicha aáta kuba omutábani?” ");
INSERT INTO zin_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Obuchilo abaantu be embága bakaba nibamuhuliiliza, Yeézu yaábagaambila abaheémba boómwe, ");
INSERT INTO zin_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mweélige na abeégesa be ebilagilo bya Musa. Aba nibeénda kulibata omu nsése kunu bazweele enkaanzu záabo ndeehi, no kweenda kwaángaluchwa ahi ikuzo omu magulizo. Káandi boónyini beenda kwiikala omu bitébe bya abakúlu omu masomelo. Na kabalikuba babaangisize omu mazenyi, beenda kwíikala áaho beékeele abatégeki. ");
INSERT INTO zin_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Baba nibazaáya entuúmbakazi ebiintu byáabo. Káandi, aha bugobya nibeekola kuneémbelela esaala ndeehi. Aha chilo cho omuchwaáziiko, abo nibeenaánkula omuchwaáziiko oguli muháango bwooli!” ");
INSERT INTO zin_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Omwáanya ogwo Yeézu akaba achili omu lubúga lwo omu nzu ya Múungu, naaléeba, yaábona abahíte óokwo baabeele nibatamo ebigabo byáabo omu chíibo che ebigabo. ");
INSERT INTO zin_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Káandi yaábona omuhabi oómo, ayaabeele ali entuúmbakazi, naátámo omu chíibo ehela nche ibili zoónka. ");
INSERT INTO zin_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aho, Yeézu yaágaamba, “Niimbagaambila amazima nkokwo, ogu mukázi entuúmbakazi no omuhabi, niwe yaásohoza endeengo mpaango kuchila abáandi bóona. ");
INSERT INTO zin_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Niingaámba iínti habwo kuba aba bóona, baásohoza ebigabo éebyo ne echinogóka chiche choónka cha amabonwa gáabo méenzi. Náho ogu entuúmbakazi, hamo no kuba omuhabi bwooli, yaatamo byóona éebyo alikweésiga aha bulami!” ");
INSERT INTO zin_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Omuli abo baheémba, bakaba nibahoóyelela nka nikwo éenzu ya Múungu etonilwe na amabáale maluunzi, hamo ne ebiintu byo obukaani éebyo abaantu baamusoholiize Múungu. Náho Yeézu yaágaamba, ");
INSERT INTO zin_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ebi byóona éebi mulikuleeba, haléeza ebilo éebyo tililisigalila no óobu ibáale éelyo lilisigala ha lugulu ye eliindi. Góona galyaákaambulwa!” ");
INSERT INTO zin_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Abaantu abo baámubúuza, “Mweégesa, ebigaambo ebyo bilyáabaho iíli? Ni luméenko chi óolwo lulitwooleka nka nikwo ago geéliliza kweésulukiza?” ");
INSERT INTO zin_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yaábagaambila, “Mube méeso, mutaákwiiza mukabéehwa! Abaantu béenzi baléeza ahi izíina lyaanze, buli oómo aha kugaamba, ‘Niwe íinye Masihi!’ Káandi, nibagaámba, ‘Obuchilo bwo omuheleeluko, bweéliliza!’ Abaantu abo, mutaákubakulaatila! ");
INSERT INTO zin_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","No obuchilo óobwo mluaáhulila empola zi ichúmu, no kuteeyeeka, mutaákutiina. Ago ni lwaampaka geéze ha kubaanza, náho omuhélo gwe éensi niguba gucháali kuhika.” ");
INSERT INTO zin_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yeézu yaázeendelela kugaamba, “Éensi eémo elyaálwaana ne eéndi, obukáma búmo bulaálwaana no obúundi. ");
INSERT INTO zin_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Halyaábaho okuteengeta kuháango kwe éensi, na haantu bunaanka bunaanka enzala mpaango na amalwáala mábi bwooli. No kuluga omu igulu, haalabaho ne emanyiso mpaango, na amahano go okutiínisa.” ");
INSERT INTO zin_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Náho, obuchilo ago góona gacháali kubahikaho, abaantu nibabakwaáta íimwe no kubatwáala omu masomelo ga Múungu muchwaaziíkwe, no kubaboha omu mabóhelo, omu kubaágalaza kúbi. Na nimutwaálwa omu méeso ga abakáma na abaanaángwa, habwo kuba íimwe muli abaheémba baanze. ");
INSERT INTO zin_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nibwo obuchilo mulyaábona omwáanya gwo kuunyatula. ");
INSERT INTO zin_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Ha bwéecho, mutiímbye emiganya yáanyu mutaákutahwa tahwa, mutaákuteekuza bwooli amagaambo áago mulaagaámba obuchilo bwo kweéhohoola. ");
INSERT INTO zin_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Íinye hanu, niimbáha okweétegeeleza ha magaambo áago mulaagaámba, kuhicha ababisa báanyu tibalihicha kwáanga nali kuhakana. ");
INSERT INTO zin_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Omu buchilo obwo bwo kusohozwa aha batégeki, nimunobwa no óobu na abazéele báanyu, badugu báanyu, abaantu bo olugaanda lwéenyu, na abanywáani báanyu. Omuli íimwe abáandi nimwiítwa. ");
INSERT INTO zin_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Abaantu bóona nibabatamwa habwo kuba muli abaheémba baanze. ");
INSERT INTO zin_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Náho, tikakubula nóobu akasoke kámo omu mitwe záanyu! ");
INSERT INTO zin_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na kamuleégumya, niho mulaaháabwa obulami bwo obucha no obuchiile.” ");
INSERT INTO zin_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Obuchilo mulaábona nkokwo omu chikaali cha Yeruzaléemu chaákubilwe na abalwaani bi ichúmu, niho mulaamanya nkokwo obuchilo bweéliliza áaho gulaásiisagulwa. ");
INSERT INTO zin_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aho, abo abali Yudea, beéchize aha kwiílukila omu mabaanga. Abo abali omu chikaali cha Yeruzaléemu, balugemo omwo bwaangu, na abo bali omu misili, bataákusuba omu muzihwa omu. ");
INSERT INTO zin_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ha kuba, ebilo ebyo, ne ebilo byo omuchwaáziiko, ebigaambo byóona éebyo ebyaayaandikilwe bibone kuhikiilila. ");
INSERT INTO zin_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nimwiilóoko abakázi áabo abeena éenda na áabo baláaba niboóncha abáana báabo omu bilo ebyo! Elaaba kúbi, omu nsi ezi, nihabaho ne ebyaágalalo bisaagiliize bwooli, káandi ne echihulumuko cha Múungu nichibeezila abaantu aba. ");
INSERT INTO zin_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Abaantu abáandi, balyaáyítwa aha lubáadi. Na abáandi, nibakwaátwa embohe no kutwáalwa omu nsi zóona. No omu chikaali cha Yeruzaléemu choónyini, Abanyamahaánga nibeéza no kuchitégeka, kuhika emihaanguko záabo zibe zaáhikiiliziibwe.” ");
INSERT INTO zin_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nihabaho ne emanyiso omu izóoba, omu kwéezi, ne enyeyéezi. Amahaánga góona omu nsi, galyáaba no olwaágalalo aha bwo kutahwa tahwa kwiingana no omusuumo gwo okuhilila kwa amakóonzo ge enyaanza. ");
INSERT INTO zin_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Abaantu balyaáfwa bwooli emiganya ha kweéganya kuhika nibalába kwiingana no kutegeza kusaangwa na amagaambo mábi agaleéza omu nsi. Habwo kuba, amagala go omu igulu galaázugumisibwa. ");
INSERT INTO zin_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Aho niho abaantu balaábona íinye Mutábani wo Omuuntu, niinyiza omu bwíile, nnyina obuzizi bwíinzi ni ikuzo likúlu. ");
INSERT INTO zin_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ago góona, obuchilo galaábaanza kukolwa, mwiimeelele buligi ligi mwiinamule emitwe yáanyu, habwo kuba obuchilo bwo kuchuúngulwa kwéenyu, bweéliliza!” ");
INSERT INTO zin_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mále, Yeézu yaábagaambila abaheémba boómwe omugani, aha kugaamba, “Muleebe omuti gwo omutini, ne emiti eéndi yóona. ");
INSERT INTO zin_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Obuchilo nimubona nkokwo yaábaanza kusébuka amababi, ahonyini nimumanya nkokwo obuchilo bwe echaanda bweéliliza. ");
INSERT INTO zin_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","“Nikwo bilibaho hali íimwe. Obuchilo mulaábona nkokwo áago nigabaho, niho mulaamanya nkokwo obukáma bwa Múungu bweéliliza. ");
INSERT INTO zin_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mazima butúnu niimbagaambila nka nikwo, abaantu bo obu buchilo tibakuhwaho obuchilo amagaambo ago góona gatakeésuululukiize. ");
INSERT INTO zin_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Igulu ne éensi nibihwa, náho amagaambo gaanze tigalihwa nakáti.” ");
INSERT INTO zin_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mweélige, mutaákwiiza mukalemeelelwa ne ebya katóozi, obutamiizi, no okutahwa tahwa kwo omu bulami, ne echilo echo nichibeezila bwaangu ");
INSERT INTO zin_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","echilo echo, chilyaábeefuumbukamo abaantu bóona omu nsi yóona. ");
INSERT INTO zin_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ha bwéecho, mube méeso buli káanya, omu kumusaba Múungu nkokwo mwaakaáhikize kweéliga amahano ago góona agalabagwamo kuhicha mweémeelela omu méeso gaanze íinye Mutábani wo Omuuntu.” ");
INSERT INTO zin_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Omuli ebyo bilo, nyemisana Yeézu akaba naayegesa abaantu omu lubúga lwe éenzu ya Múungu, no omu chilo, akaba naazeénda kuhunila omu ibaanga lye Emizeituni. ");
INSERT INTO zin_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Buli chilo, abaantu bóona bakaba beémuka omulucheelelélwa no kuzeenda omu lubúga lwe éenzu ya Múungu, babone kumuhuliiliza. ");
INSERT INTO zin_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Amazenyi ge emikaate éezo etatiílwémo ituumbyo, geéliliza. (Niyo elikwéetwa Paásika.) ");
INSERT INTO zin_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Abakúlu ba abagabe ba Múungu, hamo na abeégesa be ebilagilo, bakaba nibaloondela omuháanda gwo kumwíita Yeézu. Náho, bakatíina habwa abaantu. ");
INSERT INTO zin_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aho, Isitáani lyaamuzamo Yuda óogwo akaba ayétwa Iskariote, akaba ali oómo wáabo abaheémba ba Yeézu ikúmi na bábili. ");
INSERT INTO zin_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Niho, Yuda yaázeenda ha bakúlu ba abagabe ba Múungu, na ha batwaálilizi ba abalwaanila ngoma be éenzu ya Múungu. Yeehanuuza nábo nka nikwo alaamukooba Yeézu no kumusohoza hali boónyini. ");
INSERT INTO zin_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ago, gaábasemelela bwooli, baákuundilana hamo kumuliha empilya. ");
INSERT INTO zin_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda yaákúunda, ahonyini yaábaanza kuloondela omwáanya gwo kubaha Yeézu obuchilo abaantu béenzi tibaliho. ");
INSERT INTO zin_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Echilo cha mbele cha amazenyi ge emikaate éezo etatiílwémo ituumbyo, chaáhika. (Nicho echilo éecho omutaámbwa gwa Paásika guhikiiliilwe kubáagwa.) ");
INSERT INTO zin_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Niho, Yeézu kubasiíndika Peétero na Yohana, akabagaambila, “Muzeénde kutuloongeza echookulya cha Paásika, tubone kwíiza kulya hamo.” ");
INSERT INTO zin_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Baámubúuza, “Nooyeénda tuchiloongeze nkáhi?” ");
INSERT INTO zin_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yaábasubiza, “Obuchilo mlataahamo omu chikaali, nimubugana no omukwaáta oómo, ayimukize ensúha ya améenzi. Mumukulaatile muhike omu nzu éezo alataahamo, ");
INSERT INTO zin_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mumugaambile nyineéka, ‘Omweégesa naakubuúza, “Echiseenge cha abazenyi chili nkáhi, omwo ndaalya echookulya cha Paásika hamo na abaheémba baanze?” ’ ");
INSERT INTO zin_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aho, naabatwaála omu golofa, naabooleka echiseenge echiháango. Omwo nimusaánga chilóongize. Omwo nyini mutuloongezemo echookulya cha Paásika.” ");
INSERT INTO zin_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Abaheémba abo bábili, obuchilo óobu baáhuliile ebyo, baalugáho aho, baázeenda, baásaanga byóona byaábéele nka Yeézu óokwo yaábagaambiile. Baábaanza kuloonza echookulya cha Paásika. ");
INSERT INTO zin_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Akáanya ko kulya kaáhika. Niho Yeézu kwiikala ha luhelo, hamo ne entumwaze. ");
INSERT INTO zin_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yaábagaambila aáti, “Ndigiile bwooli kulya echi chookulya cha Paásika hamo neemwe ncháali ntakaágaleezwe! ");
INSERT INTO zin_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ha bwéecho niimbagaambila nkokwo, tiínkulya káandi kuhicha ensoonga yaáho yóona ehikiílizwe omu bukáma bwa Múungu.” ");
INSERT INTO zin_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ahonyini, Yeézu yeemucha echikóombe. Káyaabeele yaámazile kusiima, yaágaamba aáti, “Mutwaále ezi, munyweeleláne! ");
INSERT INTO zin_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Niimbagaambila nka nikwo, kulugilila óobu tiínkunywa káandi evíini kuhicha áaho buliíza obukáma bwa Múungu.” ");
INSERT INTO zin_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Káandi, Yeézu yeemucha omukaate. Káyaabeele yaámazile kusiima, yaágumenyula, yaábaha, ha kubagaambila, “Óogu no omubili gwaanze, ogulikusohozwa ha bwéenyu. Mube nimukola mútyo, aha kunyizuka íinye!” ");
INSERT INTO zin_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kábaabeele baámazile kulya, bityo nyini, Yeézu yeemucha káandi echikóombe echo, yaágaamba, “Evíini ezi omu chikóombe ne endagano eénsha. Múungu naagahikiíliza, habwo kuseeseka kwe enságama yaanze ha bwéenyu. ");
INSERT INTO zin_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Náho muléebe! Engalo zo óogwo alaánnoba, zili hamo neenye nitukoza hamo. ");
INSERT INTO zin_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Íinye Mutábani wo Omuuntu, niinzeénda kwíitwa, nko óokwo nkaba ndamuliilwe. No óobu bityo, neelóoko hali óogwo alaánnoba!” ");
INSERT INTO zin_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aho, entumwa za Yeézu baábaanza kweébuuza, noóha hali íichwe alihicha kukola ago. ");
INSERT INTO zin_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Haabáho empaka omu ntumwa za Yeézu, nkokwo noóha alikuteékuzwa omuli boónyini aláaba mukúlu kuchila bazeenzíbe. ");
INSERT INTO zin_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chaamukola Yeézu kubagaambila, “Abakáma ba amahaánga agáandi baba nibabatégeka abaantu báabo lwa amagala. Abo abatégeki, baba nibesiingiza nkokwo na abeetégezwa. ");
INSERT INTO zin_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Náho íimwe, mutaákuba mútyo. Omuli íimwe, omuuntu kaálaaba mukúlu kuchila abáandi, aábe nko omuuntu ali muto bwooli kuchila abáandi. Na kaálaaba naatégeka, aábe nko omuuntu ali omuzáana. ");
INSERT INTO zin_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mbwéenu! Noóha ali mukúlu bwooli? No óogwo ali aha luhelo naálya, nali óogwo alikuléeta ebyookulya? Niinzila iínti no ogwo ali aha luhelo naálya! Náho, íinye ndi ahagáti yáanyu, nko omuzáana wéenyu. ");
INSERT INTO zin_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Íimwe, omwáanya gwóona óobu mbele niindeengeswa, mubele muli hamo neenye. ");
INSERT INTO zin_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ha bwéecho, niimbakola abatégeki omu bukáma bwaanze, nko óokwo Táata waanze yaánkozile kuba omukáma. ");
INSERT INTO zin_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","No omu bukáma bwaanze, nituba nitulya ebyookulya no kunywa hamo, na nimwiikala aha bitébe byo obutégeki, nimutégeka Abaiziraeli ne engaanda záabo ikúmi ne ébili.” ");
INSERT INTO zin_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yeézu yaágaamba, “Íiwe Simoni, íiwe Simoni! Omanye kuzima nkokwo Isitáani lyeékililiziibwe kubaleengesa mwéena. Nikuba nko kweelula omuchele. ");
INSERT INTO zin_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Náho, naákusabiile hali Múungu, nkokwo otaákulekaho okwiikiliza kwaawe. Na káandi koólaaba waángwiile omu magulu, ozeénde kubaha amagala bazeenzi baawe.” ");
INSERT INTO zin_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Náho, Simoni yaámusubiza, “Íiwe, Mukáma wéetu! Íinye ndi buligi ligi kuzeenda kubohwa hamo neewe omu ibóhelo, no óobu kwíitwa hamo neewe!” ");
INSERT INTO zin_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeézu yaámugaambila, “Íiwe Peétero! Niinkugaambila nkokwo, leélo enkoókolomi tekukoókoloma, otakanyaángile entúlo isatu nka nikwo tokuúmmanya!” ");
INSERT INTO zin_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Káyaabaliile, Yeézu yaábúuza abaheémba boómwe, “Obuchilo naábasiíndikile mutéena enfulebe ye empilya, nali omugugu, nali ebilaátu, ngási mukabulilwa choóna chóona?” Baámusubiza, “Mmahi!” ");
INSERT INTO zin_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yeézu yaábagaambila, “Náho óobu, kaálaaba omuuntu ayina enfulebe ye empilya, nali omugugu, abitwáale. Na kaálaaba atéena lubáadi, aguze ebebo yoómwe, abone kulugula lúmo. ");
INSERT INTO zin_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Habwo kuba chaandikilwe, ‘Akabalwa hamo na abakola biheno.’ Ago magaambo gakaandikwa ha bwaánze. Niimbagaambila amazima iínti ni lwaampaka kuhikiilizwa hali íinye, nágo gali héehi kukolwa óobu.” ");
INSERT INTO zin_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Abo baámugaambila, “Íiwe Omukáma wéetu! Léeba! Aha heena embáadi ibili.” Náwe yaágaamba, “Mubileke ebyo.” ");
INSERT INTO zin_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeézu yaalugáho aho, yaázeenda ahi ibaanga lye Emizeituni, nko óokwo yaabele amanyiile. Na abaheémba boómwe bakaba nibamukulaatíla. ");
INSERT INTO zin_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Káyaahikile ahi ibaanga elyo, yaábagaambila, “Mumusabe Múungu, nka nikwo mutaákwiiza mukaza omu bileengeso.” ");
INSERT INTO zin_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Niho, kubaleka aho, akeelila akáanya káche, nko obula bwo kunaguza ibáale. Yaáteela ebizwi, yaámusaba Múungu aáti, ");
INSERT INTO zin_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Íiwe Táata! Koólaayeénda, onyihileho echikóombe echi cho olwaágalalo. Náho, buli éecho olikweenda íiwe, chikolwe. Náho chitaákuba éecho ndikweenda íinye!”  ");
INSERT INTO zin_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aho, maléeka kuluga omu igulu yaámwiisulukiza Yeézu, yaamutamo amagala. ");
INSERT INTO zin_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yeézu akaba ayina obusaasi bwo olwaágalalo luháango bwooli, yaáguma kumusaba Múungu aha chihika. Empiita yoómwe, yaásusana na amatoónya go obwáamba, yaaba neetoónya ahaansi omu itaka. ");
INSERT INTO zin_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Na káyaamazile kumusaba Múungu, yaáyemeelela, yéeza aha baheémba boómwe, yaábasaanga bahuniile ha kuba bakaba beene entíimba. ");
INSERT INTO zin_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yaábagaambila, “He! Ha bwaáchi muhuníile? Mwiimuke! Mumusabe Múungu, mutaákwiiza mukaza omu bileengeso.” ");
INSERT INTO zin_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Obuchilo Yeézu akaba acháali naagaámba ebyo, baamwiizáho abaantu béenzi. Abaantu aba, bakeebeembelelwa na Yuda, oómo wáabo wa abaheémba boómwe ikúmi na bábili. Niho, Yuda yaámwiililila héehi Yeézu, abone kumunyweégela. ");
INSERT INTO zin_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yeézu yaámugaambila, “Íiwe Yuda! Ngási, noomukoónga Mutábani wo Omuuntu ha kumunyweégela?” ");
INSERT INTO zin_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Abaheémba ba Yeézu, obuchilo kábaabweene okwo bilaába, baámubúuza, “Íiwe Omukáma wéetu! Ngási, tubatemaateme ne embáadi?” ");
INSERT INTO zin_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ahonyini, oómo wáabo yaámuteela omuhálila wo omugabe omukúlu no lubáadi, yaámutema okutwi kwo obúlyo. ");
INSERT INTO zin_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yeézu yaágaamba, “Mubileke ebyo!” Yaakukoláho okutwi kwo omuhálila ogwo, yaámuchiza. ");
INSERT INTO zin_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Omuli abo baantu áabo bakéeza kumukwáata Yeézu, bakaba balimo abakúlu ba abagabe ba Múungu, na abakúlu ba abasilikale be éenzu ya Múungu, hamo na abanyaampala ba Abayahudi. Yeézu yaábabúuza, “Íimwe! Ha bwaáchi mwéeza ne embáadi ne engoligo, nkoóti mweézila omunyagiilizi? ");
INSERT INTO zin_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ha bwaáchi buli chilo, tukaba nitusíiba hamo omu nzu ya Múungu, na timulaankuúmizeho! Náho óobu, nibwo obuchilo bwéenyu, obuchilo bwo okutégeka kwe ensiimbaazi.” ");
INSERT INTO zin_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ahonyini, abo baantu baámukwáata Yeézu, baámutwáala omúka yo omugabe mukúlu. Peétero yaábakulaatila haláho. ");
INSERT INTO zin_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Akáanya abo baantu baáhika ha lubuga lwe eéka, baáhéemba echikoome, beékala. Peétero náwe, yéeza omuli abo yeekala hamo nábo. ");
INSERT INTO zin_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ne echikoome echo chaámumulika, no omuzaánakazi oómo yaámuleeba ha kumukómela, yaágaamba, “Mazima ogu muuntu, akaba ali hamo náze.” ");
INSERT INTO zin_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Náho Peétero yaáyaanga, “Íiwe mukázi! Tiínkumumanya!” ");
INSERT INTO zin_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Káyaabaliile káche, omuuntu oóndi yaámubona Peétero, yaámugaambila, “Neewe oli muzeenzi wáabo.” Náho Peétero yaámusubiza, “Íiwe mwoózo! Ti íinye!” ");
INSERT INTO zin_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Káyaabeele yaáhiingwiile esáaha eémo eéti, omuuntu oóndi yaámukomeenteleza, “Omu mazima, ogu muuntu akaba ali hamo náze! Habwo kuba weényini náwe no omu Galiláaya!” ");
INSERT INTO zin_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Náho Peétero yaámusubiza, “Íiwe mwoózo! Áago olikugaamba, tiínkugamanya!” Acháali naagaámba ago, ahonyini enkoókolomi ekoókoloma. ");
INSERT INTO zin_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Omukáma yaámweechebuka, yaámuleeba Peétero aha méeso. Ahonyini, Peétero yeézuka ago magaambo go Omukáma gi yaámugaambiile, “Leélo, enkoókolomi etakakoókolomile, noóba waányogile entúlo isatu.” ");
INSERT INTO zin_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aho, Peétero yaásohola ahéelu, yaábaanza kuchula ha ntíimba na amaziga méenzi. ");
INSERT INTO zin_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Abakwaáta abo abakaba nibamweekomya Yeézu, baaba nibamusekeélela. Hamo na ago, bakaba nibamuteéla bwooli. ");
INSERT INTO zin_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Baámusweekelela aha méeso, ha kumugaambila buli ntúlo, “Gaámba obubáasi! Noóha óogwo ayaákuteela?” ");
INSERT INTO zin_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Baáguma kumuzuma ha magaambo méenzi go kulyoogweeza. ");
INSERT INTO zin_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Obuchilo bwo omulucheelelélwa, Itégekelo lya abanyaampala bóona ba Abayahudi beékobya. Omu Itégekelo éelyo hakaba heena abakúlu ba abagabe ba Múungu, na abeégesa be ebilagilo. Yeézu yaáleetwa omu méeso gáabo. Niho baámubúuza, ");
INSERT INTO zin_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Íiwe! Koólaaba níiwe Masihi, otugaambile.” Yeézu yaábasubiza, “Mazima naakubagaambíile, timwaákukuunzile. ");
INSERT INTO zin_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na kinakubabuulíze, timwaákuunsubiize. ");
INSERT INTO zin_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Náho kubaandiza óobu, íinye Mutábani wo Omuuntu niímba nnyikeele olubazu lwo obúlyo lwa Múungu wo obuzizi bwóona.” ");
INSERT INTO zin_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bóona, baámubúuza Yeézu káandi, “Ha bwéecho, íiwe oli Mutábani wa Múungu?” Yeézu yaábasubiza, “Ha bwaáchi íimwe nyini mwaágaambile nkokwo íinye níinye!” ");
INSERT INTO zin_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ahonyini, abakúlu abo baágaamba, “Mbwéenu! Nitweendela chi obwaátuzi obúundi? Léeba íichwe boónyini twaáhuliile echigaambo echi kuluga aha munwa gwoómwe weényini!” ");
INSERT INTO zin_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kábaabalíile, abakúlu abo bóona ba Abayahudi baáyemeelela, baámutwáala Yeézu hali Pontio Pilato, óogwo ayaabeele ali omwaanaángwa wo omu nsi ya Yudea. ");
INSERT INTO zin_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Baábaanza kumulegelela ha busaaye omu kugaamba, “Omuuntu ogu, twaámubona naasíisa echaalo chéetu ha kuba naayaangila abaantu nkokwo bataákutoba oluhaambwe hali Kaizáari, na naagaámba nkokwo weényini niwe Masihi, omukáma.” ");
INSERT INTO zin_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Niho, Pilato yaámugaambila Yeézu, “Ngási, níiwe omukáma wa Abayahudi?” Yeézu náwe yaágaamba, “Mbwéenu kawachegaambila íiwe nyini!” ");
INSERT INTO zin_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aho, Pilato yaábagaambila abakúlu ba abagabe ba Múungu, hamo ne echipípi cha abaantu, “Omuuntu ogu, tihaliho echiheno choóna chóona éecho naábona hali weényini.” ");
INSERT INTO zin_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Abaantu abo, baákomeenteleza kugaamba, “Léeba! Ha byeégeso byoómwe, naaleéta omusuniko ha baantu! Akabaandiza óokwo Galiláaya, na yaábisaámbeeze kuhicha éensi ezi yóona ya Yudea.” ");
INSERT INTO zin_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Obuchilo óobwo Pilato yaáhuliile ago, yaábúuza kaálaaba Yeézu no omu Galiláaya. ");
INSERT INTO zin_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na káyaamanyile nkokwo weényini no omu Galiláaya wo obutégeki bwa Herode, yaámusiíndika hali Herode habwo kuba ebilo ebyo, Herode akaba ali okwo Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Akáanya Herode yaamubwéene Yeézu, akanulilwa bwooli ha kuba akaba yaáhuliile empola zoómwe. Na ha bilo bíinzi akaba ategeza kumubona, abone kuleeba emanyiso ezo alaakola Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herode yaámubuúliliza Yeézu ha mabúuzo méenzi. Náho Yeézu talamusubiize chigaambo. ");
INSERT INTO zin_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Abakúlu ba abagabe ba Múungu na abeégesa be ebilagilo bakaba baliho, baaba nibamulégelela Yeézu kúbi. ");
INSERT INTO zin_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mara Herode na abalwaanila ngoma boómwe baábaanza kumugaya. Nibamusekeélela, baámweechuma enkaanzu nduunzi ye echikáma. Káyaabaliile, Herode yaámusubya Yeézu hali Pilato. ");
INSERT INTO zin_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na buluga echilo echo, Herode na Pilato bakaba abanywáani, náho bakaba banobeéne aha bubaandizo. ");
INSERT INTO zin_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Káyaabaliile, Pilato yaábabuganisa abakúlu ba abagabe ba Múungu, abatégeki ba Abayahudi, hamo na abaantu bo omu muzihwa. ");
INSERT INTO zin_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Yaábagaambila, “Mwaándeetela omuuntu ogu, nimugaámba nkokwo naabasunika abaantu. Mumanye kuzima nkokwo naámubuúliliize omu méeso géenyu. Na aha kulégelela kwéenyu kwóona, tihaliho echiheno choóna chóona éecho naábona hali weényini. ");
INSERT INTO zin_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Bityo Herode náwe, takachibweene echiheno hali weényini. Niyo ensoonga yaámusubya hali íichwe. Mumanye kuzima nkokwo omuuntu ogu, tihaliho echigaambo echi yaákola, éecho echihikize ayitwe! ");
INSERT INTO zin_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ha bwéecho niimmukona óobu, niho ndaámulekulila.”  ");
INSERT INTO zin_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Buli chilo chikúlu cha Paásika, Pilato akaba ayeendelwa abalekulile abaantu embóhe eémo. ");
INSERT INTO zin_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Abaantu abo bóona, baáhámuka hamo omu kugaamba, “Omwiíheho omuuntu ogu! Otuchiíngulile Baraba!” ");
INSERT INTO zin_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na Baraba ogwo, akaba abohilwe omu ibóhelo habwo kuba akaléeta omusuniko muháango omu muzihwa, no kwiita. ");
INSERT INTO zin_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato, akaba naayeénda kumulekulila Yeézu, chaaletelela káandi weényini kugaamba na abaantu abo. ");
INSERT INTO zin_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Náho, baáguma kutéela eyoombo, “Mubaámbe ha musalaba! Mubaámbe ha musalaba!” ");
INSERT INTO zin_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yaágaamba nábo káandi entúlo ya kásatu, “Íimwe mulamanya! Yaákola ntaambala chi? Ha bwaáchi tiínkabwéene echigaambo choóna chóona hali weényini éecho echihikize ayitwe! Ha bwéecho niimmukona óobu, niho nimulekulila.” ");
INSERT INTO zin_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Náho, abaantu abo baáguma kutéela eyoombo bwooli nka nikwo Yeézu abaámbwe ha musalaba. Nikwo, eyoombo záabo zaásíinga. ");
INSERT INTO zin_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Niho, Pilato yaálamula kumuchwaáziika nkokwo abakolele Abayahudi abo nka nikwo bakaba nibamusaba. ");
INSERT INTO zin_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yaábachiíngulila Baraba kwiingana no okusaba kwáabo, nóobwo akaba abohilwe habwo kuleételela omusuniko muháango omu muzihwa, no obwíisi. Yaálamula kubaha Yeézu babone kumukola nko óokwo balikweenda kwiingana no kutóonga kwáabo. ");
INSERT INTO zin_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Akáanya abalwaanila ngoma bakaba nibamutwáala Yeézu kumwíita, baábugana no omuuntu oómo, izíina lyoómwe Simoni, wo omuzihwa gwa Kurene. Ogwo Simoni, akaba naaluga omu musili. Aho, baámukwáata, baámutweeka omusalaba gwa Yeézu. Yaázeenda agwiímukize kunu naamukulaatila Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Abaantu béenzi bakaba nibamukulaatíla Yeézu. Omuli abo, abakázi bakaba nibamuchulila ha ntíimba. ");
INSERT INTO zin_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeézu yaábechebuka, yaábagaambila, “Íimwe bakázi ba Yeruzaléemu! Mutaanchulila! Náho, mweéchulilile íimwe nyini, hamo na abáana báanyu! ");
INSERT INTO zin_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mumanye ha mazima nkokwo omu bilo ebilikwiiza, abaantu nibagaámba, ‘Beena omugisa abakázi áabo bali abaguumba. Beena omugisa áabo abataloónkize!’ ");
INSERT INTO zin_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mala, balyaáhamukila amabaanga báti, ‘Mutugwéele!’ Balyaáhamukila emigoongo báti, ‘Mutusweékelele!’ ");
INSERT INTO zin_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Habwe ensoonga, kábilaaba ebyo nibikolwa ha muti mubisi, ngási nibibaho bita ha muti gwoómile?” ");
INSERT INTO zin_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ha buchilo obwo, hakaba heena abazilwa bábili. Abalwaanila ngoma bakaba nibamutwáala Yeézu na abazilwa abo, bazeénde kumwíita hamo nábo. ");
INSERT INTO zin_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Baáhika ahaantu áaho halikwéetwa “Oluhaanga lwo Omútwe,” baámubaamba Yeézu ha musalaba. Baábaamba abazilwa abo bábili, buli oómo omusalaba gwoómwe, oómo olubazu lwo omukóno gwo obúlyo gwa Yeézu, no oóndi olubazu lwoómwe lwo obumoso. ");
INSERT INTO zin_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeézu yaágaamba, “Íiwe Táata! Obaganyile! Habwo kuba aga gi balikukola, tibakugasoombookelwa.” Abalwaanila ngoma abo baáyesa olweeso lwi ibaando aha kubagana ebizwáalo bya Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Abaantu bakeemeelela áaho nibaléeba. Bakúlu ba Abayahudi, baábaanza kumugaya Yeézu omu kugaamba, “Léeba akachuúngula abáandi! Mbwéenu! Keélaaba weényini niwe Masihi óogwo ayaatooziibwe na Múungu, ayechuungule weényini!” ");
INSERT INTO zin_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abalwaanila ngoma nábo, baámugaya. Bakaba nibamwiililila, babone kumuha evíini esaankameele. ");
INSERT INTO zin_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bakasubiilila kumugaambila, “Koólaaba íiwe oli omukáma wa Abayahudi, oyechuungule íiwe nyini!” ");
INSERT INTO zin_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na aha lugulu aha mútwe gwoómwe, baatáho echibaáho cha amaandiko, gaandikilwe gáti, “ogu niwe omukáma wa abayahudi.” ");
INSERT INTO zin_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Oómo wáabo omu bazilwa abo bábili, yaámuzuma Yeézu omu kugaamba, “Ngási íiwe níiwe Masihi? Mbwéenu! Oyezune íiwe nyini! Neechwe, otuchuúngule!” ");
INSERT INTO zin_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Náho, muzeenzíwe yaámuchaáhukila ha kumukaama ha kugaamba, “Ngási, íiwe tokumutíina Múungu obuchilo neewe noochwaaziíka kufwa nka weényini? ");
INSERT INTO zin_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Náho íichwe, twaáchwaaziikwa ha mazima, kwiingana ne ebikolwa byéetu. Náho ogu, takozile echiheno choóna chóona.” ");
INSERT INTO zin_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mara, yaágaamba, “Íiwe Yeézu! Obuchilo óobwo olaazamo omu bukáma bwaawe, neenye olaanyizuka!” ");
INSERT INTO zin_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeézu yaámusubiza, “Mazima butúnu niinkugaambila, leélo ezi nituba hamo omu Butúulo bwo Kunulilwa.” ");
INSERT INTO zin_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Obuchilo nke esáaha mukáaga zíti nyemisana, haaba ne ensiimbaazi éensi yóona kuhicha esáaha mweenda, ");
INSERT INTO zin_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","habwo kuba izóoba likaláala. Ni ichiíngilizo elyaabeele lisiikile ahaantu ahatakatíifu omu nzu ya Múungu, ahonyini lyaáteemukamo ha binogóka bibili. ");
INSERT INTO zin_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Niho Yeézu yaáchula ahi iláka liháango, “Íiwe Táata! Omu ngalo zaawe naákuheéleza omwooyo gwaanze.” Káyaabeele yaámazile kugaamba aátyo, omwooyo gwoómwe gwaahwámo. ");
INSERT INTO zin_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Omwiímeelelezi wa abalwaanila ngoma abo akabona byóona éebyo ebyáagwa. Niho yaákuza Múungu omu kugaamba, “Ha mazima, omuuntu ogu takozile echiheno choóna chóona!” ");
INSERT INTO zin_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Abaantu bóona, kábaabweene ebyáagwa ebyo, baásuba omúka owáabo, nibeeteéla aha kalezi káabo aha ntíimba. ");
INSERT INTO zin_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na bóona áabo abaamumanyile Yeézu, bakaba beémeeliile haláho káche, na bakabona ebyo byóona ebyáagwa. Omuli abo abaabeele beémeeliile, bakaba balimo na abakázi áabo baabeele nibamukulaatíla kuluga omu nsi ya Galiláaya. ");
INSERT INTO zin_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Hakaba haliho omuuntu oómo, izíina lyoómwe Yozéfu, wo omu iboma lya Arimatea, omu nsi ya Yudea. Yozéfu akaba ali oómo wáabo wa abakúlu ba Abayahudi. Náho talakuundileene na bazeenzíbe ha chigaambo echo cho kumwíita Yeézu, ha kuba akaba ali omuuntu ayetegeeliize no omugololoke omu méeso ga Múungu. Na káandi akaba ategamiliile obukáma bwa Múungu bwiíze. ");
INSERT INTO zin_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Niho, Yozéfu yaázeenda kumusaba Pilato nkokwo atwaále omutúumbi gwa Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato káyekiliize, Yozéfu yaázeenda kuguhanaantula kuluga ha musalaba. Yaátaandika kuguziíngilila isáanda, káyaabaliile, yaáguziika omu mbi eyaabeele esumilwe aha luchili. Omu mbi omwo, hatakaziikilwe omuuntu weéna wéena omugati. ");
INSERT INTO zin_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Echilo echo, chikaba chili echilo cho kweéloonza. Ne echilo che Endaálikizo, chikaba chili héehi kubaanza. ");
INSERT INTO zin_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Abakázi abo abeezile hamo na Yeézu kuluga Galiláaya, baázeenda hamo na Yozéfu aha mbi. Baázibona eémbi, na nka nikwo omutúumbi gwa Yeézu óokwo gwaályaámikizwe omugati. ");
INSERT INTO zin_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kábaabalíile, baásuba omúka, baáloonza amazuta ne emizeeze. Náho baáhuumula ha chilo che Endaálikizo, nke echilagilo cha Abayahudi nko óokwo chilikulagila. ");
INSERT INTO zin_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Obuchilo bwo omulucheelelélwa echilo cha Habwooyo, abakázi abo baázeenda aha mbi. Bakaba beemukize emizeeze éezo baaloongíze. ");
INSERT INTO zin_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ne elyo ibáale liháango likaba lichiingile eémbi, baálisaanga lyaáhiliingisiibwe aha mpelo. ");
INSERT INTO zin_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Niho, baataahámo omugati. Náho baásaanga omutúumbi gwo Omukáma Yeézu, gutalimo. ");
INSERT INTO zin_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Echigaambo echi chaabaha okutahwa tahwa bwooli. Akáanya bachaáyagalala báti, ahonyini héehi nábo, baáyemeelela abakwaáta bábili, bazweele ebizwáalo bilikweela pee! ");
INSERT INTO zin_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Abakázi abo kábaabweene ebyo, baákwáatwa obutíini buháango. Beénama, kuhicha obuso bwáabo ahaansi. Náho, abakwaáta abo baábagaambila, “Kanimuloónda ali mwooyo aha bafwiile? ");
INSERT INTO zin_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Taliho káandi aha! Yaázookile! Ngási, timukwiizuka ago magaambo yaábagaambiile óobu akaba acháali Galiláaya, ");
INSERT INTO zin_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Íinye Mutábani wo Omuuntu, ni lwaampaka nsohozwe omu ngalo za abaheni, na nibaambaámba aha musalaba. No óobu bityo, echilo cha kásatu, niinzóoka!’ ” ");
INSERT INTO zin_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Abakázi abo, bageezuka ago magaambo ga Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ha bwéecho, baalugáho aha mbi. Baázeenda kugagaamba áago góona aha ntumwa za Yeézu ikúmi no oómo, hamo na bóona abáandi. ");
INSERT INTO zin_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na abakázi abo, nibo aba: Mariamu omunya Magidala, na Yoana, na Mariamu nyina wa Yakobo, hamo na abakázi abáandi áabo bakaba hamo nábo. ");
INSERT INTO zin_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Náho, káandi baágaamba éebyo byóona aha ntumwa za Yeézu, entumwa baábibona nke ebitéena ensoonga, tibalabeesigile abakázi áabo aha mpola éezo. ");
INSERT INTO zin_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ha bwéecho, Peétero yaáyemeelela ahonyini, yeeluka kuza aha mbi. Yaáhika aha mbi, yaataahámo omugati, yeénama kuleeba, yaábona isáanda éelyo baamuziikilemo Yeézu, bilimo byoónyini byoónka. Yaalugaho áaho, ali omu kusobelwa bwooli. ");
INSERT INTO zin_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ha chilo echo nyini cha Habwooyo, abaheémba bábili ba Yeézu bakaba bali omu luzeendo lwo kuzeenda omu mugoongo gwa Emau. Omutúulo ogwo, guli nko kulibata esáaha ibili zíti kuluga Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bábili abo, bakaba nibazeénda nibeeteekelela empola za amagaambo góona áago agagwiile. ");
INSERT INTO zin_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Obuchilo bakaba bacháali nibateekelela aga, Yeézu weényini yéeza, yaálibata hamo nábo. ");
INSERT INTO zin_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Baámubona, náho Múungu akabakola bataákumumanya nkokwo ni Yeézu. ");
INSERT INTO zin_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yaábabúuza, “Nimuteekelela magaambo chi kunu nimulibata?” Baáyemeelela, obuso bwáabo nibwooleka entíimba. ");
INSERT INTO zin_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Oómo wáabo, izíina lyoómwe ni Kileopa, yaámusubiza, “Ngási, omu chipípi cha abaantu bóona abaabeele bali Yeruzaléemu, níiwe weénka omuzenyi otakahuliile góona áago agagwiile aho ebilo éebi?” ");
INSERT INTO zin_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yeézu náwe yaábasubiza, “Ni magaambo chi ago?” Baámusubiza, “Íichwe nituteekelela byóona éebyo bamukolíile Yeézu Omunyanazaréeti. Abaantu bóona, no óobu na Múungu, bakabona nkokwo weényini no omubáasi, habwo kuba ebikolwa byoómwe na amagaambo goómwe gakaba geena obuhicha bwooli. ");
INSERT INTO zin_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Náho, abakúlu ba abagabe ba Múungu, na abatégeki béetu, baámusohoza, achwaaziikilwe kufwa. Kábaabalíile, baámwíita ha kumubaamba ha musalaba. ");
INSERT INTO zin_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na weényini niwe twaámutegiize nkokwo alaátuchuúngula Abaiziraeli. Náho óobu, buluga ago góona gagwíile, leélo ne echilo cha kásatu. ");
INSERT INTO zin_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Hamo ne ebyo, abáandi abakázi omuli íichwe baátukaamaaza, habwo kuba leélo obuchilo bwo omulucheelelélwa, baázeenda aha mbi, ");
INSERT INTO zin_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","baásaanga omutúumbi gutalimo omugati. Béeza kutugaambila nkokwo beesulukizwa na bamaléeka, abo baábagaambila nkokwo Yeézu ali mwooyo! ");
INSERT INTO zin_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","“Mále, abáandi omuli íichwe baázeenda aha mbi, baásaanga byóona ni nka nikwo abakázi abo baátugaambila. Nábo bityo nyini, tibalagubwéene omutúumbi.” ");
INSERT INTO zin_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yeézu yaábagaambila, “Íimwe basílu! Ha bwaáchi timukuhicha kwiikiliza buli áago gaagaambilwe na ababáasi? ");
INSERT INTO zin_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ngási, ti Masihi akaba ahikiiliilwe kulabila ebyaágalazo ebyo byóona, atakazíile omu ikuzo lyoómwe?” ");
INSERT INTO zin_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Niho, Yeézu kubasoomboolela amagaambo ago góona agaayaandikilwe ageene empoláze, kubaandiza omu Maandiko ga Musa na aga ababáasi abáandi bóona. ");
INSERT INTO zin_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Niho beeliliza omu mugoongo óogwo baabeele nibazeénda. Náwe Yeézu yeekola nka acháali naazeendelela no oluzeendo. ");
INSERT INTO zin_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Náho, baámuneémbelela bwooli, “Yikala hamo neechwe aha! Léeba ensiimbaazi neeyiza, ni izóoba lyáagwa.” Niho, Yeézu yaataahámo omu nzu, abone kwiikala hamo nábo. ");
INSERT INTO zin_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Káyaabaliile beékala hamo ha luhelo niho Yeézu yeemucha omukaate, yaásaba no kusiima, yaágumenyula, yaaba naabaha. ");
INSERT INTO zin_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ahonyini, Múungu yaábakola kumanya nkokwo ni Yeézu. Náwe ahonyini yaabahwáho aha méeso. ");
INSERT INTO zin_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Beébuuza, “Akáanya ako yaaba naagaámba gaamba neechwe omu muháanda, ha kutusoomboolela agali omu Maandiko Amatakatíifu, mbwéenu kitwaahulila nko omulilo gwaáyaka omu miganya yéetu?” ");
INSERT INTO zin_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ha buchilo obwo nyini baáyemeelela, baásuba Yeruzaléemu. Baábugana ne entumwa za Yeézu ikúmi ne eémo beékobya hamo na abáandi. ");
INSERT INTO zin_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bóona bakaba nibabagaambila bábili áabo omu kugaamba, “Na amazima nkokwo Omukáma wéetu yaázooka! Yaámweesuululukiize Simoni!” ");
INSERT INTO zin_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niho nábo kubasoomboolela bazeenzi báabo buli áago agagwiile omu muháanda. Baábagaambila nka nikwo baabweene kumumanya Yeézu obuchilo naabamenyulila omukaate. ");
INSERT INTO zin_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Obuchilo abaheémba áabo ba Yeézu bakaba bacháali bachaáhooyela empola ye éebyo, ahonyini Yeézu náwe, yaáyemeelela ahagáti yáabo. Yaábagaambila, “Mube no obuhóolo!” ");
INSERT INTO zin_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Beékaangwa, baátíina bwooli, habwo kuba bakeéteekuza nkokwo baábona omuzimu. ");
INSERT INTO zin_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Náho, Yeézu yaábagaambila, “Ha bwaáchi mwaázululukwa! Kamwaábéele ne enteenga teenga omu miganya yáanyu? ");
INSERT INTO zin_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Muundéebe emikono yaanze na amagulu gaanze, niho mumanye nkokwo níinye! Muunkúumye! Mweélebele íimwe nyini! Ha kuba omuzimu tigwíina mubili, nali amagúfa, nko óokwo mulikuleeba nnyinabyo.” ");
INSERT INTO zin_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Obuchilo Yeézu káyaamazile kubagaambila ago, yaábooleka emikono na amagulu. ");
INSERT INTO zin_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Abaheémba boómwe, bakanulilwa bwooli, kuhicha tibalakuunzile nka nikwo ebyo byóona na amazima. Baásobelwa bwooli. Niho, Yeézu yaábabúuza, “Ngási aha heena echookulya choóna chóona?” ");
INSERT INTO zin_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Baámuha echinogóka che eénfwi eyaabeele eyokizwe. ");
INSERT INTO zin_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yaáchanaánkula, yaáchilya omu méeso gáabo. ");
INSERT INTO zin_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yaábagaambila, “Obuchilo mbele nchili hamo neemwe, mbele niimbagaambila amagaambo góona áago agaándikilwe ha bwaánze ni lwaampaka gahikiilizwe: agaándikilwe omu bilagilo bya Musa, no omu maandiko ga ababáasi, no omu chitabu che Enzina.” ");
INSERT INTO zin_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aho, Yeézu yaábakola kumanya Amaandiko Matakatíifu. ");
INSERT INTO zin_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Káandi yaábagaambila, “Gaandikilwe nka nikwo, Masihi naayeéndelwa kwaágalazibwa ne echilo cha kásatu, alyaázooka kuluga omu bafwíile. ");
INSERT INTO zin_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na nka nikwo, abaantu ba amahaánga góona, kubaandiza Yeruzaléemu, boólekeélelwe nka nikwo batamwe ebiheno byáabo, babone kuganyilwa. ");
INSERT INTO zin_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Íimwe mwaáyatula amagaambo ago. ");
INSERT INTO zin_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Muléebe! Niimbasiindikila Omwooyo Mutakatíifu nka Táata waanze omulago ogwo yaabeésagiize. Náho, muliindilile omu iboma óomu kuhicha obuchilo óobwo mulaaháabwa obuzizi óobwo buleéza kuluga omu igulu.” ");
INSERT INTO zin_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Káyaabaliile, Yeézu yaábeebeembelela abaheémba boómwe kuhicha kuhika omu muzihwa gwa Betania. Akáanya kabaahikile aho, yeemucha emikonóye aha lugulu, yaábafuuha. ");
INSERT INTO zin_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Na káandi akaba acháali naabafúuha, yaábaleka, yaaba naalelema kuzeenda omu igulu. ");
INSERT INTO zin_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aho, baámulamya. Baásuba Yeruzaléemu, nibanulilwa bwooli. ");
INSERT INTO zin_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Beékala aha nzu ya Múungu, nibamukúza Múungu.");
INSERT INTO zin_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aho obwa mbele na mbele, hakaba haliho Echigaambo. No ogwo Chigaambo akaba ali hamo na Múungu, mala ogwo Chigaambo niwe akaba ali Múungu. ");
INSERT INTO zin_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kulugiilila obwa mbele na mbele, ogwo Chigaambo akaba ali hamo na Múungu. ");
INSERT INTO zin_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ebiintu byóona bikahaangwa ha kulabila hali ogwo Chigaambo. Tihaliho no óobu echiintu chimo éecho chikahaangwa hatéena weényini. ");
INSERT INTO zin_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Echigaambo ogwo akaba ali entabuko yo obulami bwóona, no obulami obwo nibwo buleeta omwaanga omu baantu. ");
INSERT INTO zin_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Omwaanga ogwo gumulika omu nsiimbaazi, mala ensiimbaazi telahikize kugusíinga. ");
INSERT INTO zin_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Akeeza omuuntu oómo óogwo akasiindikwa na Múungu. Ogwo muuntu akaba naayétwa Yohana. ");
INSERT INTO zin_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Weényini akeeza kusiinza ogwo mwaanga, kuba abaantu bóona babone kwiikiliza habwo kulabila okusiinza kwoómwe. ");
INSERT INTO zin_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana weényini akaba atali ogwo mwaanga, náho akeeza kugusiinza. ");
INSERT INTO zin_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ogu nigwo omwaanga gwa amazima, óogwo gumulikila buli muuntu, nágwo gukaba nigwiíza omu nsi ezi. ");
INSERT INTO zin_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ogwo Chigaambo niwe ayaabeele aliho omu nsi ezi éezo Múungu akahaanga habwo kulabila hali weényini. Náho, abaantu abo omu nsi ezo tibalamusoombookiilwe. ");
INSERT INTO zin_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Akeeza habwa abaantu boómwe, náho abaantu boómwe tibalamwiinaankwiile. ");
INSERT INTO zin_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Náho abaantu bóona áabo bakamunyegeza no kumwiíkiliza, abo akabaha obuhicha bwo kuba abáana ba Múungu. ");
INSERT INTO zin_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Abaazéelwe, ti habwe enságama, ti habwe engoonzi zo omubili, mala ti habwe engoonzi zo omuuntu, náho Múungu weényini niwe abakozile kuba abáana boómwe. ");
INSERT INTO zin_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mbwéenu, ogwo Chigaambo yaaba omuuntu, yeékala omuli íichwe. Neechwe twaálileeba ikuzo lyoómwe, ikuzo lyo Omutábani nyakámo we Isíichwe Múungu. Weényini ayizwiile embabazi mpaango na amazima. ");
INSERT INTO zin_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana yaámusiinza, yaáhamuka ahi iláka naagaámba aáti, “Ogu niwe óogwo nkaba niimbagaambila nka nikwo, ‘Naayiza kwiiza omuuntu oómo enyuma yaanze, óogwo ali mukúlu kusaaga íinye, habwo kuba akaba abáho obuchilo íinye ncháali ntakazeelwe.’ ” ");
INSERT INTO zin_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na habwa akalyo koómwe Múungu atuheéle íichwe twéena embabazi zoómwe, káandi naazeendelela kutuha embabazi obusáago. ");
INSERT INTO zin_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ensoonga, kala Múungu akasohoza ebilagilo byoómwe omu kulabila hali Musa, na mbwéenu asohweeze embabazi yoómwe na amazima goómwe kulabila hali Yeézu Kristu. ");
INSERT INTO zin_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Táliho omuuntu weéna wéena óogwo alahikize kumubona Múungu. Náho Omwaana nyakámo, náwe ali Múungu, mále óogwo ali héehi na Táata, óogwo niwe ayaatusuululiile. ");
INSERT INTO zin_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Echilo chimo, abatégeki ba Abayahudi bakasiindika abagabe na Abaláawi kuluga Yeruzaléemu, bazeénde ahali Yohana. Aho baámubúuza báti, “Íiwe oli oóha?” ");
INSERT INTO zin_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana yaáyatula obuumbona omu kugaamba obutazila kuseleka amazima aáti, “Íinye tiíndi Masihi.” ");
INSERT INTO zin_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Baámubúuza káandi báti, “Óobu íiwe oli oóha? Ngási, íiwe níiwe omubáasi Eliya?” Yohana yaábagalulila aáti, “Mmahi, íinye tiíndi Eliya.” Boónyini baámubúuza káandi báti, “Ngási, íiwe níiwe omubáasi óogwo tulikuliindilila kuluga ahali Múungu?” Yohana yaábagalulila aáti, “Mmahi, tíwe íinye.” ");
INSERT INTO zin_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Baámubúuza káandi báti, “Mbwéenu, íiwe oli oóha? Otugaambile tubone kuzeenda kubasoomboolela abo abaátusiindika. Íiwe noogaámba chiíha ha bwaáwe nyini?” ");
INSERT INTO zin_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana yaábagalulila kwiingana na amagaambo áago omubáasi Isaya óokwo yaágaambile, aáti, “Íinye níinye ogwo, ‘Omuuntu alikuhámuka ahi iláka liháango omu nsi yo obwoóma, nka nikwo, mugugolole omuháanda gwo Omukáma!’” ");
INSERT INTO zin_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Omu baantu áabo bakasiindikwa bazeénde ahali Yohana, bakaba balimo na Abafarisayo. ");
INSERT INTO zin_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Abo baámubúuza báti, “Kábilaaba íiwe toli Masihi, nali omubáasi Eliya, nali omubáasi óogwo tulikuliindilila kuluga ahali Múungu, na ha bwaáchi noobatiza abaantu?” ");
INSERT INTO zin_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana yaábagalulila aáti, “Íinye niimbatiza abaantu ha méenzi, náho omuli íimwe aliho omuuntu óogwo íimwe timukamusoombookiilwe. ");
INSERT INTO zin_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ogwo niwe alikwiiza enyuma yaanze. Íinye tiinkwiílwe no óobu kumusumuululila enkóba ze enkeeto zoómwe.” ");
INSERT INTO zin_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Amagaambo ago góona gakakolwa okwo Betania, obutúluka bwo omulaambo gwo omunóna gwa Yorodáani, obuchilo Yohana akaba naabatiza abaantu. ");
INSERT INTO zin_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nyeéncha eémo, Yohana yaámubona Yeézu naayiza hali weényini. Yaábagaambila abaantu áabo bakaba baliho aho aáti, “Muléebe, ogwo niwe Omutaámbwa wa Múungu, óogwo alikwiihaho ebiheno bya abaantu bóona abe éensi ezi! ");
INSERT INTO zin_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ogu niwe óogwo naábagaambiile nka nikwo, ‘Naayiza kwiiza omuuntu oómo enyuma yaanze, óogwo ali mukúlu kusaaga íinye, habwo kuba akaba abáho obuchilo íinye ncháali ntakazéelwe.’ ");
INSERT INTO zin_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","No óobu neenye nkaba ntakumusoombookelwa nka nikwo noóha, náho nkeeza kubatiza abaantu aha méenzi kuba abone kumanyiswa omu baantu ba Iziraeli.” ");
INSERT INTO zin_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Niho Yohana akabaátulila áago akaba abwéene, naagaámba aáti, “Naágubona Omwooyo nigumuhanaántukila kuluga omu igulu nke echiiba nágwo gwéeza gwaátuungama ha lugulu ya weényini. ");
INSERT INTO zin_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","No óobu neenye nkaba ntakumusoombookelwa nka nikwo noóha, náho Múungu óogwo akaansiíndika kubatiza akaba angaambíile nka nikwo, ‘Omuuntu óogwo olibona nka nikwo Omwooyo gwaanze nigumuhanaántukila aha lugulu yoómwe no kusigala náwe, ogwo niwe óogwo alaabatiza abaantu ha Mwooyo Mutakatíifu.’ ” ");
INSERT INTO zin_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aho Yohana yaámuzila aáti, “Neenye naábona ago góona, na niimmusiinza óobu nka nikwo, ogwo niwe Mutábani wa Múungu.” ");
INSERT INTO zin_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nyeéncha eémo, Yohana akaba ayemeeliile ahonyini, hamo na bábili omu baheémba boómwe. ");
INSERT INTO zin_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mála yaámubona Yeézu naahiingula héehi nábo. Niho yaábagaambila abaheémba boómwe aáti, “Muléebe, ogwo niwe Omutaámbwa wa Múungu!” ");
INSERT INTO zin_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Obuchilo abaheémba abo bábili baáhuliile ago magaambo, baámukulaatíla Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeézu yeéchebuka, yaábona abaheémba abo nibamukulaatíla. Yaábabúuza aáti, “Ngási, nimweénda chiíha?” Boónyini baámusubiza báti, “Íiwe Rabi, otuula nkáhi?” Ensoonga ye echigaambo “Rabi” no “Omweégesa.” ");
INSERT INTO zin_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yeézu yaábasubiza aáti, “Mwiíze, muhaléebe.” Niho baámukulaatíla, baázeenda baáhabóna áaho akaba atuula. Obuchilo baáhikile aho, zikaba zili esáaha ikúmi zo olweébazo, baásiiba hamo náze echo chilo. ");
INSERT INTO zin_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Oómo omu baheémba abo bábili áabo bahuliile amagaambo ga Yohana no kumukulaatila Yeézu, akaba naayétwa Andrea, mudugu wa Simoni Peétero éenda eémo. ");
INSERT INTO zin_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ahonyini azeénda kumuloondela Simoni, mweene wáabo. Obuchilo yaamubwéene, yaámugaambila aáti, “Twaámubona Masihi,” ensoonga yaáho ni “Kristu.” ");
INSERT INTO zin_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Niho Andrea yaámutwáala Simoni ahali Yeézu. Yeézu yaámuléeba Simoni, yaámugaambila aáti, “Íiwe oli Simoni, mutábani wa Yohana. Náho kubaandiza óobu, izíina lyaawe olaáyétwa Kefa.” Izíina elyo omu Chiyunani ni Peétero, ensoonga yaályo no “Oluchili.” ");
INSERT INTO zin_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nyeéncha eémo, Yeézu yaálamula nka nikwo azeénde omu nsi ya Galiláaya. Mbwéenu amusaánga Filipo, yaámugaambila aáti, “Iíza, onkulaatile.” ");
INSERT INTO zin_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo akaba ali omuuntu kuluga omu muzihwa gwa Betisaida, óomwo Andrea na Peétero nábo bakaba nibatuúla. ");
INSERT INTO zin_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Mbwéenu, Filipo yaámusaanga Natanaeli, yaámugaambila aáti, “Twaámubona omuuntu óogwo Musa akaandika empola zoómwe omu echitabu che ebilagilo, káandi óogwo ababáasi nábo bakaandika empola zoómwe. Izíina lyoómwe ni Yeézu omunya Nazaréeti, mutábani wa Yozéfu.” ");
INSERT INTO zin_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Náho Natanaeli yaámubúuza Filipo aáti, “Ngási echiintu echili chizima chikaáhichaho chita kuluga omu iboma lya Nazaréeti?” Filipo náwe yaámugalulila aáti, “Iíza, oléebe.” ");
INSERT INTO zin_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mbwéenu Yeézu yaámubona Natanaeli naamwiízáho, yaágaamba empoláze aáti, “Léeba, ogu muuntu no Omuiziraeli wa amazima, atéena enteba yoóna yóona omuli weényini.” ");
INSERT INTO zin_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaeli yaámubúuza Yeézu aáti, “Bita noomanya?” Yeézu yaámugalulila aáti, “No óobu obuchilo Filipo achaali atakakweésile, íinye nkakubona oyikeele ahaansi yo omuti gwo omutini.” ");
INSERT INTO zin_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaeli yaámugalulila aáti, “Mweégesa, íiwe oli Mutábani wa Múungu! Íiwe níiwe Omukáma wa Abaiziraeli!” ");
INSERT INTO zin_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeézu yaámubúuza aáti, “Ngási, nooyikiliza habwo kuba naákugaambila nka nikwo nkakubona obuchilo obwo oyikeele ahaansi yo omutini? Olaábona amagaambo agáandi amakúlu agasaagile aga!” ");
INSERT INTO zin_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Niho yaámugaambila aáti, “Mazima butúnu niimbagaambila nka nikwo, mulaábona igulu nilichiinguka, na mulaábona bamaléeka ba Múungu nibahanama no kutúuka hali íinye Mutábani wo Omuuntu.” ");
INSERT INTO zin_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kábyaabeele byaáhiíngwiile ebilo bibili, hakaba heena amazenyi go obweenga omu muzihwa gwa Kána, omu nsi ya Galiláaya. Ahali obwo bweenga, nyina Yeézu náwe akaba aliho. ");
INSERT INTO zin_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yeézu na abaheémba boómwe nábo bakaba balalikilwe ahali obwo bweenga. ");
INSERT INTO zin_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Obuchilo abazenyi bakaba baánywiile evíini yóona, nyina Yeézu yaámugaambila aáti, “Baáhwéelwa evíini.” ");
INSERT INTO zin_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeézu yaámugalulila aáti, “Máaha, ha bwaáchi noongaambila oótyo? Omwáanya gwo kukola emilimo yaanze gucháali kuhika.” ");
INSERT INTO zin_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Niho nyina yaábagaambila abahálila aáti, “Choóna chóona éecho alaabalagila, muchikole.” ");
INSERT INTO zin_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mbwéenu, zikaba ziliho ensúha mukáaga za améenzi éezo zikakoleswa amabáale. Abayahudi bakaba bazitamo améenzi habwo kweéyeza kwiingana no obuteéka bwáabo. Buli nsúha ekaba neeyizula nke endeengo ya amadebe ataanu nali mukáaga. ");
INSERT INTO zin_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Niho Yeézu yaábagaambila abahálila aáti, “Mwiizuze améenzi omu nsúha ezo.” Nábo baáziizuza kuhicha aha lugulu. ");
INSERT INTO zin_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Niho, Yeézu yaábalagila aáti, “Mbwéenu, mutáhe améenzi ago, muze kumuha mukúlu wa amazenyi.” Nábo baákola bátyo. ");
INSERT INTO zin_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mukúlu wa amazenyi yaáloza améenzi ago, áago gakaba gaáhiindukile kuba evíini. Talasoombookilwe áaho ekaluga ezo víini, náho abahálila áabo abatahile améenzi omu nsúha ezo bakamanya. Niho ogwo mukúlu wa amazenyi yaámweeta chisweéla. ");
INSERT INTO zin_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Obuchilo yeezile, mukúlu wa amazenyi yaámugaambila aáti, “Buli akola amazenyi ataándika kubaha abazenyi evíini éezo eli nduunzi. Niho, obuchilo abo bazenyi kábalaaba baánywiile no kuhikwa, niho eloonzwa evíini éezo eloongolweele. Náho íiwe waáléeta evíini éezo eli nduunzi aha muhélo.” ");
INSERT INTO zin_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yeézu akakola oluméenko óolu lwa mbele omu muzihwa gwa Kána omu nsi ya Galiláaya. Habwo oluméenko olwo akoóleka ikuzo lyoómwe, na abaheémba boómwe baámwiíkiliza. ");
INSERT INTO zin_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Obuchilo amazenyi go obweenga gaáhwéele, Yeézu yaágolomoka kuzeenda omu muzihwa gwa Kaperinaumu hamo na nyina, abalumuna abo obukwaáta na abaheémba boómwe. Beékala okwo ebilo bíche. ");
INSERT INTO zin_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Obuchilo echilo chikúlu cha Abayahudi éecho echilikwéetwa Paásika chikaba cheliliize, Yeézu yaáhanama kuzeenda Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mbwéenu, obuchilo yaáhikile, yaátaaha omu lubúga lwe éenzu ya Múungu, yaásaanga omwo abaantu nibaguza ente, entaama ne ebiiba, na abáandi bakaba beékeele omu meéza záabo nibahiínga empilya zo kukoza omu nzu ya Múungu. ");
INSERT INTO zin_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Obuchilo Yeézu akabona ago, yaáyogosa omusumi gwe enkóba, yaábiinga bóona abaabeele nibaguza omu lubúga lwe éenzu ya Múungu, hamo ne entaama ne ente. Káandi, yaázuumika emeéza za abo abalikuhiinga empilya, no okuzifuka empilya záabo. ");
INSERT INTO zin_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Niho yaábagaambila abaabeele nibaguza ebiiba aáti, “Mubiíheho ebiintu éebi aha! Mutaákuzikola ezi nzu ya Táata kuba igulizo!” ");
INSERT INTO zin_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Obuchilo abaheémba boómwe bahuliile ago, beézuka amagaambo áago gaandikilwe omu Maandiko Matakatíifu gáti, “Engoonzi zaanze habwe éenzu yaawe zaáyaka omuunda yaanze na niziinsiingaálicha íinye.” ");
INSERT INTO zin_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Obuchilo abatégeki ba Abayahudi baabweene áago Yeézu yaákozile, baámubúuza báti, “Nookola luméenko chi kutwoóleka nka nikwo oyina amagala go kukola amagaambo ago?” ");
INSERT INTO zin_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeézu yaábagalulila aáti, “Muzikaambagule éenzu ya Múungu ezi, neenye niinzoombéka omu bilo bísatu.” ");
INSERT INTO zin_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Niho baámusubiza báti, “Éenzu ya Múungu ezi ekoómbekwa aha myáaka makúmi aána na mukáaga! Bita íiwe noohichaho oóta kuzoómbeka omu bilo bísatu byoónka?” ");
INSERT INTO zin_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Náho Yeézu akaba atakuhooyela habwe éenzu ya Múungu yoónyini, náho akaba naahoóyela habwo omubili gwoómwe. ");
INSERT INTO zin_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ahaakulaatiile, obuchilo óobwo Yeézu yaázookile kuluga omu bafwiile, abaheémba boómwe bakeezuka amagaambo áago akagaamba. Habwo omuháanda ogwo, beekiliza Amaandiko Matakatíifu, na amagaambo áago Yeézu akagaamba. ");
INSERT INTO zin_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Obuchilo Yeézu akaba ali Yeruzaléemu aha chilo chikúlu cha Paásika, abaantu béenzi bakamwiíkiliza, habwo kuba bakaleeba eméenko éezo akaba akola. ");
INSERT INTO zin_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Náho Yeézu talabesigile, habwo kuba akabasoombookelwa bóona. ");
INSERT INTO zin_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Taleénzile omuuntu weéna wéena kumusoomboolela habwa abo baantu, habwo kuba akasoombookelwa kuzima góona áago gali omu muganya gwa buli muuntu. ");
INSERT INTO zin_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Akaba aliho omweébeembezi oómo wa Abayahudi we embága ya Abafarisayo, izíina lyoómwe Nikodemo. ");
INSERT INTO zin_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chilo chimo omu chilo, akazeenda hali Yeézu, yaámugaambila aáti, “Mweégesa, nitusoomboókelwa nka nikwo íiwe oli omweégesa óogwo osiindikilwe na Múungu, habwo kuba táliho omuuntu óogwo ayaakuhicha kukola emanyiso éezo olikukola íiwe hanu, kayaakuba Múungu atali hamo náze.” ");
INSERT INTO zin_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeézu yaámugalulila aáti, “Mazima butúnu niinkugaambila nkokwo, táliho omuuntu óogwo ayaakuhicha kutaahamo omu bukáma bwa Múungu kaálaaba atazeélwe entúlo ya kábili.” ");
INSERT INTO zin_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo yaámubúuza Yeézu aáti, “Ngási! Omuuntu yaakaáhichaho aáta kuzáalwa káandi entúlo ya kábili kunu yaákuzile yaábeele omunyaampala? Kuba, yaakaáhicha kusubamo omuunda ya nyina abone kuzaalwa káandi?” ");
INSERT INTO zin_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeézu yaámugalulila aáti, “Mazima butúnu niinkugaambila nka nikwo, táliho omuuntu óogwo yaakuhicha kutaahamo omu bukáma bwa Múungu kaálikuba atakazéelwe kwa améenzi no kwo Omwooyo. ");
INSERT INTO zin_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Omuuntu azaalwa na abazéele boómwe kwo omubili, náho Omwooyo gwa Múungu guzaala omuuntu aha mwooyo. ");
INSERT INTO zin_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Otaákusobelwa aha kuba naákugaambila nka nikwo, ‘Ni lwaampaka muzaálwe entúlo ya kábili.’ ");
INSERT INTO zin_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Omwooyo Mutakatíifu naasusana omuyaga óogwo ogulikuhéemba kwoólekela áaho gulikweenda. Okaáhicha kuhulila okuhéemba kwaágwo, náho okabula kumanya áaho gulikulugiilila no okwo áaho gulikuzeenda. Nikwo bili aha muuntu óogwo ayaazéelwe no Mwooyo.” ");
INSERT INTO zin_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo yaámubúuza Yeézu aáti, “Ngási, aga magaambo nigahichaho gáta kukolwa?” ");
INSERT INTO zin_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeézu yaámugalulila aáti, “Ngási íiwe oli omweégesa óogwo olikukuzibwa bwooli omu nsi ya Iziraeli na tokugasoombookelwa amagaambo aga? ");
INSERT INTO zin_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mazima butúnu niinkugaambila nka nikwo, íichwe tugaamba áago tulikumanya, no kusiinza áago tubweéne. Náho íimwe timukwiikiliza okusiinza kwéetu. ");
INSERT INTO zin_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mbasoombooliile empola za amagaambo áago agalikukolwa omuli ezi nsi, náho íimwe mukabula kuunyikiliza. Óobu nimuhichaho muta kuunyikiliza kaándaabasoomboolela empola za amagaambo áago agalikukolwa omu igulu? ");
INSERT INTO zin_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tábaho omuuntu óogwo alahikize kusutuka kuza omu igulu, náho íinye nyeénka Mutábani wo Omuuntu, óogwo naáhanaantukile kuluga omu igulu. ");
INSERT INTO zin_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Obuchilo Abaiziraeli bakaba bali omu nsi yo obwoóma, Musa akakola echisusano che enzóka ye esaba no kuzihanamika aha muti babone kuchila. Bityo nyini neenye Mutábani wo Omuuntu ni lwaampaka kuhanamikwa, ");
INSERT INTO zin_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kuba buli muuntu óogwo alikwiikiliza abone kuba no obulami bwo obucha no obuchiile.” ");
INSERT INTO zin_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ensoonga Múungu akabéenda bwooli abaantu bóona be éensi ezi. Niyo entaahililo akamusohoza Omutábani nyakámo kwiiza omu nsi ezi, kuba buli muuntu óogwo alikumwiíkiliza atasiingaálika, náho aábe no obulami bwo obucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Múungu talamusiindikile Omutábani omu nsi ezi abone kuchwaáziika abaantu, náho abachuúngule kulabila hali weényini. ");
INSERT INTO zin_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Múungu tachwaaziika omuuntu óogwo alikumwiíkiliza Omutábani. Náho omuuntu óogwo atakumwiíkiliza, yaáchwaaziikilwe habwo kuba takamwiíkiliize Omutábani nyakámo wa Múungu. ");
INSERT INTO zin_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","No omuchwaáziiko nigwo ogu nka nikwo, Mutábani wa Múungu aleesile omwaanga omu nsi óomu, náho abaantu beenzile kuba omu nsiimbaazi kuchila kuba omu mwaanga, habwo kuba ebikolwa byáabo ni bíbi. ");
INSERT INTO zin_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Buli muuntu weena óogwo akola ebikolwa bíbi, weényini agutamwa ogu mwaanga. Tayeénda kwíiza omuli ogu mwaanga, kuba ebikolwa byoómwe bíbi biteéza kumanywa. ");
INSERT INTO zin_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Náho abaantu bóona áabo abakola ebikolwa bya amazima, boónyini nibaloondela kuba omuli ogwo mwaanga, kuba esoombóoke nka nikwo niwe Múungu óogwo alikubaha obuhicha bwo kugakola. ");
INSERT INTO zin_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mbwéenu, kábyaahiíngwiile ebyo, Yeézu na abaheémba boómwe baásohola omu muzihwa baázeenda omu nsi ya Yudea. Yeékala hamo nábo ha mwáanya bunaanka, yaaba naabatiza abaantu. ");
INSERT INTO zin_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana náwe akaba abatiza abaantu omu byaalo bya Ainoni, héehi no omugoongo gwa Salimu. Gakaba galiyo améenzi agali méenzi okwo, na abaantu bakaba bazeenda hali Yohana náwe akaba naababatiza. ");
INSERT INTO zin_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Aha buchilo obwo, Yohana akaba atakakwaásilwe no kutéebwa omu ibóhelo. ");
INSERT INTO zin_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chilo chimo, omu baheémba ba Yohana bakazogootana no Omuyahudi oómo habwe empola zo obuteéka bwo kweéyeza. ");
INSERT INTO zin_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Niho baázeenda ahali Yohana, baámugaambila báti, “Mweégesa, nooyizuka omuuntu óogwo akaba ali hamo neewe okwo aha mulaambo gwo omunóna gwa Yorodáani no óogwo okaatula empola zoómwe? Óobu weényini náwe naabatiza, na abaantu bóona nibazeénda hali weényini!” ");
INSERT INTO zin_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana yaábagalulila aáti, “Omuuntu tiyaákuhicha kubonesa echiintu choóna chóona, kayaakuba ataheélwe na Múungu. ");
INSERT INTO zin_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Íimwe nyini ni baalusíinza baanze nkokwo naágaambile nka nikwo, ‘Íinye tiíndi Masihi, náho Múungu akaansiíndika mbone kumweébeembelela weényini Masihi.’ ");
INSERT INTO zin_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Chisweélwa ayeendelwa kuzeenda owa chisweéla. Íinye ndi nka munywáani wa chisweéla, nnyimeeliile olubazu lwoómwe na niinulilwa kaandikuhulila iláka lyoómwe chisweéla naahóoya. Mazima nikwo amanulilwa gaanze gaáhikiilizibwa. ");
INSERT INTO zin_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ni lwaampaka Yeézu agume kuba mukúlu bwooli, náho íinye kúba muto.” ");
INSERT INTO zin_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Weényini óogwo ayizile kuluga omu igulu, ali olugulu ya bóona. Weéna wéena óogwo alikuluga omu nsi, naagaámba amagaambo go omu nsi ezi. Náho óogwo alugile omu igulu, ali olugulu ya bóona. ");
INSERT INTO zin_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Weényini ayatula áago yaabwéene no kugahulila, náho táliho omuuntu óogwo alikwiikiliza okusiinza kwoómwe. ");
INSERT INTO zin_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Omuuntu weéna wéena óogwo alikwiikiliza okusiinza kwoómwe, naásuúmba nka nikwo Múungu no owa amazima. ");
INSERT INTO zin_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Óogwo akasiindikwa na Múungu agaámba amagaambo ga Múungu, na ha kuba Múungu amuha Omwooyo Mutakatíifu atéena kumuteelaho endeengo. ");
INSERT INTO zin_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Isíichwe Múungu azila engoonzi aha Mutábani, káandi amuheéle obuzizi bwa byóona. ");
INSERT INTO zin_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Omuuntu óogwo alikumwiíkiliza Mutábani wa Múungu, ogwo ayina obulami bwo obucha no obuchiile. Náho omuuntu óogwo alikumwáanga Mutábani wa Múungu, ogwo taliba no obulami bwo obucha no obuchiile, náho echihulumuko cha Múungu chilyaáguma kumubaho. ");
INSERT INTO zin_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mbwéenu, Yeézu yaáhulila nka nikwo Abafarisayo baásoombookiilwe nka nikwo, naabatiza no kubonesa abaheémba béenzi kusaaga Yohana. ");
INSERT INTO zin_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","No óobu bityo, amazima ni nka nikwo, Yeézu weényini talabatiize, náho abaheémba boómwe nibo abaabeele nibabatiza. ");
INSERT INTO zin_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mbwéenu, Yeézu káyaahuliize aátyo, yaalugáho omu nsi ya Yudea, yaásuba omu nsi ya Galiláaya. ");
INSERT INTO zin_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Obuchilo akaba naazeénda okwo Galiláaya, ekaba eli lwaampaka ahiingule Samaria. ");
INSERT INTO zin_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mbwéenu, baáhika omu muzihwa gúmo gwa Samaria óogwo gukaba nigweétwa Sikari. Omuzihwa ogwo, gukaba guli héehi no musili óogwo Yakobo akaha obuhuunguzi mutábani Yozéfu. ");
INSERT INTO zin_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Aho niho likaba lili iziba lya Yakobo. Náwe Yeézu aba yeékala aho aha mpelo ye elyo iziba abone kuhuúmula, kuba akaba ayina obulemwa habwo oluzeendo. Ekaba lili iháangwe lya nke esáaha mukáaga zíti. ");
INSERT INTO zin_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mala, omukázi oómo omu Samaria yaáhika aho ahi iziba kutáha améenzi. Yeézu yaámugaambila aáti, “Niinsaba, oómpe améenzi mbone kunywa.” ");
INSERT INTO zin_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ogwo mwáanya, abaheémba boómwe Yeézu bakaba baázeenzile omu muzihwa kuza kugula ebyookulya. ");
INSERT INTO zin_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mbwéenu, ogwo Omusamariakazi aba yaámugalulila aáti, “Íiwe oli Omuyahudi, neenye ndi Omusamariakazi. Ngási noohichaho oóta íiwe kuúnsaba íinye nkúhe améenzi?” Akagaamba aátyo, habwo kuba Abayahudi bakaba batakobana na Abasamaria. ");
INSERT INTO zin_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeézu yaámugalulila aáti, “Káwaakubeele waásoombookiilwe engabilano éezo Múungu alikweenda kukúha, mala káandi okahicha kusoombookelwa nkokwo noóha óogwo alikukuseega améenzi, waakubeele waánsabile, neenye naakaákuhéele améenzi áago agatuha obulami.” ");
INSERT INTO zin_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Omukázi ogwo yaámugalulila Yeézu aáti, “Mukáma, íiwe toyina no óobu echitahiso, mále káandi eli iziba ni lila, noogataábuuza nkáhi ago méenzi agatuha obulami? ");
INSERT INTO zin_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Isíichwe enkúlu Yakobo weényini niwe akatuha eli iziba, na weényini nyini akaba anywa aga méenzi gaályo hamo na abáana boómwe ne ebituungaánwa byoómwe. Óobu ngási íiwe, nooyebona nka nikwo íiwe oli mukúlu bwooli kusaaga weényini?” ");
INSERT INTO zin_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Niho Yeézu yaámugalulila aáti, “Buli oómo óogwo alikunywa aga méenzi aga agalikuluga omuli eli iziba, naahulila iliho káandi na káandi. ");
INSERT INTO zin_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Náho omuuntu óogwo alaanywa améenzi áago ndaamuha íinye, talihulila iliho káandi obucha no obuchiile. Habwo kuba améenzi áago ndaamuha, nigahiinduka kuba nke enzwéelo za améenzi ezili omuli weényini, nayo elyáaba neézwa ha kumuha obulami bwo obucha no obuchiile.” ");
INSERT INTO zin_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Niho ogwo mukázi aba yaámugaambila Yeézu aáti, “Mukáma, oómpe ago méenzi, neenye ntalihulila iliho, na káandi ntálíiza aha káandi kwiiza kutáha aga méenzi omuli eli iziba.” ");
INSERT INTO zin_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeézu yaámugalulila aáti, “Zeénda omwéete bálo, oyize náze aha.” ");
INSERT INTO zin_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ogwo mukázi amugalulila aáti, “Íinye tiinyina ibáanye.” Yeézu náwe yaámusubiza aáti, “Waágaamba amazima nka nikwo íiwe toyina bálo, ");
INSERT INTO zin_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","habwo kuba waámazile kwiikala na abaséeza bataanu, no ogwo muséeza óogwo olikwiikala náze óobu, ti bálo. Aho waágaamba amazima.” ");
INSERT INTO zin_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ogwo mukázi yaámugalulila Yeézu aáti, “Mukáma, niimbóna nka nikwo íiwe oli omubáasi. ");
INSERT INTO zin_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Besiichwe enkúlu bakaba nibamulámya Múungu omuli eli ibaanga lya Gerizimu, náho íimwe Abayahudi nimugaámba ni lwaampaka tuzeénde kumulámya Múungu omuli Yeruzaléemu.” ");
INSERT INTO zin_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeézu yaámugalulila ogwo Omusamariakazi aáti, “Onyikilize, obuchilo nibwiíza óobwo mulibulwa kumulamya Isíimwe omuli eli ibaanga nali okwo omuli Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Íimwe Abasamaria nimumulamya óogwo mutakumusoombookelwa. Náho íichwe Abayahudi nitumulamya óogwo tulikusoombookelwa, habwo kuba obuchuúnguzi bwa abaantu bóona nibwiíza kulabila aha Bayahudi. ");
INSERT INTO zin_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Náho obuchilo nibwiíza, mále bwaáhikile, óobwo abaantu áabo abalikweenda kumulámya Isíichwe Múungu aha mazima, balaámulamya aha Mwooyo na amazima. Ha bwéecho Isíichwe Múungu naaloondela abaantu nka abo babone kumulamya. ");
INSERT INTO zin_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Múungu no Omwooyo. Abaantu áabo abalikumulámya, ni lwaampaka babe nibamulámya aha Mwooyo na aha mazima.” ");
INSERT INTO zin_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ogwo mukázi yaámugaambila Yeézu aáti, “Niinsoomboókelwa nka nikwo Masihi naayiza, óogwo alikwéetwa Kristu. Mala niinsoomboókelwa nka nikwo, obuchilo óobwo aleéza, alaátusoomboolela buli chiintu.” ");
INSERT INTO zin_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Niho Yeézu yaámugalulila aáti, “Íinye, óogwo alikuhooya neewe níinye Masihi.” ");
INSERT INTO zin_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mala, obuchilo obwo nyini, abaheémba boómwe nábo baba baásuba. Baásobelwa bwooli kusaanga Yeézu naahóoya no omukázi. Náho talabeeleho no óobu oómo ayaábuúlize aáti, “Nooyeénda chiíha hali weényini?” nali aáti, “Ha bwaáchi noohóoya no omukázi?” ");
INSERT INTO zin_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Niho, ogwo mukázi aba yaásigaho aho ensúha yoómwe ya améenzi, aba yaátayo kuzeenda omu muzihwa. Kayaahikileyo okwo, yaágaambila abaantu nka nikwo, ");
INSERT INTO zin_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tuzeénde, muze kumubona omuuntu óogwo ayaángaambila amagaambo góona áago ndakozile! Ngási, tibyaakuba nka nikwo ogwo niwe Masihi?” ");
INSERT INTO zin_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Obuchilo abaantu bahuliile ago, baásohola kuluga omuli ogwo muzihwa, baamuzaho Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Obuchilo abaantu abo bakaba batakahikile hali Yeézu, abaheémba boómwe bakaba nibamutoozela Yeézu báti, “Mweégesa, noólye echookulya.” ");
INSERT INTO zin_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Náho weényini yaábagalulila aáti, “Íinye nnyina echookulya éecho mutakusoombookelwa íimwe.” ");
INSERT INTO zin_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Niho abaheémba boómwe kutaándika kweébuuza báti, “Ngási, heena omuuntu óogwo yaámuléetela ebyookulya?” ");
INSERT INTO zin_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeézu yaábagalulila aáti, “Echookulya chaanze no kukola áago alikweenda óogwo akaansiíndika, no kuguhikiiliza omulimo gwoómwe. ");
INSERT INTO zin_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Íimwe mumanyiile kugaamba nka nikwo, ‘Haásigeele améezi aána goónka kuhika obuchilo bwi igesa.’ Náho íinye niimbagaambila nka nikwo, muléebe amasaambo óokwo gali, gaáyelize ebyookulya, nágo galiindiliile kwoónka kugeswa. ");
INSERT INTO zin_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Omugesi naabonesa empeéla yoómwe, no okusuumbya ebigesizwe habwo obulami bwo obucha no obuchiile. Bityo, omubíbi no omugesi, bóona nibabona kunulilwa hamo. ");
INSERT INTO zin_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ha bwéecho gubaho omugani ogwa amazima ogugaamba nka nikwo, ‘Omuuntu oómo abiba, no oóndi agesa.’ ");
INSERT INTO zin_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Íinye nkabasiíndika íimwe mubóne kugesa áago mutalayagalaliile. Abaantu abáandi bakaágalala ha kukola emilimo yóona, neemwe nimubonesa omugaso gwe emilimo yáabo.” ");
INSERT INTO zin_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mbwéenu, Abasamaria béenzi omu muzihwa ogwo, baámwiíkiliza Yeézu, habwo kuba bakahulila obuumbona bwo ogwo mukázi báti, “Omuuntu ogwo yaángaambila amagaambo góona áago ndakozile.” ");
INSERT INTO zin_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Niho Abasamaria baáhika áaho akaba aáli Yeézu, baámutoózela bwooli ayikále hamo nábo. Niho yeékala omuli ogwo muzihwa ebilo bibili. ");
INSERT INTO zin_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Abaantu béenzi bwooli baámwiíkiliza Yeézu habwe empola éezo akaba naabagaambila. ");
INSERT INTO zin_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Baámugaambila ogwo mukázi báti, “Echo kubaanza twaámwiikiliza ogu muuntu, habwa áago waátugaambila íiwe. Náho óobu íichwe nyini nitumwiikiliza habwo kuba twaámuhulila áago alikugaamba. Óobu nitusoomboókelwa butúnu nka nikwo, ogu muuntu mazima niwe Omuchuúnguzi we éensi.” ");
INSERT INTO zin_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kábyaabele byaáhiíngwiile ebilo bibili, Yeézu aba yaalugáyo okwo, yaazila oluzeendo kuza omu nsi ya Galiláaya. ");
INSERT INTO zin_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yeézu akaba agaambile aáti, “Omubáasi tahaabwa ikuzo na abaantu bo omu muzihwa gwo owaabo.” ");
INSERT INTO zin_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Obuchilo yaahikileyo okwo Galiláaya Abagaliláaya béenzi baámunyegeza, habwo kuba boónyini nábo bakaba baliyo okwo omu mazenyi ga Paásika na bakaba baabweene góona áago Yeézu akakola okwo Yeruzaléemu omu buchilo bwa ago mazenyi. ");
INSERT INTO zin_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yeézu yaázeenda káandi omu muzihwa gwa Kána yo okwo Galiláaya, áaho yaáhiindwiile améenzi kuba evíini. Mbwéenu, akaba aliho omutwaáliliza oómo we chikáma kuluga omu muzihwa gwa Kaperinaumu. Ogwo mutwaáliliza akaba ayina omutábani omúka yoómwe, ogwo mutábani akaba ali omulwéele. ");
INSERT INTO zin_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mbwéenu ogwo mutwaáliliza káyaahuliize nka nikwo Yeézu yaásubile kuluga Yudea ali Galiláaya. Yaázeenda hali Yeézu no kumuneémbelela nka nikwo azeénde Kaperinaumu, abone kuza kumuchiza omutábani, habwo kuba akaba ali omulwéele ali aha chihalala. ");
INSERT INTO zin_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeézu yaámugalulila aáti, “Íimwe, kamulikubula kubona emanyiso na amahano, buzima timukwiikiliza!” ");
INSERT INTO zin_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ogwo mutwaáliliza yaámugalulila Yeézu aáti, “Mukáma, niinkusába, tuzeénde ha mutábani waanze, achaali atákafwíile.” ");
INSERT INTO zin_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Náho Yeézu yaámugalulila aáti, “Zeénda, mutábani waawe yaáchizile.” Ogwo mutwaáliliza aba yaágeékiliza ago magaambo ga Yeézu áago akamugaambila, yaalugáho, aba yaatáyo. ");
INSERT INTO zin_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nyeéncha eémo, obuchilo akaba achaali achili omu muháanda achaágolomoka kutaaha, aba yaábugana na abazáana boómwe, nábo baba baámusoomboolela nka nikwo, mutábani woómwe yaáchizile. ");
INSERT INTO zin_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Niho náwe aba yaábabúuza ako kaziingo áako yabaandiizémo kweéhulila enziingo zoómwe. Nábo baámusubiza báti, “Omuswíiza gumulekuliile kubaandiza nyeénchilo, esáaha musaanzu omu iháangwe.” ");
INSERT INTO zin_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mbwéenu, iíse wo ogwo musígazi aba yaásoombookelwa nka nikwo, yaáchila kubaandiza áako kaziingo nyini áako Yeézu akagaamba aáti, “Mutábani waawe yaáchizile.” Áaho ogwo mutwaáliliza hamo na abaantu bóona bo omúka yoómwe, baba baámwiíkiliza Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Óolu lukaba luli oluméenko lwa kábili óolwo Yeézu akakola omu nsi ya Galiláaya, obuchilo yaabele yaásubile kuluga omu nsi ya Yudea. ");
INSERT INTO zin_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kágaabeele ago gaáhwéele, Yeézu yaázeenda Yeruzaléemu omu mazenyi ga Abayahudi. ");
INSERT INTO zin_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Okwo omuli Yeruzaléemu, hakaba heenamo iléembo liháango éelyo likaba nilyeétwa, “Iléembo lye Entaama.” Héehi ne elyo iléembo, hakaba heena iláambo, elyo iláambo likaba lyéetwa omu izíina lyo olulími lwe Echihebrania, liti, Beetizata. Iláambo elyo likaba lizoongolokilwe na amakulato ataanu áago gakaba geena enyomyo. ");
INSERT INTO zin_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Omuli ago makulato, bakaba balyaamamo abalwéele béenzi, nka abahume, enziíngami, na áabo abalageele. Bakaba baliindiliile améenzi gabulaangulwe, ");
INSERT INTO zin_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ha kuba hakaba haazila omwáanya óogwo maléeka wa Múungu akaba atúuka, aza omuli elyo iláambo no kugabulaangula améenzi. Omulwéele óogwo akaba aba owo kubaanza ha kuzamo omu méenzi kagalikuba gaábulaangwiilwe, ogwo mulwéele akaba achila endwáala yoóna yóona éezo akaba ayina. ");
INSERT INTO zin_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Omuli abo nyini, akaba alimo omuuntu oómo óogwo ayaabeele ali omulwéele aha mwáanya gwe emyáaka makúmi asatu na munáana. ");
INSERT INTO zin_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Niho Yeézu kumubona ogwo muuntu alyaamile aho. Yaaba yaásoombookelwa nka nikwo yaalalweele omwáanya mula, yaámubúuza, “Ngási, nooyeénda kuchila?” ");
INSERT INTO zin_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ogwo mulwéele yaámugalulila Yeézu aáti, “Mukáma, íinye tiinyina omuuntu wo kuúnzuna kutaahámo omu iláambo obuchilo améenzi nigabulaángulwa. Buli kiindikweenda kutaahamo, omuuntu oóndi naayaanguha kuunyibeembela kuzamo.” ");
INSERT INTO zin_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Niho Yeézu aba yaámugaambila aáti, “Yemeelela, yimucha omukeeka gwaawe, olibate.” ");
INSERT INTO zin_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ahonyini, ogwo muuntu aba yaáchila, yeemucha omukeeka gwoómwe, yaábaanza kulibata. Náho echigaambo echi chikakolwa aha chilo che Endaálikizo. ");
INSERT INTO zin_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ha bwéecho, abatégeki ba Abayahudi baámugaambila omuuntu óogwo ayaáchilizwe báti, “Leélo ne echilo che Endaálikizo, ebilagilo byéetu tibikukukuundila kusutula omukeeka gwaawe.” ");
INSERT INTO zin_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Náho yaábagalulila aáti, “Omuuntu óogwo ayaánchíza, niwe ayaángaambila nka nikwo, ‘Sutula omukeeka gwaawe, olibate.’” ");
INSERT INTO zin_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Abo batégeki baámubúuza báti, “Ngási, ogwo muuntu ayaákugaambila kukola oótyo, noóha?” ");
INSERT INTO zin_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Náho weényini talamusoombookilwe óogwo ayaamuchilize, habwo kuba Yeézu akaba yaámazile kulugáho aho, kuba hakaba heena embága mpaango ya abaantu. ");
INSERT INTO zin_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Káyaabeele yaámazile ebyo, Yeézu yaáza omu nzu ya Múungu, yaamusaangamo ogwo muuntu ayaáchilizwe náwe, mala aba yaámugaambila aáti, “Huliiliza, óobu waáchila enziingo zaawe. Otasubila káandi kuhena, oteéza okazila entaambala esagiliize.” ");
INSERT INTO zin_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mala, ogwo muuntu aba yaáza aha batégeki ba Abayahudi, yaábagaambila nka nikwo ni Yeézu ayaámuchiza. ");
INSERT INTO zin_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Niho Abayahudi baábaanza kumwaágalaza Yeézu, habwo kuba akaba yaáchiza omuuntu ha chilo che Endaálikizo. ");
INSERT INTO zin_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Náho Yeézu yaábagaambila aáti, “Táata naakola emilimo buchiile, neenye niinkola iíntyo nyini.” ");
INSERT INTO zin_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Habwa ago amagaambo, abatégeki ba Abayahudi baayomaho omu kuloondela omuháanda gwo kumwíita Yeézu. Bakaba nibeénda kukola bátyo, ti habwo kuba Yeézu akaba naahenela echilo che Endaálikizo kwoónka, náho habwo kuba akaba naagaámba nka nikwo, Múungu ni Iíse. Habwo kugaamba aátyo, baábona naayekola nka nikwo ali nko óokwo aáli Múungu. ");
INSERT INTO zin_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeézu yaábagaambila abo batégeki aáti, “Mazima butúnu niimbagaambila nka nikwo, Mutábani wa Múungu tiyaákuhicha kukola choóna chóona habwo obuzizi bwoómwe weényini. Naahicha kukola kwoónka éecho alikubona nichikolwa ne Iíse. Kuba éecho alikukola Iíse, no Omutábani náwe achikola aátyo nyini. ");
INSERT INTO zin_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Táata ayina engoonzi no Omutábani, na naamwooleka buli chóona éecho alikukola weényini. Káandi, alaámwooleka amagaambo makúlu kusáaga aga, kuba íimwe mubóne kusobelwa bwooli. ");
INSERT INTO zin_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nko óokwo Táata azóola abáfwiile no kubabonesa obulami, bityo nyini Omutábani náwe ababonesa obulami abaantu áabo alikweenda. ");
INSERT INTO zin_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Táata tachwaaziika muuntu, náho aheéle Omutábani obuzizi bwóona bwo kuchwaáziika abaantu. ");
INSERT INTO zin_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Habwo ogwo muháanda, abaantu bóona nibamukúza Omutábani nko óokwo balikumukúza Iíse. Omuuntu óogwo atakumukúza Omutábani, ogwo takumukúza Iíse óogwo akamusiíndika. ");
INSERT INTO zin_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mazima butúnu niimbagaambila nka nikwo, omuuntu óogwo alikuhulila amagaambo gaanze, akageékomya no kumwiíkiliza Múungu óogwo akaansiíndika, ogwo muuntu ayina obulami bwo obucha no obuchiile. Ogwo muuntu mazima talichwaaziikwa, náho yaáyaambukile kuluga omu lufu no kuza omu bulami bwo obucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mazima butúnu niimbagaambila nka nikwo, obuchilo nibwiíza, káandi no obwo buchilo bwaáhikile, nka nikwo abáfwiile balaáhulila iláka lya Mutábani wa Múungu. Mala abo baantu abaliba nibahulila, balaázila obulami bwo obucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nko óokwo Táata ali entabuko yo obulami bwo bucha no buchiile, nikwo bityo nyini yaámuhiíliile Omutábani kuzila entabuko yo obwo bulami. ");
INSERT INTO zin_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Káandi, amuheéle Omutábani obuzizi bwo kuchwaáziika abaantu, habwo kuba weényini niwe Mutábani wo Omuuntu. ");
INSERT INTO zin_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ago magaambo mutaákusobelwa! Niheéza akaziingo áako bóona áabo abáfwiile balaáhulila iláka lya Mutábani wo Omuuntu, ");
INSERT INTO zin_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nábo balaázooka no kuluga omu bitúulo. Abaantu abaabeele nibakola ebikolwa bye entúungwa nzima, balaázoolwa no kuháabwa obulami bwo bucha no buchiile, náho abaabeele nibakola ebikolwa byo obuzilwa, balaázoolwa no kuchwaáziíkilwa. ");
INSERT INTO zin_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Tiháliho chiintu choóna chóona éecho naakuhicha kukola aha buzizi bwaanze íinye. Niinchwaaziíka abaantu nko óokwo Táata alikuundagila. Omuchwaáziiko gwaanze no gwa amazima, habwo kuba echífu chaanze tiyo kukola nko óokwo íinye ndikweendaho, náho niinkola nko óokwo alikweendaho Táata ayaansiíndikile.” ");
INSERT INTO zin_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kábilaaba íinye niinyesiínza empola zaanze íinye nyeénka, timwaákuhicha kwiikiliza nka nikwo okusiinza kwaanze no okwa amazima. ");
INSERT INTO zin_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Náho aliho oóndi óogwo alikusíinza empola zaanze ahali íimwe. Neenye niinsoomboókelwa nka nikwo, áago alikusíinza habwi íinye na aga mazima. ");
INSERT INTO zin_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Íimwe mukasiindika abaantu ahali Yohana Omubatiza kubonesa empola, náwe akasiinza amazima ha bwaánze. ");
INSERT INTO zin_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Íinye ti nka nikwo oóti niinyesiga bwooli okusiinza kwa abaantu, náho niimbagaambila ago góona, muhiche kuchuúngulwa. ");
INSERT INTO zin_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana Omubatiza akaba ali nko olumuli óolwo olulikwáaka no okumulika omu nsiimbaazi, neemwe mukaba muli bweémi ha kugunulilwa ogwo mwaanga ahali ako kaziingo. ");
INSERT INTO zin_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Náho íinye nnyina okusiinza kuháango kusaaga okwo okwa Yohana, niyo emilimo éezo Táata akaámpa mbone kuzihikiiliza. Emilimo yaanze neeyoleka nka nikwo, Táata niwe weényini óogwo akaansiíndika. ");
INSERT INTO zin_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Náwe Táata óogwo akaansiíndika, weényini ansiínza. Íimwe muchaáliga no óobu kuhulila iláka lyoómwe, nali kuzibona ensuso yoómwe nka nikwo eéli. ");
INSERT INTO zin_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Na ameégeso ge empola zoómwe, tigakwiikala omuli íimwe, habwo kuba timukuunyikiliza íinye óogwo nkasiindikwa na Táata kwíiza hali íimwe. ");
INSERT INTO zin_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nimukola echífu ha kucheéngelela Amaandiko Matakatíifu, habwo kuba nimuteekuza nka nikwo nimuhicha kubonesamo omwo obulami bwo obucha no obuchiile. Náho kási, ago Maandiko nigaansiínza íinye! ");
INSERT INTO zin_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","No óobu bityo, íimwe nimwaánga kwíiza hali íinye, kuba mubonese obulami bwo obucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Íinye tiínkutegeza ikuzo kuluga omu baantu. ");
INSERT INTO zin_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Náho íinye niimbasoomboókelwa óokwo muli, íimwe, timukumwéenda Múungu omu miganya yáanyu. ");
INSERT INTO zin_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Íinye nnyizile habwo obutwáale bwa Táata, náho nimwaánga kuunyinaankula. Náho omuuntu oóndi kaáleéza habwo obutwáale bwa weényini, íimwe nimumwiinaánkula. ");
INSERT INTO zin_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Íimwe nimweénda kusiingizwa na bazeenzi báanyu, náho timukuloonda ikuzo éelyo elilikuluga ahali weényini Múungu. Mbwéenu, aho, nimuhicha muta kuunyikiliza? ");
INSERT INTO zin_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Mutaákuteekuza nka nikwo, íinye ndaábalegelela ahali Táata. Musa niwe óogwo alibalegelela, habwo kuba ogwo niwe mulikutegeza. ");
INSERT INTO zin_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kábyaakubeele amazima nka nikwo mwaakwiikiliize amagaambo go mwa Musa, mbwéenu neenye mwaakaányikiliize, habwe ensoonga Musa akaandika empola zaanze. ");
INSERT INTO zin_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Náho kábilaaba íimwe mutakwíikiliza amaandiko go mwa Musa, mbwéenu nimuhicha muta kwiikiliza amagaambo gaanze?” ");
INSERT INTO zin_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kágaabeele gaáhwéele ago, Yeézu yayaambuka enyaanza ya Galiláaya, izíina eliindi lye ezo nyaanza ni Tiberia. ");
INSERT INTO zin_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Embága mpáango ya abaantu bakaba nibamukulaatíla Yeézu, habwo kuba bakaba baabweene eméenko éezo akaba naakola aha balwéele. ");
INSERT INTO zin_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Niho Yeézu yaáhanama omu ibaanga hamo na abaheémba boómwe, yeékala okwo hamo nábo. ");
INSERT INTO zin_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Obuchilo obwo, echilo chikúlu cha Abayahudi echilikwéetwa Paásika, nácho chikaba cheéliliza. ");
INSERT INTO zin_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mbwéenu Yeézu akaleeba, yaábona embága mpáango ya abaantu abaabeele nibeéza hali weényini. Niho aba yaámubúuza Filipo aáti, “Ngási, ni nkáhi áaho twaakuhicha kugula ebyookulya byo kulíisa ezi mbága yóona ya abaantu?” ");
INSERT INTO zin_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yeézu akamubúuza Filipo aátyo ha kumuleengesa, ha kuba akaba naasoomboókelwa éecho alaakola. ");
INSERT INTO zin_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo yaámugalulila aáti, “No óobu twaakubeele tuguzile ebyookulya bíche kwoónka habwa buli muuntu, bye edináali magána abili tibyaákubahikile aba baantu bóona.” ");
INSERT INTO zin_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Niho Andrea, óogwo akaba ali oómo omu baheémba ba Yeézu, káandi ali mweene wáabo na Simoni Peétero, aba yaámugaambila Yeézu nka nikwo, ");
INSERT INTO zin_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Aliho aha omusígazi oómo óogwo ayina emikaate itaanu ne eénfwi ibili. Náho, ebyookulya ebi nibigasa chiíha aha mbága ezi yóona?” ");
INSERT INTO zin_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mbwéenu, Yeézu yaálagila abaheémba boómwe aáti, “Mubagaambile abaantu beekale.” Ahaantu aho, hakaba heena endyaámila nyíinzi. Niho abaantu bóona, baba beékala. Omuli abo nyini, bakaba balimo obukúmi bwa abaséeza ebihuumbi bitaanu. ");
INSERT INTO zin_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Niho, Yeézu yeemucha ezo mikaate, yaámusiima Múungu, yaábagabila abaantu bóona abaabeele beékeele babone kulya. Yaákola aátyo nyini na ahali ezo nfwi ibili, yaábagabila. Abaantu bóona baálya nko óokwo baabeele nibeéndaho kulya. ");
INSERT INTO zin_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mbwéenu abaantu bóona kabahaágile, Yeézu yaábalagila abaheémba boómwe aáti, “Mutulaanize emisige yóona ye ebyookulya, bitaákwiiza bikasiisagulika.” ");
INSERT INTO zin_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mbwéenu, batulaaniza amanogóka góona, baaba beezuza ebitukulu ikúmi na bibili kuluga hali ebyo binogóka bye mikaate itaanu ye eshayiri éebyo bikasigalila. ");
INSERT INTO zin_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Obuchilo abaantu abo baabweene oluméenko óolwo Yeézu akakola, baágaamba báti, “Mazima ogu muuntu niwe omubáasi wa Múungu óogwo tubele nitutegeza nka nikwo aléeza omu nsi ezi.” ");
INSERT INTO zin_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yeézu yaásoombookelwa nka nikwo áabo baantu bakaba nibeénda bamukwáate lwa amáani, babone kumukola kuba omukáma wáabo. Niho Yeézu aba yaalugáho aho, yaázeenda weénka omu ibaanga. ");
INSERT INTO zin_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kahabeele olweébazo, abaheémba ba Yeézu baágolomoka kuzeenda aha nyaanza ya Galiláaya. ");
INSERT INTO zin_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Baáhanama omu bwáato, babone kwaambuka enyaanza kuzeenda omu muzihwa gwa Kaperinaumu. Obuchilo obwo, ensiimbaazi ekaba yaábaandize, náho Yeézu akaba acháali atakabahikiile abaheémba boómwe. ");
INSERT INTO zin_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mbwéenu, enyaanza eba yaábaanza kubulaanguka, habwo kuba omuyaga muháango gukaba nigwiíha. ");
INSERT INTO zin_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Obuchilo abaheémba ba Yeézu kábaabeele baábugile oluzeendo nka akáanya ke ekilomíita itaanu nali mukáaga zíti, baba baámubona Yeézu naalibata aha lugulu ya améenzi ge enyaanza kwiililila obwáato bwáabo. Baátíina bwooli. ");
INSERT INTO zin_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Niho, Yeézu yaábagaambila aáti, “Mutatiina! Níinye!” ");
INSERT INTO zin_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mbwéenu, boónyini baáyeenda nka nikwo ahaname omu bwáato. Ahonyini, obwáato buba bwaágoba aha mulaambo áaho bakaba nibazeénda. ");
INSERT INTO zin_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nyeéncha eémo, embága ya abaantu áabo bakaba basigaliile okwo aha mulaambo ogúundi gwe enyaanza, baabonáho obwáato búmo bwoónka aho. Baámanya nka nikwo Yeézu talabugile omu bwáato hamo na abaheémba boómwe, náho abaheémba boómwe bakabuga boónka. ");
INSERT INTO zin_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Niho, abaantu abáandi beeza na amáato kuluga omu muzihwa gwa Tiberia, baáhika héehi na ahaantu áaho embága ya abaantu ekalya emikaate, obuchilo Omukáma Yeézu yaabele yaámazile kumusiima Múungu. ");
INSERT INTO zin_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Obuchilo embága ya abaantu abo baabweene nka nikwo Yeézu akaba ataliho aho, na abaheémba boómwe nábo bakaba bataliho, baáhanama omu bwáato, baábuga kuzeenda Kaperinaumu babone kumuloondela Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Abo baantu kábaahikile ha mulaambo gwe enyaanza, baámusaanga Yeézu, baámubúuza báti, “Mweégesa, oyizile kunu iíli?” ");
INSERT INTO zin_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeézu yaábagalulila aáti, “Mazima butúnu niimbagaambila nka nikwo, nimuundoóndela habwo kuba nkábaha emikaate, mwaálya no kuhaaga, ti habwo kuba nimweénda kusoombookelwa eméenko éezo nkakola. ");
INSERT INTO zin_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mutaákukola emilimo habwo kubonesa echookulya éecho chilikusiisikala, náho mube nimukola emilimo habwo kubonesa echookulya éecho chitakusiisikala, káandi echilikubaha obulami bwo bucha no buchiile. Íinye Mutábani wo Omuuntu, niimbáha echookulya echo, habwo kuba Isíichwe Múungu ampeele amagala go kukola iíntyo.” ");
INSERT INTO zin_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Niho boónyini baámubúuza báti, “Ngási, tukole chiíha kuba tubone kukola amagaambo áago Múungu alikweenda?” ");
INSERT INTO zin_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeézu yaábagalulila aáti, “Echigaambo éecho Múungu alikweenda mukole, no kunyikiliza íinye, óogwo nkasiindikwa náze.” ");
INSERT INTO zin_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aho baámubúuza báti, “Nookola luméenko chi, tubone kululeeba niho tukwiíkilize? Nookola chiintu chi? ");
INSERT INTO zin_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Besiichwe enkúlu, obuchilo baabeele bali omu nsi yo obwoóma, bakalya echookulya chilikwéetwa mana echituukile kuluga omu igulu. Chaandikilwe omu Maandiko Matakatíifu nka nikwo, ‘Akabaha ebyookulya byo kuluga omu igulu balye.’ ” ");
INSERT INTO zin_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mbwéenu, Yeézu yaábagaambila aáti, “Mazima butúnu niimbagaambila nka nikwo, tíwe Musa óogwo akaha besiimweénkulu echo chookulya cho kuluga omu igulu, náho ni Táata. Weényini niwe alikubaha íimwe echookulya cha mazima kuluga omu igulu. ");
INSERT INTO zin_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Echookulya cha Múungu no ogwo alikuhanaantuka kuluga omu igulu, kuba ababonese abaantu bóona abo omu nsi ezi obulami bwo obucha no obuchiile.” ");
INSERT INTO zin_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Niho baámugaambila báti, “Mukáma, tuhe buchiile echo chookulya.” ");
INSERT INTO zin_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeézu yaábagalulila aáti, “Íinye níinye echookulya echilikubaha abaantu obulami bwo obucha no obuchiile. Omuuntu óogwo alikwiiza hali íinye no kuunyikiliza, talizila nzala káandi, nali kuhulila iliho káandi. ");
INSERT INTO zin_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Náho íinye nkabagaambila nka nikwo, mwaámbona, náho timukuunyikiliza. ");
INSERT INTO zin_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Abaantu bóona áabo alikuúmpa Táata, nibeéza hali íinye. Íinye tiínkwáanga no óobu oómo óogwo alikwiiza hali íinye. ");
INSERT INTO zin_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Íinye tiíndeezile kuluga omu igulu mbone kuba niinkola óokwo ndikweenda íinye, náho mbone kuba niinkola óokwo alikweenda Táata óogwo akaansiíndika. ");
INSERT INTO zin_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Táata óogwo akaansiíndika naayeénda aáti, ntaákubuza no óobu omuuntu oómo omuli áabo akaámpa, náho mbone kubazoola bóona ha chilo cho omuhélo. ");
INSERT INTO zin_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Éecho alikweenda Táata ni nka nikwo, buli muuntu óogwo alikusoombookelwa nka nikwo, íinye ndi Omutábani no kuunyikiliza, aábe no obulami bwo bucha no buchiile. Ogwo íinye ndaámuzoola aha chilo cho omuhélo.” ");
INSERT INTO zin_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mbwéenu, Abayahudi ba aho, baábaanza kuteéka téeka habwo kuba Yeézu akeégaamba aáti, “Íinye níinye echookulya éecho echituukile kuluga omu igulu.” ");
INSERT INTO zin_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Beébuuza báti, “Ngási, omuuntu ogu tíwe Yeézu, omwaana wa Yozéfu? Káandi abazéele boómwe nitubamanya? Óobu, bita yaakaáhicha kugaamba nka nikwo, ‘Nhanaantukile kuluga omu igulu’?” ");
INSERT INTO zin_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeézu yaábagalulila aáti, “Muleke kudugulima íimwe mweénka. ");
INSERT INTO zin_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Táliho omuuntu óogwo ayaakuhicha kwiiza hali íinye, kábilaaba atakebeembeliilwe na Táata óogwo akaansiíndika. Neenye niinyíza kumuzoola aha chilo cho omuhélo. ");
INSERT INTO zin_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Chaandikilwe omu Maandiko Matakatíifu ga ababáasi nka nikwo, ‘Abaantu bóona balaáyegeswa na Múungu.’ Mbwéenu, omuuntu óogwo alikuhuliiliza no kweéyega kuluga hali Táata, ayiza hali íinye. ");
INSERT INTO zin_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Táliho omuuntu óogwo ayaámubwéene Múungu Táata, náho íinye nyeénka ayaámubwéene, habwo kuba nkaluga hali weényini. ");
INSERT INTO zin_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Mazima butúnu niimbagaambila nka nikwo, omuuntu weéna wéena óogwo alikuunyikiliza, ogwo ayina obulami bwo bucha no buchiile. ");
INSERT INTO zin_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Íinye níinye echookulya echilikubaha abaantu obwo bulami. ");
INSERT INTO zin_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Besíimwe enkúlu bakalya echookulya echilikwéetwa mana echituukile kuluga omu igulu, obuchilo bakaba bali okwo omu nsi yo obwoóma, náho no óobu bityo bakáfwa. ");
INSERT INTO zin_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Náho aha chiliho echookulya éecho echituukile kuluga omu igulu. Omuuntu kaálaálya echo chookulya, talifwa nakáti. ");
INSERT INTO zin_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Íinye níinye echo echookulya echaatuúkile kuluga omu igulu, echilikubaha abaantu obulami bwo obucha no obuchiile. Omuuntu óogwo alikulya echo chookulya, aláaba no obulami bwo obucha no obuchiile. Echookulya echo no omubili gwaanze óogwo ndaasohoza habwa abaantu bóona be éensi ezi, babone kuba no obulami bwo obucha no obuchiile.” ");
INSERT INTO zin_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mbwéenu, abo Bayahudi baábaanza kuzogootana boónyini boónka, nibagaamba báti, “Óogu muuntu, naahichaho aáta kutuha íichwe omubili gwoómwe, tugulye?” ");
INSERT INTO zin_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ha bwéecho, Yeézu yaábagaambila aáti, “Mazima butúnu niimbagaambila nka nikwo, kábilaaba mutaliíle omubili gwaanze, no okunywa enságama yaanze íinye Mutábani wo Omuuntu, timukuba no obulami bwo obucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Omuuntu óogwo alikulya omubili gwaanze no okunywa enságama yaanze, ogwo ayina obulami bwo bucha no buchiile, neenye ndyaámuzoola aha chilo cho omuhélo. ");
INSERT INTO zin_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Musoomboókelwe nka nikwo, omubili gwaanze nigwo echookulya cha amazima, ne enságama yaanze niyo ensikilizo ya amazima. ");
INSERT INTO zin_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Omuuntu óogwo alikulya omubili gwaanze no okunywa enságama yaanze, ogwo naazeendelela kusigalila omuli íinye, neenye niinsigala omuli weényini. ");
INSERT INTO zin_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Táata óogwo ali omulame akaansiíndika, neenye mbonesize obulami kuluga hali weényini. Bityo nyini, omuuntu weéna wéena alikuúndya íinye, náwe naabonesa obwo bulami kuluga hali íinye. ");
INSERT INTO zin_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mbwéenu, íinye níinye echookulya éecho echituukile kuluga omu igulu. Echookulya echo tichikususana ne echookulya éecho besiimwe enkúlu bakalya, bakáfwa. Náho omuuntu óogwo alikulya echookulya echi, naába no obulami bwo bucha no buchiile.” ");
INSERT INTO zin_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yeézu akagaamba amagaambo ago, obuchilo yaabeele naayegesa omu isomelo lyo okwo Kaperinaumu. ");
INSERT INTO zin_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Obuchilo abaantu béenzi omu baheémba boómwe baáhuliile amagaambo ago, baágaamba báti, “Ameégeso aga gazaazaheele bwooli! Oóha ayaakuhicha kugeékiliza?” ");
INSERT INTO zin_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeézu akasoombookelwa nkokwo, abaheémba boómwe nibadugulumila amagaambo áago akaba agaambile, ha bwéecho yaábabúuza aáti, “Ngási, echigaambo echi nichibatamisa? ");
INSERT INTO zin_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mbwéenu, bilyaábaho bita kamuliimbona íinye Mutábani wo Omuuntu, niindelema kuzeenda olugulu áaho nkaba ndi omu kubaanza? ");
INSERT INTO zin_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Omwooyo gwa Múungu niwe óogwo alikubaha abaantu obulami. Omuuntu tiyaákuhicha kukola choóna chóona habwo obuhicha bwoómwe weénka. Amagaambo áago naábagaambila na ago Omwooyo gwa Múungu, na nigaleeta obulami bwo obucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Náho baliho abáandi omuli íimwe áabo abatakwiikiliza.” Yeézu akagaamba aátyo, habwo kuba akasoombookelwa kuluga aha bubaandizo nka nikwo, ni baáhi áabo abatakumwiíkiliza, na nka nikwo noóha óogwo alimukoonga kóonga. ");
INSERT INTO zin_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mbwéenu, yaázeendelela kubasoomboolela aáti, “Ezo niyo ensoonga niimbagaambila nka nikwo, táliho omuuntu óogwo ayaakuhicha kwíiza hali íinye, kaálaaba ateebeembeliilwe na Táata.” ");
INSERT INTO zin_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kubaandiza obuchilo óobwo baáhuliile ago magaambo, béenzi omu baheémba boómwe, baámusigaho, tibalalibasile náwe káandi. ");
INSERT INTO zin_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Niho Yeézu yaábúuza abaheémba boómwe ikúmi na bábili aáti, “Ngási, neemwe nyini nimweénda kuluhéenda?” ");
INSERT INTO zin_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Peétero yaámugalulila aáti, “Mukáma, tuzeénde hali oóha? Íiwe oyinágo amagaambo ago obulami bwo bucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Íichwe nitukwiikiliza na nitusoomboókelwa nka nikwo, íiwe níiwe Omutakatíifu owo kuluga hali Múungu.” ");
INSERT INTO zin_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Niho Yeézu yaábagaambila aáti, “Ngási, tiíndabatoólize íimwe ikúmi na bábili kuba abaheémba baanze? Náho no óobu bityo, oómo omuli íimwe naayebeembelelwa ni Isitáani.” ");
INSERT INTO zin_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Aho Yeézu akaba naamuhooyela Yuda, mutábani wa Simoni Iskariote. Ogwo Yuda niwe óogwo ayaakumukoonga kóongile Yeézu, mále akaba ali oómo omuli áabo abaheémba boómwe ikúmi na bábili. ");
INSERT INTO zin_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kágaabeele gaáhiingwiile ago, Yeézu yaábaanza kulibata omu nsi ya Galiláaya. Taleénzile kulibata omu nsi ya Yudea, habwo kuba abatégeki ba Abayahudi bakaba nibeénda kumwíita. ");
INSERT INTO zin_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Obuchilo obwo, amazenyi ga Abayahudi go Otutiindi gakaba geéliliize. ");
INSERT INTO zin_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Niho balumuna ba Yeézu baámugaambila báti, “Oteekala aha, ozeénde Yudea, kuba abaheémba baawe babone kuleeba amahano áago olikukola. ");
INSERT INTO zin_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kaálaaba omuuntu naayeénda akumuúke omu baantu, takweendelwa akole emilimo yoómwe aha bweeseléke. Mbwéenu, keélaaba íiwe noohicha kukola amagaambo ago, zeénda oyeyoleke omu baantu bóona, babone kukumanya.” ");
INSERT INTO zin_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Abalumunábe bakagaamba bátyo, habwo kuba na boónyini bakaba batakumwiikiliza Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Niho Yeézu yaábagaambila aáti, “Obuchilo bwaanze obugasize, bucháali tibukahikile, náho ahali íimwe buli mwáanya nigubagasa. ");
INSERT INTO zin_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Abaantu be éensi ezi, tibéena entaahililo yo kubatamwa íimwe. Náho nibaantámwa íinye, habwo kuba niinyatula nka nikwo, ebikolwa byáabo ne ebyo obuzilwa. ");
INSERT INTO zin_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Íimwe nyini, nimwiilóoko muhaname kuzeenda okwo Yeruzaléemu kulya amazenyi. Íinye tiínkuzeenda, habwo kuba obuchilo bwaanze tibukahikile.” ");
INSERT INTO zin_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Obuchilo Yeézu káyaamazile kugaamba amagaambo ago, yaásigala omu nsi ya Galiláaya. ");
INSERT INTO zin_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Náho obuchilo abalumunábe bakaba baázeenzile Yeruzaléemu kulya echilo chikúlu echo, Yeézu náwe yaázeenda okwo, náho aha bweeseléke, atéena kweéyoleka butúnu. ");
INSERT INTO zin_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mbwéenu, obuchilo bwa amazenyi, abatégeki ba Abayahudi baaba nibamuloondela Yeézu. Baábúuza abaantu báti, “Ali nkáhi ogwo muuntu?” ");
INSERT INTO zin_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Abaantu béenzi baaba nibadugulíma habwa Yeézu. Abáandi omuli abo nibagaámba báti, “Yeézu no omuuntu omweésigwa,” náho abáandi baaba nibagaamba báti, “Mmahi, weényini naabahabisa abaantu.” ");
INSERT INTO zin_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Náho talabeeleho omuuntu óogwo ayaabeele naamugaámba Yeézu ha bwéelu, habwo kuba bakaba nibabatiína abatégeki ba Abayahudi. ");
INSERT INTO zin_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ebilo bya amazenyi kibyaahikile ahagáti, Yeézu yaáhanama, yaáza omu lubúga lwe éenzu ya Múungu, yaábaanza kweégesa omwo abaantu. ");
INSERT INTO zin_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mala, abatégeki ba Abayahudi baásobelwa habwa ameégeso goómwe, baágaamba báti, “Ngási, ogu muuntu ogu ahikize aáta kusoombookelwa góona aga, kunu atasomile?” ");
INSERT INTO zin_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mbwéenu, Yeézu yaábagaambila aáti, “Ameégeso áago ndikubeégesa, ti gaanze, náho galugile ahali óogwo akaansiíndika. ");
INSERT INTO zin_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Omuuntu óogwo alikweenda kukola áago Múungu alikweenda, ogwo alaásoombookelwa nka nikwo, ameégeso gaanze nigaluga ahali Múungu, na nka nikwo tiínkugaamba kwoónka kuluga omu muganya gwaanze. ");
INSERT INTO zin_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Omuuntu ogwo alikugaamba kwoónka ha bweenzi bwoómwe, ogwo aba naaloonda ikuzo lya weényini. Náho óogwo alikuloondela ikuzo lyo óogwo akamusiíndika, ogwo naagaámba amazima, no obuzilwa tibulimo omu muganya gwoómwe.” ");
INSERT INTO zin_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Yeézu yaázeendelela kugaamba aáti, “Nimumanya nka nikwo, Musa akabaha ebilagilo bya Múungu. Náho táliho omuuntu omuli íimwe óogwo alikubyeékomya ebyo bilagilo. Ha bwaáchi nimuloónda kuunyíta?” ");
INSERT INTO zin_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aho embága ya abaantu yaámusubiza eéti, “Íiwe oyine izimu! Noóha óogwo alikweenda kukwíita?” ");
INSERT INTO zin_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeézu yaábagalulila aáti, “Heena ihano límo éelyo nkakola, neemwe mwaákaankamala. ");
INSERT INTO zin_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Léeba, Musa akabalagila kusála ikóba abáana báanyu bo obuséeza. Ti nka nikwo obuteéka obwo bukaluga hali weényini Musa, náho bukalugiilila ahali besiimwe enkúlu aba kala. Íimwe óobu nimubasála amakóba abáana báanyu no óobu ha chilo che Endaálikizo. ");
INSERT INTO zin_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nimuzila echífu omu kweékomya ebilagilo bya Musa habwo okusála amakóba abáana báanyu abaséeza aha chilo che Endaálikizo. Náho ha bwaáchi niimmuniingahalila kaándikuchiza enziingo zóona zo omuuntu omu chilo che Endaálikizo? ");
INSERT INTO zin_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mutaákuchwaaziika omuuntu habwa amagaambo ago agalikubonwa ahéelu, náho mube nimulamula abaantu omu kukulaatila amazima.” ");
INSERT INTO zin_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mbwéenu, abaantu abáandi ba Yeruzaléemu aho, baaba nibeebuúza báti, “Ngási, ogu muuntu tíwe óogwo abatégeki béetu balikuloonda kumwíita? ");
INSERT INTO zin_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mulole, óobu naagaámba ha bwéelu, na káandi tihaliho omuuntu alikumugaambila no óobu echigaambo choóna chóona! Ngási, byaakáaba nka nikwo, abatégeki béetu baásoombookelwa amazima nka nikwo, ogwo niwe Masihi? ");
INSERT INTO zin_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Omuuntu ogu, nitusoomboókelwa áaho alugile. Náho obuchilo aleéza weényini Masihi, táliho muuntu óogwo alisoombookelwa áaho yaálugile.” ");
INSERT INTO zin_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Obuchilo Yeézu akaba naayegesa omu lubúga lwe éenzu ya Múungu, yaáyaambaza ahi iláka naagaámba aáti, “Iíngu nimugaámba, nimuummanya, na nimuhasoomboókelwa áaho ndugiíliile. Íinye tiíndeezile aha bwo obuzizi bwaanze, náho nkasiindikwa na Múungu óogwo ali owa mazima, náho íimwe timukumusoombookelwa. ");
INSERT INTO zin_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Íinye niimmusoomboókelwa, habwo kuba ndugile hali weényini. Weényini niwe akaansiíndika kwíiza.” ");
INSERT INTO zin_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Niho abaantu baáloonda kumuta omuli itaanu, náho talabeeleho omuuntu óogwo ayaaleengesize kumutaho engalo, habwo kuba obuchilo bwoómwe obukaba buleengilwe bukaba butakahikile. ");
INSERT INTO zin_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Náho omuli abo baantu, bakaba balimo béenzi áabo abaamwiíkiliize Yeézu. Abaantu abo baágaamba báti, “Ngási, obuchilo Masihi aléeza, alaáhicha kukola eméenko nyíinzi kusaaga éezo alikukola ogu muuntu?” ");
INSERT INTO zin_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mbwéenu, Abafarisayo bahuliile óokwo embága ya abaantu nibahweehweéta bátyo habwa Yeézu. Ha bwéecho, Abafarisayo abo, hamo na abakúlu ba abagabe, baásiindika abaselikale kuba bamukwáate Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Niho Yeézu yaábagaambila abaantu abo aáti, “Niímba neemwe aha mwáanya muche kwoónka. Mala niinsuba ahali óogwo akaansiíndika. ");
INSERT INTO zin_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mulaándoondela, náho timuliimbona. Káandi, neenye áaho ndiba ndi, íimwe timwaákuhicha kwíiza.” ");
INSERT INTO zin_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Niho Abayahudi bagaámba báti, “Ngási, omuuntu ogu alyáaza nkáhi áaho íichwe titukwiíle kumubona? Ngási, naayeénda kuzeenda aha Bayahudi áabo abasaambaalile omu nsi ezíindi, no kweégesa Abanyamahaánga? ");
INSERT INTO zin_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ngási, ayina nsoonga chi obu alikugaamba nka nikwo, ‘Mulaándoondela, náho timuliimbona. Káandi, áaho íinye ndiba ndi, íimwe timulihicha kwiizáho’?” ");
INSERT INTO zin_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Echilo cho kumaliiliza amazenyi go Otutiindi, chikaba chili echilo chiháango. Mbwéenu, Yeézu yaáyemeelela omu lubúga lwe éenzu ya Múungu, yaáyaambaza ahi iláka liháango aáti, “Omuuntu ayina iliho, ayize hali íinye, abone kunywa! ");
INSERT INTO zin_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Amaandiko Matakatíifu nigasoomboola nka nikwo, omuuntu óogwo alikuunyikiliza, ‘Enzwéelo za méenzi agatuha obulami zilaázela kuluga omuli weényini.’” ");
INSERT INTO zin_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yeézu akaba naahoóyela Omwooyo Mutakatíifu, óogwo baliinaánkula abaantu áabo abamwiíkilize Yeézu. Omwáanya ogwo, Múungu akaba atakasiíndikile Omwooyo gwoómwe hali boónyini, habwo kuba Yeézu akaba achaali atakakuziibwe. ");
INSERT INTO zin_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mbwéenu abaantu abáandi kuluga omuli ezo mbága kábaahuliile ago magaambo, baágaamba báti, “Mazima, ogu muuntu niwe ogwo omubáasi óogwo tulikumuliindilila kuluga ahali Múungu.” ");
INSERT INTO zin_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Abaantu abáandi baágaamba báti, “Óogu muuntu niwe Masihi.” Náho abáandi baágaamba báti, “Mmahi, Masihi tiyaákuhicha kuluga omu nsi ya Galiláaya. ");
INSERT INTO zin_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ngási, Amaandiko Matakatíifu tigakusoomboola nka nikwo, Masihi alaáluga omu lugaanda lwo omukáma Daudi? Káandi nka nikwo, alaázaálilwa omuli Betlehemu, omu mugoongo óogwo akazaalilwámo Daudi?” ");
INSERT INTO zin_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Bityo ezo mbága ya baantu eba yaátaagana habwa Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Abáandi bakaba nibeénda kumuta omuli itaanu náho talabeeleho omuuntu óogwo ayaaleengesize kumukwáata. ");
INSERT INTO zin_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mbwéenu, abaselikale abo baásuba aha bakúlu ba abagabe na Abafarisayo. Abatégeki abo baábabúuza báti, “Ha bwaáchi timwaamukwaata Yeézu no kumuléeta aha?” ");
INSERT INTO zin_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Abaselikale abo baábasúbiza báti, “Tuchaáliga no obuche bwa akáti kuhulila omuuntu oóndi óogwo alikuhicha kugaamba nko óokwo alikugaambáho ogu.” ");
INSERT INTO zin_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Niho Abafarisayo baábabúuza báti, “Ngási, no óobu íimwe mwaábeehabeehilwe náze? ");
INSERT INTO zin_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ngási, mwaábwéene no óobu oómo omu beébeembezi ba abaantu nali Omufarisayo no óobu oómo óogwo ayaámwiíkilize? ");
INSERT INTO zin_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Náho abaantu áabo abalikumwiíkiliza, ne embága ya abaantu áabo abatakusoombookelwa ebilagilo bya Musa. Bacheénilwe na Múungu!” ");
INSERT INTO zin_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Niho Nikodemo, oómo wa abatégeki ba Abafarisayo óogwo ha bubaandizo akaba ayimukile kuza hali Yeézu echilo chimo omu chilo, yaábúuza bazeenzíbe nka nikwo, ");
INSERT INTO zin_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ngási, echilagilo chéetu nichikuúnda kumuchwaáziika omuuntu obuchilo titukamuhuliliize no kusoombookelwa áago alikukola?” ");
INSERT INTO zin_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Boónyini baámusubiza Nikodemo báti, “Ngási, neewe nyini olugile Galiláaya? Ilóoko ozeénde ogacheéngelele kuzima Amaandiko Matakatíifu, neewe obóne kusoombookelwa nka nikwo, táliho no obuche bwa akáti omubáasi óogwo alilugiilila omuli Galiláaya.” ");
INSERT INTO zin_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Niho abo bóona baalugáyo okwo, baásuba omúka. Yeézu yaázeenda ahi ibaanga lye Emizeituni. ");
INSERT INTO zin_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Óobu haáchíile, Yeézu yaázeenda káandi omu lubúga lwe éenzu ya Múungu. Abaantu bóona baamwiizáho, náwe yeékala, yaábaanza kubeégesa. ");
INSERT INTO zin_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Niho, abeégesa be ebilagilo bya Musa na Abafarisayo, baámuléeta omukázi óogwo akaba akwaásilwe omu busaambani, baámuta ahagáti ye embága ya abaantu. ");
INSERT INTO zin_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mala baámugaambila Yeézu báti, “Mweégesa, ogu mukázi, yaákwáatwa naasaambana. ");
INSERT INTO zin_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mbwéenu, omu bilagilo byéetu, Musa akatulagila kwiita omukázi nko ogu, ha kumuhoonda na amabáale. Mbwéenu, íiwe noogaámbáho oóta?” ");
INSERT INTO zin_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Boónyini bakamubúuza bátyo Yeézu habwo kumuleengesa, babone kubonesa omuháanda gwo kumulégelela. Náho Yeézu yeénama, yaábaanza kwaandika ahaansi no olukumu lwoómwe. ");
INSERT INTO zin_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Obu baázeendeliile kumubúuza, Yeézu yeénamuluka, yaábagaambila aáti, “Kaálaaba aliho omuuntu omuli íimwe óogwo achaáliga kuhena no óobu entúlo eémo, ogwo aábe owo kubaanza kumuhoonda ibáale ogu mukázi.” ");
INSERT INTO zin_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mala, Yeézu yeénama káandi ahaansi, yaázeendelela kwaandika ahi itaka. ");
INSERT INTO zin_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Obu baáhuliile ago magaambo, baálegelelwa ne emiganya yáabo, baábaanza kunyoloomboka oómo oómo, kubaandiza abanyaampala. Ha muheleeluko, Yeézu yaasigalaho weénka no ogwo mukázi, ogu mukázi yaásigala ayemeeliile omu méeso goómwe. ");
INSERT INTO zin_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Niho Yeézu yeénamuluka, yaámubúuza aáti, “Íiwe mukázi, bali nkáhi áabo abalikukulegelela? Ngási, táliho óogwo ayaásigalila abone kukuchwaáziikila?” ");
INSERT INTO zin_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yaámugalulila aáti, “Mukáma, tiyaásigalilaho no óobu oómo.” Niho, Yeézu yaámugaambila aáti, “Nóobu íinye tiínkukuchwaaziikila. Zeénda, náho kubaandiza leélo éeli, otahena káandi.” ");
INSERT INTO zin_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mbwéenu, Yeézu yaázeendelela kugaamba aáti, “Íinye níinye omwaanga gwe éensi. Omuuntu weéna wéena óogwo alikuunkulaatila íinye, takulibata omu nsiimbaazi no obuche bwa akáti, náho aláaba no omwaanga óogwo gulikumweebeembelela omu bulami bwo obucha no obuchiile.” ");
INSERT INTO zin_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Abafarisayo baámugaambila Yeézu báti, “Íiwe nooyesiinza weénka. Okusiinza kwaawe ti kwa amazima!” ");
INSERT INTO zin_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeézu yaábagalulila aáti, “Nóobu bilaaba niinyesiinza nyeénka, okusiinza kwaanze no kwa amazima. Íinye niinsoomboókelwa áaho nkaluga, káandi niinsoomboókelwa áaho ndikuzeenda. Náho íimwe timukusoombookelwa áaho nkaluga na áaho ndikuzeenda. ");
INSERT INTO zin_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Íimwe nimuteekuza no kulamula kwiingana na akaleébele ka abaantu, náho íinye tiínkumulamulila muuntu iíntyo. ");
INSERT INTO zin_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Náho kábilaaba íinye niimmulamulila omuuntu, niimmulamulila aha mazima, habwo kuba íinye tiíndi nyeénka, náho ndi hamo na Táata óogwo akaansiíndika. ");
INSERT INTO zin_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Omu bilagilo byáanyu haandikilwe nka nikwo, okusiinza kwa abaantu bábili nikweesigwa kuba okwa amazima. ");
INSERT INTO zin_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mbwéenu, íinye niinyesiínza, na Táata óogwo akaansiíndika náwe naanyesiinza.” ");
INSERT INTO zin_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Niho Abafarisayo baámubúuza Yeézu báti, “Ngási, Iíso ali nkáhi?” Yeézu yaábagalulila aáti, “Íimwe timukuunsoombookelwa íinye, no óobu Táata timukumusoombookelwa. Kabiliba mwaakuunsoomboókiilwe íinye, mbwéenu mukaámusoombookiilwe na Táata.” ");
INSERT INTO zin_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeézu akagaamba ago góona, obuchilo yaabele naayegesa aha lubuga lwe éenzu ya Múungu, ahaantu áaho bakaba nibatamo omwo ebíibo bye empilya. Náho talabeeleho omuuntu óogwo akamuta omuli itaanu, habwo kuba obuchilo bwoómwe bukaba butakahikile. ");
INSERT INTO zin_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mbwéenu, Yeézu yaábagaambila Abafarisayo abo káandi aáti, “Íinye niinzeénda, neemwe mulaándoondela. Náho mulaafwa omu biheno byáanyu. Áaho ndikuzeenda íinye, íimwe timukuhicha kwiizáho.” ");
INSERT INTO zin_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Niho abatégeki ba Abayahudi baábaanza kweébuuza báti, “Ha bwaáchi naagaámba nka nikwo, titukwiíle kumukulaatila áaho alikuzeenda? Ngási, naáza kweéyita?” ");
INSERT INTO zin_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeézu yaázeendelela kubasoomboolela aáti, “Íimwe mulugiliile ahaansi aha, náho íinye ndugile olugulu omu igulu. Íimwe muli abe ezi nsi, náho íinye tiíndi we éensi ezi. ");
INSERT INTO zin_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Niyo ensoonga nkabagaambila nka nikwo, mulaáfwéela omu biheno byáanyu. Habwo kuba kamulaaba mutakwíikiliza nka nikwo ‘Íinye Niwe,’ mulaáfwéela omu biheno byáanyu.” ");
INSERT INTO zin_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nábo baámubúuza báti, “Otugaambiile, íiwe oli oóha?” Yeézu yaábagalulila aáti, “Mbagaambíile kuluga obutaándikilo nka nikwo íinye ndi oóha! ");
INSERT INTO zin_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nnyina amagaambo méenzi go kubagaambila no kubachwaáziika, náho tiínkukola iíntyo. Óogwo akaansiíndika no wa amazima, neenye empola éezo naáhuliile kuluga hali weényini, nizo ndikubasoomboolela abaantu be éensi ezi.” ");
INSERT INTO zin_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Obuchilo bahuliile ebyo, tibalasoombookiilwe nka nikwo akaba naagaámba nábo habwe Eése owo omu igulu. ");
INSERT INTO zin_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mbwéenu, Yeézu yaábagaambila aáti, “Obuchilo mulaanhanamika aha musalaba, aho niho mulaamanya nka nikwo íinye níinye Mutábani wo Omuuntu. Káandi mulaásoombookelwa nka nikwo góona áago ndikukola, tiínkugakola habwa amagala gaanze, náho niingagaámba óokwo Táata akaanyegesa. ");
INSERT INTO zin_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ogwo ayaansiíndikile ali hamo neenye. Takaandekile íinye nyeénka, habwo kuba obuchilo bwóona niinkola ago agalikumusemelela.” ");
INSERT INTO zin_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Obuchilo Yeézu akaba naagaámba amagaambo ago, abaantu béenzi baámwiíkiliza. ");
INSERT INTO zin_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mbwéenu, Yeézu yaábagaambila Abayahudi áabo baamwiikiliize aáti, “Kábilaaba nimuzeendelela kukulaatila ameégeso gaanze, aho niho muláaba abaheémba baanze ba amazima. ");
INSERT INTO zin_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Káandi mulaásoombookelwa amazima, na amazima ago, nigabaha obweéyagaaluzi.” ");
INSERT INTO zin_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Boónyini baámusubiza báti, “Íichwe ne enzaalwa za Ibrahímu. Tuchaáliga kukolwa no omuuntu weéna wéena kuba abahálila. Ha bwaáchi nootugaambila nka nikwo íichwe nituba abeéyagaalwiile?” ");
INSERT INTO zin_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeézu yaábagalulila aáti, “Mazima butúnu niimbagaambila nka nikwo, omuuntu weéna wéena óogwo alikuzeendelela kuhena, ogwo no omuhálila we echiheno. ");
INSERT INTO zin_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Omuhálila tasigala omúka yo omukáma woómwe ebilo byóona, náho omutábani niwe asigalila omúka ebilo byóona. ");
INSERT INTO zin_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Bityo, íinye Mutábani wa Múungu kaándikubaha obweéyagaaluzi, nimuba mweéyagaalula mazima. ");
INSERT INTO zin_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Niinsoomboókelwa nka nikwo, íimwe muli abo oluzáalo lwa Ibrahímu. Náho nimuloondela kuunyíta, habwo kuba nimwaánga kwiikiliza áago ndikuboólekeelela. ");
INSERT INTO zin_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Íinye niimbagaambila áago mbweene ahali Táata, náho íimwe nimukola áago muhuliile kuluga hali isíimwe.” ");
INSERT INTO zin_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Boónyini baámusubiza báti, “Ibrahímu niwe isíichwe!” Yeézu yaábagalulila aáti, “Kábilaaba mazima muli enzáalwa ya Ibrahímu mukaábeele nimukola áago akaba akola Ibrahímu. ");
INSERT INTO zin_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Náho óobu nimuloondela omuháanda gwo kuunyíta, no óobu naámazile kubasoomboolela amazima áago naáhuliile kuluga ahali Múungu. Ibrahímu talakozile óokwo mulikuloonda kukola óobu. ");
INSERT INTO zin_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ebikolwa éebyo íimwe mulikukola, nibiluga ahali isíimwe.” Niho baámusubiza báti, “Íichwe tituli enzaalwa zo obusiihani. Twiina Táata oómo weénka niwe Múungu!” ");
INSERT INTO zin_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeézu yaábagalulila aáti, “Kaálaaba Múungu ali Isíimwe, mukaányeenzile, habwo kuba nkaluga ahali Múungu, no óobu ndi aha. Íinye tiíndeezile aha magala gaanze, náho Múungu niwe yaánsiíndikile. ");
INSERT INTO zin_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ha bwaáchi timukusoombookelwa áago ndikubagaambila? Na habwo kuba timukweenda kuhuliliiza amagaambo áago ndikubasoomboolela. ");
INSERT INTO zin_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Íimwe muli abi Isitáani, ogwo niwe isíimwe! Bityo nimweénda kukola áago isíimwe alikuligila. Weényini no omwíisi kulugiilila aha butaándiko, mále tayeénda amazima, habwo kuba amazima tigalimo omuli weényini. Obuchilo naagaámba ebisuba, niyo entabuko yoómwe, habwo kuba weényini no omubéehi, káandi niwe iíse we ebisuba byóona. ");
INSERT INTO zin_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Náho timukuunyikiliza íinye habwo kuba niimbasoomboolela amazima. ");
INSERT INTO zin_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Noóha omuli íimwe óogwo ayaakuhicha kusiinza nka nikwo íinye ndi omuheni? Keélaaba niimbagaambila amazima, ha bwaáchi timukuunyikiliza? ");
INSERT INTO zin_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Omuuntu óogwo ali owa Múungu, ahulila amagaambo goómwe Múungu. Íimwe timukuhulila amagaambo goómwe, habwo kuba íimwe timuli abaantu boómwe.” ");
INSERT INTO zin_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Abayahudi baámusubiza Yeézu báti, “Ngási, íichwe hanu titukugaamba amazima katulikugaamba nka nikwo, íiwe oli omunya Samaria, na káandi oyine izimu?” ");
INSERT INTO zin_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeézu yaábagalulila aáti, “Íinye tiinyina izimu. Íinye niimmukúza Táata, náho íimwe nimuungoókela. ");
INSERT INTO zin_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Íinye tiínkuloonda echikumuuko chaanze, náho aliho oóndi óogwo alikuloonda kuunkúza, káandi niwe omulamuzi wa mazima. ");
INSERT INTO zin_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mazima butúnu niimbagaambila nka nikwo, omuuntu óogwo alikweékomya ameégeso gaanze, talifwa no obuche bwa akáti.” ");
INSERT INTO zin_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mbwéenu, Abayahudi abo baámugaambila Yeézu báti, “Óobu nitusoomboókelwa nka nikwo, íiwe oyina izimu! Ibrahímu akafwa, na ababáasi nábo bakáfwa. Náho íiwe noogaámba nka nikwo, ‘Omuuntu óogwo alikweékomya ameégeso gaanze, talifwa no obuche bwa akáti.’ ");
INSERT INTO zin_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ngási, nooyekola kuba mukúlu kusaaga isíichwe enkúlu Ibrahímu? Weényini akafwa, na ababáasi nábo bakáfwa. Ngási, íiwe nooyekola kuba oóha?” ");
INSERT INTO zin_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeézu yaábagalulila aáti, “Kábilaaba niinyekuza nyeénka, kweékuza kwaanze tikwiina nsoonga yoóna yóona. Náho Táata, óogwo mulikugaamba íimwe nka nikwo ni Múungu wáanyu, niwe alikuunkuza. ");
INSERT INTO zin_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Íimwe timukumusoombookelwa Múungu, náho íinye niimmusoomboókelwa. Keélaaba naakugaambíle nka nikwo tiínkumusoombookelwa, niho naakubeele ndi omubéehi nkeemwe. Náho íinye niimmusoomboókelwa Múungu, káandi niinkulaatila áago alikugaamba. ");
INSERT INTO zin_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Isíimwe enkúlu Ibrahímu, akanulilwa bwooli kuchibona echilo cho kwíiza kwaanze. Obuchilo yaachibwéene, akanulilwa bwooli.” ");
INSERT INTO zin_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mbwéenu, Abayahudi baámugaambila Yeézu báti, “Íiwe tokahikize emyáaka makúmi ataanu. Ni bitaho okahicha kumubona Ibrahímu?” ");
INSERT INTO zin_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeézu yaábagalulila aáti, “Mazima butúnu niimbagaambila nka nikwo, obuchilo Ibrahímu akaba atakazéelwe, íinye ndiyo.” ");
INSERT INTO zin_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Obuchilo Abayahudi baáhuliile ago, baákobya amabáale babone kugamuhoondesa. Náho Yeézu aba yeéseleka, yaásohola omu lubúga lwe éenzu ya Múungu. ");
INSERT INTO zin_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Echilo chimo, obuchilo Yeézu akaba naalibata omu muháanda, yaábona omuuntu oómo óogwo akazaalwa ali omuhume. ");
INSERT INTO zin_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Abaheémba boómwe baámubúuza báti, “Mweégesa, omuuntu ogu akazaalwa ali omuhume habwe ebiheno byo oóha? Byo omuuntu ogu weényini, nali bya abazéele boómwe?” ");
INSERT INTO zin_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeézu yaábagalulila aáti, “Óogu talabeele omuhume habwe ebiheno byoómwe, nali ebiheno bya abazéele boómwe. Náho akazaalwa ali omuhume, kuba obuzizi bwa Múungu bubone kumanyiswa omu baantu kulabila obulami bwoómwe. ");
INSERT INTO zin_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nitweendélwa kukola emilimo ya Múungu óogwo akaansiíndika, obuchilo óobu hacháali ni nyemisana. Ensiimbaazi neeyiza kwiiza, áaho tulaaleka kuhicha kukola emilimo ezo. ");
INSERT INTO zin_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Obuchilo óobwo nchili omu nsi ezi, íinye ndi omwaanga omu baantu be éensi ezi.” ");
INSERT INTO zin_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Obuchilo Yeézu yaámazile kugaamba ago magaambo, yaáchweela amachwaánta ahi itaka, yaábúumba olutome na amachwaánta, olwo lutome yaálusiiga aha méeso go ogwo omuhume. ");
INSERT INTO zin_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Niho yaámugaambila ogwo omuhume aáti, “Zeénda onáabe omu iláambo lya Siloamu.” Siloamu, ensoonga yaáho no “Óogwo asiindikilwe.” Niho ogwo omuhume yaázeenda, yaánaaba obuso, yaásuba omúka yoómwe naahweéza kuzima. ");
INSERT INTO zin_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mbwéenu, batúuzi boómwe na abáandi abaabeele baalamanyiile kumubona ali omu kusabiliza, beébuuza báti, “Ngási, ogu muuntu tíwe oliinya óogwo akaba asiiba ayikeele no kusabiliza?” ");
INSERT INTO zin_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Abáandi baágaamba báti, “Niwe.” Abáandi baágaamba báti, “Ti weényini, náho naasusana náwe bwooli.” Náho weényini nyini yaábasoomboolela aáti, “Na amazima, niwe íinye.” ");
INSERT INTO zin_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Niho baámubúuza báti, “Kábilaaba amazima niwe íiwe, ni bitaho améeso gaawe gaáhicha kuhwéeza?” ");
INSERT INTO zin_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yaábagalulila aáti, “Omuuntu óogwo alikwéetwa Yeézu, akachwéela amachwaánta omu itaka, yaálubúumba, olwo lutome yalusiiga aha méeso gaanze. Mala yaángaambila nka nikwo, ‘Zeénda onáabe omu iláambo lya Siloamu.’ Mbwéenu mba naázeenda, naánaaba, naábonesa kuhweeza.” ");
INSERT INTO zin_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Boónyini baámubúuza báti, “Ngási, ogwo muuntu ali nkáhi?” Náwe yaábagalulila aáti, “Íinye tiínkumanya.” ");
INSERT INTO zin_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mbwéenu, baámutwáala óogwo akaba ali omuhume aha Bafarisayo. ");
INSERT INTO zin_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Echilo éecho Yeézu akakola olutome na amachwaánta, no kumuchíza ogwo muhume, chikaba chili echilo che Endaálikizo. ");
INSERT INTO zin_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mbwéenu, Abafarisayo nábo baámubúuza káandi omuuntu ogwo óokwo akahichaho kuhweeza. Yaábagalulila aáti, “Omuuntu oómo akaansiiga olutome aha méeso, naánaaba, no óobu niinhweéza.” ");
INSERT INTO zin_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Niho Abafarisayo abáandi baágaamba báti, “Omuuntu óogwo akozile aátyo, talugile ahali Múungu, habwo kuba naahenela ebilagilo bye echilo che Endaálikizo.” Náho Abafarisayo abáandi baágaamba báti, “Ngási, omuheni yaakaáhichaho aáta kukola eméenko za amahano nke ezo?” Ha bwéecho, baátáana boónyini boónka. ");
INSERT INTO zin_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Niho, Abafarisayo baámubúuza káandi óogwo ayaabeele ali omuhume báti, “Omuuntu óogwo ayaákuchiza améeso gaawe, íiwe noogaámbáho oóta habwa weényini?” Náwe yaábagalulila aáti, “Íinye niimbóna omuuntu ogwo no omubáasi wa Múungu.” ");
INSERT INTO zin_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Náho abatégeki abo ba Abayahudi tibalekiliize empola ezo nka nikwo, omuuntu ogwo akaba ali omuhume. Ha bwéecho, baáyéta abazéele boómwe. ");
INSERT INTO zin_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Baábabúuza báti, “Ngási, omuuntu ogu ni mutábani wáanyu? Na amazima nka nikwo akazaalwa ali omuhume? Kábilaaba ni bityo, ni bitaho yaáhicha kuhweeza óobu?” ");
INSERT INTO zin_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Niho abazéele boómwe baábagalulila báti, “Íichwe nitusoomboókelwa nka nikwo ogu ni mutábani wéetu, na nka nikwo akazaalwa ali omuhume. ");
INSERT INTO zin_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Náho titukusoombookelwa óokwo akahicha kuhweeza, káandi titukumusoombookelwa omuuntu óogwo ayaamuchilize améeso goómwe. Mumubúuze weényini, habwo kuba ni muuntu mukúlu, yaakaáhicha kusoomboola weényini.” ");
INSERT INTO zin_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abazéele boómwe bakagaamba bátyo, habwo kuba bakaba nibabatiína abatégeki ba Abayahudi. Habwe ensoonga, Abayahudi bakaba beékililizeene nka nikwo, omuuntu weéna wéena óogwo aleekiliza nka nikwo Yeézu niwe Masihi, alaátaaguchwa kuluga omu isomelo. ");
INSERT INTO zin_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nicho chaaleételiile abazéele bagaámbe báti, “Mumubúuze weényini, habwo kuba ni muuntu mukúlu.” ");
INSERT INTO zin_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mbwéenu, abatégeki ba Abayahudi baámwéeta káandi omuuntu óogwo akaba ali omuhume, baámugaambila báti, “Omuhe ikuzo Múungu nka nikwo, gaámba amazima! Íichwe nitumanya nka nikwo óogwo muuntu ayaakuchilize, no omuheni.” ");
INSERT INTO zin_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Náwe yaábagalulila aáti, “Íinye tiínkumanya nkokwo omuuntu ogwo no omuheni, náho niinsoomboókelwa echiintu chimo choónka. Nkaba ndi omuhume, náho óobu niinhweéza.” ");
INSERT INTO zin_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mála baámubúuza báti, “Ngási, ogwo muuntu akukoliile chiíha? Akuhuumbulwiile aáta ago méeso gaawe?” ");
INSERT INTO zin_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Náwe yaábagalulila aáti, “Naámazile kubasoomboolela empola ezo, náho timwaámpuliiliza. Ha bwaáchi nimweénda mbagaambile káandi? Ngási, neemwe nimweénda kuba abaheémba boómwe?” ");
INSERT INTO zin_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Náho, boónyini baámuzuma báti, “Íiwe níiwe omuheémba woómwe! Náho íichwe tuli abaheémba ba Musa. ");
INSERT INTO zin_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nitusoomboókelwa nka nikwo Múungu akagaamba na Musa, náho omuuntu ogwo titukusoombookelwa áaho alugile.” ");
INSERT INTO zin_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Náwe yaábagalulila aáti, “Echi ne echigaambo cho kusobeza bwooli! Íimwe timukusoombookelwa áaho yaálugile, náho ogwo niwe ayaánchíza améeso gaanze! ");
INSERT INTO zin_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nitusoomboókelwa nka nikwo, Múungu takuhulila okusaba kwa abaheni, náho naahulila omuuntu weéna wéena óogwo alikumugomookela Múungu no kukola áago alikweenda. ");
INSERT INTO zin_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kulugiilila kala, tuchaáliga kuhulila no óobu entúlo eémo nka nikwo, omuuntu yaáchiza omuuntu óogwo akazaalwa ali omuhume. ");
INSERT INTO zin_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kayaakuba omuuntu ogwo atalugiíliile owa Múungu, tiyaákuhikize kukola choóna chóona.” ");
INSERT INTO zin_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Boónyini baámugalulila báti, “Íiwe okazáalwa no okulelwa nko omuheni. Mbwéenu noohichaho oóta kutweégesa íichwe?” Niho, baba baamutaaguchamo omwo. ");
INSERT INTO zin_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Obuchilo Yeézu yaahuliize nka nikwo baamutaaguchamo ogwo muuntu, yaázeenda kumutabuuza. Obuchilo yaamubwéene, yaámubúuza aáti, “Ngási, noonyikiliza íinye Mutábani wo Omuuntu?” ");
INSERT INTO zin_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Omuuntu ogwo yaámugalulila aáti, “Mukáma, ongaambile Mutábani wo Omuuntu noóha, mbone kuba niimwiikiliza.” ");
INSERT INTO zin_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeézu yaasubámo naamugaámbila aáti, “Íiwe waámazile kumubona, káandi niwe óogwo olikuhooya náze.” ");
INSERT INTO zin_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Omuuntu ogwo yaámuzila aáti, “Niinyikiliza Mukáma waanze.” Niho yaámulamya. ");
INSERT INTO zin_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mbwéenu, Yeézu yaámuzila aáti, “Íinye nnyizile omu nsi ezi kuchwaáziika, kuba abo abali abahume babone kuhweeza, na abo abalikuleeba, babe abahume.” ");
INSERT INTO zin_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Niho, Abafarisayo abáandi áabo bakaba baliho aho, obuchilo bahuliile amagaambo ago, baámubúuza báti, “Ngási, noogaámba nka nikwo neechwe tuli abahume?” ");
INSERT INTO zin_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeézu yaábagalulila aáti, “Kámwaakubeele abahume, timwaákubeele ne entaambala ye echiheno. Náho óobu nimugaámba nka nikwo nimuleeba kuzima, habwe echo nimusigala ne echiheno cháanyu.” ");
INSERT INTO zin_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yeézu yaázeendelela kugaamba aáti, “Mazima butúnu niimbagaambila nka nikwo, omuuntu óogwo atakutaaha omu chihoongóle che entaama omu kuhiíngula ahi iléembo, náho naalabila aháandi, ogwo muuntu no omwíibi mále no omunyagiilizi. ");
INSERT INTO zin_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Náho óogwo alikutaahámo omu kulabila ahi iléembo lye echihoongóle, ogwo niwe omulíisa we entaama. ");
INSERT INTO zin_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Omuliinzi we echibuga amuchiingulila ogwo iléembo, ne entaama zihulila iláka lyoómwe. Náwe omulíisa ayéta buli ntaama izíina lyaáyo no kuzifunya omu kusohola ahéelu. ");
INSERT INTO zin_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Obuchilo yaámazile kuzisohoza entaama zoómwe ahéelu, naazeebeembelela omu méeso, názo zimukulaátila, habwo kuba zilisoomboókelwa iláka lyoómwe. ");
INSERT INTO zin_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Entaama tizikuhicha kumukulaatila omuzenyi, náho zimwiiluka, habwo kuba tizikulisoombookelwa iláka lyoómwe.” ");
INSERT INTO zin_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeézu akabagaambila Abafarisayo omugani ogu, náho boónyini tibalasoombookiilwe áago akaba naabagaambila. ");
INSERT INTO zin_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mbwéenu, Yeézu yaábagaambila káandi aáti, “Mazima butúnu niimbagaambila nka nikwo, íinye níinye iléembo éelyo entaama zilabila kutaaha omu chibuga. ");
INSERT INTO zin_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Abo abáandi bóona abaanyebeembeliile kwiiza bakaba bali abeebi na abanyagiilizi, náho entaama tizilabahuliilize. ");
INSERT INTO zin_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Íinye níinye elyo iléembo. Weéna wéena óogwo alikutaahamo omu chibuga kulabila hali íinye, alaáchuúngulwa, káandi alyáaba omweéyagaaluzi kuzamo no kusohola, na naabonesa amaliísizo. ");
INSERT INTO zin_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Omwíibi ayiza omu chibuga habwe echihika cho kwíiba, no kwíita no kusiingaalicha. Náho íinye nnyizile babone kuba no obulami, káandi babe no obulami obwo ha bwíinzi. ");
INSERT INTO zin_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Íinye níinye omulíisa omweésigwa. Omulíisa omweésigwa asohoza obulami bwoómwe habwe entaama zoómwe. ");
INSERT INTO zin_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Omuuntu alikuliísiza empeéla atali kanyinázo entaama, kaálikubona omusegwe nigwiíza, naayiluka no kuzinagilana entaama zoónka. Ha bwéecho, ogwo musegwe niguzizaázaana ezo ntaama no kuzisaámbaaza. ");
INSERT INTO zin_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ogwo muliisa we empeéla ayiluka, habwo kuba takuzisaaswa ezo ntaama no obuche bwa káti. ");
INSERT INTO zin_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Íinye níinye omulíisa omweésigwa. Niinzisoombookelwa kuzima entaama zaanze, názo niziinsoombookelwa, ");
INSERT INTO zin_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","nko óokwo Táata alikuunsoombookelwaho íinye, neenye nikwo ndikumusoombookelwaho. Íinye niinsohoza obulami bwaanze habwe entaama zaanze. ");
INSERT INTO zin_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Íinye nnyina entaama ezíindi éezo ezitali ezo omuli echi chibuga, niinyeendelwa názo nziléete óomu. Kuba ezo ntaama názo, zilaálihulila iláka lyaanze. Bityo, nibuba obusho búmo, no omulíisa oómo. ");
INSERT INTO zin_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ha bwéecho, nicho Táata anyeéndela, kuba niimbusohoza obulami bwaanze, mbone kubusúbya káandi. ");
INSERT INTO zin_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Táliho omuuntu óogwo ayaakuhicha kusaakula obulami bwaanze. Níinye nyeénka ndikubusohoza obulami bwaanze. Nnyina obuzizi bwo kubusohoza obulami bwaanze, mala nnyina obuzizi bwo kubusúbya káandi. Echo chilagilo cho kukola iíntyo nkachiinaankula kuluga hali Táata.” ");
INSERT INTO zin_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Obuchilo bahuliile amagaambo ago, Abayahudi baba baátáana káandi boónyini boónka. ");
INSERT INTO zin_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Béenzi kuluga omuli abo nyini baágaamba báti, “Óogu ayina izimu! Mále ahikiilwe na abazimu! Ha bwaáchi nimumuhuliiliza?” ");
INSERT INTO zin_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Náho abáandi baágaamba báti, “Amagaambo áago alikugaamba ti go omuuntu óogwo ayina izimu. Ngási, izimu likaáhicha kumukola omuhume ahweéze?” ");
INSERT INTO zin_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mbwéenu, okwo Yeruzaléemu, hakaba heena obuzenyi bwa Abayahudi bwo kwiizuka nka nikwo isomelo likéezwa no kuchiíngulwa káandi. Obuchilo obwo, bukaba buli obwe embého. ");
INSERT INTO zin_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeézu akaba naalibata aha lubúga lwe éenzu ya Múungu, aha chinogoka éecho chilikwéetwa nka nikwo, omu Ikulato lya Selemani. ");
INSERT INTO zin_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Abayahudi abáandi baámuzoongoloka, baámubúuza báti, “Ngási, nootuteéyeecha omu miganya yéetu kuhicha iíli? Kábilaaba íiwe níiwe Masihi, otugaambiile butúnu.” ");
INSERT INTO zin_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Náho Yeézu yaábagalulila aáti, “Íinye naámazile kubasoomboolela iíntyo, náho íimwe timukuunyikiliza. Ebikolwa éebyo ndikukola habwa amagala ga Táata, nibyo bilikuunsíinza nka nikwo íinye ndi oóha. ");
INSERT INTO zin_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Náho timukweenda kuunyikiliza, habwo kuba íimwe timuli entaama zaanze. ");
INSERT INTO zin_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Entaama zaanze zihulila iláka lyaanze. Íinye niinzisoombookelwa, názo ziinkulaátila. ");
INSERT INTO zin_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Íinye niimbáha obulami bwo obucha no obuchiile, na tibalisiingaalika no obuche bwa akáti. Káandi tíhalibaho omuuntu óogwo alihicha kubasaakula íimwe kuluga omu mikono yaanze. ");
INSERT INTO zin_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Táata óogwo ampeele abo, weényini niwe mukúlu kusáaga bóona. Káandi táliho omuuntu óogwo ayaakuhicha kubasaakula kuluga omu ngalo zoómwe. ");
INSERT INTO zin_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Íinye na Táata tuli obúmo.” ");
INSERT INTO zin_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ahonyini Abayahudi baákobya amabáale, babone kugamuhoondesa. ");
INSERT INTO zin_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Náho Yeézu yaábagaambila aáti, “Ndaboólekile ebikolwa bíinzi bizima éebyo nkakola habwo obuzizi bwa Táata. Ni chigaambo chi omuli ebyo echilikubakola íimwe muloónde kuúnhoonda na amabáale?” ");
INSERT INTO zin_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Abayahudi baábasúbiza báti, “Titukweenda kukuhoonda na amabáale habwo kukola amagaambo amazima, náho habwo kuba noomulyoógooza Múungu. Nooyegaámba nka nikwo íiwe oli Múungu, obuchilo íiwe oli omuuntu kwoónka nka abáandi!” ");
INSERT INTO zin_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeézu yaábabúuza aáti, “Ngási, tihaandikilwe omu Maandiko gáanyu ge ebilagilo nka nikwo Múungu akagaamba nkokwo, ‘Íimwe muli bamúungu’? ");
INSERT INTO zin_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Haandikilwe omu Maandiko Matakatíifu nka nikwo, abaantu áabo abeenaánkwiile echigaambo cha Múungu, Múungu akabéeta nka nikwo ni bamúungu. Neechwe nitusoomboókelwa nka nikwo, ago agaándikilwe omu Maandiko Matakatíifu na aga amazima tigakuhicha kwiihibwáho. ");
INSERT INTO zin_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Táata niwe ayaanyelize no kuunsiíndika omu nsi ezi. Óobu ngási, ha bwaáchi nimugaámba nka nikwo, íinye niimmulyoógooza Múungu obuchilo niingaámba nka nikwo, ‘Íinye ndi Mutábani wa Múungu’? ");
INSERT INTO zin_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kábilaaba tiínkukola emilimo za Táata, mbwéenu mutaanyikiliza. ");
INSERT INTO zin_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Náho kábilaaba niinkola emilimo ya Táata, no óobu kábilaaba timukuunyikiliza íinye, mbwéenu mwiikilize emilimo ezo. Niho mulaásoombookelwa no kumanya nka nikwo, Táata ali omuli íinye, neenye ndi omuli weényini Táata.” ");
INSERT INTO zin_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Obuchilo Abayahudi bahuliile amagaambo ago, baáloonda káandi kumuta omuli itaanu, náho Yeézu aba yeépuluusuka omu ngalo záabo yaatáyo. ");
INSERT INTO zin_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mala, Yeézu azeénda káandi buseeli bwo omunóna gwa Yorodáani, yaáhika áaho Yohana akaba abatiza abaantu aha bubaandizo. Yeékalayo okwo ebilo bíche. ");
INSERT INTO zin_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Abaantu béenzi baamwiizáho, baágaamba báti, “No óobu kábilaaba Yohana talakozile oluméenko no óobu lúmo, náho amagaambo góona áago akaba naagaámba habwa Yeézu, gakaba gali aga mazima.” ");
INSERT INTO zin_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Abaantu béenzi áabo bakaba baliho aho, baámwiíkiliza Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Akaba aliho omuuntu oómo izíina lyoómwe Lazáaro, akaba naatuúla Betania, náwe akaba ali omulwéele. Omuli ogwo mugoongo gwa Betania nimwo bakaba batuula banyáanya bo ogu Lazáaro, bali Mariamu na Marita. ");
INSERT INTO zin_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Óogu Mariamu, munyáanya wa Lazáaro omulwéele, niwe óogwo akamusiiga Omukáma Yeézu amazuta go omugaazu yaámukubula amagulu habwi isóke lyoómwe. ");
INSERT INTO zin_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mbwéenu, Mariamu na Marita baásiindika empola ahali Yeézu báti, “Mukáma, enfula yaawe Lazáaro no omulwéele.” ");
INSERT INTO zin_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Obuchilo Yeézu yaáhuliile empola éezo, yaágaamba aáti, “Endwáala éezo ti yo kumwíita, náho ne eyo kwoóleka ikuzo lya Múungu. Alweele kuba, habwo omuháanda ogwo, íinye Mutábani wa Múungu, mbone kukúzibwa omu kulabila endwáala yoómwe.” ");
INSERT INTO zin_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeézu akabéenda Marita na Mariamu munyáanya, wa Lazáaro. ");
INSERT INTO zin_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mbwéenu, obuchilo Yeézu yaahuliize nka nikwo Lazáaro akaba ali omulwéele, yaázeendelela kwíikala ahaantu áaho ebilo bibili. ");
INSERT INTO zin_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mala káyaamazile éebyo, niho Yeézu yaábagaambila abaheémba boómwe aáti, “Tusubeyo okwo Yudea.” ");
INSERT INTO zin_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Abaheémba boómwe baámusubiza báti, “Mweégesa, no óobu zuba zuba nka nikwo Abayahudi bakaba nibeénda kukuhoonda na amabáale babone kukwíita. Ha bwaáchi nooyeénda kusubayo káandi okwo?” ");
INSERT INTO zin_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeézu yaábagalulila aáti, “Ngási, nyemisana tezila amasáaha ikúmi na abili? Kábilaaba omuuntu naalibata nyemisana, tiyaákuhicha kweékuumpa okugulu kwoómwe, habwo kuba omwaanga gwe éensi ezi nigumumulikila byóona. ");
INSERT INTO zin_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Náho óogwo alikulibata omu chilo naayekuúmpa, habwo kuba omwaanga gwo kumumulikila tigulimo.” ");
INSERT INTO zin_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Obuchilo Yeézu káyaamazile kugaamba áago, yaázeendelela kugaambila abaheémba boómwe aáti, “Munywáani wéetu Lazáaro abyaámile, náho niinzeénda kumwiimucha.” ");
INSERT INTO zin_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Niho abaheémba boómwe baámusubiza báti, “Mukáma, keélaaba alyaamile, naachila.” ");
INSERT INTO zin_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Abaheémba boómwe bakateekuza nka nikwo naateekelela nka nikwo Lazáaro alyaamile otúlo, náho Yeézu akaba naamanyisa nka nikwo yaáfwiile. ");
INSERT INTO zin_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Niho, Yeézu kubagaambila butúnu aáti, “Lazáaro yaáfwiile. ");
INSERT INTO zin_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Náho íinye niinulilwa nka nikwo mbele ntaliho obuchilo Lazáaro naakába, kuba íimwe mubóne kuunyikiliza. Mbwéenu, tuzeénde owoómwe.” ");
INSERT INTO zin_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Niho omuheémba oómo izíina lyoómwe Tomaso óogwo izíina elíindi akaba ayétwa Iloongo, yaábagaambila abaheémba bazeenzíbe aáti, “Neechwe tuzeénde, tubone kufwa hamo náwe.” ");
INSERT INTO zin_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mbwéenu, obuchilo Yeézu yaahikileyo okwo, yaásaanga Lazáaro akaba yaámazile ebilo bina omu chiláalo. ");
INSERT INTO zin_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Omugoongo gwa Betania gukaba guli nke ekilomíita isatu kwoónka kuluga Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Abayahudi béenzi bakaba beézile Betania kusuumbilila Marita na Mariamu, habwo olufu lwa Lazáaro munyáanya wáabo. ");
INSERT INTO zin_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mbwéenu, obuchilo Marita yaáhuliile nka nikwo Yeézu akaba naayiza, yaásohola ahéelu, yaázeenda kumunyegeza. Kwoónka weényini Mariamu yaásigalila omúka. ");
INSERT INTO zin_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marita yaámugaambila Yeézu aáti, “Mukáma, káwaakubeele oliho aha, munyaányeenye tiyaákufwíile. ");
INSERT INTO zin_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Náho no óobu nyini niinsoomboókelwa nka nikwo, choóna chóona éecho olaamusaba Múungu, naakuha.” ");
INSERT INTO zin_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yeézu yaámugalulila aáti, “Munyaányoko alaázooka.” ");
INSERT INTO zin_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marita yaámuzila aáti, “Niinsoomboókelwa nka nikwo aha chilo cho muheleeluko cho kuzooka kwa abaantu, náwe alaázooka.” ");
INSERT INTO zin_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeézu yaámugalulila aáti, “Íinye níinye okuzooka no obulami. Omuuntu weéna wéena óogwo alikuunyikiliza íinye, no óobu alaáfwa, aláaba omulame. ");
INSERT INTO zin_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na weéna wéena óogwo ali mwooyo no kuunyikiliza íinye, talifwa nakáti. Ngási, noogeekiliza ago?” ");
INSERT INTO zin_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marita yaámugalulila aáti, “Mazima Mukáma, niinyikiliza nka nikwo íiwe oli Masihi, Mutábani wa Múungu, óogwo alikwíiza omu nsi.” ");
INSERT INTO zin_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Obuchilo Marita akagaamba ago, aba yaázeenda kumwéeta Mariamu ali muhala wáabo, yaámuhweéhweetela aha bweeseléke aáti, “Omweégesa aliho aha, naakweéta.” ");
INSERT INTO zin_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Obuchilo Mariamu yaáhuliile aátyo, yeémuka bwaangu, yaáza ahali Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Akáanya ako, Yeézu akaba achaali atakataahile omu mugoongo ogwo, náho akaba ali áaho Marita akazeenda kumunyegeza. ");
INSERT INTO zin_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Abayahudi abaabeele bali hamo na Mariamu kumusuumbilila, kábaabweene naayimuka no kulugáho bwaangu. Bityo baámukulaatíla, habwo kuba bakateékuza nka nikwo naazeénda aha chitúulo abone kuchulilayo okwo. ");
INSERT INTO zin_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Obuchilo Mariamu yaáhikile áaho Yeézu akaba ali, akamubona, yaáteela ebizwi omu méeso goómwe, yaámugaambila aáti, “Mukáma, káwaakubeele oliho aha, munyaányeenye tiyaákufwíile.” ");
INSERT INTO zin_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Obuchilo Yeézu yaamubwéene Mariamu naachula, na Abayahudi abo béeza náze káandi nibachula, yaáhulila obusúungu bwooli omu mwooyo gwoómwe, yaázululukilwa bwooli. ");
INSERT INTO zin_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mbwéenu, yaábabúuza aáti, “Mumuziikile nkáhi?” Baámusubiza báti, “Mukáma, iíza ohaléebe.” ");
INSERT INTO zin_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeézu yaáchula. ");
INSERT INTO zin_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mbwéenu, Abayahudi abaabeele bali aha lufu baágaamba báti, “Muléebe óokwo abeele naamweénda Lazáaro!” ");
INSERT INTO zin_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Náho abáandi omuli abo baágaamba báti, “Ngási, ogu muuntu tíwe ayaahuumbulwiile ogwo muhume, tiyaákuhikize kumukolela no ogu Lazáaro ataákufwa?” ");
INSERT INTO zin_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Niho Yeézu yaáhulila káandi kuzololokelwa bwooli omu muganya gwoómwe, yaáhika aha mbi. Eémbi ezo ekaba eli enyaanga éezo echiingisiibwe ni ibáale liháango. ");
INSERT INTO zin_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeézu yaábagaambila abaantu áabo bakaba baliho aho aáti, “Muliíheho ibáale elyo.” Náho Marita, munyáanya Lazáaro ogwo chífwa, yaámugalulila aáti, “Mukáma, óobu naanúunka, aha kuba yaámazile ebilo bina ali omu chitúulo.” ");
INSERT INTO zin_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yeézu yaámugaambila aáti, “Ngási, tinaákugaambila nka nikwo, keélaaba nooyikiliza, noolibona ikuzo lya Múungu?” ");
INSERT INTO zin_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mbwéenu, beehaho elyo ibáale. Yeézu alalamila améeso goómwe olugulu, aneémbelela ahali Múungu aáti, “Táata, niinkusiima habwo kuba waánhulila. ");
INSERT INTO zin_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Íinye mba niinsoomboókelwa nka nikwo ompulila buchiile, mbwéenu niingaámba amagaambo aga habwe embága ya aba baantu aba abakobile aha, kuba babone kwiikiliza nka nikwo íiwe níiwe okaannsiíndika.” ");
INSERT INTO zin_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Obuchilo Yeézu yaámazile kugaamba ago, yaáhamuka ahi iláka liháango naagaámba aáti, “Lazáaro, iíza kunu ahéelu!” ");
INSERT INTO zin_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mbwéenu, Lazáaro óogwo akaba afwiile, yaásohola ahéelu. Amagulu ne emikono yoómwe ziseembilwe isáanda, káandi obuso bwoómwe buseembilwe isila. Niho Yeézu yaábalagila aáti, “Mumusuulule emyéenda ezo, mumuleke azeénde.” ");
INSERT INTO zin_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mbwéenu, Abayahudi béenzi áabo bakaba beézile ahali Mariamu, obuchilo baabweene áago Yeézu akakola, baámwiíkiliza. ");
INSERT INTO zin_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Náho Abayahudi abáandi omuli abo baba baázeenda aha Bafarisayo, baábasoomboolela éebyo Yeézu yaákola. ");
INSERT INTO zin_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mbwéenu, abakúlu ba abagabe na Abafarisayo baáyetesa echiikalo chi Itégekelo lya Balusiingo ba Abayahudi, beébuuza báti, “Tukole chi? Óogu muuntu naakola eméenko nyíinzi. ");
INSERT INTO zin_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kábilaaba nitumuleka azeendelele kukola ago mahano, abaantu bóona nibamwiikiliza. Niho Abarúumi baléeza no kusiisa byóona, ihaánga lyéetu, hamo ni isomelo lyéetu.” ");
INSERT INTO zin_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Omuuntu oómo omuli abo balusiingo izíina lyoómwe Kayafa, óogwo akaba ali omugabe mukúlu wo omwáaka ogwo, yaábagaambila aáti, “Íimwe timukusoombookelwa choóna chóona!” ");
INSERT INTO zin_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ngási, timukusoombookelwa nka nikwo, ni haáchili hali íimwe nka nikwo omuuntu oómo afweéle embága yóona, kuchila ihaánga lyóona lisiingaálichibwe? ");
INSERT INTO zin_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafa talagaambile ago habwe ebiteékuzo byoómwe weényini, náho habwo kuba akaba ali omugabe mukúlu wo omwáaka ogwo. Bityo akaba naabáasa nka nikwo Yeézu alaáfwa habwe éensi ya Abayahudi, ");
INSERT INTO zin_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na ti habwa boónyini boónka, náho na habwo kusuumbya abáana ba Múungu áabo abasaambeele omu nsi, babone kuba hamo. ");
INSERT INTO zin_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kulugiilila echilo echo, abatégeki ba Abayahudi baákola omweétegeko gwo kumwíita Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ha bwéecho, Yeézu yaálekelela kulibata ha bwéelu omu Bayahudi. Yaalugáho aho no kuzeenda héehi no omu nsi yo obwoóma, omu muzihwa óogwo gukaba gweetwa Efraimu, yeékala okwo hamo na abaheémba boómwe. ");
INSERT INTO zin_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Obuchilo obwo, echilo chikúlu cha Abayahudi echilikwéetwa Paásika chikaba cheéliliza. Ha bwéecho, abaantu béenzi baalugáyo omu maboma gáabo kuzeenda Yeruzaléemu, babone kweéloonza kala habwo kweéyeza. ");
INSERT INTO zin_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Abaantu baaba nibamuloondela Yeézu. Obuchilo bakaba beemeeliile omu lubúga lwe éenzu ya Múungu, beébuuza báti, “Íimwe nimuleebaho muta? Omuuntu ogwo takwiiza aha mazenyi aga?” ");
INSERT INTO zin_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Abakúlu ba abagabe na Abafarisayo bakaba balagiile nka nikwo, omuuntu weéna wéena óogwo alikumanya áaho Yeézu ali, aleéte empola hali boónyini babone kumuta omuli itaanu. ");
INSERT INTO zin_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kabyaasigeele ebilo mukáaga kuhika amazenyi ga Paásika, Yeézu yaáhika káandi Betania áaho yaabeele atúula Lazáaro. ");
INSERT INTO zin_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mbwéenu, abaantu ba aho baámuloongeza amazenyi. Marita yaámuheéleza, na Lazáaro akaba ali oómo omu baantu áabo abaabeele beékeele aha luhelo hamo na Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mbwéenu, Mariamu yeemucha enusu líita ya amazuta galikweetwa nardo galikwéela ageena obukaani buháango na geena omuzeeze muluunzi. Yaásiiga aha magulu ga Yeézu, yaágakubula amagulu ga Yeézu habwi isóke lyoómwe ogwo mukázi. Éenzu yóona yaásohoza omugaazu muluunzi gwe emizeeze. ");
INSERT INTO zin_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Náho oómo wa abaheémba boómwe, izíina lyoómwe Yuda Iskariote, óogwo alaámukoonga kóonga Yeézu, yaámuzila nka nikwo, ");
INSERT INTO zin_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ha bwaáchi amazuta ago tigaáguzwa edináali magána asatu no kuhaabwa abahabi?” ");
INSERT INTO zin_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yuda talagaambisiibwe ebyo habwo kusaaswa abahabi, náho na habwo kuba akaba ali omwíibi. Yuda niwe akaba naasutula enfulebe ye empilya, na akaba ayiba empilya ezikaba ziteebwa omu nfulebe ezo. ");
INSERT INTO zin_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mbwéenu, Yeézu yaámugalulila Yuda aáti, “Omuléke, habwo kuba yaánsiiga amazuta habwe emiloonzo ye echo chilo éecho baliinzíika. ");
INSERT INTO zin_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Abahabi mwiinábo ebilo byóona, náho íinye tiínkúba hamo neemwe ebilo byóona.” ");
INSERT INTO zin_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mbwéenu, Abayahudi béenzi baáhulila nka nikwo Yeézu akaba ali ahaantu aho, baázeenda kumubona, ti weényini kwoónka, náho káandi kumubona Lazáaro óogwo Yeézu akamuzoola kuluga omu bafwiile. ");
INSERT INTO zin_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Niho abakúlu ba abagabe baákola enteba yo kumwíita Lazáaro káandi, ");
INSERT INTO zin_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","habwe ensoonga yo kuzoolwa kwoómwe, Abayahudi béenzi baámwiíkiliza Yeézu, baáyeliga na abatégeki báabo. ");
INSERT INTO zin_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nyeéncha eémo, embága mpaango ya abaantu áabo bakaba beezíle kulya obuzenyi bwa Paásika, baáhulila nka nikwo Yeézu ali omu muháanda kwíiza Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mbwéenu, baátwáala amatábazi ge emichíindo, baázeenda kumusuúngaana Yeézu. Baáyaambaza ahi iláka nibagaámba báti, “Hosana! Ayina omugisa óogwo alikwíiza ahi izíina lyo Omukáma Múungu! Ayina omugisa Omukáma wa Abaiziraeli.” ");
INSERT INTO zin_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mbwéenu, Yeézu yaásaanga omwaana gwe ensíkili, yaáguhanama nko óokwo chaandikilwe omu Maandiko Matakatíifu chíti, ");
INSERT INTO zin_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Íimwe abaantu ba Sayuni, mutatiina! Léeba, omukáma wáanyu naayiza, ahanamile omwaana gwe ensíkili!” ");
INSERT INTO zin_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Obuchilo obwo, abaheémba ba Yeézu tibalasoombookiilwe ago. Náho obuchilo Yeézu yaabele yaázookile niho beézuka nka nikwo amagaambo ago gakaaandikwa na nikwo óokwo baamukoliile. ");
INSERT INTO zin_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Abaantu abaabeele bali hamo na Yeézu obuchilo óobwo yaáyesile Lazáaro kuluga omu chitúulo no kumuzoola kuluga omu bafwiile, baaba nibaatula empola ezo omu baantu. ");
INSERT INTO zin_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ha bwéecho, abaantu béenzi bakabonesa kuhulila empola ze eméenko éezo Yeézu akakola. Echo nicho chikakola abaantu béenzi baásohola Yeruzaléemu kuzeenda kumusuúngaana Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Náho Abafarisayo beégaambila báti, “Nimuléeba! Titúkuhicha kukola choóna chóona! Muléebe, abaantu bóona nibamukulaatíla.” ");
INSERT INTO zin_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hakaba heena abaantu áabo bakaba bali Abanyamahaánga, omuli abo baantu bakaba balimo áabo bakazeenda Yeruzaléemu habwa amazenyi ga Paásika. ");
INSERT INTO zin_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mbwéenu, abaantu abo baázeenda ahali Filipo óogwo akalugiilila Betisaida okwo omu nsi ya Galiláaya, baámusaba báti, “Owi isima, nitusaba tubonane na Yeézu.” ");
INSERT INTO zin_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo yaázeenda kumumanyisa Andrea empola ezo, niho bóona baázeenda kumugaambila Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeézu yaábagalulila aáti, “Obuchilo bwaáhikile hali íinye Mutábani wo Omuuntu kuhaabwa ikuzo. ");
INSERT INTO zin_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mazima butúnu niimbagaambila nka nikwo, kábilaaba akazuma ke engano katakagwiile omu itaka no kufwa, tikakuhicha kumela. Náho kakalaáfwa, nikamela no kuzáala enzuma nyíinzi. ");
INSERT INTO zin_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Omuuntu weéna wéena óogwo alikweenda kuchigilila obulami bwoómwe, naabulwa obulami bwo obucha no obuchiile. Náho weéna wéena óogwo atakusaaswa obulami bwoómwe omu nsi ezi, óogwo naabuchuungula obulami bwoómwe kuhicha obucha no obuchiile. ");
INSERT INTO zin_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Omuuntu weéna wéena óogwo alikuunheéleza íinye, neeyeendelwa ankulaatile. Hoóna hóona áaho ndi, aho niho omuzáana waanze aláaba aáli. Táata naamukuza omuuntu weéna wéena óogwo alikuunheéleza íinye.” ");
INSERT INTO zin_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Niho Yeézu yaámuzila aáti, “Óobu naábaanza kuzuzubalilwa bwooli omu muganya gwaanze. Ngaámbe chiíha? Ngási, ngaámbe nka nikwo, ‘Íiwe Táata, niinkusába onchuúngule kuluga aha buchilo óobu bwe ebyaágalalo?’ Mmahi, tinaákuhicha kusaba iíntyo, habwo kuba nnyizile omu nsi ezi kuba nsaángwe ebyaágalalo ebyo. ");
INSERT INTO zin_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Íiwe Táata Múungu, osuulule ikuzo li izíina lyaawe.” Niho iláka liluga omu igulu niligaámba líti, “Naásuulula ikuzo lyaanze, káandi niinzeendelela kulisuulula.” ");
INSERT INTO zin_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Embága ya abaantu áabo abaabeele beemeeliile aho, obuchilo bahuliile elyo iláka, abáandi bakagaamba báti, “Ne enkuba,” na abáandi bakagaamba báti, “Maléeka yaágaamba gaamba náze.” ");
INSERT INTO zin_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Náho Yeézu yaábagaambila aáti, “Iláka éelyo mwaáhulila libeele litali ha bwaánze, náho hali íimwe. ");
INSERT INTO zin_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Óobu bwaáhikile obuchilo bwa Múungu kuzichwaáziikila éensi ezi. Óobu bwaáhikile obuchilo bwo kulitaágucha ahéelu Isitáani éelyo lili omutégeki we éensi ezi. ");
INSERT INTO zin_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Obuchilo óobwo íinye ndaayeleezibwa olugulu ye éensi, niinkwéesa abaantu bóona babone kwiiza hali íinye.” ");
INSERT INTO zin_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yeézu akagaamba aátyo, kwoóleka ni lufu chi óolwo alaáfwa. ");
INSERT INTO zin_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mbwéenu, embága ezo yaámusubiza Yeézu eéti, “Tusomile omu Maandiko Matakatíifu nka nikwo, Masihi naába omulame obucha no obuchiile. Mbwéenu, ha bwaáchi noogaámba nka nikwo, ni lwaampaka Mutábani wo Omuuntu ayeleezibwe olugulu? Ngási, Mutábani wo Omuuntu ogu noóha?” ");
INSERT INTO zin_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeézu yaábagaambila aáti, “Omwaanga niguba hamo neemwe aha káanya kache kwoónka. Muzeendelele kulibata omu mwaanga ogu mucháali muchiinágwo, kuba ensiimbaazi eteéza kubapaámpukilamo. Kuba, omuuntu óogwo alikulibata omu nsiimbaazi, tasoombookelwa áaho alikuzeenda. ");
INSERT INTO zin_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Aha buchilo óobu óobwo mwiina omwaanga, mugwiikilize omwaanga ogwo, mubóne kuba abáana bo omwaanga.” Obuchilo Yeézu yaámazile kugaamba ago, yaásiga embága ya abaantu abo, yaázeenda kweéseleka. ");
INSERT INTO zin_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Náho nóobwo Yeézu yaákozile eméenko nyíinzi omu méeso gáabo, abaantu béenzi tibalamwiíkiliize. ");
INSERT INTO zin_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ekaba eli eétyo gabone kuhikiilizibwa amagaambo áago omubáasi Isaya akagaamba aáti, “Mukáma, noóha óogwo ayikiliize empola zéetu? Káandi, noóha óogwo omusuululiile obuzizi bwaawe?” ");
INSERT INTO zin_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tibalamwiíkiliize habwo kuba Múungu akagaamba kulabila ahali Isaya nka nikwo, ");
INSERT INTO zin_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Naáhumisa améeso gáabo, no kukola emiganya yáabo eébe egumile, batabona kuhweeza habwa méeso, batakusoombookelwa ha miganya, bateéza bakaánhiindukila, neenye nkabachíza.” ");
INSERT INTO zin_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya akagaamba amagaambo aga, habwo kuba akalibona ikuzo lya Yeézu no kugaamba empola zoómwe. ");
INSERT INTO zin_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nóobu bityo, abatégeki béenzi ba Abayahudi bakamwiíkiliza Yeézu. Náho tibalagaambile ha bwéelu nka nikwo baámwiikiliize, habwo kuba bakaba nibatiína kubiingwa na Abafarisayo kuluga omu isomelo. ");
INSERT INTO zin_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Abatégeki abo bakaba nibeénda bwooli kukúzibwa na abaantu, kuchila kukúzibwa na Múungu. ");
INSERT INTO zin_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mbwéenu, Yeézu yaáhamuka iláka naagaámba aáti, “Omuuntu óogwo alikuunyikiliza, takuunyikiliza íinye nyeénka, náho naamwiikiliza na Múungu óogwo akaansiíndika. ");
INSERT INTO zin_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Omuuntu óogwo alikuumbona íinye, naába yaámubona Múungu óogwo akaansiíndika. ");
INSERT INTO zin_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Íinye nnyizile omu nsi ezi nko omwaanga, kuba buli muuntu óogwo alikuunyikiliza, atazeendelela kutúula omu nsiimbaazi. ");
INSERT INTO zin_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Omuuntu weéna wéena óogwo aliba yaáhuliile ebigaambo byaanze, náho akáanga kubikwáata, íinye tiíndimuchwaáziika. Habwo kuba, tiíndeezile omu nsi ezi kuchwaáziika abaantu, náho nnyizile kubachuúngula. ");
INSERT INTO zin_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Omuuntu weéna wéena óogwo alikuunyáanga íinye hamo na amagaambo gaanze, alyaáchwaaziikwa. Amagaambo áago ngaambile, nigo galeeza kumuchwaáziika aha chilo echo cho omuhélo. ");
INSERT INTO zin_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tiíndagaambile amagaambo ago habwo obuzizi bwaanze íinye nyini, náho Táata óogwo ansiindikile niwe yaándagiiliile ebyo kugaamba, no óokwo ndaasoomboola. ");
INSERT INTO zin_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Káandi, niinsoomboókelwa nka nikwo echilagilo choómwe chibabonesa abaantu obulami bwo obucha no obuchiile. Mbwéenu, íinye niingaámba kwoónka áago Táata yaángaambiile ngaámbe.” ");
INSERT INTO zin_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mbwéenu, obuchilo amazenyi ga Paásika gakaba gatakahikile, Yeézu yaásoombookelwa nka nikwo obuchilo bwoómwe bwaáhikile bwo kulugáho omu nsi ezi abone kusuba owe Eése. Yeézu akaba ayina engoonzi na abaantu boómwe omu nsi, na yaázeendelela kubazilila engoonzi bwooli kuhicha omuhélo. ");
INSERT INTO zin_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yeézu na abaheémba boómwe bakaba nibalaagila. Akaziingo ako, Isitáani likaba lyaátaahile omu muganya gwa Yuda, mutábani wa Simoni Iskariote, abone kumukoonga kóonga Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeézu akaba naasoomboókelwa nka nikwo Iíse akamuha obuzizi habwe ebiintu byóona. Káandi akaba naasoomboókelwa nka nikwo akalugiilila ahali Múungu, na nka nikwo alaásuba ahali Múungu. ");
INSERT INTO zin_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mbwéenu, obuchilo nibalya, Yeézu yaáyemeelela, yaázuula enkaanzu yoómwe, yaátwáala enkáanda yaázeekoma omu nyugunyu. ");
INSERT INTO zin_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Niho, yaáchenena améenzi omu lusaabuzo, yaábaanza kwóoza amagulu ga abaheémba boómwe no kugakubula ne enkáanda éezo ayekomile. ");
INSERT INTO zin_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Obuchilo Yeézu yaamuhikaho Simoni Peétero, Peétero yaámubúuza aáti, “Mukáma, íiwe nooyeénda kuunyóza íinye amagulu?” ");
INSERT INTO zin_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeézu yaámugalulila aáti, “Éecho ndikukola, íiwe tokuchisoombookelwa óobu, náho noochisoombookelwa ahaleéza.” ");
INSERT INTO zin_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peétero yaámugaambila aáti, “Íiwe toliinyoza íinye amagulu no obuche bwa akáti!” Yeézu yaámugalulila aáti, “Kábilaaba íiwe nooyaanga ntakwóoza amagulu, tokuhicha kukoba hamo neenye káandi.” ");
INSERT INTO zin_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Peétero yaámugalulila aáti, “Mukáma, kábilaaba ni bityo, otaanyoza amagulu goónka, náho ne emikono yaanze hamo no omútwe gwaanze.” ");
INSERT INTO zin_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeézu yaámugalulila aáti, “Omuuntu óogwo ayaámazile kwóoga, takweendelwa ayoge káandi, náho kunaaba amagulu goónka, habwo kuba yaámazile kwéela. Íimwe mwaámazile kwéela, náho ti mwéena.” ");
INSERT INTO zin_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yeézu akaba naamusoomboókelwa óogwo ayaakumukoonga kóongile, nicho chaaleételiile agaámbe aáti, “Náho ti mwéena áabo mweezile.” ");
INSERT INTO zin_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Obuchilo Yeézu yaámazile kwóoza abaheémba boómwe amagulu gáabo, yaázwaala enkaanzu yoómwe, yeékala nábo káandi, yaábabúuza aáti, “Ngási, mwaáchisoombookelwa éecho naábakolela? ");
INSERT INTO zin_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Íimwe nimuunyeta ‘Omweégesa’ no ‘Omukáma.’ Ago na ga amazima, habwo kuba nikwo ndi. ");
INSERT INTO zin_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mbwéenu kábilaaba íinye ndi Omweégesa wáanyu no Omukáma wáanyu, naáboóza íimwe amagulu, neeyeendelwa íimwe neemwe mube nimweeyoza amagulu mútyo nyini. ");
INSERT INTO zin_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mbaheele omugani, nka nikwo neemwe mube nimweekolela nkeenye óokwo mbakoliíle íimwe. ");
INSERT INTO zin_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mazima butúnu niimbagaambila nka nikwo, omuzáana ti mukúlu kuchila omukáma woómwe, káandi omuuntu óogwo alikusiíndikwa ti mukúlu kuchila óogwo alikumusiíndika. ");
INSERT INTO zin_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mbwéenu kábilaaba mwaágasoombookelwa ago góona, niho Múungu alaábafuuha kamulaaba nimugakolela emilimo. ");
INSERT INTO zin_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Tiínkugaamba ago hali íimwe mwéena. Niimbasoomboókelwa áabo ntoolize kuba abaheémba baanze. Náho ni lwaampaka gahikiilizwe áago agaándikilwe omu Maandiko Matakatíifu nka nikwo, ‘Munywáani waanze óogwo akaba naálya ebyookulya hamo neenye, yaáhiinduka kuba omubisa waanze.’ ");
INSERT INTO zin_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Niimbagaambila ago góona gacháali gatakeésuululukiize, kuba obuchilo óobwo galisuúlulukiza, mwiikilize nka nikwo ‘Íinye Niwe.’ ");
INSERT INTO zin_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mazima butúnu niimbagaambila nka nikwo, omuuntu weéna wéena óogwo alikumwiínaankula óogwo nkamusiíndika, ogwo naába yaányinaánkula neenye. Bityo nyini, óogwo alikuunyinaánkula íinye, naába yaámwiinaankula Táata óogwo akaansiíndika.” ");
INSERT INTO zin_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Obuchilo Yeézu akagaamba amagaambo ago, akazululukilwa bwooli omu mwooyo gwoómwe, yaáyatula naagaámba aáti, “Mazima butúnu niimbagaambila nka nikwo, oómo omuli íimwe naankoónga.” ");
INSERT INTO zin_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Niho abaheémba boómwe baábaanza kweéleeba, habwo kuba tibalasoombookiilwe naamugaámba oóha. ");
INSERT INTO zin_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Oómo omu baheémba boómwe akaba ayegamiile aha chifuba cha Yeézu, omuheémba ogwo niwe akaba ayeéndwa bwooli na Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mbwéenu, Simoni Peétero yaámuleémbeleza omuheémba ogwo, yaámugaambila aáti, “Mubúuze Yeézu nka nikwo noóha omuli íichwe óogwo alikugaamba.” ");
INSERT INTO zin_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Niho omuheémba ogwo akaba ayegamiile aha kalezi ka Yeézu, yaámubúuza aáti, “Mukáma, noóha?” ");
INSERT INTO zin_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeézu yaámugalulila aáti, “No óogwo ndaaha echinogóka cho omukaate éecho ndaakoza.” Mbwéenu, yeemucha echinogóka cho omukaate yaáchikoza, yaaha Yuda, mutábani wa Simoni Iskariote. ");
INSERT INTO zin_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda obuchilo yaáyanaankwiile echinogóka echo cho omukaate, Isitáani lyaamutaahamo. Niho Yeézu aba yaámugaambila aáti, “Áago olikweenda kukola, ogakole bwaangu!” ");
INSERT INTO zin_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Náho talabeeleho no óobu oómo omuli abo abáandi abaabeele bakobile aha luhelo óogwo yaasoombookiilwe ha bwaáchi Yeézu yaábagaambila aátyo. ");
INSERT INTO zin_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Abáandi bakateékuza nka nikwo Yeézu akagaamba aátyo, habwo kuba Yuda akaba ali omubiiki we empilya. Bakateékuza nka nikwo Yeézu akamugaambila Yuda nka nikwo agule ebiintu bya amazenyi ga Paásika, nali nka nikwo abáhe abahabi empilya. ");
INSERT INTO zin_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mbwéenu, obuchilo Yuda akaba yaátwéele echinogóka echo cho omukaate, yaalugáho omwáanya ogwo nyini. Gukaba guli omwáanya gwe echilo. ");
INSERT INTO zin_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mbwéenu, obuchilo Yuda yaabele yaálugileho, Yeézu yaábagaambila abaheémba boómwe aáti, “Óobu ikuzo lyaanze, íinye Mutábani wo Omuuntu, lyeélilila kubonekana butúnu. No óobu ikuzo lya Múungu lilyaábonekana ha bwéelu kulabila ahali íinye. ");
INSERT INTO zin_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kábilaaba ikuzo lyoómwe lyaábonekana kulabila ahali íinye, mbwéenu na Múungu náwe naamanyisa abaantu ikuzo lyaanze íinye Mutábani wo Omuuntu. Alaákola aátyo zuba zuba. ");
INSERT INTO zin_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Íimwe baana baanze enfula, niímba neemwe aha mwáanya mugufu gwoónka. Mulaándoondela, náho nko óokwo mbeele niimbasoomboolela abatégeki ba Abayahudi, bityo nyini niimbagaambila neemwe óobu nka nikwo, ahaantu áaho ndaazeénda íinye, íimwe timukuhicha kuhikaho. ");
INSERT INTO zin_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Óobu, niimbáha echilagilo echisha. Niimbalagila nka nikwo, mweendane. Nko óokwo íinye ndikubéenda íimwe, bityo nyini neemwe mweendane. ");
INSERT INTO zin_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kábilaaba nimweéndana mútyo, aho niho abaantu bóona balaásoombookelwa nka nikwo, íimwe muli abaheémba baanze.” ");
INSERT INTO zin_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mbwéenu, Simoni Peétero yaámubúuza Yeézu aáti, “Mukáma, noóza nkáhi?” Yeézu yaámugalulila aáti, “Ahaantu áaho ndikuza íinye, íiwe tokuhicha kuunkulaatila óobu, náho olaánkulaatila ahaleéza.” ");
INSERT INTO zin_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peétero yaámubúuza aáti, “Mukáma, ha bwaáchi tinaákuhicha kukukulaatila okwo óobu? Íinye ndi bweémi kufwa ha bwaáwe!” ");
INSERT INTO zin_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeézu yaámugalulila aáti, “Ngási íiwe oli bweémi kufwa ha bwaánze? Mazima butúnu niinkugaambila nka nikwo, enkoókolomi etakakoókolomile, noóba waányogile entúlo isatu.” ");
INSERT INTO zin_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeézu yaázeendelela kweégesa abaheémba boómwe aáti, “Mutazuzubalilwa omu miganya yáanyu. Mumwiikilize Múungu, káandi muunyikilize neenye. ");
INSERT INTO zin_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Omu nzu ya Táata, heena obwiikalo bwíinzi. Byaakubeele bitali bityo, mazima naakaábagaambiile nka nikwo niinzeénda kubaloongeza obwiikalo? ");
INSERT INTO zin_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Obuchilo ndaamala kubaloongeza obwiikalo omwo, niinsuba hali íimwe káandi. Niho ndaabatwáala kuzeenda ahaantu áaho ndaaba ndi, neemwe muláaba muli áaho hamo neenye. ");
INSERT INTO zin_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Íimwe nimusoomboókelwa omuháanda gwo kuhika áaho ndikuzeenda.” ");
INSERT INTO zin_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Niho, Tomaso yaábúuza Yeézu aáti, “Mukáma, íichwe titukusoombookelwa áaho olikuzeenda. Mbwéenu nituhicha túta kugusoombookelwa ogwo muháanda?” ");
INSERT INTO zin_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeézu yaámugalulila aáti, “Íinye níinye omuháanda, na amazima, no obulami. Tihaliho omuuntu weéna wéena óogwo ayaakuhicha kuhika ahali Táata kaálaaba atakalabiile hali íinye. ");
INSERT INTO zin_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kábilaaba mwaakuunsoomboókiilwe íinye, aho mukamusoombookiilwe Táata náwe. Kubaandiza óobu, nimumusoombookelwa na mwaámazile kumubona.” ");
INSERT INTO zin_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Niho, Filipo yaámugaambila aáti, “Mukáma, otwoóleke Táata! Echo choónka nichihika.” ");
INSERT INTO zin_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeézu yaámugalulila aáti, “Mbeele ndi hamo neemwe omwáanya gwóona ogwo, íiwe Filipo otakuunsoombookelwa? Omuuntu weéna wéena óogwo ambweene íinye, naába amubweene Táata. Mbwéenu, ha bwaáchi noongaambila nka nikwo, ‘Otwoóleke Táata?’ ");
INSERT INTO zin_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ngási, tokwiikiliza nka nikwo íinye ndi omuli weényini Táata, náwe Táata ali omuli íinye? Amagaambo áago ndikubagaambila tigakulugiilila omu biteékuzo byaanze, náho Táata óogwo ali omuli íinye, naakola emilimo yoómwe kulabila hali íinye. ");
INSERT INTO zin_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mwiikilize éebyo ndikugaamba nka nikwo, íinye ndi omuli weényini Táata, na Táata ali omuli íinye. Náho kamulaaba mutakweenda kwiikiliza áago ndikugaamba, mbwéenu mwiikilize habwe ebikolwa éebyo ndikukola. ");
INSERT INTO zin_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mazima butúnu niimbagaambila nka nikwo, omuuntu weéna wéena óogwo alikuunyikiliza, alaakola emilimo éezo íinye ndikukola. Káandi alaákola emilimo kusaaga éezo íinye ndikukola, habwo kuba íinye niinzeénda ahali Táata. ");
INSERT INTO zin_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kamulaasaba echiintu choóna chóona ahi izíina lyaanze, íinye niinchikola, kuba ikuzo lya Táata libonekane kulabila omuli íinye, Omutábani. ");
INSERT INTO zin_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Echiintu choóna chóona éecho mulaansaba ahi izíina lyaanze, niinchikola.” ");
INSERT INTO zin_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kamulaaba nimuunyeénda, nimubyeekomya ebilagilo byaanze. ");
INSERT INTO zin_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Neenye niimmusaba Táata abáhe Omuhweezi oóndi, abone kuba hamo neemwe omwáanya gwóona. ");
INSERT INTO zin_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ogwo niwe Omwooyo owa mazima. Abaantu be éensi ezi tibakuhicha kumwiínaankula, habwo kuba tibakumubona, káandi tibakumusoombookelwa. Náho íimwe nimumusoombookelwa ogwo Mwooyo, habwo kuba naayikala hamo neemwe, káandi naába ali omuli íimwe. ");
INSERT INTO zin_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Tiínkubasiga íimwe mweénka nke enfúuzi, náho niinsuba káandi hali íimwe. ");
INSERT INTO zin_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hacháali akáanya kache na tiínkubonwa káandi omu nsi ezi. Náho íimwe nimuumbona, habwo kuba ndi omulame, neemwe nimuba muli abalame. ");
INSERT INTO zin_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aha chilo echo, mulaamanya nka nikwo íinye ndi omuli weényini Táata, neemwe muli omuli íinye, neenye ndi omuli íimwe. ");
INSERT INTO zin_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Omuuntu óogwo alikweékomya ebilagilo byaanze, ogwo niwe alikuunyeenda. No omuuntu óogwo alikuunyeenda, Táata náwe alaámwéenda. Neenye ndaámuzilila engoonzi no kweéyoleka hali weényini.” ");
INSERT INTO zin_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda atali ogwo Iskariote, yaámubúuza Yeézu aáti, “Mukáma, nibiba bita nka nikwo oyeyoleke hali íichwe, náho ti ha baantu abáandi be éensi ezi?” ");
INSERT INTO zin_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeézu yaámugalulila aáti, “Omuuntu óogwo alikuunyeenda, ayekomya amagaambo gaanze, náwe Táata alaámwéenda. Káandi íinye na Táata nitwiíza hali weényini no kwíikala hamo náze. ");
INSERT INTO zin_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Náho omuuntu weéna wéena óogwo atakuunyéenda, ogwo tayekomya amagaambo gaanze. Amagaambo áago ndikubasoomboolela ti gaanze, náho na ga Táata óogwo ansiindikile hali íimwe. ");
INSERT INTO zin_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mbagaambíile góona ago, obuchilo ncháali ndi hamo neemwe. ");
INSERT INTO zin_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Náho Omuhweezi ogwo, óogwo ali Omwooyo Mutakatíifu óogwo Táata alaasiindika hali íimwe ahi izíina lyaanze, alaábeegesa no kubeézukiza góona áago nkabagaambila. ");
INSERT INTO zin_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Niimbasigila obuhóolo, obuhóolo bwaanze niimbáha. Obuhóolo óobwo ti nko óobwo muhaabwa ne éensi ezi. Mutazuzubalilwa omu miganya yáanyu, káandi mutatiina choóna chóona. ");
INSERT INTO zin_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mwaáhuliize áago nkabagaambila nka nikwo, ‘Niinzeénda, náho niinsuba káandi hali íimwe.’ Kábilaaba mazima mwakuunyeénzile, mukaánuliilwe kuhulila nka nikwo niinzeénda ahali Táata, habwo kuba Táata ni mukúlu kusaaga íinye. ");
INSERT INTO zin_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Mbagaambíile ago góona óobu, obuchilo ago magaambo gacháali gatakabéeleho, kuba obuchilo óobwo galaabaho, mubóne kuunyikiliza. ");
INSERT INTO zin_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Tinaákuhicha kuhooya neemwe omwáanya mula, habwo kuba omutégeki we éensi óobu naayiza. Náho tayina amagala goóna góona ha bwaánze. ");
INSERT INTO zin_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Amagaambo áago ndikukola nigo áago Táata yaándagiiliile ngakole, kuba abaantu bóona babone kusoombookelwa nka nikwo nnyine engoonzi na Táata. “Óobu, mwiimeelele, tulugeho aha.” ");
INSERT INTO zin_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yeézu yaázeendelela kubeégesa aáti, “Íinye níinye omuzabibu gwa mazima, na Táata niwe omulimi. ");
INSERT INTO zin_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Buli itábazi omuli íinye éelyo elitakuzáala amagoomba, Táata aliihaho. Náho buli itábazi éelyo lilikuzáala amagoomba, Táata alisálila kuba lizaále bwooli. ");
INSERT INTO zin_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Íimwe mwaáyezile, habwa ameégeso gaanze áago naáboolekeeliile. ");
INSERT INTO zin_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mwiikale omuli íinye, neenye niinyikala omuli íimwe. Nko óokwo itábazi litakuhicha kuzáala amagoomba lyoónka litéena kweekwaatilila aha muzabibu, bityo nyini neemwe timwaákuhicha kukola áago Múungu ayeénda mutéena kwíikala omuli íinye. ");
INSERT INTO zin_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Íinye ndi omuzabibu, íimwe muli amatábazi. Omuuntu óogwo alikutúula omuli íinye, neenye niintuúla omuli weényini, ogwo naába alikuzáala amagoomba méenzi, habwo kuba hatéena íinye timwaákuhicha kukola choóna chóona. ");
INSERT INTO zin_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Omuuntu weéna wéena óogwo atakwiikala omuli íinye asuseene ni itábazi éelyo elinogweelwe no kwóoma. Mbwéenu abaantu baálikobya no kulinaga omu mulilo no okusha. ");
INSERT INTO zin_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kamuleekala omuli íinye ne ebigaambo byaanze kabileekala omuli íimwe, mbwéenu mumusabe Táata choóna chóona éecho mulikweenda, náwe naabaha. ");
INSERT INTO zin_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kamulaaba nimuzaála amagoomba méenzi no kuba abaheémba baanze ba amazima, muláaba nimwooleka ha bwéelu ikuzo lya Táata. ");
INSERT INTO zin_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nko óokwo Táata alikunyeenda íinye, nikwo neenye nnyina engoonzi hali íimwe. Mbwéenu mwiikale omu ngoonzi zaanze. ");
INSERT INTO zin_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kamulaaba nimukwaáta ebilagilo byaanze, mbwéenu mulaázeendelela kwíikala omu ngoonzi zaanze, nko óokwo íinye nkwaasile ebilagilo bya Táata no kwíikala omu ngoonzi zoómwe. ");
INSERT INTO zin_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Naábagaambila aga kuba kunulilwa kwaanze kube omuli íimwe, no kunulilwa kwáanyu kuhikiílizwe. ");
INSERT INTO zin_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Echilagilo chaanze nicho echi, mube nimweéndana, nko óokwo íinye ndikubéenda íimwe. ");
INSERT INTO zin_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Táliho omuuntu óogwo ayina engoonzi mpáango kuchila óogwo alikusohoza obulami bwoómwe habwa abanywáani boómwe. ");
INSERT INTO zin_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kamulaaba nimukola áago mbalagiile, íimwe muli banywáani baanze. ");
INSERT INTO zin_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kubaandiza óobu, tiínkubéeta káandi abazáana, habwo kuba omuzáana takusoombookelwa éecho mukúlu woómwe alikukola. Náho íimwe niimbeéta banywáani baanze, habwo kuba naábasuululila góona áago naáhuliile kuluga hali Táata. ");
INSERT INTO zin_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Íimwe timulaantoolize íinye, náho níinye óogwo nkabatóoza íimwe. Nkabaatóoza kuba muzaále amagoomba áago agatakuhwa nakáti. Kámulaakola mútyo, góona áago mulikusaba omu izíina lyaanze, náwe Táata naabaha. ");
INSERT INTO zin_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mbwéenu, Echilagilo chaanze nicho echi, mweendane.” ");
INSERT INTO zin_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yeézu yaázeendelela kubeégesa aáti, “Kábilaaba abaantu be éensi ezi balaabatamwa íimwe, mube nimwiizuka nka nikwo bakeébeembela kuuntámwa íinye. ");
INSERT INTO zin_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kámwaakubeele muli abaantu be éensi ezi, mbwéenu áabo baakubeele nibabeénda nko óokwo balikweenda abaantu báabo. Náho íimwe timukabéele be éensi ezi, habwo kuba mbatoolize kuluga omu nsi óomu. Niyo ensoonga éezo abaantu omu éensi ezi nibabatamwa. ");
INSERT INTO zin_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mwiizuke áago naábagaambiile nka nikwo, ‘Omuzáana ti mukúlu kumusáaga omukáma woómwe.’ Mbwéenu, kábilaaba bakaanyagalaza íinye, balaábaagalaza neemwe káandi. Náho kábilaaba beekiliza ameégeso gaanze, baleekiliza na gáanyu. ");
INSERT INTO zin_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Náho nibabakolela góona ago habwo kuba nimuunkulaatila íinye, káandi habwe ensoonga nka nikwo tibakumumanya óogwo ansiindikile. ");
INSERT INTO zin_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Naakubeele ntaleezile hali boónyini no kugaamba gaamba nábo, mbwéenu tibaákubeele ne ebiheno. Náho óobu, tibakuhicha kweétoonganila nka nikwo tibéena ebiheno. ");
INSERT INTO zin_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Omuuntu weéna wéena óogwo alikuuntámwa íinye, naamutámwa na Táata káandi. ");
INSERT INTO zin_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nkozile amahano maháango áago atakakolaga oóndi. Naakubeele ntalagakozile, tibaákubeele ne ebiheno. Náho óobu, babweene góona áago nkakola, no óobu bityo bacháali baantamilwe, na bamutamilwe Táata káandi. ");
INSERT INTO zin_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aga gabeele kuba amagaambo gahikiilile áago gaandikilwe omu Maandiko Matakatíifu kuba, ‘Bakaantamilwa busa.’ ");
INSERT INTO zin_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Niimmusiindika hali íimwe Omuhweezi, óogwo no Omwooyo Mutakatíifu, wo kubasuululila abaantu bóona amazima. Naaluga hali Táata, no obuchilo alihika hali íimwe, alaáyatula amazima ha bwaanze. ");
INSERT INTO zin_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mále neemwe káandi mulaasiinza empola zaanze, habwo kuba mukaba muli hamo neenye kuluga aha bubaandizo. ");
INSERT INTO zin_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mbagaambíile amagaambo ago góona kuba mutaakukuleka okwiikiliza kwáanyu. ");
INSERT INTO zin_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Abaantu baláaba nibabatóla íimwe omu masomelo. Nibwiíza obuchilo óobwo kábilaaba omuuntu naabeéta, alaateekuza nkokwo naakola emilimo ya Múungu. ");
INSERT INTO zin_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nibabakolela bátyo, habwo kuba tibakumumanya Táata, káandi íinye, tibakuummanya. ");
INSERT INTO zin_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Náho niimbagaambila ago, kuba obuchilo bwáabo bwo kukola ago áaho bulaahika, mwiizuke nka nikwo naábagaambiile.” “Tiíndabagaambiile ago góona aha bubaandizo, habwo kuba nkaba ndi hamo neemwe. ");
INSERT INTO zin_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mbwéenu, óobu naázeenda hali Táata óogwo ansiindikile hali íimwe. Náho táliho weéna wéena ahagáti yáanyu óogwo alikubúuza nka nikwo, ‘Ngási, noozeénda nkáhi?’ ");
INSERT INTO zin_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mwaázuzubalilwa bwooli omu miganya yáanyu habwo kuba niimbagaambila kuba niinzeénda hali Táata. ");
INSERT INTO zin_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Niimbagaambila amazima, ni kuzima hali íimwe nka nikwo naázeenda hali Táata. Kaándaaba ntakuzeenda, Omuhweezi ogwo tiyaákuhicha kwíiza hali íimwe. Náho kaándaaba niinzeénda, niimmusiindika hali íimwe. ");
INSERT INTO zin_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Obuchilo kaáliíza ogwo Muhweezi, alaazimanyisa éensi habwe ebiheno, amazima no omuchwaáziiko. ");
INSERT INTO zin_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Aláaba naabooleka nka nikwo na abaheni, habwo kuba tibakuunyikiliza íinye. ");
INSERT INTO zin_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Alaayoleka nka nikwo íinye ndi owa amazima habwo kuba niinzeénda hali Táata na tímuliimbona káandi. ");
INSERT INTO zin_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aláaba naabooleka ha bwéelu kuba Múungu alyaábachwaáziika habwe ensoonga yaálichwaáziika Isitáani, elilikutegeka éensi ezi. ");
INSERT INTO zin_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ncháali nchiinágo méenzi go kubasoomboolela, náho obuchilo óobu timwaákuhicha kugasoombookelwa. ");
INSERT INTO zin_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Omwooyo ogwo owa mazima, obuchilo aléeza hali íimwe, alaábeebeembelela kusoombookelwa amazima mwéena. Taligaamba habwa amagala goómwe weényini, náho alyaágaamba áago ahuliile no kubasoomboolela áago galaabonwa. ");
INSERT INTO zin_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Omwooyo ogwo aláaba naabooleka ikuzo lyaanze, habwo kuba alaábagaambila góona áago alihulila kuluga hali íinye. ");
INSERT INTO zin_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ebiintu byóona éebyo Táata ayinabyo ne ebyaánze. Niyo ensoonga niingaámba kuba Omwooyo ogwo naabagaambila góona áago naába agahuliile kuluga hali íinye.” ");
INSERT INTO zin_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kacháali akáanya kache neemwe timuliimbona, káandi kacháali akáanya kache neemwe mulyaámbona.” ");
INSERT INTO zin_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mbwéenu, abaheémba boómwe abáandi beébuuza báti, “Ngási, ensoonga yaáho ni chiíha áago yaágaamba nka nikwo, ‘Kacháali akáanya kache neemwe timuliimbona, káandi kacháali akáanya kache neemwe mulyaámbona,’ na nka nikwo, ‘Niinzeénda hali Táata’?” ");
INSERT INTO zin_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mbwéenu, baáguma kweébuuza báti, “Ensoonga yaáho ni chiíha, ‘Akáanya kache’? Íichwe titukusoombookelwa áago yaágaamba.” ");
INSERT INTO zin_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeézu yaásoombookelwa kuba bakaba nibeénda kumubúuza áago agaambile, mbwéenu yaábabúuza aáti, “Ngási, nimweebuúza habwa áago naágaamba nka nikwo, ‘Kacháali akáanya kache neemwe timuliimbona, káandi kacháali akáanya kache neemwe mulyaámbona’? ");
INSERT INTO zin_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mazima butúnu niimbagaambila nka nikwo, íimwe mulaalila no kuzolelwa, náho abaantu be éensi ezi balaánulilwa. Mulaazolelwa, náho entíimba zéenyu zilaáhiinduka kuba amanulilwa. ");
INSERT INTO zin_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nko omukázi alikuzeenda kuzáala omwaana, azuzubalilwa habwo kuba obuchilo bwo olwaágalalo lwoómwe bwaáhika. Náho obuchilo yaázáala, takwiizuka káandi olwaágalalo olwo habwa amanulilwa go kuzaalwa omwaana omu nsi. ");
INSERT INTO zin_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Íimwe káandi mwiina entíimba aha mwáanya. Náho ndéeza káandi hali íimwe, mbwéenu muláaba na manulilwa omu miganya yáanyu. Táliho óogwo aligeehaho amanulilwa ago kuluga omu miganya yáanyu. ");
INSERT INTO zin_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Káandi echilo echo, timuliimbúuza echigaambo choóna chóona. “Mazima butúnu niimbagaambila nka nikwo, góona áago mulikusaba omu izíina lyaanze, náwe Táata naabaha. ");
INSERT INTO zin_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kuhicha óobu, timukasabile choóna chóona hali Múungu ahi izíina lyaanze. Musabe hali Múungu, náwe naabaha. Aha muháanda ogwo mulaázeendelela kuba na manulilwa bwooli omu miganya yáanyu.” ");
INSERT INTO zin_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Niimbagaambila góona ago aha muháanda gwe emigani. Obuchilo nibwiíza óobwo ntaligaamba neemwe aha muháanda gwe emigani, náho ndaábagaambila ha bwéelu habwa Táata. ");
INSERT INTO zin_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Omu buchilo obwo, mulaakolesa izíina lyaanze kumusaba Múungu. Tiínkugaamba kuba íinye ndaábasabila hali Táata. ");
INSERT INTO zin_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Weényini Táata abeénda íimwe, habwo kuba íimwe nimuunyeénda íinye, káandi mwiikiliize kuba nkaluga hali Táata. ");
INSERT INTO zin_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nkeeza omu éensi ezi kuluga hali Táata, náho óobu niinduga omu nsi omu, niinsuba hali Táata.” ");
INSERT INTO zin_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mbwéenu abaheémba boómwe baámugaambila báti, “Óobu waábaanza kugaamba neechwe otéena kukoza emigani! ");
INSERT INTO zin_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mbwéenu, óobu twaásoombookelwa nka nikwo noomanya góona, káandi tokweenda omuuntu kukubúuza choóna chóona. Ago nigo áago gatukozile kwiikiliza nkokwo okaluga hali Múungu.” ");
INSERT INTO zin_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeézu yaábabúuza aáti, “Ngási, mwaányiikiliza óobu? ");
INSERT INTO zin_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Obuchilo bweélilila, káandi buli héehi bwooli, obuchilo bwóona mulaásaambaala. Buli oómo alaazeenda owaabo, no kuúndeka íinye nyeénka. Náho tiínkúba íinye nyeénka, habwo kuba Táata ali hamo neenye. ");
INSERT INTO zin_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Íimwe enfula, naábagaambila ago góona kuba mube no obuhóolo omu miganya yáanyu, habwo kuba muli omuli íinye. Omu nsi omu mulaabonesa ebyaágalalo bíinzi, náho mutatiina habwo kuba íinye naázisíinga éensi.” ");
INSERT INTO zin_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Obuchilo Yeézu káyaamazile kugaamba góona ago, yaálalamila omu igulu, yaáneembelela aáti, “Íiwe Táata, obuchilo bwaáhikile. Oboóleke abaantu ikuzo lyaanze íinye Mutábani waawe, kuba neenye mbooleke ikuzo lyaawe nko óokwo lili. ");
INSERT INTO zin_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ompeéle obuzizi hali bóona abeene omubili, kuba mbone kubaha obulami bwo bucha no buchiile bóona áabo waampéele. ");
INSERT INTO zin_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Obulami bwo bucha no buchiile nibwo óobu, abaantu bakumanye íiwe Múungu owa mazima, íiwe weénka, káandi baammanye íinye Yeézu Kristu, óogwo okaansiíndika hali boónyini. ");
INSERT INTO zin_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Íinye naáyoleka ikuzo lyaawe aha abaantu bóona omu nsi, kulabila omu emilimo éezo okaansiíndika kuzikola. ");
INSERT INTO zin_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Íiwe Táata, niinsaba oyoleke ikuzo lyaanze, ikuzo éelyo nkaba nnyina obuchilo tuli hamo, obuchilo ochaali otakahaangile éensi.” ");
INSERT INTO zin_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nkukozile okumuúke aha baantu áabo waampéele abaabeele bali abe éensi ezi. Boónyini bakaba bali abaawe, neewe wabaámpa íinye. Mále bakwaasile echigaambo chaawe. ");
INSERT INTO zin_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Óobu baásoombookelwa nkokwo ebiintu byóona éebyo okaámpa, bilugile hali íiwe, ");
INSERT INTO zin_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","habwo kuba naábagaambila góona áago okaángaambila, nábo bagenaánkwiile. Nibasoomboókelwa mazima kuba ndugile hali íiwe, káandi beekilize kuba níiwe óogwo okaansiíndika. ");
INSERT INTO zin_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Niimbasabila abo habwo kuba na abaantu baawe. Tiínkubasabila abaantu bóona be éensi ezi, náho niimbasabila áabo okaámpa boónka. ");
INSERT INTO zin_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Abaantu bóona abali abaánze na abaawe, káandi abaantu bóona abali abaawe na abaánze. Ikuzo lyaanze lisuululiilwe kulabila hali boónyini. ");
INSERT INTO zin_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Íinye niinyíza hali íiwe, mbwéenu tiínkubaho káandi omu nsi óomu. Náho boónyini nibazeendelela kuba omu nsi aha. Íiwe Táata Omutakatíifu, niinkusába obeemanye aha buhicha bwi izíina lyaawe éelyo ompeéle, kuba babe chiintu chimo nko óokwo íinye neewe tuli chiintu chimo. ");
INSERT INTO zin_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Obuchilo nkaba ndi hamo nábo, nkaba mbeemanyile aha buhicha bwi izíina lyaawe éelyo waampéele. Nkaba niimbaléeba kuzima kuba ntaákubuza no óobu oómo omuli abo, choónka óogwo alikweendelwa kusiingaalichwa, kuba bihikiilizwe éebyo ebyaandikilwe omu Maandiko Matakatíifu. ");
INSERT INTO zin_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Íiwe Táata, óobu niinyíza hali íiwe. Íinye niimbagaambila abaheémba baanze góona ago obuchilo ncháali nchili omu nsi ezi, kuba amanulilwa gaanze gahikiilizibwe omu miganya yáabo. ");
INSERT INTO zin_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Niimbagaambila abaheémba baanze empola éezo ompeéle. Náho abaantu bo omu nsi ezi babatamilwe, habwo kuba boónyini ti bo omu nsi óomu, nko óokwo íinye ntali wo omu nsi óomu. ");
INSERT INTO zin_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Íiwe Táata, tiínkusaba nka nikwo obeéhémo omu nsi óomu, náho nka nikwo obachigilile ne neelyo Izilwa, Isitáani. ");
INSERT INTO zin_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Boónyini ti bo omu nsi óomu nko óokwo íinye ntali wo omu nsi óomu. ");
INSERT INTO zin_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Íiwe Táata, niinkusába obeeze babe abaantu baawe, omu mazima gaawe, habwo kuba echigaambo chaawe nicho amazima. ");
INSERT INTO zin_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nko óokwo okaansiíndika íinye omu nsi, bityo nyini neenye naábasiindika boónyini omu nsi. ");
INSERT INTO zin_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Naáyetaho kukukólela íiwe habwe ensoonga yáabo, kuba na abo beézwe omu mazima.” ");
INSERT INTO zin_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Tiínkubasabila boónyini boónka, náho niimbasabila bóona áabo abaleekiliza habwa amagaambo áago abaheémba baanze nibaboolekeelela. ");
INSERT INTO zin_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Niinsaba nka nikwo abo babe echiintu chimo. Táata, niinsaba babe omuli íichwe, nko óokwo íiwe oli omuli íinye, neenye ndi omuli íiwe. Niinsaba kuba babe echiintu chimo, kuba abaantu be éensi beekilize nkokwo níiwe óogwo okaansiíndika. ");
INSERT INTO zin_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ikuzo éelyo okaámpa íinye, naábaha abaheémba baanze, kuba babe echiintu chimo, nko óokwo íinye neewe tuli echiintu chimo. ");
INSERT INTO zin_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Íinye ndi omuli boónyini, neewe oli omuli íinye. Niinsaba nka nikwo babe echiintu chimo butúnu, nka nikwo aha muháanda ogwo abaantu bóona bo omu nsi basoombookelwe nkokwo níiwe óogwo okaansiíndika, káandi basoombookelwe nkokwo noobeénda nko óokwo olikuunyeenda íinye. ");
INSERT INTO zin_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Íiwe Táata, niindígila kuba áabo waampéele babe hamo neenye áaho ndikuba ndi, kuba balibone ikuzo lyaanze éelyo okaámpa, habwo kuba okaányéenda no óobu ochaali kuhaanga éensi. ");
INSERT INTO zin_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Íiwe Táata owa amazima, abaantu bo omu nsi óomu tibakukusoombookelwa. Náho íinye niinkusoomboókelwa, káandi abaheémba baanze nibasoomboókelwa kuba níiwe óogwo okaannsiíndika. ");
INSERT INTO zin_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Íinye mbeegesize nko óokwo íiwe oóli, káandi niinzeendelela kukola iíntyo, kuba beendane nko óokwo olikuunyeenda íinye, káandi mbone kuba omuli boónyini.” ");
INSERT INTO zin_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Obuchilo Yeézu káyaamazile kusaba, yaalugaho na abaheémba boómwe, yayaambuka omu iholoola lya Kidroni, áaho hakaba guliho omusili gwe emizeituni. Baátaaha omwo. ");
INSERT INTO zin_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mbwéenu, Yuda óogwo akamukoonga kóonga Yeézu, akaba naagumanya omusili ogwo, habwo kuba Yeézu akamanyiila kuzeenda omwo enchilo nyíinzi hamo na abaheémba boómwe. ");
INSERT INTO zin_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mbwéenu, Yuda yaázeebeembelela embága ya abalwaanila ngoma, hamo na abazáana abáandi kuluga aha bakúlu ba abagabe na aha Bafarisayo. Baázeenda omu musili ogwo, bakwáasile emyaanga, ebimuli ne ebikwáato. ");
INSERT INTO zin_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeézu akamanya góona áago gakaba nigategezwa kukolwa hali weényini. Mbwéenu, yeelila omu méeso, yaábabúuza abaantu abaabeele beezíle aáti, “Ngási, nimumuloondela oóha?” ");
INSERT INTO zin_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Boónyini baámusubiza báti, “Nitumuloondela Yeézu Omunyanazaréeti.” Yeézu yaábagalulila aáti, “Íinye níinye.” Yuda óogwo akamukóonga kóonga Yeézu akaba ayemeeliile hamo na abasilikale abo. ");
INSERT INTO zin_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mbwéenu, obuchilo Yeézu yaábagaambiile aáti, “Íinye níinye,” abasilikale abo baásuba enyuma no kugwa ahaansi. ");
INSERT INTO zin_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yeézu yaábabúuza káandi aáti, “Ngási, nimumuloónda oóha?” Boónyini baámusubiza báti, “Nitumuloondela Yeézu Omunyanazaréeti.” ");
INSERT INTO zin_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yeézu yaábagaambila aáti, “Niimbagaambila nkokwo íinye níinye. Kamulaaba nimuundoondela íinye, mbwéenu mubaleke abaantu abali hamo neenye bazeénde.” ");
INSERT INTO zin_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yeézu akagaamba aátyo kuba kuhikiiliza áago akagaamba aha bubaandizo aáti, “Nkaba niimbaliísa kuzima, kuba ntaákubuza no óobu oómo omuli abo áabo okaámpa.” ");
INSERT INTO zin_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Peétero akaba ayina olubáadi, mbwéenu yaálusopoolola, yaámuchwa okutwi kwo obúlyo omuhálila wo omugabe mukúlu. Omuzáana ogwo izíina lyoómwe akaba naayétwa Maliko. ");
INSERT INTO zin_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Náho Yeézu yaámukaama Peétero aáti, “Peétero, subya olubáadi lwaawe omu chiláalo chaálwo. Ngási, tokumanya kuba niinyeendelwa kwaágalazwa nko óokwo Táata aloongize kuba nnyagalazwe?” ");
INSERT INTO zin_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mbwéenu, mukúlu wa abalwaanila ngoma, hamo ne embága yoómwe, na abazáana ba abatégeki ba Abayahudi, baámuta omuli itaanu Yeézu, baámuboha. ");
INSERT INTO zin_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Mbwéenu, baámutwáala ha kubaanza hali Anasi, óogwo akaba ali isézaala wa Kayafa, óogwo akaba ali omugabe mukúlu omwáaka ogwo. ");
INSERT INTO zin_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Omu bilo bye enyuma, Kayafa niwe óogwo akabachóola abatégeki ba Abayahudi kuba ni hachili omuuntu oómo kufwa habwa abaantu bóona. ");
INSERT INTO zin_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Peétero no omuheémba oóndi bakaba nibamukulaatíla Yeézu bwe enyuma. Omuheémba ogwo akaba naamanyíika aha mugabe omukúlu, niwe yaátaaha na Yeézu omu lubuga lwe eéka yo omugabe mukúlu. ");
INSERT INTO zin_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Náho Peétero yaáyemeelela ahéelu omu lwiizi. Niho omuheémba oóndi óogwo akaba naamanyíika aha mugabe mukúlu, yaáluga ahéelu. Yaágaamba gaamba no omuhalákazi oómo óogwo akaba naayemeelela aha chisasi, yaámukuúndila Peétero kuza omu lubúga. ");
INSERT INTO zin_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mbwéenu, omuzaánakazi omuliindilizi ogwo, yaámubúuza Peétero aáti, “Ngási, neewe hanu toli oómo omu baheémba bo omuuntu ogwo?” Peétero yaámugalulila aáti, “Mmahi, ti íinye.” ");
INSERT INTO zin_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Habwo kuba hakaba heena embého, abazáana na abaleebelezi áabo bakaba beemeeliile áaho gwaábeele guliho omulilo gwa amakala, bakaba niboóta omulilo. Náwe Peétero akaba ayemeeliile hamo nábo, akaba naayota omulilo. ");
INSERT INTO zin_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mbwéenu omugabe omukúlu ogwo, izíina lyoómwe Anasi, yaámubúuza Yeézu empola za abaheémba boómwe na ameégeso goómwe. ");
INSERT INTO zin_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeézu yaámugalulila aáti, “Obuchilo bwóona nkaba niingaámba aha baantu bóona ha bwéelu, nkaba niinyegesa abaantu omu nzu za amasomelo gáanyu no omu lubúga lwe éenzu ya Múungu omwo áaho Abayahudi béenzi baba nibakobamo hamo. Nnyegesize ameégeso gaanze góona ha bwéelu. ");
INSERT INTO zin_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ha bwaáchi kuumbúuza íinye? Mbwéenu ha bwaáchi tokubabúuza abaantu abaabeele nibaampuuliliza obuchilo niinyegesa? Boónyini nibamanya áago nkaba niingaámba no kweégesa.” ");
INSERT INTO zin_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Obuchilo Yeézu akagaamba ago, omusilikale oómo óogwo akaba ayemeeliile héehi náwe amuteeza oluhi, yaámubúuza aáti, “Ngási, noomusubiza oótyo omugabe mukúlu?” ");
INSERT INTO zin_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeézu yaámugalulila aáti, “Kaándaaba naágaamba kubi, yatula obubi bwaanze. Náho kábilaaba naágaamba amazima, ha bwaáchi noonteéla?” ");
INSERT INTO zin_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mbwéenu, obuchilo Yeézu achaali abohilwe, Anasi yaálagila nkokwo bamutwáale owo omugabe mukúlu, Kayafa. ");
INSERT INTO zin_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mbwéenu, obuchilo Simoni Peétero akaba ayimeeliile achaáyota omulilo, abaantu bunaanka baámubúuza báti, “Ngási, neewe toli oómo wa abaheémba bo ogwo muuntu?” Peétero yaáyáanga yaágaamba, “Ti íinye.” ");
INSERT INTO zin_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Náho oómo wo omu bahálila bo omugabe mukúlu, mudugu wo óogwo akachwéebwa okutwi na Peétero, aba yaámubúuza aáti, “Ngási, íinye tinaákubona íiwe okwo omu musili oli hamo náze Yeézu?” ");
INSERT INTO zin_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Káandi ahonyini Peétero aba yaáguluka omu kwáanga. Ahonyini, enkoókolomi eba yaákoókoloma. ");
INSERT INTO zin_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mbwéenu, obuchilo kábwaachíile, abatégeki ba Abayahudi baámutwáala Yeézu kuluga owa Kayafa. Baázeenda náwe omu ikulato lyo omutégeki we Echirúumi. Náho boónyini tibalataahilemo omu ikulato lyoómwe kuba bateetaho obulofo no kulemwa kulya ebyookulya bya Paásika. ");
INSERT INTO zin_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mbwéenu omweébeembezi wa Abarúumi, izíina lyoómwe Pilato, yaáluga ahéelu no kuzeenda áaho baabeele bali, yaábabúuza yaágaamba, “Ngási, omuuntu ogu akozile bíbi chi éebyo mulikumulégelela?” ");
INSERT INTO zin_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Boónyini baámusubiza báti, “Kábilaaba omuuntu ogu yaakubeele atali ne ebíbi, titwaákumuleesile hali íiwe.” ");
INSERT INTO zin_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato yaábagaambila aáti, “Mbwéenu íimwe mumutwáale mumuchwaaziike kwiingana ne ebilagilo byáanyu.” Náho Abayahudi baámusubiza báti, “Titwíina amagala go kumuchwaáziika omuuntu weéna wéena kuba aáfwe.” ");
INSERT INTO zin_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ago gakabaho gátyo, kuba amagaambo áago Yeézu akagaamba gahike kwoóleka óokwo alaáfwa. ");
INSERT INTO zin_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mbwéenu, Pilato yaátaaha káandi omu nzu, yaálagila nka nikwo, bamuléete Yeézu hali weényini, yaámubúuza aáti, “Iíngu, íiwe oli mukáma wa Abayahudi?” ");
INSERT INTO zin_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yeézu yaámugalulila aáti, “Ngási, amagaambo áago olikubúuza na agaáwe nali ago kuluga omu baantu abáandi abakusoombooliile empola zaanze?” ");
INSERT INTO zin_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato yaámugalulila aáti, “Ngási, íinye ndi Omuyahudi? Abaantu be éensi yaawe hamo na abakúlu ba abagabe nibo áabo baákuléeta hali íinye kuba nkuchwaáziike. Ngási, okozile chiheno chi?” ");
INSERT INTO zin_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeézu yaámugalulila aáti, “Obukáma bwaanze ti bwe éensi ezi. Kábwaakubeele buli obwe éensi ezi, abaheémba baanze bakaandwaaniile kuba ntakwaatwa na Abayahudi. Náho obukáma bwaanze ti bwo omu nsi omu.” ");
INSERT INTO zin_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mbwéenu, Pilato yaámubúuza aáti, “Ngási, mbwéenu na mazima kuba íiwe oli omukáma?” Yeézu yaámugalulila aáti, “Níiwe waágaamba kuba íinye ndi omukáma. Íinye nkazalilwa omu nsi omu, káandi nkeeza mbone kwaatulila abaantu amazima. Omuuntu weéna wéena óogwo alikugakulaatila amazima, ogwo naagahulila amagaambo gaanze.” ");
INSERT INTO zin_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato yaámubúuza aáti, “Amazima ni chiíha?” Obuchilo Pilato akagaamba ago, yaásohola ahéelu, yaábagaambila abatégeki ba Abayahudi aáti, “Íinye tiínkabonesize echiheno choóna chóona cho kumulegelela omuuntu ogu. ");
INSERT INTO zin_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Náho muzila obuteéka bwo kuúnsaba kubakomoololela embóhe oómo obuchilo bwe echilo chikúlu cha Paásika. Ngási, nimweénda mbakomoololele omukáma wa Abayahudi?” ");
INSERT INTO zin_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Náho abaantu bóona baátéela eyoombo nibagaámba báti, “Mmahi! Otatuchiíngulila omuuntu ogwo, náho otuchiíngulile Baraba.” Baraba akaba abohilwe omu ibóhelo habwo kugomela obutégeki bwa Abarúumi. ");
INSERT INTO zin_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Niho, Pilato yaámusohoza Yeézu, yaálagila bamutéele enkoba. ");
INSERT INTO zin_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Abalwaanila ngoma baáyogosa omukáko gwa amáhwa, baámuzwéeka aha mútwe. Káandi baámuzwéeka enkaanzu yi ibala lye ezaambalau. ");
INSERT INTO zin_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Baaba nibamuzaho, baámwaangalucha nibagaámba báti, “Nookasíinge, íiwe Omukáma wa Abayahudi!” Baámukaámbaatula eémpi. ");
INSERT INTO zin_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato yaáza ahéelu káandi, yaábagaambila embága ya abaantu abo aáti, “Muhuliilíze, niimmuleéta ahéelu hali íimwe omuuntu ogu, kuba musoomboókelwe nka nikwo tiínkabwéene echiheno choóna chóona cho kumulegelela omuuntu ogu.” ");
INSERT INTO zin_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mbwéenu, Yeézu yaásohola ahéelu obuchilo azweele omukáko gwa amáhwa ne enkaanzu ye ezaambalau. Mbwéenu, Pilato yaáhooya ha bwéelu aáti, “Léeba, omuuntu weényini niwe ogu.” ");
INSERT INTO zin_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Obuchilo abakúlu ba abagabe na abaleebelezi be éenzu ya Múungu baámubona Yeézu, batéela eyoombo nibagaámba báti, “Mubaámbe aha musalaba, Mubaámbe aha musalaba!” Mbwéenu, Pilato yaábagaambila aáti, “Mumutwáale íimwe nyini mumubaámbe aha musalaba, habwe ensoonga íinye tiínkabonesize echiheno choóna chóona cho kumulegelela.” ");
INSERT INTO zin_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Abayahudi baámusubiza báti, “Íichwe twiinácho echilagilo. Kwiingana ne echilagilo echo, naayeéndelwa kwíitwa, habwo kuba naayegaámba nka nikwo ni Mutábani wa Múungu.” ");
INSERT INTO zin_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Obuchilo Pilato yaáhuliile amagaambo ago, yaáguma kutíina bwooli. ");
INSERT INTO zin_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mbwéenu, yaátaaha káandi omu nzu, yaámubúuza Yeézu aáti, “Íiwe olugile nkáhi?” Náho Yeézu talamugaluliile choóna chóona. ");
INSERT INTO zin_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mbwéenu, Pilato yaámugalulila aáti, “Ha bwaáchi tokugaamba? Ngási, tokumanya kuba nnyina amagala go kukukomoolola, na ago kukubaamba aha musalaba?” ");
INSERT INTO zin_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeézu yaámugalulila Pilato aáti, “Tiwaákubeele oyina amagala goóna góona ha bwaánze káwaakubeele otaheélwe na Múungu. Náho omuuntu óogwo antiile omu ngalo zaawe ayina echiheno chiháango bwooli kusáaga echiheno chaawe.” ");
INSERT INTO zin_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mbwéenu, obuchilo Pilato yaáhuliile ago, yaábaanza kuloondela omuháanda gwo kumukomoolola Yeézu, náho Abayahudi baáyoongela kutéela eyoombo nibagaámba báti, “Koólaamukomoolola omuuntu ogwo, mbwéenu íiwe toli munywáani wa Kaizáari. Omuuntu weéna wéena óogwo alikweékola kuba omukáma, naamunuga Kaizáari.” ");
INSERT INTO zin_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Obuchilo Pilato yaáhuliile amagaambo ago, yaámuléeta Yeézu ahéelu, yaázeenda kwíikala náwe omu chitébe cho muchwaaziiko, ahaantu áaho bakaheeta Omwaalilo gwi Ibáale. Habwo lulími lwe Echihebrania nibagaámba Gabatha. ");
INSERT INTO zin_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ekaba yeéliliza esáaha mukáaga aha chilo cho kweéloonza habwe echilo chikúlu cha Paásika. Pilato yaábagaambila abatégeki ba Abayahudi aáti, “Muléebe, omukáma wáanyu!” ");
INSERT INTO zin_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Boónyini batéela eyoombo nibagaámba báti, “Mwíite, mwíite! Mubaámbe aha musalaba!” Pilato yaábabúuza aáti, “Ngási, nimweénda mmubaámbe aha musalaba omukáma wáanyu?” Abakúlu ba abagabe baámusubiza báti, “Íichwe titwíina omukáma oóndi náho Kaizáari!” ");
INSERT INTO zin_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mbwéenu, omuhélo Pilato yaámuta Yeézu omu ngalo záabo kuba bamubaámbe aha musalaba. Mbwéenu, abasilikale baámutwáala Yeézu no kuzeenda náze. ");
INSERT INTO zin_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yeemucha omusalaba gwoómwe, yaásohola omu muzihwa, yaázeenda ahaantu áaho omu lulími lwe Echihebrania nibaheéta Goligoota. Izíina eli liina ensoonga eéti, “Oluhaanga lwo Omútwe.” ");
INSERT INTO zin_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Obuchilo kábaahikile aho, baámubaamba Yeézu aha musalaba. Ahaantu ahonyini bakaba baliho abaantu abáandi bábili áabo abaabeele babaambilwe aha misalaba hamo náwe, oómo olubazu lwo obúlyo no oóndi olubazu lwo obumoso, náwe Yeézu yaaba ahagáti. ");
INSERT INTO zin_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato yaálagila nkokwo gaandikwe amagaambo no kutéebwa aha musalaba gwa Yeézu, áago galikugaamba gáti, “ogu ni yeézu omunyanazaréeti, omukáma wa abayahudi.” ");
INSERT INTO zin_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Amaandiko ago gakaaandikwa omu lulími lwe Echihebrania, Echirúumi ne Echiyunani. Abayahudi béenzi bakaba nibasoma amaandiko ago, habwo kuba ahaantu áaho baámubaambile aha musalaba hakaba hali héehi na Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mbwéenu, abakúlu ba abagabe baámugaambila Pilato báti, “Otaakwaandika nka nikwo, ‘Óogu no omukáma wa Abayahudi,’ náho oyaandike nka nikwo, ‘Omuuntu ogu akagaamba kuba weényini no omukáma wa Abayahudi.’ ” ");
INSERT INTO zin_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato yaábagalulila aáti, “Mmahi, tiínkuhiindula amaandiko áago naáyaandika.” ");
INSERT INTO zin_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Obuchilo abasilikale baámubaambile Yeézu aha musalaba, baátwáala emyéenda yoómwe, baázitéela amafuungu aána. Buli omusilikale yeemucha echinogokáche. Káandi, baátwáala enkaanzu yoómwe. Enkaanzu éezo ekaba eyogosize yóona kubaandiza olugulu kuhika aheéfo, telabeele no olubaziililo no óobu lúmo. ");
INSERT INTO zin_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mbwéenu, baáteékatéeka báti, “Tutaziteémula ezi nkaanzu, náho tuteéle olweeso, tulole nka nikwo, neéba yo oóha.” Ago gakakolwa kuba gabonwe kuhikiilizwa áago agaándikilwe omu Maandiko Matakatíifu gáti, “Bakabagana emyéenda yaanze, na kuzitéelela olweeso enkaanzu yaanze.” Nikwo óokwo bakakola abasilikale. ");
INSERT INTO zin_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mbwéenu, bakaba baliho abakázi abáandi bana abaabeele beemeeliile héehi no musalaba gwa Yeézu. Aha bakázi abo akaba aliho nyina Yeézu, nyina éento wa Yeézu, Mariamu muka Kilopa, na Mariamu omunya Magidala. ");
INSERT INTO zin_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Obuchilo Yeézu káyaamubwéene nyina no ogwo muheémba óogwo yaáyeenzile bwooli ayemeeliile héehi na nyina, yaámuzila aáti, “Íiwe máaha waanze, muléebe ogu. Mukole aábe omwaana waawe.” ");
INSERT INTO zin_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Káandi yaámugaambila omuheémba ogwo aáti, “Muléebe ogu. Omukóle aábe nyoko.” Mbwéenu, kuluga obuchilo obwo nyini omuheémba ogwo yaámunyegeza nyina Yeézu, ayikale náze omúka yoómwe. ");
INSERT INTO zin_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mbwéenu, Yeézu yaásoombookelwa kuba akaba yaámazile kuzikola emilimo yoómwe. Mbwéenu, yaáhooya naagaámba aáti, “Naázila iliho.” Akagaamba aátyo kuba gahikiilile áago agaabeele gaandikilwe omu Maandiko Matakatíifu. ");
INSERT INTO zin_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ahaantu áaho hakaba heena echiseme éecho bakeezuza evíini esaankameele. Mbwéenu, beémucha esifoongo, baázikoza omu víini ezo, baázita omu lusekeyáanda, baámutwaálila Yeézu aha munwa. ");
INSERT INTO zin_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yeézu obuchilo yaáziloza evíini esaankameele ezo, yaáhooya naagaámba aáti, “Emilimo yaanze yaáhwa!” Mbwéenu yeenamika omútwe gwoómwe, omwooyo gwaahwámo. ");
INSERT INTO zin_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Chikaba chili echilo cho kweéloonza habwe Endaálikizo, káandi Endaálikizo ezo ekaba eli echilo chiháango kusaaga Endaálikizo ezíindi. Abatégeki ba Abayahudi bakaba bateénda omutúumbi gusigale aha lugulu yo musalaba aha chilo che Endaálikizo, mbwéenu baázeenda hali Pilato, baámusaba nka nikwo abasilikale bazeénde kubahéenda amagulu abaantu áabo ababaambilwe, no kwiiháho emitúumbi yáabo aha misalaba. ");
INSERT INTO zin_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mbwéenu, abasilikale baázeenda, baámuhéenda amagulu owo kubaanza no wa kábili áabo ababaambilwe hamo na Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Náho obuchilo nibazeénda hali Yeézu, baásaanga yaáfwiile, bityo tibalamuheenzile amagulu. ");
INSERT INTO zin_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Náho omulwaanila ngoma oómo yaámuchumita Yeézu ni ichúmu aha lubazu. Ahonyini enságama na méenzi byaásululuka. ");
INSERT INTO zin_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Empola ezi zaandikilwe no omuuntu óogwo akaba naagabona áago gakaba nigakolwa. Okusiinza kwoómwe no kwa amazima, náwe naamanya kuba áago alikugaamba na ga mazima. Akagaandika kuba neemwe hanu mwiikilize. ");
INSERT INTO zin_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ago gakakolwa kuba gahikiilizwe áago agaándikilwe omu Maandiko Matakatíifu kuba, “Tihaliho igufwa lyoómwe éelyo lilaahéendwa.” ");
INSERT INTO zin_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Káandi Amaandiko Matakatíifu nigagaámba gáti, “Baléeza kuleeba óogwo baáchumisile ichúmu.” ");
INSERT INTO zin_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kágaabeele gaáhiingwiile ago, yéeza omuuntu oómo izíina lyoómwe Yozéfu, óogwo akalugiilila Arimatea. Omuuntu ogwo akaba ali omuheémba wa Yeézu, náho habwe eseleke kwoónka, habwo kuba akaba naabatiína abatégeki ba Abayahudi. Mbwéenu, omuuntu ogwo yaázeenda hali Pilato, yaámusaba kuba atwaále omutúumbi gwa Yeézu, aáze kuziika. Pilato yaámukuúndila. Mbwéenu, Yozéfu yaázeenda, yeeháho omutúumbi gwa Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Náwe Nikodemo óogwo obuchilo búmo akazeenda hali Yeézu omu chilo, yéeza yaáleeta omutulaanilo gwe emanemane no obubáani, gakaba gali ekilo makúmi asatu. ");
INSERT INTO zin_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mbwéenu, abo bábili baátwáala omutúumbi gwa Yeézu, baáguziíngilila isáanda, hamo ne emizeeze emiluunzi kwiingana no obuteéka bwa Abayahudi bwo kuziika abaantu. ");
INSERT INTO zin_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ahaantu áaho yaabaambiilwe Yeézu hakaba guliho musili. Omu musili omwo hakaba halimo eémbi nsha éezo etakaziikagwamo omuuntu weéna wéena. ");
INSERT INTO zin_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Echilo echo, chikaba echilo cha Abayahudi kweéloonza habwe Endaálikizo. Ha bwéecho baámuziika Yeézu omu mbi ezo, habwo kuba ekaba eli héehi. ");
INSERT INTO zin_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Echilo cha mbele cho obwooyo, enchaákala omulucheelelélwa, Mariamu omunya Magidala yaázeenda omu mbi ya Yeézu. Yaásaanga ibáale elyo lyaáhiliingisiibwe kuluga aha mulyáango gwe eémbi. ");
INSERT INTO zin_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mbwéenu, yeeluka kuluga aho, yaázeenda hali Simoni Peétero na aha omuheémba óogwo Yeézu yaáyeenzile. Yaábagaambila aáti, “Abaantu baagwiiháho omutúumbi gwo Omukáma wéetu omu mbi, káandi titukusoombookelwa áaho baágutwáala!” ");
INSERT INTO zin_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peétero no omuheémba oóndi ogwo, baalugáho, baázeenda omu mbi. ");
INSERT INTO zin_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bóona bábili bakaba nibeéluka, náho omuheémba ogwo oóndi yeeluka kumusáaga Peétero no kweébeembela kuhika omu mbi. ");
INSERT INTO zin_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yeénama, yaásuuza omu mbi, yaálibona isáanda éelyo bakamuziikila Yeézu, náho talatáahile omugati. ");
INSERT INTO zin_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mbwéenu, Simoni Peétero yamukulaatila, yaáhika aho, yaátaaha omu mbi no kulisaanga isáanda éelyo bakamuziikila Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Káandi yaásaanga ne echitaambaala éecho baamukomile Yeézu omu mútwe. Chikaba chitali hamo ne emyéenda eéndi, náho chikahinywa no kutéebwa ha lubazu. ");
INSERT INTO zin_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mbwéenu, omuheémba oóndi óogwo akeébeembela kuhika aho, náwe yaátaaha omu mbi. Yaáleeba, yeekililiza, ");
INSERT INTO zin_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","nóobwo bakaba bachaali kusoombookelwa Amaandiko Matakatíifu áago galikugaamba nka nikwo, Yeézu ni lwaampaka azooke kuluga omu bafwiile. ");
INSERT INTO zin_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mbwéenu, abaheémba abo baázeenda owaabo. ");
INSERT INTO zin_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Náho Mariamu omunya Magidala yaásigala no kweémeelela ahéelu aha mbi, akaba naalíla. Obuchilo akaba naalíla, yeénama no kusuuza omu mbi, ");
INSERT INTO zin_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yaábabona bamaléeka bábili áabo bazweele emyéenda zilikwéela. Bakaba beékeele áaho bakaba balyaamikile omutúumbi gwa Yeézu. Maléeka oómo ayikeele olubazu óolwo gukaba guli omútwe gwa Yeézu, oóndi ayikeele olubazu óolwo gakaba gali amagulu ga Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bamaléeka abo baámubúuza báti, “Íiwe máaha, ha bwaáchi noolila?” Náwe yaábagalulila aáti, “Abaantu baagwiiháho omutúumbi gwo Omukáma waanze, káandi tiínkumanya áaho baágutwáala!” ");
INSERT INTO zin_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Obuchilo Mariamu yaámazile kugaamba amagaambo ago, yeéchebuka, yaámubona Yeézu ayemeeliile ahonyini, náho weényini Mariamu talamumanyile. ");
INSERT INTO zin_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeézu yaámubúuza yaámuzila, “Íiwe máaha, ha bwaáchi noolila? Ngási, noomuloónda oóha?” Mariamu akateekuza kuba omuuntu ogwo akaba omuzáana wo omusili, mbwéenu yaámugalulila aáti, “Íiwe táata, kábilaaba níiwe waagwiihaho omutúumbi gwoómwe, ngaambila áaho waguta, neenye ndaazeénda kugutwáala.” ");
INSERT INTO zin_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeézu yaámweeta izíina lyoómwe aáti, “Íiwe Mariamu!” Mále Mariamu yeéchebuka, yaámubona Yeézu, yaágaamba omu lulími lwe Echihebrania aáti, “Raboni!” Raboni, ensoonga yaáho no “Omweégesa.” ");
INSERT INTO zin_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeézu yaámugaambila aáti, “Leka otaankwáata. Ncháali tikazeenzile omu igulu hali Táata. Mbwéenu, zeénda kubagaambila abeekiliza bazeenzi baanze, kuba naázeenda omu igulu hali Táata, óogwo ali Isíimwe, hali Múungu waanze óogwo ali Múungu wáanyu.” ");
INSERT INTO zin_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mbwéenu Mariamu omunya Magidala yaázeenda aha baheémba ba Yeézu, yaábagaambila empola ezi, naagaámba aáti, “Léeba, íinye naámubona Omukáma!” Mbwéenu, yabasoomboolela góona áago Yeézu akamulagila. ");
INSERT INTO zin_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yaaba olweébazo echilo echo nyini cha mbele cho obwooyo, abaheémba ba Yeézu bakakóba omu nzu eémo no kuchiinga emilyaango habwo kuba bakaba nibatiína abatégeki ba Abayahudi. No óobu keélaaba emilyaango ekaba echiingilwe, mala Yeézu yaábonwa ha bwéelu, no kweémeelela ahagáti yáabo, yaábagaambila aáti, “Obuhóolo bube neemwe!” ");
INSERT INTO zin_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mbwéenu, yaábooleka engalo zoómwe no olubazu lwoómwe. Obuchilo abaheémba baámubweene Omukáma, baánulilwa bwooli. ");
INSERT INTO zin_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yeézu yaábasuula káandi aáti, “Obuhóolo bube neemwe. Nko óokwo Táata akaansiíndika íinye, bityo nyini neenye niimbasiindika íimwe omu nsi aha.” ");
INSERT INTO zin_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Káyaamazile kugaamba ago, mbwéenu yaábahuuhila olwooya, yaábagaambila aáti, “Mwiinaánkule Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kamulaaba nimubaganyila abaantu ebiheno byáabo, Múungu náwe yaábaganyiile ebiheno byáabo. Kamulaaba mutakubaganyila, Múungu náwe takabaganyiile.” ");
INSERT INTO zin_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Omuheémba oómo omu baheémba ba Yeézu, izíina lyoómwe Tomaso óogwo izíina elíindi akaba ayétwa Iloongo, akaba atali hamo na abaheémba abáandi obuchilo Yeézu naabeesuúlulukiza. ");
INSERT INTO zin_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mbwéenu, abaheémba abáandi abo baámugaambila báti, “Íichwe twaámubona Omukáma.” Náho weényini yaábagalulila aáti, “Íinye tinaákuhicha kwiikiliza ago kaándaaba ntabweéne aha kubaanza amakozo ge emisumali omu ngalo zoómwe, no kúta olukumu lwaanze áaho baágoógotiile emisumali no kúta omukóno gwaanze aho aha lubazu lwoómwe.” ");
INSERT INTO zin_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Obuchilo ebilo munáana byaáhiíngwiile, abaheémba ba Yeézu baákoba hamo káandi omu nzu. Echilo echo náwe Tomaso akaba aliho hamo nábo. Emilyaango bachiingile, mala, Yeézu yaábonwa ha bwéelu, yaáyemeelela ahagáti yáabo, yaábasuula aáti, “Obuhóolo bube neemwe!” ");
INSERT INTO zin_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mbwéenu, Yeézu yaámugaambila Tomaso aáti, “Íiwe Tomaso, iíza onkúumye no lukumu lwaawe omu ngalo zaanze. Káandi, onkúumye ne omukóno gwaawe omu lubazu lwaanze. Otakuzeendelela kuleka kwiikiliza, náho oyikilize.” ");
INSERT INTO zin_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaso yaámugalulila aáti, “Omukáma waanze na Múungu waanze!” ");
INSERT INTO zin_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeézu yaámugalulila aáti, “Weékiliza habwo kuba waámbona. Béena omugisa áabo banyikiliize no óobu kábalaaba batakaambweene.” ");
INSERT INTO zin_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeézu akakola eméenko eéndi nyíinzi éezo abaheémba boómwe bakazibona. Tizilaandikilwe omu chitabu echi. ");
INSERT INTO zin_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Náho eméenko éezo zili omu echitabu echi zikaandikwa kuba mubóne kwiikiliza nka nikwo Yeézu niwe Masihi, Mutábani wa Múungu, no kuba aha kumwiíkiliza, mubóne obulami bwo bucha no buchiile kulabila omu izíina lyoómwe. ");
INSERT INTO zin_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kágaabeele gaáhiingwiile ago, Yeézu yaábeesuululukiza káandi abaheémba boómwe aha ngeégeelo ye enyaanza ya Tiberia. ");
INSERT INTO zin_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Bakaba baliho Simoni Peétero, Tomaso óogwo izíina elíindi akaba ayétwa Iloongo, Natanaeli óogwo akalugiilila Kána omuli Galiláaya, abáana bábili ba Zebedayo, na abaheémba abáandi bábili. ");
INSERT INTO zin_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Peétero yaábagaambila bazeenzíbe aáti, “Niinzeénda kutéga eénfwi.” Boónyini baámusubiza báti, “Neechwe nituzeénda hamo neewe.” Mbwéenu baázeenda, baáhanama omu bwáato, bakatega omu chilo pee, náho tibalakwaasize eénfwi yóona yóona. ");
INSERT INTO zin_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Omulucheelelélwa, Yeézu yaáyemeelela aha ngeégeelo ye enyaanza, náho abaheémba boómwe tibalamanyile kuba ni Yeézu. ");
INSERT INTO zin_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mbwéenu, Yeézu yaábéeta aáti, “Báana baanze, ngási, mwaákwáasa eénfwi yoóna yóona?” Boónyini baámusubiza báti, “Mmahi.” ");
INSERT INTO zin_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yeézu yaábagaambila aáti, “Munaguze omutego olubazu lwo obúlyo lwo obwáato, neemwe nimubona kubasa eénfwi.” Mbwéenu, baánaguza omutego gwáabo omu nyaanza omukóno gwo obúlyo, bakakwáasa eénfwi nyíinzi bwooli kuhicha baásiingwa kugukweesa omutego gwáabo. ");
INSERT INTO zin_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Omuheémba óogwo Yeézu ayaamweenzile bwooli, yaámugaambila Peétero aáti, “No Omukáma!” Obuchilo Simoni Peétero yaáhuliile kuba no Omukáma, yaázwaala omwéenda gwoómwe óogwo akazuula obuchilo yabaandize kutéga, yeenaga omu nyaanza. ");
INSERT INTO zin_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Abaheémba abáandi beeza aha bwáato, habwo kuba tibalabeele hala kuhika aha chaambo, náho bakaba bali nke entáambo igana límo zíti. Bakweesa omutego óogwo gukeezula eénfwi. ");
INSERT INTO zin_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Obuchilo kábaahikile aha ngeégeelo ye enyaanza, baábona heena olutóondo lwo omulilo. Ahali ogwo mulilo zikaba zitiilwého eénfwi no omukaate. ");
INSERT INTO zin_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeézu yaábagaambila abaheémba boómwe aáti, “Mwiíze, muleéte aha eénfwi iínche éezo mwaátéga.” ");
INSERT INTO zin_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mbwéenu Simoni Peétero yaátaaha omu bwáato, yaákweeseza aha ngeégeelo ye enyaanza omutego óogwo gukaba gwiizwíile eénfwi. Omu mutego ogwo zikaba zilimo eénfwi empáango igana límo makúmi ataanu ne isatu. No óobu bilaaba zikaba zilimo eénfwi nyíinzi bwooli, no óobu bityo omutego tigulatéemukile. ");
INSERT INTO zin_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeézu yaábagaambila abaheémba boómwe aáti, “Mwiíza mulye ebyookulya.” Taliho omuheémba óogwo ayaaleengesize kumubúuza aáti, “Íiwe oli oóha?” habwo kuba bakamanya kuba no Omukáma. ");
INSERT INTO zin_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mbwéenu Yeézu yéeza, yeemucha omukaate, yaábaha abaheémba boómwe. Káandi, yeemucha ne eénfwi, yaákola aátyo nyini. ");
INSERT INTO zin_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ezo ekaba eli entúlo ya kásatu Yeézu kubesuululikiza abaheémba boómwe buluga Múungu kumuzoola kuluga omu bafwiile. ");
INSERT INTO zin_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Obuchilo baliile, Yeézu yaámubúuza Peétero aáti, “Simoni, mutábani wa Yohana, ngási, noonyeénda bwooli íinye kusaaga bazeenzi baawe aba óokwo balikuunyeenda?” Peétero yaámugalulila aáti, “Éego, Omukáma, noomanya kuba niinkweénda.” Yeézu yaámugaambila aáti, “Liísa entaama zaanze.” ");
INSERT INTO zin_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yeézu yaámubúuza Peétero entúlo ya kábili aáti, “Simoni, mutábani wa Yohana, ngási noonyeénda?” Peétero yaámugalulila aáti, “Éego, Omukáma, noomanya kuba niinkweénda.” Yeézu yaámugaambila aáti, “Liísa entaama zaanze.” ");
INSERT INTO zin_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yaámubúuza entúlo ya kásatu aáti, “Simoni, mutábani wa Yohana, ngási noonyeénda?” Mbwéenu, Peétero yaázuzubalilwa habwo kuba akamubuuliza entúlo ya kásatu kuba, “Ngási, noonyeénda?” Yaámugalulila aáti, “Íiwe Omukáma, noomanya góona. Noomanya kuba niinkweénda.” Yeézu yaámugaambila, “Liísa entaama zaanze. ");
INSERT INTO zin_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mazima butúnu niinkugaambila nka nikwo, obuchilo okaba oli omusígazi, okamanyiila kuzwaala emyéenda yaawe íiwe nyini, no kuzeenda hóona áaho wayeenzile. Náho obuchilo olyaákokola, olyaágolola emikóno yaawe no omuuntu oóndi alyaákuzwéeka emyéenda yaawe na kukuutwáala áaho otakweenda kuzeenda.” ");
INSERT INTO zin_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yeézu akagaamba aátyo kwoóleka omuháanda óogwo Peétero alaáfwa, no ogwo kumukúza Múungu. Mbwéenu, Yeézu yaámugaambila Peétero aáti, “Nkuláatila.” ");
INSERT INTO zin_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Mbwéenu, Peétero yeéchebuka, yaámubona omuheémba óogwo Yeézu yaáyeenzile bwooli, akaba naabakulaatila. Omuheémba ogwo niwe óogwo akaba ayikeele héehi na Yeézu obuchilo nibalya ebyookulya, no kumubúuza kuba, “Íiwe Omukáma, noóha alaakukoonga?” ");
INSERT INTO zin_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mbwéenu, obuchilo Peétero ayaámubwéene omuheémba ogwo, yaámubúuza Yeézu aáti, “Mukáma, ngási ogu náwe?” ");
INSERT INTO zin_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeézu yaámugalulila yaámuzila aáti, “Kiindaaba niinyeénda kuba aábe omulame kuhicha obuchilo niinsuba, echo nichikusaanila chi? Íiwe nkuláatila.” ");
INSERT INTO zin_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mbwéenu echigaambo echo chikasugaana omu beekiliza nka nikwo omuheémba ogwo talifwa nakáti. Náho Yeézu talamugaambiile nka nikwo omuheémba ogwo talifwa nakáti, náho akagaamba aáti, “Kiindaaba niinyeénda kuba aábe ali omulame kuhicha obuchilo niinsuba, ha bwaáchi ago nigakwaágalaza?” ");
INSERT INTO zin_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Omuheémba ogwo niwe óogwo alikusíinza aga na niwe yaágaandikile. No óobu íichwe nitusoomboókelwa kuba áago alikugaamba na ga mazima. ");
INSERT INTO zin_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Galiho amagaambo agáandi méenzi áago Yeézu akaba naakola. Kábyaakubeele góona ago gakwaandikilwe, niimbóna omu nsi hóona tihakuhikile kutamo ebitabu éebyo byaakwaandikilwe.");
INSERT INTO zin_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Owe engoonzi Teofiilo, omu chitabu chaanze cho kutaándika, nkakwaándikila habwa amagaambo góona áago Yeézu yaákozile no kweégesa, kuluga ha bubaandizo ");
INSERT INTO zin_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kuhika echilo éecho yaatweelwe kuzeenda omu igulu. Atakatwéelwe, akabalagila ha muháanda gwo Omwooyo Mutakatíifu entumwa zoómwe áabo yaabeele atoólize. ");
INSERT INTO zin_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ha mwáanya gwe ebilo makúmi aána káyaabeele yaayagaleezwe kuhicha kufwa, akaba naayeyoleka hali ezo ntumwa káandi na káandi, naayemanyisa butúnu nkokwo ali mwooyo, no kubeégesa amagaambo go obukáma bwa Múungu. ");
INSERT INTO zin_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Echilo chimo, obuchilo Yeézu akaba naálya hamo ne ezo ntumwa, akabalagila, “Mutalugamo omu chikaali cha Yeruzaléemu. Náho mutegamilíle omwo nyini, kuhika obuchilo óobwo muleenaánkula Omwooyo óogwo Táata yaabeésagiize íimwe kulabila amagaambo gaanze áago mbele niimbagaambila. ");
INSERT INTO zin_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kuba, Yohana akabatiza abaantu aha méenzi, náho ahaleéza ha bilo bíche íimwe nimubatizwa aha Mwooyo Mutakatíifu.” ");
INSERT INTO zin_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bityo, omu buchilo ezo ntumwa kázaakobile hamo na Yeézu, zaámubúuza, “Mukáma wéetu, obuchilo obu niho olaábasubiza Abaiziraeli obukáma bwáabo?” ");
INSERT INTO zin_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Náwe yaábagaambila, “Obuchilo nali emihaanguko za amagaambo ago, ti géenyu kumanya, ha kuba ni Táata weénka óogwo ha buzizi bwoómwe yaálamwíile nigabáho iíli. ");
INSERT INTO zin_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Náho nimwiinaánkula obuhicha obuchilo Omwooyo Mutakatíifu aleeza hali íimwe, nimuba nimuunyatula íinye omuli Yeruzaléemu ne enkasi ezíindi zóona ze éensi ya Yudea, na Samaria, no kuhika hóona ha muhélo gwi ihaánga lye éensi.” ");
INSERT INTO zin_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Obuchilo Yeézu yaámazile kubagaambila entumwa zoómwe ago, nibamuleeba bóona, ahonyini akasutulwa kuzeenda omu igulu. Obwíile bwaámusweekelela, tibalamubweene káandi. ");
INSERT INTO zin_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Obuchilo bakaba bacháali nibalaangamila améeso gáabo olugulu, bwaangu ahonyini, héehi nábo, beemeelelaho abakwaáta bábili áabo bakaba bazweele ebizwáalo bilikwéela! ");
INSERT INTO zin_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Baágaamba, “Íimwe bakwaáta ba Galiláaya, kamweemeeliile aha nimuleeba omu igulu? Ogu Yeézu ayaátwaalwa kuluga hali íimwe kuzeenda omu igulu, aleeza káandi aátyo nyini, nko óokwo mwaámuleeba naazeénda omu igulu.” ");
INSERT INTO zin_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mala entumwa baalugáho aho ahi ibaanga elyo elilikwéetwa Mizeituni, baásuba omu chikaali cha Yeruzaléemu. Hakaba hali héehi, nko oluzeendo lwe echilo che Endaálikizo. ");
INSERT INTO zin_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Baátaaha omu muzihwa, baázeenda baáhanama omu chiseenge echoombekilwe olugulu ye éenzu omwo baabeele nibeekala. Ezo ntumwa nibo aba: Peétero, Yohana, Yakobo, Andrea, Filipo, Tomaso, Baritolomayo, Matayo na Yakobo, ali mutábani wa Alfayo. Káandi bakaba baliho Simoni, óogwo akaba ali Omuzelóote, na Yuda, ali mutábani wa Yakobo. ");
INSERT INTO zin_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Aba bóona bakaba bakoba aho kumusaba Múungu ha nsoonga eémo, hamo na Mariamu nyina wa Yeézu, na abakázi abáandi, na badugu ba Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Omu mwáanya ogwo, hakaba heena omukobo gwa abeekiliza. (Obwíinzi bwa abaantu bukaba buli igana límo na makúmi ábili báti.) Niho Peétero yeémeelela ahagáti yáabo, ");
INSERT INTO zin_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","yaábagaambila, “Badugu baanze, amagaambo ago agaayaandikilwe omu Maandiko Amatakatíifu habwa Yuda, gakaba gali lwaampaka gahikiílizwe. Ago gakagaambwa no Omwooyo Mutakatíifu kulabila hali Daudi habwe empola za Yuda, ayaábeebeembeliile áabo abamukwaásile Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Akabalwa kuba entumwa muzeenzi wéetu, akaboneswa ikola eli hamo neechwe.” ");
INSERT INTO zin_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Obuchilo obwo, Yuda akagula ensaambo hali ezo mpilya éezo yaáyanaankwiile kwiingana ne echikolwa choómwe chibi. Omwo niho yaágwíile buzuúma, éenda yoómwe ekaátika, na amala goómwe gaáseeseka ahéelu. ");
INSERT INTO zin_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Empola ze echigaambo echo zaámanyiika ha batúuzi bóona ba Yeruzaléemu. Ha bwéecho baáziluka ensaambo ezo izíina lya Akeldama kuluga omu lulími lwáabo, ensoonga yaáho, Ensaambo ye Enságama.) ");
INSERT INTO zin_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peétero yaázeendelela omu kugaamba, “Kuba amagaambo ago agaándikilwe omu chitabu che Enzina nigo aga, ‘Éenzu yoómwe eébe no obufúuzi, hataákubaho omuuntu óogwo alaasigala aho.’ “Káandi chaandikilwe, ‘Omulimo gwoómwe gwo kweémeelelela, ahaábwe omuuntu oóndi.’ ");
INSERT INTO zin_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Ha bwéecho, ni lwaampaka atoózwe omuuntu oóndi óogwo ayaakulaatileene neechwe obuchilo bwóona óobwo Omukáma Yeézu akaba ali hamo neechwe, ");
INSERT INTO zin_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kubaandiza obuchilo óobwo Yeézu akabatizibwa na Yohana kuhicha obuchilo obu yaátweelwe kuzeenda omu igulu. Óogwo alaatoózibwa, naayeéndelwa aábe hamo neechwe kugaamba obubona bwo okuzooka kwa Yeézu.” ");
INSERT INTO zin_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bityo, baatáho amazíina ga abaantu bábili. Oómo akaba ali Yozéfu ayaabeele naayétwa Barsaba, káandi akaba ayina izíina eliindi Yusito. No wa kábili, akaba ayétwa Mathia. ");
INSERT INTO zin_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Baámusaba Múungu omu kugaamba, “Mukáma, níiwe olikumanya emiganya ya abaantu bóona. Ha bwéecho, nitukusaba otwoóleke noóha omuli aba bábili waámutoólize nka nikwo, ");
INSERT INTO zin_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","atwaále omwáanya ogu gwo obuheéleza bwe entumwa éezo Yuda alekile, obuchilo yaáfwiile no kuzeenda ahaantu áaho ahalikumugasa.” ");
INSERT INTO zin_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mala baáyesa olweeso, lwaámugweela Mathia, yaátelaniswa na abo entumwa abáandi ikúmi no oómo. ");
INSERT INTO zin_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Obuchilo bwe echilo cha Peentekoste kabwaahikile, abaantu bóona áabo abamwiíkiliize Yeézu bakaba bakobile omu nzu eémo. ");
INSERT INTO zin_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ahonyini, iláka elyaabeele lili nke echiihúle cho omuyaga, gwaáhéemba kuluga omu igulu, gwéeza gwéezula omu nzu yóona éezo bakaba beekeelemo. ");
INSERT INTO zin_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ahonyini beesulukizwa ebiintu bili nke endími zo omulilo, byeebaganisa, byeekala aha lugulu ya buli oómo wáabo. ");
INSERT INTO zin_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Abaantu abo bóona beezuzwa obuhicha kuluga ha Mwooyo Mutakatíifu, baábaanza kugaamba ha ndími ezíindi, nko óokwo Omwooyo Mutakatíifu yaabeendíize kugaamba. ");
INSERT INTO zin_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na aho Yeruzaléemu bakaba baliho Abayahudi abaabeele nibamulámya Múungu. Abo Bayahudi bakaluga buli mahaánga góona ge éensi. ");
INSERT INTO zin_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Obuchilo kábaahuliile iláka eli, abaantu embága beeza. Na buli oómo wáabo yaákamaala, habwo kuba akabahulila abeekiliza abo nibagaamba gaamba nábo omu ndími ezili záabo. ");
INSERT INTO zin_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ago gaábasobeza no kubakaamaaza bwooli, kunu nibagaámba, “Ngási aba bóona bi tulikuhulila nibasoomboola báti, ta abatuuzi ba Galiláaya? ");
INSERT INTO zin_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ngási! Byáabaho bita nkokwo buli oómo wéetu naabahulila nibagaámba ha lulími lwoómwe lwo obuzaálwa? ");
INSERT INTO zin_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Aha heena abaantu kuluga omu nsi za Abaparti, Medi, Eláamu, Mesopotamia no omu byaalo bya Yudea, Kapadokia, Poonto, Asia, ");
INSERT INTO zin_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Furigia, Paamfilia, na Miísiri. Heena abáandi kuluga olubazu lwe éensi ya Libia éezo zili héehi na Kurene. Heena abazenyi áabo bakaba balugile okwo Rúumi, abo abáandi na Abayahudi bo obuteéka, na abáandi bakazaalilwa edíini ezíindi náho beékililizana ne edíini ye Chiyahudi. ");
INSERT INTO zin_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Heena abáandi áabo bali Abakirete, na abáandi Abaarabu. Neechwe chwéena, nituhulila abaantu aba nibamukúza Múungu ha bikolwa byoómwe bikulu, omu ndími ezili zéetu nyini!” ");
INSERT INTO zin_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Abaantu bóona baákamaala no kutahwa tahwa nibeegaambila, “Chiina nsoonga chi, echi chigaambo?” ");
INSERT INTO zin_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Náho abáandi omuli abo baábasekeelela abo baantu ba Yeézu omu kugaamba, “Batamiile evíini!” ");
INSERT INTO zin_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Náho Peétero yeémeelela, hamo ne entumwa bazeenzíbe abo ikúmi no oómo, yaábagaambila abaantu áabo ahi iláka liháango, “Íimwe Bayahudi, neemwe abáandi áabo mulikutúula aha Yeruzaléemu, muumpuliilize kuzima, mbone kubasoomboolela ebyo! ");
INSERT INTO zin_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nimuzila múti abaantu aba batamiile, amazima, aba baantu tibatamiile. Óobu hacháali ne esáaha isatu kwoónka ze enchaákala! ");
INSERT INTO zin_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Náho amagaambo aga nigo áago gaagaambilwe kulabila aha mubáasi Yoeli, ");
INSERT INTO zin_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Múungu naagaámba nka nikwo, ‘Omu bilo byo omuheleeluko, niimbaseésela abaantu bóona Omwooyo gwaanze. Batábani báanyu na bahala báanyu balaabáasa, na abasigazi báanyu nibabona ameezaho, na abanyaampala báanyu nibaloóta ebiloosi. ");
INSERT INTO zin_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Omu bilo ebyo niimbaseésela Omwooyo gwaanze no óobu aha lugulu ya abazáana baanze, abakwaáta na abakázi, nábo balaágaamba obubáasi. ");
INSERT INTO zin_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Niinkola amahano omu igulu olugulu, ne emanyiso omu nsi ahaansi, obwáamba, no omulilo, no olwoóyela lwíinzi lwe elíika. ");
INSERT INTO zin_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Izóoba lilaáhiinduka kuba ensiimbaazi, no okwéezi kuláaba okulikutukula nko obwáamba. Ago góona galáaba obuchilo chitakahikile echilo chikúlu chi ikuzo lyo Omukáma Múungu. ");
INSERT INTO zin_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na buli muuntu óogwo alikwéeta ahi izíina lyo Omukáma Múungu, naachuungulwa.’” ");
INSERT INTO zin_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Peétero yaázeendelela kugaamba, “Íimwe bakwaáta Abanyaiziraeli, muhuliilíze! Múungu akamumanyisa butúnu Yeézu Omunyanazaréeti hali íimwe, ha muháanda gwa amahano go kusobeza ne eméenko kulabila hali weényini, éezo Múungu akamuhikiiliza kuzikola omuli íimwe. Ago, íimwe nyini nimugamanya kuzima. ");
INSERT INTO zin_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Káyaabaliile ogu Yeézu yaásohozwa hali íimwe, nka Múungu okwo yaálamwíile kwiingana ne ensoonga yoómwe kuluga ha bubaandizo. Neemwe mukamubaamba no kumwiítila aha musalaba, aha muháanda gwo kulabila Abanyamahaánga abatakusaaswa ebilagilo. ");
INSERT INTO zin_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Náho Múungu akamuzoola kuluga omu bafwiile, yaámuchuúngula ne ebyaágalalo byo olufu, habwo kuba mazima tichikwiíle lufu kuzeendelela kumukóma Yeézu! ");
INSERT INTO zin_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kuba náwe Omukáma Daudi akagaamba aáti habwa Yeézu, ‘Nkaba mmubona Omukáma ali Múungu omu méeso gaanze buli bucha. Na habwo kuba ali olubazu lwaanze lwo obúlyo, tiínkuchuúndagulika. ");
INSERT INTO zin_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ha bwéecho, omuganya gwaanze nigusemelelwa, káandi olulími lwaanze niluteéla emihila. No óobu omubili gwaanze nágwo, nigutuúla aha bweetegeza bwa weényini, ");
INSERT INTO zin_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","habwo kuba íiwe toligunagilana omwooyo gwaanze omuli kuzimu, na káandi tokukuunda omubili gwaanze guzuúnde, íinye Omutakatíifu waawe. ");
INSERT INTO zin_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Waányoleka emiháanda zo obulami, noonyizuza amanulilwa, habwo kuba oli héehi neenye.’” ");
INSERT INTO zin_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peétero yaázeendelela kugaamba, “Abayahudi bazeenzi baanze, niinhicha kubagaambila ha kugima nkokwo isíichwe enkúlu Daudi akafwa, yaáziikwa, ne eémbi yoómwe echáali eliho aha kuhicha leélo. ");
INSERT INTO zin_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Náho Daudi akaba ali omubáasi, na akamanya nkokwo Múungu akamweésagiza ha kulahila nka nikwo, alyaámukola omuuntu oómo wo kuluga omu lugaanda lwoómwe kwiikala aha chitébe cho obutégeki bwoómwe. ");
INSERT INTO zin_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi akasoombookelwa amagaambo áago nigabáho gáta, niho akagaamba habwo kuzooka kwa Masihi nka nikwo, talalekilwe omu kuzimu nali omubili gwoómwe tigulazuunzile. ");
INSERT INTO zin_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ogwo Yeézu, Múungu akamuzoola kuluga omu bafwiile, neechwe chwéena ni baalubona bo okuzooka okwo. ");
INSERT INTO zin_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Múungu yaámuha Yeézu ikuzo liháango no kumuta héehi náze olubazu lwo obúlyo. Náwe Yeézu yaáyanaankula kuluga hali weényini Táata Omwooyo Mutakatíifu óogwo yaatweésagiize, náwe yaátuseeseliile. Echo nicho mulikuleeba óobu no kuhulila. ");
INSERT INTO zin_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kuba Daudi weényini talasutukile no kuzeenda omu igulu, náho akagaamba, ‘Omukáma Múungu akamugaambila Omukáma waanze, “Oyikále olubazu lwaanze lwo obúlyo, ");
INSERT INTO zin_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kuhika mbate ababisa baawe, iífo ya amagulu gaawe.”’” ");
INSERT INTO zin_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Peétero akamala ha kugaamba, “Ha bwéecho, Abaiziraeli bóona nibeendelwa bamanye aha mazima nkokwo: Múungu yaámukola ogu nyini Yeézu kuba weényini Masihi no Omukáma, ogu, íimwe mukamubaamba aha musalaba.” ");
INSERT INTO zin_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Abaantu abo, kábaahuliile amagaambo ago, gaábachumita bwooli omu miganya yáabo. Baámubúuza Peétero ne entumwa abáandi, “Bazeenzi béetu, óobu tuzilého túta?” ");
INSERT INTO zin_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peétero yaábagaambila, “Buli oómo weenyu atamwe ebiheno byoómwe no kubilekelela, amuhiindukile Múungu no kubatizwa ahi izíina lya Yeézu Kristu, mubóne kuganyilwa ebiheno byáanyu. Neemwe nimwiinaánkula obuhicha bwo Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Múungu akatweésagiza endagano ezi ha bwéenyu, na abáana báanyu, na ha báandi bóona áabo abali hala okwo, kuba bóona áabo abalikwéetwa no Omukáma, Múungu wéetu weényini.” ");
INSERT INTO zin_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peétero yaázeendelela kubagaambila abo baantu amagaambo agáandi méenzi go kubaneémbelela omu kubagumisa omuganya ha kugaamba, “Mchuungulwe kuluga omu luzáalo olu oluhuugeene lwa abatakutegezwa!” ");
INSERT INTO zin_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ha bwéecho, bóona abeenaánkwiile echigaambo choómwe Peétero, bakabatizibwa. Echilo éecho abaantu bo kuhika nke ebihuumbi bísatu (3,000) baaba baáyoongelwa omu baheémba abáandi. ");
INSERT INTO zin_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Abaheémba bakazeendelela omu kweéyega ebyeégeso bye entumwa za Yeézu. Beékala omu búmo bwo Omwooyo, baaba nibamenyula omukaate, no kumusaba Múungu hamo. ");
INSERT INTO zin_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Entumwa abo bakaba nibakola emanyiso na amahano go kusobeza méenzi, kuhicha abaantu bóona baaba beétimwa. ");
INSERT INTO zin_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abeekiliza bóona bakakóba ahaantu hamo, omu kukobela buli chiintu chóona éecho bakaba beenácho hamo. ");
INSERT INTO zin_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bakaba nibaguza ebiintu byáabo ne empilya éezo baabonesize, bakazibagana, kwiinganisa no okweenda kwa buli oómo okwo kuli. ");
INSERT INTO zin_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Buli chilo bakazeendelela kubugana omu lubúga lwe éenzu ya Múungu. Bakaba nibamenyula omukaate omu maka gáabo, no kulya hamo ha manulilwa no omuganya gulikwéela. ");
INSERT INTO zin_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bakaba nibamukúza Múungu no kunulilwa omu mbabazi za abaantu bóona. Na buchiile, Omukáma yaaba naaboongéla abaantu abáandi omu mbága ya abo abaabeele nibachuungúlwa. ");
INSERT INTO zin_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Echilo chimo, Peétero na Yohana bakaba nibazeénda aha nzu ya Múungu kusaba. Akáanya ako zikaba zili esáaha mweenda za nyemisana. ");
INSERT INTO zin_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Omu nzu ya Múungu omwo, akaba alimo omuuntu, enziíngami óogwo akaba naayimuchwa na abaantu héehi no omulyaango ogulikwéetwa Muzima. Akaba ali omulema kuluga ha kuzáalwa kwoómwe na buli chilo akaba atwáalwa okwo, abone kusaba empilya ha baantu áabo bakaba nibatáaha omu nzu ya Múungu. ");
INSERT INTO zin_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Omuuntu ogwo káyaababwéene Peétero na Yohana beélilila kutaaha omu nzu ya Múungu, yaábasaba bamuhe empilya. ");
INSERT INTO zin_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aho Peétero na Yohana baámutukuliza améeso, niho Peétero yaámugaambila, “Otuléebe íichwe!” ");
INSERT INTO zin_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yaábaleeba, kunu naayetegeza nkokwo bakaba beene echiintu cho kumuha. ");
INSERT INTO zin_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Náho Peétero yaámugaambila, “Tiinyina eféeza nali ezaháabu, náho echi nnyinácho, nicho ndikukuha. Niinkugaambila ahi izíina lya Yeézu Kristu Omunyanazaréeti, yemeelela, olibate!” ");
INSERT INTO zin_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peétero yaámukwáata ogwo muuntu omukóno gwo obúlyo, yaámweemeeleza. Ahonyini amagulu ne enfuundo zoómwe byaaba na amagala. ");
INSERT INTO zin_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yaáyemeelela bwaangu no kuguluka, yaábaanza kulibata weénka. Yaátaha omu nzu ya Múungu hamo na Peétero na Yohana, kunu naalibata no kuguluka guluka naamukuza Múungu. ");
INSERT INTO zin_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Abaantu bóona baámubona naalibata no kumukúza Múungu. ");
INSERT INTO zin_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Baámumanya nkokwo niwe ogwo nyini ayaabeele naayikala no kusabiliza aha mulyaango ogulikwéetwa Muzima gwe éenzu ya Múungu. Bóona bakeekaángwa no kusobelwa bwooli kuleeba echigaambo echo echaamweésuulukiize. ");
INSERT INTO zin_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Obuchilo obwo, omuuntu ogwo ayaáchilizwe akaba naaboomeléla Peétero na Yohana. Abaantu bóona baábelukiilila nibasobelwa bwooli. Ahaantu áaho Peétero na Yohana bakaba bali hakaba niheétwa Ikulato lya Selemani. ");
INSERT INTO zin_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Obuchilo Peétero yaábabwéene abaantu abo, yaábagaambila, “Abaiziraeli bazeenzi baanze, hali chiíha ebyo nibibasobela? Ha bwaáchi nimututukuliza améeso? Nimuzila múti ogu muuntu naalibata ha buhicha bwéetu, nali habwo kuba íichwe nitutuúla nko óokwo Múungu alikutweéndeza? ");
INSERT INTO zin_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mmahi! Ti bityo. Óobu Múungu wa besiichwe enkúlu, Ibrahímu, Izáaka, na Yakobo, yaámukúza omuzáana woómwe Yeézu. No ogwo Yeézu niwe óogwo íimwe nyini mwaamusohwéeze ahali Pilato, mukatóonga nka nikwo achwaaziikilwe okufwa! No óobu obuchilo Pilato akaba ayeenzile amulekulile Yeézu azeénde, mukamwáanga, ");
INSERT INTO zin_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","mwaámusaba Pilato nkokwo omwíisi achiingulilwe no kuleka weényini. Mukamwáanga Yeézu, Omutakatíifu no Omugololoke. ");
INSERT INTO zin_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mukamwíita weényini ali obutaándikilo bwo obulame! Náho Múungu akamuzoola kuluga omu bafwiile, neechwe ni baalubona bo okuzooka kwoómwe. ");
INSERT INTO zin_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Omuuntu óogwo mulikubona aha, nimumumanya kuzima. Weényini yaáchízwa ha muháanda gwo okwiikiliza omu izíina lya Yeézu. Éelyo izíina, hamo no kumwiikiliza weényini, niyo ensoonga yaabele no kuchila, nko óokwo mulikubona óokwo aáli. ");
INSERT INTO zin_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Óobu Abaiziraeli bazeenzi béetu, éebyo byóona éebyo mwaámukoliile Yeézu, íimwe na abatwaáliliza báanyu, niimmanya nkokwo mukakola habwo butasoombookelwa. ");
INSERT INTO zin_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Náho, aha muháanda ogwo Múungu akahikiíliza amagaambo áago yaábaasize ha muháanda gwa ababáasi boómwe bóona nkokwo, Masihi woómwe naayagalazwa. ");
INSERT INTO zin_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ha bwéecho, mutamwe ebiheno byáanyu no kubilekelela, mumuhiindukile Múungu, niho weényini ayihého ebiheno byáanyu, bubone kwiiza obuchilo bwo kuhuúmuzwa habwo kubaho kwoómwe Omukáma. Ha muháanda ogu, Múungu aláaba naabachuleéza no kubagumya emyóoyo kuluga ha Mukáma Múungu, ");
INSERT INTO zin_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","naasiindika Yeézu hali íimwe. Weényini niwe Masihi, Omuchuúnguzi óogwo Múungu yaámutoólize ha bwéenyu íimwe kuluga ha bubaandizo. ");
INSERT INTO zin_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ni lwaampaka Yeézu asigale omu igulu kuhicha buhike obuchilo Múungu akole ebiintu byóona bibe bisha, nko óokwo yaágaambile kuluga kala ha muháanda gwa ababáasi boómwe abatakatíifu. ");
INSERT INTO zin_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Kuba, Musa akagaamba, ‘Kuluga omuli íimwe Abaiziraeli, Omukáma Múungu weenyu alyaábaleétela omubáasi nkeenye. Muhuliilíze kuzima buli chigaambo éecho alibagaambila. ");
INSERT INTO zin_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Omuuntu weéna wéena óogwo alileka kumuhuliiliza ogwo omubáasi, alyaáchiindikwa mazima na abaantu ba Múungu.’ ");
INSERT INTO zin_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","No óobu ababáasi bóona, kubaandiza Samweeli na abáandi áabo abaakulaatiilého, bakabáasa amagaambo ge ebilo ebi. ");
INSERT INTO zin_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Íimwe muli abáana ba ababáasi, káandi mulimo omu ndagano éezo Múungu yaákozile na baguúku báanyu. Múungu akamweésagiza Ibrahímu, ‘Kuluga omu luzáalo lwaawe ndyaáfuuha engaanda zóona omu nsi.’ ");
INSERT INTO zin_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Múungu kayaamukulize omuzáana woómwe Yeézu, obwa mbele akamusiíndika hali íimwe, niho abafúuhe ha kubahiindula buli oómo kuluga omu biheno byoómwe.” ");
INSERT INTO zin_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Obuchilo Peétero na Yohana bakaba niboolekeelela abaantu abo, abagabe ba Múungu, na Abasadukayo, na mukúlu wa abalwaanila ngoma be éenzu ya Múungu baabeezáho. ");
INSERT INTO zin_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Beeza basaayile bwooli, habwo kuba Peétero na Yohana bakaba nibabeegesa abaantu nibabaatulila nkokwo, hali Yeézu heena okuzooka kwa abáfwiile kwiingana no kuzooka kwoómwe. ");
INSERT INTO zin_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ha bwéecho, baábakwáata Peétero na Yohana. Baábachiíngila omu ibóhelo kuhicha nyeéncha eémo, habwo kuba hakaba hali olweébazo. ");
INSERT INTO zin_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","No óobu bityo, béenzi abaahuliile echigaambo cha Peétero na Yohana bakeekiliza, kuhicha okubalwa kwa abakwaáta boónka áabo abakeekiliza Yeézu kwaáhika ebihuumbi bitaanu biti. ");
INSERT INTO zin_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nyeéncha eémo, echilo cha kábili, abatégeki, abanyaampala, na abeégesa be ebilagilo baákoba aho Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ahagáti ya abaantu abo, bakaba balimo omugabe omukúlu wa Múungu Anasi, hamo na Kayafa, Yohana, Alekisanda, na abáandi áabo bakaba bali bo lugaanda lwa Anasi. ");
INSERT INTO zin_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Baálagila Peétero na Yohana baleetwe, baábeemeeleza omu méeso gi Itégekelo lya Balusiingo, baábabúuza omu kugaamba, “Ago gi mukozile, mugakozile ha buhicha chi, nali ahi izíina lyo oóha?” ");
INSERT INTO zin_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aho Peétero ayizwiile obuhicha kuluga aha Mwooyo Mutakatíifu yaábasubiza, “Abatégeki na abanyaampala! ");
INSERT INTO zin_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Keélaaba leélo nimutubuúza amabúuzo habwo kuba tumuhweéliile omuuntu ogu akaba ali omulema, na nimutubuuliliza nka nikwo yaachizwáho, ");
INSERT INTO zin_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","mbwéenu, íimwe mwéena, hamo na Abaiziraeli abáandi bóona, mumanye ebi. Niinyeénda mumanye ha mazima nka nikwo ogu ayemeeliile omu méeso géenyu yaábeele no bulami ha buhicha bwi izíina lya Yeézu Kristu Omunyanazaréeti. Ogwo niwe íimwe mukamubaamba, náho Múungu akamuzoola kuluga omu bafwiile. ");
INSERT INTO zin_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Niwe óogwo Amaandiko Matakatíifu galikugaamba nka nikwo, weényini ni, ‘Ibáale éelyo mukáanga íimwe aboómbeki, elyo nilyo lyaahiindukile kuba ibáale igazi lyo oluhazo.’ ");
INSERT INTO zin_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Obuchuúnguzi nibubonwa kuluga hali weényini weénka, Yeézu Kristu! Kuba mazima tihaliho izíina eliindi iífo yi igulu éelyo baheélwe abaantu kubachuúngula, obuchuúnguzi bwéetu ni lwaampaka buluge ahi izíina éelyo lyoónka.” ");
INSERT INTO zin_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Balusiingo abo kábaabweene nkokwo Peétero na Yohana baágaamba no obugimi, na nkokwo abo na abaantu bátyo kwoónka batéena echisomo, niho baábasobelwa bwooli. Baábaanza kumanya nka nikwo Peétero na Yohana baabeele hamo na Yeézu ha mwáanya. ");
INSERT INTO zin_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Náho, habwo kuba balusiingo abo bakaba nibamuleeba omukwaáta óogwo akachízwa ayímeeliile aho ali hamo na Peétero na Yohana, tibalabeele ne echigaambo cho kugaamba. ");
INSERT INTO zin_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bityo, baábazema Peétero na Yohana basohole omu Itégekelo elyo. Boónyini baasigalámo nibehanuuza ");
INSERT INTO zin_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","no kweébuuza báti, “Tubazilého túta abaantu aba? Abatúuzi bóona ba aha Yeruzaléemu nibamanya nkokwo baákola emanyiso zi ihano, na titúkuhicha kulyóoga. ");
INSERT INTO zin_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Náho tubone kwaángila echigaambo chitáakuzeendelela kusaágiliza kusaámbaala omu baantu, ni kuzima tubaángile abaantu aba balekelele kugaamba káandi no omuuntu weéna wéena ahi izíina lya Yeézu.” ");
INSERT INTO zin_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Niho áabo balusiingo baábéeta Peétero na Yohana. Baábagaambila bataleengesa kweégesa nali kugaamba káandi habwi izíina lya Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Náho Peétero na Yohana baábagaambila, “Mulamule íimwe nyini, kábilaaba na mazima omu méeso ga Múungu kubakoondookela íimwe kuchila Múungu. ");
INSERT INTO zin_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Íichwe Titúkuhicha kuleka kugaamba habwe ebigaambo éebyo twaabwéene no kuhulila!” ");
INSERT INTO zin_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Peétero na Yohana kabaagaambile báti, balusiingo abo tibalabweene omuháanda gwo kubachwaáziika, habwo kuba abaantu bóona bakaba nibamukúza bwooli Múungu habwe emanyiso yi ihano elyo. Bakaba nibamanya nkokwo omuuntu óogwo ayaáchizwa akaba ali omulema ha mwáanya gwe emyáaka makúmi aána no obusáago. Ha bwéecho balusiingo baábahana káandi Peétero na Yohana aha busaaye buháango, baábalekulila bazeénde. ");
INSERT INTO zin_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Peétero na Yohana, obuchilo bakakomoololwa, baásuba ha beekiliza bazeenzi báabo. Baábasoomboolela amagaambo góona áago baagaambíilwe na abakúlu ba bagabe ba Múungu hamo na abanyaampala ba Abayahudi. ");
INSERT INTO zin_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na abaantu abo kábaahuliile amagaambo ago, bóona hamo baáteelana omu kumusaba Múungu nibagaámba, “Íiwe Omukáma Múungu, íiwe níiwe omutégeki mukúlu wa byóona. Íiwe níiwe ayaahaangile igulu, ne éensi, ne enziba, na byóona ebilimo. ");
INSERT INTO zin_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Íiwe okagaamba ha muháanda gwo Omwooyo Mutakatíifu, kulabila ha kanwa ke isíichwe Daudi, omuzáana waawe, ‘Ha bwaáchi Abanyamahaánga nibasáaya bwooli, káandi, abaantu nibateekuza ebitéena mugaso? ");
INSERT INTO zin_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abakáma be éensi na abatégeki baákobile hamo, babone kumwáanga Omukáma, no kumwáanga Masihi woómwe.’ ");
INSERT INTO zin_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Na amazima nka nikwo omukáma Herode na Pontio Pilato bakakoba hamo na Abanyamahaánga na Abaiziraeli omu chikaali echo, babone kumwáanga Yeézu, omuzáana waawe omutakatíifu óogwo waámutoólize. ");
INSERT INTO zin_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Boónyini baákola áago kwiingana no obuhicha bwaawe no okweenda kwaawe óokwo okaba olamwiileho gakolwe kuluga aha bubaandizo. ");
INSERT INTO zin_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Omukáma Múungu, okuléebe okulamula kwáabo kubi. Otuhe obuhicha, íichwe abazáana baawe, kugaamba echigaambo chaawe ha bugimi buháango. ");
INSERT INTO zin_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Golola omukóno gwaawe obóne kuchiza abaantu, no kukola emanyiso na amahano ha muháanda gwi izíina lya Yeézu, omuzáana waawe mutakatíifu!” ");
INSERT INTO zin_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Obuchilo baámazile kumusaba Múungu, ahaantu áaho baabeele bakobile haáchuundagulwa. Nábo bóona beezuzwa obuhicha kuluga aha Mwooyo Mutakatíifu, baábaanza kweégesa abaantu echigaambo cha Múungu ha bugimi. ");
INSERT INTO zin_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Abeekiliza bóona bakaba béene obúmo ha mateékuzo na ha chihika. Taliho omuuntu óogwo akatóonga no óobu echiintu chimo nka nikwo ne cha weényini weénka, náho bakakobela hamo byóona éebyo baabeele beenábyo. ");
INSERT INTO zin_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Entumwa za Yeézu bakaba nibabagaambila obuumbona abaantu ha buhicha bwíinzi aha mpola za nka nikwo, Omukáma Yeézu azoókile. Múungu akaba naabaha bóona embabazi yoómwe mpaango. ");
INSERT INTO zin_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kuba talabeeleho omuuntu weéna wéena omuli abo óogwo ayaalebesize echiintu. Ha kuba abaantu bóona abo abaabeele beene amasaambo nali éenzu bakabiguza, ");
INSERT INTO zin_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","empilya baázita omu magulu ge entumwa. Ezo mpilya entumwa baázigabila abaantu, kwiingana no okweendáho kwa buli muuntu. ");
INSERT INTO zin_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Hakaba heena Omuláawi oómo, izíina lyoómwe Yozéfu, enzáalwa yo omu iziinga lya Kipro, óogwo entumwa za Yeézu bakamweeta izíina Barinaba (ensoonga yaáho no, “Owo kugumya omuganya”). ");
INSERT INTO zin_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ogwo muuntu akaguza ensaambo yoómwe. Ne empilya éezo yaabweene, yaáziléeta aha ntumwa. ");
INSERT INTO zin_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hakaba heena omuuntu, izíina lyoómwe Anania. Mukazíwe akaba naayétwa Safira. Boónyini bakaguza ensaambo yáabo. ");
INSERT INTO zin_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","No kuluga empilya éezo baabonesize, Anania akeehaho empilya ezíindi yaáziseleka habwa weényini. Mukazíwe akaba ayikililizeene náwe kukola aátyo. Empilya éezo ezaasigeele, Anania yaáziléeta yaábaha entumwa za Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Náho Peétero yaámugaambila, “Íiwe Anania! Ha bwaáchi Isitáani lyaátégeka omuganya gwaawe, kuhicha kugaamba ebisuba ha Mwooyo Mutakatíifu? Ha bweeseléke weébiikila ensaága ye empilya éezo obweéne ha kuguza ensaambo yaawe. ");
INSERT INTO zin_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Otakaligulize libeele litali echiintu chaawe, tikwo? Noobwo obeele waágulize, empilya zibeele zili omu buhicha bwaawe kuzikoza óokwo olikweenda. Ha bwaáchi waálamula kukola echigaambo nke éechi? Tiwaábeeha muuntu, waágaambila Múungu ebisuba!” ");
INSERT INTO zin_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Obuchilo Anania yaáhuliile éebyo bigaambo bya Peétero, yáagwa ahaansi, yaáfwa. Bóona áabo abaahuliile ebigaambo éebyo bya Peétero bakeéganya bwooli. ");
INSERT INTO zin_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Abasigazi beeza baásweekelela omubili gwoómwe ne esuúka, baámusohoza ahéelu, baámuziika. ");
INSERT INTO zin_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kahaabaliile ha mwáanya gwe esáaha isatu zíti, muka Anania náwe yaátaaha omu chiseenge éecho, atéena kumanya amagaambo áago agáagwa. ");
INSERT INTO zin_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peétero yaámubúuza, “Hóona sii! Ngaambila, mugulize ensaambo yáanyu ha mpilya ezi?” Yaámusubiza, “Éego! Tugulize ha ndeengo éezo!” ");
INSERT INTO zin_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peétero yaámugaambila, “Ha bwaáchi íiwe na bálo mweékiliza kumuleengesa Omwooyo Mutakatíifu gwo Omukáma? Léeba! Abasigazi áabo abaázeenda kumuziika bálo, baásuba, óobu bali áaho aha chisasi, nibataahámo kukutwáala íiwe ahéelu óobu nyini!” ");
INSERT INTO zin_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ahonyini Safira náwe yáagwa ahaansi omu magulu ga Peétero, yaáfwa. Niho abasigazi baataahámo, baásaanga Safira náwe yaáfwiile. Baágusohoza ahéelu omutúumbi gwoómwe, baáguziika héehi neéba. ");
INSERT INTO zin_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Amagaambo áago gaásaambaala omu kelezia, beétimwa bwooli, hamo na abáandi bóona áabo abaahuliile empola ezi. ");
INSERT INTO zin_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Éezo entumwa za Yeézu bakaba nibakola emanyiso na amahano go kusobeza méenzi omu baantu. Na abeekiliza ba Yeézu bóona bakaba bakoba hamo omu nzu ya Múungu, omu Ikulato lya Selemani ha nsoonga eémo. ");
INSERT INTO zin_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Omuuntu weéna wéena oóndi óogwo akaba atali omwiikiliza akatíina kuteélana nábo. Náho, abaantu béenzi bakabakoondookela. ");
INSERT INTO zin_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nábo abáandi, abakwaáta na abakázi, bakamwiíkiliza Omukáma, bityo obukúmi bwa abeekiliza bukaba nibweeyoongela bwooli. ");
INSERT INTO zin_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Habwa amahano ge entumwa, abaantu bakaba nibabasohoza abalwéele ahéelu nibabatwaála kubalyaámika omu miháanda. Óokwo bakaba nibabalyaamika aha bitabo ne emikeeka, kubona obuchilo Peétero naahiingula, echimunyaamunya choómwe chibone kubakúumya abáandi omuli áabo, bachile. ");
INSERT INTO zin_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Abaantu beenzi bakahika kuluga omu maboma ge engeégeelo ya Yeruzaléemu, nibabaleéta abalwéele báabo, na áabo abaabeele batuungamiilwe na amazimu. Bóona bakachízwa. ");
INSERT INTO zin_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Omugabe omukúlu, na bazeenzíbe bóona áabo bakaba bali Abasadukayo, bakazila ichubi bwooli habwe entumwa za Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ha bwéecho, baábakwáata entumwa éezo, baábachiíngila omu ibóhelo liháango. ");
INSERT INTO zin_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Náho omu chilo omwo maléeka oómo wo Omukáma Múungu yaáchiingula emilyaango ye éenzu éezo, yaábasohoza ahéelu. Mala yaábagaambila, ");
INSERT INTO zin_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Muzeénde kweémeelela omu lubúga lwe éenzu ya Múungu, mubagaambile abaantu amagaambo góona habwo obulami óobu obusha!” ");
INSERT INTO zin_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Entumwa éezo kábaahuliile éebyo, baábikoondookela, baázeenda omu lubúga lwe éenzu ya Múungu enchaákala yo omulutulutúlu, baábaanza kweégesa abaantu omwo. Obuchilo óobwo nyini omugabe omukúlu, hamo na bazeenzíbe áabo, bakabalaálika Itégekelo lya Balusiingo ba Abaiziraeli, nikwo kugaamba embága yóona ya abakúlu ba Abayahudi, babugane. Baásiindika abaantu omu ibóhelo, babone kubaléeta entumwa ezo. ");
INSERT INTO zin_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Náho obuchilo baatahilemo omwo, baásaanga ezo entumwa tibalimo. Baásuba basohoza empola nkokwo, ");
INSERT INTO zin_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Obuchilo twaáhika omu ibóhelo, twaásaanga emilyaango echiingile kuzima, na abachuungi beémeeliile ahéelu ye emilyaango nibachuúnga. Náho obuchilo twaáchiingula emilyaango, titwaámusaangamo omuuntu weéna wéena omwo omugati!” ");
INSERT INTO zin_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Omukúlu wa abachuungi be éenzu ya Múungu no omugabe omukúlu kábaahuliile éebyo baaba no kutahwa tahwa omu kweébuuza, “Amagaambo aga gaabaho gáta?” ");
INSERT INTO zin_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mala omuuntu oómo yeeza, yaábagaambila, “Muunhuliilize! Áabo baantu abo mubeele mubohile, óobu nyini balimo omugati omu lubúga lwe éenzu ya Múungu! Nibeegesa abaantu!” ");
INSERT INTO zin_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Niho óogwo mukúlu wa abachuungi, hamo na abachuungi boómwe, baázeenda ha lyéezo ntumwa, baábaléeta. Náho tibalabakwaásile lwa amáani, habwo kuba bakatíina nkokwo abaantu bakaábahoonzile na amabáale. ");
INSERT INTO zin_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Baábeebeembelela omu Itégekelo éelyo lya Balusiingo, baábeemeeleza omu méeso ga bóona. Omugabe omukúlu yaábagaambila, ");
INSERT INTO zin_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tubaangiíze bwooli nkokwo mutabeégesa abaantu habwi izíina lyo omuuntu ogwo! Náho nimuzeendelela kweégesa abaantu empola zoómwe omu nkási zóona za Yeruzaléemu, nimugaámba nkokwo kufwa kwoómwe kwaáletelelwa neechwe.” ");
INSERT INTO zin_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peétero hamo ne entumwa bazeenzíbe baábagaambila, “Chikwiílwe tumukoondoókele Múungu, kuchila kukoondoókela abaantu! ");
INSERT INTO zin_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Íimwe mukamwíita Yeézu ha muháanda gwo kumubáamba aha musalaba, náho Múungu wa besiichwe enkúlu akamuzoola. ");
INSERT INTO zin_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yaámweemeeleza óogwo no kumuhanamika aha chitébe ha kumuta olubazu lwoómwe lwo obúlyo, aábe Omutégeki no Omuchuúnguzi. Múungu akozile aátyo, kuba ababonese Abaiziraeli balekelele ebiheno byáabo, na baganyilwe. ");
INSERT INTO zin_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Íichwe ni baalubona be éebyo byóona, na káandi Omwooyo Mutakatíifu ni lubona. Weényini niwe óogwo Múungu yaátuhéele íichwe abeétegeeleza boómwe.” ");
INSERT INTO zin_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Obuchilo balusiingo áabo kábaahuliile éebyo, baásaaya bwooli, bakaba nibeénda kubéeta áabo entumwa. ");
INSERT INTO zin_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Náho omu Itégekelo éelyo, hakaba heena Omufarisayo oómo, izíina lyoómwe Gamalieli. Gamalieli óogwo akaba ali omweégesa we ebilagilo, akaba naakuzwa na abaantu bóona. Akeémeelela, yaálagila nkokwo entumwa basohozwe ahéelu ha mwáanya mugufu. ");
INSERT INTO zin_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mala yaábagaambila balusiingo bazeenzíbe, “Abakwaáta ba Iziraeli, mweétegeeleze echigaambo éecho mulikweenda kukola ha baantu aba! ");
INSERT INTO zin_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nimwiizuka ebilo éebyo ebihiingwiile, akaba aliho omuuntu, izíina lyoómwe Theuda. Theuda ogwo akaba naayebuga nkokwo no omuuntu mukúlu, na abaantu magana aána báti baáhulilana náze. Náho omuheleeluko, akeetwa, na áabo bóona áabo abaamukulaatiile bakasaámbaala. Emilimo záabo zóona, zaaba busa. ");
INSERT INTO zin_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Káandi, ahakulaatiilého, obuchilo obwo abaantu bakaba nibabalwa, akabaho omubisa oóndi. Óogwo akaba ali omu Galiláaya, izíina lyoómwe Yuda. Akababéeha abaantu bamukulaatile, náho náwe akafwa, na bóona áabo abaamukulaatiile bakasaámbaala. ");
INSERT INTO zin_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mbwéenu óobu niimbahanúuza, mubaleke abaantu aba! Mutaákubakolela choóna chóona, kábilaaba omuháanda gwáabo na byóona éebyo balikukola ne byo obumuuntu kwoónka, nibihwáho byoónyini. ");
INSERT INTO zin_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Náho kábilaaba ebyo ne emilimo za Múungu, timukuhicha kubaángila aba, nimwiisaánga nimumwaánga Múungu weényini.” ");
INSERT INTO zin_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bityo, okulamulwa okwo kwa Gamalieli, áabo bazeenzíbe baákwiikiliza. Baábéeta entumwa kusuba omu Itégekelo. Baálagila bateélwe ensáanzu bwooli. Mále baábaángila nka nikwo balekelele kubagaambila abaantu empola omu izíina lya Yeézu, baábalekulila bazeénde. ");
INSERT INTO zin_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Entumwa áabo baalugamo omu Itégekelo éelyo nibanulilwa, habwo kuba baáyeendelwa kugoolwa habwi izíina lya Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tibalalekile kweégesa abaantu no kubaátulila Empola Nzima nka nikwo Yeézu niwe Masihi. Buli chilo bakazeendelela kukola bátyo omu lubúga lwe éenzu ya Múungu, no omu maka ga abaantu. ");
INSERT INTO zin_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ebilo éebyo, obwíinzi bwa abaheémba ba Yeézu bukaba nibuzeendelela kukanya. Omuli áabo hakaba heena Abayahudi áabo abagaambile olulími lwe Echiyunani, na Abayahudi bazeenzi báabo áabo abagaambile olulími lwe Echihebrania. Abo abaabeele nibahóoya Echiyunani bakabadugulumila Abayahudi abo olulími lwe Echihebrania nka nikwo, tibalabasaasilwe entuúmbakazi záabo omu kubabaganisiza ebyookulya bya buli bucha. ");
INSERT INTO zin_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ha bwéecho entumwa ikúmi na bábili baábakobya kobya abaheémba bóona, baábagaambila, “Ti kuzima íichwe tuleke kweégesa echigaambo cha Múungu habwo kugabila abaantu ebyookulya. ");
INSERT INTO zin_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ha bwéecho, beekiliza bazeenzi béetu, mutoóze abakwaáta musaanzu omuli íimwe áabo abalikumanyíika nkokwo beezwíile obuhicha kuluga Omwooyo Mutakatíifu no kweétegeeleza. Abo nitubaha omulimo ogu, ");
INSERT INTO zin_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","tubone íichwe kuguma kumusaba Múungu no kuchiheéleza omu baantu echigaambo choómwe.” ");
INSERT INTO zin_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Echo chigaambo chaábanulila abaheémba abo bóona. Baátóoza Stefano, omuuntu óogwo ayizwiile Omwooyo Mutakatíifu no owo okwiikiliza kuháango. Káandi baábatóoza Filipo, Porokoro, Nikanori, Timoni, Parimena, na Nikolao wa Antiokia, ogu ayaahiindukile no kukulaatila okwiikiliza kwa Abayahudi. ");
INSERT INTO zin_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Baábaléeta abakwaáta abo omu méeso ge entumwa, nábo baábasabila nibabateélaho emikono aha lugulu yáabo. ");
INSERT INTO zin_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ne echigaambo cha Múungu chaásaambaala. Okubalwa kwa abaheémba kweéyoongela bwooli omuli Yeruzaléemu, ne embága mpaango ya abagabe be Echiyahudi baákoondookela okwo kwiikiliza. ");
INSERT INTO zin_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Múungu akaba naamuha Stefano embabazi bwooli no obuhicha bwíinzi, yaaba naakola amahano maháango go kusobeza ne emanyiso omu baantu. ");
INSERT INTO zin_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Náho abáandi omu Bayahudi bakaleéngesa kuhakana náwe. Abo bakaluga omu isomelo lya Abayahudi éelyo elyaayesilwe Isomelo lya Abaantu Bokweéyagaalula. Abáandi omuli abo bakaluga Kurene na Alekisandria, na abáandi bakaluga Kilikia, na Asia. Abayahudi abo baaba nibehanuuza na Stefano, ");
INSERT INTO zin_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","náho yaaba naabasiínga ha kugaamba amagaambo go kweétegeeleza ha buhicha bwo Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Niho baásunika abaantu bunaanka bweeseléke, babone kugaamba ebisuba nkokwo bamuhuliíle Stefano naamuzuma no kulyoogooza kubi habwa Musa na Múungu. ");
INSERT INTO zin_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ha kugaamba ebyo, baábasunika bwooli abaantu, hamo na abanyaampala ba Abayahudi na abeégesa be ebilagilo. Abo baamuzáho Stefano, baámukwáata, baámutwáala omu Itégekelo lya Balusiingo ba Abayahudi. ");
INSERT INTO zin_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Baáléeta baalubona be ebisuba, abo baágaamba ebisuba habwa Stefano, nibagaámba, “Ebilo byóona ogu muuntu naagaámba amagaambo ge echilogwéezi habwe éenzu ezi entakatíifu ya Múungu, na habwe ebilagilo bya Musa! ");
INSERT INTO zin_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ha kuba tumuhuliíle naagaámba nkokwo, Yeézu Omunyanazaréeti naakaambúla éenzu ezi ya Múungu, no kuhiindula entúungwa éezo twiinaánkwiile kuluga hali Musa.” ");
INSERT INTO zin_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Abaantu bóona omu Itégekelo elyo lya Balusiingo bakeekala bamutukuliíze améeso Stefano, bakabona obuso bwoómwe bwaásusana nko obuso bwa maléeka. ");
INSERT INTO zin_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mala omugabe omukúlu yaámubúuza Stefano, “Aga góona áago balikugaamba ha bwéenyu, ngási nikwo gali?” ");
INSERT INTO zin_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano yaágaamba, “Íimwe bazeenzi béetu na besiichwe, muunhuliilize! Múungu wi ikuzo akeesuulukiza hali táata wéetu Ibrahímu ali omu nsi ya Mesopotamia, obuchilo acháali atakafulukíile Haráani. ");
INSERT INTO zin_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Múungu akamugaambila, ‘Olugemo omu nsi yaawe ezi, obasige omwo badugu baawe, ozeénde omu nsi éezo ndaakwoóleka.’ ");
INSERT INTO zin_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Niho Ibrahímu akafuluka omu nsi yoómwe ya Bakalidayo, yaázeenda yaátuula Haráani. Káyaabeele yaámazile kufwa iíse, Múungu yaamufululayo okwo, yaámuléeta omu nsi ezi yo mulikutuulamo íimwe óobu. ");
INSERT INTO zin_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Omu nsi ezi, Múungu talamuhéele Ibrahímu obuhuunguzi bwoóna bwóona, no óobu akanogoka kache. No óobu bityo, akamweésagiza kumuha éensi ezi, eébe eyoómwe no oluzáalo lwoómwe, noobwo obuchilo óobwo akaba atéena mwáana. ");
INSERT INTO zin_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Bityo Múungu yaámugaambila Ibrahímu, ‘Abaantu bo oluzáalo lwaawe balyáaba abazenyi omu nsi ya abaantu abáandi. No okwo, abaantu be éensi éezo nibabakola abahálila báabo, nibaba nibabaagaláza bwooli ha myáaka magana aána. ");
INSERT INTO zin_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Náho abaantu bi ihaánga elyo, íinye Múungu wáanyu ndyaábachwaáziika, niho, abaantu bo lugaanda lwaawe balyaáluga omu nsi ezo, baléeza aha no kuungomookela.’ ");
INSERT INTO zin_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Káyaabalíile Múungu yaákola endagano na Ibrahímu yo kusála amakóba, éezo eyaakozilwe ha muháanda gwo kusála ikóba buli mwáana wo bukwaáta. Bityo Ibrahímu yaaba iíse wa Izáaka, akamusála ikóba echilo cha munáana káyaabeele yaazéelwe. Náwe Izáaka yaaba iíse wa Yakobo, yaámusala ikóba, náwe Yakobo yaaba iíse wa abasigazi ikúmi na bábili, yaábasala amakóba. Abo nibo besiichwe enkúlu. ");
INSERT INTO zin_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Abo baguúku béetu bakamuzilíla ichubi mudugu wáabo, Yozéfu, baámuguza aábe omuhálila omu nsi ya Miísiri. Náho, Múungu akaba ali hamo náze Yozéfu, ");
INSERT INTO zin_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","yaámuchuúngula omu byaágalazo byoómwe byóona. Yaámuha okweétegeeleza ne embabazi yoómwe kuhicha Farao omukáma wa Miísiri yaámwéenda, yaamutaho aábe omutégeki mukúlu omu nsi yoómwe ya Miísiri, no omwiímeelelezi wa bóona omu nzu yoómwe ye chikáma. ");
INSERT INTO zin_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Káhabalíile haabáho ne enzala mpaango omuli ezo nsi yóona ya Miísiri, no omu nsi ya Kanáani, abaantu baáyagalala bwóoli. Besiichwe enkúlu bakesaánga batéena echookulya choóna chóona. ");
INSERT INTO zin_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobo yaáhulila nkokwo omu nsi ya Miísiri hakaba heena engano, yaábasiíndika besíichwe enkúlu, bazeénde okwo. Olu lukaba luli oluzeendo lwáabo lwa mbele kuhika okwo. ");
INSERT INTO zin_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Omu luzeendo lwáabo lwa kábili, Yozéfu yeémanyisa hali badugúbe, na Farao yaábamanya badugu ba Yozéfu. ");
INSERT INTO zin_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yozéfu yaásiindika empola hali iíse Yakobo, nkokwo ayize okwo Miísiri hamo na badugu boómwe bóona. Bakaba bali abaantu makúmi musaanzu na bataanu. ");
INSERT INTO zin_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mala Yakobo yaázeenda Miísiri, yaafweeláyo okwo, weényini hamo na baguúku béetu. ");
INSERT INTO zin_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kábaabalíile emibili yáabo yaáleetwa owáabo Shekeemu, yaáziikwa omu mbi ye nyaanga. Enyaanga éezo Ibrahímu akagulayo okwo ha mpilya bunaanka kuluga ha baana bo bukwaáta bo mwa Hamóori. ");
INSERT INTO zin_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Náho, obuchilo kábwaabeele bweéliliza óobwo Múungu ahikiílize endagano éezo akaba yaamweésagiize Ibrahímu, obwíinzi bwa abaantu okwo Miísiri bukeéyoongela bwooli. ");
INSERT INTO zin_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ha muheleeluko, yaabaho omukáma oóndi yaábaanza kutégeka, ogu akaba atakumanya empola zoóna zóona za Yozéfu. ");
INSERT INTO zin_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Omukáma ogu akababéeha abaantu bi ihaánga lyéetu, no kubáaya, no kubahatika banage ahéelu abáana báabo abacheche, babone kufwa. ");
INSERT INTO zin_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Omu buchilo obwo nyini Musa akazáalwa, akaba ali omwaana muzima bwooli omu méeso ga Múungu. Akalelwa na abazéele boómwe omu nzu yáabo ha méezi asatu. ");
INSERT INTO zin_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Obuchilo óobwo abazéele boómwe bakalemwa kuzeendelela kumuseleka, baámuta ahéelu. Yaákugwa na muhala wo Farao omukáma wa Miísiri, yaámutwáala yaámulela nko omwaanáwe wo bukwaáta. ");
INSERT INTO zin_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa yaáyolekeelelwa amasala góona ga Abamiísiri, yaaba omugimi omu kugaamba, no wa amagala ha kukola. ");
INSERT INTO zin_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Obuchilo Musa káyaahikize echéemo che myáaka makúmi aána, akazila echihika cho kuzeenda kubayeélela badugúbe Abaiziraeli. ");
INSERT INTO zin_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yaábona Omuiziraeli oómo, óogwo atéena ntaambala, naahutáazwa no Mumiísiri. Ahonyini yaámulwaanila ogwo mudugu woómwe, yaámweehoolela aha kumwiígaza ogwo Mumiísiri. ");
INSERT INTO zin_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Obuchilo obwo Musa akaba naateekuza nkokwo badugu boómwe baakaásoombookiilwe nkokwo Múungu naabachuungúla ha buhweezi bwoómwe, náho tibalasoombookiilwe bátyo. ");
INSERT INTO zin_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nyeéncha eémo, yaábugana na Abaiziraeli bábili áabo bakaba nibalwáana. Yaáleengesa kubalamula, naabagaambila, ‘Boózo, íimwe muli abadugu! Ha bwaáchi nimweehutáaza?’ ");
INSERT INTO zin_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Náho weényini ayaabeele naamuhutáaza muzeenzíwe yaásiindika Musa aha lubazu, naagaámba, ‘Noóha ogu ayaakutiilého oóbe omutégeki wéetu no mulamuzi wéetu? ");
INSERT INTO zin_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ngási, nooyeénda kuunyíta nko óokwo oyisile ogwo Mumiísiri nyeénchilo?’ ");
INSERT INTO zin_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Obuchilo Musa káyaahuliile amagaambo ago, yeeluka, yaázeenda omu nsi ya Midiani, kutúula okwo nko omuzenyi. Okwo, akazáala abáana bábili. ");
INSERT INTO zin_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Káyaabeele yaátwíile Midiani emyáaka makúmi aána, ali omu nsi yo obwoóma muno héehi ni ibaanga lya Sinai, akeésuulukizwa na maléeka oómo. Ogwo maléeka akaba ali omu chisaka éecho echaabeele nichaáka omulilo. ");
INSERT INTO zin_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Obuchilo yaabweene echisaka éecho akasobelwa bwooli, yeelila héehi kuchileeba kuzima, yaáhulila iláka lyo Omukáma Múungu, nilimugaambila, ");
INSERT INTO zin_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Íinye ndi Múungu wa besiimwe enkúlu, Múungu wa Ibrahímu, Izáaka, na Yakobo!’ Obuchilo Musa káyaahuliile ago, yaábaanza kuzuguma ha butíini, talaleengesize kuleeba echisaka echo. ");
INSERT INTO zin_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Aho Omukáma Múungu yaámugaambila, ‘Zuúla enkeeto zaawe, habwo kuba aho ho oyimeeliíle na ahaantu hatakatíifu. ");
INSERT INTO zin_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mazima naábona abaantu baanze óokwo balikwaágalazwa okwo omu nsi ya Miísiri, naáhulila okuchula kwáabo. Ha ensoonga ezo naátuuka ahaansi mbone kubachuúngula. Óobu, niinkusiindika okwo Miísiri.’ ");
INSERT INTO zin_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ogu Musa, niwe óogwo abaantu ba Iziraeli bakamwáanga omu kugaamba, ‘Noóha ogu ayaakutiilého oóbe omutégeki wéetu no mulamuzi wéetu?’ Niwe ogwo nyini Múungu akamusiíndika aábe omutégeki wáabo no omuchuúnguzi wáabo, ha muháanda gwa maléeka ogu ayaamweésulukiize omuli echo chisaka! ");
INSERT INTO zin_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Káyaabaliile, Musa akabeébeembelela kubeeha omu nsi ya Miísiri, ha muháanda gwo kwoóleka amahano ne emanyiso nyíinzi éezo akaba naakola omu nsi ya Miísiri, omu nziba ya Shamu, no omu nsi yo obwoóma muno ha mwáanya gwe myáaka makúmi aána.” ");
INSERT INTO zin_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ogwo niwe Musa ayaagaambiile Abaiziraeli abo, ‘Kuluga omuli badugu báanyu, Múungu alyaámukuza omubáasi nkeenye.’ ");
INSERT INTO zin_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Niwe ogu akaba ali hamo no omukobo gwa Abaiziraeli omu nsi yo obwoóma muno. Niwe ogu ayaagaambile na maléeka wa Múungu hamo na besíichwe enkúlu omu ibaanga lya Sinai, yaáyanaankula kuluga hali weényini amagaambo go obulame, yaátugaambila íichwe. ");
INSERT INTO zin_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Náho besiichwe enkúlu, bakáanga kumukoondookela Musa. Bakamubyéeda, nibeegoónga omu miganya yáabo kusuba Miísiri. ");
INSERT INTO zin_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Baámugaambila Haruni, ‘Otukolele ebisusano bya bamúungu, éebyo bilaatweébeembeléla. Ha nsoonga Musa, ogu ayaatweébeembelíile kuluga omu nsi ya Miísiri, titukumanya amagaambo áago agaámugweela!’ ");
INSERT INTO zin_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Obwo nibwo obuchilo bakakola echisusano éecho chilikususana ne enyána ye ente. Baázisoholeza ebitáambo, no kukola amazenyi habwe echiintu éecho beekoliíle ha mikóno yáabo boónyini! ");
INSERT INTO zin_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ha bwéecho Múungu yaábatega omugoongo, yaábaleka balamye izóoba, okwéezi, ne enyenyéezi zo omu igulu, nko óokwo byaayaandikilwe omu chitabu cha ababáasi, ‘Íimwe Abaiziraeli, obuchilo mweekeele omu nsi yo obwoóma muno ha myáaka makúmi aána, ngási, mukaba nimuumbaagila íinye ebituungaánwa mubóne kuúnsoholeza ebitáambo? Mmahi! ");
INSERT INTO zin_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Íimwe mukaba nimwiimucha iheéma lya múungu weenyu Moloki, ne enyenyéezi za múungu weenyu Refani. Ebisusano éebyo mweékoliile, no kubilamya. Ha bwéecho, ndyaábakola mube enkwáate, mulyaátwáalwa éensi za hala bwooli, no óobu kutaámbuka éensi ya Babéeli.’” ");
INSERT INTO zin_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stefano yaázeendelela kugaamba, “Óokwo omu nsi yo obwoóma muno, besiichwe enkúlu bakaba beene iheéma ha kugaamba obubona bwa Múungu. Múungu akaba amulagiile Musa alikole iheéma aha nsuso éezo Múungu akamwoóleka. ");
INSERT INTO zin_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kahaabaliile, besiichwe enkúlu bakaliínaankula no kweéheeleleza iheéma eli omuli boónyini kuhicha abeébeembeliilwe na Yoshua. Nábo baáliléeta omu nsi éezo baáyakile kuluga ha Abanyamahaánga. Abaantu aba Múungu akababiinga omu méeso gáabo. Iheéma lyaásigala omuli ezo nsi yáabo kuhicha obuchilo bwo omukáma Daudi. ");
INSERT INTO zin_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi óogwo akazililwa embabazi ya Múungu, náwe akamusaba amukuúndile abone kumwoómbekela obwiikalo Múungu wa Yakobo. ");
INSERT INTO zin_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Náho omwoómbeki we éenzu ezo akaba ali omukáma Selemani. ");
INSERT INTO zin_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“No óobu bityo, Múungu Óogwo Ali Olugulu ya Byóona, káandi takutúula omu nzu éezo ezoombekilwe ne emikono ya abaantu kwoónka. Ni nko omubáasi akagaamba, ");
INSERT INTO zin_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Omukáma Múungu agaámba aáti, igulu, niho echitébe chaanze cho obutégeki, ne éensi, niho ahaantu haanze ho kúta amagulu gaanze. Óobu, nimuunyoombekela nzu chi? Nali ahaantu haanze ho kuhuúmula ni nkáhi? ");
INSERT INTO zin_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ebi byóona, ngási tíwe íinye nyini óogwo naabihaangile?’” ");
INSERT INTO zin_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stefano yaázeendelela kugaamba, “Íimwe mwiina ihagi! Emiganya yáanyu na amatwi gáanyu ni nka ago aga abagome! Íimwe ni nka besíimwe enkúlu. Ebilo byóona nimumwaánga Omwooyo Mutakatíifu! ");
INSERT INTO zin_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ngási, heena omubáasi no óobu oómo ogu batalamwaágaléeze? Bakabéeta no óobu ababáasi abo kala bakaba nibagaámba kwiiza kwo Ogwo Omugololoke! No ogu niwe oliinya óogwo íimwe mukamunóba, mwaámwíita! ");
INSERT INTO zin_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mbwéenu, íimwe mukeenaankula echilagilo cha Múungu, echaasohweezwe ha muháanda gwa bamaléeka boómwe, no óobu bityo timulachikoondookíile.” ");
INSERT INTO zin_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Obuchilo Balusiingo áabo ba Abayahudi kábaahuliile amagaambo áago ga Stefano, baásaaya bwooli, baámuseela améeno ha chiniga. ");
INSERT INTO zin_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Náho Stefano ayizwiile obuhicha bwo Omwooyo Mutakatíifu, yaánoonkolela améeso olugulu omu igulu, yaábona ikuzo lya Múungu, na Yeézu ayemeeliile olubazu lwo obúlyo lwa Múungu. ");
INSERT INTO zin_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Aho yaágaamba, “Muléebe! Niimbóna igulu lyaáchiinguka, no Omutábani wo Omuuntu ayemeelíile olubazu lwo obúlyo lwa Múungu!” ");
INSERT INTO zin_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Aho balusiingo abo ba Abayahudi kábaahuliile ago baátéela eyoombo, nibazibika amatwi gáabo ha mikóno yáabo. Baámwiilukiilila Stefano hamo, baámukwáata, ");
INSERT INTO zin_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","baámusohoza ahéelu yi iboma, baábaanza kumuhoonda na amabáale. Nábo baalubona bakazúula ebebo, baágaleka héehi no omusígazi izíina lyoómwe Sauli. ");
INSERT INTO zin_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Obuchilo baabeele nibamuhoónda Stefano na amabáale, yaásaba aáti, “Omukáma Yeézu, oyinaánkule omwooyo gwaanze!” ");
INSERT INTO zin_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mala yaáteela ebizwi, yaálila ahi iláka liháango omu kugaamba aáti, “Mukáma, oteekala nácho echiheno echi!” Káyaabeele yaámazile kugaamba ebyo, yaáfwa. Sauli náwe akabona nka nikwo, echigaambo cho kumwíita Stefano yaakuundileene nácho. ");
INSERT INTO zin_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Kábaabalíile abakwaáta abo abalikumwiíkiliza Múungu baámuziika Stefano no kumwaálamila bwooli. Echilo éecho baamwiísile Stefano, abeekiliza be ekelezia ya Yeruzaléemu baábaanza kwaágalazwa bwooli. Abeekiliza bóona baálaluka, baásaambaalila omu nsi za Yudea na Samaria. Entumwa za Yeézu boónka nibo abasígeele Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sauli náwe yaábaanza kusiingaalicha ekelezia. Weényini yaaba naatáaha buli nzu, naabatwaála abakwaáta na abakázi lwa amáani, no kubachiíngila omu ibóhelo. ");
INSERT INTO zin_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Abo beekiliza abasaambeele, baaba nibabeegesa abaantu Empola Nzima za Yeézu buli haantu áaho baabeele nibazeénda. ");
INSERT INTO zin_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo náwe yaázeenda omu iboma límo lya Samaria, yaábaanza kubaátulila abaantu bo okwo empola za Masihi. ");
INSERT INTO zin_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Abaantu beenzi bakaba nibamuhuliiliza aha bweétegeeleza, nibahulila no kuleeba emanyiso éezo akaba naakola. ");
INSERT INTO zin_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Akaba naabiínga amazimu kuluga omu baantu beenzi, nigabalugaho kunu nigateéla empámo. Akaba naabachíza beenzi áabo bakaba bali enziíngami na abalageele emibili. ");
INSERT INTO zin_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ha bwéecho abaantu bo omu iboma éelyo bakaba beena amanulilwa maháango. ");
INSERT INTO zin_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Omu iboma elyo, hakaba heena omuhike oómo, izíina lyoómwe Simoni. Aha mwáanya mula, Simoni akaba naabasobéza abaantu bo omu nsi ya Samaria ha kukola obuhike, naayebuga nka nikwo weényini no omuuntu mukúlu. ");
INSERT INTO zin_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Abaantu bóona, abato na abakúlu, bakaba nibamuhuliiliza ha kweétegeeleza nibagaamba, “Ogu niwe obuhicha bwa Múungu óogwo alikwéetwa Obuhicha Bukúlu!” ");
INSERT INTO zin_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Abaantu áabo bakamweekomya bátyo habwo kuba akabasobeza ha mwáanya mula ne ebisobezo byoómwe. ");
INSERT INTO zin_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Náho obuchilo abaantu kabaamwiikiliize Filipo, naaboolekeelela Empola Nzima zo obukáma bwa Múungu na habwi izíina lya Yeézu Kristu, baábatizibwa, abakwaáta hamo na abakázi. ");
INSERT INTO zin_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na weényini Simoni yaámwiikiliza Yeézu, yaábatizwa, yaaba yaákwaátaangana hamo na Filipo buli haantu. Obuchilo yaabweene emanyiso na amaleeba áago Filipo akaba naakola, yaásobelwa. ");
INSERT INTO zin_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Okwo Yeruzaléemu, entumwa kábaahuliile nka nikwo abaantu ba Samaria beekiliza echigaambo cha Múungu, baásiindika Peétero na Yohana kuza hali abo. ");
INSERT INTO zin_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kábaahikile, baábasabila abaantu abo babone kumwiínaankula Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kuba, Omwooyo Mutakatíifu akaba atákatuukile no óobu hali oómo wáabo. Abo bakaba babatiziibwe kwoónka ahi izíina lyo Mukáma Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peétero na Yohana bakaba nibabateélaho emikono yáabo aha lugulu ya abeekiliza abo, nábo beenaánkula Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni, obuchilo yaabweene nka nikwo abaantu beenaánkula Omwooyo Mutakatíifu aha kutéebwáho emikono ze entumwa, yaábaha Peétero na Yohana empilya, naabagaambila, ");
INSERT INTO zin_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Muúmpe neenye obuzizi obu, mbone buli muuntu óogwo ndaámutéelaho emikono yaanze, ayanaánkule Omwooyo Mutakatíifu.” ");
INSERT INTO zin_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Náho Peétero yaámusubiza, “Empilya zaawe zisiingaálike hamo neewe habwo kuba nooteekuza obuhicha bwa Múungu nibuboneswa aha mpilya! ");
INSERT INTO zin_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Íiwe, toyina mubalo nali omugabo gwoóna gwóona omu chigaambo echi cha Múungu habwo kuba omuganya gwaawe ti gugololokile omu méeso ga Múungu. ");
INSERT INTO zin_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bityo, mazima lekela obufu bwaawe, osabe Omukáma. Lúundi alaálamula kukuganyila habwe ensoonga mbi omu mwooyo gwaawe. ");
INSERT INTO zin_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kuba niindéeba íiwe, nka nikwo oyizwiile ichubi liháango ne ebiheno byaawe nibikubóha.” ");
INSERT INTO zin_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni yaásubya, “Íimwe, muunsabile ha Mukáma, kuba chitáambaho no óobu echigaambo chimo omuli ago gi mulikugaamba!” ");
INSERT INTO zin_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Obuchilo Peétero na Yohana kabamazile okwaátula kwáabo no kubeégesa abaantu bo okwo echigaambo habwo Omukáma Yeézu, baábaanza oluzeendo lwáabo kusuba Yeruzaléemu. Baálabila omu migoongo míinzi za Abasamaria niboolekeelela abaantu Empola Nzima ezo. ");
INSERT INTO zin_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Maléeka wo Omukáma akamugaambila Filipo, “Yimuka, ozeénde ihaándagazi lyo kwoólekela olubazu lwa nyakaziinzakazi, elilikulugiilila Yeruzaléemu no kugolomoka kuza Gaza.” Ihaándagazi éeli likaba nililabila omu nsi yo obwoóma. ");
INSERT INTO zin_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bityo Filipo yaalugáho aho. Obuchilo akaba ali omu ihaándagazi, yaábugana no omukúlu oómo we éensi ya Ethiopia, ogu akaba akonilwe. Omukúlu óogwo akaba ali omwiímeelelezi mukúlu we ensabo ya Kaandake, ali omukámakazi wa Ethiopia. Akaba aziile Yeruzaléemu kumulámya Múungu. ");
INSERT INTO zin_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Óobu akaba naasuba omúka, ayikeele omu igáali lyoómwe lyo kukweeswa ne efaláasi, ali omu kusoma echitabu cho omubáasi Isaya. ");
INSERT INTO zin_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Omwooyo Mutakatíifu yaámugaambila Filipo, “Zeénda bwaangu oyilile ahi gáali elyo, ozeendáne nályo.” ");
INSERT INTO zin_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Niho Filipo yaáliilukiilila, yaalihikáho. Yaámuhuliiliza ogwo mukúlu ali omu kusoma omu chitabu cho omubáasi Isaya, yaámubúuza, “Mbwéenu, amagaambo áago olikusoma, noogasoomboókelwa?” ");
INSERT INTO zin_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Náwe yaámusubiza, “Niinhicha aánta kusoombookelwa, obuchilo tihaliho omuuntu wo kuúnsoomboolela ago?” Bityo, yaámunyegeza Filipo ahaname igáali, ayikale hamo náze. ");
INSERT INTO zin_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Amaandiko Matakatíifu áago akaba naasóma omukúlu ogwo, nigo aga: “Akatwáalwa nke entaama elikuzeenda kubáagwa, na nko omutaámbwa okwo gulikweésiza obuchilo nigunogolwa amooya, bityo nyini talagaambile echigaambo choóna chóona. ");
INSERT INTO zin_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bakamugoola no kumwíima amazima goómwe obuchilo bwo omuchwaáziiko. Noóha óogwo alaahicha kuhooyela empola zo oluzáalo lwoómwe? Kuba obulami bwoómwe bukeehwáho omu nsi.” ");
INSERT INTO zin_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ogwo omukúlu akonilwe yaámubúuza Filipo, “Niinsaba ongaambile, amagaambo ago go omubáasi na habwo oóha? Na ha bwoómwe weényini, nali habwo omuuntu oóndi?” ");
INSERT INTO zin_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ahonyini Filipo yaábaanza na amagaambo áago nyini ga Amaandiko Matakatíifu, yaázeendelela kumusoomboolela Empola Nzima za Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Obuchilo bakaba nibazeénda omu muháanda, baáhika ahaantu ahaabeele heena améenzi. Ogwo omukúlu akonilwe yaámugaambila Filipo, “Léeba, aha heena améenzi! Heena chiintu chi cho kuunyaángila ndeke kubatizwa?”  ");
INSERT INTO zin_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo yaámugaambila, “Koólaamwiíkiliza Yeézu Kristu aha muganya gwaawe gwoóna, wakaáhicha kubatizwa.” Náwe yaámusubiza, “Niinyikiliza nka nikwo Yeézu Kristu ni Mutábani wa Múungu.” ");
INSERT INTO zin_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ahonyini yaálagila igáali liimeelezwe. Niho bóona bábili baátúuka kuluga omu igáali, baátaaha omuli ago méenzi, náwe Filipo yaámubatiza. ");
INSERT INTO zin_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Obuchilo nibalugamo omu méenzi, ahonyini Omwooyo gwo Omukáma gwaámusapula Filipo. Omukúlu ogwo talamubwéene káandi, yaázeendelela no oluzeendo lwoómwe ali omu kunulilwa. ");
INSERT INTO zin_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Náho Filipo yeesaanga yaáhikile omu muzihwa gwa Azoto, na yaázeendelela kulabila omuli buli muzihwa gwo okwo naabaátulila abaantu Empola Nzima kuhicha akahika omu iboma lya Kaizáaria. ");
INSERT INTO zin_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Omwáanya ogwo, Sauli akazeendelela na amatiinisa goómwe go kwíita abaheémba bo Omukáma. Yaamuzáho omugabe omukúlu, ");
INSERT INTO zin_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","yaámusaba amuhe enyaandiko zo kumumanyisa, azeénde názo omu masomelo ga Múungu go omu muzihwa gwa Damaásiko. Empapula éezo zimwiikililize nka nikwo, kaálaasaanga okwo omuheémba weéna wéena we embága elikwéetwa Omuháanda, bali abakwaáta nali abakázi, ababohe no kubaléeta Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Niho Sauli yaázeenda Damaásiko. Káyeeliliize omu muzihwa, ahonyini omwaanga muháango kuluga omu igulu gwaámumweekela enkasi zóona. ");
INSERT INTO zin_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Yáagwa ahaansi, yaáhulila iláka nilimubuúza, “Sauli, Sauli! Ha bwaáchi noonyagalaza?” ");
INSERT INTO zin_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli yaábúuza, “Íiwe Mukáma, íiwe oli oóha?” Yaámugaambila, “Íinye níinye Yeézu, ogu íiwe olikwaágalaza. ");
INSERT INTO zin_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Óobu, oyimeelele! Zeénda otaahemo omu iboma, omwo noogaambilwa áago ohikiiliilwe okole.” ");
INSERT INTO zin_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Abaantu abo abaabeele nibazeénda hamo na Sauli baáyemeelela beésiíze chée! Habwo kuba nábo bakalihulila elyo iláka, náho tibalabweene muuntu weéna wéena. ");
INSERT INTO zin_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli yeemukaho ahaansi, yaáyemeelela, yaáhuumbulula améeso goómwe, náho talahikize kuleeba chiintu. Abo bazeenzíbe baákwáata omukonógwe ha kumuhabula, baamutaashamo omuli Damaásiko. ");
INSERT INTO zin_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yeekala omwo ha bilo bísatu, talahikize kuhwéeza, kulya choóna chóona, nali kunywa. ");
INSERT INTO zin_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Okwo Damaásiko, hakaba heena omuheémba oómo wa Yeézu, izíina lyoómwe Anania. Omukáma yaámweeta Anania omu meezaho, “Anania!” Náwe yaáyétabila, “Kaláme, Mukáma.” ");
INSERT INTO zin_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Omukáma yaámugaambila, “Óobu zeénda omu nzu yo mwa Yuda, éezo eli aha muháanda ogulikwéetwa Ogugololokile. Obuulilize omwo omuuntu óogwo ayaaluga omu muzihwa gwa Tarso, izíina lyoómwe naayétwa Sauli. Óobu naasába Múungu. ");
INSERT INTO zin_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Náwe yaabwéene ameezaho. Omu meezaho ago, akabona omukwaáta izíina lyoómwe Anania naatáaha omu nzu éezo alimo weényini, naátáho emikono ha lugulúye, kuba abone kuleeba káandi.” ");
INSERT INTO zin_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Náho Anania yaágaamba, “Mukáma, abaantu beenzi baangaambíile empola zo omuuntu ogwo na nka nikwo yaábakoliile ebíbi abatakatíifu baawe okwo Yeruzaléemu! ");
INSERT INTO zin_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","No óobu ali aha, ayina obuhicha kuluga ha bakúlu ba abagabe ba Múungu abakwáate bóona abo abalikusaba ahi izíina lyaawe.” ");
INSERT INTO zin_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Náho Omukáma yaámugaambila Anania, “Zeénda kwoónka! Omuuntu ogwo, mmutoolize ábe omuhálila waanze, abone kumanyisa izíina lyaanze ha Abanyamahaánga, ha bakáma báabo, no óobu aha Baiziraeli. ");
INSERT INTO zin_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Íinye nyini niimwoolekeelela nka nikwo ni lwaampaka ayagalale bwooli habwi izíina lyaanze.” ");
INSERT INTO zin_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ha bwéecho, Anania yaázeenda, yaátaaha omu nzu ezo. Yaatáho emikono yoómwe aha lugulu ya Sauli, yaámugaambila, “Mwiikiliza muzeenzi waanze Sauli, Omukáma Yeézu ayaakweésuulukiize omu muháanda obuchilo okaba nooyiza aha. Omukáma óogwo yaánsiíndika hali íiwe, obóne káandi kuhweeza, mala oyizuzwe obuhicha bwo Omwooyo Mutakatíifu.” ");
INSERT INTO zin_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ahonyini ebiintu nka amagaamba byaálagala kuluga omu méeso go mwa Sauli, yaáhicha kuleeba káandi, yaáyemeelela, yaábatizwa. ");
INSERT INTO zin_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mala yaálya ebyookulya, yaazila amagala káandi. Ha bilo bíche, Sauli akeekala hamo na abaheémba ba Yeézu omuli Damaásiko. ");
INSERT INTO zin_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ahonyini yaábaanza kuboólekeelela omu masomelo ga Abayahudi, naabasoomboólela empola za Yeézu, nka nikwo weényini niwe Mutábani wa Múungu. ");
INSERT INTO zin_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Abaantu bóona abo abaamuhuliile Sauli baásobelwa bwooli, beébuuza, “Omuuntu ogu, tíwe óogwo akaba naayagalaza abaantu abalikusaba omu izíina lya Yeézu okwo Yeruzaléemu? Káandi tíwe ogu ayeezile aha abakwáate abaantu áabo abatwáale aha bakúlu ba abagabe ba Múungu?” ");
INSERT INTO zin_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Náho Sauli akaba naaguma kubona amagala go kweégesa abaantu. Káandi, akaba naabamanyisa Abayahudi ba Damaásiko aha Maandiko Matakatíifu nka nikwo Yeézu niwe Masihi, kuhicha baálemwa kumuhakanisa. ");
INSERT INTO zin_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kábyaabeele ebilo bíinzi byaáhiíngwiile, Abayahudi baákola okweéhanuuza kwo kumwíita Sauli. ");
INSERT INTO zin_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Omu chilo na nyemisana Abayahudi baaba nibamuteébeleza omu maleembo go omuzihwa ogwo, kuba kaálaasohola babone kumwíita. Náho Sauli yaáháabwa empola zo obweéhanuuzi obwo. ");
INSERT INTO zin_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bityo, abaheémba boómwe baámutwáala omu chilo, baámutuucha ali omu chitukulu aha kulabila ahaantu aheene omwáanya omu lukuta. ");
INSERT INTO zin_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli akasuba Yeruzaléemu. Obuchilo obwo káyaahikile, yaaba naaleengesa kukwaátaangana hamo na abaheémba ba Yeézu. Náho áabo bóona bakamutiína habwo kuba bakaba batakumwiíkiliza nkokwo yaabeele omuheémba wa Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Náho Barinaba yaámutwáala Sauli aha ntumwa za Yeézu. Yaábagaambila nkokwo Sauli akabona Omukáma omu muháanda ali omu luzeendo kuza Damaásiko, na nkokwo Omukáma yaáhooyile náwe. Káandi, yaábagaambila nka nikwo aha kugima yaáyolekeeliile abaantu bo okwo ahi izíina lya Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ha bwéecho Sauli yeekala hamo na abaheémba ba Yeézu naataahámo no kusohola omuli Yeruzaléemu no okwoólekeelela abaantu empola ha kugima ahi izíina lyo Omukáma. ");
INSERT INTO zin_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Akaba naahóoya no kuhakana na Abayahudi abo abagaambile Echiyunani, náho boónyini bakaba nibaloónda kumwíita. ");
INSERT INTO zin_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Abeekiliza bazeenzi béetu, kábaamanyile empola ezo, baámuseéndekeleza kuhicha omu muzihwa gwa Kaizáaria, no kuluga okwo, baámusiíndika azeénde okwo Tarso. ");
INSERT INTO zin_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mála, ekelezia ekaba eyina obuhóolo enkasi zóona zo omuli Yudea, Galiláaya, na Samaria. Abeekiliza ba buli haantu bakazeendelela kukomeela no kutiimbibwa omuganya no Omwooyo Mutakatíifu. Káandi, abeekiliza abo baaba nibamweeganya Omukáma ahi isima, no okukanya kwáabo kukazeendelela kwoongela. ");
INSERT INTO zin_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peétero káyaabeele naazeénda buli haantu, chilo chimo akahika kubayeélela abatakatíifu áabo bakaba nibatuúla Lida. ");
INSERT INTO zin_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Okwo, yaásaanga omuuntu oómo omukwaáta, alikwéetwa Ainea. Ogwo akaba alageele omubili, alyaamile aha chitabo ha mwáanya gwe emyáaka munáana. ");
INSERT INTO zin_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peétero yaámugaambila, “Ainea, Yeézu Kristu naakuchíza. Yimuka! Oyale echitabo chaawe.” Ahonyini Ainea yaáyemeelela! ");
INSERT INTO zin_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kahaabaliile, abaantu bóona abo abaatwiile omuli Lida, no omu iholoola lya Saroni, baámubona Ainea, baáhiinduka kumwiíkiliza Omukáma Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Omu muzihwa gwa Yopa hakaba heena omukázi oómo, ali omuheémba wa Yeézu, izíina lyoómwe Tabita. (Omu lulími lwe Echiyunani, izíina éeli ni Dorkasi.) Weényini akaba asuumbuusa abahabi, káandi akaba akola ebikolwa bizima. ");
INSERT INTO zin_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ebilo ebyo akalwáala, yaáfwa. Abaantu baáyoza omubili gwoómwe, baágubyaámíka omu chiseenge echoombekilwe olugulu ye éenzu. ");
INSERT INTO zin_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Obuchilo obwo abaheémba bakahulila nka nikwo Peétero akaba ali Lida, baábasiíndika abakwaáta bábili hali Peétero, habwo kuba Lida ekaba eli héehi na Yopa. Abo baámugaambila Peétero, “Nitukusaba, oyize owéetu bwaangu!” ");
INSERT INTO zin_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peétero yeémuka, yaázeenda hamo nábo. Obuchilo kabaahikile, baámutwáala omu chiseenge echoombekilwe olugulu ye éenzu. Omwo, abakázi bóona abakaambwiile baámuzoongoloka nibachula. Baámwooleka enkaanzu, ne ebizwáalo ebíindi éebyo Dorkasi akaba abaziilila obuchilo achili mwooyo. ");
INSERT INTO zin_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mala Peétero yaábasohoza bóona ahéelu, yaáteela ebizwi, yaámusaba Múungu. Mála yaáguhiindukila ogwo mutuumbi, yaágaamba, “Tabita, yemeelela!” Tabita yaáhuumbulula améeso goómwe, yaámuleeba Peétero, mala yeékala aha chitabo. ");
INSERT INTO zin_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peétero yaámukwáata omukóno, yaámuhweela kwiimeelela. Yaábéeta abo bakázi abakaambwiile na abatakatíifu abáandi, yaábooleka Tabita, nka nikwo yaábeele mwooyo. ");
INSERT INTO zin_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Empola ze ebyo zaásaambaala bwooli okwo hóona omuli Yopa, abaantu beenzi baámwiíkiliza Omukáma. ");
INSERT INTO zin_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Mala Peétero yeekala aho Yopa ebilo bíinzi, naatuúla omu nzu yo omusisiimi we eémpu, izíina lyoómwe Simoni. ");
INSERT INTO zin_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Omu muzihwa gwa Kaizáaria hakaba heena omwiímeelelezi wa abalwaanila ngoma, izíina lyoómwe naayétwa Kornelio. Ogwo akeémeelelela abalwaanila ngoma igana omu mbága éezo yaayesilwe Embága ya Abalwaanila Ngoma ye Echiitalia. ");
INSERT INTO zin_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Weényini akaba naamukoondoókela no kweétaho hali Múungu, hamo na abaantu bóona omúka yoómwe. Akaba naamusaba Múungu buli mwáanya, no kubaha ebigabo abaantu abahabi. ");
INSERT INTO zin_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Chilo chimo nke esáaha mweenda zíti za nyemisana, Kornelio akabona ameezaho. Omu meezaho ago, yaábona maléeka wa Múungu naamwiízáho. Maléeka ogwo yaámugaambila, “Kornelio!” ");
INSERT INTO zin_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Náwe Kornelio yaámukomela améeso ogwo maléeka ha butíini, naamubuúza, “Mukáma, ni chiíha?” Ogwo maléeka yaámusubiza, “Okusaba kwaawe na nka nikwo olikuzuna abahabi byaáhika omu igulu no kuba obwiizukizo omu méeso ga Múungu. ");
INSERT INTO zin_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Óobu, osiíndike abaantu bazeénde omu muzihwa gwa Yopa, bamuléete Simoni óogwo alikwéetwa Peétero. ");
INSERT INTO zin_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Naatuúla nko omuzenyi omu nzu ya Simoni, omusisiimi we eémpu. Éenzu yoómwe éeli aha ngeégeelo ye enziba.” ");
INSERT INTO zin_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Obuchilo maléeka yaámazile kugaambila Kornelio ago, yaalugáho. Kornelio yaáyéta abazáana bábili, no omulwaanila ngoma oómo omu bahwéezi boómwe óogwo alikweétáho hali Múungu. ");
INSERT INTO zin_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornelio yaábasoomboolela góona ago óokwo gaabaho, yaábasiíndika bazeénde Yopa. ");
INSERT INTO zin_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nyeéncha eémo, obuchilo abo baantu básatu bakaba beéliliza iboma lya Yopa, Peétero yaáhanama olugulu ye éenzu kumusaba Múungu. Ekaba eli esáaha mukáaga zíti za nyemisana. ");
INSERT INTO zin_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Yaálumwa enzala, yeégoonga kulya. Obuchilo bakaba nibamuloongeza echookulya, yaátwaalilizibwa no kubona ameezaho. ");
INSERT INTO zin_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Omu meezaho omwo yaábona igulu lyaáchiinguka, ne echiintu nki isuúka liháango elikwaasilwe embazu zaályo iína, likaba nilituúchwa ahaansi kuhicha ahi itaka. ");
INSERT INTO zin_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Omugati yaályo hakaba heenamo buli lugaanda lwe enyameéswa ne ebituungaánwa ebiina amagulu aána, enyameéswa éezo ezilikwaázula ahaansi, ne enyonyi. ");
INSERT INTO zin_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aho Peétero yaáhulila iláka, nilimugaambila, “Peétero, yimeelela! Baága no okulya!” ");
INSERT INTO zin_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peétero yaámugaambila, “Mmahi, Mukáma! Tiínkalyaga mahi echookulya choóna chóona éecho echili omuzilo nali echilofo!” ");
INSERT INTO zin_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Elyo iláka lyaámugaambila káandi Peétero, “Otaákubyeeta omuzilo ebiintu éebyo Múungu yaáyelize.” ");
INSERT INTO zin_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Echigaambo echi chaásubiililwa entúlo isatu, niho elyo isuúka lyaásubibwa omu igulu. ");
INSERT INTO zin_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Obuchilo Peétero akaba achali acheébuuza habwe ensoonga ya ameezaho áago yaabweene, abaantu abo básatu áabo bakasiindikwa na Kornelio baáyemeelela ahéelu yo omulyaango gwe éenzu yoómwe ezo. Bakaba baábuuliliize éenzu ya Simoni, nikwo baázimanyile éenzu niyo ezi. ");
INSERT INTO zin_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Baátéela hóodi no kubúuza, “Ngási, heena omuzenyi omu, óogwo izíina lyoómwe ni Simoni alikwéetwa Peétero?” ");
INSERT INTO zin_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","No obuchilo Peétero akaba naateekuza ago meezaho, Omwooyo Mutakatíifu gwaámugaambila, “Huliiliza! Heena abaantu básatu aha, nibakuloondela. ");
INSERT INTO zin_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bityo Otuúke ahaansi, mala ozeénde hamo nábo. Otaákuba no kutahwa tahwa habwo kuba íinye níinye naábasiindika hali íiwe.” ");
INSERT INTO zin_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peétero yaátuuka ahaansi, yaábagaambila abo baantu, “Íinye níinye óogwo mulikuloondela. Ha bwaáchi mwéeza?” ");
INSERT INTO zin_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Baámugaambila, “Twaásiindikwa no omwiímeelelezi oómo wa abalwaanila ngoma, izíina lyoómwe naayétwa Kornelio. Óogwo aheébwa isima liháango na abaantu bóona abi ihaánga lya Abayahudi, weényini agomookela Múungu, mále no omuuntu omugololoke. Maléeka omutakatíifu wa Múungu yaámulagila akunyégeze omu nzu yoómwe, abone kuhuliiliza empola éezo olaamugaambila.” ");
INSERT INTO zin_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Niho Peétero yaábeénaankula no kubanyegeza omu nzu, babe abazenyi boómwe. Nyeéncha eémo, Peétero hamo na abazenyi, na abeekiliza báche bazeenzi béetu bo kuluga Yopa, baaba baábaanza oluzeendo. ");
INSERT INTO zin_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Echilo echaakulaatiilého, baba baáhika omu muzihwa gwa Kaizáaria. Baásaanga Kornelio yaákoba kobize badugúbe, hamo na abanywáani boómwe ba héehi, baliho babaliindiliile. ");
INSERT INTO zin_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Obuchilo Peétero naataahámo, Kornelio akeeza yaámwaanaankula, yaáteela ebizwi omu méeso goómwe no kwíinama ahaansi kumuha ikuzo. ");
INSERT INTO zin_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Náho Peétero yaámweemeeleza naamugaámbila, “Oyimeelele! Íinye ndi omuuntu kwoónka nkeewe!” ");
INSERT INTO zin_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Niho Peétero na Kornelio baátaaha omu nzu kunu nibahóoya, baásaanga abaantu beenzi bakobile omu nzu. ");
INSERT INTO zin_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Peétero yaábagaambila, “Íimwe nimumanya kuzima nka nikwo no omuzilo íichwe Abayahudi kusiímbahala na Abanyamahaánga agáandi. No óobu kubayeélela, titukukuúndilwa. Náho Múungu yaányoleka nka nikwo ntaákuteekuza omuuntu weéna wéena nkokwo no omulofo, nali no omuzilo. ");
INSERT INTO zin_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Niyo ensoonga obuchilo nimuunyeta, neeza ntéena kweéganya. Mbwéenu, ni chigaambóchi éecho mwaanyetela?” ");
INSERT INTO zin_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelio yaámugaambila, “Ebilo bísatu éebyo bihiingwíile, mbeele ndi omúka niimmusaba Múungu, esáaha nke ezi, ensoonga esáaha mweenda nyemisana. Ahonyini naábona omuuntu ayemeeliile omu méeso gaanze ayechumile ebizwáalo biluunzi. ");
INSERT INTO zin_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yaángaambila, ‘Kornelio, Múungu yaáhulila okusaba kwaawe, naayizuka nkokwo olikuzuna abahabi. ");
INSERT INTO zin_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ha bwéecho, óobu osiíndike abaantu omu muzihwa gwa Yopa, bamuléete Simoni óogwo alikwéetwa Peétero. Naatuúla nko omuzenyi omúka ya Simoni, omusisiimi we eémpu. Éenzu yoómwe éeli aha ngeégeelo ye enziba.’ ");
INSERT INTO zin_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Niyo ensoonga nsiindikile abaantu hali íiwe bwaangu, neewe waákola kuzima kwíiza. Óobu twéena tuli omu méeso ga Múungu, tubone kuhulila buli chigaambo éecho Omukáma yaákulagila kutugaambila.” ");
INSERT INTO zin_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Aho Peétero yaágaambila abaantu abo aáti, “Óobu niho naámanya nka nikwo, mazima Múungu tazila obweendeza omu baantu! ");
INSERT INTO zin_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Naabakuúnda abaantu ba buli ihaánga áabo abalikumukoondookela, no kukola amazima omu méeso goómwe. ");
INSERT INTO zin_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nimusoomboókelwa empola éezo weényini akasiindika ha Baiziraeli. Babéele niboolekeelelwa Empola Nzima zo obuhóolo ha kulabila hali Yeézu Kristu. Ogu Yeézu niwe Omukáma wa abaantu bóona. ");
INSERT INTO zin_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Káandi nimusoomboókelwa amagaambo ago agagwiile omu nsi yóona ya Yudea. Gakabaandiza Galiláaya, obuchilo Yohana Omubatiza yaáyolekeeliile obubatizo. ");
INSERT INTO zin_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Múungu yaámutoólize Yeézu owa Nazaréeti ha kumwiítilila Omwooyo Mutakatíifu no obuhicha. Yeézu náwe akazeenda ahaantu hóona, naakola ebizima no kuchiza bóona áabo bakaba nibaagalazwa ni Isitáani, habwo kuba Múungu akaba ali hamo náze. ");
INSERT INTO zin_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Neechwe níichwe baalubona ba amagaambo góona áago Yeézu yaákozile omu nsi ya Abayahudi, na Yeruzaléemu. Bakamwíita ha kumubáamba aha musalaba, ");
INSERT INTO zin_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","náho Múungu akamuzoola echilo cha kásatu, yaámwooleka ha baantu. ");
INSERT INTO zin_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Talabweenwe ha baantu bóona, náho akabonwa hali baalubona áabo Múungu akaba yaátoolize kumubona, na baalubona abo nibo íichwe, áabo twaálíile no okunywa hamo náze káyaabeele yaázookile kuluga omu bafwíile. ");
INSERT INTO zin_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Akatulagila kwoólekeelela abaantu Empola Nzima, no kugaamba okwaátula nka nikwo weényini niwe ayaatooziibwe na Múungu, achwaaziíke abeene obulame na abáfwiile. ");
INSERT INTO zin_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Amaandiko ga Ababáasi bóona gagaamba okwaátula nko okwo habwa weényini, omuuntu weéna wéena óogwo alikumwiíkiliza naaganyilwa ebiheno byoómwe kulabila ahi izíina lya Yeézu.” ");
INSERT INTO zin_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Obuchilo Peétero akaba achaali naagaámba ebyo, bóona áabo bakaba nibamuhuliiliza, Omwooyo Mutakatíifu yaabeezamo. ");
INSERT INTO zin_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Abo Bayahudi abeésigwa áabo bakaba beézile hamo na Peétero, baákamaala bwooli kuleeba nkokwo Múungu yaáseesa obuhicha bwo Omwooyo Mutakatíifu ha Abanyamahaánga. ");
INSERT INTO zin_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kuba bakahulila abaantu abo nibagaámba omu ndími ezíindi nibamukúza Múungu. Aho Peétero yaágaamba, ");
INSERT INTO zin_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ngási heena omuuntu weéna wéena wo kwaángila abaantu aba bataákubatizwa aha méenzi? Beenaánkula Omwooyo Mutakatíifu nko óokwo neechwe twaámwiinaankwiile.” ");
INSERT INTO zin_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ha bwéecho Peétero yaábalagila nka nikwo babatizwe ahi izíina lya Yeézu Kristu. Niho baámusaba Peétero ayikale nábo aha bilo bíche. ");
INSERT INTO zin_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Entumwa za Yeézu na abeekiliza bazeenzi béetu abáandi bo okwo Yudea, baáhulila empola nka nikwo Abanyamahaánga nábo beekiliza echigaambo cha Múungu. ");
INSERT INTO zin_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ha bwéecho, obuchilo Peétero yaásubile Yeruzaléemu, Abayahudi abo baábaanza kumweéfuuza, ");
INSERT INTO zin_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nibagaámba, “Íiwe okataaha omu nzu eyina abaantu abatasázilwe amakóba no kulya ebyookulya hamo nábo!” ");
INSERT INTO zin_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Niho Peétero yaábaanza kubasoomboolela amagaambo góona nka nikwo óokwo byaabeelého, naagaámba, ");
INSERT INTO zin_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Chilo chimo nkaba ndi omu iboma lya Yopa niimmusaba Múungu, naátwaalilizibwa na kubona ameezaho. Omu meezaho ago, naábona echiintu nki isuúka liháango elyaabeele nilituúlwa ahaansi kuluga omu igulu, kunu embazu zaályo iína zikwaasilwe, nályo lyaátuukila aha mpelo yaanze. ");
INSERT INTO zin_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nkalikomela améeso kuzima, naábona enyameéswa ne ebituungaánwa byo omu nsi eza buli lugaanda ebiina amagulu aána, enyameéswa éezo ezilikwaázula, ne enyonyi. ");
INSERT INTO zin_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","“Niho naáhulila iláka niliingaambila, ‘Peétero, yimeelela! Baága no okulya!’ ");
INSERT INTO zin_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Naágaamba, ‘Mmahi, Mukáma! Tiínkalyaga mahi echookulya choóna chóona éecho chili omuzilo nali echilofo!’ ");
INSERT INTO zin_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Náho nkahulila káandi iláka elyo kuluga omu igulu, niliingaambila, ‘Otaákubyeeta omuzilo ebiintu éebyo Múungu yaáyelize.’ ");
INSERT INTO zin_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Echigaambo echi chaásubiililwa entúlo isatu, mala ebiintu ebyo byóona byaákweeswa kusuba káandi omu igulu. ");
INSERT INTO zin_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ahonyini abaantu básatu áabo abaasiíndikilwe kuluga Kaizáaria baáhika omu méeso ge éenzu éezo nkaba niinyikala. ");
INSERT INTO zin_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Omwooyo Mutakatíifu gwaángaambila nka nikwo nzeénde hamo nábo, ntaákuzila okutahwa tahwa. Ha bwéecho naázeenda nábo, na aba abeekiliza bazeenzi betu mukáaga bakazeenda neechwe hamo. Obuchilo twaázilemo omu nzu ya Kornelio, ");
INSERT INTO zin_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","yaátusoomboolela óokwo yaamubwéene maléeka omúka yoómwe, yaámugaambila, ‘Obasiíndike abaantu kuza okwo Yopa, bamwéete Simoni óogwo alikwéetwa Peétero ayize. ");
INSERT INTO zin_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ogwo niwe alaakugaambila empola, na ha kulabila empola ezo íiwe na abaantu bóona be eéka yaawe yóona nimuchuungulwa.’ ");
INSERT INTO zin_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Kanabaandize kubagaambila abaantu abo empola, niho Omwooyo Mutakatíifu yaabeezamo, nko óokwo yaatwiizileho ha bubaandizo. ");
INSERT INTO zin_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Neézuka echigaambo éecho Omukáma akatugaambila, ‘Yohana akabatiza abaantu aha méenzi, náho íimwe nimubatizwa aha Mwooyo Mutakatíifu.’ ");
INSERT INTO zin_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ha bwéecho obwo buhicha óobwo Múungu akatuha íichwe áabo tulikumwiíkiliza Omukáma Yeézu Kristu, nibyo ebyo nyini yaábaha nábo aba baantu. Mbwéenu! Íinye ndi oóha nsiingaangáne na Múungu?” ");
INSERT INTO zin_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Obuchilo Abayahudi abo kibaahuliile amagaambo ago, beésiza. Baámweésiingiza Múungu nibagaámba, “Kási, Múungu yaábaha obuhicha kulekela ebiheno byáabo Abanyamahaánga, babone obulame bwo obucha no obuchiile!” ");
INSERT INTO zin_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Abáandi ba abeekiliza áabo abasaambeele aha kwaágalazwa kwiingana no kwíitwa kwa Stefano, bakeelukila omu nsi ya Foonike, Kipro, na Antiokia. No okwo hóona, baaba nibagaamba empola za Yeézu ha Abayahudi boónka. ");
INSERT INTO zin_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Náho abeekiliza abáandi kuluga éensi ya Kipro no omu muzihwa gwa Kurene baázeenda Antiokia. Aba baábaanza kwoólekeelela Empola Nzima ezo zo Omukáma Yeézu no óobu ha Abanyamahaánga. ");
INSERT INTO zin_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","No obuhicha bwo Omukáma bukaba buli hamo nábo, na abaantu beenzi bwooli baámwiíkiliza no kumukulaatila Omukáma. ");
INSERT INTO zin_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Obuchilo kábaahuliile empola za abaheémba abo omuli Antiokia, ekelezia ya Yeruzaléemu yaámusiíndika Barinaba azeénde okwo. ");
INSERT INTO zin_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Obuchilo yaáhikile okwo, akabona nka nikwo Múungu yaábaha abaantu áabo embabazi zoómwe. Yaánulilwa bwooli, naabagumya emiganya bazeendelele ne ensoonga yo kuba abeésigwa ha Mukáma. ");
INSERT INTO zin_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barinaba akaba ali omuuntu ayetegeeliize na ayizwiile obuhicha bwo Omwooyo Mutakatíifu no kumwiíkiliza Múungu. No kukanya kwe embága ya abaantu bo Omukáma kwaáyoongela bwooli. ");
INSERT INTO zin_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mala Barinaba yaázeenda Tarso kumuloondela Sauli okwo. ");
INSERT INTO zin_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Obuchilo yaamubwéene, yaámuléeta aho Antiokia. Abo bábili beékala ne ekelezia okwo omwáaka gwóona, baaba nibeegesa abaantu beenzi bwooli habwa Yeézu. Aho omuli Antiokia nimwo abaheémba ba Yeézu bakabaanza kwéetwa Abakristu. ");
INSERT INTO zin_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Omu bilo ebyo, bakéeza omuli Antiokia ababáasi kuluga Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Oómo wáabo, izíina lyoómwe naayétwa Agabo, yaáyemeelela omu mukobo, yaágaamba obubáasi ha muháanda gwo Omwooyo Mutakatíifu nka nikwo enzala mpaango elyéeza omu nsi ezi yóona. Kahaabaliile, enzala éezo ekabaho omu buchilo Kaizáari Klaudio akaba naatégeka. ");
INSERT INTO zin_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ha bwéecho, abaheémba baálamula nka nikwo, buli oómo wáabo, kwiingana no obuhicha bwoómwe, asohoze choóna chóona habwo kubazuna abo beekiliza bazeenzíbe áabo bakaba nibatuúla Yudea. ");
INSERT INTO zin_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Baákola bátyo, baábaha Barinaba na Sauli engabilano ezo, babone kuzitwáala ha banyaampala be ekelezia yo okwo Yudea. ");
INSERT INTO zin_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Omu bilo ebyo, omukáma Herode yaábaanza kubaágalaza abeekiliza abáandi abe ekelezia. ");
INSERT INTO zin_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akalagila Yakobo mudugu wa Yohana ayitwe ha lubáadi. ");
INSERT INTO zin_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Obuchilo káyaabweene nka nikwo echikolwa echo chaábanulila Abayahudi, yaálagila na Peétero akwaátwe. Echi chikabaho obuchilo bwa amazenyi ge emikaate éezo etatiílwémo ituumbyo. ");
INSERT INTO zin_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Káyaamazile kumukwáata Peétero, Herode yaálagila ateébwe omu ibóhelo. Yaámuhikiiliza ha bipípi bina bya abalwaanila ngoma bana bána, babone kumweékomya. Akaba ayeenzile amuchwaáziike omu méeso ga abaantu echilo chikúlu cha Paásika kachilaaba chaáhwéele. ");
INSERT INTO zin_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bityo, Peétero akaba atiilwe omu ibóhelo, náho ekelezia ekaba neeyeéyomeleza bwooli kumusabila hali Múungu. ");
INSERT INTO zin_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Omu chilo cho kwiimukila echilo éecho Herode akaba yaálamwíile kumuchwaáziika Peétero, weényini akaba alyaamile ahagáti ya abalwaanila ngoma bábili, abohilwe ne eminyololyo ebili. Ahéelu yo olwíizi lwe ezo nzu, abalwaanila ngoma abáandi bakaba nibaheekomya. ");
INSERT INTO zin_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ahonyini yeesuululukizaho maléeka wo Omukáma yaáyemeelela ahaantu áaho Peétero akaba ali, omwaanga gwaáyaka omugati ye echiseenge echo. Maléeka yaamukoláho Peétero omu lubazu kumuhiinda, naamugaámbila, “Yimuka bwaangu!” Mále eminyololyo éezo akaba akomilwe Peétero omu mikono yaálagala ahaansi! ");
INSERT INTO zin_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Aho maléeka yaámugaambila, “Ozwaále ebizwáalo byaawe ne enkeeto zaawe.” Náwe Peétero yaákola aátyo. Maléeka yaámugaambila, “Zwaála ebebo yaawe, onkuláatile!” ");
INSERT INTO zin_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peétero yaámukulaatila ogwo maléeka, niboolekela ahéelu yi ibóhelo. Náho Peétero talamanyile nka nikwo ebikolwa ebyo byóona bya maléeka bikaba bili bya mazima, akaba naateekuza nka nikwo naabona ameezaho kwoónka. ");
INSERT INTO zin_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Peétero no ogwo maléeka bahiíngula ha balwaanila ngoma ba mbele, na ba kábili, baáhika aha lwiizi lwi isiinza lwi iléembo lyo kutaahilamo omu iboma. Olwiizi olwo lwaáchiinguka lwoónka, baásohola ahéelu yi ibóhelo. Baálibata omuháanda gúmo, ahonyini ogwo maléeka yaámuleka Peétero. ");
INSERT INTO zin_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Áaho Peétero káyaamanyile nka nikwo ago agaámugweela gaaba gatali ebiloosi, yaágaamba, “Óobu naámanya ha mazima, Omukáma yaánsiíndikiile maléeka woómwe. Yaánchuungwíile kuluga engalo za Herode, no kuluga omu mábi góona áago Abayahudi baabeele nibategeza kuunkolela.” ");
INSERT INTO zin_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Obuchilo Peétero káyaamanyile ebyo, yaázeenda ahaanzu ya Mariamu, nyina Yohana ayétwa Mariko. Omu nzu ezo, abeekiliza beenzi bakaba bakobile, nibamusaba Múungu habwa Peétero. ");
INSERT INTO zin_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peétero yaáteela hóodi aha lwiizi lwi iléembo lye éenzu éezo. Omuhalákazi oómo omuzaánakazi, izíina lyoómwe Roda, yeeza kuhuliiliza nka nikwo noóha. ");
INSERT INTO zin_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Obuchilo yaásoombookilwe iláka lya Peétero, yaánulilwa bwooli, yaásuba obutamuchiíngulila. Yaábagaambila bóona omu nzu, “Peétero ayemeeliile aha chisasi!” ");
INSERT INTO zin_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Abo baámubúuza, “Ngási waásala?” Náho ogwo muhalákazi yaákomeenteleza nka nikwo libeele lili iláka lya Peétero éelyo yaáhulila. Niho baámugaambila, “Mazima ogwo ni maléeka woómwe.” ");
INSERT INTO zin_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Omwáanya óogwo Peétero akaba naazeendelela kutéela hóodi ahi iléembo. Obuchilo kábaachiíngwiile iléembo, baámubona, baásobelwa muno. ");
INSERT INTO zin_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peétero yaáyemeeleza omukóno kubamanyisa beésize, yaábagaambila nkokwo Omukáma yaámusohoza kuluga omu ibóhelo. Niho yaábagaambila, “Empola ezi, mumugaambile Yakobo na abeekiliza bazeenzi béetu abáandi.” Mala Peétero yaalugáho aho, yaázeenda ahaantu aháandi. ");
INSERT INTO zin_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Káhaabeele omulucheelelélwa, okwo omu ibóhelo abalwaanila ngoma baaba no kutahwa tahwa kwíinzi bwooli habwa áago agaámugweela Peétero. ");
INSERT INTO zin_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herode yaálagila abalwaanila ngoma boómwe bamuloóndele Peétero bwooli, náho talabweenwe. Ha bwéecho, yaálagila abalwaanila ngoma áabo abaabeele nibamweekomya Peétero babuulilizwe. Obuchilo baábuzilwe cho kusubya, yaálagila beétwe. Káyaabaliile Herode yaalugáho aho Yudea, yaázeenda okwo Kaizáaria, yeekala okwo ha mwáanya. ");
INSERT INTO zin_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mbwéenu, Herode akaba asaayile bwooli ha baantu ba Tíilo, na ba Sidóoni. Ha bwéecho abaantu áabo baámuzeendela Herode aha nsoonga eémo kusaba nka nikwo babe no obuhóolo, habwo kuba omu mizihwa záabo bakaba babonesa ebyookulya kuluga éensi ya Herode. Baámukoóba kooba Bulasto, óogwo akaba ali omwiímeelelezi we éenzu yo omukáma Herode, akuundilane nábo omu méeso ga Herode. ");
INSERT INTO zin_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Echilo éecho omukáma Herode akaba atoólize kubonana nábo, yaázwaala ebizwáalo byoómwe bye chikáma, yeékala aha chitébe choómwe, yaágaamba ebigaambo omu méeso ga abaantu. ");
INSERT INTO zin_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Aho abaantu abo baábaanza kumweésiingiza, nibateéla eyoombo omu kugaamba, “Éeli tilyo iláka lyo omuuntu! Elyo ni iláka lya Múungu!” ");
INSERT INTO zin_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ahonyini, habwo kuba Herode talamuhéele Múungu ikuzo lyoómwe, maléeka wo Omukáma yaámuteela Herode aha ndwáala yo kulúmwa enzóka zo omuunda, yaáfwa. ");
INSERT INTO zin_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Echigaambo cha Múungu habwa Yeézu chikazeendelela kusaámbaala omu baantu, na abeekiliza baáyoongela bwooli. ");
INSERT INTO zin_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nábo Barinaba na Sauli kábaamazile okuheéleza kwáabo kwo kutwáala empilya ezitoolizwe aha beekiliza okwo Yeruzaléemu, baásuba Antiokia bali hamo na Yohana, alikwéetwa ahi izíina eliindi Mariko. ");
INSERT INTO zin_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Omu kelezia ya Antiokia bakaba bali ababáasi na abeégesa. Omuli abo akaba ali Barinaba, Simeoni alikwéetwa Nigeri, Lukio kuluga Kurene, Sauli, na Manaeni óogwo akalelelwa hamo no omukáma Herode. ");
INSERT INTO zin_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Obuchilo baabeele nibamulámya Omukáma no kuzila echisiibo, Omwooyo Mutakatíifu yaábagaambila, “Muuntoóleze Barinaba na Sauli aha bwe emilimo éezo naábeetela.” ");
INSERT INTO zin_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ha bwéecho, kábaamazile echisiibo no kumusaba Múungu, baabateeláho emikono yáabo hali Barinaba na Sauli, baábasiíndika bazeénde. ");
INSERT INTO zin_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barinaba na Sauli baágolomoka kuhika ha chaambo cha Selukia, habwo kuba bakaba baasiindikilwe no Omwooyo Mutakatíifu. Kuluga okwo baáyaambuka, baábuga ni itaanga kuzeenda Kipro. ");
INSERT INTO zin_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kábaahikile okwo omu iziinga, baázeenda, baáhika omu chaalo chilikwéetwa Salami, okwo baábaanza kwoólekeelela abaantu echigaambo cha Múungu omu masomelo ga Abayahudi. Bakaba bali hamo na Yohana Mariko, weényini akaba ali omuhweezi wáabo. ");
INSERT INTO zin_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kábaabeele baáyeéliile omu iziinga lyóona lya Kipro, niho baáhika Pafo. Aho baábugana no Omuyahudi oómo omulozi, omubáasi we ebisuba, izíina lyoómwe Bar‑Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ogu akaba ali hamo no omwaanaángwa Serugio Paulo, ayaabeele ayina obwéenze. Omukúlu ogwo yaáyéta Barinaba na Sauli bamwiízeho, akaba naayeénda ahuliilize echigaambo cha Múungu kuluga hali boónyini. ");
INSERT INTO zin_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Náho, Bar‑Yeézu, omulozi (izíina lyoómwe omu Chiyunani ni Elima) akaba naagaámba amagaambo go kwáanga empola za Barinaba na Sauli, kunu naaleengesa kumusunika omwaanaángwa wi iziinga elyo ataákumwiikiliza Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Niho Sauli, óogwo káandi akaba ayétwa Paulo, káyaabeele yeézwiile obuhicha bwo Omwooyo Mutakatíifu, yaámutukuliza améeso Elima omulozi, naamugaámbila, ");
INSERT INTO zin_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Íiwe mwáana wi Isitáani! Íiwe oli omubisa wa byóona ebili bizima omu méeso ga Múungu! Oyizwiile obucheluke bwoónka, óoba noobeéha abáandi! Noozeendelela kuhabisa amagaambo ga mazima go Omukáma kuba ebisuba! ");
INSERT INTO zin_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Óobu, huliiliza! Omukáma yaágolola omukóno gwoómwe kukuchwaáziika, noóba omuhume, obutahicha kuhwéeza omusana gwi izóoba ha mwáanya.” Ahonyini, oluhwe lwaámuchíinga aha méeso, náwe yaaba omu nsiimbaazi atéena kuhwéeza. Yaábaanza kutuuyana no kuloondela omuuntu óogwo alaámukwáata omukóno abone kumweébeembelela. ");
INSERT INTO zin_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Omwaanaángwa ogwo káyaabweene ihano elyo, yaámwiikiliza Omukáma habwo kuba yaásobiilwe bwooli habwe ebyeégeso byo Omukáma éebyo akahulila. ");
INSERT INTO zin_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo na bazeenzíbe baalugáho aho Pafo. Baábuga baázeenda baágoba Perga omu chaalo cha Paamfilia. Yohana Mariko yaábaleka aho, yaásuba Yeruzaléemu. ");
INSERT INTO zin_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mala Paulo na Barinaba baalugáho Perga, baázeendelela no oluzeendo, baágoba Antiokia omu nsi ya Pisidia. Echilo che Endaálikizo, baátaaha omu isomelo lya Abayahudi, beékala. ");
INSERT INTO zin_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Obuchilo baámazile kusoma kuluga omu bilagilo bya Musa no omu bitabu bya ababáasi, abeémeelelezi bi isomelo elyo baásiindika omuuntu hali Paulo na Barinaba kubagaambila, “Abaiziraeli bazeenzi béetu, kamulaaba mwiina echigaambo cho kubagaambila abaantu kubagumya omuganya, muchigaámbe.” ");
INSERT INTO zin_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Aho Paulo, yeemucha omukóno nka nikwo bamuhuuliílize, yaágaamba, “Íimwe abakwaáta ba Iziraeli, neemwe Abanyamahaánga áabo mulikulamya Múungu, muumpuliilize! ");
INSERT INTO zin_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Múungu wa abaantu ba Iziraeli niwe akatooza besiichwe enkúlu. Omu mwáanya óogwo baabeele nibatuúla omu nsi ya Miísiri, akabakola kuba olugaanda luháango bwooli. Káyaabaliile yaábeebeembelela, omu kubasohoza omuli Miísiri ha buhicha bwoómwe bwo kusobeza, ");
INSERT INTO zin_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","yaábegumisiliza aha mwáanya gwe emyáaka makúmi aána omu nsi yo obwoóma. ");
INSERT INTO zin_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Káandi, yaásiingaalicha endími musaanzu omu nsi ya Kanáani, yaábaha baguúku béetu éensi éezo kuba obuhuunguzi bwáabo. ");
INSERT INTO zin_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ago góona gakakolwa omu mwáanya gwe emyáaka magana aána na makúmi ataanu zíti. “Káyaabaliile, Múungu yaábaha baguúku béetu abalamuzi be ebilagilo kubeébeembelela, kuhicha obuchilo bwo omubáasi Samweeli. ");
INSERT INTO zin_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Niho baásabile nka nikwo babe no omukáma. Múungu yaábaha Sauli, mutábani wa Kishi, wo lugaanda lwa Benyaámini, náwe yaaba omukáma wáabo ha myáaka makúmi aána. ");
INSERT INTO zin_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Obuchilo Múungu yaamwiihileho Sauli, yaámwiimeeleza Daudi kuba omukáma wáabo. Múungu akagaamba okwaátula buzima habwa Daudi, ‘Naámubona Daudi mutábani wa Yese, kuba omuuntu óogwo alikuunsemelela aha muganya, káandi niwe alaakola okweenda kwaanze kwóona.’ ");
INSERT INTO zin_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Kuluga ha luzaalólwe Daudi, Múungu yaábaleétela Abaiziraeli Omuchuúnguzi Yeézu, nka nikwo yaamweésagiize. ");
INSERT INTO zin_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Obuchilo Yeézu acháali atakabaandize emilimo yoómwe, Yohana akabasoomboolela Abaiziraeli bóona nkokwo nibeendelwa batamwe ebiheno byáabo no kumuhiindukila Múungu, no okubatizibwa. ");
INSERT INTO zin_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Obuchilo Yohana káyaabeele naamaliíliza emilimo yoómwe, akaba naagaámba, ‘Nimuzila íinye ndi oóha? Íinye tíwe ogwo weényini óogwo mulikuteékuza kuba niwe íinye! Muhuliilíze! Óogwo alikwíiza ha bwaánze, íinye tiinkwiílwe no óobu kukomoolola enkóba za amakuúbaasi goómwe.’” ");
INSERT INTO zin_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Paulo yaázeendelela kugaamba, “Badugu béetu, íimwe enzaalwa za Ibrahímu neemwe Abanyamahaánga áabo mulikumukoondookela Múungu, ha bwéetu empola ezo zo kuchuúnguka zisiindikilwe! ");
INSERT INTO zin_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kuba abaantu ba Yeruzaléemu na abakúlu báabo tibalamanyile nka nikwo Yeézu niwe Omuchuúnguzi, baámukola weényini achwaaziikwe. Aha kumukolela bátyo, bakahikiíliza amagaambo áago agaándikilwe habwa weényini omu bitabu bya ababáasi, na nigo áago baba nibagasoma buli chilo che Endaálikizo. ");
INSERT INTO zin_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Noobwo tibalabweene ne ensoonga yoóna yóona ya amazima yo kumulégelela ayitwe, baámusaba Pilato alagize kwíitwa. ");
INSERT INTO zin_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Obuchilo kábaamazile góona áago agaándikilwe habwa Yeézu, baámuhanaantula kuluga aha musalaba, baámuta omu mbi ye enyaanga. ");
INSERT INTO zin_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Náho Múungu yaámuzóola kuluga omu bafwiile. ");
INSERT INTO zin_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Náwe Yeézu, aha bilo bíinzi, yaábeesuululukiza abaantu abo abaakulaatileene náze kuluga Galiláaya kuhika Yeruzaléemu. Óobu, abo nibo baalubona boómwe ha baantu béetu. ");
INSERT INTO zin_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Íichwe nituboolekeelela Empola Nzima nka nikwo, ago gi Múungu yaábalagiile besiichwe enkúlu ");
INSERT INTO zin_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","yaágahikiiliza ahali íichwe, abáana báabo omu kumuzoola Yeézu. Nka nikwo chayaandikilwe omu Nzina ya kábili, ‘Íiwe níiwe Mutábani waanze, leélo íinye naaba Iíso.’ ");
INSERT INTO zin_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Káandi, Múungu akamuzoola Yeézu kuluga omu bafwiile kuba ataákuzuunda káandi. Habwe ebyo, Múungu akagaamba aáti, ‘Niimbáha emigisa emitakatíifu za amazima éezo nkamweésagiza Daudi.’ ");
INSERT INTO zin_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Bityo, echigaambo éecho chaandikilwe ahaantu aháandi, ‘Tokumuleka Omutakatíifu waawe abone kuzuunda.’” ");
INSERT INTO zin_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Paulo yaázeendelela kugaamba, “Obuchilo Daudi akahikiiliza góona áago Múungu yaámweendiize akole aha nzaalwa zo obuchilo bwoómwe, yaáfwa, yaáziikwa héehi na beeseénkulu, omubili gwoómwe gwaábona kuzuunda. ");
INSERT INTO zin_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Náho ogwo, óogwo Múungu akamuzoola, weényini talabweene kuzuunda. ");
INSERT INTO zin_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Ha bwéecho bazeenzi béetu, niinyeénda musoomboókelwe nka nikwo, aha kulabila ahali Yeézu heena okuganyilwa kwe ebiheno. ");
INSERT INTO zin_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kulabila hali weényini weénka, buli muuntu óogwo alikumwiíkiliza naabalwa kuba omugololoke omu méeso ga Múungu, echigaambo éecho echitakwiikilizana hali íimwe aha kukuláatila ebilagilo bya Musa. ");
INSERT INTO zin_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ha bwéecho mweémanye kuzima kuba mutaákwiiza mukakwáatwa na amagaambo áago agaándikilwe omu bitabu bya ababáasi, ");
INSERT INTO zin_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Íimwe abi igayo, muleebe! Musobelwe no okusiingaalika, habwo kuba omu bilo byáanyu niinkola echigaambo éecho timwaákuchiikiliza, nóobwo omuuntu yaakubasoomboólela echo chigaambo.’” ");
INSERT INTO zin_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Obuchilo Paulo na Barinaba bakaba nibasohola omu nzu yi isomelo lya Abayahudi, abaantu baábasaba basube aha chilo che Endaálikizo elikwiiza, babone kuzeendelela kugaamba habwa amagaambo ago. ");
INSERT INTO zin_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Obuchilo omukobo ogwo gwi isomelo kagwaahwéele, Abayahudi beenzi, hamo na Abanyamahaánga agáandi áabo abakeekiliza edíini ye Echiyahudi, bakabakulaatila Paulo na Barinaba. Bakaba nibahóoya hamo na abo beekiliza no kubagumya omuganya bazeendelele kulama omu mbabazi za Múungu. ");
INSERT INTO zin_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Echilo che Endaálikizo éezo eyakulaatíileho, lúundi buli muuntu kuluga omu iboma éelyo bakakóba kuhuliiliza echigaambo habwo Omukáma. ");
INSERT INTO zin_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nábo Abayahudi kábaabweene embága mpaango za abaantu, baaba ni ichubi bwooli. Niho baábaanza kumuhakanisa Paulo no kumuzuma habwe ebigaambo éebyo alikugaamba. ");
INSERT INTO zin_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","No óobu bityo, Paulo na Barinaba baábasúbiza Abayahudi abo aha kugima omu kugaamba, “Tukeendelwa twoolekeelele echigaambo cha Múungu kubaanza hali íimwe. Náho, habwo kuba mwaálamula kuchaanga, no kweébona timugasize obulame bwo obucha no obuchiile, muléebe! Nitubaleka, tuzeénde kwoólekeelela Abanyamahaánga. ");
INSERT INTO zin_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kuba nibyo Omukáma atulagíile aáti, ‘Naákutaho oóbe omwaanga aha Banyamahaánga, oóbe Omuchuúnguzi wa abaantu omu nsi yóona.’” ");
INSERT INTO zin_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Abo Abanyamahaánga, kábaahuliile echigaambo echo, baánulilwa, baaba nibachikuza echigaambo habwo Omukáma. Nábo bóona áabo bakaba baatóoziíbwe kuba no obulami obutahwaho, baámwiíkiliza Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Bityo echigaambo habwo Omukáma chiba chaásaambaala buli hóona omu chaalo echo. ");
INSERT INTO zin_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Náho Abayahudi bakabasunika abakázi bi isima áabo bakamulámya Múungu, na abakwaáta abakúlu bo omu iboma elyo. Abo baábeebeembelela abaantu kubaágalaza Paulo na Barinaba, nikwo baábabiinga kuluga omu chaalo cháabo. ");
INSERT INTO zin_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bityo Paulo na Barinaba baákuunkumula enkuungu kuluga amagulu gáabo ha kubáanga, baázeenda Ikonio. ");
INSERT INTO zin_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nábo abaheémba ba Yeézu okwo bakaba beézwiile amanulilwa bwooli, nibazeendelela omu kwiízula obuhicha bwo Omwooyo Mutakatíifu. ");
INSERT INTO zin_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Okwo Ikonio, Paulo na Barinaba baazámo hamo omu isomelo lya Abayahudi nko obuteéka bwáabo. Omwo baáyolekeelela ha buhicha buháango kuhicha Abayahudi beenzi beekiliza Yeézu, hamo na abaantu beenzi ba Abanyamahaánga. ");
INSERT INTO zin_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Náho Abayahudi áabo abakaanga kumwiíkiliza Yeézu, baábaanza kusunika emiganya yáabo Abanyamahaánga, babone kubatamwa abo abeekiliza bazeenzi béetu. ");
INSERT INTO zin_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ha bwéecho Paulo na Barinaba baázeendelela kwiikala ebilo bíinzi aho Ikonio, nibabagaambila abaantu aha kugima echigaambo cho Omukáma Yeézu. Omukáma náwe yaaba naamanyisa echo chigaambo choómwe che embabazi omu kubahikiiliza kukola emanyiso na amahano. ");
INSERT INTO zin_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Náho, abaantu bo omuli elyo iboma baba baátaaganamo embága ibili. Omuli áabo bakaba nibakuundilana na Abayahudi, abáandi olubazu lwe entumwa. ");
INSERT INTO zin_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Omuli abo Bayahudi na Abanyamahaánga, hamo na abatégeki báabo, baázila omuzeenzo gwo kubeéfoolela kubi Paulo na Barinaba no kubahoonda na amabáale. ");
INSERT INTO zin_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Náho obuchilo entumwa baabweene empola ezi, beélukila Likaonia, omu chaalo cha Lisitira na Derbe ne engeégeelo ye ebyaalo ebiheleleene ne ezo. ");
INSERT INTO zin_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","No okwo baaba niboolekeelela abaantu Empola Nzima za Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Omuli Lisitira, akaba alimo omuuntu óogwo akaba ali enziíngami bulugiilila kuzáalwa kwoómwe, na takahichaga kulibata. ");
INSERT INTO zin_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Obuchilo Paulo akaba naayolekeelela, ogwo muuntu náwe akaba ayikeele aho naamuhuliiliza. Paulo yaámuleeba omu méeso aha kumukomela, yaásoombookelwa nka nikwo ayina okwiikiliza kwo kuchizwa. ");
INSERT INTO zin_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nikwo Paulo yaámugaambila ahi iláka liháango, “Yimuka! Oyimeelele lwa amagulu gaawe.” Ahonyini ogwo muuntu yaáguluka, yaáyemeelela lwa amagulúge, yaábaanza kulibata libata aho weénka! ");
INSERT INTO zin_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Echipípi cha abaantu echo káchabwéene amaleeba áago yaákozile Paulo, baábaanza kuhamuka omu lulími lwáabo lwe Chilikaonia omu kugaamba, “Bamúungu baátúuka hali íichwe omu nsuso ya abaantu!” ");
INSERT INTO zin_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Baámuluka Barinaba izíina lya múungu wáabo oómo alikwéetwa Zeu. Na Paulo, baámwéeta izíina lya múungu wáabo oóndi alikwéetwa Herme, habwo kuba Paulo niwe akaba ali omugaambi mukúlu. ");
INSERT INTO zin_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ahéelu kache yo omu iboma elyo, hakaba heena éenzu ya múungu Zeu. Omugabe we éenzu ezo yaáleeta echimasa che ente no omukáko gwe enyaso aha lwiizi lwi iboma. Weényini hamo ne ebipípi ebyo bya abaantu bakaba nibeénda kubataámbila. ");
INSERT INTO zin_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Náho entumwa Paulo na Barinaba kábaabihuliile ebyo bigaambo, baálaansamula ebizwáalo byáabo, baáhulumuka bwaangu omugati ye ebipípi ebyo, kunu nibahamuka ahi iláka liháango, ");
INSERT INTO zin_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Íimwe baantu! Ha bwaáchi nimukola amagaambo aga? Neechwe tuli abaantu kwoónka nkeemwe! Tuli aha kuboólekeelela Empola Nzima nka nikwo, muléke kulámya ebiintu bitéena mugaso, mumuhiindukile Múungu owo obulami! Weényini niwe ayaahaangile igulu, ne éensi, ne enziba, na byóona ebilimo. ");
INSERT INTO zin_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Obuchilo bwe enzáalwa za kala ezaahiíngwiile, Múungu akabeékililiza Abanyamahaánga bóona batuúle no kukola óokwo balikweéhulila. ");
INSERT INTO zin_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","No óobu bityo, talalekiile kweésoomboola. Habwo kuba íimwe akabakolela amazima. Weényini abaleetela enzula kuluga omu igulu no kubaboneseza omwéezo aha mwáanya gwaágwo, náwe abahaagisa ebyookulya aha manulilwa omu myóoyo yáanyu.” ");
INSERT INTO zin_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Noobwo Paulo na Barinaba bakagaamba amagaambo ago, chikaba chigumile kubaángila abaantu be ebipiipi ebyo bataákubatáambila. ");
INSERT INTO zin_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Niho beeza Abayahudi abáandi kuluga Antiokia, no kuluga Ikonio. Baábakoonza koonza abaantu bo okwo Lisitira, kuhicha baaba no obúmo, baámuhoónda Paulo na amabáale. Baámukululila ahéelu yi iboma nibamanya nka nikwo yaáfwa. ");
INSERT INTO zin_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Náho abaheémba kábaabeele baákoba no kumuzoóngoloka, yeémuka, yaásuba omu iboma. Nyeéncha eémo, yaalugaho aho, yaázeenda hamo na Barinaba omu chaalo cha Derbe. ");
INSERT INTO zin_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Okwo Derbe baáyolekeelela abaantu Empola Nzima ya Yeézu no kubakoonza koonza béenzi omuli abo kuhicha kuba abaheémba. Kábaabalíile baásuba omu kulabila omu maboma ga Lisitira, Ikonio, na Antiokia. ");
INSERT INTO zin_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Omu byaalo ebyo, bakagumisa abaheémba no kubatiimbya bazeendelele kuguma omu kwiikiliza kwáabo. Bakaba nibabagaambila, “Omu kutaaha omu bukáma bwa Múungu, tichikwiíle otalabile omu byaágalazo bíinzi.” ");
INSERT INTO zin_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Omuli buli kelezia, Paulo na Barinaba baábatoóleza abáandi omuli abo beekiliza kuba abanyaampala. Baázila echisiibo no kubasabila omu kubahikiiliza omu ngalo zo Omukáma, óogwo bakaba baamwiíkilize. ");
INSERT INTO zin_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Paulo na Barinaba baálabila éensi ya Pisidia, baataahamo omu chaalo cha Paamfilia, ");
INSERT INTO zin_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","baáhika Perga. Okwo bakoolekeelela empola habwa Yeézu, niho baágolomoka omuli Atalia. ");
INSERT INTO zin_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Buluga aho babuga no obwáato bwi itaanga, baásuba Antiokia omu nsi ya Siíria. Aho niho obwa mbele bakaba basabiílwe babe aheéfo ye embabazi ya Múungu ha milimo éezo bakaba baámazile omu luzeendo lwáabo. ");
INSERT INTO zin_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Obuchilo baáhikile káandi aho Antiokia, bakazeeta ekelezia. Baábasoomboolela góona áago Múungu yaákozile kulabila hali boónyini, na nka nikwo óokwo yaábachiínguliile Abanyamahaánga olwiizi lwo kwiikiliza Yeézu. ");
INSERT INTO zin_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Beékala ha mwáanya mula aho Antiokia hamo na abaheémba abo. ");
INSERT INTO zin_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Abaantu bunaanka bakaluga Yudea, baágolomoka aho omu muzihwa gwa Antiokia kuluga Yudea. Baábaanza kweégesa abeekiliza bazeenzi béetu omu kugaamba, “Kamulaaba mutasázilwe amakóba kwiingana ne entúungwa éezo twaáleekiilwe na Musa, timukuhicha kuchuúnguka.” ");
INSERT INTO zin_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Echo chigaambo chaaleetelela Paulo na Barinaba nábo kuhakana bwooli na abo baantu. Omuhélo, ekelezia ya aho Antiokia yaálamula nkokwo Paulo na Barinaba hamo na abeekiliza abáandi omuli abo bazeénde hamo Yeruzaléemu, babone kubugana okwo ne ntumwa za Yeézu na aha banyaampala be ekelezia aha mpola ye echigaambo echo. ");
INSERT INTO zin_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ekelezia yaábasiíndika kuzeenda. Paulo na abo bazeenzíbe, baálabila omu nsi ya Foonike, no omuli Samaria, baaba nibabasoomboólela abaantu óokwo Abanyamahaánga bamwiikilize Yeézu. Empola ezo zaábasemelela bwóoli abeekiliza bóona bazeenzi béetu. ");
INSERT INTO zin_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kabaahikile Yeruzaléemu, baáyanaankulwa kuzima ne ekelezia yo okwo, hamo ne entumwa za Yeézu, na abanyaampala. Baábaha empola za byóona éebyo Múungu yaákozile kulabila hali boónyini. ");
INSERT INTO zin_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Náho abeekiliza bunaanka be embága ya Abafarisayo baáyemeelela, baágaamba, “Abanyamahaánga nábo bahatikwe kusálwa amakóba, na balagilwe kukoondoókela ebilagilo byóona bya Musa.” ");
INSERT INTO zin_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ha bwéecho, entumwa za Yeézu na abo abanyaampala be ekelezia baákoba hamo babone kweéhanuuza kuzima echo chigaambo. ");
INSERT INTO zin_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kábaabeele baámazile omwáanya mula omu kweéhanuuza, Peétero yaáyemeelela, yaábagaambila, “Íimwe badugu béetu, nimumanya nkokwo bulugiilila kala Múungu akaantooza íinye kubaátulila Abanyamahaánga babone kuhulila no kwiikiliza echigaambo che Empola Nzima. ");
INSERT INTO zin_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Náwe Múungu niwe alikumanya emiganya ya abaantu, akabaátulila nka nikwo naabeekiliza omu kubaha Omwooyo Mutakatíifu nko óokwo yaátuhéele íichwe. ");
INSERT INTO zin_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ha bwéecho tiheenaho obuchilanisi óobwo Múungu yaákozile hali íichwe na boónyini, habwo kuba na boónyini ha muháanda ogwo nyini gwo kwiikiliza akabéeza emiganya yáabo. ");
INSERT INTO zin_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mbwéenu, ha bwaáchi nimumuleengesa Múungu ha kubatwéeka omugaámba omu bicha bya abaheémba, óogwo besiichwe enkúlu gukabalema, neechwe nyini nigutulema kugusutula? ");
INSERT INTO zin_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mmahi! Íichwe nitwiikiliza nka nikwo nituchuungulwa habwe embabazi zo Omukáma Yeézu, nka boónyini okwo balikuchuúngulwaho.” ");
INSERT INTO zin_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Aho embága yóona yeésiza chee! Baaba abo kumuhuliliiza Barinaba na Paulo nibabasoomboólela nka nikwo emanyiso na amahano go okusobeza áago Múungu yaákozile omuli abo Banyamahaánga ha kulabila hali boónyini. ");
INSERT INTO zin_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Obuchilo kabamazile kusoomboola, Yakobo náwe yaágaamba aáti, “Íimwe beekiliza bazeenzi béetu, muunhuliilize! ");
INSERT INTO zin_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni yaátusoombooliile nkokwo Múungu ha kubaanza akabeékomya Abanyamahaánga aha kutóoza abaantu kuluga omuli abo habwi izíina lyoómwe. ");
INSERT INTO zin_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Echigaambo éechi nichiikililizana hamo na Amagaambo ga ababáasi nko óokwo gaáyaandikilwe, ");
INSERT INTO zin_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Aha muheleeluko gwe ebigaambo ebi, ndyaásuba, neenye ndyaázoombeka káandi éenzu ya Daudi eyaagwíile. Niinyoombeka káandi amatoongo goómwe no okugasemeza, ");
INSERT INTO zin_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","kuba abaantu abáandi babone kumuloondela Omukáma Múungu, no óobu abo Abanyamahaánga, bóona abalikwéetwa ahi izíina lyaanze, naagaámba Omukáma Múungu’ alikukola byóona ebi, ");
INSERT INTO zin_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ebyaasoomboókile bulugiilila kala.” ");
INSERT INTO zin_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobo yaázeendelela kugaamba, “Ha bwéecho okulamula kwaanze ni kuti, tutaákubaagalaza Abanyamahaánga abalikumuhiindukila Múungu. ");
INSERT INTO zin_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Náho nitweendélwa tubaandikile olwaandiko lwo kubagaambila nkokwo beélige ne enyama esohweezwe aha mazimu, emize mibi yo obusaambani, kulya enyama ze ebituungaánwa ebihotweelwe, no okunywa obwáamba. ");
INSERT INTO zin_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kuba buluga kala, ebilagilo bya Musa bibeéle nibyoolekeelelwa omuli buli muzihwa, no kusomwa omu masomelo ga Abayahudi buli chilo che Endaálikizo.” ");
INSERT INTO zin_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Aho ezo ntumwa za Yeézu na áabo abanyaampala, hamo ne ekelezia yóona yo okwo Yeruzaléemu baálamula nkokwo batoóze abáandi omuli abo abalaazeénda hamo na Paulo na Barinaba okwo Antiokia. Bityo omuli abo beekiliza bazeenzi béetu, baátóoza abeébeembezi bábili, oómo ni Yuda ayaabeele ayétwa Barsaba, no oóndi ni Sila. Abo baásiindikwa kuzeenda no olwaandiko olulikugaamba luti, ");
INSERT INTO zin_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","“Íichwe entumwa hamo na abanyaampala, abadugu bazeenzi beenyu ba Yeézu, nitubaangalucha íimwe abeekiliza bazeenzi béetu Abanyamahaánga abali Antiokia, no omu nsi ya Siíria, no omu chaalo cha Kilikia. ");
INSERT INTO zin_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tuhuliile nkokwo abaantu bunaanka abalugile owéetu bakabagaambila ebigaambo byo kubahabisa, no kubaágalaza emiganya yáanyu. Íichwe titulabasiíndikile. ");
INSERT INTO zin_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ha bwéecho, tweekililizana nkokwo tutoóze abakwaáta no kubasiíndika hali íimwe, beéze hamo ne engaanzi zéetu Barinaba na Paulo. ");
INSERT INTO zin_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Abaantu aba bali omu buhuta bwo obulame bwáabo habwi izíina lyo Omukáma wéetu Yeézu Kristu. ");
INSERT INTO zin_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ha bwéecho abo twaábasiíndika hali íimwe, Yuda na Sila, boónyini aba nibabamanyisa aha munwa gwáabo ebigaambo éebyo twaáyaandika. ");
INSERT INTO zin_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kuba byaámunulila Omwooyo Mutakatíifu neechwe tweekiliza tutaákubatweeka omugugu gwoóna gwóona kusaaga amagaambo aga. ");
INSERT INTO zin_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mweélige ne enyama esohweezwe aha mazimu, kunywa obwáamba, kulya enyama ze ebituungaánwa ebihotweelwe, no kukola obusiihani. Kamuleeliga ne ebyo, nimuba mwaákola kuzima. Mube no obuhóolo.” ");
INSERT INTO zin_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kábaabeele baálagilwe, baágolomoka kuzeenda Antiokia. Baábakobya kobya abeekiliza, baábaha olwo lwaandiko. ");
INSERT INTO zin_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Abeekiliza abo kábaalusomile, lwaábagumya emiganya, baánulilwa. ");
INSERT INTO zin_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nábo Yuda na Sila, abo abaabeele bali ababáasi, baábagaambila abo beekiliza bazeenzi báabo ebigaambo bíinzi byo kubagumya emiganya, no kubakola bagume. ");
INSERT INTO zin_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kábaabeele beékeele okwo ha mwáanya, abo beekiliza bazeenzi béetu baábakuúndila nkokwo basube okwo hali abo abaabasiíndikile, baábalaga aha buhóolo.  ");
INSERT INTO zin_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Náho Sila weényini yaábona nkokwo ni kuzima asigaleyo okwo. ");
INSERT INTO zin_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo na Barinaba nábo bakasigala okwo Antiokia, nibeegesa no kwoólekeelela echigaambo habwo Omukáma, hamo na abaantu abáandi beenzi. ");
INSERT INTO zin_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kábyaahiíngwiile ebilo, Paulo yaágaambila Barinaba aáti, “Tusube aha beekiliza bazeenzi béetu omuli buli iboma éelyo twaáyegesize echigaambo habwo Omukáma, tubone kubayeélela no kuleeba nka nikwo balikuzeendelela.” ");
INSERT INTO zin_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Omu luzeendo olwo, Barinaba akeenda bamutwaale Yohana ayaabeele ayétwa Mariko azeénde hamo nábo. ");
INSERT INTO zin_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Náho Paulo yaábona nkokwo ti kuzima Mariko azeénde hamo nábo, habwo kuba akabaleka okwo Paamfilia, na talazeendeliile kukola nábo emilimo. ");
INSERT INTO zin_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Echo chaaleetelela boónyini okuhakana kuháango no obutahuliilizana, kuhicha baálekaana. Barinaba yaámutwáala Mariko, baázeenda hamo omu bwáato bwi itaanga kuhicha baáhika omu iziinga lya Kipro. ");
INSERT INTO zin_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo náwe yaátooza Sila. Na abo beekiliza bazeenzi béetu baábasabila embabazi zo Omukáma, niho Paulo na Sila baázeenda. ");
INSERT INTO zin_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Baálabila omu nsi ya Siíria na Kilikia, nibagagumisa amakelezia. ");
INSERT INTO zin_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo akahika Derbe, na Lisitira. Okwo hakaba heena omuheémba wa Yeézu, izíina lyoómwe ni Timoteo. Nyina, akaba ali omukázi we Echiyahudi ayaamwiíkiliize Yeézu. Náho iíse akaba ali Omuyunani. ");
INSERT INTO zin_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timoteo akaba ayina okukuzwa kuzima omu beekiliza bazeenzi béetu abo okwo Lisitira na Ikonio. ");
INSERT INTO zin_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo yaáyeenda nkokwo Timoteo azeénde náze omu luzeendo. Ha bwéecho, yaámusala ikóba Timoteo abone kukuúndilwa na Abayahudi bóona bo okwo. Kuba Abayahudi abo bakaba nibamanya nkokwo iíse Timoteo akaba ali Omuyunani. ");
INSERT INTO zin_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ahakulaatiilého Paulo na abo bazeenzíbe baázeenda nibalabila omu maboma go okwo. Baaba nibabamanyisa abeekiliza ba Abanyamahaánga ebyo bilagilo ebyaatiilwého ne entumwa za Yeézu hamo na abanyaampala bo okwo Yeruzaléemu, nábo babone kubikoondoókela ebyo bilagilo. ");
INSERT INTO zin_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ha bwéecho ekelezia zo okwo zaázeendelela kukomeela omu kwiikiliza. No kupeetwa kwa abeekiliza kukaba nikweeyoongela buli chilo. ");
INSERT INTO zin_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo na bazeenzíbe abo baálaba omuli Furigia no omuli Galatia. Bakakola bátyo habwo kuba bakaba baáyaángiizwe no Omwooyo Mutakatíifu nkokwo bataákwiiza kwoólekeelela echigaambo cha Múungu omuli Asia. ");
INSERT INTO zin_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kábaahikile aha lubíbi lwo kutaaha omuli Misia, baáleengesa kutaaha omuli Bithinia, náho Omwooyo gwa Yeézu tigulabeekililiize. ");
INSERT INTO zin_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ha bwéecho, baálabila omuli Misia, baázeenda Turoa. ");
INSERT INTO zin_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Omu chilo Paulo yaábona ameezaho. Omu meezaho goómwe, akabona omuli Makedonia omuuntu oómo wa Makedonia ayemeeliile, naamusaba bwóoli Paulo, naagaámba, “Oyaambuke kunu, oyize Makedonia, otuhwéele.” ");
INSERT INTO zin_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Káyaabeele Paulo yaáleebile ago meezaho, ahonyini tweéloonza kuzeenda okwo Makedonia. Tukabona nkokwo Múungu yaátweeta kumanyisa Empola Nzima ha baantu bo okwo. ");
INSERT INTO zin_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ha bwéecho twaalugáho aho Turoa no obwáato bwi itaanga, twaázeenda omuháanda gúmo kuhika omu iziinga lya Samotirake. Nyeéncha eémo twaázeenda, twaáhika omu muzihwa gwa Neapoli. ");
INSERT INTO zin_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kuluga aho, twaázeenda kuhika Filipi, nilyo iboma liháango omuli Makedonia, na nilyo iboma lya Abarúumi bakaba nibatuúla. Neechwe tweékala aho ebilo bíche. ");
INSERT INTO zin_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Omu chilo che Endaálikizo twaázeenda ahéelu yo ogwo muzihwa, héehi no omunóna, habwo kuba tukaba nituteekuza nkokwo niho twaakaásaangile abaantu nibamusaba Múungu. Kátwaahikile aho, tukasaanga bakobile abakázi, neechwe tweékala no kuhooya hamo nábo. ");
INSERT INTO zin_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Omuli abo abaabeele nibatuhuliiliza, akaba aliho omukázi oómo wo omu iboma lya Thiatira, izíina lyoómwe ni Lidia. Ogu Lidia akaba ali omusúluza we ebizwáalo bye ezaambalau, náwe akaba amulámya Múungu. Paulo káyaabamanyisize Empola Nzima, Omukáma yaáchiingula omwooyo gwa Lidia abone kweétegeeleza amazima ge empola zo mwa Paulo. ");
INSERT INTO zin_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Káyaabeele yaábatiizwe hamo na abaantu be éenzu yoómwe, akatusaba naagaámba, “Kamulaaba mwaálamula no kubona nkokwo neenye ndi omwiikiliza wo Omukáma, mwiikale hali íinye.” Yaátuneémbelela kuhicha twaákúunda kwiikala ha woómwe. ");
INSERT INTO zin_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Echilo chimo, obuchilo tukaba nituzeénda ahaantu ho kumusaba Múungu, tweésulukizwa no omuhalákazi oómo ali omuzaánakazi. Ogwo muzaánakazi akaba ayina izimu libi elyaabeele nilimuha obuhicha bwo kulagula amagaambo go obuchilo obulikwiiza. Ha muháanda ogwo bakamábe bakaba nibabonesa empilya nyíinzi. ");
INSERT INTO zin_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ogwo muhalákazi yaaba naakulaatila Paulo neechwe, naateéla eyoombo omu kugaamba, “Aba baantu na abazáana ba Múungu, Óogwo Ali Olugulu ya Byóona. Aba baliho kubamanyisa omuháanda gwo kuchuúnguka.” ");
INSERT INTO zin_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Yaámala ebilo bíinzi ali omu kukola aátyo. Omuhélo, Paulo yaásaaya. Yaálihiindukila elyo izimu libi, yaáligaambila, “Niinkulagila ahi izíina lya Yeézu Kristu, omulugého omuhalákazi ogu!” Omwáanya ogwo nyini elyo izimu libi lyaamulugáho. ");
INSERT INTO zin_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Abo abakáma bo ogwo muhalákazi, kábaabweene nkokwo tihaliho itegezo káandi lyo kubonesa amabonwa, baábatabaalila Paulo na Sila, baábakulula kuhika omu igulizo omu méeso ga abatégeki. ");
INSERT INTO zin_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Baábatwáala aha balamuzi bakúlu, baábagaambila, “Aba bakwaáta na Abayahudi, nibaleetelela elyo iboma lyéetu libe no omusaambo bwóoli. ");
INSERT INTO zin_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nábo nibatulaánga kukulaatila obuteéka bwo owaabo óobwo íichwe Abarúumi no omuzilo kubwiíkiliza, nali kubukulaatila.” ");
INSERT INTO zin_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mále abaantu abaabeele bakobile echipípi áaho beékililizana no kulégelelwa okwo kwa Paulo na Sila. Abo balamuzi bakúlu baábazúula Paulo na Sila ebizwáalo byáabo, baálagila nkokwo bateélwe ensáanzu. ");
INSERT INTO zin_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kábaamazile kubatéela bwooli, baábanaguza omu ibóhelo. Abo balamuzi bakúlu baámukomeenteleza omwiímeelelezi nkokwo abeékomye kuzima. ");
INSERT INTO zin_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ha bwéecho omwiímeelelezi ogwo yaábataasha omu chiseenge cho omugati, yaábakoma amagulu gáabo ahagáti ya mabago ge miti. ");
INSERT INTO zin_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Káhaabeele itúumbi, Paulo na Sila bakaba nibamusaba Múungu, no kumuzinila enzina zo kumukúza. Embóhe bazeenzi báabo bakaba nibabahuliiliza. ");
INSERT INTO zin_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bwaangu ahonyini, enyahíinga mpaango bwóoli yaáhiingula omu nsi, yaáchuundagula oluhazo lwe elyo ibóhelo. Mala emilyaango yóona yaaba yaáchiinguka yoónka, ne eminyololyo ye embóhe zóona éeba yaákomooloka. ");
INSERT INTO zin_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ogwo mwiímeelelezi wi ibóhelo elyo yeémuka. Káyaabweene nkokwo emilyaango echiingwiíle, yaálusopoololayo olubaadi lwoómwe ali bweémi kweéyita. Ha kuba akaba naateekuza nkokwo ezo mbóhe zóona zaányooloombokile. ");
INSERT INTO zin_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Náho Paulo yaáteela eyoombo naamugaámbila, “Óteéyita! Chwéena tulimo óomu!” ");
INSERT INTO zin_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Aho ogwo mwiímeelelezi yaálagila ebimuli bileétwe, yeelukila omu nzu ezo, yáagwa omu méeso ga Paulo na Sila naazuguma aha butíini. ");
INSERT INTO zin_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Niho yaábatwáala ahéelu, yaábabúuza, “Íimwe bakáma baanze, ni lwaampaka íinye nkole chiíha mbone kuchuúnguka?” ");
INSERT INTO zin_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Baámusubiza, “Mwiikilize Omukáma Yeézu, niho olaachuúnguka, íiwe hamo na abaantu abali omu nzu yaawe.” ");
INSERT INTO zin_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Aho Paulo na Sila baámweégesa ogwo mwiímeelelezi echigaambo habwo Omukáma, hamo na abaantu bóona abaabeele bali omu nzu yoómwe. ");
INSERT INTO zin_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Esáaha ezo nyini yo omu chilo